/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 *  under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
*/
/*
 * Copyright(c) 1998 Sun Microsystems, Inc.
 * All rights reserved.
 */


#ifndef _UTF_CNS_H_
#define _UTF_CNS_H_

#include <public_struc.h>

/* maxium mapping number from UTF8 to CNS11643 */
#define MAX_UTF_NUM		17715

/* unicode (UTF8) to CNS 11643 mapping table
 * (some characters are missing;
 * includes plane 1/2/14, i.e. cnscode begins with 21/22/2e;
 * supports CNS11643-86 only, CNS11643-92 not yet supported)
 */
table_t utf_cns_tab[MAX_UTF_NUM] = {
	{ 0x00a2, 0x212266 },
	{ 0x00a3, 0x212267 },
	{ 0x00a5, 0x212264 },
	{ 0x00a7, 0x212170 },
	{ 0x00b0, 0x212278 },
	{ 0x00b1, 0x212234 },
	{ 0x00b7, 0x212126 },
	{ 0x00d7, 0x212232 },
	{ 0x00f7, 0x212233 },
	{ 0x02c7, 0x21256f },
	{ 0x02c9, 0x21256d },
	{ 0x02ca, 0x21256e },
	{ 0x02cb, 0x212570 },
	{ 0x02d9, 0x21256c },
	{ 0x0391, 0x212475 },
	{ 0x0392, 0x212476 },
	{ 0x0393, 0x212477 },
	{ 0x0394, 0x212478 },
	{ 0x0395, 0x212479 },
	{ 0x0396, 0x21247a },
	{ 0x0397, 0x21247b },
	{ 0x0398, 0x21247c },
	{ 0x0399, 0x21247d },
	{ 0x039a, 0x21247e },
	{ 0x039b, 0x212521 },
	{ 0x039c, 0x212522 },
	{ 0x039d, 0x212523 },
	{ 0x039e, 0x212524 },
	{ 0x039f, 0x212525 },
	{ 0x03a0, 0x212526 },
	{ 0x03a1, 0x212527 },
	{ 0x03a3, 0x212528 },
	{ 0x03a4, 0x212529 },
	{ 0x03a5, 0x21252a },
	{ 0x03a6, 0x21252b },
	{ 0x03a7, 0x21252c },
	{ 0x03a8, 0x21252d },
	{ 0x03a9, 0x21252e },
	{ 0x03b1, 0x21252f },
	{ 0x03b2, 0x212530 },
	{ 0x03b3, 0x212531 },
	{ 0x03b4, 0x212532 },
	{ 0x03b5, 0x212533 },
	{ 0x03b6, 0x212534 },
	{ 0x03b7, 0x212535 },
	{ 0x03b8, 0x212536 },
	{ 0x03b9, 0x212537 },
	{ 0x03ba, 0x212538 },
	{ 0x03bb, 0x212539 },
	{ 0x03bc, 0x21253a },
	{ 0x03bd, 0x21253b },
	{ 0x03be, 0x21253c },
	{ 0x03bf, 0x21253d },
	{ 0x03c0, 0x21253e },
	{ 0x03c1, 0x21253f },
	{ 0x03c3, 0x212540 },
	{ 0x03c4, 0x212541 },
	{ 0x03c5, 0x212542 },
	{ 0x03c6, 0x212543 },
	{ 0x03c7, 0x212544 },
	{ 0x03c8, 0x212545 },
	{ 0x03c9, 0x212546 },
	{ 0x2013, 0x212139 },
	{ 0x2014, 0x212137 },
	{ 0x2016, 0x21225d },
	{ 0x2017, 0x212226 },
	{ 0x2018, 0x212164 },
	{ 0x2019, 0x212165 },
	{ 0x201c, 0x212166 },
	{ 0x201d, 0x212167 },
	{ 0x2025, 0x21212d },
	{ 0x2026, 0x21212c },
	{ 0x203b, 0x21216f },
	{ 0x203e, 0x212223 },
	{ 0x203f, 0x212224 },
	{ 0x2103, 0x21226a },
	{ 0x2105, 0x212222 },
	{ 0x2109, 0x21226b },
	{ 0x2160, 0x21242b },
	{ 0x2161, 0x21242c },
	{ 0x2162, 0x21242d },
	{ 0x2163, 0x21242e },
	{ 0x2164, 0x21242f },
	{ 0x2165, 0x212430 },
	{ 0x2166, 0x212431 },
	{ 0x2167, 0x212432 },
	{ 0x2168, 0x212433 },
	{ 0x2169, 0x212434 },
	{ 0x2170, 0x212635 },
	{ 0x2171, 0x212636 },
	{ 0x2172, 0x212637 },
	{ 0x2173, 0x212638 },
	{ 0x2174, 0x212639 },
	{ 0x2175, 0x21263a },
	{ 0x2176, 0x21263b },
	{ 0x2177, 0x21263c },
	{ 0x2178, 0x21263d },
	{ 0x2179, 0x21263e },
	{ 0x2190, 0x212258 },
	{ 0x2191, 0x212255 },
	{ 0x2192, 0x212257 },
	{ 0x2193, 0x212256 },
	{ 0x2196, 0x212259 },
	{ 0x2197, 0x21225a },
	{ 0x2198, 0x21225c },
	{ 0x2199, 0x21225b },
	{ 0x221a, 0x212235 },
	{ 0x221e, 0x21223c },
	{ 0x221f, 0x212249 },
	{ 0x2220, 0x212248 },
	{ 0x2229, 0x212245 },
	{ 0x222a, 0x212246 },
	{ 0x222b, 0x21224d },
	{ 0x222e, 0x21224e },
	{ 0x2234, 0x212250 },
	{ 0x2235, 0x21224f },
	{ 0x223c, 0x212244 },
	{ 0x2252, 0x21223d },
	{ 0x2260, 0x21223b },
	{ 0x2261, 0x21223e },
	{ 0x2264, 0x212239 },
	{ 0x2265, 0x21223a },
	{ 0x22a5, 0x212247 },
	{ 0x22bf, 0x21224a },
	{ 0x2400, 0x214221 },
	{ 0x2401, 0x214222 },
	{ 0x2402, 0x214223 },
	{ 0x2403, 0x214224 },
	{ 0x2404, 0x214225 },
	{ 0x2405, 0x214226 },
	{ 0x2406, 0x214227 },
	{ 0x2407, 0x214228 },
	{ 0x2408, 0x214229 },
	{ 0x2409, 0x21422a },
	{ 0x240a, 0x21422b },
	{ 0x240b, 0x21422c },
	{ 0x240c, 0x21422d },
	{ 0x240d, 0x21422e },
	{ 0x240e, 0x21422f },
	{ 0x240f, 0x214230 },
	{ 0x2410, 0x214231 },
	{ 0x2411, 0x214232 },
	{ 0x2412, 0x214233 },
	{ 0x2413, 0x214234 },
	{ 0x2414, 0x214235 },
	{ 0x2415, 0x214236 },
	{ 0x2416, 0x214237 },
	{ 0x2417, 0x214238 },
	{ 0x2418, 0x214239 },
	{ 0x2419, 0x21423a },
	{ 0x241a, 0x21423b },
	{ 0x241b, 0x21423c },
	{ 0x241c, 0x21423d },
	{ 0x241d, 0x21423e },
	{ 0x241e, 0x21423f },
	{ 0x241f, 0x214240 },
	{ 0x2421, 0x214241 },
	{ 0x2460, 0x212621 },
	{ 0x2461, 0x212622 },
	{ 0x2462, 0x212623 },
	{ 0x2463, 0x212624 },
	{ 0x2464, 0x212625 },
	{ 0x2465, 0x212626 },
	{ 0x2466, 0x212627 },
	{ 0x2467, 0x212628 },
	{ 0x2468, 0x212629 },
	{ 0x2469, 0x21262a },
	{ 0x2474, 0x21262b },
	{ 0x2475, 0x21262c },
	{ 0x2476, 0x21262d },
	{ 0x2477, 0x21262e },
	{ 0x2478, 0x21262f },
	{ 0x2479, 0x212630 },
	{ 0x247a, 0x212631 },
	{ 0x247b, 0x212632 },
	{ 0x247c, 0x212633 },
	{ 0x247d, 0x212634 },
	{ 0x2500, 0x212339 },
	{ 0x2502, 0x21233a },
	{ 0x250c, 0x21233c },
	{ 0x2510, 0x21233d },
	{ 0x2514, 0x21233e },
	{ 0x2518, 0x21233f },
	{ 0x251c, 0x212337 },
	{ 0x2524, 0x212336 },
	{ 0x252c, 0x212335 },
	{ 0x2534, 0x212334 },
	{ 0x253c, 0x212333 },
	{ 0x2550, 0x212344 },
	{ 0x255e, 0x212345 },
	{ 0x2561, 0x212347 },
	{ 0x256a, 0x212346 },
	{ 0x256d, 0x212340 },
	{ 0x256e, 0x212341 },
	{ 0x256f, 0x212343 },
	{ 0x2570, 0x212342 },
	{ 0x2571, 0x21234c },
	{ 0x2572, 0x21234d },
	{ 0x2573, 0x21234e },
	{ 0x2581, 0x212324 },
	{ 0x2582, 0x212325 },
	{ 0x2583, 0x212326 },
	{ 0x2584, 0x212327 },
	{ 0x2585, 0x212328 },
	{ 0x2586, 0x212329 },
	{ 0x2587, 0x21232a },
	{ 0x2588, 0x21232b },
	{ 0x2589, 0x212332 },
	{ 0x258a, 0x212331 },
	{ 0x258b, 0x212330 },
	{ 0x258c, 0x21232f },
	{ 0x258d, 0x21232e },
	{ 0x258e, 0x21232d },
	{ 0x258f, 0x21232c },
	{ 0x2594, 0x212338 },
	{ 0x2595, 0x21233b },
	{ 0x25a0, 0x21217c },
	{ 0x25a1, 0x21217b },
	{ 0x25b2, 0x212175 },
	{ 0x25b3, 0x212174 },
	{ 0x25bc, 0x21217e },
	{ 0x25bd, 0x21217d },
	{ 0x25c6, 0x21217a },
	{ 0x25c7, 0x212179 },
	{ 0x25cb, 0x212172 },
	{ 0x25ce, 0x212176 },
	{ 0x25cf, 0x212173 },
	{ 0x25e2, 0x212348 },
	{ 0x25e3, 0x212349 },
	{ 0x25e4, 0x21234b },
	{ 0x25e5, 0x21234a },
	{ 0x2605, 0x212178 },
	{ 0x2606, 0x212177 },
	{ 0x2609, 0x212254 },
	{ 0x2640, 0x212251 },
	{ 0x2641, 0x212253 },
	{ 0x2642, 0x212252 },
	{ 0x3000, 0x212121 },
	{ 0x3001, 0x212123 },
	{ 0x3002, 0x212124 },
	{ 0x3003, 0x212171 },
	{ 0x3008, 0x212152 },
	{ 0x3009, 0x212153 },
	{ 0x300a, 0x21214e },
	{ 0x300b, 0x21214f },
	{ 0x300c, 0x212156 },
	{ 0x300d, 0x212157 },
	{ 0x300e, 0x21215a },
	{ 0x300f, 0x21215b },
	{ 0x3010, 0x21214a },
	{ 0x3011, 0x21214b },
	{ 0x3012, 0x212265 },
	{ 0x3014, 0x212146 },
	{ 0x3015, 0x212147 },
	{ 0x301d, 0x212168 },
	{ 0x301e, 0x212169 },
	{ 0x3021, 0x212435 },
	{ 0x3022, 0x212436 },
	{ 0x3023, 0x212437 },
	{ 0x3024, 0x212438 },
	{ 0x3025, 0x212439 },
	{ 0x3026, 0x21243a },
	{ 0x3027, 0x21243b },
	{ 0x3028, 0x21243c },
	{ 0x3029, 0x21243d },
	{ 0x303a, 0x21216a },
	{ 0x303b, 0x21216b },
	{ 0x303c, 0x21243e },
	{ 0x303d, 0x21243f },
	{ 0x303e, 0x212440 },
	{ 0x3105, 0x212547 },
	{ 0x3106, 0x212548 },
	{ 0x3107, 0x212549 },
	{ 0x3108, 0x21254a },
	{ 0x3109, 0x21254b },
	{ 0x310a, 0x21254c },
	{ 0x310b, 0x21254d },
	{ 0x310c, 0x21254e },
	{ 0x310d, 0x21254f },
	{ 0x310e, 0x212550 },
	{ 0x310f, 0x212551 },
	{ 0x3110, 0x212552 },
	{ 0x3111, 0x212553 },
	{ 0x3112, 0x212554 },
	{ 0x3113, 0x212555 },
	{ 0x3114, 0x212556 },
	{ 0x3115, 0x212557 },
	{ 0x3116, 0x212558 },
	{ 0x3117, 0x212559 },
	{ 0x3118, 0x21255a },
	{ 0x3119, 0x21255b },
	{ 0x311a, 0x21255c },
	{ 0x311b, 0x21255d },
	{ 0x311c, 0x21255e },
	{ 0x311d, 0x21255f },
	{ 0x311e, 0x212560 },
	{ 0x311f, 0x212561 },
	{ 0x3120, 0x212562 },
	{ 0x3121, 0x212563 },
	{ 0x3122, 0x212564 },
	{ 0x3123, 0x212565 },
	{ 0x3124, 0x212566 },
	{ 0x3125, 0x212567 },
	{ 0x3126, 0x212568 },
	{ 0x3127, 0x212569 },
	{ 0x3128, 0x21256a },
	{ 0x3129, 0x21256b },
	{ 0x32a3, 0x212221 },
	{ 0x338e, 0x212275 },
	{ 0x338f, 0x212276 },
	{ 0x339c, 0x212270 },
	{ 0x339d, 0x212271 },
	{ 0x339e, 0x212272 },
	{ 0x33a1, 0x212274 },
	{ 0x33c4, 0x212277 },
	{ 0x33ce, 0x212273 },
	{ 0x33d1, 0x21224c },
	{ 0x33d2, 0x21224b },
	{ 0x33d5, 0x21226f },
	{ 0x4e00, 0x214421 },
	{ 0x4e01, 0x214423 },
	{ 0x4e03, 0x214424 },
	{ 0x4e04, 0x232126 },
	{ 0x4e05, 0x232125 },
	{ 0x4e07, 0x222126 },
	{ 0x4e08, 0x214437 },
	{ 0x4e09, 0x214435 },
	{ 0x4e0a, 0x214438 },
	{ 0x4e0b, 0x214436 },
	{ 0x4e0c, 0x222127 },
	{ 0x4e0d, 0x214462 },
	{ 0x4e0e, 0x22212f },
	{ 0x4e0f, 0x22212d },
	{ 0x4e10, 0x214461 },
	{ 0x4e11, 0x214460 },
	{ 0x4e14, 0x214562 },
	{ 0x4e15, 0x214561 },
	{ 0x4e16, 0x214560 },
	{ 0x4e18, 0x214563 },
	{ 0x4e19, 0x21455f },
	{ 0x4e1e, 0x214722 },
	{ 0x4e1f, 0x214723 },
	{ 0x4e20, 0x232262 },
	{ 0x4e21, 0x232261 },
	{ 0x4e22, 0x232263 },
	{ 0x4e24, 0x23243f },
	{ 0x4e26, 0x214b64 },
	{ 0x4e28, 0x232121 },
	{ 0x4e2a, 0x23212c },
	{ 0x4e2b, 0x214439 },
	{ 0x4e2d, 0x214463 },
	{ 0x4e2e, 0x222130 },
	{ 0x4e30, 0x214464 },
	{ 0x4e31, 0x222143 },
	{ 0x4e32, 0x21486b },
	{ 0x4e33, 0x222531 },
	{ 0x4e36, 0x232122 },
	{ 0x4e38, 0x21443a },
	{ 0x4e39, 0x214465 },
	{ 0x4e3b, 0x214564 },
	{ 0x4e3c, 0x222144 },
	{ 0x4e3d, 0x232740 },
	{ 0x4e3f, 0x232123 },
	{ 0x4e42, 0x222121 },
	{ 0x4e43, 0x214425 },
	{ 0x4e45, 0x21443c },
	{ 0x4e46, 0x232130 },
	{ 0x4e47, 0x222128 },
	{ 0x4e48, 0x21443d },
	{ 0x4e49, 0x23212e },
	{ 0x4e4b, 0x214466 },
	{ 0x4e4d, 0x214565 },
	{ 0x4e4e, 0x214567 },
	{ 0x4e4f, 0x214566 },
	{ 0x4e52, 0x214724 },
	{ 0x4e53, 0x214725 },
	{ 0x4e54, 0x232345 },
	{ 0x4e56, 0x214b65 },
	{ 0x4e57, 0x232b22 },
	{ 0x4e58, 0x21537d },
	{ 0x4e59, 0x214422 },
	{ 0x4e5c, 0x222122 },
	{ 0x4e5d, 0x214426 },
	{ 0x4e5e, 0x21443f },
	{ 0x4e5f, 0x21443e },
	{ 0x4e62, 0x232146 },
	{ 0x4e63, 0x232145 },
	{ 0x4e68, 0x232264 },
	{ 0x4e69, 0x214726 },
	{ 0x4e71, 0x232440 },
	{ 0x4e73, 0x214b66 },
	{ 0x4e79, 0x232b23 },
	{ 0x4e7e, 0x215871 },
	{ 0x4e7f, 0x22334e },
	{ 0x4e80, 0x23396c },
	{ 0x4e81, 0x23396e },
	{ 0x4e82, 0x21632a },
	{ 0x4e83, 0x224156 },
	{ 0x4e84, 0x224157 },
	{ 0x4e85, 0x232124 },
	{ 0x4e86, 0x214427 },
	{ 0x4e87, 0x23212d },
	{ 0x4e88, 0x214468 },
	{ 0x4e89, 0x232265 },
	{ 0x4e8b, 0x214b67 },
	{ 0x4e8c, 0x214428 },
	{ 0x4e8d, 0x222129 },
	{ 0x4e8e, 0x214440 },
	{ 0x4e8f, 0x232131 },
	{ 0x4e91, 0x214469 },
	{ 0x4e92, 0x21446b },
	{ 0x4e93, 0x222131 },
	{ 0x4e94, 0x21446c },
	{ 0x4e95, 0x21446a },
	{ 0x4e97, 0x23216c },
	{ 0x4e98, 0x232266 },
	{ 0x4e99, 0x214727 },
	{ 0x4e9b, 0x214b68 },
	{ 0x4e9c, 0x232442 },
	{ 0x4e9d, 0x232742 },
	{ 0x4e9e, 0x214b69 },
	{ 0x4e9f, 0x214f67 },
	{ 0x4ea1, 0x214441 },
	{ 0x4ea2, 0x21446d },
	{ 0x4ea3, 0x232147 },
	{ 0x4ea4, 0x214728 },
	{ 0x4ea5, 0x21472a },
	{ 0x4ea6, 0x214729 },
	{ 0x4ea8, 0x21486c },
	{ 0x4eab, 0x214b6a },
	{ 0x4eac, 0x214b6b },
	{ 0x4ead, 0x214f68 },
	{ 0x4eae, 0x214f69 },
	{ 0x4eaf, 0x232b26 },
	{ 0x4eb0, 0x232b25 },
	{ 0x4eb1, 0x232b27 },
	{ 0x4eb2, 0x232b24 },
	{ 0x4eb3, 0x21537e },
	{ 0x4eb6, 0x224158 },
	{ 0x4eb7, 0x234033 },
	{ 0x4eb9, 0x226d44 },
	{ 0x4eba, 0x214429 },
	{ 0x4ebc, 0x232132 },
	{ 0x4ebe, 0x232133 },
	{ 0x4ec0, 0x21446f },
	{ 0x4ec1, 0x21446e },
	{ 0x4ec2, 0x222132 },
	{ 0x4ec3, 0x214470 },
	{ 0x4ec4, 0x214476 },
	{ 0x4ec5, 0x232149 },
	{ 0x4ec6, 0x214471 },
	{ 0x4ec7, 0x214472 },
	{ 0x4ec8, 0x222134 },
	{ 0x4ec9, 0x222133 },
	{ 0x4eca, 0x214474 },
	{ 0x4ecb, 0x214475 },
	{ 0x4ecc, 0x23214c },
	{ 0x4ecd, 0x214473 },
	{ 0x4ece, 0x23214b },
	{ 0x4ecf, 0x23214a },
	{ 0x4ed4, 0x21456a },
	{ 0x4ed5, 0x21456b },
	{ 0x4ed6, 0x21456c },
	{ 0x4ed7, 0x21456d },
	{ 0x4ed8, 0x214569 },
	{ 0x4ed9, 0x214570 },
	{ 0x4eda, 0x22214a },
	{ 0x4edc, 0x222146 },
	{ 0x4edd, 0x222149 },
	{ 0x4ede, 0x214571 },
	{ 0x4edf, 0x214623 },
	{ 0x4ee0, 0x23216d },
	{ 0x4ee1, 0x222148 },
	{ 0x4ee3, 0x21456e },
	{ 0x4ee4, 0x21456f },
	{ 0x4ee5, 0x214568 },
	{ 0x4ee6, 0x232172 },
	{ 0x4ee7, 0x232170 },
	{ 0x4ee8, 0x222145 },
	{ 0x4ee9, 0x222147 },
	{ 0x4eee, 0x23226f },
	{ 0x4eef, 0x232268 },
	{ 0x4ef0, 0x214737 },
	{ 0x4ef1, 0x22216f },
	{ 0x4ef2, 0x214734 },
	{ 0x4ef3, 0x214738 },
	{ 0x4ef4, 0x222179 },
	{ 0x4ef5, 0x22216d },
	{ 0x4ef6, 0x214735 },
	{ 0x4ef7, 0x222171 },
	{ 0x4ef8, 0x23226b },
	{ 0x4ef9, 0x232267 },
	{ 0x4efa, 0x232276 },
	{ 0x4efb, 0x214736 },
	{ 0x4efc, 0x23226e },
	{ 0x4efd, 0x214739 },
	{ 0x4eff, 0x21472b },
	{ 0x4f00, 0x222170 },
	{ 0x4f01, 0x21473a },
	{ 0x4f02, 0x222174 },
	{ 0x4f03, 0x23226d },
	{ 0x4f04, 0x222178 },
	{ 0x4f05, 0x222175 },
	{ 0x4f06, 0x23226c },
	{ 0x4f07, 0x232274 },
	{ 0x4f08, 0x222172 },
	{ 0x4f09, 0x21472c },
	{ 0x4f0a, 0x21472e },
	{ 0x4f0b, 0x21473b },
	{ 0x4f0d, 0x214730 },
	{ 0x4f0e, 0x22216a },
	{ 0x4f0f, 0x214733 },
	{ 0x4f10, 0x214731 },
	{ 0x4f11, 0x214732 },
	{ 0x4f12, 0x22217a },
	{ 0x4f13, 0x222177 },
	{ 0x4f14, 0x22216e },
	{ 0x4f15, 0x21472f },
	{ 0x4f16, 0x232270 },
	{ 0x4f17, 0x232277 },
	{ 0x4f18, 0x22216b },
	{ 0x4f19, 0x21472d },
	{ 0x4f1a, 0x232275 },
	{ 0x4f1c, 0x232273 },
	{ 0x4f1d, 0x222173 },
	{ 0x4f22, 0x222176 },
	{ 0x4f28, 0x232272 },
	{ 0x4f2c, 0x22216c },
	{ 0x4f2d, 0x222328 },
	{ 0x4f2f, 0x214924 },
	{ 0x4f30, 0x214875 },
	{ 0x4f31, 0x232450 },
	{ 0x4f32, 0x232448 },
	{ 0x4f33, 0x222329 },
	{ 0x4f34, 0x214872 },
	{ 0x4f35, 0x23244f },
	{ 0x4f36, 0x214926 },
	{ 0x4f37, 0x232446 },
	{ 0x4f38, 0x21487a },
	{ 0x4f39, 0x232445 },
	{ 0x4f3a, 0x214879 },
	{ 0x4f3b, 0x22227b },
	{ 0x4f3c, 0x21487d },
	{ 0x4f3d, 0x214878 },
	{ 0x4f3e, 0x222322 },
	{ 0x4f3f, 0x22232a },
	{ 0x4f40, 0x23244e },
	{ 0x4f41, 0x222326 },
	{ 0x4f42, 0x232449 },
	{ 0x4f43, 0x21487b },
	{ 0x4f44, 0x23244b },
	{ 0x4f45, 0x232443 },
	{ 0x4f46, 0x21487e },
	{ 0x4f47, 0x21486f },
	{ 0x4f48, 0x214929 },
	{ 0x4f49, 0x22227d },
	{ 0x4f4a, 0x232444 },
	{ 0x4f4b, 0x23244c },
	{ 0x4f4c, 0x22253d },
	{ 0x4f4d, 0x21486d },
	{ 0x4f4e, 0x214925 },
	{ 0x4f4f, 0x21486e },
	{ 0x4f50, 0x214876 },
	{ 0x4f51, 0x214877 },
	{ 0x4f52, 0x222324 },
	{ 0x4f53, 0x22227e },
	{ 0x4f54, 0x21487c },
	{ 0x4f55, 0x214874 },
	{ 0x4f56, 0x22227a },
	{ 0x4f57, 0x214870 },
	{ 0x4f58, 0x222327 },
	{ 0x4f59, 0x214927 },
	{ 0x4f5a, 0x21492a },
	{ 0x4f5b, 0x214873 },
	{ 0x4f5c, 0x214922 },
	{ 0x4f5d, 0x214928 },
	{ 0x4f5e, 0x214871 },
	{ 0x4f5f, 0x222325 },
	{ 0x4f60, 0x214923 },
	{ 0x4f61, 0x22232b },
	{ 0x4f62, 0x22227c },
	{ 0x4f63, 0x214921 },
	{ 0x4f64, 0x222321 },
	{ 0x4f66, 0x236448 },
	{ 0x4f67, 0x222323 },
	{ 0x4f68, 0x236449 },
	{ 0x4f69, 0x214b79 },
	{ 0x4f6a, 0x22253f },
	{ 0x4f6b, 0x22254b },
	{ 0x4f6c, 0x214b71 },
	{ 0x4f6d, 0x232747 },
	{ 0x4f6e, 0x22254c },
	{ 0x4f6f, 0x214b6c },
	{ 0x4f70, 0x214b76 },
	{ 0x4f72, 0x23274f },
	{ 0x4f73, 0x214b6f },
	{ 0x4f74, 0x222539 },
	{ 0x4f75, 0x214b77 },
	{ 0x4f76, 0x222538 },
	{ 0x4f77, 0x22253c },
	{ 0x4f78, 0x222543 },
	{ 0x4f79, 0x222541 },
	{ 0x4f7a, 0x214c21 },
	{ 0x4f7b, 0x214b7a },
	{ 0x4f7c, 0x222533 },
	{ 0x4f7d, 0x222535 },
	{ 0x4f7e, 0x214b7c },
	{ 0x4f7f, 0x214b70 },
	{ 0x4f80, 0x222536 },
	{ 0x4f81, 0x222542 },
	{ 0x4f82, 0x222549 },
	{ 0x4f83, 0x214b75 },
	{ 0x4f84, 0x22253b },
	{ 0x4f85, 0x222534 },
	{ 0x4f86, 0x214b74 },
	{ 0x4f87, 0x222537 },
	{ 0x4f88, 0x214b78 },
	{ 0x4f89, 0x22253a },
	{ 0x4f8a, 0x232744 },
	{ 0x4f8b, 0x214b73 },
	{ 0x4f8c, 0x232751 },
	{ 0x4f8d, 0x214b6e },
	{ 0x4f8e, 0x232748 },
	{ 0x4f8f, 0x214b7d },
	{ 0x4f90, 0x222544 },
	{ 0x4f91, 0x214b7e },
	{ 0x4f92, 0x222548 },
	{ 0x4f93, 0x232743 },
	{ 0x4f94, 0x222546 },
	{ 0x4f95, 0x22254a },
	{ 0x4f96, 0x214b7b },
	{ 0x4f97, 0x22253e },
	{ 0x4f98, 0x222532 },
	{ 0x4f9a, 0x222540 },
	{ 0x4f9b, 0x214b72 },
	{ 0x4f9c, 0x222545 },
	{ 0x4f9d, 0x214b6d },
	{ 0x4f9e, 0x222547 },
	{ 0x4f9f, 0x23274c },
	{ 0x4fa0, 0x232749 },
	{ 0x4fa1, 0x23274b },
	{ 0x4fa2, 0x23274a },
	{ 0x4fa3, 0x23274d },
	{ 0x4fae, 0x214f78 },
	{ 0x4faf, 0x214f6c },
	{ 0x4fb0, 0x232b2d },
	{ 0x4fb1, 0x232b2e },
	{ 0x4fb2, 0x222922 },
	{ 0x4fb3, 0x22292a },
	{ 0x4fb4, 0x232b36 },
	{ 0x4fb5, 0x214f6b },
	{ 0x4fb6, 0x214f73 },
	{ 0x4fb7, 0x215021 },
	{ 0x4fb8, 0x232b2c },
	{ 0x4fb9, 0x222930 },
	{ 0x4fba, 0x22292e },
	{ 0x4fbb, 0x222929 },
	{ 0x4fbd, 0x236263 },
	{ 0x4fbe, 0x232b2b },
	{ 0x4fbf, 0x214f6d },
	{ 0x4fc0, 0x22292f },
	{ 0x4fc1, 0x222925 },
	{ 0x4fc2, 0x214f7b },
	{ 0x4fc3, 0x214f72 },
	{ 0x4fc4, 0x214f7a },
	{ 0x4fc5, 0x22287e },
	{ 0x4fc6, 0x232b32 },
	{ 0x4fc7, 0x22292c },
	{ 0x4fc8, 0x232b2f },
	{ 0x4fc9, 0x222923 },
	{ 0x4fca, 0x214f76 },
	{ 0x4fcb, 0x222924 },
	{ 0x4fcc, 0x232b33 },
	{ 0x4fcd, 0x22287d },
	{ 0x4fce, 0x214f7d },
	{ 0x4fcf, 0x214f70 },
	{ 0x4fd0, 0x214f79 },
	{ 0x4fd1, 0x214f6f },
	{ 0x4fd2, 0x232b28 },
	{ 0x4fd3, 0x222921 },
	{ 0x4fd4, 0x222926 },
	{ 0x4fd5, 0x232b29 },
	{ 0x4fd6, 0x22292d },
	{ 0x4fd7, 0x214f77 },
	{ 0x4fd8, 0x214f74 },
	{ 0x4fd9, 0x222928 },
	{ 0x4fda, 0x214f7c },
	{ 0x4fdb, 0x22292b },
	{ 0x4fdc, 0x222927 },
	{ 0x4fdd, 0x214f71 },
	{ 0x4fde, 0x214f7e },
	{ 0x4fdf, 0x214f75 },
	{ 0x4fe0, 0x214f6e },
	{ 0x4fe1, 0x214f6a },
	{ 0x4fe3, 0x232b35 },
	{ 0x4fe5, 0x232b34 },
	{ 0x4fe7, 0x23644a },
	{ 0x4fec, 0x222931 },
	{ 0x4fee, 0x21543a },
	{ 0x4fef, 0x215424 },
	{ 0x4ff0, 0x232f48 },
	{ 0x4ff1, 0x215434 },
	{ 0x4ff2, 0x232f4d },
	{ 0x4ff3, 0x215439 },
	{ 0x4ff4, 0x222d71 },
	{ 0x4ff5, 0x222d70 },
	{ 0x4ff6, 0x222d75 },
	{ 0x4ff7, 0x222d76 },
	{ 0x4ff8, 0x215427 },
	{ 0x4ff9, 0x232f44 },
	{ 0x4ffa, 0x215430 },
	{ 0x4ffb, 0x232f58 },
	{ 0x4ffc, 0x232f4c },
	{ 0x4ffd, 0x232f56 },
	{ 0x4ffe, 0x21543d },
	{ 0x4fff, 0x232f46 },
	{ 0x5000, 0x215431 },
	{ 0x5002, 0x232f4b },
	{ 0x5003, 0x232f49 },
	{ 0x5004, 0x232f47 },
	{ 0x5005, 0x222d6a },
	{ 0x5006, 0x21542a },
	{ 0x5007, 0x222d6b },
	{ 0x5008, 0x232f4f },
	{ 0x5009, 0x21543f },
	{ 0x500b, 0x215436 },
	{ 0x500c, 0x215421 },
	{ 0x500d, 0x215422 },
	{ 0x500e, 0x222d7e },
	{ 0x500f, 0x215924 },
	{ 0x5010, 0x232f53 },
	{ 0x5011, 0x21542f },
	{ 0x5012, 0x21542e },
	{ 0x5013, 0x222d6c },
	{ 0x5014, 0x215432 },
	{ 0x5015, 0x22335e },
	{ 0x5016, 0x215429 },
	{ 0x5017, 0x222d77 },
	{ 0x5018, 0x215438 },
	{ 0x5019, 0x215437 },
	{ 0x501a, 0x21542d },
	{ 0x501b, 0x222d6f },
	{ 0x501c, 0x222d78 },
	{ 0x501d, 0x232f45 },
	{ 0x501e, 0x222d69 },
	{ 0x501f, 0x21542c },
	{ 0x5020, 0x222d79 },
	{ 0x5021, 0x215435 },
	{ 0x5022, 0x222d6d },
	{ 0x5023, 0x215423 },
	{ 0x5024, 0x232f4e },
	{ 0x5025, 0x215426 },
	{ 0x5026, 0x215425 },
	{ 0x5027, 0x222d7a },
	{ 0x5028, 0x215433 },
	{ 0x5029, 0x215428 },
	{ 0x502a, 0x21543c },
	{ 0x502b, 0x21543e },
	{ 0x502c, 0x222d74 },
	{ 0x502d, 0x21543b },
	{ 0x502e, 0x232f51 },
	{ 0x502f, 0x222d7c },
	{ 0x5030, 0x222d6e },
	{ 0x5031, 0x222d7d },
	{ 0x5032, 0x232f43 },
	{ 0x5033, 0x222d72 },
	{ 0x5035, 0x222d7b },
	{ 0x5036, 0x232f50 },
	{ 0x5037, 0x222d73 },
	{ 0x5038, 0x232f54 },
	{ 0x5039, 0x232f55 },
	{ 0x503c, 0x21542b },
	{ 0x503f, 0x23644b },
	{ 0x5040, 0x223366 },
	{ 0x5041, 0x22335a },
	{ 0x5042, 0x23343c },
	{ 0x5043, 0x215876 },
	{ 0x5044, 0x23343f },
	{ 0x5045, 0x22335f },
	{ 0x5046, 0x223365 },
	{ 0x5047, 0x215875 },
	{ 0x5048, 0x223358 },
	{ 0x5049, 0x215879 },
	{ 0x504a, 0x22335c },
	{ 0x504b, 0x223355 },
	{ 0x504c, 0x215877 },
	{ 0x504d, 0x223359 },
	{ 0x504e, 0x21587c },
	{ 0x504f, 0x215923 },
	{ 0x5050, 0x233444 },
	{ 0x5051, 0x22336a },
	{ 0x5052, 0x233441 },
	{ 0x5053, 0x223354 },
	{ 0x5054, 0x233442 },
	{ 0x5055, 0x21587d },
	{ 0x5056, 0x232f57 },
	{ 0x5057, 0x223369 },
	{ 0x5058, 0x233447 },
	{ 0x5059, 0x23343d },
	{ 0x505a, 0x215878 },
	{ 0x505b, 0x22335b },
	{ 0x505c, 0x215874 },
	{ 0x505d, 0x223356 },
	{ 0x505e, 0x223352 },
	{ 0x505f, 0x223360 },
	{ 0x5060, 0x223353 },
	{ 0x5061, 0x223351 },
	{ 0x5062, 0x22335d },
	{ 0x5063, 0x223363 },
	{ 0x5064, 0x223364 },
	{ 0x5065, 0x21587a },
	{ 0x5066, 0x233440 },
	{ 0x5068, 0x223a3f },
	{ 0x5069, 0x223361 },
	{ 0x506a, 0x223350 },
	{ 0x506b, 0x223362 },
	{ 0x506c, 0x23344b },
	{ 0x506d, 0x215926 },
	{ 0x506e, 0x223367 },
	{ 0x506f, 0x215925 },
	{ 0x5070, 0x22334f },
	{ 0x5071, 0x233443 },
	{ 0x5072, 0x223357 },
	{ 0x5073, 0x223368 },
	{ 0x5074, 0x215921 },
	{ 0x5075, 0x21587e },
	{ 0x5076, 0x21587b },
	{ 0x5077, 0x215922 },
	{ 0x5078, 0x23344c },
	{ 0x5079, 0x23344a },
	{ 0x507a, 0x215872 },
	{ 0x507b, 0x233445 },
	{ 0x507c, 0x233446 },
	{ 0x507d, 0x215873 },
	{ 0x5080, 0x215e2e },
	{ 0x5081, 0x233975 },
	{ 0x5082, 0x223a42 },
	{ 0x5083, 0x223a3b },
	{ 0x5085, 0x215e2b },
	{ 0x5087, 0x223a43 },
	{ 0x5088, 0x233971 },
	{ 0x5089, 0x233972 },
	{ 0x508b, 0x223a39 },
	{ 0x508c, 0x223a3c },
	{ 0x508d, 0x215e2a },
	{ 0x508e, 0x223a3d },
	{ 0x508f, 0x23396f },
	{ 0x5091, 0x215e2d },
	{ 0x5092, 0x223a41 },
	{ 0x5094, 0x223a37 },
	{ 0x5095, 0x223a36 },
	{ 0x5096, 0x215e2f },
	{ 0x5097, 0x233970 },
	{ 0x5098, 0x215e30 },
	{ 0x5099, 0x215e2c },
	{ 0x509a, 0x215e31 },
	{ 0x509b, 0x223a35 },
	{ 0x509c, 0x223a40 },
	{ 0x509d, 0x223a3e },
	{ 0x509e, 0x223a38 },
	{ 0x50a2, 0x215e29 },
	{ 0x50a3, 0x223a3a },
	{ 0x50a6, 0x23644d },
	{ 0x50aa, 0x234039 },
	{ 0x50ab, 0x23403c },
	{ 0x50ac, 0x216331 },
	{ 0x50ad, 0x21632b },
	{ 0x50ae, 0x22415c },
	{ 0x50af, 0x216334 },
	{ 0x50b0, 0x224162 },
	{ 0x50b1, 0x224165 },
	{ 0x50b2, 0x21632d },
	{ 0x50b3, 0x21632e },
	{ 0x50b4, 0x22415f },
	{ 0x50b5, 0x21632c },
	{ 0x50b6, 0x224168 },
	{ 0x50b7, 0x216332 },
	{ 0x50b8, 0x224169 },
	{ 0x50b9, 0x23403a },
	{ 0x50ba, 0x224164 },
	{ 0x50bb, 0x216333 },
	{ 0x50bc, 0x234037 },
	{ 0x50bd, 0x224159 },
	{ 0x50be, 0x216330 },
	{ 0x50bf, 0x22415a },
	{ 0x50c1, 0x224163 },
	{ 0x50c2, 0x224161 },
	{ 0x50c3, 0x23403d },
	{ 0x50c4, 0x22415d },
	{ 0x50c5, 0x21632f },
	{ 0x50c6, 0x22415b },
	{ 0x50c7, 0x216335 },
	{ 0x50c8, 0x224160 },
	{ 0x50c9, 0x224167 },
	{ 0x50ca, 0x22415e },
	{ 0x50cb, 0x224166 },
	{ 0x50cc, 0x234036 },
	{ 0x50cd, 0x23403e },
	{ 0x50ce, 0x21677c },
	{ 0x50cf, 0x216779 },
	{ 0x50d0, 0x23456b },
	{ 0x50d1, 0x21677a },
	{ 0x50d2, 0x23634c },
	{ 0x50d3, 0x224921 },
	{ 0x50d4, 0x224877 },
	{ 0x50d5, 0x216778 },
	{ 0x50d6, 0x216775 },
	{ 0x50d7, 0x224878 },
	{ 0x50d8, 0x23456e },
	{ 0x50d9, 0x23456c },
	{ 0x50da, 0x216777 },
	{ 0x50db, 0x22487b },
	{ 0x50dc, 0x23456d },
	{ 0x50dd, 0x22487d },
	{ 0x50de, 0x234576 },
	{ 0x50df, 0x23634d },
	{ 0x50e0, 0x224926 },
	{ 0x50e1, 0x234570 },
	{ 0x50e2, 0x234575 },
	{ 0x50e3, 0x224925 },
	{ 0x50e4, 0x22487e },
	{ 0x50e5, 0x216774 },
	{ 0x50e6, 0x224876 },
	{ 0x50e7, 0x216772 },
	{ 0x50e8, 0x224879 },
	{ 0x50e9, 0x21677d },
	{ 0x50ea, 0x22487c },
	{ 0x50eb, 0x234571 },
	{ 0x50ec, 0x224922 },
	{ 0x50ed, 0x216776 },
	{ 0x50ee, 0x216773 },
	{ 0x50ef, 0x224924 },
	{ 0x50f0, 0x224923 },
	{ 0x50f1, 0x21677b },
	{ 0x50f3, 0x22487a },
	{ 0x50f4, 0x234574 },
	{ 0x50f5, 0x216c23 },
	{ 0x50f6, 0x224f54 },
	{ 0x50f7, 0x234b29 },
	{ 0x50f8, 0x224f51 },
	{ 0x50f9, 0x216c24 },
	{ 0x50fb, 0x216c22 },
	{ 0x50fc, 0x234b2b },
	{ 0x50fd, 0x224f58 },
	{ 0x50fe, 0x224f55 },
	{ 0x50ff, 0x224f4e },
	{ 0x5100, 0x216c21 },
	{ 0x5101, 0x234b2d },
	{ 0x5102, 0x216c25 },
	{ 0x5103, 0x224f4f },
	{ 0x5104, 0x216b7e },
	{ 0x5105, 0x216c28 },
	{ 0x5106, 0x224f52 },
	{ 0x5107, 0x224f53 },
	{ 0x5108, 0x216c26 },
	{ 0x5109, 0x216c27 },
	{ 0x510a, 0x224f59 },
	{ 0x510b, 0x224f56 },
	{ 0x510c, 0x224f57 },
	{ 0x510d, 0x234b2c },
	{ 0x510e, 0x234b27 },
	{ 0x510f, 0x23644e },
	{ 0x5110, 0x217033 },
	{ 0x5111, 0x225643 },
	{ 0x5112, 0x217030 },
	{ 0x5113, 0x225640 },
	{ 0x5114, 0x217032 },
	{ 0x5115, 0x217034 },
	{ 0x5116, 0x235031 },
	{ 0x5117, 0x225641 },
	{ 0x5118, 0x217031 },
	{ 0x511a, 0x225642 },
	{ 0x511b, 0x235035 },
	{ 0x511c, 0x22563f },
	{ 0x511d, 0x235030 },
	{ 0x511e, 0x235034 },
	{ 0x511f, 0x217341 },
	{ 0x5120, 0x225c49 },
	{ 0x5121, 0x217342 },
	{ 0x5122, 0x225c47 },
	{ 0x5124, 0x225c48 },
	{ 0x5125, 0x225c46 },
	{ 0x5126, 0x225c45 },
	{ 0x5127, 0x235441 },
	{ 0x5128, 0x235440 },
	{ 0x5129, 0x225c4a },
	{ 0x512a, 0x217340 },
	{ 0x512b, 0x235033 },
	{ 0x512d, 0x226144 },
	{ 0x512e, 0x226145 },
	{ 0x512f, 0x235752 },
	{ 0x5130, 0x224f50 },
	{ 0x5131, 0x226143 },
	{ 0x5132, 0x217343 },
	{ 0x5133, 0x21782b },
	{ 0x5134, 0x226537 },
	{ 0x5135, 0x226538 },
	{ 0x5136, 0x235c32 },
	{ 0x5137, 0x217a62 },
	{ 0x5138, 0x217a63 },
	{ 0x5139, 0x226b4f },
	{ 0x513a, 0x226b4e },
	{ 0x513b, 0x217b58 },
	{ 0x513c, 0x217b57 },
	{ 0x513d, 0x226e7d },
	{ 0x513e, 0x23606f },
	{ 0x513f, 0x21442a },
	{ 0x5140, 0x214442 },
	{ 0x5141, 0x214478 },
	{ 0x5143, 0x214477 },
	{ 0x5144, 0x214573 },
	{ 0x5145, 0x214572 },
	{ 0x5146, 0x21473e },
	{ 0x5147, 0x21473d },
	{ 0x5148, 0x21473f },
	{ 0x5149, 0x21473c },
	{ 0x514a, 0x232278 },
	{ 0x514b, 0x21492c },
	{ 0x514c, 0x21492b },
	{ 0x514d, 0x21492d },
	{ 0x514e, 0x232454 },
	{ 0x5150, 0x232453 },
	{ 0x5151, 0x232451 },
	{ 0x5152, 0x214c23 },
	{ 0x5154, 0x214c22 },
	{ 0x5155, 0x214c24 },
	{ 0x5156, 0x232752 },
	{ 0x5157, 0x215022 },
	{ 0x5159, 0x212279 },
	{ 0x515a, 0x222e21 },
	{ 0x515b, 0x21227a },
	{ 0x515c, 0x215927 },
	{ 0x515d, 0x21227c },
	{ 0x515e, 0x21227b },
	{ 0x515f, 0x223a44 },
	{ 0x5160, 0x233976 },
	{ 0x5161, 0x21227d },
	{ 0x5162, 0x21677e },
	{ 0x5163, 0x21227e },
	{ 0x5164, 0x235e25 },
	{ 0x5165, 0x21442b },
	{ 0x5166, 0x232134 },
	{ 0x5167, 0x214479 },
	{ 0x5168, 0x214740 },
	{ 0x5169, 0x214c25 },
	{ 0x516a, 0x232b37 },
	{ 0x516b, 0x21442c },
	{ 0x516c, 0x21447c },
	{ 0x516d, 0x21447a },
	{ 0x516e, 0x21447b },
	{ 0x5171, 0x214741 },
	{ 0x5172, 0x23227a },
	{ 0x5175, 0x21492e },
	{ 0x5176, 0x214c27 },
	{ 0x5177, 0x214c26 },
	{ 0x5178, 0x214c28 },
	{ 0x5179, 0x232e7b },
	{ 0x517c, 0x215440 },
	{ 0x517e, 0x23403f },
	{ 0x517f, 0x236453 },
	{ 0x5180, 0x217035 },
	{ 0x5182, 0x232127 },
	{ 0x5184, 0x23214d },
	{ 0x5185, 0x232148 },
	{ 0x5186, 0x23214e },
	{ 0x5187, 0x22212e },
	{ 0x5189, 0x214574 },
	{ 0x518a, 0x214575 },
	{ 0x518b, 0x232178 },
	{ 0x518c, 0x232179 },
	{ 0x518d, 0x214742 },
	{ 0x518f, 0x22232c },
	{ 0x5190, 0x232755 },
	{ 0x5191, 0x215024 },
	{ 0x5192, 0x215023 },
	{ 0x5193, 0x222e23 },
	{ 0x5194, 0x222e22 },
	{ 0x5195, 0x215928 },
	{ 0x5196, 0x232128 },
	{ 0x5197, 0x21447d },
	{ 0x5198, 0x222135 },
	{ 0x5199, 0x23217a },
	{ 0x519d, 0x232457 },
	{ 0x519e, 0x22254d },
	{ 0x519f, 0x232b39 },
	{ 0x51a0, 0x215025 },
	{ 0x51a1, 0x232f5b },
	{ 0x51a2, 0x215443 },
	{ 0x51a3, 0x232f59 },
	{ 0x51a4, 0x215441 },
	{ 0x51a5, 0x215442 },
	{ 0x51a6, 0x232f5a },
	{ 0x51a8, 0x23344d },
	{ 0x51aa, 0x217036 },
	{ 0x51ac, 0x214576 },
	{ 0x51b0, 0x214743 },
	{ 0x51b1, 0x22217b },
	{ 0x51b2, 0x23227e },
	{ 0x51b3, 0x23227d },
	{ 0x51b4, 0x23227c },
	{ 0x51b5, 0x232459 },
	{ 0x51b6, 0x21492f },
	{ 0x51b7, 0x214930 },
	{ 0x51b8, 0x23245a },
	{ 0x51b9, 0x22232d },
	{ 0x51bc, 0x22254e },
	{ 0x51bd, 0x214c29 },
	{ 0x51be, 0x22254f },
	{ 0x51c1, 0x232b3b },
	{ 0x51c2, 0x232b3d },
	{ 0x51c3, 0x232b3e },
	{ 0x51c4, 0x222e25 },
	{ 0x51c5, 0x222e26 },
	{ 0x51c6, 0x215446 },
	{ 0x51c7, 0x232f5e },
	{ 0x51c8, 0x222e27 },
	{ 0x51c9, 0x232f5f },
	{ 0x51ca, 0x222e24 },
	{ 0x51cb, 0x215447 },
	{ 0x51cc, 0x215445 },
	{ 0x51cd, 0x215444 },
	{ 0x51ce, 0x222e28 },
	{ 0x51cf, 0x23344f },
	{ 0x51d0, 0x22336b },
	{ 0x51d1, 0x23344e },
	{ 0x51d2, 0x23397d },
	{ 0x51d3, 0x23397a },
	{ 0x51d4, 0x223a45 },
	{ 0x51d6, 0x23397e },
	{ 0x51d7, 0x22416a },
	{ 0x51d8, 0x224927 },
	{ 0x51d9, 0x234b2f },
	{ 0x51da, 0x234b2e },
	{ 0x51db, 0x234b30 },
	{ 0x51dc, 0x216c29 },
	{ 0x51dd, 0x217037 },
	{ 0x51de, 0x225644 },
	{ 0x51df, 0x235442 },
	{ 0x51e0, 0x21442d },
	{ 0x51e1, 0x21443b },
	{ 0x51e2, 0x23212f },
	{ 0x51e3, 0x232135 },
	{ 0x51e4, 0x232151 },
	{ 0x51e5, 0x23217b },
	{ 0x51e8, 0x232322 },
	{ 0x51ec, 0x23245b },
	{ 0x51ed, 0x232759 },
	{ 0x51f0, 0x215929 },
	{ 0x51f1, 0x215e33 },
	{ 0x51f3, 0x216821 },
	{ 0x51f4, 0x23457a },
	{ 0x51f5, 0x222123 },
	{ 0x51f6, 0x21447e },
	{ 0x51f8, 0x214579 },
	{ 0x51f9, 0x214577 },
	{ 0x51fa, 0x214578 },
	{ 0x51fd, 0x214c2a },
	{ 0x51fe, 0x23275a },
	{ 0x5200, 0x21442e },
	{ 0x5201, 0x21442f },
	{ 0x5203, 0x214443 },
	{ 0x5204, 0x232136 },
	{ 0x5205, 0x232152 },
	{ 0x5206, 0x214521 },
	{ 0x5207, 0x214522 },
	{ 0x5208, 0x214523 },
	{ 0x5209, 0x22214c },
	{ 0x520a, 0x21457a },
	{ 0x520b, 0x23217d },
	{ 0x520c, 0x22214b },
	{ 0x520e, 0x214747 },
	{ 0x520f, 0x232325 },
	{ 0x5210, 0x22217d },
	{ 0x5211, 0x214745 },
	{ 0x5212, 0x214746 },
	{ 0x5213, 0x22217c },
	{ 0x5214, 0x232324 },
	{ 0x5215, 0x232326 },
	{ 0x5216, 0x214748 },
	{ 0x5217, 0x214744 },
	{ 0x5218, 0x232327 },
	{ 0x521c, 0x22232e },
	{ 0x521d, 0x214f4f },
	{ 0x521e, 0x22232f },
	{ 0x521f, 0x23245f },
	{ 0x5220, 0x232461 },
	{ 0x5221, 0x222330 },
	{ 0x5223, 0x23245c },
	{ 0x5224, 0x214932 },
	{ 0x5225, 0x214931 },
	{ 0x5226, 0x23245e },
	{ 0x5227, 0x23245d },
	{ 0x5228, 0x214935 },
	{ 0x5229, 0x214933 },
	{ 0x522a, 0x214934 },
	{ 0x522b, 0x232460 },
	{ 0x522e, 0x214c30 },
	{ 0x522f, 0x23275b },
	{ 0x5230, 0x214c2f },
	{ 0x5231, 0x222554 },
	{ 0x5232, 0x222551 },
	{ 0x5233, 0x222552 },
	{ 0x5234, 0x23275e },
	{ 0x5235, 0x222550 },
	{ 0x5236, 0x214c31 },
	{ 0x5237, 0x214c2d },
	{ 0x5238, 0x214c2c },
	{ 0x5239, 0x23275f },
	{ 0x523a, 0x214c2e },
	{ 0x523b, 0x214c2b },
	{ 0x523c, 0x23275d },
	{ 0x523e, 0x23644f },
	{ 0x5241, 0x214c32 },
	{ 0x5243, 0x215027 },
	{ 0x5244, 0x222932 },
	{ 0x5245, 0x232b3f },
	{ 0x5246, 0x222553 },
	{ 0x5247, 0x21502c },
	{ 0x5248, 0x232b40 },
	{ 0x5249, 0x222933 },
	{ 0x524a, 0x215028 },
	{ 0x524b, 0x21502b },
	{ 0x524c, 0x21502a },
	{ 0x524d, 0x215029 },
	{ 0x524e, 0x215026 },
	{ 0x524f, 0x232b43 },
	{ 0x5252, 0x222e2b },
	{ 0x5253, 0x232f68 },
	{ 0x5254, 0x21544a },
	{ 0x5255, 0x222e2e },
	{ 0x5256, 0x215448 },
	{ 0x5257, 0x232f65 },
	{ 0x5259, 0x232f62 },
	{ 0x525a, 0x222e2a },
	{ 0x525b, 0x21544b },
	{ 0x525c, 0x215449 },
	{ 0x525d, 0x21544c },
	{ 0x525e, 0x222e2c },
	{ 0x525f, 0x222e2d },
	{ 0x5260, 0x232f60 },
	{ 0x5261, 0x222e29 },
	{ 0x5262, 0x222e2f },
	{ 0x5263, 0x232f66 },
	{ 0x5264, 0x232f61 },
	{ 0x5265, 0x232f63 },
	{ 0x5267, 0x232f64 },
	{ 0x5268, 0x233450 },
	{ 0x5269, 0x215e37 },
	{ 0x526a, 0x21592a },
	{ 0x526b, 0x22336c },
	{ 0x526c, 0x22336e },
	{ 0x526d, 0x22336d },
	{ 0x526e, 0x22336f },
	{ 0x526f, 0x21592b },
	{ 0x5270, 0x233a23 },
	{ 0x5272, 0x215e34 },
	{ 0x5273, 0x233a21 },
	{ 0x5274, 0x215e35 },
	{ 0x5275, 0x215e36 },
	{ 0x5276, 0x233451 },
	{ 0x5277, 0x216337 },
	{ 0x5278, 0x22416c },
	{ 0x5279, 0x234041 },
	{ 0x527a, 0x22416b },
	{ 0x527b, 0x22416d },
	{ 0x527c, 0x22416e },
	{ 0x527d, 0x216338 },
	{ 0x527e, 0x234040 },
	{ 0x527f, 0x216336 },
	{ 0x5280, 0x224928 },
	{ 0x5281, 0x224929 },
	{ 0x5282, 0x216823 },
	{ 0x5283, 0x216822 },
	{ 0x5284, 0x224c61 },
	{ 0x5286, 0x234b31 },
	{ 0x5287, 0x216c2a },
	{ 0x5288, 0x216c2b },
	{ 0x5289, 0x216c2c },
	{ 0x528a, 0x216c2e },
	{ 0x528b, 0x224f5a },
	{ 0x528c, 0x224f5b },
	{ 0x528d, 0x216c2d },
	{ 0x528e, 0x234b32 },
	{ 0x5290, 0x235036 },
	{ 0x5291, 0x217038 },
	{ 0x5293, 0x217039 },
	{ 0x5294, 0x235037 },
	{ 0x5296, 0x226539 },
	{ 0x5297, 0x226b51 },
	{ 0x5298, 0x226b50 },
	{ 0x5299, 0x226e7e },
	{ 0x529a, 0x23602c },
	{ 0x529b, 0x214430 },
	{ 0x529c, 0x232137 },
	{ 0x529d, 0x232154 },
	{ 0x529e, 0x232153 },
	{ 0x529f, 0x21457c },
	{ 0x52a0, 0x21457b },
	{ 0x52a3, 0x214749 },
	{ 0x52a6, 0x22217e },
	{ 0x52a8, 0x232328 },
	{ 0x52a9, 0x214937 },
	{ 0x52aa, 0x214938 },
	{ 0x52ab, 0x214936 },
	{ 0x52ac, 0x214939 },
	{ 0x52ad, 0x222331 },
	{ 0x52ae, 0x222332 },
	{ 0x52b3, 0x232463 },
	{ 0x52b4, 0x232462 },
	{ 0x52b5, 0x232761 },
	{ 0x52b9, 0x232760 },
	{ 0x52bb, 0x214c34 },
	{ 0x52bc, 0x222555 },
	{ 0x52bd, 0x23625a },
	{ 0x52be, 0x214c33 },
	{ 0x52bf, 0x232762 },
	{ 0x52c0, 0x222934 },
	{ 0x52c1, 0x215030 },
	{ 0x52c2, 0x222935 },
	{ 0x52c3, 0x21502f },
	{ 0x52c4, 0x232b48 },
	{ 0x52c5, 0x232b46 },
	{ 0x52c7, 0x21502d },
	{ 0x52c9, 0x21502e },
	{ 0x52ca, 0x232b47 },
	{ 0x52cc, 0x232f6f },
	{ 0x52cd, 0x222e30 },
	{ 0x52ce, 0x232f6c },
	{ 0x52cf, 0x232f6a },
	{ 0x52d0, 0x232f6d },
	{ 0x52d1, 0x232f6e },
	{ 0x52d2, 0x21592c },
	{ 0x52d3, 0x223371 },
	{ 0x52d4, 0x233452 },
	{ 0x52d5, 0x21592f },
	{ 0x52d6, 0x223370 },
	{ 0x52d7, 0x215b2b },
	{ 0x52d8, 0x21592e },
	{ 0x52d9, 0x21592d },
	{ 0x52db, 0x215e3a },
	{ 0x52dd, 0x215e39 },
	{ 0x52de, 0x215e38 },
	{ 0x52df, 0x216339 },
	{ 0x52e0, 0x234045 },
	{ 0x52e1, 0x234044 },
	{ 0x52e2, 0x21633c },
	{ 0x52e3, 0x21633d },
	{ 0x52e4, 0x21633b },
	{ 0x52e6, 0x21633a },
	{ 0x52e7, 0x234046 },
	{ 0x52e9, 0x22492a },
	{ 0x52ea, 0x234621 },
	{ 0x52eb, 0x22492b },
	{ 0x52ed, 0x23457e },
	{ 0x52ee, 0x234b33 },
	{ 0x52ef, 0x224f5d },
	{ 0x52f0, 0x216c2f },
	{ 0x52f1, 0x224f5c },
	{ 0x52f2, 0x234d2c },
	{ 0x52f3, 0x21703a },
	{ 0x52f4, 0x225c4b },
	{ 0x52f5, 0x217344 },
	{ 0x52f7, 0x22653a },
	{ 0x52f8, 0x217961 },
	{ 0x52fa, 0x214444 },
	{ 0x52fb, 0x214524 },
	{ 0x52fc, 0x222136 },
	{ 0x52fd, 0x232155 },
	{ 0x52fe, 0x214525 },
	{ 0x52ff, 0x214526 },
	{ 0x5300, 0x232156 },
	{ 0x5303, 0x232223 },
	{ 0x5304, 0x232222 },
	{ 0x5305, 0x21457d },
	{ 0x5306, 0x21457e },
	{ 0x5307, 0x232224 },
	{ 0x5308, 0x21474a },
	{ 0x5309, 0x222333 },
	{ 0x530a, 0x222556 },
	{ 0x530b, 0x222557 },
	{ 0x530d, 0x215031 },
	{ 0x530e, 0x222e31 },
	{ 0x530f, 0x215931 },
	{ 0x5310, 0x215930 },
	{ 0x5311, 0x223a47 },
	{ 0x5312, 0x223a46 },
	{ 0x5314, 0x235038 },
	{ 0x5315, 0x214431 },
	{ 0x5316, 0x214527 },
	{ 0x5317, 0x214621 },
	{ 0x5319, 0x215932 },
	{ 0x531a, 0x222124 },
	{ 0x531c, 0x22214d },
	{ 0x531d, 0x214622 },
	{ 0x531e, 0x232226 },
	{ 0x531f, 0x222222 },
	{ 0x5320, 0x21474c },
	{ 0x5321, 0x21474b },
	{ 0x5322, 0x222221 },
	{ 0x5323, 0x21493a },
	{ 0x5324, 0x236450 },
	{ 0x5325, 0x232465 },
	{ 0x5327, 0x232b49 },
	{ 0x532a, 0x21544d },
	{ 0x532d, 0x223372 },
	{ 0x532f, 0x21633e },
	{ 0x5330, 0x22492c },
	{ 0x5331, 0x216824 },
	{ 0x5332, 0x234623 },
	{ 0x5333, 0x234b34 },
	{ 0x5334, 0x225645 },
	{ 0x5335, 0x235444 },
	{ 0x5336, 0x235c34 },
	{ 0x5337, 0x22686a },
	{ 0x5338, 0x232129 },
	{ 0x5339, 0x214528 },
	{ 0x533a, 0x232157 },
	{ 0x533b, 0x232466 },
	{ 0x533c, 0x222558 },
	{ 0x533d, 0x222936 },
	{ 0x533e, 0x215935 },
	{ 0x533f, 0x215933 },
	{ 0x5340, 0x215934 },
	{ 0x5341, 0x214432 },
	{ 0x5343, 0x214445 },
	{ 0x5345, 0x21452b },
	{ 0x5346, 0x232159 },
	{ 0x5347, 0x21452a },
	{ 0x5348, 0x214529 },
	{ 0x5349, 0x214625 },
	{ 0x534a, 0x214624 },
	{ 0x534b, 0x23232a },
	{ 0x534c, 0x22214e },
	{ 0x534d, 0x222223 },
	{ 0x534f, 0x23232b },
	{ 0x5350, 0x23232d },
	{ 0x5351, 0x214c38 },
	{ 0x5352, 0x214c35 },
	{ 0x5353, 0x214c37 },
	{ 0x5354, 0x214c36 },
	{ 0x5355, 0x232763 },
	{ 0x5357, 0x215032 },
	{ 0x5358, 0x232b4a },
	{ 0x535a, 0x215e3b },
	{ 0x535c, 0x214433 },
	{ 0x535d, 0x23215a },
	{ 0x535e, 0x21452c },
	{ 0x535f, 0x232227 },
	{ 0x5360, 0x214627 },
	{ 0x5361, 0x214626 },
	{ 0x5363, 0x222334 },
	{ 0x5365, 0x236451 },
	{ 0x5366, 0x214c39 },
	{ 0x5367, 0x232a5c },
	{ 0x5369, 0x23212a },
	{ 0x536c, 0x222137 },
	{ 0x536d, 0x232228 },
	{ 0x536e, 0x214629 },
	{ 0x536f, 0x214628 },
	{ 0x5370, 0x21474d },
	{ 0x5371, 0x21474e },
	{ 0x5372, 0x222335 },
	{ 0x5373, 0x21493b },
	{ 0x5374, 0x232467 },
	{ 0x5375, 0x21493c },
	{ 0x5376, 0x232765 },
	{ 0x5377, 0x214c3a },
	{ 0x5378, 0x214c3b },
	{ 0x5379, 0x214c3c },
	{ 0x537a, 0x232766 },
	{ 0x537b, 0x215033 },
	{ 0x537c, 0x222937 },
	{ 0x537d, 0x232b4b },
	{ 0x537f, 0x21544e },
	{ 0x5380, 0x234047 },
	{ 0x5382, 0x222125 },
	{ 0x5384, 0x21452d },
	{ 0x5386, 0x23215b },
	{ 0x5389, 0x232229 },
	{ 0x538a, 0x222224 },
	{ 0x538b, 0x23232f },
	{ 0x538e, 0x222336 },
	{ 0x538f, 0x222337 },
	{ 0x5392, 0x222559 },
	{ 0x5393, 0x232767 },
	{ 0x5394, 0x22255a },
	{ 0x5396, 0x222939 },
	{ 0x5397, 0x222938 },
	{ 0x5398, 0x22293b },
	{ 0x5399, 0x22293a },
	{ 0x539a, 0x215034 },
	{ 0x539b, 0x236452 },
	{ 0x539c, 0x223373 },
	{ 0x539d, 0x215450 },
	{ 0x539e, 0x222e32 },
	{ 0x539f, 0x21544f },
	{ 0x53a0, 0x233454 },
	{ 0x53a4, 0x223a48 },
	{ 0x53a5, 0x215e3c },
	{ 0x53a6, 0x233a28 },
	{ 0x53a7, 0x223a49 },
	{ 0x53a8, 0x233a27 },
	{ 0x53a9, 0x23404a },
	{ 0x53aa, 0x234049 },
	{ 0x53ab, 0x234048 },
	{ 0x53ac, 0x22492d },
	{ 0x53ad, 0x216825 },
	{ 0x53ae, 0x234625 },
	{ 0x53b0, 0x234626 },
	{ 0x53b1, 0x234b35 },
	{ 0x53b2, 0x216c30 },
	{ 0x53b3, 0x235445 },
	{ 0x53b4, 0x22653b },
	{ 0x53b6, 0x23212b },
	{ 0x53b7, 0x23215c },
	{ 0x53b9, 0x222138 },
	{ 0x53ba, 0x23222a },
	{ 0x53bb, 0x21462a },
	{ 0x53be, 0x232331 },
	{ 0x53c1, 0x232769 },
	{ 0x53c2, 0x23276a },
	{ 0x53c3, 0x215936 },
	{ 0x53c4, 0x233455 },
	{ 0x53c5, 0x233a29 },
	{ 0x53c8, 0x214434 },
	{ 0x53c9, 0x214446 },
	{ 0x53ca, 0x21452f },
	{ 0x53cb, 0x21452e },
	{ 0x53cc, 0x23215e },
	{ 0x53cd, 0x214530 },
	{ 0x53ce, 0x232160 },
	{ 0x53d0, 0x23222b },
	{ 0x53d2, 0x232333 },
	{ 0x53d4, 0x214c3e },
	{ 0x53d5, 0x23276b },
	{ 0x53d6, 0x214c3d },
	{ 0x53d7, 0x214c3f },
	{ 0x53d9, 0x232b50 },
	{ 0x53da, 0x232b4f },
	{ 0x53db, 0x215035 },
	{ 0x53dc, 0x232b4e },
	{ 0x53dd, 0x232b4d },
	{ 0x53df, 0x215451 },
	{ 0x53e0, 0x23404b },
	{ 0x53e1, 0x225646 },
	{ 0x53e2, 0x21763b },
	{ 0x53e3, 0x214447 },
	{ 0x53e4, 0x21462c },
	{ 0x53e5, 0x21463b },
	{ 0x53e6, 0x214636 },
	{ 0x53e8, 0x214631 },
	{ 0x53e9, 0x214630 },
	{ 0x53ea, 0x214637 },
	{ 0x53eb, 0x214635 },
	{ 0x53ec, 0x21462e },
	{ 0x53ed, 0x21463c },
	{ 0x53ee, 0x21462f },
	{ 0x53ef, 0x21462b },
	{ 0x53f0, 0x21463a },
	{ 0x53f1, 0x214639 },
	{ 0x53f2, 0x214638 },
	{ 0x53f3, 0x21462d },
	{ 0x53f4, 0x232231 },
	{ 0x53f5, 0x214634 },
	{ 0x53f6, 0x23222d },
	{ 0x53f7, 0x23222e },
	{ 0x53f8, 0x214633 },
	{ 0x53f9, 0x23222f },
	{ 0x53fb, 0x21463d },
	{ 0x53fc, 0x214632 },
	{ 0x53ff, 0x232335 },
	{ 0x5400, 0x232337 },
	{ 0x5401, 0x214754 },
	{ 0x5403, 0x21475a },
	{ 0x5404, 0x214756 },
	{ 0x5405, 0x232339 },
	{ 0x5406, 0x21475c },
	{ 0x5407, 0x222225 },
	{ 0x5408, 0x214759 },
	{ 0x5409, 0x21474f },
	{ 0x540a, 0x214752 },
	{ 0x540b, 0x214755 },
	{ 0x540c, 0x214751 },
	{ 0x540d, 0x214758 },
	{ 0x540e, 0x21475b },
	{ 0x540f, 0x214750 },
	{ 0x5410, 0x214753 },
	{ 0x5411, 0x214757 },
	{ 0x5412, 0x21475d },
	{ 0x5413, 0x23233a },
	{ 0x5415, 0x23233b },
	{ 0x5416, 0x232334 },
	{ 0x5418, 0x222340 },
	{ 0x5419, 0x22233d },
	{ 0x541a, 0x232476 },
	{ 0x541b, 0x214949 },
	{ 0x541c, 0x22233e },
	{ 0x541d, 0x21493d },
	{ 0x541e, 0x21493f },
	{ 0x541f, 0x214957 },
	{ 0x5420, 0x214952 },
	{ 0x5421, 0x232479 },
	{ 0x5422, 0x23247e },
	{ 0x5423, 0x232475 },
	{ 0x5424, 0x222345 },
	{ 0x5425, 0x22233f },
	{ 0x5426, 0x214941 },
	{ 0x5427, 0x214943 },
	{ 0x5428, 0x222344 },
	{ 0x5429, 0x21494a },
	{ 0x542a, 0x22233a },
	{ 0x542b, 0x214956 },
	{ 0x542c, 0x214958 },
	{ 0x542d, 0x21493e },
	{ 0x542e, 0x21494f },
	{ 0x542f, 0x232524 },
	{ 0x5430, 0x222338 },
	{ 0x5431, 0x214955 },
	{ 0x5432, 0x232477 },
	{ 0x5433, 0x214946 },
	{ 0x5434, 0x23247b },
	{ 0x5435, 0x214950 },
	{ 0x5436, 0x214951 },
	{ 0x5437, 0x222339 },
	{ 0x5438, 0x21494e },
	{ 0x5439, 0x21494c },
	{ 0x543a, 0x232470 },
	{ 0x543b, 0x21494d },
	{ 0x543c, 0x214953 },
	{ 0x543d, 0x222341 },
	{ 0x543e, 0x214940 },
	{ 0x543f, 0x232521 },
	{ 0x5440, 0x214954 },
	{ 0x5441, 0x222343 },
	{ 0x5442, 0x214948 },
	{ 0x5443, 0x214945 },
	{ 0x5444, 0x232473 },
	{ 0x5445, 0x22233c },
	{ 0x5446, 0x214944 },
	{ 0x5447, 0x222346 },
	{ 0x5448, 0x214947 },
	{ 0x5449, 0x23247c },
	{ 0x544a, 0x21494b },
	{ 0x544b, 0x232478 },
	{ 0x544c, 0x232474 },
	{ 0x544d, 0x23246d },
	{ 0x544e, 0x214942 },
	{ 0x544f, 0x222342 },
	{ 0x5450, 0x23247d },
	{ 0x5451, 0x232522 },
	{ 0x5454, 0x22233b },
	{ 0x545a, 0x232523 },
	{ 0x545f, 0x23276e },
	{ 0x5460, 0x22256b },
	{ 0x5461, 0x22256a },
	{ 0x5462, 0x214c51 },
	{ 0x5463, 0x22256d },
	{ 0x5464, 0x22256f },
	{ 0x5465, 0x222564 },
	{ 0x5466, 0x222567 },
	{ 0x5467, 0x22256e },
	{ 0x5468, 0x214c52 },
	{ 0x5469, 0x232774 },
	{ 0x546a, 0x232778 },
	{ 0x546b, 0x222561 },
	{ 0x546c, 0x222565 },
	{ 0x546d, 0x232775 },
	{ 0x546f, 0x222569 },
	{ 0x5470, 0x22294a },
	{ 0x5471, 0x214c4d },
	{ 0x5472, 0x22294e },
	{ 0x5473, 0x214c40 },
	{ 0x5474, 0x222566 },
	{ 0x5475, 0x214c41 },
	{ 0x5476, 0x214c4e },
	{ 0x5477, 0x214c47 },
	{ 0x5478, 0x214c43 },
	{ 0x5479, 0x232771 },
	{ 0x547a, 0x222562 },
	{ 0x547b, 0x214c46 },
	{ 0x547c, 0x214c4b },
	{ 0x547d, 0x214c54 },
	{ 0x547e, 0x222563 },
	{ 0x547f, 0x22255c },
	{ 0x5480, 0x214c45 },
	{ 0x5481, 0x22255d },
	{ 0x5482, 0x22255f },
	{ 0x5484, 0x214c48 },
	{ 0x5485, 0x23276c },
	{ 0x5486, 0x214c4a },
	{ 0x5487, 0x22255b },
	{ 0x5488, 0x222560 },
	{ 0x5489, 0x232770 },
	{ 0x548a, 0x232779 },
	{ 0x548b, 0x214c53 },
	{ 0x548c, 0x214c4f },
	{ 0x548d, 0x222568 },
	{ 0x548e, 0x214c55 },
	{ 0x548f, 0x232773 },
	{ 0x5490, 0x214c4c },
	{ 0x5491, 0x22255e },
	{ 0x5492, 0x214c49 },
	{ 0x5493, 0x23276f },
	{ 0x5494, 0x232777 },
	{ 0x5495, 0x214c44 },
	{ 0x5496, 0x214c42 },
	{ 0x5498, 0x22256c },
	{ 0x549a, 0x214c50 },
	{ 0x549e, 0x232b5c },
	{ 0x549f, 0x232b5d },
	{ 0x54a0, 0x222949 },
	{ 0x54a1, 0x22293d },
	{ 0x54a2, 0x22294c },
	{ 0x54a3, 0x232b57 },
	{ 0x54a4, 0x232b59 },
	{ 0x54a5, 0x22293f },
	{ 0x54a6, 0x21503c },
	{ 0x54a7, 0x21504a },
	{ 0x54a8, 0x215038 },
	{ 0x54a9, 0x215049 },
	{ 0x54aa, 0x215041 },
	{ 0x54ab, 0x215046 },
	{ 0x54ac, 0x215036 },
	{ 0x54ad, 0x22293e },
	{ 0x54ae, 0x222944 },
	{ 0x54af, 0x215045 },
	{ 0x54b0, 0x222950 },
	{ 0x54b1, 0x215047 },
	{ 0x54b2, 0x232b5b },
	{ 0x54b3, 0x21503d },
	{ 0x54b4, 0x232b54 },
	{ 0x54b5, 0x232b5e },
	{ 0x54b6, 0x222946 },
	{ 0x54b7, 0x222943 },
	{ 0x54b8, 0x21503b },
	{ 0x54b9, 0x232b51 },
	{ 0x54ba, 0x22293c },
	{ 0x54bb, 0x215048 },
	{ 0x54bc, 0x22294b },
	{ 0x54bd, 0x215040 },
	{ 0x54be, 0x22294d },
	{ 0x54bf, 0x21504b },
	{ 0x54c0, 0x215037 },
	{ 0x54c1, 0x215042 },
	{ 0x54c2, 0x21503f },
	{ 0x54c3, 0x222941 },
	{ 0x54c4, 0x215043 },
	{ 0x54c5, 0x222947 },
	{ 0x54c6, 0x222948 },
	{ 0x54c7, 0x21503e },
	{ 0x54c8, 0x215044 },
	{ 0x54c9, 0x21503a },
	{ 0x54ca, 0x232b55 },
	{ 0x54cb, 0x236454 },
	{ 0x54cc, 0x232b63 },
	{ 0x54cd, 0x232b61 },
	{ 0x54ce, 0x215039 },
	{ 0x54cf, 0x222940 },
	{ 0x54d0, 0x232b53 },
	{ 0x54d6, 0x222945 },
	{ 0x54da, 0x232b58 },
	{ 0x54de, 0x22294f },
	{ 0x54e0, 0x222e46 },
	{ 0x54e1, 0x21545e },
	{ 0x54e2, 0x222e34 },
	{ 0x54e4, 0x222e39 },
	{ 0x54e5, 0x215457 },
	{ 0x54e6, 0x215462 },
	{ 0x54e7, 0x222e37 },
	{ 0x54e8, 0x215452 },
	{ 0x54e9, 0x21545c },
	{ 0x54ea, 0x215461 },
	{ 0x54eb, 0x222e3e },
	{ 0x54ed, 0x21545d },
	{ 0x54ee, 0x215460 },
	{ 0x54ef, 0x232f77 },
	{ 0x54f0, 0x233021 },
	{ 0x54f1, 0x222e41 },
	{ 0x54f2, 0x215458 },
	{ 0x54f3, 0x222e38 },
	{ 0x54f4, 0x232f74 },
	{ 0x54f5, 0x232f78 },
	{ 0x54f6, 0x233022 },
	{ 0x54f7, 0x222e44 },
	{ 0x54f8, 0x222e45 },
	{ 0x54f9, 0x232f79 },
	{ 0x54fa, 0x21545a },
	{ 0x54fb, 0x222e43 },
	{ 0x54fc, 0x215456 },
	{ 0x54fd, 0x215465 },
	{ 0x54ff, 0x222e3b },
	{ 0x5500, 0x232f7b },
	{ 0x5501, 0x215454 },
	{ 0x5502, 0x232f7a },
	{ 0x5503, 0x222e48 },
	{ 0x5504, 0x222e3c },
	{ 0x5505, 0x222e40 },
	{ 0x5506, 0x215459 },
	{ 0x5507, 0x215464 },
	{ 0x5508, 0x222e3d },
	{ 0x5509, 0x21545f },
	{ 0x550a, 0x222e42 },
	{ 0x550b, 0x222e49 },
	{ 0x550c, 0x223424 },
	{ 0x550d, 0x232f73 },
	{ 0x550e, 0x222e47 },
	{ 0x550f, 0x215466 },
	{ 0x5510, 0x215453 },
	{ 0x5511, 0x222e3f },
	{ 0x5512, 0x222e36 },
	{ 0x5513, 0x232f76 },
	{ 0x5514, 0x21545b },
	{ 0x5517, 0x222e35 },
	{ 0x5518, 0x232f7e },
	{ 0x5519, 0x233025 },
	{ 0x551a, 0x222e3a },
	{ 0x5526, 0x222e33 },
	{ 0x5527, 0x215463 },
	{ 0x5528, 0x236721 },
	{ 0x5529, 0x23345f },
	{ 0x552a, 0x22337a },
	{ 0x552b, 0x233468 },
	{ 0x552c, 0x215949 },
	{ 0x552d, 0x22342a },
	{ 0x552e, 0x215947 },
	{ 0x552f, 0x215944 },
	{ 0x5530, 0x223421 },
	{ 0x5531, 0x215940 },
	{ 0x5532, 0x223425 },
	{ 0x5533, 0x21594b },
	{ 0x5534, 0x223379 },
	{ 0x5535, 0x22337e },
	{ 0x5536, 0x22337d },
	{ 0x5537, 0x215455 },
	{ 0x5538, 0x215946 },
	{ 0x5539, 0x223428 },
	{ 0x553a, 0x233466 },
	{ 0x553b, 0x22342b },
	{ 0x553c, 0x223376 },
	{ 0x553e, 0x215e4e },
	{ 0x553f, 0x233467 },
	{ 0x5540, 0x22342c },
	{ 0x5541, 0x21594c },
	{ 0x5543, 0x21593e },
	{ 0x5544, 0x21593b },
	{ 0x5545, 0x223423 },
	{ 0x5546, 0x215938 },
	{ 0x5548, 0x223429 },
	{ 0x5549, 0x23345b },
	{ 0x554a, 0x21593f },
	{ 0x554b, 0x22342d },
	{ 0x554c, 0x233458 },
	{ 0x554d, 0x223377 },
	{ 0x554e, 0x223427 },
	{ 0x554f, 0x215942 },
	{ 0x5550, 0x223378 },
	{ 0x5551, 0x22337b },
	{ 0x5552, 0x223422 },
	{ 0x5553, 0x233462 },
	{ 0x5554, 0x233461 },
	{ 0x5555, 0x215943 },
	{ 0x5556, 0x215941 },
	{ 0x5557, 0x21594d },
	{ 0x5558, 0x233457 },
	{ 0x5559, 0x233a36 },
	{ 0x555a, 0x233464 },
	{ 0x555c, 0x215948 },
	{ 0x555d, 0x23345e },
	{ 0x555e, 0x21593c },
	{ 0x555f, 0x215a76 },
	{ 0x5561, 0x21593d },
	{ 0x5562, 0x22337c },
	{ 0x5563, 0x21594a },
	{ 0x5564, 0x215945 },
	{ 0x5565, 0x223426 },
	{ 0x5566, 0x21593a },
	{ 0x5568, 0x233459 },
	{ 0x556a, 0x215939 },
	{ 0x556b, 0x236457 },
	{ 0x5571, 0x236456 },
	{ 0x5572, 0x236722 },
	{ 0x5573, 0x236455 },
	{ 0x5575, 0x223374 },
	{ 0x5576, 0x223375 },
	{ 0x5577, 0x223a4e },
	{ 0x557a, 0x233a3c },
	{ 0x557b, 0x215e3d },
	{ 0x557c, 0x215e40 },
	{ 0x557d, 0x223a59 },
	{ 0x557e, 0x215e54 },
	{ 0x557f, 0x223a5c },
	{ 0x5580, 0x215e3e },
	{ 0x5581, 0x223a55 },
	{ 0x5582, 0x215e44 },
	{ 0x5583, 0x215e4a },
	{ 0x5584, 0x216143 },
	{ 0x5585, 0x233a31 },
	{ 0x5586, 0x233a38 },
	{ 0x5587, 0x215e48 },
	{ 0x5588, 0x223a52 },
	{ 0x5589, 0x215e55 },
	{ 0x558a, 0x215e41 },
	{ 0x558b, 0x215e49 },
	{ 0x558c, 0x223a5a },
	{ 0x558d, 0x22417c },
	{ 0x558e, 0x223a5f },
	{ 0x558f, 0x223a53 },
	{ 0x5591, 0x223a4a },
	{ 0x5592, 0x223a57 },
	{ 0x5593, 0x223a51 },
	{ 0x5594, 0x215e47 },
	{ 0x5595, 0x223a5d },
	{ 0x5596, 0x233a2e },
	{ 0x5597, 0x233a2a },
	{ 0x5598, 0x215e43 },
	{ 0x5599, 0x215e57 },
	{ 0x559a, 0x215e50 },
	{ 0x559b, 0x233a33 },
	{ 0x559c, 0x215e45 },
	{ 0x559d, 0x215e42 },
	{ 0x559e, 0x233a40 },
	{ 0x559f, 0x215e4d },
	{ 0x55a0, 0x233a34 },
	{ 0x55a1, 0x223a5e },
	{ 0x55a2, 0x223a50 },
	{ 0x55a3, 0x223a56 },
	{ 0x55a4, 0x223a58 },
	{ 0x55a5, 0x223a4c },
	{ 0x55a6, 0x223a5b },
	{ 0x55a7, 0x215e3f },
	{ 0x55a8, 0x223a4b },
	{ 0x55a9, 0x233a42 },
	{ 0x55aa, 0x215e46 },
	{ 0x55ab, 0x215e56 },
	{ 0x55ac, 0x215e52 },
	{ 0x55ad, 0x223a4d },
	{ 0x55ae, 0x215e4c },
	{ 0x55af, 0x233a3b },
	{ 0x55b1, 0x215e53 },
	{ 0x55b2, 0x215e4f },
	{ 0x55b3, 0x215e4b },
	{ 0x55b4, 0x233a2f },
	{ 0x55b5, 0x223a54 },
	{ 0x55ba, 0x236723 },
	{ 0x55bb, 0x215e51 },
	{ 0x55bf, 0x22417a },
	{ 0x55c0, 0x224176 },
	{ 0x55c1, 0x234051 },
	{ 0x55c2, 0x224227 },
	{ 0x55c3, 0x22416f },
	{ 0x55c4, 0x224178 },
	{ 0x55c5, 0x21634c },
	{ 0x55c6, 0x21634d },
	{ 0x55c7, 0x216345 },
	{ 0x55c8, 0x224223 },
	{ 0x55c9, 0x21634f },
	{ 0x55ca, 0x224174 },
	{ 0x55cb, 0x224173 },
	{ 0x55cc, 0x224171 },
	{ 0x55cd, 0x224225 },
	{ 0x55ce, 0x216343 },
	{ 0x55cf, 0x22417d },
	{ 0x55d0, 0x224172 },
	{ 0x55d1, 0x216346 },
	{ 0x55d2, 0x22417b },
	{ 0x55d3, 0x216341 },
	{ 0x55d4, 0x224177 },
	{ 0x55d5, 0x22417e },
	{ 0x55d6, 0x224222 },
	{ 0x55d7, 0x23404e },
	{ 0x55d9, 0x224226 },
	{ 0x55da, 0x21634a },
	{ 0x55db, 0x224170 },
	{ 0x55dc, 0x216344 },
	{ 0x55dd, 0x224175 },
	{ 0x55de, 0x233a2b },
	{ 0x55df, 0x21633f },
	{ 0x55e1, 0x21634b },
	{ 0x55e2, 0x224221 },
	{ 0x55e3, 0x216347 },
	{ 0x55e4, 0x216348 },
	{ 0x55e5, 0x21634e },
	{ 0x55e6, 0x216342 },
	{ 0x55e7, 0x212321 },
	{ 0x55e8, 0x216340 },
	{ 0x55e9, 0x224179 },
	{ 0x55ea, 0x23404c },
	{ 0x55ee, 0x236725 },
	{ 0x55ef, 0x216349 },
	{ 0x55f0, 0x236724 },
	{ 0x55f2, 0x224224 },
	{ 0x55f4, 0x236458 },
	{ 0x55f6, 0x216835 },
	{ 0x55f7, 0x216830 },
	{ 0x55f8, 0x23462e },
	{ 0x55f9, 0x22493c },
	{ 0x55fa, 0x224938 },
	{ 0x55fb, 0x234628 },
	{ 0x55fc, 0x224932 },
	{ 0x55fd, 0x21682a },
	{ 0x55fe, 0x216826 },
	{ 0x55ff, 0x22493b },
	{ 0x5600, 0x216827 },
	{ 0x5601, 0x224935 },
	{ 0x5602, 0x224937 },
	{ 0x5603, 0x234629 },
	{ 0x5604, 0x22493a },
	{ 0x5605, 0x234636 },
	{ 0x5606, 0x21682c },
	{ 0x5607, 0x23462c },
	{ 0x5608, 0x216833 },
	{ 0x5609, 0x21682d },
	{ 0x560b, 0x23462a },
	{ 0x560c, 0x224930 },
	{ 0x560d, 0x21682e },
	{ 0x560e, 0x21682f },
	{ 0x560f, 0x224933 },
	{ 0x5610, 0x216834 },
	{ 0x5611, 0x234634 },
	{ 0x5612, 0x224931 },
	{ 0x5613, 0x224936 },
	{ 0x5614, 0x21682b },
	{ 0x5615, 0x22492f },
	{ 0x5616, 0x216831 },
	{ 0x5617, 0x216829 },
	{ 0x5618, 0x234633 },
	{ 0x561b, 0x216828 },
	{ 0x561c, 0x224934 },
	{ 0x561d, 0x224939 },
	{ 0x561e, 0x234631 },
	{ 0x561f, 0x216832 },
	{ 0x5620, 0x23645a },
	{ 0x5622, 0x236459 },
	{ 0x5626, 0x234650 },
	{ 0x5627, 0x22492e },
	{ 0x5628, 0x234630 },
	{ 0x5629, 0x216c37 },
	{ 0x562a, 0x224f6e },
	{ 0x562b, 0x234b41 },
	{ 0x562c, 0x224f6b },
	{ 0x562d, 0x234b38 },
	{ 0x562e, 0x216c31 },
	{ 0x562f, 0x216c3d },
	{ 0x5630, 0x216c3e },
	{ 0x5631, 0x234b3d },
	{ 0x5632, 0x216c34 },
	{ 0x5633, 0x224f69 },
	{ 0x5634, 0x216c36 },
	{ 0x5635, 0x224f61 },
	{ 0x5636, 0x216c3c },
	{ 0x5637, 0x234b44 },
	{ 0x5638, 0x224f6d },
	{ 0x5639, 0x216c33 },
	{ 0x563a, 0x224f6f },
	{ 0x563b, 0x216c32 },
	{ 0x563d, 0x224f6a },
	{ 0x563e, 0x224f6c },
	{ 0x563f, 0x216c35 },
	{ 0x5640, 0x224f68 },
	{ 0x5641, 0x224f62 },
	{ 0x5642, 0x224f5f },
	{ 0x5644, 0x234b3e },
	{ 0x5645, 0x223a4f },
	{ 0x5646, 0x224f65 },
	{ 0x5647, 0x234b37 },
	{ 0x5648, 0x224f5e },
	{ 0x5649, 0x224f64 },
	{ 0x564a, 0x224f63 },
	{ 0x564b, 0x234b3b },
	{ 0x564c, 0x224f60 },
	{ 0x564d, 0x234b43 },
	{ 0x564e, 0x216c39 },
	{ 0x564f, 0x234b45 },
	{ 0x5650, 0x234b40 },
	{ 0x5651, 0x234635 },
	{ 0x5652, 0x234b3c },
	{ 0x5653, 0x216c38 },
	{ 0x5654, 0x234b39 },
	{ 0x5656, 0x234b3f },
	{ 0x5657, 0x216c3a },
	{ 0x5658, 0x224f66 },
	{ 0x5659, 0x21703b },
	{ 0x565a, 0x224f67 },
	{ 0x565e, 0x22564f },
	{ 0x565f, 0x23503f },
	{ 0x5660, 0x225648 },
	{ 0x5661, 0x235040 },
	{ 0x5662, 0x217047 },
	{ 0x5663, 0x22564c },
	{ 0x5664, 0x21703f },
	{ 0x5665, 0x217043 },
	{ 0x5666, 0x22564b },
	{ 0x5667, 0x23503b },
	{ 0x5668, 0x217042 },
	{ 0x5669, 0x21703e },
	{ 0x566a, 0x217041 },
	{ 0x566b, 0x21703c },
	{ 0x566c, 0x217046 },
	{ 0x566d, 0x22564d },
	{ 0x566e, 0x225649 },
	{ 0x566f, 0x217045 },
	{ 0x5670, 0x225647 },
	{ 0x5671, 0x217044 },
	{ 0x5672, 0x22564e },
	{ 0x5673, 0x22564a },
	{ 0x5674, 0x216c3b },
	{ 0x5676, 0x217048 },
	{ 0x5677, 0x225650 },
	{ 0x5678, 0x217040 },
	{ 0x5679, 0x21703d },
	{ 0x567b, 0x23503d },
	{ 0x567d, 0x235448 },
	{ 0x567e, 0x225c52 },
	{ 0x567f, 0x225c54 },
	{ 0x5680, 0x217346 },
	{ 0x5681, 0x225c55 },
	{ 0x5682, 0x225c53 },
	{ 0x5683, 0x225c51 },
	{ 0x5684, 0x225c50 },
	{ 0x5685, 0x217348 },
	{ 0x5686, 0x225c4f },
	{ 0x5687, 0x217349 },
	{ 0x5689, 0x235449 },
	{ 0x568a, 0x235447 },
	{ 0x568c, 0x225c4d },
	{ 0x568d, 0x225c4e },
	{ 0x568e, 0x217345 },
	{ 0x568f, 0x21734a },
	{ 0x5690, 0x217347 },
	{ 0x5691, 0x23645d },
	{ 0x5692, 0x23645b },
	{ 0x5693, 0x225c4c },
	{ 0x5694, 0x23575b },
	{ 0x5695, 0x21763c },
	{ 0x5696, 0x23575a },
	{ 0x5697, 0x226148 },
	{ 0x5698, 0x226146 },
	{ 0x5699, 0x22614b },
	{ 0x569a, 0x226149 },
	{ 0x569b, 0x235758 },
	{ 0x569c, 0x226147 },
	{ 0x569d, 0x22614a },
	{ 0x569e, 0x235759 },
	{ 0x569f, 0x235757 },
	{ 0x56a0, 0x23575c },
	{ 0x56a5, 0x21782c },
	{ 0x56a6, 0x22653e },
	{ 0x56a7, 0x22653f },
	{ 0x56a8, 0x21782d },
	{ 0x56aa, 0x226540 },
	{ 0x56ab, 0x22653c },
	{ 0x56ac, 0x226541 },
	{ 0x56ad, 0x22653d },
	{ 0x56ae, 0x21763d },
	{ 0x56af, 0x235a2d },
	{ 0x56b0, 0x23645e },
	{ 0x56b2, 0x22686b },
	{ 0x56b3, 0x22686d },
	{ 0x56b4, 0x217964 },
	{ 0x56b5, 0x22686c },
	{ 0x56b6, 0x217963 },
	{ 0x56b7, 0x217962 },
	{ 0x56b8, 0x236726 },
	{ 0x56b9, 0x236727 },
	{ 0x56ba, 0x23645c },
	{ 0x56bb, 0x235e26 },
	{ 0x56bc, 0x217965 },
	{ 0x56bd, 0x226b53 },
	{ 0x56be, 0x226b54 },
	{ 0x56c0, 0x217a65 },
	{ 0x56c1, 0x217a64 },
	{ 0x56c2, 0x217a66 },
	{ 0x56c3, 0x226b52 },
	{ 0x56c4, 0x236728 },
	{ 0x56c5, 0x226d46 },
	{ 0x56c6, 0x226d45 },
	{ 0x56c7, 0x235f40 },
	{ 0x56c8, 0x217b59 },
	{ 0x56c9, 0x217b5b },
	{ 0x56ca, 0x217b5a },
	{ 0x56cb, 0x226d47 },
	{ 0x56cc, 0x217c34 },
	{ 0x56cd, 0x227034 },
	{ 0x56d1, 0x217c5d },
	{ 0x56d2, 0x236071 },
	{ 0x56d3, 0x227033 },
	{ 0x56d4, 0x22707c },
	{ 0x56d7, 0x22212a },
	{ 0x56d8, 0x232177 },
	{ 0x56da, 0x21463f },
	{ 0x56db, 0x21463e },
	{ 0x56dd, 0x214760 },
	{ 0x56de, 0x21475f },
	{ 0x56df, 0x222227 },
	{ 0x56e0, 0x21475e },
	{ 0x56e1, 0x222226 },
	{ 0x56e3, 0x23233e },
	{ 0x56e4, 0x21495b },
	{ 0x56e5, 0x222349 },
	{ 0x56e6, 0x23252c },
	{ 0x56e7, 0x222348 },
	{ 0x56e9, 0x232526 },
	{ 0x56ea, 0x214959 },
	{ 0x56eb, 0x21495c },
	{ 0x56ec, 0x23252b },
	{ 0x56ed, 0x23252a },
	{ 0x56ee, 0x222347 },
	{ 0x56ef, 0x232529 },
	{ 0x56f0, 0x21495a },
	{ 0x56f1, 0x232548 },
	{ 0x56f2, 0x232527 },
	{ 0x56f3, 0x232528 },
	{ 0x56f6, 0x232822 },
	{ 0x56f7, 0x222570 },
	{ 0x56f8, 0x23277d },
	{ 0x56f9, 0x222571 },
	{ 0x56fa, 0x214c56 },
	{ 0x56fb, 0x23277c },
	{ 0x56fc, 0x232821 },
	{ 0x56fd, 0x23277b },
	{ 0x56ff, 0x21504c },
	{ 0x5700, 0x232b65 },
	{ 0x5701, 0x222e4a },
	{ 0x5702, 0x222e4b },
	{ 0x5703, 0x215467 },
	{ 0x5704, 0x215468 },
	{ 0x5705, 0x233027 },
	{ 0x5707, 0x22342f },
	{ 0x5708, 0x21594e },
	{ 0x5709, 0x215950 },
	{ 0x570a, 0x22342e },
	{ 0x570b, 0x21594f },
	{ 0x570c, 0x223a60 },
	{ 0x570d, 0x215e58 },
	{ 0x570e, 0x233a44 },
	{ 0x570f, 0x233a43 },
	{ 0x5712, 0x216350 },
	{ 0x5713, 0x216351 },
	{ 0x5714, 0x224228 },
	{ 0x5715, 0x234052 },
	{ 0x5716, 0x216837 },
	{ 0x5717, 0x234637 },
	{ 0x5718, 0x216836 },
	{ 0x571a, 0x224f70 },
	{ 0x571b, 0x225652 },
	{ 0x571c, 0x225651 },
	{ 0x571d, 0x235f41 },
	{ 0x571e, 0x22715a },
	{ 0x571f, 0x214448 },
	{ 0x5720, 0x222139 },
	{ 0x5721, 0x232161 },
	{ 0x5722, 0x22214f },
	{ 0x5723, 0x222150 },
	{ 0x5724, 0x232234 },
	{ 0x5727, 0x236249 },
	{ 0x5728, 0x214763 },
	{ 0x5729, 0x214767 },
	{ 0x572a, 0x222229 },
	{ 0x572c, 0x214765 },
	{ 0x572d, 0x214764 },
	{ 0x572e, 0x222228 },
	{ 0x572f, 0x214766 },
	{ 0x5730, 0x214762 },
	{ 0x5731, 0x232341 },
	{ 0x5732, 0x232342 },
	{ 0x5733, 0x214761 },
	{ 0x5734, 0x22222a },
	{ 0x5735, 0x23233f },
	{ 0x5736, 0x232340 },
	{ 0x573b, 0x214966 },
	{ 0x573c, 0x232531 },
	{ 0x573d, 0x23253e },
	{ 0x573e, 0x214963 },
	{ 0x573f, 0x232530 },
	{ 0x5740, 0x21495f },
	{ 0x5741, 0x22234a },
	{ 0x5742, 0x232540 },
	{ 0x5743, 0x232536 },
	{ 0x5744, 0x23252f },
	{ 0x5745, 0x22234b },
	{ 0x5746, 0x23253c },
	{ 0x5747, 0x214961 },
	{ 0x5748, 0x23252d },
	{ 0x5749, 0x22234d },
	{ 0x574a, 0x21495d },
	{ 0x574b, 0x22234e },
	{ 0x574c, 0x22234c },
	{ 0x574d, 0x214960 },
	{ 0x574e, 0x214962 },
	{ 0x574f, 0x214965 },
	{ 0x5750, 0x214964 },
	{ 0x5751, 0x21495e },
	{ 0x5752, 0x22234f },
	{ 0x5753, 0x232532 },
	{ 0x5754, 0x232541 },
	{ 0x5755, 0x232542 },
	{ 0x5756, 0x232533 },
	{ 0x5757, 0x232538 },
	{ 0x5758, 0x232537 },
	{ 0x5759, 0x23645f },
	{ 0x575f, 0x232535 },
	{ 0x5761, 0x214c5b },
	{ 0x5762, 0x22257e },
	{ 0x5763, 0x232825 },
	{ 0x5764, 0x214c5d },
	{ 0x5765, 0x232823 },
	{ 0x5766, 0x214c5c },
	{ 0x5767, 0x232826 },
	{ 0x5768, 0x222621 },
	{ 0x5769, 0x214c5a },
	{ 0x576a, 0x214c59 },
	{ 0x576b, 0x222575 },
	{ 0x576d, 0x222574 },
	{ 0x576e, 0x232828 },
	{ 0x576f, 0x222572 },
	{ 0x5770, 0x222577 },
	{ 0x5771, 0x222576 },
	{ 0x5772, 0x222573 },
	{ 0x5773, 0x22257c },
	{ 0x5774, 0x22257d },
	{ 0x5775, 0x22257a },
	{ 0x5776, 0x222578 },
	{ 0x5777, 0x214c58 },
	{ 0x5778, 0x232829 },
	{ 0x577b, 0x22257b },
	{ 0x577c, 0x214c5e },
	{ 0x577d, 0x222622 },
	{ 0x577f, 0x23282a },
	{ 0x5780, 0x222579 },
	{ 0x5781, 0x232824 },
	{ 0x5782, 0x21504d },
	{ 0x5783, 0x214c57 },
	{ 0x578a, 0x236460 },
	{ 0x578b, 0x21504e },
	{ 0x578c, 0x222955 },
	{ 0x578d, 0x232b69 },
	{ 0x578e, 0x232b68 },
	{ 0x578f, 0x22295b },
	{ 0x5790, 0x232b6c },
	{ 0x5791, 0x232b67 },
	{ 0x5792, 0x232b6a },
	{ 0x5793, 0x215054 },
	{ 0x5794, 0x222959 },
	{ 0x5795, 0x22295f },
	{ 0x5796, 0x232b71 },
	{ 0x5797, 0x222956 },
	{ 0x5798, 0x22295a },
	{ 0x5799, 0x22295c },
	{ 0x579a, 0x22295e },
	{ 0x579b, 0x222958 },
	{ 0x579c, 0x232b70 },
	{ 0x579d, 0x222957 },
	{ 0x579e, 0x222952 },
	{ 0x579f, 0x222953 },
	{ 0x57a0, 0x21504f },
	{ 0x57a1, 0x232b6b },
	{ 0x57a2, 0x215051 },
	{ 0x57a3, 0x215050 },
	{ 0x57a4, 0x222954 },
	{ 0x57a5, 0x22295d },
	{ 0x57a6, 0x232b6d },
	{ 0x57a7, 0x232b72 },
	{ 0x57a8, 0x232b6e },
	{ 0x57ac, 0x232b66 },
	{ 0x57ae, 0x215053 },
	{ 0x57b5, 0x222951 },
	{ 0x57b6, 0x222e55 },
	{ 0x57b7, 0x23302a },
	{ 0x57b8, 0x222e54 },
	{ 0x57b9, 0x222e59 },
	{ 0x57ba, 0x222e50 },
	{ 0x57bb, 0x233030 },
	{ 0x57bc, 0x222e53 },
	{ 0x57bd, 0x222e52 },
	{ 0x57be, 0x23302f },
	{ 0x57bf, 0x222e56 },
	{ 0x57c0, 0x233038 },
	{ 0x57c1, 0x222e5a },
	{ 0x57c2, 0x215469 },
	{ 0x57c3, 0x21546c },
	{ 0x57c4, 0x233034 },
	{ 0x57c5, 0x233035 },
	{ 0x57c6, 0x222e51 },
	{ 0x57c7, 0x222e57 },
	{ 0x57c8, 0x233033 },
	{ 0x57c9, 0x233028 },
	{ 0x57ca, 0x233037 },
	{ 0x57cb, 0x21546b },
	{ 0x57cc, 0x222e4c },
	{ 0x57cd, 0x23302b },
	{ 0x57ce, 0x215052 },
	{ 0x57cf, 0x22343d },
	{ 0x57d0, 0x222e58 },
	{ 0x57d1, 0x233036 },
	{ 0x57d2, 0x222e4f },
	{ 0x57d4, 0x21546a },
	{ 0x57d5, 0x222e4e },
	{ 0x57db, 0x233032 },
	{ 0x57dc, 0x223434 },
	{ 0x57dd, 0x23346e },
	{ 0x57de, 0x233471 },
	{ 0x57df, 0x215951 },
	{ 0x57e0, 0x215955 },
	{ 0x57e1, 0x223444 },
	{ 0x57e2, 0x223432 },
	{ 0x57e3, 0x223440 },
	{ 0x57e4, 0x215956 },
	{ 0x57e5, 0x223442 },
	{ 0x57e6, 0x233472 },
	{ 0x57e7, 0x223448 },
	{ 0x57e8, 0x233474 },
	{ 0x57e9, 0x22344c },
	{ 0x57ea, 0x233469 },
	{ 0x57ec, 0x223443 },
	{ 0x57ed, 0x223437 },
	{ 0x57ee, 0x22343f },
	{ 0x57ef, 0x23346b },
	{ 0x57f0, 0x22344d },
	{ 0x57f1, 0x22344b },
	{ 0x57f2, 0x223441 },
	{ 0x57f3, 0x22343c },
	{ 0x57f4, 0x223435 },
	{ 0x57f5, 0x223a68 },
	{ 0x57f6, 0x223433 },
	{ 0x57f7, 0x21595a },
	{ 0x57f8, 0x22343a },
	{ 0x57f9, 0x21595b },
	{ 0x57fa, 0x215957 },
	{ 0x57fb, 0x223430 },
	{ 0x57fc, 0x223446 },
	{ 0x57fd, 0x223438 },
	{ 0x57fe, 0x23346f },
	{ 0x57ff, 0x233475 },
	{ 0x5800, 0x223436 },
	{ 0x5801, 0x223449 },
	{ 0x5802, 0x215958 },
	{ 0x5803, 0x233476 },
	{ 0x5804, 0x22344f },
	{ 0x5805, 0x215952 },
	{ 0x5806, 0x215954 },
	{ 0x5807, 0x22343e },
	{ 0x5808, 0x223439 },
	{ 0x5809, 0x21546d },
	{ 0x580a, 0x215953 },
	{ 0x580b, 0x22343b },
	{ 0x580c, 0x22344a },
	{ 0x580d, 0x22344e },
	{ 0x580e, 0x223445 },
	{ 0x580f, 0x236461 },
	{ 0x5810, 0x223447 },
	{ 0x5812, 0x236462 },
	{ 0x5813, 0x236463 },
	{ 0x5814, 0x223431 },
	{ 0x5818, 0x233a4a },
	{ 0x5819, 0x223a63 },
	{ 0x581a, 0x233a45 },
	{ 0x581b, 0x223a6c },
	{ 0x581c, 0x223a6b },
	{ 0x581d, 0x215e60 },
	{ 0x581e, 0x223a64 },
	{ 0x581f, 0x233a47 },
	{ 0x5820, 0x215e61 },
	{ 0x5821, 0x215e5f },
	{ 0x5822, 0x233a50 },
	{ 0x5823, 0x223a66 },
	{ 0x5824, 0x215e5c },
	{ 0x5825, 0x223a6a },
	{ 0x5826, 0x233a4c },
	{ 0x5827, 0x223a65 },
	{ 0x5828, 0x223a67 },
	{ 0x5829, 0x223a61 },
	{ 0x582a, 0x215e5a },
	{ 0x582b, 0x236336 },
	{ 0x582c, 0x223a74 },
	{ 0x582d, 0x223a73 },
	{ 0x582e, 0x223a70 },
	{ 0x582f, 0x215e59 },
	{ 0x5830, 0x215e5d },
	{ 0x5831, 0x215e5e },
	{ 0x5832, 0x222e4d },
	{ 0x5833, 0x223a6d },
	{ 0x5834, 0x215e5b },
	{ 0x5835, 0x215959 },
	{ 0x5836, 0x223a6f },
	{ 0x5837, 0x223a62 },
	{ 0x5838, 0x223a72 },
	{ 0x5839, 0x223a71 },
	{ 0x583a, 0x233a4e },
	{ 0x583b, 0x223a75 },
	{ 0x583c, 0x233a49 },
	{ 0x583d, 0x224236 },
	{ 0x583e, 0x233a4b },
	{ 0x583f, 0x223a6e },
	{ 0x5845, 0x236337 },
	{ 0x5847, 0x236464 },
	{ 0x5848, 0x223a69 },
	{ 0x5849, 0x22422e },
	{ 0x584a, 0x21635b },
	{ 0x584b, 0x21635e },
	{ 0x584c, 0x216359 },
	{ 0x584d, 0x22422d },
	{ 0x584e, 0x224231 },
	{ 0x584f, 0x22422c },
	{ 0x5850, 0x234057 },
	{ 0x5851, 0x216353 },
	{ 0x5852, 0x21635d },
	{ 0x5853, 0x224229 },
	{ 0x5854, 0x216357 },
	{ 0x5855, 0x224230 },
	{ 0x5856, 0x23405b },
	{ 0x5857, 0x216355 },
	{ 0x5858, 0x216354 },
	{ 0x5859, 0x224233 },
	{ 0x585a, 0x216356 },
	{ 0x585b, 0x224235 },
	{ 0x585c, 0x234056 },
	{ 0x585d, 0x224232 },
	{ 0x585e, 0x216352 },
	{ 0x585f, 0x23405e },
	{ 0x5860, 0x23405c },
	{ 0x5861, 0x234058 },
	{ 0x5862, 0x21635c },
	{ 0x5863, 0x224237 },
	{ 0x5864, 0x22422b },
	{ 0x5865, 0x224234 },
	{ 0x5866, 0x23405d },
	{ 0x5867, 0x236343 },
	{ 0x5868, 0x22422a },
	{ 0x5869, 0x23405a },
	{ 0x586a, 0x234059 },
	{ 0x586b, 0x216358 },
	{ 0x586c, 0x234054 },
	{ 0x586d, 0x21635a },
	{ 0x586f, 0x22422f },
	{ 0x5871, 0x224238 },
	{ 0x5872, 0x234643 },
	{ 0x5873, 0x23463e },
	{ 0x5874, 0x224944 },
	{ 0x5875, 0x216838 },
	{ 0x5876, 0x22494a },
	{ 0x5877, 0x234642 },
	{ 0x5878, 0x23463c },
	{ 0x5879, 0x21683d },
	{ 0x587a, 0x224946 },
	{ 0x587b, 0x22494d },
	{ 0x587c, 0x22493e },
	{ 0x587d, 0x21683f },
	{ 0x587e, 0x216839 },
	{ 0x587f, 0x224943 },
	{ 0x5880, 0x216c3f },
	{ 0x5881, 0x224942 },
	{ 0x5882, 0x22494b },
	{ 0x5883, 0x21683a },
	{ 0x5884, 0x23463d },
	{ 0x5885, 0x21683e },
	{ 0x5886, 0x224941 },
	{ 0x5887, 0x224947 },
	{ 0x5888, 0x22494c },
	{ 0x5889, 0x22493d },
	{ 0x588a, 0x21683c },
	{ 0x588b, 0x224945 },
	{ 0x588c, 0x23463a },
	{ 0x588d, 0x234645 },
	{ 0x588e, 0x224949 },
	{ 0x588f, 0x22494f },
	{ 0x5890, 0x22493f },
	{ 0x5891, 0x224948 },
	{ 0x5892, 0x234638 },
	{ 0x5893, 0x21683b },
	{ 0x5894, 0x22494e },
	{ 0x5895, 0x234641 },
	{ 0x5896, 0x234644 },
	{ 0x5897, 0x234640 },
	{ 0x5898, 0x224940 },
	{ 0x589b, 0x236465 },
	{ 0x589c, 0x216c43 },
	{ 0x589d, 0x224f72 },
	{ 0x589e, 0x216c41 },
	{ 0x589f, 0x216c40 },
	{ 0x58a0, 0x224f74 },
	{ 0x58a1, 0x224f79 },
	{ 0x58a2, 0x234b46 },
	{ 0x58a3, 0x224f75 },
	{ 0x58a4, 0x234b50 },
	{ 0x58a5, 0x224f78 },
	{ 0x58a6, 0x216c46 },
	{ 0x58a7, 0x234b51 },
	{ 0x58a8, 0x21702e },
	{ 0x58a9, 0x216c45 },
	{ 0x58aa, 0x234b4b },
	{ 0x58ab, 0x224f71 },
	{ 0x58ac, 0x224f77 },
	{ 0x58ad, 0x23463f },
	{ 0x58ae, 0x216c44 },
	{ 0x58af, 0x224f76 },
	{ 0x58b0, 0x234b4d },
	{ 0x58b1, 0x224f73 },
	{ 0x58b2, 0x234b49 },
	{ 0x58b3, 0x216c42 },
	{ 0x58b4, 0x234b4f },
	{ 0x58b5, 0x234b4c },
	{ 0x58b7, 0x234b47 },
	{ 0x58ba, 0x225657 },
	{ 0x58bb, 0x23504a },
	{ 0x58bc, 0x225659 },
	{ 0x58bd, 0x225654 },
	{ 0x58be, 0x21704a },
	{ 0x58bf, 0x225656 },
	{ 0x58c0, 0x23504b },
	{ 0x58c1, 0x217049 },
	{ 0x58c2, 0x225658 },
	{ 0x58c3, 0x235048 },
	{ 0x58c4, 0x23504c },
	{ 0x58c5, 0x21704c },
	{ 0x58c6, 0x22565a },
	{ 0x58c7, 0x21704b },
	{ 0x58c8, 0x225653 },
	{ 0x58c9, 0x225655 },
	{ 0x58ca, 0x235049 },
	{ 0x58cd, 0x23544b },
	{ 0x58ce, 0x21734e },
	{ 0x58cf, 0x225c58 },
	{ 0x58d0, 0x23544c },
	{ 0x58d1, 0x21734d },
	{ 0x58d2, 0x225c59 },
	{ 0x58d3, 0x21734c },
	{ 0x58d4, 0x225c57 },
	{ 0x58d5, 0x21734b },
	{ 0x58d6, 0x225c56 },
	{ 0x58d8, 0x21763f },
	{ 0x58d9, 0x21763e },
	{ 0x58da, 0x226542 },
	{ 0x58db, 0x226544 },
	{ 0x58dc, 0x235a2f },
	{ 0x58dd, 0x226543 },
	{ 0x58de, 0x21782e },
	{ 0x58df, 0x21782f },
	{ 0x58e0, 0x235a2e },
	{ 0x58e2, 0x217830 },
	{ 0x58e3, 0x22686e },
	{ 0x58e4, 0x217966 },
	{ 0x58e6, 0x235e28 },
	{ 0x58e7, 0x226f22 },
	{ 0x58e8, 0x226f21 },
	{ 0x58e9, 0x217c5e },
	{ 0x58eb, 0x214449 },
	{ 0x58ec, 0x214531 },
	{ 0x58ee, 0x232343 },
	{ 0x58ef, 0x214967 },
	{ 0x58f0, 0x232545 },
	{ 0x58f1, 0x232543 },
	{ 0x58f2, 0x232544 },
	{ 0x58f3, 0x23282d },
	{ 0x58f4, 0x222960 },
	{ 0x58f5, 0x232b77 },
	{ 0x58f7, 0x233477 },
	{ 0x58f9, 0x215e62 },
	{ 0x58fa, 0x215e63 },
	{ 0x58fb, 0x233a52 },
	{ 0x58fc, 0x224239 },
	{ 0x58fd, 0x216840 },
	{ 0x58fe, 0x224950 },
	{ 0x58ff, 0x224f7a },
	{ 0x5900, 0x236466 },
	{ 0x5901, 0x23504d },
	{ 0x5902, 0x232139 },
	{ 0x5903, 0x22213a },
	{ 0x5904, 0x232235 },
	{ 0x5905, 0x232344 },
	{ 0x5906, 0x222350 },
	{ 0x5908, 0x232b7a },
	{ 0x5909, 0x232b79 },
	{ 0x590a, 0x23213a },
	{ 0x590b, 0x232546 },
	{ 0x590c, 0x222623 },
	{ 0x590d, 0x222961 },
	{ 0x590e, 0x222e5b },
	{ 0x590f, 0x21546e },
	{ 0x5910, 0x234646 },
	{ 0x5911, 0x236560 },
	{ 0x5912, 0x226545 },
	{ 0x5914, 0x217a67 },
	{ 0x5915, 0x21444a },
	{ 0x5916, 0x214640 },
	{ 0x5917, 0x222151 },
	{ 0x5918, 0x232236 },
	{ 0x5919, 0x214768 },
	{ 0x591a, 0x214769 },
	{ 0x591c, 0x214c5f },
	{ 0x591f, 0x233479 },
	{ 0x5920, 0x21595c },
	{ 0x5922, 0x216842 },
	{ 0x5923, 0x23405f },
	{ 0x5924, 0x216843 },
	{ 0x5925, 0x216841 },
	{ 0x5926, 0x234b53 },
	{ 0x5927, 0x21444b },
	{ 0x5929, 0x214532 },
	{ 0x592a, 0x214534 },
	{ 0x592b, 0x214533 },
	{ 0x592c, 0x22213b },
	{ 0x592d, 0x214535 },
	{ 0x592e, 0x214641 },
	{ 0x592f, 0x222152 },
	{ 0x5930, 0x232238 },
	{ 0x5931, 0x214642 },
	{ 0x5932, 0x232237 },
	{ 0x5934, 0x232239 },
	{ 0x5936, 0x232347 },
	{ 0x5937, 0x21476a },
	{ 0x5938, 0x21476b },
	{ 0x593c, 0x22222b },
	{ 0x593d, 0x232549 },
	{ 0x593e, 0x214968 },
	{ 0x5940, 0x222351 },
	{ 0x5944, 0x214c63 },
	{ 0x5945, 0x222624 },
	{ 0x5947, 0x214c61 },
	{ 0x5948, 0x214c62 },
	{ 0x5949, 0x214c60 },
	{ 0x594a, 0x222e5c },
	{ 0x594b, 0x23282e },
	{ 0x594c, 0x23282f },
	{ 0x594d, 0x236467 },
	{ 0x594e, 0x215058 },
	{ 0x594f, 0x215057 },
	{ 0x5950, 0x215059 },
	{ 0x5951, 0x215056 },
	{ 0x5952, 0x232b7c },
	{ 0x5953, 0x222962 },
	{ 0x5954, 0x214c64 },
	{ 0x5955, 0x215055 },
	{ 0x5957, 0x21546f },
	{ 0x5958, 0x215470 },
	{ 0x595a, 0x215471 },
	{ 0x595b, 0x23347b },
	{ 0x595c, 0x223450 },
	{ 0x595d, 0x23347c },
	{ 0x595e, 0x23347d },
	{ 0x5960, 0x215e64 },
	{ 0x5961, 0x223a76 },
	{ 0x5962, 0x21595d },
	{ 0x5963, 0x233a53 },
	{ 0x5964, 0x233a54 },
	{ 0x5966, 0x234060 },
	{ 0x5967, 0x21635f },
	{ 0x5968, 0x234061 },
	{ 0x5969, 0x216845 },
	{ 0x596a, 0x216844 },
	{ 0x596b, 0x224951 },
	{ 0x596c, 0x234648 },
	{ 0x596d, 0x216c47 },
	{ 0x596e, 0x21704d },
	{ 0x5970, 0x22614c },
	{ 0x5971, 0x226d48 },
	{ 0x5972, 0x226f23 },
	{ 0x5973, 0x21444c },
	{ 0x5974, 0x214643 },
	{ 0x5975, 0x23223b },
	{ 0x5976, 0x214644 },
	{ 0x5977, 0x222231 },
	{ 0x5978, 0x21476d },
	{ 0x5979, 0x214770 },
	{ 0x597a, 0x23234b },
	{ 0x597b, 0x22222f },
	{ 0x597c, 0x22222d },
	{ 0x597d, 0x21476f },
	{ 0x597e, 0x222230 },
	{ 0x597f, 0x222232 },
	{ 0x5980, 0x22222c },
	{ 0x5981, 0x214772 },
	{ 0x5982, 0x214771 },
	{ 0x5983, 0x21476e },
	{ 0x5984, 0x21476c },
	{ 0x5985, 0x22222e },
	{ 0x5986, 0x23234d },
	{ 0x5989, 0x232555 },
	{ 0x598a, 0x214973 },
	{ 0x598c, 0x23254c },
	{ 0x598d, 0x214970 },
	{ 0x598e, 0x222356 },
	{ 0x598f, 0x222359 },
	{ 0x5990, 0x222358 },
	{ 0x5992, 0x21496a },
	{ 0x5993, 0x214972 },
	{ 0x5994, 0x23254b },
	{ 0x5996, 0x21496f },
	{ 0x5997, 0x222355 },
	{ 0x5998, 0x222353 },
	{ 0x5999, 0x21496e },
	{ 0x599a, 0x232556 },
	{ 0x599b, 0x232553 },
	{ 0x599c, 0x23254e },
	{ 0x599d, 0x214969 },
	{ 0x599e, 0x21496c },
	{ 0x599f, 0x232551 },
	{ 0x59a0, 0x222354 },
	{ 0x59a1, 0x22235b },
	{ 0x59a2, 0x222357 },
	{ 0x59a3, 0x21496d },
	{ 0x59a4, 0x214971 },
	{ 0x59a5, 0x214974 },
	{ 0x59a6, 0x222352 },
	{ 0x59a7, 0x22235a },
	{ 0x59a8, 0x21496b },
	{ 0x59ac, 0x232841 },
	{ 0x59ad, 0x232833 },
	{ 0x59ae, 0x214c69 },
	{ 0x59af, 0x214c71 },
	{ 0x59b0, 0x232838 },
	{ 0x59b1, 0x222630 },
	{ 0x59b2, 0x222629 },
	{ 0x59b3, 0x214c72 },
	{ 0x59b4, 0x222634 },
	{ 0x59b5, 0x222625 },
	{ 0x59b6, 0x22262c },
	{ 0x59b7, 0x232845 },
	{ 0x59b8, 0x232840 },
	{ 0x59b9, 0x214c68 },
	{ 0x59ba, 0x222626 },
	{ 0x59bb, 0x214c66 },
	{ 0x59bc, 0x22262d },
	{ 0x59bd, 0x222631 },
	{ 0x59be, 0x214c65 },
	{ 0x59bf, 0x23283d },
	{ 0x59c0, 0x222632 },
	{ 0x59c1, 0x22262b },
	{ 0x59c2, 0x232837 },
	{ 0x59c3, 0x22262e },
	{ 0x59c4, 0x232835 },
	{ 0x59c5, 0x214c74 },
	{ 0x59c6, 0x214c6b },
	{ 0x59c7, 0x222635 },
	{ 0x59c8, 0x222633 },
	{ 0x59c9, 0x23283f },
	{ 0x59ca, 0x214c70 },
	{ 0x59cb, 0x214c6e },
	{ 0x59cc, 0x22262a },
	{ 0x59cd, 0x214c6d },
	{ 0x59ce, 0x222628 },
	{ 0x59cf, 0x222627 },
	{ 0x59d0, 0x214c6c },
	{ 0x59d1, 0x214c6a },
	{ 0x59d2, 0x214c73 },
	{ 0x59d3, 0x214c6f },
	{ 0x59d4, 0x214c67 },
	{ 0x59d5, 0x232c26 },
	{ 0x59d6, 0x22262f },
	{ 0x59d7, 0x232846 },
	{ 0x59d8, 0x21505b },
	{ 0x59d9, 0x232c2d },
	{ 0x59da, 0x215062 },
	{ 0x59db, 0x222970 },
	{ 0x59dc, 0x21505a },
	{ 0x59dd, 0x222968 },
	{ 0x59de, 0x222964 },
	{ 0x59df, 0x232c21 },
	{ 0x59e0, 0x222974 },
	{ 0x59e1, 0x222963 },
	{ 0x59e2, 0x232c2c },
	{ 0x59e3, 0x21505d },
	{ 0x59e4, 0x22296d },
	{ 0x59e5, 0x215060 },
	{ 0x59e6, 0x215063 },
	{ 0x59e7, 0x232c2e },
	{ 0x59e8, 0x21505e },
	{ 0x59e9, 0x222971 },
	{ 0x59ea, 0x215061 },
	{ 0x59eb, 0x232c23 },
	{ 0x59ec, 0x215478 },
	{ 0x59ed, 0x222977 },
	{ 0x59ee, 0x222965 },
	{ 0x59ef, 0x232c24 },
	{ 0x59f0, 0x232c25 },
	{ 0x59f1, 0x222967 },
	{ 0x59f2, 0x22296e },
	{ 0x59f3, 0x222972 },
	{ 0x59f4, 0x222976 },
	{ 0x59f5, 0x222973 },
	{ 0x59f6, 0x22296c },
	{ 0x59f7, 0x22296f },
	{ 0x59f8, 0x232c2b },
	{ 0x59f9, 0x232c29 },
	{ 0x59fa, 0x222969 },
	{ 0x59fb, 0x215065 },
	{ 0x59fc, 0x22296b },
	{ 0x59fd, 0x22296a },
	{ 0x59fe, 0x222975 },
	{ 0x59ff, 0x21505c },
	{ 0x5a00, 0x222966 },
	{ 0x5a01, 0x215064 },
	{ 0x5a02, 0x232c2a },
	{ 0x5a03, 0x21505f },
	{ 0x5a04, 0x232c28 },
	{ 0x5a09, 0x21547e },
	{ 0x5a0a, 0x222e64 },
	{ 0x5a0b, 0x233040 },
	{ 0x5a0c, 0x21547d },
	{ 0x5a0d, 0x232c27 },
	{ 0x5a0f, 0x222e62 },
	{ 0x5a10, 0x236270 },
	{ 0x5a11, 0x215472 },
	{ 0x5a12, 0x23304f },
	{ 0x5a13, 0x215477 },
	{ 0x5a14, 0x23304a },
	{ 0x5a15, 0x222e61 },
	{ 0x5a16, 0x222e5e },
	{ 0x5a17, 0x222e63 },
	{ 0x5a18, 0x215473 },
	{ 0x5a19, 0x222e5d },
	{ 0x5a1a, 0x23304e },
	{ 0x5a1b, 0x215476 },
	{ 0x5a1c, 0x215474 },
	{ 0x5a1d, 0x23303e },
	{ 0x5a1e, 0x222e65 },
	{ 0x5a1f, 0x215475 },
	{ 0x5a20, 0x215479 },
	{ 0x5a21, 0x23303b },
	{ 0x5a22, 0x233045 },
	{ 0x5a23, 0x21547a },
	{ 0x5a24, 0x233048 },
	{ 0x5a25, 0x21547c },
	{ 0x5a26, 0x233052 },
	{ 0x5a29, 0x21547b },
	{ 0x5a2a, 0x23303c },
	{ 0x5a2b, 0x233522 },
	{ 0x5a2c, 0x233538 },
	{ 0x5a2d, 0x222e5f },
	{ 0x5a2e, 0x222e60 },
	{ 0x5a2f, 0x23304d },
	{ 0x5a31, 0x23304b },
	{ 0x5a33, 0x222e66 },
	{ 0x5a35, 0x223457 },
	{ 0x5a36, 0x21595e },
	{ 0x5a37, 0x223b26 },
	{ 0x5a38, 0x223456 },
	{ 0x5a39, 0x223469 },
	{ 0x5a3a, 0x233528 },
	{ 0x5a3b, 0x233524 },
	{ 0x5a3c, 0x215964 },
	{ 0x5a3d, 0x233531 },
	{ 0x5a3e, 0x223467 },
	{ 0x5a3f, 0x233533 },
	{ 0x5a40, 0x215963 },
	{ 0x5a41, 0x21595f },
	{ 0x5a42, 0x223470 },
	{ 0x5a43, 0x223460 },
	{ 0x5a44, 0x223463 },
	{ 0x5a45, 0x23352e },
	{ 0x5a46, 0x215967 },
	{ 0x5a47, 0x22346d },
	{ 0x5a48, 0x223465 },
	{ 0x5a49, 0x215960 },
	{ 0x5a4a, 0x215968 },
	{ 0x5a4b, 0x23352a },
	{ 0x5a4c, 0x22346a },
	{ 0x5a4d, 0x223468 },
	{ 0x5a4e, 0x23352f },
	{ 0x5a4f, 0x23353b },
	{ 0x5a50, 0x223459 },
	{ 0x5a51, 0x22346e },
	{ 0x5a52, 0x223462 },
	{ 0x5a53, 0x22345d },
	{ 0x5a54, 0x23353a },
	{ 0x5a55, 0x223453 },
	{ 0x5a56, 0x22346f },
	{ 0x5a57, 0x22345f },
	{ 0x5a58, 0x223452 },
	{ 0x5a59, 0x233539 },
	{ 0x5a5a, 0x215966 },
	{ 0x5a5b, 0x223464 },
	{ 0x5a5c, 0x223471 },
	{ 0x5a5d, 0x223461 },
	{ 0x5a5e, 0x223455 },
	{ 0x5a5f, 0x22345a },
	{ 0x5a60, 0x223451 },
	{ 0x5a61, 0x233527 },
	{ 0x5a62, 0x215965 },
	{ 0x5a63, 0x23353c },
	{ 0x5a64, 0x22345e },
	{ 0x5a65, 0x22345b },
	{ 0x5a66, 0x215961 },
	{ 0x5a67, 0x223454 },
	{ 0x5a68, 0x233530 },
	{ 0x5a69, 0x22346c },
	{ 0x5a6a, 0x215962 },
	{ 0x5a6b, 0x23352b },
	{ 0x5a6c, 0x22345c },
	{ 0x5a6d, 0x223458 },
	{ 0x5a6e, 0x233529 },
	{ 0x5a6f, 0x233534 },
	{ 0x5a70, 0x22346b },
	{ 0x5a71, 0x233532 },
	{ 0x5a73, 0x233537 },
	{ 0x5a75, 0x233535 },
	{ 0x5a77, 0x215e65 },
	{ 0x5a78, 0x223a7d },
	{ 0x5a79, 0x233a75 },
	{ 0x5a7a, 0x223a7a },
	{ 0x5a7b, 0x223b2d },
	{ 0x5a7c, 0x223b21 },
	{ 0x5a7d, 0x223b2e },
	{ 0x5a7e, 0x233a7c },
	{ 0x5a7f, 0x215e67 },
	{ 0x5a80, 0x233a63 },
	{ 0x5a81, 0x233a61 },
	{ 0x5a82, 0x233a58 },
	{ 0x5a83, 0x223b2a },
	{ 0x5a84, 0x223b27 },
	{ 0x5a85, 0x233a5b },
	{ 0x5a86, 0x233a77 },
	{ 0x5a87, 0x233a72 },
	{ 0x5a88, 0x233a59 },
	{ 0x5a89, 0x233a60 },
	{ 0x5a8a, 0x223b28 },
	{ 0x5a8b, 0x223b2b },
	{ 0x5a8c, 0x223b2f },
	{ 0x5a8d, 0x233a7b },
	{ 0x5a8e, 0x223466 },
	{ 0x5a8f, 0x223b31 },
	{ 0x5a90, 0x22424d },
	{ 0x5a91, 0x233a66 },
	{ 0x5a92, 0x215e68 },
	{ 0x5a93, 0x223b32 },
	{ 0x5a94, 0x223a78 },
	{ 0x5a95, 0x223b24 },
	{ 0x5a96, 0x233a62 },
	{ 0x5a97, 0x223b29 },
	{ 0x5a98, 0x233a5c },
	{ 0x5a99, 0x233a5e },
	{ 0x5a9a, 0x215e66 },
	{ 0x5a9b, 0x215e69 },
	{ 0x5a9c, 0x223b30 },
	{ 0x5a9d, 0x223b33 },
	{ 0x5a9e, 0x223a7c },
	{ 0x5a9f, 0x223a79 },
	{ 0x5aa0, 0x233a73 },
	{ 0x5aa1, 0x233a5a },
	{ 0x5aa2, 0x223a7b },
	{ 0x5aa3, 0x233a57 },
	{ 0x5aa4, 0x233a7a },
	{ 0x5aa5, 0x223b22 },
	{ 0x5aa6, 0x223a7e },
	{ 0x5aa7, 0x215e6a },
	{ 0x5aa8, 0x233a56 },
	{ 0x5aa9, 0x223b2c },
	{ 0x5aaa, 0x233a79 },
	{ 0x5aab, 0x233a78 },
	{ 0x5aac, 0x223b23 },
	{ 0x5aae, 0x223b25 },
	{ 0x5aaf, 0x223a77 },
	{ 0x5ab0, 0x224241 },
	{ 0x5ab1, 0x22423f },
	{ 0x5ab2, 0x216368 },
	{ 0x5ab3, 0x216366 },
	{ 0x5ab4, 0x224249 },
	{ 0x5ab5, 0x224240 },
	{ 0x5ab6, 0x22424a },
	{ 0x5ab7, 0x224246 },
	{ 0x5ab8, 0x22423e },
	{ 0x5ab9, 0x22424c },
	{ 0x5aba, 0x22423d },
	{ 0x5abb, 0x224244 },
	{ 0x5abc, 0x216365 },
	{ 0x5abd, 0x216364 },
	{ 0x5abe, 0x216363 },
	{ 0x5abf, 0x224242 },
	{ 0x5ac0, 0x224247 },
	{ 0x5ac1, 0x216360 },
	{ 0x5ac2, 0x216367 },
	{ 0x5ac3, 0x234067 },
	{ 0x5ac4, 0x22423b },
	{ 0x5ac5, 0x234066 },
	{ 0x5ac6, 0x224245 },
	{ 0x5ac7, 0x22423a },
	{ 0x5ac8, 0x224243 },
	{ 0x5ac9, 0x216361 },
	{ 0x5aca, 0x224248 },
	{ 0x5acb, 0x22423c },
	{ 0x5acc, 0x216362 },
	{ 0x5acd, 0x22424b },
	{ 0x5ace, 0x234064 },
	{ 0x5acf, 0x233a6b },
	{ 0x5ad0, 0x23406a },
	{ 0x5ad1, 0x236468 },
	{ 0x5ad3, 0x236469 },
	{ 0x5ad5, 0x224955 },
	{ 0x5ad6, 0x21684a },
	{ 0x5ad7, 0x216849 },
	{ 0x5ad8, 0x21684b },
	{ 0x5ad9, 0x224961 },
	{ 0x5ada, 0x224957 },
	{ 0x5adb, 0x22495d },
	{ 0x5adc, 0x224952 },
	{ 0x5add, 0x224960 },
	{ 0x5ade, 0x22495f },
	{ 0x5adf, 0x224963 },
	{ 0x5ae0, 0x22495c },
	{ 0x5ae1, 0x216846 },
	{ 0x5ae2, 0x22495b },
	{ 0x5ae3, 0x21684c },
	{ 0x5ae4, 0x23464c },
	{ 0x5ae5, 0x224954 },
	{ 0x5ae6, 0x216847 },
	{ 0x5ae7, 0x23464a },
	{ 0x5ae8, 0x224962 },
	{ 0x5ae9, 0x216848 },
	{ 0x5aea, 0x224956 },
	{ 0x5aeb, 0x224959 },
	{ 0x5aec, 0x22495e },
	{ 0x5aed, 0x224958 },
	{ 0x5aee, 0x224953 },
	{ 0x5aef, 0x23464f },
	{ 0x5af0, 0x234653 },
	{ 0x5af3, 0x22495a },
	{ 0x5af4, 0x224f7c },
	{ 0x5af5, 0x216c4b },
	{ 0x5af6, 0x225021 },
	{ 0x5af7, 0x224f7e },
	{ 0x5af8, 0x225023 },
	{ 0x5af9, 0x225025 },
	{ 0x5afa, 0x234b5c },
	{ 0x5afb, 0x216c49 },
	{ 0x5afc, 0x234b58 },
	{ 0x5afd, 0x224f7d },
	{ 0x5afe, 0x234b54 },
	{ 0x5aff, 0x224f7b },
	{ 0x5b00, 0x234b5e },
	{ 0x5b01, 0x225026 },
	{ 0x5b02, 0x225024 },
	{ 0x5b03, 0x225022 },
	{ 0x5b04, 0x234b56 },
	{ 0x5b05, 0x225028 },
	{ 0x5b06, 0x234b5a },
	{ 0x5b07, 0x225027 },
	{ 0x5b08, 0x216c4d },
	{ 0x5b09, 0x216c48 },
	{ 0x5b0a, 0x234b5b },
	{ 0x5b0b, 0x216c4a },
	{ 0x5b0c, 0x216c4c },
	{ 0x5b0d, 0x234b5d },
	{ 0x5b0e, 0x234b5f },
	{ 0x5b0f, 0x225029 },
	{ 0x5b10, 0x225661 },
	{ 0x5b11, 0x235050 },
	{ 0x5b12, 0x235053 },
	{ 0x5b13, 0x225660 },
	{ 0x5b14, 0x22565f },
	{ 0x5b15, 0x235051 },
	{ 0x5b16, 0x225662 },
	{ 0x5b17, 0x22565b },
	{ 0x5b18, 0x23504f },
	{ 0x5b19, 0x22565c },
	{ 0x5b1a, 0x225664 },
	{ 0x5b1b, 0x22565d },
	{ 0x5b1c, 0x235054 },
	{ 0x5b1d, 0x21704e },
	{ 0x5b1e, 0x225666 },
	{ 0x5b1f, 0x23504e },
	{ 0x5b20, 0x225665 },
	{ 0x5b21, 0x22565e },
	{ 0x5b22, 0x235056 },
	{ 0x5b23, 0x225c5d },
	{ 0x5b24, 0x217351 },
	{ 0x5b25, 0x225c5b },
	{ 0x5b26, 0x225c60 },
	{ 0x5b27, 0x225c5f },
	{ 0x5b28, 0x225663 },
	{ 0x5b29, 0x235450 },
	{ 0x5b2a, 0x217350 },
	{ 0x5b2b, 0x23544e },
	{ 0x5b2c, 0x225c5e },
	{ 0x5b2d, 0x225c5a },
	{ 0x5b2e, 0x225c62 },
	{ 0x5b2f, 0x225c61 },
	{ 0x5b30, 0x21734f },
	{ 0x5b31, 0x235452 },
	{ 0x5b32, 0x225c5c },
	{ 0x5b33, 0x23544f },
	{ 0x5b34, 0x21704f },
	{ 0x5b35, 0x235451 },
	{ 0x5b37, 0x235453 },
	{ 0x5b38, 0x217640 },
	{ 0x5b39, 0x235a31 },
	{ 0x5b3a, 0x235761 },
	{ 0x5b3b, 0x23575e },
	{ 0x5b3c, 0x22614d },
	{ 0x5b3d, 0x226546 },
	{ 0x5b3e, 0x226547 },
	{ 0x5b3f, 0x226548 },
	{ 0x5b40, 0x217967 },
	{ 0x5b42, 0x235c36 },
	{ 0x5b43, 0x217968 },
	{ 0x5b44, 0x235c39 },
	{ 0x5b45, 0x22686f },
	{ 0x5b46, 0x235c3a },
	{ 0x5b47, 0x226b56 },
	{ 0x5b48, 0x226b55 },
	{ 0x5b49, 0x235e29 },
	{ 0x5b4a, 0x235f42 },
	{ 0x5b4b, 0x226d49 },
	{ 0x5b4c, 0x226d4a },
	{ 0x5b4d, 0x226f24 },
	{ 0x5b4e, 0x227035 },
	{ 0x5b4f, 0x236073 },
	{ 0x5b50, 0x21444d },
	{ 0x5b51, 0x21444e },
	{ 0x5b53, 0x21444f },
	{ 0x5b54, 0x214536 },
	{ 0x5b55, 0x214645 },
	{ 0x5b56, 0x222233 },
	{ 0x5b57, 0x214773 },
	{ 0x5b58, 0x214774 },
	{ 0x5b5a, 0x214977 },
	{ 0x5b5b, 0x214978 },
	{ 0x5b5c, 0x214976 },
	{ 0x5b5d, 0x214975 },
	{ 0x5b5f, 0x214c75 },
	{ 0x5b60, 0x232848 },
	{ 0x5b62, 0x222636 },
	{ 0x5b63, 0x214c77 },
	{ 0x5b64, 0x214c76 },
	{ 0x5b65, 0x222637 },
	{ 0x5b66, 0x23625c },
	{ 0x5b67, 0x23646a },
	{ 0x5b69, 0x215066 },
	{ 0x5b6a, 0x232c2f },
	{ 0x5b6b, 0x215521 },
	{ 0x5b6c, 0x222e67 },
	{ 0x5b6e, 0x223473 },
	{ 0x5b70, 0x215969 },
	{ 0x5b71, 0x215e6c },
	{ 0x5b72, 0x223472 },
	{ 0x5b73, 0x215e6b },
	{ 0x5b74, 0x234071 },
	{ 0x5b75, 0x21684d },
	{ 0x5b76, 0x234072 },
	{ 0x5b77, 0x224964 },
	{ 0x5b78, 0x217050 },
	{ 0x5b79, 0x235057 },
	{ 0x5b7a, 0x217352 },
	{ 0x5b7b, 0x225c63 },
	{ 0x5b7c, 0x235a34 },
	{ 0x5b7d, 0x217969 },
	{ 0x5b7e, 0x235c3b },
	{ 0x5b7f, 0x217b5c },
	{ 0x5b80, 0x23213b },
	{ 0x5b81, 0x222153 },
	{ 0x5b82, 0x23223d },
	{ 0x5b83, 0x214646 },
	{ 0x5b84, 0x222154 },
	{ 0x5b85, 0x214777 },
	{ 0x5b86, 0x232350 },
	{ 0x5b87, 0x214775 },
	{ 0x5b88, 0x214776 },
	{ 0x5b89, 0x214778 },
	{ 0x5b8b, 0x21497a },
	{ 0x5b8c, 0x214979 },
	{ 0x5b8d, 0x23255a },
	{ 0x5b8e, 0x22235c },
	{ 0x5b8f, 0x21497b },
	{ 0x5b92, 0x22235d },
	{ 0x5b93, 0x222638 },
	{ 0x5b94, 0x23284c },
	{ 0x5b95, 0x222639 },
	{ 0x5b96, 0x23284a },
	{ 0x5b97, 0x214c78 },
	{ 0x5b98, 0x214c7a },
	{ 0x5b99, 0x214c7c },
	{ 0x5b9a, 0x214c79 },
	{ 0x5b9b, 0x214c7d },
	{ 0x5b9c, 0x214c7b },
	{ 0x5b9d, 0x23284e },
	{ 0x5b9e, 0x23284b },
	{ 0x5b9f, 0x23284d },
	{ 0x5ba2, 0x21506a },
	{ 0x5ba3, 0x215067 },
	{ 0x5ba4, 0x215069 },
	{ 0x5ba5, 0x21506b },
	{ 0x5ba6, 0x215068 },
	{ 0x5ba7, 0x222e68 },
	{ 0x5ba8, 0x222978 },
	{ 0x5bab, 0x232c32 },
	{ 0x5bac, 0x222e6a },
	{ 0x5bad, 0x222e69 },
	{ 0x5bae, 0x215527 },
	{ 0x5bb0, 0x215523 },
	{ 0x5bb3, 0x215524 },
	{ 0x5bb4, 0x215526 },
	{ 0x5bb5, 0x215528 },
	{ 0x5bb6, 0x215525 },
	{ 0x5bb7, 0x233057 },
	{ 0x5bb8, 0x21552a },
	{ 0x5bb9, 0x215529 },
	{ 0x5bbb, 0x233056 },
	{ 0x5bbc, 0x233055 },
	{ 0x5bbf, 0x21596e },
	{ 0x5bc0, 0x223475 },
	{ 0x5bc1, 0x223474 },
	{ 0x5bc2, 0x21596d },
	{ 0x5bc3, 0x233541 },
	{ 0x5bc4, 0x21596c },
	{ 0x5bc5, 0x21596b },
	{ 0x5bc6, 0x21596f },
	{ 0x5bc7, 0x21596a },
	{ 0x5bc8, 0x23353f },
	{ 0x5bca, 0x223b39 },
	{ 0x5bcb, 0x223b36 },
	{ 0x5bcc, 0x215e6e },
	{ 0x5bcd, 0x223b35 },
	{ 0x5bce, 0x223b3a },
	{ 0x5bd0, 0x215e70 },
	{ 0x5bd1, 0x223b38 },
	{ 0x5bd2, 0x215e6d },
	{ 0x5bd3, 0x215e6f },
	{ 0x5bd4, 0x223b37 },
	{ 0x5bd5, 0x233a7e },
	{ 0x5bd6, 0x22424e },
	{ 0x5bd7, 0x234074 },
	{ 0x5bd8, 0x22424f },
	{ 0x5bd9, 0x224250 },
	{ 0x5bda, 0x234075 },
	{ 0x5bdb, 0x234076 },
	{ 0x5bdc, 0x234073 },
	{ 0x5bdd, 0x236345 },
	{ 0x5bde, 0x21684e },
	{ 0x5bdf, 0x216856 },
	{ 0x5be0, 0x224965 },
	{ 0x5be1, 0x216850 },
	{ 0x5be2, 0x216854 },
	{ 0x5be3, 0x224966 },
	{ 0x5be4, 0x216855 },
	{ 0x5be5, 0x216851 },
	{ 0x5be6, 0x216852 },
	{ 0x5be7, 0x21684f },
	{ 0x5be8, 0x216853 },
	{ 0x5be9, 0x216c50 },
	{ 0x5bea, 0x223b34 },
	{ 0x5beb, 0x216c51 },
	{ 0x5bec, 0x216c4f },
	{ 0x5bee, 0x216c4e },
	{ 0x5bef, 0x225667 },
	{ 0x5bf0, 0x217051 },
	{ 0x5bf1, 0x225c64 },
	{ 0x5bf2, 0x225c65 },
	{ 0x5bf3, 0x235a35 },
	{ 0x5bf5, 0x217831 },
	{ 0x5bf6, 0x21796a },
	{ 0x5bf7, 0x235e2a },
	{ 0x5bf8, 0x214450 },
	{ 0x5bf9, 0x23223e },
	{ 0x5bfa, 0x214779 },
	{ 0x5bfd, 0x23255e },
	{ 0x5bfe, 0x23255c },
	{ 0x5bff, 0x23255d },
	{ 0x5c00, 0x232850 },
	{ 0x5c01, 0x21506c },
	{ 0x5c03, 0x222e6b },
	{ 0x5c04, 0x21552b },
	{ 0x5c05, 0x233058 },
	{ 0x5c06, 0x233059 },
	{ 0x5c07, 0x215972 },
	{ 0x5c08, 0x215971 },
	{ 0x5c09, 0x215970 },
	{ 0x5c0a, 0x215e71 },
	{ 0x5c0b, 0x215e72 },
	{ 0x5c0c, 0x223b3b },
	{ 0x5c0d, 0x216857 },
	{ 0x5c0e, 0x217052 },
	{ 0x5c0f, 0x214451 },
	{ 0x5c10, 0x22213c },
	{ 0x5c11, 0x214537 },
	{ 0x5c12, 0x222155 },
	{ 0x5c13, 0x23624a },
	{ 0x5c14, 0x23223f },
	{ 0x5c15, 0x222234 },
	{ 0x5c16, 0x21477a },
	{ 0x5c18, 0x232352 },
	{ 0x5c19, 0x232851 },
	{ 0x5c1a, 0x214c7e },
	{ 0x5c1b, 0x232c34 },
	{ 0x5c1e, 0x233b24 },
	{ 0x5c1f, 0x224251 },
	{ 0x5c20, 0x234078 },
	{ 0x5c21, 0x236525 },
	{ 0x5c22, 0x214452 },
	{ 0x5c24, 0x214538 },
	{ 0x5c25, 0x222235 },
	{ 0x5c28, 0x22235e },
	{ 0x5c2a, 0x22235f },
	{ 0x5c2b, 0x23255f },
	{ 0x5c2c, 0x21497c },
	{ 0x5c2f, 0x232c35 },
	{ 0x5c30, 0x223b3c },
	{ 0x5c31, 0x215e73 },
	{ 0x5c33, 0x224252 },
	{ 0x5c36, 0x235454 },
	{ 0x5c37, 0x217353 },
	{ 0x5c38, 0x214453 },
	{ 0x5c39, 0x214467 },
	{ 0x5c3a, 0x214539 },
	{ 0x5c3b, 0x222156 },
	{ 0x5c3c, 0x214647 },
	{ 0x5c3d, 0x232354 },
	{ 0x5c3e, 0x214a22 },
	{ 0x5c3f, 0x214a21 },
	{ 0x5c40, 0x21497d },
	{ 0x5c41, 0x21497e },
	{ 0x5c44, 0x22263a },
	{ 0x5c45, 0x214d22 },
	{ 0x5c46, 0x214d23 },
	{ 0x5c47, 0x22263b },
	{ 0x5c48, 0x214d21 },
	{ 0x5c49, 0x232854 },
	{ 0x5c4a, 0x232855 },
	{ 0x5c4b, 0x215070 },
	{ 0x5c4c, 0x222979 },
	{ 0x5c4d, 0x21506f },
	{ 0x5c4e, 0x21506d },
	{ 0x5c4f, 0x21506e },
	{ 0x5c50, 0x21552e },
	{ 0x5c51, 0x21552c },
	{ 0x5c52, 0x23305a },
	{ 0x5c53, 0x23305b },
	{ 0x5c54, 0x222e6d },
	{ 0x5c55, 0x21552d },
	{ 0x5c56, 0x222e6c },
	{ 0x5c57, 0x23646b },
	{ 0x5c58, 0x215522 },
	{ 0x5c59, 0x223476 },
	{ 0x5c5b, 0x233543 },
	{ 0x5c5c, 0x215974 },
	{ 0x5c5d, 0x215975 },
	{ 0x5c5e, 0x233b26 },
	{ 0x5c5f, 0x233b25 },
	{ 0x5c60, 0x215973 },
	{ 0x5c61, 0x233544 },
	{ 0x5c62, 0x216858 },
	{ 0x5c63, 0x224967 },
	{ 0x5c64, 0x216c52 },
	{ 0x5c65, 0x216c53 },
	{ 0x5c67, 0x22502a },
	{ 0x5c68, 0x217354 },
	{ 0x5c69, 0x22614e },
	{ 0x5c6a, 0x22614f },
	{ 0x5c6b, 0x235a38 },
	{ 0x5c6c, 0x217a68 },
	{ 0x5c6d, 0x227036 },
	{ 0x5c6e, 0x22212b },
	{ 0x5c6f, 0x21453a },
	{ 0x5c71, 0x214454 },
	{ 0x5c73, 0x222158 },
	{ 0x5c74, 0x222157 },
	{ 0x5c77, 0x23646c },
	{ 0x5c78, 0x232355 },
	{ 0x5c79, 0x21477b },
	{ 0x5c7a, 0x222237 },
	{ 0x5c7b, 0x222238 },
	{ 0x5c7c, 0x222236 },
	{ 0x5c7e, 0x222239 },
	{ 0x5c80, 0x23235a },
	{ 0x5c84, 0x232561 },
	{ 0x5c85, 0x232566 },
	{ 0x5c86, 0x222367 },
	{ 0x5c88, 0x222362 },
	{ 0x5c89, 0x222364 },
	{ 0x5c8a, 0x222366 },
	{ 0x5c8b, 0x222363 },
	{ 0x5c8c, 0x214a26 },
	{ 0x5c8d, 0x222360 },
	{ 0x5c8e, 0x232562 },
	{ 0x5c8f, 0x222361 },
	{ 0x5c90, 0x214a23 },
	{ 0x5c91, 0x214a24 },
	{ 0x5c92, 0x222365 },
	{ 0x5c93, 0x222368 },
	{ 0x5c94, 0x214a25 },
	{ 0x5c95, 0x222369 },
	{ 0x5c9c, 0x232563 },
	{ 0x5c9d, 0x222649 },
	{ 0x5c9e, 0x23285d },
	{ 0x5c9f, 0x222643 },
	{ 0x5ca0, 0x22263e },
	{ 0x5ca1, 0x214d25 },
	{ 0x5ca2, 0x222646 },
	{ 0x5ca3, 0x222644 },
	{ 0x5ca4, 0x22263d },
	{ 0x5ca5, 0x22264a },
	{ 0x5ca6, 0x22264d },
	{ 0x5ca7, 0x222648 },
	{ 0x5ca8, 0x222641 },
	{ 0x5ca9, 0x214d27 },
	{ 0x5caa, 0x222647 },
	{ 0x5cab, 0x214d28 },
	{ 0x5cac, 0x222642 },
	{ 0x5cad, 0x222645 },
	{ 0x5cae, 0x22263c },
	{ 0x5caf, 0x222640 },
	{ 0x5cb0, 0x22264c },
	{ 0x5cb1, 0x214d29 },
	{ 0x5cb3, 0x214d2a },
	{ 0x5cb4, 0x23285e },
	{ 0x5cb5, 0x22263f },
	{ 0x5cb6, 0x22264b },
	{ 0x5cb7, 0x214d24 },
	{ 0x5cb8, 0x214d26 },
	{ 0x5cb9, 0x23285c },
	{ 0x5cba, 0x23285f },
	{ 0x5cbb, 0x232857 },
	{ 0x5cc1, 0x232858 },
	{ 0x5cc6, 0x222a2c },
	{ 0x5cc7, 0x222a25 },
	{ 0x5cc8, 0x222a2b },
	{ 0x5cc9, 0x222a24 },
	{ 0x5cca, 0x222a26 },
	{ 0x5ccb, 0x22297e },
	{ 0x5ccc, 0x22297c },
	{ 0x5ccd, 0x232c3f },
	{ 0x5cce, 0x222a2d },
	{ 0x5ccf, 0x222a2a },
	{ 0x5cd0, 0x22297a },
	{ 0x5cd1, 0x232c3b },
	{ 0x5cd2, 0x215072 },
	{ 0x5cd3, 0x222a28 },
	{ 0x5cd4, 0x222a29 },
	{ 0x5cd5, 0x23646d },
	{ 0x5cd6, 0x222a27 },
	{ 0x5cd7, 0x22297d },
	{ 0x5cd8, 0x22297b },
	{ 0x5cd9, 0x215071 },
	{ 0x5cda, 0x222a23 },
	{ 0x5cdb, 0x222a21 },
	{ 0x5cdc, 0x232c3c },
	{ 0x5cdd, 0x232c42 },
	{ 0x5cde, 0x222a22 },
	{ 0x5cdf, 0x222a2e },
	{ 0x5ce1, 0x232c3e },
	{ 0x5ce2, 0x232c41 },
	{ 0x5ce5, 0x232c43 },
	{ 0x5ce6, 0x232c3d },
	{ 0x5ce8, 0x215533 },
	{ 0x5ce9, 0x233063 },
	{ 0x5cea, 0x215532 },
	{ 0x5ceb, 0x23305f },
	{ 0x5cec, 0x222e6e },
	{ 0x5ced, 0x21552f },
	{ 0x5cee, 0x222e70 },
	{ 0x5cef, 0x233064 },
	{ 0x5cf0, 0x215534 },
	{ 0x5cf1, 0x222e71 },
	{ 0x5cf3, 0x233061 },
	{ 0x5cf4, 0x215537 },
	{ 0x5cf5, 0x233062 },
	{ 0x5cf6, 0x215535 },
	{ 0x5cf7, 0x222e72 },
	{ 0x5cf8, 0x222a2f },
	{ 0x5cf9, 0x222e74 },
	{ 0x5cfa, 0x23305e },
	{ 0x5cfb, 0x215531 },
	{ 0x5cfc, 0x236271 },
	{ 0x5cfd, 0x215530 },
	{ 0x5cfe, 0x236272 },
	{ 0x5cff, 0x222e6f },
	{ 0x5d00, 0x222e73 },
	{ 0x5d01, 0x215536 },
	{ 0x5d06, 0x215977 },
	{ 0x5d07, 0x215976 },
	{ 0x5d08, 0x23354b },
	{ 0x5d09, 0x233548 },
	{ 0x5d0a, 0x233547 },
	{ 0x5d0b, 0x223478 },
	{ 0x5d0c, 0x22347c },
	{ 0x5d0d, 0x22347e },
	{ 0x5d0e, 0x215978 },
	{ 0x5d0f, 0x223523 },
	{ 0x5d10, 0x233551 },
	{ 0x5d11, 0x21597c },
	{ 0x5d12, 0x223525 },
	{ 0x5d13, 0x233552 },
	{ 0x5d14, 0x21597e },
	{ 0x5d15, 0x23354f },
	{ 0x5d16, 0x21597a },
	{ 0x5d17, 0x215a24 },
	{ 0x5d18, 0x233555 },
	{ 0x5d19, 0x215a21 },
	{ 0x5d1a, 0x22347a },
	{ 0x5d1b, 0x215979 },
	{ 0x5d1c, 0x233b2b },
	{ 0x5d1d, 0x223479 },
	{ 0x5d1e, 0x223477 },
	{ 0x5d1f, 0x223527 },
	{ 0x5d20, 0x22347b },
	{ 0x5d21, 0x233546 },
	{ 0x5d22, 0x21597b },
	{ 0x5d23, 0x223526 },
	{ 0x5d24, 0x215a22 },
	{ 0x5d25, 0x223522 },
	{ 0x5d26, 0x223521 },
	{ 0x5d27, 0x215a23 },
	{ 0x5d28, 0x22347d },
	{ 0x5d29, 0x21597d },
	{ 0x5d2a, 0x23354e },
	{ 0x5d2c, 0x23354a },
	{ 0x5d2e, 0x223528 },
	{ 0x5d2f, 0x233554 },
	{ 0x5d30, 0x223524 },
	{ 0x5d31, 0x223b4b },
	{ 0x5d32, 0x223b52 },
	{ 0x5d33, 0x223b47 },
	{ 0x5d34, 0x215e76 },
	{ 0x5d35, 0x223b43 },
	{ 0x5d36, 0x223b53 },
	{ 0x5d37, 0x223b3d },
	{ 0x5d38, 0x223b50 },
	{ 0x5d39, 0x223b4e },
	{ 0x5d3a, 0x223b48 },
	{ 0x5d3b, 0x233b36 },
	{ 0x5d3c, 0x223b51 },
	{ 0x5d3d, 0x223b4a },
	{ 0x5d3e, 0x233b28 },
	{ 0x5d3f, 0x223b42 },
	{ 0x5d40, 0x223b54 },
	{ 0x5d41, 0x223b40 },
	{ 0x5d42, 0x223b4d },
	{ 0x5d43, 0x223b3e },
	{ 0x5d44, 0x233b27 },
	{ 0x5d45, 0x223b55 },
	{ 0x5d46, 0x233b37 },
	{ 0x5d47, 0x215e77 },
	{ 0x5d48, 0x233b2a },
	{ 0x5d49, 0x223b4f },
	{ 0x5d4a, 0x224255 },
	{ 0x5d4b, 0x223b41 },
	{ 0x5d4c, 0x215e74 },
	{ 0x5d4d, 0x233b2e },
	{ 0x5d4e, 0x223b45 },
	{ 0x5d4f, 0x233b34 },
	{ 0x5d50, 0x215e75 },
	{ 0x5d51, 0x223b44 },
	{ 0x5d52, 0x223b49 },
	{ 0x5d53, 0x233b33 },
	{ 0x5d55, 0x223b46 },
	{ 0x5d57, 0x233b31 },
	{ 0x5d59, 0x223b4c },
	{ 0x5d5b, 0x233b2d },
	{ 0x5d5e, 0x224259 },
	{ 0x5d60, 0x234121 },
	{ 0x5d62, 0x22425c },
	{ 0x5d63, 0x224254 },
	{ 0x5d64, 0x23407c },
	{ 0x5d65, 0x224256 },
	{ 0x5d66, 0x23407a },
	{ 0x5d67, 0x22425b },
	{ 0x5d68, 0x22425a },
	{ 0x5d69, 0x216369 },
	{ 0x5d6b, 0x223b3f },
	{ 0x5d6c, 0x224258 },
	{ 0x5d6d, 0x234079 },
	{ 0x5d6e, 0x23407d },
	{ 0x5d6f, 0x21636a },
	{ 0x5d71, 0x224253 },
	{ 0x5d72, 0x224257 },
	{ 0x5d75, 0x23646e },
	{ 0x5d77, 0x22496e },
	{ 0x5d78, 0x23465c },
	{ 0x5d79, 0x224975 },
	{ 0x5d7a, 0x22496c },
	{ 0x5d7b, 0x234654 },
	{ 0x5d7c, 0x224973 },
	{ 0x5d7d, 0x22496a },
	{ 0x5d7e, 0x224972 },
	{ 0x5d7f, 0x224976 },
	{ 0x5d80, 0x224969 },
	{ 0x5d81, 0x22496d },
	{ 0x5d82, 0x224968 },
	{ 0x5d83, 0x234656 },
	{ 0x5d84, 0x216859 },
	{ 0x5d86, 0x22496b },
	{ 0x5d87, 0x21685a },
	{ 0x5d88, 0x224971 },
	{ 0x5d89, 0x224970 },
	{ 0x5d8a, 0x22496f },
	{ 0x5d8b, 0x234659 },
	{ 0x5d8c, 0x23465a },
	{ 0x5d8d, 0x224974 },
	{ 0x5d8e, 0x23646f },
	{ 0x5d8f, 0x234b65 },
	{ 0x5d90, 0x234b66 },
	{ 0x5d91, 0x234b63 },
	{ 0x5d92, 0x22502e },
	{ 0x5d93, 0x225030 },
	{ 0x5d94, 0x216c55 },
	{ 0x5d95, 0x225031 },
	{ 0x5d96, 0x234b6b },
	{ 0x5d97, 0x22502c },
	{ 0x5d98, 0x234b67 },
	{ 0x5d99, 0x22502b },
	{ 0x5d9a, 0x225035 },
	{ 0x5d9b, 0x234b69 },
	{ 0x5d9c, 0x225033 },
	{ 0x5d9d, 0x216c54 },
	{ 0x5d9e, 0x225036 },
	{ 0x5d9f, 0x22502d },
	{ 0x5da0, 0x225032 },
	{ 0x5da1, 0x225034 },
	{ 0x5da2, 0x22502f },
	{ 0x5da3, 0x234b6a },
	{ 0x5da4, 0x234b68 },
	{ 0x5da5, 0x236470 },
	{ 0x5da6, 0x235058 },
	{ 0x5da7, 0x22566b },
	{ 0x5da8, 0x225670 },
	{ 0x5da9, 0x22566a },
	{ 0x5daa, 0x22566f },
	{ 0x5dab, 0x23505b },
	{ 0x5dac, 0x225668 },
	{ 0x5dad, 0x225672 },
	{ 0x5dae, 0x22566e },
	{ 0x5daf, 0x225673 },
	{ 0x5db0, 0x22566d },
	{ 0x5db1, 0x225669 },
	{ 0x5db2, 0x225671 },
	{ 0x5db3, 0x23505a },
	{ 0x5db4, 0x225674 },
	{ 0x5db5, 0x22566c },
	{ 0x5db6, 0x236471 },
	{ 0x5db7, 0x225c66 },
	{ 0x5db8, 0x217358 },
	{ 0x5db9, 0x235457 },
	{ 0x5dba, 0x217356 },
	{ 0x5dbb, 0x235459 },
	{ 0x5dbc, 0x217355 },
	{ 0x5dbd, 0x217357 },
	{ 0x5dbe, 0x235455 },
	{ 0x5dbf, 0x236472 },
	{ 0x5dc0, 0x226150 },
	{ 0x5dc1, 0x235762 },
	{ 0x5dc2, 0x22643e },
	{ 0x5dc3, 0x226549 },
	{ 0x5dc4, 0x235a39 },
	{ 0x5dc6, 0x226870 },
	{ 0x5dc7, 0x226871 },
	{ 0x5dc8, 0x235c3d },
	{ 0x5dc9, 0x21796b },
	{ 0x5dca, 0x235c3c },
	{ 0x5dcb, 0x226b57 },
	{ 0x5dcc, 0x235c3e },
	{ 0x5dcd, 0x217a69 },
	{ 0x5dcf, 0x226b58 },
	{ 0x5dd0, 0x235e2d },
	{ 0x5dd1, 0x226d4c },
	{ 0x5dd2, 0x217b5e },
	{ 0x5dd3, 0x235f43 },
	{ 0x5dd4, 0x217b5d },
	{ 0x5dd5, 0x226d4b },
	{ 0x5dd6, 0x217c35 },
	{ 0x5dd7, 0x236030 },
	{ 0x5dd8, 0x226f25 },
	{ 0x5ddb, 0x23213c },
	{ 0x5ddd, 0x214455 },
	{ 0x5dde, 0x21477c },
	{ 0x5ddf, 0x22223a },
	{ 0x5de0, 0x22236a },
	{ 0x5de1, 0x214b56 },
	{ 0x5de2, 0x215a25 },
	{ 0x5de3, 0x233557 },
	{ 0x5de4, 0x234b6c },
	{ 0x5de5, 0x214456 },
	{ 0x5de6, 0x21464a },
	{ 0x5de7, 0x214649 },
	{ 0x5de8, 0x214648 },
	{ 0x5deb, 0x214a27 },
	{ 0x5dee, 0x215538 },
	{ 0x5df0, 0x22425d },
	{ 0x5df1, 0x214457 },
	{ 0x5df2, 0x214458 },
	{ 0x5df3, 0x214459 },
	{ 0x5df4, 0x21453b },
	{ 0x5df5, 0x232567 },
	{ 0x5df6, 0x232860 },
	{ 0x5df7, 0x215073 },
	{ 0x5df9, 0x222a30 },
	{ 0x5dfa, 0x232c45 },
	{ 0x5dfb, 0x232c44 },
	{ 0x5dfd, 0x215e78 },
	{ 0x5dfe, 0x21445a },
	{ 0x5dff, 0x22213d },
	{ 0x5e00, 0x232163 },
	{ 0x5e02, 0x21464b },
	{ 0x5e03, 0x21464c },
	{ 0x5e04, 0x222159 },
	{ 0x5e06, 0x21477d },
	{ 0x5e08, 0x23235c },
	{ 0x5e09, 0x232568 },
	{ 0x5e0a, 0x22236b },
	{ 0x5e0b, 0x23256b },
	{ 0x5e0c, 0x214a28 },
	{ 0x5e0e, 0x22236c },
	{ 0x5e11, 0x214d30 },
	{ 0x5e12, 0x232862 },
	{ 0x5e13, 0x232861 },
	{ 0x5e14, 0x22264f },
	{ 0x5e15, 0x214d2e },
	{ 0x5e16, 0x214d2d },
	{ 0x5e17, 0x22264e },
	{ 0x5e18, 0x214d2b },
	{ 0x5e19, 0x222650 },
	{ 0x5e1a, 0x214d2c },
	{ 0x5e1b, 0x214d2f },
	{ 0x5e1d, 0x215074 },
	{ 0x5e1e, 0x232c46 },
	{ 0x5e1f, 0x215076 },
	{ 0x5e20, 0x222a34 },
	{ 0x5e21, 0x222a31 },
	{ 0x5e22, 0x222a32 },
	{ 0x5e23, 0x222a33 },
	{ 0x5e24, 0x222a35 },
	{ 0x5e25, 0x215075 },
	{ 0x5e28, 0x222e76 },
	{ 0x5e29, 0x222e75 },
	{ 0x5e2a, 0x233066 },
	{ 0x5e2b, 0x21553a },
	{ 0x5e2c, 0x233069 },
	{ 0x5e2d, 0x215539 },
	{ 0x5e2e, 0x233068 },
	{ 0x5e2f, 0x23306a },
	{ 0x5e30, 0x233067 },
	{ 0x5e32, 0x23355b },
	{ 0x5e33, 0x215a28 },
	{ 0x5e34, 0x22352a },
	{ 0x5e35, 0x233559 },
	{ 0x5e36, 0x215a27 },
	{ 0x5e37, 0x215a29 },
	{ 0x5e38, 0x215a26 },
	{ 0x5e39, 0x233558 },
	{ 0x5e3a, 0x23355a },
	{ 0x5e3d, 0x215e7a },
	{ 0x5e3e, 0x223529 },
	{ 0x5e40, 0x215e7b },
	{ 0x5e41, 0x223b57 },
	{ 0x5e42, 0x233979 },
	{ 0x5e43, 0x215e7c },
	{ 0x5e44, 0x223b56 },
	{ 0x5e45, 0x215e79 },
	{ 0x5e46, 0x233b3a },
	{ 0x5e47, 0x233b3b },
	{ 0x5e48, 0x233b3d },
	{ 0x5e4a, 0x224260 },
	{ 0x5e4b, 0x224262 },
	{ 0x5e4c, 0x21636b },
	{ 0x5e4d, 0x224261 },
	{ 0x5e4e, 0x22425f },
	{ 0x5e4f, 0x22425e },
	{ 0x5e52, 0x23465d },
	{ 0x5e53, 0x224979 },
	{ 0x5e54, 0x21685f },
	{ 0x5e55, 0x21685d },
	{ 0x5e57, 0x21685e },
	{ 0x5e58, 0x224977 },
	{ 0x5e59, 0x224978 },
	{ 0x5e5a, 0x234b6d },
	{ 0x5e5b, 0x21685b },
	{ 0x5e5c, 0x22503a },
	{ 0x5e5d, 0x225038 },
	{ 0x5e5e, 0x234b70 },
	{ 0x5e5f, 0x216c57 },
	{ 0x5e60, 0x225039 },
	{ 0x5e61, 0x216c58 },
	{ 0x5e62, 0x216c56 },
	{ 0x5e63, 0x21685c },
	{ 0x5e65, 0x236473 },
	{ 0x5e66, 0x225677 },
	{ 0x5e67, 0x225675 },
	{ 0x5e68, 0x225676 },
	{ 0x5e69, 0x225037 },
	{ 0x5e6a, 0x225c68 },
	{ 0x5e6b, 0x217359 },
	{ 0x5e6c, 0x225c67 },
	{ 0x5e6d, 0x226151 },
	{ 0x5e6e, 0x226152 },
	{ 0x5e6f, 0x225678 },
	{ 0x5e70, 0x22654a },
	{ 0x5e71, 0x236677 },
	{ 0x5e72, 0x21445b },
	{ 0x5e73, 0x21464d },
	{ 0x5e74, 0x214821 },
	{ 0x5e75, 0x22223b },
	{ 0x5e76, 0x21477e },
	{ 0x5e77, 0x232863 },
	{ 0x5e78, 0x214d31 },
	{ 0x5e79, 0x21636c },
	{ 0x5e7a, 0x23213d },
	{ 0x5e7b, 0x21453c },
	{ 0x5e7c, 0x21464e },
	{ 0x5e7d, 0x215077 },
	{ 0x5e7e, 0x215e7d },
	{ 0x5e7f, 0x23213e },
	{ 0x5e80, 0x22215a },
	{ 0x5e81, 0x232247 },
	{ 0x5e82, 0x22215b },
	{ 0x5e83, 0x232248 },
	{ 0x5e84, 0x22223c },
	{ 0x5e85, 0x236678 },
	{ 0x5e87, 0x214a2a },
	{ 0x5e88, 0x222370 },
	{ 0x5e89, 0x22236e },
	{ 0x5e8a, 0x214a2b },
	{ 0x5e8b, 0x22236d },
	{ 0x5e8c, 0x22236f },
	{ 0x5e8d, 0x222371 },
	{ 0x5e8f, 0x214a29 },
	{ 0x5e90, 0x23256e },
	{ 0x5e92, 0x23256d },
	{ 0x5e95, 0x214d35 },
	{ 0x5e96, 0x214d36 },
	{ 0x5e97, 0x214d33 },
	{ 0x5e98, 0x232865 },
	{ 0x5e99, 0x232867 },
	{ 0x5e9a, 0x214d32 },
	{ 0x5e9b, 0x222a39 },
	{ 0x5e9c, 0x214d34 },
	{ 0x5e9d, 0x232868 },
	{ 0x5ea0, 0x215078 },
	{ 0x5ea1, 0x232c48 },
	{ 0x5ea2, 0x222a38 },
	{ 0x5ea3, 0x222a3a },
	{ 0x5ea4, 0x222a37 },
	{ 0x5ea5, 0x222a3b },
	{ 0x5ea6, 0x215079 },
	{ 0x5ea7, 0x21553d },
	{ 0x5ea8, 0x222e77 },
	{ 0x5ea9, 0x23306c },
	{ 0x5eaa, 0x222e79 },
	{ 0x5eab, 0x21553b },
	{ 0x5eac, 0x222e7a },
	{ 0x5ead, 0x21553c },
	{ 0x5eae, 0x222e78 },
	{ 0x5eaf, 0x23306b },
	{ 0x5eb0, 0x222a36 },
	{ 0x5eb1, 0x22352b },
	{ 0x5eb2, 0x22352e },
	{ 0x5eb3, 0x22352f },
	{ 0x5eb4, 0x22352c },
	{ 0x5eb5, 0x215a2d },
	{ 0x5eb6, 0x215a2c },
	{ 0x5eb7, 0x215a2a },
	{ 0x5eb8, 0x215a2b },
	{ 0x5eb9, 0x22352d },
	{ 0x5eba, 0x233561 },
	{ 0x5ebb, 0x233560 },
	{ 0x5ebd, 0x233b3f },
	{ 0x5ebe, 0x215a2e },
	{ 0x5ebf, 0x233b40 },
	{ 0x5ec0, 0x233b3e },
	{ 0x5ec1, 0x215f21 },
	{ 0x5ec2, 0x215f22 },
	{ 0x5ec4, 0x215f23 },
	{ 0x5ec5, 0x224263 },
	{ 0x5ec6, 0x224265 },
	{ 0x5ec7, 0x224267 },
	{ 0x5ec8, 0x21636e },
	{ 0x5ec9, 0x21636d },
	{ 0x5eca, 0x215e7e },
	{ 0x5ecb, 0x224266 },
	{ 0x5ecc, 0x224264 },
	{ 0x5ecd, 0x236474 },
	{ 0x5ece, 0x22497d },
	{ 0x5ecf, 0x234661 },
	{ 0x5ed0, 0x234660 },
	{ 0x5ed1, 0x22497b },
	{ 0x5ed2, 0x224a23 },
	{ 0x5ed3, 0x216860 },
	{ 0x5ed4, 0x224a24 },
	{ 0x5ed5, 0x224a21 },
	{ 0x5ed6, 0x216861 },
	{ 0x5ed7, 0x22497c },
	{ 0x5ed8, 0x22497a },
	{ 0x5ed9, 0x224a22 },
	{ 0x5eda, 0x216c5a },
	{ 0x5edb, 0x22503c },
	{ 0x5edc, 0x22497e },
	{ 0x5edd, 0x216c5c },
	{ 0x5ede, 0x22503d },
	{ 0x5edf, 0x216c5b },
	{ 0x5ee0, 0x216c5e },
	{ 0x5ee1, 0x22503e },
	{ 0x5ee2, 0x216c59 },
	{ 0x5ee3, 0x216c5d },
	{ 0x5ee5, 0x22567d },
	{ 0x5ee6, 0x22567b },
	{ 0x5ee7, 0x22567a },
	{ 0x5ee8, 0x22567c },
	{ 0x5ee9, 0x225679 },
	{ 0x5eea, 0x23505c },
	{ 0x5eec, 0x217833 },
	{ 0x5eed, 0x236475 },
	{ 0x5eee, 0x226872 },
	{ 0x5eef, 0x226873 },
	{ 0x5ef0, 0x235c3f },
	{ 0x5ef1, 0x226b59 },
	{ 0x5ef2, 0x226d4d },
	{ 0x5ef3, 0x217d22 },
	{ 0x5ef4, 0x23213f },
	{ 0x5ef5, 0x232361 },
	{ 0x5ef6, 0x214d37 },
	{ 0x5ef7, 0x214a2c },
	{ 0x5ef8, 0x232869 },
	{ 0x5ef9, 0x23286b },
	{ 0x5efa, 0x21507a },
	{ 0x5efb, 0x232c4c },
	{ 0x5efc, 0x232c4b },
	{ 0x5efd, 0x23306e },
	{ 0x5efe, 0x21445c },
	{ 0x5eff, 0x21453d },
	{ 0x5f01, 0x21464f },
	{ 0x5f02, 0x22223d },
	{ 0x5f03, 0x23256f },
	{ 0x5f04, 0x214a2d },
	{ 0x5f05, 0x222372 },
	{ 0x5f06, 0x23286d },
	{ 0x5f07, 0x222a3c },
	{ 0x5f08, 0x21507b },
	{ 0x5f0a, 0x216862 },
	{ 0x5f0b, 0x21445d },
	{ 0x5f0c, 0x232164 },
	{ 0x5f0d, 0x232249 },
	{ 0x5f0e, 0x232362 },
	{ 0x5f0f, 0x214822 },
	{ 0x5f11, 0x233b42 },
	{ 0x5f12, 0x21636f },
	{ 0x5f13, 0x21445e },
	{ 0x5f14, 0x21453e },
	{ 0x5f15, 0x21453f },
	{ 0x5f17, 0x214651 },
	{ 0x5f18, 0x214650 },
	{ 0x5f1a, 0x22223e },
	{ 0x5f1b, 0x214823 },
	{ 0x5f1d, 0x222373 },
	{ 0x5f1e, 0x232571 },
	{ 0x5f1f, 0x214a2e },
	{ 0x5f21, 0x23286e },
	{ 0x5f22, 0x222652 },
	{ 0x5f23, 0x222653 },
	{ 0x5f24, 0x222654 },
	{ 0x5f25, 0x232870 },
	{ 0x5f26, 0x214d38 },
	{ 0x5f27, 0x214d39 },
	{ 0x5f28, 0x222651 },
	{ 0x5f29, 0x214d3a },
	{ 0x5f2d, 0x21507c },
	{ 0x5f2e, 0x222a3d },
	{ 0x5f2f, 0x232c4d },
	{ 0x5f30, 0x222e7c },
	{ 0x5f31, 0x21553e },
	{ 0x5f32, 0x23306f },
	{ 0x5f33, 0x222e7b },
	{ 0x5f34, 0x233562 },
	{ 0x5f35, 0x215a2f },
	{ 0x5f36, 0x223530 },
	{ 0x5f37, 0x215a30 },
	{ 0x5f38, 0x223531 },
	{ 0x5f39, 0x233563 },
	{ 0x5f3a, 0x233b47 },
	{ 0x5f3b, 0x233b45 },
	{ 0x5f3c, 0x215f24 },
	{ 0x5f3e, 0x233b44 },
	{ 0x5f40, 0x224268 },
	{ 0x5f42, 0x234122 },
	{ 0x5f43, 0x224a26 },
	{ 0x5f44, 0x224a25 },
	{ 0x5f46, 0x216863 },
	{ 0x5f48, 0x216c5f },
	{ 0x5f49, 0x22503f },
	{ 0x5f4a, 0x217053 },
	{ 0x5f4b, 0x22567e },
	{ 0x5f4c, 0x21735a },
	{ 0x5f4d, 0x235763 },
	{ 0x5f4e, 0x217b5f },
	{ 0x5f4f, 0x226f27 },
	{ 0x5f50, 0x232140 },
	{ 0x5f51, 0x232141 },
	{ 0x5f52, 0x23224a },
	{ 0x5f53, 0x232351 },
	{ 0x5f54, 0x222655 },
	{ 0x5f55, 0x232871 },
	{ 0x5f56, 0x222a3e },
	{ 0x5f57, 0x215a31 },
	{ 0x5f58, 0x223b58 },
	{ 0x5f59, 0x216370 },
	{ 0x5f5a, 0x234123 },
	{ 0x5f5b, 0x23505e },
	{ 0x5f5d, 0x235764 },
	{ 0x5f5e, 0x217641 },
	{ 0x5f60, 0x236164 },
	{ 0x5f61, 0x232142 },
	{ 0x5f62, 0x214a30 },
	{ 0x5f63, 0x232572 },
	{ 0x5f64, 0x214a2f },
	{ 0x5f65, 0x21507d },
	{ 0x5f66, 0x232c50 },
	{ 0x5f67, 0x222e7d },
	{ 0x5f69, 0x215a33 },
	{ 0x5f6a, 0x215d29 },
	{ 0x5f6b, 0x215a34 },
	{ 0x5f6c, 0x215a32 },
	{ 0x5f6d, 0x215f25 },
	{ 0x5f6e, 0x234124 },
	{ 0x5f6f, 0x224a27 },
	{ 0x5f70, 0x216864 },
	{ 0x5f71, 0x216c60 },
	{ 0x5f72, 0x235f45 },
	{ 0x5f73, 0x22212c },
	{ 0x5f74, 0x22223f },
	{ 0x5f76, 0x222375 },
	{ 0x5f77, 0x214a31 },
	{ 0x5f78, 0x222374 },
	{ 0x5f79, 0x214a32 },
	{ 0x5f7c, 0x214d3e },
	{ 0x5f7d, 0x222658 },
	{ 0x5f7e, 0x222657 },
	{ 0x5f7f, 0x214d3d },
	{ 0x5f80, 0x214d3b },
	{ 0x5f81, 0x214d3c },
	{ 0x5f82, 0x222656 },
	{ 0x5f83, 0x232876 },
	{ 0x5f84, 0x232875 },
	{ 0x5f85, 0x215121 },
	{ 0x5f86, 0x222a3f },
	{ 0x5f87, 0x215124 },
	{ 0x5f88, 0x21507e },
	{ 0x5f89, 0x215126 },
	{ 0x5f8a, 0x215122 },
	{ 0x5f8b, 0x215123 },
	{ 0x5f8c, 0x215125 },
	{ 0x5f8d, 0x236264 },
	{ 0x5f8e, 0x233070 },
	{ 0x5f8f, 0x233072 },
	{ 0x5f90, 0x215541 },
	{ 0x5f91, 0x215540 },
	{ 0x5f92, 0x21553f },
	{ 0x5f93, 0x233071 },
	{ 0x5f94, 0x236476 },
	{ 0x5f96, 0x223533 },
	{ 0x5f97, 0x215a35 },
	{ 0x5f98, 0x215a38 },
	{ 0x5f99, 0x215a36 },
	{ 0x5f9a, 0x236477 },
	{ 0x5f9b, 0x223532 },
	{ 0x5f9c, 0x215a3b },
	{ 0x5f9e, 0x215a37 },
	{ 0x5f9f, 0x223534 },
	{ 0x5fa0, 0x215a3a },
	{ 0x5fa1, 0x215a39 },
	{ 0x5fa5, 0x223b5a },
	{ 0x5fa6, 0x223b59 },
	{ 0x5fa7, 0x233b4b },
	{ 0x5fa8, 0x215f28 },
	{ 0x5fa9, 0x215f26 },
	{ 0x5faa, 0x215f27 },
	{ 0x5fab, 0x223b5b },
	{ 0x5fac, 0x216371 },
	{ 0x5fad, 0x22426a },
	{ 0x5fae, 0x216372 },
	{ 0x5faf, 0x224269 },
	{ 0x5fb2, 0x225040 },
	{ 0x5fb3, 0x234663 },
	{ 0x5fb4, 0x234664 },
	{ 0x5fb5, 0x216c62 },
	{ 0x5fb6, 0x224a28 },
	{ 0x5fb7, 0x216c61 },
	{ 0x5fb8, 0x234b72 },
	{ 0x5fb9, 0x216865 },
	{ 0x5fba, 0x236478 },
	{ 0x5fbb, 0x225722 },
	{ 0x5fbc, 0x225721 },
	{ 0x5fbd, 0x21735b },
	{ 0x5fbe, 0x225c69 },
	{ 0x5fbf, 0x22654b },
	{ 0x5fc0, 0x226874 },
	{ 0x5fc1, 0x226875 },
	{ 0x5fc2, 0x235e2f },
	{ 0x5fc3, 0x214540 },
	{ 0x5fc5, 0x214652 },
	{ 0x5fc7, 0x23224d },
	{ 0x5fc8, 0x236251 },
	{ 0x5fc9, 0x22215c },
	{ 0x5fca, 0x23224c },
	{ 0x5fcc, 0x214a34 },
	{ 0x5fcd, 0x214a36 },
	{ 0x5fce, 0x232578 },
	{ 0x5fcf, 0x222242 },
	{ 0x5fd0, 0x222378 },
	{ 0x5fd1, 0x222377 },
	{ 0x5fd2, 0x222376 },
	{ 0x5fd3, 0x232366 },
	{ 0x5fd4, 0x222241 },
	{ 0x5fd5, 0x222240 },
	{ 0x5fd6, 0x214825 },
	{ 0x5fd7, 0x214a35 },
	{ 0x5fd8, 0x214a33 },
	{ 0x5fd9, 0x214824 },
	{ 0x5fda, 0x232367 },
	{ 0x5fdb, 0x232369 },
	{ 0x5fdc, 0x232577 },
	{ 0x5fdd, 0x214d3f },
	{ 0x5fde, 0x222659 },
	{ 0x5fdf, 0x23257b },
	{ 0x5fe0, 0x214d40 },
	{ 0x5fe1, 0x22237d },
	{ 0x5fe3, 0x222421 },
	{ 0x5fe4, 0x22237e },
	{ 0x5fe5, 0x22265a },
	{ 0x5fe6, 0x232576 },
	{ 0x5fe7, 0x232574 },
	{ 0x5fe8, 0x22237a },
	{ 0x5fe9, 0x23287e },
	{ 0x5fea, 0x214a3a },
	{ 0x5feb, 0x214a38 },
	{ 0x5fec, 0x23257c },
	{ 0x5fed, 0x222379 },
	{ 0x5fee, 0x22237b },
	{ 0x5fef, 0x222423 },
	{ 0x5ff0, 0x232622 },
	{ 0x5ff1, 0x214a37 },
	{ 0x5ff2, 0x232621 },
	{ 0x5ff3, 0x22237c },
	{ 0x5ff4, 0x222427 },
	{ 0x5ff5, 0x214d42 },
	{ 0x5ff6, 0x23257d },
	{ 0x5ff7, 0x222424 },
	{ 0x5ff8, 0x214a39 },
	{ 0x5ff9, 0x232623 },
	{ 0x5ffa, 0x222422 },
	{ 0x5ffb, 0x222425 },
	{ 0x5ffc, 0x23257a },
	{ 0x5ffd, 0x214d41 },
	{ 0x5ffe, 0x232575 },
	{ 0x5fff, 0x214d43 },
	{ 0x6000, 0x222426 },
	{ 0x6007, 0x232878 },
	{ 0x6008, 0x232922 },
	{ 0x6009, 0x22266e },
	{ 0x600a, 0x222661 },
	{ 0x600b, 0x22265f },
	{ 0x600c, 0x22266d },
	{ 0x600d, 0x222668 },
	{ 0x600e, 0x21512b },
	{ 0x600f, 0x214d44 },
	{ 0x6010, 0x222669 },
	{ 0x6011, 0x22266c },
	{ 0x6012, 0x215127 },
	{ 0x6013, 0x22266b },
	{ 0x6014, 0x214d45 },
	{ 0x6015, 0x214d4a },
	{ 0x6016, 0x214d48 },
	{ 0x6017, 0x222662 },
	{ 0x6018, 0x236266 },
	{ 0x6019, 0x22265d },
	{ 0x601a, 0x222664 },
	{ 0x601b, 0x214d4f },
	{ 0x601c, 0x22266f },
	{ 0x601d, 0x215128 },
	{ 0x601e, 0x222665 },
	{ 0x6020, 0x215129 },
	{ 0x6021, 0x214d4b },
	{ 0x6022, 0x222667 },
	{ 0x6023, 0x232c5a },
	{ 0x6024, 0x222a4e },
	{ 0x6025, 0x21512a },
	{ 0x6026, 0x22265c },
	{ 0x6027, 0x214d4c },
	{ 0x6028, 0x21512c },
	{ 0x6029, 0x214d4d },
	{ 0x602a, 0x214d49 },
	{ 0x602b, 0x214d4e },
	{ 0x602c, 0x222666 },
	{ 0x602d, 0x22265b },
	{ 0x602e, 0x22266a },
	{ 0x602f, 0x214d46 },
	{ 0x6030, 0x232877 },
	{ 0x6031, 0x232c5b },
	{ 0x6032, 0x22265e },
	{ 0x6033, 0x222663 },
	{ 0x6034, 0x222660 },
	{ 0x6035, 0x214d47 },
	{ 0x6036, 0x23287a },
	{ 0x6037, 0x222a40 },
	{ 0x6039, 0x222a41 },
	{ 0x603d, 0x232921 },
	{ 0x6040, 0x222a4b },
	{ 0x6041, 0x222f23 },
	{ 0x6042, 0x222a4c },
	{ 0x6043, 0x215132 },
	{ 0x6044, 0x222a4f },
	{ 0x6045, 0x222a45 },
	{ 0x6046, 0x215131 },
	{ 0x6047, 0x222a47 },
	{ 0x6048, 0x236267 },
	{ 0x6049, 0x222a48 },
	{ 0x604a, 0x232c60 },
	{ 0x604b, 0x233079 },
	{ 0x604c, 0x222a4a },
	{ 0x604d, 0x21512d },
	{ 0x604e, 0x232c56 },
	{ 0x604f, 0x233073 },
	{ 0x6050, 0x215545 },
	{ 0x6051, 0x232c57 },
	{ 0x6052, 0x232c5d },
	{ 0x6053, 0x222a46 },
	{ 0x6054, 0x222a42 },
	{ 0x6055, 0x215546 },
	{ 0x6056, 0x23307e },
	{ 0x6058, 0x222a50 },
	{ 0x6059, 0x215542 },
	{ 0x605a, 0x222f21 },
	{ 0x605b, 0x222a49 },
	{ 0x605c, 0x232c54 },
	{ 0x605d, 0x222e7e },
	{ 0x605e, 0x222a44 },
	{ 0x605f, 0x222a4d },
	{ 0x6060, 0x232c5f },
	{ 0x6061, 0x232c61 },
	{ 0x6062, 0x215130 },
	{ 0x6063, 0x215543 },
	{ 0x6064, 0x215136 },
	{ 0x6065, 0x215544 },
	{ 0x6066, 0x222a51 },
	{ 0x6067, 0x222f22 },
	{ 0x6068, 0x21512f },
	{ 0x6069, 0x215548 },
	{ 0x606a, 0x215135 },
	{ 0x606b, 0x215134 },
	{ 0x606c, 0x215133 },
	{ 0x606d, 0x215547 },
	{ 0x606e, 0x222a52 },
	{ 0x606f, 0x215549 },
	{ 0x6070, 0x21512e },
	{ 0x6072, 0x222a43 },
	{ 0x6073, 0x23307a },
	{ 0x6074, 0x233078 },
	{ 0x6075, 0x23307b },
	{ 0x607c, 0x232c5c },
	{ 0x607e, 0x233076 },
	{ 0x607f, 0x215a3c },
	{ 0x6080, 0x222f26 },
	{ 0x6081, 0x222f28 },
	{ 0x6083, 0x222f2a },
	{ 0x6084, 0x21554a },
	{ 0x6085, 0x215550 },
	{ 0x6086, 0x223537 },
	{ 0x6087, 0x222f2e },
	{ 0x6088, 0x222f25 },
	{ 0x6089, 0x215a3e },
	{ 0x608a, 0x223535 },
	{ 0x608b, 0x233122 },
	{ 0x608c, 0x21554f },
	{ 0x608d, 0x21554d },
	{ 0x608e, 0x222f30 },
	{ 0x6090, 0x223536 },
	{ 0x6092, 0x222f27 },
	{ 0x6093, 0x233125 },
	{ 0x6094, 0x21554e },
	{ 0x6095, 0x222f2b },
	{ 0x6096, 0x215551 },
	{ 0x6097, 0x222f2d },
	{ 0x6098, 0x233568 },
	{ 0x6099, 0x233074 },
	{ 0x609a, 0x21554c },
	{ 0x609b, 0x222f2c },
	{ 0x609c, 0x222f2f },
	{ 0x609d, 0x222f29 },
	{ 0x609e, 0x233127 },
	{ 0x609f, 0x21554b },
	{ 0x60a0, 0x215a3f },
	{ 0x60a1, 0x233571 },
	{ 0x60a2, 0x222f24 },
	{ 0x60a3, 0x215a3d },
	{ 0x60a4, 0x233572 },
	{ 0x60a6, 0x233123 },
	{ 0x60a7, 0x233128 },
	{ 0x60a8, 0x215a40 },
	{ 0x60a9, 0x233121 },
	{ 0x60aa, 0x23356f },
	{ 0x60ae, 0x233126 },
	{ 0x60b0, 0x223539 },
	{ 0x60b1, 0x223542 },
	{ 0x60b2, 0x215f2b },
	{ 0x60b3, 0x233b54 },
	{ 0x60b4, 0x215a42 },
	{ 0x60b5, 0x215a47 },
	{ 0x60b6, 0x215f2c },
	{ 0x60b7, 0x223544 },
	{ 0x60b8, 0x215a4e },
	{ 0x60b9, 0x223b5d },
	{ 0x60ba, 0x22353a },
	{ 0x60bb, 0x215a46 },
	{ 0x60bc, 0x215a49 },
	{ 0x60bd, 0x215a44 },
	{ 0x60be, 0x223538 },
	{ 0x60bf, 0x223546 },
	{ 0x60c0, 0x223549 },
	{ 0x60c1, 0x223b6c },
	{ 0x60c3, 0x223547 },
	{ 0x60c4, 0x223b61 },
	{ 0x60c5, 0x215a45 },
	{ 0x60c6, 0x215a4c },
	{ 0x60c7, 0x215a50 },
	{ 0x60c8, 0x223541 },
	{ 0x60c9, 0x223b5c },
	{ 0x60ca, 0x223545 },
	{ 0x60cb, 0x215a41 },
	{ 0x60cc, 0x223b5e },
	{ 0x60cd, 0x223548 },
	{ 0x60ce, 0x223b60 },
	{ 0x60cf, 0x22353d },
	{ 0x60d0, 0x23356a },
	{ 0x60d1, 0x215f29 },
	{ 0x60d2, 0x233b56 },
	{ 0x60d3, 0x22353b },
	{ 0x60d4, 0x22353c },
	{ 0x60d5, 0x215a4b },
	{ 0x60d6, 0x233b55 },
	{ 0x60d7, 0x23356e },
	{ 0x60d8, 0x215a4a },
	{ 0x60d9, 0x22353f },
	{ 0x60da, 0x215a4f },
	{ 0x60db, 0x223543 },
	{ 0x60dc, 0x215a48 },
	{ 0x60dd, 0x223540 },
	{ 0x60de, 0x233579 },
	{ 0x60df, 0x215a4d },
	{ 0x60e0, 0x215f2d },
	{ 0x60e1, 0x215f2a },
	{ 0x60e2, 0x223b5f },
	{ 0x60e3, 0x233b58 },
	{ 0x60e4, 0x22353e },
	{ 0x60e5, 0x233b59 },
	{ 0x60e6, 0x215a43 },
	{ 0x60e7, 0x233576 },
	{ 0x60e9, 0x233b5a },
	{ 0x60ea, 0x233b4d },
	{ 0x60ee, 0x233574 },
	{ 0x60f0, 0x215f32 },
	{ 0x60f1, 0x215f36 },
	{ 0x60f2, 0x223b63 },
	{ 0x60f3, 0x216377 },
	{ 0x60f4, 0x215f34 },
	{ 0x60f5, 0x223b67 },
	{ 0x60f6, 0x215f38 },
	{ 0x60f7, 0x22426b },
	{ 0x60f8, 0x223b69 },
	{ 0x60f9, 0x216379 },
	{ 0x60fa, 0x215f30 },
	{ 0x60fb, 0x215f33 },
	{ 0x60fc, 0x223b6a },
	{ 0x60fd, 0x233b5e },
	{ 0x60fe, 0x223b6b },
	{ 0x60ff, 0x223b71 },
	{ 0x6100, 0x215f3a },
	{ 0x6101, 0x21637a },
	{ 0x6103, 0x223b6d },
	{ 0x6104, 0x223b72 },
	{ 0x6105, 0x223b66 },
	{ 0x6106, 0x216426 },
	{ 0x6107, 0x233b4f },
	{ 0x6108, 0x21637b },
	{ 0x6109, 0x215f39 },
	{ 0x610a, 0x223b64 },
	{ 0x610b, 0x223b73 },
	{ 0x610c, 0x233b51 },
	{ 0x610d, 0x216425 },
	{ 0x610e, 0x215f37 },
	{ 0x610f, 0x216374 },
	{ 0x6110, 0x223b70 },
	{ 0x6111, 0x233b5d },
	{ 0x6112, 0x215f3b },
	{ 0x6113, 0x223b68 },
	{ 0x6114, 0x223b62 },
	{ 0x6115, 0x215f31 },
	{ 0x6116, 0x223b65 },
	{ 0x6118, 0x223b6e },
	{ 0x6119, 0x23412b },
	{ 0x611a, 0x216373 },
	{ 0x611b, 0x216378 },
	{ 0x611c, 0x215f2e },
	{ 0x611d, 0x223b6f },
	{ 0x611e, 0x233b61 },
	{ 0x611f, 0x216376 },
	{ 0x6120, 0x233b62 },
	{ 0x6121, 0x233b63 },
	{ 0x6122, 0x233b50 },
	{ 0x6123, 0x215f2f },
	{ 0x6125, 0x236479 },
	{ 0x6127, 0x216424 },
	{ 0x6128, 0x224a2a },
	{ 0x6129, 0x224276 },
	{ 0x612a, 0x234129 },
	{ 0x612b, 0x22426e },
	{ 0x612c, 0x224a29 },
	{ 0x612e, 0x224272 },
	{ 0x612f, 0x224274 },
	{ 0x6130, 0x234127 },
	{ 0x6131, 0x23412c },
	{ 0x6132, 0x224271 },
	{ 0x6133, 0x23466f },
	{ 0x6134, 0x216423 },
	{ 0x6136, 0x224270 },
	{ 0x6137, 0x216427 },
	{ 0x6138, 0x23466e },
	{ 0x613a, 0x234128 },
	{ 0x613b, 0x224a39 },
	{ 0x613c, 0x23466c },
	{ 0x613d, 0x23412e },
	{ 0x613e, 0x216422 },
	{ 0x613f, 0x216867 },
	{ 0x6140, 0x224277 },
	{ 0x6141, 0x224a2b },
	{ 0x6142, 0x23466d },
	{ 0x6143, 0x23412a },
	{ 0x6144, 0x21637e },
	{ 0x6145, 0x22426f },
	{ 0x6146, 0x224273 },
	{ 0x6147, 0x216866 },
	{ 0x6148, 0x216375 },
	{ 0x6149, 0x22426c },
	{ 0x614a, 0x22426d },
	{ 0x614b, 0x216868 },
	{ 0x614c, 0x21637d },
	{ 0x614d, 0x216421 },
	{ 0x614e, 0x21637c },
	{ 0x614f, 0x224275 },
	{ 0x6150, 0x23647a },
	{ 0x6152, 0x224a2f },
	{ 0x6153, 0x224a30 },
	{ 0x6154, 0x224a35 },
	{ 0x6155, 0x216c67 },
	{ 0x6156, 0x224a3c },
	{ 0x6157, 0x234b73 },
	{ 0x6158, 0x21686e },
	{ 0x6159, 0x234b7e },
	{ 0x615a, 0x21686d },
	{ 0x615b, 0x224a37 },
	{ 0x615c, 0x234b74 },
	{ 0x615d, 0x216c66 },
	{ 0x615e, 0x224a2c },
	{ 0x615f, 0x21686c },
	{ 0x6160, 0x234671 },
	{ 0x6161, 0x224a3b },
	{ 0x6162, 0x21686a },
	{ 0x6163, 0x21686b },
	{ 0x6164, 0x234b7c },
	{ 0x6165, 0x224a38 },
	{ 0x6166, 0x225051 },
	{ 0x6167, 0x216c64 },
	{ 0x6168, 0x215f35 },
	{ 0x6169, 0x234672 },
	{ 0x616a, 0x224a3a },
	{ 0x616b, 0x216c6b },
	{ 0x616c, 0x224a32 },
	{ 0x616e, 0x216c65 },
	{ 0x616f, 0x23466a },
	{ 0x6170, 0x216c6a },
	{ 0x6171, 0x224a2d },
	{ 0x6172, 0x224a31 },
	{ 0x6173, 0x224a2e },
	{ 0x6174, 0x224a34 },
	{ 0x6175, 0x21686f },
	{ 0x6176, 0x216c63 },
	{ 0x6177, 0x216869 },
	{ 0x6178, 0x234c21 },
	{ 0x6179, 0x225043 },
	{ 0x617a, 0x224a36 },
	{ 0x617b, 0x234668 },
	{ 0x617c, 0x216c69 },
	{ 0x617d, 0x234673 },
	{ 0x617e, 0x216c6c },
	{ 0x6180, 0x224a33 },
	{ 0x6181, 0x23466b },
	{ 0x6182, 0x216c68 },
	{ 0x6183, 0x225042 },
	{ 0x6185, 0x234c23 },
	{ 0x6186, 0x234674 },
	{ 0x6187, 0x234c24 },
	{ 0x6188, 0x234b77 },
	{ 0x6189, 0x225047 },
	{ 0x618a, 0x217057 },
	{ 0x618b, 0x225041 },
	{ 0x618c, 0x22572e },
	{ 0x618d, 0x225050 },
	{ 0x618e, 0x216c70 },
	{ 0x618f, 0x234b7a },
	{ 0x6190, 0x216c6e },
	{ 0x6191, 0x217055 },
	{ 0x6192, 0x22504d },
	{ 0x6193, 0x225049 },
	{ 0x6194, 0x216c74 },
	{ 0x6195, 0x234b76 },
	{ 0x6196, 0x225725 },
	{ 0x6197, 0x235068 },
	{ 0x6198, 0x234c28 },
	{ 0x6199, 0x235067 },
	{ 0x619a, 0x216c72 },
	{ 0x619b, 0x225048 },
	{ 0x619c, 0x234c29 },
	{ 0x619d, 0x225723 },
	{ 0x619e, 0x234c25 },
	{ 0x619f, 0x22504c },
	{ 0x61a1, 0x22504f },
	{ 0x61a2, 0x225046 },
	{ 0x61a3, 0x234b79 },
	{ 0x61a4, 0x216c73 },
	{ 0x61a6, 0x234b75 },
	{ 0x61a7, 0x216c6d },
	{ 0x61a8, 0x225724 },
	{ 0x61a9, 0x217056 },
	{ 0x61aa, 0x22504e },
	{ 0x61ab, 0x216c6f },
	{ 0x61ac, 0x216c71 },
	{ 0x61ad, 0x22504b },
	{ 0x61ae, 0x216c75 },
	{ 0x61af, 0x22504a },
	{ 0x61b0, 0x225045 },
	{ 0x61b1, 0x225044 },
	{ 0x61b2, 0x217054 },
	{ 0x61b3, 0x225052 },
	{ 0x61b4, 0x225727 },
	{ 0x61b5, 0x225c6b },
	{ 0x61b6, 0x217059 },
	{ 0x61b7, 0x235061 },
	{ 0x61b8, 0x22572d },
	{ 0x61b9, 0x235063 },
	{ 0x61ba, 0x22572b },
	{ 0x61bb, 0x23506a },
	{ 0x61bc, 0x225c6c },
	{ 0x61bd, 0x235064 },
	{ 0x61be, 0x21705a },
	{ 0x61bf, 0x22572c },
	{ 0x61c0, 0x235066 },
	{ 0x61c1, 0x225729 },
	{ 0x61c2, 0x21735d },
	{ 0x61c3, 0x225c6a },
	{ 0x61c4, 0x23506c },
	{ 0x61c5, 0x225726 },
	{ 0x61c6, 0x225728 },
	{ 0x61c7, 0x21735e },
	{ 0x61c8, 0x21705c },
	{ 0x61c9, 0x21735c },
	{ 0x61ca, 0x21705b },
	{ 0x61cb, 0x217360 },
	{ 0x61cc, 0x22572a },
	{ 0x61cd, 0x217058 },
	{ 0x61ce, 0x235062 },
	{ 0x61cf, 0x235065 },
	{ 0x61d0, 0x23506b },
	{ 0x61d3, 0x236679 },
	{ 0x61d6, 0x22615b },
	{ 0x61d8, 0x226153 },
	{ 0x61d9, 0x235461 },
	{ 0x61da, 0x23545f },
	{ 0x61db, 0x23545c },
	{ 0x61dc, 0x23545e },
	{ 0x61dd, 0x23545d },
	{ 0x61de, 0x225c72 },
	{ 0x61df, 0x226154 },
	{ 0x61e0, 0x225c6e },
	{ 0x61e2, 0x23545b },
	{ 0x61e3, 0x217642 },
	{ 0x61e4, 0x225c70 },
	{ 0x61e5, 0x225c6f },
	{ 0x61e6, 0x21735f },
	{ 0x61e7, 0x225c6d },
	{ 0x61e8, 0x225c71 },
	{ 0x61e9, 0x22615c },
	{ 0x61ea, 0x226158 },
	{ 0x61eb, 0x22615a },
	{ 0x61ed, 0x226155 },
	{ 0x61ee, 0x226156 },
	{ 0x61f0, 0x226159 },
	{ 0x61f1, 0x226157 },
	{ 0x61f2, 0x217834 },
	{ 0x61f3, 0x235765 },
	{ 0x61f5, 0x217837 },
	{ 0x61f6, 0x217836 },
	{ 0x61f7, 0x217835 },
	{ 0x61f8, 0x21796c },
	{ 0x61f9, 0x226876 },
	{ 0x61fa, 0x21796d },
	{ 0x61fb, 0x22654c },
	{ 0x61fc, 0x217a6a },
	{ 0x61fd, 0x226b5a },
	{ 0x61fe, 0x217a6b },
	{ 0x61ff, 0x217b60 },
	{ 0x6200, 0x217c36 },
	{ 0x6201, 0x226f28 },
	{ 0x6202, 0x235f46 },
	{ 0x6203, 0x226f29 },
	{ 0x6204, 0x226f2a },
	{ 0x6205, 0x23613e },
	{ 0x6207, 0x22722a },
	{ 0x6208, 0x214541 },
	{ 0x6209, 0x22215d },
	{ 0x620a, 0x214653 },
	{ 0x620c, 0x214827 },
	{ 0x620d, 0x214828 },
	{ 0x620e, 0x214826 },
	{ 0x620f, 0x23236b },
	{ 0x6210, 0x214829 },
	{ 0x6211, 0x214a3c },
	{ 0x6212, 0x214a3b },
	{ 0x6213, 0x232625 },
	{ 0x6214, 0x222670 },
	{ 0x6215, 0x214d51 },
	{ 0x6216, 0x214d50 },
	{ 0x6218, 0x232c63 },
	{ 0x6219, 0x222f31 },
	{ 0x621a, 0x215a51 },
	{ 0x621b, 0x215a52 },
	{ 0x621e, 0x233b64 },
	{ 0x621f, 0x215f3c },
	{ 0x6220, 0x224278 },
	{ 0x6221, 0x216428 },
	{ 0x6222, 0x216429 },
	{ 0x6223, 0x22427a },
	{ 0x6224, 0x22427c },
	{ 0x6225, 0x22427b },
	{ 0x6227, 0x224a3e },
	{ 0x6228, 0x234676 },
	{ 0x6229, 0x224a3d },
	{ 0x622a, 0x216870 },
	{ 0x622b, 0x224a3f },
	{ 0x622c, 0x234675 },
	{ 0x622d, 0x225053 },
	{ 0x622e, 0x216c76 },
	{ 0x622f, 0x234c2c },
	{ 0x6230, 0x21705d },
	{ 0x6231, 0x23506d },
	{ 0x6232, 0x217361 },
	{ 0x6233, 0x217643 },
	{ 0x6234, 0x217362 },
	{ 0x6235, 0x235f48 },
	{ 0x6236, 0x214542 },
	{ 0x6237, 0x232165 },
	{ 0x6238, 0x232166 },
	{ 0x6239, 0x23224e },
	{ 0x623a, 0x222428 },
	{ 0x623b, 0x232628 },
	{ 0x623c, 0x232629 },
	{ 0x623d, 0x222671 },
	{ 0x623e, 0x214d53 },
	{ 0x623f, 0x214d52 },
	{ 0x6240, 0x214d54 },
	{ 0x6241, 0x215137 },
	{ 0x6242, 0x222a53 },
	{ 0x6243, 0x222a54 },
	{ 0x6245, 0x233129 },
	{ 0x6246, 0x222f32 },
	{ 0x6247, 0x215552 },
	{ 0x6248, 0x215a53 },
	{ 0x6249, 0x215f3d },
	{ 0x624a, 0x223b74 },
	{ 0x624b, 0x214543 },
	{ 0x624d, 0x21445f },
	{ 0x624e, 0x214544 },
	{ 0x624f, 0x232250 },
	{ 0x6250, 0x22215e },
	{ 0x6251, 0x214657 },
	{ 0x6252, 0x214656 },
	{ 0x6253, 0x214654 },
	{ 0x6254, 0x214655 },
	{ 0x6257, 0x23236f },
	{ 0x6258, 0x21482c },
	{ 0x6259, 0x222249 },
	{ 0x625a, 0x22224b },
	{ 0x625b, 0x21482b },
	{ 0x625c, 0x222243 },
	{ 0x625d, 0x23236c },
	{ 0x625e, 0x222244 },
	{ 0x625f, 0x23236d },
	{ 0x6260, 0x22224a },
	{ 0x6261, 0x222246 },
	{ 0x6262, 0x222248 },
	{ 0x6263, 0x21482a },
	{ 0x6264, 0x222245 },
	{ 0x6265, 0x22224c },
	{ 0x6266, 0x222247 },
	{ 0x6267, 0x23236e },
	{ 0x626d, 0x214a43 },
	{ 0x626e, 0x214a4c },
	{ 0x626f, 0x214a4a },
	{ 0x6270, 0x222432 },
	{ 0x6271, 0x22242f },
	{ 0x6272, 0x222437 },
	{ 0x6273, 0x214a48 },
	{ 0x6274, 0x222438 },
	{ 0x6275, 0x232639 },
	{ 0x6276, 0x214a41 },
	{ 0x6277, 0x222435 },
	{ 0x6278, 0x23262e },
	{ 0x6279, 0x214a47 },
	{ 0x627a, 0x222431 },
	{ 0x627b, 0x222430 },
	{ 0x627c, 0x214a45 },
	{ 0x627d, 0x222436 },
	{ 0x627e, 0x214a46 },
	{ 0x627f, 0x214d55 },
	{ 0x6280, 0x214a40 },
	{ 0x6281, 0x222433 },
	{ 0x6282, 0x23262a },
	{ 0x6283, 0x222429 },
	{ 0x6284, 0x214a3d },
	{ 0x6285, 0x232637 },
	{ 0x6286, 0x214a50 },
	{ 0x6287, 0x22242e },
	{ 0x6288, 0x222434 },
	{ 0x6289, 0x214a42 },
	{ 0x628a, 0x214a44 },
	{ 0x628b, 0x23262f },
	{ 0x628c, 0x22242a },
	{ 0x628d, 0x232636 },
	{ 0x628e, 0x22242b },
	{ 0x628f, 0x22242c },
	{ 0x6291, 0x214a4f },
	{ 0x6292, 0x214a49 },
	{ 0x6293, 0x214a4e },
	{ 0x6294, 0x22242d },
	{ 0x6295, 0x214a4d },
	{ 0x6296, 0x214a3f },
	{ 0x6297, 0x214a3e },
	{ 0x6298, 0x214a4b },
	{ 0x6299, 0x232635 },
	{ 0x629b, 0x232633 },
	{ 0x629c, 0x232634 },
	{ 0x629d, 0x232638 },
	{ 0x629e, 0x232631 },
	{ 0x62a3, 0x23647b },
	{ 0x62a5, 0x232632 },
	{ 0x62a6, 0x232931 },
	{ 0x62a7, 0x23292a },
	{ 0x62a8, 0x214d63 },
	{ 0x62a9, 0x22267d },
	{ 0x62aa, 0x222676 },
	{ 0x62ab, 0x214d5e },
	{ 0x62ac, 0x214d71 },
	{ 0x62ad, 0x222672 },
	{ 0x62ae, 0x222679 },
	{ 0x62af, 0x22267b },
	{ 0x62b0, 0x22267e },
	{ 0x62b1, 0x214d6c },
	{ 0x62b2, 0x232926 },
	{ 0x62b3, 0x22267a },
	{ 0x62b4, 0x222673 },
	{ 0x62b5, 0x214d6a },
	{ 0x62b6, 0x222677 },
	{ 0x62b7, 0x232928 },
	{ 0x62b8, 0x222721 },
	{ 0x62b9, 0x214d5b },
	{ 0x62ba, 0x232925 },
	{ 0x62bb, 0x22267c },
	{ 0x62bc, 0x214d65 },
	{ 0x62bd, 0x214d64 },
	{ 0x62be, 0x222675 },
	{ 0x62bf, 0x214d59 },
	{ 0x62c0, 0x232934 },
	{ 0x62c1, 0x232932 },
	{ 0x62c2, 0x214d5a },
	{ 0x62c4, 0x214d58 },
	{ 0x62c5, 0x232933 },
	{ 0x62c6, 0x214d70 },
	{ 0x62c7, 0x214d68 },
	{ 0x62c8, 0x214d62 },
	{ 0x62c9, 0x214d56 },
	{ 0x62ca, 0x222678 },
	{ 0x62cb, 0x214d61 },
	{ 0x62cc, 0x214d57 },
	{ 0x62cd, 0x214d69 },
	{ 0x62ce, 0x214d72 },
	{ 0x62cf, 0x222a55 },
	{ 0x62d0, 0x214d66 },
	{ 0x62d1, 0x222674 },
	{ 0x62d2, 0x214d5c },
	{ 0x62d3, 0x214d5f },
	{ 0x62d4, 0x214d60 },
	{ 0x62d5, 0x23292e },
	{ 0x62d6, 0x214d6e },
	{ 0x62d7, 0x214d6f },
	{ 0x62d8, 0x214d6d },
	{ 0x62d9, 0x214d67 },
	{ 0x62da, 0x214d6b },
	{ 0x62db, 0x214d5d },
	{ 0x62dc, 0x215138 },
	{ 0x62dd, 0x232930 },
	{ 0x62de, 0x232937 },
	{ 0x62df, 0x232935 },
	{ 0x62e0, 0x232936 },
	{ 0x62e1, 0x23292f },
	{ 0x62e4, 0x232929 },
	{ 0x62ea, 0x232c6d },
	{ 0x62eb, 0x222a5b },
	{ 0x62ec, 0x215144 },
	{ 0x62ed, 0x21513c },
	{ 0x62ee, 0x21513e },
	{ 0x62ef, 0x215143 },
	{ 0x62f0, 0x222a67 },
	{ 0x62f1, 0x215141 },
	{ 0x62f2, 0x222f33 },
	{ 0x62f3, 0x215553 },
	{ 0x62f4, 0x215146 },
	{ 0x62f5, 0x222a58 },
	{ 0x62f6, 0x222a60 },
	{ 0x62f7, 0x215142 },
	{ 0x62f8, 0x222a5f },
	{ 0x62f9, 0x222a5c },
	{ 0x62fa, 0x222a64 },
	{ 0x62fb, 0x222a66 },
	{ 0x62fc, 0x21513b },
	{ 0x62fd, 0x21513f },
	{ 0x62fe, 0x215145 },
	{ 0x62ff, 0x215555 },
	{ 0x6300, 0x222a61 },
	{ 0x6301, 0x21513d },
	{ 0x6302, 0x215148 },
	{ 0x6303, 0x222a5a },
	{ 0x6304, 0x232c6f },
	{ 0x6305, 0x232c70 },
	{ 0x6307, 0x215140 },
	{ 0x6308, 0x215554 },
	{ 0x6309, 0x21513a },
	{ 0x630b, 0x222a57 },
	{ 0x630c, 0x222a5e },
	{ 0x630d, 0x222a56 },
	{ 0x630e, 0x222a59 },
	{ 0x630f, 0x222a5d },
	{ 0x6310, 0x222f34 },
	{ 0x6311, 0x215147 },
	{ 0x6313, 0x222a62 },
	{ 0x6314, 0x222a63 },
	{ 0x6315, 0x222a65 },
	{ 0x6316, 0x215139 },
	{ 0x6317, 0x232c6c },
	{ 0x6319, 0x233132 },
	{ 0x631b, 0x233133 },
	{ 0x631f, 0x232c6b },
	{ 0x6321, 0x232c6e },
	{ 0x6328, 0x215563 },
	{ 0x6329, 0x222f40 },
	{ 0x632a, 0x215561 },
	{ 0x632b, 0x215562 },
	{ 0x632c, 0x222f36 },
	{ 0x632d, 0x222f46 },
	{ 0x632e, 0x23312c },
	{ 0x632f, 0x215558 },
	{ 0x6330, 0x23312f },
	{ 0x6331, 0x233135 },
	{ 0x6332, 0x22354a },
	{ 0x6333, 0x222f48 },
	{ 0x6334, 0x222f42 },
	{ 0x6335, 0x233138 },
	{ 0x6336, 0x222f39 },
	{ 0x6337, 0x233137 },
	{ 0x6338, 0x222f4b },
	{ 0x6339, 0x222f3c },
	{ 0x633a, 0x21555e },
	{ 0x633b, 0x223561 },
	{ 0x633c, 0x222f3f },
	{ 0x633d, 0x215560 },
	{ 0x633e, 0x215557 },
	{ 0x633f, 0x23313c },
	{ 0x6340, 0x222f4d },
	{ 0x6341, 0x222f41 },
	{ 0x6342, 0x21555a },
	{ 0x6343, 0x222f3a },
	{ 0x6344, 0x222f37 },
	{ 0x6345, 0x222f38 },
	{ 0x6346, 0x21555b },
	{ 0x6347, 0x222f47 },
	{ 0x6348, 0x222f4e },
	{ 0x6349, 0x21555d },
	{ 0x634a, 0x222f3e },
	{ 0x634b, 0x222f3d },
	{ 0x634c, 0x215565 },
	{ 0x634d, 0x215564 },
	{ 0x634e, 0x215556 },
	{ 0x634f, 0x21555c },
	{ 0x6350, 0x21555f },
	{ 0x6351, 0x222f4a },
	{ 0x6352, 0x23312e },
	{ 0x6353, 0x233139 },
	{ 0x6354, 0x222f44 },
	{ 0x6355, 0x215559 },
	{ 0x6356, 0x222f35 },
	{ 0x6357, 0x222f4c },
	{ 0x6358, 0x222f43 },
	{ 0x6359, 0x222f45 },
	{ 0x635a, 0x222f49 },
	{ 0x635b, 0x233130 },
	{ 0x635c, 0x23313b },
	{ 0x635d, 0x233136 },
	{ 0x6360, 0x23647c },
	{ 0x6364, 0x23647d },
	{ 0x6365, 0x22354b },
	{ 0x6366, 0x233631 },
	{ 0x6367, 0x215a5b },
	{ 0x6368, 0x215a6f },
	{ 0x6369, 0x215a6e },
	{ 0x636a, 0x233627 },
	{ 0x636b, 0x215a63 },
	{ 0x636c, 0x233629 },
	{ 0x636d, 0x22355d },
	{ 0x636e, 0x223559 },
	{ 0x636f, 0x223556 },
	{ 0x6370, 0x223568 },
	{ 0x6371, 0x215a5e },
	{ 0x6372, 0x215a56 },
	{ 0x6373, 0x233626 },
	{ 0x6374, 0x233632 },
	{ 0x6375, 0x22355b },
	{ 0x6376, 0x215f4d },
	{ 0x6377, 0x215a5a },
	{ 0x6378, 0x223563 },
	{ 0x6379, 0x233622 },
	{ 0x637a, 0x215a70 },
	{ 0x637b, 0x215a6d },
	{ 0x637c, 0x22355f },
	{ 0x637d, 0x22354e },
	{ 0x637e, 0x23357c },
	{ 0x637f, 0x23362b },
	{ 0x6380, 0x215a6c },
	{ 0x6381, 0x223565 },
	{ 0x6382, 0x22354d },
	{ 0x6383, 0x215a61 },
	{ 0x6384, 0x215a65 },
	{ 0x6385, 0x223564 },
	{ 0x6386, 0x233623 },
	{ 0x6387, 0x223557 },
	{ 0x6388, 0x215a66 },
	{ 0x6389, 0x215a60 },
	{ 0x638a, 0x22354c },
	{ 0x638b, 0x23357d },
	{ 0x638c, 0x215f3f },
	{ 0x638d, 0x223567 },
	{ 0x638e, 0x223555 },
	{ 0x638f, 0x215a6b },
	{ 0x6390, 0x223558 },
	{ 0x6391, 0x223566 },
	{ 0x6392, 0x215a6a },
	{ 0x6393, 0x233624 },
	{ 0x6394, 0x223b75 },
	{ 0x6396, 0x215a57 },
	{ 0x6397, 0x223553 },
	{ 0x6398, 0x215a5c },
	{ 0x6399, 0x215a67 },
	{ 0x639b, 0x215a62 },
	{ 0x639c, 0x22355c },
	{ 0x639d, 0x223552 },
	{ 0x639e, 0x223550 },
	{ 0x639f, 0x223562 },
	{ 0x63a0, 0x215a54 },
	{ 0x63a1, 0x215a68 },
	{ 0x63a2, 0x215a58 },
	{ 0x63a3, 0x215f3e },
	{ 0x63a4, 0x223560 },
	{ 0x63a5, 0x215a59 },
	{ 0x63a7, 0x215a55 },
	{ 0x63a8, 0x215a64 },
	{ 0x63a9, 0x215a5f },
	{ 0x63aa, 0x215a5d },
	{ 0x63ab, 0x223554 },
	{ 0x63ac, 0x215a69 },
	{ 0x63ad, 0x223551 },
	{ 0x63ae, 0x22355e },
	{ 0x63af, 0x22355a },
	{ 0x63b0, 0x223b77 },
	{ 0x63b1, 0x223b76 },
	{ 0x63b2, 0x23362d },
	{ 0x63b6, 0x23647e },
	{ 0x63ba, 0x23362e },
	{ 0x63bd, 0x22354f },
	{ 0x63be, 0x223c29 },
	{ 0x63bf, 0x233b71 },
	{ 0x63c0, 0x215f41 },
	{ 0x63c1, 0x233b70 },
	{ 0x63c2, 0x223c2f },
	{ 0x63c3, 0x223b7c },
	{ 0x63c4, 0x223c2c },
	{ 0x63c5, 0x22427d },
	{ 0x63c6, 0x215f44 },
	{ 0x63c7, 0x223c30 },
	{ 0x63c8, 0x223c33 },
	{ 0x63c9, 0x215f43 },
	{ 0x63ca, 0x223c21 },
	{ 0x63cb, 0x223c32 },
	{ 0x63cc, 0x223c31 },
	{ 0x63cd, 0x215f45 },
	{ 0x63ce, 0x223b78 },
	{ 0x63cf, 0x215f40 },
	{ 0x63d0, 0x215f48 },
	{ 0x63d1, 0x233b73 },
	{ 0x63d2, 0x215f46 },
	{ 0x63d3, 0x223c2e },
	{ 0x63d5, 0x223c24 },
	{ 0x63d6, 0x215f4a },
	{ 0x63d7, 0x223c35 },
	{ 0x63d8, 0x223c2d },
	{ 0x63d9, 0x223c36 },
	{ 0x63da, 0x215f52 },
	{ 0x63db, 0x215f50 },
	{ 0x63dc, 0x223c2b },
	{ 0x63dd, 0x223c2a },
	{ 0x63de, 0x233b67 },
	{ 0x63df, 0x223c28 },
	{ 0x63e0, 0x223c22 },
	{ 0x63e1, 0x215f49 },
	{ 0x63e2, 0x233b66 },
	{ 0x63e3, 0x215f47 },
	{ 0x63e4, 0x222f3b },
	{ 0x63e5, 0x223b79 },
	{ 0x63e6, 0x233b68 },
	{ 0x63e7, 0x22433d },
	{ 0x63e8, 0x223b7a },
	{ 0x63e9, 0x215f42 },
	{ 0x63ea, 0x215f4f },
	{ 0x63eb, 0x224321 },
	{ 0x63ed, 0x215f4b },
	{ 0x63ee, 0x215f4c },
	{ 0x63ef, 0x223b7b },
	{ 0x63f0, 0x223c34 },
	{ 0x63f1, 0x22427e },
	{ 0x63f2, 0x223c25 },
	{ 0x63f3, 0x223b7e },
	{ 0x63f4, 0x215f4e },
	{ 0x63f5, 0x223c26 },
	{ 0x63f6, 0x223c23 },
	{ 0x63f7, 0x233b72 },
	{ 0x63f8, 0x233b6d },
	{ 0x63f9, 0x215f53 },
	{ 0x63fa, 0x236339 },
	{ 0x63fe, 0x233b6f },
	{ 0x6403, 0x236521 },
	{ 0x6406, 0x216438 },
	{ 0x6407, 0x234149 },
	{ 0x6408, 0x234132 },
	{ 0x6409, 0x224324 },
	{ 0x640a, 0x224337 },
	{ 0x640b, 0x22433c },
	{ 0x640c, 0x224330 },
	{ 0x640d, 0x216434 },
	{ 0x640e, 0x224341 },
	{ 0x640f, 0x216431 },
	{ 0x6410, 0x224322 },
	{ 0x6411, 0x23413a },
	{ 0x6412, 0x224323 },
	{ 0x6413, 0x21642a },
	{ 0x6414, 0x216433 },
	{ 0x6415, 0x22432a },
	{ 0x6416, 0x216436 },
	{ 0x6417, 0x216437 },
	{ 0x6418, 0x22432b },
	{ 0x6419, 0x234138 },
	{ 0x641a, 0x224338 },
	{ 0x641b, 0x22433e },
	{ 0x641c, 0x216432 },
	{ 0x641d, 0x23413e },
	{ 0x641e, 0x21642c },
	{ 0x641f, 0x224329 },
	{ 0x6420, 0x224325 },
	{ 0x6421, 0x224340 },
	{ 0x6422, 0x22432e },
	{ 0x6423, 0x22432f },
	{ 0x6424, 0x224326 },
	{ 0x6425, 0x22433a },
	{ 0x6426, 0x224331 },
	{ 0x6427, 0x22433b },
	{ 0x6428, 0x224333 },
	{ 0x6429, 0x23413d },
	{ 0x642a, 0x21642d },
	{ 0x642b, 0x224a40 },
	{ 0x642c, 0x216430 },
	{ 0x642d, 0x21642e },
	{ 0x642e, 0x22433f },
	{ 0x642f, 0x224336 },
	{ 0x6430, 0x224332 },
	{ 0x6431, 0x234136 },
	{ 0x6432, 0x234133 },
	{ 0x6433, 0x224327 },
	{ 0x6434, 0x21687a },
	{ 0x6435, 0x224335 },
	{ 0x6436, 0x216435 },
	{ 0x6437, 0x22432d },
	{ 0x6438, 0x234134 },
	{ 0x6439, 0x22432c },
	{ 0x643a, 0x234148 },
	{ 0x643b, 0x234725 },
	{ 0x643c, 0x234142 },
	{ 0x643d, 0x21642f },
	{ 0x643e, 0x21642b },
	{ 0x643f, 0x224a55 },
	{ 0x6440, 0x224339 },
	{ 0x6441, 0x224334 },
	{ 0x6443, 0x224328 },
	{ 0x6446, 0x234144 },
	{ 0x6447, 0x234145 },
	{ 0x6449, 0x236676 },
	{ 0x644b, 0x224a50 },
	{ 0x644c, 0x234678 },
	{ 0x644d, 0x224a41 },
	{ 0x644e, 0x224a4c },
	{ 0x644f, 0x234728 },
	{ 0x6450, 0x224a53 },
	{ 0x6451, 0x216878 },
	{ 0x6452, 0x215f51 },
	{ 0x6453, 0x224a51 },
	{ 0x6454, 0x216873 },
	{ 0x6455, 0x23467e },
	{ 0x6456, 0x234724 },
	{ 0x6457, 0x23467a },
	{ 0x6458, 0x216872 },
	{ 0x6459, 0x224a58 },
	{ 0x645b, 0x224a42 },
	{ 0x645c, 0x224a4f },
	{ 0x645d, 0x224a43 },
	{ 0x645e, 0x224a4e },
	{ 0x645f, 0x216876 },
	{ 0x6460, 0x224a52 },
	{ 0x6461, 0x223c27 },
	{ 0x6462, 0x234721 },
	{ 0x6464, 0x23472a },
	{ 0x6465, 0x224a59 },
	{ 0x6466, 0x224a4a },
	{ 0x6467, 0x216879 },
	{ 0x6468, 0x225061 },
	{ 0x6469, 0x216c77 },
	{ 0x646a, 0x234723 },
	{ 0x646b, 0x224a57 },
	{ 0x646c, 0x224a56 },
	{ 0x646d, 0x21687b },
	{ 0x646e, 0x225054 },
	{ 0x646f, 0x216c78 },
	{ 0x6470, 0x225055 },
	{ 0x6471, 0x234722 },
	{ 0x6472, 0x224a46 },
	{ 0x6473, 0x224a47 },
	{ 0x6474, 0x224a44 },
	{ 0x6475, 0x224a49 },
	{ 0x6476, 0x224a45 },
	{ 0x6477, 0x224a5a },
	{ 0x6478, 0x216875 },
	{ 0x6479, 0x216c79 },
	{ 0x647a, 0x216877 },
	{ 0x647b, 0x21687c },
	{ 0x647c, 0x23467b },
	{ 0x647d, 0x224a48 },
	{ 0x647e, 0x234729 },
	{ 0x647f, 0x224a54 },
	{ 0x6480, 0x234c2d },
	{ 0x6481, 0x234726 },
	{ 0x6482, 0x224a4d },
	{ 0x6483, 0x234c35 },
	{ 0x6485, 0x225058 },
	{ 0x6486, 0x234c38 },
	{ 0x6487, 0x216871 },
	{ 0x6488, 0x216c7c },
	{ 0x6489, 0x225735 },
	{ 0x648a, 0x22505d },
	{ 0x648b, 0x22505c },
	{ 0x648c, 0x22505e },
	{ 0x648d, 0x234c30 },
	{ 0x648e, 0x234c2f },
	{ 0x648f, 0x22505b },
	{ 0x6490, 0x216c7d },
	{ 0x6491, 0x234c3b },
	{ 0x6492, 0x216d25 },
	{ 0x6493, 0x216d22 },
	{ 0x6494, 0x234c31 },
	{ 0x6495, 0x216d23 },
	{ 0x6496, 0x225056 },
	{ 0x6497, 0x225059 },
	{ 0x6498, 0x225063 },
	{ 0x6499, 0x216d2b },
	{ 0x649a, 0x216d29 },
	{ 0x649b, 0x234c2e },
	{ 0x649c, 0x22505a },
	{ 0x649d, 0x223b7d },
	{ 0x649e, 0x216c7a },
	{ 0x649f, 0x225060 },
	{ 0x64a0, 0x225057 },
	{ 0x64a1, 0x234c3e },
	{ 0x64a2, 0x216d2c },
	{ 0x64a3, 0x22505f },
	{ 0x64a4, 0x216874 },
	{ 0x64a5, 0x216d21 },
	{ 0x64a6, 0x224a4b },
	{ 0x64a7, 0x234c3f },
	{ 0x64a8, 0x234c34 },
	{ 0x64a9, 0x216d24 },
	{ 0x64aa, 0x234c3d },
	{ 0x64ab, 0x216d28 },
	{ 0x64ac, 0x216d2a },
	{ 0x64ad, 0x216d27 },
	{ 0x64ae, 0x216d26 },
	{ 0x64af, 0x234c3a },
	{ 0x64b0, 0x216c7e },
	{ 0x64b1, 0x225062 },
	{ 0x64b2, 0x216c7b },
	{ 0x64b3, 0x216d2d },
	{ 0x64b4, 0x234c39 },
	{ 0x64b6, 0x236522 },
	{ 0x64b9, 0x234c37 },
	{ 0x64bb, 0x217061 },
	{ 0x64bc, 0x217062 },
	{ 0x64bd, 0x225734 },
	{ 0x64be, 0x21706b },
	{ 0x64bf, 0x217068 },
	{ 0x64c0, 0x235070 },
	{ 0x64c1, 0x21705f },
	{ 0x64c2, 0x217066 },
	{ 0x64c3, 0x225736 },
	{ 0x64c4, 0x217064 },
	{ 0x64c5, 0x21705e },
	{ 0x64c6, 0x234c32 },
	{ 0x64c7, 0x217065 },
	{ 0x64c8, 0x235077 },
	{ 0x64c9, 0x225733 },
	{ 0x64ca, 0x217364 },
	{ 0x64cb, 0x217060 },
	{ 0x64cd, 0x217067 },
	{ 0x64ce, 0x217363 },
	{ 0x64cf, 0x225732 },
	{ 0x64d0, 0x225731 },
	{ 0x64d1, 0x235076 },
	{ 0x64d2, 0x217069 },
	{ 0x64d3, 0x23506f },
	{ 0x64d4, 0x21706a },
	{ 0x64d5, 0x235079 },
	{ 0x64d6, 0x225730 },
	{ 0x64d7, 0x22572f },
	{ 0x64d8, 0x217365 },
	{ 0x64d9, 0x225739 },
	{ 0x64da, 0x217063 },
	{ 0x64db, 0x225737 },
	{ 0x64dc, 0x235075 },
	{ 0x64df, 0x235464 },
	{ 0x64e0, 0x217366 },
	{ 0x64e1, 0x235467 },
	{ 0x64e2, 0x21736b },
	{ 0x64e3, 0x225c75 },
	{ 0x64e4, 0x225c77 },
	{ 0x64e5, 0x23576b },
	{ 0x64e6, 0x217368 },
	{ 0x64e7, 0x23576d },
	{ 0x64e8, 0x225c78 },
	{ 0x64e9, 0x225c74 },
	{ 0x64ea, 0x23576c },
	{ 0x64eb, 0x225c76 },
	{ 0x64ec, 0x217369 },
	{ 0x64ed, 0x21736c },
	{ 0x64ee, 0x235469 },
	{ 0x64ef, 0x225c73 },
	{ 0x64f0, 0x217367 },
	{ 0x64f1, 0x21736a },
	{ 0x64f2, 0x217645 },
	{ 0x64f3, 0x225738 },
	{ 0x64f4, 0x217644 },
	{ 0x64f6, 0x23576a },
	{ 0x64f7, 0x21764a },
	{ 0x64f8, 0x226160 },
	{ 0x64f9, 0x235770 },
	{ 0x64fa, 0x217648 },
	{ 0x64fb, 0x217649 },
	{ 0x64fc, 0x226163 },
	{ 0x64fd, 0x22615f },
	{ 0x64fe, 0x217646 },
	{ 0x64ff, 0x22615d },
	{ 0x6500, 0x217838 },
	{ 0x6501, 0x226161 },
	{ 0x6503, 0x226162 },
	{ 0x6504, 0x22615e },
	{ 0x6505, 0x23576e },
	{ 0x6506, 0x217647 },
	{ 0x6507, 0x22654d },
	{ 0x6508, 0x235a3b },
	{ 0x6509, 0x226550 },
	{ 0x650a, 0x235a3c },
	{ 0x650b, 0x235a3a },
	{ 0x650c, 0x226551 },
	{ 0x650d, 0x22654f },
	{ 0x650e, 0x226552 },
	{ 0x650f, 0x217839 },
	{ 0x6510, 0x22654e },
	{ 0x6511, 0x235e31 },
	{ 0x6513, 0x22687a },
	{ 0x6514, 0x21796f },
	{ 0x6515, 0x226879 },
	{ 0x6516, 0x226878 },
	{ 0x6517, 0x226877 },
	{ 0x6518, 0x21796e },
	{ 0x6519, 0x217970 },
	{ 0x651a, 0x236523 },
	{ 0x651b, 0x226b5b },
	{ 0x651c, 0x217a6d },
	{ 0x651d, 0x217a6c },
	{ 0x651e, 0x235f4a },
	{ 0x651f, 0x235f4b },
	{ 0x6520, 0x226d4f },
	{ 0x6521, 0x226d4e },
	{ 0x6522, 0x226d51 },
	{ 0x6523, 0x217c37 },
	{ 0x6524, 0x217b61 },
	{ 0x6525, 0x226f2c },
	{ 0x6526, 0x226d50 },
	{ 0x6527, 0x235f49 },
	{ 0x6528, 0x236032 },
	{ 0x6529, 0x226f2b },
	{ 0x652a, 0x217c39 },
	{ 0x652b, 0x217c38 },
	{ 0x652c, 0x217c5f },
	{ 0x652d, 0x227037 },
	{ 0x652e, 0x22707d },
	{ 0x652f, 0x214545 },
	{ 0x6531, 0x232c72 },
	{ 0x6532, 0x223c37 },
	{ 0x6533, 0x22573a },
	{ 0x6534, 0x232167 },
	{ 0x6535, 0x232168 },
	{ 0x6536, 0x21482d },
	{ 0x6537, 0x22224d },
	{ 0x6538, 0x214a53 },
	{ 0x6539, 0x214a51 },
	{ 0x653b, 0x214a52 },
	{ 0x653d, 0x222722 },
	{ 0x653e, 0x214d73 },
	{ 0x653f, 0x215149 },
	{ 0x6540, 0x232c74 },
	{ 0x6541, 0x222a68 },
	{ 0x6542, 0x232c76 },
	{ 0x6543, 0x222a69 },
	{ 0x6544, 0x232c73 },
	{ 0x6545, 0x21514a },
	{ 0x6546, 0x222f50 },
	{ 0x6548, 0x215566 },
	{ 0x6549, 0x215567 },
	{ 0x654a, 0x222f4f },
	{ 0x654b, 0x23313d },
	{ 0x654d, 0x233637 },
	{ 0x654e, 0x233636 },
	{ 0x654f, 0x215a77 },
	{ 0x6551, 0x215a73 },
	{ 0x6553, 0x223569 },
	{ 0x6554, 0x215a7a },
	{ 0x6555, 0x215a79 },
	{ 0x6556, 0x215a72 },
	{ 0x6557, 0x215a75 },
	{ 0x6558, 0x215a78 },
	{ 0x6559, 0x215a74 },
	{ 0x655a, 0x233634 },
	{ 0x655c, 0x223c3b },
	{ 0x655d, 0x215a71 },
	{ 0x655e, 0x215f54 },
	{ 0x655f, 0x233b74 },
	{ 0x6560, 0x233b75 },
	{ 0x6561, 0x233b76 },
	{ 0x6562, 0x215f56 },
	{ 0x6563, 0x215f57 },
	{ 0x6564, 0x223c3a },
	{ 0x6565, 0x223c3d },
	{ 0x6566, 0x215f55 },
	{ 0x6567, 0x223c38 },
	{ 0x6568, 0x223c3c },
	{ 0x656a, 0x223c39 },
	{ 0x656b, 0x23414b },
	{ 0x656c, 0x216439 },
	{ 0x656d, 0x23414e },
	{ 0x656e, 0x236346 },
	{ 0x656f, 0x224342 },
	{ 0x6570, 0x23414d },
	{ 0x6571, 0x234730 },
	{ 0x6572, 0x21687d },
	{ 0x6573, 0x224a5b },
	{ 0x6574, 0x21706c },
	{ 0x6575, 0x216d2e },
	{ 0x6576, 0x225064 },
	{ 0x6577, 0x216d2f },
	{ 0x6578, 0x216d30 },
	{ 0x6579, 0x225066 },
	{ 0x657a, 0x225065 },
	{ 0x657b, 0x225067 },
	{ 0x657c, 0x22573c },
	{ 0x657f, 0x22573b },
	{ 0x6580, 0x225c7a },
	{ 0x6581, 0x225c79 },
	{ 0x6582, 0x21736d },
	{ 0x6583, 0x21736e },
	{ 0x6584, 0x226553 },
	{ 0x6585, 0x235c41 },
	{ 0x6587, 0x214546 },
	{ 0x6588, 0x232558 },
	{ 0x6589, 0x232939 },
	{ 0x658b, 0x233140 },
	{ 0x658c, 0x223c3e },
	{ 0x658d, 0x233638 },
	{ 0x658e, 0x233639 },
	{ 0x6590, 0x215f59 },
	{ 0x6591, 0x215f58 },
	{ 0x6592, 0x224343 },
	{ 0x6594, 0x226164 },
	{ 0x6595, 0x217a6e },
	{ 0x6596, 0x226f2d },
	{ 0x6597, 0x214547 },
	{ 0x6599, 0x215568 },
	{ 0x659a, 0x233142 },
	{ 0x659b, 0x215a7c },
	{ 0x659c, 0x215a7b },
	{ 0x659d, 0x223c3f },
	{ 0x659e, 0x223c40 },
	{ 0x659f, 0x21643a },
	{ 0x65a0, 0x224a5c },
	{ 0x65a1, 0x21687e },
	{ 0x65a2, 0x22573d },
	{ 0x65a4, 0x214548 },
	{ 0x65a5, 0x214658 },
	{ 0x65a6, 0x23293b },
	{ 0x65a7, 0x214d74 },
	{ 0x65a8, 0x222723 },
	{ 0x65aa, 0x222a6a },
	{ 0x65ab, 0x21514b },
	{ 0x65ac, 0x215a7d },
	{ 0x65ad, 0x23363a },
	{ 0x65ae, 0x223c41 },
	{ 0x65af, 0x215f5a },
	{ 0x65b0, 0x21643b },
	{ 0x65b2, 0x225068 },
	{ 0x65b3, 0x225069 },
	{ 0x65b5, 0x23546b },
	{ 0x65b6, 0x225c7b },
	{ 0x65b7, 0x21764b },
	{ 0x65b8, 0x22707e },
	{ 0x65b9, 0x214549 },
	{ 0x65ba, 0x23293c },
	{ 0x65bb, 0x222724 },
	{ 0x65bc, 0x214d75 },
	{ 0x65bd, 0x21514c },
	{ 0x65be, 0x232c77 },
	{ 0x65bf, 0x222a6b },
	{ 0x65c1, 0x215569 },
	{ 0x65c2, 0x222f54 },
	{ 0x65c3, 0x222f52 },
	{ 0x65c4, 0x222f53 },
	{ 0x65c5, 0x21556a },
	{ 0x65c6, 0x222f51 },
	{ 0x65c7, 0x23363c },
	{ 0x65c9, 0x23363f },
	{ 0x65ca, 0x23363d },
	{ 0x65cb, 0x215b21 },
	{ 0x65cc, 0x215b22 },
	{ 0x65cd, 0x22356a },
	{ 0x65ce, 0x215b23 },
	{ 0x65cf, 0x215a7e },
	{ 0x65d0, 0x223c42 },
	{ 0x65d1, 0x233b79 },
	{ 0x65d2, 0x223c43 },
	{ 0x65d3, 0x224344 },
	{ 0x65d6, 0x216922 },
	{ 0x65d7, 0x216921 },
	{ 0x65da, 0x225c7c },
	{ 0x65db, 0x226165 },
	{ 0x65dc, 0x235a3f },
	{ 0x65dd, 0x226555 },
	{ 0x65de, 0x226554 },
	{ 0x65df, 0x22687b },
	{ 0x65e0, 0x232169 },
	{ 0x65e1, 0x22213e },
	{ 0x65e2, 0x21514d },
	{ 0x65e3, 0x233641 },
	{ 0x65e4, 0x234150 },
	{ 0x65e5, 0x21454a },
	{ 0x65e6, 0x214659 },
	{ 0x65e7, 0x232251 },
	{ 0x65e8, 0x21482f },
	{ 0x65e9, 0x21482e },
	{ 0x65ea, 0x232373 },
	{ 0x65eb, 0x232372 },
	{ 0x65ec, 0x214830 },
	{ 0x65ed, 0x214831 },
	{ 0x65ee, 0x22224f },
	{ 0x65ef, 0x22224e },
	{ 0x65f0, 0x222439 },
	{ 0x65f1, 0x214a54 },
	{ 0x65f2, 0x22243c },
	{ 0x65f3, 0x22243b },
	{ 0x65f4, 0x22243a },
	{ 0x65f5, 0x22243d },
	{ 0x65f6, 0x23263d },
	{ 0x65f9, 0x23625e },
	{ 0x65fa, 0x214d76 },
	{ 0x65fb, 0x22272a },
	{ 0x65fc, 0x222726 },
	{ 0x65fd, 0x22272f },
	{ 0x65fe, 0x232943 },
	{ 0x65ff, 0x23293e },
	{ 0x6600, 0x214d7d },
	{ 0x6601, 0x232942 },
	{ 0x6602, 0x214d7b },
	{ 0x6603, 0x22272b },
	{ 0x6604, 0x222727 },
	{ 0x6605, 0x22272e },
	{ 0x6606, 0x214d7a },
	{ 0x6607, 0x214e23 },
	{ 0x6608, 0x222729 },
	{ 0x6609, 0x222725 },
	{ 0x660a, 0x214e22 },
	{ 0x660b, 0x22272c },
	{ 0x660c, 0x214d79 },
	{ 0x660d, 0x22272d },
	{ 0x660e, 0x214d7c },
	{ 0x660f, 0x214d7e },
	{ 0x6610, 0x222731 },
	{ 0x6611, 0x222730 },
	{ 0x6612, 0x222728 },
	{ 0x6613, 0x214d78 },
	{ 0x6614, 0x214d77 },
	{ 0x6615, 0x214e21 },
	{ 0x6617, 0x232940 },
	{ 0x6618, 0x232941 },
	{ 0x661a, 0x232c7e },
	{ 0x661b, 0x232c7a },
	{ 0x661c, 0x222a70 },
	{ 0x661d, 0x222a76 },
	{ 0x661e, 0x232d23 },
	{ 0x661f, 0x215153 },
	{ 0x6620, 0x215150 },
	{ 0x6621, 0x222a6d },
	{ 0x6622, 0x222a72 },
	{ 0x6623, 0x232c7c },
	{ 0x6624, 0x215156 },
	{ 0x6625, 0x21514e },
	{ 0x6626, 0x222a71 },
	{ 0x6627, 0x215151 },
	{ 0x6628, 0x215154 },
	{ 0x6629, 0x232c79 },
	{ 0x662b, 0x222a74 },
	{ 0x662c, 0x232c7d },
	{ 0x662d, 0x21514f },
	{ 0x662e, 0x222a79 },
	{ 0x662f, 0x215152 },
	{ 0x6630, 0x232d21 },
	{ 0x6631, 0x215155 },
	{ 0x6632, 0x222a6e },
	{ 0x6633, 0x222a73 },
	{ 0x6634, 0x222a77 },
	{ 0x6635, 0x222a6f },
	{ 0x6636, 0x222a6c },
	{ 0x6637, 0x232d24 },
	{ 0x6638, 0x232d25 },
	{ 0x6639, 0x222a78 },
	{ 0x663a, 0x222a75 },
	{ 0x663b, 0x232d22 },
	{ 0x663c, 0x232c37 },
	{ 0x6640, 0x233146 },
	{ 0x6641, 0x215572 },
	{ 0x6642, 0x21556b },
	{ 0x6643, 0x21556e },
	{ 0x6644, 0x23314c },
	{ 0x6645, 0x215571 },
	{ 0x6646, 0x233144 },
	{ 0x6647, 0x222f57 },
	{ 0x6648, 0x233149 },
	{ 0x6649, 0x21556c },
	{ 0x664a, 0x222f55 },
	{ 0x664b, 0x233148 },
	{ 0x664c, 0x215570 },
	{ 0x664d, 0x23314d },
	{ 0x664e, 0x233145 },
	{ 0x664f, 0x21556d },
	{ 0x6650, 0x233143 },
	{ 0x6651, 0x222f58 },
	{ 0x6652, 0x21556f },
	{ 0x6657, 0x233642 },
	{ 0x6659, 0x22356e },
	{ 0x665a, 0x215b25 },
	{ 0x665b, 0x22356d },
	{ 0x665c, 0x22356f },
	{ 0x665d, 0x215b24 },
	{ 0x665e, 0x215b29 },
	{ 0x665f, 0x222f56 },
	{ 0x6660, 0x23314b },
	{ 0x6661, 0x22356c },
	{ 0x6662, 0x223570 },
	{ 0x6663, 0x233644 },
	{ 0x6664, 0x215b26 },
	{ 0x6665, 0x22356b },
	{ 0x6666, 0x215b28 },
	{ 0x6667, 0x233645 },
	{ 0x6668, 0x215b27 },
	{ 0x6669, 0x233c26 },
	{ 0x666a, 0x223c4a },
	{ 0x666b, 0x233b7d },
	{ 0x666c, 0x223c45 },
	{ 0x666d, 0x233c25 },
	{ 0x666e, 0x215f5b },
	{ 0x666f, 0x215f5f },
	{ 0x6670, 0x215f5c },
	{ 0x6671, 0x223c48 },
	{ 0x6672, 0x223c4b },
	{ 0x6673, 0x233c23 },
	{ 0x6674, 0x215f5d },
	{ 0x6676, 0x215f5e },
	{ 0x6677, 0x215f63 },
	{ 0x6678, 0x22434d },
	{ 0x6679, 0x223c49 },
	{ 0x667a, 0x215f61 },
	{ 0x667b, 0x223c46 },
	{ 0x667c, 0x223c44 },
	{ 0x667d, 0x233b7c },
	{ 0x667e, 0x215f62 },
	{ 0x667f, 0x233b7e },
	{ 0x6680, 0x223c47 },
	{ 0x6681, 0x233c24 },
	{ 0x6684, 0x216441 },
	{ 0x6686, 0x224345 },
	{ 0x6687, 0x21643e },
	{ 0x6688, 0x21643f },
	{ 0x6689, 0x21643d },
	{ 0x668a, 0x22434a },
	{ 0x668b, 0x224349 },
	{ 0x668c, 0x224346 },
	{ 0x668d, 0x216443 },
	{ 0x668e, 0x23415b },
	{ 0x668f, 0x234156 },
	{ 0x6690, 0x224348 },
	{ 0x6691, 0x215f60 },
	{ 0x6692, 0x234159 },
	{ 0x6693, 0x234151 },
	{ 0x6694, 0x22434c },
	{ 0x6695, 0x224347 },
	{ 0x6696, 0x216440 },
	{ 0x6697, 0x21643c },
	{ 0x6698, 0x216442 },
	{ 0x6699, 0x22434b },
	{ 0x669a, 0x234734 },
	{ 0x669c, 0x234735 },
	{ 0x669d, 0x216925 },
	{ 0x669f, 0x224a5f },
	{ 0x66a0, 0x224a5e },
	{ 0x66a1, 0x224a5d },
	{ 0x66a2, 0x216923 },
	{ 0x66a4, 0x234739 },
	{ 0x66a5, 0x234733 },
	{ 0x66a6, 0x234737 },
	{ 0x66a8, 0x216924 },
	{ 0x66a9, 0x22506c },
	{ 0x66aa, 0x22506f },
	{ 0x66ab, 0x216d32 },
	{ 0x66ac, 0x234c44 },
	{ 0x66ad, 0x234c46 },
	{ 0x66ae, 0x216d31 },
	{ 0x66af, 0x225070 },
	{ 0x66b0, 0x22506b },
	{ 0x66b1, 0x216d34 },
	{ 0x66b2, 0x22506d },
	{ 0x66b3, 0x234c41 },
	{ 0x66b4, 0x216d33 },
	{ 0x66b5, 0x22506a },
	{ 0x66b6, 0x234c40 },
	{ 0x66b7, 0x22506e },
	{ 0x66b8, 0x217072 },
	{ 0x66b9, 0x21706f },
	{ 0x66ba, 0x225746 },
	{ 0x66bb, 0x225745 },
	{ 0x66bc, 0x234c43 },
	{ 0x66bd, 0x225744 },
	{ 0x66be, 0x22573f },
	{ 0x66bf, 0x23507d },
	{ 0x66c0, 0x225740 },
	{ 0x66c1, 0x235123 },
	{ 0x66c3, 0x23507a },
	{ 0x66c4, 0x217070 },
	{ 0x66c5, 0x23507e },
	{ 0x66c6, 0x21706d },
	{ 0x66c7, 0x217071 },
	{ 0x66c8, 0x22573e },
	{ 0x66c9, 0x21706e },
	{ 0x66ca, 0x225741 },
	{ 0x66cb, 0x225742 },
	{ 0x66cc, 0x225747 },
	{ 0x66cd, 0x235122 },
	{ 0x66ce, 0x235471 },
	{ 0x66cf, 0x225743 },
	{ 0x66d0, 0x23546f },
	{ 0x66d1, 0x235470 },
	{ 0x66d2, 0x225c7d },
	{ 0x66d4, 0x23546c },
	{ 0x66d5, 0x23546d },
	{ 0x66d6, 0x217370 },
	{ 0x66d7, 0x235472 },
	{ 0x66d8, 0x226168 },
	{ 0x66d9, 0x21736f },
	{ 0x66da, 0x226166 },
	{ 0x66db, 0x226167 },
	{ 0x66dc, 0x21764c },
	{ 0x66dd, 0x21783b },
	{ 0x66de, 0x226556 },
	{ 0x66df, 0x235a43 },
	{ 0x66e0, 0x21783a },
	{ 0x66e1, 0x235a42 },
	{ 0x66e2, 0x236526 },
	{ 0x66e3, 0x22687d },
	{ 0x66e4, 0x22687e },
	{ 0x66e5, 0x235c42 },
	{ 0x66e6, 0x217971 },
	{ 0x66e7, 0x235c43 },
	{ 0x66e8, 0x22687c },
	{ 0x66e9, 0x217a6f },
	{ 0x66eb, 0x226f2e },
	{ 0x66ec, 0x217c3a },
	{ 0x66ed, 0x227038 },
	{ 0x66ee, 0x227039 },
	{ 0x66ef, 0x23613f },
	{ 0x66f0, 0x21454b },
	{ 0x66f2, 0x214832 },
	{ 0x66f3, 0x214833 },
	{ 0x66f4, 0x214a55 },
	{ 0x66f5, 0x232641 },
	{ 0x66f6, 0x222732 },
	{ 0x66f7, 0x215157 },
	{ 0x66f8, 0x215573 },
	{ 0x66f9, 0x215b2a },
	{ 0x66fc, 0x215937 },
	{ 0x66fe, 0x215f64 },
	{ 0x66ff, 0x215f65 },
	{ 0x6700, 0x215e32 },
	{ 0x6701, 0x223c4c },
	{ 0x6702, 0x236527 },
	{ 0x6703, 0x216444 },
	{ 0x6704, 0x224a61 },
	{ 0x6705, 0x224a60 },
	{ 0x6706, 0x235124 },
	{ 0x6708, 0x21454c },
	{ 0x6709, 0x214834 },
	{ 0x670a, 0x222733 },
	{ 0x670b, 0x214e25 },
	{ 0x670c, 0x232945 },
	{ 0x670d, 0x214e24 },
	{ 0x670e, 0x232d27 },
	{ 0x670f, 0x222a7a },
	{ 0x6710, 0x222a7b },
	{ 0x6711, 0x236632 },
	{ 0x6712, 0x222f59 },
	{ 0x6713, 0x222f5a },
	{ 0x6714, 0x215574 },
	{ 0x6715, 0x215575 },
	{ 0x6716, 0x233648 },
	{ 0x6717, 0x215576 },
	{ 0x6718, 0x223571 },
	{ 0x6719, 0x233647 },
	{ 0x671a, 0x233646 },
	{ 0x671b, 0x215b2c },
	{ 0x671d, 0x215f67 },
	{ 0x671e, 0x233c29 },
	{ 0x671f, 0x215f66 },
	{ 0x6720, 0x22434e },
	{ 0x6721, 0x224641 },
	{ 0x6722, 0x224a62 },
	{ 0x6723, 0x225748 },
	{ 0x6724, 0x235126 },
	{ 0x6725, 0x236633 },
	{ 0x6726, 0x21764d },
	{ 0x6727, 0x217972 },
	{ 0x6728, 0x21454d },
	{ 0x672a, 0x21465c },
	{ 0x672b, 0x21465d },
	{ 0x672c, 0x21465b },
	{ 0x672d, 0x21465e },
	{ 0x672e, 0x21465a },
	{ 0x672f, 0x232252 },
	{ 0x6731, 0x214837 },
	{ 0x6732, 0x232377 },
	{ 0x6733, 0x222257 },
	{ 0x6734, 0x214836 },
	{ 0x6735, 0x214838 },
	{ 0x6736, 0x232378 },
	{ 0x6737, 0x232375 },
	{ 0x6738, 0x222252 },
	{ 0x6739, 0x222251 },
	{ 0x673a, 0x222254 },
	{ 0x673b, 0x222253 },
	{ 0x673c, 0x222256 },
	{ 0x673d, 0x214835 },
	{ 0x673e, 0x222250 },
	{ 0x673f, 0x222255 },
	{ 0x6744, 0x232648 },
	{ 0x6745, 0x22243e },
	{ 0x6746, 0x214a5f },
	{ 0x6747, 0x22243f },
	{ 0x6748, 0x222443 },
	{ 0x6749, 0x214a5e },
	{ 0x674a, 0x232649 },
	{ 0x674b, 0x222447 },
	{ 0x674c, 0x222442 },
	{ 0x674d, 0x222445 },
	{ 0x674e, 0x214a57 },
	{ 0x674f, 0x214a58 },
	{ 0x6750, 0x214a59 },
	{ 0x6751, 0x214a5a },
	{ 0x6752, 0x232645 },
	{ 0x6753, 0x214a61 },
	{ 0x6754, 0x232644 },
	{ 0x6755, 0x222441 },
	{ 0x6756, 0x214a5c },
	{ 0x6757, 0x214a62 },
	{ 0x6758, 0x232647 },
	{ 0x6759, 0x222440 },
	{ 0x675a, 0x222446 },
	{ 0x675b, 0x232642 },
	{ 0x675c, 0x214a5b },
	{ 0x675d, 0x222444 },
	{ 0x675e, 0x214a5d },
	{ 0x675f, 0x214a56 },
	{ 0x6760, 0x214a60 },
	{ 0x6761, 0x23264a },
	{ 0x6765, 0x236257 },
	{ 0x676a, 0x214e3a },
	{ 0x676b, 0x232947 },
	{ 0x676c, 0x222735 },
	{ 0x676d, 0x214e26 },
	{ 0x676f, 0x214e30 },
	{ 0x6770, 0x214e31 },
	{ 0x6771, 0x214e29 },
	{ 0x6772, 0x214e3b },
	{ 0x6773, 0x214e2b },
	{ 0x6774, 0x22273d },
	{ 0x6775, 0x214e36 },
	{ 0x6776, 0x222738 },
	{ 0x6777, 0x214e2c },
	{ 0x6778, 0x222747 },
	{ 0x6779, 0x222748 },
	{ 0x677a, 0x222740 },
	{ 0x677b, 0x222739 },
	{ 0x677c, 0x214e39 },
	{ 0x677d, 0x222745 },
	{ 0x677e, 0x214e34 },
	{ 0x677f, 0x214e32 },
	{ 0x6780, 0x232952 },
	{ 0x6781, 0x222746 },
	{ 0x6782, 0x232949 },
	{ 0x6783, 0x222744 },
	{ 0x6784, 0x22273c },
	{ 0x6785, 0x222734 },
	{ 0x6786, 0x22273b },
	{ 0x6787, 0x214e2d },
	{ 0x6788, 0x23625f },
	{ 0x6789, 0x214e33 },
	{ 0x678a, 0x23294a },
	{ 0x678b, 0x214e27 },
	{ 0x678c, 0x22273f },
	{ 0x678d, 0x22273e },
	{ 0x678e, 0x222736 },
	{ 0x678f, 0x23294f },
	{ 0x6790, 0x214e35 },
	{ 0x6791, 0x222742 },
	{ 0x6792, 0x222737 },
	{ 0x6793, 0x214e38 },
	{ 0x6794, 0x222749 },
	{ 0x6795, 0x214e28 },
	{ 0x6796, 0x232948 },
	{ 0x6797, 0x214e2f },
	{ 0x6798, 0x22273a },
	{ 0x6799, 0x222743 },
	{ 0x679a, 0x214e37 },
	{ 0x679c, 0x214e2a },
	{ 0x679d, 0x214e2e },
	{ 0x679f, 0x222741 },
	{ 0x67a2, 0x23294e },
	{ 0x67a3, 0x23294c },
	{ 0x67a4, 0x236528 },
	{ 0x67ac, 0x236529 },
	{ 0x67ae, 0x222b3d },
	{ 0x67af, 0x21515f },
	{ 0x67b0, 0x21516c },
	{ 0x67b1, 0x232d36 },
	{ 0x67b2, 0x222b38 },
	{ 0x67b3, 0x222b2e },
	{ 0x67b4, 0x215165 },
	{ 0x67b5, 0x222b2c },
	{ 0x67b6, 0x21515e },
	{ 0x67b7, 0x222b27 },
	{ 0x67b8, 0x215168 },
	{ 0x67b9, 0x222b34 },
	{ 0x67ba, 0x222b21 },
	{ 0x67bb, 0x222b23 },
	{ 0x67bc, 0x232d2e },
	{ 0x67bf, 0x232d30 },
	{ 0x67c0, 0x222b26 },
	{ 0x67c1, 0x222a7c },
	{ 0x67c2, 0x222b33 },
	{ 0x67c3, 0x222b43 },
	{ 0x67c4, 0x215163 },
	{ 0x67c5, 0x222b28 },
	{ 0x67c6, 0x222b3a },
	{ 0x67c7, 0x232d2d },
	{ 0x67c8, 0x222a7e },
	{ 0x67c9, 0x222b41 },
	{ 0x67ca, 0x222b42 },
	{ 0x67cb, 0x222b45 },
	{ 0x67cc, 0x222b3c },
	{ 0x67cd, 0x222b2d },
	{ 0x67ce, 0x222b35 },
	{ 0x67cf, 0x215169 },
	{ 0x67d0, 0x21515c },
	{ 0x67d1, 0x215164 },
	{ 0x67d2, 0x215170 },
	{ 0x67d3, 0x215159 },
	{ 0x67d4, 0x21515b },
	{ 0x67d5, 0x232d31 },
	{ 0x67d6, 0x232d2b },
	{ 0x67d7, 0x232d3a },
	{ 0x67d8, 0x222b25 },
	{ 0x67d9, 0x21516d },
	{ 0x67da, 0x215166 },
	{ 0x67db, 0x222b3f },
	{ 0x67dc, 0x222b22 },
	{ 0x67dd, 0x21516f },
	{ 0x67de, 0x21516a },
	{ 0x67df, 0x222b2b },
	{ 0x67e2, 0x21516e },
	{ 0x67e3, 0x222b32 },
	{ 0x67e4, 0x222b2a },
	{ 0x67e5, 0x215167 },
	{ 0x67e6, 0x222b3e },
	{ 0x67e7, 0x222b36 },
	{ 0x67e8, 0x232d2a },
	{ 0x67e9, 0x215161 },
	{ 0x67ea, 0x222b44 },
	{ 0x67eb, 0x222b29 },
	{ 0x67ec, 0x21515d },
	{ 0x67ed, 0x222b3b },
	{ 0x67ee, 0x222b31 },
	{ 0x67ef, 0x215162 },
	{ 0x67f0, 0x222b37 },
	{ 0x67f1, 0x21515a },
	{ 0x67f2, 0x222a7d },
	{ 0x67f3, 0x21516b },
	{ 0x67f4, 0x215627 },
	{ 0x67f5, 0x215160 },
	{ 0x67f6, 0x222b30 },
	{ 0x67f7, 0x222b2f },
	{ 0x67f8, 0x222b24 },
	{ 0x67f9, 0x232951 },
	{ 0x67fa, 0x222b40 },
	{ 0x67fb, 0x232d34 },
	{ 0x67fc, 0x222b39 },
	{ 0x67fe, 0x232d32 },
	{ 0x67ff, 0x215158 },
	{ 0x6800, 0x232d39 },
	{ 0x6801, 0x232d37 },
	{ 0x6805, 0x232d38 },
	{ 0x6806, 0x23652b },
	{ 0x6810, 0x23652a },
	{ 0x6812, 0x222f6e },
	{ 0x6813, 0x21562e },
	{ 0x6814, 0x222f6f },
	{ 0x6815, 0x23315d },
	{ 0x6816, 0x222f63 },
	{ 0x6817, 0x215623 },
	{ 0x6818, 0x21562f },
	{ 0x6819, 0x233157 },
	{ 0x681a, 0x222f5c },
	{ 0x681b, 0x233153 },
	{ 0x681c, 0x222f65 },
	{ 0x681d, 0x222f6d },
	{ 0x681e, 0x23315b },
	{ 0x681f, 0x222f5b },
	{ 0x6820, 0x222f76 },
	{ 0x6821, 0x215577 },
	{ 0x6822, 0x23315e },
	{ 0x6823, 0x233164 },
	{ 0x6824, 0x233150 },
	{ 0x6825, 0x222f75 },
	{ 0x6826, 0x222f70 },
	{ 0x6827, 0x23315f },
	{ 0x6828, 0x222f71 },
	{ 0x6829, 0x215621 },
	{ 0x682a, 0x21562c },
	{ 0x682b, 0x222f67 },
	{ 0x682c, 0x233156 },
	{ 0x682d, 0x222f68 },
	{ 0x682e, 0x222f72 },
	{ 0x682f, 0x222f69 },
	{ 0x6830, 0x233163 },
	{ 0x6831, 0x222f64 },
	{ 0x6832, 0x222f5e },
	{ 0x6833, 0x222f5f },
	{ 0x6834, 0x222f6c },
	{ 0x6835, 0x222f66 },
	{ 0x6836, 0x233154 },
	{ 0x6837, 0x23314f },
	{ 0x6838, 0x215578 },
	{ 0x6839, 0x21557c },
	{ 0x683a, 0x222f74 },
	{ 0x683b, 0x222f60 },
	{ 0x683c, 0x21562a },
	{ 0x683d, 0x215626 },
	{ 0x683e, 0x23315a },
	{ 0x6840, 0x215629 },
	{ 0x6841, 0x215630 },
	{ 0x6842, 0x21557d },
	{ 0x6843, 0x21562b },
	{ 0x6844, 0x222f6b },
	{ 0x6845, 0x21562d },
	{ 0x6846, 0x21557a },
	{ 0x6847, 0x233159 },
	{ 0x6848, 0x215579 },
	{ 0x6849, 0x222f5d },
	{ 0x684b, 0x222f61 },
	{ 0x684c, 0x215624 },
	{ 0x684d, 0x222f73 },
	{ 0x684e, 0x222f6a },
	{ 0x684f, 0x222f62 },
	{ 0x6850, 0x215628 },
	{ 0x6851, 0x215625 },
	{ 0x6852, 0x232d2f },
	{ 0x6853, 0x21557b },
	{ 0x6854, 0x21557e },
	{ 0x6855, 0x233162 },
	{ 0x6856, 0x233158 },
	{ 0x6858, 0x233161 },
	{ 0x6859, 0x233160 },
	{ 0x685a, 0x23652d },
	{ 0x685e, 0x23652c },
	{ 0x686b, 0x223628 },
	{ 0x686c, 0x233655 },
	{ 0x686d, 0x223576 },
	{ 0x686e, 0x223577 },
	{ 0x686f, 0x22357b },
	{ 0x6870, 0x233660 },
	{ 0x6871, 0x22362c },
	{ 0x6872, 0x223629 },
	{ 0x6873, 0x23364e },
	{ 0x6874, 0x223622 },
	{ 0x6875, 0x223621 },
	{ 0x6876, 0x215b33 },
	{ 0x6877, 0x223625 },
	{ 0x6878, 0x223634 },
	{ 0x6879, 0x223572 },
	{ 0x687a, 0x23365b },
	{ 0x687b, 0x223635 },
	{ 0x687c, 0x223627 },
	{ 0x687d, 0x223639 },
	{ 0x687e, 0x22362d },
	{ 0x687f, 0x215b32 },
	{ 0x6880, 0x22362b },
	{ 0x6881, 0x215b2d },
	{ 0x6882, 0x215b42 },
	{ 0x6883, 0x215b38 },
	{ 0x6884, 0x233657 },
	{ 0x6885, 0x215b3c },
	{ 0x6886, 0x215b3b },
	{ 0x6887, 0x223573 },
	{ 0x6889, 0x223632 },
	{ 0x688a, 0x223638 },
	{ 0x688b, 0x223630 },
	{ 0x688c, 0x223637 },
	{ 0x688e, 0x233651 },
	{ 0x688f, 0x223624 },
	{ 0x6890, 0x223574 },
	{ 0x6891, 0x223636 },
	{ 0x6892, 0x223626 },
	{ 0x6893, 0x215b30 },
	{ 0x6894, 0x215b3d },
	{ 0x6895, 0x23365a },
	{ 0x6896, 0x22362f },
	{ 0x6897, 0x215b36 },
	{ 0x6898, 0x23364d },
	{ 0x6899, 0x23365c },
	{ 0x689a, 0x233650 },
	{ 0x689b, 0x22362e },
	{ 0x689c, 0x223575 },
	{ 0x689d, 0x215b3e },
	{ 0x689e, 0x23364b },
	{ 0x689f, 0x215b40 },
	{ 0x68a0, 0x223631 },
	{ 0x68a1, 0x215b41 },
	{ 0x68a2, 0x215b2f },
	{ 0x68a3, 0x22357c },
	{ 0x68a4, 0x223633 },
	{ 0x68a5, 0x233654 },
	{ 0x68a6, 0x233478 },
	{ 0x68a7, 0x215b35 },
	{ 0x68a8, 0x215b3f },
	{ 0x68a9, 0x22357e },
	{ 0x68aa, 0x22362a },
	{ 0x68ab, 0x223579 },
	{ 0x68ac, 0x22357d },
	{ 0x68ad, 0x215b3a },
	{ 0x68ae, 0x223578 },
	{ 0x68af, 0x215b2e },
	{ 0x68b0, 0x215b37 },
	{ 0x68b1, 0x215b34 },
	{ 0x68b2, 0x223623 },
	{ 0x68b3, 0x215622 },
	{ 0x68b4, 0x223c63 },
	{ 0x68b5, 0x215b31 },
	{ 0x68b6, 0x23364c },
	{ 0x68b7, 0x233652 },
	{ 0x68b8, 0x23365e },
	{ 0x68b9, 0x23365f },
	{ 0x68c1, 0x233656 },
	{ 0x68c3, 0x233c45 },
	{ 0x68c4, 0x215b39 },
	{ 0x68c5, 0x233c41 },
	{ 0x68c6, 0x223c66 },
	{ 0x68c7, 0x223c7c },
	{ 0x68c8, 0x223c71 },
	{ 0x68c9, 0x215f7b },
	{ 0x68ca, 0x233c38 },
	{ 0x68cb, 0x215f76 },
	{ 0x68cc, 0x223c60 },
	{ 0x68cd, 0x215f77 },
	{ 0x68ce, 0x223c70 },
	{ 0x68cf, 0x233c3e },
	{ 0x68d0, 0x223c69 },
	{ 0x68d1, 0x223c76 },
	{ 0x68d2, 0x215f73 },
	{ 0x68d3, 0x223c4e },
	{ 0x68d4, 0x223c78 },
	{ 0x68d5, 0x215f69 },
	{ 0x68d6, 0x223c56 },
	{ 0x68d7, 0x215f6c },
	{ 0x68d8, 0x215f6b },
	{ 0x68da, 0x215f7c },
	{ 0x68db, 0x233653 },
	{ 0x68dc, 0x223c50 },
	{ 0x68dd, 0x223c72 },
	{ 0x68de, 0x223c73 },
	{ 0x68df, 0x215f6e },
	{ 0x68e0, 0x215f6a },
	{ 0x68e1, 0x223c5e },
	{ 0x68e2, 0x233c3d },
	{ 0x68e3, 0x215f75 },
	{ 0x68e4, 0x223c59 },
	{ 0x68e5, 0x233c32 },
	{ 0x68e6, 0x223c74 },
	{ 0x68e7, 0x215f71 },
	{ 0x68e8, 0x223c6c },
	{ 0x68e9, 0x223c79 },
	{ 0x68ea, 0x223c53 },
	{ 0x68eb, 0x223c58 },
	{ 0x68ec, 0x223c52 },
	{ 0x68ed, 0x233c2a },
	{ 0x68ee, 0x215f70 },
	{ 0x68ef, 0x223c65 },
	{ 0x68f0, 0x224364 },
	{ 0x68f1, 0x223c54 },
	{ 0x68f2, 0x215f74 },
	{ 0x68f3, 0x223c5d },
	{ 0x68f4, 0x223c75 },
	{ 0x68f5, 0x215f6f },
	{ 0x68f6, 0x223c5a },
	{ 0x68f7, 0x223c57 },
	{ 0x68f8, 0x223c68 },
	{ 0x68f9, 0x215f72 },
	{ 0x68fa, 0x215f68 },
	{ 0x68fb, 0x215f7e },
	{ 0x68fc, 0x223c6b },
	{ 0x68fd, 0x223c6a },
	{ 0x68fe, 0x233c31 },
	{ 0x68ff, 0x233c42 },
	{ 0x6900, 0x233c39 },
	{ 0x6901, 0x233c3b },
	{ 0x6902, 0x233c34 },
	{ 0x6903, 0x233c2f },
	{ 0x6904, 0x223c4f },
	{ 0x6905, 0x215f6d },
	{ 0x6906, 0x223c77 },
	{ 0x6907, 0x223c5f },
	{ 0x6908, 0x223c61 },
	{ 0x6909, 0x233c37 },
	{ 0x690a, 0x223c6e },
	{ 0x690b, 0x223c6d },
	{ 0x690c, 0x223c4d },
	{ 0x690d, 0x215f78 },
	{ 0x690e, 0x215f7a },
	{ 0x690f, 0x223c55 },
	{ 0x6910, 0x223c5c },
	{ 0x6911, 0x223c64 },
	{ 0x6912, 0x215f79 },
	{ 0x6913, 0x223c5b },
	{ 0x6914, 0x223c67 },
	{ 0x6915, 0x223c7a },
	{ 0x6917, 0x223c6f },
	{ 0x6918, 0x233c3c },
	{ 0x691c, 0x233c44 },
	{ 0x691e, 0x233c33 },
	{ 0x6925, 0x223c7b },
	{ 0x6929, 0x23652f },
	{ 0x692a, 0x223c51 },
	{ 0x692c, 0x23652e },
	{ 0x692e, 0x233c40 },
	{ 0x692f, 0x224378 },
	{ 0x6930, 0x21644c },
	{ 0x6931, 0x234165 },
	{ 0x6932, 0x224376 },
	{ 0x6933, 0x224361 },
	{ 0x6934, 0x224366 },
	{ 0x6935, 0x22435f },
	{ 0x6936, 0x234177 },
	{ 0x6937, 0x224372 },
	{ 0x6938, 0x224351 },
	{ 0x6939, 0x224358 },
	{ 0x693b, 0x224370 },
	{ 0x693c, 0x22437a },
	{ 0x693d, 0x224362 },
	{ 0x693e, 0x234168 },
	{ 0x693f, 0x224355 },
	{ 0x6940, 0x224368 },
	{ 0x6941, 0x22436d },
	{ 0x6942, 0x224359 },
	{ 0x6943, 0x23416b },
	{ 0x6944, 0x22436a },
	{ 0x6945, 0x224356 },
	{ 0x6946, 0x23415d },
	{ 0x6947, 0x234175 },
	{ 0x6948, 0x22435d },
	{ 0x6949, 0x22435e },
	{ 0x694a, 0x21644e },
	{ 0x694b, 0x224371 },
	{ 0x694c, 0x22436f },
	{ 0x694d, 0x234173 },
	{ 0x694e, 0x224352 },
	{ 0x694f, 0x224374 },
	{ 0x6950, 0x234174 },
	{ 0x6951, 0x224375 },
	{ 0x6952, 0x224377 },
	{ 0x6953, 0x216452 },
	{ 0x6954, 0x21644a },
	{ 0x6955, 0x23416f },
	{ 0x6956, 0x22357a },
	{ 0x6957, 0x22435a },
	{ 0x6958, 0x22436c },
	{ 0x6959, 0x22435b },
	{ 0x695a, 0x216447 },
	{ 0x695b, 0x216457 },
	{ 0x695c, 0x224373 },
	{ 0x695d, 0x216455 },
	{ 0x695e, 0x216451 },
	{ 0x695f, 0x224350 },
	{ 0x6960, 0x216449 },
	{ 0x6961, 0x234179 },
	{ 0x6962, 0x224353 },
	{ 0x6963, 0x216456 },
	{ 0x6964, 0x234178 },
	{ 0x6965, 0x224363 },
	{ 0x6966, 0x22434f },
	{ 0x6967, 0x234176 },
	{ 0x6968, 0x21644f },
	{ 0x6969, 0x224367 },
	{ 0x696a, 0x224357 },
	{ 0x696b, 0x216450 },
	{ 0x696c, 0x224360 },
	{ 0x696d, 0x216446 },
	{ 0x696e, 0x215f7d },
	{ 0x696f, 0x224369 },
	{ 0x6970, 0x223c62 },
	{ 0x6971, 0x224354 },
	{ 0x6973, 0x23416d },
	{ 0x6974, 0x22436e },
	{ 0x6975, 0x21644b },
	{ 0x6976, 0x22436b },
	{ 0x6977, 0x216448 },
	{ 0x6978, 0x224365 },
	{ 0x6979, 0x216453 },
	{ 0x697a, 0x22435c },
	{ 0x697b, 0x224379 },
	{ 0x697c, 0x23416a },
	{ 0x697d, 0x23417b },
	{ 0x6982, 0x21644d },
	{ 0x6983, 0x22452c },
	{ 0x6985, 0x234172 },
	{ 0x6986, 0x216454 },
	{ 0x698d, 0x224a70 },
	{ 0x698e, 0x224a6e },
	{ 0x698f, 0x23473a },
	{ 0x6990, 0x224b26 },
	{ 0x6991, 0x224a6c },
	{ 0x6992, 0x23473d },
	{ 0x6993, 0x224a7e },
	{ 0x6994, 0x216445 },
	{ 0x6995, 0x216928 },
	{ 0x6996, 0x224a68 },
	{ 0x6997, 0x224b25 },
	{ 0x6998, 0x234751 },
	{ 0x6999, 0x224a6d },
	{ 0x699a, 0x224a7b },
	{ 0x699b, 0x21692d },
	{ 0x699c, 0x216926 },
	{ 0x699d, 0x23474e },
	{ 0x699e, 0x224b23 },
	{ 0x699f, 0x234746 },
	{ 0x69a0, 0x224a66 },
	{ 0x69a1, 0x224b22 },
	{ 0x69a2, 0x234747 },
	{ 0x69a3, 0x216938 },
	{ 0x69a4, 0x224a77 },
	{ 0x69a5, 0x224b29 },
	{ 0x69a6, 0x216936 },
	{ 0x69a7, 0x224a6f },
	{ 0x69a8, 0x216927 },
	{ 0x69a9, 0x224a71 },
	{ 0x69aa, 0x224b21 },
	{ 0x69ab, 0x216930 },
	{ 0x69ac, 0x224a6a },
	{ 0x69ad, 0x216934 },
	{ 0x69ae, 0x21692a },
	{ 0x69af, 0x224a73 },
	{ 0x69b0, 0x224a69 },
	{ 0x69b1, 0x224a63 },
	{ 0x69b2, 0x23473e },
	{ 0x69b3, 0x224a7d },
	{ 0x69b4, 0x216931 },
	{ 0x69b5, 0x224b28 },
	{ 0x69b6, 0x224a64 },
	{ 0x69b7, 0x21692e },
	{ 0x69b9, 0x224a79 },
	{ 0x69ba, 0x236352 },
	{ 0x69bb, 0x21692f },
	{ 0x69bc, 0x224a6b },
	{ 0x69bd, 0x224a76 },
	{ 0x69be, 0x224a72 },
	{ 0x69bf, 0x224a74 },
	{ 0x69c0, 0x234743 },
	{ 0x69c1, 0x216929 },
	{ 0x69c2, 0x224b27 },
	{ 0x69c3, 0x216937 },
	{ 0x69c4, 0x224a75 },
	{ 0x69c5, 0x23473b },
	{ 0x69c6, 0x224b2a },
	{ 0x69c8, 0x23473c },
	{ 0x69c9, 0x224a65 },
	{ 0x69ca, 0x224a7a },
	{ 0x69cb, 0x21692c },
	{ 0x69cc, 0x216935 },
	{ 0x69cd, 0x216933 },
	{ 0x69ce, 0x224a67 },
	{ 0x69cf, 0x224a7c },
	{ 0x69d0, 0x216932 },
	{ 0x69d1, 0x234745 },
	{ 0x69d2, 0x234748 },
	{ 0x69d3, 0x21692b },
	{ 0x69d4, 0x224a78 },
	{ 0x69d5, 0x23474d },
	{ 0x69d6, 0x234744 },
	{ 0x69d8, 0x234c54 },
	{ 0x69d9, 0x224b24 },
	{ 0x69e1, 0x23474c },
	{ 0x69e2, 0x22507c },
	{ 0x69e3, 0x234742 },
	{ 0x69e4, 0x225078 },
	{ 0x69e5, 0x225074 },
	{ 0x69e6, 0x22512a },
	{ 0x69e7, 0x225127 },
	{ 0x69e8, 0x216d37 },
	{ 0x69e9, 0x234c64 },
	{ 0x69ea, 0x234c60 },
	{ 0x69eb, 0x22512e },
	{ 0x69ec, 0x22507b },
	{ 0x69ed, 0x216d42 },
	{ 0x69ee, 0x225124 },
	{ 0x69ef, 0x234c4f },
	{ 0x69f0, 0x234c51 },
	{ 0x69f1, 0x225077 },
	{ 0x69f2, 0x225123 },
	{ 0x69f3, 0x216d3f },
	{ 0x69f4, 0x225137 },
	{ 0x69f6, 0x225134 },
	{ 0x69f7, 0x225126 },
	{ 0x69f8, 0x225075 },
	{ 0x69f9, 0x234c5f },
	{ 0x69fa, 0x234c57 },
	{ 0x69fb, 0x22512b },
	{ 0x69fc, 0x22512d },
	{ 0x69fd, 0x216d3b },
	{ 0x69fe, 0x225121 },
	{ 0x69ff, 0x22507a },
	{ 0x6a00, 0x225071 },
	{ 0x6a01, 0x216d38 },
	{ 0x6a02, 0x216d40 },
	{ 0x6a04, 0x225130 },
	{ 0x6a05, 0x216d41 },
	{ 0x6a06, 0x225072 },
	{ 0x6a07, 0x225136 },
	{ 0x6a08, 0x225129 },
	{ 0x6a09, 0x22512f },
	{ 0x6a0a, 0x216d3e },
	{ 0x6a0b, 0x234c4d },
	{ 0x6a0c, 0x234c50 },
	{ 0x6a0d, 0x22512c },
	{ 0x6a0e, 0x234c47 },
	{ 0x6a0f, 0x225133 },
	{ 0x6a10, 0x234c5b },
	{ 0x6a11, 0x216d43 },
	{ 0x6a12, 0x234c56 },
	{ 0x6a13, 0x216d3d },
	{ 0x6a14, 0x225125 },
	{ 0x6a15, 0x225076 },
	{ 0x6a16, 0x225138 },
	{ 0x6a17, 0x225073 },
	{ 0x6a18, 0x225131 },
	{ 0x6a19, 0x216d3a },
	{ 0x6a1a, 0x234c4a },
	{ 0x6a1b, 0x22507d },
	{ 0x6a1c, 0x234c49 },
	{ 0x6a1d, 0x22507e },
	{ 0x6a1e, 0x216d39 },
	{ 0x6a1f, 0x216d36 },
	{ 0x6a20, 0x225079 },
	{ 0x6a21, 0x216d3c },
	{ 0x6a22, 0x234c52 },
	{ 0x6a23, 0x216d35 },
	{ 0x6a24, 0x234c62 },
	{ 0x6a25, 0x225132 },
	{ 0x6a26, 0x225135 },
	{ 0x6a27, 0x225122 },
	{ 0x6a28, 0x225755 },
	{ 0x6a29, 0x234c5e },
	{ 0x6a2a, 0x234c59 },
	{ 0x6a2c, 0x234c61 },
	{ 0x6a2d, 0x236530 },
	{ 0x6a32, 0x22574d },
	{ 0x6a33, 0x23512c },
	{ 0x6a34, 0x225749 },
	{ 0x6a35, 0x217121 },
	{ 0x6a36, 0x23513c },
	{ 0x6a37, 0x235138 },
	{ 0x6a38, 0x217074 },
	{ 0x6a39, 0x217079 },
	{ 0x6a3a, 0x217075 },
	{ 0x6a3b, 0x225757 },
	{ 0x6a3c, 0x225762 },
	{ 0x6a3d, 0x217073 },
	{ 0x6a3e, 0x22574f },
	{ 0x6a3f, 0x225758 },
	{ 0x6a40, 0x225128 },
	{ 0x6a41, 0x225759 },
	{ 0x6a42, 0x235128 },
	{ 0x6a43, 0x23512b },
	{ 0x6a44, 0x21707a },
	{ 0x6a45, 0x235140 },
	{ 0x6a46, 0x225768 },
	{ 0x6a47, 0x21707e },
	{ 0x6a48, 0x217123 },
	{ 0x6a49, 0x22574b },
	{ 0x6a4a, 0x23513b },
	{ 0x6a4b, 0x21707d },
	{ 0x6a4c, 0x235131 },
	{ 0x6a4d, 0x225766 },
	{ 0x6a4e, 0x225767 },
	{ 0x6a4f, 0x22575d },
	{ 0x6a50, 0x22575c },
	{ 0x6a51, 0x225754 },
	{ 0x6a52, 0x235129 },
	{ 0x6a53, 0x23513e },
	{ 0x6a54, 0x22575e },
	{ 0x6a55, 0x225765 },
	{ 0x6a56, 0x225764 },
	{ 0x6a57, 0x23512f },
	{ 0x6a58, 0x217078 },
	{ 0x6a59, 0x217076 },
	{ 0x6a5a, 0x225756 },
	{ 0x6a5b, 0x225753 },
	{ 0x6a5c, 0x235144 },
	{ 0x6a5d, 0x225750 },
	{ 0x6a5e, 0x225763 },
	{ 0x6a5f, 0x217122 },
	{ 0x6a60, 0x225761 },
	{ 0x6a61, 0x21707c },
	{ 0x6a62, 0x21707b },
	{ 0x6a63, 0x235127 },
	{ 0x6a64, 0x22575b },
	{ 0x6a66, 0x22574a },
	{ 0x6a67, 0x22574c },
	{ 0x6a68, 0x22574e },
	{ 0x6a69, 0x225760 },
	{ 0x6a6a, 0x22575a },
	{ 0x6a6b, 0x217077 },
	{ 0x6a6c, 0x23512e },
	{ 0x6a6d, 0x225751 },
	{ 0x6a6e, 0x235132 },
	{ 0x6a6f, 0x22575f },
	{ 0x6a70, 0x235141 },
	{ 0x6a71, 0x23513a },
	{ 0x6a76, 0x225752 },
	{ 0x6a77, 0x236531 },
	{ 0x6a7a, 0x236532 },
	{ 0x6a7d, 0x235475 },
	{ 0x6a7e, 0x217378 },
	{ 0x6a7f, 0x225d31 },
	{ 0x6a80, 0x217371 },
	{ 0x6a81, 0x225d22 },
	{ 0x6a82, 0x23547b },
	{ 0x6a83, 0x225d2d },
	{ 0x6a84, 0x217373 },
	{ 0x6a85, 0x225d34 },
	{ 0x6a86, 0x235521 },
	{ 0x6a87, 0x225d29 },
	{ 0x6a88, 0x23547c },
	{ 0x6a89, 0x225d24 },
	{ 0x6a8a, 0x235476 },
	{ 0x6a8c, 0x225d35 },
	{ 0x6a8d, 0x225c7e },
	{ 0x6a8e, 0x225d2b },
	{ 0x6a8f, 0x235527 },
	{ 0x6a90, 0x21737a },
	{ 0x6a91, 0x225d30 },
	{ 0x6a92, 0x225d36 },
	{ 0x6a93, 0x225d2a },
	{ 0x6a94, 0x217372 },
	{ 0x6a95, 0x225d2c },
	{ 0x6a96, 0x225d21 },
	{ 0x6a97, 0x217379 },
	{ 0x6a98, 0x235523 },
	{ 0x6a99, 0x23547a },
	{ 0x6a9a, 0x225d33 },
	{ 0x6a9b, 0x225d26 },
	{ 0x6a9c, 0x217375 },
	{ 0x6a9d, 0x235524 },
	{ 0x6a9e, 0x225d28 },
	{ 0x6a9f, 0x225d25 },
	{ 0x6aa0, 0x21737b },
	{ 0x6aa1, 0x225d27 },
	{ 0x6aa2, 0x217374 },
	{ 0x6aa3, 0x217377 },
	{ 0x6aa4, 0x225d2f },
	{ 0x6aa5, 0x225d23 },
	{ 0x6aa6, 0x225d32 },
	{ 0x6aa7, 0x235478 },
	{ 0x6aa8, 0x225d2e },
	{ 0x6aaa, 0x235529 },
	{ 0x6aab, 0x235774 },
	{ 0x6aac, 0x21764f },
	{ 0x6aad, 0x226173 },
	{ 0x6aae, 0x217654 },
	{ 0x6aaf, 0x217655 },
	{ 0x6ab0, 0x235777 },
	{ 0x6ab1, 0x235821 },
	{ 0x6ab2, 0x235776 },
	{ 0x6ab3, 0x21764e },
	{ 0x6ab4, 0x226172 },
	{ 0x6ab5, 0x235778 },
	{ 0x6ab6, 0x22616f },
	{ 0x6ab7, 0x226170 },
	{ 0x6ab8, 0x217652 },
	{ 0x6ab9, 0x22616a },
	{ 0x6aba, 0x22616e },
	{ 0x6abb, 0x217651 },
	{ 0x6abc, 0x23577e },
	{ 0x6abd, 0x22616b },
	{ 0x6abe, 0x235779 },
	{ 0x6abf, 0x235823 },
	{ 0x6ac0, 0x23577d },
	{ 0x6ac1, 0x23577a },
	{ 0x6ac2, 0x217653 },
	{ 0x6ac3, 0x217650 },
	{ 0x6ac4, 0x235822 },
	{ 0x6ac5, 0x226169 },
	{ 0x6ac6, 0x22616d },
	{ 0x6ac7, 0x226171 },
	{ 0x6ac8, 0x23577b },
	{ 0x6aca, 0x236533 },
	{ 0x6acb, 0x22655c },
	{ 0x6acc, 0x226559 },
	{ 0x6acd, 0x226562 },
	{ 0x6ace, 0x235a44 },
	{ 0x6acf, 0x226561 },
	{ 0x6ad0, 0x22655f },
	{ 0x6ad1, 0x22655a },
	{ 0x6ad2, 0x235a4f },
	{ 0x6ad3, 0x21783f },
	{ 0x6ad4, 0x235a45 },
	{ 0x6ad5, 0x235a4e },
	{ 0x6ad7, 0x235a47 },
	{ 0x6ad8, 0x235a4d },
	{ 0x6ad9, 0x22655b },
	{ 0x6ada, 0x21783e },
	{ 0x6adb, 0x217376 },
	{ 0x6adc, 0x22655e },
	{ 0x6add, 0x21783d },
	{ 0x6ade, 0x226563 },
	{ 0x6adf, 0x22655d },
	{ 0x6ae0, 0x226558 },
	{ 0x6ae1, 0x22616c },
	{ 0x6ae2, 0x235a48 },
	{ 0x6ae3, 0x235a46 },
	{ 0x6ae5, 0x21783c },
	{ 0x6ae6, 0x236534 },
	{ 0x6ae7, 0x226557 },
	{ 0x6ae8, 0x226924 },
	{ 0x6ae9, 0x235c49 },
	{ 0x6aea, 0x226923 },
	{ 0x6aeb, 0x226560 },
	{ 0x6aec, 0x217973 },
	{ 0x6aed, 0x235775 },
	{ 0x6aee, 0x226927 },
	{ 0x6aef, 0x226928 },
	{ 0x6af0, 0x226922 },
	{ 0x6af1, 0x226926 },
	{ 0x6af3, 0x226921 },
	{ 0x6af4, 0x235c47 },
	{ 0x6af5, 0x236535 },
	{ 0x6af8, 0x226b5f },
	{ 0x6af9, 0x226925 },
	{ 0x6afa, 0x217a72 },
	{ 0x6afb, 0x217a70 },
	{ 0x6afc, 0x226b5d },
	{ 0x6afd, 0x235e35 },
	{ 0x6afe, 0x235e34 },
	{ 0x6aff, 0x235e33 },
	{ 0x6b00, 0x226b60 },
	{ 0x6b01, 0x235e37 },
	{ 0x6b02, 0x226b5c },
	{ 0x6b03, 0x226b5e },
	{ 0x6b04, 0x217a71 },
	{ 0x6b06, 0x235f4f },
	{ 0x6b07, 0x235f4e },
	{ 0x6b08, 0x226d53 },
	{ 0x6b09, 0x226d54 },
	{ 0x6b0a, 0x217b62 },
	{ 0x6b0b, 0x226d52 },
	{ 0x6b0d, 0x236536 },
	{ 0x6b0e, 0x236537 },
	{ 0x6b0f, 0x226f31 },
	{ 0x6b10, 0x217c3b },
	{ 0x6b11, 0x226f2f },
	{ 0x6b12, 0x226f30 },
	{ 0x6b13, 0x22703a },
	{ 0x6b14, 0x236074 },
	{ 0x6b16, 0x217d23 },
	{ 0x6b17, 0x227123 },
	{ 0x6b18, 0x227121 },
	{ 0x6b19, 0x227122 },
	{ 0x6b1a, 0x227124 },
	{ 0x6b1b, 0x236140 },
	{ 0x6b1c, 0x236165 },
	{ 0x6b1d, 0x236141 },
	{ 0x6b1e, 0x22722b },
	{ 0x6b20, 0x21454e },
	{ 0x6b21, 0x214839 },
	{ 0x6b22, 0x232379 },
	{ 0x6b23, 0x214e3c },
	{ 0x6b25, 0x22274a },
	{ 0x6b26, 0x232953 },
	{ 0x6b27, 0x232954 },
	{ 0x6b28, 0x222b46 },
	{ 0x6b29, 0x236269 },
	{ 0x6b2a, 0x232d3c },
	{ 0x6b2b, 0x233166 },
	{ 0x6b2c, 0x222f77 },
	{ 0x6b2d, 0x222f79 },
	{ 0x6b2e, 0x233165 },
	{ 0x6b2f, 0x222f78 },
	{ 0x6b30, 0x233167 },
	{ 0x6b31, 0x222f7a },
	{ 0x6b32, 0x215b43 },
	{ 0x6b33, 0x22363b },
	{ 0x6b34, 0x222f7b },
	{ 0x6b35, 0x233662 },
	{ 0x6b36, 0x22363a },
	{ 0x6b37, 0x22363c },
	{ 0x6b38, 0x22363d },
	{ 0x6b39, 0x223c7d },
	{ 0x6b3a, 0x216022 },
	{ 0x6b3b, 0x223c7e },
	{ 0x6b3c, 0x223d22 },
	{ 0x6b3d, 0x216023 },
	{ 0x6b3e, 0x216021 },
	{ 0x6b3f, 0x223d21 },
	{ 0x6b40, 0x23417d },
	{ 0x6b41, 0x224422 },
	{ 0x6b42, 0x22437e },
	{ 0x6b43, 0x22437d },
	{ 0x6b44, 0x23417c },
	{ 0x6b45, 0x22437c },
	{ 0x6b46, 0x22437b },
	{ 0x6b47, 0x216458 },
	{ 0x6b48, 0x224421 },
	{ 0x6b49, 0x216939 },
	{ 0x6b4a, 0x224b2b },
	{ 0x6b4b, 0x224b2d },
	{ 0x6b4c, 0x21693a },
	{ 0x6b4d, 0x224b2c },
	{ 0x6b4e, 0x216d45 },
	{ 0x6b4f, 0x234c66 },
	{ 0x6b50, 0x216d44 },
	{ 0x6b51, 0x225139 },
	{ 0x6b52, 0x234c65 },
	{ 0x6b53, 0x234c67 },
	{ 0x6b54, 0x22576a },
	{ 0x6b55, 0x225769 },
	{ 0x6b56, 0x22576b },
	{ 0x6b57, 0x235146 },
	{ 0x6b58, 0x235145 },
	{ 0x6b59, 0x217124 },
	{ 0x6b5b, 0x225d37 },
	{ 0x6b5c, 0x21737c },
	{ 0x6b5d, 0x23552b },
	{ 0x6b5e, 0x226174 },
	{ 0x6b5f, 0x217656 },
	{ 0x6b60, 0x226564 },
	{ 0x6b61, 0x217b63 },
	{ 0x6b62, 0x21454f },
	{ 0x6b63, 0x21465f },
	{ 0x6b64, 0x21483a },
	{ 0x6b65, 0x214a63 },
	{ 0x6b66, 0x214e3d },
	{ 0x6b67, 0x214e3e },
	{ 0x6b68, 0x232955 },
	{ 0x6b69, 0x232956 },
	{ 0x6b6a, 0x215171 },
	{ 0x6b6b, 0x232d3d },
	{ 0x6b6c, 0x233168 },
	{ 0x6b6d, 0x222f7c },
	{ 0x6b6e, 0x233c49 },
	{ 0x6b6f, 0x233c47 },
	{ 0x6b71, 0x23417e },
	{ 0x6b72, 0x216459 },
	{ 0x6b73, 0x234221 },
	{ 0x6b74, 0x234753 },
	{ 0x6b76, 0x225259 },
	{ 0x6b77, 0x217125 },
	{ 0x6b78, 0x217657 },
	{ 0x6b79, 0x214550 },
	{ 0x6b7a, 0x232253 },
	{ 0x6b7b, 0x21483b },
	{ 0x6b7e, 0x22274c },
	{ 0x6b7f, 0x214e3f },
	{ 0x6b80, 0x22274b },
	{ 0x6b81, 0x232958 },
	{ 0x6b82, 0x222b47 },
	{ 0x6b83, 0x215172 },
	{ 0x6b84, 0x222b48 },
	{ 0x6b86, 0x215173 },
	{ 0x6b88, 0x222f7e },
	{ 0x6b89, 0x215632 },
	{ 0x6b8a, 0x215631 },
	{ 0x6b8b, 0x23316a },
	{ 0x6b8c, 0x223642 },
	{ 0x6b8d, 0x223640 },
	{ 0x6b8e, 0x223641 },
	{ 0x6b8f, 0x22363f },
	{ 0x6b90, 0x233664 },
	{ 0x6b91, 0x22363e },
	{ 0x6b94, 0x223d23 },
	{ 0x6b95, 0x223d26 },
	{ 0x6b96, 0x216025 },
	{ 0x6b97, 0x223d24 },
	{ 0x6b98, 0x216024 },
	{ 0x6b99, 0x223d25 },
	{ 0x6b9b, 0x224423 },
	{ 0x6b9c, 0x234222 },
	{ 0x6b9d, 0x236354 },
	{ 0x6b9e, 0x224b2e },
	{ 0x6b9f, 0x224b2f },
	{ 0x6ba0, 0x224b30 },
	{ 0x6ba1, 0x234754 },
	{ 0x6ba2, 0x22513c },
	{ 0x6ba3, 0x22513b },
	{ 0x6ba4, 0x216d46 },
	{ 0x6ba5, 0x22513a },
	{ 0x6ba6, 0x22513d },
	{ 0x6ba7, 0x22576c },
	{ 0x6baa, 0x22576d },
	{ 0x6bab, 0x22576e },
	{ 0x6bad, 0x225d38 },
	{ 0x6bae, 0x21737d },
	{ 0x6baf, 0x217658 },
	{ 0x6bb0, 0x226565 },
	{ 0x6bb2, 0x217a73 },
	{ 0x6bb3, 0x22213f },
	{ 0x6bb4, 0x232959 },
	{ 0x6bb5, 0x215174 },
	{ 0x6bb6, 0x222b49 },
	{ 0x6bb7, 0x215633 },
	{ 0x6bba, 0x215b44 },
	{ 0x6bbb, 0x233665 },
	{ 0x6bbc, 0x216026 },
	{ 0x6bbd, 0x223d27 },
	{ 0x6bbe, 0x233c4b },
	{ 0x6bbf, 0x21645b },
	{ 0x6bc0, 0x21645a },
	{ 0x6bc1, 0x234226 },
	{ 0x6bc3, 0x224b31 },
	{ 0x6bc4, 0x224b32 },
	{ 0x6bc5, 0x216d47 },
	{ 0x6bc6, 0x216d48 },
	{ 0x6bc7, 0x225770 },
	{ 0x6bc8, 0x22576f },
	{ 0x6bc9, 0x226175 },
	{ 0x6bca, 0x226f32 },
	{ 0x6bcb, 0x214551 },
	{ 0x6bcc, 0x222140 },
	{ 0x6bcd, 0x214660 },
	{ 0x6bce, 0x23237a },
	{ 0x6bcf, 0x214a64 },
	{ 0x6bd0, 0x222448 },
	{ 0x6bd1, 0x23295a },
	{ 0x6bd2, 0x215175 },
	{ 0x6bd3, 0x21645c },
	{ 0x6bd4, 0x214552 },
	{ 0x6bd6, 0x222b4a },
	{ 0x6bd7, 0x215176 },
	{ 0x6bd8, 0x222b4b },
	{ 0x6bda, 0x21737e },
	{ 0x6bdb, 0x214553 },
	{ 0x6bdc, 0x236538 },
	{ 0x6bdd, 0x236539 },
	{ 0x6bde, 0x22274d },
	{ 0x6be0, 0x222b4c },
	{ 0x6be1, 0x232d42 },
	{ 0x6be2, 0x223025 },
	{ 0x6be3, 0x223024 },
	{ 0x6be4, 0x223022 },
	{ 0x6be5, 0x23316e },
	{ 0x6be6, 0x223021 },
	{ 0x6be7, 0x223026 },
	{ 0x6be8, 0x223023 },
	{ 0x6be9, 0x23316c },
	{ 0x6bea, 0x23316d },
	{ 0x6beb, 0x215b45 },
	{ 0x6bec, 0x215b46 },
	{ 0x6bed, 0x233666 },
	{ 0x6bef, 0x216027 },
	{ 0x6bf0, 0x223d28 },
	{ 0x6bf2, 0x223d29 },
	{ 0x6bf3, 0x223d2a },
	{ 0x6bf4, 0x233c4d },
	{ 0x6bf6, 0x23653a },
	{ 0x6bf7, 0x224427 },
	{ 0x6bf8, 0x224428 },
	{ 0x6bf9, 0x224426 },
	{ 0x6bfa, 0x234228 },
	{ 0x6bfb, 0x224424 },
	{ 0x6bfc, 0x224425 },
	{ 0x6bfd, 0x21645d },
	{ 0x6bfe, 0x224b33 },
	{ 0x6bff, 0x225140 },
	{ 0x6c00, 0x22513f },
	{ 0x6c01, 0x22513e },
	{ 0x6c02, 0x225141 },
	{ 0x6c03, 0x225772 },
	{ 0x6c04, 0x225771 },
	{ 0x6c05, 0x217126 },
	{ 0x6c06, 0x225773 },
	{ 0x6c08, 0x217421 },
	{ 0x6c09, 0x225d39 },
	{ 0x6c0a, 0x23552d },
	{ 0x6c0b, 0x226176 },
	{ 0x6c0c, 0x226566 },
	{ 0x6c0d, 0x226d55 },
	{ 0x6c0f, 0x214554 },
	{ 0x6c10, 0x214662 },
	{ 0x6c11, 0x214661 },
	{ 0x6c13, 0x214e40 },
	{ 0x6c14, 0x222141 },
	{ 0x6c15, 0x22215f },
	{ 0x6c16, 0x21483c },
	{ 0x6c18, 0x222258 },
	{ 0x6c19, 0x222449 },
	{ 0x6c1a, 0x22244a },
	{ 0x6c1b, 0x214e41 },
	{ 0x6c1c, 0x23295d },
	{ 0x6c1d, 0x22274e },
	{ 0x6c1e, 0x23653b },
	{ 0x6c1f, 0x215177 },
	{ 0x6c20, 0x222b4d },
	{ 0x6c21, 0x222b4e },
	{ 0x6c23, 0x215634 },
	{ 0x6c24, 0x215638 },
	{ 0x6c25, 0x223027 },
	{ 0x6c26, 0x215637 },
	{ 0x6c27, 0x215635 },
	{ 0x6c28, 0x215636 },
	{ 0x6c2a, 0x223643 },
	{ 0x6c2b, 0x215b47 },
	{ 0x6c2c, 0x21602a },
	{ 0x6c2d, 0x233c4e },
	{ 0x6c2e, 0x216028 },
	{ 0x6c2f, 0x216029 },
	{ 0x6c30, 0x223d2b },
	{ 0x6c31, 0x234229 },
	{ 0x6c32, 0x23422a },
	{ 0x6c33, 0x21693b },
	{ 0x6c34, 0x214555 },
	{ 0x6c36, 0x222160 },
	{ 0x6c37, 0x232257 },
	{ 0x6c38, 0x214663 },
	{ 0x6c39, 0x232254 },
	{ 0x6c3b, 0x222163 },
	{ 0x6c3c, 0x232421 },
	{ 0x6c3e, 0x214666 },
	{ 0x6c3f, 0x222162 },
	{ 0x6c40, 0x214665 },
	{ 0x6c41, 0x214664 },
	{ 0x6c42, 0x214a65 },
	{ 0x6c43, 0x222161 },
	{ 0x6c44, 0x232258 },
	{ 0x6c45, 0x232259 },
	{ 0x6c46, 0x222259 },
	{ 0x6c4a, 0x22225d },
	{ 0x6c4b, 0x22225f },
	{ 0x6c4c, 0x222260 },
	{ 0x6c4d, 0x214846 },
	{ 0x6c4e, 0x214847 },
	{ 0x6c4f, 0x22225c },
	{ 0x6c50, 0x214842 },
	{ 0x6c51, 0x23237d },
	{ 0x6c52, 0x22225a },
	{ 0x6c53, 0x232425 },
	{ 0x6c54, 0x22225e },
	{ 0x6c55, 0x214843 },
	{ 0x6c56, 0x232655 },
	{ 0x6c57, 0x21483e },
	{ 0x6c58, 0x23237c },
	{ 0x6c59, 0x21483f },
	{ 0x6c5a, 0x232423 },
	{ 0x6c5b, 0x214845 },
	{ 0x6c5c, 0x22225b },
	{ 0x6c5d, 0x21483d },
	{ 0x6c5e, 0x214a66 },
	{ 0x6c5f, 0x214840 },
	{ 0x6c60, 0x214841 },
	{ 0x6c61, 0x214844 },
	{ 0x6c63, 0x23653c },
	{ 0x6c65, 0x22245b },
	{ 0x6c66, 0x222459 },
	{ 0x6c67, 0x22244c },
	{ 0x6c68, 0x214a72 },
	{ 0x6c69, 0x222453 },
	{ 0x6c6a, 0x214a6d },
	{ 0x6c6b, 0x22244d },
	{ 0x6c6c, 0x232964 },
	{ 0x6c6d, 0x222455 },
	{ 0x6c6e, 0x232650 },
	{ 0x6c6f, 0x222452 },
	{ 0x6c70, 0x214a70 },
	{ 0x6c71, 0x222451 },
	{ 0x6c72, 0x214a77 },
	{ 0x6c73, 0x22245a },
	{ 0x6c74, 0x214a79 },
	{ 0x6c75, 0x232653 },
	{ 0x6c76, 0x214a7b },
	{ 0x6c77, 0x23237e },
	{ 0x6c78, 0x22244b },
	{ 0x6c79, 0x232657 },
	{ 0x6c7a, 0x214a6e },
	{ 0x6c7b, 0x22245c },
	{ 0x6c7c, 0x232651 },
	{ 0x6c7d, 0x214a75 },
	{ 0x6c7e, 0x214a78 },
	{ 0x6c7f, 0x23264c },
	{ 0x6c80, 0x222765 },
	{ 0x6c81, 0x214a68 },
	{ 0x6c82, 0x214b21 },
	{ 0x6c83, 0x214a76 },
	{ 0x6c84, 0x22244e },
	{ 0x6c85, 0x214a6b },
	{ 0x6c86, 0x214a7a },
	{ 0x6c87, 0x222456 },
	{ 0x6c88, 0x214a69 },
	{ 0x6c89, 0x214a6a },
	{ 0x6c8a, 0x222763 },
	{ 0x6c8b, 0x22244f },
	{ 0x6c8c, 0x214a71 },
	{ 0x6c8d, 0x214a7c },
	{ 0x6c8e, 0x22245d },
	{ 0x6c8f, 0x222450 },
	{ 0x6c90, 0x214a6f },
	{ 0x6c91, 0x23264d },
	{ 0x6c92, 0x214a74 },
	{ 0x6c93, 0x22274f },
	{ 0x6c94, 0x214a7d },
	{ 0x6c95, 0x222457 },
	{ 0x6c96, 0x214a73 },
	{ 0x6c97, 0x232963 },
	{ 0x6c98, 0x214a7e },
	{ 0x6c99, 0x214a67 },
	{ 0x6c9a, 0x222454 },
	{ 0x6c9b, 0x214a6c },
	{ 0x6c9c, 0x222458 },
	{ 0x6c9d, 0x222764 },
	{ 0x6c9e, 0x23264e },
	{ 0x6c9f, 0x232652 },
	{ 0x6ca0, 0x23265c },
	{ 0x6ca1, 0x232659 },
	{ 0x6ca2, 0x232656 },
	{ 0x6caa, 0x23265b },
	{ 0x6cab, 0x214e4d },
	{ 0x6cac, 0x214e5d },
	{ 0x6cad, 0x222756 },
	{ 0x6cae, 0x214e54 },
	{ 0x6caf, 0x232d4e },
	{ 0x6cb0, 0x22276b },
	{ 0x6cb1, 0x214e45 },
	{ 0x6cb2, 0x23296b },
	{ 0x6cb3, 0x214e48 },
	{ 0x6cb4, 0x222762 },
	{ 0x6cb6, 0x222754 },
	{ 0x6cb7, 0x222758 },
	{ 0x6cb8, 0x214e50 },
	{ 0x6cb9, 0x214e52 },
	{ 0x6cba, 0x22275b },
	{ 0x6cbb, 0x214e59 },
	{ 0x6cbc, 0x214e4b },
	{ 0x6cbd, 0x214e49 },
	{ 0x6cbe, 0x214e4a },
	{ 0x6cbf, 0x214e58 },
	{ 0x6cc0, 0x222767 },
	{ 0x6cc1, 0x214e53 },
	{ 0x6cc2, 0x22275a },
	{ 0x6cc3, 0x22275c },
	{ 0x6cc4, 0x214e51 },
	{ 0x6cc5, 0x214e56 },
	{ 0x6cc6, 0x22275d },
	{ 0x6cc7, 0x22276a },
	{ 0x6cc8, 0x23296d },
	{ 0x6cc9, 0x215178 },
	{ 0x6cca, 0x214e5c },
	{ 0x6ccb, 0x236261 },
	{ 0x6ccc, 0x214e46 },
	{ 0x6ccd, 0x222769 },
	{ 0x6cce, 0x23296c },
	{ 0x6ccf, 0x22276d },
	{ 0x6cd0, 0x222759 },
	{ 0x6cd1, 0x22276f },
	{ 0x6cd2, 0x222760 },
	{ 0x6cd3, 0x214e4f },
	{ 0x6cd4, 0x222755 },
	{ 0x6cd5, 0x214e4e },
	{ 0x6cd6, 0x214e60 },
	{ 0x6cd7, 0x214e55 },
	{ 0x6cd8, 0x23296a },
	{ 0x6cd9, 0x222753 },
	{ 0x6cda, 0x222b57 },
	{ 0x6cdb, 0x214e5b },
	{ 0x6cdc, 0x214e5f },
	{ 0x6cdd, 0x222761 },
	{ 0x6cde, 0x222766 },
	{ 0x6cdf, 0x232965 },
	{ 0x6ce0, 0x214e61 },
	{ 0x6ce1, 0x214e5a },
	{ 0x6ce2, 0x214e4c },
	{ 0x6ce3, 0x214e42 },
	{ 0x6ce4, 0x232969 },
	{ 0x6ce5, 0x214e47 },
	{ 0x6ce6, 0x236260 },
	{ 0x6ce7, 0x222757 },
	{ 0x6ce8, 0x214e43 },
	{ 0x6ce9, 0x22276e },
	{ 0x6cea, 0x232967 },
	{ 0x6ceb, 0x222751 },
	{ 0x6cec, 0x222750 },
	{ 0x6ced, 0x22275e },
	{ 0x6cee, 0x222752 },
	{ 0x6cef, 0x214e5e },
	{ 0x6cf0, 0x215639 },
	{ 0x6cf1, 0x214e57 },
	{ 0x6cf2, 0x22275f },
	{ 0x6cf3, 0x214e44 },
	{ 0x6cf4, 0x232d4f },
	{ 0x6cf5, 0x215229 },
	{ 0x6cf9, 0x22276c },
	{ 0x6cff, 0x232d46 },
	{ 0x6d00, 0x222b5e },
	{ 0x6d01, 0x222b61 },
	{ 0x6d02, 0x232d50 },
	{ 0x6d03, 0x222b64 },
	{ 0x6d04, 0x222b59 },
	{ 0x6d05, 0x232d48 },
	{ 0x6d06, 0x232d4a },
	{ 0x6d07, 0x222b67 },
	{ 0x6d08, 0x222b6a },
	{ 0x6d09, 0x222b6c },
	{ 0x6d0a, 0x222b56 },
	{ 0x6d0b, 0x215179 },
	{ 0x6d0c, 0x21517e },
	{ 0x6d0d, 0x22302c },
	{ 0x6d0e, 0x215230 },
	{ 0x6d0f, 0x222b65 },
	{ 0x6d10, 0x222b6d },
	{ 0x6d11, 0x222b5d },
	{ 0x6d12, 0x222b55 },
	{ 0x6d13, 0x232d49 },
	{ 0x6d14, 0x232d47 },
	{ 0x6d15, 0x232d4d },
	{ 0x6d16, 0x223047 },
	{ 0x6d17, 0x215223 },
	{ 0x6d18, 0x222b62 },
	{ 0x6d19, 0x222b5a },
	{ 0x6d1a, 0x222b5c },
	{ 0x6d1b, 0x215228 },
	{ 0x6d1c, 0x23317a },
	{ 0x6d1d, 0x222b5f },
	{ 0x6d1e, 0x215222 },
	{ 0x6d1f, 0x222b52 },
	{ 0x6d20, 0x222b68 },
	{ 0x6d21, 0x232d4b },
	{ 0x6d22, 0x222b6b },
	{ 0x6d23, 0x232d45 },
	{ 0x6d24, 0x232d57 },
	{ 0x6d25, 0x21517d },
	{ 0x6d26, 0x232d53 },
	{ 0x6d27, 0x21522b },
	{ 0x6d28, 0x222b4f },
	{ 0x6d29, 0x21522d },
	{ 0x6d2a, 0x21517b },
	{ 0x6d2b, 0x215231 },
	{ 0x6d2c, 0x222b69 },
	{ 0x6d2d, 0x222b51 },
	{ 0x6d2e, 0x21522e },
	{ 0x6d2f, 0x223041 },
	{ 0x6d30, 0x222768 },
	{ 0x6d31, 0x215221 },
	{ 0x6d32, 0x21517a },
	{ 0x6d33, 0x222b58 },
	{ 0x6d34, 0x222b50 },
	{ 0x6d35, 0x21522f },
	{ 0x6d36, 0x215227 },
	{ 0x6d37, 0x222b63 },
	{ 0x6d38, 0x21522c },
	{ 0x6d39, 0x21522a },
	{ 0x6d3a, 0x222b5b },
	{ 0x6d3b, 0x215224 },
	{ 0x6d3c, 0x222b53 },
	{ 0x6d3d, 0x215225 },
	{ 0x6d3e, 0x215226 },
	{ 0x6d3f, 0x222b54 },
	{ 0x6d40, 0x222b66 },
	{ 0x6d41, 0x21517c },
	{ 0x6d42, 0x222b60 },
	{ 0x6d44, 0x232d55 },
	{ 0x6d45, 0x232d51 },
	{ 0x6d56, 0x233177 },
	{ 0x6d57, 0x233173 },
	{ 0x6d58, 0x22302f },
	{ 0x6d59, 0x215641 },
	{ 0x6d5a, 0x215646 },
	{ 0x6d5b, 0x233179 },
	{ 0x6d5c, 0x233226 },
	{ 0x6d5d, 0x233176 },
	{ 0x6d5e, 0x223038 },
	{ 0x6d5f, 0x22303e },
	{ 0x6d60, 0x22303a },
	{ 0x6d61, 0x22302d },
	{ 0x6d62, 0x223030 },
	{ 0x6d63, 0x223029 },
	{ 0x6d64, 0x22302a },
	{ 0x6d65, 0x21564d },
	{ 0x6d66, 0x21563e },
	{ 0x6d67, 0x223039 },
	{ 0x6d68, 0x223042 },
	{ 0x6d69, 0x215648 },
	{ 0x6d6a, 0x21563a },
	{ 0x6d6b, 0x23316f },
	{ 0x6d6c, 0x215643 },
	{ 0x6d6d, 0x223031 },
	{ 0x6d6e, 0x215645 },
	{ 0x6d6f, 0x223032 },
	{ 0x6d70, 0x22303c },
	{ 0x6d71, 0x233222 },
	{ 0x6d72, 0x233225 },
	{ 0x6d73, 0x233172 },
	{ 0x6d74, 0x215647 },
	{ 0x6d75, 0x22304b },
	{ 0x6d76, 0x22302b },
	{ 0x6d77, 0x215640 },
	{ 0x6d78, 0x21563f },
	{ 0x6d79, 0x21564b },
	{ 0x6d7a, 0x223028 },
	{ 0x6d7b, 0x223049 },
	{ 0x6d7c, 0x22303d },
	{ 0x6d7d, 0x22304a },
	{ 0x6d7e, 0x223044 },
	{ 0x6d7f, 0x223036 },
	{ 0x6d80, 0x223045 },
	{ 0x6d81, 0x233221 },
	{ 0x6d82, 0x22303f },
	{ 0x6d83, 0x223048 },
	{ 0x6d84, 0x223046 },
	{ 0x6d85, 0x21564c },
	{ 0x6d86, 0x223037 },
	{ 0x6d87, 0x21563d },
	{ 0x6d88, 0x21563c },
	{ 0x6d89, 0x215644 },
	{ 0x6d8a, 0x21564a },
	{ 0x6d8b, 0x223043 },
	{ 0x6d8c, 0x215649 },
	{ 0x6d8d, 0x223034 },
	{ 0x6d8e, 0x215b48 },
	{ 0x6d8f, 0x233178 },
	{ 0x6d90, 0x22304c },
	{ 0x6d91, 0x223033 },
	{ 0x6d92, 0x22302e },
	{ 0x6d93, 0x215642 },
	{ 0x6d94, 0x21564e },
	{ 0x6d95, 0x21563b },
	{ 0x6d96, 0x233227 },
	{ 0x6d97, 0x22303b },
	{ 0x6d98, 0x223040 },
	{ 0x6d99, 0x23317d },
	{ 0x6d9a, 0x23317b },
	{ 0x6d9b, 0x23317c },
	{ 0x6da5, 0x23653d },
	{ 0x6daa, 0x215b6a },
	{ 0x6dab, 0x223645 },
	{ 0x6dac, 0x223649 },
	{ 0x6dad, 0x23366f },
	{ 0x6dae, 0x215b57 },
	{ 0x6daf, 0x215b55 },
	{ 0x6db0, 0x23367a },
	{ 0x6db1, 0x233721 },
	{ 0x6db2, 0x215b4c },
	{ 0x6db3, 0x223647 },
	{ 0x6db4, 0x223646 },
	{ 0x6db5, 0x215b60 },
	{ 0x6db6, 0x233c50 },
	{ 0x6db7, 0x22364c },
	{ 0x6db8, 0x215b5a },
	{ 0x6db9, 0x233672 },
	{ 0x6dba, 0x22365e },
	{ 0x6dbb, 0x22366a },
	{ 0x6dbc, 0x215b49 },
	{ 0x6dbd, 0x22365b },
	{ 0x6dbe, 0x223654 },
	{ 0x6dbf, 0x215b6c },
	{ 0x6dc0, 0x223644 },
	{ 0x6dc1, 0x23366a },
	{ 0x6dc2, 0x223660 },
	{ 0x6dc3, 0x23366b },
	{ 0x6dc4, 0x215b69 },
	{ 0x6dc5, 0x215b5d },
	{ 0x6dc6, 0x215b68 },
	{ 0x6dc7, 0x215b53 },
	{ 0x6dc8, 0x223650 },
	{ 0x6dc9, 0x223662 },
	{ 0x6dca, 0x22365a },
	{ 0x6dcb, 0x215b54 },
	{ 0x6dcc, 0x215b4e },
	{ 0x6dcd, 0x223668 },
	{ 0x6dce, 0x23366c },
	{ 0x6dcf, 0x223661 },
	{ 0x6dd0, 0x223663 },
	{ 0x6dd1, 0x215b56 },
	{ 0x6dd2, 0x215b5e },
	{ 0x6dd3, 0x223665 },
	{ 0x6dd4, 0x22364e },
	{ 0x6dd5, 0x22365f },
	{ 0x6dd6, 0x223653 },
	{ 0x6dd7, 0x223667 },
	{ 0x6dd8, 0x215b63 },
	{ 0x6dd9, 0x215b4b },
	{ 0x6dda, 0x215b61 },
	{ 0x6ddb, 0x223658 },
	{ 0x6ddc, 0x223656 },
	{ 0x6ddd, 0x223657 },
	{ 0x6dde, 0x215b58 },
	{ 0x6ddf, 0x223652 },
	{ 0x6de0, 0x223651 },
	{ 0x6de1, 0x215b4d },
	{ 0x6de2, 0x22364b },
	{ 0x6de3, 0x223669 },
	{ 0x6de4, 0x215b4f },
	{ 0x6de5, 0x223655 },
	{ 0x6de6, 0x215b6d },
	{ 0x6de7, 0x233674 },
	{ 0x6de8, 0x215b67 },
	{ 0x6de9, 0x22364a },
	{ 0x6dea, 0x215b64 },
	{ 0x6deb, 0x215b62 },
	{ 0x6dec, 0x215b6b },
	{ 0x6ded, 0x22365c },
	{ 0x6dee, 0x215b66 },
	{ 0x6def, 0x223035 },
	{ 0x6df0, 0x22365d },
	{ 0x6df1, 0x215b65 },
	{ 0x6df2, 0x223664 },
	{ 0x6df3, 0x215b4a },
	{ 0x6df4, 0x223659 },
	{ 0x6df5, 0x215b5c },
	{ 0x6df6, 0x22364d },
	{ 0x6df7, 0x215b5b },
	{ 0x6df8, 0x23367c },
	{ 0x6df9, 0x215b59 },
	{ 0x6dfa, 0x215b51 },
	{ 0x6dfb, 0x215b50 },
	{ 0x6dfc, 0x223d2c },
	{ 0x6dfd, 0x223666 },
	{ 0x6dfe, 0x233c5d },
	{ 0x6dff, 0x233728 },
	{ 0x6e00, 0x22364f },
	{ 0x6e01, 0x233726 },
	{ 0x6e02, 0x233723 },
	{ 0x6e03, 0x223d41 },
	{ 0x6e04, 0x233670 },
	{ 0x6e05, 0x215b52 },
	{ 0x6e06, 0x233677 },
	{ 0x6e07, 0x233724 },
	{ 0x6e08, 0x233676 },
	{ 0x6e09, 0x233725 },
	{ 0x6e0a, 0x233679 },
	{ 0x6e0c, 0x23367d },
	{ 0x6e0f, 0x23653e },
	{ 0x6e12, 0x233729 },
	{ 0x6e17, 0x233727 },
	{ 0x6e18, 0x233c54 },
	{ 0x6e19, 0x216047 },
	{ 0x6e1a, 0x215b5f },
	{ 0x6e1b, 0x216035 },
	{ 0x6e1c, 0x223d3b },
	{ 0x6e1d, 0x216043 },
	{ 0x6e1e, 0x233c52 },
	{ 0x6e1f, 0x223d2f },
	{ 0x6e20, 0x216032 },
	{ 0x6e21, 0x21602e },
	{ 0x6e22, 0x223d4d },
	{ 0x6e23, 0x216034 },
	{ 0x6e24, 0x216038 },
	{ 0x6e25, 0x216033 },
	{ 0x6e26, 0x21603c },
	{ 0x6e27, 0x223d51 },
	{ 0x6e28, 0x223d48 },
	{ 0x6e29, 0x233c6b },
	{ 0x6e2a, 0x233c6d },
	{ 0x6e2b, 0x223d36 },
	{ 0x6e2c, 0x216041 },
	{ 0x6e2d, 0x21603b },
	{ 0x6e2e, 0x223d42 },
	{ 0x6e2f, 0x21602b },
	{ 0x6e30, 0x223d4e },
	{ 0x6e31, 0x223d47 },
	{ 0x6e32, 0x21602f },
	{ 0x6e33, 0x223d3c },
	{ 0x6e34, 0x21603e },
	{ 0x6e35, 0x223d59 },
	{ 0x6e36, 0x223d5a },
	{ 0x6e38, 0x21602c },
	{ 0x6e39, 0x223d4c },
	{ 0x6e3a, 0x216040 },
	{ 0x6e3b, 0x223d40 },
	{ 0x6e3c, 0x223d32 },
	{ 0x6e3d, 0x223d33 },
	{ 0x6e3e, 0x216044 },
	{ 0x6e3f, 0x223d37 },
	{ 0x6e40, 0x223d3e },
	{ 0x6e41, 0x223d38 },
	{ 0x6e42, 0x233c5a },
	{ 0x6e43, 0x216042 },
	{ 0x6e44, 0x21604a },
	{ 0x6e45, 0x223d34 },
	{ 0x6e46, 0x223d2d },
	{ 0x6e47, 0x223d2e },
	{ 0x6e48, 0x233c56 },
	{ 0x6e49, 0x223d30 },
	{ 0x6e4a, 0x216031 },
	{ 0x6e4b, 0x223d3d },
	{ 0x6e4c, 0x233c6e },
	{ 0x6e4d, 0x21603f },
	{ 0x6e4e, 0x216048 },
	{ 0x6e4f, 0x233c58 },
	{ 0x6e50, 0x233c69 },
	{ 0x6e51, 0x223d3f },
	{ 0x6e52, 0x223d57 },
	{ 0x6e53, 0x223d4f },
	{ 0x6e54, 0x21602d },
	{ 0x6e55, 0x223d55 },
	{ 0x6e56, 0x216039 },
	{ 0x6e57, 0x233c66 },
	{ 0x6e58, 0x216037 },
	{ 0x6e59, 0x233c64 },
	{ 0x6e5a, 0x223d5b },
	{ 0x6e5b, 0x216036 },
	{ 0x6e5c, 0x223d45 },
	{ 0x6e5d, 0x223d39 },
	{ 0x6e5e, 0x223d43 },
	{ 0x6e5f, 0x21604d },
	{ 0x6e60, 0x223d49 },
	{ 0x6e61, 0x223d46 },
	{ 0x6e62, 0x223d35 },
	{ 0x6e63, 0x216049 },
	{ 0x6e64, 0x223d53 },
	{ 0x6e65, 0x223d50 },
	{ 0x6e66, 0x223d58 },
	{ 0x6e67, 0x216030 },
	{ 0x6e68, 0x223d44 },
	{ 0x6e69, 0x21604c },
	{ 0x6e6a, 0x233c5b },
	{ 0x6e6b, 0x223d4b },
	{ 0x6e6c, 0x23423a },
	{ 0x6e6d, 0x233c60 },
	{ 0x6e6e, 0x21603a },
	{ 0x6e6f, 0x21603d },
	{ 0x6e70, 0x233c5c },
	{ 0x6e71, 0x223d4a },
	{ 0x6e72, 0x21604b },
	{ 0x6e73, 0x223d3a },
	{ 0x6e74, 0x223648 },
	{ 0x6e75, 0x233c51 },
	{ 0x6e76, 0x233c6c },
	{ 0x6e77, 0x223d54 },
	{ 0x6e78, 0x223d52 },
	{ 0x6e79, 0x223d56 },
	{ 0x6e7b, 0x233c62 },
	{ 0x6e7c, 0x236542 },
	{ 0x6e7e, 0x233c63 },
	{ 0x6e80, 0x233c68 },
	{ 0x6e84, 0x236540 },
	{ 0x6e86, 0x23633d },
	{ 0x6e88, 0x223d31 },
	{ 0x6e89, 0x216046 },
	{ 0x6e8a, 0x23653f },
	{ 0x6e8b, 0x236541 },
	{ 0x6e8d, 0x224447 },
	{ 0x6e8e, 0x224446 },
	{ 0x6e8f, 0x22442c },
	{ 0x6e90, 0x216463 },
	{ 0x6e91, 0x234230 },
	{ 0x6e92, 0x224445 },
	{ 0x6e93, 0x22442f },
	{ 0x6e94, 0x224430 },
	{ 0x6e96, 0x21646d },
	{ 0x6e97, 0x22444e },
	{ 0x6e98, 0x216468 },
	{ 0x6e99, 0x224444 },
	{ 0x6e9a, 0x234233 },
	{ 0x6e9b, 0x224429 },
	{ 0x6e9c, 0x21646e },
	{ 0x6e9d, 0x216464 },
	{ 0x6e9e, 0x224438 },
	{ 0x6e9f, 0x22442e },
	{ 0x6ea0, 0x224431 },
	{ 0x6ea1, 0x224449 },
	{ 0x6ea2, 0x21645e },
	{ 0x6ea3, 0x224450 },
	{ 0x6ea4, 0x224448 },
	{ 0x6ea5, 0x216467 },
	{ 0x6ea6, 0x22443d },
	{ 0x6ea7, 0x216472 },
	{ 0x6ea8, 0x23422e },
	{ 0x6ea9, 0x234236 },
	{ 0x6eaa, 0x216471 },
	{ 0x6eab, 0x21646b },
	{ 0x6eac, 0x234240 },
	{ 0x6eae, 0x22444f },
	{ 0x6eaf, 0x21645f },
	{ 0x6eb0, 0x22443b },
	{ 0x6eb1, 0x224432 },
	{ 0x6eb2, 0x22443f },
	{ 0x6eb3, 0x22444b },
	{ 0x6eb4, 0x216473 },
	{ 0x6eb5, 0x234239 },
	{ 0x6eb6, 0x216461 },
	{ 0x6eb7, 0x22443a },
	{ 0x6eb8, 0x23422d },
	{ 0x6eb9, 0x224433 },
	{ 0x6eba, 0x21646a },
	{ 0x6ebb, 0x234231 },
	{ 0x6ebc, 0x216469 },
	{ 0x6ebd, 0x224436 },
	{ 0x6ebe, 0x224440 },
	{ 0x6ebf, 0x22444a },
	{ 0x6ec0, 0x22442d },
	{ 0x6ec1, 0x224437 },
	{ 0x6ec2, 0x216462 },
	{ 0x6ec3, 0x224441 },
	{ 0x6ec4, 0x21646f },
	{ 0x6ec5, 0x216466 },
	{ 0x6ec6, 0x224434 },
	{ 0x6ec7, 0x216465 },
	{ 0x6ec8, 0x22442b },
	{ 0x6ec9, 0x224439 },
	{ 0x6eca, 0x22444d },
	{ 0x6ecb, 0x216045 },
	{ 0x6ecc, 0x216957 },
	{ 0x6ecd, 0x22443c },
	{ 0x6ece, 0x224b34 },
	{ 0x6ecf, 0x22443e },
	{ 0x6ed0, 0x22444c },
	{ 0x6ed1, 0x21646c },
	{ 0x6ed2, 0x224435 },
	{ 0x6ed3, 0x216460 },
	{ 0x6ed4, 0x216470 },
	{ 0x6ed5, 0x216d5a },
	{ 0x6ed6, 0x22442a },
	{ 0x6ed8, 0x224443 },
	{ 0x6ed9, 0x234244 },
	{ 0x6eda, 0x23423e },
	{ 0x6edb, 0x234247 },
	{ 0x6edc, 0x224442 },
	{ 0x6edd, 0x23423d },
	{ 0x6ee3, 0x234245 },
	{ 0x6ee6, 0x23423f },
	{ 0x6ee8, 0x23423b },
	{ 0x6ee9, 0x234246 },
	{ 0x6eeb, 0x224b50 },
	{ 0x6eec, 0x216954 },
	{ 0x6eed, 0x224b45 },
	{ 0x6eee, 0x224b4a },
	{ 0x6eef, 0x216949 },
	{ 0x6ef0, 0x234756 },
	{ 0x6ef1, 0x224b36 },
	{ 0x6ef2, 0x216956 },
	{ 0x6ef3, 0x234757 },
	{ 0x6ef4, 0x216940 },
	{ 0x6ef5, 0x224b35 },
	{ 0x6ef6, 0x224b56 },
	{ 0x6ef7, 0x216958 },
	{ 0x6ef8, 0x224b39 },
	{ 0x6ef9, 0x224b49 },
	{ 0x6efa, 0x234765 },
	{ 0x6efb, 0x224b3b },
	{ 0x6efc, 0x224b59 },
	{ 0x6efd, 0x224b55 },
	{ 0x6efe, 0x21693e },
	{ 0x6eff, 0x216948 },
	{ 0x6f00, 0x22515b },
	{ 0x6f01, 0x216955 },
	{ 0x6f02, 0x216946 },
	{ 0x6f03, 0x224b37 },
	{ 0x6f04, 0x234763 },
	{ 0x6f05, 0x224b54 },
	{ 0x6f06, 0x21694a },
	{ 0x6f07, 0x224b51 },
	{ 0x6f08, 0x224b5e },
	{ 0x6f09, 0x224b3d },
	{ 0x6f0a, 0x224b46 },
	{ 0x6f0b, 0x234c78 },
	{ 0x6f0c, 0x23475b },
	{ 0x6f0d, 0x224b5c },
	{ 0x6f0e, 0x224b52 },
	{ 0x6f0f, 0x216945 },
	{ 0x6f10, 0x234c6a },
	{ 0x6f11, 0x234764 },
	{ 0x6f12, 0x224b44 },
	{ 0x6f13, 0x21693f },
	{ 0x6f14, 0x21693d },
	{ 0x6f15, 0x21694f },
	{ 0x6f17, 0x23475f },
	{ 0x6f18, 0x224b42 },
	{ 0x6f19, 0x224b3f },
	{ 0x6f1a, 0x224b40 },
	{ 0x6f1b, 0x23475a },
	{ 0x6f1c, 0x224b58 },
	{ 0x6f1d, 0x23475c },
	{ 0x6f1e, 0x224b5d },
	{ 0x6f1f, 0x224b5b },
	{ 0x6f20, 0x216943 },
	{ 0x6f21, 0x224b5f },
	{ 0x6f22, 0x216947 },
	{ 0x6f23, 0x21694e },
	{ 0x6f25, 0x224b38 },
	{ 0x6f26, 0x225143 },
	{ 0x6f27, 0x224b41 },
	{ 0x6f28, 0x23475e },
	{ 0x6f29, 0x216941 },
	{ 0x6f2a, 0x216953 },
	{ 0x6f2b, 0x216950 },
	{ 0x6f2c, 0x216944 },
	{ 0x6f2d, 0x224b4b },
	{ 0x6f2e, 0x224b3c },
	{ 0x6f2f, 0x216951 },
	{ 0x6f30, 0x224b4d },
	{ 0x6f31, 0x21694b },
	{ 0x6f32, 0x21694d },
	{ 0x6f33, 0x21693c },
	{ 0x6f34, 0x23475d },
	{ 0x6f35, 0x224b4f },
	{ 0x6f36, 0x224b47 },
	{ 0x6f37, 0x224b3a },
	{ 0x6f38, 0x21694c },
	{ 0x6f39, 0x224b57 },
	{ 0x6f3a, 0x224b5a },
	{ 0x6f3b, 0x224b43 },
	{ 0x6f3c, 0x224b4e },
	{ 0x6f3d, 0x234c74 },
	{ 0x6f3e, 0x216942 },
	{ 0x6f3f, 0x216d49 },
	{ 0x6f40, 0x224b4c },
	{ 0x6f41, 0x225142 },
	{ 0x6f42, 0x234762 },
	{ 0x6f43, 0x224b53 },
	{ 0x6f44, 0x234761 },
	{ 0x6f48, 0x236544 },
	{ 0x6f49, 0x236545 },
	{ 0x6f4a, 0x234766 },
	{ 0x6f4c, 0x236543 },
	{ 0x6f4e, 0x224b3e },
	{ 0x6f4f, 0x22514c },
	{ 0x6f50, 0x225156 },
	{ 0x6f51, 0x216d4c },
	{ 0x6f52, 0x225155 },
	{ 0x6f53, 0x225161 },
	{ 0x6f54, 0x216d4e },
	{ 0x6f55, 0x225153 },
	{ 0x6f57, 0x225157 },
	{ 0x6f58, 0x216d59 },
	{ 0x6f59, 0x234c7d },
	{ 0x6f5a, 0x22514e },
	{ 0x6f5b, 0x216d51 },
	{ 0x6f5c, 0x234c73 },
	{ 0x6f5d, 0x22515a },
	{ 0x6f5e, 0x22577b },
	{ 0x6f5f, 0x216d5d },
	{ 0x6f60, 0x216d5c },
	{ 0x6f61, 0x22515c },
	{ 0x6f62, 0x22514b },
	{ 0x6f63, 0x225166 },
	{ 0x6f64, 0x216d57 },
	{ 0x6f65, 0x234c6b },
	{ 0x6f66, 0x216d4d },
	{ 0x6f67, 0x22515f },
	{ 0x6f69, 0x225163 },
	{ 0x6f6a, 0x225168 },
	{ 0x6f6b, 0x22515d },
	{ 0x6f6c, 0x225151 },
	{ 0x6f6d, 0x216d50 },
	{ 0x6f6e, 0x216d53 },
	{ 0x6f6f, 0x216d5b },
	{ 0x6f70, 0x216d56 },
	{ 0x6f71, 0x234c75 },
	{ 0x6f72, 0x225154 },
	{ 0x6f73, 0x224b48 },
	{ 0x6f74, 0x234c7e },
	{ 0x6f75, 0x234c6c },
	{ 0x6f76, 0x225150 },
	{ 0x6f77, 0x225167 },
	{ 0x6f78, 0x216d52 },
	{ 0x6f79, 0x234c79 },
	{ 0x6f7a, 0x216d55 },
	{ 0x6f7b, 0x225169 },
	{ 0x6f7c, 0x216d4a },
	{ 0x6f7d, 0x22515e },
	{ 0x6f7e, 0x225144 },
	{ 0x6f7f, 0x225164 },
	{ 0x6f80, 0x21742a },
	{ 0x6f81, 0x234c7a },
	{ 0x6f82, 0x225152 },
	{ 0x6f84, 0x216d4b },
	{ 0x6f85, 0x22514d },
	{ 0x6f86, 0x216d4f },
	{ 0x6f87, 0x225145 },
	{ 0x6f88, 0x216952 },
	{ 0x6f89, 0x225149 },
	{ 0x6f8a, 0x236363 },
	{ 0x6f8b, 0x225162 },
	{ 0x6f8c, 0x22514a },
	{ 0x6f8d, 0x225148 },
	{ 0x6f8e, 0x216d54 },
	{ 0x6f8f, 0x234c7b },
	{ 0x6f90, 0x225160 },
	{ 0x6f91, 0x234c77 },
	{ 0x6f92, 0x225147 },
	{ 0x6f93, 0x225159 },
	{ 0x6f94, 0x225158 },
	{ 0x6f95, 0x225165 },
	{ 0x6f96, 0x22514f },
	{ 0x6f97, 0x216d58 },
	{ 0x6f99, 0x236547 },
	{ 0x6f9d, 0x236546 },
	{ 0x6f9e, 0x22577e },
	{ 0x6f9f, 0x235156 },
	{ 0x6fa0, 0x217133 },
	{ 0x6fa1, 0x217129 },
	{ 0x6fa2, 0x22582c },
	{ 0x6fa3, 0x225776 },
	{ 0x6fa4, 0x21712b },
	{ 0x6fa5, 0x225824 },
	{ 0x6fa6, 0x217132 },
	{ 0x6fa7, 0x21712d },
	{ 0x6fa8, 0x225822 },
	{ 0x6fa9, 0x225d3b },
	{ 0x6faa, 0x225828 },
	{ 0x6fab, 0x22582e },
	{ 0x6fac, 0x225827 },
	{ 0x6fad, 0x225774 },
	{ 0x6fae, 0x225825 },
	{ 0x6faf, 0x225830 },
	{ 0x6fb0, 0x225832 },
	{ 0x6fb1, 0x217128 },
	{ 0x6fb2, 0x225831 },
	{ 0x6fb3, 0x21712e },
	{ 0x6fb4, 0x217134 },
	{ 0x6fb5, 0x235154 },
	{ 0x6fb6, 0x217131 },
	{ 0x6fb7, 0x235158 },
	{ 0x6fb8, 0x22582b },
	{ 0x6fb9, 0x217130 },
	{ 0x6fba, 0x225826 },
	{ 0x6fbb, 0x23514d },
	{ 0x6fbc, 0x225778 },
	{ 0x6fbd, 0x22577d },
	{ 0x6fbe, 0x235150 },
	{ 0x6fbf, 0x22582a },
	{ 0x6fc0, 0x21712f },
	{ 0x6fc1, 0x21712c },
	{ 0x6fc2, 0x217127 },
	{ 0x6fc3, 0x21712a },
	{ 0x6fc4, 0x22577c },
	{ 0x6fc6, 0x225146 },
	{ 0x6fc7, 0x225777 },
	{ 0x6fc8, 0x22577a },
	{ 0x6fc9, 0x22582d },
	{ 0x6fca, 0x225821 },
	{ 0x6fcb, 0x225775 },
	{ 0x6fcc, 0x225d3a },
	{ 0x6fcd, 0x22582f },
	{ 0x6fce, 0x225779 },
	{ 0x6fcf, 0x225829 },
	{ 0x6fd0, 0x234c71 },
	{ 0x6fd3, 0x235155 },
	{ 0x6fd4, 0x225d3d },
	{ 0x6fd5, 0x21742e },
	{ 0x6fd6, 0x235530 },
	{ 0x6fd7, 0x23552f },
	{ 0x6fd8, 0x217422 },
	{ 0x6fd9, 0x235535 },
	{ 0x6fda, 0x235536 },
	{ 0x6fdb, 0x217426 },
	{ 0x6fdc, 0x225d3f },
	{ 0x6fdd, 0x225d45 },
	{ 0x6fde, 0x225d43 },
	{ 0x6fdf, 0x217424 },
	{ 0x6fe0, 0x217425 },
	{ 0x6fe1, 0x21742c },
	{ 0x6fe2, 0x225d46 },
	{ 0x6fe3, 0x225d3e },
	{ 0x6fe4, 0x217427 },
	{ 0x6fe5, 0x235531 },
	{ 0x6fe6, 0x225d42 },
	{ 0x6fe7, 0x225d41 },
	{ 0x6fe8, 0x225d47 },
	{ 0x6fe9, 0x21742d },
	{ 0x6fea, 0x235537 },
	{ 0x6feb, 0x217428 },
	{ 0x6fec, 0x21742b },
	{ 0x6fed, 0x225d40 },
	{ 0x6fee, 0x21742f },
	{ 0x6fef, 0x217429 },
	{ 0x6ff0, 0x217430 },
	{ 0x6ff1, 0x217423 },
	{ 0x6ff2, 0x225d44 },
	{ 0x6ff3, 0x235a55 },
	{ 0x6ff4, 0x225d3c },
	{ 0x6ff5, 0x235159 },
	{ 0x6ff6, 0x235539 },
	{ 0x6ff7, 0x226225 },
	{ 0x6ff8, 0x236548 },
	{ 0x6ffa, 0x21765d },
	{ 0x6ffb, 0x226222 },
	{ 0x6ffc, 0x226224 },
	{ 0x6ffd, 0x235828 },
	{ 0x6ffe, 0x21765b },
	{ 0x6fff, 0x22617e },
	{ 0x7000, 0x226221 },
	{ 0x7001, 0x22617a },
	{ 0x7002, 0x23582a },
	{ 0x7003, 0x235827 },
	{ 0x7004, 0x225823 },
	{ 0x7005, 0x22617b },
	{ 0x7006, 0x21765c },
	{ 0x7007, 0x226177 },
	{ 0x7008, 0x235826 },
	{ 0x7009, 0x217659 },
	{ 0x700a, 0x226226 },
	{ 0x700b, 0x21765a },
	{ 0x700c, 0x226178 },
	{ 0x700d, 0x226179 },
	{ 0x700e, 0x22617d },
	{ 0x700f, 0x21765f },
	{ 0x7010, 0x235829 },
	{ 0x7011, 0x21765e },
	{ 0x7013, 0x23582b },
	{ 0x7014, 0x22617c },
	{ 0x7015, 0x217845 },
	{ 0x7016, 0x22656a },
	{ 0x7017, 0x226570 },
	{ 0x7018, 0x217846 },
	{ 0x7019, 0x226567 },
	{ 0x701a, 0x217843 },
	{ 0x701b, 0x217840 },
	{ 0x701c, 0x226572 },
	{ 0x701d, 0x217844 },
	{ 0x701e, 0x235a52 },
	{ 0x701f, 0x217841 },
	{ 0x7020, 0x226569 },
	{ 0x7021, 0x22656c },
	{ 0x7022, 0x22656d },
	{ 0x7023, 0x22656e },
	{ 0x7024, 0x226571 },
	{ 0x7025, 0x235a54 },
	{ 0x7026, 0x226223 },
	{ 0x7027, 0x226568 },
	{ 0x7028, 0x217842 },
	{ 0x7029, 0x22656f },
	{ 0x702a, 0x226934 },
	{ 0x702b, 0x22656b },
	{ 0x702c, 0x235a53 },
	{ 0x702d, 0x23654a },
	{ 0x702e, 0x236549 },
	{ 0x702f, 0x22692b },
	{ 0x7030, 0x217975 },
	{ 0x7031, 0x22692e },
	{ 0x7032, 0x217976 },
	{ 0x7033, 0x226937 },
	{ 0x7034, 0x22692d },
	{ 0x7035, 0x22692a },
	{ 0x7036, 0x235c51 },
	{ 0x7037, 0x22692c },
	{ 0x7038, 0x226930 },
	{ 0x7039, 0x226933 },
	{ 0x703a, 0x226932 },
	{ 0x703b, 0x226936 },
	{ 0x703c, 0x226929 },
	{ 0x703d, 0x235c4f },
	{ 0x703e, 0x217974 },
	{ 0x703f, 0x226931 },
	{ 0x7040, 0x226935 },
	{ 0x7041, 0x226938 },
	{ 0x7042, 0x22692f },
	{ 0x7043, 0x226b61 },
	{ 0x7044, 0x226b62 },
	{ 0x7045, 0x226b66 },
	{ 0x7046, 0x226b67 },
	{ 0x7047, 0x235e3c },
	{ 0x7048, 0x226b64 },
	{ 0x7049, 0x226b65 },
	{ 0x704a, 0x226b63 },
	{ 0x704b, 0x235e3a },
	{ 0x704c, 0x217a74 },
	{ 0x704d, 0x235e3b },
	{ 0x7051, 0x217b64 },
	{ 0x7052, 0x226d59 },
	{ 0x7053, 0x236036 },
	{ 0x7054, 0x235f52 },
	{ 0x7055, 0x226d56 },
	{ 0x7056, 0x226d57 },
	{ 0x7057, 0x226d58 },
	{ 0x7058, 0x217b65 },
	{ 0x7059, 0x236037 },
	{ 0x705a, 0x226f34 },
	{ 0x705b, 0x226f33 },
	{ 0x705c, 0x23654b },
	{ 0x705d, 0x22703d },
	{ 0x705e, 0x217c60 },
	{ 0x705f, 0x22703b },
	{ 0x7060, 0x22703e },
	{ 0x7061, 0x22703c },
	{ 0x7062, 0x227125 },
	{ 0x7063, 0x217d24 },
	{ 0x7064, 0x217d32 },
	{ 0x7065, 0x227171 },
	{ 0x7066, 0x22715b },
	{ 0x7067, 0x236179 },
	{ 0x7068, 0x227170 },
	{ 0x7069, 0x22723e },
	{ 0x706a, 0x22723f },
	{ 0x706b, 0x214556 },
	{ 0x706e, 0x232428 },
	{ 0x706f, 0x232426 },
	{ 0x7070, 0x214848 },
	{ 0x7071, 0x222261 },
	{ 0x7072, 0x232427 },
	{ 0x7073, 0x23242b },
	{ 0x7074, 0x22245e },
	{ 0x7075, 0x232662 },
	{ 0x7076, 0x214b22 },
	{ 0x7077, 0x23265f },
	{ 0x7078, 0x214b25 },
	{ 0x7079, 0x23265e },
	{ 0x707a, 0x22245f },
	{ 0x707b, 0x232663 },
	{ 0x707c, 0x214b23 },
	{ 0x707d, 0x214b24 },
	{ 0x707e, 0x232660 },
	{ 0x7081, 0x232977 },
	{ 0x7082, 0x222778 },
	{ 0x7083, 0x22277a },
	{ 0x7084, 0x222775 },
	{ 0x7085, 0x222772 },
	{ 0x7086, 0x222774 },
	{ 0x7087, 0x232974 },
	{ 0x7088, 0x232970 },
	{ 0x7089, 0x232975 },
	{ 0x708a, 0x214e65 },
	{ 0x708b, 0x23296f },
	{ 0x708c, 0x232979 },
	{ 0x708d, 0x232976 },
	{ 0x708e, 0x214e63 },
	{ 0x708f, 0x232972 },
	{ 0x7090, 0x232971 },
	{ 0x7091, 0x222776 },
	{ 0x7092, 0x214e64 },
	{ 0x7093, 0x222773 },
	{ 0x7094, 0x222770 },
	{ 0x7095, 0x214e62 },
	{ 0x7096, 0x222777 },
	{ 0x7098, 0x222771 },
	{ 0x7099, 0x214e66 },
	{ 0x709a, 0x222779 },
	{ 0x709f, 0x222b6f },
	{ 0x70a0, 0x232d5e },
	{ 0x70a1, 0x222b73 },
	{ 0x70a2, 0x232d5c },
	{ 0x70a3, 0x232d5a },
	{ 0x70a4, 0x21523a },
	{ 0x70a5, 0x232d58 },
	{ 0x70a6, 0x23626a },
	{ 0x70a7, 0x232d65 },
	{ 0x70a8, 0x232d62 },
	{ 0x70a9, 0x222b76 },
	{ 0x70aa, 0x232d5f },
	{ 0x70ab, 0x215232 },
	{ 0x70ac, 0x215235 },
	{ 0x70ad, 0x215237 },
	{ 0x70ae, 0x215239 },
	{ 0x70af, 0x215236 },
	{ 0x70b0, 0x222b72 },
	{ 0x70b1, 0x222b71 },
	{ 0x70b2, 0x232d64 },
	{ 0x70b3, 0x215234 },
	{ 0x70b4, 0x222b74 },
	{ 0x70b5, 0x222b75 },
	{ 0x70b6, 0x232d63 },
	{ 0x70b7, 0x222b6e },
	{ 0x70b8, 0x215238 },
	{ 0x70b9, 0x232d68 },
	{ 0x70ba, 0x215233 },
	{ 0x70bb, 0x232d5d },
	{ 0x70be, 0x222b70 },
	{ 0x70bf, 0x23654d },
	{ 0x70c4, 0x233228 },
	{ 0x70c5, 0x22305a },
	{ 0x70c6, 0x22305b },
	{ 0x70c7, 0x22305c },
	{ 0x70c8, 0x215653 },
	{ 0x70c9, 0x236279 },
	{ 0x70ca, 0x21564f },
	{ 0x70cb, 0x223051 },
	{ 0x70cc, 0x23322a },
	{ 0x70cd, 0x223059 },
	{ 0x70ce, 0x22305e },
	{ 0x70cf, 0x215654 },
	{ 0x70d0, 0x23322b },
	{ 0x70d1, 0x22304f },
	{ 0x70d2, 0x223055 },
	{ 0x70d3, 0x22304e },
	{ 0x70d4, 0x223058 },
	{ 0x70d5, 0x233231 },
	{ 0x70d6, 0x23322f },
	{ 0x70d7, 0x223054 },
	{ 0x70d8, 0x215650 },
	{ 0x70d9, 0x215652 },
	{ 0x70da, 0x22305d },
	{ 0x70db, 0x233229 },
	{ 0x70dc, 0x22304d },
	{ 0x70dd, 0x223050 },
	{ 0x70de, 0x223056 },
	{ 0x70df, 0x23322d },
	{ 0x70e0, 0x223057 },
	{ 0x70e1, 0x22305f },
	{ 0x70e2, 0x223053 },
	{ 0x70e3, 0x23322c },
	{ 0x70e4, 0x215651 },
	{ 0x70e5, 0x23654f },
	{ 0x70ea, 0x23654e },
	{ 0x70ee, 0x233230 },
	{ 0x70ef, 0x215b72 },
	{ 0x70f0, 0x223671 },
	{ 0x70f1, 0x233730 },
	{ 0x70f2, 0x233732 },
	{ 0x70f3, 0x223673 },
	{ 0x70f4, 0x22366f },
	{ 0x70f5, 0x23372f },
	{ 0x70f6, 0x22367b },
	{ 0x70f7, 0x22366d },
	{ 0x70f8, 0x22367a },
	{ 0x70f9, 0x215b6e },
	{ 0x70fa, 0x22366b },
	{ 0x70fb, 0x223d5f },
	{ 0x70fc, 0x223675 },
	{ 0x70fd, 0x215b71 },
	{ 0x70fe, 0x233735 },
	{ 0x70ff, 0x223676 },
	{ 0x7100, 0x223679 },
	{ 0x7101, 0x23372e },
	{ 0x7102, 0x22367d },
	{ 0x7103, 0x23372c },
	{ 0x7104, 0x223672 },
	{ 0x7106, 0x223677 },
	{ 0x7107, 0x23372d },
	{ 0x7108, 0x233731 },
	{ 0x7109, 0x215b6f },
	{ 0x710a, 0x215b70 },
	{ 0x710b, 0x22367c },
	{ 0x710c, 0x223670 },
	{ 0x710d, 0x22366c },
	{ 0x710e, 0x22367e },
	{ 0x710f, 0x233733 },
	{ 0x7110, 0x223674 },
	{ 0x7111, 0x236550 },
	{ 0x7112, 0x236551 },
	{ 0x7113, 0x223678 },
	{ 0x7117, 0x22366e },
	{ 0x7119, 0x21604e },
	{ 0x711a, 0x21604f },
	{ 0x711b, 0x223d69 },
	{ 0x711c, 0x216055 },
	{ 0x711d, 0x233c74 },
	{ 0x711e, 0x223d5d },
	{ 0x711f, 0x223d66 },
	{ 0x7120, 0x223d5c },
	{ 0x7121, 0x216052 },
	{ 0x7122, 0x223d64 },
	{ 0x7123, 0x223d62 },
	{ 0x7124, 0x233c7d },
	{ 0x7125, 0x223d63 },
	{ 0x7126, 0x216050 },
	{ 0x7127, 0x233c7c },
	{ 0x7128, 0x223d67 },
	{ 0x712a, 0x233c6f },
	{ 0x712b, 0x233c7a },
	{ 0x712c, 0x233c72 },
	{ 0x712d, 0x233d21 },
	{ 0x712e, 0x223d60 },
	{ 0x712f, 0x223d5e },
	{ 0x7130, 0x216051 },
	{ 0x7131, 0x223d61 },
	{ 0x7132, 0x223d65 },
	{ 0x7133, 0x233c7b },
	{ 0x7134, 0x233c79 },
	{ 0x7135, 0x233c71 },
	{ 0x7136, 0x216053 },
	{ 0x7137, 0x233c73 },
	{ 0x7138, 0x233c77 },
	{ 0x7139, 0x236553 },
	{ 0x713a, 0x223d68 },
	{ 0x713b, 0x236554 },
	{ 0x713d, 0x236555 },
	{ 0x713f, 0x236552 },
	{ 0x7141, 0x224456 },
	{ 0x7142, 0x22445d },
	{ 0x7143, 0x22445f },
	{ 0x7144, 0x224465 },
	{ 0x7145, 0x234257 },
	{ 0x7146, 0x216522 },
	{ 0x7147, 0x224451 },
	{ 0x7148, 0x23424c },
	{ 0x7149, 0x216478 },
	{ 0x714a, 0x23424e },
	{ 0x714b, 0x224460 },
	{ 0x714c, 0x21647d },
	{ 0x714d, 0x224466 },
	{ 0x714e, 0x216474 },
	{ 0x714f, 0x234251 },
	{ 0x7150, 0x224463 },
	{ 0x7151, 0x234258 },
	{ 0x7152, 0x224453 },
	{ 0x7153, 0x224464 },
	{ 0x7154, 0x224452 },
	{ 0x7156, 0x216524 },
	{ 0x7157, 0x234252 },
	{ 0x7158, 0x22445e },
	{ 0x7159, 0x216475 },
	{ 0x715a, 0x224467 },
	{ 0x715b, 0x23483c },
	{ 0x715c, 0x21647a },
	{ 0x715d, 0x224457 },
	{ 0x715e, 0x216521 },
	{ 0x715f, 0x224462 },
	{ 0x7160, 0x224455 },
	{ 0x7161, 0x22445c },
	{ 0x7162, 0x224458 },
	{ 0x7163, 0x224454 },
	{ 0x7164, 0x216477 },
	{ 0x7165, 0x21647e },
	{ 0x7166, 0x21647c },
	{ 0x7167, 0x216479 },
	{ 0x7168, 0x216523 },
	{ 0x7169, 0x216476 },
	{ 0x716a, 0x22445b },
	{ 0x716b, 0x23424f },
	{ 0x716c, 0x21647b },
	{ 0x716d, 0x234259 },
	{ 0x716e, 0x216054 },
	{ 0x716f, 0x234249 },
	{ 0x7170, 0x224461 },
	{ 0x7171, 0x236559 },
	{ 0x7172, 0x224459 },
	{ 0x7174, 0x234253 },
	{ 0x7175, 0x236557 },
	{ 0x7176, 0x236558 },
	{ 0x7177, 0x236556 },
	{ 0x7178, 0x22445a },
	{ 0x717b, 0x224b67 },
	{ 0x717c, 0x23476f },
	{ 0x717d, 0x21695b },
	{ 0x717e, 0x23476e },
	{ 0x717f, 0x23476c },
	{ 0x7180, 0x224b63 },
	{ 0x7181, 0x224b69 },
	{ 0x7182, 0x224b65 },
	{ 0x7183, 0x234770 },
	{ 0x7184, 0x21695d },
	{ 0x7185, 0x224b64 },
	{ 0x7186, 0x224b68 },
	{ 0x7187, 0x224b60 },
	{ 0x7188, 0x234772 },
	{ 0x7189, 0x224b62 },
	{ 0x718a, 0x21695c },
	{ 0x718b, 0x23476a },
	{ 0x718c, 0x23476d },
	{ 0x718d, 0x23476b },
	{ 0x718e, 0x234768 },
	{ 0x718f, 0x224b66 },
	{ 0x7190, 0x224b61 },
	{ 0x7191, 0x234767 },
	{ 0x7192, 0x21695e },
	{ 0x7193, 0x23655b },
	{ 0x7194, 0x216959 },
	{ 0x7196, 0x23655a },
	{ 0x7197, 0x224b6a },
	{ 0x7199, 0x21695a },
	{ 0x719a, 0x22516f },
	{ 0x719b, 0x22516c },
	{ 0x719c, 0x225178 },
	{ 0x719d, 0x225172 },
	{ 0x719e, 0x225174 },
	{ 0x719f, 0x216d5e },
	{ 0x71a0, 0x22516e },
	{ 0x71a1, 0x225176 },
	{ 0x71a2, 0x234d2a },
	{ 0x71a3, 0x234d24 },
	{ 0x71a4, 0x225175 },
	{ 0x71a5, 0x225173 },
	{ 0x71a6, 0x234d29 },
	{ 0x71a7, 0x225179 },
	{ 0x71a8, 0x216d61 },
	{ 0x71a9, 0x225170 },
	{ 0x71aa, 0x225177 },
	{ 0x71ab, 0x234d28 },
	{ 0x71ac, 0x216d5f },
	{ 0x71ad, 0x234d25 },
	{ 0x71ae, 0x234d22 },
	{ 0x71af, 0x22516b },
	{ 0x71b0, 0x22516d },
	{ 0x71b1, 0x216d60 },
	{ 0x71b2, 0x22516a },
	{ 0x71b3, 0x22517a },
	{ 0x71b4, 0x23655c },
	{ 0x71b5, 0x225171 },
	{ 0x71b6, 0x235162 },
	{ 0x71b7, 0x23515a },
	{ 0x71b8, 0x225836 },
	{ 0x71b9, 0x21713b },
	{ 0x71ba, 0x235160 },
	{ 0x71bb, 0x23515c },
	{ 0x71bc, 0x225841 },
	{ 0x71bd, 0x22583f },
	{ 0x71be, 0x217135 },
	{ 0x71bf, 0x225835 },
	{ 0x71c0, 0x225838 },
	{ 0x71c1, 0x225839 },
	{ 0x71c2, 0x225834 },
	{ 0x71c3, 0x21713f },
	{ 0x71c4, 0x217140 },
	{ 0x71c5, 0x225833 },
	{ 0x71c6, 0x225842 },
	{ 0x71c7, 0x22583d },
	{ 0x71c8, 0x217139 },
	{ 0x71c9, 0x217136 },
	{ 0x71ca, 0x22583c },
	{ 0x71cb, 0x22583a },
	{ 0x71cc, 0x235163 },
	{ 0x71cd, 0x236374 },
	{ 0x71ce, 0x21713c },
	{ 0x71cf, 0x22583e },
	{ 0x71d0, 0x217137 },
	{ 0x71d1, 0x23515e },
	{ 0x71d2, 0x217138 },
	{ 0x71d3, 0x235166 },
	{ 0x71d4, 0x22583b },
	{ 0x71d5, 0x21713a },
	{ 0x71d6, 0x225837 },
	{ 0x71d8, 0x225840 },
	{ 0x71d9, 0x21713d },
	{ 0x71da, 0x225843 },
	{ 0x71db, 0x225844 },
	{ 0x71dc, 0x21713e },
	{ 0x71dd, 0x23655d },
	{ 0x71de, 0x23655e },
	{ 0x71df, 0x217432 },
	{ 0x71e0, 0x217439 },
	{ 0x71e1, 0x225d48 },
	{ 0x71e2, 0x225d4e },
	{ 0x71e3, 0x23553c },
	{ 0x71e4, 0x225d4c },
	{ 0x71e5, 0x217435 },
	{ 0x71e6, 0x217434 },
	{ 0x71e7, 0x217431 },
	{ 0x71e8, 0x225d4a },
	{ 0x71e9, 0x23553e },
	{ 0x71ea, 0x235543 },
	{ 0x71eb, 0x235540 },
	{ 0x71ec, 0x217437 },
	{ 0x71ed, 0x217436 },
	{ 0x71ee, 0x217433 },
	{ 0x71ef, 0x235541 },
	{ 0x71f0, 0x225d4d },
	{ 0x71f1, 0x225d49 },
	{ 0x71f2, 0x225d4b },
	{ 0x71f3, 0x235542 },
	{ 0x71f4, 0x217438 },
	{ 0x71f8, 0x217663 },
	{ 0x71f9, 0x226229 },
	{ 0x71fa, 0x23582d },
	{ 0x71fb, 0x217660 },
	{ 0x71fc, 0x217661 },
	{ 0x71fd, 0x22622b },
	{ 0x71fe, 0x217662 },
	{ 0x71ff, 0x226228 },
	{ 0x7200, 0x23582e },
	{ 0x7201, 0x226227 },
	{ 0x7202, 0x226576 },
	{ 0x7203, 0x22622a },
	{ 0x7204, 0x235a56 },
	{ 0x7205, 0x226577 },
	{ 0x7206, 0x217847 },
	{ 0x7207, 0x226575 },
	{ 0x7208, 0x235a57 },
	{ 0x720a, 0x226574 },
	{ 0x720b, 0x235c59 },
	{ 0x720c, 0x226573 },
	{ 0x720d, 0x217848 },
	{ 0x720e, 0x23655f },
	{ 0x720f, 0x235c56 },
	{ 0x7210, 0x217977 },
	{ 0x7211, 0x235c58 },
	{ 0x7212, 0x235c55 },
	{ 0x7213, 0x226939 },
	{ 0x7214, 0x22693a },
	{ 0x7215, 0x235a58 },
	{ 0x7216, 0x235c53 },
	{ 0x7217, 0x235c57 },
	{ 0x7218, 0x236561 },
	{ 0x7219, 0x226b6a },
	{ 0x721a, 0x226b69 },
	{ 0x721b, 0x217a75 },
	{ 0x721c, 0x235f53 },
	{ 0x721d, 0x226b68 },
	{ 0x721e, 0x226d5a },
	{ 0x721f, 0x226d5b },
	{ 0x7220, 0x235f54 },
	{ 0x7221, 0x236039 },
	{ 0x7222, 0x226f35 },
	{ 0x7223, 0x22703f },
	{ 0x7224, 0x236143 },
	{ 0x7225, 0x236142 },
	{ 0x7226, 0x227126 },
	{ 0x7227, 0x22722c },
	{ 0x7228, 0x217d46 },
	{ 0x7229, 0x227240 },
	{ 0x722a, 0x214557 },
	{ 0x722c, 0x214e67 },
	{ 0x722d, 0x214e68 },
	{ 0x722e, 0x232d69 },
	{ 0x7230, 0x21523b },
	{ 0x7232, 0x233d22 },
	{ 0x7235, 0x21743a },
	{ 0x7236, 0x214558 },
	{ 0x7238, 0x214e69 },
	{ 0x7239, 0x215655 },
	{ 0x723a, 0x216525 },
	{ 0x723b, 0x214559 },
	{ 0x723c, 0x232d6b },
	{ 0x723d, 0x215b73 },
	{ 0x723e, 0x21695f },
	{ 0x723f, 0x222142 },
	{ 0x7240, 0x23297c },
	{ 0x7241, 0x222b77 },
	{ 0x7242, 0x223060 },
	{ 0x7244, 0x224b6b },
	{ 0x7246, 0x21743b },
	{ 0x7247, 0x21455a },
	{ 0x7248, 0x214e6a },
	{ 0x7249, 0x222b78 },
	{ 0x724a, 0x222b79 },
	{ 0x724b, 0x223d6a },
	{ 0x724c, 0x216056 },
	{ 0x724e, 0x23425d },
	{ 0x724f, 0x224468 },
	{ 0x7250, 0x23425c },
	{ 0x7251, 0x23425b },
	{ 0x7252, 0x216526 },
	{ 0x7253, 0x224b6c },
	{ 0x7255, 0x234d2e },
	{ 0x7256, 0x216d62 },
	{ 0x7257, 0x234d2d },
	{ 0x7258, 0x217849 },
	{ 0x7259, 0x21455b },
	{ 0x725a, 0x223d6b },
	{ 0x725b, 0x21455c },
	{ 0x725d, 0x21484a },
	{ 0x725e, 0x222262 },
	{ 0x725f, 0x214849 },
	{ 0x7260, 0x214b28 },
	{ 0x7261, 0x214b27 },
	{ 0x7262, 0x214b26 },
	{ 0x7263, 0x222460 },
	{ 0x7264, 0x232664 },
	{ 0x7265, 0x232a21 },
	{ 0x7266, 0x232a22 },
	{ 0x7267, 0x214e6b },
	{ 0x7268, 0x232a23 },
	{ 0x7269, 0x214e6c },
	{ 0x726a, 0x22277b },
	{ 0x726c, 0x222b7a },
	{ 0x726d, 0x232d6d },
	{ 0x726e, 0x222b7d },
	{ 0x726f, 0x21523d },
	{ 0x7270, 0x222b7b },
	{ 0x7272, 0x21523c },
	{ 0x7273, 0x222b7c },
	{ 0x7274, 0x21523e },
	{ 0x7276, 0x223063 },
	{ 0x7277, 0x223062 },
	{ 0x7278, 0x223061 },
	{ 0x7279, 0x215656 },
	{ 0x727a, 0x233236 },
	{ 0x727b, 0x223722 },
	{ 0x727c, 0x223723 },
	{ 0x727d, 0x215b74 },
	{ 0x727e, 0x223721 },
	{ 0x727f, 0x223724 },
	{ 0x7280, 0x216058 },
	{ 0x7281, 0x215b75 },
	{ 0x7282, 0x233d24 },
	{ 0x7283, 0x233d23 },
	{ 0x7284, 0x216057 },
	{ 0x7285, 0x223d6f },
	{ 0x7286, 0x223d6e },
	{ 0x7287, 0x233d25 },
	{ 0x7288, 0x223d6c },
	{ 0x7289, 0x223d6d },
	{ 0x728b, 0x223d70 },
	{ 0x728c, 0x22446a },
	{ 0x728d, 0x224469 },
	{ 0x728e, 0x22446d },
	{ 0x7290, 0x22446c },
	{ 0x7291, 0x22446b },
	{ 0x7292, 0x216960 },
	{ 0x7293, 0x224b6f },
	{ 0x7294, 0x234775 },
	{ 0x7295, 0x224b6e },
	{ 0x7296, 0x216961 },
	{ 0x7297, 0x224b6d },
	{ 0x7298, 0x22517b },
	{ 0x7299, 0x234d2f },
	{ 0x729a, 0x22517c },
	{ 0x729b, 0x216d63 },
	{ 0x729d, 0x225845 },
	{ 0x729e, 0x225846 },
	{ 0x72a1, 0x22657c },
	{ 0x72a2, 0x21784a },
	{ 0x72a3, 0x22657b },
	{ 0x72a4, 0x22657a },
	{ 0x72a5, 0x226578 },
	{ 0x72a6, 0x226579 },
	{ 0x72a7, 0x217a76 },
	{ 0x72a8, 0x22693b },
	{ 0x72a9, 0x226d5c },
	{ 0x72aa, 0x227127 },
	{ 0x72ab, 0x23617b },
	{ 0x72ac, 0x21455d },
	{ 0x72ae, 0x222164 },
	{ 0x72af, 0x214667 },
	{ 0x72b0, 0x222165 },
	{ 0x72b1, 0x23242c },
	{ 0x72b2, 0x23242d },
	{ 0x72b4, 0x222263 },
	{ 0x72b5, 0x222264 },
	{ 0x72b6, 0x23266b },
	{ 0x72b9, 0x232669 },
	{ 0x72ba, 0x222466 },
	{ 0x72bb, 0x232666 },
	{ 0x72bc, 0x232667 },
	{ 0x72bd, 0x222462 },
	{ 0x72be, 0x23266a },
	{ 0x72bf, 0x222461 },
	{ 0x72c0, 0x214e6d },
	{ 0x72c1, 0x222465 },
	{ 0x72c2, 0x214b2a },
	{ 0x72c3, 0x222463 },
	{ 0x72c4, 0x214b29 },
	{ 0x72c5, 0x222467 },
	{ 0x72c6, 0x222464 },
	{ 0x72c7, 0x232668 },
	{ 0x72c9, 0x222821 },
	{ 0x72ca, 0x222b7e },
	{ 0x72cb, 0x22277d },
	{ 0x72cc, 0x222826 },
	{ 0x72cd, 0x232a26 },
	{ 0x72ce, 0x214e6e },
	{ 0x72cf, 0x232a2a },
	{ 0x72d0, 0x214e71 },
	{ 0x72d1, 0x222827 },
	{ 0x72d2, 0x222823 },
	{ 0x72d3, 0x232a27 },
	{ 0x72d4, 0x222824 },
	{ 0x72d6, 0x22277c },
	{ 0x72d7, 0x214e70 },
	{ 0x72d8, 0x22277e },
	{ 0x72d9, 0x214e6f },
	{ 0x72da, 0x222825 },
	{ 0x72db, 0x232a28 },
	{ 0x72dc, 0x222822 },
	{ 0x72df, 0x222c24 },
	{ 0x72e0, 0x215240 },
	{ 0x72e1, 0x215241 },
	{ 0x72e2, 0x232d75 },
	{ 0x72e3, 0x222c27 },
	{ 0x72e4, 0x222c21 },
	{ 0x72e5, 0x232d74 },
	{ 0x72e6, 0x222c26 },
	{ 0x72e7, 0x232d70 },
	{ 0x72e8, 0x222c22 },
	{ 0x72e9, 0x21523f },
	{ 0x72ea, 0x222c25 },
	{ 0x72eb, 0x222c23 },
	{ 0x72ec, 0x232d73 },
	{ 0x72ed, 0x232d71 },
	{ 0x72f3, 0x223069 },
	{ 0x72f4, 0x223066 },
	{ 0x72f5, 0x233238 },
	{ 0x72f6, 0x223068 },
	{ 0x72f7, 0x21565b },
	{ 0x72f8, 0x21565a },
	{ 0x72f9, 0x215658 },
	{ 0x72fa, 0x223065 },
	{ 0x72fb, 0x22306a },
	{ 0x72fc, 0x215657 },
	{ 0x72fd, 0x215659 },
	{ 0x72fe, 0x223067 },
	{ 0x72ff, 0x22372c },
	{ 0x7300, 0x223064 },
	{ 0x7301, 0x22306b },
	{ 0x7302, 0x233239 },
	{ 0x7306, 0x233d26 },
	{ 0x7307, 0x223727 },
	{ 0x7308, 0x22372b },
	{ 0x730a, 0x22372a },
	{ 0x730b, 0x223d72 },
	{ 0x730c, 0x223d7d },
	{ 0x730e, 0x23373b },
	{ 0x730f, 0x22372d },
	{ 0x7310, 0x23373a },
	{ 0x7311, 0x223728 },
	{ 0x7312, 0x223d71 },
	{ 0x7313, 0x215b79 },
	{ 0x7316, 0x215b78 },
	{ 0x7317, 0x223726 },
	{ 0x7318, 0x223729 },
	{ 0x7319, 0x215b7a },
	{ 0x731a, 0x233739 },
	{ 0x731b, 0x215b77 },
	{ 0x731c, 0x215b76 },
	{ 0x731d, 0x223725 },
	{ 0x731e, 0x22372e },
	{ 0x7322, 0x223d74 },
	{ 0x7323, 0x223d7b },
	{ 0x7324, 0x233d27 },
	{ 0x7325, 0x21605a },
	{ 0x7326, 0x223d7a },
	{ 0x7327, 0x223d77 },
	{ 0x7328, 0x233d2e },
	{ 0x7329, 0x21605c },
	{ 0x732a, 0x233d29 },
	{ 0x732b, 0x233d2b },
	{ 0x732c, 0x233d2a },
	{ 0x732d, 0x223d79 },
	{ 0x732e, 0x234261 },
	{ 0x732f, 0x233d2d },
	{ 0x7330, 0x223d73 },
	{ 0x7331, 0x223d75 },
	{ 0x7332, 0x223d78 },
	{ 0x7333, 0x223d76 },
	{ 0x7334, 0x21605b },
	{ 0x7335, 0x223d7c },
	{ 0x7336, 0x216059 },
	{ 0x7337, 0x216527 },
	{ 0x7338, 0x233d28 },
	{ 0x733a, 0x224471 },
	{ 0x733b, 0x224470 },
	{ 0x733c, 0x22446e },
	{ 0x733e, 0x21652a },
	{ 0x733f, 0x216529 },
	{ 0x7340, 0x224472 },
	{ 0x7341, 0x23425f },
	{ 0x7342, 0x22446f },
	{ 0x7343, 0x224b70 },
	{ 0x7344, 0x216962 },
	{ 0x7345, 0x216528 },
	{ 0x7346, 0x234262 },
	{ 0x7347, 0x236562 },
	{ 0x7348, 0x236563 },
	{ 0x7349, 0x224474 },
	{ 0x734a, 0x224473 },
	{ 0x734b, 0x234d30 },
	{ 0x734c, 0x224b73 },
	{ 0x734d, 0x224b71 },
	{ 0x734e, 0x216d64 },
	{ 0x734f, 0x234779 },
	{ 0x7350, 0x216963 },
	{ 0x7351, 0x224b72 },
	{ 0x7352, 0x22517e },
	{ 0x7353, 0x234778 },
	{ 0x7354, 0x23477a },
	{ 0x7355, 0x234777 },
	{ 0x7357, 0x216d65 },
	{ 0x7358, 0x22517d },
	{ 0x7359, 0x225228 },
	{ 0x735a, 0x225227 },
	{ 0x735b, 0x225225 },
	{ 0x735d, 0x225224 },
	{ 0x735e, 0x225221 },
	{ 0x735f, 0x225222 },
	{ 0x7360, 0x225223 },
	{ 0x7361, 0x225226 },
	{ 0x7362, 0x225229 },
	{ 0x7365, 0x22584b },
	{ 0x7366, 0x225848 },
	{ 0x7367, 0x225849 },
	{ 0x7368, 0x217141 },
	{ 0x7369, 0x225847 },
	{ 0x736a, 0x22584d },
	{ 0x736b, 0x22584c },
	{ 0x736c, 0x22584a },
	{ 0x736e, 0x225d50 },
	{ 0x736f, 0x225d51 },
	{ 0x7370, 0x21743c },
	{ 0x7371, 0x235549 },
	{ 0x7372, 0x21743d },
	{ 0x7373, 0x225d4f },
	{ 0x7375, 0x217665 },
	{ 0x7376, 0x22622c },
	{ 0x7377, 0x217664 },
	{ 0x7378, 0x21784b },
	{ 0x737a, 0x21784c },
	{ 0x737b, 0x217978 },
	{ 0x737c, 0x22693d },
	{ 0x737d, 0x22693c },
	{ 0x737e, 0x226b6b },
	{ 0x737f, 0x226d5d },
	{ 0x7380, 0x217b66 },
	{ 0x7381, 0x226f37 },
	{ 0x7382, 0x226f36 },
	{ 0x7383, 0x226f38 },
	{ 0x7384, 0x214668 },
	{ 0x7385, 0x222c28 },
	{ 0x7386, 0x21565c },
	{ 0x7387, 0x215b7b },
	{ 0x7388, 0x22372f },
	{ 0x7389, 0x214669 },
	{ 0x738a, 0x222166 },
	{ 0x738b, 0x21455e },
	{ 0x738c, 0x23225a },
	{ 0x738d, 0x23216b },
	{ 0x738e, 0x222265 },
	{ 0x738f, 0x23242f },
	{ 0x7392, 0x22246c },
	{ 0x7393, 0x22246a },
	{ 0x7394, 0x22246b },
	{ 0x7395, 0x222468 },
	{ 0x7396, 0x214b2b },
	{ 0x7397, 0x222469 },
	{ 0x7398, 0x23266e },
	{ 0x739c, 0x232a33 },
	{ 0x739d, 0x22282f },
	{ 0x739e, 0x232a2d },
	{ 0x739f, 0x214e74 },
	{ 0x73a0, 0x22282d },
	{ 0x73a1, 0x222829 },
	{ 0x73a2, 0x22282c },
	{ 0x73a3, 0x232a2c },
	{ 0x73a4, 0x222828 },
	{ 0x73a5, 0x214e76 },
	{ 0x73a6, 0x22282b },
	{ 0x73a7, 0x232a2b },
	{ 0x73a8, 0x214e73 },
	{ 0x73a9, 0x214e72 },
	{ 0x73aa, 0x232a32 },
	{ 0x73ab, 0x214e75 },
	{ 0x73ac, 0x22282e },
	{ 0x73ad, 0x22282a },
	{ 0x73af, 0x232a2f },
	{ 0x73b2, 0x215245 },
	{ 0x73b3, 0x215248 },
	{ 0x73b4, 0x222c30 },
	{ 0x73b5, 0x222c2f },
	{ 0x73b6, 0x222c2e },
	{ 0x73b7, 0x215242 },
	{ 0x73b8, 0x222c37 },
	{ 0x73b9, 0x222c2d },
	{ 0x73bb, 0x215244 },
	{ 0x73bc, 0x223070 },
	{ 0x73bd, 0x232d78 },
	{ 0x73be, 0x222c34 },
	{ 0x73bf, 0x222c32 },
	{ 0x73c0, 0x215247 },
	{ 0x73c1, 0x232d7b },
	{ 0x73c2, 0x222c2a },
	{ 0x73c3, 0x222c35 },
	{ 0x73c4, 0x232d77 },
	{ 0x73c5, 0x222c2c },
	{ 0x73c6, 0x222c36 },
	{ 0x73c7, 0x222c33 },
	{ 0x73c8, 0x222c2b },
	{ 0x73c9, 0x232d7a },
	{ 0x73ca, 0x215243 },
	{ 0x73cb, 0x222c38 },
	{ 0x73cc, 0x222c29 },
	{ 0x73cd, 0x215246 },
	{ 0x73ce, 0x232d7e },
	{ 0x73cf, 0x232d79 },
	{ 0x73d0, 0x232d7c },
	{ 0x73d2, 0x223075 },
	{ 0x73d3, 0x22306c },
	{ 0x73d4, 0x223077 },
	{ 0x73d5, 0x23323e },
	{ 0x73d6, 0x22306f },
	{ 0x73d7, 0x22307a },
	{ 0x73d8, 0x22307b },
	{ 0x73d9, 0x22306d },
	{ 0x73da, 0x223079 },
	{ 0x73db, 0x223076 },
	{ 0x73dc, 0x223074 },
	{ 0x73dd, 0x223078 },
	{ 0x73de, 0x215662 },
	{ 0x73df, 0x233240 },
	{ 0x73e0, 0x215660 },
	{ 0x73e1, 0x233247 },
	{ 0x73e2, 0x23323c },
	{ 0x73e3, 0x223072 },
	{ 0x73e4, 0x233246 },
	{ 0x73e5, 0x22306e },
	{ 0x73e6, 0x233241 },
	{ 0x73e7, 0x223071 },
	{ 0x73e8, 0x22307c },
	{ 0x73e9, 0x223073 },
	{ 0x73ea, 0x215661 },
	{ 0x73eb, 0x222c31 },
	{ 0x73ec, 0x23323d },
	{ 0x73ed, 0x21565d },
	{ 0x73ee, 0x21565f },
	{ 0x73ef, 0x236564 },
	{ 0x73f3, 0x23373d },
	{ 0x73f4, 0x22373d },
	{ 0x73f5, 0x223732 },
	{ 0x73f6, 0x223730 },
	{ 0x73f7, 0x233d38 },
	{ 0x73f8, 0x223731 },
	{ 0x73f9, 0x23323f },
	{ 0x73fa, 0x223738 },
	{ 0x73fb, 0x233740 },
	{ 0x73fc, 0x223739 },
	{ 0x73fd, 0x223735 },
	{ 0x73fe, 0x215c22 },
	{ 0x73ff, 0x22373a },
	{ 0x7400, 0x223737 },
	{ 0x7401, 0x223734 },
	{ 0x7402, 0x23373c },
	{ 0x7403, 0x215b7e },
	{ 0x7404, 0x223733 },
	{ 0x7405, 0x215b7c },
	{ 0x7406, 0x215c21 },
	{ 0x7407, 0x223736 },
	{ 0x7408, 0x22373e },
	{ 0x7409, 0x21565e },
	{ 0x740a, 0x215b7d },
	{ 0x740b, 0x22373c },
	{ 0x740c, 0x22373b },
	{ 0x740d, 0x215c23 },
	{ 0x7412, 0x236565 },
	{ 0x7414, 0x233d36 },
	{ 0x7415, 0x233d3a },
	{ 0x7416, 0x223e24 },
	{ 0x7417, 0x233d2f },
	{ 0x7418, 0x233d3b },
	{ 0x7419, 0x233d32 },
	{ 0x741a, 0x223e25 },
	{ 0x741b, 0x216066 },
	{ 0x741c, 0x233d39 },
	{ 0x741d, 0x223e2b },
	{ 0x741e, 0x23426d },
	{ 0x741f, 0x233d35 },
	{ 0x7420, 0x223e2d },
	{ 0x7421, 0x223e26 },
	{ 0x7422, 0x216060 },
	{ 0x7423, 0x223e2a },
	{ 0x7424, 0x223e29 },
	{ 0x7425, 0x216061 },
	{ 0x7426, 0x216067 },
	{ 0x7427, 0x234264 },
	{ 0x7428, 0x216068 },
	{ 0x7429, 0x223e2c },
	{ 0x742a, 0x21605e },
	{ 0x742b, 0x223e23 },
	{ 0x742c, 0x223e21 },
	{ 0x742d, 0x223e27 },
	{ 0x742e, 0x223d7e },
	{ 0x742f, 0x216065 },
	{ 0x7430, 0x223e22 },
	{ 0x7431, 0x223e28 },
	{ 0x7432, 0x223e2e },
	{ 0x7433, 0x21605f },
	{ 0x7434, 0x216064 },
	{ 0x7435, 0x216062 },
	{ 0x7436, 0x216063 },
	{ 0x7438, 0x233d33 },
	{ 0x7439, 0x233d3c },
	{ 0x743a, 0x21605d },
	{ 0x743b, 0x236566 },
	{ 0x743c, 0x233d37 },
	{ 0x743d, 0x234268 },
	{ 0x743e, 0x234275 },
	{ 0x743f, 0x216531 },
	{ 0x7440, 0x22447b },
	{ 0x7441, 0x216530 },
	{ 0x7442, 0x224521 },
	{ 0x7443, 0x23426f },
	{ 0x7444, 0x224475 },
	{ 0x7445, 0x234274 },
	{ 0x7446, 0x224522 },
	{ 0x7447, 0x23426e },
	{ 0x7448, 0x234266 },
	{ 0x7449, 0x234271 },
	{ 0x744a, 0x224476 },
	{ 0x744b, 0x224477 },
	{ 0x744c, 0x234273 },
	{ 0x744d, 0x224523 },
	{ 0x744e, 0x22447e },
	{ 0x744f, 0x22447c },
	{ 0x7450, 0x22447d },
	{ 0x7451, 0x224479 },
	{ 0x7452, 0x224478 },
	{ 0x7453, 0x234267 },
	{ 0x7454, 0x224524 },
	{ 0x7455, 0x21652d },
	{ 0x7456, 0x23426b },
	{ 0x7457, 0x22447a },
	{ 0x7458, 0x234270 },
	{ 0x7459, 0x216532 },
	{ 0x745a, 0x21652c },
	{ 0x745b, 0x216533 },
	{ 0x745c, 0x216534 },
	{ 0x745d, 0x23426a },
	{ 0x745e, 0x21652f },
	{ 0x745f, 0x21652e },
	{ 0x7460, 0x234825 },
	{ 0x7461, 0x23477e },
	{ 0x7462, 0x224b74 },
	{ 0x7463, 0x216965 },
	{ 0x7464, 0x216964 },
	{ 0x7465, 0x23477c },
	{ 0x7466, 0x23477d },
	{ 0x7467, 0x224b79 },
	{ 0x7468, 0x234822 },
	{ 0x7469, 0x216d66 },
	{ 0x746a, 0x216966 },
	{ 0x746b, 0x234821 },
	{ 0x746c, 0x23477b },
	{ 0x746d, 0x216968 },
	{ 0x746e, 0x224b7a },
	{ 0x746f, 0x21652b },
	{ 0x7470, 0x216967 },
	{ 0x7471, 0x224b76 },
	{ 0x7472, 0x224b78 },
	{ 0x7473, 0x224b75 },
	{ 0x7474, 0x234827 },
	{ 0x7475, 0x224b77 },
	{ 0x7476, 0x234823 },
	{ 0x7479, 0x225233 },
	{ 0x747a, 0x234d31 },
	{ 0x747b, 0x234d3b },
	{ 0x747c, 0x225232 },
	{ 0x747d, 0x22522f },
	{ 0x747e, 0x216d69 },
	{ 0x747f, 0x22584e },
	{ 0x7480, 0x216d6a },
	{ 0x7481, 0x22522e },
	{ 0x7482, 0x234d39 },
	{ 0x7483, 0x216d68 },
	{ 0x7484, 0x234d36 },
	{ 0x7485, 0x225230 },
	{ 0x7486, 0x22522d },
	{ 0x7487, 0x22522a },
	{ 0x7488, 0x225231 },
	{ 0x7489, 0x22522b },
	{ 0x748a, 0x22522c },
	{ 0x748b, 0x216d67 },
	{ 0x748c, 0x234d35 },
	{ 0x748d, 0x236568 },
	{ 0x7490, 0x225d55 },
	{ 0x7492, 0x225852 },
	{ 0x7493, 0x234d3a },
	{ 0x7494, 0x225851 },
	{ 0x7495, 0x225853 },
	{ 0x7496, 0x23516a },
	{ 0x7497, 0x225d52 },
	{ 0x7498, 0x217144 },
	{ 0x7499, 0x236375 },
	{ 0x749a, 0x22584f },
	{ 0x749b, 0x235167 },
	{ 0x749c, 0x217142 },
	{ 0x749d, 0x23516c },
	{ 0x749e, 0x217146 },
	{ 0x749f, 0x217145 },
	{ 0x74a0, 0x225850 },
	{ 0x74a1, 0x225854 },
	{ 0x74a2, 0x23516b },
	{ 0x74a3, 0x217143 },
	{ 0x74a4, 0x236567 },
	{ 0x74a5, 0x225d59 },
	{ 0x74a6, 0x217440 },
	{ 0x74a7, 0x217666 },
	{ 0x74a8, 0x217441 },
	{ 0x74a9, 0x21743e },
	{ 0x74aa, 0x225d56 },
	{ 0x74ab, 0x225d54 },
	{ 0x74ac, 0x23554f },
	{ 0x74ad, 0x225d57 },
	{ 0x74ae, 0x23554b },
	{ 0x74af, 0x225d5a },
	{ 0x74b0, 0x21743f },
	{ 0x74b1, 0x225d58 },
	{ 0x74b2, 0x225d53 },
	{ 0x74b3, 0x23554d },
	{ 0x74b4, 0x236569 },
	{ 0x74b5, 0x22622f },
	{ 0x74b6, 0x226232 },
	{ 0x74b7, 0x226621 },
	{ 0x74b8, 0x22622d },
	{ 0x74b9, 0x23582f },
	{ 0x74ba, 0x22693e },
	{ 0x74bb, 0x226233 },
	{ 0x74bc, 0x235830 },
	{ 0x74bd, 0x21784d },
	{ 0x74be, 0x226231 },
	{ 0x74bf, 0x217667 },
	{ 0x74c0, 0x22622e },
	{ 0x74c1, 0x226230 },
	{ 0x74c2, 0x226234 },
	{ 0x74c3, 0x226622 },
	{ 0x74c4, 0x235a5a },
	{ 0x74c5, 0x22657e },
	{ 0x74c7, 0x235a5c },
	{ 0x74c8, 0x235a5d },
	{ 0x74c9, 0x235a5b },
	{ 0x74ca, 0x21784e },
	{ 0x74cb, 0x22657d },
	{ 0x74cc, 0x235c5e },
	{ 0x74cd, 0x235c5c },
	{ 0x74ce, 0x235c5f },
	{ 0x74cf, 0x217979 },
	{ 0x74d0, 0x235c5d },
	{ 0x74d1, 0x235c60 },
	{ 0x74d3, 0x235e3d },
	{ 0x74d4, 0x217a78 },
	{ 0x74d5, 0x226d5f },
	{ 0x74d6, 0x217a77 },
	{ 0x74d7, 0x226d61 },
	{ 0x74d8, 0x226d5e },
	{ 0x74d9, 0x226d60 },
	{ 0x74da, 0x217c3c },
	{ 0x74db, 0x227040 },
	{ 0x74dc, 0x21466a },
	{ 0x74dd, 0x222830 },
	{ 0x74de, 0x22307d },
	{ 0x74df, 0x22307e },
	{ 0x74e0, 0x215c24 },
	{ 0x74e1, 0x224525 },
	{ 0x74e2, 0x217147 },
	{ 0x74e3, 0x21784f },
	{ 0x74e4, 0x217b67 },
	{ 0x74e5, 0x227041 },
	{ 0x74e6, 0x21466b },
	{ 0x74e8, 0x222831 },
	{ 0x74e9, 0x212322 },
	{ 0x74eb, 0x232e22 },
	{ 0x74ec, 0x222c39 },
	{ 0x74ed, 0x232e21 },
	{ 0x74ee, 0x222c3a },
	{ 0x74ef, 0x232e24 },
	{ 0x74f3, 0x233248 },
	{ 0x74f4, 0x223121 },
	{ 0x74f5, 0x223122 },
	{ 0x74f6, 0x215c25 },
	{ 0x74f7, 0x215c26 },
	{ 0x74f9, 0x233d3d },
	{ 0x74fb, 0x223e2f },
	{ 0x74fd, 0x224528 },
	{ 0x74fe, 0x224527 },
	{ 0x74ff, 0x224526 },
	{ 0x7500, 0x224b7b },
	{ 0x7501, 0x234277 },
	{ 0x7502, 0x224b7c },
	{ 0x7503, 0x224b7d },
	{ 0x7504, 0x216969 },
	{ 0x7506, 0x234828 },
	{ 0x7507, 0x225235 },
	{ 0x7508, 0x225234 },
	{ 0x7509, 0x234d3d },
	{ 0x750a, 0x23516d },
	{ 0x750b, 0x225855 },
	{ 0x750c, 0x217148 },
	{ 0x750d, 0x217149 },
	{ 0x750e, 0x23516e },
	{ 0x750f, 0x225d5e },
	{ 0x7510, 0x225d5b },
	{ 0x7511, 0x225d5c },
	{ 0x7512, 0x225d5d },
	{ 0x7513, 0x226236 },
	{ 0x7514, 0x226235 },
	{ 0x7515, 0x217668 },
	{ 0x7516, 0x226623 },
	{ 0x7517, 0x226b6c },
	{ 0x7518, 0x21466c },
	{ 0x751a, 0x215249 },
	{ 0x751b, 0x233744 },
	{ 0x751c, 0x215c27 },
	{ 0x751d, 0x224529 },
	{ 0x751e, 0x234278 },
	{ 0x751f, 0x21466d },
	{ 0x7521, 0x223123 },
	{ 0x7522, 0x215c28 },
	{ 0x7523, 0x233745 },
	{ 0x7524, 0x233d3e },
	{ 0x7525, 0x216069 },
	{ 0x7526, 0x21606a },
	{ 0x7528, 0x21466e },
	{ 0x7529, 0x21466f },
	{ 0x752a, 0x222266 },
	{ 0x752b, 0x214b2d },
	{ 0x752c, 0x214b2c },
	{ 0x752d, 0x21524a },
	{ 0x752e, 0x222c3b },
	{ 0x752f, 0x223e30 },
	{ 0x7530, 0x214670 },
	{ 0x7531, 0x214671 },
	{ 0x7532, 0x214672 },
	{ 0x7533, 0x214673 },
	{ 0x7537, 0x214b2e },
	{ 0x7538, 0x214b2f },
	{ 0x7539, 0x22246e },
	{ 0x753a, 0x22246d },
	{ 0x753b, 0x232a37 },
	{ 0x753d, 0x214e77 },
	{ 0x753e, 0x222834 },
	{ 0x753f, 0x222832 },
	{ 0x7540, 0x222833 },
	{ 0x7541, 0x232a38 },
	{ 0x7542, 0x232a35 },
	{ 0x7544, 0x232a36 },
	{ 0x7546, 0x232e27 },
	{ 0x7547, 0x222c3c },
	{ 0x7548, 0x222c3d },
	{ 0x7549, 0x232e25 },
	{ 0x754a, 0x232e28 },
	{ 0x754b, 0x21524e },
	{ 0x754c, 0x21524c },
	{ 0x754d, 0x232e2a },
	{ 0x754e, 0x21524d },
	{ 0x754f, 0x21524b },
	{ 0x7550, 0x232e26 },
	{ 0x7554, 0x215663 },
	{ 0x7555, 0x23324e },
	{ 0x7556, 0x23324d },
	{ 0x7557, 0x233250 },
	{ 0x7558, 0x23324f },
	{ 0x7559, 0x215667 },
	{ 0x755a, 0x215666 },
	{ 0x755b, 0x223124 },
	{ 0x755c, 0x215665 },
	{ 0x755d, 0x215664 },
	{ 0x755e, 0x233251 },
	{ 0x755f, 0x223125 },
	{ 0x7561, 0x233746 },
	{ 0x7562, 0x215c2b },
	{ 0x7563, 0x223740 },
	{ 0x7564, 0x22373f },
	{ 0x7565, 0x215c29 },
	{ 0x7566, 0x215c2a },
	{ 0x7567, 0x233749 },
	{ 0x7568, 0x233747 },
	{ 0x756a, 0x21606c },
	{ 0x756b, 0x21606b },
	{ 0x756c, 0x223e32 },
	{ 0x756d, 0x233d43 },
	{ 0x756e, 0x233d42 },
	{ 0x756f, 0x223e31 },
	{ 0x7570, 0x215c2c },
	{ 0x7571, 0x233d44 },
	{ 0x7576, 0x216535 },
	{ 0x7577, 0x22452b },
	{ 0x7578, 0x216536 },
	{ 0x7579, 0x22452a },
	{ 0x757a, 0x23427b },
	{ 0x757d, 0x224b7e },
	{ 0x757e, 0x225236 },
	{ 0x757f, 0x216d6b },
	{ 0x7580, 0x225856 },
	{ 0x7581, 0x235170 },
	{ 0x7583, 0x235552 },
	{ 0x7584, 0x225d5f },
	{ 0x7586, 0x217851 },
	{ 0x7587, 0x217850 },
	{ 0x7589, 0x235c62 },
	{ 0x758a, 0x217b68 },
	{ 0x758b, 0x214674 },
	{ 0x758c, 0x222835 },
	{ 0x758e, 0x233d45 },
	{ 0x758f, 0x215c2d },
	{ 0x7590, 0x224c21 },
	{ 0x7591, 0x21696a },
	{ 0x7592, 0x23225b },
	{ 0x7593, 0x232673 },
	{ 0x7594, 0x22246f },
	{ 0x7595, 0x222470 },
	{ 0x7598, 0x222836 },
	{ 0x7599, 0x214e79 },
	{ 0x759a, 0x214e7a },
	{ 0x759b, 0x232a3a },
	{ 0x759d, 0x214e78 },
	{ 0x759e, 0x232a3b },
	{ 0x75a2, 0x215252 },
	{ 0x75a3, 0x215253 },
	{ 0x75a4, 0x215250 },
	{ 0x75a5, 0x215251 },
	{ 0x75a6, 0x232e2b },
	{ 0x75a7, 0x222c3e },
	{ 0x75a8, 0x232e2f },
	{ 0x75aa, 0x222c3f },
	{ 0x75ab, 0x21524f },
	{ 0x75b0, 0x223126 },
	{ 0x75b1, 0x233257 },
	{ 0x75b2, 0x21566b },
	{ 0x75b3, 0x21566c },
	{ 0x75b4, 0x233255 },
	{ 0x75b5, 0x215c30 },
	{ 0x75b6, 0x22312c },
	{ 0x75b8, 0x215671 },
	{ 0x75b9, 0x21566f },
	{ 0x75ba, 0x22312d },
	{ 0x75bb, 0x223128 },
	{ 0x75bc, 0x21566e },
	{ 0x75bd, 0x21566d },
	{ 0x75be, 0x215668 },
	{ 0x75bf, 0x22312b },
	{ 0x75c0, 0x22312a },
	{ 0x75c1, 0x223127 },
	{ 0x75c2, 0x215670 },
	{ 0x75c3, 0x233252 },
	{ 0x75c4, 0x223129 },
	{ 0x75c5, 0x215669 },
	{ 0x75c7, 0x21566a },
	{ 0x75ca, 0x215c31 },
	{ 0x75cb, 0x223744 },
	{ 0x75cc, 0x223745 },
	{ 0x75cd, 0x215c32 },
	{ 0x75ce, 0x223741 },
	{ 0x75cf, 0x223743 },
	{ 0x75d0, 0x223747 },
	{ 0x75d1, 0x223746 },
	{ 0x75d2, 0x223742 },
	{ 0x75d3, 0x23374a },
	{ 0x75d4, 0x215c2e },
	{ 0x75d5, 0x215c2f },
	{ 0x75d7, 0x223e3a },
	{ 0x75d8, 0x216071 },
	{ 0x75d9, 0x216070 },
	{ 0x75da, 0x223e34 },
	{ 0x75db, 0x21606e },
	{ 0x75dd, 0x223e37 },
	{ 0x75de, 0x216072 },
	{ 0x75df, 0x223e38 },
	{ 0x75e0, 0x216073 },
	{ 0x75e1, 0x223e35 },
	{ 0x75e2, 0x21606d },
	{ 0x75e3, 0x21606f },
	{ 0x75e4, 0x223e39 },
	{ 0x75e5, 0x233d47 },
	{ 0x75e6, 0x223e36 },
	{ 0x75e7, 0x223e33 },
	{ 0x75ed, 0x224538 },
	{ 0x75ee, 0x23427c },
	{ 0x75ef, 0x22452d },
	{ 0x75f0, 0x216538 },
	{ 0x75f1, 0x21653b },
	{ 0x75f2, 0x21653a },
	{ 0x75f3, 0x21653f },
	{ 0x75f4, 0x21653e },
	{ 0x75f5, 0x224539 },
	{ 0x75f6, 0x224537 },
	{ 0x75f7, 0x224530 },
	{ 0x75f8, 0x224534 },
	{ 0x75f9, 0x224533 },
	{ 0x75fa, 0x21653c },
	{ 0x75fb, 0x224536 },
	{ 0x75fc, 0x224532 },
	{ 0x75fd, 0x22453a },
	{ 0x75fe, 0x224531 },
	{ 0x75ff, 0x21653d },
	{ 0x7600, 0x216537 },
	{ 0x7601, 0x216539 },
	{ 0x7602, 0x23427d },
	{ 0x7603, 0x22452f },
	{ 0x7607, 0x23482b },
	{ 0x7608, 0x224c23 },
	{ 0x7609, 0x21696e },
	{ 0x760a, 0x224c27 },
	{ 0x760b, 0x21696d },
	{ 0x760c, 0x224c24 },
	{ 0x760d, 0x21696c },
	{ 0x760e, 0x234829 },
	{ 0x760f, 0x22452e },
	{ 0x7610, 0x224535 },
	{ 0x7611, 0x224c26 },
	{ 0x7613, 0x21696f },
	{ 0x7614, 0x224c28 },
	{ 0x7615, 0x224c25 },
	{ 0x7616, 0x224c22 },
	{ 0x7619, 0x225239 },
	{ 0x761a, 0x22523d },
	{ 0x761b, 0x22523f },
	{ 0x761c, 0x22523b },
	{ 0x761d, 0x22523a },
	{ 0x761e, 0x225238 },
	{ 0x761f, 0x216d6e },
	{ 0x7620, 0x216d6c },
	{ 0x7621, 0x216d71 },
	{ 0x7622, 0x216d72 },
	{ 0x7623, 0x22523c },
	{ 0x7624, 0x216d6f },
	{ 0x7625, 0x225237 },
	{ 0x7626, 0x216d70 },
	{ 0x7627, 0x21696b },
	{ 0x7628, 0x22523e },
	{ 0x7629, 0x216d6d },
	{ 0x762c, 0x235171 },
	{ 0x762d, 0x225858 },
	{ 0x762f, 0x225857 },
	{ 0x7630, 0x22585f },
	{ 0x7631, 0x225859 },
	{ 0x7632, 0x22585e },
	{ 0x7633, 0x22585b },
	{ 0x7634, 0x21714a },
	{ 0x7635, 0x22585d },
	{ 0x7636, 0x235173 },
	{ 0x7637, 0x235172 },
	{ 0x7638, 0x21714b },
	{ 0x763a, 0x21714c },
	{ 0x763b, 0x235174 },
	{ 0x763c, 0x22585c },
	{ 0x763d, 0x22585a },
	{ 0x7642, 0x217443 },
	{ 0x7643, 0x225d60 },
	{ 0x7644, 0x235555 },
	{ 0x7645, 0x235553 },
	{ 0x7646, 0x217442 },
	{ 0x7647, 0x225d63 },
	{ 0x7648, 0x225d61 },
	{ 0x7649, 0x225d62 },
	{ 0x764c, 0x217444 },
	{ 0x764e, 0x235554 },
	{ 0x764f, 0x235834 },
	{ 0x7650, 0x22623a },
	{ 0x7651, 0x235833 },
	{ 0x7652, 0x21766b },
	{ 0x7653, 0x22623b },
	{ 0x7656, 0x217669 },
	{ 0x7657, 0x22623c },
	{ 0x7658, 0x21766a },
	{ 0x7659, 0x226239 },
	{ 0x765a, 0x22623d },
	{ 0x765b, 0x235832 },
	{ 0x765c, 0x226237 },
	{ 0x765f, 0x217852 },
	{ 0x7660, 0x226624 },
	{ 0x7661, 0x217853 },
	{ 0x7662, 0x21797a },
	{ 0x7664, 0x226238 },
	{ 0x7665, 0x21797b },
	{ 0x7667, 0x235e3f },
	{ 0x7668, 0x235e3e },
	{ 0x7669, 0x217a79 },
	{ 0x766a, 0x226b6d },
	{ 0x766c, 0x217b6a },
	{ 0x766d, 0x226d62 },
	{ 0x766e, 0x217b69 },
	{ 0x766f, 0x23603b },
	{ 0x7670, 0x226f39 },
	{ 0x7671, 0x217c61 },
	{ 0x7672, 0x217c62 },
	{ 0x7673, 0x23656a },
	{ 0x7675, 0x22723a },
	{ 0x7676, 0x23225c },
	{ 0x7677, 0x23656b },
	{ 0x7678, 0x215254 },
	{ 0x7679, 0x222c40 },
	{ 0x767b, 0x216074 },
	{ 0x767c, 0x216075 },
	{ 0x767d, 0x214675 },
	{ 0x767e, 0x21484b },
	{ 0x767f, 0x222267 },
	{ 0x7680, 0x232674 },
	{ 0x7681, 0x222471 },
	{ 0x7682, 0x214b30 },
	{ 0x7683, 0x232676 },
	{ 0x7684, 0x214e7b },
	{ 0x7686, 0x215255 },
	{ 0x7687, 0x215256 },
	{ 0x7688, 0x215257 },
	{ 0x7689, 0x223749 },
	{ 0x768a, 0x22312e },
	{ 0x768b, 0x215672 },
	{ 0x768e, 0x215c33 },
	{ 0x768f, 0x223748 },
	{ 0x7690, 0x23374d },
	{ 0x7692, 0x223e3c },
	{ 0x7693, 0x216077 },
	{ 0x7694, 0x233d4c },
	{ 0x7695, 0x223e3b },
	{ 0x7696, 0x216076 },
	{ 0x7697, 0x23427e },
	{ 0x7698, 0x234321 },
	{ 0x7699, 0x22453b },
	{ 0x769a, 0x216d73 },
	{ 0x769b, 0x225243 },
	{ 0x769c, 0x225240 },
	{ 0x769d, 0x225241 },
	{ 0x769e, 0x225242 },
	{ 0x76a1, 0x235176 },
	{ 0x76a3, 0x235556 },
	{ 0x76a4, 0x225d64 },
	{ 0x76a5, 0x235557 },
	{ 0x76a6, 0x22623e },
	{ 0x76a9, 0x235a5e },
	{ 0x76aa, 0x226940 },
	{ 0x76ab, 0x22693f },
	{ 0x76ad, 0x226d63 },
	{ 0x76ae, 0x214676 },
	{ 0x76af, 0x222837 },
	{ 0x76b0, 0x215673 },
	{ 0x76b3, 0x233d4d },
	{ 0x76b4, 0x216078 },
	{ 0x76b5, 0x22453c },
	{ 0x76b7, 0x234830 },
	{ 0x76b8, 0x224c29 },
	{ 0x76b9, 0x23482e },
	{ 0x76ba, 0x216d74 },
	{ 0x76bb, 0x225860 },
	{ 0x76bc, 0x23656c },
	{ 0x76bd, 0x22623f },
	{ 0x76be, 0x226941 },
	{ 0x76bf, 0x214677 },
	{ 0x76c0, 0x232677 },
	{ 0x76c1, 0x232678 },
	{ 0x76c2, 0x214e7c },
	{ 0x76c3, 0x21525a },
	{ 0x76c4, 0x222c41 },
	{ 0x76c5, 0x21525b },
	{ 0x76c6, 0x215259 },
	{ 0x76c7, 0x232e32 },
	{ 0x76c8, 0x215258 },
	{ 0x76c9, 0x22312f },
	{ 0x76ca, 0x215674 },
	{ 0x76cb, 0x23325a },
	{ 0x76cc, 0x23325b },
	{ 0x76cd, 0x215675 },
	{ 0x76ce, 0x215676 },
	{ 0x76d2, 0x215c35 },
	{ 0x76d3, 0x22374a },
	{ 0x76d4, 0x215c34 },
	{ 0x76d5, 0x233750 },
	{ 0x76d6, 0x233752 },
	{ 0x76d7, 0x233751 },
	{ 0x76d9, 0x233d4f },
	{ 0x76da, 0x223e3d },
	{ 0x76db, 0x215c36 },
	{ 0x76dc, 0x216079 },
	{ 0x76dd, 0x22453d },
	{ 0x76de, 0x216540 },
	{ 0x76df, 0x216541 },
	{ 0x76e1, 0x216970 },
	{ 0x76e2, 0x234831 },
	{ 0x76e3, 0x216971 },
	{ 0x76e4, 0x216d75 },
	{ 0x76e5, 0x21714e },
	{ 0x76e6, 0x225861 },
	{ 0x76e7, 0x21714d },
	{ 0x76e9, 0x225d65 },
	{ 0x76ea, 0x217445 },
	{ 0x76eb, 0x235835 },
	{ 0x76ec, 0x226240 },
	{ 0x76ed, 0x226942 },
	{ 0x76ee, 0x214678 },
	{ 0x76ef, 0x214b31 },
	{ 0x76f0, 0x22283a },
	{ 0x76f1, 0x222839 },
	{ 0x76f2, 0x214e7d },
	{ 0x76f3, 0x222838 },
	{ 0x76f4, 0x214e7e },
	{ 0x76f5, 0x22283b },
	{ 0x76f7, 0x222c47 },
	{ 0x76f8, 0x21525e },
	{ 0x76f9, 0x21525d },
	{ 0x76fa, 0x222c49 },
	{ 0x76fb, 0x222c48 },
	{ 0x76fc, 0x215262 },
	{ 0x76fd, 0x232e35 },
	{ 0x76fe, 0x215261 },
	{ 0x76ff, 0x232e33 },
	{ 0x7701, 0x21525c },
	{ 0x7703, 0x222c43 },
	{ 0x7704, 0x222c44 },
	{ 0x7705, 0x222c45 },
	{ 0x7706, 0x23626c },
	{ 0x7707, 0x215263 },
	{ 0x7708, 0x222c42 },
	{ 0x7709, 0x21525f },
	{ 0x770a, 0x222c46 },
	{ 0x770b, 0x215260 },
	{ 0x770e, 0x233264 },
	{ 0x770f, 0x23325f },
	{ 0x7710, 0x223132 },
	{ 0x7711, 0x223136 },
	{ 0x7712, 0x223134 },
	{ 0x7713, 0x223133 },
	{ 0x7715, 0x223137 },
	{ 0x7716, 0x23325e },
	{ 0x7718, 0x233268 },
	{ 0x7719, 0x223138 },
	{ 0x771a, 0x223139 },
	{ 0x771b, 0x223131 },
	{ 0x771d, 0x223130 },
	{ 0x771e, 0x233759 },
	{ 0x771f, 0x215678 },
	{ 0x7720, 0x215679 },
	{ 0x7721, 0x233267 },
	{ 0x7722, 0x22313a },
	{ 0x7723, 0x223135 },
	{ 0x7724, 0x233265 },
	{ 0x7725, 0x223753 },
	{ 0x7726, 0x233755 },
	{ 0x7727, 0x22313b },
	{ 0x7728, 0x21567a },
	{ 0x7729, 0x215677 },
	{ 0x772a, 0x23325c },
	{ 0x772b, 0x233263 },
	{ 0x772d, 0x22374d },
	{ 0x772f, 0x22374c },
	{ 0x7730, 0x233753 },
	{ 0x7731, 0x22374e },
	{ 0x7732, 0x22374f },
	{ 0x7733, 0x223751 },
	{ 0x7734, 0x223750 },
	{ 0x7735, 0x223755 },
	{ 0x7736, 0x215c3a },
	{ 0x7737, 0x215c37 },
	{ 0x7738, 0x215c3b },
	{ 0x7739, 0x22374b },
	{ 0x773a, 0x215c3c },
	{ 0x773b, 0x223754 },
	{ 0x773c, 0x215c39 },
	{ 0x773d, 0x223752 },
	{ 0x773e, 0x215c38 },
	{ 0x773f, 0x233262 },
	{ 0x7740, 0x233757 },
	{ 0x7742, 0x233d56 },
	{ 0x7743, 0x233d53 },
	{ 0x7744, 0x223e40 },
	{ 0x7745, 0x223e42 },
	{ 0x7746, 0x223e3e },
	{ 0x7747, 0x223e3f },
	{ 0x7748, 0x233d51 },
	{ 0x7749, 0x233d52 },
	{ 0x774a, 0x223e43 },
	{ 0x774b, 0x223e45 },
	{ 0x774c, 0x223e46 },
	{ 0x774d, 0x223e41 },
	{ 0x774e, 0x223e44 },
	{ 0x774f, 0x21607a },
	{ 0x7752, 0x224541 },
	{ 0x7753, 0x234327 },
	{ 0x7754, 0x224546 },
	{ 0x7755, 0x22453e },
	{ 0x7756, 0x224542 },
	{ 0x7758, 0x234328 },
	{ 0x7759, 0x224547 },
	{ 0x775a, 0x224543 },
	{ 0x775b, 0x216542 },
	{ 0x775c, 0x21654a },
	{ 0x775d, 0x234325 },
	{ 0x775e, 0x216545 },
	{ 0x775f, 0x22453f },
	{ 0x7760, 0x224540 },
	{ 0x7761, 0x216975 },
	{ 0x7762, 0x21654d },
	{ 0x7763, 0x216546 },
	{ 0x7764, 0x234326 },
	{ 0x7765, 0x21654b },
	{ 0x7766, 0x216544 },
	{ 0x7767, 0x224545 },
	{ 0x7768, 0x21654c },
	{ 0x7769, 0x224544 },
	{ 0x776a, 0x216548 },
	{ 0x776b, 0x216543 },
	{ 0x776c, 0x216549 },
	{ 0x776d, 0x224548 },
	{ 0x776e, 0x224c2e },
	{ 0x776f, 0x224c30 },
	{ 0x7771, 0x234839 },
	{ 0x7774, 0x234833 },
	{ 0x7775, 0x234836 },
	{ 0x7776, 0x234835 },
	{ 0x7777, 0x234834 },
	{ 0x7778, 0x234838 },
	{ 0x7779, 0x216547 },
	{ 0x777a, 0x23483b },
	{ 0x777b, 0x23483d },
	{ 0x777c, 0x224c2b },
	{ 0x777d, 0x216973 },
	{ 0x777e, 0x224c31 },
	{ 0x777f, 0x216974 },
	{ 0x7780, 0x224c2f },
	{ 0x7781, 0x224c2a },
	{ 0x7782, 0x224c2d },
	{ 0x7783, 0x224c32 },
	{ 0x7784, 0x216972 },
	{ 0x7785, 0x224c2c },
	{ 0x7787, 0x216d77 },
	{ 0x7788, 0x225247 },
	{ 0x7789, 0x225246 },
	{ 0x778a, 0x234d44 },
	{ 0x778b, 0x216d7a },
	{ 0x778c, 0x216d78 },
	{ 0x778d, 0x225244 },
	{ 0x778e, 0x216d76 },
	{ 0x778f, 0x225245 },
	{ 0x7790, 0x234d46 },
	{ 0x7791, 0x216d79 },
	{ 0x7795, 0x225869 },
	{ 0x7796, 0x23517b },
	{ 0x7797, 0x22586b },
	{ 0x7798, 0x235179 },
	{ 0x7799, 0x22586a },
	{ 0x779a, 0x225862 },
	{ 0x779b, 0x225866 },
	{ 0x779c, 0x225865 },
	{ 0x779d, 0x225863 },
	{ 0x779e, 0x217150 },
	{ 0x779f, 0x217151 },
	{ 0x77a0, 0x21714f },
	{ 0x77a1, 0x225864 },
	{ 0x77a2, 0x225867 },
	{ 0x77a3, 0x225868 },
	{ 0x77a4, 0x235559 },
	{ 0x77a5, 0x217152 },
	{ 0x77a6, 0x235558 },
	{ 0x77a7, 0x21744a },
	{ 0x77a8, 0x225d6d },
	{ 0x77a9, 0x23555b },
	{ 0x77aa, 0x217447 },
	{ 0x77ab, 0x225d67 },
	{ 0x77ac, 0x217449 },
	{ 0x77ad, 0x21744b },
	{ 0x77af, 0x23555c },
	{ 0x77b0, 0x217448 },
	{ 0x77b1, 0x225d6c },
	{ 0x77b2, 0x225d68 },
	{ 0x77b3, 0x217446 },
	{ 0x77b4, 0x225d6b },
	{ 0x77b5, 0x225d66 },
	{ 0x77b6, 0x225d6a },
	{ 0x77b7, 0x225d69 },
	{ 0x77b8, 0x235836 },
	{ 0x77b9, 0x235838 },
	{ 0x77ba, 0x226242 },
	{ 0x77bb, 0x21766e },
	{ 0x77bc, 0x21766f },
	{ 0x77bd, 0x21766c },
	{ 0x77be, 0x23583b },
	{ 0x77bf, 0x21766d },
	{ 0x77c0, 0x23583a },
	{ 0x77c1, 0x235839 },
	{ 0x77c2, 0x226241 },
	{ 0x77c4, 0x226627 },
	{ 0x77c5, 0x235a60 },
	{ 0x77c6, 0x235a5f },
	{ 0x77c7, 0x217854 },
	{ 0x77c9, 0x226625 },
	{ 0x77ca, 0x226626 },
	{ 0x77cc, 0x226943 },
	{ 0x77cd, 0x226946 },
	{ 0x77ce, 0x226944 },
	{ 0x77cf, 0x226945 },
	{ 0x77d0, 0x226b6e },
	{ 0x77d1, 0x235e42 },
	{ 0x77d3, 0x217a7a },
	{ 0x77d4, 0x226f3a },
	{ 0x77d5, 0x227042 },
	{ 0x77d6, 0x236432 },
	{ 0x77d7, 0x217c63 },
	{ 0x77d8, 0x227128 },
	{ 0x77d9, 0x227129 },
	{ 0x77da, 0x217d33 },
	{ 0x77db, 0x214679 },
	{ 0x77dc, 0x215264 },
	{ 0x77dd, 0x233269 },
	{ 0x77de, 0x223e47 },
	{ 0x77df, 0x233d57 },
	{ 0x77e0, 0x224549 },
	{ 0x77e2, 0x21467a },
	{ 0x77e3, 0x214b32 },
	{ 0x77e5, 0x214f21 },
	{ 0x77e6, 0x232e36 },
	{ 0x77e7, 0x222c4a },
	{ 0x77e8, 0x222c4b },
	{ 0x77e9, 0x21567b },
	{ 0x77ec, 0x223e48 },
	{ 0x77ed, 0x21607b },
	{ 0x77ee, 0x21654e },
	{ 0x77ef, 0x21744c },
	{ 0x77f0, 0x225d6e },
	{ 0x77f1, 0x226628 },
	{ 0x77f2, 0x226947 },
	{ 0x77f3, 0x21467b },
	{ 0x77f4, 0x23267b },
	{ 0x77f5, 0x23267c },
	{ 0x77f7, 0x222841 },
	{ 0x77f8, 0x22283c },
	{ 0x77f9, 0x22283e },
	{ 0x77fa, 0x222840 },
	{ 0x77fb, 0x22283f },
	{ 0x77fc, 0x22283d },
	{ 0x77fd, 0x214f22 },
	{ 0x7802, 0x215265 },
	{ 0x7803, 0x222c54 },
	{ 0x7804, 0x232e39 },
	{ 0x7805, 0x222c4f },
	{ 0x7806, 0x222c4c },
	{ 0x7807, 0x232e3b },
	{ 0x7808, 0x232e3e },
	{ 0x7809, 0x222c53 },
	{ 0x780a, 0x232e37 },
	{ 0x780b, 0x232e3a },
	{ 0x780c, 0x215267 },
	{ 0x780d, 0x215268 },
	{ 0x780e, 0x222c52 },
	{ 0x780f, 0x222c51 },
	{ 0x7810, 0x222c50 },
	{ 0x7811, 0x222c4d },
	{ 0x7812, 0x222c4e },
	{ 0x7813, 0x222c55 },
	{ 0x7814, 0x215266 },
	{ 0x7815, 0x232e3d },
	{ 0x7819, 0x23656d },
	{ 0x781b, 0x23656e },
	{ 0x781d, 0x215721 },
	{ 0x781e, 0x23667c },
	{ 0x781f, 0x215727 },
	{ 0x7820, 0x215726 },
	{ 0x7821, 0x223144 },
	{ 0x7822, 0x22313e },
	{ 0x7823, 0x22313c },
	{ 0x7824, 0x23326c },
	{ 0x7825, 0x215724 },
	{ 0x7826, 0x22375c },
	{ 0x7827, 0x21567d },
	{ 0x7828, 0x223141 },
	{ 0x7829, 0x223145 },
	{ 0x782a, 0x223147 },
	{ 0x782b, 0x223143 },
	{ 0x782c, 0x22313d },
	{ 0x782d, 0x215725 },
	{ 0x782e, 0x223142 },
	{ 0x782f, 0x223140 },
	{ 0x7830, 0x21567c },
	{ 0x7831, 0x223148 },
	{ 0x7832, 0x215728 },
	{ 0x7833, 0x223146 },
	{ 0x7834, 0x215722 },
	{ 0x7835, 0x22313f },
	{ 0x7836, 0x23326d },
	{ 0x7837, 0x215723 },
	{ 0x7838, 0x21567e },
	{ 0x783d, 0x23656f },
	{ 0x7842, 0x233762 },
	{ 0x7843, 0x215c3e },
	{ 0x7845, 0x22375d },
	{ 0x7846, 0x233763 },
	{ 0x7847, 0x23375d },
	{ 0x7848, 0x223756 },
	{ 0x7849, 0x223758 },
	{ 0x784a, 0x22375a },
	{ 0x784b, 0x23375f },
	{ 0x784c, 0x22375b },
	{ 0x784d, 0x223759 },
	{ 0x784e, 0x215c3f },
	{ 0x784f, 0x233761 },
	{ 0x7850, 0x22375e },
	{ 0x7851, 0x233760 },
	{ 0x7852, 0x223757 },
	{ 0x7853, 0x236570 },
	{ 0x7854, 0x236571 },
	{ 0x7858, 0x236572 },
	{ 0x785c, 0x223e4c },
	{ 0x785d, 0x21607c },
	{ 0x785e, 0x223e54 },
	{ 0x785f, 0x233d5c },
	{ 0x7860, 0x223e49 },
	{ 0x7862, 0x223e55 },
	{ 0x7863, 0x233d59 },
	{ 0x7864, 0x223e4a },
	{ 0x7865, 0x223e4b },
	{ 0x7866, 0x233d5d },
	{ 0x7868, 0x223e53 },
	{ 0x7869, 0x223e52 },
	{ 0x786a, 0x223e4f },
	{ 0x786b, 0x215c3d },
	{ 0x786c, 0x21607d },
	{ 0x786d, 0x223e4d },
	{ 0x786e, 0x223e50 },
	{ 0x786f, 0x21607e },
	{ 0x7870, 0x223e51 },
	{ 0x7871, 0x223e4e },
	{ 0x7876, 0x233d5a },
	{ 0x7878, 0x234331 },
	{ 0x7879, 0x224554 },
	{ 0x787a, 0x23432d },
	{ 0x787b, 0x224558 },
	{ 0x787c, 0x216555 },
	{ 0x787d, 0x23432e },
	{ 0x787e, 0x224c38 },
	{ 0x787f, 0x216558 },
	{ 0x7880, 0x224556 },
	{ 0x7881, 0x234337 },
	{ 0x7882, 0x234329 },
	{ 0x7883, 0x224553 },
	{ 0x7884, 0x22454e },
	{ 0x7885, 0x224550 },
	{ 0x7886, 0x224551 },
	{ 0x7887, 0x22454a },
	{ 0x7888, 0x234335 },
	{ 0x7889, 0x216554 },
	{ 0x788a, 0x23432b },
	{ 0x788b, 0x234330 },
	{ 0x788c, 0x216553 },
	{ 0x788d, 0x234334 },
	{ 0x788e, 0x21654f },
	{ 0x788f, 0x22454d },
	{ 0x7890, 0x23432a },
	{ 0x7891, 0x216556 },
	{ 0x7892, 0x234336 },
	{ 0x7893, 0x216557 },
	{ 0x7894, 0x22454c },
	{ 0x7895, 0x22454f },
	{ 0x7896, 0x224557 },
	{ 0x7897, 0x216551 },
	{ 0x7898, 0x216552 },
	{ 0x7899, 0x224555 },
	{ 0x789a, 0x22454b },
	{ 0x789e, 0x224c3a },
	{ 0x789f, 0x216977 },
	{ 0x78a0, 0x224c3c },
	{ 0x78a1, 0x224552 },
	{ 0x78a2, 0x224c3e },
	{ 0x78a3, 0x21697b },
	{ 0x78a4, 0x224c3f },
	{ 0x78a5, 0x224c3b },
	{ 0x78a6, 0x23483e },
	{ 0x78a7, 0x216978 },
	{ 0x78a8, 0x224c37 },
	{ 0x78a9, 0x21697a },
	{ 0x78aa, 0x224c34 },
	{ 0x78ab, 0x224c39 },
	{ 0x78ac, 0x224c3d },
	{ 0x78ad, 0x224c36 },
	{ 0x78ae, 0x23483f },
	{ 0x78af, 0x234845 },
	{ 0x78b0, 0x216550 },
	{ 0x78b1, 0x234844 },
	{ 0x78b2, 0x224c33 },
	{ 0x78b3, 0x216979 },
	{ 0x78b4, 0x224c35 },
	{ 0x78b7, 0x236573 },
	{ 0x78b8, 0x234840 },
	{ 0x78ba, 0x216d7d },
	{ 0x78bb, 0x225249 },
	{ 0x78bc, 0x216e23 },
	{ 0x78be, 0x216e21 },
	{ 0x78c0, 0x234d4a },
	{ 0x78c1, 0x216976 },
	{ 0x78c2, 0x234d4d },
	{ 0x78c3, 0x225250 },
	{ 0x78c4, 0x225251 },
	{ 0x78c5, 0x216d7c },
	{ 0x78c6, 0x234d48 },
	{ 0x78c7, 0x234d4c },
	{ 0x78c8, 0x22524f },
	{ 0x78c9, 0x225252 },
	{ 0x78ca, 0x216d7e },
	{ 0x78cb, 0x216d7b },
	{ 0x78cc, 0x22524b },
	{ 0x78cd, 0x225248 },
	{ 0x78ce, 0x22524d },
	{ 0x78cf, 0x22524a },
	{ 0x78d0, 0x216e24 },
	{ 0x78d1, 0x22524c },
	{ 0x78d2, 0x234d4b },
	{ 0x78d3, 0x234d49 },
	{ 0x78d4, 0x22524e },
	{ 0x78d5, 0x216e22 },
	{ 0x78d6, 0x235221 },
	{ 0x78d8, 0x236574 },
	{ 0x78da, 0x217154 },
	{ 0x78db, 0x225872 },
	{ 0x78dc, 0x235224 },
	{ 0x78dd, 0x22586c },
	{ 0x78de, 0x225870 },
	{ 0x78df, 0x225876 },
	{ 0x78e0, 0x225877 },
	{ 0x78e1, 0x225873 },
	{ 0x78e2, 0x225874 },
	{ 0x78e3, 0x225871 },
	{ 0x78e5, 0x22586e },
	{ 0x78e7, 0x217156 },
	{ 0x78e8, 0x217153 },
	{ 0x78e9, 0x22586d },
	{ 0x78ea, 0x22586f },
	{ 0x78eb, 0x235222 },
	{ 0x78ec, 0x217155 },
	{ 0x78ed, 0x225875 },
	{ 0x78ee, 0x236575 },
	{ 0x78ef, 0x217450 },
	{ 0x78f0, 0x235560 },
	{ 0x78f1, 0x235562 },
	{ 0x78f2, 0x225d75 },
	{ 0x78f3, 0x225d6f },
	{ 0x78f4, 0x21744f },
	{ 0x78f7, 0x21744d },
	{ 0x78f8, 0x235561 },
	{ 0x78f9, 0x225d77 },
	{ 0x78fa, 0x21744e },
	{ 0x78fb, 0x225d72 },
	{ 0x78fc, 0x225d73 },
	{ 0x78fd, 0x225d70 },
	{ 0x78fe, 0x225d78 },
	{ 0x78ff, 0x225d74 },
	{ 0x7901, 0x217451 },
	{ 0x7902, 0x225d71 },
	{ 0x7904, 0x225d79 },
	{ 0x7905, 0x225d76 },
	{ 0x7906, 0x235843 },
	{ 0x7907, 0x23583e },
	{ 0x7908, 0x235840 },
	{ 0x7909, 0x226246 },
	{ 0x790a, 0x23583f },
	{ 0x790b, 0x23583c },
	{ 0x790c, 0x226243 },
	{ 0x790d, 0x235842 },
	{ 0x790e, 0x217670 },
	{ 0x7910, 0x226247 },
	{ 0x7911, 0x226249 },
	{ 0x7912, 0x226248 },
	{ 0x7913, 0x226244 },
	{ 0x7914, 0x226245 },
	{ 0x7915, 0x235844 },
	{ 0x7917, 0x22662d },
	{ 0x7918, 0x235a61 },
	{ 0x7919, 0x217855 },
	{ 0x791a, 0x235a62 },
	{ 0x791b, 0x22662a },
	{ 0x791c, 0x22662c },
	{ 0x791d, 0x226629 },
	{ 0x791e, 0x22662e },
	{ 0x7920, 0x235a63 },
	{ 0x7921, 0x22662b },
	{ 0x7922, 0x236576 },
	{ 0x7923, 0x226949 },
	{ 0x7924, 0x22694c },
	{ 0x7925, 0x226948 },
	{ 0x7926, 0x21797c },
	{ 0x7927, 0x22694a },
	{ 0x7928, 0x22694b },
	{ 0x7929, 0x22694d },
	{ 0x792a, 0x21797d },
	{ 0x792b, 0x217a21 },
	{ 0x792c, 0x21797e },
	{ 0x792d, 0x226b6f },
	{ 0x792e, 0x235e45 },
	{ 0x792f, 0x226b71 },
	{ 0x7930, 0x235e43 },
	{ 0x7931, 0x226b70 },
	{ 0x7932, 0x235e44 },
	{ 0x7935, 0x226d64 },
	{ 0x7937, 0x23603c },
	{ 0x7938, 0x227043 },
	{ 0x7939, 0x22712a },
	{ 0x793a, 0x21467c },
	{ 0x793c, 0x232433 },
	{ 0x793d, 0x222472 },
	{ 0x793e, 0x214f23 },
	{ 0x793f, 0x222843 },
	{ 0x7940, 0x214f24 },
	{ 0x7941, 0x214f25 },
	{ 0x7942, 0x222842 },
	{ 0x7944, 0x222c5a },
	{ 0x7945, 0x222c59 },
	{ 0x7946, 0x215269 },
	{ 0x7947, 0x21526c },
	{ 0x7948, 0x21526b },
	{ 0x7949, 0x21526a },
	{ 0x794a, 0x222c56 },
	{ 0x794b, 0x222c58 },
	{ 0x794c, 0x222c57 },
	{ 0x794d, 0x236577 },
	{ 0x794f, 0x22314b },
	{ 0x7950, 0x21572a },
	{ 0x7951, 0x22314f },
	{ 0x7952, 0x22314e },
	{ 0x7953, 0x22314d },
	{ 0x7954, 0x223149 },
	{ 0x7955, 0x215729 },
	{ 0x7956, 0x21572d },
	{ 0x7957, 0x215730 },
	{ 0x7958, 0x23326f },
	{ 0x7959, 0x233270 },
	{ 0x795a, 0x215731 },
	{ 0x795b, 0x22314a },
	{ 0x795c, 0x22314c },
	{ 0x795d, 0x21572f },
	{ 0x795e, 0x21572e },
	{ 0x795f, 0x21572c },
	{ 0x7960, 0x21572b },
	{ 0x7961, 0x223765 },
	{ 0x7962, 0x233272 },
	{ 0x7963, 0x223763 },
	{ 0x7964, 0x22375f },
	{ 0x7965, 0x215c40 },
	{ 0x7966, 0x233d5e },
	{ 0x7967, 0x223760 },
	{ 0x7968, 0x215c41 },
	{ 0x7969, 0x223761 },
	{ 0x796a, 0x223762 },
	{ 0x796b, 0x223764 },
	{ 0x796c, 0x233766 },
	{ 0x796d, 0x215c42 },
	{ 0x796e, 0x233765 },
	{ 0x7970, 0x223e59 },
	{ 0x7971, 0x233d5f },
	{ 0x7972, 0x223e58 },
	{ 0x7973, 0x223e57 },
	{ 0x7974, 0x223e56 },
	{ 0x7975, 0x233d64 },
	{ 0x7976, 0x233d62 },
	{ 0x7979, 0x22455c },
	{ 0x797a, 0x216559 },
	{ 0x797c, 0x224559 },
	{ 0x797d, 0x22455b },
	{ 0x797e, 0x234338 },
	{ 0x797f, 0x21655a },
	{ 0x7980, 0x23433d },
	{ 0x7981, 0x21655b },
	{ 0x7982, 0x22455a },
	{ 0x7983, 0x234339 },
	{ 0x7984, 0x233d63 },
	{ 0x7986, 0x236578 },
	{ 0x7987, 0x234848 },
	{ 0x7988, 0x224c48 },
	{ 0x7989, 0x234847 },
	{ 0x798a, 0x224c41 },
	{ 0x798b, 0x224c42 },
	{ 0x798d, 0x21697e },
	{ 0x798e, 0x21697c },
	{ 0x798f, 0x21697d },
	{ 0x7990, 0x224c4a },
	{ 0x7992, 0x224c49 },
	{ 0x7993, 0x224c46 },
	{ 0x7994, 0x224c45 },
	{ 0x7995, 0x224c44 },
	{ 0x7996, 0x224c43 },
	{ 0x7997, 0x224c47 },
	{ 0x7998, 0x224c40 },
	{ 0x7999, 0x236579 },
	{ 0x799a, 0x225253 },
	{ 0x799b, 0x225258 },
	{ 0x799c, 0x225256 },
	{ 0x799d, 0x234d50 },
	{ 0x799e, 0x234d51 },
	{ 0x799f, 0x234d4f },
	{ 0x79a0, 0x225255 },
	{ 0x79a1, 0x225254 },
	{ 0x79a2, 0x225257 },
	{ 0x79a3, 0x23657a },
	{ 0x79a4, 0x225878 },
	{ 0x79a5, 0x235226 },
	{ 0x79a6, 0x217157 },
	{ 0x79a7, 0x217452 },
	{ 0x79a8, 0x225d7b },
	{ 0x79a9, 0x235227 },
	{ 0x79aa, 0x217453 },
	{ 0x79ab, 0x225d7a },
	{ 0x79ac, 0x22624b },
	{ 0x79ad, 0x22624a },
	{ 0x79ae, 0x217671 },
	{ 0x79af, 0x235845 },
	{ 0x79b0, 0x22662f },
	{ 0x79b1, 0x217856 },
	{ 0x79b2, 0x22694e },
	{ 0x79b3, 0x217b6b },
	{ 0x79b4, 0x226d65 },
	{ 0x79b5, 0x23603d },
	{ 0x79b6, 0x227045 },
	{ 0x79b7, 0x227044 },
	{ 0x79b8, 0x222167 },
	{ 0x79b9, 0x21526d },
	{ 0x79ba, 0x21526e },
	{ 0x79bb, 0x223766 },
	{ 0x79bc, 0x23657b },
	{ 0x79bd, 0x21655d },
	{ 0x79be, 0x21467d },
	{ 0x79bf, 0x214b35 },
	{ 0x79c0, 0x214b34 },
	{ 0x79c1, 0x214b33 },
	{ 0x79c3, 0x232a3e },
	{ 0x79c4, 0x232a3d },
	{ 0x79c5, 0x222844 },
	{ 0x79c6, 0x232a3f },
	{ 0x79c7, 0x232a42 },
	{ 0x79c8, 0x214f27 },
	{ 0x79c9, 0x214f26 },
	{ 0x79ca, 0x232a44 },
	{ 0x79cb, 0x215271 },
	{ 0x79cc, 0x23654c },
	{ 0x79cd, 0x222c5c },
	{ 0x79ce, 0x222c5f },
	{ 0x79cf, 0x222c5d },
	{ 0x79d0, 0x232e42 },
	{ 0x79d1, 0x21526f },
	{ 0x79d2, 0x215270 },
	{ 0x79d3, 0x232e40 },
	{ 0x79d4, 0x232e41 },
	{ 0x79d5, 0x222c5b },
	{ 0x79d6, 0x222c5e },
	{ 0x79d7, 0x232e43 },
	{ 0x79d8, 0x215738 },
	{ 0x79d9, 0x233274 },
	{ 0x79da, 0x233273 },
	{ 0x79db, 0x233279 },
	{ 0x79dc, 0x223156 },
	{ 0x79dd, 0x223158 },
	{ 0x79de, 0x223157 },
	{ 0x79df, 0x215735 },
	{ 0x79e0, 0x223152 },
	{ 0x79e1, 0x233276 },
	{ 0x79e2, 0x23327b },
	{ 0x79e3, 0x215733 },
	{ 0x79e4, 0x215732 },
	{ 0x79e5, 0x233277 },
	{ 0x79e6, 0x215736 },
	{ 0x79e7, 0x215734 },
	{ 0x79e8, 0x233278 },
	{ 0x79e9, 0x215737 },
	{ 0x79ea, 0x223155 },
	{ 0x79eb, 0x223150 },
	{ 0x79ec, 0x223151 },
	{ 0x79ed, 0x223154 },
	{ 0x79ee, 0x223153 },
	{ 0x79f0, 0x23327c },
	{ 0x79f1, 0x233769 },
	{ 0x79f2, 0x233767 },
	{ 0x79f3, 0x23376b },
	{ 0x79f5, 0x23376a },
	{ 0x79f6, 0x223769 },
	{ 0x79f7, 0x22376a },
	{ 0x79f8, 0x223768 },
	{ 0x79f9, 0x23376c },
	{ 0x79fa, 0x223767 },
	{ 0x79fb, 0x215c43 },
	{ 0x79ff, 0x233d65 },
	{ 0x7a00, 0x216125 },
	{ 0x7a02, 0x223e5a },
	{ 0x7a03, 0x223e5c },
	{ 0x7a04, 0x223e5e },
	{ 0x7a05, 0x216124 },
	{ 0x7a07, 0x233d66 },
	{ 0x7a08, 0x216122 },
	{ 0x7a09, 0x233d69 },
	{ 0x7a0a, 0x223e5b },
	{ 0x7a0b, 0x216123 },
	{ 0x7a0c, 0x223e5d },
	{ 0x7a0d, 0x216121 },
	{ 0x7a0e, 0x233d68 },
	{ 0x7a0f, 0x234341 },
	{ 0x7a10, 0x224566 },
	{ 0x7a11, 0x22455d },
	{ 0x7a12, 0x224560 },
	{ 0x7a13, 0x224564 },
	{ 0x7a14, 0x216561 },
	{ 0x7a15, 0x224562 },
	{ 0x7a17, 0x224561 },
	{ 0x7a18, 0x22455e },
	{ 0x7a19, 0x22455f },
	{ 0x7a1a, 0x21655f },
	{ 0x7a1b, 0x224565 },
	{ 0x7a1c, 0x21655e },
	{ 0x7a1d, 0x234344 },
	{ 0x7a1e, 0x216563 },
	{ 0x7a1f, 0x216562 },
	{ 0x7a20, 0x216560 },
	{ 0x7a22, 0x224563 },
	{ 0x7a25, 0x236524 },
	{ 0x7a26, 0x224c50 },
	{ 0x7a28, 0x224c4f },
	{ 0x7a29, 0x23484b },
	{ 0x7a2a, 0x23484d },
	{ 0x7a2b, 0x224c4b },
	{ 0x7a2c, 0x234850 },
	{ 0x7a2d, 0x23484f },
	{ 0x7a2e, 0x216a21 },
	{ 0x7a2f, 0x224c4e },
	{ 0x7a30, 0x224c4d },
	{ 0x7a31, 0x216a22 },
	{ 0x7a32, 0x234852 },
	{ 0x7a37, 0x216e29 },
	{ 0x7a38, 0x234d55 },
	{ 0x7a39, 0x22525a },
	{ 0x7a3a, 0x234d56 },
	{ 0x7a3b, 0x216e2a },
	{ 0x7a3c, 0x216e26 },
	{ 0x7a3d, 0x216e28 },
	{ 0x7a3e, 0x234d5a },
	{ 0x7a3f, 0x216e25 },
	{ 0x7a40, 0x216e27 },
	{ 0x7a41, 0x234d53 },
	{ 0x7a42, 0x234d57 },
	{ 0x7a44, 0x225879 },
	{ 0x7a45, 0x23522a },
	{ 0x7a46, 0x21715a },
	{ 0x7a47, 0x22587b },
	{ 0x7a48, 0x22587a },
	{ 0x7a49, 0x235564 },
	{ 0x7a4a, 0x224c4c },
	{ 0x7a4b, 0x21715c },
	{ 0x7a4c, 0x21715b },
	{ 0x7a4d, 0x217158 },
	{ 0x7a4e, 0x217159 },
	{ 0x7a4f, 0x23522c },
	{ 0x7a53, 0x235229 },
	{ 0x7a54, 0x225e22 },
	{ 0x7a56, 0x225d7e },
	{ 0x7a57, 0x217454 },
	{ 0x7a58, 0x225e21 },
	{ 0x7a5a, 0x225e23 },
	{ 0x7a5b, 0x225d7d },
	{ 0x7a5c, 0x225d7c },
	{ 0x7a5f, 0x22624c },
	{ 0x7a60, 0x217674 },
	{ 0x7a61, 0x217672 },
	{ 0x7a62, 0x217673 },
	{ 0x7a64, 0x235a66 },
	{ 0x7a66, 0x235a65 },
	{ 0x7a67, 0x226630 },
	{ 0x7a68, 0x226631 },
	{ 0x7a69, 0x217858 },
	{ 0x7a6a, 0x235a67 },
	{ 0x7a6b, 0x217857 },
	{ 0x7a6c, 0x226950 },
	{ 0x7a6d, 0x226951 },
	{ 0x7a6e, 0x22694f },
	{ 0x7a6f, 0x235c64 },
	{ 0x7a70, 0x226d66 },
	{ 0x7a71, 0x226d67 },
	{ 0x7a72, 0x236076 },
	{ 0x7a73, 0x236077 },
	{ 0x7a74, 0x21467e },
	{ 0x7a75, 0x222268 },
	{ 0x7a76, 0x214b36 },
	{ 0x7a78, 0x222845 },
	{ 0x7a79, 0x214f29 },
	{ 0x7a7a, 0x214f28 },
	{ 0x7a7b, 0x222846 },
	{ 0x7a7c, 0x232e44 },
	{ 0x7a7d, 0x232e47 },
	{ 0x7a7e, 0x222c61 },
	{ 0x7a7f, 0x215272 },
	{ 0x7a80, 0x222c60 },
	{ 0x7a81, 0x215273 },
	{ 0x7a82, 0x232e49 },
	{ 0x7a83, 0x232e48 },
	{ 0x7a84, 0x215739 },
	{ 0x7a85, 0x22315b },
	{ 0x7a86, 0x223159 },
	{ 0x7a87, 0x22315f },
	{ 0x7a88, 0x21573a },
	{ 0x7a89, 0x22315a },
	{ 0x7a8a, 0x22315e },
	{ 0x7a8b, 0x22315c },
	{ 0x7a8c, 0x22315d },
	{ 0x7a8f, 0x22376b },
	{ 0x7a90, 0x22376d },
	{ 0x7a91, 0x233772 },
	{ 0x7a92, 0x215c44 },
	{ 0x7a93, 0x233771 },
	{ 0x7a94, 0x22376c },
	{ 0x7a95, 0x215c45 },
	{ 0x7a96, 0x216128 },
	{ 0x7a97, 0x216127 },
	{ 0x7a98, 0x216126 },
	{ 0x7a99, 0x223e5f },
	{ 0x7a9a, 0x233770 },
	{ 0x7a9e, 0x224569 },
	{ 0x7a9f, 0x216564 },
	{ 0x7aa0, 0x216565 },
	{ 0x7aa1, 0x234346 },
	{ 0x7aa2, 0x224568 },
	{ 0x7aa3, 0x224567 },
	{ 0x7aa4, 0x234347 },
	{ 0x7aa7, 0x23657c },
	{ 0x7aa8, 0x224c51 },
	{ 0x7aa9, 0x216a24 },
	{ 0x7aaa, 0x216a23 },
	{ 0x7aab, 0x224c52 },
	{ 0x7aac, 0x224c53 },
	{ 0x7aae, 0x216e2c },
	{ 0x7aaf, 0x216e2b },
	{ 0x7ab0, 0x234d5b },
	{ 0x7ab1, 0x225921 },
	{ 0x7ab2, 0x22525b },
	{ 0x7ab3, 0x22525d },
	{ 0x7ab4, 0x22525c },
	{ 0x7ab5, 0x22587e },
	{ 0x7ab6, 0x22587c },
	{ 0x7ab7, 0x225922 },
	{ 0x7ab8, 0x22587d },
	{ 0x7aba, 0x21715d },
	{ 0x7abb, 0x23522f },
	{ 0x7abd, 0x23522e },
	{ 0x7abe, 0x225e24 },
	{ 0x7abf, 0x217455 },
	{ 0x7ac0, 0x225e25 },
	{ 0x7ac1, 0x225e26 },
	{ 0x7ac2, 0x235568 },
	{ 0x7ac4, 0x217675 },
	{ 0x7ac5, 0x217676 },
	{ 0x7ac7, 0x217a22 },
	{ 0x7ac8, 0x235e49 },
	{ 0x7ac9, 0x235e48 },
	{ 0x7aca, 0x217c3d },
	{ 0x7acb, 0x214721 },
	{ 0x7acc, 0x23267e },
	{ 0x7acd, 0x232721 },
	{ 0x7acf, 0x232a47 },
	{ 0x7ad0, 0x232e4e },
	{ 0x7ad1, 0x222c62 },
	{ 0x7ad2, 0x232e4f },
	{ 0x7ad3, 0x232e4d },
	{ 0x7ad4, 0x232e4b },
	{ 0x7ad5, 0x232e4c },
	{ 0x7ad8, 0x223160 },
	{ 0x7ad9, 0x21573b },
	{ 0x7ada, 0x233323 },
	{ 0x7adb, 0x233326 },
	{ 0x7adc, 0x233327 },
	{ 0x7add, 0x233324 },
	{ 0x7adf, 0x215d7e },
	{ 0x7ae0, 0x215d7d },
	{ 0x7ae1, 0x233773 },
	{ 0x7ae2, 0x233d71 },
	{ 0x7ae3, 0x21612a },
	{ 0x7ae4, 0x223e61 },
	{ 0x7ae5, 0x216129 },
	{ 0x7ae6, 0x223e60 },
	{ 0x7ae7, 0x233d70 },
	{ 0x7ae9, 0x234349 },
	{ 0x7aea, 0x23434a },
	{ 0x7aeb, 0x22456a },
	{ 0x7aec, 0x234854 },
	{ 0x7aed, 0x216a25 },
	{ 0x7aee, 0x224c54 },
	{ 0x7aef, 0x216a26 },
	{ 0x7af0, 0x234855 },
	{ 0x7af1, 0x235230 },
	{ 0x7af2, 0x235569 },
	{ 0x7af3, 0x23556a },
	{ 0x7af5, 0x235849 },
	{ 0x7af6, 0x217a23 },
	{ 0x7af7, 0x226952 },
	{ 0x7af8, 0x235f55 },
	{ 0x7af9, 0x21484c },
	{ 0x7afa, 0x214f2a },
	{ 0x7afb, 0x222847 },
	{ 0x7afc, 0x232e51 },
	{ 0x7afd, 0x215275 },
	{ 0x7afe, 0x232e50 },
	{ 0x7aff, 0x215274 },
	{ 0x7b00, 0x222c63 },
	{ 0x7b01, 0x222c64 },
	{ 0x7b04, 0x223162 },
	{ 0x7b05, 0x223164 },
	{ 0x7b06, 0x21573c },
	{ 0x7b08, 0x223166 },
	{ 0x7b09, 0x223169 },
	{ 0x7b0a, 0x223167 },
	{ 0x7b0b, 0x23332b },
	{ 0x7b0d, 0x23332a },
	{ 0x7b0e, 0x223168 },
	{ 0x7b0f, 0x223165 },
	{ 0x7b10, 0x223161 },
	{ 0x7b11, 0x21573d },
	{ 0x7b12, 0x22316a },
	{ 0x7b13, 0x223163 },
	{ 0x7b14, 0x23332c },
	{ 0x7b16, 0x233778 },
	{ 0x7b17, 0x233779 },
	{ 0x7b18, 0x223776 },
	{ 0x7b19, 0x215c4b },
	{ 0x7b1a, 0x223821 },
	{ 0x7b1b, 0x215c48 },
	{ 0x7b1c, 0x233777 },
	{ 0x7b1d, 0x223778 },
	{ 0x7b1e, 0x215c4c },
	{ 0x7b1f, 0x23377b },
	{ 0x7b20, 0x215c46 },
	{ 0x7b21, 0x233776 },
	{ 0x7b22, 0x223773 },
	{ 0x7b23, 0x223822 },
	{ 0x7b24, 0x223774 },
	{ 0x7b25, 0x223771 },
	{ 0x7b26, 0x215c4a },
	{ 0x7b28, 0x215c47 },
	{ 0x7b29, 0x23632d },
	{ 0x7b2a, 0x223777 },
	{ 0x7b2b, 0x22377a },
	{ 0x7b2c, 0x215c49 },
	{ 0x7b2d, 0x22377b },
	{ 0x7b2e, 0x215c4d },
	{ 0x7b2f, 0x22377c },
	{ 0x7b30, 0x223772 },
	{ 0x7b31, 0x223779 },
	{ 0x7b32, 0x22377d },
	{ 0x7b33, 0x223775 },
	{ 0x7b34, 0x223770 },
	{ 0x7b35, 0x22376e },
	{ 0x7b36, 0x23377a },
	{ 0x7b37, 0x23657d },
	{ 0x7b38, 0x22377e },
	{ 0x7b3b, 0x22376f },
	{ 0x7b40, 0x223e68 },
	{ 0x7b41, 0x233d7b },
	{ 0x7b42, 0x233d78 },
	{ 0x7b43, 0x233d75 },
	{ 0x7b44, 0x223e64 },
	{ 0x7b45, 0x223e6a },
	{ 0x7b46, 0x21612d },
	{ 0x7b47, 0x223e63 },
	{ 0x7b48, 0x223e65 },
	{ 0x7b49, 0x21612b },
	{ 0x7b4a, 0x223e62 },
	{ 0x7b4b, 0x216132 },
	{ 0x7b4c, 0x223e66 },
	{ 0x7b4d, 0x216131 },
	{ 0x7b4e, 0x223e67 },
	{ 0x7b4f, 0x216133 },
	{ 0x7b50, 0x21612e },
	{ 0x7b51, 0x216134 },
	{ 0x7b52, 0x21612f },
	{ 0x7b53, 0x233d79 },
	{ 0x7b54, 0x216130 },
	{ 0x7b55, 0x233d72 },
	{ 0x7b56, 0x21612c },
	{ 0x7b57, 0x233d76 },
	{ 0x7b58, 0x223e69 },
	{ 0x7b59, 0x23657e },
	{ 0x7b5e, 0x23434f },
	{ 0x7b60, 0x216568 },
	{ 0x7b61, 0x224575 },
	{ 0x7b62, 0x23434c },
	{ 0x7b63, 0x224578 },
	{ 0x7b64, 0x22456c },
	{ 0x7b65, 0x224571 },
	{ 0x7b66, 0x22456b },
	{ 0x7b67, 0x21656a },
	{ 0x7b68, 0x234355 },
	{ 0x7b69, 0x22456f },
	{ 0x7b6b, 0x23434d },
	{ 0x7b6c, 0x233d77 },
	{ 0x7b6d, 0x22456d },
	{ 0x7b6e, 0x216569 },
	{ 0x7b6f, 0x234354 },
	{ 0x7b70, 0x224574 },
	{ 0x7b71, 0x224573 },
	{ 0x7b72, 0x224570 },
	{ 0x7b73, 0x224572 },
	{ 0x7b74, 0x22456e },
	{ 0x7b75, 0x216a2a },
	{ 0x7b76, 0x224577 },
	{ 0x7b77, 0x216566 },
	{ 0x7b78, 0x224576 },
	{ 0x7b79, 0x234351 },
	{ 0x7b81, 0x234856 },
	{ 0x7b82, 0x224c64 },
	{ 0x7b83, 0x234858 },
	{ 0x7b84, 0x216a31 },
	{ 0x7b85, 0x224c5f },
	{ 0x7b86, 0x234860 },
	{ 0x7b87, 0x216a30 },
	{ 0x7b88, 0x224c55 },
	{ 0x7b8a, 0x224c57 },
	{ 0x7b8b, 0x216a29 },
	{ 0x7b8c, 0x224c5c },
	{ 0x7b8d, 0x224c5b },
	{ 0x7b8e, 0x224c5e },
	{ 0x7b8f, 0x216a2e },
	{ 0x7b90, 0x224c59 },
	{ 0x7b91, 0x224c58 },
	{ 0x7b92, 0x23485a },
	{ 0x7b93, 0x23485e },
	{ 0x7b94, 0x216a2d },
	{ 0x7b95, 0x216a28 },
	{ 0x7b96, 0x224c5a },
	{ 0x7b97, 0x216a2b },
	{ 0x7b98, 0x224c60 },
	{ 0x7b99, 0x224c62 },
	{ 0x7b9b, 0x224c5d },
	{ 0x7b9c, 0x224c56 },
	{ 0x7b9d, 0x216a2c },
	{ 0x7b9e, 0x234857 },
	{ 0x7b9f, 0x23485d },
	{ 0x7ba0, 0x216e34 },
	{ 0x7ba1, 0x216a27 },
	{ 0x7ba3, 0x23485c },
	{ 0x7ba4, 0x224c63 },
	{ 0x7bac, 0x225261 },
	{ 0x7bad, 0x216e2d },
	{ 0x7bae, 0x234d5c },
	{ 0x7baf, 0x225263 },
	{ 0x7bb1, 0x216e2e },
	{ 0x7bb2, 0x234d65 },
	{ 0x7bb3, 0x234d5d },
	{ 0x7bb4, 0x216e30 },
	{ 0x7bb5, 0x225266 },
	{ 0x7bb7, 0x22525e },
	{ 0x7bb8, 0x216a2f },
	{ 0x7bb9, 0x225264 },
	{ 0x7bbe, 0x225260 },
	{ 0x7bbf, 0x234d60 },
	{ 0x7bc0, 0x216567 },
	{ 0x7bc1, 0x216e33 },
	{ 0x7bc2, 0x236367 },
	{ 0x7bc3, 0x236366 },
	{ 0x7bc4, 0x216e2f },
	{ 0x7bc6, 0x216e31 },
	{ 0x7bc7, 0x216e32 },
	{ 0x7bc9, 0x217160 },
	{ 0x7bca, 0x225265 },
	{ 0x7bcb, 0x22525f },
	{ 0x7bcc, 0x216e35 },
	{ 0x7bcd, 0x234d63 },
	{ 0x7bce, 0x225262 },
	{ 0x7bd0, 0x236621 },
	{ 0x7bd4, 0x22592c },
	{ 0x7bd5, 0x225927 },
	{ 0x7bd8, 0x225931 },
	{ 0x7bd9, 0x21715e },
	{ 0x7bda, 0x225929 },
	{ 0x7bdb, 0x217162 },
	{ 0x7bdc, 0x22592f },
	{ 0x7bdd, 0x225926 },
	{ 0x7bde, 0x225923 },
	{ 0x7bdf, 0x225932 },
	{ 0x7be0, 0x21745b },
	{ 0x7be1, 0x217163 },
	{ 0x7be2, 0x22592e },
	{ 0x7be3, 0x225924 },
	{ 0x7be4, 0x217161 },
	{ 0x7be5, 0x225928 },
	{ 0x7be6, 0x217165 },
	{ 0x7be7, 0x225925 },
	{ 0x7be8, 0x22592a },
	{ 0x7be9, 0x217164 },
	{ 0x7bea, 0x22592d },
	{ 0x7beb, 0x225930 },
	{ 0x7bec, 0x235233 },
	{ 0x7bed, 0x235234 },
	{ 0x7bf0, 0x225e38 },
	{ 0x7bf1, 0x225e39 },
	{ 0x7bf2, 0x225e29 },
	{ 0x7bf3, 0x225e30 },
	{ 0x7bf4, 0x225e2e },
	{ 0x7bf6, 0x23556d },
	{ 0x7bf7, 0x217459 },
	{ 0x7bf8, 0x225e35 },
	{ 0x7bf9, 0x22592b },
	{ 0x7bfa, 0x23556b },
	{ 0x7bfb, 0x225e2c },
	{ 0x7bfc, 0x23556e },
	{ 0x7bfd, 0x225e36 },
	{ 0x7bfe, 0x217458 },
	{ 0x7bff, 0x225e2b },
	{ 0x7c00, 0x225e2a },
	{ 0x7c01, 0x225e34 },
	{ 0x7c02, 0x225e31 },
	{ 0x7c03, 0x225e33 },
	{ 0x7c05, 0x225e27 },
	{ 0x7c06, 0x225e37 },
	{ 0x7c07, 0x217456 },
	{ 0x7c08, 0x235570 },
	{ 0x7c09, 0x225e32 },
	{ 0x7c0a, 0x225e3b },
	{ 0x7c0b, 0x225e2f },
	{ 0x7c0c, 0x21745a },
	{ 0x7c0d, 0x217457 },
	{ 0x7c0e, 0x225e2d },
	{ 0x7c0f, 0x225e28 },
	{ 0x7c10, 0x225e3a },
	{ 0x7c11, 0x21715f },
	{ 0x7c12, 0x235571 },
	{ 0x7c18, 0x23556f },
	{ 0x7c19, 0x22624f },
	{ 0x7c1a, 0x235850 },
	{ 0x7c1b, 0x23584e },
	{ 0x7c1c, 0x22624d },
	{ 0x7c1d, 0x226253 },
	{ 0x7c1e, 0x21767a },
	{ 0x7c1f, 0x226251 },
	{ 0x7c20, 0x226250 },
	{ 0x7c21, 0x21767c },
	{ 0x7c22, 0x226256 },
	{ 0x7c23, 0x21767b },
	{ 0x7c24, 0x235851 },
	{ 0x7c25, 0x226257 },
	{ 0x7c26, 0x226254 },
	{ 0x7c27, 0x217678 },
	{ 0x7c28, 0x226255 },
	{ 0x7c29, 0x22624e },
	{ 0x7c2a, 0x217679 },
	{ 0x7c2b, 0x217677 },
	{ 0x7c2c, 0x226635 },
	{ 0x7c2d, 0x226252 },
	{ 0x7c2e, 0x23584c },
	{ 0x7c2f, 0x236622 },
	{ 0x7c30, 0x226258 },
	{ 0x7c32, 0x236623 },
	{ 0x7c33, 0x226632 },
	{ 0x7c34, 0x235a6f },
	{ 0x7c35, 0x235a6e },
	{ 0x7c37, 0x21785d },
	{ 0x7c38, 0x21785b },
	{ 0x7c39, 0x226634 },
	{ 0x7c3b, 0x226636 },
	{ 0x7c3c, 0x226633 },
	{ 0x7c3d, 0x21785c },
	{ 0x7c3e, 0x217859 },
	{ 0x7c3f, 0x21785a },
	{ 0x7c40, 0x21785e },
	{ 0x7c42, 0x236624 },
	{ 0x7c43, 0x217a25 },
	{ 0x7c44, 0x235c66 },
	{ 0x7c45, 0x226957 },
	{ 0x7c47, 0x226956 },
	{ 0x7c48, 0x226954 },
	{ 0x7c49, 0x226953 },
	{ 0x7c4a, 0x226955 },
	{ 0x7c4b, 0x235c65 },
	{ 0x7c4c, 0x217a24 },
	{ 0x7c4d, 0x217a26 },
	{ 0x7c4e, 0x236625 },
	{ 0x7c50, 0x217a7b },
	{ 0x7c51, 0x235e4c },
	{ 0x7c53, 0x226b73 },
	{ 0x7c54, 0x226b72 },
	{ 0x7c56, 0x235e4b },
	{ 0x7c57, 0x226d68 },
	{ 0x7c58, 0x235f58 },
	{ 0x7c59, 0x226d6a },
	{ 0x7c5a, 0x226d6c },
	{ 0x7c5b, 0x226d6b },
	{ 0x7c5c, 0x226d69 },
	{ 0x7c5d, 0x235f57 },
	{ 0x7c5e, 0x23603f },
	{ 0x7c5f, 0x217b6d },
	{ 0x7c60, 0x217b6c },
	{ 0x7c62, 0x23603e },
	{ 0x7c63, 0x217c3f },
	{ 0x7c64, 0x217c3e },
	{ 0x7c65, 0x217c40 },
	{ 0x7c66, 0x226f3c },
	{ 0x7c67, 0x226f3b },
	{ 0x7c68, 0x236626 },
	{ 0x7c69, 0x22712b },
	{ 0x7c6a, 0x227046 },
	{ 0x7c6b, 0x22712c },
	{ 0x7c6c, 0x217d25 },
	{ 0x7c6d, 0x236144 },
	{ 0x7c6e, 0x217d26 },
	{ 0x7c6f, 0x22715c },
	{ 0x7c71, 0x23623a },
	{ 0x7c72, 0x217d4b },
	{ 0x7c73, 0x21484d },
	{ 0x7c74, 0x232a49 },
	{ 0x7c75, 0x222848 },
	{ 0x7c76, 0x232a48 },
	{ 0x7c77, 0x232e52 },
	{ 0x7c78, 0x222c66 },
	{ 0x7c79, 0x222c67 },
	{ 0x7c7a, 0x222c65 },
	{ 0x7c7b, 0x232e54 },
	{ 0x7c7c, 0x232e53 },
	{ 0x7c7d, 0x215276 },
	{ 0x7c7f, 0x222c68 },
	{ 0x7c80, 0x222c69 },
	{ 0x7c81, 0x222c6a },
	{ 0x7c83, 0x233331 },
	{ 0x7c84, 0x22316b },
	{ 0x7c85, 0x223171 },
	{ 0x7c86, 0x23332e },
	{ 0x7c87, 0x233330 },
	{ 0x7c88, 0x22316f },
	{ 0x7c89, 0x21573e },
	{ 0x7c8a, 0x22316d },
	{ 0x7c8b, 0x233332 },
	{ 0x7c8c, 0x22316e },
	{ 0x7c8d, 0x223170 },
	{ 0x7c8e, 0x23332d },
	{ 0x7c91, 0x22316c },
	{ 0x7c92, 0x215c4e },
	{ 0x7c93, 0x23377d },
	{ 0x7c94, 0x223823 },
	{ 0x7c95, 0x215c50 },
	{ 0x7c96, 0x223825 },
	{ 0x7c97, 0x215c4f },
	{ 0x7c98, 0x223824 },
	{ 0x7c99, 0x23377e },
	{ 0x7c9a, 0x233821 },
	{ 0x7c9b, 0x23383e },
	{ 0x7c9c, 0x233822 },
	{ 0x7c9e, 0x223e6c },
	{ 0x7c9f, 0x216135 },
	{ 0x7ca0, 0x233e21 },
	{ 0x7ca1, 0x223e6e },
	{ 0x7ca2, 0x223e6b },
	{ 0x7ca3, 0x223826 },
	{ 0x7ca4, 0x233e23 },
	{ 0x7ca5, 0x216136 },
	{ 0x7ca6, 0x233e22 },
	{ 0x7ca7, 0x233d7e },
	{ 0x7ca8, 0x223e6d },
	{ 0x7ca9, 0x236627 },
	{ 0x7cae, 0x234358 },
	{ 0x7caf, 0x22457b },
	{ 0x7cb0, 0x23435c },
	{ 0x7cb1, 0x21656b },
	{ 0x7cb2, 0x224579 },
	{ 0x7cb3, 0x21656c },
	{ 0x7cb4, 0x22457a },
	{ 0x7cb5, 0x21656d },
	{ 0x7cb7, 0x234862 },
	{ 0x7cb8, 0x234861 },
	{ 0x7cb9, 0x216a32 },
	{ 0x7cba, 0x224c68 },
	{ 0x7cbb, 0x224c65 },
	{ 0x7cbc, 0x224c67 },
	{ 0x7cbd, 0x216a33 },
	{ 0x7cbe, 0x216a34 },
	{ 0x7cbf, 0x224c66 },
	{ 0x7cc2, 0x234d6f },
	{ 0x7cc3, 0x234d71 },
	{ 0x7cc4, 0x234d6d },
	{ 0x7cc5, 0x225267 },
	{ 0x7cc6, 0x234d70 },
	{ 0x7cc7, 0x234d73 },
	{ 0x7cc8, 0x225268 },
	{ 0x7cc9, 0x234d72 },
	{ 0x7cca, 0x216e36 },
	{ 0x7ccb, 0x22526a },
	{ 0x7ccc, 0x225269 },
	{ 0x7ccd, 0x234d6e },
	{ 0x7cce, 0x212323 },
	{ 0x7cd0, 0x225936 },
	{ 0x7cd1, 0x225937 },
	{ 0x7cd2, 0x225933 },
	{ 0x7cd3, 0x235237 },
	{ 0x7cd4, 0x225934 },
	{ 0x7cd5, 0x217166 },
	{ 0x7cd6, 0x217167 },
	{ 0x7cd7, 0x225935 },
	{ 0x7cd9, 0x217461 },
	{ 0x7cda, 0x235575 },
	{ 0x7cdb, 0x235574 },
	{ 0x7cdc, 0x21745d },
	{ 0x7cdd, 0x217462 },
	{ 0x7cde, 0x21745e },
	{ 0x7cdf, 0x217460 },
	{ 0x7ce0, 0x21745c },
	{ 0x7ce1, 0x235239 },
	{ 0x7ce2, 0x21745f },
	{ 0x7ce3, 0x235855 },
	{ 0x7ce6, 0x235854 },
	{ 0x7ce7, 0x21767d },
	{ 0x7ce8, 0x225e3c },
	{ 0x7cea, 0x226638 },
	{ 0x7cec, 0x226637 },
	{ 0x7ced, 0x236628 },
	{ 0x7cee, 0x226958 },
	{ 0x7cef, 0x217a27 },
	{ 0x7cf0, 0x217a28 },
	{ 0x7cf1, 0x226d6e },
	{ 0x7cf2, 0x226b74 },
	{ 0x7cf3, 0x236169 },
	{ 0x7cf4, 0x226d6d },
	{ 0x7cf5, 0x236040 },
	{ 0x7cf6, 0x22712d },
	{ 0x7cf7, 0x227172 },
	{ 0x7cf8, 0x21484e },
	{ 0x7cfa, 0x232722 },
	{ 0x7cfb, 0x214b37 },
	{ 0x7cfc, 0x232a4b },
	{ 0x7cfd, 0x222849 },
	{ 0x7cfe, 0x214f2b },
	{ 0x7cff, 0x232a4a },
	{ 0x7d00, 0x215279 },
	{ 0x7d01, 0x222c6d },
	{ 0x7d02, 0x215277 },
	{ 0x7d03, 0x222c6b },
	{ 0x7d04, 0x21527c },
	{ 0x7d05, 0x215278 },
	{ 0x7d06, 0x21527d },
	{ 0x7d07, 0x21527b },
	{ 0x7d08, 0x222c6c },
	{ 0x7d09, 0x21527a },
	{ 0x7d0a, 0x215742 },
	{ 0x7d0b, 0x215741 },
	{ 0x7d0c, 0x22317c },
	{ 0x7d0d, 0x21574a },
	{ 0x7d0e, 0x223175 },
	{ 0x7d0f, 0x22317b },
	{ 0x7d10, 0x215746 },
	{ 0x7d11, 0x223174 },
	{ 0x7d12, 0x22317a },
	{ 0x7d13, 0x223178 },
	{ 0x7d14, 0x215745 },
	{ 0x7d15, 0x215747 },
	{ 0x7d16, 0x223177 },
	{ 0x7d17, 0x215740 },
	{ 0x7d18, 0x223176 },
	{ 0x7d19, 0x21574b },
	{ 0x7d1a, 0x215748 },
	{ 0x7d1b, 0x21574c },
	{ 0x7d1c, 0x215749 },
	{ 0x7d1d, 0x223173 },
	{ 0x7d1e, 0x223172 },
	{ 0x7d1f, 0x223179 },
	{ 0x7d20, 0x215743 },
	{ 0x7d21, 0x21573f },
	{ 0x7d22, 0x215744 },
	{ 0x7d24, 0x233337 },
	{ 0x7d25, 0x23333b },
	{ 0x7d28, 0x223835 },
	{ 0x7d29, 0x22382e },
	{ 0x7d2b, 0x21613b },
	{ 0x7d2c, 0x22382d },
	{ 0x7d2d, 0x233829 },
	{ 0x7d2e, 0x215c54 },
	{ 0x7d2f, 0x215c5b },
	{ 0x7d30, 0x215c58 },
	{ 0x7d31, 0x215c5e },
	{ 0x7d32, 0x215c5d },
	{ 0x7d33, 0x215c59 },
	{ 0x7d34, 0x233826 },
	{ 0x7d35, 0x223827 },
	{ 0x7d36, 0x22382a },
	{ 0x7d37, 0x233827 },
	{ 0x7d38, 0x223829 },
	{ 0x7d39, 0x215c55 },
	{ 0x7d3a, 0x22382b },
	{ 0x7d3b, 0x223834 },
	{ 0x7d3c, 0x215c56 },
	{ 0x7d3d, 0x223828 },
	{ 0x7d3e, 0x223831 },
	{ 0x7d3f, 0x223832 },
	{ 0x7d40, 0x215c57 },
	{ 0x7d41, 0x22382f },
	{ 0x7d42, 0x215c5c },
	{ 0x7d43, 0x215c52 },
	{ 0x7d44, 0x215c5a },
	{ 0x7d45, 0x22382c },
	{ 0x7d46, 0x215c51 },
	{ 0x7d47, 0x223830 },
	{ 0x7d48, 0x23382e },
	{ 0x7d49, 0x233824 },
	{ 0x7d4a, 0x223833 },
	{ 0x7d4c, 0x23382b },
	{ 0x7d4d, 0x233e34 },
	{ 0x7d4e, 0x223f21 },
	{ 0x7d4f, 0x223e76 },
	{ 0x7d50, 0x216138 },
	{ 0x7d51, 0x223e7d },
	{ 0x7d52, 0x223e7a },
	{ 0x7d53, 0x223e72 },
	{ 0x7d54, 0x223e7b },
	{ 0x7d55, 0x21613a },
	{ 0x7d56, 0x223e73 },
	{ 0x7d57, 0x233e29 },
	{ 0x7d58, 0x223e6f },
	{ 0x7d59, 0x233e26 },
	{ 0x7d5a, 0x233e2e },
	{ 0x7d5b, 0x216573 },
	{ 0x7d5c, 0x223e78 },
	{ 0x7d5d, 0x233e2f },
	{ 0x7d5e, 0x216137 },
	{ 0x7d5f, 0x223e7e },
	{ 0x7d60, 0x233e28 },
	{ 0x7d61, 0x21613e },
	{ 0x7d62, 0x216140 },
	{ 0x7d63, 0x223e71 },
	{ 0x7d64, 0x233e2c },
	{ 0x7d66, 0x21613f },
	{ 0x7d67, 0x223e74 },
	{ 0x7d68, 0x216139 },
	{ 0x7d69, 0x223e7c },
	{ 0x7d6a, 0x223e75 },
	{ 0x7d6b, 0x223e79 },
	{ 0x7d6c, 0x233e2a },
	{ 0x7d6d, 0x223e77 },
	{ 0x7d6e, 0x21613c },
	{ 0x7d6f, 0x223e70 },
	{ 0x7d70, 0x216141 },
	{ 0x7d71, 0x215c53 },
	{ 0x7d72, 0x21613d },
	{ 0x7d73, 0x216142 },
	{ 0x7d74, 0x233e24 },
	{ 0x7d75, 0x233e35 },
	{ 0x7d76, 0x233e33 },
	{ 0x7d78, 0x234367 },
	{ 0x7d79, 0x21656f },
	{ 0x7d7a, 0x224624 },
	{ 0x7d7b, 0x224626 },
	{ 0x7d7c, 0x224628 },
	{ 0x7d7d, 0x22462c },
	{ 0x7d7e, 0x233e2b },
	{ 0x7d7f, 0x224622 },
	{ 0x7d80, 0x22457e },
	{ 0x7d81, 0x216571 },
	{ 0x7d83, 0x224627 },
	{ 0x7d84, 0x22462b },
	{ 0x7d85, 0x224623 },
	{ 0x7d86, 0x22457d },
	{ 0x7d87, 0x234366 },
	{ 0x7d88, 0x22457c },
	{ 0x7d89, 0x234369 },
	{ 0x7d8a, 0x234360 },
	{ 0x7d8b, 0x234362 },
	{ 0x7d8c, 0x224629 },
	{ 0x7d8d, 0x224621 },
	{ 0x7d8e, 0x224625 },
	{ 0x7d8f, 0x216572 },
	{ 0x7d90, 0x23435e },
	{ 0x7d91, 0x216570 },
	{ 0x7d92, 0x22462d },
	{ 0x7d93, 0x21656e },
	{ 0x7d94, 0x22462a },
	{ 0x7d95, 0x234364 },
	{ 0x7d96, 0x224c79 },
	{ 0x7d97, 0x234368 },
	{ 0x7d98, 0x23436a },
	{ 0x7d99, 0x234363 },
	{ 0x7d9c, 0x216a37 },
	{ 0x7d9d, 0x224c71 },
	{ 0x7d9e, 0x216e43 },
	{ 0x7d9f, 0x224c7b },
	{ 0x7da0, 0x216a3a },
	{ 0x7da1, 0x224d21 },
	{ 0x7da2, 0x216a40 },
	{ 0x7da3, 0x224c6c },
	{ 0x7da4, 0x234874 },
	{ 0x7da6, 0x224c7c },
	{ 0x7da7, 0x224c69 },
	{ 0x7da8, 0x23486d },
	{ 0x7da9, 0x224c7e },
	{ 0x7daa, 0x224c6d },
	{ 0x7dab, 0x23486e },
	{ 0x7dac, 0x216a47 },
	{ 0x7dad, 0x216a44 },
	{ 0x7dae, 0x224c7d },
	{ 0x7daf, 0x224c77 },
	{ 0x7db0, 0x216a36 },
	{ 0x7db1, 0x216a3e },
	{ 0x7db2, 0x216a3d },
	{ 0x7db3, 0x234870 },
	{ 0x7db4, 0x216a3c },
	{ 0x7db5, 0x216a42 },
	{ 0x7db6, 0x234869 },
	{ 0x7db7, 0x224c6a },
	{ 0x7db8, 0x216a43 },
	{ 0x7db9, 0x224c78 },
	{ 0x7dba, 0x216a3f },
	{ 0x7dbb, 0x216a35 },
	{ 0x7dbc, 0x224c7a },
	{ 0x7dbd, 0x216a38 },
	{ 0x7dbe, 0x216a39 },
	{ 0x7dbf, 0x216a41 },
	{ 0x7dc0, 0x224c6f },
	{ 0x7dc1, 0x224c6e },
	{ 0x7dc2, 0x224c6b },
	{ 0x7dc4, 0x224c73 },
	{ 0x7dc5, 0x224c70 },
	{ 0x7dc6, 0x224c74 },
	{ 0x7dc7, 0x216a46 },
	{ 0x7dc8, 0x234868 },
	{ 0x7dc9, 0x224d22 },
	{ 0x7dca, 0x216a3b },
	{ 0x7dcb, 0x224c75 },
	{ 0x7dcc, 0x224c76 },
	{ 0x7dcd, 0x234871 },
	{ 0x7dce, 0x224c72 },
	{ 0x7dcf, 0x234873 },
	{ 0x7dd0, 0x236629 },
	{ 0x7dd1, 0x23486b },
	{ 0x7dd2, 0x216a45 },
	{ 0x7dd3, 0x23662b },
	{ 0x7dd6, 0x234e22 },
	{ 0x7dd7, 0x22526f },
	{ 0x7dd8, 0x216e3b },
	{ 0x7dd9, 0x216e44 },
	{ 0x7dda, 0x216e40 },
	{ 0x7ddb, 0x22526c },
	{ 0x7ddc, 0x234d7c },
	{ 0x7ddd, 0x216e3d },
	{ 0x7dde, 0x216e41 },
	{ 0x7ddf, 0x225278 },
	{ 0x7de0, 0x216e37 },
	{ 0x7de1, 0x225270 },
	{ 0x7de2, 0x234d78 },
	{ 0x7de3, 0x216e3f },
	{ 0x7de4, 0x234e24 },
	{ 0x7de5, 0x234e2f },
	{ 0x7de6, 0x225273 },
	{ 0x7de7, 0x22526e },
	{ 0x7de8, 0x216e3e },
	{ 0x7de9, 0x216e42 },
	{ 0x7dea, 0x22526d },
	{ 0x7deb, 0x234e2e },
	{ 0x7dec, 0x216e3c },
	{ 0x7ded, 0x234d77 },
	{ 0x7dee, 0x225277 },
	{ 0x7def, 0x216e39 },
	{ 0x7df0, 0x225276 },
	{ 0x7df1, 0x225275 },
	{ 0x7df2, 0x216e45 },
	{ 0x7df3, 0x22503b },
	{ 0x7df4, 0x216e38 },
	{ 0x7df5, 0x234e2b },
	{ 0x7df6, 0x225274 },
	{ 0x7df7, 0x22526b },
	{ 0x7df8, 0x234d75 },
	{ 0x7df9, 0x216e46 },
	{ 0x7dfa, 0x225272 },
	{ 0x7dfb, 0x216e3a },
	{ 0x7dfc, 0x234e28 },
	{ 0x7dfd, 0x234e29 },
	{ 0x7dfe, 0x234e25 },
	{ 0x7dff, 0x234e2c },
	{ 0x7e00, 0x234e27 },
	{ 0x7e01, 0x234d7e },
	{ 0x7e02, 0x234d7d },
	{ 0x7e03, 0x225271 },
	{ 0x7e07, 0x23662a },
	{ 0x7e08, 0x21716a },
	{ 0x7e09, 0x21716f },
	{ 0x7e0a, 0x217168 },
	{ 0x7e0b, 0x225944 },
	{ 0x7e0c, 0x22593b },
	{ 0x7e0d, 0x225947 },
	{ 0x7e0e, 0x22593f },
	{ 0x7e0f, 0x225945 },
	{ 0x7e10, 0x217170 },
	{ 0x7e11, 0x217169 },
	{ 0x7e12, 0x225938 },
	{ 0x7e13, 0x22593e },
	{ 0x7e14, 0x225948 },
	{ 0x7e15, 0x225941 },
	{ 0x7e16, 0x225946 },
	{ 0x7e17, 0x22593a },
	{ 0x7e19, 0x23523b },
	{ 0x7e1a, 0x225942 },
	{ 0x7e1b, 0x21716b },
	{ 0x7e1c, 0x225940 },
	{ 0x7e1d, 0x21716e },
	{ 0x7e1e, 0x21716d },
	{ 0x7e1f, 0x22593c },
	{ 0x7e20, 0x22593d },
	{ 0x7e21, 0x225939 },
	{ 0x7e22, 0x225943 },
	{ 0x7e23, 0x21716c },
	{ 0x7e24, 0x22594a },
	{ 0x7e25, 0x225949 },
	{ 0x7e26, 0x235240 },
	{ 0x7e27, 0x23523f },
	{ 0x7e29, 0x225e47 },
	{ 0x7e2a, 0x225e43 },
	{ 0x7e2b, 0x217469 },
	{ 0x7e2c, 0x235579 },
	{ 0x7e2d, 0x225e3d },
	{ 0x7e2e, 0x217463 },
	{ 0x7e2f, 0x217473 },
	{ 0x7e30, 0x225e49 },
	{ 0x7e31, 0x21746b },
	{ 0x7e32, 0x217467 },
	{ 0x7e33, 0x225e40 },
	{ 0x7e34, 0x21746e },
	{ 0x7e35, 0x217471 },
	{ 0x7e36, 0x225e4b },
	{ 0x7e37, 0x217466 },
	{ 0x7e38, 0x225e42 },
	{ 0x7e39, 0x21746f },
	{ 0x7e3a, 0x225e4d },
	{ 0x7e3b, 0x225e4a },
	{ 0x7e3c, 0x225e3e },
	{ 0x7e3d, 0x21746a },
	{ 0x7e3e, 0x217464 },
	{ 0x7e3f, 0x217472 },
	{ 0x7e40, 0x225e45 },
	{ 0x7e41, 0x21746d },
	{ 0x7e42, 0x225e3f },
	{ 0x7e43, 0x217468 },
	{ 0x7e44, 0x225e4c },
	{ 0x7e45, 0x21746c },
	{ 0x7e46, 0x217465 },
	{ 0x7e47, 0x225e46 },
	{ 0x7e48, 0x217470 },
	{ 0x7e49, 0x225e44 },
	{ 0x7e4c, 0x225e48 },
	{ 0x7e4d, 0x23557a },
	{ 0x7e4f, 0x235859 },
	{ 0x7e50, 0x22625a },
	{ 0x7e51, 0x226260 },
	{ 0x7e52, 0x217725 },
	{ 0x7e53, 0x226263 },
	{ 0x7e54, 0x21767e },
	{ 0x7e55, 0x217721 },
	{ 0x7e56, 0x22625b },
	{ 0x7e57, 0x226262 },
	{ 0x7e58, 0x22625d },
	{ 0x7e59, 0x217726 },
	{ 0x7e5a, 0x217723 },
	{ 0x7e5b, 0x23585b },
	{ 0x7e5c, 0x226259 },
	{ 0x7e5d, 0x235858 },
	{ 0x7e5e, 0x217722 },
	{ 0x7e5f, 0x22625f },
	{ 0x7e60, 0x226261 },
	{ 0x7e61, 0x217724 },
	{ 0x7e62, 0x22625e },
	{ 0x7e63, 0x22625c },
	{ 0x7e64, 0x23662c },
	{ 0x7e66, 0x23585a },
	{ 0x7e68, 0x226642 },
	{ 0x7e69, 0x217862 },
	{ 0x7e6a, 0x217863 },
	{ 0x7e6b, 0x21785f },
	{ 0x7e6c, 0x235a72 },
	{ 0x7e6d, 0x217860 },
	{ 0x7e6e, 0x235a74 },
	{ 0x7e6f, 0x22663e },
	{ 0x7e70, 0x22663c },
	{ 0x7e71, 0x235a75 },
	{ 0x7e72, 0x226640 },
	{ 0x7e73, 0x217864 },
	{ 0x7e74, 0x226641 },
	{ 0x7e75, 0x22663a },
	{ 0x7e76, 0x226639 },
	{ 0x7e77, 0x22663d },
	{ 0x7e78, 0x22663b },
	{ 0x7e79, 0x217861 },
	{ 0x7e7a, 0x22663f },
	{ 0x7e7b, 0x226959 },
	{ 0x7e7c, 0x217a2b },
	{ 0x7e7d, 0x217a2a },
	{ 0x7e7e, 0x22695a },
	{ 0x7e7f, 0x235c6c },
	{ 0x7e80, 0x22695c },
	{ 0x7e81, 0x22695b },
	{ 0x7e82, 0x217a2c },
	{ 0x7e84, 0x235e53 },
	{ 0x7e85, 0x235e50 },
	{ 0x7e86, 0x226b79 },
	{ 0x7e87, 0x226b76 },
	{ 0x7e88, 0x226b77 },
	{ 0x7e89, 0x235e51 },
	{ 0x7e8a, 0x226b75 },
	{ 0x7e8b, 0x226b78 },
	{ 0x7e8c, 0x217a7d },
	{ 0x7e8d, 0x226b7a },
	{ 0x7e8e, 0x235e52 },
	{ 0x7e8f, 0x217a7c },
	{ 0x7e91, 0x226d6f },
	{ 0x7e92, 0x235f5a },
	{ 0x7e93, 0x217c41 },
	{ 0x7e94, 0x217c43 },
	{ 0x7e95, 0x226f3d },
	{ 0x7e96, 0x217c42 },
	{ 0x7e97, 0x227047 },
	{ 0x7e98, 0x22712f },
	{ 0x7e99, 0x227131 },
	{ 0x7e9a, 0x22712e },
	{ 0x7e9b, 0x227130 },
	{ 0x7e9c, 0x217d39 },
	{ 0x7e9e, 0x236235 },
	{ 0x7f36, 0x21484f },
	{ 0x7f38, 0x21527e },
	{ 0x7f39, 0x223052 },
	{ 0x7f3a, 0x21574d },
	{ 0x7f3b, 0x233831 },
	{ 0x7f3d, 0x215c5f },
	{ 0x7f3e, 0x223f22 },
	{ 0x7f3f, 0x223f23 },
	{ 0x7f40, 0x23662d },
	{ 0x7f41, 0x234877 },
	{ 0x7f43, 0x22594b },
	{ 0x7f44, 0x217474 },
	{ 0x7f45, 0x225e4e },
	{ 0x7f46, 0x23557d },
	{ 0x7f47, 0x23585c },
	{ 0x7f48, 0x217727 },
	{ 0x7f4a, 0x226644 },
	{ 0x7f4b, 0x226643 },
	{ 0x7f4c, 0x217a2d },
	{ 0x7f4d, 0x226b7b },
	{ 0x7f4e, 0x235f5b },
	{ 0x7f4f, 0x226d70 },
	{ 0x7f50, 0x217c64 },
	{ 0x7f51, 0x222269 },
	{ 0x7f54, 0x214f2c },
	{ 0x7f55, 0x214b38 },
	{ 0x7f58, 0x222c6e },
	{ 0x7f59, 0x232a4e },
	{ 0x7f5b, 0x223224 },
	{ 0x7f5c, 0x22317d },
	{ 0x7f5d, 0x223223 },
	{ 0x7f5e, 0x223221 },
	{ 0x7f5f, 0x21574e },
	{ 0x7f60, 0x223222 },
	{ 0x7f61, 0x22317e },
	{ 0x7f62, 0x23333c },
	{ 0x7f63, 0x223836 },
	{ 0x7f65, 0x223f24 },
	{ 0x7f66, 0x223f25 },
	{ 0x7f67, 0x224630 },
	{ 0x7f68, 0x224631 },
	{ 0x7f69, 0x216575 },
	{ 0x7f6a, 0x216576 },
	{ 0x7f6b, 0x22462f },
	{ 0x7f6c, 0x224632 },
	{ 0x7f6d, 0x22462e },
	{ 0x7f6e, 0x216574 },
	{ 0x7f6f, 0x234878 },
	{ 0x7f70, 0x216a48 },
	{ 0x7f71, 0x234879 },
	{ 0x7f72, 0x216577 },
	{ 0x7f73, 0x224d23 },
	{ 0x7f75, 0x216e47 },
	{ 0x7f76, 0x225279 },
	{ 0x7f77, 0x216e48 },
	{ 0x7f78, 0x234e30 },
	{ 0x7f79, 0x217171 },
	{ 0x7f7a, 0x22594e },
	{ 0x7f7b, 0x22594c },
	{ 0x7f7c, 0x22594d },
	{ 0x7f7d, 0x225e51 },
	{ 0x7f7e, 0x225e50 },
	{ 0x7f7f, 0x225e4f },
	{ 0x7f83, 0x226645 },
	{ 0x7f84, 0x236422 },
	{ 0x7f85, 0x217865 },
	{ 0x7f86, 0x226646 },
	{ 0x7f87, 0x226d71 },
	{ 0x7f88, 0x217c65 },
	{ 0x7f89, 0x227048 },
	{ 0x7f8a, 0x214850 },
	{ 0x7f8b, 0x214f2e },
	{ 0x7f8c, 0x214f2d },
	{ 0x7f8d, 0x222c70 },
	{ 0x7f8e, 0x215321 },
	{ 0x7f8f, 0x232e5d },
	{ 0x7f91, 0x222c6f },
	{ 0x7f92, 0x223226 },
	{ 0x7f93, 0x23333d },
	{ 0x7f94, 0x21574f },
	{ 0x7f95, 0x223837 },
	{ 0x7f96, 0x223225 },
	{ 0x7f97, 0x23333f },
	{ 0x7f99, 0x23333e },
	{ 0x7f9a, 0x215c61 },
	{ 0x7f9b, 0x22383a },
	{ 0x7f9c, 0x223838 },
	{ 0x7f9d, 0x223839 },
	{ 0x7f9e, 0x215c60 },
	{ 0x7fa0, 0x223f27 },
	{ 0x7fa1, 0x223f28 },
	{ 0x7fa2, 0x223f26 },
	{ 0x7fa3, 0x23436e },
	{ 0x7fa4, 0x21657a },
	{ 0x7fa5, 0x224634 },
	{ 0x7fa6, 0x224633 },
	{ 0x7fa7, 0x224635 },
	{ 0x7fa8, 0x216579 },
	{ 0x7fa9, 0x216578 },
	{ 0x7fac, 0x22527a },
	{ 0x7fad, 0x22527c },
	{ 0x7fae, 0x234e31 },
	{ 0x7faf, 0x216e49 },
	{ 0x7fb0, 0x22527b },
	{ 0x7fb1, 0x22594f },
	{ 0x7fb2, 0x217172 },
	{ 0x7fb3, 0x226265 },
	{ 0x7fb4, 0x23585d },
	{ 0x7fb5, 0x226264 },
	{ 0x7fb6, 0x217866 },
	{ 0x7fb7, 0x226647 },
	{ 0x7fb8, 0x217868 },
	{ 0x7fb9, 0x217867 },
	{ 0x7fba, 0x22695d },
	{ 0x7fbb, 0x226b7c },
	{ 0x7fbc, 0x217a7e },
	{ 0x7fbd, 0x214851 },
	{ 0x7fbe, 0x222c71 },
	{ 0x7fbf, 0x215322 },
	{ 0x7fc0, 0x223229 },
	{ 0x7fc1, 0x215751 },
	{ 0x7fc2, 0x223228 },
	{ 0x7fc3, 0x223227 },
	{ 0x7fc4, 0x233342 },
	{ 0x7fc5, 0x215750 },
	{ 0x7fc6, 0x233343 },
	{ 0x7fc7, 0x223840 },
	{ 0x7fc9, 0x223842 },
	{ 0x7fca, 0x22383b },
	{ 0x7fcb, 0x22383c },
	{ 0x7fcc, 0x215c62 },
	{ 0x7fcd, 0x22383d },
	{ 0x7fce, 0x215c63 },
	{ 0x7fcf, 0x223841 },
	{ 0x7fd0, 0x22383e },
	{ 0x7fd1, 0x22383f },
	{ 0x7fd2, 0x215c64 },
	{ 0x7fd3, 0x233e37 },
	{ 0x7fd4, 0x216144 },
	{ 0x7fd5, 0x216145 },
	{ 0x7fd6, 0x233e38 },
	{ 0x7fd7, 0x223f29 },
	{ 0x7fdb, 0x224636 },
	{ 0x7fdc, 0x224637 },
	{ 0x7fdd, 0x234372 },
	{ 0x7fde, 0x224d27 },
	{ 0x7fdf, 0x216a4b },
	{ 0x7fe0, 0x216a49 },
	{ 0x7fe1, 0x216a4a },
	{ 0x7fe2, 0x224d24 },
	{ 0x7fe3, 0x224d25 },
	{ 0x7fe5, 0x224d26 },
	{ 0x7fe6, 0x225323 },
	{ 0x7fe7, 0x234e32 },
	{ 0x7fe8, 0x225324 },
	{ 0x7fe9, 0x216e4a },
	{ 0x7fea, 0x225321 },
	{ 0x7feb, 0x22527e },
	{ 0x7fec, 0x225322 },
	{ 0x7fed, 0x22527d },
	{ 0x7fee, 0x217175 },
	{ 0x7fef, 0x225950 },
	{ 0x7ff0, 0x217173 },
	{ 0x7ff1, 0x217174 },
	{ 0x7ff2, 0x225e53 },
	{ 0x7ff3, 0x217475 },
	{ 0x7ff4, 0x225e52 },
	{ 0x7ff5, 0x226134 },
	{ 0x7ff6, 0x23557e },
	{ 0x7ff7, 0x226266 },
	{ 0x7ff8, 0x226267 },
	{ 0x7ff9, 0x217728 },
	{ 0x7ffa, 0x235861 },
	{ 0x7ffb, 0x217729 },
	{ 0x7ffc, 0x217476 },
	{ 0x7ffd, 0x226648 },
	{ 0x7ffe, 0x226649 },
	{ 0x7fff, 0x22695e },
	{ 0x8000, 0x217a2e },
	{ 0x8001, 0x214852 },
	{ 0x8002, 0x23667b },
	{ 0x8003, 0x214853 },
	{ 0x8004, 0x215753 },
	{ 0x8005, 0x214f2f },
	{ 0x8006, 0x215752 },
	{ 0x8007, 0x222c72 },
	{ 0x8008, 0x233836 },
	{ 0x800a, 0x233344 },
	{ 0x800b, 0x216146 },
	{ 0x800c, 0x214854 },
	{ 0x800d, 0x215324 },
	{ 0x800e, 0x222c73 },
	{ 0x800f, 0x222c74 },
	{ 0x8010, 0x215323 },
	{ 0x8011, 0x215325 },
	{ 0x8012, 0x214855 },
	{ 0x8014, 0x222c75 },
	{ 0x8015, 0x215755 },
	{ 0x8016, 0x22322a },
	{ 0x8017, 0x215757 },
	{ 0x8018, 0x215754 },
	{ 0x8019, 0x215756 },
	{ 0x801a, 0x233837 },
	{ 0x801b, 0x223845 },
	{ 0x801c, 0x215c65 },
	{ 0x801d, 0x233839 },
	{ 0x801e, 0x223844 },
	{ 0x801f, 0x223843 },
	{ 0x8021, 0x224638 },
	{ 0x8023, 0x234922 },
	{ 0x8024, 0x224d28 },
	{ 0x8026, 0x216e4b },
	{ 0x8028, 0x217176 },
	{ 0x8029, 0x225952 },
	{ 0x802a, 0x225951 },
	{ 0x802b, 0x235621 },
	{ 0x802c, 0x225e54 },
	{ 0x802e, 0x235862 },
	{ 0x802f, 0x235c6f },
	{ 0x8030, 0x226b7d },
	{ 0x8033, 0x214856 },
	{ 0x8034, 0x222473 },
	{ 0x8035, 0x22284a },
	{ 0x8036, 0x215326 },
	{ 0x8037, 0x222c76 },
	{ 0x8039, 0x22322c },
	{ 0x803b, 0x233349 },
	{ 0x803c, 0x233348 },
	{ 0x803d, 0x215758 },
	{ 0x803e, 0x22322b },
	{ 0x803f, 0x215759 },
	{ 0x8040, 0x233347 },
	{ 0x8041, 0x23662f },
	{ 0x8043, 0x223847 },
	{ 0x8044, 0x23383d },
	{ 0x8045, 0x23383c },
	{ 0x8046, 0x215c67 },
	{ 0x8047, 0x223846 },
	{ 0x8048, 0x223848 },
	{ 0x8049, 0x23383b },
	{ 0x804a, 0x215c66 },
	{ 0x804e, 0x233e3c },
	{ 0x804f, 0x223f2b },
	{ 0x8050, 0x223f2c },
	{ 0x8051, 0x223f2a },
	{ 0x8052, 0x216147 },
	{ 0x8053, 0x236729 },
	{ 0x8056, 0x21657b },
	{ 0x8057, 0x234373 },
	{ 0x8058, 0x21657c },
	{ 0x8059, 0x236356 },
	{ 0x805a, 0x216a4d },
	{ 0x805b, 0x234923 },
	{ 0x805c, 0x224d2a },
	{ 0x805d, 0x224d29 },
	{ 0x805e, 0x216a4c },
	{ 0x805f, 0x234926 },
	{ 0x8060, 0x233e3b },
	{ 0x8061, 0x234925 },
	{ 0x8063, 0x236630 },
	{ 0x8064, 0x225325 },
	{ 0x8065, 0x234e34 },
	{ 0x8066, 0x234e36 },
	{ 0x8067, 0x225326 },
	{ 0x8068, 0x234e37 },
	{ 0x806a, 0x234e35 },
	{ 0x806b, 0x234e38 },
	{ 0x806c, 0x225953 },
	{ 0x806e, 0x235243 },
	{ 0x806f, 0x21747a },
	{ 0x8070, 0x217479 },
	{ 0x8071, 0x217477 },
	{ 0x8072, 0x217478 },
	{ 0x8073, 0x21747b },
	{ 0x8074, 0x235622 },
	{ 0x8075, 0x226268 },
	{ 0x8076, 0x21772b },
	{ 0x8077, 0x21772a },
	{ 0x8078, 0x22664a },
	{ 0x8079, 0x22695f },
	{ 0x807a, 0x235c70 },
	{ 0x807b, 0x235c71 },
	{ 0x807c, 0x235c72 },
	{ 0x807d, 0x217b6f },
	{ 0x807e, 0x217b6e },
	{ 0x807f, 0x214857 },
	{ 0x8082, 0x222f7d },
	{ 0x8084, 0x21657e },
	{ 0x8085, 0x216148 },
	{ 0x8086, 0x21657d },
	{ 0x8087, 0x216a4e },
	{ 0x8089, 0x214858 },
	{ 0x808a, 0x222168 },
	{ 0x808b, 0x214859 },
	{ 0x808c, 0x21485a },
	{ 0x808d, 0x232435 },
	{ 0x808e, 0x232436 },
	{ 0x808f, 0x22284b },
	{ 0x8090, 0x222476 },
	{ 0x8091, 0x232724 },
	{ 0x8092, 0x222477 },
	{ 0x8093, 0x214b3a },
	{ 0x8094, 0x232726 },
	{ 0x8095, 0x222474 },
	{ 0x8096, 0x214b39 },
	{ 0x8097, 0x232725 },
	{ 0x8098, 0x214b3c },
	{ 0x8099, 0x222475 },
	{ 0x809a, 0x214b3e },
	{ 0x809b, 0x214b3d },
	{ 0x809c, 0x222478 },
	{ 0x809d, 0x214b3b },
	{ 0x809f, 0x232723 },
	{ 0x80a1, 0x214f34 },
	{ 0x80a2, 0x214f32 },
	{ 0x80a3, 0x22284d },
	{ 0x80a4, 0x232a56 },
	{ 0x80a5, 0x214f31 },
	{ 0x80a6, 0x232a5b },
	{ 0x80a7, 0x232a58 },
	{ 0x80a8, 0x232a4f },
	{ 0x80a9, 0x214f36 },
	{ 0x80aa, 0x214f38 },
	{ 0x80ab, 0x214f35 },
	{ 0x80ac, 0x232a59 },
	{ 0x80ad, 0x222850 },
	{ 0x80ae, 0x22284c },
	{ 0x80af, 0x214f39 },
	{ 0x80b0, 0x232a52 },
	{ 0x80b1, 0x214f33 },
	{ 0x80b2, 0x214b3f },
	{ 0x80b3, 0x232a54 },
	{ 0x80b4, 0x214f37 },
	{ 0x80b5, 0x22284f },
	{ 0x80b6, 0x232a57 },
	{ 0x80b8, 0x22284e },
	{ 0x80ba, 0x214f30 },
	{ 0x80bb, 0x236631 },
	{ 0x80c2, 0x222c7c },
	{ 0x80c3, 0x21532a },
	{ 0x80c4, 0x21532b },
	{ 0x80c5, 0x222c7e },
	{ 0x80c6, 0x232e66 },
	{ 0x80c7, 0x222c78 },
	{ 0x80c8, 0x222c7b },
	{ 0x80c9, 0x222d26 },
	{ 0x80ca, 0x222d24 },
	{ 0x80cb, 0x232e60 },
	{ 0x80cc, 0x21532c },
	{ 0x80cd, 0x222d2a },
	{ 0x80ce, 0x21532f },
	{ 0x80cf, 0x222d27 },
	{ 0x80d0, 0x222c7d },
	{ 0x80d1, 0x222c7a },
	{ 0x80d2, 0x232e61 },
	{ 0x80d3, 0x232e5e },
	{ 0x80d4, 0x223f2e },
	{ 0x80d5, 0x222d25 },
	{ 0x80d6, 0x215327 },
	{ 0x80d7, 0x222d28 },
	{ 0x80d8, 0x222c77 },
	{ 0x80d9, 0x222d22 },
	{ 0x80da, 0x215329 },
	{ 0x80db, 0x21532e },
	{ 0x80dc, 0x222d23 },
	{ 0x80dd, 0x215332 },
	{ 0x80de, 0x215330 },
	{ 0x80df, 0x232e65 },
	{ 0x80e0, 0x222c79 },
	{ 0x80e1, 0x21532d },
	{ 0x80e2, 0x232e64 },
	{ 0x80e3, 0x222d21 },
	{ 0x80e4, 0x215331 },
	{ 0x80e5, 0x215328 },
	{ 0x80e6, 0x222d29 },
	{ 0x80ed, 0x21575e },
	{ 0x80ee, 0x23334c },
	{ 0x80ef, 0x215767 },
	{ 0x80f0, 0x21575c },
	{ 0x80f1, 0x21575a },
	{ 0x80f2, 0x22322e },
	{ 0x80f3, 0x215762 },
	{ 0x80f4, 0x21575f },
	{ 0x80f5, 0x223230 },
	{ 0x80f6, 0x23334a },
	{ 0x80f7, 0x233352 },
	{ 0x80f8, 0x215761 },
	{ 0x80f9, 0x22322f },
	{ 0x80fa, 0x22322d },
	{ 0x80fb, 0x223232 },
	{ 0x80fc, 0x215766 },
	{ 0x80fd, 0x215764 },
	{ 0x80fe, 0x223f2d },
	{ 0x80ff, 0x23334b },
	{ 0x8100, 0x223233 },
	{ 0x8101, 0x223231 },
	{ 0x8102, 0x21575b },
	{ 0x8103, 0x23334e },
	{ 0x8104, 0x23334d },
	{ 0x8105, 0x21575d },
	{ 0x8106, 0x215760 },
	{ 0x8107, 0x23334f },
	{ 0x8108, 0x215763 },
	{ 0x8109, 0x232e63 },
	{ 0x810a, 0x215765 },
	{ 0x8114, 0x233e44 },
	{ 0x8115, 0x223852 },
	{ 0x8116, 0x215c69 },
	{ 0x8117, 0x233849 },
	{ 0x8118, 0x223849 },
	{ 0x8119, 0x22384b },
	{ 0x811a, 0x233847 },
	{ 0x811b, 0x22384c },
	{ 0x811d, 0x223854 },
	{ 0x811e, 0x223850 },
	{ 0x811f, 0x22384e },
	{ 0x8121, 0x223851 },
	{ 0x8122, 0x223855 },
	{ 0x8123, 0x215c6a },
	{ 0x8124, 0x215c6e },
	{ 0x8125, 0x22384a },
	{ 0x8127, 0x223853 },
	{ 0x8128, 0x23632e },
	{ 0x8129, 0x215c6c },
	{ 0x812a, 0x233841 },
	{ 0x812b, 0x215c6b },
	{ 0x812c, 0x22384f },
	{ 0x812d, 0x22384d },
	{ 0x812e, 0x233842 },
	{ 0x812f, 0x215c68 },
	{ 0x8130, 0x215c6d },
	{ 0x8131, 0x233845 },
	{ 0x8134, 0x233848 },
	{ 0x8139, 0x21614e },
	{ 0x813a, 0x223f36 },
	{ 0x813b, 0x233e3e },
	{ 0x813d, 0x223f34 },
	{ 0x813e, 0x216150 },
	{ 0x8140, 0x233e43 },
	{ 0x8141, 0x233e45 },
	{ 0x8142, 0x233e41 },
	{ 0x8143, 0x223f2f },
	{ 0x8144, 0x224646 },
	{ 0x8145, 0x233e3d },
	{ 0x8146, 0x21614f },
	{ 0x8147, 0x223f33 },
	{ 0x8148, 0x233e40 },
	{ 0x8149, 0x233e42 },
	{ 0x814a, 0x223f30 },
	{ 0x814b, 0x21614b },
	{ 0x814c, 0x216151 },
	{ 0x814d, 0x223f35 },
	{ 0x814e, 0x21614d },
	{ 0x814f, 0x223f32 },
	{ 0x8150, 0x216a4f },
	{ 0x8151, 0x21614c },
	{ 0x8152, 0x223f31 },
	{ 0x8153, 0x216152 },
	{ 0x8154, 0x21614a },
	{ 0x8155, 0x216149 },
	{ 0x815b, 0x22463e },
	{ 0x815c, 0x22463c },
	{ 0x815d, 0x23437b },
	{ 0x815e, 0x224642 },
	{ 0x815f, 0x23437e },
	{ 0x8160, 0x22463a },
	{ 0x8161, 0x224647 },
	{ 0x8162, 0x22463f },
	{ 0x8163, 0x234375 },
	{ 0x8164, 0x224639 },
	{ 0x8165, 0x216624 },
	{ 0x8166, 0x21662a },
	{ 0x8167, 0x224644 },
	{ 0x8169, 0x22463d },
	{ 0x816a, 0x234376 },
	{ 0x816b, 0x216627 },
	{ 0x816c, 0x234377 },
	{ 0x816d, 0x234423 },
	{ 0x816e, 0x216625 },
	{ 0x816f, 0x224645 },
	{ 0x8170, 0x216622 },
	{ 0x8171, 0x216621 },
	{ 0x8172, 0x224640 },
	{ 0x8173, 0x216626 },
	{ 0x8174, 0x216153 },
	{ 0x8175, 0x23437c },
	{ 0x8176, 0x224643 },
	{ 0x8177, 0x22463b },
	{ 0x8178, 0x216623 },
	{ 0x8179, 0x216628 },
	{ 0x817a, 0x216629 },
	{ 0x817d, 0x234422 },
	{ 0x817f, 0x216a54 },
	{ 0x8180, 0x216a50 },
	{ 0x8181, 0x234927 },
	{ 0x8182, 0x216a55 },
	{ 0x8183, 0x224d2d },
	{ 0x8184, 0x23492a },
	{ 0x8186, 0x224d2c },
	{ 0x8187, 0x224d2e },
	{ 0x8188, 0x216a52 },
	{ 0x8189, 0x224d2b },
	{ 0x818a, 0x216a53 },
	{ 0x818b, 0x224d31 },
	{ 0x818c, 0x224d30 },
	{ 0x818d, 0x224d2f },
	{ 0x818f, 0x216a51 },
	{ 0x8192, 0x234e3b },
	{ 0x8193, 0x234e3d },
	{ 0x8194, 0x234e39 },
	{ 0x8195, 0x22532a },
	{ 0x8196, 0x234e3c },
	{ 0x8197, 0x22532d },
	{ 0x8198, 0x216e51 },
	{ 0x8199, 0x22532c },
	{ 0x819a, 0x216e50 },
	{ 0x819b, 0x216e4c },
	{ 0x819c, 0x216e4d },
	{ 0x819d, 0x216e4e },
	{ 0x819e, 0x225329 },
	{ 0x819f, 0x225328 },
	{ 0x81a0, 0x216e4f },
	{ 0x81a1, 0x234e3a },
	{ 0x81a2, 0x22532b },
	{ 0x81a3, 0x225327 },
	{ 0x81a6, 0x225955 },
	{ 0x81a7, 0x22595f },
	{ 0x81a8, 0x217179 },
	{ 0x81a9, 0x217178 },
	{ 0x81aa, 0x235249 },
	{ 0x81ab, 0x225959 },
	{ 0x81ac, 0x22595b },
	{ 0x81ad, 0x235247 },
	{ 0x81ae, 0x225956 },
	{ 0x81af, 0x235244 },
	{ 0x81b0, 0x22595a },
	{ 0x81b1, 0x225954 },
	{ 0x81b2, 0x22595d },
	{ 0x81b3, 0x217177 },
	{ 0x81b4, 0x22595c },
	{ 0x81b5, 0x225958 },
	{ 0x81b7, 0x22595e },
	{ 0x81b8, 0x235623 },
	{ 0x81b9, 0x225957 },
	{ 0x81ba, 0x21747e },
	{ 0x81bb, 0x225e55 },
	{ 0x81bc, 0x225e5b },
	{ 0x81bd, 0x217524 },
	{ 0x81be, 0x217526 },
	{ 0x81bf, 0x217523 },
	{ 0x81c0, 0x217522 },
	{ 0x81c2, 0x217521 },
	{ 0x81c3, 0x21747d },
	{ 0x81c4, 0x225e56 },
	{ 0x81c5, 0x225e59 },
	{ 0x81c6, 0x21747c },
	{ 0x81c7, 0x225e5a },
	{ 0x81c8, 0x235624 },
	{ 0x81c9, 0x217525 },
	{ 0x81ca, 0x225e58 },
	{ 0x81cc, 0x225e57 },
	{ 0x81cd, 0x21772c },
	{ 0x81ce, 0x235865 },
	{ 0x81cf, 0x21772d },
	{ 0x81d0, 0x22626b },
	{ 0x81d1, 0x226269 },
	{ 0x81d2, 0x22626a },
	{ 0x81d4, 0x235a77 },
	{ 0x81d5, 0x22664c },
	{ 0x81d6, 0x235a78 },
	{ 0x81d7, 0x22664b },
	{ 0x81d8, 0x217869 },
	{ 0x81d9, 0x226961 },
	{ 0x81da, 0x217a2f },
	{ 0x81db, 0x226960 },
	{ 0x81dd, 0x226b7e },
	{ 0x81de, 0x226d72 },
	{ 0x81df, 0x217b70 },
	{ 0x81e0, 0x227132 },
	{ 0x81e1, 0x227133 },
	{ 0x81e2, 0x217c44 },
	{ 0x81e3, 0x21485b },
	{ 0x81e5, 0x214f3a },
	{ 0x81e6, 0x223f37 },
	{ 0x81e7, 0x216a56 },
	{ 0x81e8, 0x217527 },
	{ 0x81e9, 0x225e5c },
	{ 0x81ea, 0x21485c },
	{ 0x81ec, 0x215769 },
	{ 0x81ed, 0x215768 },
	{ 0x81ee, 0x223f38 },
	{ 0x81ef, 0x233e47 },
	{ 0x81f2, 0x225960 },
	{ 0x81f3, 0x21485d },
	{ 0x81f4, 0x215333 },
	{ 0x81f6, 0x233e48 },
	{ 0x81f7, 0x223f39 },
	{ 0x81f8, 0x223f3a },
	{ 0x81f9, 0x223f3b },
	{ 0x81fa, 0x216a57 },
	{ 0x81fb, 0x21717a },
	{ 0x81fc, 0x21485e },
	{ 0x81fe, 0x214f3b },
	{ 0x81ff, 0x222d2b },
	{ 0x8200, 0x21576a },
	{ 0x8201, 0x223234 },
	{ 0x8202, 0x215c6f },
	{ 0x8203, 0x233e49 },
	{ 0x8204, 0x223f3c },
	{ 0x8205, 0x21662b },
	{ 0x8207, 0x216a58 },
	{ 0x8208, 0x21717b },
	{ 0x8209, 0x217528 },
	{ 0x820a, 0x21772e },
	{ 0x820b, 0x22664d },
	{ 0x820c, 0x21485f },
	{ 0x820d, 0x214f3c },
	{ 0x820e, 0x232a5d },
	{ 0x8210, 0x21576b },
	{ 0x8211, 0x223856 },
	{ 0x8212, 0x216154 },
	{ 0x8213, 0x23492b },
	{ 0x8214, 0x216a59 },
	{ 0x8215, 0x224d32 },
	{ 0x8216, 0x22532e },
	{ 0x8218, 0x23524a },
	{ 0x8219, 0x235868 },
	{ 0x821a, 0x235a79 },
	{ 0x821b, 0x214860 },
	{ 0x821c, 0x216155 },
	{ 0x821d, 0x224648 },
	{ 0x821e, 0x216a5a },
	{ 0x821f, 0x214861 },
	{ 0x8220, 0x222851 },
	{ 0x8221, 0x222d2c },
	{ 0x8222, 0x215334 },
	{ 0x8224, 0x232e68 },
	{ 0x8225, 0x223236 },
	{ 0x8227, 0x233357 },
	{ 0x8228, 0x21576e },
	{ 0x8229, 0x233358 },
	{ 0x822a, 0x21576c },
	{ 0x822b, 0x21576d },
	{ 0x822c, 0x21576f },
	{ 0x822d, 0x233355 },
	{ 0x822f, 0x223235 },
	{ 0x8232, 0x22385b },
	{ 0x8233, 0x223858 },
	{ 0x8234, 0x22385a },
	{ 0x8235, 0x215c70 },
	{ 0x8236, 0x215c72 },
	{ 0x8237, 0x215c71 },
	{ 0x8238, 0x223857 },
	{ 0x8239, 0x215c73 },
	{ 0x823a, 0x223859 },
	{ 0x823c, 0x223f3d },
	{ 0x823d, 0x223f3e },
	{ 0x823f, 0x223f3f },
	{ 0x8240, 0x22464b },
	{ 0x8241, 0x234426 },
	{ 0x8242, 0x22464c },
	{ 0x8244, 0x22464a },
	{ 0x8245, 0x22464d },
	{ 0x8247, 0x21662c },
	{ 0x8248, 0x236634 },
	{ 0x8249, 0x224649 },
	{ 0x824a, 0x23492d },
	{ 0x824b, 0x216a5b },
	{ 0x824c, 0x23492e },
	{ 0x824e, 0x225333 },
	{ 0x824f, 0x22532f },
	{ 0x8250, 0x225332 },
	{ 0x8251, 0x225334 },
	{ 0x8252, 0x225331 },
	{ 0x8253, 0x225330 },
	{ 0x8255, 0x225961 },
	{ 0x8256, 0x225962 },
	{ 0x8257, 0x225963 },
	{ 0x8258, 0x21717c },
	{ 0x8259, 0x21717d },
	{ 0x825a, 0x225e5e },
	{ 0x825b, 0x225e5d },
	{ 0x825c, 0x225e5f },
	{ 0x825e, 0x22626d },
	{ 0x825f, 0x22626c },
	{ 0x8261, 0x22664f },
	{ 0x8262, 0x235a7a },
	{ 0x8263, 0x226650 },
	{ 0x8264, 0x22664e },
	{ 0x8265, 0x235a7b },
	{ 0x8266, 0x217a30 },
	{ 0x8268, 0x226962 },
	{ 0x8269, 0x226963 },
	{ 0x826a, 0x235e55 },
	{ 0x826b, 0x226d73 },
	{ 0x826c, 0x226f3e },
	{ 0x826d, 0x227049 },
	{ 0x826e, 0x214862 },
	{ 0x826f, 0x214b40 },
	{ 0x8271, 0x217529 },
	{ 0x8272, 0x214863 },
	{ 0x8274, 0x22385c },
	{ 0x8275, 0x223f40 },
	{ 0x8276, 0x235a7c },
	{ 0x8277, 0x217c6c },
	{ 0x8278, 0x22226a },
	{ 0x827b, 0x232438 },
	{ 0x827c, 0x22226b },
	{ 0x827d, 0x22226d },
	{ 0x827e, 0x214864 },
	{ 0x827f, 0x22226e },
	{ 0x8280, 0x22226c },
	{ 0x8283, 0x222522 },
	{ 0x8284, 0x222523 },
	{ 0x8285, 0x22247b },
	{ 0x8286, 0x232728 },
	{ 0x828a, 0x222521 },
	{ 0x828b, 0x214b42 },
	{ 0x828c, 0x232729 },
	{ 0x828d, 0x214b43 },
	{ 0x828e, 0x22247c },
	{ 0x828f, 0x22247a },
	{ 0x8290, 0x222479 },
	{ 0x8291, 0x22247d },
	{ 0x8292, 0x214b41 },
	{ 0x8293, 0x22247e },
	{ 0x8294, 0x222d2d },
	{ 0x8295, 0x23272b },
	{ 0x8298, 0x222856 },
	{ 0x8299, 0x214f3f },
	{ 0x829a, 0x222855 },
	{ 0x829b, 0x222857 },
	{ 0x829c, 0x232a60 },
	{ 0x829d, 0x214f3e },
	{ 0x829e, 0x22285c },
	{ 0x829f, 0x214f42 },
	{ 0x82a0, 0x222852 },
	{ 0x82a1, 0x222860 },
	{ 0x82a2, 0x222866 },
	{ 0x82a3, 0x214f49 },
	{ 0x82a4, 0x222863 },
	{ 0x82a5, 0x214f46 },
	{ 0x82a6, 0x232a6b },
	{ 0x82a7, 0x222859 },
	{ 0x82a8, 0x22285f },
	{ 0x82a9, 0x222861 },
	{ 0x82aa, 0x232a66 },
	{ 0x82ab, 0x222854 },
	{ 0x82ac, 0x214f45 },
	{ 0x82ad, 0x214f40 },
	{ 0x82ae, 0x22285a },
	{ 0x82af, 0x214f47 },
	{ 0x82b0, 0x214f4a },
	{ 0x82b1, 0x214f44 },
	{ 0x82b2, 0x232a6c },
	{ 0x82b3, 0x214f3d },
	{ 0x82b4, 0x22285e },
	{ 0x82b5, 0x222858 },
	{ 0x82b6, 0x222865 },
	{ 0x82b7, 0x214f4c },
	{ 0x82b8, 0x214f48 },
	{ 0x82b9, 0x214f43 },
	{ 0x82ba, 0x22285d },
	{ 0x82bb, 0x215770 },
	{ 0x82bc, 0x22285b },
	{ 0x82bd, 0x214f41 },
	{ 0x82be, 0x214f4b },
	{ 0x82c0, 0x222853 },
	{ 0x82c2, 0x222862 },
	{ 0x82c3, 0x222864 },
	{ 0x82c4, 0x232a5e },
	{ 0x82c9, 0x232a68 },
	{ 0x82d0, 0x232e76 },
	{ 0x82d1, 0x215345 },
	{ 0x82d2, 0x21533f },
	{ 0x82d3, 0x215347 },
	{ 0x82d4, 0x215344 },
	{ 0x82d5, 0x222d34 },
	{ 0x82d6, 0x222d37 },
	{ 0x82d7, 0x215340 },
	{ 0x82d8, 0x232e6a },
	{ 0x82d9, 0x222d2e },
	{ 0x82db, 0x215339 },
	{ 0x82dc, 0x215343 },
	{ 0x82dd, 0x232e6b },
	{ 0x82de, 0x215346 },
	{ 0x82df, 0x215348 },
	{ 0x82e0, 0x222d43 },
	{ 0x82e1, 0x222d3a },
	{ 0x82e2, 0x232e78 },
	{ 0x82e3, 0x215338 },
	{ 0x82e4, 0x222d42 },
	{ 0x82e5, 0x21533c },
	{ 0x82e6, 0x21533a },
	{ 0x82e7, 0x215335 },
	{ 0x82e8, 0x222d32 },
	{ 0x82e9, 0x232e72 },
	{ 0x82ea, 0x222d41 },
	{ 0x82eb, 0x222d36 },
	{ 0x82ec, 0x222d39 },
	{ 0x82ed, 0x222d46 },
	{ 0x82ee, 0x232e74 },
	{ 0x82ef, 0x215349 },
	{ 0x82f0, 0x222d40 },
	{ 0x82f1, 0x215341 },
	{ 0x82f2, 0x222d3b },
	{ 0x82f3, 0x222d45 },
	{ 0x82f4, 0x222d38 },
	{ 0x82f5, 0x222d3c },
	{ 0x82f6, 0x222d3f },
	{ 0x82f7, 0x232e69 },
	{ 0x82f8, 0x232e6e },
	{ 0x82f9, 0x222d30 },
	{ 0x82fa, 0x222d44 },
	{ 0x82fb, 0x222d3e },
	{ 0x82fc, 0x232e6f },
	{ 0x82fd, 0x232e7a },
	{ 0x82fe, 0x222d2f },
	{ 0x8300, 0x222d33 },
	{ 0x8301, 0x215342 },
	{ 0x8302, 0x21533d },
	{ 0x8303, 0x215336 },
	{ 0x8304, 0x21533b },
	{ 0x8305, 0x215337 },
	{ 0x8306, 0x21534a },
	{ 0x8307, 0x222d31 },
	{ 0x8308, 0x223247 },
	{ 0x8309, 0x21533e },
	{ 0x830b, 0x232e79 },
	{ 0x830c, 0x222d3d },
	{ 0x830d, 0x222942 },
	{ 0x830e, 0x232e77 },
	{ 0x8310, 0x236635 },
	{ 0x8312, 0x236637 },
	{ 0x8316, 0x22324a },
	{ 0x8317, 0x21577e },
	{ 0x8318, 0x233362 },
	{ 0x8319, 0x22323a },
	{ 0x831b, 0x223245 },
	{ 0x831c, 0x223241 },
	{ 0x831d, 0x23384d },
	{ 0x831e, 0x223254 },
	{ 0x831f, 0x233359 },
	{ 0x8320, 0x22324c },
	{ 0x8321, 0x23335f },
	{ 0x8322, 0x223242 },
	{ 0x8323, 0x23385b },
	{ 0x8324, 0x22324b },
	{ 0x8325, 0x22323c },
	{ 0x8326, 0x223240 },
	{ 0x8327, 0x223257 },
	{ 0x8328, 0x215823 },
	{ 0x8329, 0x22324f },
	{ 0x832a, 0x223246 },
	{ 0x832b, 0x215771 },
	{ 0x832c, 0x223255 },
	{ 0x832d, 0x223238 },
	{ 0x832f, 0x22324e },
	{ 0x8331, 0x215822 },
	{ 0x8332, 0x21577b },
	{ 0x8333, 0x223237 },
	{ 0x8334, 0x215779 },
	{ 0x8335, 0x215778 },
	{ 0x8336, 0x21577d },
	{ 0x8337, 0x22324d },
	{ 0x8338, 0x215775 },
	{ 0x8339, 0x21577c },
	{ 0x833a, 0x222d35 },
	{ 0x833b, 0x223f41 },
	{ 0x833c, 0x223248 },
	{ 0x833e, 0x232a5f },
	{ 0x833f, 0x22323e },
	{ 0x8340, 0x215821 },
	{ 0x8341, 0x22323f },
	{ 0x8342, 0x223243 },
	{ 0x8343, 0x215824 },
	{ 0x8344, 0x223239 },
	{ 0x8345, 0x223251 },
	{ 0x8346, 0x233e57 },
	{ 0x8347, 0x223250 },
	{ 0x8348, 0x223258 },
	{ 0x8349, 0x215777 },
	{ 0x834a, 0x215774 },
	{ 0x834b, 0x223256 },
	{ 0x834c, 0x223252 },
	{ 0x834d, 0x223249 },
	{ 0x834e, 0x223244 },
	{ 0x834f, 0x21577a },
	{ 0x8350, 0x215776 },
	{ 0x8351, 0x22323b },
	{ 0x8352, 0x215772 },
	{ 0x8353, 0x223253 },
	{ 0x8354, 0x215773 },
	{ 0x8356, 0x22323d },
	{ 0x8357, 0x23335a },
	{ 0x8358, 0x233363 },
	{ 0x8362, 0x236636 },
	{ 0x8363, 0x232d33 },
	{ 0x8371, 0x23384e },
	{ 0x8372, 0x233851 },
	{ 0x8373, 0x223862 },
	{ 0x8374, 0x223864 },
	{ 0x8375, 0x223869 },
	{ 0x8376, 0x22387d },
	{ 0x8377, 0x215d23 },
	{ 0x8378, 0x215c77 },
	{ 0x8379, 0x233854 },
	{ 0x837a, 0x223861 },
	{ 0x837b, 0x215d24 },
	{ 0x837c, 0x215d25 },
	{ 0x837d, 0x22386c },
	{ 0x837e, 0x223873 },
	{ 0x837f, 0x223879 },
	{ 0x8380, 0x233850 },
	{ 0x8381, 0x223866 },
	{ 0x8383, 0x22386d },
	{ 0x8384, 0x23384f },
	{ 0x8385, 0x23385d },
	{ 0x8386, 0x215d26 },
	{ 0x8387, 0x22387b },
	{ 0x8388, 0x223876 },
	{ 0x8389, 0x215d21 },
	{ 0x838a, 0x215c7d },
	{ 0x838b, 0x223872 },
	{ 0x838c, 0x22386e },
	{ 0x838d, 0x223860 },
	{ 0x838e, 0x215c74 },
	{ 0x838f, 0x223865 },
	{ 0x8390, 0x22385d },
	{ 0x8391, 0x233855 },
	{ 0x8392, 0x215c7c },
	{ 0x8393, 0x215c7e },
	{ 0x8394, 0x22386a },
	{ 0x8395, 0x223867 },
	{ 0x8396, 0x215c79 },
	{ 0x8397, 0x223877 },
	{ 0x8398, 0x215c76 },
	{ 0x8399, 0x223868 },
	{ 0x839a, 0x223f6a },
	{ 0x839b, 0x223870 },
	{ 0x839c, 0x23385e },
	{ 0x839d, 0x22386f },
	{ 0x839e, 0x215c75 },
	{ 0x839f, 0x233857 },
	{ 0x83a0, 0x215d22 },
	{ 0x83a1, 0x233852 },
	{ 0x83a2, 0x215c78 },
	{ 0x83a3, 0x22385e },
	{ 0x83a4, 0x223863 },
	{ 0x83a5, 0x223874 },
	{ 0x83a6, 0x22387a },
	{ 0x83a7, 0x215d27 },
	{ 0x83a8, 0x22385f },
	{ 0x83a9, 0x22386b },
	{ 0x83aa, 0x223871 },
	{ 0x83ab, 0x215c7b },
	{ 0x83ad, 0x233858 },
	{ 0x83ae, 0x22387c },
	{ 0x83af, 0x223875 },
	{ 0x83b0, 0x223878 },
	{ 0x83b7, 0x23385f },
	{ 0x83bd, 0x215c7a },
	{ 0x83bf, 0x223f51 },
	{ 0x83c0, 0x223f45 },
	{ 0x83c1, 0x21615d },
	{ 0x83c2, 0x223f62 },
	{ 0x83c3, 0x223f6b },
	{ 0x83c4, 0x223f6e },
	{ 0x83c5, 0x21615b },
	{ 0x83c6, 0x223f4d },
	{ 0x83c7, 0x223f66 },
	{ 0x83c8, 0x223f4e },
	{ 0x83c9, 0x223f5c },
	{ 0x83ca, 0x216168 },
	{ 0x83cb, 0x223f58 },
	{ 0x83cc, 0x216165 },
	{ 0x83cd, 0x233e5e },
	{ 0x83ce, 0x223f59 },
	{ 0x83cf, 0x223f42 },
	{ 0x83d1, 0x223f67 },
	{ 0x83d2, 0x233e4f },
	{ 0x83d3, 0x233e59 },
	{ 0x83d4, 0x21616e },
	{ 0x83d5, 0x223f64 },
	{ 0x83d6, 0x223f5a },
	{ 0x83d7, 0x223f70 },
	{ 0x83d8, 0x223f55 },
	{ 0x83d9, 0x22466d },
	{ 0x83da, 0x233e4d },
	{ 0x83db, 0x223f73 },
	{ 0x83dc, 0x21616c },
	{ 0x83dd, 0x223f53 },
	{ 0x83de, 0x223f5f },
	{ 0x83df, 0x21616f },
	{ 0x83e0, 0x21615a },
	{ 0x83e1, 0x223f57 },
	{ 0x83e2, 0x223f71 },
	{ 0x83e3, 0x223f50 },
	{ 0x83e4, 0x223f49 },
	{ 0x83e5, 0x223f54 },
	{ 0x83e6, 0x233e5f },
	{ 0x83e7, 0x223f48 },
	{ 0x83e8, 0x223f46 },
	{ 0x83e9, 0x216156 },
	{ 0x83ea, 0x223f68 },
	{ 0x83eb, 0x223f4f },
	{ 0x83ec, 0x223f6c },
	{ 0x83ed, 0x233e4b },
	{ 0x83ee, 0x223f6d },
	{ 0x83ef, 0x21615e },
	{ 0x83f0, 0x216163 },
	{ 0x83f1, 0x21615f },
	{ 0x83f2, 0x216167 },
	{ 0x83f3, 0x223f63 },
	{ 0x83f4, 0x216160 },
	{ 0x83f5, 0x223f5b },
	{ 0x83f6, 0x223f4b },
	{ 0x83f8, 0x216158 },
	{ 0x83f9, 0x223f43 },
	{ 0x83fa, 0x223f65 },
	{ 0x83fb, 0x223f6f },
	{ 0x83fc, 0x223f4a },
	{ 0x83fd, 0x216166 },
	{ 0x83fe, 0x223f74 },
	{ 0x83ff, 0x223f56 },
	{ 0x8400, 0x233e52 },
	{ 0x8401, 0x223f52 },
	{ 0x8402, 0x233e5c },
	{ 0x8403, 0x216157 },
	{ 0x8404, 0x21616b },
	{ 0x8405, 0x233e5a },
	{ 0x8406, 0x223f61 },
	{ 0x8407, 0x21616d },
	{ 0x8408, 0x233e50 },
	{ 0x8409, 0x223f5d },
	{ 0x840a, 0x216162 },
	{ 0x840b, 0x21615c },
	{ 0x840c, 0x216164 },
	{ 0x840d, 0x216159 },
	{ 0x840e, 0x21616a },
	{ 0x840f, 0x223f5e },
	{ 0x8410, 0x223f4c },
	{ 0x8411, 0x223f60 },
	{ 0x8412, 0x223f47 },
	{ 0x8413, 0x223f69 },
	{ 0x8414, 0x233e58 },
	{ 0x8416, 0x233e5d },
	{ 0x8417, 0x233e56 },
	{ 0x8418, 0x233e4e },
	{ 0x841b, 0x223f72 },
	{ 0x841e, 0x236639 },
	{ 0x841f, 0x233e5b },
	{ 0x8421, 0x236638 },
	{ 0x8423, 0x223f44 },
	{ 0x8429, 0x22466c },
	{ 0x842a, 0x23442d },
	{ 0x842b, 0x224724 },
	{ 0x842c, 0x21655c },
	{ 0x842d, 0x224671 },
	{ 0x842e, 0x234431 },
	{ 0x842f, 0x22466f },
	{ 0x8430, 0x22465a },
	{ 0x8431, 0x216630 },
	{ 0x8432, 0x22466a },
	{ 0x8433, 0x22467e },
	{ 0x8434, 0x224666 },
	{ 0x8435, 0x216638 },
	{ 0x8436, 0x22467d },
	{ 0x8437, 0x224664 },
	{ 0x8438, 0x216169 },
	{ 0x8439, 0x224674 },
	{ 0x843a, 0x224665 },
	{ 0x843b, 0x22467b },
	{ 0x843c, 0x216637 },
	{ 0x843d, 0x21662f },
	{ 0x843e, 0x23443a },
	{ 0x843f, 0x22464f },
	{ 0x8440, 0x224657 },
	{ 0x8441, 0x234435 },
	{ 0x8442, 0x224670 },
	{ 0x8443, 0x224668 },
	{ 0x8444, 0x224723 },
	{ 0x8445, 0x22466b },
	{ 0x8446, 0x21663d },
	{ 0x8447, 0x22467c },
	{ 0x8448, 0x23442c },
	{ 0x8449, 0x216634 },
	{ 0x844a, 0x23443e },
	{ 0x844b, 0x22466e },
	{ 0x844c, 0x224676 },
	{ 0x844d, 0x22465b },
	{ 0x844e, 0x224675 },
	{ 0x844f, 0x234427 },
	{ 0x8450, 0x224728 },
	{ 0x8451, 0x224656 },
	{ 0x8452, 0x224677 },
	{ 0x8453, 0x234433 },
	{ 0x8454, 0x224726 },
	{ 0x8455, 0x23443f },
	{ 0x8456, 0x224650 },
	{ 0x8457, 0x216161 },
	{ 0x8458, 0x234440 },
	{ 0x8459, 0x22465e },
	{ 0x845a, 0x22465d },
	{ 0x845b, 0x216636 },
	{ 0x845c, 0x234432 },
	{ 0x845d, 0x224661 },
	{ 0x845e, 0x224663 },
	{ 0x845f, 0x224672 },
	{ 0x8460, 0x224725 },
	{ 0x8461, 0x216639 },
	{ 0x8462, 0x234438 },
	{ 0x8463, 0x21663a },
	{ 0x8464, 0x234430 },
	{ 0x8465, 0x224655 },
	{ 0x8466, 0x216632 },
	{ 0x8467, 0x224659 },
	{ 0x8468, 0x224721 },
	{ 0x8469, 0x21663b },
	{ 0x846b, 0x216633 },
	{ 0x846c, 0x216635 },
	{ 0x846d, 0x21663c },
	{ 0x846e, 0x224727 },
	{ 0x846f, 0x224678 },
	{ 0x8470, 0x224673 },
	{ 0x8471, 0x23443c },
	{ 0x8472, 0x23442f },
	{ 0x8473, 0x224660 },
	{ 0x8474, 0x22465f },
	{ 0x8475, 0x216631 },
	{ 0x8476, 0x224651 },
	{ 0x8477, 0x21662e },
	{ 0x8478, 0x224669 },
	{ 0x8479, 0x224652 },
	{ 0x847a, 0x224667 },
	{ 0x847b, 0x23442e },
	{ 0x847d, 0x22465c },
	{ 0x847e, 0x224722 },
	{ 0x847f, 0x23442a },
	{ 0x8480, 0x234439 },
	{ 0x8482, 0x21662d },
	{ 0x8483, 0x23443b },
	{ 0x8484, 0x234428 },
	{ 0x8486, 0x224658 },
	{ 0x848d, 0x224654 },
	{ 0x848e, 0x22467a },
	{ 0x848f, 0x224653 },
	{ 0x8490, 0x216a68 },
	{ 0x8491, 0x224d5a },
	{ 0x8492, 0x234935 },
	{ 0x8493, 0x234944 },
	{ 0x8494, 0x224d49 },
	{ 0x8495, 0x234933 },
	{ 0x8496, 0x234938 },
	{ 0x8497, 0x224d33 },
	{ 0x8498, 0x224d51 },
	{ 0x8499, 0x216a60 },
	{ 0x849a, 0x224d42 },
	{ 0x849b, 0x224d4c },
	{ 0x849c, 0x216a63 },
	{ 0x849d, 0x224d45 },
	{ 0x849e, 0x216a61 },
	{ 0x849f, 0x224d36 },
	{ 0x84a0, 0x224d54 },
	{ 0x84a1, 0x224d35 },
	{ 0x84a2, 0x224d48 },
	{ 0x84a3, 0x23493c },
	{ 0x84a4, 0x224d34 },
	{ 0x84a5, 0x234939 },
	{ 0x84a7, 0x224d46 },
	{ 0x84a8, 0x224d4f },
	{ 0x84a9, 0x224d4d },
	{ 0x84aa, 0x224d41 },
	{ 0x84ab, 0x224d3c },
	{ 0x84ac, 0x224d3a },
	{ 0x84ad, 0x234942 },
	{ 0x84ae, 0x224d3b },
	{ 0x84af, 0x224d4e },
	{ 0x84b0, 0x224d59 },
	{ 0x84b1, 0x224d43 },
	{ 0x84b2, 0x216a62 },
	{ 0x84b3, 0x23493b },
	{ 0x84b4, 0x224d3e },
	{ 0x84b5, 0x23493a },
	{ 0x84b6, 0x224d52 },
	{ 0x84b7, 0x234941 },
	{ 0x84b8, 0x216a65 },
	{ 0x84b9, 0x224d3d },
	{ 0x84ba, 0x224d37 },
	{ 0x84bb, 0x224d47 },
	{ 0x84bc, 0x216a69 },
	{ 0x84bd, 0x234932 },
	{ 0x84bf, 0x216a5d },
	{ 0x84c0, 0x216a66 },
	{ 0x84c1, 0x224d3f },
	{ 0x84c2, 0x224d39 },
	{ 0x84c3, 0x234936 },
	{ 0x84c4, 0x216a5f },
	{ 0x84c5, 0x224679 },
	{ 0x84c6, 0x216a5e },
	{ 0x84c7, 0x224d4a },
	{ 0x84c8, 0x234436 },
	{ 0x84c9, 0x216a5c },
	{ 0x84ca, 0x216a6b },
	{ 0x84cb, 0x216a64 },
	{ 0x84cc, 0x224d4b },
	{ 0x84cd, 0x224d40 },
	{ 0x84ce, 0x224d38 },
	{ 0x84cf, 0x224d53 },
	{ 0x84d0, 0x224d44 },
	{ 0x84d1, 0x216a6a },
	{ 0x84d2, 0x224d57 },
	{ 0x84d3, 0x216a67 },
	{ 0x84d4, 0x224d56 },
	{ 0x84d5, 0x23493f },
	{ 0x84d6, 0x224d50 },
	{ 0x84d7, 0x224d55 },
	{ 0x84d8, 0x23493e },
	{ 0x84da, 0x234943 },
	{ 0x84db, 0x224d58 },
	{ 0x84de, 0x23663b },
	{ 0x84e1, 0x23663c },
	{ 0x84e2, 0x23663a },
	{ 0x84e4, 0x23493d },
	{ 0x84e7, 0x22535c },
	{ 0x84e8, 0x22535d },
	{ 0x84e9, 0x225350 },
	{ 0x84ea, 0x22534f },
	{ 0x84eb, 0x22534b },
	{ 0x84ec, 0x216e5d },
	{ 0x84ed, 0x234e4f },
	{ 0x84ee, 0x216e55 },
	{ 0x84ef, 0x22535f },
	{ 0x84f0, 0x22535e },
	{ 0x84f1, 0x22464e },
	{ 0x84f2, 0x225348 },
	{ 0x84f3, 0x22534c },
	{ 0x84f4, 0x225346 },
	{ 0x84f5, 0x234e44 },
	{ 0x84f6, 0x225359 },
	{ 0x84f7, 0x22534a },
	{ 0x84f8, 0x234e42 },
	{ 0x84f9, 0x225360 },
	{ 0x84fa, 0x225343 },
	{ 0x84fb, 0x225341 },
	{ 0x84fc, 0x22534d },
	{ 0x84fd, 0x225357 },
	{ 0x84fe, 0x225352 },
	{ 0x84ff, 0x216e5f },
	{ 0x8500, 0x225338 },
	{ 0x8501, 0x234e40 },
	{ 0x8502, 0x225356 },
	{ 0x8503, 0x234e4c },
	{ 0x8504, 0x234e46 },
	{ 0x8505, 0x234e54 },
	{ 0x8506, 0x216e60 },
	{ 0x8507, 0x224662 },
	{ 0x8508, 0x225344 },
	{ 0x8509, 0x22533b },
	{ 0x850a, 0x22533e },
	{ 0x850b, 0x225364 },
	{ 0x850c, 0x225345 },
	{ 0x850d, 0x22533c },
	{ 0x850e, 0x22533a },
	{ 0x850f, 0x225337 },
	{ 0x8511, 0x216e59 },
	{ 0x8512, 0x22534e },
	{ 0x8513, 0x216e58 },
	{ 0x8514, 0x216e5c },
	{ 0x8515, 0x225349 },
	{ 0x8516, 0x225351 },
	{ 0x8517, 0x216e52 },
	{ 0x8518, 0x225361 },
	{ 0x8519, 0x225365 },
	{ 0x851a, 0x216e54 },
	{ 0x851b, 0x234e4b },
	{ 0x851c, 0x225340 },
	{ 0x851d, 0x225354 },
	{ 0x851e, 0x225358 },
	{ 0x851f, 0x22533d },
	{ 0x8520, 0x225362 },
	{ 0x8521, 0x216e5b },
	{ 0x8523, 0x216e5a },
	{ 0x8524, 0x225335 },
	{ 0x8525, 0x216e5e },
	{ 0x8526, 0x22535b },
	{ 0x8527, 0x22533f },
	{ 0x8528, 0x225353 },
	{ 0x8529, 0x225339 },
	{ 0x852a, 0x225347 },
	{ 0x852b, 0x225342 },
	{ 0x852c, 0x216e56 },
	{ 0x852d, 0x216e57 },
	{ 0x852e, 0x225355 },
	{ 0x852f, 0x225366 },
	{ 0x8530, 0x225363 },
	{ 0x8531, 0x22535a },
	{ 0x8533, 0x234e4d },
	{ 0x8534, 0x234e4e },
	{ 0x8535, 0x234e52 },
	{ 0x853b, 0x225336 },
	{ 0x853d, 0x216e53 },
	{ 0x853e, 0x225974 },
	{ 0x853f, 0x23525a },
	{ 0x8540, 0x22596b },
	{ 0x8541, 0x22596e },
	{ 0x8542, 0x235252 },
	{ 0x8543, 0x217225 },
	{ 0x8544, 0x225970 },
	{ 0x8545, 0x225965 },
	{ 0x8546, 0x22596c },
	{ 0x8547, 0x225972 },
	{ 0x8548, 0x217222 },
	{ 0x8549, 0x217226 },
	{ 0x854a, 0x21717e },
	{ 0x854b, 0x235259 },
	{ 0x854c, 0x235250 },
	{ 0x854d, 0x225967 },
	{ 0x854e, 0x225977 },
	{ 0x8551, 0x225971 },
	{ 0x8553, 0x225968 },
	{ 0x8554, 0x225a22 },
	{ 0x8555, 0x22597a },
	{ 0x8556, 0x225964 },
	{ 0x8557, 0x225e72 },
	{ 0x8558, 0x22596a },
	{ 0x8559, 0x217221 },
	{ 0x855a, 0x235258 },
	{ 0x855b, 0x225975 },
	{ 0x855c, 0x235254 },
	{ 0x855d, 0x225a21 },
	{ 0x855e, 0x217229 },
	{ 0x855f, 0x235256 },
	{ 0x8560, 0x22597c },
	{ 0x8561, 0x225969 },
	{ 0x8562, 0x22596f },
	{ 0x8563, 0x225973 },
	{ 0x8564, 0x22596d },
	{ 0x8565, 0x225a23 },
	{ 0x8566, 0x22597e },
	{ 0x8567, 0x22597b },
	{ 0x8568, 0x217223 },
	{ 0x8569, 0x217224 },
	{ 0x856a, 0x217228 },
	{ 0x856b, 0x225966 },
	{ 0x856c, 0x225a24 },
	{ 0x856d, 0x217227 },
	{ 0x856e, 0x225978 },
	{ 0x856f, 0x23524f },
	{ 0x8570, 0x235255 },
	{ 0x8571, 0x225976 },
	{ 0x8573, 0x23663d },
	{ 0x8575, 0x225979 },
	{ 0x8576, 0x225f21 },
	{ 0x8577, 0x225e6c },
	{ 0x8578, 0x225e71 },
	{ 0x8579, 0x225e7e },
	{ 0x857a, 0x225e70 },
	{ 0x857b, 0x225e68 },
	{ 0x857c, 0x225e6d },
	{ 0x857e, 0x21752c },
	{ 0x857f, 0x23562b },
	{ 0x8580, 0x225e61 },
	{ 0x8581, 0x225e79 },
	{ 0x8582, 0x225e7b },
	{ 0x8583, 0x225e60 },
	{ 0x8584, 0x21752b },
	{ 0x8585, 0x225e7d },
	{ 0x8586, 0x225e75 },
	{ 0x8587, 0x217532 },
	{ 0x8588, 0x225e7c },
	{ 0x8589, 0x225e6e },
	{ 0x858a, 0x217534 },
	{ 0x858b, 0x225e66 },
	{ 0x858c, 0x22597d },
	{ 0x858d, 0x225e76 },
	{ 0x858e, 0x225e73 },
	{ 0x858f, 0x225e62 },
	{ 0x8590, 0x225f23 },
	{ 0x8591, 0x21752e },
	{ 0x8592, 0x235628 },
	{ 0x8593, 0x235629 },
	{ 0x8594, 0x21752f },
	{ 0x8595, 0x225e64 },
	{ 0x8596, 0x225e74 },
	{ 0x8597, 0x23562d },
	{ 0x8598, 0x225f22 },
	{ 0x8599, 0x225e77 },
	{ 0x859a, 0x225e6a },
	{ 0x859b, 0x217531 },
	{ 0x859c, 0x21752d },
	{ 0x859d, 0x225e78 },
	{ 0x859e, 0x225e6b },
	{ 0x859f, 0x225f24 },
	{ 0x85a0, 0x225e65 },
	{ 0x85a1, 0x225e6f },
	{ 0x85a2, 0x225e7a },
	{ 0x85a3, 0x225e67 },
	{ 0x85a4, 0x225e69 },
	{ 0x85a6, 0x217535 },
	{ 0x85a7, 0x225e63 },
	{ 0x85a8, 0x217533 },
	{ 0x85a9, 0x217730 },
	{ 0x85aa, 0x21752a },
	{ 0x85ab, 0x23562c },
	{ 0x85ac, 0x235630 },
	{ 0x85af, 0x217530 },
	{ 0x85b0, 0x217734 },
	{ 0x85b1, 0x22627d },
	{ 0x85b2, 0x23586c },
	{ 0x85b3, 0x226273 },
	{ 0x85b4, 0x22626e },
	{ 0x85b5, 0x226274 },
	{ 0x85b6, 0x22627e },
	{ 0x85b7, 0x226324 },
	{ 0x85b8, 0x226323 },
	{ 0x85b9, 0x217736 },
	{ 0x85ba, 0x217735 },
	{ 0x85bb, 0x23586e },
	{ 0x85bd, 0x226275 },
	{ 0x85be, 0x226325 },
	{ 0x85bf, 0x226278 },
	{ 0x85c0, 0x226270 },
	{ 0x85c1, 0x23586f },
	{ 0x85c2, 0x226272 },
	{ 0x85c3, 0x226271 },
	{ 0x85c4, 0x226277 },
	{ 0x85c5, 0x22627c },
	{ 0x85c6, 0x22626f },
	{ 0x85c7, 0x226276 },
	{ 0x85c8, 0x22627b },
	{ 0x85c9, 0x217733 },
	{ 0x85cb, 0x226279 },
	{ 0x85cc, 0x23586b },
	{ 0x85cd, 0x217731 },
	{ 0x85ce, 0x22627a },
	{ 0x85cf, 0x21772f },
	{ 0x85d0, 0x217732 },
	{ 0x85d1, 0x226660 },
	{ 0x85d2, 0x226321 },
	{ 0x85d4, 0x23663e },
	{ 0x85d5, 0x21786d },
	{ 0x85d6, 0x235a7e },
	{ 0x85d7, 0x226658 },
	{ 0x85d8, 0x22665c },
	{ 0x85d9, 0x226654 },
	{ 0x85da, 0x226657 },
	{ 0x85db, 0x235a7d },
	{ 0x85dc, 0x22665f },
	{ 0x85dd, 0x21786b },
	{ 0x85de, 0x226664 },
	{ 0x85df, 0x22665d },
	{ 0x85e1, 0x226655 },
	{ 0x85e2, 0x226665 },
	{ 0x85e3, 0x22665e },
	{ 0x85e4, 0x21786e },
	{ 0x85e5, 0x21786f },
	{ 0x85e6, 0x226662 },
	{ 0x85e7, 0x235b22 },
	{ 0x85e8, 0x226656 },
	{ 0x85e9, 0x21786a },
	{ 0x85ea, 0x21786c },
	{ 0x85eb, 0x226651 },
	{ 0x85ec, 0x226659 },
	{ 0x85ed, 0x226653 },
	{ 0x85ee, 0x235c7b },
	{ 0x85ef, 0x226663 },
	{ 0x85f0, 0x226661 },
	{ 0x85f1, 0x226652 },
	{ 0x85f2, 0x22665a },
	{ 0x85f4, 0x235b25 },
	{ 0x85f5, 0x23663f },
	{ 0x85f6, 0x22696a },
	{ 0x85f7, 0x217870 },
	{ 0x85f8, 0x22665b },
	{ 0x85f9, 0x217a32 },
	{ 0x85fa, 0x217a34 },
	{ 0x85fb, 0x217a31 },
	{ 0x85fc, 0x235c76 },
	{ 0x85fd, 0x22696f },
	{ 0x85fe, 0x226967 },
	{ 0x85ff, 0x226965 },
	{ 0x8600, 0x226969 },
	{ 0x8601, 0x226966 },
	{ 0x8602, 0x235c78 },
	{ 0x8603, 0x235c7c },
	{ 0x8604, 0x22696b },
	{ 0x8605, 0x22696d },
	{ 0x8606, 0x217a35 },
	{ 0x8607, 0x217a37 },
	{ 0x8608, 0x235d22 },
	{ 0x8609, 0x22696c },
	{ 0x860a, 0x217a38 },
	{ 0x860b, 0x217a36 },
	{ 0x860c, 0x22696e },
	{ 0x860d, 0x235c7e },
	{ 0x860f, 0x235d23 },
	{ 0x8610, 0x235c77 },
	{ 0x8611, 0x217a33 },
	{ 0x8613, 0x235d21 },
	{ 0x8615, 0x235e5b },
	{ 0x8616, 0x235e5a },
	{ 0x8617, 0x217b21 },
	{ 0x8618, 0x226c21 },
	{ 0x8619, 0x226c27 },
	{ 0x861a, 0x217b23 },
	{ 0x861b, 0x226968 },
	{ 0x861c, 0x226c26 },
	{ 0x861d, 0x235e5c },
	{ 0x861e, 0x226c2d },
	{ 0x861f, 0x226c24 },
	{ 0x8620, 0x226c2b },
	{ 0x8621, 0x226c2a },
	{ 0x8622, 0x226964 },
	{ 0x8623, 0x226c25 },
	{ 0x8624, 0x226322 },
	{ 0x8625, 0x226c2e },
	{ 0x8626, 0x226c23 },
	{ 0x8627, 0x226c28 },
	{ 0x8628, 0x235e58 },
	{ 0x8629, 0x226c2c },
	{ 0x862a, 0x226c22 },
	{ 0x862b, 0x235e56 },
	{ 0x862c, 0x226d77 },
	{ 0x862d, 0x217b22 },
	{ 0x862e, 0x226c29 },
	{ 0x862f, 0x235e57 },
	{ 0x8631, 0x226f43 },
	{ 0x8632, 0x226d78 },
	{ 0x8633, 0x226d76 },
	{ 0x8634, 0x226d74 },
	{ 0x8635, 0x226d75 },
	{ 0x8636, 0x226d79 },
	{ 0x8637, 0x236640 },
	{ 0x8638, 0x217c45 },
	{ 0x8639, 0x226f41 },
	{ 0x863a, 0x226f3f },
	{ 0x863b, 0x226f44 },
	{ 0x863c, 0x226f42 },
	{ 0x863d, 0x236043 },
	{ 0x863e, 0x226f45 },
	{ 0x863f, 0x217c46 },
	{ 0x8640, 0x226f40 },
	{ 0x8641, 0x23602f },
	{ 0x8642, 0x236146 },
	{ 0x8643, 0x22704a },
	{ 0x8645, 0x236641 },
	{ 0x8646, 0x227134 },
	{ 0x8647, 0x227135 },
	{ 0x8648, 0x227136 },
	{ 0x8649, 0x236147 },
	{ 0x864a, 0x23617c },
	{ 0x864b, 0x227235 },
	{ 0x864c, 0x22722d },
	{ 0x864d, 0x22226f },
	{ 0x864e, 0x214f4d },
	{ 0x8650, 0x21534b },
	{ 0x8652, 0x22325a },
	{ 0x8653, 0x223259 },
	{ 0x8654, 0x215825 },
	{ 0x8655, 0x215d28 },
	{ 0x8656, 0x223921 },
	{ 0x8657, 0x233863 },
	{ 0x8658, 0x233860 },
	{ 0x8659, 0x22387e },
	{ 0x865a, 0x233861 },
	{ 0x865b, 0x216170 },
	{ 0x865c, 0x21663f },
	{ 0x865d, 0x233e61 },
	{ 0x865e, 0x21663e },
	{ 0x865f, 0x216640 },
	{ 0x8661, 0x224d5b },
	{ 0x8662, 0x225367 },
	{ 0x8663, 0x225a25 },
	{ 0x8664, 0x225a27 },
	{ 0x8665, 0x225a26 },
	{ 0x8667, 0x217536 },
	{ 0x8668, 0x225f25 },
	{ 0x8669, 0x226326 },
	{ 0x866a, 0x227173 },
	{ 0x866b, 0x214865 },
	{ 0x866c, 0x23272d },
	{ 0x866d, 0x222869 },
	{ 0x866e, 0x22286a },
	{ 0x866f, 0x222868 },
	{ 0x8670, 0x222867 },
	{ 0x8671, 0x214f4e },
	{ 0x8672, 0x236642 },
	{ 0x8673, 0x222d4a },
	{ 0x8674, 0x222d48 },
	{ 0x8675, 0x232f23 },
	{ 0x8676, 0x232e7c },
	{ 0x8677, 0x222d47 },
	{ 0x8678, 0x232e7e },
	{ 0x8679, 0x21534c },
	{ 0x867a, 0x21534e },
	{ 0x867b, 0x21534d },
	{ 0x867c, 0x222d49 },
	{ 0x867d, 0x232f24 },
	{ 0x8684, 0x233369 },
	{ 0x8685, 0x223266 },
	{ 0x8686, 0x223263 },
	{ 0x8687, 0x223261 },
	{ 0x8689, 0x23336c },
	{ 0x868a, 0x215826 },
	{ 0x868b, 0x223264 },
	{ 0x868c, 0x21582b },
	{ 0x868d, 0x22325e },
	{ 0x868e, 0x22326d },
	{ 0x868f, 0x23336f },
	{ 0x8690, 0x22326f },
	{ 0x8691, 0x22325f },
	{ 0x8692, 0x23336e },
	{ 0x8693, 0x215828 },
	{ 0x8694, 0x223270 },
	{ 0x8695, 0x22326b },
	{ 0x8696, 0x22325d },
	{ 0x8697, 0x223262 },
	{ 0x8698, 0x22326c },
	{ 0x8699, 0x223268 },
	{ 0x869a, 0x223265 },
	{ 0x869b, 0x23336b },
	{ 0x869c, 0x21582d },
	{ 0x869d, 0x22326e },
	{ 0x869e, 0x223260 },
	{ 0x869f, 0x23336a },
	{ 0x86a0, 0x233370 },
	{ 0x86a1, 0x223269 },
	{ 0x86a2, 0x22325b },
	{ 0x86a3, 0x21582c },
	{ 0x86a4, 0x215829 },
	{ 0x86a5, 0x223267 },
	{ 0x86a6, 0x23336d },
	{ 0x86a7, 0x22326a },
	{ 0x86a8, 0x22325c },
	{ 0x86a9, 0x21582a },
	{ 0x86aa, 0x215827 },
	{ 0x86ae, 0x233866 },
	{ 0x86af, 0x215d32 },
	{ 0x86b0, 0x223928 },
	{ 0x86b1, 0x215d31 },
	{ 0x86b2, 0x233864 },
	{ 0x86b3, 0x22392b },
	{ 0x86b4, 0x22392e },
	{ 0x86b5, 0x215d2e },
	{ 0x86b6, 0x215d2c },
	{ 0x86b7, 0x223923 },
	{ 0x86b8, 0x22392c },
	{ 0x86b9, 0x22392a },
	{ 0x86ba, 0x223927 },
	{ 0x86bb, 0x22392f },
	{ 0x86bc, 0x223930 },
	{ 0x86bd, 0x223932 },
	{ 0x86be, 0x223933 },
	{ 0x86bf, 0x223922 },
	{ 0x86c0, 0x215d2b },
	{ 0x86c1, 0x223925 },
	{ 0x86c2, 0x223924 },
	{ 0x86c3, 0x223931 },
	{ 0x86c4, 0x215d2d },
	{ 0x86c5, 0x223926 },
	{ 0x86c6, 0x215d2f },
	{ 0x86c7, 0x215d2a },
	{ 0x86c8, 0x223929 },
	{ 0x86c9, 0x215d33 },
	{ 0x86cb, 0x215d30 },
	{ 0x86cc, 0x22392d },
	{ 0x86d0, 0x216177 },
	{ 0x86d1, 0x224025 },
	{ 0x86d3, 0x223f78 },
	{ 0x86d4, 0x216174 },
	{ 0x86d5, 0x233e62 },
	{ 0x86d6, 0x22472e },
	{ 0x86d7, 0x224023 },
	{ 0x86d8, 0x223f75 },
	{ 0x86d9, 0x216172 },
	{ 0x86da, 0x223f7a },
	{ 0x86db, 0x216175 },
	{ 0x86dc, 0x223f7e },
	{ 0x86dd, 0x223f7c },
	{ 0x86de, 0x216178 },
	{ 0x86df, 0x216171 },
	{ 0x86e1, 0x233e63 },
	{ 0x86e2, 0x223f76 },
	{ 0x86e3, 0x223f79 },
	{ 0x86e4, 0x216176 },
	{ 0x86e6, 0x223f77 },
	{ 0x86e8, 0x224024 },
	{ 0x86e9, 0x224022 },
	{ 0x86ea, 0x223f7b },
	{ 0x86eb, 0x223f7d },
	{ 0x86ec, 0x224021 },
	{ 0x86ed, 0x216173 },
	{ 0x86ee, 0x233e68 },
	{ 0x86f5, 0x22472f },
	{ 0x86f6, 0x224735 },
	{ 0x86f7, 0x22472b },
	{ 0x86f8, 0x224731 },
	{ 0x86f9, 0x216641 },
	{ 0x86fa, 0x22472d },
	{ 0x86fb, 0x216647 },
	{ 0x86fc, 0x234444 },
	{ 0x86fd, 0x234445 },
	{ 0x86fe, 0x216646 },
	{ 0x86ff, 0x234449 },
	{ 0x8700, 0x216645 },
	{ 0x8701, 0x224734 },
	{ 0x8702, 0x216648 },
	{ 0x8703, 0x216649 },
	{ 0x8704, 0x22472a },
	{ 0x8705, 0x224737 },
	{ 0x8706, 0x21664a },
	{ 0x8707, 0x216644 },
	{ 0x8708, 0x216643 },
	{ 0x8709, 0x224733 },
	{ 0x870a, 0x21664b },
	{ 0x870b, 0x224729 },
	{ 0x870c, 0x22472c },
	{ 0x870d, 0x224736 },
	{ 0x870e, 0x224732 },
	{ 0x8711, 0x224d7b },
	{ 0x8712, 0x224d70 },
	{ 0x8713, 0x216642 },
	{ 0x8715, 0x234446 },
	{ 0x8716, 0x234448 },
	{ 0x8718, 0x216a72 },
	{ 0x8719, 0x224d64 },
	{ 0x871a, 0x224d79 },
	{ 0x871b, 0x224d65 },
	{ 0x871c, 0x216a6d },
	{ 0x871d, 0x23494f },
	{ 0x871e, 0x224d62 },
	{ 0x8720, 0x224d6b },
	{ 0x8721, 0x224d63 },
	{ 0x8722, 0x216a6f },
	{ 0x8723, 0x224d5d },
	{ 0x8724, 0x224d78 },
	{ 0x8725, 0x216a70 },
	{ 0x8726, 0x224d75 },
	{ 0x8727, 0x224d76 },
	{ 0x8728, 0x224d5e },
	{ 0x8729, 0x216a75 },
	{ 0x872a, 0x224d6d },
	{ 0x872b, 0x23494a },
	{ 0x872c, 0x224d67 },
	{ 0x872d, 0x224d6e },
	{ 0x872e, 0x224d61 },
	{ 0x8730, 0x224d7a },
	{ 0x8731, 0x224d72 },
	{ 0x8732, 0x224d6c },
	{ 0x8733, 0x224d5c },
	{ 0x8734, 0x216a71 },
	{ 0x8735, 0x224d73 },
	{ 0x8736, 0x234945 },
	{ 0x8737, 0x216a74 },
	{ 0x8738, 0x224d77 },
	{ 0x8739, 0x23494c },
	{ 0x873a, 0x224d71 },
	{ 0x873b, 0x216a6e },
	{ 0x873c, 0x224d6f },
	{ 0x873d, 0x234949 },
	{ 0x873e, 0x224d69 },
	{ 0x873f, 0x216a6c },
	{ 0x8740, 0x224d60 },
	{ 0x8741, 0x224d68 },
	{ 0x8742, 0x224d74 },
	{ 0x8743, 0x224d66 },
	{ 0x8745, 0x23494e },
	{ 0x8746, 0x224d6a },
	{ 0x8747, 0x23494b },
	{ 0x874a, 0x236643 },
	{ 0x874c, 0x216e6a },
	{ 0x874d, 0x224730 },
	{ 0x874e, 0x225379 },
	{ 0x874f, 0x225424 },
	{ 0x8750, 0x225378 },
	{ 0x8751, 0x225374 },
	{ 0x8752, 0x225371 },
	{ 0x8753, 0x216e6b },
	{ 0x8754, 0x22536f },
	{ 0x8755, 0x216a73 },
	{ 0x8756, 0x225368 },
	{ 0x8757, 0x216e69 },
	{ 0x8758, 0x22536e },
	{ 0x8759, 0x216e68 },
	{ 0x875a, 0x225373 },
	{ 0x875b, 0x225370 },
	{ 0x875c, 0x225422 },
	{ 0x875d, 0x22537b },
	{ 0x875e, 0x225375 },
	{ 0x875f, 0x22537a },
	{ 0x8760, 0x216e64 },
	{ 0x8761, 0x225372 },
	{ 0x8762, 0x225427 },
	{ 0x8763, 0x225369 },
	{ 0x8764, 0x22536a },
	{ 0x8765, 0x225423 },
	{ 0x8766, 0x216e65 },
	{ 0x8767, 0x225428 },
	{ 0x8768, 0x216e67 },
	{ 0x8769, 0x225429 },
	{ 0x876a, 0x225377 },
	{ 0x876b, 0x224d5f },
	{ 0x876c, 0x22537d },
	{ 0x876d, 0x225376 },
	{ 0x876e, 0x225421 },
	{ 0x876f, 0x22537c },
	{ 0x8771, 0x234e5d },
	{ 0x8773, 0x22536d },
	{ 0x8774, 0x216e62 },
	{ 0x8775, 0x225426 },
	{ 0x8776, 0x216e63 },
	{ 0x8777, 0x22536b },
	{ 0x8778, 0x216e66 },
	{ 0x8779, 0x225a32 },
	{ 0x877a, 0x22537e },
	{ 0x877b, 0x225425 },
	{ 0x877d, 0x234e59 },
	{ 0x8781, 0x225a2f },
	{ 0x8782, 0x216e61 },
	{ 0x8783, 0x21722a },
	{ 0x8784, 0x225a39 },
	{ 0x8785, 0x225a35 },
	{ 0x8787, 0x225a33 },
	{ 0x8788, 0x225a2e },
	{ 0x8789, 0x225a3d },
	{ 0x878a, 0x23525b },
	{ 0x878b, 0x23525d },
	{ 0x878d, 0x21722e },
	{ 0x878e, 0x23525f },
	{ 0x878f, 0x225a2a },
	{ 0x8790, 0x225a36 },
	{ 0x8791, 0x225a37 },
	{ 0x8792, 0x225a2d },
	{ 0x8793, 0x225a2c },
	{ 0x8794, 0x225a3a },
	{ 0x8796, 0x225a30 },
	{ 0x8797, 0x225a2b },
	{ 0x8798, 0x225a31 },
	{ 0x8799, 0x235262 },
	{ 0x879a, 0x225a3c },
	{ 0x879b, 0x225a29 },
	{ 0x879c, 0x225a3b },
	{ 0x879d, 0x225a38 },
	{ 0x879e, 0x21722c },
	{ 0x879f, 0x21722b },
	{ 0x87a1, 0x23525e },
	{ 0x87a2, 0x21722d },
	{ 0x87a3, 0x225a34 },
	{ 0x87a4, 0x225a28 },
	{ 0x87a5, 0x236645 },
	{ 0x87a9, 0x236644 },
	{ 0x87aa, 0x225f27 },
	{ 0x87ab, 0x21753c },
	{ 0x87ac, 0x225f2b },
	{ 0x87ad, 0x225f28 },
	{ 0x87ae, 0x225f2f },
	{ 0x87af, 0x225f35 },
	{ 0x87b0, 0x225f2a },
	{ 0x87b1, 0x23563a },
	{ 0x87b2, 0x225f3e },
	{ 0x87b3, 0x217539 },
	{ 0x87b4, 0x225f38 },
	{ 0x87b5, 0x225f2d },
	{ 0x87b6, 0x225f39 },
	{ 0x87b7, 0x225f34 },
	{ 0x87b8, 0x225f3b },
	{ 0x87b9, 0x225f2c },
	{ 0x87ba, 0x21753e },
	{ 0x87bb, 0x21753d },
	{ 0x87bc, 0x225f2e },
	{ 0x87bd, 0x225f3c },
	{ 0x87be, 0x225f26 },
	{ 0x87bf, 0x225f3a },
	{ 0x87c0, 0x217537 },
	{ 0x87c1, 0x235639 },
	{ 0x87c2, 0x225f32 },
	{ 0x87c3, 0x225f31 },
	{ 0x87c4, 0x225f36 },
	{ 0x87c5, 0x225f29 },
	{ 0x87c6, 0x21753b },
	{ 0x87c7, 0x23563b },
	{ 0x87c8, 0x21753f },
	{ 0x87c9, 0x225f30 },
	{ 0x87ca, 0x225f37 },
	{ 0x87cb, 0x217540 },
	{ 0x87cc, 0x225f33 },
	{ 0x87cd, 0x235636 },
	{ 0x87ce, 0x235634 },
	{ 0x87d1, 0x217538 },
	{ 0x87d2, 0x21753a },
	{ 0x87d3, 0x226333 },
	{ 0x87d4, 0x226331 },
	{ 0x87d5, 0x235b28 },
	{ 0x87d6, 0x235876 },
	{ 0x87d7, 0x226337 },
	{ 0x87d8, 0x226335 },
	{ 0x87d9, 0x226338 },
	{ 0x87da, 0x235878 },
	{ 0x87db, 0x22632a },
	{ 0x87dc, 0x226332 },
	{ 0x87dd, 0x22633c },
	{ 0x87de, 0x225f3d },
	{ 0x87df, 0x22632e },
	{ 0x87e0, 0x21773a },
	{ 0x87e1, 0x22536c },
	{ 0x87e2, 0x226329 },
	{ 0x87e3, 0x226336 },
	{ 0x87e4, 0x226330 },
	{ 0x87e5, 0x22632d },
	{ 0x87e6, 0x226328 },
	{ 0x87e7, 0x226327 },
	{ 0x87e8, 0x22633b },
	{ 0x87e9, 0x235873 },
	{ 0x87ea, 0x22632c },
	{ 0x87eb, 0x22632b },
	{ 0x87ec, 0x217738 },
	{ 0x87ed, 0x226334 },
	{ 0x87ee, 0x235874 },
	{ 0x87ef, 0x217737 },
	{ 0x87f0, 0x235875 },
	{ 0x87f2, 0x217739 },
	{ 0x87f3, 0x22632f },
	{ 0x87f4, 0x22633a },
	{ 0x87f5, 0x236646 },
	{ 0x87f6, 0x226669 },
	{ 0x87f7, 0x22666a },
	{ 0x87f8, 0x235b2c },
	{ 0x87f9, 0x217874 },
	{ 0x87fa, 0x226667 },
	{ 0x87fb, 0x217871 },
	{ 0x87fc, 0x22666f },
	{ 0x87fd, 0x235b27 },
	{ 0x87fe, 0x217875 },
	{ 0x87ff, 0x226671 },
	{ 0x8800, 0x226666 },
	{ 0x8801, 0x226339 },
	{ 0x8802, 0x226673 },
	{ 0x8803, 0x226668 },
	{ 0x8805, 0x217872 },
	{ 0x8806, 0x22666e },
	{ 0x8807, 0x235b29 },
	{ 0x8808, 0x226670 },
	{ 0x8809, 0x22666b },
	{ 0x880a, 0x226672 },
	{ 0x880b, 0x22666d },
	{ 0x880c, 0x22666c },
	{ 0x880d, 0x217873 },
	{ 0x880e, 0x235877 },
	{ 0x880f, 0x235b2b },
	{ 0x8810, 0x226971 },
	{ 0x8811, 0x226972 },
	{ 0x8812, 0x235d25 },
	{ 0x8813, 0x226974 },
	{ 0x8814, 0x217a39 },
	{ 0x8815, 0x217a3a },
	{ 0x8816, 0x226975 },
	{ 0x8817, 0x226973 },
	{ 0x8818, 0x235d24 },
	{ 0x8819, 0x226970 },
	{ 0x881a, 0x235e5d },
	{ 0x881b, 0x226c31 },
	{ 0x881c, 0x226c34 },
	{ 0x881d, 0x226c30 },
	{ 0x881f, 0x217b27 },
	{ 0x8820, 0x226c32 },
	{ 0x8821, 0x217b26 },
	{ 0x8822, 0x217b25 },
	{ 0x8823, 0x217b24 },
	{ 0x8824, 0x226c33 },
	{ 0x8825, 0x226d7e },
	{ 0x8826, 0x226d7c },
	{ 0x8827, 0x235f5f },
	{ 0x8828, 0x226d7b },
	{ 0x8829, 0x226c2f },
	{ 0x882a, 0x226d7d },
	{ 0x882b, 0x226c35 },
	{ 0x882c, 0x226d7a },
	{ 0x882d, 0x236045 },
	{ 0x882e, 0x226f48 },
	{ 0x882f, 0x226f26 },
	{ 0x8830, 0x226f46 },
	{ 0x8831, 0x217c47 },
	{ 0x8832, 0x226f47 },
	{ 0x8833, 0x226f49 },
	{ 0x8834, 0x236647 },
	{ 0x8835, 0x22704d },
	{ 0x8836, 0x217c66 },
	{ 0x8837, 0x22704c },
	{ 0x8838, 0x22704b },
	{ 0x8839, 0x217c67 },
	{ 0x883b, 0x217d27 },
	{ 0x883c, 0x22715d },
	{ 0x883d, 0x227175 },
	{ 0x883e, 0x227174 },
	{ 0x883f, 0x227176 },
	{ 0x8840, 0x214866 },
	{ 0x8841, 0x222d4b },
	{ 0x8842, 0x232f26 },
	{ 0x8843, 0x223271 },
	{ 0x8844, 0x223272 },
	{ 0x8845, 0x23386a },
	{ 0x8846, 0x233e6a },
	{ 0x8847, 0x233e69 },
	{ 0x8848, 0x224026 },
	{ 0x884a, 0x226c36 },
	{ 0x884b, 0x22704e },
	{ 0x884c, 0x214867 },
	{ 0x884d, 0x21534f },
	{ 0x884e, 0x222d4c },
	{ 0x884f, 0x233371 },
	{ 0x8850, 0x236648 },
	{ 0x8852, 0x223934 },
	{ 0x8853, 0x215d34 },
	{ 0x8855, 0x224028 },
	{ 0x8856, 0x224027 },
	{ 0x8857, 0x216179 },
	{ 0x8858, 0x23444d },
	{ 0x8859, 0x21664c },
	{ 0x885a, 0x22542a },
	{ 0x885b, 0x216e6c },
	{ 0x885c, 0x234e5f },
	{ 0x885d, 0x216e6d },
	{ 0x885e, 0x235263 },
	{ 0x885f, 0x235264 },
	{ 0x8861, 0x21722f },
	{ 0x8862, 0x217c68 },
	{ 0x8863, 0x214868 },
	{ 0x8866, 0x232f27 },
	{ 0x8867, 0x222d4d },
	{ 0x8868, 0x214f50 },
	{ 0x8869, 0x222d4f },
	{ 0x886a, 0x222d4e },
	{ 0x886b, 0x215350 },
	{ 0x886d, 0x223273 },
	{ 0x886e, 0x233374 },
	{ 0x886f, 0x22327a },
	{ 0x8870, 0x21582e },
	{ 0x8871, 0x223278 },
	{ 0x8872, 0x223276 },
	{ 0x8873, 0x233377 },
	{ 0x8874, 0x22327d },
	{ 0x8875, 0x223274 },
	{ 0x8876, 0x223275 },
	{ 0x8877, 0x21582f },
	{ 0x8878, 0x233372 },
	{ 0x8879, 0x215833 },
	{ 0x887a, 0x233373 },
	{ 0x887b, 0x233375 },
	{ 0x887c, 0x22327e },
	{ 0x887d, 0x215832 },
	{ 0x887e, 0x22327c },
	{ 0x887f, 0x223279 },
	{ 0x8880, 0x223277 },
	{ 0x8881, 0x215830 },
	{ 0x8882, 0x215831 },
	{ 0x8883, 0x22327b },
	{ 0x8884, 0x233376 },
	{ 0x8887, 0x236649 },
	{ 0x8888, 0x215d36 },
	{ 0x8889, 0x223935 },
	{ 0x888a, 0x233872 },
	{ 0x888b, 0x215d3b },
	{ 0x888c, 0x223945 },
	{ 0x888d, 0x215d3a },
	{ 0x888e, 0x223947 },
	{ 0x888f, 0x23386e },
	{ 0x8890, 0x233874 },
	{ 0x8891, 0x22393b },
	{ 0x8892, 0x215d38 },
	{ 0x8893, 0x223946 },
	{ 0x8894, 0x23386c },
	{ 0x8895, 0x223936 },
	{ 0x8896, 0x215d39 },
	{ 0x8897, 0x223942 },
	{ 0x8898, 0x22393e },
	{ 0x8899, 0x223940 },
	{ 0x889a, 0x22393a },
	{ 0x889b, 0x223941 },
	{ 0x889c, 0x23386b },
	{ 0x889e, 0x215d35 },
	{ 0x889f, 0x22393d },
	{ 0x88a0, 0x233873 },
	{ 0x88a1, 0x22393c },
	{ 0x88a2, 0x223938 },
	{ 0x88a3, 0x23386d },
	{ 0x88a4, 0x223943 },
	{ 0x88a5, 0x23386f },
	{ 0x88a6, 0x233871 },
	{ 0x88a7, 0x22393f },
	{ 0x88a8, 0x223937 },
	{ 0x88a9, 0x233870 },
	{ 0x88aa, 0x223939 },
	{ 0x88ab, 0x215d37 },
	{ 0x88ac, 0x223944 },
	{ 0x88b1, 0x21617c },
	{ 0x88b2, 0x224033 },
	{ 0x88b4, 0x233e70 },
	{ 0x88b5, 0x233e72 },
	{ 0x88b6, 0x22402f },
	{ 0x88b7, 0x224031 },
	{ 0x88b8, 0x22402c },
	{ 0x88b9, 0x22402b },
	{ 0x88ba, 0x224029 },
	{ 0x88bb, 0x233e6d },
	{ 0x88bc, 0x224030 },
	{ 0x88bd, 0x224032 },
	{ 0x88be, 0x22402e },
	{ 0x88bf, 0x233e6f },
	{ 0x88c0, 0x22402d },
	{ 0x88c1, 0x21617a },
	{ 0x88c2, 0x21617b },
	{ 0x88c9, 0x224035 },
	{ 0x88ca, 0x216654 },
	{ 0x88cb, 0x224739 },
	{ 0x88cc, 0x22473f },
	{ 0x88cd, 0x22473a },
	{ 0x88ce, 0x22473b },
	{ 0x88cf, 0x23444e },
	{ 0x88d0, 0x224740 },
	{ 0x88d2, 0x216656 },
	{ 0x88d4, 0x21664e },
	{ 0x88d5, 0x216655 },
	{ 0x88d6, 0x224738 },
	{ 0x88d7, 0x22402a },
	{ 0x88d8, 0x216651 },
	{ 0x88d9, 0x21664f },
	{ 0x88da, 0x22473e },
	{ 0x88db, 0x22473d },
	{ 0x88dc, 0x216650 },
	{ 0x88dd, 0x216652 },
	{ 0x88de, 0x22473c },
	{ 0x88df, 0x21664d },
	{ 0x88e0, 0x23444f },
	{ 0x88e1, 0x216653 },
	{ 0x88e6, 0x234e60 },
	{ 0x88e7, 0x224d7d },
	{ 0x88e8, 0x216a7c },
	{ 0x88e9, 0x234959 },
	{ 0x88ea, 0x234952 },
	{ 0x88eb, 0x224e2a },
	{ 0x88ec, 0x224e29 },
	{ 0x88ed, 0x234957 },
	{ 0x88ee, 0x224e24 },
	{ 0x88ef, 0x216a7e },
	{ 0x88f0, 0x224e28 },
	{ 0x88f1, 0x224d7e },
	{ 0x88f2, 0x224e21 },
	{ 0x88f3, 0x216a76 },
	{ 0x88f4, 0x216a78 },
	{ 0x88f5, 0x234954 },
	{ 0x88f6, 0x224e26 },
	{ 0x88f7, 0x224d7c },
	{ 0x88f8, 0x216a7a },
	{ 0x88f9, 0x216a79 },
	{ 0x88fa, 0x224e22 },
	{ 0x88fb, 0x224e27 },
	{ 0x88fc, 0x224e25 },
	{ 0x88fd, 0x216a7b },
	{ 0x88fe, 0x224e23 },
	{ 0x88ff, 0x234951 },
	{ 0x8900, 0x234956 },
	{ 0x8901, 0x224034 },
	{ 0x8902, 0x216a77 },
	{ 0x8903, 0x234958 },
	{ 0x8905, 0x22542b },
	{ 0x8906, 0x225432 },
	{ 0x8907, 0x216e6f },
	{ 0x8909, 0x225436 },
	{ 0x890a, 0x216e73 },
	{ 0x890b, 0x22542e },
	{ 0x890c, 0x22542c },
	{ 0x890e, 0x225435 },
	{ 0x890f, 0x234e61 },
	{ 0x8910, 0x216e6e },
	{ 0x8911, 0x225434 },
	{ 0x8912, 0x216e70 },
	{ 0x8913, 0x216e71 },
	{ 0x8914, 0x22542d },
	{ 0x8915, 0x216e72 },
	{ 0x8916, 0x225433 },
	{ 0x8917, 0x22542f },
	{ 0x8918, 0x225430 },
	{ 0x8919, 0x225431 },
	{ 0x891a, 0x216a7d },
	{ 0x891b, 0x234e62 },
	{ 0x891e, 0x225a3e },
	{ 0x891f, 0x225a4a },
	{ 0x8921, 0x217234 },
	{ 0x8922, 0x225a45 },
	{ 0x8923, 0x225a47 },
	{ 0x8924, 0x235265 },
	{ 0x8925, 0x217232 },
	{ 0x8926, 0x225a3f },
	{ 0x8927, 0x225a43 },
	{ 0x8929, 0x225a46 },
	{ 0x892a, 0x217230 },
	{ 0x892b, 0x217233 },
	{ 0x892c, 0x225a49 },
	{ 0x892d, 0x225a41 },
	{ 0x892e, 0x225a42 },
	{ 0x892f, 0x225a48 },
	{ 0x8930, 0x225a40 },
	{ 0x8931, 0x225a44 },
	{ 0x8932, 0x217231 },
	{ 0x8933, 0x225f40 },
	{ 0x8935, 0x225f3f },
	{ 0x8936, 0x217542 },
	{ 0x8937, 0x225f45 },
	{ 0x8938, 0x217544 },
	{ 0x8939, 0x235640 },
	{ 0x893b, 0x217541 },
	{ 0x893c, 0x225f41 },
	{ 0x893d, 0x217545 },
	{ 0x893e, 0x225f42 },
	{ 0x893f, 0x23563f },
	{ 0x8940, 0x23563d },
	{ 0x8941, 0x225f43 },
	{ 0x8942, 0x225f46 },
	{ 0x8943, 0x235642 },
	{ 0x8944, 0x217543 },
	{ 0x8946, 0x226341 },
	{ 0x8948, 0x235879 },
	{ 0x8949, 0x226344 },
	{ 0x894a, 0x23587a },
	{ 0x894b, 0x22633e },
	{ 0x894c, 0x226340 },
	{ 0x894d, 0x23587c },
	{ 0x894e, 0x23587b },
	{ 0x894f, 0x22633f },
	{ 0x8950, 0x226342 },
	{ 0x8951, 0x226343 },
	{ 0x8952, 0x225f44 },
	{ 0x8953, 0x22633d },
	{ 0x8954, 0x23664a },
	{ 0x8956, 0x217878 },
	{ 0x8957, 0x226677 },
	{ 0x8958, 0x22667a },
	{ 0x8959, 0x22667c },
	{ 0x895a, 0x226675 },
	{ 0x895b, 0x226676 },
	{ 0x895c, 0x226679 },
	{ 0x895d, 0x22667b },
	{ 0x895e, 0x217879 },
	{ 0x895f, 0x217877 },
	{ 0x8960, 0x217876 },
	{ 0x8961, 0x226678 },
	{ 0x8962, 0x226674 },
	{ 0x8963, 0x226976 },
	{ 0x8964, 0x217a3b },
	{ 0x8965, 0x235d29 },
	{ 0x8966, 0x226977 },
	{ 0x8967, 0x235d28 },
	{ 0x8969, 0x226c38 },
	{ 0x896a, 0x217b28 },
	{ 0x896b, 0x226c3a },
	{ 0x896c, 0x217b29 },
	{ 0x896d, 0x226c37 },
	{ 0x896e, 0x226c39 },
	{ 0x896f, 0x217b72 },
	{ 0x8971, 0x226e21 },
	{ 0x8972, 0x217b71 },
	{ 0x8973, 0x226f4c },
	{ 0x8974, 0x226f4b },
	{ 0x8976, 0x226f4a },
	{ 0x8978, 0x236149 },
	{ 0x8979, 0x227137 },
	{ 0x897a, 0x227138 },
	{ 0x897b, 0x22713a },
	{ 0x897c, 0x227139 },
	{ 0x897d, 0x23617d },
	{ 0x897e, 0x222270 },
	{ 0x897f, 0x214869 },
	{ 0x8981, 0x215351 },
	{ 0x8982, 0x223948 },
	{ 0x8983, 0x21617d },
	{ 0x8984, 0x23664b },
	{ 0x8985, 0x224741 },
	{ 0x8986, 0x21773b },
	{ 0x8987, 0x235b2f },
	{ 0x8988, 0x22667d },
	{ 0x8989, 0x236046 },
	{ 0x898a, 0x23614a },
	{ 0x898b, 0x214b44 },
	{ 0x898c, 0x232f29 },
	{ 0x898f, 0x215d3d },
	{ 0x8991, 0x233876 },
	{ 0x8992, 0x233875 },
	{ 0x8993, 0x215d3c },
	{ 0x8994, 0x233877 },
	{ 0x8995, 0x224036 },
	{ 0x8996, 0x21617e },
	{ 0x8997, 0x224038 },
	{ 0x8998, 0x224037 },
	{ 0x899a, 0x233e74 },
	{ 0x899b, 0x224742 },
	{ 0x899c, 0x216657 },
	{ 0x899d, 0x224e2b },
	{ 0x899e, 0x224e2e },
	{ 0x899f, 0x224e2d },
	{ 0x89a1, 0x224e2c },
	{ 0x89a2, 0x225437 },
	{ 0x89a3, 0x225439 },
	{ 0x89a4, 0x225438 },
	{ 0x89a5, 0x234e65 },
	{ 0x89a6, 0x217236 },
	{ 0x89a7, 0x235266 },
	{ 0x89a9, 0x234e64 },
	{ 0x89aa, 0x217235 },
	{ 0x89ab, 0x235646 },
	{ 0x89ac, 0x217546 },
	{ 0x89ad, 0x225f47 },
	{ 0x89ae, 0x225f49 },
	{ 0x89af, 0x225f48 },
	{ 0x89b0, 0x23587e },
	{ 0x89b1, 0x23587d },
	{ 0x89b2, 0x21773c },
	{ 0x89b3, 0x235921 },
	{ 0x89b5, 0x235b31 },
	{ 0x89b6, 0x226721 },
	{ 0x89b7, 0x22667e },
	{ 0x89b9, 0x226978 },
	{ 0x89ba, 0x217a3c },
	{ 0x89bb, 0x235d2a },
	{ 0x89bc, 0x235e61 },
	{ 0x89bd, 0x217b2a },
	{ 0x89be, 0x226e23 },
	{ 0x89bf, 0x226e22 },
	{ 0x89c0, 0x217d28 },
	{ 0x89d2, 0x214b45 },
	{ 0x89d3, 0x222d50 },
	{ 0x89d4, 0x215352 },
	{ 0x89d5, 0x22394b },
	{ 0x89d6, 0x223949 },
	{ 0x89d9, 0x22394a },
	{ 0x89da, 0x22403a },
	{ 0x89db, 0x22403b },
	{ 0x89dc, 0x224749 },
	{ 0x89dd, 0x224039 },
	{ 0x89df, 0x224743 },
	{ 0x89e0, 0x224747 },
	{ 0x89e1, 0x224746 },
	{ 0x89e2, 0x224748 },
	{ 0x89e3, 0x216658 },
	{ 0x89e4, 0x224745 },
	{ 0x89e5, 0x224744 },
	{ 0x89e6, 0x22474a },
	{ 0x89e7, 0x234454 },
	{ 0x89e8, 0x224e31 },
	{ 0x89e9, 0x224e2f },
	{ 0x89ea, 0x23495c },
	{ 0x89eb, 0x224e30 },
	{ 0x89ec, 0x22543c },
	{ 0x89ed, 0x22543a },
	{ 0x89ee, 0x234e66 },
	{ 0x89f0, 0x22543b },
	{ 0x89f1, 0x225a4b },
	{ 0x89f2, 0x225f4a },
	{ 0x89f3, 0x225f4b },
	{ 0x89f4, 0x21773d },
	{ 0x89f5, 0x235b32 },
	{ 0x89f6, 0x226722 },
	{ 0x89f7, 0x226979 },
	{ 0x89f8, 0x217a3d },
	{ 0x89fa, 0x226c3b },
	{ 0x89fb, 0x226e24 },
	{ 0x89fc, 0x217b73 },
	{ 0x89fe, 0x226f4d },
	{ 0x89ff, 0x22713b },
	{ 0x8a00, 0x214b46 },
	{ 0x8a02, 0x215354 },
	{ 0x8a03, 0x215355 },
	{ 0x8a04, 0x222d51 },
	{ 0x8a05, 0x232f2a },
	{ 0x8a06, 0x232f2c },
	{ 0x8a07, 0x222d52 },
	{ 0x8a08, 0x215353 },
	{ 0x8a0a, 0x215839 },
	{ 0x8a0b, 0x23337b },
	{ 0x8a0c, 0x215837 },
	{ 0x8a0d, 0x23337a },
	{ 0x8a0e, 0x215836 },
	{ 0x8a0f, 0x21583d },
	{ 0x8a10, 0x215835 },
	{ 0x8a11, 0x21583e },
	{ 0x8a12, 0x223321 },
	{ 0x8a13, 0x21583b },
	{ 0x8a15, 0x215838 },
	{ 0x8a16, 0x21583c },
	{ 0x8a17, 0x21583a },
	{ 0x8a18, 0x215834 },
	{ 0x8a19, 0x23337c },
	{ 0x8a1b, 0x215d45 },
	{ 0x8a1c, 0x23387e },
	{ 0x8a1d, 0x215d3f },
	{ 0x8a1e, 0x22394f },
	{ 0x8a1f, 0x215d44 },
	{ 0x8a20, 0x233923 },
	{ 0x8a21, 0x233929 },
	{ 0x8a22, 0x215d46 },
	{ 0x8a23, 0x215d40 },
	{ 0x8a25, 0x215d41 },
	{ 0x8a26, 0x233879 },
	{ 0x8a27, 0x22394d },
	{ 0x8a28, 0x23387b },
	{ 0x8a29, 0x233925 },
	{ 0x8a2a, 0x215d3e },
	{ 0x8a2b, 0x233922 },
	{ 0x8a2c, 0x22394e },
	{ 0x8a2d, 0x215d43 },
	{ 0x8a2e, 0x236330 },
	{ 0x8a30, 0x22394c },
	{ 0x8a31, 0x215d42 },
	{ 0x8a32, 0x23387a },
	{ 0x8a34, 0x21622b },
	{ 0x8a35, 0x233e7c },
	{ 0x8a36, 0x21622d },
	{ 0x8a38, 0x233e7d },
	{ 0x8a39, 0x22403e },
	{ 0x8a3a, 0x21622c },
	{ 0x8a3b, 0x216221 },
	{ 0x8a3c, 0x216225 },
	{ 0x8a3d, 0x233f24 },
	{ 0x8a3e, 0x21666b },
	{ 0x8a3f, 0x22474f },
	{ 0x8a40, 0x224040 },
	{ 0x8a41, 0x216226 },
	{ 0x8a42, 0x233e7e },
	{ 0x8a43, 0x233e75 },
	{ 0x8a44, 0x224043 },
	{ 0x8a45, 0x224044 },
	{ 0x8a46, 0x21622a },
	{ 0x8a48, 0x224046 },
	{ 0x8a49, 0x233f21 },
	{ 0x8a4a, 0x224048 },
	{ 0x8a4b, 0x233f23 },
	{ 0x8a4c, 0x224049 },
	{ 0x8a4d, 0x22403d },
	{ 0x8a4e, 0x22403c },
	{ 0x8a4f, 0x22404a },
	{ 0x8a50, 0x216229 },
	{ 0x8a51, 0x224047 },
	{ 0x8a52, 0x224045 },
	{ 0x8a54, 0x216227 },
	{ 0x8a55, 0x216223 },
	{ 0x8a56, 0x21622e },
	{ 0x8a57, 0x224041 },
	{ 0x8a58, 0x224042 },
	{ 0x8a59, 0x22403f },
	{ 0x8a5a, 0x233e78 },
	{ 0x8a5b, 0x216228 },
	{ 0x8a5d, 0x233f22 },
	{ 0x8a5e, 0x216224 },
	{ 0x8a60, 0x216222 },
	{ 0x8a61, 0x22474e },
	{ 0x8a62, 0x216666 },
	{ 0x8a63, 0x216661 },
	{ 0x8a64, 0x234460 },
	{ 0x8a65, 0x234459 },
	{ 0x8a66, 0x21665c },
	{ 0x8a67, 0x234463 },
	{ 0x8a68, 0x21666c },
	{ 0x8a69, 0x21665d },
	{ 0x8a6a, 0x234455 },
	{ 0x8a6b, 0x216659 },
	{ 0x8a6c, 0x216668 },
	{ 0x8a6d, 0x216665 },
	{ 0x8a6e, 0x216667 },
	{ 0x8a6f, 0x234458 },
	{ 0x8a70, 0x21665e },
	{ 0x8a71, 0x216663 },
	{ 0x8a72, 0x21665a },
	{ 0x8a73, 0x21665b },
	{ 0x8a74, 0x224756 },
	{ 0x8a75, 0x224753 },
	{ 0x8a76, 0x22474b },
	{ 0x8a77, 0x224750 },
	{ 0x8a78, 0x23445b },
	{ 0x8a79, 0x216669 },
	{ 0x8a7a, 0x224757 },
	{ 0x8a7b, 0x21666a },
	{ 0x8a7c, 0x216660 },
	{ 0x8a7d, 0x23445c },
	{ 0x8a7e, 0x234461 },
	{ 0x8a7f, 0x22474d },
	{ 0x8a80, 0x234456 },
	{ 0x8a81, 0x224755 },
	{ 0x8a82, 0x224751 },
	{ 0x8a83, 0x224754 },
	{ 0x8a84, 0x224752 },
	{ 0x8a85, 0x216664 },
	{ 0x8a86, 0x22474c },
	{ 0x8a87, 0x21665f },
	{ 0x8a88, 0x23445d },
	{ 0x8a8b, 0x224e34 },
	{ 0x8a8c, 0x216b22 },
	{ 0x8a8d, 0x216b25 },
	{ 0x8a8e, 0x23495f },
	{ 0x8a8f, 0x224e36 },
	{ 0x8a90, 0x234964 },
	{ 0x8a91, 0x216b2d },
	{ 0x8a92, 0x224e35 },
	{ 0x8a93, 0x216b27 },
	{ 0x8a94, 0x234963 },
	{ 0x8a95, 0x216e78 },
	{ 0x8a96, 0x224e37 },
	{ 0x8a98, 0x216b2c },
	{ 0x8a99, 0x224e33 },
	{ 0x8a9a, 0x216b2e },
	{ 0x8a9b, 0x23495e },
	{ 0x8a9c, 0x234962 },
	{ 0x8a9d, 0x23496b },
	{ 0x8a9e, 0x216b23 },
	{ 0x8a9f, 0x234968 },
	{ 0x8aa0, 0x216662 },
	{ 0x8aa1, 0x216b26 },
	{ 0x8aa2, 0x234960 },
	{ 0x8aa3, 0x216b24 },
	{ 0x8aa4, 0x216b28 },
	{ 0x8aa5, 0x216b2a },
	{ 0x8aa6, 0x216b21 },
	{ 0x8aa7, 0x216b2f },
	{ 0x8aa8, 0x216b2b },
	{ 0x8aa9, 0x234965 },
	{ 0x8aaa, 0x216b29 },
	{ 0x8aab, 0x224e32 },
	{ 0x8aac, 0x234966 },
	{ 0x8aaf, 0x234e74 },
	{ 0x8ab0, 0x216f21 },
	{ 0x8ab1, 0x234e67 },
	{ 0x8ab2, 0x216e7b },
	{ 0x8ab3, 0x234e72 },
	{ 0x8ab4, 0x234e70 },
	{ 0x8ab5, 0x234e6e },
	{ 0x8ab6, 0x216f24 },
	{ 0x8ab7, 0x234e6c },
	{ 0x8ab8, 0x22543f },
	{ 0x8ab9, 0x216f25 },
	{ 0x8aba, 0x22544b },
	{ 0x8abb, 0x225444 },
	{ 0x8abc, 0x216e74 },
	{ 0x8abd, 0x22544c },
	{ 0x8abe, 0x225446 },
	{ 0x8abf, 0x216e7e },
	{ 0x8ac0, 0x225447 },
	{ 0x8ac1, 0x234e73 },
	{ 0x8ac2, 0x216e7d },
	{ 0x8ac3, 0x22544a },
	{ 0x8ac4, 0x216e77 },
	{ 0x8ac5, 0x225448 },
	{ 0x8ac6, 0x22543e },
	{ 0x8ac7, 0x216e76 },
	{ 0x8ac8, 0x225a56 },
	{ 0x8ac9, 0x216e7c },
	{ 0x8aca, 0x234e75 },
	{ 0x8acb, 0x216e79 },
	{ 0x8acc, 0x234e69 },
	{ 0x8acd, 0x216f23 },
	{ 0x8ace, 0x234e6a },
	{ 0x8acf, 0x22543d },
	{ 0x8ad0, 0x234e76 },
	{ 0x8ad1, 0x225441 },
	{ 0x8ad2, 0x216e75 },
	{ 0x8ad3, 0x225440 },
	{ 0x8ad4, 0x225442 },
	{ 0x8ad5, 0x225443 },
	{ 0x8ad6, 0x216f22 },
	{ 0x8ad7, 0x225445 },
	{ 0x8ad8, 0x225449 },
	{ 0x8ad9, 0x22544d },
	{ 0x8adb, 0x216f26 },
	{ 0x8adc, 0x21723c },
	{ 0x8add, 0x225a51 },
	{ 0x8ade, 0x225a57 },
	{ 0x8adf, 0x225a54 },
	{ 0x8ae0, 0x225a4c },
	{ 0x8ae1, 0x225a58 },
	{ 0x8ae2, 0x225a4d },
	{ 0x8ae3, 0x23526a },
	{ 0x8ae4, 0x225a53 },
	{ 0x8ae5, 0x23526b },
	{ 0x8ae6, 0x217237 },
	{ 0x8ae7, 0x21723d },
	{ 0x8ae8, 0x225a59 },
	{ 0x8ae9, 0x234e6f },
	{ 0x8aea, 0x235267 },
	{ 0x8aeb, 0x217239 },
	{ 0x8aec, 0x23526e },
	{ 0x8aed, 0x217243 },
	{ 0x8aee, 0x21723e },
	{ 0x8aef, 0x225a5b },
	{ 0x8af0, 0x225a55 },
	{ 0x8af1, 0x21723a },
	{ 0x8af2, 0x225a4e },
	{ 0x8af3, 0x217244 },
	{ 0x8af4, 0x225a4f },
	{ 0x8af5, 0x225a50 },
	{ 0x8af6, 0x217245 },
	{ 0x8af7, 0x217242 },
	{ 0x8af8, 0x216e7a },
	{ 0x8af9, 0x235269 },
	{ 0x8afa, 0x217238 },
	{ 0x8afb, 0x225a5c },
	{ 0x8afc, 0x217246 },
	{ 0x8afd, 0x235268 },
	{ 0x8afe, 0x21723f },
	{ 0x8aff, 0x225a5a },
	{ 0x8b00, 0x21723b },
	{ 0x8b01, 0x217240 },
	{ 0x8b02, 0x217241 },
	{ 0x8b03, 0x23664c },
	{ 0x8b04, 0x21754e },
	{ 0x8b05, 0x225f50 },
	{ 0x8b06, 0x225f59 },
	{ 0x8b07, 0x225f56 },
	{ 0x8b08, 0x225f58 },
	{ 0x8b09, 0x235649 },
	{ 0x8b0a, 0x21754b },
	{ 0x8b0b, 0x225f51 },
	{ 0x8b0c, 0x23564a },
	{ 0x8b0d, 0x225f57 },
	{ 0x8b0e, 0x217547 },
	{ 0x8b0f, 0x225f53 },
	{ 0x8b10, 0x21754f },
	{ 0x8b11, 0x225f4f },
	{ 0x8b12, 0x225f54 },
	{ 0x8b13, 0x225f5b },
	{ 0x8b14, 0x225a52 },
	{ 0x8b15, 0x225f55 },
	{ 0x8b16, 0x225f4e },
	{ 0x8b17, 0x217548 },
	{ 0x8b18, 0x225f4d },
	{ 0x8b19, 0x217549 },
	{ 0x8b1a, 0x225f5c },
	{ 0x8b1b, 0x21754a },
	{ 0x8b1c, 0x225f5a },
	{ 0x8b1d, 0x21754d },
	{ 0x8b1e, 0x225f4c },
	{ 0x8b1f, 0x235648 },
	{ 0x8b20, 0x21754c },
	{ 0x8b22, 0x225f52 },
	{ 0x8b23, 0x226347 },
	{ 0x8b24, 0x226355 },
	{ 0x8b25, 0x226350 },
	{ 0x8b26, 0x226352 },
	{ 0x8b27, 0x226346 },
	{ 0x8b28, 0x21773e },
	{ 0x8b29, 0x23592a },
	{ 0x8b2a, 0x226345 },
	{ 0x8b2b, 0x217741 },
	{ 0x8b2c, 0x217740 },
	{ 0x8b2d, 0x235926 },
	{ 0x8b2e, 0x226354 },
	{ 0x8b2f, 0x22634c },
	{ 0x8b30, 0x226349 },
	{ 0x8b31, 0x22634f },
	{ 0x8b32, 0x235924 },
	{ 0x8b33, 0x226348 },
	{ 0x8b34, 0x235928 },
	{ 0x8b35, 0x22634a },
	{ 0x8b36, 0x226353 },
	{ 0x8b37, 0x226351 },
	{ 0x8b38, 0x235923 },
	{ 0x8b39, 0x21773f },
	{ 0x8b3a, 0x226358 },
	{ 0x8b3b, 0x226356 },
	{ 0x8b3c, 0x22634d },
	{ 0x8b3d, 0x226357 },
	{ 0x8b3e, 0x22634e },
	{ 0x8b3f, 0x235b34 },
	{ 0x8b40, 0x226726 },
	{ 0x8b41, 0x21787a },
	{ 0x8b42, 0x22672d },
	{ 0x8b43, 0x235b35 },
	{ 0x8b45, 0x226c3e },
	{ 0x8b46, 0x217923 },
	{ 0x8b47, 0x22634b },
	{ 0x8b48, 0x226724 },
	{ 0x8b49, 0x21787d },
	{ 0x8b4a, 0x226725 },
	{ 0x8b4b, 0x22672a },
	{ 0x8b4c, 0x235b36 },
	{ 0x8b4d, 0x235d33 },
	{ 0x8b4e, 0x217921 },
	{ 0x8b4f, 0x217922 },
	{ 0x8b50, 0x226723 },
	{ 0x8b51, 0x22672c },
	{ 0x8b52, 0x22672e },
	{ 0x8b53, 0x226727 },
	{ 0x8b54, 0x226729 },
	{ 0x8b55, 0x22672b },
	{ 0x8b56, 0x226728 },
	{ 0x8b57, 0x22672f },
	{ 0x8b58, 0x21787c },
	{ 0x8b59, 0x217924 },
	{ 0x8b5a, 0x21787e },
	{ 0x8b5c, 0x21787b },
	{ 0x8b5d, 0x22697c },
	{ 0x8b5f, 0x217a42 },
	{ 0x8b60, 0x22697a },
	{ 0x8b61, 0x235d30 },
	{ 0x8b62, 0x235d2c },
	{ 0x8b63, 0x22697e },
	{ 0x8b64, 0x235d32 },
	{ 0x8b65, 0x226a21 },
	{ 0x8b66, 0x217a40 },
	{ 0x8b67, 0x226a22 },
	{ 0x8b68, 0x22697d },
	{ 0x8b69, 0x235d2b },
	{ 0x8b6a, 0x22697b },
	{ 0x8b6b, 0x217a43 },
	{ 0x8b6c, 0x217a3f },
	{ 0x8b6d, 0x226a23 },
	{ 0x8b6e, 0x235d2e },
	{ 0x8b6f, 0x217a41 },
	{ 0x8b70, 0x217a3e },
	{ 0x8b71, 0x235c6d },
	{ 0x8b73, 0x23642d },
	{ 0x8b74, 0x217b2b },
	{ 0x8b75, 0x235e62 },
	{ 0x8b77, 0x217b2c },
	{ 0x8b78, 0x226c3d },
	{ 0x8b79, 0x226c3c },
	{ 0x8b7a, 0x226c3f },
	{ 0x8b7b, 0x226c40 },
	{ 0x8b7c, 0x235e63 },
	{ 0x8b7d, 0x217b2d },
	{ 0x8b7e, 0x226e25 },
	{ 0x8b7f, 0x226e2a },
	{ 0x8b80, 0x217b74 },
	{ 0x8b81, 0x235f61 },
	{ 0x8b82, 0x226e27 },
	{ 0x8b83, 0x235f62 },
	{ 0x8b84, 0x226e26 },
	{ 0x8b85, 0x226e29 },
	{ 0x8b86, 0x226e28 },
	{ 0x8b87, 0x236048 },
	{ 0x8b88, 0x226f51 },
	{ 0x8b8a, 0x217c48 },
	{ 0x8b8b, 0x226f50 },
	{ 0x8b8c, 0x226f4e },
	{ 0x8b8d, 0x236047 },
	{ 0x8b8e, 0x226f4f },
	{ 0x8b90, 0x236049 },
	{ 0x8b91, 0x23607b },
	{ 0x8b92, 0x217c6a },
	{ 0x8b93, 0x217c69 },
	{ 0x8b94, 0x22704f },
	{ 0x8b95, 0x227050 },
	{ 0x8b96, 0x217c6b },
	{ 0x8b97, 0x23614b },
	{ 0x8b98, 0x22713c },
	{ 0x8b99, 0x22713d },
	{ 0x8b9a, 0x217d34 },
	{ 0x8b9b, 0x23616b },
	{ 0x8b9c, 0x217d3a },
	{ 0x8b9d, 0x23617e },
	{ 0x8b9e, 0x227177 },
	{ 0x8b9f, 0x227236 },
	{ 0x8c37, 0x214b47 },
	{ 0x8c39, 0x223950 },
	{ 0x8c3a, 0x23392a },
	{ 0x8c3b, 0x223951 },
	{ 0x8c3c, 0x224758 },
	{ 0x8c3d, 0x224e38 },
	{ 0x8c3e, 0x22544e },
	{ 0x8c3f, 0x217551 },
	{ 0x8c40, 0x23564d },
	{ 0x8c41, 0x217550 },
	{ 0x8c42, 0x226359 },
	{ 0x8c43, 0x226730 },
	{ 0x8c44, 0x235f64 },
	{ 0x8c45, 0x226f52 },
	{ 0x8c46, 0x214b48 },
	{ 0x8c47, 0x223322 },
	{ 0x8c48, 0x21583f },
	{ 0x8c49, 0x215d47 },
	{ 0x8c4a, 0x22475a },
	{ 0x8c4b, 0x224759 },
	{ 0x8c4c, 0x216f27 },
	{ 0x8c4d, 0x22544f },
	{ 0x8c4e, 0x216f28 },
	{ 0x8c4f, 0x225f5d },
	{ 0x8c50, 0x217742 },
	{ 0x8c51, 0x235d34 },
	{ 0x8c52, 0x23664d },
	{ 0x8c53, 0x236221 },
	{ 0x8c54, 0x217d43 },
	{ 0x8c55, 0x214b49 },
	{ 0x8c56, 0x22286b },
	{ 0x8c57, 0x223323 },
	{ 0x8c58, 0x23392d },
	{ 0x8c5a, 0x215d48 },
	{ 0x8c5b, 0x23392c },
	{ 0x8c5c, 0x223952 },
	{ 0x8c5d, 0x223953 },
	{ 0x8c5e, 0x233f2a },
	{ 0x8c5f, 0x22404b },
	{ 0x8c60, 0x233f29 },
	{ 0x8c61, 0x21622f },
	{ 0x8c62, 0x21666d },
	{ 0x8c63, 0x234464 },
	{ 0x8c64, 0x22475c },
	{ 0x8c65, 0x22475b },
	{ 0x8c66, 0x22475d },
	{ 0x8c67, 0x23496d },
	{ 0x8c68, 0x224e39 },
	{ 0x8c69, 0x224e3a },
	{ 0x8c6a, 0x216b30 },
	{ 0x8c6b, 0x217247 },
	{ 0x8c6c, 0x216f29 },
	{ 0x8c6d, 0x217248 },
	{ 0x8c6f, 0x225f61 },
	{ 0x8c70, 0x225f5e },
	{ 0x8c71, 0x225f60 },
	{ 0x8c72, 0x225f5f },
	{ 0x8c73, 0x217552 },
	{ 0x8c74, 0x23592b },
	{ 0x8c75, 0x22635a },
	{ 0x8c76, 0x226732 },
	{ 0x8c77, 0x226731 },
	{ 0x8c78, 0x222524 },
	{ 0x8c79, 0x215841 },
	{ 0x8c7a, 0x215840 },
	{ 0x8c7b, 0x223324 },
	{ 0x8c7c, 0x23392e },
	{ 0x8c7d, 0x223954 },
	{ 0x8c7e, 0x233f2c },
	{ 0x8c7f, 0x233f2b },
	{ 0x8c80, 0x22404d },
	{ 0x8c81, 0x22404c },
	{ 0x8c82, 0x216230 },
	{ 0x8c83, 0x233f2d },
	{ 0x8c84, 0x22475f },
	{ 0x8c85, 0x224760 },
	{ 0x8c86, 0x22475e },
	{ 0x8c87, 0x23634a },
	{ 0x8c88, 0x234465 },
	{ 0x8c89, 0x21666f },
	{ 0x8c8a, 0x21666e },
	{ 0x8c8c, 0x216b32 },
	{ 0x8c8d, 0x216b31 },
	{ 0x8c8e, 0x234e7a },
	{ 0x8c8f, 0x225450 },
	{ 0x8c90, 0x225a5f },
	{ 0x8c91, 0x225a5d },
	{ 0x8c92, 0x225a5e },
	{ 0x8c93, 0x217249 },
	{ 0x8c94, 0x225f63 },
	{ 0x8c95, 0x225f62 },
	{ 0x8c96, 0x23564f },
	{ 0x8c97, 0x22635d },
	{ 0x8c98, 0x22635c },
	{ 0x8c99, 0x22635b },
	{ 0x8c9a, 0x226733 },
	{ 0x8c9b, 0x23614d },
	{ 0x8c9c, 0x227178 },
	{ 0x8c9d, 0x214b4a },
	{ 0x8c9e, 0x215356 },
	{ 0x8c9f, 0x232f2e },
	{ 0x8ca0, 0x215357 },
	{ 0x8ca1, 0x215842 },
	{ 0x8ca2, 0x215843 },
	{ 0x8ca3, 0x223326 },
	{ 0x8ca4, 0x223325 },
	{ 0x8ca5, 0x223955 },
	{ 0x8ca6, 0x233930 },
	{ 0x8ca7, 0x215d4e },
	{ 0x8ca8, 0x215d4c },
	{ 0x8ca9, 0x215d49 },
	{ 0x8caa, 0x215d4d },
	{ 0x8cab, 0x215d4b },
	{ 0x8cac, 0x215d4a },
	{ 0x8cad, 0x233932 },
	{ 0x8cae, 0x233931 },
	{ 0x8caf, 0x216231 },
	{ 0x8cb0, 0x224050 },
	{ 0x8cb1, 0x233f2f },
	{ 0x8cb2, 0x216674 },
	{ 0x8cb3, 0x216233 },
	{ 0x8cb4, 0x216238 },
	{ 0x8cb5, 0x224052 },
	{ 0x8cb6, 0x21623a },
	{ 0x8cb7, 0x216239 },
	{ 0x8cb8, 0x21623c },
	{ 0x8cb9, 0x224051 },
	{ 0x8cba, 0x22404e },
	{ 0x8cbb, 0x216236 },
	{ 0x8cbc, 0x216232 },
	{ 0x8cbd, 0x216234 },
	{ 0x8cbe, 0x22404f },
	{ 0x8cbf, 0x21623b },
	{ 0x8cc0, 0x216237 },
	{ 0x8cc1, 0x216235 },
	{ 0x8cc2, 0x216676 },
	{ 0x8cc3, 0x216675 },
	{ 0x8cc4, 0x216673 },
	{ 0x8cc5, 0x216677 },
	{ 0x8cc7, 0x216671 },
	{ 0x8cc8, 0x216672 },
	{ 0x8cc9, 0x234469 },
	{ 0x8cca, 0x216670 },
	{ 0x8ccc, 0x224761 },
	{ 0x8ccd, 0x234467 },
	{ 0x8ccf, 0x224e3c },
	{ 0x8cd0, 0x234970 },
	{ 0x8cd1, 0x216b34 },
	{ 0x8cd2, 0x216b35 },
	{ 0x8cd3, 0x216b33 },
	{ 0x8cd4, 0x234972 },
	{ 0x8cd5, 0x224e3b },
	{ 0x8cd6, 0x234971 },
	{ 0x8cd7, 0x224e3d },
	{ 0x8cd8, 0x23664e },
	{ 0x8cd9, 0x225453 },
	{ 0x8cda, 0x225455 },
	{ 0x8cdb, 0x234e7e },
	{ 0x8cdc, 0x216f32 },
	{ 0x8cdd, 0x225456 },
	{ 0x8cde, 0x216f2b },
	{ 0x8cdf, 0x225452 },
	{ 0x8ce0, 0x216f2a },
	{ 0x8ce1, 0x216f34 },
	{ 0x8ce2, 0x216f30 },
	{ 0x8ce3, 0x216f31 },
	{ 0x8ce4, 0x216f2d },
	{ 0x8ce5, 0x225451 },
	{ 0x8ce6, 0x216f2c },
	{ 0x8ce7, 0x225457 },
	{ 0x8ce8, 0x225454 },
	{ 0x8ce9, 0x234e7d },
	{ 0x8cea, 0x216f33 },
	{ 0x8ceb, 0x234f22 },
	{ 0x8cec, 0x216f2e },
	{ 0x8ced, 0x216f2f },
	{ 0x8cee, 0x225a61 },
	{ 0x8cef, 0x235275 },
	{ 0x8cf0, 0x225a63 },
	{ 0x8cf1, 0x225a62 },
	{ 0x8cf2, 0x235273 },
	{ 0x8cf3, 0x225a64 },
	{ 0x8cf4, 0x21724a },
	{ 0x8cf5, 0x225a60 },
	{ 0x8cf6, 0x235651 },
	{ 0x8cf7, 0x235652 },
	{ 0x8cf8, 0x217556 },
	{ 0x8cf9, 0x225f64 },
	{ 0x8cfa, 0x217553 },
	{ 0x8cfb, 0x217557 },
	{ 0x8cfc, 0x217555 },
	{ 0x8cfd, 0x217554 },
	{ 0x8cfe, 0x22635e },
	{ 0x8d00, 0x226361 },
	{ 0x8d02, 0x226360 },
	{ 0x8d03, 0x23592e },
	{ 0x8d04, 0x22635f },
	{ 0x8d05, 0x217743 },
	{ 0x8d06, 0x226734 },
	{ 0x8d07, 0x226735 },
	{ 0x8d08, 0x217925 },
	{ 0x8d09, 0x226736 },
	{ 0x8d0a, 0x217926 },
	{ 0x8d0b, 0x235b38 },
	{ 0x8d0c, 0x23664f },
	{ 0x8d0d, 0x217a45 },
	{ 0x8d0e, 0x236428 },
	{ 0x8d0f, 0x217a44 },
	{ 0x8d10, 0x226c41 },
	{ 0x8d11, 0x235e65 },
	{ 0x8d12, 0x235e66 },
	{ 0x8d13, 0x217b2e },
	{ 0x8d14, 0x226c42 },
	{ 0x8d15, 0x226e2b },
	{ 0x8d16, 0x217b75 },
	{ 0x8d17, 0x217b76 },
	{ 0x8d18, 0x236650 },
	{ 0x8d19, 0x226f53 },
	{ 0x8d1a, 0x23604a },
	{ 0x8d1b, 0x217c6d },
	{ 0x8d1c, 0x23614e },
	{ 0x8d64, 0x214b4b },
	{ 0x8d65, 0x233933 },
	{ 0x8d66, 0x215d50 },
	{ 0x8d67, 0x215d4f },
	{ 0x8d68, 0x224762 },
	{ 0x8d69, 0x224763 },
	{ 0x8d6b, 0x216b36 },
	{ 0x8d6c, 0x225a65 },
	{ 0x8d6d, 0x216f35 },
	{ 0x8d6e, 0x225a66 },
	{ 0x8d6f, 0x225f65 },
	{ 0x8d70, 0x214b4c },
	{ 0x8d71, 0x23243a },
	{ 0x8d72, 0x222d53 },
	{ 0x8d73, 0x215359 },
	{ 0x8d74, 0x215358 },
	{ 0x8d76, 0x223327 },
	{ 0x8d77, 0x215844 },
	{ 0x8d78, 0x223328 },
	{ 0x8d79, 0x223958 },
	{ 0x8d7a, 0x233939 },
	{ 0x8d7b, 0x223957 },
	{ 0x8d7c, 0x233937 },
	{ 0x8d7d, 0x223956 },
	{ 0x8d7e, 0x233935 },
	{ 0x8d7f, 0x233938 },
	{ 0x8d80, 0x224054 },
	{ 0x8d81, 0x21623f },
	{ 0x8d82, 0x233f39 },
	{ 0x8d83, 0x233f34 },
	{ 0x8d84, 0x224053 },
	{ 0x8d85, 0x21623e },
	{ 0x8d86, 0x233f37 },
	{ 0x8d87, 0x233f30 },
	{ 0x8d88, 0x233f33 },
	{ 0x8d89, 0x224055 },
	{ 0x8d8a, 0x21623d },
	{ 0x8d8b, 0x233f38 },
	{ 0x8d8c, 0x224765 },
	{ 0x8d8d, 0x224768 },
	{ 0x8d8e, 0x224766 },
	{ 0x8d8f, 0x224767 },
	{ 0x8d90, 0x22476b },
	{ 0x8d91, 0x224764 },
	{ 0x8d92, 0x22476c },
	{ 0x8d93, 0x224769 },
	{ 0x8d94, 0x22476a },
	{ 0x8d95, 0x216b38 },
	{ 0x8d96, 0x224e3e },
	{ 0x8d97, 0x234975 },
	{ 0x8d98, 0x234973 },
	{ 0x8d99, 0x216b37 },
	{ 0x8d9a, 0x234974 },
	{ 0x8d9b, 0x22545b },
	{ 0x8d9c, 0x225459 },
	{ 0x8d9d, 0x234f26 },
	{ 0x8d9f, 0x216f36 },
	{ 0x8da0, 0x225458 },
	{ 0x8da1, 0x22545a },
	{ 0x8da2, 0x234f25 },
	{ 0x8da3, 0x216f37 },
	{ 0x8da4, 0x234f23 },
	{ 0x8da5, 0x225a67 },
	{ 0x8da6, 0x235277 },
	{ 0x8da7, 0x225a68 },
	{ 0x8da8, 0x217558 },
	{ 0x8da9, 0x235931 },
	{ 0x8daa, 0x226738 },
	{ 0x8dab, 0x22673a },
	{ 0x8dac, 0x226737 },
	{ 0x8dad, 0x226739 },
	{ 0x8dae, 0x226a24 },
	{ 0x8daf, 0x226c43 },
	{ 0x8db0, 0x236651 },
	{ 0x8db2, 0x22715e },
	{ 0x8db3, 0x214b4d },
	{ 0x8db4, 0x21535a },
	{ 0x8db5, 0x223329 },
	{ 0x8db6, 0x22332b },
	{ 0x8db7, 0x22332a },
	{ 0x8db9, 0x22395b },
	{ 0x8dba, 0x215d52 },
	{ 0x8dbb, 0x23393e },
	{ 0x8dbc, 0x223959 },
	{ 0x8dbd, 0x23393a },
	{ 0x8dbe, 0x215d51 },
	{ 0x8dbf, 0x22395c },
	{ 0x8dc0, 0x23393d },
	{ 0x8dc1, 0x22395d },
	{ 0x8dc2, 0x22395a },
	{ 0x8dc5, 0x224061 },
	{ 0x8dc6, 0x216247 },
	{ 0x8dc7, 0x224059 },
	{ 0x8dc8, 0x22405f },
	{ 0x8dc9, 0x233f3f },
	{ 0x8dca, 0x233f3a },
	{ 0x8dcb, 0x216242 },
	{ 0x8dcc, 0x216245 },
	{ 0x8dcd, 0x224058 },
	{ 0x8dce, 0x216240 },
	{ 0x8dcf, 0x22405c },
	{ 0x8dd0, 0x224772 },
	{ 0x8dd1, 0x216244 },
	{ 0x8dd2, 0x233f3b },
	{ 0x8dd3, 0x224057 },
	{ 0x8dd4, 0x233f3e },
	{ 0x8dd5, 0x22405d },
	{ 0x8dd6, 0x22405a },
	{ 0x8dd7, 0x224060 },
	{ 0x8dd8, 0x224056 },
	{ 0x8dd9, 0x22405e },
	{ 0x8dda, 0x216243 },
	{ 0x8ddb, 0x216246 },
	{ 0x8ddc, 0x22405b },
	{ 0x8ddd, 0x216241 },
	{ 0x8ddf, 0x216679 },
	{ 0x8de0, 0x22476e },
	{ 0x8de1, 0x216678 },
	{ 0x8de2, 0x224775 },
	{ 0x8de3, 0x224774 },
	{ 0x8de4, 0x216721 },
	{ 0x8de6, 0x216722 },
	{ 0x8de7, 0x224776 },
	{ 0x8de8, 0x21667a },
	{ 0x8de9, 0x224773 },
	{ 0x8dea, 0x21667e },
	{ 0x8deb, 0x224778 },
	{ 0x8dec, 0x22476f },
	{ 0x8ded, 0x23446b },
	{ 0x8dee, 0x224771 },
	{ 0x8def, 0x21667b },
	{ 0x8df0, 0x22476d },
	{ 0x8df1, 0x224770 },
	{ 0x8df2, 0x224777 },
	{ 0x8df3, 0x21667c },
	{ 0x8df4, 0x224779 },
	{ 0x8dfa, 0x21667d },
	{ 0x8dfc, 0x216b39 },
	{ 0x8dfd, 0x224e43 },
	{ 0x8dfe, 0x224e49 },
	{ 0x8dff, 0x224e41 },
	{ 0x8e00, 0x224e4a },
	{ 0x8e01, 0x23497b },
	{ 0x8e02, 0x224e40 },
	{ 0x8e03, 0x224e45 },
	{ 0x8e04, 0x224e4b },
	{ 0x8e05, 0x224e48 },
	{ 0x8e06, 0x224e47 },
	{ 0x8e07, 0x224e46 },
	{ 0x8e08, 0x23497a },
	{ 0x8e09, 0x224e3f },
	{ 0x8e0a, 0x224e44 },
	{ 0x8e0b, 0x234979 },
	{ 0x8e0d, 0x224e42 },
	{ 0x8e0f, 0x216f3c },
	{ 0x8e10, 0x216f39 },
	{ 0x8e11, 0x225464 },
	{ 0x8e12, 0x225469 },
	{ 0x8e13, 0x22546b },
	{ 0x8e14, 0x225468 },
	{ 0x8e15, 0x225461 },
	{ 0x8e16, 0x225463 },
	{ 0x8e17, 0x22546d },
	{ 0x8e18, 0x22546a },
	{ 0x8e19, 0x225465 },
	{ 0x8e1a, 0x22546e },
	{ 0x8e1b, 0x225462 },
	{ 0x8e1c, 0x22546c },
	{ 0x8e1d, 0x216f3a },
	{ 0x8e1e, 0x216f40 },
	{ 0x8e1f, 0x216f3e },
	{ 0x8e20, 0x22545c },
	{ 0x8e21, 0x216f3f },
	{ 0x8e22, 0x216f3b },
	{ 0x8e23, 0x22545d },
	{ 0x8e24, 0x22545f },
	{ 0x8e25, 0x22545e },
	{ 0x8e26, 0x225466 },
	{ 0x8e27, 0x225467 },
	{ 0x8e28, 0x234f2c },
	{ 0x8e29, 0x216f3d },
	{ 0x8e2a, 0x234f2b },
	{ 0x8e2b, 0x216f38 },
	{ 0x8e2e, 0x225460 },
	{ 0x8e30, 0x225a72 },
	{ 0x8e31, 0x21724c },
	{ 0x8e32, 0x23527e },
	{ 0x8e33, 0x225a69 },
	{ 0x8e34, 0x21724d },
	{ 0x8e35, 0x217250 },
	{ 0x8e36, 0x225a6e },
	{ 0x8e38, 0x225a6b },
	{ 0x8e39, 0x21724f },
	{ 0x8e3b, 0x23527b },
	{ 0x8e3c, 0x225a6f },
	{ 0x8e3d, 0x225a70 },
	{ 0x8e3e, 0x225a6a },
	{ 0x8e3f, 0x225a73 },
	{ 0x8e40, 0x225a6c },
	{ 0x8e41, 0x225a71 },
	{ 0x8e42, 0x21724e },
	{ 0x8e43, 0x23527c },
	{ 0x8e44, 0x21724b },
	{ 0x8e45, 0x225a6d },
	{ 0x8e46, 0x235654 },
	{ 0x8e47, 0x225f6b },
	{ 0x8e48, 0x21755b },
	{ 0x8e49, 0x217559 },
	{ 0x8e4a, 0x21755c },
	{ 0x8e4b, 0x21755a },
	{ 0x8e4c, 0x225f6a },
	{ 0x8e4d, 0x225f67 },
	{ 0x8e4e, 0x225f66 },
	{ 0x8e4f, 0x235655 },
	{ 0x8e50, 0x225f69 },
	{ 0x8e53, 0x225f68 },
	{ 0x8e54, 0x22636f },
	{ 0x8e55, 0x217749 },
	{ 0x8e56, 0x226366 },
	{ 0x8e57, 0x226365 },
	{ 0x8e58, 0x235932 },
	{ 0x8e59, 0x217744 },
	{ 0x8e5a, 0x22636b },
	{ 0x8e5b, 0x22636a },
	{ 0x8e5c, 0x226362 },
	{ 0x8e5d, 0x22636d },
	{ 0x8e5e, 0x226367 },
	{ 0x8e5f, 0x217748 },
	{ 0x8e60, 0x226364 },
	{ 0x8e61, 0x22636c },
	{ 0x8e62, 0x226363 },
	{ 0x8e63, 0x217745 },
	{ 0x8e64, 0x217747 },
	{ 0x8e65, 0x226368 },
	{ 0x8e66, 0x217746 },
	{ 0x8e67, 0x226369 },
	{ 0x8e68, 0x235b3a },
	{ 0x8e69, 0x22636e },
	{ 0x8e6a, 0x22673e },
	{ 0x8e6b, 0x235b39 },
	{ 0x8e6c, 0x21792b },
	{ 0x8e6d, 0x22673b },
	{ 0x8e6f, 0x22673f },
	{ 0x8e70, 0x235b3b },
	{ 0x8e72, 0x217928 },
	{ 0x8e73, 0x22673d },
	{ 0x8e74, 0x21792d },
	{ 0x8e75, 0x235b3c },
	{ 0x8e76, 0x21792a },
	{ 0x8e77, 0x235b3d },
	{ 0x8e78, 0x22673c },
	{ 0x8e7a, 0x21792c },
	{ 0x8e7b, 0x226740 },
	{ 0x8e7c, 0x217927 },
	{ 0x8e81, 0x217a47 },
	{ 0x8e82, 0x217a49 },
	{ 0x8e83, 0x235d37 },
	{ 0x8e84, 0x226a27 },
	{ 0x8e85, 0x217a48 },
	{ 0x8e86, 0x226a25 },
	{ 0x8e87, 0x217929 },
	{ 0x8e88, 0x226a26 },
	{ 0x8e89, 0x217a46 },
	{ 0x8e8a, 0x217b2f },
	{ 0x8e8b, 0x217b31 },
	{ 0x8e8c, 0x226c45 },
	{ 0x8e8d, 0x217b30 },
	{ 0x8e8e, 0x226c44 },
	{ 0x8e90, 0x226e30 },
	{ 0x8e91, 0x217b77 },
	{ 0x8e92, 0x226e2f },
	{ 0x8e93, 0x217b78 },
	{ 0x8e94, 0x226e2d },
	{ 0x8e95, 0x226e2c },
	{ 0x8e96, 0x226e31 },
	{ 0x8e97, 0x226e32 },
	{ 0x8e98, 0x226f54 },
	{ 0x8e99, 0x23604b },
	{ 0x8e9a, 0x226e2e },
	{ 0x8e9d, 0x227054 },
	{ 0x8e9e, 0x227051 },
	{ 0x8e9f, 0x227052 },
	{ 0x8ea0, 0x227053 },
	{ 0x8ea1, 0x217d29 },
	{ 0x8ea2, 0x236150 },
	{ 0x8ea3, 0x227140 },
	{ 0x8ea4, 0x22713f },
	{ 0x8ea5, 0x22713e },
	{ 0x8ea6, 0x22715f },
	{ 0x8ea7, 0x23616c },
	{ 0x8ea8, 0x22722e },
	{ 0x8ea9, 0x227179 },
	{ 0x8eaa, 0x217d3b },
	{ 0x8eab, 0x214b4e },
	{ 0x8eac, 0x215845 },
	{ 0x8ead, 0x23393f },
	{ 0x8eaf, 0x233940 },
	{ 0x8eb0, 0x233f40 },
	{ 0x8eb1, 0x234473 },
	{ 0x8eb2, 0x216723 },
	{ 0x8eb3, 0x23497d },
	{ 0x8eb4, 0x23497c },
	{ 0x8eb6, 0x234f30 },
	{ 0x8eb7, 0x234f32 },
	{ 0x8eb8, 0x234f2f },
	{ 0x8eb9, 0x234f31 },
	{ 0x8eba, 0x216f41 },
	{ 0x8ebc, 0x236652 },
	{ 0x8ebd, 0x225a74 },
	{ 0x8ebf, 0x235935 },
	{ 0x8ec0, 0x21774a },
	{ 0x8ec1, 0x235936 },
	{ 0x8ec2, 0x226741 },
	{ 0x8ec3, 0x235b3f },
	{ 0x8ec6, 0x235d38 },
	{ 0x8ec9, 0x22717a },
	{ 0x8eca, 0x214b4f },
	{ 0x8ecb, 0x214f51 },
	{ 0x8ecc, 0x21535c },
	{ 0x8ecd, 0x21535b },
	{ 0x8ecf, 0x215848 },
	{ 0x8ed1, 0x22332c },
	{ 0x8ed2, 0x215846 },
	{ 0x8ed3, 0x22332d },
	{ 0x8ed4, 0x215847 },
	{ 0x8ed5, 0x236653 },
	{ 0x8ed6, 0x233941 },
	{ 0x8ed7, 0x223962 },
	{ 0x8ed8, 0x22395e },
	{ 0x8ed9, 0x233947 },
	{ 0x8edb, 0x215d53 },
	{ 0x8edc, 0x223961 },
	{ 0x8edd, 0x223960 },
	{ 0x8ede, 0x22395f },
	{ 0x8edf, 0x215d54 },
	{ 0x8ee0, 0x223963 },
	{ 0x8ee1, 0x223964 },
	{ 0x8ee4, 0x233f45 },
	{ 0x8ee5, 0x224068 },
	{ 0x8ee6, 0x224066 },
	{ 0x8ee7, 0x22406a },
	{ 0x8ee8, 0x22406b },
	{ 0x8ee9, 0x224071 },
	{ 0x8eea, 0x233f47 },
	{ 0x8eeb, 0x22406d },
	{ 0x8eec, 0x22406f },
	{ 0x8eee, 0x224067 },
	{ 0x8eef, 0x224062 },
	{ 0x8ef1, 0x22406e },
	{ 0x8ef2, 0x233f44 },
	{ 0x8ef3, 0x233f46 },
	{ 0x8ef4, 0x224070 },
	{ 0x8ef5, 0x224069 },
	{ 0x8ef6, 0x22406c },
	{ 0x8ef7, 0x224063 },
	{ 0x8ef8, 0x216249 },
	{ 0x8ef9, 0x224065 },
	{ 0x8efa, 0x224064 },
	{ 0x8efb, 0x216248 },
	{ 0x8efc, 0x21624a },
	{ 0x8efd, 0x233f49 },
	{ 0x8efe, 0x216726 },
	{ 0x8eff, 0x22477b },
	{ 0x8f00, 0x22477d },
	{ 0x8f01, 0x22477c },
	{ 0x8f02, 0x224823 },
	{ 0x8f03, 0x216724 },
	{ 0x8f04, 0x234476 },
	{ 0x8f05, 0x22477e },
	{ 0x8f06, 0x22477a },
	{ 0x8f07, 0x224821 },
	{ 0x8f08, 0x224822 },
	{ 0x8f09, 0x216725 },
	{ 0x8f0a, 0x216727 },
	{ 0x8f0b, 0x224824 },
	{ 0x8f0d, 0x224e4f },
	{ 0x8f0e, 0x224e4e },
	{ 0x8f10, 0x224e4c },
	{ 0x8f11, 0x224e4d },
	{ 0x8f12, 0x216b3b },
	{ 0x8f13, 0x216b3d },
	{ 0x8f14, 0x216b3a },
	{ 0x8f15, 0x216b3c },
	{ 0x8f16, 0x225475 },
	{ 0x8f17, 0x225476 },
	{ 0x8f18, 0x225471 },
	{ 0x8f19, 0x234f36 },
	{ 0x8f1a, 0x225472 },
	{ 0x8f1b, 0x216f43 },
	{ 0x8f1c, 0x216f48 },
	{ 0x8f1d, 0x216f42 },
	{ 0x8f1e, 0x216f49 },
	{ 0x8f1f, 0x216f44 },
	{ 0x8f20, 0x225473 },
	{ 0x8f22, 0x234f33 },
	{ 0x8f23, 0x225474 },
	{ 0x8f24, 0x225470 },
	{ 0x8f25, 0x216f4a },
	{ 0x8f26, 0x216f46 },
	{ 0x8f27, 0x234f35 },
	{ 0x8f29, 0x216f45 },
	{ 0x8f2a, 0x216f47 },
	{ 0x8f2b, 0x234f34 },
	{ 0x8f2c, 0x22546f },
	{ 0x8f2d, 0x235324 },
	{ 0x8f2e, 0x225a76 },
	{ 0x8f2f, 0x217252 },
	{ 0x8f30, 0x235322 },
	{ 0x8f31, 0x235321 },
	{ 0x8f32, 0x225a78 },
	{ 0x8f33, 0x217254 },
	{ 0x8f34, 0x225a7b },
	{ 0x8f35, 0x225a77 },
	{ 0x8f36, 0x225a75 },
	{ 0x8f37, 0x225a7a },
	{ 0x8f38, 0x217253 },
	{ 0x8f39, 0x225a79 },
	{ 0x8f3b, 0x217251 },
	{ 0x8f3c, 0x235325 },
	{ 0x8f3d, 0x235659 },
	{ 0x8f3e, 0x21755e },
	{ 0x8f3f, 0x217561 },
	{ 0x8f40, 0x225f6d },
	{ 0x8f41, 0x23565a },
	{ 0x8f42, 0x21755f },
	{ 0x8f43, 0x225f6c },
	{ 0x8f44, 0x21755d },
	{ 0x8f45, 0x217560 },
	{ 0x8f46, 0x226370 },
	{ 0x8f47, 0x226371 },
	{ 0x8f48, 0x226372 },
	{ 0x8f49, 0x21774b },
	{ 0x8f4a, 0x235937 },
	{ 0x8f4b, 0x226373 },
	{ 0x8f4d, 0x21774c },
	{ 0x8f4e, 0x21792f },
	{ 0x8f4f, 0x226744 },
	{ 0x8f50, 0x226745 },
	{ 0x8f51, 0x226743 },
	{ 0x8f52, 0x226742 },
	{ 0x8f53, 0x226746 },
	{ 0x8f54, 0x21792e },
	{ 0x8f55, 0x226a2b },
	{ 0x8f56, 0x226a29 },
	{ 0x8f57, 0x226a2a },
	{ 0x8f58, 0x226a2c },
	{ 0x8f59, 0x226a28 },
	{ 0x8f5a, 0x226a2d },
	{ 0x8f5b, 0x226c47 },
	{ 0x8f5c, 0x235e67 },
	{ 0x8f5d, 0x226c48 },
	{ 0x8f5e, 0x226c46 },
	{ 0x8f5f, 0x217b32 },
	{ 0x8f60, 0x226e33 },
	{ 0x8f61, 0x217b79 },
	{ 0x8f62, 0x226e34 },
	{ 0x8f63, 0x226f56 },
	{ 0x8f64, 0x226f55 },
	{ 0x8f65, 0x236222 },
	{ 0x8f9b, 0x214b50 },
	{ 0x8f9c, 0x21624b },
	{ 0x8f9d, 0x233f4b },
	{ 0x8f9e, 0x234477 },
	{ 0x8f9f, 0x216728 },
	{ 0x8fa0, 0x234478 },
	{ 0x8fa1, 0x234a21 },
	{ 0x8fa2, 0x234a22 },
	{ 0x8fa3, 0x216b3e },
	{ 0x8fa4, 0x234f37 },
	{ 0x8fa5, 0x235327 },
	{ 0x8fa6, 0x217256 },
	{ 0x8fa7, 0x235326 },
	{ 0x8fa8, 0x217255 },
	{ 0x8faa, 0x236654 },
	{ 0x8fac, 0x235938 },
	{ 0x8fad, 0x217930 },
	{ 0x8fae, 0x217a29 },
	{ 0x8faf, 0x217b33 },
	{ 0x8fb0, 0x214b51 },
	{ 0x8fb1, 0x215849 },
	{ 0x8fb2, 0x216729 },
	{ 0x8fb3, 0x234f39 },
	{ 0x8fb4, 0x226747 },
	{ 0x8fb5, 0x23272f },
	{ 0x8fb9, 0x23243b },
	{ 0x8fbe, 0x232730 },
	{ 0x8fbf, 0x222526 },
	{ 0x8fc1, 0x232733 },
	{ 0x8fc2, 0x214b52 },
	{ 0x8fc4, 0x214b55 },
	{ 0x8fc5, 0x214b54 },
	{ 0x8fc6, 0x214b53 },
	{ 0x8fc7, 0x232731 },
	{ 0x8fc9, 0x222525 },
	{ 0x8fca, 0x232a72 },
	{ 0x8fcb, 0x22286d },
	{ 0x8fcc, 0x232a70 },
	{ 0x8fcd, 0x22286f },
	{ 0x8fce, 0x214f52 },
	{ 0x8fcf, 0x232a74 },
	{ 0x8fd1, 0x214f54 },
	{ 0x8fd2, 0x22286c },
	{ 0x8fd3, 0x22286e },
	{ 0x8fd4, 0x214f53 },
	{ 0x8fd5, 0x222871 },
	{ 0x8fd6, 0x222870 },
	{ 0x8fd7, 0x222872 },
	{ 0x8fd8, 0x232a73 },
	{ 0x8fd9, 0x232a71 },
	{ 0x8fe0, 0x222d57 },
	{ 0x8fe1, 0x222d55 },
	{ 0x8fe2, 0x21535f },
	{ 0x8fe3, 0x222d54 },
	{ 0x8fe4, 0x215364 },
	{ 0x8fe5, 0x215361 },
	{ 0x8fe6, 0x21535e },
	{ 0x8fe7, 0x232f31 },
	{ 0x8fe8, 0x215365 },
	{ 0x8fe9, 0x232f32 },
	{ 0x8fea, 0x215360 },
	{ 0x8feb, 0x215363 },
	{ 0x8fed, 0x215362 },
	{ 0x8fee, 0x222d56 },
	{ 0x8fef, 0x232f33 },
	{ 0x8ff0, 0x21535d },
	{ 0x8ff1, 0x232f30 },
	{ 0x8ff4, 0x21584f },
	{ 0x8ff5, 0x22332f },
	{ 0x8ff6, 0x223335 },
	{ 0x8ff7, 0x21584c },
	{ 0x8ff8, 0x215853 },
	{ 0x8ff9, 0x233425 },
	{ 0x8ffa, 0x21584e },
	{ 0x8ffb, 0x223332 },
	{ 0x8ffc, 0x223334 },
	{ 0x8ffd, 0x215851 },
	{ 0x8ffe, 0x22332e },
	{ 0x8fff, 0x223331 },
	{ 0x9000, 0x21584d },
	{ 0x9001, 0x21584a },
	{ 0x9002, 0x223330 },
	{ 0x9003, 0x215850 },
	{ 0x9004, 0x223333 },
	{ 0x9005, 0x215852 },
	{ 0x9006, 0x21584b },
	{ 0x9008, 0x233427 },
	{ 0x9009, 0x233426 },
	{ 0x900b, 0x223966 },
	{ 0x900c, 0x223969 },
	{ 0x900d, 0x215d56 },
	{ 0x900e, 0x23394b },
	{ 0x900f, 0x215d60 },
	{ 0x9010, 0x215d5c },
	{ 0x9011, 0x223967 },
	{ 0x9012, 0x23394a },
	{ 0x9013, 0x23394e },
	{ 0x9014, 0x215d64 },
	{ 0x9015, 0x215d5d },
	{ 0x9016, 0x215d62 },
	{ 0x9017, 0x215d58 },
	{ 0x9019, 0x215d55 },
	{ 0x901a, 0x215d57 },
	{ 0x901b, 0x215d63 },
	{ 0x901c, 0x223968 },
	{ 0x901d, 0x215d5b },
	{ 0x901e, 0x215d5e },
	{ 0x901f, 0x215d5a },
	{ 0x9020, 0x215d5f },
	{ 0x9021, 0x22396a },
	{ 0x9022, 0x215d61 },
	{ 0x9023, 0x215d59 },
	{ 0x9024, 0x223965 },
	{ 0x9025, 0x23394c },
	{ 0x9028, 0x233f4f },
	{ 0x9029, 0x233f50 },
	{ 0x902a, 0x233f4d },
	{ 0x902b, 0x233f4c },
	{ 0x902c, 0x233f51 },
	{ 0x902d, 0x224072 },
	{ 0x902e, 0x21624c },
	{ 0x902f, 0x224074 },
	{ 0x9030, 0x233f55 },
	{ 0x9031, 0x21624e },
	{ 0x9032, 0x216250 },
	{ 0x9034, 0x224073 },
	{ 0x9035, 0x21624d },
	{ 0x9036, 0x216251 },
	{ 0x9037, 0x233f56 },
	{ 0x9038, 0x21624f },
	{ 0x903a, 0x233f54 },
	{ 0x903b, 0x233f57 },
	{ 0x903c, 0x21672f },
	{ 0x903d, 0x224829 },
	{ 0x903e, 0x216737 },
	{ 0x903f, 0x224826 },
	{ 0x9040, 0x23447d },
	{ 0x9041, 0x216738 },
	{ 0x9042, 0x21672d },
	{ 0x9043, 0x234479 },
	{ 0x9044, 0x224827 },
	{ 0x9045, 0x23447c },
	{ 0x9046, 0x23447a },
	{ 0x9047, 0x216732 },
	{ 0x9048, 0x23447b },
	{ 0x9049, 0x224828 },
	{ 0x904a, 0x21672b },
	{ 0x904b, 0x21672a },
	{ 0x904c, 0x23447e },
	{ 0x904d, 0x216735 },
	{ 0x904e, 0x216734 },
	{ 0x904f, 0x216733 },
	{ 0x9050, 0x216731 },
	{ 0x9051, 0x216736 },
	{ 0x9052, 0x224825 },
	{ 0x9053, 0x21672c },
	{ 0x9054, 0x21672e },
	{ 0x9055, 0x216730 },
	{ 0x9058, 0x216b40 },
	{ 0x9059, 0x216b43 },
	{ 0x905a, 0x234a24 },
	{ 0x905b, 0x216b47 },
	{ 0x905c, 0x216b41 },
	{ 0x905d, 0x216b46 },
	{ 0x905e, 0x216b44 },
	{ 0x905f, 0x234a27 },
	{ 0x9060, 0x216b3f },
	{ 0x9061, 0x234a26 },
	{ 0x9062, 0x216b45 },
	{ 0x9063, 0x216b42 },
	{ 0x9067, 0x22547a },
	{ 0x9068, 0x216f4d },
	{ 0x9069, 0x216f4b },
	{ 0x906a, 0x234f3c },
	{ 0x906b, 0x22547b },
	{ 0x906d, 0x216f4e },
	{ 0x906e, 0x216f4c },
	{ 0x906f, 0x225479 },
	{ 0x9070, 0x225478 },
	{ 0x9071, 0x234f3b },
	{ 0x9072, 0x21725a },
	{ 0x9073, 0x225477 },
	{ 0x9074, 0x217258 },
	{ 0x9075, 0x217257 },
	{ 0x9076, 0x225a7c },
	{ 0x9077, 0x216f4f },
	{ 0x9078, 0x217259 },
	{ 0x9079, 0x225a7d },
	{ 0x907a, 0x21725c },
	{ 0x907b, 0x225a7e },
	{ 0x907c, 0x21725b },
	{ 0x907d, 0x217563 },
	{ 0x907e, 0x225f6f },
	{ 0x907f, 0x217562 },
	{ 0x9080, 0x217567 },
	{ 0x9081, 0x217565 },
	{ 0x9082, 0x217566 },
	{ 0x9083, 0x21774e },
	{ 0x9084, 0x217564 },
	{ 0x9085, 0x225f6e },
	{ 0x9086, 0x225b21 },
	{ 0x9087, 0x21774d },
	{ 0x9088, 0x21774f },
	{ 0x9089, 0x23593a },
	{ 0x908a, 0x217931 },
	{ 0x908b, 0x217932 },
	{ 0x908d, 0x226a2e },
	{ 0x908f, 0x217c4a },
	{ 0x9090, 0x217c49 },
	{ 0x9091, 0x214b57 },
	{ 0x9092, 0x23225e },
	{ 0x9093, 0x23225d },
	{ 0x9094, 0x222275 },
	{ 0x9095, 0x215854 },
	{ 0x9096, 0x23243c },
	{ 0x9097, 0x222272 },
	{ 0x9098, 0x222273 },
	{ 0x9099, 0x222271 },
	{ 0x909a, 0x23243d },
	{ 0x909b, 0x222274 },
	{ 0x909c, 0x236655 },
	{ 0x909e, 0x22252a },
	{ 0x909f, 0x222527 },
	{ 0x90a0, 0x22252c },
	{ 0x90a1, 0x222528 },
	{ 0x90a2, 0x214b58 },
	{ 0x90a3, 0x214b5b },
	{ 0x90a4, 0x232735 },
	{ 0x90a5, 0x222529 },
	{ 0x90a6, 0x214b5a },
	{ 0x90a7, 0x22252b },
	{ 0x90a8, 0x232739 },
	{ 0x90a9, 0x232734 },
	{ 0x90aa, 0x214b59 },
	{ 0x90ab, 0x233951 },
	{ 0x90ad, 0x232a77 },
	{ 0x90af, 0x222875 },
	{ 0x90b0, 0x222877 },
	{ 0x90b1, 0x214f57 },
	{ 0x90b2, 0x222873 },
	{ 0x90b3, 0x222876 },
	{ 0x90b4, 0x222874 },
	{ 0x90b5, 0x214f55 },
	{ 0x90b6, 0x214f58 },
	{ 0x90b7, 0x232a75 },
	{ 0x90b8, 0x214f56 },
	{ 0x90b9, 0x232a78 },
	{ 0x90bc, 0x232f35 },
	{ 0x90bd, 0x222d59 },
	{ 0x90be, 0x222d5d },
	{ 0x90bf, 0x222d5a },
	{ 0x90c0, 0x232f38 },
	{ 0x90c1, 0x215368 },
	{ 0x90c2, 0x232f34 },
	{ 0x90c3, 0x215369 },
	{ 0x90c4, 0x232f3e },
	{ 0x90c5, 0x222d5c },
	{ 0x90c6, 0x232f37 },
	{ 0x90c7, 0x222d5e },
	{ 0x90c8, 0x222d60 },
	{ 0x90c9, 0x232f3c },
	{ 0x90ca, 0x215366 },
	{ 0x90cb, 0x222d5f },
	{ 0x90cd, 0x232f3b },
	{ 0x90ce, 0x215367 },
	{ 0x90d4, 0x223971 },
	{ 0x90d5, 0x222d5b },
	{ 0x90d6, 0x223336 },
	{ 0x90d7, 0x22333f },
	{ 0x90d8, 0x22333d },
	{ 0x90d9, 0x223338 },
	{ 0x90da, 0x223339 },
	{ 0x90db, 0x22333e },
	{ 0x90dc, 0x223340 },
	{ 0x90dd, 0x215856 },
	{ 0x90de, 0x233429 },
	{ 0x90df, 0x22333b },
	{ 0x90e0, 0x223337 },
	{ 0x90e1, 0x215855 },
	{ 0x90e2, 0x215857 },
	{ 0x90e3, 0x22333a },
	{ 0x90e4, 0x223341 },
	{ 0x90e5, 0x22333c },
	{ 0x90e8, 0x215d65 },
	{ 0x90e9, 0x223974 },
	{ 0x90ea, 0x22396c },
	{ 0x90eb, 0x223972 },
	{ 0x90ec, 0x223973 },
	{ 0x90ed, 0x215d66 },
	{ 0x90ee, 0x23394f },
	{ 0x90ef, 0x22396b },
	{ 0x90f0, 0x22396d },
	{ 0x90f1, 0x222d58 },
	{ 0x90f2, 0x22396f },
	{ 0x90f3, 0x223970 },
	{ 0x90f4, 0x22396e },
	{ 0x90f5, 0x216253 },
	{ 0x90f6, 0x23636c },
	{ 0x90f7, 0x233952 },
	{ 0x90f9, 0x22407b },
	{ 0x90fa, 0x225b22 },
	{ 0x90fb, 0x22407c },
	{ 0x90fc, 0x224079 },
	{ 0x90fd, 0x215d67 },
	{ 0x90fe, 0x216255 },
	{ 0x90ff, 0x224078 },
	{ 0x9100, 0x22407e },
	{ 0x9101, 0x22407d },
	{ 0x9102, 0x216252 },
	{ 0x9103, 0x224123 },
	{ 0x9104, 0x224077 },
	{ 0x9105, 0x224122 },
	{ 0x9106, 0x224075 },
	{ 0x9107, 0x224121 },
	{ 0x9108, 0x22407a },
	{ 0x9109, 0x216254 },
	{ 0x910a, 0x233f59 },
	{ 0x910b, 0x224830 },
	{ 0x910c, 0x234523 },
	{ 0x910d, 0x22482b },
	{ 0x910e, 0x224831 },
	{ 0x910f, 0x22482c },
	{ 0x9110, 0x22482a },
	{ 0x9111, 0x22482d },
	{ 0x9112, 0x216739 },
	{ 0x9113, 0x234524 },
	{ 0x9114, 0x22482f },
	{ 0x9115, 0x234525 },
	{ 0x9116, 0x22482e },
	{ 0x9117, 0x21673a },
	{ 0x9118, 0x216b49 },
	{ 0x9119, 0x216b48 },
	{ 0x911a, 0x224e56 },
	{ 0x911b, 0x224e59 },
	{ 0x911c, 0x224e51 },
	{ 0x911d, 0x224e55 },
	{ 0x911e, 0x216b4a },
	{ 0x911f, 0x224e54 },
	{ 0x9120, 0x224e52 },
	{ 0x9121, 0x224e58 },
	{ 0x9122, 0x224e53 },
	{ 0x9123, 0x224e50 },
	{ 0x9124, 0x224e57 },
	{ 0x9125, 0x234a2a },
	{ 0x9126, 0x225523 },
	{ 0x9127, 0x216f52 },
	{ 0x9128, 0x226374 },
	{ 0x9129, 0x22547e },
	{ 0x912a, 0x225521 },
	{ 0x912b, 0x22547d },
	{ 0x912c, 0x224076 },
	{ 0x912d, 0x216f51 },
	{ 0x912e, 0x225524 },
	{ 0x912f, 0x22547c },
	{ 0x9130, 0x216f50 },
	{ 0x9131, 0x216f53 },
	{ 0x9132, 0x225522 },
	{ 0x9133, 0x225b23 },
	{ 0x9134, 0x21725d },
	{ 0x9135, 0x225b24 },
	{ 0x9136, 0x225b25 },
	{ 0x9137, 0x23532b },
	{ 0x9138, 0x225f70 },
	{ 0x9139, 0x217568 },
	{ 0x913a, 0x226375 },
	{ 0x913b, 0x226376 },
	{ 0x913c, 0x23593c },
	{ 0x913d, 0x23593b },
	{ 0x913e, 0x226377 },
	{ 0x913f, 0x226749 },
	{ 0x9140, 0x226748 },
	{ 0x9141, 0x226a30 },
	{ 0x9143, 0x226a2f },
	{ 0x9144, 0x226c4a },
	{ 0x9145, 0x226c4b },
	{ 0x9146, 0x226c49 },
	{ 0x9147, 0x226e35 },
	{ 0x9148, 0x217b7a },
	{ 0x9149, 0x214b5c },
	{ 0x914a, 0x21536b },
	{ 0x914b, 0x21536a },
	{ 0x914c, 0x21585a },
	{ 0x914d, 0x215859 },
	{ 0x914e, 0x223343 },
	{ 0x914f, 0x223344 },
	{ 0x9150, 0x223342 },
	{ 0x9151, 0x23342a },
	{ 0x9152, 0x215858 },
	{ 0x9153, 0x223978 },
	{ 0x9154, 0x233955 },
	{ 0x9155, 0x223979 },
	{ 0x9156, 0x223975 },
	{ 0x9157, 0x215d68 },
	{ 0x9158, 0x223976 },
	{ 0x9159, 0x233954 },
	{ 0x915a, 0x223977 },
	{ 0x915c, 0x236657 },
	{ 0x915f, 0x224126 },
	{ 0x9160, 0x224128 },
	{ 0x9161, 0x224124 },
	{ 0x9162, 0x224127 },
	{ 0x9163, 0x216256 },
	{ 0x9164, 0x224125 },
	{ 0x9165, 0x216257 },
	{ 0x9167, 0x234528 },
	{ 0x9168, 0x224279 },
	{ 0x9169, 0x21673d },
	{ 0x916a, 0x21673c },
	{ 0x916b, 0x234527 },
	{ 0x916c, 0x21673b },
	{ 0x916e, 0x224832 },
	{ 0x916f, 0x224833 },
	{ 0x9172, 0x224e5b },
	{ 0x9173, 0x224e5d },
	{ 0x9174, 0x216b4e },
	{ 0x9175, 0x216b4b },
	{ 0x9176, 0x234a2c },
	{ 0x9177, 0x216b4d },
	{ 0x9178, 0x216b4c },
	{ 0x9179, 0x224e5c },
	{ 0x917a, 0x224e5a },
	{ 0x917b, 0x234a2b },
	{ 0x917c, 0x234a2d },
	{ 0x9180, 0x22552b },
	{ 0x9181, 0x225528 },
	{ 0x9182, 0x225529 },
	{ 0x9183, 0x216f57 },
	{ 0x9184, 0x22552a },
	{ 0x9185, 0x225525 },
	{ 0x9186, 0x225526 },
	{ 0x9187, 0x216f54 },
	{ 0x9188, 0x234f3f },
	{ 0x9189, 0x216f55 },
	{ 0x918a, 0x225527 },
	{ 0x918b, 0x216f56 },
	{ 0x918c, 0x234f40 },
	{ 0x918d, 0x225b29 },
	{ 0x918e, 0x23532d },
	{ 0x918f, 0x225b2a },
	{ 0x9190, 0x225b27 },
	{ 0x9191, 0x225b28 },
	{ 0x9192, 0x21725e },
	{ 0x9193, 0x225b26 },
	{ 0x9195, 0x23532c },
	{ 0x9196, 0x23532f },
	{ 0x9199, 0x225f74 },
	{ 0x919a, 0x225f71 },
	{ 0x919b, 0x225f73 },
	{ 0x919c, 0x21756b },
	{ 0x919d, 0x225f77 },
	{ 0x919e, 0x21756a },
	{ 0x919f, 0x225f75 },
	{ 0x91a0, 0x225f78 },
	{ 0x91a1, 0x225f76 },
	{ 0x91a2, 0x225f72 },
	{ 0x91a3, 0x217569 },
	{ 0x91a5, 0x226379 },
	{ 0x91a7, 0x22637a },
	{ 0x91a8, 0x226378 },
	{ 0x91a9, 0x23593d },
	{ 0x91aa, 0x22637c },
	{ 0x91ab, 0x217750 },
	{ 0x91ac, 0x217751 },
	{ 0x91ad, 0x22674b },
	{ 0x91ae, 0x217934 },
	{ 0x91af, 0x22637b },
	{ 0x91b0, 0x22674a },
	{ 0x91b1, 0x217933 },
	{ 0x91b2, 0x226a33 },
	{ 0x91b3, 0x226a34 },
	{ 0x91b4, 0x217a4a },
	{ 0x91b5, 0x226a32 },
	{ 0x91b7, 0x226a31 },
	{ 0x91b9, 0x226c4c },
	{ 0x91ba, 0x217b34 },
	{ 0x91bb, 0x235e68 },
	{ 0x91bc, 0x226f57 },
	{ 0x91bd, 0x227056 },
	{ 0x91be, 0x227055 },
	{ 0x91bf, 0x23607e },
	{ 0x91c0, 0x217c6e },
	{ 0x91c1, 0x217d2a },
	{ 0x91c2, 0x227057 },
	{ 0x91c3, 0x227160 },
	{ 0x91c4, 0x23616d },
	{ 0x91c5, 0x217d3c },
	{ 0x91c6, 0x214b5d },
	{ 0x91c7, 0x214f59 },
	{ 0x91c9, 0x21673e },
	{ 0x91cb, 0x217a4b },
	{ 0x91cc, 0x214b5e },
	{ 0x91cd, 0x21536c },
	{ 0x91ce, 0x215d69 },
	{ 0x91cf, 0x216258 },
	{ 0x91d0, 0x217752 },
	{ 0x91d1, 0x214f5a },
	{ 0x91d3, 0x222d62 },
	{ 0x91d4, 0x222d61 },
	{ 0x91d5, 0x223345 },
	{ 0x91d6, 0x233430 },
	{ 0x91d7, 0x21585d },
	{ 0x91d8, 0x21585b },
	{ 0x91d9, 0x21585f },
	{ 0x91da, 0x223347 },
	{ 0x91db, 0x23342d },
	{ 0x91dc, 0x21585e },
	{ 0x91dd, 0x21585c },
	{ 0x91de, 0x23342f },
	{ 0x91df, 0x23342e },
	{ 0x91e0, 0x233431 },
	{ 0x91e2, 0x223346 },
	{ 0x91e3, 0x215d6c },
	{ 0x91e4, 0x223a21 },
	{ 0x91e5, 0x233958 },
	{ 0x91e6, 0x215d6b },
	{ 0x91e7, 0x215d6d },
	{ 0x91e8, 0x223a26 },
	{ 0x91e9, 0x215d6f },
	{ 0x91ea, 0x223a23 },
	{ 0x91eb, 0x223a24 },
	{ 0x91ec, 0x22397a },
	{ 0x91ed, 0x215d6e },
	{ 0x91ee, 0x223a27 },
	{ 0x91f0, 0x233957 },
	{ 0x91f1, 0x22397c },
	{ 0x91f2, 0x233956 },
	{ 0x91f3, 0x22397d },
	{ 0x91f4, 0x22397b },
	{ 0x91f5, 0x215d6a },
	{ 0x91f6, 0x233959 },
	{ 0x91f7, 0x223a25 },
	{ 0x91f8, 0x22397e },
	{ 0x91f9, 0x223a22 },
	{ 0x91fd, 0x224134 },
	{ 0x91fe, 0x233f5d },
	{ 0x91ff, 0x224133 },
	{ 0x9200, 0x224131 },
	{ 0x9201, 0x224129 },
	{ 0x9202, 0x224138 },
	{ 0x9203, 0x22412c },
	{ 0x9204, 0x224136 },
	{ 0x9205, 0x22413d },
	{ 0x9206, 0x224135 },
	{ 0x9207, 0x216260 },
	{ 0x9208, 0x233f66 },
	{ 0x9209, 0x21625c },
	{ 0x920a, 0x22412a },
	{ 0x920b, 0x233f60 },
	{ 0x920c, 0x224130 },
	{ 0x920d, 0x21625e },
	{ 0x920e, 0x233f68 },
	{ 0x920f, 0x22412f },
	{ 0x9210, 0x21625f },
	{ 0x9211, 0x216261 },
	{ 0x9212, 0x224132 },
	{ 0x9213, 0x233f69 },
	{ 0x9214, 0x216259 },
	{ 0x9215, 0x21625a },
	{ 0x9216, 0x22413e },
	{ 0x9217, 0x22413c },
	{ 0x9218, 0x233f62 },
	{ 0x9219, 0x22413b },
	{ 0x921a, 0x22412d },
	{ 0x921b, 0x233f65 },
	{ 0x921c, 0x224139 },
	{ 0x921e, 0x21625d },
	{ 0x9220, 0x233f5e },
	{ 0x9221, 0x236659 },
	{ 0x9222, 0x233f63 },
	{ 0x9223, 0x21625b },
	{ 0x9224, 0x22413a },
	{ 0x9225, 0x22412b },
	{ 0x9226, 0x22412e },
	{ 0x9227, 0x224137 },
	{ 0x922b, 0x236658 },
	{ 0x922d, 0x224f22 },
	{ 0x922e, 0x22483d },
	{ 0x922f, 0x23452e },
	{ 0x9230, 0x224836 },
	{ 0x9231, 0x224849 },
	{ 0x9232, 0x224852 },
	{ 0x9233, 0x224839 },
	{ 0x9234, 0x216749 },
	{ 0x9235, 0x23452b },
	{ 0x9236, 0x224846 },
	{ 0x9237, 0x21673f },
	{ 0x9238, 0x216741 },
	{ 0x9239, 0x21674d },
	{ 0x923a, 0x224837 },
	{ 0x923b, 0x234537 },
	{ 0x923c, 0x23452f },
	{ 0x923d, 0x216742 },
	{ 0x923e, 0x216744 },
	{ 0x923f, 0x21674e },
	{ 0x9240, 0x216743 },
	{ 0x9241, 0x234539 },
	{ 0x9244, 0x234538 },
	{ 0x9245, 0x21674c },
	{ 0x9246, 0x22483f },
	{ 0x9248, 0x224834 },
	{ 0x9249, 0x21674a },
	{ 0x924a, 0x22483e },
	{ 0x924b, 0x216746 },
	{ 0x924c, 0x224850 },
	{ 0x924d, 0x21674b },
	{ 0x924e, 0x22484e },
	{ 0x924f, 0x224842 },
	{ 0x9250, 0x22484c },
	{ 0x9251, 0x216748 },
	{ 0x9252, 0x224835 },
	{ 0x9253, 0x22484f },
	{ 0x9254, 0x22484a },
	{ 0x9255, 0x23452a },
	{ 0x9256, 0x224851 },
	{ 0x9257, 0x216740 },
	{ 0x9259, 0x23452d },
	{ 0x925a, 0x21674f },
	{ 0x925b, 0x216745 },
	{ 0x925c, 0x234531 },
	{ 0x925d, 0x234529 },
	{ 0x925e, 0x22483b },
	{ 0x925f, 0x234534 },
	{ 0x9260, 0x224843 },
	{ 0x9261, 0x224847 },
	{ 0x9262, 0x234533 },
	{ 0x9263, 0x22484b },
	{ 0x9264, 0x216747 },
	{ 0x9265, 0x22483a },
	{ 0x9266, 0x224838 },
	{ 0x9267, 0x224844 },
	{ 0x926a, 0x234532 },
	{ 0x926b, 0x234535 },
	{ 0x926c, 0x224841 },
	{ 0x926d, 0x224840 },
	{ 0x926e, 0x234536 },
	{ 0x926f, 0x224845 },
	{ 0x9270, 0x224848 },
	{ 0x9272, 0x22484d },
	{ 0x9273, 0x23665a },
	{ 0x9276, 0x224e60 },
	{ 0x9278, 0x216b4f },
	{ 0x9279, 0x224e6a },
	{ 0x927a, 0x224e62 },
	{ 0x927b, 0x216b55 },
	{ 0x927c, 0x216b59 },
	{ 0x927d, 0x224e73 },
	{ 0x927e, 0x224e7b },
	{ 0x927f, 0x224e6c },
	{ 0x9280, 0x216b51 },
	{ 0x9281, 0x234a34 },
	{ 0x9282, 0x224e70 },
	{ 0x9283, 0x22483c },
	{ 0x9284, 0x234a35 },
	{ 0x9285, 0x216b52 },
	{ 0x9286, 0x224e77 },
	{ 0x9287, 0x224e7c },
	{ 0x9288, 0x224e74 },
	{ 0x9289, 0x234a2f },
	{ 0x928a, 0x224e76 },
	{ 0x928b, 0x224f21 },
	{ 0x928c, 0x224e78 },
	{ 0x928d, 0x224e66 },
	{ 0x928e, 0x224e6f },
	{ 0x928f, 0x234530 },
	{ 0x9290, 0x234a38 },
	{ 0x9291, 0x216b5a },
	{ 0x9292, 0x234a33 },
	{ 0x9293, 0x216b56 },
	{ 0x9294, 0x224e64 },
	{ 0x9295, 0x224e71 },
	{ 0x9296, 0x216b54 },
	{ 0x9297, 0x224e6b },
	{ 0x9298, 0x216b53 },
	{ 0x9299, 0x224e79 },
	{ 0x929a, 0x224e68 },
	{ 0x929b, 0x224e61 },
	{ 0x929c, 0x216b57 },
	{ 0x929d, 0x224e7e },
	{ 0x929e, 0x234a39 },
	{ 0x92a0, 0x224e63 },
	{ 0x92a1, 0x224e75 },
	{ 0x92a2, 0x224e72 },
	{ 0x92a3, 0x224e6d },
	{ 0x92a4, 0x224e5f },
	{ 0x92a5, 0x224e5e },
	{ 0x92a6, 0x224e67 },
	{ 0x92a7, 0x224e7a },
	{ 0x92a8, 0x216b58 },
	{ 0x92a9, 0x224e7d },
	{ 0x92aa, 0x224e65 },
	{ 0x92ab, 0x224e69 },
	{ 0x92ac, 0x216b50 },
	{ 0x92ad, 0x234a32 },
	{ 0x92ae, 0x234a37 },
	{ 0x92b0, 0x23672a },
	{ 0x92b1, 0x234a31 },
	{ 0x92b2, 0x216f63 },
	{ 0x92b3, 0x216f5e },
	{ 0x92b4, 0x22554d },
	{ 0x92b5, 0x225549 },
	{ 0x92b6, 0x225531 },
	{ 0x92b7, 0x216f5a },
	{ 0x92b8, 0x234f42 },
	{ 0x92b9, 0x234f50 },
	{ 0x92bb, 0x216f59 },
	{ 0x92bc, 0x216f5f },
	{ 0x92be, 0x234f43 },
	{ 0x92bf, 0x234f41 },
	{ 0x92c0, 0x22552f },
	{ 0x92c1, 0x216f5d },
	{ 0x92c2, 0x22553b },
	{ 0x92c3, 0x22552d },
	{ 0x92c4, 0x22552e },
	{ 0x92c5, 0x216f58 },
	{ 0x92c6, 0x22554c },
	{ 0x92c7, 0x216f61 },
	{ 0x92c8, 0x22553e },
	{ 0x92c9, 0x225543 },
	{ 0x92ca, 0x22553d },
	{ 0x92cb, 0x225b3c },
	{ 0x92cc, 0x225539 },
	{ 0x92cd, 0x225541 },
	{ 0x92ce, 0x22553f },
	{ 0x92cf, 0x225532 },
	{ 0x92d0, 0x22552c },
	{ 0x92d1, 0x225547 },
	{ 0x92d2, 0x216f60 },
	{ 0x92d3, 0x225548 },
	{ 0x92d4, 0x234f48 },
	{ 0x92d5, 0x225542 },
	{ 0x92d6, 0x234f49 },
	{ 0x92d7, 0x225537 },
	{ 0x92d8, 0x225535 },
	{ 0x92d9, 0x225530 },
	{ 0x92da, 0x234f4b },
	{ 0x92db, 0x234f4e },
	{ 0x92dc, 0x234f44 },
	{ 0x92dd, 0x225538 },
	{ 0x92de, 0x225545 },
	{ 0x92df, 0x225534 },
	{ 0x92e0, 0x225544 },
	{ 0x92e1, 0x22554a },
	{ 0x92e2, 0x234f51 },
	{ 0x92e4, 0x216f5c },
	{ 0x92e5, 0x234f45 },
	{ 0x92e6, 0x225540 },
	{ 0x92e7, 0x225546 },
	{ 0x92e8, 0x22553c },
	{ 0x92e9, 0x225536 },
	{ 0x92ea, 0x216f5b },
	{ 0x92eb, 0x234f52 },
	{ 0x92ed, 0x234f4c },
	{ 0x92ee, 0x224e6e },
	{ 0x92ef, 0x22553a },
	{ 0x92f0, 0x216f62 },
	{ 0x92f1, 0x225533 },
	{ 0x92f3, 0x234f4d },
	{ 0x92f4, 0x23665b },
	{ 0x92f5, 0x23665c },
	{ 0x92f6, 0x234a30 },
	{ 0x92f7, 0x225b41 },
	{ 0x92f8, 0x217261 },
	{ 0x92f9, 0x225b40 },
	{ 0x92fa, 0x225b3e },
	{ 0x92fb, 0x225b50 },
	{ 0x92fc, 0x217265 },
	{ 0x92fd, 0x235335 },
	{ 0x92fe, 0x225b4d },
	{ 0x92ff, 0x225b45 },
	{ 0x9300, 0x225b4f },
	{ 0x9301, 0x225b37 },
	{ 0x9302, 0x225b43 },
	{ 0x9303, 0x23533d },
	{ 0x9304, 0x217267 },
	{ 0x9305, 0x23533e },
	{ 0x9306, 0x225b2f },
	{ 0x9307, 0x235338 },
	{ 0x9308, 0x225b2d },
	{ 0x9309, 0x225b4e },
	{ 0x930a, 0x235332 },
	{ 0x930b, 0x225b4c },
	{ 0x930c, 0x225b4b },
	{ 0x930d, 0x225b3b },
	{ 0x930e, 0x225b3a },
	{ 0x930f, 0x225b30 },
	{ 0x9310, 0x217269 },
	{ 0x9312, 0x225b36 },
	{ 0x9313, 0x225b3f },
	{ 0x9314, 0x225b4a },
	{ 0x9315, 0x21726c },
	{ 0x9316, 0x225b51 },
	{ 0x9317, 0x235336 },
	{ 0x9318, 0x217573 },
	{ 0x9319, 0x21726e },
	{ 0x931a, 0x217268 },
	{ 0x931b, 0x225b34 },
	{ 0x931c, 0x235337 },
	{ 0x931d, 0x225b3d },
	{ 0x931e, 0x225b2c },
	{ 0x931f, 0x225b2e },
	{ 0x9320, 0x21725f },
	{ 0x9321, 0x21726b },
	{ 0x9322, 0x217264 },
	{ 0x9323, 0x225b35 },
	{ 0x9324, 0x225b44 },
	{ 0x9325, 0x22554b },
	{ 0x9326, 0x21726a },
	{ 0x9327, 0x225b2b },
	{ 0x9328, 0x21756e },
	{ 0x9329, 0x225b46 },
	{ 0x932a, 0x225b49 },
	{ 0x932b, 0x217266 },
	{ 0x932c, 0x23533b },
	{ 0x932d, 0x225b39 },
	{ 0x932e, 0x21726d },
	{ 0x932f, 0x217263 },
	{ 0x9330, 0x23533c },
	{ 0x9331, 0x235339 },
	{ 0x9332, 0x23533a },
	{ 0x9333, 0x217262 },
	{ 0x9334, 0x225b42 },
	{ 0x9335, 0x225b48 },
	{ 0x9336, 0x217260 },
	{ 0x9338, 0x225b32 },
	{ 0x9339, 0x225b47 },
	{ 0x933c, 0x225b33 },
	{ 0x933f, 0x23665d },
	{ 0x9342, 0x23665e },
	{ 0x9345, 0x235331 },
	{ 0x9346, 0x225b38 },
	{ 0x9347, 0x225f7e },
	{ 0x9348, 0x235665 },
	{ 0x9349, 0x226025 },
	{ 0x934a, 0x217570 },
	{ 0x934b, 0x217572 },
	{ 0x934c, 0x22602b },
	{ 0x934d, 0x21756c },
	{ 0x934e, 0x226039 },
	{ 0x934f, 0x226031 },
	{ 0x9350, 0x226026 },
	{ 0x9351, 0x226027 },
	{ 0x9352, 0x226030 },
	{ 0x9353, 0x235666 },
	{ 0x9354, 0x217579 },
	{ 0x9355, 0x22602f },
	{ 0x9356, 0x225f7d },
	{ 0x9357, 0x22602e },
	{ 0x9358, 0x226022 },
	{ 0x9359, 0x22603a },
	{ 0x935a, 0x217578 },
	{ 0x935b, 0x217576 },
	{ 0x935c, 0x226023 },
	{ 0x935d, 0x23565d },
	{ 0x935e, 0x226036 },
	{ 0x935f, 0x235667 },
	{ 0x9360, 0x226028 },
	{ 0x9361, 0x226035 },
	{ 0x9362, 0x235664 },
	{ 0x9363, 0x226037 },
	{ 0x9364, 0x225f7c },
	{ 0x9365, 0x217571 },
	{ 0x9366, 0x23565b },
	{ 0x9367, 0x226038 },
	{ 0x9368, 0x235668 },
	{ 0x9369, 0x23565e },
	{ 0x936a, 0x22602c },
	{ 0x936b, 0x23566b },
	{ 0x936c, 0x217575 },
	{ 0x936d, 0x226029 },
	{ 0x936e, 0x235661 },
	{ 0x9370, 0x217577 },
	{ 0x9371, 0x226032 },
	{ 0x9372, 0x235662 },
	{ 0x9373, 0x235663 },
	{ 0x9374, 0x23565f },
	{ 0x9375, 0x21756f },
	{ 0x9376, 0x226024 },
	{ 0x9377, 0x226033 },
	{ 0x9378, 0x23565c },
	{ 0x9379, 0x22602d },
	{ 0x937a, 0x225b31 },
	{ 0x937b, 0x226034 },
	{ 0x937c, 0x226021 },
	{ 0x937d, 0x235660 },
	{ 0x937e, 0x217574 },
	{ 0x937f, 0x23566a },
	{ 0x9380, 0x22642f },
	{ 0x9382, 0x21756d },
	{ 0x9383, 0x225f7a },
	{ 0x9386, 0x23665f },
	{ 0x9388, 0x22642c },
	{ 0x9389, 0x226425 },
	{ 0x938a, 0x217754 },
	{ 0x938b, 0x235943 },
	{ 0x938c, 0x22637e },
	{ 0x938d, 0x226430 },
	{ 0x938e, 0x226427 },
	{ 0x938f, 0x22602a },
	{ 0x9390, 0x235940 },
	{ 0x9391, 0x226432 },
	{ 0x9392, 0x226421 },
	{ 0x9393, 0x235942 },
	{ 0x9394, 0x217753 },
	{ 0x9395, 0x22642b },
	{ 0x9396, 0x217755 },
	{ 0x9397, 0x21775d },
	{ 0x9398, 0x21775b },
	{ 0x9399, 0x22642d },
	{ 0x939a, 0x21775c },
	{ 0x939b, 0x226423 },
	{ 0x939c, 0x235949 },
	{ 0x939d, 0x226424 },
	{ 0x939e, 0x226429 },
	{ 0x939f, 0x22642e },
	{ 0x93a0, 0x23593e },
	{ 0x93a1, 0x225f79 },
	{ 0x93a2, 0x217756 },
	{ 0x93a3, 0x226437 },
	{ 0x93a4, 0x226434 },
	{ 0x93a5, 0x226761 },
	{ 0x93a6, 0x22642a },
	{ 0x93a7, 0x226426 },
	{ 0x93a8, 0x226435 },
	{ 0x93a9, 0x226756 },
	{ 0x93aa, 0x226428 },
	{ 0x93ac, 0x217759 },
	{ 0x93ad, 0x235944 },
	{ 0x93ae, 0x217758 },
	{ 0x93af, 0x225f7b },
	{ 0x93b0, 0x21775a },
	{ 0x93b1, 0x226431 },
	{ 0x93b2, 0x226433 },
	{ 0x93b3, 0x217757 },
	{ 0x93b4, 0x226436 },
	{ 0x93b5, 0x22637d },
	{ 0x93b7, 0x226422 },
	{ 0x93b8, 0x235946 },
	{ 0x93bb, 0x235945 },
	{ 0x93bc, 0x236661 },
	{ 0x93bd, 0x236662 },
	{ 0x93be, 0x236660 },
	{ 0x93c0, 0x22675f },
	{ 0x93c1, 0x235b50 },
	{ 0x93c2, 0x22674f },
	{ 0x93c3, 0x217938 },
	{ 0x93c4, 0x22675d },
	{ 0x93c5, 0x235b44 },
	{ 0x93c6, 0x235b45 },
	{ 0x93c7, 0x22674d },
	{ 0x93c8, 0x217939 },
	{ 0x93ca, 0x226758 },
	{ 0x93cb, 0x235b43 },
	{ 0x93cc, 0x226754 },
	{ 0x93cd, 0x21793e },
	{ 0x93ce, 0x22675e },
	{ 0x93cf, 0x22674e },
	{ 0x93d0, 0x226751 },
	{ 0x93d1, 0x217936 },
	{ 0x93d2, 0x226760 },
	{ 0x93d3, 0x235b48 },
	{ 0x93d4, 0x226759 },
	{ 0x93d5, 0x22675c },
	{ 0x93d6, 0x21793c },
	{ 0x93d7, 0x217941 },
	{ 0x93d8, 0x21793f },
	{ 0x93d9, 0x226755 },
	{ 0x93da, 0x226750 },
	{ 0x93db, 0x235b4d },
	{ 0x93dc, 0x21793a },
	{ 0x93dd, 0x21793b },
	{ 0x93de, 0x22674c },
	{ 0x93df, 0x217937 },
	{ 0x93e0, 0x235b4f },
	{ 0x93e1, 0x217935 },
	{ 0x93e2, 0x21793d },
	{ 0x93e3, 0x22675b },
	{ 0x93e4, 0x217940 },
	{ 0x93e5, 0x235b4a },
	{ 0x93e6, 0x226757 },
	{ 0x93e7, 0x226762 },
	{ 0x93e8, 0x217942 },
	{ 0x93e9, 0x235b41 },
	{ 0x93ea, 0x235b42 },
	{ 0x93eb, 0x235b4e },
	{ 0x93ec, 0x226753 },
	{ 0x93ed, 0x235b47 },
	{ 0x93ee, 0x22675a },
	{ 0x93ef, 0x236665 },
	{ 0x93f1, 0x236663 },
	{ 0x93f2, 0x236664 },
	{ 0x93f3, 0x235d41 },
	{ 0x93f4, 0x235e6a },
	{ 0x93f5, 0x226a41 },
	{ 0x93f6, 0x226a50 },
	{ 0x93f7, 0x226a43 },
	{ 0x93f8, 0x226a4a },
	{ 0x93f9, 0x226752 },
	{ 0x93fa, 0x226a48 },
	{ 0x93fb, 0x226a37 },
	{ 0x93fc, 0x226a4e },
	{ 0x93fd, 0x217a4e },
	{ 0x93fe, 0x226a3b },
	{ 0x93ff, 0x226a4d },
	{ 0x9400, 0x226a42 },
	{ 0x9402, 0x235d43 },
	{ 0x9403, 0x217a4d },
	{ 0x9404, 0x235d3c },
	{ 0x9405, 0x235d3f },
	{ 0x9406, 0x226a52 },
	{ 0x9407, 0x226a44 },
	{ 0x9408, 0x235d3e },
	{ 0x9409, 0x226a49 },
	{ 0x940a, 0x226a4c },
	{ 0x940b, 0x226a35 },
	{ 0x940c, 0x226a4f },
	{ 0x940d, 0x226a40 },
	{ 0x940e, 0x226a45 },
	{ 0x940f, 0x226a39 },
	{ 0x9410, 0x226a3d },
	{ 0x9411, 0x226a51 },
	{ 0x9412, 0x226a47 },
	{ 0x9413, 0x226a36 },
	{ 0x9414, 0x226a3a },
	{ 0x9415, 0x226a3c },
	{ 0x9416, 0x226a46 },
	{ 0x9417, 0x235d3d },
	{ 0x9418, 0x217a4c },
	{ 0x9419, 0x226a3f },
	{ 0x941a, 0x235d44 },
	{ 0x941b, 0x235d45 },
	{ 0x941c, 0x235d47 },
	{ 0x941e, 0x235d42 },
	{ 0x941f, 0x235d3a },
	{ 0x9420, 0x226a38 },
	{ 0x9422, 0x236666 },
	{ 0x9423, 0x236667 },
	{ 0x9424, 0x236668 },
	{ 0x9427, 0x235d46 },
	{ 0x9428, 0x226a3e },
	{ 0x9429, 0x226c50 },
	{ 0x942a, 0x226c54 },
	{ 0x942b, 0x217b3b },
	{ 0x942c, 0x226c56 },
	{ 0x942d, 0x235e6d },
	{ 0x942e, 0x217b35 },
	{ 0x9430, 0x226c52 },
	{ 0x9431, 0x226c58 },
	{ 0x9432, 0x217b3a },
	{ 0x9433, 0x217b36 },
	{ 0x9435, 0x217b37 },
	{ 0x9436, 0x226c4f },
	{ 0x9437, 0x226c55 },
	{ 0x9438, 0x217b39 },
	{ 0x9439, 0x226c53 },
	{ 0x943a, 0x217b38 },
	{ 0x943b, 0x226c4e },
	{ 0x943c, 0x226a4b },
	{ 0x943d, 0x226c51 },
	{ 0x943f, 0x226c4d },
	{ 0x9440, 0x226c57 },
	{ 0x9442, 0x235f69 },
	{ 0x9443, 0x235f6e },
	{ 0x9444, 0x217b7b },
	{ 0x9445, 0x226e3c },
	{ 0x9446, 0x226e3f },
	{ 0x9447, 0x226e3b },
	{ 0x9448, 0x226e3d },
	{ 0x9449, 0x226e3e },
	{ 0x944a, 0x226e38 },
	{ 0x944b, 0x226e39 },
	{ 0x944c, 0x226e36 },
	{ 0x944d, 0x235f6a },
	{ 0x944e, 0x235f6c },
	{ 0x944f, 0x226e3a },
	{ 0x9450, 0x226e37 },
	{ 0x9451, 0x217b7c },
	{ 0x9452, 0x217b7d },
	{ 0x9454, 0x235f6b },
	{ 0x9455, 0x226f59 },
	{ 0x9456, 0x236052 },
	{ 0x9457, 0x226f5b },
	{ 0x9458, 0x236431 },
	{ 0x945a, 0x236055 },
	{ 0x945b, 0x236054 },
	{ 0x945c, 0x236056 },
	{ 0x945d, 0x226f5a },
	{ 0x945e, 0x226f5c },
	{ 0x945f, 0x23604f },
	{ 0x9460, 0x217c4c },
	{ 0x9461, 0x236053 },
	{ 0x9462, 0x226f58 },
	{ 0x9463, 0x217c4b },
	{ 0x9464, 0x217c4d },
	{ 0x9465, 0x236057 },
	{ 0x9466, 0x23666a },
	{ 0x9467, 0x236669 },
	{ 0x9468, 0x227059 },
	{ 0x9469, 0x22705a },
	{ 0x946a, 0x217c6f },
	{ 0x946b, 0x227058 },
	{ 0x946c, 0x236122 },
	{ 0x946d, 0x227142 },
	{ 0x946e, 0x227141 },
	{ 0x946f, 0x227143 },
	{ 0x9470, 0x217d2c },
	{ 0x9471, 0x227144 },
	{ 0x9472, 0x217d2b },
	{ 0x9473, 0x227145 },
	{ 0x9474, 0x227161 },
	{ 0x9475, 0x227164 },
	{ 0x9476, 0x227163 },
	{ 0x9477, 0x217d35 },
	{ 0x9478, 0x227162 },
	{ 0x947a, 0x23616f },
	{ 0x947b, 0x236223 },
	{ 0x947c, 0x217d3f },
	{ 0x947d, 0x217d3d },
	{ 0x947e, 0x217d3e },
	{ 0x947f, 0x217d44 },
	{ 0x9480, 0x227230 },
	{ 0x9481, 0x227231 },
	{ 0x9482, 0x22722f },
	{ 0x9483, 0x227237 },
	{ 0x9484, 0x236236 },
	{ 0x9577, 0x214f5b },
	{ 0x9579, 0x236323 },
	{ 0x957a, 0x223a28 },
	{ 0x957b, 0x22413f },
	{ 0x957c, 0x22554e },
	{ 0x957d, 0x226763 },
	{ 0x9580, 0x214f5c },
	{ 0x9581, 0x232f40 },
	{ 0x9582, 0x21536d },
	{ 0x9583, 0x215860 },
	{ 0x9585, 0x233432 },
	{ 0x9586, 0x223a29 },
	{ 0x9587, 0x23395c },
	{ 0x9588, 0x223a2a },
	{ 0x9589, 0x215d70 },
	{ 0x958b, 0x216264 },
	{ 0x958c, 0x224141 },
	{ 0x958d, 0x224140 },
	{ 0x958e, 0x216268 },
	{ 0x958f, 0x216263 },
	{ 0x9590, 0x224142 },
	{ 0x9591, 0x216265 },
	{ 0x9592, 0x216267 },
	{ 0x9593, 0x216266 },
	{ 0x9594, 0x216262 },
	{ 0x9595, 0x233f6c },
	{ 0x9597, 0x23666b },
	{ 0x9598, 0x216750 },
	{ 0x9599, 0x23453c },
	{ 0x959a, 0x23453a },
	{ 0x959b, 0x224856 },
	{ 0x959c, 0x224854 },
	{ 0x959e, 0x224855 },
	{ 0x959f, 0x224853 },
	{ 0x95a1, 0x216b5b },
	{ 0x95a2, 0x234a3d },
	{ 0x95a3, 0x216b5e },
	{ 0x95a4, 0x216b60 },
	{ 0x95a5, 0x216b5f },
	{ 0x95a7, 0x234a3e },
	{ 0x95a8, 0x216b5c },
	{ 0x95a9, 0x216b5d },
	{ 0x95ab, 0x225550 },
	{ 0x95ac, 0x22554f },
	{ 0x95ad, 0x216f64 },
	{ 0x95ae, 0x225551 },
	{ 0x95af, 0x234f53 },
	{ 0x95b0, 0x225552 },
	{ 0x95b1, 0x216f65 },
	{ 0x95b2, 0x234f55 },
	{ 0x95b3, 0x234f56 },
	{ 0x95b5, 0x225b59 },
	{ 0x95b6, 0x225b57 },
	{ 0x95b7, 0x226040 },
	{ 0x95b8, 0x235342 },
	{ 0x95b9, 0x225b55 },
	{ 0x95ba, 0x225b56 },
	{ 0x95bb, 0x21726f },
	{ 0x95bc, 0x225b52 },
	{ 0x95bd, 0x225b5a },
	{ 0x95be, 0x225b54 },
	{ 0x95bf, 0x225b58 },
	{ 0x95c0, 0x22603c },
	{ 0x95c1, 0x235344 },
	{ 0x95c2, 0x235340 },
	{ 0x95c3, 0x22603e },
	{ 0x95c4, 0x23566d },
	{ 0x95c5, 0x22603f },
	{ 0x95c6, 0x21757e },
	{ 0x95c7, 0x22603b },
	{ 0x95c8, 0x21757d },
	{ 0x95c9, 0x22603d },
	{ 0x95ca, 0x21757a },
	{ 0x95cb, 0x21757b },
	{ 0x95cc, 0x21757c },
	{ 0x95cd, 0x225b53 },
	{ 0x95ce, 0x23666c },
	{ 0x95d0, 0x217760 },
	{ 0x95d1, 0x22643a },
	{ 0x95d2, 0x226438 },
	{ 0x95d3, 0x226439 },
	{ 0x95d4, 0x21775e },
	{ 0x95d5, 0x217761 },
	{ 0x95d6, 0x21775f },
	{ 0x95d7, 0x23594b },
	{ 0x95d8, 0x23594a },
	{ 0x95da, 0x226764 },
	{ 0x95db, 0x226765 },
	{ 0x95dc, 0x217943 },
	{ 0x95dd, 0x235b53 },
	{ 0x95de, 0x226a53 },
	{ 0x95df, 0x226a55 },
	{ 0x95e0, 0x226a54 },
	{ 0x95e1, 0x217a4f },
	{ 0x95e2, 0x217b3c },
	{ 0x95e3, 0x226c5b },
	{ 0x95e4, 0x226c5a },
	{ 0x95e5, 0x226c59 },
	{ 0x95e7, 0x23666d },
	{ 0x961c, 0x214f5d },
	{ 0x961d, 0x232143 },
	{ 0x961e, 0x222169 },
	{ 0x9620, 0x222278 },
	{ 0x9621, 0x21486a },
	{ 0x9622, 0x222276 },
	{ 0x9623, 0x222279 },
	{ 0x9624, 0x222277 },
	{ 0x9626, 0x23273b },
	{ 0x9627, 0x23273a },
	{ 0x9628, 0x22252e },
	{ 0x9629, 0x23273f },
	{ 0x962a, 0x214b62 },
	{ 0x962b, 0x23273c },
	{ 0x962c, 0x214b63 },
	{ 0x962d, 0x222530 },
	{ 0x962e, 0x214b60 },
	{ 0x962f, 0x22252f },
	{ 0x9630, 0x22252d },
	{ 0x9631, 0x214b61 },
	{ 0x9632, 0x214b5f },
	{ 0x9633, 0x23273d },
	{ 0x9634, 0x23273e },
	{ 0x9637, 0x232a79 },
	{ 0x9639, 0x222878 },
	{ 0x963a, 0x22287b },
	{ 0x963b, 0x214f60 },
	{ 0x963c, 0x22287a },
	{ 0x963d, 0x222879 },
	{ 0x963e, 0x232a7c },
	{ 0x963f, 0x214f5f },
	{ 0x9640, 0x214f5e },
	{ 0x9641, 0x232a7b },
	{ 0x9642, 0x214f62 },
	{ 0x9643, 0x22287c },
	{ 0x9644, 0x214f61 },
	{ 0x964a, 0x222d67 },
	{ 0x964b, 0x21536f },
	{ 0x964c, 0x215370 },
	{ 0x964d, 0x215371 },
	{ 0x964e, 0x222d68 },
	{ 0x964f, 0x222d64 },
	{ 0x9650, 0x21536e },
	{ 0x9651, 0x222d65 },
	{ 0x9653, 0x222d66 },
	{ 0x9654, 0x222d63 },
	{ 0x9656, 0x233436 },
	{ 0x9658, 0x215867 },
	{ 0x9659, 0x233434 },
	{ 0x965a, 0x23395e },
	{ 0x965b, 0x215864 },
	{ 0x965c, 0x223348 },
	{ 0x965d, 0x215865 },
	{ 0x965e, 0x215868 },
	{ 0x965f, 0x223349 },
	{ 0x9660, 0x233433 },
	{ 0x9661, 0x215863 },
	{ 0x9662, 0x215861 },
	{ 0x9663, 0x215862 },
	{ 0x9664, 0x215866 },
	{ 0x966a, 0x215d71 },
	{ 0x966b, 0x223a2d },
	{ 0x966c, 0x215d79 },
	{ 0x966d, 0x223a2c },
	{ 0x966e, 0x233961 },
	{ 0x966f, 0x223a2f },
	{ 0x9670, 0x215d75 },
	{ 0x9671, 0x223a2e },
	{ 0x9672, 0x216270 },
	{ 0x9673, 0x215d73 },
	{ 0x9674, 0x215d76 },
	{ 0x9675, 0x215d72 },
	{ 0x9676, 0x215d77 },
	{ 0x9677, 0x215d78 },
	{ 0x9678, 0x215d74 },
	{ 0x9679, 0x233965 },
	{ 0x967b, 0x233f71 },
	{ 0x967c, 0x223a2b },
	{ 0x967d, 0x21626c },
	{ 0x967e, 0x224144 },
	{ 0x967f, 0x233f72 },
	{ 0x9680, 0x224148 },
	{ 0x9681, 0x233f73 },
	{ 0x9682, 0x233f75 },
	{ 0x9683, 0x224147 },
	{ 0x9684, 0x216271 },
	{ 0x9685, 0x21626d },
	{ 0x9686, 0x21626e },
	{ 0x9687, 0x224143 },
	{ 0x9688, 0x224145 },
	{ 0x9689, 0x224146 },
	{ 0x968a, 0x216269 },
	{ 0x968b, 0x21626b },
	{ 0x968c, 0x233f70 },
	{ 0x968d, 0x21626f },
	{ 0x968e, 0x21626a },
	{ 0x968f, 0x234540 },
	{ 0x9691, 0x224859 },
	{ 0x9692, 0x224857 },
	{ 0x9693, 0x224858 },
	{ 0x9694, 0x216752 },
	{ 0x9695, 0x216753 },
	{ 0x9696, 0x234542 },
	{ 0x9697, 0x22485a },
	{ 0x9698, 0x216751 },
	{ 0x9699, 0x216b61 },
	{ 0x969b, 0x216b63 },
	{ 0x969c, 0x216b62 },
	{ 0x969d, 0x234a45 },
	{ 0x969e, 0x224f23 },
	{ 0x969f, 0x234a46 },
	{ 0x96a0, 0x234a44 },
	{ 0x96a1, 0x224f24 },
	{ 0x96a2, 0x225554 },
	{ 0x96a3, 0x234f5a },
	{ 0x96a4, 0x225553 },
	{ 0x96a5, 0x234f5b },
	{ 0x96a7, 0x217270 },
	{ 0x96a8, 0x217271 },
	{ 0x96a9, 0x225b5b },
	{ 0x96aa, 0x217272 },
	{ 0x96ab, 0x235348 },
	{ 0x96ac, 0x226043 },
	{ 0x96ad, 0x235670 },
	{ 0x96ae, 0x226041 },
	{ 0x96af, 0x23566f },
	{ 0x96b0, 0x226042 },
	{ 0x96b1, 0x217621 },
	{ 0x96b2, 0x235671 },
	{ 0x96b3, 0x22643b },
	{ 0x96b4, 0x217944 },
	{ 0x96b5, 0x235d49 },
	{ 0x96b6, 0x232a7d },
	{ 0x96b7, 0x235349 },
	{ 0x96b8, 0x217622 },
	{ 0x96b9, 0x214f63 },
	{ 0x96ba, 0x236325 },
	{ 0x96bb, 0x215869 },
	{ 0x96bc, 0x22334a },
	{ 0x96bd, 0x233439 },
	{ 0x96bf, 0x223a30 },
	{ 0x96c0, 0x215d7a },
	{ 0x96c1, 0x216272 },
	{ 0x96c2, 0x224149 },
	{ 0x96c3, 0x22414b },
	{ 0x96c4, 0x216274 },
	{ 0x96c5, 0x216273 },
	{ 0x96c6, 0x216275 },
	{ 0x96c7, 0x216276 },
	{ 0x96c8, 0x22414a },
	{ 0x96c9, 0x216756 },
	{ 0x96ca, 0x216757 },
	{ 0x96cb, 0x216755 },
	{ 0x96cc, 0x216b64 },
	{ 0x96cd, 0x216754 },
	{ 0x96ce, 0x22485b },
	{ 0x96d0, 0x234a47 },
	{ 0x96d1, 0x234a49 },
	{ 0x96d2, 0x216b65 },
	{ 0x96d3, 0x225555 },
	{ 0x96d4, 0x225b5c },
	{ 0x96d5, 0x217273 },
	{ 0x96d6, 0x217623 },
	{ 0x96d7, 0x22643c },
	{ 0x96d8, 0x226440 },
	{ 0x96d9, 0x217764 },
	{ 0x96da, 0x22643d },
	{ 0x96db, 0x217765 },
	{ 0x96dc, 0x217763 },
	{ 0x96dd, 0x226441 },
	{ 0x96de, 0x217766 },
	{ 0x96df, 0x22643f },
	{ 0x96e1, 0x226766 },
	{ 0x96e2, 0x217762 },
	{ 0x96e3, 0x217945 },
	{ 0x96e4, 0x235e70 },
	{ 0x96e5, 0x22705b },
	{ 0x96e6, 0x236125 },
	{ 0x96e7, 0x23622f },
	{ 0x96e8, 0x214f64 },
	{ 0x96e9, 0x215d7c },
	{ 0x96ea, 0x215d7b },
	{ 0x96ec, 0x233f7e },
	{ 0x96ed, 0x233f7c },
	{ 0x96ee, 0x233f7b },
	{ 0x96ef, 0x216277 },
	{ 0x96f0, 0x22414d },
	{ 0x96f1, 0x22414c },
	{ 0x96f2, 0x216278 },
	{ 0x96f4, 0x234546 },
	{ 0x96f5, 0x22485f },
	{ 0x96f6, 0x21675b },
	{ 0x96f7, 0x216758 },
	{ 0x96f8, 0x22485e },
	{ 0x96f9, 0x21675a },
	{ 0x96fa, 0x22485c },
	{ 0x96fb, 0x216759 },
	{ 0x96fc, 0x234547 },
	{ 0x96fd, 0x22485d },
	{ 0x96ff, 0x224f25 },
	{ 0x9700, 0x216b66 },
	{ 0x9702, 0x225558 },
	{ 0x9704, 0x216f66 },
	{ 0x9705, 0x225556 },
	{ 0x9706, 0x216f67 },
	{ 0x9707, 0x216f68 },
	{ 0x9708, 0x225557 },
	{ 0x9709, 0x216f69 },
	{ 0x970a, 0x234f60 },
	{ 0x970b, 0x225b5d },
	{ 0x970c, 0x235350 },
	{ 0x970d, 0x217277 },
	{ 0x970e, 0x217274 },
	{ 0x970f, 0x217279 },
	{ 0x9710, 0x225b5f },
	{ 0x9711, 0x217275 },
	{ 0x9712, 0x225b5e },
	{ 0x9713, 0x217278 },
	{ 0x9714, 0x23534d },
	{ 0x9715, 0x23534c },
	{ 0x9716, 0x217276 },
	{ 0x9717, 0x235351 },
	{ 0x9718, 0x226046 },
	{ 0x9719, 0x226048 },
	{ 0x971a, 0x235674 },
	{ 0x971b, 0x235675 },
	{ 0x971c, 0x217624 },
	{ 0x971d, 0x226047 },
	{ 0x971e, 0x217625 },
	{ 0x971f, 0x226045 },
	{ 0x9720, 0x226044 },
	{ 0x9722, 0x226443 },
	{ 0x9723, 0x226442 },
	{ 0x9724, 0x217767 },
	{ 0x9725, 0x226444 },
	{ 0x9726, 0x22676b },
	{ 0x9727, 0x217947 },
	{ 0x9728, 0x22676a },
	{ 0x9729, 0x226767 },
	{ 0x972a, 0x217946 },
	{ 0x972b, 0x226768 },
	{ 0x972c, 0x226769 },
	{ 0x972e, 0x226a56 },
	{ 0x972f, 0x226a57 },
	{ 0x9730, 0x217a50 },
	{ 0x9731, 0x235d4f },
	{ 0x9732, 0x217b3f },
	{ 0x9733, 0x235d4c },
	{ 0x9734, 0x235d4e },
	{ 0x9735, 0x226c5c },
	{ 0x9736, 0x235e72 },
	{ 0x9737, 0x235e71 },
	{ 0x9738, 0x217b3d },
	{ 0x9739, 0x217b3e },
	{ 0x973a, 0x226c5d },
	{ 0x973b, 0x23666e },
	{ 0x973c, 0x235f71 },
	{ 0x973d, 0x217b7e },
	{ 0x973e, 0x217c21 },
	{ 0x973f, 0x226e40 },
	{ 0x9740, 0x235f72 },
	{ 0x9741, 0x236059 },
	{ 0x9742, 0x217c70 },
	{ 0x9743, 0x22705d },
	{ 0x9744, 0x217c72 },
	{ 0x9745, 0x236126 },
	{ 0x9746, 0x22705c },
	{ 0x9747, 0x22705e },
	{ 0x9748, 0x217c71 },
	{ 0x9749, 0x227146 },
	{ 0x974b, 0x22717b },
	{ 0x974d, 0x23666f },
	{ 0x9750, 0x236245 },
	{ 0x9751, 0x232a7e },
	{ 0x9752, 0x214f65 },
	{ 0x9755, 0x234549 },
	{ 0x9756, 0x21675c },
	{ 0x9758, 0x224f26 },
	{ 0x9759, 0x234a4c },
	{ 0x975a, 0x225559 },
	{ 0x975b, 0x21727a },
	{ 0x975c, 0x21727b },
	{ 0x975d, 0x23594f },
	{ 0x975e, 0x214f66 },
	{ 0x975f, 0x234021 },
	{ 0x9760, 0x216f6a },
	{ 0x9761, 0x217948 },
	{ 0x9762, 0x215372 },
	{ 0x9763, 0x232b21 },
	{ 0x9764, 0x234a4e },
	{ 0x9766, 0x21727c },
	{ 0x9767, 0x235e73 },
	{ 0x9768, 0x217c4e },
	{ 0x9769, 0x215373 },
	{ 0x976a, 0x223a31 },
	{ 0x976c, 0x22414e },
	{ 0x976d, 0x234024 },
	{ 0x976e, 0x224150 },
	{ 0x976f, 0x234022 },
	{ 0x9770, 0x22414f },
	{ 0x9772, 0x224863 },
	{ 0x9773, 0x224860 },
	{ 0x9774, 0x21675d },
	{ 0x9776, 0x21675e },
	{ 0x9777, 0x224861 },
	{ 0x9778, 0x224862 },
	{ 0x9779, 0x23454b },
	{ 0x977a, 0x224f28 },
	{ 0x977b, 0x224f2d },
	{ 0x977c, 0x216b67 },
	{ 0x977d, 0x224f27 },
	{ 0x977e, 0x224f29 },
	{ 0x977f, 0x224f30 },
	{ 0x9780, 0x224f2b },
	{ 0x9781, 0x224f2f },
	{ 0x9782, 0x224f2c },
	{ 0x9783, 0x224f2a },
	{ 0x9784, 0x224f2e },
	{ 0x9785, 0x216b68 },
	{ 0x9787, 0x234f62 },
	{ 0x9788, 0x22555c },
	{ 0x9789, 0x234f63 },
	{ 0x978a, 0x22555a },
	{ 0x978b, 0x216f6c },
	{ 0x978c, 0x234f64 },
	{ 0x978d, 0x216f6b },
	{ 0x978e, 0x22555b },
	{ 0x978f, 0x216f6d },
	{ 0x9793, 0x235353 },
	{ 0x9794, 0x225b62 },
	{ 0x9797, 0x225b61 },
	{ 0x9798, 0x21727d },
	{ 0x9799, 0x225b60 },
	{ 0x979a, 0x226049 },
	{ 0x979b, 0x23567a },
	{ 0x979c, 0x22604b },
	{ 0x979d, 0x22604d },
	{ 0x979e, 0x22604c },
	{ 0x979f, 0x23567b },
	{ 0x97a0, 0x217626 },
	{ 0x97a1, 0x22604a },
	{ 0x97a2, 0x22644b },
	{ 0x97a3, 0x217768 },
	{ 0x97a4, 0x226449 },
	{ 0x97a5, 0x22644c },
	{ 0x97a6, 0x217769 },
	{ 0x97a8, 0x226447 },
	{ 0x97a9, 0x235950 },
	{ 0x97aa, 0x22644a },
	{ 0x97ab, 0x226448 },
	{ 0x97ac, 0x226445 },
	{ 0x97ad, 0x21776a },
	{ 0x97ae, 0x226446 },
	{ 0x97b1, 0x235b5f },
	{ 0x97b2, 0x235b5d },
	{ 0x97b3, 0x22676c },
	{ 0x97b4, 0x235b5e },
	{ 0x97b5, 0x235b60 },
	{ 0x97b6, 0x22676e },
	{ 0x97b7, 0x22676d },
	{ 0x97b8, 0x235d50 },
	{ 0x97b9, 0x226a58 },
	{ 0x97ba, 0x235d51 },
	{ 0x97bb, 0x226a59 },
	{ 0x97bd, 0x235e75 },
	{ 0x97be, 0x235e74 },
	{ 0x97bf, 0x226c5e },
	{ 0x97c0, 0x235f73 },
	{ 0x97c1, 0x217c23 },
	{ 0x97c3, 0x217c22 },
	{ 0x97c4, 0x226f5d },
	{ 0x97c5, 0x226f5e },
	{ 0x97c6, 0x217c73 },
	{ 0x97c7, 0x22705f },
	{ 0x97c8, 0x236128 },
	{ 0x97c9, 0x217d36 },
	{ 0x97ca, 0x23623b },
	{ 0x97cb, 0x215374 },
	{ 0x97cc, 0x216279 },
	{ 0x97cd, 0x224f32 },
	{ 0x97ce, 0x224f31 },
	{ 0x97cf, 0x22555e },
	{ 0x97d0, 0x22555d },
	{ 0x97d2, 0x235355 },
	{ 0x97d3, 0x217627 },
	{ 0x97d4, 0x22604f },
	{ 0x97d5, 0x22604e },
	{ 0x97d6, 0x22644f },
	{ 0x97d7, 0x22644d },
	{ 0x97d8, 0x226450 },
	{ 0x97d9, 0x22644e },
	{ 0x97da, 0x235951 },
	{ 0x97dc, 0x217949 },
	{ 0x97dd, 0x22676f },
	{ 0x97de, 0x226770 },
	{ 0x97df, 0x226771 },
	{ 0x97e1, 0x226c5f },
	{ 0x97e2, 0x235e76 },
	{ 0x97e3, 0x226e41 },
	{ 0x97e4, 0x236129 },
	{ 0x97e5, 0x227060 },
	{ 0x97ed, 0x215375 },
	{ 0x97ee, 0x23454f },
	{ 0x97ef, 0x234f65 },
	{ 0x97f0, 0x225b63 },
	{ 0x97f1, 0x226050 },
	{ 0x97f2, 0x235b61 },
	{ 0x97f3, 0x215376 },
	{ 0x97f5, 0x234550 },
	{ 0x97f6, 0x216b69 },
	{ 0x97f8, 0x225b64 },
	{ 0x97f9, 0x21776b },
	{ 0x97fa, 0x226451 },
	{ 0x97fb, 0x21794a },
	{ 0x97fc, 0x235d53 },
	{ 0x97fd, 0x226a5a },
	{ 0x97fe, 0x226a5b },
	{ 0x97ff, 0x217b40 },
	{ 0x9800, 0x226f5f },
	{ 0x9801, 0x215377 },
	{ 0x9802, 0x215e21 },
	{ 0x9803, 0x215e22 },
	{ 0x9804, 0x223a32 },
	{ 0x9805, 0x21627a },
	{ 0x9806, 0x21627b },
	{ 0x9807, 0x224151 },
	{ 0x9808, 0x21627c },
	{ 0x980a, 0x216762 },
	{ 0x980b, 0x234552 },
	{ 0x980c, 0x216764 },
	{ 0x980d, 0x224865 },
	{ 0x980e, 0x224866 },
	{ 0x980f, 0x224864 },
	{ 0x9810, 0x21675f },
	{ 0x9811, 0x216760 },
	{ 0x9812, 0x216763 },
	{ 0x9813, 0x216761 },
	{ 0x9814, 0x234a54 },
	{ 0x9815, 0x234a55 },
	{ 0x9816, 0x224f33 },
	{ 0x9817, 0x216b6a },
	{ 0x9818, 0x216b6b },
	{ 0x9819, 0x234a52 },
	{ 0x981a, 0x234a56 },
	{ 0x981b, 0x225565 },
	{ 0x981c, 0x216f70 },
	{ 0x981d, 0x225560 },
	{ 0x981e, 0x22555f },
	{ 0x981f, 0x234f69 },
	{ 0x9820, 0x225564 },
	{ 0x9821, 0x216f6e },
	{ 0x9822, 0x234f67 },
	{ 0x9823, 0x23636e },
	{ 0x9824, 0x217326 },
	{ 0x9826, 0x225561 },
	{ 0x9827, 0x225566 },
	{ 0x9828, 0x225563 },
	{ 0x9829, 0x225562 },
	{ 0x982a, 0x234f66 },
	{ 0x982b, 0x216f6f },
	{ 0x982d, 0x217324 },
	{ 0x982e, 0x23535c },
	{ 0x982f, 0x225b66 },
	{ 0x9830, 0x21727e },
	{ 0x9831, 0x235359 },
	{ 0x9832, 0x225b67 },
	{ 0x9833, 0x23535a },
	{ 0x9834, 0x235228 },
	{ 0x9835, 0x225b65 },
	{ 0x9836, 0x235358 },
	{ 0x9837, 0x217323 },
	{ 0x9838, 0x217321 },
	{ 0x9839, 0x217325 },
	{ 0x983a, 0x23535d },
	{ 0x983b, 0x217322 },
	{ 0x983c, 0x23535b },
	{ 0x983d, 0x23535f },
	{ 0x983f, 0x23595b },
	{ 0x9840, 0x235726 },
	{ 0x9841, 0x226051 },
	{ 0x9842, 0x23637b },
	{ 0x9843, 0x226056 },
	{ 0x9844, 0x226052 },
	{ 0x9845, 0x226055 },
	{ 0x9846, 0x217628 },
	{ 0x9847, 0x235728 },
	{ 0x9848, 0x225e41 },
	{ 0x9849, 0x226054 },
	{ 0x984a, 0x226053 },
	{ 0x984b, 0x235959 },
	{ 0x984c, 0x21776e },
	{ 0x984d, 0x21776c },
	{ 0x984e, 0x21776f },
	{ 0x984f, 0x21776d },
	{ 0x9850, 0x226452 },
	{ 0x9851, 0x226453 },
	{ 0x9852, 0x226454 },
	{ 0x9853, 0x217770 },
	{ 0x9854, 0x235956 },
	{ 0x9855, 0x235958 },
	{ 0x9856, 0x235b65 },
	{ 0x9857, 0x226775 },
	{ 0x9858, 0x21794c },
	{ 0x9859, 0x226773 },
	{ 0x985b, 0x21794d },
	{ 0x985c, 0x226772 },
	{ 0x985d, 0x226774 },
	{ 0x985e, 0x21794b },
	{ 0x985f, 0x226a5f },
	{ 0x9860, 0x226a5c },
	{ 0x9861, 0x23642a },
	{ 0x9862, 0x226a5d },
	{ 0x9863, 0x226a5e },
	{ 0x9864, 0x226c60 },
	{ 0x9865, 0x217b42 },
	{ 0x9866, 0x235e78 },
	{ 0x9867, 0x217b41 },
	{ 0x9868, 0x235e77 },
	{ 0x9869, 0x226e43 },
	{ 0x986a, 0x226e42 },
	{ 0x986b, 0x217c24 },
	{ 0x986c, 0x23605d },
	{ 0x986d, 0x23605e },
	{ 0x986e, 0x23605c },
	{ 0x986f, 0x217c4f },
	{ 0x9870, 0x217c74 },
	{ 0x9871, 0x217d2d },
	{ 0x9872, 0x227147 },
	{ 0x9873, 0x22717c },
	{ 0x9874, 0x22717d },
	{ 0x98a8, 0x215378 },
	{ 0x98a9, 0x224152 },
	{ 0x98ac, 0x224867 },
	{ 0x98ad, 0x224f34 },
	{ 0x98ae, 0x224f35 },
	{ 0x98af, 0x216b6c },
	{ 0x98b1, 0x216b6d },
	{ 0x98b2, 0x225567 },
	{ 0x98b3, 0x216f71 },
	{ 0x98b5, 0x235361 },
	{ 0x98b6, 0x217629 },
	{ 0x98b7, 0x23572a },
	{ 0x98b8, 0x226455 },
	{ 0x98b9, 0x23595c },
	{ 0x98ba, 0x217771 },
	{ 0x98bb, 0x226778 },
	{ 0x98bc, 0x21794e },
	{ 0x98bd, 0x226777 },
	{ 0x98be, 0x226779 },
	{ 0x98bf, 0x226776 },
	{ 0x98c0, 0x226c63 },
	{ 0x98c1, 0x226a60 },
	{ 0x98c2, 0x226a61 },
	{ 0x98c3, 0x235d56 },
	{ 0x98c4, 0x217a51 },
	{ 0x98c6, 0x226c62 },
	{ 0x98c7, 0x235e7b },
	{ 0x98c8, 0x235e79 },
	{ 0x98c9, 0x226c61 },
	{ 0x98ca, 0x235e7a },
	{ 0x98cb, 0x226e44 },
	{ 0x98cc, 0x22717e },
	{ 0x98cd, 0x236225 },
	{ 0x98db, 0x215379 },
	{ 0x98dc, 0x235e7c },
	{ 0x98dd, 0x236226 },
	{ 0x98df, 0x21537a },
	{ 0x98e1, 0x233967 },
	{ 0x98e2, 0x21586a },
	{ 0x98e3, 0x22334b },
	{ 0x98e4, 0x236670 },
	{ 0x98e5, 0x223a33 },
	{ 0x98e6, 0x233968 },
	{ 0x98e7, 0x21627d },
	{ 0x98e9, 0x216322 },
	{ 0x98ea, 0x21627e },
	{ 0x98eb, 0x224153 },
	{ 0x98ec, 0x23455b },
	{ 0x98ed, 0x216324 },
	{ 0x98ef, 0x216321 },
	{ 0x98f0, 0x23402b },
	{ 0x98f1, 0x23455c },
	{ 0x98f2, 0x216323 },
	{ 0x98f3, 0x234554 },
	{ 0x98f4, 0x216766 },
	{ 0x98f5, 0x234559 },
	{ 0x98f6, 0x224868 },
	{ 0x98f7, 0x234557 },
	{ 0x98f8, 0x234a5d },
	{ 0x98f9, 0x224869 },
	{ 0x98fa, 0x225569 },
	{ 0x98fc, 0x216765 },
	{ 0x98fd, 0x216767 },
	{ 0x98fe, 0x216768 },
	{ 0x98ff, 0x234558 },
	{ 0x9900, 0x224f37 },
	{ 0x9901, 0x234a5e },
	{ 0x9902, 0x224f36 },
	{ 0x9903, 0x216b6e },
	{ 0x9905, 0x216b6f },
	{ 0x9906, 0x234a5b },
	{ 0x9907, 0x224f38 },
	{ 0x9908, 0x225568 },
	{ 0x9909, 0x216b71 },
	{ 0x990a, 0x216f72 },
	{ 0x990c, 0x216b70 },
	{ 0x990e, 0x23667a },
	{ 0x9910, 0x217327 },
	{ 0x9911, 0x22556a },
	{ 0x9912, 0x216f74 },
	{ 0x9913, 0x216f73 },
	{ 0x9914, 0x22556b },
	{ 0x9915, 0x22556e },
	{ 0x9916, 0x22556c },
	{ 0x9917, 0x22556d },
	{ 0x9918, 0x216f75 },
	{ 0x9919, 0x234f6b },
	{ 0x991a, 0x21732c },
	{ 0x991b, 0x21732a },
	{ 0x991c, 0x235365 },
	{ 0x991d, 0x235366 },
	{ 0x991e, 0x217329 },
	{ 0x991f, 0x225b69 },
	{ 0x9920, 0x235364 },
	{ 0x9921, 0x21732b },
	{ 0x9922, 0x235362 },
	{ 0x9923, 0x235363 },
	{ 0x9924, 0x225b68 },
	{ 0x9925, 0x226057 },
	{ 0x9927, 0x225b6a },
	{ 0x9928, 0x217328 },
	{ 0x9929, 0x225b6b },
	{ 0x992a, 0x22605a },
	{ 0x992b, 0x226058 },
	{ 0x992c, 0x226059 },
	{ 0x992d, 0x22605e },
	{ 0x992e, 0x217775 },
	{ 0x992f, 0x22605d },
	{ 0x9930, 0x226060 },
	{ 0x9931, 0x22605f },
	{ 0x9932, 0x22605c },
	{ 0x9933, 0x22605b },
	{ 0x9935, 0x21762a },
	{ 0x9936, 0x235962 },
	{ 0x9938, 0x235961 },
	{ 0x9939, 0x235966 },
	{ 0x993a, 0x226458 },
	{ 0x993b, 0x235965 },
	{ 0x993c, 0x226457 },
	{ 0x993d, 0x217774 },
	{ 0x993e, 0x217772 },
	{ 0x993f, 0x217773 },
	{ 0x9940, 0x235963 },
	{ 0x9941, 0x226456 },
	{ 0x9942, 0x236671 },
	{ 0x9943, 0x22677c },
	{ 0x9944, 0x235b69 },
	{ 0x9945, 0x21794f },
	{ 0x9947, 0x22677b },
	{ 0x9948, 0x22677a },
	{ 0x9949, 0x217950 },
	{ 0x994b, 0x226a66 },
	{ 0x994c, 0x226a65 },
	{ 0x994d, 0x235d58 },
	{ 0x994e, 0x226a63 },
	{ 0x994f, 0x235e7e },
	{ 0x9950, 0x226a62 },
	{ 0x9951, 0x217a53 },
	{ 0x9952, 0x217a52 },
	{ 0x9953, 0x226a67 },
	{ 0x9954, 0x226e45 },
	{ 0x9955, 0x217c25 },
	{ 0x9956, 0x226c65 },
	{ 0x9957, 0x217b43 },
	{ 0x9958, 0x226c64 },
	{ 0x9959, 0x226a64 },
	{ 0x995a, 0x235f78 },
	{ 0x995b, 0x226e46 },
	{ 0x995c, 0x217c50 },
	{ 0x995d, 0x23612a },
	{ 0x995e, 0x217d2e },
	{ 0x995f, 0x227148 },
	{ 0x9961, 0x227221 },
	{ 0x9996, 0x21537b },
	{ 0x9997, 0x223a34 },
	{ 0x9998, 0x226061 },
	{ 0x9999, 0x21537c },
	{ 0x999a, 0x23455f },
	{ 0x999c, 0x224f3a },
	{ 0x999d, 0x224f39 },
	{ 0x999e, 0x225b6c },
	{ 0x99a0, 0x235368 },
	{ 0x99a1, 0x226063 },
	{ 0x99a2, 0x235730 },
	{ 0x99a3, 0x226062 },
	{ 0x99a4, 0x235967 },
	{ 0x99a5, 0x217776 },
	{ 0x99a6, 0x22677d },
	{ 0x99a7, 0x22677e },
	{ 0x99a8, 0x217a54 },
	{ 0x99a9, 0x235f21 },
	{ 0x99aa, 0x236060 },
	{ 0x99ab, 0x227222 },
	{ 0x99ac, 0x21586b },
	{ 0x99ad, 0x216326 },
	{ 0x99ae, 0x216325 },
	{ 0x99af, 0x22486a },
	{ 0x99b0, 0x22486c },
	{ 0x99b1, 0x21676a },
	{ 0x99b2, 0x22486b },
	{ 0x99b3, 0x216769 },
	{ 0x99b4, 0x21676b },
	{ 0x99b5, 0x22486d },
	{ 0x99b6, 0x234a63 },
	{ 0x99b7, 0x234a62 },
	{ 0x99b8, 0x234a66 },
	{ 0x99b9, 0x224f3c },
	{ 0x99ba, 0x224f3e },
	{ 0x99bb, 0x224f3d },
	{ 0x99bc, 0x234a61 },
	{ 0x99bd, 0x224f40 },
	{ 0x99be, 0x234a60 },
	{ 0x99bf, 0x234a6c },
	{ 0x99c0, 0x234a64 },
	{ 0x99c1, 0x216b72 },
	{ 0x99c2, 0x224f3f },
	{ 0x99c3, 0x224f3b },
	{ 0x99c4, 0x234a6a },
	{ 0x99c7, 0x224f41 },
	{ 0x99c8, 0x234f73 },
	{ 0x99c9, 0x225575 },
	{ 0x99ca, 0x234f6d },
	{ 0x99cb, 0x225578 },
	{ 0x99cc, 0x22557a },
	{ 0x99cd, 0x225570 },
	{ 0x99ce, 0x225574 },
	{ 0x99cf, 0x225571 },
	{ 0x99d0, 0x216f77 },
	{ 0x99d1, 0x216f7a },
	{ 0x99d2, 0x216f7c },
	{ 0x99d3, 0x225572 },
	{ 0x99d4, 0x225573 },
	{ 0x99d5, 0x216f7b },
	{ 0x99d6, 0x225576 },
	{ 0x99d7, 0x225579 },
	{ 0x99d8, 0x225577 },
	{ 0x99d9, 0x216f7d },
	{ 0x99da, 0x234f6e },
	{ 0x99db, 0x216f79 },
	{ 0x99dc, 0x22556f },
	{ 0x99dd, 0x216f76 },
	{ 0x99de, 0x234f72 },
	{ 0x99df, 0x216f78 },
	{ 0x99e0, 0x234f74 },
	{ 0x99e1, 0x235370 },
	{ 0x99e2, 0x21732e },
	{ 0x99e3, 0x225b72 },
	{ 0x99e4, 0x225b70 },
	{ 0x99e5, 0x225b6f },
	{ 0x99e6, 0x235371 },
	{ 0x99e7, 0x225b75 },
	{ 0x99e8, 0x23536b },
	{ 0x99e9, 0x225b74 },
	{ 0x99ea, 0x225b73 },
	{ 0x99eb, 0x23536c },
	{ 0x99ec, 0x225b6e },
	{ 0x99ed, 0x21732d },
	{ 0x99ee, 0x225b6d },
	{ 0x99ef, 0x23536a },
	{ 0x99f0, 0x225b71 },
	{ 0x99f1, 0x21732f },
	{ 0x99f3, 0x235734 },
	{ 0x99f4, 0x226066 },
	{ 0x99f5, 0x235737 },
	{ 0x99f6, 0x22606a },
	{ 0x99f7, 0x226067 },
	{ 0x99f8, 0x226069 },
	{ 0x99f9, 0x226068 },
	{ 0x99fa, 0x226065 },
	{ 0x99fb, 0x22606b },
	{ 0x99fc, 0x22606e },
	{ 0x99fd, 0x22606c },
	{ 0x99fe, 0x22606d },
	{ 0x99ff, 0x21762c },
	{ 0x9a00, 0x235733 },
	{ 0x9a01, 0x21762b },
	{ 0x9a02, 0x226064 },
	{ 0x9a03, 0x22606f },
	{ 0x9a04, 0x22645d },
	{ 0x9a05, 0x226460 },
	{ 0x9a06, 0x226462 },
	{ 0x9a07, 0x226461 },
	{ 0x9a08, 0x23596a },
	{ 0x9a09, 0x22645b },
	{ 0x9a0a, 0x22645f },
	{ 0x9a0b, 0x22645a },
	{ 0x9a0c, 0x23596b },
	{ 0x9a0d, 0x22645c },
	{ 0x9a0e, 0x217777 },
	{ 0x9a0f, 0x226459 },
	{ 0x9a10, 0x23596d },
	{ 0x9a11, 0x22645e },
	{ 0x9a14, 0x22682d },
	{ 0x9a15, 0x226822 },
	{ 0x9a16, 0x217951 },
	{ 0x9a17, 0x235b6f },
	{ 0x9a18, 0x235b6d },
	{ 0x9a19, 0x217952 },
	{ 0x9a1a, 0x226821 },
	{ 0x9a1b, 0x226826 },
	{ 0x9a1c, 0x22682c },
	{ 0x9a1d, 0x226824 },
	{ 0x9a1e, 0x22682b },
	{ 0x9a1f, 0x235b6c },
	{ 0x9a20, 0x226828 },
	{ 0x9a21, 0x235b6e },
	{ 0x9a22, 0x226827 },
	{ 0x9a23, 0x22682a },
	{ 0x9a24, 0x226825 },
	{ 0x9a25, 0x226823 },
	{ 0x9a26, 0x235b6b },
	{ 0x9a27, 0x226829 },
	{ 0x9a29, 0x226a6e },
	{ 0x9a2a, 0x226a6c },
	{ 0x9a2b, 0x217a55 },
	{ 0x9a2c, 0x226a6b },
	{ 0x9a2d, 0x226a71 },
	{ 0x9a2e, 0x226a6f },
	{ 0x9a2f, 0x235d5a },
	{ 0x9a30, 0x217a56 },
	{ 0x9a31, 0x226a6a },
	{ 0x9a32, 0x226a68 },
	{ 0x9a34, 0x226a69 },
	{ 0x9a35, 0x217a58 },
	{ 0x9a36, 0x226a6d },
	{ 0x9a37, 0x217a57 },
	{ 0x9a38, 0x226a70 },
	{ 0x9a39, 0x226c66 },
	{ 0x9a3a, 0x226c6c },
	{ 0x9a3b, 0x235f24 },
	{ 0x9a3c, 0x235f22 },
	{ 0x9a3d, 0x226c67 },
	{ 0x9a3e, 0x217b47 },
	{ 0x9a3f, 0x226c6d },
	{ 0x9a40, 0x217b46 },
	{ 0x9a41, 0x226c6b },
	{ 0x9a42, 0x226c6a },
	{ 0x9a43, 0x217b45 },
	{ 0x9a44, 0x226c69 },
	{ 0x9a45, 0x217b44 },
	{ 0x9a46, 0x226c68 },
	{ 0x9a48, 0x226e4c },
	{ 0x9a49, 0x226e4e },
	{ 0x9a4a, 0x226e4d },
	{ 0x9a4c, 0x226e4a },
	{ 0x9a4d, 0x217c27 },
	{ 0x9a4e, 0x226e47 },
	{ 0x9a4f, 0x226e4b },
	{ 0x9a50, 0x226e50 },
	{ 0x9a51, 0x235f79 },
	{ 0x9a52, 0x226e4f },
	{ 0x9a53, 0x226e48 },
	{ 0x9a54, 0x226e49 },
	{ 0x9a55, 0x217c26 },
	{ 0x9a56, 0x226f60 },
	{ 0x9a57, 0x217c53 },
	{ 0x9a58, 0x236062 },
	{ 0x9a59, 0x226f61 },
	{ 0x9a5a, 0x217c51 },
	{ 0x9a5b, 0x217c52 },
	{ 0x9a5c, 0x236061 },
	{ 0x9a5e, 0x227061 },
	{ 0x9a5f, 0x217c75 },
	{ 0x9a60, 0x227165 },
	{ 0x9a61, 0x236172 },
	{ 0x9a62, 0x217d37 },
	{ 0x9a63, 0x236173 },
	{ 0x9a64, 0x227223 },
	{ 0x9a65, 0x217d38 },
	{ 0x9a66, 0x227224 },
	{ 0x9a67, 0x227225 },
	{ 0x9a68, 0x227233 },
	{ 0x9a69, 0x227232 },
	{ 0x9a6a, 0x217d47 },
	{ 0x9a6b, 0x22723b },
	{ 0x9aa8, 0x21586c },
	{ 0x9aa9, 0x23402f },
	{ 0x9aab, 0x22486f },
	{ 0x9aad, 0x22486e },
	{ 0x9aaf, 0x216b73 },
	{ 0x9ab0, 0x216b74 },
	{ 0x9ab1, 0x224f42 },
	{ 0x9ab3, 0x22557b },
	{ 0x9ab4, 0x225b78 },
	{ 0x9ab5, 0x234f77 },
	{ 0x9ab6, 0x234f76 },
	{ 0x9ab7, 0x216f7e },
	{ 0x9ab8, 0x217330 },
	{ 0x9ab9, 0x225b76 },
	{ 0x9abb, 0x225b79 },
	{ 0x9abc, 0x217331 },
	{ 0x9abd, 0x23573a },
	{ 0x9abe, 0x226070 },
	{ 0x9abf, 0x225b77 },
	{ 0x9ac0, 0x226463 },
	{ 0x9ac1, 0x217778 },
	{ 0x9ac2, 0x22682e },
	{ 0x9ac4, 0x235d61 },
	{ 0x9ac6, 0x226a74 },
	{ 0x9ac7, 0x226a72 },
	{ 0x9ac8, 0x235d60 },
	{ 0x9ac9, 0x235d5e },
	{ 0x9aca, 0x226a73 },
	{ 0x9acd, 0x226c6e },
	{ 0x9ace, 0x235f25 },
	{ 0x9acf, 0x217b48 },
	{ 0x9ad0, 0x226e51 },
	{ 0x9ad1, 0x217c56 },
	{ 0x9ad2, 0x217c28 },
	{ 0x9ad3, 0x217c54 },
	{ 0x9ad4, 0x217c55 },
	{ 0x9ad5, 0x227062 },
	{ 0x9ad6, 0x217d2f },
	{ 0x9ad7, 0x236174 },
	{ 0x9ad8, 0x21586d },
	{ 0x9ad9, 0x236334 },
	{ 0x9ada, 0x234a6e },
	{ 0x9adc, 0x226464 },
	{ 0x9add, 0x235f7b },
	{ 0x9ade, 0x236063 },
	{ 0x9adf, 0x22334c },
	{ 0x9ae0, 0x234032 },
	{ 0x9ae1, 0x21676c },
	{ 0x9ae2, 0x234561 },
	{ 0x9ae3, 0x224f43 },
	{ 0x9ae4, 0x234a6f },
	{ 0x9ae5, 0x234a73 },
	{ 0x9ae6, 0x216b75 },
	{ 0x9ae7, 0x224f44 },
	{ 0x9ae8, 0x234a71 },
	{ 0x9ae9, 0x234a70 },
	{ 0x9aea, 0x234a72 },
	{ 0x9aeb, 0x22557d },
	{ 0x9aec, 0x22557c },
	{ 0x9aed, 0x217333 },
	{ 0x9aee, 0x217021 },
	{ 0x9aef, 0x217022 },
	{ 0x9af1, 0x225622 },
	{ 0x9af2, 0x225621 },
	{ 0x9af3, 0x22557e },
	{ 0x9af4, 0x234f79 },
	{ 0x9af5, 0x235375 },
	{ 0x9af6, 0x225b7a },
	{ 0x9af7, 0x225b7d },
	{ 0x9af8, 0x235374 },
	{ 0x9af9, 0x225b7c },
	{ 0x9afa, 0x225b7b },
	{ 0x9afb, 0x217332 },
	{ 0x9afc, 0x226074 },
	{ 0x9afd, 0x226072 },
	{ 0x9afe, 0x226071 },
	{ 0x9b00, 0x23573b },
	{ 0x9b01, 0x226073 },
	{ 0x9b02, 0x23573c },
	{ 0x9b03, 0x217779 },
	{ 0x9b04, 0x226466 },
	{ 0x9b05, 0x226467 },
	{ 0x9b06, 0x21777a },
	{ 0x9b07, 0x23596f },
	{ 0x9b08, 0x226465 },
	{ 0x9b09, 0x235b71 },
	{ 0x9b0a, 0x226830 },
	{ 0x9b0b, 0x22682f },
	{ 0x9b0c, 0x226832 },
	{ 0x9b0d, 0x217953 },
	{ 0x9b0e, 0x226831 },
	{ 0x9b10, 0x226a75 },
	{ 0x9b11, 0x226a77 },
	{ 0x9b12, 0x226a76 },
	{ 0x9b14, 0x235f27 },
	{ 0x9b15, 0x226c6f },
	{ 0x9b16, 0x226c72 },
	{ 0x9b17, 0x226c70 },
	{ 0x9b18, 0x226c71 },
	{ 0x9b19, 0x226e52 },
	{ 0x9b1a, 0x217c29 },
	{ 0x9b1d, 0x236672 },
	{ 0x9b1e, 0x226f62 },
	{ 0x9b1f, 0x226f63 },
	{ 0x9b20, 0x226f64 },
	{ 0x9b21, 0x23612c },
	{ 0x9b22, 0x217c76 },
	{ 0x9b23, 0x217d30 },
	{ 0x9b24, 0x227226 },
	{ 0x9b25, 0x21586e },
	{ 0x9b26, 0x234a75 },
	{ 0x9b27, 0x217023 },
	{ 0x9b28, 0x217334 },
	{ 0x9b29, 0x226468 },
	{ 0x9b2a, 0x235d62 },
	{ 0x9b2b, 0x226e53 },
	{ 0x9b2c, 0x23612e },
	{ 0x9b2d, 0x236433 },
	{ 0x9b2e, 0x227166 },
	{ 0x9b2f, 0x22334d },
	{ 0x9b30, 0x236228 },
	{ 0x9b31, 0x217d48 },
	{ 0x9b32, 0x21586f },
	{ 0x9b33, 0x225b7e },
	{ 0x9b34, 0x23573e },
	{ 0x9b35, 0x226469 },
	{ 0x9b37, 0x226833 },
	{ 0x9b38, 0x235d63 },
	{ 0x9b3a, 0x226c73 },
	{ 0x9b3b, 0x226e54 },
	{ 0x9b3c, 0x215870 },
	{ 0x9b3d, 0x234562 },
	{ 0x9b3e, 0x224f45 },
	{ 0x9b3f, 0x224f46 },
	{ 0x9b40, 0x234a78 },
	{ 0x9b41, 0x216b76 },
	{ 0x9b42, 0x216b77 },
	{ 0x9b43, 0x225624 },
	{ 0x9b44, 0x217025 },
	{ 0x9b45, 0x217024 },
	{ 0x9b46, 0x225623 },
	{ 0x9b48, 0x226075 },
	{ 0x9b49, 0x23573f },
	{ 0x9b4a, 0x22646a },
	{ 0x9b4b, 0x22646c },
	{ 0x9b4c, 0x22646b },
	{ 0x9b4d, 0x21777d },
	{ 0x9b4e, 0x21777c },
	{ 0x9b4f, 0x21777b },
	{ 0x9b50, 0x235d64 },
	{ 0x9b51, 0x217b4a },
	{ 0x9b52, 0x226c74 },
	{ 0x9b53, 0x235f28 },
	{ 0x9b54, 0x217b49 },
	{ 0x9b55, 0x226e56 },
	{ 0x9b56, 0x226e55 },
	{ 0x9b57, 0x23612f },
	{ 0x9b58, 0x217c77 },
	{ 0x9b59, 0x227063 },
	{ 0x9b5a, 0x215e23 },
	{ 0x9b5b, 0x224870 },
	{ 0x9b5d, 0x234563 },
	{ 0x9b5f, 0x224f49 },
	{ 0x9b60, 0x224f47 },
	{ 0x9b61, 0x224f48 },
	{ 0x9b63, 0x234f7e },
	{ 0x9b64, 0x22562d },
	{ 0x9b66, 0x225628 },
	{ 0x9b67, 0x225625 },
	{ 0x9b68, 0x22562c },
	{ 0x9b69, 0x234f7c },
	{ 0x9b6b, 0x234f7b },
	{ 0x9b6c, 0x22562e },
	{ 0x9b6f, 0x217027 },
	{ 0x9b70, 0x22562b },
	{ 0x9b71, 0x225627 },
	{ 0x9b72, 0x234f7d },
	{ 0x9b74, 0x225626 },
	{ 0x9b75, 0x22562a },
	{ 0x9b76, 0x225629 },
	{ 0x9b77, 0x217026 },
	{ 0x9b7a, 0x225c2b },
	{ 0x9b7b, 0x225c26 },
	{ 0x9b7c, 0x225c24 },
	{ 0x9b7d, 0x225c2d },
	{ 0x9b7e, 0x225c25 },
	{ 0x9b80, 0x225c21 },
	{ 0x9b82, 0x225c27 },
	{ 0x9b83, 0x235378 },
	{ 0x9b84, 0x23537a },
	{ 0x9b85, 0x225c22 },
	{ 0x9b86, 0x22607e },
	{ 0x9b87, 0x225c23 },
	{ 0x9b88, 0x225c2e },
	{ 0x9b89, 0x235423 },
	{ 0x9b8b, 0x23537c },
	{ 0x9b8c, 0x235421 },
	{ 0x9b8e, 0x235425 },
	{ 0x9b8f, 0x23537d },
	{ 0x9b90, 0x225c2a },
	{ 0x9b91, 0x217335 },
	{ 0x9b92, 0x225c29 },
	{ 0x9b93, 0x225c28 },
	{ 0x9b94, 0x235379 },
	{ 0x9b95, 0x225c2c },
	{ 0x9b98, 0x236673 },
	{ 0x9b99, 0x235744 },
	{ 0x9b9a, 0x226076 },
	{ 0x9b9b, 0x226079 },
	{ 0x9b9d, 0x235745 },
	{ 0x9b9e, 0x226078 },
	{ 0x9b9f, 0x235740 },
	{ 0x9ba0, 0x226122 },
	{ 0x9ba1, 0x22607b },
	{ 0x9ba2, 0x226121 },
	{ 0x9ba3, 0x235742 },
	{ 0x9ba4, 0x22607d },
	{ 0x9ba5, 0x22607c },
	{ 0x9ba6, 0x22607a },
	{ 0x9ba8, 0x226077 },
	{ 0x9baa, 0x21762f },
	{ 0x9bab, 0x21762e },
	{ 0x9bad, 0x217630 },
	{ 0x9bae, 0x21762d },
	{ 0x9baf, 0x226123 },
	{ 0x9bb5, 0x226472 },
	{ 0x9bb6, 0x226475 },
	{ 0x9bb8, 0x226473 },
	{ 0x9bb9, 0x226477 },
	{ 0x9bbb, 0x235974 },
	{ 0x9bbd, 0x226478 },
	{ 0x9bbf, 0x226470 },
	{ 0x9bc0, 0x217824 },
	{ 0x9bc1, 0x226471 },
	{ 0x9bc2, 0x235973 },
	{ 0x9bc3, 0x22646f },
	{ 0x9bc4, 0x226476 },
	{ 0x9bc5, 0x235b74 },
	{ 0x9bc6, 0x22646e },
	{ 0x9bc7, 0x22646d },
	{ 0x9bc8, 0x217823 },
	{ 0x9bc9, 0x217821 },
	{ 0x9bca, 0x21777e },
	{ 0x9bcb, 0x235976 },
	{ 0x9bcc, 0x235975 },
	{ 0x9bcd, 0x235743 },
	{ 0x9bd2, 0x235971 },
	{ 0x9bd3, 0x226474 },
	{ 0x9bd4, 0x22683c },
	{ 0x9bd5, 0x226842 },
	{ 0x9bd6, 0x217956 },
	{ 0x9bd7, 0x22683d },
	{ 0x9bd9, 0x226840 },
	{ 0x9bda, 0x226844 },
	{ 0x9bdb, 0x217957 },
	{ 0x9bdc, 0x22683f },
	{ 0x9bde, 0x226837 },
	{ 0x9bdf, 0x235b75 },
	{ 0x9be0, 0x226836 },
	{ 0x9be1, 0x226843 },
	{ 0x9be2, 0x22683a },
	{ 0x9be3, 0x235b77 },
	{ 0x9be4, 0x226838 },
	{ 0x9be5, 0x226841 },
	{ 0x9be6, 0x226839 },
	{ 0x9be7, 0x217955 },
	{ 0x9be8, 0x217954 },
	{ 0x9be9, 0x235b79 },
	{ 0x9bea, 0x226834 },
	{ 0x9beb, 0x226835 },
	{ 0x9bec, 0x22683e },
	{ 0x9bee, 0x235b7a },
	{ 0x9bf0, 0x22683b },
	{ 0x9bf6, 0x235d6f },
	{ 0x9bf7, 0x226a7a },
	{ 0x9bf8, 0x226a7d },
	{ 0x9bf9, 0x235d71 },
	{ 0x9bfb, 0x235d67 },
	{ 0x9bfc, 0x235d69 },
	{ 0x9bfd, 0x217822 },
	{ 0x9bfe, 0x235d6a },
	{ 0x9bff, 0x235d74 },
	{ 0x9c00, 0x235d75 },
	{ 0x9c02, 0x235d6e },
	{ 0x9c04, 0x235d68 },
	{ 0x9c05, 0x226a7b },
	{ 0x9c06, 0x226b23 },
	{ 0x9c07, 0x226b21 },
	{ 0x9c08, 0x226a79 },
	{ 0x9c09, 0x226b26 },
	{ 0x9c0a, 0x235d66 },
	{ 0x9c0b, 0x226a78 },
	{ 0x9c0c, 0x235d76 },
	{ 0x9c0d, 0x217a5a },
	{ 0x9c0e, 0x226b22 },
	{ 0x9c10, 0x235d73 },
	{ 0x9c12, 0x226a7c },
	{ 0x9c13, 0x217a59 },
	{ 0x9c14, 0x226b25 },
	{ 0x9c15, 0x235d72 },
	{ 0x9c17, 0x226b24 },
	{ 0x9c1b, 0x235d70 },
	{ 0x9c1c, 0x226c77 },
	{ 0x9c1d, 0x226c76 },
	{ 0x9c1f, 0x235f2c },
	{ 0x9c21, 0x226c7d },
	{ 0x9c23, 0x226c79 },
	{ 0x9c24, 0x226c7c },
	{ 0x9c25, 0x217b4c },
	{ 0x9c27, 0x23642f },
	{ 0x9c28, 0x226c7a },
	{ 0x9c29, 0x226c7b },
	{ 0x9c2b, 0x226c75 },
	{ 0x9c2c, 0x226c78 },
	{ 0x9c2d, 0x217b4b },
	{ 0x9c2e, 0x235f2a },
	{ 0x9c31, 0x217c2b },
	{ 0x9c32, 0x226e61 },
	{ 0x9c33, 0x226e5c },
	{ 0x9c34, 0x226e60 },
	{ 0x9c35, 0x236025 },
	{ 0x9c36, 0x226e63 },
	{ 0x9c37, 0x226e5f },
	{ 0x9c38, 0x235f7e },
	{ 0x9c39, 0x226e5b },
	{ 0x9c3a, 0x236023 },
	{ 0x9c3b, 0x217c2d },
	{ 0x9c3c, 0x226e5e },
	{ 0x9c3d, 0x226e62 },
	{ 0x9c3e, 0x217c2c },
	{ 0x9c3f, 0x226e59 },
	{ 0x9c40, 0x226a7e },
	{ 0x9c41, 0x226e5d },
	{ 0x9c44, 0x226e5a },
	{ 0x9c45, 0x236022 },
	{ 0x9c46, 0x226e57 },
	{ 0x9c48, 0x226e58 },
	{ 0x9c49, 0x217c2a },
	{ 0x9c4a, 0x226f68 },
	{ 0x9c4b, 0x226f6a },
	{ 0x9c4c, 0x226f6d },
	{ 0x9c4d, 0x226f69 },
	{ 0x9c4e, 0x226f6e },
	{ 0x9c4f, 0x236065 },
	{ 0x9c50, 0x226f67 },
	{ 0x9c51, 0x236066 },
	{ 0x9c52, 0x226f65 },
	{ 0x9c53, 0x236068 },
	{ 0x9c54, 0x217c57 },
	{ 0x9c55, 0x226f6b },
	{ 0x9c56, 0x217c59 },
	{ 0x9c57, 0x217c58 },
	{ 0x9c58, 0x226f66 },
	{ 0x9c59, 0x226f6c },
	{ 0x9c5d, 0x236132 },
	{ 0x9c5e, 0x227068 },
	{ 0x9c5f, 0x217c78 },
	{ 0x9c60, 0x227069 },
	{ 0x9c61, 0x236133 },
	{ 0x9c62, 0x227067 },
	{ 0x9c63, 0x227064 },
	{ 0x9c65, 0x236134 },
	{ 0x9c66, 0x227066 },
	{ 0x9c67, 0x227065 },
	{ 0x9c68, 0x227149 },
	{ 0x9c6c, 0x236159 },
	{ 0x9c6d, 0x22714b },
	{ 0x9c6e, 0x22714a },
	{ 0x9c6f, 0x23615b },
	{ 0x9c71, 0x227169 },
	{ 0x9c73, 0x227168 },
	{ 0x9c74, 0x227167 },
	{ 0x9c75, 0x22716a },
	{ 0x9c76, 0x236175 },
	{ 0x9c77, 0x217d40 },
	{ 0x9c78, 0x217d41 },
	{ 0x9c79, 0x227238 },
	{ 0x9c7a, 0x22723c },
	{ 0x9c7b, 0x236241 },
	{ 0x9ce5, 0x215e24 },
	{ 0x9ce6, 0x224154 },
	{ 0x9ce7, 0x224873 },
	{ 0x9ce8, 0x234564 },
	{ 0x9ce9, 0x21676d },
	{ 0x9cea, 0x224871 },
	{ 0x9ceb, 0x234566 },
	{ 0x9cec, 0x232f42 },
	{ 0x9ced, 0x224872 },
	{ 0x9cee, 0x234568 },
	{ 0x9cef, 0x234567 },
	{ 0x9cf1, 0x224f4a },
	{ 0x9cf2, 0x224f4b },
	{ 0x9cf3, 0x216b7a },
	{ 0x9cf4, 0x216b78 },
	{ 0x9cf5, 0x224f4c },
	{ 0x9cf6, 0x216b79 },
	{ 0x9cf7, 0x225633 },
	{ 0x9cf8, 0x235027 },
	{ 0x9cf9, 0x225636 },
	{ 0x9cfa, 0x225630 },
	{ 0x9cfb, 0x225637 },
	{ 0x9cfc, 0x22562f },
	{ 0x9cfd, 0x225631 },
	{ 0x9cfe, 0x23502a },
	{ 0x9cff, 0x225632 },
	{ 0x9d00, 0x225635 },
	{ 0x9d01, 0x235024 },
	{ 0x9d02, 0x23502b },
	{ 0x9d03, 0x21702a },
	{ 0x9d04, 0x22563a },
	{ 0x9d05, 0x225639 },
	{ 0x9d06, 0x217028 },
	{ 0x9d07, 0x225634 },
	{ 0x9d08, 0x225638 },
	{ 0x9d09, 0x217029 },
	{ 0x9d0a, 0x23542d },
	{ 0x9d0c, 0x235025 },
	{ 0x9d0d, 0x235022 },
	{ 0x9d0f, 0x23542a },
	{ 0x9d10, 0x225c38 },
	{ 0x9d12, 0x21733a },
	{ 0x9d13, 0x23542c },
	{ 0x9d14, 0x225c33 },
	{ 0x9d15, 0x217336 },
	{ 0x9d16, 0x235436 },
	{ 0x9d17, 0x225c30 },
	{ 0x9d18, 0x225c36 },
	{ 0x9d19, 0x225c39 },
	{ 0x9d1a, 0x235433 },
	{ 0x9d1b, 0x21733b },
	{ 0x9d1d, 0x225c35 },
	{ 0x9d1e, 0x225c32 },
	{ 0x9d1f, 0x225c3a },
	{ 0x9d20, 0x225c31 },
	{ 0x9d21, 0x235437 },
	{ 0x9d22, 0x225c37 },
	{ 0x9d23, 0x217337 },
	{ 0x9d24, 0x235429 },
	{ 0x9d25, 0x225c2f },
	{ 0x9d26, 0x217338 },
	{ 0x9d27, 0x235435 },
	{ 0x9d28, 0x217339 },
	{ 0x9d29, 0x225c34 },
	{ 0x9d2a, 0x235432 },
	{ 0x9d2d, 0x226135 },
	{ 0x9d2e, 0x226128 },
	{ 0x9d2f, 0x226129 },
	{ 0x9d30, 0x22612c },
	{ 0x9d31, 0x22612a },
	{ 0x9d33, 0x226124 },
	{ 0x9d35, 0x23574d },
	{ 0x9d36, 0x226127 },
	{ 0x9d37, 0x226131 },
	{ 0x9d38, 0x22612b },
	{ 0x9d39, 0x235748 },
	{ 0x9d3b, 0x217631 },
	{ 0x9d3d, 0x226133 },
	{ 0x9d3e, 0x226130 },
	{ 0x9d3f, 0x217632 },
	{ 0x9d40, 0x226132 },
	{ 0x9d41, 0x226125 },
	{ 0x9d42, 0x22612e },
	{ 0x9d43, 0x22612f },
	{ 0x9d44, 0x23574a },
	{ 0x9d45, 0x22612d },
	{ 0x9d49, 0x236675 },
	{ 0x9d4a, 0x22647c },
	{ 0x9d4b, 0x22647e },
	{ 0x9d4c, 0x226523 },
	{ 0x9d4d, 0x235979 },
	{ 0x9d4e, 0x23597b },
	{ 0x9d4f, 0x22647b },
	{ 0x9d50, 0x23597d },
	{ 0x9d51, 0x217825 },
	{ 0x9d52, 0x226525 },
	{ 0x9d53, 0x22647a },
	{ 0x9d54, 0x226526 },
	{ 0x9d55, 0x23597e },
	{ 0x9d56, 0x226522 },
	{ 0x9d57, 0x226524 },
	{ 0x9d58, 0x226528 },
	{ 0x9d59, 0x226521 },
	{ 0x9d5a, 0x226529 },
	{ 0x9d5b, 0x22647d },
	{ 0x9d5c, 0x226479 },
	{ 0x9d5d, 0x217826 },
	{ 0x9d5e, 0x235a22 },
	{ 0x9d5f, 0x226527 },
	{ 0x9d60, 0x217827 },
	{ 0x9d61, 0x217959 },
	{ 0x9d63, 0x23597a },
	{ 0x9d66, 0x235b7d },
	{ 0x9d67, 0x226126 },
	{ 0x9d68, 0x22685e },
	{ 0x9d69, 0x226855 },
	{ 0x9d6a, 0x21795b },
	{ 0x9d6b, 0x226851 },
	{ 0x9d6c, 0x21795c },
	{ 0x9d6d, 0x235c27 },
	{ 0x9d6e, 0x235c22 },
	{ 0x9d6f, 0x22685a },
	{ 0x9d70, 0x226854 },
	{ 0x9d71, 0x22684a },
	{ 0x9d72, 0x21795a },
	{ 0x9d73, 0x226857 },
	{ 0x9d74, 0x226852 },
	{ 0x9d75, 0x226853 },
	{ 0x9d76, 0x235c25 },
	{ 0x9d77, 0x226845 },
	{ 0x9d78, 0x22684c },
	{ 0x9d79, 0x22685b },
	{ 0x9d7a, 0x235b7e },
	{ 0x9d7b, 0x226858 },
	{ 0x9d7d, 0x226850 },
	{ 0x9d7e, 0x235c26 },
	{ 0x9d7f, 0x22685c },
	{ 0x9d80, 0x22684b },
	{ 0x9d81, 0x226846 },
	{ 0x9d82, 0x226859 },
	{ 0x9d83, 0x235c24 },
	{ 0x9d84, 0x226848 },
	{ 0x9d85, 0x226856 },
	{ 0x9d86, 0x22684d },
	{ 0x9d87, 0x22685d },
	{ 0x9d88, 0x226849 },
	{ 0x9d89, 0x217958 },
	{ 0x9d8a, 0x226847 },
	{ 0x9d8b, 0x22684e },
	{ 0x9d8c, 0x22684f },
	{ 0x9d90, 0x226b2d },
	{ 0x9d91, 0x235c23 },
	{ 0x9d92, 0x226b2b },
	{ 0x9d94, 0x226b30 },
	{ 0x9d95, 0x235d79 },
	{ 0x9d96, 0x226b3c },
	{ 0x9d97, 0x226b33 },
	{ 0x9d98, 0x226b2c },
	{ 0x9d99, 0x226b28 },
	{ 0x9d9a, 0x226b35 },
	{ 0x9d9b, 0x226b2e },
	{ 0x9d9c, 0x226b31 },
	{ 0x9d9d, 0x226b2a },
	{ 0x9d9e, 0x226b38 },
	{ 0x9d9f, 0x226b27 },
	{ 0x9da0, 0x226b2f },
	{ 0x9da1, 0x226b34 },
	{ 0x9da2, 0x226b36 },
	{ 0x9da3, 0x226b39 },
	{ 0x9da4, 0x226b29 },
	{ 0x9da5, 0x235d7a },
	{ 0x9da6, 0x226b3d },
	{ 0x9da7, 0x226b3e },
	{ 0x9da8, 0x226b37 },
	{ 0x9da9, 0x226b3b },
	{ 0x9daa, 0x226b32 },
	{ 0x9dac, 0x226d2f },
	{ 0x9dad, 0x226d32 },
	{ 0x9dae, 0x235f35 },
	{ 0x9daf, 0x217b4d },
	{ 0x9db0, 0x235f31 },
	{ 0x9db1, 0x226d31 },
	{ 0x9db2, 0x226d36 },
	{ 0x9db3, 0x226d34 },
	{ 0x9db4, 0x217b4e },
	{ 0x9db5, 0x226d2b },
	{ 0x9db6, 0x226d21 },
	{ 0x9db7, 0x226c7e },
	{ 0x9db8, 0x217b50 },
	{ 0x9db9, 0x226d2d },
	{ 0x9dba, 0x226d2e },
	{ 0x9dbb, 0x226d2a },
	{ 0x9dbc, 0x226d22 },
	{ 0x9dbd, 0x235f32 },
	{ 0x9dbe, 0x226d27 },
	{ 0x9dbf, 0x226b3a },
	{ 0x9dc1, 0x226d23 },
	{ 0x9dc2, 0x217b4f },
	{ 0x9dc3, 0x226d29 },
	{ 0x9dc4, 0x235f36 },
	{ 0x9dc5, 0x226d28 },
	{ 0x9dc7, 0x226d24 },
	{ 0x9dc8, 0x226d30 },
	{ 0x9dca, 0x226d25 },
	{ 0x9dcb, 0x226e68 },
	{ 0x9dcc, 0x226d33 },
	{ 0x9dcd, 0x226d35 },
	{ 0x9dce, 0x226d2c },
	{ 0x9dcf, 0x226d26 },
	{ 0x9dd0, 0x226e69 },
	{ 0x9dd1, 0x226e6b },
	{ 0x9dd2, 0x226e65 },
	{ 0x9dd3, 0x217c2e },
	{ 0x9dd5, 0x226e72 },
	{ 0x9dd6, 0x226e70 },
	{ 0x9dd7, 0x217c2f },
	{ 0x9dd8, 0x226e6f },
	{ 0x9dd9, 0x226e6e },
	{ 0x9dda, 0x226e67 },
	{ 0x9ddb, 0x226e64 },
	{ 0x9ddc, 0x226e6a },
	{ 0x9ddd, 0x226e73 },
	{ 0x9dde, 0x226e66 },
	{ 0x9ddf, 0x226e6c },
	{ 0x9de1, 0x226f77 },
	{ 0x9de2, 0x226f7c },
	{ 0x9de3, 0x226f72 },
	{ 0x9de4, 0x226f75 },
	{ 0x9de5, 0x217c5a },
	{ 0x9de6, 0x226f79 },
	{ 0x9de8, 0x227022 },
	{ 0x9de9, 0x226e6d },
	{ 0x9deb, 0x226f73 },
	{ 0x9dec, 0x226f7d },
	{ 0x9ded, 0x227023 },
	{ 0x9dee, 0x226f78 },
	{ 0x9def, 0x226f71 },
	{ 0x9df0, 0x226f7b },
	{ 0x9df2, 0x226f7a },
	{ 0x9df3, 0x227021 },
	{ 0x9df4, 0x226f7e },
	{ 0x9df5, 0x226e71 },
	{ 0x9df6, 0x226f76 },
	{ 0x9df7, 0x226f70 },
	{ 0x9df8, 0x226f74 },
	{ 0x9df9, 0x217c79 },
	{ 0x9dfa, 0x217c7a },
	{ 0x9dfb, 0x226f6f },
	{ 0x9dfc, 0x23606c },
	{ 0x9dfd, 0x227074 },
	{ 0x9dfe, 0x22706b },
	{ 0x9dff, 0x227073 },
	{ 0x9e00, 0x227070 },
	{ 0x9e01, 0x227071 },
	{ 0x9e02, 0x22706a },
	{ 0x9e03, 0x22706d },
	{ 0x9e04, 0x227075 },
	{ 0x9e05, 0x22706f },
	{ 0x9e06, 0x22706e },
	{ 0x9e07, 0x22706c },
	{ 0x9e08, 0x236135 },
	{ 0x9e09, 0x227072 },
	{ 0x9e0b, 0x22714c },
	{ 0x9e0d, 0x22714d },
	{ 0x9e0e, 0x23615d },
	{ 0x9e0f, 0x22714f },
	{ 0x9e10, 0x22714e },
	{ 0x9e11, 0x227151 },
	{ 0x9e12, 0x227150 },
	{ 0x9e13, 0x22716c },
	{ 0x9e14, 0x22716b },
	{ 0x9e15, 0x227227 },
	{ 0x9e16, 0x236229 },
	{ 0x9e17, 0x227228 },
	{ 0x9e18, 0x236230 },
	{ 0x9e19, 0x227234 },
	{ 0x9e1a, 0x217d45 },
	{ 0x9e1b, 0x217d49 },
	{ 0x9e1c, 0x236238 },
	{ 0x9e1d, 0x22723d },
	{ 0x9e1e, 0x217d4a },
	{ 0x9e75, 0x215e25 },
	{ 0x9e79, 0x217a5b },
	{ 0x9e7a, 0x226d37 },
	{ 0x9e7b, 0x235f37 },
	{ 0x9e7c, 0x217c7b },
	{ 0x9e7d, 0x217c7c },
	{ 0x9e7f, 0x215e26 },
	{ 0x9e80, 0x224874 },
	{ 0x9e81, 0x234569 },
	{ 0x9e82, 0x21676e },
	{ 0x9e83, 0x22563b },
	{ 0x9e84, 0x23502c },
	{ 0x9e85, 0x235439 },
	{ 0x9e86, 0x225c3c },
	{ 0x9e87, 0x225c3d },
	{ 0x9e88, 0x225c3b },
	{ 0x9e89, 0x226137 },
	{ 0x9e8a, 0x226136 },
	{ 0x9e8b, 0x217633 },
	{ 0x9e8c, 0x22652b },
	{ 0x9e8d, 0x226138 },
	{ 0x9e8e, 0x22652a },
	{ 0x9e90, 0x235a24 },
	{ 0x9e91, 0x226860 },
	{ 0x9e92, 0x21795d },
	{ 0x9e93, 0x21795f },
	{ 0x9e94, 0x22685f },
	{ 0x9e95, 0x235c29 },
	{ 0x9e97, 0x21795e },
	{ 0x9e98, 0x235e21 },
	{ 0x9e99, 0x226b3f },
	{ 0x9e9a, 0x226b41 },
	{ 0x9e9b, 0x226b40 },
	{ 0x9e9c, 0x226d38 },
	{ 0x9e9d, 0x217b51 },
	{ 0x9e9e, 0x235f3a },
	{ 0x9e9f, 0x217c5b },
	{ 0x9ea0, 0x227076 },
	{ 0x9ea1, 0x227152 },
	{ 0x9ea2, 0x236231 },
	{ 0x9ea3, 0x23623f },
	{ 0x9ea4, 0x227241 },
	{ 0x9ea5, 0x215e27 },
	{ 0x9ea6, 0x232547 },
	{ 0x9ea7, 0x224f4d },
	{ 0x9ea9, 0x21702b },
	{ 0x9eaa, 0x23502f },
	{ 0x9eab, 0x23502e },
	{ 0x9eac, 0x23543a },
	{ 0x9ead, 0x225c3f },
	{ 0x9eae, 0x225c3e },
	{ 0x9eaf, 0x235750 },
	{ 0x9eb0, 0x226139 },
	{ 0x9eb1, 0x235a26 },
	{ 0x9eb2, 0x235a25 },
	{ 0x9eb4, 0x217960 },
	{ 0x9eb5, 0x217a5c },
	{ 0x9eb6, 0x226e74 },
	{ 0x9eb7, 0x227239 },
	{ 0x9ebb, 0x215e28 },
	{ 0x9ebc, 0x216b7b },
	{ 0x9ebd, 0x234b22 },
	{ 0x9ebe, 0x21702c },
	{ 0x9ec0, 0x226861 },
	{ 0x9ec1, 0x235e22 },
	{ 0x9ec2, 0x227024 },
	{ 0x9ec3, 0x216327 },
	{ 0x9ec4, 0x23396a },
	{ 0x9ec5, 0x23543c },
	{ 0x9ec6, 0x23543b },
	{ 0x9ec8, 0x22613a },
	{ 0x9eca, 0x235a28 },
	{ 0x9ecc, 0x217d31 },
	{ 0x9ecd, 0x216328 },
	{ 0x9ece, 0x21702d },
	{ 0x9ecf, 0x217634 },
	{ 0x9ed0, 0x227025 },
	{ 0x9ed1, 0x216329 },
	{ 0x9ed2, 0x23396b },
	{ 0x9ed3, 0x22563c },
	{ 0x9ed4, 0x21733d },
	{ 0x9ed5, 0x225c40 },
	{ 0x9ed6, 0x225c41 },
	{ 0x9ed7, 0x23543d },
	{ 0x9ed8, 0x21733c },
	{ 0x9eda, 0x22613b },
	{ 0x9edb, 0x217638 },
	{ 0x9edc, 0x217636 },
	{ 0x9edd, 0x217637 },
	{ 0x9ede, 0x217635 },
	{ 0x9edf, 0x22652c },
	{ 0x9ee0, 0x217828 },
	{ 0x9ee3, 0x235c2a },
	{ 0x9ee4, 0x226b43 },
	{ 0x9ee5, 0x226b42 },
	{ 0x9ee6, 0x226b45 },
	{ 0x9ee7, 0x226b44 },
	{ 0x9ee8, 0x217a5d },
	{ 0x9eeb, 0x226d39 },
	{ 0x9eed, 0x226d3b },
	{ 0x9eee, 0x226d3a },
	{ 0x9eef, 0x217b52 },
	{ 0x9ef0, 0x226e75 },
	{ 0x9ef1, 0x236029 },
	{ 0x9ef2, 0x227026 },
	{ 0x9ef3, 0x227027 },
	{ 0x9ef4, 0x217c5c },
	{ 0x9ef5, 0x227153 },
	{ 0x9ef6, 0x22716d },
	{ 0x9ef7, 0x217d42 },
	{ 0x9ef9, 0x224155 },
	{ 0x9efa, 0x225c42 },
	{ 0x9efb, 0x22613c },
	{ 0x9efc, 0x226862 },
	{ 0x9efd, 0x224875 },
	{ 0x9efe, 0x232772 },
	{ 0x9eff, 0x22613d },
	{ 0x9f00, 0x22652e },
	{ 0x9f01, 0x22652d },
	{ 0x9f02, 0x235a29 },
	{ 0x9f03, 0x235c2d },
	{ 0x9f04, 0x235c2e },
	{ 0x9f05, 0x235f3c },
	{ 0x9f06, 0x227028 },
	{ 0x9f07, 0x217c7d },
	{ 0x9f08, 0x23615f },
	{ 0x9f09, 0x227154 },
	{ 0x9f0a, 0x22716e },
	{ 0x9f0e, 0x21676f },
	{ 0x9f0f, 0x22563d },
	{ 0x9f10, 0x22563e },
	{ 0x9f12, 0x225c43 },
	{ 0x9f13, 0x216770 },
	{ 0x9f14, 0x23456a },
	{ 0x9f15, 0x217829 },
	{ 0x9f16, 0x22652f },
	{ 0x9f17, 0x235c30 },
	{ 0x9f18, 0x226d3d },
	{ 0x9f19, 0x217b53 },
	{ 0x9f1a, 0x226d3e },
	{ 0x9f1b, 0x226d3c },
	{ 0x9f1c, 0x227029 },
	{ 0x9f1d, 0x236160 },
	{ 0x9f1e, 0x227077 },
	{ 0x9f20, 0x216771 },
	{ 0x9f22, 0x226140 },
	{ 0x9f23, 0x22613f },
	{ 0x9f24, 0x22613e },
	{ 0x9f25, 0x226530 },
	{ 0x9f26, 0x235a2b },
	{ 0x9f27, 0x235a2a },
	{ 0x9f28, 0x226534 },
	{ 0x9f29, 0x226533 },
	{ 0x9f2a, 0x226532 },
	{ 0x9f2b, 0x226531 },
	{ 0x9f2c, 0x21782a },
	{ 0x9f2d, 0x226863 },
	{ 0x9f2e, 0x226b47 },
	{ 0x9f2f, 0x217a5e },
	{ 0x9f30, 0x226b46 },
	{ 0x9f31, 0x226d3f },
	{ 0x9f32, 0x226e78 },
	{ 0x9f33, 0x226e77 },
	{ 0x9f34, 0x217c30 },
	{ 0x9f35, 0x226e76 },
	{ 0x9f36, 0x22702c },
	{ 0x9f37, 0x22702b },
	{ 0x9f38, 0x22702a },
	{ 0x9f39, 0x23606d },
	{ 0x9f3b, 0x216b7c },
	{ 0x9f3d, 0x225c44 },
	{ 0x9f3e, 0x217639 },
	{ 0x9f40, 0x226864 },
	{ 0x9f41, 0x226865 },
	{ 0x9f42, 0x226e79 },
	{ 0x9f43, 0x22702d },
	{ 0x9f45, 0x23613b },
	{ 0x9f46, 0x227078 },
	{ 0x9f47, 0x227155 },
	{ 0x9f48, 0x227229 },
	{ 0x9f49, 0x227243 },
	{ 0x9f4a, 0x216b7d },
	{ 0x9f4b, 0x21763a },
	{ 0x9f4c, 0x226535 },
	{ 0x9f4d, 0x226866 },
	{ 0x9f4e, 0x226d40 },
	{ 0x9f4f, 0x22702e },
	{ 0x9f50, 0x232370 },
	{ 0x9f52, 0x21702f },
	{ 0x9f53, 0x23543e },
	{ 0x9f54, 0x226141 },
	{ 0x9f55, 0x226536 },
	{ 0x9f56, 0x226867 },
	{ 0x9f57, 0x226868 },
	{ 0x9f58, 0x226869 },
	{ 0x9f59, 0x226b4c },
	{ 0x9f5a, 0x235e24 },
	{ 0x9f5b, 0x226b48 },
	{ 0x9f5c, 0x217b54 },
	{ 0x9f5d, 0x226b4b },
	{ 0x9f5e, 0x226b4a },
	{ 0x9f5f, 0x217a5f },
	{ 0x9f60, 0x226b49 },
	{ 0x9f61, 0x217a61 },
	{ 0x9f63, 0x217a60 },
	{ 0x9f64, 0x226d42 },
	{ 0x9f65, 0x226d41 },
	{ 0x9f66, 0x217b55 },
	{ 0x9f67, 0x217b56 },
	{ 0x9f69, 0x235f3e },
	{ 0x9f6a, 0x217c32 },
	{ 0x9f6b, 0x226e7a },
	{ 0x9f6c, 0x217c31 },
	{ 0x9f6e, 0x227031 },
	{ 0x9f6f, 0x227032 },
	{ 0x9f70, 0x227030 },
	{ 0x9f71, 0x22702f },
	{ 0x9f72, 0x217d21 },
	{ 0x9f74, 0x227079 },
	{ 0x9f75, 0x22707a },
	{ 0x9f76, 0x22707b },
	{ 0x9f77, 0x217c7e },
	{ 0x9f78, 0x227156 },
	{ 0x9f79, 0x227159 },
	{ 0x9f7a, 0x227158 },
	{ 0x9f7b, 0x227157 },
	{ 0x9f7c, 0x236233 },
	{ 0x9f7e, 0x227242 },
	{ 0x9f8d, 0x21733e },
	{ 0x9f8e, 0x235755 },
	{ 0x9f90, 0x217832 },
	{ 0x9f91, 0x226b4d },
	{ 0x9f92, 0x226d43 },
	{ 0x9f93, 0x23602b },
	{ 0x9f94, 0x217c33 },
	{ 0x9f95, 0x226e7b },
	{ 0x9f97, 0x236242 },
	{ 0x9f98, 0x227244 },
	{ 0x9f9c, 0x21733f },
	{ 0x9f9d, 0x235e47 },
	{ 0x9fa0, 0x226142 },
	{ 0x9fa1, 0x235f3f },
	{ 0x9fa2, 0x226e7c },
	{ 0x9fa3, 0x236161 },
	{ 0x9fa4, 0x22716f },
	{ 0x9fa5, 0x236177 },
	{ 0xfe30, 0x21212b },
	{ 0xfe31, 0x212136 },
	{ 0xfe32, 0x212138 },
	{ 0xfe35, 0x212140 },
	{ 0xfe36, 0x212141 },
	{ 0xfe37, 0x212144 },
	{ 0xfe38, 0x212145 },
	{ 0xfe39, 0x212148 },
	{ 0xfe3a, 0x212149 },
	{ 0xfe3b, 0x21214c },
	{ 0xfe3c, 0x21214d },
	{ 0xfe3d, 0x212150 },
	{ 0xfe3e, 0x212151 },
	{ 0xfe3f, 0x212154 },
	{ 0xfe40, 0x212155 },
	{ 0xfe41, 0x212158 },
	{ 0xfe42, 0x212159 },
	{ 0xfe43, 0x21215c },
	{ 0xfe44, 0x21215d },
	{ 0xfe49, 0x212227 },
	{ 0xfe4a, 0x212228 },
	{ 0xfe4b, 0x21222b },
	{ 0xfe4c, 0x21222c },
	{ 0xfe4d, 0x212229 },
	{ 0xfe4e, 0x21222a },
	{ 0xfe50, 0x21212e },
	{ 0xfe51, 0x21212f },
	{ 0xfe52, 0x212130 },
	{ 0xfe53, 0x212131 },
	{ 0xfe54, 0x212132 },
	{ 0xfe55, 0x212133 },
	{ 0xfe56, 0x212134 },
	{ 0xfe57, 0x212135 },
	{ 0xfe59, 0x21215e },
	{ 0xfe5a, 0x21215f },
	{ 0xfe5b, 0x212160 },
	{ 0xfe5c, 0x212161 },
	{ 0xfe5d, 0x212162 },
	{ 0xfe5e, 0x212163 },
	{ 0xfe5f, 0x21222d },
	{ 0xfe60, 0x21222e },
	{ 0xfe61, 0x21222f },
	{ 0xfe62, 0x21223f },
	{ 0xfe63, 0x212240 },
	{ 0xfe64, 0x212241 },
	{ 0xfe65, 0x212243 },
	{ 0xfe66, 0x212242 },
	{ 0xfe67, 0x212261 },
	{ 0xfe68, 0x212262 },
	{ 0xfe69, 0x21226c },
	{ 0xfe6a, 0x21226d },
	{ 0xfe6b, 0x21226e },
	{ 0xff01, 0x21212a },
	{ 0xff03, 0x21216c },
	{ 0xff04, 0x212263 },
	{ 0xff05, 0x212268 },
	{ 0xff06, 0x21216d },
	{ 0xff08, 0x21213e },
	{ 0xff09, 0x21213f },
	{ 0xff0a, 0x21216e },
	{ 0xff0b, 0x212230 },
	{ 0xff0c, 0x212122 },
	{ 0xff0d, 0x212231 },
	{ 0xff0e, 0x212125 },
	{ 0xff0f, 0x21225f },
	{ 0xff10, 0x212421 },
	{ 0xff11, 0x212422 },
	{ 0xff12, 0x212423 },
	{ 0xff13, 0x212424 },
	{ 0xff14, 0x212425 },
	{ 0xff15, 0x212426 },
	{ 0xff16, 0x212427 },
	{ 0xff17, 0x212428 },
	{ 0xff18, 0x212429 },
	{ 0xff19, 0x21242a },
	{ 0xff1a, 0x212128 },
	{ 0xff1b, 0x212127 },
	{ 0xff1c, 0x212236 },
	{ 0xff1d, 0x212238 },
	{ 0xff1e, 0x212237 },
	{ 0xff1f, 0x212129 },
	{ 0xff20, 0x212269 },
	{ 0xff21, 0x212441 },
	{ 0xff22, 0x212442 },
	{ 0xff23, 0x212443 },
	{ 0xff24, 0x212444 },
	{ 0xff25, 0x212445 },
	{ 0xff26, 0x212446 },
	{ 0xff27, 0x212447 },
	{ 0xff28, 0x212448 },
	{ 0xff29, 0x212449 },
	{ 0xff2a, 0x21244a },
	{ 0xff2b, 0x21244b },
	{ 0xff2c, 0x21244c },
	{ 0xff2d, 0x21244d },
	{ 0xff2e, 0x21244e },
	{ 0xff2f, 0x21244f },
	{ 0xff30, 0x212450 },
	{ 0xff31, 0x212451 },
	{ 0xff32, 0x212452 },
	{ 0xff33, 0x212453 },
	{ 0xff34, 0x212454 },
	{ 0xff35, 0x212455 },
	{ 0xff36, 0x212456 },
	{ 0xff37, 0x212457 },
	{ 0xff38, 0x212458 },
	{ 0xff39, 0x212459 },
	{ 0xff3a, 0x21245a },
	{ 0xff3c, 0x212260 },
	{ 0xff3f, 0x212225 },
	{ 0xff41, 0x21245b },
	{ 0xff42, 0x21245c },
	{ 0xff43, 0x21245d },
	{ 0xff44, 0x21245e },
	{ 0xff45, 0x21245f },
	{ 0xff46, 0x212460 },
	{ 0xff47, 0x212461 },
	{ 0xff48, 0x212462 },
	{ 0xff49, 0x212463 },
	{ 0xff4a, 0x212464 },
	{ 0xff4b, 0x212465 },
	{ 0xff4c, 0x212466 },
	{ 0xff4d, 0x212467 },
	{ 0xff4e, 0x212468 },
	{ 0xff4f, 0x212469 },
	{ 0xff50, 0x21246a },
	{ 0xff51, 0x21246b },
	{ 0xff52, 0x21246c },
	{ 0xff53, 0x21246d },
	{ 0xff54, 0x21246e },
	{ 0xff55, 0x21246f },
	{ 0xff56, 0x212470 },
	{ 0xff57, 0x212471 },
	{ 0xff58, 0x212472 },
	{ 0xff59, 0x212473 },
	{ 0xff5a, 0x212474 },
	{ 0xff5b, 0x212142 },
	{ 0xff5c, 0x21225e },
	{ 0xff5d, 0x212143 }
};

#endif
