/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 *	Copyright(c)	1997, Sun Microsystems, Inc.
 *	All rights reserved.
 */

#define BIG5MAX	6752
typedef struct gb_cns {
	long gbcode;
	long cnscode;
} gb_cns;

/* the table is generated from gb_big5 and big5_cns */
gb_cns gb_cns_tab[BIG5MAX] = {
	0xA1A1, 0x212121,
	0xA1A2, 0x212123,
	0xA1A3, 0x212124,
	0xA1A4, 0x212130,
	0xA1A5, 0x212223,
	0xA1A7, 0x21212D,
	0xA1A8, 0x212171,
	0xA1AA, 0x212339,
	0xA1AB, 0x212244,
	0xA1AC, 0x21225D,
	0xA1AD, 0x21212C,
	0xA1AE, 0x212164,
	0xA1AF, 0x212165,
	0xA1B0, 0x212166,
	0xA1B1, 0x212167,
	0xA1B2, 0x212146,
	0xA1B3, 0x212147,
	0xA1B4, 0x212152,
	0xA1B5, 0x212153,
	0xA1B6, 0x21214E,
	0xA1B7, 0x21214F,
	0xA1B8, 0x212156,
	0xA1B9, 0x212157,
	0xA1BA, 0x21215A,
	0xA1BB, 0x21215B,
	0xA1BE, 0x21214A,
	0xA1BF, 0x21214B,
	0xA1C0, 0x212234,
	0xA1C1, 0x212232,
	0xA1C2, 0x212233,
	0xA1C3, 0x21212B,
	0xA1C4, 0x212521,
	0xA1C6, 0x212528,
	0xA1C7, 0x212526,
	0xA1C8, 0x212246,
	0xA1C9, 0x212245,
	0xA1CC, 0x212235,
	0xA1CF, 0x212248,
	0xA1D1, 0x212254,
	0xA1D2, 0x21224D,
	0xA1D3, 0x21224E,
	0xA1D4, 0x21223E,
	0xA1D6, 0x21223D,
	0xA1D9, 0x21223B,
	0xA1DC, 0x212239,
	0xA1DD, 0x21223A,
	0xA1DE, 0x21223C,
	0xA1DF, 0x21224F,
	0xA1E0, 0x212250,
	0xA1E1, 0x212252,
	0xA1E2, 0x212251,
	0xA1E3, 0x212278,
	0xA1E4, 0x21216B,
	0xA1E5, 0x212169,
	0xA1E6, 0x21226A,
	0xA1E7, 0x212263,
	0xA1E9, 0x212266,
	0xA1EA, 0x212267,
	0xA1EC, 0x212170,
	0xA1EE, 0x212177,
	0xA1EF, 0x212178,
	0xA1F0, 0x212172,
	0xA1F1, 0x212173,
	0xA1F2, 0x212176,
	0xA1F3, 0x212179,
	0xA1F4, 0x21217A,
	0xA1F5, 0x21217B,
	0xA1F6, 0x21217C,
	0xA1F7, 0x212174,
	0xA1F8, 0x212175,
	0xA1F9, 0x21216F,
	0xA1FA, 0x212258,
	0xA1FB, 0x212257,
	0xA1FC, 0x212255,
	0xA1FD, 0x212256,
	0xA1FE, 0x212344,
	0xA2F1, 0x21242B,
	0xA2F2, 0x21242C,
	0xA2F3, 0x21242D,
	0xA2F4, 0x21242E,
	0xA2F5, 0x21242F,
	0xA2F6, 0x212430,
	0xA2F7, 0x212431,
	0xA2F8, 0x212432,
	0xA2F9, 0x212433,
	0xA2FA, 0x212434,
	0xA3A1, 0x21212A,
	0xA3A2, 0x212168,
	0xA3A3, 0x21216C,
	0xA3A4, 0x212263,
	0xA3A5, 0x212268,
	0xA3A6, 0x21216D,
	0xA3A7, 0x21216B,
	0xA3A8, 0x21213E,
	0xA3A9, 0x21213F,
	0xA3AA, 0x21216E,
	0xA3AB, 0x212230,
	0xA3AC, 0x212122,
	0xA3AD, 0x212231,
	0xA3AE, 0x212125,
	0xA3AF, 0x21225F,
	0xA3B0, 0x212421,
	0xA3B1, 0x212422,
	0xA3B2, 0x212423,
	0xA3B3, 0x212424,
	0xA3B4, 0x212425,
	0xA3B5, 0x212426,
	0xA3B6, 0x212427,
	0xA3B7, 0x212428,
	0xA3B8, 0x212429,
	0xA3B9, 0x21242A,
	0xA3BA, 0x212128,
	0xA3BB, 0x212127,
	0xA3BC, 0x212236,
	0xA3BD, 0x212238,
	0xA3BE, 0x212237,
	0xA3BF, 0x212129,
	0xA3C0, 0x212269,
	0xA3C1, 0x212441,
	0xA3C2, 0x212442,
	0xA3C3, 0x212443,
	0xA3C4, 0x212444,
	0xA3C5, 0x212445,
	0xA3C6, 0x212446,
	0xA3C7, 0x212447,
	0xA3C8, 0x212448,
	0xA3C9, 0x212449,
	0xA3CA, 0x21244A,
	0xA3CB, 0x21244B,
	0xA3CC, 0x21244C,
	0xA3CD, 0x21244D,
	0xA3CE, 0x21244E,
	0xA3CF, 0x21244F,
	0xA3D0, 0x212450,
	0xA3D1, 0x212451,
	0xA3D2, 0x212452,
	0xA3D3, 0x212453,
	0xA3D4, 0x212454,
	0xA3D5, 0x212455,
	0xA3D6, 0x212456,
	0xA3D7, 0x212457,
	0xA3D8, 0x212458,
	0xA3D9, 0x212459,
	0xA3DA, 0x21245A,
	0xA3DB, 0x212162,
	0xA3DC, 0x212260,
	0xA3DD, 0x212163,
	0xA3DE, 0x212154,
	0xA3DF, 0x212225,
	0xA3E0, 0x21216A,
	0xA3E1, 0x21245B,
	0xA3E2, 0x21245C,
	0xA3E3, 0x21245D,
	0xA3E4, 0x21245E,
	0xA3E5, 0x21245F,
	0xA3E6, 0x212460,
	0xA3E7, 0x212461,
	0xA3E8, 0x212462,
	0xA3E9, 0x212463,
	0xA3EA, 0x212464,
	0xA3EB, 0x212465,
	0xA3EC, 0x212466,
	0xA3ED, 0x212467,
	0xA3EE, 0x212468,
	0xA3EF, 0x212469,
	0xA3F0, 0x21246A,
	0xA3F1, 0x21246B,
	0xA3F2, 0x21246C,
	0xA3F3, 0x21246D,
	0xA3F4, 0x21246E,
	0xA3F5, 0x21246F,
	0xA3F6, 0x212470,
	0xA3F7, 0x212471,
	0xA3F8, 0x212472,
	0xA3F9, 0x212473,
	0xA3FA, 0x212474,
	0xA3FB, 0x212142,
	0xA3FC, 0x212136,
	0xA3FD, 0x212143,
	0xA3FE, 0x212223,
	0xA6A1, 0x212475,
	0xA6A2, 0x212476,
	0xA6A3, 0x212477,
	0xA6A4, 0x212478,
	0xA6A5, 0x212479,
	0xA6A6, 0x21247A,
	0xA6A7, 0x21247B,
	0xA6A8, 0x21247C,
	0xA6A9, 0x21247D,
	0xA6AA, 0x21247E,
	0xA6AB, 0x212521,
	0xA6AC, 0x212522,
	0xA6AD, 0x212523,
	0xA6AE, 0x212524,
	0xA6AF, 0x212525,
	0xA6B0, 0x212526,
	0xA6B1, 0x212527,
	0xA6B2, 0x212528,
	0xA6B3, 0x212529,
	0xA6B4, 0x21252A,
	0xA6B5, 0x21252B,
	0xA6B6, 0x21252C,
	0xA6B7, 0x21252D,
	0xA6B8, 0x21252E,
	0xA6C1, 0x21252F,
	0xA6C2, 0x212530,
	0xA6C3, 0x212531,
	0xA6C4, 0x212532,
	0xA6C5, 0x212533,
	0xA6C6, 0x212534,
	0xA6C7, 0x212535,
	0xA6C8, 0x212536,
	0xA6C9, 0x212537,
	0xA6CA, 0x212538,
	0xA6CB, 0x212539,
	0xA6CC, 0x21253A,
	0xA6CD, 0x21253B,
	0xA6CE, 0x21253C,
	0xA6CF, 0x21253D,
	0xA6D0, 0x21253E,
	0xA6D1, 0x21253F,
	0xA6D2, 0x212540,
	0xA6D3, 0x212541,
	0xA6D4, 0x212542,
	0xA6D5, 0x212543,
	0xA6D6, 0x212544,
	0xA6D7, 0x212545,
	0xA6D8, 0x212546,
	0xA8C5, 0x212547,
	0xA8C6, 0x212548,
	0xA8C7, 0x212549,
	0xA8C8, 0x21254A,
	0xA8C9, 0x21254B,
	0xA8CA, 0x21254C,
	0xA8CB, 0x21254D,
	0xA8CC, 0x21254E,
	0xA8CD, 0x21254F,
	0xA8CE, 0x212550,
	0xA8CF, 0x212551,
	0xA8D0, 0x212552,
	0xA8D1, 0x212553,
	0xA8D2, 0x212554,
	0xA8D3, 0x212555,
	0xA8D4, 0x212556,
	0xA8D5, 0x212557,
	0xA8D6, 0x212558,
	0xA8D7, 0x212559,
	0xA8D8, 0x21255A,
	0xA8D9, 0x21255B,
	0xA8DA, 0x21255C,
	0xA8DB, 0x21255D,
	0xA8DC, 0x21255E,
	0xA8DD, 0x21255F,
	0xA8DE, 0x212560,
	0xA8DF, 0x212561,
	0xA8E0, 0x212562,
	0xA8E1, 0x212563,
	0xA8E2, 0x212564,
	0xA8E3, 0x212565,
	0xA8E4, 0x212566,
	0xA8E5, 0x212567,
	0xA8E6, 0x212568,
	0xA8E7, 0x212569,
	0xA8E8, 0x21256A,
	0xA8E9, 0x21256B,
	0xA9A4, 0x212339,
	0xA9A6, 0x21233A,
	0xA9B0, 0x21233C,
	0xA9B4, 0x21233D,
	0xA9B8, 0x21233E,
	0xA9BC, 0x21233F,
	0xA9C0, 0x212337,
	0xA9C8, 0x212336,
	0xA9D0, 0x212335,
	0xA9D8, 0x212334,
	0xA9E0, 0x212333,
	0xB0A1, 0x21593F,
	0xB0A2, 0x214F5F,
	0xB0A3, 0x21546C,
	0xB0A4, 0x215563,
	0xB0A5, 0x215039,
	0xB0A6, 0x21545F,
	0xB0A7, 0x215037,
	0xB0A8, 0x216D73,
	0xB0A9, 0x217444,
	0xB0AA, 0x217A32,
	0xB0AB, 0x21654E,
	0xB0AC, 0x214864,
	0xB0AD, 0x217855,
	0xB0AE, 0x216378,
	0xB0AF, 0x216751,
	0xB0B0, 0x216F6B,
	0xB0B1, 0x215636,
	0xB0B2, 0x214778,
	0xB0B3, 0x215430,
	0xB0B4, 0x21513A,
	0xB0B5, 0x21643C,
	0xB0B6, 0x214D26,
	0xB0B7, 0x22322D,
	0xB0B8, 0x215579,
	0xB0B9, 0x216B73,
	0xB0BA, 0x214D7B,
	0xB0BB, 0x215676,
	0xB0BC, 0x214577,
	0xB0BD, 0x215A72,
	0xB0BE, 0x216D5F,
	0xB0BF, 0x217174,
	0xB0C0, 0x217878,
	0xB0C1, 0x21632D,
	0xB0C2, 0x21635F,
	0xB0C3, 0x21705B,
	0xB0C4, 0x21712E,
	0xB0C5, 0x214F40,
	0xB0C6, 0x215565,
	0xB0C7, 0x214656,
	0xB0C8, 0x21463C,
	0xB0C9, 0x214943,
	0xB0CA, 0x21573C,
	0xB0CB, 0x21442C,
	0xB0CC, 0x215250,
	0xB0CD, 0x21453B,
	0xB0CE, 0x214D60,
	0xB0CF, 0x216242,
	0xB0D0, 0x21675E,
	0xB0D1, 0x214A44,
	0xB0D2, 0x215756,
	0xB0D3, 0x217C5E,
	0xB0D4, 0x217B3D,
	0xB0D5, 0x216E48,
	0xB0D6, 0x214E69,
	0xB0D7, 0x214675,
	0xB0D8, 0x215169,
	0xB0D9, 0x21484B,
	0xB0DA, 0x217648,
	0xB0DB, 0x214B76,
	0xB0DC, 0x215A75,
	0xB0DD, 0x215138,
	0xB0DE, 0x224561,
	0xB0DF, 0x215F58,
	0xB0E0, 0x21565D,
	0xB0E1, 0x216430,
	0xB0E2, 0x214A48,
	0xB0E3, 0x21576F,
	0xB0E4, 0x216763,
	0xB0E5, 0x214E32,
	0xB0E6, 0x214E6A,
	0xB0E7, 0x214A4C,
	0xB0E8, 0x214D57,
	0xB0E9, 0x214872,
	0xB0EA, 0x21784F,
	0xB0EB, 0x214624,
	0xB0EC, 0x217256,
	0xB0ED, 0x215C51,
	0xB0EE, 0x214B5A,
	0xB0EF, 0x217359,
	0xB0F0, 0x215B3B,
	0xB0F1, 0x216926,
	0xB0F2, 0x216A50,
	0xB0F3, 0x216571,
	0xB0F4, 0x215F73,
	0xB0F5, 0x216D7C,
	0xB0F6, 0x21582B,
	0xB0F7, 0x217754,
	0xB0F8, 0x215E2A,
	0xB0F9, 0x217548,
	0xB0FA, 0x215346,
	0xB0FB, 0x215330,
	0xB0FC, 0x21457D,
	0xB0FD, 0x216E70,
	0xB0FE, 0x21544C,
	0xB1A1, 0x21752B,
	0xB1A2, 0x21675A,
	0xB1A3, 0x214F71,
	0xB1A4, 0x215E5F,
	0xB1A5, 0x216767,
	0xB1A6, 0x21796A,
	0xB1A7, 0x214D6C,
	0xB1A8, 0x215E5E,
	0xB1A9, 0x216D33,
	0xB1AA, 0x215841,
	0xB1AB, 0x217335,
	0xB1AC, 0x217847,
	0xB1AD, 0x214E30,
	0xB1AE, 0x216556,
	0xB1AF, 0x215F2B,
	0xB1B0, 0x214C38,
	0xB1B1, 0x214621,
	0xB1B2, 0x216F45,
	0xB1B3, 0x21532C,
	0xB1B4, 0x214B4A,
	0xB1B5, 0x216F61,
	0xB1B6, 0x215422,
	0xB1B7, 0x215659,
	0xB1B8, 0x215E2C,
	0xB1B9, 0x217057,
	0xB1BA, 0x21604E,
	0xB1BB, 0x215D37,
	0xB1BC, 0x214C64,
	0xB1BD, 0x215349,
	0xB1BE, 0x21465B,
	0xB1BF, 0x215C47,
	0xB1C0, 0x21597D,
	0xB1C1, 0x217468,
	0xB1C2, 0x21524A,
	0xB1C3, 0x215229,
	0xB1C4, 0x217746,
	0xB1C5, 0x215853,
	0xB1C6, 0x21672F,
	0xB1C7, 0x216B7C,
	0xB1C8, 0x214552,
	0xB1C9, 0x216B48,
	0xB1CA, 0x21612D,
	0xB1CB, 0x214D3E,
	0xB1CC, 0x216978,
	0xB1CD, 0x224D50,
	0xB1CE, 0x216E53,
	0xB1CF, 0x215C2B,
	0xB1D0, 0x21736E,
	0xB1D1, 0x222B4A,
	0xB1D2, 0x21685C,
	0xB1D3, 0x214A2A,
	0xB1D4, 0x21653C,
	0xB1D5, 0x215D70,
	0xB1D6, 0x215A71,
	0xB1D7, 0x216862,
	0xB1D8, 0x214652,
	0xB1D9, 0x216728,
	0xB1DA, 0x217049,
	0xB1DB, 0x217521,
	0xB1DC, 0x217562,
	0xB1DD, 0x215864,
	0xB1DE, 0x21776A,
	0xB1DF, 0x217931,
	0xB1E0, 0x216E3E,
	0xB1E1, 0x21623A,
	0xB1E2, 0x215137,
	0xB1E3, 0x214F6D,
	0xB1E4, 0x217C48,
	0xB1E5, 0x21452C,
	0xB1E6, 0x217255,
	0xB1E7, 0x217B33,
	0xB1E8, 0x217A29,
	0xB1E9, 0x216735,
	0xB1EA, 0x216D3A,
	0xB1EB, 0x215D29,
	0xB1EC, 0x216E51,
	0xB1ED, 0x214F50,
	0xB1EE, 0x217C2A,
	0xB1EF, 0x225041,
	0xB1F0, 0x214931,
	0xB1F1, 0x217852,
	0xB1F2, 0x215A32,
	0xB1F3, 0x223C3E,
	0xB1F4, 0x217845,
	0xB1F5, 0x217423,
	0xB1F6, 0x216B33,
	0xB1F7, 0x225C73,
	0xB1F8, 0x21492E,
	0xB1F9, 0x214743,
	0xB1FA, 0x215163,
	0xB1FB, 0x21455F,
	0xB1FC, 0x214F26,
	0xB1FD, 0x216B6F,
	0xB1FE, 0x215234,
	0xB2A1, 0x215669,
	0xB2A2, 0x214B64,
	0xB2A3, 0x215244,
	0xB2A4, 0x21615A,
	0xB2A5, 0x216D27,
	0xB2A6, 0x216D21,
	0xB2A7, 0x22313F,
	0xB2A8, 0x214E4C,
	0xB2A9, 0x215E3B,
	0xB2AA, 0x21502F,
	0xB2AB, 0x216431,
	0xB2AC, 0x216748,
	0xB2AD, 0x216A2D,
	0xB2AE, 0x214924,
	0xB2AF, 0x214D2F,
	0xB2B0, 0x215C72,
	0xB2B1, 0x215C69,
	0xB2B2, 0x216A53,
	0xB2B3, 0x216038,
	0xB2B4, 0x214E5C,
	0xB2B5, 0x216B72,
	0xB2B6, 0x215559,
	0xB2B7, 0x214433,
	0xB2B8, 0x21545A,
	0xB2B9, 0x216650,
	0xB2BA, 0x215955,
	0xB2BB, 0x214462,
	0xB2BC, 0x21464C,
	0xB2BD, 0x214A63,
	0xB2BE, 0x21785A,
	0xB2BF, 0x215D65,
	0xB2C0, 0x214D48,
	0xB2C1, 0x217368,
	0xB2C2, 0x215B76,
	0xB2C3, 0x21617A,
	0xB2C4, 0x214A59,
	0xB2C5, 0x21445F,
	0xB2C6, 0x215842,
	0xB2C7, 0x216549,
	0xB2C8, 0x216F3D,
	0xB2C9, 0x215A68,
	0xB2CA, 0x215A33,
	0xB2CB, 0x21616C,
	0xB2CC, 0x216E5B,
	0xB2CD, 0x217327,
	0xB2CE, 0x215936,
	0xB2CF, 0x217C66,
	0xB2D0, 0x216024,
	0xB2D1, 0x21686D,
	0xB2D2, 0x21686E,
	0xB2D3, 0x217434,
	0xB2D4, 0x216A69,
	0xB2D5, 0x21717D,
	0xB2D6, 0x21543F,
	0xB2D7, 0x21646F,
	0xB2D8, 0x21772F,
	0xB2D9, 0x217067,
	0xB2DA, 0x217461,
	0xB2DB, 0x216D3B,
	0xB2DC, 0x215B2A,
	0xB2DD, 0x215777,
	0xB2DE, 0x215F21,
	0xB2DF, 0x21612C,
	0xB2E0, 0x215921,
	0xB2E1, 0x214575,
	0xB2E2, 0x216041,
	0xB2E3, 0x216C52,
	0xB2E4, 0x22673B,
	0xB2E5, 0x215F46,
	0xB2E6, 0x214446,
	0xB2E7, 0x223255,
	0xB2E8, 0x21577D,
	0xB2E9, 0x215167,
	0xB2EA, 0x224C35,
	0xB2EB, 0x21642F,
	0xB2EC, 0x216856,
	0xB2ED, 0x214A25,
	0xB2EE, 0x215538,
	0xB2EF, 0x216659,
	0xB2F0, 0x214D70,
	0xB2F1, 0x215627,
	0xB2F2, 0x215840,
	0xB2F3, 0x217970,
	0xB2F4, 0x21687C,
	0xB2F5, 0x217738,
	0xB2F6, 0x217D2E,
	0xB2F7, 0x217C6A,
	0xB2F8, 0x217A7C,
	0xB2F9, 0x217937,
	0xB2FA, 0x215C28,
	0xB2FB, 0x217A4F,
	0xB2FC, 0x217C24,
	0xB2FD, 0x214D79,
	0xB2FE, 0x215B78,
	0xB3A1, 0x215E5B,
	0xB3A2, 0x216829,
	0xB3A3, 0x215A26,
	0xB3A4, 0x214F5B,
	0xB3A5, 0x217341,
	0xB3A6, 0x216623,
	0xB3A7, 0x216C5E,
	0xB3A8, 0x215F54,
	0xB3A9, 0x216923,
	0xB3AA, 0x215940,
	0xB3AB, 0x215435,
	0xB3AC, 0x21623E,
	0xB3AD, 0x214A3D,
	0xB3AE, 0x216259,
	0xB3AF, 0x215F67,
	0xB3B0, 0x216C34,
	0xB3B1, 0x216D53,
	0xB3B2, 0x215A25,
	0xB3B3, 0x214950,
	0xB3B4, 0x214E64,
	0xB3B5, 0x214B4F,
	0xB3B6, 0x214A4A,
	0xB3B7, 0x216874,
	0xB3B8, 0x215F3E,
	0xB3B9, 0x216865,
	0xB3BA, 0x216952,
	0xB3BB, 0x22396E,
	0xB3BC, 0x21485B,
	0xB3BD, 0x214B51,
	0xB3BE, 0x216838,
	0xB3BF, 0x215B27,
	0xB3C0, 0x214A37,
	0xB3C1, 0x214A6A,
	0xB3C2, 0x215D73,
	0xB3C3, 0x21623F,
	0xB3C4, 0x217B72,
	0xB3C5, 0x216C7D,
	0xB3C6, 0x216A22,
	0xB3C7, 0x215052,
	0xB3C8, 0x217076,
	0xB3C9, 0x214829,
	0xB3CA, 0x214947,
	0xB3CB, 0x21537D,
	0xB3CC, 0x216123,
	0xB3CD, 0x217834,
	0xB3CE, 0x216D4B,
	0xB3CF, 0x216662,
	0xB3D0, 0x214D55,
	0xB3D1, 0x215D5E,
	0xB3D2, 0x21762B,
	0xB3D3, 0x215732,
	0xB3D4, 0x21475A,
	0xB3D5, 0x21653E,
	0xB3D6, 0x21513D,
	0xB3D7, 0x215932,
	0xB3D8, 0x214841,
	0xB3D9, 0x21725A,
	0xB3DA, 0x214823,
	0xB3DB, 0x216769,
	0xB3DC, 0x215544,
	0xB3DD, 0x21702F,
	0xB3DE, 0x214B78,
	0xB3DF, 0x214539,
	0xB3E0, 0x214B4B,
	0xB3E1, 0x215750,
	0xB3E2, 0x214658,
	0xB3E3, 0x217135,
	0xB3E4, 0x214572,
	0xB3E5, 0x214A73,
	0xB3E6, 0x214865,
	0xB3E7, 0x215976,
	0xB3E8, 0x217831,
	0xB3E9, 0x214D64,
	0xB3EA, 0x21673B,
	0xB3EB, 0x217850,
	0xB3EC, 0x217B2F,
	0xB3ED, 0x216560,
	0xB3EE, 0x21637A,
	0xB3EF, 0x217A24,
	0xB3F0, 0x214472,
	0xB3F1, 0x216A40,
	0xB3F2, 0x224C2C,
	0xB3F3, 0x21756B,
	0xB3F4, 0x215768,
	0xB3F5, 0x214F4F,
	0xB3F6, 0x214578,
	0xB3F7, 0x21783C,
	0xB3F8, 0x216C5A,
	0xB3F9, 0x217929,
	0xB3FA, 0x216F5C,
	0xB3FB, 0x217765,
	0xB3FC, 0x224437,
	0xB3FD, 0x215866,
	0xB3FE, 0x216447,
	0xB4A1, 0x217670,
	0xB4A2, 0x217343,
	0xB4A3, 0x217C63,
	0xB4A4, 0x224322,
	0xB4A5, 0x217A3D,
	0xB4A6, 0x215D28,
	0xB4A7, 0x215F47,
	0xB4A8, 0x214455,
	0xB4A9, 0x215272,
	0xB4AA, 0x224362,
	0xB4AB, 0x21632E,
	0xB4AC, 0x215C73,
	0xB4AD, 0x215E43,
	0xB4AE, 0x21486B,
	0xB4AF, 0x216D71,
	0xB4B0, 0x216127,
	0xB4B1, 0x216C56,
	0xB4B2, 0x214A2B,
	0xB4B3, 0x21775F,
	0xB4B4, 0x215E36,
	0xB4B5, 0x21494C,
	0xB4B6, 0x214E65,
	0xB4B7, 0x215F4D,
	0xB4B8, 0x217573,
	0xB4B9, 0x21504D,
	0xB4BA, 0x21514E,
	0xB4BB, 0x224355,
	0xB4BC, 0x216F54,
	0xB4BD, 0x215464,
	0xB4BE, 0x215B4A,
	0xB4BF, 0x215745,
	0xB4C0, 0x217B25,
	0xB4C1, 0x217643,
	0xB4C2, 0x216A38,
	0xB4C3, 0x215C30,
	0xB4C4, 0x215823,
	0xB4C5, 0x216976,
	0xB4C6, 0x216B64,
	0xB4C7, 0x217930,
	0xB4C8, 0x216375,
	0xB4C9, 0x215C26,
	0xB4CA, 0x216224,
	0xB4CB, 0x21483A,
	0xB4CC, 0x214C2E,
	0xB4CD, 0x216F32,
	0xB4CE, 0x214839,
	0xB4CF, 0x217479,
	0xB4D0, 0x216E5E,
	0xB4D1, 0x214959,
	0xB4D2, 0x21457E,
	0xB4D3, 0x215A37,
	0xB4D4, 0x21763B,
	0xB4D5, 0x216031,
	0xB4D6, 0x215C4F,
	0xB4D7, 0x216F56,
	0xB4D8, 0x217456,
	0xB4D9, 0x214F72,
	0xB4DA, 0x22713E,
	0xB4DB, 0x217163,
	0xB4DC, 0x217675,
	0xB4DD, 0x216879,
	0xB4DE, 0x21597E,
	0xB4DF, 0x216331,
	0xB4E0, 0x215760,
	0xB4E1, 0x216539,
	0xB4E2, 0x216A32,
	0xB4E3, 0x215B6B,
	0xB4E4, 0x216A49,
	0xB4E5, 0x214A5A,
	0xB4E6, 0x214774,
	0xB4E7, 0x214450,
	0xB4E8, 0x216D7B,
	0xB4E9, 0x216D26,
	0xB4EA, 0x21642A,
	0xB4EB, 0x215A5D,
	0xB4EC, 0x215562,
	0xB4ED, 0x217263,
	0xB4EE, 0x21642E,
	0xB4EF, 0x21672E,
	0xB4F0, 0x216130,
	0xB4F1, 0x216D6D,
	0xB4F2, 0x214654,
	0xB4F3, 0x21444B,
	0xB4F4, 0x214944,
	0xB4F5, 0x214550,
	0xB4F6, 0x223A3A,
	0xB4F7, 0x217362,
	0xB4F8, 0x215A27,
	0xB4F9, 0x215173,
	0xB4FA, 0x21456E,
	0xB4FB, 0x21623C,
	0xB4FC, 0x215D3B,
	0xB4FD, 0x215121,
	0xB4FE, 0x21624C,
	0xB5A1, 0x215129,
	0xB5A2, 0x215758,
	0xB5A3, 0x21706A,
	0xB5A4, 0x214465,
	0xB5A5, 0x215E4C,
	0xB5A6, 0x225522,
	0xB5A7, 0x22505F,
	0xB5A8, 0x217524,
	0xB5A9, 0x214659,
	0xB5AA, 0x216028,
	0xB5AB, 0x21487E,
	0xB5AC, 0x216C72,
	0xB5AD, 0x215B4D,
	0xB5AE, 0x216E78,
	0xB5AF, 0x216C5F,
	0xB5B0, 0x215D30,
	0xB5B1, 0x216535,
	0xB5B2, 0x217060,
	0xB5B3, 0x217A5D,
	0xB5B4, 0x217445,
	0xB5B5, 0x217372,
	0xB5B6, 0x21442E,
	0xB5B7, 0x216437,
	0xB5B8, 0x21755B,
	0xB5B9, 0x21542E,
	0xB5BA, 0x215535,
	0xB5BB, 0x217856,
	0xB5BC, 0x217052,
	0xB5BD, 0x214C2F,
	0xB5BE, 0x216E2A,
	0xB5BF, 0x215A49,
	0xB5C0, 0x21672C,
	0xB5C1, 0x216079,
	0xB5C2, 0x216C61,
	0xB5C3, 0x215A35,
	0xB5C4, 0x214E7B,
	0xB5C5, 0x21792B,
	0xB5C6, 0x217139,
	0xB5C7, 0x216074,
	0xB5C8, 0x21612B,
	0xB5C9, 0x217447,
	0xB5CA, 0x216821,
	0xB5CB, 0x216F52,
	0xB5CC, 0x215E5C,
	0xB5CD, 0x214925,
	0xB5CE, 0x216940,
	0xB5CF, 0x215360,
	0xB5D0, 0x216D2E,
	0xB5D1, 0x215C48,
	0xB5D2, 0x214B29,
	0xB5D3, 0x216957,
	0xB5D4, 0x216A4B,
	0xB5D5, 0x216846,
	0xB5D6, 0x214D6A,
	0xB5D7, 0x214D35,
	0xB5D8, 0x214762,
	0xB5D9, 0x21662D,
	0xB5DA, 0x215C49,
	0xB5DB, 0x215074,
	0xB5DC, 0x214A2E,
	0xB5DD, 0x216B44,
	0xB5DE, 0x216E37,
	0xB5DF, 0x21794D,
	0xB5E0, 0x22354D,
	0xB5E1, 0x216465,
	0xB5E2, 0x216552,
	0xB5E3, 0x217635,
	0xB5E4, 0x214C28,
	0xB5E5, 0x21727A,
	0xB5E6, 0x21683C,
	0xB5E7, 0x216759,
	0xB5E8, 0x21487B,
	0xB5E9, 0x214B2F,
	0xB5EA, 0x214D33,
	0xB5EB, 0x215A43,
	0xB5EC, 0x215E64,
	0xB5ED, 0x217128,
	0xB5EE, 0x21645B,
	0xB5EF, 0x216554,
	0xB5F0, 0x214632,
	0xB5F1, 0x217273,
	0xB5F2, 0x215447,
	0xB5F3, 0x21442F,
	0xB5F4, 0x215A60,
	0xB5F5, 0x214752,
	0xB5F6, 0x215D6C,
	0xB5F7, 0x216E7E,
	0xB5F8, 0x216245,
	0xB5F9, 0x215655,
	0xB5FA, 0x216977,
	0xB5FB, 0x216E63,
	0xB5FC, 0x215362,
	0xB5FD, 0x21723C,
	0xB5FE, 0x217B68,
	0xB6A1, 0x214423,
	0xB6A2, 0x214B31,
	0xB6A3, 0x21462F,
	0xB6A4, 0x21585B,
	0xB6A5, 0x215E21,
	0xB6A6, 0x21676F,
	0xB6A7, 0x21725F,
	0xB6A8, 0x214C79,
	0xB6A9, 0x215354,
	0xB6AA, 0x214723,
	0xB6AB, 0x214E29,
	0xB6AC, 0x214576,
	0xB6AD, 0x21663A,
	0xB6AE, 0x21735D,
	0xB6AF, 0x21592F,
	0xB6B0, 0x215F6E,
	0xB6B1, 0x22253E,
	0xB6B2, 0x215134,
	0xB6B3, 0x215444,
	0xB6B4, 0x215222,
	0xB6B5, 0x215927,
	0xB6B6, 0x214A3F,
	0xB6B7, 0x21586E,
	0xB6B8, 0x215863,
	0xB6B9, 0x214B48,
	0xB6BA, 0x215D58,
	0xB6BB, 0x216071,
	0xB6BC, 0x215D67,
	0xB6BD, 0x216546,
	0xB6BE, 0x215175,
	0xB6BF, 0x21784A,
	0xB6C0, 0x217141,
	0xB6C1, 0x217B74,
	0xB6C2, 0x215959,
	0xB6C3, 0x216547,
	0xB6C4, 0x216F2F,
	0xB6C5, 0x214A5B,
	0xB6C6, 0x21756C,
	0xB6C7, 0x214B3E,
	0xB6C8, 0x215079,
	0xB6C9, 0x21602E,
	0xB6CA, 0x21496A,
	0xB6CB, 0x216A26,
	0xB6CC, 0x21607B,
	0xB6CD, 0x217576,
	0xB6CE, 0x215174,
	0xB6CF, 0x21764B,
	0xB6D0, 0x216E41,
	0xB6D1, 0x215954,
	0xB6D2, 0x21492B,
	0xB6D3, 0x216269,
	0xB6D4, 0x216857,
	0xB6D5, 0x216C45,
	0xB6D6, 0x217040,
	0xB6D7, 0x217928,
	0xB6D8, 0x215F55,
	0xB6D9, 0x216761,
	0xB6DA, 0x21495B,
	0xB6DB, 0x21625E,
	0xB6DC, 0x215261,
	0xB6DD, 0x216738,
	0xB6DE, 0x223557,
	0xB6DF, 0x222948,
	0xB6E0, 0x214769,
	0xB6E1, 0x216844,
	0xB6E2, 0x222958,
	0xB6E3, 0x216723,
	0xB6E4, 0x214838,
	0xB6E5, 0x21667D,
	0xB6E6, 0x215C70,
	0xB6E7, 0x214C32,
	0xB6E8, 0x215F32,
	0xB6E9, 0x216C44,
	0xB6EA, 0x216646,
	0xB6EB, 0x215533,
	0xB6EC, 0x217826,
	0xB6ED, 0x214F7A,
	0xB6EE, 0x21776C,
	0xB6EF, 0x215D45,
	0xB6F0, 0x21547C,
	0xB6F1, 0x215F2A,
	0xB6F2, 0x21452D,
	0xB6F3, 0x214A45,
	0xB6F4, 0x216733,
	0xB6F5, 0x216252,
	0xB6F6, 0x216F73,
	0xB6F7, 0x215548,
	0xB6F8, 0x214854,
	0xB6F9, 0x214C23,
	0xB6FA, 0x214856,
	0xB6FB, 0x21695F,
	0xB6FC, 0x216B70,
	0xB6FD, 0x215221,
	0xB6FE, 0x214428,
	0xB7A1, 0x216233,
	0xB7A2, 0x216075,
	0xB7A3, 0x216A48,
	0xB7A4, 0x216133,
	0xB7A5, 0x214731,
	0xB7A6, 0x214566,
	0xB7A7, 0x216B5F,
	0xB7A8, 0x214E4E,
	0xB7A9, 0x21605D,
	0xB7AA, 0x21786A,
	0xB7AB, 0x21477D,
	0xB7AC, 0x21606C,
	0xB7AD, 0x217729,
	0xB7AE, 0x216D3E,
	0xB7AF, 0x21797E,
	0xB7B0, 0x215D6F,
	0xB7B1, 0x21746D,
	0xB7B2, 0x21443B,
	0xB7B3, 0x216476,
	0xB7B4, 0x214530,
	0xB7B5, 0x214F53,
	0xB7B6, 0x215336,
	0xB7B7, 0x215D49,
	0xB7B8, 0x214667,
	0xB7B9, 0x216321,
	0xB7BA, 0x214E5B,
	0xB7BB, 0x21495D,
	0xB7BC, 0x214F3D,
	0xB7BD, 0x214549,
	0xB7BE, 0x214F38,
	0xB7BF, 0x214D52,
	0xB7C0, 0x214B5F,
	0xB7C1, 0x21496B,
	0xB7C2, 0x21472B,
	0xB7C3, 0x215D3E,
	0xB7C4, 0x21573F,
	0xB7C5, 0x214D73,
	0xB7C6, 0x216167,
	0xB7C7, 0x214F66,
	0xB7C8, 0x21593D,
	0xB7C9, 0x215379,
	0xB7CA, 0x214F31,
	0xB7CB, 0x21544D,
	0xB7CC, 0x216F25,
	0xB7CD, 0x214952,
	0xB7CE, 0x214F30,
	0xB7CF, 0x216C59,
	0xB7D0, 0x214E50,
	0xB7D1, 0x216236,
	0xB7D2, 0x214F45,
	0xB7D3, 0x223977,
	0xB7D4, 0x21494A,
	0xB7D5, 0x214E41,
	0xB7D6, 0x214521,
	0xB7D7, 0x21574C,
	0xB7D8, 0x216C42,
	0xB7D9, 0x21604F,
	0xB7DA, 0x214A78,
	0xB7DB, 0x21573E,
	0xB7DC, 0x21704D,
	0xB7DD, 0x214739,
	0xB7DE, 0x214D43,
	0xB7DF, 0x216C73,
	0xB7E0, 0x21745E,
	0xB7E1, 0x217742,
	0xB7E2, 0x21506C,
	0xB7E3, 0x216452,
	0xB7E4, 0x216648,
	0xB7E5, 0x215534,
	0xB7E6, 0x216F60,
	0xB7E7, 0x215378,
	0xB7E8, 0x21696D,
	0xB7E9, 0x215B71,
	0xB7EA, 0x215D61,
	0xB7EB, 0x216325,
	0xB7EC, 0x217469,
	0xB7ED, 0x217242,
	0xB7EE, 0x214C60,
	0xB7EF, 0x216B7A,
	0xB7F0, 0x214873,
	0xB7F1, 0x214941,
	0xB7F2, 0x214533,
	0xB7F3, 0x216D2F,
	0xB7F4, 0x216E50,
	0xB7F5, 0x21684D,
	0xB7F6, 0x214A41,
	0xB7F7, 0x214D5A,
	0xB7F8, 0x217251,
	0xB7F9, 0x215E79,
	0xB7FA, 0x215177,
	0xB7FB, 0x215C4A,
	0xB7FC, 0x214733,
	0xB7FD, 0x214F74,
	0xB7FE, 0x214E24,
	0xB8A1, 0x215645,
	0xB8A2, 0x215B6A,
	0xB8A3, 0x21697D,
	0xB8A4, 0x21617C,
	0xB8A5, 0x214651,
	0xB8A6, 0x214B2D,
	0xB8A7, 0x216D28,
	0xB8A8, 0x216B3A,
	0xB8A9, 0x215424,
	0xB8AA, 0x21585E,
	0xB8AB, 0x214D74,
	0xB8AC, 0x215C68,
	0xB8AD, 0x21614C,
	0xB8AE, 0x214D34,
	0xB8AF, 0x216A4F,
	0xB8B0, 0x215358,
	0xB8B1, 0x21592B,
	0xB8B2, 0x21773B,
	0xB8B3, 0x216F2C,
	0xB8B4, 0x215F26,
	0xB8B5, 0x215E2B,
	0xB8B6, 0x214569,
	0xB8B7, 0x214F5D,
	0xB8B8, 0x214558,
	0xB8B9, 0x216628,
	0xB8BA, 0x215357,
	0xB8BB, 0x215E6E,
	0xB8BC, 0x215355,
	0xB8BD, 0x214F61,
	0xB8BE, 0x215961,
	0xB8BF, 0x21716B,
	0xB8C0, 0x214C4C,
	0xB8C1, 0x217048,
	0xB8C2, 0x21682F,
	0xB8C3, 0x21665A,
	0xB8C4, 0x214A51,
	0xB8C5, 0x21644D,
	0xB8C6, 0x21625B,
	0xB8C7, 0x216A64,
	0xB8C8, 0x216046,
	0xB8C9, 0x21636C,
	0xB8CA, 0x21466C,
	0xB8CB, 0x215B32,
	0xB8CC, 0x215164,
	0xB8CD, 0x215274,
	0xB8CE, 0x214B3B,
	0xB8CF, 0x216B38,
	0xB8D0, 0x216376,
	0xB8D1, 0x216122,
	0xB8D2, 0x215F56,
	0xB8D3, 0x217C6D,
	0xB8D4, 0x214D25,
	0xB8D5, 0x21544B,
	0xB8D6, 0x217265,
	0xB8D7, 0x21527E,
	0xB8D8, 0x214B3D,
	0xB8D9, 0x216A3E,
	0xB8DA, 0x215A24,
	0xB8DB, 0x21602B,
	0xB8DC, 0x21692B,
	0xB8DD, 0x21715E,
	0xB8DE, 0x215672,
	0xB8DF, 0x21586D,
	0xB8E0, 0x216A51,
	0xB8E1, 0x21574F,
	0xB8E2, 0x217166,
	0xB8E3, 0x21642C,
	0xB8E4, 0x217759,
	0xB8E5, 0x216E25,
	0xB8E6, 0x21494B,
	0xB8E7, 0x215457,
	0xB8E8, 0x21693A,
	0xB8E9, 0x21736A,
	0xB8EA, 0x214541,
	0xB8EB, 0x217632,
	0xB8EC, 0x215762,
	0xB8ED, 0x214E79,
	0xB8EE, 0x215E34,
	0xB8EF, 0x215373,
	0xB8F0, 0x216636,
	0xB8F1, 0x21562A,
	0xB8F2, 0x216176,
	0xB8F3, 0x216B5E,
	0xB8F4, 0x216752,
	0xB8F5, 0x216B55,
	0xB8F6, 0x215436,
	0xB8F7, 0x214756,
	0xB8F8, 0x21613F,
	0xB8F9, 0x21557C,
	0xB8FA, 0x216679,
	0xB8FB, 0x215755,
	0xB8FC, 0x214A55,
	0xB8FD, 0x214D32,
	0xB8FE, 0x217867,
	0xB9A1, 0x215469,
	0xB9A2, 0x215759,
	0xB9A3, 0x215B36,
	0xB9A4, 0x214456,
	0xB9A5, 0x214A52,
	0xB9A6, 0x21457C,
	0xB9A7, 0x215547,
	0xB9A8, 0x217C33,
	0xB9A9, 0x214B72,
	0xB9AA, 0x215845,
	0xB9AB, 0x21447C,
	0xB9AC, 0x215527,
	0xB9AD, 0x21445E,
	0xB9AE, 0x216F6D,
	0xB9AF, 0x214A66,
	0xB9B0, 0x215141,
	0xB9B1, 0x215843,
	0xB9B2, 0x214741,
	0xB9B3, 0x216747,
	0xB9B4, 0x214525,
	0xB9B5, 0x216464,
	0xB9B6, 0x215348,
	0xB9B7, 0x214E70,
	0xB9B8, 0x215051,
	0xB9B9, 0x21692C,
	0xB9BA, 0x217555,
	0xB9BB, 0x21595C,
	0xB9BC, 0x21624B,
	0xB9BD, 0x223F66,
	0xB9BE, 0x214C44,
	0xB9BF, 0x224C5B,
	0xB9C0, 0x214875,
	0xB9C1, 0x214E49,
	0xB9C2, 0x214C76,
	0xB9C3, 0x214C6A,
	0xB9C4, 0x216770,
	0xB9C5, 0x21462C,
	0xB9C6, 0x217C47,
	0xB9C7, 0x21586C,
	0xB9C8, 0x214B47,
	0xB9C9, 0x214F34,
	0xB9CA, 0x21514A,
	0xB9CB, 0x217B41,
	0xB9CC, 0x214C56,
	0xB9CD, 0x216276,
	0xB9CE, 0x214C30,
	0xB9CF, 0x21466A,
	0xB9D0, 0x22336F,
	0xB9D1, 0x216850,
	0xB9D2, 0x215A62,
	0xB9D3, 0x216A77,
	0xB9D4, 0x214B65,
	0xB9D5, 0x214D66,
	0xB9D6, 0x214D49,
	0xB9D7, 0x215F68,
	0xB9D8, 0x217943,
	0xB9D9, 0x214C7A,
	0xB9DA, 0x215025,
	0xB9DB, 0x217D28,
	0xB9DC, 0x216A27,
	0xB9DD, 0x217328,
	0xB9DE, 0x217C64,
	0xB9DF, 0x21686B,
	0xB9E0, 0x217A74,
	0xB9E1, 0x215D4B,
	0xB9E2, 0x21473C,
	0xB9E3, 0x216C5D,
	0xB9E4, 0x215D63,
	0xB9E5, 0x216967,
	0xB9E6, 0x215D3D,
	0xB9E7, 0x214764,
	0xB9E8, 0x22375D,
	0xB9E9, 0x217657,
	0xB9EA, 0x21733F,
	0xB9EB, 0x216B5C,
	0xB9EC, 0x21535C,
	0xB9ED, 0x215870,
	0xB9EE, 0x216665,
	0xB9EF, 0x215254,
	0xB9F0, 0x21557D,
	0xB9F1, 0x217650,
	0xB9F2, 0x21667E,
	0xB9F3, 0x216238,
	0xB9F4, 0x216C2E,
	0xB9F5, 0x216F4A,
	0xB9F6, 0x21693E,
	0xB9F7, 0x215F77,
	0xB9F8, 0x217572,
	0xB9F9, 0x215D66,
	0xB9FA, 0x21594F,
	0xB9FB, 0x214E2A,
	0xB9FC, 0x216A79,
	0xB9FD, 0x216734,
	0xB9FE, 0x215044,
	0xBAA1, 0x217330,
	0xBAA2, 0x215066,
	0xBAA3, 0x215640,
	0xBAA4, 0x215637,
	0xBAA5, 0x21472A,
	0xBAA6, 0x215524,
	0xBAA7, 0x21732D,
	0xBAA8, 0x216256,
	0xBAA9, 0x225724,
	0xBAAA, 0x222875,
	0xBAAB, 0x217627,
	0xBAAC, 0x214956,
	0xBAAD, 0x215B60,
	0xBAAE, 0x215E6D,
	0xBAAF, 0x214C2A,
	0xBAB0, 0x215E41,
	0xBAB1, 0x214B38,
	0xBAB2, 0x217173,
	0xBAB3, 0x217062,
	0xBAB4, 0x215564,
	0xBAB5, 0x214A54,
	0xBAB6, 0x21705A,
	0xBAB7, 0x21554D,
	0xBAB8, 0x215B70,
	0xBAB9, 0x21483E,
	0xBABA, 0x216947,
	0xBABB, 0x222152,
	0xBABC, 0x214E26,
	0xBABD, 0x21576C,
	0xBABE, 0x21734B,
	0xBABF, 0x217345,
	0xBAC0, 0x216B30,
	0xBAC1, 0x215B45,
	0xBAC2, 0x215856,
	0xBAC3, 0x21476F,
	0xBAC4, 0x215757,
	0xBAC5, 0x216640,
	0xBAC6, 0x215648,
	0xBAC7, 0x214C41,
	0xBAC8, 0x215E42,
	0xBAC9, 0x215D23,
	0xBACA, 0x223F42,
	0xBACB, 0x215578,
	0xBACC, 0x21467D,
	0xBACD, 0x214C4F,
	0xBACE, 0x214874,
	0xBACF, 0x214759,
	0xBAD0, 0x215C35,
	0xBAD1, 0x21666F,
	0xBAD2, 0x216B5B,
	0xBAD3, 0x214E48,
	0xBAD4, 0x215B5A,
	0xBAD5, 0x216B36,
	0xBAD6, 0x216E6E,
	0xBAD7, 0x217B4E,
	0xBAD8, 0x216237,
	0xBAD9, 0x216C35,
	0xBADA, 0x216329,
	0xBADB, 0x215C2F,
	0xBADC, 0x21507E,
	0xBADD, 0x215240,
	0xBADE, 0x21512F,
	0xBADF, 0x215456,
	0xBAE0, 0x21486C,
	0xBAE1, 0x217077,
	0xBAE2, 0x21722F,
	0xBAE3, 0x215131,
	0xBAE4, 0x217B32,
	0xBAE5, 0x215043,
	0xBAE6, 0x215650,
	0xBAE7, 0x21534C,
	0xBAE8, 0x217631,
	0xBAE9, 0x21517B,
	0xBAEA, 0x21497B,
	0xBAEB, 0x214650,
	0xBAEC, 0x215278,
	0xBAED, 0x215E55,
	0xBAEE, 0x214F6C,
	0xBAEF, 0x21605B,
	0xBAF0, 0x214953,
	0xBAF1, 0x215034,
	0xBAF2, 0x215437,
	0xBAF3, 0x215125,
	0xBAF4, 0x214C4B,
	0xBAF5, 0x214567,
	0xBAF6, 0x214D41,
	0xBAF7, 0x21652C,
	0xBAF8, 0x215E63,
	0xBAF9, 0x216633,
	0xBAFA, 0x21532D,
	0xBAFB, 0x216E62,
	0xBAFC, 0x214E71,
	0xBAFD, 0x216E36,
	0xBAFE, 0x216039,
	0xBBA1, 0x214D39,
	0xBBA2, 0x214F4D,
	0xBBA3, 0x215949,
	0xBBA4, 0x217B2C,
	0xBBA5, 0x21446B,
	0xBBA6, 0x216954,
	0xBBA7, 0x214542,
	0xBBA8, 0x214F44,
	0xBBA9, 0x216C37,
	0xBBAA, 0x21615E,
	0xBBAB, 0x21652A,
	0xBBAC, 0x21646C,
	0xBBAD, 0x21606B,
	0xBBAE, 0x216822,
	0xBBAF, 0x214527,
	0xBBB0, 0x216663,
	0xBBB1, 0x216932,
	0xBBB2, 0x215122,
	0xBBB3, 0x217835,
	0xBBB4, 0x215B66,
	0xBBB5, 0x21782E,
	0xBBB6, 0x217B63,
	0xBBB7, 0x21743F,
	0xBBB8, 0x21557B,
	0xBBB9, 0x217564,
	0xBBBA, 0x216E42,
	0xBBBB, 0x215F50,
	0xBBBC, 0x215A3D,
	0xBBBD, 0x215E50,
	0xBBBE, 0x21696F,
	0xBBBF, 0x21666D,
	0xBBC0, 0x21647E,
	0xBBC1, 0x216047,
	0xBBC2, 0x215068,
	0xBBC3, 0x21453C,
	0xBBC4, 0x215772,
	0xBBC5, 0x21637D,
	0xBBC6, 0x216327,
	0xBBC7, 0x21744E,
	0xBBC8, 0x216E69,
	0xBBC9, 0x217678,
	0xBBCA, 0x215256,
	0xBBCB, 0x215929,
	0xBBCC, 0x215F38,
	0xBBCD, 0x21647D,
	0xBBCE, 0x21556E,
	0xBBCF, 0x21636B,
	0xBBD0, 0x21512D,
	0xBBD1, 0x21754B,
	0xBBD2, 0x214848,
	0xBBD3, 0x215F4C,
	0xBBD4, 0x216F42,
	0xBBD5, 0x21735B,
	0xBBD6, 0x215130,
	0xBBD7, 0x216174,
	0xBBD8, 0x21475F,
	0xBBD9, 0x21645A,
	0xBBDA, 0x21554E,
	0xBBDB, 0x216C64,
	0xBBDC, 0x214625,
	0xBBDD, 0x215F2D,
	0xBBDE, 0x215B28,
	0xBBDF, 0x216673,
	0xBBE0, 0x217673,
	0xBBE1, 0x216444,
	0xBBE2, 0x217438,
	0xBBE3, 0x21633E,
	0xBBE4, 0x21723A,
	0xBBE5, 0x216B2B,
	0xBBE6, 0x217863,
	0xBBE7, 0x21662E,
	0xBBE8, 0x214D7E,
	0xBBE9, 0x215966,
	0xBBEA, 0x216B77,
	0xBBEB, 0x216044,
	0xBBEC, 0x215B5B,
	0xBBED, 0x217550,
	0xBBEE, 0x215224,
	0xBBEF, 0x21472D,
	0xBBF0, 0x214556,
	0xBBF1, 0x21743D,
	0xBBF2, 0x214D50,
	0xBBF3, 0x215F29,
	0xBBF4, 0x217277,
	0xBBF5, 0x215D4C,
	0xBBF6, 0x21697E,
	0xBBF7, 0x217364,
	0xBBF8, 0x214963,
	0xBBF9, 0x215957,
	0xBBFA, 0x217122,
	0xBBFB, 0x216536,
	0xBBFC, 0x216E28,
	0xBBFD, 0x217158,
	0xBBFE, 0x216A28,
	0xBCA1, 0x21485A,
	0xBCA2, 0x21586A,
	0xBCA3, 0x216678,
	0xBCA4, 0x21712F,
	0xBCA5, 0x217922,
	0xBCA6, 0x217766,
	0xBCA7, 0x215478,
	0xBCA8, 0x217464,
	0xBCA9, 0x216E3D,
	0xBCAA, 0x21474F,
	0xBCAB, 0x21644B,
	0xBCAC, 0x215F6B,
	0xBCAD, 0x217252,
	0xBCAE, 0x217A26,
	0xBCAF, 0x216275,
	0xBCB0, 0x21452F,
	0xBCB1, 0x21512A,
	0xBCB2, 0x215668,
	0xBCB3, 0x214A77,
	0xBCB4, 0x21493B,
	0xBCB5, 0x216361,
	0xBCB6, 0x215748,
	0xBCB7, 0x217366,
	0xBCB8, 0x215E7D,
	0xBCB9, 0x215765,
	0xBCBA, 0x214457,
	0xBCBB, 0x217534,
	0xBCBC, 0x214A40,
	0xBCBD, 0x217035,
	0xBCBE, 0x214C77,
	0xBCBF, 0x22216A,
	0xBCC0, 0x215C42,
	0xBCC1, 0x217038,
	0xBCC2, 0x215A4E,
	0xBCC3, 0x217424,
	0xBCC4, 0x21596C,
	0xBCC5, 0x21596D,
	0xBCC6, 0x215353,
	0xBCC7, 0x215834,
	0xBCC8, 0x21514D,
	0xBCC9, 0x214A34,
	0xBCCA, 0x216B63,
	0xBCCB, 0x214972,
	0xBCCC, 0x217A2B,
	0xBCCD, 0x215279,
	0xBCCE, 0x21682D,
	0xBCCF, 0x222B27,
	0xBCD0, 0x214968,
	0xBCD1, 0x214B6F,
	0xBCD2, 0x215525,
	0xBCD3, 0x21457B,
	0xBCD4, 0x215C78,
	0xBCD5, 0x21727E,
	0xBCD6, 0x216672,
	0xBCD7, 0x214672,
	0xBCD8, 0x216743,
	0xBCD9, 0x215875,
	0xBCDA, 0x216E26,
	0xBCDB, 0x216C24,
	0xBCDC, 0x21515E,
	0xBCDD, 0x216F7B,
	0xBCDE, 0x216360,
	0xBCDF, 0x217A73,
	0xBCE0, 0x216971,
	0xBCE1, 0x215952,
	0xBCE2, 0x21477A,
	0xBCE3, 0x216A29,
	0xBCE4, 0x216266,
	0xBCE5, 0x216474,
	0xBCE6, 0x215440,
	0xBCE7, 0x214F36,
	0xBCE8, 0x217529,
	0xBCE9, 0x21476D,
	0xBCEA, 0x216E3B,
	0xBCEB, 0x217860,
	0xBCEC, 0x217374,
	0xBCED, 0x21515D,
	0xBCEE, 0x217C7B,
	0xBCEF, 0x217C7B,
	0xBCF0, 0x215F41,
	0xBCF1, 0x217068,
	0xBCF2, 0x21767C,
	0xBCF3, 0x216C27,
	0xBCF4, 0x21592A,
	0xBCF5, 0x216035,
	0xBCF6, 0x217535,
	0xBCF7, 0x217651,
	0xBCF8, 0x217B7D,
	0xBCF9, 0x216F39,
	0xBCFA, 0x216F2D,
	0xBCFB, 0x214B44,
	0xBCFC, 0x21756F,
	0xBCFD, 0x216E2D,
	0xBCFE, 0x214735,
	0xBDA1, 0x21587A,
	0xBDA2, 0x217A30,
	0xBDA3, 0x216C2D,
	0xBDA4, 0x217329,
	0xBDA5, 0x21694C,
	0xBDA6, 0x21765D,
	0xBDA7, 0x216D58,
	0xBDA8, 0x21507A,
	0xBDA9, 0x216C23,
	0xBDAA, 0x21505A,
	0xBDAB, 0x215972,
	0xBDAC, 0x216D49,
	0xBDAD, 0x214840,
	0xBDAE, 0x217851,
	0xBDAF, 0x216E5A,
	0xBDB0, 0x216D3F,
	0xBDB1, 0x216D64,
	0xBDB2, 0x21754A,
	0xBDB3, 0x21474C,
	0xBDB4, 0x217751,
	0xBDB5, 0x215371,
	0xBDB6, 0x217226,
	0xBDB7, 0x215F79,
	0xBDB8, 0x217451,
	0xBDB9, 0x216050,
	0xBDBA, 0x216E4F,
	0xBDBB, 0x214728,
	0xBDBC, 0x215366,
	0xBDBD, 0x216D4F,
	0xBDBE, 0x217C26,
	0xBDBF, 0x216C4C,
	0xBDC0, 0x217965,
	0xBDC1, 0x217C39,
	0xBDC2, 0x216B4F,
	0xBDC3, 0x21744C,
	0xBDC4, 0x216774,
	0xBDC5, 0x216626,
	0xBDC6, 0x215241,
	0xBDC7, 0x214B45,
	0xBDC8, 0x216B6E,
	0xBDC9, 0x217864,
	0xBDCA, 0x216137,
	0xBDCB, 0x216336,
	0xBDCC, 0x215A74,
	0xBDCD, 0x216B4B,
	0xBDCE, 0x21792F,
	0xBDCF, 0x216724,
	0xBDD0, 0x214635,
	0xBDD1, 0x216128,
	0xBDD2, 0x215F4B,
	0xBDD3, 0x215A59,
	0xBDD4, 0x215255,
	0xBDD5, 0x223768,
	0xBDD6, 0x216179,
	0xBDD7, 0x21626A,
	0xBDD8, 0x216870,
	0xBDD9, 0x214936,
	0xBDDA, 0x216567,
	0xBDDB, 0x21557E,
	0xBDDC, 0x215E2D,
	0xBDDD, 0x215A5A,
	0xBDDE, 0x216543,
	0xBDDF, 0x216A25,
	0xBDE0, 0x216D4E,
	0xBDE1, 0x216138,
	0xBDE2, 0x216658,
	0xBDE3, 0x214C6C,
	0xBDE4, 0x214A3B,
	0xBDE5, 0x217733,
	0xBDE6, 0x214F46,
	0xBDE7, 0x21524C,
	0xBDE8, 0x21542C,
	0xBDE9, 0x214475,
	0xBDEA, 0x215251,
	0xBDEB, 0x216B26,
	0xBDEC, 0x214D23,
	0xBDED, 0x21445A,
	0xBDEE, 0x216132,
	0xBDEF, 0x214548,
	0xBDF0, 0x214F5A,
	0xBDF1, 0x214474,
	0xBDF2, 0x21517D,
	0xBDF3, 0x217877,
	0xBDF4, 0x216A3B,
	0xBDF5, 0x21726A,
	0xBDF6, 0x21632F,
	0xBDF7, 0x21773F,
	0xBDF8, 0x216250,
	0xBDF9, 0x224860,
	0xBDFA, 0x21556C,
	0xBDFB, 0x21655B,
	0xBDFC, 0x214F54,
	0xBDFD, 0x217661,
	0xBDFE, 0x21563F,
	0xBEA1, 0x216970,
	0xBEA2, 0x215030,
	0xBEA3, 0x215774,
	0xBEA4, 0x21677E,
	0xBEA5, 0x215C79,
	0xBEA6, 0x216542,
	0xBEA7, 0x215F5E,
	0xBEA8, 0x217954,
	0xBEA9, 0x214B6B,
	0xBEAA, 0x217C51,
	0xBEAB, 0x216A34,
	0xBEAC, 0x21656C,
	0xBEAD, 0x21656E,
	0xBEAE, 0x21446A,
	0xBEAF, 0x217A40,
	0xBEB0, 0x215F5F,
	0xBEB1, 0x217321,
	0xBEB2, 0x21727B,
	0xBEB3, 0x21683A,
	0xBEB4, 0x216439,
	0xBEB5, 0x217935,
	0xBEB6, 0x215540,
	0xBEB7, 0x216070,
	0xBEB8, 0x21675C,
	0xBEB9, 0x215D7E,
	0xBEBA, 0x217A23,
	0xBEBB, 0x215B67,
	0xBEBC, 0x215236,
	0xBEBD, 0x216126,
	0xBEBE, 0x215F4F,
	0xBEBF, 0x214B36,
	0xBEC0, 0x214F2B,
	0xBEC1, 0x214B2B,
	0xBEC2, 0x215375,
	0xBEC3, 0x21443C,
	0xBEC4, 0x214B25,
	0xBEC5, 0x214426,
	0xBEC6, 0x215858,
	0xBEC7, 0x215F23,
	0xBEC8, 0x215A73,
	0xBEC9, 0x21772E,
	0xBECA, 0x21485E,
	0xBECB, 0x21662B,
	0xBECC, 0x214C55,
	0xBECD, 0x215E73,
	0xBECE, 0x214E7A,
	0xBECF, 0x217626,
	0xBED0, 0x214D6D,
	0xBED1, 0x214E6F,
	0xBED2, 0x21566D,
	0xBED3, 0x214D22,
	0xBED4, 0x216F7C,
	0xBED5, 0x216168,
	0xBED6, 0x21497D,
	0xBED7, 0x214C45,
	0xBED8, 0x21567B,
	0xBED9, 0x217528,
	0xBEDA, 0x214E54,
	0xBEDB, 0x216A4D,
	0xBEDC, 0x214D5C,
	0xBEDD, 0x217063,
	0xBEDE, 0x214648,
	0xBEDF, 0x214C26,
	0xBEE0, 0x216241,
	0xBEE1, 0x216F40,
	0xBEE2, 0x217261,
	0xBEE3, 0x215434,
	0xBEE4, 0x21463B,
	0xBEE5, 0x217A6A,
	0xBEE6, 0x215235,
	0xBEE7, 0x216C2A,
	0xBEE8, 0x21555F,
	0xBEE9, 0x217825,
	0xBEEA, 0x215475,
	0xBEEB, 0x215425,
	0xBEEC, 0x215C37,
	0xBEED, 0x214C3A,
	0xBEEE, 0x21656F,
	0xBEEF, 0x225058,
	0xBEF0, 0x217C38,
	0xBEF1, 0x214A42,
	0xBEF2, 0x215A5C,
	0xBEF3, 0x215432,
	0xBEF4, 0x21743A,
	0xBEF5, 0x217A3C,
	0xBEF6, 0x214A6E,
	0xBEF7, 0x215D40,
	0xBEF8, 0x21613A,
	0xBEF9, 0x214961,
	0xBEFA, 0x216165,
	0xBEFB, 0x21625D,
	0xBEFC, 0x21535B,
	0xBEFD, 0x214949,
	0xBEFE, 0x215531,
	0xBFA1, 0x214F76,
	0xBFA2, 0x21612A,
	0xBFA3, 0x21742B,
	0xBFA4, 0x215855,
	0xBFA5, 0x21762C,
	0xBFA6, 0x215E3E,
	0xBFA7, 0x214C42,
	0xBFA8, 0x214626,
	0xBFA9, 0x215045,
	0xBFAA, 0x216264,
	0xBFAB, 0x215F42,
	0xBFAC, 0x216448,
	0xBFAD, 0x215E33,
	0xBFAE, 0x215F35,
	0xBFAF, 0x21457A,
	0xBFB0, 0x215E5A,
	0xBFB1, 0x21592E,
	0xBFB2, 0x214962,
	0xBFB3, 0x215268,
	0xBFB4, 0x215260,
	0xBFB5, 0x215A2A,
	0xBFB6, 0x216869,
	0xBFB7, 0x21745C,
	0xBFB8, 0x21482B,
	0xBFB9, 0x214A3E,
	0xBFBA, 0x21446D,
	0xBFBB, 0x214E62,
	0xBFBC, 0x214853,
	0xBFBD, 0x215142,
	0xBFBE, 0x215651,
	0xBFBF, 0x216F6A,
	0xBFC0, 0x214C58,
	0xBFC1, 0x215339,
	0xBFC2, 0x215162,
	0xBFC3, 0x215F6F,
	0xBFC4, 0x216E22,
	0xBFC5, 0x217628,
	0xBFC6, 0x21526F,
	0xBFC7, 0x216026,
	0xBFC8, 0x21503D,
	0xBFC9, 0x21462B,
	0xBFCA, 0x21603E,
	0xBFCB, 0x21492C,
	0xBFCC, 0x214C2B,
	0xBFCD, 0x21506A,
	0xBFCE, 0x216E7B,
	0xBFCF, 0x214F39,
	0xBFD0, 0x21593E,
	0xBFD1, 0x21704A,
	0xBFD2, 0x21735E,
	0xBFD3, 0x21495E,
	0xBFD4, 0x21493E,
	0xBFD5, 0x214F28,
	0xBFD6, 0x215545,
	0xBFD7, 0x214536,
	0xBFD8, 0x215A55,
	0xBFD9, 0x224A47,
	0xBFDA, 0x214447,
	0xBFDB, 0x21482A,
	0xBFDC, 0x21596A,
	0xBFDD, 0x21515F,
	0xBFDE, 0x21545D,
	0xBFDF, 0x216564,
	0xBFE0, 0x21533A,
	0xBFE1, 0x216B4D,
	0xBFE2, 0x21553B,
	0xBFE3, 0x217231,
	0xBFE4, 0x21476B,
	0xBFE5, 0x215053,
	0xBFE6, 0x222A59,
	0xBFE7, 0x21667A,
	0xBFE8, 0x215767,
	0xBFE9, 0x21635B,
	0xBFEA, 0x216566,
	0xBFEB, 0x216C26,
	0xBFEC, 0x214A38,
	0xBFED, 0x216C4F,
	0xBFEE, 0x216021,
	0xBFEF, 0x21474B,
	0xBFF0, 0x21612E,
	0xBFF1, 0x214B2A,
	0xBFF2, 0x21557A,
	0xBFF3, 0x21797C,
	0xBFF4, 0x215C3A,
	0xBFF5, 0x21783A,
	0xBFF6, 0x214E53,
	0xBFF7, 0x217536,
	0xBFF8, 0x215C34,
	0xBFF9, 0x226B57,
	0xBFFA, 0x21715D,
	0xBFFB, 0x216631,
	0xBFFC, 0x215058,
	0xBFFD, 0x216B76,
	0xBFFE, 0x215E2E,
	0xC0A1, 0x226A66,
	0xC0A2, 0x216424,
	0xC0A3, 0x216D56,
	0xC0A4, 0x214C5D,
	0xC0A5, 0x214D7A,
	0xC0A6, 0x21555B,
	0xC0A7, 0x21495A,
	0xC0A8, 0x215144,
	0xC0A9, 0x217644,
	0xC0AA, 0x216860,
	0xC0AB, 0x21757A,
	0xC0AC, 0x214C57,
	0xC0AD, 0x214D56,
	0xC0AE, 0x215E48,
	0xC0AF, 0x217B27,
	0xC0B0, 0x217869,
	0xC0B1, 0x216B3E,
	0xC0B2, 0x21593A,
	0xC0B3, 0x216162,
	0xC0B4, 0x214B74,
	0xC0B5, 0x21724A,
	0xC0B6, 0x217731,
	0xC0B7, 0x215962,
	0xC0B8, 0x217A71,
	0xC0B9, 0x21796F,
	0xC0BA, 0x217A25,
	0xC0BB, 0x21757C,
	0xC0BC, 0x217B22,
	0xC0BD, 0x217974,
	0xC0BE, 0x227050,
	0xC0BF, 0x217C5F,
	0xC0C0, 0x217B2A,
	0xC0C1, 0x217836,
	0xC0C2, 0x217D39,
	0xC0C3, 0x217A75,
	0xC0C4, 0x217428,
	0xC0C5, 0x215B7C,
	0xC0C6, 0x216445,
	0xC0C7, 0x215657,
	0xC0C8, 0x215E7E,
	0xC0C9, 0x215367,
	0xC0CA, 0x215576,
	0xC0CB, 0x21563A,
	0xC0CC, 0x216C7C,
	0xC0CD, 0x215E38,
	0xC0CE, 0x214B26,
	0xC0CF, 0x214852,
	0xC0D0, 0x214B71,
	0xC0D1, 0x215060,
	0xC0D2, 0x21673C,
	0xC0D3, 0x215652,
	0xC0D4, 0x225145,
	0xC0D5, 0x21592C,
	0xC0D6, 0x216D40,
	0xC0D7, 0x216758,
	0xC0D8, 0x217B36,
	0xC0D9, 0x21752C,
	0xC0DA, 0x216D7E,
	0xC0DB, 0x215C5B,
	0xC0DC, 0x217342,
	0xC0DD, 0x21763F,
	0xC0DE, 0x217066,
	0xC0DF, 0x214859,
	0xC0E0, 0x21794B,
	0xC0E1, 0x215B61,
	0xC0E2, 0x223C54,
	0xC0E3, 0x216451,
	0xC0E4, 0x214930,
	0xC0E5, 0x22293B,
	0xC0E6, 0x215B3F,
	0xC0E7, 0x215B75,
	0xC0E8, 0x21702D,
	0xC0E9, 0x217D25,
	0xC0EA, 0x216B31,
	0xC0EB, 0x217762,
	0xC0EC, 0x21693F,
	0xC0ED, 0x215C21,
	0xC0EE, 0x214A57,
	0xC0EF, 0x216653,
	0xC0F0, 0x217821,
	0xC0F1, 0x217671,
	0xC0F2, 0x215D21,
	0xC0F3, 0x215773,
	0xC0F4, 0x214750,
	0xC0F5, 0x215623,
	0xC0F6, 0x21795E,
	0xC0F7, 0x216C30,
	0xC0F8, 0x217344,
	0xC0F9, 0x217A21,
	0xC0FA, 0x217125,
	0xC0FB, 0x214933,
	0xC0FC, 0x22487A,
	0xC0FD, 0x214B73,
	0xC0FE, 0x214F79,
	0xC1A1, 0x21606D,
	0xC1A2, 0x214721,
	0xC1A3, 0x215C4E,
	0xC1A4, 0x217844,
	0xC1A5, 0x217622,
	0xC1A6, 0x214430,
	0xC1A7, 0x216D68,
	0xC1A8, 0x21545C,
	0xC1A9, 0x21542A,
	0xC1AA, 0x21747A,
	0xC1AB, 0x216E55,
	0xC1AC, 0x215D59,
	0xC1AD, 0x217B35,
	0xC1AE, 0x21636D,
	0xC1AF, 0x216C6E,
	0xC1B0, 0x21694E,
	0xC1B1, 0x214D2B,
	0xC1B2, 0x21736D,
	0xC1B3, 0x217525,
	0xC1B4, 0x217939,
	0xC1B5, 0x217C36,
	0xC1B6, 0x216478,
	0xC1B7, 0x216E38,
	0xC1B8, 0x21767D,
	0xC1B9, 0x215B49,
	0xC1BA, 0x216D43,
	0xC1BB, 0x21656B,
	0xC1BC, 0x214B40,
	0xC1BD, 0x214C25,
	0xC1BE, 0x216F43,
	0xC1BF, 0x216258,
	0xC1C0, 0x215F62,
	0xC1C1, 0x214F69,
	0xC1C2, 0x216E75,
	0xC1C3, 0x216D24,
	0xC1C4, 0x215C66,
	0xC1C5, 0x216777,
	0xC1C6, 0x217443,
	0xC1C7, 0x21713C,
	0xC1C8, 0x216851,
	0xC1C9, 0x21725B,
	0xC1CA, 0x216D4D,
	0xC1CB, 0x214427,
	0xC1CC, 0x224A4D,
	0xC1CD, 0x226A3D,
	0xC1CE, 0x216861,
	0xC1CF, 0x215568,
	0xC1D0, 0x214744,
	0xC1D1, 0x21617B,
	0xC1D2, 0x215653,
	0xC1D3, 0x214749,
	0xC1D4, 0x217665,
	0xC1D5, 0x21605F,
	0xC1D6, 0x214E2F,
	0xC1D7, 0x21744D,
	0xC1D8, 0x217276,
	0xC1D9, 0x217527,
	0xC1DA, 0x216F50,
	0xC1DB, 0x217C58,
	0xC1DC, 0x215B54,
	0xC1DD, 0x216C29,
	0xC1DE, 0x216675,
	0xC1DF, 0x21493D,
	0xC1E0, 0x214D72,
	0xC1E1, 0x215245,
	0xC1E2, 0x21615F,
	0xC1E3, 0x21675B,
	0xC1E4, 0x217A61,
	0xC1E5, 0x216749,
	0xC1E6, 0x214926,
	0xC1E7, 0x215C61,
	0xC1E8, 0x215445,
	0xC1E9, 0x217C71,
	0xC1EA, 0x215D72,
	0xC1EB, 0x217356,
	0xC1EC, 0x216B6B,
	0xC1ED, 0x214636,
	0xC1EE, 0x21456F,
	0xC1EF, 0x21646E,
	0xC1F0, 0x21565E,
	0xC1F1, 0x216931,
	0xC1F2, 0x215C3D,
	0xC1F3, 0x217772,
	0xC1F4, 0x215667,
	0xC1F5, 0x216C2C,
	0xC1F6, 0x216D6F,
	0xC1F7, 0x21517C,
	0xC1F8, 0x21516B,
	0xC1F9, 0x21447A,
	0xC1FA, 0x21733E,
	0xC1FB, 0x217B6E,
	0xC1FC, 0x21782D,
	0xC1FD, 0x217B6C,
	0xC1FE, 0x217455,
	0xC2A1, 0x21626E,
	0xC2A2, 0x21782F,
	0xC2A3, 0x217839,
	0xC2A4, 0x217944,
	0xC2A5, 0x216D3D,
	0xC2A6, 0x21595F,
	0xC2A7, 0x216876,
	0xC2A8, 0x217457,
	0xC2A9, 0x216945,
	0xC2AA, 0x21536F,
	0xC2AB, 0x217A35,
	0xC2AC, 0x21714D,
	0xC2AD, 0x217D2D,
	0xC2AE, 0x217833,
	0xC2AF, 0x217977,
	0xC2B0, 0x217064,
	0xC2B1, 0x215E25,
	0xC2B2, 0x21663F,
	0xC2B3, 0x217027,
	0xC2B4, 0x21795F,
	0xC2B5, 0x216553,
	0xC2B6, 0x217B3F,
	0xC2B7, 0x21667B,
	0xC2B8, 0x216676,
	0xC2B9, 0x215E26,
	0xC2BA, 0x22577B,
	0xC2BB, 0x21655A,
	0xC2BC, 0x217267,
	0xC2BD, 0x215D74,
	0xC2BE, 0x216C76,
	0xC2BF, 0x217D37,
	0xC2C0, 0x214948,
	0xC2C1, 0x216F5D,
	0xC2C2, 0x214F73,
	0xC2C3, 0x21556A,
	0xC2C4, 0x216C53,
	0xC2C5, 0x216858,
	0xC2C6, 0x217466,
	0xC2C7, 0x216C65,
	0xC2C8, 0x216029,
	0xC2C9, 0x215123,
	0xC2CA, 0x215B7B,
	0xC2CB, 0x21765B,
	0xC2CC, 0x216A3A,
	0xC2CD, 0x217B5E,
	0xC2CE, 0x217C37,
	0xC2CF, 0x217B5C,
	0xC2D0, 0x217D32,
	0xC2D1, 0x21493C,
	0xC2D2, 0x21632A,
	0xC2D3, 0x215A54,
	0xC2D4, 0x215C29,
	0xC2D5, 0x215A65,
	0xC2D6, 0x216F47,
	0xC2D7, 0x21543E,
	0xC2D8, 0x214B7B,
	0xC2D9, 0x215B64,
	0xC2DA, 0x216A43,
	0xC2DB, 0x216F22,
	0xC2DC, 0x217C46,
	0xC2DD, 0x21753E,
	0xC2DE, 0x217865,
	0xC2DF, 0x217C4A,
	0xC2E0, 0x217D3F,
	0xC2E1, 0x217D26,
	0xC2E2, 0x217B47,
	0xC2E3, 0x216A7A,
	0xC2E4, 0x21662F,
	0xC2E5, 0x215228,
	0xC2E6, 0x21732F,
	0xC2E7, 0x21613E,
	0xC2E8, 0x216364,
	0xC2E9, 0x215E28,
	0xC2EA, 0x216966,
	0xC2EB, 0x216E23,
	0xC2EC, 0x21722C,
	0xC2ED, 0x21586B,
	0xC2EE, 0x216E47,
	0xC2EF, 0x216828,
	0xC2F0, 0x216343,
	0xC2F1, 0x21546B,
	0xC2F2, 0x216239,
	0xC2F3, 0x215E27,
	0xC2F4, 0x216F31,
	0xC2F5, 0x217565,
	0xC2F6, 0x215763,
	0xC2F7, 0x217150,
	0xC2F8, 0x21794F,
	0xC2F9, 0x217D27,
	0xC2FA, 0x216948,
	0xC2FB, 0x216E58,
	0xC2FC, 0x215937,
	0xC2FD, 0x21686A,
	0xC2FE, 0x216950,
	0xC3A1, 0x22634E,
	0xC3A2, 0x214B41,
	0xC3A3, 0x215771,
	0xC3A4, 0x214E7D,
	0xC3A5, 0x214E40,
	0xC3A6, 0x214824,
	0xC3A7, 0x215C7A,
	0xC3A8, 0x217249,
	0xC3A9, 0x215337,
	0xC3AA, 0x21756E,
	0xC3AB, 0x214553,
	0xC3AC, 0x214679,
	0xC3AD, 0x21674F,
	0xC3AE, 0x214628,
	0xC3AF, 0x21533D,
	0xC3B0, 0x215023,
	0xC3B1, 0x215E7A,
	0xC3B2, 0x216B32,
	0xC3B3, 0x21623B,
	0xC3B4, 0x216B7B,
	0xC3B5, 0x214E75,
	0xC3B6, 0x214E37,
	0xC3B7, 0x215B3C,
	0xC3B9, 0x216F69,
	0xC3BA, 0x216477,
	0xC3BB, 0x214A74,
	0xC3BC, 0x21525F,
	0xC3BD, 0x215E68,
	0xC3BE, 0x21756D,
	0xC3BF, 0x214A64,
	0xC3C0, 0x215321,
	0xC3C1, 0x215151,
	0xC3C2, 0x215E70,
	0xC3C3, 0x214C68,
	0xC3C4, 0x215E66,
	0xC3C5, 0x214F5C,
	0xC3C6, 0x215F2C,
	0xC3C7, 0x21542F,
	0xC3C8, 0x216164,
	0xC3C9, 0x216A60,
	0xC3CA, 0x21764F,
	0xC3CB, 0x216541,
	0xC3CC, 0x217262,
	0xC3CD, 0x215B77,
	0xC3CE, 0x216842,
	0xC3CF, 0x214C75,
	0xC3D0, 0x216D77,
	0xC3D1, 0x225F71,
	0xC3D2, 0x217948,
	0xC3D3, 0x21745D,
	0xC3D4, 0x21584C,
	0xC3D5, 0x217547,
	0xC3D6, 0x21735A,
	0xC3D7, 0x21484D,
	0xC3D8, 0x215738,
	0xC3D9, 0x215D3C,
	0xC3DA, 0x214E46,
	0xC3DB, 0x216A6D,
	0xC3DC, 0x21596F,
	0xC3DD, 0x217036,
	0xC3DE, 0x215F7B,
	0xC3DF, 0x215679,
	0xC3E0, 0x216A41,
	0xC3E1, 0x215928,
	0xC3E2, 0x21492D,
	0xC3E3, 0x21502E,
	0xC3E4, 0x21547B,
	0xC3E5, 0x216E3C,
	0xC3E6, 0x215372,
	0xC3E7, 0x215340,
	0xC3E8, 0x215F40,
	0xC3E9, 0x216972,
	0xC3EA, 0x217732,
	0xC3EB, 0x215270,
	0xC3EC, 0x216040,
	0xC3ED, 0x216C5B,
	0xC3EE, 0x21496E,
	0xC3EF, 0x216E59,
	0xC3F0, 0x216466,
	0xC3F1, 0x214661,
	0xC3F2, 0x214D59,
	0xC3F3, 0x214677,
	0xC3F4, 0x215A77,
	0xC3F5, 0x216C6F,
	0xC3F6, 0x216B5D,
	0xC3F7, 0x214D7C,
	0xC3F8, 0x21722B,
	0xC3F9, 0x216B78,
	0xC3FA, 0x216B53,
	0xC3FB, 0x214758,
	0xC3FC, 0x214C54,
	0xC3FD, 0x217740,
	0xC3FE, 0x216875,
	0xC4A1, 0x216C79,
	0xC4A2, 0x217A33,
	0xC4A3, 0x216D3C,
	0xC4A4, 0x216E4D,
	0xC4A5, 0x217153,
	0xC4A6, 0x216C77,
	0xC4A7, 0x217B49,
	0xC4A8, 0x214D5B,
	0xC4A9, 0x21465D,
	0xC4AA, 0x215C7B,
	0xC4AB, 0x21702E,
	0xC4AC, 0x21733C,
	0xC4AD, 0x214E4D,
	0xC4AE, 0x216943,
	0xC4AF, 0x21684E,
	0xC4B0, 0x215370,
	0xC4B1, 0x21723B,
	0xC4B2, 0x214849,
	0xC4B3, 0x21515C,
	0xC4B4, 0x214D68,
	0xC4B5, 0x214B27,
	0xC4B6, 0x215664,
	0xC4B7, 0x214C6B,
	0xC4B8, 0x214660,
	0xC4B9, 0x21683B,
	0xC4BA, 0x216D31,
	0xC4BB, 0x21685D,
	0xC4BC, 0x216339,
	0xC4BD, 0x216C67,
	0xC4BE, 0x21454D,
	0xC4BF, 0x214678,
	0xC4C0, 0x216544,
	0xC4C1, 0x214E6B,
	0xC4C2, 0x21715A,
	0xC4C3, 0x215555,
	0xC4C4, 0x215461,
	0xC4C5, 0x214951,
	0xC4C6, 0x21625C,
	0xC4C7, 0x214B5B,
	0xC4C8, 0x215474,
	0xC4C9, 0x21574A,
	0xC4CA, 0x21483C,
	0xC4CB, 0x214425,
	0xC4CC, 0x214644,
	0xC4CD, 0x215323,
	0xC4CE, 0x214C62,
	0xC4CF, 0x215032,
	0xC4D0, 0x214B2E,
	0xC4D1, 0x217945,
	0xC4D2, 0x217B5A,
	0xC4D3, 0x216D22,
	0xC4D4, 0x21662A,
	0xC4D5, 0x215F36,
	0xC4D6, 0x217023,
	0xC4D7, 0x223653,
	0xC4D8, 0x214C51,
	0xC4D9, 0x216F74,
	0xC4DA, 0x214479,
	0xC4DB, 0x216848,
	0xC4DC, 0x215764,
	0xC4DD, 0x214C69,
	0xC4DE, 0x217278,
	0xC4DF, 0x21543C,
	0xC4E0, 0x214E47,
	0xC4E1, 0x214647,
	0xC4E2, 0x217369,
	0xC4E3, 0x214923,
	0xC4E4, 0x215933,
	0xC4E5, 0x217178,
	0xC4E6, 0x21584B,
	0xC4E7, 0x21646A,
	0xC4E8, 0x225342,
	0xC4E9, 0x214D62,
	0xC4EA, 0x214821,
	0xC4EB, 0x216E21,
	0xC4EC, 0x217647,
	0xC4ED, 0x215A6D,
	0xC4EE, 0x214D42,
	0xC4EF, 0x215473,
	0xC4F0, 0x217C6E,
	0xC4F1, 0x215E24,
	0xC4F2, 0x214A21,
	0xC4F3, 0x21555C,
	0xC4F4, 0x21772B,
	0xC4F5, 0x217969,
	0xC4F6, 0x22614B,
	0xC4F7, 0x217D35,
	0xC4F8, 0x217757,
	0xC4F9, 0x21564C,
	0xC4FA, 0x215A40,
	0xC4FB, 0x217652,
	0xC4FC, 0x21743C,
	0xC4FD, 0x217037,
	0xC4FE, 0x21684F,
	0xC5A1, 0x217367,
	0xC5A2, 0x217422,
	0xC5A3, 0x21455C,
	0xC5A4, 0x214A43,
	0xC5A5, 0x21625A,
	0xC5A6, 0x215746,
	0xC5A7, 0x217523,
	0xC5A8, 0x21712A,
	0xC5A9, 0x216729,
	0xC5AA, 0x214A2D,
	0xC5AB, 0x214643,
	0xC5AC, 0x214938,
	0xC5AD, 0x215127,
	0xC5AE, 0x21444C,
	0xC5AF, 0x216440,
	0xC5B0, 0x21534B,
	0xC5B1, 0x21696B,
	0xC5B2, 0x215561,
	0xC5B3, 0x21735F,
	0xC5B4, 0x217A27,
	0xC5B5, 0x21723F,
	0xC5B6, 0x215462,
	0xC5B7, 0x216D44,
	0xC5B8, 0x217C2F,
	0xC5B9, 0x216D48,
	0xC5BA, 0x21786D,
	0xC5BB, 0x21682B,
	0xC5BC, 0x21587B,
	0xC5BD, 0x224B40,
	0xC5BE, 0x215939,
	0xC5BF, 0x21535A,
	0xC5C0, 0x214E67,
	0xC5C1, 0x214D2E,
	0xC5C2, 0x214D4A,
	0xC5C3, 0x216063,
	0xC5C4, 0x214D69,
	0xC5C5, 0x215A6A,
	0xC5C6, 0x216056,
	0xC5C7, 0x215A38,
	0xC5C8, 0x216042,
	0xC5C9, 0x215226,
	0xC5CA, 0x217838,
	0xC5CB, 0x216D59,
	0xC5CC, 0x216D75,
	0xC5CD, 0x216E24,
	0xC5CE, 0x215262,
	0xC5CF, 0x215663,
	0xC5D0, 0x214932,
	0xC5D1, 0x215035,
	0xC5D2, 0x214725,
	0xC5D3, 0x217832,
	0xC5D4, 0x215569,
	0xC5D5, 0x225951,
	0xC5D6, 0x215327,
	0xC5D7, 0x214D61,
	0xC5D8, 0x214C4A,
	0xC5D9, 0x214935,
	0xC5DA, 0x215239,
	0xC5DB, 0x215D3A,
	0xC5DC, 0x216244,
	0xC5DD, 0x214E5A,
	0xC5DE, 0x214C43,
	0xC5DF, 0x215329,
	0xC5E0, 0x21595B,
	0xC5E1, 0x216A78,
	0xC5E2, 0x216F2A,
	0xC5E3, 0x215D71,
	0xC5E4, 0x215859,
	0xC5E5, 0x214B79,
	0xC5E6, 0x214A6C,
	0xC5E7, 0x216C3B,
	0xC5E8, 0x215259,
	0xC5E9, 0x21567C,
	0xC5EA, 0x214D63,
	0xC5EB, 0x215B6E,
	0xC5EC, 0x216D54,
	0xC5ED, 0x215F25,
	0xC5EE, 0x216E5D,
	0xC5EF, 0x215F7C,
	0xC5F0, 0x216555,
	0xC5F1, 0x217459,
	0xC5F2, 0x217179,
	0xC5F3, 0x214E25,
	0xC5F4, 0x21795C,
	0xC5F5, 0x215A5B,
	0xC5F6, 0x216550,
	0xC5F7, 0x222572,
	0xC5F8, 0x222C4E,
	0xC5F9, 0x217B3E,
	0xC5FA, 0x214A47,
	0xC5FB, 0x214D5E,
	0xC5FC, 0x216C2B,
	0xC5FD, 0x216062,
	0xC5FE, 0x215176,
	0xC6A1, 0x215945,
	0xC6A2, 0x216150,
	0xC6A3, 0x21566B,
	0xC6A4, 0x214676,
	0xC6A5, 0x214528,
	0xC6A6, 0x216072,
	0xC6A7, 0x216C22,
	0xC6A8, 0x21497E,
	0xC6A9, 0x217A3F,
	0xC6AA, 0x216E32,
	0xC6AB, 0x215923,
	0xC6AC, 0x21455A,
	0xC6AD, 0x217952,
	0xC6AE, 0x217A51,
	0xC6AF, 0x216946,
	0xC6B0, 0x217147,
	0xC6B1, 0x215C41,
	0xC6B2, 0x216871,
	0xC6B3, 0x217152,
	0xC6B4, 0x21513B,
	0xC6B5, 0x217322,
	0xC6B6, 0x215D4E,
	0xC6B7, 0x215042,
	0xC6B8, 0x21657C,
	0xC6B9, 0x214724,
	0xC6BA, 0x214C59,
	0xC6BB, 0x217A36,
	0xC6BC, 0x216159,
	0xC6BD, 0x21464D,
	0xC6BE, 0x217055,
	0xC6BF, 0x215C25,
	0xC6C0, 0x216223,
	0xC6C1, 0x21506E,
	0xC6C2, 0x214C5B,
	0xC6C3, 0x216D4C,
	0xC6C4, 0x216B6A,
	0xC6C5, 0x215967,
	0xC6C6, 0x215722,
	0xC6C7, 0x217025,
	0xC6C8, 0x215363,
	0xC6C9, 0x215C50,
	0xC6CA, 0x215448,
	0xC6CB, 0x216C7B,
	0xC6CC, 0x22532E,
	0xC6CD, 0x216778,
	0xC6CE, 0x215D26,
	0xC6CF, 0x216639,
	0xC6D0, 0x216156,
	0xC6D1, 0x216A62,
	0xC6D2, 0x21546A,
	0xC6D3, 0x214836,
	0xC6D4, 0x215467,
	0xC6D5, 0x215F5B,
	0xC6D6, 0x21563E,
	0xC6D7, 0x21787B,
	0xC6D8, 0x21783B,
	0xC6D9, 0x21765E,
	0xC6DA, 0x215F66,
	0xC6DB, 0x216022,
	0xC6DC, 0x215F74,
	0xC6DD, 0x215A51,
	0xC6DE, 0x214C66,
	0xC6DF, 0x214424,
	0xC6E0, 0x215B5E,
	0xC6E1, 0x21694A,
	0xC6E2, 0x215170,
	0xC6E3, 0x222450,
	0xC6E4, 0x214C27,
	0xC6E5, 0x215F76,
	0xC6E6, 0x214C61,
	0xC6E7, 0x214E3E,
	0xC6E8, 0x215C2A,
	0xC6E9, 0x215978,
	0xC6EA, 0x21772C,
	0xC6EB, 0x216B7D,
	0xC6EC, 0x216921,
	0xC6ED, 0x21526B,
	0xC6EE, 0x214F25,
	0xC6EF, 0x217777,
	0xC6F0, 0x215844,
	0xC6F1, 0x21583F,
	0xC6F2, 0x21443F,
	0xC6F3, 0x21473A,
	0xC6F4, 0x215A76,
	0xC6F5, 0x215056,
	0xC6F6, 0x215267,
	0xC6F7, 0x217042,
	0xC6F8, 0x215634,
	0xC6F9, 0x214B55,
	0xC6FA, 0x215B39,
	0xC6FB, 0x214A75,
	0xC6FC, 0x214E42,
	0xC6FD, 0x21583C,
	0xC6FE, 0x223558,
	0xC7A1, 0x21512E,
	0xC7A2, 0x215225,
	0xC7A3, 0x215B74,
	0xC7A4, 0x222247,
	0xC7A6, 0x216745,
	0xC7A7, 0x214445,
	0xC7A8, 0x216F4F,
	0xC7A9, 0x21785C,
	0xC7AA, 0x214623,
	0xC7AB, 0x217549,
	0xC7AC, 0x215871,
	0xC7AD, 0x21733D,
	0xC7AE, 0x217264,
	0xC7AF, 0x216740,
	0xC7B0, 0x215029,
	0xC7B1, 0x216D51,
	0xC7B2, 0x216B42,
	0xC7B3, 0x215B51,
	0xC7B4, 0x217B2B,
	0xC7B5, 0x21683D,
	0xC7B6, 0x215E74,
	0xC7B7, 0x21454E,
	0xC7B8, 0x216939,
	0xC7B9, 0x216933,
	0xC7BA, 0x21634D,
	0xC7BB, 0x21614A,
	0xC7BC, 0x214F2D,
	0xC7BD, 0x21743B,
	0xC7BE, 0x21752F,
	0xC7BF, 0x215A30,
	0xC7C0, 0x216435,
	0xC7C1, 0x21707E,
	0xC7C2, 0x217575,
	0xC7C3, 0x21687D,
	0xC7C4, 0x21554A,
	0xC7C5, 0x21707D,
	0xC7C6, 0x21744A,
	0xC7C7, 0x215E52,
	0xC7C8, 0x21677A,
	0xC7C9, 0x214649,
	0xC7CA, 0x21727D,
	0xC7CB, 0x216D2A,
	0xC7CC, 0x217728,
	0xC7CD, 0x21552F,
	0xC7CE, 0x214F70,
	0xC7CF, 0x217676,
	0xC7D0, 0x214522,
	0xC7D1, 0x21533B,
	0xC7D2, 0x214562,
	0xC7D3, 0x214D46,
	0xC7D4, 0x217C3D,
	0xC7D5, 0x216023,
	0xC7D6, 0x214F6B,
	0xC7D7, 0x217235,
	0xC7D8, 0x215736,
	0xC7D9, 0x216064,
	0xC7DA, 0x21633B,
	0xC7DB, 0x214F43,
	0xC7DC, 0x217069,
	0xC7DD, 0x21655D,
	0xC7DE, 0x216854,
	0xC7DF, 0x214A68,
	0xC7E0, 0x214F65,
	0xC7E1, 0x216B3C,
	0xC7E2, 0x215B47,
	0xC7E3, 0x216330,
	0xC7E4, 0x21544E,
	0xC7E5, 0x215B52,
	0xC7E6, 0x217363,
	0xC7E7, 0x215F5D,
	0xC7E8, 0x223D2B,
	0xC7E9, 0x215A45,
	0xC7EA, 0x215E22,
	0xC7EB, 0x216E79,
	0xC7EC, 0x216C63,
	0xC7ED, 0x21784E,
	0xC7EE, 0x216E2C,
	0xC7EF, 0x215271,
	0xC7F0, 0x214563,
	0xC7F1, 0x214F57,
	0xC7F2, 0x215B7E,
	0xC7F3, 0x214A65,
	0xC7F4, 0x21463F,
	0xC7F5, 0x21536A,
	0xC7F6, 0x214E56,
	0xC7F7, 0x217558,
	0xC7F8, 0x215934,
	0xC7F9, 0x215D2F,
	0xC7FA, 0x214832,
	0xC7FB, 0x21774A,
	0xC7FC, 0x214D21,
	0xC7FD, 0x217B44,
	0xC7FE, 0x216032,
	0xC8A1, 0x214C3D,
	0xC8A2, 0x21595E,
	0xC8A3, 0x217D21,
	0xC8A4, 0x216F37,
	0xC8A5, 0x21462A,
	0xC8A6, 0x21594E,
	0xC8A7, 0x22717D,
	0xC8A8, 0x217B62,
	0xC8A9, 0x225F73,
	0xC8AA, 0x215178,
	0xC8AB, 0x214740,
	0xC8AC, 0x215C31,
	0xC8AD, 0x215553,
	0xC8AE, 0x21455D,
	0xC8AF, 0x214C2C,
	0xC8B0, 0x217961,
	0xC8B1, 0x21574D,
	0xC8B2, 0x222770,
	0xC8B3, 0x21714B,
	0xC8B4, 0x215033,
	0xC8B5, 0x21795A,
	0xC8B6, 0x21692E,
	0xC8B7, 0x216D7D,
	0xC8B8, 0x215D7A,
	0xC8B9, 0x21664F,
	0xC8BA, 0x21657A,
	0xC8BB, 0x216053,
	0xC8BC, 0x21713F,
	0xC8BD, 0x214574,
	0xC8BE, 0x215159,
	0xC8BF, 0x217B67,
	0xC8C0, 0x217966,
	0xC8C1, 0x21796E,
	0xC8C2, 0x217962,
	0xC8C3, 0x217C69,
	0xC8C4, 0x217A52,
	0xC8C5, 0x217646,
	0xC8C6, 0x217722,
	0xC8C7, 0x216379,
	0xC8C8, 0x216D60,
	0xC8C9, 0x214531,
	0xC8CA, 0x21446E,
	0xC8CB, 0x214429,
	0xC8CC, 0x214A36,
	0xC8CD, 0x216279,
	0xC8CE, 0x214736,
	0xC8CF, 0x216B25,
	0xC8D0, 0x214443,
	0xC8D1, 0x214973,
	0xC8D2, 0x21527A,
	0xC8D3, 0x214655,
	0xC8D4, 0x214473,
	0xC8D5, 0x21454A,
	0xC8D6, 0x214826,
	0xC8D7, 0x215775,
	0xC8D8, 0x216A5C,
	0xC8D9, 0x21692A,
	0xC8DA, 0x21722E,
	0xC8DB, 0x216959,
	0xC8DC, 0x216461,
	0xC8DD, 0x215529,
	0xC8DE, 0x216139,
	0xC8DF, 0x21447D,
	0xC8E0, 0x215F43,
	0xC8E1, 0x21515B,
	0xC8E2, 0x214858,
	0xC8E3, 0x21577C,
	0xC8E4, 0x217A3A,
	0xC8E5, 0x217030,
	0xC8E6, 0x217352,
	0xC8E7, 0x214771,
	0xC8E8, 0x215849,
	0xC8E9, 0x214B66,
	0xC8EA, 0x21483D,
	0xC8EB, 0x21442B,
	0xC8EC, 0x217232,
	0xC8ED, 0x215D54,
	0xC8EE, 0x214B60,
	0xC8EF, 0x21717E,
	0xC8F0, 0x21652F,
	0xC8F1, 0x216F5E,
	0xC8F2, 0x216263,
	0xC8F3, 0x216D57,
	0xC8F4, 0x21533C,
	0xC8F5, 0x21553E,
	0xC8F6, 0x216D25,
	0xC8F7, 0x222B55,
	0xC8F8, 0x217730,
	0xC8F9, 0x216625,
	0xC8FA, 0x217A59,
	0xC8FB, 0x216352,
	0xC8FC, 0x217554,
	0xC8FD, 0x214435,
	0xC8FE, 0x214435,
	0xC9A1, 0x215E30,
	0xC9A2, 0x215F57,
	0xC9A3, 0x215625,
	0xC9A4, 0x216341,
	0xC9A5, 0x215E46,
	0xC9A6, 0x216433,
	0xC9A7, 0x217A57,
	0xC9A8, 0x215A61,
	0xC9A9, 0x216367,
	0xC9AA, 0x21652E,
	0xC9AB, 0x214863,
	0xC9AC, 0x21742A,
	0xC9AD, 0x215F70,
	0xC9AE, 0x216772,
	0xC9AF, 0x215C74,
	0xC9B0, 0x215265,
	0xC9B1, 0x215B44,
	0xC9B2, 0x215026,
	0xC9B3, 0x214A67,
	0xC9B4, 0x215740,
	0xC9B5, 0x216333,
	0xC9B6, 0x223426,
	0xC9B7, 0x216521,
	0xC9B8, 0x217164,
	0xC9B9, 0x217C3A,
	0xC9BA, 0x215243,
	0xC9BB, 0x222D36,
	0xC9BC, 0x214A5E,
	0xC9BD, 0x214454,
	0xC9BE, 0x214934,
	0xC9BF, 0x21695B,
	0xC9C0, 0x215350,
	0xC9C1, 0x215860,
	0xC9C2, 0x215865,
	0xC9C3, 0x21705E,
	0xC9C4, 0x217A45,
	0xC9C5, 0x217177,
	0xC9C6, 0x216143,
	0xC9C7, 0x214843,
	0xC9C8, 0x215552,
	0xC9C9, 0x217721,
	0xC9CA, 0x224948,
	0xC9CB, 0x216332,
	0xC9CC, 0x215938,
	0xC9CD, 0x216F2B,
	0xC9CE, 0x215570,
	0xC9CF, 0x214438,
	0xC9D0, 0x214C7E,
	0xC9D1, 0x216A76,
	0xC9D2, 0x215B2F,
	0xC9D3, 0x215556,
	0xC9D4, 0x216121,
	0xC9D5, 0x217138,
	0xC9D6, 0x214B43,
	0xC9D7, 0x214444,
	0xC9D8, 0x216B69,
	0xC9D9, 0x214537,
	0xC9DA, 0x215452,
	0xC9DB, 0x214F55,
	0xC9DC, 0x215C55,
	0xC9DD, 0x21595D,
	0xC9DE, 0x216B35,
	0xC9DF, 0x215D2A,
	0xC9E0, 0x21485F,
	0xC9E1, 0x214F3C,
	0xC9E2, 0x215D50,
	0xC9E3, 0x217A6C,
	0xC9E4, 0x21552B,
	0xC9E5, 0x217A6B,
	0xC9E6, 0x215644,
	0xC9E7, 0x214F23,
	0xC9E8, 0x215D43,
	0xC9E9, 0x215723,
	0xC9EA, 0x214673,
	0xC9EB, 0x214C46,
	0xC9EC, 0x21487A,
	0xC9ED, 0x214B4E,
	0xC9EE, 0x215B65,
	0xC9EF, 0x215479,
	0xC9F0, 0x215C59,
	0xC9F1, 0x21572E,
	0xC9F2, 0x214A69,
	0xC9F3, 0x216C50,
	0xC9F4, 0x217640,
	0xC9F5, 0x215249,
	0xC9F6, 0x21614D,
	0xC9F7, 0x21637C,
	0xC9F8, 0x216956,
	0xC9F9, 0x217478,
	0xC9FA, 0x21466D,
	0xC9FB, 0x216069,
	0xC9FC, 0x21523C,
	0xC9FD, 0x21452A,
	0xC9FE, 0x217862,
	0xCAA1, 0x21525C,
	0xCAA2, 0x215C36,
	0xCAA3, 0x215E37,
	0xCAA4, 0x215E39,
	0xCAA5, 0x21657B,
	0xCAA6, 0x21553A,
	0xCAA7, 0x214642,
	0xCAA8, 0x216528,
	0xCAA9, 0x21514C,
	0xCAAA, 0x21742E,
	0xCAAB, 0x21665D,
	0xCAAC, 0x21506F,
	0xCAAD, 0x216E67,
	0xCAAE, 0x214432,
	0xCAAF, 0x21467B,
	0xCAB0, 0x215145,
	0xCAB1, 0x21556B,
	0xCAB2, 0x21446F,
	0xCAB3, 0x21537A,
	0xCAB4, 0x216A73,
	0xCAB5, 0x216852,
	0xCAB6, 0x21787C,
	0xCAB7, 0x214638,
	0xCAB8, 0x21467A,
	0xCAB9, 0x214B70,
	0xCABA, 0x21506D,
	0xCABB, 0x216F79,
	0xCABC, 0x214C6E,
	0xCABD, 0x214822,
	0xCABE, 0x21467C,
	0xCABF, 0x214449,
	0xCAC0, 0x214560,
	0xCAC1, 0x215158,
	0xCAC2, 0x214B67,
	0xCAC3, 0x21513C,
	0xCAC4, 0x216B27,
	0xCAC5, 0x215D5B,
	0xCAC6, 0x21633C,
	0xCAC7, 0x215152,
	0xCAC8, 0x216344,
	0xCAC9, 0x217046,
	0xCACA, 0x216F4B,
	0xCACB, 0x21456B,
	0xCACC, 0x214B6E,
	0xCACD, 0x217A4B,
	0xCACE, 0x216768,
	0xCACF, 0x214554,
	0xCAD0, 0x21464B,
	0xCAD1, 0x215132,
	0xCAD2, 0x215069,
	0xCAD3, 0x21617E,
	0xCAD4, 0x21665C,
	0xCAD5, 0x21482D,
	0xCAD6, 0x214543,
	0xCAD7, 0x21537B,
	0xCAD8, 0x214776,
	0xCAD9, 0x216840,
	0xCADA, 0x215A66,
	0xCADB, 0x215947,
	0xCADC, 0x214C3F,
	0xCADD, 0x216D70,
	0xCADE, 0x21784B,
	0xCADF, 0x216E56,
	0xCAE0, 0x216D39,
	0xCAE1, 0x215622,
	0xCAE2, 0x215631,
	0xCAE3, 0x214A49,
	0xCAE4, 0x217253,
	0xCAE5, 0x214C3E,
	0xCAE6, 0x216154,
	0xCAE7, 0x215B56,
	0xCAE8, 0x215C2D,
	0xCAE9, 0x215573,
	0xCAEA, 0x217B75,
	0xCAEB, 0x215969,
	0xCAEC, 0x216D5E,
	0xCAED, 0x217530,
	0xCAEE, 0x215F60,
	0xCAEF, 0x21736F,
	0xCAF0, 0x216577,
	0xCAF1, 0x216645,
	0xCAF2, 0x216328,
	0xCAF3, 0x216771,
	0xCAF4, 0x217A68,
	0xCAF5, 0x215D34,
	0xCAF6, 0x21535D,
	0xCAF7, 0x217079,
	0xCAF8, 0x214A56,
	0xCAF9, 0x214828,
	0xCAFA, 0x216F28,
	0xCAFB, 0x21683E,
	0xCAFC, 0x215A2C,
	0xCAFD, 0x216D30,
	0xCAFE, 0x21694B,
	0xCBA1, 0x215546,
	0xCBA2, 0x214C2D,
	0xCBA3, 0x215324,
	0xCBA4, 0x216873,
	0xCBA5, 0x21582E,
	0xCBA6, 0x21466F,
	0xCBA7, 0x215075,
	0xCBA8, 0x21562E,
	0xCBA9, 0x215146,
	0xCBAA, 0x217624,
	0xCBAB, 0x217764,
	0xCBAC, 0x215B73,
	0xCBAD, 0x216F21,
	0xCBAE, 0x214555,
	0xCBAF, 0x216975,
	0xCBB0, 0x216124,
	0xCBB1, 0x21494F,
	0xCBB2, 0x217449,
	0xCBB3, 0x21627B,
	0xCBB4, 0x216155,
	0xCBB5, 0x216B29,
	0xCBB6, 0x21697A,
	0xCBB7, 0x215574,
	0xCBB8, 0x217848,
	0xCBB9, 0x215F5A,
	0xCBBA, 0x216D23,
	0xCBBB, 0x216C3C,
	0xCBBC, 0x215128,
	0xCBBD, 0x214B33,
	0xCBBE, 0x214633,
	0xCBBF, 0x21613D,
	0xCBC0, 0x21483B,
	0xCBC1, 0x21657D,
	0xCBC2, 0x214779,
	0xCBC3, 0x216347,
	0xCBC4, 0x21463E,
	0xCBC5, 0x214879,
	0xCBC6, 0x21487D,
	0xCBC7, 0x216765,
	0xCBC8, 0x214459,
	0xCBC9, 0x21777A,
	0xCBCA, 0x21747B,
	0xCBCB, 0x216C6B,
	0xCBCC, 0x216764,
	0xCBCD, 0x21584A,
	0xCBCE, 0x21497A,
	0xCBCF, 0x215D44,
	0xCBD0, 0x216B21,
	0xCBD1, 0x216432,
	0xCBD2, 0x21717C,
	0xCBD3, 0x217649,
	0xCBD4, 0x21682A,
	0xCBD5, 0x217A37,
	0xCBD6, 0x216257,
	0xCBD7, 0x214F77,
	0xCBD8, 0x215743,
	0xCBD9, 0x215D5A,
	0xCBDA, 0x216135,
	0xCBDB, 0x22487A,
	0xCBDC, 0x216353,
	0xCBDD, 0x21645F,
	0xCBDE, 0x21596E,
	0xCBDF, 0x21622B,
	0xCBE0, 0x216148,
	0xCBE1, 0x216B4C,
	0xCBE2, 0x216A63,
	0xCBE3, 0x216A2B,
	0xCBE4, 0x217623,
	0xCBE5, 0x21626B,
	0xCBE6, 0x217271,
	0xCBE7, 0x216572,
	0xCBE8, 0x217C54,
	0xCBE9, 0x21654F,
	0xCBEA, 0x216459,
	0xCBEB, 0x217454,
	0xCBEC, 0x21672D,
	0xCBED, 0x217270,
	0xCBEE, 0x21572C,
	0xCBEF, 0x215521,
	0xCBF0, 0x216434,
	0xCBF1, 0x216131,
	0xCBF2, 0x216A6A,
	0xCBF3, 0x215B3A,
	0xCBF4, 0x215459,
	0xCBF5, 0x217463,
	0xCBF6, 0x216965,
	0xCBF7, 0x215744,
	0xCBF8, 0x217755,
	0xCBF9, 0x214D54,
	0xCBFA, 0x216359,
	0xCBFB, 0x21456C,
	0xCBFC, 0x214646,
	0xCBFD, 0x214770,
	0xCBFE, 0x216357,
	0xCCA1, 0x21784C,
	0xCCA2, 0x217061,
	0xCCA3, 0x21755A,
	0xCCA4, 0x216F3C,
	0xCCA5, 0x21532F,
	0xCCA6, 0x215344,
	0xCCA7, 0x214D71,
	0xCCA8, 0x21463A,
	0xCCA9, 0x215639,
	0xCCAB, 0x214534,
	0xCCAC, 0x216868,
	0xCCAD, 0x214A70,
	0xCCAE, 0x214960,
	0xCCAF, 0x217B61,
	0xCCB0, 0x215D4D,
	0xCCB1, 0x217C61,
	0xCCB2, 0x217B65,
	0xCCB3, 0x21704B,
	0xCCB4, 0x217371,
	0xCCB5, 0x216538,
	0xCCB6, 0x216D50,
	0xCCB7, 0x21787E,
	0xCCB8, 0x216E76,
	0xCCB9, 0x214C5C,
	0xCCBA, 0x216027,
	0xCCBB, 0x215D38,
	0xCCBC, 0x216979,
	0xCCBD, 0x215A58,
	0xCCBE, 0x21682C,
	0xCCBF, 0x215237,
	0xCCC0, 0x21603D,
	0xCCC1, 0x216354,
	0xCCC2, 0x21642D,
	0xCCC3, 0x215958,
	0xCCC4, 0x215F6A,
	0xCCC5, 0x216E4C,
	0xCCC6, 0x215453,
	0xCCC7, 0x217167,
	0xCCC8, 0x215438,
	0xCCC9, 0x216F41,
	0xCCCA, 0x215B4E,
	0xCCCB, 0x216F36,
	0xCCCC, 0x21713D,
	0xCCCD, 0x215A6B,
	0xCCCE, 0x217427,
	0xCCCF, 0x216470,
	0xCCD0, 0x216573,
	0xCCD1, 0x21616B,
	0xCCD2, 0x21562B,
	0xCCD3, 0x215850,
	0xCCD4, 0x215B63,
	0xCCD5, 0x215D77,
	0xCCD6, 0x215836,
	0xCCD7, 0x21546F,
	0xCCD8, 0x215656,
	0xCCD9, 0x217A7B,
	0xCCDA, 0x217A56,
	0xCCDB, 0x21566E,
	0xCCDC, 0x21754E,
	0xCCDD, 0x215B2E,
	0xCCDE, 0x21544A,
	0xCCDF, 0x216F3B,
	0xCCE0, 0x216F59,
	0xCCE1, 0x215F48,
	0xCCE2, 0x21776E,
	0xCCE3, 0x21724B,
	0xCCE4, 0x215E40,
	0xCCE5, 0x217C55,
	0xCCE6, 0x215F65,
	0xCCE7, 0x21734A,
	0xCCE8, 0x215A4B,
	0xCCE9, 0x21563B,
	0xCCEA, 0x215027,
	0xCCEB, 0x215974,
	0xCCEC, 0x214532,
	0xCCED, 0x215B50,
	0xCCEE, 0x216358,
	0xCCEF, 0x214670,
	0xCCF0, 0x215C27,
	0xCCF1, 0x215133,
	0xCCF2, 0x216A59,
	0xCCF3, 0x21614F,
	0xCCF4, 0x215147,
	0xCCF5, 0x215B3E,
	0xCCF6, 0x21535F,
	0xCCF7, 0x215C3C,
	0xCCF8, 0x21667C,
	0xCCF9, 0x216232,
	0xCCFA, 0x217B37,
	0xCCFB, 0x214D2D,
	0xCCFC, 0x217D22,
	0xCCFD, 0x217B6F,
	0xCCFE, 0x22366F,
	0xCDA1, 0x214665,
	0xCDA2, 0x214A2C,
	0xCDA3, 0x215874,
	0xCDA4, 0x214F68,
	0xCDA5, 0x21553C,
	0xCDA6, 0x21555E,
	0xCDA7, 0x21662C,
	0xCDA8, 0x215D57,
	0xCDA9, 0x215628,
	0xCDAA, 0x224832,
	0xCDAB, 0x217446,
	0xCDAC, 0x214751,
	0xCDAD, 0x216B52,
	0xCDAE, 0x214A2F,
	0xCDAF, 0x216129,
	0xCDB0, 0x215B33,
	0xCDB1, 0x222F38,
	0xCDB2, 0x21612F,
	0xCDB3, 0x215C53,
	0xCDB4, 0x21606E,
	0xCDB5, 0x215922,
	0xCDB6, 0x214A4D,
	0xCDB7, 0x217324,
	0xCDB8, 0x215D60,
	0xCDB9, 0x214579,
	0xCDBA, 0x214B35,
	0xCDBB, 0x215273,
	0xCDBC, 0x216837,
	0xCDBD, 0x21553F,
	0xCDBE, 0x215D64,
	0xCDBF, 0x216355,
	0xCDC0, 0x215973,
	0xCDC1, 0x214448,
	0xCDC2, 0x214753,
	0xCDC3, 0x214C22,
	0xCDC4, 0x21603F,
	0xCDC5, 0x216836,
	0xCDC6, 0x215A64,
	0xCDC7, 0x217325,
	0xCDC8, 0x216A54,
	0xCDC9, 0x216647,
	0xCDCA, 0x217230,
	0xCDCB, 0x21584D,
	0xCDCC, 0x21493F,
	0xCDCD, 0x21453A,
	0xCDCE, 0x217522,
	0xCDCF, 0x214D6E,
	0xCDD0, 0x21482C,
	0xCDD1, 0x215C6B,
	0xCDD2, 0x217336,
	0xCDD3, 0x214F5E,
	0xCDD4, 0x21676A,
	0xCDD5, 0x216F76,
	0xCDD6, 0x21707B,
	0xCDD7, 0x214974,
	0xCDD8, 0x214D5F,
	0xCDD9, 0x215E4E,
	0xCDDA, 0x215139,
	0xCDDB, 0x21503E,
	0xCDDC, 0x216172,
	0xCDDD, 0x216A23,
	0xCDDE, 0x21505F,
	0xCDDF, 0x21466B,
	0xCDE0, 0x217B28,
	0xCDE1, 0x215171,
	0xCDE2, 0x214640,
	0xCDE3, 0x216F27,
	0xCDE4, 0x217B5F,
	0xCDE5, 0x217D24,
	0xCDE6, 0x214E72,
	0xCDE7, 0x216760,
	0xCDE8, 0x21443A,
	0xCDE9, 0x22366D,
	0xCDEA, 0x214979,
	0xCDEB, 0x216551,
	0xCDEC, 0x215560,
	0xCDED, 0x215B25,
	0xCDEE, 0x216076,
	0xCDEF, 0x215A41,
	0xCDF0, 0x214C7D,
	0xCDF1, 0x215960,
	0xCDF2, 0x21655C,
	0xCDF3, 0x216149,
	0xCDF4, 0x214A6D,
	0xCDF5, 0x21455E,
	0xCDF6, 0x214441,
	0xCDF7, 0x214E33,
	0xCDF8, 0x216A3D,
	0xCDF9, 0x214D3B,
	0xCDFA, 0x214D76,
	0xCDFB, 0x215B2C,
	0xCDFC, 0x214A33,
	0xCDFD, 0x21476C,
	0xCDFE, 0x215064,
	0xCEA1, 0x217A69,
	0xCEA2, 0x216372,
	0xCEA3, 0x21474E,
	0xCEA4, 0x215374,
	0xCEA5, 0x216730,
	0xCEA6, 0x21562D,
	0xCEA7, 0x215E58,
	0xCEA8, 0x215944,
	0xCEA9, 0x215A4D,
	0xCEAA, 0x215233,
	0xCEAB, 0x217430,
	0xCEAC, 0x216A44,
	0xCEAD, 0x216632,
	0xCEAE, 0x21616A,
	0xCEAF, 0x214C67,
	0xCEB0, 0x215879,
	0xCEB1, 0x215873,
	0xCEB2, 0x214A22,
	0xCEB3, 0x216E39,
	0xCEB4, 0x21465C,
	0xCEB5, 0x216E54,
	0xCEB6, 0x214C40,
	0xCEB7, 0x21524B,
	0xCEB8, 0x21532A,
	0xCEB9, 0x215E44,
	0xCEBA, 0x21777B,
	0xCEBB, 0x21486D,
	0xCEBC, 0x21603B,
	0xCEBD, 0x217241,
	0xCEBE, 0x215970,
	0xCEBF, 0x216C6A,
	0xCEC0, 0x216E6C,
	0xCEC1, 0x216D6E,
	0xCEC2, 0x21646B,
	0xCEC3, 0x215826,
	0xCEC4, 0x214546,
	0xCEC5, 0x216A4C,
	0xCEC6, 0x215741,
	0xCEC7, 0x21494D,
	0xCEC8, 0x217858,
	0xCEC9, 0x215742,
	0xCECA, 0x215942,
	0xCECB, 0x21634B,
	0xCECC, 0x215751,
	0xCECD, 0x217668,
	0xCECE, 0x21706B,
	0xCECF, 0x216E66,
	0xCED0, 0x21603C,
	0xCED1, 0x216A24,
	0xCED2, 0x214A3C,
	0xCED3, 0x21687E,
	0xCED4, 0x214F3A,
	0xCED5, 0x215F49,
	0xCED6, 0x214A76,
	0xCED7, 0x214A27,
	0xCED8, 0x21634A,
	0xCED9, 0x217756,
	0xCEDA, 0x215654,
	0xCEDB, 0x214844,
	0xCEDC, 0x216B24,
	0xCEDD, 0x215070,
	0xCEDE, 0x216052,
	0xCEDF, 0x217228,
	0xCEE0, 0x215B35,
	0xCEE1, 0x214940,
	0xCEE2, 0x214946,
	0xCEE3, 0x214551,
	0xCEE4, 0x214E3D,
	0xCEE5, 0x21446C,
	0xCEE6, 0x21555A,
	0xCEE7, 0x214529,
	0xCEE8, 0x216A5A,
	0xCEE9, 0x214730,
	0xCEEA, 0x214F78,
	0xCEEB, 0x21635C,
	0xCEEC, 0x214653,
	0xCEED, 0x217947,
	0xCEEE, 0x215B26,
	0xCEEF, 0x214E6C,
	0xCEF0, 0x214526,
	0xCEF1, 0x21592D,
	0xCEF2, 0x21554B,
	0xCEF3, 0x216B28,
	0xCEF4, 0x214D77,
	0xCEF5, 0x21695A,
	0xCEF6, 0x214E35,
	0xCEF7, 0x214869,
	0xCEF8, 0x223757,
	0xCEF9, 0x214F22,
	0xCEFA, 0x215F5C,
	0xCEFB, 0x216C32,
	0xCEFC, 0x21494E,
	0xCEFD, 0x217266,
	0xCEFE, 0x217A76,
	0xCFA1, 0x216125,
	0xCFA2, 0x215549,
	0xCFA3, 0x214A28,
	0xCFA4, 0x215A3E,
	0xCFA5, 0x216E4E,
	0xCFA6, 0x21444A,
	0xCFA7, 0x215A48,
	0xCFA8, 0x21695D,
	0xCFA9, 0x215B72,
	0xCFAA, 0x216471,
	0xCFAB, 0x214842,
	0xCFAC, 0x216058,
	0xCFAD, 0x217373,
	0xCFAE, 0x217B71,
	0xCFAF, 0x215539,
	0xCFB0, 0x215C64,
	0xCFB1, 0x216366,
	0xCFB2, 0x215E45,
	0xCFB3, 0x216B5A,
	0xCFB4, 0x215223,
	0xCFB5, 0x214B37,
	0xCFB6, 0x216B61,
	0xCFB7, 0x217361,
	0xCFB8, 0x215C58,
	0xCFB9, 0x216D76,
	0xCFBA, 0x216E65,
	0xCFBB, 0x21493A,
	0xCFBC, 0x217625,
	0xCFBD, 0x21755D,
	0xCFBE, 0x21643E,
	0xCFBF, 0x215530,
	0xCFC0, 0x214F6E,
	0xCFC1, 0x215658,
	0xCFC2, 0x214436,
	0xCFC3, 0x21636E,
	0xCFC4, 0x21546E,
	0xCFC5, 0x217349,
	0xCFC6, 0x215A6C,
	0xCFC8, 0x21473F,
	0xCFC9, 0x214570,
	0xCFCA, 0x21762D,
	0xCFCB, 0x217C42,
	0xCFCC, 0x21503B,
	0xCFCD, 0x216F30,
	0xCFCE, 0x216B57,
	0xCFCF, 0x215C71,
	0xCFD0, 0x216265,
	0xCFD1, 0x215B48,
	0xCFD2, 0x214D38,
	0xCFD3, 0x216362,
	0xCFD4, 0x217C4F,
	0xCFD5, 0x217272,
	0xCFD6, 0x215C22,
	0xCFD7, 0x217978,
	0xCFD8, 0x21716C,
	0xCFD9, 0x216629,
	0xCFDA, 0x21732B,
	0xCFDB, 0x216579,
	0xCFDC, 0x217054,
	0xCFDD, 0x215D78,
	0xCFDE, 0x21536E,
	0xCFDF, 0x216E40,
	0xCFE0, 0x21525E,
	0xCFE1, 0x215F22,
	0xCFE2, 0x217D2B,
	0xCFE3, 0x21537C,
	0xCFE4, 0x216E2E,
	0xCFE5, 0x217543,
	0xCFE6, 0x216037,
	0xCFE7, 0x216254,
	0xCFE8, 0x216144,
	0xCFE9, 0x215C40,
	0xCFEA, 0x21665B,
	0xCFEB, 0x216377,
	0xCFEC, 0x217B40,
	0xCFED, 0x214B6A,
	0xCFEE, 0x21627A,
	0xCFEF, 0x215073,
	0xCFF0, 0x21707C,
	0xCFF1, 0x216779,
	0xCFF2, 0x214757,
	0xCFF3, 0x21622F,
	0xCFF4, 0x217227,
	0xCFF5, 0x21607C,
	0xCFF6, 0x216F66,
	0xCFF7, 0x215028,
	0xCFF8, 0x215460,
	0xCFF9, 0x217A66,
	0xCFFA, 0x216F5A,
	0xCFFB, 0x21563C,
	0xCFFC, 0x215528,
	0xCFFD, 0x215B68,
	0xCFFE, 0x21706E,
	0xD0A1, 0x214451,
	0xD0A2, 0x214975,
	0xD0A3, 0x215577,
	0xD0A4, 0x214B39,
	0xD0A5, 0x216C3D,
	0xD0A6, 0x21573D,
	0xD0A7, 0x215566,
	0xD0A8, 0x21644A,
	0xD0A9, 0x214B68,
	0xD0AA, 0x216458,
	0xD0AB, 0x217873,
	0xD0AC, 0x216F6C,
	0xD0AD, 0x214C36,
	0xD0AE, 0x215557,
	0xD0AF, 0x217A6D,
	0xD0B0, 0x214B59,
	0xD0B1, 0x215A7B,
	0xD0B2, 0x21575D,
	0xD0B3, 0x21723D,
	0xD0B4, 0x216C51,
	0xD0B5, 0x215B37,
	0xD0B6, 0x214C3B,
	0xD0B7, 0x217874,
	0xD0B8, 0x21705C,
	0xD0B9, 0x214E51,
	0xD0BA, 0x217659,
	0xD0BB, 0x21754D,
	0xD0BC, 0x21552C,
	0xD0BD, 0x21752A,
	0xD0BE, 0x214F47,
	0xD0BF, 0x216F58,
	0xD0C0, 0x214E3C,
	0xD0C1, 0x214B50,
	0xD0C2, 0x21643B,
	0xD0C3, 0x222425,
	0xD0C4, 0x214540,
	0xD0C5, 0x214F6A,
	0xD0C6, 0x22664D,
	0xD0C7, 0x215153,
	0xD0C8, 0x216624,
	0xD0C9, 0x21605C,
	0xD0CA, 0x215F30,
	0xD0CB, 0x21717B,
	0xD0CC, 0x214745,
	0xD0CD, 0x21504E,
	0xD0CE, 0x214A30,
	0xD0CF, 0x214B58,
	0xD0D0, 0x214867,
	0xD0D1, 0x21725E,
	0xD0D2, 0x214D31,
	0xD0D3, 0x214A58,
	0xD0D4, 0x214D4C,
	0xD0D5, 0x214C6F,
	0xD0D6, 0x214573,
	0xD0D7, 0x21473D,
	0xD0D8, 0x215761,
	0xD0D9, 0x21474A,
	0xD0DA, 0x215227,
	0xD0DB, 0x216274,
	0xD0DC, 0x21695C,
	0xD0DD, 0x214732,
	0xD0DE, 0x21543A,
	0xD0DF, 0x215C60,
	0xD0E0, 0x214835,
	0xD0E1, 0x21634C,
	0xD0E2, 0x217A4E,
	0xD0E3, 0x214B34,
	0xD0E4, 0x215D39,
	0xD0E5, 0x217724,
	0xD0E6, 0x216C40,
	0xD0E7, 0x214827,
	0xD0E8, 0x216B66,
	0xD0E9, 0x216170,
	0xD0EA, 0x216C38,
	0xD0EB, 0x21627C,
	0xD0EC, 0x215541,
	0xD0ED, 0x215D42,
	0xD0EE, 0x216A5F,
	0xD0EF, 0x215D68,
	0xD0F0, 0x215A78,
	0xD0F1, 0x214831,
	0xD0F2, 0x214A29,
	0xD0F3, 0x215665,
	0xD0F4, 0x215136,
	0xD0F5, 0x21613C,
	0xD0F6, 0x215E67,
	0xD0F7, 0x216A45,
	0xD0F8, 0x217A7D,
	0xD0F9, 0x215846,
	0xD0FA, 0x215E3F,
	0xD0FB, 0x215067,
	0xD0FC, 0x21796C,
	0xD0FD, 0x215B21,
	0xD0FE, 0x214668,
	0xD1A1, 0x217259,
	0xD1A2, 0x217B6A,
	0xD1A3, 0x215677,
	0xD1A4, 0x216140,
	0xD1A5, 0x21675D,
	0xD1A6, 0x217531,
	0xD1A7, 0x217050,
	0xD1A8, 0x21467E,
	0xD1A9, 0x215D7B,
	0xD1AA, 0x214866,
	0xD1AB, 0x215E3A,
	0xD1AC, 0x224B66,
	0xD1AD, 0x215F27,
	0xD1AE, 0x214830,
	0xD1AF, 0x216666,
	0xD1B0, 0x215E72,
	0xD1B1, 0x21676B,
	0xD1B2, 0x214B56,
	0xD1B3, 0x215632,
	0xD1B4, 0x214845,
	0xD1B5, 0x21583B,
	0xD1B6, 0x215839,
	0xD1B7, 0x216B41,
	0xD1B8, 0x214B54,
	0xD1B9, 0x21734C,
	0xD1BA, 0x214D65,
	0xD1BB, 0x217029,
	0xD1BC, 0x217339,
	0xD1BD, 0x214954,
	0xD1BE, 0x214439,
	0xD1BF, 0x214F41,
	0xD1C0, 0x21455B,
	0xD1C1, 0x21582D,
	0xD1C2, 0x21597A,
	0xD1C3, 0x21664C,
	0xD1C4, 0x215B55,
	0xD1C5, 0x216273,
	0xD1C6, 0x21593C,
	0xD1C7, 0x214B69,
	0xD1C8, 0x215D3F,
	0xD1C9, 0x215B6F,
	0xD1CA, 0x21782C,
	0xD1CB, 0x225B55,
	0xD1CC, 0x216475,
	0xD1CD, 0x215B59,
	0xD1CE, 0x217C7C,
	0xD1CF, 0x217964,
	0xD1D0, 0x215266,
	0xD1D1, 0x224D70,
	0xD1D2, 0x217C35,
	0xD1D3, 0x214D37,
	0xD1D4, 0x214B46,
	0xD1D5, 0x21776D,
	0xD1D6, 0x21726F,
	0xD1D7, 0x214E63,
	0xD1D8, 0x214E58,
	0xD1D9, 0x214C63,
	0xD1DA, 0x215A5F,
	0xD1DB, 0x215C39,
	0xD1DC, 0x21534F,
	0xD1DD, 0x21693D,
	0xD1DE, 0x217C6C,
	0xD1DF, 0x215E5D,
	0xD1E0, 0x21713A,
	0xD1E1, 0x216825,
	0xD1E2, 0x21607E,
	0xD1E3, 0x216272,
	0xD1E4, 0x215454,
	0xD1E5, 0x21507D,
	0xD1E6, 0x217140,
	0xD1E7, 0x215526,
	0xD1E8, 0x217238,
	0xD1E9, 0x217C53,
	0xD1EA, 0x215172,
	0xD1EB, 0x214641,
	0xD1EC, 0x217338,
	0xD1ED, 0x215734,
	0xD1EE, 0x21644E,
	0xD1EF, 0x215F52,
	0xD1F0, 0x214B6C,
	0xD1F1, 0x21696C,
	0xD1F2, 0x214850,
	0xD1F3, 0x215179,
	0xD1F4, 0x21626C,
	0xD1F5, 0x215635,
	0xD1F6, 0x214737,
	0xD1F7, 0x223742,
	0xD1F8, 0x216F72,
	0xD1F9, 0x216D35,
	0xD1FA, 0x216942,
	0xD1FB, 0x217567,
	0xD1FC, 0x216622,
	0xD1FD, 0x21496F,
	0xD1FE, 0x216964,
	0xD2A1, 0x216436,
	0xD2A2, 0x215E59,
	0xD2A3, 0x216B43,
	0xD2A4, 0x216E2B,
	0xD2A5, 0x21754C,
	0xD2A6, 0x215062,
	0xD2A7, 0x215036,
	0xD2A8, 0x21576A,
	0xD2A9, 0x21786F,
	0xD2AA, 0x215351,
	0xD2AB, 0x217A2E,
	0xD2AC, 0x21644C,
	0xD2AD, 0x216C39,
	0xD2AE, 0x215326,
	0xD2AF, 0x216525,
	0xD2B0, 0x215D69,
	0xD2B1, 0x21492F,
	0xD2B2, 0x21443E,
	0xD2B3, 0x215377,
	0xD2B4, 0x215A57,
	0xD2B5, 0x216446,
	0xD2B6, 0x216634,
	0xD2B7, 0x214833,
	0xD2B8, 0x21614B,
	0xD2B9, 0x214C5F,
	0xD2BA, 0x215B4C,
	0xD2BB, 0x214421,
	0xD2BC, 0x215E62,
	0xD2BD, 0x217750,
	0xD2BE, 0x215F4A,
	0xD2BF, 0x224E5E,
	0xD2C0, 0x214B6D,
	0xD2C1, 0x21472E,
	0xD2C2, 0x214868,
	0xD2C3, 0x217326,
	0xD2C4, 0x21476A,
	0xD2C5, 0x21725C,
	0xD2C6, 0x215C43,
	0xD2C7, 0x216C21,
	0xD2C8, 0x21575C,
	0xD2C9, 0x21696A,
	0xD2CA, 0x214B21,
	0xD2CB, 0x214C7B,
	0xD2CC, 0x21505E,
	0xD2CD, 0x000000,	/* Exist in GB and Big5, not in cns */
	0xD2CE, 0x215F6D,
	0xD2CF, 0x217871,
	0xD2D0, 0x21542D,
	0xD2D1, 0x214458,
	0xD2D2, 0x214422,
	0xD2D3, 0x214B32,
	0xD2D4, 0x214568,
	0xD2D5, 0x21786B,
	0xD2D6, 0x214A4F,
	0xD2D7, 0x214D78,
	0xD2D8, 0x214B57,
	0xD2D9, 0x21477B,
	0xD2DA, 0x216B7E,
	0xD2DB, 0x214A32,
	0xD2DC, 0x21747C,
	0xD2DD, 0x21624F,
	0xD2DE, 0x21657E,
	0xD2DF, 0x21524F,
	0xD2E0, 0x214729,
	0xD2E1, 0x21664E,
	0xD2E2, 0x216374,
	0xD2E3, 0x216D47,
	0xD2E4, 0x217059,
	0xD2E5, 0x216578,
	0xD2E6, 0x215674,
	0xD2E7, 0x21645E,
	0xD2E8, 0x216661,
	0xD2E9, 0x217A3E,
	0xD2EA, 0x216E74,
	0xD2EB, 0x217A41,
	0xD2EC, 0x215C2C,
	0xD2ED, 0x217476,
	0xD2EE, 0x215C62,
	0xD2EF, 0x217861,
	0xD2F0, 0x215778,
	0xD2F1, 0x216E57,
	0xD2F2, 0x21475E,
	0xD2F3, 0x215633,
	0xD2F4, 0x215376,
	0xD2F5, 0x215D75,
	0xD2F6, 0x215065,
	0xD2F7, 0x214957,
	0xD2F8, 0x216B51,
	0xD2F9, 0x215B62,
	0xD2FA, 0x21596B,
	0xD2FB, 0x216323,
	0xD2FC, 0x214467,
	0xD2FD, 0x21453F,
	0xD2FE, 0x217621,
	0xD3A1, 0x21474D,
	0xD3A2, 0x215341,
	0xD3A3, 0x217A70,
	0xD3A4, 0x21734F,
	0xD3A5, 0x217C79,
	0xD3A6, 0x21735C,
	0xD3A7, 0x217C41,
	0xD3A8, 0x216D66,
	0xD3A9, 0x21722D,
	0xD3AA, 0x217432,
	0xD3AB, 0x21695E,
	0xD3AC, 0x217872,
	0xD3AD, 0x214F52,
	0xD3AE, 0x217A44,
	0xD3AF, 0x215258,
	0xD3B0, 0x216C60,
	0xD3B1, 0x217159,
	0xD3B2, 0x21607D,
	0xD3B3, 0x215150,
	0xD3B4, 0x215E4F,
	0xD3B5, 0x21705F,
	0xD3B6, 0x21632B,
	0xD3B7, 0x21747D,
	0xD3B8, 0x226F39,
	0xD3B9, 0x215A2B,
	0xD3BA, 0x216754,
	0xD3BB, 0x21724D,
	0xD3BC, 0x216641,
	0xD3BD, 0x216222,
	0xD3BE, 0x214E44,
	0xD3BF, 0x216030,
	0xD3C0, 0x214663,
	0xD3C1, 0x215A3C,
	0xD3C2, 0x21502D,
	0xD3C3, 0x21466E,
	0xD3C4, 0x215077,
	0xD3C5, 0x217340,
	0xD3C6, 0x215A3F,
	0xD3C7, 0x216C68,
	0xD3C8, 0x214538,
	0xD3C9, 0x214671,
	0xD3CA, 0x216253,
	0xD3CB, 0x216744,
	0xD3CC, 0x216059,
	0xD3CD, 0x214E52,
	0xD3CE, 0x21672B,
	0xD3CF, 0x214B5C,
	0xD3D0, 0x214834,
	0xD3D1, 0x21452E,
	0xD3D2, 0x21462D,
	0xD3D3, 0x214877,
	0xD3D4, 0x21673E,
	0xD3D5, 0x216B2C,
	0xD3D6, 0x214434,
	0xD3D7, 0x21464E,
	0xD3D8, 0x214B52,
	0xD3D9, 0x215B4F,
	0xD3DA, 0x214D75,
	0xD3DB, 0x214E7C,
	0xD3DC, 0x216454,
	0xD3DD, 0x21663E,
	0xD3DE, 0x216373,
	0xD3DF, 0x217561,
	0xD3E0, 0x214927,
	0xD3E1, 0x214F7E,
	0xD3E2, 0x216737,
	0xD3E3, 0x215E23,
	0xD3E4, 0x215F39,
	0xD3E5, 0x216043,
	0xD3E6, 0x216955,
	0xD3E7, 0x21626D,
	0xD3E8, 0x214468,
	0xD3E9, 0x215476,
	0xD3EA, 0x214F64,
	0xD3EB, 0x216A58,
	0xD3EC, 0x217355,
	0xD3ED, 0x21526D,
	0xD3EE, 0x214775,
	0xD3EF, 0x216B23,
	0xD3F0, 0x214851,
	0xD3F1, 0x214669,
	0xD3F2, 0x215951,
	0xD3F3, 0x214B42,
	0xD3F4, 0x217D48,
	0xD3F5, 0x214754,
	0xD3F6, 0x216732,
	0xD3F7, 0x215E51,
	0xD3F8, 0x215532,
	0xD3F9, 0x215A39,
	0xD3FA, 0x21766B,
	0xD3FB, 0x215B43,
	0xD3FC, 0x216962,
	0xD3FD, 0x214B3F,
	0xD3FE, 0x217B2D,
	0xD4A1, 0x215647,
	0xD4A2, 0x215E6F,
	0xD4A3, 0x216655,
	0xD4A4, 0x21675F,
	0xD4A5, 0x217247,
	0xD4A6, 0x216326,
	0xD4A7, 0x21733B,
	0xD4A8, 0x215B5C,
	0xD4A9, 0x215441,
	0xD4AA, 0x214477,
	0xD4AB, 0x215050,
	0xD4AC, 0x215830,
	0xD4AD, 0x21544F,
	0xD4AE, 0x215F4E,
	0xD4AF, 0x217560,
	0xD4B0, 0x216350,
	0xD4B1, 0x21545E,
	0xD4B2, 0x216351,
	0xD4B3, 0x216529,
	0xD4B4, 0x216463,
	0xD4B5, 0x216E3F,
	0xD4B6, 0x216B3F,
	0xD4B7, 0x215345,
	0xD4B8, 0x21794C,
	0xD4B9, 0x21512C,
	0xD4BA, 0x215861,
	0xD4BB, 0x21454B,
	0xD4BC, 0x21527C,
	0xD4BD, 0x21623D,
	0xD4BE, 0x217B30,
	0xD4BF, 0x217D2C,
	0xD4C0, 0x214D2A,
	0xD4C1, 0x21656D,
	0xD4C2, 0x21454C,
	0xD4C3, 0x215550,
	0xD4C4, 0x216F65,
	0xD4C5, 0x215754,
	0xD4C6, 0x216278,
	0xD4C7, 0x22482E,
	0xD4C8, 0x214524,
	0xD4C9, 0x216753,
	0xD4CA, 0x214478,
	0xD4CB, 0x21672A,
	0xD4CC, 0x217A38,
	0xD4CD, 0x21756A,
	0xD4CE, 0x21643F,
	0xD4CF, 0x21794A,
	0xD4D0, 0x214645,
	0xD4D1, 0x214622,
	0xD4D2, 0x21567E,
	0xD4D3, 0x217763,
	0xD4D4, 0x215626,
	0xD4D5, 0x21503A,
	0xD4D6, 0x214B24,
	0xD4D7, 0x215523,
	0xD4D8, 0x216725,
	0xD4D9, 0x214742,
	0xD4DA, 0x214763,
	0xD4DB, 0x215047,
	0xD4DC, 0x226D51,
	0xD4DD, 0x216D32,
	0xD4DE, 0x217D34,
	0xD4DF, 0x217B2E,
	0xD4E0, 0x217B70,
	0xD4E1, 0x216635,
	0xD4E2, 0x216F4E,
	0xD4E3, 0x217460,
	0xD4E4, 0x217D44,
	0xD4E5, 0x217A31,
	0xD4E6, 0x215F6C,
	0xD4E7, 0x21482E,
	0xD4E8, 0x217129,
	0xD4E9, 0x215829,
	0xD4EA, 0x217A47,
	0xD4EB, 0x217041,
	0xD4EC, 0x215D5F,
	0xD4ED, 0x214B30,
	0xD4EE, 0x214B22,
	0xD4EF, 0x217435,
	0xD4F0, 0x215D4A,
	0xD4F1, 0x217065,
	0xD4F2, 0x21502C,
	0xD4F3, 0x21712B,
	0xD4F4, 0x216670,
	0xD4F5, 0x21512B,
	0xD4F6, 0x216C41,
	0xD4F7, 0x216C70,
	0xD4F8, 0x215F64,
	0xD4F9, 0x217925,
	0xD4FA, 0x215C54,
	0xD4FB, 0x215E4B,
	0xD4FC, 0x216034,
	0xD4FD, 0x21465E,
	0xD4FE, 0x214F51,
	0xD5A1, 0x226022,
	0xD5A2, 0x216750,
	0xD5A3, 0x21567A,
	0xD5A4, 0x215160,
	0xD5A5, 0x216927,
	0xD5A6, 0x214C53,
	0xD5A7, 0x214565,
	0xD5A8, 0x215238,
	0xD5A9, 0x216229,
	0xD5AA, 0x216872,
	0xD5AB, 0x21763A,
	0xD5AC, 0x214777,
	0xD5AD, 0x215739,
	0xD5AE, 0x21632C,
	0xD5AF, 0x216853,
	0xD5B0, 0x21766E,
	0xD5B1, 0x217421,
	0xD5B2, 0x216669,
	0xD5B3, 0x223824,
	0xD5B4, 0x214E4A,
	0xD5B5, 0x216540,
	0xD5B6, 0x215A7D,
	0xD5B7, 0x21755E,
	0xD5B8, 0x216859,
	0xD5B9, 0x21552D,
	0xD5BA, 0x217C45,
	0xD5BB, 0x215F71,
	0xD5BC, 0x21487C,
	0xD5BD, 0x21705D,
	0xD5BE, 0x21573B,
	0xD5BF, 0x216036,
	0xD5C0, 0x216A35,
	0xD5C1, 0x216D36,
	0xD5C2, 0x215D7D,
	0xD5C3, 0x216864,
	0xD5C4, 0x21693C,
	0xD5C5, 0x215A2F,
	0xD5C6, 0x215F3F,
	0xD5C7, 0x21694D,
	0xD5C8, 0x214A5C,
	0xD5C9, 0x214437,
	0xD5CA, 0x215A28,
	0xD5CB, 0x216F2E,
	0xD5CC, 0x21456D,
	0xD5CD, 0x21614E,
	0xD5CE, 0x21714A,
	0xD5CF, 0x216B62,
	0xD5D0, 0x214D5D,
	0xD5D1, 0x21514F,
	0xD5D2, 0x214A46,
	0xD5D3, 0x214E4B,
	0xD5D4, 0x216B37,
	0xD5D5, 0x216479,
	0xD5D6, 0x216575,
	0xD5D7, 0x21473E,
	0xD5D8, 0x216A4E,
	0xD5D9, 0x21462E,
	0xD5DA, 0x216F4C,
	0xD5DB, 0x214A4B,
	0xD5DC, 0x215458,
	0xD5DD, 0x225F36,
	0xD5DE, 0x21774C,
	0xD5DF, 0x214F2F,
	0xD5E0, 0x225B31,
	0xD5E1, 0x216E52,
	0xD5E2, 0x215D55,
	0xD5E3, 0x215641,
	0xD5E4, 0x215246,
	0xD5E5, 0x21643A,
	0xD5E6, 0x215678,
	0xD5E7, 0x216969,
	0xD5E8, 0x21567D,
	0xD5E9, 0x21717A,
	0xD5EA, 0x215356,
	0xD5EB, 0x21585C,
	0xD5EC, 0x21587E,
	0xD5ED, 0x214E28,
	0xD5EE, 0x21566F,
	0xD5EF, 0x21622C,
	0xD5F0, 0x216F68,
	0xD5F1, 0x215558,
	0xD5F2, 0x217758,
	0xD5F3, 0x215862,
	0xD5F4, 0x216A65,
	0xD5F5, 0x215A67,
	0xD5F6, 0x21654A,
	0xD5F7, 0x214D3C,
	0xD5F8, 0x215B7A,
	0xD5F9, 0x214E68,
	0xD5FA, 0x214D45,
	0xD5FB, 0x21706C,
	0xD5FC, 0x215143,
	0xD5FD, 0x21465F,
	0xD5FE, 0x215149,
	0xD6A1, 0x215E7B,
	0xD6A2, 0x21566A,
	0xD6A3, 0x216F51,
	0xD6A4, 0x216225,
	0xD6A5, 0x214F3E,
	0xD6A6, 0x214E2E,
	0xD6A7, 0x214545,
	0xD6A8, 0x214955,
	0xD6A9, 0x216A72,
	0xD6AA, 0x214F21,
	0xD6AB, 0x214F32,
	0xD6AC, 0x21575B,
	0xD6AD, 0x214664,
	0xD6AE, 0x214466,
	0xD6AF, 0x21767E,
	0xD6B0, 0x21772A,
	0xD6B1, 0x214E7E,
	0xD6B2, 0x215F78,
	0xD6B3, 0x216025,
	0xD6B4, 0x21595A,
	0xD6B5, 0x21542B,
	0xD6B6, 0x22253B,
	0xD6B7, 0x21495F,
	0xD6B8, 0x215140,
	0xD6B9, 0x21454F,
	0xD6BA, 0x215D51,
	0xD6BB, 0x214637,
	0xD6BC, 0x21482F,
	0xD6BD, 0x21574B,
	0xD6BE, 0x214A35,
	0xD6BF, 0x216C78,
	0xD6C0, 0x217645,
	0xD6C1, 0x21485D,
	0xD6C2, 0x215333,
	0xD6C3, 0x216574,
	0xD6C4, 0x216C57,
	0xD6C5, 0x215071,
	0xD6C6, 0x214C31,
	0xD6C7, 0x215F61,
	0xD6C8, 0x215737,
	0xD6C9, 0x21655F,
	0xD6CA, 0x216F33,
	0xD6CB, 0x214E66,
	0xD6CC, 0x215C2E,
	0xD6CD, 0x216949,
	0xD6CE, 0x214E59,
	0xD6CF, 0x215C44,
	0xD6D0, 0x214463,
	0xD6D1, 0x21525B,
	0xD6D2, 0x214D40,
	0xD6D3, 0x217A4C,
	0xD6D4, 0x21582F,
	0xD6D5, 0x215C5C,
	0xD6D6, 0x216A21,
	0xD6D7, 0x216627,
	0xD6D8, 0x21536C,
	0xD6D9, 0x214734,
	0xD6DA, 0x215C38,
	0xD6DB, 0x214861,
	0xD6DC, 0x214C52,
	0xD6DD, 0x21477C,
	0xD6DE, 0x21517A,
	0xD6DF, 0x225F50,
	0xD6E0, 0x216136,
	0xD6E1, 0x216249,
	0xD6E2, 0x214B3C,
	0xD6E3, 0x214D2C,
	0xD6E4, 0x214C49,
	0xD6E5, 0x216D74,
	0xD6E6, 0x214C7C,
	0xD6E7, 0x215B24,
	0xD6E8, 0x217C75,
	0xD6E9, 0x215660,
	0xD6EA, 0x21562C,
	0xD6EB, 0x216175,
	0xD6EC, 0x214837,
	0xD6ED, 0x216F29,
	0xD6EE, 0x216E7A,
	0xD6EF, 0x216664,
	0xD6F0, 0x215D5C,
	0xD6F1, 0x21484C,
	0xD6F2, 0x217436,
	0xD6F3, 0x216054,
	0xD6F4, 0x214D58,
	0xD6F5, 0x217D33,
	0xD6F6, 0x217C5D,
	0xD6F7, 0x214564,
	0xD6F8, 0x216161,
	0xD6F9, 0x21515A,
	0xD6FA, 0x214937,
	0xD6FB, 0x215D2B,
	0xD6FC, 0x216231,
	0xD6FD, 0x217B7B,
	0xD6FE, 0x217160,
	0xD7A1, 0x21486E,
	0xD7A2, 0x214E43,
	0xD7A3, 0x21572F,
	0xD7A4, 0x216F77,
	0xD7A5, 0x214A4E,
	0xD7A6, 0x214557,
	0xD7A7, 0x21513F,
	0xD7A8, 0x215971,
	0xD7A9, 0x217154,
	0xD7AA, 0x21774B,
	0xD7AB, 0x216C7E,
	0xD7AC, 0x217553,
	0xD7AD, 0x216E31,
	0xD7AE, 0x216D38,
	0xD7AF, 0x215C7D,
	0xD7B0, 0x216652,
	0xD7B1, 0x214969,
	0xD7B2, 0x216C7A,
	0xD7B3, 0x214967,
	0xD7B4, 0x214E6D,
	0xD7B5, 0x215F7A,
	0xD7B6, 0x217269,
	0xD7B7, 0x215851,
	0xD7B8, 0x217743,
	0xD7B9, 0x216C43,
	0xD7BA, 0x216A3C,
	0xD7BB, 0x216E77,
	0xD7BC, 0x21646D,
	0xD7BD, 0x21555D,
	0xD7BE, 0x214D67,
	0xD7BF, 0x214C37,
	0xD7C0, 0x215624,
	0xD7C1, 0x216060,
	0xD7C2, 0x215342,
	0xD7C3, 0x21585A,
	0xD7C4, 0x21593B,
	0xD7C5, 0x216161,
	0xD7C6, 0x214B23,
	0xD7C7, 0x21712C,
	0xD7C8, 0x21577B,
	0xD7C9, 0x215038,
	0xD7CA, 0x216671,
	0xD7CB, 0x21505C,
	0xD7CC, 0x216045,
	0xD7CD, 0x215B69,
	0xD7CE, 0x214976,
	0xD7CF, 0x21613B,
	0xD7D0, 0x21456A,
	0xD7D1, 0x215276,
	0xD7D2, 0x216460,
	0xD7D3, 0x21444D,
	0xD7D4, 0x21485C,
	0xD7D5, 0x216944,
	0xD7D6, 0x214773,
	0xD7D7, 0x217779,
	0xD7D8, 0x215F69,
	0xD7D9, 0x217747,
	0xD7DA, 0x214C78,
	0xD7DB, 0x216A37,
	0xD7DC, 0x21746A,
	0xD7DD, 0x21746B,
	0xD7DE, 0x216739,
	0xD7DF, 0x214B4C,
	0xD7E0, 0x215057,
	0xD7E1, 0x215F45,
	0xD7E2, 0x215735,
	0xD7E3, 0x214B4D,
	0xD7E4, 0x214C35,
	0xD7E5, 0x215A7E,
	0xD7E6, 0x21572D,
	0xD7E7, 0x216228,
	0xD7E8, 0x214F60,
	0xD7E9, 0x215C5A,
	0xD7EA, 0x217D3D,
	0xD7EB, 0x217A2C,
	0xD7EC, 0x216C36,
	0xD7ED, 0x216F55,
	0xD7EE, 0x215E32,
	0xD7EF, 0x216576,
	0xD7F0, 0x215E71,
	0xD7F1, 0x217257,
	0xD7F2, 0x215154,
	0xD7F3, 0x21464A,
	0xD7F4, 0x214876,
	0xD7F5, 0x21516A,
	0xD7F6, 0x215878,
	0xD7F7, 0x214922,
	0xD7F8, 0x214964,
	0xD7F9, 0x21553D,
	0xD8A1, 0x222129,
	0xD8A2, 0x222127,
	0xD8A3, 0x214442,
	0xD8A4, 0x214461,
	0xD8A5, 0x21453D,
	0xD8A6, 0x21452B,
	0xD8A7, 0x214561,
	0xD8A8, 0x214727,
	0xD8A9, 0x214722,
	0xD8AA, 0x21586F,
	0xD8AB, 0x222E67,
	0xD8AC, 0x21703E,
	0xD8AE, 0x21526E,
	0xD8B0, 0x214431,
	0xD8B1, 0x222128,
	0xD8B2, 0x214535,
	0xD8B3, 0x214559,
	0xD8B4, 0x214629,
	0xD8B5, 0x214662,
	0xD8B6, 0x222227,
	0xD8B7, 0x215331,
	0xD8B8, 0x223A34,
	0xD8B9, 0x21645C,
	0xD8BA, 0x216548,
	0xD8BD, 0x214F67,
	0xD8BE, 0x22563E,
	0xD8BF, 0x222122,
	0xD8C0, 0x214726,
	0xD8C1, 0x222131,
	0xD8C2, 0x214F2E,
	0xD8C3, 0x214978,
	0xD8C4, 0x216345,
	0xD8C5, 0x224933,
	0xD8C6, 0x214476,
	0xD8C7, 0x22293A,
	0xD8C8, 0x215450,
	0xD8C9, 0x22653B,
	0xD8CA, 0x215E3C,
	0xD8CB, 0x216C5C,
	0xD8CC, 0x217C4E,
	0xD8CD, 0x217B76,
	0xD8CE, 0x222124,
	0xD8CF, 0x214634,
	0xD8D0, 0x223372,
	0xD8D1, 0x216824,
	0xD8D2, 0x215935,
	0xD8D3, 0x22635E,
	0xD8D4, 0x214C39,
	0xD8D5, 0x222334,
	0xD8D7, 0x214523,
	0xD8D8, 0x214747,
	0xD8D9, 0x222932,
	0xD8DA, 0x222552,
	0xD8DB, 0x224F5B,
	0xD8DC, 0x215E35,
	0xD8DD, 0x21502A,
	0xD8DE, 0x222E2C,
	0xD8DF, 0x222E29,
	0xD8E0, 0x215449,
	0xD8E1, 0x224D4E,
	0xD8E2, 0x216338,
	0xD8E3, 0x216823,
	0xD8E4, 0x224929,
	0xD8E6, 0x217039,
	0xD8E8, 0x214F2C,
	0xD8EA, 0x214470,
	0xD8EB, 0x222133,
	0xD8EC, 0x222132,
	0xD8ED, 0x222145,
	0xD8EE, 0x222148,
	0xD8F0, 0x214571,
	0xD8F1, 0x22415F,
	0xD8F2, 0x214738,
	0xD8F3, 0x222176,
	0xD8F4, 0x222321,
	0xD8F5, 0x22216D,
	0xD8F6, 0x215431,
	0xD8F7, 0x215E2F,
	0xD8F8, 0x21472C,
	0xD8F9, 0x21486F,
	0xD8FA, 0x214871,
	0xD8FB, 0x222323,
	0xD8FC, 0x214A53,
	0xD8FD, 0x21492A,
	0xD8FE, 0x214928,
	0xD9A1, 0x222325,
	0xD9A2, 0x214870,
	0xD9A4, 0x214878,
	0xD9A5, 0x222538,
	0xD9A6, 0x222539,
	0xD9A7, 0x214B7E,
	0xD9A8, 0x22253A,
	0xD9A9, 0x214B75,
	0xD9AA, 0x214B7D,
	0xD9AB, 0x214B7C,
	0xD9AC, 0x214B7A,
	0xD9AD, 0x217034,
	0xD9AE, 0x222533,
	0xD9AF, 0x216C25,
	0xD9B0, 0x222546,
	0xD9B1, 0x217032,
	0xD9B2, 0x217B57,
	0xD9B3, 0x217A62,
	0xD9B4, 0x22287E,
	0xD9B5, 0x214F7C,
	0xD9B6, 0x222925,
	0xD9B7, 0x222927,
	0xD9B8, 0x214F6F,
	0xD9B9, 0x214F75,
	0xD9BA, 0x215427,
	0xD9BB, 0x215428,
	0xD9BC, 0x215877,
	0xD9BD, 0x215439,
	0xD9BE, 0x222D74,
	0xD9BF, 0x215924,
	0xD9C1, 0x21543B,
	0xD9C2, 0x21543D,
	0xD9C3, 0x222D78,
	0xD9C4, 0x215421,
	0xD9C5, 0x215426,
	0xD9C6, 0x215433,
	0xD9C7, 0x224879,
	0xD9C8, 0x215876,
	0xD9C9, 0x21587D,
	0xD9CA, 0x223358,
	0xD9CB, 0x21587C,
	0xD9CC, 0x216334,
	0xD9CD, 0x224161,
	0xD9CE, 0x217B58,
	0xD9CF, 0x217033,
	0xD9D0, 0x226B4E,
	0xD9D1, 0x224164,
	0xD9D2, 0x216775,
	0xD9D3, 0x224F52,
	0xD9D4, 0x216776,
	0xD9D5, 0x224922,
	0xD9D6, 0x224876,
	0xD9D7, 0x216773,
	0xD9D8, 0x224F53,
	0xD9D9, 0x224F56,
	0xD9DA, 0x222149,
	0xD9DB, 0x222259,
	0xD9DC, 0x222327,
	0xD9DD, 0x224167,
	0xD9DE, 0x214F7D,
	0xD9DF, 0x226142,
	0xD9E0, 0x222259,
	0xD9E1, 0x226D6D,
	0xD9E2, 0x21447B,
	0xD9E3, 0x215E78,
	0xD9E4, 0x217D31,
	0xD9E5, 0x226061,
	0xD9E6, 0x226D46,
	0xD9E7, 0x217A67,
	0xD9E9, 0x215031,
	0xD9EA, 0x222D52,
	0xD9EB, 0x215930,
	0xD9EC, 0x224873,
	0xD9ED, 0x214768,
	0xD9EE, 0x214C24,
	0xD9F0, 0x215022,
	0xD9F1, 0x21537E,
	0xD9F2, 0x215D35,
	0xD9F3, 0x223943,
	0xD9F4, 0x217541,
	0xD9F5, 0x227132,
	0xD9F6, 0x216656,
	0xD9F7, 0x216562,
	0xD9F8, 0x21704F,
	0xD9F9, 0x226668,
	0xD9FA, 0x217868,
	0xD9FC, 0x22217B,
	0xD9FD, 0x214C29,
	0xD9FE, 0x22254E,
	0xDAA3, 0x216356,
	0xDAA4, 0x215442,
	0xDAA5, 0x226751,
	0xDAA6, 0x215835,
	0xDAA7, 0x215837,
	0xDAA8, 0x215838,
	0xDAA9, 0x226348,
	0xDAAA, 0x22403C,
	0xDAAB, 0x215D41,
	0xDAAC, 0x216226,
	0xDAAD, 0x21622D,
	0xDAAE, 0x21622A,
	0xDAAF, 0x216227,
	0xDAB1, 0x224045,
	0xDAB2, 0x22474C,
	0xDAB3, 0x224752,
	0xDAB4, 0x22474D,
	0xDAB5, 0x21665E,
	0xDAB6, 0x216660,
	0xDAB7, 0x224753,
	0xDAB8, 0x216668,
	0xDAB9, 0x216667,
	0xDABA, 0x216F23,
	0xDABB, 0x225A4D,
	0xDABC, 0x22474E,
	0xDABD, 0x216B2E,
	0xDABE, 0x216B2A,
	0xDABF, 0x216B2D,
	0xDAC0, 0x224E35,
	0xDAC1, 0x22543D,
	0xDAC2, 0x225441,
	0xDAC3, 0x216E7C,
	0xDAC4, 0x216F26,
	0xDAC5, 0x225445,
	0xDAC6, 0x216E7D,
	0xDAC7, 0x216F24,
	0xDAC8, 0x217245,
	0xDAC9, 0x217239,
	0xDACA, 0x225A52,
	0xDACB, 0x217240,
	0xDACC, 0x225A53,
	0xDACD, 0x217243,
	0xDACE, 0x217246,
	0xDACF, 0x217244,
	0xDAD0, 0x217237,
	0xDAD1, 0x21723E,
	0xDAD2, 0x225A57,
	0xDAD3, 0x21773E,
	0xDAD4, 0x217D3A,
	0xDAD5, 0x225F4E,
	0xDAD6, 0x225F5C,
	0xDAD7, 0x21754F,
	0xDAD8, 0x217741,
	0xDAD9, 0x226E25,
	0xDADA, 0x226728,
	0xDADB, 0x217924,
	0xDADC, 0x217921,
	0xDADD, 0x227177,
	0xDADE, 0x217A43,
	0xDADF, 0x217C6B,
	0xDAE1, 0x222A30,
	0xDAE3, 0x222276,
	0xDAE4, 0x21486A,
	0xDAE5, 0x214B61,
	0xDAE6, 0x214B62,
	0xDAE7, 0x222879,
	0xDAE8, 0x22287A,
	0xDAE9, 0x214F62,
	0xDAEA, 0x215867,
	0xDAEB, 0x222D63,
	0xDAEC, 0x223349,
	0xDAED, 0x224146,
	0xDAEE, 0x215D79,
	0xDAEF, 0x216270,
	0xDAF0, 0x215D76,
	0xDAF1, 0x224145,
	0xDAF2, 0x21626F,
	0xDAF3, 0x22485A,
	0xDAF4, 0x226042,
	0xDAF5, 0x222272,
	0xDAF6, 0x222274,
	0xDAF7, 0x226375,
	0xDAF8, 0x222271,
	0xDAF9, 0x22482F,
	0xDAFA, 0x222528,
	0xDAFB, 0x222874,
	0xDAFC, 0x222876,
	0xDAFD, 0x214F58,
	0xDAFE, 0x21725D,
	0xDBA1, 0x214F56,
	0xDBA2, 0x222877,
	0xDBA3, 0x22333B,
	0xDBA4, 0x222D5C,
	0xDBA5, 0x222D5D,
	0xDBA6, 0x225B25,
	0xDBA8, 0x222D5E,
	0xDBA9, 0x224075,
	0xDBAA, 0x217B7A,
	0xDBAB, 0x215857,
	0xDBAC, 0x223340,
	0xDBAD, 0x22333F,
	0xDBAE, 0x22333E,
	0xDBAF, 0x223972,
	0xDBB0, 0x22396B,
	0xDBB1, 0x216255,
	0xDBB2, 0x224077,
	0xDBB3, 0x224E53,
	0xDBB4, 0x216B4A,
	0xDBB5, 0x224E50,
	0xDBB6, 0x216F53,
	0xDBB7, 0x22547C,
	0xDBB8, 0x217568,
	0xDBB9, 0x226A2F,
	0xDBBA, 0x226C49,
	0xDBBB, 0x215770,
	0xDBBC, 0x215059,
	0xDBBD, 0x224F5C,
	0xDBBE, 0x214939,
	0xDBBF, 0x222331,
	0xDBC0, 0x214C33,
	0xDBC1, 0x222E3B,
	0xDBC3, 0x223370,
	0xDBC4, 0x216C2F,
	0xDBC5, 0x215451,
	0xDBC6, 0x217433,
	0xDBC7, 0x226946,
	0xDBCB, 0x22334D,
	0xDBCD, 0x21464F,
	0xDBCE, 0x215666,
	0xDBCF, 0x222C78,
	0xDBD0, 0x22234C,
	0xDBD1, 0x215953,
	0xDBD3, 0x216839,
	0xDBD4, 0x225659,
	0xDBD5, 0x21704C,
	0xDBD6, 0x21734D,
	0xDBD7, 0x214767,
	0xDBD8, 0x214765,
	0xDBDA, 0x214761,
	0xDBDB, 0x21763E,
	0xDBDC, 0x222228,
	0xDBDD, 0x214766,
	0xDBDE, 0x217830,
	0xDBDF, 0x214966,
	0xDBE1, 0x214C5A,
	0xDBE3, 0x222575,
	0xDBE4, 0x226542,
	0xDBE5, 0x214C5E,
	0xDBE6, 0x22257B,
	0xDBE7, 0x222621,
	0xDBE8, 0x222574,
	0xDBE9, 0x222578,
	0xDBEA, 0x22257C,
	0xDBEB, 0x223444,
	0xDBEC, 0x222954,
	0xDBED, 0x222955,
	0xDBEE, 0x22422C,
	0xDBEF, 0x22343D,
	0xDBF2, 0x215054,
	0xDBF3, 0x21504F,
	0xDBF4, 0x222E4E,
	0xDBF5, 0x21635D,
	0xDBF6, 0x215E60,
	0xDBF7, 0x22422B,
	0xDBF8, 0x222E4F,
	0xDBF9, 0x222E54,
	0xDBFA, 0x223435,
	0xDBFC, 0x22343A,
	0xDBFD, 0x215956,
	0xDCA1, 0x22343B,
	0xDCA2, 0x22344E,
	0xDCA3, 0x223438,
	0xDCA4, 0x223437,
	0xDCA5, 0x223436,
	0xDCA6, 0x223A64,
	0xDCA7, 0x223A63,
	0xDCA9, 0x215E61,
	0xDCAA, 0x224234,
	0xDCAC, 0x224942,
	0xDCAD, 0x22493D,
	0xDCAF, 0x216C3F,
	0xDCB0, 0x217A54,
	0xDCB1, 0x217B53,
	0xDCB2, 0x217B60,
	0xDCB4, 0x22226D,
	0xDCB5, 0x22226E,
	0xDCB6, 0x22247A,
	0xDCB7, 0x222521,
	0xDCB8, 0x22285F,
	0xDCB9, 0x222523,
	0xDCBA, 0x22247C,
	0xDCBB, 0x22247D,
	0xDCBC, 0x22597D,
	0xDCBD, 0x214F3F,
	0xDCBE, 0x222854,
	0xDCBF, 0x214F48,
	0xDCC0, 0x214F4B,
	0xDCC1, 0x214F4A,
	0xDCC2, 0x22696A,
	0xDCC4, 0x215338,
	0xDCC5, 0x222856,
	0xDCC6, 0x214F4C,
	0xDCC7, 0x22285A,
	0xDCC8, 0x215D27,
	0xDCC9, 0x21616D,
	0xDCCA, 0x22535F,
	0xDCCB, 0x222861,
	0xDCCC, 0x22285E,
	0xDCCD, 0x222860,
	0xDCCF, 0x214F42,
	0xDCD1, 0x215335,
	0xDCD2, 0x222863,
	0xDCD3, 0x222D3A,
	0xDCD4, 0x21533E,
	0xDCD6, 0x222D42,
	0xDCD7, 0x226964,
	0xDCD8, 0x222D31,
	0xDCD9, 0x215343,
	0xDCDA, 0x222D38,
	0xDCDB, 0x21533F,
	0xDCDD, 0x222D3D,
	0xDCDE, 0x222D3E,
	0xDCDF, 0x215347,
	0xDCE0, 0x22535B,
	0xDCE2, 0x21534A,
	0xDCE3, 0x21635E,
	0xDCE4, 0x224458,
	0xDCE5, 0x222D43,
	0xDCE6, 0x222D34,
	0xDCE7, 0x223241,
	0xDCE8, 0x22323B,
	0xDCE9, 0x22596A,
	0xDCEA, 0x225357,
	0xDCEB, 0x223247,
	0xDCEC, 0x215C7C,
	0xDCED, 0x223248,
	0xDCEE, 0x215779,
	0xDCEF, 0x215822,
	0xDCF0, 0x223870,
	0xDCF1, 0x225977,
	0xDCF2, 0x22324E,
	0xDCF3, 0x21577A,
	0xDCF4, 0x223250,
	0xDCF5, 0x215824,
	0xDCF6, 0x225E7C,
	0xDCF7, 0x215821,
	0xDCF8, 0x21577E,
	0xDCF9, 0x217735,
	0xDCFA, 0x223238,
	0xDCFB, 0x222D35,
	0xDCFC, 0x223237,
	0xDCFD, 0x216961,
	0xDCFE, 0x224B34,
	0xDDA2, 0x223245,
	0xDDA3, 0x22627A,
	0xDDA5, 0x216A66,
	0xDDA6, 0x224677,
	0xDDA9, 0x215C77,
	0xDDAA, 0x224D49,
	0xDDAB, 0x216638,
	0xDDAC, 0x215D22,
	0xDDAD, 0x223871,
	0xDDAE, 0x215C7E,
	0xDDB0, 0x216A61,
	0xDDB1, 0x215D25,
	0xDDB3, 0x22386B,
	0xDDB4, 0x22386C,
	0xDDB5, 0x22597A,
	0xDDB6, 0x215D24,
	0xDDB7, 0x215C76,
	0xDDB8, 0x215C75,
	0xDDB9, 0x22385F,
	0xDDBA, 0x217B4D,
	0xDDBC, 0x21615D,
	0xDDBD, 0x223F52,
	0xDDBE, 0x223F54,
	0xDDBF, 0x223F55,
	0xDDC0, 0x22343E,
	0xDDC2, 0x21615C,
	0xDDC3, 0x223F53,
	0xDDC4, 0x216166,
	0xDDC5, 0x223F5A,
	0xDDC7, 0x216169,
	0xDDC8, 0x223F60,
	0xDDC9, 0x223F61,
	0xDDCA, 0x21616E,
	0xDDCB, 0x21616F,
	0xDDCC, 0x223F5E,
	0xDDCD, 0x216157,
	0xDDCE, 0x216158,
	0xDDCF, 0x223F43,
	0xDDD0, 0x223F68,
	0xDDD1, 0x21615B,
	0xDDD2, 0x223F45,
	0xDDD3, 0x21716A,
	0xDDD4, 0x216163,
	0xDDD5, 0x223F57,
	0xDDD7, 0x224656,
	0xDDD8, 0x22465D,
	0xDDD9, 0x22465E,
	0xDDDA, 0x224660,
	0xDDDB, 0x22596C,
	0xDDDD, 0x224667,
	0xDDDE, 0x22596F,
	0xDDDF, 0x224669,
	0xDDE0, 0x216637,
	0xDDE1, 0x21663D,
	0xDDE2, 0x21663B,
	0xDDE3, 0x224651,
	0xDDE4, 0x225358,
	0xDDE5, 0x22467A,
	0xDDE6, 0x216630,
	0xDDE7, 0x21663C,
	0xDDE8, 0x224D3F,
	0xDDE9, 0x224D40,
	0xDDEA, 0x224D44,
	0xDDEB, 0x217B46,
	0xDDED, 0x216A67,
	0xDDEE, 0x216A6B,
	0xDDEF, 0x216A5D,
	0xDDF0, 0x224D37,
	0xDDF1, 0x226F3F,
	0xDDF2, 0x224D35,
	0xDDF3, 0x224D3D,
	0xDDF4, 0x224D3E,
	0xDDF5, 0x224D33,
	0xDDF7, 0x225E6C,
	0xDDF8, 0x225345,
	0xDDF9, 0x217149,
	0xDDFB, 0x22535E,
	0xDDFC, 0x226C2D,
	0xDDFD, 0x22533D,
	0xDDFE, 0x217A34,
	0xDEA1, 0x225964,
	0xDEA2, 0x225336,
	0xDEA3, 0x216E5F,
	0xDEA4, 0x22534D,
	0xDEA5, 0x217221,
	0xDEA6, 0x217222,
	0xDEA7, 0x217223,
	0xDEA8, 0x22596D,
	0xDEA9, 0x217229,
	0xDEAA, 0x225E70,
	0xDEAB, 0x225867,
	0xDEAC, 0x217225,
	0xDEAD, 0x22696B,
	0xDEAE, 0x225E68,
	0xDEAF, 0x225E69,
	0xDEB0, 0x217533,
	0xDEB1, 0x217532,
	0xDEB2, 0x225E62,
	0xDEB3, 0x225E7E,
	0xDEB4, 0x21786C,
	0xDEB5, 0x21752D,
	0xDEB6, 0x225E7D,
	0xDEB7, 0x217736,
	0xDEB8, 0x226324,
	0xDEB9, 0x217734,
	0xDEBA, 0x217B23,
	0xDEBC, 0x22665F,
	0xDEBD, 0x226965,
	0xDEBE, 0x226C28,
	0xDEBF, 0x22696D,
	0xDEC0, 0x226C2C,
	0xDEC1, 0x217B21,
	0xDEC2, 0x226F42,
	0xDEC3, 0x21445C,
	0xDEC4, 0x21507B,
	0xDEC5, 0x22222B,
	0xDEC6, 0x216845,
	0xDEC7, 0x222C76,
	0xDEC8, 0x215055,
	0xDEC9, 0x215471,
	0xDECA, 0x215470,
	0xDECB, 0x215931,
	0xDECC, 0x214452,
	0xDECD, 0x222235,
	0xDECE, 0x21497C,
	0xDECF, 0x217353,
	0xDED1, 0x215A63,
	0xDED2, 0x224A45,
	0xDED3, 0x22267C,
	0xDED4, 0x222678,
	0xDED5, 0x214D6B,
	0xDED6, 0x214D6F,
	0xDED7, 0x21513E,
	0xDED8, 0x225060,
	0xDED9, 0x222A60,
	0xDEDA, 0x222F3C,
	0xDEDB, 0x222F3D,
	0xDEDC, 0x222F3A,
	0xDEDD, 0x223551,
	0xDEDE, 0x223C23,
	0xDEDF, 0x215A5E,
	0xDEE0, 0x215A70,
	0xDEE1, 0x223555,
	0xDEE2, 0x216878,
	0xDEE3, 0x22355D,
	0xDEE4, 0x215A69,
	0xDEE5, 0x22354C,
	0xDEE6, 0x215A6E,
	0xDEE7, 0x22355E,
	0xDEE8, 0x224A4F,
	0xDEE9, 0x223C25,
	0xDEEB, 0x223C22,
	0xDEEC, 0x216D2D,
	0xDEED, 0x223C2C,
	0xDEEF, 0x223B78,
	0xDEF0, 0x215F51,
	0xDEF1, 0x215F44,
	0xDEF2, 0x223C29,
	0xDEF3, 0x22615E,
	0xDEF4, 0x224334,
	0xDEF5, 0x22433C,
	0xDEF6, 0x22433E,
	0xDEF7, 0x224325,
	0xDEF8, 0x224B26,
	0xDEF9, 0x224331,
	0xDEFA, 0x224340,
	0xDEFB, 0x224A4E,
	0xDEFC, 0x226878,
	0xDEFD, 0x21687B,
	0xDEFE, 0x225056,
	0xDFA1, 0x216877,
	0xDFA2, 0x21764A,
	0xDFA3, 0x226163,
	0xDFA4, 0x216D2B,
	0xDFA5, 0x226B5B,
	0xDFA7, 0x225731,
	0xDFA8, 0x22572F,
	0xDFA9, 0x225C77,
	0xDFAA, 0x21736B,
	0xDFAB, 0x226550,
	0xDFAC, 0x226F2C,
	0xDFAD, 0x22707D,
	0xDFAE, 0x21445D,
	0xDFAF, 0x222376,
	0xDFB1, 0x21636F,
	0xDFB3, 0x214639,
	0xDFB4, 0x216C3E,
	0xDFB5, 0x214630,
	0xDFB6, 0x214631,
	0xDFB7, 0x21463D,
	0xDFB8, 0x21475D,
	0xDFBA, 0x21475C,
	0xDFBC, 0x224F6D,
	0xDFBD, 0x217B59,
	0xDFBE, 0x22233B,
	0xDFBF, 0x22653E,
	0xDFC0, 0x214945,
	0xDFC2, 0x222E3C,
	0xDFC6, 0x22255F,
	0xDFC8, 0x214C47,
	0xDFC9, 0x214C4D,
	0xDFCA, 0x22256F,
	0xDFCB, 0x214C50,
	0xDFCC, 0x217346,
	0xDFCD, 0x214C48,
	0xDFCE, 0x214C4E,
	0xDFCF, 0x222567,
	0xDFD2, 0x22293E,
	0xDFD3, 0x21503F,
	0xDFD5, 0x225648,
	0xDFD6, 0x21504A,
	0xDFD7, 0x21503C,
	0xDFD8, 0x224F61,
	0xDFD9, 0x216835,
	0xDFDA, 0x22294E,
	0xDFDC, 0x22564B,
	0xDFDD, 0x215048,
	0xDFDE, 0x21504B,
	0xDFE0, 0x22564E,
	0xDFE2, 0x225C4D,
	0xDFE3, 0x215049,
	0xDFE4, 0x215041,
	0xDFE6, 0x217043,
	0xDFE7, 0x222940,
	0xDFE8, 0x22294F,
	0xDFE9, 0x224934,
	0xDFEA, 0x222E37,
	0xDFEB, 0x216C31,
	0xDFEC, 0x215465,
	0xDFED, 0x21545B,
	0xDFEE, 0x222E38,
	0xDFEF, 0x224179,
	0xDFF1, 0x215466,
	0xDFF2, 0x222E3F,
	0xDFF3, 0x215463,
	0xDFF4, 0x22337A,
	0xDFF5, 0x216831,
	0xDFF6, 0x223A53,
	0xDFF7, 0x223A54,
	0xDFF9, 0x217A65,
	0xDFFA, 0x21594C,
	0xDFFB, 0x215943,
	0xDFFD, 0x223378,
	0xE0A1, 0x215455,
	0xE0A2, 0x215941,
	0xE0A3, 0x223374,
	0xE0A4, 0x223375,
	0xE0A6, 0x21594B,
	0xE0A7, 0x223421,
	0xE0A8, 0x215948,
	0xE0A9, 0x215E49,
	0xE0AA, 0x22417B,
	0xE0AB, 0x215E4A,
	0xE0AC, 0x215E53,
	0xE0AE, 0x223A52,
	0xE0AF, 0x223A55,
	0xE0B0, 0x215E4D,
	0xE0B1, 0x215E54,
	0xE0B2, 0x224222,
	0xE0B3, 0x223A4A,
	0xE0B4, 0x215E3D,
	0xE0B5, 0x21633F,
	0xE0B6, 0x21682E,
	0xE0B7, 0x22686D,
	0xE0B8, 0x215E47,
	0xE0B9, 0x215E57,
	0xE0BB, 0x216830,
	0xE0BC, 0x21634F,
	0xE0BD, 0x216832,
	0xE0BE, 0x216346,
	0xE0BF, 0x217A64,
	0xE0C1, 0x224177,
	0xE0C2, 0x216342,
	0xE0C3, 0x224175,
	0xE0C4, 0x224178,
	0xE0C5, 0x216349,
	0xE0C6, 0x21634E,
	0xE0C7, 0x224224,
	0xE0C8, 0x217045,
	0xE0C9, 0x224171,
	0xE0CA, 0x224225,
	0xE0CB, 0x216340,
	0xE0CD, 0x216348,
	0xE0CE, 0x217B79,
	0xE0D0, 0x216833,
	0xE0D1, 0x224930,
	0xE0D2, 0x224935,
	0xE0D3, 0x217963,
	0xE0D5, 0x216826,
	0xE0D6, 0x216827,
	0xE0D7, 0x22492E,
	0xE0D9, 0x224F66,
	0xE0DA, 0x216C33,
	0xE0DB, 0x216C3A,
	0xE0DC, 0x224F6B,
	0xE0DE, 0x217047,
	0xE0DF, 0x21703B,
	0xE0E0, 0x21763C,
	0xE0E1, 0x224F60,
	0xE0E3, 0x225C4F,
	0xE0E4, 0x21703F,
	0xE0E5, 0x217044,
	0xE0E6, 0x21703C,
	0xE0E9, 0x217348,
	0xE0EA, 0x225C4C,
	0xE0EC, 0x22707C,
	0xE0ED, 0x22212A,
	0xE0EE, 0x214760,
	0xE0EF, 0x222226,
	0xE0F0, 0x22342F,
	0xE0F1, 0x21495C,
	0xE0F2, 0x222571,
	0xE0F3, 0x21504C,
	0xE0F4, 0x215468,
	0xE0F5, 0x22342E,
	0xE0F6, 0x215950,
	0xE0F7, 0x225651,
	0xE0F8, 0x215E7C,
	0xE0F9, 0x222650,
	0xE0FA, 0x22264F,
	0xE0FB, 0x214D30,
	0xE0FC, 0x225C67,
	0xE0FD, 0x224977,
	0xE0FE, 0x21685E,
	0xE1A1, 0x215A29,
	0xE1A2, 0x223B56,
	0xE1A3, 0x21685F,
	0xE1A4, 0x21685B,
	0xE1A6, 0x216C58,
	0xE1A7, 0x214A26,
	0xE1A8, 0x222237,
	0xE1A9, 0x222360,
	0xE1AA, 0x214A23,
	0xE1AB, 0x21685A,
	0xE1AC, 0x222362,
	0xE1AD, 0x215537,
	0xE1AF, 0x214A24,
	0xE1B0, 0x215E75,
	0xE1B2, 0x22263F,
	0xE1B3, 0x222646,
	0xE1B5, 0x222642,
	0xE1B6, 0x214D28,
	0xE1B7, 0x214D29,
	0xE1B8, 0x222644,
	0xE1BA, 0x214D24,
	0xE1BB, 0x22566B,
	0xE1BC, 0x215072,
	0xE1BD, 0x225032,
	0xE1BE, 0x22297E,
	0xE1BF, 0x21597B,
	0xE1C0, 0x22502C,
	0xE1C1, 0x22347E,
	0xE1C2, 0x215A23,
	0xE1C3, 0x223521,
	0xE1C4, 0x223528,
	0xE1C5, 0x215A22,
	0xE1C6, 0x223477,
	0xE1C7, 0x215977,
	0xE1C8, 0x215979,
	0xE1C9, 0x217358,
	0xE1CB, 0x215E76,
	0xE1CC, 0x223B4A,
	0xE1CD, 0x224258,
	0xE1CE, 0x223B47,
	0xE1CF, 0x21636A,
	0xE1D0, 0x22496D,
	0xE1D1, 0x223B3F,
	0xE1D2, 0x223B41,
	0xE1D3, 0x224255,
	0xE1D4, 0x216369,
	0xE1D6, 0x224968,
	0xE1D7, 0x22502B,
	0xE1D8, 0x216C54,
	0xE1D9, 0x217552,
	0xE1DA, 0x225C66,
	0xE1DB, 0x217B5D,
	0xE1DC, 0x22212C,
	0xE1DD, 0x214A31,
	0xE1DE, 0x222656,
	0xE1DF, 0x215124,
	0xE1E0, 0x215126,
	0xE1E1, 0x215125,
	0xE1E2, 0x215A3A,
	0xE1E3, 0x215A36,
	0xE1E4, 0x215A3B,
	0xE1E5, 0x215F28,
	0xE1E6, 0x22426A,
	0xE1E7, 0x216C62,
	0xE1E8, 0x225721,
	0xE1E9, 0x217C68,
	0xE1EC, 0x222165,
	0xE1ED, 0x222263,
	0xE1EE, 0x217664,
	0xE1F0, 0x222463,
	0xE1F1, 0x222465,
	0xE1F2, 0x214E6E,
	0xE1F4, 0x222823,
	0xE1F5, 0x222C22,
	0xE1F6, 0x22584D,
	0xE1F7, 0x21523F,
	0xE1F8, 0x224470,
	0xE1F9, 0x223066,
	0xE1FA, 0x21565B,
	0xE1FB, 0x22306B,
	0xE1FC, 0x223069,
	0xE1FD, 0x22584C,
	0xE1FE, 0x223065,
	0xE2A1, 0x22306A,
	0xE2A2, 0x223726,
	0xE2A3, 0x215B79,
	0xE2A4, 0x217B66,
	0xE2A5, 0x22372A,
	0xE2A6, 0x22372E,
	0xE2A7, 0x223725,
	0xE2A8, 0x22693D,
	0xE2A9, 0x223D74,
	0xE2AB, 0x21605A,
	0xE2AE, 0x223D75,
	0xE2AF, 0x216963,
	0xE2B0, 0x224B71,
	0xE2B1, 0x216D65,
	0xE2B2, 0x225223,
	0xE2B3, 0x22584A,
	0xE2B4, 0x225D51,
	0xE2B5, 0x226B6B,
	0xE2B6, 0x214860,
	0xE2B7, 0x216841,
	0xE2B8, 0x21627D,
	0xE2B9, 0x216843,
	0xE2BC, 0x22605B,
	0xE2BD, 0x216322,
	0xE2BE, 0x226457,
	0xE2BF, 0x21627E,
	0xE2C0, 0x224153,
	0xE2C1, 0x216324,
	0xE2C2, 0x216766,
	0xE2C3, 0x216B71,
	0xE2C4, 0x22556A,
	0xE2C5, 0x216F75,
	0xE2C6, 0x21732A,
	0xE2C8, 0x217773,
	0xE2C9, 0x22677C,
	0xE2CA, 0x22677A,
	0xE2CB, 0x217950,
	0xE2CD, 0x226A65,
	0xE2CF, 0x22215A,
	0xE2D0, 0x22503E,
	0xE2D1, 0x22236D,
	0xE2D2, 0x214D36,
	0xE2D3, 0x222A3B,
	0xE2D4, 0x215078,
	0xE2D5, 0x22352D,
	0xE2D6, 0x215A2D,
	0xE2D7, 0x215A2E,
	0xE2D8, 0x22352F,
	0xE2D9, 0x216F34,
	0xE2DA, 0x224A23,
	0xE2DB, 0x22497B,
	0xE2DC, 0x22503C,
	0xE2DD, 0x22567C,
	0xE2DE, 0x225679,
	0xE2DF, 0x21747E,
	0xE2E1, 0x22215C,
	0xE2E2, 0x214825,
	0xE2E3, 0x21796D,
	0xE2E4, 0x216C75,
	0xE2E5, 0x22237B,
	0xE2E6, 0x224A3A,
	0xE2E7, 0x22237D,
	0xE2E8, 0x22237E,
	0xE2E9, 0x216422,
	0xE2EA, 0x215A47,
	0xE2EB, 0x216423,
	0xE2EC, 0x214A3A,
	0xE2ED, 0x222379,
	0xE2EE, 0x214A39,
	0xE2EF, 0x22265D,
	0xE2F0, 0x214D47,
	0xE2F1, 0x22265C,
	0xE2F2, 0x214D4F,
	0xE2F3, 0x214D44,
	0xE2F4, 0x222668,
	0xE2F5, 0x214D4D,
	0xE2F6, 0x214D4E,
	0xE2F7, 0x222661,
	0xE2F8, 0x22572A,
	0xE2F9, 0x214D4B,
	0xE2FA, 0x21686C,
	0xE2FB, 0x225C71,
	0xE2FC, 0x215F33,
	0xE2FD, 0x216427,
	0xE2FE, 0x222A4C,
	0xE3A1, 0x215135,
	0xE3A2, 0x223B63,
	0xE3A3, 0x215551,
	0xE3A4, 0x21554C,
	0xE3A5, 0x224A2E,
	0xE3A6, 0x222F29,
	0xE3A7, 0x222F2A,
	0xE3A8, 0x222F27,
	0xE3A9, 0x21554F,
	0xE3AA, 0x222F2C,
	0xE3AB, 0x215F2E,
	0xE3AC, 0x215A46,
	0xE3AD, 0x223542,
	0xE3AE, 0x223540,
	0xE3AF, 0x215A4A,
	0xE3B0, 0x215A4C,
	0xE3B1, 0x215A4F,
	0xE3B2, 0x215A42,
	0xE3B3, 0x216421,
	0xE3B4, 0x22504D,
	0xE3B5, 0x215F31,
	0xE3B6, 0x215F2F,
	0xE3B7, 0x215F34,
	0xE3B8, 0x215F3A,
	0xE3B9, 0x215F37,
	0xE3BA, 0x22426E,
	0xE3BB, 0x22426D,
	0xE3BC, 0x21686F,
	0xE3BD, 0x216C71,
	0xE3BE, 0x216C74,
	0xE3BF, 0x216C6D,
	0xE3C1, 0x217058,
	0xE3C2, 0x217837,
	0xE3C3, 0x214D3F,
	0xE3C4, 0x22643B,
	0xE3C5, 0x21536D,
	0xE3C6, 0x223A29,
	0xE3C7, 0x21757D,
	0xE3C8, 0x216268,
	0xE3C9, 0x216262,
	0xE3CA, 0x224141,
	0xE3CB, 0x226C59,
	0xE3CC, 0x216F64,
	0xE3CD, 0x225550,
	0xE3CE, 0x227166,
	0xE3CF, 0x22554F,
	0xE3D0, 0x225B54,
	0xE3D1, 0x225B57,
	0xE3D3, 0x225B58,
	0xE3D4, 0x225B5A,
	0xE3D5, 0x225B52,
	0xE3D6, 0x22603E,
	0xE3D7, 0x21757B,
	0xE3D8, 0x21775E,
	0xE3D9, 0x217760,
	0xE3DA, 0x217761,
	0xE3DB, 0x226A53,
	0xE3DE, 0x214D51,
	0xE3E0, 0x22225E,
	0xE3E1, 0x22225B,
	0xE3E2, 0x22225D,
	0xE3E3, 0x226B61,
	0xE3E4, 0x214A6B,
	0xE3E5, 0x214A6F,
	0xE3E6, 0x214A7D,
	0xE3E7, 0x214A71,
	0xE3E8, 0x214A72,
	0xE3EA, 0x214A79,
	0xE3EB, 0x214A7B,
	0xE3EC, 0x214A7A,
	0xE3ED, 0x223D31,
	0xE3EE, 0x222759,
	0xE3EF, 0x222755,
	0xE3F0, 0x222756,
	0xE3F1, 0x226568,
	0xE3F2, 0x217846,
	0xE3F3, 0x214E57,
	0xE3F4, 0x214E55,
	0xE3F6, 0x214E61,
	0xE3F7, 0x214E60,
	0xE3F8, 0x226224,
	0xE3F9, 0x222751,
	0xE3FA, 0x222752,
	0xE3FB, 0x214E45,
	0xE3FC, 0x214E4F,
	0xE3FD, 0x214E5E,
	0xE3FE, 0x21563D,
	0xE4A1, 0x21522A,
	0xE4A2, 0x21522B,
	0xE4A3, 0x21517E,
	0xE4A4, 0x21564B,
	0xE4A5, 0x223D43,
	0xE4A6, 0x222B67,
	0xE4A7, 0x222B59,
	0xE4A8, 0x222B5A,
	0xE4A9, 0x215230,
	0xE4AA, 0x215231,
	0xE4AB, 0x225825,
	0xE4AC, 0x21522E,
	0xE4AD, 0x21522F,
	0xE4AE, 0x222B5C,
	0xE4AF, 0x21765F,
	0xE4B0, 0x224B39,
	0xE4B1, 0x216D5B,
	0xE4B2, 0x222B58,
	0xE4B3, 0x223033,
	0xE4B4, 0x223032,
	0xE4B5, 0x22364D,
	0xE4B6, 0x225164,
	0xE4B7, 0x223038,
	0xE4B8, 0x215642,
	0xE4B9, 0x21564E,
	0xE4BB, 0x22303A,
	0xE4BC, 0x22303D,
	0xE4BD, 0x223029,
	0xE4BE, 0x215B5F,
	0xE4BF, 0x215B53,
	0xE4C0, 0x215B5D,
	0xE4C1, 0x215B58,
	0xE4C2, 0x21765C,
	0xE4C3, 0x215B6C,
	0xE4C4, 0x223651,
	0xE4C5, 0x217133,
	0xE4C6, 0x215B6D,
	0xE4C7, 0x223657,
	0xE4C8, 0x215B4B,
	0xE4C9, 0x21765A,
	0xE4CA, 0x223645,
	0xE4CB, 0x223655,
	0xE4CC, 0x215B57,
	0xE4CD, 0x223D36,
	0xE4CE, 0x21603A,
	0xE4CF, 0x216048,
	0xE4D0, 0x223D4B,
	0xE4D1, 0x22443F,
	0xE4D2, 0x21604D,
	0xE4D3, 0x224B4F,
	0xE4D4, 0x223D4F,
	0xE4D5, 0x21602D,
	0xE4D6, 0x21602F,
	0xE4D7, 0x216033,
	0xE4D8, 0x21604A,
	0xE4D9, 0x22723E,
	0xE4DA, 0x224432,
	0xE4DB, 0x216468,
	0xE4DC, 0x226B62,
	0xE4DD, 0x224B4B,
	0xE4DE, 0x22617B,
	0xE4DF, 0x216467,
	0xE4E0, 0x216472,
	0xE4E1, 0x224436,
	0xE4E3, 0x22443A,
	0xE4E4, 0x225167,
	0xE4E5, 0x216473,
	0xE4E6, 0x22443E,
	0xE4E7, 0x22442C,
	0xE4E8, 0x216462,
	0xE4E9, 0x22442E,
	0xE4EA, 0x22514B,
	0xE4EB, 0x226569,
	0xE4EC, 0x217841,
	0xE4EE, 0x21694F,
	0xE4EF, 0x224B49,
	0xE4F0, 0x216951,
	0xE4F1, 0x224B47,
	0xE4F2, 0x217976,
	0xE4F3, 0x226223,
	0xE4F4, 0x216953,
	0xE4F5, 0x224B3D,
	0xE4F6, 0x216941,
	0xE4F7, 0x225149,
	0xE4F8, 0x225148,
	0xE4F9, 0x22514A,
	0xE4FA, 0x216D52,
	0xE4FB, 0x225154,
	0xE4FC, 0x216D4A,
	0xE4FD, 0x216D55,
	0xE4FE, 0x217842,
	0xE5A1, 0x22582D,
	0xE5A2, 0x21712D,
	0xE5A3, 0x217130,
	0xE5A4, 0x217131,
	0xE5A5, 0x217127,
	0xE5A6, 0x21742C,
	0xE5A7, 0x21742F,
	0xE5A9, 0x217425,
	0xE5AA, 0x217429,
	0xE5AB, 0x217843,
	0xE5AC, 0x22656E,
	0xE5AD, 0x217840,
	0xE5AE, 0x226933,
	0xE5AF, 0x22692A,
	0xE5B0, 0x22703D,
	0xE5B1, 0x217C60,
	0xE5B3, 0x222154,
	0xE5B4, 0x222639,
	0xE5B5, 0x222638,
	0xE5B6, 0x21506B,
	0xE5B7, 0x21552A,
	0xE5B8, 0x223E30,
	0xE5B9, 0x217A55,
	0xE5BA, 0x21687A,
	0xE5BB, 0x216855,
	0xE5BC, 0x216C4E,
	0xE5BD, 0x225A40,
	0xE5BE, 0x217051,
	0xE5BF, 0x225F6B,
	0xE5C0, 0x225F56,
	0xE5C2, 0x22286E,
	0xE5C3, 0x222871,
	0xE5C4, 0x215361,
	0xE5C5, 0x222D56,
	0xE5C6, 0x215364,
	0xE5C7, 0x21774D,
	0xE5C8, 0x21535E,
	0xE5C9, 0x215D5D,
	0xE5CA, 0x215365,
	0xE5CB, 0x215852,
	0xE5CC, 0x223333,
	0xE5CD, 0x223966,
	0xE5CE, 0x217C49,
	0xE5CF, 0x223967,
	0xE5D0, 0x215D56,
	0xE5D1, 0x215D62,
	0xE5D2, 0x22396A,
	0xE5D3, 0x21624D,
	0xE5D4, 0x216251,
	0xE5D5, 0x224072,
	0xE5D6, 0x224074,
	0xE5D7, 0x224827,
	0xE5D8, 0x216736,
	0xE5D9, 0x224825,
	0xE5DA, 0x216731,
	0xE5DB, 0x216F4D,
	0xE5DC, 0x216B40,
	0xE5DD, 0x216B45,
	0xE5DE, 0x216B47,
	0xE5DF, 0x21706F,
	0xE5E0, 0x217258,
	0xE5E1, 0x217563,
	0xE5E2, 0x217566,
	0xE5E3, 0x21774F,
	0xE5E4, 0x21774E,
	0xE5E5, 0x217932,
	0xE5E7, 0x215A31,
	0xE5E8, 0x222A3E,
	0xE5E9, 0x223B58,
	0xE5EA, 0x222156,
	0xE5EB, 0x215046,
	0xE5EC, 0x21552E,
	0xE5ED, 0x223476,
	0xE5EE, 0x215E6C,
	0xE5EF, 0x224967,
	0xE5F0, 0x217354,
	0xE5F1, 0x217A7E,
	0xE5F2, 0x222E7B,
	0xE5F3, 0x214D3A,
	0xE5F4, 0x21507C,
	0xE5F5, 0x22385C,
	0xE5F6, 0x215F24,
	0xE5F7, 0x226E54,
	0xE5F9, 0x214772,
	0xE5FA, 0x21476E,
	0xE5FB, 0x214970,
	0xE5FC, 0x216C4B,
	0xE5FD, 0x216849,
	0xE5FE, 0x21496D,
	0xE6A1, 0x222355,
	0xE6A2, 0x214C70,
	0xE6A3, 0x223A77,
	0xE6A4, 0x21496C,
	0xE6A5, 0x214971,
	0xE6A6, 0x214C73,
	0xE6A7, 0x222629,
	0xE6A8, 0x214C71,
	0xE6A9, 0x214C6D,
	0xE6AA, 0x214C65,
	0xE6AB, 0x223458,
	0xE6AC, 0x216C4D,
	0xE6AD, 0x222968,
	0xE6AE, 0x226D4A,
	0xE6AF, 0x21505D,
	0xE6B0, 0x21505B,
	0xE6B2, 0x21547D,
	0xE6B3, 0x21547E,
	0xE6B4, 0x215E6A,
	0xE6B5, 0x216C49,
	0xE6B6, 0x215472,
	0xE6B7, 0x21547A,
	0xE6B8, 0x215477,
	0xE6B9, 0x215963,
	0xE6BA, 0x223454,
	0xE6BB, 0x215968,
	0xE6BC, 0x223453,
	0xE6BD, 0x215964,
	0xE6BE, 0x215965,
	0xE6BF, 0x216C4A,
	0xE6C1, 0x216365,
	0xE6C2, 0x215E69,
	0xE6C3, 0x215E65,
	0xE6C4, 0x223A7A,
	0xE6C5, 0x216363,
	0xE6C6, 0x224959,
	0xE6C7, 0x216368,
	0xE6C8, 0x22565E,
	0xE6C9, 0x217350,
	0xE6CA, 0x22423E,
	0xE6CB, 0x22495C,
	0xE6CC, 0x21684C,
	0xE6CD, 0x22565C,
	0xE6CE, 0x21684A,
	0xE6CF, 0x216847,
	0xE6D0, 0x21684B,
	0xE6D1, 0x224952,
	0xE6D2, 0x216C48,
	0xE6D3, 0x22565B,
	0xE6D4, 0x225662,
	0xE6D5, 0x225C5C,
	0xE6D6, 0x217351,
	0xE6D7, 0x217967,
	0xE6D8, 0x222234,
	0xE6DA, 0x214977,
	0xE6DB, 0x222637,
	0xE6DC, 0x215E6B,
	0xE6DD, 0x21444E,
	0xE6DE, 0x21444F,
	0xE6DF, 0x222636,
	0xE6E0, 0x225573,
	0xE6E1, 0x216F78,
	0xE6E2, 0x216F7D,
	0xE6E3, 0x226A6D,
	0xE6E4, 0x217C52,
	0xE6E5, 0x216F7A,
	0xE6E6, 0x225577,
	0xE6E7, 0x217C27,
	0xE6E8, 0x226E4D,
	0xE6E9, 0x21732E,
	0xE6EA, 0x217D47,
	0xE6EB, 0x226459,
	0xE6EC, 0x22645C,
	0xE6ED, 0x226460,
	0xE6EE, 0x226C6A,
	0xE6EF, 0x226A71,
	0xE6F0, 0x217951,
	0xE6F1, 0x226C6B,
	0xE6F2, 0x226A6F,
	0xE6F3, 0x226A70,
	0xE6F4, 0x217B45,
	0xE6F5, 0x226C69,
	0xE6F6, 0x226E4B,
	0xE6F7, 0x217D38,
	0xE6F8, 0x227223,
	0xE6FA, 0x21527D,
	0xE6FB, 0x215277,
	0xE6FC, 0x21527B,
	0xE6FD, 0x222C6C,
	0xE6FE, 0x226B75,
	0xE7A1, 0x215749,
	0xE7A2, 0x215747,
	0xE7A3, 0x223178,
	0xE7A4, 0x22382B,
	0xE7A5, 0x215C5D,
	0xE7A6, 0x215C5E,
	0xE7A7, 0x217170,
	0xE7A8, 0x215C56,
	0xE7A9, 0x215C57,
	0xE7AC, 0x223F21,
	0xE7AD, 0x216142,
	0xE7AE, 0x22457D,
	0xE7AF, 0x224627,
	0xE7B0, 0x22457C,
	0xE7B1, 0x216A39,
	0xE7B2, 0x216A3F,
	0xE7B3, 0x224C75,
	0xE7B5, 0x224C73,
	0xE7B6, 0x216E43,
	0xE7B7, 0x216A47,
	0xE7B8, 0x224C78,
	0xE7B9, 0x224C6C,
	0xE7BA, 0x216A36,
	0xE7BB, 0x216A46,
	0xE7BC, 0x216E44,
	0xE7BD, 0x22526F,
	0xE7BE, 0x216E46,
	0xE7BF, 0x216E45,
	0xE7C0, 0x22625E,
	0xE7C1, 0x225273,
	0xE7C2, 0x225274,
	0xE7C3, 0x225275,
	0xE7C4, 0x225944,
	0xE7C5, 0x225270,
	0xE7C6, 0x21716F,
	0xE7C7, 0x21716E,
	0xE7C8, 0x22593C,
	0xE7C9, 0x21716D,
	0xE7CA, 0x225E3D,
	0xE7CB, 0x217168,
	0xE7CC, 0x217169,
	0xE7CD, 0x217A2A,
	0xE7CE, 0x21746F,
	0xE7CF, 0x217471,
	0xE7D0, 0x217467,
	0xE7D1, 0x217465,
	0xE7D2, 0x21746C,
	0xE7D3, 0x226B77,
	0xE7D4, 0x217723,
	0xE7D5, 0x217725,
	0xE7D6, 0x217C23,
	0xE7D7, 0x22695A,
	0xE7D8, 0x22663C,
	0xE7D9, 0x22663E,
	0xE7DA, 0x22712F,
	0xE7DC, 0x216D6B,
	0xE7DE, 0x222834,
	0xE7DF, 0x215854,
	0xE7E0, 0x222265,
	0xE7E1, 0x217143,
	0xE7E2, 0x224477,
	0xE7E3, 0x22282C,
	0xE7E4, 0x214E74,
	0xE7E5, 0x214E73,
	0xE7E6, 0x222C2A,
	0xE7E7, 0x217979,
	0xE7E8, 0x215242,
	0xE7E9, 0x215248,
	0xE7EA, 0x215247,
	0xE7EC, 0x222C2B,
	0xE7ED, 0x22306E,
	0xE7EE, 0x22306D,
	0xE7EF, 0x216762,
	0xE7F0, 0x215B7D,
	0xE7F1, 0x223073,
	0xE7F2, 0x223071,
	0xE7F3, 0x215662,
	0xE7F4, 0x21784D,
	0xE7F5, 0x216531,
	0xE7F6, 0x22522B,
	0xE7F7, 0x21605E,
	0xE7F8, 0x216533,
	0xE7F9, 0x216067,
	0xE7FA, 0x216061,
	0xE7FB, 0x216068,
	0xE7FC, 0x223E22,
	0xE7FD, 0x223D7E,
	0xE7FE, 0x223E21,
	0xE8A1, 0x216066,
	0xE8A2, 0x223E25,
	0xE8A3, 0x216530,
	0xE8A4, 0x216534,
	0xE8A5, 0x22447A,
	0xE8A6, 0x21652D,
	0xE8A7, 0x216532,
	0xE8A8, 0x217440,
	0xE8A9, 0x216968,
	0xE8AA, 0x216D69,
	0xE8AB, 0x217142,
	0xE8AC, 0x217A78,
	0xE8AD, 0x216D6A,
	0xE8AE, 0x22522E,
	0xE8AF, 0x22522A,
	0xE8B0, 0x216D67,
	0xE8B1, 0x217146,
	0xE8B2, 0x217441,
	0xE8B3, 0x21743E,
	0xE8B4, 0x225D55,
	0xE8B5, 0x217666,
	0xE8B6, 0x217C3C,
	0xE8B7, 0x22693E,
	0xE8B8, 0x22644E,
	0xE8B9, 0x226770,
	0xE8BA, 0x217949,
	0xE8BB, 0x222442,
	0xE8BC, 0x214A61,
	0xE8BD, 0x214A5D,
	0xE8BE, 0x222443,
	0xE8BF, 0x224B21,
	0xE8C0, 0x226923,
	0xE8C1, 0x214E2D,
	0xE8C2, 0x214E3A,
	0xE8C3, 0x214E2B,
	0xE8C4, 0x22273A,
	0xE8C6, 0x214E36,
	0xE8C7, 0x223C56,
	0xE8C8, 0x216D41,
	0xE8C9, 0x215B40,
	0xE8CA, 0x214E27,
	0xE8CB, 0x214E2C,
	0xE8CC, 0x214E39,
	0xE8CD, 0x222B37,
	0xE8CE, 0x217376,
	0xE8CF, 0x222B25,
	0xE8D0, 0x226921,
	0xE8D1, 0x215161,
	0xE8D2, 0x21516C,
	0xE8D3, 0x226924,
	0xE8D4, 0x21516D,
	0xE8D5, 0x222B2C,
	0xE8D6, 0x215166,
	0xE8D7, 0x222B2E,
	0xE8D8, 0x21516F,
	0xE8D9, 0x215B3D,
	0xE8DA, 0x222B43,
	0xE8DB, 0x215168,
	0xE8DC, 0x21516E,
	0xE8DD, 0x22655D,
	0xE8DE, 0x222A7C,
	0xE8DF, 0x225D24,
	0xE8E0, 0x222F5E,
	0xE8E1, 0x222F5F,
	0xE8E2, 0x223C55,
	0xE8E3, 0x217123,
	0xE8E4, 0x222F6A,
	0xE8E5, 0x21644F,
	0xE8E6, 0x222F6B,
	0xE8E7, 0x224A74,
	0xE8E8, 0x215B38,
	0xE8E9, 0x222F6D,
	0xE8EB, 0x217075,
	0xE8EC, 0x215630,
	0xE8ED, 0x217375,
	0xE8EE, 0x215629,
	0xE8EF, 0x226F30,
	0xE8F1, 0x222F5D,
	0xE8F2, 0x215621,
	0xE8F3, 0x215B31,
	0xE8F4, 0x223624,
	0xE8F5, 0x223622,
	0xE8F6, 0x223625,
	0xE8F7, 0x215B30,
	0xE8F8, 0x223628,
	0xE8F9, 0x217A72,
	0xE8FA, 0x215F7D,
	0xE8FB, 0x223C6B,
	0xE8FC, 0x21783D,
	0xE8FD, 0x225127,
	0xE8FE, 0x215F72,
	0xE9A1, 0x226F31,
	0xE9A2, 0x224364,
	0xE9A3, 0x223C6D,
	0xE9A4, 0x216D37,
	0xE9A5, 0x22435A,
	0xE9A6, 0x215F75,
	0xE9A7, 0x223C5C,
	0xE9A8, 0x224354,
	0xE9A9, 0x224358,
	0xE9AA, 0x216449,
	0xE9AB, 0x224359,
	0xE9AC, 0x216455,
	0xE9AD, 0x217D23,
	0xE9AE, 0x216450,
	0xE9B1, 0x224365,
	0xE9B2, 0x224366,
	0xE9B3, 0x216935,
	0xE9B4, 0x217973,
	0xE9B5, 0x21783E,
	0xE9B6, 0x224A67,
	0xE9B7, 0x226B5F,
	0xE9B8, 0x22434F,
	0xE9B9, 0x216456,
	0xE9BA, 0x216453,
	0xE9BB, 0x21692D,
	0xE9BC, 0x224A6F,
	0xE9BD, 0x21692F,
	0xE9BE, 0x216930,
	0xE9BF, 0x216934,
	0xE9C0, 0x224A78,
	0xE9C1, 0x224A63,
	0xE9C2, 0x216929,
	0xE9C3, 0x224A7A,
	0xE9C4, 0x21764E,
	0xE9C5, 0x216928,
	0xE9C6, 0x226557,
	0xE9C7, 0x224A70,
	0xE9C8, 0x22507A,
	0xE9C9, 0x217377,
	0xE9CA, 0x216D42,
	0xE9CB, 0x225073,
	0xE9CC, 0x225131,
	0xE9CD, 0x226560,
	0xE9CE, 0x225123,
	0xE9CF, 0x21707A,
	0xE9D0, 0x22574F,
	0xE9D1, 0x21737B,
	0xE9D2, 0x22575C,
	0xE9D3, 0x225753,
	0xE9D4, 0x217121,
	0xE9D5, 0x225D2B,
	0xE9D6, 0x21783F,
	0xE9D7, 0x217073,
	0xE9D8, 0x225755,
	0xE9D9, 0x217078,
	0xE9DA, 0x226563,
	0xE9DB, 0x225D30,
	0xE9DC, 0x21737A,
	0xE9DD, 0x225D22,
	0xE9DE, 0x217379,
	0xE9E0, 0x216527,
	0xE9E2, 0x214E3F,
	0xE9E3, 0x222B47,
	0xE9E4, 0x216D46,
	0xE9E5, 0x222B48,
	0xE9E6, 0x224B2E,
	0xE9E7, 0x21737D,
	0xE9E8, 0x223640,
	0xE9E9, 0x22576E,
	0xE9EA, 0x224423,
	0xE9EB, 0x217658,
	0xE9EC, 0x22576D,
	0xE9ED, 0x215847,
	0xE9EE, 0x215D53,
	0xE9F0, 0x216248,
	0xE9F1, 0x226F55,
	0xE9F2, 0x224065,
	0xE9F3, 0x21624A,
	0xE9F4, 0x22406D,
	0xE9F6, 0x226E34,
	0xE9F7, 0x224064,
	0xE9F8, 0x216726,
	0xE9F9, 0x216727,
	0xE9FA, 0x224821,
	0xE9FB, 0x22477E,
	0xE9FC, 0x216B3B,
	0xE9FD, 0x216F46,
	0xE9FE, 0x216F49,
	0xEAA1, 0x216F44,
	0xEAA2, 0x216F48,
	0xEAA3, 0x217254,
	0xEAA4, 0x226370,
	0xEAA5, 0x21792E,
	0xEAA7, 0x222670,
	0xEAA8, 0x224A3E,
	0xEAA9, 0x215A52,
	0xEAAA, 0x215F3C,
	0xEAAB, 0x216429,
	0xEAAC, 0x216428,
	0xEAAD, 0x22427B,
	0xEAAE, 0x22427C,
	0xEAAF, 0x224A3D,
	0xEAB0, 0x216A56,
	0xEAB1, 0x217148,
	0xEAB2, 0x223121,
	0xEAB3, 0x224526,
	0xEAB4, 0x225D5E,
	0xEAB5, 0x225D5C,
	0xEAB6, 0x226236,
	0xEAB8, 0x22224F,
	0xEAB9, 0x22224E,
	0xEABA, 0x222439,
	0xEABB, 0x214E22,
	0xEABC, 0x217071,
	0xEABD, 0x214E3B,
	0xEABE, 0x22272B,
	0xEABF, 0x214E21,
	0xEAC0, 0x214D7D,
	0xEAC1, 0x222772,
	0xEAC2, 0x215157,
	0xEAC3, 0x222A76,
	0xEAC4, 0x222A77,
	0xEAC5, 0x215155,
	0xEAC6, 0x222A6C,
	0xEAC7, 0x216D34,
	0xEAC8, 0x215752,
	0xEAC9, 0x222F56,
	0xEACA, 0x217070,
	0xEACB, 0x215572,
	0xEACC, 0x21556D,
	0xEACD, 0x21643D,
	0xEACE, 0x22356C,
	0xEAD0, 0x215F63,
	0xEAD1, 0x216441,
	0xEAD2, 0x224346,
	0xEAD3, 0x217370,
	0xEAD4, 0x216925,
	0xEAD5, 0x22573F,
	0xEAD6, 0x226167,
	0xEAD7, 0x21764C,
	0xEAD8, 0x217971,
	0xEAD9, 0x217A6F,
	0xEADA, 0x216235,
	0xEADB, 0x224050,
	0xEADC, 0x22404E,
	0xEADD, 0x216234,
	0xEADE, 0x22635F,
	0xEADF, 0x216674,
	0xEAE0, 0x216677,
	0xEAE1, 0x226C41,
	0xEAE2, 0x216B34,
	0xEAE3, 0x225455,
	0xEAE4, 0x224E3B,
	0xEAE6, 0x225457,
	0xEAE7, 0x217557,
	0xEAE8, 0x224037,
	0xEAE9, 0x217546,
	0xEAEA, 0x224E2C,
	0xEAEB, 0x226E22,
	0xEAEC, 0x217236,
	0xEAED, 0x225F48,
	0xEAEE, 0x21773C,
	0xEAEF, 0x22667E,
	0xEAF0, 0x222B7D,
	0xEAF2, 0x21484A,
	0xEAF4, 0x21523D,
	0xEAF5, 0x223721,
	0xEAF6, 0x223724,
	0xEAF7, 0x216057,
	0xEAF8, 0x223D70,
	0xEAF9, 0x224469,
	0xEAFB, 0x216960,
	0xEAFC, 0x215554,
	0xEAFD, 0x22354A,
	0xEAFE, 0x223B77,
	0xEBA1, 0x224A55,
	0xEBA2, 0x217365,
	0xEBA3, 0x215753,
	0xEBA5, 0x223D2A,
	0xEBA6, 0x21645D,
	0xEBA7, 0x225140,
	0xEBA8, 0x224426,
	0xEBA9, 0x217126,
	0xEBAA, 0x226566,
	0xEBAB, 0x225773,
	0xEBAC, 0x226D55,
	0xEBAD, 0x22215F,
	0xEBAE, 0x222258,
	0xEBAF, 0x222449,
	0xEBB0, 0x22244A,
	0xEBB1, 0x222B4E,
	0xEBB2, 0x21602A,
	0xEBB3, 0x215638,
	0xEBB4, 0x223643,
	0xEBB5, 0x21693B,
	0xEBB7, 0x215A79,
	0xEBB9, 0x217849,
	0xEBBA, 0x216526,
	0xEBBB, 0x216D62,
	0xEBBC, 0x21523B,
	0xEBBD, 0x225367,
	0xEBBE, 0x214748,
	0xEBC0, 0x222478,
	0xEBC1, 0x214B3A,
	0xEBC3, 0x222733,
	0xEBC5, 0x214F33,
	0xEBC6, 0x214F35,
	0xEBC7, 0x222850,
	0xEBC8, 0x214F37,
	0xEBCA, 0x217972,
	0xEBCD, 0x217A2F,
	0xEBCE, 0x21532E,
	0xEBCF, 0x222C7C,
	0xEBD0, 0x215024,
	0xEBD1, 0x222D22,
	0xEBD2, 0x222D2A,
	0xEBD3, 0x222D28,
	0xEBD4, 0x222A7B,
	0xEBD5, 0x215332,
	0xEBD6, 0x22384C,
	0xEBD7, 0x21575A,
	0xEBD8, 0x21575F,
	0xEBD9, 0x21575E,
	0xEBDA, 0x217526,
	0xEBDD, 0x215766,
	0xEBDE, 0x215575,
	0xEBE0, 0x215D48,
	0xEBE1, 0x224647,
	0xEBE2, 0x223850,
	0xEBE3, 0x22384F,
	0xEBE4, 0x223849,
	0xEBE7, 0x216151,
	0xEBE8, 0x216152,
	0xEBE9, 0x216153,
	0xEBEC, 0x216621,
	0xEBED, 0x22463A,
	0xEBEE, 0x22463D,
	0xEBF0, 0x224D2D,
	0xEBF3, 0x22422D,
	0xEBF4, 0x224240,
	0xEBF5, 0x216A52,
	0xEBF6, 0x216A55,
	0xEBF7, 0x21772D,
	0xEBF8, 0x216D5A,
	0xEBF9, 0x225327,
	0xEBFB, 0x225E57,
	0xEBFC, 0x21764D,
	0xEBFD, 0x225E58,
	0xEBFE, 0x225E55,
	0xECA2, 0x225955,
	0xECA3, 0x217656,
	0xECA4, 0x22363C,
	0xECA5, 0x223C7D,
	0xECA6, 0x22437D,
	0xECA7, 0x22437B,
	0xECA8, 0x217124,
	0xECA9, 0x224F35,
	0xECAA, 0x216B6C,
	0xECAB, 0x217629,
	0xECAC, 0x21794E,
	0xECAD, 0x226C62,
	0xECB0, 0x224268,
	0xECB1, 0x21755F,
	0xECB2, 0x225F4B,
	0xECB3, 0x215F59,
	0xECB4, 0x22702E,
	0xECB5, 0x217A6E,
	0xECB6, 0x214D75,
	0xECB7, 0x222F51,
	0xECB8, 0x222F53,
	0xECB9, 0x222F52,
	0xECBA, 0x215B22,
	0xECBB, 0x215B23,
	0xECBC, 0x223C43,
	0xECBD, 0x216922,
	0xECBE, 0x21647B,
	0xECBF, 0x224453,
	0xECC0, 0x217136,
	0xECC4, 0x222B6E,
	0xECC5, 0x215232,
	0xECC6, 0x222B71,
	0xECC7, 0x225839,
	0xECC8, 0x21564F,
	0xECC9, 0x223674,
	0xECCA, 0x223678,
	0xECCB, 0x21713E,
	0xECCC, 0x223D5E,
	0xECCD, 0x223D61,
	0xECCF, 0x21647A,
	0xECD0, 0x216523,
	0xECD2, 0x224459,
	0xECD4, 0x22445A,
	0xECD7, 0x22517A,
	0xECD8, 0x225171,
	0xECD9, 0x216D61,
	0xECDA, 0x22516E,
	0xECDB, 0x217439,
	0xECDC, 0x22583B,
	0xECDD, 0x217431,
	0xECDE, 0x226229,
	0xECDF, 0x226B68,
	0xECE0, 0x217D46,
	0xECE2, 0x217662,
	0xECE3, 0x21647C,
	0xECE4, 0x21713B,
	0xECE5, 0x214D53,
	0xECE6, 0x222671,
	0xECE7, 0x222A54,
	0xECE8, 0x215A53,
	0xECE9, 0x215F3D,
	0xECEB, 0x214F24,
	0xECEC, 0x215269,
	0xECED, 0x21526A,
	0xECEE, 0x223939,
	0xECEF, 0x22314C,
	0xECF0, 0x22314D,
	0xECF1, 0x215731,
	0xECF2, 0x226170,
	0xECF3, 0x215730,
	0xECF4, 0x21572B,
	0xECF5, 0x21697C,
	0xECF6, 0x223760,
	0xECF7, 0x216559,
	0xECF8, 0x217453,
	0xECF9, 0x224C41,
	0xECFA, 0x225253,
	0xECFB, 0x217452,
	0xECFC, 0x217B6B,
	0xECFD, 0x222377,
	0xECFE, 0x222378,
	0xEDA1, 0x226154,
	0xEDA2, 0x222E7E,
	0xEDA3, 0x222F21,
	0xEDA4, 0x222F22,
	0xEDA5, 0x222F23,
	0xEDA6, 0x215542,
	0xEDA7, 0x215543,
	0xEDA8, 0x224A2A,
	0xEDA9, 0x216426,
	0xEDAA, 0x216425,
	0xEDAB, 0x216C66,
	0xEDAC, 0x217056,
	0xEDAD, 0x225723,
	0xEDAE, 0x217360,
	0xEDAF, 0x217642,
	0xEDB0, 0x22722A,
	0xEDB2, 0x214857,
	0xEDB3, 0x22274F,
	0xEDB4, 0x225D3B,
	0xEDB5, 0x223D2C,
	0xEDB6, 0x217450,
	0xEDB7, 0x22283C,
	0xEDB8, 0x224C36,
	0xEDB9, 0x222C53,
	0xEDBA, 0x223E53,
	0xEDBC, 0x222C4D,
	0xEDBD, 0x21514B,
	0xEDBE, 0x215725,
	0xEDC0, 0x215721,
	0xEDC2, 0x21797D,
	0xEDC3, 0x226B70,
	0xEDC4, 0x215727,
	0xEDC6, 0x215724,
	0xEDC7, 0x22313D,
	0xEDC8, 0x22313C,
	0xEDC9, 0x223145,
	0xEDCA, 0x215C3F,
	0xEDCB, 0x223E4D,
	0xEDCC, 0x223E4A,
	0xEDCD, 0x225D70,
	0xEDCE, 0x22375C,
	0xEDCF, 0x22375E,
	0xEDD1, 0x22375B,
	0xEDD3, 0x217156,
	0xEDD4, 0x216557,
	0xEDD5, 0x22454B,
	0xEDD6, 0x22454A,
	0xEDD7, 0x225871,
	0xEDD8, 0x224552,
	0xEDD9, 0x21697B,
	0xEDDA, 0x224C33,
	0xEDDC, 0x224C3B,
	0xEDDD, 0x22524E,
	0xEDDF, 0x225252,
	0xEDE0, 0x217155,
	0xEDE1, 0x225D75,
	0xEDE2, 0x225D76,
	0xEDE3, 0x21744F,
	0xEDE4, 0x226244,
	0xEDE5, 0x22694C,
	0xEDE6, 0x22662E,
	0xEDE7, 0x22662B,
	0xEDE8, 0x226E7B,
	0xEDE9, 0x224155,
	0xEDEA, 0x22613C,
	0xEDEB, 0x226862,
	0xEDEC, 0x222839,
	0xEDED, 0x222C44,
	0xEDEF, 0x21525D,
	0xEDF0, 0x215263,
	0xEDF1, 0x222C42,
	0xEDF2, 0x223139,
	0xEDF3, 0x22313A,
	0xEDF4, 0x223138,
	0xEDF5, 0x22374D,
	0xEDF6, 0x223753,
	0xEDF7, 0x223755,
	0xEDF8, 0x215C3B,
	0xEDF9, 0x216545,
	0xEDFA, 0x21766F,
	0xEDFB, 0x223E3F,
	0xEDFD, 0x224543,
	0xEDFE, 0x21654C,
	0xEEA1, 0x21654D,
	0xEEA2, 0x21654B,
	0xEEA3, 0x216974,
	0xEEA4, 0x225244,
	0xEEA5, 0x216973,
	0xEEA6, 0x224C2F,
	0xEEA7, 0x216D78,
	0xEEA8, 0x216D79,
	0xEEA9, 0x217151,
	0xEEAA, 0x21714F,
	0xEEAB, 0x217448,
	0xEEAC, 0x225D66,
	0xEEAD, 0x21766C,
	0xEEAE, 0x22246D,
	0xEEAF, 0x222833,
	0xEEB0, 0x21524D,
	0xEEB1, 0x21524E,
	0xEEB2, 0x222C3D,
	0xEEB3, 0x223124,
	0xEEB4, 0x223E32,
	0xEEB5, 0x22452A,
	0xEEB7, 0x222C6E,
	0xEEB8, 0x22317E,
	0xEEB9, 0x21574E,
	0xEEBA, 0x224046,
	0xEEBB, 0x224631,
	0xEEBC, 0x226646,
	0xEEBE, 0x217171,
	0xEEBF, 0x217C65,
	0xEEC0, 0x225E50,
	0xEEC1, 0x215675,
	0xEEC2, 0x21714E,
	0xEEC3, 0x226F47,
	0xEEC5, 0x222D62,
	0xEEC6, 0x222D61,
	0xEEC7, 0x21585F,
	0xEEC8, 0x21585D,
	0xEEC9, 0x223345,
	0xEECA, 0x223A25,
	0xEECB, 0x215D6D,
	0xEECC, 0x223A21,
	0xEECD, 0x225B38,
	0xEECE, 0x215D6A,
	0xEECF, 0x223A22,
	0xEED1, 0x22412E,
	0xEED2, 0x21674C,
	0xEED3, 0x216261,
	0xEED4, 0x21625F,
	0xEED5, 0x224129,
	0xEED6, 0x224137,
	0xEED7, 0x224136,
	0xEED8, 0x22412B,
	0xEED9, 0x224131,
	0xEEDA, 0x224837,
	0xEEDB, 0x224838,
	0xEEDC, 0x21673F,
	0xEEDD, 0x224839,
	0xEEDF, 0x216742,
	0xEEE0, 0x216741,
	0xEEE1, 0x22483B,
	0xEEE2, 0x224841,
	0xEEE3, 0x224840,
	0xEEE4, 0x21674E,
	0xEEE5, 0x217C4C,
	0xEEE6, 0x224836,
	0xEEE7, 0x21674A,
	0xEEE8, 0x224834,
	0xEEE9, 0x21674B,
	0xEEEA, 0x22483D,
	0xEEEB, 0x21674D,
	0xEEEC, 0x217B39,
	0xEEED, 0x216B50,
	0xEEEE, 0x224E63,
	0xEEEF, 0x224E62,
	0xEEF0, 0x224E65,
	0xEEF1, 0x224E6E,
	0xEEF2, 0x225532,
	0xEEF3, 0x217A4D,
	0xEEF5, 0x217B38,
	0xEEF7, 0x224E67,
	0xEEF8, 0x226426,
	0xEEF9, 0x216B54,
	0xEEFA, 0x225539,
	0xEEFB, 0x224E7D,
	0xEEFC, 0x226A41,
	0xEEFD, 0x216B56,
	0xEEFE, 0x224E6C,
	0xEFA1, 0x226756,
	0xEFA2, 0x224E68,
	0xEFA3, 0x217268,
	0xEFA4, 0x224E69,
	0xEFA5, 0x22483C,
	0xEFA6, 0x226A35,
	0xEFA7, 0x216B58,
	0xEFA8, 0x224E6D,
	0xEFA9, 0x226A47,
	0xEFAA, 0x225B32,
	0xEFAB, 0x225533,
	0xEFAC, 0x217941,
	0xEFAE, 0x216F62,
	0xEFAF, 0x22553A,
	0xEFB0, 0x22553C,
	0xEFB1, 0x216F5F,
	0xEFB2, 0x225538,
	0xEFB6, 0x22552D,
	0xEFB7, 0x225534,
	0xEFB8, 0x225540,
	0xEFB9, 0x225B36,
	0xEFBA, 0x225B2F,
	0xEFBC, 0x225B34,
	0xEFBE, 0x225B37,
	0xEFBF, 0x21726C,
	0xEFC0, 0x21726D,
	0xEFC3, 0x225B2D,
	0xEFC4, 0x225B2E,
	0xEFC5, 0x21726E,
	0xEFC6, 0x217571,
	0xEFC7, 0x225F7E,
	0xEFC8, 0x226024,
	0xEFC9, 0x217579,
	0xEFCA, 0x225F7C,
	0xEFCB, 0x226428,
	0xEFCC, 0x217577,
	0xEFCE, 0x217940,
	0xEFCF, 0x21793F,
	0xEFD2, 0x226754,
	0xEFD3, 0x21775B,
	0xEFD4, 0x217B3B,
	0xEFD6, 0x22642A,
	0xEFD7, 0x21775A,
	0xEFD8, 0x22637D,
	0xEFD9, 0x226E36,
	0xEFDA, 0x21793D,
	0xEFDB, 0x21793A,
	0xEFDC, 0x21793B,
	0xEFDD, 0x21793E,
	0xEFDE, 0x22674C,
	0xEFDF, 0x217938,
	0xEFE0, 0x22674D,
	0xEFE1, 0x217936,
	0xEFE2, 0x226A3A,
	0xEFE4, 0x226A43,
	0xEFE6, 0x226A36,
	0xEFE7, 0x227142,
	0xEFE8, 0x226A38,
	0xEFEA, 0x226752,
	0xEFEB, 0x226A3F,
	0xEFEC, 0x226E38,
	0xEFED, 0x217B3A,
	0xEFEE, 0x226C4D,
	0xEFF0, 0x217C4B,
	0xEFF1, 0x217574,
	0xEFF2, 0x222C4A,
	0xEFF3, 0x223E48,
	0xEFF4, 0x216756,
	0xEFF5, 0x222C5B,
	0xEFF6, 0x223154,
	0xEFF7, 0x215733,
	0xEFF8, 0x223150,
	0xEFFA, 0x215E77,
	0xEFFB, 0x223E5C,
	0xEFFC, 0x223E5A,
	0xEFFD, 0x216563,
	0xEFFE, 0x216561,
	0xF0A1, 0x22525A,
	0xF0A2, 0x216E29,
	0xF0A3, 0x217672,
	0xF0A4, 0x217634,
	0xF0A5, 0x217776,
	0xF0A6, 0x226D66,
	0xF0A7, 0x215257,
	0xF0A8, 0x215C33,
	0xF0A9, 0x216077,
	0xF0AA, 0x22453B,
	0xF0AB, 0x225D64,
	0xF0AC, 0x22307D,
	0xF0AD, 0x215C24,
	0xF0AE, 0x214B2C,
	0xF0AF, 0x21676D,
	0xF0B0, 0x216B79,
	0xF0B1, 0x225634,
	0xF0B2, 0x217028,
	0xF0B3, 0x217337,
	0xF0B4, 0x22685D,
	0xF0B5, 0x227227,
	0xF0B6, 0x225C35,
	0xF0B7, 0x225C3A,
	0xF0B8, 0x217C5A,
	0xF0B9, 0x226129,
	0xF0BA, 0x226E6E,
	0xF0BB, 0x22612C,
	0xF0BC, 0x22612E,
	0xF0BD, 0x217D4A,
	0xF0BE, 0x22647A,
	0xF0BF, 0x22723D,
	0xF0C0, 0x217827,
	0xF0C1, 0x226525,
	0xF0C2, 0x226F7E,
	0xF0C3, 0x226479,
	0xF0C4, 0x217959,
	0xF0C6, 0x21795B,
	0xF0C7, 0x22685A,
	0xF0C8, 0x217958,
	0xF0C9, 0x226B2C,
	0xF0CA, 0x226B35,
	0xF0CD, 0x226B3B,
	0xF0CE, 0x217B4F,
	0xF0CF, 0x226D22,
	0xF0D0, 0x217D45,
	0xF0D1, 0x217C2E,
	0xF0D2, 0x226E67,
	0xF0D3, 0x226F71,
	0xF0D4, 0x226F79,
	0xF0D5, 0x226F7A,
	0xF0D6, 0x226F74,
	0xF0D8, 0x217C7A,
	0xF0D9, 0x217D49,
	0xF0DB, 0x22246F,
	0xF0DC, 0x226238,
	0xF0DD, 0x21766A,
	0xF0DE, 0x214E78,
	0xF0E0, 0x215253,
	0xF0E1, 0x21566C,
	0xF0E2, 0x224531,
	0xF0E3, 0x215671,
	0xF0E5, 0x215673,
	0xF0E6, 0x223126,
	0xF0E8, 0x215670,
	0xF0EA, 0x215C32,
	0xF0EB, 0x21606F,
	0xF0EC, 0x217442,
	0xF0ED, 0x223E36,
	0xF0EE, 0x223E39,
	0xF0EF, 0x225D63,
	0xF0F0, 0x223E33,
	0xF0F1, 0x22452F,
	0xF0F2, 0x21653B,
	0xF0F3, 0x224532,
	0xF0F4, 0x21653D,
	0xF0F5, 0x224535,
	0xF0F6, 0x216537,
	0xF0F7, 0x225D62,
	0xF0F8, 0x224C24,
	0xF0F9, 0x225238,
	0xF0FA, 0x224C27,
	0xF0FB, 0x225237,
	0xF0FD, 0x224C25,
	0xF0FE, 0x225239,
	0xF1A2, 0x22585C,
	0xF1A3, 0x216D72,
	0xF1A4, 0x216D6C,
	0xF1A6, 0x225858,
	0xF1A7, 0x22585F,
	0xF1A8, 0x226D62,
	0xF1A9, 0x22585D,
	0xF1AA, 0x225D60,
	0xF1AB, 0x217B69,
	0xF1AC, 0x22585B,
	0xF1AE, 0x217A79,
	0xF1B0, 0x226237,
	0xF1B1, 0x217669,
	0xF1B2, 0x217C62,
	0xF1B4, 0x22383B,
	0xF1B5, 0x223E60,
	0xF1B6, 0x222845,
	0xF1B7, 0x214F29,
	0xF1B8, 0x222C60,
	0xF1B9, 0x223159,
	0xF1BA, 0x21573A,
	0xF1BB, 0x215C45,
	0xF1BC, 0x217A22,
	0xF1BD, 0x216565,
	0xF1BE, 0x224C53,
	0xF1BF, 0x224C51,
	0xF1C0, 0x22587C,
	0xF1C1, 0x22525D,
	0xF1C3, 0x222D4F,
	0xF1C4, 0x223276,
	0xF1C5, 0x215832,
	0xF1C6, 0x223279,
	0xF1C7, 0x215831,
	0xF1C8, 0x223938,
	0xF1C9, 0x217876,
	0xF1CA, 0x224031,
	0xF1CB, 0x224030,
	0xF1CC, 0x224035,
	0xF1CD, 0x225F40,
	0xF1CE, 0x22473B,
	0xF1CF, 0x22667B,
	0xF1D0, 0x226344,
	0xF1D1, 0x224D7E,
	0xF1D2, 0x216A7D,
	0xF1D3, 0x224E25,
	0xF1D4, 0x216A7C,
	0xF1D5, 0x224E23,
	0xF1D6, 0x224E28,
	0xF1D7, 0x217234,
	0xF1D8, 0x225431,
	0xF1D9, 0x216E71,
	0xF1DA, 0x217544,
	0xF1DB, 0x216E73,
	0xF1DC, 0x217A3B,
	0xF1DD, 0x217233,
	0xF1DE, 0x217542,
	0xF1DF, 0x225F43,
	0xF1E0, 0x226977,
	0xF1E1, 0x22713A,
	0xF1E2, 0x214674,
	0xF1E3, 0x215328,
	0xF1E4, 0x224C29,
	0xF1E5, 0x216078,
	0xF1E6, 0x215264,
	0xF1E7, 0x214855,
	0xF1E8, 0x222C75,
	0xF1E9, 0x22322A,
	0xF1EA, 0x215C65,
	0xF1EE, 0x216E4B,
	0xF1EF, 0x225E54,
	0xF1F0, 0x225952,
	0xF1F1, 0x217176,
	0xF1F3, 0x216146,
	0xF1F4, 0x22284A,
	0xF1F5, 0x223847,
	0xF1F6, 0x215C67,
	0xF1F7, 0x22695F,
	0xF1F8, 0x216147,
	0xF1F9, 0x226268,
	0xF1FA, 0x217477,
	0xF1FB, 0x21617D,
	0xF1FC, 0x224151,
	0xF1FD, 0x224866,
	0xF1FE, 0x224864,
	0xF2A1, 0x216F6E,
	0xF2A2, 0x216F70,
	0xF2A3, 0x217159,
	0xF2A4, 0x225561,
	0xF2A5, 0x217323,
	0xF2A6, 0x21776F,
	0xF2A7, 0x217770,
	0xF2A8, 0x22717C,
	0xF2A9, 0x226A5D,
	0xF2AA, 0x226773,
	0xF2AB, 0x217B42,
	0xF2AD, 0x217C74,
	0xF2AF, 0x215825,
	0xF2B0, 0x222868,
	0xF2B1, 0x226336,
	0xF2B2, 0x22666E,
	0xF2B3, 0x21534E,
	0xF2B4, 0x222D49,
	0xF2B5, 0x21534D,
	0xF2B6, 0x22325C,
	0xF2B7, 0x22325E,
	0xF2B8, 0x223264,
	0xF2B9, 0x21664A,
	0xF2BA, 0x217A39,
	0xF2BB, 0x22326A,
	0xF2BC, 0x21582C,
	0xF2BD, 0x215827,
	0xF2BE, 0x215828,
	0xF2BF, 0x21582A,
	0xF2C0, 0x215D2C,
	0xF2C1, 0x215D2D,
	0xF2C2, 0x215D2E,
	0xF2C3, 0x217B24,
	0xF2C4, 0x223928,
	0xF2C5, 0x223927,
	0xF2C6, 0x215D31,
	0xF2C7, 0x215D32,
	0xF2C8, 0x215D33,
	0xF2C9, 0x226669,
	0xF2CA, 0x22392E,
	0xF2CB, 0x224022,
	0xF2CC, 0x22472D,
	0xF2CD, 0x217737,
	0xF2CE, 0x216173,
	0xF2CF, 0x225A39,
	0xF2D0, 0x216177,
	0xF2D1, 0x216642,
	0xF2D2, 0x216178,
	0xF2D3, 0x226971,
	0xF2D4, 0x216171,
	0xF2D5, 0x223F75,
	0xF2D6, 0x224025,
	0xF2D7, 0x216649,
	0xF2D8, 0x216644,
	0xF2D9, 0x224731,
	0xF2DA, 0x216643,
	0xF2DB, 0x21664B,
	0xF2DC, 0x224736,
	0xF2DD, 0x224733,
	0xF2DE, 0x224D5D,
	0xF2DF, 0x216A6E,
	0xF2E0, 0x224D62,
	0xF2E1, 0x216A70,
	0xF2E2, 0x224D61,
	0xF2E3, 0x224D79,
	0xF2E4, 0x224D69,
	0xF2E5, 0x21753F,
	0xF2E6, 0x216A71,
	0xF2E7, 0x224D72,
	0xF2E8, 0x216A75,
	0xF2E9, 0x216A74,
	0xF2EA, 0x216A6C,
	0xF2EB, 0x216E61,
	0xF2EC, 0x216A6F,
	0xF2EE, 0x226972,
	0xF2EF, 0x225425,
	0xF2F0, 0x216E64,
	0xF2F2, 0x216E6A,
	0xF2F3, 0x225421,
	0xF2F5, 0x216E6B,
	0xF2F6, 0x225369,
	0xF2F7, 0x21753D,
	0xF2F8, 0x22536A,
	0xF2F9, 0x216E68,
	0xF2FA, 0x225423,
	0xF2FB, 0x225A2C,
	0xF2FC, 0x225F35,
	0xF2FE, 0x21753A,
	0xF3A1, 0x21753B,
	0xF3A2, 0x225A2E,
	0xF3A3, 0x225A35,
	0xF3A4, 0x225F28,
	0xF3A5, 0x225A2B,
	0xF3A6, 0x21722A,
	0xF3A7, 0x21753C,
	0xF3A8, 0x22632D,
	0xF3A9, 0x225F2B,
	0xF3AA, 0x225F2D,
	0xF3AB, 0x217539,
	0xF3AC, 0x217540,
	0xF3AD, 0x226333,
	0xF3AE, 0x225F3C,
	0xF3AF, 0x217538,
	0xF3B0, 0x217537,
	0xF3B1, 0x225F37,
	0xF3B2, 0x22632A,
	0xF3B3, 0x22632C,
	0xF3B4, 0x21773A,
	0xF3B6, 0x226975,
	0xF3B7, 0x226974,
	0xF3B8, 0x217875,
	0xF3B9, 0x226672,
	0xF3BA, 0x226C31,
	0xF3BB, 0x217B26,
	0xF3BC, 0x217C67,
	0xF3BD, 0x22704C,
	0xF3BE, 0x21484F,
	0xF3BF, 0x217A2D,
	0xF3C0, 0x217474,
	0xF3C1, 0x225E4E,
	0xF3C2, 0x21576B,
	0xF3C3, 0x214F2A,
	0xF3C4, 0x215275,
	0xF3C5, 0x223166,
	0xF3C6, 0x217161,
	0xF3C7, 0x223162,
	0xF3C8, 0x21656A,
	0xF3C9, 0x223167,
	0xF3CA, 0x22377A,
	0xF3CB, 0x223165,
	0xF3CC, 0x223E63,
	0xF3CD, 0x22377E,
	0xF3CE, 0x223777,
	0xF3CF, 0x215C4B,
	0xF3D0, 0x215C4D,
	0xF3D1, 0x223779,
	0xF3D2, 0x215C46,
	0xF3D3, 0x223771,
	0xF3D4, 0x223774,
	0xF3D5, 0x223775,
	0xF3D6, 0x22712B,
	0xF3D7, 0x215C4C,
	0xF3D8, 0x223E69,
	0xF3D9, 0x225E30,
	0xF3DA, 0x223E6A,
	0xF3DB, 0x216A2A,
	0xF3DC, 0x223E66,
	0xF3DD, 0x216A2E,
	0xF3DE, 0x216568,
	0xF3DF, 0x216569,
	0xF3E2, 0x224570,
	0xF3E3, 0x224573,
	0xF3E4, 0x224C59,
	0xF3E5, 0x225E2A,
	0xF3E6, 0x22525F,
	0xF3E7, 0x216A2F,
	0xF3E8, 0x225261,
	0xF3E9, 0x216A2C,
	0xF3EA, 0x226D69,
	0xF3EB, 0x224C5F,
	0xF3EC, 0x21767A,
	0xF3ED, 0x224C56,
	0xF3EF, 0x217677,
	0xF3F0, 0x216E30,
	0xF3F1, 0x21767B,
	0xF3F2, 0x216E33,
	0xF3F3, 0x216E35,
	0xF3F4, 0x225926,
	0xF3F5, 0x225929,
	0xF3F6, 0x225928,
	0xF3F7, 0x217165,
	0xF3F8, 0x22592D,
	0xF3F9, 0x21745A,
	0xF3FA, 0x217458,
	0xF3FC, 0x225E28,
	0xF3FD, 0x227046,
	0xF3FE, 0x225E2F,
	0xF4A1, 0x226251,
	0xF4A2, 0x217679,
	0xF4A3, 0x226254,
	0xF4A4, 0x21785B,
	0xF4A5, 0x217B6D,
	0xF4A6, 0x21785E,
	0xF4A7, 0x214F3B,
	0xF4A8, 0x223234,
	0xF4A9, 0x215C6F,
	0xF4AA, 0x216D5D,
	0xF4AB, 0x215769,
	0xF4AC, 0x223272,
	0xF4AD, 0x222D2C,
	0xF4AE, 0x215334,
	0xF4AF, 0x22664E,
	0xF4B1, 0x223235,
	0xF4B2, 0x21576E,
	0xF4B3, 0x21576D,
	0xF4B4, 0x223857,
	0xF4B5, 0x226D73,
	0xF4B6, 0x223858,
	0xF4B7, 0x22385A,
	0xF4B9, 0x22464A,
	0xF4BA, 0x224649,
	0xF4BB, 0x216A5B,
	0xF4BC, 0x22532F,
	0xF4BD, 0x225E5E,
	0xF4BE, 0x22626C,
	0xF4BF, 0x226962,
	0xF4C0, 0x22327C,
	0xF4C1, 0x216654,
	0xF4C2, 0x215D36,
	0xF4C3, 0x216651,
	0xF4C4, 0x21664D,
	0xF4C5, 0x217879,
	0xF4C6, 0x223839,
	0xF4C7, 0x224634,
	0xF4C8, 0x224635,
	0xF4C9, 0x216E49,
	0xF4CA, 0x22527B,
	0xF4CB, 0x217172,
	0xF4CC, 0x214F27,
	0xF4CD, 0x215567,
	0xF4CE, 0x22316C,
	0xF4D1, 0x223E6C,
	0xF4D2, 0x223E6B,
	0xF4D3, 0x224579,
	0xF4D4, 0x224C67,
	0xF4D5, 0x216A33,
	0xF4D6, 0x217462,
	0xF4D8, 0x225269,
	0xF4DA, 0x225268,
	0xF4DB, 0x225267,
	0xF4DC, 0x225935,
	0xF4DD, 0x225E3C,
	0xF4DE, 0x214862,
	0xF4DF, 0x216924,
	0xF4E0, 0x215322,
	0xF4E1, 0x215C63,
	0xF4E2, 0x216145,
	0xF4E3, 0x224D26,
	0xF4E4, 0x216A4A,
	0xF4E5, 0x225323,
	0xF4E6, 0x216E4A,
	0xF4E7, 0x217175,
	0xF4E8, 0x217475,
	0xF4E9, 0x21484E,
	0xF4EA, 0x225E4B,
	0xF4EB, 0x224C7C,
	0xF4EC, 0x224C7D,
	0xF4ED, 0x225E46,
	0xF4EE, 0x227130,
	0xF4EF, 0x21702B,
	0xF4F0, 0x217960,
	0xF4F1, 0x215359,
	0xF4F2, 0x224053,
	0xF4F3, 0x22476A,
	0xF4F4, 0x224764,
	0xF4F5, 0x22715E,
	0xF4F6, 0x215D4F,
	0xF4F7, 0x216F35,
	0xF4F8, 0x223322,
	0xF4F9, 0x215D47,
	0xF4FA, 0x21536B,
	0xF4FB, 0x223342,
	0xF4FC, 0x223343,
	0xF4FD, 0x223344,
	0xF4FE, 0x224125,
	0xF5A1, 0x224127,
	0xF5A2, 0x224124,
	0xF5A4, 0x21673D,
	0xF5A5, 0x224833,
	0xF5A6, 0x217D3C,
	0xF5A7, 0x227160,
	0xF5A8, 0x224E5B,
	0xF5A9, 0x216B4E,
	0xF5AA, 0x224E5C,
	0xF5AC, 0x225525,
	0xF5AD, 0x225B27,
	0xF5AE, 0x225B29,
	0xF5AF, 0x225B28,
	0xF5B0, 0x225F72,
	0xF5B1, 0x217569,
	0xF5B2, 0x22637C,
	0xF5B3, 0x22674B,
	0xF5B4, 0x217934,
	0xF5B5, 0x22637B,
	0xF5B6, 0x226A32,
	0xF5B7, 0x217A4A,
	0xF5B8, 0x217B34,
	0xF5B9, 0x214B49,
	0xF5BA, 0x226D37,
	0xF5BB, 0x217A46,
	0xF5BC, 0x224778,
	0xF5BD, 0x224E48,
	0xF5BE, 0x217744,
	0xF5BF, 0x22636E,
	0xF5C0, 0x223329,
	0xF5C1, 0x22395C,
	0xF5C2, 0x223959,
	0xF5C3, 0x215D52,
	0xF5C4, 0x225F6A,
	0xF5C5, 0x22405A,
	0xF5C6, 0x224060,
	0xF5C7, 0x216243,
	0xF5C8, 0x226E2F,
	0xF5C9, 0x216240,
	0xF5CA, 0x22405C,
	0xF5CB, 0x216246,
	0xF5CC, 0x216247,
	0xF5CD, 0x22476F,
	0xF5CE, 0x21792C,
	0xF5CF, 0x217749,
	0xF5D0, 0x224774,
	0xF5D1, 0x226E2E,
	0xF5D2, 0x217B31,
	0xF5D3, 0x216721,
	0xF5D4, 0x224E3F,
	0xF5D5, 0x224E43,
	0xF5D6, 0x225468,
	0xF5D7, 0x216F3A,
	0xF5D8, 0x216F3E,
	0xF5D9, 0x217B78,
	0xF5DA, 0x225460,
	0xF5DB, 0x22545D,
	0xF5DC, 0x217B77,
	0xF5DE, 0x225A6C,
	0xF5E0, 0x217250,
	0xF5E1, 0x225A70,
	0xF5E2, 0x21724C,
	0xF5E3, 0x217559,
	0xF5E4, 0x225A71,
	0xF5E5, 0x21724E,
	0xF5E6, 0x217D29,
	0xF5E7, 0x217745,
	0xF5E8, 0x21755C,
	0xF5E9, 0x226E2C,
	0xF5EA, 0x21792A,
	0xF5EB, 0x217927,
	0xF5EC, 0x22673F,
	0xF5ED, 0x21792D,
	0xF5EE, 0x217A48,
	0xF5EF, 0x217D3B,
	0xF5F0, 0x226E2D,
	0xF5F1, 0x226E30,
	0xF5F2, 0x22715F,
	0xF5F3, 0x227051,
	0xF5F4, 0x222524,
	0xF5F5, 0x216230,
	0xF5F6, 0x21666E,
	0xF5F7, 0x224760,
	0xF5F8, 0x22635C,
	0xF5F9, 0x225F63,
	0xF5FA, 0x215A7C,
	0xF5FB, 0x223949,
	0xF5FC, 0x21773D,
	0xF5FD, 0x22403A,
	0xF5FE, 0x224749,
	0xF6A1, 0x224744,
	0xF6A2, 0x224E30,
	0xF6A3, 0x226722,
	0xF6A4, 0x21666B,
	0xF6A5, 0x226352,
	0xF6A6, 0x225559,
	0xF6A7, 0x215D7C,
	0xF6A8, 0x217C70,
	0xF6A9, 0x216277,
	0xF6AA, 0x216F67,
	0xF6AB, 0x217B7E,
	0xF6AC, 0x225557,
	0xF6AD, 0x217279,
	0xF6AE, 0x217274,
	0xF6AF, 0x217946,
	0xF6B0, 0x217C72,
	0xF6B1, 0x217A50,
	0xF6B2, 0x217C21,
	0xF6B3, 0x226141,
	0xF6B4, 0x217A5F,
	0xF6B5, 0x226B4C,
	0xF6B6, 0x226B49,
	0xF6B7, 0x217B54,
	0xF6B8, 0x217B55,
	0xF6B9, 0x217C31,
	0xF6BA, 0x217C32,
	0xF6BB, 0x217C7E,
	0xF6BC, 0x224875,
	0xF6BD, 0x22613D,
	0xF6BE, 0x227154,
	0xF6BF, 0x214F63,
	0xF6C0, 0x22334A,
	0xF6C1, 0x216755,
	0xF6C2, 0x22485B,
	0xF6C3, 0x216B65,
	0xF6C4, 0x21766D,
	0xF6C5, 0x226F4F,
	0xF6C6, 0x224E6F,
	0xF6C7, 0x217D3E,
	0xF6C8, 0x22553E,
	0xF6C9, 0x217942,
	0xF6CA, 0x22602C,
	0xF6CB, 0x226758,
	0xF6CC, 0x22602A,
	0xF6CE, 0x227058,
	0xF6CF, 0x217026,
	0xF6D0, 0x225626,
	0xF6D1, 0x226F69,
	0xF6D4, 0x217D41,
	0xF6D5, 0x21715B,
	0xF6D6, 0x225C29,
	0xF6D7, 0x217C78,
	0xF6D8, 0x225C2A,
	0xF6D9, 0x217630,
	0xF6DA, 0x226076,
	0xF6DB, 0x21762F,
	0xF6DC, 0x226078,
	0xF6DD, 0x22714B,
	0xF6DE, 0x21762E,
	0xF6DF, 0x22683D,
	0xF6E0, 0x226F66,
	0xF6E1, 0x226471,
	0xF6E2, 0x22723C,
	0xF6E3, 0x217C2B,
	0xF6E4, 0x226E5B,
	0xF6E5, 0x226C79,
	0xF6E6, 0x226E5F,
	0xF6E7, 0x217824,
	0xF6E8, 0x21777E,
	0xF6E9, 0x22646D,
	0xF6EA, 0x217822,
	0xF6EB, 0x217956,
	0xF6EC, 0x226834,
	0xF6ED, 0x226835,
	0xF6EE, 0x226843,
	0xF6EF, 0x226838,
	0xF6F0, 0x217955,
	0xF6F2, 0x22683A,
	0xF6F3, 0x22683B,
	0xF6F4, 0x217957,
	0xF6F6, 0x22683C,
	0xF6F8, 0x226A79,
	0xF6F9, 0x217D40,
	0xF6FA, 0x217A5A,
	0xF6FB, 0x226A7C,
	0xF6FC, 0x226B26,
	0xF7A1, 0x226E61,
	0xF7A2, 0x217B4B,
	0xF7A3, 0x226C7A,
	0xF7A4, 0x217B4C,
	0xF7A5, 0x226C7B,
	0xF7A6, 0x226E5C,
	0xF7A7, 0x217C2C,
	0xF7A8, 0x226E58,
	0xF7A9, 0x217C2D,
	0xF7AC, 0x217C59,
	0xF7AD, 0x217C57,
	0xF7AE, 0x226F65,
	0xF7AF, 0x227065,
	0xF7B0, 0x216B67,
	0xF7B1, 0x216B68,
	0xF7B2, 0x217C22,
	0xF7B4, 0x225B62,
	0xF7B5, 0x217D36,
	0xF7B6, 0x226448,
	0xF7B7, 0x217768,
	0xF7BA, 0x224F42,
	0xF7BB, 0x216B74,
	0xF7BC, 0x216F7E,
	0xF7BD, 0x226D2A,
	0xF7C0, 0x217331,
	0xF7C1, 0x217778,
	0xF7C2, 0x226463,
	0xF7C3, 0x217B48,
	0xF7C4, 0x22682E,
	0xF7C5, 0x217D2F,
	0xF7C6, 0x227062,
	0xF7C7, 0x217C56,
	0xF7C8, 0x217024,
	0xF7C9, 0x225624,
	0xF7CA, 0x217C77,
	0xF7CB, 0x21777C,
	0xF7CC, 0x226075,
	0xF7CD, 0x21777D,
	0xF7CE, 0x217B4A,
	0xF7CF, 0x217B43,
	0xF7D0, 0x217C50,
	0xF7D1, 0x217775,
	0xF7D2, 0x217C25,
	0xF7D3, 0x226E45,
	0xF7D4, 0x22334C,
	0xF7D5, 0x21676C,
	0xF7D6, 0x216B75,
	0xF7D7, 0x217022,
	0xF7D8, 0x22557D,
	0xF7D9, 0x217332,
	0xF7DA, 0x217333,
	0xF7DB, 0x225B7C,
	0xF7DC, 0x226465,
	0xF7DE, 0x217C76,
	0xF7DF, 0x226F63,
	0xF7E0, 0x217D30,
	0xF7E1, 0x216B7B,
	0xF7E2, 0x21702C,
	0xF7E3, 0x225E4A,
	0xF7E4, 0x21676E,
	0xF7E5, 0x225C3D,
	0xF7E6, 0x225C3B,
	0xF7E7, 0x217633,
	0xF7E8, 0x21795D,
	0xF7E9, 0x21793C,
	0xF7EA, 0x217B51,
	0xF7EB, 0x217C5B,
	0xF7EC, 0x217638,
	0xF7ED, 0x217636,
	0xF7EE, 0x217637,
	0xF7EF, 0x217828,
	0xF7F0, 0x22652C,
	0xF7F2, 0x217D42,
	0xF7F3, 0x226B44,
	0xF7F4, 0x226B42,
	0xF7F5, 0x227026,
	0xF7F6, 0x217B52,
	0xF7F7, 0x226140,
	0xF7F8, 0x21782A,
	0xF7F9, 0x217A5E,
	0xF7FA, 0x217C30,
	0xF7FB, 0x22702B,
	0xF7FC, 0x225C44,
	0xF7FD, 0x217639
};
