/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 *	Copyright(c)	1997, Sun Microsystems, Inc.
 *	All rights reserved.
 */

#ifndef _GB2312_BIG5_H_

#define _GB2312_BIG5_H_

#include "public_struc.h"

#define BIG5MAX	6752

table_t gb_big5_tab[BIG5MAX] = {
	0xA1A1, 0xA140,
	0xA1A2, 0xA142,
	0xA1A3, 0xA143,
	0xA1A4, 0xA14F,
	0xA1A5, 0xA1C2,
	0xA1A7, 0xA14C,
	0xA1A8, 0xA1B2,
	0xA1AA, 0xA277,
	0xA1AB, 0xA1E3,
	0xA1AC, 0xA1FC,
	0xA1AD, 0xA14B,
	0xA1AE, 0xA1A5,
	0xA1AF, 0xA1A6,
	0xA1B0, 0xA1A7,
	0xA1B1, 0xA1A8,
	0xA1B2, 0xA165,
	0xA1B3, 0xA166,
	0xA1B4, 0xA171,
	0xA1B5, 0xA172,
	0xA1B6, 0xA16D,
	0xA1B7, 0xA16E,
	0xA1B8, 0xA175,
	0xA1B9, 0xA176,
	0xA1BA, 0xA179,
	0xA1BB, 0xA17A,
	0xA1BE, 0xA169,
	0xA1BF, 0xA16A,
	0xA1C0, 0xA1D3,
	0xA1C1, 0xA1D1,
	0xA1C2, 0xA1D2,
	0xA1C3, 0xA14A,
	0xA1C4, 0xA34E,
	0xA1C6, 0xA355,
	0xA1C7, 0xA353,
	0xA1C8, 0xA1E5,
	0xA1C9, 0xA1E4,
	0xA1CC, 0xA1D4,
	0xA1CF, 0xA1E7,
	0xA1D1, 0xA1F3,
	0xA1D2, 0xA1EC,
	0xA1D3, 0xA1ED,
	0xA1D4, 0xA1DD,
	0xA1D6, 0xA1DC,
	0xA1D9, 0xA1DA,
	0xA1DC, 0xA1D8,
	0xA1DD, 0xA1D9,
	0xA1DE, 0xA1DB,
	0xA1DF, 0xA1EE,
	0xA1E0, 0xA1EF,
	0xA1E1, 0xA1F1,
	0xA1E2, 0xA1F0,
	0xA1E3, 0xA258,
	0xA1E4, 0xA1AC,
	0xA1E5, 0xA1AA,
	0xA1E6, 0xA24A,
	0xA1E7, 0xA243,
	0xA1E9, 0xA246,
	0xA1EA, 0xA247,
	0xA1EC, 0xA1B1,
	0xA1EE, 0xA1B8,
	0xA1EF, 0xA1B9,
	0xA1F0, 0xA1B3,
	0xA1F1, 0xA1B4,
	0xA1F2, 0xA1B7,
	0xA1F3, 0xA1BA,
	0xA1F4, 0xA1BB,
	0xA1F5, 0xA1BC,
	0xA1F6, 0xA1BD,
	0xA1F7, 0xA1B5,
	0xA1F8, 0xA1B6,
	0xA1F9, 0xA1B0,
	0xA1FA, 0xA1F7,
	0xA1FB, 0xA1F6,
	0xA1FC, 0xA1F4,
	0xA1FD, 0xA1F5,
	0xA1FE, 0xA2A4,
	0xA2F1, 0xA2B9,
	0xA2F2, 0xA2BA,
	0xA2F3, 0xA2BB,
	0xA2F4, 0xA2BC,
	0xA2F5, 0xA2BD,
	0xA2F6, 0xA2BE,
	0xA2F7, 0xA2BF,
	0xA2F8, 0xA2C0,
	0xA2F9, 0xA2C1,
	0xA2FA, 0xA2C2,
	0xA3A1, 0xA149,
	0xA3A2, 0xA1A9,
	0xA3A3, 0xA1AD,
	0xA3A4, 0xA243,
	0xA3A5, 0xA248,
	0xA3A6, 0xA1AE,
	0xA3A7, 0xA1AC,
	0xA3A8, 0xA15D,
	0xA3A9, 0xA15E,
	0xA3AA, 0xA1AF,
	0xA3AB, 0xA1CF,
	0xA3AC, 0xA141,
	0xA3AD, 0xA1D0,
	0xA3AE, 0xA144,
	0xA3AF, 0xA1FE,
	0xA3B0, 0xA2AF,
	0xA3B1, 0xA2B0,
	0xA3B2, 0xA2B1,
	0xA3B3, 0xA2B2,
	0xA3B4, 0xA2B3,
	0xA3B5, 0xA2B4,
	0xA3B6, 0xA2B5,
	0xA3B7, 0xA2B6,
	0xA3B8, 0xA2B7,
	0xA3B9, 0xA2B8,
	0xA3BA, 0xA147,
	0xA3BB, 0xA146,
	0xA3BC, 0xA1D5,
	0xA3BD, 0xA1D7,
	0xA3BE, 0xA1D6,
	0xA3BF, 0xA148,
	0xA3C0, 0xA249,
	0xA3C1, 0xA2CF,
	0xA3C2, 0xA2D0,
	0xA3C3, 0xA2D1,
	0xA3C4, 0xA2D2,
	0xA3C5, 0xA2D3,
	0xA3C6, 0xA2D4,
	0xA3C7, 0xA2D5,
	0xA3C8, 0xA2D6,
	0xA3C9, 0xA2D7,
	0xA3CA, 0xA2D8,
	0xA3CB, 0xA2D9,
	0xA3CC, 0xA2DA,
	0xA3CD, 0xA2DB,
	0xA3CE, 0xA2DC,
	0xA3CF, 0xA2DD,
	0xA3D0, 0xA2DE,
	0xA3D1, 0xA2DF,
	0xA3D2, 0xA2E0,
	0xA3D3, 0xA2E1,
	0xA3D4, 0xA2E2,
	0xA3D5, 0xA2E3,
	0xA3D6, 0xA2E4,
	0xA3D7, 0xA2E5,
	0xA3D8, 0xA2E6,
	0xA3D9, 0xA2E7,
	0xA3DA, 0xA2E8,
	0xA3DB, 0xA1A3,
	0xA3DC, 0xA240,
	0xA3DD, 0xA1A4,
	0xA3DE, 0xA173,
	0xA3DF, 0xA15A,
	0xA3E0, 0xA1AB,
	0xA3E1, 0xA2E9,
	0xA3E2, 0xA2EA,
	0xA3E3, 0xA2EB,
	0xA3E4, 0xA2EC,
	0xA3E5, 0xA2ED,
	0xA3E6, 0xA2EE,
	0xA3E7, 0xA2EF,
	0xA3E8, 0xA2F0,
	0xA3E9, 0xA2F1,
	0xA3EA, 0xA2F2,
	0xA3EB, 0xA2F3,
	0xA3EC, 0xA2F4,
	0xA3ED, 0xA2F5,
	0xA3EE, 0xA2F6,
	0xA3EF, 0xA2F7,
	0xA3F0, 0xA2F8,
	0xA3F1, 0xA2F9,
	0xA3F2, 0xA2FA,
	0xA3F3, 0xA2FB,
	0xA3F4, 0xA2FC,
	0xA3F5, 0xA2FD,
	0xA3F6, 0xA2FE,
	0xA3F7, 0xA340,
	0xA3F8, 0xA341,
	0xA3F9, 0xA342,
	0xA3FA, 0xA343,
	0xA3FB, 0xA161,
	0xA3FC, 0xA155,
	0xA3FD, 0xA162,
	0xA3FE, 0xA1C2,
	0xA6A1, 0xA344,
	0xA6A2, 0xA345,
	0xA6A3, 0xA346,
	0xA6A4, 0xA347,
	0xA6A5, 0xA348,
	0xA6A6, 0xA349,
	0xA6A7, 0xA34A,
	0xA6A8, 0xA34B,
	0xA6A9, 0xA34C,
	0xA6AA, 0xA34D,
	0xA6AB, 0xA34E,
	0xA6AC, 0xA34F,
	0xA6AD, 0xA350,
	0xA6AE, 0xA351,
	0xA6AF, 0xA352,
	0xA6B0, 0xA353,
	0xA6B1, 0xA354,
	0xA6B2, 0xA355,
	0xA6B3, 0xA356,
	0xA6B4, 0xA357,
	0xA6B5, 0xA358,
	0xA6B6, 0xA359,
	0xA6B7, 0xA35A,
	0xA6B8, 0xA35B,
	0xA6C1, 0xA35C,
	0xA6C2, 0xA35D,
	0xA6C3, 0xA35E,
	0xA6C4, 0xA35F,
	0xA6C5, 0xA360,
	0xA6C6, 0xA361,
	0xA6C7, 0xA362,
	0xA6C8, 0xA363,
	0xA6C9, 0xA364,
	0xA6CA, 0xA365,
	0xA6CB, 0xA366,
	0xA6CC, 0xA367,
	0xA6CD, 0xA368,
	0xA6CE, 0xA369,
	0xA6CF, 0xA36A,
	0xA6D0, 0xA36B,
	0xA6D1, 0xA36C,
	0xA6D2, 0xA36D,
	0xA6D3, 0xA36E,
	0xA6D4, 0xA36F,
	0xA6D5, 0xA370,
	0xA6D6, 0xA371,
	0xA6D7, 0xA372,
	0xA6D8, 0xA373,
	0xA8C5, 0xA374,
	0xA8C6, 0xA375,
	0xA8C7, 0xA376,
	0xA8C8, 0xA377,
	0xA8C9, 0xA378,
	0xA8CA, 0xA379,
	0xA8CB, 0xA37A,
	0xA8CC, 0xA37B,
	0xA8CD, 0xA37C,
	0xA8CE, 0xA37D,
	0xA8CF, 0xA37E,
	0xA8D0, 0xA3A1,
	0xA8D1, 0xA3A2,
	0xA8D2, 0xA3A3,
	0xA8D3, 0xA3A4,
	0xA8D4, 0xA3A5,
	0xA8D5, 0xA3A6,
	0xA8D6, 0xA3A7,
	0xA8D7, 0xA3A8,
	0xA8D8, 0xA3A9,
	0xA8D9, 0xA3AA,
	0xA8DA, 0xA3AB,
	0xA8DB, 0xA3AC,
	0xA8DC, 0xA3AD,
	0xA8DD, 0xA3AE,
	0xA8DE, 0xA3AF,
	0xA8DF, 0xA3B0,
	0xA8E0, 0xA3B1,
	0xA8E1, 0xA3B2,
	0xA8E2, 0xA3B3,
	0xA8E3, 0xA3B4,
	0xA8E4, 0xA3B5,
	0xA8E5, 0xA3B6,
	0xA8E6, 0xA3B7,
	0xA8E7, 0xA3B8,
	0xA8E8, 0xA3B9,
	0xA8E9, 0xA3BA,
	0xA9A4, 0xA277,
	0xA9A6, 0xA278,
	0xA9B0, 0xA27A,
	0xA9B4, 0xA27B,
	0xA9B8, 0xA27C,
	0xA9BC, 0xA27D,
	0xA9C0, 0xA275,
	0xA9C8, 0xA274,
	0xA9D0, 0xA273,
	0xA9D8, 0xA272,
	0xA9E0, 0xA271,
	0xB0A1, 0xB0DA,
	0xB0A2, 0xAAFC,
	0xB0A3, 0xAE4A,
	0xB0A4, 0xAEC1,
	0xB0A5, 0xAB75,
	0xB0A6, 0xADFC,
	0xB0A7, 0xAB73,
	0xB0A8, 0xBD4A,
	0xB0A9, 0xC0F9,
	0xB0AA, 0xC4A7,
	0xB0AB, 0xB847,
	0xB0AC, 0xA6E3,
	0xB0AD, 0xC3AA,
	0xB0AE, 0xB752,
	0xB0AF, 0xB969,
	0xB0B0, 0xBE62,
	0xB0B1, 0xAEF2,
	0xB0B2, 0xA677,
	0xB0B3, 0xADCD,
	0xB0B4, 0xABF6,
	0xB0B5, 0xB774,
	0xB0B6, 0xA9A4,
	0xB0B7, 0xD369,
	0xB0B8, 0xAED7,
	0xB0B9, 0xBBEA,
	0xB0BA, 0xA9F9,
	0xB0BB, 0xAF73,
	0xB0BC, 0xA557,
	0xB0BD, 0xB1CE,
	0xB0BE, 0xBCF5,
	0xB0BF, 0xBFAC,
	0xB0C0, 0xC3CD,
	0xB0C1, 0xB6C6,
	0xB0C2, 0xB6F8,
	0xB0C3, 0xBED2,
	0xB0C4, 0xBF44,
	0xB0C5, 0xAADD,
	0xB0C6, 0xAEC3,
	0xB0C7, 0xA5B6,
	0xB0C8, 0xA57A,
	0xB0C9, 0xA761,
	0xB0CA, 0xAFB9,
	0xB0CB, 0xA44B,
	0xB0CC, 0xACCD,
	0xB0CD, 0xA4DA,
	0xB0CE, 0xA9DE,
	0xB0CF, 0xB65B,
	0xB0D0, 0xB976,
	0xB0D1, 0xA7E2,
	0xB0D2, 0xAFD2,
	0xB0D3, 0xC5F2,
	0xB0D4, 0xC551,
	0xB0D5, 0xBD7D,
	0xB0D6, 0xAAA8,
	0xB0D7, 0xA5D5,
	0xB0D8, 0xAC66,
	0xB0D9, 0xA6CA,
	0xB0DA, 0xC25C,
	0xB0DB, 0xA8D5,
	0xB0DC, 0xB1D1,
	0xB0DD, 0xABF4,
	0xB0DE, 0xDEFB,
	0xB0DF, 0xB4B3,
	0xB0E0, 0xAF5A,
	0xB0E1, 0xB768,
	0xB0E2, 0xA7E6,
	0xB0E3, 0xAFEB,
	0xB0E4, 0xB97B,
	0xB0E5, 0xAA4F,
	0xB0E6, 0xAAA9,
	0xB0E7, 0xA7EA,
	0xB0E8, 0xA9D5,
	0xB0E9, 0xA6F1,
	0xB0EA, 0xC3A4,
	0xB0EB, 0xA562,
	0xB0EC, 0xBFEC,
	0xB0ED, 0xB2CC,
	0xB0EE, 0xA8B9,
	0xB0EF, 0xC0B0,
	0xB0F0, 0xB1F5,
	0xB0F1, 0xBA5D,
	0xB0F2, 0xBB48,
	0xB0F3, 0xB86A,
	0xB0F4, 0xB4CE,
	0xB0F5, 0xBD53,
	0xB0F6, 0xB046,
	0xB0F7, 0xC2E9,
	0xB0F8, 0xB3C4,
	0xB0F9, 0xC1BD,
	0xB0FA, 0xAD63,
	0xB0FB, 0xAD4D,
	0xB0FC, 0xA55D,
	0xB0FD, 0xBDC7,
	0xB0FE, 0xADE9,
	0xB1A1, 0xC1A1,
	0xB1A2, 0xB972,
	0xB1A3, 0xAB4F,
	0xB1A4, 0xB3F9,
	0xB1A5, 0xB9A1,
	0xB1A6, 0xC45F,
	0xB1A7, 0xA9EA,
	0xB1A8, 0xB3F8,
	0xB1A9, 0xBCC9,
	0xB1AA, 0xB05C,
	0xB1AB, 0xC06A,
	0xB1AC, 0xC37A,
	0xB1AD, 0xAA4D,
	0xB1AE, 0xB84F,
	0xB1AF, 0xB464,
	0xB1B0, 0xA8F5,
	0xB1B1, 0xA55F,
	0xB1B2, 0xBDFA,
	0xB1B3, 0xAD49,
	0xB1B4, 0xA8A9,
	0xB1B5, 0xBE58,
	0xB1B6, 0xADBF,
	0xB1B7, 0xAF56,
	0xB1B8, 0xB3C6,
	0xB1B9, 0xBECE,
	0xB1BA, 0xB548,
	0xB1BB, 0xB351,
	0xB1BC, 0xA962,
	0xB1BD, 0xAD66,
	0xB1BE, 0xA5BB,
	0xB1BF, 0xB2C2,
	0xB1C0, 0xB159,
	0xB1C1, 0xC15E,
	0xB1C2, 0xACC7,
	0xB1C3, 0xACA6,
	0xB1C4, 0xC2DB,
	0xB1C5, 0xB06E,
	0xB1C6, 0xB947,
	0xB1C7, 0xBBF3,
	0xB1C8, 0xA4F1,
	0xB1C9, 0xBBC0,
	0xB1CA, 0xB5A7,
	0xB1CB, 0xA9BC,
	0xB1CC, 0xBAD1,
	0xB1CD, 0xE3C9,
	0xB1CE, 0xBDAA,
	0xB1CF, 0xB2A6,
	0xB1D0, 0xC0C5,
	0xB1D1, 0xCF68,
	0xB1D2, 0xB9F4,
	0xB1D3, 0xA7C8,
	0xB1D4, 0xB7F4,
	0xB1D5, 0xB3AC,
	0xB1D6, 0xB1CD,
	0xB1D7, 0xB9FA,
	0xB1D8, 0xA5B2,
	0xB1D9, 0xB940,
	0xB1DA, 0xBEC0,
	0xB1DB, 0xC175,
	0xB1DC, 0xC1D7,
	0xB1DD, 0xB0A1,
	0xB1DE, 0xC340,
	0xB1DF, 0xC3E4,
	0xB1E0, 0xBD73,
	0xB1E1, 0xB653,
	0xB1E2, 0xABF3,
	0xB1E3, 0xAB4B,
	0xB1E4, 0xC5DC,
	0xB1E5, 0xA4CB,
	0xB1E6, 0xBFEB,
	0xB1E7, 0xC547,
	0xB1E8, 0xC47C,
	0xB1E9, 0xB94D,
	0xB1EA, 0xBCD0,
	0xB1EB, 0xB343,
	0xB1EC, 0xBDA8,
	0xB1ED, 0xAAED,
	0xB1EE, 0xC5BE,
	0xB1EF, 0xE578,
	0xB1F0, 0xA74F,
	0xB1F1, 0xC3A7,
	0xB1F2, 0xB16C,
	0xB1F3, 0xD979,
	0xB1F4, 0xC378,
	0xB1F5, 0xC0D8,
	0xB1F6, 0xBBAB,
	0xB1F7, 0xECE8,
	0xB1F8, 0xA74C,
	0xB1F9, 0xA642,
	0xB1FA, 0xAC60,
	0xB1FB, 0xA4FE,
	0xB1FC, 0xAAC3,
	0xB1FD, 0xBBE6,
	0xB1FE, 0xACB1,
	0xB2A1, 0xAF66,
	0xB2A2, 0xA8C3,
	0xB2A3, 0xACC1,
	0xB2A4, 0xB5D4,
	0xB2A5, 0xBCBD,
	0xB2A6, 0xBCB7,
	0xB2A7, 0xD2DC,
	0xB2A8, 0xAA69,
	0xB2A9, 0xB3D5,
	0xB2AA, 0xAB6B,
	0xB2AB, 0xB769,
	0xB2AC, 0xB960,
	0xB2AD, 0xBAE4,
	0xB2AE, 0xA742,
	0xB2AF, 0xA9AD,
	0xB2B0, 0xB2ED,
	0xB2B1, 0xB2E4,
	0xB2B2, 0xBB4B,
	0xB2B3, 0xB4F1,
	0xB2B4, 0xAA79,
	0xB2B5, 0xBBE9,
	0xB2B6, 0xAEB7,
	0xB2B7, 0xA452,
	0xB2B8, 0xADF7,
	0xB2B9, 0xB8C9,
	0xB2BA, 0xB0F0,
	0xB2BB, 0xA4A3,
	0xB2BC, 0xA5AC,
	0xB2BD, 0xA842,
	0xB2BE, 0xC3AF,
	0xB2BF, 0xB3A1,
	0xB2C0, 0xA9C6,
	0xB2C1, 0xC0BF,
	0xB2C2, 0xB271,
	0xB2C3, 0xB5F4,
	0xB2C4, 0xA7F7,
	0xB2C5, 0xA47E,
	0xB2C6, 0xB05D,
	0xB2C7, 0xB842,
	0xB2C8, 0xBDF2,
	0xB2C9, 0xB1C4,
	0xB2CA, 0xB16D,
	0xB2CB, 0xB5E6,
	0xB2CC, 0xBDB2,
	0xB2CD, 0xC05C,
	0xB2CE, 0xB0D1,
	0xB2CF, 0xC5FA,
	0xB2D0, 0xB4DD,
	0xB2D1, 0xBA46,
	0xB2D2, 0xBA47,
	0xB2D3, 0xC0E9,
	0xB2D4, 0xBB61,
	0xB2D5, 0xBFB5,
	0xB2D6, 0xADDC,
	0xB2D7, 0xB7C9,
	0xB2D8, 0xC2C3,
	0xB2D9, 0xBEDE,
	0xB2DA, 0xC157,
	0xB2DB, 0xBCD1,
	0xB2DC, 0xB1E4,
	0xB2DD, 0xAFF3,
	0xB2DE, 0xB45A,
	0xB2DF, 0xB5A6,
	0xB2E0, 0xB0BC,
	0xB2E1, 0xA555,
	0xB2E2, 0xB4FA,
	0xB2E3, 0xBC68,
	0xB2E4, 0xF34F,
	0xB2E5, 0xB4A1,
	0xB2E6, 0xA465,
	0xB2E7, 0xD3B3,
	0xB2E8, 0xAFF9,
	0xB2E9, 0xAC64,
	0xB2EA, 0xE2ED,
	0xB2EB, 0xB767,
	0xB2EC, 0xB9EE,
	0xB2ED, 0xA7C3,
	0xB2EE, 0xAE74,
	0xB2EF, 0xB8D2,
	0xB2F0, 0xA9EE,
	0xB2F1, 0xAEE3,
	0xB2F2, 0xB05B,
	0xB2F3, 0xC465,
	0xB2F4, 0xBA55,
	0xB2F5, 0xC2CD,
	0xB2F6, 0xC661,
	0xB2F7, 0xC5FE,
	0xB2F8, 0xC4F1,
	0xB2F9, 0xC3EA,
	0xB2FA, 0xB2A3,
	0xB2FB, 0xC4C4,
	0xB2FC, 0xC5B8,
	0xB2FD, 0xA9F7,
	0xB2FE, 0xB273,
	0xB3A1, 0xB3F5,
	0xB3A2, 0xB9C1,
	0xB3A3, 0xB160,
	0xB3A4, 0xAAF8,
	0xB3A5, 0xC076,
	0xB3A6, 0xB87A,
	0xB3A7, 0xBC74,
	0xB3A8, 0xB4AF,
	0xB3A9, 0xBA5A,
	0xB3AA, 0xB0DB,
	0xB3AB, 0xADD2,
	0xB3AC, 0xB657,
	0xB3AD, 0xA7DB,
	0xB3AE, 0xB672,
	0xB3AF, 0xB4C2,
	0xB3B0, 0xBC4A,
	0xB3B1, 0xBCE9,
	0xB3B2, 0xB15F,
	0xB3B3, 0xA76E,
	0xB3B4, 0xAAA3,
	0xB3B5, 0xA8AE,
	0xB3B6, 0xA7E8,
	0xB3B7, 0xBA4D,
	0xB3B8, 0xB477,
	0xB3B9, 0xB9FD,
	0xB3BA, 0xBAAB,
	0xB3BB, 0xD7EB,
	0xB3BC, 0xA6DA,
	0xB3BD, 0xA8B0,
	0xB3BE, 0xB9D0,
	0xB3BF, 0xB1E1,
	0xB3C0, 0xA7D5,
	0xB3C1, 0xA849,
	0xB3C2, 0xB3AF,
	0xB3C3, 0xB658,
	0xB3C4, 0xC5A8,
	0xB3C5, 0xBCB5,
	0xB3C6, 0xBAD9,
	0xB3C7, 0xABB0,
	0xB3C8, 0xBEED,
	0xB3C9, 0xA6A8,
	0xB3CA, 0xA765,
	0xB3CB, 0xADBC,
	0xB3CC, 0xB57B,
	0xB3CD, 0xC367,
	0xB3CE, 0xBCE1,
	0xB3CF, 0xB8DB,
	0xB3D0, 0xA9D3,
	0xB3D1, 0xB378,
	0xB3D2, 0xC1FE,
	0xB3D3, 0xAFAF,
	0xB3D4, 0xA659,
	0xB3D5, 0xB7F6,
	0xB3D6, 0xABF9,
	0xB3D7, 0xB0CD,
	0xB3D8, 0xA6C0,
	0xB3D9, 0xBFF0,
	0xB3DA, 0xA6A2,
	0xB3DB, 0xB9A3,
	0xB3DC, 0xAEA2,
	0xB3DD, 0xBEA6,
	0xB3DE, 0xA8D7,
	0xB3DF, 0xA4D8,
	0xB3E0, 0xA8AA,
	0xB3E1, 0xAFCD,
	0xB3E2, 0xA5B8,
	0xB3E3, 0xBF4B,
	0xB3E4, 0xA552,
	0xB3E5, 0xA852,
	0xB3E6, 0xA6E4,
	0xB3E7, 0xB152,
	0xB3E8, 0xC364,
	0xB3E9, 0xA9E2,
	0xB3EA, 0xB953,
	0xB3EB, 0xC3A5,
	0xB3EC, 0xC543,
	0xB3ED, 0xB859,
	0xB3EE, 0xB754,
	0xB3EF, 0xC477,
	0xB3F0, 0xA4B3,
	0xB3F1, 0xBAF7,
	0xB3F2, 0xE2E4,
	0xB3F3, 0xC1E0,
	0xB3F4, 0xAFE4,
	0xB3F5, 0xAAEC,
	0xB3F6, 0xA558,
	0xB3F7, 0xC36F,
	0xB3F8, 0xBC70,
	0xB3F9, 0xC3DC,
	0xB3FA, 0xBE53,
	0xB3FB, 0xC2FA,
	0xB3FC, 0xDE51,
	0xB3FD, 0xB0A3,
	0xB3FE, 0xB7A1,
	0xB4A1, 0xC2A6,
	0xB4A2, 0xC078,
	0xB4A3, 0xC5F7,
	0xB4A4, 0xDD7A,
	0xB4A5, 0xC4B2,
	0xB4A6, 0xB342,
	0xB4A7, 0xB4A2,
	0xB4A8, 0xA474,
	0xB4A9, 0xACEF,
	0xB4AA, 0xDDDC,
	0xB4AB, 0xB6C7,
	0xB4AC, 0xB2EE,
	0xB4AD, 0xB3DD,
	0xB4AE, 0xA6EA,
	0xB4AF, 0xBD48,
	0xB4B0, 0xB5A1,
	0xB4B1, 0xBC6C,
	0xB4B2, 0xA7C9,
	0xB4B3, 0xC2F4,
	0xB4B4, 0xB3D0,
	0xB4B5, 0xA76A,
	0xB4B6, 0xAAA4,
	0xB4B7, 0xB4A8,
	0xB4B8, 0xC1E8,
	0xB4B9, 0xABAB,
	0xB4BA, 0xAC4B,
	0xB4BB, 0xDDCF,
	0xB4BC, 0xBE4A,
	0xB4BD, 0xAE42,
	0xB4BE, 0xB245,
	0xB4BF, 0xAFC2,
	0xB4C0, 0xC4F8,
	0xB4C1, 0xC257,
	0xB4C2, 0xBAEF,
	0xB4C3, 0xB2AB,
	0xB4C4, 0xAFFD,
	0xB4C5, 0xBACF,
	0xB4C6, 0xBBDB,
	0xB4C7, 0xC3E3,
	0xB4C8, 0xB74F,
	0xB4C9, 0xB2A1,
	0xB4CA, 0xB5FC,
	0xB4CB, 0xA6B9,
	0xB4CC, 0xA8EB,
	0xB4CD, 0xBDE7,
	0xB4CE, 0xA6B8,
	0xB4CF, 0xC16F,
	0xB4D0, 0xBDB5,
	0xB4D1, 0xA777,
	0xB4D2, 0xA55E,
	0xB4D3, 0xB171,
	0xB4D4, 0xC24F,
	0xB4D5, 0xB4EA,
	0xB4D6, 0xB2CA,
	0xB4D7, 0xBE4C,
	0xB4D8, 0xC14C,
	0xB4D9, 0xAB50,
	0xB4DA, 0xF94F,
	0xB4DB, 0xBF79,
	0xB4DC, 0xC2AB,
	0xB4DD, 0xBA52,
	0xB4DE, 0xB15A,
	0xB4DF, 0xB6CA,
	0xB4E0, 0xAFDC,
	0xB4E1, 0xB7F1,
	0xB4E2, 0xBAE9,
	0xB4E3, 0xB266,
	0xB4E4, 0xBB41,
	0xB4E5, 0xA7F8,
	0xB4E6, 0xA673,
	0xB4E7, 0xA46F,
	0xB4E8, 0xBD52,
	0xB4E9, 0xBCBC,
	0xB4EA, 0xB762,
	0xB4EB, 0xB1B9,
	0xB4EC, 0xAEC0,
	0xB4ED, 0xBFF9,
	0xB4EE, 0xB766,
	0xB4EF, 0xB946,
	0xB4F0, 0xB5AA,
	0xB4F1, 0xBD44,
	0xB4F2, 0xA5B4,
	0xB4F3, 0xA46A,
	0xB4F4, 0xA762,
	0xB4F5, 0xA4EF,
	0xB4F6, 0xD856,
	0xB4F7, 0xC0B9,
	0xB4F8, 0xB161,
	0xB4F9, 0xAC70,
	0xB4FA, 0xA54E,
	0xB4FB, 0xB655,
	0xB4FC, 0xB355,
	0xB4FD, 0xABDD,
	0xB4FE, 0xB665,
	0xB5A1, 0xABE5,
	0xB5A2, 0xAFD4,
	0xB5A3, 0xBEE1,
	0xB5A4, 0xA4A6,
	0xB5A5, 0xB3E6,
	0xB5A6, 0xE858,
	0xB5A7, 0xE5B8,
	0xB5A8, 0xC178,
	0xB5A9, 0xA5B9,
	0xB5AA, 0xB4E1,
	0xB5AB, 0xA6FD,
	0xB5AC, 0xBCAA,
	0xB5AD, 0xB248,
	0xB5AE, 0xBDCF,
	0xB5AF, 0xBC75,
	0xB5B0, 0xB34A,
	0xB5B1, 0xB7ED,
	0xB5B2, 0xBED7,
	0xB5B3, 0xC4D2,
	0xB5B4, 0xC0FA,
	0xB5B5, 0xC0C9,
	0xB5B6, 0xA44D,
	0xB5B7, 0xB76F,
	0xB5B8, 0xC1D0,
	0xB5B9, 0xADCB,
	0xB5BA, 0xAE71,
	0xB5BB, 0xC3AB,
	0xB5BC, 0xBEC9,
	0xB5BD, 0xA8EC,
	0xB5BE, 0xBD5F,
	0xB5BF, 0xB1A5,
	0xB5C0, 0xB944,
	0xB5C1, 0xB573,
	0xB5C2, 0xBC77,
	0xB5C3, 0xB16F,
	0xB5C4, 0xAABA,
	0xB5C5, 0xC3DE,
	0xB5C6, 0xBF4F,
	0xB5C7, 0xB56E,
	0xB5C8, 0xB5A5,
	0xB5C9, 0xC0FC,
	0xB5CA, 0xB9B9,
	0xB5CB, 0xBE48,
	0xB5CC, 0xB3F6,
	0xB5CD, 0xA743,
	0xB5CE, 0xBA77,
	0xB5CF, 0xAD7D,
	0xB5D0, 0xBCC4,
	0xB5D1, 0xB2C3,
	0xB5D2, 0xA866,
	0xB5D3, 0xBAB0,
	0xB5D4, 0xBB43,
	0xB5D5, 0xB9DE,
	0xB5D6, 0xA9E8,
	0xB5D7, 0xA9B3,
	0xB5D8, 0xA661,
	0xB5D9, 0xB8A6,
	0xB5DA, 0xB2C4,
	0xB5DB, 0xABD2,
	0xB5DC, 0xA7CC,
	0xB5DD, 0xBBBC,
	0xB5DE, 0xBD6C,
	0xB5DF, 0xC441,
	0xB5E0, 0xD569,
	0xB5E1, 0xB7BF,
	0xB5E2, 0xB84B,
	0xB5E3, 0xC249,
	0xB5E4, 0xA8E5,
	0xB5E5, 0xC051,
	0xB5E6, 0xB9D4,
	0xB5E7, 0xB971,
	0xB5E8, 0xA6FA,
	0xB5E9, 0xA86C,
	0xB5EA, 0xA9B1,
	0xB5EB, 0xB17D,
	0xB5EC, 0xB3FE,
	0xB5ED, 0xBEFD,
	0xB5EE, 0xB7B5,
	0xB5EF, 0xB84D,
	0xB5F0, 0xA570,
	0xB5F1, 0xC04A,
	0xB5F2, 0xADE4,
	0xB5F3, 0xA44E,
	0xB5F4, 0xB1BC,
	0xB5F5, 0xA651,
	0xB5F6, 0xB3A8,
	0xB5F7, 0xBDD5,
	0xB5F8, 0xB65E,
	0xB5F9, 0xAF52,
	0xB5FA, 0xBAD0,
	0xB5FB, 0xBDBA,
	0xB5FC, 0xADA1,
	0xB5FD, 0xBFD2,
	0xB5FE, 0xC57C,
	0xB6A1, 0xA442,
	0xB6A2, 0xA86E,
	0xB6A3, 0xA56D,
	0xB6A4, 0xB076,
	0xB6A5, 0xB3BB,
	0xB6A6, 0xB9A9,
	0xB6A7, 0xBFF5,
	0xB6A8, 0xA977,
	0xB6A9, 0xAD71,
	0xB6AA, 0xA5E1,
	0xB6AB, 0xAA46,
	0xB6AC, 0xA556,
	0xB6AD, 0xB8B3,
	0xB6AE, 0xC0B4,
	0xB6AF, 0xB0CA,
	0xB6B0, 0xB4C9,
	0xB6B1, 0xCBBE,
	0xB6B2, 0xABF0,
	0xB6B3, 0xADE1,
	0xB6B4, 0xAC7D,
	0xB6B5, 0xB0C2,
	0xB6B6, 0xA7DD,
	0xB6B7, 0xB0AB,
	0xB6B8, 0xB07E,
	0xB6B9, 0xA8A7,
	0xB6BA, 0xB372,
	0xB6BB, 0xB56B,
	0xB6BC, 0xB3A3,
	0xB6BD, 0xB7FE,
	0xB6BE, 0xAC72,
	0xB6BF, 0xC37D,
	0xB6C0, 0xBF57,
	0xB6C1, 0xC5AA,
	0xB6C2, 0xB0F4,
	0xB6C3, 0xB840,
	0xB6C4, 0xBDE4,
	0xB6C5, 0xA7F9,
	0xB6C6, 0xC1E1,
	0xB6C7, 0xA87B,
	0xB6C8, 0xABD7,
	0xB6C9, 0xB4E7,
	0xB6CA, 0xA7AA,
	0xB6CB, 0xBADD,
	0xB6CC, 0xB575,
	0xB6CD, 0xC1EB,
	0xB6CE, 0xAC71,
	0xB6CF, 0xC25F,
	0xB6D0, 0xBD76,
	0xB6D1, 0xB0EF,
	0xB6D2, 0xA749,
	0xB6D3, 0xB6A4,
	0xB6D4, 0xB9EF,
	0xB6D5, 0xBC5B,
	0xB6D6, 0xBEB7,
	0xB6D7, 0xC3DB,
	0xB6D8, 0xB4B0,
	0xB6D9, 0xB979,
	0xB6DA, 0xA779,
	0xB6DB, 0xB677,
	0xB6DC, 0xACDE,
	0xB6DD, 0xB950,
	0xB6DE, 0xD573,
	0xB6DF, 0xCE47,
	0xB6E0, 0xA668,
	0xB6E1, 0xB9DC,
	0xB6E2, 0xCE57,
	0xB6E3, 0xB8FA,
	0xB6E4, 0xA6B7,
	0xB6E5, 0xB8F6,
	0xB6E6, 0xB2EB,
	0xB6E7, 0xA8EF,
	0xB6E8, 0xB46B,
	0xB6E9, 0xBC5A,
	0xB6EA, 0xB8BF,
	0xB6EB, 0xAE6F,
	0xB6EC, 0xC35A,
	0xB6ED, 0xAB58,
	0xB6EE, 0xC342,
	0xB6EF, 0xB35F,
	0xB6F0, 0xAE5A,
	0xB6F1, 0xB463,
	0xB6F2, 0xA4CC,
	0xB6F3, 0xA7E3,
	0xB6F4, 0xB94B,
	0xB6F5, 0xB66B,
	0xB6F6, 0xBE6A,
	0xB6F7, 0xAEA6,
	0xB6F8, 0xA6D3,
	0xB6F9, 0xA8E0,
	0xB6FA, 0xA6D5,
	0xB6FB, 0xBAB8,
	0xB6FC, 0xBBE7,
	0xB6FD, 0xAC7C,
	0xB6FE, 0xA447,
	0xB7A1, 0xB64C,
	0xB7A2, 0xB56F,
	0xB7A3, 0xBB40,
	0xB7A4, 0xB5AD,
	0xB7A5, 0xA5EF,
	0xB7A6, 0xA546,
	0xB7A7, 0xBBD6,
	0xB7A8, 0xAA6B,
	0xB7A9, 0xB557,
	0xB7AA, 0xC3BF,
	0xB7AB, 0xA67C,
	0xB7AC, 0xB566,
	0xB7AD, 0xC2BD,
	0xB7AE, 0xBCD4,
	0xB7AF, 0xC473,
	0xB7B0, 0xB3AB,
	0xB7B1, 0xC163,
	0xB7B2, 0xA45A,
	0xB7B3, 0xB7D0,
	0xB7B4, 0xA4CF,
	0xB7B5, 0xAAF0,
	0xB7B6, 0xAD53,
	0xB7B7, 0xB363,
	0xB7B8, 0xA5C7,
	0xB7B9, 0xB6BA,
	0xB7BA, 0xAA78,
	0xB7BB, 0xA77B,
	0xB7BC, 0xAADA,
	0xB7BD, 0xA4E8,
	0xB7BE, 0xAAD5,
	0xB7BF, 0xA9D0,
	0xB7C0, 0xA8BE,
	0xB7C1, 0xA7AB,
	0xB7C2, 0xA5E9,
	0xB7C3, 0xB358,
	0xB7C4, 0xAFBC,
	0xB7C5, 0xA9F1,
	0xB7C6, 0xB5E1,
	0xB7C7, 0xAB44,
	0xB7C8, 0xB0D8,
	0xB7C9, 0xADB8,
	0xB7CA, 0xAACE,
	0xB7CB, 0xADEA,
	0xB7CC, 0xBDDA,
	0xB7CD, 0xA770,
	0xB7CE, 0xAACD,
	0xB7CF, 0xBC6F,
	0xB7D0, 0xAA6D,
	0xB7D1, 0xB64F,
	0xB7D2, 0xAAE2,
	0xB7D3, 0xD7F4,
	0xB7D4, 0xA768,
	0xB7D5, 0xAA5E,
	0xB7D6, 0xA4C0,
	0xB7D7, 0xAFC9,
	0xB7D8, 0xBC58,
	0xB7D9, 0xB549,
	0xB7DA, 0xA857,
	0xB7DB, 0xAFBB,
	0xB7DC, 0xBEC4,
	0xB7DD, 0xA5F7,
	0xB7DE, 0xA9C1,
	0xB7DF, 0xBCAB,
	0xB7E0, 0xC154,
	0xB7E1, 0xC2D7,
	0xB7E2, 0xABCA,
	0xB7E3, 0xB7AC,
	0xB7E4, 0xB8C1,
	0xB7E5, 0xAE70,
	0xB7E6, 0xBE57,
	0xB7E7, 0xADB7,
	0xB7E8, 0xBAC6,
	0xB7E9, 0xB26C,
	0xB7EA, 0xB37B,
	0xB7EB, 0xB6BE,
	0xB7EC, 0xC15F,
	0xB7ED, 0xBFD8,
	0xB7EE, 0xA95E,
	0xB7EF, 0xBBF1,
	0xB7F0, 0xA6F2,
	0xB7F1, 0xA75F,
	0xB7F2, 0xA4D2,
	0xB7F3, 0xBCC5,
	0xB7F4, 0xBDA7,
	0xB7F5, 0xB9E5,
	0xB7F6, 0xA7DF,
	0xB7F7, 0xA9D8,
	0xB7F8, 0xBFE7,
	0xB7F9, 0xB454,
	0xB7FA, 0xAC74,
	0xB7FB, 0xB2C5,
	0xB7FC, 0xA5F1,
	0xB7FD, 0xAB52,
	0xB7FE, 0xAA41,
	0xB8A1, 0xAF42,
	0xB8A2, 0xB265,
	0xB8A3, 0xBAD6,
	0xB8A4, 0xB5F6,
	0xB8A5, 0xA5B1,
	0xB8A6, 0xA86A,
	0xB8A7, 0xBCBE,
	0xB8A8, 0xBBB2,
	0xB8A9, 0xADC1,
	0xB8AA, 0xB079,
	0xB8AB, 0xA9F2,
	0xB8AC, 0xB2E3,
	0xB8AD, 0xB5C6,
	0xB8AE, 0xA9B2,
	0xB8AF, 0xBB47,
	0xB8B0, 0xAD75,
	0xB8B1, 0xB0C6,
	0xB8B2, 0xC2D0,
	0xB8B3, 0xBDE1,
	0xB8B4, 0xB45F,
	0xB8B5, 0xB3C5,
	0xB8B6, 0xA549,
	0xB8B7, 0xAAFA,
	0xB8B8, 0xA4F7,
	0xB8B9, 0xB8A1,
	0xB8BA, 0xAD74,
	0xB8BB, 0xB449,
	0xB8BC, 0xAD72,
	0xB8BD, 0xAAFE,
	0xB8BE, 0xB0FC,
	0xB8BF, 0xBFA3,
	0xB8C0, 0xA94A,
	0xB8C1, 0xBEBF,
	0xB8C2, 0xB9C7,
	0xB8C3, 0xB8D3,
	0xB8C4, 0xA7EF,
	0xB8C5, 0xB7A7,
	0xB8C6, 0xB674,
	0xB8C7, 0xBB5C,
	0xB8C8, 0xB540,
	0xB8C9, 0xB746,
	0xB8CA, 0xA5CC,
	0xB8CB, 0xB1EC,
	0xB8CC, 0xAC61,
	0xB8CD, 0xACF1,
	0xB8CE, 0xA878,
	0xB8CF, 0xBBB0,
	0xB8D0, 0xB750,
	0xB8D1, 0xB57A,
	0xB8D2, 0xB4B1,
	0xB8D3, 0xC642,
	0xB8D4, 0xA9A3,
	0xB8D5, 0xADE8,
	0xB8D6, 0xBFFB,
	0xB8D7, 0xACFB,
	0xB8D8, 0xA87A,
	0xB8D9, 0xBAF5,
	0xB8DA, 0xB15E,
	0xB8DB, 0xB4E4,
	0xB8DC, 0xBA62,
	0xB8DD, 0xBF74,
	0xB8DE, 0xAF6F,
	0xB8DF, 0xB0AA,
	0xB8E0, 0xBB49,
	0xB8E1, 0xAFCC,
	0xB8E2, 0xBF7C,
	0xB8E3, 0xB764,
	0xB8E4, 0xC2EE,
	0xB8E5, 0xBD5A,
	0xB8E6, 0xA769,
	0xB8E7, 0xADF4,
	0xB8E8, 0xBA71,
	0xB8E9, 0xC0C1,
	0xB8EA, 0xA4E0,
	0xB8EB, 0xC246,
	0xB8EC, 0xAFDE,
	0xB8ED, 0xAAB8,
	0xB8EE, 0xB3CE,
	0xB8EF, 0xADB2,
	0xB8F0, 0xB8AF,
	0xB8F1, 0xAEE6,
	0xB8F2, 0xB5F0,
	0xB8F3, 0xBBD5,
	0xB8F4, 0xB96A,
	0xB8F5, 0xBBCC,
	0xB8F6, 0xADD3,
	0xB8F7, 0xA655,
	0xB8F8, 0xB5B9,
	0xB8F9, 0xAEDA,
	0xB8FA, 0xB8F2,
	0xB8FB, 0xAFD1,
	0xB8FC, 0xA7F3,
	0xB8FD, 0xA9B0,
	0xB8FE, 0xC3BC,
	0xB9A1, 0xAE47,
	0xB9A2, 0xAFD5,
	0xB9A3, 0xB1F0,
	0xB9A4, 0xA475,
	0xB9A5, 0xA7F0,
	0xB9A6, 0xA55C,
	0xB9A7, 0xAEA5,
	0xB9A8, 0xC5C7,
	0xB9A9, 0xA8D1,
	0xB9AA, 0xB060,
	0xB9AB, 0xA4BD,
	0xB9AC, 0xAE63,
	0xB9AD, 0xA47D,
	0xB9AE, 0xBE64,
	0xB9AF, 0xA845,
	0xB9B0, 0xABFD,
	0xB9B1, 0xB05E,
	0xB9B2, 0xA640,
	0xB9B3, 0xB95F,
	0xB9B4, 0xA4C4,
	0xB9B5, 0xB7BE,
	0xB9B6, 0xAD65,
	0xB9B7, 0xAAAF,
	0xB9B8, 0xABAF,
	0xB9B9, 0xBA63,
	0xB9BA, 0xC1CA,
	0xB9BB, 0xB0F7,
	0xB9BC, 0xB664,
	0xB9BD, 0xDBA3,
	0xB9BE, 0xA942,
	0xB9BF, 0xE354,
	0xB9C0, 0xA6F4,
	0xB9C1, 0xAA66,
	0xB9C2, 0xA974,
	0xB9C3, 0xA968,
	0xB9C4, 0xB9AA,
	0xB9C5, 0xA56A,
	0xB9C6, 0xC5DB,
	0xB9C7, 0xB0A9,
	0xB9C8, 0xA8A6,
	0xB9C9, 0xAAD1,
	0xB9CA, 0xAC47,
	0xB9CB, 0xC555,
	0xB9CC, 0xA954,
	0xB9CD, 0xB6B1,
	0xB9CE, 0xA8ED,
	0xB9CF, 0xA5CA,
	0xB9D0, 0xD46C,
	0xB9D1, 0xB9E8,
	0xB9D2, 0xB1BE,
	0xB9D3, 0xBB6F,
	0xB9D4, 0xA8C4,
	0xB9D5, 0xA9E4,
	0xB9D6, 0xA9C7,
	0xB9D7, 0xB4C3,
	0xB9D8, 0xC3F6,
	0xB9D9, 0xA978,
	0xB9DA, 0xAB61,
	0xB9DB, 0xC65B,
	0xB9DC, 0xBADE,
	0xB9DD, 0xC05D,
	0xB9DE, 0xC5F8,
	0xB9DF, 0xBA44,
	0xB9E0, 0xC4E9,
	0xB9E1, 0xB365,
	0xB9E2, 0xA5FA,
	0xB9E3, 0xBC73,
	0xB9E4, 0xB37D,
	0xB9E5, 0xBAC0,
	0xB9E6, 0xB357,
	0xB9E7, 0xA663,
	0xB9E8, 0xD6BA,
	0xB9E9, 0xC26B,
	0xB9EA, 0xC074,
	0xB9EB, 0xBBD3,
	0xB9EC, 0xAD79,
	0xB9ED, 0xB0AD,
	0xB9EE, 0xB8DE,
	0xB9EF, 0xACD1,
	0xB9F0, 0xAEDB,
	0xB9F1, 0xC264,
	0xB9F2, 0xB8F7,
	0xB9F3, 0xB651,
	0xB9F4, 0xBC44,
	0xB9F5, 0xBE40,
	0xB9F6, 0xBA75,
	0xB9F7, 0xB4D2,
	0xB9F8, 0xC1E7,
	0xB9F9, 0xB3A2,
	0xB9FA, 0xB0EA,
	0xB9FB, 0xAA47,
	0xB9FC, 0xBB71,
	0xB9FD, 0xB94C,
	0xB9FE, 0xABA2,
	0xBAA1, 0xC065,
	0xBAA2, 0xABC4,
	0xBAA3, 0xAEFC,
	0xBAA4, 0xAEF3,
	0xBAA5, 0xA5E8,
	0xBAA6, 0xAE60,
	0xBAA7, 0xC062,
	0xBAA8, 0xB66F,
	0xBAA9, 0xE977,
	0xBAAA, 0xCDD5,
	0xBAAB, 0xC1FA,
	0xBAAC, 0xA774,
	0xBAAD, 0xB25B,
	0xBAAE, 0xB448,
	0xBAAF, 0xA8E7,
	0xBAB0, 0xB3DB,
	0xBAB1, 0xA875,
	0xBAB2, 0xBFAB,
	0xBAB3, 0xBED9,
	0xBAB4, 0xAEC2,
	0xBAB5, 0xA7F2,
	0xBAB6, 0xBED1,
	0xBAB7, 0xAEAB,
	0xBAB8, 0xB26B,
	0xBAB9, 0xA6BD,
	0xBABA, 0xBA7E,
	0xBABB, 0xC971,
	0xBABC, 0xAA43,
	0xBABD, 0xAFE8,
	0xBABE, 0xC0A2,
	0xBABF, 0xC07A,
	0xBAC0, 0xBBA8,
	0xBAC1, 0xB240,
	0xBAC2, 0xB071,
	0xBAC3, 0xA66E,
	0xBAC4, 0xAFD3,
	0xBAC5, 0xB8B9,
	0xBAC6, 0xAF45,
	0xBAC7, 0xA8FE,
	0xBAC8, 0xB3DC,
	0xBAC9, 0xB2FC,
	0xBACA, 0xDB5D,
	0xBACB, 0xAED6,
	0xBACC, 0xA5DD,
	0xBACD, 0xA94D,
	0xBACE, 0xA6F3,
	0xBACF, 0xA658,
	0xBAD0, 0xB2B0,
	0xBAD1, 0xB8E8,
	0xBAD2, 0xBBD2,
	0xBAD3, 0xAA65,
	0xBAD4, 0xB255,
	0xBAD5, 0xBBAE,
	0xBAD6, 0xBDC5,
	0xBAD7, 0xC562,
	0xBAD8, 0xB650,
	0xBAD9, 0xBC4B,
	0xBADA, 0xB6C2,
	0xBADB, 0xB2AA,
	0xBADC, 0xABDC,
	0xBADD, 0xACBD,
	0xBADE, 0xABEB,
	0xBADF, 0xADF3,
	0xBAE0, 0xA6EB,
	0xBAE1, 0xBEEE,
	0xBAE2, 0xBFC5,
	0xBAE3, 0xABED,
	0xBAE4, 0xC546,
	0xBAE5, 0xABA1,
	0xBAE6, 0xAF4D,
	0xBAE7, 0xAD69,
	0xBAE8, 0xC245,
	0xBAE9, 0xAC78,
	0xBAEA, 0xA7BB,
	0xBAEB, 0xA5B0,
	0xBAEC, 0xACF5,
	0xBAED, 0xB3EF,
	0xBAEE, 0xAB4A,
	0xBAEF, 0xB555,
	0xBAF0, 0xA771,
	0xBAF1, 0xAB70,
	0xBAF2, 0xADD4,
	0xBAF3, 0xABE1,
	0xBAF4, 0xA949,
	0xBAF5, 0xA547,
	0xBAF6, 0xA9BF,
	0xBAF7, 0xB7E4,
	0xBAF8, 0xB3FD,
	0xBAF9, 0xB8AC,
	0xBAFA, 0xAD4A,
	0xBAFB, 0xBDB9,
	0xBAFC, 0xAAB0,
	0xBAFD, 0xBD6B,
	0xBAFE, 0xB4F2,
	0xBBA1, 0xA9B7,
	0xBBA2, 0xAAEA,
	0xBBA3, 0xB0E4,
	0xBBA4, 0xC540,
	0xBBA5, 0xA4AC,
	0xBBA6, 0xBAAD,
	0xBBA7, 0xA4E1,
	0xBBA8, 0xAAE1,
	0xBBA9, 0xBC4D,
	0xBBAA, 0xB5D8,
	0xBBAB, 0xB7E2,
	0xBBAC, 0xB7C6,
	0xBBAD, 0xB565,
	0xBBAE, 0xB9BA,
	0xBBAF, 0xA4C6,
	0xBBB0, 0xB8DC,
	0xBBB1, 0xBA69,
	0xBBB2, 0xABDE,
	0xBBB3, 0xC368,
	0xBBB4, 0xB261,
	0xBBB5, 0xC361,
	0xBBB6, 0xC577,
	0xBBB7, 0xC0F4,
	0xBBB8, 0xAED9,
	0xBBB9, 0xC1D9,
	0xBBBA, 0xBD77,
	0xBBBB, 0xB4AB,
	0xBBBC, 0xB177,
	0xBBBD, 0xB3EA,
	0xBBBE, 0xBAC8,
	0xBBBF, 0xB8E6,
	0xBBC0, 0xB7D8,
	0xBBC1, 0xB541,
	0xBBC2, 0xABC6,
	0xBBC3, 0xA4DB,
	0xBBC4, 0xAFEE,
	0xBBC5, 0xB757,
	0xBBC6, 0xB6C0,
	0xBBC7, 0xC144,
	0xBBC8, 0xBDC0,
	0xBBC9, 0xC2AE,
	0xBBCA, 0xACD3,
	0xBBCB, 0xB0C4,
	0xBBCC, 0xB471,
	0xBBCD, 0xB7D7,
	0xBBCE, 0xAECC,
	0xBBCF, 0xB745,
	0xBBD0, 0xABE9,
	0xBBD1, 0xC1C0,
	0xBBD2, 0xA6C7,
	0xBBD3, 0xB4A7,
	0xBBD4, 0xBDF7,
	0xBBD5, 0xC0B2,
	0xBBD6, 0xABEC,
	0xBBD7, 0xB5EE,
	0xBBD8, 0xA65E,
	0xBBD9, 0xB7B4,
	0xBBDA, 0xAEAC,
	0xBBDB, 0xBC7A,
	0xBBDC, 0xA563,
	0xBBDD, 0xB466,
	0xBBDE, 0xB1E2,
	0xBBDF, 0xB8EC,
	0xBBE0, 0xC2A9,
	0xBBE1, 0xB77C,
	0xBBE2, 0xC0ED,
	0xBBE3, 0xB6D7,
	0xBBE4, 0xBFD0,
	0xBBE5, 0xBBA3,
	0xBBE6, 0xC3B8,
	0xBBE7, 0xB8A7,
	0xBBE8, 0xA9FC,
	0xBBE9, 0xB142,
	0xBBEA, 0xBBEE,
	0xBBEB, 0xB4FD,
	0xBBEC, 0xB256,
	0xBBED, 0xC1C5,
	0xBBEE, 0xACA1,
	0xBBEF, 0xA5EB,
	0xBBF0, 0xA4F5,
	0xBBF1, 0xC0F2,
	0xBBF2, 0xA9CE,
	0xBBF3, 0xB462,
	0xBBF4, 0xC04E,
	0xBBF5, 0xB366,
	0xBBF6, 0xBAD7,
	0xBBF7, 0xC0BB,
	0xBBF8, 0xA7A3,
	0xBBF9, 0xB0F2,
	0xBBFA, 0xBEF7,
	0xBBFB, 0xB7EE,
	0xBBFC, 0xBD5D,
	0xBBFD, 0xBF6E,
	0xBBFE, 0xBADF,
	0xBCA1, 0xA6D9,
	0xBCA2, 0xB0A7,
	0xBCA3, 0xB8F1,
	0xBCA4, 0xBF45,
	0xBCA5, 0xC3D5,
	0xBCA6, 0xC2FB,
	0xBCA7, 0xAE56,
	0xBCA8, 0xC15A,
	0xBCA9, 0xBD72,
	0xBCAA, 0xA64E,
	0xBCAB, 0xB7A5,
	0xBCAC, 0xB4C6,
	0xBCAD, 0xBFE8,
	0xBCAE, 0xC479,
	0xBCAF, 0xB6B0,
	0xBCB0, 0xA4CE,
	0xBCB1, 0xABE6,
	0xBCB2, 0xAF65,
	0xBCB3, 0xA856,
	0xBCB4, 0xA759,
	0xBCB5, 0xB6FA,
	0xBCB6, 0xAFC5,
	0xBCB7, 0xC0BD,
	0xBCB8, 0xB458,
	0xBCB9, 0xAFE1,
	0xBCBA, 0xA476,
	0xBCBB, 0xC1AA,
	0xBCBC, 0xA7DE,
	0xBCBD, 0xBEAC,
	0xBCBE, 0xA975,
	0xBCBF, 0xC9AB,
	0xBCC0, 0xB2BD,
	0xBCC1, 0xBEAF,
	0xBCC2, 0xB1AA,
	0xBCC3, 0xC0D9,
	0xBCC4, 0xB148,
	0xBCC5, 0xB149,
	0xBCC6, 0xAD70,
	0xBCC7, 0xB04F,
	0xBCC8, 0xAC4A,
	0xBCC9, 0xA7D2,
	0xBCCA, 0xBBDA,
	0xBCCB, 0xA7B2,
	0xBCCC, 0xC47E,
	0xBCCD, 0xACF6,
	0xBCCE, 0xB9C5,
	0xBCCF, 0xCF45,
	0xBCD0, 0xA7A8,
	0xBCD1, 0xA8CE,
	0xBCD2, 0xAE61,
	0xBCD3, 0xA55B,
	0xBCD4, 0xB2F3,
	0xBCD5, 0xC055,
	0xBCD6, 0xB8EB,
	0xBCD7, 0xA5D2,
	0xBCD8, 0xB95B,
	0xBCD9, 0xB0B2,
	0xBCDA, 0xBD5B,
	0xBCDB, 0xBBF9,
	0xBCDC, 0xAC5B,
	0xBCDD, 0xBE72,
	0xBCDE, 0xB6F9,
	0xBCDF, 0xC4E8,
	0xBCE0, 0xBACA,
	0xBCE1, 0xB0ED,
	0xBCE2, 0xA679,
	0xBCE3, 0xBAE0,
	0xBCE4, 0xB6A1,
	0xBCE5, 0xB7CE,
	0xBCE6, 0xADDD,
	0xBCE7, 0xAAD3,
	0xBCE8, 0xC17D,
	0xBCE9, 0xA66C,
	0xBCEA, 0xBD70,
	0xBCEB, 0xC3B5,
	0xBCEC, 0xC0CB,
	0xBCED, 0xAC5A,
	0xBCEE, 0xC650,
	0xBCEF, 0xC650,
	0xBCF0, 0xB47A,
	0xBCF1, 0xBEDF,
	0xBCF2, 0xC2B2,
	0xBCF3, 0xBBFC,
	0xBCF4, 0xB0C5,
	0xBCF5, 0xB4EE,
	0xBCF6, 0xC2CB,
	0xBCF7, 0xC265,
	0xBCF8, 0xC5B3,
	0xBCF9, 0xBDEE,
	0xBCFA, 0xBDE2,
	0xBCFB, 0xA8A3,
	0xBCFC, 0xC1E4,
	0xBCFD, 0xBD62,
	0xBCFE, 0xA5F3,
	0xBDA1, 0xB0B7,
	0xBDA2, 0xC4A5,
	0xBDA3, 0xBC43,
	0xBDA4, 0xC05E,
	0xBDA5, 0xBAA5,
	0xBDA6, 0xC271,
	0xBDA7, 0xBCEE,
	0xBDA8, 0xABD8,
	0xBDA9, 0xBBF8,
	0xBDAA, 0xABB8,
	0xBDAB, 0xB14E,
	0xBDAC, 0xBCDF,
	0xBDAD, 0xA6BF,
	0xBDAE, 0xC3A6,
	0xBDAF, 0xBDB1,
	0xBDB0, 0xBCD5,
	0xBDB1, 0xBCFA,
	0xBDB2, 0xC1BF,
	0xBDB3, 0xA64B,
	0xBDB4, 0xC2E6,
	0xBDB5, 0xADB0,
	0xBDB6, 0xBFBC,
	0xBDB7, 0xB4D4,
	0xBDB8, 0xC147,
	0xBDB9, 0xB54A,
	0xBDBA, 0xBDA6,
	0xBDBB, 0xA5E6,
	0xBDBC, 0xADA5,
	0xBDBD, 0xBCE5,
	0xBDBE, 0xC5BA,
	0xBDBF, 0xBC62,
	0xBDC0, 0xC45A,
	0xBDC1, 0xC5CD,
	0xBDC2, 0xBBC7,
	0xBDC3, 0xC142,
	0xBDC4, 0xB9AE,
	0xBDC5, 0xB87D,
	0xBDC6, 0xACBE,
	0xBDC7, 0xA8A4,
	0xBDC8, 0xBBE5,
	0xBDC9, 0xC3BA,
	0xBDCA, 0xB5B1,
	0xBDCB, 0xB6CF,
	0xBDCC, 0xB1D0,
	0xBDCD, 0xBBC3,
	0xBDCE, 0xC3E2,
	0xBDCF, 0xB8FB,
	0xBDD0, 0xA573,
	0xBDD1, 0xB5A2,
	0xBDD2, 0xB4A6,
	0xBDD3, 0xB1B5,
	0xBDD4, 0xACD2,
	0xBDD5, 0xD6C5,
	0xBDD6, 0xB5F3,
	0xBDD7, 0xB6A5,
	0xBDD8, 0xBA49,
	0xBDD9, 0xA754,
	0xBDDA, 0xB860,
	0xBDDB, 0xAEDC,
	0xBDDC, 0xB3C7,
	0xBDDD, 0xB1B6,
	0xBDDE, 0xB7FB,
	0xBDDF, 0xBADC,
	0xBDE0, 0xBCE4,
	0xBDE1, 0xB5B2,
	0xBDE2, 0xB8D1,
	0xBDE3, 0xA96A,
	0xBDE4, 0xA7D9,
	0xBDE5, 0xC2C7,
	0xBDE6, 0xAAE3,
	0xBDE7, 0xACC9,
	0xBDE8, 0xADC9,
	0xBDE9, 0xA4B6,
	0xBDEA, 0xACCE,
	0xBDEB, 0xBB7C,
	0xBDEC, 0xA9A1,
	0xBDED, 0xA479,
	0xBDEE, 0xB5AC,
	0xBDEF, 0xA4E7,
	0xBDF0, 0xAAF7,
	0xBDF1, 0xA4B5,
	0xBDF2, 0xAC7A,
	0xBDF3, 0xC3CC,
	0xBDF4, 0xBAF2,
	0xBDF5, 0xC041,
	0xBDF6, 0xB6C8,
	0xBDF7, 0xC2D4,
	0xBDF8, 0xB669,
	0xBDF9, 0xE0DA,
	0xBDFA, 0xAECA,
	0xBDFB, 0xB854,
	0xBDFC, 0xAAF1,
	0xBDFD, 0xC275,
	0xBDFE, 0xAEFB,
	0xBEA1, 0xBAC9,
	0xBEA2, 0xAB6C,
	0xBEA3, 0xAFF0,
	0xBEA4, 0xB9B8,
	0xBEA5, 0xB2F4,
	0xBEA6, 0xB7FA,
	0xBEA7, 0xB4B9,
	0xBEA8, 0xC448,
	0xBEA9, 0xA8CA,
	0xBEAA, 0xC5E5,
	0xBEAB, 0xBAEB,
	0xBEAC, 0xB865,
	0xBEAD, 0xB867,
	0xBEAE, 0xA4AB,
	0xBEAF, 0xC4B5,
	0xBEB0, 0xB4BA,
	0xBEB1, 0xC056,
	0xBEB2, 0xC052,
	0xBEB3, 0xB9D2,
	0xBEB4, 0xB771,
	0xBEB5, 0xC3E8,
	0xBEB6, 0xAE7C,
	0xBEB7, 0xB56A,
	0xBEB8, 0xB974,
	0xBEB9, 0xB3BA,
	0xBEBA, 0xC476,
	0xBEBB, 0xB262,
	0xBEBC, 0xACB3,
	0xBEBD, 0xB57E,
	0xBEBE, 0xB4AA,
	0xBEBF, 0xA873,
	0xBEC0, 0xAAC8,
	0xBEC1, 0xA868,
	0xBEC2, 0xADB4,
	0xBEC3, 0xA45B,
	0xBEC4, 0xA862,
	0xBEC5, 0xA445,
	0xBEC6, 0xB073,
	0xBEC7, 0xB45C,
	0xBEC8, 0xB1CF,
	0xBEC9, 0xC2C2,
	0xBECA, 0xA6DD,
	0xBECB, 0xB8A4,
	0xBECC, 0xA953,
	0xBECD, 0xB44E,
	0xBECE, 0xAAB9,
	0xBECF, 0xC1F9,
	0xBED0, 0xA9EB,
	0xBED1, 0xAAAE,
	0xBED2, 0xAF6A,
	0xBED3, 0xA97E,
	0xBED4, 0xBE73,
	0xBED5, 0xB5E2,
	0xBED6, 0xA7BD,
	0xBED7, 0xA943,
	0xBED8, 0xAF78,
	0xBED9, 0xC17C,
	0xBEDA, 0xAA71,
	0xBEDB, 0xBB45,
	0xBEDC, 0xA9DA,
	0xBEDD, 0xBEDA,
	0xBEDE, 0xA5A8,
	0xBEDF, 0xA8E3,
	0xBEE0, 0xB65A,
	0xBEE1, 0xBDF5,
	0xBEE2, 0xBFF7,
	0xBEE3, 0xADD1,
	0xBEE4, 0xA579,
	0xBEE5, 0xC4DF,
	0xBEE6, 0xACB2,
	0xBEE7, 0xBC40,
	0xBEE8, 0xAEBD,
	0xBEE9, 0xC359,
	0xBEEA, 0xAE53,
	0xBEEB, 0xADC2,
	0xBEEC, 0xB2B2,
	0xBEED, 0xA8F7,
	0xBEEE, 0xB868,
	0xBEEF, 0xE5B1,
	0xBEF0, 0xC5CC,
	0xBEF1, 0xA7E0,
	0xBEF2, 0xB1B8,
	0xBEF3, 0xADCF,
	0xBEF4, 0xC0EF,
	0xBEF5, 0xC4B1,
	0xBEF6, 0xA84D,
	0xBEF7, 0xB35A,
	0xBEF8, 0xB5B4,
	0xBEF9, 0xA7A1,
	0xBEFA, 0xB5DF,
	0xBEFB, 0xB676,
	0xBEFC, 0xAD78,
	0xBEFD, 0xA767,
	0xBEFE, 0xAE6D,
	0xBFA1, 0xAB54,
	0xBFA2, 0xB5A4,
	0xBFA3, 0xC0E0,
	0xBFA4, 0xB070,
	0xBFA5, 0xC240,
	0xBFA6, 0xB3D8,
	0xBFA7, 0xA940,
	0xBFA8, 0xA564,
	0xBFA9, 0xABA3,
	0xBFAA, 0xB67D,
	0xBFAB, 0xB47B,
	0xBFAC, 0xB7A2,
	0xBFAD, 0xB3CD,
	0xBFAE, 0xB46E,
	0xBFAF, 0xA55A,
	0xBFB0, 0xB3F4,
	0xBFB1, 0xB0C9,
	0xBFB2, 0xA7A2,
	0xBFB3, 0xACE5,
	0xBFB4, 0xACDD,
	0xBFB5, 0xB164,
	0xBFB6, 0xBA42,
	0xBFB7, 0xC152,
	0xBFB8, 0xA6AA,
	0xBFB9, 0xA7DC,
	0xBFBA, 0xA4AE,
	0xBFBB, 0xAAA1,
	0xBFBC, 0xA6D2,
	0xBFBD, 0xABFE,
	0xBFBE, 0xAF4E,
	0xBFBF, 0xBE61,
	0xBFC0, 0xA956,
	0xBFC1, 0xAD56,
	0xBFC2, 0xAC5F,
	0xBFC3, 0xB4CA,
	0xBFC4, 0xBD57,
	0xBFC5, 0xC1FB,
	0xBFC6, 0xACEC,
	0xBFC7, 0xB4DF,
	0xBFC8, 0xAB79,
	0xBFC9, 0xA569,
	0xBFCA, 0xB4F7,
	0xBFCB, 0xA74A,
	0xBFCC, 0xA8E8,
	0xBFCD, 0xABC8,
	0xBFCE, 0xBDD2,
	0xBFCF, 0xAAD6,
	0xBFD0, 0xB0D9,
	0xBFD1, 0xBEC1,
	0xBFD2, 0xC0B5,
	0xBFD3, 0xA77C,
	0xBFD4, 0xA75C,
	0xBFD5, 0xAAC5,
	0xBFD6, 0xAEA3,
	0xBFD7, 0xA4D5,
	0xBFD8, 0xB1B1,
	0xBFD9, 0xE1E0,
	0xBFDA, 0xA466,
	0xBFDB, 0xA6A9,
	0xBFDC, 0xB146,
	0xBFDD, 0xAC5C,
	0xBFDE, 0xADFA,
	0xBFDF, 0xB85D,
	0xBFE0, 0xAD57,
	0xBFE1, 0xBBC5,
	0xBFE2, 0xAE77,
	0xBFE3, 0xBFC7,
	0xBFE4, 0xA66A,
	0xBFE5, 0xABB1,
	0xBFE6, 0xCED8,
	0xBFE7, 0xB8F3,
	0xBFE8, 0xAFE3,
	0xBFE9, 0xB6F4,
	0xBFEA, 0xB85F,
	0xBFEB, 0xBBFB,
	0xBFEC, 0xA7D6,
	0xBFED, 0xBC65,
	0xBFEE, 0xB4DA,
	0xBFEF, 0xA64A,
	0xBFF0, 0xB5A8,
	0xBFF1, 0xA867,
	0xBFF2, 0xAED8,
	0xBFF3, 0xC471,
	0xBFF4, 0xB2B5,
	0xBFF5, 0xC36D,
	0xBFF6, 0xAA70,
	0xBFF7, 0xC1AB,
	0xBFF8, 0xB2AF,
	0xBFF9, 0xF5C9,
	0xBFFA, 0xBF73,
	0xBFFB, 0xB8AA,
	0xBFFC, 0xABB6,
	0xBFFD, 0xBBED,
	0xBFFE, 0xB3C8,
	0xC0A1, 0xF558,
	0xC0A2, 0xB75C,
	0xC0A3, 0xBCEC,
	0xC0A4, 0xA95B,
	0xC0A5, 0xA9F8,
	0xC0A6, 0xAEB9,
	0xC0A7, 0xA778,
	0xC0A8, 0xAC41,
	0xC0A9, 0xC258,
	0xC0AA, 0xB9F8,
	0xC0AB, 0xC1EF,
	0xC0AC, 0xA955,
	0xC0AD, 0xA9D4,
	0xC0AE, 0xB3E2,
	0xC0AF, 0xC4FA,
	0xC0B0, 0xC3BE,
	0xC0B1, 0xBBB6,
	0xC0B2, 0xB0D5,
	0xC0B3, 0xB5DC,
	0xC0B4, 0xA8D3,
	0xC0B5, 0xBFE0,
	0xC0B6, 0xC2C5,
	0xC0B7, 0xB0FD,
	0xC0B8, 0xC4E6,
	0xC0B9, 0xC464,
	0xC0BA, 0xC478,
	0xC0BB, 0xC1F1,
	0xC0BC, 0xC4F5,
	0xC0BD, 0xC469,
	0xC0BE, 0xF8C2,
	0xC0BF, 0xC5F3,
	0xC0C0, 0xC4FD,
	0xC0C1, 0xC369,
	0xC0C2, 0xC66C,
	0xC0C3, 0xC4EA,
	0xC0C4, 0xC0DD,
	0xC0C5, 0xB277,
	0xC0C6, 0xB77D,
	0xC0C7, 0xAF54,
	0xC0C8, 0xB459,
	0xC0C9, 0xADA6,
	0xC0CA, 0xAED4,
	0xC0CB, 0xAEF6,
	0xC0CC, 0xBCB4,
	0xC0CD, 0xB3D2,
	0xC0CE, 0xA863,
	0xC0CF, 0xA6D1,
	0xC0D0, 0xA8D0,
	0xC0D1, 0xABBE,
	0xC0D2, 0xB954,
	0xC0D3, 0xAF4F,
	0xC0D4, 0xE5FC,
	0xC0D5, 0xB0C7,
	0xC0D6, 0xBCD6,
	0xC0D7, 0xB970,
	0xC0D8, 0xC54A,
	0xC0D9, 0xC1A2,
	0xC0DA, 0xBD55,
	0xC0DB, 0xB2D6,
	0xC0DC, 0xC077,
	0xC0DD, 0xC253,
	0xC0DE, 0xBEDD,
	0xC0DF, 0xA6D8,
	0xC0E0, 0xC3FE,
	0xC0E1, 0xB25C,
	0xC0E2, 0xD9B1,
	0xC0E3, 0xB7AB,
	0xC0E4, 0xA74E,
	0xC0E5, 0xCDF9,
	0xC0E6, 0xB1F9,
	0xC0E7, 0xB270,
	0xC0E8, 0xBEA4,
	0xC0E9, 0xC658,
	0xC0EA, 0xBBA9,
	0xC0EB, 0xC2F7,
	0xC0EC, 0xBA76,
	0xC0ED, 0xB27A,
	0xC0EE, 0xA7F5,
	0xC0EF, 0xB8CC,
	0xC0F0, 0xC355,
	0xC0F1, 0xC2A7,
	0xC0F2, 0xB2FA,
	0xC0F3, 0xAFEF,
	0xC0F4, 0xA64F,
	0xC0F5, 0xAEDF,
	0xC0F6, 0xC452,
	0xC0F7, 0xBC46,
	0xC0F8, 0xC079,
	0xC0F9, 0xC474,
	0xC0FA, 0xBEFA,
	0xC0FB, 0xA751,
	0xC0FC, 0xE0F4,
	0xC0FD, 0xA8D2,
	0xC0FE, 0xAB57,
	0xC1A1, 0xB567,
	0xC1A2, 0xA5DF,
	0xC1A3, 0xB2C9,
	0xC1A4, 0xC377,
	0xC1A5, 0xC1F5,
	0xC1A6, 0xA44F,
	0xC1A7, 0xBCFE,
	0xC1A8, 0xADF9,
	0xC1A9, 0xADC7,
	0xC1AA, 0xC170,
	0xC1AB, 0xBDAC,
	0xC1AC, 0xB373,
	0xC1AD, 0xC549,
	0xC1AE, 0xB747,
	0xC1AF, 0xBCA6,
	0xC1B0, 0xBAA7,
	0xC1B1, 0xA9A9,
	0xC1B2, 0xC0C4,
	0xC1B3, 0xC179,
	0xC1B4, 0xC3EC,
	0xC1B5, 0xC5CA,
	0xC1B6, 0xB7D2,
	0xC1B7, 0xBD6D,
	0xC1B8, 0xC2B3,
	0xC1B9, 0xB244,
	0xC1BA, 0xBCD9,
	0xC1BB, 0xB864,
	0xC1BC, 0xA87D,
	0xC1BD, 0xA8E2,
	0xC1BE, 0xBDF8,
	0xC1BF, 0xB671,
	0xC1C0, 0xB4BD,
	0xC1C1, 0xAB47,
	0xC1C2, 0xBDCC,
	0xC1C3, 0xBCBA,
	0xC1C4, 0xB2E1,
	0xC1C5, 0xB9B1,
	0xC1C6, 0xC0F8,
	0xC1C7, 0xBF52,
	0xC1C8, 0xB9E9,
	0xC1C9, 0xBFF1,
	0xC1CA, 0xBCE3,
	0xC1CB, 0xA446,
	0xC1CC, 0xE1E6,
	0xC1CD, 0xF4EF,
	0xC1CE, 0xB9F9,
	0xC1CF, 0xAEC6,
	0xC1D0, 0xA643,
	0xC1D1, 0xB5F5,
	0xC1D2, 0xAF50,
	0xC1D3, 0xA648,
	0xC1D4, 0xC279,
	0xC1D5, 0xB559,
	0xC1D6, 0xAA4C,
	0xC1D7, 0xC143,
	0xC1D8, 0xC04D,
	0xC1D9, 0xC17B,
	0xC1DA, 0xBE46,
	0xC1DB, 0xC5EC,
	0xC1DC, 0xB24F,
	0xC1DD, 0xBBFE,
	0xC1DE, 0xB8EE,
	0xC1DF, 0xA75B,
	0xC1E0, 0xA9F0,
	0xC1E1, 0xACC2,
	0xC1E2, 0xB5D9,
	0xC1E3, 0xB973,
	0xC1E4, 0xC4D6,
	0xC1E5, 0xB961,
	0xC1E6, 0xA744,
	0xC1E7, 0xB2DC,
	0xC1E8, 0xADE2,
	0xC1E9, 0xC646,
	0xC1EA, 0xB3AE,
	0xC1EB, 0xC0AD,
	0xC1EC, 0xBBE2,
	0xC1ED, 0xA574,
	0xC1EE, 0xA54F,
	0xC1EF, 0xB7C8,
	0xC1F0, 0xAF5B,
	0xC1F1, 0xBA68,
	0xC1F2, 0xB2B8,
	0xC1F3, 0xC348,
	0xC1F4, 0xAF64,
	0xC1F5, 0xBC42,
	0xC1F6, 0xBD46,
	0xC1F7, 0xAC79,
	0xC1F8, 0xAC68,
	0xC1F9, 0xA4BB,
	0xC1FA, 0xC073,
	0xC1FB, 0xC5A4,
	0xC1FC, 0xC456,
	0xC1FD, 0xC5A2,
	0xC1FE, 0xC14B,
	0xC2A1, 0xB6A9,
	0xC2A2, 0xC362,
	0xC2A3, 0xC36C,
	0xC2A4, 0xC3F7,
	0xC2A5, 0xBCD3,
	0xC2A6, 0xB0FA,
	0xC2A7, 0xBA4F,
	0xC2A8, 0xC14D,
	0xC2A9, 0xBA7C,
	0xC2AA, 0xADAE,
	0xC2AB, 0xC4AA,
	0xC2AC, 0xBF63,
	0xC2AD, 0xC660,
	0xC2AE, 0xC366,
	0xC2AF, 0xC46C,
	0xC2B0, 0xBEDB,
	0xC2B1, 0xB3BF,
	0xC2B2, 0xB8B8,
	0xC2B3, 0xBE7C,
	0xC2B4, 0xC453,
	0xC2B5, 0xB84C,
	0xC2B6, 0xC553,
	0xC2B7, 0xB8F4,
	0xC2B8, 0xB8EF,
	0xC2B9, 0xB3C0,
	0xC2BA, 0xE9F0,
	0xC2BB, 0xB853,
	0xC2BC, 0xBFFD,
	0xC2BD, 0xB3B0,
	0xC2BE, 0xBCAE,
	0xC2BF, 0xC66A,
	0xC2C0, 0xA766,
	0xC2C1, 0xBE54,
	0xC2C2, 0xAB51,
	0xC2C3, 0xAEC8,
	0xC2C4, 0xBC69,
	0xC2C5, 0xB9F0,
	0xC2C6, 0xC15C,
	0xC2C7, 0xBC7B,
	0xC2C8, 0xB4E2,
	0xC2C9, 0xABDF,
	0xC2CA, 0xB276,
	0xC2CB, 0xC26F,
	0xC2CC, 0xBAF1,
	0xC2CD, 0xC572,
	0xC2CE, 0xC5CB,
	0xC2CF, 0xC570,
	0xC2D0, 0xC665,
	0xC2D1, 0xA75A,
	0xC2D2, 0xB6C3,
	0xC2D3, 0xB1B0,
	0xC2D4, 0xB2A4,
	0xC2D5, 0xB1C1,
	0xC2D6, 0xBDFC,
	0xC2D7, 0xADDB,
	0xC2D8, 0xA8DA,
	0xC2D9, 0xB25F,
	0xC2DA, 0xBAFA,
	0xC2DB, 0xBDD7,
	0xC2DC, 0xC5DA,
	0xC2DD, 0xC1B3,
	0xC2DE, 0xC3B9,
	0xC2DF, 0xC5DE,
	0xC2E0, 0xC672,
	0xC2E1, 0xC659,
	0xC2E2, 0xC55B,
	0xC2E3, 0xBB72,
	0xC2E4, 0xB8A8,
	0xC2E5, 0xACA5,
	0xC2E6, 0xC064,
	0xC2E7, 0xB5B8,
	0xC2E8, 0xB6FD,
	0xC2E9, 0xB3C2,
	0xC2EA, 0xBABF,
	0xC2EB, 0xBD58,
	0xC2EC, 0xBFC2,
	0xC2ED, 0xB0A8,
	0xC2EE, 0xBD7C,
	0xC2EF, 0xB9C0,
	0xC2F0, 0xB6DC,
	0xC2F1, 0xAE49,
	0xC2F2, 0xB652,
	0xC2F3, 0xB3C1,
	0xC2F4, 0xBDE6,
	0xC2F5, 0xC1DA,
	0xC2F6, 0xAFDF,
	0xC2F7, 0xBF66,
	0xC2F8, 0xC443,
	0xC2F9, 0xC65A,
	0xC2FA, 0xBAA1,
	0xC2FB, 0xBDAF,
	0xC2FC, 0xB0D2,
	0xC2FD, 0xBA43,
	0xC2FE, 0xBAA9,
	0xC3A1, 0xF0E3,
	0xC3A2, 0xA87E,
	0xC3A3, 0xAFED,
	0xC3A4, 0xAABC,
	0xC3A5, 0xAA5D,
	0xC3A6, 0xA6A3,
	0xC3A7, 0xB2F5,
	0xC3A8, 0xBFDF,
	0xC3A9, 0xAD54,
	0xC3AA, 0xC1E3,
	0xC3AB, 0xA4F2,
	0xC3AC, 0xA5D9,
	0xC3AD, 0xB967,
	0xC3AE, 0xA566,
	0xC3AF, 0xAD5A,
	0xC3B0, 0xAB5F,
	0xC3B1, 0xB455,
	0xC3B2, 0xBBAA,
	0xC3B3, 0xB654,
	0xC3B4, 0xBBF2,
	0xC3B5, 0xAAB4,
	0xC3B6, 0xAA54,
	0xC3B7, 0xB1F6,
	0xC3B9, 0xBE60,
	0xC3BA, 0xB7D1,
	0xC3BB, 0xA853,
	0xC3BC, 0xACDC,
	0xC3BD, 0xB443,
	0xC3BE, 0xC1E2,
	0xC3BF, 0xA843,
	0xC3C0, 0xACFC,
	0xC3C1, 0xAC4E,
	0xC3C2, 0xB44B,
	0xC3C3, 0xA966,
	0xC3C4, 0xB441,
	0xC3C5, 0xAAF9,
	0xC3C6, 0xB465,
	0xC3C7, 0xADCC,
	0xC3C8, 0xB5DE,
	0xC3C9, 0xBB58,
	0xC3CA, 0xC263,
	0xC3CB, 0xB7F9,
	0xC3CC, 0xBFF8,
	0xC3CD, 0xB272,
	0xC3CE, 0xB9DA,
	0xC3CF, 0xA973,
	0xC3D0, 0xBD4E,
	0xC3D1, 0xEEC5,
	0xC3D2, 0xC3FB,
	0xC3D3, 0xC153,
	0xC3D4, 0xB067,
	0xC3D5, 0xC1BC,
	0xC3D6, 0xC0B1,
	0xC3D7, 0xA6CC,
	0xC3D8, 0xAFB5,
	0xC3D9, 0xB356,
	0xC3DA, 0xAA63,
	0xC3DB, 0xBB65,
	0xC3DC, 0xB14B,
	0xC3DD, 0xBEAD,
	0xC3DE, 0xB4D6,
	0xC3DF, 0xAF76,
	0xC3E0, 0xBAF8,
	0xC3E1, 0xB0C3,
	0xC3E2, 0xA74B,
	0xC3E3, 0xAB6A,
	0xC3E4, 0xAE59,
	0xC3E5, 0xBD71,
	0xC3E6, 0xADB1,
	0xC3E7, 0xAD5D,
	0xC3E8, 0xB479,
	0xC3E9, 0xBACB,
	0xC3EA, 0xC2C6,
	0xC3EB, 0xACED,
	0xC3EC, 0xB4F9,
	0xC3ED, 0xBC71,
	0xC3EE, 0xA7AE,
	0xC3EF, 0xBDB0,
	0xC3F0, 0xB7C0,
	0xC3F1, 0xA5C1,
	0xC3F2, 0xA9D7,
	0xC3F3, 0xA5D7,
	0xC3F4, 0xB1D3,
	0xC3F5, 0xBCA7,
	0xC3F6, 0xBBD4,
	0xC3F7, 0xA9FA,
	0xC3F8, 0xBFC1,
	0xC3F9, 0xBBEF,
	0xC3FA, 0xBBCA,
	0xC3FB, 0xA657,
	0xC3FC, 0xA952,
	0xC3FD, 0xC2D5,
	0xC3FE, 0xBA4E,
	0xC4A1, 0xBCB1,
	0xC4A2, 0xC4A8,
	0xC4A3, 0xBCD2,
	0xC4A4, 0xBDA4,
	0xC4A5, 0xBF69,
	0xC4A6, 0xBCAF,
	0xC4A7, 0xC55D,
	0xC4A8, 0xA9D9,
	0xC4A9, 0xA5BD,
	0xC4AA, 0xB2F6,
	0xC4AB, 0xBEA5,
	0xC4AC, 0xC071,
	0xC4AD, 0xAA6A,
	0xC4AE, 0xBA7A,
	0xC4AF, 0xB9E6,
	0xC4B0, 0xADAF,
	0xC4B1, 0xBFD1,
	0xC4B2, 0xA6C8,
	0xC4B3, 0xAC59,
	0xC4B4, 0xA9E6,
	0xC4B5, 0xA864,
	0xC4B6, 0xAF61,
	0xC4B7, 0xA969,
	0xC4B8, 0xA5C0,
	0xC4B9, 0xB9D3,
	0xC4BA, 0xBCC7,
	0xC4BB, 0xB9F5,
	0xC4BC, 0xB6D2,
	0xC4BD, 0xBC7D,
	0xC4BE, 0xA4EC,
	0xC4BF, 0xA5D8,
	0xC4C0, 0xB7FC,
	0xC4C1, 0xAAAA,
	0xC4C2, 0xBF70,
	0xC4C3, 0xAEB3,
	0xC4C4, 0xADFE,
	0xC4C5, 0xA76F,
	0xC4C6, 0xB675,
	0xC4C7, 0xA8BA,
	0xC4C8, 0xAE52,
	0xC4C9, 0xAFC7,
	0xC4CA, 0xA6BB,
	0xC4CB, 0xA444,
	0xC4CC, 0xA5A4,
	0xC4CD, 0xAD40,
	0xC4CE, 0xA960,
	0xC4CF, 0xAB6E,
	0xC4D0, 0xA86B,
	0xC4D1, 0xC3F8,
	0xC4D2, 0xC56E,
	0xC4D3, 0xBCB8,
	0xC4D4, 0xB8A3,
	0xC4D5, 0xB46F,
	0xC4D6, 0xBE78,
	0xC4D7, 0xD5EF,
	0xC4D8, 0xA94F,
	0xC4D9, 0xBE6B,
	0xC4DA, 0xA4BA,
	0xC4DB, 0xB9E0,
	0xC4DC, 0xAFE0,
	0xC4DD, 0xA967,
	0xC4DE, 0xC04F,
	0xC4DF, 0xADD9,
	0xC4E0, 0xAA64,
	0xC4E1, 0xA5A7,
	0xC4E2, 0xC0C0,
	0xC4E3, 0xA741,
	0xC4E4, 0xB0CE,
	0xC4E5, 0xBFB0,
	0xC4E6, 0xB066,
	0xC4E7, 0xB7C4,
	0xC4E8, 0xE759,
	0xC4E9, 0xA9E0,
	0xC4EA, 0xA67E,
	0xC4EB, 0xBD56,
	0xC4EC, 0xC25B,
	0xC4ED, 0xB1C9,
	0xC4EE, 0xA9C0,
	0xC4EF, 0xAE51,
	0xC4F0, 0xC643,
	0xC4F1, 0xB3BE,
	0xC4F2, 0xA7BF,
	0xC4F3, 0xAEBA,
	0xC4F4, 0xC2BF,
	0xC4F5, 0xC45E,
	0xC4F6, 0xEFBF,
	0xC4F7, 0xC668,
	0xC4F8, 0xC2EC,
	0xC4F9, 0xAF49,
	0xC4FA, 0xB17A,
	0xC4FB, 0xC266,
	0xC4FC, 0xC0F1,
	0xC4FD, 0xBEAE,
	0xC4FE, 0xB9E7,
	0xC5A1, 0xC0BE,
	0xC5A2, 0xC0D7,
	0xC5A3, 0xA4FB,
	0xC5A4, 0xA7E1,
	0xC5A5, 0xB673,
	0xC5A6, 0xAFC3,
	0xC5A7, 0xC177,
	0xC5A8, 0xBF40,
	0xC5A9, 0xB941,
	0xC5AA, 0xA7CB,
	0xC5AB, 0xA5A3,
	0xC5AC, 0xA756,
	0xC5AD, 0xABE3,
	0xC5AE, 0xA46B,
	0xC5AF, 0xB778,
	0xC5B0, 0xAD68,
	0xC5B1, 0xBAC4,
	0xC5B2, 0xAEBF,
	0xC5B3, 0xC0B6,
	0xC5B4, 0xC47A,
	0xC5B5, 0xBFD5,
	0xC5B6, 0xAE40,
	0xC5B7, 0xBCDA,
	0xC5B8, 0xC5C3,
	0xC5B9, 0xBCDE,
	0xC5BA, 0xC3C2,
	0xC5BB, 0xB9C3,
	0xC5BC, 0xB0B8,
	0xC5BD, 0xE278,
	0xC5BE, 0xB0D4,
	0xC5BF, 0xAD77,
	0xC5C0, 0xAAA6,
	0xC5C1, 0xA9AC,
	0xC5C2, 0xA9C8,
	0xC5C3, 0xB55D,
	0xC5C4, 0xA9E7,
	0xC5C5, 0xB1C6,
	0xC5C6, 0xB550,
	0xC5C7, 0xB172,
	0xC5C8, 0xB4FB,
	0xC5C9, 0xACA3,
	0xC5CA, 0xC36B,
	0xC5CB, 0xBCEF,
	0xC5CC, 0xBD4C,
	0xC5CD, 0xBD59,
	0xC5CE, 0xACDF,
	0xC5CF, 0xAF60,
	0xC5D0, 0xA750,
	0xC5D1, 0xAB71,
	0xC5D2, 0xA5E3,
	0xC5D3, 0xC365,
	0xC5D4, 0xAEC7,
	0xC5D5, 0xEAE5,
	0xC5D6, 0xAD44,
	0xC5D7, 0xA9DF,
	0xC5D8, 0xA948,
	0xC5D9, 0xA753,
	0xC5DA, 0xACB6,
	0xC5DB, 0xB354,
	0xC5DC, 0xB65D,
	0xC5DD, 0xAA77,
	0xC5DE, 0xA941,
	0xC5DF, 0xAD46,
	0xC5E0, 0xB0F6,
	0xC5E1, 0xBB70,
	0xC5E2, 0xBDDF,
	0xC5E3, 0xB3AD,
	0xC5E4, 0xB074,
	0xC5E5, 0xA8D8,
	0xC5E6, 0xA84B,
	0xC5E7, 0xBC51,
	0xC5E8, 0xACD6,
	0xC5E9, 0xAF79,
	0xC5EA, 0xA9E1,
	0xC5EB, 0xB269,
	0xC5EC, 0xBCEA,
	0xC5ED, 0xB45E,
	0xC5EE, 0xBDB4,
	0xC5EF, 0xB4D7,
	0xC5F0, 0xB84E,
	0xC5F1, 0xC14F,
	0xC5F2, 0xBFB1,
	0xC5F3, 0xAA42,
	0xC5F4, 0xC450,
	0xC5F5, 0xB1B7,
	0xC5F6, 0xB849,
	0xC5F7, 0xCBF2,
	0xC5F8, 0xCFEC,
	0xC5F9, 0xC552,
	0xC5FA, 0xA7E5,
	0xC5FB, 0xA9DC,
	0xC5FC, 0xBC41,
	0xC5FD, 0xB55C,
	0xC5FE, 0xAC73,
	0xC6A1, 0xB0E0,
	0xC6A2, 0xB5CA,
	0xC6A3, 0xAF68,
	0xC6A4, 0xA5D6,
	0xC6A5, 0xA4C7,
	0xC6A6, 0xB56C,
	0xC6A7, 0xBBF7,
	0xC6A8, 0xA7BE,
	0xC6A9, 0xC4B4,
	0xC6AA, 0xBD67,
	0xC6AB, 0xB0BE,
	0xC6AC, 0xA4F9,
	0xC6AD, 0xC446,
	0xC6AE, 0xC4C6,
	0xC6AF, 0xBA7D,
	0xC6B0, 0xBF5D,
	0xC6B1, 0xB2BC,
	0xC6B2, 0xBA4A,
	0xC6B3, 0xBF68,
	0xC6B4, 0xABF7,
	0xC6B5, 0xC057,
	0xC6B6, 0xB368,
	0xC6B7, 0xAB7E,
	0xC6B8, 0xB875,
	0xC6B9, 0xA5E2,
	0xC6BA, 0xA957,
	0xC6BB, 0xC4AB,
	0xC6BC, 0xB5D3,
	0xC6BD, 0xA5AD,
	0xC6BE, 0xBECC,
	0xC6BF, 0xB27E,
	0xC6C0, 0xB5FB,
	0xC6C1, 0xABCC,
	0xC6C2, 0xA959,
	0xC6C3, 0xBCE2,
	0xC6C4, 0xBBE1,
	0xC6C5, 0xB143,
	0xC6C6, 0xAF7D,
	0xC6C7, 0xBE7A,
	0xC6C8, 0xADA2,
	0xC6C9, 0xB2CB,
	0xC6CA, 0xADE5,
	0xC6CB, 0xBCB3,
	0xC6CC, 0xE745,
	0xC6CD, 0xB9B2,
	0xC6CE, 0xB340,
	0xC6CF, 0xB8B2,
	0xC6D0, 0xB5D0,
	0xC6D1, 0xBB5A,
	0xC6D2, 0xAE48,
	0xC6D3, 0xA6B5,
	0xC6D4, 0xAE45,
	0xC6D5, 0xB4B6,
	0xC6D6, 0xAEFA,
	0xC6D7, 0xC3D0,
	0xC6D8, 0xC36E,
	0xC6D9, 0xC272,
	0xC6DA, 0xB4C1,
	0xC6DB, 0xB4DB,
	0xC6DC, 0xB4CF,
	0xC6DD, 0xB1AD,
	0xC6DE, 0xA964,
	0xC6DF, 0xA443,
	0xC6E0, 0xB259,
	0xC6E1, 0xBAA3,
	0xC6E2, 0xAC6D,
	0xC6E3, 0xCB50,
	0xC6E4, 0xA8E4,
	0xC6E5, 0xB4D1,
	0xC6E6, 0xA95F,
	0xC6E7, 0xAA5B,
	0xC6E8, 0xB2A5,
	0xC6E9, 0xB154,
	0xC6EA, 0xC2C0,
	0xC6EB, 0xBBF4,
	0xC6EC, 0xBA58,
	0xC6ED, 0xACE8,
	0xC6EE, 0xAAC2,
	0xC6EF, 0xC34D,
	0xC6F0, 0xB05F,
	0xC6F1, 0xB05A,
	0xC6F2, 0xA45E,
	0xC6F3, 0xA5F8,
	0xC6F4, 0xB1D2,
	0xC6F5, 0xABB4,
	0xC6F6, 0xACE4,
	0xC6F7, 0xBEB9,
	0xC6F8, 0xAEF0,
	0xC6F9, 0xA8B4,
	0xC6FA, 0xB1F3,
	0xC6FB, 0xA854,
	0xC6FC, 0xAA5F,
	0xC6FD, 0xB057,
	0xC6FE, 0xD574,
	0xC7A1, 0xABEA,
	0xC7A2, 0xACA2,
	0xC7A3, 0xB26F,
	0xC7A4, 0xC9E7,
	0xC7A6, 0xB95D,
	0xC7A7, 0xA464,
	0xC7A8, 0xBE45,
	0xC7A9, 0xC3B1,
	0xC7AA, 0xA561,
	0xC7AB, 0xC1BE,
	0xC7AC, 0xB0AE,
	0xC7AD, 0xC072,
	0xC7AE, 0xBFFA,
	0xC7AF, 0xB958,
	0xC7B0, 0xAB65,
	0xC7B1, 0xBCE7,
	0xC7B2, 0xBBBA,
	0xC7B3, 0xB24C,
	0xC7B4, 0xC4FE,
	0xC7B5, 0xB9D5,
	0xC7B6, 0xB44F,
	0xC7B7, 0xA4ED,
	0xC7B8, 0xBA70,
	0xC7B9, 0xBA6A,
	0xC7BA, 0xB6E6,
	0xC7BB, 0xB5C4,
	0xC7BC, 0xAACA,
	0xC7BD, 0xC0F0,
	0xC7BE, 0xC1A5,
	0xC7BF, 0xB16A,
	0xC7C0, 0xB76D,
	0xC7C1, 0xBEF5,
	0xC7C2, 0xC1EA,
	0xC7C3, 0xBA56,
	0xC7C4, 0xAEA8,
	0xC7C5, 0xBEF4,
	0xC7C6, 0xC140,
	0xC7C7, 0xB3EC,
	0xC7C8, 0xB9B4,
	0xC7C9, 0xA5A9,
	0xC7CA, 0xC054,
	0xC7CB, 0xBCC0,
	0xC7CC, 0xC2BC,
	0xC7CD, 0xAE6B,
	0xC7CE, 0xAB4E,
	0xC7CF, 0xC2AC,
	0xC7D0, 0xA4C1,
	0xC7D1, 0xAD58,
	0xC7D2, 0xA542,
	0xC7D3, 0xA9C4,
	0xC7D4, 0xC5D1,
	0xC7D5, 0xB4DC,
	0xC7D6, 0xAB49,
	0xC7D7, 0xBFCB,
	0xC7D8, 0xAFB3,
	0xC7D9, 0xB55E,
	0xC7DA, 0xB6D4,
	0xC7DB, 0xAAE0,
	0xC7DC, 0xBEE0,
	0xC7DD, 0xB856,
	0xC7DE, 0xB9EC,
	0xC7DF, 0xA847,
	0xC7E0, 0xAB43,
	0xC7E1, 0xBBB4,
	0xC7E2, 0xB242,
	0xC7E3, 0xB6C9,
	0xC7E4, 0xADEB,
	0xC7E5, 0xB24D,
	0xC7E6, 0xC0BA,
	0xC7E7, 0xB4B8,
	0xC7E8, 0xD9E6,
	0xC7E9, 0xB1A1,
	0xC7EA, 0xB3BC,
	0xC7EB, 0xBDD0,
	0xC7EC, 0xBC79,
	0xC7ED, 0xC3A3,
	0xC7EE, 0xBD61,
	0xC7EF, 0xACEE,
	0xC7F0, 0xA543,
	0xC7F1, 0xAAF4,
	0xC7F2, 0xB279,
	0xC7F3, 0xA844,
	0xC7F4, 0xA57D,
	0xC7F5, 0xADA9,
	0xC7F6, 0xAA73,
	0xC7F7, 0xC1CD,
	0xC7F8, 0xB0CF,
	0xC7F9, 0xB349,
	0xC7FA, 0xA6B1,
	0xC7FB, 0xC2DF,
	0xC7FC, 0xA97D,
	0xC7FD, 0xC558,
	0xC7FE, 0xB4EB,
	0xC8A1, 0xA8FA,
	0xC8A2, 0xB0F9,
	0xC8A3, 0xC654,
	0xC8A4, 0xBDEC,
	0xC8A5, 0xA568,
	0xC8A6, 0xB0E9,
	0xC8A7, 0xF9AF,
	0xC8A8, 0xC576,
	0xC8A9, 0xEEC7,
	0xC8AA, 0xAC75,
	0xC8AB, 0xA5FE,
	0xC8AC, 0xB2AC,
	0xC8AD, 0xAEB1,
	0xC8AE, 0xA4FC,
	0xC8AF, 0xA8E9,
	0xC8B0, 0xC455,
	0xC8B1, 0xAFCA,
	0xC8B2, 0xCD50,
	0xC8B3, 0xBF61,
	0xC8B4, 0xAB6F,
	0xC8B5, 0xC44E,
	0xC8B6, 0xBA65,
	0xC8B7, 0xBD54,
	0xC8B8, 0xB3B6,
	0xC8B9, 0xB8C8,
	0xC8BA, 0xB873,
	0xC8BB, 0xB54D,
	0xC8BC, 0xBF55,
	0xC8BD, 0xA554,
	0xC8BE, 0xAC56,
	0xC8BF, 0xC57B,
	0xC8C0, 0xC45B,
	0xC8C1, 0xC463,
	0xC8C2, 0xC457,
	0xC8C3, 0xC5FD,
	0xC8C4, 0xC4C7,
	0xC8C5, 0xC25A,
	0xC8C6, 0xC2B6,
	0xC8C7, 0xB753,
	0xC8C8, 0xBCF6,
	0xC8C9, 0xA4D0,
	0xC8CA, 0xA4AF,
	0xC8CB, 0xA448,
	0xC8CC, 0xA7D4,
	0xC8CD, 0xB6B4,
	0xC8CE, 0xA5F4,
	0xC8CF, 0xBB7B,
	0xC8D0, 0xA462,
	0xC8D1, 0xA7B3,
	0xC8D2, 0xACF7,
	0xC8D3, 0xA5B5,
	0xC8D4, 0xA4B4,
	0xC8D5, 0xA4E9,
	0xC8D6, 0xA6A5,
	0xC8D7, 0xAFF1,
	0xC8D8, 0xBB54,
	0xC8D9, 0xBA61,
	0xC8DA, 0xBFC4,
	0xC8DB, 0xBAB2,
	0xC8DC, 0xB7BB,
	0xC8DD, 0xAE65,
	0xC8DE, 0xB5B3,
	0xC8DF, 0xA4BE,
	0xC8E0, 0xB47C,
	0xC8E1, 0xAC58,
	0xC8E2, 0xA6D7,
	0xC8E3, 0xAFF8,
	0xC8E4, 0xC4AF,
	0xC8E5, 0xBEA7,
	0xC8E6, 0xC0A9,
	0xC8E7, 0xA670,
	0xC8E8, 0xB064,
	0xC8E9, 0xA8C5,
	0xC8EA, 0xA6BC,
	0xC8EB, 0xA44A,
	0xC8EC, 0xBFC8,
	0xC8ED, 0xB36E,
	0xC8EE, 0xA8BF,
	0xC8EF, 0xBFB6,
	0xC8F0, 0xB7E7,
	0xC8F1, 0xBE55,
	0xC8F2, 0xB67C,
	0xC8F3, 0xBCED,
	0xC8F4, 0xAD59,
	0xC8F5, 0xAE7A,
	0xC8F6, 0xBCBB,
	0xC8F7, 0xCF73,
	0xC8F8, 0xC2C4,
	0xC8F9, 0xB87C,
	0xC8FA, 0xC4CE,
	0xC8FB, 0xB6EB,
	0xC8FC, 0xC1C9,
	0xC8FD, 0xA454,
	0xC8FE, 0xA454,
	0xC9A1, 0xB3CA,
	0xC9A2, 0xB4B2,
	0xC9A3, 0xAEE1,
	0xC9A4, 0xB6DA,
	0xC9A5, 0xB3E0,
	0xC9A6, 0xB76B,
	0xC9A7, 0xC4CC,
	0xC9A8, 0xB1BD,
	0xC9A9, 0xB741,
	0xC9AA, 0xB7E6,
	0xC9AB, 0xA6E2,
	0xC9AC, 0xC0DF,
	0xC9AD, 0xB4CB,
	0xC9AE, 0xB9AC,
	0xC9AF, 0xB2EF,
	0xC9B0, 0xACE2,
	0xC9B1, 0xB1FE,
	0xC9B2, 0xAB62,
	0xC9B3, 0xA846,
	0xC9B4, 0xAFBD,
	0xC9B5, 0xB6CC,
	0xC9B6, 0xD4A3,
	0xC9B7, 0xB7D9,
	0xC9B8, 0xBF7A,
	0xC9B9, 0xC5CE,
	0xC9BA, 0xACC0,
	0xC9BB, 0xD073,
	0xC9BC, 0xA7FC,
	0xC9BD, 0xA473,
	0xC9BE, 0xA752,
	0xC9BF, 0xBAB4,
	0xC9C0, 0xAD6D,
	0xC9C1, 0xB07B,
	0xC9C2, 0xB0A2,
	0xC9C3, 0xBED5,
	0xC9C4, 0xC4BA,
	0xC9C5, 0xBFAF,
	0xC9C6, 0xB5BD,
	0xC9C7, 0xA6C2,
	0xC9C8, 0xAEB0,
	0xC9C9, 0xC2B5,
	0xC9CA, 0xE161,
	0xC9CB, 0xB6CB,
	0xC9CC, 0xB0D3,
	0xC9CD, 0xBDE0,
	0xC9CE, 0xAECE,
	0xC9CF, 0xA457,
	0xC9D0, 0xA97C,
	0xC9D1, 0xBB6E,
	0xC9D2, 0xB1E9,
	0xC9D3, 0xAEB4,
	0xC9D4, 0xB579,
	0xC9D5, 0xBF4E,
	0xC9D6, 0xA8A2,
	0xC9D7, 0xA463,
	0xC9D8, 0xBBE0,
	0xC9D9, 0xA4D6,
	0xC9DA, 0xADEF,
	0xC9DB, 0xAAF2,
	0xC9DC, 0xB2D0,
	0xC9DD, 0xB0F8,
	0xC9DE, 0xBBAD,
	0xC9DF, 0xB344,
	0xC9E0, 0xA6DE,
	0xC9E1, 0xAAD9,
	0xC9E2, 0xB36A,
	0xC9E3, 0xC4E1,
	0xC9E4, 0xAE67,
	0xC9E5, 0xC4E0,
	0xC9E6, 0xAF41,
	0xC9E7, 0xAAC0,
	0xC9E8, 0xB35D,
	0xC9E9, 0xAF7E,
	0xC9EA, 0xA5D3,
	0xC9EB, 0xA944,
	0xC9EC, 0xA6F9,
	0xC9ED, 0xA8AD,
	0xC9EE, 0xB260,
	0xC9EF, 0xAE57,
	0xC9F0, 0xB2D4,
	0xC9F1, 0xAFAB,
	0xC9F2, 0xA848,
	0xC9F3, 0xBC66,
	0xC9F4, 0xC254,
	0xC9F5, 0xACC6,
	0xC9F6, 0xB5C7,
	0xC9F7, 0xB756,
	0xC9F8, 0xBAAF,
	0xC9F9, 0xC16E,
	0xC9FA, 0xA5CD,
	0xC9FB, 0xB563,
	0xC9FC, 0xACB9,
	0xC9FD, 0xA4C9,
	0xC9FE, 0xC3B7,
	0xCAA1, 0xACD9,
	0xCAA2, 0xB2B1,
	0xCAA3, 0xB3D1,
	0xCAA4, 0xB3D3,
	0xCAA5, 0xB874,
	0xCAA6, 0xAE76,
	0xCAA7, 0xA5A2,
	0xCAA8, 0xB7E0,
	0xCAA9, 0xAC49,
	0xCAAA, 0xC0E3,
	0xCAAB, 0xB8D6,
	0xCAAC, 0xABCD,
	0xCAAD, 0xBDBE,
	0xCAAE, 0xA451,
	0xCAAF, 0xA5DB,
	0xCAB0, 0xAC42,
	0xCAB1, 0xAEC9,
	0xCAB2, 0xA4B0,
	0xCAB3, 0xADB9,
	0xCAB4, 0xBB6B,
	0xCAB5, 0xB9EA,
	0xCAB6, 0xC3D1,
	0xCAB7, 0xA576,
	0xCAB8, 0xA5DA,
	0xCAB9, 0xA8CF,
	0xCABA, 0xABCB,
	0xCABB, 0xBE70,
	0xCABC, 0xA96C,
	0xCABD, 0xA6A1,
	0xCABE, 0xA5DC,
	0xCABF, 0xA468,
	0xCAC0, 0xA540,
	0xCAC1, 0xAC55,
	0xCAC2, 0xA8C6,
	0xCAC3, 0xABF8,
	0xCAC4, 0xBB7D,
	0xCAC5, 0xB375,
	0xCAC6, 0xB6D5,
	0xCAC7, 0xAC4F,
	0xCAC8, 0xB6DD,
	0xCAC9, 0xBEBD,
	0xCACA, 0xBE41,
	0xCACB, 0xA54B,
	0xCACC, 0xA8CD,
	0xCACD, 0xC4C0,
	0xCACE, 0xB9A2,
	0xCACF, 0xA4F3,
	0xCAD0, 0xA5AB,
	0xCAD1, 0xABEE,
	0xCAD2, 0xABC7,
	0xCAD3, 0xB5F8,
	0xCAD4, 0xB8D5,
	0xCAD5, 0xA6AC,
	0xCAD6, 0xA4E2,
	0xCAD7, 0xADBA,
	0xCAD8, 0xA675,
	0xCAD9, 0xB9D8,
	0xCADA, 0xB1C2,
	0xCADB, 0xB0E2,
	0xCADC, 0xA8FC,
	0xCADD, 0xBD47,
	0xCADE, 0xC37E,
	0xCADF, 0xBDAD,
	0xCAE0, 0xBCCF,
	0xCAE1, 0xAEDE,
	0xCAE2, 0xAEED,
	0xCAE3, 0xA7E7,
	0xCAE4, 0xBFE9,
	0xCAE5, 0xA8FB,
	0xCAE6, 0xB5CE,
	0xCAE7, 0xB251,
	0xCAE8, 0xB2A8,
	0xCAE9, 0xAED1,
	0xCAEA, 0xC5AB,
	0xCAEB, 0xB145,
	0xCAEC, 0xBCF4,
	0xCAED, 0xC1A6,
	0xCAEE, 0xB4BB,
	0xCAEF, 0xC0C6,
	0xCAF0, 0xB870,
	0xCAF1, 0xB8BE,
	0xCAF2, 0xB6C1,
	0xCAF3, 0xB9AB,
	0xCAF4, 0xC4DD,
	0xCAF5, 0xB34E,
	0xCAF6, 0xAD7A,
	0xCAF7, 0xBEF0,
	0xCAF8, 0xA7F4,
	0xCAF9, 0xA6A7,
	0xCAFA, 0xBDDD,
	0xCAFB, 0xB9D6,
	0xCAFC, 0xB166,
	0xCAFD, 0xBCC6,
	0xCAFE, 0xBAA4,
	0xCBA1, 0xAEA4,
	0xCBA2, 0xA8EA,
	0xCBA3, 0xAD41,
	0xCBA4, 0xBA4C,
	0xCBA5, 0xB049,
	0xCBA6, 0xA5CF,
	0xCBA7, 0xABD3,
	0xCBA8, 0xAEEA,
	0xCBA9, 0xAC43,
	0xCBAA, 0xC1F7,
	0xCBAB, 0xC2F9,
	0xCBAC, 0xB26E,
	0xCBAD, 0xBDD6,
	0xCBAE, 0xA4F4,
	0xCBAF, 0xBACE,
	0xCBB0, 0xB57C,
	0xCBB1, 0xA76D,
	0xCBB2, 0xC0FE,
	0xCBB3, 0xB6B6,
	0xCBB4, 0xB5CF,
	0xCBB5, 0xBBA1,
	0xCBB6, 0xBAD3,
	0xCBB7, 0xAED2,
	0xCBB8, 0xC37B,
	0xCBB9, 0xB4B5,
	0xCBBA, 0xBCB9,
	0xCBBB, 0xBC52,
	0xCBBC, 0xABE4,
	0xCBBD, 0xA870,
	0xCBBE, 0xA571,
	0xCBBF, 0xB5B7,
	0xCBC0, 0xA6BA,
	0xCBC1, 0xB876,
	0xCBC2, 0xA678,
	0xCBC3, 0xB6E0,
	0xCBC4, 0xA57C,
	0xCBC5, 0xA6F8,
	0xCBC6, 0xA6FC,
	0xCBC7, 0xB97D,
	0xCBC8, 0xA478,
	0xCBC9, 0xC350,
	0xCBCA, 0xC171,
	0xCBCB, 0xBCA3,
	0xCBCC, 0xB97C,
	0xCBCD, 0xB065,
	0xCBCE, 0xA7BA,
	0xCBCF, 0xB35E,
	0xCBD0, 0xBB77,
	0xCBD1, 0xB76A,
	0xCBD2, 0xBFB4,
	0xCBD3, 0xC25D,
	0xCBD4, 0xB9C2,
	0xCBD5, 0xC4AC,
	0xCBD6, 0xB670,
	0xCBD7, 0xAB55,
	0xCBD8, 0xAFC0,
	0xCBD9, 0xB374,
	0xCBDA, 0xB5AF,
	0xCBDB, 0xE0F4,
	0xCBDC, 0xB6EC,
	0xCBDD, 0xB7B9,
	0xCBDE, 0xB14A,
	0xCBDF, 0xB644,
	0xCBE0, 0xB5C2,
	0xCBE1, 0xBBC4,
	0xCBE2, 0xBB5B,
	0xCBE3, 0xBAE2,
	0xCBE4, 0xC1F6,
	0xCBE5, 0xB6A6,
	0xCBE6, 0xC048,
	0xCBE7, 0xB86B,
	0xCBE8, 0xC5E8,
	0xCBE9, 0xB848,
	0xCBEA, 0xB7B3,
	0xCBEB, 0xC14A,
	0xCBEC, 0xB945,
	0xCBED, 0xC047,
	0xCBEE, 0xAFA9,
	0xCBEF, 0xAE5D,
	0xCBF0, 0xB76C,
	0xCBF1, 0xB5AB,
	0xCBF2, 0xBB62,
	0xCBF3, 0xB1F4,
	0xCBF4, 0xADF6,
	0xCBF5, 0xC159,
	0xCBF6, 0xBABE,
	0xCBF7, 0xAFC1,
	0xCBF8, 0xC2EA,
	0xCBF9, 0xA9D2,
	0xCBFA, 0xB6F2,
	0xCBFB, 0xA54C,
	0xCBFC, 0xA5A6,
	0xCBFD, 0xA66F,
	0xCBFE, 0xB6F0,
	0xCCA1, 0xC3A1,
	0xCCA2, 0xBED8,
	0xCCA3, 0xC1CF,
	0xCCA4, 0xBDF1,
	0xCCA5, 0xAD4C,
	0xCCA6, 0xAD61,
	0xCCA7, 0xA9EF,
	0xCCA8, 0xA578,
	0xCCA9, 0xAEF5,
	0xCCAB, 0xA4D3,
	0xCCAC, 0xBA41,
	0xCCAD, 0xA84F,
	0xCCAE, 0xA77E,
	0xCCAF, 0xC575,
	0xCCB0, 0xB367,
	0xCCB1, 0xC5F5,
	0xCCB2, 0xC579,
	0xCCB3, 0xBEC2,
	0xCCB4, 0xC0C8,
	0xCCB5, 0xB7F0,
	0xCCB6, 0xBCE6,
	0xCCB7, 0xC3D3,
	0xCCB8, 0xBDCD,
	0xCCB9, 0xA95A,
	0xCCBA, 0xB4E0,
	0xCCBB, 0xB352,
	0xCCBC, 0xBAD2,
	0xCCBD, 0xB1B4,
	0xCCBE, 0xB9C4,
	0xCCBF, 0xACB4,
	0xCCC0, 0xB4F6,
	0xCCC1, 0xB6ED,
	0xCCC2, 0xB765,
	0xCCC3, 0xB0F3,
	0xCCC4, 0xB4C5,
	0xCCC5, 0xBDA3,
	0xCCC6, 0xADF0,
	0xCCC7, 0xBF7D,
	0xCCC8, 0xADD5,
	0xCCC9, 0xBDF6,
	0xCCCA, 0xB249,
	0xCCCB, 0xBDEB,
	0xCCCC, 0xBF53,
	0xCCCD, 0xB1C7,
	0xCCCE, 0xC0DC,
	0xCCCF, 0xB7CA,
	0xCCD0, 0xB86C,
	0xCCD1, 0xB5E5,
	0xCCD2, 0xAEE7,
	0xCCD3, 0xB06B,
	0xCCD4, 0xB25E,
	0xCCD5, 0xB3B3,
	0xCCD6, 0xB051,
	0xCCD7, 0xAE4D,
	0xCCD8, 0xAF53,
	0xCCD9, 0xC4F0,
	0xCCDA, 0xC4CB,
	0xCCDB, 0xAF6B,
	0xCCDC, 0xC1C3,
	0xCCDD, 0xB1E8,
	0xCCDE, 0xADE7,
	0xCCDF, 0xBDF0,
	0xCCE0, 0xBE4F,
	0xCCE1, 0xB4A3,
	0xCCE2, 0xC344,
	0xCCE3, 0xBFE1,
	0xCCE4, 0xB3DA,
	0xCCE5, 0xC5E9,
	0xCCE6, 0xB4C0,
	0xCCE7, 0xC0A1,
	0xCCE8, 0xB1A7,
	0xCCE9, 0xAEF7,
	0xCCEA, 0xAB63,
	0xCCEB, 0xB150,
	0xCCEC, 0xA4D1,
	0xCCED, 0xB24B,
	0xCCEE, 0xB6F1,
	0xCCEF, 0xA5D0,
	0xCCF0, 0xB2A2,
	0xCCF1, 0xABEF,
	0xCCF2, 0xBB51,
	0xCCF3, 0xB5C9,
	0xCCF4, 0xAC44,
	0xCCF5, 0xB1F8,
	0xCCF6, 0xAD7C,
	0xCCF7, 0xB2B7,
	0xCCF8, 0xB8F5,
	0xCCF9, 0xB64B,
	0xCCFA, 0xC54B,
	0xCCFB, 0xA9AB,
	0xCCFC, 0xC655,
	0xCCFD, 0xC5A5,
	0xCCFE, 0xD64C,
	0xCDA1, 0xA5C5,
	0xCDA2, 0xA7CA,
	0xCDA3, 0xB0B1,
	0xCDA4, 0xAB46,
	0xCDA5, 0xAE78,
	0xCDA6, 0xAEBC,
	0xCDA7, 0xB8A5,
	0xCDA8, 0xB371,
	0xCDA9, 0xAEE4,
	0xCDAA, 0xE0AC,
	0xCDAB, 0xC0FB,
	0xCDAC, 0xA650,
	0xCDAD, 0xBBC9,
	0xCDAE, 0xA7CD,
	0xCDAF, 0xB5A3,
	0xCDB0, 0xB1ED,
	0xCDB1, 0xD1B6,
	0xCDB2, 0xB5A9,
	0xCDB3, 0xB2CE,
	0xCDB4, 0xB568,
	0xCDB5, 0xB0BD,
	0xCDB6, 0xA7EB,
	0xCDB7, 0xC059,
	0xCDB8, 0xB37A,
	0xCDB9, 0xA559,
	0xCDBA, 0xA872,
	0xCDBB, 0xACF0,
	0xCDBC, 0xB9CF,
	0xCDBD, 0xAE7B,
	0xCDBE, 0xB37E,
	0xCDBF, 0xB6EE,
	0xCDC0, 0xB14F,
	0xCDC1, 0xA467,
	0xCDC2, 0xA652,
	0xCDC3, 0xA8DF,
	0xCDC4, 0xB4F8,
	0xCDC5, 0xB9CE,
	0xCDC6, 0xB1C0,
	0xCDC7, 0xC05A,
	0xCDC8, 0xBB4C,
	0xCDC9, 0xB8C0,
	0xCDCA, 0xBFC6,
	0xCDCB, 0xB068,
	0xCDCC, 0xA75D,
	0xCDCD, 0xA4D9,
	0xCDCE, 0xC176,
	0xCDCF, 0xA9EC,
	0xCDD0, 0xA6AB,
	0xCDD1, 0xB2E6,
	0xCDD2, 0xC06B,
	0xCDD3, 0xAAFB,
	0xCDD4, 0xB9A4,
	0xCDD5, 0xBE6D,
	0xCDD6, 0xBEF2,
	0xCDD7, 0xA7B4,
	0xCDD8, 0xA9DD,
	0xCDD9, 0xB3E8,
	0xCDDA, 0xABF5,
	0xCDDB, 0xAB7A,
	0xCDDC, 0xB5EC,
	0xCDDD, 0xBADA,
	0xCDDE, 0xABBD,
	0xCDDF, 0xA5CB,
	0xCDE0, 0xC4FB,
	0xCDE1, 0xAC6E,
	0xCDE2, 0xA57E,
	0xCDE3, 0xBDDC,
	0xCDE4, 0xC573,
	0xCDE5, 0xC657,
	0xCDE6, 0xAAB1,
	0xCDE7, 0xB978,
	0xCDE8, 0xA459,
	0xCDE9, 0xD64A,
	0xCDEA, 0xA7B9,
	0xCDEB, 0xB84A,
	0xCDEC, 0xAEBE,
	0xCDED, 0xB1DF,
	0xCDEE, 0xB570,
	0xCDEF, 0xB17B,
	0xCDF0, 0xA97B,
	0xCDF1, 0xB0FB,
	0xCDF2, 0xB855,
	0xCDF3, 0xB5C3,
	0xCDF4, 0xA84C,
	0xCDF5, 0xA4FD,
	0xCDF6, 0xA460,
	0xCDF7, 0xAA50,
	0xCDF8, 0xBAF4,
	0xCDF9, 0xA9B9,
	0xCDFA, 0xA9F4,
	0xCDFB, 0xB1E6,
	0xCDFC, 0xA7D1,
	0xCDFD, 0xA66B,
	0xCDFE, 0xABC2,
	0xCEA1, 0xC4DE,
	0xCEA2, 0xB74C,
	0xCEA3, 0xA64D,
	0xCEA4, 0xADB3,
	0xCEA5, 0xB948,
	0xCEA6, 0xAEE9,
	0xCEA7, 0xB3F2,
	0xCEA8, 0xB0DF,
	0xCEA9, 0xB1A9,
	0xCEAA, 0xACB0,
	0xCEAB, 0xC0E5,
	0xCEAC, 0xBAFB,
	0xCEAD, 0xB8AB,
	0xCEAE, 0xB5E4,
	0xCEAF, 0xA965,
	0xCEB0, 0xB0B6,
	0xCEB1, 0xB0B0,
	0xCEB2, 0xA7C0,
	0xCEB3, 0xBD6E,
	0xCEB4, 0xA5BC,
	0xCEB5, 0xBDAB,
	0xCEB6, 0xA8FD,
	0xCEB7, 0xACC8,
	0xCEB8, 0xAD47,
	0xCEB9, 0xB3DE,
	0xCEBA, 0xC351,
	0xCEBB, 0xA6EC,
	0xCEBC, 0xB4F4,
	0xCEBD, 0xBFD7,
	0xCEBE, 0xB14C,
	0xCEBF, 0xBCA2,
	0xCEC0, 0xBDC3,
	0xCEC1, 0xBD45,
	0xCEC2, 0xB7C5,
	0xCEC3, 0xB041,
	0xCEC4, 0xA4E5,
	0xCEC5, 0xBB44,
	0xCEC6, 0xAFBE,
	0xCEC7, 0xA76B,
	0xCEC8, 0xC3AD,
	0xCEC9, 0xAFBF,
	0xCECA, 0xB0DD,
	0xCECB, 0xB6E4,
	0xCECC, 0xAFCE,
	0xCECD, 0xC27C,
	0xCECE, 0xBEE2,
	0xCECF, 0xBDBD,
	0xCED0, 0xB4F5,
	0xCED1, 0xBADB,
	0xCED2, 0xA7DA,
	0xCED3, 0xBA57,
	0xCED4, 0xAAD7,
	0xCED5, 0xB4A4,
	0xCED6, 0xA855,
	0xCED7, 0xA7C5,
	0xCED8, 0xB6E3,
	0xCED9, 0xC2EB,
	0xCEDA, 0xAF51,
	0xCEDB, 0xA6C3,
	0xCEDC, 0xBB7A,
	0xCEDD, 0xABCE,
	0xCEDE, 0xB54C,
	0xCEDF, 0xBFBE,
	0xCEE0, 0xB1EF,
	0xCEE1, 0xA75E,
	0xCEE2, 0xA764,
	0xCEE3, 0xA4F0,
	0xCEE4, 0xAA5A,
	0xCEE5, 0xA4AD,
	0xCEE6, 0xAEB8,
	0xCEE7, 0xA4C8,
	0xCEE8, 0xBB52,
	0xCEE9, 0xA5EE,
	0xCEEA, 0xAB56,
	0xCEEB, 0xB6F5,
	0xCEEC, 0xA5B3,
	0xCEED, 0xC3FA,
	0xCEEE, 0xB1E0,
	0xCEEF, 0xAAAB,
	0xCEF0, 0xA4C5,
	0xCEF1, 0xB0C8,
	0xCEF2, 0xAEA9,
	0xCEF3, 0xBB7E,
	0xCEF4, 0xA9F5,
	0xCEF5, 0xBAB3,
	0xCEF6, 0xAA52,
	0xCEF7, 0xA6E8,
	0xCEF8, 0xD6B4,
	0xCEF9, 0xAABF,
	0xCEFA, 0xB4B7,
	0xCEFB, 0xBC48,
	0xCEFC, 0xA76C,
	0xCEFD, 0xBFFC,
	0xCEFE, 0xC4EB,
	0xCFA1, 0xB57D,
	0xCFA2, 0xAEA7,
	0xCFA3, 0xA7C6,
	0xCFA4, 0xB178,
	0xCFA5, 0xBDA5,
	0xCFA6, 0xA469,
	0xCFA7, 0xB1A4,
	0xCFA8, 0xBAB6,
	0xCFA9, 0xB26D,
	0xCFAA, 0xB7CB,
	0xCFAB, 0xA6C1,
	0xCFAC, 0xB552,
	0xCFAD, 0xC0CA,
	0xCFAE, 0xC5A7,
	0xCFAF, 0xAE75,
	0xCFB0, 0xB2DF,
	0xCFB1, 0xB740,
	0xCFB2, 0xB3DF,
	0xCFB3, 0xBBD1,
	0xCFB4, 0xAC7E,
	0xCFB5, 0xA874,
	0xCFB6, 0xBBD8,
	0xCFB7, 0xC0B8,
	0xCFB8, 0xB2D3,
	0xCFB9, 0xBD4D,
	0xCFBA, 0xBDBC,
	0xCFBB, 0xA758,
	0xCFBC, 0xC1F8,
	0xCFBD, 0xC1D2,
	0xCFBE, 0xB776,
	0xCFBF, 0xAE6C,
	0xCFC0, 0xAB4C,
	0xCFC1, 0xAF55,
	0xCFC2, 0xA455,
	0xCFC3, 0xB748,
	0xCFC4, 0xAE4C,
	0xCFC5, 0xC07E,
	0xCFC6, 0xB1C8,
	0xCFC8, 0xA5FD,
	0xCFC9, 0xA550,
	0xCFCA, 0xC241,
	0xCFCB, 0xC5D6,
	0xCFCC, 0xAB77,
	0xCFCD, 0xBDE5,
	0xCFCE, 0xBBCE,
	0xCFCF, 0xB2EC,
	0xCFD0, 0xB67E,
	0xCFD1, 0xB243,
	0xCFD2, 0xA9B6,
	0xCFD3, 0xB6FB,
	0xCFD4, 0xC5E3,
	0xCFD5, 0xC049,
	0xCFD6, 0xB27B,
	0xCFD7, 0xC46D,
	0xCFD8, 0xBFA4,
	0xCFD9, 0xB8A2,
	0xCFDA, 0xC060,
	0xCFDB, 0xB872,
	0xCFDC, 0xBECB,
	0xCFDD, 0xB3B4,
	0xCFDE, 0xADAD,
	0xCFDF, 0xBD75,
	0xCFE0, 0xACDB,
	0xCFE1, 0xB45B,
	0xCFE2, 0xC65E,
	0xCFE3, 0xADBB,
	0xCFE4, 0xBD63,
	0xCFE5, 0xC1B8,
	0xCFE6, 0xB4F0,
	0xCFE7, 0xB66D,
	0xCFE8, 0xB5BE,
	0xCFE9, 0xB2BB,
	0xCFEA, 0xB8D4,
	0xCFEB, 0xB751,
	0xCFEC, 0xC554,
	0xCFED, 0xA8C9,
	0xCFEE, 0xB6B5,
	0xCFEF, 0xABD1,
	0xCFF0, 0xBEF3,
	0xCFF1, 0xB9B3,
	0xCFF2, 0xA656,
	0xCFF3, 0xB648,
	0xCFF4, 0xBFBD,
	0xCFF5, 0xB576,
	0xCFF6, 0xBE5D,
	0xCFF7, 0xAB64,
	0xCFF8, 0xADFD,
	0xCFF9, 0xC4DB,
	0xCFFA, 0xBE50,
	0xCFFB, 0xAEF8,
	0xCFFC, 0xAE64,
	0xCFFD, 0xB263,
	0xCFFE, 0xBEE5,
	0xD0A1, 0xA470,
	0xD0A2, 0xA7B5,
	0xD0A3, 0xAED5,
	0xD0A4, 0xA876,
	0xD0A5, 0xBC53,
	0xD0A6, 0xAFBA,
	0xD0A7, 0xAEC4,
	0xD0A8, 0xB7A4,
	0xD0A9, 0xA8C7,
	0xD0AA, 0xB7B2,
	0xD0AB, 0xC3C8,
	0xD0AC, 0xBE63,
	0xD0AD, 0xA8F3,
	0xD0AE, 0xAEB5,
	0xD0AF, 0xC4E2,
	0xD0B0, 0xA8B8,
	0xD0B1, 0xB1D7,
	0xD0B2, 0xAFD9,
	0xD0B3, 0xBFD3,
	0xD0B4, 0xBC67,
	0xD0B5, 0xB1F1,
	0xD0B6, 0xA8F8,
	0xD0B7, 0xC3C9,
	0xD0B8, 0xBED3,
	0xD0B9, 0xAA6E,
	0xD0BA, 0xC26D,
	0xD0BB, 0xC1C2,
	0xD0BC, 0xAE68,
	0xD0BD, 0xC17E,
	0xD0BE, 0xAAE4,
	0xD0BF, 0xBE4E,
	0xD0C0, 0xAA59,
	0xD0C1, 0xA8AF,
	0xD0C2, 0xB773,
	0xD0C3, 0xCAE3,
	0xD0C4, 0xA4DF,
	0xD0C5, 0xAB48,
	0xD0C6, 0xF4B5,
	0xD0C7, 0xAC50,
	0xD0C8, 0xB87B,
	0xD0C9, 0xB556,
	0xD0CA, 0xB469,
	0xD0CB, 0xBFB3,
	0xD0CC, 0xA644,
	0xD0CD, 0xABAC,
	0xD0CE, 0xA7CE,
	0xD0CF, 0xA8B7,
	0xD0D0, 0xA6E6,
	0xD0D1, 0xBFF4,
	0xD0D2, 0xA9AF,
	0xD0D3, 0xA7F6,
	0xD0D4, 0xA9CA,
	0xD0D5, 0xA96D,
	0xD0D6, 0xA553,
	0xD0D7, 0xA5FB,
	0xD0D8, 0xAFDD,
	0xD0D9, 0xA649,
	0xD0DA, 0xACA4,
	0xD0DB, 0xB6AF,
	0xD0DC, 0xBAB5,
	0xD0DD, 0xA5F0,
	0xD0DE, 0xADD7,
	0xD0DF, 0xB2DB,
	0xD0E0, 0xA6B4,
	0xD0E1, 0xB6E5,
	0xD0E2, 0xC4C3,
	0xD0E3, 0xA871,
	0xD0E4, 0xB353,
	0xD0E5, 0xC2B8,
	0xD0E6, 0xBC56,
	0xD0E7, 0xA6A6,
	0xD0E8, 0xBBDD,
	0xD0E9, 0xB5EA,
	0xD0EA, 0xBC4E,
	0xD0EB, 0xB6B7,
	0xD0EC, 0xAE7D,
	0xD0ED, 0xB35C,
	0xD0EE, 0xBB57,
	0xD0EF, 0xB3A4,
	0xD0F0, 0xB1D4,
	0xD0F1, 0xA6B0,
	0xD0F2, 0xA7C7,
	0xD0F3, 0xAF62,
	0xD0F4, 0xABF2,
	0xD0F5, 0xB5B6,
	0xD0F6, 0xB442,
	0xD0F7, 0xBAFC,
	0xD0F8, 0xC4F2,
	0xD0F9, 0xB061,
	0xD0FA, 0xB3D9,
	0xD0FB, 0xABC5,
	0xD0FC, 0xC461,
	0xD0FD, 0xB1DB,
	0xD0FE, 0xA5C8,
	0xD1A1, 0xBFEF,
	0xD1A2, 0xC57E,
	0xD1A3, 0xAF74,
	0xD1A4, 0xB5BA,
	0xD1A5, 0xB975,
	0xD1A6, 0xC1A7,
	0xD1A7, 0xBEC7,
	0xD1A8, 0xA5DE,
	0xD1A9, 0xB3B7,
	0xD1AA, 0xA6E5,
	0xD1AB, 0xB3D4,
	0xD1AC, 0xE2C0,
	0xD1AD, 0xB460,
	0xD1AE, 0xA6AF,
	0xD1AF, 0xB8DF,
	0xD1B0, 0xB44D,
	0xD1B1, 0xB9A5,
	0xD1B2, 0xA8B5,
	0xD1B3, 0xAEEE,
	0xD1B4, 0xA6C4,
	0xD1B5, 0xB056,
	0xD1B6, 0xB054,
	0xD1B7, 0xBBB9,
	0xD1B8, 0xA8B3,
	0xD1B9, 0xC0A3,
	0xD1BA, 0xA9E3,
	0xD1BB, 0xBE7E,
	0xD1BC, 0xC06E,
	0xD1BD, 0xA772,
	0xD1BE, 0xA458,
	0xD1BF, 0xAADE,
	0xD1C0, 0xA4FA,
	0xD1C1, 0xB048,
	0xD1C2, 0xB156,
	0xD1C3, 0xB8C5,
	0xD1C4, 0xB250,
	0xD1C5, 0xB6AE,
	0xD1C6, 0xB0D7,
	0xD1C7, 0xA8C8,
	0xD1C8, 0xB359,
	0xD1C9, 0xB26A,
	0xD1CA, 0xC360,
	0xD1CB, 0xEC49,
	0xD1CC, 0xB7CF,
	0xD1CD, 0xB254,
	0xD1CE, 0xC651,
	0xD1CF, 0xC459,
	0xD1D0, 0xACE3,
	0xD1D1, 0xE3E9,
	0xD1D2, 0xC5C9,
	0xD1D3, 0xA9B5,
	0xD1D4, 0xA8A5,
	0xD1D5, 0xC343,
	0xD1D6, 0xC046,
	0xD1D7, 0xAAA2,
	0xD1D8, 0xAA75,
	0xD1D9, 0xA961,
	0xD1DA, 0xB1BB,
	0xD1DB, 0xB2B4,
	0xD1DC, 0xAD6C,
	0xD1DD, 0xBA74,
	0xD1DE, 0xC641,
	0xD1DF, 0xB3F7,
	0xD1E0, 0xBF50,
	0xD1E1, 0xB9BD,
	0xD1E2, 0xB578,
	0xD1E3, 0xB6AD,
	0xD1E4, 0xADF1,
	0xD1E5, 0xABDB,
	0xD1E6, 0xBF56,
	0xD1E7, 0xAE62,
	0xD1E8, 0xBFCE,
	0xD1E9, 0xC5E7,
	0xD1EA, 0xAC6F,
	0xD1EB, 0xA5A1,
	0xD1EC, 0xC06D,
	0xD1ED, 0xAFB1,
	0xD1EE, 0xB7A8,
	0xD1EF, 0xB4AD,
	0xD1F0, 0xA8CB,
	0xD1F1, 0xBAC5,
	0xD1F2, 0xA6CF,
	0xD1F3, 0xAC76,
	0xD1F4, 0xB6A7,
	0xD1F5, 0xAEF1,
	0xD1F6, 0xA5F5,
	0xD1F7, 0xD67D,
	0xD1F8, 0xBE69,
	0xD1F9, 0xBCCB,
	0xD1FA, 0xBA79,
	0xD1FB, 0xC1DC,
	0xD1FC, 0xB879,
	0xD1FD, 0xA7AF,
	0xD1FE, 0xBABD,
	0xD2A1, 0xB76E,
	0xD2A2, 0xB3F3,
	0xD2A3, 0xBBBB,
	0xD2A4, 0xBD60,
	0xD2A5, 0xC1C1,
	0xD2A6, 0xABC0,
	0xD2A7, 0xAB72,
	0xD2A8, 0xAFE6,
	0xD2A9, 0xC3C4,
	0xD2AA, 0xAD6E,
	0xD2AB, 0xC4A3,
	0xD2AC, 0xB7A6,
	0xD2AD, 0xBC4F,
	0xD2AE, 0xAD43,
	0xD2AF, 0xB7DD,
	0xD2B0, 0xB3A5,
	0xD2B1, 0xA74D,
	0xD2B2, 0xA45D,
	0xD2B3, 0xADB6,
	0xD2B4, 0xB1B3,
	0xD2B5, 0xB77E,
	0xD2B6, 0xB8AD,
	0xD2B7, 0xA6B2,
	0xD2B8, 0xB5C5,
	0xD2B9, 0xA95D,
	0xD2BA, 0xB247,
	0xD2BB, 0xA440,
	0xD2BC, 0xB3FC,
	0xD2BD, 0xC2E5,
	0xD2BE, 0xB4A5,
	0xD2BF, 0xE476,
	0xD2C0, 0xA8CC,
	0xD2C1, 0xA5EC,
	0xD2C2, 0xA6E7,
	0xD2C3, 0xC05B,
	0xD2C4, 0xA669,
	0xD2C5, 0xBFF2,
	0xD2C6, 0xB2BE,
	0xD2C7, 0xBBF6,
	0xD2C8, 0xAFD8,
	0xD2C9, 0xBAC3,
	0xD2CA, 0xA85E,
	0xD2CB, 0xA979,
	0xD2CC, 0xABBC,
	0xD2CD, 0xC255,
	0xD2CE, 0xB4C8,
	0xD2CF, 0xC3C6,
	0xD2D0, 0xADCA,
	0xD2D1, 0xA477,
	0xD2D2, 0xA441,
	0xD2D3, 0xA86F,
	0xD2D4, 0xA548,
	0xD2D5, 0xC3C0,
	0xD2D6, 0xA7ED,
	0xD2D7, 0xA9F6,
	0xD2D8, 0xA8B6,
	0xD2D9, 0xA67A,
	0xD2DA, 0xBBF5,
	0xD2DB, 0xA7D0,
	0xD2DC, 0xC172,
	0xD2DD, 0xB668,
	0xD2DE, 0xB877,
	0xD2DF, 0xACCC,
	0xD2E0, 0xA5E7,
	0xD2E1, 0xB8C7,
	0xD2E2, 0xB74E,
	0xD2E3, 0xBCDD,
	0xD2E4, 0xBED0,
	0xD2E5, 0xB871,
	0xD2E6, 0xAF71,
	0xD2E7, 0xB7B8,
	0xD2E8, 0xB8DA,
	0xD2E9, 0xC4B3,
	0xD2EA, 0xBDCB,
	0xD2EB, 0xC4B6,
	0xD2EC, 0xB2A7,
	0xD2ED, 0xC16C,
	0xD2EE, 0xB2DD,
	0xD2EF, 0xC3B6,
	0xD2F0, 0xAFF4,
	0xD2F1, 0xBDAE,
	0xD2F2, 0xA65D,
	0xD2F3, 0xAEEF,
	0xD2F4, 0xADB5,
	0xD2F5, 0xB3B1,
	0xD2F6, 0xABC3,
	0xD2F7, 0xA775,
	0xD2F8, 0xBBC8,
	0xD2F9, 0xB25D,
	0xD2FA, 0xB147,
	0xD2FB, 0xB6BC,
	0xD2FC, 0xA4A8,
	0xD2FD, 0xA4DE,
	0xD2FE, 0xC1F4,
	0xD3A1, 0xA64C,
	0xD3A2, 0xAD5E,
	0xD3A3, 0xC4E5,
	0xD3A4, 0xC0A6,
	0xD3A5, 0xC64E,
	0xD3A6, 0xC0B3,
	0xD3A7, 0xC5D5,
	0xD3A8, 0xBCFC,
	0xD3A9, 0xBFC3,
	0xD3AA, 0xC0E7,
	0xD3AB, 0xBAB7,
	0xD3AC, 0xC3C7,
	0xD3AD, 0xAAEF,
	0xD3AE, 0xC4B9,
	0xD3AF, 0xACD5,
	0xD3B0, 0xBC76,
	0xD3B1, 0xBF6F,
	0xD3B2, 0xB577,
	0xD3B3, 0xAC4D,
	0xD3B4, 0xB3E9,
	0xD3B5, 0xBED6,
	0xD3B6, 0xB6C4,
	0xD3B7, 0xC173,
	0xD3B8, 0xF7EA,
	0xD3B9, 0xB165,
	0xD3BA, 0xB96C,
	0xD3BB, 0xBFE3,
	0xD3BC, 0xB8BA,
	0xD3BD, 0xB5FA,
	0xD3BE, 0xAA61,
	0xD3BF, 0xB4E9,
	0xD3C0, 0xA5C3,
	0xD3C1, 0xB176,
	0xD3C2, 0xAB69,
	0xD3C3, 0xA5CE,
	0xD3C4, 0xABD5,
	0xD3C5, 0xC075,
	0xD3C6, 0xB179,
	0xD3C7, 0xBC7E,
	0xD3C8, 0xA4D7,
	0xD3C9, 0xA5D1,
	0xD3CA, 0xB66C,
	0xD3CB, 0xB95C,
	0xD3CC, 0xB553,
	0xD3CD, 0xAA6F,
	0xD3CE, 0xB943,
	0xD3CF, 0xA8BB,
	0xD3D0, 0xA6B3,
	0xD3D1, 0xA4CD,
	0xD3D2, 0xA56B,
	0xD3D3, 0xA6F6,
	0xD3D4, 0xB956,
	0xD3D5, 0xBBA4,
	0xD3D6, 0xA453,
	0xD3D7, 0xA5AE,
	0xD3D8, 0xA8B1,
	0xD3D9, 0xB24A,
	0xD3DA, 0xA9F3,
	0xD3DB, 0xAABB,
	0xD3DC, 0xB7AE,
	0xD3DD, 0xB8B7,
	0xD3DE, 0xB74D,
	0xD3DF, 0xC1D6,
	0xD3E0, 0xA745,
	0xD3E1, 0xAB5C,
	0xD3E2, 0xB94F,
	0xD3E3, 0xB3BD,
	0xD3E4, 0xB472,
	0xD3E5, 0xB4FC,
	0xD3E6, 0xBAAE,
	0xD3E7, 0xB6A8,
	0xD3E8, 0xA4A9,
	0xD3E9, 0xAE54,
	0xD3EA, 0xAB42,
	0xD3EB, 0xBB50,
	0xD3EC, 0xC0AC,
	0xD3ED, 0xACEA,
	0xD3EE, 0xA674,
	0xD3EF, 0xBB79,
	0xD3F0, 0xA6D0,
	0xD3F1, 0xA5C9,
	0xD3F2, 0xB0EC,
	0xD3F3, 0xA8A1,
	0xD3F4, 0xC67B,
	0xD3F5, 0xA653,
	0xD3F6, 0xB94A,
	0xD3F7, 0xB3EB,
	0xD3F8, 0xAE6E,
	0xD3F9, 0xB173,
	0xD3FA, 0xC2A1,
	0xD3FB, 0xB1FD,
	0xD3FC, 0xBABB,
	0xD3FD, 0xA87C,
	0xD3FE, 0xC541,
	0xD4A1, 0xAF44,
	0xD4A2, 0xB44A,
	0xD4A3, 0xB8CE,
	0xD4A4, 0xB977,
	0xD4A5, 0xBFDD,
	0xD4A6, 0xB6BF,
	0xD4A7, 0xC070,
	0xD4A8, 0xB257,
	0xD4A9, 0xADDE,
	0xD4AA, 0xA4B8,
	0xD4AB, 0xABAE,
	0xD4AC, 0xB04B,
	0xD4AD, 0xADEC,
	0xD4AE, 0xB4A9,
	0xD4AF, 0xC1D5,
	0xD4B0, 0xB6E9,
	0xD4B1, 0xADFB,
	0xD4B2, 0xB6EA,
	0xD4B3, 0xB7E1,
	0xD4B4, 0xB7BD,
	0xD4B5, 0xBD74,
	0xD4B6, 0xBBB7,
	0xD4B7, 0xAD62,
	0xD4B8, 0xC440,
	0xD4B9, 0xABE8,
	0xD4BA, 0xB07C,
	0xD4BB, 0xA4EA,
	0xD4BC, 0xACF9,
	0xD4BD, 0xB656,
	0xD4BE, 0xC544,
	0xD4BF, 0xC65F,
	0xD4C0, 0xA9A8,
	0xD4C1, 0xB866,
	0xD4C2, 0xA4EB,
	0xD4C3, 0xAEAE,
	0xD4C4, 0xBE5C,
	0xD4C5, 0xAFD0,
	0xD4C6, 0xB6B3,
	0xD4C7, 0xE0A8,
	0xD4C8, 0xA4C3,
	0xD4C9, 0xB96B,
	0xD4CA, 0xA4B9,
	0xD4CB, 0xB942,
	0xD4CC, 0xC4AD,
	0xD4CD, 0xC1DF,
	0xD4CE, 0xB777,
	0xD4CF, 0xC3FD,
	0xD4D0, 0xA5A5,
	0xD4D1, 0xA560,
	0xD4D2, 0xAF7B,
	0xD4D3, 0xC2F8,
	0xD4D4, 0xAEE2,
	0xD4D5, 0xAB76,
	0xD4D6, 0xA861,
	0xD4D7, 0xAE5F,
	0xD4D8, 0xB8FC,
	0xD4D9, 0xA641,
	0xD4DA, 0xA662,
	0xD4DB, 0xABA5,
	0xD4DC, 0xF6E3,
	0xD4DD, 0xBCC8,
	0xD4DE, 0xC667,
	0xD4DF, 0xC542,
	0xD4E0, 0xC5A6,
	0xD4E1, 0xB8AE,
	0xD4E2, 0xBE44,
	0xD4E3, 0xC156,
	0xD4E4, 0xC677,
	0xD4E5, 0xC4A6,
	0xD4E6, 0xB4C7,
	0xD4E7, 0xA6AD,
	0xD4E8, 0xBEFE,
	0xD4E9, 0xB044,
	0xD4EA, 0xC4BC,
	0xD4EB, 0xBEB8,
	0xD4EC, 0xB379,
	0xD4ED, 0xA86D,
	0xD4EE, 0xA85F,
	0xD4EF, 0xC0EA,
	0xD4F0, 0xB364,
	0xD4F1, 0xBEDC,
	0xD4F2, 0xAB68,
	0xD4F3, 0xBF41,
	0xD4F4, 0xB8E9,
	0xD4F5, 0xABE7,
	0xD4F6, 0xBC57,
	0xD4F7, 0xBCA8,
	0xD4F8, 0xB4BF,
	0xD4F9, 0xC3D8,
	0xD4FA, 0xB2CF,
	0xD4FB, 0xB3E5,
	0xD4FC, 0xB4ED,
	0xD4FD, 0xA5BE,
	0xD4FE, 0xAAEE,
	0xD5A1, 0xEED4,
	0xD5A2, 0xB968,
	0xD5A3, 0xAF77,
	0xD5A4, 0xAC5D,
	0xD5A5, 0xBA5E,
	0xD5A6, 0xA951,
	0xD5A7, 0xA545,
	0xD5A8, 0xACB5,
	0xD5A9, 0xB642,
	0xD5AA, 0xBA4B,
	0xD5AB, 0xC24E,
	0xD5AC, 0xA676,
	0xD5AD, 0xAFB6,
	0xD5AE, 0xB6C5,
	0xD5AF, 0xB9EB,
	0xD5B0, 0xC2A4,
	0xD5B1, 0xC0D6,
	0xD5B2, 0xB8E2,
	0xD5B3, 0xD6DF,
	0xD5B4, 0xAA67,
	0xD5B5, 0xB7F8,
	0xD5B6, 0xB1D9,
	0xD5B7, 0xC1D3,
	0xD5B8, 0xB9F1,
	0xD5B9, 0xAE69,
	0xD5BA, 0xC5D9,
	0xD5BB, 0xB4CC,
	0xD5BC, 0xA6FB,
	0xD5BD, 0xBED4,
	0xD5BE, 0xAFB8,
	0xD5BF, 0xB4EF,
	0xD5C0, 0xBAEC,
	0xD5C1, 0xBCCC,
	0xD5C2, 0xB3B9,
	0xD5C3, 0xB9FC,
	0xD5C4, 0xBA73,
	0xD5C5, 0xB169,
	0xD5C6, 0xB478,
	0xD5C7, 0xBAA6,
	0xD5C8, 0xA7FA,
	0xD5C9, 0xA456,
	0xD5CA, 0xB162,
	0xD5CB, 0xBDE3,
	0xD5CC, 0xA54D,
	0xD5CD, 0xB5C8,
	0xD5CE, 0xBF60,
	0xD5CF, 0xBBD9,
	0xD5D0, 0xA9DB,
	0xD5D1, 0xAC4C,
	0xD5D2, 0xA7E4,
	0xD5D3, 0xAA68,
	0xD5D4, 0xBBAF,
	0xD5D5, 0xB7D3,
	0xD5D6, 0xB86E,
	0xD5D7, 0xA5FC,
	0xD5D8, 0xBB46,
	0xD5D9, 0xA56C,
	0xD5DA, 0xBE42,
	0xD5DB, 0xA7E9,
	0xD5DC, 0xADF5,
	0xD5DD, 0xEE68,
	0xD5DE, 0xC2E1,
	0xD5DF, 0xAACC,
	0xD5E0, 0xEBE3,
	0xD5E1, 0xBDA9,
	0xD5E2, 0xB36F,
	0xD5E3, 0xAEFD,
	0xD5E4, 0xACC3,
	0xD5E5, 0xB772,
	0xD5E6, 0xAF75,
	0xD5E7, 0xBAC2,
	0xD5E8, 0xAF7A,
	0xD5E9, 0xBFB2,
	0xD5EA, 0xAD73,
	0xD5EB, 0xB077,
	0xD5EC, 0xB0BB,
	0xD5ED, 0xAA45,
	0xD5EE, 0xAF6C,
	0xD5EF, 0xB645,
	0xD5F0, 0xBE5F,
	0xD5F1, 0xAEB6,
	0xD5F2, 0xC2ED,
	0xD5F3, 0xB07D,
	0xD5F4, 0xBB5D,
	0xD5F5, 0xB1C3,
	0xD5F6, 0xB843,
	0xD5F7, 0xA9BA,
	0xD5F8, 0xB275,
	0xD5F9, 0xAAA7,
	0xD5FA, 0xA9C3,
	0xD5FB, 0xBEE3,
	0xD5FC, 0xAC40,
	0xD5FD, 0xA5BF,
	0xD5FE, 0xAC46,
	0xD6A1, 0xB456,
	0xD6A2, 0xAF67,
	0xD6A3, 0xBE47,
	0xD6A4, 0xB5FD,
	0xD6A5, 0xAADB,
	0xD6A6, 0xAA4B,
	0xD6A7, 0xA4E4,
	0xD6A8, 0xA773,
	0xD6A9, 0xBB6A,
	0xD6AA, 0xAABE,
	0xD6AB, 0xAACF,
	0xD6AC, 0xAFD7,
	0xD6AD, 0xA5C4,
	0xD6AE, 0xA4A7,
	0xD6AF, 0xC2B4,
	0xD6B0, 0xC2BE,
	0xD6B1, 0xAABD,
	0xD6B2, 0xB4D3,
	0xD6B3, 0xB4DE,
	0xD6B4, 0xB0F5,
	0xD6B5, 0xADC8,
	0xD6B6, 0xCBBB,
	0xD6B7, 0xA77D,
	0xD6B8, 0xABFC,
	0xD6B9, 0xA4EE,
	0xD6BA, 0xB36B,
	0xD6BB, 0xA575,
	0xD6BC, 0xA6AE,
	0xD6BD, 0xAFC8,
	0xD6BE, 0xA7D3,
	0xD6BF, 0xBCB0,
	0xD6C0, 0xC259,
	0xD6C1, 0xA6DC,
	0xD6C2, 0xAD50,
	0xD6C3, 0xB86D,
	0xD6C4, 0xBC6D,
	0xD6C5, 0xABCF,
	0xD6C6, 0xA8EE,
	0xD6C7, 0xB4BC,
	0xD6C8, 0xAFB4,
	0xD6C9, 0xB858,
	0xD6CA, 0xBDE8,
	0xD6CB, 0xAAA5,
	0xD6CC, 0xB2A9,
	0xD6CD, 0xBAA2,
	0xD6CE, 0xAA76,
	0xD6CF, 0xB2BF,
	0xD6D0, 0xA4A4,
	0xD6D1, 0xACD8,
	0xD6D2, 0xA9BE,
	0xD6D3, 0xC4C1,
	0xD6D4, 0xB04A,
	0xD6D5, 0xB2D7,
	0xD6D6, 0xBAD8,
	0xD6D7, 0xB87E,
	0xD6D8, 0xADAB,
	0xD6D9, 0xA5F2,
	0xD6DA, 0xB2B3,
	0xD6DB, 0xA6E0,
	0xD6DC, 0xA950,
	0xD6DD, 0xA67B,
	0xD6DE, 0xAC77,
	0xD6DF, 0xEEA4,
	0xD6E0, 0xB5B0,
	0xD6E1, 0xB662,
	0xD6E2, 0xA879,
	0xD6E3, 0xA9AA,
	0xD6E4, 0xA947,
	0xD6E5, 0xBD4B,
	0xD6E6, 0xA97A,
	0xD6E7, 0xB1DE,
	0xD6E8, 0xC64A,
	0xD6E9, 0xAF5D,
	0xD6EA, 0xAEE8,
	0xD6EB, 0xB5EF,
	0xD6EC, 0xA6B6,
	0xD6ED, 0xBDDE,
	0xD6EE, 0xBDD1,
	0xD6EF, 0xB8DD,
	0xD6F0, 0xB376,
	0xD6F1, 0xA6CB,
	0xD6F2, 0xC0EB,
	0xD6F3, 0xB54E,
	0xD6F4, 0xA9D6,
	0xD6F5, 0xC666,
	0xD6F6, 0xC5F1,
	0xD6F7, 0xA544,
	0xD6F8, 0xB5DB,
	0xD6F9, 0xAC57,
	0xD6FA, 0xA755,
	0xD6FB, 0xB345,
	0xD6FC, 0xB64A,
	0xD6FD, 0xC5B1,
	0xD6FE, 0xBF76,
	0xD7A1, 0xA6ED,
	0xD7A2, 0xAA60,
	0xD7A3, 0xAFAC,
	0xD7A4, 0xBE6E,
	0xD7A5, 0xA7EC,
	0xD7A6, 0xA4F6,
	0xD7A7, 0xABFB,
	0xD7A8, 0xB14D,
	0xD7A9, 0xBF6A,
	0xD7AA, 0xC2E0,
	0xD7AB, 0xBCB6,
	0xD7AC, 0xC1C8,
	0xD7AD, 0xBD66,
	0xD7AE, 0xBCCE,
	0xD7AF, 0xB2F8,
	0xD7B0, 0xB8CB,
	0xD7B1, 0xA7A9,
	0xD7B2, 0xBCB2,
	0xD7B3, 0xA7A7,
	0xD7B4, 0xAAAC,
	0xD7B5, 0xB4D5,
	0xD7B6, 0xC040,
	0xD7B7, 0xB06C,
	0xD7B8, 0xC2D8,
	0xD7B9, 0xBC59,
	0xD7BA, 0xBAF3,
	0xD7BB, 0xBDCE,
	0xD7BC, 0xB7C7,
	0xD7BD, 0xAEBB,
	0xD7BE, 0xA9E5,
	0xD7BF, 0xA8F4,
	0xD7C0, 0xAEE0,
	0xD7C1, 0xB55A,
	0xD7C2, 0xAD5F,
	0xD7C3, 0xB075,
	0xD7C4, 0xB0D6,
	0xD7C5, 0xB5DB,
	0xD7C6, 0xA860,
	0xD7C7, 0xBF42,
	0xD7C8, 0xAFF7,
	0xD7C9, 0xAB74,
	0xD7CA, 0xB8EA,
	0xD7CB, 0xABBA,
	0xD7CC, 0xB4FE,
	0xD7CD, 0xB264,
	0xD7CE, 0xA7B6,
	0xD7CF, 0xB5B5,
	0xD7D0, 0xA54A,
	0xD7D1, 0xACF3,
	0xD7D2, 0xB7BA,
	0xD7D3, 0xA46C,
	0xD7D4, 0xA6DB,
	0xD7D5, 0xBA7B,
	0xD7D6, 0xA672,
	0xD7D7, 0xC34F,
	0xD7D8, 0xB4C4,
	0xD7D9, 0xC2DC,
	0xD7DA, 0xA976,
	0xD7DB, 0xBAEE,
	0xD7DC, 0xC160,
	0xD7DD, 0xC161,
	0xD7DE, 0xB951,
	0xD7DF, 0xA8AB,
	0xD7E0, 0xABB5,
	0xD7E1, 0xB47E,
	0xD7E2, 0xAFB2,
	0xD7E3, 0xA8AC,
	0xD7E4, 0xA8F2,
	0xD7E5, 0xB1DA,
	0xD7E6, 0xAFAA,
	0xD7E7, 0xB641,
	0xD7E8, 0xAAFD,
	0xD7E9, 0xB2D5,
	0xD7EA, 0xC670,
	0xD7EB, 0xC4A1,
	0xD7EC, 0xBC4C,
	0xD7ED, 0xBE4B,
	0xD7EE, 0xB3CC,
	0xD7EF, 0xB86F,
	0xD7F0, 0xB44C,
	0xD7F1, 0xBFED,
	0xD7F2, 0xAC51,
	0xD7F3, 0xA5AA,
	0xD7F4, 0xA6F5,
	0xD7F5, 0xAC67,
	0xD7F6, 0xB0B5,
	0xD7F7, 0xA740,
	0xD7F8, 0xA7A4,
	0xD7F9, 0xAE79,
	0xD8A1, 0xC948,
	0xD8A2, 0xC946,
	0xD8A3, 0xA461,
	0xD8A4, 0xA4A2,
	0xD8A5, 0xA4DC,
	0xD8A6, 0xA4CA,
	0xD8A7, 0xA541,
	0xD8A8, 0xA5E5,
	0xD8A9, 0xA5E0,
	0xD8AA, 0xB0AC,
	0xD8AB, 0xD165,
	0xD8AC, 0xBEB5,
	0xD8AE, 0xACEB,
	0xD8B0, 0xA450,
	0xD8B1, 0xC947,
	0xD8B2, 0xA4D4,
	0xD8B3, 0xA4F8,
	0xD8B4, 0xA567,
	0xD8B5, 0xA5C2,
	0xD8B6, 0xC9C7,
	0xD8B7, 0xAD4E,
	0xD8B8, 0xD850,
	0xD8B9, 0xB7B6,
	0xD8BA, 0xB841,
	0xD8BD, 0xAB45,
	0xD8BE, 0xE8F3,
	0xD8BF, 0xC941,
	0xD8C0, 0xA5E4,
	0xD8C1, 0xC951,
	0xD8C2, 0xAACB,
	0xD8C3, 0xA7B8,
	0xD8C4, 0xB6DE,
	0xD8C5, 0xE14C,
	0xD8C6, 0xA4B7,
	0xD8C7, 0xCDF8,
	0xD8C8, 0xADED,
	0xD8C9, 0xF1EF,
	0xD8CA, 0xB3D6,
	0xD8CB, 0xBC72,
	0xD8CC, 0xC5E2,
	0xD8CD, 0xC5AC,
	0xD8CE, 0xC943,
	0xD8CF, 0xA572,
	0xD8D0, 0xD46F,
	0xD8D1, 0xB9BC,
	0xD8D2, 0xB0D0,
	0xD8D3, 0xF0F3,
	0xD8D4, 0xA8F6,
	0xD8D5, 0xCA72,
	0xD8D7, 0xA4C2,
	0xD8D8, 0xA646,
	0xD8D9, 0xCDF0,
	0xD8DA, 0xCBD2,
	0xD8DB, 0xE4F3,
	0xD8DC, 0xB3CF,
	0xD8DD, 0xAB66,
	0xD8DE, 0xD0E9,
	0xD8DF, 0xD0E6,
	0xD8E0, 0xADE6,
	0xD8E1, 0xE3C7,
	0xD8E2, 0xB6D1,
	0xD8E3, 0xB9BB,
	0xD8E4, 0xE142,
	0xD8E6, 0xBEB0,
	0xD8E8, 0xAAC9,
	0xD8EA, 0xA4B1,
	0xD8EB, 0xC953,
	0xD8EC, 0xC952,
	0xD8ED, 0xC965,
	0xD8EE, 0xC968,
	0xD8F0, 0xA551,
	0xD8F1, 0xDCBA,
	0xD8F2, 0xA5F6,
	0xD8F3, 0xC9B7,
	0xD8F4, 0xCA5F,
	0xD8F5, 0xC9AE,
	0xD8F6, 0xADCE,
	0xD8F7, 0xB3C9,
	0xD8F8, 0xA5EA,
	0xD8F9, 0xA6EE,
	0xD8FA, 0xA6F0,
	0xD8FB, 0xCA61,
	0xD8FC, 0xA7F1,
	0xD8FD, 0xA748,
	0xD8FE, 0xA746,
	0xD9A1, 0xCA63,
	0xD9A2, 0xA6EF,
	0xD9A4, 0xA6F7,
	0xD9A5, 0xCBB8,
	0xD9A6, 0xCBB9,
	0xD9A7, 0xA8DD,
	0xD9A8, 0xCBBA,
	0xD9A9, 0xA8D4,
	0xD9AA, 0xA8DC,
	0xD9AB, 0xA8DB,
	0xD9AC, 0xA8D9,
	0xD9AD, 0xBEAB,
	0xD9AE, 0xCBB3,
	0xD9AF, 0xBBFA,
	0xD9B0, 0xCBC6,
	0xD9B1, 0xBEA9,
	0xD9B2, 0xC56B,
	0xD9B3, 0xC4D7,
	0xD9B4, 0xCDDE,
	0xD9B5, 0xAB5A,
	0xD9B6, 0xCDE3,
	0xD9B7, 0xCDE5,
	0xD9B8, 0xAB4D,
	0xD9B9, 0xAB53,
	0xD9BA, 0xADC4,
	0xD9BB, 0xADC5,
	0xD9BC, 0xB0B4,
	0xD9BD, 0xADD6,
	0xD9BE, 0xD0D3,
	0xD9BF, 0xB0BF,
	0xD9C1, 0xADD8,
	0xD9C2, 0xADDA,
	0xD9C3, 0xD0D7,
	0xD9C4, 0xADBE,
	0xD9C5, 0xADC3,
	0xD9C6, 0xADD0,
	0xD9C7, 0xE0F3,
	0xD9C8, 0xB0B3,
	0xD9C9, 0xB0BA,
	0xD9CA, 0xD455,
	0xD9CB, 0xB0B9,
	0xD9CC, 0xB6CD,
	0xD9CD, 0xDCBC,
	0xD9CE, 0xC56C,
	0xD9CF, 0xBEAA,
	0xD9D0, 0xF5C0,
	0xD9D1, 0xDCBF,
	0xD9D2, 0xB9AF,
	0xD9D3, 0xE4EA,
	0xD9D4, 0xB9B0,
	0xD9D5, 0xE0FA,
	0xD9D6, 0xE0F0,
	0xD9D7, 0xB9AD,
	0xD9D8, 0xE4EB,
	0xD9D9, 0xE4EE,
	0xD9DA, 0xC969,
	0xD9DB, 0xC9F8,
	0xD9DC, 0xCA65,
	0xD9DD, 0xDCC2,
	0xD9DE, 0xAB5B,
	0xD9DF, 0xEFB6,
	0xD9E0, 0xC9F8,
	0xD9E1, 0xF740,
	0xD9E2, 0xA4BC,
	0xD9E3, 0xB453,
	0xD9E4, 0xC664,
	0xD9E5, 0xEF55,
	0xD9E6, 0xF6D8,
	0xD9E7, 0xC4DC,
	0xD9E9, 0xAB6D,
	0xD9EA, 0xD0B1,
	0xD9EB, 0xB0CB,
	0xD9EC, 0xE0ED,
	0xD9ED, 0xA667,
	0xD9EE, 0xA8E1,
	0xD9F0, 0xAB5E,
	0xD9F1, 0xADBD,
	0xD9F2, 0xB34F,
	0xD9F3, 0xD7C0,
	0xD9F4, 0xC1B6,
	0xD9F5, 0xF943,
	0xD9F6, 0xB8CF,
	0xD9F7, 0xB85B,
	0xD9F8, 0xBEC6,
	0xD9F9, 0xF2DD,
	0xD9FA, 0xC3BD,
	0xD9FC, 0xC9BC,
	0xD9FD, 0xA8E6,
	0xD9FE, 0xCBCE,
	0xDAA3, 0xB6EF,
	0xDAA4, 0xADDF,
	0xDAA5, 0xF365,
	0xDAA6, 0xB050,
	0xDAA7, 0xB052,
	0xDAA8, 0xB053,
	0xDAA9, 0xF0DD,
	0xDAAA, 0xDBD6,
	0xDAAB, 0xB35B,
	0xDAAC, 0xB5FE,
	0xDAAD, 0xB646,
	0xDAAE, 0xB643,
	0xDAAF, 0xB640,
	0xDAB1, 0xDBDF,
	0xDAB2, 0xE046,
	0xDAB3, 0xE04C,
	0xDAB4, 0xE047,
	0xDAB5, 0xB8D7,
	0xDAB6, 0xB8D9,
	0xDAB7, 0xE04D,
	0xDAB8, 0xB8E1,
	0xDAB9, 0xB8E0,
	0xDABA, 0xBDD8,
	0xDABB, 0xEBA1,
	0xDABC, 0xE048,
	0xDABD, 0xBBA6,
	0xDABE, 0xBBA2,
	0xDABF, 0xBBA5,
	0xDAC0, 0xE44D,
	0xDAC1, 0xE7D4,
	0xDAC2, 0xE7D8,
	0xDAC3, 0xBDD3,
	0xDAC4, 0xBDDB,
	0xDAC5, 0xE7DC,
	0xDAC6, 0xBDD4,
	0xDAC7, 0xBDD9,
	0xDAC8, 0xBFDB,
	0xDAC9, 0xBFCF,
	0xDACA, 0xEBA6,
	0xDACB, 0xBFD6,
	0xDACC, 0xEBA7,
	0xDACD, 0xBFD9,
	0xDACE, 0xBFDC,
	0xDACF, 0xBFDA,
	0xDAD0, 0xBFCD,
	0xDAD1, 0xBFD4,
	0xDAD2, 0xEBAB,
	0xDAD3, 0xC2D3,
	0xDAD4, 0xC66D,
	0xDAD5, 0xEEA2,
	0xDAD6, 0xEEB0,
	0xDAD7, 0xC1C4,
	0xDAD8, 0xC2D6,
	0xDAD9, 0xF756,
	0xDADA, 0xF2FB,
	0xDADB, 0xC3D7,
	0xDADC, 0xC3D4,
	0xDADD, 0xF9A9,
	0xDADE, 0xC4B8,
	0xDADF, 0xC640,
	0xDAE1, 0xCEAF,
	0xDAE3, 0xCA56,
	0xDAE4, 0xA6E9,
	0xDAE5, 0xA8C0,
	0xDAE6, 0xA8C1,
	0xDAE7, 0xCDD9,
	0xDAE8, 0xCDDA,
	0xDAE9, 0xAB40,
	0xDAEA, 0xB0A4,
	0xDAEB, 0xD0C2,
	0xDAEC, 0xD446,
	0xDAED, 0xDCA1,
	0xDAEE, 0xB3B5,
	0xDAEF, 0xB6AB,
	0xDAF0, 0xB3B2,
	0xDAF1, 0xDC7E,
	0xDAF2, 0xB6AA,
	0xDAF3, 0xE0D4,
	0xDAF4, 0xEEF5,
	0xDAF5, 0xCA52,
	0xDAF6, 0xCA54,
	0xDAF7, 0xF14B,
	0xDAF8, 0xCA51,
	0xDAF9, 0xE0A9,
	0xDAFA, 0xCBA8,
	0xDAFB, 0xCDD4,
	0xDAFC, 0xCDD6,
	0xDAFD, 0xAAF5,
	0xDAFE, 0xBFF3,
	0xDBA1, 0xAAF3,
	0xDBA2, 0xCDD7,
	0xDBA3, 0xD3F7,
	0xDBA4, 0xD0BB,
	0xDBA5, 0xD0BC,
	0xDBA6, 0xEBD7,
	0xDBA8, 0xD0BD,
	0xDBA9, 0xDC50,
	0xDBAA, 0xC5B0,
	0xDBAB, 0xB072,
	0xDBAC, 0xD3FC,
	0xDBAD, 0xD3FB,
	0xDBAE, 0xD3FA,
	0xDBAF, 0xD7EF,
	0xDBB0, 0xD7E8,
	0xDBB1, 0xB66E,
	0xDBB2, 0xDC52,
	0xDBB3, 0xE46B,
	0xDBB4, 0xBBC2,
	0xDBB5, 0xE468,
	0xDBB6, 0xBE49,
	0xDBB7, 0xE854,
	0xDBB8, 0xC1DD,
	0xDBB9, 0xF4E1,
	0xDBBA, 0xF65A,
	0xDBBB, 0xAFEC,
	0xDBBC, 0xABB7,
	0xDBBD, 0xE4F4,
	0xDBBE, 0xA757,
	0xDBBF, 0xCA6F,
	0xDBC0, 0xA8F0,
	0xDBC1, 0xD0F8,
	0xDBC3, 0xD46D,
	0xDBC4, 0xBC45,
	0xDBC5, 0xADEE,
	0xDBC6, 0xC0E8,
	0xDBC7, 0xF477,
	0xDBCB, 0xD44A,
	0xDBCD, 0xA5AF,
	0xDBCE, 0xAF63,
	0xDBCF, 0xD057,
	0xDBD0, 0xCAAC,
	0xDBD1, 0xB0EE,
	0xDBD3, 0xB9D1,
	0xDBD4, 0xE94F,
	0xDBD5, 0xBEC3,
	0xDBD6, 0xC0A4,
	0xDBD7, 0xA666,
	0xDBD8, 0xA664,
	0xDBDA, 0xA660,
	0xDBDB, 0xC252,
	0xDBDC, 0xC9C8,
	0xDBDD, 0xA665,
	0xDBDE, 0xC363,
	0xDBDF, 0xA7A6,
	0xDBE1, 0xA958,
	0xDBE3, 0xCBF5,
	0xDBE4, 0xF1F6,
	0xDBE5, 0xA95C,
	0xDBE6, 0xCBFB,
	0xDBE7, 0xCC40,
	0xDBE8, 0xCBF4,
	0xDBE9, 0xCBF8,
	0xDBEA, 0xCBFC,
	0xDBEB, 0xD4C1,
	0xDBEC, 0xCE53,
	0xDBED, 0xCE54,
	0xDBEE, 0xDCE5,
	0xDBEF, 0xD4BA,
	0xDBF2, 0xABB2,
	0xDBF3, 0xABAD,
	0xDBF4, 0xD14C,
	0xDBF5, 0xB6F6,
	0xDBF6, 0xB3FA,
	0xDBF7, 0xDCE4,
	0xDBF8, 0xD14D,
	0xDBF9, 0xD152,
	0xDBFA, 0xD4B2,
	0xDBFC, 0xD4B7,
	0xDBFD, 0xB0F1,
	0xDCA1, 0xD4B8,
	0xDCA2, 0xD4CB,
	0xDCA3, 0xD4B5,
	0xDCA4, 0xD4B4,
	0xDCA5, 0xD4B3,
	0xDCA6, 0xD8A2,
	0xDCA7, 0xD8A1,
	0xDCA9, 0xB3FB,
	0xDCAA, 0xDCED,
	0xDCAC, 0xE15B,
	0xDCAD, 0xE156,
	0xDCAF, 0xBC55,
	0xDCB0, 0xC4C9,
	0xDCB1, 0xC567,
	0xDCB2, 0xC574,
	0xDCB4, 0xCA4D,
	0xDCB5, 0xCA4E,
	0xDCB6, 0xCB7A,
	0xDCB7, 0xCBA1,
	0xDCB8, 0xCDBF,
	0xDCB9, 0xCBA3,
	0xDCBA, 0xCB7C,
	0xDCBB, 0xCB7D,
	0xDCBC, 0xEB52,
	0xDCBD, 0xAADC,
	0xDCBE, 0xCDB4,
	0xDCBF, 0xAAE5,
	0xDCC0, 0xAAE8,
	0xDCC1, 0xAAE7,
	0xDCC2, 0xF4BE,
	0xDCC4, 0xAD55,
	0xDCC5, 0xCDB6,
	0xDCC6, 0xAAE9,
	0xDCC7, 0xCDBA,
	0xDCC8, 0xB341,
	0xDCC9, 0xB5E7,
	0xDCCA, 0xE776,
	0xDCCB, 0xCDC1,
	0xDCCC, 0xCDBE,
	0xDCCD, 0xCDC0,
	0xDCCF, 0xAADF,
	0xDCD1, 0xAD52,
	0xDCD2, 0xCDC3,
	0xDCD3, 0xD077,
	0xDCD4, 0xAD5B,
	0xDCD6, 0xD0A1,
	0xDCD7, 0xF4B8,
	0xDCD8, 0xD06E,
	0xDCD9, 0xAD60,
	0xDCDA, 0xD075,
	0xDCDB, 0xAD5C,
	0xDCDD, 0xD07A,
	0xDCDE, 0xD07B,
	0xDCDF, 0xAD64,
	0xDCE0, 0xE772,
	0xDCE2, 0xAD67,
	0xDCE3, 0xB6F7,
	0xDCE4, 0xDE72,
	0xDCE5, 0xD0A2,
	0xDCE6, 0xD071,
	0xDCE7, 0xD37D,
	0xDCE8, 0xD377,
	0xDCE9, 0xEAFE,
	0xDCEA, 0xE76E,
	0xDCEB, 0xD3A5,
	0xDCEC, 0xB2F7,
	0xDCED, 0xD3A6,
	0xDCEE, 0xAFF5,
	0xDCEF, 0xAFFC,
	0xDCF0, 0xD76C,
	0xDCF1, 0xEB4C,
	0xDCF2, 0xD3AC,
	0xDCF3, 0xAFF6,
	0xDCF4, 0xD3AE,
	0xDCF5, 0xAFFE,
	0xDCF6, 0xEE50,
	0xDCF7, 0xAFFB,
	0xDCF8, 0xAFFA,
	0xDCF9, 0xC2C9,
	0xDCFA, 0xD374,
	0xDCFB, 0xD072,
	0xDCFC, 0xD373,
	0xDCFD, 0xBABA,
	0xDCFE, 0xE26C,
	0xDDA2, 0xD3A3,
	0xDDA3, 0xF0B0,
	0xDDA5, 0xBB5E,
	0xDDA6, 0xDFD2,
	0xDDA9, 0xB2F2,
	0xDDAA, 0xE3C2,
	0xDDAB, 0xB8B1,
	0xDDAC, 0xB2FB,
	0xDDAD, 0xD76D,
	0xDDAE, 0xB2F9,
	0xDDB0, 0xBB59,
	0xDDB1, 0xB2FE,
	0xDDB3, 0xD767,
	0xDDB4, 0xD768,
	0xDDB5, 0xEB4F,
	0xDDB6, 0xB2FD,
	0xDDB7, 0xB2F1,
	0xDDB8, 0xB2F0,
	0xDDB9, 0xD75B,
	0xDDBA, 0xC561,
	0xDDBC, 0xB5D7,
	0xDDBD, 0xDB6D,
	0xDDBE, 0xDB6F,
	0xDDBF, 0xDB70,
	0xDDC0, 0xD4BB,
	0xDDC2, 0xB5D6,
	0xDDC3, 0xDB6E,
	0xDDC4, 0xB5E0,
	0xDDC5, 0xDB75,
	0xDDC7, 0xB5E3,
	0xDDC8, 0xDB7B,
	0xDDC9, 0xDB7C,
	0xDDCA, 0xB5E8,
	0xDDCB, 0xB5E9,
	0xDDCC, 0xDB79,
	0xDDCD, 0xB5D1,
	0xDDCE, 0xB5D2,
	0xDDCF, 0xDB5E,
	0xDDD0, 0xDBA5,
	0xDDD1, 0xB5D5,
	0xDDD2, 0xDB60,
	0xDDD3, 0xBFA2,
	0xDDD4, 0xB5DD,
	0xDDD5, 0xDB72,
	0xDDD7, 0xDFB1,
	0xDDD8, 0xDFB8,
	0xDDD9, 0xDFB9,
	0xDDDA, 0xDFBB,
	0xDDDB, 0xEB41,
	0xDDDD, 0xDFC2,
	0xDDDE, 0xEB44,
	0xDDDF, 0xDFC4,
	0xDDE0, 0xB8B0,
	0xDDE1, 0xB8B6,
	0xDDE2, 0xB8B4,
	0xDDE3, 0xDFAC,
	0xDDE4, 0xE76F,
	0xDDE5, 0xDFD5,
	0xDDE6, 0xB8A9,
	0xDDE7, 0xB8B5,
	0xDDE8, 0xE3B8,
	0xDDE9, 0xE3B9,
	0xDDEA, 0xE3BD,
	0xDDEB, 0xC55A,
	0xDDED, 0xBB5F,
	0xDDEE, 0xBB63,
	0xDDEF, 0xBB55,
	0xDDF0, 0xE3B0,
	0xDDF1, 0xF7F0,
	0xDDF2, 0xE3AE,
	0xDDF3, 0xE3B6,
	0xDDF4, 0xE3B7,
	0xDDF5, 0xE3AC,
	0xDDF7, 0xEE40,
	0xDDF8, 0xE75C,
	0xDDF9, 0xBF5F,
	0xDDFB, 0xE775,
	0xDDFC, 0xF5FD,
	0xDDFD, 0xE754,
	0xDDFE, 0xC4A9,
	0xDEA1, 0xEAF8,
	0xDEA2, 0xE74D,
	0xDEA3, 0xBDB6,
	0xDEA4, 0xE764,
	0xDEA5, 0xBFB7,
	0xDEA6, 0xBFB8,
	0xDEA7, 0xBFB9,
	0xDEA8, 0xEB42,
	0xDEA9, 0xBFBF,
	0xDEAA, 0xEE44,
	0xDEAB, 0xEA7B,
	0xDEAC, 0xBFBB,
	0xDEAD, 0xF4BF,
	0xDEAE, 0xEDFB,
	0xDEAF, 0xEDFC,
	0xDEB0, 0xC1A9,
	0xDEB1, 0xC1A8,
	0xDEB2, 0xEDF5,
	0xDEB3, 0xEE52,
	0xDEB4, 0xC3C1,
	0xDEB5, 0xC1A3,
	0xDEB6, 0xEE51,
	0xDEB7, 0xC2CA,
	0xDEB8, 0xF0B8,
	0xDEB9, 0xC2C8,
	0xDEBA, 0xC4F6,
	0xDEBC, 0xF2D4,
	0xDEBD, 0xF4B9,
	0xDEBE, 0xF5F8,
	0xDEBF, 0xF4C1,
	0xDEC0, 0xF5FC,
	0xDEC1, 0xC4F4,
	0xDEC2, 0xF7F3,
	0xDEC3, 0xA47B,
	0xDEC4, 0xABD9,
	0xDEC5, 0xC9CB,
	0xDEC6, 0xB9DD,
	0xDEC7, 0xD055,
	0xDEC8, 0xABB3,
	0xDEC9, 0xAE4F,
	0xDECA, 0xAE4E,
	0xDECB, 0xB0CC,
	0xDECC, 0xA471,
	0xDECD, 0xC9D5,
	0xDECE, 0xA7BC,
	0xDECF, 0xC0AA,
	0xDED1, 0xB1BF,
	0xDED2, 0xE1DE,
	0xDED3, 0xCCBD,
	0xDED4, 0xCCB9,
	0xDED5, 0xA9E9,
	0xDED6, 0xA9ED,
	0xDED7, 0xABFA,
	0xDED8, 0xE5B9,
	0xDED9, 0xCEDF,
	0xDEDA, 0xD1BA,
	0xDEDB, 0xD1BB,
	0xDEDC, 0xD1B8,
	0xDEDD, 0xD56D,
	0xDEDE, 0xD95E,
	0xDEDF, 0xB1BA,
	0xDEE0, 0xB1CC,
	0xDEE1, 0xD571,
	0xDEE2, 0xBA51,
	0xDEE3, 0xD579,
	0xDEE4, 0xB1C5,
	0xDEE5, 0xD568,
	0xDEE6, 0xB1CA,
	0xDEE7, 0xD57A,
	0xDEE8, 0xE1E8,
	0xDEE9, 0xD960,
	0xDEEB, 0xD95D,
	0xDEEC, 0xBCC3,
	0xDEED, 0xD967,
	0xDEEF, 0xD955,
	0xDEF0, 0xB4AC,
	0xDEF1, 0xB47D,
	0xDEF2, 0xD964,
	0xDEF3, 0xEFD2,
	0xDEF4, 0xDDAE,
	0xDEF5, 0xDDB6,
	0xDEF6, 0xDDB8,
	0xDEF7, 0xDD7D,
	0xDEF8, 0xE25E,
	0xDEF9, 0xDDAB,
	0xDEFA, 0xDDBA,
	0xDEFB, 0xE1E7,
	0xDEFC, 0xF44C,
	0xDEFD, 0xBA54,
	0xDEFE, 0xE5AF,
	0xDFA1, 0xBA50,
	0xDFA2, 0xC25E,
	0xDFA3, 0xEFD7,
	0xDFA4, 0xBCC1,
	0xDFA5, 0xF5CD,
	0xDFA7, 0xE9A6,
	0xDFA8, 0xE9A4,
	0xDFA9, 0xECEC,
	0xDFAA, 0xC0C2,
	0xDFAB, 0xF245,
	0xDFAC, 0xF7DD,
	0xDFAD, 0xF8EF,
	0xDFAE, 0xA47C,
	0xDFAF, 0xCAD6,
	0xDFB1, 0xB749,
	0xDFB3, 0xA577,
	0xDFB4, 0xBC54,
	0xDFB5, 0xA56E,
	0xDFB6, 0xA56F,
	0xDFB7, 0xA57B,
	0xDFB8, 0xA65C,
	0xDFBA, 0xA65B,
	0xDFBC, 0xE546,
	0xDFBD, 0xC56D,
	0xDFBE, 0xCA79,
	0xDFBF, 0xF1F2,
	0xDFC0, 0xA763,
	0xDFC2, 0xD0F9,
	0xDFC6, 0xCBDF,
	0xDFC8, 0xA945,
	0xDFC9, 0xA94B,
	0xDFCA, 0xCBEF,
	0xDFCB, 0xA94E,
	0xDFCC, 0xC07B,
	0xDFCD, 0xA946,
	0xDFCE, 0xA94C,
	0xDFCF, 0xCBE7,
	0xDFD2, 0xCDFC,
	0xDFD3, 0xAB7B,
	0xDFD5, 0xE8FD,
	0xDFD6, 0xABA8,
	0xDFD7, 0xAB78,
	0xDFD8, 0xE4F9,
	0xDFD9, 0xB9CD,
	0xDFDA, 0xCE4D,
	0xDFDC, 0xE941,
	0xDFDD, 0xABA6,
	0xDFDE, 0xABA9,
	0xDFE0, 0xE944,
	0xDFE2, 0xECC1,
	0xDFE3, 0xABA7,
	0xDFE4, 0xAB7D,
	0xDFE6, 0xBEBA,
	0xDFE7, 0xCDFE,
	0xDFE8, 0xCE4E,
	0xDFE9, 0xE14D,
	0xDFEA, 0xD0F4,
	0xDFEB, 0xBC47,
	0xDFEC, 0xAE43,
	0xDFED, 0xADF8,
	0xDFEE, 0xD0F5,
	0xDFEF, 0xDCD4,
	0xDFF1, 0xAE44,
	0xDFF2, 0xD0FC,
	0xDFF3, 0xAE41,
	0xDFF4, 0xD477,
	0xDFF5, 0xB9C9,
	0xDFF6, 0xD86F,
	0xDFF7, 0xD870,
	0xDFF9, 0xC4DA,
	0xDFFA, 0xB0E7,
	0xDFFB, 0xB0DE,
	0xDFFD, 0xD475,
	0xE0A1, 0xADF2,
	0xE0A2, 0xB0DC,
	0xE0A3, 0xD471,
	0xE0A4, 0xD472,
	0xE0A6, 0xB0E6,
	0xE0A7, 0xD47C,
	0xE0A8, 0xB0E3,
	0xE0A9, 0xB3E3,
	0xE0AA, 0xDCD6,
	0xE0AB, 0xB3E4,
	0xE0AC, 0xB3ED,
	0xE0AE, 0xD86E,
	0xE0AF, 0xD871,
	0xE0B0, 0xB3E7,
	0xE0B1, 0xB3EE,
	0xE0B2, 0xDCDB,
	0xE0B3, 0xD866,
	0xE0B4, 0xB3D7,
	0xE0B5, 0xB6D8,
	0xE0B6, 0xB9C6,
	0xE0B7, 0xF441,
	0xE0B8, 0xB3E1,
	0xE0B9, 0xB3F1,
	0xE0BB, 0xB9C8,
	0xE0BC, 0xB6E8,
	0xE0BD, 0xB9CA,
	0xE0BE, 0xB6DF,
	0xE0BF, 0xC4D9,
	0xE0C1, 0xDCD2,
	0xE0C2, 0xB6DB,
	0xE0C3, 0xDCD0,
	0xE0C4, 0xDCD3,
	0xE0C5, 0xB6E2,
	0xE0C6, 0xB6E7,
	0xE0C7, 0xDCDD,
	0xE0C8, 0xBEBC,
	0xE0C9, 0xDCCC,
	0xE0CA, 0xDCDE,
	0xE0CB, 0xB6D9,
	0xE0CD, 0xB6E1,
	0xE0CE, 0xC5AF,
	0xE0D0, 0xB9CB,
	0xE0D1, 0xE149,
	0xE0D2, 0xE14E,
	0xE0D3, 0xC458,
	0xE0D5, 0xB9BE,
	0xE0D6, 0xB9BF,
	0xE0D7, 0xE147,
	0xE0D9, 0xE4FE,
	0xE0DA, 0xBC49,
	0xE0DB, 0xBC50,
	0xE0DC, 0xE544,
	0xE0DE, 0xBEBE,
	0xE0DF, 0xBEB2,
	0xE0E0, 0xC250,
	0xE0E1, 0xE4F8,
	0xE0E3, 0xECC3,
	0xE0E4, 0xBEB6,
	0xE0E5, 0xBEBB,
	0xE0E6, 0xBEB3,
	0xE0E9, 0xC07D,
	0xE0EA, 0xECC0,
	0xE0EC, 0xF8EE,
	0xE0ED, 0xC949,
	0xE0EE, 0xA65F,
	0xE0EF, 0xC9C6,
	0xE0F0, 0xD4AC,
	0xE0F1, 0xA77A,
	0xE0F2, 0xCBF1,
	0xE0F3, 0xABAA,
	0xE0F4, 0xAE46,
	0xE0F5, 0xD4AB,
	0xE0F6, 0xB0EB,
	0xE0F7, 0xE947,
	0xE0F8, 0xB457,
	0xE0F9, 0xCC6F,
	0xE0FA, 0xCC6E,
	0xE0FB, 0xA9AE,
	0xE0FC, 0xECDB,
	0xE0FD, 0xE1B2,
	0xE0FE, 0xB9F6,
	0xE1A1, 0xB163,
	0xE1A2, 0xD8F2,
	0xE1A3, 0xB9F7,
	0xE1A4, 0xB9F3,
	0xE1A6, 0xBC6E,
	0xE1A7, 0xA7C4,
	0xE1A8, 0xC9D7,
	0xE1A9, 0xCAC0,
	0xE1AA, 0xA7C1,
	0xE1AB, 0xB9F2,
	0xE1AC, 0xCAC2,
	0xE1AD, 0xAE73,
	0xE1AF, 0xA7C2,
	0xE1B0, 0xB450,
	0xE1B2, 0xCC5E,
	0xE1B3, 0xCC65,
	0xE1B5, 0xCC61,
	0xE1B6, 0xA9A6,
	0xE1B7, 0xA9A7,
	0xE1B8, 0xCC63,
	0xE1BA, 0xA9A2,
	0xE1BB, 0xE961,
	0xE1BC, 0xABD0,
	0xE1BD, 0xE569,
	0xE1BE, 0xCE7D,
	0xE1BF, 0xB157,
	0xE1C0, 0xE563,
	0xE1C1, 0xD4FB,
	0xE1C2, 0xB15D,
	0xE1C3, 0xD4FC,
	0xE1C4, 0xD544,
	0xE1C5, 0xB15C,
	0xE1C6, 0xD4F4,
	0xE1C7, 0xB153,
	0xE1C8, 0xB155,
	0xE1C9, 0xC0AF,
	0xE1CB, 0xB451,
	0xE1CC, 0xD8E6,
	0xE1CD, 0xDD52,
	0xE1CE, 0xD8E3,
	0xE1CF, 0xB744,
	0xE1D0, 0xE1A8,
	0xE1D1, 0xD8DB,
	0xE1D2, 0xD8DD,
	0xE1D3, 0xDD4F,
	0xE1D4, 0xB743,
	0xE1D6, 0xE1A3,
	0xE1D7, 0xE562,
	0xE1D8, 0xBC6A,
	0xE1D9, 0xC1C7,
	0xE1DA, 0xECDA,
	0xE1DB, 0xC571,
	0xE1DC, 0xC94C,
	0xE1DD, 0xA7CF,
	0xE1DE, 0xCC75,
	0xE1DF, 0xABE0,
	0xE1E0, 0xABE2,
	0xE1E1, 0xABE1,
	0xE1E2, 0xB174,
	0xE1E3, 0xB170,
	0xE1E4, 0xB175,
	0xE1E5, 0xB461,
	0xE1E6, 0xDD64,
	0xE1E7, 0xBC78,
	0xE1E8, 0xE975,
	0xE1E9, 0xC5FC,
	0xE1EC, 0xC9A6,
	0xE1ED, 0xCA43,
	0xE1EE, 0xC278,
	0xE1F0, 0xCB63,
	0xE1F1, 0xCB65,
	0xE1F2, 0xAAAD,
	0xE1F4, 0xCD61,
	0xE1F5, 0xCFC0,
	0xE1F6, 0xEA61,
	0xE1F7, 0xACBC,
	0xE1F8, 0xDEAC,
	0xE1F9, 0xD2A5,
	0xE1FA, 0xAF58,
	0xE1FB, 0xD2AA,
	0xE1FC, 0xD2A8,
	0xE1FD, 0xEA60,
	0xE1FE, 0xD2A4,
	0xE2A1, 0xD2A9,
	0xE2A2, 0xD661,
	0xE2A3, 0xB274,
	0xE2A4, 0xC57A,
	0xE2A5, 0xD665,
	0xE2A6, 0xD669,
	0xE2A7, 0xD660,
	0xE2A8, 0xF46E,
	0xE2A9, 0xDA70,
	0xE2AB, 0xB554,
	0xE2AE, 0xDA71,
	0xE2AF, 0xBABC,
	0xE2B0, 0xE2CB,
	0xE2B1, 0xBCFB,
	0xE2B2, 0xE679,
	0xE2B3, 0xEA5E,
	0xE2B4, 0xED65,
	0xE2B5, 0xF5DD,
	0xE2B6, 0xA6DF,
	0xE2B7, 0xB9D9,
	0xE2B8, 0xB6B8,
	0xE2B9, 0xB9DB,
	0xE2BC, 0xEF4F,
	0xE2BD, 0xB6BB,
	0xE2BE, 0xF1AD,
	0xE2BF, 0xB6B9,
	0xE2C0, 0xDCAE,
	0xE2C1, 0xB6BD,
	0xE2C2, 0xB97E,
	0xE2C3, 0xBBE8,
	0xE2C4, 0xE8C1,
	0xE2C5, 0xBE6C,
	0xE2C6, 0xC05F,
	0xE2C8, 0xC349,
	0xE2C9, 0xF3B1,
	0xE2CA, 0xF3AF,
	0xE2CB, 0xC444,
	0xE2CD, 0xF557,
	0xE2CF, 0xC979,
	0xE2D0, 0xE575,
	0xE2D1, 0xCACD,
	0xE2D2, 0xA9B4,
	0xE2D3, 0xCEBA,
	0xE2D4, 0xABD6,
	0xE2D5, 0xD549,
	0xE2D6, 0xB167,
	0xE2D7, 0xB168,
	0xE2D8, 0xD54B,
	0xE2D9, 0xBDE9,
	0xE2DA, 0xE1BC,
	0xE2DB, 0xE1B6,
	0xE2DC, 0xE573,
	0xE2DD, 0xE972,
	0xE2DE, 0xE96F,
	0xE2DF, 0xC174,
	0xE2E1, 0xC97B,
	0xE2E2, 0xA6A4,
	0xE2E3, 0xC462,
	0xE2E4, 0xBCAD,
	0xE2E5, 0xCADB,
	0xE2E6, 0xE1D3,
	0xE2E7, 0xCADD,
	0xE2E8, 0xCADE,
	0xE2E9, 0xB75A,
	0xE2EA, 0xB1A3,
	0xE2EB, 0xB75B,
	0xE2EC, 0xA7D8,
	0xE2ED, 0xCAD9,
	0xE2EE, 0xA7D7,
	0xE2EF, 0xCC7C,
	0xE2F0, 0xA9C5,
	0xE2F1, 0xCC7B,
	0xE2F2, 0xA9CD,
	0xE2F3, 0xA9C2,
	0xE2F4, 0xCCA9,
	0xE2F5, 0xA9CB,
	0xE2F6, 0xA9CC,
	0xE2F7, 0xCCA2,
	0xE2F8, 0xE97D,
	0xE2F9, 0xA9C9,
	0xE2FA, 0xBA45,
	0xE2FB, 0xECE6,
	0xE2FC, 0xB46C,
	0xE2FD, 0xB75F,
	0xE2FE, 0xCECB,
	0xE3A1, 0xABF1,
	0xE3A2, 0xD940,
	0xE3A3, 0xAEAF,
	0xE3A4, 0xAEAA,
	0xE3A5, 0xE1C7,
	0xE3A6, 0xD1A7,
	0xE3A7, 0xD1A8,
	0xE3A8, 0xD1A5,
	0xE3A9, 0xAEAD,
	0xE3AA, 0xD1AA,
	0xE3AB, 0xB467,
	0xE3AC, 0xB1A2,
	0xE3AD, 0xD55E,
	0xE3AE, 0xD55C,
	0xE3AF, 0xB1A6,
	0xE3B0, 0xB1A8,
	0xE3B1, 0xB1AB,
	0xE3B2, 0xB17C,
	0xE3B3, 0xB759,
	0xE3B4, 0xE5A6,
	0xE3B5, 0xB46A,
	0xE3B6, 0xB468,
	0xE3B7, 0xB46D,
	0xE3B8, 0xB473,
	0xE3B9, 0xB470,
	0xE3BA, 0xDD68,
	0xE3BB, 0xDD67,
	0xE3BC, 0xBA48,
	0xE3BD, 0xBCA9,
	0xE3BE, 0xBCAC,
	0xE3BF, 0xBCA5,
	0xE3C1, 0xBECF,
	0xE3C2, 0xC36A,
	0xE3C3, 0xA9BD,
	0xE3C4, 0xF16F,
	0xE3C5, 0xADAC,
	0xE3C6, 0xD845,
	0xE3C7, 0xC1F2,
	0xE3C8, 0xB6A3,
	0xE3C9, 0xB67B,
	0xE3CA, 0xDC7A,
	0xE3CB, 0xF66B,
	0xE3CC, 0xBE5B,
	0xE3CD, 0xE8A7,
	0xE3CE, 0xF9C4,
	0xE3CF, 0xE8A6,
	0xE3D0, 0xEC48,
	0xE3D1, 0xEC4B,
	0xE3D3, 0xEC4C,
	0xE3D4, 0xEC4E,
	0xE3D5, 0xEC46,
	0xE3D6, 0xEEF1,
	0xE3D7, 0xC1F0,
	0xE3D8, 0xC2F3,
	0xE3D9, 0xC2F5,
	0xE3DA, 0xC2F6,
	0xE3DB, 0xF545,
	0xE3DE, 0xA9CF,
	0xE3E0, 0xC9FD,
	0xE3E1, 0xC9FA,
	0xE3E2, 0xC9FC,
	0xE3E3, 0xF5D3,
	0xE3E4, 0xA84A,
	0xE3E5, 0xA84E,
	0xE3E6, 0xA85C,
	0xE3E7, 0xA850,
	0xE3E8, 0xA851,
	0xE3EA, 0xA858,
	0xE3EB, 0xA85A,
	0xE3EC, 0xA859,
	0xE3ED, 0xD9EC,
	0xE3EE, 0xCCF8,
	0xE3EF, 0xCCF4,
	0xE3F0, 0xCCF5,
	0xE3F1, 0xF25D,
	0xE3F2, 0xC379,
	0xE3F3, 0xAA74,
	0xE3F4, 0xAA72,
	0xE3F6, 0xAA7E,
	0xE3F7, 0xAA7D,
	0xE3F8, 0xEFF6,
	0xE3F9, 0xCCF0,
	0xE3FA, 0xCCF1,
	0xE3FB, 0xAA62,
	0xE3FC, 0xAA6C,
	0xE3FD, 0xAA7B,
	0xE3FE, 0xAEF9,
	0xE4A1, 0xACA7,
	0xE4A2, 0xACA8,
	0xE4A3, 0xAC7B,
	0xE4A4, 0xAF48,
	0xE4A5, 0xD9FE,
	0xE4A6, 0xCFA7,
	0xE4A7, 0xCF77,
	0xE4A8, 0xCF78,
	0xE4A9, 0xACAD,
	0xE4AA, 0xACAE,
	0xE4AB, 0xE9F8,
	0xE4AC, 0xACAB,
	0xE4AD, 0xACAC,
	0xE4AE, 0xCF7A,
	0xE4AF, 0xC273,
	0xE4B0, 0xE271,
	0xE4B1, 0xBCF1,
	0xE4B2, 0xCF76,
	0xE4B3, 0xD250,
	0xE4B4, 0xD24F,
	0xE4B5, 0xD5E9,
	0xE4B6, 0xE65C,
	0xE4B7, 0xD255,
	0xE4B8, 0xAEFE,
	0xE4B9, 0xAF4B,
	0xE4BB, 0xD257,
	0xE4BC, 0xD25A,
	0xE4BD, 0xD246,
	0xE4BE, 0xB25A,
	0xE4BF, 0xB24E,
	0xE4C0, 0xB258,
	0xE4C1, 0xB253,
	0xE4C2, 0xC270,
	0xE4C3, 0xB267,
	0xE4C4, 0xD5ED,
	0xE4C5, 0xBF49,
	0xE4C6, 0xB268,
	0xE4C7, 0xD5F3,
	0xE4C8, 0xB246,
	0xE4C9, 0xC26E,
	0xE4CA, 0xD5E1,
	0xE4CB, 0xD5F1,
	0xE4CC, 0xB252,
	0xE4CD, 0xD9F1,
	0xE4CE, 0xB4F3,
	0xE4CF, 0xB542,
	0xE4D0, 0xDA47,
	0xE4D1, 0xDE59,
	0xE4D2, 0xB547,
	0xE4D3, 0xE2A9,
	0xE4D4, 0xDA4B,
	0xE4D5, 0xB4E6,
	0xE4D6, 0xB4E8,
	0xE4D7, 0xB4EC,
	0xE4D8, 0xB544,
	0xE4D9, 0xF9D0,
	0xE4DA, 0xDE4C,
	0xE4DB, 0xB7C2,
	0xE4DC, 0xF5D4,
	0xE4DD, 0xE2A5,
	0xE4DE, 0xEFEF,
	0xE4DF, 0xB7C1,
	0xE4E0, 0xB7CC,
	0xE4E1, 0xDE50,
	0xE4E3, 0xDE54,
	0xE4E4, 0xE65F,
	0xE4E5, 0xB7CD,
	0xE4E6, 0xDE58,
	0xE4E7, 0xDE46,
	0xE4E8, 0xB7BC,
	0xE4E9, 0xDE48,
	0xE4EA, 0xE643,
	0xE4EB, 0xF25E,
	0xE4EC, 0xC374,
	0xE4EE, 0xBAA8,
	0xE4EF, 0xE2A3,
	0xE4F0, 0xBAAA,
	0xE4F1, 0xE2A1,
	0xE4F2, 0xC46B,
	0xE4F3, 0xEFF5,
	0xE4F4, 0xBAAC,
	0xE4F5, 0xE275,
	0xE4F6, 0xBA78,
	0xE4F7, 0xE641,
	0xE4F8, 0xE640,
	0xE4F9, 0xE642,
	0xE4FA, 0xBCE8,
	0xE4FB, 0xE64C,
	0xE4FC, 0xBCE0,
	0xE4FD, 0xBCEB,
	0xE4FE, 0xC375,
	0xE5A1, 0xEA41,
	0xE5A2, 0xBF43,
	0xE5A3, 0xBF46,
	0xE5A4, 0xBF47,
	0xE5A5, 0xBEFC,
	0xE5A6, 0xC0E1,
	0xE5A7, 0xC0E4,
	0xE5A9, 0xC0DA,
	0xE5AA, 0xC0DE,
	0xE5AB, 0xC376,
	0xE5AC, 0xF263,
	0xE5AD, 0xC373,
	0xE5AE, 0xF465,
	0xE5AF, 0xF45C,
	0xE5B0, 0xF8AF,
	0xE5B1, 0xC5F4,
	0xE5B3, 0xC973,
	0xE5B4, 0xCC58,
	0xE5B5, 0xCC57,
	0xE5B6, 0xABC9,
	0xE5B7, 0xAE66,
	0xE5B8, 0xDAAC,
	0xE5B9, 0xC4CA,
	0xE5BA, 0xBA53,
	0xE5BB, 0xB9ED,
	0xE5BC, 0xBC64,
	0xE5BD, 0xEB72,
	0xE5BE, 0xBEC8,
	0xE5BF, 0xEEBF,
	0xE5C0, 0xEEAA,
	0xE5C2, 0xCDCE,
	0xE5C3, 0xCDD1,
	0xE5C4, 0xAD7E,
	0xE5C5, 0xD0B5,
	0xE5C6, 0xADA3,
	0xE5C7, 0xC2E2,
	0xE5C8, 0xAD7B,
	0xE5C9, 0xB377,
	0xE5CA, 0xADA4,
	0xE5CB, 0xB06D,
	0xE5CC, 0xD3EF,
	0xE5CD, 0xD7E3,
	0xE5CE, 0xC5DD,
	0xE5CF, 0xD7E4,
	0xE5D0, 0xB370,
	0xE5D1, 0xB37C,
	0xE5D2, 0xD7E7,
	0xE5D3, 0xB666,
	0xE5D4, 0xB66A,
	0xE5D5, 0xDC4D,
	0xE5D6, 0xDC4F,
	0xE5D7, 0xE0A1,
	0xE5D8, 0xB94E,
	0xE5D9, 0xE07D,
	0xE5DA, 0xB949,
	0xE5DB, 0xBE43,
	0xE5DC, 0xBBB8,
	0xE5DD, 0xBBBD,
	0xE5DE, 0xBBBF,
	0xE5DF, 0xBEE6,
	0xE5E0, 0xBFEE,
	0xE5E1, 0xC1D8,
	0xE5E2, 0xC1DB,
	0xE5E3, 0xC2E4,
	0xE5E4, 0xC2E3,
	0xE5E5, 0xC3E5,
	0xE5E7, 0xB16B,
	0xE5E8, 0xCEBD,
	0xE5E9, 0xD8F4,
	0xE5EA, 0xC975,
	0xE5EB, 0xABA4,
	0xE5EC, 0xAE6A,
	0xE5ED, 0xD4F3,
	0xE5EE, 0xB447,
	0xE5EF, 0xE1A2,
	0xE5F0, 0xC0AB,
	0xE5F1, 0xC4F3,
	0xE5F2, 0xD179,
	0xE5F3, 0xA9B8,
	0xE5F4, 0xABDA,
	0xE5F5, 0xD758,
	0xE5F6, 0xB45D,
	0xE5F7, 0xF7A7,
	0xE5F9, 0xA671,
	0xE5FA, 0xA66D,
	0xE5FB, 0xA7B0,
	0xE5FC, 0xBC61,
	0xE5FD, 0xB9E1,
	0xE5FE, 0xA7AD,
	0xE6A1, 0xCAB5,
	0xE6A2, 0xA96E,
	0xE6A3, 0xD8B5,
	0xE6A4, 0xA7AC,
	0xE6A5, 0xA7B1,
	0xE6A6, 0xA971,
	0xE6A7, 0xCC48,
	0xE6A8, 0xA96F,
	0xE6A9, 0xA96B,
	0xE6AA, 0xA963,
	0xE6AB, 0xD4D5,
	0xE6AC, 0xBC63,
	0xE6AD, 0xCE67,
	0xE6AE, 0xF6DC,
	0xE6AF, 0xABBB,
	0xE6B0, 0xABB9,
	0xE6B2, 0xAE5B,
	0xE6B3, 0xAE5C,
	0xE6B4, 0xB445,
	0xE6B5, 0xBC5F,
	0xE6B6, 0xAE50,
	0xE6B7, 0xAE58,
	0xE6B8, 0xAE55,
	0xE6B9, 0xB0FE,
	0xE6BA, 0xD4D1,
	0xE6BB, 0xB144,
	0xE6BC, 0xD4D0,
	0xE6BD, 0xB140,
	0xE6BE, 0xB141,
	0xE6BF, 0xBC60,
	0xE6C1, 0xB6FE,
	0xE6C2, 0xB444,
	0xE6C3, 0xB440,
	0xE6C4, 0xD8B8,
	0xE6C5, 0xB6FC,
	0xE6C6, 0xE172,
	0xE6C7, 0xB742,
	0xE6C8, 0xE954,
	0xE6C9, 0xC0A7,
	0xE6CA, 0xDCF7,
	0xE6CB, 0xE175,
	0xE6CC, 0xB9E4,
	0xE6CD, 0xE952,
	0xE6CE, 0xB9E2,
	0xE6CF, 0xB9DF,
	0xE6D0, 0xB9E3,
	0xE6D1, 0xE16B,
	0xE6D2, 0xBC5E,
	0xE6D3, 0xE951,
	0xE6D4, 0xE958,
	0xE6D5, 0xECD0,
	0xE6D6, 0xC0A8,
	0xE6D7, 0xC45C,
	0xE6D8, 0xC9D4,
	0xE6DA, 0xA7B7,
	0xE6DB, 0xCC56,
	0xE6DC, 0xB446,
	0xE6DD, 0xA46D,
	0xE6DE, 0xA46E,
	0xE6DF, 0xCC55,
	0xE6E0, 0xE8CA,
	0xE6E1, 0xBE6F,
	0xE6E2, 0xBE74,
	0xE6E3, 0xF55F,
	0xE6E4, 0xC5E6,
	0xE6E5, 0xBE71,
	0xE6E6, 0xE8CE,
	0xE6E7, 0xC5BB,
	0xE6E8, 0xF77E,
	0xE6E9, 0xC063,
	0xE6EA, 0xC67A,
	0xE6EB, 0xF1AF,
	0xE6EC, 0xF1B2,
	0xE6ED, 0xF1B6,
	0xE6EE, 0xF67C,
	0xE6EF, 0xF563,
	0xE6F0, 0xC445,
	0xE6F1, 0xF67D,
	0xE6F2, 0xF561,
	0xE6F3, 0xF562,
	0xE6F4, 0xC559,
	0xE6F5, 0xF67B,
	0xE6F6, 0xF77C,
	0xE6F7, 0xC66B,
	0xE6F8, 0xF9B3,
	0xE6FA, 0xACFA,
	0xE6FB, 0xACF4,
	0xE6FC, 0xACF8,
	0xE6FD, 0xD04B,
	0xE6FE, 0xF5E7,
	0xE7A1, 0xAFC6,
	0xE7A2, 0xAFC4,
	0xE7A3, 0xD356,
	0xE7A4, 0xD6E6,
	0xE7A5, 0xB2D8,
	0xE7A6, 0xB2D9,
	0xE7A7, 0xBFA8,
	0xE7A8, 0xB2D1,
	0xE7A9, 0xB2D2,
	0xE7AC, 0xDAFB,
	0xE7AD, 0xB5BC,
	0xE7AE, 0xDF58,
	0xE7AF, 0xDF60,
	0xE7B0, 0xDF57,
	0xE7B1, 0xBAF0,
	0xE7B2, 0xBAF6,
	0xE7B3, 0xE36E,
	0xE7B5, 0xE36C,
	0xE7B6, 0xBD78,
	0xE7B7, 0xBAFE,
	0xE7B8, 0xE371,
	0xE7B9, 0xE365,
	0xE7BA, 0xBAED,
	0xE7BB, 0xBAFD,
	0xE7BC, 0xBD79,
	0xE7BD, 0xE6E7,
	0xE7BE, 0xBD7B,
	0xE7BF, 0xBD7A,
	0xE7C0, 0xF072,
	0xE7C1, 0xE6EB,
	0xE7C2, 0xE6EC,
	0xE7C3, 0xE6ED,
	0xE7C4, 0xEAD8,
	0xE7C5, 0xE6E8,
	0xE7C6, 0xBFA7,
	0xE7C7, 0xBFA6,
	0xE7C8, 0xEAD0,
	0xE7C9, 0xBFA5,
	0xE7CA, 0xEDD0,
	0xE7CB, 0xBF7E,
	0xE7CC, 0xBFA1,
	0xE7CD, 0xC47D,
	0xE7CE, 0xC165,
	0xE7CF, 0xC167,
	0xE7D0, 0xC15D,
	0xE7D1, 0xC15B,
	0xE7D2, 0xC162,
	0xE7D3, 0xF5E9,
	0xE7D4, 0xC2B7,
	0xE7D5, 0xC2B9,
	0xE7D6, 0xC5B7,
	0xE7D7, 0xF4AD,
	0xE7D8, 0xF2B2,
	0xE7D9, 0xF2B4,
	0xE7DA, 0xF940,
	0xE7DC, 0xBD42,
	0xE7DE, 0xCD72,
	0xE7DF, 0xB06F,
	0xE7E0, 0xCA45,
	0xE7E1, 0xBF59,
	0xE7E2, 0xDEB3,
	0xE7E3, 0xCD6A,
	0xE7E4, 0xAAB3,
	0xE7E5, 0xAAB2,
	0xE7E6, 0xCFC8,
	0xE7E7, 0xC46E,
	0xE7E8, 0xACBF,
	0xE7E9, 0xACC5,
	0xE7EA, 0xACC4,
	0xE7EC, 0xCFC9,
	0xE7ED, 0xD2AD,
	0xE7EE, 0xD2AC,
	0xE7EF, 0xB97A,
	0xE7F0, 0xB278,
	0xE7F1, 0xD2B2,
	0xE7F2, 0xD2B0,
	0xE7F3, 0xAF5F,
	0xE7F4, 0xC3A2,
	0xE7F5, 0xB7E9,
	0xE7F6, 0xE6A3,
	0xE7F7, 0xB558,
	0xE7F8, 0xB7EB,
	0xE7F9, 0xB561,
	0xE7FA, 0xB55B,
	0xE7FB, 0xB562,
	0xE7FC, 0xDA7C,
	0xE7FD, 0xDA7A,
	0xE7FE, 0xDA7B,
	0xE8A1, 0xB560,
	0xE8A2, 0xDAA1,
	0xE8A3, 0xB7E8,
	0xE8A4, 0xB7EC,
	0xE8A5, 0xDEB6,
	0xE8A6, 0xB7E5,
	0xE8A7, 0xB7EA,
	0xE8A8, 0xC0F5,
	0xE8A9, 0xBAC1,
	0xE8AA, 0xBD40,
	0xE8AB, 0xBF58,
	0xE8AC, 0xC4ED,
	0xE8AD, 0xBD41,
	0xE8AE, 0xE6A6,
	0xE8AF, 0xE6A2,
	0xE8B0, 0xBCFD,
	0xE8B1, 0xBF5C,
	0xE8B2, 0xC0F6,
	0xE8B3, 0xC0F3,
	0xE8B4, 0xED69,
	0xE8B5, 0xC27A,
	0xE8B6, 0xC5D0,
	0xE8B7, 0xF46F,
	0xE8B8, 0xF1A4,
	0xE8B9, 0xF3A5,
	0xE8BA, 0xC3FC,
	0xE8BB, 0xCB42,
	0xE8BC, 0xA840,
	0xE8BD, 0xA7FB,
	0xE8BE, 0xCB43,
	0xE8BF, 0xE259,
	0xE8C0, 0xF455,
	0xE8C1, 0xAA4A,
	0xE8C2, 0xAA57,
	0xE8C3, 0xAA48,
	0xE8C4, 0xCCD9,
	0xE8C6, 0xAA53,
	0xE8C7, 0xD9B3,
	0xE8C8, 0xBCD7,
	0xE8C9, 0xB1FA,
	0xE8CA, 0xAA44,
	0xE8CB, 0xAA49,
	0xE8CC, 0xAA56,
	0xE8CD, 0xCF55,
	0xE8CE, 0xC0CD,
	0xE8CF, 0xCF43,
	0xE8D0, 0xF453,
	0xE8D1, 0xAC5E,
	0xE8D2, 0xAC69,
	0xE8D3, 0xF456,
	0xE8D4, 0xAC6A,
	0xE8D5, 0xCF4A,
	0xE8D6, 0xAC63,
	0xE8D7, 0xCF4C,
	0xE8D8, 0xAC6C,
	0xE8D9, 0xB1F7,
	0xE8DA, 0xCF61,
	0xE8DB, 0xAC65,
	0xE8DC, 0xAC6B,
	0xE8DD, 0xF252,
	0xE8DE, 0xCEFB,
	0xE8DF, 0xECF7,
	0xE8E0, 0xD1DC,
	0xE8E1, 0xD1DD,
	0xE8E2, 0xD9B2,
	0xE8E3, 0xBEF8,
	0xE8E4, 0xD1E8,
	0xE8E5, 0xB7A9,
	0xE8E6, 0xD1E9,
	0xE8E7, 0xE24E,
	0xE8E8, 0xB1F2,
	0xE8E9, 0xD1EB,
	0xE8EB, 0xBEEC,
	0xE8EC, 0xAEEC,
	0xE8ED, 0xC0CC,
	0xE8EE, 0xAEE5,
	0xE8EF, 0xF7E1,
	0xE8F1, 0xD1DB,
	0xE8F2, 0xAEDD,
	0xE8F3, 0xB1EB,
	0xE8F4, 0xD5C0,
	0xE8F5, 0xD5BE,
	0xE8F6, 0xD5C1,
	0xE8F7, 0xB1EA,
	0xE8F8, 0xD5C4,
	0xE8F9, 0xC4E7,
	0xE8FA, 0xB4D8,
	0xE8FB, 0xD9C8,
	0xE8FC, 0xC370,
	0xE8FD, 0xE5DE,
	0xE8FE, 0xB4CD,
	0xE9A1, 0xF7E2,
	0xE9A2, 0xDDDE,
	0xE9A3, 0xD9CA,
	0xE9A4, 0xBCCD,
	0xE9A5, 0xDDD4,
	0xE9A6, 0xB4D0,
	0xE9A7, 0xD9B9,
	0xE9A8, 0xDDCE,
	0xE9A9, 0xDDD2,
	0xE9AA, 0xB7A3,
	0xE9AB, 0xDDD3,
	0xE9AC, 0xB7AF,
	0xE9AD, 0xC656,
	0xE9AE, 0xB7AA,
	0xE9B1, 0xDDDF,
	0xE9B2, 0xDDE0,
	0xE9B3, 0xBA6C,
	0xE9B4, 0xC468,
	0xE9B5, 0xC371,
	0xE9B6, 0xE241,
	0xE9B7, 0xF5D1,
	0xE9B8, 0xDDC9,
	0xE9B9, 0xB7B0,
	0xE9BA, 0xB7AD,
	0xE9BB, 0xBA64,
	0xE9BC, 0xE249,
	0xE9BD, 0xBA66,
	0xE9BE, 0xBA67,
	0xE9BF, 0xBA6B,
	0xE9C0, 0xE252,
	0xE9C1, 0xE1FC,
	0xE9C2, 0xBA60,
	0xE9C3, 0xE254,
	0xE9C4, 0xC262,
	0xE9C5, 0xBA5F,
	0xE9C6, 0xF24C,
	0xE9C7, 0xE24A,
	0xE9C8, 0xE5D3,
	0xE9C9, 0xC0CE,
	0xE9CA, 0xBCD8,
	0xE9CB, 0xE5CC,
	0xE9CC, 0xE5E8,
	0xE9CD, 0xF255,
	0xE9CE, 0xE5DA,
	0xE9CF, 0xBEF1,
	0xE9D0, 0xE9C4,
	0xE9D1, 0xC0D2,
	0xE9D2, 0xE9D1,
	0xE9D3, 0xE9C8,
	0xE9D4, 0xBEF6,
	0xE9D5, 0xECFE,
	0xE9D6, 0xC372,
	0xE9D7, 0xBEEA,
	0xE9D8, 0xE9CA,
	0xE9D9, 0xBEEF,
	0xE9DA, 0xF258,
	0xE9DB, 0xED44,
	0xE9DC, 0xC0D1,
	0xE9DD, 0xECF5,
	0xE9DE, 0xC0D0,
	0xE9E0, 0xB7DF,
	0xE9E2, 0xAA5C,
	0xE9E3, 0xCF65,
	0xE9E4, 0xBCDC,
	0xE9E5, 0xCF66,
	0xE9E6, 0xE266,
	0xE9E7, 0xC0D4,
	0xE9E8, 0xD5DC,
	0xE9E9, 0xE9E3,
	0xE9EA, 0xDDFB,
	0xE9EB, 0xC26C,
	0xE9EC, 0xE9E2,
	0xE9ED, 0xB062,
	0xE9EE, 0xB36D,
	0xE9F0, 0xB661,
	0xE9F1, 0xF847,
	0xE9F2, 0xDC40,
	0xE9F3, 0xB663,
	0xE9F4, 0xDC48,
	0xE9F6, 0xF765,
	0xE9F7, 0xDBFE,
	0xE9F8, 0xB8FD,
	0xE9F9, 0xB8FE,
	0xE9FA, 0xE079,
	0xE9FB, 0xE078,
	0xE9FC, 0xBBB3,
	0xE9FD, 0xBDFB,
	0xE9FE, 0xBDFE,
	0xEAA1, 0xBDF9,
	0xEAA2, 0xBDFD,
	0xEAA3, 0xBFEA,
	0xEAA4, 0xF146,
	0xEAA5, 0xC3E1,
	0xEAA7, 0xCCB1,
	0xEAA8, 0xE1D7,
	0xEAA9, 0xB1AE,
	0xEAAA, 0xB475,
	0xEAAB, 0xB761,
	0xEAAC, 0xB760,
	0xEAAD, 0xDD75,
	0xEAAE, 0xDD76,
	0xEAAF, 0xE1D6,
	0xEAB0, 0xBB4E,
	0xEAB1, 0xBF5E,
	0xEAB2, 0xD2BE,
	0xEAB3, 0xDEC0,
	0xEAB4, 0xED72,
	0xEAB5, 0xED70,
	0xEAB6, 0xF049,
	0xEAB8, 0xC9EE,
	0xEAB9, 0xC9ED,
	0xEABA, 0xCAF8,
	0xEABB, 0xA9FE,
	0xEABC, 0xBEE8,
	0xEABD, 0xAA58,
	0xEABE, 0xCCCA,
	0xEABF, 0xA9FD,
	0xEAC0, 0xA9FB,
	0xEAC1, 0xCD52,
	0xEAC2, 0xAC54,
	0xEAC3, 0xCEF5,
	0xEAC4, 0xCEF6,
	0xEAC5, 0xAC52,
	0xEAC6, 0xCEEB,
	0xEAC7, 0xBCCA,
	0xEAC8, 0xAFCF,
	0xEAC9, 0xD1D4,
	0xEACA, 0xBEE7,
	0xEACB, 0xAED0,
	0xEACC, 0xAECB,
	0xEACD, 0xB775,
	0xEACE, 0xD5AA,
	0xEAD0, 0xB4BE,
	0xEAD1, 0xB779,
	0xEAD2, 0xDDC0,
	0xEAD3, 0xC0C7,
	0xEAD4, 0xBA5C,
	0xEAD5, 0xE9B4,
	0xEAD6, 0xEFDB,
	0xEAD7, 0xC260,
	0xEAD8, 0xC466,
	0xEAD9, 0xC4E4,
	0xEADA, 0xB64E,
	0xEADB, 0xDBEA,
	0xEADC, 0xDBE8,
	0xEADD, 0xB64D,
	0xEADE, 0xF0F4,
	0xEADF, 0xB8ED,
	0xEAE0, 0xB8F0,
	0xEAE1, 0xF652,
	0xEAE2, 0xBBAC,
	0xEAE3, 0xE7EC,
	0xEAE4, 0xE453,
	0xEAE6, 0xE7EE,
	0xEAE7, 0xC1CC,
	0xEAE8, 0xDBD1,
	0xEAE9, 0xC1BB,
	0xEAEA, 0xE444,
	0xEAEB, 0xF753,
	0xEAEC, 0xBFCC,
	0xEAED, 0xEE7A,
	0xEAEE, 0xC2D1,
	0xEAEF, 0xF2F3,
	0xEAF0, 0xCFBD,
	0xEAF2, 0xA6C9,
	0xEAF4, 0xACBA,
	0xEAF5, 0xD65C,
	0xEAF6, 0xD65F,
	0xEAF7, 0xB551,
	0xEAF8, 0xDA6C,
	0xEAF9, 0xDEA5,
	0xEAFB, 0xBAB9,
	0xEAFC, 0xAEB2,
	0xEAFD, 0xD566,
	0xEAFE, 0xD954,
	0xEBA1, 0xE1EE,
	0xEBA2, 0xC0BC,
	0xEBA3, 0xACFE,
	0xEBA5, 0xD9E5,
	0xEBA6, 0xB7B7,
	0xEBA7, 0xE5F7,
	0xEBA8, 0xDE40,
	0xEBA9, 0xBEFB,
	0xEBAA, 0xF25B,
	0xEBAB, 0xE9E8,
	0xEBAC, 0xF6E7,
	0xEBAD, 0xC97E,
	0xEBAE, 0xC9F7,
	0xEBAF, 0xCB49,
	0xEBB0, 0xCB4A,
	0xEBB1, 0xCF6C,
	0xEBB2, 0xB4E3,
	0xEBB3, 0xAEF4,
	0xEBB4, 0xD5DF,
	0xEBB5, 0xBA72,
	0xEBB7, 0xB1D5,
	0xEBB9, 0xC37C,
	0xEBBA, 0xB7DE,
	0xEBBB, 0xBCF8,
	0xEBBC, 0xACB8,
	0xEBBD, 0xE77E,
	0xEBBE, 0xA647,
	0xEBC0, 0xCB78,
	0xEBC1, 0xA877,
	0xEBC3, 0xCCD2,
	0xEBC5, 0xAAD0,
	0xEBC6, 0xAAD2,
	0xEBC7, 0xCDB0,
	0xEBC8, 0xAAD4,
	0xEBCA, 0xC467,
	0xEBCD, 0xC4A4,
	0xEBCE, 0xAD4B,
	0xEBCF, 0xD05B,
	0xEBD0, 0xAB60,
	0xEBD1, 0xD05F,
	0xEBD2, 0xD067,
	0xEBD3, 0xD065,
	0xEBD4, 0xCEFA,
	0xEBD5, 0xAD4F,
	0xEBD6, 0xD748,
	0xEBD7, 0xAFD6,
	0xEBD8, 0xAFDB,
	0xEBD9, 0xAFDA,
	0xEBDA, 0xC17A,
	0xEBDD, 0xAFE2,
	0xEBDE, 0xAED3,
	0xEBE0, 0xB362,
	0xEBE1, 0xDFA2,
	0xEBE2, 0xD74C,
	0xEBE3, 0xD74B,
	0xEBE4, 0xD745,
	0xEBE7, 0xB5CB,
	0xEBE8, 0xB5CC,
	0xEBE9, 0xB5CD,
	0xEBEC, 0xB878,
	0xEBED, 0xDF73,
	0xEBEE, 0xDF76,
	0xEBF0, 0xE3A6,
	0xEBF3, 0xDCE6,
	0xEBF4, 0xDCF9,
	0xEBF5, 0xBB4A,
	0xEBF6, 0xBB4D,
	0xEBF7, 0xC2C1,
	0xEBF8, 0xBCF0,
	0xEBF9, 0xE6FD,
	0xEBFB, 0xEDEA,
	0xEBFC, 0xC261,
	0xEBFD, 0xEDEB,
	0xEBFE, 0xEDE8,
	0xECA2, 0xEAE9,
	0xECA3, 0xC26A,
	0xECA4, 0xD5D8,
	0xECA5, 0xD9DA,
	0xECA6, 0xDDF7,
	0xECA7, 0xDDF5,
	0xECA8, 0xBEF9,
	0xECA9, 0xE4CD,
	0xECAA, 0xBBE3,
	0xECAB, 0xC1FC,
	0xECAC, 0xC442,
	0xECAD, 0xF674,
	0xECB0, 0xDD62,
	0xECB1, 0xC1D4,
	0xECB2, 0xEE7D,
	0xECB3, 0xB4B4,
	0xECB4, 0xF87E,
	0xECB5, 0xC4E3,
	0xECB6, 0xA9F3,
	0xECB7, 0xD1CF,
	0xECB8, 0xD1D1,
	0xECB9, 0xD1D0,
	0xECBA, 0xB1DC,
	0xECBB, 0xB1DD,
	0xECBC, 0xD97E,
	0xECBD, 0xBA59,
	0xECBE, 0xB7D5,
	0xECBF, 0xDE6D,
	0xECC0, 0xBF4C,
	0xECC4, 0xCFAE,
	0xECC5, 0xACAF,
	0xECC6, 0xCFB1,
	0xECC7, 0xEA4D,
	0xECC8, 0xAF4C,
	0xECC9, 0xD651,
	0xECCA, 0xD655,
	0xECCB, 0xBF54,
	0xECCC, 0xDA5A,
	0xECCD, 0xDA5D,
	0xECCF, 0xB7D4,
	0xECD0, 0xB7DB,
	0xECD2, 0xDE73,
	0xECD4, 0xDE74,
	0xECD7, 0xE672,
	0xECD8, 0xE669,
	0xECD9, 0xBCF7,
	0xECDA, 0xE666,
	0xECDB, 0xC0EE,
	0xECDC, 0xEA4F,
	0xECDD, 0xC0E6,
	0xECDE, 0xEFFB,
	0xECDF, 0xF5DA,
	0xECE0, 0xC679,
	0xECE2, 0xC276,
	0xECE3, 0xB7D6,
	0xECE4, 0xBF51,
	0xECE5, 0xA9D1,
	0xECE6, 0xCCB2,
	0xECE7, 0xCED3,
	0xECE8, 0xB1AF,
	0xECE9, 0xB476,
	0xECEB, 0xAAC1,
	0xECEC, 0xACE6,
	0xECED, 0xACE7,
	0xECEE, 0xD7B6,
	0xECEF, 0xD2E9,
	0xECF0, 0xD2EA,
	0xECF1, 0xAFAE,
	0xECF2, 0xEFE4,
	0xECF3, 0xAFAD,
	0xECF4, 0xAFA8,
	0xECF5, 0xBAD5,
	0xECF6, 0xD6BD,
	0xECF7, 0xB852,
	0xECF8, 0xC149,
	0xECF9, 0xE2F9,
	0xECFA, 0xE6CB,
	0xECFB, 0xC148,
	0xECFC, 0xC5A1,
	0xECFD, 0xCAD7,
	0xECFE, 0xCAD8,
	0xEDA1, 0xEFC8,
	0xEDA2, 0xD17C,
	0xEDA3, 0xD17D,
	0xEDA4, 0xD17E,
	0xEDA5, 0xD1A1,
	0xEDA6, 0xAE7E,
	0xEDA7, 0xAEA1,
	0xEDA8, 0xE1C3,
	0xEDA9, 0xB75E,
	0xEDAA, 0xB75D,
	0xEDAB, 0xBC7C,
	0xEDAC, 0xBECD,
	0xEDAD, 0xE976,
	0xEDAE, 0xC0B7,
	0xEDAF, 0xC256,
	0xEDB0, 0xF9BA,
	0xEDB2, 0xA6D6,
	0xEDB3, 0xCCEE,
	0xEDB4, 0xED4F,
	0xEDB5, 0xD9E7,
	0xEDB6, 0xC146,
	0xEDB7, 0xCD7A,
	0xEDB8, 0xE2EE,
	0xEDB9, 0xCFF1,
	0xEDBA, 0xDACF,
	0xEDBC, 0xCFEB,
	0xEDBD, 0xAC48,
	0xEDBE, 0xAFA2,
	0xEDC0, 0xAF7C,
	0xEDC2, 0xC472,
	0xEDC3, 0xF5E2,
	0xEDC4, 0xAFA4,
	0xEDC6, 0xAFA1,
	0xEDC7, 0xD2DA,
	0xEDC8, 0xD2D9,
	0xEDC9, 0xD2E2,
	0xEDCA, 0xB2BA,
	0xEDCB, 0xDAC9,
	0xEDCC, 0xDAC6,
	0xEDCD, 0xEDA6,
	0xEDCE, 0xD6B9,
	0xEDCF, 0xD6BB,
	0xEDD1, 0xD6B8,
	0xEDD3, 0xBF6C,
	0xEDD4, 0xB850,
	0xEDD5, 0xDEE5,
	0xEDD6, 0xDEE4,
	0xEDD7, 0xEAA7,
	0xEDD8, 0xDEEC,
	0xEDD9, 0xBAD4,
	0xEDDA, 0xE2EB,
	0xEDDC, 0xE2F3,
	0xEDDD, 0xE6C6,
	0xEDDF, 0xE6CA,
	0xEDE0, 0xBF6B,
	0xEDE1, 0xEDAA,
	0xEDE2, 0xEDAB,
	0xEDE3, 0xC145,
	0xEDE4, 0xF058,
	0xEDE5, 0xF47D,
	0xEDE6, 0xF2A4,
	0xEDE7, 0xF2A1,
	0xEDE8, 0xF7CE,
	0xEDE9, 0xDCB0,
	0xEDEA, 0xEFB0,
	0xEDEB, 0xF3F5,
	0xEDEC, 0xCD77,
	0xEDED, 0xCFE2,
	0xEDEF, 0xACDA,
	0xEDF0, 0xACE0,
	0xEDF1, 0xCFE0,
	0xEDF2, 0xD2D6,
	0xEDF3, 0xD2D7,
	0xEDF4, 0xD2D5,
	0xEDF5, 0xD6AA,
	0xEDF6, 0xD6B0,
	0xEDF7, 0xD6B2,
	0xEDF8, 0xB2B6,
	0xEDF9, 0xB7FD,
	0xEDFA, 0xC2A5,
	0xEDFB, 0xDABB,
	0xEDFD, 0xDEDD,
	0xEDFE, 0xB845,
	0xEEA1, 0xB846,
	0xEEA2, 0xB844,
	0xEEA3, 0xBACD,
	0xEEA4, 0xE6BC,
	0xEEA5, 0xBACC,
	0xEEA6, 0xE2E7,
	0xEEA7, 0xBD4F,
	0xEEA8, 0xBD50,
	0xEEA9, 0xBF67,
	0xEEAA, 0xBF65,
	0xEEAB, 0xC0FD,
	0xEEAC, 0xED7A,
	0xEEAD, 0xC2A2,
	0xEEAE, 0xCB6D,
	0xEEAF, 0xCD71,
	0xEEB0, 0xACCA,
	0xEEB1, 0xACCB,
	0xEEB2, 0xCFDB,
	0xEEB3, 0xD2C1,
	0xEEB4, 0xDAAE,
	0xEEB5, 0xDEC4,
	0xEEB7, 0xD04D,
	0xEEB8, 0xD35C,
	0xEEB9, 0xAFCB,
	0xEEBA, 0xDBE0,
	0xEEBB, 0xDF6A,
	0xEEBC, 0xF2BC,
	0xEEBE, 0xBFA9,
	0xEEBF, 0xC5F9,
	0xEEC0, 0xEDE3,
	0xEEC1, 0xAF72,
	0xEEC2, 0xBF64,
	0xEEC3, 0xF7F8,
	0xEEC5, 0xD0C1,
	0xEEC6, 0xD0C0,
	0xEEC7, 0xB07A,
	0xEEC8, 0xB078,
	0xEEC9, 0xD442,
	0xEECA, 0xD841,
	0xEECB, 0xB3A9,
	0xEECC, 0xD7FC,
	0xEECD, 0xEBEA,
	0xEECE, 0xB3A6,
	0xEECF, 0xD7FD,
	0xEED1, 0xDC67,
	0xEED2, 0xB964,
	0xEED3, 0xB67A,
	0xEED4, 0xB678,
	0xEED5, 0xDC62,
	0xEED6, 0xDC70,
	0xEED7, 0xDC6F,
	0xEED8, 0xDC64,
	0xEED9, 0xDC6A,
	0xEEDA, 0xE0B1,
	0xEEDB, 0xE0B2,
	0xEEDC, 0xB957,
	0xEEDD, 0xE0B3,
	0xEEDF, 0xB95A,
	0xEEE0, 0xB959,
	0xEEE1, 0xE0B5,
	0xEEE2, 0xE0BB,
	0xEEE3, 0xE0BA,
	0xEEE4, 0xB966,
	0xEEE5, 0xC5E0,
	0xEEE6, 0xE0B0,
	0xEEE7, 0xB962,
	0xEEE8, 0xE0AE,
	0xEEE9, 0xB963,
	0xEEEA, 0xE0B7,
	0xEEEB, 0xB965,
	0xEEEC, 0xC54D,
	0xEEED, 0xBE52,
	0xEEEE, 0xE47B,
	0xEEEF, 0xE47A,
	0xEEF0, 0xE47D,
	0xEEF1, 0xE4A8,
	0xEEF2, 0xE868,
	0xEEF3, 0xC4C2,
	0xEEF5, 0xC54C,
	0xEEF7, 0xE4A1,
	0xEEF8, 0xF15A,
	0xEEF9, 0xBBCB,
	0xEEFA, 0xE86F,
	0xEEFB, 0xE4B7,
	0xEEFC, 0xF4F3,
	0xEEFD, 0xBBCD,
	0xEEFE, 0xE4A6,
	0xEFA1, 0xF36A,
	0xEFA2, 0xE4A2,
	0xEFA3, 0xBFFE,
	0xEFA4, 0xE4A3,
	0xEFA5, 0xE0B6,
	0xEFA6, 0xF4E7,
	0xEFA7, 0xBBCF,
	0xEFA8, 0xE4A7,
	0xEFA9, 0xF4F9,
	0xEFAA, 0xEBE4,
	0xEFAB, 0xE869,
	0xEFAC, 0xC3F4,
	0xEFAE, 0xBE59,
	0xEFAF, 0xE870,
	0xEFB0, 0xE872,
	0xEFB1, 0xBE56,
	0xEFB2, 0xE86E,
	0xEFB6, 0xE863,
	0xEFB7, 0xE86A,
	0xEFB8, 0xE876,
	0xEFB9, 0xEBE8,
	0xEFBA, 0xEBE1,
	0xEFBC, 0xEBE6,
	0xEFBE, 0xEBE9,
	0xEFBF, 0xC043,
	0xEFC0, 0xC044,
	0xEFC3, 0xEBDF,
	0xEFC4, 0xEBE0,
	0xEFC5, 0xC045,
	0xEFC6, 0xC1E6,
	0xEFC7, 0xEED2,
	0xEFC8, 0xEED6,
	0xEFC9, 0xC1EE,
	0xEFCA, 0xEED0,
	0xEFCB, 0xF15C,
	0xEFCC, 0xC1EC,
	0xEFCE, 0xC3F3,
	0xEFCF, 0xC3F2,
	0xEFD2, 0xF368,
	0xEFD3, 0xC2F0,
	0xEFD4, 0xC54F,
	0xEFD6, 0xF15E,
	0xEFD7, 0xC2EF,
	0xEFD8, 0xF153,
	0xEFD9, 0xF767,
	0xEFDA, 0xC3F0,
	0xEFDB, 0xC3ED,
	0xEFDC, 0xC3EE,
	0xEFDD, 0xC3F1,
	0xEFDE, 0xF360,
	0xEFDF, 0xC3EB,
	0xEFE0, 0xF361,
	0xEFE1, 0xC3E9,
	0xEFE2, 0xF4EC,
	0xEFE4, 0xF4F5,
	0xEFE6, 0xF4E8,
	0xEFE7, 0xF953,
	0xEFE8, 0xF4EA,
	0xEFEA, 0xF366,
	0xEFEB, 0xF4F1,
	0xEFEC, 0xF769,
	0xEFED, 0xC54E,
	0xEFEE, 0xF65E,
	0xEFF0, 0xC5DF,
	0xEFF1, 0xC1E9,
	0xEFF2, 0xCFE8,
	0xEFF3, 0xDAC4,
	0xEFF4, 0xB96E,
	0xEFF5, 0xCFF9,
	0xEFF6, 0xD2F1,
	0xEFF7, 0xAFB0,
	0xEFF8, 0xD2ED,
	0xEFFA, 0xB452,
	0xEFFB, 0xDAD8,
	0xEFFC, 0xDAD6,
	0xEFFD, 0xB85C,
	0xEFFE, 0xB85A,
	0xF0A1, 0xE6D2,
	0xF0A2, 0xBD5E,
	0xF0A3, 0xC2A8,
	0xF0A4, 0xC248,
	0xF0A5, 0xC34C,
	0xF0A6, 0xF6F8,
	0xF0A7, 0xACD4,
	0xF0A8, 0xB2AE,
	0xF0A9, 0xB571,
	0xF0AA, 0xDED5,
	0xF0AB, 0xED78,
	0xF0AC, 0xD2BC,
	0xF0AD, 0xB27D,
	0xF0AE, 0xA869,
	0xF0AF, 0xB9A7,
	0xF0B0, 0xBBF0,
	0xF0B1, 0xE8E9,
	0xF0B2, 0xBE7D,
	0xF0B3, 0xC06C,
	0xF0B4, 0xF3F0,
	0xF0B5, 0xF9B7,
	0xF0B6, 0xECA9,
	0xF0B7, 0xECAE,
	0xF0B8, 0xC5EE,
	0xF0B9, 0xEF7B,
	0xF0BA, 0xF7C1,
	0xF0BB, 0xEF7E,
	0xF0BC, 0xEFA2,
	0xF0BD, 0xC67D,
	0xF0BE, 0xF1D0,
	0xF0BF, 0xF9CF,
	0xF0C0, 0xC35B,
	0xF0C1, 0xF1D9,
	0xF0C2, 0xF870,
	0xF0C3, 0xF1CF,
	0xF0C4, 0xC44D,
	0xF0C6, 0xC44F,
	0xF0C7, 0xF3ED,
	0xF0C8, 0xC44C,
	0xF0C9, 0xF57C,
	0xF0CA, 0xF5A7,
	0xF0CD, 0xF5AD,
	0xF0CE, 0xC563,
	0xF0CF, 0xF6B4,
	0xF0D0, 0xC678,
	0xF0D1, 0xC5C2,
	0xF0D2, 0xF7BA,
	0xF0D3, 0xF863,
	0xF0D4, 0xF86B,
	0xF0D5, 0xF86C,
	0xF0D6, 0xF866,
	0xF0D8, 0xC64F,
	0xF0D9, 0xC67C,
	0xF0DB, 0xCB6F,
	0xF0DC, 0xF04B,
	0xF0DD, 0xC27E,
	0xF0DE, 0xAAB7,
	0xF0E0, 0xACD0,
	0xF0E1, 0xAF69,
	0xF0E2, 0xDECB,
	0xF0E3, 0xAF6E,
	0xF0E5, 0xAF70,
	0xF0E6, 0xD2C3,
	0xF0E8, 0xAF6D,
	0xF0EA, 0xB2AD,
	0xF0EB, 0xB569,
	0xF0EC, 0xC0F7,
	0xF0ED, 0xDAB2,
	0xF0EE, 0xDAB5,
	0xF0EF, 0xED77,
	0xF0F0, 0xDAAF,
	0xF0F1, 0xDEC9,
	0xF0F2, 0xB7F3,
	0xF0F3, 0xDECC,
	0xF0F4, 0xB7F5,
	0xF0F5, 0xDECF,
	0xF0F6, 0xB7EF,
	0xF0F7, 0xED76,
	0xF0F8, 0xE2DC,
	0xF0F9, 0xE6B0,
	0xF0FA, 0xE2DF,
	0xF0FB, 0xE6AF,
	0xF0FD, 0xE2DD,
	0xF0FE, 0xE6B1,
	0xF1A2, 0xEA70,
	0xF1A3, 0xBD49,
	0xF1A4, 0xBD43,
	0xF1A6, 0xEA6C,
	0xF1A7, 0xEA73,
	0xF1A8, 0xF6F4,
	0xF1A9, 0xEA71,
	0xF1AA, 0xED74,
	0xF1AB, 0xC57D,
	0xF1AC, 0xEA6F,
	0xF1AE, 0xC4EE,
	0xF1B0, 0xF04A,
	0xF1B1, 0xC27D,
	0xF1B2, 0xC5F6,
	0xF1B4, 0xD6F6,
	0xF1B5, 0xDADC,
	0xF1B6, 0xCDA5,
	0xF1B7, 0xAAC6,
	0xF1B8, 0xCFFE,
	0xF1B9, 0xD2F6,
	0xF1BA, 0xAFB7,
	0xF1BB, 0xB2C0,
	0xF1BC, 0xC475,
	0xF1BD, 0xB85E,
	0xF1BE, 0xE34C,
	0xF1BF, 0xE34A,
	0xF1C0, 0xEAB2,
	0xF1C1, 0xE6D5,
	0xF1C3, 0xD0AE,
	0xF1C4, 0xD3D4,
	0xF1C5, 0xB04D,
	0xF1C6, 0xD3D7,
	0xF1C7, 0xB04C,
	0xF1C8, 0xD7B5,
	0xF1C9, 0xC3CB,
	0xF1CA, 0xDBCB,
	0xF1CB, 0xDBCA,
	0xF1CC, 0xDBCF,
	0xF1CD, 0xEE72,
	0xF1CE, 0xDFF4,
	0xF1CF, 0xF2F0,
	0xF1D0, 0xF0D9,
	0xF1D1, 0xE3F7,
	0xF1D2, 0xBB75,
	0xF1D3, 0xE3FC,
	0xF1D4, 0xBB74,
	0xF1D5, 0xE3FA,
	0xF1D6, 0xE440,
	0xF1D7, 0xBFCA,
	0xF1D8, 0xE7C8,
	0xF1D9, 0xBDC8,
	0xF1DA, 0xC1B9,
	0xF1DB, 0xBDCA,
	0xF1DC, 0xC4B0,
	0xF1DD, 0xBFC9,
	0xF1DE, 0xC1B7,
	0xF1DF, 0xEE75,
	0xF1E0, 0xF4CB,
	0xF1E1, 0xF94B,
	0xF1E2, 0xA5D4,
	0xF1E3, 0xAD45,
	0xF1E4, 0xE2E1,
	0xF1E5, 0xB572,
	0xF1E6, 0xACE1,
	0xF1E7, 0xA6D4,
	0xF1E8, 0xD054,
	0xF1E9, 0xD366,
	0xF1EA, 0xB2E0,
	0xF1EE, 0xBDA2,
	0xF1EF, 0xEDE7,
	0xF1F0, 0xEAE6,
	0xF1F1, 0xBFAE,
	0xF1F3, 0xB5C0,
	0xF1F4, 0xCDAA,
	0xF1F5, 0xD743,
	0xF1F6, 0xB2E2,
	0xF1F7, 0xF4B2,
	0xF1F8, 0xB5C1,
	0xF1F9, 0xF07C,
	0xF1FA, 0xC16D,
	0xF1FB, 0xB5F7,
	0xF1FC, 0xDCAC,
	0xF1FD, 0xE0E0,
	0xF1FE, 0xE0DE,
	0xF2A1, 0xBE65,
	0xF2A2, 0xBE67,
	0xF2A3, 0xBF6F,
	0xF2A4, 0xE8B8,
	0xF2A5, 0xC058,
	0xF2A6, 0xC345,
	0xF2A7, 0xC346,
	0xF2A8, 0xF9AE,
	0xF2A9, 0xF54F,
	0xF2AA, 0xF3A8,
	0xF2AB, 0xC556,
	0xF2AD, 0xC649,
	0xF2AF, 0xB040,
	0xF2B0, 0xCDC8,
	0xF2B1, 0xF0CA,
	0xF2B2, 0xF2E3,
	0xF2B3, 0xAD6B,
	0xF2B4, 0xD0A8,
	0xF2B5, 0xAD6A,
	0xF2B6, 0xD3BA,
	0xF2B7, 0xD3BC,
	0xF2B8, 0xD3C2,
	0xF2B9, 0xB8C3,
	0xF2BA, 0xC4AE,
	0xF2BB, 0xD3C8,
	0xF2BC, 0xB047,
	0xF2BD, 0xB042,
	0xF2BE, 0xB043,
	0xF2BF, 0xB045,
	0xF2C0, 0xB346,
	0xF2C1, 0xB347,
	0xF2C2, 0xB348,
	0xF2C3, 0xC4F7,
	0xF2C4, 0xD7A5,
	0xF2C5, 0xD7A4,
	0xF2C6, 0xB34B,
	0xF2C7, 0xB34C,
	0xF2C8, 0xB34D,
	0xF2C9, 0xF2DE,
	0xF2CA, 0xD7AB,
	0xF2CB, 0xDBBC,
	0xF2CC, 0xDFE6,
	0xF2CD, 0xC2CC,
	0xF2CE, 0xB5ED,
	0xF2CF, 0xEB6B,
	0xF2D0, 0xB5F1,
	0xF2D1, 0xB8BB,
	0xF2D2, 0xB5F2,
	0xF2D3, 0xF4C5,
	0xF2D4, 0xB5EB,
	0xF2D5, 0xDBB1,
	0xF2D6, 0xDBBF,
	0xF2D7, 0xB8C2,
	0xF2D8, 0xB8BD,
	0xF2D9, 0xDFEA,
	0xF2DA, 0xB8BC,
	0xF2DB, 0xB8C4,
	0xF2DC, 0xDFEF,
	0xF2DD, 0xDFEC,
	0xF2DE, 0xE3D6,
	0xF2DF, 0xBB66,
	0xF2E0, 0xE3DB,
	0xF2E1, 0xBB68,
	0xF2E2, 0xE3DA,
	0xF2E3, 0xE3F2,
	0xF2E4, 0xE3E2,
	0xF2E5, 0xC1B4,
	0xF2E6, 0xBB69,
	0xF2E7, 0xE3EB,
	0xF2E8, 0xBB6D,
	0xF2E9, 0xBB6C,
	0xF2EA, 0xBB64,
	0xF2EB, 0xBDB8,
	0xF2EC, 0xBB67,
	0xF2EE, 0xF4C6,
	0xF2EF, 0xE7BC,
	0xF2F0, 0xBDBB,
	0xF2F2, 0xBDC1,
	0xF2F3, 0xE7B8,
	0xF2F5, 0xBDC2,
	0xF2F6, 0xE7A2,
	0xF2F7, 0xC1B2,
	0xF2F8, 0xE7A3,
	0xF2F9, 0xBDBF,
	0xF2FA, 0xE7BA,
	0xF2FB, 0xEB5E,
	0xF2FC, 0xEE67,
	0xF2FE, 0xC1AF,
	0xF3A1, 0xC1B0,
	0xF3A2, 0xEB60,
	0xF3A3, 0xEB67,
	0xF3A4, 0xEE5A,
	0xF3A5, 0xEB5D,
	0xF3A6, 0xBFC0,
	0xF3A7, 0xC1B1,
	0xF3A8, 0xF0C1,
	0xF3A9, 0xEE5D,
	0xF3AA, 0xEE5F,
	0xF3AB, 0xC1AE,
	0xF3AC, 0xC1B5,
	0xF3AD, 0xF0C7,
	0xF3AE, 0xEE6E,
	0xF3AF, 0xC1AD,
	0xF3B0, 0xC1AC,
	0xF3B1, 0xEE69,
	0xF3B2, 0xF0BE,
	0xF3B3, 0xF0C0,
	0xF3B4, 0xC2CF,
	0xF3B6, 0xF4C9,
	0xF3B7, 0xF4C8,
	0xF3B8, 0xC3CA,
	0xF3B9, 0xF2E7,
	0xF3BA, 0xF642,
	0xF3BB, 0xC4F9,
	0xF3BC, 0xC5FB,
	0xF3BD, 0xF8BE,
	0xF3BE, 0xA6CE,
	0xF3BF, 0xC4A2,
	0xF3C0, 0xC16A,
	0xF3C1, 0xEDE1,
	0xF3C2, 0xAFE7,
	0xF3C3, 0xAAC7,
	0xF3C4, 0xACF2,
	0xF3C5, 0xD344,
	0xF3C6, 0xBF77,
	0xF3C7, 0xD340,
	0xF3C8, 0xB863,
	0xF3C9, 0xD345,
	0xF3CA, 0xD6D7,
	0xF3CB, 0xD343,
	0xF3CC, 0xD6CC,
	0xF3CD, 0xD6DB,
	0xF3CE, 0xD6D4,
	0xF3CF, 0xB2C6,
	0xF3D0, 0xB2C8,
	0xF3D1, 0xD6D6,
	0xF3D2, 0xB2C1,
	0xF3D3, 0xD6CE,
	0xF3D4, 0xD6D1,
	0xF3D5, 0xD6D2,
	0xF3D6, 0xF8FB,
	0xF3D7, 0xB2C7,
	0xF3D8, 0xDAE5,
	0xF3D9, 0xEDC3,
	0xF3DA, 0xDAE6,
	0xF3DB, 0xBAE1,
	0xF3DC, 0xDAE2,
	0xF3DD, 0xBAE5,
	0xF3DE, 0xB861,
	0xF3DF, 0xB862,
	0xF3E2, 0xDF4B,
	0xF3E3, 0xDF4E,
	0xF3E4, 0xE352,
	0xF3E5, 0xEDBD,
	0xF3E6, 0xE6D7,
	0xF3E7, 0xBAE6,
	0xF3E8, 0xE6D9,
	0xF3E9, 0xBAE3,
	0xF3EA, 0xF6FB,
	0xF3EB, 0xE358,
	0xF3EC, 0xC2B0,
	0xF3ED, 0xE34F,
	0xF3EF, 0xC2AD,
	0xF3F0, 0xBD65,
	0xF3F1, 0xC2B1,
	0xF3F2, 0xBD68,
	0xF3F3, 0xBD6A,
	0xF3F4, 0xEABA,
	0xF3F5, 0xEABD,
	0xF3F6, 0xEABC,
	0xF3F7, 0xBF7B,
	0xF3F8, 0xEAC1,
	0xF3F9, 0xC150,
	0xF3FA, 0xC14E,
	0xF3FC, 0xEDBB,
	0xF3FD, 0xF8B8,
	0xF3FE, 0xEDC2,
	0xF4A1, 0xF065,
	0xF4A2, 0xC2AF,
	0xF4A3, 0xF068,
	0xF4A4, 0xC3B0,
	0xF4A5, 0xC5A3,
	0xF4A6, 0xC3B3,
	0xF4A7, 0xAAD8,
	0xF4A8, 0xD370,
	0xF4A9, 0xB2EA,
	0xF4AA, 0xBCF3,
	0xF4AB, 0xAFE5,
	0xF4AC, 0xD3D0,
	0xF4AD, 0xD069,
	0xF4AE, 0xAD51,
	0xF4AF, 0xF2C3,
	0xF4B1, 0xD371,
	0xF4B2, 0xAFEA,
	0xF4B3, 0xAFE9,
	0xF4B4, 0xD753,
	0xF4B5, 0xF746,
	0xF4B6, 0xD754,
	0xF4B7, 0xD756,
	0xF4B9, 0xDFA5,
	0xF4BA, 0xDFA4,
	0xF4BB, 0xBB53,
	0xF4BC, 0xE746,
	0xF4BD, 0xEDF1,
	0xF4BE, 0xF0A2,
	0xF4BF, 0xF4B6,
	0xF4C0, 0xD3DA,
	0xF4C1, 0xB8CD,
	0xF4C2, 0xB350,
	0xF4C3, 0xB8CA,
	0xF4C4, 0xB8C6,
	0xF4C5, 0xC3CE,
	0xF4C6, 0xD6F4,
	0xF4C7, 0xDF6D,
	0xF4C8, 0xDF6E,
	0xF4C9, 0xBD7E,
	0xF4CA, 0xE6F3,
	0xF4CB, 0xBFAA,
	0xF4CC, 0xAAC4,
	0xF4CD, 0xAEC5,
	0xF4CE, 0xD34A,
	0xF4D1, 0xDAE8,
	0xF4D2, 0xDAE7,
	0xF4D3, 0xDF54,
	0xF4D4, 0xE360,
	0xF4D5, 0xBAEA,
	0xF4D6, 0xC158,
	0xF4D8, 0xE6E1,
	0xF4DA, 0xE6E0,
	0xF4DB, 0xE6DF,
	0xF4DC, 0xEAC9,
	0xF4DD, 0xEDCF,
	0xF4DE, 0xA6E1,
	0xF4DF, 0xBA5B,
	0xF4E0, 0xACFD,
	0xF4E1, 0xB2DE,
	0xF4E2, 0xB5BF,
	0xF4E3, 0xE37D,
	0xF4E4, 0xBB42,
	0xF4E5, 0xE6F9,
	0xF4E6, 0xBDA1,
	0xF4E7, 0xBFAD,
	0xF4E8, 0xC16B,
	0xF4E9, 0xA6CD,
	0xF4EA, 0xEDDE,
	0xF4EB, 0xE375,
	0xF4EC, 0xE376,
	0xF4ED, 0xEDD9,
	0xF4EE, 0xF941,
	0xF4EF, 0xBEA2,
	0xF4F0, 0xC454,
	0xF4F1, 0xAD76,
	0xF4F2, 0xDBED,
	0xF4F3, 0xE064,
	0xF4F4, 0xE05E,
	0xF4F5, 0xF96F,
	0xF4F6, 0xB369,
	0xF4F7, 0xBDEA,
	0xF4F8, 0xD3DE,
	0xF4F9, 0xB361,
	0xF4FA, 0xADAA,
	0xF4FB, 0xD3FE,
	0xF4FC, 0xD440,
	0xF4FD, 0xD441,
	0xF4FE, 0xDC5E,
	0xF5A1, 0xDC60,
	0xF5A2, 0xDC5D,
	0xF5A4, 0xB955,
	0xF5A5, 0xE0AD,
	0xF5A6, 0xC66F,
	0xF5A7, 0xF971,
	0xF5A8, 0xE473,
	0xF5A9, 0xBBC6,
	0xF5AA, 0xE474,
	0xF5AC, 0xE85B,
	0xF5AD, 0xEBD9,
	0xF5AE, 0xEBDB,
	0xF5AF, 0xEBDA,
	0xF5B0, 0xEEC6,
	0xF5B1, 0xC1DE,
	0xF5B2, 0xF152,
	0xF5B3, 0xF35F,
	0xF5B4, 0xC3E7,
	0xF5B5, 0xF151,
	0xF5B6, 0xF4E4,
	0xF5B7, 0xC4BF,
	0xF5B8, 0xC548,
	0xF5B9, 0xA8A8,
	0xF5BA, 0xF6C9,
	0xF5BB, 0xC4BB,
	0xF5BC, 0xE072,
	0xF5BD, 0xE460,
	0xF5BE, 0xC2D9,
	0xF5BF, 0xF144,
	0xF5C0, 0xD3E5,
	0xF5C1, 0xD7D9,
	0xF5C2, 0xD7D6,
	0xF5C3, 0xB36C,
	0xF5C4, 0xEEBE,
	0xF5C5, 0xDBF4,
	0xF5C6, 0xDBFA,
	0xF5C7, 0xB65C,
	0xF5C8, 0xF760,
	0xF5C9, 0xB659,
	0xF5CA, 0xDBF6,
	0xF5CB, 0xB65F,
	0xF5CC, 0xB660,
	0xF5CD, 0xE069,
	0xF5CE, 0xC3DF,
	0xF5CF, 0xC2DE,
	0xF5D0, 0xE06E,
	0xF5D1, 0xF75F,
	0xF5D2, 0xC545,
	0xF5D3, 0xB8F8,
	0xF5D4, 0xE457,
	0xF5D5, 0xE45B,
	0xF5D6, 0xE840,
	0xF5D7, 0xBDEF,
	0xF5D8, 0xBDF3,
	0xF5D9, 0xC5AE,
	0xF5DA, 0xE7F7,
	0xF5DB, 0xE7F4,
	0xF5DC, 0xC5AD,
	0xF5DE, 0xEBC0,
	0xF5E0, 0xBFE6,
	0xF5E1, 0xEBC4,
	0xF5E2, 0xBFE2,
	0xF5E3, 0xC1CE,
	0xF5E4, 0xEBC5,
	0xF5E5, 0xBFE4,
	0xF5E6, 0xC65C,
	0xF5E7, 0xC2DA,
	0xF5E8, 0xC1D1,
	0xF5E9, 0xF75D,
	0xF5EA, 0xC3DD,
	0xF5EB, 0xC3DA,
	0xF5EC, 0xF353,
	0xF5ED, 0xC3E0,
	0xF5EE, 0xC4BD,
	0xF5EF, 0xC66E,
	0xF5F0, 0xF75E,
	0xF5F1, 0xF761,
	0xF5F2, 0xF970,
	0xF5F3, 0xF8C3,
	0xF5F4, 0xCBA4,
	0xF5F5, 0xB649,
	0xF5F6, 0xB8E7,
	0xF5F7, 0xE05A,
	0xF5F8, 0xF0F1,
	0xF5F9, 0xEEB7,
	0xF5FA, 0xB1D8,
	0xF5FB, 0xD7C6,
	0xF5FC, 0xC2D2,
	0xF5FD, 0xDBD4,
	0xF5FE, 0xE043,
	0xF6A1, 0xDFFD,
	0xF6A2, 0xE448,
	0xF6A3, 0xF2F5,
	0xF6A4, 0xB8E4,
	0xF6A5, 0xF0E7,
	0xF6A6, 0xE8B0,
	0xF6A7, 0xB3B8,
	0xF6A8, 0xC645,
	0xF6A9, 0xB6B2,
	0xF6AA, 0xBE5E,
	0xF6AB, 0xC5B4,
	0xF6AC, 0xE8AE,
	0xF6AD, 0xC050,
	0xF6AE, 0xC04B,
	0xF6AF, 0xC3F9,
	0xF6B0, 0xC647,
	0xF6B1, 0xC4C5,
	0xF6B2, 0xC5B5,
	0xF6B3, 0xEFB5,
	0xF6B4, 0xC4D4,
	0xF6B5, 0xF5BE,
	0xF6B6, 0xF5BB,
	0xF6B7, 0xC568,
	0xF6B8, 0xC569,
	0xF6B9, 0xC5C5,
	0xF6BA, 0xC5C6,
	0xF6BB, 0xC653,
	0xF6BC, 0xE0EF,
	0xF6BD, 0xEFB1,
	0xF6BE, 0xF965,
	0xF6BF, 0xAB41,
	0xF6C0, 0xD447,
	0xF6C1, 0xB96D,
	0xF6C2, 0xE0D5,
	0xF6C3, 0xBBDC,
	0xF6C4, 0xC2A3,
	0xF6C5, 0xF841,
	0xF6C6, 0xE4A9,
	0xF6C7, 0xC671,
	0xF6C8, 0xE874,
	0xF6C9, 0xC3F5,
	0xF6CA, 0xEEDE,
	0xF6CB, 0xF36C,
	0xF6CC, 0xEEDC,
	0xF6CE, 0xF8CA,
	0xF6CF, 0xBE7B,
	0xF6D0, 0xE8DB,
	0xF6D1, 0xF85B,
	0xF6D4, 0xC674,
	0xF6D5, 0xBF71,
	0xF6D6, 0xEC7B,
	0xF6D7, 0xC64D,
	0xF6D8, 0xEC7C,
	0xF6D9, 0xC244,
	0xF6DA, 0xEF6A,
	0xF6DB, 0xC243,
	0xF6DC, 0xEF6C,
	0xF6DD, 0xF95C,
	0xF6DE, 0xC242,
	0xF6DF, 0xF3D0,
	0xF6E0, 0xF858,
	0xF6E1, 0xF1C7,
	0xF6E2, 0xF9CE,
	0xF6E3, 0xC5BF,
	0xF6E4, 0xF7AE,
	0xF6E5, 0xF6AD,
	0xF6E6, 0xF7B2,
	0xF6E7, 0xC358,
	0xF6E8, 0xC354,
	0xF6E9, 0xF1C3,
	0xF6EA, 0xC356,
	0xF6EB, 0xC44A,
	0xF6EC, 0xF3C7,
	0xF6ED, 0xF3C8,
	0xF6EE, 0xF3D6,
	0xF6EF, 0xF3CB,
	0xF6F0, 0xC449,
	0xF6F2, 0xF3CD,
	0xF6F3, 0xF3CE,
	0xF6F4, 0xC44B,
	0xF6F6, 0xF3CF,
	0xF6F8, 0xF56B,
	0xF6F9, 0xC673,
	0xF6FA, 0xC4CF,
	0xF6FB, 0xF56E,
	0xF6FC, 0xF576,
	0xF7A1, 0xF7B4,
	0xF7A2, 0xC55F,
	0xF7A3, 0xF6AE,
	0xF7A4, 0xC560,
	0xF7A5, 0xF6AF,
	0xF7A6, 0xF7AF,
	0xF7A7, 0xC5C0,
	0xF7A8, 0xF7AB,
	0xF7A9, 0xC5C1,
	0xF7AC, 0xC5ED,
	0xF7AD, 0xC5EB,
	0xF7AE, 0xF857,
	0xF7AF, 0xF8D7,
	0xF7B0, 0xBBDE,
	0xF7B1, 0xBBDF,
	0xF7B2, 0xC5B6,
	0xF7B4, 0xEC56,
	0xF7B5, 0xC669,
	0xF7B6, 0xF17C,
	0xF7B7, 0xC2FD,
	0xF7BA, 0xE4DA,
	0xF7BB, 0xBBEB,
	0xF7BC, 0xBE75,
	0xF7BD, 0xF6BC,
	0xF7C0, 0xC066,
	0xF7C1, 0xC34E,
	0xF7C2, 0xF1B9,
	0xF7C3, 0xC55C,
	0xF7C4, 0xF3C1,
	0xF7C5, 0xC662,
	0xF7C6, 0xF8D4,
	0xF7C7, 0xC5EA,
	0xF7C8, 0xBE79,
	0xF7C9, 0xE8D9,
	0xF7CA, 0xC64C,
	0xF7CB, 0xC352,
	0xF7CC, 0xEF69,
	0xF7CD, 0xC353,
	0xF7CE, 0xC55E,
	0xF7CF, 0xC557,
	0xF7D0, 0xC5E4,
	0xF7D1, 0xC34B,
	0xF7D2, 0xC5B9,
	0xF7D3, 0xF776,
	0xF7D4, 0xD449,
	0xF7D5, 0xB9A6,
	0xF7D6, 0xBBEC,
	0xF7D7, 0xBE77,
	0xF7D8, 0xE8D4,
	0xF7D9, 0xC067,
	0xF7DA, 0xC068,
	0xF7DB, 0xEC70,
	0xF7DC, 0xF1BB,
	0xF7DE, 0xC64B,
	0xF7DF, 0xF855,
	0xF7E0, 0xC663,
	0xF7E1, 0xBBF2,
	0xF7E2, 0xBEA3,
	0xF7E3, 0xEDDD,
	0xF7E4, 0xB9A8,
	0xF7E5, 0xECB1,
	0xF7E6, 0xECAF,
	0xF7E7, 0xC247,
	0xF7E8, 0xC451,
	0xF7E9, 0xC3EF,
	0xF7EA, 0xC565,
	0xF7EB, 0xC5EF,
	0xF7EC, 0xC24C,
	0xF7ED, 0xC24A,
	0xF7EE, 0xC24B,
	0xF7EF, 0xC35C,
	0xF7F0, 0xF1E0,
	0xF7F2, 0xC675,
	0xF7F3, 0xF5B6,
	0xF7F4, 0xF5B4,
	0xF7F5, 0xF876,
	0xF7F6, 0xC566,
	0xF7F7, 0xEFB4,
	0xF7F8, 0xC35E,
	0xF7F9, 0xC4D3,
	0xF7FA, 0xC5C4,
	0xF7FB, 0xF87B,
	0xF7FC, 0xECB8,
	0xF7FD, 0xC24D
};

#endif
