/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 *  ICU License - ICU 1.8.1 and later
 *
 *  COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1995-2005 International Business Machines Corporation and others
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 * --------------------------------------------------------------------------
 * All trademarks and registered trademarks mentioned herein are the property
 * of their respective owners.
 */

/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 * All rights reserved.
 */


#ifndef	_CP937_TO_UCS2_H_
#define	_CP937_TO_UCS2_H_


/* maxium mapping number from IBM Cp937 to UCS */
#define MAX_UCS_NUM             20395


lookup_table    cp937_ucs2_tab[MAX_UCS_NUM] = {
        { 0x0000, 0x0000 },
        { 0x0001, 0x0001 },
        { 0x0002, 0x0002 },
        { 0x0003, 0x0003 },
        { 0x0009, 0x0005 },
        { 0x007F, 0x0007 },
        { 0x000B, 0x000B },
        { 0x000C, 0x000C },
        { 0x000D, 0x000D },
        { 0x000E, 0x000E },
        { 0x000F, 0x000F },
        { 0x0010, 0x0010 },
        { 0x0011, 0x0011 },
        { 0x0012, 0x0012 },
        { 0x0013, 0x0013 },
        { 0x0008, 0x0016 },
        { 0x0018, 0x0018 },
        { 0x0019, 0x0019 },
        { 0x001C, 0x001C },
        { 0x001D, 0x001D },
        { 0x001E, 0x001E },
        { 0x001F, 0x001F },
        { 0x000A, 0x0025 },
        { 0x0017, 0x0026 },
        { 0x001B, 0x0027 },
        { 0x0005, 0x002D },
        { 0x0006, 0x002E },
        { 0x0007, 0x002F },
        { 0x0016, 0x0032 },
        { 0x0004, 0x0037 },
        { 0x0014, 0x003C },
        { 0x0015, 0x003D },
        { 0x001A, 0x003F },
        { 0x0020, 0x0040 },
        { 0x00A2, 0x004A },
        { 0x002E, 0x004B },
        { 0x003C, 0x004C },
        { 0x0028, 0x004D },
        { 0x002B, 0x004E },
        { 0x007C, 0x004F },
        { 0x0026, 0x0050 },
        { 0x0021, 0x005A },
        { 0x0024, 0x005B },
        { 0x002A, 0x005C },
        { 0x0029, 0x005D },
        { 0x003B, 0x005E },
        { 0x00AC, 0x005F },
        { 0x002D, 0x0060 },
        { 0x002F, 0x0061 },
        { 0x00A6, 0x006A },
        { 0x002C, 0x006B },
        { 0x0025, 0x006C },
        { 0x005F, 0x006D },
        { 0x003E, 0x006E },
        { 0x003F, 0x006F },
        { 0x0060, 0x0079 },
        { 0x003A, 0x007A },
        { 0x0023, 0x007B },
        { 0x0040, 0x007C },
        { 0x0027, 0x007D },
        { 0x003D, 0x007E },
        { 0x0022, 0x007F },
        { 0x0061, 0x0081 },
        { 0x0062, 0x0082 },
        { 0x0063, 0x0083 },
        { 0x0064, 0x0084 },
        { 0x0065, 0x0085 },
        { 0x0066, 0x0086 },
        { 0x0067, 0x0087 },
        { 0x0068, 0x0088 },
        { 0x0069, 0x0089 },
        { 0x006A, 0x0091 },
        { 0x006B, 0x0092 },
        { 0x006C, 0x0093 },
        { 0x006D, 0x0094 },
        { 0x006E, 0x0095 },
        { 0x006F, 0x0096 },
        { 0x0070, 0x0097 },
        { 0x0071, 0x0098 },
        { 0x0072, 0x0099 },
        { 0x007E, 0x00A1 },
        { 0x0073, 0x00A2 },
        { 0x0074, 0x00A3 },
        { 0x0075, 0x00A4 },
        { 0x0076, 0x00A5 },
        { 0x0077, 0x00A6 },
        { 0x0078, 0x00A7 },
        { 0x0079, 0x00A8 },
        { 0x007A, 0x00A9 },
        { 0x005E, 0x00B0 },
        { 0x005B, 0x00BA },
        { 0x005D, 0x00BB },
        { 0x007B, 0x00C0 },
        { 0x0041, 0x00C1 },
        { 0x0042, 0x00C2 },
        { 0x0043, 0x00C3 },
        { 0x0044, 0x00C4 },
        { 0x0045, 0x00C5 },
        { 0x0046, 0x00C6 },
        { 0x0047, 0x00C7 },
        { 0x0048, 0x00C8 },
        { 0x0049, 0x00C9 },
        { 0x007D, 0x00D0 },
        { 0x004A, 0x00D1 },
        { 0x004B, 0x00D2 },
        { 0x004C, 0x00D3 },
        { 0x004D, 0x00D4 },
        { 0x004E, 0x00D5 },
        { 0x004F, 0x00D6 },
        { 0x0050, 0x00D7 },
        { 0x0051, 0x00D8 },
        { 0x0052, 0x00D9 },
        { 0x005C, 0x00E0 },
        { 0x0053, 0x00E2 },
        { 0x0054, 0x00E3 },
        { 0x0055, 0x00E4 },
        { 0x0056, 0x00E5 },
        { 0x0057, 0x00E6 },
        { 0x0058, 0x00E7 },
        { 0x0059, 0x00E8 },
        { 0x005A, 0x00E9 },
        { 0x0030, 0x00F0 },
        { 0x0031, 0x00F1 },
        { 0x0032, 0x00F2 },
        { 0x0033, 0x00F3 },
        { 0x0034, 0x00F4 },
        { 0x0035, 0x00F5 },
        { 0x0036, 0x00F6 },
        { 0x0037, 0x00F7 },
        { 0x0038, 0x00F8 },
        { 0x0039, 0x00F9 },
        { 0x3000, 0x4040 },
        { 0x03B1, 0x4141 },
        { 0x03B2, 0x4142 },
        { 0x03B3, 0x4143 },
        { 0x03B4, 0x4144 },
        { 0x03B5, 0x4145 },
        { 0x03B6, 0x4146 },
        { 0x03B7, 0x4147 },
        { 0x03B8, 0x4148 },
        { 0x03B9, 0x4149 },
        { 0x03BA, 0x414A },
        { 0x03BB, 0x414B },
        { 0x03BC, 0x414C },
        { 0x03BD, 0x414D },
        { 0x03BE, 0x414E },
        { 0x03BF, 0x414F },
        { 0x03C0, 0x4150 },
        { 0x03C1, 0x4151 },
        { 0x03C3, 0x4152 },
        { 0x03C4, 0x4153 },
        { 0x03C5, 0x4154 },
        { 0x03C6, 0x4155 },
        { 0x03C7, 0x4156 },
        { 0x03C8, 0x4157 },
        { 0x03C9, 0x4158 },
        { 0x0391, 0x4161 },
        { 0x0392, 0x4162 },
        { 0x0393, 0x4163 },
        { 0x0394, 0x4164 },
        { 0x0395, 0x4165 },
        { 0x0396, 0x4166 },
        { 0x0397, 0x4167 },
        { 0x0398, 0x4168 },
        { 0x0399, 0x4169 },
        { 0x039A, 0x416A },
        { 0x039B, 0x416B },
        { 0x039C, 0x416C },
        { 0x039D, 0x416D },
        { 0x039E, 0x416E },
        { 0x039F, 0x416F },
        { 0x03A0, 0x4170 },
        { 0x03A1, 0x4171 },
        { 0x03A3, 0x4172 },
        { 0x03A4, 0x4173 },
        { 0x03A5, 0x4174 },
        { 0x03A6, 0x4175 },
        { 0x03A7, 0x4176 },
        { 0x03A8, 0x4177 },
        { 0x03A9, 0x4178 },
        { 0x0430, 0x4180 },
        { 0x0431, 0x4181 },
        { 0x0432, 0x4182 },
        { 0x0433, 0x4183 },
        { 0x0434, 0x4184 },
        { 0x0435, 0x4185 },
        { 0x0451, 0x4186 },
        { 0x0436, 0x4187 },
        { 0x0437, 0x4188 },
        { 0x0438, 0x4189 },
        { 0x0439, 0x418A },
        { 0x043A, 0x418B },
        { 0x043B, 0x418C },
        { 0x043C, 0x418D },
        { 0x043D, 0x418E },
        { 0x043E, 0x418F },
        { 0x043F, 0x4190 },
        { 0x0440, 0x4191 },
        { 0x0441, 0x4192 },
        { 0x0442, 0x4193 },
        { 0x0443, 0x4194 },
        { 0x0444, 0x4195 },
        { 0x0445, 0x4196 },
        { 0x0446, 0x4197 },
        { 0x0447, 0x4198 },
        { 0x0448, 0x4199 },
        { 0x0449, 0x419A },
        { 0x044A, 0x419B },
        { 0x044B, 0x419C },
        { 0x044C, 0x419D },
        { 0x044D, 0x419E },
        { 0x044E, 0x419F },
        { 0x044F, 0x41A0 },
        { 0x2170, 0x41B1 },
        { 0x2171, 0x41B2 },
        { 0x2172, 0x41B3 },
        { 0x2173, 0x41B4 },
        { 0x2174, 0x41B5 },
        { 0x2175, 0x41B6 },
        { 0x2176, 0x41B7 },
        { 0x2177, 0x41B8 },
        { 0x2178, 0x41B9 },
        { 0x2179, 0x41BA },
        { 0x0410, 0x41C0 },
        { 0x0411, 0x41C1 },
        { 0x0412, 0x41C2 },
        { 0x0413, 0x41C3 },
        { 0x0414, 0x41C4 },
        { 0x0415, 0x41C5 },
        { 0x0401, 0x41C6 },
        { 0x0416, 0x41C7 },
        { 0x0417, 0x41C8 },
        { 0x0418, 0x41C9 },
        { 0x0419, 0x41CA },
        { 0x041A, 0x41CB },
        { 0x041B, 0x41CC },
        { 0x041C, 0x41CD },
        { 0x041D, 0x41CE },
        { 0x041E, 0x41CF },
        { 0x041F, 0x41D0 },
        { 0x0420, 0x41D1 },
        { 0x0421, 0x41D2 },
        { 0x0422, 0x41D3 },
        { 0x0423, 0x41D4 },
        { 0x0424, 0x41D5 },
        { 0x0425, 0x41D6 },
        { 0x0426, 0x41D7 },
        { 0x0427, 0x41D8 },
        { 0x0428, 0x41D9 },
        { 0x0429, 0x41DA },
        { 0x042A, 0x41DB },
        { 0x042B, 0x41DC },
        { 0x042C, 0x41DD },
        { 0x042D, 0x41DE },
        { 0x042E, 0x41DF },
        { 0x042F, 0x41E0 },
        { 0x2160, 0x41F1 },
        { 0x2161, 0x41F2 },
        { 0x2162, 0x41F3 },
        { 0x2163, 0x41F4 },
        { 0x2164, 0x41F5 },
        { 0x2165, 0x41F6 },
        { 0x2166, 0x41F7 },
        { 0x2167, 0x41F8 },
        { 0x2168, 0x41F9 },
        { 0x2169, 0x41FA },
        { 0xFFE1, 0x424A },
        { 0xFF0E, 0x424B },
        { 0xFF1C, 0x424C },
        { 0xFF08, 0x424D },
        { 0xFF0B, 0x424E },
        { 0xFF5C, 0x424F },
        { 0xFF06, 0x4250 },
        { 0xFF01, 0x425A },
        { 0xFFE5, 0x425B },
        { 0x2217, 0x425C },
        { 0xFF09, 0x425D },
        { 0xFF1B, 0x425E },
        { 0xFFE2, 0x425F },
        { 0xFF0D, 0x4260 },
        { 0xFF0F, 0x4261 },
        { 0xFFE4, 0x426A },
        { 0xFF0C, 0x426B },
        { 0xFF05, 0x426C },
        { 0xFF3F, 0x426D },
        { 0xFF1E, 0x426E },
        { 0xFF1F, 0x426F },
        { 0x2035, 0x4279 },
        { 0xFF1A, 0x427A },
        { 0xFF03, 0x427B },
        { 0xFF20, 0x427C },
        { 0xFF07, 0x427D },
        { 0xFF1D, 0x427E },
        { 0xFF02, 0x427F },
        { 0xFF41, 0x4281 },
        { 0xFF42, 0x4282 },
        { 0xFF43, 0x4283 },
        { 0xFF44, 0x4284 },
        { 0xFF45, 0x4285 },
        { 0xFF46, 0x4286 },
        { 0xFF47, 0x4287 },
        { 0xFF48, 0x4288 },
        { 0xFF49, 0x4289 },
        { 0xFF4A, 0x4291 },
        { 0xFF4B, 0x4292 },
        { 0xFF4C, 0x4293 },
        { 0xFF4D, 0x4294 },
        { 0xFF4E, 0x4295 },
        { 0xFF4F, 0x4296 },
        { 0xFF50, 0x4297 },
        { 0xFF51, 0x4298 },
        { 0xFF52, 0x4299 },
        { 0xFFE3, 0x42A1 },
        { 0xFF53, 0x42A2 },
        { 0xFF54, 0x42A3 },
        { 0xFF55, 0x42A4 },
        { 0xFF56, 0x42A5 },
        { 0xFF57, 0x42A6 },
        { 0xFF58, 0x42A7 },
        { 0xFF59, 0x42A8 },
        { 0xFF5A, 0x42A9 },
        { 0xFF5B, 0x42C0 },
        { 0xFF21, 0x42C1 },
        { 0xFF22, 0x42C2 },
        { 0xFF23, 0x42C3 },
        { 0xFF24, 0x42C4 },
        { 0xFF25, 0x42C5 },
        { 0xFF26, 0x42C6 },
        { 0xFF27, 0x42C7 },
        { 0xFF28, 0x42C8 },
        { 0xFF29, 0x42C9 },
        { 0xFF5D, 0x42D0 },
        { 0xFF2A, 0x42D1 },
        { 0xFF2B, 0x42D2 },
        { 0xFF2C, 0x42D3 },
        { 0xFF2D, 0x42D4 },
        { 0xFF2E, 0x42D5 },
        { 0xFF2F, 0x42D6 },
        { 0xFF30, 0x42D7 },
        { 0xFF31, 0x42D8 },
        { 0xFF32, 0x42D9 },
        { 0xFF04, 0x42E0 },
        { 0xFF33, 0x42E2 },
        { 0xFF34, 0x42E3 },
        { 0xFF35, 0x42E4 },
        { 0xFF36, 0x42E5 },
        { 0xFF37, 0x42E6 },
        { 0xFF38, 0x42E7 },
        { 0xFF39, 0x42E8 },
        { 0xFF3A, 0x42E9 },
        { 0xFF10, 0x42F0 },
        { 0xFF11, 0x42F1 },
        { 0xFF12, 0x42F2 },
        { 0xFF13, 0x42F3 },
        { 0xFF14, 0x42F4 },
        { 0xFF15, 0x42F5 },
        { 0xFF16, 0x42F6 },
        { 0xFF17, 0x42F7 },
        { 0xFF18, 0x42F8 },
        { 0xFF19, 0x42F9 },
        { 0x3002, 0x4341 },
        { 0x300C, 0x4342 },
        { 0x300D, 0x4343 },
        { 0x3001, 0x4344 },
        { 0x30FB, 0x4345 },
        { 0x30F2, 0x4346 },
        { 0x30A1, 0x4347 },
        { 0x30A3, 0x4348 },
        { 0x30A5, 0x4349 },
        { 0xFFE0, 0x434A },
        { 0x2312, 0x434D },
        { 0x2202, 0x434E },
        { 0x2207, 0x434F },
        { 0x30A7, 0x4351 },
        { 0x30A9, 0x4352 },
        { 0x30E3, 0x4353 },
        { 0x30E5, 0x4354 },
        { 0x30E7, 0x4355 },
        { 0x30C3, 0x4356 },
        { 0x30EE, 0x4357 },
        { 0x30FC, 0x4358 },
        { 0x30F5, 0x4359 },
        { 0x30F6, 0x435A },
        { 0x226A, 0x435D },
        { 0x226B, 0x435E },
        { 0x223D, 0x4360 },
        { 0x221D, 0x4361 },
        { 0x222C, 0x4363 },
        { 0x2208, 0x4364 },
        { 0x220B, 0x4365 },
        { 0x2286, 0x4366 },
        { 0x2287, 0x4367 },
        { 0x2282, 0x4368 },
        { 0x2283, 0x4369 },
        { 0x2227, 0x436C },
        { 0x2228, 0x436D },
        { 0x21D2, 0x436E },
        { 0x21D4, 0x436F },
        { 0x2200, 0x4370 },
        { 0x2203, 0x4371 },
        { 0x212B, 0x4372 },
        { 0x2030, 0x4373 },
        { 0x266F, 0x4374 },
        { 0x266D, 0x4375 },
        { 0x266A, 0x4376 },
        { 0x2020, 0x4377 },
        { 0x2021, 0x4378 },
        { 0x00B6, 0x4379 },
        { 0x25EF, 0x437A },
        { 0x30A2, 0x4381 },
        { 0x30A4, 0x4382 },
        { 0x30A6, 0x4383 },
        { 0x30A8, 0x4384 },
        { 0x30AA, 0x4385 },
        { 0x30AB, 0x4386 },
        { 0x30AD, 0x4387 },
        { 0x30AF, 0x4388 },
        { 0x30B1, 0x4389 },
        { 0x30B3, 0x438A },
        { 0x30B5, 0x438C },
        { 0x30B7, 0x438D },
        { 0x30B9, 0x438E },
        { 0x30BB, 0x438F },
        { 0x30BD, 0x4390 },
        { 0x30BF, 0x4391 },
        { 0x30C1, 0x4392 },
        { 0x30C4, 0x4393 },
        { 0x30C6, 0x4394 },
        { 0x30C8, 0x4395 },
        { 0x30CA, 0x4396 },
        { 0x30CB, 0x4397 },
        { 0x30CC, 0x4398 },
        { 0x30CD, 0x4399 },
        { 0x30CE, 0x439A },
        { 0x30CF, 0x439D },
        { 0x30D2, 0x439E },
        { 0x30D5, 0x439F },
        { 0x223C, 0x43A1 },
        { 0x30D8, 0x43A2 },
        { 0x30DB, 0x43A3 },
        { 0x30DE, 0x43A4 },
        { 0x30DF, 0x43A5 },
        { 0x30E0, 0x43A6 },
        { 0x30E1, 0x43A7 },
        { 0x30E2, 0x43A8 },
        { 0x30E4, 0x43A9 },
        { 0x30E6, 0x43AA },
        { 0x30E8, 0x43AC },
        { 0x30E9, 0x43AD },
        { 0x30EA, 0x43AE },
        { 0x30EB, 0x43AF },
        { 0x2501, 0x43B7 },
        { 0x2503, 0x43B8 },
        { 0x250F, 0x43B9 },
        { 0x30EC, 0x43BA },
        { 0x30ED, 0x43BB },
        { 0x30EF, 0x43BC },
        { 0x30F3, 0x43BD },
        { 0x309B, 0x43BE },
        { 0x309C, 0x43BF },
        { 0x30AC, 0x43C0 },
        { 0x30AE, 0x43C1 },
        { 0x30B0, 0x43C2 },
        { 0x30B2, 0x43C3 },
        { 0x30B4, 0x43C4 },
        { 0x30B6, 0x43C5 },
        { 0x30B8, 0x43C6 },
        { 0x30BA, 0x43C7 },
        { 0x30BC, 0x43C8 },
        { 0x30BE, 0x43C9 },
        { 0x30C0, 0x43CA },
        { 0x30C2, 0x43CB },
        { 0x30C5, 0x43CC },
        { 0x30C7, 0x43CD },
        { 0x30C9, 0x43CE },
        { 0x30D0, 0x43CF },
        { 0x30D3, 0x43D0 },
        { 0x30D6, 0x43D1 },
        { 0x30D9, 0x43D2 },
        { 0x30DC, 0x43D3 },
        { 0x30F4, 0x43D4 },
        { 0x30D1, 0x43D5 },
        { 0x30D4, 0x43D6 },
        { 0x30D7, 0x43D7 },
        { 0x30DA, 0x43D8 },
        { 0x30DD, 0x43D9 },
        { 0x30F0, 0x43DA },
        { 0x30F1, 0x43DB },
        { 0x30FD, 0x43DC },
        { 0x30FE, 0x43DD },
        { 0xFF3C, 0x43E0 },
        { 0x2513, 0x43E1 },
        { 0x251B, 0x43E2 },
        { 0x2517, 0x43E3 },
        { 0x2523, 0x43E4 },
        { 0x2533, 0x43E5 },
        { 0x252B, 0x43E6 },
        { 0x253B, 0x43E7 },
        { 0x254B, 0x43E8 },
        { 0x2520, 0x43E9 },
        { 0x252F, 0x43EA },
        { 0x2528, 0x43EB },
        { 0x2537, 0x43EC },
        { 0x253F, 0x43ED },
        { 0x251D, 0x43EE },
        { 0x2530, 0x43EF },
        { 0x2525, 0x43F0 },
        { 0x2538, 0x43F1 },
        { 0x2542, 0x43F2 },
        { 0x300E, 0x4442 },
        { 0x300F, 0x4443 },
        { 0xFF3B, 0x4444 },
        { 0xFF3D, 0x4445 },
        { 0x3092, 0x4446 },
        { 0x3041, 0x4447 },
        { 0x3043, 0x4448 },
        { 0x3045, 0x4449 },
        { 0x2014, 0x444A },
        { 0x00B1, 0x444B },
        { 0x2260, 0x444C },
        { 0x221E, 0x444D },
        { 0x2103, 0x444E },
        { 0x00B4, 0x4450 },
        { 0x3047, 0x4451 },
        { 0x3049, 0x4452 },
        { 0x3083, 0x4453 },
        { 0x3085, 0x4454 },
        { 0x3087, 0x4455 },
        { 0x3063, 0x4456 },
        { 0x308E, 0x4457 },
        { 0x2010, 0x445A },
        { 0x3003, 0x445B },
        { 0xF8D2, 0x445C },
        { 0x3005, 0x445D },
        { 0x3006, 0x445E },
        { 0x3007, 0x445F },
        { 0x00A8, 0x4460 },
        { 0x2018, 0x4461 },
        { 0x201C, 0x4462 },
        { 0x3014, 0x4463 },
        { 0x3008, 0x4464 },
        { 0x300A, 0x4465 },
        { 0x3010, 0x4466 },
        { 0x2266, 0x4467 },
        { 0x2234, 0x4468 },
        { 0x2642, 0x4469 },
        { 0x00A7, 0x446A },
        { 0x203B, 0x446B },
        { 0x3012, 0x446C },
        { 0x3231, 0x446D },
        { 0x2116, 0x446E },
        { 0x2121, 0x446F },
        { 0xFF3E, 0x4470 },
        { 0x2019, 0x4471 },
        { 0x201D, 0x4472 },
        { 0x3015, 0x4473 },
        { 0x3009, 0x4474 },
        { 0x300B, 0x4475 },
        { 0x3011, 0x4476 },
        { 0x2267, 0x4477 },
        { 0x2235, 0x4478 },
        { 0x2640, 0x4479 },
        { 0x00D7, 0x447A },
        { 0x00F7, 0x447B },
        { 0x2225, 0x447C },
        { 0x3013, 0x447D },
        { 0x2025, 0x447E },
        { 0x2026, 0x447F },
        { 0x3042, 0x4481 },
        { 0x3044, 0x4482 },
        { 0x3046, 0x4483 },
        { 0x3048, 0x4484 },
        { 0x304A, 0x4485 },
        { 0x304B, 0x4486 },
        { 0x304D, 0x4487 },
        { 0x304F, 0x4488 },
        { 0x3051, 0x4489 },
        { 0x3053, 0x448A },
        { 0x3055, 0x448C },
        { 0x3057, 0x448D },
        { 0x3059, 0x448E },
        { 0x305B, 0x448F },
        { 0x305D, 0x4490 },
        { 0x305F, 0x4491 },
        { 0x3061, 0x4492 },
        { 0x3064, 0x4493 },
        { 0x3066, 0x4494 },
        { 0x3068, 0x4495 },
        { 0x306A, 0x4496 },
        { 0x306B, 0x4497 },
        { 0x306C, 0x4498 },
        { 0x306D, 0x4499 },
        { 0x306E, 0x449A },
        { 0x306F, 0x449D },
        { 0x3072, 0x449E },
        { 0x3075, 0x449F },
        { 0x3078, 0x44A2 },
        { 0x307B, 0x44A3 },
        { 0x307E, 0x44A4 },
        { 0x307F, 0x44A5 },
        { 0x3080, 0x44A6 },
        { 0x3081, 0x44A7 },
        { 0x3082, 0x44A8 },
        { 0x3084, 0x44A9 },
        { 0x3086, 0x44AA },
        { 0x3088, 0x44AC },
        { 0x3089, 0x44AD },
        { 0x308A, 0x44AE },
        { 0x308B, 0x44AF },
        { 0x308C, 0x44BA },
        { 0x308D, 0x44BB },
        { 0x308F, 0x44BC },
        { 0x3093, 0x44BD },
        { 0x304C, 0x44C0 },
        { 0x304E, 0x44C1 },
        { 0x3050, 0x44C2 },
        { 0x3052, 0x44C3 },
        { 0x3054, 0x44C4 },
        { 0x3056, 0x44C5 },
        { 0x3058, 0x44C6 },
        { 0x305A, 0x44C7 },
        { 0x305C, 0x44C8 },
        { 0x305E, 0x44C9 },
        { 0x3060, 0x44CA },
        { 0x3062, 0x44CB },
        { 0x3065, 0x44CC },
        { 0x3067, 0x44CD },
        { 0x3069, 0x44CE },
        { 0x3070, 0x44CF },
        { 0x3073, 0x44D0 },
        { 0x3076, 0x44D1 },
        { 0x3079, 0x44D2 },
        { 0x307C, 0x44D3 },
        { 0x3071, 0x44D5 },
        { 0x3074, 0x44D6 },
        { 0x3077, 0x44D7 },
        { 0x307A, 0x44D8 },
        { 0x307D, 0x44D9 },
        { 0x3090, 0x44DA },
        { 0x3091, 0x44DB },
        { 0x309D, 0x44DC },
        { 0x309E, 0x44DD },
        { 0x25CB, 0x44E0 },
        { 0x25CF, 0x44E1 },
        { 0x25B3, 0x44E2 },
        { 0x25B2, 0x44E3 },
        { 0x25CE, 0x44E4 },
        { 0x2606, 0x44E5 },
        { 0x2605, 0x44E6 },
        { 0x25C7, 0x44E7 },
        { 0x25C6, 0x44E8 },
        { 0x25A1, 0x44E9 },
        { 0x25A0, 0x44EA },
        { 0x25BD, 0x44EB },
        { 0x25BC, 0x44EC },
        { 0x00B0, 0x44ED },
        { 0x2032, 0x44EE },
        { 0x2033, 0x44EF },
        { 0x2192, 0x44F0 },
        { 0x2190, 0x44F1 },
        { 0x2191, 0x44F2 },
        { 0x2193, 0x44F3 },
        { 0x3021, 0x4541 },
        { 0x3022, 0x4542 },
        { 0x3023, 0x4543 },
        { 0x3024, 0x4544 },
        { 0x3025, 0x4545 },
        { 0x3026, 0x4546 },
        { 0x3027, 0x4547 },
        { 0x3028, 0x4548 },
        { 0x3029, 0x4549 },
        { 0x5341, 0x454A },
        { 0x5344, 0x454B },
        { 0x5345, 0x454C },
        { 0x02C9, 0x4551 },
        { 0x02CA, 0x4552 },
        { 0x02C7, 0x4553 },
        { 0x02CB, 0x4554 },
        { 0x02D9, 0x4555 },
        { 0x3105, 0x4556 },
        { 0x3106, 0x4557 },
        { 0x3107, 0x4558 },
        { 0x3108, 0x4559 },
        { 0x3109, 0x455A },
        { 0x310A, 0x455B },
        { 0x310B, 0x455C },
        { 0x310C, 0x455D },
        { 0x310D, 0x455E },
        { 0x310E, 0x455F },
        { 0x310F, 0x4560 },
        { 0x3110, 0x4561 },
        { 0x3111, 0x4562 },
        { 0x3112, 0x4563 },
        { 0x3113, 0x4564 },
        { 0x3114, 0x4565 },
        { 0x3115, 0x4566 },
        { 0x3116, 0x4567 },
        { 0x3117, 0x4568 },
        { 0x3118, 0x4569 },
        { 0x3119, 0x456A },
        { 0x311A, 0x456B },
        { 0x311B, 0x456C },
        { 0x311C, 0x456D },
        { 0x311D, 0x456E },
        { 0x311E, 0x456F },
        { 0x311F, 0x4570 },
        { 0x3120, 0x4571 },
        { 0x3121, 0x4572 },
        { 0x3122, 0x4573 },
        { 0x3123, 0x4574 },
        { 0x3124, 0x4575 },
        { 0x3125, 0x4576 },
        { 0x3126, 0x4577 },
        { 0x3127, 0x4578 },
        { 0x3128, 0x4579 },
        { 0x3129, 0x457A },
        { 0x2460, 0x4641 },
        { 0x2461, 0x4642 },
        { 0x2462, 0x4643 },
        { 0x2463, 0x4644 },
        { 0x2464, 0x4645 },
        { 0x2465, 0x4646 },
        { 0x2466, 0x4647 },
        { 0x2467, 0x4648 },
        { 0x2468, 0x4649 },
        { 0x2469, 0x464A },
        { 0x2474, 0x4651 },
        { 0x2475, 0x4652 },
        { 0x2476, 0x4653 },
        { 0x2477, 0x4654 },
        { 0x2478, 0x4655 },
        { 0x2479, 0x4656 },
        { 0x247A, 0x4657 },
        { 0x247B, 0x4658 },
        { 0x247C, 0x4659 },
        { 0x247D, 0x465A },
        { 0x2581, 0x4660 },
        { 0x2582, 0x4661 },
        { 0x2583, 0x4662 },
        { 0x2584, 0x4663 },
        { 0x2585, 0x4664 },
        { 0x2586, 0x4665 },
        { 0x2587, 0x4666 },
        { 0x2588, 0x4667 },
        { 0x258F, 0x4668 },
        { 0x258E, 0x4669 },
        { 0x258D, 0x466A },
        { 0x258C, 0x466B },
        { 0x258B, 0x466C },
        { 0x258A, 0x466D },
        { 0x2589, 0x466E },
        { 0x253C, 0x466F },
        { 0x2534, 0x4670 },
        { 0x252C, 0x4671 },
        { 0x2524, 0x4672 },
        { 0x251C, 0x4673 },
        { 0x2594, 0x4674 },
        { 0x2500, 0x4675 },
        { 0x2502, 0x4676 },
        { 0x2595, 0x4677 },
        { 0x250C, 0x4678 },
        { 0x2510, 0x4679 },
        { 0x2514, 0x467A },
        { 0x2518, 0x467B },
        { 0x256D, 0x467C },
        { 0x256E, 0x467D },
        { 0x2570, 0x467E },
        { 0x256F, 0x467F },
        { 0x2550, 0x4681 },
        { 0x255E, 0x4682 },
        { 0x256A, 0x4683 },
        { 0x2561, 0x4684 },
        { 0x25E2, 0x4685 },
        { 0x25E3, 0x4686 },
        { 0x25E5, 0x4687 },
        { 0x25E4, 0x4688 },
        { 0x2571, 0x4689 },
        { 0x2572, 0x468A },
        { 0x2573, 0x468B },
        { 0xFE41, 0x46A0 },
        { 0xFE42, 0x46A1 },
        { 0xFE43, 0x46A2 },
        { 0xFE44, 0x46A3 },
        { 0xFE3B, 0x46A4 },
        { 0xFE3C, 0x46A5 },
        { 0xFE31, 0x46A7 },
        { 0xFE33, 0x46A8 },
        { 0x2574, 0x46A9 },
        { 0xFE34, 0x46AA },
        { 0xFE4F, 0x46AB },
        { 0xFE35, 0x46AC },
        { 0xFE36, 0x46AD },
        { 0xFE37, 0x46AE },
        { 0xFE38, 0x46AF },
        { 0xFE39, 0x46B0 },
        { 0xFE3A, 0x46B1 },
        { 0xFE3D, 0x46B2 },
        { 0xFE3E, 0x46B3 },
        { 0xFE3F, 0x46B4 },
        { 0xFE40, 0x46B5 },
        { 0xF8D1, 0x46B6 },
        { 0xF8D0, 0x46B7 },
        { 0xFF0A, 0x46B8 },
        { 0x02BA, 0x46B9 },
        { 0x32A3, 0x46BA },
        { 0x2105, 0x46BB },
        { 0xF8CF, 0x46BC },
        { 0xF8CE, 0x46BD },
        { 0xFE49, 0x46BE },
        { 0xFE4A, 0x46BF },
        { 0xFE4D, 0x46C0 },
        { 0xFE4E, 0x46C1 },
        { 0xFE4B, 0x46C2 },
        { 0xFE4C, 0x46C3 },
        { 0xFE61, 0x46C4 },
        { 0x221A, 0x46C5 },
        { 0x2252, 0x46C6 },
        { 0x2261, 0x46C7 },
        { 0x2229, 0x46C8 },
        { 0x222A, 0x46C9 },
        { 0x22A5, 0x46CA },
        { 0x2220, 0x46CB },
        { 0x221F, 0x46CC },
        { 0x22BF, 0x46CD },
        { 0x33D2, 0x46CE },
        { 0x33D1, 0x46CF },
        { 0x222B, 0x46D0 },
        { 0x222E, 0x46D1 },
        { 0x2295, 0x46D2 },
        { 0x2299, 0x46D3 },
        { 0x2196, 0x46D4 },
        { 0x2197, 0x46D5 },
        { 0x2199, 0x46D6 },
        { 0x2198, 0x46D7 },
        { 0x2044, 0x46DA },
        { 0x2109, 0x46DB },
        { 0x33D5, 0x46DC },
        { 0x339C, 0x46DD },
        { 0x339D, 0x46DE },
        { 0x339E, 0x46DF },
        { 0x33CE, 0x46E0 },
        { 0x33A1, 0x46E1 },
        { 0x338E, 0x46E2 },
        { 0x338F, 0x46E3 },
        { 0x33C4, 0x46E4 },
        { 0x00B7, 0x46E5 },
        { 0x301D, 0x46E9 },
        { 0x301E, 0x46EA },
        { 0x21E7, 0x46EE },
        { 0x21B8, 0x46EF },
        { 0x21B9, 0x46F0 },
        { 0x5159, 0x46F1 },
        { 0x515B, 0x46F2 },
        { 0x515E, 0x46F3 },
        { 0x515D, 0x46F4 },
        { 0x5161, 0x46F5 },
        { 0x5163, 0x46F6 },
        { 0x55E7, 0x46F7 },
        { 0x74E9, 0x46F8 },
        { 0x7CCE, 0x46F9 },
        { 0xFE30, 0x4741 },
        { 0xFE50, 0x4742 },
        { 0xFE51, 0x4743 },
        { 0xFE52, 0x4744 },
        { 0xFE54, 0x4745 },
        { 0xFE55, 0x4746 },
        { 0xFE56, 0x4747 },
        { 0xFE57, 0x4748 },
        { 0xFE32, 0x4749 },
        { 0xFE58, 0x474A },
        { 0xFE59, 0x474B },
        { 0xFE5A, 0x474C },
        { 0xFE5B, 0x474D },
        { 0xFE5C, 0x474E },
        { 0xFE5D, 0x474F },
        { 0xFE5E, 0x4750 },
        { 0x203E, 0x4751 },
        { 0x02CD, 0x4752 },
        { 0xFE5F, 0x4753 },
        { 0xFE60, 0x4754 },
        { 0xFE62, 0x4755 },
        { 0xFE63, 0x4756 },
        { 0xFE64, 0x4757 },
        { 0xFE65, 0x4758 },
        { 0xFE66, 0x4759 },
        { 0xFE68, 0x475A },
        { 0xFE69, 0x475B },
        { 0xFE6A, 0x475C },
        { 0xFE6B, 0x475D },
        { 0x2400, 0x4781 },
        { 0x2401, 0x4782 },
        { 0x2402, 0x4783 },
        { 0x2403, 0x4784 },
        { 0x2404, 0x4785 },
        { 0x2405, 0x4786 },
        { 0x2406, 0x4787 },
        { 0x2407, 0x4788 },
        { 0x2408, 0x4789 },
        { 0x2409, 0x478A },
        { 0x240A, 0x478B },
        { 0x240B, 0x478C },
        { 0x240C, 0x478D },
        { 0x240D, 0x478E },
        { 0x240E, 0x478F },
        { 0x240F, 0x4790 },
        { 0x2410, 0x4791 },
        { 0x2411, 0x4792 },
        { 0x2412, 0x4793 },
        { 0x2413, 0x4794 },
        { 0x2414, 0x4795 },
        { 0x2415, 0x4796 },
        { 0x2416, 0x4797 },
        { 0x2417, 0x4798 },
        { 0x2418, 0x4799 },
        { 0x2419, 0x479A },
        { 0x241A, 0x479B },
        { 0x241B, 0x479C },
        { 0x241C, 0x479D },
        { 0x241D, 0x479E },
        { 0x241E, 0x479F },
        { 0x241F, 0x47A0 },
        { 0x2421, 0x47A1 },
        { 0x4E00, 0x4841 },
        { 0x4E28, 0x4842 },
        { 0x4E36, 0x4843 },
        { 0x4E3F, 0x4844 },
        { 0x4E59, 0x4845 },
        { 0x4E85, 0x4846 },
        { 0x4E8C, 0x4847 },
        { 0x4EA0, 0x4848 },
        { 0x4EBA, 0x4849 },
        { 0x513F, 0x484A },
        { 0x5165, 0x484B },
        { 0x516B, 0x484C },
        { 0x5182, 0x484D },
        { 0x5196, 0x484E },
        { 0x51AB, 0x484F },
        { 0x51E0, 0x4850 },
        { 0x51F5, 0x4851 },
        { 0x5200, 0x4852 },
        { 0x529B, 0x4853 },
        { 0x52F9, 0x4854 },
        { 0x5315, 0x4855 },
        { 0x531A, 0x4856 },
        { 0x5338, 0x4857 },
        { 0x5341, 0x4858 },
        { 0x535C, 0x4859 },
        { 0x5369, 0x485A },
        { 0x5382, 0x485B },
        { 0x53B6, 0x485C },
        { 0x53C8, 0x485D },
        { 0x53E3, 0x485E },
        { 0x56D7, 0x485F },
        { 0x571F, 0x4860 },
        { 0x58EB, 0x4861 },
        { 0x590A, 0x4862 },
        { 0x5915, 0x4863 },
        { 0x5927, 0x4864 },
        { 0x5973, 0x4865 },
        { 0x5B50, 0x4866 },
        { 0x5B80, 0x4867 },
        { 0x5BF8, 0x4868 },
        { 0x5C0F, 0x4869 },
        { 0x5C22, 0x486A },
        { 0x5C38, 0x486B },
        { 0x5C6E, 0x486C },
        { 0x5C71, 0x486D },
        { 0x5DDB, 0x486E },
        { 0x5DE5, 0x486F },
        { 0x5DF1, 0x4870 },
        { 0x5DFE, 0x4871 },
        { 0x5E72, 0x4872 },
        { 0x5E7A, 0x4873 },
        { 0x5E7F, 0x4874 },
        { 0x5EF4, 0x4875 },
        { 0x5EFE, 0x4876 },
        { 0x5F0B, 0x4877 },
        { 0x5F13, 0x4878 },
        { 0x5F50, 0x4879 },
        { 0x5F61, 0x487A },
        { 0x5F73, 0x487B },
        { 0x5FC3, 0x487C },
        { 0x6208, 0x487D },
        { 0x6236, 0x487E },
        { 0x624B, 0x487F },
        { 0x652F, 0x4881 },
        { 0x6534, 0x4882 },
        { 0x6587, 0x4883 },
        { 0x6597, 0x4884 },
        { 0x65A4, 0x4885 },
        { 0x65B9, 0x4886 },
        { 0x65E0, 0x4887 },
        { 0x65E5, 0x4888 },
        { 0x66F0, 0x4889 },
        { 0x6708, 0x488A },
        { 0x6728, 0x488B },
        { 0x6B20, 0x488C },
        { 0x6B62, 0x488D },
        { 0x6B79, 0x488E },
        { 0x6BB3, 0x488F },
        { 0x6BCB, 0x4890 },
        { 0x6BD4, 0x4891 },
        { 0x6BDB, 0x4892 },
        { 0x6C0F, 0x4893 },
        { 0x6C14, 0x4894 },
        { 0x6C34, 0x4895 },
        { 0x706B, 0x4896 },
        { 0x722A, 0x4897 },
        { 0x7236, 0x4898 },
        { 0x723B, 0x4899 },
        { 0x723F, 0x489A },
        { 0x7247, 0x489B },
        { 0x7259, 0x489C },
        { 0x725B, 0x489D },
        { 0x72AC, 0x489E },
        { 0x7384, 0x489F },
        { 0x7389, 0x48A0 },
        { 0x74DC, 0x48A1 },
        { 0x74E6, 0x48A2 },
        { 0x7518, 0x48A3 },
        { 0x751F, 0x48A4 },
        { 0x7528, 0x48A5 },
        { 0x7530, 0x48A6 },
        { 0x758B, 0x48A7 },
        { 0x7592, 0x48A8 },
        { 0x7676, 0x48A9 },
        { 0x767D, 0x48AA },
        { 0x76AE, 0x48AB },
        { 0x76BF, 0x48AC },
        { 0x76EE, 0x48AD },
        { 0x77DB, 0x48AE },
        { 0x77E2, 0x48AF },
        { 0x77F3, 0x48B0 },
        { 0x793A, 0x48B1 },
        { 0x79B8, 0x48B2 },
        { 0x79BE, 0x48B3 },
        { 0x7A74, 0x48B4 },
        { 0x7ACB, 0x48B5 },
        { 0x7AF9, 0x48B6 },
        { 0x7C73, 0x48B7 },
        { 0x7CF8, 0x48B8 },
        { 0x7F36, 0x48B9 },
        { 0x7F51, 0x48BA },
        { 0x7F8A, 0x48BB },
        { 0x7FBD, 0x48BC },
        { 0x8001, 0x48BD },
        { 0x800C, 0x48BE },
        { 0x8012, 0x48BF },
        { 0x8033, 0x48C0 },
        { 0x807F, 0x48C1 },
        { 0x8089, 0x48C2 },
        { 0x81E3, 0x48C3 },
        { 0x81EA, 0x48C4 },
        { 0x81F3, 0x48C5 },
        { 0x81FC, 0x48C6 },
        { 0x820C, 0x48C7 },
        { 0x821B, 0x48C8 },
        { 0x821F, 0x48C9 },
        { 0x826E, 0x48CA },
        { 0x8272, 0x48CB },
        { 0x8278, 0x48CC },
        { 0x864D, 0x48CD },
        { 0x866B, 0x48CE },
        { 0x8840, 0x48CF },
        { 0x884C, 0x48D0 },
        { 0x8863, 0x48D1 },
        { 0x897E, 0x48D2 },
        { 0x898B, 0x48D3 },
        { 0x89D2, 0x48D4 },
        { 0x8A00, 0x48D5 },
        { 0x8C37, 0x48D6 },
        { 0x8C46, 0x48D7 },
        { 0x8C55, 0x48D8 },
        { 0x8C78, 0x48D9 },
        { 0x8C9D, 0x48DA },
        { 0x8D64, 0x48DB },
        { 0x8D70, 0x48DC },
        { 0x8DB3, 0x48DD },
        { 0x8EAB, 0x48DE },
        { 0x8ECA, 0x48DF },
        { 0x8F9B, 0x48E0 },
        { 0x8FB0, 0x48E1 },
        { 0x8FB5, 0x48E2 },
        { 0x9091, 0x48E3 },
        { 0x9149, 0x48E4 },
        { 0x91C6, 0x48E5 },
        { 0x91CC, 0x48E6 },
        { 0x91D1, 0x48E7 },
        { 0x9577, 0x48E8 },
        { 0x9580, 0x48E9 },
        { 0x961C, 0x48EA },
        { 0x96B6, 0x48EB },
        { 0x96B9, 0x48EC },
        { 0x96E8, 0x48ED },
        { 0x9752, 0x48EE },
        { 0x975E, 0x48EF },
        { 0x9762, 0x48F0 },
        { 0x9769, 0x48F1 },
        { 0x97CB, 0x48F2 },
        { 0x97ED, 0x48F3 },
        { 0x97F3, 0x48F4 },
        { 0x9801, 0x48F5 },
        { 0x98A8, 0x48F6 },
        { 0x98DB, 0x48F7 },
        { 0x98DF, 0x48F8 },
        { 0x9996, 0x48F9 },
        { 0x9999, 0x48FA },
        { 0x99AC, 0x48FB },
        { 0x9AA8, 0x48FC },
        { 0x9AD8, 0x48FD },
        { 0x9ADF, 0x4941 },
        { 0x9B25, 0x4942 },
        { 0x9B2F, 0x4943 },
        { 0x9B32, 0x4944 },
        { 0x9B3C, 0x4945 },
        { 0x9B5A, 0x4946 },
        { 0x9CE5, 0x4947 },
        { 0x9E75, 0x4948 },
        { 0x9E7F, 0x4949 },
        { 0x9EA5, 0x494A },
        { 0x9EBB, 0x494B },
        { 0x9EC3, 0x494C },
        { 0x9ECD, 0x494D },
        { 0x9ED1, 0x494E },
        { 0x9EF9, 0x494F },
        { 0x9EFD, 0x4950 },
        { 0x9F0E, 0x4951 },
        { 0x9F13, 0x4952 },
        { 0x9F20, 0x4953 },
        { 0x9F3B, 0x4954 },
        { 0x9F4A, 0x4955 },
        { 0x9F52, 0x4956 },
        { 0x9F8D, 0x4957 },
        { 0x9F9C, 0x4958 },
        { 0x9FA0, 0x4959 },
        { 0x4E00, 0x4C41 },
        { 0x4E59, 0x4C42 },
        { 0x4E01, 0x4C43 },
        { 0x4E03, 0x4C44 },
        { 0x4E43, 0x4C45 },
        { 0x4E5D, 0x4C46 },
        { 0x4E86, 0x4C47 },
        { 0x4E8C, 0x4C48 },
        { 0x4EBA, 0x4C49 },
        { 0x513F, 0x4C4A },
        { 0x5165, 0x4C4B },
        { 0x516B, 0x4C4C },
        { 0x51E0, 0x4C4D },
        { 0x5200, 0x4C4E },
        { 0x5201, 0x4C4F },
        { 0x529B, 0x4C50 },
        { 0x5315, 0x4C51 },
        { 0x5341, 0x4C52 },
        { 0x535C, 0x4C53 },
        { 0x53C8, 0x4C54 },
        { 0x4E09, 0x4C55 },
        { 0x4E0B, 0x4C56 },
        { 0x4E08, 0x4C57 },
        { 0x4E0A, 0x4C58 },
        { 0x4E2B, 0x4C59 },
        { 0x4E38, 0x4C5A },
        { 0x51E1, 0x4C5B },
        { 0x4E45, 0x4C5C },
        { 0x4E48, 0x4C5D },
        { 0x4E5F, 0x4C5E },
        { 0x4E5E, 0x4C5F },
        { 0x4E8E, 0x4C60 },
        { 0x4EA1, 0x4C61 },
        { 0x5140, 0x4C62 },
        { 0x5203, 0x4C63 },
        { 0x52FA, 0x4C64 },
        { 0x5343, 0x4C65 },
        { 0x53C9, 0x4C66 },
        { 0x53E3, 0x4C67 },
        { 0x571F, 0x4C68 },
        { 0x58EB, 0x4C69 },
        { 0x5915, 0x4C6A },
        { 0x5927, 0x4C6B },
        { 0x5973, 0x4C6C },
        { 0x5B50, 0x4C6D },
        { 0x5B51, 0x4C6E },
        { 0x5B53, 0x4C6F },
        { 0x5BF8, 0x4C70 },
        { 0x5C0F, 0x4C71 },
        { 0x5C22, 0x4C72 },
        { 0x5C38, 0x4C73 },
        { 0x5C71, 0x4C74 },
        { 0x5DDD, 0x4C75 },
        { 0x5DE5, 0x4C76 },
        { 0x5DF1, 0x4C77 },
        { 0x5DF2, 0x4C78 },
        { 0x5DF3, 0x4C79 },
        { 0x5DFE, 0x4C7A },
        { 0x5E72, 0x4C7B },
        { 0x5EFE, 0x4C7C },
        { 0x5F0B, 0x4C7D },
        { 0x5F13, 0x4C7E },
        { 0x624D, 0x4C7F },
        { 0x4E11, 0x4C81 },
        { 0x4E10, 0x4C82 },
        { 0x4E0D, 0x4C83 },
        { 0x4E2D, 0x4C84 },
        { 0x4E30, 0x4C85 },
        { 0x4E39, 0x4C86 },
        { 0x4E4B, 0x4C87 },
        { 0x5C39, 0x4C88 },
        { 0x4E88, 0x4C89 },
        { 0x4E91, 0x4C8A },
        { 0x4E95, 0x4C8B },
        { 0x4E92, 0x4C8C },
        { 0x4E94, 0x4C8D },
        { 0x4EA2, 0x4C8E },
        { 0x4EC1, 0x4C8F },
        { 0x4EC0, 0x4C90 },
        { 0x4EC3, 0x4C91 },
        { 0x4EC6, 0x4C92 },
        { 0x4EC7, 0x4C93 },
        { 0x4ECD, 0x4C94 },
        { 0x4ECA, 0x4C95 },
        { 0x4ECB, 0x4C96 },
        { 0x4EC4, 0x4C97 },
        { 0x5143, 0x4C98 },
        { 0x5141, 0x4C99 },
        { 0x5167, 0x4C9A },
        { 0x516D, 0x4C9B },
        { 0x516E, 0x4C9C },
        { 0x516C, 0x4C9D },
        { 0x5197, 0x4C9E },
        { 0x51F6, 0x4C9F },
        { 0x5206, 0x4CA0 },
        { 0x5207, 0x4CA1 },
        { 0x5208, 0x4CA2 },
        { 0x52FB, 0x4CA3 },
        { 0x52FE, 0x4CA4 },
        { 0x52FF, 0x4CA5 },
        { 0x5316, 0x4CA6 },
        { 0x5339, 0x4CA7 },
        { 0x5348, 0x4CA8 },
        { 0x5347, 0x4CA9 },
        { 0x5345, 0x4CAA },
        { 0x535E, 0x4CAB },
        { 0x5384, 0x4CAC },
        { 0x53CB, 0x4CAD },
        { 0x53CA, 0x4CAE },
        { 0x53CD, 0x4CAF },
        { 0x58EC, 0x4CB0 },
        { 0x5929, 0x4CB1 },
        { 0x592B, 0x4CB2 },
        { 0x592A, 0x4CB3 },
        { 0x592D, 0x4CB4 },
        { 0x5B54, 0x4CB5 },
        { 0x5C11, 0x4CB6 },
        { 0x5C24, 0x4CB7 },
        { 0x5C3A, 0x4CB8 },
        { 0x5C6F, 0x4CB9 },
        { 0x5DF4, 0x4CBA },
        { 0x5E7B, 0x4CBB },
        { 0x5EFF, 0x4CBC },
        { 0x5F14, 0x4CBD },
        { 0x5F15, 0x4CBE },
        { 0x5FC3, 0x4CBF },
        { 0x6208, 0x4CC0 },
        { 0x6236, 0x4CC1 },
        { 0x624B, 0x4CC2 },
        { 0x624E, 0x4CC3 },
        { 0x652F, 0x4CC4 },
        { 0x6587, 0x4CC5 },
        { 0x6597, 0x4CC6 },
        { 0x65A4, 0x4CC7 },
        { 0x65B9, 0x4CC8 },
        { 0x65E5, 0x4CC9 },
        { 0x66F0, 0x4CCA },
        { 0x6708, 0x4CCB },
        { 0x6728, 0x4CCC },
        { 0x6B20, 0x4CCD },
        { 0x6B62, 0x4CCE },
        { 0x6B79, 0x4CCF },
        { 0x6BCB, 0x4CD0 },
        { 0x6BD4, 0x4CD1 },
        { 0x6BDB, 0x4CD2 },
        { 0x6C0F, 0x4CD3 },
        { 0x6C34, 0x4CD4 },
        { 0x706B, 0x4CD5 },
        { 0x722A, 0x4CD6 },
        { 0x7236, 0x4CD7 },
        { 0x723B, 0x4CD8 },
        { 0x7247, 0x4CD9 },
        { 0x7259, 0x4CDA },
        { 0x725B, 0x4CDB },
        { 0x72AC, 0x4CDC },
        { 0x738B, 0x4CDD },
        { 0x4E19, 0x4CDE },
        { 0x4E16, 0x4CDF },
        { 0x4E15, 0x4CE0 },
        { 0x4E14, 0x4CE1 },
        { 0x4E18, 0x4CE2 },
        { 0x4E3B, 0x4CE3 },
        { 0x4E4D, 0x4CE4 },
        { 0x4E4F, 0x4CE5 },
        { 0x4E4E, 0x4CE6 },
        { 0x4EE5, 0x4CE7 },
        { 0x4ED8, 0x4CE8 },
        { 0x4ED4, 0x4CE9 },
        { 0x4ED5, 0x4CEA },
        { 0x4ED6, 0x4CEB },
        { 0x4ED7, 0x4CEC },
        { 0x4EE3, 0x4CED },
        { 0x4EE4, 0x4CEE },
        { 0x4ED9, 0x4CEF },
        { 0x4EDE, 0x4CF0 },
        { 0x5145, 0x4CF1 },
        { 0x5144, 0x4CF2 },
        { 0x5189, 0x4CF3 },
        { 0x518A, 0x4CF4 },
        { 0x51AC, 0x4CF5 },
        { 0x51F9, 0x4CF6 },
        { 0x51FA, 0x4CF7 },
        { 0x51F8, 0x4CF8 },
        { 0x520A, 0x4CF9 },
        { 0x52A0, 0x4CFA },
        { 0x529F, 0x4CFB },
        { 0x5305, 0x4CFC },
        { 0x5306, 0x4CFD },
        { 0x5317, 0x4D41 },
        { 0x531D, 0x4D42 },
        { 0x4EDF, 0x4D43 },
        { 0x534A, 0x4D44 },
        { 0x5349, 0x4D45 },
        { 0x5361, 0x4D46 },
        { 0x5360, 0x4D47 },
        { 0x536F, 0x4D48 },
        { 0x536E, 0x4D49 },
        { 0x53BB, 0x4D4A },
        { 0x53EF, 0x4D4B },
        { 0x53E4, 0x4D4C },
        { 0x53F3, 0x4D4D },
        { 0x53EC, 0x4D4E },
        { 0x53EE, 0x4D4F },
        { 0x53E9, 0x4D50 },
        { 0x53E8, 0x4D51 },
        { 0x53FC, 0x4D52 },
        { 0x53F8, 0x4D53 },
        { 0x53F5, 0x4D54 },
        { 0x53EB, 0x4D55 },
        { 0x53E6, 0x4D56 },
        { 0x53EA, 0x4D57 },
        { 0x53F2, 0x4D58 },
        { 0x53F1, 0x4D59 },
        { 0x53F0, 0x4D5A },
        { 0x53E5, 0x4D5B },
        { 0x53ED, 0x4D5C },
        { 0x53FB, 0x4D5D },
        { 0x56DB, 0x4D5E },
        { 0x56DA, 0x4D5F },
        { 0x5916, 0x4D60 },
        { 0x592E, 0x4D61 },
        { 0x5931, 0x4D62 },
        { 0x5974, 0x4D63 },
        { 0x5976, 0x4D64 },
        { 0x5B55, 0x4D65 },
        { 0x5B83, 0x4D66 },
        { 0x5C3C, 0x4D67 },
        { 0x5DE8, 0x4D68 },
        { 0x5DE7, 0x4D69 },
        { 0x5DE6, 0x4D6A },
        { 0x5E02, 0x4D6B },
        { 0x5E03, 0x4D6C },
        { 0x5E73, 0x4D6D },
        { 0x5E7C, 0x4D6E },
        { 0x5F01, 0x4D6F },
        { 0x5F18, 0x4D70 },
        { 0x5F17, 0x4D71 },
        { 0x5FC5, 0x4D72 },
        { 0x620A, 0x4D73 },
        { 0x6253, 0x4D74 },
        { 0x6254, 0x4D75 },
        { 0x6252, 0x4D76 },
        { 0x6251, 0x4D77 },
        { 0x65A5, 0x4D78 },
        { 0x65E6, 0x4D79 },
        { 0x672E, 0x4D7A },
        { 0x672C, 0x4D7B },
        { 0x672A, 0x4D7C },
        { 0x672B, 0x4D7D },
        { 0x672D, 0x4D7E },
        { 0x6B63, 0x4D7F },
        { 0x6BCD, 0x4D81 },
        { 0x6C11, 0x4D82 },
        { 0x6C10, 0x4D83 },
        { 0x6C38, 0x4D84 },
        { 0x6C41, 0x4D85 },
        { 0x6C40, 0x4D86 },
        { 0x6C3E, 0x4D87 },
        { 0x72AF, 0x4D88 },
        { 0x7384, 0x4D89 },
        { 0x7389, 0x4D8A },
        { 0x74DC, 0x4D8B },
        { 0x74E6, 0x4D8C },
        { 0x7518, 0x4D8D },
        { 0x751F, 0x4D8E },
        { 0x7528, 0x4D8F },
        { 0x7529, 0x4D90 },
        { 0x7530, 0x4D91 },
        { 0x7531, 0x4D92 },
        { 0x7532, 0x4D93 },
        { 0x7533, 0x4D94 },
        { 0x758B, 0x4D95 },
        { 0x767D, 0x4D96 },
        { 0x76AE, 0x4D97 },
        { 0x76BF, 0x4D98 },
        { 0x76EE, 0x4D99 },
        { 0x77DB, 0x4D9A },
        { 0x77E2, 0x4D9B },
        { 0x77F3, 0x4D9C },
        { 0x793A, 0x4D9D },
        { 0x79BE, 0x4D9E },
        { 0x7A74, 0x4D9F },
        { 0x7ACB, 0x4DA0 },
        { 0x4E1E, 0x4DA1 },
        { 0x4E1F, 0x4DA2 },
        { 0x4E52, 0x4DA3 },
        { 0x4E53, 0x4DA4 },
        { 0x4E69, 0x4DA5 },
        { 0x4E99, 0x4DA6 },
        { 0x4EA4, 0x4DA7 },
        { 0x4EA6, 0x4DA8 },
        { 0x4EA5, 0x4DA9 },
        { 0x4EFF, 0x4DAA },
        { 0x4F09, 0x4DAB },
        { 0x4F19, 0x4DAC },
        { 0x4F0A, 0x4DAD },
        { 0x4F15, 0x4DAE },
        { 0x4F0D, 0x4DAF },
        { 0x4F10, 0x4DB0 },
        { 0x4F11, 0x4DB1 },
        { 0x4F0F, 0x4DB2 },
        { 0x4EF2, 0x4DB3 },
        { 0x4EF6, 0x4DB4 },
        { 0x4EFB, 0x4DB5 },
        { 0x4EF0, 0x4DB6 },
        { 0x4EF3, 0x4DB7 },
        { 0x4EFD, 0x4DB8 },
        { 0x4F01, 0x4DB9 },
        { 0x4F0B, 0x4DBA },
        { 0x5149, 0x4DBB },
        { 0x5147, 0x4DBC },
        { 0x5146, 0x4DBD },
        { 0x5148, 0x4DBE },
        { 0x5168, 0x4DBF },
        { 0x5171, 0x4DC0 },
        { 0x518D, 0x4DC1 },
        { 0x51B0, 0x4DC2 },
        { 0x5217, 0x4DC3 },
        { 0x5211, 0x4DC4 },
        { 0x5212, 0x4DC5 },
        { 0x520E, 0x4DC6 },
        { 0x5216, 0x4DC7 },
        { 0x52A3, 0x4DC8 },
        { 0x5308, 0x4DC9 },
        { 0x5321, 0x4DCA },
        { 0x5320, 0x4DCB },
        { 0x5370, 0x4DCC },
        { 0x5371, 0x4DCD },
        { 0x5409, 0x4DCE },
        { 0x540F, 0x4DCF },
        { 0x540C, 0x4DD0 },
        { 0x540A, 0x4DD1 },
        { 0x5410, 0x4DD2 },
        { 0x5401, 0x4DD3 },
        { 0x540B, 0x4DD4 },
        { 0x5404, 0x4DD5 },
        { 0x5411, 0x4DD6 },
        { 0x540D, 0x4DD7 },
        { 0x5408, 0x4DD8 },
        { 0x5403, 0x4DD9 },
        { 0x540E, 0x4DDA },
        { 0x5406, 0x4DDB },
        { 0x5412, 0x4DDC },
        { 0x56E0, 0x4DDD },
        { 0x56DE, 0x4DDE },
        { 0x56DD, 0x4DDF },
        { 0x5733, 0x4DE0 },
        { 0x5730, 0x4DE1 },
        { 0x5728, 0x4DE2 },
        { 0x572D, 0x4DE3 },
        { 0x572C, 0x4DE4 },
        { 0x572F, 0x4DE5 },
        { 0x5729, 0x4DE6 },
        { 0x5919, 0x4DE7 },
        { 0x591A, 0x4DE8 },
        { 0x5937, 0x4DE9 },
        { 0x5938, 0x4DEA },
        { 0x5984, 0x4DEB },
        { 0x5978, 0x4DEC },
        { 0x5983, 0x4DED },
        { 0x597D, 0x4DEE },
        { 0x5979, 0x4DEF },
        { 0x5982, 0x4DF0 },
        { 0x5981, 0x4DF1 },
        { 0x5B57, 0x4DF2 },
        { 0x5B58, 0x4DF3 },
        { 0x5B87, 0x4DF4 },
        { 0x5B88, 0x4DF5 },
        { 0x5B85, 0x4DF6 },
        { 0x5B89, 0x4DF7 },
        { 0x5BFA, 0x4DF8 },
        { 0x5C16, 0x4DF9 },
        { 0x5C79, 0x4DFA },
        { 0x5DDE, 0x4DFB },
        { 0x5E06, 0x4DFC },
        { 0x5E76, 0x4DFD },
        { 0x5E74, 0x4E41 },
        { 0x5F0F, 0x4E42 },
        { 0x5F1B, 0x4E43 },
        { 0x5FD9, 0x4E44 },
        { 0x5FD6, 0x4E45 },
        { 0x620E, 0x4E46 },
        { 0x620C, 0x4E47 },
        { 0x620D, 0x4E48 },
        { 0x6210, 0x4E49 },
        { 0x6263, 0x4E4A },
        { 0x625B, 0x4E4B },
        { 0x6258, 0x4E4C },
        { 0x6536, 0x4E4D },
        { 0x65E9, 0x4E4E },
        { 0x65E8, 0x4E4F },
        { 0x65EC, 0x4E50 },
        { 0x65ED, 0x4E51 },
        { 0x66F2, 0x4E52 },
        { 0x66F3, 0x4E53 },
        { 0x6709, 0x4E54 },
        { 0x673D, 0x4E55 },
        { 0x6734, 0x4E56 },
        { 0x6731, 0x4E57 },
        { 0x6735, 0x4E58 },
        { 0x6B21, 0x4E59 },
        { 0x6B64, 0x4E5A },
        { 0x6B7B, 0x4E5B },
        { 0x6C16, 0x4E5C },
        { 0x6C5D, 0x4E5D },
        { 0x6C57, 0x4E5E },
        { 0x6C59, 0x4E5F },
        { 0x6C5F, 0x4E60 },
        { 0x6C60, 0x4E61 },
        { 0x6C50, 0x4E62 },
        { 0x6C55, 0x4E63 },
        { 0x6C61, 0x4E64 },
        { 0x6C5B, 0x4E65 },
        { 0x6C4D, 0x4E66 },
        { 0x6C4E, 0x4E67 },
        { 0x7070, 0x4E68 },
        { 0x725F, 0x4E69 },
        { 0x725D, 0x4E6A },
        { 0x767E, 0x4E6B },
        { 0x7AF9, 0x4E6C },
        { 0x7C73, 0x4E6D },
        { 0x7CF8, 0x4E6E },
        { 0x7F36, 0x4E6F },
        { 0x7F8A, 0x4E70 },
        { 0x7FBD, 0x4E71 },
        { 0x8001, 0x4E72 },
        { 0x8003, 0x4E73 },
        { 0x800C, 0x4E74 },
        { 0x8012, 0x4E75 },
        { 0x8033, 0x4E76 },
        { 0x807F, 0x4E77 },
        { 0x8089, 0x4E78 },
        { 0x808B, 0x4E79 },
        { 0x808C, 0x4E7A },
        { 0x81E3, 0x4E7B },
        { 0x81EA, 0x4E7C },
        { 0x81F3, 0x4E7D },
        { 0x81FC, 0x4E7E },
        { 0x820C, 0x4E7F },
        { 0x821B, 0x4E81 },
        { 0x821F, 0x4E82 },
        { 0x826E, 0x4E83 },
        { 0x8272, 0x4E84 },
        { 0x827E, 0x4E85 },
        { 0x866B, 0x4E86 },
        { 0x8840, 0x4E87 },
        { 0x884C, 0x4E88 },
        { 0x8863, 0x4E89 },
        { 0x897F, 0x4E8A },
        { 0x9621, 0x4E8B },
        { 0x4E32, 0x4E8C },
        { 0x4EA8, 0x4E8D },
        { 0x4F4D, 0x4E8E },
        { 0x4F4F, 0x4E8F },
        { 0x4F47, 0x4E90 },
        { 0x4F57, 0x4E91 },
        { 0x4F5E, 0x4E92 },
        { 0x4F34, 0x4E93 },
        { 0x4F5B, 0x4E94 },
        { 0x4F55, 0x4E95 },
        { 0x4F30, 0x4E96 },
        { 0x4F50, 0x4E97 },
        { 0x4F51, 0x4E98 },
        { 0x4F3D, 0x4E99 },
        { 0x4F3A, 0x4E9A },
        { 0x4F38, 0x4E9B },
        { 0x4F43, 0x4E9C },
        { 0x4F54, 0x4E9D },
        { 0x4F3C, 0x4E9E },
        { 0x4F46, 0x4E9F },
        { 0x4F63, 0x4EA0 },
        { 0x4F5C, 0x4EA1 },
        { 0x4F60, 0x4EA2 },
        { 0x4F2F, 0x4EA3 },
        { 0x4F4E, 0x4EA4 },
        { 0x4F36, 0x4EA5 },
        { 0x4F59, 0x4EA6 },
        { 0x4F5D, 0x4EA7 },
        { 0x4F48, 0x4EA8 },
        { 0x4F5A, 0x4EA9 },
        { 0x514C, 0x4EAA },
        { 0x514B, 0x4EAB },
        { 0x514D, 0x4EAC },
        { 0x5175, 0x4EAD },
        { 0x51B6, 0x4EAE },
        { 0x51B7, 0x4EAF },
        { 0x5225, 0x4EB0 },
        { 0x5224, 0x4EB1 },
        { 0x5229, 0x4EB2 },
        { 0x522A, 0x4EB3 },
        { 0x5228, 0x4EB4 },
        { 0x52AB, 0x4EB5 },
        { 0x52A9, 0x4EB6 },
        { 0x52AA, 0x4EB7 },
        { 0x52AC, 0x4EB8 },
        { 0x5323, 0x4EB9 },
        { 0x5373, 0x4EBA },
        { 0x5375, 0x4EBB },
        { 0x541D, 0x4EBC },
        { 0x542D, 0x4EBD },
        { 0x541E, 0x4EBE },
        { 0x543E, 0x4EBF },
        { 0x5426, 0x4EC0 },
        { 0x544E, 0x4EC1 },
        { 0x5427, 0x4EC2 },
        { 0x5446, 0x4EC3 },
        { 0x5443, 0x4EC4 },
        { 0x5433, 0x4EC5 },
        { 0x5448, 0x4EC6 },
        { 0x5442, 0x4EC7 },
        { 0x541B, 0x4EC8 },
        { 0x5429, 0x4EC9 },
        { 0x544A, 0x4ECA },
        { 0x5439, 0x4ECB },
        { 0x543B, 0x4ECC },
        { 0x5438, 0x4ECD },
        { 0x542E, 0x4ECE },
        { 0x5435, 0x4ECF },
        { 0x5436, 0x4ED0 },
        { 0x5420, 0x4ED1 },
        { 0x543C, 0x4ED2 },
        { 0x5440, 0x4ED3 },
        { 0x5431, 0x4ED4 },
        { 0x542B, 0x4ED5 },
        { 0x541F, 0x4ED6 },
        { 0x542C, 0x4ED7 },
        { 0x56EA, 0x4ED8 },
        { 0x56F0, 0x4ED9 },
        { 0x56E4, 0x4EDA },
        { 0x56EB, 0x4EDB },
        { 0x574A, 0x4EDC },
        { 0x5751, 0x4EDD },
        { 0x5740, 0x4EDE },
        { 0x574D, 0x4EDF },
        { 0x5747, 0x4EE0 },
        { 0x574E, 0x4EE1 },
        { 0x573E, 0x4EE2 },
        { 0x5750, 0x4EE3 },
        { 0x574F, 0x4EE4 },
        { 0x573B, 0x4EE5 },
        { 0x58EF, 0x4EE6 },
        { 0x593E, 0x4EE7 },
        { 0x599D, 0x4EE8 },
        { 0x5992, 0x4EE9 },
        { 0x59A8, 0x4EEA },
        { 0x599E, 0x4EEB },
        { 0x59A3, 0x4EEC },
        { 0x5999, 0x4EED },
        { 0x5996, 0x4EEE },
        { 0x598D, 0x4EEF },
        { 0x59A4, 0x4EF0 },
        { 0x5993, 0x4EF1 },
        { 0x598A, 0x4EF2 },
        { 0x59A5, 0x4EF3 },
        { 0x5B5D, 0x4EF4 },
        { 0x5B5C, 0x4EF5 },
        { 0x5B5A, 0x4EF6 },
        { 0x5B5B, 0x4EF7 },
        { 0x5B8C, 0x4EF8 },
        { 0x5B8B, 0x4EF9 },
        { 0x5B8F, 0x4EFA },
        { 0x5C2C, 0x4EFB },
        { 0x5C40, 0x4EFC },
        { 0x5C41, 0x4EFD },
        { 0x5C3F, 0x4F41 },
        { 0x5C3E, 0x4F42 },
        { 0x5C90, 0x4F43 },
        { 0x5C91, 0x4F44 },
        { 0x5C94, 0x4F45 },
        { 0x5C8C, 0x4F46 },
        { 0x5DEB, 0x4F47 },
        { 0x5E0C, 0x4F48 },
        { 0x5E8F, 0x4F49 },
        { 0x5E87, 0x4F4A },
        { 0x5E8A, 0x4F4B },
        { 0x5EF7, 0x4F4C },
        { 0x5F04, 0x4F4D },
        { 0x5F1F, 0x4F4E },
        { 0x5F64, 0x4F4F },
        { 0x5F62, 0x4F50 },
        { 0x5F77, 0x4F51 },
        { 0x5F79, 0x4F52 },
        { 0x5FD8, 0x4F53 },
        { 0x5FCC, 0x4F54 },
        { 0x5FD7, 0x4F55 },
        { 0x5FCD, 0x4F56 },
        { 0x5FF1, 0x4F57 },
        { 0x5FEB, 0x4F58 },
        { 0x5FF8, 0x4F59 },
        { 0x5FEA, 0x4F5A },
        { 0x6212, 0x4F5B },
        { 0x6211, 0x4F5C },
        { 0x6284, 0x4F5D },
        { 0x6297, 0x4F5E },
        { 0x6296, 0x4F5F },
        { 0x6280, 0x4F60 },
        { 0x6276, 0x4F61 },
        { 0x6289, 0x4F62 },
        { 0x626D, 0x4F63 },
        { 0x628A, 0x4F64 },
        { 0x627C, 0x4F65 },
        { 0x627E, 0x4F66 },
        { 0x6279, 0x4F67 },
        { 0x6273, 0x4F68 },
        { 0x6292, 0x4F69 },
        { 0x626F, 0x4F6A },
        { 0x6298, 0x4F6B },
        { 0x626E, 0x4F6C },
        { 0x6295, 0x4F6D },
        { 0x6293, 0x4F6E },
        { 0x6291, 0x4F6F },
        { 0x6286, 0x4F70 },
        { 0x6539, 0x4F71 },
        { 0x653B, 0x4F72 },
        { 0x6538, 0x4F73 },
        { 0x65F1, 0x4F74 },
        { 0x66F4, 0x4F75 },
        { 0x675F, 0x4F76 },
        { 0x674E, 0x4F77 },
        { 0x674F, 0x4F78 },
        { 0x6750, 0x4F79 },
        { 0x6751, 0x4F7A },
        { 0x675C, 0x4F7B },
        { 0x6756, 0x4F7C },
        { 0x675E, 0x4F7D },
        { 0x6749, 0x4F7E },
        { 0x6746, 0x4F7F },
        { 0x6760, 0x4F81 },
        { 0x6753, 0x4F82 },
        { 0x6757, 0x4F83 },
        { 0x6B65, 0x4F84 },
        { 0x6BCF, 0x4F85 },
        { 0x6C42, 0x4F86 },
        { 0x6C5E, 0x4F87 },
        { 0x6C99, 0x4F88 },
        { 0x6C81, 0x4F89 },
        { 0x6C88, 0x4F8A },
        { 0x6C89, 0x4F8B },
        { 0x6C85, 0x4F8C },
        { 0x6C9B, 0x4F8D },
        { 0x6C6A, 0x4F8E },
        { 0x6C7A, 0x4F8F },
        { 0x6C90, 0x4F90 },
        { 0x6C70, 0x4F91 },
        { 0x6C8C, 0x4F92 },
        { 0x6C68, 0x4F93 },
        { 0x6C96, 0x4F94 },
        { 0x6C92, 0x4F95 },
        { 0x6C7D, 0x4F96 },
        { 0x6C83, 0x4F97 },
        { 0x6C72, 0x4F98 },
        { 0x6C7E, 0x4F99 },
        { 0x6C74, 0x4F9A },
        { 0x6C86, 0x4F9B },
        { 0x6C76, 0x4F9C },
        { 0x6C8D, 0x4F9D },
        { 0x6C94, 0x4F9E },
        { 0x6C98, 0x4F9F },
        { 0x6C82, 0x4FA0 },
        { 0x7076, 0x4FA1 },
        { 0x707C, 0x4FA2 },
        { 0x707D, 0x4FA3 },
        { 0x7078, 0x4FA4 },
        { 0x7262, 0x4FA5 },
        { 0x7261, 0x4FA6 },
        { 0x7260, 0x4FA7 },
        { 0x72C4, 0x4FA8 },
        { 0x72C2, 0x4FA9 },
        { 0x7396, 0x4FAA },
        { 0x752C, 0x4FAB },
        { 0x752B, 0x4FAC },
        { 0x7537, 0x4FAD },
        { 0x7538, 0x4FAE },
        { 0x7682, 0x4FAF },
        { 0x76EF, 0x4FB0 },
        { 0x77E3, 0x4FB1 },
        { 0x79C1, 0x4FB2 },
        { 0x79C0, 0x4FB3 },
        { 0x79BF, 0x4FB4 },
        { 0x7A76, 0x4FB5 },
        { 0x7CFB, 0x4FB6 },
        { 0x7F55, 0x4FB7 },
        { 0x8096, 0x4FB8 },
        { 0x8093, 0x4FB9 },
        { 0x809D, 0x4FBA },
        { 0x8098, 0x4FBB },
        { 0x809B, 0x4FBC },
        { 0x809A, 0x4FBD },
        { 0x80B2, 0x4FBE },
        { 0x826F, 0x4FBF },
        { 0x8292, 0x4FC0 },
        { 0x828B, 0x4FC1 },
        { 0x828D, 0x4FC2 },
        { 0x898B, 0x4FC3 },
        { 0x89D2, 0x4FC4 },
        { 0x8A00, 0x4FC5 },
        { 0x8C37, 0x4FC6 },
        { 0x8C46, 0x4FC7 },
        { 0x8C55, 0x4FC8 },
        { 0x8C9D, 0x4FC9 },
        { 0x8D64, 0x4FCA },
        { 0x8D70, 0x4FCB },
        { 0x8DB3, 0x4FCC },
        { 0x8EAB, 0x4FCD },
        { 0x8ECA, 0x4FCE },
        { 0x8F9B, 0x4FCF },
        { 0x8FB0, 0x4FD0 },
        { 0x8FC2, 0x4FD1 },
        { 0x8FC6, 0x4FD2 },
        { 0x8FC5, 0x4FD3 },
        { 0x8FC4, 0x4FD4 },
        { 0x5DE1, 0x4FD5 },
        { 0x9091, 0x4FD6 },
        { 0x90A2, 0x4FD7 },
        { 0x90AA, 0x4FD8 },
        { 0x90A6, 0x4FD9 },
        { 0x90A3, 0x4FDA },
        { 0x9149, 0x4FDB },
        { 0x91C6, 0x4FDC },
        { 0x91CC, 0x4FDD },
        { 0x9632, 0x4FDE },
        { 0x962E, 0x4FDF },
        { 0x9631, 0x4FE0 },
        { 0x962A, 0x4FE1 },
        { 0x962C, 0x4FE2 },
        { 0x4E26, 0x4FE3 },
        { 0x4E56, 0x4FE4 },
        { 0x4E73, 0x4FE5 },
        { 0x4E8B, 0x4FE6 },
        { 0x4E9B, 0x4FE7 },
        { 0x4E9E, 0x4FE8 },
        { 0x4EAB, 0x4FE9 },
        { 0x4EAC, 0x4FEA },
        { 0x4F6F, 0x4FEB },
        { 0x4F9D, 0x4FEC },
        { 0x4F8D, 0x4FED },
        { 0x4F73, 0x4FEE },
        { 0x4F7F, 0x4FEF },
        { 0x4F6C, 0x4FF0 },
        { 0x4F9B, 0x4FF1 },
        { 0x4F8B, 0x4FF2 },
        { 0x4F86, 0x4FF3 },
        { 0x4F83, 0x4FF4 },
        { 0x4F70, 0x4FF5 },
        { 0x4F75, 0x4FF6 },
        { 0x4F88, 0x4FF7 },
        { 0x4F69, 0x4FF8 },
        { 0x4F7B, 0x4FF9 },
        { 0x4F96, 0x4FFA },
        { 0x4F7E, 0x4FFB },
        { 0x4F8F, 0x4FFC },
        { 0x4F91, 0x4FFD },
        { 0x4F7A, 0x5041 },
        { 0x5154, 0x5042 },
        { 0x5152, 0x5043 },
        { 0x5155, 0x5044 },
        { 0x5169, 0x5045 },
        { 0x5177, 0x5046 },
        { 0x5176, 0x5047 },
        { 0x5178, 0x5048 },
        { 0x51BD, 0x5049 },
        { 0x51FD, 0x504A },
        { 0x523B, 0x504B },
        { 0x5238, 0x504C },
        { 0x5237, 0x504D },
        { 0x523A, 0x504E },
        { 0x5230, 0x504F },
        { 0x522E, 0x5050 },
        { 0x5236, 0x5051 },
        { 0x5241, 0x5052 },
        { 0x52BE, 0x5053 },
        { 0x52BB, 0x5054 },
        { 0x5352, 0x5055 },
        { 0x5354, 0x5056 },
        { 0x5353, 0x5057 },
        { 0x5351, 0x5058 },
        { 0x5366, 0x5059 },
        { 0x5377, 0x505A },
        { 0x5378, 0x505B },
        { 0x5379, 0x505C },
        { 0x53D6, 0x505D },
        { 0x53D4, 0x505E },
        { 0x53D7, 0x505F },
        { 0x5473, 0x5060 },
        { 0x5475, 0x5061 },
        { 0x5496, 0x5062 },
        { 0x5478, 0x5063 },
        { 0x5495, 0x5064 },
        { 0x5480, 0x5065 },
        { 0x547B, 0x5066 },
        { 0x5477, 0x5067 },
        { 0x5484, 0x5068 },
        { 0x5492, 0x5069 },
        { 0x5486, 0x506A },
        { 0x547C, 0x506B },
        { 0x5490, 0x506C },
        { 0x5471, 0x506D },
        { 0x5476, 0x506E },
        { 0x548C, 0x506F },
        { 0x549A, 0x5070 },
        { 0x5462, 0x5071 },
        { 0x5468, 0x5072 },
        { 0x548B, 0x5073 },
        { 0x547D, 0x5074 },
        { 0x548E, 0x5075 },
        { 0x56FA, 0x5076 },
        { 0x5783, 0x5077 },
        { 0x5777, 0x5078 },
        { 0x576A, 0x5079 },
        { 0x5769, 0x507A },
        { 0x5761, 0x507B },
        { 0x5766, 0x507C },
        { 0x5764, 0x507D },
        { 0x577C, 0x507E },
        { 0x591C, 0x507F },
        { 0x5949, 0x5081 },
        { 0x5947, 0x5082 },
        { 0x5948, 0x5083 },
        { 0x5944, 0x5084 },
        { 0x5954, 0x5085 },
        { 0x59BE, 0x5086 },
        { 0x59BB, 0x5087 },
        { 0x59D4, 0x5088 },
        { 0x59B9, 0x5089 },
        { 0x59AE, 0x508A },
        { 0x59D1, 0x508B },
        { 0x59C6, 0x508C },
        { 0x59D0, 0x508D },
        { 0x59CD, 0x508E },
        { 0x59CB, 0x508F },
        { 0x59D3, 0x5090 },
        { 0x59CA, 0x5091 },
        { 0x59AF, 0x5092 },
        { 0x59B3, 0x5093 },
        { 0x59D2, 0x5094 },
        { 0x59C5, 0x5095 },
        { 0x5B5F, 0x5096 },
        { 0x5B64, 0x5097 },
        { 0x5B63, 0x5098 },
        { 0x5B97, 0x5099 },
        { 0x5B9A, 0x509A },
        { 0x5B98, 0x509B },
        { 0x5B9C, 0x509C },
        { 0x5B99, 0x509D },
        { 0x5B9B, 0x509E },
        { 0x5C1A, 0x509F },
        { 0x5C48, 0x50A0 },
        { 0x5C45, 0x50A1 },
        { 0x5C46, 0x50A2 },
        { 0x5CB7, 0x50A3 },
        { 0x5CA1, 0x50A4 },
        { 0x5CB8, 0x50A5 },
        { 0x5CA9, 0x50A6 },
        { 0x5CAB, 0x50A7 },
        { 0x5CB1, 0x50A8 },
        { 0x5CB3, 0x50A9 },
        { 0x5E18, 0x50AA },
        { 0x5E1A, 0x50AB },
        { 0x5E16, 0x50AC },
        { 0x5E15, 0x50AD },
        { 0x5E1B, 0x50AE },
        { 0x5E11, 0x50AF },
        { 0x5E78, 0x50B0 },
        { 0x5E9A, 0x50B1 },
        { 0x5E97, 0x50B2 },
        { 0x5E9C, 0x50B3 },
        { 0x5E95, 0x50B4 },
        { 0x5E96, 0x50B5 },
        { 0x5EF6, 0x50B6 },
        { 0x5F26, 0x50B7 },
        { 0x5F27, 0x50B8 },
        { 0x5F29, 0x50B9 },
        { 0x5F80, 0x50BA },
        { 0x5F81, 0x50BB },
        { 0x5F7F, 0x50BC },
        { 0x5F7C, 0x50BD },
        { 0x5FDD, 0x50BE },
        { 0x5FE0, 0x50BF },
        { 0x5FFD, 0x50C0 },
        { 0x5FF5, 0x50C1 },
        { 0x5FFF, 0x50C2 },
        { 0x600F, 0x50C3 },
        { 0x6014, 0x50C4 },
        { 0x602F, 0x50C5 },
        { 0x6035, 0x50C6 },
        { 0x6016, 0x50C7 },
        { 0x602A, 0x50C8 },
        { 0x6015, 0x50C9 },
        { 0x6021, 0x50CA },
        { 0x6027, 0x50CB },
        { 0x6029, 0x50CC },
        { 0x602B, 0x50CD },
        { 0x601B, 0x50CE },
        { 0x6216, 0x50CF },
        { 0x6215, 0x50D0 },
        { 0x623F, 0x50D1 },
        { 0x623E, 0x50D2 },
        { 0x6240, 0x50D3 },
        { 0x627F, 0x50D4 },
        { 0x62C9, 0x50D5 },
        { 0x62CC, 0x50D6 },
        { 0x62C4, 0x50D7 },
        { 0x62BF, 0x50D8 },
        { 0x62C2, 0x50D9 },
        { 0x62B9, 0x50DA },
        { 0x62D2, 0x50DB },
        { 0x62DB, 0x50DC },
        { 0x62AB, 0x50DD },
        { 0x62D3, 0x50DE },
        { 0x62D4, 0x50DF },
        { 0x62CB, 0x50E0 },
        { 0x62C8, 0x50E1 },
        { 0x62A8, 0x50E2 },
        { 0x62BD, 0x50E3 },
        { 0x62BC, 0x50E4 },
        { 0x62D0, 0x50E5 },
        { 0x62D9, 0x50E6 },
        { 0x62C7, 0x50E7 },
        { 0x62CD, 0x50E8 },
        { 0x62B5, 0x50E9 },
        { 0x62DA, 0x50EA },
        { 0x62B1, 0x50EB },
        { 0x62D8, 0x50EC },
        { 0x62D6, 0x50ED },
        { 0x62D7, 0x50EE },
        { 0x62C6, 0x50EF },
        { 0x62AC, 0x50F0 },
        { 0x62CE, 0x50F1 },
        { 0x653E, 0x50F2 },
        { 0x65A7, 0x50F3 },
        { 0x65BC, 0x50F4 },
        { 0x65FA, 0x50F5 },
        { 0x6614, 0x50F6 },
        { 0x6613, 0x50F7 },
        { 0x660C, 0x50F8 },
        { 0x6606, 0x50F9 },
        { 0x6602, 0x50FA },
        { 0x660E, 0x50FB },
        { 0x6600, 0x50FC },
        { 0x660F, 0x50FD },
        { 0x6615, 0x5141 },
        { 0x660A, 0x5142 },
        { 0x6607, 0x5143 },
        { 0x670D, 0x5144 },
        { 0x670B, 0x5145 },
        { 0x676D, 0x5146 },
        { 0x678B, 0x5147 },
        { 0x6795, 0x5148 },
        { 0x6771, 0x5149 },
        { 0x679C, 0x514A },
        { 0x6773, 0x514B },
        { 0x6777, 0x514C },
        { 0x6787, 0x514D },
        { 0x679D, 0x514E },
        { 0x6797, 0x514F },
        { 0x676F, 0x5150 },
        { 0x6770, 0x5151 },
        { 0x677F, 0x5152 },
        { 0x6789, 0x5153 },
        { 0x677E, 0x5154 },
        { 0x6790, 0x5155 },
        { 0x6775, 0x5156 },
        { 0x679A, 0x5157 },
        { 0x6793, 0x5158 },
        { 0x677C, 0x5159 },
        { 0x676A, 0x515A },
        { 0x6772, 0x515B },
        { 0x6B23, 0x515C },
        { 0x6B66, 0x515D },
        { 0x6B67, 0x515E },
        { 0x6B7F, 0x515F },
        { 0x6C13, 0x5160 },
        { 0x6C1B, 0x5161 },
        { 0x6CE3, 0x5162 },
        { 0x6CE8, 0x5163 },
        { 0x6CF3, 0x5164 },
        { 0x6CB1, 0x5165 },
        { 0x6CCC, 0x5166 },
        { 0x6CE5, 0x5167 },
        { 0x6CB3, 0x5168 },
        { 0x6CBD, 0x5169 },
        { 0x6CBE, 0x516A },
        { 0x6CBC, 0x516B },
        { 0x6CE2, 0x516C },
        { 0x6CAB, 0x516D },
        { 0x6CD5, 0x516E },
        { 0x6CD3, 0x516F },
        { 0x6CB8, 0x5170 },
        { 0x6CC4, 0x5171 },
        { 0x6CB9, 0x5172 },
        { 0x6CC1, 0x5173 },
        { 0x6CAE, 0x5174 },
        { 0x6CD7, 0x5175 },
        { 0x6CC5, 0x5176 },
        { 0x6CF1, 0x5177 },
        { 0x6CBF, 0x5178 },
        { 0x6CBB, 0x5179 },
        { 0x6CE1, 0x517A },
        { 0x6CDB, 0x517B },
        { 0x6CCA, 0x517C },
        { 0x6CAC, 0x517D },
        { 0x6CEF, 0x517E },
        { 0x6CDC, 0x517F },
        { 0x6CD6, 0x5181 },
        { 0x6CE0, 0x5182 },
        { 0x7095, 0x5183 },
        { 0x708E, 0x5184 },
        { 0x7092, 0x5185 },
        { 0x708A, 0x5186 },
        { 0x7099, 0x5187 },
        { 0x722C, 0x5188 },
        { 0x722D, 0x5189 },
        { 0x7238, 0x518A },
        { 0x7248, 0x518B },
        { 0x7267, 0x518C },
        { 0x7269, 0x518D },
        { 0x72C0, 0x518E },
        { 0x72CE, 0x518F },
        { 0x72D9, 0x5190 },
        { 0x72D7, 0x5191 },
        { 0x72D0, 0x5192 },
        { 0x73A9, 0x5193 },
        { 0x73A8, 0x5194 },
        { 0x739F, 0x5195 },
        { 0x73AB, 0x5196 },
        { 0x73A5, 0x5197 },
        { 0x753D, 0x5198 },
        { 0x759D, 0x5199 },
        { 0x7599, 0x519A },
        { 0x759A, 0x519B },
        { 0x7684, 0x519C },
        { 0x76C2, 0x519D },
        { 0x76F2, 0x519E },
        { 0x76F4, 0x519F },
        { 0x77E5, 0x51A0 },
        { 0x77FD, 0x51A1 },
        { 0x793E, 0x51A2 },
        { 0x7940, 0x51A3 },
        { 0x7941, 0x51A4 },
        { 0x79C9, 0x51A5 },
        { 0x79C8, 0x51A6 },
        { 0x7A7A, 0x51A7 },
        { 0x7A79, 0x51A8 },
        { 0x7AFA, 0x51A9 },
        { 0x7CFE, 0x51AA },
        { 0x7F54, 0x51AB },
        { 0x7F8C, 0x51AC },
        { 0x7F8B, 0x51AD },
        { 0x8005, 0x51AE },
        { 0x80BA, 0x51AF },
        { 0x80A5, 0x51B0 },
        { 0x80A2, 0x51B1 },
        { 0x80B1, 0x51B2 },
        { 0x80A1, 0x51B3 },
        { 0x80AB, 0x51B4 },
        { 0x80A9, 0x51B5 },
        { 0x80B4, 0x51B6 },
        { 0x80AA, 0x51B7 },
        { 0x80AF, 0x51B8 },
        { 0x81E5, 0x51B9 },
        { 0x81FE, 0x51BA },
        { 0x820D, 0x51BB },
        { 0x82B3, 0x51BC },
        { 0x829D, 0x51BD },
        { 0x8299, 0x51BE },
        { 0x82AD, 0x51BF },
        { 0x82BD, 0x51C0 },
        { 0x829F, 0x51C1 },
        { 0x82B9, 0x51C2 },
        { 0x82B1, 0x51C3 },
        { 0x82AC, 0x51C4 },
        { 0x82A5, 0x51C5 },
        { 0x82AF, 0x51C6 },
        { 0x82B8, 0x51C7 },
        { 0x82A3, 0x51C8 },
        { 0x82B0, 0x51C9 },
        { 0x82BE, 0x51CA },
        { 0x82B7, 0x51CB },
        { 0x864E, 0x51CC },
        { 0x8671, 0x51CD },
        { 0x521D, 0x51CE },
        { 0x8868, 0x51CF },
        { 0x8ECB, 0x51D0 },
        { 0x8FCE, 0x51D1 },
        { 0x8FD4, 0x51D2 },
        { 0x8FD1, 0x51D3 },
        { 0x90B5, 0x51D4 },
        { 0x90B8, 0x51D5 },
        { 0x90B1, 0x51D6 },
        { 0x90B6, 0x51D7 },
        { 0x91C7, 0x51D8 },
        { 0x91D1, 0x51D9 },
        { 0x9577, 0x51DA },
        { 0x9580, 0x51DB },
        { 0x961C, 0x51DC },
        { 0x9640, 0x51DD },
        { 0x963F, 0x51DE },
        { 0x963B, 0x51DF },
        { 0x9644, 0x51E0 },
        { 0x9642, 0x51E1 },
        { 0x96B9, 0x51E2 },
        { 0x96E8, 0x51E3 },
        { 0x9752, 0x51E4 },
        { 0x975E, 0x51E5 },
        { 0x4E9F, 0x51E6 },
        { 0x4EAD, 0x51E7 },
        { 0x4EAE, 0x51E8 },
        { 0x4FE1, 0x51E9 },
        { 0x4FB5, 0x51EA },
        { 0x4FAF, 0x51EB },
        { 0x4FBF, 0x51EC },
        { 0x4FE0, 0x51ED },
        { 0x4FD1, 0x51EE },
        { 0x4FCF, 0x51EF },
        { 0x4FDD, 0x51F0 },
        { 0x4FC3, 0x51F1 },
        { 0x4FB6, 0x51F2 },
        { 0x4FD8, 0x51F3 },
        { 0x4FDF, 0x51F4 },
        { 0x4FCA, 0x51F5 },
        { 0x4FD7, 0x51F6 },
        { 0x4FAE, 0x51F7 },
        { 0x4FD0, 0x51F8 },
        { 0x4FC4, 0x51F9 },
        { 0x4FC2, 0x51FA },
        { 0x4FDA, 0x51FB },
        { 0x4FCE, 0x51FC },
        { 0x4FDE, 0x51FD },
        { 0x4FB7, 0x5241 },
        { 0x5157, 0x5242 },
        { 0x5192, 0x5243 },
        { 0x5191, 0x5244 },
        { 0x51A0, 0x5245 },
        { 0x524E, 0x5246 },
        { 0x5243, 0x5247 },
        { 0x524A, 0x5248 },
        { 0x524D, 0x5249 },
        { 0x524C, 0x524A },
        { 0x524B, 0x524B },
        { 0x5247, 0x524C },
        { 0x52C7, 0x524D },
        { 0x52C9, 0x524E },
        { 0x52C3, 0x524F },
        { 0x52C1, 0x5250 },
        { 0x530D, 0x5251 },
        { 0x5357, 0x5252 },
        { 0x537B, 0x5253 },
        { 0x539A, 0x5254 },
        { 0x53DB, 0x5255 },
        { 0x54AC, 0x5256 },
        { 0x54C0, 0x5257 },
        { 0x54A8, 0x5258 },
        { 0x54CE, 0x5259 },
        { 0x54C9, 0x525A },
        { 0x54B8, 0x525B },
        { 0x54A6, 0x525C },
        { 0x54B3, 0x525D },
        { 0x54C7, 0x525E },
        { 0x54C2, 0x525F },
        { 0x54BD, 0x5260 },
        { 0x54AA, 0x5261 },
        { 0x54C1, 0x5262 },
        { 0x54C4, 0x5263 },
        { 0x54C8, 0x5264 },
        { 0x54AF, 0x5265 },
        { 0x54AB, 0x5266 },
        { 0x54B1, 0x5267 },
        { 0x54BB, 0x5268 },
        { 0x54A9, 0x5269 },
        { 0x54A7, 0x526A },
        { 0x54BF, 0x526B },
        { 0x56FF, 0x526C },
        { 0x5782, 0x526D },
        { 0x578B, 0x526E },
        { 0x57A0, 0x526F },
        { 0x57A3, 0x5270 },
        { 0x57A2, 0x5271 },
        { 0x57CE, 0x5272 },
        { 0x57AE, 0x5273 },
        { 0x5793, 0x5274 },
        { 0x5955, 0x5275 },
        { 0x5951, 0x5276 },
        { 0x594F, 0x5277 },
        { 0x594E, 0x5278 },
        { 0x5950, 0x5279 },
        { 0x59DC, 0x527A },
        { 0x59D8, 0x527B },
        { 0x59FF, 0x527C },
        { 0x59E3, 0x527D },
        { 0x59E8, 0x527E },
        { 0x5A03, 0x527F },
        { 0x59E5, 0x5281 },
        { 0x59EA, 0x5282 },
        { 0x59DA, 0x5283 },
        { 0x59E6, 0x5284 },
        { 0x5A01, 0x5285 },
        { 0x59FB, 0x5286 },
        { 0x5B69, 0x5287 },
        { 0x5BA3, 0x5288 },
        { 0x5BA6, 0x5289 },
        { 0x5BA4, 0x528A },
        { 0x5BA2, 0x528B },
        { 0x5BA5, 0x528C },
        { 0x5C01, 0x528D },
        { 0x5C4E, 0x528E },
        { 0x5C4F, 0x528F },
        { 0x5C4D, 0x5290 },
        { 0x5C4B, 0x5291 },
        { 0x5CD9, 0x5292 },
        { 0x5CD2, 0x5293 },
        { 0x5DF7, 0x5294 },
        { 0x5E1D, 0x5295 },
        { 0x5E25, 0x5296 },
        { 0x5E1F, 0x5297 },
        { 0x5E7D, 0x5298 },
        { 0x5EA0, 0x5299 },
        { 0x5EA6, 0x529A },
        { 0x5EFA, 0x529B },
        { 0x5F08, 0x529C },
        { 0x5F2D, 0x529D },
        { 0x5F65, 0x529E },
        { 0x5F88, 0x529F },
        { 0x5F85, 0x52A0 },
        { 0x5F8A, 0x52A1 },
        { 0x5F8B, 0x52A2 },
        { 0x5F87, 0x52A3 },
        { 0x5F8C, 0x52A4 },
        { 0x5F89, 0x52A5 },
        { 0x6012, 0x52A6 },
        { 0x601D, 0x52A7 },
        { 0x6020, 0x52A8 },
        { 0x6025, 0x52A9 },
        { 0x600E, 0x52AA },
        { 0x6028, 0x52AB },
        { 0x604D, 0x52AC },
        { 0x6070, 0x52AD },
        { 0x6068, 0x52AE },
        { 0x6062, 0x52AF },
        { 0x6046, 0x52B0 },
        { 0x6043, 0x52B1 },
        { 0x606C, 0x52B2 },
        { 0x606B, 0x52B3 },
        { 0x606A, 0x52B4 },
        { 0x6064, 0x52B5 },
        { 0x6241, 0x52B6 },
        { 0x62DC, 0x52B7 },
        { 0x6316, 0x52B8 },
        { 0x6309, 0x52B9 },
        { 0x62FC, 0x52BA },
        { 0x62ED, 0x52BB },
        { 0x6301, 0x52BC },
        { 0x62EE, 0x52BD },
        { 0x62FD, 0x52BE },
        { 0x6307, 0x52BF },
        { 0x62F1, 0x52C0 },
        { 0x62F7, 0x52C1 },
        { 0x62EF, 0x52C2 },
        { 0x62EC, 0x52C3 },
        { 0x62FE, 0x52C4 },
        { 0x62F4, 0x52C5 },
        { 0x6311, 0x52C6 },
        { 0x6302, 0x52C7 },
        { 0x653F, 0x52C8 },
        { 0x6545, 0x52C9 },
        { 0x65AB, 0x52CA },
        { 0x65BD, 0x52CB },
        { 0x65E2, 0x52CC },
        { 0x6625, 0x52CD },
        { 0x662D, 0x52CE },
        { 0x6620, 0x52CF },
        { 0x6627, 0x52D0 },
        { 0x662F, 0x52D1 },
        { 0x661F, 0x52D2 },
        { 0x6628, 0x52D3 },
        { 0x6631, 0x52D4 },
        { 0x6624, 0x52D5 },
        { 0x66F7, 0x52D6 },
        { 0x67FF, 0x52D7 },
        { 0x67D3, 0x52D8 },
        { 0x67F1, 0x52D9 },
        { 0x67D4, 0x52DA },
        { 0x67D0, 0x52DB },
        { 0x67EC, 0x52DC },
        { 0x67B6, 0x52DD },
        { 0x67AF, 0x52DE },
        { 0x67F5, 0x52DF },
        { 0x67E9, 0x52E0 },
        { 0x67EF, 0x52E1 },
        { 0x67C4, 0x52E2 },
        { 0x67D1, 0x52E3 },
        { 0x67B4, 0x52E4 },
        { 0x67DA, 0x52E5 },
        { 0x67E5, 0x52E6 },
        { 0x67B8, 0x52E7 },
        { 0x67CF, 0x52E8 },
        { 0x67DE, 0x52E9 },
        { 0x67F3, 0x52EA },
        { 0x67B0, 0x52EB },
        { 0x67D9, 0x52EC },
        { 0x67E2, 0x52ED },
        { 0x67DD, 0x52EE },
        { 0x67D2, 0x52EF },
        { 0x6B6A, 0x52F0 },
        { 0x6B83, 0x52F1 },
        { 0x6B86, 0x52F2 },
        { 0x6BB5, 0x52F3 },
        { 0x6BD2, 0x52F4 },
        { 0x6BD7, 0x52F5 },
        { 0x6C1F, 0x52F6 },
        { 0x6CC9, 0x52F7 },
        { 0x6D0B, 0x52F8 },
        { 0x6D32, 0x52F9 },
        { 0x6D2A, 0x52FA },
        { 0x6D41, 0x52FB },
        { 0x6D25, 0x52FC },
        { 0x6D0C, 0x52FD },
        { 0x6D31, 0x5341 },
        { 0x6D1E, 0x5342 },
        { 0x6D17, 0x5343 },
        { 0x6D3B, 0x5344 },
        { 0x6D3D, 0x5345 },
        { 0x6D3E, 0x5346 },
        { 0x6D36, 0x5347 },
        { 0x6D1B, 0x5348 },
        { 0x6CF5, 0x5349 },
        { 0x6D39, 0x534A },
        { 0x6D27, 0x534B },
        { 0x6D38, 0x534C },
        { 0x6D29, 0x534D },
        { 0x6D2E, 0x534E },
        { 0x6D35, 0x534F },
        { 0x6D0E, 0x5350 },
        { 0x6D2B, 0x5351 },
        { 0x70AB, 0x5352 },
        { 0x70BA, 0x5353 },
        { 0x70B3, 0x5354 },
        { 0x70AC, 0x5355 },
        { 0x70AF, 0x5356 },
        { 0x70AD, 0x5357 },
        { 0x70B8, 0x5358 },
        { 0x70AE, 0x5359 },
        { 0x70A4, 0x535A },
        { 0x7230, 0x535B },
        { 0x7272, 0x535C },
        { 0x726F, 0x535D },
        { 0x7274, 0x535E },
        { 0x72E9, 0x535F },
        { 0x72E0, 0x5360 },
        { 0x72E1, 0x5361 },
        { 0x73B7, 0x5362 },
        { 0x73CA, 0x5363 },
        { 0x73BB, 0x5364 },
        { 0x73B2, 0x5365 },
        { 0x73CD, 0x5366 },
        { 0x73C0, 0x5367 },
        { 0x73B3, 0x5368 },
        { 0x751A, 0x5369 },
        { 0x752D, 0x536A },
        { 0x754F, 0x536B },
        { 0x754C, 0x536C },
        { 0x754E, 0x536D },
        { 0x754B, 0x536E },
        { 0x75AB, 0x536F },
        { 0x75A4, 0x5370 },
        { 0x75A5, 0x5371 },
        { 0x75A2, 0x5372 },
        { 0x75A3, 0x5373 },
        { 0x7678, 0x5374 },
        { 0x7686, 0x5375 },
        { 0x7687, 0x5376 },
        { 0x7688, 0x5377 },
        { 0x76C8, 0x5378 },
        { 0x76C6, 0x5379 },
        { 0x76C3, 0x537A },
        { 0x76C5, 0x537B },
        { 0x7701, 0x537C },
        { 0x76F9, 0x537D },
        { 0x76F8, 0x537E },
        { 0x7709, 0x537F },
        { 0x770B, 0x5381 },
        { 0x76FE, 0x5382 },
        { 0x76FC, 0x5383 },
        { 0x7707, 0x5384 },
        { 0x77DC, 0x5385 },
        { 0x7802, 0x5386 },
        { 0x7814, 0x5387 },
        { 0x780C, 0x5388 },
        { 0x780D, 0x5389 },
        { 0x7946, 0x538A },
        { 0x7949, 0x538B },
        { 0x7948, 0x538C },
        { 0x7947, 0x538D },
        { 0x79B9, 0x538E },
        { 0x79BA, 0x538F },
        { 0x79D1, 0x5390 },
        { 0x79D2, 0x5391 },
        { 0x79CB, 0x5392 },
        { 0x7A7F, 0x5393 },
        { 0x7A81, 0x5394 },
        { 0x7AFF, 0x5395 },
        { 0x7AFD, 0x5396 },
        { 0x7C7D, 0x5397 },
        { 0x7D02, 0x5398 },
        { 0x7D05, 0x5399 },
        { 0x7D00, 0x539A },
        { 0x7D09, 0x539B },
        { 0x7D07, 0x539C },
        { 0x7D04, 0x539D },
        { 0x7D06, 0x539E },
        { 0x7F38, 0x539F },
        { 0x7F8E, 0x53A0 },
        { 0x7FBF, 0x53A1 },
        { 0x8004, 0x53A2 },
        { 0x8010, 0x53A3 },
        { 0x800D, 0x53A4 },
        { 0x8011, 0x53A5 },
        { 0x8036, 0x53A6 },
        { 0x80D6, 0x53A7 },
        { 0x80E5, 0x53A8 },
        { 0x80DA, 0x53A9 },
        { 0x80C3, 0x53AA },
        { 0x80C4, 0x53AB },
        { 0x80CC, 0x53AC },
        { 0x80E1, 0x53AD },
        { 0x80DB, 0x53AE },
        { 0x80CE, 0x53AF },
        { 0x80DE, 0x53B0 },
        { 0x80E4, 0x53B1 },
        { 0x80DD, 0x53B2 },
        { 0x81F4, 0x53B3 },
        { 0x8222, 0x53B4 },
        { 0x82E7, 0x53B5 },
        { 0x8303, 0x53B6 },
        { 0x8305, 0x53B7 },
        { 0x82E3, 0x53B8 },
        { 0x82DB, 0x53B9 },
        { 0x82E6, 0x53BA },
        { 0x8304, 0x53BB },
        { 0x82E5, 0x53BC },
        { 0x8302, 0x53BD },
        { 0x8309, 0x53BE },
        { 0x82D2, 0x53BF },
        { 0x82D7, 0x53C0 },
        { 0x82F1, 0x53C1 },
        { 0x8301, 0x53C2 },
        { 0x82DC, 0x53C3 },
        { 0x82D4, 0x53C4 },
        { 0x82D1, 0x53C5 },
        { 0x82DE, 0x53C6 },
        { 0x82D3, 0x53C7 },
        { 0x82DF, 0x53C8 },
        { 0x82EF, 0x53C9 },
        { 0x8306, 0x53CA },
        { 0x8650, 0x53CB },
        { 0x8679, 0x53CC },
        { 0x867B, 0x53CD },
        { 0x867A, 0x53CE },
        { 0x884D, 0x53CF },
        { 0x886B, 0x53D0 },
        { 0x8981, 0x53D1 },
        { 0x89D4, 0x53D2 },
        { 0x8A08, 0x53D3 },
        { 0x8A02, 0x53D4 },
        { 0x8A03, 0x53D5 },
        { 0x8C9E, 0x53D6 },
        { 0x8CA0, 0x53D7 },
        { 0x8D74, 0x53D8 },
        { 0x8D73, 0x53D9 },
        { 0x8DB4, 0x53DA },
        { 0x8ECD, 0x53DB },
        { 0x8ECC, 0x53DC },
        { 0x8FF0, 0x53DD },
        { 0x8FE6, 0x53DE },
        { 0x8FE2, 0x53DF },
        { 0x8FEA, 0x53E0 },
        { 0x8FE5, 0x53E1 },
        { 0x8FED, 0x53E2 },
        { 0x8FEB, 0x53E3 },
        { 0x8FE4, 0x53E4 },
        { 0x8FE8, 0x53E5 },
        { 0x90CA, 0x53E6 },
        { 0x90CE, 0x53E7 },
        { 0x90C1, 0x53E8 },
        { 0x90C3, 0x53E9 },
        { 0x914B, 0x53EA },
        { 0x914A, 0x53EB },
        { 0x91CD, 0x53EC },
        { 0x9582, 0x53ED },
        { 0x9650, 0x53EE },
        { 0x964B, 0x53EF },
        { 0x964C, 0x53F0 },
        { 0x964D, 0x53F1 },
        { 0x9762, 0x53F2 },
        { 0x9769, 0x53F3 },
        { 0x97CB, 0x53F4 },
        { 0x97ED, 0x53F5 },
        { 0x97F3, 0x53F6 },
        { 0x9801, 0x53F7 },
        { 0x98A8, 0x53F8 },
        { 0x98DB, 0x53F9 },
        { 0x98DF, 0x53FA },
        { 0x9996, 0x53FB },
        { 0x9999, 0x53FC },
        { 0x4E58, 0x53FD },
        { 0x4EB3, 0x5441 },
        { 0x500C, 0x5442 },
        { 0x500D, 0x5443 },
        { 0x5023, 0x5444 },
        { 0x4FEF, 0x5445 },
        { 0x5026, 0x5446 },
        { 0x5025, 0x5447 },
        { 0x4FF8, 0x5448 },
        { 0x5029, 0x5449 },
        { 0x5016, 0x544A },
        { 0x5006, 0x544B },
        { 0x503C, 0x544C },
        { 0x501F, 0x544D },
        { 0x501A, 0x544E },
        { 0x5012, 0x544F },
        { 0x5011, 0x5450 },
        { 0x4FFA, 0x5451 },
        { 0x5000, 0x5452 },
        { 0x5014, 0x5453 },
        { 0x5028, 0x5454 },
        { 0x4FF1, 0x5455 },
        { 0x5021, 0x5456 },
        { 0x500B, 0x5457 },
        { 0x5019, 0x5458 },
        { 0x5018, 0x5459 },
        { 0x4FF3, 0x545A },
        { 0x4FEE, 0x545B },
        { 0x502D, 0x545C },
        { 0x502A, 0x545D },
        { 0x4FFE, 0x545E },
        { 0x502B, 0x545F },
        { 0x5009, 0x5460 },
        { 0x517C, 0x5461 },
        { 0x51A4, 0x5462 },
        { 0x51A5, 0x5463 },
        { 0x51A2, 0x5464 },
        { 0x51CD, 0x5465 },
        { 0x51CC, 0x5466 },
        { 0x51C6, 0x5467 },
        { 0x51CB, 0x5468 },
        { 0x5256, 0x5469 },
        { 0x525C, 0x546A },
        { 0x5254, 0x546B },
        { 0x525B, 0x546C },
        { 0x525D, 0x546D },
        { 0x532A, 0x546E },
        { 0x537F, 0x546F },
        { 0x539F, 0x5470 },
        { 0x539D, 0x5471 },
        { 0x53DF, 0x5472 },
        { 0x54E8, 0x5473 },
        { 0x5510, 0x5474 },
        { 0x5501, 0x5475 },
        { 0x5537, 0x5476 },
        { 0x54FC, 0x5477 },
        { 0x54E5, 0x5478 },
        { 0x54F2, 0x5479 },
        { 0x5506, 0x547A },
        { 0x54FA, 0x547B },
        { 0x5514, 0x547C },
        { 0x54E9, 0x547D },
        { 0x54ED, 0x547E },
        { 0x54E1, 0x547F },
        { 0x5509, 0x5481 },
        { 0x54EE, 0x5482 },
        { 0x54EA, 0x5483 },
        { 0x54E6, 0x5484 },
        { 0x5527, 0x5485 },
        { 0x5507, 0x5486 },
        { 0x54FD, 0x5487 },
        { 0x550F, 0x5488 },
        { 0x5703, 0x5489 },
        { 0x5704, 0x548A },
        { 0x57C2, 0x548B },
        { 0x57D4, 0x548C },
        { 0x57CB, 0x548D },
        { 0x57C3, 0x548E },
        { 0x5809, 0x548F },
        { 0x590F, 0x5490 },
        { 0x5957, 0x5491 },
        { 0x5958, 0x5492 },
        { 0x595A, 0x5493 },
        { 0x5A11, 0x5494 },
        { 0x5A18, 0x5495 },
        { 0x5A1C, 0x5496 },
        { 0x5A1F, 0x5497 },
        { 0x5A1B, 0x5498 },
        { 0x5A13, 0x5499 },
        { 0x59EC, 0x549A },
        { 0x5A20, 0x549B },
        { 0x5A23, 0x549C },
        { 0x5A29, 0x549D },
        { 0x5A25, 0x549E },
        { 0x5A0C, 0x549F },
        { 0x5A09, 0x54A0 },
        { 0x5B6B, 0x54A1 },
        { 0x5C58, 0x54A2 },
        { 0x5BB0, 0x54A3 },
        { 0x5BB3, 0x54A4 },
        { 0x5BB6, 0x54A5 },
        { 0x5BB4, 0x54A6 },
        { 0x5BAE, 0x54A7 },
        { 0x5BB5, 0x54A8 },
        { 0x5BB9, 0x54A9 },
        { 0x5BB8, 0x54AA },
        { 0x5C04, 0x54AB },
        { 0x5C51, 0x54AC },
        { 0x5C55, 0x54AD },
        { 0x5C50, 0x54AE },
        { 0x5CED, 0x54AF },
        { 0x5CFD, 0x54B0 },
        { 0x5CFB, 0x54B1 },
        { 0x5CEA, 0x54B2 },
        { 0x5CE8, 0x54B3 },
        { 0x5CF0, 0x54B4 },
        { 0x5CF6, 0x54B5 },
        { 0x5D01, 0x54B6 },
        { 0x5CF4, 0x54B7 },
        { 0x5DEE, 0x54B8 },
        { 0x5E2D, 0x54B9 },
        { 0x5E2B, 0x54BA },
        { 0x5EAB, 0x54BB },
        { 0x5EAD, 0x54BC },
        { 0x5EA7, 0x54BD },
        { 0x5F31, 0x54BE },
        { 0x5F92, 0x54BF },
        { 0x5F91, 0x54C0 },
        { 0x5F90, 0x54C1 },
        { 0x6059, 0x54C2 },
        { 0x6063, 0x54C3 },
        { 0x6065, 0x54C4 },
        { 0x6050, 0x54C5 },
        { 0x6055, 0x54C6 },
        { 0x606D, 0x54C7 },
        { 0x6069, 0x54C8 },
        { 0x606F, 0x54C9 },
        { 0x6084, 0x54CA },
        { 0x609F, 0x54CB },
        { 0x609A, 0x54CC },
        { 0x608D, 0x54CD },
        { 0x6094, 0x54CE },
        { 0x608C, 0x54CF },
        { 0x6085, 0x54D0 },
        { 0x6096, 0x54D1 },
        { 0x6247, 0x54D2 },
        { 0x62F3, 0x54D3 },
        { 0x6308, 0x54D4 },
        { 0x62FF, 0x54D5 },
        { 0x634E, 0x54D6 },
        { 0x633E, 0x54D7 },
        { 0x632F, 0x54D8 },
        { 0x6355, 0x54D9 },
        { 0x6342, 0x54DA },
        { 0x6346, 0x54DB },
        { 0x634F, 0x54DC },
        { 0x6349, 0x54DD },
        { 0x633A, 0x54DE },
        { 0x6350, 0x54DF },
        { 0x633D, 0x54E0 },
        { 0x632A, 0x54E1 },
        { 0x632B, 0x54E2 },
        { 0x6328, 0x54E3 },
        { 0x634D, 0x54E4 },
        { 0x634C, 0x54E5 },
        { 0x6548, 0x54E6 },
        { 0x6549, 0x54E7 },
        { 0x6599, 0x54E8 },
        { 0x65C1, 0x54E9 },
        { 0x65C5, 0x54EA },
        { 0x6642, 0x54EB },
        { 0x6649, 0x54EC },
        { 0x664F, 0x54ED },
        { 0x6643, 0x54EE },
        { 0x6652, 0x54EF },
        { 0x664C, 0x54F0 },
        { 0x6645, 0x54F1 },
        { 0x6641, 0x54F2 },
        { 0x66F8, 0x54F3 },
        { 0x6714, 0x54F4 },
        { 0x6715, 0x54F5 },
        { 0x6717, 0x54F6 },
        { 0x6821, 0x54F7 },
        { 0x6838, 0x54F8 },
        { 0x6848, 0x54F9 },
        { 0x6846, 0x54FA },
        { 0x6853, 0x54FB },
        { 0x6839, 0x54FC },
        { 0x6842, 0x54FD },
        { 0x6854, 0x5541 },
        { 0x6829, 0x5542 },
        { 0x68B3, 0x5543 },
        { 0x6817, 0x5544 },
        { 0x684C, 0x5545 },
        { 0x6851, 0x5546 },
        { 0x683D, 0x5547 },
        { 0x67F4, 0x5548 },
        { 0x6850, 0x5549 },
        { 0x6840, 0x554A },
        { 0x683C, 0x554B },
        { 0x6843, 0x554C },
        { 0x682A, 0x554D },
        { 0x6845, 0x554E },
        { 0x6813, 0x554F },
        { 0x6818, 0x5550 },
        { 0x6841, 0x5551 },
        { 0x6B8A, 0x5552 },
        { 0x6B89, 0x5553 },
        { 0x6BB7, 0x5554 },
        { 0x6C23, 0x5555 },
        { 0x6C27, 0x5556 },
        { 0x6C28, 0x5557 },
        { 0x6C26, 0x5558 },
        { 0x6C24, 0x5559 },
        { 0x6CF0, 0x555A },
        { 0x6D6A, 0x555B },
        { 0x6D95, 0x555C },
        { 0x6D88, 0x555D },
        { 0x6D87, 0x555E },
        { 0x6D66, 0x555F },
        { 0x6D78, 0x5560 },
        { 0x6D77, 0x5561 },
        { 0x6D59, 0x5562 },
        { 0x6D93, 0x5563 },
        { 0x6D6C, 0x5564 },
        { 0x6D89, 0x5565 },
        { 0x6D6E, 0x5566 },
        { 0x6D5A, 0x5567 },
        { 0x6D74, 0x5568 },
        { 0x6D69, 0x5569 },
        { 0x6D8C, 0x556A },
        { 0x6D8A, 0x556B },
        { 0x6D79, 0x556C },
        { 0x6D85, 0x556D },
        { 0x6D65, 0x556E },
        { 0x6D94, 0x556F },
        { 0x70CA, 0x5570 },
        { 0x70D8, 0x5571 },
        { 0x70E4, 0x5572 },
        { 0x70D9, 0x5573 },
        { 0x70C8, 0x5574 },
        { 0x70CF, 0x5575 },
        { 0x7239, 0x5576 },
        { 0x7279, 0x5577 },
        { 0x72FC, 0x5578 },
        { 0x72F9, 0x5579 },
        { 0x72FD, 0x557A },
        { 0x72F8, 0x557B },
        { 0x72F7, 0x557C },
        { 0x7386, 0x557D },
        { 0x73ED, 0x557E },
        { 0x7409, 0x557F },
        { 0x73EE, 0x5581 },
        { 0x73E0, 0x5582 },
        { 0x73EA, 0x5583 },
        { 0x73DE, 0x5584 },
        { 0x7554, 0x5585 },
        { 0x755D, 0x5586 },
        { 0x755C, 0x5587 },
        { 0x755A, 0x5588 },
        { 0x7559, 0x5589 },
        { 0x75BE, 0x558A },
        { 0x75C5, 0x558B },
        { 0x75C7, 0x558C },
        { 0x75B2, 0x558D },
        { 0x75B3, 0x558E },
        { 0x75BD, 0x558F },
        { 0x75BC, 0x5590 },
        { 0x75B9, 0x5591 },
        { 0x75C2, 0x5592 },
        { 0x75B8, 0x5593 },
        { 0x768B, 0x5594 },
        { 0x76B0, 0x5595 },
        { 0x76CA, 0x5596 },
        { 0x76CD, 0x5597 },
        { 0x76CE, 0x5598 },
        { 0x7729, 0x5599 },
        { 0x771F, 0x559A },
        { 0x7720, 0x559B },
        { 0x7728, 0x559C },
        { 0x77E9, 0x559D },
        { 0x7830, 0x559E },
        { 0x7827, 0x559F },
        { 0x7838, 0x55A0 },
        { 0x781D, 0x55A1 },
        { 0x7834, 0x55A2 },
        { 0x7837, 0x55A3 },
        { 0x7825, 0x55A4 },
        { 0x782D, 0x55A5 },
        { 0x7820, 0x55A6 },
        { 0x781F, 0x55A7 },
        { 0x7832, 0x55A8 },
        { 0x7955, 0x55A9 },
        { 0x7950, 0x55AA },
        { 0x7960, 0x55AB },
        { 0x795F, 0x55AC },
        { 0x7956, 0x55AD },
        { 0x795E, 0x55AE },
        { 0x795D, 0x55AF },
        { 0x7957, 0x55B0 },
        { 0x795A, 0x55B1 },
        { 0x79E4, 0x55B2 },
        { 0x79E3, 0x55B3 },
        { 0x79E7, 0x55B4 },
        { 0x79DF, 0x55B5 },
        { 0x79E6, 0x55B6 },
        { 0x79E9, 0x55B7 },
        { 0x79D8, 0x55B8 },
        { 0x7A84, 0x55B9 },
        { 0x7A88, 0x55BA },
        { 0x7AD9, 0x55BB },
        { 0x7B06, 0x55BC },
        { 0x7B11, 0x55BD },
        { 0x7C89, 0x55BE },
        { 0x7D21, 0x55BF },
        { 0x7D17, 0x55C0 },
        { 0x7D0B, 0x55C1 },
        { 0x7D0A, 0x55C2 },
        { 0x7D20, 0x55C3 },
        { 0x7D22, 0x55C4 },
        { 0x7D14, 0x55C5 },
        { 0x7D10, 0x55C6 },
        { 0x7D15, 0x55C7 },
        { 0x7D1A, 0x55C8 },
        { 0x7D1C, 0x55C9 },
        { 0x7D0D, 0x55CA },
        { 0x7D19, 0x55CB },
        { 0x7D1B, 0x55CC },
        { 0x7F3A, 0x55CD },
        { 0x7F5F, 0x55CE },
        { 0x7F94, 0x55CF },
        { 0x7FC5, 0x55D0 },
        { 0x7FC1, 0x55D1 },
        { 0x8006, 0x55D2 },
        { 0x8018, 0x55D3 },
        { 0x8015, 0x55D4 },
        { 0x8019, 0x55D5 },
        { 0x8017, 0x55D6 },
        { 0x803D, 0x55D7 },
        { 0x803F, 0x55D8 },
        { 0x80F1, 0x55D9 },
        { 0x8102, 0x55DA },
        { 0x80F0, 0x55DB },
        { 0x8105, 0x55DC },
        { 0x80ED, 0x55DD },
        { 0x80F4, 0x55DE },
        { 0x8106, 0x55DF },
        { 0x80F8, 0x55E0 },
        { 0x80F3, 0x55E1 },
        { 0x8108, 0x55E2 },
        { 0x80FD, 0x55E3 },
        { 0x810A, 0x55E4 },
        { 0x80FC, 0x55E5 },
        { 0x80EF, 0x55E6 },
        { 0x81ED, 0x55E7 },
        { 0x81EC, 0x55E8 },
        { 0x8200, 0x55E9 },
        { 0x8210, 0x55EA },
        { 0x822A, 0x55EB },
        { 0x822B, 0x55EC },
        { 0x8228, 0x55ED },
        { 0x822C, 0x55EE },
        { 0x82BB, 0x55EF },
        { 0x832B, 0x55F0 },
        { 0x8352, 0x55F1 },
        { 0x8354, 0x55F2 },
        { 0x834A, 0x55F3 },
        { 0x8338, 0x55F4 },
        { 0x8350, 0x55F5 },
        { 0x8349, 0x55F6 },
        { 0x8335, 0x55F7 },
        { 0x8334, 0x55F8 },
        { 0x834F, 0x55F9 },
        { 0x8332, 0x55FA },
        { 0x8339, 0x55FB },
        { 0x8336, 0x55FC },
        { 0x8317, 0x55FD },
        { 0x8340, 0x5641 },
        { 0x8331, 0x5642 },
        { 0x8328, 0x5643 },
        { 0x8343, 0x5644 },
        { 0x8654, 0x5645 },
        { 0x868A, 0x5646 },
        { 0x86AA, 0x5647 },
        { 0x8693, 0x5648 },
        { 0x86A4, 0x5649 },
        { 0x86A9, 0x564A },
        { 0x868C, 0x564B },
        { 0x86A3, 0x564C },
        { 0x869C, 0x564D },
        { 0x8870, 0x564E },
        { 0x8877, 0x564F },
        { 0x8881, 0x5650 },
        { 0x8882, 0x5651 },
        { 0x887D, 0x5652 },
        { 0x8879, 0x5653 },
        { 0x8A18, 0x5654 },
        { 0x8A10, 0x5655 },
        { 0x8A0E, 0x5656 },
        { 0x8A0C, 0x5657 },
        { 0x8A15, 0x5658 },
        { 0x8A0A, 0x5659 },
        { 0x8A17, 0x565A },
        { 0x8A13, 0x565B },
        { 0x8A16, 0x565C },
        { 0x8A0F, 0x565D },
        { 0x8A11, 0x565E },
        { 0x8C48, 0x565F },
        { 0x8C7A, 0x5660 },
        { 0x8C79, 0x5661 },
        { 0x8CA1, 0x5662 },
        { 0x8CA2, 0x5663 },
        { 0x8D77, 0x5664 },
        { 0x8EAC, 0x5665 },
        { 0x8ED2, 0x5666 },
        { 0x8ED4, 0x5667 },
        { 0x8ECF, 0x5668 },
        { 0x8FB1, 0x5669 },
        { 0x9001, 0x566A },
        { 0x9006, 0x566B },
        { 0x8FF7, 0x566C },
        { 0x9000, 0x566D },
        { 0x8FFA, 0x566E },
        { 0x8FF4, 0x566F },
        { 0x9003, 0x5670 },
        { 0x8FFD, 0x5671 },
        { 0x9005, 0x5672 },
        { 0x8FF8, 0x5673 },
        { 0x9095, 0x5674 },
        { 0x90E1, 0x5675 },
        { 0x90DD, 0x5676 },
        { 0x90E2, 0x5677 },
        { 0x9152, 0x5678 },
        { 0x914D, 0x5679 },
        { 0x914C, 0x567A },
        { 0x91D8, 0x567B },
        { 0x91DD, 0x567C },
        { 0x91D7, 0x567D },
        { 0x91DC, 0x567E },
        { 0x91D9, 0x567F },
        { 0x9583, 0x5681 },
        { 0x9662, 0x5682 },
        { 0x9663, 0x5683 },
        { 0x9661, 0x5684 },
        { 0x965B, 0x5685 },
        { 0x965D, 0x5686 },
        { 0x9664, 0x5687 },
        { 0x9658, 0x5688 },
        { 0x965E, 0x5689 },
        { 0x96BB, 0x568A },
        { 0x98E2, 0x568B },
        { 0x99AC, 0x568C },
        { 0x9AA8, 0x568D },
        { 0x9AD8, 0x568E },
        { 0x9B25, 0x568F },
        { 0x9B32, 0x5690 },
        { 0x9B3C, 0x5691 },
        { 0x4E7E, 0x5692 },
        { 0x507A, 0x5693 },
        { 0x507D, 0x5694 },
        { 0x505C, 0x5695 },
        { 0x5047, 0x5696 },
        { 0x5043, 0x5697 },
        { 0x504C, 0x5698 },
        { 0x505A, 0x5699 },
        { 0x5049, 0x569A },
        { 0x5065, 0x569B },
        { 0x5076, 0x569C },
        { 0x504E, 0x569D },
        { 0x5055, 0x569E },
        { 0x5075, 0x569F },
        { 0x5074, 0x56A0 },
        { 0x5077, 0x56A1 },
        { 0x504F, 0x56A2 },
        { 0x500F, 0x56A3 },
        { 0x506F, 0x56A4 },
        { 0x506D, 0x56A5 },
        { 0x515C, 0x56A6 },
        { 0x5195, 0x56A7 },
        { 0x51F0, 0x56A8 },
        { 0x526A, 0x56A9 },
        { 0x526F, 0x56AA },
        { 0x52D2, 0x56AB },
        { 0x52D9, 0x56AC },
        { 0x52D8, 0x56AD },
        { 0x52D5, 0x56AE },
        { 0x5310, 0x56AF },
        { 0x530F, 0x56B0 },
        { 0x5319, 0x56B1 },
        { 0x533F, 0x56B2 },
        { 0x5340, 0x56B3 },
        { 0x533E, 0x56B4 },
        { 0x53C3, 0x56B5 },
        { 0x66FC, 0x56B6 },
        { 0x5546, 0x56B7 },
        { 0x556A, 0x56B8 },
        { 0x5566, 0x56B9 },
        { 0x5544, 0x56BA },
        { 0x555E, 0x56BB },
        { 0x5561, 0x56BC },
        { 0x5543, 0x56BD },
        { 0x554A, 0x56BE },
        { 0x5531, 0x56BF },
        { 0x5556, 0x56C0 },
        { 0x554F, 0x56C1 },
        { 0x5555, 0x56C2 },
        { 0x552F, 0x56C3 },
        { 0x5564, 0x56C4 },
        { 0x5538, 0x56C5 },
        { 0x552E, 0x56C6 },
        { 0x555C, 0x56C7 },
        { 0x552C, 0x56C8 },
        { 0x5563, 0x56C9 },
        { 0x5533, 0x56CA },
        { 0x5541, 0x56CB },
        { 0x5557, 0x56CC },
        { 0x5708, 0x56CD },
        { 0x570B, 0x56CE },
        { 0x5709, 0x56CF },
        { 0x57DF, 0x56D0 },
        { 0x5805, 0x56D1 },
        { 0x580A, 0x56D2 },
        { 0x5806, 0x56D3 },
        { 0x57E0, 0x56D4 },
        { 0x57E4, 0x56D5 },
        { 0x57FA, 0x56D6 },
        { 0x5802, 0x56D7 },
        { 0x5835, 0x56D8 },
        { 0x57F7, 0x56D9 },
        { 0x57F9, 0x56DA },
        { 0x5920, 0x56DB },
        { 0x5962, 0x56DC },
        { 0x5A36, 0x56DD },
        { 0x5A41, 0x56DE },
        { 0x5A49, 0x56DF },
        { 0x5A66, 0x56E0 },
        { 0x5A6A, 0x56E1 },
        { 0x5A40, 0x56E2 },
        { 0x5A3C, 0x56E3 },
        { 0x5A62, 0x56E4 },
        { 0x5A5A, 0x56E5 },
        { 0x5A46, 0x56E6 },
        { 0x5A4A, 0x56E7 },
        { 0x5B70, 0x56E8 },
        { 0x5BC7, 0x56E9 },
        { 0x5BC5, 0x56EA },
        { 0x5BC4, 0x56EB },
        { 0x5BC2, 0x56EC },
        { 0x5BBF, 0x56ED },
        { 0x5BC6, 0x56EE },
        { 0x5C09, 0x56EF },
        { 0x5C08, 0x56F0 },
        { 0x5C07, 0x56F1 },
        { 0x5C60, 0x56F2 },
        { 0x5C5C, 0x56F3 },
        { 0x5C5D, 0x56F4 },
        { 0x5D07, 0x56F5 },
        { 0x5D06, 0x56F6 },
        { 0x5D0E, 0x56F7 },
        { 0x5D1B, 0x56F8 },
        { 0x5D16, 0x56F9 },
        { 0x5D22, 0x56FA },
        { 0x5D11, 0x56FB },
        { 0x5D29, 0x56FC },
        { 0x5D14, 0x56FD },
        { 0x5D19, 0x5741 },
        { 0x5D24, 0x5742 },
        { 0x5D27, 0x5743 },
        { 0x5D17, 0x5744 },
        { 0x5DE2, 0x5745 },
        { 0x5E38, 0x5746 },
        { 0x5E36, 0x5747 },
        { 0x5E33, 0x5748 },
        { 0x5E37, 0x5749 },
        { 0x5EB7, 0x574A },
        { 0x5EB8, 0x574B },
        { 0x5EB6, 0x574C },
        { 0x5EB5, 0x574D },
        { 0x5EBE, 0x574E },
        { 0x5F35, 0x574F },
        { 0x5F37, 0x5750 },
        { 0x5F57, 0x5751 },
        { 0x5F6C, 0x5752 },
        { 0x5F69, 0x5753 },
        { 0x5F6B, 0x5754 },
        { 0x5F97, 0x5755 },
        { 0x5F99, 0x5756 },
        { 0x5F9E, 0x5757 },
        { 0x5F98, 0x5758 },
        { 0x5FA1, 0x5759 },
        { 0x5FA0, 0x575A },
        { 0x5F9C, 0x575B },
        { 0x607F, 0x575C },
        { 0x60A3, 0x575D },
        { 0x6089, 0x575E },
        { 0x60A0, 0x575F },
        { 0x60A8, 0x5760 },
        { 0x60CB, 0x5761 },
        { 0x60B4, 0x5762 },
        { 0x60E6, 0x5763 },
        { 0x60BD, 0x5764 },
        { 0x60C5, 0x5765 },
        { 0x60BB, 0x5766 },
        { 0x60B5, 0x5767 },
        { 0x60DC, 0x5768 },
        { 0x60BC, 0x5769 },
        { 0x60D8, 0x576A },
        { 0x60D5, 0x576B },
        { 0x60C6, 0x576C },
        { 0x60DF, 0x576D },
        { 0x60B8, 0x576E },
        { 0x60DA, 0x576F },
        { 0x60C7, 0x5770 },
        { 0x621A, 0x5771 },
        { 0x621B, 0x5772 },
        { 0x6248, 0x5773 },
        { 0x63A0, 0x5774 },
        { 0x63A7, 0x5775 },
        { 0x6372, 0x5776 },
        { 0x6396, 0x5777 },
        { 0x63A2, 0x5778 },
        { 0x63A5, 0x5779 },
        { 0x6377, 0x577A },
        { 0x6367, 0x577B },
        { 0x6398, 0x577C },
        { 0x63AA, 0x577D },
        { 0x6371, 0x577E },
        { 0x63A9, 0x577F },
        { 0x6389, 0x5781 },
        { 0x6383, 0x5782 },
        { 0x639B, 0x5783 },
        { 0x636B, 0x5784 },
        { 0x63A8, 0x5785 },
        { 0x6384, 0x5786 },
        { 0x6388, 0x5787 },
        { 0x6399, 0x5788 },
        { 0x63A1, 0x5789 },
        { 0x63AC, 0x578A },
        { 0x6392, 0x578B },
        { 0x638F, 0x578C },
        { 0x6380, 0x578D },
        { 0x637B, 0x578E },
        { 0x6369, 0x578F },
        { 0x6368, 0x5790 },
        { 0x637A, 0x5791 },
        { 0x655D, 0x5792 },
        { 0x6556, 0x5793 },
        { 0x6551, 0x5794 },
        { 0x6559, 0x5795 },
        { 0x6557, 0x5796 },
        { 0x555F, 0x5797 },
        { 0x654F, 0x5798 },
        { 0x6558, 0x5799 },
        { 0x6555, 0x579A },
        { 0x6554, 0x579B },
        { 0x659C, 0x579C },
        { 0x659B, 0x579D },
        { 0x65AC, 0x579E },
        { 0x65CF, 0x579F },
        { 0x65CB, 0x57A0 },
        { 0x65CC, 0x57A1 },
        { 0x65CE, 0x57A2 },
        { 0x665D, 0x57A3 },
        { 0x665A, 0x57A4 },
        { 0x6664, 0x57A5 },
        { 0x6668, 0x57A6 },
        { 0x6666, 0x57A7 },
        { 0x665E, 0x57A8 },
        { 0x66F9, 0x57A9 },
        { 0x52D7, 0x57AA },
        { 0x671B, 0x57AB },
        { 0x6881, 0x57AC },
        { 0x68AF, 0x57AD },
        { 0x68A2, 0x57AE },
        { 0x6893, 0x57AF },
        { 0x68B5, 0x57B0 },
        { 0x687F, 0x57B1 },
        { 0x6876, 0x57B2 },
        { 0x68B1, 0x57B3 },
        { 0x68A7, 0x57B4 },
        { 0x6897, 0x57B5 },
        { 0x68B0, 0x57B6 },
        { 0x6883, 0x57B7 },
        { 0x68C4, 0x57B8 },
        { 0x68AD, 0x57B9 },
        { 0x6886, 0x57BA },
        { 0x6885, 0x57BB },
        { 0x6894, 0x57BC },
        { 0x689D, 0x57BD },
        { 0x68A8, 0x57BE },
        { 0x689F, 0x57BF },
        { 0x68A1, 0x57C0 },
        { 0x6882, 0x57C1 },
        { 0x6B32, 0x57C2 },
        { 0x6BBA, 0x57C3 },
        { 0x6BEB, 0x57C4 },
        { 0x6BEC, 0x57C5 },
        { 0x6C2B, 0x57C6 },
        { 0x6D8E, 0x57C7 },
        { 0x6DBC, 0x57C8 },
        { 0x6DF3, 0x57C9 },
        { 0x6DD9, 0x57CA },
        { 0x6DB2, 0x57CB },
        { 0x6DE1, 0x57CC },
        { 0x6DCC, 0x57CD },
        { 0x6DE4, 0x57CE },
        { 0x6DFB, 0x57CF },
        { 0x6DFA, 0x57D0 },
        { 0x6E05, 0x57D1 },
        { 0x6DC7, 0x57D2 },
        { 0x6DCB, 0x57D3 },
        { 0x6DAF, 0x57D4 },
        { 0x6DD1, 0x57D5 },
        { 0x6DAE, 0x57D6 },
        { 0x6DDE, 0x57D7 },
        { 0x6DF9, 0x57D8 },
        { 0x6DB8, 0x57D9 },
        { 0x6DF7, 0x57DA },
        { 0x6DF5, 0x57DB },
        { 0x6DC5, 0x57DC },
        { 0x6DD2, 0x57DD },
        { 0x6E1A, 0x57DE },
        { 0x6DB5, 0x57DF },
        { 0x6DDA, 0x57E0 },
        { 0x6DEB, 0x57E1 },
        { 0x6DD8, 0x57E2 },
        { 0x6DEA, 0x57E3 },
        { 0x6DF1, 0x57E4 },
        { 0x6DEE, 0x57E5 },
        { 0x6DE8, 0x57E6 },
        { 0x6DC6, 0x57E7 },
        { 0x6DC4, 0x57E8 },
        { 0x6DAA, 0x57E9 },
        { 0x6DEC, 0x57EA },
        { 0x6DBF, 0x57EB },
        { 0x6DE6, 0x57EC },
        { 0x70F9, 0x57ED },
        { 0x7109, 0x57EE },
        { 0x710A, 0x57EF },
        { 0x70FD, 0x57F0 },
        { 0x70EF, 0x57F1 },
        { 0x723D, 0x57F2 },
        { 0x727D, 0x57F3 },
        { 0x7281, 0x57F4 },
        { 0x731C, 0x57F5 },
        { 0x731B, 0x57F6 },
        { 0x7316, 0x57F7 },
        { 0x7313, 0x57F8 },
        { 0x7319, 0x57F9 },
        { 0x7387, 0x57FA },
        { 0x7405, 0x57FB },
        { 0x740A, 0x57FC },
        { 0x7403, 0x57FD },
        { 0x7406, 0x5841 },
        { 0x73FE, 0x5842 },
        { 0x740D, 0x5843 },
        { 0x74E0, 0x5844 },
        { 0x74F6, 0x5845 },
        { 0x74F7, 0x5846 },
        { 0x751C, 0x5847 },
        { 0x7522, 0x5848 },
        { 0x7565, 0x5849 },
        { 0x7566, 0x584A },
        { 0x7562, 0x584B },
        { 0x7570, 0x584C },
        { 0x758F, 0x584D },
        { 0x75D4, 0x584E },
        { 0x75D5, 0x584F },
        { 0x75B5, 0x5850 },
        { 0x75CA, 0x5851 },
        { 0x75CD, 0x5852 },
        { 0x768E, 0x5853 },
        { 0x76D4, 0x5854 },
        { 0x76D2, 0x5855 },
        { 0x76DB, 0x5856 },
        { 0x7737, 0x5857 },
        { 0x773E, 0x5858 },
        { 0x773C, 0x5859 },
        { 0x7736, 0x585A },
        { 0x7738, 0x585B },
        { 0x773A, 0x585C },
        { 0x786B, 0x585D },
        { 0x7843, 0x585E },
        { 0x784E, 0x585F },
        { 0x7965, 0x5860 },
        { 0x7968, 0x5861 },
        { 0x796D, 0x5862 },
        { 0x79FB, 0x5863 },
        { 0x7A92, 0x5864 },
        { 0x7A95, 0x5865 },
        { 0x7B20, 0x5866 },
        { 0x7B28, 0x5867 },
        { 0x7B1B, 0x5868 },
        { 0x7B2C, 0x5869 },
        { 0x7B26, 0x586A },
        { 0x7B19, 0x586B },
        { 0x7B1E, 0x586C },
        { 0x7B2E, 0x586D },
        { 0x7C92, 0x586E },
        { 0x7C97, 0x586F },
        { 0x7C95, 0x5870 },
        { 0x7D46, 0x5871 },
        { 0x7D43, 0x5872 },
        { 0x7D71, 0x5873 },
        { 0x7D2E, 0x5874 },
        { 0x7D39, 0x5875 },
        { 0x7D3C, 0x5876 },
        { 0x7D40, 0x5877 },
        { 0x7D30, 0x5878 },
        { 0x7D33, 0x5879 },
        { 0x7D44, 0x587A },
        { 0x7D2F, 0x587B },
        { 0x7D42, 0x587C },
        { 0x7D32, 0x587D },
        { 0x7D31, 0x587E },
        { 0x7F3D, 0x587F },
        { 0x7F9E, 0x5881 },
        { 0x7F9A, 0x5882 },
        { 0x7FCC, 0x5883 },
        { 0x7FCE, 0x5884 },
        { 0x7FD2, 0x5885 },
        { 0x801C, 0x5886 },
        { 0x804A, 0x5887 },
        { 0x8046, 0x5888 },
        { 0x812F, 0x5889 },
        { 0x8116, 0x588A },
        { 0x8123, 0x588B },
        { 0x812B, 0x588C },
        { 0x8129, 0x588D },
        { 0x8130, 0x588E },
        { 0x8124, 0x588F },
        { 0x8202, 0x5890 },
        { 0x8235, 0x5891 },
        { 0x8237, 0x5892 },
        { 0x8236, 0x5893 },
        { 0x8239, 0x5894 },
        { 0x838E, 0x5895 },
        { 0x839E, 0x5896 },
        { 0x8398, 0x5897 },
        { 0x8378, 0x5898 },
        { 0x83A2, 0x5899 },
        { 0x8396, 0x589A },
        { 0x83BD, 0x589B },
        { 0x83AB, 0x589C },
        { 0x8392, 0x589D },
        { 0x838A, 0x589E },
        { 0x8393, 0x589F },
        { 0x8389, 0x58A0 },
        { 0x83A0, 0x58A1 },
        { 0x8377, 0x58A2 },
        { 0x837B, 0x58A3 },
        { 0x837C, 0x58A4 },
        { 0x8386, 0x58A5 },
        { 0x83A7, 0x58A6 },
        { 0x8655, 0x58A7 },
        { 0x5F6A, 0x58A8 },
        { 0x86C7, 0x58A9 },
        { 0x86C0, 0x58AA },
        { 0x86B6, 0x58AB },
        { 0x86C4, 0x58AC },
        { 0x86B5, 0x58AD },
        { 0x86C6, 0x58AE },
        { 0x86CB, 0x58AF },
        { 0x86B1, 0x58B0 },
        { 0x86AF, 0x58B1 },
        { 0x86C9, 0x58B2 },
        { 0x8853, 0x58B3 },
        { 0x889E, 0x58B4 },
        { 0x8888, 0x58B5 },
        { 0x88AB, 0x58B6 },
        { 0x8892, 0x58B7 },
        { 0x8896, 0x58B8 },
        { 0x888D, 0x58B9 },
        { 0x888B, 0x58BA },
        { 0x8993, 0x58BB },
        { 0x898F, 0x58BC },
        { 0x8A2A, 0x58BD },
        { 0x8A1D, 0x58BE },
        { 0x8A23, 0x58BF },
        { 0x8A25, 0x58C0 },
        { 0x8A31, 0x58C1 },
        { 0x8A2D, 0x58C2 },
        { 0x8A1F, 0x58C3 },
        { 0x8A1B, 0x58C4 },
        { 0x8A22, 0x58C5 },
        { 0x8C49, 0x58C6 },
        { 0x8C5A, 0x58C7 },
        { 0x8CA9, 0x58C8 },
        { 0x8CAC, 0x58C9 },
        { 0x8CAB, 0x58CA },
        { 0x8CA8, 0x58CB },
        { 0x8CAA, 0x58CC },
        { 0x8CA7, 0x58CD },
        { 0x8D67, 0x58CE },
        { 0x8D66, 0x58CF },
        { 0x8DBE, 0x58D0 },
        { 0x8DBA, 0x58D1 },
        { 0x8EDB, 0x58D2 },
        { 0x8EDF, 0x58D3 },
        { 0x9019, 0x58D4 },
        { 0x900D, 0x58D5 },
        { 0x901A, 0x58D6 },
        { 0x9017, 0x58D7 },
        { 0x9023, 0x58D8 },
        { 0x901F, 0x58D9 },
        { 0x901D, 0x58DA },
        { 0x9010, 0x58DB },
        { 0x9015, 0x58DC },
        { 0x901E, 0x58DD },
        { 0x9020, 0x58DE },
        { 0x900F, 0x58DF },
        { 0x9022, 0x58E0 },
        { 0x9016, 0x58E1 },
        { 0x901B, 0x58E2 },
        { 0x9014, 0x58E3 },
        { 0x90E8, 0x58E4 },
        { 0x90ED, 0x58E5 },
        { 0x90FD, 0x58E6 },
        { 0x9157, 0x58E7 },
        { 0x91CE, 0x58E8 },
        { 0x91F5, 0x58E9 },
        { 0x91E6, 0x58EA },
        { 0x91E3, 0x58EB },
        { 0x91E7, 0x58EC },
        { 0x91ED, 0x58ED },
        { 0x91E9, 0x58EE },
        { 0x9589, 0x58EF },
        { 0x966A, 0x58F0 },
        { 0x9675, 0x58F1 },
        { 0x9673, 0x58F2 },
        { 0x9678, 0x58F3 },
        { 0x9670, 0x58F4 },
        { 0x9674, 0x58F5 },
        { 0x9676, 0x58F6 },
        { 0x9677, 0x58F7 },
        { 0x966C, 0x58F8 },
        { 0x96C0, 0x58F9 },
        { 0x96EA, 0x58FA },
        { 0x96E9, 0x58FB },
        { 0x7AE0, 0x58FC },
        { 0x7ADF, 0x58FD },
        { 0x9802, 0x5941 },
        { 0x9803, 0x5942 },
        { 0x9B5A, 0x5943 },
        { 0x9CE5, 0x5944 },
        { 0x9E75, 0x5945 },
        { 0x9E7F, 0x5946 },
        { 0x9EA5, 0x5947 },
        { 0x9EBB, 0x5948 },
        { 0x50A2, 0x5949 },
        { 0x508D, 0x594A },
        { 0x5085, 0x594B },
        { 0x5099, 0x594C },
        { 0x5091, 0x594D },
        { 0x5080, 0x594E },
        { 0x5096, 0x594F },
        { 0x5098, 0x5950 },
        { 0x509A, 0x5951 },
        { 0x6700, 0x5952 },
        { 0x51F1, 0x5953 },
        { 0x5272, 0x5954 },
        { 0x5274, 0x5955 },
        { 0x5275, 0x5956 },
        { 0x5269, 0x5957 },
        { 0x52DE, 0x5958 },
        { 0x52DD, 0x5959 },
        { 0x52DB, 0x595A },
        { 0x535A, 0x595B },
        { 0x53A5, 0x595C },
        { 0x557B, 0x595D },
        { 0x5580, 0x595E },
        { 0x55A7, 0x595F },
        { 0x557C, 0x5960 },
        { 0x558A, 0x5961 },
        { 0x559D, 0x5962 },
        { 0x5598, 0x5963 },
        { 0x5582, 0x5964 },
        { 0x559C, 0x5965 },
        { 0x55AA, 0x5966 },
        { 0x5594, 0x5967 },
        { 0x5587, 0x5968 },
        { 0x558B, 0x5969 },
        { 0x5583, 0x596A },
        { 0x55B3, 0x596B },
        { 0x55AE, 0x596C },
        { 0x559F, 0x596D },
        { 0x553E, 0x596E },
        { 0x55B2, 0x596F },
        { 0x559A, 0x5970 },
        { 0x55BB, 0x5971 },
        { 0x55AC, 0x5972 },
        { 0x55B1, 0x5973 },
        { 0x557E, 0x5974 },
        { 0x5589, 0x5975 },
        { 0x55AB, 0x5976 },
        { 0x5599, 0x5977 },
        { 0x570D, 0x5978 },
        { 0x582F, 0x5979 },
        { 0x582A, 0x597A },
        { 0x5834, 0x597B },
        { 0x5824, 0x597C },
        { 0x5830, 0x597D },
        { 0x5831, 0x597E },
        { 0x5821, 0x597F },
        { 0x581D, 0x5981 },
        { 0x5820, 0x5982 },
        { 0x58F9, 0x5983 },
        { 0x58FA, 0x5984 },
        { 0x5960, 0x5985 },
        { 0x5A77, 0x5986 },
        { 0x5A9A, 0x5987 },
        { 0x5A7F, 0x5988 },
        { 0x5A92, 0x5989 },
        { 0x5A9B, 0x598A },
        { 0x5AA7, 0x598B },
        { 0x5B73, 0x598C },
        { 0x5B71, 0x598D },
        { 0x5BD2, 0x598E },
        { 0x5BCC, 0x598F },
        { 0x5BD3, 0x5990 },
        { 0x5BD0, 0x5991 },
        { 0x5C0A, 0x5992 },
        { 0x5C0B, 0x5993 },
        { 0x5C31, 0x5994 },
        { 0x5D4C, 0x5995 },
        { 0x5D50, 0x5996 },
        { 0x5D34, 0x5997 },
        { 0x5D47, 0x5998 },
        { 0x5DFD, 0x5999 },
        { 0x5E45, 0x599A },
        { 0x5E3D, 0x599B },
        { 0x5E40, 0x599C },
        { 0x5E43, 0x599D },
        { 0x5E7E, 0x599E },
        { 0x5ECA, 0x599F },
        { 0x5EC1, 0x59A0 },
        { 0x5EC2, 0x59A1 },
        { 0x5EC4, 0x59A2 },
        { 0x5F3C, 0x59A3 },
        { 0x5F6D, 0x59A4 },
        { 0x5FA9, 0x59A5 },
        { 0x5FAA, 0x59A6 },
        { 0x5FA8, 0x59A7 },
        { 0x60D1, 0x59A8 },
        { 0x60E1, 0x59A9 },
        { 0x60B2, 0x59AA },
        { 0x60B6, 0x59AB },
        { 0x60E0, 0x59AC },
        { 0x611C, 0x59AD },
        { 0x6123, 0x59AE },
        { 0x60FA, 0x59AF },
        { 0x6115, 0x59B0 },
        { 0x60F0, 0x59B1 },
        { 0x60FB, 0x59B2 },
        { 0x60F4, 0x59B3 },
        { 0x6168, 0x59B4 },
        { 0x60F1, 0x59B5 },
        { 0x610E, 0x59B6 },
        { 0x60F6, 0x59B7 },
        { 0x6109, 0x59B8 },
        { 0x6100, 0x59B9 },
        { 0x6112, 0x59BA },
        { 0x621F, 0x59BB },
        { 0x6249, 0x59BC },
        { 0x63A3, 0x59BD },
        { 0x638C, 0x59BE },
        { 0x63CF, 0x59BF },
        { 0x63C0, 0x59C0 },
        { 0x63E9, 0x59C1 },
        { 0x63C9, 0x59C2 },
        { 0x63C6, 0x59C3 },
        { 0x63CD, 0x59C4 },
        { 0x63D2, 0x59C5 },
        { 0x63E3, 0x59C6 },
        { 0x63D0, 0x59C7 },
        { 0x63E1, 0x59C8 },
        { 0x63D6, 0x59C9 },
        { 0x63ED, 0x59CA },
        { 0x63EE, 0x59CB },
        { 0x6376, 0x59CC },
        { 0x63F4, 0x59CD },
        { 0x63EA, 0x59CE },
        { 0x63DB, 0x59CF },
        { 0x6452, 0x59D0 },
        { 0x63DA, 0x59D1 },
        { 0x63F9, 0x59D2 },
        { 0x655E, 0x59D3 },
        { 0x6566, 0x59D4 },
        { 0x6562, 0x59D5 },
        { 0x6563, 0x59D6 },
        { 0x6591, 0x59D7 },
        { 0x6590, 0x59D8 },
        { 0x65AF, 0x59D9 },
        { 0x666E, 0x59DA },
        { 0x6670, 0x59DB },
        { 0x6674, 0x59DC },
        { 0x6676, 0x59DD },
        { 0x666F, 0x59DE },
        { 0x6691, 0x59DF },
        { 0x667A, 0x59E0 },
        { 0x667E, 0x59E1 },
        { 0x6677, 0x59E2 },
        { 0x66FE, 0x59E3 },
        { 0x66FF, 0x59E4 },
        { 0x671F, 0x59E5 },
        { 0x671D, 0x59E6 },
        { 0x68FA, 0x59E7 },
        { 0x68D5, 0x59E8 },
        { 0x68E0, 0x59E9 },
        { 0x68D8, 0x59EA },
        { 0x68D7, 0x59EB },
        { 0x6905, 0x59EC },
        { 0x68DF, 0x59ED },
        { 0x68F5, 0x59EE },
        { 0x68EE, 0x59EF },
        { 0x68E7, 0x59F0 },
        { 0x68F9, 0x59F1 },
        { 0x68D2, 0x59F2 },
        { 0x68F2, 0x59F3 },
        { 0x68E3, 0x59F4 },
        { 0x68CB, 0x59F5 },
        { 0x68CD, 0x59F6 },
        { 0x690D, 0x59F7 },
        { 0x6912, 0x59F8 },
        { 0x690E, 0x59F9 },
        { 0x68C9, 0x59FA },
        { 0x68DA, 0x59FB },
        { 0x696E, 0x59FC },
        { 0x68FB, 0x59FD },
        { 0x6B3E, 0x5A41 },
        { 0x6B3A, 0x5A42 },
        { 0x6B3D, 0x5A43 },
        { 0x6B98, 0x5A44 },
        { 0x6B96, 0x5A45 },
        { 0x6BBC, 0x5A46 },
        { 0x6BEF, 0x5A47 },
        { 0x6C2E, 0x5A48 },
        { 0x6C2F, 0x5A49 },
        { 0x6C2C, 0x5A4A },
        { 0x6E2F, 0x5A4B },
        { 0x6E38, 0x5A4C },
        { 0x6E54, 0x5A4D },
        { 0x6E21, 0x5A4E },
        { 0x6E32, 0x5A4F },
        { 0x6E67, 0x5A50 },
        { 0x6E4A, 0x5A51 },
        { 0x6E20, 0x5A52 },
        { 0x6E25, 0x5A53 },
        { 0x6E23, 0x5A54 },
        { 0x6E1B, 0x5A55 },
        { 0x6E5B, 0x5A56 },
        { 0x6E58, 0x5A57 },
        { 0x6E24, 0x5A58 },
        { 0x6E56, 0x5A59 },
        { 0x6E6E, 0x5A5A },
        { 0x6E2D, 0x5A5B },
        { 0x6E26, 0x5A5C },
        { 0x6E6F, 0x5A5D },
        { 0x6E34, 0x5A5E },
        { 0x6E4D, 0x5A5F },
        { 0x6E3A, 0x5A60 },
        { 0x6E2C, 0x5A61 },
        { 0x6E43, 0x5A62 },
        { 0x6E1D, 0x5A63 },
        { 0x6E3E, 0x5A64 },
        { 0x6ECB, 0x5A65 },
        { 0x6E89, 0x5A66 },
        { 0x6E19, 0x5A67 },
        { 0x6E4E, 0x5A68 },
        { 0x6E63, 0x5A69 },
        { 0x6E44, 0x5A6A },
        { 0x6E72, 0x5A6B },
        { 0x6E69, 0x5A6C },
        { 0x6E5F, 0x5A6D },
        { 0x7119, 0x5A6E },
        { 0x711A, 0x5A6F },
        { 0x7126, 0x5A70 },
        { 0x7130, 0x5A71 },
        { 0x7121, 0x5A72 },
        { 0x7136, 0x5A73 },
        { 0x716E, 0x5A74 },
        { 0x711C, 0x5A75 },
        { 0x724C, 0x5A76 },
        { 0x7284, 0x5A77 },
        { 0x7280, 0x5A78 },
        { 0x7336, 0x5A79 },
        { 0x7325, 0x5A7A },
        { 0x7334, 0x5A7B },
        { 0x7329, 0x5A7C },
        { 0x743A, 0x5A7D },
        { 0x742A, 0x5A7E },
        { 0x7433, 0x5A7F },
        { 0x7422, 0x5A81 },
        { 0x7425, 0x5A82 },
        { 0x7435, 0x5A83 },
        { 0x7436, 0x5A84 },
        { 0x7434, 0x5A85 },
        { 0x742F, 0x5A86 },
        { 0x741B, 0x5A87 },
        { 0x7426, 0x5A88 },
        { 0x7428, 0x5A89 },
        { 0x7525, 0x5A8A },
        { 0x7526, 0x5A8B },
        { 0x756B, 0x5A8C },
        { 0x756A, 0x5A8D },
        { 0x75E2, 0x5A8E },
        { 0x75DB, 0x5A8F },
        { 0x75E3, 0x5A90 },
        { 0x75D9, 0x5A91 },
        { 0x75D8, 0x5A92 },
        { 0x75DE, 0x5A93 },
        { 0x75E0, 0x5A94 },
        { 0x767B, 0x5A95 },
        { 0x767C, 0x5A96 },
        { 0x7696, 0x5A97 },
        { 0x7693, 0x5A98 },
        { 0x76B4, 0x5A99 },
        { 0x76DC, 0x5A9A },
        { 0x774F, 0x5A9B },
        { 0x77ED, 0x5A9C },
        { 0x785D, 0x5A9D },
        { 0x786C, 0x5A9E },
        { 0x786F, 0x5A9F },
        { 0x7A0D, 0x5AA0 },
        { 0x7A08, 0x5AA1 },
        { 0x7A0B, 0x5AA2 },
        { 0x7A05, 0x5AA3 },
        { 0x7A00, 0x5AA4 },
        { 0x7A98, 0x5AA5 },
        { 0x7A97, 0x5AA6 },
        { 0x7A96, 0x5AA7 },
        { 0x7AE5, 0x5AA8 },
        { 0x7AE3, 0x5AA9 },
        { 0x7B49, 0x5AAA },
        { 0x7B56, 0x5AAB },
        { 0x7B46, 0x5AAC },
        { 0x7B50, 0x5AAD },
        { 0x7B52, 0x5AAE },
        { 0x7B54, 0x5AAF },
        { 0x7B4D, 0x5AB0 },
        { 0x7B4B, 0x5AB1 },
        { 0x7B4F, 0x5AB2 },
        { 0x7B51, 0x5AB3 },
        { 0x7C9F, 0x5AB4 },
        { 0x7CA5, 0x5AB5 },
        { 0x7D5E, 0x5AB6 },
        { 0x7D50, 0x5AB7 },
        { 0x7D68, 0x5AB8 },
        { 0x7D55, 0x5AB9 },
        { 0x7D2B, 0x5ABA },
        { 0x7D6E, 0x5ABB },
        { 0x7D72, 0x5ABC },
        { 0x7D61, 0x5ABD },
        { 0x7D66, 0x5ABE },
        { 0x7D62, 0x5ABF },
        { 0x7D70, 0x5AC0 },
        { 0x7D73, 0x5AC1 },
        { 0x5584, 0x5AC2 },
        { 0x7FD4, 0x5AC3 },
        { 0x7FD5, 0x5AC4 },
        { 0x800B, 0x5AC5 },
        { 0x8052, 0x5AC6 },
        { 0x8085, 0x5AC7 },
        { 0x8155, 0x5AC8 },
        { 0x8154, 0x5AC9 },
        { 0x814B, 0x5ACA },
        { 0x8151, 0x5ACB },
        { 0x814E, 0x5ACC },
        { 0x8139, 0x5ACD },
        { 0x8146, 0x5ACE },
        { 0x813E, 0x5ACF },
        { 0x814C, 0x5AD0 },
        { 0x8153, 0x5AD1 },
        { 0x8174, 0x5AD2 },
        { 0x8212, 0x5AD3 },
        { 0x821C, 0x5AD4 },
        { 0x83E9, 0x5AD5 },
        { 0x8403, 0x5AD6 },
        { 0x83F8, 0x5AD7 },
        { 0x840D, 0x5AD8 },
        { 0x83E0, 0x5AD9 },
        { 0x83C5, 0x5ADA },
        { 0x840B, 0x5ADB },
        { 0x83C1, 0x5ADC },
        { 0x83EF, 0x5ADD },
        { 0x83F1, 0x5ADE },
        { 0x83F4, 0x5ADF },
        { 0x8457, 0x5AE0 },
        { 0x840A, 0x5AE1 },
        { 0x83F0, 0x5AE2 },
        { 0x840C, 0x5AE3 },
        { 0x83CC, 0x5AE4 },
        { 0x83FD, 0x5AE5 },
        { 0x83F2, 0x5AE6 },
        { 0x83CA, 0x5AE7 },
        { 0x8438, 0x5AE8 },
        { 0x840E, 0x5AE9 },
        { 0x8404, 0x5AEA },
        { 0x83DC, 0x5AEB },
        { 0x8407, 0x5AEC },
        { 0x83D4, 0x5AED },
        { 0x83DF, 0x5AEE },
        { 0x865B, 0x5AEF },
        { 0x86DF, 0x5AF0 },
        { 0x86D9, 0x5AF1 },
        { 0x86ED, 0x5AF2 },
        { 0x86D4, 0x5AF3 },
        { 0x86DB, 0x5AF4 },
        { 0x86E4, 0x5AF5 },
        { 0x86D0, 0x5AF6 },
        { 0x86DE, 0x5AF7 },
        { 0x8857, 0x5AF8 },
        { 0x88C1, 0x5AF9 },
        { 0x88C2, 0x5AFA },
        { 0x88B1, 0x5AFB },
        { 0x8983, 0x5AFC },
        { 0x8996, 0x5AFD },
        { 0x8A3B, 0x5B41 },
        { 0x8A60, 0x5B42 },
        { 0x8A55, 0x5B43 },
        { 0x8A5E, 0x5B44 },
        { 0x8A3C, 0x5B45 },
        { 0x8A41, 0x5B46 },
        { 0x8A54, 0x5B47 },
        { 0x8A5B, 0x5B48 },
        { 0x8A50, 0x5B49 },
        { 0x8A46, 0x5B4A },
        { 0x8A34, 0x5B4B },
        { 0x8A3A, 0x5B4C },
        { 0x8A36, 0x5B4D },
        { 0x8A56, 0x5B4E },
        { 0x8C61, 0x5B4F },
        { 0x8C82, 0x5B50 },
        { 0x8CAF, 0x5B51 },
        { 0x8CBC, 0x5B52 },
        { 0x8CB3, 0x5B53 },
        { 0x8CBD, 0x5B54 },
        { 0x8CC1, 0x5B55 },
        { 0x8CBB, 0x5B56 },
        { 0x8CC0, 0x5B57 },
        { 0x8CB4, 0x5B58 },
        { 0x8CB7, 0x5B59 },
        { 0x8CB6, 0x5B5A },
        { 0x8CBF, 0x5B5B },
        { 0x8CB8, 0x5B5C },
        { 0x8D8A, 0x5B5D },
        { 0x8D85, 0x5B5E },
        { 0x8D81, 0x5B5F },
        { 0x8DCE, 0x5B60 },
        { 0x8DDD, 0x5B61 },
        { 0x8DCB, 0x5B62 },
        { 0x8DDA, 0x5B63 },
        { 0x8DD1, 0x5B64 },
        { 0x8DCC, 0x5B65 },
        { 0x8DDB, 0x5B66 },
        { 0x8DC6, 0x5B67 },
        { 0x8EFB, 0x5B68 },
        { 0x8EF8, 0x5B69 },
        { 0x8EFC, 0x5B6A },
        { 0x8F9C, 0x5B6B },
        { 0x902E, 0x5B6C },
        { 0x9035, 0x5B6D },
        { 0x9031, 0x5B6E },
        { 0x9038, 0x5B6F },
        { 0x9032, 0x5B70 },
        { 0x9036, 0x5B71 },
        { 0x9102, 0x5B72 },
        { 0x90F5, 0x5B73 },
        { 0x9109, 0x5B74 },
        { 0x90FE, 0x5B75 },
        { 0x9163, 0x5B76 },
        { 0x9165, 0x5B77 },
        { 0x91CF, 0x5B78 },
        { 0x9214, 0x5B79 },
        { 0x9215, 0x5B7A },
        { 0x9223, 0x5B7B },
        { 0x9209, 0x5B7C },
        { 0x921E, 0x5B7D },
        { 0x920D, 0x5B7E },
        { 0x9210, 0x5B7F },
        { 0x9207, 0x5B81 },
        { 0x9211, 0x5B82 },
        { 0x9594, 0x5B83 },
        { 0x958F, 0x5B84 },
        { 0x958B, 0x5B85 },
        { 0x9591, 0x5B86 },
        { 0x9593, 0x5B87 },
        { 0x9592, 0x5B88 },
        { 0x958E, 0x5B89 },
        { 0x968A, 0x5B8A },
        { 0x968E, 0x5B8B },
        { 0x968B, 0x5B8C },
        { 0x967D, 0x5B8D },
        { 0x9685, 0x5B8E },
        { 0x9686, 0x5B8F },
        { 0x968D, 0x5B90 },
        { 0x9672, 0x5B91 },
        { 0x9684, 0x5B92 },
        { 0x96C1, 0x5B93 },
        { 0x96C5, 0x5B94 },
        { 0x96C4, 0x5B95 },
        { 0x96C6, 0x5B96 },
        { 0x96C7, 0x5B97 },
        { 0x96EF, 0x5B98 },
        { 0x96F2, 0x5B99 },
        { 0x97CC, 0x5B9A },
        { 0x9805, 0x5B9B },
        { 0x9806, 0x5B9C },
        { 0x9808, 0x5B9D },
        { 0x98E7, 0x5B9E },
        { 0x98EA, 0x5B9F },
        { 0x98EF, 0x5BA0 },
        { 0x98E9, 0x5BA1 },
        { 0x98F2, 0x5BA2 },
        { 0x98ED, 0x5BA3 },
        { 0x99AE, 0x5BA4 },
        { 0x99AD, 0x5BA5 },
        { 0x9EC3, 0x5BA6 },
        { 0x9ECD, 0x5BA7 },
        { 0x9ED1, 0x5BA8 },
        { 0x4E82, 0x5BA9 },
        { 0x50AD, 0x5BAA },
        { 0x50B5, 0x5BAB },
        { 0x50B2, 0x5BAC },
        { 0x50B3, 0x5BAD },
        { 0x50C5, 0x5BAE },
        { 0x50BE, 0x5BAF },
        { 0x50AC, 0x5BB0 },
        { 0x50B7, 0x5BB1 },
        { 0x50BB, 0x5BB2 },
        { 0x50AF, 0x5BB3 },
        { 0x50C7, 0x5BB4 },
        { 0x527F, 0x5BB5 },
        { 0x5277, 0x5BB6 },
        { 0x527D, 0x5BB7 },
        { 0x52DF, 0x5BB8 },
        { 0x52E6, 0x5BB9 },
        { 0x52E4, 0x5BBA },
        { 0x52E2, 0x5BBB },
        { 0x52E3, 0x5BBC },
        { 0x532F, 0x5BBD },
        { 0x55DF, 0x5BBE },
        { 0x55E8, 0x5BBF },
        { 0x55D3, 0x5BC0 },
        { 0x55E6, 0x5BC1 },
        { 0x55CE, 0x5BC2 },
        { 0x55DC, 0x5BC3 },
        { 0x55C7, 0x5BC4 },
        { 0x55D1, 0x5BC5 },
        { 0x55E3, 0x5BC6 },
        { 0x55E4, 0x5BC7 },
        { 0x55EF, 0x5BC8 },
        { 0x55DA, 0x5BC9 },
        { 0x55E1, 0x5BCA },
        { 0x55C5, 0x5BCB },
        { 0x55C6, 0x5BCC },
        { 0x55E5, 0x5BCD },
        { 0x55C9, 0x5BCE },
        { 0x5712, 0x5BCF },
        { 0x5713, 0x5BD0 },
        { 0x585E, 0x5BD1 },
        { 0x5851, 0x5BD2 },
        { 0x5858, 0x5BD3 },
        { 0x5857, 0x5BD4 },
        { 0x585A, 0x5BD5 },
        { 0x5854, 0x5BD6 },
        { 0x586B, 0x5BD7 },
        { 0x584C, 0x5BD8 },
        { 0x586D, 0x5BD9 },
        { 0x584A, 0x5BDA },
        { 0x5862, 0x5BDB },
        { 0x5852, 0x5BDC },
        { 0x584B, 0x5BDD },
        { 0x5967, 0x5BDE },
        { 0x5AC1, 0x5BDF },
        { 0x5AC9, 0x5BE0 },
        { 0x5ACC, 0x5BE1 },
        { 0x5ABE, 0x5BE2 },
        { 0x5ABD, 0x5BE3 },
        { 0x5ABC, 0x5BE4 },
        { 0x5AB3, 0x5BE5 },
        { 0x5AC2, 0x5BE6 },
        { 0x5AB2, 0x5BE7 },
        { 0x5D69, 0x5BE8 },
        { 0x5D6F, 0x5BE9 },
        { 0x5E4C, 0x5BEA },
        { 0x5E79, 0x5BEB },
        { 0x5EC9, 0x5BEC },
        { 0x5EC8, 0x5BED },
        { 0x5F12, 0x5BEE },
        { 0x5F59, 0x5BEF },
        { 0x5FAC, 0x5BF0 },
        { 0x5FAE, 0x5BF1 },
        { 0x611A, 0x5BF2 },
        { 0x610F, 0x5BF3 },
        { 0x6148, 0x5BF4 },
        { 0x611F, 0x5BF5 },
        { 0x60F3, 0x5BF6 },
        { 0x611B, 0x5BF7 },
        { 0x60F9, 0x5BF8 },
        { 0x6101, 0x5BF9 },
        { 0x6108, 0x5BFA },
        { 0x614E, 0x5BFB },
        { 0x614C, 0x5BFC },
        { 0x6144, 0x5BFD },
        { 0x614D, 0x5C41 },
        { 0x613E, 0x5C42 },
        { 0x6134, 0x5C43 },
        { 0x6127, 0x5C44 },
        { 0x610D, 0x5C45 },
        { 0x6106, 0x5C46 },
        { 0x6137, 0x5C47 },
        { 0x6221, 0x5C48 },
        { 0x6222, 0x5C49 },
        { 0x6413, 0x5C4A },
        { 0x643E, 0x5C4B },
        { 0x641E, 0x5C4C },
        { 0x642A, 0x5C4D },
        { 0x642D, 0x5C4E },
        { 0x643D, 0x5C4F },
        { 0x642C, 0x5C50 },
        { 0x640F, 0x5C51 },
        { 0x641C, 0x5C52 },
        { 0x6414, 0x5C53 },
        { 0x640D, 0x5C54 },
        { 0x6436, 0x5C55 },
        { 0x6416, 0x5C56 },
        { 0x6417, 0x5C57 },
        { 0x6406, 0x5C58 },
        { 0x656C, 0x5C59 },
        { 0x659F, 0x5C5A },
        { 0x65B0, 0x5C5B },
        { 0x6697, 0x5C5C },
        { 0x6689, 0x5C5D },
        { 0x6687, 0x5C5E },
        { 0x6688, 0x5C5F },
        { 0x6696, 0x5C60 },
        { 0x6684, 0x5C61 },
        { 0x6698, 0x5C62 },
        { 0x668D, 0x5C63 },
        { 0x6703, 0x5C64 },
        { 0x6994, 0x5C65 },
        { 0x696D, 0x5C66 },
        { 0x695A, 0x5C67 },
        { 0x6977, 0x5C68 },
        { 0x6960, 0x5C69 },
        { 0x6954, 0x5C6A },
        { 0x6975, 0x5C6B },
        { 0x6930, 0x5C6C },
        { 0x6982, 0x5C6D },
        { 0x694A, 0x5C6E },
        { 0x6968, 0x5C6F },
        { 0x696B, 0x5C70 },
        { 0x695E, 0x5C71 },
        { 0x6953, 0x5C72 },
        { 0x6979, 0x5C73 },
        { 0x6986, 0x5C74 },
        { 0x695D, 0x5C75 },
        { 0x6963, 0x5C76 },
        { 0x695B, 0x5C77 },
        { 0x6B47, 0x5C78 },
        { 0x6B72, 0x5C79 },
        { 0x6BC0, 0x5C7A },
        { 0x6BBF, 0x5C7B },
        { 0x6BD3, 0x5C7C },
        { 0x6BFD, 0x5C7D },
        { 0x6EA2, 0x5C7E },
        { 0x6EAF, 0x5C7F },
        { 0x6ED3, 0x5C81 },
        { 0x6EB6, 0x5C82 },
        { 0x6EC2, 0x5C83 },
        { 0x6E90, 0x5C84 },
        { 0x6E9D, 0x5C85 },
        { 0x6EC7, 0x5C86 },
        { 0x6EC5, 0x5C87 },
        { 0x6EA5, 0x5C88 },
        { 0x6E98, 0x5C89 },
        { 0x6EBC, 0x5C8A },
        { 0x6EBA, 0x5C8B },
        { 0x6EAB, 0x5C8C },
        { 0x6ED1, 0x5C8D },
        { 0x6E96, 0x5C8E },
        { 0x6E9C, 0x5C8F },
        { 0x6EC4, 0x5C90 },
        { 0x6ED4, 0x5C91 },
        { 0x6EAA, 0x5C92 },
        { 0x6EA7, 0x5C93 },
        { 0x6EB4, 0x5C94 },
        { 0x714E, 0x5C95 },
        { 0x7159, 0x5C96 },
        { 0x7169, 0x5C97 },
        { 0x7164, 0x5C98 },
        { 0x7149, 0x5C99 },
        { 0x7167, 0x5C9A },
        { 0x715C, 0x5C9B },
        { 0x716C, 0x5C9C },
        { 0x7166, 0x5C9D },
        { 0x714C, 0x5C9E },
        { 0x7165, 0x5C9F },
        { 0x715E, 0x5CA0 },
        { 0x7146, 0x5CA1 },
        { 0x7168, 0x5CA2 },
        { 0x7156, 0x5CA3 },
        { 0x723A, 0x5CA4 },
        { 0x7252, 0x5CA5 },
        { 0x7337, 0x5CA6 },
        { 0x7345, 0x5CA7 },
        { 0x733F, 0x5CA8 },
        { 0x733E, 0x5CA9 },
        { 0x746F, 0x5CAA },
        { 0x745A, 0x5CAB },
        { 0x7455, 0x5CAC },
        { 0x745F, 0x5CAD },
        { 0x745E, 0x5CAE },
        { 0x7441, 0x5CAF },
        { 0x743F, 0x5CB0 },
        { 0x7459, 0x5CB1 },
        { 0x745B, 0x5CB2 },
        { 0x745C, 0x5CB3 },
        { 0x7576, 0x5CB4 },
        { 0x7578, 0x5CB5 },
        { 0x7600, 0x5CB6 },
        { 0x75F0, 0x5CB7 },
        { 0x7601, 0x5CB8 },
        { 0x75F2, 0x5CB9 },
        { 0x75F1, 0x5CBA },
        { 0x75FA, 0x5CBB },
        { 0x75FF, 0x5CBC },
        { 0x75F4, 0x5CBD },
        { 0x75F3, 0x5CBE },
        { 0x76DE, 0x5CBF },
        { 0x76DF, 0x5CC0 },
        { 0x775B, 0x5CC1 },
        { 0x776B, 0x5CC2 },
        { 0x7766, 0x5CC3 },
        { 0x775E, 0x5CC4 },
        { 0x7763, 0x5CC5 },
        { 0x7779, 0x5CC6 },
        { 0x776A, 0x5CC7 },
        { 0x776C, 0x5CC8 },
        { 0x775C, 0x5CC9 },
        { 0x7765, 0x5CCA },
        { 0x7768, 0x5CCB },
        { 0x7762, 0x5CCC },
        { 0x77EE, 0x5CCD },
        { 0x788E, 0x5CCE },
        { 0x78B0, 0x5CCF },
        { 0x7897, 0x5CD0 },
        { 0x7898, 0x5CD1 },
        { 0x788C, 0x5CD2 },
        { 0x7889, 0x5CD3 },
        { 0x787C, 0x5CD4 },
        { 0x7891, 0x5CD5 },
        { 0x7893, 0x5CD6 },
        { 0x787F, 0x5CD7 },
        { 0x797A, 0x5CD8 },
        { 0x797F, 0x5CD9 },
        { 0x7981, 0x5CDA },
        { 0x842C, 0x5CDB },
        { 0x79BD, 0x5CDC },
        { 0x7A1C, 0x5CDD },
        { 0x7A1A, 0x5CDE },
        { 0x7A20, 0x5CDF },
        { 0x7A14, 0x5CE0 },
        { 0x7A1F, 0x5CE1 },
        { 0x7A1E, 0x5CE2 },
        { 0x7A9F, 0x5CE3 },
        { 0x7AA0, 0x5CE4 },
        { 0x7B77, 0x5CE5 },
        { 0x7BC0, 0x5CE6 },
        { 0x7B60, 0x5CE7 },
        { 0x7B6E, 0x5CE8 },
        { 0x7B67, 0x5CE9 },
        { 0x7CB1, 0x5CEA },
        { 0x7CB3, 0x5CEB },
        { 0x7CB5, 0x5CEC },
        { 0x7D93, 0x5CED },
        { 0x7D79, 0x5CEE },
        { 0x7D91, 0x5CEF },
        { 0x7D81, 0x5CF0 },
        { 0x7D8F, 0x5CF1 },
        { 0x7D5B, 0x5CF2 },
        { 0x7F6E, 0x5CF3 },
        { 0x7F69, 0x5CF4 },
        { 0x7F6A, 0x5CF5 },
        { 0x7F72, 0x5CF6 },
        { 0x7FA9, 0x5CF7 },
        { 0x7FA8, 0x5CF8 },
        { 0x7FA4, 0x5CF9 },
        { 0x8056, 0x5CFA },
        { 0x8058, 0x5CFB },
        { 0x8086, 0x5CFC },
        { 0x8084, 0x5CFD },
        { 0x8171, 0x5D41 },
        { 0x8170, 0x5D42 },
        { 0x8178, 0x5D43 },
        { 0x8165, 0x5D44 },
        { 0x816E, 0x5D45 },
        { 0x8173, 0x5D46 },
        { 0x816B, 0x5D47 },
        { 0x8179, 0x5D48 },
        { 0x817A, 0x5D49 },
        { 0x8166, 0x5D4A },
        { 0x8205, 0x5D4B },
        { 0x8247, 0x5D4C },
        { 0x8482, 0x5D4D },
        { 0x8477, 0x5D4E },
        { 0x843D, 0x5D4F },
        { 0x8431, 0x5D50 },
        { 0x8475, 0x5D51 },
        { 0x8466, 0x5D52 },
        { 0x846B, 0x5D53 },
        { 0x8449, 0x5D54 },
        { 0x846C, 0x5D55 },
        { 0x845B, 0x5D56 },
        { 0x843C, 0x5D57 },
        { 0x8435, 0x5D58 },
        { 0x8461, 0x5D59 },
        { 0x8463, 0x5D5A },
        { 0x8469, 0x5D5B },
        { 0x846D, 0x5D5C },
        { 0x8446, 0x5D5D },
        { 0x865E, 0x5D5E },
        { 0x865C, 0x5D5F },
        { 0x865F, 0x5D60 },
        { 0x86F9, 0x5D61 },
        { 0x8713, 0x5D62 },
        { 0x8708, 0x5D63 },
        { 0x8707, 0x5D64 },
        { 0x8700, 0x5D65 },
        { 0x86FE, 0x5D66 },
        { 0x86FB, 0x5D67 },
        { 0x8702, 0x5D68 },
        { 0x8703, 0x5D69 },
        { 0x8706, 0x5D6A },
        { 0x870A, 0x5D6B },
        { 0x8859, 0x5D6C },
        { 0x88DF, 0x5D6D },
        { 0x88D4, 0x5D6E },
        { 0x88D9, 0x5D6F },
        { 0x88DC, 0x5D70 },
        { 0x88D8, 0x5D71 },
        { 0x88DD, 0x5D72 },
        { 0x88E1, 0x5D73 },
        { 0x88CA, 0x5D74 },
        { 0x88D5, 0x5D75 },
        { 0x88D2, 0x5D76 },
        { 0x899C, 0x5D77 },
        { 0x89E3, 0x5D78 },
        { 0x8A6B, 0x5D79 },
        { 0x8A72, 0x5D7A },
        { 0x8A73, 0x5D7B },
        { 0x8A66, 0x5D7C },
        { 0x8A69, 0x5D7D },
        { 0x8A70, 0x5D7E },
        { 0x8A87, 0x5D7F },
        { 0x8A7C, 0x5D81 },
        { 0x8A63, 0x5D82 },
        { 0x8AA0, 0x5D83 },
        { 0x8A71, 0x5D84 },
        { 0x8A85, 0x5D85 },
        { 0x8A6D, 0x5D86 },
        { 0x8A62, 0x5D87 },
        { 0x8A6E, 0x5D88 },
        { 0x8A6C, 0x5D89 },
        { 0x8A79, 0x5D8A },
        { 0x8A7B, 0x5D8B },
        { 0x8A3E, 0x5D8C },
        { 0x8A68, 0x5D8D },
        { 0x8C62, 0x5D8E },
        { 0x8C8A, 0x5D8F },
        { 0x8C89, 0x5D90 },
        { 0x8CCA, 0x5D91 },
        { 0x8CC7, 0x5D92 },
        { 0x8CC8, 0x5D93 },
        { 0x8CC4, 0x5D94 },
        { 0x8CB2, 0x5D95 },
        { 0x8CC3, 0x5D96 },
        { 0x8CC2, 0x5D97 },
        { 0x8CC5, 0x5D98 },
        { 0x8DE1, 0x5D99 },
        { 0x8DDF, 0x5D9A },
        { 0x8DE8, 0x5D9B },
        { 0x8DEF, 0x5D9C },
        { 0x8DF3, 0x5D9D },
        { 0x8DFA, 0x5D9E },
        { 0x8DEA, 0x5D9F },
        { 0x8DE4, 0x5DA0 },
        { 0x8DE6, 0x5DA1 },
        { 0x8EB2, 0x5DA2 },
        { 0x8F03, 0x5DA3 },
        { 0x8F09, 0x5DA4 },
        { 0x8EFE, 0x5DA5 },
        { 0x8F0A, 0x5DA6 },
        { 0x8F9F, 0x5DA7 },
        { 0x8FB2, 0x5DA8 },
        { 0x904B, 0x5DA9 },
        { 0x904A, 0x5DAA },
        { 0x9053, 0x5DAB },
        { 0x9042, 0x5DAC },
        { 0x9054, 0x5DAD },
        { 0x903C, 0x5DAE },
        { 0x9055, 0x5DAF },
        { 0x9050, 0x5DB0 },
        { 0x9047, 0x5DB1 },
        { 0x904F, 0x5DB2 },
        { 0x904E, 0x5DB3 },
        { 0x904D, 0x5DB4 },
        { 0x9051, 0x5DB5 },
        { 0x903E, 0x5DB6 },
        { 0x9041, 0x5DB7 },
        { 0x9112, 0x5DB8 },
        { 0x9117, 0x5DB9 },
        { 0x916C, 0x5DBA },
        { 0x916A, 0x5DBB },
        { 0x9169, 0x5DBC },
        { 0x91C9, 0x5DBD },
        { 0x9237, 0x5DBE },
        { 0x9257, 0x5DBF },
        { 0x9238, 0x5DC0 },
        { 0x923D, 0x5DC1 },
        { 0x9240, 0x5DC2 },
        { 0x923E, 0x5DC3 },
        { 0x925B, 0x5DC4 },
        { 0x924B, 0x5DC5 },
        { 0x9264, 0x5DC6 },
        { 0x9251, 0x5DC7 },
        { 0x9234, 0x5DC8 },
        { 0x9249, 0x5DC9 },
        { 0x924D, 0x5DCA },
        { 0x9245, 0x5DCB },
        { 0x9239, 0x5DCC },
        { 0x923F, 0x5DCD },
        { 0x925A, 0x5DCE },
        { 0x9598, 0x5DCF },
        { 0x9698, 0x5DD0 },
        { 0x9694, 0x5DD1 },
        { 0x9695, 0x5DD2 },
        { 0x96CD, 0x5DD3 },
        { 0x96CB, 0x5DD4 },
        { 0x96C9, 0x5DD5 },
        { 0x96CA, 0x5DD6 },
        { 0x96F7, 0x5DD7 },
        { 0x96FB, 0x5DD8 },
        { 0x96F9, 0x5DD9 },
        { 0x96F6, 0x5DDA },
        { 0x9756, 0x5DDB },
        { 0x9774, 0x5DDC },
        { 0x9776, 0x5DDD },
        { 0x9810, 0x5DDE },
        { 0x9811, 0x5DDF },
        { 0x9813, 0x5DE0 },
        { 0x980A, 0x5DE1 },
        { 0x9812, 0x5DE2 },
        { 0x980C, 0x5DE3 },
        { 0x98FC, 0x5DE4 },
        { 0x98F4, 0x5DE5 },
        { 0x98FD, 0x5DE6 },
        { 0x98FE, 0x5DE7 },
        { 0x99B3, 0x5DE8 },
        { 0x99B1, 0x5DE9 },
        { 0x99B4, 0x5DEA },
        { 0x9AE1, 0x5DEB },
        { 0x9CE9, 0x5DEC },
        { 0x9E82, 0x5DED },
        { 0x9F0E, 0x5DEE },
        { 0x9F13, 0x5DEF },
        { 0x9F20, 0x5DF0 },
        { 0x50E7, 0x5DF1 },
        { 0x50EE, 0x5DF2 },
        { 0x50E5, 0x5DF3 },
        { 0x50D6, 0x5DF4 },
        { 0x50ED, 0x5DF5 },
        { 0x50DA, 0x5DF6 },
        { 0x50D5, 0x5DF7 },
        { 0x50CF, 0x5DF8 },
        { 0x50D1, 0x5DF9 },
        { 0x50F1, 0x5DFA },
        { 0x50CE, 0x5DFB },
        { 0x50E9, 0x5DFC },
        { 0x5162, 0x5DFD },
        { 0x51F3, 0x5E41 },
        { 0x5283, 0x5E42 },
        { 0x5282, 0x5E43 },
        { 0x5331, 0x5E44 },
        { 0x53AD, 0x5E45 },
        { 0x55FE, 0x5E46 },
        { 0x5600, 0x5E47 },
        { 0x561B, 0x5E48 },
        { 0x5617, 0x5E49 },
        { 0x55FD, 0x5E4A },
        { 0x5614, 0x5E4B },
        { 0x5606, 0x5E4C },
        { 0x5609, 0x5E4D },
        { 0x560D, 0x5E4E },
        { 0x560E, 0x5E4F },
        { 0x55F7, 0x5E50 },
        { 0x5616, 0x5E51 },
        { 0x561F, 0x5E52 },
        { 0x5608, 0x5E53 },
        { 0x5610, 0x5E54 },
        { 0x55F6, 0x5E55 },
        { 0x5718, 0x5E56 },
        { 0x5716, 0x5E57 },
        { 0x5875, 0x5E58 },
        { 0x587E, 0x5E59 },
        { 0x5883, 0x5E5A },
        { 0x5893, 0x5E5B },
        { 0x588A, 0x5E5C },
        { 0x5879, 0x5E5D },
        { 0x5885, 0x5E5E },
        { 0x587D, 0x5E5F },
        { 0x58FD, 0x5E60 },
        { 0x5925, 0x5E61 },
        { 0x5922, 0x5E62 },
        { 0x5924, 0x5E63 },
        { 0x596A, 0x5E64 },
        { 0x5969, 0x5E65 },
        { 0x5AE1, 0x5E66 },
        { 0x5AE6, 0x5E67 },
        { 0x5AE9, 0x5E68 },
        { 0x5AD7, 0x5E69 },
        { 0x5AD6, 0x5E6A },
        { 0x5AD8, 0x5E6B },
        { 0x5AE3, 0x5E6C },
        { 0x5B75, 0x5E6D },
        { 0x5BDE, 0x5E6E },
        { 0x5BE7, 0x5E6F },
        { 0x5BE1, 0x5E70 },
        { 0x5BE5, 0x5E71 },
        { 0x5BE6, 0x5E72 },
        { 0x5BE8, 0x5E73 },
        { 0x5BE2, 0x5E74 },
        { 0x5BE4, 0x5E75 },
        { 0x5BDF, 0x5E76 },
        { 0x5C0D, 0x5E77 },
        { 0x5C62, 0x5E78 },
        { 0x5D84, 0x5E79 },
        { 0x5D87, 0x5E7A },
        { 0x5E5B, 0x5E7B },
        { 0x5E63, 0x5E7C },
        { 0x5E55, 0x5E7D },
        { 0x5E57, 0x5E7E },
        { 0x5E54, 0x5E7F },
        { 0x5ED3, 0x5E81 },
        { 0x5ED6, 0x5E82 },
        { 0x5F0A, 0x5E83 },
        { 0x5F46, 0x5E84 },
        { 0x5F70, 0x5E85 },
        { 0x5FB9, 0x5E86 },
        { 0x6147, 0x5E87 },
        { 0x613F, 0x5E88 },
        { 0x614B, 0x5E89 },
        { 0x6177, 0x5E8A },
        { 0x6162, 0x5E8B },
        { 0x6163, 0x5E8C },
        { 0x615F, 0x5E8D },
        { 0x615A, 0x5E8E },
        { 0x6158, 0x5E8F },
        { 0x6175, 0x5E90 },
        { 0x622A, 0x5E91 },
        { 0x6487, 0x5E92 },
        { 0x6458, 0x5E93 },
        { 0x6454, 0x5E94 },
        { 0x64A4, 0x5E95 },
        { 0x6478, 0x5E96 },
        { 0x645F, 0x5E97 },
        { 0x647A, 0x5E98 },
        { 0x6451, 0x5E99 },
        { 0x6467, 0x5E9A },
        { 0x6434, 0x5E9B },
        { 0x646D, 0x5E9C },
        { 0x647B, 0x5E9D },
        { 0x6572, 0x5E9E },
        { 0x65A1, 0x5E9F },
        { 0x65D7, 0x5EA0 },
        { 0x65D6, 0x5EA1 },
        { 0x66A2, 0x5EA2 },
        { 0x66A8, 0x5EA3 },
        { 0x669D, 0x5EA4 },
        { 0x699C, 0x5EA5 },
        { 0x69A8, 0x5EA6 },
        { 0x6995, 0x5EA7 },
        { 0x69C1, 0x5EA8 },
        { 0x69AE, 0x5EA9 },
        { 0x69D3, 0x5EAA },
        { 0x69CB, 0x5EAB },
        { 0x699B, 0x5EAC },
        { 0x69B7, 0x5EAD },
        { 0x69BB, 0x5EAE },
        { 0x69AB, 0x5EAF },
        { 0x69B4, 0x5EB0 },
        { 0x69D0, 0x5EB1 },
        { 0x69CD, 0x5EB2 },
        { 0x69AD, 0x5EB3 },
        { 0x69CC, 0x5EB4 },
        { 0x69A6, 0x5EB5 },
        { 0x69C3, 0x5EB6 },
        { 0x69A3, 0x5EB7 },
        { 0x6B49, 0x5EB8 },
        { 0x6B4C, 0x5EB9 },
        { 0x6C33, 0x5EBA },
        { 0x6F33, 0x5EBB },
        { 0x6F14, 0x5EBC },
        { 0x6EFE, 0x5EBD },
        { 0x6F13, 0x5EBE },
        { 0x6EF4, 0x5EBF },
        { 0x6F29, 0x5EC0 },
        { 0x6F3E, 0x5EC1 },
        { 0x6F20, 0x5EC2 },
        { 0x6F2C, 0x5EC3 },
        { 0x6F0F, 0x5EC4 },
        { 0x6F02, 0x5EC5 },
        { 0x6F22, 0x5EC6 },
        { 0x6EFF, 0x5EC7 },
        { 0x6EEF, 0x5EC8 },
        { 0x6F06, 0x5EC9 },
        { 0x6F31, 0x5ECA },
        { 0x6F38, 0x5ECB },
        { 0x6F32, 0x5ECC },
        { 0x6F23, 0x5ECD },
        { 0x6F15, 0x5ECE },
        { 0x6F2B, 0x5ECF },
        { 0x6F2F, 0x5ED0 },
        { 0x6F88, 0x5ED1 },
        { 0x6F2A, 0x5ED2 },
        { 0x6EEC, 0x5ED3 },
        { 0x6F01, 0x5ED4 },
        { 0x6EF2, 0x5ED5 },
        { 0x6ECC, 0x5ED6 },
        { 0x6EF7, 0x5ED7 },
        { 0x7194, 0x5ED8 },
        { 0x7199, 0x5ED9 },
        { 0x717D, 0x5EDA },
        { 0x718A, 0x5EDB },
        { 0x7184, 0x5EDC },
        { 0x7192, 0x5EDD },
        { 0x723E, 0x5EDE },
        { 0x7292, 0x5EDF },
        { 0x7296, 0x5EE0 },
        { 0x7344, 0x5EE1 },
        { 0x7350, 0x5EE2 },
        { 0x7464, 0x5EE3 },
        { 0x7463, 0x5EE4 },
        { 0x746A, 0x5EE5 },
        { 0x7470, 0x5EE6 },
        { 0x746D, 0x5EE7 },
        { 0x7504, 0x5EE8 },
        { 0x7591, 0x5EE9 },
        { 0x7627, 0x5EEA },
        { 0x760D, 0x5EEB },
        { 0x760B, 0x5EEC },
        { 0x7609, 0x5EED },
        { 0x7613, 0x5EEE },
        { 0x76E1, 0x5EEF },
        { 0x76E3, 0x5EF0 },
        { 0x7784, 0x5EF1 },
        { 0x777D, 0x5EF2 },
        { 0x777F, 0x5EF3 },
        { 0x7761, 0x5EF4 },
        { 0x78C1, 0x5EF5 },
        { 0x789F, 0x5EF6 },
        { 0x78A7, 0x5EF7 },
        { 0x78B3, 0x5EF8 },
        { 0x78A9, 0x5EF9 },
        { 0x78A3, 0x5EFA },
        { 0x798E, 0x5EFB },
        { 0x798F, 0x5EFC },
        { 0x798D, 0x5EFD },
        { 0x7A2E, 0x5F41 },
        { 0x7A31, 0x5F42 },
        { 0x7AAA, 0x5F43 },
        { 0x7AA9, 0x5F44 },
        { 0x7AED, 0x5F45 },
        { 0x7AEF, 0x5F46 },
        { 0x7BA1, 0x5F47 },
        { 0x7B95, 0x5F48 },
        { 0x7B8B, 0x5F49 },
        { 0x7B75, 0x5F4A },
        { 0x7B97, 0x5F4B },
        { 0x7B9D, 0x5F4C },
        { 0x7B94, 0x5F4D },
        { 0x7B8F, 0x5F4E },
        { 0x7BB8, 0x5F4F },
        { 0x7B87, 0x5F50 },
        { 0x7B84, 0x5F51 },
        { 0x7CB9, 0x5F52 },
        { 0x7CBD, 0x5F53 },
        { 0x7CBE, 0x5F54 },
        { 0x7DBB, 0x5F55 },
        { 0x7DB0, 0x5F56 },
        { 0x7D9C, 0x5F57 },
        { 0x7DBD, 0x5F58 },
        { 0x7DBE, 0x5F59 },
        { 0x7DA0, 0x5F5A },
        { 0x7DCA, 0x5F5B },
        { 0x7DB4, 0x5F5C },
        { 0x7DB2, 0x5F5D },
        { 0x7DB1, 0x5F5E },
        { 0x7DBA, 0x5F5F },
        { 0x7DA2, 0x5F60 },
        { 0x7DBF, 0x5F61 },
        { 0x7DB5, 0x5F62 },
        { 0x7DB8, 0x5F63 },
        { 0x7DAD, 0x5F64 },
        { 0x7DD2, 0x5F65 },
        { 0x7DC7, 0x5F66 },
        { 0x7DAC, 0x5F67 },
        { 0x7F70, 0x5F68 },
        { 0x7FE0, 0x5F69 },
        { 0x7FE1, 0x5F6A },
        { 0x7FDF, 0x5F6B },
        { 0x805E, 0x5F6C },
        { 0x805A, 0x5F6D },
        { 0x8087, 0x5F6E },
        { 0x8150, 0x5F6F },
        { 0x8180, 0x5F70 },
        { 0x818F, 0x5F71 },
        { 0x8188, 0x5F72 },
        { 0x818A, 0x5F73 },
        { 0x817F, 0x5F74 },
        { 0x8182, 0x5F75 },
        { 0x81E7, 0x5F76 },
        { 0x81FA, 0x5F77 },
        { 0x8207, 0x5F78 },
        { 0x8214, 0x5F79 },
        { 0x821E, 0x5F7A },
        { 0x824B, 0x5F7B },
        { 0x84C9, 0x5F7C },
        { 0x84BF, 0x5F7D },
        { 0x84C6, 0x5F7E },
        { 0x84C4, 0x5F7F },
        { 0x8499, 0x5F81 },
        { 0x849E, 0x5F82 },
        { 0x84B2, 0x5F83 },
        { 0x849C, 0x5F84 },
        { 0x84CB, 0x5F85 },
        { 0x84B8, 0x5F86 },
        { 0x84C0, 0x5F87 },
        { 0x84D3, 0x5F88 },
        { 0x8490, 0x5F89 },
        { 0x84BC, 0x5F8A },
        { 0x84D1, 0x5F8B },
        { 0x84CA, 0x5F8C },
        { 0x873F, 0x5F8D },
        { 0x871C, 0x5F8E },
        { 0x873B, 0x5F8F },
        { 0x8722, 0x5F90 },
        { 0x8725, 0x5F91 },
        { 0x8734, 0x5F92 },
        { 0x8718, 0x5F93 },
        { 0x8755, 0x5F94 },
        { 0x8737, 0x5F95 },
        { 0x8729, 0x5F96 },
        { 0x88F3, 0x5F97 },
        { 0x8902, 0x5F98 },
        { 0x88F4, 0x5F99 },
        { 0x88F9, 0x5F9A },
        { 0x88F8, 0x5F9B },
        { 0x88FD, 0x5F9C },
        { 0x88E8, 0x5F9D },
        { 0x891A, 0x5F9E },
        { 0x88EF, 0x5F9F },
        { 0x8AA6, 0x5FA0 },
        { 0x8A8C, 0x5FA1 },
        { 0x8A9E, 0x5FA2 },
        { 0x8AA3, 0x5FA3 },
        { 0x8A8D, 0x5FA4 },
        { 0x8AA1, 0x5FA5 },
        { 0x8A93, 0x5FA6 },
        { 0x8AA4, 0x5FA7 },
        { 0x8AAA, 0x5FA8 },
        { 0x8AA5, 0x5FA9 },
        { 0x8AA8, 0x5FAA },
        { 0x8A98, 0x5FAB },
        { 0x8A91, 0x5FAC },
        { 0x8A9A, 0x5FAD },
        { 0x8AA7, 0x5FAE },
        { 0x8C6A, 0x5FAF },
        { 0x8C8D, 0x5FB0 },
        { 0x8C8C, 0x5FB1 },
        { 0x8CD3, 0x5FB2 },
        { 0x8CD1, 0x5FB3 },
        { 0x8CD2, 0x5FB4 },
        { 0x8D6B, 0x5FB5 },
        { 0x8D99, 0x5FB6 },
        { 0x8D95, 0x5FB7 },
        { 0x8DFC, 0x5FB8 },
        { 0x8F14, 0x5FB9 },
        { 0x8F12, 0x5FBA },
        { 0x8F15, 0x5FBB },
        { 0x8F13, 0x5FBC },
        { 0x8FA3, 0x5FBD },
        { 0x9060, 0x5FBE },
        { 0x9058, 0x5FBF },
        { 0x905C, 0x5FC0 },
        { 0x9063, 0x5FC1 },
        { 0x9059, 0x5FC2 },
        { 0x905E, 0x5FC3 },
        { 0x9062, 0x5FC4 },
        { 0x905D, 0x5FC5 },
        { 0x905B, 0x5FC6 },
        { 0x9119, 0x5FC7 },
        { 0x9118, 0x5FC8 },
        { 0x911E, 0x5FC9 },
        { 0x9175, 0x5FCA },
        { 0x9178, 0x5FCB },
        { 0x9177, 0x5FCC },
        { 0x9174, 0x5FCD },
        { 0x9278, 0x5FCE },
        { 0x9280, 0x5FCF },
        { 0x9285, 0x5FD0 },
        { 0x9298, 0x5FD1 },
        { 0x9296, 0x5FD2 },
        { 0x927B, 0x5FD3 },
        { 0x9293, 0x5FD4 },
        { 0x929C, 0x5FD5 },
        { 0x92A8, 0x5FD6 },
        { 0x927C, 0x5FD7 },
        { 0x9291, 0x5FD8 },
        { 0x95A1, 0x5FD9 },
        { 0x95A8, 0x5FDA },
        { 0x95A9, 0x5FDB },
        { 0x95A3, 0x5FDC },
        { 0x95A5, 0x5FDD },
        { 0x95A4, 0x5FDE },
        { 0x9699, 0x5FDF },
        { 0x969C, 0x5FE0 },
        { 0x969B, 0x5FE1 },
        { 0x96CC, 0x5FE2 },
        { 0x96D2, 0x5FE3 },
        { 0x9700, 0x5FE4 },
        { 0x977C, 0x5FE5 },
        { 0x9785, 0x5FE6 },
        { 0x97F6, 0x5FE7 },
        { 0x9817, 0x5FE8 },
        { 0x9818, 0x5FE9 },
        { 0x98AF, 0x5FEA },
        { 0x98B1, 0x5FEB },
        { 0x9903, 0x5FEC },
        { 0x9905, 0x5FED },
        { 0x990C, 0x5FEE },
        { 0x9909, 0x5FEF },
        { 0x99C1, 0x5FF0 },
        { 0x9AAF, 0x5FF1 },
        { 0x9AB0, 0x5FF2 },
        { 0x9AE6, 0x5FF3 },
        { 0x9B41, 0x5FF4 },
        { 0x9B42, 0x5FF5 },
        { 0x9CF4, 0x5FF6 },
        { 0x9CF6, 0x5FF7 },
        { 0x9CF3, 0x5FF8 },
        { 0x9EBC, 0x5FF9 },
        { 0x9F3B, 0x5FFA },
        { 0x9F4A, 0x5FFB },
        { 0x5104, 0x5FFC },
        { 0x5100, 0x5FFD },
        { 0x50FB, 0x6041 },
        { 0x50F5, 0x6042 },
        { 0x50F9, 0x6043 },
        { 0x5102, 0x6044 },
        { 0x5108, 0x6045 },
        { 0x5109, 0x6046 },
        { 0x5105, 0x6047 },
        { 0x51DC, 0x6048 },
        { 0x5287, 0x6049 },
        { 0x5288, 0x604A },
        { 0x5289, 0x604B },
        { 0x528D, 0x604C },
        { 0x528A, 0x604D },
        { 0x52F0, 0x604E },
        { 0x53B2, 0x604F },
        { 0x562E, 0x6050 },
        { 0x563B, 0x6051 },
        { 0x5639, 0x6052 },
        { 0x5632, 0x6053 },
        { 0x563F, 0x6054 },
        { 0x5634, 0x6055 },
        { 0x5629, 0x6056 },
        { 0x5653, 0x6057 },
        { 0x564E, 0x6058 },
        { 0x5657, 0x6059 },
        { 0x5674, 0x605A },
        { 0x5636, 0x605B },
        { 0x562F, 0x605C },
        { 0x5630, 0x605D },
        { 0x5880, 0x605E },
        { 0x589F, 0x605F },
        { 0x589E, 0x6060 },
        { 0x58B3, 0x6061 },
        { 0x589C, 0x6062 },
        { 0x58AE, 0x6063 },
        { 0x58A9, 0x6064 },
        { 0x58A6, 0x6065 },
        { 0x596D, 0x6066 },
        { 0x5B09, 0x6067 },
        { 0x5AFB, 0x6068 },
        { 0x5B0B, 0x6069 },
        { 0x5AF5, 0x606A },
        { 0x5B0C, 0x606B },
        { 0x5B08, 0x606C },
        { 0x5BEE, 0x606D },
        { 0x5BEC, 0x606E },
        { 0x5BE9, 0x606F },
        { 0x5BEB, 0x6070 },
        { 0x5C64, 0x6071 },
        { 0x5C65, 0x6072 },
        { 0x5D9D, 0x6073 },
        { 0x5D94, 0x6074 },
        { 0x5E62, 0x6075 },
        { 0x5E5F, 0x6076 },
        { 0x5E61, 0x6077 },
        { 0x5EE2, 0x6078 },
        { 0x5EDA, 0x6079 },
        { 0x5EDF, 0x607A },
        { 0x5EDD, 0x607B },
        { 0x5EE3, 0x607C },
        { 0x5EE0, 0x607D },
        { 0x5F48, 0x607E },
        { 0x5F71, 0x607F },
        { 0x5FB7, 0x6081 },
        { 0x5FB5, 0x6082 },
        { 0x6176, 0x6083 },
        { 0x6167, 0x6084 },
        { 0x616E, 0x6085 },
        { 0x615D, 0x6086 },
        { 0x6155, 0x6087 },
        { 0x6182, 0x6088 },
        { 0x617C, 0x6089 },
        { 0x6170, 0x608A },
        { 0x616B, 0x608B },
        { 0x617E, 0x608C },
        { 0x61A7, 0x608D },
        { 0x6190, 0x608E },
        { 0x61AB, 0x608F },
        { 0x618E, 0x6090 },
        { 0x61AC, 0x6091 },
        { 0x619A, 0x6092 },
        { 0x61A4, 0x6093 },
        { 0x6194, 0x6094 },
        { 0x61AE, 0x6095 },
        { 0x622E, 0x6096 },
        { 0x6469, 0x6097 },
        { 0x646F, 0x6098 },
        { 0x6479, 0x6099 },
        { 0x649E, 0x609A },
        { 0x64B2, 0x609B },
        { 0x6488, 0x609C },
        { 0x6491, 0x609D },
        { 0x64B0, 0x609E },
        { 0x64A5, 0x609F },
        { 0x6493, 0x60A0 },
        { 0x6495, 0x60A1 },
        { 0x64A9, 0x60A2 },
        { 0x6492, 0x60A3 },
        { 0x64AE, 0x60A4 },
        { 0x64AD, 0x60A5 },
        { 0x64AB, 0x60A6 },
        { 0x649A, 0x60A7 },
        { 0x64AC, 0x60A8 },
        { 0x6499, 0x60A9 },
        { 0x64A2, 0x60AA },
        { 0x64B3, 0x60AB },
        { 0x6575, 0x60AC },
        { 0x6577, 0x60AD },
        { 0x6578, 0x60AE },
        { 0x66AE, 0x60AF },
        { 0x66AB, 0x60B0 },
        { 0x66B4, 0x60B1 },
        { 0x66B1, 0x60B2 },
        { 0x6A23, 0x60B3 },
        { 0x6A1F, 0x60B4 },
        { 0x69E8, 0x60B5 },
        { 0x6A01, 0x60B6 },
        { 0x6A1E, 0x60B7 },
        { 0x6A19, 0x60B8 },
        { 0x69FD, 0x60B9 },
        { 0x6A21, 0x60BA },
        { 0x6A13, 0x60BB },
        { 0x6A0A, 0x60BC },
        { 0x69F3, 0x60BD },
        { 0x6A02, 0x60BE },
        { 0x6A05, 0x60BF },
        { 0x69ED, 0x60C0 },
        { 0x6A11, 0x60C1 },
        { 0x6B50, 0x60C2 },
        { 0x6B4E, 0x60C3 },
        { 0x6BA4, 0x60C4 },
        { 0x6BC5, 0x60C5 },
        { 0x6BC6, 0x60C6 },
        { 0x6F3F, 0x60C7 },
        { 0x6F7C, 0x60C8 },
        { 0x6F84, 0x60C9 },
        { 0x6F51, 0x60CA },
        { 0x6F66, 0x60CB },
        { 0x6F54, 0x60CC },
        { 0x6F86, 0x60CD },
        { 0x6F6D, 0x60CE },
        { 0x6F5B, 0x60CF },
        { 0x6F78, 0x60D0 },
        { 0x6F6E, 0x60D1 },
        { 0x6F8E, 0x60D2 },
        { 0x6F7A, 0x60D3 },
        { 0x6F70, 0x60D4 },
        { 0x6F64, 0x60D5 },
        { 0x6F97, 0x60D6 },
        { 0x6F58, 0x60D7 },
        { 0x6ED5, 0x60D8 },
        { 0x6F6F, 0x60D9 },
        { 0x6F60, 0x60DA },
        { 0x6F5F, 0x60DB },
        { 0x719F, 0x60DC },
        { 0x71AC, 0x60DD },
        { 0x71B1, 0x60DE },
        { 0x71A8, 0x60DF },
        { 0x7256, 0x60E0 },
        { 0x729B, 0x60E1 },
        { 0x734E, 0x60E2 },
        { 0x7357, 0x60E3 },
        { 0x7469, 0x60E4 },
        { 0x748B, 0x60E5 },
        { 0x7483, 0x60E6 },
        { 0x747E, 0x60E7 },
        { 0x7480, 0x60E8 },
        { 0x757F, 0x60E9 },
        { 0x7620, 0x60EA },
        { 0x7629, 0x60EB },
        { 0x761F, 0x60EC },
        { 0x7624, 0x60ED },
        { 0x7626, 0x60EE },
        { 0x7621, 0x60EF },
        { 0x7622, 0x60F0 },
        { 0x769A, 0x60F1 },
        { 0x76BA, 0x60F2 },
        { 0x76E4, 0x60F3 },
        { 0x778E, 0x60F4 },
        { 0x7787, 0x60F5 },
        { 0x778C, 0x60F6 },
        { 0x7791, 0x60F7 },
        { 0x778B, 0x60F8 },
        { 0x78CB, 0x60F9 },
        { 0x78C5, 0x60FA },
        { 0x78BA, 0x60FB },
        { 0x78CA, 0x60FC },
        { 0x78BE, 0x60FD },
        { 0x78D5, 0x6141 },
        { 0x78BC, 0x6142 },
        { 0x78D0, 0x6143 },
        { 0x7A3F, 0x6144 },
        { 0x7A3C, 0x6145 },
        { 0x7A40, 0x6146 },
        { 0x7A3D, 0x6147 },
        { 0x7A37, 0x6148 },
        { 0x7A3B, 0x6149 },
        { 0x7AAF, 0x614A },
        { 0x7AAE, 0x614B },
        { 0x7BAD, 0x614C },
        { 0x7BB1, 0x614D },
        { 0x7BC4, 0x614E },
        { 0x7BB4, 0x614F },
        { 0x7BC6, 0x6150 },
        { 0x7BC7, 0x6151 },
        { 0x7BC1, 0x6152 },
        { 0x7BA0, 0x6153 },
        { 0x7BCC, 0x6154 },
        { 0x7CCA, 0x6155 },
        { 0x7DE0, 0x6156 },
        { 0x7DF4, 0x6157 },
        { 0x7DEF, 0x6158 },
        { 0x7DFB, 0x6159 },
        { 0x7DD8, 0x615A },
        { 0x7DEC, 0x615B },
        { 0x7DDD, 0x615C },
        { 0x7DE8, 0x615D },
        { 0x7DE3, 0x615E },
        { 0x7DDA, 0x615F },
        { 0x7DDE, 0x6160 },
        { 0x7DE9, 0x6161 },
        { 0x7D9E, 0x6162 },
        { 0x7DD9, 0x6163 },
        { 0x7DF2, 0x6164 },
        { 0x7DF9, 0x6165 },
        { 0x7F75, 0x6166 },
        { 0x7F77, 0x6167 },
        { 0x7FAF, 0x6168 },
        { 0x7FE9, 0x6169 },
        { 0x8026, 0x616A },
        { 0x819B, 0x616B },
        { 0x819C, 0x616C },
        { 0x819D, 0x616D },
        { 0x81A0, 0x616E },
        { 0x819A, 0x616F },
        { 0x8198, 0x6170 },
        { 0x8517, 0x6171 },
        { 0x853D, 0x6172 },
        { 0x851A, 0x6173 },
        { 0x84EE, 0x6174 },
        { 0x852C, 0x6175 },
        { 0x852D, 0x6176 },
        { 0x8513, 0x6177 },
        { 0x8511, 0x6178 },
        { 0x8523, 0x6179 },
        { 0x8521, 0x617A },
        { 0x8514, 0x617B },
        { 0x84EC, 0x617C },
        { 0x8525, 0x617D },
        { 0x84FF, 0x617E },
        { 0x8506, 0x617F },
        { 0x8782, 0x6181 },
        { 0x8774, 0x6182 },
        { 0x8776, 0x6183 },
        { 0x8760, 0x6184 },
        { 0x8766, 0x6185 },
        { 0x8778, 0x6186 },
        { 0x8768, 0x6187 },
        { 0x8759, 0x6188 },
        { 0x8757, 0x6189 },
        { 0x874C, 0x618A },
        { 0x8753, 0x618B },
        { 0x885B, 0x618C },
        { 0x885D, 0x618D },
        { 0x8910, 0x618E },
        { 0x8907, 0x618F },
        { 0x8912, 0x6190 },
        { 0x8913, 0x6191 },
        { 0x8915, 0x6192 },
        { 0x890A, 0x6193 },
        { 0x8ABC, 0x6194 },
        { 0x8AD2, 0x6195 },
        { 0x8AC7, 0x6196 },
        { 0x8AC4, 0x6197 },
        { 0x8A95, 0x6198 },
        { 0x8ACB, 0x6199 },
        { 0x8AF8, 0x619A },
        { 0x8AB2, 0x619B },
        { 0x8AC9, 0x619C },
        { 0x8AC2, 0x619D },
        { 0x8ABF, 0x619E },
        { 0x8AB0, 0x619F },
        { 0x8AD6, 0x61A0 },
        { 0x8ACD, 0x61A1 },
        { 0x8AB6, 0x61A2 },
        { 0x8AB9, 0x61A3 },
        { 0x8ADB, 0x61A4 },
        { 0x8C4C, 0x61A5 },
        { 0x8C4E, 0x61A6 },
        { 0x8C6C, 0x61A7 },
        { 0x8CE0, 0x61A8 },
        { 0x8CDE, 0x61A9 },
        { 0x8CE6, 0x61AA },
        { 0x8CE4, 0x61AB },
        { 0x8CEC, 0x61AC },
        { 0x8CED, 0x61AD },
        { 0x8CE2, 0x61AE },
        { 0x8CE3, 0x61AF },
        { 0x8CDC, 0x61B0 },
        { 0x8CEA, 0x61B1 },
        { 0x8CE1, 0x61B2 },
        { 0x8D6D, 0x61B3 },
        { 0x8D9F, 0x61B4 },
        { 0x8DA3, 0x61B5 },
        { 0x8E2B, 0x61B6 },
        { 0x8E10, 0x61B7 },
        { 0x8E1D, 0x61B8 },
        { 0x8E22, 0x61B9 },
        { 0x8E0F, 0x61BA },
        { 0x8E29, 0x61BB },
        { 0x8E1F, 0x61BC },
        { 0x8E21, 0x61BD },
        { 0x8E1E, 0x61BE },
        { 0x8EBA, 0x61BF },
        { 0x8F1D, 0x61C0 },
        { 0x8F1B, 0x61C1 },
        { 0x8F1F, 0x61C2 },
        { 0x8F29, 0x61C3 },
        { 0x8F26, 0x61C4 },
        { 0x8F2A, 0x61C5 },
        { 0x8F1C, 0x61C6 },
        { 0x8F1E, 0x61C7 },
        { 0x8F25, 0x61C8 },
        { 0x9069, 0x61C9 },
        { 0x906E, 0x61CA },
        { 0x9068, 0x61CB },
        { 0x906D, 0x61CC },
        { 0x9077, 0x61CD },
        { 0x9130, 0x61CE },
        { 0x912D, 0x61CF },
        { 0x9127, 0x61D0 },
        { 0x9131, 0x61D1 },
        { 0x9187, 0x61D2 },
        { 0x9189, 0x61D3 },
        { 0x918B, 0x61D4 },
        { 0x9183, 0x61D5 },
        { 0x92C5, 0x61D6 },
        { 0x92BB, 0x61D7 },
        { 0x92B7, 0x61D8 },
        { 0x92EA, 0x61D9 },
        { 0x92AC, 0x61DA },
        { 0x92E4, 0x61DB },
        { 0x92C1, 0x61DC },
        { 0x92B3, 0x61DD },
        { 0x92BC, 0x61DE },
        { 0x92D2, 0x61DF },
        { 0x92C7, 0x61E0 },
        { 0x92F0, 0x61E1 },
        { 0x92B2, 0x61E2 },
        { 0x95AD, 0x61E3 },
        { 0x95B1, 0x61E4 },
        { 0x9704, 0x61E5 },
        { 0x9706, 0x61E6 },
        { 0x9707, 0x61E7 },
        { 0x9709, 0x61E8 },
        { 0x9760, 0x61E9 },
        { 0x978D, 0x61EA },
        { 0x978B, 0x61EB },
        { 0x978F, 0x61EC },
        { 0x9821, 0x61ED },
        { 0x982B, 0x61EE },
        { 0x981C, 0x61EF },
        { 0x98B3, 0x61F0 },
        { 0x990A, 0x61F1 },
        { 0x9913, 0x61F2 },
        { 0x9912, 0x61F3 },
        { 0x9918, 0x61F4 },
        { 0x99DD, 0x61F5 },
        { 0x99D0, 0x61F6 },
        { 0x99DF, 0x61F7 },
        { 0x99DB, 0x61F8 },
        { 0x99D1, 0x61F9 },
        { 0x99D5, 0x61FA },
        { 0x99D2, 0x61FB },
        { 0x99D9, 0x61FC },
        { 0x9AB7, 0x61FD },
        { 0x9AEE, 0x6241 },
        { 0x9AEF, 0x6242 },
        { 0x9B27, 0x6243 },
        { 0x9B45, 0x6244 },
        { 0x9B44, 0x6245 },
        { 0x9B77, 0x6246 },
        { 0x9B6F, 0x6247 },
        { 0x9D06, 0x6248 },
        { 0x9D09, 0x6249 },
        { 0x9D03, 0x624A },
        { 0x9EA9, 0x624B },
        { 0x9EBE, 0x624C },
        { 0x9ECE, 0x624D },
        { 0x58A8, 0x624E },
        { 0x9F52, 0x624F },
        { 0x5112, 0x6250 },
        { 0x5118, 0x6251 },
        { 0x5114, 0x6252 },
        { 0x5110, 0x6253 },
        { 0x5115, 0x6254 },
        { 0x5180, 0x6255 },
        { 0x51AA, 0x6256 },
        { 0x51DD, 0x6257 },
        { 0x5291, 0x6258 },
        { 0x5293, 0x6259 },
        { 0x52F3, 0x625A },
        { 0x5659, 0x625B },
        { 0x566B, 0x625C },
        { 0x5679, 0x625D },
        { 0x5669, 0x625E },
        { 0x5664, 0x625F },
        { 0x5678, 0x6260 },
        { 0x566A, 0x6261 },
        { 0x5668, 0x6262 },
        { 0x5665, 0x6263 },
        { 0x5671, 0x6264 },
        { 0x566F, 0x6265 },
        { 0x566C, 0x6266 },
        { 0x5662, 0x6267 },
        { 0x5676, 0x6268 },
        { 0x58C1, 0x6269 },
        { 0x58BE, 0x626A },
        { 0x58C7, 0x626B },
        { 0x58C5, 0x626C },
        { 0x596E, 0x626D },
        { 0x5B1D, 0x626E },
        { 0x5B34, 0x626F },
        { 0x5B78, 0x6270 },
        { 0x5BF0, 0x6271 },
        { 0x5C0E, 0x6272 },
        { 0x5F4A, 0x6273 },
        { 0x61B2, 0x6274 },
        { 0x6191, 0x6275 },
        { 0x61A9, 0x6276 },
        { 0x618A, 0x6277 },
        { 0x61CD, 0x6278 },
        { 0x61B6, 0x6279 },
        { 0x61BE, 0x627A },
        { 0x61CA, 0x627B },
        { 0x61C8, 0x627C },
        { 0x6230, 0x627D },
        { 0x64C5, 0x627E },
        { 0x64C1, 0x627F },
        { 0x64CB, 0x6281 },
        { 0x64BB, 0x6282 },
        { 0x64BC, 0x6283 },
        { 0x64DA, 0x6284 },
        { 0x64C4, 0x6285 },
        { 0x64C7, 0x6286 },
        { 0x64C2, 0x6287 },
        { 0x64CD, 0x6288 },
        { 0x64BF, 0x6289 },
        { 0x64D2, 0x628A },
        { 0x64D4, 0x628B },
        { 0x64BE, 0x628C },
        { 0x6574, 0x628D },
        { 0x66C6, 0x628E },
        { 0x66C9, 0x628F },
        { 0x66B9, 0x6290 },
        { 0x66C4, 0x6291 },
        { 0x66C7, 0x6292 },
        { 0x66B8, 0x6293 },
        { 0x6A3D, 0x6294 },
        { 0x6A38, 0x6295 },
        { 0x6A3A, 0x6296 },
        { 0x6A59, 0x6297 },
        { 0x6A6B, 0x6298 },
        { 0x6A58, 0x6299 },
        { 0x6A39, 0x629A },
        { 0x6A44, 0x629B },
        { 0x6A62, 0x629C },
        { 0x6A61, 0x629D },
        { 0x6A4B, 0x629E },
        { 0x6A47, 0x629F },
        { 0x6A35, 0x62A0 },
        { 0x6A5F, 0x62A1 },
        { 0x6A48, 0x62A2 },
        { 0x6B59, 0x62A3 },
        { 0x6B77, 0x62A4 },
        { 0x6C05, 0x62A5 },
        { 0x6FC2, 0x62A6 },
        { 0x6FB1, 0x62A7 },
        { 0x6FA1, 0x62A8 },
        { 0x6FC3, 0x62A9 },
        { 0x6FA4, 0x62AA },
        { 0x6FC1, 0x62AB },
        { 0x6FA7, 0x62AC },
        { 0x6FB3, 0x62AD },
        { 0x6FC0, 0x62AE },
        { 0x6FB9, 0x62AF },
        { 0x6FB6, 0x62B0 },
        { 0x6FA6, 0x62B1 },
        { 0x6FA0, 0x62B2 },
        { 0x6FB4, 0x62B3 },
        { 0x71BE, 0x62B4 },
        { 0x71C9, 0x62B5 },
        { 0x71D0, 0x62B6 },
        { 0x71D2, 0x62B7 },
        { 0x71C8, 0x62B8 },
        { 0x71D5, 0x62B9 },
        { 0x71B9, 0x62BA },
        { 0x71CE, 0x62BB },
        { 0x71D9, 0x62BC },
        { 0x71DC, 0x62BD },
        { 0x71C3, 0x62BE },
        { 0x71C4, 0x62BF },
        { 0x7368, 0x62C0 },
        { 0x749C, 0x62C1 },
        { 0x74A3, 0x62C2 },
        { 0x7498, 0x62C3 },
        { 0x749F, 0x62C4 },
        { 0x749E, 0x62C5 },
        { 0x74E2, 0x62C6 },
        { 0x750C, 0x62C7 },
        { 0x750D, 0x62C8 },
        { 0x7634, 0x62C9 },
        { 0x7638, 0x62CA },
        { 0x763A, 0x62CB },
        { 0x76E7, 0x62CC },
        { 0x76E5, 0x62CD },
        { 0x77A0, 0x62CE },
        { 0x779E, 0x62CF },
        { 0x779F, 0x62D0 },
        { 0x77A5, 0x62D1 },
        { 0x78E8, 0x62D2 },
        { 0x78DA, 0x62D3 },
        { 0x78EC, 0x62D4 },
        { 0x78E7, 0x62D5 },
        { 0x79A6, 0x62D6 },
        { 0x7A4D, 0x62D7 },
        { 0x7A4E, 0x62D8 },
        { 0x7A46, 0x62D9 },
        { 0x7A4C, 0x62DA },
        { 0x7A4B, 0x62DB },
        { 0x7ABA, 0x62DC },
        { 0x7BD9, 0x62DD },
        { 0x7C11, 0x62DE },
        { 0x7BC9, 0x62DF },
        { 0x7BE4, 0x62E0 },
        { 0x7BDB, 0x62E1 },
        { 0x7BE1, 0x62E2 },
        { 0x7BE9, 0x62E3 },
        { 0x7BE6, 0x62E4 },
        { 0x7CD5, 0x62E5 },
        { 0x7CD6, 0x62E6 },
        { 0x7E0A, 0x62E7 },
        { 0x7E11, 0x62E8 },
        { 0x7E08, 0x62E9 },
        { 0x7E1B, 0x62EA },
        { 0x7E23, 0x62EB },
        { 0x7E1E, 0x62EC },
        { 0x7E1D, 0x62ED },
        { 0x7E09, 0x62EE },
        { 0x7E10, 0x62EF },
        { 0x7F79, 0x62F0 },
        { 0x7FB2, 0x62F1 },
        { 0x7FF0, 0x62F2 },
        { 0x7FF1, 0x62F3 },
        { 0x7FEE, 0x62F4 },
        { 0x8028, 0x62F5 },
        { 0x81B3, 0x62F6 },
        { 0x81A9, 0x62F7 },
        { 0x81A8, 0x62F8 },
        { 0x81FB, 0x62F9 },
        { 0x8208, 0x62FA },
        { 0x8258, 0x62FB },
        { 0x8259, 0x62FC },
        { 0x854A, 0x62FD },
        { 0x8559, 0x6341 },
        { 0x8548, 0x6342 },
        { 0x8568, 0x6343 },
        { 0x8569, 0x6344 },
        { 0x8543, 0x6345 },
        { 0x8549, 0x6346 },
        { 0x856D, 0x6347 },
        { 0x856A, 0x6348 },
        { 0x855E, 0x6349 },
        { 0x8783, 0x634A },
        { 0x879F, 0x634B },
        { 0x879E, 0x634C },
        { 0x87A2, 0x634D },
        { 0x878D, 0x634E },
        { 0x8861, 0x634F },
        { 0x892A, 0x6350 },
        { 0x8932, 0x6351 },
        { 0x8925, 0x6352 },
        { 0x892B, 0x6353 },
        { 0x8921, 0x6354 },
        { 0x89AA, 0x6355 },
        { 0x89A6, 0x6356 },
        { 0x8AE6, 0x6357 },
        { 0x8AFA, 0x6358 },
        { 0x8AEB, 0x6359 },
        { 0x8AF1, 0x635A },
        { 0x8B00, 0x635B },
        { 0x8ADC, 0x635C },
        { 0x8AE7, 0x635D },
        { 0x8AEE, 0x635E },
        { 0x8AFE, 0x635F },
        { 0x8B01, 0x6360 },
        { 0x8B02, 0x6361 },
        { 0x8AF7, 0x6362 },
        { 0x8AED, 0x6363 },
        { 0x8AF3, 0x6364 },
        { 0x8AF6, 0x6365 },
        { 0x8AFC, 0x6366 },
        { 0x8C6B, 0x6367 },
        { 0x8C6D, 0x6368 },
        { 0x8C93, 0x6369 },
        { 0x8CF4, 0x636A },
        { 0x8E44, 0x636B },
        { 0x8E31, 0x636C },
        { 0x8E34, 0x636D },
        { 0x8E42, 0x636E },
        { 0x8E39, 0x636F },
        { 0x8E35, 0x6370 },
        { 0x8F3B, 0x6371 },
        { 0x8F2F, 0x6372 },
        { 0x8F38, 0x6373 },
        { 0x8F33, 0x6374 },
        { 0x8FA8, 0x6375 },
        { 0x8FA6, 0x6376 },
        { 0x9075, 0x6377 },
        { 0x9074, 0x6378 },
        { 0x9078, 0x6379 },
        { 0x9072, 0x637A },
        { 0x907C, 0x637B },
        { 0x907A, 0x637C },
        { 0x9134, 0x637D },
        { 0x9192, 0x637E },
        { 0x9320, 0x637F },
        { 0x9336, 0x6381 },
        { 0x92F8, 0x6382 },
        { 0x9333, 0x6383 },
        { 0x932F, 0x6384 },
        { 0x9322, 0x6385 },
        { 0x92FC, 0x6386 },
        { 0x932B, 0x6387 },
        { 0x9304, 0x6388 },
        { 0x931A, 0x6389 },
        { 0x9310, 0x638A },
        { 0x9326, 0x638B },
        { 0x9321, 0x638C },
        { 0x9315, 0x638D },
        { 0x932E, 0x638E },
        { 0x9319, 0x638F },
        { 0x95BB, 0x6390 },
        { 0x96A7, 0x6391 },
        { 0x96A8, 0x6392 },
        { 0x96AA, 0x6393 },
        { 0x96D5, 0x6394 },
        { 0x970E, 0x6395 },
        { 0x9711, 0x6396 },
        { 0x9716, 0x6397 },
        { 0x970D, 0x6398 },
        { 0x9713, 0x6399 },
        { 0x970F, 0x639A },
        { 0x975B, 0x639B },
        { 0x975C, 0x639C },
        { 0x9766, 0x639D },
        { 0x9798, 0x639E },
        { 0x9830, 0x639F },
        { 0x9838, 0x63A0 },
        { 0x983B, 0x63A1 },
        { 0x9837, 0x63A2 },
        { 0x982D, 0x63A3 },
        { 0x9839, 0x63A4 },
        { 0x9824, 0x63A5 },
        { 0x9910, 0x63A6 },
        { 0x9928, 0x63A7 },
        { 0x991E, 0x63A8 },
        { 0x991B, 0x63A9 },
        { 0x9921, 0x63AA },
        { 0x991A, 0x63AB },
        { 0x99ED, 0x63AC },
        { 0x99E2, 0x63AD },
        { 0x99F1, 0x63AE },
        { 0x9AB8, 0x63AF },
        { 0x9ABC, 0x63B0 },
        { 0x9AFB, 0x63B1 },
        { 0x9AED, 0x63B2 },
        { 0x9B28, 0x63B3 },
        { 0x9B91, 0x63B4 },
        { 0x9D15, 0x63B5 },
        { 0x9D23, 0x63B6 },
        { 0x9D26, 0x63B7 },
        { 0x9D28, 0x63B8 },
        { 0x9D12, 0x63B9 },
        { 0x9D1B, 0x63BA },
        { 0x9ED8, 0x63BB },
        { 0x9ED4, 0x63BC },
        { 0x9F8D, 0x63BD },
        { 0x9F9C, 0x63BE },
        { 0x512A, 0x63BF },
        { 0x511F, 0x63C0 },
        { 0x5121, 0x63C1 },
        { 0x5132, 0x63C2 },
        { 0x52F5, 0x63C3 },
        { 0x568E, 0x63C4 },
        { 0x5680, 0x63C5 },
        { 0x5690, 0x63C6 },
        { 0x5685, 0x63C7 },
        { 0x5687, 0x63C8 },
        { 0x568F, 0x63C9 },
        { 0x58D5, 0x63CA },
        { 0x58D3, 0x63CB },
        { 0x58D1, 0x63CC },
        { 0x58CE, 0x63CD },
        { 0x5B30, 0x63CE },
        { 0x5B2A, 0x63CF },
        { 0x5B24, 0x63D0 },
        { 0x5B7A, 0x63D1 },
        { 0x5C37, 0x63D2 },
        { 0x5C68, 0x63D3 },
        { 0x5DBC, 0x63D4 },
        { 0x5DBA, 0x63D5 },
        { 0x5DBD, 0x63D6 },
        { 0x5DB8, 0x63D7 },
        { 0x5E6B, 0x63D8 },
        { 0x5F4C, 0x63D9 },
        { 0x5FBD, 0x63DA },
        { 0x61C9, 0x63DB },
        { 0x61C2, 0x63DC },
        { 0x61C7, 0x63DD },
        { 0x61E6, 0x63DE },
        { 0x61CB, 0x63DF },
        { 0x6232, 0x63E0 },
        { 0x6234, 0x63E1 },
        { 0x64CE, 0x63E2 },
        { 0x64CA, 0x63E3 },
        { 0x64D8, 0x63E4 },
        { 0x64E0, 0x63E5 },
        { 0x64F0, 0x63E6 },
        { 0x64E6, 0x63E7 },
        { 0x64EC, 0x63E8 },
        { 0x64F1, 0x63E9 },
        { 0x64E2, 0x63EA },
        { 0x64ED, 0x63EB },
        { 0x6582, 0x63EC },
        { 0x6583, 0x63ED },
        { 0x66D9, 0x63EE },
        { 0x66D6, 0x63EF },
        { 0x6A80, 0x63F0 },
        { 0x6A94, 0x63F1 },
        { 0x6A84, 0x63F2 },
        { 0x6AA2, 0x63F3 },
        { 0x6A9C, 0x63F4 },
        { 0x6ADB, 0x63F5 },
        { 0x6AA3, 0x63F6 },
        { 0x6A7E, 0x63F7 },
        { 0x6A97, 0x63F8 },
        { 0x6A90, 0x63F9 },
        { 0x6AA0, 0x63FA },
        { 0x6B5C, 0x63FB },
        { 0x6BAE, 0x63FC },
        { 0x6BDA, 0x63FD },
        { 0x6C08, 0x6441 },
        { 0x6FD8, 0x6442 },
        { 0x6FF1, 0x6443 },
        { 0x6FDF, 0x6444 },
        { 0x6FE0, 0x6445 },
        { 0x6FDB, 0x6446 },
        { 0x6FE4, 0x6447 },
        { 0x6FEB, 0x6448 },
        { 0x6FEF, 0x6449 },
        { 0x6F80, 0x644A },
        { 0x6FEC, 0x644B },
        { 0x6FE1, 0x644C },
        { 0x6FE9, 0x644D },
        { 0x6FD5, 0x644E },
        { 0x6FEE, 0x644F },
        { 0x6FF0, 0x6450 },
        { 0x71E7, 0x6451 },
        { 0x71DF, 0x6452 },
        { 0x71EE, 0x6453 },
        { 0x71E6, 0x6454 },
        { 0x71E5, 0x6455 },
        { 0x71ED, 0x6456 },
        { 0x71EC, 0x6457 },
        { 0x71F4, 0x6458 },
        { 0x71E0, 0x6459 },
        { 0x7235, 0x645A },
        { 0x7246, 0x645B },
        { 0x7370, 0x645C },
        { 0x7372, 0x645D },
        { 0x74A9, 0x645E },
        { 0x74B0, 0x645F },
        { 0x74A6, 0x6460 },
        { 0x74A8, 0x6461 },
        { 0x7646, 0x6462 },
        { 0x7642, 0x6463 },
        { 0x764C, 0x6464 },
        { 0x76EA, 0x6465 },
        { 0x77B3, 0x6466 },
        { 0x77AA, 0x6467 },
        { 0x77B0, 0x6468 },
        { 0x77AC, 0x6469 },
        { 0x77A7, 0x646A },
        { 0x77AD, 0x646B },
        { 0x77EF, 0x646C },
        { 0x78F7, 0x646D },
        { 0x78FA, 0x646E },
        { 0x78F4, 0x646F },
        { 0x78EF, 0x6470 },
        { 0x7901, 0x6471 },
        { 0x79A7, 0x6472 },
        { 0x79AA, 0x6473 },
        { 0x7A57, 0x6474 },
        { 0x7ABF, 0x6475 },
        { 0x7C07, 0x6476 },
        { 0x7C0D, 0x6477 },
        { 0x7BFE, 0x6478 },
        { 0x7BF7, 0x6479 },
        { 0x7C0C, 0x647A },
        { 0x7BE0, 0x647B },
        { 0x7CE0, 0x647C },
        { 0x7CDC, 0x647D },
        { 0x7CDE, 0x647E },
        { 0x7CE2, 0x647F },
        { 0x7CDF, 0x6481 },
        { 0x7CD9, 0x6482 },
        { 0x7CDD, 0x6483 },
        { 0x7E2E, 0x6484 },
        { 0x7E3E, 0x6485 },
        { 0x7E46, 0x6486 },
        { 0x7E37, 0x6487 },
        { 0x7E32, 0x6488 },
        { 0x7E43, 0x6489 },
        { 0x7E2B, 0x648A },
        { 0x7E3D, 0x648B },
        { 0x7E31, 0x648C },
        { 0x7E45, 0x648D },
        { 0x7E41, 0x648E },
        { 0x7E34, 0x648F },
        { 0x7E39, 0x6490 },
        { 0x7E48, 0x6491 },
        { 0x7E35, 0x6492 },
        { 0x7E3F, 0x6493 },
        { 0x7E2F, 0x6494 },
        { 0x7F44, 0x6495 },
        { 0x7FF3, 0x6496 },
        { 0x7FFC, 0x6497 },
        { 0x8071, 0x6498 },
        { 0x8072, 0x6499 },
        { 0x8070, 0x649A },
        { 0x806F, 0x649B },
        { 0x8073, 0x649C },
        { 0x81C6, 0x649D },
        { 0x81C3, 0x649E },
        { 0x81BA, 0x649F },
        { 0x81C2, 0x64A0 },
        { 0x81C0, 0x64A1 },
        { 0x81BF, 0x64A2 },
        { 0x81BD, 0x64A3 },
        { 0x81C9, 0x64A4 },
        { 0x81BE, 0x64A5 },
        { 0x81E8, 0x64A6 },
        { 0x8209, 0x64A7 },
        { 0x8271, 0x64A8 },
        { 0x85AA, 0x64A9 },
        { 0x8584, 0x64AA },
        { 0x857E, 0x64AB },
        { 0x859C, 0x64AC },
        { 0x8591, 0x64AD },
        { 0x8594, 0x64AE },
        { 0x85AF, 0x64AF },
        { 0x859B, 0x64B0 },
        { 0x8587, 0x64B1 },
        { 0x85A8, 0x64B2 },
        { 0x858A, 0x64B3 },
        { 0x8667, 0x64B4 },
        { 0x87C0, 0x64B5 },
        { 0x87D1, 0x64B6 },
        { 0x87B3, 0x64B7 },
        { 0x87D2, 0x64B8 },
        { 0x87C6, 0x64B9 },
        { 0x87AB, 0x64BA },
        { 0x87BB, 0x64BB },
        { 0x87BA, 0x64BC },
        { 0x87C8, 0x64BD },
        { 0x87CB, 0x64BE },
        { 0x893B, 0x64BF },
        { 0x8936, 0x64C0 },
        { 0x8944, 0x64C1 },
        { 0x8938, 0x64C2 },
        { 0x893D, 0x64C3 },
        { 0x89AC, 0x64C4 },
        { 0x8B0E, 0x64C5 },
        { 0x8B17, 0x64C6 },
        { 0x8B19, 0x64C7 },
        { 0x8B1B, 0x64C8 },
        { 0x8B0A, 0x64C9 },
        { 0x8B20, 0x64CA },
        { 0x8B1D, 0x64CB },
        { 0x8B04, 0x64CC },
        { 0x8B10, 0x64CD },
        { 0x8C41, 0x64CE },
        { 0x8C3F, 0x64CF },
        { 0x8C73, 0x64D0 },
        { 0x8CFA, 0x64D1 },
        { 0x8CFD, 0x64D2 },
        { 0x8CFC, 0x64D3 },
        { 0x8CF8, 0x64D4 },
        { 0x8CFB, 0x64D5 },
        { 0x8DA8, 0x64D6 },
        { 0x8E49, 0x64D7 },
        { 0x8E4B, 0x64D8 },
        { 0x8E48, 0x64D9 },
        { 0x8E4A, 0x64DA },
        { 0x8F44, 0x64DB },
        { 0x8F3E, 0x64DC },
        { 0x8F42, 0x64DD },
        { 0x8F45, 0x64DE },
        { 0x8F3F, 0x64DF },
        { 0x907F, 0x64E0 },
        { 0x907D, 0x64E1 },
        { 0x9084, 0x64E2 },
        { 0x9081, 0x64E3 },
        { 0x9082, 0x64E4 },
        { 0x9080, 0x64E5 },
        { 0x9139, 0x64E6 },
        { 0x91A3, 0x64E7 },
        { 0x919E, 0x64E8 },
        { 0x919C, 0x64E9 },
        { 0x934D, 0x64EA },
        { 0x9382, 0x64EB },
        { 0x9328, 0x64EC },
        { 0x9375, 0x64ED },
        { 0x934A, 0x64EE },
        { 0x9365, 0x64EF },
        { 0x934B, 0x64F0 },
        { 0x9318, 0x64F1 },
        { 0x937E, 0x64F2 },
        { 0x936C, 0x64F3 },
        { 0x935B, 0x64F4 },
        { 0x9370, 0x64F5 },
        { 0x935A, 0x64F6 },
        { 0x9354, 0x64F7 },
        { 0x95CA, 0x64F8 },
        { 0x95CB, 0x64F9 },
        { 0x95CC, 0x64FA },
        { 0x95C8, 0x64FB },
        { 0x95C6, 0x64FC },
        { 0x96B1, 0x64FD },
        { 0x96B8, 0x6541 },
        { 0x96D6, 0x6542 },
        { 0x971C, 0x6543 },
        { 0x971E, 0x6544 },
        { 0x97A0, 0x6545 },
        { 0x97D3, 0x6546 },
        { 0x9846, 0x6547 },
        { 0x98B6, 0x6548 },
        { 0x9935, 0x6549 },
        { 0x9A01, 0x654A },
        { 0x99FF, 0x654B },
        { 0x9BAE, 0x654C },
        { 0x9BAB, 0x654D },
        { 0x9BAA, 0x654E },
        { 0x9BAD, 0x654F },
        { 0x9D3B, 0x6550 },
        { 0x9D3F, 0x6551 },
        { 0x9E8B, 0x6552 },
        { 0x9ECF, 0x6553 },
        { 0x9EDE, 0x6554 },
        { 0x9EDC, 0x6555 },
        { 0x9EDD, 0x6556 },
        { 0x9EDB, 0x6557 },
        { 0x9F3E, 0x6558 },
        { 0x9F4B, 0x6559 },
        { 0x53E2, 0x655A },
        { 0x5695, 0x655B },
        { 0x56AE, 0x655C },
        { 0x58D9, 0x655D },
        { 0x58D8, 0x655E },
        { 0x5B38, 0x655F },
        { 0x5F5E, 0x6560 },
        { 0x61E3, 0x6561 },
        { 0x6233, 0x6562 },
        { 0x64F4, 0x6563 },
        { 0x64F2, 0x6564 },
        { 0x64FE, 0x6565 },
        { 0x6506, 0x6566 },
        { 0x64FA, 0x6567 },
        { 0x64FB, 0x6568 },
        { 0x64F7, 0x6569 },
        { 0x65B7, 0x656A },
        { 0x66DC, 0x656B },
        { 0x6726, 0x656C },
        { 0x6AB3, 0x656D },
        { 0x6AAC, 0x656E },
        { 0x6AC3, 0x656F },
        { 0x6ABB, 0x6570 },
        { 0x6AB8, 0x6571 },
        { 0x6AC2, 0x6572 },
        { 0x6AAE, 0x6573 },
        { 0x6AAF, 0x6574 },
        { 0x6B5F, 0x6575 },
        { 0x6B78, 0x6576 },
        { 0x6BAF, 0x6577 },
        { 0x7009, 0x6578 },
        { 0x700B, 0x6579 },
        { 0x6FFE, 0x657A },
        { 0x7006, 0x657B },
        { 0x6FFA, 0x657C },
        { 0x7011, 0x657D },
        { 0x700F, 0x657E },
        { 0x71FB, 0x657F },
        { 0x71FC, 0x6581 },
        { 0x71FE, 0x6582 },
        { 0x71F8, 0x6583 },
        { 0x7377, 0x6584 },
        { 0x7375, 0x6585 },
        { 0x74A7, 0x6586 },
        { 0x74BF, 0x6587 },
        { 0x7515, 0x6588 },
        { 0x7656, 0x6589 },
        { 0x7658, 0x658A },
        { 0x7652, 0x658B },
        { 0x77BD, 0x658C },
        { 0x77BF, 0x658D },
        { 0x77BB, 0x658E },
        { 0x77BC, 0x658F },
        { 0x790E, 0x6590 },
        { 0x79AE, 0x6591 },
        { 0x7A61, 0x6592 },
        { 0x7A62, 0x6593 },
        { 0x7A60, 0x6594 },
        { 0x7AC4, 0x6595 },
        { 0x7AC5, 0x6596 },
        { 0x7C2B, 0x6597 },
        { 0x7C27, 0x6598 },
        { 0x7C2A, 0x6599 },
        { 0x7C1E, 0x659A },
        { 0x7C23, 0x659B },
        { 0x7C21, 0x659C },
        { 0x7CE7, 0x659D },
        { 0x7E54, 0x659E },
        { 0x7E55, 0x659F },
        { 0x7E5E, 0x65A0 },
        { 0x7E5A, 0x65A1 },
        { 0x7E61, 0x65A2 },
        { 0x7E52, 0x65A3 },
        { 0x7E59, 0x65A4 },
        { 0x7F48, 0x65A5 },
        { 0x7FF9, 0x65A6 },
        { 0x7FFB, 0x65A7 },
        { 0x8077, 0x65A8 },
        { 0x8076, 0x65A9 },
        { 0x81CD, 0x65AA },
        { 0x81CF, 0x65AB },
        { 0x820A, 0x65AC },
        { 0x85CF, 0x65AD },
        { 0x85A9, 0x65AE },
        { 0x85CD, 0x65AF },
        { 0x85D0, 0x65B0 },
        { 0x85C9, 0x65B1 },
        { 0x85B0, 0x65B2 },
        { 0x85BA, 0x65B3 },
        { 0x85B9, 0x65B4 },
        { 0x85A6, 0x65B5 },
        { 0x87EF, 0x65B6 },
        { 0x87EC, 0x65B7 },
        { 0x87F2, 0x65B8 },
        { 0x87E0, 0x65B9 },
        { 0x8986, 0x65BA },
        { 0x89B2, 0x65BB },
        { 0x89F4, 0x65BC },
        { 0x8B28, 0x65BD },
        { 0x8B39, 0x65BE },
        { 0x8B2C, 0x65BF },
        { 0x8B2B, 0x65C0 },
        { 0x8C50, 0x65C1 },
        { 0x8D05, 0x65C2 },
        { 0x8E59, 0x65C3 },
        { 0x8E63, 0x65C4 },
        { 0x8E66, 0x65C5 },
        { 0x8E64, 0x65C6 },
        { 0x8E5F, 0x65C7 },
        { 0x8E55, 0x65C8 },
        { 0x8EC0, 0x65C9 },
        { 0x8F49, 0x65CA },
        { 0x8F4D, 0x65CB },
        { 0x9087, 0x65CC },
        { 0x9083, 0x65CD },
        { 0x9088, 0x65CE },
        { 0x91AB, 0x65CF },
        { 0x91AC, 0x65D0 },
        { 0x91D0, 0x65D1 },
        { 0x9394, 0x65D2 },
        { 0x938A, 0x65D3 },
        { 0x9396, 0x65D4 },
        { 0x93A2, 0x65D5 },
        { 0x93B3, 0x65D6 },
        { 0x93AE, 0x65D7 },
        { 0x93AC, 0x65D8 },
        { 0x93B0, 0x65D9 },
        { 0x9398, 0x65DA },
        { 0x939A, 0x65DB },
        { 0x9397, 0x65DC },
        { 0x95D4, 0x65DD },
        { 0x95D6, 0x65DE },
        { 0x95D0, 0x65DF },
        { 0x95D5, 0x65E0 },
        { 0x96E2, 0x65E1 },
        { 0x96DC, 0x65E2 },
        { 0x96D9, 0x65E3 },
        { 0x96DB, 0x65E4 },
        { 0x96DE, 0x65E5 },
        { 0x9724, 0x65E6 },
        { 0x97A3, 0x65E7 },
        { 0x97A6, 0x65E8 },
        { 0x97AD, 0x65E9 },
        { 0x97F9, 0x65EA },
        { 0x984D, 0x65EB },
        { 0x984F, 0x65EC },
        { 0x984C, 0x65ED },
        { 0x984E, 0x65EE },
        { 0x9853, 0x65EF },
        { 0x98BA, 0x65F0 },
        { 0x993E, 0x65F1 },
        { 0x993F, 0x65F2 },
        { 0x993D, 0x65F3 },
        { 0x992E, 0x65F4 },
        { 0x99A5, 0x65F5 },
        { 0x9A0E, 0x65F6 },
        { 0x9AC1, 0x65F7 },
        { 0x9B03, 0x65F8 },
        { 0x9B06, 0x65F9 },
        { 0x9B4F, 0x65FA },
        { 0x9B4E, 0x65FB },
        { 0x9B4D, 0x65FC },
        { 0x9BCA, 0x65FD },
        { 0x9BC9, 0x6641 },
        { 0x9BFD, 0x6642 },
        { 0x9BC8, 0x6643 },
        { 0x9BC0, 0x6644 },
        { 0x9D51, 0x6645 },
        { 0x9D5D, 0x6646 },
        { 0x9D60, 0x6647 },
        { 0x9EE0, 0x6648 },
        { 0x9F15, 0x6649 },
        { 0x9F2C, 0x664A },
        { 0x5133, 0x664B },
        { 0x56A5, 0x664C },
        { 0x58DE, 0x664D },
        { 0x58DF, 0x664E },
        { 0x58E2, 0x664F },
        { 0x5BF5, 0x6650 },
        { 0x9F90, 0x6651 },
        { 0x5EEC, 0x6652 },
        { 0x61F2, 0x6653 },
        { 0x61F7, 0x6654 },
        { 0x61F6, 0x6655 },
        { 0x61F5, 0x6656 },
        { 0x6500, 0x6657 },
        { 0x650F, 0x6658 },
        { 0x66E0, 0x6659 },
        { 0x66DD, 0x665A },
        { 0x6AE5, 0x665B },
        { 0x6ADD, 0x665C },
        { 0x6ADA, 0x665D },
        { 0x6AD3, 0x665E },
        { 0x701B, 0x665F },
        { 0x701F, 0x6660 },
        { 0x7028, 0x6661 },
        { 0x701A, 0x6662 },
        { 0x701D, 0x6663 },
        { 0x7015, 0x6664 },
        { 0x7018, 0x6665 },
        { 0x7206, 0x6666 },
        { 0x720D, 0x6667 },
        { 0x7258, 0x6668 },
        { 0x72A2, 0x6669 },
        { 0x7378, 0x666A },
        { 0x737A, 0x666B },
        { 0x74BD, 0x666C },
        { 0x74CA, 0x666D },
        { 0x74E3, 0x666E },
        { 0x7587, 0x666F },
        { 0x7586, 0x6670 },
        { 0x765F, 0x6671 },
        { 0x7661, 0x6672 },
        { 0x77C7, 0x6673 },
        { 0x7919, 0x6674 },
        { 0x79B1, 0x6675 },
        { 0x7A6B, 0x6676 },
        { 0x7A69, 0x6677 },
        { 0x7C3E, 0x6678 },
        { 0x7C3F, 0x6679 },
        { 0x7C38, 0x667A },
        { 0x7C3D, 0x667B },
        { 0x7C37, 0x667C },
        { 0x7C40, 0x667D },
        { 0x7E6B, 0x667E },
        { 0x7E6D, 0x667F },
        { 0x7E79, 0x6681 },
        { 0x7E69, 0x6682 },
        { 0x7E6A, 0x6683 },
        { 0x7F85, 0x6684 },
        { 0x7E73, 0x6685 },
        { 0x7FB6, 0x6686 },
        { 0x7FB9, 0x6687 },
        { 0x7FB8, 0x6688 },
        { 0x81D8, 0x6689 },
        { 0x85E9, 0x668A },
        { 0x85DD, 0x668B },
        { 0x85EA, 0x668C },
        { 0x85D5, 0x668D },
        { 0x85E4, 0x668E },
        { 0x85E5, 0x668F },
        { 0x85F7, 0x6690 },
        { 0x87FB, 0x6691 },
        { 0x8805, 0x6692 },
        { 0x880D, 0x6693 },
        { 0x87F9, 0x6694 },
        { 0x87FE, 0x6695 },
        { 0x8960, 0x6696 },
        { 0x895F, 0x6697 },
        { 0x8956, 0x6698 },
        { 0x895E, 0x6699 },
        { 0x8B41, 0x669A },
        { 0x8B5C, 0x669B },
        { 0x8B58, 0x669C },
        { 0x8B49, 0x669D },
        { 0x8B5A, 0x669E },
        { 0x8B4E, 0x669F },
        { 0x8B4F, 0x66A0 },
        { 0x8B46, 0x66A1 },
        { 0x8B59, 0x66A2 },
        { 0x8D08, 0x66A3 },
        { 0x8D0A, 0x66A4 },
        { 0x8E7C, 0x66A5 },
        { 0x8E72, 0x66A6 },
        { 0x8E87, 0x66A7 },
        { 0x8E76, 0x66A8 },
        { 0x8E6C, 0x66A9 },
        { 0x8E7A, 0x66AA },
        { 0x8E74, 0x66AB },
        { 0x8F54, 0x66AC },
        { 0x8F4E, 0x66AD },
        { 0x8FAD, 0x66AE },
        { 0x908A, 0x66AF },
        { 0x908B, 0x66B0 },
        { 0x91B1, 0x66B1 },
        { 0x91AE, 0x66B2 },
        { 0x93E1, 0x66B3 },
        { 0x93D1, 0x66B4 },
        { 0x93DF, 0x66B5 },
        { 0x93C3, 0x66B6 },
        { 0x93C8, 0x66B7 },
        { 0x93DC, 0x66B8 },
        { 0x93DD, 0x66B9 },
        { 0x93D6, 0x66BA },
        { 0x93E2, 0x66BB },
        { 0x93CD, 0x66BC },
        { 0x93D8, 0x66BD },
        { 0x93E4, 0x66BE },
        { 0x93D7, 0x66BF },
        { 0x93E8, 0x66C0 },
        { 0x95DC, 0x66C1 },
        { 0x96B4, 0x66C2 },
        { 0x96E3, 0x66C3 },
        { 0x972A, 0x66C4 },
        { 0x9727, 0x66C5 },
        { 0x9761, 0x66C6 },
        { 0x97DC, 0x66C7 },
        { 0x97FB, 0x66C8 },
        { 0x985E, 0x66C9 },
        { 0x9858, 0x66CA },
        { 0x985B, 0x66CB },
        { 0x98BC, 0x66CC },
        { 0x9945, 0x66CD },
        { 0x9949, 0x66CE },
        { 0x9A16, 0x66CF },
        { 0x9A19, 0x66D0 },
        { 0x9B0D, 0x66D1 },
        { 0x9BE8, 0x66D2 },
        { 0x9BE7, 0x66D3 },
        { 0x9BD6, 0x66D4 },
        { 0x9BDB, 0x66D5 },
        { 0x9D89, 0x66D6 },
        { 0x9D61, 0x66D7 },
        { 0x9D72, 0x66D8 },
        { 0x9D6A, 0x66D9 },
        { 0x9D6C, 0x66DA },
        { 0x9E92, 0x66DB },
        { 0x9E97, 0x66DC },
        { 0x9E93, 0x66DD },
        { 0x9EB4, 0x66DE },
        { 0x52F8, 0x66DF },
        { 0x56A8, 0x66E0 },
        { 0x56B7, 0x66E1 },
        { 0x56B6, 0x66E2 },
        { 0x56B4, 0x66E3 },
        { 0x56BC, 0x66E4 },
        { 0x58E4, 0x66E5 },
        { 0x5B40, 0x66E6 },
        { 0x5B43, 0x66E7 },
        { 0x5B7D, 0x66E8 },
        { 0x5BF6, 0x66E9 },
        { 0x5DC9, 0x66EA },
        { 0x61F8, 0x66EB },
        { 0x61FA, 0x66EC },
        { 0x6518, 0x66ED },
        { 0x6514, 0x66EE },
        { 0x6519, 0x66EF },
        { 0x66E6, 0x66F0 },
        { 0x6727, 0x66F1 },
        { 0x6AEC, 0x66F2 },
        { 0x703E, 0x66F3 },
        { 0x7030, 0x66F4 },
        { 0x7032, 0x66F5 },
        { 0x7210, 0x66F6 },
        { 0x737B, 0x66F7 },
        { 0x74CF, 0x66F8 },
        { 0x7662, 0x66F9 },
        { 0x7665, 0x66FA },
        { 0x7926, 0x66FB },
        { 0x792A, 0x66FC },
        { 0x792C, 0x66FD },
        { 0x792B, 0x6741 },
        { 0x7AC7, 0x6742 },
        { 0x7AF6, 0x6743 },
        { 0x7C4C, 0x6744 },
        { 0x7C43, 0x6745 },
        { 0x7C4D, 0x6746 },
        { 0x7CEF, 0x6747 },
        { 0x7CF0, 0x6748 },
        { 0x8FAE, 0x6749 },
        { 0x7E7D, 0x674A },
        { 0x7E7C, 0x674B },
        { 0x7E82, 0x674C },
        { 0x7F4C, 0x674D },
        { 0x8000, 0x674E },
        { 0x81DA, 0x674F },
        { 0x8266, 0x6750 },
        { 0x85FB, 0x6751 },
        { 0x85F9, 0x6752 },
        { 0x8611, 0x6753 },
        { 0x85FA, 0x6754 },
        { 0x8606, 0x6755 },
        { 0x860B, 0x6756 },
        { 0x8607, 0x6757 },
        { 0x860A, 0x6758 },
        { 0x8814, 0x6759 },
        { 0x8815, 0x675A },
        { 0x8964, 0x675B },
        { 0x89BA, 0x675C },
        { 0x89F8, 0x675D },
        { 0x8B70, 0x675E },
        { 0x8B6C, 0x675F },
        { 0x8B66, 0x6760 },
        { 0x8B6F, 0x6761 },
        { 0x8B5F, 0x6762 },
        { 0x8B6B, 0x6763 },
        { 0x8D0F, 0x6764 },
        { 0x8D0D, 0x6765 },
        { 0x8E89, 0x6766 },
        { 0x8E81, 0x6767 },
        { 0x8E85, 0x6768 },
        { 0x8E82, 0x6769 },
        { 0x91B4, 0x676A },
        { 0x91CB, 0x676B },
        { 0x9418, 0x676C },
        { 0x9403, 0x676D },
        { 0x93FD, 0x676E },
        { 0x95E1, 0x676F },
        { 0x9730, 0x6770 },
        { 0x98C4, 0x6771 },
        { 0x9952, 0x6772 },
        { 0x9951, 0x6773 },
        { 0x99A8, 0x6774 },
        { 0x9A2B, 0x6775 },
        { 0x9A30, 0x6776 },
        { 0x9A37, 0x6777 },
        { 0x9A35, 0x6778 },
        { 0x9C13, 0x6779 },
        { 0x9C0D, 0x677A },
        { 0x9E79, 0x677B },
        { 0x9EB5, 0x677C },
        { 0x9EE8, 0x677D },
        { 0x9F2F, 0x677E },
        { 0x9F5F, 0x677F },
        { 0x9F63, 0x6781 },
        { 0x9F61, 0x6782 },
        { 0x5137, 0x6783 },
        { 0x5138, 0x6784 },
        { 0x56C1, 0x6785 },
        { 0x56C0, 0x6786 },
        { 0x56C2, 0x6787 },
        { 0x5914, 0x6788 },
        { 0x5C6C, 0x6789 },
        { 0x5DCD, 0x678A },
        { 0x61FC, 0x678B },
        { 0x61FE, 0x678C },
        { 0x651D, 0x678D },
        { 0x651C, 0x678E },
        { 0x6595, 0x678F },
        { 0x66E9, 0x6790 },
        { 0x6AFB, 0x6791 },
        { 0x6B04, 0x6792 },
        { 0x6AFA, 0x6793 },
        { 0x6BB2, 0x6794 },
        { 0x704C, 0x6795 },
        { 0x721B, 0x6796 },
        { 0x72A7, 0x6797 },
        { 0x74D6, 0x6798 },
        { 0x74D4, 0x6799 },
        { 0x7669, 0x679A },
        { 0x77D3, 0x679B },
        { 0x7C50, 0x679C },
        { 0x7E8F, 0x679D },
        { 0x7E8C, 0x679E },
        { 0x7FBC, 0x679F },
        { 0x8617, 0x67A0 },
        { 0x862D, 0x67A1 },
        { 0x861A, 0x67A2 },
        { 0x8823, 0x67A3 },
        { 0x8822, 0x67A4 },
        { 0x8821, 0x67A5 },
        { 0x881F, 0x67A6 },
        { 0x896A, 0x67A7 },
        { 0x896C, 0x67A8 },
        { 0x89BD, 0x67A9 },
        { 0x8B74, 0x67AA },
        { 0x8B77, 0x67AB },
        { 0x8B7D, 0x67AC },
        { 0x8D13, 0x67AD },
        { 0x8E8A, 0x67AE },
        { 0x8E8D, 0x67AF },
        { 0x8E8B, 0x67B0 },
        { 0x8F5F, 0x67B1 },
        { 0x8FAF, 0x67B2 },
        { 0x91BA, 0x67B3 },
        { 0x942E, 0x67B4 },
        { 0x9433, 0x67B5 },
        { 0x9435, 0x67B6 },
        { 0x943A, 0x67B7 },
        { 0x9438, 0x67B8 },
        { 0x9432, 0x67B9 },
        { 0x942B, 0x67BA },
        { 0x95E2, 0x67BB },
        { 0x9738, 0x67BC },
        { 0x9739, 0x67BD },
        { 0x9732, 0x67BE },
        { 0x97FF, 0x67BF },
        { 0x9867, 0x67C0 },
        { 0x9865, 0x67C1 },
        { 0x9957, 0x67C2 },
        { 0x9A45, 0x67C3 },
        { 0x9A43, 0x67C4 },
        { 0x9A40, 0x67C5 },
        { 0x9A3E, 0x67C6 },
        { 0x9ACF, 0x67C7 },
        { 0x9B54, 0x67C8 },
        { 0x9B51, 0x67C9 },
        { 0x9C2D, 0x67CA },
        { 0x9C25, 0x67CB },
        { 0x9DAF, 0x67CC },
        { 0x9DB4, 0x67CD },
        { 0x9DC2, 0x67CE },
        { 0x9DB8, 0x67CF },
        { 0x9E9D, 0x67D0 },
        { 0x9EEF, 0x67D1 },
        { 0x9F19, 0x67D2 },
        { 0x9F5C, 0x67D3 },
        { 0x9F66, 0x67D4 },
        { 0x9F67, 0x67D5 },
        { 0x513C, 0x67D6 },
        { 0x513B, 0x67D7 },
        { 0x56C8, 0x67D8 },
        { 0x56CA, 0x67D9 },
        { 0x56C9, 0x67DA },
        { 0x5B7F, 0x67DB },
        { 0x5DD4, 0x67DC },
        { 0x5DD2, 0x67DD },
        { 0x5F4E, 0x67DE },
        { 0x61FF, 0x67DF },
        { 0x6524, 0x67E0 },
        { 0x6B0A, 0x67E1 },
        { 0x6B61, 0x67E2 },
        { 0x7051, 0x67E3 },
        { 0x7058, 0x67E4 },
        { 0x7380, 0x67E5 },
        { 0x74E4, 0x67E6 },
        { 0x758A, 0x67E7 },
        { 0x766E, 0x67E8 },
        { 0x766C, 0x67E9 },
        { 0x79B3, 0x67EA },
        { 0x7C60, 0x67EB },
        { 0x7C5F, 0x67EC },
        { 0x807E, 0x67ED },
        { 0x807D, 0x67EE },
        { 0x81DF, 0x67EF },
        { 0x8972, 0x67F0 },
        { 0x896F, 0x67F1 },
        { 0x89FC, 0x67F2 },
        { 0x8B80, 0x67F3 },
        { 0x8D16, 0x67F4 },
        { 0x8D17, 0x67F5 },
        { 0x8E91, 0x67F6 },
        { 0x8E93, 0x67F7 },
        { 0x8F61, 0x67F8 },
        { 0x9148, 0x67F9 },
        { 0x9444, 0x67FA },
        { 0x9451, 0x67FB },
        { 0x9452, 0x67FC },
        { 0x973D, 0x67FD },
        { 0x973E, 0x6841 },
        { 0x97C3, 0x6842 },
        { 0x97C1, 0x6843 },
        { 0x986B, 0x6844 },
        { 0x9955, 0x6845 },
        { 0x9A55, 0x6846 },
        { 0x9A4D, 0x6847 },
        { 0x9AD2, 0x6848 },
        { 0x9B1A, 0x6849 },
        { 0x9C49, 0x684A },
        { 0x9C31, 0x684B },
        { 0x9C3E, 0x684C },
        { 0x9C3B, 0x684D },
        { 0x9DD3, 0x684E },
        { 0x9DD7, 0x684F },
        { 0x9F34, 0x6850 },
        { 0x9F6C, 0x6851 },
        { 0x9F6A, 0x6852 },
        { 0x9F94, 0x6853 },
        { 0x56CC, 0x6854 },
        { 0x5DD6, 0x6855 },
        { 0x6200, 0x6856 },
        { 0x6523, 0x6857 },
        { 0x652B, 0x6858 },
        { 0x652A, 0x6859 },
        { 0x66EC, 0x685A },
        { 0x6B10, 0x685B },
        { 0x74DA, 0x685C },
        { 0x7ACA, 0x685D },
        { 0x7C64, 0x685E },
        { 0x7C63, 0x685F },
        { 0x7C65, 0x6860 },
        { 0x7E93, 0x6861 },
        { 0x7E96, 0x6862 },
        { 0x7E94, 0x6863 },
        { 0x81E2, 0x6864 },
        { 0x8638, 0x6865 },
        { 0x863F, 0x6866 },
        { 0x8831, 0x6867 },
        { 0x8B8A, 0x6868 },
        { 0x9090, 0x6869 },
        { 0x908F, 0x686A },
        { 0x9463, 0x686B },
        { 0x9460, 0x686C },
        { 0x9464, 0x686D },
        { 0x9768, 0x686E },
        { 0x986F, 0x686F },
        { 0x995C, 0x6870 },
        { 0x9A5A, 0x6871 },
        { 0x9A5B, 0x6872 },
        { 0x9A57, 0x6873 },
        { 0x9AD3, 0x6874 },
        { 0x9AD4, 0x6875 },
        { 0x9AD1, 0x6876 },
        { 0x9C54, 0x6877 },
        { 0x9C57, 0x6878 },
        { 0x9C56, 0x6879 },
        { 0x9DE5, 0x687A },
        { 0x9E9F, 0x687B },
        { 0x9EF4, 0x687C },
        { 0x56D1, 0x687D },
        { 0x58E9, 0x687E },
        { 0x652C, 0x687F },
        { 0x705E, 0x6881 },
        { 0x7671, 0x6882 },
        { 0x7672, 0x6883 },
        { 0x77D7, 0x6884 },
        { 0x7F50, 0x6885 },
        { 0x7F88, 0x6886 },
        { 0x8836, 0x6887 },
        { 0x8839, 0x6888 },
        { 0x8862, 0x6889 },
        { 0x8B93, 0x688A },
        { 0x8B92, 0x688B },
        { 0x8B96, 0x688C },
        { 0x8277, 0x688D },
        { 0x8D1B, 0x688E },
        { 0x91C0, 0x688F },
        { 0x946A, 0x6890 },
        { 0x9742, 0x6891 },
        { 0x9748, 0x6892 },
        { 0x9744, 0x6893 },
        { 0x97C6, 0x6894 },
        { 0x9870, 0x6895 },
        { 0x9A5F, 0x6896 },
        { 0x9B22, 0x6897 },
        { 0x9B58, 0x6898 },
        { 0x9C5F, 0x6899 },
        { 0x9DF9, 0x689A },
        { 0x9DFA, 0x689B },
        { 0x9E7C, 0x689C },
        { 0x9E7D, 0x689D },
        { 0x9F07, 0x689E },
        { 0x9F77, 0x689F },
        { 0x9F72, 0x68A0 },
        { 0x5EF3, 0x68A1 },
        { 0x6B16, 0x68A2 },
        { 0x7063, 0x68A3 },
        { 0x7C6C, 0x68A4 },
        { 0x7C6E, 0x68A5 },
        { 0x883B, 0x68A6 },
        { 0x89C0, 0x68A7 },
        { 0x8EA1, 0x68A8 },
        { 0x91C1, 0x68A9 },
        { 0x9472, 0x68AA },
        { 0x9470, 0x68AB },
        { 0x9871, 0x68AC },
        { 0x995E, 0x68AD },
        { 0x9AD6, 0x68AE },
        { 0x9B23, 0x68AF },
        { 0x9ECC, 0x68B0 },
        { 0x7064, 0x68B1 },
        { 0x77DA, 0x68B2 },
        { 0x8B9A, 0x68B3 },
        { 0x9477, 0x68B4 },
        { 0x97C9, 0x68B5 },
        { 0x9A62, 0x68B6 },
        { 0x9A65, 0x68B7 },
        { 0x7E9C, 0x68B8 },
        { 0x8B9C, 0x68B9 },
        { 0x8EAA, 0x68BA },
        { 0x91C5, 0x68BB },
        { 0x947D, 0x68BC },
        { 0x947E, 0x68BD },
        { 0x947C, 0x68BE },
        { 0x9C77, 0x68BF },
        { 0x9C78, 0x68C0 },
        { 0x9EF7, 0x68C1 },
        { 0x8C54, 0x68C2 },
        { 0x947F, 0x68C3 },
        { 0x9E1A, 0x68C4 },
        { 0x7228, 0x68C5 },
        { 0x9A6A, 0x68C6 },
        { 0x9B31, 0x68C7 },
        { 0x9E1B, 0x68C8 },
        { 0x9E1E, 0x68C9 },
        { 0x7C72, 0x68CA },
        { 0x6490, 0x68CB },
        { 0x4E42, 0x6941 },
        { 0x4E5C, 0x6942 },
        { 0x51F5, 0x6943 },
        { 0x531A, 0x6944 },
        { 0x5382, 0x6945 },
        { 0x4E07, 0x6946 },
        { 0x4E0C, 0x6947 },
        { 0x4E47, 0x6948 },
        { 0x4E8D, 0x6949 },
        { 0x56D7, 0x694A },
        { 0xFA0C, 0x694B },
        { 0x5C6E, 0x694C },
        { 0x5F73, 0x694D },
        { 0x4E0F, 0x694E },
        { 0x5187, 0x694F },
        { 0x4E0E, 0x6950 },
        { 0x4E2E, 0x6951 },
        { 0x4E93, 0x6952 },
        { 0x4EC2, 0x6953 },
        { 0x4EC9, 0x6954 },
        { 0x4EC8, 0x6955 },
        { 0x5198, 0x6956 },
        { 0x52FC, 0x6957 },
        { 0x536C, 0x6958 },
        { 0x53B9, 0x6959 },
        { 0x5720, 0x695A },
        { 0x5903, 0x695B },
        { 0x592C, 0x695C },
        { 0x5C10, 0x695D },
        { 0x5DFF, 0x695E },
        { 0x65E1, 0x695F },
        { 0x6BB3, 0x6960 },
        { 0x6BCC, 0x6961 },
        { 0x6C14, 0x6962 },
        { 0x723F, 0x6963 },
        { 0x4E31, 0x6964 },
        { 0x4E3C, 0x6965 },
        { 0x4EE8, 0x6966 },
        { 0x4EDC, 0x6967 },
        { 0x4EE9, 0x6968 },
        { 0x4EE1, 0x6969 },
        { 0x4EDD, 0x696A },
        { 0x4EDA, 0x696B },
        { 0x520C, 0x696C },
        { 0x531C, 0x696D },
        { 0x534C, 0x696E },
        { 0x5722, 0x696F },
        { 0x5723, 0x6970 },
        { 0x5917, 0x6971 },
        { 0x592F, 0x6972 },
        { 0x5B81, 0x6973 },
        { 0x5B84, 0x6974 },
        { 0x5C12, 0x6975 },
        { 0x5C3B, 0x6976 },
        { 0x5C74, 0x6977 },
        { 0x5C73, 0x6978 },
        { 0x5E04, 0x6979 },
        { 0x5E80, 0x697A },
        { 0x5E82, 0x697B },
        { 0x5FC9, 0x697C },
        { 0x6209, 0x697D },
        { 0x6250, 0x697E },
        { 0x6C15, 0x697F },
        { 0x6C36, 0x6981 },
        { 0x6C43, 0x6982 },
        { 0x6C3F, 0x6983 },
        { 0x6C3B, 0x6984 },
        { 0x72AE, 0x6985 },
        { 0x72B0, 0x6986 },
        { 0x738A, 0x6987 },
        { 0x79B8, 0x6988 },
        { 0x808A, 0x6989 },
        { 0x961E, 0x698A },
        { 0x4F0E, 0x698B },
        { 0x4F18, 0x698C },
        { 0x4F2C, 0x698D },
        { 0x4EF5, 0x698E },
        { 0x4F14, 0x698F },
        { 0x4EF1, 0x6990 },
        { 0x4F00, 0x6991 },
        { 0x4EF7, 0x6992 },
        { 0x4F08, 0x6993 },
        { 0x4F1D, 0x6994 },
        { 0x4F02, 0x6995 },
        { 0x4F05, 0x6996 },
        { 0x4F22, 0x6997 },
        { 0x4F13, 0x6998 },
        { 0x4F04, 0x6999 },
        { 0x4EF4, 0x699A },
        { 0x4F12, 0x699B },
        { 0x51B1, 0x699C },
        { 0x5213, 0x699D },
        { 0x5209, 0x699E },
        { 0x5210, 0x699F },
        { 0x52A6, 0x69A0 },
        { 0x5322, 0x69A1 },
        { 0x531F, 0x69A2 },
        { 0x534D, 0x69A3 },
        { 0x538A, 0x69A4 },
        { 0x5407, 0x69A5 },
        { 0x56E1, 0x69A6 },
        { 0x56DF, 0x69A7 },
        { 0x572E, 0x69A8 },
        { 0x572A, 0x69A9 },
        { 0x5734, 0x69AA },
        { 0x593C, 0x69AB },
        { 0x5980, 0x69AC },
        { 0x597C, 0x69AD },
        { 0x5985, 0x69AE },
        { 0x597B, 0x69AF },
        { 0x597E, 0x69B0 },
        { 0x5977, 0x69B1 },
        { 0x597F, 0x69B2 },
        { 0x5B56, 0x69B3 },
        { 0x5C15, 0x69B4 },
        { 0x5C25, 0x69B5 },
        { 0x5C7C, 0x69B6 },
        { 0x5C7A, 0x69B7 },
        { 0x5C7B, 0x69B8 },
        { 0x5C7E, 0x69B9 },
        { 0x5DDF, 0x69BA },
        { 0x5E75, 0x69BB },
        { 0x5E84, 0x69BC },
        { 0x5F02, 0x69BD },
        { 0x5F1A, 0x69BE },
        { 0x5F74, 0x69BF },
        { 0x5FD5, 0x69C0 },
        { 0x5FD4, 0x69C1 },
        { 0x5FCF, 0x69C2 },
        { 0x6265, 0x69C3 },
        { 0x625C, 0x69C4 },
        { 0x625E, 0x69C5 },
        { 0x6264, 0x69C6 },
        { 0x6261, 0x69C7 },
        { 0x6266, 0x69C8 },
        { 0x6262, 0x69C9 },
        { 0x6259, 0x69CA },
        { 0x6260, 0x69CB },
        { 0x625A, 0x69CC },
        { 0x65EF, 0x69CD },
        { 0x65EE, 0x69CE },
        { 0x673E, 0x69CF },
        { 0x6739, 0x69D0 },
        { 0x6738, 0x69D1 },
        { 0x673B, 0x69D2 },
        { 0x673A, 0x69D3 },
        { 0x673F, 0x69D4 },
        { 0x673C, 0x69D5 },
        { 0x6733, 0x69D6 },
        { 0x6C18, 0x69D7 },
        { 0x6C46, 0x69D8 },
        { 0x6C52, 0x69D9 },
        { 0x6C5C, 0x69DA },
        { 0x6C4F, 0x69DB },
        { 0x6C4A, 0x69DC },
        { 0x6C54, 0x69DD },
        { 0x6C4B, 0x69DE },
        { 0x6C4C, 0x69DF },
        { 0x7071, 0x69E0 },
        { 0x725E, 0x69E1 },
        { 0x72B4, 0x69E2 },
        { 0x72B5, 0x69E3 },
        { 0x738E, 0x69E4 },
        { 0x752A, 0x69E5 },
        { 0x767F, 0x69E6 },
        { 0x7A75, 0x69E7 },
        { 0x7F51, 0x69E8 },
        { 0x8278, 0x69E9 },
        { 0x827C, 0x69EA },
        { 0x8280, 0x69EB },
        { 0x827D, 0x69EC },
        { 0x827F, 0x69ED },
        { 0x864D, 0x69EE },
        { 0x897E, 0x69EF },
        { 0x9099, 0x69F0 },
        { 0x9097, 0x69F1 },
        { 0x9098, 0x69F2 },
        { 0x909B, 0x69F3 },
        { 0x9094, 0x69F4 },
        { 0x9622, 0x69F5 },
        { 0x9624, 0x69F6 },
        { 0x9620, 0x69F7 },
        { 0x9623, 0x69F8 },
        { 0x4F56, 0x69F9 },
        { 0x4F3B, 0x69FA },
        { 0x4F62, 0x69FB },
        { 0x4F49, 0x69FC },
        { 0x4F53, 0x69FD },
        { 0x4F64, 0x6A41 },
        { 0x4F3E, 0x6A42 },
        { 0x4F67, 0x6A43 },
        { 0x4F52, 0x6A44 },
        { 0x4F5F, 0x6A45 },
        { 0x4F41, 0x6A46 },
        { 0x4F58, 0x6A47 },
        { 0x4F2D, 0x6A48 },
        { 0x4F33, 0x6A49 },
        { 0x4F3F, 0x6A4A },
        { 0x4F61, 0x6A4B },
        { 0x518F, 0x6A4C },
        { 0x51B9, 0x6A4D },
        { 0x521C, 0x6A4E },
        { 0x521E, 0x6A4F },
        { 0x5221, 0x6A50 },
        { 0x52AD, 0x6A51 },
        { 0x52AE, 0x6A52 },
        { 0x5309, 0x6A53 },
        { 0x5363, 0x6A54 },
        { 0x5372, 0x6A55 },
        { 0x538E, 0x6A56 },
        { 0x538F, 0x6A57 },
        { 0x5430, 0x6A58 },
        { 0x5437, 0x6A59 },
        { 0x542A, 0x6A5A },
        { 0x5454, 0x6A5B },
        { 0x5445, 0x6A5C },
        { 0x5419, 0x6A5D },
        { 0x541C, 0x6A5E },
        { 0x5425, 0x6A5F },
        { 0x5418, 0x6A60 },
        { 0x543D, 0x6A61 },
        { 0x544F, 0x6A62 },
        { 0x5441, 0x6A63 },
        { 0x5428, 0x6A64 },
        { 0x5424, 0x6A65 },
        { 0x5447, 0x6A66 },
        { 0x56EE, 0x6A67 },
        { 0x56E7, 0x6A68 },
        { 0x56E5, 0x6A69 },
        { 0x5741, 0x6A6A },
        { 0x5745, 0x6A6B },
        { 0x574C, 0x6A6C },
        { 0x5749, 0x6A6D },
        { 0x574B, 0x6A6E },
        { 0x5752, 0x6A6F },
        { 0x5906, 0x6A70 },
        { 0x5940, 0x6A71 },
        { 0x59A6, 0x6A72 },
        { 0x5998, 0x6A73 },
        { 0x59A0, 0x6A74 },
        { 0x5997, 0x6A75 },
        { 0x598E, 0x6A76 },
        { 0x59A2, 0x6A77 },
        { 0x5990, 0x6A78 },
        { 0x598F, 0x6A79 },
        { 0x59A7, 0x6A7A },
        { 0x59A1, 0x6A7B },
        { 0x5B8E, 0x6A7C },
        { 0x5B92, 0x6A7D },
        { 0x5C28, 0x6A7E },
        { 0x5C2A, 0x6A7F },
        { 0x5C8D, 0x6A81 },
        { 0x5C8F, 0x6A82 },
        { 0x5C88, 0x6A83 },
        { 0x5C8B, 0x6A84 },
        { 0x5C89, 0x6A85 },
        { 0x5C92, 0x6A86 },
        { 0x5C8A, 0x6A87 },
        { 0x5C86, 0x6A88 },
        { 0x5C93, 0x6A89 },
        { 0x5C95, 0x6A8A },
        { 0x5DE0, 0x6A8B },
        { 0x5E0A, 0x6A8C },
        { 0x5E0E, 0x6A8D },
        { 0x5E8B, 0x6A8E },
        { 0x5E89, 0x6A8F },
        { 0x5E8C, 0x6A90 },
        { 0x5E88, 0x6A91 },
        { 0x5E8D, 0x6A92 },
        { 0x5F05, 0x6A93 },
        { 0x5F1D, 0x6A94 },
        { 0x5F78, 0x6A95 },
        { 0x5F76, 0x6A96 },
        { 0x5FD2, 0x6A97 },
        { 0x5FD1, 0x6A98 },
        { 0x5FD0, 0x6A99 },
        { 0x5FED, 0x6A9A },
        { 0x5FE8, 0x6A9B },
        { 0x5FEE, 0x6A9C },
        { 0x5FF3, 0x6A9D },
        { 0x5FE1, 0x6A9E },
        { 0x5FE4, 0x6A9F },
        { 0x5FE3, 0x6AA0 },
        { 0x5FFA, 0x6AA1 },
        { 0x5FEF, 0x6AA2 },
        { 0x5FF7, 0x6AA3 },
        { 0x5FFB, 0x6AA4 },
        { 0x6000, 0x6AA5 },
        { 0x5FF4, 0x6AA6 },
        { 0x623A, 0x6AA7 },
        { 0x6283, 0x6AA8 },
        { 0x628C, 0x6AA9 },
        { 0x628E, 0x6AAA },
        { 0x628F, 0x6AAB },
        { 0x6294, 0x6AAC },
        { 0x6287, 0x6AAD },
        { 0x6271, 0x6AAE },
        { 0x627B, 0x6AAF },
        { 0x627A, 0x6AB0 },
        { 0x6270, 0x6AB1 },
        { 0x6281, 0x6AB2 },
        { 0x6288, 0x6AB3 },
        { 0x6277, 0x6AB4 },
        { 0x627D, 0x6AB5 },
        { 0x6272, 0x6AB6 },
        { 0x6274, 0x6AB7 },
        { 0x6537, 0x6AB8 },
        { 0x65F0, 0x6AB9 },
        { 0x65F4, 0x6ABA },
        { 0x65F3, 0x6ABB },
        { 0x65F2, 0x6ABC },
        { 0x65F5, 0x6ABD },
        { 0x6745, 0x6ABE },
        { 0x6747, 0x6ABF },
        { 0x6759, 0x6AC0 },
        { 0x6755, 0x6AC1 },
        { 0x674C, 0x6AC2 },
        { 0x6748, 0x6AC3 },
        { 0x675D, 0x6AC4 },
        { 0x674D, 0x6AC5 },
        { 0x675A, 0x6AC6 },
        { 0x674B, 0x6AC7 },
        { 0x6BD0, 0x6AC8 },
        { 0x6C19, 0x6AC9 },
        { 0x6C1A, 0x6ACA },
        { 0x6C78, 0x6ACB },
        { 0x6C67, 0x6ACC },
        { 0x6C6B, 0x6ACD },
        { 0x6C84, 0x6ACE },
        { 0x6C8B, 0x6ACF },
        { 0x6C8F, 0x6AD0 },
        { 0x6C71, 0x6AD1 },
        { 0x6C6F, 0x6AD2 },
        { 0x6C69, 0x6AD3 },
        { 0x6C9A, 0x6AD4 },
        { 0x6C6D, 0x6AD5 },
        { 0x6C87, 0x6AD6 },
        { 0x6C95, 0x6AD7 },
        { 0x6C9C, 0x6AD8 },
        { 0x6C66, 0x6AD9 },
        { 0x6C73, 0x6ADA },
        { 0x6C65, 0x6ADB },
        { 0x6C7B, 0x6ADC },
        { 0x6C8E, 0x6ADD },
        { 0x7074, 0x6ADE },
        { 0x707A, 0x6ADF },
        { 0x7263, 0x6AE0 },
        { 0x72BF, 0x6AE1 },
        { 0x72BD, 0x6AE2 },
        { 0x72C3, 0x6AE3 },
        { 0x72C6, 0x6AE4 },
        { 0x72C1, 0x6AE5 },
        { 0x72BA, 0x6AE6 },
        { 0x72C5, 0x6AE7 },
        { 0x7395, 0x6AE8 },
        { 0x7397, 0x6AE9 },
        { 0x7393, 0x6AEA },
        { 0x7394, 0x6AEB },
        { 0x7392, 0x6AEC },
        { 0x753A, 0x6AED },
        { 0x7539, 0x6AEE },
        { 0x7594, 0x6AEF },
        { 0x7595, 0x6AF0 },
        { 0x7681, 0x6AF1 },
        { 0x793D, 0x6AF2 },
        { 0x8034, 0x6AF3 },
        { 0x8095, 0x6AF4 },
        { 0x8099, 0x6AF5 },
        { 0x8090, 0x6AF6 },
        { 0x8092, 0x6AF7 },
        { 0x809C, 0x6AF8 },
        { 0x8290, 0x6AF9 },
        { 0x828F, 0x6AFA },
        { 0x8285, 0x6AFB },
        { 0x828E, 0x6AFC },
        { 0x8291, 0x6AFD },
        { 0x8293, 0x6B41 },
        { 0x828A, 0x6B42 },
        { 0x8283, 0x6B43 },
        { 0x8284, 0x6B44 },
        { 0x8C78, 0x6B45 },
        { 0x8FC9, 0x6B46 },
        { 0x8FBF, 0x6B47 },
        { 0x909F, 0x6B48 },
        { 0x90A1, 0x6B49 },
        { 0x90A5, 0x6B4A },
        { 0x909E, 0x6B4B },
        { 0x90A7, 0x6B4C },
        { 0x90A0, 0x6B4D },
        { 0x9630, 0x6B4E },
        { 0x9628, 0x6B4F },
        { 0x962F, 0x6B50 },
        { 0x962D, 0x6B51 },
        { 0x4E33, 0x6B52 },
        { 0x4F98, 0x6B53 },
        { 0x4F7C, 0x6B54 },
        { 0x4F85, 0x6B55 },
        { 0x4F7D, 0x6B56 },
        { 0x4F80, 0x6B57 },
        { 0x4F87, 0x6B58 },
        { 0x4F76, 0x6B59 },
        { 0x4F74, 0x6B5A },
        { 0x4F89, 0x6B5B },
        { 0x4F84, 0x6B5C },
        { 0x4F77, 0x6B5D },
        { 0x4F4C, 0x6B5E },
        { 0x4F97, 0x6B5F },
        { 0x4F6A, 0x6B60 },
        { 0x4F9A, 0x6B61 },
        { 0x4F79, 0x6B62 },
        { 0x4F81, 0x6B63 },
        { 0x4F78, 0x6B64 },
        { 0x4F90, 0x6B65 },
        { 0x4F9C, 0x6B66 },
        { 0x4F94, 0x6B67 },
        { 0x4F9E, 0x6B68 },
        { 0x4F92, 0x6B69 },
        { 0x4F82, 0x6B6A },
        { 0x4F95, 0x6B6B },
        { 0x4F6B, 0x6B6C },
        { 0x4F6E, 0x6B6D },
        { 0x519E, 0x6B6E },
        { 0x51BC, 0x6B6F },
        { 0x51BE, 0x6B70 },
        { 0x5235, 0x6B71 },
        { 0x5232, 0x6B72 },
        { 0x5233, 0x6B73 },
        { 0x5246, 0x6B74 },
        { 0x5231, 0x6B75 },
        { 0x52BC, 0x6B76 },
        { 0x530A, 0x6B77 },
        { 0x530B, 0x6B78 },
        { 0x533C, 0x6B79 },
        { 0x5392, 0x6B7A },
        { 0x5394, 0x6B7B },
        { 0x5487, 0x6B7C },
        { 0x547F, 0x6B7D },
        { 0x5481, 0x6B7E },
        { 0x5491, 0x6B7F },
        { 0x5482, 0x6B81 },
        { 0x5488, 0x6B82 },
        { 0x546B, 0x6B83 },
        { 0x547A, 0x6B84 },
        { 0x547E, 0x6B85 },
        { 0x5465, 0x6B86 },
        { 0x546C, 0x6B87 },
        { 0x5474, 0x6B88 },
        { 0x5466, 0x6B89 },
        { 0x548D, 0x6B8A },
        { 0x546F, 0x6B8B },
        { 0x5461, 0x6B8C },
        { 0x5460, 0x6B8D },
        { 0x5498, 0x6B8E },
        { 0x5463, 0x6B8F },
        { 0x5467, 0x6B90 },
        { 0x5464, 0x6B91 },
        { 0x56F7, 0x6B92 },
        { 0x56F9, 0x6B93 },
        { 0x576F, 0x6B94 },
        { 0x5772, 0x6B95 },
        { 0x576D, 0x6B96 },
        { 0x576B, 0x6B97 },
        { 0x5771, 0x6B98 },
        { 0x5770, 0x6B99 },
        { 0x5776, 0x6B9A },
        { 0x5780, 0x6B9B },
        { 0x5775, 0x6B9C },
        { 0x577B, 0x6B9D },
        { 0x5773, 0x6B9E },
        { 0x5774, 0x6B9F },
        { 0x5762, 0x6BA0 },
        { 0x5768, 0x6BA1 },
        { 0x577D, 0x6BA2 },
        { 0x590C, 0x6BA3 },
        { 0x5945, 0x6BA4 },
        { 0x59B5, 0x6BA5 },
        { 0x59BA, 0x6BA6 },
        { 0x59CF, 0x6BA7 },
        { 0x59CE, 0x6BA8 },
        { 0x59B2, 0x6BA9 },
        { 0x59CC, 0x6BAA },
        { 0x59C1, 0x6BAB },
        { 0x59B6, 0x6BAC },
        { 0x59BC, 0x6BAD },
        { 0x59C3, 0x6BAE },
        { 0x59D6, 0x6BAF },
        { 0x59B1, 0x6BB0 },
        { 0x59BD, 0x6BB1 },
        { 0x59C0, 0x6BB2 },
        { 0x59C8, 0x6BB3 },
        { 0x59B4, 0x6BB4 },
        { 0x59C7, 0x6BB5 },
        { 0x5B62, 0x6BB6 },
        { 0x5B65, 0x6BB7 },
        { 0x5B93, 0x6BB8 },
        { 0x5B95, 0x6BB9 },
        { 0x5C44, 0x6BBA },
        { 0x5C47, 0x6BBB },
        { 0x5CAE, 0x6BBC },
        { 0x5CA4, 0x6BBD },
        { 0x5CA0, 0x6BBE },
        { 0x5CB5, 0x6BBF },
        { 0x5CAF, 0x6BC0 },
        { 0x5CA8, 0x6BC1 },
        { 0x5CAC, 0x6BC2 },
        { 0x5C9F, 0x6BC3 },
        { 0x5CA3, 0x6BC4 },
        { 0x5CAD, 0x6BC5 },
        { 0x5CA2, 0x6BC6 },
        { 0x5CAA, 0x6BC7 },
        { 0x5CA7, 0x6BC8 },
        { 0x5C9D, 0x6BC9 },
        { 0x5CA5, 0x6BCA },
        { 0x5CB6, 0x6BCB },
        { 0x5CB0, 0x6BCC },
        { 0x5CA6, 0x6BCD },
        { 0x5E17, 0x6BCE },
        { 0x5E14, 0x6BCF },
        { 0x5E19, 0x6BD0 },
        { 0x5F28, 0x6BD1 },
        { 0x5F22, 0x6BD2 },
        { 0x5F23, 0x6BD3 },
        { 0x5F24, 0x6BD4 },
        { 0x5F54, 0x6BD5 },
        { 0x5F82, 0x6BD6 },
        { 0x5F7E, 0x6BD7 },
        { 0x5F7D, 0x6BD8 },
        { 0x5FDE, 0x6BD9 },
        { 0x5FE5, 0x6BDA },
        { 0x602D, 0x6BDB },
        { 0x6026, 0x6BDC },
        { 0x6019, 0x6BDD },
        { 0x6032, 0x6BDE },
        { 0x600B, 0x6BDF },
        { 0x6034, 0x6BE0 },
        { 0x600A, 0x6BE1 },
        { 0x6017, 0x6BE2 },
        { 0x6033, 0x6BE3 },
        { 0x601A, 0x6BE4 },
        { 0x601E, 0x6BE5 },
        { 0x602C, 0x6BE6 },
        { 0x6022, 0x6BE7 },
        { 0x600D, 0x6BE8 },
        { 0x6010, 0x6BE9 },
        { 0x602E, 0x6BEA },
        { 0x6013, 0x6BEB },
        { 0x6011, 0x6BEC },
        { 0x600C, 0x6BED },
        { 0x6009, 0x6BEE },
        { 0x601C, 0x6BEF },
        { 0x6214, 0x6BF0 },
        { 0x623D, 0x6BF1 },
        { 0x62AD, 0x6BF2 },
        { 0x62B4, 0x6BF3 },
        { 0x62D1, 0x6BF4 },
        { 0x62BE, 0x6BF5 },
        { 0x62AA, 0x6BF6 },
        { 0x62B6, 0x6BF7 },
        { 0x62CA, 0x6BF8 },
        { 0x62AE, 0x6BF9 },
        { 0x62B3, 0x6BFA },
        { 0x62AF, 0x6BFB },
        { 0x62BB, 0x6BFC },
        { 0x62A9, 0x6BFD },
        { 0x62B0, 0x6C41 },
        { 0x62B8, 0x6C42 },
        { 0x653D, 0x6C43 },
        { 0x65A8, 0x6C44 },
        { 0x65BB, 0x6C45 },
        { 0x6609, 0x6C46 },
        { 0x65FC, 0x6C47 },
        { 0x6604, 0x6C48 },
        { 0x6612, 0x6C49 },
        { 0x6608, 0x6C4A },
        { 0x65FB, 0x6C4B },
        { 0x6603, 0x6C4C },
        { 0x660B, 0x6C4D },
        { 0x660D, 0x6C4E },
        { 0x6605, 0x6C4F },
        { 0x65FD, 0x6C50 },
        { 0x6611, 0x6C51 },
        { 0x6610, 0x6C52 },
        { 0x66F6, 0x6C53 },
        { 0x670A, 0x6C54 },
        { 0x6785, 0x6C55 },
        { 0x676C, 0x6C56 },
        { 0x678E, 0x6C57 },
        { 0x6792, 0x6C58 },
        { 0x6776, 0x6C59 },
        { 0x677B, 0x6C5A },
        { 0x6798, 0x6C5B },
        { 0x6786, 0x6C5C },
        { 0x6784, 0x6C5D },
        { 0x6774, 0x6C5E },
        { 0x678D, 0x6C5F },
        { 0x678C, 0x6C60 },
        { 0x677A, 0x6C61 },
        { 0x679F, 0x6C62 },
        { 0x6791, 0x6C63 },
        { 0x6799, 0x6C64 },
        { 0x6783, 0x6C65 },
        { 0x677D, 0x6C66 },
        { 0x6781, 0x6C67 },
        { 0x6778, 0x6C68 },
        { 0x6779, 0x6C69 },
        { 0x6794, 0x6C6A },
        { 0x6B25, 0x6C6B },
        { 0x6B80, 0x6C6C },
        { 0x6B7E, 0x6C6D },
        { 0x6BDE, 0x6C6E },
        { 0x6C1D, 0x6C6F },
        { 0x6C93, 0x6C70 },
        { 0x6CEC, 0x6C71 },
        { 0x6CEB, 0x6C72 },
        { 0x6CEE, 0x6C73 },
        { 0x6CD9, 0x6C74 },
        { 0x6CB6, 0x6C75 },
        { 0x6CD4, 0x6C76 },
        { 0x6CAD, 0x6C77 },
        { 0x6CE7, 0x6C78 },
        { 0x6CB7, 0x6C79 },
        { 0x6CD0, 0x6C7A },
        { 0x6CC2, 0x6C7B },
        { 0x6CBA, 0x6C7C },
        { 0x6CC3, 0x6C7D },
        { 0x6CC6, 0x6C7E },
        { 0x6CED, 0x6C7F },
        { 0x6CF2, 0x6C81 },
        { 0x6CD2, 0x6C82 },
        { 0x6CDD, 0x6C83 },
        { 0x6CB4, 0x6C84 },
        { 0x6C8A, 0x6C85 },
        { 0x6C9D, 0x6C86 },
        { 0x6C80, 0x6C87 },
        { 0x6CDE, 0x6C88 },
        { 0x6CC0, 0x6C89 },
        { 0x6D30, 0x6C8A },
        { 0x6CCD, 0x6C8B },
        { 0x6CC7, 0x6C8C },
        { 0x6CB0, 0x6C8D },
        { 0x6CF9, 0x6C8E },
        { 0x6CCF, 0x6C8F },
        { 0x6CE9, 0x6C90 },
        { 0x6CD1, 0x6C91 },
        { 0x7094, 0x6C92 },
        { 0x7098, 0x6C93 },
        { 0x7085, 0x6C94 },
        { 0x7093, 0x6C95 },
        { 0x7086, 0x6C96 },
        { 0x7084, 0x6C97 },
        { 0x7091, 0x6C98 },
        { 0x7096, 0x6C99 },
        { 0x7082, 0x6C9A },
        { 0x709A, 0x6C9B },
        { 0x7083, 0x6C9C },
        { 0x726A, 0x6C9D },
        { 0x72D6, 0x6C9E },
        { 0x72CB, 0x6C9F },
        { 0x72D8, 0x6CA0 },
        { 0x72C9, 0x6CA1 },
        { 0x72DC, 0x6CA2 },
        { 0x72D2, 0x6CA3 },
        { 0x72D4, 0x6CA4 },
        { 0x72DA, 0x6CA5 },
        { 0x72CC, 0x6CA6 },
        { 0x72D1, 0x6CA7 },
        { 0x73A4, 0x6CA8 },
        { 0x73A1, 0x6CA9 },
        { 0x73AD, 0x6CAA },
        { 0x73A6, 0x6CAB },
        { 0x73A2, 0x6CAC },
        { 0x73A0, 0x6CAD },
        { 0x73AC, 0x6CAE },
        { 0x739D, 0x6CAF },
        { 0x74DD, 0x6CB0 },
        { 0x74E8, 0x6CB1 },
        { 0x753F, 0x6CB2 },
        { 0x7540, 0x6CB3 },
        { 0x753E, 0x6CB4 },
        { 0x758C, 0x6CB5 },
        { 0x7598, 0x6CB6 },
        { 0x76AF, 0x6CB7 },
        { 0x76F3, 0x6CB8 },
        { 0x76F1, 0x6CB9 },
        { 0x76F0, 0x6CBA },
        { 0x76F5, 0x6CBB },
        { 0x77F8, 0x6CBC },
        { 0x77FC, 0x6CBD },
        { 0x77F9, 0x6CBE },
        { 0x77FB, 0x6CBF },
        { 0x77FA, 0x6CC0 },
        { 0x77F7, 0x6CC1 },
        { 0x7942, 0x6CC2 },
        { 0x793F, 0x6CC3 },
        { 0x79C5, 0x6CC4 },
        { 0x7A78, 0x6CC5 },
        { 0x7A7B, 0x6CC6 },
        { 0x7AFB, 0x6CC7 },
        { 0x7C75, 0x6CC8 },
        { 0x7CFD, 0x6CC9 },
        { 0x8035, 0x6CCA },
        { 0x808F, 0x6CCB },
        { 0x80AE, 0x6CCC },
        { 0x80A3, 0x6CCD },
        { 0x80B8, 0x6CCE },
        { 0x80B5, 0x6CCF },
        { 0x80AD, 0x6CD0 },
        { 0x8220, 0x6CD1 },
        { 0x82A0, 0x6CD2 },
        { 0x82C0, 0x6CD3 },
        { 0x82AB, 0x6CD4 },
        { 0x829A, 0x6CD5 },
        { 0x8298, 0x6CD6 },
        { 0x829B, 0x6CD7 },
        { 0x82B5, 0x6CD8 },
        { 0x82A7, 0x6CD9 },
        { 0x82AE, 0x6CDA },
        { 0x82BC, 0x6CDB },
        { 0x829E, 0x6CDC },
        { 0x82BA, 0x6CDD },
        { 0x82B4, 0x6CDE },
        { 0x82A8, 0x6CDF },
        { 0x82A1, 0x6CE0 },
        { 0x82A9, 0x6CE1 },
        { 0x82C2, 0x6CE2 },
        { 0x82A4, 0x6CE3 },
        { 0x82C3, 0x6CE4 },
        { 0x82B6, 0x6CE5 },
        { 0x82A2, 0x6CE6 },
        { 0x8670, 0x6CE7 },
        { 0x866F, 0x6CE8 },
        { 0x866D, 0x6CE9 },
        { 0x866E, 0x6CEA },
        { 0x8C56, 0x6CEB },
        { 0x8FD2, 0x6CEC },
        { 0x8FCB, 0x6CED },
        { 0x8FD3, 0x6CEE },
        { 0x8FCD, 0x6CEF },
        { 0x8FD6, 0x6CF0 },
        { 0x8FD5, 0x6CF1 },
        { 0x8FD7, 0x6CF2 },
        { 0x90B2, 0x6CF3 },
        { 0x90B4, 0x6CF4 },
        { 0x90AF, 0x6CF5 },
        { 0x90B3, 0x6CF6 },
        { 0x90B0, 0x6CF7 },
        { 0x9639, 0x6CF8 },
        { 0x963D, 0x6CF9 },
        { 0x963C, 0x6CFA },
        { 0x963A, 0x6CFB },
        { 0x9643, 0x6CFC },
        { 0x4FCD, 0x6CFD },
        { 0x4FC5, 0x6D41 },
        { 0x4FD3, 0x6D42 },
        { 0x4FB2, 0x6D43 },
        { 0x4FC9, 0x6D44 },
        { 0x4FCB, 0x6D45 },
        { 0x4FC1, 0x6D46 },
        { 0x4FD4, 0x6D47 },
        { 0x4FDC, 0x6D48 },
        { 0x4FD9, 0x6D49 },
        { 0x4FBB, 0x6D4A },
        { 0x4FB3, 0x6D4B },
        { 0x4FDB, 0x6D4C },
        { 0x4FC7, 0x6D4D },
        { 0x4FD6, 0x6D4E },
        { 0x4FBA, 0x6D4F },
        { 0x4FC0, 0x6D50 },
        { 0x4FB9, 0x6D51 },
        { 0x4FEC, 0x6D52 },
        { 0x5244, 0x6D53 },
        { 0x5249, 0x6D54 },
        { 0x52C0, 0x6D55 },
        { 0x52C2, 0x6D56 },
        { 0x533D, 0x6D57 },
        { 0x537C, 0x6D58 },
        { 0x5397, 0x6D59 },
        { 0x5396, 0x6D5A },
        { 0x5399, 0x6D5B },
        { 0x5398, 0x6D5C },
        { 0x54BA, 0x6D5D },
        { 0x54A1, 0x6D5E },
        { 0x54AD, 0x6D5F },
        { 0x54A5, 0x6D60 },
        { 0x54CF, 0x6D61 },
        { 0x54C3, 0x6D62 },
        { 0x830D, 0x6D63 },
        { 0x54B7, 0x6D64 },
        { 0x54AE, 0x6D65 },
        { 0x54D6, 0x6D66 },
        { 0x54B6, 0x6D67 },
        { 0x54C5, 0x6D68 },
        { 0x54C6, 0x6D69 },
        { 0x54A0, 0x6D6A },
        { 0x5470, 0x6D6B },
        { 0x54BC, 0x6D6C },
        { 0x54A2, 0x6D6D },
        { 0x54BE, 0x6D6E },
        { 0x5472, 0x6D6F },
        { 0x54DE, 0x6D70 },
        { 0x54B0, 0x6D71 },
        { 0x57B5, 0x6D72 },
        { 0x579E, 0x6D73 },
        { 0x579F, 0x6D74 },
        { 0x57A4, 0x6D75 },
        { 0x578C, 0x6D76 },
        { 0x5797, 0x6D77 },
        { 0x579D, 0x6D78 },
        { 0x579B, 0x6D79 },
        { 0x5794, 0x6D7A },
        { 0x5798, 0x6D7B },
        { 0x578F, 0x6D7C },
        { 0x5799, 0x6D7D },
        { 0x57A5, 0x6D7E },
        { 0x579A, 0x6D7F },
        { 0x5795, 0x6D81 },
        { 0x58F4, 0x6D82 },
        { 0x590D, 0x6D83 },
        { 0x5953, 0x6D84 },
        { 0x59E1, 0x6D85 },
        { 0x59DE, 0x6D86 },
        { 0x59EE, 0x6D87 },
        { 0x5A00, 0x6D88 },
        { 0x59F1, 0x6D89 },
        { 0x59DD, 0x6D8A },
        { 0x59FA, 0x6D8B },
        { 0x59FD, 0x6D8C },
        { 0x59FC, 0x6D8D },
        { 0x59F6, 0x6D8E },
        { 0x59E4, 0x6D8F },
        { 0x59F2, 0x6D90 },
        { 0x59F7, 0x6D91 },
        { 0x59DB, 0x6D92 },
        { 0x59E9, 0x6D93 },
        { 0x59F3, 0x6D94 },
        { 0x59F5, 0x6D95 },
        { 0x59E0, 0x6D96 },
        { 0x59FE, 0x6D97 },
        { 0x59F4, 0x6D98 },
        { 0x59ED, 0x6D99 },
        { 0x5BA8, 0x6D9A },
        { 0x5C4C, 0x6D9B },
        { 0x5CD0, 0x6D9C },
        { 0x5CD8, 0x6D9D },
        { 0x5CCC, 0x6D9E },
        { 0x5CD7, 0x6D9F },
        { 0x5CCB, 0x6DA0 },
        { 0x5CDB, 0x6DA1 },
        { 0x5CDE, 0x6DA2 },
        { 0x5CDA, 0x6DA3 },
        { 0x5CC9, 0x6DA4 },
        { 0x5CC7, 0x6DA5 },
        { 0x5CCA, 0x6DA6 },
        { 0x5CD6, 0x6DA7 },
        { 0x5CD3, 0x6DA8 },
        { 0x5CD4, 0x6DA9 },
        { 0x5CCF, 0x6DAA },
        { 0x5CC8, 0x6DAB },
        { 0x5CC6, 0x6DAC },
        { 0x5CCE, 0x6DAD },
        { 0x5CDF, 0x6DAE },
        { 0x5CF8, 0x6DAF },
        { 0x5DF9, 0x6DB0 },
        { 0x5E21, 0x6DB1 },
        { 0x5E22, 0x6DB2 },
        { 0x5E23, 0x6DB3 },
        { 0x5E20, 0x6DB4 },
        { 0x5E24, 0x6DB5 },
        { 0x5EB0, 0x6DB6 },
        { 0x5EA4, 0x6DB7 },
        { 0x5EA2, 0x6DB8 },
        { 0x5E9B, 0x6DB9 },
        { 0x5EA3, 0x6DBA },
        { 0x5EA5, 0x6DBB },
        { 0x5F07, 0x6DBC },
        { 0x5F2E, 0x6DBD },
        { 0x5F56, 0x6DBE },
        { 0x5F86, 0x6DBF },
        { 0x6037, 0x6DC0 },
        { 0x6039, 0x6DC1 },
        { 0x6054, 0x6DC2 },
        { 0x6072, 0x6DC3 },
        { 0x605E, 0x6DC4 },
        { 0x6045, 0x6DC5 },
        { 0x6053, 0x6DC6 },
        { 0x6047, 0x6DC7 },
        { 0x6049, 0x6DC8 },
        { 0x605B, 0x6DC9 },
        { 0x604C, 0x6DCA },
        { 0x6040, 0x6DCB },
        { 0x6042, 0x6DCC },
        { 0x605F, 0x6DCD },
        { 0x6024, 0x6DCE },
        { 0x6044, 0x6DCF },
        { 0x6058, 0x6DD0 },
        { 0x6066, 0x6DD1 },
        { 0x606E, 0x6DD2 },
        { 0x6242, 0x6DD3 },
        { 0x6243, 0x6DD4 },
        { 0x62CF, 0x6DD5 },
        { 0x630D, 0x6DD6 },
        { 0x630B, 0x6DD7 },
        { 0x62F5, 0x6DD8 },
        { 0x630E, 0x6DD9 },
        { 0x6303, 0x6DDA },
        { 0x62EB, 0x6DDB },
        { 0x62F9, 0x6DDC },
        { 0x630F, 0x6DDD },
        { 0x630C, 0x6DDE },
        { 0x62F8, 0x6DDF },
        { 0x62F6, 0x6DE0 },
        { 0x6300, 0x6DE1 },
        { 0x6313, 0x6DE2 },
        { 0x6314, 0x6DE3 },
        { 0x62FA, 0x6DE4 },
        { 0x6315, 0x6DE5 },
        { 0x62FB, 0x6DE6 },
        { 0x62F0, 0x6DE7 },
        { 0x6541, 0x6DE8 },
        { 0x6543, 0x6DE9 },
        { 0x65AA, 0x6DEA },
        { 0x65BF, 0x6DEB },
        { 0x6636, 0x6DEC },
        { 0x6621, 0x6DED },
        { 0x6632, 0x6DEE },
        { 0x6635, 0x6DEF },
        { 0x661C, 0x6DF0 },
        { 0x6626, 0x6DF1 },
        { 0x6622, 0x6DF2 },
        { 0x6633, 0x6DF3 },
        { 0x662B, 0x6DF4 },
        { 0x663A, 0x6DF5 },
        { 0x661D, 0x6DF6 },
        { 0x6634, 0x6DF7 },
        { 0x6639, 0x6DF8 },
        { 0x662E, 0x6DF9 },
        { 0x670F, 0x6DFA },
        { 0x6710, 0x6DFB },
        { 0x67C1, 0x6DFC },
        { 0x67F2, 0x6DFD },
        { 0x67C8, 0x6E41 },
        { 0x67BA, 0x6E42 },
        { 0x67DC, 0x6E43 },
        { 0x67BB, 0x6E44 },
        { 0x67F8, 0x6E45 },
        { 0x67D8, 0x6E46 },
        { 0x67C0, 0x6E47 },
        { 0x67B7, 0x6E48 },
        { 0x67C5, 0x6E49 },
        { 0x67EB, 0x6E4A },
        { 0x67E4, 0x6E4B },
        { 0x67DF, 0x6E4C },
        { 0x67B5, 0x6E4D },
        { 0x67CD, 0x6E4E },
        { 0x67B3, 0x6E4F },
        { 0x67F7, 0x6E50 },
        { 0x67F6, 0x6E51 },
        { 0x67EE, 0x6E52 },
        { 0x67E3, 0x6E53 },
        { 0x67C2, 0x6E54 },
        { 0x67B9, 0x6E55 },
        { 0x67CE, 0x6E56 },
        { 0x67E7, 0x6E57 },
        { 0x67F0, 0x6E58 },
        { 0x67B2, 0x6E59 },
        { 0x67FC, 0x6E5A },
        { 0x67C6, 0x6E5B },
        { 0x67ED, 0x6E5C },
        { 0x67CC, 0x6E5D },
        { 0x67AE, 0x6E5E },
        { 0x67E6, 0x6E5F },
        { 0x67DB, 0x6E60 },
        { 0x67FA, 0x6E61 },
        { 0x67C9, 0x6E62 },
        { 0x67CA, 0x6E63 },
        { 0x67C3, 0x6E64 },
        { 0x67EA, 0x6E65 },
        { 0x67CB, 0x6E66 },
        { 0x6B28, 0x6E67 },
        { 0x6B82, 0x6E68 },
        { 0x6B84, 0x6E69 },
        { 0x6BB6, 0x6E6A },
        { 0x6BD6, 0x6E6B },
        { 0x6BD8, 0x6E6C },
        { 0x6BE0, 0x6E6D },
        { 0x6C20, 0x6E6E },
        { 0x6C21, 0x6E6F },
        { 0x6D28, 0x6E70 },
        { 0x6D34, 0x6E71 },
        { 0x6D2D, 0x6E72 },
        { 0x6D1F, 0x6E73 },
        { 0x6D3C, 0x6E74 },
        { 0x6D3F, 0x6E75 },
        { 0x6D12, 0x6E76 },
        { 0x6D0A, 0x6E77 },
        { 0x6CDA, 0x6E78 },
        { 0x6D33, 0x6E79 },
        { 0x6D04, 0x6E7A },
        { 0x6D19, 0x6E7B },
        { 0x6D3A, 0x6E7C },
        { 0x6D1A, 0x6E7D },
        { 0x6D11, 0x6E7E },
        { 0x6D00, 0x6E7F },
        { 0x6D1D, 0x6E81 },
        { 0x6D42, 0x6E82 },
        { 0x6D01, 0x6E83 },
        { 0x6D18, 0x6E84 },
        { 0x6D37, 0x6E85 },
        { 0x6D03, 0x6E86 },
        { 0x6D0F, 0x6E87 },
        { 0x6D40, 0x6E88 },
        { 0x6D07, 0x6E89 },
        { 0x6D20, 0x6E8A },
        { 0x6D2C, 0x6E8B },
        { 0x6D08, 0x6E8C },
        { 0x6D22, 0x6E8D },
        { 0x6D09, 0x6E8E },
        { 0x6D10, 0x6E8F },
        { 0x70B7, 0x6E90 },
        { 0x709F, 0x6E91 },
        { 0x70BE, 0x6E92 },
        { 0x70B1, 0x6E93 },
        { 0x70B0, 0x6E94 },
        { 0x70A1, 0x6E95 },
        { 0x70B4, 0x6E96 },
        { 0x70B5, 0x6E97 },
        { 0x70A9, 0x6E98 },
        { 0x7241, 0x6E99 },
        { 0x7249, 0x6E9A },
        { 0x724A, 0x6E9B },
        { 0x726C, 0x6E9C },
        { 0x7270, 0x6E9D },
        { 0x7273, 0x6E9E },
        { 0x726E, 0x6E9F },
        { 0x72CA, 0x6EA0 },
        { 0x72E4, 0x6EA1 },
        { 0x72E8, 0x6EA2 },
        { 0x72EB, 0x6EA3 },
        { 0x72DF, 0x6EA4 },
        { 0x72EA, 0x6EA5 },
        { 0x72E6, 0x6EA6 },
        { 0x72E3, 0x6EA7 },
        { 0x7385, 0x6EA8 },
        { 0x73CC, 0x6EA9 },
        { 0x73C2, 0x6EAA },
        { 0x73C8, 0x6EAB },
        { 0x73C5, 0x6EAC },
        { 0x73B9, 0x6EAD },
        { 0x73B6, 0x6EAE },
        { 0x73B5, 0x6EAF },
        { 0x73B4, 0x6EB0 },
        { 0x73EB, 0x6EB1 },
        { 0x73BF, 0x6EB2 },
        { 0x73C7, 0x6EB3 },
        { 0x73BE, 0x6EB4 },
        { 0x73C3, 0x6EB5 },
        { 0x73C6, 0x6EB6 },
        { 0x73B8, 0x6EB7 },
        { 0x73CB, 0x6EB8 },
        { 0x74EC, 0x6EB9 },
        { 0x74EE, 0x6EBA },
        { 0x752E, 0x6EBB },
        { 0x7547, 0x6EBC },
        { 0x7548, 0x6EBD },
        { 0x75A7, 0x6EBE },
        { 0x75AA, 0x6EBF },
        { 0x7679, 0x6EC0 },
        { 0x76C4, 0x6EC1 },
        { 0x7708, 0x6EC2 },
        { 0x7703, 0x6EC3 },
        { 0x7704, 0x6EC4 },
        { 0x7705, 0x6EC5 },
        { 0x770A, 0x6EC6 },
        { 0x76F7, 0x6EC7 },
        { 0x76FB, 0x6EC8 },
        { 0x76FA, 0x6EC9 },
        { 0x77E7, 0x6ECA },
        { 0x77E8, 0x6ECB },
        { 0x7806, 0x6ECC },
        { 0x7811, 0x6ECD },
        { 0x7812, 0x6ECE },
        { 0x7805, 0x6ECF },
        { 0x7810, 0x6ED0 },
        { 0x780F, 0x6ED1 },
        { 0x780E, 0x6ED2 },
        { 0x7809, 0x6ED3 },
        { 0x7803, 0x6ED4 },
        { 0x7813, 0x6ED5 },
        { 0x794A, 0x6ED6 },
        { 0x794C, 0x6ED7 },
        { 0x794B, 0x6ED8 },
        { 0x7945, 0x6ED9 },
        { 0x7944, 0x6EDA },
        { 0x79D5, 0x6EDB },
        { 0x79CD, 0x6EDC },
        { 0x79CF, 0x6EDD },
        { 0x79D6, 0x6EDE },
        { 0x79CE, 0x6EDF },
        { 0x7A80, 0x6EE0 },
        { 0x7A7E, 0x6EE1 },
        { 0x7AD1, 0x6EE2 },
        { 0x7B00, 0x6EE3 },
        { 0x7B01, 0x6EE4 },
        { 0x7C7A, 0x6EE5 },
        { 0x7C78, 0x6EE6 },
        { 0x7C79, 0x6EE7 },
        { 0x7C7F, 0x6EE8 },
        { 0x7C80, 0x6EE9 },
        { 0x7C81, 0x6EEA },
        { 0x7D03, 0x6EEB },
        { 0x7D08, 0x6EEC },
        { 0x7D01, 0x6EED },
        { 0x7F58, 0x6EEE },
        { 0x7F91, 0x6EEF },
        { 0x7F8D, 0x6EF0 },
        { 0x7FBE, 0x6EF1 },
        { 0x8007, 0x6EF2 },
        { 0x800E, 0x6EF3 },
        { 0x800F, 0x6EF4 },
        { 0x8014, 0x6EF5 },
        { 0x8037, 0x6EF6 },
        { 0x80D8, 0x6EF7 },
        { 0x80C7, 0x6EF8 },
        { 0x80E0, 0x6EF9 },
        { 0x80D1, 0x6EFA },
        { 0x80C8, 0x6EFB },
        { 0x80C2, 0x6EFC },
        { 0x80D0, 0x6EFD },
        { 0x80C5, 0x6F41 },
        { 0x80E3, 0x6F42 },
        { 0x80D9, 0x6F43 },
        { 0x80DC, 0x6F44 },
        { 0x80CA, 0x6F45 },
        { 0x80D5, 0x6F46 },
        { 0x80C9, 0x6F47 },
        { 0x80CF, 0x6F48 },
        { 0x80D7, 0x6F49 },
        { 0x80E6, 0x6F4A },
        { 0x80CD, 0x6F4B },
        { 0x81FF, 0x6F4C },
        { 0x8221, 0x6F4D },
        { 0x8294, 0x6F4E },
        { 0x82D9, 0x6F4F },
        { 0x82FE, 0x6F50 },
        { 0x82F9, 0x6F51 },
        { 0x8307, 0x6F52 },
        { 0x82E8, 0x6F53 },
        { 0x8300, 0x6F54 },
        { 0x82D5, 0x6F55 },
        { 0x833A, 0x6F56 },
        { 0x82EB, 0x6F57 },
        { 0x82D6, 0x6F58 },
        { 0x82F4, 0x6F59 },
        { 0x82EC, 0x6F5A },
        { 0x82E1, 0x6F5B },
        { 0x82F2, 0x6F5C },
        { 0x82F5, 0x6F5D },
        { 0x830C, 0x6F5E },
        { 0x82FB, 0x6F5F },
        { 0x82F6, 0x6F60 },
        { 0x82F0, 0x6F61 },
        { 0x82EA, 0x6F62 },
        { 0x82E4, 0x6F63 },
        { 0x82E0, 0x6F64 },
        { 0x82FA, 0x6F65 },
        { 0x82F3, 0x6F66 },
        { 0x82ED, 0x6F67 },
        { 0x8677, 0x6F68 },
        { 0x8674, 0x6F69 },
        { 0x867C, 0x6F6A },
        { 0x8673, 0x6F6B },
        { 0x8841, 0x6F6C },
        { 0x884E, 0x6F6D },
        { 0x8867, 0x6F6E },
        { 0x886A, 0x6F6F },
        { 0x8869, 0x6F70 },
        { 0x89D3, 0x6F71 },
        { 0x8A04, 0x6F72 },
        { 0x8A07, 0x6F73 },
        { 0x8D72, 0x6F74 },
        { 0x8FE3, 0x6F75 },
        { 0x8FE1, 0x6F76 },
        { 0x8FEE, 0x6F77 },
        { 0x8FE0, 0x6F78 },
        { 0x90F1, 0x6F79 },
        { 0x90BD, 0x6F7A },
        { 0x90BF, 0x6F7B },
        { 0x90D5, 0x6F7C },
        { 0x90C5, 0x6F7D },
        { 0x90BE, 0x6F7E },
        { 0x90C7, 0x6F7F },
        { 0x90CB, 0x6F81 },
        { 0x90C8, 0x6F82 },
        { 0x91D4, 0x6F83 },
        { 0x91D3, 0x6F84 },
        { 0x9654, 0x6F85 },
        { 0x964F, 0x6F86 },
        { 0x9651, 0x6F87 },
        { 0x9653, 0x6F88 },
        { 0x964A, 0x6F89 },
        { 0x964E, 0x6F8A },
        { 0x501E, 0x6F8B },
        { 0x5005, 0x6F8C },
        { 0x5007, 0x6F8D },
        { 0x5013, 0x6F8E },
        { 0x5022, 0x6F8F },
        { 0x5030, 0x6F90 },
        { 0x501B, 0x6F91 },
        { 0x4FF5, 0x6F92 },
        { 0x4FF4, 0x6F93 },
        { 0x5033, 0x6F94 },
        { 0x5037, 0x6F95 },
        { 0x502C, 0x6F96 },
        { 0x4FF6, 0x6F97 },
        { 0x4FF7, 0x6F98 },
        { 0x5017, 0x6F99 },
        { 0x501C, 0x6F9A },
        { 0x5020, 0x6F9B },
        { 0x5027, 0x6F9C },
        { 0x5035, 0x6F9D },
        { 0x502F, 0x6F9E },
        { 0x5031, 0x6F9F },
        { 0x500E, 0x6FA0 },
        { 0x515A, 0x6FA1 },
        { 0x5194, 0x6FA2 },
        { 0x5193, 0x6FA3 },
        { 0x51CA, 0x6FA4 },
        { 0x51C4, 0x6FA5 },
        { 0x51C5, 0x6FA6 },
        { 0x51C8, 0x6FA7 },
        { 0x51CE, 0x6FA8 },
        { 0x5261, 0x6FA9 },
        { 0x525A, 0x6FAA },
        { 0x5252, 0x6FAB },
        { 0x525E, 0x6FAC },
        { 0x525F, 0x6FAD },
        { 0x5255, 0x6FAE },
        { 0x5262, 0x6FAF },
        { 0x52CD, 0x6FB0 },
        { 0x530E, 0x6FB1 },
        { 0x539E, 0x6FB2 },
        { 0x5526, 0x6FB3 },
        { 0x54E2, 0x6FB4 },
        { 0x5517, 0x6FB5 },
        { 0x5512, 0x6FB6 },
        { 0x54E7, 0x6FB7 },
        { 0x54F3, 0x6FB8 },
        { 0x54E4, 0x6FB9 },
        { 0x551A, 0x6FBA },
        { 0x54FF, 0x6FBB },
        { 0x5504, 0x6FBC },
        { 0x5508, 0x6FBD },
        { 0x54EB, 0x6FBE },
        { 0x5511, 0x6FBF },
        { 0x5505, 0x6FC0 },
        { 0x54F1, 0x6FC1 },
        { 0x550A, 0x6FC2 },
        { 0x54FB, 0x6FC3 },
        { 0x54F7, 0x6FC4 },
        { 0x54F8, 0x6FC5 },
        { 0x54E0, 0x6FC6 },
        { 0x550E, 0x6FC7 },
        { 0x5503, 0x6FC8 },
        { 0x550B, 0x6FC9 },
        { 0x5701, 0x6FCA },
        { 0x5702, 0x6FCB },
        { 0x57CC, 0x6FCC },
        { 0x5832, 0x6FCD },
        { 0x57D5, 0x6FCE },
        { 0x57D2, 0x6FCF },
        { 0x57BA, 0x6FD0 },
        { 0x57C6, 0x6FD1 },
        { 0x57BD, 0x6FD2 },
        { 0x57BC, 0x6FD3 },
        { 0x57B8, 0x6FD4 },
        { 0x57B6, 0x6FD5 },
        { 0x57BF, 0x6FD6 },
        { 0x57C7, 0x6FD7 },
        { 0x57D0, 0x6FD8 },
        { 0x57B9, 0x6FD9 },
        { 0x57C1, 0x6FDA },
        { 0x590E, 0x6FDB },
        { 0x594A, 0x6FDC },
        { 0x5A19, 0x6FDD },
        { 0x5A16, 0x6FDE },
        { 0x5A2D, 0x6FDF },
        { 0x5A2E, 0x6FE0 },
        { 0x5A15, 0x6FE1 },
        { 0x5A0F, 0x6FE2 },
        { 0x5A17, 0x6FE3 },
        { 0x5A0A, 0x6FE4 },
        { 0x5A1E, 0x6FE5 },
        { 0x5A33, 0x6FE6 },
        { 0x5B6C, 0x6FE7 },
        { 0x5BA7, 0x6FE8 },
        { 0x5BAD, 0x6FE9 },
        { 0x5BAC, 0x6FEA },
        { 0x5C03, 0x6FEB },
        { 0x5C56, 0x6FEC },
        { 0x5C54, 0x6FED },
        { 0x5CEC, 0x6FEE },
        { 0x5CFF, 0x6FEF },
        { 0x5CEE, 0x6FF0 },
        { 0x5CF1, 0x6FF1 },
        { 0x5CF7, 0x6FF2 },
        { 0x5D00, 0x6FF3 },
        { 0x5CF9, 0x6FF4 },
        { 0x5E29, 0x6FF5 },
        { 0x5E28, 0x6FF6 },
        { 0x5EA8, 0x6FF7 },
        { 0x5EAE, 0x6FF8 },
        { 0x5EAA, 0x6FF9 },
        { 0x5EAC, 0x6FFA },
        { 0x5F33, 0x6FFB },
        { 0x5F30, 0x6FFC },
        { 0x5F67, 0x6FFD },
        { 0x605D, 0x7041 },
        { 0x605A, 0x7042 },
        { 0x6067, 0x7043 },
        { 0x6041, 0x7044 },
        { 0x60A2, 0x7045 },
        { 0x6088, 0x7046 },
        { 0x6080, 0x7047 },
        { 0x6092, 0x7048 },
        { 0x6081, 0x7049 },
        { 0x609D, 0x704A },
        { 0x6083, 0x704B },
        { 0x6095, 0x704C },
        { 0x609B, 0x704D },
        { 0x6097, 0x704E },
        { 0x6087, 0x704F },
        { 0x609C, 0x7050 },
        { 0x608E, 0x7051 },
        { 0x6219, 0x7052 },
        { 0x6246, 0x7053 },
        { 0x62F2, 0x7054 },
        { 0x6310, 0x7055 },
        { 0x6356, 0x7056 },
        { 0x632C, 0x7057 },
        { 0x6344, 0x7058 },
        { 0x6345, 0x7059 },
        { 0x6336, 0x705A },
        { 0x6343, 0x705B },
        { 0x63E4, 0x705C },
        { 0x6339, 0x705D },
        { 0x634B, 0x705E },
        { 0x634A, 0x705F },
        { 0x633C, 0x7060 },
        { 0x6329, 0x7061 },
        { 0x6341, 0x7062 },
        { 0x6334, 0x7063 },
        { 0x6358, 0x7064 },
        { 0x6354, 0x7065 },
        { 0x6359, 0x7066 },
        { 0x632D, 0x7067 },
        { 0x6347, 0x7068 },
        { 0x6333, 0x7069 },
        { 0x635A, 0x706A },
        { 0x6351, 0x706B },
        { 0x6338, 0x706C },
        { 0x6357, 0x706D },
        { 0x6340, 0x706E },
        { 0x6348, 0x706F },
        { 0x654A, 0x7070 },
        { 0x6546, 0x7071 },
        { 0x65C6, 0x7072 },
        { 0x65C3, 0x7073 },
        { 0x65C4, 0x7074 },
        { 0x65C2, 0x7075 },
        { 0x664A, 0x7076 },
        { 0x665F, 0x7077 },
        { 0x6647, 0x7078 },
        { 0x6651, 0x7079 },
        { 0x6712, 0x707A },
        { 0x6713, 0x707B },
        { 0x681F, 0x707C },
        { 0x681A, 0x707D },
        { 0x6849, 0x707E },
        { 0x6832, 0x707F },
        { 0x6833, 0x7081 },
        { 0x683B, 0x7082 },
        { 0x684B, 0x7083 },
        { 0x684F, 0x7084 },
        { 0x6816, 0x7085 },
        { 0x6831, 0x7086 },
        { 0x681C, 0x7087 },
        { 0x6835, 0x7088 },
        { 0x682B, 0x7089 },
        { 0x682D, 0x708A },
        { 0x682F, 0x708B },
        { 0x684E, 0x708C },
        { 0x6844, 0x708D },
        { 0x6834, 0x708E },
        { 0x681D, 0x708F },
        { 0x6812, 0x7090 },
        { 0x6814, 0x7091 },
        { 0x6826, 0x7092 },
        { 0x6828, 0x7093 },
        { 0x682E, 0x7094 },
        { 0x684D, 0x7095 },
        { 0x683A, 0x7096 },
        { 0x6825, 0x7097 },
        { 0x6820, 0x7098 },
        { 0x6B2C, 0x7099 },
        { 0x6B2F, 0x709A },
        { 0x6B2D, 0x709B },
        { 0x6B31, 0x709C },
        { 0x6B34, 0x709D },
        { 0x6B6D, 0x709E },
        { 0x8082, 0x709F },
        { 0x6B88, 0x70A0 },
        { 0x6BE6, 0x70A1 },
        { 0x6BE4, 0x70A2 },
        { 0x6BE8, 0x70A3 },
        { 0x6BE3, 0x70A4 },
        { 0x6BE2, 0x70A5 },
        { 0x6BE7, 0x70A6 },
        { 0x6C25, 0x70A7 },
        { 0x6D7A, 0x70A8 },
        { 0x6D63, 0x70A9 },
        { 0x6D64, 0x70AA },
        { 0x6D76, 0x70AB },
        { 0x6D0D, 0x70AC },
        { 0x6D61, 0x70AD },
        { 0x6D92, 0x70AE },
        { 0x6D58, 0x70AF },
        { 0x6D62, 0x70B0 },
        { 0x6D6D, 0x70B1 },
        { 0x6D6F, 0x70B2 },
        { 0x6D91, 0x70B3 },
        { 0x6D8D, 0x70B4 },
        { 0x6DEF, 0x70B5 },
        { 0x6D7F, 0x70B6 },
        { 0x6D86, 0x70B7 },
        { 0x6D5E, 0x70B8 },
        { 0x6D67, 0x70B9 },
        { 0x6D60, 0x70BA },
        { 0x6D97, 0x70BB },
        { 0x6D70, 0x70BC },
        { 0x6D7C, 0x70BD },
        { 0x6D5F, 0x70BE },
        { 0x6D82, 0x70BF },
        { 0x6D98, 0x70C0 },
        { 0x6D2F, 0x70C1 },
        { 0x6D68, 0x70C2 },
        { 0x6D8B, 0x70C3 },
        { 0x6D7E, 0x70C4 },
        { 0x6D80, 0x70C5 },
        { 0x6D84, 0x70C6 },
        { 0x6D16, 0x70C7 },
        { 0x6D83, 0x70C8 },
        { 0x6D7B, 0x70C9 },
        { 0x6D7D, 0x70CA },
        { 0x6D75, 0x70CB },
        { 0x6D90, 0x70CC },
        { 0x70DC, 0x70CD },
        { 0x70D3, 0x70CE },
        { 0x70D1, 0x70CF },
        { 0x70DD, 0x70D0 },
        { 0x70CB, 0x70D1 },
        { 0x7F39, 0x70D2 },
        { 0x70E2, 0x70D3 },
        { 0x70D7, 0x70D4 },
        { 0x70D2, 0x70D5 },
        { 0x70DE, 0x70D6 },
        { 0x70E0, 0x70D7 },
        { 0x70D4, 0x70D8 },
        { 0x70CD, 0x70D9 },
        { 0x70C5, 0x70DA },
        { 0x70C6, 0x70DB },
        { 0x70C7, 0x70DC },
        { 0x70DA, 0x70DD },
        { 0x70CE, 0x70DE },
        { 0x70E1, 0x70DF },
        { 0x7242, 0x70E0 },
        { 0x7278, 0x70E1 },
        { 0x7277, 0x70E2 },
        { 0x7276, 0x70E3 },
        { 0x7300, 0x70E4 },
        { 0x72FA, 0x70E5 },
        { 0x72F4, 0x70E6 },
        { 0x72FE, 0x70E7 },
        { 0x72F6, 0x70E8 },
        { 0x72F3, 0x70E9 },
        { 0x72FB, 0x70EA },
        { 0x7301, 0x70EB },
        { 0x73D3, 0x70EC },
        { 0x73D9, 0x70ED },
        { 0x73E5, 0x70EE },
        { 0x73D6, 0x70EF },
        { 0x73BC, 0x70F0 },
        { 0x73E7, 0x70F1 },
        { 0x73E3, 0x70F2 },
        { 0x73E9, 0x70F3 },
        { 0x73DC, 0x70F4 },
        { 0x73D2, 0x70F5 },
        { 0x73DB, 0x70F6 },
        { 0x73D4, 0x70F7 },
        { 0x73DD, 0x70F8 },
        { 0x73DA, 0x70F9 },
        { 0x73D7, 0x70FA },
        { 0x73D8, 0x70FB },
        { 0x73E8, 0x70FC },
        { 0x74DE, 0x70FD },
        { 0x74DF, 0x7141 },
        { 0x74F4, 0x7142 },
        { 0x74F5, 0x7143 },
        { 0x7521, 0x7144 },
        { 0x755B, 0x7145 },
        { 0x755F, 0x7146 },
        { 0x75B0, 0x7147 },
        { 0x75C1, 0x7148 },
        { 0x75BB, 0x7149 },
        { 0x75C4, 0x714A },
        { 0x75C0, 0x714B },
        { 0x75BF, 0x714C },
        { 0x75B6, 0x714D },
        { 0x75BA, 0x714E },
        { 0x768A, 0x714F },
        { 0x76C9, 0x7150 },
        { 0x771D, 0x7151 },
        { 0x771B, 0x7152 },
        { 0x7710, 0x7153 },
        { 0x7713, 0x7154 },
        { 0x7712, 0x7155 },
        { 0x7723, 0x7156 },
        { 0x7711, 0x7157 },
        { 0x7715, 0x7158 },
        { 0x7719, 0x7159 },
        { 0x771A, 0x715A },
        { 0x7722, 0x715B },
        { 0x7727, 0x715C },
        { 0x7823, 0x715D },
        { 0x782C, 0x715E },
        { 0x7822, 0x715F },
        { 0x7835, 0x7160 },
        { 0x782F, 0x7161 },
        { 0x7828, 0x7162 },
        { 0x782E, 0x7163 },
        { 0x782B, 0x7164 },
        { 0x7821, 0x7165 },
        { 0x7829, 0x7166 },
        { 0x7833, 0x7167 },
        { 0x782A, 0x7168 },
        { 0x7831, 0x7169 },
        { 0x7954, 0x716A },
        { 0x795B, 0x716B },
        { 0x794F, 0x716C },
        { 0x795C, 0x716D },
        { 0x7953, 0x716E },
        { 0x7952, 0x716F },
        { 0x7951, 0x7170 },
        { 0x79EB, 0x7171 },
        { 0x79EC, 0x7172 },
        { 0x79E0, 0x7173 },
        { 0x79EE, 0x7174 },
        { 0x79ED, 0x7175 },
        { 0x79EA, 0x7176 },
        { 0x79DC, 0x7177 },
        { 0x79DE, 0x7178 },
        { 0x79DD, 0x7179 },
        { 0x7A86, 0x717A },
        { 0x7A89, 0x717B },
        { 0x7A85, 0x717C },
        { 0x7A8B, 0x717D },
        { 0x7A8C, 0x717E },
        { 0x7A8A, 0x717F },
        { 0x7A87, 0x7181 },
        { 0x7AD8, 0x7182 },
        { 0x7B10, 0x7183 },
        { 0x7B04, 0x7184 },
        { 0x7B13, 0x7185 },
        { 0x7B05, 0x7186 },
        { 0x7B0F, 0x7187 },
        { 0x7B08, 0x7188 },
        { 0x7B0A, 0x7189 },
        { 0x7B0E, 0x718A },
        { 0x7B09, 0x718B },
        { 0x7B12, 0x718C },
        { 0x7C84, 0x718D },
        { 0x7C91, 0x718E },
        { 0x7C8A, 0x718F },
        { 0x7C8C, 0x7190 },
        { 0x7C88, 0x7191 },
        { 0x7C8D, 0x7192 },
        { 0x7C85, 0x7193 },
        { 0x7D1E, 0x7194 },
        { 0x7D1D, 0x7195 },
        { 0x7D11, 0x7196 },
        { 0x7D0E, 0x7197 },
        { 0x7D18, 0x7198 },
        { 0x7D16, 0x7199 },
        { 0x7D13, 0x719A },
        { 0x7D1F, 0x719B },
        { 0x7D12, 0x719C },
        { 0x7D0F, 0x719D },
        { 0x7D0C, 0x719E },
        { 0x7F5C, 0x719F },
        { 0x7F61, 0x71A0 },
        { 0x7F5E, 0x71A1 },
        { 0x7F60, 0x71A2 },
        { 0x7F5D, 0x71A3 },
        { 0x7F5B, 0x71A4 },
        { 0x7F96, 0x71A5 },
        { 0x7F92, 0x71A6 },
        { 0x7FC3, 0x71A7 },
        { 0x7FC2, 0x71A8 },
        { 0x7FC0, 0x71A9 },
        { 0x8016, 0x71AA },
        { 0x803E, 0x71AB },
        { 0x8039, 0x71AC },
        { 0x80FA, 0x71AD },
        { 0x80F2, 0x71AE },
        { 0x80F9, 0x71AF },
        { 0x80F5, 0x71B0 },
        { 0x8101, 0x71B1 },
        { 0x80FB, 0x71B2 },
        { 0x8100, 0x71B3 },
        { 0x8201, 0x71B4 },
        { 0x822F, 0x71B5 },
        { 0x8225, 0x71B6 },
        { 0x8333, 0x71B7 },
        { 0x832D, 0x71B8 },
        { 0x8344, 0x71B9 },
        { 0x8319, 0x71BA },
        { 0x8351, 0x71BB },
        { 0x8325, 0x71BC },
        { 0x8356, 0x71BD },
        { 0x833F, 0x71BE },
        { 0x8341, 0x71BF },
        { 0x8326, 0x71C0 },
        { 0x831C, 0x71C1 },
        { 0x8322, 0x71C2 },
        { 0x8342, 0x71C3 },
        { 0x834E, 0x71C4 },
        { 0x831B, 0x71C5 },
        { 0x832A, 0x71C6 },
        { 0x8308, 0x71C7 },
        { 0x833C, 0x71C8 },
        { 0x834D, 0x71C9 },
        { 0x8316, 0x71CA },
        { 0x8324, 0x71CB },
        { 0x8320, 0x71CC },
        { 0x8337, 0x71CD },
        { 0x832F, 0x71CE },
        { 0x8329, 0x71CF },
        { 0x8347, 0x71D0 },
        { 0x8345, 0x71D1 },
        { 0x834C, 0x71D2 },
        { 0x8353, 0x71D3 },
        { 0x831E, 0x71D4 },
        { 0x832C, 0x71D5 },
        { 0x834B, 0x71D6 },
        { 0x8327, 0x71D7 },
        { 0x8348, 0x71D8 },
        { 0x8653, 0x71D9 },
        { 0x8652, 0x71DA },
        { 0x86A2, 0x71DB },
        { 0x86A8, 0x71DC },
        { 0x8696, 0x71DD },
        { 0x868D, 0x71DE },
        { 0x8691, 0x71DF },
        { 0x869E, 0x71E0 },
        { 0x8687, 0x71E1 },
        { 0x8697, 0x71E2 },
        { 0x8686, 0x71E3 },
        { 0x868B, 0x71E4 },
        { 0x869A, 0x71E5 },
        { 0x8685, 0x71E6 },
        { 0x86A5, 0x71E7 },
        { 0x8699, 0x71E8 },
        { 0x86A1, 0x71E9 },
        { 0x86A7, 0x71EA },
        { 0x8695, 0x71EB },
        { 0x8698, 0x71EC },
        { 0x868E, 0x71ED },
        { 0x869D, 0x71EE },
        { 0x8690, 0x71EF },
        { 0x8694, 0x71F0 },
        { 0x8843, 0x71F1 },
        { 0x8844, 0x71F2 },
        { 0x886D, 0x71F3 },
        { 0x8875, 0x71F4 },
        { 0x8876, 0x71F5 },
        { 0x8872, 0x71F6 },
        { 0x8880, 0x71F7 },
        { 0x8871, 0x71F8 },
        { 0x887F, 0x71F9 },
        { 0x886F, 0x71FA },
        { 0x8883, 0x71FB },
        { 0x887E, 0x71FC },
        { 0x8874, 0x71FD },
        { 0x887C, 0x7241 },
        { 0x8A12, 0x7242 },
        { 0x8C47, 0x7243 },
        { 0x8C57, 0x7244 },
        { 0x8C7B, 0x7245 },
        { 0x8CA4, 0x7246 },
        { 0x8CA3, 0x7247 },
        { 0x8D76, 0x7248 },
        { 0x8D78, 0x7249 },
        { 0x8DB5, 0x724A },
        { 0x8DB7, 0x724B },
        { 0x8DB6, 0x724C },
        { 0x8ED1, 0x724D },
        { 0x8ED3, 0x724E },
        { 0x8FFE, 0x724F },
        { 0x8FF5, 0x7250 },
        { 0x9002, 0x7251 },
        { 0x8FFF, 0x7252 },
        { 0x8FFB, 0x7253 },
        { 0x9004, 0x7254 },
        { 0x8FFC, 0x7255 },
        { 0x8FF6, 0x7256 },
        { 0x90D6, 0x7257 },
        { 0x90E0, 0x7258 },
        { 0x90D9, 0x7259 },
        { 0x90DA, 0x725A },
        { 0x90E3, 0x725B },
        { 0x90DF, 0x725C },
        { 0x90E5, 0x725D },
        { 0x90D8, 0x725E },
        { 0x90DB, 0x725F },
        { 0x90D7, 0x7260 },
        { 0x90DC, 0x7261 },
        { 0x90E4, 0x7262 },
        { 0x9150, 0x7263 },
        { 0x914E, 0x7264 },
        { 0x914F, 0x7265 },
        { 0x91D5, 0x7266 },
        { 0x91E2, 0x7267 },
        { 0x91DA, 0x7268 },
        { 0x965C, 0x7269 },
        { 0x965F, 0x726A },
        { 0x96BC, 0x726B },
        { 0x98E3, 0x726C },
        { 0x9ADF, 0x726D },
        { 0x9B2F, 0x726E },
        { 0x4E7F, 0x726F },
        { 0x5070, 0x7270 },
        { 0x506A, 0x7271 },
        { 0x5061, 0x7272 },
        { 0x505E, 0x7273 },
        { 0x5060, 0x7274 },
        { 0x5053, 0x7275 },
        { 0x504B, 0x7276 },
        { 0x505D, 0x7277 },
        { 0x5072, 0x7278 },
        { 0x5048, 0x7279 },
        { 0x504D, 0x727A },
        { 0x5041, 0x727B },
        { 0x505B, 0x727C },
        { 0x504A, 0x727D },
        { 0x5062, 0x727E },
        { 0x5015, 0x727F },
        { 0x5045, 0x7281 },
        { 0x505F, 0x7282 },
        { 0x5069, 0x7283 },
        { 0x506B, 0x7284 },
        { 0x5063, 0x7285 },
        { 0x5064, 0x7286 },
        { 0x5046, 0x7287 },
        { 0x5040, 0x7288 },
        { 0x506E, 0x7289 },
        { 0x5073, 0x728A },
        { 0x5057, 0x728B },
        { 0x5051, 0x728C },
        { 0x51D0, 0x728D },
        { 0x526B, 0x728E },
        { 0x526D, 0x728F },
        { 0x526C, 0x7290 },
        { 0x526E, 0x7291 },
        { 0x52D6, 0x7292 },
        { 0x52D3, 0x7293 },
        { 0x532D, 0x7294 },
        { 0x539C, 0x7295 },
        { 0x5575, 0x7296 },
        { 0x5576, 0x7297 },
        { 0x553C, 0x7298 },
        { 0x554D, 0x7299 },
        { 0x5550, 0x729A },
        { 0x5534, 0x729B },
        { 0x552A, 0x729C },
        { 0x5551, 0x729D },
        { 0x5562, 0x729E },
        { 0x5536, 0x729F },
        { 0x5535, 0x72A0 },
        { 0x5530, 0x72A1 },
        { 0x5552, 0x72A2 },
        { 0x5545, 0x72A3 },
        { 0x550C, 0x72A4 },
        { 0x5532, 0x72A5 },
        { 0x5565, 0x72A6 },
        { 0x554E, 0x72A7 },
        { 0x5539, 0x72A8 },
        { 0x5548, 0x72A9 },
        { 0x552D, 0x72AA },
        { 0x553B, 0x72AB },
        { 0x5540, 0x72AC },
        { 0x554B, 0x72AD },
        { 0x570A, 0x72AE },
        { 0x5707, 0x72AF },
        { 0x57FB, 0x72B0 },
        { 0x5814, 0x72B1 },
        { 0x57E2, 0x72B2 },
        { 0x57F6, 0x72B3 },
        { 0x57DC, 0x72B4 },
        { 0x57F4, 0x72B5 },
        { 0x5800, 0x72B6 },
        { 0x57ED, 0x72B7 },
        { 0x57FD, 0x72B8 },
        { 0x5808, 0x72B9 },
        { 0x57F8, 0x72BA },
        { 0x580B, 0x72BB },
        { 0x57F3, 0x72BC },
        { 0x57CF, 0x72BD },
        { 0x5807, 0x72BE },
        { 0x57EE, 0x72BF },
        { 0x57E3, 0x72C0 },
        { 0x57F2, 0x72C1 },
        { 0x57E5, 0x72C2 },
        { 0x57EC, 0x72C3 },
        { 0x57E1, 0x72C4 },
        { 0x580E, 0x72C5 },
        { 0x57FC, 0x72C6 },
        { 0x5810, 0x72C7 },
        { 0x57E7, 0x72C8 },
        { 0x5801, 0x72C9 },
        { 0x580C, 0x72CA },
        { 0x57F1, 0x72CB },
        { 0x57E9, 0x72CC },
        { 0x57F0, 0x72CD },
        { 0x580D, 0x72CE },
        { 0x5804, 0x72CF },
        { 0x595C, 0x72D0 },
        { 0x5A60, 0x72D1 },
        { 0x5A58, 0x72D2 },
        { 0x5A55, 0x72D3 },
        { 0x5A67, 0x72D4 },
        { 0x5A5E, 0x72D5 },
        { 0x5A38, 0x72D6 },
        { 0x5A35, 0x72D7 },
        { 0x5A6D, 0x72D8 },
        { 0x5A50, 0x72D9 },
        { 0x5A5F, 0x72DA },
        { 0x5A65, 0x72DB },
        { 0x5A6C, 0x72DC },
        { 0x5A53, 0x72DD },
        { 0x5A64, 0x72DE },
        { 0x5A57, 0x72DF },
        { 0x5A43, 0x72E0 },
        { 0x5A5D, 0x72E1 },
        { 0x5A52, 0x72E2 },
        { 0x5A44, 0x72E3 },
        { 0x5A5B, 0x72E4 },
        { 0x5A48, 0x72E5 },
        { 0x5A8E, 0x72E6 },
        { 0x5A3E, 0x72E7 },
        { 0x5A4D, 0x72E8 },
        { 0x5A39, 0x72E9 },
        { 0x5A4C, 0x72EA },
        { 0x5A70, 0x72EB },
        { 0x5A69, 0x72EC },
        { 0x5A47, 0x72ED },
        { 0x5A51, 0x72EE },
        { 0x5A56, 0x72EF },
        { 0x5A42, 0x72F0 },
        { 0x5A5C, 0x72F1 },
        { 0x5B72, 0x72F2 },
        { 0x5B6E, 0x72F3 },
        { 0x5BC1, 0x72F4 },
        { 0x5BC0, 0x72F5 },
        { 0x5C59, 0x72F6 },
        { 0x5D1E, 0x72F7 },
        { 0x5D0B, 0x72F8 },
        { 0x5D1D, 0x72F9 },
        { 0x5D1A, 0x72FA },
        { 0x5D20, 0x72FB },
        { 0x5D0C, 0x72FC },
        { 0x5D28, 0x72FD },
        { 0x5D0D, 0x7341 },
        { 0x5D26, 0x7342 },
        { 0x5D25, 0x7343 },
        { 0x5D0F, 0x7344 },
        { 0x5D30, 0x7345 },
        { 0x5D12, 0x7346 },
        { 0x5D23, 0x7347 },
        { 0x5D1F, 0x7348 },
        { 0x5D2E, 0x7349 },
        { 0x5E3E, 0x734A },
        { 0x5E34, 0x734B },
        { 0x5EB1, 0x734C },
        { 0x5EB4, 0x734D },
        { 0x5EB9, 0x734E },
        { 0x5EB2, 0x734F },
        { 0x5EB3, 0x7350 },
        { 0x5F36, 0x7351 },
        { 0x5F38, 0x7352 },
        { 0x5F9B, 0x7353 },
        { 0x5F96, 0x7354 },
        { 0x5F9F, 0x7355 },
        { 0x608A, 0x7356 },
        { 0x6090, 0x7357 },
        { 0x6086, 0x7358 },
        { 0x60BE, 0x7359 },
        { 0x60B0, 0x735A },
        { 0x60BA, 0x735B },
        { 0x60D3, 0x735C },
        { 0x60D4, 0x735D },
        { 0x60CF, 0x735E },
        { 0x60E4, 0x735F },
        { 0x60D9, 0x7360 },
        { 0x60DD, 0x7361 },
        { 0x60C8, 0x7362 },
        { 0x60B1, 0x7363 },
        { 0x60DB, 0x7364 },
        { 0x60B7, 0x7365 },
        { 0x60CA, 0x7366 },
        { 0x60BF, 0x7367 },
        { 0x60C3, 0x7368 },
        { 0x60CD, 0x7369 },
        { 0x60C0, 0x736A },
        { 0x6332, 0x736B },
        { 0x6365, 0x736C },
        { 0x638A, 0x736D },
        { 0x6382, 0x736E },
        { 0x637D, 0x736F },
        { 0x63BD, 0x7370 },
        { 0x639E, 0x7371 },
        { 0x63AD, 0x7372 },
        { 0x639D, 0x7373 },
        { 0x6397, 0x7374 },
        { 0x63AB, 0x7375 },
        { 0x638E, 0x7376 },
        { 0x636F, 0x7377 },
        { 0x6387, 0x7378 },
        { 0x6390, 0x7379 },
        { 0x636E, 0x737A },
        { 0x63AF, 0x737B },
        { 0x6375, 0x737C },
        { 0x639C, 0x737D },
        { 0x636D, 0x737E },
        { 0x63AE, 0x737F },
        { 0x637C, 0x7381 },
        { 0x63A4, 0x7382 },
        { 0x633B, 0x7383 },
        { 0x639F, 0x7384 },
        { 0x6378, 0x7385 },
        { 0x6385, 0x7386 },
        { 0x6381, 0x7387 },
        { 0x6391, 0x7388 },
        { 0x638D, 0x7389 },
        { 0x6370, 0x738A },
        { 0x6553, 0x738B },
        { 0x65CD, 0x738C },
        { 0x6665, 0x738D },
        { 0x6661, 0x738E },
        { 0x665B, 0x738F },
        { 0x6659, 0x7390 },
        { 0x665C, 0x7391 },
        { 0x6662, 0x7392 },
        { 0x6718, 0x7393 },
        { 0x6879, 0x7394 },
        { 0x6887, 0x7395 },
        { 0x6890, 0x7396 },
        { 0x689C, 0x7397 },
        { 0x686D, 0x7398 },
        { 0x686E, 0x7399 },
        { 0x68AE, 0x739A },
        { 0x68AB, 0x739B },
        { 0x6956, 0x739C },
        { 0x686F, 0x739D },
        { 0x68A3, 0x739E },
        { 0x68AC, 0x739F },
        { 0x68A9, 0x73A0 },
        { 0x6875, 0x73A1 },
        { 0x6874, 0x73A2 },
        { 0x68B2, 0x73A3 },
        { 0x688F, 0x73A4 },
        { 0x6877, 0x73A5 },
        { 0x6892, 0x73A6 },
        { 0x687C, 0x73A7 },
        { 0x686B, 0x73A8 },
        { 0x6872, 0x73A9 },
        { 0x68AA, 0x73AA },
        { 0x6880, 0x73AB },
        { 0x6871, 0x73AC },
        { 0x687E, 0x73AD },
        { 0x689B, 0x73AE },
        { 0x6896, 0x73AF },
        { 0x688B, 0x73B0 },
        { 0x68A0, 0x73B1 },
        { 0x6889, 0x73B2 },
        { 0x68A4, 0x73B3 },
        { 0x6878, 0x73B4 },
        { 0x687B, 0x73B5 },
        { 0x6891, 0x73B6 },
        { 0x688C, 0x73B7 },
        { 0x691E, 0x73B8 },
        { 0x687D, 0x73B9 },
        { 0x6B36, 0x73BA },
        { 0x6B33, 0x73BB },
        { 0x6B37, 0x73BC },
        { 0x6B38, 0x73BD },
        { 0x6B91, 0x73BE },
        { 0x6B8F, 0x73BF },
        { 0x6B8D, 0x73C0 },
        { 0x6B8E, 0x73C1 },
        { 0x6B8C, 0x73C2 },
        { 0x6C2A, 0x73C3 },
        { 0x6DC0, 0x73C4 },
        { 0x6DAB, 0x73C5 },
        { 0x6DB4, 0x73C6 },
        { 0x6DB3, 0x73C7 },
        { 0x6E74, 0x73C8 },
        { 0x6DAC, 0x73C9 },
        { 0x6DE9, 0x73CA },
        { 0x6DE2, 0x73CB },
        { 0x6DB7, 0x73CC },
        { 0x6DF6, 0x73CD },
        { 0x6DD4, 0x73CE },
        { 0x6E00, 0x73CF },
        { 0x6DC8, 0x73D0 },
        { 0x6DE0, 0x73D1 },
        { 0x6DDF, 0x73D2 },
        { 0x6DD6, 0x73D3 },
        { 0x6DBE, 0x73D4 },
        { 0x6DE5, 0x73D5 },
        { 0x6DDC, 0x73D6 },
        { 0x6DDD, 0x73D7 },
        { 0x6DDB, 0x73D8 },
        { 0x6DF4, 0x73D9 },
        { 0x6DCA, 0x73DA },
        { 0x6DBD, 0x73DB },
        { 0x6DED, 0x73DC },
        { 0x6DF0, 0x73DD },
        { 0x6DBA, 0x73DE },
        { 0x6DD5, 0x73DF },
        { 0x6DC2, 0x73E0 },
        { 0x6DCF, 0x73E1 },
        { 0x6DC9, 0x73E2 },
        { 0x6DD0, 0x73E3 },
        { 0x6DF2, 0x73E4 },
        { 0x6DD3, 0x73E5 },
        { 0x6DFD, 0x73E6 },
        { 0x6DD7, 0x73E7 },
        { 0x6DCD, 0x73E8 },
        { 0x6DE3, 0x73E9 },
        { 0x6DBB, 0x73EA },
        { 0x70FA, 0x73EB },
        { 0x710D, 0x73EC },
        { 0x70F7, 0x73ED },
        { 0x7117, 0x73EE },
        { 0x70F4, 0x73EF },
        { 0x710C, 0x73F0 },
        { 0x70F0, 0x73F1 },
        { 0x7104, 0x73F2 },
        { 0x70F3, 0x73F3 },
        { 0x7110, 0x73F4 },
        { 0x70FC, 0x73F5 },
        { 0x70FF, 0x73F6 },
        { 0x7106, 0x73F7 },
        { 0x7113, 0x73F8 },
        { 0x7100, 0x73F9 },
        { 0x70F8, 0x73FA },
        { 0x70F6, 0x73FB },
        { 0x710B, 0x73FC },
        { 0x7102, 0x73FD },
        { 0x710E, 0x7441 },
        { 0x727E, 0x7442 },
        { 0x727B, 0x7443 },
        { 0x727C, 0x7444 },
        { 0x727F, 0x7445 },
        { 0x731D, 0x7446 },
        { 0x7317, 0x7447 },
        { 0x7307, 0x7448 },
        { 0x7311, 0x7449 },
        { 0x7318, 0x744A },
        { 0x730A, 0x744B },
        { 0x7308, 0x744C },
        { 0x72FF, 0x744D },
        { 0x730F, 0x744E },
        { 0x731E, 0x744F },
        { 0x7388, 0x7450 },
        { 0x73F6, 0x7451 },
        { 0x73F8, 0x7452 },
        { 0x73F5, 0x7453 },
        { 0x7404, 0x7454 },
        { 0x7401, 0x7455 },
        { 0x73FD, 0x7456 },
        { 0x7407, 0x7457 },
        { 0x7400, 0x7458 },
        { 0x73FA, 0x7459 },
        { 0x73FC, 0x745A },
        { 0x73FF, 0x745B },
        { 0x740C, 0x745C },
        { 0x740B, 0x745D },
        { 0x73F4, 0x745E },
        { 0x7408, 0x745F },
        { 0x7564, 0x7460 },
        { 0x7563, 0x7461 },
        { 0x75CE, 0x7462 },
        { 0x75D2, 0x7463 },
        { 0x75CF, 0x7464 },
        { 0x75CB, 0x7465 },
        { 0x75CC, 0x7466 },
        { 0x75D1, 0x7467 },
        { 0x75D0, 0x7468 },
        { 0x768F, 0x7469 },
        { 0x7689, 0x746A },
        { 0x76D3, 0x746B },
        { 0x7739, 0x746C },
        { 0x772F, 0x746D },
        { 0x772D, 0x746E },
        { 0x7731, 0x746F },
        { 0x7732, 0x7470 },
        { 0x7734, 0x7471 },
        { 0x7733, 0x7472 },
        { 0x773D, 0x7473 },
        { 0x7725, 0x7474 },
        { 0x773B, 0x7475 },
        { 0x7735, 0x7476 },
        { 0x7848, 0x7477 },
        { 0x7852, 0x7478 },
        { 0x7849, 0x7479 },
        { 0x784D, 0x747A },
        { 0x784A, 0x747B },
        { 0x784C, 0x747C },
        { 0x7826, 0x747D },
        { 0x7845, 0x747E },
        { 0x7850, 0x747F },
        { 0x7964, 0x7481 },
        { 0x7967, 0x7482 },
        { 0x7969, 0x7483 },
        { 0x796A, 0x7484 },
        { 0x7963, 0x7485 },
        { 0x796B, 0x7486 },
        { 0x7961, 0x7487 },
        { 0x79BB, 0x7488 },
        { 0x79FA, 0x7489 },
        { 0x79F8, 0x748A },
        { 0x79F6, 0x748B },
        { 0x79F7, 0x748C },
        { 0x7A8F, 0x748D },
        { 0x7A94, 0x748E },
        { 0x7A90, 0x748F },
        { 0x7B35, 0x7490 },
        { 0x7B47, 0x7491 },
        { 0x7B34, 0x7492 },
        { 0x7B25, 0x7493 },
        { 0x7B30, 0x7494 },
        { 0x7B22, 0x7495 },
        { 0x7B24, 0x7496 },
        { 0x7B33, 0x7497 },
        { 0x7B18, 0x7498 },
        { 0x7B2A, 0x7499 },
        { 0x7B1D, 0x749A },
        { 0x7B31, 0x749B },
        { 0x7B2B, 0x749C },
        { 0x7B2D, 0x749D },
        { 0x7B2F, 0x749E },
        { 0x7B32, 0x749F },
        { 0x7B38, 0x74A0 },
        { 0x7B1A, 0x74A1 },
        { 0x7B23, 0x74A2 },
        { 0x7C94, 0x74A3 },
        { 0x7C98, 0x74A4 },
        { 0x7C96, 0x74A5 },
        { 0x7CA3, 0x74A6 },
        { 0x7D35, 0x74A7 },
        { 0x7D3D, 0x74A8 },
        { 0x7D38, 0x74A9 },
        { 0x7D36, 0x74AA },
        { 0x7D3A, 0x74AB },
        { 0x7D45, 0x74AC },
        { 0x7D2C, 0x74AD },
        { 0x7D29, 0x74AE },
        { 0x7D41, 0x74AF },
        { 0x7D47, 0x74B0 },
        { 0x7D3E, 0x74B1 },
        { 0x7D3F, 0x74B2 },
        { 0x7D4A, 0x74B3 },
        { 0x7D3B, 0x74B4 },
        { 0x7D28, 0x74B5 },
        { 0x7F63, 0x74B6 },
        { 0x7F95, 0x74B7 },
        { 0x7F9C, 0x74B8 },
        { 0x7F9D, 0x74B9 },
        { 0x7F9B, 0x74BA },
        { 0x7FCA, 0x74BB },
        { 0x7FCB, 0x74BC },
        { 0x7FCD, 0x74BD },
        { 0x7FD0, 0x74BE },
        { 0x7FD1, 0x74BF },
        { 0x7FC7, 0x74C0 },
        { 0x7FCF, 0x74C1 },
        { 0x7FC9, 0x74C2 },
        { 0x801F, 0x74C3 },
        { 0x801E, 0x74C4 },
        { 0x801B, 0x74C5 },
        { 0x8047, 0x74C6 },
        { 0x8043, 0x74C7 },
        { 0x8048, 0x74C8 },
        { 0x8118, 0x74C9 },
        { 0x8125, 0x74CA },
        { 0x8119, 0x74CB },
        { 0x811B, 0x74CC },
        { 0x812D, 0x74CD },
        { 0x811F, 0x74CE },
        { 0x812C, 0x74CF },
        { 0x811E, 0x74D0 },
        { 0x8121, 0x74D1 },
        { 0x8115, 0x74D2 },
        { 0x8127, 0x74D3 },
        { 0x811D, 0x74D4 },
        { 0x8122, 0x74D5 },
        { 0x8211, 0x74D6 },
        { 0x8238, 0x74D7 },
        { 0x8233, 0x74D8 },
        { 0x823A, 0x74D9 },
        { 0x8234, 0x74DA },
        { 0x8232, 0x74DB },
        { 0x8274, 0x74DC },
        { 0x8390, 0x74DD },
        { 0x83A3, 0x74DE },
        { 0x83A8, 0x74DF },
        { 0x838D, 0x74E0 },
        { 0x837A, 0x74E1 },
        { 0x8373, 0x74E2 },
        { 0x83A4, 0x74E3 },
        { 0x8374, 0x74E4 },
        { 0x838F, 0x74E5 },
        { 0x8381, 0x74E6 },
        { 0x8395, 0x74E7 },
        { 0x8399, 0x74E8 },
        { 0x8375, 0x74E9 },
        { 0x8394, 0x74EA },
        { 0x83A9, 0x74EB },
        { 0x837D, 0x74EC },
        { 0x8383, 0x74ED },
        { 0x838C, 0x74EE },
        { 0x839D, 0x74EF },
        { 0x839B, 0x74F0 },
        { 0x83AA, 0x74F1 },
        { 0x838B, 0x74F2 },
        { 0x837E, 0x74F3 },
        { 0x83A5, 0x74F4 },
        { 0x83AF, 0x74F5 },
        { 0x8388, 0x74F6 },
        { 0x8397, 0x74F7 },
        { 0x83B0, 0x74F8 },
        { 0x837F, 0x74F9 },
        { 0x83A6, 0x74FA },
        { 0x8387, 0x74FB },
        { 0x83AE, 0x74FC },
        { 0x8376, 0x74FD },
        { 0x839A, 0x7541 },
        { 0x8659, 0x7542 },
        { 0x8656, 0x7543 },
        { 0x86BF, 0x7544 },
        { 0x86B7, 0x7545 },
        { 0x86C2, 0x7546 },
        { 0x86C1, 0x7547 },
        { 0x86C5, 0x7548 },
        { 0x86BA, 0x7549 },
        { 0x86B0, 0x754A },
        { 0x86C8, 0x754B },
        { 0x86B9, 0x754C },
        { 0x86B3, 0x754D },
        { 0x86B8, 0x754E },
        { 0x86CC, 0x754F },
        { 0x86B4, 0x7550 },
        { 0x86BB, 0x7551 },
        { 0x86BC, 0x7552 },
        { 0x86C3, 0x7553 },
        { 0x86BD, 0x7554 },
        { 0x86BE, 0x7555 },
        { 0x8852, 0x7556 },
        { 0x8889, 0x7557 },
        { 0x8895, 0x7558 },
        { 0x88A8, 0x7559 },
        { 0x88A2, 0x755A },
        { 0x88AA, 0x755B },
        { 0x889A, 0x755C },
        { 0x8891, 0x755D },
        { 0x88A1, 0x755E },
        { 0x889F, 0x755F },
        { 0x8898, 0x7560 },
        { 0x88A7, 0x7561 },
        { 0x8899, 0x7562 },
        { 0x889B, 0x7563 },
        { 0x8897, 0x7564 },
        { 0x88A4, 0x7565 },
        { 0x88AC, 0x7566 },
        { 0x888C, 0x7567 },
        { 0x8893, 0x7568 },
        { 0x888E, 0x7569 },
        { 0x8982, 0x756A },
        { 0x89D6, 0x756B },
        { 0x89D9, 0x756C },
        { 0x89D5, 0x756D },
        { 0x8A30, 0x756E },
        { 0x8A27, 0x756F },
        { 0x8A2C, 0x7570 },
        { 0x8A1E, 0x7571 },
        { 0x8C39, 0x7572 },
        { 0x8C3B, 0x7573 },
        { 0x8C5C, 0x7574 },
        { 0x8C5D, 0x7575 },
        { 0x8C7D, 0x7576 },
        { 0x8CA5, 0x7577 },
        { 0x8D7D, 0x7578 },
        { 0x8D7B, 0x7579 },
        { 0x8D79, 0x757A },
        { 0x8DBC, 0x757B },
        { 0x8DC2, 0x757C },
        { 0x8DB9, 0x757D },
        { 0x8DBF, 0x757E },
        { 0x8DC1, 0x757F },
        { 0x8ED8, 0x7581 },
        { 0x8EDE, 0x7582 },
        { 0x8EDD, 0x7583 },
        { 0x8EDC, 0x7584 },
        { 0x8ED7, 0x7585 },
        { 0x8EE0, 0x7586 },
        { 0x8EE1, 0x7587 },
        { 0x9024, 0x7588 },
        { 0x900B, 0x7589 },
        { 0x9011, 0x758A },
        { 0x901C, 0x758B },
        { 0x900C, 0x758C },
        { 0x9021, 0x758D },
        { 0x90EF, 0x758E },
        { 0x90EA, 0x758F },
        { 0x90F0, 0x7590 },
        { 0x90F4, 0x7591 },
        { 0x90F2, 0x7592 },
        { 0x90F3, 0x7593 },
        { 0x90D4, 0x7594 },
        { 0x90EB, 0x7595 },
        { 0x90EC, 0x7596 },
        { 0x90E9, 0x7597 },
        { 0x9156, 0x7598 },
        { 0x9158, 0x7599 },
        { 0x915A, 0x759A },
        { 0x9153, 0x759B },
        { 0x9155, 0x759C },
        { 0x91EC, 0x759D },
        { 0x91F4, 0x759E },
        { 0x91F1, 0x759F },
        { 0x91F3, 0x75A0 },
        { 0x91F8, 0x75A1 },
        { 0x91E4, 0x75A2 },
        { 0x91F9, 0x75A3 },
        { 0x91EA, 0x75A4 },
        { 0x91EB, 0x75A5 },
        { 0x91F7, 0x75A6 },
        { 0x91E8, 0x75A7 },
        { 0x91EE, 0x75A8 },
        { 0x957A, 0x75A9 },
        { 0x9586, 0x75AA },
        { 0x9588, 0x75AB },
        { 0x967C, 0x75AC },
        { 0x966D, 0x75AD },
        { 0x966B, 0x75AE },
        { 0x9671, 0x75AF },
        { 0x966F, 0x75B0 },
        { 0x96BF, 0x75B1 },
        { 0x976A, 0x75B2 },
        { 0x9804, 0x75B3 },
        { 0x98E5, 0x75B4 },
        { 0x9997, 0x75B5 },
        { 0x509B, 0x75B6 },
        { 0x5095, 0x75B7 },
        { 0x5094, 0x75B8 },
        { 0x509E, 0x75B9 },
        { 0x508B, 0x75BA },
        { 0x50A3, 0x75BB },
        { 0x5083, 0x75BC },
        { 0x508C, 0x75BD },
        { 0x508E, 0x75BE },
        { 0x509D, 0x75BF },
        { 0x5068, 0x75C0 },
        { 0x509C, 0x75C1 },
        { 0x5092, 0x75C2 },
        { 0x5082, 0x75C3 },
        { 0x5087, 0x75C4 },
        { 0x515F, 0x75C5 },
        { 0x51D4, 0x75C6 },
        { 0x5312, 0x75C7 },
        { 0x5311, 0x75C8 },
        { 0x53A4, 0x75C9 },
        { 0x53A7, 0x75CA },
        { 0x5591, 0x75CB },
        { 0x55A8, 0x75CC },
        { 0x55A5, 0x75CD },
        { 0x55AD, 0x75CE },
        { 0x5577, 0x75CF },
        { 0x5645, 0x75D0 },
        { 0x55A2, 0x75D1 },
        { 0x5593, 0x75D2 },
        { 0x5588, 0x75D3 },
        { 0x558F, 0x75D4 },
        { 0x55B5, 0x75D5 },
        { 0x5581, 0x75D6 },
        { 0x55A3, 0x75D7 },
        { 0x5592, 0x75D8 },
        { 0x55A4, 0x75D9 },
        { 0x557D, 0x75DA },
        { 0x558C, 0x75DB },
        { 0x55A6, 0x75DC },
        { 0x557F, 0x75DD },
        { 0x5595, 0x75DE },
        { 0x55A1, 0x75DF },
        { 0x558E, 0x75E0 },
        { 0x570C, 0x75E1 },
        { 0x5829, 0x75E2 },
        { 0x5837, 0x75E3 },
        { 0x5819, 0x75E4 },
        { 0x581E, 0x75E5 },
        { 0x5827, 0x75E6 },
        { 0x5823, 0x75E7 },
        { 0x5828, 0x75E8 },
        { 0x57F5, 0x75E9 },
        { 0x5848, 0x75EA },
        { 0x5825, 0x75EB },
        { 0x581C, 0x75EC },
        { 0x581B, 0x75ED },
        { 0x5833, 0x75EE },
        { 0x583F, 0x75EF },
        { 0x5836, 0x75F0 },
        { 0x582E, 0x75F1 },
        { 0x5839, 0x75F2 },
        { 0x5838, 0x75F3 },
        { 0x582D, 0x75F4 },
        { 0x582C, 0x75F5 },
        { 0x583B, 0x75F6 },
        { 0x5961, 0x75F7 },
        { 0x5AAF, 0x75F8 },
        { 0x5A94, 0x75F9 },
        { 0x5A9F, 0x75FA },
        { 0x5A7A, 0x75FB },
        { 0x5AA2, 0x75FC },
        { 0x5A9E, 0x75FD },
        { 0x5A78, 0x7641 },
        { 0x5AA6, 0x7642 },
        { 0x5A7C, 0x7643 },
        { 0x5AA5, 0x7644 },
        { 0x5AAC, 0x7645 },
        { 0x5A95, 0x7646 },
        { 0x5AAE, 0x7647 },
        { 0x5A37, 0x7648 },
        { 0x5A84, 0x7649 },
        { 0x5A8A, 0x764A },
        { 0x5A97, 0x764B },
        { 0x5A83, 0x764C },
        { 0x5A8B, 0x764D },
        { 0x5AA9, 0x764E },
        { 0x5A7B, 0x764F },
        { 0x5A7D, 0x7650 },
        { 0x5A8C, 0x7651 },
        { 0x5A9C, 0x7652 },
        { 0x5A8F, 0x7653 },
        { 0x5A93, 0x7654 },
        { 0x5A9D, 0x7655 },
        { 0x5BEA, 0x7656 },
        { 0x5BCD, 0x7657 },
        { 0x5BCB, 0x7658 },
        { 0x5BD4, 0x7659 },
        { 0x5BD1, 0x765A },
        { 0x5BCA, 0x765B },
        { 0x5BCE, 0x765C },
        { 0x5C0C, 0x765D },
        { 0x5C30, 0x765E },
        { 0x5D37, 0x765F },
        { 0x5D43, 0x7660 },
        { 0x5D6B, 0x7661 },
        { 0x5D41, 0x7662 },
        { 0x5D4B, 0x7663 },
        { 0x5D3F, 0x7664 },
        { 0x5D35, 0x7665 },
        { 0x5D51, 0x7666 },
        { 0x5D4E, 0x7667 },
        { 0x5D55, 0x7668 },
        { 0x5D33, 0x7669 },
        { 0x5D3A, 0x766A },
        { 0x5D52, 0x766B },
        { 0x5D3D, 0x766C },
        { 0x5D31, 0x766D },
        { 0x5D59, 0x766E },
        { 0x5D42, 0x766F },
        { 0x5D39, 0x7670 },
        { 0x5D49, 0x7671 },
        { 0x5D38, 0x7672 },
        { 0x5D3C, 0x7673 },
        { 0x5D32, 0x7674 },
        { 0x5D36, 0x7675 },
        { 0x5D40, 0x7676 },
        { 0x5D45, 0x7677 },
        { 0x5E44, 0x7678 },
        { 0x5E41, 0x7679 },
        { 0x5F58, 0x767A },
        { 0x5FA6, 0x767B },
        { 0x5FA5, 0x767C },
        { 0x5FAB, 0x767D },
        { 0x60C9, 0x767E },
        { 0x60B9, 0x767F },
        { 0x60CC, 0x7681 },
        { 0x60E2, 0x7682 },
        { 0x60CE, 0x7683 },
        { 0x60C4, 0x7684 },
        { 0x6114, 0x7685 },
        { 0x60F2, 0x7686 },
        { 0x610A, 0x7687 },
        { 0x6116, 0x7688 },
        { 0x6105, 0x7689 },
        { 0x60F5, 0x768A },
        { 0x6113, 0x768B },
        { 0x60F8, 0x768C },
        { 0x60FC, 0x768D },
        { 0x60FE, 0x768E },
        { 0x60C1, 0x768F },
        { 0x6103, 0x7690 },
        { 0x6118, 0x7691 },
        { 0x611D, 0x7692 },
        { 0x6110, 0x7693 },
        { 0x60FF, 0x7694 },
        { 0x6104, 0x7695 },
        { 0x610B, 0x7696 },
        { 0x624A, 0x7697 },
        { 0x6394, 0x7698 },
        { 0x63B1, 0x7699 },
        { 0x63B0, 0x769A },
        { 0x63CE, 0x769B },
        { 0x63E5, 0x769C },
        { 0x63E8, 0x769D },
        { 0x63EF, 0x769E },
        { 0x63C3, 0x769F },
        { 0x649D, 0x76A0 },
        { 0x63F3, 0x76A1 },
        { 0x63CA, 0x76A2 },
        { 0x63E0, 0x76A3 },
        { 0x63F6, 0x76A4 },
        { 0x63D5, 0x76A5 },
        { 0x63F2, 0x76A6 },
        { 0x63F5, 0x76A7 },
        { 0x6461, 0x76A8 },
        { 0x63DF, 0x76A9 },
        { 0x63BE, 0x76AA },
        { 0x63DD, 0x76AB },
        { 0x63DC, 0x76AC },
        { 0x63C4, 0x76AD },
        { 0x63D8, 0x76AE },
        { 0x63D3, 0x76AF },
        { 0x63C2, 0x76B0 },
        { 0x63C7, 0x76B1 },
        { 0x63CC, 0x76B2 },
        { 0x63CB, 0x76B3 },
        { 0x63C8, 0x76B4 },
        { 0x63F0, 0x76B5 },
        { 0x63D7, 0x76B6 },
        { 0x63D9, 0x76B7 },
        { 0x6532, 0x76B8 },
        { 0x6567, 0x76B9 },
        { 0x656A, 0x76BA },
        { 0x6564, 0x76BB },
        { 0x655C, 0x76BC },
        { 0x6568, 0x76BD },
        { 0x6565, 0x76BE },
        { 0x658C, 0x76BF },
        { 0x659D, 0x76C0 },
        { 0x659E, 0x76C1 },
        { 0x65AE, 0x76C2 },
        { 0x65D0, 0x76C3 },
        { 0x65D2, 0x76C4 },
        { 0x667C, 0x76C5 },
        { 0x666C, 0x76C6 },
        { 0x667B, 0x76C7 },
        { 0x6680, 0x76C8 },
        { 0x6671, 0x76C9 },
        { 0x6679, 0x76CA },
        { 0x666A, 0x76CB },
        { 0x6672, 0x76CC },
        { 0x6701, 0x76CD },
        { 0x690C, 0x76CE },
        { 0x68D3, 0x76CF },
        { 0x6904, 0x76D0 },
        { 0x68DC, 0x76D1 },
        { 0x692A, 0x76D2 },
        { 0x68EC, 0x76D3 },
        { 0x68EA, 0x76D4 },
        { 0x68F1, 0x76D5 },
        { 0x690F, 0x76D6 },
        { 0x68D6, 0x76D7 },
        { 0x68F7, 0x76D8 },
        { 0x68EB, 0x76D9 },
        { 0x68E4, 0x76DA },
        { 0x68F6, 0x76DB },
        { 0x6913, 0x76DC },
        { 0x6910, 0x76DD },
        { 0x68F3, 0x76DE },
        { 0x68E1, 0x76DF },
        { 0x6907, 0x76E0 },
        { 0x68CC, 0x76E1 },
        { 0x6908, 0x76E2 },
        { 0x6970, 0x76E3 },
        { 0x68B4, 0x76E4 },
        { 0x6911, 0x76E5 },
        { 0x68EF, 0x76E6 },
        { 0x68C6, 0x76E7 },
        { 0x6914, 0x76E8 },
        { 0x68F8, 0x76E9 },
        { 0x68D0, 0x76EA },
        { 0x68FD, 0x76EB },
        { 0x68FC, 0x76EC },
        { 0x68E8, 0x76ED },
        { 0x690B, 0x76EE },
        { 0x690A, 0x76EF },
        { 0x6917, 0x76F0 },
        { 0x68CE, 0x76F1 },
        { 0x68C8, 0x76F2 },
        { 0x68DD, 0x76F3 },
        { 0x68DE, 0x76F4 },
        { 0x68E6, 0x76F5 },
        { 0x68F4, 0x76F6 },
        { 0x68D1, 0x76F7 },
        { 0x6906, 0x76F8 },
        { 0x68D4, 0x76F9 },
        { 0x68E9, 0x76FA },
        { 0x6915, 0x76FB },
        { 0x6925, 0x76FC },
        { 0x68C7, 0x76FD },
        { 0x6B39, 0x7741 },
        { 0x6B3B, 0x7742 },
        { 0x6B3F, 0x7743 },
        { 0x6B3C, 0x7744 },
        { 0x6B94, 0x7745 },
        { 0x6B97, 0x7746 },
        { 0x6B99, 0x7747 },
        { 0x6B95, 0x7748 },
        { 0x6BBD, 0x7749 },
        { 0x6BF0, 0x774A },
        { 0x6BF2, 0x774B },
        { 0x6BF3, 0x774C },
        { 0x6C30, 0x774D },
        { 0x6DFC, 0x774E },
        { 0x6E46, 0x774F },
        { 0x6E47, 0x7750 },
        { 0x6E1F, 0x7751 },
        { 0x6E49, 0x7752 },
        { 0x6E88, 0x7753 },
        { 0x6E3C, 0x7754 },
        { 0x6E3D, 0x7755 },
        { 0x6E45, 0x7756 },
        { 0x6E62, 0x7757 },
        { 0x6E2B, 0x7758 },
        { 0x6E3F, 0x7759 },
        { 0x6E41, 0x775A },
        { 0x6E5D, 0x775B },
        { 0x6E73, 0x775C },
        { 0x6E1C, 0x775D },
        { 0x6E33, 0x775E },
        { 0x6E4B, 0x775F },
        { 0x6E40, 0x7760 },
        { 0x6E51, 0x7761 },
        { 0x6E3B, 0x7762 },
        { 0x6E03, 0x7763 },
        { 0x6E2E, 0x7764 },
        { 0x6E5E, 0x7765 },
        { 0x6E68, 0x7766 },
        { 0x6E5C, 0x7767 },
        { 0x6E61, 0x7768 },
        { 0x6E31, 0x7769 },
        { 0x6E28, 0x776A },
        { 0x6E60, 0x776B },
        { 0x6E71, 0x776C },
        { 0x6E6B, 0x776D },
        { 0x6E39, 0x776E },
        { 0x6E22, 0x776F },
        { 0x6E30, 0x7770 },
        { 0x6E53, 0x7771 },
        { 0x6E65, 0x7772 },
        { 0x6E27, 0x7773 },
        { 0x6E78, 0x7774 },
        { 0x6E64, 0x7775 },
        { 0x6E77, 0x7776 },
        { 0x6E55, 0x7777 },
        { 0x6E79, 0x7778 },
        { 0x6E52, 0x7779 },
        { 0x6E66, 0x777A },
        { 0x6E35, 0x777B },
        { 0x6E36, 0x777C },
        { 0x6E5A, 0x777D },
        { 0x7120, 0x777E },
        { 0x711E, 0x777F },
        { 0x712F, 0x7781 },
        { 0x70FB, 0x7782 },
        { 0x712E, 0x7783 },
        { 0x7131, 0x7784 },
        { 0x7123, 0x7785 },
        { 0x7125, 0x7786 },
        { 0x7122, 0x7787 },
        { 0x7132, 0x7788 },
        { 0x711F, 0x7789 },
        { 0x7128, 0x778A },
        { 0x713A, 0x778B },
        { 0x711B, 0x778C },
        { 0x724B, 0x778D },
        { 0x725A, 0x778E },
        { 0x7288, 0x778F },
        { 0x7289, 0x7790 },
        { 0x7286, 0x7791 },
        { 0x7285, 0x7792 },
        { 0x728B, 0x7793 },
        { 0x7312, 0x7794 },
        { 0x730B, 0x7795 },
        { 0x7330, 0x7796 },
        { 0x7322, 0x7797 },
        { 0x7331, 0x7798 },
        { 0x7333, 0x7799 },
        { 0x7327, 0x779A },
        { 0x7332, 0x779B },
        { 0x732D, 0x779C },
        { 0x7326, 0x779D },
        { 0x7323, 0x779E },
        { 0x7335, 0x779F },
        { 0x730C, 0x77A0 },
        { 0x742E, 0x77A1 },
        { 0x742C, 0x77A2 },
        { 0x7430, 0x77A3 },
        { 0x742B, 0x77A4 },
        { 0x7416, 0x77A5 },
        { 0x741A, 0x77A6 },
        { 0x7421, 0x77A7 },
        { 0x742D, 0x77A8 },
        { 0x7431, 0x77A9 },
        { 0x7424, 0x77AA },
        { 0x7423, 0x77AB },
        { 0x741D, 0x77AC },
        { 0x7429, 0x77AD },
        { 0x7420, 0x77AE },
        { 0x7432, 0x77AF },
        { 0x74FB, 0x77B0 },
        { 0x752F, 0x77B1 },
        { 0x756F, 0x77B2 },
        { 0x756C, 0x77B3 },
        { 0x75E7, 0x77B4 },
        { 0x75DA, 0x77B5 },
        { 0x75E1, 0x77B6 },
        { 0x75E6, 0x77B7 },
        { 0x75DD, 0x77B8 },
        { 0x75DF, 0x77B9 },
        { 0x75E4, 0x77BA },
        { 0x75D7, 0x77BB },
        { 0x7695, 0x77BC },
        { 0x7692, 0x77BD },
        { 0x76DA, 0x77BE },
        { 0x7746, 0x77BF },
        { 0x7747, 0x77C0 },
        { 0x7744, 0x77C1 },
        { 0x774D, 0x77C2 },
        { 0x7745, 0x77C3 },
        { 0x774A, 0x77C4 },
        { 0x774E, 0x77C5 },
        { 0x774B, 0x77C6 },
        { 0x774C, 0x77C7 },
        { 0x77DE, 0x77C8 },
        { 0x77EC, 0x77C9 },
        { 0x7860, 0x77CA },
        { 0x7864, 0x77CB },
        { 0x7865, 0x77CC },
        { 0x785C, 0x77CD },
        { 0x786D, 0x77CE },
        { 0x7871, 0x77CF },
        { 0x786A, 0x77D0 },
        { 0x786E, 0x77D1 },
        { 0x7870, 0x77D2 },
        { 0x7869, 0x77D3 },
        { 0x7868, 0x77D4 },
        { 0x785E, 0x77D5 },
        { 0x7862, 0x77D6 },
        { 0x7974, 0x77D7 },
        { 0x7973, 0x77D8 },
        { 0x7972, 0x77D9 },
        { 0x7970, 0x77DA },
        { 0x7A02, 0x77DB },
        { 0x7A0A, 0x77DC },
        { 0x7A03, 0x77DD },
        { 0x7A0C, 0x77DE },
        { 0x7A04, 0x77DF },
        { 0x7A99, 0x77E0 },
        { 0x7AE6, 0x77E1 },
        { 0x7AE4, 0x77E2 },
        { 0x7B4A, 0x77E3 },
        { 0x7B3B, 0x77E4 },
        { 0x7B44, 0x77E5 },
        { 0x7B48, 0x77E6 },
        { 0x7B4C, 0x77E7 },
        { 0x7B4E, 0x77E8 },
        { 0x7B40, 0x77E9 },
        { 0x7B58, 0x77EA },
        { 0x7B45, 0x77EB },
        { 0x7CA2, 0x77EC },
        { 0x7C9E, 0x77ED },
        { 0x7CA8, 0x77EE },
        { 0x7CA1, 0x77EF },
        { 0x7D58, 0x77F0 },
        { 0x7D6F, 0x77F1 },
        { 0x7D63, 0x77F2 },
        { 0x7D53, 0x77F3 },
        { 0x7D56, 0x77F4 },
        { 0x7D67, 0x77F5 },
        { 0x7D6A, 0x77F6 },
        { 0x7D4F, 0x77F7 },
        { 0x7D6D, 0x77F8 },
        { 0x7D5C, 0x77F9 },
        { 0x7D6B, 0x77FA },
        { 0x7D52, 0x77FB },
        { 0x7D54, 0x77FC },
        { 0x7D69, 0x77FD },
        { 0x7D51, 0x7841 },
        { 0x7D5F, 0x7842 },
        { 0x7D4E, 0x7843 },
        { 0x7F3E, 0x7844 },
        { 0x7F3F, 0x7845 },
        { 0x7F65, 0x7846 },
        { 0x7F66, 0x7847 },
        { 0x7FA2, 0x7848 },
        { 0x7FA0, 0x7849 },
        { 0x7FA1, 0x784A },
        { 0x7FD7, 0x784B },
        { 0x8051, 0x784C },
        { 0x804F, 0x784D },
        { 0x8050, 0x784E },
        { 0x80FE, 0x784F },
        { 0x80D4, 0x7850 },
        { 0x8143, 0x7851 },
        { 0x814A, 0x7852 },
        { 0x8152, 0x7853 },
        { 0x814F, 0x7854 },
        { 0x8147, 0x7855 },
        { 0x813D, 0x7856 },
        { 0x814D, 0x7857 },
        { 0x813A, 0x7858 },
        { 0x81E6, 0x7859 },
        { 0x81EE, 0x785A },
        { 0x81F7, 0x785B },
        { 0x81F8, 0x785C },
        { 0x81F9, 0x785D },
        { 0x8204, 0x785E },
        { 0x823C, 0x785F },
        { 0x823D, 0x7860 },
        { 0x823F, 0x7861 },
        { 0x8275, 0x7862 },
        { 0x833B, 0x7863 },
        { 0x83CF, 0x7864 },
        { 0x83F9, 0x7865 },
        { 0x8423, 0x7866 },
        { 0x83C0, 0x7867 },
        { 0x83E8, 0x7868 },
        { 0x8412, 0x7869 },
        { 0x83E7, 0x786A },
        { 0x83E4, 0x786B },
        { 0x83FC, 0x786C },
        { 0x83F6, 0x786D },
        { 0x8410, 0x786E },
        { 0x83C6, 0x786F },
        { 0x83C8, 0x7870 },
        { 0x83EB, 0x7871 },
        { 0x83E3, 0x7872 },
        { 0x83BF, 0x7873 },
        { 0x8401, 0x7874 },
        { 0x83DD, 0x7875 },
        { 0x83E5, 0x7876 },
        { 0x83D8, 0x7877 },
        { 0x83FF, 0x7878 },
        { 0x83E1, 0x7879 },
        { 0x83CB, 0x787A },
        { 0x83CE, 0x787B },
        { 0x83D6, 0x787C },
        { 0x83F5, 0x787D },
        { 0x83C9, 0x787E },
        { 0x8409, 0x787F },
        { 0x840F, 0x7881 },
        { 0x83DE, 0x7882 },
        { 0x8411, 0x7883 },
        { 0x8406, 0x7884 },
        { 0x83C2, 0x7885 },
        { 0x83F3, 0x7886 },
        { 0x83D5, 0x7887 },
        { 0x83FA, 0x7888 },
        { 0x83C7, 0x7889 },
        { 0x83D1, 0x788A },
        { 0x83EA, 0x788B },
        { 0x8413, 0x788C },
        { 0x83C3, 0x788D },
        { 0x83EC, 0x788E },
        { 0x83EE, 0x788F },
        { 0x83C4, 0x7890 },
        { 0x83FB, 0x7891 },
        { 0x83D7, 0x7892 },
        { 0x83E2, 0x7893 },
        { 0x841B, 0x7894 },
        { 0x83DB, 0x7895 },
        { 0x83FE, 0x7896 },
        { 0x86D8, 0x7897 },
        { 0x86E2, 0x7898 },
        { 0x86E6, 0x7899 },
        { 0x86D3, 0x789A },
        { 0x86E3, 0x789B },
        { 0x86DA, 0x789C },
        { 0x86EA, 0x789D },
        { 0x86DD, 0x789E },
        { 0x86EB, 0x789F },
        { 0x86DC, 0x78A0 },
        { 0x86EC, 0x78A1 },
        { 0x86E9, 0x78A2 },
        { 0x86D7, 0x78A3 },
        { 0x86E8, 0x78A4 },
        { 0x86D1, 0x78A5 },
        { 0x8848, 0x78A6 },
        { 0x8856, 0x78A7 },
        { 0x8855, 0x78A8 },
        { 0x88BA, 0x78A9 },
        { 0x88D7, 0x78AA },
        { 0x88B9, 0x78AB },
        { 0x88B8, 0x78AC },
        { 0x88C0, 0x78AD },
        { 0x88BE, 0x78AE },
        { 0x88B6, 0x78AF },
        { 0x88BC, 0x78B0 },
        { 0x88B7, 0x78B1 },
        { 0x88BD, 0x78B2 },
        { 0x88B2, 0x78B3 },
        { 0x8901, 0x78B4 },
        { 0x88C9, 0x78B5 },
        { 0x8995, 0x78B6 },
        { 0x8998, 0x78B7 },
        { 0x8997, 0x78B8 },
        { 0x89DD, 0x78B9 },
        { 0x89DA, 0x78BA },
        { 0x89DB, 0x78BB },
        { 0x8A4E, 0x78BC },
        { 0x8A4D, 0x78BD },
        { 0x8A39, 0x78BE },
        { 0x8A59, 0x78BF },
        { 0x8A40, 0x78C0 },
        { 0x8A57, 0x78C1 },
        { 0x8A58, 0x78C2 },
        { 0x8A44, 0x78C3 },
        { 0x8A45, 0x78C4 },
        { 0x8A52, 0x78C5 },
        { 0x8A48, 0x78C6 },
        { 0x8A51, 0x78C7 },
        { 0x8A4A, 0x78C8 },
        { 0x8A4C, 0x78C9 },
        { 0x8A4F, 0x78CA },
        { 0x8C5F, 0x78CB },
        { 0x8C81, 0x78CC },
        { 0x8C80, 0x78CD },
        { 0x8CBA, 0x78CE },
        { 0x8CBE, 0x78CF },
        { 0x8CB0, 0x78D0 },
        { 0x8CB9, 0x78D1 },
        { 0x8CB5, 0x78D2 },
        { 0x8D84, 0x78D3 },
        { 0x8D80, 0x78D4 },
        { 0x8D89, 0x78D5 },
        { 0x8DD8, 0x78D6 },
        { 0x8DD3, 0x78D7 },
        { 0x8DCD, 0x78D8 },
        { 0x8DC7, 0x78D9 },
        { 0x8DD6, 0x78DA },
        { 0x8DDC, 0x78DB },
        { 0x8DCF, 0x78DC },
        { 0x8DD5, 0x78DD },
        { 0x8DD9, 0x78DE },
        { 0x8DC8, 0x78DF },
        { 0x8DD7, 0x78E0 },
        { 0x8DC5, 0x78E1 },
        { 0x8EEF, 0x78E2 },
        { 0x8EF7, 0x78E3 },
        { 0x8EFA, 0x78E4 },
        { 0x8EF9, 0x78E5 },
        { 0x8EE6, 0x78E6 },
        { 0x8EEE, 0x78E7 },
        { 0x8EE5, 0x78E8 },
        { 0x8EF5, 0x78E9 },
        { 0x8EE7, 0x78EA },
        { 0x8EE8, 0x78EB },
        { 0x8EF6, 0x78EC },
        { 0x8EEB, 0x78ED },
        { 0x8EF1, 0x78EE },
        { 0x8EEC, 0x78EF },
        { 0x8EF4, 0x78F0 },
        { 0x8EE9, 0x78F1 },
        { 0x902D, 0x78F2 },
        { 0x9034, 0x78F3 },
        { 0x902F, 0x78F4 },
        { 0x9106, 0x78F5 },
        { 0x912C, 0x78F6 },
        { 0x9104, 0x78F7 },
        { 0x90FF, 0x78F8 },
        { 0x90FC, 0x78F9 },
        { 0x9108, 0x78FA },
        { 0x90F9, 0x78FB },
        { 0x90FB, 0x78FC },
        { 0x9101, 0x78FD },
        { 0x9100, 0x7941 },
        { 0x9107, 0x7942 },
        { 0x9105, 0x7943 },
        { 0x9103, 0x7944 },
        { 0x9161, 0x7945 },
        { 0x9164, 0x7946 },
        { 0x915F, 0x7947 },
        { 0x9162, 0x7948 },
        { 0x9160, 0x7949 },
        { 0x9201, 0x794A },
        { 0x920A, 0x794B },
        { 0x9225, 0x794C },
        { 0x9203, 0x794D },
        { 0x921A, 0x794E },
        { 0x9226, 0x794F },
        { 0x920F, 0x7950 },
        { 0x920C, 0x7951 },
        { 0x9200, 0x7952 },
        { 0x9212, 0x7953 },
        { 0x91FF, 0x7954 },
        { 0x91FD, 0x7955 },
        { 0x9206, 0x7956 },
        { 0x9204, 0x7957 },
        { 0x9227, 0x7958 },
        { 0x9202, 0x7959 },
        { 0x921C, 0x795A },
        { 0x9224, 0x795B },
        { 0x9219, 0x795C },
        { 0x9217, 0x795D },
        { 0x9205, 0x795E },
        { 0x9216, 0x795F },
        { 0x957B, 0x7960 },
        { 0x958D, 0x7961 },
        { 0x958C, 0x7962 },
        { 0x9590, 0x7963 },
        { 0x9687, 0x7964 },
        { 0x967E, 0x7965 },
        { 0x9688, 0x7966 },
        { 0x9689, 0x7967 },
        { 0x9683, 0x7968 },
        { 0x9680, 0x7969 },
        { 0x96C2, 0x796A },
        { 0x96C8, 0x796B },
        { 0x96C3, 0x796C },
        { 0x96F1, 0x796D },
        { 0x96F0, 0x796E },
        { 0x976C, 0x796F },
        { 0x9770, 0x7970 },
        { 0x976E, 0x7971 },
        { 0x9807, 0x7972 },
        { 0x98A9, 0x7973 },
        { 0x98EB, 0x7974 },
        { 0x9CE6, 0x7975 },
        { 0x9EF9, 0x7976 },
        { 0x4E83, 0x7977 },
        { 0x4E84, 0x7978 },
        { 0x4EB6, 0x7979 },
        { 0x50BD, 0x797A },
        { 0x50BF, 0x797B },
        { 0x50C6, 0x797C },
        { 0x50AE, 0x797D },
        { 0x50C4, 0x797E },
        { 0x50CA, 0x797F },
        { 0x50B4, 0x7981 },
        { 0x50C8, 0x7982 },
        { 0x50C2, 0x7983 },
        { 0x50B0, 0x7984 },
        { 0x50C1, 0x7985 },
        { 0x50BA, 0x7986 },
        { 0x50B1, 0x7987 },
        { 0x50CB, 0x7988 },
        { 0x50C9, 0x7989 },
        { 0x50B6, 0x798A },
        { 0x50B8, 0x798B },
        { 0x51D7, 0x798C },
        { 0x527A, 0x798D },
        { 0x5278, 0x798E },
        { 0x527B, 0x798F },
        { 0x527C, 0x7990 },
        { 0x55C3, 0x7991 },
        { 0x55DB, 0x7992 },
        { 0x55CC, 0x7993 },
        { 0x55D0, 0x7994 },
        { 0x55CB, 0x7995 },
        { 0x55CA, 0x7996 },
        { 0x55DD, 0x7997 },
        { 0x55C0, 0x7998 },
        { 0x55D4, 0x7999 },
        { 0x55C4, 0x799A },
        { 0x55E9, 0x799B },
        { 0x55BF, 0x799C },
        { 0x55D2, 0x799D },
        { 0x558D, 0x799E },
        { 0x55CF, 0x799F },
        { 0x55D5, 0x79A0 },
        { 0x55E2, 0x79A1 },
        { 0x55D6, 0x79A2 },
        { 0x55C8, 0x79A3 },
        { 0x55F2, 0x79A4 },
        { 0x55CD, 0x79A5 },
        { 0x55D9, 0x79A6 },
        { 0x55C2, 0x79A7 },
        { 0x5714, 0x79A8 },
        { 0x5853, 0x79A9 },
        { 0x5868, 0x79AA },
        { 0x5864, 0x79AB },
        { 0x584F, 0x79AC },
        { 0x584D, 0x79AD },
        { 0x5849, 0x79AE },
        { 0x586F, 0x79AF },
        { 0x5855, 0x79B0 },
        { 0x584E, 0x79B1 },
        { 0x585D, 0x79B2 },
        { 0x5859, 0x79B3 },
        { 0x5865, 0x79B4 },
        { 0x585B, 0x79B5 },
        { 0x583D, 0x79B6 },
        { 0x5863, 0x79B7 },
        { 0x5871, 0x79B8 },
        { 0x58FC, 0x79B9 },
        { 0x5AC7, 0x79BA },
        { 0x5AC4, 0x79BB },
        { 0x5ACB, 0x79BC },
        { 0x5ABA, 0x79BD },
        { 0x5AB8, 0x79BE },
        { 0x5AB1, 0x79BF },
        { 0x5AB5, 0x79C0 },
        { 0x5AB0, 0x79C1 },
        { 0x5ABF, 0x79C2 },
        { 0x5AC8, 0x79C3 },
        { 0x5ABB, 0x79C4 },
        { 0x5AC6, 0x79C5 },
        { 0x5AB7, 0x79C6 },
        { 0x5AC0, 0x79C7 },
        { 0x5ACA, 0x79C8 },
        { 0x5AB4, 0x79C9 },
        { 0x5AB6, 0x79CA },
        { 0x5ACD, 0x79CB },
        { 0x5AB9, 0x79CC },
        { 0x5A90, 0x79CD },
        { 0x5BD6, 0x79CE },
        { 0x5BD8, 0x79CF },
        { 0x5BD9, 0x79D0 },
        { 0x5C1F, 0x79D1 },
        { 0x5C33, 0x79D2 },
        { 0x5D71, 0x79D3 },
        { 0x5D63, 0x79D4 },
        { 0x5D4A, 0x79D5 },
        { 0x5D65, 0x79D6 },
        { 0x5D72, 0x79D7 },
        { 0x5D6C, 0x79D8 },
        { 0x5D5E, 0x79D9 },
        { 0x5D68, 0x79DA },
        { 0x5D67, 0x79DB },
        { 0x5D62, 0x79DC },
        { 0x5DF0, 0x79DD },
        { 0x5E4F, 0x79DE },
        { 0x5E4E, 0x79DF },
        { 0x5E4A, 0x79E0 },
        { 0x5E4D, 0x79E1 },
        { 0x5E4B, 0x79E2 },
        { 0x5EC5, 0x79E3 },
        { 0x5ECC, 0x79E4 },
        { 0x5EC6, 0x79E5 },
        { 0x5ECB, 0x79E6 },
        { 0x5EC7, 0x79E7 },
        { 0x5F40, 0x79E8 },
        { 0x5FAF, 0x79E9 },
        { 0x5FAD, 0x79EA },
        { 0x60F7, 0x79EB },
        { 0x6149, 0x79EC },
        { 0x614A, 0x79ED },
        { 0x612B, 0x79EE },
        { 0x6145, 0x79EF },
        { 0x6136, 0x79F0 },
        { 0x6132, 0x79F1 },
        { 0x612E, 0x79F2 },
        { 0x6146, 0x79F3 },
        { 0x612F, 0x79F4 },
        { 0x614F, 0x79F5 },
        { 0x6129, 0x79F6 },
        { 0x6140, 0x79F7 },
        { 0x6220, 0x79F8 },
        { 0x9168, 0x79F9 },
        { 0x6223, 0x79FA },
        { 0x6225, 0x79FB },
        { 0x6224, 0x79FC },
        { 0x63C5, 0x79FD },
        { 0x63F1, 0x7A41 },
        { 0x63EB, 0x7A42 },
        { 0x6410, 0x7A43 },
        { 0x6412, 0x7A44 },
        { 0x6409, 0x7A45 },
        { 0x6420, 0x7A46 },
        { 0x6424, 0x7A47 },
        { 0x6433, 0x7A48 },
        { 0x6443, 0x7A49 },
        { 0x641F, 0x7A4A },
        { 0x6415, 0x7A4B },
        { 0x6418, 0x7A4C },
        { 0x6439, 0x7A4D },
        { 0x6437, 0x7A4E },
        { 0x6422, 0x7A4F },
        { 0x6423, 0x7A50 },
        { 0x640C, 0x7A51 },
        { 0x6426, 0x7A52 },
        { 0x6430, 0x7A53 },
        { 0x6428, 0x7A54 },
        { 0x6441, 0x7A55 },
        { 0x6435, 0x7A56 },
        { 0x642F, 0x7A57 },
        { 0x640A, 0x7A58 },
        { 0x641A, 0x7A59 },
        { 0x6440, 0x7A5A },
        { 0x6425, 0x7A5B },
        { 0x6427, 0x7A5C },
        { 0x640B, 0x7A5D },
        { 0x63E7, 0x7A5E },
        { 0x641B, 0x7A5F },
        { 0x642E, 0x7A60 },
        { 0x6421, 0x7A61 },
        { 0x640E, 0x7A62 },
        { 0x656F, 0x7A63 },
        { 0x6592, 0x7A64 },
        { 0x65D3, 0x7A65 },
        { 0x6686, 0x7A66 },
        { 0x668C, 0x7A67 },
        { 0x6695, 0x7A68 },
        { 0x6690, 0x7A69 },
        { 0x668B, 0x7A6A },
        { 0x668A, 0x7A6B },
        { 0x6699, 0x7A6C },
        { 0x6694, 0x7A6D },
        { 0x6678, 0x7A6E },
        { 0x6720, 0x7A6F },
        { 0x6966, 0x7A70 },
        { 0x695F, 0x7A71 },
        { 0x6938, 0x7A72 },
        { 0x694E, 0x7A73 },
        { 0x6962, 0x7A74 },
        { 0x6971, 0x7A75 },
        { 0x693F, 0x7A76 },
        { 0x6945, 0x7A77 },
        { 0x696A, 0x7A78 },
        { 0x6939, 0x7A79 },
        { 0x6942, 0x7A7A },
        { 0x6957, 0x7A7B },
        { 0x6959, 0x7A7C },
        { 0x697A, 0x7A7D },
        { 0x6948, 0x7A7E },
        { 0x6949, 0x7A7F },
        { 0x6935, 0x7A81 },
        { 0x696C, 0x7A82 },
        { 0x6933, 0x7A83 },
        { 0x693D, 0x7A84 },
        { 0x6965, 0x7A85 },
        { 0x68F0, 0x7A86 },
        { 0x6978, 0x7A87 },
        { 0x6934, 0x7A88 },
        { 0x6969, 0x7A89 },
        { 0x6940, 0x7A8A },
        { 0x696F, 0x7A8B },
        { 0x6944, 0x7A8C },
        { 0x6976, 0x7A8D },
        { 0x6958, 0x7A8E },
        { 0x6941, 0x7A8F },
        { 0x6974, 0x7A90 },
        { 0x694C, 0x7A91 },
        { 0x693B, 0x7A92 },
        { 0x694B, 0x7A93 },
        { 0x6937, 0x7A94 },
        { 0x695C, 0x7A95 },
        { 0x694F, 0x7A96 },
        { 0x6951, 0x7A97 },
        { 0x6932, 0x7A98 },
        { 0x6952, 0x7A99 },
        { 0x692F, 0x7A9A },
        { 0x697B, 0x7A9B },
        { 0x693C, 0x7A9C },
        { 0x6B46, 0x7A9D },
        { 0x6B45, 0x7A9E },
        { 0x6B43, 0x7A9F },
        { 0x6B42, 0x7AA0 },
        { 0x6B48, 0x7AA1 },
        { 0x6B41, 0x7AA2 },
        { 0x6B9B, 0x7AA3 },
        { 0xFA0D, 0x7AA4 },
        { 0x6BFB, 0x7AA5 },
        { 0x6BFC, 0x7AA6 },
        { 0x6BF9, 0x7AA7 },
        { 0x6BF7, 0x7AA8 },
        { 0x6BF8, 0x7AA9 },
        { 0x6E9B, 0x7AAA },
        { 0x6ED6, 0x7AAB },
        { 0x6EC8, 0x7AAC },
        { 0x6E8F, 0x7AAD },
        { 0x6EC0, 0x7AAE },
        { 0x6E9F, 0x7AAF },
        { 0x6E93, 0x7AB0 },
        { 0x6E94, 0x7AB1 },
        { 0x6EA0, 0x7AB2 },
        { 0x6EB1, 0x7AB3 },
        { 0x6EB8, 0x7AB4 },
        { 0x6EC6, 0x7AB5 },
        { 0x6ED2, 0x7AB6 },
        { 0x6EBD, 0x7AB7 },
        { 0x6EC1, 0x7AB8 },
        { 0x6E9E, 0x7AB9 },
        { 0x6EC9, 0x7ABA },
        { 0x6EB7, 0x7ABB },
        { 0x6EB0, 0x7ABC },
        { 0x6ECD, 0x7ABD },
        { 0x6EA6, 0x7ABE },
        { 0x6ECF, 0x7ABF },
        { 0x6EB2, 0x7AC0 },
        { 0x6EBE, 0x7AC1 },
        { 0x6EC3, 0x7AC2 },
        { 0x6EDC, 0x7AC3 },
        { 0x6ED8, 0x7AC4 },
        { 0x6E99, 0x7AC5 },
        { 0x6E92, 0x7AC6 },
        { 0x6E8E, 0x7AC7 },
        { 0x6E8D, 0x7AC8 },
        { 0x6EA4, 0x7AC9 },
        { 0x6EA1, 0x7ACA },
        { 0x6EBF, 0x7ACB },
        { 0x6EB3, 0x7ACC },
        { 0x6ED0, 0x7ACD },
        { 0x6ECA, 0x7ACE },
        { 0x6E97, 0x7ACF },
        { 0x6EAE, 0x7AD0 },
        { 0x6EA3, 0x7AD1 },
        { 0x7147, 0x7AD2 },
        { 0x7154, 0x7AD3 },
        { 0x7152, 0x7AD4 },
        { 0x7163, 0x7AD5 },
        { 0x7160, 0x7AD6 },
        { 0x7141, 0x7AD7 },
        { 0x715D, 0x7AD8 },
        { 0x7162, 0x7AD9 },
        { 0x7172, 0x7ADA },
        { 0x7178, 0x7ADB },
        { 0x716A, 0x7ADC },
        { 0x7161, 0x7ADD },
        { 0x7142, 0x7ADE },
        { 0x7158, 0x7ADF },
        { 0x7143, 0x7AE0 },
        { 0x714B, 0x7AE1 },
        { 0x7170, 0x7AE2 },
        { 0x715F, 0x7AE3 },
        { 0x7150, 0x7AE4 },
        { 0x7153, 0x7AE5 },
        { 0x7144, 0x7AE6 },
        { 0x714D, 0x7AE7 },
        { 0x715A, 0x7AE8 },
        { 0x724F, 0x7AE9 },
        { 0x728D, 0x7AEA },
        { 0x728C, 0x7AEB },
        { 0x7291, 0x7AEC },
        { 0x7290, 0x7AED },
        { 0x728E, 0x7AEE },
        { 0x733C, 0x7AEF },
        { 0x7342, 0x7AF0 },
        { 0x733B, 0x7AF1 },
        { 0x733A, 0x7AF2 },
        { 0x7340, 0x7AF3 },
        { 0x734A, 0x7AF4 },
        { 0x7349, 0x7AF5 },
        { 0x7444, 0x7AF6 },
        { 0x744A, 0x7AF7 },
        { 0x744B, 0x7AF8 },
        { 0x7452, 0x7AF9 },
        { 0x7451, 0x7AFA },
        { 0x7457, 0x7AFB },
        { 0x7440, 0x7AFC },
        { 0x744F, 0x7AFD },
        { 0x7450, 0x7B41 },
        { 0x744E, 0x7B42 },
        { 0x7442, 0x7B43 },
        { 0x7446, 0x7B44 },
        { 0x744D, 0x7B45 },
        { 0x7454, 0x7B46 },
        { 0x74E1, 0x7B47 },
        { 0x74FF, 0x7B48 },
        { 0x74FE, 0x7B49 },
        { 0x74FD, 0x7B4A },
        { 0x751D, 0x7B4B },
        { 0x7579, 0x7B4C },
        { 0x7577, 0x7B4D },
        { 0x6983, 0x7B4E },
        { 0x75EF, 0x7B4F },
        { 0x760F, 0x7B50 },
        { 0x7603, 0x7B51 },
        { 0x75F7, 0x7B52 },
        { 0x75FE, 0x7B53 },
        { 0x75FC, 0x7B54 },
        { 0x75F9, 0x7B55 },
        { 0x75F8, 0x7B56 },
        { 0x7610, 0x7B57 },
        { 0x75FB, 0x7B58 },
        { 0x75F6, 0x7B59 },
        { 0x75ED, 0x7B5A },
        { 0x75F5, 0x7B5B },
        { 0x75FD, 0x7B5C },
        { 0x7699, 0x7B5D },
        { 0x76B5, 0x7B5E },
        { 0x76DD, 0x7B5F },
        { 0x7755, 0x7B60 },
        { 0x775F, 0x7B61 },
        { 0x7760, 0x7B62 },
        { 0x7752, 0x7B63 },
        { 0x7756, 0x7B64 },
        { 0x775A, 0x7B65 },
        { 0x7769, 0x7B66 },
        { 0x7767, 0x7B67 },
        { 0x7754, 0x7B68 },
        { 0x7759, 0x7B69 },
        { 0x776D, 0x7B6A },
        { 0x77E0, 0x7B6B },
        { 0x7887, 0x7B6C },
        { 0x789A, 0x7B6D },
        { 0x7894, 0x7B6E },
        { 0x788F, 0x7B6F },
        { 0x7884, 0x7B70 },
        { 0x7895, 0x7B71 },
        { 0x7885, 0x7B72 },
        { 0x7886, 0x7B73 },
        { 0x78A1, 0x7B74 },
        { 0x7883, 0x7B75 },
        { 0x7879, 0x7B76 },
        { 0x7899, 0x7B77 },
        { 0x7880, 0x7B78 },
        { 0x7896, 0x7B79 },
        { 0x787B, 0x7B7A },
        { 0x797C, 0x7B7B },
        { 0x7982, 0x7B7C },
        { 0x797D, 0x7B7D },
        { 0x7979, 0x7B7E },
        { 0x7A11, 0x7B7F },
        { 0x7A18, 0x7B81 },
        { 0x7A19, 0x7B82 },
        { 0x7A12, 0x7B83 },
        { 0x7A17, 0x7B84 },
        { 0x7A15, 0x7B85 },
        { 0x7A22, 0x7B86 },
        { 0x7A13, 0x7B87 },
        { 0x7A1B, 0x7B88 },
        { 0x7A10, 0x7B89 },
        { 0x7AA3, 0x7B8A },
        { 0x7AA2, 0x7B8B },
        { 0x7A9E, 0x7B8C },
        { 0x7AEB, 0x7B8D },
        { 0x7B66, 0x7B8E },
        { 0x7B64, 0x7B8F },
        { 0x7B6D, 0x7B90 },
        { 0x7B74, 0x7B91 },
        { 0x7B69, 0x7B92 },
        { 0x7B72, 0x7B93 },
        { 0x7B65, 0x7B94 },
        { 0x7B73, 0x7B95 },
        { 0x7B71, 0x7B96 },
        { 0x7B70, 0x7B97 },
        { 0x7B61, 0x7B98 },
        { 0x7B78, 0x7B99 },
        { 0x7B76, 0x7B9A },
        { 0x7B63, 0x7B9B },
        { 0x7CB2, 0x7B9C },
        { 0x7CB4, 0x7B9D },
        { 0x7CAF, 0x7B9E },
        { 0x7D88, 0x7B9F },
        { 0x7D86, 0x7BA0 },
        { 0x7D80, 0x7BA1 },
        { 0x7D8D, 0x7BA2 },
        { 0x7D7F, 0x7BA3 },
        { 0x7D85, 0x7BA4 },
        { 0x7D7A, 0x7BA5 },
        { 0x7D8E, 0x7BA6 },
        { 0x7D7B, 0x7BA7 },
        { 0x7D83, 0x7BA8 },
        { 0x7D7C, 0x7BA9 },
        { 0x7D8C, 0x7BAA },
        { 0x7D94, 0x7BAB },
        { 0x7D84, 0x7BAC },
        { 0x7D7D, 0x7BAD },
        { 0x7D92, 0x7BAE },
        { 0x7F6D, 0x7BAF },
        { 0x7F6B, 0x7BB0 },
        { 0x7F67, 0x7BB1 },
        { 0x7F68, 0x7BB2 },
        { 0x7F6C, 0x7BB3 },
        { 0x7FA6, 0x7BB4 },
        { 0x7FA5, 0x7BB5 },
        { 0x7FA7, 0x7BB6 },
        { 0x7FDB, 0x7BB7 },
        { 0x7FDC, 0x7BB8 },
        { 0x8021, 0x7BB9 },
        { 0x8164, 0x7BBA },
        { 0x8160, 0x7BBB },
        { 0x8177, 0x7BBC },
        { 0x815C, 0x7BBD },
        { 0x8169, 0x7BBE },
        { 0x815B, 0x7BBF },
        { 0x8162, 0x7BC0 },
        { 0x8172, 0x7BC1 },
        { 0x6721, 0x7BC2 },
        { 0x815E, 0x7BC3 },
        { 0x8176, 0x7BC4 },
        { 0x8167, 0x7BC5 },
        { 0x816F, 0x7BC6 },
        { 0x8144, 0x7BC7 },
        { 0x8161, 0x7BC8 },
        { 0x821D, 0x7BC9 },
        { 0x8249, 0x7BCA },
        { 0x8244, 0x7BCB },
        { 0x8240, 0x7BCC },
        { 0x8242, 0x7BCD },
        { 0x8245, 0x7BCE },
        { 0x84F1, 0x7BCF },
        { 0x843F, 0x7BD0 },
        { 0x8456, 0x7BD1 },
        { 0x8476, 0x7BD2 },
        { 0x8479, 0x7BD3 },
        { 0x848F, 0x7BD4 },
        { 0x848D, 0x7BD5 },
        { 0x8465, 0x7BD6 },
        { 0x8451, 0x7BD7 },
        { 0x8440, 0x7BD8 },
        { 0x8486, 0x7BD9 },
        { 0x8467, 0x7BDA },
        { 0x8430, 0x7BDB },
        { 0x844D, 0x7BDC },
        { 0x847D, 0x7BDD },
        { 0x845A, 0x7BDE },
        { 0x8459, 0x7BDF },
        { 0x8474, 0x7BE0 },
        { 0x8473, 0x7BE1 },
        { 0x845D, 0x7BE2 },
        { 0x8507, 0x7BE3 },
        { 0x845E, 0x7BE4 },
        { 0x8437, 0x7BE5 },
        { 0x843A, 0x7BE6 },
        { 0x8434, 0x7BE7 },
        { 0x847A, 0x7BE8 },
        { 0x8443, 0x7BE9 },
        { 0x8478, 0x7BEA },
        { 0x8432, 0x7BEB },
        { 0x8445, 0x7BEC },
        { 0x8429, 0x7BED },
        { 0x83D9, 0x7BEE },
        { 0x844B, 0x7BEF },
        { 0x842F, 0x7BF0 },
        { 0x8442, 0x7BF1 },
        { 0x842D, 0x7BF2 },
        { 0x845F, 0x7BF3 },
        { 0x8470, 0x7BF4 },
        { 0x8439, 0x7BF5 },
        { 0x844E, 0x7BF6 },
        { 0x844C, 0x7BF7 },
        { 0x8452, 0x7BF8 },
        { 0x846F, 0x7BF9 },
        { 0x84C5, 0x7BFA },
        { 0x848E, 0x7BFB },
        { 0x843B, 0x7BFC },
        { 0x8447, 0x7BFD },
        { 0x8436, 0x7C41 },
        { 0x8433, 0x7C42 },
        { 0x8468, 0x7C43 },
        { 0x847E, 0x7C44 },
        { 0x8444, 0x7C45 },
        { 0x842B, 0x7C46 },
        { 0x8460, 0x7C47 },
        { 0x8454, 0x7C48 },
        { 0x846E, 0x7C49 },
        { 0x8450, 0x7C4A },
        { 0x870B, 0x7C4B },
        { 0x8704, 0x7C4C },
        { 0x86F7, 0x7C4D },
        { 0x870C, 0x7C4E },
        { 0x86FA, 0x7C4F },
        { 0x86D6, 0x7C50 },
        { 0x86F5, 0x7C51 },
        { 0x874D, 0x7C52 },
        { 0x86F8, 0x7C53 },
        { 0x870E, 0x7C54 },
        { 0x8709, 0x7C55 },
        { 0x8701, 0x7C56 },
        { 0x86F6, 0x7C57 },
        { 0x870D, 0x7C58 },
        { 0x8705, 0x7C59 },
        { 0x88D6, 0x7C5A },
        { 0x88CB, 0x7C5B },
        { 0x88CD, 0x7C5C },
        { 0x88CE, 0x7C5D },
        { 0x88DE, 0x7C5E },
        { 0x88DB, 0x7C5F },
        { 0x88DA, 0x7C60 },
        { 0x88CC, 0x7C61 },
        { 0x88D0, 0x7C62 },
        { 0x8985, 0x7C63 },
        { 0x899B, 0x7C64 },
        { 0x89DF, 0x7C65 },
        { 0x89E5, 0x7C66 },
        { 0x89E4, 0x7C67 },
        { 0x89E1, 0x7C68 },
        { 0x89E0, 0x7C69 },
        { 0x89E2, 0x7C6A },
        { 0x89DC, 0x7C6B },
        { 0x89E6, 0x7C6C },
        { 0x8A76, 0x7C6D },
        { 0x8A86, 0x7C6E },
        { 0x8A7F, 0x7C6F },
        { 0x8A61, 0x7C70 },
        { 0x8A3F, 0x7C71 },
        { 0x8A77, 0x7C72 },
        { 0x8A82, 0x7C73 },
        { 0x8A84, 0x7C74 },
        { 0x8A75, 0x7C75 },
        { 0x8A83, 0x7C76 },
        { 0x8A81, 0x7C77 },
        { 0x8A74, 0x7C78 },
        { 0x8A7A, 0x7C79 },
        { 0x8C3C, 0x7C7A },
        { 0x8C4B, 0x7C7B },
        { 0x8C4A, 0x7C7C },
        { 0x8C65, 0x7C7D },
        { 0x8C64, 0x7C7E },
        { 0x8C66, 0x7C7F },
        { 0x8C86, 0x7C81 },
        { 0x8C84, 0x7C82 },
        { 0x8C85, 0x7C83 },
        { 0x8CCC, 0x7C84 },
        { 0x8D68, 0x7C85 },
        { 0x8D69, 0x7C86 },
        { 0x8D91, 0x7C87 },
        { 0x8D8C, 0x7C88 },
        { 0x8D8E, 0x7C89 },
        { 0x8D8F, 0x7C8A },
        { 0x8D8D, 0x7C8B },
        { 0x8D93, 0x7C8C },
        { 0x8D94, 0x7C8D },
        { 0x8D90, 0x7C8E },
        { 0x8D92, 0x7C8F },
        { 0x8DF0, 0x7C90 },
        { 0x8DE0, 0x7C91 },
        { 0x8DEC, 0x7C92 },
        { 0x8DF1, 0x7C93 },
        { 0x8DEE, 0x7C94 },
        { 0x8DD0, 0x7C95 },
        { 0x8DE9, 0x7C96 },
        { 0x8DE3, 0x7C97 },
        { 0x8DE2, 0x7C98 },
        { 0x8DE7, 0x7C99 },
        { 0x8DF2, 0x7C9A },
        { 0x8DEB, 0x7C9B },
        { 0x8DF4, 0x7C9C },
        { 0x8F06, 0x7C9D },
        { 0x8EFF, 0x7C9E },
        { 0x8F01, 0x7C9F },
        { 0x8F00, 0x7CA0 },
        { 0x8F05, 0x7CA1 },
        { 0x8F07, 0x7CA2 },
        { 0x8F08, 0x7CA3 },
        { 0x8F02, 0x7CA4 },
        { 0x8F0B, 0x7CA5 },
        { 0x9052, 0x7CA6 },
        { 0x903F, 0x7CA7 },
        { 0x9044, 0x7CA8 },
        { 0x9049, 0x7CA9 },
        { 0x903D, 0x7CAA },
        { 0x9110, 0x7CAB },
        { 0x910D, 0x7CAC },
        { 0x910F, 0x7CAD },
        { 0x9111, 0x7CAE },
        { 0x9116, 0x7CAF },
        { 0x9114, 0x7CB0 },
        { 0x910B, 0x7CB1 },
        { 0x910E, 0x7CB2 },
        { 0x916E, 0x7CB3 },
        { 0x916F, 0x7CB4 },
        { 0x9248, 0x7CB5 },
        { 0x9252, 0x7CB6 },
        { 0x9230, 0x7CB7 },
        { 0x923A, 0x7CB8 },
        { 0x9266, 0x7CB9 },
        { 0x9233, 0x7CBA },
        { 0x9265, 0x7CBB },
        { 0x925E, 0x7CBC },
        { 0x9283, 0x7CBD },
        { 0x922E, 0x7CBE },
        { 0x924A, 0x7CBF },
        { 0x9246, 0x7CC0 },
        { 0x926D, 0x7CC1 },
        { 0x926C, 0x7CC2 },
        { 0x924F, 0x7CC3 },
        { 0x9260, 0x7CC4 },
        { 0x9267, 0x7CC5 },
        { 0x926F, 0x7CC6 },
        { 0x9236, 0x7CC7 },
        { 0x9261, 0x7CC8 },
        { 0x9270, 0x7CC9 },
        { 0x9231, 0x7CCA },
        { 0x9254, 0x7CCB },
        { 0x9263, 0x7CCC },
        { 0x9250, 0x7CCD },
        { 0x9272, 0x7CCE },
        { 0x924E, 0x7CCF },
        { 0x9253, 0x7CD0 },
        { 0x924C, 0x7CD1 },
        { 0x9256, 0x7CD2 },
        { 0x9232, 0x7CD3 },
        { 0x959F, 0x7CD4 },
        { 0x959C, 0x7CD5 },
        { 0x959E, 0x7CD6 },
        { 0x959B, 0x7CD7 },
        { 0x9692, 0x7CD8 },
        { 0x9693, 0x7CD9 },
        { 0x9691, 0x7CDA },
        { 0x9697, 0x7CDB },
        { 0x96CE, 0x7CDC },
        { 0x96FA, 0x7CDD },
        { 0x96FD, 0x7CDE },
        { 0x96F8, 0x7CDF },
        { 0x96F5, 0x7CE0 },
        { 0x9773, 0x7CE1 },
        { 0x9777, 0x7CE2 },
        { 0x9778, 0x7CE3 },
        { 0x9772, 0x7CE4 },
        { 0x980F, 0x7CE5 },
        { 0x980D, 0x7CE6 },
        { 0x980E, 0x7CE7 },
        { 0x98AC, 0x7CE8 },
        { 0x98F6, 0x7CE9 },
        { 0x98F9, 0x7CEA },
        { 0x99AF, 0x7CEB },
        { 0x99B2, 0x7CEC },
        { 0x99B0, 0x7CED },
        { 0x99B5, 0x7CEE },
        { 0x9AAD, 0x7CEF },
        { 0x9AAB, 0x7CF0 },
        { 0x9B5B, 0x7CF1 },
        { 0x9CEA, 0x7CF2 },
        { 0x9CED, 0x7CF3 },
        { 0x9CE7, 0x7CF4 },
        { 0x9E80, 0x7CF5 },
        { 0x9EFD, 0x7CF6 },
        { 0x50E6, 0x7CF7 },
        { 0x50D4, 0x7CF8 },
        { 0x50D7, 0x7CF9 },
        { 0x50E8, 0x7CFA },
        { 0x50F3, 0x7CFB },
        { 0x50DB, 0x7CFC },
        { 0x50EA, 0x7CFD },
        { 0x50DD, 0x7D41 },
        { 0x50E4, 0x7D42 },
        { 0x50D3, 0x7D43 },
        { 0x50EC, 0x7D44 },
        { 0x50F0, 0x7D45 },
        { 0x50EF, 0x7D46 },
        { 0x50E3, 0x7D47 },
        { 0x50E0, 0x7D48 },
        { 0x51D8, 0x7D49 },
        { 0x5280, 0x7D4A },
        { 0x5281, 0x7D4B },
        { 0x52E9, 0x7D4C },
        { 0x52EB, 0x7D4D },
        { 0x5330, 0x7D4E },
        { 0x53AC, 0x7D4F },
        { 0x5627, 0x7D50 },
        { 0x5615, 0x7D51 },
        { 0x560C, 0x7D52 },
        { 0x5612, 0x7D53 },
        { 0x55FC, 0x7D54 },
        { 0x560F, 0x7D55 },
        { 0x561C, 0x7D56 },
        { 0x5601, 0x7D57 },
        { 0x5613, 0x7D58 },
        { 0x5602, 0x7D59 },
        { 0x55FA, 0x7D5A },
        { 0x561D, 0x7D5B },
        { 0x5604, 0x7D5C },
        { 0x55FF, 0x7D5D },
        { 0x55F9, 0x7D5E },
        { 0x5889, 0x7D5F },
        { 0x587C, 0x7D60 },
        { 0x5890, 0x7D61 },
        { 0x5898, 0x7D62 },
        { 0x5886, 0x7D63 },
        { 0x5881, 0x7D64 },
        { 0x587F, 0x7D65 },
        { 0x5874, 0x7D66 },
        { 0x588B, 0x7D67 },
        { 0x587A, 0x7D68 },
        { 0x5887, 0x7D69 },
        { 0x5891, 0x7D6A },
        { 0x588E, 0x7D6B },
        { 0x5876, 0x7D6C },
        { 0x5882, 0x7D6D },
        { 0x5888, 0x7D6E },
        { 0x587B, 0x7D6F },
        { 0x5894, 0x7D70 },
        { 0x588F, 0x7D71 },
        { 0x58FE, 0x7D72 },
        { 0x596B, 0x7D73 },
        { 0x5ADC, 0x7D74 },
        { 0x5AEE, 0x7D75 },
        { 0x5AE5, 0x7D76 },
        { 0x5AD5, 0x7D77 },
        { 0x5AEA, 0x7D78 },
        { 0x5ADA, 0x7D79 },
        { 0x5AED, 0x7D7A },
        { 0x5AEB, 0x7D7B },
        { 0x5AF3, 0x7D7C },
        { 0x5AE2, 0x7D7D },
        { 0x5AE0, 0x7D7E },
        { 0x5ADB, 0x7D7F },
        { 0x5AEC, 0x7D81 },
        { 0x5ADE, 0x7D82 },
        { 0x5ADD, 0x7D83 },
        { 0x5AD9, 0x7D84 },
        { 0x5AE8, 0x7D85 },
        { 0x5ADF, 0x7D86 },
        { 0x5B77, 0x7D87 },
        { 0x5BE0, 0x7D88 },
        { 0x5BE3, 0x7D89 },
        { 0x5C63, 0x7D8A },
        { 0x5D82, 0x7D8B },
        { 0x5D80, 0x7D8C },
        { 0x5D7D, 0x7D8D },
        { 0x5D86, 0x7D8E },
        { 0x5D7A, 0x7D8F },
        { 0x5D81, 0x7D90 },
        { 0x5D77, 0x7D91 },
        { 0x5D8A, 0x7D92 },
        { 0x5D89, 0x7D93 },
        { 0x5D88, 0x7D94 },
        { 0x5D7E, 0x7D95 },
        { 0x5D7C, 0x7D96 },
        { 0x5D8D, 0x7D97 },
        { 0x5D79, 0x7D98 },
        { 0x5D7F, 0x7D99 },
        { 0x5E58, 0x7D9A },
        { 0x5E59, 0x7D9B },
        { 0x5E53, 0x7D9C },
        { 0x5ED8, 0x7D9D },
        { 0x5ED1, 0x7D9E },
        { 0x5ED7, 0x7D9F },
        { 0x5ECE, 0x7DA0 },
        { 0x5EDC, 0x7DA1 },
        { 0x5ED5, 0x7DA2 },
        { 0x5ED9, 0x7DA3 },
        { 0x5ED2, 0x7DA4 },
        { 0x5ED4, 0x7DA5 },
        { 0x5F44, 0x7DA6 },
        { 0x5F43, 0x7DA7 },
        { 0x5F6F, 0x7DA8 },
        { 0x5FB6, 0x7DA9 },
        { 0x612C, 0x7DAA },
        { 0x6128, 0x7DAB },
        { 0x6141, 0x7DAC },
        { 0x615E, 0x7DAD },
        { 0x6171, 0x7DAE },
        { 0x6173, 0x7DAF },
        { 0x6152, 0x7DB0 },
        { 0x6153, 0x7DB1 },
        { 0x6172, 0x7DB2 },
        { 0x616C, 0x7DB3 },
        { 0x6180, 0x7DB4 },
        { 0x6174, 0x7DB5 },
        { 0x6154, 0x7DB6 },
        { 0x617A, 0x7DB7 },
        { 0x615B, 0x7DB8 },
        { 0x6165, 0x7DB9 },
        { 0x613B, 0x7DBA },
        { 0x616A, 0x7DBB },
        { 0x6161, 0x7DBC },
        { 0x6156, 0x7DBD },
        { 0x6229, 0x7DBE },
        { 0x6227, 0x7DBF },
        { 0x622B, 0x7DC0 },
        { 0x642B, 0x7DC1 },
        { 0x644D, 0x7DC2 },
        { 0x645B, 0x7DC3 },
        { 0x645D, 0x7DC4 },
        { 0x6474, 0x7DC5 },
        { 0x6476, 0x7DC6 },
        { 0x6472, 0x7DC7 },
        { 0x6473, 0x7DC8 },
        { 0x647D, 0x7DC9 },
        { 0x6475, 0x7DCA },
        { 0x6466, 0x7DCB },
        { 0x64A6, 0x7DCC },
        { 0x644E, 0x7DCD },
        { 0x6482, 0x7DCE },
        { 0x645E, 0x7DCF },
        { 0x645C, 0x7DD0 },
        { 0x644B, 0x7DD1 },
        { 0x6453, 0x7DD2 },
        { 0x6460, 0x7DD3 },
        { 0x6450, 0x7DD4 },
        { 0x647F, 0x7DD5 },
        { 0x643F, 0x7DD6 },
        { 0x646C, 0x7DD7 },
        { 0x646B, 0x7DD8 },
        { 0x6459, 0x7DD9 },
        { 0x6465, 0x7DDA },
        { 0x6477, 0x7DDB },
        { 0x6573, 0x7DDC },
        { 0x65A0, 0x7DDD },
        { 0x66A1, 0x7DDE },
        { 0x66A0, 0x7DDF },
        { 0x669F, 0x7DE0 },
        { 0x6705, 0x7DE1 },
        { 0x6704, 0x7DE2 },
        { 0x6722, 0x7DE3 },
        { 0x69B1, 0x7DE4 },
        { 0x69B6, 0x7DE5 },
        { 0x69C9, 0x7DE6 },
        { 0x69A0, 0x7DE7 },
        { 0x69CE, 0x7DE8 },
        { 0x6996, 0x7DE9 },
        { 0x69B0, 0x7DEA },
        { 0x69AC, 0x7DEB },
        { 0x69BC, 0x7DEC },
        { 0x6991, 0x7DED },
        { 0x6999, 0x7DEE },
        { 0x698E, 0x7DEF },
        { 0x69A7, 0x7DF0 },
        { 0x698D, 0x7DF1 },
        { 0x69A9, 0x7DF2 },
        { 0x69BE, 0x7DF3 },
        { 0x69AF, 0x7DF4 },
        { 0x69BF, 0x7DF5 },
        { 0x69C4, 0x7DF6 },
        { 0x69BD, 0x7DF7 },
        { 0x69A4, 0x7DF8 },
        { 0x69D4, 0x7DF9 },
        { 0x69B9, 0x7DFA },
        { 0x69CA, 0x7DFB },
        { 0x699A, 0x7DFC },
        { 0x69CF, 0x7DFD },
        { 0x69B3, 0x7E41 },
        { 0x6993, 0x7E42 },
        { 0x69AA, 0x7E43 },
        { 0x69A1, 0x7E44 },
        { 0x699E, 0x7E45 },
        { 0x69D9, 0x7E46 },
        { 0x6997, 0x7E47 },
        { 0x6990, 0x7E48 },
        { 0x69C2, 0x7E49 },
        { 0x69B5, 0x7E4A },
        { 0x69A5, 0x7E4B },
        { 0x69C6, 0x7E4C },
        { 0x6B4A, 0x7E4D },
        { 0x6B4D, 0x7E4E },
        { 0x6B4B, 0x7E4F },
        { 0x6B9E, 0x7E50 },
        { 0x6B9F, 0x7E51 },
        { 0x6BA0, 0x7E52 },
        { 0x6BC3, 0x7E53 },
        { 0x6BC4, 0x7E54 },
        { 0x6BFE, 0x7E55 },
        { 0x6ECE, 0x7E56 },
        { 0x6EF5, 0x7E57 },
        { 0x6EF1, 0x7E58 },
        { 0x6F03, 0x7E59 },
        { 0x6F25, 0x7E5A },
        { 0x6EF8, 0x7E5B },
        { 0x6F37, 0x7E5C },
        { 0x6EFB, 0x7E5D },
        { 0x6F2E, 0x7E5E },
        { 0x6F09, 0x7E5F },
        { 0x6F4E, 0x7E60 },
        { 0x6F19, 0x7E61 },
        { 0x6F1A, 0x7E62 },
        { 0x6F27, 0x7E63 },
        { 0x6F18, 0x7E64 },
        { 0x6F3B, 0x7E65 },
        { 0x6F12, 0x7E66 },
        { 0x6EED, 0x7E67 },
        { 0x6F0A, 0x7E68 },
        { 0x6F36, 0x7E69 },
        { 0x6F73, 0x7E6A },
        { 0x6EF9, 0x7E6B },
        { 0x6EEE, 0x7E6C },
        { 0x6F2D, 0x7E6D },
        { 0x6F40, 0x7E6E },
        { 0x6F30, 0x7E6F },
        { 0x6F3C, 0x7E70 },
        { 0x6F35, 0x7E71 },
        { 0x6EEB, 0x7E72 },
        { 0x6F07, 0x7E73 },
        { 0x6F0E, 0x7E74 },
        { 0x6F43, 0x7E75 },
        { 0x6F05, 0x7E76 },
        { 0x6EFD, 0x7E77 },
        { 0x6EF6, 0x7E78 },
        { 0x6F39, 0x7E79 },
        { 0x6F1C, 0x7E7A },
        { 0x6EFC, 0x7E7B },
        { 0x6F3A, 0x7E7C },
        { 0x6F1F, 0x7E7D },
        { 0x6F0D, 0x7E7E },
        { 0x6F1E, 0x7E7F },
        { 0x6F08, 0x7E81 },
        { 0x6F21, 0x7E82 },
        { 0x7187, 0x7E83 },
        { 0x7190, 0x7E84 },
        { 0x7189, 0x7E85 },
        { 0x7180, 0x7E86 },
        { 0x7185, 0x7E87 },
        { 0x7182, 0x7E88 },
        { 0x718F, 0x7E89 },
        { 0x717B, 0x7E8A },
        { 0x7186, 0x7E8B },
        { 0x7181, 0x7E8C },
        { 0x7197, 0x7E8D },
        { 0x7244, 0x7E8E },
        { 0x7253, 0x7E8F },
        { 0x7297, 0x7E90 },
        { 0x7295, 0x7E91 },
        { 0x7293, 0x7E92 },
        { 0x7343, 0x7E93 },
        { 0x734D, 0x7E94 },
        { 0x7351, 0x7E95 },
        { 0x734C, 0x7E96 },
        { 0x7462, 0x7E97 },
        { 0x7473, 0x7E98 },
        { 0x7471, 0x7E99 },
        { 0x7475, 0x7E9A },
        { 0x7472, 0x7E9B },
        { 0x7467, 0x7E9C },
        { 0x746E, 0x7E9D },
        { 0x7500, 0x7E9E },
        { 0x7502, 0x7E9F },
        { 0x7503, 0x7EA0 },
        { 0x757D, 0x7EA1 },
        { 0x7590, 0x7EA2 },
        { 0x7616, 0x7EA3 },
        { 0x7608, 0x7EA4 },
        { 0x760C, 0x7EA5 },
        { 0x7615, 0x7EA6 },
        { 0x7611, 0x7EA7 },
        { 0x760A, 0x7EA8 },
        { 0x7614, 0x7EA9 },
        { 0x76B8, 0x7EAA },
        { 0x7781, 0x7EAB },
        { 0x777C, 0x7EAC },
        { 0x7785, 0x7EAD },
        { 0x7782, 0x7EAE },
        { 0x776E, 0x7EAF },
        { 0x7780, 0x7EB0 },
        { 0x776F, 0x7EB1 },
        { 0x777E, 0x7EB2 },
        { 0x7783, 0x7EB3 },
        { 0x78B2, 0x7EB4 },
        { 0x78AA, 0x7EB5 },
        { 0x78B4, 0x7EB6 },
        { 0x78AD, 0x7EB7 },
        { 0x78A8, 0x7EB8 },
        { 0x787E, 0x7EB9 },
        { 0x78AB, 0x7EBA },
        { 0x789E, 0x7EBB },
        { 0x78A5, 0x7EBC },
        { 0x78A0, 0x7EBD },
        { 0x78AC, 0x7EBE },
        { 0x78A2, 0x7EBF },
        { 0x78A4, 0x7EC0 },
        { 0x7998, 0x7EC1 },
        { 0x798A, 0x7EC2 },
        { 0x798B, 0x7EC3 },
        { 0x7996, 0x7EC4 },
        { 0x7995, 0x7EC5 },
        { 0x7994, 0x7EC6 },
        { 0x7993, 0x7EC7 },
        { 0x7997, 0x7EC8 },
        { 0x7988, 0x7EC9 },
        { 0x7992, 0x7ECA },
        { 0x7990, 0x7ECB },
        { 0x7A2B, 0x7ECC },
        { 0x7A4A, 0x7ECD },
        { 0x7A30, 0x7ECE },
        { 0x7A2F, 0x7ECF },
        { 0x7A28, 0x7ED0 },
        { 0x7A26, 0x7ED1 },
        { 0x7AA8, 0x7ED2 },
        { 0x7AAB, 0x7ED3 },
        { 0x7AAC, 0x7ED4 },
        { 0x7AEE, 0x7ED5 },
        { 0x7B88, 0x7ED6 },
        { 0x7B9C, 0x7ED7 },
        { 0x7B8A, 0x7ED8 },
        { 0x7B91, 0x7ED9 },
        { 0x7B90, 0x7EDA },
        { 0x7B96, 0x7EDB },
        { 0x7B8D, 0x7EDC },
        { 0x7B8C, 0x7EDD },
        { 0x7B9B, 0x7EDE },
        { 0x7B8E, 0x7EDF },
        { 0x7B85, 0x7EE0 },
        { 0x7B98, 0x7EE1 },
        { 0x5284, 0x7EE2 },
        { 0x7B99, 0x7EE3 },
        { 0x7BA4, 0x7EE4 },
        { 0x7B82, 0x7EE5 },
        { 0x7CBB, 0x7EE6 },
        { 0x7CBF, 0x7EE7 },
        { 0x7CBC, 0x7EE8 },
        { 0x7CBA, 0x7EE9 },
        { 0x7DA7, 0x7EEA },
        { 0x7DB7, 0x7EEB },
        { 0x7DC2, 0x7EEC },
        { 0x7DA3, 0x7EED },
        { 0x7DAA, 0x7EEE },
        { 0x7DC1, 0x7EEF },
        { 0x7DC0, 0x7EF0 },
        { 0x7DC5, 0x7EF1 },
        { 0x7D9D, 0x7EF2 },
        { 0x7DCE, 0x7EF3 },
        { 0x7DC4, 0x7EF4 },
        { 0x7DC6, 0x7EF5 },
        { 0x7DCB, 0x7EF6 },
        { 0x7DCC, 0x7EF7 },
        { 0x7DAF, 0x7EF8 },
        { 0x7DB9, 0x7EF9 },
        { 0x7D96, 0x7EFA },
        { 0x7DBC, 0x7EFB },
        { 0x7D9F, 0x7EFC },
        { 0x7DA6, 0x7EFD },
        { 0x7DAE, 0x7F41 },
        { 0x7DA9, 0x7F42 },
        { 0x7DA1, 0x7F43 },
        { 0x7DC9, 0x7F44 },
        { 0x7F73, 0x7F45 },
        { 0x7FE2, 0x7F46 },
        { 0x7FE3, 0x7F47 },
        { 0x7FE5, 0x7F48 },
        { 0x7FDE, 0x7F49 },
        { 0x8024, 0x7F4A },
        { 0x805D, 0x7F4B },
        { 0x805C, 0x7F4C },
        { 0x8189, 0x7F4D },
        { 0x8186, 0x7F4E },
        { 0x8183, 0x7F4F },
        { 0x8187, 0x7F50 },
        { 0x818D, 0x7F51 },
        { 0x818C, 0x7F52 },
        { 0x818B, 0x7F53 },
        { 0x8215, 0x7F54 },
        { 0x8497, 0x7F55 },
        { 0x84A4, 0x7F56 },
        { 0x84A1, 0x7F57 },
        { 0x849F, 0x7F58 },
        { 0x84BA, 0x7F59 },
        { 0x84CE, 0x7F5A },
        { 0x84C2, 0x7F5B },
        { 0x84AC, 0x7F5C },
        { 0x84AE, 0x7F5D },
        { 0x84AB, 0x7F5E },
        { 0x84B9, 0x7F5F },
        { 0x84B4, 0x7F60 },
        { 0x84C1, 0x7F61 },
        { 0x84CD, 0x7F62 },
        { 0x84AA, 0x7F63 },
        { 0x849A, 0x7F64 },
        { 0x84B1, 0x7F65 },
        { 0x84D0, 0x7F66 },
        { 0x849D, 0x7F67 },
        { 0x84A7, 0x7F68 },
        { 0x84BB, 0x7F69 },
        { 0x84A2, 0x7F6A },
        { 0x8494, 0x7F6B },
        { 0x84C7, 0x7F6C },
        { 0x84CC, 0x7F6D },
        { 0x849B, 0x7F6E },
        { 0x84A9, 0x7F6F },
        { 0x84AF, 0x7F70 },
        { 0x84A8, 0x7F71 },
        { 0x84D6, 0x7F72 },
        { 0x8498, 0x7F73 },
        { 0x84B6, 0x7F74 },
        { 0x84CF, 0x7F75 },
        { 0x84A0, 0x7F76 },
        { 0x84D7, 0x7F77 },
        { 0x84D4, 0x7F78 },
        { 0x84D2, 0x7F79 },
        { 0x84DB, 0x7F7A },
        { 0x84B0, 0x7F7B },
        { 0x8491, 0x7F7C },
        { 0x8661, 0x7F7D },
        { 0x8733, 0x7F7E },
        { 0x8723, 0x7F7F },
        { 0x8728, 0x7F81 },
        { 0x876B, 0x7F82 },
        { 0x8740, 0x7F83 },
        { 0x872E, 0x7F84 },
        { 0x871E, 0x7F85 },
        { 0x8721, 0x7F86 },
        { 0x8719, 0x7F87 },
        { 0x871B, 0x7F88 },
        { 0x8743, 0x7F89 },
        { 0x872C, 0x7F8A },
        { 0x8741, 0x7F8B },
        { 0x873E, 0x7F8C },
        { 0x8746, 0x7F8D },
        { 0x8720, 0x7F8E },
        { 0x8732, 0x7F8F },
        { 0x872A, 0x7F90 },
        { 0x872D, 0x7F91 },
        { 0x873C, 0x7F92 },
        { 0x8712, 0x7F93 },
        { 0x873A, 0x7F94 },
        { 0x8731, 0x7F95 },
        { 0x8735, 0x7F96 },
        { 0x8742, 0x7F97 },
        { 0x8726, 0x7F98 },
        { 0x8727, 0x7F99 },
        { 0x8738, 0x7F9A },
        { 0x8724, 0x7F9B },
        { 0x871A, 0x7F9C },
        { 0x8730, 0x7F9D },
        { 0x8711, 0x7F9E },
        { 0x88F7, 0x7F9F },
        { 0x88E7, 0x7FA0 },
        { 0x88F1, 0x7FA1 },
        { 0x88F2, 0x7FA2 },
        { 0x88FA, 0x7FA3 },
        { 0x88FE, 0x7FA4 },
        { 0x88EE, 0x7FA5 },
        { 0x88FC, 0x7FA6 },
        { 0x88F6, 0x7FA7 },
        { 0x88FB, 0x7FA8 },
        { 0x88F0, 0x7FA9 },
        { 0x88EC, 0x7FAA },
        { 0x88EB, 0x7FAB },
        { 0x899D, 0x7FAC },
        { 0x89A1, 0x7FAD },
        { 0x899F, 0x7FAE },
        { 0x899E, 0x7FAF },
        { 0x89E9, 0x7FB0 },
        { 0x89EB, 0x7FB1 },
        { 0x89E8, 0x7FB2 },
        { 0x8AAB, 0x7FB3 },
        { 0x8A99, 0x7FB4 },
        { 0x8A8B, 0x7FB5 },
        { 0x8A92, 0x7FB6 },
        { 0x8A8F, 0x7FB7 },
        { 0x8A96, 0x7FB8 },
        { 0x8C3D, 0x7FB9 },
        { 0x8C68, 0x7FBA },
        { 0x8C69, 0x7FBB },
        { 0x8CD5, 0x7FBC },
        { 0x8CCF, 0x7FBD },
        { 0x8CD7, 0x7FBE },
        { 0x8D96, 0x7FBF },
        { 0x8E09, 0x7FC0 },
        { 0x8E02, 0x7FC1 },
        { 0x8DFF, 0x7FC2 },
        { 0x8E0D, 0x7FC3 },
        { 0x8DFD, 0x7FC4 },
        { 0x8E0A, 0x7FC5 },
        { 0x8E03, 0x7FC6 },
        { 0x8E07, 0x7FC7 },
        { 0x8E06, 0x7FC8 },
        { 0x8E05, 0x7FC9 },
        { 0x8DFE, 0x7FCA },
        { 0x8E00, 0x7FCB },
        { 0x8E04, 0x7FCC },
        { 0x8F10, 0x7FCD },
        { 0x8F11, 0x7FCE },
        { 0x8F0E, 0x7FCF },
        { 0x8F0D, 0x7FD0 },
        { 0x9123, 0x7FD1 },
        { 0x911C, 0x7FD2 },
        { 0x9120, 0x7FD3 },
        { 0x9122, 0x7FD4 },
        { 0x911F, 0x7FD5 },
        { 0x911D, 0x7FD6 },
        { 0x911A, 0x7FD7 },
        { 0x9124, 0x7FD8 },
        { 0x9121, 0x7FD9 },
        { 0x911B, 0x7FDA },
        { 0x917A, 0x7FDB },
        { 0x9172, 0x7FDC },
        { 0x9179, 0x7FDD },
        { 0x9173, 0x7FDE },
        { 0x92A5, 0x7FDF },
        { 0x92A4, 0x7FE0 },
        { 0x9276, 0x7FE1 },
        { 0x929B, 0x7FE2 },
        { 0x927A, 0x7FE3 },
        { 0x92A0, 0x7FE4 },
        { 0x9294, 0x7FE5 },
        { 0x92AA, 0x7FE6 },
        { 0x928D, 0x7FE7 },
        { 0x92A6, 0x7FE8 },
        { 0x929A, 0x7FE9 },
        { 0x92AB, 0x7FEA },
        { 0x9279, 0x7FEB },
        { 0x9297, 0x7FEC },
        { 0x927F, 0x7FED },
        { 0x92A3, 0x7FEE },
        { 0x92EE, 0x7FEF },
        { 0x928E, 0x7FF0 },
        { 0x9282, 0x7FF1 },
        { 0x9295, 0x7FF2 },
        { 0x92A2, 0x7FF3 },
        { 0x927D, 0x7FF4 },
        { 0x9288, 0x7FF5 },
        { 0x92A1, 0x7FF6 },
        { 0x928A, 0x7FF7 },
        { 0x9286, 0x7FF8 },
        { 0x928C, 0x7FF9 },
        { 0x9299, 0x7FFA },
        { 0x92A7, 0x7FFB },
        { 0x927E, 0x7FFC },
        { 0x9287, 0x7FFD },
        { 0x92A9, 0x8041 },
        { 0x929D, 0x8042 },
        { 0x928B, 0x8043 },
        { 0x922D, 0x8044 },
        { 0x969E, 0x8045 },
        { 0x96A1, 0x8046 },
        { 0x96FF, 0x8047 },
        { 0x9758, 0x8048 },
        { 0x977D, 0x8049 },
        { 0x977A, 0x804A },
        { 0x977E, 0x804B },
        { 0x9783, 0x804C },
        { 0x9780, 0x804D },
        { 0x9782, 0x804E },
        { 0x977B, 0x804F },
        { 0x9784, 0x8050 },
        { 0x9781, 0x8051 },
        { 0x977F, 0x8052 },
        { 0x97CE, 0x8053 },
        { 0x97CD, 0x8054 },
        { 0x9816, 0x8055 },
        { 0x98AD, 0x8056 },
        { 0x98AE, 0x8057 },
        { 0x9902, 0x8058 },
        { 0x9900, 0x8059 },
        { 0x9907, 0x805A },
        { 0x999D, 0x805B },
        { 0x999C, 0x805C },
        { 0x99C3, 0x805D },
        { 0x99B9, 0x805E },
        { 0x99BB, 0x805F },
        { 0x99BA, 0x8060 },
        { 0x99C2, 0x8061 },
        { 0x99BD, 0x8062 },
        { 0x99C7, 0x8063 },
        { 0x9AB1, 0x8064 },
        { 0x9AE3, 0x8065 },
        { 0x9AE7, 0x8066 },
        { 0x9B3E, 0x8067 },
        { 0x9B3F, 0x8068 },
        { 0x9B60, 0x8069 },
        { 0x9B61, 0x806A },
        { 0x9B5F, 0x806B },
        { 0x9CF1, 0x806C },
        { 0x9CF2, 0x806D },
        { 0x9CF5, 0x806E },
        { 0x9EA7, 0x806F },
        { 0x50FF, 0x8070 },
        { 0x5103, 0x8071 },
        { 0x5130, 0x8072 },
        { 0x50F8, 0x8073 },
        { 0x5106, 0x8074 },
        { 0x5107, 0x8075 },
        { 0x50F6, 0x8076 },
        { 0x50FE, 0x8077 },
        { 0x510B, 0x8078 },
        { 0x510C, 0x8079 },
        { 0x50FD, 0x807A },
        { 0x510A, 0x807B },
        { 0x528B, 0x807C },
        { 0x528C, 0x807D },
        { 0x52F1, 0x807E },
        { 0x52EF, 0x807F },
        { 0x5648, 0x8081 },
        { 0x5642, 0x8082 },
        { 0x564C, 0x8083 },
        { 0x5635, 0x8084 },
        { 0x5641, 0x8085 },
        { 0x564A, 0x8086 },
        { 0x5649, 0x8087 },
        { 0x5646, 0x8088 },
        { 0x5658, 0x8089 },
        { 0x565A, 0x808A },
        { 0x5640, 0x808B },
        { 0x5633, 0x808C },
        { 0x563D, 0x808D },
        { 0x562C, 0x808E },
        { 0x563E, 0x808F },
        { 0x5638, 0x8090 },
        { 0x562A, 0x8091 },
        { 0x563A, 0x8092 },
        { 0x571A, 0x8093 },
        { 0x58AB, 0x8094 },
        { 0x589D, 0x8095 },
        { 0x58B1, 0x8096 },
        { 0x58A0, 0x8097 },
        { 0x58A3, 0x8098 },
        { 0x58AF, 0x8099 },
        { 0x58AC, 0x809A },
        { 0x58A5, 0x809B },
        { 0x58A1, 0x809C },
        { 0x58FF, 0x809D },
        { 0x5AFF, 0x809E },
        { 0x5AF4, 0x809F },
        { 0x5AFD, 0x80A0 },
        { 0x5AF7, 0x80A1 },
        { 0x5AF6, 0x80A2 },
        { 0x5B03, 0x80A3 },
        { 0x5AF8, 0x80A4 },
        { 0x5B02, 0x80A5 },
        { 0x5AF9, 0x80A6 },
        { 0x5B01, 0x80A7 },
        { 0x5B07, 0x80A8 },
        { 0x5B05, 0x80A9 },
        { 0x5B0F, 0x80AA },
        { 0x5C67, 0x80AB },
        { 0x5D99, 0x80AC },
        { 0x5D97, 0x80AD },
        { 0x5D9F, 0x80AE },
        { 0x5D92, 0x80AF },
        { 0x5DA2, 0x80B0 },
        { 0x5D93, 0x80B1 },
        { 0x5D95, 0x80B2 },
        { 0x5DA0, 0x80B3 },
        { 0x5D9C, 0x80B4 },
        { 0x5DA1, 0x80B5 },
        { 0x5D9A, 0x80B6 },
        { 0x5D9E, 0x80B7 },
        { 0x5E69, 0x80B8 },
        { 0x5E5D, 0x80B9 },
        { 0x5E60, 0x80BA },
        { 0x5E5C, 0x80BB },
        { 0x7DF3, 0x80BC },
        { 0x5EDB, 0x80BD },
        { 0x5EDE, 0x80BE },
        { 0x5EE1, 0x80BF },
        { 0x5F49, 0x80C0 },
        { 0x5FB2, 0x80C1 },
        { 0x618B, 0x80C2 },
        { 0x6183, 0x80C3 },
        { 0x6179, 0x80C4 },
        { 0x61B1, 0x80C5 },
        { 0x61B0, 0x80C6 },
        { 0x61A2, 0x80C7 },
        { 0x6189, 0x80C8 },
        { 0x619B, 0x80C9 },
        { 0x6193, 0x80CA },
        { 0x61AF, 0x80CB },
        { 0x61AD, 0x80CC },
        { 0x619F, 0x80CD },
        { 0x6192, 0x80CE },
        { 0x61AA, 0x80CF },
        { 0x61A1, 0x80D0 },
        { 0x618D, 0x80D1 },
        { 0x6166, 0x80D2 },
        { 0x61B3, 0x80D3 },
        { 0x622D, 0x80D4 },
        { 0x646E, 0x80D5 },
        { 0x6470, 0x80D6 },
        { 0x6496, 0x80D7 },
        { 0x64A0, 0x80D8 },
        { 0x6485, 0x80D9 },
        { 0x6497, 0x80DA },
        { 0x649C, 0x80DB },
        { 0x648F, 0x80DC },
        { 0x648B, 0x80DD },
        { 0x648A, 0x80DE },
        { 0x648C, 0x80DF },
        { 0x64A3, 0x80E0 },
        { 0x649F, 0x80E1 },
        { 0x6468, 0x80E2 },
        { 0x64B1, 0x80E3 },
        { 0x6498, 0x80E4 },
        { 0x6576, 0x80E5 },
        { 0x657A, 0x80E6 },
        { 0x6579, 0x80E7 },
        { 0x657B, 0x80E8 },
        { 0x65B2, 0x80E9 },
        { 0x65B3, 0x80EA },
        { 0x66B5, 0x80EB },
        { 0x66B0, 0x80EC },
        { 0x66A9, 0x80ED },
        { 0x66B2, 0x80EE },
        { 0x66B7, 0x80EF },
        { 0x66AA, 0x80F0 },
        { 0x66AF, 0x80F1 },
        { 0x6A00, 0x80F2 },
        { 0x6A06, 0x80F3 },
        { 0x6A17, 0x80F4 },
        { 0x69E5, 0x80F5 },
        { 0x69F8, 0x80F6 },
        { 0x6A15, 0x80F7 },
        { 0x69F1, 0x80F8 },
        { 0x69E4, 0x80F9 },
        { 0x6A20, 0x80FA },
        { 0x69FF, 0x80FB },
        { 0x69EC, 0x80FC },
        { 0x69E2, 0x80FD },
        { 0x6A1B, 0x8141 },
        { 0x6A1D, 0x8142 },
        { 0x69FE, 0x8143 },
        { 0x6A27, 0x8144 },
        { 0x69F2, 0x8145 },
        { 0x69EE, 0x8146 },
        { 0x6A14, 0x8147 },
        { 0x69F7, 0x8148 },
        { 0x69E7, 0x8149 },
        { 0x6A40, 0x814A },
        { 0x6A08, 0x814B },
        { 0x69E6, 0x814C },
        { 0x69FB, 0x814D },
        { 0x6A0D, 0x814E },
        { 0x69FC, 0x814F },
        { 0x69EB, 0x8150 },
        { 0x6A09, 0x8151 },
        { 0x6A04, 0x8152 },
        { 0x6A18, 0x8153 },
        { 0x6A25, 0x8154 },
        { 0x6A0F, 0x8155 },
        { 0x69F6, 0x8156 },
        { 0x6A26, 0x8157 },
        { 0x6A07, 0x8158 },
        { 0x69F4, 0x8159 },
        { 0x6A16, 0x815A },
        { 0x6B51, 0x815B },
        { 0x6BA5, 0x815C },
        { 0x6BA3, 0x815D },
        { 0x6BA2, 0x815E },
        { 0x6BA6, 0x815F },
        { 0x6C01, 0x8160 },
        { 0x6C00, 0x8161 },
        { 0x6BFF, 0x8162 },
        { 0x6C02, 0x8163 },
        { 0x6F41, 0x8164 },
        { 0x6F26, 0x8165 },
        { 0x6F7E, 0x8166 },
        { 0x6F87, 0x8167 },
        { 0x6FC6, 0x8168 },
        { 0x6F92, 0x8169 },
        { 0x6F8D, 0x816A },
        { 0x6F89, 0x816B },
        { 0x6F8C, 0x816C },
        { 0x6F62, 0x816D },
        { 0x6F4F, 0x816E },
        { 0x6F85, 0x816F },
        { 0x6F5A, 0x8170 },
        { 0x6F96, 0x8171 },
        { 0x6F76, 0x8172 },
        { 0x6F6C, 0x8173 },
        { 0x6F82, 0x8174 },
        { 0x6F55, 0x8175 },
        { 0x6F72, 0x8176 },
        { 0x6F52, 0x8177 },
        { 0x6F50, 0x8178 },
        { 0x6F57, 0x8179 },
        { 0x6F94, 0x817A },
        { 0x6F93, 0x817B },
        { 0x6F5D, 0x817C },
        { 0x6F00, 0x817D },
        { 0x6F61, 0x817E },
        { 0x6F6B, 0x817F },
        { 0x6F7D, 0x8181 },
        { 0x6F67, 0x8182 },
        { 0x6F90, 0x8183 },
        { 0x6F53, 0x8184 },
        { 0x6F8B, 0x8185 },
        { 0x6F69, 0x8186 },
        { 0x6F7F, 0x8187 },
        { 0x6F95, 0x8188 },
        { 0x6F63, 0x8189 },
        { 0x6F77, 0x818A },
        { 0x6F6A, 0x818B },
        { 0x6F7B, 0x818C },
        { 0x71B2, 0x818D },
        { 0x71AF, 0x818E },
        { 0x719B, 0x818F },
        { 0x71B0, 0x8190 },
        { 0x71A0, 0x8191 },
        { 0x719A, 0x8192 },
        { 0x71A9, 0x8193 },
        { 0x71B5, 0x8194 },
        { 0x719D, 0x8195 },
        { 0x71A5, 0x8196 },
        { 0x719E, 0x8197 },
        { 0x71A4, 0x8198 },
        { 0x71A1, 0x8199 },
        { 0x71AA, 0x819A },
        { 0x719C, 0x819B },
        { 0x71A7, 0x819C },
        { 0x71B3, 0x819D },
        { 0x7298, 0x819E },
        { 0x729A, 0x819F },
        { 0x7358, 0x81A0 },
        { 0x7352, 0x81A1 },
        { 0x735E, 0x81A2 },
        { 0x735F, 0x81A3 },
        { 0x7360, 0x81A4 },
        { 0x735D, 0x81A5 },
        { 0x735B, 0x81A6 },
        { 0x7361, 0x81A7 },
        { 0x735A, 0x81A8 },
        { 0x7359, 0x81A9 },
        { 0x7362, 0x81AA },
        { 0x7487, 0x81AB },
        { 0x7489, 0x81AC },
        { 0x748A, 0x81AD },
        { 0x7486, 0x81AE },
        { 0x7481, 0x81AF },
        { 0x747D, 0x81B0 },
        { 0x7485, 0x81B1 },
        { 0x7488, 0x81B2 },
        { 0x747C, 0x81B3 },
        { 0x7479, 0x81B4 },
        { 0x7508, 0x81B5 },
        { 0x7507, 0x81B6 },
        { 0x757E, 0x81B7 },
        { 0x7625, 0x81B8 },
        { 0x761E, 0x81B9 },
        { 0x7619, 0x81BA },
        { 0x761D, 0x81BB },
        { 0x761C, 0x81BC },
        { 0x7623, 0x81BD },
        { 0x761A, 0x81BE },
        { 0x7628, 0x81BF },
        { 0x761B, 0x81C0 },
        { 0x769C, 0x81C1 },
        { 0x769D, 0x81C2 },
        { 0x769E, 0x81C3 },
        { 0x769B, 0x81C4 },
        { 0x778D, 0x81C5 },
        { 0x778F, 0x81C6 },
        { 0x7789, 0x81C7 },
        { 0x7788, 0x81C8 },
        { 0x78CD, 0x81C9 },
        { 0x78BB, 0x81CA },
        { 0x78CF, 0x81CB },
        { 0x78CC, 0x81CC },
        { 0x78D1, 0x81CD },
        { 0x78CE, 0x81CE },
        { 0x78D4, 0x81CF },
        { 0x78C8, 0x81D0 },
        { 0x78C3, 0x81D1 },
        { 0x78C4, 0x81D2 },
        { 0x78C9, 0x81D3 },
        { 0x799A, 0x81D4 },
        { 0x79A1, 0x81D5 },
        { 0x79A0, 0x81D6 },
        { 0x799C, 0x81D7 },
        { 0x79A2, 0x81D8 },
        { 0x799B, 0x81D9 },
        { 0x6B76, 0x81DA },
        { 0x7A39, 0x81DB },
        { 0x7AB2, 0x81DC },
        { 0x7AB4, 0x81DD },
        { 0x7AB3, 0x81DE },
        { 0x7BB7, 0x81DF },
        { 0x7BCB, 0x81E0 },
        { 0x7BBE, 0x81E1 },
        { 0x7BAC, 0x81E2 },
        { 0x7BCE, 0x81E3 },
        { 0x7BAF, 0x81E4 },
        { 0x7BB9, 0x81E5 },
        { 0x7BCA, 0x81E6 },
        { 0x7BB5, 0x81E7 },
        { 0x7CC5, 0x81E8 },
        { 0x7CC8, 0x81E9 },
        { 0x7CCC, 0x81EA },
        { 0x7CCB, 0x81EB },
        { 0x7DF7, 0x81EC },
        { 0x7DDB, 0x81ED },
        { 0x7DEA, 0x81EE },
        { 0x7DE7, 0x81EF },
        { 0x7DD7, 0x81F0 },
        { 0x7DE1, 0x81F1 },
        { 0x7E03, 0x81F2 },
        { 0x7DFA, 0x81F3 },
        { 0x7DE6, 0x81F4 },
        { 0x7DF6, 0x81F5 },
        { 0x7DF1, 0x81F6 },
        { 0x7DF0, 0x81F7 },
        { 0x7DEE, 0x81F8 },
        { 0x7DDF, 0x81F9 },
        { 0x7F76, 0x81FA },
        { 0x7FAC, 0x81FB },
        { 0x7FB0, 0x81FC },
        { 0x7FAD, 0x81FD },
        { 0x7FED, 0x8241 },
        { 0x7FEB, 0x8242 },
        { 0x7FEA, 0x8243 },
        { 0x7FEC, 0x8244 },
        { 0x7FE6, 0x8245 },
        { 0x7FE8, 0x8246 },
        { 0x8064, 0x8247 },
        { 0x8067, 0x8248 },
        { 0x81A3, 0x8249 },
        { 0x819F, 0x824A },
        { 0x819E, 0x824B },
        { 0x8195, 0x824C },
        { 0x81A2, 0x824D },
        { 0x8199, 0x824E },
        { 0x8197, 0x824F },
        { 0x8216, 0x8250 },
        { 0x824F, 0x8251 },
        { 0x8253, 0x8252 },
        { 0x8252, 0x8253 },
        { 0x8250, 0x8254 },
        { 0x824E, 0x8255 },
        { 0x8251, 0x8256 },
        { 0x8524, 0x8257 },
        { 0x853B, 0x8258 },
        { 0x850F, 0x8259 },
        { 0x8500, 0x825A },
        { 0x8529, 0x825B },
        { 0x850E, 0x825C },
        { 0x8509, 0x825D },
        { 0x850D, 0x825E },
        { 0x851F, 0x825F },
        { 0x850A, 0x8260 },
        { 0x8527, 0x8261 },
        { 0x851C, 0x8262 },
        { 0x84FB, 0x8263 },
        { 0x852B, 0x8264 },
        { 0x84FA, 0x8265 },
        { 0x8508, 0x8266 },
        { 0x850C, 0x8267 },
        { 0x84F4, 0x8268 },
        { 0x852A, 0x8269 },
        { 0x84F2, 0x826A },
        { 0x8515, 0x826B },
        { 0x84F7, 0x826C },
        { 0x84EB, 0x826D },
        { 0x84F3, 0x826E },
        { 0x84FC, 0x826F },
        { 0x8512, 0x8270 },
        { 0x84EA, 0x8271 },
        { 0x84E9, 0x8272 },
        { 0x8516, 0x8273 },
        { 0x84FE, 0x8274 },
        { 0x8528, 0x8275 },
        { 0x851D, 0x8276 },
        { 0x852E, 0x8277 },
        { 0x8502, 0x8278 },
        { 0x84FD, 0x8279 },
        { 0x851E, 0x827A },
        { 0x84F6, 0x827B },
        { 0x8531, 0x827C },
        { 0x8526, 0x827D },
        { 0x84E7, 0x827E },
        { 0x84E8, 0x827F },
        { 0x84F0, 0x8281 },
        { 0x84EF, 0x8282 },
        { 0x84F9, 0x8283 },
        { 0x8518, 0x8284 },
        { 0x8520, 0x8285 },
        { 0x8530, 0x8286 },
        { 0x850B, 0x8287 },
        { 0x8519, 0x8288 },
        { 0x852F, 0x8289 },
        { 0x8662, 0x828A },
        { 0x8756, 0x828B },
        { 0x8763, 0x828C },
        { 0x8764, 0x828D },
        { 0x8777, 0x828E },
        { 0x87E1, 0x828F },
        { 0x8773, 0x8290 },
        { 0x8758, 0x8291 },
        { 0x8754, 0x8292 },
        { 0x875B, 0x8293 },
        { 0x8752, 0x8294 },
        { 0x8761, 0x8295 },
        { 0x875A, 0x8296 },
        { 0x8751, 0x8297 },
        { 0x875E, 0x8298 },
        { 0x876D, 0x8299 },
        { 0x876A, 0x829A },
        { 0x8750, 0x829B },
        { 0x874E, 0x829C },
        { 0x875F, 0x829D },
        { 0x875D, 0x829E },
        { 0x876F, 0x829F },
        { 0x876C, 0x82A0 },
        { 0x877A, 0x82A1 },
        { 0x876E, 0x82A2 },
        { 0x875C, 0x82A3 },
        { 0x8765, 0x82A4 },
        { 0x874F, 0x82A5 },
        { 0x877B, 0x82A6 },
        { 0x8775, 0x82A7 },
        { 0x8762, 0x82A8 },
        { 0x8767, 0x82A9 },
        { 0x8769, 0x82AA },
        { 0x885A, 0x82AB },
        { 0x8905, 0x82AC },
        { 0x890C, 0x82AD },
        { 0x8914, 0x82AE },
        { 0x890B, 0x82AF },
        { 0x8917, 0x82B0 },
        { 0x8918, 0x82B1 },
        { 0x8919, 0x82B2 },
        { 0x8906, 0x82B3 },
        { 0x8916, 0x82B4 },
        { 0x8911, 0x82B5 },
        { 0x890E, 0x82B6 },
        { 0x8909, 0x82B7 },
        { 0x89A2, 0x82B8 },
        { 0x89A4, 0x82B9 },
        { 0x89A3, 0x82BA },
        { 0x89ED, 0x82BB },
        { 0x89F0, 0x82BC },
        { 0x89EC, 0x82BD },
        { 0x8ACF, 0x82BE },
        { 0x8AC6, 0x82BF },
        { 0x8AB8, 0x82C0 },
        { 0x8AD3, 0x82C1 },
        { 0x8AD1, 0x82C2 },
        { 0x8AD4, 0x82C3 },
        { 0x8AD5, 0x82C4 },
        { 0x8ABB, 0x82C5 },
        { 0x8AD7, 0x82C6 },
        { 0x8ABE, 0x82C7 },
        { 0x8AC0, 0x82C8 },
        { 0x8AC5, 0x82C9 },
        { 0x8AD8, 0x82CA },
        { 0x8AC3, 0x82CB },
        { 0x8ABA, 0x82CC },
        { 0x8ABD, 0x82CD },
        { 0x8AD9, 0x82CE },
        { 0x8C3E, 0x82CF },
        { 0x8C4D, 0x82D0 },
        { 0x8C8F, 0x82D1 },
        { 0x8CE5, 0x82D2 },
        { 0x8CDF, 0x82D3 },
        { 0x8CD9, 0x82D4 },
        { 0x8CE8, 0x82D5 },
        { 0x8CDA, 0x82D6 },
        { 0x8CDD, 0x82D7 },
        { 0x8CE7, 0x82D8 },
        { 0x8DA0, 0x82D9 },
        { 0x8D9C, 0x82DA },
        { 0x8DA1, 0x82DB },
        { 0x8D9B, 0x82DC },
        { 0x8E20, 0x82DD },
        { 0x8E23, 0x82DE },
        { 0x8E25, 0x82DF },
        { 0x8E24, 0x82E0 },
        { 0x8E2E, 0x82E1 },
        { 0x8E15, 0x82E2 },
        { 0x8E1B, 0x82E3 },
        { 0x8E16, 0x82E4 },
        { 0x8E11, 0x82E5 },
        { 0x8E19, 0x82E6 },
        { 0x8E26, 0x82E7 },
        { 0x8E27, 0x82E8 },
        { 0x8E14, 0x82E9 },
        { 0x8E12, 0x82EA },
        { 0x8E18, 0x82EB },
        { 0x8E13, 0x82EC },
        { 0x8E1C, 0x82ED },
        { 0x8E17, 0x82EE },
        { 0x8E1A, 0x82EF },
        { 0x8F2C, 0x82F0 },
        { 0x8F24, 0x82F1 },
        { 0x8F18, 0x82F2 },
        { 0x8F1A, 0x82F3 },
        { 0x8F20, 0x82F4 },
        { 0x8F23, 0x82F5 },
        { 0x8F16, 0x82F6 },
        { 0x8F17, 0x82F7 },
        { 0x9073, 0x82F8 },
        { 0x9070, 0x82F9 },
        { 0x906F, 0x82FA },
        { 0x9067, 0x82FB },
        { 0x906B, 0x82FC },
        { 0x912F, 0x82FD },
        { 0x912B, 0x8341 },
        { 0x9129, 0x8342 },
        { 0x912A, 0x8343 },
        { 0x9132, 0x8344 },
        { 0x9126, 0x8345 },
        { 0x912E, 0x8346 },
        { 0x9185, 0x8347 },
        { 0x9186, 0x8348 },
        { 0x918A, 0x8349 },
        { 0x9181, 0x834A },
        { 0x9182, 0x834B },
        { 0x9184, 0x834C },
        { 0x9180, 0x834D },
        { 0x92D0, 0x834E },
        { 0x92C3, 0x834F },
        { 0x92C4, 0x8350 },
        { 0x92C0, 0x8351 },
        { 0x92D9, 0x8352 },
        { 0x92B6, 0x8353 },
        { 0x92CF, 0x8354 },
        { 0x92F1, 0x8355 },
        { 0x92DF, 0x8356 },
        { 0x92D8, 0x8357 },
        { 0x92E9, 0x8358 },
        { 0x92D7, 0x8359 },
        { 0x92DD, 0x835A },
        { 0x92CC, 0x835B },
        { 0x92EF, 0x835C },
        { 0x92C2, 0x835D },
        { 0x92E8, 0x835E },
        { 0x92CA, 0x835F },
        { 0x92C8, 0x8360 },
        { 0x92CE, 0x8361 },
        { 0x92E6, 0x8362 },
        { 0x92CD, 0x8363 },
        { 0x92D5, 0x8364 },
        { 0x92C9, 0x8365 },
        { 0x92E0, 0x8366 },
        { 0x92DE, 0x8367 },
        { 0x92E7, 0x8368 },
        { 0x92D1, 0x8369 },
        { 0x92D3, 0x836A },
        { 0x92B5, 0x836B },
        { 0x92E1, 0x836C },
        { 0x92C6, 0x836D },
        { 0x92B4, 0x836E },
        { 0x957C, 0x836F },
        { 0x95AC, 0x8370 },
        { 0x95AB, 0x8371 },
        { 0x95AE, 0x8372 },
        { 0x95B0, 0x8373 },
        { 0x96A4, 0x8374 },
        { 0x96A2, 0x8375 },
        { 0x96D3, 0x8376 },
        { 0x9705, 0x8377 },
        { 0x9708, 0x8378 },
        { 0x9702, 0x8379 },
        { 0x975A, 0x837A },
        { 0x978A, 0x837B },
        { 0x978E, 0x837C },
        { 0x9788, 0x837D },
        { 0x97D0, 0x837E },
        { 0x97CF, 0x837F },
        { 0x981E, 0x8381 },
        { 0x981D, 0x8382 },
        { 0x9826, 0x8383 },
        { 0x9829, 0x8384 },
        { 0x9828, 0x8385 },
        { 0x9820, 0x8386 },
        { 0x981B, 0x8387 },
        { 0x9827, 0x8388 },
        { 0x98B2, 0x8389 },
        { 0x9908, 0x838A },
        { 0x98FA, 0x838B },
        { 0x9911, 0x838C },
        { 0x9914, 0x838D },
        { 0x9916, 0x838E },
        { 0x9917, 0x838F },
        { 0x9915, 0x8390 },
        { 0x99DC, 0x8391 },
        { 0x99CD, 0x8392 },
        { 0x99CF, 0x8393 },
        { 0x99D3, 0x8394 },
        { 0x99D4, 0x8395 },
        { 0x99CE, 0x8396 },
        { 0x99C9, 0x8397 },
        { 0x99D6, 0x8398 },
        { 0x99D8, 0x8399 },
        { 0x99CB, 0x839A },
        { 0x99D7, 0x839B },
        { 0x99CC, 0x839C },
        { 0x9AB3, 0x839D },
        { 0x9AEC, 0x839E },
        { 0x9AEB, 0x839F },
        { 0x9AF3, 0x83A0 },
        { 0x9AF2, 0x83A1 },
        { 0x9AF1, 0x83A2 },
        { 0x9B46, 0x83A3 },
        { 0x9B43, 0x83A4 },
        { 0x9B67, 0x83A5 },
        { 0x9B74, 0x83A6 },
        { 0x9B71, 0x83A7 },
        { 0x9B66, 0x83A8 },
        { 0x9B76, 0x83A9 },
        { 0x9B75, 0x83AA },
        { 0x9B70, 0x83AB },
        { 0x9B68, 0x83AC },
        { 0x9B64, 0x83AD },
        { 0x9B6C, 0x83AE },
        { 0x9CFC, 0x83AF },
        { 0x9CFA, 0x83B0 },
        { 0x9CFD, 0x83B1 },
        { 0x9CFF, 0x83B2 },
        { 0x9CF7, 0x83B3 },
        { 0x9D07, 0x83B4 },
        { 0x9D00, 0x83B5 },
        { 0x9CF9, 0x83B6 },
        { 0x9CFB, 0x83B7 },
        { 0x9D08, 0x83B8 },
        { 0x9D05, 0x83B9 },
        { 0x9D04, 0x83BA },
        { 0x9E83, 0x83BB },
        { 0x9ED3, 0x83BC },
        { 0x9F0F, 0x83BD },
        { 0x9F10, 0x83BE },
        { 0x511C, 0x83BF },
        { 0x5113, 0x83C0 },
        { 0x5117, 0x83C1 },
        { 0x511A, 0x83C2 },
        { 0x5111, 0x83C3 },
        { 0x51DE, 0x83C4 },
        { 0x5334, 0x83C5 },
        { 0x53E1, 0x83C6 },
        { 0x5670, 0x83C7 },
        { 0x5660, 0x83C8 },
        { 0x566E, 0x83C9 },
        { 0x5673, 0x83CA },
        { 0x5666, 0x83CB },
        { 0x5663, 0x83CC },
        { 0x566D, 0x83CD },
        { 0x5672, 0x83CE },
        { 0x565E, 0x83CF },
        { 0x5677, 0x83D0 },
        { 0x571C, 0x83D1 },
        { 0x571B, 0x83D2 },
        { 0x58C8, 0x83D3 },
        { 0x58BD, 0x83D4 },
        { 0x58C9, 0x83D5 },
        { 0x58BF, 0x83D6 },
        { 0x58BA, 0x83D7 },
        { 0x58C2, 0x83D8 },
        { 0x58BC, 0x83D9 },
        { 0x58C6, 0x83DA },
        { 0x5B17, 0x83DB },
        { 0x5B19, 0x83DC },
        { 0x5B1B, 0x83DD },
        { 0x5B21, 0x83DE },
        { 0x5B14, 0x83DF },
        { 0x5B13, 0x83E0 },
        { 0x5B10, 0x83E1 },
        { 0x5B16, 0x83E2 },
        { 0x5B28, 0x83E3 },
        { 0x5B1A, 0x83E4 },
        { 0x5B20, 0x83E5 },
        { 0x5B1E, 0x83E6 },
        { 0x5BEF, 0x83E7 },
        { 0x5DAC, 0x83E8 },
        { 0x5DB1, 0x83E9 },
        { 0x5DA9, 0x83EA },
        { 0x5DA7, 0x83EB },
        { 0x5DB5, 0x83EC },
        { 0x5DB0, 0x83ED },
        { 0x5DAE, 0x83EE },
        { 0x5DAA, 0x83EF },
        { 0x5DA8, 0x83F0 },
        { 0x5DB2, 0x83F1 },
        { 0x5DAD, 0x83F2 },
        { 0x5DAF, 0x83F3 },
        { 0x5DB4, 0x83F4 },
        { 0x5E67, 0x83F5 },
        { 0x5E68, 0x83F6 },
        { 0x5E66, 0x83F7 },
        { 0x5E6F, 0x83F8 },
        { 0x5EE9, 0x83F9 },
        { 0x5EE7, 0x83FA },
        { 0x5EE6, 0x83FB },
        { 0x5EE8, 0x83FC },
        { 0x5EE5, 0x83FD },
        { 0x5F4B, 0x8441 },
        { 0x5FBC, 0x8442 },
        { 0x619D, 0x8443 },
        { 0x61A8, 0x8444 },
        { 0x6196, 0x8445 },
        { 0x61C5, 0x8446 },
        { 0x61B4, 0x8447 },
        { 0x61C6, 0x8448 },
        { 0x61C1, 0x8449 },
        { 0x61CC, 0x844A },
        { 0x61BA, 0x844B },
        { 0x61BF, 0x844C },
        { 0x61B8, 0x844D },
        { 0x618C, 0x844E },
        { 0x64D7, 0x844F },
        { 0x64D6, 0x8450 },
        { 0x64D0, 0x8451 },
        { 0x64CF, 0x8452 },
        { 0x64C9, 0x8453 },
        { 0x64BD, 0x8454 },
        { 0x6489, 0x8455 },
        { 0x64C3, 0x8456 },
        { 0x64DB, 0x8457 },
        { 0x64F3, 0x8458 },
        { 0x64D9, 0x8459 },
        { 0x6533, 0x845A },
        { 0x657F, 0x845B },
        { 0x657C, 0x845C },
        { 0x65A2, 0x845D },
        { 0x66C8, 0x845E },
        { 0x66BE, 0x845F },
        { 0x66C0, 0x8460 },
        { 0x66CA, 0x8461 },
        { 0x66CB, 0x8462 },
        { 0x66CF, 0x8463 },
        { 0x66BD, 0x8464 },
        { 0x66BB, 0x8465 },
        { 0x66BA, 0x8466 },
        { 0x66CC, 0x8467 },
        { 0x6723, 0x8468 },
        { 0x6A34, 0x8469 },
        { 0x6A66, 0x846A },
        { 0x6A49, 0x846B },
        { 0x6A67, 0x846C },
        { 0x6A32, 0x846D },
        { 0x6A68, 0x846E },
        { 0x6A3E, 0x846F },
        { 0x6A5D, 0x8470 },
        { 0x6A6D, 0x8471 },
        { 0x6A76, 0x8472 },
        { 0x6A5B, 0x8473 },
        { 0x6A51, 0x8474 },
        { 0x6A28, 0x8475 },
        { 0x6A5A, 0x8476 },
        { 0x6A3B, 0x8477 },
        { 0x6A3F, 0x8478 },
        { 0x6A41, 0x8479 },
        { 0x6A6A, 0x847A },
        { 0x6A64, 0x847B },
        { 0x6A50, 0x847C },
        { 0x6A4F, 0x847D },
        { 0x6A54, 0x847E },
        { 0x6A6F, 0x847F },
        { 0x6A69, 0x8481 },
        { 0x6A60, 0x8482 },
        { 0x6A3C, 0x8483 },
        { 0x6A5E, 0x8484 },
        { 0x6A56, 0x8485 },
        { 0x6A55, 0x8486 },
        { 0x6A4D, 0x8487 },
        { 0x6A4E, 0x8488 },
        { 0x6A46, 0x8489 },
        { 0x6B55, 0x848A },
        { 0x6B54, 0x848B },
        { 0x6B56, 0x848C },
        { 0x6BA7, 0x848D },
        { 0x6BAA, 0x848E },
        { 0x6BAB, 0x848F },
        { 0x6BC8, 0x8490 },
        { 0x6BC7, 0x8491 },
        { 0x6C04, 0x8492 },
        { 0x6C03, 0x8493 },
        { 0x6C06, 0x8494 },
        { 0x6FAD, 0x8495 },
        { 0x6FCB, 0x8496 },
        { 0x6FA3, 0x8497 },
        { 0x6FC7, 0x8498 },
        { 0x6FBC, 0x8499 },
        { 0x6FCE, 0x849A },
        { 0x6FC8, 0x849B },
        { 0x6F5E, 0x849C },
        { 0x6FC4, 0x849D },
        { 0x6FBD, 0x849E },
        { 0x6F9E, 0x849F },
        { 0x6FCA, 0x84A0 },
        { 0x6FA8, 0x84A1 },
        { 0x7004, 0x84A2 },
        { 0x6FA5, 0x84A3 },
        { 0x6FAE, 0x84A4 },
        { 0x6FBA, 0x84A5 },
        { 0x6FAC, 0x84A6 },
        { 0x6FAA, 0x84A7 },
        { 0x6FCF, 0x84A8 },
        { 0x6FBF, 0x84A9 },
        { 0x6FB8, 0x84AA },
        { 0x6FA2, 0x84AB },
        { 0x6FC9, 0x84AC },
        { 0x6FAB, 0x84AD },
        { 0x6FCD, 0x84AE },
        { 0x6FAF, 0x84AF },
        { 0x6FB2, 0x84B0 },
        { 0x6FB0, 0x84B1 },
        { 0x71C5, 0x84B2 },
        { 0x71C2, 0x84B3 },
        { 0x71BF, 0x84B4 },
        { 0x71B8, 0x84B5 },
        { 0x71D6, 0x84B6 },
        { 0x71C0, 0x84B7 },
        { 0x71C1, 0x84B8 },
        { 0x71CB, 0x84B9 },
        { 0x71D4, 0x84BA },
        { 0x71CA, 0x84BB },
        { 0x71C7, 0x84BC },
        { 0x71CF, 0x84BD },
        { 0x71BD, 0x84BE },
        { 0x71D8, 0x84BF },
        { 0x71BC, 0x84C0 },
        { 0x71C6, 0x84C1 },
        { 0x71DA, 0x84C2 },
        { 0x71DB, 0x84C3 },
        { 0x729D, 0x84C4 },
        { 0x729E, 0x84C5 },
        { 0x7369, 0x84C6 },
        { 0x7366, 0x84C7 },
        { 0x7367, 0x84C8 },
        { 0x736C, 0x84C9 },
        { 0x7365, 0x84CA },
        { 0x736B, 0x84CB },
        { 0x736A, 0x84CC },
        { 0x747F, 0x84CD },
        { 0x749A, 0x84CE },
        { 0x74A0, 0x84CF },
        { 0x7494, 0x84D0 },
        { 0x7492, 0x84D1 },
        { 0x7495, 0x84D2 },
        { 0x74A1, 0x84D3 },
        { 0x750B, 0x84D4 },
        { 0x7580, 0x84D5 },
        { 0x762F, 0x84D6 },
        { 0x762D, 0x84D7 },
        { 0x7631, 0x84D8 },
        { 0x763D, 0x84D9 },
        { 0x7633, 0x84DA },
        { 0x763C, 0x84DB },
        { 0x7635, 0x84DC },
        { 0x7632, 0x84DD },
        { 0x7630, 0x84DE },
        { 0x76BB, 0x84DF },
        { 0x76E6, 0x84E0 },
        { 0x779A, 0x84E1 },
        { 0x779D, 0x84E2 },
        { 0x77A1, 0x84E3 },
        { 0x779C, 0x84E4 },
        { 0x779B, 0x84E5 },
        { 0x77A2, 0x84E6 },
        { 0x77A3, 0x84E7 },
        { 0x7795, 0x84E8 },
        { 0x7799, 0x84E9 },
        { 0x7797, 0x84EA },
        { 0x78DD, 0x84EB },
        { 0x78E9, 0x84EC },
        { 0x78E5, 0x84ED },
        { 0x78EA, 0x84EE },
        { 0x78DE, 0x84EF },
        { 0x78E3, 0x84F0 },
        { 0x78DB, 0x84F1 },
        { 0x78E1, 0x84F2 },
        { 0x78E2, 0x84F3 },
        { 0x78ED, 0x84F4 },
        { 0x78DF, 0x84F5 },
        { 0x78E0, 0x84F6 },
        { 0x79A4, 0x84F7 },
        { 0x7A44, 0x84F8 },
        { 0x7A48, 0x84F9 },
        { 0x7A47, 0x84FA },
        { 0x7AB6, 0x84FB },
        { 0x7AB8, 0x84FC },
        { 0x7AB5, 0x84FD },
        { 0x7AB1, 0x8541 },
        { 0x7AB7, 0x8542 },
        { 0x7BDE, 0x8543 },
        { 0x7BE3, 0x8544 },
        { 0x7BE7, 0x8545 },
        { 0x7BDD, 0x8546 },
        { 0x7BD5, 0x8547 },
        { 0x7BE5, 0x8548 },
        { 0x7BDA, 0x8549 },
        { 0x7BE8, 0x854A },
        { 0x7BF9, 0x854B },
        { 0x7BD4, 0x854C },
        { 0x7BEA, 0x854D },
        { 0x7BE2, 0x854E },
        { 0x7BDC, 0x854F },
        { 0x7BEB, 0x8550 },
        { 0x7BD8, 0x8551 },
        { 0x7BDF, 0x8552 },
        { 0x7CD2, 0x8553 },
        { 0x7CD4, 0x8554 },
        { 0x7CD7, 0x8555 },
        { 0x7CD0, 0x8556 },
        { 0x7CD1, 0x8557 },
        { 0x7E12, 0x8558 },
        { 0x7E21, 0x8559 },
        { 0x7E17, 0x855A },
        { 0x7E0C, 0x855B },
        { 0x7E1F, 0x855C },
        { 0x7E20, 0x855D },
        { 0x7E13, 0x855E },
        { 0x7E0E, 0x855F },
        { 0x7E1C, 0x8560 },
        { 0x7E15, 0x8561 },
        { 0x7E1A, 0x8562 },
        { 0x7E22, 0x8563 },
        { 0x7E0B, 0x8564 },
        { 0x7E0F, 0x8565 },
        { 0x7E16, 0x8566 },
        { 0x7E0D, 0x8567 },
        { 0x7E14, 0x8568 },
        { 0x7E25, 0x8569 },
        { 0x7E24, 0x856A },
        { 0x7F43, 0x856B },
        { 0x7F7B, 0x856C },
        { 0x7F7C, 0x856D },
        { 0x7F7A, 0x856E },
        { 0x7FB1, 0x856F },
        { 0x7FEF, 0x8570 },
        { 0x802A, 0x8571 },
        { 0x8029, 0x8572 },
        { 0x806C, 0x8573 },
        { 0x81B1, 0x8574 },
        { 0x81A6, 0x8575 },
        { 0x81AE, 0x8576 },
        { 0x81B9, 0x8577 },
        { 0x81B5, 0x8578 },
        { 0x81AB, 0x8579 },
        { 0x81B0, 0x857A },
        { 0x81AC, 0x857B },
        { 0x81B4, 0x857C },
        { 0x81B2, 0x857D },
        { 0x81B7, 0x857E },
        { 0x81A7, 0x857F },
        { 0x81F2, 0x8581 },
        { 0x8255, 0x8582 },
        { 0x8256, 0x8583 },
        { 0x8257, 0x8584 },
        { 0x8556, 0x8585 },
        { 0x8545, 0x8586 },
        { 0x856B, 0x8587 },
        { 0x854D, 0x8588 },
        { 0x8553, 0x8589 },
        { 0x8561, 0x858A },
        { 0x8558, 0x858B },
        { 0x8540, 0x858C },
        { 0x8546, 0x858D },
        { 0x8564, 0x858E },
        { 0x8541, 0x858F },
        { 0x8562, 0x8590 },
        { 0x8544, 0x8591 },
        { 0x8551, 0x8592 },
        { 0x8547, 0x8593 },
        { 0x8563, 0x8594 },
        { 0x853E, 0x8595 },
        { 0x855B, 0x8596 },
        { 0x8571, 0x8597 },
        { 0x854E, 0x8598 },
        { 0x856E, 0x8599 },
        { 0x8575, 0x859A },
        { 0x8555, 0x859B },
        { 0x8567, 0x859C },
        { 0x8560, 0x859D },
        { 0x858C, 0x859E },
        { 0x8566, 0x859F },
        { 0x855D, 0x85A0 },
        { 0x8554, 0x85A1 },
        { 0x8565, 0x85A2 },
        { 0x856C, 0x85A3 },
        { 0x8663, 0x85A4 },
        { 0x8665, 0x85A5 },
        { 0x8664, 0x85A6 },
        { 0x879B, 0x85A7 },
        { 0x878F, 0x85A8 },
        { 0x8797, 0x85A9 },
        { 0x8793, 0x85AA },
        { 0x8792, 0x85AB },
        { 0x8788, 0x85AC },
        { 0x8781, 0x85AD },
        { 0x8796, 0x85AE },
        { 0x8798, 0x85AF },
        { 0x8779, 0x85B0 },
        { 0x8787, 0x85B1 },
        { 0x87A3, 0x85B2 },
        { 0x8785, 0x85B3 },
        { 0x8790, 0x85B4 },
        { 0x8791, 0x85B5 },
        { 0x879D, 0x85B6 },
        { 0x8784, 0x85B7 },
        { 0x8794, 0x85B8 },
        { 0x879C, 0x85B9 },
        { 0x879A, 0x85BA },
        { 0x8789, 0x85BB },
        { 0x891E, 0x85BC },
        { 0x8926, 0x85BD },
        { 0x8930, 0x85BE },
        { 0x892D, 0x85BF },
        { 0x892E, 0x85C0 },
        { 0x8927, 0x85C1 },
        { 0x8931, 0x85C2 },
        { 0x8922, 0x85C3 },
        { 0x8929, 0x85C4 },
        { 0x8923, 0x85C5 },
        { 0x892F, 0x85C6 },
        { 0x892C, 0x85C7 },
        { 0x891F, 0x85C8 },
        { 0x89F1, 0x85C9 },
        { 0x8AE0, 0x85CA },
        { 0x8AE2, 0x85CB },
        { 0x8AF2, 0x85CC },
        { 0x8AF4, 0x85CD },
        { 0x8AF5, 0x85CE },
        { 0x8ADD, 0x85CF },
        { 0x8B14, 0x85D0 },
        { 0x8AE4, 0x85D1 },
        { 0x8ADF, 0x85D2 },
        { 0x8AF0, 0x85D3 },
        { 0x8AC8, 0x85D4 },
        { 0x8ADE, 0x85D5 },
        { 0x8AE1, 0x85D6 },
        { 0x8AE8, 0x85D7 },
        { 0x8AFF, 0x85D8 },
        { 0x8AEF, 0x85D9 },
        { 0x8AFB, 0x85DA },
        { 0x8C91, 0x85DB },
        { 0x8C92, 0x85DC },
        { 0x8C90, 0x85DD },
        { 0x8CF5, 0x85DE },
        { 0x8CEE, 0x85DF },
        { 0x8CF1, 0x85E0 },
        { 0x8CF0, 0x85E1 },
        { 0x8CF3, 0x85E2 },
        { 0x8D6C, 0x85E3 },
        { 0x8D6E, 0x85E4 },
        { 0x8DA5, 0x85E5 },
        { 0x8DA7, 0x85E6 },
        { 0x8E33, 0x85E7 },
        { 0x8E3E, 0x85E8 },
        { 0x8E38, 0x85E9 },
        { 0x8E40, 0x85EA },
        { 0x8E45, 0x85EB },
        { 0x8E36, 0x85EC },
        { 0x8E3C, 0x85ED },
        { 0x8E3D, 0x85EE },
        { 0x8E41, 0x85EF },
        { 0x8E30, 0x85F0 },
        { 0x8E3F, 0x85F1 },
        { 0x8EBD, 0x85F2 },
        { 0x8F36, 0x85F3 },
        { 0x8F2E, 0x85F4 },
        { 0x8F35, 0x85F5 },
        { 0x8F32, 0x85F6 },
        { 0x8F39, 0x85F7 },
        { 0x8F37, 0x85F8 },
        { 0x8F34, 0x85F9 },
        { 0x9076, 0x85FA },
        { 0x9079, 0x85FB },
        { 0x907B, 0x85FC },
        { 0x9086, 0x85FD },
        { 0x90FA, 0x8641 },
        { 0x9133, 0x8642 },
        { 0x9135, 0x8643 },
        { 0x9136, 0x8644 },
        { 0x9193, 0x8645 },
        { 0x9190, 0x8646 },
        { 0x9191, 0x8647 },
        { 0x918D, 0x8648 },
        { 0x918F, 0x8649 },
        { 0x9327, 0x864A },
        { 0x931E, 0x864B },
        { 0x9308, 0x864C },
        { 0x931F, 0x864D },
        { 0x9306, 0x864E },
        { 0x930F, 0x864F },
        { 0x937A, 0x8650 },
        { 0x9338, 0x8651 },
        { 0x933C, 0x8652 },
        { 0x931B, 0x8653 },
        { 0x9323, 0x8654 },
        { 0x9312, 0x8655 },
        { 0x9301, 0x8656 },
        { 0x9346, 0x8657 },
        { 0x932D, 0x8658 },
        { 0x930E, 0x8659 },
        { 0x930D, 0x865A },
        { 0x92CB, 0x865B },
        { 0x931D, 0x865C },
        { 0x92FA, 0x865D },
        { 0x9325, 0x865E },
        { 0x9313, 0x865F },
        { 0x92F9, 0x8660 },
        { 0x92F7, 0x8661 },
        { 0x9334, 0x8662 },
        { 0x9302, 0x8663 },
        { 0x9324, 0x8664 },
        { 0x92FF, 0x8665 },
        { 0x9329, 0x8666 },
        { 0x9339, 0x8667 },
        { 0x9335, 0x8668 },
        { 0x932A, 0x8669 },
        { 0x9314, 0x866A },
        { 0x930C, 0x866B },
        { 0x930B, 0x866C },
        { 0x92FE, 0x866D },
        { 0x9309, 0x866E },
        { 0x9300, 0x866F },
        { 0x92FB, 0x8670 },
        { 0x9316, 0x8671 },
        { 0x95BC, 0x8672 },
        { 0x95CD, 0x8673 },
        { 0x95BE, 0x8674 },
        { 0x95B9, 0x8675 },
        { 0x95BA, 0x8676 },
        { 0x95B6, 0x8677 },
        { 0x95BF, 0x8678 },
        { 0x95B5, 0x8679 },
        { 0x95BD, 0x867A },
        { 0x96A9, 0x867B },
        { 0x96D4, 0x867C },
        { 0x970B, 0x867D },
        { 0x9712, 0x867E },
        { 0x9710, 0x867F },
        { 0x9799, 0x8681 },
        { 0x9797, 0x8682 },
        { 0x9794, 0x8683 },
        { 0x97F0, 0x8684 },
        { 0x97F8, 0x8685 },
        { 0x9835, 0x8686 },
        { 0x982F, 0x8687 },
        { 0x9832, 0x8688 },
        { 0x9924, 0x8689 },
        { 0x991F, 0x868A },
        { 0x9927, 0x868B },
        { 0x9929, 0x868C },
        { 0x999E, 0x868D },
        { 0x99EE, 0x868E },
        { 0x99EC, 0x868F },
        { 0x99E5, 0x8690 },
        { 0x99E4, 0x8691 },
        { 0x99F0, 0x8692 },
        { 0x99E3, 0x8693 },
        { 0x99EA, 0x8694 },
        { 0x99E9, 0x8695 },
        { 0x99E7, 0x8696 },
        { 0x9AB9, 0x8697 },
        { 0x9ABF, 0x8698 },
        { 0x9AB4, 0x8699 },
        { 0x9ABB, 0x869A },
        { 0x9AF6, 0x869B },
        { 0x9AFA, 0x869C },
        { 0x9AF9, 0x869D },
        { 0x9AF7, 0x869E },
        { 0x9B33, 0x869F },
        { 0x9B80, 0x86A0 },
        { 0x9B85, 0x86A1 },
        { 0x9B87, 0x86A2 },
        { 0x9B7C, 0x86A3 },
        { 0x9B7E, 0x86A4 },
        { 0x9B7B, 0x86A5 },
        { 0x9B82, 0x86A6 },
        { 0x9B93, 0x86A7 },
        { 0x9B92, 0x86A8 },
        { 0x9B90, 0x86A9 },
        { 0x9B7A, 0x86AA },
        { 0x9B95, 0x86AB },
        { 0x9B7D, 0x86AC },
        { 0x9B88, 0x86AD },
        { 0x9D25, 0x86AE },
        { 0x9D17, 0x86AF },
        { 0x9D20, 0x86B0 },
        { 0x9D1E, 0x86B1 },
        { 0x9D14, 0x86B2 },
        { 0x9D29, 0x86B3 },
        { 0x9D1D, 0x86B4 },
        { 0x9D18, 0x86B5 },
        { 0x9D22, 0x86B6 },
        { 0x9D10, 0x86B7 },
        { 0x9D19, 0x86B8 },
        { 0x9D1F, 0x86B9 },
        { 0x9E88, 0x86BA },
        { 0x9E86, 0x86BB },
        { 0x9E87, 0x86BC },
        { 0x9EAE, 0x86BD },
        { 0x9EAD, 0x86BE },
        { 0x9ED5, 0x86BF },
        { 0x9ED6, 0x86C0 },
        { 0x9EFA, 0x86C1 },
        { 0x9F12, 0x86C2 },
        { 0x9F3D, 0x86C3 },
        { 0x5126, 0x86C4 },
        { 0x5125, 0x86C5 },
        { 0x5122, 0x86C6 },
        { 0x5124, 0x86C7 },
        { 0x5120, 0x86C8 },
        { 0x5129, 0x86C9 },
        { 0x52F4, 0x86CA },
        { 0x5693, 0x86CB },
        { 0x568C, 0x86CC },
        { 0x568D, 0x86CD },
        { 0x5686, 0x86CE },
        { 0x5684, 0x86CF },
        { 0x5683, 0x86D0 },
        { 0x567E, 0x86D1 },
        { 0x5682, 0x86D2 },
        { 0x567F, 0x86D3 },
        { 0x5681, 0x86D4 },
        { 0x58D6, 0x86D5 },
        { 0x58D4, 0x86D6 },
        { 0x58CF, 0x86D7 },
        { 0x58D2, 0x86D8 },
        { 0x5B2D, 0x86D9 },
        { 0x5B25, 0x86DA },
        { 0x5B32, 0x86DB },
        { 0x5B23, 0x86DC },
        { 0x5B2C, 0x86DD },
        { 0x5B27, 0x86DE },
        { 0x5B26, 0x86DF },
        { 0x5B2F, 0x86E0 },
        { 0x5B2E, 0x86E1 },
        { 0x5B7B, 0x86E2 },
        { 0x5BF1, 0x86E3 },
        { 0x5BF2, 0x86E4 },
        { 0x5DB7, 0x86E5 },
        { 0x5E6C, 0x86E6 },
        { 0x5E6A, 0x86E7 },
        { 0x5FBE, 0x86E8 },
        { 0x5FBB, 0x86E9 },
        { 0x61C3, 0x86EA },
        { 0x61B5, 0x86EB },
        { 0x61BC, 0x86EC },
        { 0x61E7, 0x86ED },
        { 0x61E0, 0x86EE },
        { 0x61E5, 0x86EF },
        { 0x61E4, 0x86F0 },
        { 0x61E8, 0x86F1 },
        { 0x61DE, 0x86F2 },
        { 0x64EF, 0x86F3 },
        { 0x64E9, 0x86F4 },
        { 0x64E3, 0x86F5 },
        { 0x64EB, 0x86F6 },
        { 0x64E4, 0x86F7 },
        { 0x64E8, 0x86F8 },
        { 0x6581, 0x86F9 },
        { 0x6580, 0x86FA },
        { 0x65B6, 0x86FB },
        { 0x65DA, 0x86FC },
        { 0x66D2, 0x86FD },
        { 0x6A8D, 0x8741 },
        { 0x6A96, 0x8742 },
        { 0x6A81, 0x8743 },
        { 0x6AA5, 0x8744 },
        { 0x6A89, 0x8745 },
        { 0x6A9F, 0x8746 },
        { 0x6A9B, 0x8747 },
        { 0x6AA1, 0x8748 },
        { 0x6A9E, 0x8749 },
        { 0x6A87, 0x874A },
        { 0x6A93, 0x874B },
        { 0x6A8E, 0x874C },
        { 0x6A95, 0x874D },
        { 0x6A83, 0x874E },
        { 0x6AA8, 0x874F },
        { 0x6AA4, 0x8750 },
        { 0x6A91, 0x8751 },
        { 0x6A7F, 0x8752 },
        { 0x6AA6, 0x8753 },
        { 0x6A9A, 0x8754 },
        { 0x6A85, 0x8755 },
        { 0x6A8C, 0x8756 },
        { 0x6A92, 0x8757 },
        { 0x6B5B, 0x8758 },
        { 0x6BAD, 0x8759 },
        { 0x6C09, 0x875A },
        { 0x6FCC, 0x875B },
        { 0x6FA9, 0x875C },
        { 0x6FF4, 0x875D },
        { 0x6FD4, 0x875E },
        { 0x6FE3, 0x875F },
        { 0x6FDC, 0x8760 },
        { 0x6FED, 0x8761 },
        { 0x6FE7, 0x8762 },
        { 0x6FE6, 0x8763 },
        { 0x6FDE, 0x8764 },
        { 0x6FF2, 0x8765 },
        { 0x6FDD, 0x8766 },
        { 0x6FE2, 0x8767 },
        { 0x6FE8, 0x8768 },
        { 0x71E1, 0x8769 },
        { 0x71F1, 0x876A },
        { 0x71E8, 0x876B },
        { 0x71F2, 0x876C },
        { 0x71E4, 0x876D },
        { 0x71F0, 0x876E },
        { 0x71E2, 0x876F },
        { 0x7373, 0x8770 },
        { 0x736E, 0x8771 },
        { 0x736F, 0x8772 },
        { 0x7497, 0x8773 },
        { 0x74B2, 0x8774 },
        { 0x74AB, 0x8775 },
        { 0x7490, 0x8776 },
        { 0x74AA, 0x8777 },
        { 0x74AD, 0x8778 },
        { 0x74B1, 0x8779 },
        { 0x74A5, 0x877A },
        { 0x74AF, 0x877B },
        { 0x7510, 0x877C },
        { 0x7511, 0x877D },
        { 0x7512, 0x877E },
        { 0x750F, 0x877F },
        { 0x7584, 0x8781 },
        { 0x7643, 0x8782 },
        { 0x7648, 0x8783 },
        { 0x7649, 0x8784 },
        { 0x7647, 0x8785 },
        { 0x76A4, 0x8786 },
        { 0x76E9, 0x8787 },
        { 0x77B5, 0x8788 },
        { 0x77AB, 0x8789 },
        { 0x77B2, 0x878A },
        { 0x77B7, 0x878B },
        { 0x77B6, 0x878C },
        { 0x77B4, 0x878D },
        { 0x77B1, 0x878E },
        { 0x77A8, 0x878F },
        { 0x77F0, 0x8790 },
        { 0x78F3, 0x8791 },
        { 0x78FD, 0x8792 },
        { 0x7902, 0x8793 },
        { 0x78FB, 0x8794 },
        { 0x78FC, 0x8795 },
        { 0x78F2, 0x8796 },
        { 0x7905, 0x8797 },
        { 0x78F9, 0x8798 },
        { 0x78FE, 0x8799 },
        { 0x7904, 0x879A },
        { 0x79AB, 0x879B },
        { 0x79A8, 0x879C },
        { 0x7A5C, 0x879D },
        { 0x7A5B, 0x879E },
        { 0x7A56, 0x879F },
        { 0x7A58, 0x87A0 },
        { 0x7A54, 0x87A1 },
        { 0x7A5A, 0x87A2 },
        { 0x7ABE, 0x87A3 },
        { 0x7AC0, 0x87A4 },
        { 0x7AC1, 0x87A5 },
        { 0x7C05, 0x87A6 },
        { 0x7C0F, 0x87A7 },
        { 0x7BF2, 0x87A8 },
        { 0x7C00, 0x87A9 },
        { 0x7BFF, 0x87AA },
        { 0x7BFB, 0x87AB },
        { 0x7C0E, 0x87AC },
        { 0x7BF4, 0x87AD },
        { 0x7C0B, 0x87AE },
        { 0x7BF3, 0x87AF },
        { 0x7C02, 0x87B0 },
        { 0x7C09, 0x87B1 },
        { 0x7C03, 0x87B2 },
        { 0x7C01, 0x87B3 },
        { 0x7BF8, 0x87B4 },
        { 0x7BFD, 0x87B5 },
        { 0x7C06, 0x87B6 },
        { 0x7BF0, 0x87B7 },
        { 0x7BF1, 0x87B8 },
        { 0x7C10, 0x87B9 },
        { 0x7C0A, 0x87BA },
        { 0x7CE8, 0x87BB },
        { 0x7E2D, 0x87BC },
        { 0x7E3C, 0x87BD },
        { 0x7E42, 0x87BE },
        { 0x7E33, 0x87BF },
        { 0x9848, 0x87C0 },
        { 0x7E38, 0x87C1 },
        { 0x7E2A, 0x87C2 },
        { 0x7E49, 0x87C3 },
        { 0x7E40, 0x87C4 },
        { 0x7E47, 0x87C5 },
        { 0x7E29, 0x87C6 },
        { 0x7E4C, 0x87C7 },
        { 0x7E30, 0x87C8 },
        { 0x7E3B, 0x87C9 },
        { 0x7E36, 0x87CA },
        { 0x7E44, 0x87CB },
        { 0x7E3A, 0x87CC },
        { 0x7F45, 0x87CD },
        { 0x7F7F, 0x87CE },
        { 0x7F7E, 0x87CF },
        { 0x7F7D, 0x87D0 },
        { 0x7FF4, 0x87D1 },
        { 0x7FF2, 0x87D2 },
        { 0x802C, 0x87D3 },
        { 0x81BB, 0x87D4 },
        { 0x81C4, 0x87D5 },
        { 0x81CC, 0x87D6 },
        { 0x81CA, 0x87D7 },
        { 0x81C5, 0x87D8 },
        { 0x81C7, 0x87D9 },
        { 0x81BC, 0x87DA },
        { 0x81E9, 0x87DB },
        { 0x825B, 0x87DC },
        { 0x825A, 0x87DD },
        { 0x825C, 0x87DE },
        { 0x8583, 0x87DF },
        { 0x8580, 0x87E0 },
        { 0x858F, 0x87E1 },
        { 0x85A7, 0x87E2 },
        { 0x8595, 0x87E3 },
        { 0x85A0, 0x87E4 },
        { 0x858B, 0x87E5 },
        { 0x85A3, 0x87E6 },
        { 0x857B, 0x87E7 },
        { 0x85A4, 0x87E8 },
        { 0x859A, 0x87E9 },
        { 0x859E, 0x87EA },
        { 0x8577, 0x87EB },
        { 0x857C, 0x87EC },
        { 0x8589, 0x87ED },
        { 0x85A1, 0x87EE },
        { 0x857A, 0x87EF },
        { 0x8578, 0x87F0 },
        { 0x8557, 0x87F1 },
        { 0x858E, 0x87F2 },
        { 0x8596, 0x87F3 },
        { 0x8586, 0x87F4 },
        { 0x858D, 0x87F5 },
        { 0x8599, 0x87F6 },
        { 0x859D, 0x87F7 },
        { 0x8581, 0x87F8 },
        { 0x85A2, 0x87F9 },
        { 0x8582, 0x87FA },
        { 0x8588, 0x87FB },
        { 0x8585, 0x87FC },
        { 0x8579, 0x87FD },
        { 0x8576, 0x8841 },
        { 0x8598, 0x8842 },
        { 0x8590, 0x8843 },
        { 0x859F, 0x8844 },
        { 0x8668, 0x8845 },
        { 0x87BE, 0x8846 },
        { 0x87AA, 0x8847 },
        { 0x87AD, 0x8848 },
        { 0x87C5, 0x8849 },
        { 0x87B0, 0x884A },
        { 0x87AC, 0x884B },
        { 0x87B9, 0x884C },
        { 0x87B5, 0x884D },
        { 0x87BC, 0x884E },
        { 0x87AE, 0x884F },
        { 0x87C9, 0x8850 },
        { 0x87C3, 0x8851 },
        { 0x87C2, 0x8852 },
        { 0x87CC, 0x8853 },
        { 0x87B7, 0x8854 },
        { 0x87AF, 0x8855 },
        { 0x87C4, 0x8856 },
        { 0x87CA, 0x8857 },
        { 0x87B4, 0x8858 },
        { 0x87B6, 0x8859 },
        { 0x87BF, 0x885A },
        { 0x87B8, 0x885B },
        { 0x87BD, 0x885C },
        { 0x87DE, 0x885D },
        { 0x87B2, 0x885E },
        { 0x8935, 0x885F },
        { 0x8933, 0x8860 },
        { 0x893C, 0x8861 },
        { 0x893E, 0x8862 },
        { 0x8941, 0x8863 },
        { 0x8952, 0x8864 },
        { 0x8937, 0x8865 },
        { 0x8942, 0x8866 },
        { 0x89AD, 0x8867 },
        { 0x89AF, 0x8868 },
        { 0x89AE, 0x8869 },
        { 0x89F2, 0x886A },
        { 0x89F3, 0x886B },
        { 0x8B1E, 0x886C },
        { 0x8B18, 0x886D },
        { 0x8B16, 0x886E },
        { 0x8B11, 0x886F },
        { 0x8B05, 0x8870 },
        { 0x8B0B, 0x8871 },
        { 0x8B22, 0x8872 },
        { 0x8B0F, 0x8873 },
        { 0x8B12, 0x8874 },
        { 0x8B15, 0x8875 },
        { 0x8B07, 0x8876 },
        { 0x8B0D, 0x8877 },
        { 0x8B08, 0x8878 },
        { 0x8B06, 0x8879 },
        { 0x8B1C, 0x887A },
        { 0x8B13, 0x887B },
        { 0x8B1A, 0x887C },
        { 0x8C4F, 0x887D },
        { 0x8C70, 0x887E },
        { 0x8C72, 0x887F },
        { 0x8C71, 0x8881 },
        { 0x8C6F, 0x8882 },
        { 0x8C95, 0x8883 },
        { 0x8C94, 0x8884 },
        { 0x8CF9, 0x8885 },
        { 0x8D6F, 0x8886 },
        { 0x8E4E, 0x8887 },
        { 0x8E4D, 0x8888 },
        { 0x8E53, 0x8889 },
        { 0x8E50, 0x888A },
        { 0x8E4C, 0x888B },
        { 0x8E47, 0x888C },
        { 0x8F43, 0x888D },
        { 0x8F40, 0x888E },
        { 0x9085, 0x888F },
        { 0x907E, 0x8890 },
        { 0x9138, 0x8891 },
        { 0x919A, 0x8892 },
        { 0x91A2, 0x8893 },
        { 0x919B, 0x8894 },
        { 0x9199, 0x8895 },
        { 0x919F, 0x8896 },
        { 0x91A1, 0x8897 },
        { 0x919D, 0x8898 },
        { 0x91A0, 0x8899 },
        { 0x93A1, 0x889A },
        { 0x9383, 0x889B },
        { 0x93AF, 0x889C },
        { 0x9364, 0x889D },
        { 0x9356, 0x889E },
        { 0x9347, 0x889F },
        { 0x937C, 0x88A0 },
        { 0x9358, 0x88A1 },
        { 0x935C, 0x88A2 },
        { 0x9376, 0x88A3 },
        { 0x9349, 0x88A4 },
        { 0x9350, 0x88A5 },
        { 0x9351, 0x88A6 },
        { 0x9360, 0x88A7 },
        { 0x936D, 0x88A8 },
        { 0x938F, 0x88A9 },
        { 0x934C, 0x88AA },
        { 0x936A, 0x88AB },
        { 0x9379, 0x88AC },
        { 0x9357, 0x88AD },
        { 0x9355, 0x88AE },
        { 0x9352, 0x88AF },
        { 0x934F, 0x88B0 },
        { 0x9371, 0x88B1 },
        { 0x9377, 0x88B2 },
        { 0x937B, 0x88B3 },
        { 0x9361, 0x88B4 },
        { 0x935E, 0x88B5 },
        { 0x9363, 0x88B6 },
        { 0x9367, 0x88B7 },
        { 0x9380, 0x88B8 },
        { 0x934E, 0x88B9 },
        { 0x9359, 0x88BA },
        { 0x95C7, 0x88BB },
        { 0x95C0, 0x88BC },
        { 0x95C9, 0x88BD },
        { 0x95C3, 0x88BE },
        { 0x95C5, 0x88BF },
        { 0x95B7, 0x88C0 },
        { 0x96AE, 0x88C1 },
        { 0x96B0, 0x88C2 },
        { 0x96AC, 0x88C3 },
        { 0x9720, 0x88C4 },
        { 0x971F, 0x88C5 },
        { 0x9718, 0x88C6 },
        { 0x971D, 0x88C7 },
        { 0x9719, 0x88C8 },
        { 0x979A, 0x88C9 },
        { 0x97A1, 0x88CA },
        { 0x979C, 0x88CB },
        { 0x979E, 0x88CC },
        { 0x979D, 0x88CD },
        { 0x97D5, 0x88CE },
        { 0x97D4, 0x88CF },
        { 0x97F1, 0x88D0 },
        { 0x9841, 0x88D1 },
        { 0x9844, 0x88D2 },
        { 0x984A, 0x88D3 },
        { 0x9849, 0x88D4 },
        { 0x9845, 0x88D5 },
        { 0x9843, 0x88D6 },
        { 0x9925, 0x88D7 },
        { 0x992B, 0x88D8 },
        { 0x992C, 0x88D9 },
        { 0x992A, 0x88DA },
        { 0x9933, 0x88DB },
        { 0x9932, 0x88DC },
        { 0x992F, 0x88DD },
        { 0x992D, 0x88DE },
        { 0x9931, 0x88DF },
        { 0x9930, 0x88E0 },
        { 0x9998, 0x88E1 },
        { 0x99A3, 0x88E2 },
        { 0x99A1, 0x88E3 },
        { 0x9A02, 0x88E4 },
        { 0x99FA, 0x88E5 },
        { 0x99F4, 0x88E6 },
        { 0x99F7, 0x88E7 },
        { 0x99F9, 0x88E8 },
        { 0x99F8, 0x88E9 },
        { 0x99F6, 0x88EA },
        { 0x99FB, 0x88EB },
        { 0x99FD, 0x88EC },
        { 0x99FE, 0x88ED },
        { 0x99FC, 0x88EE },
        { 0x9A03, 0x88EF },
        { 0x9ABE, 0x88F0 },
        { 0x9AFE, 0x88F1 },
        { 0x9AFD, 0x88F2 },
        { 0x9B01, 0x88F3 },
        { 0x9AFC, 0x88F4 },
        { 0x9B48, 0x88F5 },
        { 0x9B9A, 0x88F6 },
        { 0x9BA8, 0x88F7 },
        { 0x9B9E, 0x88F8 },
        { 0x9B9B, 0x88F9 },
        { 0x9BA6, 0x88FA },
        { 0x9BA1, 0x88FB },
        { 0x9BA5, 0x88FC },
        { 0x9BA4, 0x88FD },
        { 0x9B86, 0x8941 },
        { 0x9BA2, 0x8942 },
        { 0x9BA0, 0x8943 },
        { 0x9BAF, 0x8944 },
        { 0x9D33, 0x8945 },
        { 0x9D41, 0x8946 },
        { 0x9D67, 0x8947 },
        { 0x9D36, 0x8948 },
        { 0x9D2E, 0x8949 },
        { 0x9D2F, 0x894A },
        { 0x9D31, 0x894B },
        { 0x9D38, 0x894C },
        { 0x9D30, 0x894D },
        { 0x9D45, 0x894E },
        { 0x9D42, 0x894F },
        { 0x9D43, 0x8950 },
        { 0x9D3E, 0x8951 },
        { 0x9D37, 0x8952 },
        { 0x9D40, 0x8953 },
        { 0x9D3D, 0x8954 },
        { 0x7FF5, 0x8955 },
        { 0x9D2D, 0x8956 },
        { 0x9E8A, 0x8957 },
        { 0x9E89, 0x8958 },
        { 0x9E8D, 0x8959 },
        { 0x9EB0, 0x895A },
        { 0x9EC8, 0x895B },
        { 0x9EDA, 0x895C },
        { 0x9EFB, 0x895D },
        { 0x9EFF, 0x895E },
        { 0x9F24, 0x895F },
        { 0x9F23, 0x8960 },
        { 0x9F22, 0x8961 },
        { 0x9F54, 0x8962 },
        { 0x9FA0, 0x8963 },
        { 0x5131, 0x8964 },
        { 0x512D, 0x8965 },
        { 0x512E, 0x8966 },
        { 0x5698, 0x8967 },
        { 0x569C, 0x8968 },
        { 0x5697, 0x8969 },
        { 0x569A, 0x896A },
        { 0x569D, 0x896B },
        { 0x5699, 0x896C },
        { 0x5970, 0x896D },
        { 0x5B3C, 0x896E },
        { 0x5C69, 0x896F },
        { 0x5C6A, 0x8970 },
        { 0x5DC0, 0x8971 },
        { 0x5E6D, 0x8972 },
        { 0x5E6E, 0x8973 },
        { 0x61D8, 0x8974 },
        { 0x61DF, 0x8975 },
        { 0x61ED, 0x8976 },
        { 0x61EE, 0x8977 },
        { 0x61F1, 0x8978 },
        { 0x61EA, 0x8979 },
        { 0x61F0, 0x897A },
        { 0x61EB, 0x897B },
        { 0x61D6, 0x897C },
        { 0x61E9, 0x897D },
        { 0x64FF, 0x897E },
        { 0x6504, 0x897F },
        { 0x64FD, 0x8981 },
        { 0x64F8, 0x8982 },
        { 0x6501, 0x8983 },
        { 0x6503, 0x8984 },
        { 0x64FC, 0x8985 },
        { 0x6594, 0x8986 },
        { 0x65DB, 0x8987 },
        { 0x66DA, 0x8988 },
        { 0x66DB, 0x8989 },
        { 0x66D8, 0x898A },
        { 0x6AC5, 0x898B },
        { 0x6AB9, 0x898C },
        { 0x6ABD, 0x898D },
        { 0x6AE1, 0x898E },
        { 0x6AC6, 0x898F },
        { 0x6ABA, 0x8990 },
        { 0x6AB6, 0x8991 },
        { 0x6AB7, 0x8992 },
        { 0x6AC7, 0x8993 },
        { 0x6AB4, 0x8994 },
        { 0x6AAD, 0x8995 },
        { 0x6B5E, 0x8996 },
        { 0x6BC9, 0x8997 },
        { 0x6C0B, 0x8998 },
        { 0x7007, 0x8999 },
        { 0x700C, 0x899A },
        { 0x700D, 0x899B },
        { 0x7001, 0x899C },
        { 0x7005, 0x899D },
        { 0x7014, 0x899E },
        { 0x700E, 0x899F },
        { 0x6FFF, 0x89A0 },
        { 0x7000, 0x89A1 },
        { 0x6FFB, 0x89A2 },
        { 0x7026, 0x89A3 },
        { 0x6FFC, 0x89A4 },
        { 0x6FF7, 0x89A5 },
        { 0x700A, 0x89A6 },
        { 0x7201, 0x89A7 },
        { 0x71FF, 0x89A8 },
        { 0x71F9, 0x89A9 },
        { 0x7203, 0x89AA },
        { 0x71FD, 0x89AB },
        { 0x7376, 0x89AC },
        { 0x74B8, 0x89AD },
        { 0x74C0, 0x89AE },
        { 0x74B5, 0x89AF },
        { 0x74C1, 0x89B0 },
        { 0x74BE, 0x89B1 },
        { 0x74B6, 0x89B2 },
        { 0x74BB, 0x89B3 },
        { 0x74C2, 0x89B4 },
        { 0x7514, 0x89B5 },
        { 0x7513, 0x89B6 },
        { 0x765C, 0x89B7 },
        { 0x7664, 0x89B8 },
        { 0x7659, 0x89B9 },
        { 0x7650, 0x89BA },
        { 0x7653, 0x89BB },
        { 0x7657, 0x89BC },
        { 0x765A, 0x89BD },
        { 0x76A6, 0x89BE },
        { 0x76BD, 0x89BF },
        { 0x76EC, 0x89C0 },
        { 0x77C2, 0x89C1 },
        { 0x77BA, 0x89C2 },
        { 0x78FF, 0x89C3 },
        { 0x790C, 0x89C4 },
        { 0x7913, 0x89C5 },
        { 0x7914, 0x89C6 },
        { 0x7909, 0x89C7 },
        { 0x7910, 0x89C8 },
        { 0x7912, 0x89C9 },
        { 0x7911, 0x89CA },
        { 0x79AD, 0x89CB },
        { 0x79AC, 0x89CC },
        { 0x7A5F, 0x89CD },
        { 0x7C1C, 0x89CE },
        { 0x7C29, 0x89CF },
        { 0x7C19, 0x89D0 },
        { 0x7C20, 0x89D1 },
        { 0x7C1F, 0x89D2 },
        { 0x7C2D, 0x89D3 },
        { 0x7C1D, 0x89D4 },
        { 0x7C26, 0x89D5 },
        { 0x7C28, 0x89D6 },
        { 0x7C22, 0x89D7 },
        { 0x7C25, 0x89D8 },
        { 0x7C30, 0x89D9 },
        { 0x7E5C, 0x89DA },
        { 0x7E50, 0x89DB },
        { 0x7E56, 0x89DC },
        { 0x7E63, 0x89DD },
        { 0x7E58, 0x89DE },
        { 0x7E62, 0x89DF },
        { 0x7E5F, 0x89E0 },
        { 0x7E51, 0x89E1 },
        { 0x7E60, 0x89E2 },
        { 0x7E57, 0x89E3 },
        { 0x7E53, 0x89E4 },
        { 0x7FB5, 0x89E5 },
        { 0x7FB3, 0x89E6 },
        { 0x7FF7, 0x89E7 },
        { 0x7FF8, 0x89E8 },
        { 0x8075, 0x89E9 },
        { 0x81D1, 0x89EA },
        { 0x81D2, 0x89EB },
        { 0x81D0, 0x89EC },
        { 0x825F, 0x89ED },
        { 0x825E, 0x89EE },
        { 0x85B4, 0x89EF },
        { 0x85C6, 0x89F0 },
        { 0x85C0, 0x89F1 },
        { 0x85C3, 0x89F2 },
        { 0x85C2, 0x89F3 },
        { 0x85B3, 0x89F4 },
        { 0x85B5, 0x89F5 },
        { 0x85BD, 0x89F6 },
        { 0x85C7, 0x89F7 },
        { 0x85C4, 0x89F8 },
        { 0x85BF, 0x89F9 },
        { 0x85CB, 0x89FA },
        { 0x85CE, 0x89FB },
        { 0x85C8, 0x89FC },
        { 0x85C5, 0x89FD },
        { 0x85B1, 0x8A41 },
        { 0x85B6, 0x8A42 },
        { 0x85D2, 0x8A43 },
        { 0x8624, 0x8A44 },
        { 0x85B8, 0x8A45 },
        { 0x85B7, 0x8A46 },
        { 0x85BE, 0x8A47 },
        { 0x8669, 0x8A48 },
        { 0x87E7, 0x8A49 },
        { 0x87E6, 0x8A4A },
        { 0x87E2, 0x8A4B },
        { 0x87DB, 0x8A4C },
        { 0x87EB, 0x8A4D },
        { 0x87EA, 0x8A4E },
        { 0x87E5, 0x8A4F },
        { 0x87DF, 0x8A50 },
        { 0x87F3, 0x8A51 },
        { 0x87E4, 0x8A52 },
        { 0x87D4, 0x8A53 },
        { 0x87DC, 0x8A54 },
        { 0x87D3, 0x8A55 },
        { 0x87ED, 0x8A56 },
        { 0x87D8, 0x8A57 },
        { 0x87E3, 0x8A58 },
        { 0x87A4, 0x8A59 },
        { 0x87D7, 0x8A5A },
        { 0x87D9, 0x8A5B },
        { 0x8801, 0x8A5C },
        { 0x87F4, 0x8A5D },
        { 0x87E8, 0x8A5E },
        { 0x87DD, 0x8A5F },
        { 0x8953, 0x8A60 },
        { 0x894B, 0x8A61 },
        { 0x894F, 0x8A62 },
        { 0x894C, 0x8A63 },
        { 0x8946, 0x8A64 },
        { 0x8950, 0x8A65 },
        { 0x8951, 0x8A66 },
        { 0x8949, 0x8A67 },
        { 0x8B2A, 0x8A68 },
        { 0x8B27, 0x8A69 },
        { 0x8B23, 0x8A6A },
        { 0x8B33, 0x8A6B },
        { 0x8B30, 0x8A6C },
        { 0x8B35, 0x8A6D },
        { 0x8B47, 0x8A6E },
        { 0x8B2F, 0x8A6F },
        { 0x8B3C, 0x8A70 },
        { 0x8B3E, 0x8A71 },
        { 0x8B31, 0x8A72 },
        { 0x8B25, 0x8A73 },
        { 0x8B37, 0x8A74 },
        { 0x8B26, 0x8A75 },
        { 0x8B36, 0x8A76 },
        { 0x8B2E, 0x8A77 },
        { 0x8B24, 0x8A78 },
        { 0x8B3B, 0x8A79 },
        { 0x8B3D, 0x8A7A },
        { 0x8B3A, 0x8A7B },
        { 0x8C42, 0x8A7C },
        { 0x8C75, 0x8A7D },
        { 0x8C99, 0x8A7E },
        { 0x8C98, 0x8A7F },
        { 0x8C97, 0x8A81 },
        { 0x8CFE, 0x8A82 },
        { 0x8D04, 0x8A83 },
        { 0x8D02, 0x8A84 },
        { 0x8D00, 0x8A85 },
        { 0x8E5C, 0x8A86 },
        { 0x8E62, 0x8A87 },
        { 0x8E60, 0x8A88 },
        { 0x8E57, 0x8A89 },
        { 0x8E56, 0x8A8A },
        { 0x8E5E, 0x8A8B },
        { 0x8E65, 0x8A8C },
        { 0x8E67, 0x8A8D },
        { 0x8E5B, 0x8A8E },
        { 0x8E5A, 0x8A8F },
        { 0x8E61, 0x8A90 },
        { 0x8E5D, 0x8A91 },
        { 0x8E69, 0x8A92 },
        { 0x8E54, 0x8A93 },
        { 0x8F46, 0x8A94 },
        { 0x8F47, 0x8A95 },
        { 0x8F48, 0x8A96 },
        { 0x8F4B, 0x8A97 },
        { 0x9128, 0x8A98 },
        { 0x913A, 0x8A99 },
        { 0x913B, 0x8A9A },
        { 0x913E, 0x8A9B },
        { 0x91A8, 0x8A9C },
        { 0x91A5, 0x8A9D },
        { 0x91A7, 0x8A9E },
        { 0x91AF, 0x8A9F },
        { 0x91AA, 0x8AA0 },
        { 0x93B5, 0x8AA1 },
        { 0x938C, 0x8AA2 },
        { 0x9392, 0x8AA3 },
        { 0x93B7, 0x8AA4 },
        { 0x939B, 0x8AA5 },
        { 0x939D, 0x8AA6 },
        { 0x9389, 0x8AA7 },
        { 0x93A7, 0x8AA8 },
        { 0x938E, 0x8AA9 },
        { 0x93AA, 0x8AAA },
        { 0x939E, 0x8AAB },
        { 0x93A6, 0x8AAC },
        { 0x9395, 0x8AAD },
        { 0x9388, 0x8AAE },
        { 0x9399, 0x8AAF },
        { 0x939F, 0x8AB0 },
        { 0x938D, 0x8AB1 },
        { 0x93B1, 0x8AB2 },
        { 0x9391, 0x8AB3 },
        { 0x93B2, 0x8AB4 },
        { 0x93A4, 0x8AB5 },
        { 0x93A8, 0x8AB6 },
        { 0x93B4, 0x8AB7 },
        { 0x93A3, 0x8AB8 },
        { 0x93A5, 0x8AB9 },
        { 0x95D2, 0x8ABA },
        { 0x95D3, 0x8ABB },
        { 0x95D1, 0x8ABC },
        { 0x96B3, 0x8ABD },
        { 0x96D7, 0x8ABE },
        { 0x96DA, 0x8ABF },
        { 0x5DC2, 0x8AC0 },
        { 0x96DF, 0x8AC1 },
        { 0x96D8, 0x8AC2 },
        { 0x96DD, 0x8AC3 },
        { 0x9723, 0x8AC4 },
        { 0x9722, 0x8AC5 },
        { 0x9725, 0x8AC6 },
        { 0x97AC, 0x8AC7 },
        { 0x97AE, 0x8AC8 },
        { 0x97A8, 0x8AC9 },
        { 0x97AB, 0x8ACA },
        { 0x97A4, 0x8ACB },
        { 0x97AA, 0x8ACC },
        { 0x97A2, 0x8ACD },
        { 0x97A5, 0x8ACE },
        { 0x97D7, 0x8ACF },
        { 0x97D9, 0x8AD0 },
        { 0x97D6, 0x8AD1 },
        { 0x97D8, 0x8AD2 },
        { 0x97FA, 0x8AD3 },
        { 0x9850, 0x8AD4 },
        { 0x9851, 0x8AD5 },
        { 0x9852, 0x8AD6 },
        { 0x98B8, 0x8AD7 },
        { 0x9941, 0x8AD8 },
        { 0x993C, 0x8AD9 },
        { 0x993A, 0x8ADA },
        { 0x9A0F, 0x8ADB },
        { 0x9A0B, 0x8ADC },
        { 0x9A09, 0x8ADD },
        { 0x9A0D, 0x8ADE },
        { 0x9A04, 0x8ADF },
        { 0x9A11, 0x8AE0 },
        { 0x9A0A, 0x8AE1 },
        { 0x9A05, 0x8AE2 },
        { 0x9A07, 0x8AE3 },
        { 0x9A06, 0x8AE4 },
        { 0x9AC0, 0x8AE5 },
        { 0x9ADC, 0x8AE6 },
        { 0x9B08, 0x8AE7 },
        { 0x9B04, 0x8AE8 },
        { 0x9B05, 0x8AE9 },
        { 0x9B29, 0x8AEA },
        { 0x9B35, 0x8AEB },
        { 0x9B4A, 0x8AEC },
        { 0x9B4C, 0x8AED },
        { 0x9B4B, 0x8AEE },
        { 0x9BC7, 0x8AEF },
        { 0x9BC6, 0x8AF0 },
        { 0x9BC3, 0x8AF1 },
        { 0x9BBF, 0x8AF2 },
        { 0x9BC1, 0x8AF3 },
        { 0x9BB5, 0x8AF4 },
        { 0x9BB8, 0x8AF5 },
        { 0x9BD3, 0x8AF6 },
        { 0x9BB6, 0x8AF7 },
        { 0x9BC4, 0x8AF8 },
        { 0x9BB9, 0x8AF9 },
        { 0x9BBD, 0x8AFA },
        { 0x9D5C, 0x8AFB },
        { 0x9D53, 0x8AFC },
        { 0x9D4F, 0x8AFD },
        { 0x9D4A, 0x8B41 },
        { 0x9D5B, 0x8B42 },
        { 0x9D4B, 0x8B43 },
        { 0x9D59, 0x8B44 },
        { 0x9D56, 0x8B45 },
        { 0x9D4C, 0x8B46 },
        { 0x9D57, 0x8B47 },
        { 0x9D52, 0x8B48 },
        { 0x9D54, 0x8B49 },
        { 0x9D5F, 0x8B4A },
        { 0x9D58, 0x8B4B },
        { 0x9D5A, 0x8B4C },
        { 0x9E8E, 0x8B4D },
        { 0x9E8C, 0x8B4E },
        { 0x9EDF, 0x8B4F },
        { 0x9F01, 0x8B50 },
        { 0x9F00, 0x8B51 },
        { 0x9F16, 0x8B52 },
        { 0x9F25, 0x8B53 },
        { 0x9F2B, 0x8B54 },
        { 0x9F2A, 0x8B55 },
        { 0x9F29, 0x8B56 },
        { 0x9F28, 0x8B57 },
        { 0x9F4C, 0x8B58 },
        { 0x9F55, 0x8B59 },
        { 0x5134, 0x8B5A },
        { 0x5135, 0x8B5B },
        { 0x5296, 0x8B5C },
        { 0x52F7, 0x8B5D },
        { 0x53B4, 0x8B5E },
        { 0x56AB, 0x8B5F },
        { 0x56AD, 0x8B60 },
        { 0x56A6, 0x8B61 },
        { 0x56A7, 0x8B62 },
        { 0x56AA, 0x8B63 },
        { 0x56AC, 0x8B64 },
        { 0x58DA, 0x8B65 },
        { 0x58DD, 0x8B66 },
        { 0x58DB, 0x8B67 },
        { 0x5912, 0x8B68 },
        { 0x5B3D, 0x8B69 },
        { 0x5B3E, 0x8B6A },
        { 0x5B3F, 0x8B6B },
        { 0x5DC3, 0x8B6C },
        { 0x5E70, 0x8B6D },
        { 0x5FBF, 0x8B6E },
        { 0x61FB, 0x8B6F },
        { 0x6507, 0x8B70 },
        { 0x6510, 0x8B71 },
        { 0x650D, 0x8B72 },
        { 0x6509, 0x8B73 },
        { 0x650C, 0x8B74 },
        { 0x650E, 0x8B75 },
        { 0x6584, 0x8B76 },
        { 0x65DE, 0x8B77 },
        { 0x65DD, 0x8B78 },
        { 0x66DE, 0x8B79 },
        { 0x6AE7, 0x8B7A },
        { 0x6AE0, 0x8B7B },
        { 0x6ACC, 0x8B7C },
        { 0x6AD1, 0x8B7D },
        { 0x6AD9, 0x8B7E },
        { 0x6ACB, 0x8B7F },
        { 0x6ADF, 0x8B81 },
        { 0x6ADC, 0x8B82 },
        { 0x6AD0, 0x8B83 },
        { 0x6AEB, 0x8B84 },
        { 0x6ACF, 0x8B85 },
        { 0x6ACD, 0x8B86 },
        { 0x6ADE, 0x8B87 },
        { 0x6B60, 0x8B88 },
        { 0x6BB0, 0x8B89 },
        { 0x6C0C, 0x8B8A },
        { 0x7019, 0x8B8B },
        { 0x7027, 0x8B8C },
        { 0x7020, 0x8B8D },
        { 0x7016, 0x8B8E },
        { 0x702B, 0x8B8F },
        { 0x7021, 0x8B90 },
        { 0x7022, 0x8B91 },
        { 0x7023, 0x8B92 },
        { 0x7029, 0x8B93 },
        { 0x7017, 0x8B94 },
        { 0x7024, 0x8B95 },
        { 0x701C, 0x8B96 },
        { 0x702A, 0x8B97 },
        { 0x720C, 0x8B98 },
        { 0x720A, 0x8B99 },
        { 0x7207, 0x8B9A },
        { 0x7202, 0x8B9B },
        { 0x7205, 0x8B9C },
        { 0x72A5, 0x8B9D },
        { 0x72A6, 0x8B9E },
        { 0x72A4, 0x8B9F },
        { 0x72A3, 0x8BA0 },
        { 0x72A1, 0x8BA1 },
        { 0x74CB, 0x8BA2 },
        { 0x74C5, 0x8BA3 },
        { 0x74B7, 0x8BA4 },
        { 0x74C3, 0x8BA5 },
        { 0x7516, 0x8BA6 },
        { 0x7660, 0x8BA7 },
        { 0x77C9, 0x8BA8 },
        { 0x77CA, 0x8BA9 },
        { 0x77C4, 0x8BAA },
        { 0x77F1, 0x8BAB },
        { 0x791D, 0x8BAC },
        { 0x791B, 0x8BAD },
        { 0x7921, 0x8BAE },
        { 0x791C, 0x8BAF },
        { 0x7917, 0x8BB0 },
        { 0x791E, 0x8BB1 },
        { 0x79B0, 0x8BB2 },
        { 0x7A67, 0x8BB3 },
        { 0x7A68, 0x8BB4 },
        { 0x7C33, 0x8BB5 },
        { 0x7C3C, 0x8BB6 },
        { 0x7C39, 0x8BB7 },
        { 0x7C2C, 0x8BB8 },
        { 0x7C3B, 0x8BB9 },
        { 0x7CEC, 0x8BBA },
        { 0x7CEA, 0x8BBB },
        { 0x7E76, 0x8BBC },
        { 0x7E75, 0x8BBD },
        { 0x7E78, 0x8BBE },
        { 0x7E70, 0x8BBF },
        { 0x7E77, 0x8BC0 },
        { 0x7E6F, 0x8BC1 },
        { 0x7E7A, 0x8BC2 },
        { 0x7E72, 0x8BC3 },
        { 0x7E74, 0x8BC4 },
        { 0x7E68, 0x8BC5 },
        { 0x7F4B, 0x8BC6 },
        { 0x7F4A, 0x8BC7 },
        { 0x7F83, 0x8BC8 },
        { 0x7F86, 0x8BC9 },
        { 0x7FB7, 0x8BCA },
        { 0x7FFD, 0x8BCB },
        { 0x7FFE, 0x8BCC },
        { 0x8078, 0x8BCD },
        { 0x81D7, 0x8BCE },
        { 0x81D5, 0x8BCF },
        { 0x8264, 0x8BD0 },
        { 0x8261, 0x8BD1 },
        { 0x8263, 0x8BD2 },
        { 0x85EB, 0x8BD3 },
        { 0x85F1, 0x8BD4 },
        { 0x85ED, 0x8BD5 },
        { 0x85D9, 0x8BD6 },
        { 0x85E1, 0x8BD7 },
        { 0x85E8, 0x8BD8 },
        { 0x85DA, 0x8BD9 },
        { 0x85D7, 0x8BDA },
        { 0x85EC, 0x8BDB },
        { 0x85F2, 0x8BDC },
        { 0x85F8, 0x8BDD },
        { 0x85D8, 0x8BDE },
        { 0x85DF, 0x8BDF },
        { 0x85E3, 0x8BE0 },
        { 0x85DC, 0x8BE1 },
        { 0x85D1, 0x8BE2 },
        { 0x85F0, 0x8BE3 },
        { 0x85E6, 0x8BE4 },
        { 0x85EF, 0x8BE5 },
        { 0x85DE, 0x8BE6 },
        { 0x85E2, 0x8BE7 },
        { 0x8800, 0x8BE8 },
        { 0x87FA, 0x8BE9 },
        { 0x8803, 0x8BEA },
        { 0x87F6, 0x8BEB },
        { 0x87F7, 0x8BEC },
        { 0x8809, 0x8BED },
        { 0x880C, 0x8BEE },
        { 0x880B, 0x8BEF },
        { 0x8806, 0x8BF0 },
        { 0x87FC, 0x8BF1 },
        { 0x8808, 0x8BF2 },
        { 0x87FF, 0x8BF3 },
        { 0x880A, 0x8BF4 },
        { 0x8802, 0x8BF5 },
        { 0x8962, 0x8BF6 },
        { 0x895A, 0x8BF7 },
        { 0x895B, 0x8BF8 },
        { 0x8957, 0x8BF9 },
        { 0x8961, 0x8BFA },
        { 0x895C, 0x8BFB },
        { 0x8958, 0x8BFC },
        { 0x895D, 0x8BFD },
        { 0x8959, 0x8C41 },
        { 0x8988, 0x8C42 },
        { 0x89B7, 0x8C43 },
        { 0x89B6, 0x8C44 },
        { 0x89F6, 0x8C45 },
        { 0x8B50, 0x8C46 },
        { 0x8B48, 0x8C47 },
        { 0x8B4A, 0x8C48 },
        { 0x8B40, 0x8C49 },
        { 0x8B53, 0x8C4A },
        { 0x8B56, 0x8C4B },
        { 0x8B54, 0x8C4C },
        { 0x8B4B, 0x8C4D },
        { 0x8B55, 0x8C4E },
        { 0x8B51, 0x8C4F },
        { 0x8B42, 0x8C50 },
        { 0x8B52, 0x8C51 },
        { 0x8B57, 0x8C52 },
        { 0x8C43, 0x8C53 },
        { 0x8C77, 0x8C54 },
        { 0x8C76, 0x8C55 },
        { 0x8C9A, 0x8C56 },
        { 0x8D06, 0x8C57 },
        { 0x8D07, 0x8C58 },
        { 0x8D09, 0x8C59 },
        { 0x8DAC, 0x8C5A },
        { 0x8DAA, 0x8C5B },
        { 0x8DAD, 0x8C5C },
        { 0x8DAB, 0x8C5D },
        { 0x8E6D, 0x8C5E },
        { 0x8E78, 0x8C5F },
        { 0x8E73, 0x8C60 },
        { 0x8E6A, 0x8C61 },
        { 0x8E6F, 0x8C62 },
        { 0x8E7B, 0x8C63 },
        { 0x8EC2, 0x8C64 },
        { 0x8F52, 0x8C65 },
        { 0x8F51, 0x8C66 },
        { 0x8F4F, 0x8C67 },
        { 0x8F50, 0x8C68 },
        { 0x8F53, 0x8C69 },
        { 0x8FB4, 0x8C6A },
        { 0x9140, 0x8C6B },
        { 0x913F, 0x8C6C },
        { 0x91B0, 0x8C6D },
        { 0x91AD, 0x8C6E },
        { 0x93DE, 0x8C6F },
        { 0x93C7, 0x8C70 },
        { 0x93CF, 0x8C71 },
        { 0x93C2, 0x8C72 },
        { 0x93DA, 0x8C73 },
        { 0x93D0, 0x8C74 },
        { 0x93F9, 0x8C75 },
        { 0x93EC, 0x8C76 },
        { 0x93CC, 0x8C77 },
        { 0x93D9, 0x8C78 },
        { 0x93A9, 0x8C79 },
        { 0x93E6, 0x8C7A },
        { 0x93CA, 0x8C7B },
        { 0x93D4, 0x8C7C },
        { 0x93EE, 0x8C7D },
        { 0x93E3, 0x8C7E },
        { 0x93D5, 0x8C7F },
        { 0x93C4, 0x8C81 },
        { 0x93CE, 0x8C82 },
        { 0x93C0, 0x8C83 },
        { 0x93D2, 0x8C84 },
        { 0x93E7, 0x8C85 },
        { 0x957D, 0x8C86 },
        { 0x95DA, 0x8C87 },
        { 0x95DB, 0x8C88 },
        { 0x96E1, 0x8C89 },
        { 0x9729, 0x8C8A },
        { 0x972B, 0x8C8B },
        { 0x972C, 0x8C8C },
        { 0x9728, 0x8C8D },
        { 0x9726, 0x8C8E },
        { 0x97B3, 0x8C8F },
        { 0x97B7, 0x8C90 },
        { 0x97B6, 0x8C91 },
        { 0x97DD, 0x8C92 },
        { 0x97DE, 0x8C93 },
        { 0x97DF, 0x8C94 },
        { 0x985C, 0x8C95 },
        { 0x9859, 0x8C96 },
        { 0x985D, 0x8C97 },
        { 0x9857, 0x8C98 },
        { 0x98BF, 0x8C99 },
        { 0x98BD, 0x8C9A },
        { 0x98BB, 0x8C9B },
        { 0x98BE, 0x8C9C },
        { 0x9948, 0x8C9D },
        { 0x9947, 0x8C9E },
        { 0x9943, 0x8C9F },
        { 0x99A6, 0x8CA0 },
        { 0x99A7, 0x8CA1 },
        { 0x9A1A, 0x8CA2 },
        { 0x9A15, 0x8CA3 },
        { 0x9A25, 0x8CA4 },
        { 0x9A1D, 0x8CA5 },
        { 0x9A24, 0x8CA6 },
        { 0x9A1B, 0x8CA7 },
        { 0x9A22, 0x8CA8 },
        { 0x9A20, 0x8CA9 },
        { 0x9A27, 0x8CAA },
        { 0x9A23, 0x8CAB },
        { 0x9A1E, 0x8CAC },
        { 0x9A1C, 0x8CAD },
        { 0x9A14, 0x8CAE },
        { 0x9AC2, 0x8CAF },
        { 0x9B0B, 0x8CB0 },
        { 0x9B0A, 0x8CB1 },
        { 0x9B0E, 0x8CB2 },
        { 0x9B0C, 0x8CB3 },
        { 0x9B37, 0x8CB4 },
        { 0x9BEA, 0x8CB5 },
        { 0x9BEB, 0x8CB6 },
        { 0x9BE0, 0x8CB7 },
        { 0x9BDE, 0x8CB8 },
        { 0x9BE4, 0x8CB9 },
        { 0x9BE6, 0x8CBA },
        { 0x9BE2, 0x8CBB },
        { 0x9BF0, 0x8CBC },
        { 0x9BD4, 0x8CBD },
        { 0x9BD7, 0x8CBE },
        { 0x9BEC, 0x8CBF },
        { 0x9BDC, 0x8CC0 },
        { 0x9BD9, 0x8CC1 },
        { 0x9BE5, 0x8CC2 },
        { 0x9BD5, 0x8CC3 },
        { 0x9BE1, 0x8CC4 },
        { 0x9BDA, 0x8CC5 },
        { 0x9D77, 0x8CC6 },
        { 0x9D81, 0x8CC7 },
        { 0x9D8A, 0x8CC8 },
        { 0x9D84, 0x8CC9 },
        { 0x9D88, 0x8CCA },
        { 0x9D71, 0x8CCB },
        { 0x9D80, 0x8CCC },
        { 0x9D78, 0x8CCD },
        { 0x9D86, 0x8CCE },
        { 0x9D8B, 0x8CCF },
        { 0x9D8C, 0x8CD0 },
        { 0x9D7D, 0x8CD1 },
        { 0x9D6B, 0x8CD2 },
        { 0x9D74, 0x8CD3 },
        { 0x9D75, 0x8CD4 },
        { 0x9D70, 0x8CD5 },
        { 0x9D69, 0x8CD6 },
        { 0x9D85, 0x8CD7 },
        { 0x9D73, 0x8CD8 },
        { 0x9D7B, 0x8CD9 },
        { 0x9D82, 0x8CDA },
        { 0x9D6F, 0x8CDB },
        { 0x9D79, 0x8CDC },
        { 0x9D7F, 0x8CDD },
        { 0x9D87, 0x8CDE },
        { 0x9D68, 0x8CDF },
        { 0x9E94, 0x8CE0 },
        { 0x9E91, 0x8CE1 },
        { 0x9EC0, 0x8CE2 },
        { 0x9EFC, 0x8CE3 },
        { 0x9F2D, 0x8CE4 },
        { 0x9F40, 0x8CE5 },
        { 0x9F41, 0x8CE6 },
        { 0x9F4D, 0x8CE7 },
        { 0x9F56, 0x8CE8 },
        { 0x9F57, 0x8CE9 },
        { 0x9F58, 0x8CEA },
        { 0x5337, 0x8CEB },
        { 0x56B2, 0x8CEC },
        { 0x56B5, 0x8CED },
        { 0x56B3, 0x8CEE },
        { 0x58E3, 0x8CEF },
        { 0x5B45, 0x8CF0 },
        { 0x5DC6, 0x8CF1 },
        { 0x5DC7, 0x8CF2 },
        { 0x5EEE, 0x8CF3 },
        { 0x5EEF, 0x8CF4 },
        { 0x5FC0, 0x8CF5 },
        { 0x5FC1, 0x8CF6 },
        { 0x61F9, 0x8CF7 },
        { 0x6517, 0x8CF8 },
        { 0x6516, 0x8CF9 },
        { 0x6515, 0x8CFA },
        { 0x6513, 0x8CFB },
        { 0x65DF, 0x8CFC },
        { 0x66E8, 0x8CFD },
        { 0x66E3, 0x8D41 },
        { 0x66E4, 0x8D42 },
        { 0x6AF3, 0x8D43 },
        { 0x6AF0, 0x8D44 },
        { 0x6AEA, 0x8D45 },
        { 0x6AE8, 0x8D46 },
        { 0x6AF9, 0x8D47 },
        { 0x6AF1, 0x8D48 },
        { 0x6AEE, 0x8D49 },
        { 0x6AEF, 0x8D4A },
        { 0x703C, 0x8D4B },
        { 0x7035, 0x8D4C },
        { 0x702F, 0x8D4D },
        { 0x7037, 0x8D4E },
        { 0x7034, 0x8D4F },
        { 0x7031, 0x8D50 },
        { 0x7042, 0x8D51 },
        { 0x7038, 0x8D52 },
        { 0x703F, 0x8D53 },
        { 0x703A, 0x8D54 },
        { 0x7039, 0x8D55 },
        { 0x7040, 0x8D56 },
        { 0x703B, 0x8D57 },
        { 0x7033, 0x8D58 },
        { 0x7041, 0x8D59 },
        { 0x7213, 0x8D5A },
        { 0x7214, 0x8D5B },
        { 0x72A8, 0x8D5C },
        { 0x737D, 0x8D5D },
        { 0x737C, 0x8D5E },
        { 0x74BA, 0x8D5F },
        { 0x76AB, 0x8D60 },
        { 0x76AA, 0x8D61 },
        { 0x76BE, 0x8D62 },
        { 0x76ED, 0x8D63 },
        { 0x77CC, 0x8D64 },
        { 0x77CE, 0x8D65 },
        { 0x77CF, 0x8D66 },
        { 0x77CD, 0x8D67 },
        { 0x77F2, 0x8D68 },
        { 0x7925, 0x8D69 },
        { 0x7923, 0x8D6A },
        { 0x7927, 0x8D6B },
        { 0x7928, 0x8D6C },
        { 0x7924, 0x8D6D },
        { 0x7929, 0x8D6E },
        { 0x79B2, 0x8D6F },
        { 0x7A6E, 0x8D70 },
        { 0x7A6C, 0x8D71 },
        { 0x7A6D, 0x8D72 },
        { 0x7AF7, 0x8D73 },
        { 0x7C49, 0x8D74 },
        { 0x7C48, 0x8D75 },
        { 0x7C4A, 0x8D76 },
        { 0x7C47, 0x8D77 },
        { 0x7C45, 0x8D78 },
        { 0x7CEE, 0x8D79 },
        { 0x7E7B, 0x8D7A },
        { 0x7E7E, 0x8D7B },
        { 0x7E81, 0x8D7C },
        { 0x7E80, 0x8D7D },
        { 0x7FBA, 0x8D7E },
        { 0x7FFF, 0x8D7F },
        { 0x8079, 0x8D81 },
        { 0x81DB, 0x8D82 },
        { 0x81D9, 0x8D83 },
        { 0x820B, 0x8D84 },
        { 0x8268, 0x8D85 },
        { 0x8269, 0x8D86 },
        { 0x8622, 0x8D87 },
        { 0x85FF, 0x8D88 },
        { 0x8601, 0x8D89 },
        { 0x85FE, 0x8D8A },
        { 0x861B, 0x8D8B },
        { 0x8600, 0x8D8C },
        { 0x85F6, 0x8D8D },
        { 0x8604, 0x8D8E },
        { 0x8609, 0x8D8F },
        { 0x8605, 0x8D90 },
        { 0x860C, 0x8D91 },
        { 0x85FD, 0x8D92 },
        { 0x8819, 0x8D93 },
        { 0x8810, 0x8D94 },
        { 0x8811, 0x8D95 },
        { 0x8817, 0x8D96 },
        { 0x8813, 0x8D97 },
        { 0x8816, 0x8D98 },
        { 0x8963, 0x8D99 },
        { 0x8966, 0x8D9A },
        { 0x89B9, 0x8D9B },
        { 0x89F7, 0x8D9C },
        { 0x8B60, 0x8D9D },
        { 0x8B6A, 0x8D9E },
        { 0x8B5D, 0x8D9F },
        { 0x8B68, 0x8DA0 },
        { 0x8B63, 0x8DA1 },
        { 0x8B65, 0x8DA2 },
        { 0x8B67, 0x8DA3 },
        { 0x8B6D, 0x8DA4 },
        { 0x8DAE, 0x8DA5 },
        { 0x8E86, 0x8DA6 },
        { 0x8E88, 0x8DA7 },
        { 0x8E84, 0x8DA8 },
        { 0x8F59, 0x8DA9 },
        { 0x8F56, 0x8DAA },
        { 0x8F57, 0x8DAB },
        { 0x8F55, 0x8DAC },
        { 0x8F58, 0x8DAD },
        { 0x8F5A, 0x8DAE },
        { 0x908D, 0x8DAF },
        { 0x9143, 0x8DB0 },
        { 0x9141, 0x8DB1 },
        { 0x91B7, 0x8DB2 },
        { 0x91B5, 0x8DB3 },
        { 0x91B2, 0x8DB4 },
        { 0x91B3, 0x8DB5 },
        { 0x940B, 0x8DB6 },
        { 0x9413, 0x8DB7 },
        { 0x93FB, 0x8DB8 },
        { 0x9420, 0x8DB9 },
        { 0x940F, 0x8DBA },
        { 0x9414, 0x8DBB },
        { 0x93FE, 0x8DBC },
        { 0x9415, 0x8DBD },
        { 0x9410, 0x8DBE },
        { 0x9428, 0x8DBF },
        { 0x9419, 0x8DC0 },
        { 0x940D, 0x8DC1 },
        { 0x93F5, 0x8DC2 },
        { 0x9400, 0x8DC3 },
        { 0x93F7, 0x8DC4 },
        { 0x9407, 0x8DC5 },
        { 0x940E, 0x8DC6 },
        { 0x9416, 0x8DC7 },
        { 0x9412, 0x8DC8 },
        { 0x93FA, 0x8DC9 },
        { 0x9409, 0x8DCA },
        { 0x93F8, 0x8DCB },
        { 0x940A, 0x8DCC },
        { 0x93FF, 0x8DCD },
        { 0x93FC, 0x8DCE },
        { 0x940C, 0x8DCF },
        { 0x93F6, 0x8DD0 },
        { 0x9411, 0x8DD1 },
        { 0x9406, 0x8DD2 },
        { 0x95DE, 0x8DD3 },
        { 0x95E0, 0x8DD4 },
        { 0x95DF, 0x8DD5 },
        { 0x972E, 0x8DD6 },
        { 0x972F, 0x8DD7 },
        { 0x97B9, 0x8DD8 },
        { 0x97BB, 0x8DD9 },
        { 0x97FD, 0x8DDA },
        { 0x97FE, 0x8DDB },
        { 0x9860, 0x8DDC },
        { 0x9862, 0x8DDD },
        { 0x9863, 0x8DDE },
        { 0x985F, 0x8DDF },
        { 0x98C1, 0x8DE0 },
        { 0x98C2, 0x8DE1 },
        { 0x9950, 0x8DE2 },
        { 0x994E, 0x8DE3 },
        { 0x9959, 0x8DE4 },
        { 0x994C, 0x8DE5 },
        { 0x994B, 0x8DE6 },
        { 0x9953, 0x8DE7 },
        { 0x9A32, 0x8DE8 },
        { 0x9A34, 0x8DE9 },
        { 0x9A31, 0x8DEA },
        { 0x9A2C, 0x8DEB },
        { 0x9A2A, 0x8DEC },
        { 0x9A36, 0x8DED },
        { 0x9A29, 0x8DEE },
        { 0x9A2E, 0x8DEF },
        { 0x9A38, 0x8DF0 },
        { 0x9A2D, 0x8DF1 },
        { 0x9AC7, 0x8DF2 },
        { 0x9ACA, 0x8DF3 },
        { 0x9AC6, 0x8DF4 },
        { 0x9B10, 0x8DF5 },
        { 0x9B12, 0x8DF6 },
        { 0x9B11, 0x8DF7 },
        { 0x9C0B, 0x8DF8 },
        { 0x9C08, 0x8DF9 },
        { 0x9BF7, 0x8DFA },
        { 0x9C05, 0x8DFB },
        { 0x9C12, 0x8DFC },
        { 0x9BF8, 0x8DFD },
        { 0x9C40, 0x8E41 },
        { 0x9C07, 0x8E42 },
        { 0x9C0E, 0x8E43 },
        { 0x9C06, 0x8E44 },
        { 0x9C17, 0x8E45 },
        { 0x9C14, 0x8E46 },
        { 0x9C09, 0x8E47 },
        { 0x9D9F, 0x8E48 },
        { 0x9D99, 0x8E49 },
        { 0x9DA4, 0x8E4A },
        { 0x9D9D, 0x8E4B },
        { 0x9D92, 0x8E4C },
        { 0x9D98, 0x8E4D },
        { 0x9D90, 0x8E4E },
        { 0x9D9B, 0x8E4F },
        { 0x9DA0, 0x8E50 },
        { 0x9D94, 0x8E51 },
        { 0x9D9C, 0x8E52 },
        { 0x9DAA, 0x8E53 },
        { 0x9D97, 0x8E54 },
        { 0x9DA1, 0x8E55 },
        { 0x9D9A, 0x8E56 },
        { 0x9DA2, 0x8E57 },
        { 0x9DA8, 0x8E58 },
        { 0x9D9E, 0x8E59 },
        { 0x9DA3, 0x8E5A },
        { 0x9DBF, 0x8E5B },
        { 0x9DA9, 0x8E5C },
        { 0x9D96, 0x8E5D },
        { 0x9DA6, 0x8E5E },
        { 0x9DA7, 0x8E5F },
        { 0x9E99, 0x8E60 },
        { 0x9E9B, 0x8E61 },
        { 0x9E9A, 0x8E62 },
        { 0x9EE5, 0x8E63 },
        { 0x9EE4, 0x8E64 },
        { 0x9EE7, 0x8E65 },
        { 0x9EE6, 0x8E66 },
        { 0x9F30, 0x8E67 },
        { 0x9F2E, 0x8E68 },
        { 0x9F5B, 0x8E69 },
        { 0x9F60, 0x8E6A },
        { 0x9F5E, 0x8E6B },
        { 0x9F5D, 0x8E6C },
        { 0x9F59, 0x8E6D },
        { 0x9F91, 0x8E6E },
        { 0x513A, 0x8E6F },
        { 0x5139, 0x8E70 },
        { 0x5298, 0x8E71 },
        { 0x5297, 0x8E72 },
        { 0x56C3, 0x8E73 },
        { 0x56BD, 0x8E74 },
        { 0x56BE, 0x8E75 },
        { 0x5B48, 0x8E76 },
        { 0x5B47, 0x8E77 },
        { 0x5DCB, 0x8E78 },
        { 0x5DCF, 0x8E79 },
        { 0x5EF1, 0x8E7A },
        { 0x61FD, 0x8E7B },
        { 0x651B, 0x8E7C },
        { 0x6B02, 0x8E7D },
        { 0x6AFC, 0x8E7E },
        { 0x6B03, 0x8E7F },
        { 0x6AF8, 0x8E81 },
        { 0x6B00, 0x8E82 },
        { 0x7043, 0x8E83 },
        { 0x7044, 0x8E84 },
        { 0x704A, 0x8E85 },
        { 0x7048, 0x8E86 },
        { 0x7049, 0x8E87 },
        { 0x7045, 0x8E88 },
        { 0x7046, 0x8E89 },
        { 0x721D, 0x8E8A },
        { 0x721A, 0x8E8B },
        { 0x7219, 0x8E8C },
        { 0x737E, 0x8E8D },
        { 0x7517, 0x8E8E },
        { 0x766A, 0x8E8F },
        { 0x77D0, 0x8E90 },
        { 0x792D, 0x8E91 },
        { 0x7931, 0x8E92 },
        { 0x792F, 0x8E93 },
        { 0x7C54, 0x8E94 },
        { 0x7C53, 0x8E95 },
        { 0x7CF2, 0x8E96 },
        { 0x7E8A, 0x8E97 },
        { 0x7E87, 0x8E98 },
        { 0x7E88, 0x8E99 },
        { 0x7E8B, 0x8E9A },
        { 0x7E86, 0x8E9B },
        { 0x7E8D, 0x8E9C },
        { 0x7F4D, 0x8E9D },
        { 0x7FBB, 0x8E9E },
        { 0x8030, 0x8E9F },
        { 0x81DD, 0x8EA0 },
        { 0x8618, 0x8EA1 },
        { 0x862A, 0x8EA2 },
        { 0x8626, 0x8EA3 },
        { 0x861F, 0x8EA4 },
        { 0x8623, 0x8EA5 },
        { 0x861C, 0x8EA6 },
        { 0x8619, 0x8EA7 },
        { 0x8627, 0x8EA8 },
        { 0x862E, 0x8EA9 },
        { 0x8621, 0x8EAA },
        { 0x8620, 0x8EAB },
        { 0x8629, 0x8EAC },
        { 0x861E, 0x8EAD },
        { 0x8625, 0x8EAE },
        { 0x8829, 0x8EAF },
        { 0x881D, 0x8EB0 },
        { 0x881B, 0x8EB1 },
        { 0x8820, 0x8EB2 },
        { 0x8824, 0x8EB3 },
        { 0x881C, 0x8EB4 },
        { 0x882B, 0x8EB5 },
        { 0x884A, 0x8EB6 },
        { 0x896D, 0x8EB7 },
        { 0x8969, 0x8EB8 },
        { 0x896E, 0x8EB9 },
        { 0x896B, 0x8EBA },
        { 0x89FA, 0x8EBB },
        { 0x8B79, 0x8EBC },
        { 0x8B78, 0x8EBD },
        { 0x8B45, 0x8EBE },
        { 0x8B7A, 0x8EBF },
        { 0x8B7B, 0x8EC0 },
        { 0x8D10, 0x8EC1 },
        { 0x8D14, 0x8EC2 },
        { 0x8DAF, 0x8EC3 },
        { 0x8E8E, 0x8EC4 },
        { 0x8E8C, 0x8EC5 },
        { 0x8F5E, 0x8EC6 },
        { 0x8F5B, 0x8EC7 },
        { 0x8F5D, 0x8EC8 },
        { 0x9146, 0x8EC9 },
        { 0x9144, 0x8ECA },
        { 0x9145, 0x8ECB },
        { 0x91B9, 0x8ECC },
        { 0x943F, 0x8ECD },
        { 0x943B, 0x8ECE },
        { 0x9436, 0x8ECF },
        { 0x9429, 0x8ED0 },
        { 0x943D, 0x8ED1 },
        { 0x943C, 0x8ED2 },
        { 0x9430, 0x8ED3 },
        { 0x9439, 0x8ED4 },
        { 0x942A, 0x8ED5 },
        { 0x9437, 0x8ED6 },
        { 0x942C, 0x8ED7 },
        { 0x9440, 0x8ED8 },
        { 0x9431, 0x8ED9 },
        { 0x95E5, 0x8EDA },
        { 0x95E4, 0x8EDB },
        { 0x95E3, 0x8EDC },
        { 0x9735, 0x8EDD },
        { 0x973A, 0x8EDE },
        { 0x97BF, 0x8EDF },
        { 0x97E1, 0x8EE0 },
        { 0x9864, 0x8EE1 },
        { 0x98C9, 0x8EE2 },
        { 0x98C6, 0x8EE3 },
        { 0x98C0, 0x8EE4 },
        { 0x9958, 0x8EE5 },
        { 0x9956, 0x8EE6 },
        { 0x9A39, 0x8EE7 },
        { 0x9A3D, 0x8EE8 },
        { 0x9A46, 0x8EE9 },
        { 0x9A44, 0x8EEA },
        { 0x9A42, 0x8EEB },
        { 0x9A41, 0x8EEC },
        { 0x9A3A, 0x8EED },
        { 0x9A3F, 0x8EEE },
        { 0x9ACD, 0x8EEF },
        { 0x9B15, 0x8EF0 },
        { 0x9B17, 0x8EF1 },
        { 0x9B18, 0x8EF2 },
        { 0x9B16, 0x8EF3 },
        { 0x9B3A, 0x8EF4 },
        { 0x9B52, 0x8EF5 },
        { 0x9C2B, 0x8EF6 },
        { 0x9C1D, 0x8EF7 },
        { 0x9C1C, 0x8EF8 },
        { 0x9C2C, 0x8EF9 },
        { 0x9C23, 0x8EFA },
        { 0x9C28, 0x8EFB },
        { 0x9C29, 0x8EFC },
        { 0x9C24, 0x8EFD },
        { 0x9C21, 0x8F41 },
        { 0x9DB7, 0x8F42 },
        { 0x9DB6, 0x8F43 },
        { 0x9DBC, 0x8F44 },
        { 0x9DC1, 0x8F45 },
        { 0x9DC7, 0x8F46 },
        { 0x9DCA, 0x8F47 },
        { 0x9DCF, 0x8F48 },
        { 0x9DBE, 0x8F49 },
        { 0x9DC5, 0x8F4A },
        { 0x9DC3, 0x8F4B },
        { 0x9DBB, 0x8F4C },
        { 0x9DB5, 0x8F4D },
        { 0x9DCE, 0x8F4E },
        { 0x9DB9, 0x8F4F },
        { 0x9DBA, 0x8F50 },
        { 0x9DAC, 0x8F51 },
        { 0x9DC8, 0x8F52 },
        { 0x9DB1, 0x8F53 },
        { 0x9DAD, 0x8F54 },
        { 0x9DCC, 0x8F55 },
        { 0x9DB3, 0x8F56 },
        { 0x9DCD, 0x8F57 },
        { 0x9DB2, 0x8F58 },
        { 0x9E7A, 0x8F59 },
        { 0x9E9C, 0x8F5A },
        { 0x9EEB, 0x8F5B },
        { 0x9EEE, 0x8F5C },
        { 0x9EED, 0x8F5D },
        { 0x9F1B, 0x8F5E },
        { 0x9F18, 0x8F5F },
        { 0x9F1A, 0x8F60 },
        { 0x9F31, 0x8F61 },
        { 0x9F4E, 0x8F62 },
        { 0x9F65, 0x8F63 },
        { 0x9F64, 0x8F64 },
        { 0x9F92, 0x8F65 },
        { 0x4EB9, 0x8F66 },
        { 0x56C6, 0x8F67 },
        { 0x56C5, 0x8F68 },
        { 0x56CB, 0x8F69 },
        { 0x5971, 0x8F6A },
        { 0x5B4B, 0x8F6B },
        { 0x5B4C, 0x8F6C },
        { 0x5DD5, 0x8F6D },
        { 0x5DD1, 0x8F6E },
        { 0x5EF2, 0x8F6F },
        { 0x6521, 0x8F70 },
        { 0x6520, 0x8F71 },
        { 0x6526, 0x8F72 },
        { 0x6522, 0x8F73 },
        { 0x6B0B, 0x8F74 },
        { 0x6B08, 0x8F75 },
        { 0x6B09, 0x8F76 },
        { 0x6C0D, 0x8F77 },
        { 0x7055, 0x8F78 },
        { 0x7056, 0x8F79 },
        { 0x7057, 0x8F7A },
        { 0x7052, 0x8F7B },
        { 0x721E, 0x8F7C },
        { 0x721F, 0x8F7D },
        { 0x72A9, 0x8F7E },
        { 0x737F, 0x8F7F },
        { 0x74D8, 0x8F81 },
        { 0x74D5, 0x8F82 },
        { 0x74D9, 0x8F83 },
        { 0x74D7, 0x8F84 },
        { 0x766D, 0x8F85 },
        { 0x76AD, 0x8F86 },
        { 0x7935, 0x8F87 },
        { 0x79B4, 0x8F88 },
        { 0x7A70, 0x8F89 },
        { 0x7A71, 0x8F8A },
        { 0x7C57, 0x8F8B },
        { 0x7C5C, 0x8F8C },
        { 0x7C59, 0x8F8D },
        { 0x7C5B, 0x8F8E },
        { 0x7C5A, 0x8F8F },
        { 0x7CF4, 0x8F90 },
        { 0x7CF1, 0x8F91 },
        { 0x7E91, 0x8F92 },
        { 0x7F4F, 0x8F93 },
        { 0x7F87, 0x8F94 },
        { 0x81DE, 0x8F95 },
        { 0x826B, 0x8F96 },
        { 0x8634, 0x8F97 },
        { 0x8635, 0x8F98 },
        { 0x8633, 0x8F99 },
        { 0x862C, 0x8F9A },
        { 0x8632, 0x8F9B },
        { 0x8636, 0x8F9C },
        { 0x882C, 0x8F9D },
        { 0x8828, 0x8F9E },
        { 0x8826, 0x8F9F },
        { 0x882A, 0x8FA0 },
        { 0x8825, 0x8FA1 },
        { 0x8971, 0x8FA2 },
        { 0x89BF, 0x8FA3 },
        { 0x89BE, 0x8FA4 },
        { 0x89FB, 0x8FA5 },
        { 0x8B7E, 0x8FA6 },
        { 0x8B84, 0x8FA7 },
        { 0x8B82, 0x8FA8 },
        { 0x8B86, 0x8FA9 },
        { 0x8B85, 0x8FAA },
        { 0x8B7F, 0x8FAB },
        { 0x8D15, 0x8FAC },
        { 0x8E95, 0x8FAD },
        { 0x8E94, 0x8FAE },
        { 0x8E9A, 0x8FAF },
        { 0x8E92, 0x8FB0 },
        { 0x8E90, 0x8FB1 },
        { 0x8E96, 0x8FB2 },
        { 0x8E97, 0x8FB3 },
        { 0x8F60, 0x8FB4 },
        { 0x8F62, 0x8FB5 },
        { 0x9147, 0x8FB6 },
        { 0x944C, 0x8FB7 },
        { 0x9450, 0x8FB8 },
        { 0x944A, 0x8FB9 },
        { 0x944B, 0x8FBA },
        { 0x944F, 0x8FBB },
        { 0x9447, 0x8FBC },
        { 0x9445, 0x8FBD },
        { 0x9448, 0x8FBE },
        { 0x9449, 0x8FBF },
        { 0x9446, 0x8FC0 },
        { 0x973F, 0x8FC1 },
        { 0x97E3, 0x8FC2 },
        { 0x986A, 0x8FC3 },
        { 0x9869, 0x8FC4 },
        { 0x98CB, 0x8FC5 },
        { 0x9954, 0x8FC6 },
        { 0x995B, 0x8FC7 },
        { 0x9A4E, 0x8FC8 },
        { 0x9A53, 0x8FC9 },
        { 0x9A54, 0x8FCA },
        { 0x9A4C, 0x8FCB },
        { 0x9A4F, 0x8FCC },
        { 0x9A48, 0x8FCD },
        { 0x9A4A, 0x8FCE },
        { 0x9A49, 0x8FCF },
        { 0x9A52, 0x8FD0 },
        { 0x9A50, 0x8FD1 },
        { 0x9AD0, 0x8FD2 },
        { 0x9B19, 0x8FD3 },
        { 0x9B2B, 0x8FD4 },
        { 0x9B3B, 0x8FD5 },
        { 0x9B56, 0x8FD6 },
        { 0x9B55, 0x8FD7 },
        { 0x9C46, 0x8FD8 },
        { 0x9C48, 0x8FD9 },
        { 0x9C3F, 0x8FDA },
        { 0x9C44, 0x8FDB },
        { 0x9C39, 0x8FDC },
        { 0x9C33, 0x8FDD },
        { 0x9C41, 0x8FDE },
        { 0x9C3C, 0x8FDF },
        { 0x9C37, 0x8FE0 },
        { 0x9C34, 0x8FE1 },
        { 0x9C32, 0x8FE2 },
        { 0x9C3D, 0x8FE3 },
        { 0x9C36, 0x8FE4 },
        { 0x9DDB, 0x8FE5 },
        { 0x9DD2, 0x8FE6 },
        { 0x9DDE, 0x8FE7 },
        { 0x9DDA, 0x8FE8 },
        { 0x9DCB, 0x8FE9 },
        { 0x9DD0, 0x8FEA },
        { 0x9DDC, 0x8FEB },
        { 0x9DD1, 0x8FEC },
        { 0x9DDF, 0x8FED },
        { 0x9DE9, 0x8FEE },
        { 0x9DD9, 0x8FEF },
        { 0x9DD8, 0x8FF0 },
        { 0x9DD6, 0x8FF1 },
        { 0x9DF5, 0x8FF2 },
        { 0x9DD5, 0x8FF3 },
        { 0x9DDD, 0x8FF4 },
        { 0x9EB6, 0x8FF5 },
        { 0x9EF0, 0x8FF6 },
        { 0x9F35, 0x8FF7 },
        { 0x9F33, 0x8FF8 },
        { 0x9F32, 0x8FF9 },
        { 0x9F42, 0x8FFA },
        { 0x9F6B, 0x8FFB },
        { 0x9F95, 0x8FFC },
        { 0x9FA2, 0x8FFD },
        { 0x513D, 0x9041 },
        { 0x5299, 0x9042 },
        { 0x58E8, 0x9043 },
        { 0x58E7, 0x9044 },
        { 0x5972, 0x9045 },
        { 0x5B4D, 0x9046 },
        { 0x5DD8, 0x9047 },
        { 0x882F, 0x9048 },
        { 0x5F4F, 0x9049 },
        { 0x6201, 0x904A },
        { 0x6203, 0x904B },
        { 0x6204, 0x904C },
        { 0x6529, 0x904D },
        { 0x6525, 0x904E },
        { 0x6596, 0x904F },
        { 0x66EB, 0x9050 },
        { 0x6B11, 0x9051 },
        { 0x6B12, 0x9052 },
        { 0x6B0F, 0x9053 },
        { 0x6BCA, 0x9054 },
        { 0x705B, 0x9055 },
        { 0x705A, 0x9056 },
        { 0x7222, 0x9057 },
        { 0x7382, 0x9058 },
        { 0x7381, 0x9059 },
        { 0x7383, 0x905A },
        { 0x7670, 0x905B },
        { 0x77D4, 0x905C },
        { 0x7C67, 0x905D },
        { 0x7C66, 0x905E },
        { 0x7E95, 0x905F },
        { 0x826C, 0x9060 },
        { 0x863A, 0x9061 },
        { 0x8640, 0x9062 },
        { 0x8639, 0x9063 },
        { 0x863C, 0x9064 },
        { 0x8631, 0x9065 },
        { 0x863B, 0x9066 },
        { 0x863E, 0x9067 },
        { 0x8830, 0x9068 },
        { 0x8832, 0x9069 },
        { 0x882E, 0x906A },
        { 0x8833, 0x906B },
        { 0x8976, 0x906C },
        { 0x8974, 0x906D },
        { 0x8973, 0x906E },
        { 0x89FE, 0x906F },
        { 0x8B8C, 0x9070 },
        { 0x8B8E, 0x9071 },
        { 0x8B8B, 0x9072 },
        { 0x8B88, 0x9073 },
        { 0x8C45, 0x9074 },
        { 0x8D19, 0x9075 },
        { 0x8E98, 0x9076 },
        { 0x8F64, 0x9077 },
        { 0x8F63, 0x9078 },
        { 0x91BC, 0x9079 },
        { 0x9462, 0x907A },
        { 0x9455, 0x907B },
        { 0x945D, 0x907C },
        { 0x9457, 0x907D },
        { 0x945E, 0x907E },
        { 0x97C4, 0x907F },
        { 0x97C5, 0x9081 },
        { 0x9800, 0x9082 },
        { 0x9A56, 0x9083 },
        { 0x9A59, 0x9084 },
        { 0x9B1E, 0x9085 },
        { 0x9B1F, 0x9086 },
        { 0x9B20, 0x9087 },
        { 0x9C52, 0x9088 },
        { 0x9C58, 0x9089 },
        { 0x9C50, 0x908A },
        { 0x9C4A, 0x908B },
        { 0x9C4D, 0x908C },
        { 0x9C4B, 0x908D },
        { 0x9C55, 0x908E },
        { 0x9C59, 0x908F },
        { 0x9C4C, 0x9090 },
        { 0x9C4E, 0x9091 },
        { 0x9DFB, 0x9092 },
        { 0x9DF7, 0x9093 },
        { 0x9DEF, 0x9094 },
        { 0x9DE3, 0x9095 },
        { 0x9DEB, 0x9096 },
        { 0x9DF8, 0x9097 },
        { 0x9DE4, 0x9098 },
        { 0x9DF6, 0x9099 },
        { 0x9DE1, 0x909A },
        { 0x9DEE, 0x909B },
        { 0x9DE6, 0x909C },
        { 0x9DF2, 0x909D },
        { 0x9DF0, 0x909E },
        { 0x9DE2, 0x909F },
        { 0x9DEC, 0x90A0 },
        { 0x9DF4, 0x90A1 },
        { 0x9DF3, 0x90A2 },
        { 0x9DE8, 0x90A3 },
        { 0x9DED, 0x90A4 },
        { 0x9EC2, 0x90A5 },
        { 0x9ED0, 0x90A6 },
        { 0x9EF2, 0x90A7 },
        { 0x9EF3, 0x90A8 },
        { 0x9F06, 0x90A9 },
        { 0x9F1C, 0x90AA },
        { 0x9F38, 0x90AB },
        { 0x9F37, 0x90AC },
        { 0x9F36, 0x90AD },
        { 0x9F43, 0x90AE },
        { 0x9F4F, 0x90AF },
        { 0x9F71, 0x90B0 },
        { 0x9F70, 0x90B1 },
        { 0x9F6E, 0x90B2 },
        { 0x9F6F, 0x90B3 },
        { 0x56D3, 0x90B4 },
        { 0x56CD, 0x90B5 },
        { 0x5B4E, 0x90B6 },
        { 0x5C6D, 0x90B7 },
        { 0x652D, 0x90B8 },
        { 0x66ED, 0x90B9 },
        { 0x66EE, 0x90BA },
        { 0x6B13, 0x90BB },
        { 0x705F, 0x90BC },
        { 0x7061, 0x90BD },
        { 0x705D, 0x90BE },
        { 0x7060, 0x90BF },
        { 0x7223, 0x90C0 },
        { 0x74DB, 0x90C1 },
        { 0x74E5, 0x90C2 },
        { 0x77D5, 0x90C3 },
        { 0x7938, 0x90C4 },
        { 0x79B7, 0x90C5 },
        { 0x79B6, 0x90C6 },
        { 0x7C6A, 0x90C7 },
        { 0x7E97, 0x90C8 },
        { 0x7F89, 0x90C9 },
        { 0x826D, 0x90CA },
        { 0x8643, 0x90CB },
        { 0x8838, 0x90CC },
        { 0x8837, 0x90CD },
        { 0x8835, 0x90CE },
        { 0x884B, 0x90CF },
        { 0x8B94, 0x90D0 },
        { 0x8B95, 0x90D1 },
        { 0x8E9E, 0x90D2 },
        { 0x8E9F, 0x90D3 },
        { 0x8EA0, 0x90D4 },
        { 0x8E9D, 0x90D5 },
        { 0x91BE, 0x90D6 },
        { 0x91BD, 0x90D7 },
        { 0x91C2, 0x90D8 },
        { 0x946B, 0x90D9 },
        { 0x9468, 0x90DA },
        { 0x9469, 0x90DB },
        { 0x96E5, 0x90DC },
        { 0x9746, 0x90DD },
        { 0x9743, 0x90DE },
        { 0x9747, 0x90DF },
        { 0x97C7, 0x90E0 },
        { 0x97E5, 0x90E1 },
        { 0x9A5E, 0x90E2 },
        { 0x9AD5, 0x90E3 },
        { 0x9B59, 0x90E4 },
        { 0x9C63, 0x90E5 },
        { 0x9C67, 0x90E6 },
        { 0x9C66, 0x90E7 },
        { 0x9C62, 0x90E8 },
        { 0x9C5E, 0x90E9 },
        { 0x9C60, 0x90EA },
        { 0x9E02, 0x90EB },
        { 0x9DFE, 0x90EC },
        { 0x9E07, 0x90ED },
        { 0x9E03, 0x90EE },
        { 0x9E06, 0x90EF },
        { 0x9E05, 0x90F0 },
        { 0x9E00, 0x90F1 },
        { 0x9E01, 0x90F2 },
        { 0x9E09, 0x90F3 },
        { 0x9DFF, 0x90F4 },
        { 0x9DFD, 0x90F5 },
        { 0x9E04, 0x90F6 },
        { 0x9EA0, 0x90F7 },
        { 0x9F1E, 0x90F8 },
        { 0x9F46, 0x90F9 },
        { 0x9F74, 0x90FA },
        { 0x9F75, 0x90FB },
        { 0x9F76, 0x90FC },
        { 0x56D4, 0x90FD },
        { 0x652E, 0x9141 },
        { 0x65B8, 0x9142 },
        { 0x6B18, 0x9143 },
        { 0x6B19, 0x9144 },
        { 0x6B17, 0x9145 },
        { 0x6B1A, 0x9146 },
        { 0x7062, 0x9147 },
        { 0x7226, 0x9148 },
        { 0x72AA, 0x9149 },
        { 0x77D8, 0x914A },
        { 0x77D9, 0x914B },
        { 0x7939, 0x914C },
        { 0x7C69, 0x914D },
        { 0x7C6B, 0x914E },
        { 0x7CF6, 0x914F },
        { 0x7E9A, 0x9150 },
        { 0x7E98, 0x9151 },
        { 0x7E9B, 0x9152 },
        { 0x7E99, 0x9153 },
        { 0x81E0, 0x9154 },
        { 0x81E1, 0x9155 },
        { 0x8646, 0x9156 },
        { 0x8647, 0x9157 },
        { 0x8648, 0x9158 },
        { 0x8979, 0x9159 },
        { 0x897A, 0x915A },
        { 0x897C, 0x915B },
        { 0x897B, 0x915C },
        { 0x89FF, 0x915D },
        { 0x8B98, 0x915E },
        { 0x8B99, 0x915F },
        { 0x8EA5, 0x9160 },
        { 0x8EA4, 0x9161 },
        { 0x8EA3, 0x9162 },
        { 0x946E, 0x9163 },
        { 0x946D, 0x9164 },
        { 0x946F, 0x9165 },
        { 0x9471, 0x9166 },
        { 0x9473, 0x9167 },
        { 0x9749, 0x9168 },
        { 0x9872, 0x9169 },
        { 0x995F, 0x916A },
        { 0x9C68, 0x916B },
        { 0x9C6E, 0x916C },
        { 0x9C6D, 0x916D },
        { 0x9E0B, 0x916E },
        { 0x9E0D, 0x916F },
        { 0x9E10, 0x9170 },
        { 0x9E0F, 0x9171 },
        { 0x9E12, 0x9172 },
        { 0x9E11, 0x9173 },
        { 0x9EA1, 0x9174 },
        { 0x9EF5, 0x9175 },
        { 0x9F09, 0x9176 },
        { 0x9F47, 0x9177 },
        { 0x9F78, 0x9178 },
        { 0x9F7B, 0x9179 },
        { 0x9F7A, 0x917A },
        { 0x9F79, 0x917B },
        { 0x571E, 0x917C },
        { 0x7066, 0x917D },
        { 0x7C6F, 0x917E },
        { 0x883C, 0x917F },
        { 0x8DB2, 0x9181 },
        { 0x8EA6, 0x9182 },
        { 0x91C3, 0x9183 },
        { 0x9474, 0x9184 },
        { 0x9478, 0x9185 },
        { 0x9476, 0x9186 },
        { 0x9475, 0x9187 },
        { 0x9A60, 0x9188 },
        { 0x9C74, 0x9189 },
        { 0x9C73, 0x918A },
        { 0x9C71, 0x918B },
        { 0x9C75, 0x918C },
        { 0x9E14, 0x918D },
        { 0x9E13, 0x918E },
        { 0x9EF6, 0x918F },
        { 0x9F0A, 0x9190 },
        { 0x9FA4, 0x9191 },
        { 0x7068, 0x9192 },
        { 0x7065, 0x9193 },
        { 0x7CF7, 0x9194 },
        { 0x866A, 0x9195 },
        { 0x883E, 0x9196 },
        { 0x883D, 0x9197 },
        { 0x883F, 0x9198 },
        { 0x8B9E, 0x9199 },
        { 0x8C9C, 0x919A },
        { 0x8EA9, 0x919B },
        { 0x8EC9, 0x919C },
        { 0x974B, 0x919D },
        { 0x9873, 0x919E },
        { 0x9874, 0x919F },
        { 0x98CC, 0x91A0 },
        { 0x9961, 0x91A1 },
        { 0x99AB, 0x91A2 },
        { 0x9A64, 0x91A3 },
        { 0x9A66, 0x91A4 },
        { 0x9A67, 0x91A5 },
        { 0x9B24, 0x91A6 },
        { 0x9E15, 0x91A7 },
        { 0x9E17, 0x91A8 },
        { 0x9F48, 0x91A9 },
        { 0x6207, 0x91AA },
        { 0x6B1E, 0x91AB },
        { 0x7227, 0x91AC },
        { 0x864C, 0x91AD },
        { 0x8EA8, 0x91AE },
        { 0x9482, 0x91AF },
        { 0x9480, 0x91B0 },
        { 0x9481, 0x91B1 },
        { 0x9A69, 0x91B2 },
        { 0x9A68, 0x91B3 },
        { 0x9B2E, 0x91B4 },
        { 0x9E19, 0x91B5 },
        { 0x7229, 0x91B6 },
        { 0x864B, 0x91B7 },
        { 0x8B9F, 0x91B8 },
        { 0x9483, 0x91B9 },
        { 0x9C79, 0x91BA },
        { 0x9EB7, 0x91BB },
        { 0x7675, 0x91BC },
        { 0x9A6B, 0x91BD },
        { 0x9C7A, 0x91BE },
        { 0x9E1D, 0x91BF },
        { 0x7069, 0x91C0 },
        { 0x706A, 0x91C1 },
        { 0x9EA4, 0x91C2 },
        { 0x9F7E, 0x91C3 },
        { 0x9F49, 0x91C4 },
        { 0x9F98, 0x91C5 },
        { 0x688A, 0x91C6 },
        { 0x6EB9, 0x91C7 },
        { 0xE000, 0xC241 },
        { 0xE001, 0xC242 },
        { 0xE002, 0xC243 },
        { 0xE003, 0xC244 },
        { 0xE004, 0xC245 },
        { 0xE005, 0xC246 },
        { 0xE006, 0xC247 },
        { 0xE007, 0xC248 },
        { 0xE008, 0xC249 },
        { 0xE009, 0xC24A },
        { 0xE00A, 0xC24B },
        { 0xE00B, 0xC24C },
        { 0xE00C, 0xC24D },
        { 0xE00D, 0xC24E },
        { 0xE00E, 0xC24F },
        { 0xE00F, 0xC250 },
        { 0xE010, 0xC251 },
        { 0xE011, 0xC252 },
        { 0xE012, 0xC253 },
        { 0xE013, 0xC254 },
        { 0xE014, 0xC255 },
        { 0xE015, 0xC256 },
        { 0xE016, 0xC257 },
        { 0xE017, 0xC258 },
        { 0xE018, 0xC259 },
        { 0xE019, 0xC25A },
        { 0xE01A, 0xC25B },
        { 0xE01B, 0xC25C },
        { 0xE01C, 0xC25D },
        { 0xE01D, 0xC25E },
        { 0xE01E, 0xC25F },
        { 0xE01F, 0xC260 },
        { 0xE020, 0xC261 },
        { 0xE021, 0xC262 },
        { 0xE022, 0xC263 },
        { 0xE023, 0xC264 },
        { 0xE024, 0xC265 },
        { 0xE025, 0xC266 },
        { 0xE026, 0xC267 },
        { 0xE027, 0xC268 },
        { 0xE028, 0xC269 },
        { 0xE029, 0xC26A },
        { 0xE02A, 0xC26B },
        { 0xE02B, 0xC26C },
        { 0xE02C, 0xC26D },
        { 0xE02D, 0xC26E },
        { 0xE02E, 0xC26F },
        { 0xE02F, 0xC270 },
        { 0xE030, 0xC271 },
        { 0xE031, 0xC272 },
        { 0xE032, 0xC273 },
        { 0xE033, 0xC274 },
        { 0xE034, 0xC275 },
        { 0xE035, 0xC276 },
        { 0xE036, 0xC277 },
        { 0xE037, 0xC278 },
        { 0xE038, 0xC279 },
        { 0xE039, 0xC27A },
        { 0xE03A, 0xC27B },
        { 0xE03B, 0xC27C },
        { 0xE03C, 0xC27D },
        { 0xE03D, 0xC27E },
        { 0xE03E, 0xC27F },
        { 0xE03F, 0xC281 },
        { 0xE040, 0xC282 },
        { 0xE041, 0xC283 },
        { 0xE042, 0xC284 },
        { 0xE043, 0xC285 },
        { 0xE044, 0xC286 },
        { 0xE045, 0xC287 },
        { 0xE046, 0xC288 },
        { 0xE047, 0xC289 },
        { 0xE048, 0xC28A },
        { 0xE049, 0xC28B },
        { 0xE04A, 0xC28C },
        { 0xE04B, 0xC28D },
        { 0xE04C, 0xC28E },
        { 0xE04D, 0xC28F },
        { 0xE04E, 0xC290 },
        { 0xE04F, 0xC291 },
        { 0xE050, 0xC292 },
        { 0xE051, 0xC293 },
        { 0xE052, 0xC294 },
        { 0xE053, 0xC295 },
        { 0xE054, 0xC296 },
        { 0xE055, 0xC297 },
        { 0xE056, 0xC298 },
        { 0xE057, 0xC299 },
        { 0xE058, 0xC29A },
        { 0xE059, 0xC29B },
        { 0xE05A, 0xC29C },
        { 0xE05B, 0xC29D },
        { 0xE05C, 0xC29E },
        { 0xE05D, 0xC29F },
        { 0xE05E, 0xC2A0 },
        { 0xE05F, 0xC2A1 },
        { 0xE060, 0xC2A2 },
        { 0xE061, 0xC2A3 },
        { 0xE062, 0xC2A4 },
        { 0xE063, 0xC2A5 },
        { 0xE064, 0xC2A6 },
        { 0xE065, 0xC2A7 },
        { 0xE066, 0xC2A8 },
        { 0xE067, 0xC2A9 },
        { 0xE068, 0xC2AA },
        { 0xE069, 0xC2AB },
        { 0xE06A, 0xC2AC },
        { 0xE06B, 0xC2AD },
        { 0xE06C, 0xC2AE },
        { 0xE06D, 0xC2AF },
        { 0xE06E, 0xC2B0 },
        { 0xE06F, 0xC2B1 },
        { 0xE070, 0xC2B2 },
        { 0xE071, 0xC2B3 },
        { 0xE072, 0xC2B4 },
        { 0xE073, 0xC2B5 },
        { 0xE074, 0xC2B6 },
        { 0xE075, 0xC2B7 },
        { 0xE076, 0xC2B8 },
        { 0xE077, 0xC2B9 },
        { 0xE078, 0xC2BA },
        { 0xE079, 0xC2BB },
        { 0xE07A, 0xC2BC },
        { 0xE07B, 0xC2BD },
        { 0xE07C, 0xC2BE },
        { 0xE07D, 0xC2BF },
        { 0xE07E, 0xC2C0 },
        { 0xE07F, 0xC2C1 },
        { 0xE080, 0xC2C2 },
        { 0xE081, 0xC2C3 },
        { 0xE082, 0xC2C4 },
        { 0xE083, 0xC2C5 },
        { 0xE084, 0xC2C6 },
        { 0xE085, 0xC2C7 },
        { 0xE086, 0xC2C8 },
        { 0xE087, 0xC2C9 },
        { 0xE088, 0xC2CA },
        { 0xE089, 0xC2CB },
        { 0xE08A, 0xC2CC },
        { 0xE08B, 0xC2CD },
        { 0xE08C, 0xC2CE },
        { 0xE08D, 0xC2CF },
        { 0xE08E, 0xC2D0 },
        { 0xE08F, 0xC2D1 },
        { 0xE090, 0xC2D2 },
        { 0xE091, 0xC2D3 },
        { 0xE092, 0xC2D4 },
        { 0xE093, 0xC2D5 },
        { 0xE094, 0xC2D6 },
        { 0xE095, 0xC2D7 },
        { 0xE096, 0xC2D8 },
        { 0xE097, 0xC2D9 },
        { 0xE098, 0xC2DA },
        { 0xE099, 0xC2DB },
        { 0xE09A, 0xC2DC },
        { 0xE09B, 0xC2DD },
        { 0xE09C, 0xC2DE },
        { 0xE09D, 0xC2DF },
        { 0xE09E, 0xC2E0 },
        { 0xE09F, 0xC2E1 },
        { 0xE0A0, 0xC2E2 },
        { 0xE0A1, 0xC2E3 },
        { 0xE0A2, 0xC2E4 },
        { 0xE0A3, 0xC2E5 },
        { 0xE0A4, 0xC2E6 },
        { 0xE0A5, 0xC2E7 },
        { 0xE0A6, 0xC2E8 },
        { 0xE0A7, 0xC2E9 },
        { 0xE0A8, 0xC2EA },
        { 0xE0A9, 0xC2EB },
        { 0xE0AA, 0xC2EC },
        { 0xE0AB, 0xC2ED },
        { 0xE0AC, 0xC2EE },
        { 0xE0AD, 0xC2EF },
        { 0xE0AE, 0xC2F0 },
        { 0xE0AF, 0xC2F1 },
        { 0xE0B0, 0xC2F2 },
        { 0xE0B1, 0xC2F3 },
        { 0xE0B2, 0xC2F4 },
        { 0xE0B3, 0xC2F5 },
        { 0xE0B4, 0xC2F6 },
        { 0xE0B5, 0xC2F7 },
        { 0xE0B6, 0xC2F8 },
        { 0xE0B7, 0xC2F9 },
        { 0xE0B8, 0xC2FA },
        { 0xE0B9, 0xC2FB },
        { 0xE0BA, 0xC2FC },
        { 0xE0BB, 0xC2FD },
        { 0xE0BC, 0xC341 },
        { 0xE0BD, 0xC342 },
        { 0xE0BE, 0xC343 },
        { 0xE0BF, 0xC344 },
        { 0xE0C0, 0xC345 },
        { 0xE0C1, 0xC346 },
        { 0xE0C2, 0xC347 },
        { 0xE0C3, 0xC348 },
        { 0xE0C4, 0xC349 },
        { 0xE0C5, 0xC34A },
        { 0xE0C6, 0xC34B },
        { 0xE0C7, 0xC34C },
        { 0xE0C8, 0xC34D },
        { 0xE0C9, 0xC34E },
        { 0xE0CA, 0xC34F },
        { 0xE0CB, 0xC350 },
        { 0xE0CC, 0xC351 },
        { 0xE0CD, 0xC352 },
        { 0xE0CE, 0xC353 },
        { 0xE0CF, 0xC354 },
        { 0xE0D0, 0xC355 },
        { 0xE0D1, 0xC356 },
        { 0xE0D2, 0xC357 },
        { 0xE0D3, 0xC358 },
        { 0xE0D4, 0xC359 },
        { 0xE0D5, 0xC35A },
        { 0xE0D6, 0xC35B },
        { 0xE0D7, 0xC35C },
        { 0xE0D8, 0xC35D },
        { 0xE0D9, 0xC35E },
        { 0xE0DA, 0xC35F },
        { 0xE0DB, 0xC360 },
        { 0xE0DC, 0xC361 },
        { 0xE0DD, 0xC362 },
        { 0xE0DE, 0xC363 },
        { 0xE0DF, 0xC364 },
        { 0xE0E0, 0xC365 },
        { 0xE0E1, 0xC366 },
        { 0xE0E2, 0xC367 },
        { 0xE0E3, 0xC368 },
        { 0xE0E4, 0xC369 },
        { 0xE0E5, 0xC36A },
        { 0xE0E6, 0xC36B },
        { 0xE0E7, 0xC36C },
        { 0xE0E8, 0xC36D },
        { 0xE0E9, 0xC36E },
        { 0xE0EA, 0xC36F },
        { 0xE0EB, 0xC370 },
        { 0xE0EC, 0xC371 },
        { 0xE0ED, 0xC372 },
        { 0xE0EE, 0xC373 },
        { 0xE0EF, 0xC374 },
        { 0xE0F0, 0xC375 },
        { 0xE0F1, 0xC376 },
        { 0xE0F2, 0xC377 },
        { 0xE0F3, 0xC378 },
        { 0xE0F4, 0xC379 },
        { 0xE0F5, 0xC37A },
        { 0xE0F6, 0xC37B },
        { 0xE0F7, 0xC37C },
        { 0xE0F8, 0xC37D },
        { 0xE0F9, 0xC37E },
        { 0xE0FA, 0xC37F },
        { 0xE0FB, 0xC381 },
        { 0xE0FC, 0xC382 },
        { 0xE0FD, 0xC383 },
        { 0xE0FE, 0xC384 },
        { 0xE0FF, 0xC385 },
        { 0xE100, 0xC386 },
        { 0xE101, 0xC387 },
        { 0xE102, 0xC388 },
        { 0xE103, 0xC389 },
        { 0xE104, 0xC38A },
        { 0xE105, 0xC38B },
        { 0xE106, 0xC38C },
        { 0xE107, 0xC38D },
        { 0xE108, 0xC38E },
        { 0xE109, 0xC38F },
        { 0xE10A, 0xC390 },
        { 0xE10B, 0xC391 },
        { 0xE10C, 0xC392 },
        { 0xE10D, 0xC393 },
        { 0xE10E, 0xC394 },
        { 0xE10F, 0xC395 },
        { 0xE110, 0xC396 },
        { 0xE111, 0xC397 },
        { 0xE112, 0xC398 },
        { 0xE113, 0xC399 },
        { 0xE114, 0xC39A },
        { 0xE115, 0xC39B },
        { 0xE116, 0xC39C },
        { 0xE117, 0xC39D },
        { 0xE118, 0xC39E },
        { 0xE119, 0xC39F },
        { 0xE11A, 0xC3A0 },
        { 0xE11B, 0xC3A1 },
        { 0xE11C, 0xC3A2 },
        { 0xE11D, 0xC3A3 },
        { 0xE11E, 0xC3A4 },
        { 0xE11F, 0xC3A5 },
        { 0xE120, 0xC3A6 },
        { 0xE121, 0xC3A7 },
        { 0xE122, 0xC3A8 },
        { 0xE123, 0xC3A9 },
        { 0xE124, 0xC3AA },
        { 0xE125, 0xC3AB },
        { 0xE126, 0xC3AC },
        { 0xE127, 0xC3AD },
        { 0xE128, 0xC3AE },
        { 0xE129, 0xC3AF },
        { 0xE12A, 0xC3B0 },
        { 0xE12B, 0xC3B1 },
        { 0xE12C, 0xC3B2 },
        { 0xE12D, 0xC3B3 },
        { 0xE12E, 0xC3B4 },
        { 0xE12F, 0xC3B5 },
        { 0xE130, 0xC3B6 },
        { 0xE131, 0xC3B7 },
        { 0xE132, 0xC3B8 },
        { 0xE133, 0xC3B9 },
        { 0xE134, 0xC3BA },
        { 0xE135, 0xC3BB },
        { 0xE136, 0xC3BC },
        { 0xE137, 0xC3BD },
        { 0xE138, 0xC3BE },
        { 0xE139, 0xC3BF },
        { 0xE13A, 0xC3C0 },
        { 0xE13B, 0xC3C1 },
        { 0xE13C, 0xC3C2 },
        { 0xE13D, 0xC3C3 },
        { 0xE13E, 0xC3C4 },
        { 0xE13F, 0xC3C5 },
        { 0xE140, 0xC3C6 },
        { 0xE141, 0xC3C7 },
        { 0xE142, 0xC3C8 },
        { 0xE143, 0xC3C9 },
        { 0xE144, 0xC3CA },
        { 0xE145, 0xC3CB },
        { 0xE146, 0xC3CC },
        { 0xE147, 0xC3CD },
        { 0xE148, 0xC3CE },
        { 0xE149, 0xC3CF },
        { 0xE14A, 0xC3D0 },
        { 0xE14B, 0xC3D1 },
        { 0xE14C, 0xC3D2 },
        { 0xE14D, 0xC3D3 },
        { 0xE14E, 0xC3D4 },
        { 0xE14F, 0xC3D5 },
        { 0xE150, 0xC3D6 },
        { 0xE151, 0xC3D7 },
        { 0xE152, 0xC3D8 },
        { 0xE153, 0xC3D9 },
        { 0xE154, 0xC3DA },
        { 0xE155, 0xC3DB },
        { 0xE156, 0xC3DC },
        { 0xE157, 0xC3DD },
        { 0xE158, 0xC3DE },
        { 0xE159, 0xC3DF },
        { 0xE15A, 0xC3E0 },
        { 0xE15B, 0xC3E1 },
        { 0xE15C, 0xC3E2 },
        { 0xE15D, 0xC3E3 },
        { 0xE15E, 0xC3E4 },
        { 0xE15F, 0xC3E5 },
        { 0xE160, 0xC3E6 },
        { 0xE161, 0xC3E7 },
        { 0xE162, 0xC3E8 },
        { 0xE163, 0xC3E9 },
        { 0xE164, 0xC3EA },
        { 0xE165, 0xC3EB },
        { 0xE166, 0xC3EC },
        { 0xE167, 0xC3ED },
        { 0xE168, 0xC3EE },
        { 0xE169, 0xC3EF },
        { 0xE16A, 0xC3F0 },
        { 0xE16B, 0xC3F1 },
        { 0xE16C, 0xC3F2 },
        { 0xE16D, 0xC3F3 },
        { 0xE16E, 0xC3F4 },
        { 0xE16F, 0xC3F5 },
        { 0xE170, 0xC3F6 },
        { 0xE171, 0xC3F7 },
        { 0xE172, 0xC3F8 },
        { 0xE173, 0xC3F9 },
        { 0xE174, 0xC3FA },
        { 0xE175, 0xC3FB },
        { 0xE176, 0xC3FC },
        { 0xE177, 0xC3FD },
        { 0xE178, 0xC441 },
        { 0xE179, 0xC442 },
        { 0xE17A, 0xC443 },
        { 0xE17B, 0xC444 },
        { 0xE17C, 0xC445 },
        { 0xE17D, 0xC446 },
        { 0xE17E, 0xC447 },
        { 0xE17F, 0xC448 },
        { 0xE180, 0xC449 },
        { 0xE181, 0xC44A },
        { 0xE182, 0xC44B },
        { 0xE183, 0xC44C },
        { 0xE184, 0xC44D },
        { 0xE185, 0xC44E },
        { 0xE186, 0xC44F },
        { 0xE187, 0xC450 },
        { 0xE188, 0xC451 },
        { 0xE189, 0xC452 },
        { 0xE18A, 0xC453 },
        { 0xE18B, 0xC454 },
        { 0xE18C, 0xC455 },
        { 0xE18D, 0xC456 },
        { 0xE18E, 0xC457 },
        { 0xE18F, 0xC458 },
        { 0xE190, 0xC459 },
        { 0xE191, 0xC45A },
        { 0xE192, 0xC45B },
        { 0xE193, 0xC45C },
        { 0xE194, 0xC45D },
        { 0xE195, 0xC45E },
        { 0xE196, 0xC45F },
        { 0xE197, 0xC460 },
        { 0xE198, 0xC461 },
        { 0xE199, 0xC462 },
        { 0xE19A, 0xC463 },
        { 0xE19B, 0xC464 },
        { 0xE19C, 0xC465 },
        { 0xE19D, 0xC466 },
        { 0xE19E, 0xC467 },
        { 0xE19F, 0xC468 },
        { 0xE1A0, 0xC469 },
        { 0xE1A1, 0xC46A },
        { 0xE1A2, 0xC46B },
        { 0xE1A3, 0xC46C },
        { 0xE1A4, 0xC46D },
        { 0xE1A5, 0xC46E },
        { 0xE1A6, 0xC46F },
        { 0xE1A7, 0xC470 },
        { 0xE1A8, 0xC471 },
        { 0xE1A9, 0xC472 },
        { 0xE1AA, 0xC473 },
        { 0xE1AB, 0xC474 },
        { 0xE1AC, 0xC475 },
        { 0xE1AD, 0xC476 },
        { 0xE1AE, 0xC477 },
        { 0xE1AF, 0xC478 },
        { 0xE1B0, 0xC479 },
        { 0xE1B1, 0xC47A },
        { 0xE1B2, 0xC47B },
        { 0xE1B3, 0xC47C },
        { 0xE1B4, 0xC47D },
        { 0xE1B5, 0xC47E },
        { 0xE1B6, 0xC47F },
        { 0xE1B7, 0xC481 },
        { 0xE1B8, 0xC482 },
        { 0xE1B9, 0xC483 },
        { 0xE1BA, 0xC484 },
        { 0xE1BB, 0xC485 },
        { 0xE1BC, 0xC486 },
        { 0xE1BD, 0xC487 },
        { 0xE1BE, 0xC488 },
        { 0xE1BF, 0xC489 },
        { 0xE1C0, 0xC48A },
        { 0xE1C1, 0xC48B },
        { 0xE1C2, 0xC48C },
        { 0xE1C3, 0xC48D },
        { 0xE1C4, 0xC48E },
        { 0xE1C5, 0xC48F },
        { 0xE1C6, 0xC490 },
        { 0xE1C7, 0xC491 },
        { 0xE1C8, 0xC492 },
        { 0xE1C9, 0xC493 },
        { 0xE1CA, 0xC494 },
        { 0xE1CB, 0xC495 },
        { 0xE1CC, 0xC496 },
        { 0xE1CD, 0xC497 },
        { 0xE1CE, 0xC498 },
        { 0xE1CF, 0xC499 },
        { 0xE1D0, 0xC49A },
        { 0xE1D1, 0xC49B },
        { 0xE1D2, 0xC49C },
        { 0xE1D3, 0xC49D },
        { 0xE1D4, 0xC49E },
        { 0xE1D5, 0xC49F },
        { 0xE1D6, 0xC4A0 },
        { 0xE1D7, 0xC4A1 },
        { 0xE1D8, 0xC4A2 },
        { 0xE1D9, 0xC4A3 },
        { 0xE1DA, 0xC4A4 },
        { 0xE1DB, 0xC4A5 },
        { 0xE1DC, 0xC4A6 },
        { 0xE1DD, 0xC4A7 },
        { 0xE1DE, 0xC4A8 },
        { 0xE1DF, 0xC4A9 },
        { 0xE1E0, 0xC4AA },
        { 0xE1E1, 0xC4AB },
        { 0xE1E2, 0xC4AC },
        { 0xE1E3, 0xC4AD },
        { 0xE1E4, 0xC4AE },
        { 0xE1E5, 0xC4AF },
        { 0xE1E6, 0xC4B0 },
        { 0xE1E7, 0xC4B1 },
        { 0xE1E8, 0xC4B2 },
        { 0xE1E9, 0xC4B3 },
        { 0xE1EA, 0xC4B4 },
        { 0xE1EB, 0xC4B5 },
        { 0xE1EC, 0xC4B6 },
        { 0xE1ED, 0xC4B7 },
        { 0xE1EE, 0xC4B8 },
        { 0xE1EF, 0xC4B9 },
        { 0xE1F0, 0xC4BA },
        { 0xE1F1, 0xC4BB },
        { 0xE1F2, 0xC4BC },
        { 0xE1F3, 0xC4BD },
        { 0xE1F4, 0xC4BE },
        { 0xE1F5, 0xC4BF },
        { 0xE1F6, 0xC4C0 },
        { 0xE1F7, 0xC4C1 },
        { 0xE1F8, 0xC4C2 },
        { 0xE1F9, 0xC4C3 },
        { 0xE1FA, 0xC4C4 },
        { 0xE1FB, 0xC4C5 },
        { 0xE1FC, 0xC4C6 },
        { 0xE1FD, 0xC4C7 },
        { 0xE1FE, 0xC4C8 },
        { 0xE1FF, 0xC4C9 },
        { 0xE200, 0xC4CA },
        { 0xE201, 0xC4CB },
        { 0xE202, 0xC4CC },
        { 0xE203, 0xC4CD },
        { 0xE204, 0xC4CE },
        { 0xE205, 0xC4CF },
        { 0xE206, 0xC4D0 },
        { 0xE207, 0xC4D1 },
        { 0xE208, 0xC4D2 },
        { 0xE209, 0xC4D3 },
        { 0xE20A, 0xC4D4 },
        { 0xE20B, 0xC4D5 },
        { 0xE20C, 0xC4D6 },
        { 0xE20D, 0xC4D7 },
        { 0xE20E, 0xC4D8 },
        { 0xE20F, 0xC4D9 },
        { 0xE210, 0xC4DA },
        { 0xE211, 0xC4DB },
        { 0xE212, 0xC4DC },
        { 0xE213, 0xC4DD },
        { 0xE214, 0xC4DE },
        { 0xE215, 0xC4DF },
        { 0xE216, 0xC4E0 },
        { 0xE217, 0xC4E1 },
        { 0xE218, 0xC4E2 },
        { 0xE219, 0xC4E3 },
        { 0xE21A, 0xC4E4 },
        { 0xE21B, 0xC4E5 },
        { 0xE21C, 0xC4E6 },
        { 0xE21D, 0xC4E7 },
        { 0xE21E, 0xC4E8 },
        { 0xE21F, 0xC4E9 },
        { 0xE220, 0xC4EA },
        { 0xE221, 0xC4EB },
        { 0xE222, 0xC4EC },
        { 0xE223, 0xC4ED },
        { 0xE224, 0xC4EE },
        { 0xE225, 0xC4EF },
        { 0xE226, 0xC4F0 },
        { 0xE227, 0xC4F1 },
        { 0xE228, 0xC4F2 },
        { 0xE229, 0xC4F3 },
        { 0xE22A, 0xC4F4 },
        { 0xE22B, 0xC4F5 },
        { 0xE22C, 0xC4F6 },
        { 0xE22D, 0xC4F7 },
        { 0xE22E, 0xC4F8 },
        { 0xE22F, 0xC4F9 },
        { 0xE230, 0xC4FA },
        { 0xE231, 0xC4FB },
        { 0xE232, 0xC4FC },
        { 0xE233, 0xC4FD },
        { 0xE234, 0xC541 },
        { 0xE235, 0xC542 },
        { 0xE236, 0xC543 },
        { 0xE237, 0xC544 },
        { 0xE238, 0xC545 },
        { 0xE239, 0xC546 },
        { 0xE23A, 0xC547 },
        { 0xE23B, 0xC548 },
        { 0xE23C, 0xC549 },
        { 0xE23D, 0xC54A },
        { 0xE23E, 0xC54B },
        { 0xE23F, 0xC54C },
        { 0xE240, 0xC54D },
        { 0xE241, 0xC54E },
        { 0xE242, 0xC54F },
        { 0xE243, 0xC550 },
        { 0xE244, 0xC551 },
        { 0xE245, 0xC552 },
        { 0xE246, 0xC553 },
        { 0xE247, 0xC554 },
        { 0xE248, 0xC555 },
        { 0xE249, 0xC556 },
        { 0xE24A, 0xC557 },
        { 0xE24B, 0xC558 },
        { 0xE24C, 0xC559 },
        { 0xE24D, 0xC55A },
        { 0xE24E, 0xC55B },
        { 0xE24F, 0xC55C },
        { 0xE250, 0xC55D },
        { 0xE251, 0xC55E },
        { 0xE252, 0xC55F },
        { 0xE253, 0xC560 },
        { 0xE254, 0xC561 },
        { 0xE255, 0xC562 },
        { 0xE256, 0xC563 },
        { 0xE257, 0xC564 },
        { 0xE258, 0xC565 },
        { 0xE259, 0xC566 },
        { 0xE25A, 0xC567 },
        { 0xE25B, 0xC568 },
        { 0xE25C, 0xC569 },
        { 0xE25D, 0xC56A },
        { 0xE25E, 0xC56B },
        { 0xE25F, 0xC56C },
        { 0xE260, 0xC56D },
        { 0xE261, 0xC56E },
        { 0xE262, 0xC56F },
        { 0xE263, 0xC570 },
        { 0xE264, 0xC571 },
        { 0xE265, 0xC572 },
        { 0xE266, 0xC573 },
        { 0xE267, 0xC574 },
        { 0xE268, 0xC575 },
        { 0xE269, 0xC576 },
        { 0xE26A, 0xC577 },
        { 0xE26B, 0xC578 },
        { 0xE26C, 0xC579 },
        { 0xE26D, 0xC57A },
        { 0xE26E, 0xC57B },
        { 0xE26F, 0xC57C },
        { 0xE270, 0xC57D },
        { 0xE271, 0xC57E },
        { 0xE272, 0xC57F },
        { 0xE273, 0xC581 },
        { 0xE274, 0xC582 },
        { 0xE275, 0xC583 },
        { 0xE276, 0xC584 },
        { 0xE277, 0xC585 },
        { 0xE278, 0xC586 },
        { 0xE279, 0xC587 },
        { 0xE27A, 0xC588 },
        { 0xE27B, 0xC589 },
        { 0xE27C, 0xC58A },
        { 0xE27D, 0xC58B },
        { 0xE27E, 0xC58C },
        { 0xE27F, 0xC58D },
        { 0xE280, 0xC58E },
        { 0xE281, 0xC58F },
        { 0xE282, 0xC590 },
        { 0xE283, 0xC591 },
        { 0xE284, 0xC592 },
        { 0xE285, 0xC593 },
        { 0xE286, 0xC594 },
        { 0xE287, 0xC595 },
        { 0xE288, 0xC596 },
        { 0xE289, 0xC597 },
        { 0xE28A, 0xC598 },
        { 0xE28B, 0xC599 },
        { 0xE28C, 0xC59A },
        { 0xE28D, 0xC59B },
        { 0xE28E, 0xC59C },
        { 0xE28F, 0xC59D },
        { 0xE290, 0xC59E },
        { 0xE291, 0xC59F },
        { 0xE292, 0xC5A0 },
        { 0xE293, 0xC5A1 },
        { 0xE294, 0xC5A2 },
        { 0xE295, 0xC5A3 },
        { 0xE296, 0xC5A4 },
        { 0xE297, 0xC5A5 },
        { 0xE298, 0xC5A6 },
        { 0xE299, 0xC5A7 },
        { 0xE29A, 0xC5A8 },
        { 0xE29B, 0xC5A9 },
        { 0xE29C, 0xC5AA },
        { 0xE29D, 0xC5AB },
        { 0xE29E, 0xC5AC },
        { 0xE29F, 0xC5AD },
        { 0xE2A0, 0xC5AE },
        { 0xE2A1, 0xC5AF },
        { 0xE2A2, 0xC5B0 },
        { 0xE2A3, 0xC5B1 },
        { 0xE2A4, 0xC5B2 },
        { 0xE2A5, 0xC5B3 },
        { 0xE2A6, 0xC5B4 },
        { 0xE2A7, 0xC5B5 },
        { 0xE2A8, 0xC5B6 },
        { 0xE2A9, 0xC5B7 },
        { 0xE2AA, 0xC5B8 },
        { 0xE2AB, 0xC5B9 },
        { 0xE2AC, 0xC5BA },
        { 0xE2AD, 0xC5BB },
        { 0xE2AE, 0xC5BC },
        { 0xE2AF, 0xC5BD },
        { 0xE2B0, 0xC5BE },
        { 0xE2B1, 0xC5BF },
        { 0xE2B2, 0xC5C0 },
        { 0xE2B3, 0xC5C1 },
        { 0xE2B4, 0xC5C2 },
        { 0xE2B5, 0xC5C3 },
        { 0xE2B6, 0xC5C4 },
        { 0xE2B7, 0xC5C5 },
        { 0xE2B8, 0xC5C6 },
        { 0xE2B9, 0xC5C7 },
        { 0xE2BA, 0xC5C8 },
        { 0xE2BB, 0xC5C9 },
        { 0xE2BC, 0xC5CA },
        { 0xE2BD, 0xC5CB },
        { 0xE2BE, 0xC5CC },
        { 0xE2BF, 0xC5CD },
        { 0xE2C0, 0xC5CE },
        { 0xE2C1, 0xC5CF },
        { 0xE2C2, 0xC5D0 },
        { 0xE2C3, 0xC5D1 },
        { 0xE2C4, 0xC5D2 },
        { 0xE2C5, 0xC5D3 },
        { 0xE2C6, 0xC5D4 },
        { 0xE2C7, 0xC5D5 },
        { 0xE2C8, 0xC5D6 },
        { 0xE2C9, 0xC5D7 },
        { 0xE2CA, 0xC5D8 },
        { 0xE2CB, 0xC5D9 },
        { 0xE2CC, 0xC5DA },
        { 0xE2CD, 0xC5DB },
        { 0xE2CE, 0xC5DC },
        { 0xE2CF, 0xC5DD },
        { 0xE2D0, 0xC5DE },
        { 0xE2D1, 0xC5DF },
        { 0xE2D2, 0xC5E0 },
        { 0xE2D3, 0xC5E1 },
        { 0xE2D4, 0xC5E2 },
        { 0xE2D5, 0xC5E3 },
        { 0xE2D6, 0xC5E4 },
        { 0xE2D7, 0xC5E5 },
        { 0xE2D8, 0xC5E6 },
        { 0xE2D9, 0xC5E7 },
        { 0xE2DA, 0xC5E8 },
        { 0xE2DB, 0xC5E9 },
        { 0xE2DC, 0xC5EA },
        { 0xE2DD, 0xC5EB },
        { 0xE2DE, 0xC5EC },
        { 0xE2DF, 0xC5ED },
        { 0xE2E0, 0xC5EE },
        { 0xE2E1, 0xC5EF },
        { 0xE2E2, 0xC5F0 },
        { 0xE2E3, 0xC5F1 },
        { 0xE2E4, 0xC5F2 },
        { 0xE2E5, 0xC5F3 },
        { 0xE2E6, 0xC5F4 },
        { 0xE2E7, 0xC5F5 },
        { 0xE2E8, 0xC5F6 },
        { 0xE2E9, 0xC5F7 },
        { 0xE2EA, 0xC5F8 },
        { 0xE2EB, 0xC5F9 },
        { 0xE2EC, 0xC5FA },
        { 0xE2ED, 0xC5FB },
        { 0xE2EE, 0xC5FC },
        { 0xE2EF, 0xC5FD },
        { 0xE2F0, 0xC641 },
        { 0xE2F1, 0xC642 },
        { 0xE2F2, 0xC643 },
        { 0xE2F3, 0xC644 },
        { 0xE2F4, 0xC645 },
        { 0xE2F5, 0xC646 },
        { 0xE2F6, 0xC647 },
        { 0xE2F7, 0xC648 },
        { 0xE2F8, 0xC649 },
        { 0xE2F9, 0xC64A },
        { 0xE2FA, 0xC64B },
        { 0xE2FB, 0xC64C },
        { 0xE2FC, 0xC64D },
        { 0xE2FD, 0xC64E },
        { 0xE2FE, 0xC64F },
        { 0xE2FF, 0xC650 },
        { 0xE300, 0xC651 },
        { 0xE301, 0xC652 },
        { 0xE302, 0xC653 },
        { 0xE303, 0xC654 },
        { 0xE304, 0xC655 },
        { 0xE305, 0xC656 },
        { 0xE306, 0xC657 },
        { 0xE307, 0xC658 },
        { 0xE308, 0xC659 },
        { 0xE309, 0xC65A },
        { 0xE30A, 0xC65B },
        { 0xE30B, 0xC65C },
        { 0xE30C, 0xC65D },
        { 0xE30D, 0xC65E },
        { 0xE30E, 0xC65F },
        { 0xE30F, 0xC660 },
        { 0xE310, 0xC661 },
        { 0xE311, 0xC662 },
        { 0xE312, 0xC663 },
        { 0xE313, 0xC664 },
        { 0xE314, 0xC665 },
        { 0xE315, 0xC666 },
        { 0xE316, 0xC667 },
        { 0xE317, 0xC668 },
        { 0xE318, 0xC669 },
        { 0xE319, 0xC66A },
        { 0xE31A, 0xC66B },
        { 0xE31B, 0xC66C },
        { 0xE31C, 0xC66D },
        { 0xE31D, 0xC66E },
        { 0xE31E, 0xC66F },
        { 0xE31F, 0xC670 },
        { 0xE320, 0xC671 },
        { 0xE321, 0xC672 },
        { 0xE322, 0xC673 },
        { 0xE323, 0xC674 },
        { 0xE324, 0xC675 },
        { 0xE325, 0xC676 },
        { 0xE326, 0xC677 },
        { 0xE327, 0xC678 },
        { 0xE328, 0xC679 },
        { 0xE329, 0xC67A },
        { 0xE32A, 0xC67B },
        { 0xE32B, 0xC67C },
        { 0xE32C, 0xC67D },
        { 0xE32D, 0xC67E },
        { 0xE32E, 0xC67F },
        { 0xE32F, 0xC681 },
        { 0xE330, 0xC682 },
        { 0xE331, 0xC683 },
        { 0xE332, 0xC684 },
        { 0xE333, 0xC685 },
        { 0xE334, 0xC686 },
        { 0xE335, 0xC687 },
        { 0xE336, 0xC688 },
        { 0xE337, 0xC689 },
        { 0xE338, 0xC68A },
        { 0xE339, 0xC68B },
        { 0xE33A, 0xC68C },
        { 0xE33B, 0xC68D },
        { 0xE33C, 0xC68E },
        { 0xE33D, 0xC68F },
        { 0xE33E, 0xC690 },
        { 0xE33F, 0xC691 },
        { 0xE340, 0xC692 },
        { 0xE341, 0xC693 },
        { 0xE342, 0xC694 },
        { 0xE343, 0xC695 },
        { 0xE344, 0xC696 },
        { 0xE345, 0xC697 },
        { 0xE346, 0xC698 },
        { 0xE347, 0xC699 },
        { 0xE348, 0xC69A },
        { 0xE349, 0xC69B },
        { 0xE34A, 0xC69C },
        { 0xE34B, 0xC69D },
        { 0xE34C, 0xC69E },
        { 0xE34D, 0xC69F },
        { 0xE34E, 0xC6A0 },
        { 0xE34F, 0xC6A1 },
        { 0xE350, 0xC6A2 },
        { 0xE351, 0xC6A3 },
        { 0xE352, 0xC6A4 },
        { 0xE353, 0xC6A5 },
        { 0xE354, 0xC6A6 },
        { 0xE355, 0xC6A7 },
        { 0xE356, 0xC6A8 },
        { 0xE357, 0xC6A9 },
        { 0xE358, 0xC6AA },
        { 0xE359, 0xC6AB },
        { 0xE35A, 0xC6AC },
        { 0xE35B, 0xC6AD },
        { 0xE35C, 0xC6AE },
        { 0xE35D, 0xC6AF },
        { 0xE35E, 0xC6B0 },
        { 0xE35F, 0xC6B1 },
        { 0xE360, 0xC6B2 },
        { 0xE361, 0xC6B3 },
        { 0xE362, 0xC6B4 },
        { 0xE363, 0xC6B5 },
        { 0xE364, 0xC6B6 },
        { 0xE365, 0xC6B7 },
        { 0xE366, 0xC6B8 },
        { 0xE367, 0xC6B9 },
        { 0xE368, 0xC6BA },
        { 0xE369, 0xC6BB },
        { 0xE36A, 0xC6BC },
        { 0xE36B, 0xC6BD },
        { 0xE36C, 0xC6BE },
        { 0xE36D, 0xC6BF },
        { 0xE36E, 0xC6C0 },
        { 0xE36F, 0xC6C1 },
        { 0xE370, 0xC6C2 },
        { 0xE371, 0xC6C3 },
        { 0xE372, 0xC6C4 },
        { 0xE373, 0xC6C5 },
        { 0xE374, 0xC6C6 },
        { 0xE375, 0xC6C7 },
        { 0xE376, 0xC6C8 },
        { 0xE377, 0xC6C9 },
        { 0xE378, 0xC6CA },
        { 0xE379, 0xC6CB },
        { 0xE37A, 0xC6CC },
        { 0xE37B, 0xC6CD },
        { 0xE37C, 0xC6CE },
        { 0xE37D, 0xC6CF },
        { 0xE37E, 0xC6D0 },
        { 0xE37F, 0xC6D1 },
        { 0xE380, 0xC6D2 },
        { 0xE381, 0xC6D3 },
        { 0xE382, 0xC6D4 },
        { 0xE383, 0xC6D5 },
        { 0xE384, 0xC6D6 },
        { 0xE385, 0xC6D7 },
        { 0xE386, 0xC6D8 },
        { 0xE387, 0xC6D9 },
        { 0xE388, 0xC6DA },
        { 0xE389, 0xC6DB },
        { 0xE38A, 0xC6DC },
        { 0xE38B, 0xC6DD },
        { 0xE38C, 0xC6DE },
        { 0xE38D, 0xC6DF },
        { 0xE38E, 0xC6E0 },
        { 0xE38F, 0xC6E1 },
        { 0xE390, 0xC6E2 },
        { 0xE391, 0xC6E3 },
        { 0xE392, 0xC6E4 },
        { 0xE393, 0xC6E5 },
        { 0xE394, 0xC6E6 },
        { 0xE395, 0xC6E7 },
        { 0xE396, 0xC6E8 },
        { 0xE397, 0xC6E9 },
        { 0xE398, 0xC6EA },
        { 0xE399, 0xC6EB },
        { 0xE39A, 0xC6EC },
        { 0xE39B, 0xC6ED },
        { 0xE39C, 0xC6EE },
        { 0xE39D, 0xC6EF },
        { 0xE39E, 0xC6F0 },
        { 0xE39F, 0xC6F1 },
        { 0xE3A0, 0xC6F2 },
        { 0xE3A1, 0xC6F3 },
        { 0xE3A2, 0xC6F4 },
        { 0xE3A3, 0xC6F5 },
        { 0xE3A4, 0xC6F6 },
        { 0xE3A5, 0xC6F7 },
        { 0xE3A6, 0xC6F8 },
        { 0xE3A7, 0xC6F9 },
        { 0xE3A8, 0xC6FA },
        { 0xE3A9, 0xC6FB },
        { 0xE3AA, 0xC6FC },
        { 0xE3AB, 0xC6FD },
        { 0xE3AC, 0xC741 },
        { 0xE3AD, 0xC742 },
        { 0xE3AE, 0xC743 },
        { 0xE3AF, 0xC744 },
        { 0xE3B0, 0xC745 },
        { 0xE3B1, 0xC746 },
        { 0xE3B2, 0xC747 },
        { 0xE3B3, 0xC748 },
        { 0xE3B4, 0xC749 },
        { 0xE3B5, 0xC74A },
        { 0xE3B6, 0xC74B },
        { 0xE3B7, 0xC74C },
        { 0xE3B8, 0xC74D },
        { 0xE3B9, 0xC74E },
        { 0xE3BA, 0xC74F },
        { 0xE3BB, 0xC750 },
        { 0xE3BC, 0xC751 },
        { 0xE3BD, 0xC752 },
        { 0xE3BE, 0xC753 },
        { 0xE3BF, 0xC754 },
        { 0xE3C0, 0xC755 },
        { 0xE3C1, 0xC756 },
        { 0xE3C2, 0xC757 },
        { 0xE3C3, 0xC758 },
        { 0xE3C4, 0xC759 },
        { 0xE3C5, 0xC75A },
        { 0xE3C6, 0xC75B },
        { 0xE3C7, 0xC75C },
        { 0xE3C8, 0xC75D },
        { 0xE3C9, 0xC75E },
        { 0xE3CA, 0xC75F },
        { 0xE3CB, 0xC760 },
        { 0xE3CC, 0xC761 },
        { 0xE3CD, 0xC762 },
        { 0xE3CE, 0xC763 },
        { 0xE3CF, 0xC764 },
        { 0xE3D0, 0xC765 },
        { 0xE3D1, 0xC766 },
        { 0xE3D2, 0xC767 },
        { 0xE3D3, 0xC768 },
        { 0xE3D4, 0xC769 },
        { 0xE3D5, 0xC76A },
        { 0xE3D6, 0xC76B },
        { 0xE3D7, 0xC76C },
        { 0xE3D8, 0xC76D },
        { 0xE3D9, 0xC76E },
        { 0xE3DA, 0xC76F },
        { 0xE3DB, 0xC770 },
        { 0xE3DC, 0xC771 },
        { 0xE3DD, 0xC772 },
        { 0xE3DE, 0xC773 },
        { 0xE3DF, 0xC774 },
        { 0xE3E0, 0xC775 },
        { 0xE3E1, 0xC776 },
        { 0xE3E2, 0xC777 },
        { 0xE3E3, 0xC778 },
        { 0xE3E4, 0xC779 },
        { 0xE3E5, 0xC77A },
        { 0xE3E6, 0xC77B },
        { 0xE3E7, 0xC77C },
        { 0xE3E8, 0xC77D },
        { 0xE3E9, 0xC77E },
        { 0xE3EA, 0xC77F },
        { 0xE3EB, 0xC781 },
        { 0xE3EC, 0xC782 },
        { 0xE3ED, 0xC783 },
        { 0xE3EE, 0xC784 },
        { 0xE3EF, 0xC785 },
        { 0xE3F0, 0xC786 },
        { 0xE3F1, 0xC787 },
        { 0xE3F2, 0xC788 },
        { 0xE3F3, 0xC789 },
        { 0xE3F4, 0xC78A },
        { 0xE3F5, 0xC78B },
        { 0xE3F6, 0xC78C },
        { 0xE3F7, 0xC78D },
        { 0xE3F8, 0xC78E },
        { 0xE3F9, 0xC78F },
        { 0xE3FA, 0xC790 },
        { 0xE3FB, 0xC791 },
        { 0xE3FC, 0xC792 },
        { 0xE3FD, 0xC793 },
        { 0xE3FE, 0xC794 },
        { 0xE3FF, 0xC795 },
        { 0xE400, 0xC796 },
        { 0xE401, 0xC797 },
        { 0xE402, 0xC798 },
        { 0xE403, 0xC799 },
        { 0xE404, 0xC79A },
        { 0xE405, 0xC79B },
        { 0xE406, 0xC79C },
        { 0xE407, 0xC79D },
        { 0xE408, 0xC79E },
        { 0xE409, 0xC79F },
        { 0xE40A, 0xC7A0 },
        { 0xE40B, 0xC7A1 },
        { 0xE40C, 0xC7A2 },
        { 0xE40D, 0xC7A3 },
        { 0xE40E, 0xC7A4 },
        { 0xE40F, 0xC7A5 },
        { 0xE410, 0xC7A6 },
        { 0xE411, 0xC7A7 },
        { 0xE412, 0xC7A8 },
        { 0xE413, 0xC7A9 },
        { 0xE414, 0xC7AA },
        { 0xE415, 0xC7AB },
        { 0xE416, 0xC7AC },
        { 0xE417, 0xC7AD },
        { 0xE418, 0xC7AE },
        { 0xE419, 0xC7AF },
        { 0xE41A, 0xC7B0 },
        { 0xE41B, 0xC7B1 },
        { 0xE41C, 0xC7B2 },
        { 0xE41D, 0xC7B3 },
        { 0xE41E, 0xC7B4 },
        { 0xE41F, 0xC7B5 },
        { 0xE420, 0xC7B6 },
        { 0xE421, 0xC7B7 },
        { 0xE422, 0xC7B8 },
        { 0xE423, 0xC7B9 },
        { 0xE424, 0xC7BA },
        { 0xE425, 0xC7BB },
        { 0xE426, 0xC7BC },
        { 0xE427, 0xC7BD },
        { 0xE428, 0xC7BE },
        { 0xE429, 0xC7BF },
        { 0xE42A, 0xC7C0 },
        { 0xE42B, 0xC7C1 },
        { 0xE42C, 0xC7C2 },
        { 0xE42D, 0xC7C3 },
        { 0xE42E, 0xC7C4 },
        { 0xE42F, 0xC7C5 },
        { 0xE430, 0xC7C6 },
        { 0xE431, 0xC7C7 },
        { 0xE432, 0xC7C8 },
        { 0xE433, 0xC7C9 },
        { 0xE434, 0xC7CA },
        { 0xE435, 0xC7CB },
        { 0xE436, 0xC7CC },
        { 0xE437, 0xC7CD },
        { 0xE438, 0xC7CE },
        { 0xE439, 0xC7CF },
        { 0xE43A, 0xC7D0 },
        { 0xE43B, 0xC7D1 },
        { 0xE43C, 0xC7D2 },
        { 0xE43D, 0xC7D3 },
        { 0xE43E, 0xC7D4 },
        { 0xE43F, 0xC7D5 },
        { 0xE440, 0xC7D6 },
        { 0xE441, 0xC7D7 },
        { 0xE442, 0xC7D8 },
        { 0xE443, 0xC7D9 },
        { 0xE444, 0xC7DA },
        { 0xE445, 0xC7DB },
        { 0xE446, 0xC7DC },
        { 0xE447, 0xC7DD },
        { 0xE448, 0xC7DE },
        { 0xE449, 0xC7DF },
        { 0xE44A, 0xC7E0 },
        { 0xE44B, 0xC7E1 },
        { 0xE44C, 0xC7E2 },
        { 0xE44D, 0xC7E3 },
        { 0xE44E, 0xC7E4 },
        { 0xE44F, 0xC7E5 },
        { 0xE450, 0xC7E6 },
        { 0xE451, 0xC7E7 },
        { 0xE452, 0xC7E8 },
        { 0xE453, 0xC7E9 },
        { 0xE454, 0xC7EA },
        { 0xE455, 0xC7EB },
        { 0xE456, 0xC7EC },
        { 0xE457, 0xC7ED },
        { 0xE458, 0xC7EE },
        { 0xE459, 0xC7EF },
        { 0xE45A, 0xC7F0 },
        { 0xE45B, 0xC7F1 },
        { 0xE45C, 0xC7F2 },
        { 0xE45D, 0xC7F3 },
        { 0xE45E, 0xC7F4 },
        { 0xE45F, 0xC7F5 },
        { 0xE460, 0xC7F6 },
        { 0xE461, 0xC7F7 },
        { 0xE462, 0xC7F8 },
        { 0xE463, 0xC7F9 },
        { 0xE464, 0xC7FA },
        { 0xE465, 0xC7FB },
        { 0xE466, 0xC7FC },
        { 0xE467, 0xC7FD },
        { 0xE468, 0xC841 },
        { 0xE469, 0xC842 },
        { 0xE46A, 0xC843 },
        { 0xE46B, 0xC844 },
        { 0xE46C, 0xC845 },
        { 0xE46D, 0xC846 },
        { 0xE46E, 0xC847 },
        { 0xE46F, 0xC848 },
        { 0xE470, 0xC849 },
        { 0xE471, 0xC84A },
        { 0xE472, 0xC84B },
        { 0xE473, 0xC84C },
        { 0xE474, 0xC84D },
        { 0xE475, 0xC84E },
        { 0xE476, 0xC84F },
        { 0xE477, 0xC850 },
        { 0xE478, 0xC851 },
        { 0xE479, 0xC852 },
        { 0xE47A, 0xC853 },
        { 0xE47B, 0xC854 },
        { 0xE47C, 0xC855 },
        { 0xE47D, 0xC856 },
        { 0xE47E, 0xC857 },
        { 0xE47F, 0xC858 },
        { 0xE480, 0xC859 },
        { 0xE481, 0xC85A },
        { 0xE482, 0xC85B },
        { 0xE483, 0xC85C },
        { 0xE484, 0xC85D },
        { 0xE485, 0xC85E },
        { 0xE486, 0xC85F },
        { 0xE487, 0xC860 },
        { 0xE488, 0xC861 },
        { 0xE489, 0xC862 },
        { 0xE48A, 0xC863 },
        { 0xE48B, 0xC864 },
        { 0xE48C, 0xC865 },
        { 0xE48D, 0xC866 },
        { 0xE48E, 0xC867 },
        { 0xE48F, 0xC868 },
        { 0xE490, 0xC869 },
        { 0xE491, 0xC86A },
        { 0xE492, 0xC86B },
        { 0xE493, 0xC86C },
        { 0xE494, 0xC86D },
        { 0xE495, 0xC86E },
        { 0xE496, 0xC86F },
        { 0xE497, 0xC870 },
        { 0xE498, 0xC871 },
        { 0xE499, 0xC872 },
        { 0xE49A, 0xC873 },
        { 0xE49B, 0xC874 },
        { 0xE49C, 0xC875 },
        { 0xE49D, 0xC876 },
        { 0xE49E, 0xC877 },
        { 0xE49F, 0xC878 },
        { 0xE4A0, 0xC879 },
        { 0xE4A1, 0xC87A },
        { 0xE4A2, 0xC87B },
        { 0xE4A3, 0xC87C },
        { 0xE4A4, 0xC87D },
        { 0xE4A5, 0xC87E },
        { 0xE4A6, 0xC87F },
        { 0xE4A7, 0xC881 },
        { 0xE4A8, 0xC882 },
        { 0xE4A9, 0xC883 },
        { 0xE4AA, 0xC884 },
        { 0xE4AB, 0xC885 },
        { 0xE4AC, 0xC886 },
        { 0xE4AD, 0xC887 },
        { 0xE4AE, 0xC888 },
        { 0xE4AF, 0xC889 },
        { 0xE4B0, 0xC88A },
        { 0xE4B1, 0xC88B },
        { 0xE4B2, 0xC88C },
        { 0xE4B3, 0xC88D },
        { 0xE4B4, 0xC88E },
        { 0xE4B5, 0xC88F },
        { 0xE4B6, 0xC890 },
        { 0xE4B7, 0xC891 },
        { 0xE4B8, 0xC892 },
        { 0xE4B9, 0xC893 },
        { 0xE4BA, 0xC894 },
        { 0xE4BB, 0xC895 },
        { 0xE4BC, 0xC896 },
        { 0xE4BD, 0xC897 },
        { 0xE4BE, 0xC898 },
        { 0xE4BF, 0xC899 },
        { 0xE4C0, 0xC89A },
        { 0xE4C1, 0xC89B },
        { 0xE4C2, 0xC89C },
        { 0xE4C3, 0xC89D },
        { 0xE4C4, 0xC89E },
        { 0xE4C5, 0xC89F },
        { 0xE4C6, 0xC8A0 },
        { 0xE4C7, 0xC8A1 },
        { 0xE4C8, 0xC8A2 },
        { 0xE4C9, 0xC8A3 },
        { 0xE4CA, 0xC8A4 },
        { 0xE4CB, 0xC8A5 },
        { 0xE4CC, 0xC8A6 },
        { 0xE4CD, 0xC8A7 },
        { 0xE4CE, 0xC8A8 },
        { 0xE4CF, 0xC8A9 },
        { 0xE4D0, 0xC8AA },
        { 0xE4D1, 0xC8AB },
        { 0xE4D2, 0xC8AC },
        { 0xE4D3, 0xC8AD },
        { 0xE4D4, 0xC8AE },
        { 0xE4D5, 0xC8AF },
        { 0xE4D6, 0xC8B0 },
        { 0xE4D7, 0xC8B1 },
        { 0xE4D8, 0xC8B2 },
        { 0xE4D9, 0xC8B3 },
        { 0xE4DA, 0xC8B4 },
        { 0xE4DB, 0xC8B5 },
        { 0xE4DC, 0xC8B6 },
        { 0xE4DD, 0xC8B7 },
        { 0xE4DE, 0xC8B8 },
        { 0xE4DF, 0xC8B9 },
        { 0xE4E0, 0xC8BA },
        { 0xE4E1, 0xC8BB },
        { 0xE4E2, 0xC8BC },
        { 0xE4E3, 0xC8BD },
        { 0xE4E4, 0xC8BE },
        { 0xE4E5, 0xC8BF },
        { 0xE4E6, 0xC8C0 },
        { 0xE4E7, 0xC8C1 },
        { 0xE4E8, 0xC8C2 },
        { 0xE4E9, 0xC8C3 },
        { 0xE4EA, 0xC8C4 },
        { 0xE4EB, 0xC8C5 },
        { 0xE4EC, 0xC8C6 },
        { 0xE4ED, 0xC8C7 },
        { 0xE4EE, 0xC8C8 },
        { 0xE4EF, 0xC8C9 },
        { 0xE4F0, 0xC8CA },
        { 0xE4F1, 0xC8CB },
        { 0xE4F2, 0xC8CC },
        { 0xE4F3, 0xC8CD },
        { 0xE4F4, 0xC8CE },
        { 0xE4F5, 0xC8CF },
        { 0xE4F6, 0xC8D0 },
        { 0xE4F7, 0xC8D1 },
        { 0xE4F8, 0xC8D2 },
        { 0xE4F9, 0xC8D3 },
        { 0xE4FA, 0xC8D4 },
        { 0xE4FB, 0xC8D5 },
        { 0xE4FC, 0xC8D6 },
        { 0xE4FD, 0xC8D7 },
        { 0xE4FE, 0xC8D8 },
        { 0xE4FF, 0xC8D9 },
        { 0xE500, 0xC8DA },
        { 0xE501, 0xC8DB },
        { 0xE502, 0xC8DC },
        { 0xE503, 0xC8DD },
        { 0xE504, 0xC8DE },
        { 0xE505, 0xC8DF },
        { 0xE506, 0xC8E0 },
        { 0xE507, 0xC8E1 },
        { 0xE508, 0xC8E2 },
        { 0xE509, 0xC8E3 },
        { 0xE50A, 0xC8E4 },
        { 0xE50B, 0xC8E5 },
        { 0xE50C, 0xC8E6 },
        { 0xE50D, 0xC8E7 },
        { 0xE50E, 0xC8E8 },
        { 0xE50F, 0xC8E9 },
        { 0xE510, 0xC8EA },
        { 0xE511, 0xC8EB },
        { 0xE512, 0xC8EC },
        { 0xE513, 0xC8ED },
        { 0xE514, 0xC8EE },
        { 0xE515, 0xC8EF },
        { 0xE516, 0xC8F0 },
        { 0xE517, 0xC8F1 },
        { 0xE518, 0xC8F2 },
        { 0xE519, 0xC8F3 },
        { 0xE51A, 0xC8F4 },
        { 0xE51B, 0xC8F5 },
        { 0xE51C, 0xC8F6 },
        { 0xE51D, 0xC8F7 },
        { 0xE51E, 0xC8F8 },
        { 0xE51F, 0xC8F9 },
        { 0xE520, 0xC8FA },
        { 0xE521, 0xC8FB },
        { 0xE522, 0xC8FC },
        { 0xE523, 0xC8FD },
        { 0xE524, 0xC941 },
        { 0xE525, 0xC942 },
        { 0xE526, 0xC943 },
        { 0xE527, 0xC944 },
        { 0xE528, 0xC945 },
        { 0xE529, 0xC946 },
        { 0xE52A, 0xC947 },
        { 0xE52B, 0xC948 },
        { 0xE52C, 0xC949 },
        { 0xE52D, 0xC94A },
        { 0xE52E, 0xC94B },
        { 0xE52F, 0xC94C },
        { 0xE530, 0xC94D },
        { 0xE531, 0xC94E },
        { 0xE532, 0xC94F },
        { 0xE533, 0xC950 },
        { 0xE534, 0xC951 },
        { 0xE535, 0xC952 },
        { 0xE536, 0xC953 },
        { 0xE537, 0xC954 },
        { 0xE538, 0xC955 },
        { 0xE539, 0xC956 },
        { 0xE53A, 0xC957 },
        { 0xE53B, 0xC958 },
        { 0xE53C, 0xC959 },
        { 0xE53D, 0xC95A },
        { 0xE53E, 0xC95B },
        { 0xE53F, 0xC95C },
        { 0xE540, 0xC95D },
        { 0xE541, 0xC95E },
        { 0xE542, 0xC95F },
        { 0xE543, 0xC960 },
        { 0xE544, 0xC961 },
        { 0xE545, 0xC962 },
        { 0xE546, 0xC963 },
        { 0xE547, 0xC964 },
        { 0xE548, 0xC965 },
        { 0xE549, 0xC966 },
        { 0xE54A, 0xC967 },
        { 0xE54B, 0xC968 },
        { 0xE54C, 0xC969 },
        { 0xE54D, 0xC96A },
        { 0xE54E, 0xC96B },
        { 0xE54F, 0xC96C },
        { 0xE550, 0xC96D },
        { 0xE551, 0xC96E },
        { 0xE552, 0xC96F },
        { 0xE553, 0xC970 },
        { 0xE554, 0xC971 },
        { 0xE555, 0xC972 },
        { 0xE556, 0xC973 },
        { 0xE557, 0xC974 },
        { 0xE558, 0xC975 },
        { 0xE559, 0xC976 },
        { 0xE55A, 0xC977 },
        { 0xE55B, 0xC978 },
        { 0xE55C, 0xC979 },
        { 0xE55D, 0xC97A },
        { 0xE55E, 0xC97B },
        { 0xE55F, 0xC97C },
        { 0xE560, 0xC97D },
        { 0xE561, 0xC97E },
        { 0xE562, 0xC97F },
        { 0xE563, 0xC981 },
        { 0xE564, 0xC982 },
        { 0xE565, 0xC983 },
        { 0xE566, 0xC984 },
        { 0xE567, 0xC985 },
        { 0xE568, 0xC986 },
        { 0xE569, 0xC987 },
        { 0xE56A, 0xC988 },
        { 0xE56B, 0xC989 },
        { 0xE56C, 0xC98A },
        { 0xE56D, 0xC98B },
        { 0xE56E, 0xC98C },
        { 0xE56F, 0xC98D },
        { 0xE570, 0xC98E },
        { 0xE571, 0xC98F },
        { 0xE572, 0xC990 },
        { 0xE573, 0xC991 },
        { 0xE574, 0xC992 },
        { 0xE575, 0xC993 },
        { 0xE576, 0xC994 },
        { 0xE577, 0xC995 },
        { 0xE578, 0xC996 },
        { 0xE579, 0xC997 },
        { 0xE57A, 0xC998 },
        { 0xE57B, 0xC999 },
        { 0xE57C, 0xC99A },
        { 0xE57D, 0xC99B },
        { 0xE57E, 0xC99C },
        { 0xE57F, 0xC99D },
        { 0xE580, 0xC99E },
        { 0xE581, 0xC99F },
        { 0xE582, 0xC9A0 },
        { 0xE583, 0xC9A1 },
        { 0xE584, 0xC9A2 },
        { 0xE585, 0xC9A3 },
        { 0xE586, 0xC9A4 },
        { 0xE587, 0xC9A5 },
        { 0xE588, 0xC9A6 },
        { 0xE589, 0xC9A7 },
        { 0xE58A, 0xC9A8 },
        { 0xE58B, 0xC9A9 },
        { 0xE58C, 0xC9AA },
        { 0xE58D, 0xC9AB },
        { 0xE58E, 0xC9AC },
        { 0xE58F, 0xC9AD },
        { 0xE590, 0xC9AE },
        { 0xE591, 0xC9AF },
        { 0xE592, 0xC9B0 },
        { 0xE593, 0xC9B1 },
        { 0xE594, 0xC9B2 },
        { 0xE595, 0xC9B3 },
        { 0xE596, 0xC9B4 },
        { 0xE597, 0xC9B5 },
        { 0xE598, 0xC9B6 },
        { 0xE599, 0xC9B7 },
        { 0xE59A, 0xC9B8 },
        { 0xE59B, 0xC9B9 },
        { 0xE59C, 0xC9BA },
        { 0xE59D, 0xC9BB },
        { 0xE59E, 0xC9BC },
        { 0xE59F, 0xC9BD },
        { 0xE5A0, 0xC9BE },
        { 0xE5A1, 0xC9BF },
        { 0xE5A2, 0xC9C0 },
        { 0xE5A3, 0xC9C1 },
        { 0xE5A4, 0xC9C2 },
        { 0xE5A5, 0xC9C3 },
        { 0xE5A6, 0xC9C4 },
        { 0xE5A7, 0xC9C5 },
        { 0xE5A8, 0xC9C6 },
        { 0xE5A9, 0xC9C7 },
        { 0xE5AA, 0xC9C8 },
        { 0xE5AB, 0xC9C9 },
        { 0xE5AC, 0xC9CA },
        { 0xE5AD, 0xC9CB },
        { 0xE5AE, 0xC9CC },
        { 0xE5AF, 0xC9CD },
        { 0xE5B0, 0xC9CE },
        { 0xE5B1, 0xC9CF },
        { 0xE5B2, 0xC9D0 },
        { 0xE5B3, 0xC9D1 },
        { 0xE5B4, 0xC9D2 },
        { 0xE5B5, 0xC9D3 },
        { 0xE5B6, 0xC9D4 },
        { 0xE5B7, 0xC9D5 },
        { 0xE5B8, 0xC9D6 },
        { 0xE5B9, 0xC9D7 },
        { 0xE5BA, 0xC9D8 },
        { 0xE5BB, 0xC9D9 },
        { 0xE5BC, 0xC9DA },
        { 0xE5BD, 0xC9DB },
        { 0xE5BE, 0xC9DC },
        { 0xE5BF, 0xC9DD },
        { 0xE5C0, 0xC9DE },
        { 0xE5C1, 0xC9DF },
        { 0xE5C2, 0xC9E0 },
        { 0xE5C3, 0xC9E1 },
        { 0xE5C4, 0xC9E2 },
        { 0xE5C5, 0xC9E3 },
        { 0xE5C6, 0xC9E4 },
        { 0xE5C7, 0xC9E5 },
        { 0xE5C8, 0xC9E6 },
        { 0xE5C9, 0xC9E7 },
        { 0xE5CA, 0xC9E8 },
        { 0xE5CB, 0xC9E9 },
        { 0xE5CC, 0xC9EA },
        { 0xE5CD, 0xC9EB },
        { 0xE5CE, 0xC9EC },
        { 0xE5CF, 0xC9ED },
        { 0xE5D0, 0xC9EE },
        { 0xE5D1, 0xC9EF },
        { 0xE5D2, 0xC9F0 },
        { 0xE5D3, 0xC9F1 },
        { 0xE5D4, 0xC9F2 },
        { 0xE5D5, 0xC9F3 },
        { 0xE5D6, 0xC9F4 },
        { 0xE5D7, 0xC9F5 },
        { 0xE5D8, 0xC9F6 },
        { 0xE5D9, 0xC9F7 },
        { 0xE5DA, 0xC9F8 },
        { 0xE5DB, 0xC9F9 },
        { 0xE5DC, 0xC9FA },
        { 0xE5DD, 0xC9FB },
        { 0xE5DE, 0xC9FC },
        { 0xE5DF, 0xC9FD },
        { 0xE5E0, 0xCA41 },
        { 0xE5E1, 0xCA42 },
        { 0xE5E2, 0xCA43 },
        { 0xE5E3, 0xCA44 },
        { 0xE5E4, 0xCA45 },
        { 0xE5E5, 0xCA46 },
        { 0xE5E6, 0xCA47 },
        { 0xE5E7, 0xCA48 },
        { 0xE5E8, 0xCA49 },
        { 0xE5E9, 0xCA4A },
        { 0xE5EA, 0xCA4B },
        { 0xE5EB, 0xCA4C },
        { 0xE5EC, 0xCA4D },
        { 0xE5ED, 0xCA4E },
        { 0xE5EE, 0xCA4F },
        { 0xE5EF, 0xCA50 },
        { 0xE5F0, 0xCA51 },
        { 0xE5F1, 0xCA52 },
        { 0xE5F2, 0xCA53 },
        { 0xE5F3, 0xCA54 },
        { 0xE5F4, 0xCA55 },
        { 0xE5F5, 0xCA56 },
        { 0xE5F6, 0xCA57 },
        { 0xE5F7, 0xCA58 },
        { 0xE5F8, 0xCA59 },
        { 0xE5F9, 0xCA5A },
        { 0xE5FA, 0xCA5B },
        { 0xE5FB, 0xCA5C },
        { 0xE5FC, 0xCA5D },
        { 0xE5FD, 0xCA5E },
        { 0xE5FE, 0xCA5F },
        { 0xE5FF, 0xCA60 },
        { 0xE600, 0xCA61 },
        { 0xE601, 0xCA62 },
        { 0xE602, 0xCA63 },
        { 0xE603, 0xCA64 },
        { 0xE604, 0xCA65 },
        { 0xE605, 0xCA66 },
        { 0xE606, 0xCA67 },
        { 0xE607, 0xCA68 },
        { 0xE608, 0xCA69 },
        { 0xE609, 0xCA6A },
        { 0xE60A, 0xCA6B },
        { 0xE60B, 0xCA6C },
        { 0xE60C, 0xCA6D },
        { 0xE60D, 0xCA6E },
        { 0xE60E, 0xCA6F },
        { 0xE60F, 0xCA70 },
        { 0xE610, 0xCA71 },
        { 0xE611, 0xCA72 },
        { 0xE612, 0xCA73 },
        { 0xE613, 0xCA74 },
        { 0xE614, 0xCA75 },
        { 0xE615, 0xCA76 },
        { 0xE616, 0xCA77 },
        { 0xE617, 0xCA78 },
        { 0xE618, 0xCA79 },
        { 0xE619, 0xCA7A },
        { 0xE61A, 0xCA7B },
        { 0xE61B, 0xCA7C },
        { 0xE61C, 0xCA7D },
        { 0xE61D, 0xCA7E },
        { 0xE61E, 0xCA7F },
        { 0xE61F, 0xCA81 },
        { 0xE620, 0xCA82 },
        { 0xE621, 0xCA83 },
        { 0xE622, 0xCA84 },
        { 0xE623, 0xCA85 },
        { 0xE624, 0xCA86 },
        { 0xE625, 0xCA87 },
        { 0xE626, 0xCA88 },
        { 0xE627, 0xCA89 },
        { 0xE628, 0xCA8A },
        { 0xE629, 0xCA8B },
        { 0xE62A, 0xCA8C },
        { 0xE62B, 0xCA8D },
        { 0xE62C, 0xCA8E },
        { 0xE62D, 0xCA8F },
        { 0xE62E, 0xCA90 },
        { 0xE62F, 0xCA91 },
        { 0xE630, 0xCA92 },
        { 0xE631, 0xCA93 },
        { 0xE632, 0xCA94 },
        { 0xE633, 0xCA95 },
        { 0xE634, 0xCA96 },
        { 0xE635, 0xCA97 },
        { 0xE636, 0xCA98 },
        { 0xE637, 0xCA99 },
        { 0xE638, 0xCA9A },
        { 0xE639, 0xCA9B },
        { 0xE63A, 0xCA9C },
        { 0xE63B, 0xCA9D },
        { 0xE63C, 0xCA9E },
        { 0xE63D, 0xCA9F },
        { 0xE63E, 0xCAA0 },
        { 0xE63F, 0xCAA1 },
        { 0xE640, 0xCAA2 },
        { 0xE641, 0xCAA3 },
        { 0xE642, 0xCAA4 },
        { 0xE643, 0xCAA5 },
        { 0xE644, 0xCAA6 },
        { 0xE645, 0xCAA7 },
        { 0xE646, 0xCAA8 },
        { 0xE647, 0xCAA9 },
        { 0xE648, 0xCAAA },
        { 0xE649, 0xCAAB },
        { 0xE64A, 0xCAAC },
        { 0xE64B, 0xCAAD },
        { 0xE64C, 0xCAAE },
        { 0xE64D, 0xCAAF },
        { 0xE64E, 0xCAB0 },
        { 0xE64F, 0xCAB1 },
        { 0xE650, 0xCAB2 },
        { 0xE651, 0xCAB3 },
        { 0xE652, 0xCAB4 },
        { 0xE653, 0xCAB5 },
        { 0xE654, 0xCAB6 },
        { 0xE655, 0xCAB7 },
        { 0xE656, 0xCAB8 },
        { 0xE657, 0xCAB9 },
        { 0xE658, 0xCABA },
        { 0xE659, 0xCABB },
        { 0xE65A, 0xCABC },
        { 0xE65B, 0xCABD },
        { 0xE65C, 0xCABE },
        { 0xE65D, 0xCABF },
        { 0xE65E, 0xCAC0 },
        { 0xE65F, 0xCAC1 },
        { 0xE660, 0xCAC2 },
        { 0xE661, 0xCAC3 },
        { 0xE662, 0xCAC4 },
        { 0xE663, 0xCAC5 },
        { 0xE664, 0xCAC6 },
        { 0xE665, 0xCAC7 },
        { 0xE666, 0xCAC8 },
        { 0xE667, 0xCAC9 },
        { 0xE668, 0xCACA },
        { 0xE669, 0xCACB },
        { 0xE66A, 0xCACC },
        { 0xE66B, 0xCACD },
        { 0xE66C, 0xCACE },
        { 0xE66D, 0xCACF },
        { 0xE66E, 0xCAD0 },
        { 0xE66F, 0xCAD1 },
        { 0xE670, 0xCAD2 },
        { 0xE671, 0xCAD3 },
        { 0xE672, 0xCAD4 },
        { 0xE673, 0xCAD5 },
        { 0xE674, 0xCAD6 },
        { 0xE675, 0xCAD7 },
        { 0xE676, 0xCAD8 },
        { 0xE677, 0xCAD9 },
        { 0xE678, 0xCADA },
        { 0xE679, 0xCADB },
        { 0xE67A, 0xCADC },
        { 0xE67B, 0xCADD },
        { 0xE67C, 0xCADE },
        { 0xE67D, 0xCADF },
        { 0xE67E, 0xCAE0 },
        { 0xE67F, 0xCAE1 },
        { 0xE680, 0xCAE2 },
        { 0xE681, 0xCAE3 },
        { 0xE682, 0xCAE4 },
        { 0xE683, 0xCAE5 },
        { 0xE684, 0xCAE6 },
        { 0xE685, 0xCAE7 },
        { 0xE686, 0xCAE8 },
        { 0xE687, 0xCAE9 },
        { 0xE688, 0xCAEA },
        { 0xE689, 0xCAEB },
        { 0xE68A, 0xCAEC },
        { 0xE68B, 0xCAED },
        { 0xE68C, 0xCAEE },
        { 0xE68D, 0xCAEF },
        { 0xE68E, 0xCAF0 },
        { 0xE68F, 0xCAF1 },
        { 0xE690, 0xCAF2 },
        { 0xE691, 0xCAF3 },
        { 0xE692, 0xCAF4 },
        { 0xE693, 0xCAF5 },
        { 0xE694, 0xCAF6 },
        { 0xE695, 0xCAF7 },
        { 0xE696, 0xCAF8 },
        { 0xE697, 0xCAF9 },
        { 0xE698, 0xCAFA },
        { 0xE699, 0xCAFB },
        { 0xE69A, 0xCAFC },
        { 0xE69B, 0xCAFD },
        { 0xE69C, 0xCB41 },
        { 0xE69D, 0xCB42 },
        { 0xE69E, 0xCB43 },
        { 0xE69F, 0xCB44 },
        { 0xE6A0, 0xCB45 },
        { 0xE6A1, 0xCB46 },
        { 0xE6A2, 0xCB47 },
        { 0xE6A3, 0xCB48 },
        { 0xE6A4, 0xCB49 },
        { 0xE6A5, 0xCB4A },
        { 0xE6A6, 0xCB4B },
        { 0xE6A7, 0xCB4C },
        { 0xE6A8, 0xCB4D },
        { 0xE6A9, 0xCB4E },
        { 0xE6AA, 0xCB4F },
        { 0xE6AB, 0xCB50 },
        { 0xE6AC, 0xCB51 },
        { 0xE6AD, 0xCB52 },
        { 0xE6AE, 0xCB53 },
        { 0xE6AF, 0xCB54 },
        { 0xE6B0, 0xCB55 },
        { 0xE6B1, 0xCB56 },
        { 0xE6B2, 0xCB57 },
        { 0xE6B3, 0xCB58 },
        { 0xE6B4, 0xCB59 },
        { 0xE6B5, 0xCB5A },
        { 0xE6B6, 0xCB5B },
        { 0xE6B7, 0xCB5C },
        { 0xE6B8, 0xCB5D },
        { 0xE6B9, 0xCB5E },
        { 0xE6BA, 0xCB5F },
        { 0xE6BB, 0xCB60 },
        { 0xE6BC, 0xCB61 },
        { 0xE6BD, 0xCB62 },
        { 0xE6BE, 0xCB63 },
        { 0xE6BF, 0xCB64 },
        { 0xE6C0, 0xCB65 },
        { 0xE6C1, 0xCB66 },
        { 0xE6C2, 0xCB67 },
        { 0xE6C3, 0xCB68 },
        { 0xE6C4, 0xCB69 },
        { 0xE6C5, 0xCB6A },
        { 0xE6C6, 0xCB6B },
        { 0xE6C7, 0xCB6C },
        { 0xE6C8, 0xCB6D },
        { 0xE6C9, 0xCB6E },
        { 0xE6CA, 0xCB6F },
        { 0xE6CB, 0xCB70 },
        { 0xE6CC, 0xCB71 },
        { 0xE6CD, 0xCB72 },
        { 0xE6CE, 0xCB73 },
        { 0xE6CF, 0xCB74 },
        { 0xE6D0, 0xCB75 },
        { 0xE6D1, 0xCB76 },
        { 0xE6D2, 0xCB77 },
        { 0xE6D3, 0xCB78 },
        { 0xE6D4, 0xCB79 },
        { 0xE6D5, 0xCB7A },
        { 0xE6D6, 0xCB7B },
        { 0xE6D7, 0xCB7C },
        { 0xE6D8, 0xCB7D },
        { 0xE6D9, 0xCB7E },
        { 0xE6DA, 0xCB7F },
        { 0xE6DB, 0xCB81 },
        { 0xE6DC, 0xCB82 },
        { 0xE6DD, 0xCB83 },
        { 0xE6DE, 0xCB84 },
        { 0xE6DF, 0xCB85 },
        { 0xE6E0, 0xCB86 },
        { 0xE6E1, 0xCB87 },
        { 0xE6E2, 0xCB88 },
        { 0xE6E3, 0xCB89 },
        { 0xE6E4, 0xCB8A },
        { 0xE6E5, 0xCB8B },
        { 0xE6E6, 0xCB8C },
        { 0xE6E7, 0xCB8D },
        { 0xE6E8, 0xCB8E },
        { 0xE6E9, 0xCB8F },
        { 0xE6EA, 0xCB90 },
        { 0xE6EB, 0xCB91 },
        { 0xE6EC, 0xCB92 },
        { 0xE6ED, 0xCB93 },
        { 0xE6EE, 0xCB94 },
        { 0xE6EF, 0xCB95 },
        { 0xE6F0, 0xCB96 },
        { 0xE6F1, 0xCB97 },
        { 0xE6F2, 0xCB98 },
        { 0xE6F3, 0xCB99 },
        { 0xE6F4, 0xCB9A },
        { 0xE6F5, 0xCB9B },
        { 0xE6F6, 0xCB9C },
        { 0xE6F7, 0xCB9D },
        { 0xE6F8, 0xCB9E },
        { 0xE6F9, 0xCB9F },
        { 0xE6FA, 0xCBA0 },
        { 0xE6FB, 0xCBA1 },
        { 0xE6FC, 0xCBA2 },
        { 0xE6FD, 0xCBA3 },
        { 0xE6FE, 0xCBA4 },
        { 0xE6FF, 0xCBA5 },
        { 0xE700, 0xCBA6 },
        { 0xE701, 0xCBA7 },
        { 0xE702, 0xCBA8 },
        { 0xE703, 0xCBA9 },
        { 0xE704, 0xCBAA },
        { 0xE705, 0xCBAB },
        { 0xE706, 0xCBAC },
        { 0xE707, 0xCBAD },
        { 0xE708, 0xCBAE },
        { 0xE709, 0xCBAF },
        { 0xE70A, 0xCBB0 },
        { 0xE70B, 0xCBB1 },
        { 0xE70C, 0xCBB2 },
        { 0xE70D, 0xCBB3 },
        { 0xE70E, 0xCBB4 },
        { 0xE70F, 0xCBB5 },
        { 0xE710, 0xCBB6 },
        { 0xE711, 0xCBB7 },
        { 0xE712, 0xCBB8 },
        { 0xE713, 0xCBB9 },
        { 0xE714, 0xCBBA },
        { 0xE715, 0xCBBB },
        { 0xE716, 0xCBBC },
        { 0xE717, 0xCBBD },
        { 0xE718, 0xCBBE },
        { 0xE719, 0xCBBF },
        { 0xE71A, 0xCBC0 },
        { 0xE71B, 0xCBC1 },
        { 0xE71C, 0xCBC2 },
        { 0xE71D, 0xCBC3 },
        { 0xE71E, 0xCBC4 },
        { 0xE71F, 0xCBC5 },
        { 0xE720, 0xCBC6 },
        { 0xE721, 0xCBC7 },
        { 0xE722, 0xCBC8 },
        { 0xE723, 0xCBC9 },
        { 0xE724, 0xCBCA },
        { 0xE725, 0xCBCB },
        { 0xE726, 0xCBCC },
        { 0xE727, 0xCBCD },
        { 0xE728, 0xCBCE },
        { 0xE729, 0xCBCF },
        { 0xE72A, 0xCBD0 },
        { 0xE72B, 0xCBD1 },
        { 0xE72C, 0xCBD2 },
        { 0xE72D, 0xCBD3 },
        { 0xE72E, 0xCBD4 },
        { 0xE72F, 0xCBD5 },
        { 0xE730, 0xCBD6 },
        { 0xE731, 0xCBD7 },
        { 0xE732, 0xCBD8 },
        { 0xE733, 0xCBD9 },
        { 0xE734, 0xCBDA },
        { 0xE735, 0xCBDB },
        { 0xE736, 0xCBDC },
        { 0xE737, 0xCBDD },
        { 0xE738, 0xCBDE },
        { 0xE739, 0xCBDF },
        { 0xE73A, 0xCBE0 },
        { 0xE73B, 0xCBE1 },
        { 0xE73C, 0xCBE2 },
        { 0xE73D, 0xCBE3 },
        { 0xE73E, 0xCBE4 },
        { 0xE73F, 0xCBE5 },
        { 0xE740, 0xCBE6 },
        { 0xE741, 0xCBE7 },
        { 0xE742, 0xCBE8 },
        { 0xE743, 0xCBE9 },
        { 0xE744, 0xCBEA },
        { 0xE745, 0xCBEB },
        { 0xE746, 0xCBEC },
        { 0xE747, 0xCBED },
        { 0xE748, 0xCBEE },
        { 0xE749, 0xCBEF },
        { 0xE74A, 0xCBF0 },
        { 0xE74B, 0xCBF1 },
        { 0xE74C, 0xCBF2 },
        { 0xE74D, 0xCBF3 },
        { 0xE74E, 0xCBF4 },
        { 0xE74F, 0xCBF5 },
        { 0xE750, 0xCBF6 },
        { 0xE751, 0xCBF7 },
        { 0xE752, 0xCBF8 },
        { 0xE753, 0xCBF9 },
        { 0xE754, 0xCBFA },
        { 0xE755, 0xCBFB },
        { 0xE756, 0xCBFC },
        { 0xE757, 0xCBFD },
        { 0xE758, 0xCC41 },
        { 0xE759, 0xCC42 },
        { 0xE75A, 0xCC43 },
        { 0xE75B, 0xCC44 },
        { 0xE75C, 0xCC45 },
        { 0xE75D, 0xCC46 },
        { 0xE75E, 0xCC47 },
        { 0xE75F, 0xCC48 },
        { 0xE760, 0xCC49 },
        { 0xE761, 0xCC4A },
        { 0xE762, 0xCC4B },
        { 0xE763, 0xCC4C },
        { 0xE764, 0xCC4D },
        { 0xE765, 0xCC4E },
        { 0xE766, 0xCC4F },
        { 0xE767, 0xCC50 },
        { 0xE768, 0xCC51 },
        { 0xE769, 0xCC52 },
        { 0xE76A, 0xCC53 },
        { 0xE76B, 0xCC54 },
        { 0xE76C, 0xCC55 },
        { 0xE76D, 0xCC56 },
        { 0xE76E, 0xCC57 },
        { 0xE76F, 0xCC58 },
        { 0xE770, 0xCC59 },
        { 0xE771, 0xCC5A },
        { 0xE772, 0xCC5B },
        { 0xE773, 0xCC5C },
        { 0xE774, 0xCC5D },
        { 0xE775, 0xCC5E },
        { 0xE776, 0xCC5F },
        { 0xE777, 0xCC60 },
        { 0xE778, 0xCC61 },
        { 0xE779, 0xCC62 },
        { 0xE77A, 0xCC63 },
        { 0xE77B, 0xCC64 },
        { 0xE77C, 0xCC65 },
        { 0xE77D, 0xCC66 },
        { 0xE77E, 0xCC67 },
        { 0xE77F, 0xCC68 },
        { 0xE780, 0xCC69 },
        { 0xE781, 0xCC6A },
        { 0xE782, 0xCC6B },
        { 0xE783, 0xCC6C },
        { 0xE784, 0xCC6D },
        { 0xE785, 0xCC6E },
        { 0xE786, 0xCC6F },
        { 0xE787, 0xCC70 },
        { 0xE788, 0xCC71 },
        { 0xE789, 0xCC72 },
        { 0xE78A, 0xCC73 },
        { 0xE78B, 0xCC74 },
        { 0xE78C, 0xCC75 },
        { 0xE78D, 0xCC76 },
        { 0xE78E, 0xCC77 },
        { 0xE78F, 0xCC78 },
        { 0xE790, 0xCC79 },
        { 0xE791, 0xCC7A },
        { 0xE792, 0xCC7B },
        { 0xE793, 0xCC7C },
        { 0xE794, 0xCC7D },
        { 0xE795, 0xCC7E },
        { 0xE796, 0xCC7F },
        { 0xE797, 0xCC81 },
        { 0xE798, 0xCC82 },
        { 0xE799, 0xCC83 },
        { 0xE79A, 0xCC84 },
        { 0xE79B, 0xCC85 },
        { 0xE79C, 0xCC86 },
        { 0xE79D, 0xCC87 },
        { 0xE79E, 0xCC88 },
        { 0xE79F, 0xCC89 },
        { 0xE7A0, 0xCC8A },
        { 0xE7A1, 0xCC8B },
        { 0xE7A2, 0xCC8C },
        { 0xE7A3, 0xCC8D },
        { 0xE7A4, 0xCC8E },
        { 0xE7A5, 0xCC8F },
        { 0xE7A6, 0xCC90 },
        { 0xE7A7, 0xCC91 },
        { 0xE7A8, 0xCC92 },
        { 0xE7A9, 0xCC93 },
        { 0xE7AA, 0xCC94 },
        { 0xE7AB, 0xCC95 },
        { 0xE7AC, 0xCC96 },
        { 0xE7AD, 0xCC97 },
        { 0xE7AE, 0xCC98 },
        { 0xE7AF, 0xCC99 },
        { 0xE7B0, 0xCC9A },
        { 0xE7B1, 0xCC9B },
        { 0xE7B2, 0xCC9C },
        { 0xE7B3, 0xCC9D },
        { 0xE7B4, 0xCC9E },
        { 0xE7B5, 0xCC9F },
        { 0xE7B6, 0xCCA0 },
        { 0xE7B7, 0xCCA1 },
        { 0xE7B8, 0xCCA2 },
        { 0xE7B9, 0xCCA3 },
        { 0xE7BA, 0xCCA4 },
        { 0xE7BB, 0xCCA5 },
        { 0xE7BC, 0xCCA6 },
        { 0xE7BD, 0xCCA7 },
        { 0xE7BE, 0xCCA8 },
        { 0xE7BF, 0xCCA9 },
        { 0xE7C0, 0xCCAA },
        { 0xE7C1, 0xCCAB },
        { 0xE7C2, 0xCCAC },
        { 0xE7C3, 0xCCAD },
        { 0xE7C4, 0xCCAE },
        { 0xE7C5, 0xCCAF },
        { 0xE7C6, 0xCCB0 },
        { 0xE7C7, 0xCCB1 },
        { 0xE7C8, 0xCCB2 },
        { 0xE7C9, 0xCCB3 },
        { 0xE7CA, 0xCCB4 },
        { 0xE7CB, 0xCCB5 },
        { 0xE7CC, 0xCCB6 },
        { 0xE7CD, 0xCCB7 },
        { 0xE7CE, 0xCCB8 },
        { 0xE7CF, 0xCCB9 },
        { 0xE7D0, 0xCCBA },
        { 0xE7D1, 0xCCBB },
        { 0xE7D2, 0xCCBC },
        { 0xE7D3, 0xCCBD },
        { 0xE7D4, 0xCCBE },
        { 0xE7D5, 0xCCBF },
        { 0xE7D6, 0xCCC0 },
        { 0xE7D7, 0xCCC1 },
        { 0xE7D8, 0xCCC2 },
        { 0xE7D9, 0xCCC3 },
        { 0xE7DA, 0xCCC4 },
        { 0xE7DB, 0xCCC5 },
        { 0xE7DC, 0xCCC6 },
        { 0xE7DD, 0xCCC7 },
        { 0xE7DE, 0xCCC8 },
        { 0xE7DF, 0xCCC9 },
        { 0xE7E0, 0xCCCA },
        { 0xE7E1, 0xCCCB },
        { 0xE7E2, 0xCCCC },
        { 0xE7E3, 0xCCCD },
        { 0xE7E4, 0xCCCE },
        { 0xE7E5, 0xCCCF },
        { 0xE7E6, 0xCCD0 },
        { 0xE7E7, 0xCCD1 },
        { 0xE7E8, 0xCCD2 },
        { 0xE7E9, 0xCCD3 },
        { 0xE7EA, 0xCCD4 },
        { 0xE7EB, 0xCCD5 },
        { 0xE7EC, 0xCCD6 },
        { 0xE7ED, 0xCCD7 },
        { 0xE7EE, 0xCCD8 },
        { 0xE7EF, 0xCCD9 },
        { 0xE7F0, 0xCCDA },
        { 0xE7F1, 0xCCDB },
        { 0xE7F2, 0xCCDC },
        { 0xE7F3, 0xCCDD },
        { 0xE7F4, 0xCCDE },
        { 0xE7F5, 0xCCDF },
        { 0xE7F6, 0xCCE0 },
        { 0xE7F7, 0xCCE1 },
        { 0xE7F8, 0xCCE2 },
        { 0xE7F9, 0xCCE3 },
        { 0xE7FA, 0xCCE4 },
        { 0xE7FB, 0xCCE5 },
        { 0xE7FC, 0xCCE6 },
        { 0xE7FD, 0xCCE7 },
        { 0xE7FE, 0xCCE8 },
        { 0xE7FF, 0xCCE9 },
        { 0xE800, 0xCCEA },
        { 0xE801, 0xCCEB },
        { 0xE802, 0xCCEC },
        { 0xE803, 0xCCED },
        { 0xE804, 0xCCEE },
        { 0xE805, 0xCCEF },
        { 0xE806, 0xCCF0 },
        { 0xE807, 0xCCF1 },
        { 0xE808, 0xCCF2 },
        { 0xE809, 0xCCF3 },
        { 0xE80A, 0xCCF4 },
        { 0xE80B, 0xCCF5 },
        { 0xE80C, 0xCCF6 },
        { 0xE80D, 0xCCF7 },
        { 0xE80E, 0xCCF8 },
        { 0xE80F, 0xCCF9 },
        { 0xE810, 0xCCFA },
        { 0xE811, 0xCCFB },
        { 0xE812, 0xCCFC },
        { 0xE813, 0xCCFD },
        { 0xE814, 0xCD41 },
        { 0xE815, 0xCD42 },
        { 0xE816, 0xCD43 },
        { 0xE817, 0xCD44 },
        { 0xE818, 0xCD45 },
        { 0xE819, 0xCD46 },
        { 0xE81A, 0xCD47 },
        { 0xE81B, 0xCD48 },
        { 0xE81C, 0xCD49 },
        { 0xE81D, 0xCD4A },
        { 0xE81E, 0xCD4B },
        { 0xE81F, 0xCD4C },
        { 0xE820, 0xCD4D },
        { 0xE821, 0xCD4E },
        { 0xE822, 0xCD4F },
        { 0xE823, 0xCD50 },
        { 0xE824, 0xCD51 },
        { 0xE825, 0xCD52 },
        { 0xE826, 0xCD53 },
        { 0xE827, 0xCD54 },
        { 0xE828, 0xCD55 },
        { 0xE829, 0xCD56 },
        { 0xE82A, 0xCD57 },
        { 0xE82B, 0xCD58 },
        { 0xE82C, 0xCD59 },
        { 0xE82D, 0xCD5A },
        { 0xE82E, 0xCD5B },
        { 0xE82F, 0xCD5C },
        { 0xE830, 0xCD5D },
        { 0xE831, 0xCD5E },
        { 0xE832, 0xCD5F },
        { 0xE833, 0xCD60 },
        { 0xE834, 0xCD61 },
        { 0xE835, 0xCD62 },
        { 0xE836, 0xCD63 },
        { 0xE837, 0xCD64 },
        { 0xE838, 0xCD65 },
        { 0xE839, 0xCD66 },
        { 0xE83A, 0xCD67 },
        { 0xE83B, 0xCD68 },
        { 0xE83C, 0xCD69 },
        { 0xE83D, 0xCD6A },
        { 0xE83E, 0xCD6B },
        { 0xE83F, 0xCD6C },
        { 0xE840, 0xCD6D },
        { 0xE841, 0xCD6E },
        { 0xE842, 0xCD6F },
        { 0xE843, 0xCD70 },
        { 0xE844, 0xCD71 },
        { 0xE845, 0xCD72 },
        { 0xE846, 0xCD73 },
        { 0xE847, 0xCD74 },
        { 0xE848, 0xCD75 },
        { 0xE849, 0xCD76 },
        { 0xE84A, 0xCD77 },
        { 0xE84B, 0xCD78 },
        { 0xE84C, 0xCD79 },
        { 0xE84D, 0xCD7A },
        { 0xE84E, 0xCD7B },
        { 0xE84F, 0xCD7C },
        { 0xE850, 0xCD7D },
        { 0xE851, 0xCD7E },
        { 0xE852, 0xCD7F },
        { 0xE853, 0xCD81 },
        { 0xE854, 0xCD82 },
        { 0xE855, 0xCD83 },
        { 0xE856, 0xCD84 },
        { 0xE857, 0xCD85 },
        { 0xE858, 0xCD86 },
        { 0xE859, 0xCD87 },
        { 0xE85A, 0xCD88 },
        { 0xE85B, 0xCD89 },
        { 0xE85C, 0xCD8A },
        { 0xE85D, 0xCD8B },
        { 0xE85E, 0xCD8C },
        { 0xE85F, 0xCD8D },
        { 0xE860, 0xCD8E },
        { 0xE861, 0xCD8F },
        { 0xE862, 0xCD90 },
        { 0xE863, 0xCD91 },
        { 0xE864, 0xCD92 },
        { 0xE865, 0xCD93 },
        { 0xE866, 0xCD94 },
        { 0xE867, 0xCD95 },
        { 0xE868, 0xCD96 },
        { 0xE869, 0xCD97 },
        { 0xE86A, 0xCD98 },
        { 0xE86B, 0xCD99 },
        { 0xE86C, 0xCD9A },
        { 0xE86D, 0xCD9B },
        { 0xE86E, 0xCD9C },
        { 0xE86F, 0xCD9D },
        { 0xE870, 0xCD9E },
        { 0xE871, 0xCD9F },
        { 0xE872, 0xCDA0 },
        { 0xE873, 0xCDA1 },
        { 0xE874, 0xCDA2 },
        { 0xE875, 0xCDA3 },
        { 0xE876, 0xCDA4 },
        { 0xE877, 0xCDA5 },
        { 0xE878, 0xCDA6 },
        { 0xE879, 0xCDA7 },
        { 0xE87A, 0xCDA8 },
        { 0xE87B, 0xCDA9 },
        { 0xE87C, 0xCDAA },
        { 0xE87D, 0xCDAB },
        { 0xE87E, 0xCDAC },
        { 0xE87F, 0xCDAD },
        { 0xE880, 0xCDAE },
        { 0xE881, 0xCDAF },
        { 0xE882, 0xCDB0 },
        { 0xE883, 0xCDB1 },
        { 0xE884, 0xCDB2 },
        { 0xE885, 0xCDB3 },
        { 0xE886, 0xCDB4 },
        { 0xE887, 0xCDB5 },
        { 0xE888, 0xCDB6 },
        { 0xE889, 0xCDB7 },
        { 0xE88A, 0xCDB8 },
        { 0xE88B, 0xCDB9 },
        { 0xE88C, 0xCDBA },
        { 0xE88D, 0xCDBB },
        { 0xE88E, 0xCDBC },
        { 0xE88F, 0xCDBD },
        { 0xE890, 0xCDBE },
        { 0xE891, 0xCDBF },
        { 0xE892, 0xCDC0 },
        { 0xE893, 0xCDC1 },
        { 0xE894, 0xCDC2 },
        { 0xE895, 0xCDC3 },
        { 0xE896, 0xCDC4 },
        { 0xE897, 0xCDC5 },
        { 0xE898, 0xCDC6 },
        { 0xE899, 0xCDC7 },
        { 0xE89A, 0xCDC8 },
        { 0xE89B, 0xCDC9 },
        { 0xE89C, 0xCDCA },
        { 0xE89D, 0xCDCB },
        { 0xE89E, 0xCDCC },
        { 0xE89F, 0xCDCD },
        { 0xE8A0, 0xCDCE },
        { 0xE8A1, 0xCDCF },
        { 0xE8A2, 0xCDD0 },
        { 0xE8A3, 0xCDD1 },
        { 0xE8A4, 0xCDD2 },
        { 0xE8A5, 0xCDD3 },
        { 0xE8A6, 0xCDD4 },
        { 0xE8A7, 0xCDD5 },
        { 0xE8A8, 0xCDD6 },
        { 0xE8A9, 0xCDD7 },
        { 0xE8AA, 0xCDD8 },
        { 0xE8AB, 0xCDD9 },
        { 0xE8AC, 0xCDDA },
        { 0xE8AD, 0xCDDB },
        { 0xE8AE, 0xCDDC },
        { 0xE8AF, 0xCDDD },
        { 0xE8B0, 0xCDDE },
        { 0xE8B1, 0xCDDF },
        { 0xE8B2, 0xCDE0 },
        { 0xE8B3, 0xCDE1 },
        { 0xE8B4, 0xCDE2 },
        { 0xE8B5, 0xCDE3 },
        { 0xE8B6, 0xCDE4 },
        { 0xE8B7, 0xCDE5 },
        { 0xE8B8, 0xCDE6 },
        { 0xE8B9, 0xCDE7 },
        { 0xE8BA, 0xCDE8 },
        { 0xE8BB, 0xCDE9 },
        { 0xE8BC, 0xCDEA },
        { 0xE8BD, 0xCDEB },
        { 0xE8BE, 0xCDEC },
        { 0xE8BF, 0xCDED },
        { 0xE8C0, 0xCDEE },
        { 0xE8C1, 0xCDEF },
        { 0xE8C2, 0xCDF0 },
        { 0xE8C3, 0xCDF1 },
        { 0xE8C4, 0xCDF2 },
        { 0xE8C5, 0xCDF3 },
        { 0xE8C6, 0xCDF4 },
        { 0xE8C7, 0xCDF5 },
        { 0xE8C8, 0xCDF6 },
        { 0xE8C9, 0xCDF7 },
        { 0xE8CA, 0xCDF8 },
        { 0xE8CB, 0xCDF9 },
        { 0xE8CC, 0xCDFA },
        { 0xE8CD, 0xCDFB },
        { 0xE8CE, 0xCDFC },
        { 0xE8CF, 0xCDFD },
        { 0xE8D0, 0xCE41 },
        { 0xE8D1, 0xCE42 },
        { 0xE8D2, 0xCE43 },
        { 0xE8D3, 0xCE44 },
        { 0xE8D4, 0xCE45 },
        { 0xE8D5, 0xCE46 },
        { 0xE8D6, 0xCE47 },
        { 0xE8D7, 0xCE48 },
        { 0xE8D8, 0xCE49 },
        { 0xE8D9, 0xCE4A },
        { 0xE8DA, 0xCE4B },
        { 0xE8DB, 0xCE4C },
        { 0xE8DC, 0xCE4D },
        { 0xE8DD, 0xCE4E },
        { 0xE8DE, 0xCE4F },
        { 0xE8DF, 0xCE50 },
        { 0xE8E0, 0xCE51 },
        { 0xE8E1, 0xCE52 },
        { 0xE8E2, 0xCE53 },
        { 0xE8E3, 0xCE54 },
        { 0xE8E4, 0xCE55 },
        { 0xE8E5, 0xCE56 },
        { 0xE8E6, 0xCE57 },
        { 0xE8E7, 0xCE58 },
        { 0xE8E8, 0xCE59 },
        { 0xE8E9, 0xCE5A },
        { 0xE8EA, 0xCE5B },
        { 0xE8EB, 0xCE5C },
        { 0xE8EC, 0xCE5D },
        { 0xE8ED, 0xCE5E },
        { 0xE8EE, 0xCE5F },
        { 0xE8EF, 0xCE60 },
        { 0xE8F0, 0xCE61 },
        { 0xE8F1, 0xCE62 },
        { 0xE8F2, 0xCE63 },
        { 0xE8F3, 0xCE64 },
        { 0xE8F4, 0xCE65 },
        { 0xE8F5, 0xCE66 },
        { 0xE8F6, 0xCE67 },
        { 0xE8F7, 0xCE68 },
        { 0xE8F8, 0xCE69 },
        { 0xE8F9, 0xCE6A },
        { 0xE8FA, 0xCE6B },
        { 0xE8FB, 0xCE6C },
        { 0xE8FC, 0xCE6D },
        { 0xE8FD, 0xCE6E },
        { 0xE8FE, 0xCE6F },
        { 0xE8FF, 0xCE70 },
        { 0xE900, 0xCE71 },
        { 0xE901, 0xCE72 },
        { 0xE902, 0xCE73 },
        { 0xE903, 0xCE74 },
        { 0xE904, 0xCE75 },
        { 0xE905, 0xCE76 },
        { 0xE906, 0xCE77 },
        { 0xE907, 0xCE78 },
        { 0xE908, 0xCE79 },
        { 0xE909, 0xCE7A },
        { 0xE90A, 0xCE7B },
        { 0xE90B, 0xCE7C },
        { 0xE90C, 0xCE7D },
        { 0xE90D, 0xCE7E },
        { 0xE90E, 0xCE7F },
        { 0xE90F, 0xCE81 },
        { 0xE910, 0xCE82 },
        { 0xE911, 0xCE83 },
        { 0xE912, 0xCE84 },
        { 0xE913, 0xCE85 },
        { 0xE914, 0xCE86 },
        { 0xE915, 0xCE87 },
        { 0xE916, 0xCE88 },
        { 0xE917, 0xCE89 },
        { 0xE918, 0xCE8A },
        { 0xE919, 0xCE8B },
        { 0xE91A, 0xCE8C },
        { 0xE91B, 0xCE8D },
        { 0xE91C, 0xCE8E },
        { 0xE91D, 0xCE8F },
        { 0xE91E, 0xCE90 },
        { 0xE91F, 0xCE91 },
        { 0xE920, 0xCE92 },
        { 0xE921, 0xCE93 },
        { 0xE922, 0xCE94 },
        { 0xE923, 0xCE95 },
        { 0xE924, 0xCE96 },
        { 0xE925, 0xCE97 },
        { 0xE926, 0xCE98 },
        { 0xE927, 0xCE99 },
        { 0xE928, 0xCE9A },
        { 0xE929, 0xCE9B },
        { 0xE92A, 0xCE9C },
        { 0xE92B, 0xCE9D },
        { 0xE92C, 0xCE9E },
        { 0xE92D, 0xCE9F },
        { 0xE92E, 0xCEA0 },
        { 0xE92F, 0xCEA1 },
        { 0xE930, 0xCEA2 },
        { 0xE931, 0xCEA3 },
        { 0xE932, 0xCEA4 },
        { 0xE933, 0xCEA5 },
        { 0xE934, 0xCEA6 },
        { 0xE935, 0xCEA7 },
        { 0xE936, 0xCEA8 },
        { 0xE937, 0xCEA9 },
        { 0xE938, 0xCEAA },
        { 0xE939, 0xCEAB },
        { 0xE93A, 0xCEAC },
        { 0xE93B, 0xCEAD },
        { 0xE93C, 0xCEAE },
        { 0xE93D, 0xCEAF },
        { 0xE93E, 0xCEB0 },
        { 0xE93F, 0xCEB1 },
        { 0xE940, 0xCEB2 },
        { 0xE941, 0xCEB3 },
        { 0xE942, 0xCEB4 },
        { 0xE943, 0xCEB5 },
        { 0xE944, 0xCEB6 },
        { 0xE945, 0xCEB7 },
        { 0xE946, 0xCEB8 },
        { 0xE947, 0xCEB9 },
        { 0xE948, 0xCEBA },
        { 0xE949, 0xCEBB },
        { 0xE94A, 0xCEBC },
        { 0xE94B, 0xCEBD },
        { 0xE94C, 0xCEBE },
        { 0xE94D, 0xCEBF },
        { 0xE94E, 0xCEC0 },
        { 0xE94F, 0xCEC1 },
        { 0xE950, 0xCEC2 },
        { 0xE951, 0xCEC3 },
        { 0xE952, 0xCEC4 },
        { 0xE953, 0xCEC5 },
        { 0xE954, 0xCEC6 },
        { 0xE955, 0xCEC7 },
        { 0xE956, 0xCEC8 },
        { 0xE957, 0xCEC9 },
        { 0xE958, 0xCECA },
        { 0xE959, 0xCECB },
        { 0xE95A, 0xCECC },
        { 0xE95B, 0xCECD },
        { 0xE95C, 0xCECE },
        { 0xE95D, 0xCECF },
        { 0xE95E, 0xCED0 },
        { 0xE95F, 0xCED1 },
        { 0xE960, 0xCED2 },
        { 0xE961, 0xCED3 },
        { 0xE962, 0xCED4 },
        { 0xE963, 0xCED5 },
        { 0xE964, 0xCED6 },
        { 0xE965, 0xCED7 },
        { 0xE966, 0xCED8 },
        { 0xE967, 0xCED9 },
        { 0xE968, 0xCEDA },
        { 0xE969, 0xCEDB },
        { 0xE96A, 0xCEDC },
        { 0xE96B, 0xCEDD },
        { 0xE96C, 0xCEDE },
        { 0xE96D, 0xCEDF },
        { 0xE96E, 0xCEE0 },
        { 0xE96F, 0xCEE1 },
        { 0xE970, 0xCEE2 },
        { 0xE971, 0xCEE3 },
        { 0xE972, 0xCEE4 },
        { 0xE973, 0xCEE5 },
        { 0xE974, 0xCEE6 },
        { 0xE975, 0xCEE7 },
        { 0xE976, 0xCEE8 },
        { 0xE977, 0xCEE9 },
        { 0xE978, 0xCEEA },
        { 0xE979, 0xCEEB },
        { 0xE97A, 0xCEEC },
        { 0xE97B, 0xCEED },
        { 0xE97C, 0xCEEE },
        { 0xE97D, 0xCEEF },
        { 0xE97E, 0xCEF0 },
        { 0xE97F, 0xCEF1 },
        { 0xE980, 0xCEF2 },
        { 0xE981, 0xCEF3 },
        { 0xE982, 0xCEF4 },
        { 0xE983, 0xCEF5 },
        { 0xE984, 0xCEF6 },
        { 0xE985, 0xCEF7 },
        { 0xE986, 0xCEF8 },
        { 0xE987, 0xCEF9 },
        { 0xE988, 0xCEFA },
        { 0xE989, 0xCEFB },
        { 0xE98A, 0xCEFC },
        { 0xE98B, 0xCEFD },
        { 0xE98C, 0xCF41 },
        { 0xE98D, 0xCF42 },
        { 0xE98E, 0xCF43 },
        { 0xE98F, 0xCF44 },
        { 0xE990, 0xCF45 },
        { 0xE991, 0xCF46 },
        { 0xE992, 0xCF47 },
        { 0xE993, 0xCF48 },
        { 0xE994, 0xCF49 },
        { 0xE995, 0xCF4A },
        { 0xE996, 0xCF4B },
        { 0xE997, 0xCF4C },
        { 0xE998, 0xCF4D },
        { 0xE999, 0xCF4E },
        { 0xE99A, 0xCF4F },
        { 0xE99B, 0xCF50 },
        { 0xE99C, 0xCF51 },
        { 0xE99D, 0xCF52 },
        { 0xE99E, 0xCF53 },
        { 0xE99F, 0xCF54 },
        { 0xE9A0, 0xCF55 },
        { 0xE9A1, 0xCF56 },
        { 0xE9A2, 0xCF57 },
        { 0xE9A3, 0xCF58 },
        { 0xE9A4, 0xCF59 },
        { 0xE9A5, 0xCF5A },
        { 0xE9A6, 0xCF5B },
        { 0xE9A7, 0xCF5C },
        { 0xE9A8, 0xCF5D },
        { 0xE9A9, 0xCF5E },
        { 0xE9AA, 0xCF5F },
        { 0xE9AB, 0xCF60 },
        { 0xE9AC, 0xCF61 },
        { 0xE9AD, 0xCF62 },
        { 0xE9AE, 0xCF63 },
        { 0xE9AF, 0xCF64 },
        { 0xE9B0, 0xCF65 },
        { 0xE9B1, 0xCF66 },
        { 0xE9B2, 0xCF67 },
        { 0xE9B3, 0xCF68 },
        { 0xE9B4, 0xCF69 },
        { 0xE9B5, 0xCF6A },
        { 0xE9B6, 0xCF6B },
        { 0xE9B7, 0xCF6C },
        { 0xE9B8, 0xCF6D },
        { 0xE9B9, 0xCF6E },
        { 0xE9BA, 0xCF6F },
        { 0xE9BB, 0xCF70 },
        { 0xE9BC, 0xCF71 },
        { 0xE9BD, 0xCF72 },
        { 0xE9BE, 0xCF73 },
        { 0xE9BF, 0xCF74 },
        { 0xE9C0, 0xCF75 },
        { 0xE9C1, 0xCF76 },
        { 0xE9C2, 0xCF77 },
        { 0xE9C3, 0xCF78 },
        { 0xE9C4, 0xCF79 },
        { 0xE9C5, 0xCF7A },
        { 0xE9C6, 0xCF7B },
        { 0xE9C7, 0xCF7C },
        { 0xE9C8, 0xCF7D },
        { 0xE9C9, 0xCF7E },
        { 0xE9CA, 0xCF7F },
        { 0xE9CB, 0xCF81 },
        { 0xE9CC, 0xCF82 },
        { 0xE9CD, 0xCF83 },
        { 0xE9CE, 0xCF84 },
        { 0xE9CF, 0xCF85 },
        { 0xE9D0, 0xCF86 },
        { 0xE9D1, 0xCF87 },
        { 0xE9D2, 0xCF88 },
        { 0xE9D3, 0xCF89 },
        { 0xE9D4, 0xCF8A },
        { 0xE9D5, 0xCF8B },
        { 0xE9D6, 0xCF8C },
        { 0xE9D7, 0xCF8D },
        { 0xE9D8, 0xCF8E },
        { 0xE9D9, 0xCF8F },
        { 0xE9DA, 0xCF90 },
        { 0xE9DB, 0xCF91 },
        { 0xE9DC, 0xCF92 },
        { 0xE9DD, 0xCF93 },
        { 0xE9DE, 0xCF94 },
        { 0xE9DF, 0xCF95 },
        { 0xE9E0, 0xCF96 },
        { 0xE9E1, 0xCF97 },
        { 0xE9E2, 0xCF98 },
        { 0xE9E3, 0xCF99 },
        { 0xE9E4, 0xCF9A },
        { 0xE9E5, 0xCF9B },
        { 0xE9E6, 0xCF9C },
        { 0xE9E7, 0xCF9D },
        { 0xE9E8, 0xCF9E },
        { 0xE9E9, 0xCF9F },
        { 0xE9EA, 0xCFA0 },
        { 0xE9EB, 0xCFA1 },
        { 0xE9EC, 0xCFA2 },
        { 0xE9ED, 0xCFA3 },
        { 0xE9EE, 0xCFA4 },
        { 0xE9EF, 0xCFA5 },
        { 0xE9F0, 0xCFA6 },
        { 0xE9F1, 0xCFA7 },
        { 0xE9F2, 0xCFA8 },
        { 0xE9F3, 0xCFA9 },
        { 0xE9F4, 0xCFAA },
        { 0xE9F5, 0xCFAB },
        { 0xE9F6, 0xCFAC },
        { 0xE9F7, 0xCFAD },
        { 0xE9F8, 0xCFAE },
        { 0xE9F9, 0xCFAF },
        { 0xE9FA, 0xCFB0 },
        { 0xE9FB, 0xCFB1 },
        { 0xE9FC, 0xCFB2 },
        { 0xE9FD, 0xCFB3 },
        { 0xE9FE, 0xCFB4 },
        { 0xE9FF, 0xCFB5 },
        { 0xEA00, 0xCFB6 },
        { 0xEA01, 0xCFB7 },
        { 0xEA02, 0xCFB8 },
        { 0xEA03, 0xCFB9 },
        { 0xEA04, 0xCFBA },
        { 0xEA05, 0xCFBB },
        { 0xEA06, 0xCFBC },
        { 0xEA07, 0xCFBD },
        { 0xEA08, 0xCFBE },
        { 0xEA09, 0xCFBF },
        { 0xEA0A, 0xCFC0 },
        { 0xEA0B, 0xCFC1 },
        { 0xEA0C, 0xCFC2 },
        { 0xEA0D, 0xCFC3 },
        { 0xEA0E, 0xCFC4 },
        { 0xEA0F, 0xCFC5 },
        { 0xEA10, 0xCFC6 },
        { 0xEA11, 0xCFC7 },
        { 0xEA12, 0xCFC8 },
        { 0xEA13, 0xCFC9 },
        { 0xEA14, 0xCFCA },
        { 0xEA15, 0xCFCB },
        { 0xEA16, 0xCFCC },
        { 0xEA17, 0xCFCD },
        { 0xEA18, 0xCFCE },
        { 0xEA19, 0xCFCF },
        { 0xEA1A, 0xCFD0 },
        { 0xEA1B, 0xCFD1 },
        { 0xEA1C, 0xCFD2 },
        { 0xEA1D, 0xCFD3 },
        { 0xEA1E, 0xCFD4 },
        { 0xEA1F, 0xCFD5 },
        { 0xEA20, 0xCFD6 },
        { 0xEA21, 0xCFD7 },
        { 0xEA22, 0xCFD8 },
        { 0xEA23, 0xCFD9 },
        { 0xEA24, 0xCFDA },
        { 0xEA25, 0xCFDB },
        { 0xEA26, 0xCFDC },
        { 0xEA27, 0xCFDD },
        { 0xEA28, 0xCFDE },
        { 0xEA29, 0xCFDF },
        { 0xEA2A, 0xCFE0 },
        { 0xEA2B, 0xCFE1 },
        { 0xEA2C, 0xCFE2 },
        { 0xEA2D, 0xCFE3 },
        { 0xEA2E, 0xCFE4 },
        { 0xEA2F, 0xCFE5 },
        { 0xEA30, 0xCFE6 },
        { 0xEA31, 0xCFE7 },
        { 0xEA32, 0xCFE8 },
        { 0xEA33, 0xCFE9 },
        { 0xEA34, 0xCFEA },
        { 0xEA35, 0xCFEB },
        { 0xEA36, 0xCFEC },
        { 0xEA37, 0xCFED },
        { 0xEA38, 0xCFEE },
        { 0xEA39, 0xCFEF },
        { 0xEA3A, 0xCFF0 },
        { 0xEA3B, 0xCFF1 },
        { 0xEA3C, 0xCFF2 },
        { 0xEA3D, 0xCFF3 },
        { 0xEA3E, 0xCFF4 },
        { 0xEA3F, 0xCFF5 },
        { 0xEA40, 0xCFF6 },
        { 0xEA41, 0xCFF7 },
        { 0xEA42, 0xCFF8 },
        { 0xEA43, 0xCFF9 },
        { 0xEA44, 0xCFFA },
        { 0xEA45, 0xCFFB },
        { 0xEA46, 0xCFFC },
        { 0xEA47, 0xCFFD },
        { 0xEA48, 0xD041 },
        { 0xEA49, 0xD042 },
        { 0xEA4A, 0xD043 },
        { 0xEA4B, 0xD044 },
        { 0xEA4C, 0xD045 },
        { 0xEA4D, 0xD046 },
        { 0xEA4E, 0xD047 },
        { 0xEA4F, 0xD048 },
        { 0xEA50, 0xD049 },
        { 0xEA51, 0xD04A },
        { 0xEA52, 0xD04B },
        { 0xEA53, 0xD04C },
        { 0xEA54, 0xD04D },
        { 0xEA55, 0xD04E },
        { 0xEA56, 0xD04F },
        { 0xEA57, 0xD050 },
        { 0xEA58, 0xD051 },
        { 0xEA59, 0xD052 },
        { 0xEA5A, 0xD053 },
        { 0xEA5B, 0xD054 },
        { 0xEA5C, 0xD055 },
        { 0xEA5D, 0xD056 },
        { 0xEA5E, 0xD057 },
        { 0xEA5F, 0xD058 },
        { 0xEA60, 0xD059 },
        { 0xEA61, 0xD05A },
        { 0xEA62, 0xD05B },
        { 0xEA63, 0xD05C },
        { 0xEA64, 0xD05D },
        { 0xEA65, 0xD05E },
        { 0xEA66, 0xD05F },
        { 0xEA67, 0xD060 },
        { 0xEA68, 0xD061 },
        { 0xEA69, 0xD062 },
        { 0xEA6A, 0xD063 },
        { 0xEA6B, 0xD064 },
        { 0xEA6C, 0xD065 },
        { 0xEA6D, 0xD066 },
        { 0xEA6E, 0xD067 },
        { 0xEA6F, 0xD068 },
        { 0xEA70, 0xD069 },
        { 0xEA71, 0xD06A },
        { 0xEA72, 0xD06B },
        { 0xEA73, 0xD06C },
        { 0xEA74, 0xD06D },
        { 0xEA75, 0xD06E },
        { 0xEA76, 0xD06F },
        { 0xEA77, 0xD070 },
        { 0xEA78, 0xD071 },
        { 0xEA79, 0xD072 },
        { 0xEA7A, 0xD073 },
        { 0xEA7B, 0xD074 },
        { 0xEA7C, 0xD075 },
        { 0xEA7D, 0xD076 },
        { 0xEA7E, 0xD077 },
        { 0xEA7F, 0xD078 },
        { 0xEA80, 0xD079 },
        { 0xEA81, 0xD07A },
        { 0xEA82, 0xD07B },
        { 0xEA83, 0xD07C },
        { 0xEA84, 0xD07D },
        { 0xEA85, 0xD07E },
        { 0xEA86, 0xD07F },
        { 0xEA87, 0xD081 },
        { 0xEA88, 0xD082 },
        { 0xEA89, 0xD083 },
        { 0xEA8A, 0xD084 },
        { 0xEA8B, 0xD085 },
        { 0xEA8C, 0xD086 },
        { 0xEA8D, 0xD087 },
        { 0xEA8E, 0xD088 },
        { 0xEA8F, 0xD089 },
        { 0xEA90, 0xD08A },
        { 0xEA91, 0xD08B },
        { 0xEA92, 0xD08C },
        { 0xEA93, 0xD08D },
        { 0xEA94, 0xD08E },
        { 0xEA95, 0xD08F },
        { 0xEA96, 0xD090 },
        { 0xEA97, 0xD091 },
        { 0xEA98, 0xD092 },
        { 0xEA99, 0xD093 },
        { 0xEA9A, 0xD094 },
        { 0xEA9B, 0xD095 },
        { 0xEA9C, 0xD096 },
        { 0xEA9D, 0xD097 },
        { 0xEA9E, 0xD098 },
        { 0xEA9F, 0xD099 },
        { 0xEAA0, 0xD09A },
        { 0xEAA1, 0xD09B },
        { 0xEAA2, 0xD09C },
        { 0xEAA3, 0xD09D },
        { 0xEAA4, 0xD09E },
        { 0xEAA5, 0xD09F },
        { 0xEAA6, 0xD0A0 },
        { 0xEAA7, 0xD0A1 },
        { 0xEAA8, 0xD0A2 },
        { 0xEAA9, 0xD0A3 },
        { 0xEAAA, 0xD0A4 },
        { 0xEAAB, 0xD0A5 },
        { 0xEAAC, 0xD0A6 },
        { 0xEAAD, 0xD0A7 },
        { 0xEAAE, 0xD0A8 },
        { 0xEAAF, 0xD0A9 },
        { 0xEAB0, 0xD0AA },
        { 0xEAB1, 0xD0AB },
        { 0xEAB2, 0xD0AC },
        { 0xEAB3, 0xD0AD },
        { 0xEAB4, 0xD0AE },
        { 0xEAB5, 0xD0AF },
        { 0xEAB6, 0xD0B0 },
        { 0xEAB7, 0xD0B1 },
        { 0xEAB8, 0xD0B2 },
        { 0xEAB9, 0xD0B3 },
        { 0xEABA, 0xD0B4 },
        { 0xEABB, 0xD0B5 },
        { 0xEABC, 0xD0B6 },
        { 0xEABD, 0xD0B7 },
        { 0xEABE, 0xD0B8 },
        { 0xEABF, 0xD0B9 },
        { 0xEAC0, 0xD0BA },
        { 0xEAC1, 0xD0BB },
        { 0xEAC2, 0xD0BC },
        { 0xEAC3, 0xD0BD },
        { 0xEAC4, 0xD0BE },
        { 0xEAC5, 0xD0BF },
        { 0xEAC6, 0xD0C0 },
        { 0xEAC7, 0xD0C1 },
        { 0xEAC8, 0xD0C2 },
        { 0xEAC9, 0xD0C3 },
        { 0xEACA, 0xD0C4 },
        { 0xEACB, 0xD0C5 },
        { 0xEACC, 0xD0C6 },
        { 0xEACD, 0xD0C7 },
        { 0xEACE, 0xD0C8 },
        { 0xEACF, 0xD0C9 },
        { 0xEAD0, 0xD0CA },
        { 0xEAD1, 0xD0CB },
        { 0xEAD2, 0xD0CC },
        { 0xEAD3, 0xD0CD },
        { 0xEAD4, 0xD0CE },
        { 0xEAD5, 0xD0CF },
        { 0xEAD6, 0xD0D0 },
        { 0xEAD7, 0xD0D1 },
        { 0xEAD8, 0xD0D2 },
        { 0xEAD9, 0xD0D3 },
        { 0xEADA, 0xD0D4 },
        { 0xEADB, 0xD0D5 },
        { 0xEADC, 0xD0D6 },
        { 0xEADD, 0xD0D7 },
        { 0xEADE, 0xD0D8 },
        { 0xEADF, 0xD0D9 },
        { 0xEAE0, 0xD0DA },
        { 0xEAE1, 0xD0DB },
        { 0xEAE2, 0xD0DC },
        { 0xEAE3, 0xD0DD },
        { 0xEAE4, 0xD0DE },
        { 0xEAE5, 0xD0DF },
        { 0xEAE6, 0xD0E0 },
        { 0xEAE7, 0xD0E1 },
        { 0xEAE8, 0xD0E2 },
        { 0xEAE9, 0xD0E3 },
        { 0xEAEA, 0xD0E4 },
        { 0xEAEB, 0xD0E5 },
        { 0xEAEC, 0xD0E6 },
        { 0xEAED, 0xD0E7 },
        { 0xEAEE, 0xD0E8 },
        { 0xEAEF, 0xD0E9 },
        { 0xEAF0, 0xD0EA },
        { 0xEAF1, 0xD0EB },
        { 0xEAF2, 0xD0EC },
        { 0xEAF3, 0xD0ED },
        { 0xEAF4, 0xD0EE },
        { 0xEAF5, 0xD0EF },
        { 0xEAF6, 0xD0F0 },
        { 0xEAF7, 0xD0F1 },
        { 0xEAF8, 0xD0F2 },
        { 0xEAF9, 0xD0F3 },
        { 0xEAFA, 0xD0F4 },
        { 0xEAFB, 0xD0F5 },
        { 0xEAFC, 0xD0F6 },
        { 0xEAFD, 0xD0F7 },
        { 0xEAFE, 0xD0F8 },
        { 0xEAFF, 0xD0F9 },
        { 0xEB00, 0xD0FA },
        { 0xEB01, 0xD0FB },
        { 0xEB02, 0xD0FC },
        { 0xEB03, 0xD0FD },
        { 0xEB04, 0xD141 },
        { 0xEB05, 0xD142 },
        { 0xEB06, 0xD143 },
        { 0xEB07, 0xD144 },
        { 0xEB08, 0xD145 },
        { 0xEB09, 0xD146 },
        { 0xEB0A, 0xD147 },
        { 0xEB0B, 0xD148 },
        { 0xEB0C, 0xD149 },
        { 0xEB0D, 0xD14A },
        { 0xEB0E, 0xD14B },
        { 0xEB0F, 0xD14C },
        { 0xEB10, 0xD14D },
        { 0xEB11, 0xD14E },
        { 0xEB12, 0xD14F },
        { 0xEB13, 0xD150 },
        { 0xEB14, 0xD151 },
        { 0xEB15, 0xD152 },
        { 0xEB16, 0xD153 },
        { 0xEB17, 0xD154 },
        { 0xEB18, 0xD155 },
        { 0xEB19, 0xD156 },
        { 0xEB1A, 0xD157 },
        { 0xEB1B, 0xD158 },
        { 0xEB1C, 0xD159 },
        { 0xEB1D, 0xD15A },
        { 0xEB1E, 0xD15B },
        { 0xEB1F, 0xD15C },
        { 0xEB20, 0xD15D },
        { 0xEB21, 0xD15E },
        { 0xEB22, 0xD15F },
        { 0xEB23, 0xD160 },
        { 0xEB24, 0xD161 },
        { 0xEB25, 0xD162 },
        { 0xEB26, 0xD163 },
        { 0xEB27, 0xD164 },
        { 0xEB28, 0xD165 },
        { 0xEB29, 0xD166 },
        { 0xEB2A, 0xD167 },
        { 0xEB2B, 0xD168 },
        { 0xEB2C, 0xD169 },
        { 0xEB2D, 0xD16A },
        { 0xEB2E, 0xD16B },
        { 0xEB2F, 0xD16C },
        { 0xEB30, 0xD16D },
        { 0xEB31, 0xD16E },
        { 0xEB32, 0xD16F },
        { 0xEB33, 0xD170 },
        { 0xEB34, 0xD171 },
        { 0xEB35, 0xD172 },
        { 0xEB36, 0xD173 },
        { 0xEB37, 0xD174 },
        { 0xEB38, 0xD175 },
        { 0xEB39, 0xD176 },
        { 0xEB3A, 0xD177 },
        { 0xEB3B, 0xD178 },
        { 0xEB3C, 0xD179 },
        { 0xEB3D, 0xD17A },
        { 0xEB3E, 0xD17B },
        { 0xEB3F, 0xD17C },
        { 0xEB40, 0xD17D },
        { 0xEB41, 0xD17E },
        { 0xEB42, 0xD17F },
        { 0xEB43, 0xD181 },
        { 0xEB44, 0xD182 },
        { 0xEB45, 0xD183 },
        { 0xEB46, 0xD184 },
        { 0xEB47, 0xD185 },
        { 0xEB48, 0xD186 },
        { 0xEB49, 0xD187 },
        { 0xEB4A, 0xD188 },
        { 0xEB4B, 0xD189 },
        { 0xEB4C, 0xD18A },
        { 0xEB4D, 0xD18B },
        { 0xEB4E, 0xD18C },
        { 0xEB4F, 0xD18D },
        { 0xEB50, 0xD18E },
        { 0xEB51, 0xD18F },
        { 0xEB52, 0xD190 },
        { 0xEB53, 0xD191 },
        { 0xEB54, 0xD192 },
        { 0xEB55, 0xD193 },
        { 0xEB56, 0xD194 },
        { 0xEB57, 0xD195 },
        { 0xEB58, 0xD196 },
        { 0xEB59, 0xD197 },
        { 0xEB5A, 0xD198 },
        { 0xEB5B, 0xD199 },
        { 0xEB5C, 0xD19A },
        { 0xEB5D, 0xD19B },
        { 0xEB5E, 0xD19C },
        { 0xEB5F, 0xD19D },
        { 0xEB60, 0xD19E },
        { 0xEB61, 0xD19F },
        { 0xEB62, 0xD1A0 },
        { 0xEB63, 0xD1A1 },
        { 0xEB64, 0xD1A2 },
        { 0xEB65, 0xD1A3 },
        { 0xEB66, 0xD1A4 },
        { 0xEB67, 0xD1A5 },
        { 0xEB68, 0xD1A6 },
        { 0xEB69, 0xD1A7 },
        { 0xEB6A, 0xD1A8 },
        { 0xEB6B, 0xD1A9 },
        { 0xEB6C, 0xD1AA },
        { 0xEB6D, 0xD1AB },
        { 0xEB6E, 0xD1AC },
        { 0xEB6F, 0xD1AD },
        { 0xEB70, 0xD1AE },
        { 0xEB71, 0xD1AF },
        { 0xEB72, 0xD1B0 },
        { 0xEB73, 0xD1B1 },
        { 0xEB74, 0xD1B2 },
        { 0xEB75, 0xD1B3 },
        { 0xEB76, 0xD1B4 },
        { 0xEB77, 0xD1B5 },
        { 0xEB78, 0xD1B6 },
        { 0xEB79, 0xD1B7 },
        { 0xEB7A, 0xD1B8 },
        { 0xEB7B, 0xD1B9 },
        { 0xEB7C, 0xD1BA },
        { 0xEB7D, 0xD1BB },
        { 0xEB7E, 0xD1BC },
        { 0xEB7F, 0xD1BD },
        { 0xEB80, 0xD1BE },
        { 0xEB81, 0xD1BF },
        { 0xEB82, 0xD1C0 },
        { 0xEB83, 0xD1C1 },
        { 0xEB84, 0xD1C2 },
        { 0xEB85, 0xD1C3 },
        { 0xEB86, 0xD1C4 },
        { 0xEB87, 0xD1C5 },
        { 0xEB88, 0xD1C6 },
        { 0xEB89, 0xD1C7 },
        { 0xEB8A, 0xD1C8 },
        { 0xEB8B, 0xD1C9 },
        { 0xEB8C, 0xD1CA },
        { 0xEB8D, 0xD1CB },
        { 0xEB8E, 0xD1CC },
        { 0xEB8F, 0xD1CD },
        { 0xEB90, 0xD1CE },
        { 0xEB91, 0xD1CF },
        { 0xEB92, 0xD1D0 },
        { 0xEB93, 0xD1D1 },
        { 0xEB94, 0xD1D2 },
        { 0xEB95, 0xD1D3 },
        { 0xEB96, 0xD1D4 },
        { 0xEB97, 0xD1D5 },
        { 0xEB98, 0xD1D6 },
        { 0xEB99, 0xD1D7 },
        { 0xEB9A, 0xD1D8 },
        { 0xEB9B, 0xD1D9 },
        { 0xEB9C, 0xD1DA },
        { 0xEB9D, 0xD1DB },
        { 0xEB9E, 0xD1DC },
        { 0xEB9F, 0xD1DD },
        { 0xEBA0, 0xD1DE },
        { 0xEBA1, 0xD1DF },
        { 0xEBA2, 0xD1E0 },
        { 0xEBA3, 0xD1E1 },
        { 0xEBA4, 0xD1E2 },
        { 0xEBA5, 0xD1E3 },
        { 0xEBA6, 0xD1E4 },
        { 0xEBA7, 0xD1E5 },
        { 0xEBA8, 0xD1E6 },
        { 0xEBA9, 0xD1E7 },
        { 0xEBAA, 0xD1E8 },
        { 0xEBAB, 0xD1E9 },
        { 0xEBAC, 0xD1EA },
        { 0xEBAD, 0xD1EB },
        { 0xEBAE, 0xD1EC },
        { 0xEBAF, 0xD1ED },
        { 0xEBB0, 0xD1EE },
        { 0xEBB1, 0xD1EF },
        { 0xEBB2, 0xD1F0 },
        { 0xEBB3, 0xD1F1 },
        { 0xEBB4, 0xD1F2 },
        { 0xEBB5, 0xD1F3 },
        { 0xEBB6, 0xD1F4 },
        { 0xEBB7, 0xD1F5 },
        { 0xEBB8, 0xD1F6 },
        { 0xEBB9, 0xD1F7 },
        { 0xEBBA, 0xD1F8 },
        { 0xEBBB, 0xD1F9 },
        { 0xEBBC, 0xD1FA },
        { 0xEBBD, 0xD1FB },
        { 0xEBBE, 0xD1FC },
        { 0xEBBF, 0xD1FD },
        { 0xEBC0, 0xD241 },
        { 0xEBC1, 0xD242 },
        { 0xEBC2, 0xD243 },
        { 0xEBC3, 0xD244 },
        { 0xEBC4, 0xD245 },
        { 0xEBC5, 0xD246 },
        { 0xEBC6, 0xD247 },
        { 0xEBC7, 0xD248 },
        { 0xEBC8, 0xD249 },
        { 0xEBC9, 0xD24A },
        { 0xEBCA, 0xD24B },
        { 0xEBCB, 0xD24C },
        { 0xEBCC, 0xD24D },
        { 0xEBCD, 0xD24E },
        { 0xEBCE, 0xD24F },
        { 0xEBCF, 0xD250 },
        { 0xEBD0, 0xD251 },
        { 0xEBD1, 0xD252 },
        { 0xEBD2, 0xD253 },
        { 0xEBD3, 0xD254 },
        { 0xEBD4, 0xD255 },
        { 0xEBD5, 0xD256 },
        { 0xEBD6, 0xD257 },
        { 0xEBD7, 0xD258 },
        { 0xEBD8, 0xD259 },
        { 0xEBD9, 0xD25A },
        { 0xEBDA, 0xD25B },
        { 0xEBDB, 0xD25C },
        { 0xEBDC, 0xD25D },
        { 0xEBDD, 0xD25E },
        { 0xEBDE, 0xD25F },
        { 0xEBDF, 0xD260 },
        { 0xEBE0, 0xD261 },
        { 0xEBE1, 0xD262 },
        { 0xEBE2, 0xD263 },
        { 0xEBE3, 0xD264 },
        { 0xEBE4, 0xD265 },
        { 0xEBE5, 0xD266 },
        { 0xEBE6, 0xD267 },
        { 0xEBE7, 0xD268 },
        { 0xEBE8, 0xD269 },
        { 0xEBE9, 0xD26A },
        { 0xEBEA, 0xD26B },
        { 0xEBEB, 0xD26C },
        { 0xEBEC, 0xD26D },
        { 0xEBED, 0xD26E },
        { 0xEBEE, 0xD26F },
        { 0xEBEF, 0xD270 },
        { 0xEBF0, 0xD271 },
        { 0xEBF1, 0xD272 },
        { 0xEBF2, 0xD273 },
        { 0xEBF3, 0xD274 },
        { 0xEBF4, 0xD275 },
        { 0xEBF5, 0xD276 },
        { 0xEBF6, 0xD277 },
        { 0xEBF7, 0xD278 },
        { 0xEBF8, 0xD279 },
        { 0xEBF9, 0xD27A },
        { 0xEBFA, 0xD27B },
        { 0xEBFB, 0xD27C },
        { 0xEBFC, 0xD27D },
        { 0xEBFD, 0xD27E },
        { 0xEBFE, 0xD27F },
        { 0xEBFF, 0xD281 },
        { 0xEC00, 0xD282 },
        { 0xEC01, 0xD283 },
        { 0xEC02, 0xD284 },
        { 0xEC03, 0xD285 },
        { 0xEC04, 0xD286 },
        { 0xEC05, 0xD287 },
        { 0xEC06, 0xD288 },
        { 0xEC07, 0xD289 },
        { 0xEC08, 0xD28A },
        { 0xEC09, 0xD28B },
        { 0xEC0A, 0xD28C },
        { 0xEC0B, 0xD28D },
        { 0xEC0C, 0xD28E },
        { 0xEC0D, 0xD28F },
        { 0xEC0E, 0xD290 },
        { 0xEC0F, 0xD291 },
        { 0xEC10, 0xD292 },
        { 0xEC11, 0xD293 },
        { 0xEC12, 0xD294 },
        { 0xEC13, 0xD295 },
        { 0xEC14, 0xD296 },
        { 0xEC15, 0xD297 },
        { 0xEC16, 0xD298 },
        { 0xEC17, 0xD299 },
        { 0xEC18, 0xD29A },
        { 0xEC19, 0xD29B },
        { 0xEC1A, 0xD29C },
        { 0xEC1B, 0xD29D },
        { 0xEC1C, 0xD29E },
        { 0xEC1D, 0xD29F },
        { 0xEC1E, 0xD2A0 },
        { 0xEC1F, 0xD2A1 },
        { 0xEC20, 0xD2A2 },
        { 0xEC21, 0xD2A3 },
        { 0xEC22, 0xD2A4 },
        { 0xEC23, 0xD2A5 },
        { 0xEC24, 0xD2A6 },
        { 0xEC25, 0xD2A7 },
        { 0xEC26, 0xD2A8 },
        { 0xEC27, 0xD2A9 },
        { 0xEC28, 0xD2AA },
        { 0xEC29, 0xD2AB },
        { 0xEC2A, 0xD2AC },
        { 0xEC2B, 0xD2AD },
        { 0xEC2C, 0xD2AE },
        { 0xEC2D, 0xD2AF },
        { 0xEC2E, 0xD2B0 },
        { 0xEC2F, 0xD2B1 },
        { 0xEC30, 0xD2B2 },
        { 0xEC31, 0xD2B3 },
        { 0xEC32, 0xD2B4 },
        { 0xEC33, 0xD2B5 },
        { 0xEC34, 0xD2B6 },
        { 0xEC35, 0xD2B7 },
        { 0xEC36, 0xD2B8 },
        { 0xEC37, 0xD2B9 },
        { 0xEC38, 0xD2BA },
        { 0xEC39, 0xD2BB },
        { 0xEC3A, 0xD2BC },
        { 0xEC3B, 0xD2BD },
        { 0xEC3C, 0xD2BE },
        { 0xEC3D, 0xD2BF },
        { 0xEC3E, 0xD2C0 },
        { 0xEC3F, 0xD2C1 },
        { 0xEC40, 0xD2C2 },
        { 0xEC41, 0xD2C3 },
        { 0xEC42, 0xD2C4 },
        { 0xEC43, 0xD2C5 },
        { 0xEC44, 0xD2C6 },
        { 0xEC45, 0xD2C7 },
        { 0xEC46, 0xD2C8 },
        { 0xEC47, 0xD2C9 },
        { 0xEC48, 0xD2CA },
        { 0xEC49, 0xD2CB },
        { 0xEC4A, 0xD2CC },
        { 0xEC4B, 0xD2CD },
        { 0xEC4C, 0xD2CE },
        { 0xEC4D, 0xD2CF },
        { 0xEC4E, 0xD2D0 },
        { 0xEC4F, 0xD2D1 },
        { 0xEC50, 0xD2D2 },
        { 0xEC51, 0xD2D3 },
        { 0xEC52, 0xD2D4 },
        { 0xEC53, 0xD2D5 },
        { 0xEC54, 0xD2D6 },
        { 0xEC55, 0xD2D7 },
        { 0xEC56, 0xD2D8 },
        { 0xEC57, 0xD2D9 },
        { 0xEC58, 0xD2DA },
        { 0xEC59, 0xD2DB },
        { 0xEC5A, 0xD2DC },
        { 0xEC5B, 0xD2DD },
        { 0xEC5C, 0xD2DE },
        { 0xEC5D, 0xD2DF },
        { 0xEC5E, 0xD2E0 },
        { 0xEC5F, 0xD2E1 },
        { 0xEC60, 0xD2E2 },
        { 0xEC61, 0xD2E3 },
        { 0xEC62, 0xD2E4 },
        { 0xEC63, 0xD2E5 },
        { 0xEC64, 0xD2E6 },
        { 0xEC65, 0xD2E7 },
        { 0xEC66, 0xD2E8 },
        { 0xEC67, 0xD2E9 },
        { 0xEC68, 0xD2EA },
        { 0xEC69, 0xD2EB },
        { 0xEC6A, 0xD2EC },
        { 0xEC6B, 0xD2ED },
        { 0xEC6C, 0xD2EE },
        { 0xEC6D, 0xD2EF },
        { 0xEC6E, 0xD2F0 },
        { 0xEC6F, 0xD2F1 },
        { 0xEC70, 0xD2F2 },
        { 0xEC71, 0xD2F3 },
        { 0xEC72, 0xD2F4 },
        { 0xEC73, 0xD2F5 },
        { 0xEC74, 0xD2F6 },
        { 0xEC75, 0xD2F7 },
        { 0xEC76, 0xD2F8 },
        { 0xEC77, 0xD2F9 },
        { 0xEC78, 0xD2FA },
        { 0xEC79, 0xD2FB },
        { 0xEC7A, 0xD2FC },
        { 0xEC7B, 0xD2FD },
        { 0xEC7C, 0xD341 },
        { 0xEC7D, 0xD342 },
        { 0xEC7E, 0xD343 },
        { 0xEC7F, 0xD344 },
        { 0xEC80, 0xD345 },
        { 0xEC81, 0xD346 },
        { 0xEC82, 0xD347 },
        { 0xEC83, 0xD348 },
        { 0xEC84, 0xD349 },
        { 0xEC85, 0xD34A },
        { 0xEC86, 0xD34B },
        { 0xEC87, 0xD34C },
        { 0xEC88, 0xD34D },
        { 0xEC89, 0xD34E },
        { 0xEC8A, 0xD34F },
        { 0xEC8B, 0xD350 },
        { 0xEC8C, 0xD351 },
        { 0xEC8D, 0xD352 },
        { 0xEC8E, 0xD353 },
        { 0xEC8F, 0xD354 },
        { 0xEC90, 0xD355 },
        { 0xEC91, 0xD356 },
        { 0xEC92, 0xD357 },
        { 0xEC93, 0xD358 },
        { 0xEC94, 0xD359 },
        { 0xEC95, 0xD35A },
        { 0xEC96, 0xD35B },
        { 0xEC97, 0xD35C },
        { 0xEC98, 0xD35D },
        { 0xEC99, 0xD35E },
        { 0xEC9A, 0xD35F },
        { 0xEC9B, 0xD360 },
        { 0xEC9C, 0xD361 },
        { 0xEC9D, 0xD362 },
        { 0xEC9E, 0xD363 },
        { 0xEC9F, 0xD364 },
        { 0xECA0, 0xD365 },
        { 0xECA1, 0xD366 },
        { 0xECA2, 0xD367 },
        { 0xECA3, 0xD368 },
        { 0xECA4, 0xD369 },
        { 0xECA5, 0xD36A },
        { 0xECA6, 0xD36B },
        { 0xECA7, 0xD36C },
        { 0xECA8, 0xD36D },
        { 0xECA9, 0xD36E },
        { 0xECAA, 0xD36F },
        { 0xECAB, 0xD370 },
        { 0xECAC, 0xD371 },
        { 0xECAD, 0xD372 },
        { 0xECAE, 0xD373 },
        { 0xECAF, 0xD374 },
        { 0xECB0, 0xD375 },
        { 0xECB1, 0xD376 },
        { 0xECB2, 0xD377 },
        { 0xECB3, 0xD378 },
        { 0xECB4, 0xD379 },
        { 0xECB5, 0xD37A },
        { 0xECB6, 0xD37B },
        { 0xECB7, 0xD37C },
        { 0xECB8, 0xD37D },
        { 0xECB9, 0xD37E },
        { 0xECBA, 0xD37F },
        { 0xECBB, 0xD381 },
        { 0xECBC, 0xD382 },
        { 0xECBD, 0xD383 },
        { 0xECBE, 0xD384 },
        { 0xECBF, 0xD385 },
        { 0xECC0, 0xD386 },
        { 0xECC1, 0xD387 },
        { 0xECC2, 0xD388 },
        { 0xECC3, 0xD389 },
        { 0xECC4, 0xD38A },
        { 0xECC5, 0xD38B },
        { 0xECC6, 0xD38C },
        { 0xECC7, 0xD38D },
        { 0xECC8, 0xD38E },
        { 0xECC9, 0xD38F },
        { 0xECCA, 0xD390 },
        { 0xECCB, 0xD391 },
        { 0xECCC, 0xD392 },
        { 0xECCD, 0xD393 },
        { 0xECCE, 0xD394 },
        { 0xECCF, 0xD395 },
        { 0xECD0, 0xD396 },
        { 0xECD1, 0xD397 },
        { 0xECD2, 0xD398 },
        { 0xECD3, 0xD399 },
        { 0xECD4, 0xD39A },
        { 0xECD5, 0xD39B },
        { 0xECD6, 0xD39C },
        { 0xECD7, 0xD39D },
        { 0xECD8, 0xD39E },
        { 0xECD9, 0xD39F },
        { 0xECDA, 0xD3A0 },
        { 0xECDB, 0xD3A1 },
        { 0xECDC, 0xD3A2 },
        { 0xECDD, 0xD3A3 },
        { 0xECDE, 0xD3A4 },
        { 0xECDF, 0xD3A5 },
        { 0xECE0, 0xD3A6 },
        { 0xECE1, 0xD3A7 },
        { 0xECE2, 0xD3A8 },
        { 0xECE3, 0xD3A9 },
        { 0xECE4, 0xD3AA },
        { 0xECE5, 0xD3AB },
        { 0xECE6, 0xD3AC },
        { 0xECE7, 0xD3AD },
        { 0xECE8, 0xD3AE },
        { 0xECE9, 0xD3AF },
        { 0xECEA, 0xD3B0 },
        { 0xECEB, 0xD3B1 },
        { 0xECEC, 0xD3B2 },
        { 0xECED, 0xD3B3 },
        { 0xECEE, 0xD3B4 },
        { 0xECEF, 0xD3B5 },
        { 0xECF0, 0xD3B6 },
        { 0xECF1, 0xD3B7 },
        { 0xECF2, 0xD3B8 },
        { 0xECF3, 0xD3B9 },
        { 0xECF4, 0xD3BA },
        { 0xECF5, 0xD3BB },
        { 0xECF6, 0xD3BC },
        { 0xECF7, 0xD3BD },
        { 0xECF8, 0xD3BE },
        { 0xECF9, 0xD3BF },
        { 0xECFA, 0xD3C0 },
        { 0xECFB, 0xD3C1 },
        { 0xECFC, 0xD3C2 },
        { 0xECFD, 0xD3C3 },
        { 0xECFE, 0xD3C4 },
        { 0xECFF, 0xD3C5 },
        { 0xED00, 0xD3C6 },
        { 0xED01, 0xD3C7 },
        { 0xED02, 0xD3C8 },
        { 0xED03, 0xD3C9 },
        { 0xED04, 0xD3CA },
        { 0xED05, 0xD3CB },
        { 0xED06, 0xD3CC },
        { 0xED07, 0xD3CD },
        { 0xED08, 0xD3CE },
        { 0xED09, 0xD3CF },
        { 0xED0A, 0xD3D0 },
        { 0xED0B, 0xD3D1 },
        { 0xED0C, 0xD3D2 },
        { 0xED0D, 0xD3D3 },
        { 0xED0E, 0xD3D4 },
        { 0xED0F, 0xD3D5 },
        { 0xED10, 0xD3D6 },
        { 0xED11, 0xD3D7 },
        { 0xED12, 0xD3D8 },
        { 0xED13, 0xD3D9 },
        { 0xED14, 0xD3DA },
        { 0xED15, 0xD3DB },
        { 0xED16, 0xD3DC },
        { 0xED17, 0xD3DD },
        { 0xED18, 0xD3DE },
        { 0xED19, 0xD3DF },
        { 0xED1A, 0xD3E0 },
        { 0xED1B, 0xD3E1 },
        { 0xED1C, 0xD3E2 },
        { 0xED1D, 0xD3E3 },
        { 0xED1E, 0xD3E4 },
        { 0xED1F, 0xD3E5 },
        { 0xED20, 0xD3E6 },
        { 0xED21, 0xD3E7 },
        { 0xED22, 0xD3E8 },
        { 0xED23, 0xD3E9 },
        { 0xED24, 0xD3EA },
        { 0xED25, 0xD3EB },
        { 0xED26, 0xD3EC },
        { 0xED27, 0xD3ED },
        { 0xED28, 0xD3EE },
        { 0xED29, 0xD3EF },
        { 0xED2A, 0xD3F0 },
        { 0xED2B, 0xD3F1 },
        { 0xED2C, 0xD3F2 },
        { 0xED2D, 0xD3F3 },
        { 0xED2E, 0xD3F4 },
        { 0xED2F, 0xD3F5 },
        { 0xED30, 0xD3F6 },
        { 0xED31, 0xD3F7 },
        { 0xED32, 0xD3F8 },
        { 0xED33, 0xD3F9 },
        { 0xED34, 0xD3FA },
        { 0xED35, 0xD3FB },
        { 0xED36, 0xD3FC },
        { 0xED37, 0xD3FD },
        { 0xED38, 0xD441 },
        { 0xED39, 0xD442 },
        { 0xED3A, 0xD443 },
        { 0xED3B, 0xD444 },
        { 0xED3C, 0xD445 },
        { 0xED3D, 0xD446 },
        { 0xED3E, 0xD447 },
        { 0xED3F, 0xD448 },
        { 0xED40, 0xD449 },
        { 0xED41, 0xD44A },
        { 0xED42, 0xD44B },
        { 0xED43, 0xD44C },
        { 0xED44, 0xD44D },
        { 0xED45, 0xD44E },
        { 0xED46, 0xD44F },
        { 0xED47, 0xD450 },
        { 0xED48, 0xD451 },
        { 0xED49, 0xD452 },
        { 0xED4A, 0xD453 },
        { 0xED4B, 0xD454 },
        { 0xED4C, 0xD455 },
        { 0xED4D, 0xD456 },
        { 0xED4E, 0xD457 },
        { 0xED4F, 0xD458 },
        { 0xED50, 0xD459 },
        { 0xED51, 0xD45A },
        { 0xED52, 0xD45B },
        { 0xED53, 0xD45C },
        { 0xED54, 0xD45D },
        { 0xED55, 0xD45E },
        { 0xED56, 0xD45F },
        { 0xED57, 0xD460 },
        { 0xED58, 0xD461 },
        { 0xED59, 0xD462 },
        { 0xED5A, 0xD463 },
        { 0xED5B, 0xD464 },
        { 0xED5C, 0xD465 },
        { 0xED5D, 0xD466 },
        { 0xED5E, 0xD467 },
        { 0xED5F, 0xD468 },
        { 0xED60, 0xD469 },
        { 0xED61, 0xD46A },
        { 0xED62, 0xD46B },
        { 0xED63, 0xD46C },
        { 0xED64, 0xD46D },
        { 0xED65, 0xD46E },
        { 0xED66, 0xD46F },
        { 0xED67, 0xD470 },
        { 0xED68, 0xD471 },
        { 0xED69, 0xD472 },
        { 0xED6A, 0xD473 },
        { 0xED6B, 0xD474 },
        { 0xED6C, 0xD475 },
        { 0xED6D, 0xD476 },
        { 0xED6E, 0xD477 },
        { 0xED6F, 0xD478 },
        { 0xED70, 0xD479 },
        { 0xED71, 0xD47A },
        { 0xED72, 0xD47B },
        { 0xED73, 0xD47C },
        { 0xED74, 0xD47D },
        { 0xED75, 0xD47E },
        { 0xED76, 0xD47F },
        { 0xED77, 0xD481 },
        { 0xED78, 0xD482 },
        { 0xED79, 0xD483 },
        { 0xED7A, 0xD484 },
        { 0xED7B, 0xD485 },
        { 0xED7C, 0xD486 },
        { 0xED7D, 0xD487 },
        { 0xED7E, 0xD488 },
        { 0xED7F, 0xD489 },
        { 0xED80, 0xD48A },
        { 0xED81, 0xD48B },
        { 0xED82, 0xD48C },
        { 0xED83, 0xD48D },
        { 0xED84, 0xD48E },
        { 0xED85, 0xD48F },
        { 0xED86, 0xD490 },
        { 0xED87, 0xD491 },
        { 0xED88, 0xD492 },
        { 0xED89, 0xD493 },
        { 0xED8A, 0xD494 },
        { 0xED8B, 0xD495 },
        { 0xED8C, 0xD496 },
        { 0xED8D, 0xD497 },
        { 0xED8E, 0xD498 },
        { 0xED8F, 0xD499 },
        { 0xED90, 0xD49A },
        { 0xED91, 0xD49B },
        { 0xED92, 0xD49C },
        { 0xED93, 0xD49D },
        { 0xED94, 0xD49E },
        { 0xED95, 0xD49F },
        { 0xED96, 0xD4A0 },
        { 0xED97, 0xD4A1 },
        { 0xED98, 0xD4A2 },
        { 0xED99, 0xD4A3 },
        { 0xED9A, 0xD4A4 },
        { 0xED9B, 0xD4A5 },
        { 0xED9C, 0xD4A6 },
        { 0xED9D, 0xD4A7 },
        { 0xED9E, 0xD4A8 },
        { 0xED9F, 0xD4A9 },
        { 0xEDA0, 0xD4AA },
        { 0xEDA1, 0xD4AB },
        { 0xEDA2, 0xD4AC },
        { 0xEDA3, 0xD4AD },
        { 0xEDA4, 0xD4AE },
        { 0xEDA5, 0xD4AF },
        { 0xEDA6, 0xD4B0 },
        { 0xEDA7, 0xD4B1 },
        { 0xEDA8, 0xD4B2 },
        { 0xEDA9, 0xD4B3 },
        { 0xEDAA, 0xD4B4 },
        { 0xEDAB, 0xD4B5 },
        { 0xEDAC, 0xD4B6 },
        { 0xEDAD, 0xD4B7 },
        { 0xEDAE, 0xD4B8 },
        { 0xEDAF, 0xD4B9 },
        { 0xEDB0, 0xD4BA },
        { 0xEDB1, 0xD4BB },
        { 0xEDB2, 0xD4BC },
        { 0xEDB3, 0xD4BD },
        { 0xEDB4, 0xD4BE },
        { 0xEDB5, 0xD4BF },
        { 0xEDB6, 0xD4C0 },
        { 0xEDB7, 0xD4C1 },
        { 0xEDB8, 0xD4C2 },
        { 0xEDB9, 0xD4C3 },
        { 0xEDBA, 0xD4C4 },
        { 0xEDBB, 0xD4C5 },
        { 0xEDBC, 0xD4C6 },
        { 0xEDBD, 0xD4C7 },
        { 0xEDBE, 0xD4C8 },
        { 0xEDBF, 0xD4C9 },
        { 0xEDC0, 0xD4CA },
        { 0xEDC1, 0xD4CB },
        { 0xEDC2, 0xD4CC },
        { 0xEDC3, 0xD4CD },
        { 0xEDC4, 0xD4CE },
        { 0xEDC5, 0xD4CF },
        { 0xEDC6, 0xD4D0 },
        { 0xEDC7, 0xD4D1 },
        { 0xEDC8, 0xD4D2 },
        { 0xEDC9, 0xD4D3 },
        { 0xEDCA, 0xD4D4 },
        { 0xEDCB, 0xD4D5 },
        { 0xEDCC, 0xD4D6 },
        { 0xEDCD, 0xD4D7 },
        { 0xEDCE, 0xD4D8 },
        { 0xEDCF, 0xD4D9 },
        { 0xEDD0, 0xD4DA },
        { 0xEDD1, 0xD4DB },
        { 0xEDD2, 0xD4DC },
        { 0xEDD3, 0xD4DD },
        { 0xEDD4, 0xD4DE },
        { 0xEDD5, 0xD4DF },
        { 0xEDD6, 0xD4E0 },
        { 0xEDD7, 0xD4E1 },
        { 0xEDD8, 0xD4E2 },
        { 0xEDD9, 0xD4E3 },
        { 0xEDDA, 0xD4E4 },
        { 0xEDDB, 0xD4E5 },
        { 0xEDDC, 0xD4E6 },
        { 0xEDDD, 0xD4E7 },
        { 0xEDDE, 0xD4E8 },
        { 0xEDDF, 0xD4E9 },
        { 0xEDE0, 0xD4EA },
        { 0xEDE1, 0xD4EB },
        { 0xEDE2, 0xD4EC },
        { 0xEDE3, 0xD4ED },
        { 0xEDE4, 0xD4EE },
        { 0xEDE5, 0xD4EF },
        { 0xEDE6, 0xD4F0 },
        { 0xEDE7, 0xD4F1 },
        { 0xEDE8, 0xD4F2 },
        { 0xEDE9, 0xD4F3 },
        { 0xEDEA, 0xD4F4 },
        { 0xEDEB, 0xD4F5 },
        { 0xEDEC, 0xD4F6 },
        { 0xEDED, 0xD4F7 },
        { 0xEDEE, 0xD4F8 },
        { 0xEDEF, 0xD4F9 },
        { 0xEDF0, 0xD4FA },
        { 0xEDF1, 0xD4FB },
        { 0xEDF2, 0xD4FC },
        { 0xEDF3, 0xD4FD },
        { 0xEDF4, 0xD541 },
        { 0xEDF5, 0xD542 },
        { 0xEDF6, 0xD543 },
        { 0xEDF7, 0xD544 },
        { 0xEDF8, 0xD545 },
        { 0xEDF9, 0xD546 },
        { 0xEDFA, 0xD547 },
        { 0xEDFB, 0xD548 },
        { 0xEDFC, 0xD549 },
        { 0xEDFD, 0xD54A },
        { 0xEDFE, 0xD54B },
        { 0xEDFF, 0xD54C },
        { 0xEE00, 0xD54D },
        { 0xEE01, 0xD54E },
        { 0xEE02, 0xD54F },
        { 0xEE03, 0xD550 },
        { 0xEE04, 0xD551 },
        { 0xEE05, 0xD552 },
        { 0xEE06, 0xD553 },
        { 0xEE07, 0xD554 },
        { 0xEE08, 0xD555 },
        { 0xEE09, 0xD556 },
        { 0xEE0A, 0xD557 },
        { 0xEE0B, 0xD558 },
        { 0xEE0C, 0xD559 },
        { 0xEE0D, 0xD55A },
        { 0xEE0E, 0xD55B },
        { 0xEE0F, 0xD55C },
        { 0xEE10, 0xD55D },
        { 0xEE11, 0xD55E },
        { 0xEE12, 0xD55F },
        { 0xEE13, 0xD560 },
        { 0xEE14, 0xD561 },
        { 0xEE15, 0xD562 },
        { 0xEE16, 0xD563 },
        { 0xEE17, 0xD564 },
        { 0xEE18, 0xD565 },
        { 0xEE19, 0xD566 },
        { 0xEE1A, 0xD567 },
        { 0xEE1B, 0xD568 },
        { 0xEE1C, 0xD569 },
        { 0xEE1D, 0xD56A },
        { 0xEE1E, 0xD56B },
        { 0xEE1F, 0xD56C },
        { 0xEE20, 0xD56D },
        { 0xEE21, 0xD56E },
        { 0xEE22, 0xD56F },
        { 0xEE23, 0xD570 },
        { 0xEE24, 0xD571 },
        { 0xEE25, 0xD572 },
        { 0xEE26, 0xD573 },
        { 0xEE27, 0xD574 },
        { 0xEE28, 0xD575 },
        { 0xEE29, 0xD576 },
        { 0xEE2A, 0xD577 },
        { 0xEE2B, 0xD578 },
        { 0xEE2C, 0xD579 },
        { 0xEE2D, 0xD57A },
        { 0xEE2E, 0xD57B },
        { 0xEE2F, 0xD57C },
        { 0xEE30, 0xD57D },
        { 0xEE31, 0xD57E },
        { 0xEE32, 0xD57F },
        { 0xEE33, 0xD581 },
        { 0xEE34, 0xD582 },
        { 0xEE35, 0xD583 },
        { 0xEE36, 0xD584 },
        { 0xEE37, 0xD585 },
        { 0xEE38, 0xD586 },
        { 0xEE39, 0xD587 },
        { 0xEE3A, 0xD588 },
        { 0xEE3B, 0xD589 },
        { 0xEE3C, 0xD58A },
        { 0xEE3D, 0xD58B },
        { 0xEE3E, 0xD58C },
        { 0xEE3F, 0xD58D },
        { 0xEE40, 0xD58E },
        { 0xEE41, 0xD58F },
        { 0xEE42, 0xD590 },
        { 0xEE43, 0xD591 },
        { 0xEE44, 0xD592 },
        { 0xEE45, 0xD593 },
        { 0xEE46, 0xD594 },
        { 0xEE47, 0xD595 },
        { 0xEE48, 0xD596 },
        { 0xEE49, 0xD597 },
        { 0xEE4A, 0xD598 },
        { 0xEE4B, 0xD599 },
        { 0xEE4C, 0xD59A },
        { 0xEE4D, 0xD59B },
        { 0xEE4E, 0xD59C },
        { 0xEE4F, 0xD59D },
        { 0xEE50, 0xD59E },
        { 0xEE51, 0xD59F },
        { 0xEE52, 0xD5A0 },
        { 0xEE53, 0xD5A1 },
        { 0xEE54, 0xD5A2 },
        { 0xEE55, 0xD5A3 },
        { 0xEE56, 0xD5A4 },
        { 0xEE57, 0xD5A5 },
        { 0xEE58, 0xD5A6 },
        { 0xEE59, 0xD5A7 },
        { 0xEE5A, 0xD5A8 },
        { 0xEE5B, 0xD5A9 },
        { 0xEE5C, 0xD5AA },
        { 0xEE5D, 0xD5AB },
        { 0xEE5E, 0xD5AC },
        { 0xEE5F, 0xD5AD },
        { 0xEE60, 0xD5AE },
        { 0xEE61, 0xD5AF },
        { 0xEE62, 0xD5B0 },
        { 0xEE63, 0xD5B1 },
        { 0xEE64, 0xD5B2 },
        { 0xEE65, 0xD5B3 },
        { 0xEE66, 0xD5B4 },
        { 0xEE67, 0xD5B5 },
        { 0xEE68, 0xD5B6 },
        { 0xEE69, 0xD5B7 },
        { 0xEE6A, 0xD5B8 },
        { 0xEE6B, 0xD5B9 },
        { 0xEE6C, 0xD5BA },
        { 0xEE6D, 0xD5BB },
        { 0xEE6E, 0xD5BC },
        { 0xEE6F, 0xD5BD },
        { 0xEE70, 0xD5BE },
        { 0xEE71, 0xD5BF },
        { 0xEE72, 0xD5C0 },
        { 0xEE73, 0xD5C1 },
        { 0xEE74, 0xD5C2 },
        { 0xEE75, 0xD5C3 },
        { 0xEE76, 0xD5C4 },
        { 0xEE77, 0xD5C5 },
        { 0xEE78, 0xD5C6 },
        { 0xEE79, 0xD5C7 },
        { 0xEE7A, 0xD5C8 },
        { 0xEE7B, 0xD5C9 },
        { 0xEE7C, 0xD5CA },
        { 0xEE7D, 0xD5CB },
        { 0xEE7E, 0xD5CC },
        { 0xEE7F, 0xD5CD },
        { 0xEE80, 0xD5CE },
        { 0xEE81, 0xD5CF },
        { 0xEE82, 0xD5D0 },
        { 0xEE83, 0xD5D1 },
        { 0xEE84, 0xD5D2 },
        { 0xEE85, 0xD5D3 },
        { 0xEE86, 0xD5D4 },
        { 0xEE87, 0xD5D5 },
        { 0xEE88, 0xD5D6 },
        { 0xEE89, 0xD5D7 },
        { 0xEE8A, 0xD5D8 },
        { 0xEE8B, 0xD5D9 },
        { 0xEE8C, 0xD5DA },
        { 0xEE8D, 0xD5DB },
        { 0xEE8E, 0xD5DC },
        { 0xEE8F, 0xD5DD },
        { 0xEE90, 0xD5DE },
        { 0xEE91, 0xD5DF },
        { 0xEE92, 0xD5E0 },
        { 0xEE93, 0xD5E1 },
        { 0xEE94, 0xD5E2 },
        { 0xEE95, 0xD5E3 },
        { 0xEE96, 0xD5E4 },
        { 0xEE97, 0xD5E5 },
        { 0xEE98, 0xD5E6 },
        { 0xEE99, 0xD5E7 },
        { 0xEE9A, 0xD5E8 },
        { 0xEE9B, 0xD5E9 },
        { 0xEE9C, 0xD5EA },
        { 0xEE9D, 0xD5EB },
        { 0xEE9E, 0xD5EC },
        { 0xEE9F, 0xD5ED },
        { 0xEEA0, 0xD5EE },
        { 0xEEA1, 0xD5EF },
        { 0xEEA2, 0xD5F0 },
        { 0xEEA3, 0xD5F1 },
        { 0xEEA4, 0xD5F2 },
        { 0xEEA5, 0xD5F3 },
        { 0xEEA6, 0xD5F4 },
        { 0xEEA7, 0xD5F5 },
        { 0xEEA8, 0xD5F6 },
        { 0xEEA9, 0xD5F7 },
        { 0xEEAA, 0xD5F8 },
        { 0xEEAB, 0xD5F9 },
        { 0xEEAC, 0xD5FA },
        { 0xEEAD, 0xD5FB },
        { 0xEEAE, 0xD5FC },
        { 0xEEAF, 0xD5FD },
        { 0xEEB0, 0xD641 },
        { 0xEEB1, 0xD642 },
        { 0xEEB2, 0xD643 },
        { 0xEEB3, 0xD644 },
        { 0xEEB4, 0xD645 },
        { 0xEEB5, 0xD646 },
        { 0xEEB6, 0xD647 },
        { 0xEEB7, 0xD648 },
        { 0xEEB8, 0xD649 },
        { 0xEEB9, 0xD64A },
        { 0xEEBA, 0xD64B },
        { 0xEEBB, 0xD64C },
        { 0xEEBC, 0xD64D },
        { 0xEEBD, 0xD64E },
        { 0xEEBE, 0xD64F },
        { 0xEEBF, 0xD650 },
        { 0xEEC0, 0xD651 },
        { 0xEEC1, 0xD652 },
        { 0xEEC2, 0xD653 },
        { 0xEEC3, 0xD654 },
        { 0xEEC4, 0xD655 },
        { 0xEEC5, 0xD656 },
        { 0xEEC6, 0xD657 },
        { 0xEEC7, 0xD658 },
        { 0xEEC8, 0xD659 },
        { 0xEEC9, 0xD65A },
        { 0xEECA, 0xD65B },
        { 0xEECB, 0xD65C },
        { 0xEECC, 0xD65D },
        { 0xEECD, 0xD65E },
        { 0xEECE, 0xD65F },
        { 0xEECF, 0xD660 },
        { 0xEED0, 0xD661 },
        { 0xEED1, 0xD662 },
        { 0xEED2, 0xD663 },
        { 0xEED3, 0xD664 },
        { 0xEED4, 0xD665 },
        { 0xEED5, 0xD666 },
        { 0xEED6, 0xD667 },
        { 0xEED7, 0xD668 },
        { 0xEED8, 0xD669 },
        { 0xEED9, 0xD66A },
        { 0xEEDA, 0xD66B },
        { 0xEEDB, 0xD66C },
        { 0xEEDC, 0xD66D },
        { 0xEEDD, 0xD66E },
        { 0xEEDE, 0xD66F },
        { 0xEEDF, 0xD670 },
        { 0xEEE0, 0xD671 },
        { 0xEEE1, 0xD672 },
        { 0xEEE2, 0xD673 },
        { 0xEEE3, 0xD674 },
        { 0xEEE4, 0xD675 },
        { 0xEEE5, 0xD676 },
        { 0xEEE6, 0xD677 },
        { 0xEEE7, 0xD678 },
        { 0xEEE8, 0xD679 },
        { 0xEEE9, 0xD67A },
        { 0xEEEA, 0xD67B },
        { 0xEEEB, 0xD67C },
        { 0xEEEC, 0xD67D },
        { 0xEEED, 0xD67E },
        { 0xEEEE, 0xD67F },
        { 0xEEEF, 0xD681 },
        { 0xEEF0, 0xD682 },
        { 0xEEF1, 0xD683 },
        { 0xEEF2, 0xD684 },
        { 0xEEF3, 0xD685 },
        { 0xEEF4, 0xD686 },
        { 0xEEF5, 0xD687 },
        { 0xEEF6, 0xD688 },
        { 0xEEF7, 0xD689 },
        { 0xEEF8, 0xD68A },
        { 0xEEF9, 0xD68B },
        { 0xEEFA, 0xD68C },
        { 0xEEFB, 0xD68D },
        { 0xEEFC, 0xD68E },
        { 0xEEFD, 0xD68F },
        { 0xEEFE, 0xD690 },
        { 0xEEFF, 0xD691 },
        { 0xEF00, 0xD692 },
        { 0xEF01, 0xD693 },
        { 0xEF02, 0xD694 },
        { 0xEF03, 0xD695 },
        { 0xEF04, 0xD696 },
        { 0xEF05, 0xD697 },
        { 0xEF06, 0xD698 },
        { 0xEF07, 0xD699 },
        { 0xEF08, 0xD69A },
        { 0xEF09, 0xD69B },
        { 0xEF0A, 0xD69C },
        { 0xEF0B, 0xD69D },
        { 0xEF0C, 0xD69E },
        { 0xEF0D, 0xD69F },
        { 0xEF0E, 0xD6A0 },
        { 0xEF0F, 0xD6A1 },
        { 0xEF10, 0xD6A2 },
        { 0xEF11, 0xD6A3 },
        { 0xEF12, 0xD6A4 },
        { 0xEF13, 0xD6A5 },
        { 0xEF14, 0xD6A6 },
        { 0xEF15, 0xD6A7 },
        { 0xEF16, 0xD6A8 },
        { 0xEF17, 0xD6A9 },
        { 0xEF18, 0xD6AA },
        { 0xEF19, 0xD6AB },
        { 0xEF1A, 0xD6AC },
        { 0xEF1B, 0xD6AD },
        { 0xEF1C, 0xD6AE },
        { 0xEF1D, 0xD6AF },
        { 0xEF1E, 0xD6B0 },
        { 0xEF1F, 0xD6B1 },
        { 0xEF20, 0xD6B2 },
        { 0xEF21, 0xD6B3 },
        { 0xEF22, 0xD6B4 },
        { 0xEF23, 0xD6B5 },
        { 0xEF24, 0xD6B6 },
        { 0xEF25, 0xD6B7 },
        { 0xEF26, 0xD6B8 },
        { 0xEF27, 0xD6B9 },
        { 0xEF28, 0xD6BA },
        { 0xEF29, 0xD6BB },
        { 0xEF2A, 0xD6BC },
        { 0xEF2B, 0xD6BD },
        { 0xEF2C, 0xD6BE },
        { 0xEF2D, 0xD6BF },
        { 0xEF2E, 0xD6C0 },
        { 0xEF2F, 0xD6C1 },
        { 0xEF30, 0xD6C2 },
        { 0xEF31, 0xD6C3 },
        { 0xEF32, 0xD6C4 },
        { 0xEF33, 0xD6C5 },
        { 0xEF34, 0xD6C6 },
        { 0xEF35, 0xD6C7 },
        { 0xEF36, 0xD6C8 },
        { 0xEF37, 0xD6C9 },
        { 0xEF38, 0xD6CA },
        { 0xEF39, 0xD6CB },
        { 0xEF3A, 0xD6CC },
        { 0xEF3B, 0xD6CD },
        { 0xEF3C, 0xD6CE },
        { 0xEF3D, 0xD6CF },
        { 0xEF3E, 0xD6D0 },
        { 0xEF3F, 0xD6D1 },
        { 0xEF40, 0xD6D2 },
        { 0xEF41, 0xD6D3 },
        { 0xEF42, 0xD6D4 },
        { 0xEF43, 0xD6D5 },
        { 0xEF44, 0xD6D6 },
        { 0xEF45, 0xD6D7 },
        { 0xEF46, 0xD6D8 },
        { 0xEF47, 0xD6D9 },
        { 0xEF48, 0xD6DA },
        { 0xEF49, 0xD6DB },
        { 0xEF4A, 0xD6DC },
        { 0xEF4B, 0xD6DD },
        { 0xEF4C, 0xD6DE },
        { 0xEF4D, 0xD6DF },
        { 0xEF4E, 0xD6E0 },
        { 0xEF4F, 0xD6E1 },
        { 0xEF50, 0xD6E2 },
        { 0xEF51, 0xD6E3 },
        { 0xEF52, 0xD6E4 },
        { 0xEF53, 0xD6E5 },
        { 0xEF54, 0xD6E6 },
        { 0xEF55, 0xD6E7 },
        { 0xEF56, 0xD6E8 },
        { 0xEF57, 0xD6E9 },
        { 0xEF58, 0xD6EA },
        { 0xEF59, 0xD6EB },
        { 0xEF5A, 0xD6EC },
        { 0xEF5B, 0xD6ED },
        { 0xEF5C, 0xD6EE },
        { 0xEF5D, 0xD6EF },
        { 0xEF5E, 0xD6F0 },
        { 0xEF5F, 0xD6F1 },
        { 0xEF60, 0xD6F2 },
        { 0xEF61, 0xD6F3 },
        { 0xEF62, 0xD6F4 },
        { 0xEF63, 0xD6F5 },
        { 0xEF64, 0xD6F6 },
        { 0xEF65, 0xD6F7 },
        { 0xEF66, 0xD6F8 },
        { 0xEF67, 0xD6F9 },
        { 0xEF68, 0xD6FA },
        { 0xEF69, 0xD6FB },
        { 0xEF6A, 0xD6FC },
        { 0xEF6B, 0xD6FD },
        { 0xEF6C, 0xD741 },
        { 0xEF6D, 0xD742 },
        { 0xEF6E, 0xD743 },
        { 0xEF6F, 0xD744 },
        { 0xEF70, 0xD745 },
        { 0xEF71, 0xD746 },
        { 0xEF72, 0xD747 },
        { 0xEF73, 0xD748 },
        { 0xEF74, 0xD749 },
        { 0xEF75, 0xD74A },
        { 0xEF76, 0xD74B },
        { 0xEF77, 0xD74C },
        { 0xEF78, 0xD74D },
        { 0xEF79, 0xD74E },
        { 0xEF7A, 0xD74F },
        { 0xEF7B, 0xD750 },
        { 0xEF7C, 0xD751 },
        { 0xEF7D, 0xD752 },
        { 0xEF7E, 0xD753 },
        { 0xEF7F, 0xD754 },
        { 0xEF80, 0xD755 },
        { 0xEF81, 0xD756 },
        { 0xEF82, 0xD757 },
        { 0xEF83, 0xD758 },
        { 0xEF84, 0xD759 },
        { 0xEF85, 0xD75A },
        { 0xEF86, 0xD75B },
        { 0xEF87, 0xD75C },
        { 0xEF88, 0xD75D },
        { 0xEF89, 0xD75E },
        { 0xEF8A, 0xD75F },
        { 0xEF8B, 0xD760 },
        { 0xEF8C, 0xD761 },
        { 0xEF8D, 0xD762 },
        { 0xEF8E, 0xD763 },
        { 0xEF8F, 0xD764 },
        { 0xEF90, 0xD765 },
        { 0xEF91, 0xD766 },
        { 0xEF92, 0xD767 },
        { 0xEF93, 0xD768 },
        { 0xEF94, 0xD769 },
        { 0xEF95, 0xD76A },
        { 0xEF96, 0xD76B },
        { 0xEF97, 0xD76C },
        { 0xEF98, 0xD76D },
        { 0xEF99, 0xD76E },
        { 0xEF9A, 0xD76F },
        { 0xEF9B, 0xD770 },
        { 0xEF9C, 0xD771 },
        { 0xEF9D, 0xD772 },
        { 0xEF9E, 0xD773 },
        { 0xEF9F, 0xD774 },
        { 0xEFA0, 0xD775 },
        { 0xEFA1, 0xD776 },
        { 0xEFA2, 0xD777 },
        { 0xEFA3, 0xD778 },
        { 0xEFA4, 0xD779 },
        { 0xEFA5, 0xD77A },
        { 0xEFA6, 0xD77B },
        { 0xEFA7, 0xD77C },
        { 0xEFA8, 0xD77D },
        { 0xEFA9, 0xD77E },
        { 0xEFAA, 0xD77F },
        { 0xEFAB, 0xD781 },
        { 0xEFAC, 0xD782 },
        { 0xEFAD, 0xD783 },
        { 0xEFAE, 0xD784 },
        { 0xEFAF, 0xD785 },
        { 0xEFB0, 0xD786 },
        { 0xEFB1, 0xD787 },
        { 0xEFB2, 0xD788 },
        { 0xEFB3, 0xD789 },
        { 0xEFB4, 0xD78A },
        { 0xEFB5, 0xD78B },
        { 0xEFB6, 0xD78C },
        { 0xEFB7, 0xD78D },
        { 0xEFB8, 0xD78E },
        { 0xEFB9, 0xD78F },
        { 0xEFBA, 0xD790 },
        { 0xEFBB, 0xD791 },
        { 0xEFBC, 0xD792 },
        { 0xEFBD, 0xD793 },
        { 0xEFBE, 0xD794 },
        { 0xEFBF, 0xD795 },
        { 0xEFC0, 0xD796 },
        { 0xEFC1, 0xD797 },
        { 0xEFC2, 0xD798 },
        { 0xEFC3, 0xD799 },
        { 0xEFC4, 0xD79A },
        { 0xEFC5, 0xD79B },
        { 0xEFC6, 0xD79C },
        { 0xEFC7, 0xD79D },
        { 0xEFC8, 0xD79E },
        { 0xEFC9, 0xD79F },
        { 0xEFCA, 0xD7A0 },
        { 0xEFCB, 0xD7A1 },
        { 0xEFCC, 0xD7A2 },
        { 0xEFCD, 0xD7A3 },
        { 0xEFCE, 0xD7A4 },
        { 0xEFCF, 0xD7A5 },
        { 0xEFD0, 0xD7A6 },
        { 0xEFD1, 0xD7A7 },
        { 0xEFD2, 0xD7A8 },
        { 0xEFD3, 0xD7A9 },
        { 0xEFD4, 0xD7AA },
        { 0xEFD5, 0xD7AB },
        { 0xEFD6, 0xD7AC },
        { 0xEFD7, 0xD7AD },
        { 0xEFD8, 0xD7AE },
        { 0xEFD9, 0xD7AF },
        { 0xEFDA, 0xD7B0 },
        { 0xEFDB, 0xD7B1 },
        { 0xEFDC, 0xD7B2 },
        { 0xEFDD, 0xD7B3 },
        { 0xEFDE, 0xD7B4 },
        { 0xEFDF, 0xD7B5 },
        { 0xEFE0, 0xD7B6 },
        { 0xEFE1, 0xD7B7 },
        { 0xEFE2, 0xD7B8 },
        { 0xEFE3, 0xD7B9 },
        { 0xEFE4, 0xD7BA },
        { 0xEFE5, 0xD7BB },
        { 0xEFE6, 0xD7BC },
        { 0xEFE7, 0xD7BD },
        { 0xEFE8, 0xD7BE },
        { 0xEFE9, 0xD7BF },
        { 0xEFEA, 0xD7C0 },
        { 0xEFEB, 0xD7C1 },
        { 0xEFEC, 0xD7C2 },
        { 0xEFED, 0xD7C3 },
        { 0xEFEE, 0xD7C4 },
        { 0xEFEF, 0xD7C5 },
        { 0xEFF0, 0xD7C6 },
        { 0xEFF1, 0xD7C7 },
        { 0xEFF2, 0xD7C8 },
        { 0xEFF3, 0xD7C9 },
        { 0xEFF4, 0xD7CA },
        { 0xEFF5, 0xD7CB },
        { 0xEFF6, 0xD7CC },
        { 0xEFF7, 0xD7CD },
        { 0xEFF8, 0xD7CE },
        { 0xEFF9, 0xD7CF },
        { 0xEFFA, 0xD7D0 },
        { 0xEFFB, 0xD7D1 },
        { 0xEFFC, 0xD7D2 },
        { 0xEFFD, 0xD7D3 },
        { 0xEFFE, 0xD7D4 },
        { 0xEFFF, 0xD7D5 },
        { 0xF000, 0xD7D6 },
        { 0xF001, 0xD7D7 },
        { 0xF002, 0xD7D8 },
        { 0xF003, 0xD7D9 },
        { 0xF004, 0xD7DA },
        { 0xF005, 0xD7DB },
        { 0xF006, 0xD7DC },
        { 0xF007, 0xD7DD },
        { 0xF008, 0xD7DE },
        { 0xF009, 0xD7DF },
        { 0xF00A, 0xD7E0 },
        { 0xF00B, 0xD7E1 },
        { 0xF00C, 0xD7E2 },
        { 0xF00D, 0xD7E3 },
        { 0xF00E, 0xD7E4 },
        { 0xF00F, 0xD7E5 },
        { 0xF010, 0xD7E6 },
        { 0xF011, 0xD7E7 },
        { 0xF012, 0xD7E8 },
        { 0xF013, 0xD7E9 },
        { 0xF014, 0xD7EA },
        { 0xF015, 0xD7EB },
        { 0xF016, 0xD7EC },
        { 0xF017, 0xD7ED },
        { 0xF018, 0xD7EE },
        { 0xF019, 0xD7EF },
        { 0xF01A, 0xD7F0 },
        { 0xF01B, 0xD7F1 },
        { 0xF01C, 0xD7F2 },
        { 0xF01D, 0xD7F3 },
        { 0xF01E, 0xD7F4 },
        { 0xF01F, 0xD7F5 },
        { 0xF020, 0xD7F6 },
        { 0xF021, 0xD7F7 },
        { 0xF022, 0xD7F8 },
        { 0xF023, 0xD7F9 },
        { 0xF024, 0xD7FA },
        { 0xF025, 0xD7FB },
        { 0xF026, 0xD7FC },
        { 0xF027, 0xD7FD },
        { 0xF028, 0xD841 },
        { 0xF029, 0xD842 },
        { 0xF02A, 0xD843 },
        { 0xF02B, 0xD844 },
        { 0xF02C, 0xD845 },
        { 0xF02D, 0xD846 },
        { 0xF02E, 0xD847 },
        { 0xF02F, 0xD848 },
        { 0xF030, 0xD849 },
        { 0xF031, 0xD84A },
        { 0xF032, 0xD84B },
        { 0xF033, 0xD84C },
        { 0xF034, 0xD84D },
        { 0xF035, 0xD84E },
        { 0xF036, 0xD84F },
        { 0xF037, 0xD850 },
        { 0xF038, 0xD851 },
        { 0xF039, 0xD852 },
        { 0xF03A, 0xD853 },
        { 0xF03B, 0xD854 },
        { 0xF03C, 0xD855 },
        { 0xF03D, 0xD856 },
        { 0xF03E, 0xD857 },
        { 0xF03F, 0xD858 },
        { 0xF040, 0xD859 },
        { 0xF041, 0xD85A },
        { 0xF042, 0xD85B },
        { 0xF043, 0xD85C },
        { 0xF044, 0xD85D },
        { 0xF045, 0xD85E },
        { 0xF046, 0xD85F },
        { 0xF047, 0xD860 },
        { 0xF048, 0xD861 },
        { 0xF049, 0xD862 },
        { 0xF04A, 0xD863 },
        { 0xF04B, 0xD864 },
        { 0xF04C, 0xD865 },
        { 0xF04D, 0xD866 },
        { 0xF04E, 0xD867 },
        { 0xF04F, 0xD868 },
        { 0xF050, 0xD869 },
        { 0xF051, 0xD86A },
        { 0xF052, 0xD86B },
        { 0xF053, 0xD86C },
        { 0xF054, 0xD86D },
        { 0xF055, 0xD86E },
        { 0xF056, 0xD86F },
        { 0xF057, 0xD870 },
        { 0xF058, 0xD871 },
        { 0xF059, 0xD872 },
        { 0xF05A, 0xD873 },
        { 0xF05B, 0xD874 },
        { 0xF05C, 0xD875 },
        { 0xF05D, 0xD876 },
        { 0xF05E, 0xD877 },
        { 0xF05F, 0xD878 },
        { 0xF060, 0xD879 },
        { 0xF061, 0xD87A },
        { 0xF062, 0xD87B },
        { 0xF063, 0xD87C },
        { 0xF064, 0xD87D },
        { 0xF065, 0xD87E },
        { 0xF066, 0xD87F },
        { 0xF067, 0xD881 },
        { 0xF068, 0xD882 },
        { 0xF069, 0xD883 },
        { 0xF06A, 0xD884 },
        { 0xF06B, 0xD885 },
        { 0xF06C, 0xD886 },
        { 0xF06D, 0xD887 },
        { 0xF06E, 0xD888 },
        { 0xF06F, 0xD889 },
        { 0xF070, 0xD88A },
        { 0xF071, 0xD88B },
        { 0xF072, 0xD88C },
        { 0xF073, 0xD88D },
        { 0xF074, 0xD88E },
        { 0xF075, 0xD88F },
        { 0xF076, 0xD890 },
        { 0xF077, 0xD891 },
        { 0xF078, 0xD892 },
        { 0xF079, 0xD893 },
        { 0xF07A, 0xD894 },
        { 0xF07B, 0xD895 },
        { 0xF07C, 0xD896 },
        { 0xF07D, 0xD897 },
        { 0xF07E, 0xD898 },
        { 0xF07F, 0xD899 },
        { 0xF080, 0xD89A },
        { 0xF081, 0xD89B },
        { 0xF082, 0xD89C },
        { 0xF083, 0xD89D },
        { 0xF084, 0xD89E },
        { 0xF085, 0xD89F },
        { 0xF086, 0xD8A0 },
        { 0xF087, 0xD8A1 },
        { 0xF088, 0xD8A2 },
        { 0xF089, 0xD8A3 },
        { 0xF08A, 0xD8A4 },
        { 0xF08B, 0xD8A5 },
        { 0xF08C, 0xD8A6 },
        { 0xF08D, 0xD8A7 },
        { 0xF08E, 0xD8A8 },
        { 0xF08F, 0xD8A9 },
        { 0xF090, 0xD8AA },
        { 0xF091, 0xD8AB },
        { 0xF092, 0xD8AC },
        { 0xF093, 0xD8AD },
        { 0xF094, 0xD8AE },
        { 0xF095, 0xD8AF },
        { 0xF096, 0xD8B0 },
        { 0xF097, 0xD8B1 },
        { 0xF098, 0xD8B2 },
        { 0xF099, 0xD8B3 },
        { 0xF09A, 0xD8B4 },
        { 0xF09B, 0xD8B5 },
        { 0xF09C, 0xD8B6 },
        { 0xF09D, 0xD8B7 },
        { 0xF09E, 0xD8B8 },
        { 0xF09F, 0xD8B9 },
        { 0xF0A0, 0xD8BA },
        { 0xF0A1, 0xD8BB },
        { 0xF0A2, 0xD8BC },
        { 0xF0A3, 0xD8BD },
        { 0xF0A4, 0xD8BE },
        { 0xF0A5, 0xD8BF },
        { 0xF0A6, 0xD8C0 },
        { 0xF0A7, 0xD8C1 },
        { 0xF0A8, 0xD8C2 },
        { 0xF0A9, 0xD8C3 },
        { 0xF0AA, 0xD8C4 },
        { 0xF0AB, 0xD8C5 },
        { 0xF0AC, 0xD8C6 },
        { 0xF0AD, 0xD8C7 },
        { 0xF0AE, 0xD8C8 },
        { 0xF0AF, 0xD8C9 },
        { 0xF0B0, 0xD8CA },
        { 0xF0B1, 0xD8CB },
        { 0xF0B2, 0xD8CC },
        { 0xF0B3, 0xD8CD },
        { 0xF0B4, 0xD8CE },
        { 0xF0B5, 0xD8CF },
        { 0xF0B6, 0xD8D0 },
        { 0xF0B7, 0xD8D1 },
        { 0xF0B8, 0xD8D2 },
        { 0xF0B9, 0xD8D3 },
        { 0xF0BA, 0xD8D4 },
        { 0xF0BB, 0xD8D5 },
        { 0xF0BC, 0xD8D6 },
        { 0xF0BD, 0xD8D7 },
        { 0xF0BE, 0xD8D8 },
        { 0xF0BF, 0xD8D9 },
        { 0xF0C0, 0xD8DA },
        { 0xF0C1, 0xD8DB },
        { 0xF0C2, 0xD8DC },
        { 0xF0C3, 0xD8DD },
        { 0xF0C4, 0xD8DE },
        { 0xF0C5, 0xD8DF },
        { 0xF0C6, 0xD8E0 },
        { 0xF0C7, 0xD8E1 },
        { 0xF0C8, 0xD8E2 },
        { 0xF0C9, 0xD8E3 },
        { 0xF0CA, 0xD8E4 },
        { 0xF0CB, 0xD8E5 },
        { 0xF0CC, 0xD8E6 },
        { 0xF0CD, 0xD8E7 },
        { 0xF0CE, 0xD8E8 },
        { 0xF0CF, 0xD8E9 },
        { 0xF0D0, 0xD8EA },
        { 0xF0D1, 0xD8EB },
        { 0xF0D2, 0xD8EC },
        { 0xF0D3, 0xD8ED },
        { 0xF0D4, 0xD8EE },
        { 0xF0D5, 0xD8EF },
        { 0xF0D6, 0xD8F0 },
        { 0xF0D7, 0xD8F1 },
        { 0xF0D8, 0xD8F2 },
        { 0xF0D9, 0xD8F3 },
        { 0xF0DA, 0xD8F4 },
        { 0xF0DB, 0xD8F5 },
        { 0xF0DC, 0xD8F6 },
        { 0xF0DD, 0xD8F7 },
        { 0xF0DE, 0xD8F8 },
        { 0xF0DF, 0xD8F9 },
        { 0xF0E0, 0xD8FA },
        { 0xF0E1, 0xD8FB },
        { 0xF0E2, 0xD8FC },
        { 0xF0E3, 0xD8FD },
        { 0xF0E4, 0xD941 },
        { 0xF0E5, 0xD942 },
        { 0xF0E6, 0xD943 },
        { 0xF0E7, 0xD944 },
        { 0xF0E8, 0xD945 },
        { 0xF0E9, 0xD946 },
        { 0xF0EA, 0xD947 },
        { 0xF0EB, 0xD948 },
        { 0xF0EC, 0xD949 },
        { 0xF0ED, 0xD94A },
        { 0xF0EE, 0xD94B },
        { 0xF0EF, 0xD94C },
        { 0xF0F0, 0xD94D },
        { 0xF0F1, 0xD94E },
        { 0xF0F2, 0xD94F },
        { 0xF0F3, 0xD950 },
        { 0xF0F4, 0xD951 },
        { 0xF0F5, 0xD952 },
        { 0xF0F6, 0xD953 },
        { 0xF0F7, 0xD954 },
        { 0xF0F8, 0xD955 },
        { 0xF0F9, 0xD956 },
        { 0xF0FA, 0xD957 },
        { 0xF0FB, 0xD958 },
        { 0xF0FC, 0xD959 },
        { 0xF0FD, 0xD95A },
        { 0xF0FE, 0xD95B },
        { 0xF0FF, 0xD95C },
        { 0xF100, 0xD95D },
        { 0xF101, 0xD95E },
        { 0xF102, 0xD95F },
        { 0xF103, 0xD960 },
        { 0xF104, 0xD961 },
        { 0xF105, 0xD962 },
        { 0xF106, 0xD963 },
        { 0xF107, 0xD964 },
        { 0xF108, 0xD965 },
        { 0xF109, 0xD966 },
        { 0xF10A, 0xD967 },
        { 0xF10B, 0xD968 },
        { 0xF10C, 0xD969 },
        { 0xF10D, 0xD96A },
        { 0xF10E, 0xD96B },
        { 0xF10F, 0xD96C },
        { 0xF110, 0xD96D },
        { 0xF111, 0xD96E },
        { 0xF112, 0xD96F },
        { 0xF113, 0xD970 },
        { 0xF114, 0xD971 },
        { 0xF115, 0xD972 },
        { 0xF116, 0xD973 },
        { 0xF117, 0xD974 },
        { 0xF118, 0xD975 },
        { 0xF119, 0xD976 },
        { 0xF11A, 0xD977 },
        { 0xF11B, 0xD978 },
        { 0xF11C, 0xD979 },
        { 0xF11D, 0xD97A },
        { 0xF11E, 0xD97B },
        { 0xF11F, 0xD97C },
        { 0xF120, 0xD97D },
        { 0xF121, 0xD97E },
        { 0xF122, 0xD97F },
        { 0xF123, 0xD981 },
        { 0xF124, 0xD982 },
        { 0xF125, 0xD983 },
        { 0xF126, 0xD984 },
        { 0xF127, 0xD985 },
        { 0xF128, 0xD986 },
        { 0xF129, 0xD987 },
        { 0xF12A, 0xD988 },
        { 0xF12B, 0xD989 },
        { 0xF12C, 0xD98A },
        { 0xF12D, 0xD98B },
        { 0xF12E, 0xD98C },
        { 0xF12F, 0xD98D },
        { 0xF130, 0xD98E },
        { 0xF131, 0xD98F },
        { 0xF132, 0xD990 },
        { 0xF133, 0xD991 },
        { 0xF134, 0xD992 },
        { 0xF135, 0xD993 },
        { 0xF136, 0xD994 },
        { 0xF137, 0xD995 },
        { 0xF138, 0xD996 },
        { 0xF139, 0xD997 },
        { 0xF13A, 0xD998 },
        { 0xF13B, 0xD999 },
        { 0xF13C, 0xD99A },
        { 0xF13D, 0xD99B },
        { 0xF13E, 0xD99C },
        { 0xF13F, 0xD99D },
        { 0xF140, 0xD99E },
        { 0xF141, 0xD99F },
        { 0xF142, 0xD9A0 },
        { 0xF143, 0xD9A1 },
        { 0xF144, 0xD9A2 },
        { 0xF145, 0xD9A3 },
        { 0xF146, 0xD9A4 },
        { 0xF147, 0xD9A5 },
        { 0xF148, 0xD9A6 },
        { 0xF149, 0xD9A7 },
        { 0xF14A, 0xD9A8 },
        { 0xF14B, 0xD9A9 },
        { 0xF14C, 0xD9AA },
        { 0xF14D, 0xD9AB },
        { 0xF14E, 0xD9AC },
        { 0xF14F, 0xD9AD },
        { 0xF150, 0xD9AE },
        { 0xF151, 0xD9AF },
        { 0xF152, 0xD9B0 },
        { 0xF153, 0xD9B1 },
        { 0xF154, 0xD9B2 },
        { 0xF155, 0xD9B3 },
        { 0xF156, 0xD9B4 },
        { 0xF157, 0xD9B5 },
        { 0xF158, 0xD9B6 },
        { 0xF159, 0xD9B7 },
        { 0xF15A, 0xD9B8 },
        { 0xF15B, 0xD9B9 },
        { 0xF15C, 0xD9BA },
        { 0xF15D, 0xD9BB },
        { 0xF15E, 0xD9BC },
        { 0xF15F, 0xD9BD },
        { 0xF160, 0xD9BE },
        { 0xF161, 0xD9BF },
        { 0xF162, 0xD9C0 },
        { 0xF163, 0xD9C1 },
        { 0xF164, 0xD9C2 },
        { 0xF165, 0xD9C3 },
        { 0xF166, 0xD9C4 },
        { 0xF167, 0xD9C5 },
        { 0xF168, 0xD9C6 },
        { 0xF169, 0xD9C7 },
        { 0xF16A, 0xD9C8 },
        { 0xF16B, 0xD9C9 },
        { 0xF16C, 0xD9CA },
        { 0xF16D, 0xD9CB },
        { 0xF16E, 0xD9CC },
        { 0xF16F, 0xD9CD },
        { 0xF170, 0xD9CE },
        { 0xF171, 0xD9CF },
        { 0xF172, 0xD9D0 },
        { 0xF173, 0xD9D1 },
        { 0xF174, 0xD9D2 },
        { 0xF175, 0xD9D3 },
        { 0xF176, 0xD9D4 },
        { 0xF177, 0xD9D5 },
        { 0xF178, 0xD9D6 },
        { 0xF179, 0xD9D7 },
        { 0xF17A, 0xD9D8 },
        { 0xF17B, 0xD9D9 },
        { 0xF17C, 0xD9DA },
        { 0xF17D, 0xD9DB },
        { 0xF17E, 0xD9DC },
        { 0xF17F, 0xD9DD },
        { 0xF180, 0xD9DE },
        { 0xF181, 0xD9DF },
        { 0xF182, 0xD9E0 },
        { 0xF183, 0xD9E1 },
        { 0xF184, 0xD9E2 },
        { 0xF185, 0xD9E3 },
        { 0xF186, 0xD9E4 },
        { 0xF187, 0xD9E5 },
        { 0xF188, 0xD9E6 },
        { 0xF189, 0xD9E7 },
        { 0xF18A, 0xD9E8 },
        { 0xF18B, 0xD9E9 },
        { 0xF18C, 0xD9EA },
        { 0xF18D, 0xD9EB },
        { 0xF18E, 0xD9EC },
        { 0xF18F, 0xD9ED },
        { 0xF190, 0xD9EE },
        { 0xF191, 0xD9EF },
        { 0xF192, 0xD9F0 },
        { 0xF193, 0xD9F1 },
        { 0xF194, 0xD9F2 },
        { 0xF195, 0xD9F3 },
        { 0xF196, 0xD9F4 },
        { 0xF197, 0xD9F5 },
        { 0xF198, 0xD9F6 },
        { 0xF199, 0xD9F7 },
        { 0xF19A, 0xD9F8 },
        { 0xF19B, 0xD9F9 },
        { 0xF19C, 0xD9FA },
        { 0xF19D, 0xD9FB },
        { 0xF19E, 0xD9FC },
        { 0xF19F, 0xD9FD },
        { 0xF1A0, 0xDA41 },
        { 0xF1A1, 0xDA42 },
        { 0xF1A2, 0xDA43 },
        { 0xF1A3, 0xDA44 },
        { 0xF1A4, 0xDA45 },
        { 0xF1A5, 0xDA46 },
        { 0xF1A6, 0xDA47 },
        { 0xF1A7, 0xDA48 },
        { 0xF1A8, 0xDA49 },
        { 0xF1A9, 0xDA4A },
        { 0xF1AA, 0xDA4B },
        { 0xF1AB, 0xDA4C },
        { 0xF1AC, 0xDA4D },
        { 0xF1AD, 0xDA4E },
        { 0xF1AE, 0xDA4F },
        { 0xF1AF, 0xDA50 },
        { 0xF1B0, 0xDA51 },
        { 0xF1B1, 0xDA52 },
        { 0xF1B2, 0xDA53 },
        { 0xF1B3, 0xDA54 },
        { 0xF1B4, 0xDA55 },
        { 0xF1B5, 0xDA56 },
        { 0xF1B6, 0xDA57 },
        { 0xF1B7, 0xDA58 },
        { 0xF1B8, 0xDA59 },
        { 0xF1B9, 0xDA5A },
        { 0xF1BA, 0xDA5B },
        { 0xF1BB, 0xDA5C },
        { 0xF1BC, 0xDA5D },
        { 0xF1BD, 0xDA5E },
        { 0xF1BE, 0xDA5F },
        { 0xF1BF, 0xDA60 },
        { 0xF1C0, 0xDA61 },
        { 0xF1C1, 0xDA62 },
        { 0xF1C2, 0xDA63 },
        { 0xF1C3, 0xDA64 },
        { 0xF1C4, 0xDA65 },
        { 0xF1C5, 0xDA66 },
        { 0xF1C6, 0xDA67 },
        { 0xF1C7, 0xDA68 },
        { 0xF1C8, 0xDA69 },
        { 0xF1C9, 0xDA6A },
        { 0xF1CA, 0xDA6B },
        { 0xF1CB, 0xDA6C },
        { 0xF1CC, 0xDA6D },
        { 0xF1CD, 0xDA6E },
        { 0xF1CE, 0xDA6F },
        { 0xF1CF, 0xDA70 },
        { 0xF1D0, 0xDA71 },
        { 0xF1D1, 0xDA72 },
        { 0xF1D2, 0xDA73 },
        { 0xF1D3, 0xDA74 },
        { 0xF1D4, 0xDA75 },
        { 0xF1D5, 0xDA76 },
        { 0xF1D6, 0xDA77 },
        { 0xF1D7, 0xDA78 },
        { 0xF1D8, 0xDA79 },
        { 0xF1D9, 0xDA7A },
        { 0xF1DA, 0xDA7B },
        { 0xF1DB, 0xDA7C },
        { 0xF1DC, 0xDA7D },
        { 0xF1DD, 0xDA7E },
        { 0xF1DE, 0xDA7F },
        { 0xF1DF, 0xDA81 },
        { 0xF1E0, 0xDA82 },
        { 0xF1E1, 0xDA83 },
        { 0xF1E2, 0xDA84 },
        { 0xF1E3, 0xDA85 },
        { 0xF1E4, 0xDA86 },
        { 0xF1E5, 0xDA87 },
        { 0xF1E6, 0xDA88 },
        { 0xF1E7, 0xDA89 },
        { 0xF1E8, 0xDA8A },
        { 0xF1E9, 0xDA8B },
        { 0xF1EA, 0xDA8C },
        { 0xF1EB, 0xDA8D },
        { 0xF1EC, 0xDA8E },
        { 0xF1ED, 0xDA8F },
        { 0xF1EE, 0xDA90 },
        { 0xF1EF, 0xDA91 },
        { 0xF1F0, 0xDA92 },
        { 0xF1F1, 0xDA93 },
        { 0xF1F2, 0xDA94 },
        { 0xF1F3, 0xDA95 },
        { 0xF1F4, 0xDA96 },
        { 0xF1F5, 0xDA97 },
        { 0xF1F6, 0xDA98 },
        { 0xF1F7, 0xDA99 },
        { 0xF1F8, 0xDA9A },
        { 0xF1F9, 0xDA9B },
        { 0xF1FA, 0xDA9C },
        { 0xF1FB, 0xDA9D },
        { 0xF1FC, 0xDA9E },
        { 0xF1FD, 0xDA9F },
        { 0xF1FE, 0xDAA0 },
        { 0xF1FF, 0xDAA1 },
        { 0xF200, 0xDAA2 },
        { 0xF201, 0xDAA3 },
        { 0xF202, 0xDAA4 },
        { 0xF203, 0xDAA5 },
        { 0xF204, 0xDAA6 },
        { 0xF205, 0xDAA7 },
        { 0xF206, 0xDAA8 },
        { 0xF207, 0xDAA9 },
        { 0xF208, 0xDAAA },
        { 0xF209, 0xDAAB },
        { 0xF20A, 0xDAAC },
        { 0xF20B, 0xDAAD },
        { 0xF20C, 0xDAAE },
        { 0xF20D, 0xDAAF },
        { 0xF20E, 0xDAB0 },
        { 0xF20F, 0xDAB1 },
        { 0xF210, 0xDAB2 },
        { 0xF211, 0xDAB3 },
        { 0xF212, 0xDAB4 },
        { 0xF213, 0xDAB5 },
        { 0xF214, 0xDAB6 },
        { 0xF215, 0xDAB7 },
        { 0xF216, 0xDAB8 },
        { 0xF217, 0xDAB9 },
        { 0xF218, 0xDABA },
        { 0xF219, 0xDABB },
        { 0xF21A, 0xDABC },
        { 0xF21B, 0xDABD },
        { 0xF21C, 0xDABE },
        { 0xF21D, 0xDABF },
        { 0xF21E, 0xDAC0 },
        { 0xF21F, 0xDAC1 },
        { 0xF220, 0xDAC2 },
        { 0xF221, 0xDAC3 },
        { 0xF222, 0xDAC4 },
        { 0xF223, 0xDAC5 },
        { 0xF224, 0xDAC6 },
        { 0xF225, 0xDAC7 },
        { 0xF226, 0xDAC8 },
        { 0xF227, 0xDAC9 },
        { 0xF228, 0xDACA },
        { 0xF229, 0xDACB },
        { 0xF22A, 0xDACC },
        { 0xF22B, 0xDACD },
        { 0xF22C, 0xDACE },
        { 0xF22D, 0xDACF },
        { 0xF22E, 0xDAD0 },
        { 0xF22F, 0xDAD1 },
        { 0xF230, 0xDAD2 },
        { 0xF231, 0xDAD3 },
        { 0xF232, 0xDAD4 },
        { 0xF233, 0xDAD5 },
        { 0xF234, 0xDAD6 },
        { 0xF235, 0xDAD7 },
        { 0xF236, 0xDAD8 },
        { 0xF237, 0xDAD9 },
        { 0xF238, 0xDADA },
        { 0xF239, 0xDADB },
        { 0xF23A, 0xDADC },
        { 0xF23B, 0xDADD },
        { 0xF23C, 0xDADE },
        { 0xF23D, 0xDADF },
        { 0xF23E, 0xDAE0 },
        { 0xF23F, 0xDAE1 },
        { 0xF240, 0xDAE2 },
        { 0xF241, 0xDAE3 },
        { 0xF242, 0xDAE4 },
        { 0xF243, 0xDAE5 },
        { 0xF244, 0xDAE6 },
        { 0xF245, 0xDAE7 },
        { 0xF246, 0xDAE8 },
        { 0xF247, 0xDAE9 },
        { 0xF248, 0xDAEA },
        { 0xF249, 0xDAEB },
        { 0xF24A, 0xDAEC },
        { 0xF24B, 0xDAED },
        { 0xF24C, 0xDAEE },
        { 0xF24D, 0xDAEF },
        { 0xF24E, 0xDAF0 },
        { 0xF24F, 0xDAF1 },
        { 0xF250, 0xDAF2 },
        { 0xF251, 0xDAF3 },
        { 0xF252, 0xDAF4 },
        { 0xF253, 0xDAF5 },
        { 0xF254, 0xDAF6 },
        { 0xF255, 0xDAF7 },
        { 0xF256, 0xDAF8 },
        { 0xF257, 0xDAF9 },
        { 0xF258, 0xDAFA },
        { 0xF259, 0xDAFB },
        { 0xF25A, 0xDAFC },
        { 0xF25B, 0xDAFD },
        { 0xF25C, 0xDB41 },
        { 0xF25D, 0xDB42 },
        { 0xF25E, 0xDB43 },
        { 0xF25F, 0xDB44 },
        { 0xF260, 0xDB45 },
        { 0xF261, 0xDB46 },
        { 0xF262, 0xDB47 },
        { 0xF263, 0xDB48 },
        { 0xF264, 0xDB49 },
        { 0xF265, 0xDB4A },
        { 0xF266, 0xDB4B },
        { 0xF267, 0xDB4C },
        { 0xF268, 0xDB4D },
        { 0xF269, 0xDB4E },
        { 0xF26A, 0xDB4F },
        { 0xF26B, 0xDB50 },
        { 0xF26C, 0xDB51 },
        { 0xF26D, 0xDB52 },
        { 0xF26E, 0xDB53 },
        { 0xF26F, 0xDB54 },
        { 0xF270, 0xDB55 },
        { 0xF271, 0xDB56 },
        { 0xF272, 0xDB57 },
        { 0xF273, 0xDB58 },
        { 0xF274, 0xDB59 },
        { 0xF275, 0xDB5A },
        { 0xF276, 0xDB5B },
        { 0xF277, 0xDB5C },
        { 0xF278, 0xDB5D },
        { 0xF279, 0xDB5E },
        { 0xF27A, 0xDB5F },
        { 0xF27B, 0xDB60 },
        { 0xF27C, 0xDB61 },
        { 0xF27D, 0xDB62 },
        { 0xF27E, 0xDB63 },
        { 0xF27F, 0xDB64 },
        { 0xF280, 0xDB65 },
        { 0xF281, 0xDB66 },
        { 0xF282, 0xDB67 },
        { 0xF283, 0xDB68 },
        { 0xF284, 0xDB69 },
        { 0xF285, 0xDB6A },
        { 0xF286, 0xDB6B },
        { 0xF287, 0xDB6C },
        { 0xF288, 0xDB6D },
        { 0xF289, 0xDB6E },
        { 0xF28A, 0xDB6F },
        { 0xF28B, 0xDB70 },
        { 0xF28C, 0xDB71 },
        { 0xF28D, 0xDB72 },
        { 0xF28E, 0xDB73 },
        { 0xF28F, 0xDB74 },
        { 0xF290, 0xDB75 },
        { 0xF291, 0xDB76 },
        { 0xF292, 0xDB77 },
        { 0xF293, 0xDB78 },
        { 0xF294, 0xDB79 },
        { 0xF295, 0xDB7A },
        { 0xF296, 0xDB7B },
        { 0xF297, 0xDB7C },
        { 0xF298, 0xDB7D },
        { 0xF299, 0xDB7E },
        { 0xF29A, 0xDB7F },
        { 0xF29B, 0xDB81 },
        { 0xF29C, 0xDB82 },
        { 0xF29D, 0xDB83 },
        { 0xF29E, 0xDB84 },
        { 0xF29F, 0xDB85 },
        { 0xF2A0, 0xDB86 },
        { 0xF2A1, 0xDB87 },
        { 0xF2A2, 0xDB88 },
        { 0xF2A3, 0xDB89 },
        { 0xF2A4, 0xDB8A },
        { 0xF2A5, 0xDB8B },
        { 0xF2A6, 0xDB8C },
        { 0xF2A7, 0xDB8D },
        { 0xF2A8, 0xDB8E },
        { 0xF2A9, 0xDB8F },
        { 0xF2AA, 0xDB90 },
        { 0xF2AB, 0xDB91 },
        { 0xF2AC, 0xDB92 },
        { 0xF2AD, 0xDB93 },
        { 0xF2AE, 0xDB94 },
        { 0xF2AF, 0xDB95 },
        { 0xF2B0, 0xDB96 },
        { 0xF2B1, 0xDB97 },
        { 0xF2B2, 0xDB98 },
        { 0xF2B3, 0xDB99 },
        { 0xF2B4, 0xDB9A },
        { 0xF2B5, 0xDB9B },
        { 0xF2B6, 0xDB9C },
        { 0xF2B7, 0xDB9D },
        { 0xF2B8, 0xDB9E },
        { 0xF2B9, 0xDB9F },
        { 0xF2BA, 0xDBA0 },
        { 0xF2BB, 0xDBA1 },
        { 0xF2BC, 0xDBA2 },
        { 0xF2BD, 0xDBA3 },
        { 0xF2BE, 0xDBA4 },
        { 0xF2BF, 0xDBA5 },
        { 0xF2C0, 0xDBA6 },
        { 0xF2C1, 0xDBA7 },
        { 0xF2C2, 0xDBA8 },
        { 0xF2C3, 0xDBA9 },
        { 0xF2C4, 0xDBAA },
        { 0xF2C5, 0xDBAB },
        { 0xF2C6, 0xDBAC },
        { 0xF2C7, 0xDBAD },
        { 0xF2C8, 0xDBAE },
        { 0xF2C9, 0xDBAF },
        { 0xF2CA, 0xDBB0 },
        { 0xF2CB, 0xDBB1 },
        { 0xF2CC, 0xDBB2 },
        { 0xF2CD, 0xDBB3 },
        { 0xF2CE, 0xDBB4 },
        { 0xF2CF, 0xDBB5 },
        { 0xF2D0, 0xDBB6 },
        { 0xF2D1, 0xDBB7 },
        { 0xF2D2, 0xDBB8 },
        { 0xF2D3, 0xDBB9 },
        { 0xF2D4, 0xDBBA },
        { 0xF2D5, 0xDBBB },
        { 0xF2D6, 0xDBBC },
        { 0xF2D7, 0xDBBD },
        { 0xF2D8, 0xDBBE },
        { 0xF2D9, 0xDBBF },
        { 0xF2DA, 0xDBC0 },
        { 0xF2DB, 0xDBC1 },
        { 0xF2DC, 0xDBC2 },
        { 0xF2DD, 0xDBC3 },
        { 0xF2DE, 0xDBC4 },
        { 0xF2DF, 0xDBC5 },
        { 0xF2E0, 0xDBC6 },
        { 0xF2E1, 0xDBC7 },
        { 0xF2E2, 0xDBC8 },
        { 0xF2E3, 0xDBC9 },
        { 0xF2E4, 0xDBCA },
        { 0xF2E5, 0xDBCB },
        { 0xF2E6, 0xDBCC },
        { 0xF2E7, 0xDBCD },
        { 0xF2E8, 0xDBCE },
        { 0xF2E9, 0xDBCF },
        { 0xF2EA, 0xDBD0 },
        { 0xF2EB, 0xDBD1 },
        { 0xF2EC, 0xDBD2 },
        { 0xF2ED, 0xDBD3 },
        { 0xF2EE, 0xDBD4 },
        { 0xF2EF, 0xDBD5 },
        { 0xF2F0, 0xDBD6 },
        { 0xF2F1, 0xDBD7 },
        { 0xF2F2, 0xDBD8 },
        { 0xF2F3, 0xDBD9 },
        { 0xF2F4, 0xDBDA },
        { 0xF2F5, 0xDBDB },
        { 0xF2F6, 0xDBDC },
        { 0xF2F7, 0xDBDD },
        { 0xF2F8, 0xDBDE },
        { 0xF2F9, 0xDBDF },
        { 0xF2FA, 0xDBE0 },
        { 0xF2FB, 0xDBE1 },
        { 0xF2FC, 0xDBE2 },
        { 0xF2FD, 0xDBE3 },
        { 0xF2FE, 0xDBE4 },
        { 0xF2FF, 0xDBE5 },
        { 0xF300, 0xDBE6 },
        { 0xF301, 0xDBE7 },
        { 0xF302, 0xDBE8 },
        { 0xF303, 0xDBE9 },
        { 0xF304, 0xDBEA },
        { 0xF305, 0xDBEB },
        { 0xF306, 0xDBEC },
        { 0xF307, 0xDBED },
        { 0xF308, 0xDBEE },
        { 0xF309, 0xDBEF },
        { 0xF30A, 0xDBF0 },
        { 0xF30B, 0xDBF1 },
        { 0xF30C, 0xDBF2 },
        { 0xF30D, 0xDBF3 },
        { 0xF30E, 0xDBF4 },
        { 0xF30F, 0xDBF5 },
        { 0xF310, 0xDBF6 },
        { 0xF311, 0xDBF7 },
        { 0xF312, 0xDBF8 },
        { 0xF313, 0xDBF9 },
        { 0xF314, 0xDBFA },
        { 0xF315, 0xDBFB },
        { 0xF316, 0xDBFC },
        { 0xF317, 0xDBFD },
        { 0xF318, 0xDC41 },
        { 0xF319, 0xDC42 },
        { 0xF31A, 0xDC43 },
        { 0xF31B, 0xDC44 },
        { 0xF31C, 0xDC45 },
        { 0xF31D, 0xDC46 },
        { 0xF31E, 0xDC47 },
        { 0xF31F, 0xDC48 },
        { 0xF320, 0xDC49 },
        { 0xF321, 0xDC4A },
        { 0xF322, 0xDC4B },
        { 0xF323, 0xDC4C },
        { 0xF324, 0xDC4D },
        { 0xF325, 0xDC4E },
        { 0xF326, 0xDC4F },
        { 0xF327, 0xDC50 },
        { 0xF328, 0xDC51 },
        { 0xF329, 0xDC52 },
        { 0xF32A, 0xDC53 },
        { 0xF32B, 0xDC54 },
        { 0xF32C, 0xDC55 },
        { 0xF32D, 0xDC56 },
        { 0xF32E, 0xDC57 },
        { 0xF32F, 0xDC58 },
        { 0xF330, 0xDC59 },
        { 0xF331, 0xDC5A },
        { 0xF332, 0xDC5B },
        { 0xF333, 0xDC5C },
        { 0xF334, 0xDC5D },
        { 0xF335, 0xDC5E },
        { 0xF336, 0xDC5F },
        { 0xF337, 0xDC60 },
        { 0xF338, 0xDC61 },
        { 0xF339, 0xDC62 },
        { 0xF33A, 0xDC63 },
        { 0xF33B, 0xDC64 },
        { 0xF33C, 0xDC65 },
        { 0xF33D, 0xDC66 },
        { 0xF33E, 0xDC67 },
        { 0xF33F, 0xDC68 },
        { 0xF340, 0xDC69 },
        { 0xF341, 0xDC6A },
        { 0xF342, 0xDC6B },
        { 0xF343, 0xDC6C },
        { 0xF344, 0xDC6D },
        { 0xF345, 0xDC6E },
        { 0xF346, 0xDC6F },
        { 0xF347, 0xDC70 },
        { 0xF348, 0xDC71 },
        { 0xF349, 0xDC72 },
        { 0xF34A, 0xDC73 },
        { 0xF34B, 0xDC74 },
        { 0xF34C, 0xDC75 },
        { 0xF34D, 0xDC76 },
        { 0xF34E, 0xDC77 },
        { 0xF34F, 0xDC78 },
        { 0xF350, 0xDC79 },
        { 0xF351, 0xDC7A },
        { 0xF352, 0xDC7B },
        { 0xF353, 0xDC7C },
        { 0xF354, 0xDC7D },
        { 0xF355, 0xDC7E },
        { 0xF356, 0xDC7F },
        { 0xF357, 0xDC81 },
        { 0xF358, 0xDC82 },
        { 0xF359, 0xDC83 },
        { 0xF35A, 0xDC84 },
        { 0xF35B, 0xDC85 },
        { 0xF35C, 0xDC86 },
        { 0xF35D, 0xDC87 },
        { 0xF35E, 0xDC88 },
        { 0xF35F, 0xDC89 },
        { 0xF360, 0xDC8A },
        { 0xF361, 0xDC8B },
        { 0xF362, 0xDC8C },
        { 0xF363, 0xDC8D },
        { 0xF364, 0xDC8E },
        { 0xF365, 0xDC8F },
        { 0xF366, 0xDC90 },
        { 0xF367, 0xDC91 },
        { 0xF368, 0xDC92 },
        { 0xF369, 0xDC93 },
        { 0xF36A, 0xDC94 },
        { 0xF36B, 0xDC95 },
        { 0xF36C, 0xDC96 },
        { 0xF36D, 0xDC97 },
        { 0xF36E, 0xDC98 },
        { 0xF36F, 0xDC99 },
        { 0xF370, 0xDC9A },
        { 0xF371, 0xDC9B },
        { 0xF372, 0xDC9C },
        { 0xF373, 0xDC9D },
        { 0xF374, 0xDC9E },
        { 0xF375, 0xDC9F },
        { 0xF376, 0xDCA0 },
        { 0xF377, 0xDCA1 },
        { 0xF378, 0xDCA2 },
        { 0xF379, 0xDCA3 },
        { 0xF37A, 0xDCA4 },
        { 0xF37B, 0xDCA5 },
        { 0xF37C, 0xDCA6 },
        { 0xF37D, 0xDCA7 },
        { 0xF37E, 0xDCA8 },
        { 0xF37F, 0xDCA9 },
        { 0xF380, 0xDCAA },
        { 0xF381, 0xDCAB },
        { 0xF382, 0xDCAC },
        { 0xF383, 0xDCAD },
        { 0xF384, 0xDCAE },
        { 0xF385, 0xDCAF },
        { 0xF386, 0xDCB0 },
        { 0xF387, 0xDCB1 },
        { 0xF388, 0xDCB2 },
        { 0xF389, 0xDCB3 },
        { 0xF38A, 0xDCB4 },
        { 0xF38B, 0xDCB5 },
        { 0xF38C, 0xDCB6 },
        { 0xF38D, 0xDCB7 },
        { 0xF38E, 0xDCB8 },
        { 0xF38F, 0xDCB9 },
        { 0xF390, 0xDCBA },
        { 0xF391, 0xDCBB },
        { 0xF392, 0xDCBC },
        { 0xF393, 0xDCBD },
        { 0xF394, 0xDCBE },
        { 0xF395, 0xDCBF },
        { 0xF396, 0xDCC0 },
        { 0xF397, 0xDCC1 },
        { 0xF398, 0xDCC2 },
        { 0xF399, 0xDCC3 },
        { 0xF39A, 0xDCC4 },
        { 0xF39B, 0xDCC5 },
        { 0xF39C, 0xDCC6 },
        { 0xF39D, 0xDCC7 },
        { 0xF39E, 0xDCC8 },
        { 0xF39F, 0xDCC9 },
        { 0xF3A0, 0xDCCA },
        { 0xF3A1, 0xDCCB },
        { 0xF3A2, 0xDCCC },
        { 0xF3A3, 0xDCCD },
        { 0xF3A4, 0xDCCE },
        { 0xF3A5, 0xDCCF },
        { 0xF3A6, 0xDCD0 },
        { 0xF3A7, 0xDCD1 },
        { 0xF3A8, 0xDCD2 },
        { 0xF3A9, 0xDCD3 },
        { 0xF3AA, 0xDCD4 },
        { 0xF3AB, 0xDCD5 },
        { 0xF3AC, 0xDCD6 },
        { 0xF3AD, 0xDCD7 },
        { 0xF3AE, 0xDCD8 },
        { 0xF3AF, 0xDCD9 },
        { 0xF3B0, 0xDCDA },
        { 0xF3B1, 0xDCDB },
        { 0xF3B2, 0xDCDC },
        { 0xF3B3, 0xDCDD },
        { 0xF3B4, 0xDCDE },
        { 0xF3B5, 0xDCDF },
        { 0xF3B6, 0xDCE0 },
        { 0xF3B7, 0xDCE1 },
        { 0xF3B8, 0xDCE2 },
        { 0xF3B9, 0xDCE3 },
        { 0xF3BA, 0xDCE4 },
        { 0xF3BB, 0xDCE5 },
        { 0xF3BC, 0xDCE6 },
        { 0xF3BD, 0xDCE7 },
        { 0xF3BE, 0xDCE8 },
        { 0xF3BF, 0xDCE9 },
        { 0xF3C0, 0xDCEA },
        { 0xF3C1, 0xDCEB },
        { 0xF3C2, 0xDCEC },
        { 0xF3C3, 0xDCED },
        { 0xF3C4, 0xDCEE },
        { 0xF3C5, 0xDCEF },
        { 0xF3C6, 0xDCF0 },
        { 0xF3C7, 0xDCF1 },
        { 0xF3C8, 0xDCF2 },
        { 0xF3C9, 0xDCF3 },
        { 0xF3CA, 0xDCF4 },
        { 0xF3CB, 0xDCF5 },
        { 0xF3CC, 0xDCF6 },
        { 0xF3CD, 0xDCF7 },
        { 0xF3CE, 0xDCF8 },
        { 0xF3CF, 0xDCF9 },
        { 0xF3D0, 0xDCFA },
        { 0xF3D1, 0xDCFB },
        { 0xF3D2, 0xDCFC },
        { 0xF3D3, 0xDCFD },
        { 0xF3D4, 0xDD41 },
        { 0xF3D5, 0xDD42 },
        { 0xF3D6, 0xDD43 },
        { 0xF3D7, 0xDD44 },
        { 0xF3D8, 0xDD45 },
        { 0xF3D9, 0xDD46 },
        { 0xF3DA, 0xDD47 },
        { 0xF3DB, 0xDD48 },
        { 0xF3DC, 0xDD49 },
        { 0xF3DD, 0xDD4A },
        { 0xF3DE, 0xDD4B },
        { 0xF3DF, 0xDD4C },
        { 0xF3E0, 0xDD4D },
        { 0xF3E1, 0xDD4E },
        { 0xF3E2, 0xDD4F },
        { 0xF3E3, 0xDD50 },
        { 0xF3E4, 0xDD51 },
        { 0xF3E5, 0xDD52 },
        { 0xF3E6, 0xDD53 },
        { 0xF3E7, 0xDD54 },
        { 0xF3E8, 0xDD55 },
        { 0xF3E9, 0xDD56 },
        { 0xF3EA, 0xDD57 },
        { 0xF3EB, 0xDD58 },
        { 0xF3EC, 0xDD59 },
        { 0xF3ED, 0xDD5A },
        { 0xF3EE, 0xDD5B },
        { 0xF3EF, 0xDD5C },
        { 0xF3F0, 0xDD5D },
        { 0xF3F1, 0xDD5E },
        { 0xF3F2, 0xDD5F },
        { 0xF3F3, 0xDD60 },
        { 0xF3F4, 0xDD61 },
        { 0xF3F5, 0xDD62 },
        { 0xF3F6, 0xDD63 },
        { 0xF3F7, 0xDD64 },
        { 0xF3F8, 0xDD65 },
        { 0xF3F9, 0xDD66 },
        { 0xF3FA, 0xDD67 },
        { 0xF3FB, 0xDD68 },
        { 0xF3FC, 0xDD69 },
        { 0xF3FD, 0xDD6A },
        { 0xF3FE, 0xDD6B },
        { 0xF3FF, 0xDD6C },
        { 0xF400, 0xDD6D },
        { 0xF401, 0xDD6E },
        { 0xF402, 0xDD6F },
        { 0xF403, 0xDD70 },
        { 0xF404, 0xDD71 },
        { 0xF405, 0xDD72 },
        { 0xF406, 0xDD73 },
        { 0xF407, 0xDD74 },
        { 0xF408, 0xDD75 },
        { 0xF409, 0xDD76 },
        { 0xF40A, 0xDD77 },
        { 0xF40B, 0xDD78 },
        { 0xF40C, 0xDD79 },
        { 0xF40D, 0xDD7A },
        { 0xF40E, 0xDD7B },
        { 0xF40F, 0xDD7C },
        { 0xF410, 0xDD7D },
        { 0xF411, 0xDD7E },
        { 0xF412, 0xDD7F },
        { 0xF413, 0xDD81 },
        { 0xF414, 0xDD82 },
        { 0xF415, 0xDD83 },
        { 0xF416, 0xDD84 },
        { 0xF417, 0xDD85 },
        { 0xF418, 0xDD86 },
        { 0xF419, 0xDD87 },
        { 0xF41A, 0xDD88 },
        { 0xF41B, 0xDD89 },
        { 0xF41C, 0xDD8A },
        { 0xF41D, 0xDD8B },
        { 0xF41E, 0xDD8C },
        { 0xF41F, 0xDD8D },
        { 0xF420, 0xDD8E },
        { 0xF421, 0xDD8F },
        { 0xF422, 0xDD90 },
        { 0xF423, 0xDD91 },
        { 0xF424, 0xDD92 },
        { 0xF425, 0xDD93 },
        { 0xF426, 0xDD94 },
        { 0xF427, 0xDD95 },
        { 0xF428, 0xDD96 },
        { 0xF429, 0xDD97 },
        { 0xF42A, 0xDD98 },
        { 0xF42B, 0xDD99 },
        { 0xF42C, 0xDD9A },
        { 0xF42D, 0xDD9B },
        { 0xF42E, 0xDD9C },
        { 0xF42F, 0xDD9D },
        { 0xF430, 0xDD9E },
        { 0xF431, 0xDD9F },
        { 0xF432, 0xDDA0 },
        { 0xF433, 0xDDA1 },
        { 0xF434, 0xDDA2 },
        { 0xF435, 0xDDA3 },
        { 0xF436, 0xDDA4 },
        { 0xF437, 0xDDA5 },
        { 0xF438, 0xDDA6 },
        { 0xF439, 0xDDA7 },
        { 0xF43A, 0xDDA8 },
        { 0xF43B, 0xDDA9 },
        { 0xF43C, 0xDDAA },
        { 0xF43D, 0xDDAB },
        { 0xF43E, 0xDDAC },
        { 0xF43F, 0xDDAD },
        { 0xF440, 0xDDAE },
        { 0xF441, 0xDDAF },
        { 0xF442, 0xDDB0 },
        { 0xF443, 0xDDB1 },
        { 0xF444, 0xDDB2 },
        { 0xF445, 0xDDB3 },
        { 0xF446, 0xDDB4 },
        { 0xF447, 0xDDB5 },
        { 0xF448, 0xDDB6 },
        { 0xF449, 0xDDB7 },
        { 0xF44A, 0xDDB8 },
        { 0xF44B, 0xDDB9 },
        { 0xF44C, 0xDDBA },
        { 0xF44D, 0xDDBB },
        { 0xF44E, 0xDDBC },
        { 0xF44F, 0xDDBD },
        { 0xF450, 0xDDBE },
        { 0xF451, 0xDDBF },
        { 0xF452, 0xDDC0 },
        { 0xF453, 0xDDC1 },
        { 0xF454, 0xDDC2 },
        { 0xF455, 0xDDC3 },
        { 0xF456, 0xDDC4 },
        { 0xF457, 0xDDC5 },
        { 0xF458, 0xDDC6 },
        { 0xF459, 0xDDC7 },
        { 0xF45A, 0xDDC8 },
        { 0xF45B, 0xDDC9 },
        { 0xF45C, 0xDDCA },
        { 0xF45D, 0xDDCB },
        { 0xF45E, 0xDDCC },
        { 0xF45F, 0xDDCD },
        { 0xF460, 0xDDCE },
        { 0xF461, 0xDDCF },
        { 0xF462, 0xDDD0 },
        { 0xF463, 0xDDD1 },
        { 0xF464, 0xDDD2 },
        { 0xF465, 0xDDD3 },
        { 0xF466, 0xDDD4 },
        { 0xF467, 0xDDD5 },
        { 0xF468, 0xDDD6 },
        { 0xF469, 0xDDD7 },
        { 0xF46A, 0xDDD8 },
        { 0xF46B, 0xDDD9 },
        { 0xF46C, 0xDDDA },
        { 0xF46D, 0xDDDB },
        { 0xF46E, 0xDDDC },
        { 0xF46F, 0xDDDD },
        { 0xF470, 0xDDDE },
        { 0xF471, 0xDDDF },
        { 0xF472, 0xDDE0 },
        { 0xF473, 0xDDE1 },
        { 0xF474, 0xDDE2 },
        { 0xF475, 0xDDE3 },
        { 0xF476, 0xDDE4 },
        { 0xF477, 0xDDE5 },
        { 0xF478, 0xDDE6 },
        { 0xF479, 0xDDE7 },
        { 0xF47A, 0xDDE8 },
        { 0xF47B, 0xDDE9 },
        { 0xF47C, 0xDDEA },
        { 0xF47D, 0xDDEB },
        { 0xF47E, 0xDDEC },
        { 0xF47F, 0xDDED },
        { 0xF480, 0xDDEE },
        { 0xF481, 0xDDEF },
        { 0xF482, 0xDDF0 },
        { 0xF483, 0xDDF1 },
        { 0xF484, 0xDDF2 },
        { 0xF485, 0xDDF3 },
        { 0xF486, 0xDDF4 },
        { 0xF487, 0xDDF5 },
        { 0xF488, 0xDDF6 },
        { 0xF489, 0xDDF7 },
        { 0xF48A, 0xDDF8 },
        { 0xF48B, 0xDDF9 },
        { 0xF48C, 0xDDFA },
        { 0xF48D, 0xDDFB },
        { 0xF48E, 0xDDFC },
        { 0xF48F, 0xDDFD },
        { 0xF490, 0xDE41 },
        { 0xF491, 0xDE42 },
        { 0xF492, 0xDE43 },
        { 0xF493, 0xDE44 },
        { 0xF494, 0xDE45 },
        { 0xF495, 0xDE46 },
        { 0xF496, 0xDE47 },
        { 0xF497, 0xDE48 },
        { 0xF498, 0xDE49 },
        { 0xF499, 0xDE4A },
        { 0xF49A, 0xDE4B },
        { 0xF49B, 0xDE4C },
        { 0xF49C, 0xDE4D },
        { 0xF49D, 0xDE4E },
        { 0xF49E, 0xDE4F },
        { 0xF49F, 0xDE50 },
        { 0xF4A0, 0xDE51 },
        { 0xF4A1, 0xDE52 },
        { 0xF4A2, 0xDE53 },
        { 0xF4A3, 0xDE54 },
        { 0xF4A4, 0xDE55 },
        { 0xF4A5, 0xDE56 },
        { 0xF4A6, 0xDE57 },
        { 0xF4A7, 0xDE58 },
        { 0xF4A8, 0xDE59 },
        { 0xF4A9, 0xDE5A },
        { 0xF4AA, 0xDE5B },
        { 0xF4AB, 0xDE5C },
        { 0xF4AC, 0xDE5D },
        { 0xF4AD, 0xDE5E },
        { 0xF4AE, 0xDE5F },
        { 0xF4AF, 0xDE60 },
        { 0xF4B0, 0xDE61 },
        { 0xF4B1, 0xDE62 },
        { 0xF4B2, 0xDE63 },
        { 0xF4B3, 0xDE64 },
        { 0xF4B4, 0xDE65 },
        { 0xF4B5, 0xDE66 },
        { 0xF4B6, 0xDE67 },
        { 0xF4B7, 0xDE68 },
        { 0xF4B8, 0xDE69 },
        { 0xF4B9, 0xDE6A },
        { 0xF4BA, 0xDE6B },
        { 0xF4BB, 0xDE6C },
        { 0xF4BC, 0xDE6D },
        { 0xF4BD, 0xDE6E },
        { 0xF4BE, 0xDE6F },
        { 0xF4BF, 0xDE70 },
        { 0xF4C0, 0xDE71 },
        { 0xF4C1, 0xDE72 },
        { 0xF4C2, 0xDE73 },
        { 0xF4C3, 0xDE74 },
        { 0xF4C4, 0xDE75 },
        { 0xF4C5, 0xDE76 },
        { 0xF4C6, 0xDE77 },
        { 0xF4C7, 0xDE78 },
        { 0xF4C8, 0xDE79 },
        { 0xF4C9, 0xDE7A },
        { 0xF4CA, 0xDE7B },
        { 0xF4CB, 0xDE7C },
        { 0xF4CC, 0xDE7D },
        { 0xF4CD, 0xDE7E },
        { 0xF4CE, 0xDE7F },
        { 0xF4CF, 0xDE81 },
        { 0xF4D0, 0xDE82 },
        { 0xF4D1, 0xDE83 },
        { 0xF4D2, 0xDE84 },
        { 0xF4D3, 0xDE85 },
        { 0xF4D4, 0xDE86 },
        { 0xF4D5, 0xDE87 },
        { 0xF4D6, 0xDE88 },
        { 0xF4D7, 0xDE89 },
        { 0xF4D8, 0xDE8A },
        { 0xF4D9, 0xDE8B },
        { 0xF4DA, 0xDE8C },
        { 0xF4DB, 0xDE8D },
        { 0xF4DC, 0xDE8E },
        { 0xF4DD, 0xDE8F },
        { 0xF4DE, 0xDE90 },
        { 0xF4DF, 0xDE91 },
        { 0xF4E0, 0xDE92 },
        { 0xF4E1, 0xDE93 },
        { 0xF4E2, 0xDE94 },
        { 0xF4E3, 0xDE95 },
        { 0xF4E4, 0xDE96 },
        { 0xF4E5, 0xDE97 },
        { 0xF4E6, 0xDE98 },
        { 0xF4E7, 0xDE99 },
        { 0xF4E8, 0xDE9A },
        { 0xF4E9, 0xDE9B },
        { 0xF4EA, 0xDE9C },
        { 0xF4EB, 0xDE9D },
        { 0xF4EC, 0xDE9E },
        { 0xF4ED, 0xDE9F },
        { 0xF4EE, 0xDEA0 },
        { 0xF4EF, 0xDEA1 },
        { 0xF4F0, 0xDEA2 },
        { 0xF4F1, 0xDEA3 },
        { 0xF4F2, 0xDEA4 },
        { 0xF4F3, 0xDEA5 },
        { 0xF4F4, 0xDEA6 },
        { 0xF4F5, 0xDEA7 },
        { 0xF4F6, 0xDEA8 },
        { 0xF4F7, 0xDEA9 },
        { 0xF4F8, 0xDEAA },
        { 0xF4F9, 0xDEAB },
        { 0xF4FA, 0xDEAC },
        { 0xF4FB, 0xDEAD },
        { 0xF4FC, 0xDEAE },
        { 0xF4FD, 0xDEAF },
        { 0xF4FE, 0xDEB0 },
        { 0xF4FF, 0xDEB1 },
        { 0xF500, 0xDEB2 },
        { 0xF501, 0xDEB3 },
        { 0xF502, 0xDEB4 },
        { 0xF503, 0xDEB5 },
        { 0xF504, 0xDEB6 },
        { 0xF505, 0xDEB7 },
        { 0xF506, 0xDEB8 },
        { 0xF507, 0xDEB9 },
        { 0xF508, 0xDEBA },
        { 0xF509, 0xDEBB },
        { 0xF50A, 0xDEBC },
        { 0xF50B, 0xDEBD },
        { 0xF50C, 0xDEBE },
        { 0xF50D, 0xDEBF },
        { 0xF50E, 0xDEC0 },
        { 0xF50F, 0xDEC1 },
        { 0xF510, 0xDEC2 },
        { 0xF511, 0xDEC3 },
        { 0xF512, 0xDEC4 },
        { 0xF513, 0xDEC5 },
        { 0xF514, 0xDEC6 },
        { 0xF515, 0xDEC7 },
        { 0xF516, 0xDEC8 },
        { 0xF517, 0xDEC9 },
        { 0xF518, 0xDECA },
        { 0xF519, 0xDECB },
        { 0xF51A, 0xDECC },
        { 0xF51B, 0xDECD },
        { 0xF51C, 0xDECE },
        { 0xF51D, 0xDECF },
        { 0xF51E, 0xDED0 },
        { 0xF51F, 0xDED1 },
        { 0xF520, 0xDED2 },
        { 0xF521, 0xDED3 },
        { 0xF522, 0xDED4 },
        { 0xF523, 0xDED5 },
        { 0xF524, 0xDED6 },
        { 0xF525, 0xDED7 },
        { 0xF526, 0xDED8 },
        { 0xF527, 0xDED9 },
        { 0xF528, 0xDEDA },
        { 0xF529, 0xDEDB },
        { 0xF52A, 0xDEDC },
        { 0xF52B, 0xDEDD },
        { 0xF52C, 0xDEDE },
        { 0xF52D, 0xDEDF },
        { 0xF52E, 0xDEE0 },
        { 0xF52F, 0xDEE1 },
        { 0xF530, 0xDEE2 },
        { 0xF531, 0xDEE3 },
        { 0xF532, 0xDEE4 },
        { 0xF533, 0xDEE5 },
        { 0xF534, 0xDEE6 },
        { 0xF535, 0xDEE7 },
        { 0xF536, 0xDEE8 },
        { 0xF537, 0xDEE9 },
        { 0xF538, 0xDEEA },
        { 0xF539, 0xDEEB },
        { 0xF53A, 0xDEEC },
        { 0xF53B, 0xDEED },
        { 0xF53C, 0xDEEE },
        { 0xF53D, 0xDEEF },
        { 0xF53E, 0xDEF0 },
        { 0xF53F, 0xDEF1 },
        { 0xF540, 0xDEF2 },
        { 0xF541, 0xDEF3 },
        { 0xF542, 0xDEF4 },
        { 0xF543, 0xDEF5 },
        { 0xF544, 0xDEF6 },
        { 0xF545, 0xDEF7 },
        { 0xF546, 0xDEF8 },
        { 0xF547, 0xDEF9 },
        { 0xF548, 0xDEFA },
        { 0xF549, 0xDEFB },
        { 0xF54A, 0xDEFC },
        { 0xF54B, 0xDEFD },
        { 0xF54C, 0xDF41 },
        { 0xF54D, 0xDF42 },
        { 0xF54E, 0xDF43 },
        { 0xF54F, 0xDF44 },
        { 0xF550, 0xDF45 },
        { 0xF551, 0xDF46 },
        { 0xF552, 0xDF47 },
        { 0xF553, 0xDF48 },
        { 0xF554, 0xDF49 },
        { 0xF555, 0xDF4A },
        { 0xF556, 0xDF4B },
        { 0xF557, 0xDF4C },
        { 0xF558, 0xDF4D },
        { 0xF559, 0xDF4E },
        { 0xF55A, 0xDF4F },
        { 0xF55B, 0xDF50 },
        { 0xF55C, 0xDF51 },
        { 0xF55D, 0xDF52 },
        { 0xF55E, 0xDF53 },
        { 0xF55F, 0xDF54 },
        { 0xF560, 0xDF55 },
        { 0xF561, 0xDF56 },
        { 0xF562, 0xDF57 },
        { 0xF563, 0xDF58 },
        { 0xF564, 0xDF59 },
        { 0xF565, 0xDF5A },
        { 0xF566, 0xDF5B },
        { 0xF567, 0xDF5C },
        { 0xF568, 0xDF5D },
        { 0xF569, 0xDF5E },
        { 0xF56A, 0xDF5F },
        { 0xF56B, 0xDF60 },
        { 0xF56C, 0xDF61 },
        { 0xF56D, 0xDF62 },
        { 0xF56E, 0xDF63 },
        { 0xF56F, 0xDF64 },
        { 0xF570, 0xDF65 },
        { 0xF571, 0xDF66 },
        { 0xF572, 0xDF67 },
        { 0xF573, 0xDF68 },
        { 0xF574, 0xDF69 },
        { 0xF575, 0xDF6A },
        { 0xF576, 0xDF6B },
        { 0xF577, 0xDF6C },
        { 0xF578, 0xDF6D },
        { 0xF579, 0xDF6E },
        { 0xF57A, 0xDF6F },
        { 0xF57B, 0xDF70 },
        { 0xF57C, 0xDF71 },
        { 0xF57D, 0xDF72 },
        { 0xF57E, 0xDF73 },
        { 0xF57F, 0xDF74 },
        { 0xF580, 0xDF75 },
        { 0xF581, 0xDF76 },
        { 0xF582, 0xDF77 },
        { 0xF583, 0xDF78 },
        { 0xF584, 0xDF79 },
        { 0xF585, 0xDF7A },
        { 0xF586, 0xDF7B },
        { 0xF587, 0xDF7C },
        { 0xF588, 0xDF7D },
        { 0xF589, 0xDF7E },
        { 0xF58A, 0xDF7F },
        { 0xF58B, 0xDF81 },
        { 0xF58C, 0xDF82 },
        { 0xF58D, 0xDF83 },
        { 0xF58E, 0xDF84 },
        { 0xF58F, 0xDF85 },
        { 0xF590, 0xDF86 },
        { 0xF591, 0xDF87 },
        { 0xF592, 0xDF88 },
        { 0xF593, 0xDF89 },
        { 0xF594, 0xDF8A },
        { 0xF595, 0xDF8B },
        { 0xF596, 0xDF8C },
        { 0xF597, 0xDF8D },
        { 0xF598, 0xDF8E },
        { 0xF599, 0xDF8F },
        { 0xF59A, 0xDF90 },
        { 0xF59B, 0xDF91 },
        { 0xF59C, 0xDF92 },
        { 0xF59D, 0xDF93 },
        { 0xF59E, 0xDF94 },
        { 0xF59F, 0xDF95 },
        { 0xF5A0, 0xDF96 },
        { 0xF5A1, 0xDF97 },
        { 0xF5A2, 0xDF98 },
        { 0xF5A3, 0xDF99 },
        { 0xF5A4, 0xDF9A },
        { 0xF5A5, 0xDF9B },
        { 0xF5A6, 0xDF9C },
        { 0xF5A7, 0xDF9D },
        { 0xF5A8, 0xDF9E },
        { 0xF5A9, 0xDF9F },
        { 0xF5AA, 0xDFA0 },
        { 0xF5AB, 0xDFA1 },
        { 0xF5AC, 0xDFA2 },
        { 0xF5AD, 0xDFA3 },
        { 0xF5AE, 0xDFA4 },
        { 0xF5AF, 0xDFA5 },
        { 0xF5B0, 0xDFA6 },
        { 0xF5B1, 0xDFA7 },
        { 0xF5B2, 0xDFA8 },
        { 0xF5B3, 0xDFA9 },
        { 0xF5B4, 0xDFAA },
        { 0xF5B5, 0xDFAB },
        { 0xF5B6, 0xDFAC },
        { 0xF5B7, 0xDFAD },
        { 0xF5B8, 0xDFAE },
        { 0xF5B9, 0xDFAF },
        { 0xF5BA, 0xDFB0 },
        { 0xF5BB, 0xDFB1 },
        { 0xF5BC, 0xDFB2 },
        { 0xF5BD, 0xDFB3 },
        { 0xF5BE, 0xDFB4 },
        { 0xF5BF, 0xDFB5 },
        { 0xF5C0, 0xDFB6 },
        { 0xF5C1, 0xDFB7 },
        { 0xF5C2, 0xDFB8 },
        { 0xF5C3, 0xDFB9 },
        { 0xF5C4, 0xDFBA },
        { 0xF5C5, 0xDFBB },
        { 0xF5C6, 0xDFBC },
        { 0xF5C7, 0xDFBD },
        { 0xF5C8, 0xDFBE },
        { 0xF5C9, 0xDFBF },
        { 0xF5CA, 0xDFC0 },
        { 0xF5CB, 0xDFC1 },
        { 0xF5CC, 0xDFC2 },
        { 0xF5CD, 0xDFC3 },
        { 0xF5CE, 0xDFC4 },
        { 0xF5CF, 0xDFC5 },
        { 0xF5D0, 0xDFC6 },
        { 0xF5D1, 0xDFC7 },
        { 0xF5D2, 0xDFC8 },
        { 0xF5D3, 0xDFC9 },
        { 0xF5D4, 0xDFCA },
        { 0xF5D5, 0xDFCB },
        { 0xF5D6, 0xDFCC },
        { 0xF5D7, 0xDFCD },
        { 0xF5D8, 0xDFCE },
        { 0xF5D9, 0xDFCF },
        { 0xF5DA, 0xDFD0 },
        { 0xF5DB, 0xDFD1 },
        { 0xF5DC, 0xDFD2 },
        { 0xF5DD, 0xDFD3 },
        { 0xF5DE, 0xDFD4 },
        { 0xF5DF, 0xDFD5 },
        { 0xF5E0, 0xDFD6 },
        { 0xF5E1, 0xDFD7 },
        { 0xF5E2, 0xDFD8 },
        { 0xF5E3, 0xDFD9 },
        { 0xF5E4, 0xDFDA },
        { 0xF5E5, 0xDFDB },
        { 0xF5E6, 0xDFDC },
        { 0xF5E7, 0xDFDD },
        { 0xF5E8, 0xDFDE },
        { 0xF5E9, 0xDFDF },
        { 0xF5EA, 0xDFE0 },
        { 0xF5EB, 0xDFE1 },
        { 0xF5EC, 0xDFE2 },
        { 0xF5ED, 0xDFE3 },
        { 0xF5EE, 0xDFE4 },
        { 0xF5EF, 0xDFE5 },
        { 0xF5F0, 0xDFE6 },
        { 0xF5F1, 0xDFE7 },
        { 0xF5F2, 0xDFE8 },
        { 0xF5F3, 0xDFE9 },
        { 0xF5F4, 0xDFEA },
        { 0xF5F5, 0xDFEB },
        { 0xF5F6, 0xDFEC },
        { 0xF5F7, 0xDFED },
        { 0xF5F8, 0xDFEE },
        { 0xF5F9, 0xDFEF },
        { 0xF5FA, 0xDFF0 },
        { 0xF5FB, 0xDFF1 },
        { 0xF5FC, 0xDFF2 },
        { 0xF5FD, 0xDFF3 },
        { 0xF5FE, 0xDFF4 },
        { 0xF5FF, 0xDFF5 },
        { 0xF600, 0xDFF6 },
        { 0xF601, 0xDFF7 },
        { 0xF602, 0xDFF8 },
        { 0xF603, 0xDFF9 },
        { 0xF604, 0xDFFA },
        { 0xF605, 0xDFFB },
        { 0xF606, 0xDFFC },
        { 0xF607, 0xDFFD },
        { 0xF608, 0xE041 },
        { 0xF609, 0xE042 },
        { 0xF60A, 0xE043 },
        { 0xF60B, 0xE044 },
        { 0xF60C, 0xE045 },
        { 0xF60D, 0xE046 },
        { 0xF60E, 0xE047 },
        { 0xF60F, 0xE048 },
        { 0xF610, 0xE049 },
        { 0xF611, 0xE04A },
        { 0xF612, 0xE04B },
        { 0xF613, 0xE04C },
        { 0xF614, 0xE04D },
        { 0xF615, 0xE04E },
        { 0xF616, 0xE04F },
        { 0xF617, 0xE050 },
        { 0xF618, 0xE051 },
        { 0xF619, 0xE052 },
        { 0xF61A, 0xE053 },
        { 0xF61B, 0xE054 },
        { 0xF61C, 0xE055 },
        { 0xF61D, 0xE056 },
        { 0xF61E, 0xE057 },
        { 0xF61F, 0xE058 },
        { 0xF620, 0xE059 },
        { 0xF621, 0xE05A },
        { 0xF622, 0xE05B },
        { 0xF623, 0xE05C },
        { 0xF624, 0xE05D },
        { 0xF625, 0xE05E },
        { 0xF626, 0xE05F },
        { 0xF627, 0xE060 },
        { 0xF628, 0xE061 },
        { 0xF629, 0xE062 },
        { 0xF62A, 0xE063 },
        { 0xF62B, 0xE064 },
        { 0xF62C, 0xE065 },
        { 0xF62D, 0xE066 },
        { 0xF62E, 0xE067 },
        { 0xF62F, 0xE068 },
        { 0xF630, 0xE069 },
        { 0xF631, 0xE06A },
        { 0xF632, 0xE06B },
        { 0xF633, 0xE06C },
        { 0xF634, 0xE06D },
        { 0xF635, 0xE06E },
        { 0xF636, 0xE06F },
        { 0xF637, 0xE070 },
        { 0xF638, 0xE071 },
        { 0xF639, 0xE072 },
        { 0xF63A, 0xE073 },
        { 0xF63B, 0xE074 },
        { 0xF63C, 0xE075 },
        { 0xF63D, 0xE076 },
        { 0xF63E, 0xE077 },
        { 0xF63F, 0xE078 },
        { 0xF640, 0xE079 },
        { 0xF641, 0xE07A },
        { 0xF642, 0xE07B },
        { 0xF643, 0xE07C },
        { 0xF644, 0xE07D },
        { 0xF645, 0xE07E },
        { 0xF646, 0xE07F },
        { 0xF647, 0xE081 },
        { 0xF648, 0xE082 },
        { 0xF649, 0xE083 },
        { 0xF64A, 0xE084 },
        { 0xF64B, 0xE085 },
        { 0xF64C, 0xE086 },
        { 0xF64D, 0xE087 },
        { 0xF64E, 0xE088 },
        { 0xF64F, 0xE089 },
        { 0xF650, 0xE08A },
        { 0xF651, 0xE08B },
        { 0xF652, 0xE08C },
        { 0xF653, 0xE08D },
        { 0xF654, 0xE08E },
        { 0xF655, 0xE08F },
        { 0xF656, 0xE090 },
        { 0xF657, 0xE091 },
        { 0xF658, 0xE092 },
        { 0xF659, 0xE093 },
        { 0xF65A, 0xE094 },
        { 0xF65B, 0xE095 },
        { 0xF65C, 0xE096 },
        { 0xF65D, 0xE097 },
        { 0xF65E, 0xE098 },
        { 0xF65F, 0xE099 },
        { 0xF660, 0xE09A },
        { 0xF661, 0xE09B },
        { 0xF662, 0xE09C },
        { 0xF663, 0xE09D },
        { 0xF664, 0xE09E },
        { 0xF665, 0xE09F },
        { 0xF666, 0xE0A0 },
        { 0xF667, 0xE0A1 },
        { 0xF668, 0xE0A2 },
        { 0xF669, 0xE0A3 },
        { 0xF66A, 0xE0A4 },
        { 0xF66B, 0xE0A5 },
        { 0xF66C, 0xE0A6 },
        { 0xF66D, 0xE0A7 },
        { 0xF66E, 0xE0A8 },
        { 0xF66F, 0xE0A9 },
        { 0xF670, 0xE0AA },
        { 0xF671, 0xE0AB },
        { 0xF672, 0xE0AC },
        { 0xF673, 0xE0AD },
        { 0xF674, 0xE0AE },
        { 0xF675, 0xE0AF },
        { 0xF676, 0xE0B0 },
        { 0xF677, 0xE0B1 },
        { 0xF678, 0xE0B2 },
        { 0xF679, 0xE0B3 },
        { 0xF67A, 0xE0B4 },
        { 0xF67B, 0xE0B5 },
        { 0xF67C, 0xE0B6 },
        { 0xF67D, 0xE0B7 },
        { 0xF67E, 0xE0B8 },
        { 0xF67F, 0xE0B9 },
        { 0xF680, 0xE0BA },
        { 0xF681, 0xE0BB },
        { 0xF682, 0xE0BC },
        { 0xF683, 0xE0BD },
        { 0xF684, 0xE0BE },
        { 0xF685, 0xE0BF },
        { 0xF686, 0xE0C0 },
        { 0xF687, 0xE0C1 },
        { 0xF688, 0xE0C2 },
        { 0xF689, 0xE0C3 },
        { 0xF68A, 0xE0C4 },
        { 0xF68B, 0xE0C5 },
        { 0xF68C, 0xE0C6 },
        { 0xF68D, 0xE0C7 },
        { 0xF68E, 0xE0C8 },
        { 0xF68F, 0xE0C9 },
        { 0xF690, 0xE0CA },
        { 0xF691, 0xE0CB },
        { 0xF692, 0xE0CC },
        { 0xF693, 0xE0CD },
        { 0xF694, 0xE0CE },
        { 0xF695, 0xE0CF },
        { 0xF696, 0xE0D0 },
        { 0xF697, 0xE0D1 },
        { 0xF698, 0xE0D2 },
        { 0xF699, 0xE0D3 },
        { 0xF69A, 0xE0D4 },
        { 0xF69B, 0xE0D5 },
        { 0xF69C, 0xE0D6 },
        { 0xF69D, 0xE0D7 },
        { 0xF69E, 0xE0D8 },
        { 0xF69F, 0xE0D9 },
        { 0xF6A0, 0xE0DA },
        { 0xF6A1, 0xE0DB },
        { 0xF6A2, 0xE0DC },
        { 0xF6A3, 0xE0DD },
        { 0xF6A4, 0xE0DE },
        { 0xF6A5, 0xE0DF },
        { 0xF6A6, 0xE0E0 },
        { 0xF6A7, 0xE0E1 },
        { 0xF6A8, 0xE0E2 },
        { 0xF6A9, 0xE0E3 },
        { 0xF6AA, 0xE0E4 },
        { 0xF6AB, 0xE0E5 },
        { 0xF6AC, 0xE0E6 },
        { 0xF6AD, 0xE0E7 },
        { 0xF6AE, 0xE0E8 },
        { 0xF6AF, 0xE0E9 },
        { 0xF6B0, 0xE0EA },
        { 0xF6B1, 0xE0EB },
        { 0xF6B2, 0xE0EC },
        { 0xF6B3, 0xE0ED },
        { 0xF6B4, 0xE0EE },
        { 0xF6B5, 0xE0EF },
        { 0xF6B6, 0xE0F0 },
        { 0xF6B7, 0xE0F1 },
        { 0xF6B8, 0xE0F2 },
        { 0xF6B9, 0xE0F3 },
        { 0xF6BA, 0xE0F4 },
        { 0xF6BB, 0xE0F5 },
        { 0xF6BC, 0xE0F6 },
        { 0xF6BD, 0xE0F7 },
        { 0xF6BE, 0xE0F8 },
        { 0xF6BF, 0xE0F9 },
        { 0xF6C0, 0xE0FA },
        { 0xF6C1, 0xE0FB },
        { 0xF6C2, 0xE0FC },
        { 0xF6C3, 0xE0FD },
        { 0xF6C4, 0xE141 },
        { 0xF6C5, 0xE142 },
        { 0xF6C6, 0xE143 },
        { 0xF6C7, 0xE144 },
        { 0xF6C8, 0xE145 },
        { 0xF6C9, 0xE146 },
        { 0xF6CA, 0xE147 },
        { 0xF6CB, 0xE148 },
        { 0xF6CC, 0xE149 },
        { 0xF6CD, 0xE14A },
        { 0xF6CE, 0xE14B },
        { 0xF6CF, 0xE14C },
        { 0xF6D0, 0xE14D },
        { 0xF6D1, 0xE14E },
        { 0xF6D2, 0xE14F },
        { 0xF6D3, 0xE150 },
        { 0xF6D4, 0xE151 },
        { 0xF6D5, 0xE152 },
        { 0xF6D6, 0xE153 },
        { 0xF6D7, 0xE154 },
        { 0xF6D8, 0xE155 },
        { 0xF6D9, 0xE156 },
        { 0xF6DA, 0xE157 },
        { 0xF6DB, 0xE158 },
        { 0xF6DC, 0xE159 },
        { 0xF6DD, 0xE15A },
        { 0xF6DE, 0xE15B },
        { 0xF6DF, 0xE15C },
        { 0xF6E0, 0xE15D },
        { 0xF6E1, 0xE15E },
        { 0xF6E2, 0xE15F },
        { 0xF6E3, 0xE160 },
        { 0xF6E4, 0xE161 },
        { 0xF6E5, 0xE162 },
        { 0xF6E6, 0xE163 },
        { 0xF6E7, 0xE164 },
        { 0xF6E8, 0xE165 },
        { 0xF6E9, 0xE166 },
        { 0xF6EA, 0xE167 },
        { 0xF6EB, 0xE168 },
        { 0xF6EC, 0xE169 },
        { 0xF6ED, 0xE16A },
        { 0xF6EE, 0xE16B },
        { 0xF6EF, 0xE16C },
        { 0xF6F0, 0xE16D },
        { 0xF6F1, 0xE16E },
        { 0xF6F2, 0xE16F },
        { 0xF6F3, 0xE170 },
        { 0xF6F4, 0xE171 },
        { 0xF6F5, 0xE172 },
        { 0xF6F6, 0xE173 },
        { 0xF6F7, 0xE174 },
        { 0xF6F8, 0xE175 },
        { 0xF6F9, 0xE176 },
        { 0xF6FA, 0xE177 },
        { 0xF6FB, 0xE178 },
        { 0xF6FC, 0xE179 },
        { 0xF6FD, 0xE17A },
        { 0xF6FE, 0xE17B },
        { 0xF6FF, 0xE17C },
        { 0xF700, 0xE17D },
        { 0xF701, 0xE17E },
        { 0xF702, 0xE17F },
        { 0xF703, 0xE181 },
        { 0xF704, 0xE182 },
        { 0xF705, 0xE183 },
        { 0xF706, 0xE184 },
        { 0xF707, 0xE185 },
        { 0xF708, 0xE186 },
        { 0xF709, 0xE187 },
        { 0xF70A, 0xE188 },
        { 0xF70B, 0xE189 },
        { 0xF70C, 0xE18A },
        { 0xF70D, 0xE18B },
        { 0xF70E, 0xE18C },
        { 0xF70F, 0xE18D },
        { 0xF710, 0xE18E },
        { 0xF711, 0xE18F },
        { 0xF712, 0xE190 },
        { 0xF713, 0xE191 },
        { 0xF714, 0xE192 },
        { 0xF715, 0xE193 },
        { 0xF716, 0xE194 },
        { 0xF717, 0xE195 },
        { 0xF718, 0xE196 },
        { 0xF719, 0xE197 },
        { 0xF71A, 0xE198 },
        { 0xF71B, 0xE199 },
        { 0xF71C, 0xE19A },
        { 0xF71D, 0xE19B },
        { 0xF71E, 0xE19C },
        { 0xF71F, 0xE19D },
        { 0xF720, 0xE19E },
        { 0xF721, 0xE19F },
        { 0xF722, 0xE1A0 },
        { 0xF723, 0xE1A1 },
        { 0xF724, 0xE1A2 },
        { 0xF725, 0xE1A3 },
        { 0xF726, 0xE1A4 },
        { 0xF727, 0xE1A5 },
        { 0xF728, 0xE1A6 },
        { 0xF729, 0xE1A7 },
        { 0xF72A, 0xE1A8 },
        { 0xF72B, 0xE1A9 },
        { 0xF72C, 0xE1AA },
        { 0xF72D, 0xE1AB },
        { 0xF72E, 0xE1AC },
        { 0xF72F, 0xE1AD },
        { 0xF730, 0xE1AE },
        { 0xF731, 0xE1AF },
        { 0xF732, 0xE1B0 },
        { 0xF733, 0xE1B1 },
        { 0xF734, 0xE1B2 },
        { 0xF735, 0xE1B3 },
        { 0xF736, 0xE1B4 },
        { 0xF737, 0xE1B5 },
        { 0xF738, 0xE1B6 },
        { 0xF739, 0xE1B7 },
        { 0xF73A, 0xE1B8 },
        { 0xF73B, 0xE1B9 },
        { 0xF73C, 0xE1BA },
        { 0xF73D, 0xE1BB },
        { 0xF73E, 0xE1BC },
        { 0xF73F, 0xE1BD },
        { 0xF740, 0xE1BE },
        { 0xF741, 0xE1BF },
        { 0xF742, 0xE1C0 },
        { 0xF743, 0xE1C1 },
        { 0xF744, 0xE1C2 },
        { 0xF745, 0xE1C3 },
        { 0xF746, 0xE1C4 },
        { 0xF747, 0xE1C5 },
        { 0xF748, 0xE1C6 },
        { 0xF749, 0xE1C7 },
        { 0xF74A, 0xE1C8 },
        { 0xF74B, 0xE1C9 },
        { 0xF74C, 0xE1CA },
        { 0xF74D, 0xE1CB },
        { 0xF74E, 0xE1CC },
        { 0xF74F, 0xE1CD },
        { 0xF750, 0xE1CE },
        { 0xF751, 0xE1CF },
        { 0xF752, 0xE1D0 },
        { 0xF753, 0xE1D1 },
        { 0xF754, 0xE1D2 },
        { 0xF755, 0xE1D3 },
        { 0xF756, 0xE1D4 },
        { 0xF757, 0xE1D5 },
        { 0xF758, 0xE1D6 },
        { 0xF759, 0xE1D7 },
        { 0xF75A, 0xE1D8 },
        { 0xF75B, 0xE1D9 },
        { 0xF75C, 0xE1DA },
        { 0xF75D, 0xE1DB },
        { 0xF75E, 0xE1DC },
        { 0xF75F, 0xE1DD },
        { 0xF760, 0xE1DE },
        { 0xF761, 0xE1DF },
        { 0xF762, 0xE1E0 },
        { 0xF763, 0xE1E1 },
        { 0xF764, 0xE1E2 },
        { 0xF765, 0xE1E3 },
        { 0xF766, 0xE1E4 },
        { 0xF767, 0xE1E5 },
        { 0xF768, 0xE1E6 },
        { 0xF769, 0xE1E7 },
        { 0xF76A, 0xE1E8 },
        { 0xF76B, 0xE1E9 },
        { 0xF76C, 0xE1EA },
        { 0xF76D, 0xE1EB },
        { 0xF76E, 0xE1EC },
        { 0xF76F, 0xE1ED },
        { 0xF770, 0xE1EE },
        { 0xF771, 0xE1EF },
        { 0xF772, 0xE1F0 },
        { 0xF773, 0xE1F1 },
        { 0xF774, 0xE1F2 },
        { 0xF775, 0xE1F3 },
        { 0xF776, 0xE1F4 },
        { 0xF777, 0xE1F5 },
        { 0xF778, 0xE1F6 },
        { 0xF779, 0xE1F7 },
        { 0xF77A, 0xE1F8 },
        { 0xF77B, 0xE1F9 },
        { 0xF77C, 0xE1FA },
        { 0xF77D, 0xE1FB },
        { 0xF77E, 0xE1FC },
        { 0xF77F, 0xE1FD },
        { 0xF780, 0xE241 },
        { 0xF781, 0xE242 },
        { 0xF782, 0xE243 },
        { 0xF783, 0xE244 },
        { 0xF784, 0xE245 },
        { 0xF785, 0xE246 },
        { 0xF786, 0xE247 },
        { 0xF787, 0xE248 },
        { 0xF788, 0xE249 },
        { 0xF789, 0xE24A },
        { 0xF78A, 0xE24B },
        { 0xF78B, 0xE24C },
        { 0xF78C, 0xE24D },
        { 0xF78D, 0xE24E },
        { 0xF78E, 0xE24F },
        { 0xF78F, 0xE250 },
        { 0xF790, 0xE251 },
        { 0xF791, 0xE252 },
        { 0xF792, 0xE253 },
        { 0xF793, 0xE254 },
        { 0xF794, 0xE255 },
        { 0xF795, 0xE256 },
        { 0xF796, 0xE257 },
        { 0xF797, 0xE258 },
        { 0xF798, 0xE259 },
        { 0xF799, 0xE25A },
        { 0xF79A, 0xE25B },
        { 0xF79B, 0xE25C },
        { 0xF79C, 0xE25D },
        { 0xF79D, 0xE25E },
        { 0xF79E, 0xE25F },
        { 0xF79F, 0xE260 },
        { 0xF7A0, 0xE261 },
        { 0xF7A1, 0xE262 },
        { 0xF7A2, 0xE263 },
        { 0xF7A3, 0xE264 },
        { 0xF7A4, 0xE265 },
        { 0xF7A5, 0xE266 },
        { 0xF7A6, 0xE267 },
        { 0xF7A7, 0xE268 },
        { 0xF7A8, 0xE269 },
        { 0xF7A9, 0xE26A },
        { 0xF7AA, 0xE26B },
        { 0xF7AB, 0xE26C },
        { 0xF7AC, 0xE26D },
        { 0xF7AD, 0xE26E },
        { 0xF7AE, 0xE26F },
        { 0xF7AF, 0xE270 },
        { 0xF7B0, 0xE271 },
        { 0xF7B1, 0xE272 },
        { 0xF7B2, 0xE273 },
        { 0xF7B3, 0xE274 },
        { 0xF7B4, 0xE275 },
        { 0xF7B5, 0xE276 },
        { 0xF7B6, 0xE277 },
        { 0xF7B7, 0xE278 },
        { 0xF7B8, 0xE279 },
        { 0xF7B9, 0xE27A },
        { 0xF7BA, 0xE27B },
        { 0xF7BB, 0xE27C },
        { 0xF7BC, 0xE27D },
        { 0xF7BD, 0xE27E },
        { 0xF7BE, 0xE27F },
        { 0xF7BF, 0xE281 },
        { 0xF7C0, 0xE282 },
        { 0xF7C1, 0xE283 },
        { 0xF7C2, 0xE284 },
        { 0xF7C3, 0xE285 },
        { 0xF7C4, 0xE286 },
        { 0xF7C5, 0xE287 },
        { 0xF7C6, 0xE288 },
        { 0xF7C7, 0xE289 },
        { 0xF7C8, 0xE28A },
        { 0xF7C9, 0xE28B },
        { 0xF7CA, 0xE28C },
        { 0xF7CB, 0xE28D },
        { 0xF7CC, 0xE28E },
        { 0xF7CD, 0xE28F },
        { 0xF7CE, 0xE290 },
        { 0xF7CF, 0xE291 },
        { 0xF7D0, 0xE292 },
        { 0xF7D1, 0xE293 },
        { 0xF7D2, 0xE294 },
        { 0xF7D3, 0xE295 },
        { 0xF7D4, 0xE296 },
        { 0xF7D5, 0xE297 },
        { 0xF7D6, 0xE298 },
        { 0xF7D7, 0xE299 },
        { 0xF7D8, 0xE29A },
        { 0xF7D9, 0xE29B },
        { 0xF7DA, 0xE29C },
        { 0xF7DB, 0xE29D },
        { 0xF7DC, 0xE29E },
        { 0xF7DD, 0xE29F },
        { 0xF7DE, 0xE2A0 },
        { 0xF7DF, 0xE2A1 },
        { 0xF7E0, 0xE2A2 },
        { 0xF7E1, 0xE2A3 },
        { 0xF7E2, 0xE2A4 },
        { 0xF7E3, 0xE2A5 },
        { 0xF7E4, 0xE2A6 },
        { 0xF7E5, 0xE2A7 },
        { 0xF7E6, 0xE2A8 },
        { 0xF7E7, 0xE2A9 },
        { 0xF7E8, 0xE2AA },
        { 0xF7E9, 0xE2AB },
        { 0xF7EA, 0xE2AC },
        { 0xF7EB, 0xE2AD },
        { 0xF7EC, 0xE2AE },
        { 0xF7ED, 0xE2AF },
        { 0xF7EE, 0xE2B0 },
        { 0xF7EF, 0xE2B1 },
        { 0xF7F0, 0xE2B2 },
        { 0xF7F1, 0xE2B3 },
        { 0xF7F2, 0xE2B4 },
        { 0xF7F3, 0xE2B5 },
        { 0xF7F4, 0xE2B6 },
        { 0xF7F5, 0xE2B7 },
        { 0xF7F6, 0xE2B8 },
        { 0xF7F7, 0xE2B9 },
        { 0xF7F8, 0xE2BA },
        { 0xF7F9, 0xE2BB },
        { 0xF7FA, 0xE2BC },
        { 0xF7FB, 0xE2BD },
        { 0xF7FC, 0xE2BE },
        { 0xF7FD, 0xE2BF },
        { 0xF7FE, 0xE2C0 },
        { 0xF7FF, 0xE2C1 },
        { 0xF800, 0xE2C2 },
        { 0xF801, 0xE2C3 },
        { 0xF802, 0xE2C4 },
        { 0xF803, 0xE2C5 },
        { 0xF804, 0xE2C6 },
        { 0xF805, 0xE2C7 },
        { 0xF806, 0xE2C8 },
        { 0xF807, 0xE2C9 },
        { 0xF808, 0xE2CA },
        { 0xF809, 0xE2CB },
        { 0xF80A, 0xE2CC },
        { 0xF80B, 0xE2CD },
        { 0xF80C, 0xE2CE },
        { 0xF80D, 0xE2CF },
        { 0xF80E, 0xE2D0 },
        { 0xF80F, 0xE2D1 },
        { 0xF810, 0xE2D2 },
        { 0xF811, 0xE2D3 },
        { 0xF812, 0xE2D4 },
        { 0xF813, 0xE2D5 },
        { 0xF814, 0xE2D6 },
        { 0xF815, 0xE2D7 },
        { 0xF816, 0xE2D8 },
        { 0xF817, 0xE2D9 },
        { 0xF818, 0xE2DA },
        { 0xF819, 0xE2DB },
        { 0xF81A, 0xE2DC },
        { 0xF81B, 0xE2DD },
        { 0xF81C, 0xE2DE },
        { 0xF81D, 0xE2DF },
        { 0xF81E, 0xE2E0 },
        { 0xF81F, 0xE2E1 },
        { 0xF820, 0xE2E2 },
        { 0xF821, 0xE2E3 },
        { 0xF822, 0xE2E4 },
        { 0xF823, 0xE2E5 },
        { 0xF824, 0xE2E6 },
        { 0xF825, 0xE2E7 },
        { 0xF826, 0xE2E8 },
        { 0xF827, 0xE2E9 },
        { 0xF828, 0xE2EA },
        { 0xF829, 0xE2EB },
        { 0xF82A, 0xE2EC },
        { 0xF82B, 0xE2ED },
        { 0xF82C, 0xE2EE },
        { 0xF82D, 0xE2EF },
        { 0xF82E, 0xE2F0 },
        { 0xF82F, 0xE2F1 },
        { 0xF830, 0xE2F2 },
        { 0xF831, 0xE2F3 },
        { 0xF832, 0xE2F4 },
        { 0xF833, 0xE2F5 },
        { 0xF834, 0xE2F6 },
        { 0xF835, 0xE2F7 },
        { 0xF836, 0xE2F8 },
        { 0xF837, 0xE2F9 },
        { 0xF838, 0xE2FA },
        { 0xF839, 0xE2FB },
        { 0xF83A, 0xE2FC },
        { 0xF83B, 0xE2FD }
};

#endif
