/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 *  under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
*/
/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 */

/* maxium mapping number from CNS11643 to UTF8 */
#define MAX_CNS1_NUM		5867	/* plane #1 */
#define MAX_CNS2_NUM		7650	/* plane #2 */
#define MAX_CNS3_NUM		6394	/* plane #3 (originally plane #14) */
#define MAX_CNS4_NUM		7286    /* plane #4 */
#define MAX_CNS5_NUM		8601    /* plane #5 */
#define MAX_CNS6_NUM		6385    /* plane #6 */
#define MAX_CNS7_NUM		6537    /* plane #7 */
#define MAX_CNS15_NUM		6721    /* plane #15 */

typedef struct cns_utf {
	unsigned long	cnscode;
	unsigned long	unicode;
} cns_utf;

/* support Unicode 3.2 and mapping source is Unihan-3.2.0.txt */
/* CNS 11643 plane #1, leave unicode (UTF8) to be -1 if no mapping available */
cns_utf	cns1_utf_tab[MAX_CNS1_NUM] = {
	{ 0x2121, 0x3000 },
	{ 0x2122, 0xff0c },
	{ 0x2123, 0x3001 },
	{ 0x2124, 0x3002 },
	{ 0x2125, 0xff0e },
	{ 0x2126, 0x30fb },
	{ 0x2127, 0xff1b },
	{ 0x2128, 0xff1a },
	{ 0x2129, 0xff1f },
	{ 0x212a, 0xff01 },
	{ 0x212b, 0xfe30 },
	{ 0x212c, 0x2026 },
	{ 0x212d, 0x2025 },
	{ 0x212e, 0xfe50 },
	{ 0x212f, 0xfe51 },
	{ 0x2130, 0xfe52 },
	{ 0x2131, 0x00b7 },
	{ 0x2132, 0xfe54 },
	{ 0x2133, 0xfe55 },
	{ 0x2134, 0xfe56 },
	{ 0x2135, 0xfe57 },
	{ 0x2136, 0xfe31 },
	{ 0x2137, 0x2014 },
	{ 0x2138, 0xfe32 },
	{ 0x2139, 0x2013 },
	{ 0x213e, 0xff08 },
	{ 0x213f, 0xff09 },
	{ 0x2140, 0xfe35 },
	{ 0x2141, 0xfe36 },
	{ 0x2142, 0xff5b },
	{ 0x2143, 0xff5d },
	{ 0x2144, 0xfe37 },
	{ 0x2145, 0xfe38 },
	{ 0x2146, 0x3014 },
	{ 0x2147, 0x3015 },
	{ 0x2148, 0xfe39 },
	{ 0x2149, 0xfe3a },
	{ 0x214a, 0x3010 },
	{ 0x214b, 0x3011 },
	{ 0x214c, 0xfe3b },
	{ 0x214d, 0xfe3c },
	{ 0x214e, 0x300a },
	{ 0x214f, 0x300b },
	{ 0x2150, 0xfe3d },
	{ 0x2151, 0xfe3e },
	{ 0x2152, 0x3008 },
	{ 0x2153, 0x3009 },
	{ 0x2154, 0xfe3f },
	{ 0x2155, 0xfe40 },
	{ 0x2156, 0x300c },
	{ 0x2157, 0x300d },
	{ 0x2158, 0xfe41 },
	{ 0x2159, 0xfe42 },
	{ 0x215a, 0x300e },
	{ 0x215b, 0x300f },
	{ 0x215c, 0xfe43 },
	{ 0x215d, 0xfe44 },
	{ 0x215e, 0xfe59 },
	{ 0x215f, 0xfe5a },
	{ 0x2160, 0xfe5b },
	{ 0x2161, 0xfe5c },
	{ 0x2162, 0xfe5d },
	{ 0x2163, 0xfe5e },
	{ 0x2164, 0x2018 },
	{ 0x2165, 0x2019 },
	{ 0x2166, 0x201c },
	{ 0x2167, 0x201d },
	{ 0x2168, 0x301d },
	{ 0x2169, 0x301e },
	{ 0x216a, 0x2032 },
	{ 0x216b, 0x2035 },
	{ 0x216c, 0xff03 },
	{ 0x216d, 0xff06 },
	{ 0x216e, 0xff0a },
	{ 0x216f, 0x203b },
	{ 0x2170, 0x00a7 },
	{ 0x2171, 0x3003 },
	{ 0x2172, 0x25cb },
	{ 0x2173, 0x25cf },
	{ 0x2174, 0x25b3 },
	{ 0x2175, 0x25b2 },
	{ 0x2176, 0x25ce },
	{ 0x2177, 0x2606 },
	{ 0x2178, 0x2605 },
	{ 0x2179, 0x25c7 },
	{ 0x217a, 0x25c6 },
	{ 0x217b, 0x25a1 },
	{ 0x217c, 0x25a0 },
	{ 0x217d, 0x25bd },
	{ 0x217e, 0x25bc },
	{ 0x2221, 0x32a3 },
	{ 0x2222, 0x2105 },
	{ 0x2223, 0x203e },
	{ 0x2225, 0xff3f },
	{ 0x2227, 0xfe49 },
	{ 0x2228, 0xfe4a },
	{ 0x2229, 0xfe4d },
	{ 0x222a, 0xfe4e },
	{ 0x222b, 0xfe4b },
	{ 0x222c, 0xfe4c },
	{ 0x222d, 0xfe5f },
	{ 0x222e, 0xfe60 },
	{ 0x222f, 0xfe61 },
	{ 0x2230, 0xff0b },
	{ 0x2231, 0xff0d },
	{ 0x2232, 0x00d7 },
	{ 0x2233, 0x00f7 },
	{ 0x2234, 0x00b1 },
	{ 0x2235, 0x221a },
	{ 0x2236, 0xff1c },
	{ 0x2237, 0xff1e },
	{ 0x2238, 0xff1d },
	{ 0x2239, 0x2266 },
	{ 0x223a, 0x2267 },
	{ 0x223b, 0x2260 },
	{ 0x223c, 0x221e },
	{ 0x223d, 0x2252 },
	{ 0x223e, 0x2261 },
	{ 0x223f, 0xfe62 },
	{ 0x2240, 0xfe63 },
	{ 0x2241, 0xfe64 },
	{ 0x2242, 0xfe66 },
	{ 0x2243, 0xfe65 },
	{ 0x2244, 0x223c },
	{ 0x2245, 0x2229 },
	{ 0x2246, 0x222a },
	{ 0x2247, 0x22a5 },
	{ 0x2248, 0x2220 },
	{ 0x2249, 0x221f },
	{ 0x224a, 0x22bf },
	{ 0x224b, 0x33d2 },
	{ 0x224c, 0x33d1 },
	{ 0x224d, 0x222b },
	{ 0x224e, 0x222e },
	{ 0x224f, 0x2235 },
	{ 0x2250, 0x2234 },
	{ 0x2251, 0x2640 },
	{ 0x2252, 0x2642 },
	{ 0x2253, 0x2641 },
	{ 0x2254, 0x2609 },
	{ 0x2255, 0x2191 },
	{ 0x2256, 0x2193 },
	{ 0x2257, 0x2192 },
	{ 0x2258, 0x2190 },
	{ 0x2259, 0x2196 },
	{ 0x225a, 0x2197 },
	{ 0x225b, 0x2199 },
	{ 0x225c, 0x2198 },
	{ 0x225d, 0x2016 },
	{ 0x225e, 0xff5c },
	{ 0x225f, 0xff0f },
	{ 0x2260, 0xff3c },
	{ 0x2261, 0x2215 },
	{ 0x2262, 0xfe68 },
	{ 0x2263, 0xff04 },
	{ 0x2264, 0xffe5 },
	{ 0x2265, 0x3012 },
	{ 0x2266, 0xffe0 },
	{ 0x2267, 0xffe1 },
	{ 0x2268, 0xff05 },
	{ 0x2269, 0xff20 },
	{ 0x226a, 0x2103 },
	{ 0x226b, 0x2109 },
	{ 0x226c, 0xfe69 },
	{ 0x226d, 0xfe6a },
	{ 0x226e, 0xfe6b },
	{ 0x226f, 0x33d5 },
	{ 0x2270, 0x339c },
	{ 0x2271, 0x339d },
	{ 0x2272, 0x339e },
	{ 0x2273, 0x33ce },
	{ 0x2274, 0x33a1 },
	{ 0x2275, 0x338e },
	{ 0x2276, 0x338f },
	{ 0x2277, 0x33c4 },
	{ 0x2278, 0x00b0 },
	{ 0x2279, 0x5159 },
	{ 0x227a, 0x515b },
	{ 0x227b, 0x515e },
	{ 0x227c, 0x515d },
	{ 0x227d, 0x5161 },
	{ 0x227e, 0x5163 },
	{ 0x2321, 0x55e7 },
	{ 0x2322, 0x74e9 },
	{ 0x2323, 0x7cce },
	{ 0x2324, 0x2581 },
	{ 0x2325, 0x2582 },
	{ 0x2326, 0x2583 },
	{ 0x2327, 0x2584 },
	{ 0x2328, 0x2585 },
	{ 0x2329, 0x2586 },
	{ 0x232a, 0x2587 },
	{ 0x232b, 0x2588 },
	{ 0x232c, 0x258f },
	{ 0x232d, 0x258e },
	{ 0x232e, 0x258d },
	{ 0x232f, 0x258c },
	{ 0x2330, 0x258b },
	{ 0x2331, 0x258a },
	{ 0x2332, 0x2589 },
	{ 0x2333, 0x253c },
	{ 0x2334, 0x2534 },
	{ 0x2335, 0x252c },
	{ 0x2336, 0x2524 },
	{ 0x2337, 0x251c },
	{ 0x2338, 0x2594 },
	{ 0x2339, 0x2500 },
	{ 0x233a, 0x2502 },
	{ 0x233b, 0x2595 },
	{ 0x233c, 0x250c },
	{ 0x233d, 0x2510 },
	{ 0x233e, 0x2514 },
	{ 0x233f, 0x2518 },
	{ 0x2340, 0x256d },
	{ 0x2341, 0x256e },
	{ 0x2342, 0x2570 },
	{ 0x2343, 0x256f },
	{ 0x2344, 0x2550 },
	{ 0x2345, 0x255e },
	{ 0x2346, 0x256a },
	{ 0x2347, 0x2561 },
	{ 0x2348, 0x25e2 },
	{ 0x2349, 0x25e3 },
	{ 0x234a, 0x25e5 },
	{ 0x234b, 0x25e4 },
	{ 0x234c, 0x2571 },
	{ 0x234d, 0x2572 },
	{ 0x234e, 0x2573 },
	{ 0x2421, 0xff10 },
	{ 0x2422, 0xff11 },
	{ 0x2423, 0xff12 },
	{ 0x2424, 0xff13 },
	{ 0x2425, 0xff14 },
	{ 0x2426, 0xff15 },
	{ 0x2427, 0xff16 },
	{ 0x2428, 0xff17 },
	{ 0x2429, 0xff18 },
	{ 0x242a, 0xff19 },
	{ 0x242b, 0x2160 },
	{ 0x242c, 0x2161 },
	{ 0x242d, 0x2162 },
	{ 0x242e, 0x2163 },
	{ 0x242f, 0x2164 },
	{ 0x2430, 0x2165 },
	{ 0x2431, 0x2166 },
	{ 0x2432, 0x2167 },
	{ 0x2433, 0x2168 },
	{ 0x2434, 0x2169 },
	{ 0x2435, 0x3021 },
	{ 0x2436, 0x3022 },
	{ 0x2437, 0x3023 },
	{ 0x2438, 0x3024 },
	{ 0x2439, 0x3025 },
	{ 0x243a, 0x3026 },
	{ 0x243b, 0x3027 },
	{ 0x243c, 0x3028 },
	{ 0x243d, 0x3029 },
	{ 0x243f, 0x5344 },
	{ 0x2441, 0xff21 },
	{ 0x2442, 0xff22 },
	{ 0x2443, 0xff23 },
	{ 0x2444, 0xff24 },
	{ 0x2445, 0xff25 },
	{ 0x2446, 0xff26 },
	{ 0x2447, 0xff27 },
	{ 0x2448, 0xff28 },
	{ 0x2449, 0xff29 },
	{ 0x244a, 0xff2a },
	{ 0x244b, 0xff2b },
	{ 0x244c, 0xff2c },
	{ 0x244d, 0xff2d },
	{ 0x244e, 0xff2e },
	{ 0x244f, 0xff2f },
	{ 0x2450, 0xff30 },
	{ 0x2451, 0xff31 },
	{ 0x2452, 0xff32 },
	{ 0x2453, 0xff33 },
	{ 0x2454, 0xff34 },
	{ 0x2455, 0xff35 },
	{ 0x2456, 0xff36 },
	{ 0x2457, 0xff37 },
	{ 0x2458, 0xff38 },
	{ 0x2459, 0xff39 },
	{ 0x245a, 0xff3a },
	{ 0x245b, 0xff41 },
	{ 0x245c, 0xff42 },
	{ 0x245d, 0xff43 },
	{ 0x245e, 0xff44 },
	{ 0x245f, 0xff45 },
	{ 0x2460, 0xff46 },
	{ 0x2461, 0xff47 },
	{ 0x2462, 0xff48 },
	{ 0x2463, 0xff49 },
	{ 0x2464, 0xff4a },
	{ 0x2465, 0xff4b },
	{ 0x2466, 0xff4c },
	{ 0x2467, 0xff4d },
	{ 0x2468, 0xff4e },
	{ 0x2469, 0xff4f },
	{ 0x246a, 0xff50 },
	{ 0x246b, 0xff51 },
	{ 0x246c, 0xff52 },
	{ 0x246d, 0xff53 },
	{ 0x246e, 0xff54 },
	{ 0x246f, 0xff55 },
	{ 0x2470, 0xff56 },
	{ 0x2471, 0xff57 },
	{ 0x2472, 0xff58 },
	{ 0x2473, 0xff59 },
	{ 0x2474, 0xff5a },
	{ 0x2475, 0x0391 },
	{ 0x2476, 0x0392 },
	{ 0x2477, 0x0393 },
	{ 0x2478, 0x0394 },
	{ 0x2479, 0x0395 },
	{ 0x247a, 0x0396 },
	{ 0x247b, 0x0397 },
	{ 0x247c, 0x0398 },
	{ 0x247d, 0x0399 },
	{ 0x247e, 0x039a },
	{ 0x2521, 0x039b },
	{ 0x2522, 0x039c },
	{ 0x2523, 0x039d },
	{ 0x2524, 0x039e },
	{ 0x2525, 0x039f },
	{ 0x2526, 0x03a0 },
	{ 0x2527, 0x03a1 },
	{ 0x2528, 0x03a3 },
	{ 0x2529, 0x03a4 },
	{ 0x252a, 0x03a5 },
	{ 0x252b, 0x03a6 },
	{ 0x252c, 0x03a7 },
	{ 0x252d, 0x03a8 },
	{ 0x252e, 0x03a9 },
	{ 0x252f, 0x03b1 },
	{ 0x2530, 0x03b2 },
	{ 0x2531, 0x03b3 },
	{ 0x2532, 0x03b4 },
	{ 0x2533, 0x03b5 },
	{ 0x2534, 0x03b6 },
	{ 0x2535, 0x03b7 },
	{ 0x2536, 0x03b8 },
	{ 0x2537, 0x03b9 },
	{ 0x2538, 0x03ba },
	{ 0x2539, 0x03bb },
	{ 0x253a, 0x03bc },
	{ 0x253b, 0x03bd },
	{ 0x253c, 0x03be },
	{ 0x253d, 0x03bf },
	{ 0x253e, 0x03c0 },
	{ 0x253f, 0x03c1 },
	{ 0x2540, 0x03c3 },
	{ 0x2541, 0x03c4 },
	{ 0x2542, 0x03c5 },
	{ 0x2543, 0x03c6 },
	{ 0x2544, 0x03c7 },
	{ 0x2545, 0x03c8 },
	{ 0x2546, 0x03c9 },
	{ 0x2547, 0x3105 },
	{ 0x2548, 0x3106 },
	{ 0x2549, 0x3107 },
	{ 0x254a, 0x3108 },
	{ 0x254b, 0x3109 },
	{ 0x254c, 0x310a },
	{ 0x254d, 0x310b },
	{ 0x254e, 0x310c },
	{ 0x254f, 0x310d },
	{ 0x2550, 0x310e },
	{ 0x2551, 0x310f },
	{ 0x2552, 0x3110 },
	{ 0x2553, 0x3111 },
	{ 0x2554, 0x3112 },
	{ 0x2555, 0x3113 },
	{ 0x2556, 0x3114 },
	{ 0x2557, 0x3115 },
	{ 0x2558, 0x3116 },
	{ 0x2559, 0x3117 },
	{ 0x255a, 0x3118 },
	{ 0x255b, 0x3119 },
	{ 0x255c, 0x311a },
	{ 0x255d, 0x311b },
	{ 0x255e, 0x311c },
	{ 0x255f, 0x311d },
	{ 0x2560, 0x311e },
	{ 0x2561, 0x311f },
	{ 0x2562, 0x3120 },
	{ 0x2563, 0x3121 },
	{ 0x2564, 0x3122 },
	{ 0x2565, 0x3123 },
	{ 0x2566, 0x3124 },
	{ 0x2567, 0x3125 },
	{ 0x2568, 0x3126 },
	{ 0x2569, 0x3127 },
	{ 0x256a, 0x3128 },
	{ 0x256b, 0x3129 },
	{ 0x256c, 0x02d9 },
	{ 0x256d, 0x02c9 },
	{ 0x256e, 0x02ca },
	{ 0x256f, 0x02c7 },
	{ 0x2570, 0x02cb },
	{ 0x2621, 0x2460 },
	{ 0x2622, 0x2461 },
	{ 0x2623, 0x2462 },
	{ 0x2624, 0x2463 },
	{ 0x2625, 0x2464 },
	{ 0x2626, 0x2465 },
	{ 0x2627, 0x2466 },
	{ 0x2628, 0x2467 },
	{ 0x2629, 0x2468 },
	{ 0x262a, 0x2469 },
	{ 0x262b, 0x2474 },
	{ 0x262c, 0x2475 },
	{ 0x262d, 0x2476 },
	{ 0x262e, 0x2477 },
	{ 0x262f, 0x2478 },
	{ 0x2630, 0x2479 },
	{ 0x2631, 0x247a },
	{ 0x2632, 0x247b },
	{ 0x2633, 0x247c },
	{ 0x2634, 0x247d },
	{ 0x2635, 0x2170 },
	{ 0x2636, 0x2171 },
	{ 0x2637, 0x2172 },
	{ 0x2638, 0x2173 },
	{ 0x2639, 0x2174 },
	{ 0x263a, 0x2175 },
	{ 0x263b, 0x2176 },
	{ 0x263c, 0x2177 },
	{ 0x263d, 0x2178 },
	{ 0x263e, 0x2179 },
        { 0x2728, 0x4ea0 },
        { 0x272f, 0x51ab },
        { 0x2734, 0x52f9 },
	{ 0x4221, 0x2400 },
	{ 0x4222, 0x2401 },
	{ 0x4223, 0x2402 },
	{ 0x4224, 0x2403 },
	{ 0x4225, 0x2404 },
	{ 0x4226, 0x2405 },
	{ 0x4227, 0x2406 },
	{ 0x4228, 0x2407 },
	{ 0x4229, 0x2408 },
	{ 0x422a, 0x2409 },
	{ 0x422b, 0x240a },
	{ 0x422c, 0x240b },
	{ 0x422d, 0x240c },
	{ 0x422e, 0x240d },
	{ 0x422f, 0x240e },
	{ 0x4230, 0x240f },
	{ 0x4231, 0x2410 },
	{ 0x4232, 0x2411 },
	{ 0x4233, 0x2412 },
	{ 0x4234, 0x2413 },
	{ 0x4235, 0x2414 },
	{ 0x4236, 0x2415 },
	{ 0x4237, 0x2416 },
	{ 0x4238, 0x2417 },
	{ 0x4239, 0x2418 },
	{ 0x423a, 0x2419 },
	{ 0x423b, 0x241a },
	{ 0x423c, 0x241b },
	{ 0x423d, 0x241c },
	{ 0x423e, 0x241d },
	{ 0x423f, 0x241e },
	{ 0x4240, 0x241f },
	{ 0x4241, 0x2421 },
	{ 0x4421, 0x4e00 },
	{ 0x4422, 0x4e59 },
	{ 0x4423, 0x4e01 },
	{ 0x4424, 0x4e03 },
	{ 0x4425, 0x4e43 },
	{ 0x4426, 0x4e5d },
	{ 0x4427, 0x4e86 },
	{ 0x4428, 0x4e8c },
	{ 0x4429, 0x4eba },
	{ 0x442a, 0x513f },
	{ 0x442b, 0x5165 },
	{ 0x442c, 0x516b },
	{ 0x442d, 0x51e0 },
	{ 0x442e, 0x5200 },
	{ 0x442f, 0x5201 },
	{ 0x4430, 0x529b },
	{ 0x4431, 0x5315 },
	{ 0x4432, 0x5341 },
	{ 0x4433, 0x535c },
	{ 0x4434, 0x53c8 },
	{ 0x4435, 0x4e09 },
	{ 0x4436, 0x4e0b },
	{ 0x4437, 0x4e08 },
	{ 0x4438, 0x4e0a },
	{ 0x4439, 0x4e2b },
	{ 0x443a, 0x4e38 },
	{ 0x443b, 0x51e1 },
	{ 0x443c, 0x4e45 },
	{ 0x443d, 0x4e48 },
	{ 0x443e, 0x4e5f },
	{ 0x443f, 0x4e5e },
	{ 0x4440, 0x4e8e },
	{ 0x4441, 0x4ea1 },
	{ 0x4442, 0x5140 },
	{ 0x4443, 0x5203 },
	{ 0x4444, 0x52fa },
	{ 0x4445, 0x5343 },
	{ 0x4446, 0x53c9 },
	{ 0x4447, 0x53e3 },
	{ 0x4448, 0x571f },
	{ 0x4449, 0x58eb },
	{ 0x444a, 0x5915 },
	{ 0x444b, 0x5927 },
	{ 0x444c, 0x5973 },
	{ 0x444d, 0x5b50 },
	{ 0x444e, 0x5b51 },
	{ 0x444f, 0x5b53 },
	{ 0x4450, 0x5bf8 },
	{ 0x4451, 0x5c0f },
	{ 0x4452, 0x5c22 },
	{ 0x4453, 0x5c38 },
	{ 0x4454, 0x5c71 },
	{ 0x4455, 0x5ddd },
	{ 0x4456, 0x5de5 },
	{ 0x4457, 0x5df1 },
	{ 0x4458, 0x5df2 },
	{ 0x4459, 0x5df3 },
	{ 0x445a, 0x5dfe },
	{ 0x445b, 0x5e72 },
	{ 0x445c, 0x5efe },
	{ 0x445d, 0x5f0b },
	{ 0x445e, 0x5f13 },
	{ 0x445f, 0x624d },
	{ 0x4460, 0x4e11 },
	{ 0x4461, 0x4e10 },
	{ 0x4462, 0x4e0d },
	{ 0x4463, 0x4e2d },
	{ 0x4464, 0x4e30 },
	{ 0x4465, 0x4e39 },
	{ 0x4466, 0x4e4b },
	{ 0x4467, 0x5c39 },
	{ 0x4468, 0x4e88 },
	{ 0x4469, 0x4e91 },
	{ 0x446a, 0x4e95 },
	{ 0x446b, 0x4e92 },
	{ 0x446c, 0x4e94 },
	{ 0x446d, 0x4ea2 },
	{ 0x446e, 0x4ec1 },
	{ 0x446f, 0x4ec0 },
	{ 0x4470, 0x4ec3 },
	{ 0x4471, 0x4ec6 },
	{ 0x4472, 0x4ec7 },
	{ 0x4473, 0x4ecd },
	{ 0x4474, 0x4eca },
	{ 0x4475, 0x4ecb },
	{ 0x4476, 0x4ec4 },
	{ 0x4477, 0x5143 },
	{ 0x4478, 0x5141 },
	{ 0x4479, 0x5167 },
	{ 0x447a, 0x516d },
	{ 0x447b, 0x516e },
	{ 0x447c, 0x516c },
	{ 0x447d, 0x5197 },
	{ 0x447e, 0x51f6 },
	{ 0x4521, 0x5206 },
	{ 0x4522, 0x5207 },
	{ 0x4523, 0x5208 },
	{ 0x4524, 0x52fb },
	{ 0x4525, 0x52fe },
	{ 0x4526, 0x52ff },
	{ 0x4527, 0x5316 },
	{ 0x4528, 0x5339 },
	{ 0x4529, 0x5348 },
	{ 0x452a, 0x5347 },
	{ 0x452b, 0x5345 },
	{ 0x452c, 0x535e },
	{ 0x452d, 0x5384 },
	{ 0x452e, 0x53cb },
	{ 0x452f, 0x53ca },
	{ 0x4530, 0x53cd },
	{ 0x4531, 0x58ec },
	{ 0x4532, 0x5929 },
	{ 0x4533, 0x592b },
	{ 0x4534, 0x592a },
	{ 0x4535, 0x592d },
	{ 0x4536, 0x5b54 },
	{ 0x4537, 0x5c11 },
	{ 0x4538, 0x5c24 },
	{ 0x4539, 0x5c3a },
	{ 0x453a, 0x5c6f },
	{ 0x453b, 0x5df4 },
	{ 0x453c, 0x5e7b },
	{ 0x453d, 0x5eff },
	{ 0x453e, 0x5f14 },
	{ 0x453f, 0x5f15 },
	{ 0x4540, 0x5fc3 },
	{ 0x4541, 0x6208 },
	{ 0x4542, 0x6236 },
	{ 0x4543, 0x624b },
	{ 0x4544, 0x624e },
	{ 0x4545, 0x652f },
	{ 0x4546, 0x6587 },
	{ 0x4547, 0x6597 },
	{ 0x4548, 0x65a4 },
	{ 0x4549, 0x65b9 },
	{ 0x454a, 0x65e5 },
	{ 0x454b, 0x66f0 },
	{ 0x454c, 0x6708 },
	{ 0x454d, 0x6728 },
	{ 0x454e, 0x6b20 },
	{ 0x454f, 0x6b62 },
	{ 0x4550, 0x6b79 },
	{ 0x4551, 0x6bcb },
	{ 0x4552, 0x6bd4 },
	{ 0x4553, 0x6bdb },
	{ 0x4554, 0x6c0f },
	{ 0x4555, 0x6c34 },
	{ 0x4556, 0x706b },
	{ 0x4557, 0x722a },
	{ 0x4558, 0x7236 },
	{ 0x4559, 0x723b },
	{ 0x455a, 0x7247 },
	{ 0x455b, 0x7259 },
	{ 0x455c, 0x725b },
	{ 0x455d, 0x72ac },
	{ 0x455e, 0x738b },
	{ 0x455f, 0x4e19 },
	{ 0x4560, 0x4e16 },
	{ 0x4561, 0x4e15 },
	{ 0x4562, 0x4e14 },
	{ 0x4563, 0x4e18 },
	{ 0x4564, 0x4e3b },
	{ 0x4565, 0x4e4d },
	{ 0x4566, 0x4e4f },
	{ 0x4567, 0x4e4e },
	{ 0x4568, 0x4ee5 },
	{ 0x4569, 0x4ed8 },
	{ 0x456a, 0x4ed4 },
	{ 0x456b, 0x4ed5 },
	{ 0x456c, 0x4ed6 },
	{ 0x456d, 0x4ed7 },
	{ 0x456e, 0x4ee3 },
	{ 0x456f, 0x4ee4 },
	{ 0x4570, 0x4ed9 },
	{ 0x4571, 0x4ede },
	{ 0x4572, 0x5145 },
	{ 0x4573, 0x5144 },
	{ 0x4574, 0x5189 },
	{ 0x4575, 0x518a },
	{ 0x4576, 0x51ac },
	{ 0x4577, 0x51f9 },
	{ 0x4578, 0x51fa },
	{ 0x4579, 0x51f8 },
	{ 0x457a, 0x520a },
	{ 0x457b, 0x52a0 },
	{ 0x457c, 0x529f },
	{ 0x457d, 0x5305 },
	{ 0x457e, 0x5306 },
	{ 0x4621, 0x5317 },
	{ 0x4622, 0x531d },
	{ 0x4623, 0x4edf },
	{ 0x4624, 0x534a },
	{ 0x4625, 0x5349 },
	{ 0x4626, 0x5361 },
	{ 0x4627, 0x5360 },
	{ 0x4628, 0x536f },
	{ 0x4629, 0x536e },
	{ 0x462a, 0x53bb },
	{ 0x462b, 0x53ef },
	{ 0x462c, 0x53e4 },
	{ 0x462d, 0x53f3 },
	{ 0x462e, 0x53ec },
	{ 0x462f, 0x53ee },
	{ 0x4630, 0x53e9 },
	{ 0x4631, 0x53e8 },
	{ 0x4632, 0x53fc },
	{ 0x4633, 0x53f8 },
	{ 0x4634, 0x53f5 },
	{ 0x4635, 0x53eb },
	{ 0x4636, 0x53e6 },
	{ 0x4637, 0x53ea },
	{ 0x4638, 0x53f2 },
	{ 0x4639, 0x53f1 },
	{ 0x463a, 0x53f0 },
	{ 0x463b, 0x53e5 },
	{ 0x463c, 0x53ed },
	{ 0x463d, 0x53fb },
	{ 0x463e, 0x56db },
	{ 0x463f, 0x56da },
	{ 0x4640, 0x5916 },
	{ 0x4641, 0x592e },
	{ 0x4642, 0x5931 },
	{ 0x4643, 0x5974 },
	{ 0x4644, 0x5976 },
	{ 0x4645, 0x5b55 },
	{ 0x4646, 0x5b83 },
	{ 0x4647, 0x5c3c },
	{ 0x4648, 0x5de8 },
	{ 0x4649, 0x5de7 },
	{ 0x464a, 0x5de6 },
	{ 0x464b, 0x5e02 },
	{ 0x464c, 0x5e03 },
	{ 0x464d, 0x5e73 },
	{ 0x464e, 0x5e7c },
	{ 0x464f, 0x5f01 },
	{ 0x4650, 0x5f18 },
	{ 0x4651, 0x5f17 },
	{ 0x4652, 0x5fc5 },
	{ 0x4653, 0x620a },
	{ 0x4654, 0x6253 },
	{ 0x4655, 0x6254 },
	{ 0x4656, 0x6252 },
	{ 0x4657, 0x6251 },
	{ 0x4658, 0x65a5 },
	{ 0x4659, 0x65e6 },
	{ 0x465a, 0x672e },
	{ 0x465b, 0x672c },
	{ 0x465c, 0x672a },
	{ 0x465d, 0x672b },
	{ 0x465e, 0x672d },
	{ 0x465f, 0x6b63 },
	{ 0x4660, 0x6bcd },
	{ 0x4661, 0x6c11 },
	{ 0x4662, 0x6c10 },
	{ 0x4663, 0x6c38 },
	{ 0x4664, 0x6c41 },
	{ 0x4665, 0x6c40 },
	{ 0x4666, 0x6c3e },
	{ 0x4667, 0x72af },
	{ 0x4668, 0x7384 },
	{ 0x4669, 0x7389 },
	{ 0x466a, 0x74dc },
	{ 0x466b, 0x74e6 },
	{ 0x466c, 0x7518 },
	{ 0x466d, 0x751f },
	{ 0x466e, 0x7528 },
	{ 0x466f, 0x7529 },
	{ 0x4670, 0x7530 },
	{ 0x4671, 0x7531 },
	{ 0x4672, 0x7532 },
	{ 0x4673, 0x7533 },
	{ 0x4674, 0x758b },
	{ 0x4675, 0x767d },
	{ 0x4676, 0x76ae },
	{ 0x4677, 0x76bf },
	{ 0x4678, 0x76ee },
	{ 0x4679, 0x77db },
	{ 0x467a, 0x77e2 },
	{ 0x467b, 0x77f3 },
	{ 0x467c, 0x793a },
	{ 0x467d, 0x79be },
	{ 0x467e, 0x7a74 },
	{ 0x4721, 0x7acb },
	{ 0x4722, 0x4e1e },
	{ 0x4723, 0x4e1f },
	{ 0x4724, 0x4e52 },
	{ 0x4725, 0x4e53 },
	{ 0x4726, 0x4e69 },
	{ 0x4727, 0x4e99 },
	{ 0x4728, 0x4ea4 },
	{ 0x4729, 0x4ea6 },
	{ 0x472a, 0x4ea5 },
	{ 0x472b, 0x4eff },
	{ 0x472c, 0x4f09 },
	{ 0x472d, 0x4f19 },
	{ 0x472e, 0x4f0a },
	{ 0x472f, 0x4f15 },
	{ 0x4730, 0x4f0d },
	{ 0x4731, 0x4f10 },
	{ 0x4732, 0x4f11 },
	{ 0x4733, 0x4f0f },
	{ 0x4734, 0x4ef2 },
	{ 0x4735, 0x4ef6 },
	{ 0x4736, 0x4efb },
	{ 0x4737, 0x4ef0 },
	{ 0x4738, 0x4ef3 },
	{ 0x4739, 0x4efd },
	{ 0x473a, 0x4f01 },
	{ 0x473b, 0x4f0b },
	{ 0x473c, 0x5149 },
	{ 0x473d, 0x5147 },
	{ 0x473e, 0x5146 },
	{ 0x473f, 0x5148 },
	{ 0x4740, 0x5168 },
	{ 0x4741, 0x5171 },
	{ 0x4742, 0x518d },
	{ 0x4743, 0x51b0 },
	{ 0x4744, 0x5217 },
	{ 0x4745, 0x5211 },
	{ 0x4746, 0x5212 },
	{ 0x4747, 0x520e },
	{ 0x4748, 0x5216 },
	{ 0x4749, 0x52a3 },
	{ 0x474a, 0x5308 },
	{ 0x474b, 0x5321 },
	{ 0x474c, 0x5320 },
	{ 0x474d, 0x5370 },
	{ 0x474e, 0x5371 },
	{ 0x474f, 0x5409 },
	{ 0x4750, 0x540f },
	{ 0x4751, 0x540c },
	{ 0x4752, 0x540a },
	{ 0x4753, 0x5410 },
	{ 0x4754, 0x5401 },
	{ 0x4755, 0x540b },
	{ 0x4756, 0x5404 },
	{ 0x4757, 0x5411 },
	{ 0x4758, 0x540d },
	{ 0x4759, 0x5408 },
	{ 0x475a, 0x5403 },
	{ 0x475b, 0x540e },
	{ 0x475c, 0x5406 },
	{ 0x475d, 0x5412 },
	{ 0x475e, 0x56e0 },
	{ 0x475f, 0x56de },
	{ 0x4760, 0x56dd },
	{ 0x4761, 0x5733 },
	{ 0x4762, 0x5730 },
	{ 0x4763, 0x5728 },
	{ 0x4764, 0x572d },
	{ 0x4765, 0x572c },
	{ 0x4766, 0x572f },
	{ 0x4767, 0x5729 },
	{ 0x4768, 0x5919 },
	{ 0x4769, 0x591a },
	{ 0x476a, 0x5937 },
	{ 0x476b, 0x5938 },
	{ 0x476c, 0x5984 },
	{ 0x476d, 0x5978 },
	{ 0x476e, 0x5983 },
	{ 0x476f, 0x597d },
	{ 0x4770, 0x5979 },
	{ 0x4771, 0x5982 },
	{ 0x4772, 0x5981 },
	{ 0x4773, 0x5b57 },
	{ 0x4774, 0x5b58 },
	{ 0x4775, 0x5b87 },
	{ 0x4776, 0x5b88 },
	{ 0x4777, 0x5b85 },
	{ 0x4778, 0x5b89 },
	{ 0x4779, 0x5bfa },
	{ 0x477a, 0x5c16 },
	{ 0x477b, 0x5c79 },
	{ 0x477c, 0x5dde },
	{ 0x477d, 0x5e06 },
	{ 0x477e, 0x5e76 },
	{ 0x4821, 0x5e74 },
	{ 0x4822, 0x5f0f },
	{ 0x4823, 0x5f1b },
	{ 0x4824, 0x5fd9 },
	{ 0x4825, 0x5fd6 },
	{ 0x4826, 0x620e },
	{ 0x4827, 0x620c },
	{ 0x4828, 0x620d },
	{ 0x4829, 0x6210 },
	{ 0x482a, 0x6263 },
	{ 0x482b, 0x625b },
	{ 0x482c, 0x6258 },
	{ 0x482d, 0x6536 },
	{ 0x482e, 0x65e9 },
	{ 0x482f, 0x65e8 },
	{ 0x4830, 0x65ec },
	{ 0x4831, 0x65ed },
	{ 0x4832, 0x66f2 },
	{ 0x4833, 0x66f3 },
	{ 0x4834, 0x6709 },
	{ 0x4835, 0x673d },
	{ 0x4836, 0x6734 },
	{ 0x4837, 0x6731 },
	{ 0x4838, 0x6735 },
	{ 0x4839, 0x6b21 },
	{ 0x483a, 0x6b64 },
	{ 0x483b, 0x6b7b },
	{ 0x483c, 0x6c16 },
	{ 0x483d, 0x6c5d },
	{ 0x483e, 0x6c57 },
	{ 0x483f, 0x6c59 },
	{ 0x4840, 0x6c5f },
	{ 0x4841, 0x6c60 },
	{ 0x4842, 0x6c50 },
	{ 0x4843, 0x6c55 },
	{ 0x4844, 0x6c61 },
	{ 0x4845, 0x6c5b },
	{ 0x4846, 0x6c4d },
	{ 0x4847, 0x6c4e },
	{ 0x4848, 0x7070 },
	{ 0x4849, 0x725f },
	{ 0x484a, 0x725d },
	{ 0x484b, 0x767e },
	{ 0x484c, 0x7af9 },
	{ 0x484d, 0x7c73 },
	{ 0x484e, 0x7cf8 },
	{ 0x484f, 0x7f36 },
	{ 0x4850, 0x7f8a },
	{ 0x4851, 0x7fbd },
	{ 0x4852, 0x8001 },
	{ 0x4853, 0x8003 },
	{ 0x4854, 0x800c },
	{ 0x4855, 0x8012 },
	{ 0x4856, 0x8033 },
	{ 0x4857, 0x807f },
	{ 0x4858, 0x8089 },
	{ 0x4859, 0x808b },
	{ 0x485a, 0x808c },
	{ 0x485b, 0x81e3 },
	{ 0x485c, 0x81ea },
	{ 0x485d, 0x81f3 },
	{ 0x485e, 0x81fc },
	{ 0x485f, 0x820c },
	{ 0x4860, 0x821b },
	{ 0x4861, 0x821f },
	{ 0x4862, 0x826e },
	{ 0x4863, 0x8272 },
	{ 0x4864, 0x827e },
	{ 0x4865, 0x866b },
	{ 0x4866, 0x8840 },
	{ 0x4867, 0x884c },
	{ 0x4868, 0x8863 },
	{ 0x4869, 0x897f },
	{ 0x486a, 0x9621 },
	{ 0x486b, 0x4e32 },
	{ 0x486c, 0x4ea8 },
	{ 0x486d, 0x4f4d },
	{ 0x486e, 0x4f4f },
	{ 0x486f, 0x4f47 },
	{ 0x4870, 0x4f57 },
	{ 0x4871, 0x4f5e },
	{ 0x4872, 0x4f34 },
	{ 0x4873, 0x4f5b },
	{ 0x4874, 0x4f55 },
	{ 0x4875, 0x4f30 },
	{ 0x4876, 0x4f50 },
	{ 0x4877, 0x4f51 },
	{ 0x4878, 0x4f3d },
	{ 0x4879, 0x4f3a },
	{ 0x487a, 0x4f38 },
	{ 0x487b, 0x4f43 },
	{ 0x487c, 0x4f54 },
	{ 0x487d, 0x4f3c },
	{ 0x487e, 0x4f46 },
	{ 0x4921, 0x4f63 },
	{ 0x4922, 0x4f5c },
	{ 0x4923, 0x4f60 },
	{ 0x4924, 0x4f2f },
	{ 0x4925, 0x4f4e },
	{ 0x4926, 0x4f36 },
	{ 0x4927, 0x4f59 },
	{ 0x4928, 0x4f5d },
	{ 0x4929, 0x4f48 },
	{ 0x492a, 0x4f5a },
	{ 0x492b, 0x514c },
	{ 0x492c, 0x514b },
	{ 0x492d, 0x514d },
	{ 0x492e, 0x5175 },
	{ 0x492f, 0x51b6 },
	{ 0x4930, 0x51b7 },
	{ 0x4931, 0x5225 },
	{ 0x4932, 0x5224 },
	{ 0x4933, 0x5229 },
	{ 0x4934, 0x522a },
	{ 0x4935, 0x5228 },
	{ 0x4936, 0x52ab },
	{ 0x4937, 0x52a9 },
	{ 0x4938, 0x52aa },
	{ 0x4939, 0x52ac },
	{ 0x493a, 0x5323 },
	{ 0x493b, 0x5373 },
	{ 0x493c, 0x5375 },
	{ 0x493d, 0x541d },
	{ 0x493e, 0x542d },
	{ 0x493f, 0x541e },
	{ 0x4940, 0x543e },
	{ 0x4941, 0x5426 },
	{ 0x4942, 0x544e },
	{ 0x4943, 0x5427 },
	{ 0x4944, 0x5446 },
	{ 0x4945, 0x5443 },
	{ 0x4946, 0x5433 },
	{ 0x4947, 0x5448 },
	{ 0x4948, 0x5442 },
	{ 0x4949, 0x541b },
	{ 0x494a, 0x5429 },
	{ 0x494b, 0x544a },
	{ 0x494c, 0x5439 },
	{ 0x494d, 0x543b },
	{ 0x494e, 0x5438 },
	{ 0x494f, 0x542e },
	{ 0x4950, 0x5435 },
	{ 0x4951, 0x5436 },
	{ 0x4952, 0x5420 },
	{ 0x4953, 0x543c },
	{ 0x4954, 0x5440 },
	{ 0x4955, 0x5431 },
	{ 0x4956, 0x542b },
	{ 0x4957, 0x541f },
	{ 0x4958, 0x542c },
	{ 0x4959, 0x56ea },
	{ 0x495a, 0x56f0 },
	{ 0x495b, 0x56e4 },
	{ 0x495c, 0x56eb },
	{ 0x495d, 0x574a },
	{ 0x495e, 0x5751 },
	{ 0x495f, 0x5740 },
	{ 0x4960, 0x574d },
	{ 0x4961, 0x5747 },
	{ 0x4962, 0x574e },
	{ 0x4963, 0x573e },
	{ 0x4964, 0x5750 },
	{ 0x4965, 0x574f },
	{ 0x4966, 0x573b },
	{ 0x4967, 0x58ef },
	{ 0x4968, 0x593e },
	{ 0x4969, 0x599d },
	{ 0x496a, 0x5992 },
	{ 0x496b, 0x59a8 },
	{ 0x496c, 0x599e },
	{ 0x496d, 0x59a3 },
	{ 0x496e, 0x5999 },
	{ 0x496f, 0x5996 },
	{ 0x4970, 0x598d },
	{ 0x4971, 0x59a4 },
	{ 0x4972, 0x5993 },
	{ 0x4973, 0x598a },
	{ 0x4974, 0x59a5 },
	{ 0x4975, 0x5b5d },
	{ 0x4976, 0x5b5c },
	{ 0x4977, 0x5b5a },
	{ 0x4978, 0x5b5b },
	{ 0x4979, 0x5b8c },
	{ 0x497a, 0x5b8b },
	{ 0x497b, 0x5b8f },
	{ 0x497c, 0x5c2c },
	{ 0x497d, 0x5c40 },
	{ 0x497e, 0x5c41 },
	{ 0x4a21, 0x5c3f },
	{ 0x4a22, 0x5c3e },
	{ 0x4a23, 0x5c90 },
	{ 0x4a24, 0x5c91 },
	{ 0x4a25, 0x5c94 },
	{ 0x4a26, 0x5c8c },
	{ 0x4a27, 0x5deb },
	{ 0x4a28, 0x5e0c },
	{ 0x4a29, 0x5e8f },
	{ 0x4a2a, 0x5e87 },
	{ 0x4a2b, 0x5e8a },
	{ 0x4a2c, 0x5ef7 },
	{ 0x4a2d, 0x5f04 },
	{ 0x4a2e, 0x5f1f },
	{ 0x4a2f, 0x5f64 },
	{ 0x4a30, 0x5f62 },
	{ 0x4a31, 0x5f77 },
	{ 0x4a32, 0x5f79 },
	{ 0x4a33, 0x5fd8 },
	{ 0x4a34, 0x5fcc },
	{ 0x4a35, 0x5fd7 },
	{ 0x4a36, 0x5fcd },
	{ 0x4a37, 0x5ff1 },
	{ 0x4a38, 0x5feb },
	{ 0x4a39, 0x5ff8 },
	{ 0x4a3a, 0x5fea },
	{ 0x4a3b, 0x6212 },
	{ 0x4a3c, 0x6211 },
	{ 0x4a3d, 0x6284 },
	{ 0x4a3e, 0x6297 },
	{ 0x4a3f, 0x6296 },
	{ 0x4a40, 0x6280 },
	{ 0x4a41, 0x6276 },
	{ 0x4a42, 0x6289 },
	{ 0x4a43, 0x626d },
	{ 0x4a44, 0x628a },
	{ 0x4a45, 0x627c },
	{ 0x4a46, 0x627e },
	{ 0x4a47, 0x6279 },
	{ 0x4a48, 0x6273 },
	{ 0x4a49, 0x6292 },
	{ 0x4a4a, 0x626f },
	{ 0x4a4b, 0x6298 },
	{ 0x4a4c, 0x626e },
	{ 0x4a4d, 0x6295 },
	{ 0x4a4e, 0x6293 },
	{ 0x4a4f, 0x6291 },
	{ 0x4a50, 0x6286 },
	{ 0x4a51, 0x6539 },
	{ 0x4a52, 0x653b },
	{ 0x4a53, 0x6538 },
	{ 0x4a54, 0x65f1 },
	{ 0x4a55, 0x66f4 },
	{ 0x4a56, 0x675f },
	{ 0x4a57, 0x674e },
	{ 0x4a58, 0x674f },
	{ 0x4a59, 0x6750 },
	{ 0x4a5a, 0x6751 },
	{ 0x4a5b, 0x675c },
	{ 0x4a5c, 0x6756 },
	{ 0x4a5d, 0x675e },
	{ 0x4a5e, 0x6749 },
	{ 0x4a5f, 0x6746 },
	{ 0x4a60, 0x6760 },
	{ 0x4a61, 0x6753 },
	{ 0x4a62, 0x6757 },
	{ 0x4a63, 0x6b65 },
	{ 0x4a64, 0x6bcf },
	{ 0x4a65, 0x6c42 },
	{ 0x4a66, 0x6c5e },
	{ 0x4a67, 0x6c99 },
	{ 0x4a68, 0x6c81 },
	{ 0x4a69, 0x6c88 },
	{ 0x4a6a, 0x6c89 },
	{ 0x4a6b, 0x6c85 },
	{ 0x4a6c, 0x6c9b },
	{ 0x4a6d, 0x6c6a },
	{ 0x4a6e, 0x6c7a },
	{ 0x4a6f, 0x6c90 },
	{ 0x4a70, 0x6c70 },
	{ 0x4a71, 0x6c8c },
	{ 0x4a72, 0x6c68 },
	{ 0x4a73, 0x6c96 },
	{ 0x4a74, 0x6c92 },
	{ 0x4a75, 0x6c7d },
	{ 0x4a76, 0x6c83 },
	{ 0x4a77, 0x6c72 },
	{ 0x4a78, 0x6c7e },
	{ 0x4a79, 0x6c74 },
	{ 0x4a7a, 0x6c86 },
	{ 0x4a7b, 0x6c76 },
	{ 0x4a7c, 0x6c8d },
	{ 0x4a7d, 0x6c94 },
	{ 0x4a7e, 0x6c98 },
	{ 0x4b21, 0x6c82 },
	{ 0x4b22, 0x7076 },
	{ 0x4b23, 0x707c },
	{ 0x4b24, 0x707d },
	{ 0x4b25, 0x7078 },
	{ 0x4b26, 0x7262 },
	{ 0x4b27, 0x7261 },
	{ 0x4b28, 0x7260 },
	{ 0x4b29, 0x72c4 },
	{ 0x4b2a, 0x72c2 },
	{ 0x4b2b, 0x7396 },
	{ 0x4b2c, 0x752c },
	{ 0x4b2d, 0x752b },
	{ 0x4b2e, 0x7537 },
	{ 0x4b2f, 0x7538 },
	{ 0x4b30, 0x7682 },
	{ 0x4b31, 0x76ef },
	{ 0x4b32, 0x77e3 },
	{ 0x4b33, 0x79c1 },
	{ 0x4b34, 0x79c0 },
	{ 0x4b35, 0x79bf },
	{ 0x4b36, 0x7a76 },
	{ 0x4b37, 0x7cfb },
	{ 0x4b38, 0x7f55 },
	{ 0x4b39, 0x8096 },
	{ 0x4b3a, 0x8093 },
	{ 0x4b3b, 0x809d },
	{ 0x4b3c, 0x8098 },
	{ 0x4b3d, 0x809b },
	{ 0x4b3e, 0x809a },
	{ 0x4b3f, 0x80b2 },
	{ 0x4b40, 0x826f },
	{ 0x4b41, 0x8292 },
	{ 0x4b42, 0x828b },
	{ 0x4b43, 0x828d },
	{ 0x4b44, 0x898b },
	{ 0x4b45, 0x89d2 },
	{ 0x4b46, 0x8a00 },
	{ 0x4b47, 0x8c37 },
	{ 0x4b48, 0x8c46 },
	{ 0x4b49, 0x8c55 },
	{ 0x4b4a, 0x8c9d },
	{ 0x4b4b, 0x8d64 },
	{ 0x4b4c, 0x8d70 },
	{ 0x4b4d, 0x8db3 },
	{ 0x4b4e, 0x8eab },
	{ 0x4b4f, 0x8eca },
	{ 0x4b50, 0x8f9b },
	{ 0x4b51, 0x8fb0 },
	{ 0x4b52, 0x8fc2 },
	{ 0x4b53, 0x8fc6 },
	{ 0x4b54, 0x8fc5 },
	{ 0x4b55, 0x8fc4 },
	{ 0x4b56, 0x5de1 },
	{ 0x4b57, 0x9091 },
	{ 0x4b58, 0x90a2 },
	{ 0x4b59, 0x90aa },
	{ 0x4b5a, 0x90a6 },
	{ 0x4b5b, 0x90a3 },
	{ 0x4b5c, 0x9149 },
	{ 0x4b5d, 0x91c6 },
	{ 0x4b5e, 0x91cc },
	{ 0x4b5f, 0x9632 },
	{ 0x4b60, 0x962e },
	{ 0x4b61, 0x9631 },
	{ 0x4b62, 0x962a },
	{ 0x4b63, 0x962c },
	{ 0x4b64, 0x4e26 },
	{ 0x4b65, 0x4e56 },
	{ 0x4b66, 0x4e73 },
	{ 0x4b67, 0x4e8b },
	{ 0x4b68, 0x4e9b },
	{ 0x4b69, 0x4e9e },
	{ 0x4b6a, 0x4eab },
	{ 0x4b6b, 0x4eac },
	{ 0x4b6c, 0x4f6f },
	{ 0x4b6d, 0x4f9d },
	{ 0x4b6e, 0x4f8d },
	{ 0x4b6f, 0x4f73 },
	{ 0x4b70, 0x4f7f },
	{ 0x4b71, 0x4f6c },
	{ 0x4b72, 0x4f9b },
	{ 0x4b73, 0x4f8b },
	{ 0x4b74, 0x4f86 },
	{ 0x4b75, 0x4f83 },
	{ 0x4b76, 0x4f70 },
	{ 0x4b77, 0x4f75 },
	{ 0x4b78, 0x4f88 },
	{ 0x4b79, 0x4f69 },
	{ 0x4b7a, 0x4f7b },
	{ 0x4b7b, 0x4f96 },
	{ 0x4b7c, 0x4f7e },
	{ 0x4b7d, 0x4f8f },
	{ 0x4b7e, 0x4f91 },
	{ 0x4c21, 0x4f7a },
	{ 0x4c22, 0x5154 },
	{ 0x4c23, 0x5152 },
	{ 0x4c24, 0x5155 },
	{ 0x4c25, 0x5169 },
	{ 0x4c26, 0x5177 },
	{ 0x4c27, 0x5176 },
	{ 0x4c28, 0x5178 },
	{ 0x4c29, 0x51bd },
	{ 0x4c2a, 0x51fd },
	{ 0x4c2b, 0x523b },
	{ 0x4c2c, 0x5238 },
	{ 0x4c2d, 0x5237 },
	{ 0x4c2e, 0x523a },
	{ 0x4c2f, 0x5230 },
	{ 0x4c30, 0x522e },
	{ 0x4c31, 0x5236 },
	{ 0x4c32, 0x5241 },
	{ 0x4c33, 0x52be },
	{ 0x4c34, 0x52bb },
	{ 0x4c35, 0x5352 },
	{ 0x4c36, 0x5354 },
	{ 0x4c37, 0x5353 },
	{ 0x4c38, 0x5351 },
	{ 0x4c39, 0x5366 },
	{ 0x4c3a, 0x5377 },
	{ 0x4c3b, 0x5378 },
	{ 0x4c3c, 0x5379 },
	{ 0x4c3d, 0x53d6 },
	{ 0x4c3e, 0x53d4 },
	{ 0x4c3f, 0x53d7 },
	{ 0x4c40, 0x5473 },
	{ 0x4c41, 0x5475 },
	{ 0x4c42, 0x5496 },
	{ 0x4c43, 0x5478 },
	{ 0x4c44, 0x5495 },
	{ 0x4c45, 0x5480 },
	{ 0x4c46, 0x547b },
	{ 0x4c47, 0x5477 },
	{ 0x4c48, 0x5484 },
	{ 0x4c49, 0x5492 },
	{ 0x4c4a, 0x5486 },
	{ 0x4c4b, 0x547c },
	{ 0x4c4c, 0x5490 },
	{ 0x4c4d, 0x5471 },
	{ 0x4c4e, 0x5476 },
	{ 0x4c4f, 0x548c },
	{ 0x4c50, 0x549a },
	{ 0x4c51, 0x5462 },
	{ 0x4c52, 0x5468 },
	{ 0x4c53, 0x548b },
	{ 0x4c54, 0x547d },
	{ 0x4c55, 0x548e },
	{ 0x4c56, 0x56fa },
	{ 0x4c57, 0x5783 },
	{ 0x4c58, 0x5777 },
	{ 0x4c59, 0x576a },
	{ 0x4c5a, 0x5769 },
	{ 0x4c5b, 0x5761 },
	{ 0x4c5c, 0x5766 },
	{ 0x4c5d, 0x5764 },
	{ 0x4c5e, 0x577c },
	{ 0x4c5f, 0x591c },
	{ 0x4c60, 0x5949 },
	{ 0x4c61, 0x5947 },
	{ 0x4c62, 0x5948 },
	{ 0x4c63, 0x5944 },
	{ 0x4c64, 0x5954 },
	{ 0x4c65, 0x59be },
	{ 0x4c66, 0x59bb },
	{ 0x4c67, 0x59d4 },
	{ 0x4c68, 0x59b9 },
	{ 0x4c69, 0x59ae },
	{ 0x4c6a, 0x59d1 },
	{ 0x4c6b, 0x59c6 },
	{ 0x4c6c, 0x59d0 },
	{ 0x4c6d, 0x59cd },
	{ 0x4c6e, 0x59cb },
	{ 0x4c6f, 0x59d3 },
	{ 0x4c70, 0x59ca },
	{ 0x4c71, 0x59af },
	{ 0x4c72, 0x59b3 },
	{ 0x4c73, 0x59d2 },
	{ 0x4c74, 0x59c5 },
	{ 0x4c75, 0x5b5f },
	{ 0x4c76, 0x5b64 },
	{ 0x4c77, 0x5b63 },
	{ 0x4c78, 0x5b97 },
	{ 0x4c79, 0x5b9a },
	{ 0x4c7a, 0x5b98 },
	{ 0x4c7b, 0x5b9c },
	{ 0x4c7c, 0x5b99 },
	{ 0x4c7d, 0x5b9b },
	{ 0x4c7e, 0x5c1a },
	{ 0x4d21, 0x5c48 },
	{ 0x4d22, 0x5c45 },
	{ 0x4d23, 0x5c46 },
	{ 0x4d24, 0x5cb7 },
	{ 0x4d25, 0x5ca1 },
	{ 0x4d26, 0x5cb8 },
	{ 0x4d27, 0x5ca9 },
	{ 0x4d28, 0x5cab },
	{ 0x4d29, 0x5cb1 },
	{ 0x4d2a, 0x5cb3 },
	{ 0x4d2b, 0x5e18 },
	{ 0x4d2c, 0x5e1a },
	{ 0x4d2d, 0x5e16 },
	{ 0x4d2e, 0x5e15 },
	{ 0x4d2f, 0x5e1b },
	{ 0x4d30, 0x5e11 },
	{ 0x4d31, 0x5e78 },
	{ 0x4d32, 0x5e9a },
	{ 0x4d33, 0x5e97 },
	{ 0x4d34, 0x5e9c },
	{ 0x4d35, 0x5e95 },
	{ 0x4d36, 0x5e96 },
	{ 0x4d37, 0x5ef6 },
	{ 0x4d38, 0x5f26 },
	{ 0x4d39, 0x5f27 },
	{ 0x4d3a, 0x5f29 },
	{ 0x4d3b, 0x5f80 },
	{ 0x4d3c, 0x5f81 },
	{ 0x4d3d, 0x5f7f },
	{ 0x4d3e, 0x5f7c },
	{ 0x4d3f, 0x5fdd },
	{ 0x4d40, 0x5fe0 },
	{ 0x4d41, 0x5ffd },
	{ 0x4d42, 0x5ff5 },
	{ 0x4d43, 0x5fff },
	{ 0x4d44, 0x600f },
	{ 0x4d45, 0x6014 },
	{ 0x4d46, 0x602f },
	{ 0x4d47, 0x6035 },
	{ 0x4d48, 0x6016 },
	{ 0x4d49, 0x602a },
	{ 0x4d4a, 0x6015 },
	{ 0x4d4b, 0x6021 },
	{ 0x4d4c, 0x6027 },
	{ 0x4d4d, 0x6029 },
	{ 0x4d4e, 0x602b },
	{ 0x4d4f, 0x601b },
	{ 0x4d50, 0x6216 },
	{ 0x4d51, 0x6215 },
	{ 0x4d52, 0x623f },
	{ 0x4d53, 0x623e },
	{ 0x4d54, 0x6240 },
	{ 0x4d55, 0x627f },
	{ 0x4d56, 0x62c9 },
	{ 0x4d57, 0x62cc },
	{ 0x4d58, 0x62c4 },
	{ 0x4d59, 0x62bf },
	{ 0x4d5a, 0x62c2 },
	{ 0x4d5b, 0x62b9 },
	{ 0x4d5c, 0x62d2 },
	{ 0x4d5d, 0x62db },
	{ 0x4d5e, 0x62ab },
	{ 0x4d5f, 0x62d3 },
	{ 0x4d60, 0x62d4 },
	{ 0x4d61, 0x62cb },
	{ 0x4d62, 0x62c8 },
	{ 0x4d63, 0x62a8 },
	{ 0x4d64, 0x62bd },
	{ 0x4d65, 0x62bc },
	{ 0x4d66, 0x62d0 },
	{ 0x4d67, 0x62d9 },
	{ 0x4d68, 0x62c7 },
	{ 0x4d69, 0x62cd },
	{ 0x4d6a, 0x62b5 },
	{ 0x4d6b, 0x62da },
	{ 0x4d6c, 0x62b1 },
	{ 0x4d6d, 0x62d8 },
	{ 0x4d6e, 0x62d6 },
	{ 0x4d6f, 0x62d7 },
	{ 0x4d70, 0x62c6 },
	{ 0x4d71, 0x62ac },
	{ 0x4d72, 0x62ce },
	{ 0x4d73, 0x653e },
	{ 0x4d74, 0x65a7 },
	{ 0x4d75, 0x65bc },
	{ 0x4d76, 0x65fa },
	{ 0x4d77, 0x6614 },
	{ 0x4d78, 0x6613 },
	{ 0x4d79, 0x660c },
	{ 0x4d7a, 0x6606 },
	{ 0x4d7b, 0x6602 },
	{ 0x4d7c, 0x660e },
	{ 0x4d7d, 0x6600 },
	{ 0x4d7e, 0x660f },
	{ 0x4e21, 0x6615 },
	{ 0x4e22, 0x660a },
	{ 0x4e23, 0x6607 },
	{ 0x4e24, 0x670d },
	{ 0x4e25, 0x670b },
	{ 0x4e26, 0x676d },
	{ 0x4e27, 0x678b },
	{ 0x4e28, 0x6795 },
	{ 0x4e29, 0x6771 },
	{ 0x4e2a, 0x679c },
	{ 0x4e2b, 0x6773 },
	{ 0x4e2c, 0x6777 },
	{ 0x4e2d, 0x6787 },
	{ 0x4e2e, 0x679d },
	{ 0x4e2f, 0x6797 },
	{ 0x4e30, 0x676f },
	{ 0x4e31, 0x6770 },
	{ 0x4e32, 0x677f },
	{ 0x4e33, 0x6789 },
	{ 0x4e34, 0x677e },
	{ 0x4e35, 0x6790 },
	{ 0x4e36, 0x6775 },
	{ 0x4e37, 0x679a },
	{ 0x4e38, 0x6793 },
	{ 0x4e39, 0x677c },
	{ 0x4e3a, 0x676a },
	{ 0x4e3b, 0x6772 },
	{ 0x4e3c, 0x6b23 },
	{ 0x4e3d, 0x6b66 },
	{ 0x4e3e, 0x6b67 },
	{ 0x4e3f, 0x6b7f },
	{ 0x4e40, 0x6c13 },
	{ 0x4e41, 0x6c1b },
	{ 0x4e42, 0x6ce3 },
	{ 0x4e43, 0x6ce8 },
	{ 0x4e44, 0x6cf3 },
	{ 0x4e45, 0x6cb1 },
	{ 0x4e46, 0x6ccc },
	{ 0x4e47, 0x6ce5 },
	{ 0x4e48, 0x6cb3 },
	{ 0x4e49, 0x6cbd },
	{ 0x4e4a, 0x6cbe },
	{ 0x4e4b, 0x6cbc },
	{ 0x4e4c, 0x6ce2 },
	{ 0x4e4d, 0x6cab },
	{ 0x4e4e, 0x6cd5 },
	{ 0x4e4f, 0x6cd3 },
	{ 0x4e50, 0x6cb8 },
	{ 0x4e51, 0x6cc4 },
	{ 0x4e52, 0x6cb9 },
	{ 0x4e53, 0x6cc1 },
	{ 0x4e54, 0x6cae },
	{ 0x4e55, 0x6cd7 },
	{ 0x4e56, 0x6cc5 },
	{ 0x4e57, 0x6cf1 },
	{ 0x4e58, 0x6cbf },
	{ 0x4e59, 0x6cbb },
	{ 0x4e5a, 0x6ce1 },
	{ 0x4e5b, 0x6cdb },
	{ 0x4e5c, 0x6cca },
	{ 0x4e5d, 0x6cac },
	{ 0x4e5e, 0x6cef },
	{ 0x4e5f, 0x6cdc },
	{ 0x4e60, 0x6cd6 },
	{ 0x4e61, 0x6ce0 },
	{ 0x4e62, 0x7095 },
	{ 0x4e63, 0x708e },
	{ 0x4e64, 0x7092 },
	{ 0x4e65, 0x708a },
	{ 0x4e66, 0x7099 },
	{ 0x4e67, 0x722c },
	{ 0x4e68, 0x722d },
	{ 0x4e69, 0x7238 },
	{ 0x4e6a, 0x7248 },
	{ 0x4e6b, 0x7267 },
	{ 0x4e6c, 0x7269 },
	{ 0x4e6d, 0x72c0 },
	{ 0x4e6e, 0x72ce },
	{ 0x4e6f, 0x72d9 },
	{ 0x4e70, 0x72d7 },
	{ 0x4e71, 0x72d0 },
	{ 0x4e72, 0x73a9 },
	{ 0x4e73, 0x73a8 },
	{ 0x4e74, 0x739f },
	{ 0x4e75, 0x73ab },
	{ 0x4e76, 0x73a5 },
	{ 0x4e77, 0x753d },
	{ 0x4e78, 0x759d },
	{ 0x4e79, 0x7599 },
	{ 0x4e7a, 0x759a },
	{ 0x4e7b, 0x7684 },
	{ 0x4e7c, 0x76c2 },
	{ 0x4e7d, 0x76f2 },
	{ 0x4e7e, 0x76f4 },
	{ 0x4f21, 0x77e5 },
	{ 0x4f22, 0x77fd },
	{ 0x4f23, 0x793e },
	{ 0x4f24, 0x7940 },
	{ 0x4f25, 0x7941 },
	{ 0x4f26, 0x79c9 },
	{ 0x4f27, 0x79c8 },
	{ 0x4f28, 0x7a7a },
	{ 0x4f29, 0x7a79 },
	{ 0x4f2a, 0x7afa },
	{ 0x4f2b, 0x7cfe },
	{ 0x4f2c, 0x7f54 },
	{ 0x4f2d, 0x7f8c },
	{ 0x4f2e, 0x7f8b },
	{ 0x4f2f, 0x8005 },
	{ 0x4f30, 0x80ba },
	{ 0x4f31, 0x80a5 },
	{ 0x4f32, 0x80a2 },
	{ 0x4f33, 0x80b1 },
	{ 0x4f34, 0x80a1 },
	{ 0x4f35, 0x80ab },
	{ 0x4f36, 0x80a9 },
	{ 0x4f37, 0x80b4 },
	{ 0x4f38, 0x80aa },
	{ 0x4f39, 0x80af },
	{ 0x4f3a, 0x81e5 },
	{ 0x4f3b, 0x81fe },
	{ 0x4f3c, 0x820d },
	{ 0x4f3d, 0x82b3 },
	{ 0x4f3e, 0x829d },
	{ 0x4f3f, 0x8299 },
	{ 0x4f40, 0x82ad },
	{ 0x4f41, 0x82bd },
	{ 0x4f42, 0x829f },
	{ 0x4f43, 0x82b9 },
	{ 0x4f44, 0x82b1 },
	{ 0x4f45, 0x82ac },
	{ 0x4f46, 0x82a5 },
	{ 0x4f47, 0x82af },
	{ 0x4f48, 0x82b8 },
	{ 0x4f49, 0x82a3 },
	{ 0x4f4a, 0x82b0 },
	{ 0x4f4b, 0x82be },
	{ 0x4f4c, 0x82b7 },
	{ 0x4f4d, 0x864e },
	{ 0x4f4e, 0x8671 },
	{ 0x4f4f, 0x521d },
	{ 0x4f50, 0x8868 },
	{ 0x4f51, 0x8ecb },
	{ 0x4f52, 0x8fce },
	{ 0x4f53, 0x8fd4 },
	{ 0x4f54, 0x8fd1 },
	{ 0x4f55, 0x90b5 },
	{ 0x4f56, 0x90b8 },
	{ 0x4f57, 0x90b1 },
	{ 0x4f58, 0x90b6 },
	{ 0x4f59, 0x91c7 },
	{ 0x4f5a, 0x91d1 },
	{ 0x4f5b, 0x9577 },
	{ 0x4f5c, 0x9580 },
	{ 0x4f5d, 0x961c },
	{ 0x4f5e, 0x9640 },
	{ 0x4f5f, 0x963f },
	{ 0x4f60, 0x963b },
	{ 0x4f61, 0x9644 },
	{ 0x4f62, 0x9642 },
	{ 0x4f63, 0x96b9 },
	{ 0x4f64, 0x96e8 },
	{ 0x4f65, 0x9752 },
	{ 0x4f66, 0x975e },
	{ 0x4f67, 0x4e9f },
	{ 0x4f68, 0x4ead },
	{ 0x4f69, 0x4eae },
	{ 0x4f6a, 0x4fe1 },
	{ 0x4f6b, 0x4fb5 },
	{ 0x4f6c, 0x4faf },
	{ 0x4f6d, 0x4fbf },
	{ 0x4f6e, 0x4fe0 },
	{ 0x4f6f, 0x4fd1 },
	{ 0x4f70, 0x4fcf },
	{ 0x4f71, 0x4fdd },
	{ 0x4f72, 0x4fc3 },
	{ 0x4f73, 0x4fb6 },
	{ 0x4f74, 0x4fd8 },
	{ 0x4f75, 0x4fdf },
	{ 0x4f76, 0x4fca },
	{ 0x4f77, 0x4fd7 },
	{ 0x4f78, 0x4fae },
	{ 0x4f79, 0x4fd0 },
	{ 0x4f7a, 0x4fc4 },
	{ 0x4f7b, 0x4fc2 },
	{ 0x4f7c, 0x4fda },
	{ 0x4f7d, 0x4fce },
	{ 0x4f7e, 0x4fde },
	{ 0x5021, 0x4fb7 },
	{ 0x5022, 0x5157 },
	{ 0x5023, 0x5192 },
	{ 0x5024, 0x5191 },
	{ 0x5025, 0x51a0 },
	{ 0x5026, 0x524e },
	{ 0x5027, 0x5243 },
	{ 0x5028, 0x524a },
	{ 0x5029, 0x524d },
	{ 0x502a, 0x524c },
	{ 0x502b, 0x524b },
	{ 0x502c, 0x5247 },
	{ 0x502d, 0x52c7 },
	{ 0x502e, 0x52c9 },
	{ 0x502f, 0x52c3 },
	{ 0x5030, 0x52c1 },
	{ 0x5031, 0x530d },
	{ 0x5032, 0x5357 },
	{ 0x5033, 0x537b },
	{ 0x5034, 0x539a },
	{ 0x5035, 0x53db },
	{ 0x5036, 0x54ac },
	{ 0x5037, 0x54c0 },
	{ 0x5038, 0x54a8 },
	{ 0x5039, 0x54ce },
	{ 0x503a, 0x54c9 },
	{ 0x503b, 0x54b8 },
	{ 0x503c, 0x54a6 },
	{ 0x503d, 0x54b3 },
	{ 0x503e, 0x54c7 },
	{ 0x503f, 0x54c2 },
	{ 0x5040, 0x54bd },
	{ 0x5041, 0x54aa },
	{ 0x5042, 0x54c1 },
	{ 0x5043, 0x54c4 },
	{ 0x5044, 0x54c8 },
	{ 0x5045, 0x54af },
	{ 0x5046, 0x54ab },
	{ 0x5047, 0x54b1 },
	{ 0x5048, 0x54bb },
	{ 0x5049, 0x54a9 },
	{ 0x504a, 0x54a7 },
	{ 0x504b, 0x54bf },
	{ 0x504c, 0x56ff },
	{ 0x504d, 0x5782 },
	{ 0x504e, 0x578b },
	{ 0x504f, 0x57a0 },
	{ 0x5050, 0x57a3 },
	{ 0x5051, 0x57a2 },
	{ 0x5052, 0x57ce },
	{ 0x5053, 0x57ae },
	{ 0x5054, 0x5793 },
	{ 0x5055, 0x5955 },
	{ 0x5056, 0x5951 },
	{ 0x5057, 0x594f },
	{ 0x5058, 0x594e },
	{ 0x5059, 0x5950 },
	{ 0x505a, 0x59dc },
	{ 0x505b, 0x59d8 },
	{ 0x505c, 0x59ff },
	{ 0x505d, 0x59e3 },
	{ 0x505e, 0x59e8 },
	{ 0x505f, 0x5a03 },
	{ 0x5060, 0x59e5 },
	{ 0x5061, 0x59ea },
	{ 0x5062, 0x59da },
	{ 0x5063, 0x59e6 },
	{ 0x5064, 0x5a01 },
	{ 0x5065, 0x59fb },
	{ 0x5066, 0x5b69 },
	{ 0x5067, 0x5ba3 },
	{ 0x5068, 0x5ba6 },
	{ 0x5069, 0x5ba4 },
	{ 0x506a, 0x5ba2 },
	{ 0x506b, 0x5ba5 },
	{ 0x506c, 0x5c01 },
	{ 0x506d, 0x5c4e },
	{ 0x506e, 0x5c4f },
	{ 0x506f, 0x5c4d },
	{ 0x5070, 0x5c4b },
	{ 0x5071, 0x5cd9 },
	{ 0x5072, 0x5cd2 },
	{ 0x5073, 0x5df7 },
	{ 0x5074, 0x5e1d },
	{ 0x5075, 0x5e25 },
	{ 0x5076, 0x5e1f },
	{ 0x5077, 0x5e7d },
	{ 0x5078, 0x5ea0 },
	{ 0x5079, 0x5ea6 },
	{ 0x507a, 0x5efa },
	{ 0x507b, 0x5f08 },
	{ 0x507c, 0x5f2d },
	{ 0x507d, 0x5f65 },
	{ 0x507e, 0x5f88 },
	{ 0x5121, 0x5f85 },
	{ 0x5122, 0x5f8a },
	{ 0x5123, 0x5f8b },
	{ 0x5124, 0x5f87 },
	{ 0x5125, 0x5f8c },
	{ 0x5126, 0x5f89 },
	{ 0x5127, 0x6012 },
	{ 0x5128, 0x601d },
	{ 0x5129, 0x6020 },
	{ 0x512a, 0x6025 },
	{ 0x512b, 0x600e },
	{ 0x512c, 0x6028 },
	{ 0x512d, 0x604d },
	{ 0x512e, 0x6070 },
	{ 0x512f, 0x6068 },
	{ 0x5130, 0x6062 },
	{ 0x5131, 0x6046 },
	{ 0x5132, 0x6043 },
	{ 0x5133, 0x606c },
	{ 0x5134, 0x606b },
	{ 0x5135, 0x606a },
	{ 0x5136, 0x6064 },
	{ 0x5137, 0x6241 },
	{ 0x5138, 0x62dc },
	{ 0x5139, 0x6316 },
	{ 0x513a, 0x6309 },
	{ 0x513b, 0x62fc },
	{ 0x513c, 0x62ed },
	{ 0x513d, 0x6301 },
	{ 0x513e, 0x62ee },
	{ 0x513f, 0x62fd },
	{ 0x5140, 0x6307 },
	{ 0x5141, 0x62f1 },
	{ 0x5142, 0x62f7 },
	{ 0x5143, 0x62ef },
	{ 0x5144, 0x62ec },
	{ 0x5145, 0x62fe },
	{ 0x5146, 0x62f4 },
	{ 0x5147, 0x6311 },
	{ 0x5148, 0x6302 },
	{ 0x5149, 0x653f },
	{ 0x514a, 0x6545 },
	{ 0x514b, 0x65ab },
	{ 0x514c, 0x65bd },
	{ 0x514d, 0x65e2 },
	{ 0x514e, 0x6625 },
	{ 0x514f, 0x662d },
	{ 0x5150, 0x6620 },
	{ 0x5151, 0x6627 },
	{ 0x5152, 0x662f },
	{ 0x5153, 0x661f },
	{ 0x5154, 0x6628 },
	{ 0x5155, 0x6631 },
	{ 0x5156, 0x6624 },
	{ 0x5157, 0x66f7 },
	{ 0x5158, 0x67ff },
	{ 0x5159, 0x67d3 },
	{ 0x515a, 0x67f1 },
	{ 0x515b, 0x67d4 },
	{ 0x515c, 0x67d0 },
	{ 0x515d, 0x67ec },
	{ 0x515e, 0x67b6 },
	{ 0x515f, 0x67af },
	{ 0x5160, 0x67f5 },
	{ 0x5161, 0x67e9 },
	{ 0x5162, 0x67ef },
	{ 0x5163, 0x67c4 },
	{ 0x5164, 0x67d1 },
	{ 0x5165, 0x67b4 },
	{ 0x5166, 0x67da },
	{ 0x5167, 0x67e5 },
	{ 0x5168, 0x67b8 },
	{ 0x5169, 0x67cf },
	{ 0x516a, 0x67de },
	{ 0x516b, 0x67f3 },
	{ 0x516c, 0x67b0 },
	{ 0x516d, 0x67d9 },
	{ 0x516e, 0x67e2 },
	{ 0x516f, 0x67dd },
	{ 0x5170, 0x67d2 },
	{ 0x5171, 0x6b6a },
	{ 0x5172, 0x6b83 },
	{ 0x5173, 0x6b86 },
	{ 0x5174, 0x6bb5 },
	{ 0x5175, 0x6bd2 },
	{ 0x5176, 0x6bd7 },
	{ 0x5177, 0x6c1f },
	{ 0x5178, 0x6cc9 },
	{ 0x5179, 0x6d0b },
	{ 0x517a, 0x6d32 },
	{ 0x517b, 0x6d2a },
	{ 0x517c, 0x6d41 },
	{ 0x517d, 0x6d25 },
	{ 0x517e, 0x6d0c },
	{ 0x5221, 0x6d31 },
	{ 0x5222, 0x6d1e },
	{ 0x5223, 0x6d17 },
	{ 0x5224, 0x6d3b },
	{ 0x5225, 0x6d3d },
	{ 0x5226, 0x6d3e },
	{ 0x5227, 0x6d36 },
	{ 0x5228, 0x6d1b },
	{ 0x5229, 0x6cf5 },
	{ 0x522a, 0x6d39 },
	{ 0x522b, 0x6d27 },
	{ 0x522c, 0x6d38 },
	{ 0x522d, 0x6d29 },
	{ 0x522e, 0x6d2e },
	{ 0x522f, 0x6d35 },
	{ 0x5230, 0x6d0e },
	{ 0x5231, 0x6d2b },
	{ 0x5232, 0x70ab },
	{ 0x5233, 0x70ba },
	{ 0x5234, 0x70b3 },
	{ 0x5235, 0x70ac },
	{ 0x5236, 0x70af },
	{ 0x5237, 0x70ad },
	{ 0x5238, 0x70b8 },
	{ 0x5239, 0x70ae },
	{ 0x523a, 0x70a4 },
	{ 0x523b, 0x7230 },
	{ 0x523c, 0x7272 },
	{ 0x523d, 0x726f },
	{ 0x523e, 0x7274 },
	{ 0x523f, 0x72e9 },
	{ 0x5240, 0x72e0 },
	{ 0x5241, 0x72e1 },
	{ 0x5242, 0x73b7 },
	{ 0x5243, 0x73ca },
	{ 0x5244, 0x73bb },
	{ 0x5245, 0x73b2 },
	{ 0x5246, 0x73cd },
	{ 0x5247, 0x73c0 },
	{ 0x5248, 0x73b3 },
	{ 0x5249, 0x751a },
	{ 0x524a, 0x752d },
	{ 0x524b, 0x754f },
	{ 0x524c, 0x754c },
	{ 0x524d, 0x754e },
	{ 0x524e, 0x754b },
	{ 0x524f, 0x75ab },
	{ 0x5250, 0x75a4 },
	{ 0x5251, 0x75a5 },
	{ 0x5252, 0x75a2 },
	{ 0x5253, 0x75a3 },
	{ 0x5254, 0x7678 },
	{ 0x5255, 0x7686 },
	{ 0x5256, 0x7687 },
	{ 0x5257, 0x7688 },
	{ 0x5258, 0x76c8 },
	{ 0x5259, 0x76c6 },
	{ 0x525a, 0x76c3 },
	{ 0x525b, 0x76c5 },
	{ 0x525c, 0x7701 },
	{ 0x525d, 0x76f9 },
	{ 0x525e, 0x76f8 },
	{ 0x525f, 0x7709 },
	{ 0x5260, 0x770b },
	{ 0x5261, 0x76fe },
	{ 0x5262, 0x76fc },
	{ 0x5263, 0x7707 },
	{ 0x5264, 0x77dc },
	{ 0x5265, 0x7802 },
	{ 0x5266, 0x7814 },
	{ 0x5267, 0x780c },
	{ 0x5268, 0x780d },
	{ 0x5269, 0x7946 },
	{ 0x526a, 0x7949 },
	{ 0x526b, 0x7948 },
	{ 0x526c, 0x7947 },
	{ 0x526d, 0x79b9 },
	{ 0x526e, 0x79ba },
	{ 0x526f, 0x79d1 },
	{ 0x5270, 0x79d2 },
	{ 0x5271, 0x79cb },
	{ 0x5272, 0x7a7f },
	{ 0x5273, 0x7a81 },
	{ 0x5274, 0x7aff },
	{ 0x5275, 0x7afd },
	{ 0x5276, 0x7c7d },
	{ 0x5277, 0x7d02 },
	{ 0x5278, 0x7d05 },
	{ 0x5279, 0x7d00 },
	{ 0x527a, 0x7d09 },
	{ 0x527b, 0x7d07 },
	{ 0x527c, 0x7d04 },
	{ 0x527d, 0x7d06 },
	{ 0x527e, 0x7f38 },
	{ 0x5321, 0x7f8e },
	{ 0x5322, 0x7fbf },
	{ 0x5323, 0x8010 },
	{ 0x5324, 0x800d },
	{ 0x5325, 0x8011 },
	{ 0x5326, 0x8036 },
	{ 0x5327, 0x80d6 },
	{ 0x5328, 0x80e5 },
	{ 0x5329, 0x80da },
	{ 0x532a, 0x80c3 },
	{ 0x532b, 0x80c4 },
	{ 0x532c, 0x80cc },
	{ 0x532d, 0x80e1 },
	{ 0x532e, 0x80db },
	{ 0x532f, 0x80ce },
	{ 0x5330, 0x80de },
	{ 0x5331, 0x80e4 },
	{ 0x5332, 0x80dd },
	{ 0x5333, 0x81f4 },
	{ 0x5334, 0x8222 },
	{ 0x5335, 0x82e7 },
	{ 0x5336, 0x8303 },
	{ 0x5337, 0x8305 },
	{ 0x5338, 0x82e3 },
	{ 0x5339, 0x82db },
	{ 0x533a, 0x82e6 },
	{ 0x533b, 0x8304 },
	{ 0x533c, 0x82e5 },
	{ 0x533d, 0x8302 },
	{ 0x533e, 0x8309 },
	{ 0x533f, 0x82d2 },
	{ 0x5340, 0x82d7 },
	{ 0x5341, 0x82f1 },
	{ 0x5342, 0x8301 },
	{ 0x5343, 0x82dc },
	{ 0x5344, 0x82d4 },
	{ 0x5345, 0x82d1 },
	{ 0x5346, 0x82de },
	{ 0x5347, 0x82d3 },
	{ 0x5348, 0x82df },
	{ 0x5349, 0x82ef },
	{ 0x534a, 0x8306 },
	{ 0x534b, 0x8650 },
	{ 0x534c, 0x8679 },
	{ 0x534d, 0x867b },
	{ 0x534e, 0x867a },
	{ 0x534f, 0x884d },
	{ 0x5350, 0x886b },
	{ 0x5351, 0x8981 },
	{ 0x5352, 0x89d4 },
	{ 0x5353, 0x8a08 },
	{ 0x5354, 0x8a02 },
	{ 0x5355, 0x8a03 },
	{ 0x5356, 0x8c9e },
	{ 0x5357, 0x8ca0 },
	{ 0x5358, 0x8d74 },
	{ 0x5359, 0x8d73 },
	{ 0x535a, 0x8db4 },
	{ 0x535b, 0x8ecd },
	{ 0x535c, 0x8ecc },
	{ 0x535d, 0x8ff0 },
	{ 0x535e, 0x8fe6 },
	{ 0x535f, 0x8fe2 },
	{ 0x5360, 0x8fea },
	{ 0x5361, 0x8fe5 },
	{ 0x5362, 0x8fed },
	{ 0x5363, 0x8feb },
	{ 0x5364, 0x8fe4 },
	{ 0x5365, 0x8fe8 },
	{ 0x5366, 0x90ca },
	{ 0x5367, 0x90ce },
	{ 0x5368, 0x90c1 },
	{ 0x5369, 0x90c3 },
	{ 0x536a, 0x914b },
	{ 0x536b, 0x914a },
	{ 0x536c, 0x91cd },
	{ 0x536d, 0x9582 },
	{ 0x536e, 0x9650 },
	{ 0x536f, 0x964b },
	{ 0x5370, 0x964c },
	{ 0x5371, 0x964d },
	{ 0x5372, 0x9762 },
	{ 0x5373, 0x9769 },
	{ 0x5374, 0x97cb },
	{ 0x5375, 0x97ed },
	{ 0x5376, 0x97f3 },
	{ 0x5377, 0x9801 },
	{ 0x5378, 0x98a8 },
	{ 0x5379, 0x98db },
	{ 0x537a, 0x98df },
	{ 0x537b, 0x9996 },
	{ 0x537c, 0x9999 },
	{ 0x537d, 0x4e58 },
	{ 0x537e, 0x4eb3 },
	{ 0x5421, 0x500c },
	{ 0x5422, 0x500d },
	{ 0x5423, 0x5023 },
	{ 0x5424, 0x4fef },
	{ 0x5425, 0x5026 },
	{ 0x5426, 0x5025 },
	{ 0x5427, 0x4ff8 },
	{ 0x5428, 0x5029 },
	{ 0x5429, 0x5016 },
	{ 0x542a, 0x5006 },
	{ 0x542b, 0x503c },
	{ 0x542c, 0x501f },
	{ 0x542d, 0x501a },
	{ 0x542e, 0x5012 },
	{ 0x542f, 0x5011 },
	{ 0x5430, 0x4ffa },
	{ 0x5431, 0x5000 },
	{ 0x5432, 0x5014 },
	{ 0x5433, 0x5028 },
	{ 0x5434, 0x4ff1 },
	{ 0x5435, 0x5021 },
	{ 0x5436, 0x500b },
	{ 0x5437, 0x5019 },
	{ 0x5438, 0x5018 },
	{ 0x5439, 0x4ff3 },
	{ 0x543a, 0x4fee },
	{ 0x543b, 0x502d },
	{ 0x543c, 0x502a },
	{ 0x543d, 0x4ffe },
	{ 0x543e, 0x502b },
	{ 0x543f, 0x5009 },
	{ 0x5440, 0x517c },
	{ 0x5441, 0x51a4 },
	{ 0x5442, 0x51a5 },
	{ 0x5443, 0x51a2 },
	{ 0x5444, 0x51cd },
	{ 0x5445, 0x51cc },
	{ 0x5446, 0x51c6 },
	{ 0x5447, 0x51cb },
	{ 0x5448, 0x5256 },
	{ 0x5449, 0x525c },
	{ 0x544a, 0x5254 },
	{ 0x544b, 0x525b },
	{ 0x544c, 0x525d },
	{ 0x544d, 0x532a },
	{ 0x544e, 0x537f },
	{ 0x544f, 0x539f },
	{ 0x5450, 0x539d },
	{ 0x5451, 0x53df },
	{ 0x5452, 0x54e8 },
	{ 0x5453, 0x5510 },
	{ 0x5454, 0x5501 },
	{ 0x5455, 0x5537 },
	{ 0x5456, 0x54fc },
	{ 0x5457, 0x54e5 },
	{ 0x5458, 0x54f2 },
	{ 0x5459, 0x5506 },
	{ 0x545a, 0x54fa },
	{ 0x545b, 0x5514 },
	{ 0x545c, 0x54e9 },
	{ 0x545d, 0x54ed },
	{ 0x545e, 0x54e1 },
	{ 0x545f, 0x5509 },
	{ 0x5460, 0x54ee },
	{ 0x5461, 0x54ea },
	{ 0x5462, 0x54e6 },
	{ 0x5463, 0x5527 },
	{ 0x5464, 0x5507 },
	{ 0x5465, 0x54fd },
	{ 0x5466, 0x550f },
	{ 0x5467, 0x5703 },
	{ 0x5468, 0x5704 },
	{ 0x5469, 0x57c2 },
	{ 0x546a, 0x57d4 },
	{ 0x546b, 0x57cb },
	{ 0x546c, 0x57c3 },
	{ 0x546d, 0x5809 },
	{ 0x546e, 0x590f },
	{ 0x546f, 0x5957 },
	{ 0x5470, 0x5958 },
	{ 0x5471, 0x595a },
	{ 0x5472, 0x5a11 },
	{ 0x5473, 0x5a18 },
	{ 0x5474, 0x5a1c },
	{ 0x5475, 0x5a1f },
	{ 0x5476, 0x5a1b },
	{ 0x5477, 0x5a13 },
	{ 0x5478, 0x59ec },
	{ 0x5479, 0x5a20 },
	{ 0x547a, 0x5a23 },
	{ 0x547b, 0x5a29 },
	{ 0x547c, 0x5a25 },
	{ 0x547d, 0x5a0c },
	{ 0x547e, 0x5a09 },
	{ 0x5521, 0x5b6b },
	{ 0x5522, 0x5c58 },
	{ 0x5523, 0x5bb0 },
	{ 0x5524, 0x5bb3 },
	{ 0x5525, 0x5bb6 },
	{ 0x5526, 0x5bb4 },
	{ 0x5527, 0x5bae },
	{ 0x5528, 0x5bb5 },
	{ 0x5529, 0x5bb9 },
	{ 0x552a, 0x5bb8 },
	{ 0x552b, 0x5c04 },
	{ 0x552c, 0x5c51 },
	{ 0x552d, 0x5c55 },
	{ 0x552e, 0x5c50 },
	{ 0x552f, 0x5ced },
	{ 0x5530, 0x5cfd },
	{ 0x5531, 0x5cfb },
	{ 0x5532, 0x5cea },
	{ 0x5533, 0x5ce8 },
	{ 0x5534, 0x5cf0 },
	{ 0x5535, 0x5cf6 },
	{ 0x5536, 0x5d01 },
	{ 0x5537, 0x5cf4 },
	{ 0x5538, 0x5dee },
	{ 0x5539, 0x5e2d },
	{ 0x553a, 0x5e2b },
	{ 0x553b, 0x5eab },
	{ 0x553c, 0x5ead },
	{ 0x553d, 0x5ea7 },
	{ 0x553e, 0x5f31 },
	{ 0x553f, 0x5f92 },
	{ 0x5540, 0x5f91 },
	{ 0x5541, 0x5f90 },
	{ 0x5542, 0x6059 },
	{ 0x5543, 0x6063 },
	{ 0x5544, 0x6065 },
	{ 0x5545, 0x6050 },
	{ 0x5546, 0x6055 },
	{ 0x5547, 0x606d },
	{ 0x5548, 0x6069 },
	{ 0x5549, 0x606f },
	{ 0x554a, 0x6084 },
	{ 0x554b, 0x609f },
	{ 0x554c, 0x609a },
	{ 0x554d, 0x608d },
	{ 0x554e, 0x6094 },
	{ 0x554f, 0x608c },
	{ 0x5550, 0x6085 },
	{ 0x5551, 0x6096 },
	{ 0x5552, 0x6247 },
	{ 0x5553, 0x62f3 },
	{ 0x5554, 0x6308 },
	{ 0x5555, 0x62ff },
	{ 0x5556, 0x634e },
	{ 0x5557, 0x633e },
	{ 0x5558, 0x632f },
	{ 0x5559, 0x6355 },
	{ 0x555a, 0x6342 },
	{ 0x555b, 0x6346 },
	{ 0x555c, 0x634f },
	{ 0x555d, 0x6349 },
	{ 0x555e, 0x633a },
	{ 0x555f, 0x6350 },
	{ 0x5560, 0x633d },
	{ 0x5561, 0x632a },
	{ 0x5562, 0x632b },
	{ 0x5563, 0x6328 },
	{ 0x5564, 0x634d },
	{ 0x5565, 0x634c },
	{ 0x5566, 0x6548 },
	{ 0x5567, 0x6549 },
	{ 0x5568, 0x6599 },
	{ 0x5569, 0x65c1 },
	{ 0x556a, 0x65c5 },
	{ 0x556b, 0x6642 },
	{ 0x556c, 0x6649 },
	{ 0x556d, 0x664f },
	{ 0x556e, 0x6643 },
	{ 0x556f, 0x6652 },
	{ 0x5570, 0x664c },
	{ 0x5571, 0x6645 },
	{ 0x5572, 0x6641 },
	{ 0x5573, 0x66f8 },
	{ 0x5574, 0x6714 },
	{ 0x5575, 0x6715 },
	{ 0x5576, 0x6717 },
	{ 0x5577, 0x6821 },
	{ 0x5578, 0x6838 },
	{ 0x5579, 0x6848 },
	{ 0x557a, 0x6846 },
	{ 0x557b, 0x6853 },
	{ 0x557c, 0x6839 },
	{ 0x557d, 0x6842 },
	{ 0x557e, 0x6854 },
	{ 0x5621, 0x6829 },
	{ 0x5622, 0x68b3 },
	{ 0x5623, 0x6817 },
	{ 0x5624, 0x684c },
	{ 0x5625, 0x6851 },
	{ 0x5626, 0x683d },
	{ 0x5627, 0x67f4 },
	{ 0x5628, 0x6850 },
	{ 0x5629, 0x6840 },
	{ 0x562a, 0x683c },
	{ 0x562b, 0x6843 },
	{ 0x562c, 0x682a },
	{ 0x562d, 0x6845 },
	{ 0x562e, 0x6813 },
	{ 0x562f, 0x6818 },
	{ 0x5630, 0x6841 },
	{ 0x5631, 0x6b8a },
	{ 0x5632, 0x6b89 },
	{ 0x5633, 0x6bb7 },
	{ 0x5634, 0x6c23 },
	{ 0x5635, 0x6c27 },
	{ 0x5636, 0x6c28 },
	{ 0x5637, 0x6c26 },
	{ 0x5638, 0x6c24 },
	{ 0x5639, 0x6cf0 },
	{ 0x563a, 0x6d6a },
	{ 0x563b, 0x6d95 },
	{ 0x563c, 0x6d88 },
	{ 0x563d, 0x6d87 },
	{ 0x563e, 0x6d66 },
	{ 0x563f, 0x6d78 },
	{ 0x5640, 0x6d77 },
	{ 0x5641, 0x6d59 },
	{ 0x5642, 0x6d93 },
	{ 0x5643, 0x6d6c },
	{ 0x5644, 0x6d89 },
	{ 0x5645, 0x6d6e },
	{ 0x5646, 0x6d5a },
	{ 0x5647, 0x6d74 },
	{ 0x5648, 0x6d69 },
	{ 0x5649, 0x6d8c },
	{ 0x564a, 0x6d8a },
	{ 0x564b, 0x6d79 },
	{ 0x564c, 0x6d85 },
	{ 0x564d, 0x6d65 },
	{ 0x564e, 0x6d94 },
	{ 0x564f, 0x70ca },
	{ 0x5650, 0x70d8 },
	{ 0x5651, 0x70e4 },
	{ 0x5652, 0x70d9 },
	{ 0x5653, 0x70c8 },
	{ 0x5654, 0x70cf },
	{ 0x5655, 0x7239 },
	{ 0x5656, 0x7279 },
	{ 0x5657, 0x72fc },
	{ 0x5658, 0x72f9 },
	{ 0x5659, 0x72fd },
	{ 0x565a, 0x72f8 },
	{ 0x565b, 0x72f7 },
	{ 0x565c, 0x7386 },
	{ 0x565d, 0x73ed },
	{ 0x565e, 0x7409 },
	{ 0x565f, 0x73ee },
	{ 0x5660, 0x73e0 },
	{ 0x5661, 0x73ea },
	{ 0x5662, 0x73de },
	{ 0x5663, 0x7554 },
	{ 0x5664, 0x755d },
	{ 0x5665, 0x755c },
	{ 0x5666, 0x755a },
	{ 0x5667, 0x7559 },
	{ 0x5668, 0x75be },
	{ 0x5669, 0x75c5 },
	{ 0x566a, 0x75c7 },
	{ 0x566b, 0x75b2 },
	{ 0x566c, 0x75b3 },
	{ 0x566d, 0x75bd },
	{ 0x566e, 0x75bc },
	{ 0x566f, 0x75b9 },
	{ 0x5670, 0x75c2 },
	{ 0x5671, 0x75b8 },
	{ 0x5672, 0x768b },
	{ 0x5673, 0x76b0 },
	{ 0x5674, 0x76ca },
	{ 0x5675, 0x76cd },
	{ 0x5676, 0x76ce },
	{ 0x5677, 0x7729 },
	{ 0x5678, 0x771f },
	{ 0x5679, 0x7720 },
	{ 0x567a, 0x7728 },
	{ 0x567b, 0x77e9 },
	{ 0x567c, 0x7830 },
	{ 0x567d, 0x7827 },
	{ 0x567e, 0x7838 },
	{ 0x5721, 0x781d },
	{ 0x5722, 0x7834 },
	{ 0x5723, 0x7837 },
	{ 0x5724, 0x7825 },
	{ 0x5725, 0x782d },
	{ 0x5726, 0x7820 },
	{ 0x5727, 0x781f },
	{ 0x5728, 0x7832 },
	{ 0x5729, 0x7955 },
	{ 0x572a, 0x7950 },
	{ 0x572b, 0x7960 },
	{ 0x572c, 0x795f },
	{ 0x572d, 0x7956 },
	{ 0x572e, 0x795e },
	{ 0x572f, 0x795d },
	{ 0x5730, 0x7957 },
	{ 0x5731, 0x795a },
	{ 0x5732, 0x79e4 },
	{ 0x5733, 0x79e3 },
	{ 0x5734, 0x79e7 },
	{ 0x5735, 0x79df },
	{ 0x5736, 0x79e6 },
	{ 0x5737, 0x79e9 },
	{ 0x5738, 0x79d8 },
	{ 0x5739, 0x7a84 },
	{ 0x573a, 0x7a88 },
	{ 0x573b, 0x7ad9 },
	{ 0x573c, 0x7b06 },
	{ 0x573d, 0x7b11 },
	{ 0x573e, 0x7c89 },
	{ 0x573f, 0x7d21 },
	{ 0x5740, 0x7d17 },
	{ 0x5741, 0x7d0b },
	{ 0x5742, 0x7d0a },
	{ 0x5743, 0x7d20 },
	{ 0x5744, 0x7d22 },
	{ 0x5745, 0x7d14 },
	{ 0x5746, 0x7d10 },
	{ 0x5747, 0x7d15 },
	{ 0x5748, 0x7d1a },
	{ 0x5749, 0x7d1c },
	{ 0x574a, 0x7d0d },
	{ 0x574b, 0x7d19 },
	{ 0x574c, 0x7d1b },
	{ 0x574d, 0x7f3a },
	{ 0x574e, 0x7f5f },
	{ 0x574f, 0x7f94 },
	{ 0x5750, 0x7fc5 },
	{ 0x5751, 0x7fc1 },
	{ 0x5752, 0x8006 },
	{ 0x5753, 0x8004 },
	{ 0x5754, 0x8018 },
	{ 0x5755, 0x8015 },
	{ 0x5756, 0x8019 },
	{ 0x5757, 0x8017 },
	{ 0x5758, 0x803d },
	{ 0x5759, 0x803f },
	{ 0x575a, 0x80f1 },
	{ 0x575b, 0x8102 },
	{ 0x575c, 0x80f0 },
	{ 0x575d, 0x8105 },
	{ 0x575e, 0x80ed },
	{ 0x575f, 0x80f4 },
	{ 0x5760, 0x8106 },
	{ 0x5761, 0x80f8 },
	{ 0x5762, 0x80f3 },
	{ 0x5763, 0x8108 },
	{ 0x5764, 0x80fd },
	{ 0x5765, 0x810a },
	{ 0x5766, 0x80fc },
	{ 0x5767, 0x80ef },
	{ 0x5768, 0x81ed },
	{ 0x5769, 0x81ec },
	{ 0x576a, 0x8200 },
	{ 0x576b, 0x8210 },
	{ 0x576c, 0x822a },
	{ 0x576d, 0x822b },
	{ 0x576e, 0x8228 },
	{ 0x576f, 0x822c },
	{ 0x5770, 0x82bb },
	{ 0x5771, 0x832b },
	{ 0x5772, 0x8352 },
	{ 0x5773, 0x8354 },
	{ 0x5774, 0x834a },
	{ 0x5775, 0x8338 },
	{ 0x5776, 0x8350 },
	{ 0x5777, 0x8349 },
	{ 0x5778, 0x8335 },
	{ 0x5779, 0x8334 },
	{ 0x577a, 0x834f },
	{ 0x577b, 0x8332 },
	{ 0x577c, 0x8339 },
	{ 0x577d, 0x8336 },
	{ 0x577e, 0x8317 },
	{ 0x5821, 0x8340 },
	{ 0x5822, 0x8331 },
	{ 0x5823, 0x8328 },
	{ 0x5824, 0x8343 },
	{ 0x5825, 0x8654 },
	{ 0x5826, 0x868a },
	{ 0x5827, 0x86aa },
	{ 0x5828, 0x8693 },
	{ 0x5829, 0x86a4 },
	{ 0x582a, 0x86a9 },
	{ 0x582b, 0x868c },
	{ 0x582c, 0x86a3 },
	{ 0x582d, 0x869c },
	{ 0x582e, 0x8870 },
	{ 0x582f, 0x8877 },
	{ 0x5830, 0x8881 },
	{ 0x5831, 0x8882 },
	{ 0x5832, 0x887d },
	{ 0x5833, 0x8879 },
	{ 0x5834, 0x8a18 },
	{ 0x5835, 0x8a10 },
	{ 0x5836, 0x8a0e },
	{ 0x5837, 0x8a0c },
	{ 0x5838, 0x8a15 },
	{ 0x5839, 0x8a0a },
	{ 0x583a, 0x8a17 },
	{ 0x583b, 0x8a13 },
	{ 0x583c, 0x8a16 },
	{ 0x583d, 0x8a0f },
	{ 0x583e, 0x8a11 },
	{ 0x583f, 0x8c48 },
	{ 0x5840, 0x8c7a },
	{ 0x5841, 0x8c79 },
	{ 0x5842, 0x8ca1 },
	{ 0x5843, 0x8ca2 },
	{ 0x5844, 0x8d77 },
	{ 0x5845, 0x8eac },
	{ 0x5846, 0x8ed2 },
	{ 0x5847, 0x8ed4 },
	{ 0x5848, 0x8ecf },
	{ 0x5849, 0x8fb1 },
	{ 0x584a, 0x9001 },
	{ 0x584b, 0x9006 },
	{ 0x584c, 0x8ff7 },
	{ 0x584d, 0x9000 },
	{ 0x584e, 0x8ffa },
	{ 0x584f, 0x8ff4 },
	{ 0x5850, 0x9003 },
	{ 0x5851, 0x8ffd },
	{ 0x5852, 0x9005 },
	{ 0x5853, 0x8ff8 },
	{ 0x5854, 0x9095 },
	{ 0x5855, 0x90e1 },
	{ 0x5856, 0x90dd },
	{ 0x5857, 0x90e2 },
	{ 0x5858, 0x9152 },
	{ 0x5859, 0x914d },
	{ 0x585a, 0x914c },
	{ 0x585b, 0x91d8 },
	{ 0x585c, 0x91dd },
	{ 0x585d, 0x91d7 },
	{ 0x585e, 0x91dc },
	{ 0x585f, 0x91d9 },
	{ 0x5860, 0x9583 },
	{ 0x5861, 0x9662 },
	{ 0x5862, 0x9663 },
	{ 0x5863, 0x9661 },
	{ 0x5864, 0x965b },
	{ 0x5865, 0x965d },
	{ 0x5866, 0x9664 },
	{ 0x5867, 0x9658 },
	{ 0x5868, 0x965e },
	{ 0x5869, 0x96bb },
	{ 0x586a, 0x98e2 },
	{ 0x586b, 0x99ac },
	{ 0x586c, 0x9aa8 },
	{ 0x586d, 0x9ad8 },
	{ 0x586e, 0x9b25 },
	{ 0x586f, 0x9b32 },
	{ 0x5870, 0x9b3c },
	{ 0x5871, 0x4e7e },
	{ 0x5872, 0x507a },
	{ 0x5873, 0x507d },
	{ 0x5874, 0x505c },
	{ 0x5875, 0x5047 },
	{ 0x5876, 0x5043 },
	{ 0x5877, 0x504c },
	{ 0x5878, 0x505a },
	{ 0x5879, 0x5049 },
	{ 0x587a, 0x5065 },
	{ 0x587b, 0x5076 },
	{ 0x587c, 0x504e },
	{ 0x587d, 0x5055 },
	{ 0x587e, 0x5075 },
	{ 0x5921, 0x5074 },
	{ 0x5922, 0x5077 },
	{ 0x5923, 0x504f },
	{ 0x5924, 0x500f },
	{ 0x5925, 0x506f },
	{ 0x5926, 0x506d },
	{ 0x5927, 0x515c },
	{ 0x5928, 0x5195 },
	{ 0x5929, 0x51f0 },
	{ 0x592a, 0x526a },
	{ 0x592b, 0x526f },
	{ 0x592c, 0x52d2 },
	{ 0x592d, 0x52d9 },
	{ 0x592e, 0x52d8 },
	{ 0x592f, 0x52d5 },
	{ 0x5930, 0x5310 },
	{ 0x5931, 0x530f },
	{ 0x5932, 0x5319 },
	{ 0x5933, 0x533f },
	{ 0x5934, 0x5340 },
	{ 0x5935, 0x533e },
	{ 0x5936, 0x53c3 },
	{ 0x5937, 0x66fc },
	{ 0x5938, 0x5546 },
	{ 0x5939, 0x556a },
	{ 0x593a, 0x5566 },
	{ 0x593b, 0x5544 },
	{ 0x593c, 0x555e },
	{ 0x593d, 0x5561 },
	{ 0x593e, 0x5543 },
	{ 0x593f, 0x554a },
	{ 0x5940, 0x5531 },
	{ 0x5941, 0x5556 },
	{ 0x5942, 0x554f },
	{ 0x5943, 0x5555 },
	{ 0x5944, 0x552f },
	{ 0x5945, 0x5564 },
	{ 0x5946, 0x5538 },
	{ 0x5947, 0x552e },
	{ 0x5948, 0x555c },
	{ 0x5949, 0x552c },
	{ 0x594a, 0x5563 },
	{ 0x594b, 0x5533 },
	{ 0x594c, 0x5541 },
	{ 0x594d, 0x5557 },
	{ 0x594e, 0x5708 },
	{ 0x594f, 0x570b },
	{ 0x5950, 0x5709 },
	{ 0x5951, 0x57df },
	{ 0x5952, 0x5805 },
	{ 0x5953, 0x580a },
	{ 0x5954, 0x5806 },
	{ 0x5955, 0x57e0 },
	{ 0x5956, 0x57e4 },
	{ 0x5957, 0x57fa },
	{ 0x5958, 0x5802 },
	{ 0x5959, 0x5835 },
	{ 0x595a, 0x57f7 },
	{ 0x595b, 0x57f9 },
	{ 0x595c, 0x5920 },
	{ 0x595d, 0x5962 },
	{ 0x595e, 0x5a36 },
	{ 0x595f, 0x5a41 },
	{ 0x5960, 0x5a49 },
	{ 0x5961, 0x5a66 },
	{ 0x5962, 0x5a6a },
	{ 0x5963, 0x5a40 },
	{ 0x5964, 0x5a3c },
	{ 0x5965, 0x5a62 },
	{ 0x5966, 0x5a5a },
	{ 0x5967, 0x5a46 },
	{ 0x5968, 0x5a4a },
	{ 0x5969, 0x5b70 },
	{ 0x596a, 0x5bc7 },
	{ 0x596b, 0x5bc5 },
	{ 0x596c, 0x5bc4 },
	{ 0x596d, 0x5bc2 },
	{ 0x596e, 0x5bbf },
	{ 0x596f, 0x5bc6 },
	{ 0x5970, 0x5c09 },
	{ 0x5971, 0x5c08 },
	{ 0x5972, 0x5c07 },
	{ 0x5973, 0x5c60 },
	{ 0x5974, 0x5c5c },
	{ 0x5975, 0x5c5d },
	{ 0x5976, 0x5d07 },
	{ 0x5977, 0x5d06 },
	{ 0x5978, 0x5d0e },
	{ 0x5979, 0x5d1b },
	{ 0x597a, 0x5d16 },
	{ 0x597b, 0x5d22 },
	{ 0x597c, 0x5d11 },
	{ 0x597d, 0x5d29 },
	{ 0x597e, 0x5d14 },
	{ 0x5a21, 0x5d19 },
	{ 0x5a22, 0x5d24 },
	{ 0x5a23, 0x5d27 },
	{ 0x5a24, 0x5d17 },
	{ 0x5a25, 0x5de2 },
	{ 0x5a26, 0x5e38 },
	{ 0x5a27, 0x5e36 },
	{ 0x5a28, 0x5e33 },
	{ 0x5a29, 0x5e37 },
	{ 0x5a2a, 0x5eb7 },
	{ 0x5a2b, 0x5eb8 },
	{ 0x5a2c, 0x5eb6 },
	{ 0x5a2d, 0x5eb5 },
	{ 0x5a2e, 0x5ebe },
	{ 0x5a2f, 0x5f35 },
	{ 0x5a30, 0x5f37 },
	{ 0x5a31, 0x5f57 },
	{ 0x5a32, 0x5f6c },
	{ 0x5a33, 0x5f69 },
	{ 0x5a34, 0x5f6b },
	{ 0x5a35, 0x5f97 },
	{ 0x5a36, 0x5f99 },
	{ 0x5a37, 0x5f9e },
	{ 0x5a38, 0x5f98 },
	{ 0x5a39, 0x5fa1 },
	{ 0x5a3a, 0x5fa0 },
	{ 0x5a3b, 0x5f9c },
	{ 0x5a3c, 0x607f },
	{ 0x5a3d, 0x60a3 },
	{ 0x5a3e, 0x6089 },
	{ 0x5a3f, 0x60a0 },
	{ 0x5a40, 0x60a8 },
	{ 0x5a41, 0x60cb },
	{ 0x5a42, 0x60b4 },
	{ 0x5a43, 0x60e6 },
	{ 0x5a44, 0x60bd },
	{ 0x5a45, 0x60c5 },
	{ 0x5a46, 0x60bb },
	{ 0x5a47, 0x60b5 },
	{ 0x5a48, 0x60dc },
	{ 0x5a49, 0x60bc },
	{ 0x5a4a, 0x60d8 },
	{ 0x5a4b, 0x60d5 },
	{ 0x5a4c, 0x60c6 },
	{ 0x5a4d, 0x60df },
	{ 0x5a4e, 0x60b8 },
	{ 0x5a4f, 0x60da },
	{ 0x5a50, 0x60c7 },
	{ 0x5a51, 0x621a },
	{ 0x5a52, 0x621b },
	{ 0x5a53, 0x6248 },
	{ 0x5a54, 0x63a0 },
	{ 0x5a55, 0x63a7 },
	{ 0x5a56, 0x6372 },
	{ 0x5a57, 0x6396 },
	{ 0x5a58, 0x63a2 },
	{ 0x5a59, 0x63a5 },
	{ 0x5a5a, 0x6377 },
	{ 0x5a5b, 0x6367 },
	{ 0x5a5c, 0x6398 },
	{ 0x5a5d, 0x63aa },
	{ 0x5a5e, 0x6371 },
	{ 0x5a5f, 0x63a9 },
	{ 0x5a60, 0x6389 },
	{ 0x5a61, 0x6383 },
	{ 0x5a62, 0x639b },
	{ 0x5a63, 0x636b },
	{ 0x5a64, 0x63a8 },
	{ 0x5a65, 0x6384 },
	{ 0x5a66, 0x6388 },
	{ 0x5a67, 0x6399 },
	{ 0x5a68, 0x63a1 },
	{ 0x5a69, 0x63ac },
	{ 0x5a6a, 0x6392 },
	{ 0x5a6b, 0x638f },
	{ 0x5a6c, 0x6380 },
	{ 0x5a6d, 0x637b },
	{ 0x5a6e, 0x6369 },
	{ 0x5a6f, 0x6368 },
	{ 0x5a70, 0x637a },
	{ 0x5a71, 0x655d },
	{ 0x5a72, 0x6556 },
	{ 0x5a73, 0x6551 },
	{ 0x5a74, 0x6559 },
	{ 0x5a75, 0x6557 },
	{ 0x5a76, 0x555f },
	{ 0x5a77, 0x654f },
	{ 0x5a78, 0x6558 },
	{ 0x5a79, 0x6555 },
	{ 0x5a7a, 0x6554 },
	{ 0x5a7b, 0x659c },
	{ 0x5a7c, 0x659b },
	{ 0x5a7d, 0x65ac },
	{ 0x5a7e, 0x65cf },
	{ 0x5b21, 0x65cb },
	{ 0x5b22, 0x65cc },
	{ 0x5b23, 0x65ce },
	{ 0x5b24, 0x665d },
	{ 0x5b25, 0x665a },
	{ 0x5b26, 0x6664 },
	{ 0x5b27, 0x6668 },
	{ 0x5b28, 0x6666 },
	{ 0x5b29, 0x665e },
	{ 0x5b2a, 0x66f9 },
	{ 0x5b2b, 0x52d7 },
	{ 0x5b2c, 0x671b },
	{ 0x5b2d, 0x6881 },
	{ 0x5b2e, 0x68af },
	{ 0x5b2f, 0x68a2 },
	{ 0x5b30, 0x6893 },
	{ 0x5b31, 0x68b5 },
	{ 0x5b32, 0x687f },
	{ 0x5b33, 0x6876 },
	{ 0x5b34, 0x68b1 },
	{ 0x5b35, 0x68a7 },
	{ 0x5b36, 0x6897 },
	{ 0x5b37, 0x68b0 },
	{ 0x5b38, 0x6883 },
	{ 0x5b39, 0x68c4 },
	{ 0x5b3a, 0x68ad },
	{ 0x5b3b, 0x6886 },
	{ 0x5b3c, 0x6885 },
	{ 0x5b3d, 0x6894 },
	{ 0x5b3e, 0x689d },
	{ 0x5b3f, 0x68a8 },
	{ 0x5b40, 0x689f },
	{ 0x5b41, 0x68a1 },
	{ 0x5b42, 0x6882 },
	{ 0x5b43, 0x6b32 },
	{ 0x5b44, 0x6bba },
	{ 0x5b45, 0x6beb },
	{ 0x5b46, 0x6bec },
	{ 0x5b47, 0x6c2b },
	{ 0x5b48, 0x6d8e },
	{ 0x5b49, 0x6dbc },
	{ 0x5b4a, 0x6df3 },
	{ 0x5b4b, 0x6dd9 },
	{ 0x5b4c, 0x6db2 },
	{ 0x5b4d, 0x6de1 },
	{ 0x5b4e, 0x6dcc },
	{ 0x5b4f, 0x6de4 },
	{ 0x5b50, 0x6dfb },
	{ 0x5b51, 0x6dfa },
	{ 0x5b52, 0x6e05 },
	{ 0x5b53, 0x6dc7 },
	{ 0x5b54, 0x6dcb },
	{ 0x5b55, 0x6daf },
	{ 0x5b56, 0x6dd1 },
	{ 0x5b57, 0x6dae },
	{ 0x5b58, 0x6dde },
	{ 0x5b59, 0x6df9 },
	{ 0x5b5a, 0x6db8 },
	{ 0x5b5b, 0x6df7 },
	{ 0x5b5c, 0x6df5 },
	{ 0x5b5d, 0x6dc5 },
	{ 0x5b5e, 0x6dd2 },
	{ 0x5b5f, 0x6e1a },
	{ 0x5b60, 0x6db5 },
	{ 0x5b61, 0x6dda },
	{ 0x5b62, 0x6deb },
	{ 0x5b63, 0x6dd8 },
	{ 0x5b64, 0x6dea },
	{ 0x5b65, 0x6df1 },
	{ 0x5b66, 0x6dee },
	{ 0x5b67, 0x6de8 },
	{ 0x5b68, 0x6dc6 },
	{ 0x5b69, 0x6dc4 },
	{ 0x5b6a, 0x6daa },
	{ 0x5b6b, 0x6dec },
	{ 0x5b6c, 0x6dbf },
	{ 0x5b6d, 0x6de6 },
	{ 0x5b6e, 0x70f9 },
	{ 0x5b6f, 0x7109 },
	{ 0x5b70, 0x710a },
	{ 0x5b71, 0x70fd },
	{ 0x5b72, 0x70ef },
	{ 0x5b73, 0x723d },
	{ 0x5b74, 0x727d },
	{ 0x5b75, 0x7281 },
	{ 0x5b76, 0x731c },
	{ 0x5b77, 0x731b },
	{ 0x5b78, 0x7316 },
	{ 0x5b79, 0x7313 },
	{ 0x5b7a, 0x7319 },
	{ 0x5b7b, 0x7387 },
	{ 0x5b7c, 0x7405 },
	{ 0x5b7d, 0x740a },
	{ 0x5b7e, 0x7403 },
	{ 0x5c21, 0x7406 },
	{ 0x5c22, 0x73fe },
	{ 0x5c23, 0x740d },
	{ 0x5c24, 0x74e0 },
	{ 0x5c25, 0x74f6 },
	{ 0x5c26, 0x74f7 },
	{ 0x5c27, 0x751c },
	{ 0x5c28, 0x7522 },
	{ 0x5c29, 0x7565 },
	{ 0x5c2a, 0x7566 },
	{ 0x5c2b, 0x7562 },
	{ 0x5c2c, 0x7570 },
	{ 0x5c2d, 0x758f },
	{ 0x5c2e, 0x75d4 },
	{ 0x5c2f, 0x75d5 },
	{ 0x5c30, 0x75b5 },
	{ 0x5c31, 0x75ca },
	{ 0x5c32, 0x75cd },
	{ 0x5c33, 0x768e },
	{ 0x5c34, 0x76d4 },
	{ 0x5c35, 0x76d2 },
	{ 0x5c36, 0x76db },
	{ 0x5c37, 0x7737 },
	{ 0x5c38, 0x773e },
	{ 0x5c39, 0x773c },
	{ 0x5c3a, 0x7736 },
	{ 0x5c3b, 0x7738 },
	{ 0x5c3c, 0x773a },
	{ 0x5c3d, 0x786b },
	{ 0x5c3e, 0x7843 },
	{ 0x5c3f, 0x784e },
	{ 0x5c40, 0x7965 },
	{ 0x5c41, 0x7968 },
	{ 0x5c42, 0x796d },
	{ 0x5c43, 0x79fb },
	{ 0x5c44, 0x7a92 },
	{ 0x5c45, 0x7a95 },
	{ 0x5c46, 0x7b20 },
	{ 0x5c47, 0x7b28 },
	{ 0x5c48, 0x7b1b },
	{ 0x5c49, 0x7b2c },
	{ 0x5c4a, 0x7b26 },
	{ 0x5c4b, 0x7b19 },
	{ 0x5c4c, 0x7b1e },
	{ 0x5c4d, 0x7b2e },
	{ 0x5c4e, 0x7c92 },
	{ 0x5c4f, 0x7c97 },
	{ 0x5c50, 0x7c95 },
	{ 0x5c51, 0x7d46 },
	{ 0x5c52, 0x7d43 },
	{ 0x5c53, 0x7d71 },
	{ 0x5c54, 0x7d2e },
	{ 0x5c55, 0x7d39 },
	{ 0x5c56, 0x7d3c },
	{ 0x5c57, 0x7d40 },
	{ 0x5c58, 0x7d30 },
	{ 0x5c59, 0x7d33 },
	{ 0x5c5a, 0x7d44 },
	{ 0x5c5b, 0x7d2f },
	{ 0x5c5c, 0x7d42 },
	{ 0x5c5d, 0x7d32 },
	{ 0x5c5e, 0x7d31 },
	{ 0x5c5f, 0x7f3d },
	{ 0x5c60, 0x7f9e },
	{ 0x5c61, 0x7f9a },
	{ 0x5c62, 0x7fcc },
	{ 0x5c63, 0x7fce },
	{ 0x5c64, 0x7fd2 },
	{ 0x5c65, 0x801c },
	{ 0x5c66, 0x804a },
	{ 0x5c67, 0x8046 },
	{ 0x5c68, 0x812f },
	{ 0x5c69, 0x8116 },
	{ 0x5c6a, 0x8123 },
	{ 0x5c6b, 0x812b },
	{ 0x5c6c, 0x8129 },
	{ 0x5c6d, 0x8130 },
	{ 0x5c6e, 0x8124 },
	{ 0x5c6f, 0x8202 },
	{ 0x5c70, 0x8235 },
	{ 0x5c71, 0x8237 },
	{ 0x5c72, 0x8236 },
	{ 0x5c73, 0x8239 },
	{ 0x5c74, 0x838e },
	{ 0x5c75, 0x839e },
	{ 0x5c76, 0x8398 },
	{ 0x5c77, 0x8378 },
	{ 0x5c78, 0x83a2 },
	{ 0x5c79, 0x8396 },
	{ 0x5c7a, 0x83bd },
	{ 0x5c7b, 0x83ab },
	{ 0x5c7c, 0x8392 },
	{ 0x5c7d, 0x838a },
	{ 0x5c7e, 0x8393 },
	{ 0x5d21, 0x8389 },
	{ 0x5d22, 0x83a0 },
	{ 0x5d23, 0x8377 },
	{ 0x5d24, 0x837b },
	{ 0x5d25, 0x837c },
	{ 0x5d26, 0x8386 },
	{ 0x5d27, 0x83a7 },
	{ 0x5d28, 0x8655 },
	{ 0x5d29, 0x5f6a },
	{ 0x5d2a, 0x86c7 },
	{ 0x5d2b, 0x86c0 },
	{ 0x5d2c, 0x86b6 },
	{ 0x5d2d, 0x86c4 },
	{ 0x5d2e, 0x86b5 },
	{ 0x5d2f, 0x86c6 },
	{ 0x5d30, 0x86cb },
	{ 0x5d31, 0x86b1 },
	{ 0x5d32, 0x86af },
	{ 0x5d33, 0x86c9 },
	{ 0x5d34, 0x8853 },
	{ 0x5d35, 0x889e },
	{ 0x5d36, 0x8888 },
	{ 0x5d37, 0x88ab },
	{ 0x5d38, 0x8892 },
	{ 0x5d39, 0x8896 },
	{ 0x5d3a, 0x888d },
	{ 0x5d3b, 0x888b },
	{ 0x5d3c, 0x8993 },
	{ 0x5d3d, 0x898f },
	{ 0x5d3e, 0x8a2a },
	{ 0x5d3f, 0x8a1d },
	{ 0x5d40, 0x8a23 },
	{ 0x5d41, 0x8a25 },
	{ 0x5d42, 0x8a31 },
	{ 0x5d43, 0x8a2d },
	{ 0x5d44, 0x8a1f },
	{ 0x5d45, 0x8a1b },
	{ 0x5d46, 0x8a22 },
	{ 0x5d47, 0x8c49 },
	{ 0x5d48, 0x8c5a },
	{ 0x5d49, 0x8ca9 },
	{ 0x5d4a, 0x8cac },
	{ 0x5d4b, 0x8cab },
	{ 0x5d4c, 0x8ca8 },
	{ 0x5d4d, 0x8caa },
	{ 0x5d4e, 0x8ca7 },
	{ 0x5d4f, 0x8d67 },
	{ 0x5d50, 0x8d66 },
	{ 0x5d51, 0x8dbe },
	{ 0x5d52, 0x8dba },
	{ 0x5d53, 0x8edb },
	{ 0x5d54, 0x8edf },
	{ 0x5d55, 0x9019 },
	{ 0x5d56, 0x900d },
	{ 0x5d57, 0x901a },
	{ 0x5d58, 0x9017 },
	{ 0x5d59, 0x9023 },
	{ 0x5d5a, 0x901f },
	{ 0x5d5b, 0x901d },
	{ 0x5d5c, 0x9010 },
	{ 0x5d5d, 0x9015 },
	{ 0x5d5e, 0x901e },
	{ 0x5d5f, 0x9020 },
	{ 0x5d60, 0x900f },
	{ 0x5d61, 0x9022 },
	{ 0x5d62, 0x9016 },
	{ 0x5d63, 0x901b },
	{ 0x5d64, 0x9014 },
	{ 0x5d65, 0x90e8 },
	{ 0x5d66, 0x90ed },
	{ 0x5d67, 0x90fd },
	{ 0x5d68, 0x9157 },
	{ 0x5d69, 0x91ce },
	{ 0x5d6a, 0x91f5 },
	{ 0x5d6b, 0x91e6 },
	{ 0x5d6c, 0x91e3 },
	{ 0x5d6d, 0x91e7 },
	{ 0x5d6e, 0x91ed },
	{ 0x5d6f, 0x91e9 },
	{ 0x5d70, 0x9589 },
	{ 0x5d71, 0x966a },
	{ 0x5d72, 0x9675 },
	{ 0x5d73, 0x9673 },
	{ 0x5d74, 0x9678 },
	{ 0x5d75, 0x9670 },
	{ 0x5d76, 0x9674 },
	{ 0x5d77, 0x9676 },
	{ 0x5d78, 0x9677 },
	{ 0x5d79, 0x966c },
	{ 0x5d7a, 0x96c0 },
	{ 0x5d7b, 0x96ea },
	{ 0x5d7c, 0x96e9 },
	{ 0x5d7d, 0x7ae0 },
	{ 0x5d7e, 0x7adf },
	{ 0x5e21, 0x9802 },
	{ 0x5e22, 0x9803 },
	{ 0x5e23, 0x9b5a },
	{ 0x5e24, 0x9ce5 },
	{ 0x5e25, 0x9e75 },
	{ 0x5e26, 0x9e7f },
	{ 0x5e27, 0x9ea5 },
	{ 0x5e28, 0x9ebb },
	{ 0x5e29, 0x50a2 },
	{ 0x5e2a, 0x508d },
	{ 0x5e2b, 0x5085 },
	{ 0x5e2c, 0x5099 },
	{ 0x5e2d, 0x5091 },
	{ 0x5e2e, 0x5080 },
	{ 0x5e2f, 0x5096 },
	{ 0x5e30, 0x5098 },
	{ 0x5e31, 0x509a },
	{ 0x5e32, 0x6700 },
	{ 0x5e33, 0x51f1 },
	{ 0x5e34, 0x5272 },
	{ 0x5e35, 0x5274 },
	{ 0x5e36, 0x5275 },
	{ 0x5e37, 0x5269 },
	{ 0x5e38, 0x52de },
	{ 0x5e39, 0x52dd },
	{ 0x5e3a, 0x52db },
	{ 0x5e3b, 0x535a },
	{ 0x5e3c, 0x53a5 },
	{ 0x5e3d, 0x557b },
	{ 0x5e3e, 0x5580 },
	{ 0x5e3f, 0x55a7 },
	{ 0x5e40, 0x557c },
	{ 0x5e41, 0x558a },
	{ 0x5e42, 0x559d },
	{ 0x5e43, 0x5598 },
	{ 0x5e44, 0x5582 },
	{ 0x5e45, 0x559c },
	{ 0x5e46, 0x55aa },
	{ 0x5e47, 0x5594 },
	{ 0x5e48, 0x5587 },
	{ 0x5e49, 0x558b },
	{ 0x5e4a, 0x5583 },
	{ 0x5e4b, 0x55b3 },
	{ 0x5e4c, 0x55ae },
	{ 0x5e4d, 0x559f },
	{ 0x5e4e, 0x553e },
	{ 0x5e4f, 0x55b2 },
	{ 0x5e50, 0x559a },
	{ 0x5e51, 0x55bb },
	{ 0x5e52, 0x55ac },
	{ 0x5e53, 0x55b1 },
	{ 0x5e54, 0x557e },
	{ 0x5e55, 0x5589 },
	{ 0x5e56, 0x55ab },
	{ 0x5e57, 0x5599 },
	{ 0x5e58, 0x570d },
	{ 0x5e59, 0x582f },
	{ 0x5e5a, 0x582a },
	{ 0x5e5b, 0x5834 },
	{ 0x5e5c, 0x5824 },
	{ 0x5e5d, 0x5830 },
	{ 0x5e5e, 0x5831 },
	{ 0x5e5f, 0x5821 },
	{ 0x5e60, 0x581d },
	{ 0x5e61, 0x5820 },
	{ 0x5e62, 0x58f9 },
	{ 0x5e63, 0x58fa },
	{ 0x5e64, 0x5960 },
	{ 0x5e65, 0x5a77 },
	{ 0x5e66, 0x5a9a },
	{ 0x5e67, 0x5a7f },
	{ 0x5e68, 0x5a92 },
	{ 0x5e69, 0x5a9b },
	{ 0x5e6a, 0x5aa7 },
	{ 0x5e6b, 0x5b73 },
	{ 0x5e6c, 0x5b71 },
	{ 0x5e6d, 0x5bd2 },
	{ 0x5e6e, 0x5bcc },
	{ 0x5e6f, 0x5bd3 },
	{ 0x5e70, 0x5bd0 },
	{ 0x5e71, 0x5c0a },
	{ 0x5e72, 0x5c0b },
	{ 0x5e73, 0x5c31 },
	{ 0x5e74, 0x5d4c },
	{ 0x5e75, 0x5d50 },
	{ 0x5e76, 0x5d34 },
	{ 0x5e77, 0x5d47 },
	{ 0x5e78, 0x5dfd },
	{ 0x5e79, 0x5e45 },
	{ 0x5e7a, 0x5e3d },
	{ 0x5e7b, 0x5e40 },
	{ 0x5e7c, 0x5e43 },
	{ 0x5e7d, 0x5e7e },
	{ 0x5e7e, 0x5eca },
	{ 0x5f21, 0x5ec1 },
	{ 0x5f22, 0x5ec2 },
	{ 0x5f23, 0x5ec4 },
	{ 0x5f24, 0x5f3c },
	{ 0x5f25, 0x5f6d },
	{ 0x5f26, 0x5fa9 },
	{ 0x5f27, 0x5faa },
	{ 0x5f28, 0x5fa8 },
	{ 0x5f29, 0x60d1 },
	{ 0x5f2a, 0x60e1 },
	{ 0x5f2b, 0x60b2 },
	{ 0x5f2c, 0x60b6 },
	{ 0x5f2d, 0x60e0 },
	{ 0x5f2e, 0x611c },
	{ 0x5f2f, 0x6123 },
	{ 0x5f30, 0x60fa },
	{ 0x5f31, 0x6115 },
	{ 0x5f32, 0x60f0 },
	{ 0x5f33, 0x60fb },
	{ 0x5f34, 0x60f4 },
	{ 0x5f35, 0x6168 },
	{ 0x5f36, 0x60f1 },
	{ 0x5f37, 0x610e },
	{ 0x5f38, 0x60f6 },
	{ 0x5f39, 0x6109 },
	{ 0x5f3a, 0x6100 },
	{ 0x5f3b, 0x6112 },
	{ 0x5f3c, 0x621f },
	{ 0x5f3d, 0x6249 },
	{ 0x5f3e, 0x63a3 },
	{ 0x5f3f, 0x638c },
	{ 0x5f40, 0x63cf },
	{ 0x5f41, 0x63c0 },
	{ 0x5f42, 0x63e9 },
	{ 0x5f43, 0x63c9 },
	{ 0x5f44, 0x63c6 },
	{ 0x5f45, 0x63cd },
	{ 0x5f46, 0x63d2 },
	{ 0x5f47, 0x63e3 },
	{ 0x5f48, 0x63d0 },
	{ 0x5f49, 0x63e1 },
	{ 0x5f4a, 0x63d6 },
	{ 0x5f4b, 0x63ed },
	{ 0x5f4c, 0x63ee },
	{ 0x5f4d, 0x6376 },
	{ 0x5f4e, 0x63f4 },
	{ 0x5f4f, 0x63ea },
	{ 0x5f50, 0x63db },
	{ 0x5f51, 0x6452 },
	{ 0x5f52, 0x63da },
	{ 0x5f53, 0x63f9 },
	{ 0x5f54, 0x655e },
	{ 0x5f55, 0x6566 },
	{ 0x5f56, 0x6562 },
	{ 0x5f57, 0x6563 },
	{ 0x5f58, 0x6591 },
	{ 0x5f59, 0x6590 },
	{ 0x5f5a, 0x65af },
	{ 0x5f5b, 0x666e },
	{ 0x5f5c, 0x6670 },
	{ 0x5f5d, 0x6674 },
	{ 0x5f5e, 0x6676 },
	{ 0x5f5f, 0x666f },
	{ 0x5f60, 0x6691 },
	{ 0x5f61, 0x667a },
	{ 0x5f62, 0x667e },
	{ 0x5f63, 0x6677 },
	{ 0x5f64, 0x66fe },
	{ 0x5f65, 0x66ff },
	{ 0x5f66, 0x671f },
	{ 0x5f67, 0x671d },
	{ 0x5f68, 0x68fa },
	{ 0x5f69, 0x68d5 },
	{ 0x5f6a, 0x68e0 },
	{ 0x5f6b, 0x68d8 },
	{ 0x5f6c, 0x68d7 },
	{ 0x5f6d, 0x6905 },
	{ 0x5f6e, 0x68df },
	{ 0x5f6f, 0x68f5 },
	{ 0x5f70, 0x68ee },
	{ 0x5f71, 0x68e7 },
	{ 0x5f72, 0x68f9 },
	{ 0x5f73, 0x68d2 },
	{ 0x5f74, 0x68f2 },
	{ 0x5f75, 0x68e3 },
	{ 0x5f76, 0x68cb },
	{ 0x5f77, 0x68cd },
	{ 0x5f78, 0x690d },
	{ 0x5f79, 0x6912 },
	{ 0x5f7a, 0x690e },
	{ 0x5f7b, 0x68c9 },
	{ 0x5f7c, 0x68da },
	{ 0x5f7d, 0x696e },
	{ 0x5f7e, 0x68fb },
	{ 0x6021, 0x6b3e },
	{ 0x6022, 0x6b3a },
	{ 0x6023, 0x6b3d },
	{ 0x6024, 0x6b98 },
	{ 0x6025, 0x6b96 },
	{ 0x6026, 0x6bbc },
	{ 0x6027, 0x6bef },
	{ 0x6028, 0x6c2e },
	{ 0x6029, 0x6c2f },
	{ 0x602a, 0x6c2c },
	{ 0x602b, 0x6e2f },
	{ 0x602c, 0x6e38 },
	{ 0x602d, 0x6e54 },
	{ 0x602e, 0x6e21 },
	{ 0x602f, 0x6e32 },
	{ 0x6030, 0x6e67 },
	{ 0x6031, 0x6e4a },
	{ 0x6032, 0x6e20 },
	{ 0x6033, 0x6e25 },
	{ 0x6034, 0x6e23 },
	{ 0x6035, 0x6e1b },
	{ 0x6036, 0x6e5b },
	{ 0x6037, 0x6e58 },
	{ 0x6038, 0x6e24 },
	{ 0x6039, 0x6e56 },
	{ 0x603a, 0x6e6e },
	{ 0x603b, 0x6e2d },
	{ 0x603c, 0x6e26 },
	{ 0x603d, 0x6e6f },
	{ 0x603e, 0x6e34 },
	{ 0x603f, 0x6e4d },
	{ 0x6040, 0x6e3a },
	{ 0x6041, 0x6e2c },
	{ 0x6042, 0x6e43 },
	{ 0x6043, 0x6e1d },
	{ 0x6044, 0x6e3e },
	{ 0x6045, 0x6ecb },
	{ 0x6046, 0x6e89 },
	{ 0x6047, 0x6e19 },
	{ 0x6048, 0x6e4e },
	{ 0x6049, 0x6e63 },
	{ 0x604a, 0x6e44 },
	{ 0x604b, 0x6e72 },
	{ 0x604c, 0x6e69 },
	{ 0x604d, 0x6e5f },
	{ 0x604e, 0x7119 },
	{ 0x604f, 0x711a },
	{ 0x6050, 0x7126 },
	{ 0x6051, 0x7130 },
	{ 0x6052, 0x7121 },
	{ 0x6053, 0x7136 },
	{ 0x6054, 0x716e },
	{ 0x6055, 0x711c },
	{ 0x6056, 0x724c },
	{ 0x6057, 0x7284 },
	{ 0x6058, 0x7280 },
	{ 0x6059, 0x7336 },
	{ 0x605a, 0x7325 },
	{ 0x605b, 0x7334 },
	{ 0x605c, 0x7329 },
	{ 0x605d, 0x743a },
	{ 0x605e, 0x742a },
	{ 0x605f, 0x7433 },
	{ 0x6060, 0x7422 },
	{ 0x6061, 0x7425 },
	{ 0x6062, 0x7435 },
	{ 0x6063, 0x7436 },
	{ 0x6064, 0x7434 },
	{ 0x6065, 0x742f },
	{ 0x6066, 0x741b },
	{ 0x6067, 0x7426 },
	{ 0x6068, 0x7428 },
	{ 0x6069, 0x7525 },
	{ 0x606a, 0x7526 },
	{ 0x606b, 0x756b },
	{ 0x606c, 0x756a },
	{ 0x606d, 0x75e2 },
	{ 0x606e, 0x75db },
	{ 0x606f, 0x75e3 },
	{ 0x6070, 0x75d9 },
	{ 0x6071, 0x75d8 },
	{ 0x6072, 0x75de },
	{ 0x6073, 0x75e0 },
	{ 0x6074, 0x767b },
	{ 0x6075, 0x767c },
	{ 0x6076, 0x7696 },
	{ 0x6077, 0x7693 },
	{ 0x6078, 0x76b4 },
	{ 0x6079, 0x76dc },
	{ 0x607a, 0x774f },
	{ 0x607b, 0x77ed },
	{ 0x607c, 0x785d },
	{ 0x607d, 0x786c },
	{ 0x607e, 0x786f },
	{ 0x6121, 0x7a0d },
	{ 0x6122, 0x7a08 },
	{ 0x6123, 0x7a0b },
	{ 0x6124, 0x7a05 },
	{ 0x6125, 0x7a00 },
	{ 0x6126, 0x7a98 },
	{ 0x6127, 0x7a97 },
	{ 0x6128, 0x7a96 },
	{ 0x6129, 0x7ae5 },
	{ 0x612a, 0x7ae3 },
	{ 0x612b, 0x7b49 },
	{ 0x612c, 0x7b56 },
	{ 0x612d, 0x7b46 },
	{ 0x612e, 0x7b50 },
	{ 0x612f, 0x7b52 },
	{ 0x6130, 0x7b54 },
	{ 0x6131, 0x7b4d },
	{ 0x6132, 0x7b4b },
	{ 0x6133, 0x7b4f },
	{ 0x6134, 0x7b51 },
	{ 0x6135, 0x7c9f },
	{ 0x6136, 0x7ca5 },
	{ 0x6137, 0x7d5e },
	{ 0x6138, 0x7d50 },
	{ 0x6139, 0x7d68 },
	{ 0x613a, 0x7d55 },
	{ 0x613b, 0x7d2b },
	{ 0x613c, 0x7d6e },
	{ 0x613d, 0x7d72 },
	{ 0x613e, 0x7d61 },
	{ 0x613f, 0x7d66 },
	{ 0x6140, 0x7d62 },
	{ 0x6141, 0x7d70 },
	{ 0x6142, 0x7d73 },
	{ 0x6143, 0x5584 },
	{ 0x6144, 0x7fd4 },
	{ 0x6145, 0x7fd5 },
	{ 0x6146, 0x800b },
	{ 0x6147, 0x8052 },
	{ 0x6148, 0x8085 },
	{ 0x6149, 0x8155 },
	{ 0x614a, 0x8154 },
	{ 0x614b, 0x814b },
	{ 0x614c, 0x8151 },
	{ 0x614d, 0x814e },
	{ 0x614e, 0x8139 },
	{ 0x614f, 0x8146 },
	{ 0x6150, 0x813e },
	{ 0x6151, 0x814c },
	{ 0x6152, 0x8153 },
	{ 0x6153, 0x8174 },
	{ 0x6154, 0x8212 },
	{ 0x6155, 0x821c },
	{ 0x6156, 0x83e9 },
	{ 0x6157, 0x8403 },
	{ 0x6158, 0x83f8 },
	{ 0x6159, 0x840d },
	{ 0x615a, 0x83e0 },
	{ 0x615b, 0x83c5 },
	{ 0x615c, 0x840b },
	{ 0x615d, 0x83c1 },
	{ 0x615e, 0x83ef },
	{ 0x615f, 0x83f1 },
	{ 0x6160, 0x83f4 },
	{ 0x6161, 0x8457 },
	{ 0x6162, 0x840a },
	{ 0x6163, 0x83f0 },
	{ 0x6164, 0x840c },
	{ 0x6165, 0x83cc },
	{ 0x6166, 0x83fd },
	{ 0x6167, 0x83f2 },
	{ 0x6168, 0x83ca },
	{ 0x6169, 0x8438 },
	{ 0x616a, 0x840e },
	{ 0x616b, 0x8404 },
	{ 0x616c, 0x83dc },
	{ 0x616d, 0x8407 },
	{ 0x616e, 0x83d4 },
	{ 0x616f, 0x83df },
	{ 0x6170, 0x865b },
	{ 0x6171, 0x86df },
	{ 0x6172, 0x86d9 },
	{ 0x6173, 0x86ed },
	{ 0x6174, 0x86d4 },
	{ 0x6175, 0x86db },
	{ 0x6176, 0x86e4 },
	{ 0x6177, 0x86d0 },
	{ 0x6178, 0x86de },
	{ 0x6179, 0x8857 },
	{ 0x617a, 0x88c1 },
	{ 0x617b, 0x88c2 },
	{ 0x617c, 0x88b1 },
	{ 0x617d, 0x8983 },
	{ 0x617e, 0x8996 },
	{ 0x6221, 0x8a3b },
	{ 0x6222, 0x8a60 },
	{ 0x6223, 0x8a55 },
	{ 0x6224, 0x8a5e },
	{ 0x6225, 0x8a3c },
	{ 0x6226, 0x8a41 },
	{ 0x6227, 0x8a54 },
	{ 0x6228, 0x8a5b },
	{ 0x6229, 0x8a50 },
	{ 0x622a, 0x8a46 },
	{ 0x622b, 0x8a34 },
	{ 0x622c, 0x8a3a },
	{ 0x622d, 0x8a36 },
	{ 0x622e, 0x8a56 },
	{ 0x622f, 0x8c61 },
	{ 0x6230, 0x8c82 },
	{ 0x6231, 0x8caf },
	{ 0x6232, 0x8cbc },
	{ 0x6233, 0x8cb3 },
	{ 0x6234, 0x8cbd },
	{ 0x6235, 0x8cc1 },
	{ 0x6236, 0x8cbb },
	{ 0x6237, 0x8cc0 },
	{ 0x6238, 0x8cb4 },
	{ 0x6239, 0x8cb7 },
	{ 0x623a, 0x8cb6 },
	{ 0x623b, 0x8cbf },
	{ 0x623c, 0x8cb8 },
	{ 0x623d, 0x8d8a },
	{ 0x623e, 0x8d85 },
	{ 0x623f, 0x8d81 },
	{ 0x6240, 0x8dce },
	{ 0x6241, 0x8ddd },
	{ 0x6242, 0x8dcb },
	{ 0x6243, 0x8dda },
	{ 0x6244, 0x8dd1 },
	{ 0x6245, 0x8dcc },
	{ 0x6246, 0x8ddb },
	{ 0x6247, 0x8dc6 },
	{ 0x6248, 0x8efb },
	{ 0x6249, 0x8ef8 },
	{ 0x624a, 0x8efc },
	{ 0x624b, 0x8f9c },
	{ 0x624c, 0x902e },
	{ 0x624d, 0x9035 },
	{ 0x624e, 0x9031 },
	{ 0x624f, 0x9038 },
	{ 0x6250, 0x9032 },
	{ 0x6251, 0x9036 },
	{ 0x6252, 0x9102 },
	{ 0x6253, 0x90f5 },
	{ 0x6254, 0x9109 },
	{ 0x6255, 0x90fe },
	{ 0x6256, 0x9163 },
	{ 0x6257, 0x9165 },
	{ 0x6258, 0x91cf },
	{ 0x6259, 0x9214 },
	{ 0x625a, 0x9215 },
	{ 0x625b, 0x9223 },
	{ 0x625c, 0x9209 },
	{ 0x625d, 0x921e },
	{ 0x625e, 0x920d },
	{ 0x625f, 0x9210 },
	{ 0x6260, 0x9207 },
	{ 0x6261, 0x9211 },
	{ 0x6262, 0x9594 },
	{ 0x6263, 0x958f },
	{ 0x6264, 0x958b },
	{ 0x6265, 0x9591 },
	{ 0x6266, 0x9593 },
	{ 0x6267, 0x9592 },
	{ 0x6268, 0x958e },
	{ 0x6269, 0x968a },
	{ 0x626a, 0x968e },
	{ 0x626b, 0x968b },
	{ 0x626c, 0x967d },
	{ 0x626d, 0x9685 },
	{ 0x626e, 0x9686 },
	{ 0x626f, 0x968d },
	{ 0x6270, 0x9672 },
	{ 0x6271, 0x9684 },
	{ 0x6272, 0x96c1 },
	{ 0x6273, 0x96c5 },
	{ 0x6274, 0x96c4 },
	{ 0x6275, 0x96c6 },
	{ 0x6276, 0x96c7 },
	{ 0x6277, 0x96ef },
	{ 0x6278, 0x96f2 },
	{ 0x6279, 0x97cc },
	{ 0x627a, 0x9805 },
	{ 0x627b, 0x9806 },
	{ 0x627c, 0x9808 },
	{ 0x627d, 0x98e7 },
	{ 0x627e, 0x98ea },
	{ 0x6321, 0x98ef },
	{ 0x6322, 0x98e9 },
	{ 0x6323, 0x98f2 },
	{ 0x6324, 0x98ed },
	{ 0x6325, 0x99ae },
	{ 0x6326, 0x99ad },
	{ 0x6327, 0x9ec3 },
	{ 0x6328, 0x9ecd },
	{ 0x6329, 0x9ed1 },
	{ 0x632a, 0x4e82 },
	{ 0x632b, 0x50ad },
	{ 0x632c, 0x50b5 },
	{ 0x632d, 0x50b2 },
	{ 0x632e, 0x50b3 },
	{ 0x632f, 0x50c5 },
	{ 0x6330, 0x50be },
	{ 0x6331, 0x50ac },
	{ 0x6332, 0x50b7 },
	{ 0x6333, 0x50bb },
	{ 0x6334, 0x50af },
	{ 0x6335, 0x50c7 },
	{ 0x6336, 0x527f },
	{ 0x6337, 0x5277 },
	{ 0x6338, 0x527d },
	{ 0x6339, 0x52df },
	{ 0x633a, 0x52e6 },
	{ 0x633b, 0x52e4 },
	{ 0x633c, 0x52e2 },
	{ 0x633d, 0x52e3 },
	{ 0x633e, 0x532f },
	{ 0x633f, 0x55df },
	{ 0x6340, 0x55e8 },
	{ 0x6341, 0x55d3 },
	{ 0x6342, 0x55e6 },
	{ 0x6343, 0x55ce },
	{ 0x6344, 0x55dc },
	{ 0x6345, 0x55c7 },
	{ 0x6346, 0x55d1 },
	{ 0x6347, 0x55e3 },
	{ 0x6348, 0x55e4 },
	{ 0x6349, 0x55ef },
	{ 0x634a, 0x55da },
	{ 0x634b, 0x55e1 },
	{ 0x634c, 0x55c5 },
	{ 0x634d, 0x55c6 },
	{ 0x634e, 0x55e5 },
	{ 0x634f, 0x55c9 },
	{ 0x6350, 0x5712 },
	{ 0x6351, 0x5713 },
	{ 0x6352, 0x585e },
	{ 0x6353, 0x5851 },
	{ 0x6354, 0x5858 },
	{ 0x6355, 0x5857 },
	{ 0x6356, 0x585a },
	{ 0x6357, 0x5854 },
	{ 0x6358, 0x586b },
	{ 0x6359, 0x584c },
	{ 0x635a, 0x586d },
	{ 0x635b, 0x584a },
	{ 0x635c, 0x5862 },
	{ 0x635d, 0x5852 },
	{ 0x635e, 0x584b },
	{ 0x635f, 0x5967 },
	{ 0x6360, 0x5ac1 },
	{ 0x6361, 0x5ac9 },
	{ 0x6362, 0x5acc },
	{ 0x6363, 0x5abe },
	{ 0x6364, 0x5abd },
	{ 0x6365, 0x5abc },
	{ 0x6366, 0x5ab3 },
	{ 0x6367, 0x5ac2 },
	{ 0x6368, 0x5ab2 },
	{ 0x6369, 0x5d69 },
	{ 0x636a, 0x5d6f },
	{ 0x636b, 0x5e4c },
	{ 0x636c, 0x5e79 },
	{ 0x636d, 0x5ec9 },
	{ 0x636e, 0x5ec8 },
	{ 0x636f, 0x5f12 },
	{ 0x6370, 0x5f59 },
	{ 0x6371, 0x5fac },
	{ 0x6372, 0x5fae },
	{ 0x6373, 0x611a },
	{ 0x6374, 0x610f },
	{ 0x6375, 0x6148 },
	{ 0x6376, 0x611f },
	{ 0x6377, 0x60f3 },
	{ 0x6378, 0x611b },
	{ 0x6379, 0x60f9 },
	{ 0x637a, 0x6101 },
	{ 0x637b, 0x6108 },
	{ 0x637c, 0x614e },
	{ 0x637d, 0x614c },
	{ 0x637e, 0x6144 },
	{ 0x6421, 0x614d },
	{ 0x6422, 0x613e },
	{ 0x6423, 0x6134 },
	{ 0x6424, 0x6127 },
	{ 0x6425, 0x610d },
	{ 0x6426, 0x6106 },
	{ 0x6427, 0x6137 },
	{ 0x6428, 0x6221 },
	{ 0x6429, 0x6222 },
	{ 0x642a, 0x6413 },
	{ 0x642b, 0x643e },
	{ 0x642c, 0x641e },
	{ 0x642d, 0x642a },
	{ 0x642e, 0x642d },
	{ 0x642f, 0x643d },
	{ 0x6430, 0x642c },
	{ 0x6431, 0x640f },
	{ 0x6432, 0x641c },
	{ 0x6433, 0x6414 },
	{ 0x6434, 0x640d },
	{ 0x6435, 0x6436 },
	{ 0x6436, 0x6416 },
	{ 0x6437, 0x6417 },
	{ 0x6438, 0x6406 },
	{ 0x6439, 0x656c },
	{ 0x643a, 0x659f },
	{ 0x643b, 0x65b0 },
	{ 0x643c, 0x6697 },
	{ 0x643d, 0x6689 },
	{ 0x643e, 0x6687 },
	{ 0x643f, 0x6688 },
	{ 0x6440, 0x6696 },
	{ 0x6441, 0x6684 },
	{ 0x6442, 0x6698 },
	{ 0x6443, 0x668d },
	{ 0x6444, 0x6703 },
	{ 0x6445, 0x6994 },
	{ 0x6446, 0x696d },
	{ 0x6447, 0x695a },
	{ 0x6448, 0x6977 },
	{ 0x6449, 0x6960 },
	{ 0x644a, 0x6954 },
	{ 0x644b, 0x6975 },
	{ 0x644c, 0x6930 },
	{ 0x644d, 0x6982 },
	{ 0x644e, 0x694a },
	{ 0x644f, 0x6968 },
	{ 0x6450, 0x696b },
	{ 0x6451, 0x695e },
	{ 0x6452, 0x6953 },
	{ 0x6453, 0x6979 },
	{ 0x6454, 0x6986 },
	{ 0x6455, 0x695d },
	{ 0x6456, 0x6963 },
	{ 0x6457, 0x695b },
	{ 0x6458, 0x6b47 },
	{ 0x6459, 0x6b72 },
	{ 0x645a, 0x6bc0 },
	{ 0x645b, 0x6bbf },
	{ 0x645c, 0x6bd3 },
	{ 0x645d, 0x6bfd },
	{ 0x645e, 0x6ea2 },
	{ 0x645f, 0x6eaf },
	{ 0x6460, 0x6ed3 },
	{ 0x6461, 0x6eb6 },
	{ 0x6462, 0x6ec2 },
	{ 0x6463, 0x6e90 },
	{ 0x6464, 0x6e9d },
	{ 0x6465, 0x6ec7 },
	{ 0x6466, 0x6ec5 },
	{ 0x6467, 0x6ea5 },
	{ 0x6468, 0x6e98 },
	{ 0x6469, 0x6ebc },
	{ 0x646a, 0x6eba },
	{ 0x646b, 0x6eab },
	{ 0x646c, 0x6ed1 },
	{ 0x646d, 0x6e96 },
	{ 0x646e, 0x6e9c },
	{ 0x646f, 0x6ec4 },
	{ 0x6470, 0x6ed4 },
	{ 0x6471, 0x6eaa },
	{ 0x6472, 0x6ea7 },
	{ 0x6473, 0x6eb4 },
	{ 0x6474, 0x714e },
	{ 0x6475, 0x7159 },
	{ 0x6476, 0x7169 },
	{ 0x6477, 0x7164 },
	{ 0x6478, 0x7149 },
	{ 0x6479, 0x7167 },
	{ 0x647a, 0x715c },
	{ 0x647b, 0x716c },
	{ 0x647c, 0x7166 },
	{ 0x647d, 0x714c },
	{ 0x647e, 0x7165 },
	{ 0x6521, 0x715e },
	{ 0x6522, 0x7146 },
	{ 0x6523, 0x7168 },
	{ 0x6524, 0x7156 },
	{ 0x6525, 0x723a },
	{ 0x6526, 0x7252 },
	{ 0x6527, 0x7337 },
	{ 0x6528, 0x7345 },
	{ 0x6529, 0x733f },
	{ 0x652a, 0x733e },
	{ 0x652b, 0x746f },
	{ 0x652c, 0x745a },
	{ 0x652d, 0x7455 },
	{ 0x652e, 0x745f },
	{ 0x652f, 0x745e },
	{ 0x6530, 0x7441 },
	{ 0x6531, 0x743f },
	{ 0x6532, 0x7459 },
	{ 0x6533, 0x745b },
	{ 0x6534, 0x745c },
	{ 0x6535, 0x7576 },
	{ 0x6536, 0x7578 },
	{ 0x6537, 0x7600 },
	{ 0x6538, 0x75f0 },
	{ 0x6539, 0x7601 },
	{ 0x653a, 0x75f2 },
	{ 0x653b, 0x75f1 },
	{ 0x653c, 0x75fa },
	{ 0x653d, 0x75ff },
	{ 0x653e, 0x75f4 },
	{ 0x653f, 0x75f3 },
	{ 0x6540, 0x76de },
	{ 0x6541, 0x76df },
	{ 0x6542, 0x775b },
	{ 0x6543, 0x776b },
	{ 0x6544, 0x7766 },
	{ 0x6545, 0x775e },
	{ 0x6546, 0x7763 },
	{ 0x6547, 0x7779 },
	{ 0x6548, 0x776a },
	{ 0x6549, 0x776c },
	{ 0x654a, 0x775c },
	{ 0x654b, 0x7765 },
	{ 0x654c, 0x7768 },
	{ 0x654d, 0x7762 },
	{ 0x654e, 0x77ee },
	{ 0x654f, 0x788e },
	{ 0x6550, 0x78b0 },
	{ 0x6551, 0x7897 },
	{ 0x6552, 0x7898 },
	{ 0x6553, 0x788c },
	{ 0x6554, 0x7889 },
	{ 0x6555, 0x787c },
	{ 0x6556, 0x7891 },
	{ 0x6557, 0x7893 },
	{ 0x6558, 0x787f },
	{ 0x6559, 0x797a },
	{ 0x655a, 0x797f },
	{ 0x655b, 0x7981 },
	{ 0x655c, 0x842c },
	{ 0x655d, 0x79bd },
	{ 0x655e, 0x7a1c },
	{ 0x655f, 0x7a1a },
	{ 0x6560, 0x7a20 },
	{ 0x6561, 0x7a14 },
	{ 0x6562, 0x7a1f },
	{ 0x6563, 0x7a1e },
	{ 0x6564, 0x7a9f },
	{ 0x6565, 0x7aa0 },
	{ 0x6566, 0x7b77 },
	{ 0x6567, 0x7bc0 },
	{ 0x6568, 0x7b60 },
	{ 0x6569, 0x7b6e },
	{ 0x656a, 0x7b67 },
	{ 0x656b, 0x7cb1 },
	{ 0x656c, 0x7cb3 },
	{ 0x656d, 0x7cb5 },
	{ 0x656e, 0x7d93 },
	{ 0x656f, 0x7d79 },
	{ 0x6570, 0x7d91 },
	{ 0x6571, 0x7d81 },
	{ 0x6572, 0x7d8f },
	{ 0x6573, 0x7d5b },
	{ 0x6574, 0x7f6e },
	{ 0x6575, 0x7f69 },
	{ 0x6576, 0x7f6a },
	{ 0x6577, 0x7f72 },
	{ 0x6578, 0x7fa9 },
	{ 0x6579, 0x7fa8 },
	{ 0x657a, 0x7fa4 },
	{ 0x657b, 0x8056 },
	{ 0x657c, 0x8058 },
	{ 0x657d, 0x8086 },
	{ 0x657e, 0x8084 },
	{ 0x6621, 0x8171 },
	{ 0x6622, 0x8170 },
	{ 0x6623, 0x8178 },
	{ 0x6624, 0x8165 },
	{ 0x6625, 0x816e },
	{ 0x6626, 0x8173 },
	{ 0x6627, 0x816b },
	{ 0x6628, 0x8179 },
	{ 0x6629, 0x817a },
	{ 0x662a, 0x8166 },
	{ 0x662b, 0x8205 },
	{ 0x662c, 0x8247 },
	{ 0x662d, 0x8482 },
	{ 0x662e, 0x8477 },
	{ 0x662f, 0x843d },
	{ 0x6630, 0x8431 },
	{ 0x6631, 0x8475 },
	{ 0x6632, 0x8466 },
	{ 0x6633, 0x846b },
	{ 0x6634, 0x8449 },
	{ 0x6635, 0x846c },
	{ 0x6636, 0x845b },
	{ 0x6637, 0x843c },
	{ 0x6638, 0x8435 },
	{ 0x6639, 0x8461 },
	{ 0x663a, 0x8463 },
	{ 0x663b, 0x8469 },
	{ 0x663c, 0x846d },
	{ 0x663d, 0x8446 },
	{ 0x663e, 0x865e },
	{ 0x663f, 0x865c },
	{ 0x6640, 0x865f },
	{ 0x6641, 0x86f9 },
	{ 0x6642, 0x8713 },
	{ 0x6643, 0x8708 },
	{ 0x6644, 0x8707 },
	{ 0x6645, 0x8700 },
	{ 0x6646, 0x86fe },
	{ 0x6647, 0x86fb },
	{ 0x6648, 0x8702 },
	{ 0x6649, 0x8703 },
	{ 0x664a, 0x8706 },
	{ 0x664b, 0x870a },
	{ 0x664c, 0x8859 },
	{ 0x664d, 0x88df },
	{ 0x664e, 0x88d4 },
	{ 0x664f, 0x88d9 },
	{ 0x6650, 0x88dc },
	{ 0x6651, 0x88d8 },
	{ 0x6652, 0x88dd },
	{ 0x6653, 0x88e1 },
	{ 0x6654, 0x88ca },
	{ 0x6655, 0x88d5 },
	{ 0x6656, 0x88d2 },
	{ 0x6657, 0x899c },
	{ 0x6658, 0x89e3 },
	{ 0x6659, 0x8a6b },
	{ 0x665a, 0x8a72 },
	{ 0x665b, 0x8a73 },
	{ 0x665c, 0x8a66 },
	{ 0x665d, 0x8a69 },
	{ 0x665e, 0x8a70 },
	{ 0x665f, 0x8a87 },
	{ 0x6660, 0x8a7c },
	{ 0x6661, 0x8a63 },
	{ 0x6662, 0x8aa0 },
	{ 0x6663, 0x8a71 },
	{ 0x6664, 0x8a85 },
	{ 0x6665, 0x8a6d },
	{ 0x6666, 0x8a62 },
	{ 0x6667, 0x8a6e },
	{ 0x6668, 0x8a6c },
	{ 0x6669, 0x8a79 },
	{ 0x666a, 0x8a7b },
	{ 0x666b, 0x8a3e },
	{ 0x666c, 0x8a68 },
	{ 0x666d, 0x8c62 },
	{ 0x666e, 0x8c8a },
	{ 0x666f, 0x8c89 },
	{ 0x6670, 0x8cca },
	{ 0x6671, 0x8cc7 },
	{ 0x6672, 0x8cc8 },
	{ 0x6673, 0x8cc4 },
	{ 0x6674, 0x8cb2 },
	{ 0x6675, 0x8cc3 },
	{ 0x6676, 0x8cc2 },
	{ 0x6677, 0x8cc5 },
	{ 0x6678, 0x8de1 },
	{ 0x6679, 0x8ddf },
	{ 0x667a, 0x8de8 },
	{ 0x667b, 0x8def },
	{ 0x667c, 0x8df3 },
	{ 0x667d, 0x8dfa },
	{ 0x667e, 0x8dea },
	{ 0x6721, 0x8de4 },
	{ 0x6722, 0x8de6 },
	{ 0x6723, 0x8eb2 },
	{ 0x6724, 0x8f03 },
	{ 0x6725, 0x8f09 },
	{ 0x6726, 0x8efe },
	{ 0x6727, 0x8f0a },
	{ 0x6728, 0x8f9f },
	{ 0x6729, 0x8fb2 },
	{ 0x672a, 0x904b },
	{ 0x672b, 0x904a },
	{ 0x672c, 0x9053 },
	{ 0x672d, 0x9042 },
	{ 0x672e, 0x9054 },
	{ 0x672f, 0x903c },
	{ 0x6730, 0x9055 },
	{ 0x6731, 0x9050 },
	{ 0x6732, 0x9047 },
	{ 0x6733, 0x904f },
	{ 0x6734, 0x904e },
	{ 0x6735, 0x904d },
	{ 0x6736, 0x9051 },
	{ 0x6737, 0x903e },
	{ 0x6738, 0x9041 },
	{ 0x6739, 0x9112 },
	{ 0x673a, 0x9117 },
	{ 0x673b, 0x916c },
	{ 0x673c, 0x916a },
	{ 0x673d, 0x9169 },
	{ 0x673e, 0x91c9 },
	{ 0x673f, 0x9237 },
	{ 0x6740, 0x9257 },
	{ 0x6741, 0x9238 },
	{ 0x6742, 0x923d },
	{ 0x6743, 0x9240 },
	{ 0x6744, 0x923e },
	{ 0x6745, 0x925b },
	{ 0x6746, 0x924b },
	{ 0x6747, 0x9264 },
	{ 0x6748, 0x9251 },
	{ 0x6749, 0x9234 },
	{ 0x674a, 0x9249 },
	{ 0x674b, 0x924d },
	{ 0x674c, 0x9245 },
	{ 0x674d, 0x9239 },
	{ 0x674e, 0x923f },
	{ 0x674f, 0x925a },
	{ 0x6750, 0x9598 },
	{ 0x6751, 0x9698 },
	{ 0x6752, 0x9694 },
	{ 0x6753, 0x9695 },
	{ 0x6754, 0x96cd },
	{ 0x6755, 0x96cb },
	{ 0x6756, 0x96c9 },
	{ 0x6757, 0x96ca },
	{ 0x6758, 0x96f7 },
	{ 0x6759, 0x96fb },
	{ 0x675a, 0x96f9 },
	{ 0x675b, 0x96f6 },
	{ 0x675c, 0x9756 },
	{ 0x675d, 0x9774 },
	{ 0x675e, 0x9776 },
	{ 0x675f, 0x9810 },
	{ 0x6760, 0x9811 },
	{ 0x6761, 0x9813 },
	{ 0x6762, 0x980a },
	{ 0x6763, 0x9812 },
	{ 0x6764, 0x980c },
	{ 0x6765, 0x98fc },
	{ 0x6766, 0x98f4 },
	{ 0x6767, 0x98fd },
	{ 0x6768, 0x98fe },
	{ 0x6769, 0x99b3 },
	{ 0x676a, 0x99b1 },
	{ 0x676b, 0x99b4 },
	{ 0x676c, 0x9ae1 },
	{ 0x676d, 0x9ce9 },
	{ 0x676e, 0x9e82 },
	{ 0x676f, 0x9f0e },
	{ 0x6770, 0x9f13 },
	{ 0x6771, 0x9f20 },
	{ 0x6772, 0x50e7 },
	{ 0x6773, 0x50ee },
	{ 0x6774, 0x50e5 },
	{ 0x6775, 0x50d6 },
	{ 0x6776, 0x50ed },
	{ 0x6777, 0x50da },
	{ 0x6778, 0x50d5 },
	{ 0x6779, 0x50cf },
	{ 0x677a, 0x50d1 },
	{ 0x677b, 0x50f1 },
	{ 0x677c, 0x50ce },
	{ 0x677d, 0x50e9 },
	{ 0x677e, 0x5162 },
	{ 0x6821, 0x51f3 },
	{ 0x6822, 0x5283 },
	{ 0x6823, 0x5282 },
	{ 0x6824, 0x5331 },
	{ 0x6825, 0x53ad },
	{ 0x6826, 0x55fe },
	{ 0x6827, 0x5600 },
	{ 0x6828, 0x561b },
	{ 0x6829, 0x5617 },
	{ 0x682a, 0x55fd },
	{ 0x682b, 0x5614 },
	{ 0x682c, 0x5606 },
	{ 0x682d, 0x5609 },
	{ 0x682e, 0x560d },
	{ 0x682f, 0x560e },
	{ 0x6830, 0x55f7 },
	{ 0x6831, 0x5616 },
	{ 0x6832, 0x561f },
	{ 0x6833, 0x5608 },
	{ 0x6834, 0x5610 },
	{ 0x6835, 0x55f6 },
	{ 0x6836, 0x5718 },
	{ 0x6837, 0x5716 },
	{ 0x6838, 0x5875 },
	{ 0x6839, 0x587e },
	{ 0x683a, 0x5883 },
	{ 0x683b, 0x5893 },
	{ 0x683c, 0x588a },
	{ 0x683d, 0x5879 },
	{ 0x683e, 0x5885 },
	{ 0x683f, 0x587d },
	{ 0x6840, 0x58fd },
	{ 0x6841, 0x5925 },
	{ 0x6842, 0x5922 },
	{ 0x6843, 0x5924 },
	{ 0x6844, 0x596a },
	{ 0x6845, 0x5969 },
	{ 0x6846, 0x5ae1 },
	{ 0x6847, 0x5ae6 },
	{ 0x6848, 0x5ae9 },
	{ 0x6849, 0x5ad7 },
	{ 0x684a, 0x5ad6 },
	{ 0x684b, 0x5ad8 },
	{ 0x684c, 0x5ae3 },
	{ 0x684d, 0x5b75 },
	{ 0x684e, 0x5bde },
	{ 0x684f, 0x5be7 },
	{ 0x6850, 0x5be1 },
	{ 0x6851, 0x5be5 },
	{ 0x6852, 0x5be6 },
	{ 0x6853, 0x5be8 },
	{ 0x6854, 0x5be2 },
	{ 0x6855, 0x5be4 },
	{ 0x6856, 0x5bdf },
	{ 0x6857, 0x5c0d },
	{ 0x6858, 0x5c62 },
	{ 0x6859, 0x5d84 },
	{ 0x685a, 0x5d87 },
	{ 0x685b, 0x5e5b },
	{ 0x685c, 0x5e63 },
	{ 0x685d, 0x5e55 },
	{ 0x685e, 0x5e57 },
	{ 0x685f, 0x5e54 },
	{ 0x6860, 0x5ed3 },
	{ 0x6861, 0x5ed6 },
	{ 0x6862, 0x5f0a },
	{ 0x6863, 0x5f46 },
	{ 0x6864, 0x5f70 },
	{ 0x6865, 0x5fb9 },
	{ 0x6866, 0x6147 },
	{ 0x6867, 0x613f },
	{ 0x6868, 0x614b },
	{ 0x6869, 0x6177 },
	{ 0x686a, 0x6162 },
	{ 0x686b, 0x6163 },
	{ 0x686c, 0x615f },
	{ 0x686d, 0x615a },
	{ 0x686e, 0x6158 },
	{ 0x686f, 0x6175 },
	{ 0x6870, 0x622a },
	{ 0x6871, 0x6487 },
	{ 0x6872, 0x6458 },
	{ 0x6873, 0x6454 },
	{ 0x6874, 0x64a4 },
	{ 0x6875, 0x6478 },
	{ 0x6876, 0x645f },
	{ 0x6877, 0x647a },
	{ 0x6878, 0x6451 },
	{ 0x6879, 0x6467 },
	{ 0x687a, 0x6434 },
	{ 0x687b, 0x646d },
	{ 0x687c, 0x647b },
	{ 0x687d, 0x6572 },
	{ 0x687e, 0x65a1 },
	{ 0x6921, 0x65d7 },
	{ 0x6922, 0x65d6 },
	{ 0x6923, 0x66a2 },
	{ 0x6924, 0x66a8 },
	{ 0x6925, 0x669d },
	{ 0x6926, 0x699c },
	{ 0x6927, 0x69a8 },
	{ 0x6928, 0x6995 },
	{ 0x6929, 0x69c1 },
	{ 0x692a, 0x69ae },
	{ 0x692b, 0x69d3 },
	{ 0x692c, 0x69cb },
	{ 0x692d, 0x699b },
	{ 0x692e, 0x69b7 },
	{ 0x692f, 0x69bb },
	{ 0x6930, 0x69ab },
	{ 0x6931, 0x69b4 },
	{ 0x6932, 0x69d0 },
	{ 0x6933, 0x69cd },
	{ 0x6934, 0x69ad },
	{ 0x6935, 0x69cc },
	{ 0x6936, 0x69a6 },
	{ 0x6937, 0x69c3 },
	{ 0x6938, 0x69a3 },
	{ 0x6939, 0x6b49 },
	{ 0x693a, 0x6b4c },
	{ 0x693b, 0x6c33 },
	{ 0x693c, 0x6f33 },
	{ 0x693d, 0x6f14 },
	{ 0x693e, 0x6efe },
	{ 0x693f, 0x6f13 },
	{ 0x6940, 0x6ef4 },
	{ 0x6941, 0x6f29 },
	{ 0x6942, 0x6f3e },
	{ 0x6943, 0x6f20 },
	{ 0x6944, 0x6f2c },
	{ 0x6945, 0x6f0f },
	{ 0x6946, 0x6f02 },
	{ 0x6947, 0x6f22 },
	{ 0x6948, 0x6eff },
	{ 0x6949, 0x6eef },
	{ 0x694a, 0x6f06 },
	{ 0x694b, 0x6f31 },
	{ 0x694c, 0x6f38 },
	{ 0x694d, 0x6f32 },
	{ 0x694e, 0x6f23 },
	{ 0x694f, 0x6f15 },
	{ 0x6950, 0x6f2b },
	{ 0x6951, 0x6f2f },
	{ 0x6952, 0x6f88 },
	{ 0x6953, 0x6f2a },
	{ 0x6954, 0x6eec },
	{ 0x6955, 0x6f01 },
	{ 0x6956, 0x6ef2 },
	{ 0x6957, 0x6ecc },
	{ 0x6958, 0x6ef7 },
	{ 0x6959, 0x7194 },
	{ 0x695a, 0x7199 },
	{ 0x695b, 0x717d },
	{ 0x695c, 0x718a },
	{ 0x695d, 0x7184 },
	{ 0x695e, 0x7192 },
	{ 0x695f, 0x723e },
	{ 0x6960, 0x7292 },
	{ 0x6961, 0x7296 },
	{ 0x6962, 0x7344 },
	{ 0x6963, 0x7350 },
	{ 0x6964, 0x7464 },
	{ 0x6965, 0x7463 },
	{ 0x6966, 0x746a },
	{ 0x6967, 0x7470 },
	{ 0x6968, 0x746d },
	{ 0x6969, 0x7504 },
	{ 0x696a, 0x7591 },
	{ 0x696b, 0x7627 },
	{ 0x696c, 0x760d },
	{ 0x696d, 0x760b },
	{ 0x696e, 0x7609 },
	{ 0x696f, 0x7613 },
	{ 0x6970, 0x76e1 },
	{ 0x6971, 0x76e3 },
	{ 0x6972, 0x7784 },
	{ 0x6973, 0x777d },
	{ 0x6974, 0x777f },
	{ 0x6975, 0x7761 },
	{ 0x6976, 0x78c1 },
	{ 0x6977, 0x789f },
	{ 0x6978, 0x78a7 },
	{ 0x6979, 0x78b3 },
	{ 0x697a, 0x78a9 },
	{ 0x697b, 0x78a3 },
	{ 0x697c, 0x798e },
	{ 0x697d, 0x798f },
	{ 0x697e, 0x798d },
	{ 0x6a21, 0x7a2e },
	{ 0x6a22, 0x7a31 },
	{ 0x6a23, 0x7aaa },
	{ 0x6a24, 0x7aa9 },
	{ 0x6a25, 0x7aed },
	{ 0x6a26, 0x7aef },
	{ 0x6a27, 0x7ba1 },
	{ 0x6a28, 0x7b95 },
	{ 0x6a29, 0x7b8b },
	{ 0x6a2a, 0x7b75 },
	{ 0x6a2b, 0x7b97 },
	{ 0x6a2c, 0x7b9d },
	{ 0x6a2d, 0x7b94 },
	{ 0x6a2e, 0x7b8f },
	{ 0x6a2f, 0x7bb8 },
	{ 0x6a30, 0x7b87 },
	{ 0x6a31, 0x7b84 },
	{ 0x6a32, 0x7cb9 },
	{ 0x6a33, 0x7cbd },
	{ 0x6a34, 0x7cbe },
	{ 0x6a35, 0x7dbb },
	{ 0x6a36, 0x7db0 },
	{ 0x6a37, 0x7d9c },
	{ 0x6a38, 0x7dbd },
	{ 0x6a39, 0x7dbe },
	{ 0x6a3a, 0x7da0 },
	{ 0x6a3b, 0x7dca },
	{ 0x6a3c, 0x7db4 },
	{ 0x6a3d, 0x7db2 },
	{ 0x6a3e, 0x7db1 },
	{ 0x6a3f, 0x7dba },
	{ 0x6a40, 0x7da2 },
	{ 0x6a41, 0x7dbf },
	{ 0x6a42, 0x7db5 },
	{ 0x6a43, 0x7db8 },
	{ 0x6a44, 0x7dad },
	{ 0x6a45, 0x7dd2 },
	{ 0x6a46, 0x7dc7 },
	{ 0x6a47, 0x7dac },
	{ 0x6a48, 0x7f70 },
	{ 0x6a49, 0x7fe0 },
	{ 0x6a4a, 0x7fe1 },
	{ 0x6a4b, 0x7fdf },
	{ 0x6a4c, 0x805e },
	{ 0x6a4d, 0x805a },
	{ 0x6a4e, 0x8087 },
	{ 0x6a4f, 0x8150 },
	{ 0x6a50, 0x8180 },
	{ 0x6a51, 0x818f },
	{ 0x6a52, 0x8188 },
	{ 0x6a53, 0x818a },
	{ 0x6a54, 0x817f },
	{ 0x6a55, 0x8182 },
	{ 0x6a56, 0x81e7 },
	{ 0x6a57, 0x81fa },
	{ 0x6a58, 0x8207 },
	{ 0x6a59, 0x8214 },
	{ 0x6a5a, 0x821e },
	{ 0x6a5b, 0x824b },
	{ 0x6a5c, 0x84c9 },
	{ 0x6a5d, 0x84bf },
	{ 0x6a5e, 0x84c6 },
	{ 0x6a5f, 0x84c4 },
	{ 0x6a60, 0x8499 },
	{ 0x6a61, 0x849e },
	{ 0x6a62, 0x84b2 },
	{ 0x6a63, 0x849c },
	{ 0x6a64, 0x84cb },
	{ 0x6a65, 0x84b8 },
	{ 0x6a66, 0x84c0 },
	{ 0x6a67, 0x84d3 },
	{ 0x6a68, 0x8490 },
	{ 0x6a69, 0x84bc },
	{ 0x6a6a, 0x84d1 },
	{ 0x6a6b, 0x84ca },
	{ 0x6a6c, 0x873f },
	{ 0x6a6d, 0x871c },
	{ 0x6a6e, 0x873b },
	{ 0x6a6f, 0x8722 },
	{ 0x6a70, 0x8725 },
	{ 0x6a71, 0x8734 },
	{ 0x6a72, 0x8718 },
	{ 0x6a73, 0x8755 },
	{ 0x6a74, 0x8737 },
	{ 0x6a75, 0x8729 },
	{ 0x6a76, 0x88f3 },
	{ 0x6a77, 0x8902 },
	{ 0x6a78, 0x88f4 },
	{ 0x6a79, 0x88f9 },
	{ 0x6a7a, 0x88f8 },
	{ 0x6a7b, 0x88fd },
	{ 0x6a7c, 0x88e8 },
	{ 0x6a7d, 0x891a },
	{ 0x6a7e, 0x88ef },
	{ 0x6b21, 0x8aa6 },
	{ 0x6b22, 0x8a8c },
	{ 0x6b23, 0x8a9e },
	{ 0x6b24, 0x8aa3 },
	{ 0x6b25, 0x8a8d },
	{ 0x6b26, 0x8aa1 },
	{ 0x6b27, 0x8a93 },
	{ 0x6b28, 0x8aa4 },
	{ 0x6b29, 0x8aaa },
	{ 0x6b2a, 0x8aa5 },
	{ 0x6b2b, 0x8aa8 },
	{ 0x6b2c, 0x8a98 },
	{ 0x6b2d, 0x8a91 },
	{ 0x6b2e, 0x8a9a },
	{ 0x6b2f, 0x8aa7 },
	{ 0x6b30, 0x8c6a },
	{ 0x6b31, 0x8c8d },
	{ 0x6b32, 0x8c8c },
	{ 0x6b33, 0x8cd3 },
	{ 0x6b34, 0x8cd1 },
	{ 0x6b35, 0x8cd2 },
	{ 0x6b36, 0x8d6b },
	{ 0x6b37, 0x8d99 },
	{ 0x6b38, 0x8d95 },
	{ 0x6b39, 0x8dfc },
	{ 0x6b3a, 0x8f14 },
	{ 0x6b3b, 0x8f12 },
	{ 0x6b3c, 0x8f15 },
	{ 0x6b3d, 0x8f13 },
	{ 0x6b3e, 0x8fa3 },
	{ 0x6b3f, 0x9060 },
	{ 0x6b40, 0x9058 },
	{ 0x6b41, 0x905c },
	{ 0x6b42, 0x9063 },
	{ 0x6b43, 0x9059 },
	{ 0x6b44, 0x905e },
	{ 0x6b45, 0x9062 },
	{ 0x6b46, 0x905d },
	{ 0x6b47, 0x905b },
	{ 0x6b48, 0x9119 },
	{ 0x6b49, 0x9118 },
	{ 0x6b4a, 0x911e },
	{ 0x6b4b, 0x9175 },
	{ 0x6b4c, 0x9178 },
	{ 0x6b4d, 0x9177 },
	{ 0x6b4e, 0x9174 },
	{ 0x6b4f, 0x9278 },
	{ 0x6b50, 0x92ac },
	{ 0x6b51, 0x9280 },
	{ 0x6b52, 0x9285 },
	{ 0x6b53, 0x9298 },
	{ 0x6b54, 0x9296 },
	{ 0x6b55, 0x927b },
	{ 0x6b56, 0x9293 },
	{ 0x6b57, 0x929c },
	{ 0x6b58, 0x92a8 },
	{ 0x6b59, 0x927c },
	{ 0x6b5a, 0x9291 },
	{ 0x6b5b, 0x95a1 },
	{ 0x6b5c, 0x95a8 },
	{ 0x6b5d, 0x95a9 },
	{ 0x6b5e, 0x95a3 },
	{ 0x6b5f, 0x95a5 },
	{ 0x6b60, 0x95a4 },
	{ 0x6b61, 0x9699 },
	{ 0x6b62, 0x969c },
	{ 0x6b63, 0x969b },
	{ 0x6b64, 0x96cc },
	{ 0x6b65, 0x96d2 },
	{ 0x6b66, 0x9700 },
	{ 0x6b67, 0x977c },
	{ 0x6b68, 0x9785 },
	{ 0x6b69, 0x97f6 },
	{ 0x6b6a, 0x9817 },
	{ 0x6b6b, 0x9818 },
	{ 0x6b6c, 0x98af },
	{ 0x6b6d, 0x98b1 },
	{ 0x6b6e, 0x9903 },
	{ 0x6b6f, 0x9905 },
	{ 0x6b70, 0x990c },
	{ 0x6b71, 0x9909 },
	{ 0x6b72, 0x99c1 },
	{ 0x6b73, 0x9aaf },
	{ 0x6b74, 0x9ab0 },
	{ 0x6b75, 0x9ae6 },
	{ 0x6b76, 0x9b41 },
	{ 0x6b77, 0x9b42 },
	{ 0x6b78, 0x9cf4 },
	{ 0x6b79, 0x9cf6 },
	{ 0x6b7a, 0x9cf3 },
	{ 0x6b7b, 0x9ebc },
	{ 0x6b7c, 0x9f3b },
	{ 0x6b7d, 0x9f4a },
	{ 0x6b7e, 0x5104 },
	{ 0x6c21, 0x5100 },
	{ 0x6c22, 0x50fb },
	{ 0x6c23, 0x50f5 },
	{ 0x6c24, 0x50f9 },
	{ 0x6c25, 0x5102 },
	{ 0x6c26, 0x5108 },
	{ 0x6c27, 0x5109 },
	{ 0x6c28, 0x5105 },
	{ 0x6c29, 0x51dc },
	{ 0x6c2a, 0x5287 },
	{ 0x6c2b, 0x5288 },
	{ 0x6c2c, 0x5289 },
	{ 0x6c2d, 0x528d },
	{ 0x6c2e, 0x528a },
	{ 0x6c2f, 0x52f0 },
	{ 0x6c30, 0x53b2 },
	{ 0x6c31, 0x562e },
	{ 0x6c32, 0x563b },
	{ 0x6c33, 0x5639 },
	{ 0x6c34, 0x5632 },
	{ 0x6c35, 0x563f },
	{ 0x6c36, 0x5634 },
	{ 0x6c37, 0x5629 },
	{ 0x6c38, 0x5653 },
	{ 0x6c39, 0x564e },
	{ 0x6c3a, 0x5657 },
	{ 0x6c3b, 0x5674 },
	{ 0x6c3c, 0x5636 },
	{ 0x6c3d, 0x562f },
	{ 0x6c3e, 0x5630 },
	{ 0x6c3f, 0x5880 },
	{ 0x6c40, 0x589f },
	{ 0x6c41, 0x589e },
	{ 0x6c42, 0x58b3 },
	{ 0x6c43, 0x589c },
	{ 0x6c44, 0x58ae },
	{ 0x6c45, 0x58a9 },
	{ 0x6c46, 0x58a6 },
	{ 0x6c47, 0x596d },
	{ 0x6c48, 0x5b09 },
	{ 0x6c49, 0x5afb },
	{ 0x6c4a, 0x5b0b },
	{ 0x6c4b, 0x5af5 },
	{ 0x6c4c, 0x5b0c },
	{ 0x6c4d, 0x5b08 },
	{ 0x6c4e, 0x5bee },
	{ 0x6c4f, 0x5bec },
	{ 0x6c50, 0x5be9 },
	{ 0x6c51, 0x5beb },
	{ 0x6c52, 0x5c64 },
	{ 0x6c53, 0x5c65 },
	{ 0x6c54, 0x5d9d },
	{ 0x6c55, 0x5d94 },
	{ 0x6c56, 0x5e62 },
	{ 0x6c57, 0x5e5f },
	{ 0x6c58, 0x5e61 },
	{ 0x6c59, 0x5ee2 },
	{ 0x6c5a, 0x5eda },
	{ 0x6c5b, 0x5edf },
	{ 0x6c5c, 0x5edd },
	{ 0x6c5d, 0x5ee3 },
	{ 0x6c5e, 0x5ee0 },
	{ 0x6c5f, 0x5f48 },
	{ 0x6c60, 0x5f71 },
	{ 0x6c61, 0x5fb7 },
	{ 0x6c62, 0x5fb5 },
	{ 0x6c63, 0x6176 },
	{ 0x6c64, 0x6167 },
	{ 0x6c65, 0x616e },
	{ 0x6c66, 0x615d },
	{ 0x6c67, 0x6155 },
	{ 0x6c68, 0x6182 },
	{ 0x6c69, 0x617c },
	{ 0x6c6a, 0x6170 },
	{ 0x6c6b, 0x616b },
	{ 0x6c6c, 0x617e },
	{ 0x6c6d, 0x61a7 },
	{ 0x6c6e, 0x6190 },
	{ 0x6c6f, 0x61ab },
	{ 0x6c70, 0x618e },
	{ 0x6c71, 0x61ac },
	{ 0x6c72, 0x619a },
	{ 0x6c73, 0x61a4 },
	{ 0x6c74, 0x6194 },
	{ 0x6c75, 0x61ae },
	{ 0x6c76, 0x622e },
	{ 0x6c77, 0x6469 },
	{ 0x6c78, 0x646f },
	{ 0x6c79, 0x6479 },
	{ 0x6c7a, 0x649e },
	{ 0x6c7b, 0x64b2 },
	{ 0x6c7c, 0x6488 },
	{ 0x6c7d, 0x6490 },
	{ 0x6c7e, 0x64b0 },
	{ 0x6d21, 0x64a5 },
	{ 0x6d22, 0x6493 },
	{ 0x6d23, 0x6495 },
	{ 0x6d24, 0x64a9 },
	{ 0x6d25, 0x6492 },
	{ 0x6d26, 0x64ae },
	{ 0x6d27, 0x64ad },
	{ 0x6d28, 0x64ab },
	{ 0x6d29, 0x649a },
	{ 0x6d2a, 0x64ac },
	{ 0x6d2b, 0x6499 },
	{ 0x6d2c, 0x64a2 },
	{ 0x6d2d, 0x64b3 },
	{ 0x6d2e, 0x6575 },
	{ 0x6d2f, 0x6577 },
	{ 0x6d30, 0x6578 },
	{ 0x6d31, 0x66ae },
	{ 0x6d32, 0x66ab },
	{ 0x6d33, 0x66b4 },
	{ 0x6d34, 0x66b1 },
	{ 0x6d35, 0x6a23 },
	{ 0x6d36, 0x6a1f },
	{ 0x6d37, 0x69e8 },
	{ 0x6d38, 0x6a01 },
	{ 0x6d39, 0x6a1e },
	{ 0x6d3a, 0x6a19 },
	{ 0x6d3b, 0x69fd },
	{ 0x6d3c, 0x6a21 },
	{ 0x6d3d, 0x6a13 },
	{ 0x6d3e, 0x6a0a },
	{ 0x6d3f, 0x69f3 },
	{ 0x6d40, 0x6a02 },
	{ 0x6d41, 0x6a05 },
	{ 0x6d42, 0x69ed },
	{ 0x6d43, 0x6a11 },
	{ 0x6d44, 0x6b50 },
	{ 0x6d45, 0x6b4e },
	{ 0x6d46, 0x6ba4 },
	{ 0x6d47, 0x6bc5 },
	{ 0x6d48, 0x6bc6 },
	{ 0x6d49, 0x6f3f },
	{ 0x6d4a, 0x6f7c },
	{ 0x6d4b, 0x6f84 },
	{ 0x6d4c, 0x6f51 },
	{ 0x6d4d, 0x6f66 },
	{ 0x6d4e, 0x6f54 },
	{ 0x6d4f, 0x6f86 },
	{ 0x6d50, 0x6f6d },
	{ 0x6d51, 0x6f5b },
	{ 0x6d52, 0x6f78 },
	{ 0x6d53, 0x6f6e },
	{ 0x6d54, 0x6f8e },
	{ 0x6d55, 0x6f7a },
	{ 0x6d56, 0x6f70 },
	{ 0x6d57, 0x6f64 },
	{ 0x6d58, 0x6f97 },
	{ 0x6d59, 0x6f58 },
	{ 0x6d5a, 0x6ed5 },
	{ 0x6d5b, 0x6f6f },
	{ 0x6d5c, 0x6f60 },
	{ 0x6d5d, 0x6f5f },
	{ 0x6d5e, 0x719f },
	{ 0x6d5f, 0x71ac },
	{ 0x6d60, 0x71b1 },
	{ 0x6d61, 0x71a8 },
	{ 0x6d62, 0x7256 },
	{ 0x6d63, 0x729b },
	{ 0x6d64, 0x734e },
	{ 0x6d65, 0x7357 },
	{ 0x6d66, 0x7469 },
	{ 0x6d67, 0x748b },
	{ 0x6d68, 0x7483 },
	{ 0x6d69, 0x747e },
	{ 0x6d6a, 0x7480 },
	{ 0x6d6b, 0x757f },
	{ 0x6d6c, 0x7620 },
	{ 0x6d6d, 0x7629 },
	{ 0x6d6e, 0x761f },
	{ 0x6d6f, 0x7624 },
	{ 0x6d70, 0x7626 },
	{ 0x6d71, 0x7621 },
	{ 0x6d72, 0x7622 },
	{ 0x6d73, 0x769a },
	{ 0x6d74, 0x76ba },
	{ 0x6d75, 0x76e4 },
	{ 0x6d76, 0x778e },
	{ 0x6d77, 0x7787 },
	{ 0x6d78, 0x778c },
	{ 0x6d79, 0x7791 },
	{ 0x6d7a, 0x778b },
	{ 0x6d7b, 0x78cb },
	{ 0x6d7c, 0x78c5 },
	{ 0x6d7d, 0x78ba },
	{ 0x6d7e, 0x78ca },
	{ 0x6e21, 0x78be },
	{ 0x6e22, 0x78d5 },
	{ 0x6e23, 0x78bc },
	{ 0x6e24, 0x78d0 },
	{ 0x6e25, 0x7a3f },
	{ 0x6e26, 0x7a3c },
	{ 0x6e27, 0x7a40 },
	{ 0x6e28, 0x7a3d },
	{ 0x6e29, 0x7a37 },
	{ 0x6e2a, 0x7a3b },
	{ 0x6e2b, 0x7aaf },
	{ 0x6e2c, 0x7aae },
	{ 0x6e2d, 0x7bad },
	{ 0x6e2e, 0x7bb1 },
	{ 0x6e2f, 0x7bc4 },
	{ 0x6e30, 0x7bb4 },
	{ 0x6e31, 0x7bc6 },
	{ 0x6e32, 0x7bc7 },
	{ 0x6e33, 0x7bc1 },
	{ 0x6e34, 0x7ba0 },
	{ 0x6e35, 0x7bcc },
	{ 0x6e36, 0x7cca },
	{ 0x6e37, 0x7de0 },
	{ 0x6e38, 0x7df4 },
	{ 0x6e39, 0x7def },
	{ 0x6e3a, 0x7dfb },
	{ 0x6e3b, 0x7dd8 },
	{ 0x6e3c, 0x7dec },
	{ 0x6e3d, 0x7ddd },
	{ 0x6e3e, 0x7de8 },
	{ 0x6e3f, 0x7de3 },
	{ 0x6e40, 0x7dda },
	{ 0x6e41, 0x7dde },
	{ 0x6e42, 0x7de9 },
	{ 0x6e43, 0x7d9e },
	{ 0x6e44, 0x7dd9 },
	{ 0x6e45, 0x7df2 },
	{ 0x6e46, 0x7df9 },
	{ 0x6e47, 0x7f75 },
	{ 0x6e48, 0x7f77 },
	{ 0x6e49, 0x7faf },
	{ 0x6e4a, 0x7fe9 },
	{ 0x6e4b, 0x8026 },
	{ 0x6e4c, 0x819b },
	{ 0x6e4d, 0x819c },
	{ 0x6e4e, 0x819d },
	{ 0x6e4f, 0x81a0 },
	{ 0x6e50, 0x819a },
	{ 0x6e51, 0x8198 },
	{ 0x6e52, 0x8517 },
	{ 0x6e53, 0x853d },
	{ 0x6e54, 0x851a },
	{ 0x6e55, 0x84ee },
	{ 0x6e56, 0x852c },
	{ 0x6e57, 0x852d },
	{ 0x6e58, 0x8513 },
	{ 0x6e59, 0x8511 },
	{ 0x6e5a, 0x8523 },
	{ 0x6e5b, 0x8521 },
	{ 0x6e5c, 0x8514 },
	{ 0x6e5d, 0x84ec },
	{ 0x6e5e, 0x8525 },
	{ 0x6e5f, 0x84ff },
	{ 0x6e60, 0x8506 },
	{ 0x6e61, 0x8782 },
	{ 0x6e62, 0x8774 },
	{ 0x6e63, 0x8776 },
	{ 0x6e64, 0x8760 },
	{ 0x6e65, 0x8766 },
	{ 0x6e66, 0x8778 },
	{ 0x6e67, 0x8768 },
	{ 0x6e68, 0x8759 },
	{ 0x6e69, 0x8757 },
	{ 0x6e6a, 0x874c },
	{ 0x6e6b, 0x8753 },
	{ 0x6e6c, 0x885b },
	{ 0x6e6d, 0x885d },
	{ 0x6e6e, 0x8910 },
	{ 0x6e6f, 0x8907 },
	{ 0x6e70, 0x8912 },
	{ 0x6e71, 0x8913 },
	{ 0x6e72, 0x8915 },
	{ 0x6e73, 0x890a },
	{ 0x6e74, 0x8abc },
	{ 0x6e75, 0x8ad2 },
	{ 0x6e76, 0x8ac7 },
	{ 0x6e77, 0x8ac4 },
	{ 0x6e78, 0x8a95 },
	{ 0x6e79, 0x8acb },
	{ 0x6e7a, 0x8af8 },
	{ 0x6e7b, 0x8ab2 },
	{ 0x6e7c, 0x8ac9 },
	{ 0x6e7d, 0x8ac2 },
	{ 0x6e7e, 0x8abf },
	{ 0x6f21, 0x8ab0 },
	{ 0x6f22, 0x8ad6 },
	{ 0x6f23, 0x8acd },
	{ 0x6f24, 0x8ab6 },
	{ 0x6f25, 0x8ab9 },
	{ 0x6f26, 0x8adb },
	{ 0x6f27, 0x8c4c },
	{ 0x6f28, 0x8c4e },
	{ 0x6f29, 0x8c6c },
	{ 0x6f2a, 0x8ce0 },
	{ 0x6f2b, 0x8cde },
	{ 0x6f2c, 0x8ce6 },
	{ 0x6f2d, 0x8ce4 },
	{ 0x6f2e, 0x8cec },
	{ 0x6f2f, 0x8ced },
	{ 0x6f30, 0x8ce2 },
	{ 0x6f31, 0x8ce3 },
	{ 0x6f32, 0x8cdc },
	{ 0x6f33, 0x8cea },
	{ 0x6f34, 0x8ce1 },
	{ 0x6f35, 0x8d6d },
	{ 0x6f36, 0x8d9f },
	{ 0x6f37, 0x8da3 },
	{ 0x6f38, 0x8e2b },
	{ 0x6f39, 0x8e10 },
	{ 0x6f3a, 0x8e1d },
	{ 0x6f3b, 0x8e22 },
	{ 0x6f3c, 0x8e0f },
	{ 0x6f3d, 0x8e29 },
	{ 0x6f3e, 0x8e1f },
	{ 0x6f3f, 0x8e21 },
	{ 0x6f40, 0x8e1e },
	{ 0x6f41, 0x8eba },
	{ 0x6f42, 0x8f1d },
	{ 0x6f43, 0x8f1b },
	{ 0x6f44, 0x8f1f },
	{ 0x6f45, 0x8f29 },
	{ 0x6f46, 0x8f26 },
	{ 0x6f47, 0x8f2a },
	{ 0x6f48, 0x8f1c },
	{ 0x6f49, 0x8f1e },
	{ 0x6f4a, 0x8f25 },
	{ 0x6f4b, 0x9069 },
	{ 0x6f4c, 0x906e },
	{ 0x6f4d, 0x9068 },
	{ 0x6f4e, 0x906d },
	{ 0x6f4f, 0x9077 },
	{ 0x6f50, 0x9130 },
	{ 0x6f51, 0x912d },
	{ 0x6f52, 0x9127 },
	{ 0x6f53, 0x9131 },
	{ 0x6f54, 0x9187 },
	{ 0x6f55, 0x9189 },
	{ 0x6f56, 0x918b },
	{ 0x6f57, 0x9183 },
	{ 0x6f58, 0x92c5 },
	{ 0x6f59, 0x92bb },
	{ 0x6f5a, 0x92b7 },
	{ 0x6f5b, 0x92ea },
	{ 0x6f5c, 0x92e4 },
	{ 0x6f5d, 0x92c1 },
	{ 0x6f5e, 0x92b3 },
	{ 0x6f5f, 0x92bc },
	{ 0x6f60, 0x92d2 },
	{ 0x6f61, 0x92c7 },
	{ 0x6f62, 0x92f0 },
	{ 0x6f63, 0x92b2 },
	{ 0x6f64, 0x95ad },
	{ 0x6f65, 0x95b1 },
	{ 0x6f66, 0x9704 },
	{ 0x6f67, 0x9706 },
	{ 0x6f68, 0x9707 },
	{ 0x6f69, 0x9709 },
	{ 0x6f6a, 0x9760 },
	{ 0x6f6b, 0x978d },
	{ 0x6f6c, 0x978b },
	{ 0x6f6d, 0x978f },
	{ 0x6f6e, 0x9821 },
	{ 0x6f6f, 0x982b },
	{ 0x6f70, 0x981c },
	{ 0x6f71, 0x98b3 },
	{ 0x6f72, 0x990a },
	{ 0x6f73, 0x9913 },
	{ 0x6f74, 0x9912 },
	{ 0x6f75, 0x9918 },
	{ 0x6f76, 0x99dd },
	{ 0x6f77, 0x99d0 },
	{ 0x6f78, 0x99df },
	{ 0x6f79, 0x99db },
	{ 0x6f7a, 0x99d1 },
	{ 0x6f7b, 0x99d5 },
	{ 0x6f7c, 0x99d2 },
	{ 0x6f7d, 0x99d9 },
	{ 0x6f7e, 0x9ab7 },
	{ 0x7021, 0x9aee },
	{ 0x7022, 0x9aef },
	{ 0x7023, 0x9b27 },
	{ 0x7024, 0x9b45 },
	{ 0x7025, 0x9b44 },
	{ 0x7026, 0x9b77 },
	{ 0x7027, 0x9b6f },
	{ 0x7028, 0x9d06 },
	{ 0x7029, 0x9d09 },
	{ 0x702a, 0x9d03 },
	{ 0x702b, 0x9ea9 },
	{ 0x702c, 0x9ebe },
	{ 0x702d, 0x9ece },
	{ 0x702e, 0x58a8 },
	{ 0x702f, 0x9f52 },
	{ 0x7030, 0x5112 },
	{ 0x7031, 0x5118 },
	{ 0x7032, 0x5114 },
	{ 0x7033, 0x5110 },
	{ 0x7034, 0x5115 },
	{ 0x7035, 0x5180 },
	{ 0x7036, 0x51aa },
	{ 0x7037, 0x51dd },
	{ 0x7038, 0x5291 },
	{ 0x7039, 0x5293 },
	{ 0x703a, 0x52f3 },
	{ 0x703b, 0x5659 },
	{ 0x703c, 0x566b },
	{ 0x703d, 0x5679 },
	{ 0x703e, 0x5669 },
	{ 0x703f, 0x5664 },
	{ 0x7040, 0x5678 },
	{ 0x7041, 0x566a },
	{ 0x7042, 0x5668 },
	{ 0x7043, 0x5665 },
	{ 0x7044, 0x5671 },
	{ 0x7045, 0x566f },
	{ 0x7046, 0x566c },
	{ 0x7047, 0x5662 },
	{ 0x7048, 0x5676 },
	{ 0x7049, 0x58c1 },
	{ 0x704a, 0x58be },
	{ 0x704b, 0x58c7 },
	{ 0x704c, 0x58c5 },
	{ 0x704d, 0x596e },
	{ 0x704e, 0x5b1d },
	{ 0x704f, 0x5b34 },
	{ 0x7050, 0x5b78 },
	{ 0x7051, 0x5bf0 },
	{ 0x7052, 0x5c0e },
	{ 0x7053, 0x5f4a },
	{ 0x7054, 0x61b2 },
	{ 0x7055, 0x6191 },
	{ 0x7056, 0x61a9 },
	{ 0x7057, 0x618a },
	{ 0x7058, 0x61cd },
	{ 0x7059, 0x61b6 },
	{ 0x705a, 0x61be },
	{ 0x705b, 0x61ca },
	{ 0x705c, 0x61c8 },
	{ 0x705d, 0x6230 },
	{ 0x705e, 0x64c5 },
	{ 0x705f, 0x64c1 },
	{ 0x7060, 0x64cb },
	{ 0x7061, 0x64bb },
	{ 0x7062, 0x64bc },
	{ 0x7063, 0x64da },
	{ 0x7064, 0x64c4 },
	{ 0x7065, 0x64c7 },
	{ 0x7066, 0x64c2 },
	{ 0x7067, 0x64cd },
	{ 0x7068, 0x64bf },
	{ 0x7069, 0x64d2 },
	{ 0x706a, 0x64d4 },
	{ 0x706b, 0x64be },
	{ 0x706c, 0x6574 },
	{ 0x706d, 0x66c6 },
	{ 0x706e, 0x66c9 },
	{ 0x706f, 0x66b9 },
	{ 0x7070, 0x66c4 },
	{ 0x7071, 0x66c7 },
	{ 0x7072, 0x66b8 },
	{ 0x7073, 0x6a3d },
	{ 0x7074, 0x6a38 },
	{ 0x7075, 0x6a3a },
	{ 0x7076, 0x6a59 },
	{ 0x7077, 0x6a6b },
	{ 0x7078, 0x6a58 },
	{ 0x7079, 0x6a39 },
	{ 0x707a, 0x6a44 },
	{ 0x707b, 0x6a62 },
	{ 0x707c, 0x6a61 },
	{ 0x707d, 0x6a4b },
	{ 0x707e, 0x6a47 },
	{ 0x7121, 0x6a35 },
	{ 0x7122, 0x6a5f },
	{ 0x7123, 0x6a48 },
	{ 0x7124, 0x6b59 },
	{ 0x7125, 0x6b77 },
	{ 0x7126, 0x6c05 },
	{ 0x7127, 0x6fc2 },
	{ 0x7128, 0x6fb1 },
	{ 0x7129, 0x6fa1 },
	{ 0x712a, 0x6fc3 },
	{ 0x712b, 0x6fa4 },
	{ 0x712c, 0x6fc1 },
	{ 0x712d, 0x6fa7 },
	{ 0x712e, 0x6fb3 },
	{ 0x712f, 0x6fc0 },
	{ 0x7130, 0x6fb9 },
	{ 0x7131, 0x6fb6 },
	{ 0x7132, 0x6fa6 },
	{ 0x7133, 0x6fa0 },
	{ 0x7134, 0x6fb4 },
	{ 0x7135, 0x71be },
	{ 0x7136, 0x71c9 },
	{ 0x7137, 0x71d0 },
	{ 0x7138, 0x71d2 },
	{ 0x7139, 0x71c8 },
	{ 0x713a, 0x71d5 },
	{ 0x713b, 0x71b9 },
	{ 0x713c, 0x71ce },
	{ 0x713d, 0x71d9 },
	{ 0x713e, 0x71dc },
	{ 0x713f, 0x71c3 },
	{ 0x7140, 0x71c4 },
	{ 0x7141, 0x7368 },
	{ 0x7142, 0x749c },
	{ 0x7143, 0x74a3 },
	{ 0x7144, 0x7498 },
	{ 0x7145, 0x749f },
	{ 0x7146, 0x749e },
	{ 0x7147, 0x74e2 },
	{ 0x7148, 0x750c },
	{ 0x7149, 0x750d },
	{ 0x714a, 0x7634 },
	{ 0x714b, 0x7638 },
	{ 0x714c, 0x763a },
	{ 0x714d, 0x76e7 },
	{ 0x714e, 0x76e5 },
	{ 0x714f, 0x77a0 },
	{ 0x7150, 0x779e },
	{ 0x7151, 0x779f },
	{ 0x7152, 0x77a5 },
	{ 0x7153, 0x78e8 },
	{ 0x7154, 0x78da },
	{ 0x7155, 0x78ec },
	{ 0x7156, 0x78e7 },
	{ 0x7157, 0x79a6 },
	{ 0x7158, 0x7a4d },
	{ 0x7159, 0x7a4e },
	{ 0x715a, 0x7a46 },
	{ 0x715b, 0x7a4c },
	{ 0x715c, 0x7a4b },
	{ 0x715d, 0x7aba },
	{ 0x715e, 0x7bd9 },
	{ 0x715f, 0x7c11 },
	{ 0x7160, 0x7bc9 },
	{ 0x7161, 0x7be4 },
	{ 0x7162, 0x7bdb },
	{ 0x7163, 0x7be1 },
	{ 0x7164, 0x7be9 },
	{ 0x7165, 0x7be6 },
	{ 0x7166, 0x7cd5 },
	{ 0x7167, 0x7cd6 },
	{ 0x7168, 0x7e0a },
	{ 0x7169, 0x7e11 },
	{ 0x716a, 0x7e08 },
	{ 0x716b, 0x7e1b },
	{ 0x716c, 0x7e23 },
	{ 0x716d, 0x7e1e },
	{ 0x716e, 0x7e1d },
	{ 0x716f, 0x7e09 },
	{ 0x7170, 0x7e10 },
	{ 0x7171, 0x7f79 },
	{ 0x7172, 0x7fb2 },
	{ 0x7173, 0x7ff0 },
	{ 0x7174, 0x7ff1 },
	{ 0x7175, 0x7fee },
	{ 0x7176, 0x8028 },
	{ 0x7177, 0x81b3 },
	{ 0x7178, 0x81a9 },
	{ 0x7179, 0x81a8 },
	{ 0x717a, 0x81fb },
	{ 0x717b, 0x8208 },
	{ 0x717c, 0x8258 },
	{ 0x717d, 0x8259 },
	{ 0x717e, 0x854a },
	{ 0x7221, 0x8559 },
	{ 0x7222, 0x8548 },
	{ 0x7223, 0x8568 },
	{ 0x7224, 0x8569 },
	{ 0x7225, 0x8543 },
	{ 0x7226, 0x8549 },
	{ 0x7227, 0x856d },
	{ 0x7228, 0x856a },
	{ 0x7229, 0x855e },
	{ 0x722a, 0x8783 },
	{ 0x722b, 0x879f },
	{ 0x722c, 0x879e },
	{ 0x722d, 0x87a2 },
	{ 0x722e, 0x878d },
	{ 0x722f, 0x8861 },
	{ 0x7230, 0x892a },
	{ 0x7231, 0x8932 },
	{ 0x7232, 0x8925 },
	{ 0x7233, 0x892b },
	{ 0x7234, 0x8921 },
	{ 0x7235, 0x89aa },
	{ 0x7236, 0x89a6 },
	{ 0x7237, 0x8ae6 },
	{ 0x7238, 0x8afa },
	{ 0x7239, 0x8aeb },
	{ 0x723a, 0x8af1 },
	{ 0x723b, 0x8b00 },
	{ 0x723c, 0x8adc },
	{ 0x723d, 0x8ae7 },
	{ 0x723e, 0x8aee },
	{ 0x723f, 0x8afe },
	{ 0x7240, 0x8b01 },
	{ 0x7241, 0x8b02 },
	{ 0x7242, 0x8af7 },
	{ 0x7243, 0x8aed },
	{ 0x7244, 0x8af3 },
	{ 0x7245, 0x8af6 },
	{ 0x7246, 0x8afc },
	{ 0x7247, 0x8c6b },
	{ 0x7248, 0x8c6d },
	{ 0x7249, 0x8c93 },
	{ 0x724a, 0x8cf4 },
	{ 0x724b, 0x8e44 },
	{ 0x724c, 0x8e31 },
	{ 0x724d, 0x8e34 },
	{ 0x724e, 0x8e42 },
	{ 0x724f, 0x8e39 },
	{ 0x7250, 0x8e35 },
	{ 0x7251, 0x8f3b },
	{ 0x7252, 0x8f2f },
	{ 0x7253, 0x8f38 },
	{ 0x7254, 0x8f33 },
	{ 0x7255, 0x8fa8 },
	{ 0x7256, 0x8fa6 },
	{ 0x7257, 0x9075 },
	{ 0x7258, 0x9074 },
	{ 0x7259, 0x9078 },
	{ 0x725a, 0x9072 },
	{ 0x725b, 0x907c },
	{ 0x725c, 0x907a },
	{ 0x725d, 0x9134 },
	{ 0x725e, 0x9192 },
	{ 0x725f, 0x9320 },
	{ 0x7260, 0x9336 },
	{ 0x7261, 0x92f8 },
	{ 0x7262, 0x9333 },
	{ 0x7263, 0x932f },
	{ 0x7264, 0x9322 },
	{ 0x7265, 0x92fc },
	{ 0x7266, 0x932b },
	{ 0x7267, 0x9304 },
	{ 0x7268, 0x931a },
	{ 0x7269, 0x9310 },
	{ 0x726a, 0x9326 },
	{ 0x726b, 0x9321 },
	{ 0x726c, 0x9315 },
	{ 0x726d, 0x932e },
	{ 0x726e, 0x9319 },
	{ 0x726f, 0x95bb },
	{ 0x7270, 0x96a7 },
	{ 0x7271, 0x96a8 },
	{ 0x7272, 0x96aa },
	{ 0x7273, 0x96d5 },
	{ 0x7274, 0x970e },
	{ 0x7275, 0x9711 },
	{ 0x7276, 0x9716 },
	{ 0x7277, 0x970d },
	{ 0x7278, 0x9713 },
	{ 0x7279, 0x970f },
	{ 0x727a, 0x975b },
	{ 0x727b, 0x975c },
	{ 0x727c, 0x9766 },
	{ 0x727d, 0x9798 },
	{ 0x727e, 0x9830 },
	{ 0x7321, 0x9838 },
	{ 0x7322, 0x983b },
	{ 0x7323, 0x9837 },
	{ 0x7324, 0x982d },
	{ 0x7325, 0x9839 },
	{ 0x7326, 0x9824 },
	{ 0x7327, 0x9910 },
	{ 0x7328, 0x9928 },
	{ 0x7329, 0x991e },
	{ 0x732a, 0x991b },
	{ 0x732b, 0x9921 },
	{ 0x732c, 0x991a },
	{ 0x732d, 0x99ed },
	{ 0x732e, 0x99e2 },
	{ 0x732f, 0x99f1 },
	{ 0x7330, 0x9ab8 },
	{ 0x7331, 0x9abc },
	{ 0x7332, 0x9afb },
	{ 0x7333, 0x9aed },
	{ 0x7334, 0x9b28 },
	{ 0x7335, 0x9b91 },
	{ 0x7336, 0x9d15 },
	{ 0x7337, 0x9d23 },
	{ 0x7338, 0x9d26 },
	{ 0x7339, 0x9d28 },
	{ 0x733a, 0x9d12 },
	{ 0x733b, 0x9d1b },
	{ 0x733c, 0x9ed8 },
	{ 0x733d, 0x9ed4 },
	{ 0x733e, 0x9f8d },
	{ 0x733f, 0x9f9c },
	{ 0x7340, 0x512a },
	{ 0x7341, 0x511f },
	{ 0x7342, 0x5121 },
	{ 0x7343, 0x5132 },
	{ 0x7344, 0x52f5 },
	{ 0x7345, 0x568e },
	{ 0x7346, 0x5680 },
	{ 0x7347, 0x5690 },
	{ 0x7348, 0x5685 },
	{ 0x7349, 0x5687 },
	{ 0x734a, 0x568f },
	{ 0x734b, 0x58d5 },
	{ 0x734c, 0x58d3 },
	{ 0x734d, 0x58d1 },
	{ 0x734e, 0x58ce },
	{ 0x734f, 0x5b30 },
	{ 0x7350, 0x5b2a },
	{ 0x7351, 0x5b24 },
	{ 0x7352, 0x5b7a },
	{ 0x7353, 0x5c37 },
	{ 0x7354, 0x5c68 },
	{ 0x7355, 0x5dbc },
	{ 0x7356, 0x5dba },
	{ 0x7357, 0x5dbd },
	{ 0x7358, 0x5db8 },
	{ 0x7359, 0x5e6b },
	{ 0x735a, 0x5f4c },
	{ 0x735b, 0x5fbd },
	{ 0x735c, 0x61c9 },
	{ 0x735d, 0x61c2 },
	{ 0x735e, 0x61c7 },
	{ 0x735f, 0x61e6 },
	{ 0x7360, 0x61cb },
	{ 0x7361, 0x6232 },
	{ 0x7362, 0x6234 },
	{ 0x7363, 0x64ce },
	{ 0x7364, 0x64ca },
	{ 0x7365, 0x64d8 },
	{ 0x7366, 0x64e0 },
	{ 0x7367, 0x64f0 },
	{ 0x7368, 0x64e6 },
	{ 0x7369, 0x64ec },
	{ 0x736a, 0x64f1 },
	{ 0x736b, 0x64e2 },
	{ 0x736c, 0x64ed },
	{ 0x736d, 0x6582 },
	{ 0x736e, 0x6583 },
	{ 0x736f, 0x66d9 },
	{ 0x7370, 0x66d6 },
	{ 0x7371, 0x6a80 },
	{ 0x7372, 0x6a94 },
	{ 0x7373, 0x6a84 },
	{ 0x7374, 0x6aa2 },
	{ 0x7375, 0x6a9c },
	{ 0x7376, 0x6adb },
	{ 0x7377, 0x6aa3 },
	{ 0x7378, 0x6a7e },
	{ 0x7379, 0x6a97 },
	{ 0x737a, 0x6a90 },
	{ 0x737b, 0x6aa0 },
	{ 0x737c, 0x6b5c },
	{ 0x737d, 0x6bae },
	{ 0x737e, 0x6bda },
	{ 0x7421, 0x6c08 },
	{ 0x7422, 0x6fd8 },
	{ 0x7423, 0x6ff1 },
	{ 0x7424, 0x6fdf },
	{ 0x7425, 0x6fe0 },
	{ 0x7426, 0x6fdb },
	{ 0x7427, 0x6fe4 },
	{ 0x7428, 0x6feb },
	{ 0x7429, 0x6fef },
	{ 0x742a, 0x6f80 },
	{ 0x742b, 0x6fec },
	{ 0x742c, 0x6fe1 },
	{ 0x742d, 0x6fe9 },
	{ 0x742e, 0x6fd5 },
	{ 0x742f, 0x6fee },
	{ 0x7430, 0x6ff0 },
	{ 0x7431, 0x71e7 },
	{ 0x7432, 0x71df },
	{ 0x7433, 0x71ee },
	{ 0x7434, 0x71e6 },
	{ 0x7435, 0x71e5 },
	{ 0x7436, 0x71ed },
	{ 0x7437, 0x71ec },
	{ 0x7438, 0x71f4 },
	{ 0x7439, 0x71e0 },
	{ 0x743a, 0x7235 },
	{ 0x743b, 0x7246 },
	{ 0x743c, 0x7370 },
	{ 0x743d, 0x7372 },
	{ 0x743e, 0x74a9 },
	{ 0x743f, 0x74b0 },
	{ 0x7440, 0x74a6 },
	{ 0x7441, 0x74a8 },
	{ 0x7442, 0x7646 },
	{ 0x7443, 0x7642 },
	{ 0x7444, 0x764c },
	{ 0x7445, 0x76ea },
	{ 0x7446, 0x77b3 },
	{ 0x7447, 0x77aa },
	{ 0x7448, 0x77b0 },
	{ 0x7449, 0x77ac },
	{ 0x744a, 0x77a7 },
	{ 0x744b, 0x77ad },
	{ 0x744c, 0x77ef },
	{ 0x744d, 0x78f7 },
	{ 0x744e, 0x78fa },
	{ 0x744f, 0x78f4 },
	{ 0x7450, 0x78ef },
	{ 0x7451, 0x7901 },
	{ 0x7452, 0x79a7 },
	{ 0x7453, 0x79aa },
	{ 0x7454, 0x7a57 },
	{ 0x7455, 0x7abf },
	{ 0x7456, 0x7c07 },
	{ 0x7457, 0x7c0d },
	{ 0x7458, 0x7bfe },
	{ 0x7459, 0x7bf7 },
	{ 0x745a, 0x7c0c },
	{ 0x745b, 0x7be0 },
	{ 0x745c, 0x7ce0 },
	{ 0x745d, 0x7cdc },
	{ 0x745e, 0x7cde },
	{ 0x745f, 0x7ce2 },
	{ 0x7460, 0x7cdf },
	{ 0x7461, 0x7cd9 },
	{ 0x7462, 0x7cdd },
	{ 0x7463, 0x7e2e },
	{ 0x7464, 0x7e3e },
	{ 0x7465, 0x7e46 },
	{ 0x7466, 0x7e37 },
	{ 0x7467, 0x7e32 },
	{ 0x7468, 0x7e43 },
	{ 0x7469, 0x7e2b },
	{ 0x746a, 0x7e3d },
	{ 0x746b, 0x7e31 },
	{ 0x746c, 0x7e45 },
	{ 0x746d, 0x7e41 },
	{ 0x746e, 0x7e34 },
	{ 0x746f, 0x7e39 },
	{ 0x7470, 0x7e48 },
	{ 0x7471, 0x7e35 },
	{ 0x7472, 0x7e3f },
	{ 0x7473, 0x7e2f },
	{ 0x7474, 0x7f44 },
	{ 0x7475, 0x7ff3 },
	{ 0x7476, 0x7ffc },
	{ 0x7477, 0x8071 },
	{ 0x7478, 0x8072 },
	{ 0x7479, 0x8070 },
	{ 0x747a, 0x806f },
	{ 0x747b, 0x8073 },
	{ 0x747c, 0x81c6 },
	{ 0x747d, 0x81c3 },
	{ 0x747e, 0x81ba },
	{ 0x7521, 0x81c2 },
	{ 0x7522, 0x81c0 },
	{ 0x7523, 0x81bf },
	{ 0x7524, 0x81bd },
	{ 0x7525, 0x81c9 },
	{ 0x7526, 0x81be },
	{ 0x7527, 0x81e8 },
	{ 0x7528, 0x8209 },
	{ 0x7529, 0x8271 },
	{ 0x752a, 0x85aa },
	{ 0x752b, 0x8584 },
	{ 0x752c, 0x857e },
	{ 0x752d, 0x859c },
	{ 0x752e, 0x8591 },
	{ 0x752f, 0x8594 },
	{ 0x7530, 0x85af },
	{ 0x7531, 0x859b },
	{ 0x7532, 0x8587 },
	{ 0x7533, 0x85a8 },
	{ 0x7534, 0x858a },
	{ 0x7535, 0x85a6 },
	{ 0x7536, 0x8667 },
	{ 0x7537, 0x87c0 },
	{ 0x7538, 0x87d1 },
	{ 0x7539, 0x87b3 },
	{ 0x753a, 0x87d2 },
	{ 0x753b, 0x87c6 },
	{ 0x753c, 0x87ab },
	{ 0x753d, 0x87bb },
	{ 0x753e, 0x87ba },
	{ 0x753f, 0x87c8 },
	{ 0x7540, 0x87cb },
	{ 0x7541, 0x893b },
	{ 0x7542, 0x8936 },
	{ 0x7543, 0x8944 },
	{ 0x7544, 0x8938 },
	{ 0x7545, 0x893d },
	{ 0x7546, 0x89ac },
	{ 0x7547, 0x8b0e },
	{ 0x7548, 0x8b17 },
	{ 0x7549, 0x8b19 },
	{ 0x754a, 0x8b1b },
	{ 0x754b, 0x8b0a },
	{ 0x754c, 0x8b20 },
	{ 0x754d, 0x8b1d },
	{ 0x754e, 0x8b04 },
	{ 0x754f, 0x8b10 },
	{ 0x7550, 0x8c41 },
	{ 0x7551, 0x8c3f },
	{ 0x7552, 0x8c73 },
	{ 0x7553, 0x8cfa },
	{ 0x7554, 0x8cfd },
	{ 0x7555, 0x8cfc },
	{ 0x7556, 0x8cf8 },
	{ 0x7557, 0x8cfb },
	{ 0x7558, 0x8da8 },
	{ 0x7559, 0x8e49 },
	{ 0x755a, 0x8e4b },
	{ 0x755b, 0x8e48 },
	{ 0x755c, 0x8e4a },
	{ 0x755d, 0x8f44 },
	{ 0x755e, 0x8f3e },
	{ 0x755f, 0x8f42 },
	{ 0x7560, 0x8f45 },
	{ 0x7561, 0x8f3f },
	{ 0x7562, 0x907f },
	{ 0x7563, 0x907d },
	{ 0x7564, 0x9084 },
	{ 0x7565, 0x9081 },
	{ 0x7566, 0x9082 },
	{ 0x7567, 0x9080 },
	{ 0x7568, 0x9139 },
	{ 0x7569, 0x91a3 },
	{ 0x756a, 0x919e },
	{ 0x756b, 0x919c },
	{ 0x756c, 0x934d },
	{ 0x756d, 0x9382 },
	{ 0x756e, 0x9328 },
	{ 0x756f, 0x9375 },
	{ 0x7570, 0x934a },
	{ 0x7571, 0x9365 },
	{ 0x7572, 0x934b },
	{ 0x7573, 0x9318 },
	{ 0x7574, 0x937e },
	{ 0x7575, 0x936c },
	{ 0x7576, 0x935b },
	{ 0x7577, 0x9370 },
	{ 0x7578, 0x935a },
	{ 0x7579, 0x9354 },
	{ 0x757a, 0x95ca },
	{ 0x757b, 0x95cb },
	{ 0x757c, 0x95cc },
	{ 0x757d, 0x95c8 },
	{ 0x757e, 0x95c6 },
	{ 0x7621, 0x96b1 },
	{ 0x7622, 0x96b8 },
	{ 0x7623, 0x96d6 },
	{ 0x7624, 0x971c },
	{ 0x7625, 0x971e },
	{ 0x7626, 0x97a0 },
	{ 0x7627, 0x97d3 },
	{ 0x7628, 0x9846 },
	{ 0x7629, 0x98b6 },
	{ 0x762a, 0x9935 },
	{ 0x762b, 0x9a01 },
	{ 0x762c, 0x99ff },
	{ 0x762d, 0x9bae },
	{ 0x762e, 0x9bab },
	{ 0x762f, 0x9baa },
	{ 0x7630, 0x9bad },
	{ 0x7631, 0x9d3b },
	{ 0x7632, 0x9d3f },
	{ 0x7633, 0x9e8b },
	{ 0x7634, 0x9ecf },
	{ 0x7635, 0x9ede },
	{ 0x7636, 0x9edc },
	{ 0x7637, 0x9edd },
	{ 0x7638, 0x9edb },
	{ 0x7639, 0x9f3e },
	{ 0x763a, 0x9f4b },
	{ 0x763b, 0x53e2 },
	{ 0x763c, 0x5695 },
	{ 0x763d, 0x56ae },
	{ 0x763e, 0x58d9 },
	{ 0x763f, 0x58d8 },
	{ 0x7640, 0x5b38 },
	{ 0x7641, 0x5f5e },
	{ 0x7642, 0x61e3 },
	{ 0x7643, 0x6233 },
	{ 0x7644, 0x64f4 },
	{ 0x7645, 0x64f2 },
	{ 0x7646, 0x64fe },
	{ 0x7647, 0x6506 },
	{ 0x7648, 0x64fa },
	{ 0x7649, 0x64fb },
	{ 0x764a, 0x64f7 },
	{ 0x764b, 0x65b7 },
	{ 0x764c, 0x66dc },
	{ 0x764d, 0x6726 },
	{ 0x764e, 0x6ab3 },
	{ 0x764f, 0x6aac },
	{ 0x7650, 0x6ac3 },
	{ 0x7651, 0x6abb },
	{ 0x7652, 0x6ab8 },
	{ 0x7653, 0x6ac2 },
	{ 0x7654, 0x6aae },
	{ 0x7655, 0x6aaf },
	{ 0x7656, 0x6b5f },
	{ 0x7657, 0x6b78 },
	{ 0x7658, 0x6baf },
	{ 0x7659, 0x7009 },
	{ 0x765a, 0x700b },
	{ 0x765b, 0x6ffe },
	{ 0x765c, 0x7006 },
	{ 0x765d, 0x6ffa },
	{ 0x765e, 0x7011 },
	{ 0x765f, 0x700f },
	{ 0x7660, 0x71fb },
	{ 0x7661, 0x71fc },
	{ 0x7662, 0x71fe },
	{ 0x7663, 0x71f8 },
	{ 0x7664, 0x7377 },
	{ 0x7665, 0x7375 },
	{ 0x7666, 0x74a7 },
	{ 0x7667, 0x74bf },
	{ 0x7668, 0x7515 },
	{ 0x7669, 0x7656 },
	{ 0x766a, 0x7658 },
	{ 0x766b, 0x7652 },
	{ 0x766c, 0x77bd },
	{ 0x766d, 0x77bf },
	{ 0x766e, 0x77bb },
	{ 0x766f, 0x77bc },
	{ 0x7670, 0x790e },
	{ 0x7671, 0x79ae },
	{ 0x7672, 0x7a61 },
	{ 0x7673, 0x7a62 },
	{ 0x7674, 0x7a60 },
	{ 0x7675, 0x7ac4 },
	{ 0x7676, 0x7ac5 },
	{ 0x7677, 0x7c2b },
	{ 0x7678, 0x7c27 },
	{ 0x7679, 0x7c2a },
	{ 0x767a, 0x7c1e },
	{ 0x767b, 0x7c23 },
	{ 0x767c, 0x7c21 },
	{ 0x767d, 0x7ce7 },
	{ 0x767e, 0x7e54 },
	{ 0x7721, 0x7e55 },
	{ 0x7722, 0x7e5e },
	{ 0x7723, 0x7e5a },
	{ 0x7724, 0x7e61 },
	{ 0x7725, 0x7e52 },
	{ 0x7726, 0x7e59 },
	{ 0x7727, 0x7f48 },
	{ 0x7728, 0x7ff9 },
	{ 0x7729, 0x7ffb },
	{ 0x772a, 0x8077 },
	{ 0x772b, 0x8076 },
	{ 0x772c, 0x81cd },
	{ 0x772d, 0x81cf },
	{ 0x772e, 0x820a },
	{ 0x772f, 0x85cf },
	{ 0x7730, 0x85a9 },
	{ 0x7731, 0x85cd },
	{ 0x7732, 0x85d0 },
	{ 0x7733, 0x85c9 },
	{ 0x7734, 0x85b0 },
	{ 0x7735, 0x85ba },
	{ 0x7736, 0x85b9 },
	{ 0x7737, 0x87ef },
	{ 0x7738, 0x87ec },
	{ 0x7739, 0x87f2 },
	{ 0x773a, 0x87e0 },
	{ 0x773b, 0x8986 },
	{ 0x773c, 0x89b2 },
	{ 0x773d, 0x89f4 },
	{ 0x773e, 0x8b28 },
	{ 0x773f, 0x8b39 },
	{ 0x7740, 0x8b2c },
	{ 0x7741, 0x8b2b },
	{ 0x7742, 0x8c50 },
	{ 0x7743, 0x8d05 },
	{ 0x7744, 0x8e59 },
	{ 0x7745, 0x8e63 },
	{ 0x7746, 0x8e66 },
	{ 0x7747, 0x8e64 },
	{ 0x7748, 0x8e5f },
	{ 0x7749, 0x8e55 },
	{ 0x774a, 0x8ec0 },
	{ 0x774b, 0x8f49 },
	{ 0x774c, 0x8f4d },
	{ 0x774d, 0x9087 },
	{ 0x774e, 0x9083 },
	{ 0x774f, 0x9088 },
	{ 0x7750, 0x91ab },
	{ 0x7751, 0x91ac },
	{ 0x7752, 0x91d0 },
	{ 0x7753, 0x9394 },
	{ 0x7754, 0x938a },
	{ 0x7755, 0x9396 },
	{ 0x7756, 0x93a2 },
	{ 0x7757, 0x93b3 },
	{ 0x7758, 0x93ae },
	{ 0x7759, 0x93ac },
	{ 0x775a, 0x93b0 },
	{ 0x775b, 0x9398 },
	{ 0x775c, 0x939a },
	{ 0x775d, 0x9397 },
	{ 0x775e, 0x95d4 },
	{ 0x775f, 0x95d6 },
	{ 0x7760, 0x95d0 },
	{ 0x7761, 0x95d5 },
	{ 0x7762, 0x96e2 },
	{ 0x7763, 0x96dc },
	{ 0x7764, 0x96d9 },
	{ 0x7765, 0x96db },
	{ 0x7766, 0x96de },
	{ 0x7767, 0x9724 },
	{ 0x7768, 0x97a3 },
	{ 0x7769, 0x97a6 },
	{ 0x776a, 0x97ad },
	{ 0x776b, 0x97f9 },
	{ 0x776c, 0x984d },
	{ 0x776d, 0x984f },
	{ 0x776e, 0x984c },
	{ 0x776f, 0x984e },
	{ 0x7770, 0x9853 },
	{ 0x7771, 0x98ba },
	{ 0x7772, 0x993e },
	{ 0x7773, 0x993f },
	{ 0x7774, 0x993d },
	{ 0x7775, 0x992e },
	{ 0x7776, 0x99a5 },
	{ 0x7777, 0x9a0e },
	{ 0x7778, 0x9ac1 },
	{ 0x7779, 0x9b03 },
	{ 0x777a, 0x9b06 },
	{ 0x777b, 0x9b4f },
	{ 0x777c, 0x9b4e },
	{ 0x777d, 0x9b4d },
	{ 0x777e, 0x9bca },
	{ 0x7821, 0x9bc9 },
	{ 0x7822, 0x9bfd },
	{ 0x7823, 0x9bc8 },
	{ 0x7824, 0x9bc0 },
	{ 0x7825, 0x9d51 },
	{ 0x7826, 0x9d5d },
	{ 0x7827, 0x9d60 },
	{ 0x7828, 0x9ee0 },
	{ 0x7829, 0x9f15 },
	{ 0x782a, 0x9f2c },
	{ 0x782b, 0x5133 },
	{ 0x782c, 0x56a5 },
	{ 0x782d, 0x56a8 },
	{ 0x782e, 0x58de },
	{ 0x782f, 0x58df },
	{ 0x7830, 0x58e2 },
	{ 0x7831, 0x5bf5 },
	{ 0x7832, 0x9f90 },
	{ 0x7833, 0x5eec },
	{ 0x7834, 0x61f2 },
	{ 0x7835, 0x61f7 },
	{ 0x7836, 0x61f6 },
	{ 0x7837, 0x61f5 },
	{ 0x7838, 0x6500 },
	{ 0x7839, 0x650f },
	{ 0x783a, 0x66e0 },
	{ 0x783b, 0x66dd },
	{ 0x783c, 0x6ae5 },
	{ 0x783d, 0x6add },
	{ 0x783e, 0x6ada },
	{ 0x783f, 0x6ad3 },
	{ 0x7840, 0x701b },
	{ 0x7841, 0x701f },
	{ 0x7842, 0x7028 },
	{ 0x7843, 0x701a },
	{ 0x7844, 0x701d },
	{ 0x7845, 0x7015 },
	{ 0x7846, 0x7018 },
	{ 0x7847, 0x7206 },
	{ 0x7848, 0x720d },
	{ 0x7849, 0x7258 },
	{ 0x784a, 0x72a2 },
	{ 0x784b, 0x7378 },
	{ 0x784c, 0x737a },
	{ 0x784d, 0x74bd },
	{ 0x784e, 0x74ca },
	{ 0x784f, 0x74e3 },
	{ 0x7850, 0x7587 },
	{ 0x7851, 0x7586 },
	{ 0x7852, 0x765f },
	{ 0x7853, 0x7661 },
	{ 0x7854, 0x77c7 },
	{ 0x7855, 0x7919 },
	{ 0x7856, 0x79b1 },
	{ 0x7857, 0x7a6b },
	{ 0x7858, 0x7a69 },
	{ 0x7859, 0x7c3e },
	{ 0x785a, 0x7c3f },
	{ 0x785b, 0x7c38 },
	{ 0x785c, 0x7c3d },
	{ 0x785d, 0x7c37 },
	{ 0x785e, 0x7c40 },
	{ 0x785f, 0x7e6b },
	{ 0x7860, 0x7e6d },
	{ 0x7861, 0x7e79 },
	{ 0x7862, 0x7e69 },
	{ 0x7863, 0x7e6a },
	{ 0x7864, 0x7e73 },
	{ 0x7865, 0x7f85 },
	{ 0x7866, 0x7fb6 },
	{ 0x7867, 0x7fb9 },
	{ 0x7868, 0x7fb8 },
	{ 0x7869, 0x81d8 },
	{ 0x786a, 0x85e9 },
	{ 0x786b, 0x85dd },
	{ 0x786c, 0x85ea },
	{ 0x786d, 0x85d5 },
	{ 0x786e, 0x85e4 },
	{ 0x786f, 0x85e5 },
	{ 0x7870, 0x85f7 },
	{ 0x7871, 0x87fb },
	{ 0x7872, 0x8805 },
	{ 0x7873, 0x880d },
	{ 0x7874, 0x87f9 },
	{ 0x7875, 0x87fe },
	{ 0x7876, 0x8960 },
	{ 0x7877, 0x895f },
	{ 0x7878, 0x8956 },
	{ 0x7879, 0x895e },
	{ 0x787a, 0x8b41 },
	{ 0x787b, 0x8b5c },
	{ 0x787c, 0x8b58 },
	{ 0x787d, 0x8b49 },
	{ 0x787e, 0x8b5a },
	{ 0x7921, 0x8b4e },
	{ 0x7922, 0x8b4f },
	{ 0x7923, 0x8b46 },
	{ 0x7924, 0x8b59 },
	{ 0x7925, 0x8d08 },
	{ 0x7926, 0x8d0a },
	{ 0x7927, 0x8e7c },
	{ 0x7928, 0x8e72 },
	{ 0x7929, 0x8e87 },
	{ 0x792a, 0x8e76 },
	{ 0x792b, 0x8e6c },
	{ 0x792c, 0x8e7a },
	{ 0x792d, 0x8e74 },
	{ 0x792e, 0x8f54 },
	{ 0x792f, 0x8f4e },
	{ 0x7930, 0x8fad },
	{ 0x7931, 0x908a },
	{ 0x7932, 0x908b },
	{ 0x7933, 0x91b1 },
	{ 0x7934, 0x91ae },
	{ 0x7935, 0x93e1 },
	{ 0x7936, 0x93d1 },
	{ 0x7937, 0x93df },
	{ 0x7938, 0x93c3 },
	{ 0x7939, 0x93c8 },
	{ 0x793a, 0x93dc },
	{ 0x793b, 0x93dd },
	{ 0x793c, 0x93d6 },
	{ 0x793d, 0x93e2 },
	{ 0x793e, 0x93cd },
	{ 0x793f, 0x93d8 },
	{ 0x7940, 0x93e4 },
	{ 0x7941, 0x93d7 },
	{ 0x7942, 0x93e8 },
	{ 0x7943, 0x95dc },
	{ 0x7944, 0x96b4 },
	{ 0x7945, 0x96e3 },
	{ 0x7946, 0x972a },
	{ 0x7947, 0x9727 },
	{ 0x7948, 0x9761 },
	{ 0x7949, 0x97dc },
	{ 0x794a, 0x97fb },
	{ 0x794b, 0x985e },
	{ 0x794c, 0x9858 },
	{ 0x794d, 0x985b },
	{ 0x794e, 0x98bc },
	{ 0x794f, 0x9945 },
	{ 0x7950, 0x9949 },
	{ 0x7951, 0x9a16 },
	{ 0x7952, 0x9a19 },
	{ 0x7953, 0x9b0d },
	{ 0x7954, 0x9be8 },
	{ 0x7955, 0x9be7 },
	{ 0x7956, 0x9bd6 },
	{ 0x7957, 0x9bdb },
	{ 0x7958, 0x9d89 },
	{ 0x7959, 0x9d61 },
	{ 0x795a, 0x9d72 },
	{ 0x795b, 0x9d6a },
	{ 0x795c, 0x9d6c },
	{ 0x795d, 0x9e92 },
	{ 0x795e, 0x9e97 },
	{ 0x795f, 0x9e93 },
	{ 0x7960, 0x9eb4 },
	{ 0x7961, 0x52f8 },
	{ 0x7962, 0x56b7 },
	{ 0x7963, 0x56b6 },
	{ 0x7964, 0x56b4 },
	{ 0x7965, 0x56bc },
	{ 0x7966, 0x58e4 },
	{ 0x7967, 0x5b40 },
	{ 0x7968, 0x5b43 },
	{ 0x7969, 0x5b7d },
	{ 0x796a, 0x5bf6 },
	{ 0x796b, 0x5dc9 },
	{ 0x796c, 0x61f8 },
	{ 0x796d, 0x61fa },
	{ 0x796e, 0x6518 },
	{ 0x796f, 0x6514 },
	{ 0x7970, 0x6519 },
	{ 0x7971, 0x66e6 },
	{ 0x7972, 0x6727 },
	{ 0x7973, 0x6aec },
	{ 0x7974, 0x703e },
	{ 0x7975, 0x7030 },
	{ 0x7976, 0x7032 },
	{ 0x7977, 0x7210 },
	{ 0x7978, 0x737b },
	{ 0x7979, 0x74cf },
	{ 0x797a, 0x7662 },
	{ 0x797b, 0x7665 },
	{ 0x797c, 0x7926 },
	{ 0x797d, 0x792a },
	{ 0x797e, 0x792c },
	{ 0x7a21, 0x792b },
	{ 0x7a22, 0x7ac7 },
	{ 0x7a23, 0x7af6 },
	{ 0x7a24, 0x7c4c },
	{ 0x7a25, 0x7c43 },
	{ 0x7a26, 0x7c4d },
	{ 0x7a27, 0x7cef },
	{ 0x7a28, 0x7cf0 },
	{ 0x7a29, 0x8fae },
	{ 0x7a2a, 0x7e7d },
	{ 0x7a2b, 0x7e7c },
	{ 0x7a2c, 0x7e82 },
	{ 0x7a2d, 0x7f4c },
	{ 0x7a2e, 0x8000 },
	{ 0x7a2f, 0x81da },
	{ 0x7a30, 0x8266 },
	{ 0x7a31, 0x85fb },
	{ 0x7a32, 0x85f9 },
	{ 0x7a33, 0x8611 },
	{ 0x7a34, 0x85fa },
	{ 0x7a35, 0x8606 },
	{ 0x7a36, 0x860b },
	{ 0x7a37, 0x8607 },
	{ 0x7a38, 0x860a },
	{ 0x7a39, 0x8814 },
	{ 0x7a3a, 0x8815 },
	{ 0x7a3b, 0x8964 },
	{ 0x7a3c, 0x89ba },
	{ 0x7a3d, 0x89f8 },
	{ 0x7a3e, 0x8b70 },
	{ 0x7a3f, 0x8b6c },
	{ 0x7a40, 0x8b66 },
	{ 0x7a41, 0x8b6f },
	{ 0x7a42, 0x8b5f },
	{ 0x7a43, 0x8b6b },
	{ 0x7a44, 0x8d0f },
	{ 0x7a45, 0x8d0d },
	{ 0x7a46, 0x8e89 },
	{ 0x7a47, 0x8e81 },
	{ 0x7a48, 0x8e85 },
	{ 0x7a49, 0x8e82 },
	{ 0x7a4a, 0x91b4 },
	{ 0x7a4b, 0x91cb },
	{ 0x7a4c, 0x9418 },
	{ 0x7a4d, 0x9403 },
	{ 0x7a4e, 0x93fd },
	{ 0x7a4f, 0x95e1 },
	{ 0x7a50, 0x9730 },
	{ 0x7a51, 0x98c4 },
	{ 0x7a52, 0x9952 },
	{ 0x7a53, 0x9951 },
	{ 0x7a54, 0x99a8 },
	{ 0x7a55, 0x9a2b },
	{ 0x7a56, 0x9a30 },
	{ 0x7a57, 0x9a37 },
	{ 0x7a58, 0x9a35 },
	{ 0x7a59, 0x9c13 },
	{ 0x7a5a, 0x9c0d },
	{ 0x7a5b, 0x9e79 },
	{ 0x7a5c, 0x9eb5 },
	{ 0x7a5d, 0x9ee8 },
	{ 0x7a5e, 0x9f2f },
	{ 0x7a5f, 0x9f5f },
	{ 0x7a60, 0x9f63 },
	{ 0x7a61, 0x9f61 },
	{ 0x7a62, 0x5137 },
	{ 0x7a63, 0x5138 },
	{ 0x7a64, 0x56c1 },
	{ 0x7a65, 0x56c0 },
	{ 0x7a66, 0x56c2 },
	{ 0x7a67, 0x5914 },
	{ 0x7a68, 0x5c6c },
	{ 0x7a69, 0x5dcd },
	{ 0x7a6a, 0x61fc },
	{ 0x7a6b, 0x61fe },
	{ 0x7a6c, 0x651d },
	{ 0x7a6d, 0x651c },
	{ 0x7a6e, 0x6595 },
	{ 0x7a6f, 0x66e9 },
	{ 0x7a70, 0x6afb },
	{ 0x7a71, 0x6b04 },
	{ 0x7a72, 0x6afa },
	{ 0x7a73, 0x6bb2 },
	{ 0x7a74, 0x704c },
	{ 0x7a75, 0x721b },
	{ 0x7a76, 0x72a7 },
	{ 0x7a77, 0x74d6 },
	{ 0x7a78, 0x74d4 },
	{ 0x7a79, 0x7669 },
	{ 0x7a7a, 0x77d3 },
	{ 0x7a7b, 0x7c50 },
	{ 0x7a7c, 0x7e8f },
	{ 0x7a7d, 0x7e8c },
	{ 0x7a7e, 0x7fbc },
	{ 0x7b21, 0x8617 },
	{ 0x7b22, 0x862d },
	{ 0x7b23, 0x861a },
	{ 0x7b24, 0x8823 },
	{ 0x7b25, 0x8822 },
	{ 0x7b26, 0x8821 },
	{ 0x7b27, 0x881f },
	{ 0x7b28, 0x896a },
	{ 0x7b29, 0x896c },
	{ 0x7b2a, 0x89bd },
	{ 0x7b2b, 0x8b74 },
	{ 0x7b2c, 0x8b77 },
	{ 0x7b2d, 0x8b7d },
	{ 0x7b2e, 0x8d13 },
	{ 0x7b2f, 0x8e8a },
	{ 0x7b30, 0x8e8d },
	{ 0x7b31, 0x8e8b },
	{ 0x7b32, 0x8f5f },
	{ 0x7b33, 0x8faf },
	{ 0x7b34, 0x91ba },
	{ 0x7b35, 0x942e },
	{ 0x7b36, 0x9433 },
	{ 0x7b37, 0x9435 },
	{ 0x7b38, 0x943a },
	{ 0x7b39, 0x9438 },
	{ 0x7b3a, 0x9432 },
	{ 0x7b3b, 0x942b },
	{ 0x7b3c, 0x95e2 },
	{ 0x7b3d, 0x9738 },
	{ 0x7b3e, 0x9739 },
	{ 0x7b3f, 0x9732 },
	{ 0x7b40, 0x97ff },
	{ 0x7b41, 0x9867 },
	{ 0x7b42, 0x9865 },
	{ 0x7b43, 0x9957 },
	{ 0x7b44, 0x9a45 },
	{ 0x7b45, 0x9a43 },
	{ 0x7b46, 0x9a40 },
	{ 0x7b47, 0x9a3e },
	{ 0x7b48, 0x9acf },
	{ 0x7b49, 0x9b54 },
	{ 0x7b4a, 0x9b51 },
	{ 0x7b4b, 0x9c2d },
	{ 0x7b4c, 0x9c25 },
	{ 0x7b4d, 0x9daf },
	{ 0x7b4e, 0x9db4 },
	{ 0x7b4f, 0x9dc2 },
	{ 0x7b50, 0x9db8 },
	{ 0x7b51, 0x9e9d },
	{ 0x7b52, 0x9eef },
	{ 0x7b53, 0x9f19 },
	{ 0x7b54, 0x9f5c },
	{ 0x7b55, 0x9f66 },
	{ 0x7b56, 0x9f67 },
	{ 0x7b57, 0x513c },
	{ 0x7b58, 0x513b },
	{ 0x7b59, 0x56c8 },
	{ 0x7b5a, 0x56ca },
	{ 0x7b5b, 0x56c9 },
	{ 0x7b5c, 0x5b7f },
	{ 0x7b5d, 0x5dd4 },
	{ 0x7b5e, 0x5dd2 },
	{ 0x7b5f, 0x5f4e },
	{ 0x7b60, 0x61ff },
	{ 0x7b61, 0x6524 },
	{ 0x7b62, 0x6b0a },
	{ 0x7b63, 0x6b61 },
	{ 0x7b64, 0x7051 },
	{ 0x7b65, 0x7058 },
	{ 0x7b66, 0x7380 },
	{ 0x7b67, 0x74e4 },
	{ 0x7b68, 0x758a },
	{ 0x7b69, 0x766e },
	{ 0x7b6a, 0x766c },
	{ 0x7b6b, 0x79b3 },
	{ 0x7b6c, 0x7c60 },
	{ 0x7b6d, 0x7c5f },
	{ 0x7b6e, 0x807e },
	{ 0x7b6f, 0x807d },
	{ 0x7b70, 0x81df },
	{ 0x7b71, 0x8972 },
	{ 0x7b72, 0x896f },
	{ 0x7b73, 0x89fc },
	{ 0x7b74, 0x8b80 },
	{ 0x7b75, 0x8d16 },
	{ 0x7b76, 0x8d17 },
	{ 0x7b77, 0x8e91 },
	{ 0x7b78, 0x8e93 },
	{ 0x7b79, 0x8f61 },
	{ 0x7b7a, 0x9148 },
	{ 0x7b7b, 0x9444 },
	{ 0x7b7c, 0x9451 },
	{ 0x7b7d, 0x9452 },
	{ 0x7b7e, 0x973d },
	{ 0x7c21, 0x973e },
	{ 0x7c22, 0x97c3 },
	{ 0x7c23, 0x97c1 },
	{ 0x7c24, 0x986b },
	{ 0x7c25, 0x9955 },
	{ 0x7c26, 0x9a55 },
	{ 0x7c27, 0x9a4d },
	{ 0x7c28, 0x9ad2 },
	{ 0x7c29, 0x9b1a },
	{ 0x7c2a, 0x9c49 },
	{ 0x7c2b, 0x9c31 },
	{ 0x7c2c, 0x9c3e },
	{ 0x7c2d, 0x9c3b },
	{ 0x7c2e, 0x9dd3 },
	{ 0x7c2f, 0x9dd7 },
	{ 0x7c30, 0x9f34 },
	{ 0x7c31, 0x9f6c },
	{ 0x7c32, 0x9f6a },
	{ 0x7c33, 0x9f94 },
	{ 0x7c34, 0x56cc },
	{ 0x7c35, 0x5dd6 },
	{ 0x7c36, 0x6200 },
	{ 0x7c37, 0x6523 },
	{ 0x7c38, 0x652b },
	{ 0x7c39, 0x652a },
	{ 0x7c3a, 0x66ec },
	{ 0x7c3b, 0x6b10 },
	{ 0x7c3c, 0x74da },
	{ 0x7c3d, 0x7aca },
	{ 0x7c3e, 0x7c64 },
	{ 0x7c3f, 0x7c63 },
	{ 0x7c40, 0x7c65 },
	{ 0x7c41, 0x7e93 },
	{ 0x7c42, 0x7e96 },
	{ 0x7c43, 0x7e94 },
	{ 0x7c44, 0x81e2 },
	{ 0x7c45, 0x8638 },
	{ 0x7c46, 0x863f },
	{ 0x7c47, 0x8831 },
	{ 0x7c48, 0x8b8a },
	{ 0x7c49, 0x9090 },
	{ 0x7c4a, 0x908f },
	{ 0x7c4b, 0x9463 },
	{ 0x7c4c, 0x9460 },
	{ 0x7c4d, 0x9464 },
	{ 0x7c4e, 0x9768 },
	{ 0x7c4f, 0x986f },
	{ 0x7c50, 0x995c },
	{ 0x7c51, 0x9a5a },
	{ 0x7c52, 0x9a5b },
	{ 0x7c53, 0x9a57 },
	{ 0x7c54, 0x9ad3 },
	{ 0x7c55, 0x9ad4 },
	{ 0x7c56, 0x9ad1 },
	{ 0x7c57, 0x9c54 },
	{ 0x7c58, 0x9c57 },
	{ 0x7c59, 0x9c56 },
	{ 0x7c5a, 0x9de5 },
	{ 0x7c5b, 0x9e9f },
	{ 0x7c5c, 0x9ef4 },
	{ 0x7c5d, 0x56d1 },
	{ 0x7c5e, 0x58e9 },
	{ 0x7c5f, 0x652c },
	{ 0x7c60, 0x705e },
	{ 0x7c61, 0x7671 },
	{ 0x7c62, 0x7672 },
	{ 0x7c63, 0x77d7 },
	{ 0x7c64, 0x7f50 },
	{ 0x7c65, 0x7f88 },
	{ 0x7c66, 0x8836 },
	{ 0x7c67, 0x8839 },
	{ 0x7c68, 0x8862 },
	{ 0x7c69, 0x8b93 },
	{ 0x7c6a, 0x8b92 },
	{ 0x7c6b, 0x8b96 },
	{ 0x7c6c, 0x8277 },
	{ 0x7c6d, 0x8d1b },
	{ 0x7c6e, 0x91c0 },
	{ 0x7c6f, 0x946a },
	{ 0x7c70, 0x9742 },
	{ 0x7c71, 0x9748 },
	{ 0x7c72, 0x9744 },
	{ 0x7c73, 0x97c6 },
	{ 0x7c74, 0x9870 },
	{ 0x7c75, 0x9a5f },
	{ 0x7c76, 0x9b22 },
	{ 0x7c77, 0x9b58 },
	{ 0x7c78, 0x9c5f },
	{ 0x7c79, 0x9df9 },
	{ 0x7c7a, 0x9dfa },
	{ 0x7c7b, 0x9e7c },
	{ 0x7c7c, 0x9e7d },
	{ 0x7c7d, 0x9f07 },
	{ 0x7c7e, 0x9f77 },
	{ 0x7d21, 0x9f72 },
	{ 0x7d22, 0x5ef3 },
	{ 0x7d23, 0x6b16 },
	{ 0x7d24, 0x7063 },
	{ 0x7d25, 0x7c6c },
	{ 0x7d26, 0x7c6e },
	{ 0x7d27, 0x883b },
	{ 0x7d28, 0x89c0 },
	{ 0x7d29, 0x8ea1 },
	{ 0x7d2a, 0x91c1 },
	{ 0x7d2b, 0x9472 },
	{ 0x7d2c, 0x9470 },
	{ 0x7d2d, 0x9871 },
	{ 0x7d2e, 0x995e },
	{ 0x7d2f, 0x9ad6 },
	{ 0x7d30, 0x9b23 },
	{ 0x7d31, 0x9ecc },
	{ 0x7d32, 0x7064 },
	{ 0x7d33, 0x77da },
	{ 0x7d34, 0x8b9a },
	{ 0x7d35, 0x9477 },
	{ 0x7d36, 0x97c9 },
	{ 0x7d37, 0x9a62 },
	{ 0x7d38, 0x9a65 },
	{ 0x7d39, 0x7e9c },
	{ 0x7d3a, 0x8b9c },
	{ 0x7d3b, 0x8eaa },
	{ 0x7d3c, 0x91c5 },
	{ 0x7d3d, 0x947d },
	{ 0x7d3e, 0x947e },
	{ 0x7d3f, 0x947c },
	{ 0x7d40, 0x9c77 },
	{ 0x7d41, 0x9c78 },
	{ 0x7d42, 0x9ef7 },
	{ 0x7d43, 0x8c54 },
	{ 0x7d44, 0x947f },
	{ 0x7d45, 0x9e1a },
	{ 0x7d46, 0x7228 },
	{ 0x7d47, 0x9a6a },
	{ 0x7d48, 0x9b31 },
	{ 0x7d49, 0x9e1b },
	{ 0x7d4a, 0x9e1e },
	{ 0x7d4b, 0x7c72 }
};

/* CNS 11643 plane #2, leave unicode (UTF8) to be -1 if no mapping available */
cns_utf	cns2_utf_tab[MAX_CNS2_NUM] = {
	{ 0x2121, 0x4e42 },
	{ 0x2122, 0x4e5c },
	{ 0x2123, 0x51f5 },
	{ 0x2124, 0x531a },
	{ 0x2125, 0x5382 },
	{ 0x2126, 0x4e07 },
	{ 0x2127, 0x4e0c },
	{ 0x2128, 0x4e47 },
	{ 0x2129, 0x4e8d },
	{ 0x212a, 0x56d7 },
	{ 0x212b, 0x5c6e },
	{ 0x212c, 0x5f73 },
	{ 0x212d, 0x4e0f },
	{ 0x212e, 0x5187 },
	{ 0x212f, 0x4e0e },
	{ 0x2130, 0x4e2e },
	{ 0x2131, 0x4e93 },
	{ 0x2132, 0x4ec2 },
	{ 0x2133, 0x4ec9 },
	{ 0x2134, 0x4ec8 },
	{ 0x2135, 0x5198 },
	{ 0x2136, 0x52fc },
	{ 0x2137, 0x536c },
	{ 0x2138, 0x53b9 },
	{ 0x2139, 0x5720 },
	{ 0x213a, 0x5903 },
	{ 0x213b, 0x592c },
	{ 0x213c, 0x5c10 },
	{ 0x213d, 0x5dff },
	{ 0x213e, 0x65e1 },
	{ 0x213f, 0x6bb3 },
	{ 0x2140, 0x6bcc },
	{ 0x2141, 0x6c14 },
	{ 0x2142, 0x723f },
	{ 0x2143, 0x4e31 },
	{ 0x2144, 0x4e3c },
	{ 0x2145, 0x4ee8 },
	{ 0x2146, 0x4edc },
	{ 0x2147, 0x4ee9 },
	{ 0x2148, 0x4ee1 },
	{ 0x2149, 0x4edd },
	{ 0x214a, 0x4eda },
	{ 0x214b, 0x520c },
	{ 0x214c, 0x5209 },
	{ 0x214d, 0x531c },
	{ 0x214e, 0x534c },
	{ 0x214f, 0x5722 },
	{ 0x2150, 0x5723 },
	{ 0x2151, 0x5917 },
	{ 0x2152, 0x592f },
	{ 0x2153, 0x5b81 },
	{ 0x2154, 0x5b84 },
	{ 0x2155, 0x5c12 },
	{ 0x2156, 0x5c3b },
	{ 0x2157, 0x5c74 },
	{ 0x2158, 0x5c73 },
	{ 0x2159, 0x5e04 },
	{ 0x215a, 0x5e80 },
	{ 0x215b, 0x5e82 },
	{ 0x215c, 0x5fc9 },
	{ 0x215d, 0x6209 },
	{ 0x215e, 0x6250 },
	{ 0x215f, 0x6c15 },
	{ 0x2160, 0x6c36 },
	{ 0x2161, 0x6c43 },
	{ 0x2162, 0x6c3f },
	{ 0x2163, 0x6c3b },
	{ 0x2164, 0x72ae },
	{ 0x2165, 0x72b0 },
	{ 0x2166, 0x738a },
	{ 0x2167, 0x79b8 },
	{ 0x2168, 0x808a },
	{ 0x2169, 0x961e },
	{ 0x216a, 0x4f0e },
	{ 0x216b, 0x4f18 },
	{ 0x216c, 0x4f2c },
	{ 0x216d, 0x4ef5 },
	{ 0x216e, 0x4f14 },
	{ 0x216f, 0x4ef1 },
	{ 0x2170, 0x4f00 },
	{ 0x2171, 0x4ef7 },
	{ 0x2172, 0x4f08 },
	{ 0x2173, 0x4f1d },
	{ 0x2174, 0x4f02 },
	{ 0x2175, 0x4f05 },
	{ 0x2176, 0x4f22 },
	{ 0x2177, 0x4f13 },
	{ 0x2178, 0x4f04 },
	{ 0x2179, 0x4ef4 },
	{ 0x217a, 0x4f12 },
	{ 0x217b, 0x51b1 },
	{ 0x217c, 0x5213 },
	{ 0x217d, 0x5210 },
	{ 0x217e, 0x52a6 },
	{ 0x2221, 0x5322 },
	{ 0x2222, 0x531f },
	{ 0x2223, 0x534d },
	{ 0x2224, 0x538a },
	{ 0x2225, 0x5407 },
	{ 0x2226, 0x56e1 },
	{ 0x2227, 0x56df },
	{ 0x2228, 0x572e },
	{ 0x2229, 0x572a },
	{ 0x222a, 0x5734 },
	{ 0x222b, 0x593c },
	{ 0x222c, 0x5980 },
	{ 0x222d, 0x597c },
	{ 0x222e, 0x5985 },
	{ 0x222f, 0x597b },
	{ 0x2230, 0x597e },
	{ 0x2231, 0x5977 },
	{ 0x2232, 0x597f },
	{ 0x2233, 0x5b56 },
	{ 0x2234, 0x5c15 },
	{ 0x2235, 0x5c25 },
	{ 0x2236, 0x5c7c },
	{ 0x2237, 0x5c7a },
	{ 0x2238, 0x5c7b },
	{ 0x2239, 0x5c7e },
	{ 0x223a, 0x5ddf },
	{ 0x223b, 0x5e75 },
	{ 0x223c, 0x5e84 },
	{ 0x223d, 0x5f02 },
	{ 0x223e, 0x5f1a },
	{ 0x223f, 0x5f74 },
	{ 0x2240, 0x5fd5 },
	{ 0x2241, 0x5fd4 },
	{ 0x2242, 0x5fcf },
	{ 0x2243, 0x625c },
	{ 0x2244, 0x625e },
	{ 0x2245, 0x6264 },
	{ 0x2246, 0x6261 },
	{ 0x2247, 0x6266 },
	{ 0x2248, 0x6262 },
	{ 0x2249, 0x6259 },
	{ 0x224a, 0x6260 },
	{ 0x224b, 0x625a },
	{ 0x224c, 0x6265 },
	{ 0x224d, 0x6537 },
	{ 0x224e, 0x65ef },
	{ 0x224f, 0x65ee },
	{ 0x2250, 0x673e },
	{ 0x2251, 0x6739 },
	{ 0x2252, 0x6738 },
	{ 0x2253, 0x673b },
	{ 0x2254, 0x673a },
	{ 0x2255, 0x673f },
	{ 0x2256, 0x673c },
	{ 0x2257, 0x6733 },
	{ 0x2258, 0x6c18 },
	{ 0x2259, 0x6c46 },
	{ 0x225a, 0x6c52 },
	{ 0x225b, 0x6c5c },
	{ 0x225c, 0x6c4f },
	{ 0x225d, 0x6c4a },
	{ 0x225e, 0x6c54 },
	{ 0x225f, 0x6c4b },
	{ 0x2260, 0x6c4c },
	{ 0x2261, 0x7071 },
	{ 0x2262, 0x725e },
	{ 0x2263, 0x72b4 },
	{ 0x2264, 0x72b5 },
	{ 0x2265, 0x738e },
	{ 0x2266, 0x752a },
	{ 0x2267, 0x767f },
	{ 0x2268, 0x7a75 },
	{ 0x2269, 0x7f51 },
	{ 0x226a, 0x8278 },
	{ 0x226b, 0x827c },
	{ 0x226c, 0x8280 },
	{ 0x226d, 0x827d },
	{ 0x226e, 0x827f },
	{ 0x226f, 0x864d },
	{ 0x2270, 0x897e },
	{ 0x2271, 0x9099 },
	{ 0x2272, 0x9097 },
	{ 0x2273, 0x9098 },
	{ 0x2274, 0x909b },
	{ 0x2275, 0x9094 },
	{ 0x2276, 0x9622 },
	{ 0x2277, 0x9624 },
	{ 0x2278, 0x9620 },
	{ 0x2279, 0x9623 },
	{ 0x227a, 0x4f56 },
	{ 0x227b, 0x4f3b },
	{ 0x227c, 0x4f62 },
	{ 0x227d, 0x4f49 },
	{ 0x227e, 0x4f53 },
	{ 0x2321, 0x4f64 },
	{ 0x2322, 0x4f3e },
	{ 0x2323, 0x4f67 },
	{ 0x2324, 0x4f52 },
	{ 0x2325, 0x4f5f },
	{ 0x2326, 0x4f41 },
	{ 0x2327, 0x4f58 },
	{ 0x2328, 0x4f2d },
	{ 0x2329, 0x4f33 },
	{ 0x232a, 0x4f3f },
	{ 0x232b, 0x4f61 },
	{ 0x232c, 0x518f },
	{ 0x232d, 0x51b9 },
	{ 0x232e, 0x521c },
	{ 0x232f, 0x521e },
	{ 0x2330, 0x5221 },
	{ 0x2331, 0x52ad },
	{ 0x2332, 0x52ae },
	{ 0x2333, 0x5309 },
	{ 0x2334, 0x5363 },
	{ 0x2335, 0x5372 },
	{ 0x2336, 0x538e },
	{ 0x2337, 0x538f },
	{ 0x2338, 0x5430 },
	{ 0x2339, 0x5437 },
	{ 0x233a, 0x542a },
	{ 0x233b, 0x5454 },
	{ 0x233c, 0x5445 },
	{ 0x233d, 0x5419 },
	{ 0x233e, 0x541c },
	{ 0x233f, 0x5425 },
	{ 0x2340, 0x5418 },
	{ 0x2341, 0x543d },
	{ 0x2342, 0x544f },
	{ 0x2343, 0x5441 },
	{ 0x2344, 0x5428 },
	{ 0x2345, 0x5424 },
	{ 0x2346, 0x5447 },
	{ 0x2347, 0x56ee },
	{ 0x2348, 0x56e7 },
	{ 0x2349, 0x56e5 },
	{ 0x234a, 0x5741 },
	{ 0x234b, 0x5745 },
	{ 0x234c, 0x574c },
	{ 0x234d, 0x5749 },
	{ 0x234e, 0x574b },
	{ 0x234f, 0x5752 },
	{ 0x2350, 0x5906 },
	{ 0x2351, 0x5940 },
	{ 0x2352, 0x59a6 },
	{ 0x2353, 0x5998 },
	{ 0x2354, 0x59a0 },
	{ 0x2355, 0x5997 },
	{ 0x2356, 0x598e },
	{ 0x2357, 0x59a2 },
	{ 0x2358, 0x5990 },
	{ 0x2359, 0x598f },
	{ 0x235a, 0x59a7 },
	{ 0x235b, 0x59a1 },
	{ 0x235c, 0x5b8e },
	{ 0x235d, 0x5b92 },
	{ 0x235e, 0x5c28 },
	{ 0x235f, 0x5c2a },
	{ 0x2360, 0x5c8d },
	{ 0x2361, 0x5c8f },
	{ 0x2362, 0x5c88 },
	{ 0x2363, 0x5c8b },
	{ 0x2364, 0x5c89 },
	{ 0x2365, 0x5c92 },
	{ 0x2366, 0x5c8a },
	{ 0x2367, 0x5c86 },
	{ 0x2368, 0x5c93 },
	{ 0x2369, 0x5c95 },
	{ 0x236a, 0x5de0 },
	{ 0x236b, 0x5e0a },
	{ 0x236c, 0x5e0e },
	{ 0x236d, 0x5e8b },
	{ 0x236e, 0x5e89 },
	{ 0x236f, 0x5e8c },
	{ 0x2370, 0x5e88 },
	{ 0x2371, 0x5e8d },
	{ 0x2372, 0x5f05 },
	{ 0x2373, 0x5f1d },
	{ 0x2374, 0x5f78 },
	{ 0x2375, 0x5f76 },
	{ 0x2376, 0x5fd2 },
	{ 0x2377, 0x5fd1 },
	{ 0x2378, 0x5fd0 },
	{ 0x2379, 0x5fed },
	{ 0x237a, 0x5fe8 },
	{ 0x237b, 0x5fee },
	{ 0x237c, 0x5ff3 },
	{ 0x237d, 0x5fe1 },
	{ 0x237e, 0x5fe4 },
	{ 0x2421, 0x5fe3 },
	{ 0x2422, 0x5ffa },
	{ 0x2423, 0x5fef },
	{ 0x2424, 0x5ff7 },
	{ 0x2425, 0x5ffb },
	{ 0x2426, 0x6000 },
	{ 0x2427, 0x5ff4 },
	{ 0x2428, 0x623a },
	{ 0x2429, 0x6283 },
	{ 0x242a, 0x628c },
	{ 0x242b, 0x628e },
	{ 0x242c, 0x628f },
	{ 0x242d, 0x6294 },
	{ 0x242e, 0x6287 },
	{ 0x242f, 0x6271 },
	{ 0x2430, 0x627b },
	{ 0x2431, 0x627a },
	{ 0x2432, 0x6270 },
	{ 0x2433, 0x6281 },
	{ 0x2434, 0x6288 },
	{ 0x2435, 0x6277 },
	{ 0x2436, 0x627d },
	{ 0x2437, 0x6272 },
	{ 0x2438, 0x6274 },
	{ 0x2439, 0x65f0 },
	{ 0x243a, 0x65f4 },
	{ 0x243b, 0x65f3 },
	{ 0x243c, 0x65f2 },
	{ 0x243d, 0x65f5 },
	{ 0x243e, 0x6745 },
	{ 0x243f, 0x6747 },
	{ 0x2440, 0x6759 },
	{ 0x2441, 0x6755 },
	{ 0x2442, 0x674c },
	{ 0x2443, 0x6748 },
	{ 0x2444, 0x675d },
	{ 0x2445, 0x674d },
	{ 0x2446, 0x675a },
	{ 0x2447, 0x674b },
	{ 0x2448, 0x6bd0 },
	{ 0x2449, 0x6c19 },
	{ 0x244a, 0x6c1a },
	{ 0x244b, 0x6c78 },
	{ 0x244c, 0x6c67 },
	{ 0x244d, 0x6c6b },
	{ 0x244e, 0x6c84 },
	{ 0x244f, 0x6c8b },
	{ 0x2450, 0x6c8f },
	{ 0x2451, 0x6c71 },
	{ 0x2452, 0x6c6f },
	{ 0x2453, 0x6c69 },
	{ 0x2454, 0x6c9a },
	{ 0x2455, 0x6c6d },
	{ 0x2456, 0x6c87 },
	{ 0x2457, 0x6c95 },
	{ 0x2458, 0x6c9c },
	{ 0x2459, 0x6c66 },
	{ 0x245a, 0x6c73 },
	{ 0x245b, 0x6c65 },
	{ 0x245c, 0x6c7b },
	{ 0x245d, 0x6c8e },
	{ 0x245e, 0x7074 },
	{ 0x245f, 0x707a },
	{ 0x2460, 0x7263 },
	{ 0x2461, 0x72bf },
	{ 0x2462, 0x72bd },
	{ 0x2463, 0x72c3 },
	{ 0x2464, 0x72c6 },
	{ 0x2465, 0x72c1 },
	{ 0x2466, 0x72ba },
	{ 0x2467, 0x72c5 },
	{ 0x2468, 0x7395 },
	{ 0x2469, 0x7397 },
	{ 0x246a, 0x7393 },
	{ 0x246b, 0x7394 },
	{ 0x246c, 0x7392 },
	{ 0x246d, 0x753a },
	{ 0x246e, 0x7539 },
	{ 0x246f, 0x7594 },
	{ 0x2470, 0x7595 },
	{ 0x2471, 0x7681 },
	{ 0x2472, 0x793d },
	{ 0x2473, 0x8034 },
	{ 0x2474, 0x8095 },
	{ 0x2475, 0x8099 },
	{ 0x2476, 0x8090 },
	{ 0x2477, 0x8092 },
	{ 0x2478, 0x809c },
	{ 0x2479, 0x8290 },
	{ 0x247a, 0x828f },
	{ 0x247b, 0x8285 },
	{ 0x247c, 0x828e },
	{ 0x247d, 0x8291 },
	{ 0x247e, 0x8293 },
	{ 0x2521, 0x828a },
	{ 0x2522, 0x8283 },
	{ 0x2523, 0x8284 },
	{ 0x2524, 0x8c78 },
	{ 0x2525, 0x8fc9 },
	{ 0x2526, 0x8fbf },
	{ 0x2527, 0x909f },
	{ 0x2528, 0x90a1 },
	{ 0x2529, 0x90a5 },
	{ 0x252a, 0x909e },
	{ 0x252b, 0x90a7 },
	{ 0x252c, 0x90a0 },
	{ 0x252d, 0x9630 },
	{ 0x252e, 0x9628 },
	{ 0x252f, 0x962f },
	{ 0x2530, 0x962d },
	{ 0x2531, 0x4e33 },
	{ 0x2532, 0x4f98 },
	{ 0x2533, 0x4f7c },
	{ 0x2534, 0x4f85 },
	{ 0x2535, 0x4f7d },
	{ 0x2536, 0x4f80 },
	{ 0x2537, 0x4f87 },
	{ 0x2538, 0x4f76 },
	{ 0x2539, 0x4f74 },
	{ 0x253a, 0x4f89 },
	{ 0x253b, 0x4f84 },
	{ 0x253c, 0x4f77 },
	{ 0x253d, 0x4f4c },
	{ 0x253e, 0x4f97 },
	{ 0x253f, 0x4f6a },
	{ 0x2540, 0x4f9a },
	{ 0x2541, 0x4f79 },
	{ 0x2542, 0x4f81 },
	{ 0x2543, 0x4f78 },
	{ 0x2544, 0x4f90 },
	{ 0x2545, 0x4f9c },
	{ 0x2546, 0x4f94 },
	{ 0x2547, 0x4f9e },
	{ 0x2548, 0x4f92 },
	{ 0x2549, 0x4f82 },
	{ 0x254a, 0x4f95 },
	{ 0x254b, 0x4f6b },
	{ 0x254c, 0x4f6e },
	{ 0x254d, 0x519e },
	{ 0x254e, 0x51bc },
	{ 0x254f, 0x51be },
	{ 0x2550, 0x5235 },
	{ 0x2551, 0x5232 },
	{ 0x2552, 0x5233 },
	{ 0x2553, 0x5246 },
	{ 0x2554, 0x5231 },
	{ 0x2555, 0x52bc },
	{ 0x2556, 0x530a },
	{ 0x2557, 0x530b },
	{ 0x2558, 0x533c },
	{ 0x2559, 0x5392 },
	{ 0x255a, 0x5394 },
	{ 0x255b, 0x5487 },
	{ 0x255c, 0x547f },
	{ 0x255d, 0x5481 },
	{ 0x255e, 0x5491 },
	{ 0x255f, 0x5482 },
	{ 0x2560, 0x5488 },
	{ 0x2561, 0x546b },
	{ 0x2562, 0x547a },
	{ 0x2563, 0x547e },
	{ 0x2564, 0x5465 },
	{ 0x2565, 0x546c },
	{ 0x2566, 0x5474 },
	{ 0x2567, 0x5466 },
	{ 0x2568, 0x548d },
	{ 0x2569, 0x546f },
	{ 0x256a, 0x5461 },
	{ 0x256b, 0x5460 },
	{ 0x256c, 0x5498 },
	{ 0x256d, 0x5463 },
	{ 0x256e, 0x5467 },
	{ 0x256f, 0x5464 },
	{ 0x2570, 0x56f7 },
	{ 0x2571, 0x56f9 },
	{ 0x2572, 0x576f },
	{ 0x2573, 0x5772 },
	{ 0x2574, 0x576d },
	{ 0x2575, 0x576b },
	{ 0x2576, 0x5771 },
	{ 0x2577, 0x5770 },
	{ 0x2578, 0x5776 },
	{ 0x2579, 0x5780 },
	{ 0x257a, 0x5775 },
	{ 0x257b, 0x577b },
	{ 0x257c, 0x5773 },
	{ 0x257d, 0x5774 },
	{ 0x257e, 0x5762 },
	{ 0x2621, 0x5768 },
	{ 0x2622, 0x577d },
	{ 0x2623, 0x590c },
	{ 0x2624, 0x5945 },
	{ 0x2625, 0x59b5 },
	{ 0x2626, 0x59ba },
	{ 0x2627, 0x59cf },
	{ 0x2628, 0x59ce },
	{ 0x2629, 0x59b2 },
	{ 0x262a, 0x59cc },
	{ 0x262b, 0x59c1 },
	{ 0x262c, 0x59b6 },
	{ 0x262d, 0x59bc },
	{ 0x262e, 0x59c3 },
	{ 0x262f, 0x59d6 },
	{ 0x2630, 0x59b1 },
	{ 0x2631, 0x59bd },
	{ 0x2632, 0x59c0 },
	{ 0x2633, 0x59c8 },
	{ 0x2634, 0x59b4 },
	{ 0x2635, 0x59c7 },
	{ 0x2636, 0x5b62 },
	{ 0x2637, 0x5b65 },
	{ 0x2638, 0x5b93 },
	{ 0x2639, 0x5b95 },
	{ 0x263a, 0x5c44 },
	{ 0x263b, 0x5c47 },
	{ 0x263c, 0x5cae },
	{ 0x263d, 0x5ca4 },
	{ 0x263e, 0x5ca0 },
	{ 0x263f, 0x5cb5 },
	{ 0x2640, 0x5caf },
	{ 0x2641, 0x5ca8 },
	{ 0x2642, 0x5cac },
	{ 0x2643, 0x5c9f },
	{ 0x2644, 0x5ca3 },
	{ 0x2645, 0x5cad },
	{ 0x2646, 0x5ca2 },
	{ 0x2647, 0x5caa },
	{ 0x2648, 0x5ca7 },
	{ 0x2649, 0x5c9d },
	{ 0x264a, 0x5ca5 },
	{ 0x264b, 0x5cb6 },
	{ 0x264c, 0x5cb0 },
	{ 0x264d, 0x5ca6 },
	{ 0x264e, 0x5e17 },
	{ 0x264f, 0x5e14 },
	{ 0x2650, 0x5e19 },
	{ 0x2651, 0x5f28 },
	{ 0x2652, 0x5f22 },
	{ 0x2653, 0x5f23 },
	{ 0x2654, 0x5f24 },
	{ 0x2655, 0x5f54 },
	{ 0x2656, 0x5f82 },
	{ 0x2657, 0x5f7e },
	{ 0x2658, 0x5f7d },
	{ 0x2659, 0x5fde },
	{ 0x265a, 0x5fe5 },
	{ 0x265b, 0x602d },
	{ 0x265c, 0x6026 },
	{ 0x265d, 0x6019 },
	{ 0x265e, 0x6032 },
	{ 0x265f, 0x600b },
	{ 0x2660, 0x6034 },
	{ 0x2661, 0x600a },
	{ 0x2662, 0x6017 },
	{ 0x2663, 0x6033 },
	{ 0x2664, 0x601a },
	{ 0x2665, 0x601e },
	{ 0x2666, 0x602c },
	{ 0x2667, 0x6022 },
	{ 0x2668, 0x600d },
	{ 0x2669, 0x6010 },
	{ 0x266a, 0x602e },
	{ 0x266b, 0x6013 },
	{ 0x266c, 0x6011 },
	{ 0x266d, 0x600c },
	{ 0x266e, 0x6009 },
	{ 0x266f, 0x601c },
	{ 0x2670, 0x6214 },
	{ 0x2671, 0x623d },
	{ 0x2672, 0x62ad },
	{ 0x2673, 0x62b4 },
	{ 0x2674, 0x62d1 },
	{ 0x2675, 0x62be },
	{ 0x2676, 0x62aa },
	{ 0x2677, 0x62b6 },
	{ 0x2678, 0x62ca },
	{ 0x2679, 0x62ae },
	{ 0x267a, 0x62b3 },
	{ 0x267b, 0x62af },
	{ 0x267c, 0x62bb },
	{ 0x267d, 0x62a9 },
	{ 0x267e, 0x62b0 },
	{ 0x2721, 0x62b8 },
	{ 0x2722, 0x653d },
	{ 0x2723, 0x65a8 },
	{ 0x2724, 0x65bb },
	{ 0x2725, 0x6609 },
	{ 0x2726, 0x65fc },
	{ 0x2727, 0x6604 },
	{ 0x2728, 0x6612 },
	{ 0x2729, 0x6608 },
	{ 0x272a, 0x65fb },
	{ 0x272b, 0x6603 },
	{ 0x272c, 0x660b },
	{ 0x272d, 0x660d },
	{ 0x272e, 0x6605 },
	{ 0x272f, 0x65fd },
	{ 0x2730, 0x6611 },
	{ 0x2731, 0x6610 },
	{ 0x2732, 0x66f6 },
	{ 0x2733, 0x670a },
	{ 0x2734, 0x6785 },
	{ 0x2735, 0x676c },
	{ 0x2736, 0x678e },
	{ 0x2737, 0x6792 },
	{ 0x2738, 0x6776 },
	{ 0x2739, 0x677b },
	{ 0x273a, 0x6798 },
	{ 0x273b, 0x6786 },
	{ 0x273c, 0x6784 },
	{ 0x273d, 0x6774 },
	{ 0x273e, 0x678d },
	{ 0x273f, 0x678c },
	{ 0x2740, 0x677a },
	{ 0x2741, 0x679f },
	{ 0x2742, 0x6791 },
	{ 0x2743, 0x6799 },
	{ 0x2744, 0x6783 },
	{ 0x2745, 0x677d },
	{ 0x2746, 0x6781 },
	{ 0x2747, 0x6778 },
	{ 0x2748, 0x6779 },
	{ 0x2749, 0x6794 },
	{ 0x274a, 0x6b25 },
	{ 0x274b, 0x6b80 },
	{ 0x274c, 0x6b7e },
	{ 0x274d, 0x6bde },
	{ 0x274e, 0x6c1d },
	{ 0x274f, 0x6c93 },
	{ 0x2750, 0x6cec },
	{ 0x2751, 0x6ceb },
	{ 0x2752, 0x6cee },
	{ 0x2753, 0x6cd9 },
	{ 0x2754, 0x6cb6 },
	{ 0x2755, 0x6cd4 },
	{ 0x2756, 0x6cad },
	{ 0x2757, 0x6ce7 },
	{ 0x2758, 0x6cb7 },
	{ 0x2759, 0x6cd0 },
	{ 0x275a, 0x6cc2 },
	{ 0x275b, 0x6cba },
	{ 0x275c, 0x6cc3 },
	{ 0x275d, 0x6cc6 },
	{ 0x275e, 0x6ced },
	{ 0x275f, 0x6cf2 },
	{ 0x2760, 0x6cd2 },
	{ 0x2761, 0x6cdd },
	{ 0x2762, 0x6cb4 },
	{ 0x2763, 0x6c8a },
	{ 0x2764, 0x6c9d },
	{ 0x2765, 0x6c80 },
	{ 0x2766, 0x6cde },
	{ 0x2767, 0x6cc0 },
	{ 0x2768, 0x6d30 },
	{ 0x2769, 0x6ccd },
	{ 0x276a, 0x6cc7 },
	{ 0x276b, 0x6cb0 },
	{ 0x276c, 0x6cf9 },
	{ 0x276d, 0x6ccf },
	{ 0x276e, 0x6ce9 },
	{ 0x276f, 0x6cd1 },
	{ 0x2770, 0x7094 },
	{ 0x2771, 0x7098 },
	{ 0x2772, 0x7085 },
	{ 0x2773, 0x7093 },
	{ 0x2774, 0x7086 },
	{ 0x2775, 0x7084 },
	{ 0x2776, 0x7091 },
	{ 0x2777, 0x7096 },
	{ 0x2778, 0x7082 },
	{ 0x2779, 0x709a },
	{ 0x277a, 0x7083 },
	{ 0x277b, 0x726a },
	{ 0x277c, 0x72d6 },
	{ 0x277d, 0x72cb },
	{ 0x277e, 0x72d8 },
	{ 0x2821, 0x72c9 },
	{ 0x2822, 0x72dc },
	{ 0x2823, 0x72d2 },
	{ 0x2824, 0x72d4 },
	{ 0x2825, 0x72da },
	{ 0x2826, 0x72cc },
	{ 0x2827, 0x72d1 },
	{ 0x2828, 0x73a4 },
	{ 0x2829, 0x73a1 },
	{ 0x282a, 0x73ad },
	{ 0x282b, 0x73a6 },
	{ 0x282c, 0x73a2 },
	{ 0x282d, 0x73a0 },
	{ 0x282e, 0x73ac },
	{ 0x282f, 0x739d },
	{ 0x2830, 0x74dd },
	{ 0x2831, 0x74e8 },
	{ 0x2832, 0x753f },
	{ 0x2833, 0x7540 },
	{ 0x2834, 0x753e },
	{ 0x2835, 0x758c },
	{ 0x2836, 0x7598 },
	{ 0x2837, 0x76af },
	{ 0x2838, 0x76f3 },
	{ 0x2839, 0x76f1 },
	{ 0x283a, 0x76f0 },
	{ 0x283b, 0x76f5 },
	{ 0x283c, 0x77f8 },
	{ 0x283d, 0x77fc },
	{ 0x283e, 0x77f9 },
	{ 0x283f, 0x77fb },
	{ 0x2840, 0x77fa },
	{ 0x2841, 0x77f7 },
	{ 0x2842, 0x7942 },
	{ 0x2843, 0x793f },
	{ 0x2844, 0x79c5 },
	{ 0x2845, 0x7a78 },
	{ 0x2846, 0x7a7b },
	{ 0x2847, 0x7afb },
	{ 0x2848, 0x7c75 },
	{ 0x2849, 0x7cfd },
	{ 0x284a, 0x8035 },
	{ 0x284b, 0x808f },
	{ 0x284c, 0x80ae },
	{ 0x284d, 0x80a3 },
	{ 0x284e, 0x80b8 },
	{ 0x284f, 0x80b5 },
	{ 0x2850, 0x80ad },
	{ 0x2851, 0x8220 },
	{ 0x2852, 0x82a0 },
	{ 0x2853, 0x82c0 },
	{ 0x2854, 0x82ab },
	{ 0x2855, 0x829a },
	{ 0x2856, 0x8298 },
	{ 0x2857, 0x829b },
	{ 0x2858, 0x82b5 },
	{ 0x2859, 0x82a7 },
	{ 0x285a, 0x82ae },
	{ 0x285b, 0x82bc },
	{ 0x285c, 0x829e },
	{ 0x285d, 0x82ba },
	{ 0x285e, 0x82b4 },
	{ 0x285f, 0x82a8 },
	{ 0x2860, 0x82a1 },
	{ 0x2861, 0x82a9 },
	{ 0x2862, 0x82c2 },
	{ 0x2863, 0x82a4 },
	{ 0x2864, 0x82c3 },
	{ 0x2865, 0x82b6 },
	{ 0x2866, 0x82a2 },
	{ 0x2867, 0x8670 },
	{ 0x2868, 0x866f },
	{ 0x2869, 0x866d },
	{ 0x286a, 0x866e },
	{ 0x286b, 0x8c56 },
	{ 0x286c, 0x8fd2 },
	{ 0x286d, 0x8fcb },
	{ 0x286e, 0x8fd3 },
	{ 0x286f, 0x8fcd },
	{ 0x2870, 0x8fd6 },
	{ 0x2871, 0x8fd5 },
	{ 0x2872, 0x8fd7 },
	{ 0x2873, 0x90b2 },
	{ 0x2874, 0x90b4 },
	{ 0x2875, 0x90af },
	{ 0x2876, 0x90b3 },
	{ 0x2877, 0x90b0 },
	{ 0x2878, 0x9639 },
	{ 0x2879, 0x963d },
	{ 0x287a, 0x963c },
	{ 0x287b, 0x963a },
	{ 0x287c, 0x9643 },
	{ 0x287d, 0x4fcd },
	{ 0x287e, 0x4fc5 },
	{ 0x2921, 0x4fd3 },
	{ 0x2922, 0x4fb2 },
	{ 0x2923, 0x4fc9 },
	{ 0x2924, 0x4fcb },
	{ 0x2925, 0x4fc1 },
	{ 0x2926, 0x4fd4 },
	{ 0x2927, 0x4fdc },
	{ 0x2928, 0x4fd9 },
	{ 0x2929, 0x4fbb },
	{ 0x292a, 0x4fb3 },
	{ 0x292b, 0x4fdb },
	{ 0x292c, 0x4fc7 },
	{ 0x292d, 0x4fd6 },
	{ 0x292e, 0x4fba },
	{ 0x292f, 0x4fc0 },
	{ 0x2930, 0x4fb9 },
	{ 0x2931, 0x4fec },
	{ 0x2932, 0x5244 },
	{ 0x2933, 0x5249 },
	{ 0x2934, 0x52c0 },
	{ 0x2935, 0x52c2 },
	{ 0x2936, 0x533d },
	{ 0x2937, 0x537c },
	{ 0x2938, 0x5397 },
	{ 0x2939, 0x5396 },
	{ 0x293a, 0x5399 },
	{ 0x293b, 0x5398 },
	{ 0x293c, 0x54ba },
	{ 0x293d, 0x54a1 },
	{ 0x293e, 0x54ad },
	{ 0x293f, 0x54a5 },
	{ 0x2940, 0x54cf },
	{ 0x2941, 0x54c3 },
	{ 0x2942, 0x830d },
	{ 0x2943, 0x54b7 },
	{ 0x2944, 0x54ae },
	{ 0x2945, 0x54d6 },
	{ 0x2946, 0x54b6 },
	{ 0x2947, 0x54c5 },
	{ 0x2948, 0x54c6 },
	{ 0x2949, 0x54a0 },
	{ 0x294a, 0x5470 },
	{ 0x294b, 0x54bc },
	{ 0x294c, 0x54a2 },
	{ 0x294d, 0x54be },
	{ 0x294e, 0x5472 },
	{ 0x294f, 0x54de },
	{ 0x2950, 0x54b0 },
	{ 0x2951, 0x57b5 },
	{ 0x2952, 0x579e },
	{ 0x2953, 0x579f },
	{ 0x2954, 0x57a4 },
	{ 0x2955, 0x578c },
	{ 0x2956, 0x5797 },
	{ 0x2957, 0x579d },
	{ 0x2958, 0x579b },
	{ 0x2959, 0x5794 },
	{ 0x295a, 0x5798 },
	{ 0x295b, 0x578f },
	{ 0x295c, 0x5799 },
	{ 0x295d, 0x57a5 },
	{ 0x295e, 0x579a },
	{ 0x295f, 0x5795 },
	{ 0x2960, 0x58f4 },
	{ 0x2961, 0x590d },
	{ 0x2962, 0x5953 },
	{ 0x2963, 0x59e1 },
	{ 0x2964, 0x59de },
	{ 0x2965, 0x59ee },
	{ 0x2966, 0x5a00 },
	{ 0x2967, 0x59f1 },
	{ 0x2968, 0x59dd },
	{ 0x2969, 0x59fa },
	{ 0x296a, 0x59fd },
	{ 0x296b, 0x59fc },
	{ 0x296c, 0x59f6 },
	{ 0x296d, 0x59e4 },
	{ 0x296e, 0x59f2 },
	{ 0x296f, 0x59f7 },
	{ 0x2970, 0x59db },
	{ 0x2971, 0x59e9 },
	{ 0x2972, 0x59f3 },
	{ 0x2973, 0x59f5 },
	{ 0x2974, 0x59e0 },
	{ 0x2975, 0x59fe },
	{ 0x2976, 0x59f4 },
	{ 0x2977, 0x59ed },
	{ 0x2978, 0x5ba8 },
	{ 0x2979, 0x5c4c },
	{ 0x297a, 0x5cd0 },
	{ 0x297b, 0x5cd8 },
	{ 0x297c, 0x5ccc },
	{ 0x297d, 0x5cd7 },
	{ 0x297e, 0x5ccb },
	{ 0x2a21, 0x5cdb },
	{ 0x2a22, 0x5cde },
	{ 0x2a23, 0x5cda },
	{ 0x2a24, 0x5cc9 },
	{ 0x2a25, 0x5cc7 },
	{ 0x2a26, 0x5cca },
	{ 0x2a27, 0x5cd6 },
	{ 0x2a28, 0x5cd3 },
	{ 0x2a29, 0x5cd4 },
	{ 0x2a2a, 0x5ccf },
	{ 0x2a2b, 0x5cc8 },
	{ 0x2a2c, 0x5cc6 },
	{ 0x2a2d, 0x5cce },
	{ 0x2a2e, 0x5cdf },
	{ 0x2a2f, 0x5cf8 },
	{ 0x2a30, 0x5df9 },
	{ 0x2a31, 0x5e21 },
	{ 0x2a32, 0x5e22 },
	{ 0x2a33, 0x5e23 },
	{ 0x2a34, 0x5e20 },
	{ 0x2a35, 0x5e24 },
	{ 0x2a36, 0x5eb0 },
	{ 0x2a37, 0x5ea4 },
	{ 0x2a38, 0x5ea2 },
	{ 0x2a39, 0x5e9b },
	{ 0x2a3a, 0x5ea3 },
	{ 0x2a3b, 0x5ea5 },
	{ 0x2a3c, 0x5f07 },
	{ 0x2a3d, 0x5f2e },
	{ 0x2a3e, 0x5f56 },
	{ 0x2a3f, 0x5f86 },
	{ 0x2a40, 0x6037 },
	{ 0x2a41, 0x6039 },
	{ 0x2a42, 0x6054 },
	{ 0x2a43, 0x6072 },
	{ 0x2a44, 0x605e },
	{ 0x2a45, 0x6045 },
	{ 0x2a46, 0x6053 },
	{ 0x2a47, 0x6047 },
	{ 0x2a48, 0x6049 },
	{ 0x2a49, 0x605b },
	{ 0x2a4a, 0x604c },
	{ 0x2a4b, 0x6040 },
	{ 0x2a4c, 0x6042 },
	{ 0x2a4d, 0x605f },
	{ 0x2a4e, 0x6024 },
	{ 0x2a4f, 0x6044 },
	{ 0x2a50, 0x6058 },
	{ 0x2a51, 0x6066 },
	{ 0x2a52, 0x606e },
	{ 0x2a53, 0x6242 },
	{ 0x2a54, 0x6243 },
	{ 0x2a55, 0x62cf },
	{ 0x2a56, 0x630d },
	{ 0x2a57, 0x630b },
	{ 0x2a58, 0x62f5 },
	{ 0x2a59, 0x630e },
	{ 0x2a5a, 0x6303 },
	{ 0x2a5b, 0x62eb },
	{ 0x2a5c, 0x62f9 },
	{ 0x2a5d, 0x630f },
	{ 0x2a5e, 0x630c },
	{ 0x2a5f, 0x62f8 },
	{ 0x2a60, 0x62f6 },
	{ 0x2a61, 0x6300 },
	{ 0x2a62, 0x6313 },
	{ 0x2a63, 0x6314 },
	{ 0x2a64, 0x62fa },
	{ 0x2a65, 0x6315 },
	{ 0x2a66, 0x62fb },
	{ 0x2a67, 0x62f0 },
	{ 0x2a68, 0x6541 },
	{ 0x2a69, 0x6543 },
	{ 0x2a6a, 0x65aa },
	{ 0x2a6b, 0x65bf },
	{ 0x2a6c, 0x6636 },
	{ 0x2a6d, 0x6621 },
	{ 0x2a6e, 0x6632 },
	{ 0x2a6f, 0x6635 },
	{ 0x2a70, 0x661c },
	{ 0x2a71, 0x6626 },
	{ 0x2a72, 0x6622 },
	{ 0x2a73, 0x6633 },
	{ 0x2a74, 0x662b },
	{ 0x2a75, 0x663a },
	{ 0x2a76, 0x661d },
	{ 0x2a77, 0x6634 },
	{ 0x2a78, 0x6639 },
	{ 0x2a79, 0x662e },
	{ 0x2a7a, 0x670f },
	{ 0x2a7b, 0x6710 },
	{ 0x2a7c, 0x67c1 },
	{ 0x2a7d, 0x67f2 },
	{ 0x2a7e, 0x67c8 },
	{ 0x2b21, 0x67ba },
	{ 0x2b22, 0x67dc },
	{ 0x2b23, 0x67bb },
	{ 0x2b24, 0x67f8 },
	{ 0x2b25, 0x67d8 },
	{ 0x2b26, 0x67c0 },
	{ 0x2b27, 0x67b7 },
	{ 0x2b28, 0x67c5 },
	{ 0x2b29, 0x67eb },
	{ 0x2b2a, 0x67e4 },
	{ 0x2b2b, 0x67df },
	{ 0x2b2c, 0x67b5 },
	{ 0x2b2d, 0x67cd },
	{ 0x2b2e, 0x67b3 },
	{ 0x2b2f, 0x67f7 },
	{ 0x2b30, 0x67f6 },
	{ 0x2b31, 0x67ee },
	{ 0x2b32, 0x67e3 },
	{ 0x2b33, 0x67c2 },
	{ 0x2b34, 0x67b9 },
	{ 0x2b35, 0x67ce },
	{ 0x2b36, 0x67e7 },
	{ 0x2b37, 0x67f0 },
	{ 0x2b38, 0x67b2 },
	{ 0x2b39, 0x67fc },
	{ 0x2b3a, 0x67c6 },
	{ 0x2b3b, 0x67ed },
	{ 0x2b3c, 0x67cc },
	{ 0x2b3d, 0x67ae },
	{ 0x2b3e, 0x67e6 },
	{ 0x2b3f, 0x67db },
	{ 0x2b40, 0x67fa },
	{ 0x2b41, 0x67c9 },
	{ 0x2b42, 0x67ca },
	{ 0x2b43, 0x67c3 },
	{ 0x2b44, 0x67ea },
	{ 0x2b45, 0x67cb },
	{ 0x2b46, 0x6b28 },
	{ 0x2b47, 0x6b82 },
	{ 0x2b48, 0x6b84 },
	{ 0x2b49, 0x6bb6 },
	{ 0x2b4a, 0x6bd6 },
	{ 0x2b4b, 0x6bd8 },
	{ 0x2b4c, 0x6be0 },
	{ 0x2b4d, 0x6c20 },
	{ 0x2b4e, 0x6c21 },
	{ 0x2b4f, 0x6d28 },
	{ 0x2b50, 0x6d34 },
	{ 0x2b51, 0x6d2d },
	{ 0x2b52, 0x6d1f },
	{ 0x2b53, 0x6d3c },
	{ 0x2b54, 0x6d3f },
	{ 0x2b55, 0x6d12 },
	{ 0x2b56, 0x6d0a },
	{ 0x2b57, 0x6cda },
	{ 0x2b58, 0x6d33 },
	{ 0x2b59, 0x6d04 },
	{ 0x2b5a, 0x6d19 },
	{ 0x2b5b, 0x6d3a },
	{ 0x2b5c, 0x6d1a },
	{ 0x2b5d, 0x6d11 },
	{ 0x2b5e, 0x6d00 },
	{ 0x2b5f, 0x6d1d },
	{ 0x2b60, 0x6d42 },
	{ 0x2b61, 0x6d01 },
	{ 0x2b62, 0x6d18 },
	{ 0x2b63, 0x6d37 },
	{ 0x2b64, 0x6d03 },
	{ 0x2b65, 0x6d0f },
	{ 0x2b66, 0x6d40 },
	{ 0x2b67, 0x6d07 },
	{ 0x2b68, 0x6d20 },
	{ 0x2b69, 0x6d2c },
	{ 0x2b6a, 0x6d08 },
	{ 0x2b6b, 0x6d22 },
	{ 0x2b6c, 0x6d09 },
	{ 0x2b6d, 0x6d10 },
	{ 0x2b6e, 0x70b7 },
	{ 0x2b6f, 0x709f },
	{ 0x2b70, 0x70be },
	{ 0x2b71, 0x70b1 },
	{ 0x2b72, 0x70b0 },
	{ 0x2b73, 0x70a1 },
	{ 0x2b74, 0x70b4 },
	{ 0x2b75, 0x70b5 },
	{ 0x2b76, 0x70a9 },
	{ 0x2b77, 0x7241 },
	{ 0x2b78, 0x7249 },
	{ 0x2b79, 0x724a },
	{ 0x2b7a, 0x726c },
	{ 0x2b7b, 0x7270 },
	{ 0x2b7c, 0x7273 },
	{ 0x2b7d, 0x726e },
	{ 0x2b7e, 0x72ca },
	{ 0x2c21, 0x72e4 },
	{ 0x2c22, 0x72e8 },
	{ 0x2c23, 0x72eb },
	{ 0x2c24, 0x72df },
	{ 0x2c25, 0x72ea },
	{ 0x2c26, 0x72e6 },
	{ 0x2c27, 0x72e3 },
	{ 0x2c28, 0x7385 },
	{ 0x2c29, 0x73cc },
	{ 0x2c2a, 0x73c2 },
	{ 0x2c2b, 0x73c8 },
	{ 0x2c2c, 0x73c5 },
	{ 0x2c2d, 0x73b9 },
	{ 0x2c2e, 0x73b6 },
	{ 0x2c2f, 0x73b5 },
	{ 0x2c30, 0x73b4 },
	{ 0x2c31, 0x73eb },
	{ 0x2c32, 0x73bf },
	{ 0x2c33, 0x73c7 },
	{ 0x2c34, 0x73be },
	{ 0x2c35, 0x73c3 },
	{ 0x2c36, 0x73c6 },
	{ 0x2c37, 0x73b8 },
	{ 0x2c38, 0x73cb },
	{ 0x2c39, 0x74ec },
	{ 0x2c3a, 0x74ee },
	{ 0x2c3b, 0x752e },
	{ 0x2c3c, 0x7547 },
	{ 0x2c3d, 0x7548 },
	{ 0x2c3e, 0x75a7 },
	{ 0x2c3f, 0x75aa },
	{ 0x2c40, 0x7679 },
	{ 0x2c41, 0x76c4 },
	{ 0x2c42, 0x7708 },
	{ 0x2c43, 0x7703 },
	{ 0x2c44, 0x7704 },
	{ 0x2c45, 0x7705 },
	{ 0x2c46, 0x770a },
	{ 0x2c47, 0x76f7 },
	{ 0x2c48, 0x76fb },
	{ 0x2c49, 0x76fa },
	{ 0x2c4a, 0x77e7 },
	{ 0x2c4b, 0x77e8 },
	{ 0x2c4c, 0x7806 },
	{ 0x2c4d, 0x7811 },
	{ 0x2c4e, 0x7812 },
	{ 0x2c4f, 0x7805 },
	{ 0x2c50, 0x7810 },
	{ 0x2c51, 0x780f },
	{ 0x2c52, 0x780e },
	{ 0x2c53, 0x7809 },
	{ 0x2c54, 0x7803 },
	{ 0x2c55, 0x7813 },
	{ 0x2c56, 0x794a },
	{ 0x2c57, 0x794c },
	{ 0x2c58, 0x794b },
	{ 0x2c59, 0x7945 },
	{ 0x2c5a, 0x7944 },
	{ 0x2c5b, 0x79d5 },
	{ 0x2c5c, 0x79cd },
	{ 0x2c5d, 0x79cf },
	{ 0x2c5e, 0x79d6 },
	{ 0x2c5f, 0x79ce },
	{ 0x2c60, 0x7a80 },
	{ 0x2c61, 0x7a7e },
	{ 0x2c62, 0x7ad1 },
	{ 0x2c63, 0x7b00 },
	{ 0x2c64, 0x7b01 },
	{ 0x2c65, 0x7c7a },
	{ 0x2c66, 0x7c78 },
	{ 0x2c67, 0x7c79 },
	{ 0x2c68, 0x7c7f },
	{ 0x2c69, 0x7c80 },
	{ 0x2c6a, 0x7c81 },
	{ 0x2c6b, 0x7d03 },
	{ 0x2c6c, 0x7d08 },
	{ 0x2c6d, 0x7d01 },
	{ 0x2c6e, 0x7f58 },
	{ 0x2c6f, 0x7f91 },
	{ 0x2c70, 0x7f8d },
	{ 0x2c71, 0x7fbe },
	{ 0x2c72, 0x8007 },
	{ 0x2c73, 0x800e },
	{ 0x2c74, 0x800f },
	{ 0x2c75, 0x8014 },
	{ 0x2c76, 0x8037 },
	{ 0x2c77, 0x80d8 },
	{ 0x2c78, 0x80c7 },
	{ 0x2c79, 0x80e0 },
	{ 0x2c7a, 0x80d1 },
	{ 0x2c7b, 0x80c8 },
	{ 0x2c7c, 0x80c2 },
	{ 0x2c7d, 0x80d0 },
	{ 0x2c7e, 0x80c5 },
	{ 0x2d21, 0x80e3 },
	{ 0x2d22, 0x80d9 },
	{ 0x2d23, 0x80dc },
	{ 0x2d24, 0x80ca },
	{ 0x2d25, 0x80d5 },
	{ 0x2d26, 0x80c9 },
	{ 0x2d27, 0x80cf },
	{ 0x2d28, 0x80d7 },
	{ 0x2d29, 0x80e6 },
	{ 0x2d2a, 0x80cd },
	{ 0x2d2b, 0x81ff },
	{ 0x2d2c, 0x8221 },
	{ 0x2d2d, 0x8294 },
	{ 0x2d2e, 0x82d9 },
	{ 0x2d2f, 0x82fe },
	{ 0x2d30, 0x82f9 },
	{ 0x2d31, 0x8307 },
	{ 0x2d32, 0x82e8 },
	{ 0x2d33, 0x8300 },
	{ 0x2d34, 0x82d5 },
	{ 0x2d35, 0x833a },
	{ 0x2d36, 0x82eb },
	{ 0x2d37, 0x82d6 },
	{ 0x2d38, 0x82f4 },
	{ 0x2d39, 0x82ec },
	{ 0x2d3a, 0x82e1 },
	{ 0x2d3b, 0x82f2 },
	{ 0x2d3c, 0x82f5 },
	{ 0x2d3d, 0x830c },
	{ 0x2d3e, 0x82fb },
	{ 0x2d3f, 0x82f6 },
	{ 0x2d40, 0x82f0 },
	{ 0x2d41, 0x82ea },
	{ 0x2d42, 0x82e4 },
	{ 0x2d43, 0x82e0 },
	{ 0x2d44, 0x82fa },
	{ 0x2d45, 0x82f3 },
	{ 0x2d46, 0x82ed },
	{ 0x2d47, 0x8677 },
	{ 0x2d48, 0x8674 },
	{ 0x2d49, 0x867c },
	{ 0x2d4a, 0x8673 },
	{ 0x2d4b, 0x8841 },
	{ 0x2d4c, 0x884e },
	{ 0x2d4d, 0x8867 },
	{ 0x2d4e, 0x886a },
	{ 0x2d4f, 0x8869 },
	{ 0x2d50, 0x89d3 },
	{ 0x2d51, 0x8a04 },
	{ 0x2d52, 0x8a07 },
	{ 0x2d53, 0x8d72 },
	{ 0x2d54, 0x8fe3 },
	{ 0x2d55, 0x8fe1 },
	{ 0x2d56, 0x8fee },
	{ 0x2d57, 0x8fe0 },
	{ 0x2d58, 0x90f1 },
	{ 0x2d59, 0x90bd },
	{ 0x2d5a, 0x90bf },
	{ 0x2d5b, 0x90d5 },
	{ 0x2d5c, 0x90c5 },
	{ 0x2d5d, 0x90be },
	{ 0x2d5e, 0x90c7 },
	{ 0x2d5f, 0x90cb },
	{ 0x2d60, 0x90c8 },
	{ 0x2d61, 0x91d4 },
	{ 0x2d62, 0x91d3 },
	{ 0x2d63, 0x9654 },
	{ 0x2d64, 0x964f },
	{ 0x2d65, 0x9651 },
	{ 0x2d66, 0x9653 },
	{ 0x2d67, 0x964a },
	{ 0x2d68, 0x964e },
	{ 0x2d69, 0x501e },
	{ 0x2d6a, 0x5005 },
	{ 0x2d6b, 0x5007 },
	{ 0x2d6c, 0x5013 },
	{ 0x2d6d, 0x5022 },
	{ 0x2d6e, 0x5030 },
	{ 0x2d6f, 0x501b },
	{ 0x2d70, 0x4ff5 },
	{ 0x2d71, 0x4ff4 },
	{ 0x2d72, 0x5033 },
	{ 0x2d73, 0x5037 },
	{ 0x2d74, 0x502c },
	{ 0x2d75, 0x4ff6 },
	{ 0x2d76, 0x4ff7 },
	{ 0x2d77, 0x5017 },
	{ 0x2d78, 0x501c },
	{ 0x2d79, 0x5020 },
	{ 0x2d7a, 0x5027 },
	{ 0x2d7b, 0x5035 },
	{ 0x2d7c, 0x502f },
	{ 0x2d7d, 0x5031 },
	{ 0x2d7e, 0x500e },
	{ 0x2e21, 0x515a },
	{ 0x2e22, 0x5194 },
	{ 0x2e23, 0x5193 },
	{ 0x2e24, 0x51ca },
	{ 0x2e25, 0x51c4 },
	{ 0x2e26, 0x51c5 },
	{ 0x2e27, 0x51c8 },
	{ 0x2e28, 0x51ce },
	{ 0x2e29, 0x5261 },
	{ 0x2e2a, 0x525a },
	{ 0x2e2b, 0x5252 },
	{ 0x2e2c, 0x525e },
	{ 0x2e2d, 0x525f },
	{ 0x2e2e, 0x5255 },
	{ 0x2e2f, 0x5262 },
	{ 0x2e30, 0x52cd },
	{ 0x2e31, 0x530e },
	{ 0x2e32, 0x539e },
	{ 0x2e33, 0x5526 },
	{ 0x2e34, 0x54e2 },
	{ 0x2e35, 0x5517 },
	{ 0x2e36, 0x5512 },
	{ 0x2e37, 0x54e7 },
	{ 0x2e38, 0x54f3 },
	{ 0x2e39, 0x54e4 },
	{ 0x2e3a, 0x551a },
	{ 0x2e3b, 0x54ff },
	{ 0x2e3c, 0x5504 },
	{ 0x2e3d, 0x5508 },
	{ 0x2e3e, 0x54eb },
	{ 0x2e3f, 0x5511 },
	{ 0x2e40, 0x5505 },
	{ 0x2e41, 0x54f1 },
	{ 0x2e42, 0x550a },
	{ 0x2e43, 0x54fb },
	{ 0x2e44, 0x54f7 },
	{ 0x2e45, 0x54f8 },
	{ 0x2e46, 0x54e0 },
	{ 0x2e47, 0x550e },
	{ 0x2e48, 0x5503 },
	{ 0x2e49, 0x550b },
	{ 0x2e4a, 0x5701 },
	{ 0x2e4b, 0x5702 },
	{ 0x2e4c, 0x57cc },
	{ 0x2e4d, 0x5832 },
	{ 0x2e4e, 0x57d5 },
	{ 0x2e4f, 0x57d2 },
	{ 0x2e50, 0x57ba },
	{ 0x2e51, 0x57c6 },
	{ 0x2e52, 0x57bd },
	{ 0x2e53, 0x57bc },
	{ 0x2e54, 0x57b8 },
	{ 0x2e55, 0x57b6 },
	{ 0x2e56, 0x57bf },
	{ 0x2e57, 0x57c7 },
	{ 0x2e58, 0x57d0 },
	{ 0x2e59, 0x57b9 },
	{ 0x2e5a, 0x57c1 },
	{ 0x2e5b, 0x590e },
	{ 0x2e5c, 0x594a },
	{ 0x2e5d, 0x5a19 },
	{ 0x2e5e, 0x5a16 },
	{ 0x2e5f, 0x5a2d },
	{ 0x2e60, 0x5a2e },
	{ 0x2e61, 0x5a15 },
	{ 0x2e62, 0x5a0f },
	{ 0x2e63, 0x5a17 },
	{ 0x2e64, 0x5a0a },
	{ 0x2e65, 0x5a1e },
	{ 0x2e66, 0x5a33 },
	{ 0x2e67, 0x5b6c },
	{ 0x2e68, 0x5ba7 },
	{ 0x2e69, 0x5bad },
	{ 0x2e6a, 0x5bac },
	{ 0x2e6b, 0x5c03 },
	{ 0x2e6c, 0x5c56 },
	{ 0x2e6d, 0x5c54 },
	{ 0x2e6e, 0x5cec },
	{ 0x2e6f, 0x5cff },
	{ 0x2e70, 0x5cee },
	{ 0x2e71, 0x5cf1 },
	{ 0x2e72, 0x5cf7 },
	{ 0x2e73, 0x5d00 },
	{ 0x2e74, 0x5cf9 },
	{ 0x2e75, 0x5e29 },
	{ 0x2e76, 0x5e28 },
	{ 0x2e77, 0x5ea8 },
	{ 0x2e78, 0x5eae },
	{ 0x2e79, 0x5eaa },
	{ 0x2e7a, 0x5eac },
	{ 0x2e7b, 0x5f33 },
	{ 0x2e7c, 0x5f30 },
	{ 0x2e7d, 0x5f67 },
	{ 0x2e7e, 0x605d },
	{ 0x2f21, 0x605a },
	{ 0x2f22, 0x6067 },
	{ 0x2f23, 0x6041 },
	{ 0x2f24, 0x60a2 },
	{ 0x2f25, 0x6088 },
	{ 0x2f26, 0x6080 },
	{ 0x2f27, 0x6092 },
	{ 0x2f28, 0x6081 },
	{ 0x2f29, 0x609d },
	{ 0x2f2a, 0x6083 },
	{ 0x2f2b, 0x6095 },
	{ 0x2f2c, 0x609b },
	{ 0x2f2d, 0x6097 },
	{ 0x2f2e, 0x6087 },
	{ 0x2f2f, 0x609c },
	{ 0x2f30, 0x608e },
	{ 0x2f31, 0x6219 },
	{ 0x2f32, 0x6246 },
	{ 0x2f33, 0x62f2 },
	{ 0x2f34, 0x6310 },
	{ 0x2f35, 0x6356 },
	{ 0x2f36, 0x632c },
	{ 0x2f37, 0x6344 },
	{ 0x2f38, 0x6345 },
	{ 0x2f39, 0x6336 },
	{ 0x2f3a, 0x6343 },
	{ 0x2f3b, 0x63e4 },
	{ 0x2f3c, 0x6339 },
	{ 0x2f3d, 0x634b },
	{ 0x2f3e, 0x634a },
	{ 0x2f3f, 0x633c },
	{ 0x2f40, 0x6329 },
	{ 0x2f41, 0x6341 },
	{ 0x2f42, 0x6334 },
	{ 0x2f43, 0x6358 },
	{ 0x2f44, 0x6354 },
	{ 0x2f45, 0x6359 },
	{ 0x2f46, 0x632d },
	{ 0x2f47, 0x6347 },
	{ 0x2f48, 0x6333 },
	{ 0x2f49, 0x635a },
	{ 0x2f4a, 0x6351 },
	{ 0x2f4b, 0x6338 },
	{ 0x2f4c, 0x6357 },
	{ 0x2f4d, 0x6340 },
	{ 0x2f4e, 0x6348 },
	{ 0x2f4f, 0x654a },
	{ 0x2f50, 0x6546 },
	{ 0x2f51, 0x65c6 },
	{ 0x2f52, 0x65c3 },
	{ 0x2f53, 0x65c4 },
	{ 0x2f54, 0x65c2 },
	{ 0x2f55, 0x664a },
	{ 0x2f56, 0x665f },
	{ 0x2f57, 0x6647 },
	{ 0x2f58, 0x6651 },
	{ 0x2f59, 0x6712 },
	{ 0x2f5a, 0x6713 },
	{ 0x2f5b, 0x681f },
	{ 0x2f5c, 0x681a },
	{ 0x2f5d, 0x6849 },
	{ 0x2f5e, 0x6832 },
	{ 0x2f5f, 0x6833 },
	{ 0x2f60, 0x683b },
	{ 0x2f61, 0x684b },
	{ 0x2f62, 0x684f },
	{ 0x2f63, 0x6816 },
	{ 0x2f64, 0x6831 },
	{ 0x2f65, 0x681c },
	{ 0x2f66, 0x6835 },
	{ 0x2f67, 0x682b },
	{ 0x2f68, 0x682d },
	{ 0x2f69, 0x682f },
	{ 0x2f6a, 0x684e },
	{ 0x2f6b, 0x6844 },
	{ 0x2f6c, 0x6834 },
	{ 0x2f6d, 0x681d },
	{ 0x2f6e, 0x6812 },
	{ 0x2f6f, 0x6814 },
	{ 0x2f70, 0x6826 },
	{ 0x2f71, 0x6828 },
	{ 0x2f72, 0x682e },
	{ 0x2f73, 0x684d },
	{ 0x2f74, 0x683a },
	{ 0x2f75, 0x6825 },
	{ 0x2f76, 0x6820 },
	{ 0x2f77, 0x6b2c },
	{ 0x2f78, 0x6b2f },
	{ 0x2f79, 0x6b2d },
	{ 0x2f7a, 0x6b31 },
	{ 0x2f7b, 0x6b34 },
	{ 0x2f7c, 0x6b6d },
	{ 0x2f7d, 0x8082 },
	{ 0x2f7e, 0x6b88 },
	{ 0x3021, 0x6be6 },
	{ 0x3022, 0x6be4 },
	{ 0x3023, 0x6be8 },
	{ 0x3024, 0x6be3 },
	{ 0x3025, 0x6be2 },
	{ 0x3026, 0x6be7 },
	{ 0x3027, 0x6c25 },
	{ 0x3028, 0x6d7a },
	{ 0x3029, 0x6d63 },
	{ 0x302a, 0x6d64 },
	{ 0x302b, 0x6d76 },
	{ 0x302c, 0x6d0d },
	{ 0x302d, 0x6d61 },
	{ 0x302e, 0x6d92 },
	{ 0x302f, 0x6d58 },
	{ 0x3030, 0x6d62 },
	{ 0x3031, 0x6d6d },
	{ 0x3032, 0x6d6f },
	{ 0x3033, 0x6d91 },
	{ 0x3034, 0x6d8d },
	{ 0x3035, 0x6def },
	{ 0x3036, 0x6d7f },
	{ 0x3037, 0x6d86 },
	{ 0x3038, 0x6d5e },
	{ 0x3039, 0x6d67 },
	{ 0x303a, 0x6d60 },
	{ 0x303b, 0x6d97 },
	{ 0x303c, 0x6d70 },
	{ 0x303d, 0x6d7c },
	{ 0x303e, 0x6d5f },
	{ 0x303f, 0x6d82 },
	{ 0x3040, 0x6d98 },
	{ 0x3041, 0x6d2f },
	{ 0x3042, 0x6d68 },
	{ 0x3043, 0x6d8b },
	{ 0x3044, 0x6d7e },
	{ 0x3045, 0x6d80 },
	{ 0x3046, 0x6d84 },
	{ 0x3047, 0x6d16 },
	{ 0x3048, 0x6d83 },
	{ 0x3049, 0x6d7b },
	{ 0x304a, 0x6d7d },
	{ 0x304b, 0x6d75 },
	{ 0x304c, 0x6d90 },
	{ 0x304d, 0x70dc },
	{ 0x304e, 0x70d3 },
	{ 0x304f, 0x70d1 },
	{ 0x3050, 0x70dd },
	{ 0x3051, 0x70cb },
	{ 0x3052, 0x7f39 },
	{ 0x3053, 0x70e2 },
	{ 0x3054, 0x70d7 },
	{ 0x3055, 0x70d2 },
	{ 0x3056, 0x70de },
	{ 0x3057, 0x70e0 },
	{ 0x3058, 0x70d4 },
	{ 0x3059, 0x70cd },
	{ 0x305a, 0x70c5 },
	{ 0x305b, 0x70c6 },
	{ 0x305c, 0x70c7 },
	{ 0x305d, 0x70da },
	{ 0x305e, 0x70ce },
	{ 0x305f, 0x70e1 },
	{ 0x3060, 0x7242 },
	{ 0x3061, 0x7278 },
	{ 0x3062, 0x7277 },
	{ 0x3063, 0x7276 },
	{ 0x3064, 0x7300 },
	{ 0x3065, 0x72fa },
	{ 0x3066, 0x72f4 },
	{ 0x3067, 0x72fe },
	{ 0x3068, 0x72f6 },
	{ 0x3069, 0x72f3 },
	{ 0x306a, 0x72fb },
	{ 0x306b, 0x7301 },
	{ 0x306c, 0x73d3 },
	{ 0x306d, 0x73d9 },
	{ 0x306e, 0x73e5 },
	{ 0x306f, 0x73d6 },
	{ 0x3070, 0x73bc },
	{ 0x3071, 0x73e7 },
	{ 0x3072, 0x73e3 },
	{ 0x3073, 0x73e9 },
	{ 0x3074, 0x73dc },
	{ 0x3075, 0x73d2 },
	{ 0x3076, 0x73db },
	{ 0x3077, 0x73d4 },
	{ 0x3078, 0x73dd },
	{ 0x3079, 0x73da },
	{ 0x307a, 0x73d7 },
	{ 0x307b, 0x73d8 },
	{ 0x307c, 0x73e8 },
	{ 0x307d, 0x74de },
	{ 0x307e, 0x74df },
	{ 0x3121, 0x74f4 },
	{ 0x3122, 0x74f5 },
	{ 0x3123, 0x7521 },
	{ 0x3124, 0x755b },
	{ 0x3125, 0x755f },
	{ 0x3126, 0x75b0 },
	{ 0x3127, 0x75c1 },
	{ 0x3128, 0x75bb },
	{ 0x3129, 0x75c4 },
	{ 0x312a, 0x75c0 },
	{ 0x312b, 0x75bf },
	{ 0x312c, 0x75b6 },
	{ 0x312d, 0x75ba },
	{ 0x312e, 0x768a },
	{ 0x312f, 0x76c9 },
	{ 0x3130, 0x771d },
	{ 0x3131, 0x771b },
	{ 0x3132, 0x7710 },
	{ 0x3133, 0x7713 },
	{ 0x3134, 0x7712 },
	{ 0x3135, 0x7723 },
	{ 0x3136, 0x7711 },
	{ 0x3137, 0x7715 },
	{ 0x3138, 0x7719 },
	{ 0x3139, 0x771a },
	{ 0x313a, 0x7722 },
	{ 0x313b, 0x7727 },
	{ 0x313c, 0x7823 },
	{ 0x313d, 0x782c },
	{ 0x313e, 0x7822 },
	{ 0x313f, 0x7835 },
	{ 0x3140, 0x782f },
	{ 0x3141, 0x7828 },
	{ 0x3142, 0x782e },
	{ 0x3143, 0x782b },
	{ 0x3144, 0x7821 },
	{ 0x3145, 0x7829 },
	{ 0x3146, 0x7833 },
	{ 0x3147, 0x782a },
	{ 0x3148, 0x7831 },
	{ 0x3149, 0x7954 },
	{ 0x314a, 0x795b },
	{ 0x314b, 0x794f },
	{ 0x314c, 0x795c },
	{ 0x314d, 0x7953 },
	{ 0x314e, 0x7952 },
	{ 0x314f, 0x7951 },
	{ 0x3150, 0x79eb },
	{ 0x3151, 0x79ec },
	{ 0x3152, 0x79e0 },
	{ 0x3153, 0x79ee },
	{ 0x3154, 0x79ed },
	{ 0x3155, 0x79ea },
	{ 0x3156, 0x79dc },
	{ 0x3157, 0x79de },
	{ 0x3158, 0x79dd },
	{ 0x3159, 0x7a86 },
	{ 0x315a, 0x7a89 },
	{ 0x315b, 0x7a85 },
	{ 0x315c, 0x7a8b },
	{ 0x315d, 0x7a8c },
	{ 0x315e, 0x7a8a },
	{ 0x315f, 0x7a87 },
	{ 0x3160, 0x7ad8 },
	{ 0x3161, 0x7b10 },
	{ 0x3162, 0x7b04 },
	{ 0x3163, 0x7b13 },
	{ 0x3164, 0x7b05 },
	{ 0x3165, 0x7b0f },
	{ 0x3166, 0x7b08 },
	{ 0x3167, 0x7b0a },
	{ 0x3168, 0x7b0e },
	{ 0x3169, 0x7b09 },
	{ 0x316a, 0x7b12 },
	{ 0x316b, 0x7c84 },
	{ 0x316c, 0x7c91 },
	{ 0x316d, 0x7c8a },
	{ 0x316e, 0x7c8c },
	{ 0x316f, 0x7c88 },
	{ 0x3170, 0x7c8d },
	{ 0x3171, 0x7c85 },
	{ 0x3172, 0x7d1e },
	{ 0x3173, 0x7d1d },
	{ 0x3174, 0x7d11 },
	{ 0x3175, 0x7d0e },
	{ 0x3176, 0x7d18 },
	{ 0x3177, 0x7d16 },
	{ 0x3178, 0x7d13 },
	{ 0x3179, 0x7d1f },
	{ 0x317a, 0x7d12 },
	{ 0x317b, 0x7d0f },
	{ 0x317c, 0x7d0c },
	{ 0x317d, 0x7f5c },
	{ 0x317e, 0x7f61 },
	{ 0x3221, 0x7f5e },
	{ 0x3222, 0x7f60 },
	{ 0x3223, 0x7f5d },
	{ 0x3224, 0x7f5b },
	{ 0x3225, 0x7f96 },
	{ 0x3226, 0x7f92 },
	{ 0x3227, 0x7fc3 },
	{ 0x3228, 0x7fc2 },
	{ 0x3229, 0x7fc0 },
	{ 0x322a, 0x8016 },
	{ 0x322b, 0x803e },
	{ 0x322c, 0x8039 },
	{ 0x322d, 0x80fa },
	{ 0x322e, 0x80f2 },
	{ 0x322f, 0x80f9 },
	{ 0x3230, 0x80f5 },
	{ 0x3231, 0x8101 },
	{ 0x3232, 0x80fb },
	{ 0x3233, 0x8100 },
	{ 0x3234, 0x8201 },
	{ 0x3235, 0x822f },
	{ 0x3236, 0x8225 },
	{ 0x3237, 0x8333 },
	{ 0x3238, 0x832d },
	{ 0x3239, 0x8344 },
	{ 0x323a, 0x8319 },
	{ 0x323b, 0x8351 },
	{ 0x323c, 0x8325 },
	{ 0x323d, 0x8356 },
	{ 0x323e, 0x833f },
	{ 0x323f, 0x8341 },
	{ 0x3240, 0x8326 },
	{ 0x3241, 0x831c },
	{ 0x3242, 0x8322 },
	{ 0x3243, 0x8342 },
	{ 0x3244, 0x834e },
	{ 0x3245, 0x831b },
	{ 0x3246, 0x832a },
	{ 0x3247, 0x8308 },
	{ 0x3248, 0x833c },
	{ 0x3249, 0x834d },
	{ 0x324a, 0x8316 },
	{ 0x324b, 0x8324 },
	{ 0x324c, 0x8320 },
	{ 0x324d, 0x8337 },
	{ 0x324e, 0x832f },
	{ 0x324f, 0x8329 },
	{ 0x3250, 0x8347 },
	{ 0x3251, 0x8345 },
	{ 0x3252, 0x834c },
	{ 0x3253, 0x8353 },
	{ 0x3254, 0x831e },
	{ 0x3255, 0x832c },
	{ 0x3256, 0x834b },
	{ 0x3257, 0x8327 },
	{ 0x3258, 0x8348 },
	{ 0x3259, 0x8653 },
	{ 0x325a, 0x8652 },
	{ 0x325b, 0x86a2 },
	{ 0x325c, 0x86a8 },
	{ 0x325d, 0x8696 },
	{ 0x325e, 0x868d },
	{ 0x325f, 0x8691 },
	{ 0x3260, 0x869e },
	{ 0x3261, 0x8687 },
	{ 0x3262, 0x8697 },
	{ 0x3263, 0x8686 },
	{ 0x3264, 0x868b },
	{ 0x3265, 0x869a },
	{ 0x3266, 0x8685 },
	{ 0x3267, 0x86a5 },
	{ 0x3268, 0x8699 },
	{ 0x3269, 0x86a1 },
	{ 0x326a, 0x86a7 },
	{ 0x326b, 0x8695 },
	{ 0x326c, 0x8698 },
	{ 0x326d, 0x868e },
	{ 0x326e, 0x869d },
	{ 0x326f, 0x8690 },
	{ 0x3270, 0x8694 },
	{ 0x3271, 0x8843 },
	{ 0x3272, 0x8844 },
	{ 0x3273, 0x886d },
	{ 0x3274, 0x8875 },
	{ 0x3275, 0x8876 },
	{ 0x3276, 0x8872 },
	{ 0x3277, 0x8880 },
	{ 0x3278, 0x8871 },
	{ 0x3279, 0x887f },
	{ 0x327a, 0x886f },
	{ 0x327b, 0x8883 },
	{ 0x327c, 0x887e },
	{ 0x327d, 0x8874 },
	{ 0x327e, 0x887c },
	{ 0x3321, 0x8a12 },
	{ 0x3322, 0x8c47 },
	{ 0x3323, 0x8c57 },
	{ 0x3324, 0x8c7b },
	{ 0x3325, 0x8ca4 },
	{ 0x3326, 0x8ca3 },
	{ 0x3327, 0x8d76 },
	{ 0x3328, 0x8d78 },
	{ 0x3329, 0x8db5 },
	{ 0x332a, 0x8db7 },
	{ 0x332b, 0x8db6 },
	{ 0x332c, 0x8ed1 },
	{ 0x332d, 0x8ed3 },
	{ 0x332e, 0x8ffe },
	{ 0x332f, 0x8ff5 },
	{ 0x3330, 0x9002 },
	{ 0x3331, 0x8fff },
	{ 0x3332, 0x8ffb },
	{ 0x3333, 0x9004 },
	{ 0x3334, 0x8ffc },
	{ 0x3335, 0x8ff6 },
	{ 0x3336, 0x90d6 },
	{ 0x3337, 0x90e0 },
	{ 0x3338, 0x90d9 },
	{ 0x3339, 0x90da },
	{ 0x333a, 0x90e3 },
	{ 0x333b, 0x90df },
	{ 0x333c, 0x90e5 },
	{ 0x333d, 0x90d8 },
	{ 0x333e, 0x90db },
	{ 0x333f, 0x90d7 },
	{ 0x3340, 0x90dc },
	{ 0x3341, 0x90e4 },
	{ 0x3342, 0x9150 },
	{ 0x3343, 0x914e },
	{ 0x3344, 0x914f },
	{ 0x3345, 0x91d5 },
	{ 0x3346, 0x91e2 },
	{ 0x3347, 0x91da },
	{ 0x3348, 0x965c },
	{ 0x3349, 0x965f },
	{ 0x334a, 0x96bc },
	{ 0x334b, 0x98e3 },
	{ 0x334c, 0x9adf },
	{ 0x334d, 0x9b2f },
	{ 0x334e, 0x4e7f },
	{ 0x334f, 0x5070 },
	{ 0x3350, 0x506a },
	{ 0x3351, 0x5061 },
	{ 0x3352, 0x505e },
	{ 0x3353, 0x5060 },
	{ 0x3354, 0x5053 },
	{ 0x3355, 0x504b },
	{ 0x3356, 0x505d },
	{ 0x3357, 0x5072 },
	{ 0x3358, 0x5048 },
	{ 0x3359, 0x504d },
	{ 0x335a, 0x5041 },
	{ 0x335b, 0x505b },
	{ 0x335c, 0x504a },
	{ 0x335d, 0x5062 },
	{ 0x335e, 0x5015 },
	{ 0x335f, 0x5045 },
	{ 0x3360, 0x505f },
	{ 0x3361, 0x5069 },
	{ 0x3362, 0x506b },
	{ 0x3363, 0x5063 },
	{ 0x3364, 0x5064 },
	{ 0x3365, 0x5046 },
	{ 0x3366, 0x5040 },
	{ 0x3367, 0x506e },
	{ 0x3368, 0x5073 },
	{ 0x3369, 0x5057 },
	{ 0x336a, 0x5051 },
	{ 0x336b, 0x51d0 },
	{ 0x336c, 0x526b },
	{ 0x336d, 0x526d },
	{ 0x336e, 0x526c },
	{ 0x336f, 0x526e },
	{ 0x3370, 0x52d6 },
	{ 0x3371, 0x52d3 },
	{ 0x3372, 0x532d },
	{ 0x3373, 0x539c },
	{ 0x3374, 0x5575 },
	{ 0x3375, 0x5576 },
	{ 0x3376, 0x553c },
	{ 0x3377, 0x554d },
	{ 0x3378, 0x5550 },
	{ 0x3379, 0x5534 },
	{ 0x337a, 0x552a },
	{ 0x337b, 0x5551 },
	{ 0x337c, 0x5562 },
	{ 0x337d, 0x5536 },
	{ 0x337e, 0x5535 },
	{ 0x3421, 0x5530 },
	{ 0x3422, 0x5552 },
	{ 0x3423, 0x5545 },
	{ 0x3424, 0x550c },
	{ 0x3425, 0x5532 },
	{ 0x3426, 0x5565 },
	{ 0x3427, 0x554e },
	{ 0x3428, 0x5539 },
	{ 0x3429, 0x5548 },
	{ 0x342a, 0x552d },
	{ 0x342b, 0x553b },
	{ 0x342c, 0x5540 },
	{ 0x342d, 0x554b },
	{ 0x342e, 0x570a },
	{ 0x342f, 0x5707 },
	{ 0x3430, 0x57fb },
	{ 0x3431, 0x5814 },
	{ 0x3432, 0x57e2 },
	{ 0x3433, 0x57f6 },
	{ 0x3434, 0x57dc },
	{ 0x3435, 0x57f4 },
	{ 0x3436, 0x5800 },
	{ 0x3437, 0x57ed },
	{ 0x3438, 0x57fd },
	{ 0x3439, 0x5808 },
	{ 0x343a, 0x57f8 },
	{ 0x343b, 0x580b },
	{ 0x343c, 0x57f3 },
	{ 0x343d, 0x57cf },
	{ 0x343e, 0x5807 },
	{ 0x343f, 0x57ee },
	{ 0x3440, 0x57e3 },
	{ 0x3441, 0x57f2 },
	{ 0x3442, 0x57e5 },
	{ 0x3443, 0x57ec },
	{ 0x3444, 0x57e1 },
	{ 0x3445, 0x580e },
	{ 0x3446, 0x57fc },
	{ 0x3447, 0x5810 },
	{ 0x3448, 0x57e7 },
	{ 0x3449, 0x5801 },
	{ 0x344a, 0x580c },
	{ 0x344b, 0x57f1 },
	{ 0x344c, 0x57e9 },
	{ 0x344d, 0x57f0 },
	{ 0x344e, 0x580d },
	{ 0x344f, 0x5804 },
	{ 0x3450, 0x595c },
	{ 0x3451, 0x5a60 },
	{ 0x3452, 0x5a58 },
	{ 0x3453, 0x5a55 },
	{ 0x3454, 0x5a67 },
	{ 0x3455, 0x5a5e },
	{ 0x3456, 0x5a38 },
	{ 0x3457, 0x5a35 },
	{ 0x3458, 0x5a6d },
	{ 0x3459, 0x5a50 },
	{ 0x345a, 0x5a5f },
	{ 0x345b, 0x5a65 },
	{ 0x345c, 0x5a6c },
	{ 0x345d, 0x5a53 },
	{ 0x345e, 0x5a64 },
	{ 0x345f, 0x5a57 },
	{ 0x3460, 0x5a43 },
	{ 0x3461, 0x5a5d },
	{ 0x3462, 0x5a52 },
	{ 0x3463, 0x5a44 },
	{ 0x3464, 0x5a5b },
	{ 0x3465, 0x5a48 },
	{ 0x3466, 0x5a8e },
	{ 0x3467, 0x5a3e },
	{ 0x3468, 0x5a4d },
	{ 0x3469, 0x5a39 },
	{ 0x346a, 0x5a4c },
	{ 0x346b, 0x5a70 },
	{ 0x346c, 0x5a69 },
	{ 0x346d, 0x5a47 },
	{ 0x346e, 0x5a51 },
	{ 0x346f, 0x5a56 },
	{ 0x3470, 0x5a42 },
	{ 0x3471, 0x5a5c },
	{ 0x3472, 0x5b72 },
	{ 0x3473, 0x5b6e },
	{ 0x3474, 0x5bc1 },
	{ 0x3475, 0x5bc0 },
	{ 0x3476, 0x5c59 },
	{ 0x3477, 0x5d1e },
	{ 0x3478, 0x5d0b },
	{ 0x3479, 0x5d1d },
	{ 0x347a, 0x5d1a },
	{ 0x347b, 0x5d20 },
	{ 0x347c, 0x5d0c },
	{ 0x347d, 0x5d28 },
	{ 0x347e, 0x5d0d },
	{ 0x3521, 0x5d26 },
	{ 0x3522, 0x5d25 },
	{ 0x3523, 0x5d0f },
	{ 0x3524, 0x5d30 },
	{ 0x3525, 0x5d12 },
	{ 0x3526, 0x5d23 },
	{ 0x3527, 0x5d1f },
	{ 0x3528, 0x5d2e },
	{ 0x3529, 0x5e3e },
	{ 0x352a, 0x5e34 },
	{ 0x352b, 0x5eb1 },
	{ 0x352c, 0x5eb4 },
	{ 0x352d, 0x5eb9 },
	{ 0x352e, 0x5eb2 },
	{ 0x352f, 0x5eb3 },
	{ 0x3530, 0x5f36 },
	{ 0x3531, 0x5f38 },
	{ 0x3532, 0x5f9b },
	{ 0x3533, 0x5f96 },
	{ 0x3534, 0x5f9f },
	{ 0x3535, 0x608a },
	{ 0x3536, 0x6090 },
	{ 0x3537, 0x6086 },
	{ 0x3538, 0x60be },
	{ 0x3539, 0x60b0 },
	{ 0x353a, 0x60ba },
	{ 0x353b, 0x60d3 },
	{ 0x353c, 0x60d4 },
	{ 0x353d, 0x60cf },
	{ 0x353e, 0x60e4 },
	{ 0x353f, 0x60d9 },
	{ 0x3540, 0x60dd },
	{ 0x3541, 0x60c8 },
	{ 0x3542, 0x60b1 },
	{ 0x3543, 0x60db },
	{ 0x3544, 0x60b7 },
	{ 0x3545, 0x60ca },
	{ 0x3546, 0x60bf },
	{ 0x3547, 0x60c3 },
	{ 0x3548, 0x60cd },
	{ 0x3549, 0x60c0 },
	{ 0x354a, 0x6332 },
	{ 0x354b, 0x6365 },
	{ 0x354c, 0x638a },
	{ 0x354d, 0x6382 },
	{ 0x354e, 0x637d },
	{ 0x354f, 0x63bd },
	{ 0x3550, 0x639e },
	{ 0x3551, 0x63ad },
	{ 0x3552, 0x639d },
	{ 0x3553, 0x6397 },
	{ 0x3554, 0x63ab },
	{ 0x3555, 0x638e },
	{ 0x3556, 0x636f },
	{ 0x3557, 0x6387 },
	{ 0x3558, 0x6390 },
	{ 0x3559, 0x636e },
	{ 0x355a, 0x63af },
	{ 0x355b, 0x6375 },
	{ 0x355c, 0x639c },
	{ 0x355d, 0x636d },
	{ 0x355e, 0x63ae },
	{ 0x355f, 0x637c },
	{ 0x3560, 0x63a4 },
	{ 0x3561, 0x633b },
	{ 0x3562, 0x639f },
	{ 0x3563, 0x6378 },
	{ 0x3564, 0x6385 },
	{ 0x3565, 0x6381 },
	{ 0x3566, 0x6391 },
	{ 0x3567, 0x638d },
	{ 0x3568, 0x6370 },
	{ 0x3569, 0x6553 },
	{ 0x356a, 0x65cd },
	{ 0x356b, 0x6665 },
	{ 0x356c, 0x6661 },
	{ 0x356d, 0x665b },
	{ 0x356e, 0x6659 },
	{ 0x356f, 0x665c },
	{ 0x3570, 0x6662 },
	{ 0x3571, 0x6718 },
	{ 0x3572, 0x6879 },
	{ 0x3573, 0x6887 },
	{ 0x3574, 0x6890 },
	{ 0x3575, 0x689c },
	{ 0x3576, 0x686d },
	{ 0x3577, 0x686e },
	{ 0x3578, 0x68ae },
	{ 0x3579, 0x68ab },
	{ 0x357a, 0x6956 },
	{ 0x357b, 0x686f },
	{ 0x357c, 0x68a3 },
	{ 0x357d, 0x68ac },
	{ 0x357e, 0x68a9 },
	{ 0x3621, 0x6875 },
	{ 0x3622, 0x6874 },
	{ 0x3623, 0x68b2 },
	{ 0x3624, 0x688f },
	{ 0x3625, 0x6877 },
	{ 0x3626, 0x6892 },
	{ 0x3627, 0x687c },
	{ 0x3628, 0x686b },
	{ 0x3629, 0x6872 },
	{ 0x362a, 0x68aa },
	{ 0x362b, 0x6880 },
	{ 0x362c, 0x6871 },
	{ 0x362d, 0x687e },
	{ 0x362e, 0x689b },
	{ 0x362f, 0x6896 },
	{ 0x3630, 0x688b },
	{ 0x3631, 0x68a0 },
	{ 0x3632, 0x6889 },
	{ 0x3633, 0x68a4 },
	{ 0x3634, 0x6878 },
	{ 0x3635, 0x687b },
	{ 0x3636, 0x6891 },
	{ 0x3637, 0x688c },
	{ 0x3638, 0x688a },
	{ 0x3639, 0x687d },
	{ 0x363a, 0x6b36 },
	{ 0x363b, 0x6b33 },
	{ 0x363c, 0x6b37 },
	{ 0x363d, 0x6b38 },
	{ 0x363e, 0x6b91 },
	{ 0x363f, 0x6b8f },
	{ 0x3640, 0x6b8d },
	{ 0x3641, 0x6b8e },
	{ 0x3642, 0x6b8c },
	{ 0x3643, 0x6c2a },
	{ 0x3644, 0x6dc0 },
	{ 0x3645, 0x6dab },
	{ 0x3646, 0x6db4 },
	{ 0x3647, 0x6db3 },
	{ 0x3648, 0x6e74 },
	{ 0x3649, 0x6dac },
	{ 0x364a, 0x6de9 },
	{ 0x364b, 0x6de2 },
	{ 0x364c, 0x6db7 },
	{ 0x364d, 0x6df6 },
	{ 0x364e, 0x6dd4 },
	{ 0x364f, 0x6e00 },
	{ 0x3650, 0x6dc8 },
	{ 0x3651, 0x6de0 },
	{ 0x3652, 0x6ddf },
	{ 0x3653, 0x6dd6 },
	{ 0x3654, 0x6dbe },
	{ 0x3655, 0x6de5 },
	{ 0x3656, 0x6ddc },
	{ 0x3657, 0x6ddd },
	{ 0x3658, 0x6ddb },
	{ 0x3659, 0x6df4 },
	{ 0x365a, 0x6dca },
	{ 0x365b, 0x6dbd },
	{ 0x365c, 0x6ded },
	{ 0x365d, 0x6df0 },
	{ 0x365e, 0x6dba },
	{ 0x365f, 0x6dd5 },
	{ 0x3660, 0x6dc2 },
	{ 0x3661, 0x6dcf },
	{ 0x3662, 0x6dc9 },
	{ 0x3663, 0x6dd0 },
	{ 0x3664, 0x6df2 },
	{ 0x3665, 0x6dd3 },
	{ 0x3666, 0x6dfd },
	{ 0x3667, 0x6dd7 },
	{ 0x3668, 0x6dcd },
	{ 0x3669, 0x6de3 },
	{ 0x366a, 0x6dbb },
	{ 0x366b, 0x70fa },
	{ 0x366c, 0x710d },
	{ 0x366d, 0x70f7 },
	{ 0x366e, 0x7117 },
	{ 0x366f, 0x70f4 },
	{ 0x3670, 0x710c },
	{ 0x3671, 0x70f0 },
	{ 0x3672, 0x7104 },
	{ 0x3673, 0x70f3 },
	{ 0x3674, 0x7110 },
	{ 0x3675, 0x70fc },
	{ 0x3676, 0x70ff },
	{ 0x3677, 0x7106 },
	{ 0x3678, 0x7113 },
	{ 0x3679, 0x7100 },
	{ 0x367a, 0x70f8 },
	{ 0x367b, 0x70f6 },
	{ 0x367c, 0x710b },
	{ 0x367d, 0x7102 },
	{ 0x367e, 0x710e },
	{ 0x3721, 0x727e },
	{ 0x3722, 0x727b },
	{ 0x3723, 0x727c },
	{ 0x3724, 0x727f },
	{ 0x3725, 0x731d },
	{ 0x3726, 0x7317 },
	{ 0x3727, 0x7307 },
	{ 0x3728, 0x7311 },
	{ 0x3729, 0x7318 },
	{ 0x372a, 0x730a },
	{ 0x372b, 0x7308 },
	{ 0x372c, 0x72ff },
	{ 0x372d, 0x730f },
	{ 0x372e, 0x731e },
	{ 0x372f, 0x7388 },
	{ 0x3730, 0x73f6 },
	{ 0x3731, 0x73f8 },
	{ 0x3732, 0x73f5 },
	{ 0x3733, 0x7404 },
	{ 0x3734, 0x7401 },
	{ 0x3735, 0x73fd },
	{ 0x3736, 0x7407 },
	{ 0x3737, 0x7400 },
	{ 0x3738, 0x73fa },
	{ 0x3739, 0x73fc },
	{ 0x373a, 0x73ff },
	{ 0x373b, 0x740c },
	{ 0x373c, 0x740b },
	{ 0x373d, 0x73f4 },
	{ 0x373e, 0x7408 },
	{ 0x373f, 0x7564 },
	{ 0x3740, 0x7563 },
	{ 0x3741, 0x75ce },
	{ 0x3742, 0x75d2 },
	{ 0x3743, 0x75cf },
	{ 0x3744, 0x75cb },
	{ 0x3745, 0x75cc },
	{ 0x3746, 0x75d1 },
	{ 0x3747, 0x75d0 },
	{ 0x3748, 0x768f },
	{ 0x3749, 0x7689 },
	{ 0x374a, 0x76d3 },
	{ 0x374b, 0x7739 },
	{ 0x374c, 0x772f },
	{ 0x374d, 0x772d },
	{ 0x374e, 0x7731 },
	{ 0x374f, 0x7732 },
	{ 0x3750, 0x7734 },
	{ 0x3751, 0x7733 },
	{ 0x3752, 0x773d },
	{ 0x3753, 0x7725 },
	{ 0x3754, 0x773b },
	{ 0x3755, 0x7735 },
	{ 0x3756, 0x7848 },
	{ 0x3757, 0x7852 },
	{ 0x3758, 0x7849 },
	{ 0x3759, 0x784d },
	{ 0x375a, 0x784a },
	{ 0x375b, 0x784c },
	{ 0x375c, 0x7826 },
	{ 0x375d, 0x7845 },
	{ 0x375e, 0x7850 },
	{ 0x375f, 0x7964 },
	{ 0x3760, 0x7967 },
	{ 0x3761, 0x7969 },
	{ 0x3762, 0x796a },
	{ 0x3763, 0x7963 },
	{ 0x3764, 0x796b },
	{ 0x3765, 0x7961 },
	{ 0x3766, 0x79bb },
	{ 0x3767, 0x79fa },
	{ 0x3768, 0x79f8 },
	{ 0x3769, 0x79f6 },
	{ 0x376a, 0x79f7 },
	{ 0x376b, 0x7a8f },
	{ 0x376c, 0x7a94 },
	{ 0x376d, 0x7a90 },
	{ 0x376e, 0x7b35 },
	{ 0x376f, 0x7b3b },
	{ 0x3770, 0x7b34 },
	{ 0x3771, 0x7b25 },
	{ 0x3772, 0x7b30 },
	{ 0x3773, 0x7b22 },
	{ 0x3774, 0x7b24 },
	{ 0x3775, 0x7b33 },
	{ 0x3776, 0x7b18 },
	{ 0x3777, 0x7b2a },
	{ 0x3778, 0x7b1d },
	{ 0x3779, 0x7b31 },
	{ 0x377a, 0x7b2b },
	{ 0x377b, 0x7b2d },
	{ 0x377c, 0x7b2f },
	{ 0x377d, 0x7b32 },
	{ 0x377e, 0x7b38 },
	{ 0x3821, 0x7b1a },
	{ 0x3822, 0x7b23 },
	{ 0x3823, 0x7c94 },
	{ 0x3824, 0x7c98 },
	{ 0x3825, 0x7c96 },
	{ 0x3826, 0x7ca3 },
	{ 0x3827, 0x7d35 },
	{ 0x3828, 0x7d3d },
	{ 0x3829, 0x7d38 },
	{ 0x382a, 0x7d36 },
	{ 0x382b, 0x7d3a },
	{ 0x382c, 0x7d45 },
	{ 0x382d, 0x7d2c },
	{ 0x382e, 0x7d29 },
	{ 0x382f, 0x7d41 },
	{ 0x3830, 0x7d47 },
	{ 0x3831, 0x7d3e },
	{ 0x3832, 0x7d3f },
	{ 0x3833, 0x7d4a },
	{ 0x3834, 0x7d3b },
	{ 0x3835, 0x7d28 },
	{ 0x3836, 0x7f63 },
	{ 0x3837, 0x7f95 },
	{ 0x3838, 0x7f9c },
	{ 0x3839, 0x7f9d },
	{ 0x383a, 0x7f9b },
	{ 0x383b, 0x7fca },
	{ 0x383c, 0x7fcb },
	{ 0x383d, 0x7fcd },
	{ 0x383e, 0x7fd0 },
	{ 0x383f, 0x7fd1 },
	{ 0x3840, 0x7fc7 },
	{ 0x3841, 0x7fcf },
	{ 0x3842, 0x7fc9 },
	{ 0x3843, 0x801f },
	{ 0x3844, 0x801e },
	{ 0x3845, 0x801b },
	{ 0x3846, 0x8047 },
	{ 0x3847, 0x8043 },
	{ 0x3848, 0x8048 },
	{ 0x3849, 0x8118 },
	{ 0x384a, 0x8125 },
	{ 0x384b, 0x8119 },
	{ 0x384c, 0x811b },
	{ 0x384d, 0x812d },
	{ 0x384e, 0x811f },
	{ 0x384f, 0x812c },
	{ 0x3850, 0x811e },
	{ 0x3851, 0x8121 },
	{ 0x3852, 0x8115 },
	{ 0x3853, 0x8127 },
	{ 0x3854, 0x811d },
	{ 0x3855, 0x8122 },
	{ 0x3856, 0x8211 },
	{ 0x3857, 0x8238 },
	{ 0x3858, 0x8233 },
	{ 0x3859, 0x823a },
	{ 0x385a, 0x8234 },
	{ 0x385b, 0x8232 },
	{ 0x385c, 0x8274 },
	{ 0x385d, 0x8390 },
	{ 0x385e, 0x83a3 },
	{ 0x385f, 0x83a8 },
	{ 0x3860, 0x838d },
	{ 0x3861, 0x837a },
	{ 0x3862, 0x8373 },
	{ 0x3863, 0x83a4 },
	{ 0x3864, 0x8374 },
	{ 0x3865, 0x838f },
	{ 0x3866, 0x8381 },
	{ 0x3867, 0x8395 },
	{ 0x3868, 0x8399 },
	{ 0x3869, 0x8375 },
	{ 0x386a, 0x8394 },
	{ 0x386b, 0x83a9 },
	{ 0x386c, 0x837d },
	{ 0x386d, 0x8383 },
	{ 0x386e, 0x838c },
	{ 0x386f, 0x839d },
	{ 0x3870, 0x839b },
	{ 0x3871, 0x83aa },
	{ 0x3872, 0x838b },
	{ 0x3873, 0x837e },
	{ 0x3874, 0x83a5 },
	{ 0x3875, 0x83af },
	{ 0x3876, 0x8388 },
	{ 0x3877, 0x8397 },
	{ 0x3878, 0x83b0 },
	{ 0x3879, 0x837f },
	{ 0x387a, 0x83a6 },
	{ 0x387b, 0x8387 },
	{ 0x387c, 0x83ae },
	{ 0x387d, 0x8376 },
	{ 0x387e, 0x8659 },
	{ 0x3921, 0x8656 },
	{ 0x3922, 0x86bf },
	{ 0x3923, 0x86b7 },
	{ 0x3924, 0x86c2 },
	{ 0x3925, 0x86c1 },
	{ 0x3926, 0x86c5 },
	{ 0x3927, 0x86ba },
	{ 0x3928, 0x86b0 },
	{ 0x3929, 0x86c8 },
	{ 0x392a, 0x86b9 },
	{ 0x392b, 0x86b3 },
	{ 0x392c, 0x86b8 },
	{ 0x392d, 0x86cc },
	{ 0x392e, 0x86b4 },
	{ 0x392f, 0x86bb },
	{ 0x3930, 0x86bc },
	{ 0x3931, 0x86c3 },
	{ 0x3932, 0x86bd },
	{ 0x3933, 0x86be },
	{ 0x3934, 0x8852 },
	{ 0x3935, 0x8889 },
	{ 0x3936, 0x8895 },
	{ 0x3937, 0x88a8 },
	{ 0x3938, 0x88a2 },
	{ 0x3939, 0x88aa },
	{ 0x393a, 0x889a },
	{ 0x393b, 0x8891 },
	{ 0x393c, 0x88a1 },
	{ 0x393d, 0x889f },
	{ 0x393e, 0x8898 },
	{ 0x393f, 0x88a7 },
	{ 0x3940, 0x8899 },
	{ 0x3941, 0x889b },
	{ 0x3942, 0x8897 },
	{ 0x3943, 0x88a4 },
	{ 0x3944, 0x88ac },
	{ 0x3945, 0x888c },
	{ 0x3946, 0x8893 },
	{ 0x3947, 0x888e },
	{ 0x3948, 0x8982 },
	{ 0x3949, 0x89d6 },
	{ 0x394a, 0x89d9 },
	{ 0x394b, 0x89d5 },
	{ 0x394c, 0x8a30 },
	{ 0x394d, 0x8a27 },
	{ 0x394e, 0x8a2c },
	{ 0x394f, 0x8a1e },
	{ 0x3950, 0x8c39 },
	{ 0x3951, 0x8c3b },
	{ 0x3952, 0x8c5c },
	{ 0x3953, 0x8c5d },
	{ 0x3954, 0x8c7d },
	{ 0x3955, 0x8ca5 },
	{ 0x3956, 0x8d7d },
	{ 0x3957, 0x8d7b },
	{ 0x3958, 0x8d79 },
	{ 0x3959, 0x8dbc },
	{ 0x395a, 0x8dc2 },
	{ 0x395b, 0x8db9 },
	{ 0x395c, 0x8dbf },
	{ 0x395d, 0x8dc1 },
	{ 0x395e, 0x8ed8 },
	{ 0x395f, 0x8ede },
	{ 0x3960, 0x8edd },
	{ 0x3961, 0x8edc },
	{ 0x3962, 0x8ed7 },
	{ 0x3963, 0x8ee0 },
	{ 0x3964, 0x8ee1 },
	{ 0x3965, 0x9024 },
	{ 0x3966, 0x900b },
	{ 0x3967, 0x9011 },
	{ 0x3968, 0x901c },
	{ 0x3969, 0x900c },
	{ 0x396a, 0x9021 },
	{ 0x396b, 0x90ef },
	{ 0x396c, 0x90ea },
	{ 0x396d, 0x90f0 },
	{ 0x396e, 0x90f4 },
	{ 0x396f, 0x90f2 },
	{ 0x3970, 0x90f3 },
	{ 0x3971, 0x90d4 },
	{ 0x3972, 0x90eb },
	{ 0x3973, 0x90ec },
	{ 0x3974, 0x90e9 },
	{ 0x3975, 0x9156 },
	{ 0x3976, 0x9158 },
	{ 0x3977, 0x915a },
	{ 0x3978, 0x9153 },
	{ 0x3979, 0x9155 },
	{ 0x397a, 0x91ec },
	{ 0x397b, 0x91f4 },
	{ 0x397c, 0x91f1 },
	{ 0x397d, 0x91f3 },
	{ 0x397e, 0x91f8 },
	{ 0x3a21, 0x91e4 },
	{ 0x3a22, 0x91f9 },
	{ 0x3a23, 0x91ea },
	{ 0x3a24, 0x91eb },
	{ 0x3a25, 0x91f7 },
	{ 0x3a26, 0x91e8 },
	{ 0x3a27, 0x91ee },
	{ 0x3a28, 0x957a },
	{ 0x3a29, 0x9586 },
	{ 0x3a2a, 0x9588 },
	{ 0x3a2b, 0x967c },
	{ 0x3a2c, 0x966d },
	{ 0x3a2d, 0x966b },
	{ 0x3a2e, 0x9671 },
	{ 0x3a2f, 0x966f },
	{ 0x3a30, 0x96bf },
	{ 0x3a31, 0x976a },
	{ 0x3a32, 0x9804 },
	{ 0x3a33, 0x98e5 },
	{ 0x3a34, 0x9997 },
	{ 0x3a35, 0x509b },
	{ 0x3a36, 0x5095 },
	{ 0x3a37, 0x5094 },
	{ 0x3a38, 0x509e },
	{ 0x3a39, 0x508b },
	{ 0x3a3a, 0x50a3 },
	{ 0x3a3b, 0x5083 },
	{ 0x3a3c, 0x508c },
	{ 0x3a3d, 0x508e },
	{ 0x3a3e, 0x509d },
	{ 0x3a3f, 0x5068 },
	{ 0x3a40, 0x509c },
	{ 0x3a41, 0x5092 },
	{ 0x3a42, 0x5082 },
	{ 0x3a43, 0x5087 },
	{ 0x3a44, 0x515f },
	{ 0x3a45, 0x51d4 },
	{ 0x3a46, 0x5312 },
	{ 0x3a47, 0x5311 },
	{ 0x3a48, 0x53a4 },
	{ 0x3a49, 0x53a7 },
	{ 0x3a4a, 0x5591 },
	{ 0x3a4b, 0x55a8 },
	{ 0x3a4c, 0x55a5 },
	{ 0x3a4d, 0x55ad },
	{ 0x3a4e, 0x5577 },
	{ 0x3a4f, 0x5645 },
	{ 0x3a50, 0x55a2 },
	{ 0x3a51, 0x5593 },
	{ 0x3a52, 0x5588 },
	{ 0x3a53, 0x558f },
	{ 0x3a54, 0x55b5 },
	{ 0x3a55, 0x5581 },
	{ 0x3a56, 0x55a3 },
	{ 0x3a57, 0x5592 },
	{ 0x3a58, 0x55a4 },
	{ 0x3a59, 0x557d },
	{ 0x3a5a, 0x558c },
	{ 0x3a5b, 0x55a6 },
	{ 0x3a5c, 0x557f },
	{ 0x3a5d, 0x5595 },
	{ 0x3a5e, 0x55a1 },
	{ 0x3a5f, 0x558e },
	{ 0x3a60, 0x570c },
	{ 0x3a61, 0x5829 },
	{ 0x3a62, 0x5837 },
	{ 0x3a63, 0x5819 },
	{ 0x3a64, 0x581e },
	{ 0x3a65, 0x5827 },
	{ 0x3a66, 0x5823 },
	{ 0x3a67, 0x5828 },
	{ 0x3a68, 0x57f5 },
	{ 0x3a69, 0x5848 },
	{ 0x3a6a, 0x5825 },
	{ 0x3a6b, 0x581c },
	{ 0x3a6c, 0x581b },
	{ 0x3a6d, 0x5833 },
	{ 0x3a6e, 0x583f },
	{ 0x3a6f, 0x5836 },
	{ 0x3a70, 0x582e },
	{ 0x3a71, 0x5839 },
	{ 0x3a72, 0x5838 },
	{ 0x3a73, 0x582d },
	{ 0x3a74, 0x582c },
	{ 0x3a75, 0x583b },
	{ 0x3a76, 0x5961 },
	{ 0x3a77, 0x5aaf },
	{ 0x3a78, 0x5a94 },
	{ 0x3a79, 0x5a9f },
	{ 0x3a7a, 0x5a7a },
	{ 0x3a7b, 0x5aa2 },
	{ 0x3a7c, 0x5a9e },
	{ 0x3a7d, 0x5a78 },
	{ 0x3a7e, 0x5aa6 },
	{ 0x3b21, 0x5a7c },
	{ 0x3b22, 0x5aa5 },
	{ 0x3b23, 0x5aac },
	{ 0x3b24, 0x5a95 },
	{ 0x3b25, 0x5aae },
	{ 0x3b26, 0x5a37 },
	{ 0x3b27, 0x5a84 },
	{ 0x3b28, 0x5a8a },
	{ 0x3b29, 0x5a97 },
	{ 0x3b2a, 0x5a83 },
	{ 0x3b2b, 0x5a8b },
	{ 0x3b2c, 0x5aa9 },
	{ 0x3b2d, 0x5a7b },
	{ 0x3b2e, 0x5a7d },
	{ 0x3b2f, 0x5a8c },
	{ 0x3b30, 0x5a9c },
	{ 0x3b31, 0x5a8f },
	{ 0x3b32, 0x5a93 },
	{ 0x3b33, 0x5a9d },
	{ 0x3b34, 0x5bea },
	{ 0x3b35, 0x5bcd },
	{ 0x3b36, 0x5bcb },
	{ 0x3b37, 0x5bd4 },
	{ 0x3b38, 0x5bd1 },
	{ 0x3b39, 0x5bca },
	{ 0x3b3a, 0x5bce },
	{ 0x3b3b, 0x5c0c },
	{ 0x3b3c, 0x5c30 },
	{ 0x3b3d, 0x5d37 },
	{ 0x3b3e, 0x5d43 },
	{ 0x3b3f, 0x5d6b },
	{ 0x3b40, 0x5d41 },
	{ 0x3b41, 0x5d4b },
	{ 0x3b42, 0x5d3f },
	{ 0x3b43, 0x5d35 },
	{ 0x3b44, 0x5d51 },
	{ 0x3b45, 0x5d4e },
	{ 0x3b46, 0x5d55 },
	{ 0x3b47, 0x5d33 },
	{ 0x3b48, 0x5d3a },
	{ 0x3b49, 0x5d52 },
	{ 0x3b4a, 0x5d3d },
	{ 0x3b4b, 0x5d31 },
	{ 0x3b4c, 0x5d59 },
	{ 0x3b4d, 0x5d42 },
	{ 0x3b4e, 0x5d39 },
	{ 0x3b4f, 0x5d49 },
	{ 0x3b50, 0x5d38 },
	{ 0x3b51, 0x5d3c },
	{ 0x3b52, 0x5d32 },
	{ 0x3b53, 0x5d36 },
	{ 0x3b54, 0x5d40 },
	{ 0x3b55, 0x5d45 },
	{ 0x3b56, 0x5e44 },
	{ 0x3b57, 0x5e41 },
	{ 0x3b58, 0x5f58 },
	{ 0x3b59, 0x5fa6 },
	{ 0x3b5a, 0x5fa5 },
	{ 0x3b5b, 0x5fab },
	{ 0x3b5c, 0x60c9 },
	{ 0x3b5d, 0x60b9 },
	{ 0x3b5e, 0x60cc },
	{ 0x3b5f, 0x60e2 },
	{ 0x3b60, 0x60ce },
	{ 0x3b61, 0x60c4 },
	{ 0x3b62, 0x6114 },
	{ 0x3b63, 0x60f2 },
	{ 0x3b64, 0x610a },
	{ 0x3b65, 0x6116 },
	{ 0x3b66, 0x6105 },
	{ 0x3b67, 0x60f5 },
	{ 0x3b68, 0x6113 },
	{ 0x3b69, 0x60f8 },
	{ 0x3b6a, 0x60fc },
	{ 0x3b6b, 0x60fe },
	{ 0x3b6c, 0x60c1 },
	{ 0x3b6d, 0x6103 },
	{ 0x3b6e, 0x6118 },
	{ 0x3b6f, 0x611d },
	{ 0x3b70, 0x6110 },
	{ 0x3b71, 0x60ff },
	{ 0x3b72, 0x6104 },
	{ 0x3b73, 0x610b },
	{ 0x3b74, 0x624a },
	{ 0x3b75, 0x6394 },
	{ 0x3b76, 0x63b1 },
	{ 0x3b77, 0x63b0 },
	{ 0x3b78, 0x63ce },
	{ 0x3b79, 0x63e5 },
	{ 0x3b7a, 0x63e8 },
	{ 0x3b7b, 0x63ef },
	{ 0x3b7c, 0x63c3 },
	{ 0x3b7d, 0x649d },
	{ 0x3b7e, 0x63f3 },
	{ 0x3c21, 0x63ca },
	{ 0x3c22, 0x63e0 },
	{ 0x3c23, 0x63f6 },
	{ 0x3c24, 0x63d5 },
	{ 0x3c25, 0x63f2 },
	{ 0x3c26, 0x63f5 },
	{ 0x3c27, 0x6461 },
	{ 0x3c28, 0x63df },
	{ 0x3c29, 0x63be },
	{ 0x3c2a, 0x63dd },
	{ 0x3c2b, 0x63dc },
	{ 0x3c2c, 0x63c4 },
	{ 0x3c2d, 0x63d8 },
	{ 0x3c2e, 0x63d3 },
	{ 0x3c2f, 0x63c2 },
	{ 0x3c30, 0x63c7 },
	{ 0x3c31, 0x63cc },
	{ 0x3c32, 0x63cb },
	{ 0x3c33, 0x63c8 },
	{ 0x3c34, 0x63f0 },
	{ 0x3c35, 0x63d7 },
	{ 0x3c36, 0x63d9 },
	{ 0x3c37, 0x6532 },
	{ 0x3c38, 0x6567 },
	{ 0x3c39, 0x656a },
	{ 0x3c3a, 0x6564 },
	{ 0x3c3b, 0x655c },
	{ 0x3c3c, 0x6568 },
	{ 0x3c3d, 0x6565 },
	{ 0x3c3e, 0x658c },
	{ 0x3c3f, 0x659d },
	{ 0x3c40, 0x659e },
	{ 0x3c41, 0x65ae },
	{ 0x3c42, 0x65d0 },
	{ 0x3c43, 0x65d2 },
	{ 0x3c44, 0x667c },
	{ 0x3c45, 0x666c },
	{ 0x3c46, 0x667b },
	{ 0x3c47, 0x6680 },
	{ 0x3c48, 0x6671 },
	{ 0x3c49, 0x6679 },
	{ 0x3c4a, 0x666a },
	{ 0x3c4b, 0x6672 },
	{ 0x3c4c, 0x6701 },
	{ 0x3c4d, 0x690c },
	{ 0x3c4e, 0x68d3 },
	{ 0x3c4f, 0x6904 },
	{ 0x3c50, 0x68dc },
	{ 0x3c51, 0x692a },
	{ 0x3c52, 0x68ec },
	{ 0x3c53, 0x68ea },
	{ 0x3c54, 0x68f1 },
	{ 0x3c55, 0x690f },
	{ 0x3c56, 0x68d6 },
	{ 0x3c57, 0x68f7 },
	{ 0x3c58, 0x68eb },
	{ 0x3c59, 0x68e4 },
	{ 0x3c5a, 0x68f6 },
	{ 0x3c5b, 0x6913 },
	{ 0x3c5c, 0x6910 },
	{ 0x3c5d, 0x68f3 },
	{ 0x3c5e, 0x68e1 },
	{ 0x3c5f, 0x6907 },
	{ 0x3c60, 0x68cc },
	{ 0x3c61, 0x6908 },
	{ 0x3c62, 0x6970 },
	{ 0x3c63, 0x68b4 },
	{ 0x3c64, 0x6911 },
	{ 0x3c65, 0x68ef },
	{ 0x3c66, 0x68c6 },
	{ 0x3c67, 0x6914 },
	{ 0x3c68, 0x68f8 },
	{ 0x3c69, 0x68d0 },
	{ 0x3c6a, 0x68fd },
	{ 0x3c6b, 0x68fc },
	{ 0x3c6c, 0x68e8 },
	{ 0x3c6d, 0x690b },
	{ 0x3c6e, 0x690a },
	{ 0x3c6f, 0x6917 },
	{ 0x3c70, 0x68ce },
	{ 0x3c71, 0x68c8 },
	{ 0x3c72, 0x68dd },
	{ 0x3c73, 0x68de },
	{ 0x3c74, 0x68e6 },
	{ 0x3c75, 0x68f4 },
	{ 0x3c76, 0x68d1 },
	{ 0x3c77, 0x6906 },
	{ 0x3c78, 0x68d4 },
	{ 0x3c79, 0x68e9 },
	{ 0x3c7a, 0x6915 },
	{ 0x3c7b, 0x6925 },
	{ 0x3c7c, 0x68c7 },
	{ 0x3c7d, 0x6b39 },
	{ 0x3c7e, 0x6b3b },
	{ 0x3d21, 0x6b3f },
	{ 0x3d22, 0x6b3c },
	{ 0x3d23, 0x6b94 },
	{ 0x3d24, 0x6b97 },
	{ 0x3d25, 0x6b99 },
	{ 0x3d26, 0x6b95 },
	{ 0x3d27, 0x6bbd },
	{ 0x3d28, 0x6bf0 },
	{ 0x3d29, 0x6bf2 },
	{ 0x3d2a, 0x6bf3 },
	{ 0x3d2b, 0x6c30 },
	{ 0x3d2c, 0x6dfc },
	{ 0x3d2d, 0x6e46 },
	{ 0x3d2e, 0x6e47 },
	{ 0x3d2f, 0x6e1f },
	{ 0x3d30, 0x6e49 },
	{ 0x3d31, 0x6e88 },
	{ 0x3d32, 0x6e3c },
	{ 0x3d33, 0x6e3d },
	{ 0x3d34, 0x6e45 },
	{ 0x3d35, 0x6e62 },
	{ 0x3d36, 0x6e2b },
	{ 0x3d37, 0x6e3f },
	{ 0x3d38, 0x6e41 },
	{ 0x3d39, 0x6e5d },
	{ 0x3d3a, 0x6e73 },
	{ 0x3d3b, 0x6e1c },
	{ 0x3d3c, 0x6e33 },
	{ 0x3d3d, 0x6e4b },
	{ 0x3d3e, 0x6e40 },
	{ 0x3d3f, 0x6e51 },
	{ 0x3d40, 0x6e3b },
	{ 0x3d41, 0x6e03 },
	{ 0x3d42, 0x6e2e },
	{ 0x3d43, 0x6e5e },
	{ 0x3d44, 0x6e68 },
	{ 0x3d45, 0x6e5c },
	{ 0x3d46, 0x6e61 },
	{ 0x3d47, 0x6e31 },
	{ 0x3d48, 0x6e28 },
	{ 0x3d49, 0x6e60 },
	{ 0x3d4a, 0x6e71 },
	{ 0x3d4b, 0x6e6b },
	{ 0x3d4c, 0x6e39 },
	{ 0x3d4d, 0x6e22 },
	{ 0x3d4e, 0x6e30 },
	{ 0x3d4f, 0x6e53 },
	{ 0x3d50, 0x6e65 },
	{ 0x3d51, 0x6e27 },
	{ 0x3d52, 0x6e78 },
	{ 0x3d53, 0x6e64 },
	{ 0x3d54, 0x6e77 },
	{ 0x3d55, 0x6e55 },
	{ 0x3d56, 0x6e79 },
	{ 0x3d57, 0x6e52 },
	{ 0x3d58, 0x6e66 },
	{ 0x3d59, 0x6e35 },
	{ 0x3d5a, 0x6e36 },
	{ 0x3d5b, 0x6e5a },
	{ 0x3d5c, 0x7120 },
	{ 0x3d5d, 0x711e },
	{ 0x3d5e, 0x712f },
	{ 0x3d5f, 0x70fb },
	{ 0x3d60, 0x712e },
	{ 0x3d61, 0x7131 },
	{ 0x3d62, 0x7123 },
	{ 0x3d63, 0x7125 },
	{ 0x3d64, 0x7122 },
	{ 0x3d65, 0x7132 },
	{ 0x3d66, 0x711f },
	{ 0x3d67, 0x7128 },
	{ 0x3d68, 0x713a },
	{ 0x3d69, 0x711b },
	{ 0x3d6a, 0x724b },
	{ 0x3d6b, 0x725a },
	{ 0x3d6c, 0x7288 },
	{ 0x3d6d, 0x7289 },
	{ 0x3d6e, 0x7286 },
	{ 0x3d6f, 0x7285 },
	{ 0x3d70, 0x728b },
	{ 0x3d71, 0x7312 },
	{ 0x3d72, 0x730b },
	{ 0x3d73, 0x7330 },
	{ 0x3d74, 0x7322 },
	{ 0x3d75, 0x7331 },
	{ 0x3d76, 0x7333 },
	{ 0x3d77, 0x7327 },
	{ 0x3d78, 0x7332 },
	{ 0x3d79, 0x732d },
	{ 0x3d7a, 0x7326 },
	{ 0x3d7b, 0x7323 },
	{ 0x3d7c, 0x7335 },
	{ 0x3d7d, 0x730c },
	{ 0x3d7e, 0x742e },
	{ 0x3e21, 0x742c },
	{ 0x3e22, 0x7430 },
	{ 0x3e23, 0x742b },
	{ 0x3e24, 0x7416 },
	{ 0x3e25, 0x741a },
	{ 0x3e26, 0x7421 },
	{ 0x3e27, 0x742d },
	{ 0x3e28, 0x7431 },
	{ 0x3e29, 0x7424 },
	{ 0x3e2a, 0x7423 },
	{ 0x3e2b, 0x741d },
	{ 0x3e2c, 0x7429 },
	{ 0x3e2d, 0x7420 },
	{ 0x3e2e, 0x7432 },
	{ 0x3e2f, 0x74fb },
	{ 0x3e30, 0x752f },
	{ 0x3e31, 0x756f },
	{ 0x3e32, 0x756c },
	{ 0x3e33, 0x75e7 },
	{ 0x3e34, 0x75da },
	{ 0x3e35, 0x75e1 },
	{ 0x3e36, 0x75e6 },
	{ 0x3e37, 0x75dd },
	{ 0x3e38, 0x75df },
	{ 0x3e39, 0x75e4 },
	{ 0x3e3a, 0x75d7 },
	{ 0x3e3b, 0x7695 },
	{ 0x3e3c, 0x7692 },
	{ 0x3e3d, 0x76da },
	{ 0x3e3e, 0x7746 },
	{ 0x3e3f, 0x7747 },
	{ 0x3e40, 0x7744 },
	{ 0x3e41, 0x774d },
	{ 0x3e42, 0x7745 },
	{ 0x3e43, 0x774a },
	{ 0x3e44, 0x774e },
	{ 0x3e45, 0x774b },
	{ 0x3e46, 0x774c },
	{ 0x3e47, 0x77de },
	{ 0x3e48, 0x77ec },
	{ 0x3e49, 0x7860 },
	{ 0x3e4a, 0x7864 },
	{ 0x3e4b, 0x7865 },
	{ 0x3e4c, 0x785c },
	{ 0x3e4d, 0x786d },
	{ 0x3e4e, 0x7871 },
	{ 0x3e4f, 0x786a },
	{ 0x3e50, 0x786e },
	{ 0x3e51, 0x7870 },
	{ 0x3e52, 0x7869 },
	{ 0x3e53, 0x7868 },
	{ 0x3e54, 0x785e },
	{ 0x3e55, 0x7862 },
	{ 0x3e56, 0x7974 },
	{ 0x3e57, 0x7973 },
	{ 0x3e58, 0x7972 },
	{ 0x3e59, 0x7970 },
	{ 0x3e5a, 0x7a02 },
	{ 0x3e5b, 0x7a0a },
	{ 0x3e5c, 0x7a03 },
	{ 0x3e5d, 0x7a0c },
	{ 0x3e5e, 0x7a04 },
	{ 0x3e5f, 0x7a99 },
	{ 0x3e60, 0x7ae6 },
	{ 0x3e61, 0x7ae4 },
	{ 0x3e62, 0x7b4a },
	{ 0x3e63, 0x7b47 },
	{ 0x3e64, 0x7b44 },
	{ 0x3e65, 0x7b48 },
	{ 0x3e66, 0x7b4c },
	{ 0x3e67, 0x7b4e },
	{ 0x3e68, 0x7b40 },
	{ 0x3e69, 0x7b58 },
	{ 0x3e6a, 0x7b45 },
	{ 0x3e6b, 0x7ca2 },
	{ 0x3e6c, 0x7c9e },
	{ 0x3e6d, 0x7ca8 },
	{ 0x3e6e, 0x7ca1 },
	{ 0x3e6f, 0x7d58 },
	{ 0x3e70, 0x7d6f },
	{ 0x3e71, 0x7d63 },
	{ 0x3e72, 0x7d53 },
	{ 0x3e73, 0x7d56 },
	{ 0x3e74, 0x7d67 },
	{ 0x3e75, 0x7d6a },
	{ 0x3e76, 0x7d4f },
	{ 0x3e77, 0x7d6d },
	{ 0x3e78, 0x7d5c },
	{ 0x3e79, 0x7d6b },
	{ 0x3e7a, 0x7d52 },
	{ 0x3e7b, 0x7d54 },
	{ 0x3e7c, 0x7d69 },
	{ 0x3e7d, 0x7d51 },
	{ 0x3e7e, 0x7d5f },
	{ 0x3f21, 0x7d4e },
	{ 0x3f22, 0x7f3e },
	{ 0x3f23, 0x7f3f },
	{ 0x3f24, 0x7f65 },
	{ 0x3f25, 0x7f66 },
	{ 0x3f26, 0x7fa2 },
	{ 0x3f27, 0x7fa0 },
	{ 0x3f28, 0x7fa1 },
	{ 0x3f29, 0x7fd7 },
	{ 0x3f2a, 0x8051 },
	{ 0x3f2b, 0x804f },
	{ 0x3f2c, 0x8050 },
	{ 0x3f2d, 0x80fe },
	{ 0x3f2e, 0x80d4 },
	{ 0x3f2f, 0x8143 },
	{ 0x3f30, 0x814a },
	{ 0x3f31, 0x8152 },
	{ 0x3f32, 0x814f },
	{ 0x3f33, 0x8147 },
	{ 0x3f34, 0x813d },
	{ 0x3f35, 0x814d },
	{ 0x3f36, 0x813a },
	{ 0x3f37, 0x81e6 },
	{ 0x3f38, 0x81ee },
	{ 0x3f39, 0x81f7 },
	{ 0x3f3a, 0x81f8 },
	{ 0x3f3b, 0x81f9 },
	{ 0x3f3c, 0x8204 },
	{ 0x3f3d, 0x823c },
	{ 0x3f3e, 0x823d },
	{ 0x3f3f, 0x823f },
	{ 0x3f40, 0x8275 },
	{ 0x3f41, 0x833b },
	{ 0x3f42, 0x83cf },
	{ 0x3f43, 0x83f9 },
	{ 0x3f44, 0x8423 },
	{ 0x3f45, 0x83c0 },
	{ 0x3f46, 0x83e8 },
	{ 0x3f47, 0x8412 },
	{ 0x3f48, 0x83e7 },
	{ 0x3f49, 0x83e4 },
	{ 0x3f4a, 0x83fc },
	{ 0x3f4b, 0x83f6 },
	{ 0x3f4c, 0x8410 },
	{ 0x3f4d, 0x83c6 },
	{ 0x3f4e, 0x83c8 },
	{ 0x3f4f, 0x83eb },
	{ 0x3f50, 0x83e3 },
	{ 0x3f51, 0x83bf },
	{ 0x3f52, 0x8401 },
	{ 0x3f53, 0x83dd },
	{ 0x3f54, 0x83e5 },
	{ 0x3f55, 0x83d8 },
	{ 0x3f56, 0x83ff },
	{ 0x3f57, 0x83e1 },
	{ 0x3f58, 0x83cb },
	{ 0x3f59, 0x83ce },
	{ 0x3f5a, 0x83d6 },
	{ 0x3f5b, 0x83f5 },
	{ 0x3f5c, 0x83c9 },
	{ 0x3f5d, 0x8409 },
	{ 0x3f5e, 0x840f },
	{ 0x3f5f, 0x83de },
	{ 0x3f60, 0x8411 },
	{ 0x3f61, 0x8406 },
	{ 0x3f62, 0x83c2 },
	{ 0x3f63, 0x83f3 },
	{ 0x3f64, 0x83d5 },
	{ 0x3f65, 0x83fa },
	{ 0x3f66, 0x83c7 },
	{ 0x3f67, 0x83d1 },
	{ 0x3f68, 0x83ea },
	{ 0x3f69, 0x8413 },
	{ 0x3f6a, 0x839a },
	{ 0x3f6b, 0x83c3 },
	{ 0x3f6c, 0x83ec },
	{ 0x3f6d, 0x83ee },
	{ 0x3f6e, 0x83c4 },
	{ 0x3f6f, 0x83fb },
	{ 0x3f70, 0x83d7 },
	{ 0x3f71, 0x83e2 },
	{ 0x3f72, 0x841b },
	{ 0x3f73, 0x83db },
	{ 0x3f74, 0x83fe },
	{ 0x3f75, 0x86d8 },
	{ 0x3f76, 0x86e2 },
	{ 0x3f77, 0x86e6 },
	{ 0x3f78, 0x86d3 },
	{ 0x3f79, 0x86e3 },
	{ 0x3f7a, 0x86da },
	{ 0x3f7b, 0x86ea },
	{ 0x3f7c, 0x86dd },
	{ 0x3f7d, 0x86eb },
	{ 0x3f7e, 0x86dc },
	{ 0x4021, 0x86ec },
	{ 0x4022, 0x86e9 },
	{ 0x4023, 0x86d7 },
	{ 0x4024, 0x86e8 },
	{ 0x4025, 0x86d1 },
	{ 0x4026, 0x8848 },
	{ 0x4027, 0x8856 },
	{ 0x4028, 0x8855 },
	{ 0x4029, 0x88ba },
	{ 0x402a, 0x88d7 },
	{ 0x402b, 0x88b9 },
	{ 0x402c, 0x88b8 },
	{ 0x402d, 0x88c0 },
	{ 0x402e, 0x88be },
	{ 0x402f, 0x88b6 },
	{ 0x4030, 0x88bc },
	{ 0x4031, 0x88b7 },
	{ 0x4032, 0x88bd },
	{ 0x4033, 0x88b2 },
	{ 0x4034, 0x8901 },
	{ 0x4035, 0x88c9 },
	{ 0x4036, 0x8995 },
	{ 0x4037, 0x8998 },
	{ 0x4038, 0x8997 },
	{ 0x4039, 0x89dd },
	{ 0x403a, 0x89da },
	{ 0x403b, 0x89db },
	{ 0x403c, 0x8a4e },
	{ 0x403d, 0x8a4d },
	{ 0x403e, 0x8a39 },
	{ 0x403f, 0x8a59 },
	{ 0x4040, 0x8a40 },
	{ 0x4041, 0x8a57 },
	{ 0x4042, 0x8a58 },
	{ 0x4043, 0x8a44 },
	{ 0x4044, 0x8a45 },
	{ 0x4045, 0x8a52 },
	{ 0x4046, 0x8a48 },
	{ 0x4047, 0x8a51 },
	{ 0x4048, 0x8a4a },
	{ 0x4049, 0x8a4c },
	{ 0x404a, 0x8a4f },
	{ 0x404b, 0x8c5f },
	{ 0x404c, 0x8c81 },
	{ 0x404d, 0x8c80 },
	{ 0x404e, 0x8cba },
	{ 0x404f, 0x8cbe },
	{ 0x4050, 0x8cb0 },
	{ 0x4051, 0x8cb9 },
	{ 0x4052, 0x8cb5 },
	{ 0x4053, 0x8d84 },
	{ 0x4054, 0x8d80 },
	{ 0x4055, 0x8d89 },
	{ 0x4056, 0x8dd8 },
	{ 0x4057, 0x8dd3 },
	{ 0x4058, 0x8dcd },
	{ 0x4059, 0x8dc7 },
	{ 0x405a, 0x8dd6 },
	{ 0x405b, 0x8ddc },
	{ 0x405c, 0x8dcf },
	{ 0x405d, 0x8dd5 },
	{ 0x405e, 0x8dd9 },
	{ 0x405f, 0x8dc8 },
	{ 0x4060, 0x8dd7 },
	{ 0x4061, 0x8dc5 },
	{ 0x4062, 0x8eef },
	{ 0x4063, 0x8ef7 },
	{ 0x4064, 0x8efa },
	{ 0x4065, 0x8ef9 },
	{ 0x4066, 0x8ee6 },
	{ 0x4067, 0x8eee },
	{ 0x4068, 0x8ee5 },
	{ 0x4069, 0x8ef5 },
	{ 0x406a, 0x8ee7 },
	{ 0x406b, 0x8ee8 },
	{ 0x406c, 0x8ef6 },
	{ 0x406d, 0x8eeb },
	{ 0x406e, 0x8ef1 },
	{ 0x406f, 0x8eec },
	{ 0x4070, 0x8ef4 },
	{ 0x4071, 0x8ee9 },
	{ 0x4072, 0x902d },
	{ 0x4073, 0x9034 },
	{ 0x4074, 0x902f },
	{ 0x4075, 0x9106 },
	{ 0x4076, 0x912c },
	{ 0x4077, 0x9104 },
	{ 0x4078, 0x90ff },
	{ 0x4079, 0x90fc },
	{ 0x407a, 0x9108 },
	{ 0x407b, 0x90f9 },
	{ 0x407c, 0x90fb },
	{ 0x407d, 0x9101 },
	{ 0x407e, 0x9100 },
	{ 0x4121, 0x9107 },
	{ 0x4122, 0x9105 },
	{ 0x4123, 0x9103 },
	{ 0x4124, 0x9161 },
	{ 0x4125, 0x9164 },
	{ 0x4126, 0x915f },
	{ 0x4127, 0x9162 },
	{ 0x4128, 0x9160 },
	{ 0x4129, 0x9201 },
	{ 0x412a, 0x920a },
	{ 0x412b, 0x9225 },
	{ 0x412c, 0x9203 },
	{ 0x412d, 0x921a },
	{ 0x412e, 0x9226 },
	{ 0x412f, 0x920f },
	{ 0x4130, 0x920c },
	{ 0x4131, 0x9200 },
	{ 0x4132, 0x9212 },
	{ 0x4133, 0x91ff },
	{ 0x4134, 0x91fd },
	{ 0x4135, 0x9206 },
	{ 0x4136, 0x9204 },
	{ 0x4137, 0x9227 },
	{ 0x4138, 0x9202 },
	{ 0x4139, 0x921c },
	{ 0x413a, 0x9224 },
	{ 0x413b, 0x9219 },
	{ 0x413c, 0x9217 },
	{ 0x413d, 0x9205 },
	{ 0x413e, 0x9216 },
	{ 0x413f, 0x957b },
	{ 0x4140, 0x958d },
	{ 0x4141, 0x958c },
	{ 0x4142, 0x9590 },
	{ 0x4143, 0x9687 },
	{ 0x4144, 0x967e },
	{ 0x4145, 0x9688 },
	{ 0x4146, 0x9689 },
	{ 0x4147, 0x9683 },
	{ 0x4148, 0x9680 },
	{ 0x4149, 0x96c2 },
	{ 0x414a, 0x96c8 },
	{ 0x414b, 0x96c3 },
	{ 0x414c, 0x96f1 },
	{ 0x414d, 0x96f0 },
	{ 0x414e, 0x976c },
	{ 0x414f, 0x9770 },
	{ 0x4150, 0x976e },
	{ 0x4151, 0x9807 },
	{ 0x4152, 0x98a9 },
	{ 0x4153, 0x98eb },
	{ 0x4154, 0x9ce6 },
	{ 0x4155, 0x9ef9 },
	{ 0x4156, 0x4e83 },
	{ 0x4157, 0x4e84 },
	{ 0x4158, 0x4eb6 },
	{ 0x4159, 0x50bd },
	{ 0x415a, 0x50bf },
	{ 0x415b, 0x50c6 },
	{ 0x415c, 0x50ae },
	{ 0x415d, 0x50c4 },
	{ 0x415e, 0x50ca },
	{ 0x415f, 0x50b4 },
	{ 0x4160, 0x50c8 },
	{ 0x4161, 0x50c2 },
	{ 0x4162, 0x50b0 },
	{ 0x4163, 0x50c1 },
	{ 0x4164, 0x50ba },
	{ 0x4165, 0x50b1 },
	{ 0x4166, 0x50cb },
	{ 0x4167, 0x50c9 },
	{ 0x4168, 0x50b6 },
	{ 0x4169, 0x50b8 },
	{ 0x416a, 0x51d7 },
	{ 0x416b, 0x527a },
	{ 0x416c, 0x5278 },
	{ 0x416d, 0x527b },
	{ 0x416e, 0x527c },
	{ 0x416f, 0x55c3 },
	{ 0x4170, 0x55db },
	{ 0x4171, 0x55cc },
	{ 0x4172, 0x55d0 },
	{ 0x4173, 0x55cb },
	{ 0x4174, 0x55ca },
	{ 0x4175, 0x55dd },
	{ 0x4176, 0x55c0 },
	{ 0x4177, 0x55d4 },
	{ 0x4178, 0x55c4 },
	{ 0x4179, 0x55e9 },
	{ 0x417a, 0x55bf },
	{ 0x417b, 0x55d2 },
	{ 0x417c, 0x558d },
	{ 0x417d, 0x55cf },
	{ 0x417e, 0x55d5 },
	{ 0x4221, 0x55e2 },
	{ 0x4222, 0x55d6 },
	{ 0x4223, 0x55c8 },
	{ 0x4224, 0x55f2 },
	{ 0x4225, 0x55cd },
	{ 0x4226, 0x55d9 },
	{ 0x4227, 0x55c2 },
	{ 0x4228, 0x5714 },
	{ 0x4229, 0x5853 },
	{ 0x422a, 0x5868 },
	{ 0x422b, 0x5864 },
	{ 0x422c, 0x584f },
	{ 0x422d, 0x584d },
	{ 0x422e, 0x5849 },
	{ 0x422f, 0x586f },
	{ 0x4230, 0x5855 },
	{ 0x4231, 0x584e },
	{ 0x4232, 0x585d },
	{ 0x4233, 0x5859 },
	{ 0x4234, 0x5865 },
	{ 0x4235, 0x585b },
	{ 0x4236, 0x583d },
	{ 0x4237, 0x5863 },
	{ 0x4238, 0x5871 },
	{ 0x4239, 0x58fc },
	{ 0x423a, 0x5ac7 },
	{ 0x423b, 0x5ac4 },
	{ 0x423c, 0x5acb },
	{ 0x423d, 0x5aba },
	{ 0x423e, 0x5ab8 },
	{ 0x423f, 0x5ab1 },
	{ 0x4240, 0x5ab5 },
	{ 0x4241, 0x5ab0 },
	{ 0x4242, 0x5abf },
	{ 0x4243, 0x5ac8 },
	{ 0x4244, 0x5abb },
	{ 0x4245, 0x5ac6 },
	{ 0x4246, 0x5ab7 },
	{ 0x4247, 0x5ac0 },
	{ 0x4248, 0x5aca },
	{ 0x4249, 0x5ab4 },
	{ 0x424a, 0x5ab6 },
	{ 0x424b, 0x5acd },
	{ 0x424c, 0x5ab9 },
	{ 0x424d, 0x5a90 },
	{ 0x424e, 0x5bd6 },
	{ 0x424f, 0x5bd8 },
	{ 0x4250, 0x5bd9 },
	{ 0x4251, 0x5c1f },
	{ 0x4252, 0x5c33 },
	{ 0x4253, 0x5d71 },
	{ 0x4254, 0x5d63 },
	{ 0x4255, 0x5d4a },
	{ 0x4256, 0x5d65 },
	{ 0x4257, 0x5d72 },
	{ 0x4258, 0x5d6c },
	{ 0x4259, 0x5d5e },
	{ 0x425a, 0x5d68 },
	{ 0x425b, 0x5d67 },
	{ 0x425c, 0x5d62 },
	{ 0x425d, 0x5df0 },
	{ 0x425e, 0x5e4f },
	{ 0x425f, 0x5e4e },
	{ 0x4260, 0x5e4a },
	{ 0x4261, 0x5e4d },
	{ 0x4262, 0x5e4b },
	{ 0x4263, 0x5ec5 },
	{ 0x4264, 0x5ecc },
	{ 0x4265, 0x5ec6 },
	{ 0x4266, 0x5ecb },
	{ 0x4267, 0x5ec7 },
	{ 0x4268, 0x5f40 },
	{ 0x4269, 0x5faf },
	{ 0x426a, 0x5fad },
	{ 0x426b, 0x60f7 },
	{ 0x426c, 0x6149 },
	{ 0x426d, 0x614a },
	{ 0x426e, 0x612b },
	{ 0x426f, 0x6145 },
	{ 0x4270, 0x6136 },
	{ 0x4271, 0x6132 },
	{ 0x4272, 0x612e },
	{ 0x4273, 0x6146 },
	{ 0x4274, 0x612f },
	{ 0x4275, 0x614f },
	{ 0x4276, 0x6129 },
	{ 0x4277, 0x6140 },
	{ 0x4278, 0x6220 },
	{ 0x4279, 0x9168 },
	{ 0x427a, 0x6223 },
	{ 0x427b, 0x6225 },
	{ 0x427c, 0x6224 },
	{ 0x427d, 0x63c5 },
	{ 0x427e, 0x63f1 },
	{ 0x4321, 0x63eb },
	{ 0x4322, 0x6410 },
	{ 0x4323, 0x6412 },
	{ 0x4324, 0x6409 },
	{ 0x4325, 0x6420 },
	{ 0x4326, 0x6424 },
	{ 0x4327, 0x6433 },
	{ 0x4328, 0x6443 },
	{ 0x4329, 0x641f },
	{ 0x432a, 0x6415 },
	{ 0x432b, 0x6418 },
	{ 0x432c, 0x6439 },
	{ 0x432d, 0x6437 },
	{ 0x432e, 0x6422 },
	{ 0x432f, 0x6423 },
	{ 0x4330, 0x640c },
	{ 0x4331, 0x6426 },
	{ 0x4332, 0x6430 },
	{ 0x4333, 0x6428 },
	{ 0x4334, 0x6441 },
	{ 0x4335, 0x6435 },
	{ 0x4336, 0x642f },
	{ 0x4337, 0x640a },
	{ 0x4338, 0x641a },
	{ 0x4339, 0x6440 },
	{ 0x433a, 0x6425 },
	{ 0x433b, 0x6427 },
	{ 0x433c, 0x640b },
	{ 0x433d, 0x63e7 },
	{ 0x433e, 0x641b },
	{ 0x433f, 0x642e },
	{ 0x4340, 0x6421 },
	{ 0x4341, 0x640e },
	{ 0x4342, 0x656f },
	{ 0x4343, 0x6592 },
	{ 0x4344, 0x65d3 },
	{ 0x4345, 0x6686 },
	{ 0x4346, 0x668c },
	{ 0x4347, 0x6695 },
	{ 0x4348, 0x6690 },
	{ 0x4349, 0x668b },
	{ 0x434a, 0x668a },
	{ 0x434b, 0x6699 },
	{ 0x434c, 0x6694 },
	{ 0x434d, 0x6678 },
	{ 0x434e, 0x6720 },
	{ 0x434f, 0x6966 },
	{ 0x4350, 0x695f },
	{ 0x4351, 0x6938 },
	{ 0x4352, 0x694e },
	{ 0x4353, 0x6962 },
	{ 0x4354, 0x6971 },
	{ 0x4355, 0x693f },
	{ 0x4356, 0x6945 },
	{ 0x4357, 0x696a },
	{ 0x4358, 0x6939 },
	{ 0x4359, 0x6942 },
	{ 0x435a, 0x6957 },
	{ 0x435b, 0x6959 },
	{ 0x435c, 0x697a },
	{ 0x435d, 0x6948 },
	{ 0x435e, 0x6949 },
	{ 0x435f, 0x6935 },
	{ 0x4360, 0x696c },
	{ 0x4361, 0x6933 },
	{ 0x4362, 0x693d },
	{ 0x4363, 0x6965 },
	{ 0x4364, 0x68f0 },
	{ 0x4365, 0x6978 },
	{ 0x4366, 0x6934 },
	{ 0x4367, 0x6969 },
	{ 0x4368, 0x6940 },
	{ 0x4369, 0x696f },
	{ 0x436a, 0x6944 },
	{ 0x436b, 0x6976 },
	{ 0x436c, 0x6958 },
	{ 0x436d, 0x6941 },
	{ 0x436e, 0x6974 },
	{ 0x436f, 0x694c },
	{ 0x4370, 0x693b },
	{ 0x4371, 0x694b },
	{ 0x4372, 0x6937 },
	{ 0x4373, 0x695c },
	{ 0x4374, 0x694f },
	{ 0x4375, 0x6951 },
	{ 0x4376, 0x6932 },
	{ 0x4377, 0x6952 },
	{ 0x4378, 0x692f },
	{ 0x4379, 0x697b },
	{ 0x437a, 0x693c },
	{ 0x437b, 0x6b46 },
	{ 0x437c, 0x6b45 },
	{ 0x437d, 0x6b43 },
	{ 0x437e, 0x6b42 },
	{ 0x4421, 0x6b48 },
	{ 0x4422, 0x6b41 },
	{ 0x4423, 0x6b9b },
	{ 0x4424, 0x6bfb },
	{ 0x4425, 0x6bfc },
	{ 0x4426, 0x6bf9 },
	{ 0x4427, 0x6bf7 },
	{ 0x4428, 0x6bf8 },
	{ 0x4429, 0x6e9b },
	{ 0x442a, 0x6ed6 },
	{ 0x442b, 0x6ec8 },
	{ 0x442c, 0x6e8f },
	{ 0x442d, 0x6ec0 },
	{ 0x442e, 0x6e9f },
	{ 0x442f, 0x6e93 },
	{ 0x4430, 0x6e94 },
	{ 0x4431, 0x6ea0 },
	{ 0x4432, 0x6eb1 },
	{ 0x4433, 0x6eb9 },
	{ 0x4434, 0x6ec6 },
	{ 0x4435, 0x6ed2 },
	{ 0x4436, 0x6ebd },
	{ 0x4437, 0x6ec1 },
	{ 0x4438, 0x6e9e },
	{ 0x4439, 0x6ec9 },
	{ 0x443a, 0x6eb7 },
	{ 0x443b, 0x6eb0 },
	{ 0x443c, 0x6ecd },
	{ 0x443d, 0x6ea6 },
	{ 0x443e, 0x6ecf },
	{ 0x443f, 0x6eb2 },
	{ 0x4440, 0x6ebe },
	{ 0x4441, 0x6ec3 },
	{ 0x4442, 0x6edc },
	{ 0x4443, 0x6ed8 },
	{ 0x4444, 0x6e99 },
	{ 0x4445, 0x6e92 },
	{ 0x4446, 0x6e8e },
	{ 0x4447, 0x6e8d },
	{ 0x4448, 0x6ea4 },
	{ 0x4449, 0x6ea1 },
	{ 0x444a, 0x6ebf },
	{ 0x444b, 0x6eb3 },
	{ 0x444c, 0x6ed0 },
	{ 0x444d, 0x6eca },
	{ 0x444e, 0x6e97 },
	{ 0x444f, 0x6eae },
	{ 0x4450, 0x6ea3 },
	{ 0x4451, 0x7147 },
	{ 0x4452, 0x7154 },
	{ 0x4453, 0x7152 },
	{ 0x4454, 0x7163 },
	{ 0x4455, 0x7160 },
	{ 0x4456, 0x7141 },
	{ 0x4457, 0x715d },
	{ 0x4458, 0x7162 },
	{ 0x4459, 0x7172 },
	{ 0x445a, 0x7178 },
	{ 0x445b, 0x716a },
	{ 0x445c, 0x7161 },
	{ 0x445d, 0x7142 },
	{ 0x445e, 0x7158 },
	{ 0x445f, 0x7143 },
	{ 0x4460, 0x714b },
	{ 0x4461, 0x7170 },
	{ 0x4462, 0x715f },
	{ 0x4463, 0x7150 },
	{ 0x4464, 0x7153 },
	{ 0x4465, 0x7144 },
	{ 0x4466, 0x714d },
	{ 0x4467, 0x715a },
	{ 0x4468, 0x724f },
	{ 0x4469, 0x728d },
	{ 0x446a, 0x728c },
	{ 0x446b, 0x7291 },
	{ 0x446c, 0x7290 },
	{ 0x446d, 0x728e },
	{ 0x446e, 0x733c },
	{ 0x446f, 0x7342 },
	{ 0x4470, 0x733b },
	{ 0x4471, 0x733a },
	{ 0x4472, 0x7340 },
	{ 0x4473, 0x734a },
	{ 0x4474, 0x7349 },
	{ 0x4475, 0x7444 },
	{ 0x4476, 0x744a },
	{ 0x4477, 0x744b },
	{ 0x4478, 0x7452 },
	{ 0x4479, 0x7451 },
	{ 0x447a, 0x7457 },
	{ 0x447b, 0x7440 },
	{ 0x447c, 0x744f },
	{ 0x447d, 0x7450 },
	{ 0x447e, 0x744e },
	{ 0x4521, 0x7442 },
	{ 0x4522, 0x7446 },
	{ 0x4523, 0x744d },
	{ 0x4524, 0x7454 },
	{ 0x4525, 0x74e1 },
	{ 0x4526, 0x74ff },
	{ 0x4527, 0x74fe },
	{ 0x4528, 0x74fd },
	{ 0x4529, 0x751d },
	{ 0x452a, 0x7579 },
	{ 0x452b, 0x7577 },
	{ 0x452c, 0x6983 },
	{ 0x452d, 0x75ef },
	{ 0x452e, 0x760f },
	{ 0x452f, 0x7603 },
	{ 0x4530, 0x75f7 },
	{ 0x4531, 0x75fe },
	{ 0x4532, 0x75fc },
	{ 0x4533, 0x75f9 },
	{ 0x4534, 0x75f8 },
	{ 0x4535, 0x7610 },
	{ 0x4536, 0x75fb },
	{ 0x4537, 0x75f6 },
	{ 0x4538, 0x75ed },
	{ 0x4539, 0x75f5 },
	{ 0x453a, 0x75fd },
	{ 0x453b, 0x7699 },
	{ 0x453c, 0x76b5 },
	{ 0x453d, 0x76dd },
	{ 0x453e, 0x7755 },
	{ 0x453f, 0x775f },
	{ 0x4540, 0x7760 },
	{ 0x4541, 0x7752 },
	{ 0x4542, 0x7756 },
	{ 0x4543, 0x775a },
	{ 0x4544, 0x7769 },
	{ 0x4545, 0x7767 },
	{ 0x4546, 0x7754 },
	{ 0x4547, 0x7759 },
	{ 0x4548, 0x776d },
	{ 0x4549, 0x77e0 },
	{ 0x454a, 0x7887 },
	{ 0x454b, 0x789a },
	{ 0x454c, 0x7894 },
	{ 0x454d, 0x788f },
	{ 0x454e, 0x7884 },
	{ 0x454f, 0x7895 },
	{ 0x4550, 0x7885 },
	{ 0x4551, 0x7886 },
	{ 0x4552, 0x78a1 },
	{ 0x4553, 0x7883 },
	{ 0x4554, 0x7879 },
	{ 0x4555, 0x7899 },
	{ 0x4556, 0x7880 },
	{ 0x4557, 0x7896 },
	{ 0x4558, 0x787b },
	{ 0x4559, 0x797c },
	{ 0x455a, 0x7982 },
	{ 0x455b, 0x797d },
	{ 0x455c, 0x7979 },
	{ 0x455d, 0x7a11 },
	{ 0x455e, 0x7a18 },
	{ 0x455f, 0x7a19 },
	{ 0x4560, 0x7a12 },
	{ 0x4561, 0x7a17 },
	{ 0x4562, 0x7a15 },
	{ 0x4563, 0x7a22 },
	{ 0x4564, 0x7a13 },
	{ 0x4565, 0x7a1b },
	{ 0x4566, 0x7a10 },
	{ 0x4567, 0x7aa3 },
	{ 0x4568, 0x7aa2 },
	{ 0x4569, 0x7a9e },
	{ 0x456a, 0x7aeb },
	{ 0x456b, 0x7b66 },
	{ 0x456c, 0x7b64 },
	{ 0x456d, 0x7b6d },
	{ 0x456e, 0x7b74 },
	{ 0x456f, 0x7b69 },
	{ 0x4570, 0x7b72 },
	{ 0x4571, 0x7b65 },
	{ 0x4572, 0x7b73 },
	{ 0x4573, 0x7b71 },
	{ 0x4574, 0x7b70 },
	{ 0x4575, 0x7b61 },
	{ 0x4576, 0x7b78 },
	{ 0x4577, 0x7b76 },
	{ 0x4578, 0x7b63 },
	{ 0x4579, 0x7cb2 },
	{ 0x457a, 0x7cb4 },
	{ 0x457b, 0x7caf },
	{ 0x457c, 0x7d88 },
	{ 0x457d, 0x7d86 },
	{ 0x457e, 0x7d80 },
	{ 0x4621, 0x7d8d },
	{ 0x4622, 0x7d7f },
	{ 0x4623, 0x7d85 },
	{ 0x4624, 0x7d7a },
	{ 0x4625, 0x7d8e },
	{ 0x4626, 0x7d7b },
	{ 0x4627, 0x7d83 },
	{ 0x4628, 0x7d7c },
	{ 0x4629, 0x7d8c },
	{ 0x462a, 0x7d94 },
	{ 0x462b, 0x7d84 },
	{ 0x462c, 0x7d7d },
	{ 0x462d, 0x7d92 },
	{ 0x462e, 0x7f6d },
	{ 0x462f, 0x7f6b },
	{ 0x4630, 0x7f67 },
	{ 0x4631, 0x7f68 },
	{ 0x4632, 0x7f6c },
	{ 0x4633, 0x7fa6 },
	{ 0x4634, 0x7fa5 },
	{ 0x4635, 0x7fa7 },
	{ 0x4636, 0x7fdb },
	{ 0x4637, 0x7fdc },
	{ 0x4638, 0x8021 },
	{ 0x4639, 0x8164 },
	{ 0x463a, 0x8160 },
	{ 0x463b, 0x8177 },
	{ 0x463c, 0x815c },
	{ 0x463d, 0x8169 },
	{ 0x463e, 0x815b },
	{ 0x463f, 0x8162 },
	{ 0x4640, 0x8172 },
	{ 0x4641, 0x6721 },
	{ 0x4642, 0x815e },
	{ 0x4643, 0x8176 },
	{ 0x4644, 0x8167 },
	{ 0x4645, 0x816f },
	{ 0x4646, 0x8144 },
	{ 0x4647, 0x8161 },
	{ 0x4648, 0x821d },
	{ 0x4649, 0x8249 },
	{ 0x464a, 0x8244 },
	{ 0x464b, 0x8240 },
	{ 0x464c, 0x8242 },
	{ 0x464d, 0x8245 },
	{ 0x464e, 0x84f1 },
	{ 0x464f, 0x843f },
	{ 0x4650, 0x8456 },
	{ 0x4651, 0x8476 },
	{ 0x4652, 0x8479 },
	{ 0x4653, 0x848f },
	{ 0x4654, 0x848d },
	{ 0x4655, 0x8465 },
	{ 0x4656, 0x8451 },
	{ 0x4657, 0x8440 },
	{ 0x4658, 0x8486 },
	{ 0x4659, 0x8467 },
	{ 0x465a, 0x8430 },
	{ 0x465b, 0x844d },
	{ 0x465c, 0x847d },
	{ 0x465d, 0x845a },
	{ 0x465e, 0x8459 },
	{ 0x465f, 0x8474 },
	{ 0x4660, 0x8473 },
	{ 0x4661, 0x845d },
	{ 0x4662, 0x8507 },
	{ 0x4663, 0x845e },
	{ 0x4664, 0x8437 },
	{ 0x4665, 0x843a },
	{ 0x4666, 0x8434 },
	{ 0x4667, 0x847a },
	{ 0x4668, 0x8443 },
	{ 0x4669, 0x8478 },
	{ 0x466a, 0x8432 },
	{ 0x466b, 0x8445 },
	{ 0x466c, 0x8429 },
	{ 0x466d, 0x83d9 },
	{ 0x466e, 0x844b },
	{ 0x466f, 0x842f },
	{ 0x4670, 0x8442 },
	{ 0x4671, 0x842d },
	{ 0x4672, 0x845f },
	{ 0x4673, 0x8470 },
	{ 0x4674, 0x8439 },
	{ 0x4675, 0x844e },
	{ 0x4676, 0x844c },
	{ 0x4677, 0x8452 },
	{ 0x4678, 0x846f },
	{ 0x4679, 0x84c5 },
	{ 0x467a, 0x848e },
	{ 0x467b, 0x843b },
	{ 0x467c, 0x8447 },
	{ 0x467d, 0x8436 },
	{ 0x467e, 0x8433 },
	{ 0x4721, 0x8468 },
	{ 0x4722, 0x847e },
	{ 0x4723, 0x8444 },
	{ 0x4724, 0x842b },
	{ 0x4725, 0x8460 },
	{ 0x4726, 0x8454 },
	{ 0x4727, 0x846e },
	{ 0x4728, 0x8450 },
	{ 0x4729, 0x870b },
	{ 0x472a, 0x8704 },
	{ 0x472b, 0x86f7 },
	{ 0x472c, 0x870c },
	{ 0x472d, 0x86fa },
	{ 0x472e, 0x86d6 },
	{ 0x472f, 0x86f5 },
	{ 0x4730, 0x874d },
	{ 0x4731, 0x86f8 },
	{ 0x4732, 0x870e },
	{ 0x4733, 0x8709 },
	{ 0x4734, 0x8701 },
	{ 0x4735, 0x86f6 },
	{ 0x4736, 0x870d },
	{ 0x4737, 0x8705 },
	{ 0x4738, 0x88d6 },
	{ 0x4739, 0x88cb },
	{ 0x473a, 0x88cd },
	{ 0x473b, 0x88ce },
	{ 0x473c, 0x88de },
	{ 0x473d, 0x88db },
	{ 0x473e, 0x88da },
	{ 0x473f, 0x88cc },
	{ 0x4740, 0x88d0 },
	{ 0x4741, 0x8985 },
	{ 0x4742, 0x899b },
	{ 0x4743, 0x89df },
	{ 0x4744, 0x89e5 },
	{ 0x4745, 0x89e4 },
	{ 0x4746, 0x89e1 },
	{ 0x4747, 0x89e0 },
	{ 0x4748, 0x89e2 },
	{ 0x4749, 0x89dc },
	{ 0x474a, 0x89e6 },
	{ 0x474b, 0x8a76 },
	{ 0x474c, 0x8a86 },
	{ 0x474d, 0x8a7f },
	{ 0x474e, 0x8a61 },
	{ 0x474f, 0x8a3f },
	{ 0x4750, 0x8a77 },
	{ 0x4751, 0x8a82 },
	{ 0x4752, 0x8a84 },
	{ 0x4753, 0x8a75 },
	{ 0x4754, 0x8a83 },
	{ 0x4755, 0x8a81 },
	{ 0x4756, 0x8a74 },
	{ 0x4757, 0x8a7a },
	{ 0x4758, 0x8c3c },
	{ 0x4759, 0x8c4b },
	{ 0x475a, 0x8c4a },
	{ 0x475b, 0x8c65 },
	{ 0x475c, 0x8c64 },
	{ 0x475d, 0x8c66 },
	{ 0x475e, 0x8c86 },
	{ 0x475f, 0x8c84 },
	{ 0x4760, 0x8c85 },
	{ 0x4761, 0x8ccc },
	{ 0x4762, 0x8d68 },
	{ 0x4763, 0x8d69 },
	{ 0x4764, 0x8d91 },
	{ 0x4765, 0x8d8c },
	{ 0x4766, 0x8d8e },
	{ 0x4767, 0x8d8f },
	{ 0x4768, 0x8d8d },
	{ 0x4769, 0x8d93 },
	{ 0x476a, 0x8d94 },
	{ 0x476b, 0x8d90 },
	{ 0x476c, 0x8d92 },
	{ 0x476d, 0x8df0 },
	{ 0x476e, 0x8de0 },
	{ 0x476f, 0x8dec },
	{ 0x4770, 0x8df1 },
	{ 0x4771, 0x8dee },
	{ 0x4772, 0x8dd0 },
	{ 0x4773, 0x8de9 },
	{ 0x4774, 0x8de3 },
	{ 0x4775, 0x8de2 },
	{ 0x4776, 0x8de7 },
	{ 0x4777, 0x8df2 },
	{ 0x4778, 0x8deb },
	{ 0x4779, 0x8df4 },
	{ 0x477a, 0x8f06 },
	{ 0x477b, 0x8eff },
	{ 0x477c, 0x8f01 },
	{ 0x477d, 0x8f00 },
	{ 0x477e, 0x8f05 },
	{ 0x4821, 0x8f07 },
	{ 0x4822, 0x8f08 },
	{ 0x4823, 0x8f02 },
	{ 0x4824, 0x8f0b },
	{ 0x4825, 0x9052 },
	{ 0x4826, 0x903f },
	{ 0x4827, 0x9044 },
	{ 0x4828, 0x9049 },
	{ 0x4829, 0x903d },
	{ 0x482a, 0x9110 },
	{ 0x482b, 0x910d },
	{ 0x482c, 0x910f },
	{ 0x482d, 0x9111 },
	{ 0x482e, 0x9116 },
	{ 0x482f, 0x9114 },
	{ 0x4830, 0x910b },
	{ 0x4831, 0x910e },
	{ 0x4832, 0x916e },
	{ 0x4833, 0x916f },
	{ 0x4834, 0x9248 },
	{ 0x4835, 0x9252 },
	{ 0x4836, 0x9230 },
	{ 0x4837, 0x923a },
	{ 0x4838, 0x9266 },
	{ 0x4839, 0x9233 },
	{ 0x483a, 0x9265 },
	{ 0x483b, 0x925e },
	{ 0x483c, 0x9283 },
	{ 0x483d, 0x922e },
	{ 0x483e, 0x924a },
	{ 0x483f, 0x9246 },
	{ 0x4840, 0x926d },
	{ 0x4841, 0x926c },
	{ 0x4842, 0x924f },
	{ 0x4843, 0x9260 },
	{ 0x4844, 0x9267 },
	{ 0x4845, 0x926f },
	{ 0x4846, 0x9236 },
	{ 0x4847, 0x9261 },
	{ 0x4848, 0x9270 },
	{ 0x4849, 0x9231 },
	{ 0x484a, 0x9254 },
	{ 0x484b, 0x9263 },
	{ 0x484c, 0x9250 },
	{ 0x484d, 0x9272 },
	{ 0x484e, 0x924e },
	{ 0x484f, 0x9253 },
	{ 0x4850, 0x924c },
	{ 0x4851, 0x9256 },
	{ 0x4852, 0x9232 },
	{ 0x4853, 0x959f },
	{ 0x4854, 0x959c },
	{ 0x4855, 0x959e },
	{ 0x4856, 0x959b },
	{ 0x4857, 0x9692 },
	{ 0x4858, 0x9693 },
	{ 0x4859, 0x9691 },
	{ 0x485a, 0x9697 },
	{ 0x485b, 0x96ce },
	{ 0x485c, 0x96fa },
	{ 0x485d, 0x96fd },
	{ 0x485e, 0x96f8 },
	{ 0x485f, 0x96f5 },
	{ 0x4860, 0x9773 },
	{ 0x4861, 0x9777 },
	{ 0x4862, 0x9778 },
	{ 0x4863, 0x9772 },
	{ 0x4864, 0x980f },
	{ 0x4865, 0x980d },
	{ 0x4866, 0x980e },
	{ 0x4867, 0x98ac },
	{ 0x4868, 0x98f6 },
	{ 0x4869, 0x98f9 },
	{ 0x486a, 0x99af },
	{ 0x486b, 0x99b2 },
	{ 0x486c, 0x99b0 },
	{ 0x486d, 0x99b5 },
	{ 0x486e, 0x9aad },
	{ 0x486f, 0x9aab },
	{ 0x4870, 0x9b5b },
	{ 0x4871, 0x9cea },
	{ 0x4872, 0x9ced },
	{ 0x4873, 0x9ce7 },
	{ 0x4874, 0x9e80 },
	{ 0x4875, 0x9efd },
	{ 0x4876, 0x50e6 },
	{ 0x4877, 0x50d4 },
	{ 0x4878, 0x50d7 },
	{ 0x4879, 0x50e8 },
	{ 0x487a, 0x50f3 },
	{ 0x487b, 0x50db },
	{ 0x487c, 0x50ea },
	{ 0x487d, 0x50dd },
	{ 0x487e, 0x50e4 },
	{ 0x4921, 0x50d3 },
	{ 0x4922, 0x50ec },
	{ 0x4923, 0x50f0 },
	{ 0x4924, 0x50ef },
	{ 0x4925, 0x50e3 },
	{ 0x4926, 0x50e0 },
	{ 0x4927, 0x51d8 },
	{ 0x4928, 0x5280 },
	{ 0x4929, 0x5281 },
	{ 0x492a, 0x52e9 },
	{ 0x492b, 0x52eb },
	{ 0x492c, 0x5330 },
	{ 0x492d, 0x53ac },
	{ 0x492e, 0x5627 },
	{ 0x492f, 0x5615 },
	{ 0x4930, 0x560c },
	{ 0x4931, 0x5612 },
	{ 0x4932, 0x55fc },
	{ 0x4933, 0x560f },
	{ 0x4934, 0x561c },
	{ 0x4935, 0x5601 },
	{ 0x4936, 0x5613 },
	{ 0x4937, 0x5602 },
	{ 0x4938, 0x55fa },
	{ 0x4939, 0x561d },
	{ 0x493a, 0x5604 },
	{ 0x493b, 0x55ff },
	{ 0x493c, 0x55f9 },
	{ 0x493d, 0x5889 },
	{ 0x493e, 0x587c },
	{ 0x493f, 0x5890 },
	{ 0x4940, 0x5898 },
	{ 0x4941, 0x5886 },
	{ 0x4942, 0x5881 },
	{ 0x4943, 0x587f },
	{ 0x4944, 0x5874 },
	{ 0x4945, 0x588b },
	{ 0x4946, 0x587a },
	{ 0x4947, 0x5887 },
	{ 0x4948, 0x5891 },
	{ 0x4949, 0x588e },
	{ 0x494a, 0x5876 },
	{ 0x494b, 0x5882 },
	{ 0x494c, 0x5888 },
	{ 0x494d, 0x587b },
	{ 0x494e, 0x5894 },
	{ 0x494f, 0x588f },
	{ 0x4950, 0x58fe },
	{ 0x4951, 0x596b },
	{ 0x4952, 0x5adc },
	{ 0x4953, 0x5aee },
	{ 0x4954, 0x5ae5 },
	{ 0x4955, 0x5ad5 },
	{ 0x4956, 0x5aea },
	{ 0x4957, 0x5ada },
	{ 0x4958, 0x5aed },
	{ 0x4959, 0x5aeb },
	{ 0x495a, 0x5af3 },
	{ 0x495b, 0x5ae2 },
	{ 0x495c, 0x5ae0 },
	{ 0x495d, 0x5adb },
	{ 0x495e, 0x5aec },
	{ 0x495f, 0x5ade },
	{ 0x4960, 0x5add },
	{ 0x4961, 0x5ad9 },
	{ 0x4962, 0x5ae8 },
	{ 0x4963, 0x5adf },
	{ 0x4964, 0x5b77 },
	{ 0x4965, 0x5be0 },
	{ 0x4966, 0x5be3 },
	{ 0x4967, 0x5c63 },
	{ 0x4968, 0x5d82 },
	{ 0x4969, 0x5d80 },
	{ 0x496a, 0x5d7d },
	{ 0x496b, 0x5d86 },
	{ 0x496c, 0x5d7a },
	{ 0x496d, 0x5d81 },
	{ 0x496e, 0x5d77 },
	{ 0x496f, 0x5d8a },
	{ 0x4970, 0x5d89 },
	{ 0x4971, 0x5d88 },
	{ 0x4972, 0x5d7e },
	{ 0x4973, 0x5d7c },
	{ 0x4974, 0x5d8d },
	{ 0x4975, 0x5d79 },
	{ 0x4976, 0x5d7f },
	{ 0x4977, 0x5e58 },
	{ 0x4978, 0x5e59 },
	{ 0x4979, 0x5e53 },
	{ 0x497a, 0x5ed8 },
	{ 0x497b, 0x5ed1 },
	{ 0x497c, 0x5ed7 },
	{ 0x497d, 0x5ece },
	{ 0x497e, 0x5edc },
	{ 0x4a21, 0x5ed5 },
	{ 0x4a22, 0x5ed9 },
	{ 0x4a23, 0x5ed2 },
	{ 0x4a24, 0x5ed4 },
	{ 0x4a25, 0x5f44 },
	{ 0x4a26, 0x5f43 },
	{ 0x4a27, 0x5f6f },
	{ 0x4a28, 0x5fb6 },
	{ 0x4a29, 0x612c },
	{ 0x4a2a, 0x6128 },
	{ 0x4a2b, 0x6141 },
	{ 0x4a2c, 0x615e },
	{ 0x4a2d, 0x6171 },
	{ 0x4a2e, 0x6173 },
	{ 0x4a2f, 0x6152 },
	{ 0x4a30, 0x6153 },
	{ 0x4a31, 0x6172 },
	{ 0x4a32, 0x616c },
	{ 0x4a33, 0x6180 },
	{ 0x4a34, 0x6174 },
	{ 0x4a35, 0x6154 },
	{ 0x4a36, 0x617a },
	{ 0x4a37, 0x615b },
	{ 0x4a38, 0x6165 },
	{ 0x4a39, 0x613b },
	{ 0x4a3a, 0x616a },
	{ 0x4a3b, 0x6161 },
	{ 0x4a3c, 0x6156 },
	{ 0x4a3d, 0x6229 },
	{ 0x4a3e, 0x6227 },
	{ 0x4a3f, 0x622b },
	{ 0x4a40, 0x642b },
	{ 0x4a41, 0x644d },
	{ 0x4a42, 0x645b },
	{ 0x4a43, 0x645d },
	{ 0x4a44, 0x6474 },
	{ 0x4a45, 0x6476 },
	{ 0x4a46, 0x6472 },
	{ 0x4a47, 0x6473 },
	{ 0x4a48, 0x647d },
	{ 0x4a49, 0x6475 },
	{ 0x4a4a, 0x6466 },
	{ 0x4a4b, 0x64a6 },
	{ 0x4a4c, 0x644e },
	{ 0x4a4d, 0x6482 },
	{ 0x4a4e, 0x645e },
	{ 0x4a4f, 0x645c },
	{ 0x4a50, 0x644b },
	{ 0x4a51, 0x6453 },
	{ 0x4a52, 0x6460 },
	{ 0x4a53, 0x6450 },
	{ 0x4a54, 0x647f },
	{ 0x4a55, 0x643f },
	{ 0x4a56, 0x646c },
	{ 0x4a57, 0x646b },
	{ 0x4a58, 0x6459 },
	{ 0x4a59, 0x6465 },
	{ 0x4a5a, 0x6477 },
	{ 0x4a5b, 0x6573 },
	{ 0x4a5c, 0x65a0 },
	{ 0x4a5d, 0x66a1 },
	{ 0x4a5e, 0x66a0 },
	{ 0x4a5f, 0x669f },
	{ 0x4a60, 0x6705 },
	{ 0x4a61, 0x6704 },
	{ 0x4a62, 0x6722 },
	{ 0x4a63, 0x69b1 },
	{ 0x4a64, 0x69b6 },
	{ 0x4a65, 0x69c9 },
	{ 0x4a66, 0x69a0 },
	{ 0x4a67, 0x69ce },
	{ 0x4a68, 0x6996 },
	{ 0x4a69, 0x69b0 },
	{ 0x4a6a, 0x69ac },
	{ 0x4a6b, 0x69bc },
	{ 0x4a6c, 0x6991 },
	{ 0x4a6d, 0x6999 },
	{ 0x4a6e, 0x698e },
	{ 0x4a6f, 0x69a7 },
	{ 0x4a70, 0x698d },
	{ 0x4a71, 0x69a9 },
	{ 0x4a72, 0x69be },
	{ 0x4a73, 0x69af },
	{ 0x4a74, 0x69bf },
	{ 0x4a75, 0x69c4 },
	{ 0x4a76, 0x69bd },
	{ 0x4a77, 0x69a4 },
	{ 0x4a78, 0x69d4 },
	{ 0x4a79, 0x69b9 },
	{ 0x4a7a, 0x69ca },
	{ 0x4a7b, 0x699a },
	{ 0x4a7c, 0x69cf },
	{ 0x4a7d, 0x69b3 },
	{ 0x4a7e, 0x6993 },
	{ 0x4b21, 0x69aa },
	{ 0x4b22, 0x69a1 },
	{ 0x4b23, 0x699e },
	{ 0x4b24, 0x69d9 },
	{ 0x4b25, 0x6997 },
	{ 0x4b26, 0x6990 },
	{ 0x4b27, 0x69c2 },
	{ 0x4b28, 0x69b5 },
	{ 0x4b29, 0x69a5 },
	{ 0x4b2a, 0x69c6 },
	{ 0x4b2b, 0x6b4a },
	{ 0x4b2c, 0x6b4d },
	{ 0x4b2d, 0x6b4b },
	{ 0x4b2e, 0x6b9e },
	{ 0x4b2f, 0x6b9f },
	{ 0x4b30, 0x6ba0 },
	{ 0x4b31, 0x6bc3 },
	{ 0x4b32, 0x6bc4 },
	{ 0x4b33, 0x6bfe },
	{ 0x4b34, 0x6ece },
	{ 0x4b35, 0x6ef5 },
	{ 0x4b36, 0x6ef1 },
	{ 0x4b37, 0x6f03 },
	{ 0x4b38, 0x6f25 },
	{ 0x4b39, 0x6ef8 },
	{ 0x4b3a, 0x6f37 },
	{ 0x4b3b, 0x6efb },
	{ 0x4b3c, 0x6f2e },
	{ 0x4b3d, 0x6f09 },
	{ 0x4b3e, 0x6f4e },
	{ 0x4b3f, 0x6f19 },
	{ 0x4b40, 0x6f1a },
	{ 0x4b41, 0x6f27 },
	{ 0x4b42, 0x6f18 },
	{ 0x4b43, 0x6f3b },
	{ 0x4b44, 0x6f12 },
	{ 0x4b45, 0x6eed },
	{ 0x4b46, 0x6f0a },
	{ 0x4b47, 0x6f36 },
	{ 0x4b48, 0x6f73 },
	{ 0x4b49, 0x6ef9 },
	{ 0x4b4a, 0x6eee },
	{ 0x4b4b, 0x6f2d },
	{ 0x4b4c, 0x6f40 },
	{ 0x4b4d, 0x6f30 },
	{ 0x4b4e, 0x6f3c },
	{ 0x4b4f, 0x6f35 },
	{ 0x4b50, 0x6eeb },
	{ 0x4b51, 0x6f07 },
	{ 0x4b52, 0x6f0e },
	{ 0x4b53, 0x6f43 },
	{ 0x4b54, 0x6f05 },
	{ 0x4b55, 0x6efd },
	{ 0x4b56, 0x6ef6 },
	{ 0x4b57, 0x6f39 },
	{ 0x4b58, 0x6f1c },
	{ 0x4b59, 0x6efc },
	{ 0x4b5a, 0x6f3a },
	{ 0x4b5b, 0x6f1f },
	{ 0x4b5c, 0x6f0d },
	{ 0x4b5d, 0x6f1e },
	{ 0x4b5e, 0x6f08 },
	{ 0x4b5f, 0x6f21 },
	{ 0x4b60, 0x7187 },
	{ 0x4b61, 0x7190 },
	{ 0x4b62, 0x7189 },
	{ 0x4b63, 0x7180 },
	{ 0x4b64, 0x7185 },
	{ 0x4b65, 0x7182 },
	{ 0x4b66, 0x718f },
	{ 0x4b67, 0x717b },
	{ 0x4b68, 0x7186 },
	{ 0x4b69, 0x7181 },
	{ 0x4b6a, 0x7197 },
	{ 0x4b6b, 0x7244 },
	{ 0x4b6c, 0x7253 },
	{ 0x4b6d, 0x7297 },
	{ 0x4b6e, 0x7295 },
	{ 0x4b6f, 0x7293 },
	{ 0x4b70, 0x7343 },
	{ 0x4b71, 0x734d },
	{ 0x4b72, 0x7351 },
	{ 0x4b73, 0x734c },
	{ 0x4b74, 0x7462 },
	{ 0x4b75, 0x7473 },
	{ 0x4b76, 0x7471 },
	{ 0x4b77, 0x7475 },
	{ 0x4b78, 0x7472 },
	{ 0x4b79, 0x7467 },
	{ 0x4b7a, 0x746e },
	{ 0x4b7b, 0x7500 },
	{ 0x4b7c, 0x7502 },
	{ 0x4b7d, 0x7503 },
	{ 0x4b7e, 0x757d },
	{ 0x4c21, 0x7590 },
	{ 0x4c22, 0x7616 },
	{ 0x4c23, 0x7608 },
	{ 0x4c24, 0x760c },
	{ 0x4c25, 0x7615 },
	{ 0x4c26, 0x7611 },
	{ 0x4c27, 0x760a },
	{ 0x4c28, 0x7614 },
	{ 0x4c29, 0x76b8 },
	{ 0x4c2a, 0x7781 },
	{ 0x4c2b, 0x777c },
	{ 0x4c2c, 0x7785 },
	{ 0x4c2d, 0x7782 },
	{ 0x4c2e, 0x776e },
	{ 0x4c2f, 0x7780 },
	{ 0x4c30, 0x776f },
	{ 0x4c31, 0x777e },
	{ 0x4c32, 0x7783 },
	{ 0x4c33, 0x78b2 },
	{ 0x4c34, 0x78aa },
	{ 0x4c35, 0x78b4 },
	{ 0x4c36, 0x78ad },
	{ 0x4c37, 0x78a8 },
	{ 0x4c38, 0x787e },
	{ 0x4c39, 0x78ab },
	{ 0x4c3a, 0x789e },
	{ 0x4c3b, 0x78a5 },
	{ 0x4c3c, 0x78a0 },
	{ 0x4c3d, 0x78ac },
	{ 0x4c3e, 0x78a2 },
	{ 0x4c3f, 0x78a4 },
	{ 0x4c40, 0x7998 },
	{ 0x4c41, 0x798a },
	{ 0x4c42, 0x798b },
	{ 0x4c43, 0x7996 },
	{ 0x4c44, 0x7995 },
	{ 0x4c45, 0x7994 },
	{ 0x4c46, 0x7993 },
	{ 0x4c47, 0x7997 },
	{ 0x4c48, 0x7988 },
	{ 0x4c49, 0x7992 },
	{ 0x4c4a, 0x7990 },
	{ 0x4c4b, 0x7a2b },
	{ 0x4c4c, 0x7a4a },
	{ 0x4c4d, 0x7a30 },
	{ 0x4c4e, 0x7a2f },
	{ 0x4c4f, 0x7a28 },
	{ 0x4c50, 0x7a26 },
	{ 0x4c51, 0x7aa8 },
	{ 0x4c52, 0x7aab },
	{ 0x4c53, 0x7aac },
	{ 0x4c54, 0x7aee },
	{ 0x4c55, 0x7b88 },
	{ 0x4c56, 0x7b9c },
	{ 0x4c57, 0x7b8a },
	{ 0x4c58, 0x7b91 },
	{ 0x4c59, 0x7b90 },
	{ 0x4c5a, 0x7b96 },
	{ 0x4c5b, 0x7b8d },
	{ 0x4c5c, 0x7b8c },
	{ 0x4c5d, 0x7b9b },
	{ 0x4c5e, 0x7b8e },
	{ 0x4c5f, 0x7b85 },
	{ 0x4c60, 0x7b98 },
	{ 0x4c61, 0x5284 },
	{ 0x4c62, 0x7b99 },
	{ 0x4c63, 0x7ba4 },
	{ 0x4c64, 0x7b82 },
	{ 0x4c65, 0x7cbb },
	{ 0x4c66, 0x7cbf },
	{ 0x4c67, 0x7cbc },
	{ 0x4c68, 0x7cba },
	{ 0x4c69, 0x7da7 },
	{ 0x4c6a, 0x7db7 },
	{ 0x4c6b, 0x7dc2 },
	{ 0x4c6c, 0x7da3 },
	{ 0x4c6d, 0x7daa },
	{ 0x4c6e, 0x7dc1 },
	{ 0x4c6f, 0x7dc0 },
	{ 0x4c70, 0x7dc5 },
	{ 0x4c71, 0x7d9d },
	{ 0x4c72, 0x7dce },
	{ 0x4c73, 0x7dc4 },
	{ 0x4c74, 0x7dc6 },
	{ 0x4c75, 0x7dcb },
	{ 0x4c76, 0x7dcc },
	{ 0x4c77, 0x7daf },
	{ 0x4c78, 0x7db9 },
	{ 0x4c79, 0x7d96 },
	{ 0x4c7a, 0x7dbc },
	{ 0x4c7b, 0x7d9f },
	{ 0x4c7c, 0x7da6 },
	{ 0x4c7d, 0x7dae },
	{ 0x4c7e, 0x7da9 },
	{ 0x4d21, 0x7da1 },
	{ 0x4d22, 0x7dc9 },
	{ 0x4d23, 0x7f73 },
	{ 0x4d24, 0x7fe2 },
	{ 0x4d25, 0x7fe3 },
	{ 0x4d26, 0x7fe5 },
	{ 0x4d27, 0x7fde },
	{ 0x4d28, 0x8024 },
	{ 0x4d29, 0x805d },
	{ 0x4d2a, 0x805c },
	{ 0x4d2b, 0x8189 },
	{ 0x4d2c, 0x8186 },
	{ 0x4d2d, 0x8183 },
	{ 0x4d2e, 0x8187 },
	{ 0x4d2f, 0x818d },
	{ 0x4d30, 0x818c },
	{ 0x4d31, 0x818b },
	{ 0x4d32, 0x8215 },
	{ 0x4d33, 0x8497 },
	{ 0x4d34, 0x84a4 },
	{ 0x4d35, 0x84a1 },
	{ 0x4d36, 0x849f },
	{ 0x4d37, 0x84ba },
	{ 0x4d38, 0x84ce },
	{ 0x4d39, 0x84c2 },
	{ 0x4d3a, 0x84ac },
	{ 0x4d3b, 0x84ae },
	{ 0x4d3c, 0x84ab },
	{ 0x4d3d, 0x84b9 },
	{ 0x4d3e, 0x84b4 },
	{ 0x4d3f, 0x84c1 },
	{ 0x4d40, 0x84cd },
	{ 0x4d41, 0x84aa },
	{ 0x4d42, 0x849a },
	{ 0x4d43, 0x84b1 },
	{ 0x4d44, 0x84d0 },
	{ 0x4d45, 0x849d },
	{ 0x4d46, 0x84a7 },
	{ 0x4d47, 0x84bb },
	{ 0x4d48, 0x84a2 },
	{ 0x4d49, 0x8494 },
	{ 0x4d4a, 0x84c7 },
	{ 0x4d4b, 0x84cc },
	{ 0x4d4c, 0x849b },
	{ 0x4d4d, 0x84a9 },
	{ 0x4d4e, 0x84af },
	{ 0x4d4f, 0x84a8 },
	{ 0x4d50, 0x84d6 },
	{ 0x4d51, 0x8498 },
	{ 0x4d52, 0x84b6 },
	{ 0x4d53, 0x84cf },
	{ 0x4d54, 0x84a0 },
	{ 0x4d55, 0x84d7 },
	{ 0x4d56, 0x84d4 },
	{ 0x4d57, 0x84d2 },
	{ 0x4d58, 0x84db },
	{ 0x4d59, 0x84b0 },
	{ 0x4d5a, 0x8491 },
	{ 0x4d5b, 0x8661 },
	{ 0x4d5c, 0x8733 },
	{ 0x4d5d, 0x8723 },
	{ 0x4d5e, 0x8728 },
	{ 0x4d5f, 0x876b },
	{ 0x4d60, 0x8740 },
	{ 0x4d61, 0x872e },
	{ 0x4d62, 0x871e },
	{ 0x4d63, 0x8721 },
	{ 0x4d64, 0x8719 },
	{ 0x4d65, 0x871b },
	{ 0x4d66, 0x8743 },
	{ 0x4d67, 0x872c },
	{ 0x4d68, 0x8741 },
	{ 0x4d69, 0x873e },
	{ 0x4d6a, 0x8746 },
	{ 0x4d6b, 0x8720 },
	{ 0x4d6c, 0x8732 },
	{ 0x4d6d, 0x872a },
	{ 0x4d6e, 0x872d },
	{ 0x4d6f, 0x873c },
	{ 0x4d70, 0x8712 },
	{ 0x4d71, 0x873a },
	{ 0x4d72, 0x8731 },
	{ 0x4d73, 0x8735 },
	{ 0x4d74, 0x8742 },
	{ 0x4d75, 0x8726 },
	{ 0x4d76, 0x8727 },
	{ 0x4d77, 0x8738 },
	{ 0x4d78, 0x8724 },
	{ 0x4d79, 0x871a },
	{ 0x4d7a, 0x8730 },
	{ 0x4d7b, 0x8711 },
	{ 0x4d7c, 0x88f7 },
	{ 0x4d7d, 0x88e7 },
	{ 0x4d7e, 0x88f1 },
	{ 0x4e21, 0x88f2 },
	{ 0x4e22, 0x88fa },
	{ 0x4e23, 0x88fe },
	{ 0x4e24, 0x88ee },
	{ 0x4e25, 0x88fc },
	{ 0x4e26, 0x88f6 },
	{ 0x4e27, 0x88fb },
	{ 0x4e28, 0x88f0 },
	{ 0x4e29, 0x88ec },
	{ 0x4e2a, 0x88eb },
	{ 0x4e2b, 0x899d },
	{ 0x4e2c, 0x89a1 },
	{ 0x4e2d, 0x899f },
	{ 0x4e2e, 0x899e },
	{ 0x4e2f, 0x89e9 },
	{ 0x4e30, 0x89eb },
	{ 0x4e31, 0x89e8 },
	{ 0x4e32, 0x8aab },
	{ 0x4e33, 0x8a99 },
	{ 0x4e34, 0x8a8b },
	{ 0x4e35, 0x8a92 },
	{ 0x4e36, 0x8a8f },
	{ 0x4e37, 0x8a96 },
	{ 0x4e38, 0x8c3d },
	{ 0x4e39, 0x8c68 },
	{ 0x4e3a, 0x8c69 },
	{ 0x4e3b, 0x8cd5 },
	{ 0x4e3c, 0x8ccf },
	{ 0x4e3d, 0x8cd7 },
	{ 0x4e3e, 0x8d96 },
	{ 0x4e3f, 0x8e09 },
	{ 0x4e40, 0x8e02 },
	{ 0x4e41, 0x8dff },
	{ 0x4e42, 0x8e0d },
	{ 0x4e43, 0x8dfd },
	{ 0x4e44, 0x8e0a },
	{ 0x4e45, 0x8e03 },
	{ 0x4e46, 0x8e07 },
	{ 0x4e47, 0x8e06 },
	{ 0x4e48, 0x8e05 },
	{ 0x4e49, 0x8dfe },
	{ 0x4e4a, 0x8e00 },
	{ 0x4e4b, 0x8e04 },
	{ 0x4e4c, 0x8f10 },
	{ 0x4e4d, 0x8f11 },
	{ 0x4e4e, 0x8f0e },
	{ 0x4e4f, 0x8f0d },
	{ 0x4e50, 0x9123 },
	{ 0x4e51, 0x911c },
	{ 0x4e52, 0x9120 },
	{ 0x4e53, 0x9122 },
	{ 0x4e54, 0x911f },
	{ 0x4e55, 0x911d },
	{ 0x4e56, 0x911a },
	{ 0x4e57, 0x9124 },
	{ 0x4e58, 0x9121 },
	{ 0x4e59, 0x911b },
	{ 0x4e5a, 0x917a },
	{ 0x4e5b, 0x9172 },
	{ 0x4e5c, 0x9179 },
	{ 0x4e5d, 0x9173 },
	{ 0x4e5e, 0x92a5 },
	{ 0x4e5f, 0x92a4 },
	{ 0x4e60, 0x9276 },
	{ 0x4e61, 0x929b },
	{ 0x4e62, 0x927a },
	{ 0x4e63, 0x92a0 },
	{ 0x4e64, 0x9294 },
	{ 0x4e65, 0x92aa },
	{ 0x4e66, 0x928d },
	{ 0x4e67, 0x92a6 },
	{ 0x4e68, 0x929a },
	{ 0x4e69, 0x92ab },
	{ 0x4e6a, 0x9279 },
	{ 0x4e6b, 0x9297 },
	{ 0x4e6c, 0x927f },
	{ 0x4e6d, 0x92a3 },
	{ 0x4e6e, 0x92ee },
	{ 0x4e6f, 0x928e },
	{ 0x4e70, 0x9282 },
	{ 0x4e71, 0x9295 },
	{ 0x4e72, 0x92a2 },
	{ 0x4e73, 0x927d },
	{ 0x4e74, 0x9288 },
	{ 0x4e75, 0x92a1 },
	{ 0x4e76, 0x928a },
	{ 0x4e77, 0x9286 },
	{ 0x4e78, 0x928c },
	{ 0x4e79, 0x9299 },
	{ 0x4e7a, 0x92a7 },
	{ 0x4e7b, 0x927e },
	{ 0x4e7c, 0x9287 },
	{ 0x4e7d, 0x92a9 },
	{ 0x4e7e, 0x929d },
	{ 0x4f21, 0x928b },
	{ 0x4f22, 0x922d },
	{ 0x4f23, 0x969e },
	{ 0x4f24, 0x96a1 },
	{ 0x4f25, 0x96ff },
	{ 0x4f26, 0x9758 },
	{ 0x4f27, 0x977d },
	{ 0x4f28, 0x977a },
	{ 0x4f29, 0x977e },
	{ 0x4f2a, 0x9783 },
	{ 0x4f2b, 0x9780 },
	{ 0x4f2c, 0x9782 },
	{ 0x4f2d, 0x977b },
	{ 0x4f2e, 0x9784 },
	{ 0x4f2f, 0x9781 },
	{ 0x4f30, 0x977f },
	{ 0x4f31, 0x97ce },
	{ 0x4f32, 0x97cd },
	{ 0x4f33, 0x9816 },
	{ 0x4f34, 0x98ad },
	{ 0x4f35, 0x98ae },
	{ 0x4f36, 0x9902 },
	{ 0x4f37, 0x9900 },
	{ 0x4f38, 0x9907 },
	{ 0x4f39, 0x999d },
	{ 0x4f3a, 0x999c },
	{ 0x4f3b, 0x99c3 },
	{ 0x4f3c, 0x99b9 },
	{ 0x4f3d, 0x99bb },
	{ 0x4f3e, 0x99ba },
	{ 0x4f3f, 0x99c2 },
	{ 0x4f40, 0x99bd },
	{ 0x4f41, 0x99c7 },
	{ 0x4f42, 0x9ab1 },
	{ 0x4f43, 0x9ae3 },
	{ 0x4f44, 0x9ae7 },
	{ 0x4f45, 0x9b3e },
	{ 0x4f46, 0x9b3f },
	{ 0x4f47, 0x9b60 },
	{ 0x4f48, 0x9b61 },
	{ 0x4f49, 0x9b5f },
	{ 0x4f4a, 0x9cf1 },
	{ 0x4f4b, 0x9cf2 },
	{ 0x4f4c, 0x9cf5 },
	{ 0x4f4d, 0x9ea7 },
	{ 0x4f4e, 0x50ff },
	{ 0x4f4f, 0x5103 },
	{ 0x4f50, 0x5130 },
	{ 0x4f51, 0x50f8 },
	{ 0x4f52, 0x5106 },
	{ 0x4f53, 0x5107 },
	{ 0x4f54, 0x50f6 },
	{ 0x4f55, 0x50fe },
	{ 0x4f56, 0x510b },
	{ 0x4f57, 0x510c },
	{ 0x4f58, 0x50fd },
	{ 0x4f59, 0x510a },
	{ 0x4f5a, 0x528b },
	{ 0x4f5b, 0x528c },
	{ 0x4f5c, 0x52f1 },
	{ 0x4f5d, 0x52ef },
	{ 0x4f5e, 0x5648 },
	{ 0x4f5f, 0x5642 },
	{ 0x4f60, 0x564c },
	{ 0x4f61, 0x5635 },
	{ 0x4f62, 0x5641 },
	{ 0x4f63, 0x564a },
	{ 0x4f64, 0x5649 },
	{ 0x4f65, 0x5646 },
	{ 0x4f66, 0x5658 },
	{ 0x4f67, 0x565a },
	{ 0x4f68, 0x5640 },
	{ 0x4f69, 0x5633 },
	{ 0x4f6a, 0x563d },
	{ 0x4f6b, 0x562c },
	{ 0x4f6c, 0x563e },
	{ 0x4f6d, 0x5638 },
	{ 0x4f6e, 0x562a },
	{ 0x4f6f, 0x563a },
	{ 0x4f70, 0x571a },
	{ 0x4f71, 0x58ab },
	{ 0x4f72, 0x589d },
	{ 0x4f73, 0x58b1 },
	{ 0x4f74, 0x58a0 },
	{ 0x4f75, 0x58a3 },
	{ 0x4f76, 0x58af },
	{ 0x4f77, 0x58ac },
	{ 0x4f78, 0x58a5 },
	{ 0x4f79, 0x58a1 },
	{ 0x4f7a, 0x58ff },
	{ 0x4f7b, 0x5aff },
	{ 0x4f7c, 0x5af4 },
	{ 0x4f7d, 0x5afd },
	{ 0x4f7e, 0x5af7 },
	{ 0x5021, 0x5af6 },
	{ 0x5022, 0x5b03 },
	{ 0x5023, 0x5af8 },
	{ 0x5024, 0x5b02 },
	{ 0x5025, 0x5af9 },
	{ 0x5026, 0x5b01 },
	{ 0x5027, 0x5b07 },
	{ 0x5028, 0x5b05 },
	{ 0x5029, 0x5b0f },
	{ 0x502a, 0x5c67 },
	{ 0x502b, 0x5d99 },
	{ 0x502c, 0x5d97 },
	{ 0x502d, 0x5d9f },
	{ 0x502e, 0x5d92 },
	{ 0x502f, 0x5da2 },
	{ 0x5030, 0x5d93 },
	{ 0x5031, 0x5d95 },
	{ 0x5032, 0x5da0 },
	{ 0x5033, 0x5d9c },
	{ 0x5034, 0x5da1 },
	{ 0x5035, 0x5d9a },
	{ 0x5036, 0x5d9e },
	{ 0x5037, 0x5e69 },
	{ 0x5038, 0x5e5d },
	{ 0x5039, 0x5e60 },
	{ 0x503a, 0x5e5c },
	{ 0x503b, 0x7df3 },
	{ 0x503c, 0x5edb },
	{ 0x503d, 0x5ede },
	{ 0x503e, 0x5ee1 },
	{ 0x503f, 0x5f49 },
	{ 0x5040, 0x5fb2 },
	{ 0x5041, 0x618b },
	{ 0x5042, 0x6183 },
	{ 0x5043, 0x6179 },
	{ 0x5044, 0x61b1 },
	{ 0x5045, 0x61b0 },
	{ 0x5046, 0x61a2 },
	{ 0x5047, 0x6189 },
	{ 0x5048, 0x619b },
	{ 0x5049, 0x6193 },
	{ 0x504a, 0x61af },
	{ 0x504b, 0x61ad },
	{ 0x504c, 0x619f },
	{ 0x504d, 0x6192 },
	{ 0x504e, 0x61aa },
	{ 0x504f, 0x61a1 },
	{ 0x5050, 0x618d },
	{ 0x5051, 0x6166 },
	{ 0x5052, 0x61b3 },
	{ 0x5053, 0x622d },
	{ 0x5054, 0x646e },
	{ 0x5055, 0x6470 },
	{ 0x5056, 0x6496 },
	{ 0x5057, 0x64a0 },
	{ 0x5058, 0x6485 },
	{ 0x5059, 0x6497 },
	{ 0x505a, 0x649c },
	{ 0x505b, 0x648f },
	{ 0x505c, 0x648b },
	{ 0x505d, 0x648a },
	{ 0x505e, 0x648c },
	{ 0x505f, 0x64a3 },
	{ 0x5060, 0x649f },
	{ 0x5061, 0x6468 },
	{ 0x5062, 0x64b1 },
	{ 0x5063, 0x6498 },
	{ 0x5064, 0x6576 },
	{ 0x5065, 0x657a },
	{ 0x5066, 0x6579 },
	{ 0x5067, 0x657b },
	{ 0x5068, 0x65b2 },
	{ 0x5069, 0x65b3 },
	{ 0x506a, 0x66b5 },
	{ 0x506b, 0x66b0 },
	{ 0x506c, 0x66a9 },
	{ 0x506d, 0x66b2 },
	{ 0x506e, 0x66b7 },
	{ 0x506f, 0x66aa },
	{ 0x5070, 0x66af },
	{ 0x5071, 0x6a00 },
	{ 0x5072, 0x6a06 },
	{ 0x5073, 0x6a17 },
	{ 0x5074, 0x69e5 },
	{ 0x5075, 0x69f8 },
	{ 0x5076, 0x6a15 },
	{ 0x5077, 0x69f1 },
	{ 0x5078, 0x69e4 },
	{ 0x5079, 0x6a20 },
	{ 0x507a, 0x69ff },
	{ 0x507b, 0x69ec },
	{ 0x507c, 0x69e2 },
	{ 0x507d, 0x6a1b },
	{ 0x507e, 0x6a1d },
	{ 0x5121, 0x69fe },
	{ 0x5122, 0x6a27 },
	{ 0x5123, 0x69f2 },
	{ 0x5124, 0x69ee },
	{ 0x5125, 0x6a14 },
	{ 0x5126, 0x69f7 },
	{ 0x5127, 0x69e7 },
	{ 0x5128, 0x6a40 },
	{ 0x5129, 0x6a08 },
	{ 0x512a, 0x69e6 },
	{ 0x512b, 0x69fb },
	{ 0x512c, 0x6a0d },
	{ 0x512d, 0x69fc },
	{ 0x512e, 0x69eb },
	{ 0x512f, 0x6a09 },
	{ 0x5130, 0x6a04 },
	{ 0x5131, 0x6a18 },
	{ 0x5132, 0x6a25 },
	{ 0x5133, 0x6a0f },
	{ 0x5134, 0x69f6 },
	{ 0x5135, 0x6a26 },
	{ 0x5136, 0x6a07 },
	{ 0x5137, 0x69f4 },
	{ 0x5138, 0x6a16 },
	{ 0x5139, 0x6b51 },
	{ 0x513a, 0x6ba5 },
	{ 0x513b, 0x6ba3 },
	{ 0x513c, 0x6ba2 },
	{ 0x513d, 0x6ba6 },
	{ 0x513e, 0x6c01 },
	{ 0x513f, 0x6c00 },
	{ 0x5140, 0x6bff },
	{ 0x5141, 0x6c02 },
	{ 0x5142, 0x6f41 },
	{ 0x5143, 0x6f26 },
	{ 0x5144, 0x6f7e },
	{ 0x5145, 0x6f87 },
	{ 0x5146, 0x6fc6 },
	{ 0x5147, 0x6f92 },
	{ 0x5148, 0x6f8d },
	{ 0x5149, 0x6f89 },
	{ 0x514a, 0x6f8c },
	{ 0x514b, 0x6f62 },
	{ 0x514c, 0x6f4f },
	{ 0x514d, 0x6f85 },
	{ 0x514e, 0x6f5a },
	{ 0x514f, 0x6f96 },
	{ 0x5150, 0x6f76 },
	{ 0x5151, 0x6f6c },
	{ 0x5152, 0x6f82 },
	{ 0x5153, 0x6f55 },
	{ 0x5154, 0x6f72 },
	{ 0x5155, 0x6f52 },
	{ 0x5156, 0x6f50 },
	{ 0x5157, 0x6f57 },
	{ 0x5158, 0x6f94 },
	{ 0x5159, 0x6f93 },
	{ 0x515a, 0x6f5d },
	{ 0x515b, 0x6f00 },
	{ 0x515c, 0x6f61 },
	{ 0x515d, 0x6f6b },
	{ 0x515e, 0x6f7d },
	{ 0x515f, 0x6f67 },
	{ 0x5160, 0x6f90 },
	{ 0x5161, 0x6f53 },
	{ 0x5162, 0x6f8b },
	{ 0x5163, 0x6f69 },
	{ 0x5164, 0x6f7f },
	{ 0x5165, 0x6f95 },
	{ 0x5166, 0x6f63 },
	{ 0x5167, 0x6f77 },
	{ 0x5168, 0x6f6a },
	{ 0x5169, 0x6f7b },
	{ 0x516a, 0x71b2 },
	{ 0x516b, 0x71af },
	{ 0x516c, 0x719b },
	{ 0x516d, 0x71b0 },
	{ 0x516e, 0x71a0 },
	{ 0x516f, 0x719a },
	{ 0x5170, 0x71a9 },
	{ 0x5171, 0x71b5 },
	{ 0x5172, 0x719d },
	{ 0x5173, 0x71a5 },
	{ 0x5174, 0x719e },
	{ 0x5175, 0x71a4 },
	{ 0x5176, 0x71a1 },
	{ 0x5177, 0x71aa },
	{ 0x5178, 0x719c },
	{ 0x5179, 0x71a7 },
	{ 0x517a, 0x71b3 },
	{ 0x517b, 0x7298 },
	{ 0x517c, 0x729a },
	{ 0x517d, 0x7358 },
	{ 0x517e, 0x7352 },
	{ 0x5221, 0x735e },
	{ 0x5222, 0x735f },
	{ 0x5223, 0x7360 },
	{ 0x5224, 0x735d },
	{ 0x5225, 0x735b },
	{ 0x5226, 0x7361 },
	{ 0x5227, 0x735a },
	{ 0x5228, 0x7359 },
	{ 0x5229, 0x7362 },
	{ 0x522a, 0x7487 },
	{ 0x522b, 0x7489 },
	{ 0x522c, 0x748a },
	{ 0x522d, 0x7486 },
	{ 0x522e, 0x7481 },
	{ 0x522f, 0x747d },
	{ 0x5230, 0x7485 },
	{ 0x5231, 0x7488 },
	{ 0x5232, 0x747c },
	{ 0x5233, 0x7479 },
	{ 0x5234, 0x7508 },
	{ 0x5235, 0x7507 },
	{ 0x5236, 0x757e },
	{ 0x5237, 0x7625 },
	{ 0x5238, 0x761e },
	{ 0x5239, 0x7619 },
	{ 0x523a, 0x761d },
	{ 0x523b, 0x761c },
	{ 0x523c, 0x7623 },
	{ 0x523d, 0x761a },
	{ 0x523e, 0x7628 },
	{ 0x523f, 0x761b },
	{ 0x5240, 0x769c },
	{ 0x5241, 0x769d },
	{ 0x5242, 0x769e },
	{ 0x5243, 0x769b },
	{ 0x5244, 0x778d },
	{ 0x5245, 0x778f },
	{ 0x5246, 0x7789 },
	{ 0x5247, 0x7788 },
	{ 0x5248, 0x78cd },
	{ 0x5249, 0x78bb },
	{ 0x524a, 0x78cf },
	{ 0x524b, 0x78cc },
	{ 0x524c, 0x78d1 },
	{ 0x524d, 0x78ce },
	{ 0x524e, 0x78d4 },
	{ 0x524f, 0x78c8 },
	{ 0x5250, 0x78c3 },
	{ 0x5251, 0x78c4 },
	{ 0x5252, 0x78c9 },
	{ 0x5253, 0x799a },
	{ 0x5254, 0x79a1 },
	{ 0x5255, 0x79a0 },
	{ 0x5256, 0x799c },
	{ 0x5257, 0x79a2 },
	{ 0x5258, 0x799b },
	{ 0x5259, 0x6b76 },
	{ 0x525a, 0x7a39 },
	{ 0x525b, 0x7ab2 },
	{ 0x525c, 0x7ab4 },
	{ 0x525d, 0x7ab3 },
	{ 0x525e, 0x7bb7 },
	{ 0x525f, 0x7bcb },
	{ 0x5260, 0x7bbe },
	{ 0x5261, 0x7bac },
	{ 0x5262, 0x7bce },
	{ 0x5263, 0x7baf },
	{ 0x5264, 0x7bb9 },
	{ 0x5265, 0x7bca },
	{ 0x5266, 0x7bb5 },
	{ 0x5267, 0x7cc5 },
	{ 0x5268, 0x7cc8 },
	{ 0x5269, 0x7ccc },
	{ 0x526a, 0x7ccb },
	{ 0x526b, 0x7df7 },
	{ 0x526c, 0x7ddb },
	{ 0x526d, 0x7dea },
	{ 0x526e, 0x7de7 },
	{ 0x526f, 0x7dd7 },
	{ 0x5270, 0x7de1 },
	{ 0x5271, 0x7e03 },
	{ 0x5272, 0x7dfa },
	{ 0x5273, 0x7de6 },
	{ 0x5274, 0x7df6 },
	{ 0x5275, 0x7df1 },
	{ 0x5276, 0x7df0 },
	{ 0x5277, 0x7dee },
	{ 0x5278, 0x7ddf },
	{ 0x5279, 0x7f76 },
	{ 0x527a, 0x7fac },
	{ 0x527b, 0x7fb0 },
	{ 0x527c, 0x7fad },
	{ 0x527d, 0x7fed },
	{ 0x527e, 0x7feb },
	{ 0x5321, 0x7fea },
	{ 0x5322, 0x7fec },
	{ 0x5323, 0x7fe6 },
	{ 0x5324, 0x7fe8 },
	{ 0x5325, 0x8064 },
	{ 0x5326, 0x8067 },
	{ 0x5327, 0x81a3 },
	{ 0x5328, 0x819f },
	{ 0x5329, 0x819e },
	{ 0x532a, 0x8195 },
	{ 0x532b, 0x81a2 },
	{ 0x532c, 0x8199 },
	{ 0x532d, 0x8197 },
	{ 0x532e, 0x8216 },
	{ 0x532f, 0x824f },
	{ 0x5330, 0x8253 },
	{ 0x5331, 0x8252 },
	{ 0x5332, 0x8250 },
	{ 0x5333, 0x824e },
	{ 0x5334, 0x8251 },
	{ 0x5335, 0x8524 },
	{ 0x5336, 0x853b },
	{ 0x5337, 0x850f },
	{ 0x5338, 0x8500 },
	{ 0x5339, 0x8529 },
	{ 0x533a, 0x850e },
	{ 0x533b, 0x8509 },
	{ 0x533c, 0x850d },
	{ 0x533d, 0x851f },
	{ 0x533e, 0x850a },
	{ 0x533f, 0x8527 },
	{ 0x5340, 0x851c },
	{ 0x5341, 0x84fb },
	{ 0x5342, 0x852b },
	{ 0x5343, 0x84fa },
	{ 0x5344, 0x8508 },
	{ 0x5345, 0x850c },
	{ 0x5346, 0x84f4 },
	{ 0x5347, 0x852a },
	{ 0x5348, 0x84f2 },
	{ 0x5349, 0x8515 },
	{ 0x534a, 0x84f7 },
	{ 0x534b, 0x84eb },
	{ 0x534c, 0x84f3 },
	{ 0x534d, 0x84fc },
	{ 0x534e, 0x8512 },
	{ 0x534f, 0x84ea },
	{ 0x5350, 0x84e9 },
	{ 0x5351, 0x8516 },
	{ 0x5352, 0x84fe },
	{ 0x5353, 0x8528 },
	{ 0x5354, 0x851d },
	{ 0x5355, 0x852e },
	{ 0x5356, 0x8502 },
	{ 0x5357, 0x84fd },
	{ 0x5358, 0x851e },
	{ 0x5359, 0x84f6 },
	{ 0x535a, 0x8531 },
	{ 0x535b, 0x8526 },
	{ 0x535c, 0x84e7 },
	{ 0x535d, 0x84e8 },
	{ 0x535e, 0x84f0 },
	{ 0x535f, 0x84ef },
	{ 0x5360, 0x84f9 },
	{ 0x5361, 0x8518 },
	{ 0x5362, 0x8520 },
	{ 0x5363, 0x8530 },
	{ 0x5364, 0x850b },
	{ 0x5365, 0x8519 },
	{ 0x5366, 0x852f },
	{ 0x5367, 0x8662 },
	{ 0x5368, 0x8756 },
	{ 0x5369, 0x8763 },
	{ 0x536a, 0x8764 },
	{ 0x536b, 0x8777 },
	{ 0x536c, 0x87e1 },
	{ 0x536d, 0x8773 },
	{ 0x536e, 0x8758 },
	{ 0x536f, 0x8754 },
	{ 0x5370, 0x875b },
	{ 0x5371, 0x8752 },
	{ 0x5372, 0x8761 },
	{ 0x5373, 0x875a },
	{ 0x5374, 0x8751 },
	{ 0x5375, 0x875e },
	{ 0x5376, 0x876d },
	{ 0x5377, 0x876a },
	{ 0x5378, 0x8750 },
	{ 0x5379, 0x874e },
	{ 0x537a, 0x875f },
	{ 0x537b, 0x875d },
	{ 0x537c, 0x876f },
	{ 0x537d, 0x876c },
	{ 0x537e, 0x877a },
	{ 0x5421, 0x876e },
	{ 0x5422, 0x875c },
	{ 0x5423, 0x8765 },
	{ 0x5424, 0x874f },
	{ 0x5425, 0x877b },
	{ 0x5426, 0x8775 },
	{ 0x5427, 0x8762 },
	{ 0x5428, 0x8767 },
	{ 0x5429, 0x8769 },
	{ 0x542a, 0x885a },
	{ 0x542b, 0x8905 },
	{ 0x542c, 0x890c },
	{ 0x542d, 0x8914 },
	{ 0x542e, 0x890b },
	{ 0x542f, 0x8917 },
	{ 0x5430, 0x8918 },
	{ 0x5431, 0x8919 },
	{ 0x5432, 0x8906 },
	{ 0x5433, 0x8916 },
	{ 0x5434, 0x8911 },
	{ 0x5435, 0x890e },
	{ 0x5436, 0x8909 },
	{ 0x5437, 0x89a2 },
	{ 0x5438, 0x89a4 },
	{ 0x5439, 0x89a3 },
	{ 0x543a, 0x89ed },
	{ 0x543b, 0x89f0 },
	{ 0x543c, 0x89ec },
	{ 0x543d, 0x8acf },
	{ 0x543e, 0x8ac6 },
	{ 0x543f, 0x8ab8 },
	{ 0x5440, 0x8ad3 },
	{ 0x5441, 0x8ad1 },
	{ 0x5442, 0x8ad4 },
	{ 0x5443, 0x8ad5 },
	{ 0x5444, 0x8abb },
	{ 0x5445, 0x8ad7 },
	{ 0x5446, 0x8abe },
	{ 0x5447, 0x8ac0 },
	{ 0x5448, 0x8ac5 },
	{ 0x5449, 0x8ad8 },
	{ 0x544a, 0x8ac3 },
	{ 0x544b, 0x8aba },
	{ 0x544c, 0x8abd },
	{ 0x544d, 0x8ad9 },
	{ 0x544e, 0x8c3e },
	{ 0x544f, 0x8c4d },
	{ 0x5450, 0x8c8f },
	{ 0x5451, 0x8ce5 },
	{ 0x5452, 0x8cdf },
	{ 0x5453, 0x8cd9 },
	{ 0x5454, 0x8ce8 },
	{ 0x5455, 0x8cda },
	{ 0x5456, 0x8cdd },
	{ 0x5457, 0x8ce7 },
	{ 0x5458, 0x8da0 },
	{ 0x5459, 0x8d9c },
	{ 0x545a, 0x8da1 },
	{ 0x545b, 0x8d9b },
	{ 0x545c, 0x8e20 },
	{ 0x545d, 0x8e23 },
	{ 0x545e, 0x8e25 },
	{ 0x545f, 0x8e24 },
	{ 0x5460, 0x8e2e },
	{ 0x5461, 0x8e15 },
	{ 0x5462, 0x8e1b },
	{ 0x5463, 0x8e16 },
	{ 0x5464, 0x8e11 },
	{ 0x5465, 0x8e19 },
	{ 0x5466, 0x8e26 },
	{ 0x5467, 0x8e27 },
	{ 0x5468, 0x8e14 },
	{ 0x5469, 0x8e12 },
	{ 0x546a, 0x8e18 },
	{ 0x546b, 0x8e13 },
	{ 0x546c, 0x8e1c },
	{ 0x546d, 0x8e17 },
	{ 0x546e, 0x8e1a },
	{ 0x546f, 0x8f2c },
	{ 0x5470, 0x8f24 },
	{ 0x5471, 0x8f18 },
	{ 0x5472, 0x8f1a },
	{ 0x5473, 0x8f20 },
	{ 0x5474, 0x8f23 },
	{ 0x5475, 0x8f16 },
	{ 0x5476, 0x8f17 },
	{ 0x5477, 0x9073 },
	{ 0x5478, 0x9070 },
	{ 0x5479, 0x906f },
	{ 0x547a, 0x9067 },
	{ 0x547b, 0x906b },
	{ 0x547c, 0x912f },
	{ 0x547d, 0x912b },
	{ 0x547e, 0x9129 },
	{ 0x5521, 0x912a },
	{ 0x5522, 0x9132 },
	{ 0x5523, 0x9126 },
	{ 0x5524, 0x912e },
	{ 0x5525, 0x9185 },
	{ 0x5526, 0x9186 },
	{ 0x5527, 0x918a },
	{ 0x5528, 0x9181 },
	{ 0x5529, 0x9182 },
	{ 0x552a, 0x9184 },
	{ 0x552b, 0x9180 },
	{ 0x552c, 0x92d0 },
	{ 0x552d, 0x92c3 },
	{ 0x552e, 0x92c4 },
	{ 0x552f, 0x92c0 },
	{ 0x5530, 0x92d9 },
	{ 0x5531, 0x92b6 },
	{ 0x5532, 0x92cf },
	{ 0x5533, 0x92f1 },
	{ 0x5534, 0x92df },
	{ 0x5535, 0x92d8 },
	{ 0x5536, 0x92e9 },
	{ 0x5537, 0x92d7 },
	{ 0x5538, 0x92dd },
	{ 0x5539, 0x92cc },
	{ 0x553a, 0x92ef },
	{ 0x553b, 0x92c2 },
	{ 0x553c, 0x92e8 },
	{ 0x553d, 0x92ca },
	{ 0x553e, 0x92c8 },
	{ 0x553f, 0x92ce },
	{ 0x5540, 0x92e6 },
	{ 0x5541, 0x92cd },
	{ 0x5542, 0x92d5 },
	{ 0x5543, 0x92c9 },
	{ 0x5544, 0x92e0 },
	{ 0x5545, 0x92de },
	{ 0x5546, 0x92e7 },
	{ 0x5547, 0x92d1 },
	{ 0x5548, 0x92d3 },
	{ 0x5549, 0x92b5 },
	{ 0x554a, 0x92e1 },
	{ 0x554b, 0x9325 },
	{ 0x554c, 0x92c6 },
	{ 0x554d, 0x92b4 },
	{ 0x554e, 0x957c },
	{ 0x554f, 0x95ac },
	{ 0x5550, 0x95ab },
	{ 0x5551, 0x95ae },
	{ 0x5552, 0x95b0 },
	{ 0x5553, 0x96a4 },
	{ 0x5554, 0x96a2 },
	{ 0x5555, 0x96d3 },
	{ 0x5556, 0x9705 },
	{ 0x5557, 0x9708 },
	{ 0x5558, 0x9702 },
	{ 0x5559, 0x975a },
	{ 0x555a, 0x978a },
	{ 0x555b, 0x978e },
	{ 0x555c, 0x9788 },
	{ 0x555d, 0x97d0 },
	{ 0x555e, 0x97cf },
	{ 0x555f, 0x981e },
	{ 0x5560, 0x981d },
	{ 0x5561, 0x9826 },
	{ 0x5562, 0x9829 },
	{ 0x5563, 0x9828 },
	{ 0x5564, 0x9820 },
	{ 0x5565, 0x981b },
	{ 0x5566, 0x9827 },
	{ 0x5567, 0x98b2 },
	{ 0x5568, 0x9908 },
	{ 0x5569, 0x98fa },
	{ 0x556a, 0x9911 },
	{ 0x556b, 0x9914 },
	{ 0x556c, 0x9916 },
	{ 0x556d, 0x9917 },
	{ 0x556e, 0x9915 },
	{ 0x556f, 0x99dc },
	{ 0x5570, 0x99cd },
	{ 0x5571, 0x99cf },
	{ 0x5572, 0x99d3 },
	{ 0x5573, 0x99d4 },
	{ 0x5574, 0x99ce },
	{ 0x5575, 0x99c9 },
	{ 0x5576, 0x99d6 },
	{ 0x5577, 0x99d8 },
	{ 0x5578, 0x99cb },
	{ 0x5579, 0x99d7 },
	{ 0x557a, 0x99cc },
	{ 0x557b, 0x9ab3 },
	{ 0x557c, 0x9aec },
	{ 0x557d, 0x9aeb },
	{ 0x557e, 0x9af3 },
	{ 0x5621, 0x9af2 },
	{ 0x5622, 0x9af1 },
	{ 0x5623, 0x9b46 },
	{ 0x5624, 0x9b43 },
	{ 0x5625, 0x9b67 },
	{ 0x5626, 0x9b74 },
	{ 0x5627, 0x9b71 },
	{ 0x5628, 0x9b66 },
	{ 0x5629, 0x9b76 },
	{ 0x562a, 0x9b75 },
	{ 0x562b, 0x9b70 },
	{ 0x562c, 0x9b68 },
	{ 0x562d, 0x9b64 },
	{ 0x562e, 0x9b6c },
	{ 0x562f, 0x9cfc },
	{ 0x5630, 0x9cfa },
	{ 0x5631, 0x9cfd },
	{ 0x5632, 0x9cff },
	{ 0x5633, 0x9cf7 },
	{ 0x5634, 0x9d07 },
	{ 0x5635, 0x9d00 },
	{ 0x5636, 0x9cf9 },
	{ 0x5637, 0x9cfb },
	{ 0x5638, 0x9d08 },
	{ 0x5639, 0x9d05 },
	{ 0x563a, 0x9d04 },
	{ 0x563b, 0x9e83 },
	{ 0x563c, 0x9ed3 },
	{ 0x563d, 0x9f0f },
	{ 0x563e, 0x9f10 },
	{ 0x563f, 0x511c },
	{ 0x5640, 0x5113 },
	{ 0x5641, 0x5117 },
	{ 0x5642, 0x511a },
	{ 0x5643, 0x5111 },
	{ 0x5644, 0x51de },
	{ 0x5645, 0x5334 },
	{ 0x5646, 0x53e1 },
	{ 0x5647, 0x5670 },
	{ 0x5648, 0x5660 },
	{ 0x5649, 0x566e },
	{ 0x564a, 0x5673 },
	{ 0x564b, 0x5666 },
	{ 0x564c, 0x5663 },
	{ 0x564d, 0x566d },
	{ 0x564e, 0x5672 },
	{ 0x564f, 0x565e },
	{ 0x5650, 0x5677 },
	{ 0x5651, 0x571c },
	{ 0x5652, 0x571b },
	{ 0x5653, 0x58c8 },
	{ 0x5654, 0x58bd },
	{ 0x5655, 0x58c9 },
	{ 0x5656, 0x58bf },
	{ 0x5657, 0x58ba },
	{ 0x5658, 0x58c2 },
	{ 0x5659, 0x58bc },
	{ 0x565a, 0x58c6 },
	{ 0x565b, 0x5b17 },
	{ 0x565c, 0x5b19 },
	{ 0x565d, 0x5b1b },
	{ 0x565e, 0x5b21 },
	{ 0x565f, 0x5b14 },
	{ 0x5660, 0x5b13 },
	{ 0x5661, 0x5b10 },
	{ 0x5662, 0x5b16 },
	{ 0x5663, 0x5b28 },
	{ 0x5664, 0x5b1a },
	{ 0x5665, 0x5b20 },
	{ 0x5666, 0x5b1e },
	{ 0x5667, 0x5bef },
	{ 0x5668, 0x5dac },
	{ 0x5669, 0x5db1 },
	{ 0x566a, 0x5da9 },
	{ 0x566b, 0x5da7 },
	{ 0x566c, 0x5db5 },
	{ 0x566d, 0x5db0 },
	{ 0x566e, 0x5dae },
	{ 0x566f, 0x5daa },
	{ 0x5670, 0x5da8 },
	{ 0x5671, 0x5db2 },
	{ 0x5672, 0x5dad },
	{ 0x5673, 0x5daf },
	{ 0x5674, 0x5db4 },
	{ 0x5675, 0x5e67 },
	{ 0x5676, 0x5e68 },
	{ 0x5677, 0x5e66 },
	{ 0x5678, 0x5e6f },
	{ 0x5679, 0x5ee9 },
	{ 0x567a, 0x5ee7 },
	{ 0x567b, 0x5ee6 },
	{ 0x567c, 0x5ee8 },
	{ 0x567d, 0x5ee5 },
	{ 0x567e, 0x5f4b },
	{ 0x5721, 0x5fbc },
	{ 0x5722, 0x5fbb },
	{ 0x5723, 0x619d },
	{ 0x5724, 0x61a8 },
	{ 0x5725, 0x6196 },
	{ 0x5726, 0x61c5 },
	{ 0x5727, 0x61b4 },
	{ 0x5728, 0x61c6 },
	{ 0x5729, 0x61c1 },
	{ 0x572a, 0x61cc },
	{ 0x572b, 0x61ba },
	{ 0x572c, 0x61bf },
	{ 0x572d, 0x61b8 },
	{ 0x572e, 0x618c },
	{ 0x572f, 0x64d7 },
	{ 0x5730, 0x64d6 },
	{ 0x5731, 0x64d0 },
	{ 0x5732, 0x64cf },
	{ 0x5733, 0x64c9 },
	{ 0x5734, 0x64bd },
	{ 0x5735, 0x6489 },
	{ 0x5736, 0x64c3 },
	{ 0x5737, 0x64db },
	{ 0x5738, 0x64f3 },
	{ 0x5739, 0x64d9 },
	{ 0x573a, 0x6533 },
	{ 0x573b, 0x657f },
	{ 0x573c, 0x657c },
	{ 0x573d, 0x65a2 },
	{ 0x573e, 0x66c8 },
	{ 0x573f, 0x66be },
	{ 0x5740, 0x66c0 },
	{ 0x5741, 0x66ca },
	{ 0x5742, 0x66cb },
	{ 0x5743, 0x66cf },
	{ 0x5744, 0x66bd },
	{ 0x5745, 0x66bb },
	{ 0x5746, 0x66ba },
	{ 0x5747, 0x66cc },
	{ 0x5748, 0x6723 },
	{ 0x5749, 0x6a34 },
	{ 0x574a, 0x6a66 },
	{ 0x574b, 0x6a49 },
	{ 0x574c, 0x6a67 },
	{ 0x574d, 0x6a32 },
	{ 0x574e, 0x6a68 },
	{ 0x574f, 0x6a3e },
	{ 0x5750, 0x6a5d },
	{ 0x5751, 0x6a6d },
	{ 0x5752, 0x6a76 },
	{ 0x5753, 0x6a5b },
	{ 0x5754, 0x6a51 },
	{ 0x5755, 0x6a28 },
	{ 0x5756, 0x6a5a },
	{ 0x5757, 0x6a3b },
	{ 0x5758, 0x6a3f },
	{ 0x5759, 0x6a41 },
	{ 0x575a, 0x6a6a },
	{ 0x575b, 0x6a64 },
	{ 0x575c, 0x6a50 },
	{ 0x575d, 0x6a4f },
	{ 0x575e, 0x6a54 },
	{ 0x575f, 0x6a6f },
	{ 0x5760, 0x6a69 },
	{ 0x5761, 0x6a60 },
	{ 0x5762, 0x6a3c },
	{ 0x5763, 0x6a5e },
	{ 0x5764, 0x6a56 },
	{ 0x5765, 0x6a55 },
	{ 0x5766, 0x6a4d },
	{ 0x5767, 0x6a4e },
	{ 0x5768, 0x6a46 },
	{ 0x5769, 0x6b55 },
	{ 0x576a, 0x6b54 },
	{ 0x576b, 0x6b56 },
	{ 0x576c, 0x6ba7 },
	{ 0x576d, 0x6baa },
	{ 0x576e, 0x6bab },
	{ 0x576f, 0x6bc8 },
	{ 0x5770, 0x6bc7 },
	{ 0x5771, 0x6c04 },
	{ 0x5772, 0x6c03 },
	{ 0x5773, 0x6c06 },
	{ 0x5774, 0x6fad },
	{ 0x5775, 0x6fcb },
	{ 0x5776, 0x6fa3 },
	{ 0x5777, 0x6fc7 },
	{ 0x5778, 0x6fbc },
	{ 0x5779, 0x6fce },
	{ 0x577a, 0x6fc8 },
	{ 0x577b, 0x6f5e },
	{ 0x577c, 0x6fc4 },
	{ 0x577d, 0x6fbd },
	{ 0x577e, 0x6f9e },
	{ 0x5821, 0x6fca },
	{ 0x5822, 0x6fa8 },
	{ 0x5823, 0x7004 },
	{ 0x5824, 0x6fa5 },
	{ 0x5825, 0x6fae },
	{ 0x5826, 0x6fba },
	{ 0x5827, 0x6fac },
	{ 0x5828, 0x6faa },
	{ 0x5829, 0x6fcf },
	{ 0x582a, 0x6fbf },
	{ 0x582b, 0x6fb8 },
	{ 0x582c, 0x6fa2 },
	{ 0x582d, 0x6fc9 },
	{ 0x582e, 0x6fab },
	{ 0x582f, 0x6fcd },
	{ 0x5830, 0x6faf },
	{ 0x5831, 0x6fb2 },
	{ 0x5832, 0x6fb0 },
	{ 0x5833, 0x71c5 },
	{ 0x5834, 0x71c2 },
	{ 0x5835, 0x71bf },
	{ 0x5836, 0x71b8 },
	{ 0x5837, 0x71d6 },
	{ 0x5838, 0x71c0 },
	{ 0x5839, 0x71c1 },
	{ 0x583a, 0x71cb },
	{ 0x583b, 0x71d4 },
	{ 0x583c, 0x71ca },
	{ 0x583d, 0x71c7 },
	{ 0x583e, 0x71cf },
	{ 0x583f, 0x71bd },
	{ 0x5840, 0x71d8 },
	{ 0x5841, 0x71bc },
	{ 0x5842, 0x71c6 },
	{ 0x5843, 0x71da },
	{ 0x5844, 0x71db },
	{ 0x5845, 0x729d },
	{ 0x5846, 0x729e },
	{ 0x5847, 0x7369 },
	{ 0x5848, 0x7366 },
	{ 0x5849, 0x7367 },
	{ 0x584a, 0x736c },
	{ 0x584b, 0x7365 },
	{ 0x584c, 0x736b },
	{ 0x584d, 0x736a },
	{ 0x584e, 0x747f },
	{ 0x584f, 0x749a },
	{ 0x5850, 0x74a0 },
	{ 0x5851, 0x7494 },
	{ 0x5852, 0x7492 },
	{ 0x5853, 0x7495 },
	{ 0x5854, 0x74a1 },
	{ 0x5855, 0x750b },
	{ 0x5856, 0x7580 },
	{ 0x5857, 0x762f },
	{ 0x5858, 0x762d },
	{ 0x5859, 0x7631 },
	{ 0x585a, 0x763d },
	{ 0x585b, 0x7633 },
	{ 0x585c, 0x763c },
	{ 0x585d, 0x7635 },
	{ 0x585e, 0x7632 },
	{ 0x585f, 0x7630 },
	{ 0x5860, 0x76bb },
	{ 0x5861, 0x76e6 },
	{ 0x5862, 0x779a },
	{ 0x5863, 0x779d },
	{ 0x5864, 0x77a1 },
	{ 0x5865, 0x779c },
	{ 0x5866, 0x779b },
	{ 0x5867, 0x77a2 },
	{ 0x5868, 0x77a3 },
	{ 0x5869, 0x7795 },
	{ 0x586a, 0x7799 },
	{ 0x586b, 0x7797 },
	{ 0x586c, 0x78dd },
	{ 0x586d, 0x78e9 },
	{ 0x586e, 0x78e5 },
	{ 0x586f, 0x78ea },
	{ 0x5870, 0x78de },
	{ 0x5871, 0x78e3 },
	{ 0x5872, 0x78db },
	{ 0x5873, 0x78e1 },
	{ 0x5874, 0x78e2 },
	{ 0x5875, 0x78ed },
	{ 0x5876, 0x78df },
	{ 0x5877, 0x78e0 },
	{ 0x5878, 0x79a4 },
	{ 0x5879, 0x7a44 },
	{ 0x587a, 0x7a48 },
	{ 0x587b, 0x7a47 },
	{ 0x587c, 0x7ab6 },
	{ 0x587d, 0x7ab8 },
	{ 0x587e, 0x7ab5 },
	{ 0x5921, 0x7ab1 },
	{ 0x5922, 0x7ab7 },
	{ 0x5923, 0x7bde },
	{ 0x5924, 0x7be3 },
	{ 0x5925, 0x7be7 },
	{ 0x5926, 0x7bdd },
	{ 0x5927, 0x7bd5 },
	{ 0x5928, 0x7be5 },
	{ 0x5929, 0x7bda },
	{ 0x592a, 0x7be8 },
	{ 0x592b, 0x7bf9 },
	{ 0x592c, 0x7bd4 },
	{ 0x592d, 0x7bea },
	{ 0x592e, 0x7be2 },
	{ 0x592f, 0x7bdc },
	{ 0x5930, 0x7beb },
	{ 0x5931, 0x7bd8 },
	{ 0x5932, 0x7bdf },
	{ 0x5933, 0x7cd2 },
	{ 0x5934, 0x7cd4 },
	{ 0x5935, 0x7cd7 },
	{ 0x5936, 0x7cd0 },
	{ 0x5937, 0x7cd1 },
	{ 0x5938, 0x7e12 },
	{ 0x5939, 0x7e21 },
	{ 0x593a, 0x7e17 },
	{ 0x593b, 0x7e0c },
	{ 0x593c, 0x7e1f },
	{ 0x593d, 0x7e20 },
	{ 0x593e, 0x7e13 },
	{ 0x593f, 0x7e0e },
	{ 0x5940, 0x7e1c },
	{ 0x5941, 0x7e15 },
	{ 0x5942, 0x7e1a },
	{ 0x5943, 0x7e22 },
	{ 0x5944, 0x7e0b },
	{ 0x5945, 0x7e0f },
	{ 0x5946, 0x7e16 },
	{ 0x5947, 0x7e0d },
	{ 0x5948, 0x7e14 },
	{ 0x5949, 0x7e25 },
	{ 0x594a, 0x7e24 },
	{ 0x594b, 0x7f43 },
	{ 0x594c, 0x7f7b },
	{ 0x594d, 0x7f7c },
	{ 0x594e, 0x7f7a },
	{ 0x594f, 0x7fb1 },
	{ 0x5950, 0x7fef },
	{ 0x5951, 0x802a },
	{ 0x5952, 0x8029 },
	{ 0x5953, 0x806c },
	{ 0x5954, 0x81b1 },
	{ 0x5955, 0x81a6 },
	{ 0x5956, 0x81ae },
	{ 0x5957, 0x81b9 },
	{ 0x5958, 0x81b5 },
	{ 0x5959, 0x81ab },
	{ 0x595a, 0x81b0 },
	{ 0x595b, 0x81ac },
	{ 0x595c, 0x81b4 },
	{ 0x595d, 0x81b2 },
	{ 0x595e, 0x81b7 },
	{ 0x595f, 0x81a7 },
	{ 0x5960, 0x81f2 },
	{ 0x5961, 0x8255 },
	{ 0x5962, 0x8256 },
	{ 0x5963, 0x8257 },
	{ 0x5964, 0x8556 },
	{ 0x5965, 0x8545 },
	{ 0x5966, 0x856b },
	{ 0x5967, 0x854d },
	{ 0x5968, 0x8553 },
	{ 0x5969, 0x8561 },
	{ 0x596a, 0x8558 },
	{ 0x596b, 0x8540 },
	{ 0x596c, 0x8546 },
	{ 0x596d, 0x8564 },
	{ 0x596e, 0x8541 },
	{ 0x596f, 0x8562 },
	{ 0x5970, 0x8544 },
	{ 0x5971, 0x8551 },
	{ 0x5972, 0x8547 },
	{ 0x5973, 0x8563 },
	{ 0x5974, 0x853e },
	{ 0x5975, 0x855b },
	{ 0x5976, 0x8571 },
	{ 0x5977, 0x854e },
	{ 0x5978, 0x856e },
	{ 0x5979, 0x8575 },
	{ 0x597a, 0x8555 },
	{ 0x597b, 0x8567 },
	{ 0x597c, 0x8560 },
	{ 0x597d, 0x858c },
	{ 0x597e, 0x8566 },
	{ 0x5a21, 0x855d },
	{ 0x5a22, 0x8554 },
	{ 0x5a23, 0x8565 },
	{ 0x5a24, 0x856c },
	{ 0x5a25, 0x8663 },
	{ 0x5a26, 0x8665 },
	{ 0x5a27, 0x8664 },
	{ 0x5a28, 0x87a4 },
	{ 0x5a29, 0x879b },
	{ 0x5a2a, 0x878f },
	{ 0x5a2b, 0x8797 },
	{ 0x5a2c, 0x8793 },
	{ 0x5a2d, 0x8792 },
	{ 0x5a2e, 0x8788 },
	{ 0x5a2f, 0x8781 },
	{ 0x5a30, 0x8796 },
	{ 0x5a31, 0x8798 },
	{ 0x5a32, 0x8779 },
	{ 0x5a33, 0x8787 },
	{ 0x5a34, 0x87a3 },
	{ 0x5a35, 0x8785 },
	{ 0x5a36, 0x8790 },
	{ 0x5a37, 0x8791 },
	{ 0x5a38, 0x879d },
	{ 0x5a39, 0x8784 },
	{ 0x5a3a, 0x8794 },
	{ 0x5a3b, 0x879c },
	{ 0x5a3c, 0x879a },
	{ 0x5a3d, 0x8789 },
	{ 0x5a3e, 0x891e },
	{ 0x5a3f, 0x8926 },
	{ 0x5a40, 0x8930 },
	{ 0x5a41, 0x892d },
	{ 0x5a42, 0x892e },
	{ 0x5a43, 0x8927 },
	{ 0x5a44, 0x8931 },
	{ 0x5a45, 0x8922 },
	{ 0x5a46, 0x8929 },
	{ 0x5a47, 0x8923 },
	{ 0x5a48, 0x892f },
	{ 0x5a49, 0x892c },
	{ 0x5a4a, 0x891f },
	{ 0x5a4b, 0x89f1 },
	{ 0x5a4c, 0x8ae0 },
	{ 0x5a4d, 0x8ae2 },
	{ 0x5a4e, 0x8af2 },
	{ 0x5a4f, 0x8af4 },
	{ 0x5a50, 0x8af5 },
	{ 0x5a51, 0x8add },
	{ 0x5a52, 0x8b14 },
	{ 0x5a53, 0x8ae4 },
	{ 0x5a54, 0x8adf },
	{ 0x5a55, 0x8af0 },
	{ 0x5a56, 0x8ac8 },
	{ 0x5a57, 0x8ade },
	{ 0x5a58, 0x8ae1 },
	{ 0x5a59, 0x8ae8 },
	{ 0x5a5a, 0x8aff },
	{ 0x5a5b, 0x8aef },
	{ 0x5a5c, 0x8afb },
	{ 0x5a5d, 0x8c91 },
	{ 0x5a5e, 0x8c92 },
	{ 0x5a5f, 0x8c90 },
	{ 0x5a60, 0x8cf5 },
	{ 0x5a61, 0x8cee },
	{ 0x5a62, 0x8cf1 },
	{ 0x5a63, 0x8cf0 },
	{ 0x5a64, 0x8cf3 },
	{ 0x5a65, 0x8d6c },
	{ 0x5a66, 0x8d6e },
	{ 0x5a67, 0x8da5 },
	{ 0x5a68, 0x8da7 },
	{ 0x5a69, 0x8e33 },
	{ 0x5a6a, 0x8e3e },
	{ 0x5a6b, 0x8e38 },
	{ 0x5a6c, 0x8e40 },
	{ 0x5a6d, 0x8e45 },
	{ 0x5a6e, 0x8e36 },
	{ 0x5a6f, 0x8e3c },
	{ 0x5a70, 0x8e3d },
	{ 0x5a71, 0x8e41 },
	{ 0x5a72, 0x8e30 },
	{ 0x5a73, 0x8e3f },
	{ 0x5a74, 0x8ebd },
	{ 0x5a75, 0x8f36 },
	{ 0x5a76, 0x8f2e },
	{ 0x5a77, 0x8f35 },
	{ 0x5a78, 0x8f32 },
	{ 0x5a79, 0x8f39 },
	{ 0x5a7a, 0x8f37 },
	{ 0x5a7b, 0x8f34 },
	{ 0x5a7c, 0x9076 },
	{ 0x5a7d, 0x9079 },
	{ 0x5a7e, 0x907b },
	{ 0x5b21, 0x9086 },
	{ 0x5b22, 0x90fa },
	{ 0x5b23, 0x9133 },
	{ 0x5b24, 0x9135 },
	{ 0x5b25, 0x9136 },
	{ 0x5b26, 0x9193 },
	{ 0x5b27, 0x9190 },
	{ 0x5b28, 0x9191 },
	{ 0x5b29, 0x918d },
	{ 0x5b2a, 0x918f },
	{ 0x5b2b, 0x9327 },
	{ 0x5b2c, 0x931e },
	{ 0x5b2d, 0x9308 },
	{ 0x5b2e, 0x931f },
	{ 0x5b2f, 0x9306 },
	{ 0x5b30, 0x930f },
	{ 0x5b31, 0x937a },
	{ 0x5b32, 0x9338 },
	{ 0x5b33, 0x933c },
	{ 0x5b34, 0x931b },
	{ 0x5b35, 0x9323 },
	{ 0x5b36, 0x9312 },
	{ 0x5b37, 0x9301 },
	{ 0x5b38, 0x9346 },
	{ 0x5b39, 0x932d },
	{ 0x5b3a, 0x930e },
	{ 0x5b3b, 0x930d },
	{ 0x5b3c, 0x92cb },
	{ 0x5b3d, 0x931d },
	{ 0x5b3e, 0x92fa },
	{ 0x5b3f, 0x9313 },
	{ 0x5b40, 0x92f9 },
	{ 0x5b41, 0x92f7 },
	{ 0x5b42, 0x9334 },
	{ 0x5b43, 0x9302 },
	{ 0x5b44, 0x9324 },
	{ 0x5b45, 0x92ff },
	{ 0x5b46, 0x9329 },
	{ 0x5b47, 0x9339 },
	{ 0x5b48, 0x9335 },
	{ 0x5b49, 0x932a },
	{ 0x5b4a, 0x9314 },
	{ 0x5b4b, 0x930c },
	{ 0x5b4c, 0x930b },
	{ 0x5b4d, 0x92fe },
	{ 0x5b4e, 0x9309 },
	{ 0x5b4f, 0x9300 },
	{ 0x5b50, 0x92fb },
	{ 0x5b51, 0x9316 },
	{ 0x5b52, 0x95bc },
	{ 0x5b53, 0x95cd },
	{ 0x5b54, 0x95be },
	{ 0x5b55, 0x95b9 },
	{ 0x5b56, 0x95ba },
	{ 0x5b57, 0x95b6 },
	{ 0x5b58, 0x95bf },
	{ 0x5b59, 0x95b5 },
	{ 0x5b5a, 0x95bd },
	{ 0x5b5b, 0x96a9 },
	{ 0x5b5c, 0x96d4 },
	{ 0x5b5d, 0x970b },
	{ 0x5b5e, 0x9712 },
	{ 0x5b5f, 0x9710 },
	{ 0x5b60, 0x9799 },
	{ 0x5b61, 0x9797 },
	{ 0x5b62, 0x9794 },
	{ 0x5b63, 0x97f0 },
	{ 0x5b64, 0x97f8 },
	{ 0x5b65, 0x9835 },
	{ 0x5b66, 0x982f },
	{ 0x5b67, 0x9832 },
	{ 0x5b68, 0x9924 },
	{ 0x5b69, 0x991f },
	{ 0x5b6a, 0x9927 },
	{ 0x5b6b, 0x9929 },
	{ 0x5b6c, 0x999e },
	{ 0x5b6d, 0x99ee },
	{ 0x5b6e, 0x99ec },
	{ 0x5b6f, 0x99e5 },
	{ 0x5b70, 0x99e4 },
	{ 0x5b71, 0x99f0 },
	{ 0x5b72, 0x99e3 },
	{ 0x5b73, 0x99ea },
	{ 0x5b74, 0x99e9 },
	{ 0x5b75, 0x99e7 },
	{ 0x5b76, 0x9ab9 },
	{ 0x5b77, 0x9abf },
	{ 0x5b78, 0x9ab4 },
	{ 0x5b79, 0x9abb },
	{ 0x5b7a, 0x9af6 },
	{ 0x5b7b, 0x9afa },
	{ 0x5b7c, 0x9af9 },
	{ 0x5b7d, 0x9af7 },
	{ 0x5b7e, 0x9b33 },
	{ 0x5c21, 0x9b80 },
	{ 0x5c22, 0x9b85 },
	{ 0x5c23, 0x9b87 },
	{ 0x5c24, 0x9b7c },
	{ 0x5c25, 0x9b7e },
	{ 0x5c26, 0x9b7b },
	{ 0x5c27, 0x9b82 },
	{ 0x5c28, 0x9b93 },
	{ 0x5c29, 0x9b92 },
	{ 0x5c2a, 0x9b90 },
	{ 0x5c2b, 0x9b7a },
	{ 0x5c2c, 0x9b95 },
	{ 0x5c2d, 0x9b7d },
	{ 0x5c2e, 0x9b88 },
	{ 0x5c2f, 0x9d25 },
	{ 0x5c30, 0x9d17 },
	{ 0x5c31, 0x9d20 },
	{ 0x5c32, 0x9d1e },
	{ 0x5c33, 0x9d14 },
	{ 0x5c34, 0x9d29 },
	{ 0x5c35, 0x9d1d },
	{ 0x5c36, 0x9d18 },
	{ 0x5c37, 0x9d22 },
	{ 0x5c38, 0x9d10 },
	{ 0x5c39, 0x9d19 },
	{ 0x5c3a, 0x9d1f },
	{ 0x5c3b, 0x9e88 },
	{ 0x5c3c, 0x9e86 },
	{ 0x5c3d, 0x9e87 },
	{ 0x5c3e, 0x9eae },
	{ 0x5c3f, 0x9ead },
	{ 0x5c40, 0x9ed5 },
	{ 0x5c41, 0x9ed6 },
	{ 0x5c42, 0x9efa },
	{ 0x5c43, 0x9f12 },
	{ 0x5c44, 0x9f3d },
	{ 0x5c45, 0x5126 },
	{ 0x5c46, 0x5125 },
	{ 0x5c47, 0x5122 },
	{ 0x5c48, 0x5124 },
	{ 0x5c49, 0x5120 },
	{ 0x5c4a, 0x5129 },
	{ 0x5c4b, 0x52f4 },
	{ 0x5c4c, 0x5693 },
	{ 0x5c4d, 0x568c },
	{ 0x5c4e, 0x568d },
	{ 0x5c4f, 0x5686 },
	{ 0x5c50, 0x5684 },
	{ 0x5c51, 0x5683 },
	{ 0x5c52, 0x567e },
	{ 0x5c53, 0x5682 },
	{ 0x5c54, 0x567f },
	{ 0x5c55, 0x5681 },
	{ 0x5c56, 0x58d6 },
	{ 0x5c57, 0x58d4 },
	{ 0x5c58, 0x58cf },
	{ 0x5c59, 0x58d2 },
	{ 0x5c5a, 0x5b2d },
	{ 0x5c5b, 0x5b25 },
	{ 0x5c5c, 0x5b32 },
	{ 0x5c5d, 0x5b23 },
	{ 0x5c5e, 0x5b2c },
	{ 0x5c5f, 0x5b27 },
	{ 0x5c60, 0x5b26 },
	{ 0x5c61, 0x5b2f },
	{ 0x5c62, 0x5b2e },
	{ 0x5c63, 0x5b7b },
	{ 0x5c64, 0x5bf1 },
	{ 0x5c65, 0x5bf2 },
	{ 0x5c66, 0x5db7 },
	{ 0x5c67, 0x5e6c },
	{ 0x5c68, 0x5e6a },
	{ 0x5c69, 0x5fbe },
	{ 0x5c6a, 0x61c3 },
	{ 0x5c6b, 0x61b5 },
	{ 0x5c6c, 0x61bc },
	{ 0x5c6d, 0x61e7 },
	{ 0x5c6e, 0x61e0 },
	{ 0x5c6f, 0x61e5 },
	{ 0x5c70, 0x61e4 },
	{ 0x5c71, 0x61e8 },
	{ 0x5c72, 0x61de },
	{ 0x5c73, 0x64ef },
	{ 0x5c74, 0x64e9 },
	{ 0x5c75, 0x64e3 },
	{ 0x5c76, 0x64eb },
	{ 0x5c77, 0x64e4 },
	{ 0x5c78, 0x64e8 },
	{ 0x5c79, 0x6581 },
	{ 0x5c7a, 0x6580 },
	{ 0x5c7b, 0x65b6 },
	{ 0x5c7c, 0x65da },
	{ 0x5c7d, 0x66d2 },
	{ 0x5c7e, 0x6a8d },
	{ 0x5d21, 0x6a96 },
	{ 0x5d22, 0x6a81 },
	{ 0x5d23, 0x6aa5 },
	{ 0x5d24, 0x6a89 },
	{ 0x5d25, 0x6a9f },
	{ 0x5d26, 0x6a9b },
	{ 0x5d27, 0x6aa1 },
	{ 0x5d28, 0x6a9e },
	{ 0x5d29, 0x6a87 },
	{ 0x5d2a, 0x6a93 },
	{ 0x5d2b, 0x6a8e },
	{ 0x5d2c, 0x6a95 },
	{ 0x5d2d, 0x6a83 },
	{ 0x5d2e, 0x6aa8 },
	{ 0x5d2f, 0x6aa4 },
	{ 0x5d30, 0x6a91 },
	{ 0x5d31, 0x6a7f },
	{ 0x5d32, 0x6aa6 },
	{ 0x5d33, 0x6a9a },
	{ 0x5d34, 0x6a85 },
	{ 0x5d35, 0x6a8c },
	{ 0x5d36, 0x6a92 },
	{ 0x5d37, 0x6b5b },
	{ 0x5d38, 0x6bad },
	{ 0x5d39, 0x6c09 },
	{ 0x5d3a, 0x6fcc },
	{ 0x5d3b, 0x6fa9 },
	{ 0x5d3c, 0x6ff4 },
	{ 0x5d3d, 0x6fd4 },
	{ 0x5d3e, 0x6fe3 },
	{ 0x5d3f, 0x6fdc },
	{ 0x5d40, 0x6fed },
	{ 0x5d41, 0x6fe7 },
	{ 0x5d42, 0x6fe6 },
	{ 0x5d43, 0x6fde },
	{ 0x5d44, 0x6ff2 },
	{ 0x5d45, 0x6fdd },
	{ 0x5d46, 0x6fe2 },
	{ 0x5d47, 0x6fe8 },
	{ 0x5d48, 0x71e1 },
	{ 0x5d49, 0x71f1 },
	{ 0x5d4a, 0x71e8 },
	{ 0x5d4b, 0x71f2 },
	{ 0x5d4c, 0x71e4 },
	{ 0x5d4d, 0x71f0 },
	{ 0x5d4e, 0x71e2 },
	{ 0x5d4f, 0x7373 },
	{ 0x5d50, 0x736e },
	{ 0x5d51, 0x736f },
	{ 0x5d52, 0x7497 },
	{ 0x5d53, 0x74b2 },
	{ 0x5d54, 0x74ab },
	{ 0x5d55, 0x7490 },
	{ 0x5d56, 0x74aa },
	{ 0x5d57, 0x74ad },
	{ 0x5d58, 0x74b1 },
	{ 0x5d59, 0x74a5 },
	{ 0x5d5a, 0x74af },
	{ 0x5d5b, 0x7510 },
	{ 0x5d5c, 0x7511 },
	{ 0x5d5d, 0x7512 },
	{ 0x5d5e, 0x750f },
	{ 0x5d5f, 0x7584 },
	{ 0x5d60, 0x7643 },
	{ 0x5d61, 0x7648 },
	{ 0x5d62, 0x7649 },
	{ 0x5d63, 0x7647 },
	{ 0x5d64, 0x76a4 },
	{ 0x5d65, 0x76e9 },
	{ 0x5d66, 0x77b5 },
	{ 0x5d67, 0x77ab },
	{ 0x5d68, 0x77b2 },
	{ 0x5d69, 0x77b7 },
	{ 0x5d6a, 0x77b6 },
	{ 0x5d6b, 0x77b4 },
	{ 0x5d6c, 0x77b1 },
	{ 0x5d6d, 0x77a8 },
	{ 0x5d6e, 0x77f0 },
	{ 0x5d6f, 0x78f3 },
	{ 0x5d70, 0x78fd },
	{ 0x5d71, 0x7902 },
	{ 0x5d72, 0x78fb },
	{ 0x5d73, 0x78fc },
	{ 0x5d74, 0x78ff },
	{ 0x5d75, 0x78f2 },
	{ 0x5d76, 0x7905 },
	{ 0x5d77, 0x78f9 },
	{ 0x5d78, 0x78fe },
	{ 0x5d79, 0x7904 },
	{ 0x5d7a, 0x79ab },
	{ 0x5d7b, 0x79a8 },
	{ 0x5d7c, 0x7a5c },
	{ 0x5d7d, 0x7a5b },
	{ 0x5d7e, 0x7a56 },
	{ 0x5e21, 0x7a58 },
	{ 0x5e22, 0x7a54 },
	{ 0x5e23, 0x7a5a },
	{ 0x5e24, 0x7abe },
	{ 0x5e25, 0x7ac0 },
	{ 0x5e26, 0x7ac1 },
	{ 0x5e27, 0x7c05 },
	{ 0x5e28, 0x7c0f },
	{ 0x5e29, 0x7bf2 },
	{ 0x5e2a, 0x7c00 },
	{ 0x5e2b, 0x7bff },
	{ 0x5e2c, 0x7bfb },
	{ 0x5e2d, 0x7c0e },
	{ 0x5e2e, 0x7bf4 },
	{ 0x5e2f, 0x7c0b },
	{ 0x5e30, 0x7bf3 },
	{ 0x5e31, 0x7c02 },
	{ 0x5e32, 0x7c09 },
	{ 0x5e33, 0x7c03 },
	{ 0x5e34, 0x7c01 },
	{ 0x5e35, 0x7bf8 },
	{ 0x5e36, 0x7bfd },
	{ 0x5e37, 0x7c06 },
	{ 0x5e38, 0x7bf0 },
	{ 0x5e39, 0x7bf1 },
	{ 0x5e3a, 0x7c10 },
	{ 0x5e3b, 0x7c0a },
	{ 0x5e3c, 0x7ce8 },
	{ 0x5e3d, 0x7e2d },
	{ 0x5e3e, 0x7e3c },
	{ 0x5e3f, 0x7e42 },
	{ 0x5e40, 0x7e33 },
	{ 0x5e41, 0x9848 },
	{ 0x5e42, 0x7e38 },
	{ 0x5e43, 0x7e2a },
	{ 0x5e44, 0x7e49 },
	{ 0x5e45, 0x7e40 },
	{ 0x5e46, 0x7e47 },
	{ 0x5e47, 0x7e29 },
	{ 0x5e48, 0x7e4c },
	{ 0x5e49, 0x7e30 },
	{ 0x5e4a, 0x7e3b },
	{ 0x5e4b, 0x7e36 },
	{ 0x5e4c, 0x7e44 },
	{ 0x5e4d, 0x7e3a },
	{ 0x5e4e, 0x7f45 },
	{ 0x5e4f, 0x7f7f },
	{ 0x5e50, 0x7f7e },
	{ 0x5e51, 0x7f7d },
	{ 0x5e52, 0x7ff4 },
	{ 0x5e53, 0x7ff2 },
	{ 0x5e54, 0x802c },
	{ 0x5e55, 0x81bb },
	{ 0x5e56, 0x81c4 },
	{ 0x5e57, 0x81cc },
	{ 0x5e58, 0x81ca },
	{ 0x5e59, 0x81c5 },
	{ 0x5e5a, 0x81c7 },
	{ 0x5e5b, 0x81bc },
	{ 0x5e5c, 0x81e9 },
	{ 0x5e5d, 0x825b },
	{ 0x5e5e, 0x825a },
	{ 0x5e5f, 0x825c },
	{ 0x5e60, 0x8583 },
	{ 0x5e61, 0x8580 },
	{ 0x5e62, 0x858f },
	{ 0x5e63, 0x85a7 },
	{ 0x5e64, 0x8595 },
	{ 0x5e65, 0x85a0 },
	{ 0x5e66, 0x858b },
	{ 0x5e67, 0x85a3 },
	{ 0x5e68, 0x857b },
	{ 0x5e69, 0x85a4 },
	{ 0x5e6a, 0x859a },
	{ 0x5e6b, 0x859e },
	{ 0x5e6c, 0x8577 },
	{ 0x5e6d, 0x857c },
	{ 0x5e6e, 0x8589 },
	{ 0x5e6f, 0x85a1 },
	{ 0x5e70, 0x857a },
	{ 0x5e71, 0x8578 },
	{ 0x5e72, 0x8557 },
	{ 0x5e73, 0x858e },
	{ 0x5e74, 0x8596 },
	{ 0x5e75, 0x8586 },
	{ 0x5e76, 0x858d },
	{ 0x5e77, 0x8599 },
	{ 0x5e78, 0x859d },
	{ 0x5e79, 0x8581 },
	{ 0x5e7a, 0x85a2 },
	{ 0x5e7b, 0x8582 },
	{ 0x5e7c, 0x8588 },
	{ 0x5e7d, 0x8585 },
	{ 0x5e7e, 0x8579 },
	{ 0x5f21, 0x8576 },
	{ 0x5f22, 0x8598 },
	{ 0x5f23, 0x8590 },
	{ 0x5f24, 0x859f },
	{ 0x5f25, 0x8668 },
	{ 0x5f26, 0x87be },
	{ 0x5f27, 0x87aa },
	{ 0x5f28, 0x87ad },
	{ 0x5f29, 0x87c5 },
	{ 0x5f2a, 0x87b0 },
	{ 0x5f2b, 0x87ac },
	{ 0x5f2c, 0x87b9 },
	{ 0x5f2d, 0x87b5 },
	{ 0x5f2e, 0x87bc },
	{ 0x5f2f, 0x87ae },
	{ 0x5f30, 0x87c9 },
	{ 0x5f31, 0x87c3 },
	{ 0x5f32, 0x87c2 },
	{ 0x5f33, 0x87cc },
	{ 0x5f34, 0x87b7 },
	{ 0x5f35, 0x87af },
	{ 0x5f36, 0x87c4 },
	{ 0x5f37, 0x87ca },
	{ 0x5f38, 0x87b4 },
	{ 0x5f39, 0x87b6 },
	{ 0x5f3a, 0x87bf },
	{ 0x5f3b, 0x87b8 },
	{ 0x5f3c, 0x87bd },
	{ 0x5f3d, 0x87de },
	{ 0x5f3e, 0x87b2 },
	{ 0x5f3f, 0x8935 },
	{ 0x5f40, 0x8933 },
	{ 0x5f41, 0x893c },
	{ 0x5f42, 0x893e },
	{ 0x5f43, 0x8941 },
	{ 0x5f44, 0x8952 },
	{ 0x5f45, 0x8937 },
	{ 0x5f46, 0x8942 },
	{ 0x5f47, 0x89ad },
	{ 0x5f48, 0x89af },
	{ 0x5f49, 0x89ae },
	{ 0x5f4a, 0x89f2 },
	{ 0x5f4b, 0x89f3 },
	{ 0x5f4c, 0x8b1e },
	{ 0x5f4d, 0x8b18 },
	{ 0x5f4e, 0x8b16 },
	{ 0x5f4f, 0x8b11 },
	{ 0x5f50, 0x8b05 },
	{ 0x5f51, 0x8b0b },
	{ 0x5f52, 0x8b22 },
	{ 0x5f53, 0x8b0f },
	{ 0x5f54, 0x8b12 },
	{ 0x5f55, 0x8b15 },
	{ 0x5f56, 0x8b07 },
	{ 0x5f57, 0x8b0d },
	{ 0x5f58, 0x8b08 },
	{ 0x5f59, 0x8b06 },
	{ 0x5f5a, 0x8b1c },
	{ 0x5f5b, 0x8b13 },
	{ 0x5f5c, 0x8b1a },
	{ 0x5f5d, 0x8c4f },
	{ 0x5f5e, 0x8c70 },
	{ 0x5f5f, 0x8c72 },
	{ 0x5f60, 0x8c71 },
	{ 0x5f61, 0x8c6f },
	{ 0x5f62, 0x8c95 },
	{ 0x5f63, 0x8c94 },
	{ 0x5f64, 0x8cf9 },
	{ 0x5f65, 0x8d6f },
	{ 0x5f66, 0x8e4e },
	{ 0x5f67, 0x8e4d },
	{ 0x5f68, 0x8e53 },
	{ 0x5f69, 0x8e50 },
	{ 0x5f6a, 0x8e4c },
	{ 0x5f6b, 0x8e47 },
	{ 0x5f6c, 0x8f43 },
	{ 0x5f6d, 0x8f40 },
	{ 0x5f6e, 0x9085 },
	{ 0x5f6f, 0x907e },
	{ 0x5f70, 0x9138 },
	{ 0x5f71, 0x919a },
	{ 0x5f72, 0x91a2 },
	{ 0x5f73, 0x919b },
	{ 0x5f74, 0x9199 },
	{ 0x5f75, 0x919f },
	{ 0x5f76, 0x91a1 },
	{ 0x5f77, 0x919d },
	{ 0x5f78, 0x91a0 },
	{ 0x5f79, 0x93a1 },
	{ 0x5f7a, 0x9383 },
	{ 0x5f7b, 0x93af },
	{ 0x5f7c, 0x9364 },
	{ 0x5f7d, 0x9356 },
	{ 0x5f7e, 0x9347 },
	{ 0x6021, 0x937c },
	{ 0x6022, 0x9358 },
	{ 0x6023, 0x935c },
	{ 0x6024, 0x9376 },
	{ 0x6025, 0x9349 },
	{ 0x6026, 0x9350 },
	{ 0x6027, 0x9351 },
	{ 0x6028, 0x9360 },
	{ 0x6029, 0x936d },
	{ 0x602a, 0x938f },
	{ 0x602b, 0x934c },
	{ 0x602c, 0x936a },
	{ 0x602d, 0x9379 },
	{ 0x602e, 0x9357 },
	{ 0x602f, 0x9355 },
	{ 0x6030, 0x9352 },
	{ 0x6031, 0x934f },
	{ 0x6032, 0x9371 },
	{ 0x6033, 0x9377 },
	{ 0x6034, 0x937b },
	{ 0x6035, 0x9361 },
	{ 0x6036, 0x935e },
	{ 0x6037, 0x9363 },
	{ 0x6038, 0x9367 },
	{ 0x6039, 0x934e },
	{ 0x603a, 0x9359 },
	{ 0x603b, 0x95c7 },
	{ 0x603c, 0x95c0 },
	{ 0x603d, 0x95c9 },
	{ 0x603e, 0x95c3 },
	{ 0x603f, 0x95c5 },
	{ 0x6040, 0x95b7 },
	{ 0x6041, 0x96ae },
	{ 0x6042, 0x96b0 },
	{ 0x6043, 0x96ac },
	{ 0x6044, 0x9720 },
	{ 0x6045, 0x971f },
	{ 0x6046, 0x9718 },
	{ 0x6047, 0x971d },
	{ 0x6048, 0x9719 },
	{ 0x6049, 0x979a },
	{ 0x604a, 0x97a1 },
	{ 0x604b, 0x979c },
	{ 0x604c, 0x979e },
	{ 0x604d, 0x979d },
	{ 0x604e, 0x97d5 },
	{ 0x604f, 0x97d4 },
	{ 0x6050, 0x97f1 },
	{ 0x6051, 0x9841 },
	{ 0x6052, 0x9844 },
	{ 0x6053, 0x984a },
	{ 0x6054, 0x9849 },
	{ 0x6055, 0x9845 },
	{ 0x6056, 0x9843 },
	{ 0x6057, 0x9925 },
	{ 0x6058, 0x992b },
	{ 0x6059, 0x992c },
	{ 0x605a, 0x992a },
	{ 0x605b, 0x9933 },
	{ 0x605c, 0x9932 },
	{ 0x605d, 0x992f },
	{ 0x605e, 0x992d },
	{ 0x605f, 0x9931 },
	{ 0x6060, 0x9930 },
	{ 0x6061, 0x9998 },
	{ 0x6062, 0x99a3 },
	{ 0x6063, 0x99a1 },
	{ 0x6064, 0x9a02 },
	{ 0x6065, 0x99fa },
	{ 0x6066, 0x99f4 },
	{ 0x6067, 0x99f7 },
	{ 0x6068, 0x99f9 },
	{ 0x6069, 0x99f8 },
	{ 0x606a, 0x99f6 },
	{ 0x606b, 0x99fb },
	{ 0x606c, 0x99fd },
	{ 0x606d, 0x99fe },
	{ 0x606e, 0x99fc },
	{ 0x606f, 0x9a03 },
	{ 0x6070, 0x9abe },
	{ 0x6071, 0x9afe },
	{ 0x6072, 0x9afd },
	{ 0x6073, 0x9b01 },
	{ 0x6074, 0x9afc },
	{ 0x6075, 0x9b48 },
	{ 0x6076, 0x9b9a },
	{ 0x6077, 0x9ba8 },
	{ 0x6078, 0x9b9e },
	{ 0x6079, 0x9b9b },
	{ 0x607a, 0x9ba6 },
	{ 0x607b, 0x9ba1 },
	{ 0x607c, 0x9ba5 },
	{ 0x607d, 0x9ba4 },
	{ 0x607e, 0x9b86 },
	{ 0x6121, 0x9ba2 },
	{ 0x6122, 0x9ba0 },
	{ 0x6123, 0x9baf },
	{ 0x6124, 0x9d33 },
	{ 0x6125, 0x9d41 },
	{ 0x6126, 0x9d67 },
	{ 0x6127, 0x9d36 },
	{ 0x6128, 0x9d2e },
	{ 0x6129, 0x9d2f },
	{ 0x612a, 0x9d31 },
	{ 0x612b, 0x9d38 },
	{ 0x612c, 0x9d30 },
	{ 0x612d, 0x9d45 },
	{ 0x612e, 0x9d42 },
	{ 0x612f, 0x9d43 },
	{ 0x6130, 0x9d3e },
	{ 0x6131, 0x9d37 },
	{ 0x6132, 0x9d40 },
	{ 0x6133, 0x9d3d },
	{ 0x6134, 0x7ff5 },
	{ 0x6135, 0x9d2d },
	{ 0x6136, 0x9e8a },
	{ 0x6137, 0x9e89 },
	{ 0x6138, 0x9e8d },
	{ 0x6139, 0x9eb0 },
	{ 0x613a, 0x9ec8 },
	{ 0x613b, 0x9eda },
	{ 0x613c, 0x9efb },
	{ 0x613d, 0x9eff },
	{ 0x613e, 0x9f24 },
	{ 0x613f, 0x9f23 },
	{ 0x6140, 0x9f22 },
	{ 0x6141, 0x9f54 },
	{ 0x6142, 0x9fa0 },
	{ 0x6143, 0x5131 },
	{ 0x6144, 0x512d },
	{ 0x6145, 0x512e },
	{ 0x6146, 0x5698 },
	{ 0x6147, 0x569c },
	{ 0x6148, 0x5697 },
	{ 0x6149, 0x569a },
	{ 0x614a, 0x569d },
	{ 0x614b, 0x5699 },
	{ 0x614c, 0x5970 },
	{ 0x614d, 0x5b3c },
	{ 0x614e, 0x5c69 },
	{ 0x614f, 0x5c6a },
	{ 0x6150, 0x5dc0 },
	{ 0x6151, 0x5e6d },
	{ 0x6152, 0x5e6e },
	{ 0x6153, 0x61d8 },
	{ 0x6154, 0x61df },
	{ 0x6155, 0x61ed },
	{ 0x6156, 0x61ee },
	{ 0x6157, 0x61f1 },
	{ 0x6158, 0x61ea },
	{ 0x6159, 0x61f0 },
	{ 0x615a, 0x61eb },
	{ 0x615b, 0x61d6 },
	{ 0x615c, 0x61e9 },
	{ 0x615d, 0x64ff },
	{ 0x615e, 0x6504 },
	{ 0x615f, 0x64fd },
	{ 0x6160, 0x64f8 },
	{ 0x6161, 0x6501 },
	{ 0x6162, 0x6503 },
	{ 0x6163, 0x64fc },
	{ 0x6164, 0x6594 },
	{ 0x6165, 0x65db },
	{ 0x6166, 0x66da },
	{ 0x6167, 0x66db },
	{ 0x6168, 0x66d8 },
	{ 0x6169, 0x6ac5 },
	{ 0x616a, 0x6ab9 },
	{ 0x616b, 0x6abd },
	{ 0x616c, 0x6ae1 },
	{ 0x616d, 0x6ac6 },
	{ 0x616e, 0x6aba },
	{ 0x616f, 0x6ab6 },
	{ 0x6170, 0x6ab7 },
	{ 0x6171, 0x6ac7 },
	{ 0x6172, 0x6ab4 },
	{ 0x6173, 0x6aad },
	{ 0x6174, 0x6b5e },
	{ 0x6175, 0x6bc9 },
	{ 0x6176, 0x6c0b },
	{ 0x6177, 0x7007 },
	{ 0x6178, 0x700c },
	{ 0x6179, 0x700d },
	{ 0x617a, 0x7001 },
	{ 0x617b, 0x7005 },
	{ 0x617c, 0x7014 },
	{ 0x617d, 0x700e },
	{ 0x617e, 0x6fff },
	{ 0x6221, 0x7000 },
	{ 0x6222, 0x6ffb },
	{ 0x6223, 0x7026 },
	{ 0x6224, 0x6ffc },
	{ 0x6225, 0x6ff7 },
	{ 0x6226, 0x700a },
	{ 0x6227, 0x7201 },
	{ 0x6228, 0x71ff },
	{ 0x6229, 0x71f9 },
	{ 0x622a, 0x7203 },
	{ 0x622b, 0x71fd },
	{ 0x622c, 0x7376 },
	{ 0x622d, 0x74b8 },
	{ 0x622e, 0x74c0 },
	{ 0x622f, 0x74b5 },
	{ 0x6230, 0x74c1 },
	{ 0x6231, 0x74be },
	{ 0x6232, 0x74b6 },
	{ 0x6233, 0x74bb },
	{ 0x6234, 0x74c2 },
	{ 0x6235, 0x7514 },
	{ 0x6236, 0x7513 },
	{ 0x6237, 0x765c },
	{ 0x6238, 0x7664 },
	{ 0x6239, 0x7659 },
	{ 0x623a, 0x7650 },
	{ 0x623b, 0x7653 },
	{ 0x623c, 0x7657 },
	{ 0x623d, 0x765a },
	{ 0x623e, 0x76a6 },
	{ 0x623f, 0x76bd },
	{ 0x6240, 0x76ec },
	{ 0x6241, 0x77c2 },
	{ 0x6242, 0x77ba },
	{ 0x6243, 0x790c },
	{ 0x6244, 0x7913 },
	{ 0x6245, 0x7914 },
	{ 0x6246, 0x7909 },
	{ 0x6247, 0x7910 },
	{ 0x6248, 0x7912 },
	{ 0x6249, 0x7911 },
	{ 0x624a, 0x79ad },
	{ 0x624b, 0x79ac },
	{ 0x624c, 0x7a5f },
	{ 0x624d, 0x7c1c },
	{ 0x624e, 0x7c29 },
	{ 0x624f, 0x7c19 },
	{ 0x6250, 0x7c20 },
	{ 0x6251, 0x7c1f },
	{ 0x6252, 0x7c2d },
	{ 0x6253, 0x7c1d },
	{ 0x6254, 0x7c26 },
	{ 0x6255, 0x7c28 },
	{ 0x6256, 0x7c22 },
	{ 0x6257, 0x7c25 },
	{ 0x6258, 0x7c30 },
	{ 0x6259, 0x7e5c },
	{ 0x625a, 0x7e50 },
	{ 0x625b, 0x7e56 },
	{ 0x625c, 0x7e63 },
	{ 0x625d, 0x7e58 },
	{ 0x625e, 0x7e62 },
	{ 0x625f, 0x7e5f },
	{ 0x6260, 0x7e51 },
	{ 0x6261, 0x7e60 },
	{ 0x6262, 0x7e57 },
	{ 0x6263, 0x7e53 },
	{ 0x6264, 0x7fb5 },
	{ 0x6265, 0x7fb3 },
	{ 0x6266, 0x7ff7 },
	{ 0x6267, 0x7ff8 },
	{ 0x6268, 0x8075 },
	{ 0x6269, 0x81d1 },
	{ 0x626a, 0x81d2 },
	{ 0x626b, 0x81d0 },
	{ 0x626c, 0x825f },
	{ 0x626d, 0x825e },
	{ 0x626e, 0x85b4 },
	{ 0x626f, 0x85c6 },
	{ 0x6270, 0x85c0 },
	{ 0x6271, 0x85c3 },
	{ 0x6272, 0x85c2 },
	{ 0x6273, 0x85b3 },
	{ 0x6274, 0x85b5 },
	{ 0x6275, 0x85bd },
	{ 0x6276, 0x85c7 },
	{ 0x6277, 0x85c4 },
	{ 0x6278, 0x85bf },
	{ 0x6279, 0x85cb },
	{ 0x627a, 0x85ce },
	{ 0x627b, 0x85c8 },
	{ 0x627c, 0x85c5 },
	{ 0x627d, 0x85b1 },
	{ 0x627e, 0x85b6 },
	{ 0x6321, 0x85d2 },
	{ 0x6322, 0x8624 },
	{ 0x6323, 0x85b8 },
	{ 0x6324, 0x85b7 },
	{ 0x6325, 0x85be },
	{ 0x6326, 0x8669 },
	{ 0x6327, 0x87e7 },
	{ 0x6328, 0x87e6 },
	{ 0x6329, 0x87e2 },
	{ 0x632a, 0x87db },
	{ 0x632b, 0x87eb },
	{ 0x632c, 0x87ea },
	{ 0x632d, 0x87e5 },
	{ 0x632e, 0x87df },
	{ 0x632f, 0x87f3 },
	{ 0x6330, 0x87e4 },
	{ 0x6331, 0x87d4 },
	{ 0x6332, 0x87dc },
	{ 0x6333, 0x87d3 },
	{ 0x6334, 0x87ed },
	{ 0x6335, 0x87d8 },
	{ 0x6336, 0x87e3 },
	{ 0x6337, 0x87d7 },
	{ 0x6338, 0x87d9 },
	{ 0x6339, 0x8801 },
	{ 0x633a, 0x87f4 },
	{ 0x633b, 0x87e8 },
	{ 0x633c, 0x87dd },
	{ 0x633d, 0x8953 },
	{ 0x633e, 0x894b },
	{ 0x633f, 0x894f },
	{ 0x6340, 0x894c },
	{ 0x6341, 0x8946 },
	{ 0x6342, 0x8950 },
	{ 0x6343, 0x8951 },
	{ 0x6344, 0x8949 },
	{ 0x6345, 0x8b2a },
	{ 0x6346, 0x8b27 },
	{ 0x6347, 0x8b23 },
	{ 0x6348, 0x8b33 },
	{ 0x6349, 0x8b30 },
	{ 0x634a, 0x8b35 },
	{ 0x634b, 0x8b47 },
	{ 0x634c, 0x8b2f },
	{ 0x634d, 0x8b3c },
	{ 0x634e, 0x8b3e },
	{ 0x634f, 0x8b31 },
	{ 0x6350, 0x8b25 },
	{ 0x6351, 0x8b37 },
	{ 0x6352, 0x8b26 },
	{ 0x6353, 0x8b36 },
	{ 0x6354, 0x8b2e },
	{ 0x6355, 0x8b24 },
	{ 0x6356, 0x8b3b },
	{ 0x6357, 0x8b3d },
	{ 0x6358, 0x8b3a },
	{ 0x6359, 0x8c42 },
	{ 0x635a, 0x8c75 },
	{ 0x635b, 0x8c99 },
	{ 0x635c, 0x8c98 },
	{ 0x635d, 0x8c97 },
	{ 0x635e, 0x8cfe },
	{ 0x635f, 0x8d04 },
	{ 0x6360, 0x8d02 },
	{ 0x6361, 0x8d00 },
	{ 0x6362, 0x8e5c },
	{ 0x6363, 0x8e62 },
	{ 0x6364, 0x8e60 },
	{ 0x6365, 0x8e57 },
	{ 0x6366, 0x8e56 },
	{ 0x6367, 0x8e5e },
	{ 0x6368, 0x8e65 },
	{ 0x6369, 0x8e67 },
	{ 0x636a, 0x8e5b },
	{ 0x636b, 0x8e5a },
	{ 0x636c, 0x8e61 },
	{ 0x636d, 0x8e5d },
	{ 0x636e, 0x8e69 },
	{ 0x636f, 0x8e54 },
	{ 0x6370, 0x8f46 },
	{ 0x6371, 0x8f47 },
	{ 0x6372, 0x8f48 },
	{ 0x6373, 0x8f4b },
	{ 0x6374, 0x9128 },
	{ 0x6375, 0x913a },
	{ 0x6376, 0x913b },
	{ 0x6377, 0x913e },
	{ 0x6378, 0x91a8 },
	{ 0x6379, 0x91a5 },
	{ 0x637a, 0x91a7 },
	{ 0x637b, 0x91af },
	{ 0x637c, 0x91aa },
	{ 0x637d, 0x93b5 },
	{ 0x637e, 0x938c },
	{ 0x6421, 0x9392 },
	{ 0x6422, 0x93b7 },
	{ 0x6423, 0x939b },
	{ 0x6424, 0x939d },
	{ 0x6425, 0x9389 },
	{ 0x6426, 0x93a7 },
	{ 0x6427, 0x938e },
	{ 0x6428, 0x93aa },
	{ 0x6429, 0x939e },
	{ 0x642a, 0x93a6 },
	{ 0x642b, 0x9395 },
	{ 0x642c, 0x9388 },
	{ 0x642d, 0x9399 },
	{ 0x642e, 0x939f },
	{ 0x642f, 0x9380 },
	{ 0x6430, 0x938d },
	{ 0x6431, 0x93b1 },
	{ 0x6432, 0x9391 },
	{ 0x6433, 0x93b2 },
	{ 0x6434, 0x93a4 },
	{ 0x6435, 0x93a8 },
	{ 0x6436, 0x93b4 },
	{ 0x6437, 0x93a3 },
	{ 0x6438, 0x95d2 },
	{ 0x6439, 0x95d3 },
	{ 0x643a, 0x95d1 },
	{ 0x643b, 0x96b3 },
	{ 0x643c, 0x96d7 },
	{ 0x643d, 0x96da },
	{ 0x643e, 0x5dc2 },
	{ 0x643f, 0x96df },
	{ 0x6440, 0x96d8 },
	{ 0x6441, 0x96dd },
	{ 0x6442, 0x9723 },
	{ 0x6443, 0x9722 },
	{ 0x6444, 0x9725 },
	{ 0x6445, 0x97ac },
	{ 0x6446, 0x97ae },
	{ 0x6447, 0x97a8 },
	{ 0x6448, 0x97ab },
	{ 0x6449, 0x97a4 },
	{ 0x644a, 0x97aa },
	{ 0x644b, 0x97a2 },
	{ 0x644c, 0x97a5 },
	{ 0x644d, 0x97d7 },
	{ 0x644e, 0x97d9 },
	{ 0x644f, 0x97d6 },
	{ 0x6450, 0x97d8 },
	{ 0x6451, 0x97fa },
	{ 0x6452, 0x9850 },
	{ 0x6453, 0x9851 },
	{ 0x6454, 0x9852 },
	{ 0x6455, 0x98b8 },
	{ 0x6456, 0x9941 },
	{ 0x6457, 0x993c },
	{ 0x6458, 0x993a },
	{ 0x6459, 0x9a0f },
	{ 0x645a, 0x9a0b },
	{ 0x645b, 0x9a09 },
	{ 0x645c, 0x9a0d },
	{ 0x645d, 0x9a04 },
	{ 0x645e, 0x9a11 },
	{ 0x645f, 0x9a0a },
	{ 0x6460, 0x9a05 },
	{ 0x6461, 0x9a07 },
	{ 0x6462, 0x9a06 },
	{ 0x6463, 0x9ac0 },
	{ 0x6464, 0x9adc },
	{ 0x6465, 0x9b08 },
	{ 0x6466, 0x9b04 },
	{ 0x6467, 0x9b05 },
	{ 0x6468, 0x9b29 },
	{ 0x6469, 0x9b35 },
	{ 0x646a, 0x9b4a },
	{ 0x646b, 0x9b4c },
	{ 0x646c, 0x9b4b },
	{ 0x646d, 0x9bc7 },
	{ 0x646e, 0x9bc6 },
	{ 0x646f, 0x9bc3 },
	{ 0x6470, 0x9bbf },
	{ 0x6471, 0x9bc1 },
	{ 0x6472, 0x9bb5 },
	{ 0x6473, 0x9bb8 },
	{ 0x6474, 0x9bd3 },
	{ 0x6475, 0x9bb6 },
	{ 0x6476, 0x9bc4 },
	{ 0x6477, 0x9bb9 },
	{ 0x6478, 0x9bbd },
	{ 0x6479, 0x9d5c },
	{ 0x647a, 0x9d53 },
	{ 0x647b, 0x9d4f },
	{ 0x647c, 0x9d4a },
	{ 0x647d, 0x9d5b },
	{ 0x647e, 0x9d4b },
	{ 0x6521, 0x9d59 },
	{ 0x6522, 0x9d56 },
	{ 0x6523, 0x9d4c },
	{ 0x6524, 0x9d57 },
	{ 0x6525, 0x9d52 },
	{ 0x6526, 0x9d54 },
	{ 0x6527, 0x9d5f },
	{ 0x6528, 0x9d58 },
	{ 0x6529, 0x9d5a },
	{ 0x652a, 0x9e8e },
	{ 0x652b, 0x9e8c },
	{ 0x652c, 0x9edf },
	{ 0x652d, 0x9f01 },
	{ 0x652e, 0x9f00 },
	{ 0x652f, 0x9f16 },
	{ 0x6530, 0x9f25 },
	{ 0x6531, 0x9f2b },
	{ 0x6532, 0x9f2a },
	{ 0x6533, 0x9f29 },
	{ 0x6534, 0x9f28 },
	{ 0x6535, 0x9f4c },
	{ 0x6536, 0x9f55 },
	{ 0x6537, 0x5134 },
	{ 0x6538, 0x5135 },
	{ 0x6539, 0x5296 },
	{ 0x653a, 0x52f7 },
	{ 0x653b, 0x53b4 },
	{ 0x653c, 0x56ab },
	{ 0x653d, 0x56ad },
	{ 0x653e, 0x56a6 },
	{ 0x653f, 0x56a7 },
	{ 0x6540, 0x56aa },
	{ 0x6541, 0x56ac },
	{ 0x6542, 0x58da },
	{ 0x6543, 0x58dd },
	{ 0x6544, 0x58db },
	{ 0x6545, 0x5912 },
	{ 0x6546, 0x5b3d },
	{ 0x6547, 0x5b3e },
	{ 0x6548, 0x5b3f },
	{ 0x6549, 0x5dc3 },
	{ 0x654a, 0x5e70 },
	{ 0x654b, 0x5fbf },
	{ 0x654c, 0x61fb },
	{ 0x654d, 0x6507 },
	{ 0x654e, 0x6510 },
	{ 0x654f, 0x650d },
	{ 0x6550, 0x6509 },
	{ 0x6551, 0x650c },
	{ 0x6552, 0x650e },
	{ 0x6553, 0x6584 },
	{ 0x6554, 0x65de },
	{ 0x6555, 0x65dd },
	{ 0x6556, 0x66de },
	{ 0x6557, 0x6ae7 },
	{ 0x6558, 0x6ae0 },
	{ 0x6559, 0x6acc },
	{ 0x655a, 0x6ad1 },
	{ 0x655b, 0x6ad9 },
	{ 0x655c, 0x6acb },
	{ 0x655d, 0x6adf },
	{ 0x655e, 0x6adc },
	{ 0x655f, 0x6ad0 },
	{ 0x6560, 0x6aeb },
	{ 0x6561, 0x6acf },
	{ 0x6562, 0x6acd },
	{ 0x6563, 0x6ade },
	{ 0x6564, 0x6b60 },
	{ 0x6565, 0x6bb0 },
	{ 0x6566, 0x6c0c },
	{ 0x6567, 0x7019 },
	{ 0x6568, 0x7027 },
	{ 0x6569, 0x7020 },
	{ 0x656a, 0x7016 },
	{ 0x656b, 0x702b },
	{ 0x656c, 0x7021 },
	{ 0x656d, 0x7022 },
	{ 0x656e, 0x7023 },
	{ 0x656f, 0x7029 },
	{ 0x6570, 0x7017 },
	{ 0x6571, 0x7024 },
	{ 0x6572, 0x701c },
	{ 0x6573, 0x720c },
	{ 0x6574, 0x720a },
	{ 0x6575, 0x7207 },
	{ 0x6576, 0x7202 },
	{ 0x6577, 0x7205 },
	{ 0x6578, 0x72a5 },
	{ 0x6579, 0x72a6 },
	{ 0x657a, 0x72a4 },
	{ 0x657b, 0x72a3 },
	{ 0x657c, 0x72a1 },
	{ 0x657d, 0x74cb },
	{ 0x657e, 0x74c5 },
	{ 0x6621, 0x74b7 },
	{ 0x6622, 0x74c3 },
	{ 0x6623, 0x7516 },
	{ 0x6624, 0x7660 },
	{ 0x6625, 0x77c9 },
	{ 0x6626, 0x77ca },
	{ 0x6627, 0x77c4 },
	{ 0x6628, 0x77f1 },
	{ 0x6629, 0x791d },
	{ 0x662a, 0x791b },
	{ 0x662b, 0x7921 },
	{ 0x662c, 0x791c },
	{ 0x662d, 0x7917 },
	{ 0x662e, 0x791e },
	{ 0x662f, 0x79b0 },
	{ 0x6630, 0x7a67 },
	{ 0x6631, 0x7a68 },
	{ 0x6632, 0x7c33 },
	{ 0x6633, 0x7c3c },
	{ 0x6634, 0x7c39 },
	{ 0x6635, 0x7c2c },
	{ 0x6636, 0x7c3b },
	{ 0x6637, 0x7cec },
	{ 0x6638, 0x7cea },
	{ 0x6639, 0x7e76 },
	{ 0x663a, 0x7e75 },
	{ 0x663b, 0x7e78 },
	{ 0x663c, 0x7e70 },
	{ 0x663d, 0x7e77 },
	{ 0x663e, 0x7e6f },
	{ 0x663f, 0x7e7a },
	{ 0x6640, 0x7e72 },
	{ 0x6641, 0x7e74 },
	{ 0x6642, 0x7e68 },
	{ 0x6643, 0x7f4b },
	{ 0x6644, 0x7f4a },
	{ 0x6645, 0x7f83 },
	{ 0x6646, 0x7f86 },
	{ 0x6647, 0x7fb7 },
	{ 0x6648, 0x7ffd },
	{ 0x6649, 0x7ffe },
	{ 0x664a, 0x8078 },
	{ 0x664b, 0x81d7 },
	{ 0x664c, 0x81d5 },
	{ 0x664d, 0x820b },
	{ 0x664e, 0x8264 },
	{ 0x664f, 0x8261 },
	{ 0x6650, 0x8263 },
	{ 0x6651, 0x85eb },
	{ 0x6652, 0x85f1 },
	{ 0x6653, 0x85ed },
	{ 0x6654, 0x85d9 },
	{ 0x6655, 0x85e1 },
	{ 0x6656, 0x85e8 },
	{ 0x6657, 0x85da },
	{ 0x6658, 0x85d7 },
	{ 0x6659, 0x85ec },
	{ 0x665a, 0x85f2 },
	{ 0x665b, 0x85f8 },
	{ 0x665c, 0x85d8 },
	{ 0x665d, 0x85df },
	{ 0x665e, 0x85e3 },
	{ 0x665f, 0x85dc },
	{ 0x6660, 0x85d1 },
	{ 0x6661, 0x85f0 },
	{ 0x6662, 0x85e6 },
	{ 0x6663, 0x85ef },
	{ 0x6664, 0x85de },
	{ 0x6665, 0x85e2 },
	{ 0x6666, 0x8800 },
	{ 0x6667, 0x87fa },
	{ 0x6668, 0x8803 },
	{ 0x6669, 0x87f6 },
	{ 0x666a, 0x87f7 },
	{ 0x666b, 0x8809 },
	{ 0x666c, 0x880c },
	{ 0x666d, 0x880b },
	{ 0x666e, 0x8806 },
	{ 0x666f, 0x87fc },
	{ 0x6670, 0x8808 },
	{ 0x6671, 0x87ff },
	{ 0x6672, 0x880a },
	{ 0x6673, 0x8802 },
	{ 0x6674, 0x8962 },
	{ 0x6675, 0x895a },
	{ 0x6676, 0x895b },
	{ 0x6677, 0x8957 },
	{ 0x6678, 0x8961 },
	{ 0x6679, 0x895c },
	{ 0x667a, 0x8958 },
	{ 0x667b, 0x895d },
	{ 0x667c, 0x8959 },
	{ 0x667d, 0x8988 },
	{ 0x667e, 0x89b7 },
	{ 0x6721, 0x89b6 },
	{ 0x6722, 0x89f6 },
	{ 0x6723, 0x8b50 },
	{ 0x6724, 0x8b48 },
	{ 0x6725, 0x8b4a },
	{ 0x6726, 0x8b40 },
	{ 0x6727, 0x8b53 },
	{ 0x6728, 0x8b56 },
	{ 0x6729, 0x8b54 },
	{ 0x672a, 0x8b4b },
	{ 0x672b, 0x8b55 },
	{ 0x672c, 0x8b51 },
	{ 0x672d, 0x8b42 },
	{ 0x672e, 0x8b52 },
	{ 0x672f, 0x8b57 },
	{ 0x6730, 0x8c43 },
	{ 0x6731, 0x8c77 },
	{ 0x6732, 0x8c76 },
	{ 0x6733, 0x8c9a },
	{ 0x6734, 0x8d06 },
	{ 0x6735, 0x8d07 },
	{ 0x6736, 0x8d09 },
	{ 0x6737, 0x8dac },
	{ 0x6738, 0x8daa },
	{ 0x6739, 0x8dad },
	{ 0x673a, 0x8dab },
	{ 0x673b, 0x8e6d },
	{ 0x673c, 0x8e78 },
	{ 0x673d, 0x8e73 },
	{ 0x673e, 0x8e6a },
	{ 0x673f, 0x8e6f },
	{ 0x6740, 0x8e7b },
	{ 0x6741, 0x8ec2 },
	{ 0x6742, 0x8f52 },
	{ 0x6743, 0x8f51 },
	{ 0x6744, 0x8f4f },
	{ 0x6745, 0x8f50 },
	{ 0x6746, 0x8f53 },
	{ 0x6747, 0x8fb4 },
	{ 0x6748, 0x9140 },
	{ 0x6749, 0x913f },
	{ 0x674a, 0x91b0 },
	{ 0x674b, 0x91ad },
	{ 0x674c, 0x93de },
	{ 0x674d, 0x93c7 },
	{ 0x674e, 0x93cf },
	{ 0x674f, 0x93c2 },
	{ 0x6750, 0x93da },
	{ 0x6751, 0x93d0 },
	{ 0x6752, 0x93f9 },
	{ 0x6753, 0x93ec },
	{ 0x6754, 0x93cc },
	{ 0x6755, 0x93d9 },
	{ 0x6756, 0x93a9 },
	{ 0x6757, 0x93e6 },
	{ 0x6758, 0x93ca },
	{ 0x6759, 0x93d4 },
	{ 0x675a, 0x93ee },
	{ 0x675b, 0x93e3 },
	{ 0x675c, 0x93d5 },
	{ 0x675d, 0x93c4 },
	{ 0x675e, 0x93ce },
	{ 0x675f, 0x93c0 },
	{ 0x6760, 0x93d2 },
	{ 0x6761, 0x93a5 },
	{ 0x6762, 0x93e7 },
	{ 0x6763, 0x957d },
	{ 0x6764, 0x95da },
	{ 0x6765, 0x95db },
	{ 0x6766, 0x96e1 },
	{ 0x6767, 0x9729 },
	{ 0x6768, 0x972b },
	{ 0x6769, 0x972c },
	{ 0x676a, 0x9728 },
	{ 0x676b, 0x9726 },
	{ 0x676c, 0x97b3 },
	{ 0x676d, 0x97b7 },
	{ 0x676e, 0x97b6 },
	{ 0x676f, 0x97dd },
	{ 0x6770, 0x97de },
	{ 0x6771, 0x97df },
	{ 0x6772, 0x985c },
	{ 0x6773, 0x9859 },
	{ 0x6774, 0x985d },
	{ 0x6775, 0x9857 },
	{ 0x6776, 0x98bf },
	{ 0x6777, 0x98bd },
	{ 0x6778, 0x98bb },
	{ 0x6779, 0x98be },
	{ 0x677a, 0x9948 },
	{ 0x677b, 0x9947 },
	{ 0x677c, 0x9943 },
	{ 0x677d, 0x99a6 },
	{ 0x677e, 0x99a7 },
	{ 0x6821, 0x9a1a },
	{ 0x6822, 0x9a15 },
	{ 0x6823, 0x9a25 },
	{ 0x6824, 0x9a1d },
	{ 0x6825, 0x9a24 },
	{ 0x6826, 0x9a1b },
	{ 0x6827, 0x9a22 },
	{ 0x6828, 0x9a20 },
	{ 0x6829, 0x9a27 },
	{ 0x682a, 0x9a23 },
	{ 0x682b, 0x9a1e },
	{ 0x682c, 0x9a1c },
	{ 0x682d, 0x9a14 },
	{ 0x682e, 0x9ac2 },
	{ 0x682f, 0x9b0b },
	{ 0x6830, 0x9b0a },
	{ 0x6831, 0x9b0e },
	{ 0x6832, 0x9b0c },
	{ 0x6833, 0x9b37 },
	{ 0x6834, 0x9bea },
	{ 0x6835, 0x9beb },
	{ 0x6836, 0x9be0 },
	{ 0x6837, 0x9bde },
	{ 0x6838, 0x9be4 },
	{ 0x6839, 0x9be6 },
	{ 0x683a, 0x9be2 },
	{ 0x683b, 0x9bf0 },
	{ 0x683c, 0x9bd4 },
	{ 0x683d, 0x9bd7 },
	{ 0x683e, 0x9bec },
	{ 0x683f, 0x9bdc },
	{ 0x6840, 0x9bd9 },
	{ 0x6841, 0x9be5 },
	{ 0x6842, 0x9bd5 },
	{ 0x6843, 0x9be1 },
	{ 0x6844, 0x9bda },
	{ 0x6845, 0x9d77 },
	{ 0x6846, 0x9d81 },
	{ 0x6847, 0x9d8a },
	{ 0x6848, 0x9d84 },
	{ 0x6849, 0x9d88 },
	{ 0x684a, 0x9d71 },
	{ 0x684b, 0x9d80 },
	{ 0x684c, 0x9d78 },
	{ 0x684d, 0x9d86 },
	{ 0x684e, 0x9d8b },
	{ 0x684f, 0x9d8c },
	{ 0x6850, 0x9d7d },
	{ 0x6851, 0x9d6b },
	{ 0x6852, 0x9d74 },
	{ 0x6853, 0x9d75 },
	{ 0x6854, 0x9d70 },
	{ 0x6855, 0x9d69 },
	{ 0x6856, 0x9d85 },
	{ 0x6857, 0x9d73 },
	{ 0x6858, 0x9d7b },
	{ 0x6859, 0x9d82 },
	{ 0x685a, 0x9d6f },
	{ 0x685b, 0x9d79 },
	{ 0x685c, 0x9d7f },
	{ 0x685d, 0x9d87 },
	{ 0x685e, 0x9d68 },
	{ 0x685f, 0x9e94 },
	{ 0x6860, 0x9e91 },
	{ 0x6861, 0x9ec0 },
	{ 0x6862, 0x9efc },
	{ 0x6863, 0x9f2d },
	{ 0x6864, 0x9f40 },
	{ 0x6865, 0x9f41 },
	{ 0x6866, 0x9f4d },
	{ 0x6867, 0x9f56 },
	{ 0x6868, 0x9f57 },
	{ 0x6869, 0x9f58 },
	{ 0x686a, 0x5337 },
	{ 0x686b, 0x56b2 },
	{ 0x686c, 0x56b5 },
	{ 0x686d, 0x56b3 },
	{ 0x686e, 0x58e3 },
	{ 0x686f, 0x5b45 },
	{ 0x6870, 0x5dc6 },
	{ 0x6871, 0x5dc7 },
	{ 0x6872, 0x5eee },
	{ 0x6873, 0x5eef },
	{ 0x6874, 0x5fc0 },
	{ 0x6875, 0x5fc1 },
	{ 0x6876, 0x61f9 },
	{ 0x6877, 0x6517 },
	{ 0x6878, 0x6516 },
	{ 0x6879, 0x6515 },
	{ 0x687a, 0x6513 },
	{ 0x687b, 0x65df },
	{ 0x687c, 0x66e8 },
	{ 0x687d, 0x66e3 },
	{ 0x687e, 0x66e4 },
	{ 0x6921, 0x6af3 },
	{ 0x6922, 0x6af0 },
	{ 0x6923, 0x6aea },
	{ 0x6924, 0x6ae8 },
	{ 0x6925, 0x6af9 },
	{ 0x6926, 0x6af1 },
	{ 0x6927, 0x6aee },
	{ 0x6928, 0x6aef },
	{ 0x6929, 0x703c },
	{ 0x692a, 0x7035 },
	{ 0x692b, 0x702f },
	{ 0x692c, 0x7037 },
	{ 0x692d, 0x7034 },
	{ 0x692e, 0x7031 },
	{ 0x692f, 0x7042 },
	{ 0x6930, 0x7038 },
	{ 0x6931, 0x703f },
	{ 0x6932, 0x703a },
	{ 0x6933, 0x7039 },
	{ 0x6934, 0x702a },
	{ 0x6935, 0x7040 },
	{ 0x6936, 0x703b },
	{ 0x6937, 0x7033 },
	{ 0x6938, 0x7041 },
	{ 0x6939, 0x7213 },
	{ 0x693a, 0x7214 },
	{ 0x693b, 0x72a8 },
	{ 0x693c, 0x737d },
	{ 0x693d, 0x737c },
	{ 0x693e, 0x74ba },
	{ 0x693f, 0x76ab },
	{ 0x6940, 0x76aa },
	{ 0x6941, 0x76be },
	{ 0x6942, 0x76ed },
	{ 0x6943, 0x77cc },
	{ 0x6944, 0x77ce },
	{ 0x6945, 0x77cf },
	{ 0x6946, 0x77cd },
	{ 0x6947, 0x77f2 },
	{ 0x6948, 0x7925 },
	{ 0x6949, 0x7923 },
	{ 0x694a, 0x7927 },
	{ 0x694b, 0x7928 },
	{ 0x694c, 0x7924 },
	{ 0x694d, 0x7929 },
	{ 0x694e, 0x79b2 },
	{ 0x694f, 0x7a6e },
	{ 0x6950, 0x7a6c },
	{ 0x6951, 0x7a6d },
	{ 0x6952, 0x7af7 },
	{ 0x6953, 0x7c49 },
	{ 0x6954, 0x7c48 },
	{ 0x6955, 0x7c4a },
	{ 0x6956, 0x7c47 },
	{ 0x6957, 0x7c45 },
	{ 0x6958, 0x7cee },
	{ 0x6959, 0x7e7b },
	{ 0x695a, 0x7e7e },
	{ 0x695b, 0x7e81 },
	{ 0x695c, 0x7e80 },
	{ 0x695d, 0x7fba },
	{ 0x695e, 0x7fff },
	{ 0x695f, 0x8079 },
	{ 0x6960, 0x81db },
	{ 0x6961, 0x81d9 },
	{ 0x6962, 0x8268 },
	{ 0x6963, 0x8269 },
	{ 0x6964, 0x8622 },
	{ 0x6965, 0x85ff },
	{ 0x6966, 0x8601 },
	{ 0x6967, 0x85fe },
	{ 0x6968, 0x861b },
	{ 0x6969, 0x8600 },
	{ 0x696a, 0x85f6 },
	{ 0x696b, 0x8604 },
	{ 0x696c, 0x8609 },
	{ 0x696d, 0x8605 },
	{ 0x696e, 0x860c },
	{ 0x696f, 0x85fd },
	{ 0x6970, 0x8819 },
	{ 0x6971, 0x8810 },
	{ 0x6972, 0x8811 },
	{ 0x6973, 0x8817 },
	{ 0x6974, 0x8813 },
	{ 0x6975, 0x8816 },
	{ 0x6976, 0x8963 },
	{ 0x6977, 0x8966 },
	{ 0x6978, 0x89b9 },
	{ 0x6979, 0x89f7 },
	{ 0x697a, 0x8b60 },
	{ 0x697b, 0x8b6a },
	{ 0x697c, 0x8b5d },
	{ 0x697d, 0x8b68 },
	{ 0x697e, 0x8b63 },
	{ 0x6a21, 0x8b65 },
	{ 0x6a22, 0x8b67 },
	{ 0x6a23, 0x8b6d },
	{ 0x6a24, 0x8dae },
	{ 0x6a25, 0x8e86 },
	{ 0x6a26, 0x8e88 },
	{ 0x6a27, 0x8e84 },
	{ 0x6a28, 0x8f59 },
	{ 0x6a29, 0x8f56 },
	{ 0x6a2a, 0x8f57 },
	{ 0x6a2b, 0x8f55 },
	{ 0x6a2c, 0x8f58 },
	{ 0x6a2d, 0x8f5a },
	{ 0x6a2e, 0x908d },
	{ 0x6a2f, 0x9143 },
	{ 0x6a30, 0x9141 },
	{ 0x6a31, 0x91b7 },
	{ 0x6a32, 0x91b5 },
	{ 0x6a33, 0x91b2 },
	{ 0x6a34, 0x91b3 },
	{ 0x6a35, 0x940b },
	{ 0x6a36, 0x9413 },
	{ 0x6a37, 0x93fb },
	{ 0x6a38, 0x9420 },
	{ 0x6a39, 0x940f },
	{ 0x6a3a, 0x9414 },
	{ 0x6a3b, 0x93fe },
	{ 0x6a3c, 0x9415 },
	{ 0x6a3d, 0x9410 },
	{ 0x6a3e, 0x9428 },
	{ 0x6a3f, 0x9419 },
	{ 0x6a40, 0x940d },
	{ 0x6a41, 0x93f5 },
	{ 0x6a42, 0x9400 },
	{ 0x6a43, 0x93f7 },
	{ 0x6a44, 0x9407 },
	{ 0x6a45, 0x940e },
	{ 0x6a46, 0x9416 },
	{ 0x6a47, 0x9412 },
	{ 0x6a48, 0x93fa },
	{ 0x6a49, 0x9409 },
	{ 0x6a4a, 0x93f8 },
	{ 0x6a4b, 0x943c },
	{ 0x6a4c, 0x940a },
	{ 0x6a4d, 0x93ff },
	{ 0x6a4e, 0x93fc },
	{ 0x6a4f, 0x940c },
	{ 0x6a50, 0x93f6 },
	{ 0x6a51, 0x9411 },
	{ 0x6a52, 0x9406 },
	{ 0x6a53, 0x95de },
	{ 0x6a54, 0x95e0 },
	{ 0x6a55, 0x95df },
	{ 0x6a56, 0x972e },
	{ 0x6a57, 0x972f },
	{ 0x6a58, 0x97b9 },
	{ 0x6a59, 0x97bb },
	{ 0x6a5a, 0x97fd },
	{ 0x6a5b, 0x97fe },
	{ 0x6a5c, 0x9860 },
	{ 0x6a5d, 0x9862 },
	{ 0x6a5e, 0x9863 },
	{ 0x6a5f, 0x985f },
	{ 0x6a60, 0x98c1 },
	{ 0x6a61, 0x98c2 },
	{ 0x6a62, 0x9950 },
	{ 0x6a63, 0x994e },
	{ 0x6a64, 0x9959 },
	{ 0x6a65, 0x994c },
	{ 0x6a66, 0x994b },
	{ 0x6a67, 0x9953 },
	{ 0x6a68, 0x9a32 },
	{ 0x6a69, 0x9a34 },
	{ 0x6a6a, 0x9a31 },
	{ 0x6a6b, 0x9a2c },
	{ 0x6a6c, 0x9a2a },
	{ 0x6a6d, 0x9a36 },
	{ 0x6a6e, 0x9a29 },
	{ 0x6a6f, 0x9a2e },
	{ 0x6a70, 0x9a38 },
	{ 0x6a71, 0x9a2d },
	{ 0x6a72, 0x9ac7 },
	{ 0x6a73, 0x9aca },
	{ 0x6a74, 0x9ac6 },
	{ 0x6a75, 0x9b10 },
	{ 0x6a76, 0x9b12 },
	{ 0x6a77, 0x9b11 },
	{ 0x6a78, 0x9c0b },
	{ 0x6a79, 0x9c08 },
	{ 0x6a7a, 0x9bf7 },
	{ 0x6a7b, 0x9c05 },
	{ 0x6a7c, 0x9c12 },
	{ 0x6a7d, 0x9bf8 },
	{ 0x6a7e, 0x9c40 },
	{ 0x6b21, 0x9c07 },
	{ 0x6b22, 0x9c0e },
	{ 0x6b23, 0x9c06 },
	{ 0x6b24, 0x9c17 },
	{ 0x6b25, 0x9c14 },
	{ 0x6b26, 0x9c09 },
	{ 0x6b27, 0x9d9f },
	{ 0x6b28, 0x9d99 },
	{ 0x6b29, 0x9da4 },
	{ 0x6b2a, 0x9d9d },
	{ 0x6b2b, 0x9d92 },
	{ 0x6b2c, 0x9d98 },
	{ 0x6b2d, 0x9d90 },
	{ 0x6b2e, 0x9d9b },
	{ 0x6b2f, 0x9da0 },
	{ 0x6b30, 0x9d94 },
	{ 0x6b31, 0x9d9c },
	{ 0x6b32, 0x9daa },
	{ 0x6b33, 0x9d97 },
	{ 0x6b34, 0x9da1 },
	{ 0x6b35, 0x9d9a },
	{ 0x6b36, 0x9da2 },
	{ 0x6b37, 0x9da8 },
	{ 0x6b38, 0x9d9e },
	{ 0x6b39, 0x9da3 },
	{ 0x6b3a, 0x9dbf },
	{ 0x6b3b, 0x9da9 },
	{ 0x6b3c, 0x9d96 },
	{ 0x6b3d, 0x9da6 },
	{ 0x6b3e, 0x9da7 },
	{ 0x6b3f, 0x9e99 },
	{ 0x6b40, 0x9e9b },
	{ 0x6b41, 0x9e9a },
	{ 0x6b42, 0x9ee5 },
	{ 0x6b43, 0x9ee4 },
	{ 0x6b44, 0x9ee7 },
	{ 0x6b45, 0x9ee6 },
	{ 0x6b46, 0x9f30 },
	{ 0x6b47, 0x9f2e },
	{ 0x6b48, 0x9f5b },
	{ 0x6b49, 0x9f60 },
	{ 0x6b4a, 0x9f5e },
	{ 0x6b4b, 0x9f5d },
	{ 0x6b4c, 0x9f59 },
	{ 0x6b4d, 0x9f91 },
	{ 0x6b4e, 0x513a },
	{ 0x6b4f, 0x5139 },
	{ 0x6b50, 0x5298 },
	{ 0x6b51, 0x5297 },
	{ 0x6b52, 0x56c3 },
	{ 0x6b53, 0x56bd },
	{ 0x6b54, 0x56be },
	{ 0x6b55, 0x5b48 },
	{ 0x6b56, 0x5b47 },
	{ 0x6b57, 0x5dcb },
	{ 0x6b58, 0x5dcf },
	{ 0x6b59, 0x5ef1 },
	{ 0x6b5a, 0x61fd },
	{ 0x6b5b, 0x651b },
	{ 0x6b5c, 0x6b02 },
	{ 0x6b5d, 0x6afc },
	{ 0x6b5e, 0x6b03 },
	{ 0x6b5f, 0x6af8 },
	{ 0x6b60, 0x6b00 },
	{ 0x6b61, 0x7043 },
	{ 0x6b62, 0x7044 },
	{ 0x6b63, 0x704a },
	{ 0x6b64, 0x7048 },
	{ 0x6b65, 0x7049 },
	{ 0x6b66, 0x7045 },
	{ 0x6b67, 0x7046 },
	{ 0x6b68, 0x721d },
	{ 0x6b69, 0x721a },
	{ 0x6b6a, 0x7219 },
	{ 0x6b6b, 0x737e },
	{ 0x6b6c, 0x7517 },
	{ 0x6b6d, 0x766a },
	{ 0x6b6e, 0x77d0 },
	{ 0x6b6f, 0x792d },
	{ 0x6b70, 0x7931 },
	{ 0x6b71, 0x792f },
	{ 0x6b72, 0x7c54 },
	{ 0x6b73, 0x7c53 },
	{ 0x6b74, 0x7cf2 },
	{ 0x6b75, 0x7e8a },
	{ 0x6b76, 0x7e87 },
	{ 0x6b77, 0x7e88 },
	{ 0x6b78, 0x7e8b },
	{ 0x6b79, 0x7e86 },
	{ 0x6b7a, 0x7e8d },
	{ 0x6b7b, 0x7f4d },
	{ 0x6b7c, 0x7fbb },
	{ 0x6b7d, 0x8030 },
	{ 0x6b7e, 0x81dd },
	{ 0x6c21, 0x8618 },
	{ 0x6c22, 0x862a },
	{ 0x6c23, 0x8626 },
	{ 0x6c24, 0x861f },
	{ 0x6c25, 0x8623 },
	{ 0x6c26, 0x861c },
	{ 0x6c27, 0x8619 },
	{ 0x6c28, 0x8627 },
	{ 0x6c29, 0x862e },
	{ 0x6c2a, 0x8621 },
	{ 0x6c2b, 0x8620 },
	{ 0x6c2c, 0x8629 },
	{ 0x6c2d, 0x861e },
	{ 0x6c2e, 0x8625 },
	{ 0x6c2f, 0x8829 },
	{ 0x6c30, 0x881d },
	{ 0x6c31, 0x881b },
	{ 0x6c32, 0x8820 },
	{ 0x6c33, 0x8824 },
	{ 0x6c34, 0x881c },
	{ 0x6c35, 0x882b },
	{ 0x6c36, 0x884a },
	{ 0x6c37, 0x896d },
	{ 0x6c38, 0x8969 },
	{ 0x6c39, 0x896e },
	{ 0x6c3a, 0x896b },
	{ 0x6c3b, 0x89fa },
	{ 0x6c3c, 0x8b79 },
	{ 0x6c3d, 0x8b78 },
	{ 0x6c3e, 0x8b45 },
	{ 0x6c3f, 0x8b7a },
	{ 0x6c40, 0x8b7b },
	{ 0x6c41, 0x8d10 },
	{ 0x6c42, 0x8d14 },
	{ 0x6c43, 0x8daf },
	{ 0x6c44, 0x8e8e },
	{ 0x6c45, 0x8e8c },
	{ 0x6c46, 0x8f5e },
	{ 0x6c47, 0x8f5b },
	{ 0x6c48, 0x8f5d },
	{ 0x6c49, 0x9146 },
	{ 0x6c4a, 0x9144 },
	{ 0x6c4b, 0x9145 },
	{ 0x6c4c, 0x91b9 },
	{ 0x6c4d, 0x943f },
	{ 0x6c4e, 0x943b },
	{ 0x6c4f, 0x9436 },
	{ 0x6c50, 0x9429 },
	{ 0x6c51, 0x943d },
	{ 0x6c52, 0x9430 },
	{ 0x6c53, 0x9439 },
	{ 0x6c54, 0x942a },
	{ 0x6c55, 0x9437 },
	{ 0x6c56, 0x942c },
	{ 0x6c57, 0x9440 },
	{ 0x6c58, 0x9431 },
	{ 0x6c59, 0x95e5 },
	{ 0x6c5a, 0x95e4 },
	{ 0x6c5b, 0x95e3 },
	{ 0x6c5c, 0x9735 },
	{ 0x6c5d, 0x973a },
	{ 0x6c5e, 0x97bf },
	{ 0x6c5f, 0x97e1 },
	{ 0x6c60, 0x9864 },
	{ 0x6c61, 0x98c9 },
	{ 0x6c62, 0x98c6 },
	{ 0x6c63, 0x98c0 },
	{ 0x6c64, 0x9958 },
	{ 0x6c65, 0x9956 },
	{ 0x6c66, 0x9a39 },
	{ 0x6c67, 0x9a3d },
	{ 0x6c68, 0x9a46 },
	{ 0x6c69, 0x9a44 },
	{ 0x6c6a, 0x9a42 },
	{ 0x6c6b, 0x9a41 },
	{ 0x6c6c, 0x9a3a },
	{ 0x6c6d, 0x9a3f },
	{ 0x6c6e, 0x9acd },
	{ 0x6c6f, 0x9b15 },
	{ 0x6c70, 0x9b17 },
	{ 0x6c71, 0x9b18 },
	{ 0x6c72, 0x9b16 },
	{ 0x6c73, 0x9b3a },
	{ 0x6c74, 0x9b52 },
	{ 0x6c75, 0x9c2b },
	{ 0x6c76, 0x9c1d },
	{ 0x6c77, 0x9c1c },
	{ 0x6c78, 0x9c2c },
	{ 0x6c79, 0x9c23 },
	{ 0x6c7a, 0x9c28 },
	{ 0x6c7b, 0x9c29 },
	{ 0x6c7c, 0x9c24 },
	{ 0x6c7d, 0x9c21 },
	{ 0x6c7e, 0x9db7 },
	{ 0x6d21, 0x9db6 },
	{ 0x6d22, 0x9dbc },
	{ 0x6d23, 0x9dc1 },
	{ 0x6d24, 0x9dc7 },
	{ 0x6d25, 0x9dca },
	{ 0x6d26, 0x9dcf },
	{ 0x6d27, 0x9dbe },
	{ 0x6d28, 0x9dc5 },
	{ 0x6d29, 0x9dc3 },
	{ 0x6d2a, 0x9dbb },
	{ 0x6d2b, 0x9db5 },
	{ 0x6d2c, 0x9dce },
	{ 0x6d2d, 0x9db9 },
	{ 0x6d2e, 0x9dba },
	{ 0x6d2f, 0x9dac },
	{ 0x6d30, 0x9dc8 },
	{ 0x6d31, 0x9db1 },
	{ 0x6d32, 0x9dad },
	{ 0x6d33, 0x9dcc },
	{ 0x6d34, 0x9db3 },
	{ 0x6d35, 0x9dcd },
	{ 0x6d36, 0x9db2 },
	{ 0x6d37, 0x9e7a },
	{ 0x6d38, 0x9e9c },
	{ 0x6d39, 0x9eeb },
	{ 0x6d3a, 0x9eee },
	{ 0x6d3b, 0x9eed },
	{ 0x6d3c, 0x9f1b },
	{ 0x6d3d, 0x9f18 },
	{ 0x6d3e, 0x9f1a },
	{ 0x6d3f, 0x9f31 },
	{ 0x6d40, 0x9f4e },
	{ 0x6d41, 0x9f65 },
	{ 0x6d42, 0x9f64 },
	{ 0x6d43, 0x9f92 },
	{ 0x6d44, 0x4eb9 },
	{ 0x6d45, 0x56c6 },
	{ 0x6d46, 0x56c5 },
	{ 0x6d47, 0x56cb },
	{ 0x6d48, 0x5971 },
	{ 0x6d49, 0x5b4b },
	{ 0x6d4a, 0x5b4c },
	{ 0x6d4b, 0x5dd5 },
	{ 0x6d4c, 0x5dd1 },
	{ 0x6d4d, 0x5ef2 },
	{ 0x6d4e, 0x6521 },
	{ 0x6d4f, 0x6520 },
	{ 0x6d50, 0x6526 },
	{ 0x6d51, 0x6522 },
	{ 0x6d52, 0x6b0b },
	{ 0x6d53, 0x6b08 },
	{ 0x6d54, 0x6b09 },
	{ 0x6d55, 0x6c0d },
	{ 0x6d56, 0x7055 },
	{ 0x6d57, 0x7056 },
	{ 0x6d58, 0x7057 },
	{ 0x6d59, 0x7052 },
	{ 0x6d5a, 0x721e },
	{ 0x6d5b, 0x721f },
	{ 0x6d5c, 0x72a9 },
	{ 0x6d5d, 0x737f },
	{ 0x6d5e, 0x74d8 },
	{ 0x6d5f, 0x74d5 },
	{ 0x6d60, 0x74d9 },
	{ 0x6d61, 0x74d7 },
	{ 0x6d62, 0x766d },
	{ 0x6d63, 0x76ad },
	{ 0x6d64, 0x7935 },
	{ 0x6d65, 0x79b4 },
	{ 0x6d66, 0x7a70 },
	{ 0x6d67, 0x7a71 },
	{ 0x6d68, 0x7c57 },
	{ 0x6d69, 0x7c5c },
	{ 0x6d6a, 0x7c59 },
	{ 0x6d6b, 0x7c5b },
	{ 0x6d6c, 0x7c5a },
	{ 0x6d6d, 0x7cf4 },
	{ 0x6d6e, 0x7cf1 },
	{ 0x6d6f, 0x7e91 },
	{ 0x6d70, 0x7f4f },
	{ 0x6d71, 0x7f87 },
	{ 0x6d72, 0x81de },
	{ 0x6d73, 0x826b },
	{ 0x6d74, 0x8634 },
	{ 0x6d75, 0x8635 },
	{ 0x6d76, 0x8633 },
	{ 0x6d77, 0x862c },
	{ 0x6d78, 0x8632 },
	{ 0x6d79, 0x8636 },
	{ 0x6d7a, 0x882c },
	{ 0x6d7b, 0x8828 },
	{ 0x6d7c, 0x8826 },
	{ 0x6d7d, 0x882a },
	{ 0x6d7e, 0x8825 },
	{ 0x6e21, 0x8971 },
	{ 0x6e22, 0x89bf },
	{ 0x6e23, 0x89be },
	{ 0x6e24, 0x89fb },
	{ 0x6e25, 0x8b7e },
	{ 0x6e26, 0x8b84 },
	{ 0x6e27, 0x8b82 },
	{ 0x6e28, 0x8b86 },
	{ 0x6e29, 0x8b85 },
	{ 0x6e2a, 0x8b7f },
	{ 0x6e2b, 0x8d15 },
	{ 0x6e2c, 0x8e95 },
	{ 0x6e2d, 0x8e94 },
	{ 0x6e2e, 0x8e9a },
	{ 0x6e2f, 0x8e92 },
	{ 0x6e30, 0x8e90 },
	{ 0x6e31, 0x8e96 },
	{ 0x6e32, 0x8e97 },
	{ 0x6e33, 0x8f60 },
	{ 0x6e34, 0x8f62 },
	{ 0x6e35, 0x9147 },
	{ 0x6e36, 0x944c },
	{ 0x6e37, 0x9450 },
	{ 0x6e38, 0x944a },
	{ 0x6e39, 0x944b },
	{ 0x6e3a, 0x944f },
	{ 0x6e3b, 0x9447 },
	{ 0x6e3c, 0x9445 },
	{ 0x6e3d, 0x9448 },
	{ 0x6e3e, 0x9449 },
	{ 0x6e3f, 0x9446 },
	{ 0x6e40, 0x973f },
	{ 0x6e41, 0x97e3 },
	{ 0x6e42, 0x986a },
	{ 0x6e43, 0x9869 },
	{ 0x6e44, 0x98cb },
	{ 0x6e45, 0x9954 },
	{ 0x6e46, 0x995b },
	{ 0x6e47, 0x9a4e },
	{ 0x6e48, 0x9a53 },
	{ 0x6e49, 0x9a54 },
	{ 0x6e4a, 0x9a4c },
	{ 0x6e4b, 0x9a4f },
	{ 0x6e4c, 0x9a48 },
	{ 0x6e4d, 0x9a4a },
	{ 0x6e4e, 0x9a49 },
	{ 0x6e4f, 0x9a52 },
	{ 0x6e50, 0x9a50 },
	{ 0x6e51, 0x9ad0 },
	{ 0x6e52, 0x9b19 },
	{ 0x6e53, 0x9b2b },
	{ 0x6e54, 0x9b3b },
	{ 0x6e55, 0x9b56 },
	{ 0x6e56, 0x9b55 },
	{ 0x6e57, 0x9c46 },
	{ 0x6e58, 0x9c48 },
	{ 0x6e59, 0x9c3f },
	{ 0x6e5a, 0x9c44 },
	{ 0x6e5b, 0x9c39 },
	{ 0x6e5c, 0x9c33 },
	{ 0x6e5d, 0x9c41 },
	{ 0x6e5e, 0x9c3c },
	{ 0x6e5f, 0x9c37 },
	{ 0x6e60, 0x9c34 },
	{ 0x6e61, 0x9c32 },
	{ 0x6e62, 0x9c3d },
	{ 0x6e63, 0x9c36 },
	{ 0x6e64, 0x9ddb },
	{ 0x6e65, 0x9dd2 },
	{ 0x6e66, 0x9dde },
	{ 0x6e67, 0x9dda },
	{ 0x6e68, 0x9dcb },
	{ 0x6e69, 0x9dd0 },
	{ 0x6e6a, 0x9ddc },
	{ 0x6e6b, 0x9dd1 },
	{ 0x6e6c, 0x9ddf },
	{ 0x6e6d, 0x9de9 },
	{ 0x6e6e, 0x9dd9 },
	{ 0x6e6f, 0x9dd8 },
	{ 0x6e70, 0x9dd6 },
	{ 0x6e71, 0x9df5 },
	{ 0x6e72, 0x9dd5 },
	{ 0x6e73, 0x9ddd },
	{ 0x6e74, 0x9eb6 },
	{ 0x6e75, 0x9ef0 },
	{ 0x6e76, 0x9f35 },
	{ 0x6e77, 0x9f33 },
	{ 0x6e78, 0x9f32 },
	{ 0x6e79, 0x9f42 },
	{ 0x6e7a, 0x9f6b },
	{ 0x6e7b, 0x9f95 },
	{ 0x6e7c, 0x9fa2 },
	{ 0x6e7d, 0x513d },
	{ 0x6e7e, 0x5299 },
	{ 0x6f21, 0x58e8 },
	{ 0x6f22, 0x58e7 },
	{ 0x6f23, 0x5972 },
	{ 0x6f24, 0x5b4d },
	{ 0x6f25, 0x5dd8 },
	{ 0x6f26, 0x882f },
	{ 0x6f27, 0x5f4f },
	{ 0x6f28, 0x6201 },
	{ 0x6f29, 0x6203 },
	{ 0x6f2a, 0x6204 },
	{ 0x6f2b, 0x6529 },
	{ 0x6f2c, 0x6525 },
	{ 0x6f2d, 0x6596 },
	{ 0x6f2e, 0x66eb },
	{ 0x6f2f, 0x6b11 },
	{ 0x6f30, 0x6b12 },
	{ 0x6f31, 0x6b0f },
	{ 0x6f32, 0x6bca },
	{ 0x6f33, 0x705b },
	{ 0x6f34, 0x705a },
	{ 0x6f35, 0x7222 },
	{ 0x6f36, 0x7382 },
	{ 0x6f37, 0x7381 },
	{ 0x6f38, 0x7383 },
	{ 0x6f39, 0x7670 },
	{ 0x6f3a, 0x77d4 },
	{ 0x6f3b, 0x7c67 },
	{ 0x6f3c, 0x7c66 },
	{ 0x6f3d, 0x7e95 },
	{ 0x6f3e, 0x826c },
	{ 0x6f3f, 0x863a },
	{ 0x6f40, 0x8640 },
	{ 0x6f41, 0x8639 },
	{ 0x6f42, 0x863c },
	{ 0x6f43, 0x8631 },
	{ 0x6f44, 0x863b },
	{ 0x6f45, 0x863e },
	{ 0x6f46, 0x8830 },
	{ 0x6f47, 0x8832 },
	{ 0x6f48, 0x882e },
	{ 0x6f49, 0x8833 },
	{ 0x6f4a, 0x8976 },
	{ 0x6f4b, 0x8974 },
	{ 0x6f4c, 0x8973 },
	{ 0x6f4d, 0x89fe },
	{ 0x6f4e, 0x8b8c },
	{ 0x6f4f, 0x8b8e },
	{ 0x6f50, 0x8b8b },
	{ 0x6f51, 0x8b88 },
	{ 0x6f52, 0x8c45 },
	{ 0x6f53, 0x8d19 },
	{ 0x6f54, 0x8e98 },
	{ 0x6f55, 0x8f64 },
	{ 0x6f56, 0x8f63 },
	{ 0x6f57, 0x91bc },
	{ 0x6f58, 0x9462 },
	{ 0x6f59, 0x9455 },
	{ 0x6f5a, 0x945d },
	{ 0x6f5b, 0x9457 },
	{ 0x6f5c, 0x945e },
	{ 0x6f5d, 0x97c4 },
	{ 0x6f5e, 0x97c5 },
	{ 0x6f5f, 0x9800 },
	{ 0x6f60, 0x9a56 },
	{ 0x6f61, 0x9a59 },
	{ 0x6f62, 0x9b1e },
	{ 0x6f63, 0x9b1f },
	{ 0x6f64, 0x9b20 },
	{ 0x6f65, 0x9c52 },
	{ 0x6f66, 0x9c58 },
	{ 0x6f67, 0x9c50 },
	{ 0x6f68, 0x9c4a },
	{ 0x6f69, 0x9c4d },
	{ 0x6f6a, 0x9c4b },
	{ 0x6f6b, 0x9c55 },
	{ 0x6f6c, 0x9c59 },
	{ 0x6f6d, 0x9c4c },
	{ 0x6f6e, 0x9c4e },
	{ 0x6f6f, 0x9dfb },
	{ 0x6f70, 0x9df7 },
	{ 0x6f71, 0x9def },
	{ 0x6f72, 0x9de3 },
	{ 0x6f73, 0x9deb },
	{ 0x6f74, 0x9df8 },
	{ 0x6f75, 0x9de4 },
	{ 0x6f76, 0x9df6 },
	{ 0x6f77, 0x9de1 },
	{ 0x6f78, 0x9dee },
	{ 0x6f79, 0x9de6 },
	{ 0x6f7a, 0x9df2 },
	{ 0x6f7b, 0x9df0 },
	{ 0x6f7c, 0x9de2 },
	{ 0x6f7d, 0x9dec },
	{ 0x6f7e, 0x9df4 },
	{ 0x7021, 0x9df3 },
	{ 0x7022, 0x9de8 },
	{ 0x7023, 0x9ded },
	{ 0x7024, 0x9ec2 },
	{ 0x7025, 0x9ed0 },
	{ 0x7026, 0x9ef2 },
	{ 0x7027, 0x9ef3 },
	{ 0x7028, 0x9f06 },
	{ 0x7029, 0x9f1c },
	{ 0x702a, 0x9f38 },
	{ 0x702b, 0x9f37 },
	{ 0x702c, 0x9f36 },
	{ 0x702d, 0x9f43 },
	{ 0x702e, 0x9f4f },
	{ 0x702f, 0x9f71 },
	{ 0x7030, 0x9f70 },
	{ 0x7031, 0x9f6e },
	{ 0x7032, 0x9f6f },
	{ 0x7033, 0x56d3 },
	{ 0x7034, 0x56cd },
	{ 0x7035, 0x5b4e },
	{ 0x7036, 0x5c6d },
	{ 0x7037, 0x652d },
	{ 0x7038, 0x66ed },
	{ 0x7039, 0x66ee },
	{ 0x703a, 0x6b13 },
	{ 0x703b, 0x705f },
	{ 0x703c, 0x7061 },
	{ 0x703d, 0x705d },
	{ 0x703e, 0x7060 },
	{ 0x703f, 0x7223 },
	{ 0x7040, 0x74db },
	{ 0x7041, 0x74e5 },
	{ 0x7042, 0x77d5 },
	{ 0x7043, 0x7938 },
	{ 0x7044, 0x79b7 },
	{ 0x7045, 0x79b6 },
	{ 0x7046, 0x7c6a },
	{ 0x7047, 0x7e97 },
	{ 0x7048, 0x7f89 },
	{ 0x7049, 0x826d },
	{ 0x704a, 0x8643 },
	{ 0x704b, 0x8838 },
	{ 0x704c, 0x8837 },
	{ 0x704d, 0x8835 },
	{ 0x704e, 0x884b },
	{ 0x704f, 0x8b94 },
	{ 0x7050, 0x8b95 },
	{ 0x7051, 0x8e9e },
	{ 0x7052, 0x8e9f },
	{ 0x7053, 0x8ea0 },
	{ 0x7054, 0x8e9d },
	{ 0x7055, 0x91be },
	{ 0x7056, 0x91bd },
	{ 0x7057, 0x91c2 },
	{ 0x7058, 0x946b },
	{ 0x7059, 0x9468 },
	{ 0x705a, 0x9469 },
	{ 0x705b, 0x96e5 },
	{ 0x705c, 0x9746 },
	{ 0x705d, 0x9743 },
	{ 0x705e, 0x9747 },
	{ 0x705f, 0x97c7 },
	{ 0x7060, 0x97e5 },
	{ 0x7061, 0x9a5e },
	{ 0x7062, 0x9ad5 },
	{ 0x7063, 0x9b59 },
	{ 0x7064, 0x9c63 },
	{ 0x7065, 0x9c67 },
	{ 0x7066, 0x9c66 },
	{ 0x7067, 0x9c62 },
	{ 0x7068, 0x9c5e },
	{ 0x7069, 0x9c60 },
	{ 0x706a, 0x9e02 },
	{ 0x706b, 0x9dfe },
	{ 0x706c, 0x9e07 },
	{ 0x706d, 0x9e03 },
	{ 0x706e, 0x9e06 },
	{ 0x706f, 0x9e05 },
	{ 0x7070, 0x9e00 },
	{ 0x7071, 0x9e01 },
	{ 0x7072, 0x9e09 },
	{ 0x7073, 0x9dff },
	{ 0x7074, 0x9dfd },
	{ 0x7075, 0x9e04 },
	{ 0x7076, 0x9ea0 },
	{ 0x7077, 0x9f1e },
	{ 0x7078, 0x9f46 },
	{ 0x7079, 0x9f74 },
	{ 0x707a, 0x9f75 },
	{ 0x707b, 0x9f76 },
	{ 0x707c, 0x56d4 },
	{ 0x707d, 0x652e },
	{ 0x707e, 0x65b8 },
	{ 0x7121, 0x6b18 },
	{ 0x7122, 0x6b19 },
	{ 0x7123, 0x6b17 },
	{ 0x7124, 0x6b1a },
	{ 0x7125, 0x7062 },
	{ 0x7126, 0x7226 },
	{ 0x7127, 0x72aa },
	{ 0x7128, 0x77d8 },
	{ 0x7129, 0x77d9 },
	{ 0x712a, 0x7939 },
	{ 0x712b, 0x7c69 },
	{ 0x712c, 0x7c6b },
	{ 0x712d, 0x7cf6 },
	{ 0x712e, 0x7e9a },
	{ 0x712f, 0x7e98 },
	{ 0x7130, 0x7e9b },
	{ 0x7131, 0x7e99 },
	{ 0x7132, 0x81e0 },
	{ 0x7133, 0x81e1 },
	{ 0x7134, 0x8646 },
	{ 0x7135, 0x8647 },
	{ 0x7136, 0x8648 },
	{ 0x7137, 0x8979 },
	{ 0x7138, 0x897a },
	{ 0x7139, 0x897c },
	{ 0x713a, 0x897b },
	{ 0x713b, 0x89ff },
	{ 0x713c, 0x8b98 },
	{ 0x713d, 0x8b99 },
	{ 0x713e, 0x8ea5 },
	{ 0x713f, 0x8ea4 },
	{ 0x7140, 0x8ea3 },
	{ 0x7141, 0x946e },
	{ 0x7142, 0x946d },
	{ 0x7143, 0x946f },
	{ 0x7144, 0x9471 },
	{ 0x7145, 0x9473 },
	{ 0x7146, 0x9749 },
	{ 0x7147, 0x9872 },
	{ 0x7148, 0x995f },
	{ 0x7149, 0x9c68 },
	{ 0x714a, 0x9c6e },
	{ 0x714b, 0x9c6d },
	{ 0x714c, 0x9e0b },
	{ 0x714d, 0x9e0d },
	{ 0x714e, 0x9e10 },
	{ 0x714f, 0x9e0f },
	{ 0x7150, 0x9e12 },
	{ 0x7151, 0x9e11 },
	{ 0x7152, 0x9ea1 },
	{ 0x7153, 0x9ef5 },
	{ 0x7154, 0x9f09 },
	{ 0x7155, 0x9f47 },
	{ 0x7156, 0x9f78 },
	{ 0x7157, 0x9f7b },
	{ 0x7158, 0x9f7a },
	{ 0x7159, 0x9f79 },
	{ 0x715a, 0x571e },
	{ 0x715b, 0x7066 },
	{ 0x715c, 0x7c6f },
	{ 0x715d, 0x883c },
	{ 0x715e, 0x8db2 },
	{ 0x715f, 0x8ea6 },
	{ 0x7160, 0x91c3 },
	{ 0x7161, 0x9474 },
	{ 0x7162, 0x9478 },
	{ 0x7163, 0x9476 },
	{ 0x7164, 0x9475 },
	{ 0x7165, 0x9a60 },
	{ 0x7166, 0x9b2e },
	{ 0x7167, 0x9c74 },
	{ 0x7168, 0x9c73 },
	{ 0x7169, 0x9c71 },
	{ 0x716a, 0x9c75 },
	{ 0x716b, 0x9e14 },
	{ 0x716c, 0x9e13 },
	{ 0x716d, 0x9ef6 },
	{ 0x716e, 0x9f0a },
	{ 0x716f, 0x9fa4 },
	{ 0x7170, 0x7068 },
	{ 0x7171, 0x7065 },
	{ 0x7172, 0x7cf7 },
	{ 0x7173, 0x866a },
	{ 0x7174, 0x883e },
	{ 0x7175, 0x883d },
	{ 0x7176, 0x883f },
	{ 0x7177, 0x8b9e },
	{ 0x7178, 0x8c9c },
	{ 0x7179, 0x8ea9 },
	{ 0x717a, 0x8ec9 },
	{ 0x717b, 0x974b },
	{ 0x717c, 0x9873 },
	{ 0x717d, 0x9874 },
	{ 0x717e, 0x98cc },
	{ 0x7221, 0x9961 },
	{ 0x7222, 0x99ab },
	{ 0x7223, 0x9a64 },
	{ 0x7224, 0x9a66 },
	{ 0x7225, 0x9a67 },
	{ 0x7226, 0x9b24 },
	{ 0x7227, 0x9e15 },
	{ 0x7228, 0x9e17 },
	{ 0x7229, 0x9f48 },
	{ 0x722a, 0x6207 },
	{ 0x722b, 0x6b1e },
	{ 0x722c, 0x7227 },
	{ 0x722d, 0x864c },
	{ 0x722e, 0x8ea8 },
	{ 0x722f, 0x9482 },
	{ 0x7230, 0x9480 },
	{ 0x7231, 0x9481 },
	{ 0x7232, 0x9a69 },
	{ 0x7233, 0x9a68 },
	{ 0x7234, 0x9e19 },
	{ 0x7235, 0x864b },
	{ 0x7236, 0x8b9f },
	{ 0x7237, 0x9483 },
	{ 0x7238, 0x9c79 },
	{ 0x7239, 0x9eb7 },
	{ 0x723a, 0x7675 },
	{ 0x723b, 0x9a6b },
	{ 0x723c, 0x9c7a },
	{ 0x723d, 0x9e1d },
	{ 0x723e, 0x7069 },
	{ 0x723f, 0x706a },
	{ 0x7240, 0x7229 },
	{ 0x7241, 0x9ea4 },
	{ 0x7242, 0x9f7e },
	{ 0x7243, 0x9f49 },
	{ 0x7244, 0x9f98 }
};

/* CNS 11643 plane #3 */
cns_utf cns3_utf_tab[MAX_CNS3_NUM] = {
	{ 0x2121, 0x4E28 },
	{ 0x2122, 0x4E36 },
	{ 0x2123, 0x4E3F },
	{ 0x2124, 0x4E85 },
	{ 0x2125, 0x4E05 },
	{ 0x2126, 0x4E04 },
	{ 0x2127, 0x5182 },
	{ 0x2128, 0x5196 },
	{ 0x2129, 0x5338 },
	{ 0x212A, 0x5369 },
	{ 0x212B, 0x53B6 },
	{ 0x212C, 0x4E2A },
	{ 0x212D, 0x4E87 },
	{ 0x212E, 0x4E49 },
	{ 0x212F, 0x51E2 },
	{ 0x2130, 0x4E46 },
	{ 0x2131, 0x4E8F },
	{ 0x2132, 0x4EBC },
	{ 0x2133, 0x4EBE },
	{ 0x2134, 0x5166 },
	{ 0x2135, 0x51E3 },
	{ 0x2136, 0x5204 },
	{ 0x2137, 0x529C },
	{ 0x2138, 0x5344 },
	{ 0x2139, 0x5902 },
	{ 0x213A, 0x590A },
	{ 0x213B, 0x5B80 },
	{ 0x213C, 0x5DDB },
	{ 0x213D, 0x5E7A },
	{ 0x213E, 0x5E7F },
	{ 0x213F, 0x5EF4 },
	{ 0x2140, 0x5F50 },
	{ 0x2141, 0x5F51 },
	{ 0x2142, 0x5F61 },
	{ 0x2143, 0x961D },
	{ 0x2144, 0x2000B },
	{ 0x2145, 0x4E63 },
	{ 0x2146, 0x4E62 },
	{ 0x2147, 0x4EA3 },
	{ 0x2148, 0x5185 },
	{ 0x2149, 0x4EC5 },
	{ 0x214A, 0x4ECF },
	{ 0x214B, 0x4ECE },
	{ 0x214C, 0x4ECC },
	{ 0x214D, 0x5184 },
	{ 0x214E, 0x5186 },
	{ 0x214F, 0x2F817 },
	{ 0x2150, 0x34C5 },
	{ 0x2151, 0x51E4 },
	{ 0x2152, 0x5205 },
	{ 0x2153, 0x529E },
	{ 0x2154, 0x529D },
	{ 0x2155, 0x52FD },
	{ 0x2156, 0x5300 },
	{ 0x2157, 0x533A },
	{ 0x2158, 0x3539 },
	{ 0x2159, 0x5346 },
	{ 0x215A, 0x535D },
	{ 0x215B, 0x5386 },
	{ 0x215C, 0x53B7 },
	{ 0x215D, 0x3555 },
	{ 0x215E, 0x53CC },
	{ 0x215F, 0x355B },
	{ 0x2160, 0x53CE },
	{ 0x2161, 0x5721 },
	{ 0x2162, 0x37A2 },
	{ 0x2163, 0x5E00 },
	{ 0x2164, 0x5F0C },
	{ 0x2165, 0x6237 },
	{ 0x2166, 0x6238 },
	{ 0x2167, 0x6534 },
	{ 0x2168, 0x6535 },
	{ 0x2169, 0x65E0 },
	{ 0x216A, 0x3E26 },
	{ 0x216B, 0x738D },
	{ 0x216C, 0x4E97 },
	{ 0x216D, 0x4EE0 },
	{ 0x216E, 0x3432 },
	{ 0x216F, 0x201A9 },
	{ 0x2170, 0x4EE7 },
	{ 0x2171, 0x3433 },
	{ 0x2172, 0x4EE6 },
	{ 0x2173, 0x3434 },
	{ 0x2174, 0x36A2 },
	{ 0x2175, 0x3431 },
	{ 0x2176, 0x34B0 },
	{ 0x2177, 0x56D8 },
	{ 0x2178, 0x518B },
	{ 0x2179, 0x518C },
	{ 0x217A, 0x5199 },
	{ 0x217B, 0x51E5 },
	{ 0x217C, 0x2F850 },
	{ 0x217D, 0x520B },
	{ 0x217E, 0x34DC },
	{ 0x2221, 0x361E },
	{ 0x2222, 0x5304 },
	{ 0x2223, 0x5303 },
	{ 0x2224, 0x5307 },
	{ 0x2225, 0x2F82A },
	{ 0x2226, 0x531E },
	{ 0x2227, 0x535F },
	{ 0x2228, 0x536D },
	{ 0x2229, 0x5389 },
	{ 0x222A, 0x53BA },
	{ 0x222B, 0x53D0 },
	{ 0x222C, 0x3565 },
	{ 0x222D, 0x53F6 },
	{ 0x222E, 0x53F7 },
	{ 0x222F, 0x53F9 },
	{ 0x2230, 0x3564 },
	{ 0x2231, 0x53F4 },
	{ 0x2232, 0x361D },
	{ 0x2233, 0x3626 },
	{ 0x2234, 0x5724 },
	{ 0x2235, 0x5904 },
	{ 0x2236, 0x5918 },
	{ 0x2237, 0x5932 },
	{ 0x2238, 0x5930 },
	{ 0x2239, 0x5934 },
	{ 0x223A, 0x368E },
	{ 0x223B, 0x5975 },
	{ 0x223C, 0x374A },
	{ 0x223D, 0x5B82 },
	{ 0x223E, 0x5BF9 },
	{ 0x223F, 0x5C14 },
	{ 0x2240, 0x378B },
	{ 0x2241, 0x37A6 },
	{ 0x2242, 0x37A4 },
	{ 0x2243, 0x37A5 },
	{ 0x2244, 0x37A7 },
	{ 0x2245, 0x382F },
	{ 0x2246, 0x3832 },
	{ 0x2247, 0x5E81 },
	{ 0x2248, 0x5E83 },
	{ 0x2249, 0x5F0D },
	{ 0x224A, 0x5F52 },
	{ 0x224B, 0x38D4 },
	{ 0x224C, 0x5FCA },
	{ 0x224D, 0x5FC7 },
	{ 0x224E, 0x6239 },
	{ 0x224F, 0x39C5 },
	{ 0x2250, 0x624F },
	{ 0x2251, 0x65E7 },
	{ 0x2252, 0x672F },
	{ 0x2253, 0x6B7A },
	{ 0x2254, 0x6C39 },
	{ 0x2255, 0x3CBA },
	{ 0x2256, 0x3CB9 },
	{ 0x2257, 0x6C37 },
	{ 0x2258, 0x6C44 },
	{ 0x2259, 0x6C45 },
	{ 0x225A, 0x738C },
	{ 0x225B, 0x7592 },
	{ 0x225C, 0x7676 },
	{ 0x225D, 0x9093 },
	{ 0x225E, 0x9092 },
	{ 0x225F, 0x48B3 },
	{ 0x2260, 0x49BA },
	{ 0x2261, 0x4E21 },
	{ 0x2262, 0x4E20 },
	{ 0x2263, 0x4E22 },
	{ 0x2264, 0x4E68 },
	{ 0x2265, 0x4E89 },
	{ 0x2266, 0x4E98 },
	{ 0x2267, 0x4EF9 },
	{ 0x2268, 0x4EEF },
	{ 0x2269, 0x343B },
	{ 0x226A, 0x343C },
	{ 0x226B, 0x4EF8 },
	{ 0x226C, 0x4F06 },
	{ 0x226D, 0x4F03 },
	{ 0x226E, 0x4EFC },
	{ 0x226F, 0x4EEE },
	{ 0x2270, 0x4F16 },
	{ 0x2271, 0x3439 },
	{ 0x2272, 0x4F28 },
	{ 0x2273, 0x4F1C },
	{ 0x2274, 0x4F07 },
	{ 0x2275, 0x4F1A },
	{ 0x2276, 0x4EFA },
	{ 0x2277, 0x4F17 },
	{ 0x2278, 0x514A },
	{ 0x2279, 0x34B2 },
	{ 0x227A, 0x5172 },
	{ 0x227B, 0x2F815 },
	{ 0x227C, 0x51B4 },
	{ 0x227D, 0x51B3 },
	{ 0x227E, 0x51B2 },
	{ 0x2321, 0x34C7 },
	{ 0x2322, 0x51E8 },
	{ 0x2323, 0x342B },
	{ 0x2324, 0x5214 },
	{ 0x2325, 0x520F },
	{ 0x2326, 0x5215 },
	{ 0x2327, 0x5218 },
	{ 0x2328, 0x52A8 },
	{ 0x2329, 0x2F82C },
	{ 0x232A, 0x534B },
	{ 0x232B, 0x534F },
	{ 0x232C, 0x353B },
	{ 0x232D, 0x5350 },
	{ 0x232E, 0x3544 },
	{ 0x232F, 0x538B },
	{ 0x2330, 0x3542 },
	{ 0x2331, 0x53BE },
	{ 0x2332, 0x355C },
	{ 0x2333, 0x53D2 },
	{ 0x2334, 0x5416 },
	{ 0x2335, 0x53FF },
	{ 0x2336, 0x3567 },
	{ 0x2337, 0x5400 },
	{ 0x2338, 0x3566 },
	{ 0x2339, 0x5405 },
	{ 0x233A, 0x5413 },
	{ 0x233B, 0x5415 },
	{ 0x233C, 0x2F83B },
	{ 0x233D, 0x361F },
	{ 0x233E, 0x56E3 },
	{ 0x233F, 0x5735 },
	{ 0x2340, 0x5736 },
	{ 0x2341, 0x5731 },
	{ 0x2342, 0x5732 },
	{ 0x2343, 0x58EE },
	{ 0x2344, 0x5905 },
	{ 0x2345, 0x4E54 },
	{ 0x2346, 0x368F },
	{ 0x2347, 0x5936 },
	{ 0x2348, 0x3690 },
	{ 0x2349, 0x36A8 },
	{ 0x234A, 0x36A4 },
	{ 0x234B, 0x597A },
	{ 0x234C, 0x36A3 },
	{ 0x234D, 0x5986 },
	{ 0x234E, 0x373D },
	{ 0x234F, 0x374C },
	{ 0x2350, 0x5B86 },
	{ 0x2351, 0x5F53 },
	{ 0x2352, 0x5C18 },
	{ 0x2353, 0x378C },
	{ 0x2354, 0x5C3D },
	{ 0x2355, 0x5C78 },
	{ 0x2356, 0x37A8 },
	{ 0x2357, 0x37AD },
	{ 0x2358, 0x37AF },
	{ 0x2359, 0x21D46 },
	{ 0x235A, 0x5C80 },
	{ 0x235B, 0x3829 },
	{ 0x235C, 0x5E08 },
	{ 0x235D, 0x3836 },
	{ 0x235E, 0x3871 },
	{ 0x235F, 0x3870 },
	{ 0x2360, 0x386F },
	{ 0x2361, 0x5EF5 },
	{ 0x2362, 0x5F0E },
	{ 0x2363, 0x38A9 },
	{ 0x2364, 0x38AA },
	{ 0x2365, 0x38FB },
	{ 0x2366, 0x5FD3 },
	{ 0x2367, 0x5FDA },
	{ 0x2368, 0x38FC },
	{ 0x2369, 0x5FDB },
	{ 0x236A, 0x39AE },
	{ 0x236B, 0x620F },
	{ 0x236C, 0x625D },
	{ 0x236D, 0x625F },
	{ 0x236E, 0x6267 },
	{ 0x236F, 0x6257 },
	{ 0x2370, 0x9F50 },
	{ 0x2371, 0x3AC3 },
	{ 0x2372, 0x65EB },
	{ 0x2373, 0x65EA },
	{ 0x2374, 0x3B30 },
	{ 0x2375, 0x6737 },
	{ 0x2376, 0x3B41 },
	{ 0x2377, 0x6732 },
	{ 0x2378, 0x6736 },
	{ 0x2379, 0x6B22 },
	{ 0x237A, 0x6BCE },
	{ 0x237B, 0x3C8C },
	{ 0x237C, 0x6C58 },
	{ 0x237D, 0x6C51 },
	{ 0x237E, 0x6C77 },
	{ 0x2421, 0x6C3C },
	{ 0x2422, 0x3CBB },
	{ 0x2423, 0x6C5A },
	{ 0x2424, 0x23C86 },
	{ 0x2425, 0x6C53 },
	{ 0x2426, 0x706F },
	{ 0x2427, 0x7072 },
	{ 0x2428, 0x706E },
	{ 0x2429, 0x2F835 },
	{ 0x242A, 0x3DA1 },
	{ 0x242B, 0x7073 },
	{ 0x242C, 0x72B1 },
	{ 0x242D, 0x72B2 },
	{ 0x242E, 0x3EA8 },
	{ 0x242F, 0x738F },
	{ 0x2430, 0x3EAA },
	{ 0x2431, 0x3EAB },
	{ 0x2432, 0x4096 },
	{ 0x2433, 0x793C },
	{ 0x2434, 0x41C2 },
	{ 0x2435, 0x808D },
	{ 0x2436, 0x808E },
	{ 0x2437, 0x4493 },
	{ 0x2438, 0x827B },
	{ 0x2439, 0x4494 },
	{ 0x243A, 0x8D71 },
	{ 0x243B, 0x8FB9 },
	{ 0x243C, 0x9096 },
	{ 0x243D, 0x909A },
	{ 0x243E, 0x49BB },
	{ 0x243F, 0x4E24 },
	{ 0x2440, 0x4E71 },
	{ 0x2441, 0x2F81B },
	{ 0x2442, 0x4E9C },
	{ 0x2443, 0x4F45 },
	{ 0x2444, 0x4F4A },
	{ 0x2445, 0x4F39 },
	{ 0x2446, 0x4F37 },
	{ 0x2447, 0x3443 },
	{ 0x2448, 0x4F32 },
	{ 0x2449, 0x4F42 },
	{ 0x244A, 0x3442 },
	{ 0x244B, 0x4F44 },
	{ 0x244C, 0x4F4B },
	{ 0x244D, 0x3444 },
	{ 0x244E, 0x4F40 },
	{ 0x244F, 0x4F35 },
	{ 0x2450, 0x4F31 },
	{ 0x2451, 0x5151 },
	{ 0x2452, 0x2F80E },
	{ 0x2453, 0x5150 },
	{ 0x2454, 0x514E },
	{ 0x2455, 0x34B3 },
	{ 0x2456, 0x34B7 },
	{ 0x2457, 0x519D },
	{ 0x2458, 0x34C8 },
	{ 0x2459, 0x51B5 },
	{ 0x245A, 0x51B8 },
	{ 0x245B, 0x51EC },
	{ 0x245C, 0x5223 },
	{ 0x245D, 0x5227 },
	{ 0x245E, 0x5226 },
	{ 0x245F, 0x521F },
	{ 0x2460, 0x522B },
	{ 0x2461, 0x5220 },
	{ 0x2462, 0x52B4 },
	{ 0x2463, 0x52B3 },
	{ 0x2464, 0x3518 },
	{ 0x2465, 0x5325 },
	{ 0x2466, 0x533B },
	{ 0x2467, 0x5374 },
	{ 0x2468, 0x3547 },
	{ 0x2469, 0x3546 },
	{ 0x246A, 0x3545 },
	{ 0x246B, 0x356B },
	{ 0x246C, 0x3569 },
	{ 0x246D, 0x544D },
	{ 0x246E, 0x3572 },
	{ 0x246F, 0x3571 },
	{ 0x2470, 0x543A },
	{ 0x2471, 0x356C },
	{ 0x2472, 0x356F },
	{ 0x2473, 0x5444 },
	{ 0x2474, 0x544C },
	{ 0x2475, 0x5423 },
	{ 0x2476, 0x541A },
	{ 0x2477, 0x5432 },
	{ 0x2478, 0x544B },
	{ 0x2479, 0x5421 },
	{ 0x247A, 0x3573 },
	{ 0x247B, 0x5434 },
	{ 0x247C, 0x5449 },
	{ 0x247D, 0x5450 },
	{ 0x247E, 0x5422 },
	{ 0x2521, 0x543F },
	{ 0x2522, 0x5451 },
	{ 0x2523, 0x545A },
	{ 0x2524, 0x542F },
	{ 0x2525, 0x3576 },
	{ 0x2526, 0x56E9 },
	{ 0x2527, 0x56F2 },
	{ 0x2528, 0x56F3 },
	{ 0x2529, 0x56EF },
	{ 0x252A, 0x56ED },
	{ 0x252B, 0x56EC },
	{ 0x252C, 0x56E6 },
	{ 0x252D, 0x5748 },
	{ 0x252E, 0x3627 },
	{ 0x252F, 0x5744 },
	{ 0x2530, 0x573F },
	{ 0x2531, 0x573C },
	{ 0x2532, 0x5753 },
	{ 0x2533, 0x5756 },
	{ 0x2534, 0x3630 },
	{ 0x2535, 0x575F },
	{ 0x2536, 0x5743 },
	{ 0x2537, 0x5758 },
	{ 0x2538, 0x5757 },
	{ 0x2539, 0x3629 },
	{ 0x253A, 0x362A },
	{ 0x253B, 0x362F },
	{ 0x253C, 0x5746 },
	{ 0x253D, 0x362C },
	{ 0x253E, 0x573D },
	{ 0x253F, 0x362D },
	{ 0x2540, 0x5742 },
	{ 0x2541, 0x5754 },
	{ 0x2542, 0x5755 },
	{ 0x2543, 0x58F1 },
	{ 0x2544, 0x58F2 },
	{ 0x2545, 0x58F0 },
	{ 0x2546, 0x590B },
	{ 0x2547, 0x9EA6 },
	{ 0x2548, 0x56F1 },
	{ 0x2549, 0x593D },
	{ 0x254A, 0x3693 },
	{ 0x254B, 0x5994 },
	{ 0x254C, 0x598C },
	{ 0x254D, 0x36AD },
	{ 0x254E, 0x599C },
	{ 0x254F, 0x36AC },
	{ 0x2550, 0x36AB },
	{ 0x2551, 0x599F },
	{ 0x2552, 0x36A9 },
	{ 0x2553, 0x599B },
	{ 0x2554, 0x36AE },
	{ 0x2555, 0x5989 },
	{ 0x2556, 0x599A },
	{ 0x2557, 0x36AA },
	{ 0x2558, 0x6588 },
	{ 0x2559, 0x374E },
	{ 0x255A, 0x5B8D },
	{ 0x255B, 0x3750 },
	{ 0x255C, 0x5BFE },
	{ 0x255D, 0x5BFF },
	{ 0x255E, 0x5BFD },
	{ 0x255F, 0x5C2B },
	{ 0x2560, 0x37B2 },
	{ 0x2561, 0x5C84 },
	{ 0x2562, 0x5C8E },
	{ 0x2563, 0x5C9C },
	{ 0x2564, 0x37B5 },
	{ 0x2565, 0x37B6 },
	{ 0x2566, 0x5C85 },
	{ 0x2567, 0x5DF5 },
	{ 0x2568, 0x5E09 },
	{ 0x2569, 0x3839 },
	{ 0x256A, 0x383B },
	{ 0x256B, 0x5E0B },
	{ 0x256C, 0x3872 },
	{ 0x256D, 0x5E92 },
	{ 0x256E, 0x5E90 },
	{ 0x256F, 0x5F03 },
	{ 0x2570, 0x38AC },
	{ 0x2571, 0x5F1E },
	{ 0x2572, 0x5F63 },
	{ 0x2573, 0x3908 },
	{ 0x2574, 0x5FE7 },
	{ 0x2575, 0x5FFE },
	{ 0x2576, 0x5FE6 },
	{ 0x2577, 0x5FDC },
	{ 0x2578, 0x5FCE },
	{ 0x2579, 0x3903 },
	{ 0x257A, 0x5FFC },
	{ 0x257B, 0x5FDF },
	{ 0x257C, 0x5FEC },
	{ 0x257D, 0x5FF6 },
	{ 0x257E, 0x225D7 },
	{ 0x2621, 0x5FF2 },
	{ 0x2622, 0x5FF0 },
	{ 0x2623, 0x5FF9 },
	{ 0x2624, 0x390B },
	{ 0x2625, 0x6213 },
	{ 0x2626, 0x39AF },
	{ 0x2627, 0x2F8B2 },
	{ 0x2628, 0x623B },
	{ 0x2629, 0x623C },
	{ 0x262A, 0x6282 },
	{ 0x262B, 0x39CE },
	{ 0x262C, 0x39CB },
	{ 0x262D, 0x39CC },
	{ 0x262E, 0x6278 },
	{ 0x262F, 0x628B },
	{ 0x2630, 0x39CD },
	{ 0x2631, 0x629E },
	{ 0x2632, 0x62A5 },
	{ 0x2633, 0x629B },
	{ 0x2634, 0x629C },
	{ 0x2635, 0x6299 },
	{ 0x2636, 0x628D },
	{ 0x2637, 0x6285 },
	{ 0x2638, 0x629D },
	{ 0x2639, 0x6275 },
	{ 0x263A, 0x3A80 },
	{ 0x263B, 0x3AAF },
	{ 0x263C, 0x3AD3 },
	{ 0x263D, 0x65F6 },
	{ 0x263E, 0x3AD5 },
	{ 0x263F, 0x3AD4 },
	{ 0x2640, 0x3AD7 },
	{ 0x2641, 0x66F5 },
	{ 0x2642, 0x675B },
	{ 0x2643, 0x3B42 },
	{ 0x2644, 0x6754 },
	{ 0x2645, 0x6752 },
	{ 0x2646, 0x3B44 },
	{ 0x2647, 0x6758 },
	{ 0x2648, 0x6744 },
	{ 0x2649, 0x674A },
	{ 0x264A, 0x6761 },
	{ 0x264B, 0x3CC6 },
	{ 0x264C, 0x6C7F },
	{ 0x264D, 0x6C91 },
	{ 0x264E, 0x6C9E },
	{ 0x264F, 0x3CC0 },
	{ 0x2650, 0x6C6E },
	{ 0x2651, 0x6C7C },
	{ 0x2652, 0x6C9F },
	{ 0x2653, 0x6C75 },
	{ 0x2654, 0x3CBE },
	{ 0x2655, 0x6C56 },
	{ 0x2656, 0x6CA2 },
	{ 0x2657, 0x6C79 },
	{ 0x2658, 0x3CCA },
	{ 0x2659, 0x6CA1 },
	{ 0x265A, 0x3CC4 },
	{ 0x265B, 0x6CAA },
	{ 0x265C, 0x6CA0 },
	{ 0x265D, 0x3CC2 },
	{ 0x265E, 0x7079 },
	{ 0x265F, 0x7077 },
	{ 0x2660, 0x707E },
	{ 0x2661, 0x3DA4 },
	{ 0x2662, 0x7075 },
	{ 0x2663, 0x707B },
	{ 0x2664, 0x7264 },
	{ 0x2665, 0x3E29 },
	{ 0x2666, 0x72BB },
	{ 0x2667, 0x72BC },
	{ 0x2668, 0x72C7 },
	{ 0x2669, 0x72B9 },
	{ 0x266A, 0x72BE },
	{ 0x266B, 0x72B6 },
	{ 0x266C, 0x3E60 },
	{ 0x266D, 0x3E5E },
	{ 0x266E, 0x7398 },
	{ 0x266F, 0x3EAD },
	{ 0x2670, 0x3EAE },
	{ 0x2671, 0x3EAC },
	{ 0x2672, 0x3F57 },
	{ 0x2673, 0x7593 },
	{ 0x2674, 0x7680 },
	{ 0x2675, 0x3FDD },
	{ 0x2676, 0x7683 },
	{ 0x2677, 0x76C0 },
	{ 0x2678, 0x76C1 },
	{ 0x2679, 0x400E },
	{ 0x267A, 0x4097 },
	{ 0x267B, 0x77F4 },
	{ 0x267C, 0x77F5 },
	{ 0x267D, 0x4127 },
	{ 0x267E, 0x7ACC },
	{ 0x2721, 0x7ACD },
	{ 0x2722, 0x7CFA },
	{ 0x2723, 0x809F },
	{ 0x2724, 0x8091 },
	{ 0x2725, 0x8097 },
	{ 0x2726, 0x8094 },
	{ 0x2727, 0x4495 },
	{ 0x2728, 0x8286 },
	{ 0x2729, 0x828C },
	{ 0x272A, 0x2F98F },
	{ 0x272B, 0x8295 },
	{ 0x272C, 0x4498 },
	{ 0x272D, 0x866C },
	{ 0x272E, 0x459D },
	{ 0x272F, 0x8FB5 },
	{ 0x2730, 0x8FBE },
	{ 0x2731, 0x8FC7 },
	{ 0x2732, 0x488A },
	{ 0x2733, 0x8FC1 },
	{ 0x2734, 0x90A9 },
	{ 0x2735, 0x90A4 },
	{ 0x2736, 0x48B5 },
	{ 0x2737, 0x48B6 },
	{ 0x2738, 0x48B7 },
	{ 0x2739, 0x90A8 },
	{ 0x273A, 0x9627 },
	{ 0x273B, 0x9626 },
	{ 0x273C, 0x962B },
	{ 0x273D, 0x9633 },
	{ 0x273E, 0x9634 },
	{ 0x273F, 0x9629 },
	{ 0x2740, 0x4E3D },
	{ 0x2741, 0x3428 },
	{ 0x2742, 0x4E9D },
	{ 0x2743, 0x4F93 },
	{ 0x2744, 0x4F8A },
	{ 0x2745, 0x344D },
	{ 0x2746, 0x3449 },
	{ 0x2747, 0x4F6D },
	{ 0x2748, 0x4F8E },
	{ 0x2749, 0x4FA0 },
	{ 0x274A, 0x4FA2 },
	{ 0x274B, 0x4FA1 },
	{ 0x274C, 0x4F9F },
	{ 0x274D, 0x4FA3 },
	{ 0x274E, 0x20209 },
	{ 0x274F, 0x4F72 },
	{ 0x2750, 0x3451 },
	{ 0x2751, 0x4F8C },
	{ 0x2752, 0x5156 },
	{ 0x2753, 0x2F80F },
	{ 0x2754, 0x2F811 },
	{ 0x2755, 0x5190 },
	{ 0x2756, 0x34CB },
	{ 0x2757, 0x34CA },
	{ 0x2758, 0x34CC },
	{ 0x2759, 0x51ED },
	{ 0x275A, 0x51FE },
	{ 0x275B, 0x522F },
	{ 0x275C, 0x206EC },
	{ 0x275D, 0x523C },
	{ 0x275E, 0x5234 },
	{ 0x275F, 0x5239 },
	{ 0x2760, 0x52B9 },
	{ 0x2761, 0x52B5 },
	{ 0x2762, 0x52BF },
	{ 0x2763, 0x5355 },
	{ 0x2764, 0x353D },
	{ 0x2765, 0x5376 },
	{ 0x2766, 0x537A },
	{ 0x2767, 0x5393 },
	{ 0x2768, 0x3548 },
	{ 0x2769, 0x53C1 },
	{ 0x276A, 0x53C2 },
	{ 0x276B, 0x53D5 },
	{ 0x276C, 0x5485 },
	{ 0x276D, 0x3578 },
	{ 0x276E, 0x545F },
	{ 0x276F, 0x5493 },
	{ 0x2770, 0x5489 },
	{ 0x2771, 0x5479 },
	{ 0x2772, 0x9EFE },
	{ 0x2773, 0x548F },
	{ 0x2774, 0x5469 },
	{ 0x2775, 0x546D },
	{ 0x2776, 0x357A },
	{ 0x2777, 0x5494 },
	{ 0x2778, 0x546A },
	{ 0x2779, 0x548A },
	{ 0x277A, 0x3577 },
	{ 0x277B, 0x56FD },
	{ 0x277C, 0x56FB },
	{ 0x277D, 0x56F8 },
	{ 0x277E, 0x3621 },
	{ 0x2821, 0x56FC },
	{ 0x2822, 0x56F6 },
	{ 0x2823, 0x5765 },
	{ 0x2824, 0x5781 },
	{ 0x2825, 0x5763 },
	{ 0x2826, 0x5767 },
	{ 0x2827, 0x3631 },
	{ 0x2828, 0x576E },
	{ 0x2829, 0x5778 },
	{ 0x282A, 0x577F },
	{ 0x282B, 0x3633 },
	{ 0x282C, 0x3634 },
	{ 0x282D, 0x58F3 },
	{ 0x282E, 0x594B },
	{ 0x282F, 0x594C },
	{ 0x2830, 0x36C1 },
	{ 0x2831, 0x36B0 },
	{ 0x2832, 0x36B4 },
	{ 0x2833, 0x59AD },
	{ 0x2834, 0x36B8 },
	{ 0x2835, 0x59C4 },
	{ 0x2836, 0x36BC },
	{ 0x2837, 0x59C2 },
	{ 0x2838, 0x59B0 },
	{ 0x2839, 0x36BF },
	{ 0x283A, 0x36B5 },
	{ 0x283B, 0x36B1 },
	{ 0x283C, 0x36BD },
	{ 0x283D, 0x59BF },
	{ 0x283E, 0x36BB },
	{ 0x283F, 0x59C9 },
	{ 0x2840, 0x59B8 },
	{ 0x2841, 0x59AC },
	{ 0x2842, 0x36B3 },
	{ 0x2843, 0x36B6 },
	{ 0x2844, 0x36BA },
	{ 0x2845, 0x59B7 },
	{ 0x2846, 0x59D7 },
	{ 0x2847, 0x36B7 },
	{ 0x2848, 0x5B60 },
	{ 0x2849, 0x3740 },
	{ 0x284A, 0x5B96 },
	{ 0x284B, 0x5B9E },
	{ 0x284C, 0x5B94 },
	{ 0x284D, 0x5B9F },
	{ 0x284E, 0x5B9D },
	{ 0x284F, 0x3752 },
	{ 0x2850, 0x5C00 },
	{ 0x2851, 0x5C19 },
	{ 0x2852, 0x3790 },
	{ 0x2853, 0x3791 },
	{ 0x2854, 0x5C49 },
	{ 0x2855, 0x5C4A },
	{ 0x2856, 0x37BE },
	{ 0x2857, 0x5CBB },
	{ 0x2858, 0x5CC1 },
	{ 0x2859, 0x37C0 },
	{ 0x285A, 0x37C1 },
	{ 0x285B, 0x37B9 },
	{ 0x285C, 0x5CB9 },
	{ 0x285D, 0x5C9E },
	{ 0x285E, 0x5CB4 },
	{ 0x285F, 0x5CBA },
	{ 0x2860, 0x5DF6 },
	{ 0x2861, 0x5E13 },
	{ 0x2862, 0x5E12 },
	{ 0x2863, 0x5E77 },
	{ 0x2864, 0x3879 },
	{ 0x2865, 0x5E98 },
	{ 0x2866, 0x387B },
	{ 0x2867, 0x5E99 },
	{ 0x2868, 0x5E9D },
	{ 0x2869, 0x5EF8 },
	{ 0x286A, 0x38A0 },
	{ 0x286B, 0x5EF9 },
	{ 0x286C, 0x3429 },
	{ 0x286D, 0x5F06 },
	{ 0x286E, 0x5F21 },
	{ 0x286F, 0x38AE },
	{ 0x2870, 0x5F25 },
	{ 0x2871, 0x5F55 },
	{ 0x2872, 0x38CD },
	{ 0x2873, 0x38CB },
	{ 0x2874, 0x38D9 },
	{ 0x2875, 0x5F84 },
	{ 0x2876, 0x5F83 },
	{ 0x2877, 0x6030 },
	{ 0x2878, 0x6007 },
	{ 0x2879, 0x390C },
	{ 0x287A, 0x6036 },
	{ 0x287B, 0x3901 },
	{ 0x287C, 0x3905 },
	{ 0x287D, 0x3902 },
	{ 0x287E, 0x5FE9 },
	{ 0x2921, 0x603D },
	{ 0x2922, 0x6008 },
	{ 0x2923, 0x3913 },
	{ 0x2924, 0x3911 },
	{ 0x2925, 0x62BA },
	{ 0x2926, 0x62B2 },
	{ 0x2927, 0x39E4 },
	{ 0x2928, 0x62B7 },
	{ 0x2929, 0x62E4 },
	{ 0x292A, 0x62A7 },
	{ 0x292B, 0x39DA },
	{ 0x292C, 0x39D5 },
	{ 0x292D, 0x39D3 },
	{ 0x292E, 0x62D5 },
	{ 0x292F, 0x62E1 },
	{ 0x2930, 0x62DD },
	{ 0x2931, 0x62A6 },
	{ 0x2932, 0x62C1 },
	{ 0x2933, 0x62C5 },
	{ 0x2934, 0x62C0 },
	{ 0x2935, 0x62DF },
	{ 0x2936, 0x62E0 },
	{ 0x2937, 0x62DE },
	{ 0x2938, 0x39D6 },
	{ 0x2939, 0x6589 },
	{ 0x293A, 0x3AB4 },
	{ 0x293B, 0x65A6 },
	{ 0x293C, 0x65BA },
	{ 0x293D, 0x3AD9 },
	{ 0x293E, 0x65FF },
	{ 0x293F, 0x3AD8 },
	{ 0x2940, 0x6617 },
	{ 0x2941, 0x6618 },
	{ 0x2942, 0x6601 },
	{ 0x2943, 0x65FE },
	{ 0x2944, 0x3B33 },
	{ 0x2945, 0x670C },
	{ 0x2946, 0x3B48 },
	{ 0x2947, 0x676B },
	{ 0x2948, 0x6796 },
	{ 0x2949, 0x6782 },
	{ 0x294A, 0x678A },
	{ 0x294B, 0x3B47 },
	{ 0x294C, 0x67A3 },
	{ 0x294D, 0x3B4B },
	{ 0x294E, 0x67A2 },
	{ 0x294F, 0x678F },
	{ 0x2950, 0x3B4A },
	{ 0x2951, 0x67F9 },
	{ 0x2952, 0x6780 },
	{ 0x2953, 0x6B26 },
	{ 0x2954, 0x6B27 },
	{ 0x2955, 0x6B68 },
	{ 0x2956, 0x6B69 },
	{ 0x2957, 0x3C5A },
	{ 0x2958, 0x6B81 },
	{ 0x2959, 0x6BB4 },
	{ 0x295A, 0x6BD1 },
	{ 0x295B, 0x3C8E },
	{ 0x295C, 0x3CB4 },
	{ 0x295D, 0x6C1C },
	{ 0x295E, 0x3CCD },
	{ 0x295F, 0x3CCC },
	{ 0x2960, 0x3CCF },
	{ 0x2961, 0x3CCB },
	{ 0x2962, 0x3CCE },
	{ 0x2963, 0x6C97 },
	{ 0x2964, 0x6C6C },
	{ 0x2965, 0x6CDF },
	{ 0x2966, 0x3CD2 },
	{ 0x2967, 0x6CEA },
	{ 0x2968, 0x3CD1 },
	{ 0x2969, 0x6CE4 },
	{ 0x296A, 0x6CD8 },
	{ 0x296B, 0x6CB2 },
	{ 0x296C, 0x6CCE },
	{ 0x296D, 0x6CC8 },
	{ 0x296E, 0x3DA6 },
	{ 0x296F, 0x708B },
	{ 0x2970, 0x7088 },
	{ 0x2971, 0x7090 },
	{ 0x2972, 0x708F },
	{ 0x2973, 0x3DAA },
	{ 0x2974, 0x7087 },
	{ 0x2975, 0x7089 },
	{ 0x2976, 0x708D },
	{ 0x2977, 0x7081 },
	{ 0x2978, 0x3DA8 },
	{ 0x2979, 0x708C },
	{ 0x297A, 0x3E13 },
	{ 0x297B, 0x3E1A },
	{ 0x297C, 0x7240 },
	{ 0x297D, 0x3E1D },
	{ 0x297E, 0x3E1E },
	{ 0x2A21, 0x7265 },
	{ 0x2A22, 0x7266 },
	{ 0x2A23, 0x7268 },
	{ 0x2A24, 0x3E65 },
	{ 0x2A25, 0x3E66 },
	{ 0x2A26, 0x72CD },
	{ 0x2A27, 0x72D3 },
	{ 0x2A28, 0x72DB },
	{ 0x2A29, 0x3E64 },
	{ 0x2A2A, 0x72CF },
	{ 0x2A2B, 0x73A7 },
	{ 0x2A2C, 0x73A3 },
	{ 0x2A2D, 0x739E },
	{ 0x2A2E, 0x3EB0 },
	{ 0x2A2F, 0x73AF },
	{ 0x2A30, 0x3EB3 },
	{ 0x2A31, 0x3EB5 },
	{ 0x2A32, 0x73AA },
	{ 0x2A33, 0x739C },
	{ 0x2A34, 0x3F19 },
	{ 0x2A35, 0x7542 },
	{ 0x2A36, 0x7544 },
	{ 0x2A37, 0x753B },
	{ 0x2A38, 0x7541 },
	{ 0x2A39, 0x2233F },
	{ 0x2A3A, 0x759B },
	{ 0x2A3B, 0x759E },
	{ 0x2A3C, 0x3F75 },
	{ 0x2A3D, 0x79C4 },
	{ 0x2A3E, 0x79C3 },
	{ 0x2A3F, 0x79C6 },
	{ 0x2A40, 0x412B },
	{ 0x2A41, 0x412C },
	{ 0x2A42, 0x79C7 },
	{ 0x2A43, 0x412D },
	{ 0x2A44, 0x79CA },
	{ 0x2A45, 0x2592E },
	{ 0x2A46, 0x41C3 },
	{ 0x2A47, 0x7ACF },
	{ 0x2A48, 0x7C76 },
	{ 0x2A49, 0x7C74 },
	{ 0x2A4A, 0x7CFF },
	{ 0x2A4B, 0x7CFC },
	{ 0x2A4C, 0x34BA },
	{ 0x2A4D, 0x4350 },
	{ 0x2A4E, 0x7F59 },
	{ 0x2A4F, 0x80A8 },
	{ 0x2A50, 0x43D3 },
	{ 0x2A51, 0x43D0 },
	{ 0x2A52, 0x80B0 },
	{ 0x2A53, 0x43DC },
	{ 0x2A54, 0x80B3 },
	{ 0x2A55, 0x43D2 },
	{ 0x2A56, 0x80A4 },
	{ 0x2A57, 0x80B6 },
	{ 0x2A58, 0x80A7 },
	{ 0x2A59, 0x80AC },
	{ 0x2A5A, 0x43DB },
	{ 0x2A5B, 0x80A6 },
	{ 0x2A5C, 0x5367 },
	{ 0x2A5D, 0x820E },
	{ 0x2A5E, 0x82C4 },
	{ 0x2A5F, 0x833E },
	{ 0x2A60, 0x829C },
	{ 0x2A61, 0x44A5 },
	{ 0x2A62, 0x449F },
	{ 0x2A63, 0x449A },
	{ 0x2A64, 0x449C },
	{ 0x2A65, 0x44A2 },
	{ 0x2A66, 0x82AA },
	{ 0x2A67, 0x449B },
	{ 0x2A68, 0x82C9 },
	{ 0x2A69, 0x44A3 },
	{ 0x2A6A, 0x449D },
	{ 0x2A6B, 0x82A6 },
	{ 0x2A6C, 0x82B2 },
	{ 0x2A6D, 0x4588 },
	{ 0x2A6E, 0x461A },
	{ 0x2A6F, 0x488D },
	{ 0x2A70, 0x8FCC },
	{ 0x2A71, 0x8FD9 },
	{ 0x2A72, 0x8FCA },
	{ 0x2A73, 0x8FD8 },
	{ 0x2A74, 0x8FCF },
	{ 0x2A75, 0x90B7 },
	{ 0x2A76, 0x48B8 },
	{ 0x2A77, 0x90AD },
	{ 0x2A78, 0x90B9 },
	{ 0x2A79, 0x9637 },
	{ 0x2A7A, 0x49C3 },
	{ 0x2A7B, 0x9641 },
	{ 0x2A7C, 0x963E },
	{ 0x2A7D, 0x96B6 },
	{ 0x2A7E, 0x9751 },
	{ 0x2B21, 0x9763 },
	{ 0x2B22, 0x4E57 },
	{ 0x2B23, 0x4E79 },
	{ 0x2B24, 0x4EB2 },
	{ 0x2B25, 0x4EB0 },
	{ 0x2B26, 0x4EAF },
	{ 0x2B27, 0x4EB1 },
	{ 0x2B28, 0x4FD2 },
	{ 0x2B29, 0x4FD5 },
	{ 0x2B2A, 0x345D },
	{ 0x2B2B, 0x4FBE },
	{ 0x2B2C, 0x4FB8 },
	{ 0x2B2D, 0x4FB0 },
	{ 0x2B2E, 0x4FB1 },
	{ 0x2B2F, 0x4FC8 },
	{ 0x2B30, 0x345A },
	{ 0x2B31, 0x3457 },
	{ 0x2B32, 0x4FC6 },
	{ 0x2B33, 0x4FCC },
	{ 0x2B34, 0x4FE5 },
	{ 0x2B35, 0x4FE3 },
	{ 0x2B36, 0x4FB4 },
	{ 0x2B37, 0x516A },
	{ 0x2B38, 0x34B8 },
	{ 0x2B39, 0x519F },
	{ 0x2B3A, 0x34C2 },
	{ 0x2B3B, 0x51C1 },
	{ 0x2B3C, 0x34CF },
	{ 0x2B3D, 0x51C2 },
	{ 0x2B3E, 0x51C3 },
	{ 0x2B3F, 0x5245 },
	{ 0x2B40, 0x5248 },
	{ 0x2B41, 0x34E7 },
	{ 0x2B42, 0x34E9 },
	{ 0x2B43, 0x524F },
	{ 0x2B44, 0x4452 },
	{ 0x2B45, 0x34E8 },
	{ 0x2B46, 0x52C5 },
	{ 0x2B47, 0x52CA },
	{ 0x2B48, 0x52C4 },
	{ 0x2B49, 0x5327 },
	{ 0x2B4A, 0x5358 },
	{ 0x2B4B, 0x537D },
	{ 0x2B4C, 0x354A },
	{ 0x2B4D, 0x53DD },
	{ 0x2B4E, 0x53DC },
	{ 0x2B4F, 0x53DA },
	{ 0x2B50, 0x53D9 },
	{ 0x2B51, 0x54B9 },
	{ 0x2B52, 0x3580 },
	{ 0x2B53, 0x54D0 },
	{ 0x2B54, 0x54B4 },
	{ 0x2B55, 0x54CA },
	{ 0x2B56, 0x3587 },
	{ 0x2B57, 0x54A3 },
	{ 0x2B58, 0x54DA },
	{ 0x2B59, 0x54A4 },
	{ 0x2B5A, 0x3584 },
	{ 0x2B5B, 0x54B2 },
	{ 0x2B5C, 0x549E },
	{ 0x2B5D, 0x549F },
	{ 0x2B5E, 0x54B5 },
	{ 0x2B5F, 0x3582 },
	{ 0x2B60, 0x3581 },
	{ 0x2B61, 0x54CD },
	{ 0x2B62, 0x3583 },
	{ 0x2B63, 0x54CC },
	{ 0x2B64, 0x3622 },
	{ 0x2B65, 0x5700 },
	{ 0x2B66, 0x57AC },
	{ 0x2B67, 0x5791 },
	{ 0x2B68, 0x578E },
	{ 0x2B69, 0x578D },
	{ 0x2B6A, 0x5792 },
	{ 0x2B6B, 0x57A1 },
	{ 0x2B6C, 0x5790 },
	{ 0x2B6D, 0x57A6 },
	{ 0x2B6E, 0x57A8 },
	{ 0x2B6F, 0x363B },
	{ 0x2B70, 0x579C },
	{ 0x2B71, 0x5796 },
	{ 0x2B72, 0x57A7 },
	{ 0x2B73, 0x363A },
	{ 0x2B74, 0x3638 },
	{ 0x2B75, 0x3639 },
	{ 0x2B76, 0x3636 },
	{ 0x2B77, 0x58F5 },
	{ 0x2B78, 0x3685 },
	{ 0x2B79, 0x5909 },
	{ 0x2B7A, 0x5908 },
	{ 0x2B7B, 0x3C54 },
	{ 0x2B7C, 0x5952 },
	{ 0x2B7D, 0x369A },
	{ 0x2B7E, 0x36C4 },
	{ 0x2C21, 0x59DF },
	{ 0x2C22, 0x36C5 },
	{ 0x2C23, 0x59EB },
	{ 0x2C24, 0x59EF },
	{ 0x2C25, 0x59F0 },
	{ 0x2C26, 0x59D5 },
	{ 0x2C27, 0x5A0D },
	{ 0x2C28, 0x5A04 },
	{ 0x2C29, 0x59F9 },
	{ 0x2C2A, 0x5A02 },
	{ 0x2C2B, 0x59F8 },
	{ 0x2C2C, 0x59E2 },
	{ 0x2C2D, 0x59D9 },
	{ 0x2C2E, 0x59E7 },
	{ 0x2C2F, 0x5B6A },
	{ 0x2C30, 0x3754 },
	{ 0x2C31, 0x3755 },
	{ 0x2C32, 0x5BAB },
	{ 0x2C33, 0x3756 },
	{ 0x2C34, 0x5C1B },
	{ 0x2C35, 0x5C2F },
	{ 0x2C36, 0x3796 },
	{ 0x2C37, 0x663C },
	{ 0x2C38, 0x3795 },
	{ 0x2C39, 0x3794 },
	{ 0x2C3A, 0x37C4 },
	{ 0x2C3B, 0x5CD1 },
	{ 0x2C3C, 0x5CDC },
	{ 0x2C3D, 0x5CE6 },
	{ 0x2C3E, 0x5CE1 },
	{ 0x2C3F, 0x5CCD },
	{ 0x2C40, 0x2F87A },
	{ 0x2C41, 0x5CE2 },
	{ 0x2C42, 0x5CDD },
	{ 0x2C43, 0x5CE5 },
	{ 0x2C44, 0x5DFB },
	{ 0x2C45, 0x5DFA },
	{ 0x2C46, 0x5E1E },
	{ 0x2C47, 0x3844 },
	{ 0x2C48, 0x5EA1 },
	{ 0x2C49, 0x387D },
	{ 0x2C4A, 0x387E },
	{ 0x2C4B, 0x5EFC },
	{ 0x2C4C, 0x5EFB },
	{ 0x2C4D, 0x5F2F },
	{ 0x2C4E, 0x38B2 },
	{ 0x2C4F, 0x38B6 },
	{ 0x2C50, 0x5F66 },
	{ 0x2C51, 0x2F899 },
	{ 0x2C52, 0x38DC },
	{ 0x2C53, 0x38DF },
	{ 0x2C54, 0x605C },
	{ 0x2C55, 0x3928 },
	{ 0x2C56, 0x604E },
	{ 0x2C57, 0x6051 },
	{ 0x2C58, 0x3919 },
	{ 0x2C59, 0x3910 },
	{ 0x2C5A, 0x6023 },
	{ 0x2C5B, 0x6031 },
	{ 0x2C5C, 0x607C },
	{ 0x2C5D, 0x6052 },
	{ 0x2C5E, 0x392C },
	{ 0x2C5F, 0x6060 },
	{ 0x2C60, 0x604A },
	{ 0x2C61, 0x6061 },
	{ 0x2C62, 0x391B },
	{ 0x2C63, 0x6218 },
	{ 0x2C64, 0x39C2 },
	{ 0x2C65, 0x39EF },
	{ 0x2C66, 0x39E3 },
	{ 0x2C67, 0x39E5 },
	{ 0x2C68, 0x39EA },
	{ 0x2C69, 0x39E6 },
	{ 0x2C6A, 0x39EE },
	{ 0x2C6B, 0x631F },
	{ 0x2C6C, 0x6317 },
	{ 0x2C6D, 0x62EA },
	{ 0x2C6E, 0x6321 },
	{ 0x2C6F, 0x6304 },
	{ 0x2C70, 0x6305 },
	{ 0x2C71, 0x39E8 },
	{ 0x2C72, 0x6531 },
	{ 0x2C73, 0x6544 },
	{ 0x2C74, 0x6540 },
	{ 0x2C75, 0x3A85 },
	{ 0x2C76, 0x6542 },
	{ 0x2C77, 0x65BE },
	{ 0x2C78, 0x3AE0 },
	{ 0x2C79, 0x6629 },
	{ 0x2C7A, 0x661B },
	{ 0x2C7B, 0x3ADD },
	{ 0x2C7C, 0x6623 },
	{ 0x2C7D, 0x662C },
	{ 0x2C7E, 0x661A },
	{ 0x2D21, 0x6630 },
	{ 0x2D22, 0x663B },
	{ 0x2D23, 0x661E },
	{ 0x2D24, 0x6637 },
	{ 0x2D25, 0x6638 },
	{ 0x2D26, 0x3AE1 },
	{ 0x2D27, 0x670E },
	{ 0x2D28, 0x3B51 },
	{ 0x2D29, 0x3B55 },
	{ 0x2D2A, 0x67E8 },
	{ 0x2D2B, 0x67D6 },
	{ 0x2D2C, 0x3B52 },
	{ 0x2D2D, 0x67C7 },
	{ 0x2D2E, 0x67BC },
	{ 0x2D2F, 0x6852 },
	{ 0x2D30, 0x67BF },
	{ 0x2D31, 0x67D5 },
	{ 0x2D32, 0x67FE },
	{ 0x2D33, 0x8363 },
	{ 0x2D34, 0x67FB },
	{ 0x2D35, 0x2F8DF },
	{ 0x2D36, 0x67B1 },
	{ 0x2D37, 0x6801 },
	{ 0x2D38, 0x6805 },
	{ 0x2D39, 0x6800 },
	{ 0x2D3A, 0x67D7 },
	{ 0x2D3B, 0x409E },
	{ 0x2D3C, 0x6B2A },
	{ 0x2D3D, 0x6B6B },
	{ 0x2D3E, 0x3C52 },
	{ 0x2D3F, 0x3C5E },
	{ 0x2D40, 0x3C60 },
	{ 0x2D41, 0x3C5F },
	{ 0x2D42, 0x6BE1 },
	{ 0x2D43, 0x3C92 },
	{ 0x2D44, 0x3CD6 },
	{ 0x2D45, 0x6D23 },
	{ 0x2D46, 0x6CFF },
	{ 0x2D47, 0x6D14 },
	{ 0x2D48, 0x6D05 },
	{ 0x2D49, 0x6D13 },
	{ 0x2D4A, 0x6D06 },
	{ 0x2D4B, 0x6D21 },
	{ 0x2D4C, 0x3CDE },
	{ 0x2D4D, 0x6D15 },
	{ 0x2D4E, 0x6CAF },
	{ 0x2D4F, 0x6CF4 },
	{ 0x2D50, 0x6D02 },
	{ 0x2D51, 0x6D45 },
	{ 0x2D52, 0x2F8FE },
	{ 0x2D53, 0x6D26 },
	{ 0x2D54, 0x3CD9 },
	{ 0x2D55, 0x6D44 },
	{ 0x2D56, 0x3CDD },
	{ 0x2D57, 0x6D24 },
	{ 0x2D58, 0x70A5 },
	{ 0x2D59, 0x3DAC },
	{ 0x2D5A, 0x70A3 },
	{ 0x2D5B, 0x3DB0 },
	{ 0x2D5C, 0x70A2 },
	{ 0x2D5D, 0x70BB },
	{ 0x2D5E, 0x70A0 },
	{ 0x2D5F, 0x70AA },
	{ 0x2D60, 0x3DAF },
	{ 0x2D61, 0x3DAE },
	{ 0x2D62, 0x70A8 },
	{ 0x2D63, 0x70B6 },
	{ 0x2D64, 0x70B2 },
	{ 0x2D65, 0x70A7 },
	{ 0x2D66, 0x3DAD },
	{ 0x2D67, 0x3DAB },
	{ 0x2D68, 0x70B9 },
	{ 0x2D69, 0x722E },
	{ 0x2D6A, 0x3E16 },
	{ 0x2D6B, 0x723C },
	{ 0x2D6C, 0x3E30 },
	{ 0x2D6D, 0x726D },
	{ 0x2D6E, 0x3E33 },
	{ 0x2D6F, 0x3E31 },
	{ 0x2D70, 0x72E7 },
	{ 0x2D71, 0x72ED },
	{ 0x2D72, 0x3E6E },
	{ 0x2D73, 0x72EC },
	{ 0x2D74, 0x72E5 },
	{ 0x2D75, 0x72E2 },
	{ 0x2D76, 0x3EB1 },
	{ 0x2D77, 0x73C4 },
	{ 0x2D78, 0x73BD },
	{ 0x2D79, 0x73CF },
	{ 0x2D7A, 0x73C9 },
	{ 0x2D7B, 0x73C1 },
	{ 0x2D7C, 0x73D0 },
	{ 0x2D7D, 0x3EB7 },
	{ 0x2D7E, 0x73CE },
	{ 0x2E21, 0x74ED },
	{ 0x2E22, 0x74EB },
	{ 0x2E23, 0x3F1A },
	{ 0x2E24, 0x74EF },
	{ 0x2E25, 0x7549 },
	{ 0x2E26, 0x7550 },
	{ 0x2E27, 0x7546 },
	{ 0x2E28, 0x754A },
	{ 0x2E29, 0x3F59 },
	{ 0x2E2A, 0x754D },
	{ 0x2E2B, 0x75A6 },
	{ 0x2E2C, 0x3F7A },
	{ 0x2E2D, 0x3F78 },
	{ 0x2E2E, 0x3F7B },
	{ 0x2E2F, 0x75A8 },
	{ 0x2E30, 0x3FDE },
	{ 0x2E31, 0x3FEC },
	{ 0x2E32, 0x76C7 },
	{ 0x2E33, 0x76FF },
	{ 0x2E34, 0x401E },
	{ 0x2E35, 0x76FD },
	{ 0x2E36, 0x77E6 },
	{ 0x2E37, 0x780A },
	{ 0x2E38, 0x409B },
	{ 0x2E39, 0x7804 },
	{ 0x2E3A, 0x780B },
	{ 0x2E3B, 0x7807 },
	{ 0x2E3C, 0x409D },
	{ 0x2E3D, 0x7815 },
	{ 0x2E3E, 0x7808 },
	{ 0x2E3F, 0x40FD },
	{ 0x2E40, 0x79D3 },
	{ 0x2E41, 0x79D4 },
	{ 0x2E42, 0x79D0 },
	{ 0x2E43, 0x79D7 },
	{ 0x2E44, 0x7A7C },
	{ 0x2E45, 0x4194 },
	{ 0x2E46, 0x4193 },
	{ 0x2E47, 0x7A7D },
	{ 0x2E48, 0x7A83 },
	{ 0x2E49, 0x7A82 },
	{ 0x2E4A, 0x41C6 },
	{ 0x2E4B, 0x7AD4 },
	{ 0x2E4C, 0x7AD5 },
	{ 0x2E4D, 0x7AD3 },
	{ 0x2E4E, 0x7AD0 },
	{ 0x2E4F, 0x7AD2 },
	{ 0x2E50, 0x7AFE },
	{ 0x2E51, 0x7AFC },
	{ 0x2E52, 0x7C77 },
	{ 0x2E53, 0x7C7C },
	{ 0x2E54, 0x7C7B },
	{ 0x2E55, 0x42B8 },
	{ 0x2E56, 0x2F96A },
	{ 0x2E57, 0x42B7 },
	{ 0x2E58, 0x42B9 },
	{ 0x2E59, 0x4353 },
	{ 0x2E5A, 0x25133 },
	{ 0x2E5B, 0x4352 },
	{ 0x2E5C, 0x4351 },
	{ 0x2E5D, 0x7F8F },
	{ 0x2E5E, 0x80D3 },
	{ 0x2E5F, 0x43E3 },
	{ 0x2E60, 0x80CB },
	{ 0x2E61, 0x80D2 },
	{ 0x2E62, 0x43E2 },
	{ 0x2E63, 0x8109 },
	{ 0x2E64, 0x80E2 },
	{ 0x2E65, 0x80DF },
	{ 0x2E66, 0x80C6 },
	{ 0x2E67, 0x4463 },
	{ 0x2E68, 0x8224 },
	{ 0x2E69, 0x82F7 },
	{ 0x2E6A, 0x82D8 },
	{ 0x2E6B, 0x82DD },
	{ 0x2E6C, 0x44AA },
	{ 0x2E6D, 0x44A6 },
	{ 0x2E6E, 0x82F8 },
	{ 0x2E6F, 0x82FC },
	{ 0x2E70, 0x44A8 },
	{ 0x2E71, 0x44A9 },
	{ 0x2E72, 0x82E9 },
	{ 0x2E73, 0x44AB },
	{ 0x2E74, 0x82EE },
	{ 0x2E75, 0x44AC },
	{ 0x2E76, 0x82D0 },
	{ 0x2E77, 0x830E },
	{ 0x2E78, 0x82E2 },
	{ 0x2E79, 0x830B },
	{ 0x2E7A, 0x82FD },
	{ 0x2E7B, 0x5179 },
	{ 0x2E7C, 0x8676 },
	{ 0x2E7D, 0x459E },
	{ 0x2E7E, 0x8678 },
	{ 0x2F21, 0x459F },
	{ 0x2F22, 0x45A0 },
	{ 0x2F23, 0x8675 },
	{ 0x2F24, 0x867D },
	{ 0x2F25, 0x460F },
	{ 0x2F26, 0x8842 },
	{ 0x2F27, 0x8866 },
	{ 0x2F28, 0x461C },
	{ 0x2F29, 0x898C },
	{ 0x2F2A, 0x8A05 },
	{ 0x2F2B, 0x46AE },
	{ 0x2F2C, 0x8A06 },
	{ 0x2F2D, 0x46B0 },
	{ 0x2F2E, 0x8C9F },
	{ 0x2F2F, 0x47D4 },
	{ 0x2F30, 0x8FF1 },
	{ 0x2F31, 0x8FE7 },
	{ 0x2F32, 0x8FE9 },
	{ 0x2F33, 0x8FEF },
	{ 0x2F34, 0x90C2 },
	{ 0x2F35, 0x90BC },
	{ 0x2F36, 0x48BB },
	{ 0x2F37, 0x90C6 },
	{ 0x2F38, 0x90C0 },
	{ 0x2F39, 0x48C1 },
	{ 0x2F3A, 0x48C2 },
	{ 0x2F3B, 0x90CD },
	{ 0x2F3C, 0x90C9 },
	{ 0x2F3D, 0x48BE },
	{ 0x2F3E, 0x90C4 },
	{ 0x2F3F, 0x48E5 },
	{ 0x2F40, 0x9581 },
	{ 0x2F41, 0x49C6 },
	{ 0x2F42, 0x9CEC },
	{ 0x2F43, 0x5032 },
	{ 0x2F44, 0x4FF9 },
	{ 0x2F45, 0x501D },
	{ 0x2F46, 0x4FFF },
	{ 0x2F47, 0x5004 },
	{ 0x2F48, 0x4FF0 },
	{ 0x2F49, 0x5003 },
	{ 0x2F4A, 0x462E },
	{ 0x2F4B, 0x5002 },
	{ 0x2F4C, 0x4FFC },
	{ 0x2F4D, 0x4FF2 },
	{ 0x2F4E, 0x5024 },
	{ 0x2F4F, 0x5008 },
	{ 0x2F50, 0x5036 },
	{ 0x2F51, 0x502E },
	{ 0x2F52, 0x3465 },
	{ 0x2F53, 0x5010 },
	{ 0x2F54, 0x5038 },
	{ 0x2F55, 0x5039 },
	{ 0x2F56, 0x4FFD },
	{ 0x2F57, 0x5056 },
	{ 0x2F58, 0x4FFB },
	{ 0x2F59, 0x51A3 },
	{ 0x2F5A, 0x51A6 },
	{ 0x2F5B, 0x51A1 },
	{ 0x2F5C, 0x34D1 },
	{ 0x2F5D, 0x34D0 },
	{ 0x2F5E, 0x51C7 },
	{ 0x2F5F, 0x51C9 },
	{ 0x2F60, 0x5260 },
	{ 0x2F61, 0x5264 },
	{ 0x2F62, 0x5259 },
	{ 0x2F63, 0x5265 },
	{ 0x2F64, 0x5267 },
	{ 0x2F65, 0x5257 },
	{ 0x2F66, 0x5263 },
	{ 0x2F67, 0x34EE },
	{ 0x2F68, 0x5253 },
	{ 0x2F69, 0x34EF },
	{ 0x2F6A, 0x52CF },
	{ 0x2F6B, 0x351E },
	{ 0x2F6C, 0x52CE },
	{ 0x2F6D, 0x52D0 },
	{ 0x2F6E, 0x52D1 },
	{ 0x2F6F, 0x52CC },
	{ 0x2F70, 0x354B },
	{ 0x2F71, 0x354D },
	{ 0x2F72, 0x3556 },
	{ 0x2F73, 0x550D },
	{ 0x2F74, 0x54F4 },
	{ 0x2F75, 0x3592 },
	{ 0x2F76, 0x5513 },
	{ 0x2F77, 0x54EF },
	{ 0x2F78, 0x54F5 },
	{ 0x2F79, 0x54F9 },
	{ 0x2F7A, 0x5502 },
	{ 0x2F7B, 0x5500 },
	{ 0x2F7C, 0x3593 },
	{ 0x2F7D, 0x3590 },
	{ 0x2F7E, 0x5518 },
	{ 0x3021, 0x54F0 },
	{ 0x3022, 0x54F6 },
	{ 0x3023, 0x2F841 },
	{ 0x3024, 0x3597 },
	{ 0x3025, 0x5519 },
	{ 0x3026, 0x3623 },
	{ 0x3027, 0x5705 },
	{ 0x3028, 0x57C9 },
	{ 0x3029, 0x363F },
	{ 0x302A, 0x57B7 },
	{ 0x302B, 0x57CD },
	{ 0x302C, 0x3643 },
	{ 0x302D, 0x3642 },
	{ 0x302E, 0x3644 },
	{ 0x302F, 0x57BE },
	{ 0x3030, 0x57BB },
	{ 0x3031, 0x3645 },
	{ 0x3032, 0x57DB },
	{ 0x3033, 0x57C8 },
	{ 0x3034, 0x57C4 },
	{ 0x3035, 0x57C5 },
	{ 0x3036, 0x57D1 },
	{ 0x3037, 0x57CA },
	{ 0x3038, 0x57C0 },
	{ 0x3039, 0x36D9 },
	{ 0x303A, 0x36DE },
	{ 0x303B, 0x5A21 },
	{ 0x303C, 0x5A2A },
	{ 0x303D, 0x36CF },
	{ 0x303E, 0x5A1D },
	{ 0x303F, 0x36CD },
	{ 0x3040, 0x5A0B },
	{ 0x3041, 0x36DD },
	{ 0x3042, 0x36CE },
	{ 0x3043, 0x36D3 },
	{ 0x3044, 0x36D6 },
	{ 0x3045, 0x5A22 },
	{ 0x3046, 0x36DC },
	{ 0x3047, 0x36D1 },
	{ 0x3048, 0x5A24 },
	{ 0x3049, 0x36D0 },
	{ 0x304A, 0x5A14 },
	{ 0x304B, 0x5A31 },
	{ 0x304C, 0x36D5 },
	{ 0x304D, 0x5A2F },
	{ 0x304E, 0x5A1A },
	{ 0x304F, 0x5A12 },
	{ 0x3050, 0x36D4 },
	{ 0x3051, 0x36DB },
	{ 0x3052, 0x5A26 },
	{ 0x3053, 0x2172E },
	{ 0x3054, 0x3743 },
	{ 0x3055, 0x5BBC },
	{ 0x3056, 0x5BBB },
	{ 0x3057, 0x5BB7 },
	{ 0x3058, 0x5C05 },
	{ 0x3059, 0x5C06 },
	{ 0x305A, 0x5C52 },
	{ 0x305B, 0x5C53 },
	{ 0x305C, 0x37CD },
	{ 0x305D, 0x37D1 },
	{ 0x305E, 0x5CFA },
	{ 0x305F, 0x5CEB },
	{ 0x3060, 0x37CA },
	{ 0x3061, 0x5CF3 },
	{ 0x3062, 0x5CF5 },
	{ 0x3063, 0x5CE9 },
	{ 0x3064, 0x5CEF },
	{ 0x3065, 0x37D4 },
	{ 0x3066, 0x5E2A },
	{ 0x3067, 0x5E30 },
	{ 0x3068, 0x5E2E },
	{ 0x3069, 0x5E2C },
	{ 0x306A, 0x5E2F },
	{ 0x306B, 0x5EAF },
	{ 0x306C, 0x5EA9 },
	{ 0x306D, 0x3886 },
	{ 0x306E, 0x5EFD },
	{ 0x306F, 0x5F32 },
	{ 0x3070, 0x5F8E },
	{ 0x3071, 0x5F93 },
	{ 0x3072, 0x5F8F },
	{ 0x3073, 0x604F },
	{ 0x3074, 0x6099 },
	{ 0x3075, 0x3933 },
	{ 0x3076, 0x607E },
	{ 0x3077, 0x3937 },
	{ 0x3078, 0x6074 },
	{ 0x3079, 0x604B },
	{ 0x307A, 0x6073 },
	{ 0x307B, 0x6075 },
	{ 0x307C, 0x392A },
	{ 0x307D, 0x391F },
	{ 0x307E, 0x6056 },
	{ 0x3121, 0x60A9 },
	{ 0x3122, 0x608B },
	{ 0x3123, 0x60A6 },
	{ 0x3124, 0x3939 },
	{ 0x3125, 0x6093 },
	{ 0x3126, 0x60AE },
	{ 0x3127, 0x609E },
	{ 0x3128, 0x60A7 },
	{ 0x3129, 0x6245 },
	{ 0x312A, 0x39F2 },
	{ 0x312B, 0x39F8 },
	{ 0x312C, 0x632E },
	{ 0x312D, 0x39F7 },
	{ 0x312E, 0x6352 },
	{ 0x312F, 0x6330 },
	{ 0x3130, 0x635B },
	{ 0x3131, 0x39F4 },
	{ 0x3132, 0x6319 },
	{ 0x3133, 0x631B },
	{ 0x3134, 0x39F1 },
	{ 0x3135, 0x6331 },
	{ 0x3136, 0x635D },
	{ 0x3137, 0x6337 },
	{ 0x3138, 0x6335 },
	{ 0x3139, 0x6353 },
	{ 0x313A, 0x39F5 },
	{ 0x313B, 0x635C },
	{ 0x313C, 0x633F },
	{ 0x313D, 0x654B },
	{ 0x313E, 0x3A87 },
	{ 0x313F, 0x4369 },
	{ 0x3140, 0x658B },
	{ 0x3141, 0x3AB6 },
	{ 0x3142, 0x659A },
	{ 0x3143, 0x6650 },
	{ 0x3144, 0x6646 },
	{ 0x3145, 0x664E },
	{ 0x3146, 0x6640 },
	{ 0x3147, 0x3AE9 },
	{ 0x3148, 0x664B },
	{ 0x3149, 0x6648 },
	{ 0x314A, 0x3AEB },
	{ 0x314B, 0x6660 },
	{ 0x314C, 0x6644 },
	{ 0x314D, 0x664D },
	{ 0x314E, 0x3B34 },
	{ 0x314F, 0x6837 },
	{ 0x3150, 0x6824 },
	{ 0x3151, 0x3B62 },
	{ 0x3152, 0x3B5C },
	{ 0x3153, 0x681B },
	{ 0x3154, 0x6836 },
	{ 0x3155, 0x3B60 },
	{ 0x3156, 0x682C },
	{ 0x3157, 0x6819 },
	{ 0x3158, 0x6856 },
	{ 0x3159, 0x6847 },
	{ 0x315A, 0x683E },
	{ 0x315B, 0x681E },
	{ 0x315C, 0x2F8E1 },
	{ 0x315D, 0x6815 },
	{ 0x315E, 0x6822 },
	{ 0x315F, 0x6827 },
	{ 0x3160, 0x6859 },
	{ 0x3161, 0x6858 },
	{ 0x3162, 0x6855 },
	{ 0x3163, 0x6830 },
	{ 0x3164, 0x6823 },
	{ 0x3165, 0x6B2E },
	{ 0x3166, 0x6B2B },
	{ 0x3167, 0x6B30 },
	{ 0x3168, 0x6B6C },
	{ 0x3169, 0x3C61 },
	{ 0x316A, 0x6B8B },
	{ 0x316B, 0x3C7F },
	{ 0x316C, 0x6BE9 },
	{ 0x316D, 0x6BEA },
	{ 0x316E, 0x6BE5 },
	{ 0x316F, 0x6D6B },
	{ 0x3170, 0x3CE5 },
	{ 0x3171, 0x3CE6 },
	{ 0x3172, 0x6D73 },
	{ 0x3173, 0x6D57 },
	{ 0x3174, 0x3CE9 },
	{ 0x3175, 0x3CF3 },
	{ 0x3176, 0x6D5D },
	{ 0x3177, 0x6D56 },
	{ 0x3178, 0x6D8F },
	{ 0x3179, 0x6D5B },
	{ 0x317A, 0x6D1C },
	{ 0x317B, 0x6D9A },
	{ 0x317C, 0x6D9B },
	{ 0x317D, 0x6D99 },
	{ 0x317E, 0x3CEE },
	{ 0x3221, 0x6D81 },
	{ 0x3222, 0x6D71 },
	{ 0x3223, 0x3CED },
	{ 0x3224, 0x3CEC },
	{ 0x3225, 0x6D72 },
	{ 0x3226, 0x6D5C },
	{ 0x3227, 0x6D96 },
	{ 0x3228, 0x70C4 },
	{ 0x3229, 0x70DB },
	{ 0x322A, 0x70CC },
	{ 0x322B, 0x70D0 },
	{ 0x322C, 0x70E3 },
	{ 0x322D, 0x70DF },
	{ 0x322E, 0x3DB3 },
	{ 0x322F, 0x70D6 },
	{ 0x3230, 0x70EE },
	{ 0x3231, 0x70D5 },
	{ 0x3232, 0x3DB5 },
	{ 0x3233, 0x3E27 },
	{ 0x3234, 0x3E35 },
	{ 0x3235, 0x3E36 },
	{ 0x3236, 0x727A },
	{ 0x3237, 0x3E71 },
	{ 0x3238, 0x72F5 },
	{ 0x3239, 0x7302 },
	{ 0x323A, 0x3EB8 },
	{ 0x323B, 0x3EC2 },
	{ 0x323C, 0x73E2 },
	{ 0x323D, 0x73EC },
	{ 0x323E, 0x73D5 },
	{ 0x323F, 0x73F9 },
	{ 0x3240, 0x73DF },
	{ 0x3241, 0x73E6 },
	{ 0x3242, 0x3EC8 },
	{ 0x3243, 0x3EC0 },
	{ 0x3244, 0x3EC1 },
	{ 0x3245, 0x3EC4 },
	{ 0x3246, 0x73E4 },
	{ 0x3247, 0x73E1 },
	{ 0x3248, 0x74F3 },
	{ 0x3249, 0x3F1F },
	{ 0x324A, 0x3F1C },
	{ 0x324B, 0x3F1D },
	{ 0x324C, 0x3F4D },
	{ 0x324D, 0x7556 },
	{ 0x324E, 0x7555 },
	{ 0x324F, 0x7558 },
	{ 0x3250, 0x7557 },
	{ 0x3251, 0x755E },
	{ 0x3252, 0x75C3 },
	{ 0x3253, 0x3F87 },
	{ 0x3254, 0x3F82 },
	{ 0x3255, 0x75B4 },
	{ 0x3256, 0x3F7D },
	{ 0x3257, 0x75B1 },
	{ 0x3258, 0x3FDF },
	{ 0x3259, 0x4000 },
	{ 0x325A, 0x76CB },
	{ 0x325B, 0x76CC },
	{ 0x325C, 0x772A },
	{ 0x325D, 0x4020 },
	{ 0x325E, 0x7716 },
	{ 0x325F, 0x770F },
	{ 0x3260, 0x4022 },
	{ 0x3261, 0x4024 },
	{ 0x3262, 0x773F },
	{ 0x3263, 0x772B },
	{ 0x3264, 0x770E },
	{ 0x3265, 0x7724 },
	{ 0x3266, 0x4021 },
	{ 0x3267, 0x7721 },
	{ 0x3268, 0x7718 },
	{ 0x3269, 0x77DD },
	{ 0x326A, 0x40A4 },
	{ 0x326B, 0x40A5 },
	{ 0x326C, 0x7824 },
	{ 0x326D, 0x7836 },
	{ 0x326E, 0x4101 },
	{ 0x326F, 0x7958 },
	{ 0x3270, 0x7959 },
	{ 0x3271, 0x4103 },
	{ 0x3272, 0x7962 },
	{ 0x3273, 0x79DA },
	{ 0x3274, 0x79D9 },
	{ 0x3275, 0x4137 },
	{ 0x3276, 0x79E1 },
	{ 0x3277, 0x79E5 },
	{ 0x3278, 0x79E8 },
	{ 0x3279, 0x79DB },
	{ 0x327A, 0x4138 },
	{ 0x327B, 0x79E2 },
	{ 0x327C, 0x79F0 },
	{ 0x327D, 0x4199 },
	{ 0x327E, 0x4198 },
	{ 0x3321, 0x4197 },
	{ 0x3322, 0x41C9 },
	{ 0x3323, 0x7ADA },
	{ 0x3324, 0x7ADD },
	{ 0x3325, 0x41C7 },
	{ 0x3326, 0x7ADB },
	{ 0x3327, 0x7ADC },
	{ 0x3328, 0x41D9 },
	{ 0x3329, 0x41DB },
	{ 0x332A, 0x7B0D },
	{ 0x332B, 0x7B0B },
	{ 0x332C, 0x7B14 },
	{ 0x332D, 0x7C8E },
	{ 0x332E, 0x7C86 },
	{ 0x332F, 0x427B },
	{ 0x3330, 0x7C87 },
	{ 0x3331, 0x7C83 },
	{ 0x3332, 0x7C8B },
	{ 0x3333, 0x427C },
	{ 0x3334, 0x42BD },
	{ 0x3335, 0x42BC },
	{ 0x3336, 0x42C3 },
	{ 0x3337, 0x7D24 },
	{ 0x3338, 0x42C1 },
	{ 0x3339, 0x42BF },
	{ 0x333A, 0x42C4 },
	{ 0x333B, 0x7D25 },
	{ 0x333C, 0x7F62 },
	{ 0x333D, 0x7F93 },
	{ 0x333E, 0x7F99 },
	{ 0x333F, 0x7F97 },
	{ 0x3340, 0x437E },
	{ 0x3341, 0x437F },
	{ 0x3342, 0x7FC4 },
	{ 0x3343, 0x7FC6 },
	{ 0x3344, 0x800A },
	{ 0x3345, 0x43B4 },
	{ 0x3346, 0x43B3 },
	{ 0x3347, 0x8040 },
	{ 0x3348, 0x803C },
	{ 0x3349, 0x803B },
	{ 0x334A, 0x80F6 },
	{ 0x334B, 0x80FF },
	{ 0x334C, 0x80EE },
	{ 0x334D, 0x8104 },
	{ 0x334E, 0x8103 },
	{ 0x334F, 0x8107 },
	{ 0x3350, 0x2F983 },
	{ 0x3351, 0x43E6 },
	{ 0x3352, 0x80F7 },
	{ 0x3353, 0x4459 },
	{ 0x3354, 0x445A },
	{ 0x3355, 0x822D },
	{ 0x3356, 0x4464 },
	{ 0x3357, 0x8227 },
	{ 0x3358, 0x8229 },
	{ 0x3359, 0x831F },
	{ 0x335A, 0x8357 },
	{ 0x335B, 0x44B4 },
	{ 0x335C, 0x44B9 },
	{ 0x335D, 0x44B7 },
	{ 0x335E, 0x44B5 },
	{ 0x335F, 0x8321 },
	{ 0x3360, 0x44C1 },
	{ 0x3361, 0x44B1 },
	{ 0x3362, 0x8318 },
	{ 0x3363, 0x8358 },
	{ 0x3364, 0x44B3 },
	{ 0x3365, 0x44BA },
	{ 0x3366, 0x458C },
	{ 0x3367, 0x458B },
	{ 0x3368, 0x458D },
	{ 0x3369, 0x8684 },
	{ 0x336A, 0x869F },
	{ 0x336B, 0x869B },
	{ 0x336C, 0x8689 },
	{ 0x336D, 0x86A6 },
	{ 0x336E, 0x8692 },
	{ 0x336F, 0x868F },
	{ 0x3370, 0x86A0 },
	{ 0x3371, 0x884F },
	{ 0x3372, 0x8878 },
	{ 0x3373, 0x887A },
	{ 0x3374, 0x886E },
	{ 0x3375, 0x887B },
	{ 0x3376, 0x8884 },
	{ 0x3377, 0x8873 },
	{ 0x3378, 0x4678 },
	{ 0x3379, 0x4677 },
	{ 0x337A, 0x8A0D },
	{ 0x337B, 0x8A0B },
	{ 0x337C, 0x8A19 },
	{ 0x337D, 0x46B2 },
	{ 0x337E, 0x47D6 },
	{ 0x3421, 0x8ED0 },
	{ 0x3422, 0x4845 },
	{ 0x3423, 0x4892 },
	{ 0x3424, 0x4895 },
	{ 0x3425, 0x8FF9 },
	{ 0x3426, 0x9009 },
	{ 0x3427, 0x9008 },
	{ 0x3428, 0x48C6 },
	{ 0x3429, 0x90DE },
	{ 0x342A, 0x9151 },
	{ 0x342B, 0x48E7 },
	{ 0x342C, 0x48E8 },
	{ 0x342D, 0x91DB },
	{ 0x342E, 0x91DF },
	{ 0x342F, 0x91DE },
	{ 0x3430, 0x91D6 },
	{ 0x3431, 0x91E0 },
	{ 0x3432, 0x9585 },
	{ 0x3433, 0x9660 },
	{ 0x3434, 0x9659 },
	{ 0x3435, 0x49CB },
	{ 0x3436, 0x9656 },
	{ 0x3437, 0x49CD },
	{ 0x3438, 0x49F1 },
	{ 0x3439, 0x96BD },
	{ 0x343A, 0x4B22 },
	{ 0x343B, 0x3421 },
	{ 0x343C, 0x5042 },
	{ 0x343D, 0x5059 },
	{ 0x343E, 0x346F },
	{ 0x343F, 0x5044 },
	{ 0x3440, 0x5066 },
	{ 0x3441, 0x5052 },
	{ 0x3442, 0x5054 },
	{ 0x3443, 0x5071 },
	{ 0x3444, 0x5050 },
	{ 0x3445, 0x507B },
	{ 0x3446, 0x507C },
	{ 0x3447, 0x5058 },
	{ 0x3448, 0x3470 },
	{ 0x3449, 0x3464 },
	{ 0x344A, 0x5079 },
	{ 0x344B, 0x506C },
	{ 0x344C, 0x5078 },
	{ 0x344D, 0x51A8 },
	{ 0x344E, 0x51D1 },
	{ 0x344F, 0x51CF },
	{ 0x3450, 0x5268 },
	{ 0x3451, 0x5276 },
	{ 0x3452, 0x52D4 },
	{ 0x3453, 0x352D },
	{ 0x3454, 0x53A0 },
	{ 0x3455, 0x53C4 },
	{ 0x3456, 0x3558 },
	{ 0x3457, 0x5558 },
	{ 0x3458, 0x554C },
	{ 0x3459, 0x5568 },
	{ 0x345A, 0x35A6 },
	{ 0x345B, 0x5549 },
	{ 0x345C, 0x35A4 },
	{ 0x345D, 0x359F },
	{ 0x345E, 0x555D },
	{ 0x345F, 0x5529 },
	{ 0x3460, 0x20DAE },
	{ 0x3461, 0x5554 },
	{ 0x3462, 0x5553 },
	{ 0x3463, 0x35A3 },
	{ 0x3464, 0x555A },
	{ 0x3465, 0x35A0 },
	{ 0x3466, 0x553A },
	{ 0x3467, 0x553F },
	{ 0x3468, 0x552B },
	{ 0x3469, 0x57EA },
	{ 0x346A, 0x364A },
	{ 0x346B, 0x57EF },
	{ 0x346C, 0x3647 },
	{ 0x346D, 0x3648 },
	{ 0x346E, 0x57DD },
	{ 0x346F, 0x57FE },
	{ 0x3470, 0x2F855 },
	{ 0x3471, 0x57DE },
	{ 0x3472, 0x57E6 },
	{ 0x3473, 0x3649 },
	{ 0x3474, 0x57E8 },
	{ 0x3475, 0x57FF },
	{ 0x3476, 0x5803 },
	{ 0x3477, 0x58F7 },
	{ 0x3478, 0x68A6 },
	{ 0x3479, 0x591F },
	{ 0x347A, 0x369E },
	{ 0x347B, 0x595B },
	{ 0x347C, 0x595D },
	{ 0x347D, 0x595E },
	{ 0x347E, 0x21637 },
	{ 0x3521, 0x36E8 },
	{ 0x3522, 0x5A2B },
	{ 0x3523, 0x36EC },
	{ 0x3524, 0x5A3B },
	{ 0x3525, 0x36ED },
	{ 0x3526, 0x36E6 },
	{ 0x3527, 0x5A61 },
	{ 0x3528, 0x5A3A },
	{ 0x3529, 0x5A6E },
	{ 0x352A, 0x5A4B },
	{ 0x352B, 0x5A6B },
	{ 0x352C, 0x36EB },
	{ 0x352D, 0x36E7 },
	{ 0x352E, 0x5A45 },
	{ 0x352F, 0x5A4E },
	{ 0x3530, 0x5A68 },
	{ 0x3531, 0x5A3D },
	{ 0x3532, 0x5A71 },
	{ 0x3533, 0x5A3F },
	{ 0x3534, 0x5A6F },
	{ 0x3535, 0x5A75 },
	{ 0x3536, 0x36E9 },
	{ 0x3537, 0x5A73 },
	{ 0x3538, 0x5A2C },
	{ 0x3539, 0x5A59 },
	{ 0x353A, 0x5A54 },
	{ 0x353B, 0x5A4F },
	{ 0x353C, 0x5A63 },
	{ 0x353D, 0x375C },
	{ 0x353E, 0x375D },
	{ 0x353F, 0x5BC8 },
	{ 0x3540, 0x3760 },
	{ 0x3541, 0x5BC3 },
	{ 0x3542, 0x375B },
	{ 0x3543, 0x5C5B },
	{ 0x3544, 0x5C61 },
	{ 0x3545, 0x3799 },
	{ 0x3546, 0x5D21 },
	{ 0x3547, 0x5D0A },
	{ 0x3548, 0x5D09 },
	{ 0x3549, 0x37D8 },
	{ 0x354A, 0x5D2C },
	{ 0x354B, 0x5D08 },
	{ 0x354C, 0x37DA },
	{ 0x354D, 0x37DD },
	{ 0x354E, 0x5D2A },
	{ 0x354F, 0x5D15 },
	{ 0x3550, 0x37E0 },
	{ 0x3551, 0x5D10 },
	{ 0x3552, 0x5D13 },
	{ 0x3553, 0x37E5 },
	{ 0x3554, 0x5D2F },
	{ 0x3555, 0x5D18 },
	{ 0x3556, 0x37D7 },
	{ 0x3557, 0x5DE3 },
	{ 0x3558, 0x5E39 },
	{ 0x3559, 0x5E35 },
	{ 0x355A, 0x5E3A },
	{ 0x355B, 0x5E32 },
	{ 0x355C, 0x384E },
	{ 0x355D, 0x388C },
	{ 0x355E, 0x3888 },
	{ 0x355F, 0x2F88D },
	{ 0x3560, 0x5EBB },
	{ 0x3561, 0x5EBA },
	{ 0x3562, 0x5F34 },
	{ 0x3563, 0x5F39 },
	{ 0x3564, 0x38CE },
	{ 0x3565, 0x2F89C },
	{ 0x3566, 0x38E5 },
	{ 0x3567, 0x38E6 },
	{ 0x3568, 0x6098 },
	{ 0x3569, 0x3932 },
	{ 0x356A, 0x60D0 },
	{ 0x356B, 0x3940 },
	{ 0x356C, 0x3947 },
	{ 0x356D, 0x394C },
	{ 0x356E, 0x60D7 },
	{ 0x356F, 0x60AA },
	{ 0x3570, 0x3935 },
	{ 0x3571, 0x60A1 },
	{ 0x3572, 0x60A4 },
	{ 0x3573, 0x3930 },
	{ 0x3574, 0x60EE },
	{ 0x3575, 0x3943 },
	{ 0x3576, 0x60E7 },
	{ 0x3577, 0x394D },
	{ 0x3578, 0x60E8 },
	{ 0x3579, 0x60DE },
	{ 0x357A, 0x39B7 },
	{ 0x357B, 0x39F3 },
	{ 0x357C, 0x637E },
	{ 0x357D, 0x638B },
	{ 0x357E, 0x3A02 },
	{ 0x3621, 0x3A0B },
	{ 0x3622, 0x6379 },
	{ 0x3623, 0x6386 },
	{ 0x3624, 0x6393 },
	{ 0x3625, 0x3A04 },
	{ 0x3626, 0x6373 },
	{ 0x3627, 0x636A },
	{ 0x3628, 0x2F8BA },
	{ 0x3629, 0x636C },
	{ 0x362A, 0x3A08 },
	{ 0x362B, 0x637F },
	{ 0x362C, 0x39FC },
	{ 0x362D, 0x63B2 },
	{ 0x362E, 0x63BA },
	{ 0x362F, 0x39FF },
	{ 0x3630, 0x3A00 },
	{ 0x3631, 0x6366 },
	{ 0x3632, 0x6374 },
	{ 0x3633, 0x3A8B },
	{ 0x3634, 0x655A },
	{ 0x3635, 0x3A8D },
	{ 0x3636, 0x654E },
	{ 0x3637, 0x654D },
	{ 0x3638, 0x658D },
	{ 0x3639, 0x658E },
	{ 0x363A, 0x65AD },
	{ 0x363B, 0x3ACA },
	{ 0x363C, 0x65C7 },
	{ 0x363D, 0x65CA },
	{ 0x363E, 0x3ACB },
	{ 0x363F, 0x65C9 },
	{ 0x3640, 0x2F8CB },
	{ 0x3641, 0x65E3 },
	{ 0x3642, 0x6657 },
	{ 0x3643, 0x3AF3 },
	{ 0x3644, 0x6663 },
	{ 0x3645, 0x6667 },
	{ 0x3646, 0x671A },
	{ 0x3647, 0x6719 },
	{ 0x3648, 0x6716 },
	{ 0x3649, 0x3B36 },
	{ 0x364A, 0x3B6A },
	{ 0x364B, 0x689E },
	{ 0x364C, 0x68B6 },
	{ 0x364D, 0x6898 },
	{ 0x364E, 0x6873 },
	{ 0x364F, 0x3B6B },
	{ 0x3650, 0x689A },
	{ 0x3651, 0x688E },
	{ 0x3652, 0x68B7 },
	{ 0x3653, 0x68DB },
	{ 0x3654, 0x68A5 },
	{ 0x3655, 0x686C },
	{ 0x3656, 0x68C1 },
	{ 0x3657, 0x6884 },
	{ 0x3658, 0x3B71 },
	{ 0x3659, 0x3B68 },
	{ 0x365A, 0x6895 },
	{ 0x365B, 0x687A },
	{ 0x365C, 0x6899 },
	{ 0x365D, 0x3B72 },
	{ 0x365E, 0x68B8 },
	{ 0x365F, 0x68B9 },
	{ 0x3660, 0x6870 },
	{ 0x3661, 0x3C2E },
	{ 0x3662, 0x6B35 },
	{ 0x3663, 0x3C62 },
	{ 0x3664, 0x6B90 },
	{ 0x3665, 0x6BBB },
	{ 0x3666, 0x6BED },
	{ 0x3667, 0x3C98 },
	{ 0x3668, 0x3CB5 },
	{ 0x3669, 0x3CEB },
	{ 0x366A, 0x6DC1 },
	{ 0x366B, 0x6DC3 },
	{ 0x366C, 0x6DCE },
	{ 0x366D, 0x3CFB },
	{ 0x366E, 0x3CF8 },
	{ 0x366F, 0x6DAD },
	{ 0x3670, 0x6E04 },
	{ 0x3671, 0x3CF5 },
	{ 0x3672, 0x6DB9 },
	{ 0x3673, 0x3D08 },
	{ 0x3674, 0x6DE7 },
	{ 0x3675, 0x2F907 },
	{ 0x3676, 0x6E08 },
	{ 0x3677, 0x6E06 },
	{ 0x3678, 0x3D0A },
	{ 0x3679, 0x6E0A },
	{ 0x367A, 0x6DB0 },
	{ 0x367B, 0x3D06 },
	{ 0x367C, 0x6DF8 },
	{ 0x367D, 0x6E0C },
	{ 0x367E, 0x3CFD },
	{ 0x3721, 0x6DB1 },
	{ 0x3722, 0x3CFA },
	{ 0x3723, 0x6E02 },
	{ 0x3724, 0x6E07 },
	{ 0x3725, 0x6E09 },
	{ 0x3726, 0x6E01 },
	{ 0x3727, 0x6E17 },
	{ 0x3728, 0x6DFF },
	{ 0x3729, 0x6E12 },
	{ 0x372A, 0x3DBA },
	{ 0x372B, 0x3DB9 },
	{ 0x372C, 0x7103 },
	{ 0x372D, 0x7107 },
	{ 0x372E, 0x7101 },
	{ 0x372F, 0x70F5 },
	{ 0x3730, 0x70F1 },
	{ 0x3731, 0x7108 },
	{ 0x3732, 0x70F2 },
	{ 0x3733, 0x710F },
	{ 0x3734, 0x3DBB },
	{ 0x3735, 0x70FE },
	{ 0x3736, 0x3E18 },
	{ 0x3737, 0x3E40 },
	{ 0x3738, 0x3E3D },
	{ 0x3739, 0x731A },
	{ 0x373A, 0x7310 },
	{ 0x373B, 0x730E },
	{ 0x373C, 0x7402 },
	{ 0x373D, 0x73F3 },
	{ 0x373E, 0x3ECD },
	{ 0x373F, 0x3EC9 },
	{ 0x3740, 0x73FB },
	{ 0x3741, 0x3ECB },
	{ 0x3742, 0x3ECA },
	{ 0x3743, 0x3ECE },
	{ 0x3744, 0x751B },
	{ 0x3745, 0x7523 },
	{ 0x3746, 0x7561 },
	{ 0x3747, 0x7568 },
	{ 0x3748, 0x3F5E },
	{ 0x3749, 0x7567 },
	{ 0x374A, 0x75D3 },
	{ 0x374B, 0x3F91 },
	{ 0x374C, 0x3F8C },
	{ 0x374D, 0x7690 },
	{ 0x374E, 0x3FE1 },
	{ 0x374F, 0x4002 },
	{ 0x3750, 0x76D5 },
	{ 0x3751, 0x76D7 },
	{ 0x3752, 0x76D6 },
	{ 0x3753, 0x7730 },
	{ 0x3754, 0x402B },
	{ 0x3755, 0x7726 },
	{ 0x3756, 0x402A },
	{ 0x3757, 0x7740 },
	{ 0x3758, 0x3E14 },
	{ 0x3759, 0x771E },
	{ 0x375A, 0x40AD },
	{ 0x375B, 0x40A3 },
	{ 0x375C, 0x40AB },
	{ 0x375D, 0x7847 },
	{ 0x375E, 0x40AF },
	{ 0x375F, 0x784B },
	{ 0x3760, 0x7851 },
	{ 0x3761, 0x784F },
	{ 0x3762, 0x7842 },
	{ 0x3763, 0x7846 },
	{ 0x3764, 0x4104 },
	{ 0x3765, 0x796E },
	{ 0x3766, 0x796C },
	{ 0x3767, 0x79F2 },
	{ 0x3768, 0x4144 },
	{ 0x3769, 0x79F1 },
	{ 0x376A, 0x79F5 },
	{ 0x376B, 0x79F3 },
	{ 0x376C, 0x79F9 },
	{ 0x376D, 0x413D },
	{ 0x376E, 0x4147 },
	{ 0x376F, 0x419C },
	{ 0x3770, 0x7A9A },
	{ 0x3771, 0x7A93 },
	{ 0x3772, 0x7A91 },
	{ 0x3773, 0x7AE1 },
	{ 0x3774, 0x41E0 },
	{ 0x3775, 0x41E4 },
	{ 0x3776, 0x7B21 },
	{ 0x3777, 0x7B1C },
	{ 0x3778, 0x7B16 },
	{ 0x3779, 0x7B17 },
	{ 0x377A, 0x7B36 },
	{ 0x377B, 0x7B1F },
	{ 0x377C, 0x4280 },
	{ 0x377D, 0x7C93 },
	{ 0x377E, 0x7C99 },
	{ 0x3821, 0x7C9A },
	{ 0x3822, 0x7C9C },
	{ 0x3823, 0x42CA },
	{ 0x3824, 0x7D49 },
	{ 0x3825, 0x42D4 },
	{ 0x3826, 0x7D34 },
	{ 0x3827, 0x7D37 },
	{ 0x3828, 0x42D2 },
	{ 0x3829, 0x7D2D },
	{ 0x382A, 0x42CB },
	{ 0x382B, 0x7D4C },
	{ 0x382C, 0x42CE },
	{ 0x382D, 0x42D3 },
	{ 0x382E, 0x7D48 },
	{ 0x382F, 0x4344 },
	{ 0x3830, 0x4348 },
	{ 0x3831, 0x7F3B },
	{ 0x3832, 0x4345 },
	{ 0x3833, 0x4381 },
	{ 0x3834, 0x4386 },
	{ 0x3835, 0x4385 },
	{ 0x3836, 0x8008 },
	{ 0x3837, 0x801A },
	{ 0x3838, 0x43A3 },
	{ 0x3839, 0x801D },
	{ 0x383A, 0x43B5 },
	{ 0x383B, 0x8049 },
	{ 0x383C, 0x8045 },
	{ 0x383D, 0x8044 },
	{ 0x383E, 0x7C9B },
	{ 0x383F, 0x43FA },
	{ 0x3840, 0x43F9 },
	{ 0x3841, 0x812A },
	{ 0x3842, 0x812E },
	{ 0x3843, 0x43FB },
	{ 0x3844, 0x43F2 },
	{ 0x3845, 0x8131 },
	{ 0x3846, 0x43EF },
	{ 0x3847, 0x811A },
	{ 0x3848, 0x8134 },
	{ 0x3849, 0x8117 },
	{ 0x384A, 0x445B },
	{ 0x384B, 0x4466 },
	{ 0x384C, 0x44CE },
	{ 0x384D, 0x831D },
	{ 0x384E, 0x8371 },
	{ 0x384F, 0x8384 },
	{ 0x3850, 0x8380 },
	{ 0x3851, 0x8372 },
	{ 0x3852, 0x83A1 },
	{ 0x3853, 0x35B4 },
	{ 0x3854, 0x8379 },
	{ 0x3855, 0x8391 },
	{ 0x3856, 0x44C8 },
	{ 0x3857, 0x839F },
	{ 0x3858, 0x83AD },
	{ 0x3859, 0x44D1 },
	{ 0x385A, 0x44C5 },
	{ 0x385B, 0x8323 },
	{ 0x385C, 0x44D2 },
	{ 0x385D, 0x8385 },
	{ 0x385E, 0x839C },
	{ 0x385F, 0x83B7 },
	{ 0x3860, 0x8658 },
	{ 0x3861, 0x865A },
	{ 0x3862, 0x458F },
	{ 0x3863, 0x8657 },
	{ 0x3864, 0x86B2 },
	{ 0x3865, 0x45A7 },
	{ 0x3866, 0x86AE },
	{ 0x3867, 0x45A5 },
	{ 0x3868, 0x45A4 },
	{ 0x3869, 0x4611 },
	{ 0x386A, 0x8845 },
	{ 0x386B, 0x889C },
	{ 0x386C, 0x8894 },
	{ 0x386D, 0x88A3 },
	{ 0x386E, 0x888F },
	{ 0x386F, 0x88A5 },
	{ 0x3870, 0x88A9 },
	{ 0x3871, 0x88A6 },
	{ 0x3872, 0x888A },
	{ 0x3873, 0x88A0 },
	{ 0x3874, 0x8890 },
	{ 0x3875, 0x8992 },
	{ 0x3876, 0x8991 },
	{ 0x3877, 0x8994 },
	{ 0x3878, 0x46B5 },
	{ 0x3879, 0x8A26 },
	{ 0x387A, 0x8A32 },
	{ 0x387B, 0x8A28 },
	{ 0x387C, 0x46B4 },
	{ 0x387D, 0x46BD },
	{ 0x387E, 0x8A1C },
	{ 0x3921, 0x46BB },
	{ 0x3922, 0x8A2B },
	{ 0x3923, 0x8A20 },
	{ 0x3924, 0x46B9 },
	{ 0x3925, 0x8A29 },
	{ 0x3926, 0x46C2 },
	{ 0x3927, 0x46BE },
	{ 0x3928, 0x46BA },
	{ 0x3929, 0x8A21 },
	{ 0x392A, 0x8C3A },
	{ 0x392B, 0x3AB7 },
	{ 0x392C, 0x8C5B },
	{ 0x392D, 0x8C58 },
	{ 0x392E, 0x8C7C },
	{ 0x392F, 0x4758 },
	{ 0x3930, 0x8CA6 },
	{ 0x3931, 0x8CAE },
	{ 0x3932, 0x8CAD },
	{ 0x3933, 0x8D65 },
	{ 0x3934, 0x479B },
	{ 0x3935, 0x8D7E },
	{ 0x3936, 0x479C },
	{ 0x3937, 0x8D7C },
	{ 0x3938, 0x8D7F },
	{ 0x3939, 0x8D7A },
	{ 0x393A, 0x8DBD },
	{ 0x393B, 0x47DA },
	{ 0x393C, 0x47DE },
	{ 0x393D, 0x8DC0 },
	{ 0x393E, 0x8DBB },
	{ 0x393F, 0x8EAD },
	{ 0x3940, 0x8EAF },
	{ 0x3941, 0x8ED6 },
	{ 0x3942, 0x484D },
	{ 0x3943, 0x4846 },
	{ 0x3944, 0x4847 },
	{ 0x3945, 0x484B },
	{ 0x3946, 0x484C },
	{ 0x3947, 0x8ED9 },
	{ 0x3948, 0x4848 },
	{ 0x3949, 0x4899 },
	{ 0x394A, 0x9012 },
	{ 0x394B, 0x900E },
	{ 0x394C, 0x9025 },
	{ 0x394D, 0x489B },
	{ 0x394E, 0x9013 },
	{ 0x394F, 0x90EE },
	{ 0x3950, 0x48CE },
	{ 0x3951, 0x90AB },
	{ 0x3952, 0x90F7 },
	{ 0x3953, 0x48EB },
	{ 0x3954, 0x9159 },
	{ 0x3955, 0x9154 },
	{ 0x3956, 0x91F2 },
	{ 0x3957, 0x91F0 },
	{ 0x3958, 0x91E5 },
	{ 0x3959, 0x91F6 },
	{ 0x395A, 0x491C },
	{ 0x395B, 0x498C },
	{ 0x395C, 0x9587 },
	{ 0x395D, 0x49D1 },
	{ 0x395E, 0x965A },
	{ 0x395F, 0x49D6 },
	{ 0x3960, 0x49D3 },
	{ 0x3961, 0x966E },
	{ 0x3962, 0x49D4 },
	{ 0x3963, 0x49D0 },
	{ 0x3964, 0x49D5 },
	{ 0x3965, 0x9679 },
	{ 0x3966, 0x4A0B },
	{ 0x3967, 0x98E1 },
	{ 0x3968, 0x98E6 },
	{ 0x3969, 0x4BC6 },
	{ 0x396A, 0x9EC4 },
	{ 0x396B, 0x9ED2 },
	{ 0x396C, 0x4E80 },
	{ 0x396D, 0x3424 },
	{ 0x396E, 0x4E81 },
	{ 0x396F, 0x508F },
	{ 0x3970, 0x5097 },
	{ 0x3971, 0x5088 },
	{ 0x3972, 0x5089 },
	{ 0x3973, 0x3474 },
	{ 0x3974, 0x347A },
	{ 0x3975, 0x5081 },
	{ 0x3976, 0x5160 },
	{ 0x3977, 0x20564 },
	{ 0x3978, 0x34C3 },
	{ 0x3979, 0x5E42 },
	{ 0x397A, 0x51D3 },
	{ 0x397B, 0x34D4 },
	{ 0x397C, 0x34D5 },
	{ 0x397D, 0x51D2 },
	{ 0x397E, 0x51D6 },
	{ 0x3A21, 0x5273 },
	{ 0x3A22, 0x34FB },
	{ 0x3A23, 0x5270 },
	{ 0x3A24, 0x34F7 },
	{ 0x3A25, 0x3532 },
	{ 0x3A26, 0x2F833 },
	{ 0x3A27, 0x53A8 },
	{ 0x3A28, 0x53A6 },
	{ 0x3A29, 0x53C5 },
	{ 0x3A2A, 0x5597 },
	{ 0x3A2B, 0x55DE },
	{ 0x3A2C, 0x35BA },
	{ 0x3A2D, 0x35BF },
	{ 0x3A2E, 0x5596 },
	{ 0x3A2F, 0x55B4 },
	{ 0x3A30, 0x35C7 },
	{ 0x3A31, 0x5585 },
	{ 0x3A32, 0x35B7 },
	{ 0x3A33, 0x559B },
	{ 0x3A34, 0x55A0 },
	{ 0x3A35, 0x35B9 },
	{ 0x3A36, 0x5559 },
	{ 0x3A37, 0x35C3 },
	{ 0x3A38, 0x5586 },
	{ 0x3A39, 0x35BD },
	{ 0x3A3A, 0x35D0 },
	{ 0x3A3B, 0x55AF },
	{ 0x3A3C, 0x557A },
	{ 0x3A3D, 0x35C1 },
	{ 0x3A3E, 0x35BE },
	{ 0x3A3F, 0x35CD },
	{ 0x3A40, 0x559E },
	{ 0x3A41, 0x35CB },
	{ 0x3A42, 0x55A9 },
	{ 0x3A43, 0x570F },
	{ 0x3A44, 0x570E },
	{ 0x3A45, 0x581A },
	{ 0x3A46, 0x364F },
	{ 0x3A47, 0x581F },
	{ 0x3A48, 0x3653 },
	{ 0x3A49, 0x583C },
	{ 0x3A4A, 0x5818 },
	{ 0x3A4B, 0x583E },
	{ 0x3A4C, 0x5826 },
	{ 0x3A4D, 0x3655 },
	{ 0x3A4E, 0x583A },
	{ 0x3A4F, 0x21364 },
	{ 0x3A50, 0x5822 },
	{ 0x3A51, 0x3651 },
	{ 0x3A52, 0x58FB },
	{ 0x3A53, 0x5963 },
	{ 0x3A54, 0x5964 },
	{ 0x3A55, 0x369F },
	{ 0x3A56, 0x5AA8 },
	{ 0x3A57, 0x5AA3 },
	{ 0x3A58, 0x5A82 },
	{ 0x3A59, 0x5A88 },
	{ 0x3A5A, 0x5AA1 },
	{ 0x3A5B, 0x5A85 },
	{ 0x3A5C, 0x5A98 },
	{ 0x3A5D, 0x36FE },
	{ 0x3A5E, 0x5A99 },
	{ 0x3A5F, 0x36FB },
	{ 0x3A60, 0x5A89 },
	{ 0x3A61, 0x5A81 },
	{ 0x3A62, 0x5A96 },
	{ 0x3A63, 0x5A80 },
	{ 0x3A64, 0x36F1 },
	{ 0x3A65, 0x36F5 },
	{ 0x3A66, 0x5A91 },
	{ 0x3A67, 0x36EF },
	{ 0x3A68, 0x3704 },
	{ 0x3A69, 0x3703 },
	{ 0x3A6A, 0x36F4 },
	{ 0x3A6B, 0x5ACF },
	{ 0x3A6C, 0x36F3 },
	{ 0x3A6D, 0x3702 },
	{ 0x3A6E, 0x36F7 },
	{ 0x3A6F, 0x36FA },
	{ 0x3A70, 0x36FD },
	{ 0x3A71, 0x36EE },
	{ 0x3A72, 0x5A87 },
	{ 0x3A73, 0x5AA0 },
	{ 0x3A74, 0x36F0 },
	{ 0x3A75, 0x5A79 },
	{ 0x3A76, 0x36F2 },
	{ 0x3A77, 0x5A86 },
	{ 0x3A78, 0x5AAB },
	{ 0x3A79, 0x5AAA },
	{ 0x3A7A, 0x5AA4 },
	{ 0x3A7B, 0x5A8D },
	{ 0x3A7C, 0x5A7E },
	{ 0x3A7D, 0x3744 },
	{ 0x3A7E, 0x5BD5 },
	{ 0x3B21, 0x3762 },
	{ 0x3B22, 0x3777 },
	{ 0x3B23, 0x3DC9 },
	{ 0x3B24, 0x5C1E },
	{ 0x3B25, 0x5C5F },
	{ 0x3B26, 0x5C5E },
	{ 0x3B27, 0x5D44 },
	{ 0x3B28, 0x5D3E },
	{ 0x3B29, 0x37E8 },
	{ 0x3B2A, 0x5D48 },
	{ 0x3B2B, 0x5D1C },
	{ 0x3B2C, 0x37EF },
	{ 0x3B2D, 0x5D5B },
	{ 0x3B2E, 0x5D4D },
	{ 0x3B2F, 0x37E6 },
	{ 0x3B30, 0x37ED },
	{ 0x3B31, 0x5D57 },
	{ 0x3B32, 0x37E7 },
	{ 0x3B33, 0x5D53 },
	{ 0x3B34, 0x5D4F },
	{ 0x3B35, 0x37EB },
	{ 0x3B36, 0x5D3B },
	{ 0x3B37, 0x5D46 },
	{ 0x3B38, 0x382D },
	{ 0x3B39, 0x3855 },
	{ 0x3B3A, 0x5E46 },
	{ 0x3B3B, 0x5E47 },
	{ 0x3B3C, 0x3853 },
	{ 0x3B3D, 0x5E48 },
	{ 0x3B3E, 0x5EC0 },
	{ 0x3B3F, 0x5EBD },
	{ 0x3B40, 0x5EBF },
	{ 0x3B41, 0x3890 },
	{ 0x3B42, 0x5F11 },
	{ 0x3B43, 0x38BE },
	{ 0x3B44, 0x5F3E },
	{ 0x3B45, 0x5F3B },
	{ 0x3B46, 0x38BD },
	{ 0x3B47, 0x5F3A },
	{ 0x3B48, 0x38CF },
	{ 0x3B49, 0x38D0 },
	{ 0x3B4A, 0x38EC },
	{ 0x3B4B, 0x5FA7 },
	{ 0x3B4C, 0x394B },
	{ 0x3B4D, 0x60EA },
	{ 0x3B4E, 0x3948 },
	{ 0x3B4F, 0x6107 },
	{ 0x3B50, 0x6122 },
	{ 0x3B51, 0x610C },
	{ 0x3B52, 0x3955 },
	{ 0x3B53, 0x3951 },
	{ 0x3B54, 0x60B3 },
	{ 0x3B55, 0x60D6 },
	{ 0x3B56, 0x60D2 },
	{ 0x3B57, 0x394E },
	{ 0x3B58, 0x60E3 },
	{ 0x3B59, 0x60E5 },
	{ 0x3B5A, 0x60E9 },
	{ 0x3B5B, 0x396B },
	{ 0x3B5C, 0x395E },
	{ 0x3B5D, 0x6111 },
	{ 0x3B5E, 0x60FD },
	{ 0x3B5F, 0x3960 },
	{ 0x3B60, 0x3967 },
	{ 0x3B61, 0x611E },
	{ 0x3B62, 0x6120 },
	{ 0x3B63, 0x6121 },
	{ 0x3B64, 0x621E },
	{ 0x3B65, 0x39B8 },
	{ 0x3B66, 0x63E2 },
	{ 0x3B67, 0x63DE },
	{ 0x3B68, 0x63E6 },
	{ 0x3B69, 0x3A14 },
	{ 0x3B6A, 0x3A0F },
	{ 0x3B6B, 0x3A07 },
	{ 0x3B6C, 0x3A13 },
	{ 0x3B6D, 0x63F8 },
	{ 0x3B6E, 0x3A17 },
	{ 0x3B6F, 0x63FE },
	{ 0x3B70, 0x63C1 },
	{ 0x3B71, 0x63BF },
	{ 0x3B72, 0x63F7 },
	{ 0x3B73, 0x63D1 },
	{ 0x3B74, 0x655F },
	{ 0x3B75, 0x6560 },
	{ 0x3B76, 0x6561 },
	{ 0x3B77, 0x3A9A },
	{ 0x3B78, 0x3AB8 },
	{ 0x3B79, 0x65D1 },
	{ 0x3B7A, 0x3AF7 },
	{ 0x3B7B, 0x3AF8 },
	{ 0x3B7C, 0x667D },
	{ 0x3B7D, 0x666B },
	{ 0x3B7E, 0x667F },
	{ 0x3C21, 0x3AFD },
	{ 0x3C22, 0x3AF5 },
	{ 0x3C23, 0x6673 },
	{ 0x3C24, 0x6681 },
	{ 0x3C25, 0x666D },
	{ 0x3C26, 0x6669 },
	{ 0x3C27, 0x3AFA },
	{ 0x3C28, 0x3B38 },
	{ 0x3C29, 0x671E },
	{ 0x3C2A, 0x68ED },
	{ 0x3C2B, 0x3B87 },
	{ 0x3C2C, 0x3B80 },
	{ 0x3C2D, 0x3B88 },
	{ 0x3C2E, 0x3B79 },
	{ 0x3C2F, 0x6903 },
	{ 0x3C30, 0x3B7C },
	{ 0x3C31, 0x68FE },
	{ 0x3C32, 0x68E5 },
	{ 0x3C33, 0x691E },
	{ 0x3C34, 0x6902 },
	{ 0x3C35, 0x3B83 },
	{ 0x3C36, 0x3B85 },
	{ 0x3C37, 0x6909 },
	{ 0x3C38, 0x68CA },
	{ 0x3C39, 0x6900 },
	{ 0x3C3A, 0x2F8E5 },
	{ 0x3C3B, 0x6901 },
	{ 0x3C3C, 0x6918 },
	{ 0x3C3D, 0x68E2 },
	{ 0x3C3E, 0x68CF },
	{ 0x3C3F, 0x3B7B },
	{ 0x3C40, 0x692E },
	{ 0x3C41, 0x68C5 },
	{ 0x3C42, 0x68FF },
	{ 0x3C43, 0x3B86 },
	{ 0x3C44, 0x691C },
	{ 0x3C45, 0x68C3 },
	{ 0x3C46, 0x3C34 },
	{ 0x3C47, 0x6B6F },
	{ 0x3C48, 0x3C55 },
	{ 0x3C49, 0x6B6E },
	{ 0x3C4A, 0x3C68 },
	{ 0x3C4B, 0x6BBE },
	{ 0x3C4C, 0x3C9C },
	{ 0x3C4D, 0x6BF4 },
	{ 0x3C4E, 0x6C2D },
	{ 0x3C4F, 0x3CFC },
	{ 0x3C50, 0x6DB6 },
	{ 0x3C51, 0x6E75 },
	{ 0x3C52, 0x6E1E },
	{ 0x3C53, 0x3D1A },
	{ 0x3C54, 0x6E18 },
	{ 0x3C55, 0x3D17 },
	{ 0x3C56, 0x6E48 },
	{ 0x3C57, 0x3D1B },
	{ 0x3C58, 0x6E4F },
	{ 0x3C59, 0x3D13 },
	{ 0x3C5A, 0x6E42 },
	{ 0x3C5B, 0x6E6A },
	{ 0x3C5C, 0x6E70 },
	{ 0x3C5D, 0x6DFE },
	{ 0x3C5E, 0x3D05 },
	{ 0x3C5F, 0x3D07 },
	{ 0x3C60, 0x6E6D },
	{ 0x3C61, 0x3D1C },
	{ 0x3C62, 0x6E7B },
	{ 0x3C63, 0x6E7E },
	{ 0x3C64, 0x6E59 },
	{ 0x3C65, 0x3D11 },
	{ 0x3C66, 0x6E57 },
	{ 0x3C67, 0x3D16 },
	{ 0x3C68, 0x6E80 },
	{ 0x3C69, 0x6E50 },
	{ 0x3C6A, 0x3D15 },
	{ 0x3C6B, 0x6E29 },
	{ 0x3C6C, 0x6E76 },
	{ 0x3C6D, 0x6E2A },
	{ 0x3C6E, 0x6E4C },
	{ 0x3C6F, 0x712A },
	{ 0x3C70, 0x3DCB },
	{ 0x3C71, 0x7135 },
	{ 0x3C72, 0x712C },
	{ 0x3C73, 0x7137 },
	{ 0x3C74, 0x711D },
	{ 0x3C75, 0x3DC5 },
	{ 0x3C76, 0x3DC2 },
	{ 0x3C77, 0x7138 },
	{ 0x3C78, 0x3DCD },
	{ 0x3C79, 0x7134 },
	{ 0x3C7A, 0x712B },
	{ 0x3C7B, 0x7133 },
	{ 0x3C7C, 0x7127 },
	{ 0x3C7D, 0x7124 },
	{ 0x3C7E, 0x3DCA },
	{ 0x3D21, 0x712D },
	{ 0x3D22, 0x7232 },
	{ 0x3D23, 0x7283 },
	{ 0x3D24, 0x7282 },
	{ 0x3D25, 0x7287 },
	{ 0x3D26, 0x7306 },
	{ 0x3D27, 0x7324 },
	{ 0x3D28, 0x7338 },
	{ 0x3D29, 0x732A },
	{ 0x3D2A, 0x732C },
	{ 0x3D2B, 0x732B },
	{ 0x3D2C, 0x3E83 },
	{ 0x3D2D, 0x732F },
	{ 0x3D2E, 0x7328 },
	{ 0x3D2F, 0x7417 },
	{ 0x3D30, 0x3ED6 },
	{ 0x3D31, 0x3ED5 },
	{ 0x3D32, 0x7419 },
	{ 0x3D33, 0x7438 },
	{ 0x3D34, 0x3ED1 },
	{ 0x3D35, 0x741F },
	{ 0x3D36, 0x7414 },
	{ 0x3D37, 0x743C },
	{ 0x3D38, 0x73F7 },
	{ 0x3D39, 0x741C },
	{ 0x3D3A, 0x7415 },
	{ 0x3D3B, 0x7418 },
	{ 0x3D3C, 0x7439 },
	{ 0x3D3D, 0x74F9 },
	{ 0x3D3E, 0x7524 },
	{ 0x3D3F, 0x2F934 },
	{ 0x3D40, 0x3F52 },
	{ 0x3D41, 0x3F5F },
	{ 0x3D42, 0x756E },
	{ 0x3D43, 0x756D },
	{ 0x3D44, 0x7571 },
	{ 0x3D45, 0x758E },
	{ 0x3D46, 0x3F95 },
	{ 0x3D47, 0x75E5 },
	{ 0x3D48, 0x3F9D },
	{ 0x3D49, 0x3F98 },
	{ 0x3D4A, 0x3F9E },
	{ 0x3D4B, 0x3F96 },
	{ 0x3D4C, 0x7694 },
	{ 0x3D4D, 0x76B3 },
	{ 0x3D4E, 0x4003 },
	{ 0x3D4F, 0x76D9 },
	{ 0x3D50, 0x402F },
	{ 0x3D51, 0x7748 },
	{ 0x3D52, 0x7749 },
	{ 0x3D53, 0x7743 },
	{ 0x3D54, 0x4031 },
	{ 0x3D55, 0x4033 },
	{ 0x3D56, 0x7742 },
	{ 0x3D57, 0x77DF },
	{ 0x3D58, 0x40B4 },
	{ 0x3D59, 0x7863 },
	{ 0x3D5A, 0x7876 },
	{ 0x3D5B, 0x40B0 },
	{ 0x3D5C, 0x785F },
	{ 0x3D5D, 0x7866 },
	{ 0x3D5E, 0x7966 },
	{ 0x3D5F, 0x7971 },
	{ 0x3D60, 0x4108 },
	{ 0x3D61, 0x4107 },
	{ 0x3D62, 0x7976 },
	{ 0x3D63, 0x7984 },
	{ 0x3D64, 0x7975 },
	{ 0x3D65, 0x79FF },
	{ 0x3D66, 0x7A07 },
	{ 0x3D67, 0x414E },
	{ 0x3D68, 0x7A0E },
	{ 0x3D69, 0x7A09 },
	{ 0x3D6A, 0x4150 },
	{ 0x3D6B, 0x4152 },
	{ 0x3D6C, 0x41A1 },
	{ 0x3D6D, 0x41A3 },
	{ 0x3D6E, 0x41A5 },
	{ 0x3D6F, 0x41CC },
	{ 0x3D70, 0x7AE7 },
	{ 0x3D71, 0x7AE2 },
	{ 0x3D72, 0x7B55 },
	{ 0x3D73, 0x41EF },
	{ 0x3D74, 0x41EA },
	{ 0x3D75, 0x7B43 },
	{ 0x3D76, 0x7B57 },
	{ 0x3D77, 0x7B6C },
	{ 0x3D78, 0x7B42 },
	{ 0x3D79, 0x7B53 },
	{ 0x3D7A, 0x41ED },
	{ 0x3D7B, 0x7B41 },
	{ 0x3D7C, 0x4285 },
	{ 0x3D7D, 0x4284 },
	{ 0x3D7E, 0x7CA7 },
	{ 0x3E21, 0x7CA0 },
	{ 0x3E22, 0x7CA6 },
	{ 0x3E23, 0x7CA4 },
	{ 0x3E24, 0x7D74 },
	{ 0x3E25, 0x42DB },
	{ 0x3E26, 0x7D59 },
	{ 0x3E27, 0x42D9 },
	{ 0x3E28, 0x7D60 },
	{ 0x3E29, 0x7D57 },
	{ 0x3E2A, 0x7D6C },
	{ 0x3E2B, 0x7D7E },
	{ 0x3E2C, 0x7D64 },
	{ 0x3E2D, 0x42D7 },
	{ 0x3E2E, 0x7D5A },
	{ 0x3E2F, 0x7D5D },
	{ 0x3E30, 0x42DA },
	{ 0x3E31, 0x42DE },
	{ 0x3E32, 0x42D8 },
	{ 0x3E33, 0x7D76 },
	{ 0x3E34, 0x7D4D },
	{ 0x3E35, 0x7D75 },
	{ 0x3E36, 0x42D5 },
	{ 0x3E37, 0x7FD3 },
	{ 0x3E38, 0x7FD6 },
	{ 0x3E39, 0x439C },
	{ 0x3E3A, 0x439D },
	{ 0x3E3B, 0x8060 },
	{ 0x3E3C, 0x804E },
	{ 0x3E3D, 0x8145 },
	{ 0x3E3E, 0x813B },
	{ 0x3E3F, 0x43FE },
	{ 0x3E40, 0x8148 },
	{ 0x3E41, 0x8142 },
	{ 0x3E42, 0x8149 },
	{ 0x3E43, 0x8140 },
	{ 0x3E44, 0x8114 },
	{ 0x3E45, 0x8141 },
	{ 0x3E46, 0x4407 },
	{ 0x3E47, 0x81EF },
	{ 0x3E48, 0x81F6 },
	{ 0x3E49, 0x8203 },
	{ 0x3E4A, 0x446A },
	{ 0x3E4B, 0x83ED },
	{ 0x3E4C, 0x44E7 },
	{ 0x3E4D, 0x83DA },
	{ 0x3E4E, 0x8418 },
	{ 0x3E4F, 0x83D2 },
	{ 0x3E50, 0x8408 },
	{ 0x3E51, 0x44E2 },
	{ 0x3E52, 0x8400 },
	{ 0x3E53, 0x44DF },
	{ 0x3E54, 0x44E1 },
	{ 0x3E55, 0x44E5 },
	{ 0x3E56, 0x8417 },
	{ 0x3E57, 0x8346 },
	{ 0x3E58, 0x8414 },
	{ 0x3E59, 0x83D3 },
	{ 0x3E5A, 0x8405 },
	{ 0x3E5B, 0x841F },
	{ 0x3E5C, 0x8402 },
	{ 0x3E5D, 0x8416 },
	{ 0x3E5E, 0x83CD },
	{ 0x3E5F, 0x83E6 },
	{ 0x3E60, 0x4591 },
	{ 0x3E61, 0x865D },
	{ 0x3E62, 0x86D5 },
	{ 0x3E63, 0x86E1 },
	{ 0x3E64, 0x45B4 },
	{ 0x3E65, 0x45B0 },
	{ 0x3E66, 0x45B5 },
	{ 0x3E67, 0x45AE },
	{ 0x3E68, 0x86EE },
	{ 0x3E69, 0x8847 },
	{ 0x3E6A, 0x8846 },
	{ 0x3E6B, 0x462D },
	{ 0x3E6C, 0x462C },
	{ 0x3E6D, 0x88BB },
	{ 0x3E6E, 0x462B },
	{ 0x3E6F, 0x88BF },
	{ 0x3E70, 0x88B4 },
	{ 0x3E71, 0x4629 },
	{ 0x3E72, 0x88B5 },
	{ 0x3E73, 0x467F },
	{ 0x3E74, 0x899A },
	{ 0x3E75, 0x8A43 },
	{ 0x3E76, 0x46C9 },
	{ 0x3E77, 0x46CB },
	{ 0x3E78, 0x8A5A },
	{ 0x3E79, 0x46C5 },
	{ 0x3E7A, 0x46C6 },
	{ 0x3E7B, 0x46CA },
	{ 0x3E7C, 0x8A35 },
	{ 0x3E7D, 0x8A38 },
	{ 0x3E7E, 0x8A42 },
	{ 0x3F21, 0x8A49 },
	{ 0x3F22, 0x8A5D },
	{ 0x3F23, 0x8A4B },
	{ 0x3F24, 0x8A3D },
	{ 0x3F25, 0x46D2 },
	{ 0x3F26, 0x46D0 },
	{ 0x3F27, 0x472D },
	{ 0x3F28, 0x4735 },
	{ 0x3F29, 0x8C60 },
	{ 0x3F2A, 0x8C5E },
	{ 0x3F2B, 0x8C7F },
	{ 0x3F2C, 0x8C7E },
	{ 0x3F2D, 0x8C83 },
	{ 0x3F2E, 0x476C },
	{ 0x3F2F, 0x8CB1 },
	{ 0x3F30, 0x8D87 },
	{ 0x3F31, 0x479D },
	{ 0x3F32, 0x47A0 },
	{ 0x3F33, 0x8D88 },
	{ 0x3F34, 0x8D83 },
	{ 0x3F35, 0x47A2 },
	{ 0x3F36, 0x479F },
	{ 0x3F37, 0x8D86 },
	{ 0x3F38, 0x8D8B },
	{ 0x3F39, 0x8D82 },
	{ 0x3F3A, 0x8DCA },
	{ 0x3F3B, 0x8DD2 },
	{ 0x3F3C, 0x47EB },
	{ 0x3F3D, 0x47E2 },
	{ 0x3F3E, 0x8DD4 },
	{ 0x3F3F, 0x8DC9 },
	{ 0x3F40, 0x8EB0 },
	{ 0x3F41, 0x4836 },
	{ 0x3F42, 0x4832 },
	{ 0x3F43, 0x4850 },
	{ 0x3F44, 0x8EF2 },
	{ 0x3F45, 0x8EE4 },
	{ 0x3F46, 0x8EF3 },
	{ 0x3F47, 0x8EEA },
	{ 0x3F48, 0x484F },
	{ 0x3F49, 0x8EFD },
	{ 0x3F4A, 0x4852 },
	{ 0x3F4B, 0x8F9D },
	{ 0x3F4C, 0x902B },
	{ 0x3F4D, 0x902A },
	{ 0x3F4E, 0x489E },
	{ 0x3F4F, 0x9028 },
	{ 0x3F50, 0x9029 },
	{ 0x3F51, 0x902C },
	{ 0x3F52, 0x48A0 },
	{ 0x3F53, 0x489C },
	{ 0x3F54, 0x903A },
	{ 0x3F55, 0x9030 },
	{ 0x3F56, 0x9037 },
	{ 0x3F57, 0x903B },
	{ 0x3F58, 0x48D1 },
	{ 0x3F59, 0x910A },
	{ 0x3F5A, 0x48EF },
	{ 0x3F5B, 0x48F0 },
	{ 0x3F5C, 0x48F1 },
	{ 0x3F5D, 0x91FE },
	{ 0x3F5E, 0x9220 },
	{ 0x3F5F, 0x491D },
	{ 0x3F60, 0x920B },
	{ 0x3F61, 0x491F },
	{ 0x3F62, 0x9218 },
	{ 0x3F63, 0x9222 },
	{ 0x3F64, 0x491E },
	{ 0x3F65, 0x921B },
	{ 0x3F66, 0x9208 },
	{ 0x3F67, 0x4920 },
	{ 0x3F68, 0x920E },
	{ 0x3F69, 0x9213 },
	{ 0x3F6A, 0x498E },
	{ 0x3F6B, 0x4991 },
	{ 0x3F6C, 0x9595 },
	{ 0x3F6D, 0x28CDD },
	{ 0x3F6E, 0x4990 },
	{ 0x3F6F, 0x49D7 },
	{ 0x3F70, 0x968C },
	{ 0x3F71, 0x967B },
	{ 0x3F72, 0x967F },
	{ 0x3F73, 0x9681 },
	{ 0x3F74, 0x49D9 },
	{ 0x3F75, 0x9682 },
	{ 0x3F76, 0x49F4 },
	{ 0x3F77, 0x49F6 },
	{ 0x3F78, 0x3560 },
	{ 0x3F79, 0x49F5 },
	{ 0x3F7A, 0x49F3 },
	{ 0x3F7B, 0x96EE },
	{ 0x3F7C, 0x96ED },
	{ 0x3F7D, 0x4A0C },
	{ 0x3F7E, 0x96EC },
	{ 0x4021, 0x975F },
	{ 0x4022, 0x976F },
	{ 0x4023, 0x4A51 },
	{ 0x4024, 0x976D },
	{ 0x4025, 0x4AA6 },
	{ 0x4026, 0x4AA7 },
	{ 0x4027, 0x4AA8 },
	{ 0x4028, 0x4B27 },
	{ 0x4029, 0x4B24 },
	{ 0x402A, 0x4B25 },
	{ 0x402B, 0x98F0 },
	{ 0x402C, 0x4B2A },
	{ 0x402D, 0x4B74 },
	{ 0x402E, 0x4BC7 },
	{ 0x402F, 0x9AA9 },
	{ 0x4030, 0x4BE7 },
	{ 0x4031, 0x4BED },
	{ 0x4032, 0x9AE0 },
	{ 0x4033, 0x4EB7 },
	{ 0x4034, 0x342E },
	{ 0x4035, 0x347B },
	{ 0x4036, 0x50CC },
	{ 0x4037, 0x50BC },
	{ 0x4038, 0x347C },
	{ 0x4039, 0x50AA },
	{ 0x403A, 0x50B9 },
	{ 0x403B, 0x347D },
	{ 0x403C, 0x50AB },
	{ 0x403D, 0x50C3 },
	{ 0x403E, 0x50CD },
	{ 0x403F, 0x517E },
	{ 0x4040, 0x527E },
	{ 0x4041, 0x5279 },
	{ 0x4042, 0x34FD },
	{ 0x4043, 0x2F823 },
	{ 0x4044, 0x52E1 },
	{ 0x4045, 0x52E0 },
	{ 0x4046, 0x52E7 },
	{ 0x4047, 0x5380 },
	{ 0x4048, 0x53AB },
	{ 0x4049, 0x53AA },
	{ 0x404A, 0x53A9 },
	{ 0x404B, 0x53E0 },
	{ 0x404C, 0x55EA },
	{ 0x404D, 0x35DA },
	{ 0x404E, 0x55D7 },
	{ 0x404F, 0x35D6 },
	{ 0x4050, 0x35DB },
	{ 0x4051, 0x55C1 },
	{ 0x4052, 0x5715 },
	{ 0x4053, 0x365B },
	{ 0x4054, 0x586C },
	{ 0x4055, 0x365C },
	{ 0x4056, 0x585C },
	{ 0x4057, 0x5850 },
	{ 0x4058, 0x5861 },
	{ 0x4059, 0x586A },
	{ 0x405A, 0x5869 },
	{ 0x405B, 0x5856 },
	{ 0x405C, 0x5860 },
	{ 0x405D, 0x5866 },
	{ 0x405E, 0x585F },
	{ 0x405F, 0x5923 },
	{ 0x4060, 0x5966 },
	{ 0x4061, 0x5968 },
	{ 0x4062, 0x3706 },
	{ 0x4063, 0x370B },
	{ 0x4064, 0x5ACE },
	{ 0x4065, 0x370D },
	{ 0x4066, 0x5AC5 },
	{ 0x4067, 0x5AC3 },
	{ 0x4068, 0x370A },
	{ 0x4069, 0x3713 },
	{ 0x406A, 0x5AD0 },
	{ 0x406B, 0x3710 },
	{ 0x406C, 0x3712 },
	{ 0x406D, 0x3709 },
	{ 0x406E, 0x3708 },
	{ 0x406F, 0x3711 },
	{ 0x4070, 0x370F },
	{ 0x4071, 0x5B74 },
	{ 0x4072, 0x5B76 },
	{ 0x4073, 0x5BDC },
	{ 0x4074, 0x5BD7 },
	{ 0x4075, 0x5BDA },
	{ 0x4076, 0x5BDB },
	{ 0x4077, 0x3767 },
	{ 0x4078, 0x5C20 },
	{ 0x4079, 0x5D6D },
	{ 0x407A, 0x5D66 },
	{ 0x407B, 0x37F6 },
	{ 0x407C, 0x5D64 },
	{ 0x407D, 0x5D6E },
	{ 0x407E, 0x2F87E },
	{ 0x4121, 0x5D60 },
	{ 0x4122, 0x5F42 },
	{ 0x4123, 0x5F5A },
	{ 0x4124, 0x5F6E },
	{ 0x4125, 0x3964 },
	{ 0x4126, 0x396C },
	{ 0x4127, 0x6130 },
	{ 0x4128, 0x613A },
	{ 0x4129, 0x612A },
	{ 0x412A, 0x6143 },
	{ 0x412B, 0x6119 },
	{ 0x412C, 0x6131 },
	{ 0x412D, 0x396D },
	{ 0x412E, 0x613D },
	{ 0x412F, 0x397A },
	{ 0x4130, 0x3975 },
	{ 0x4131, 0x3A0D },
	{ 0x4132, 0x6408 },
	{ 0x4133, 0x6432 },
	{ 0x4134, 0x6438 },
	{ 0x4135, 0x3A1E },
	{ 0x4136, 0x6431 },
	{ 0x4137, 0x3A1B },
	{ 0x4138, 0x6419 },
	{ 0x4139, 0x3A2A },
	{ 0x413A, 0x6411 },
	{ 0x413B, 0x3A1F },
	{ 0x413C, 0x3A22 },
	{ 0x413D, 0x6429 },
	{ 0x413E, 0x641D },
	{ 0x413F, 0x3A25 },
	{ 0x4140, 0x3A27 },
	{ 0x4141, 0x3A29 },
	{ 0x4142, 0x643C },
	{ 0x4143, 0x3A24 },
	{ 0x4144, 0x6446 },
	{ 0x4145, 0x6447 },
	{ 0x4146, 0x3A28 },
	{ 0x4147, 0x3A26 },
	{ 0x4148, 0x643A },
	{ 0x4149, 0x6407 },
	{ 0x414A, 0x3A23 },
	{ 0x414B, 0x656B },
	{ 0x414C, 0x3A9F },
	{ 0x414D, 0x6570 },
	{ 0x414E, 0x656D },
	{ 0x414F, 0x3AB1 },
	{ 0x4150, 0x65E4 },
	{ 0x4151, 0x6693 },
	{ 0x4152, 0x3B03 },
	{ 0x4153, 0x3B07 },
	{ 0x4154, 0x3B0C },
	{ 0x4155, 0x3B06 },
	{ 0x4156, 0x668F },
	{ 0x4157, 0x3B04 },
	{ 0x4158, 0x3B09 },
	{ 0x4159, 0x6692 },
	{ 0x415A, 0x3B05 },
	{ 0x415B, 0x668E },
	{ 0x415C, 0x3B08 },
	{ 0x415D, 0x6946 },
	{ 0x415E, 0x3B96 },
	{ 0x415F, 0x3B9C },
	{ 0x4160, 0x3B9F },
	{ 0x4161, 0x3B9B },
	{ 0x4162, 0x3B98 },
	{ 0x4163, 0x3B99 },
	{ 0x4164, 0x3B94 },
	{ 0x4165, 0x6931 },
	{ 0x4166, 0x3B8D },
	{ 0x4167, 0x3BA3 },
	{ 0x4168, 0x693E },
	{ 0x4169, 0x3B93 },
	{ 0x416A, 0x697C },
	{ 0x416B, 0x6943 },
	{ 0x416C, 0x3B92 },
	{ 0x416D, 0x6973 },
	{ 0x416E, 0x2F8E8 },
	{ 0x416F, 0x6955 },
	{ 0x4170, 0x3B8E },
	{ 0x4171, 0x3B8C },
	{ 0x4172, 0x6985 },
	{ 0x4173, 0x694D },
	{ 0x4174, 0x6950 },
	{ 0x4175, 0x6947 },
	{ 0x4176, 0x6967 },
	{ 0x4177, 0x6936 },
	{ 0x4178, 0x6964 },
	{ 0x4179, 0x6961 },
	{ 0x417A, 0x3B9A },
	{ 0x417B, 0x697D },
	{ 0x417C, 0x6B44 },
	{ 0x417D, 0x6B40 },
	{ 0x417E, 0x6B71 },
	{ 0x4221, 0x6B73 },
	{ 0x4222, 0x6B9C },
	{ 0x4223, 0x3C6A },
	{ 0x4224, 0x3C6D },
	{ 0x4225, 0x3C84 },
	{ 0x4226, 0x6BC1 },
	{ 0x4227, 0x3CA0 },
	{ 0x4228, 0x6BFA },
	{ 0x4229, 0x6C31 },
	{ 0x422A, 0x6C32 },
	{ 0x422B, 0x3D1D },
	{ 0x422C, 0x3D26 },
	{ 0x422D, 0x6EB8 },
	{ 0x422E, 0x6EA8 },
	{ 0x422F, 0x3D33 },
	{ 0x4230, 0x6E91 },
	{ 0x4231, 0x6EBB },
	{ 0x4232, 0x3D38 },
	{ 0x4233, 0x6E9A },
	{ 0x4234, 0x3D30 },
	{ 0x4235, 0x3D28 },
	{ 0x4236, 0x6EA9 },
	{ 0x4237, 0x3D27 },
	{ 0x4238, 0x3D2A },
	{ 0x4239, 0x6EB5 },
	{ 0x423A, 0x6E6C },
	{ 0x423B, 0x6EE8 },
	{ 0x423C, 0x3D31 },
	{ 0x423D, 0x6EDD },
	{ 0x423E, 0x6EDA },
	{ 0x423F, 0x6EE6 },
	{ 0x4240, 0x6EAC },
	{ 0x4241, 0x3D34 },
	{ 0x4242, 0x3D2E },
	{ 0x4243, 0x3D3B },
	{ 0x4244, 0x6ED9 },
	{ 0x4245, 0x6EE3 },
	{ 0x4246, 0x6EE9 },
	{ 0x4247, 0x6EDB },
	{ 0x4248, 0x3D29 },
	{ 0x4249, 0x716F },
	{ 0x424A, 0x3DD2 },
	{ 0x424B, 0x3DD8 },
	{ 0x424C, 0x7148 },
	{ 0x424D, 0x3DCF },
	{ 0x424E, 0x714A },
	{ 0x424F, 0x716B },
	{ 0x4250, 0x3DD9 },
	{ 0x4251, 0x714F },
	{ 0x4252, 0x7157 },
	{ 0x4253, 0x7174 },
	{ 0x4254, 0x3DCE },
	{ 0x4255, 0x3DD3 },
	{ 0x4256, 0x3DD0 },
	{ 0x4257, 0x7145 },
	{ 0x4258, 0x7151 },
	{ 0x4259, 0x716D },
	{ 0x425A, 0x3BA1 },
	{ 0x425B, 0x7251 },
	{ 0x425C, 0x7250 },
	{ 0x425D, 0x724E },
	{ 0x425E, 0x3E47 },
	{ 0x425F, 0x7341 },
	{ 0x4260, 0x3E8B },
	{ 0x4261, 0x732E },
	{ 0x4262, 0x7346 },
	{ 0x4263, 0x3ED4 },
	{ 0x4264, 0x7427 },
	{ 0x4265, 0x3EDE },
	{ 0x4266, 0x7448 },
	{ 0x4267, 0x7453 },
	{ 0x4268, 0x743D },
	{ 0x4269, 0x3EDF },
	{ 0x426A, 0x745D },
	{ 0x426B, 0x7456 },
	{ 0x426C, 0x3ED7 },
	{ 0x426D, 0x741E },
	{ 0x426E, 0x7447 },
	{ 0x426F, 0x7443 },
	{ 0x4270, 0x7458 },
	{ 0x4271, 0x7449 },
	{ 0x4272, 0x3EE1 },
	{ 0x4273, 0x744C },
	{ 0x4274, 0x7445 },
	{ 0x4275, 0x743E },
	{ 0x4276, 0x3F2F },
	{ 0x4277, 0x7501 },
	{ 0x4278, 0x751E },
	{ 0x4279, 0x3F62 },
	{ 0x427A, 0x3F63 },
	{ 0x427B, 0x757A },
	{ 0x427C, 0x75EE },
	{ 0x427D, 0x7602 },
	{ 0x427E, 0x7697 },
	{ 0x4321, 0x7698 },
	{ 0x4322, 0x3FE2 },
	{ 0x4323, 0x4004 },
	{ 0x4324, 0x4043 },
	{ 0x4325, 0x775D },
	{ 0x4326, 0x7764 },
	{ 0x4327, 0x7753 },
	{ 0x4328, 0x7758 },
	{ 0x4329, 0x7882 },
	{ 0x432A, 0x7890 },
	{ 0x432B, 0x788A },
	{ 0x432C, 0x40BE },
	{ 0x432D, 0x787A },
	{ 0x432E, 0x787D },
	{ 0x432F, 0x40BA },
	{ 0x4330, 0x788B },
	{ 0x4331, 0x7878 },
	{ 0x4332, 0x40BC },
	{ 0x4333, 0x2F94E },
	{ 0x4334, 0x788D },
	{ 0x4335, 0x7888 },
	{ 0x4336, 0x7892 },
	{ 0x4337, 0x7881 },
	{ 0x4338, 0x797E },
	{ 0x4339, 0x7983 },
	{ 0x433A, 0x410D },
	{ 0x433B, 0x410E },
	{ 0x433C, 0x4111 },
	{ 0x433D, 0x7980 },
	{ 0x433E, 0x410F },
	{ 0x433F, 0x4112 },
	{ 0x4340, 0x4155 },
	{ 0x4341, 0x7A0F },
	{ 0x4342, 0x4159 },
	{ 0x4343, 0x415B },
	{ 0x4344, 0x7A1D },
	{ 0x4345, 0x4157 },
	{ 0x4346, 0x7AA1 },
	{ 0x4347, 0x7AA4 },
	{ 0x4348, 0x41CE },
	{ 0x4349, 0x7AE9 },
	{ 0x434A, 0x7AEA },
	{ 0x434B, 0x41FE },
	{ 0x434C, 0x7B62 },
	{ 0x434D, 0x7B6B },
	{ 0x434E, 0x41FC },
	{ 0x434F, 0x7B5E },
	{ 0x4350, 0x41F5 },
	{ 0x4351, 0x7B79 },
	{ 0x4352, 0x41F9 },
	{ 0x4353, 0x41FA },
	{ 0x4354, 0x7B6F },
	{ 0x4355, 0x7B68 },
	{ 0x4356, 0x4288 },
	{ 0x4357, 0x4289 },
	{ 0x4358, 0x7CAE },
	{ 0x4359, 0x428A },
	{ 0x435A, 0x4287 },
	{ 0x435B, 0x428B },
	{ 0x435C, 0x7CB0 },
	{ 0x435D, 0x42E6 },
	{ 0x435E, 0x7D90 },
	{ 0x435F, 0x42ED },
	{ 0x4360, 0x7D8A },
	{ 0x4361, 0x42E5 },
	{ 0x4362, 0x7D8B },
	{ 0x4363, 0x7D99 },
	{ 0x4364, 0x7D95 },
	{ 0x4365, 0x42E0 },
	{ 0x4366, 0x7D87 },
	{ 0x4367, 0x7D78 },
	{ 0x4368, 0x7D97 },
	{ 0x4369, 0x7D89 },
	{ 0x436A, 0x7D98 },
	{ 0x436B, 0x42E1 },
	{ 0x436C, 0x435B },
	{ 0x436D, 0x435C },
	{ 0x436E, 0x7FA3 },
	{ 0x436F, 0x438F },
	{ 0x4370, 0x438B },
	{ 0x4371, 0x438D },
	{ 0x4372, 0x7FDD },
	{ 0x4373, 0x8057 },
	{ 0x4374, 0x43B9 },
	{ 0x4375, 0x8163 },
	{ 0x4376, 0x816A },
	{ 0x4377, 0x816C },
	{ 0x4378, 0x440F },
	{ 0x4379, 0x4419 },
	{ 0x437A, 0x4413 },
	{ 0x437B, 0x815D },
	{ 0x437C, 0x8175 },
	{ 0x437D, 0x4418 },
	{ 0x437E, 0x815F },
	{ 0x4421, 0x4416 },
	{ 0x4422, 0x817D },
	{ 0x4423, 0x816D },
	{ 0x4424, 0x4453 },
	{ 0x4425, 0x2F98D },
	{ 0x4426, 0x8241 },
	{ 0x4427, 0x844F },
	{ 0x4428, 0x8484 },
	{ 0x4429, 0x44F6 },
	{ 0x442A, 0x847F },
	{ 0x442B, 0x44F5 },
	{ 0x442C, 0x8448 },
	{ 0x442D, 0x842A },
	{ 0x442E, 0x847B },
	{ 0x442F, 0x8472 },
	{ 0x4430, 0x8464 },
	{ 0x4431, 0x842E },
	{ 0x4432, 0x845C },
	{ 0x4433, 0x8453 },
	{ 0x4434, 0x44F7 },
	{ 0x4435, 0x8441 },
	{ 0x4436, 0x84C8 },
	{ 0x4437, 0x44F0 },
	{ 0x4438, 0x8462 },
	{ 0x4439, 0x8480 },
	{ 0x443A, 0x843E },
	{ 0x443B, 0x8483 },
	{ 0x443C, 0x8471 },
	{ 0x443D, 0x44F9 },
	{ 0x443E, 0x844A },
	{ 0x443F, 0x8455 },
	{ 0x4440, 0x8458 },
	{ 0x4441, 0x4592 },
	{ 0x4442, 0x4595 },
	{ 0x4443, 0x4596 },
	{ 0x4444, 0x86FC },
	{ 0x4445, 0x86FD },
	{ 0x4446, 0x8715 },
	{ 0x4447, 0x45B9 },
	{ 0x4448, 0x8716 },
	{ 0x4449, 0x86FF },
	{ 0x444A, 0x45BD },
	{ 0x444B, 0x45B8 },
	{ 0x444C, 0x4612 },
	{ 0x444D, 0x8858 },
	{ 0x444E, 0x88CF },
	{ 0x444F, 0x88E0 },
	{ 0x4450, 0x4680 },
	{ 0x4451, 0x4681 },
	{ 0x4452, 0x469A },
	{ 0x4453, 0x4698 },
	{ 0x4454, 0x89E7 },
	{ 0x4455, 0x8A6A },
	{ 0x4456, 0x8A80 },
	{ 0x4457, 0x46D4 },
	{ 0x4458, 0x8A6F },
	{ 0x4459, 0x8A65 },
	{ 0x445A, 0x46DA },
	{ 0x445B, 0x8A78 },
	{ 0x445C, 0x8A7D },
	{ 0x445D, 0x8A88 },
	{ 0x445E, 0x46D6 },
	{ 0x445F, 0x46DB },
	{ 0x4460, 0x8A64 },
	{ 0x4461, 0x8A7E },
	{ 0x4462, 0x46DC },
	{ 0x4463, 0x8A67 },
	{ 0x4464, 0x8C63 },
	{ 0x4465, 0x8C88 },
	{ 0x4466, 0x4771 },
	{ 0x4467, 0x8CCD },
	{ 0x4468, 0x4772 },
	{ 0x4469, 0x8CC9 },
	{ 0x446A, 0x47A8 },
	{ 0x446B, 0x8DED },
	{ 0x446C, 0x47F0 },
	{ 0x446D, 0x2F9DB },
	{ 0x446E, 0x47F1 },
	{ 0x446F, 0x47FD },
	{ 0x4470, 0x4838 },
	{ 0x4471, 0x4837 },
	{ 0x4472, 0x4839 },
	{ 0x4473, 0x8EB1 },
	{ 0x4474, 0x4855 },
	{ 0x4475, 0x4853 },
	{ 0x4476, 0x8F04 },
	{ 0x4477, 0x8F9E },
	{ 0x4478, 0x8FA0 },
	{ 0x4479, 0x9043 },
	{ 0x447A, 0x9046 },
	{ 0x447B, 0x9048 },
	{ 0x447C, 0x9045 },
	{ 0x447D, 0x9040 },
	{ 0x447E, 0x904C },
	{ 0x4521, 0x48D5 },
	{ 0x4522, 0x48BD },
	{ 0x4523, 0x910C },
	{ 0x4524, 0x9113 },
	{ 0x4525, 0x9115 },
	{ 0x4526, 0x48F5 },
	{ 0x4527, 0x916B },
	{ 0x4528, 0x9167 },
	{ 0x4529, 0x925D },
	{ 0x452A, 0x9255 },
	{ 0x452B, 0x9235 },
	{ 0x452C, 0x4921 },
	{ 0x452D, 0x9259 },
	{ 0x452E, 0x922F },
	{ 0x452F, 0x923C },
	{ 0x4530, 0x928F },
	{ 0x4531, 0x925C },
	{ 0x4532, 0x926A },
	{ 0x4533, 0x9262 },
	{ 0x4534, 0x925F },
	{ 0x4535, 0x926B },
	{ 0x4536, 0x926E },
	{ 0x4537, 0x923B },
	{ 0x4538, 0x9244 },
	{ 0x4539, 0x9241 },
	{ 0x453A, 0x959A },
	{ 0x453B, 0x4992 },
	{ 0x453C, 0x9599 },
	{ 0x453D, 0x49DE },
	{ 0x453E, 0x49DB },
	{ 0x453F, 0x49DA },
	{ 0x4540, 0x968F },
	{ 0x4541, 0x49DF },
	{ 0x4542, 0x9696 },
	{ 0x4543, 0x49F9 },
	{ 0x4544, 0x49F8 },
	{ 0x4545, 0x49FA },
	{ 0x4546, 0x96F4 },
	{ 0x4547, 0x96FC },
	{ 0x4548, 0x4A0E },
	{ 0x4549, 0x9755 },
	{ 0x454A, 0x4A43 },
	{ 0x454B, 0x9779 },
	{ 0x454C, 0x4A56 },
	{ 0x454D, 0x4A53 },
	{ 0x454E, 0x4A9E },
	{ 0x454F, 0x97EE },
	{ 0x4550, 0x97F5 },
	{ 0x4551, 0x4AA9 },
	{ 0x4552, 0x980B },
	{ 0x4553, 0x4AFA },
	{ 0x4554, 0x98F3 },
	{ 0x4555, 0x4B31 },
	{ 0x4556, 0x4B30 },
	{ 0x4557, 0x98F7 },
	{ 0x4558, 0x98FF },
	{ 0x4559, 0x98F5 },
	{ 0x455A, 0x4B32 },
	{ 0x455B, 0x98EC },
	{ 0x455C, 0x98F1 },
	{ 0x455D, 0x4B29 },
	{ 0x455E, 0x4B2E },
	{ 0x455F, 0x999A },
	{ 0x4560, 0x4B76 },
	{ 0x4561, 0x9AE2 },
	{ 0x4562, 0x9B3D },
	{ 0x4563, 0x9B5D },
	{ 0x4564, 0x9CE8 },
	{ 0x4565, 0x4CA5 },
	{ 0x4566, 0x9CEB },
	{ 0x4567, 0x9CEF },
	{ 0x4568, 0x9CEE },
	{ 0x4569, 0x9E81 },
	{ 0x456A, 0x9F14 },
	{ 0x456B, 0x50D0 },
	{ 0x456C, 0x50D9 },
	{ 0x456D, 0x50DC },
	{ 0x456E, 0x50D8 },
	{ 0x456F, 0x348C },
	{ 0x4570, 0x50E1 },
	{ 0x4571, 0x50EB },
	{ 0x4572, 0x348B },
	{ 0x4573, 0x3489 },
	{ 0x4574, 0x50F4 },
	{ 0x4575, 0x50E2 },
	{ 0x4576, 0x50DE },
	{ 0x4577, 0x348D },
	{ 0x4578, 0x3486 },
	{ 0x4579, 0x34D7 },
	{ 0x457A, 0x51F4 },
	{ 0x457B, 0x3504 },
	{ 0x457C, 0x3507 },
	{ 0x457D, 0x3503 },
	{ 0x457E, 0x52ED },
	{ 0x4621, 0x52EA },
	{ 0x4622, 0x3522 },
	{ 0x4623, 0x5332 },
	{ 0x4624, 0x3551 },
	{ 0x4625, 0x53AE },
	{ 0x4626, 0x53B0 },
	{ 0x4627, 0x3561 },
	{ 0x4628, 0x55FB },
	{ 0x4629, 0x5603 },
	{ 0x462A, 0x560B },
	{ 0x462B, 0x35E9 },
	{ 0x462C, 0x5607 },
	{ 0x462D, 0x35E5 },
	{ 0x462E, 0x55F8 },
	{ 0x462F, 0x35E4 },
	{ 0x4630, 0x5628 },
	{ 0x4631, 0x561E },
	{ 0x4632, 0x35E3 },
	{ 0x4633, 0x5618 },
	{ 0x4634, 0x5611 },
	{ 0x4635, 0x5651 },
	{ 0x4636, 0x5605 },
	{ 0x4637, 0x5717 },
	{ 0x4638, 0x5892 },
	{ 0x4639, 0x3665 },
	{ 0x463A, 0x588C },
	{ 0x463B, 0x3663 },
	{ 0x463C, 0x5878 },
	{ 0x463D, 0x5884 },
	{ 0x463E, 0x5873 },
	{ 0x463F, 0x58AD },
	{ 0x4640, 0x5897 },
	{ 0x4641, 0x5895 },
	{ 0x4642, 0x5877 },
	{ 0x4643, 0x5872 },
	{ 0x4644, 0x5896 },
	{ 0x4645, 0x588D },
	{ 0x4646, 0x5910 },
	{ 0x4647, 0x368C },
	{ 0x4648, 0x596C },
	{ 0x4649, 0x371A },
	{ 0x464A, 0x5AE7 },
	{ 0x464B, 0x3715 },
	{ 0x464C, 0x5AE4 },
	{ 0x464D, 0x3720 },
	{ 0x464E, 0x3721 },
	{ 0x464F, 0x5AEF },
	{ 0x4650, 0x5626 },
	{ 0x4651, 0x371C },
	{ 0x4652, 0x371B },
	{ 0x4653, 0x5AF0 },
	{ 0x4654, 0x5D7B },
	{ 0x4655, 0x37FE },
	{ 0x4656, 0x5D83 },
	{ 0x4657, 0x3804 },
	{ 0x4658, 0x3801 },
	{ 0x4659, 0x5D8B },
	{ 0x465A, 0x5D8C },
	{ 0x465B, 0x3800 },
	{ 0x465C, 0x5D78 },
	{ 0x465D, 0x5E52 },
	{ 0x465E, 0x386D },
	{ 0x465F, 0x3893 },
	{ 0x4660, 0x5ED0 },
	{ 0x4661, 0x5ECF },
	{ 0x4662, 0x38A1 },
	{ 0x4663, 0x5FB3 },
	{ 0x4664, 0x5FB4 },
	{ 0x4665, 0x3976 },
	{ 0x4666, 0x3979 },
	{ 0x4667, 0x3972 },
	{ 0x4668, 0x617B },
	{ 0x4669, 0x3983 },
	{ 0x466A, 0x616F },
	{ 0x466B, 0x6181 },
	{ 0x466C, 0x613C },
	{ 0x466D, 0x6142 },
	{ 0x466E, 0x6138 },
	{ 0x466F, 0x6133 },
	{ 0x4670, 0x2F8A6 },
	{ 0x4671, 0x6160 },
	{ 0x4672, 0x6169 },
	{ 0x4673, 0x617D },
	{ 0x4674, 0x6186 },
	{ 0x4675, 0x622C },
	{ 0x4676, 0x6228 },
	{ 0x4677, 0x3A38 },
	{ 0x4678, 0x644C },
	{ 0x4679, 0x3A30 },
	{ 0x467A, 0x6457 },
	{ 0x467B, 0x647C },
	{ 0x467C, 0x3A34 },
	{ 0x467D, 0x3A3A },
	{ 0x467E, 0x6455 },
	{ 0x4721, 0x6462 },
	{ 0x4722, 0x6471 },
	{ 0x4723, 0x646A },
	{ 0x4724, 0x6456 },
	{ 0x4725, 0x643B },
	{ 0x4726, 0x6481 },
	{ 0x4727, 0x3A35 },
	{ 0x4728, 0x644F },
	{ 0x4729, 0x647E },
	{ 0x472A, 0x6464 },
	{ 0x472B, 0x3A3F },
	{ 0x472C, 0x3A40 },
	{ 0x472D, 0x3A32 },
	{ 0x472E, 0x3A31 },
	{ 0x472F, 0x3A36 },
	{ 0x4730, 0x6571 },
	{ 0x4731, 0x230BA },
	{ 0x4732, 0x3B0F },
	{ 0x4733, 0x66A5 },
	{ 0x4734, 0x669A },
	{ 0x4735, 0x669C },
	{ 0x4736, 0x3B10 },
	{ 0x4737, 0x66A6 },
	{ 0x4738, 0x3B0D },
	{ 0x4739, 0x66A4 },
	{ 0x473A, 0x698F },
	{ 0x473B, 0x69C5 },
	{ 0x473C, 0x69C8 },
	{ 0x473D, 0x6992 },
	{ 0x473E, 0x69B2 },
	{ 0x473F, 0x3BA9 },
	{ 0x4740, 0x3BB4 },
	{ 0x4741, 0x3BAC },
	{ 0x4742, 0x69E3 },
	{ 0x4743, 0x69C0 },
	{ 0x4744, 0x69D6 },
	{ 0x4745, 0x69D1 },
	{ 0x4746, 0x699F },
	{ 0x4747, 0x69A2 },
	{ 0x4748, 0x69D2 },
	{ 0x4749, 0x3BB8 },
	{ 0x474A, 0x3BAE },
	{ 0x474B, 0x235F3 },
	{ 0x474C, 0x69E1 },
	{ 0x474D, 0x69D5 },
	{ 0x474E, 0x699D },
	{ 0x474F, 0x3BB3 },
	{ 0x4750, 0x3BBA },
	{ 0x4751, 0x6998 },
	{ 0x4752, 0x3C3F },
	{ 0x4753, 0x6B74 },
	{ 0x4754, 0x6BA1 },
	{ 0x4755, 0x3D3C },
	{ 0x4756, 0x6EF0 },
	{ 0x4757, 0x6EF3 },
	{ 0x4758, 0x3D42 },
	{ 0x4759, 0x3D40 },
	{ 0x475A, 0x6F1B },
	{ 0x475B, 0x6F0C },
	{ 0x475C, 0x6F1D },
	{ 0x475D, 0x6F34 },
	{ 0x475E, 0x6F28 },
	{ 0x475F, 0x6F17 },
	{ 0x4760, 0x3D3E },
	{ 0x4761, 0x6F44 },
	{ 0x4762, 0x6F42 },
	{ 0x4763, 0x6F04 },
	{ 0x4764, 0x6F11 },
	{ 0x4765, 0x6EFA },
	{ 0x4766, 0x6F4A },
	{ 0x4767, 0x7191 },
	{ 0x4768, 0x718E },
	{ 0x4769, 0x3DE1 },
	{ 0x476A, 0x718B },
	{ 0x476B, 0x718D },
	{ 0x476C, 0x717F },
	{ 0x476D, 0x718C },
	{ 0x476E, 0x717E },
	{ 0x476F, 0x717C },
	{ 0x4770, 0x7183 },
	{ 0x4771, 0x3DE6 },
	{ 0x4772, 0x7188 },
	{ 0x4773, 0x3DE0 },
	{ 0x4774, 0x3E15 },
	{ 0x4775, 0x7294 },
	{ 0x4776, 0x3E93 },
	{ 0x4777, 0x7355 },
	{ 0x4778, 0x7353 },
	{ 0x4779, 0x734F },
	{ 0x477A, 0x7354 },
	{ 0x477B, 0x746C },
	{ 0x477C, 0x7465 },
	{ 0x477D, 0x7466 },
	{ 0x477E, 0x7461 },
	{ 0x4821, 0x746B },
	{ 0x4822, 0x7468 },
	{ 0x4823, 0x7476 },
	{ 0x4824, 0x3EE7 },
	{ 0x4825, 0x7460 },
	{ 0x4826, 0x24A0F },
	{ 0x4827, 0x7474 },
	{ 0x4828, 0x7506 },
	{ 0x4829, 0x760E },
	{ 0x482A, 0x3FAD },
	{ 0x482B, 0x7607 },
	{ 0x482C, 0x3FAE },
	{ 0x482D, 0x3FE3 },
	{ 0x482E, 0x76B9 },
	{ 0x482F, 0x3FF5 },
	{ 0x4830, 0x76B7 },
	{ 0x4831, 0x76E2 },
	{ 0x4832, 0x4006 },
	{ 0x4833, 0x7774 },
	{ 0x4834, 0x7777 },
	{ 0x4835, 0x7776 },
	{ 0x4836, 0x7775 },
	{ 0x4837, 0x404F },
	{ 0x4838, 0x7778 },
	{ 0x4839, 0x7771 },
	{ 0x483A, 0x4054 },
	{ 0x483B, 0x777A },
	{ 0x483C, 0x715B },
	{ 0x483D, 0x777B },
	{ 0x483E, 0x78A6 },
	{ 0x483F, 0x78AE },
	{ 0x4840, 0x78B8 },
	{ 0x4841, 0x40CB },
	{ 0x4842, 0x40E3 },
	{ 0x4843, 0x40C9 },
	{ 0x4844, 0x78B1 },
	{ 0x4845, 0x78AF },
	{ 0x4846, 0x4113 },
	{ 0x4847, 0x7989 },
	{ 0x4848, 0x7987 },
	{ 0x4849, 0x4115 },
	{ 0x484A, 0x4161 },
	{ 0x484B, 0x7A29 },
	{ 0x484C, 0x4166 },
	{ 0x484D, 0x7A2A },
	{ 0x484E, 0x4164 },
	{ 0x484F, 0x7A2D },
	{ 0x4850, 0x7A2C },
	{ 0x4851, 0x4160 },
	{ 0x4852, 0x7A32 },
	{ 0x4853, 0x4163 },
	{ 0x4854, 0x7AEC },
	{ 0x4855, 0x7AF0 },
	{ 0x4856, 0x7B81 },
	{ 0x4857, 0x7B9E },
	{ 0x4858, 0x7B83 },
	{ 0x4859, 0x420A },
	{ 0x485A, 0x7B92 },
	{ 0x485B, 0x4204 },
	{ 0x485C, 0x7BA3 },
	{ 0x485D, 0x7B9F },
	{ 0x485E, 0x7B93 },
	{ 0x485F, 0x4207 },
	{ 0x4860, 0x7B86 },
	{ 0x4861, 0x7CB8 },
	{ 0x4862, 0x7CB7 },
	{ 0x4863, 0x428D },
	{ 0x4864, 0x428F },
	{ 0x4865, 0x4290 },
	{ 0x4866, 0x4292 },
	{ 0x4867, 0x42EC },
	{ 0x4868, 0x7DC8 },
	{ 0x4869, 0x7DB6 },
	{ 0x486A, 0x2F96C },
	{ 0x486B, 0x7DD1 },
	{ 0x486C, 0x42E7 },
	{ 0x486D, 0x7DA8 },
	{ 0x486E, 0x7DAB },
	{ 0x486F, 0x42F2 },
	{ 0x4870, 0x7DB3 },
	{ 0x4871, 0x7DCD },
	{ 0x4872, 0x42EE },
	{ 0x4873, 0x7DCF },
	{ 0x4874, 0x7DA4 },
	{ 0x4875, 0x42EF },
	{ 0x4876, 0x434C },
	{ 0x4877, 0x7F41 },
	{ 0x4878, 0x7F6F },
	{ 0x4879, 0x7F71 },
	{ 0x487A, 0x435E },
	{ 0x487B, 0x435F },
	{ 0x487C, 0x4376 },
	{ 0x487D, 0x4374 },
	{ 0x487E, 0x4372 },
	{ 0x4921, 0x4390 },
	{ 0x4922, 0x8023 },
	{ 0x4923, 0x805B },
	{ 0x4924, 0x43BE },
	{ 0x4925, 0x8061 },
	{ 0x4926, 0x805F },
	{ 0x4927, 0x8181 },
	{ 0x4928, 0x4426 },
	{ 0x4929, 0x4425 },
	{ 0x492A, 0x8184 },
	{ 0x492B, 0x8213 },
	{ 0x492C, 0x4474 },
	{ 0x492D, 0x824A },
	{ 0x492E, 0x824C },
	{ 0x492F, 0x44FD },
	{ 0x4930, 0x4505 },
	{ 0x4931, 0x4501 },
	{ 0x4932, 0x84BD },
	{ 0x4933, 0x8495 },
	{ 0x4934, 0x4509 },
	{ 0x4935, 0x8492 },
	{ 0x4936, 0x84C3 },
	{ 0x4937, 0x450C },
	{ 0x4938, 0x8496 },
	{ 0x4939, 0x84A5 },
	{ 0x493A, 0x84B5 },
	{ 0x493B, 0x84B3 },
	{ 0x493C, 0x84A3 },
	{ 0x493D, 0x84E4 },
	{ 0x493E, 0x84D8 },
	{ 0x493F, 0x84D5 },
	{ 0x4940, 0x450D },
	{ 0x4941, 0x84B7 },
	{ 0x4942, 0x84AD },
	{ 0x4943, 0x84DA },
	{ 0x4944, 0x8493 },
	{ 0x4945, 0x8736 },
	{ 0x4946, 0x45C0 },
	{ 0x4947, 0x45C5 },
	{ 0x4948, 0x45C9 },
	{ 0x4949, 0x873D },
	{ 0x494A, 0x872B },
	{ 0x494B, 0x8747 },
	{ 0x494C, 0x8739 },
	{ 0x494D, 0x45D5 },
	{ 0x494E, 0x8745 },
	{ 0x494F, 0x871D },
	{ 0x4950, 0x4641 },
	{ 0x4951, 0x88FF },
	{ 0x4952, 0x88EA },
	{ 0x4953, 0x4633 },
	{ 0x4954, 0x88F5 },
	{ 0x4955, 0x463A },
	{ 0x4956, 0x8900 },
	{ 0x4957, 0x88ED },
	{ 0x4958, 0x8903 },
	{ 0x4959, 0x88E9 },
	{ 0x495A, 0x4640 },
	{ 0x495B, 0x4642 },
	{ 0x495C, 0x89EA },
	{ 0x495D, 0x46E8 },
	{ 0x495E, 0x8A9B },
	{ 0x495F, 0x8A8E },
	{ 0x4960, 0x8AA2 },
	{ 0x4961, 0x46E4 },
	{ 0x4962, 0x8A9C },
	{ 0x4963, 0x8A94 },
	{ 0x4964, 0x8A90 },
	{ 0x4965, 0x8AA9 },
	{ 0x4966, 0x8AAC },
	{ 0x4967, 0x46E7 },
	{ 0x4968, 0x8A9F },
	{ 0x4969, 0x46E6 },
	{ 0x496A, 0x46E1 },
	{ 0x496B, 0x8A9D },
	{ 0x496C, 0x4739 },
	{ 0x496D, 0x8C67 },
	{ 0x496E, 0x475C },
	{ 0x496F, 0x4775 },
	{ 0x4970, 0x8CD0 },
	{ 0x4971, 0x8CD6 },
	{ 0x4972, 0x8CD4 },
	{ 0x4973, 0x8D98 },
	{ 0x4974, 0x8D9A },
	{ 0x4975, 0x8D97 },
	{ 0x4976, 0x47AE },
	{ 0x4977, 0x47B0 },
	{ 0x4978, 0x47FA },
	{ 0x4979, 0x8E0B },
	{ 0x497A, 0x8E08 },
	{ 0x497B, 0x8E01 },
	{ 0x497C, 0x8EB4 },
	{ 0x497D, 0x8EB3 },
	{ 0x497E, 0x485B },
	{ 0x4A21, 0x8FA1 },
	{ 0x4A22, 0x8FA2 },
	{ 0x4A23, 0x48A5 },
	{ 0x4A24, 0x905A },
	{ 0x4A25, 0x48A2 },
	{ 0x4A26, 0x9061 },
	{ 0x4A27, 0x905F },
	{ 0x4A28, 0x48DB },
	{ 0x4A29, 0x48DA },
	{ 0x4A2A, 0x9125 },
	{ 0x4A2B, 0x917B },
	{ 0x4A2C, 0x9176 },
	{ 0x4A2D, 0x917C },
	{ 0x4A2E, 0x4924 },
	{ 0x4A2F, 0x9289 },
	{ 0x4A30, 0x92F6 },
	{ 0x4A31, 0x92B1 },
	{ 0x4A32, 0x92AD },
	{ 0x4A33, 0x9292 },
	{ 0x4A34, 0x9281 },
	{ 0x4A35, 0x9284 },
	{ 0x4A36, 0x4926 },
	{ 0x4A37, 0x92AE },
	{ 0x4A38, 0x9290 },
	{ 0x4A39, 0x929E },
	{ 0x4A3A, 0x4998 },
	{ 0x4A3B, 0x4996 },
	{ 0x4A3C, 0x499A },
	{ 0x4A3D, 0x95A2 },
	{ 0x4A3E, 0x95A7 },
	{ 0x4A3F, 0x4997 },
	{ 0x4A40, 0x49E1 },
	{ 0x4A41, 0x49E0 },
	{ 0x4A42, 0x49E3 },
	{ 0x4A43, 0x49E2 },
	{ 0x4A44, 0x96A0 },
	{ 0x4A45, 0x969D },
	{ 0x4A46, 0x969F },
	{ 0x4A47, 0x96D0 },
	{ 0x4A48, 0x49FB },
	{ 0x4A49, 0x96D1 },
	{ 0x4A4A, 0x4A12 },
	{ 0x4A4B, 0x4A14 },
	{ 0x4A4C, 0x9759 },
	{ 0x4A4D, 0x4A45 },
	{ 0x4A4E, 0x9764 },
	{ 0x4A4F, 0x4A5C },
	{ 0x4A50, 0x4A5D },
	{ 0x4A51, 0x4AB8 },
	{ 0x4A52, 0x9819 },
	{ 0x4A53, 0x4ABA },
	{ 0x4A54, 0x9814 },
	{ 0x4A55, 0x9815 },
	{ 0x4A56, 0x981A },
	{ 0x4A57, 0x4B03 },
	{ 0x4A58, 0x4B35 },
	{ 0x4A59, 0x4B36 },
	{ 0x4A5A, 0x4B39 },
	{ 0x4A5B, 0x9906 },
	{ 0x4A5C, 0x4B2D },
	{ 0x4A5D, 0x98F8 },
	{ 0x4A5E, 0x9901 },
	{ 0x4A5F, 0x4B7A },
	{ 0x4A60, 0x99BE },
	{ 0x4A61, 0x99BC },
	{ 0x4A62, 0x99B7 },
	{ 0x4A63, 0x99B6 },
	{ 0x4A64, 0x99C0 },
	{ 0x4A65, 0x4B78 },
	{ 0x4A66, 0x99B8 },
	{ 0x4A67, 0x4B7B },
	{ 0x4A68, 0x4B7C },
	{ 0x4A69, 0x4B7E },
	{ 0x4A6A, 0x99C4 },
	{ 0x4A6B, 0x4B7D },
	{ 0x4A6C, 0x99BF },
	{ 0x4A6D, 0x4BC9 },
	{ 0x4A6E, 0x9ADA },
	{ 0x4A6F, 0x9AE4 },
	{ 0x4A70, 0x9AE9 },
	{ 0x4A71, 0x9AE8 },
	{ 0x4A72, 0x9AEA },
	{ 0x4A73, 0x9AE5 },
	{ 0x4A74, 0x4BF3 },
	{ 0x4A75, 0x9B26 },
	{ 0x4A76, 0x4C1A },
	{ 0x4A77, 0x4C19 },
	{ 0x4A78, 0x9B40 },
	{ 0x4A79, 0x4C1F },
	{ 0x4A7A, 0x4CA6 },
	{ 0x4A7B, 0x4CA7 },
	{ 0x4A7C, 0x4CA8 },
	{ 0x4A7D, 0x4CAB },
	{ 0x4A7E, 0x4CA9 },
	{ 0x4B21, 0x4D2E },
	{ 0x4B22, 0x9EBD },
	{ 0x4B23, 0x4D5E },
	{ 0x4B24, 0x3495 },
	{ 0x4B25, 0x3493 },
	{ 0x4B26, 0x3492 },
	{ 0x4B27, 0x510E },
	{ 0x4B28, 0x3496 },
	{ 0x4B29, 0x50F7 },
	{ 0x4B2A, 0x3497 },
	{ 0x4B2B, 0x50FC },
	{ 0x4B2C, 0x510D },
	{ 0x4B2D, 0x5101 },
	{ 0x4B2E, 0x51DA },
	{ 0x4B2F, 0x51D9 },
	{ 0x4B30, 0x51DB },
	{ 0x4B31, 0x5286 },
	{ 0x4B32, 0x528E },
	{ 0x4B33, 0x52EE },
	{ 0x4B34, 0x5333 },
	{ 0x4B35, 0x53B1 },
	{ 0x4B36, 0x35F5 },
	{ 0x4B37, 0x5647 },
	{ 0x4B38, 0x562D },
	{ 0x4B39, 0x5654 },
	{ 0x4B3A, 0x35EA },
	{ 0x4B3B, 0x564B },
	{ 0x4B3C, 0x5652 },
	{ 0x4B3D, 0x5631 },
	{ 0x4B3E, 0x5644 },
	{ 0x4B3F, 0x5656 },
	{ 0x4B40, 0x5650 },
	{ 0x4B41, 0x562B },
	{ 0x4B42, 0x35F3 },
	{ 0x4B43, 0x564D },
	{ 0x4B44, 0x5637 },
	{ 0x4B45, 0x564F },
	{ 0x4B46, 0x58A2 },
	{ 0x4B47, 0x58B7 },
	{ 0x4B48, 0x3669 },
	{ 0x4B49, 0x58B2 },
	{ 0x4B4A, 0x366B },
	{ 0x4B4B, 0x58AA },
	{ 0x4B4C, 0x58B5 },
	{ 0x4B4D, 0x58B0 },
	{ 0x4B4E, 0x366C },
	{ 0x4B4F, 0x58B4 },
	{ 0x4B50, 0x58A4 },
	{ 0x4B51, 0x58A7 },
	{ 0x4B52, 0x3668 },
	{ 0x4B53, 0x5926 },
	{ 0x4B54, 0x5AFE },
	{ 0x4B55, 0x3728 },
	{ 0x4B56, 0x5B04 },
	{ 0x4B57, 0x3726 },
	{ 0x4B58, 0x5AFC },
	{ 0x4B59, 0x3725 },
	{ 0x4B5A, 0x5B06 },
	{ 0x4B5B, 0x5B0A },
	{ 0x4B5C, 0x5AFA },
	{ 0x4B5D, 0x5B0D },
	{ 0x4B5E, 0x5B00 },
	{ 0x4B5F, 0x5B0E },
	{ 0x4B60, 0x376B },
	{ 0x4B61, 0x380F },
	{ 0x4B62, 0x3808 },
	{ 0x4B63, 0x5D91 },
	{ 0x4B64, 0x380C },
	{ 0x4B65, 0x5D8F },
	{ 0x4B66, 0x5D90 },
	{ 0x4B67, 0x5D98 },
	{ 0x4B68, 0x5DA4 },
	{ 0x4B69, 0x5D9B },
	{ 0x4B6A, 0x5DA3 },
	{ 0x4B6B, 0x5D96 },
	{ 0x4B6C, 0x5DE4 },
	{ 0x4B6D, 0x5E5A },
	{ 0x4B6E, 0x3860 },
	{ 0x4B6F, 0x3862 },
	{ 0x4B70, 0x5E5E },
	{ 0x4B71, 0x3898 },
	{ 0x4B72, 0x5FB8 },
	{ 0x4B73, 0x6157 },
	{ 0x4B74, 0x615C },
	{ 0x4B75, 0x61A6 },
	{ 0x4B76, 0x6195 },
	{ 0x4B77, 0x6188 },
	{ 0x4B78, 0x398A },
	{ 0x4B79, 0x61A3 },
	{ 0x4B7A, 0x618F },
	{ 0x4B7B, 0x3984 },
	{ 0x4B7C, 0x6164 },
	{ 0x4B7D, 0x397F },
	{ 0x4B7E, 0x6159 },
	{ 0x4C21, 0x6178 },
	{ 0x4C22, 0x3982 },
	{ 0x4C23, 0x6185 },
	{ 0x4C24, 0x6187 },
	{ 0x4C25, 0x619E },
	{ 0x4C26, 0x3996 },
	{ 0x4C27, 0x3989 },
	{ 0x4C28, 0x6198 },
	{ 0x4C29, 0x619C },
	{ 0x4C2A, 0x398D },
	{ 0x4C2B, 0x39BC },
	{ 0x4C2C, 0x622F },
	{ 0x4C2D, 0x6480 },
	{ 0x4C2E, 0x649B },
	{ 0x4C2F, 0x648E },
	{ 0x4C30, 0x648D },
	{ 0x4C31, 0x6494 },
	{ 0x4C32, 0x64C6 },
	{ 0x4C33, 0x3A44 },
	{ 0x4C34, 0x64A8 },
	{ 0x4C35, 0x6483 },
	{ 0x4C36, 0x3A3C },
	{ 0x4C37, 0x64B9 },
	{ 0x4C38, 0x6486 },
	{ 0x4C39, 0x64B4 },
	{ 0x4C3A, 0x64AF },
	{ 0x4C3B, 0x6491 },
	{ 0x4C3C, 0x3A4E },
	{ 0x4C3D, 0x64AA },
	{ 0x4C3E, 0x64A1 },
	{ 0x4C3F, 0x64A7 },
	{ 0x4C40, 0x66B6 },
	{ 0x4C41, 0x66B3 },
	{ 0x4C42, 0x3B14 },
	{ 0x4C43, 0x66BC },
	{ 0x4C44, 0x66AC },
	{ 0x4C45, 0x3B15 },
	{ 0x4C46, 0x66AD },
	{ 0x4C47, 0x6A0E },
	{ 0x4C48, 0x3BCE },
	{ 0x4C49, 0x6A1C },
	{ 0x4C4A, 0x6A1A },
	{ 0x4C4B, 0x3BE0 },
	{ 0x4C4C, 0x3BC2 },
	{ 0x4C4D, 0x6A0B },
	{ 0x4C4E, 0x3BBF },
	{ 0x4C4F, 0x69EF },
	{ 0x4C50, 0x6A0C },
	{ 0x4C51, 0x69F0 },
	{ 0x4C52, 0x6A22 },
	{ 0x4C53, 0x3BC4 },
	{ 0x4C54, 0x69D8 },
	{ 0x4C55, 0x3BCF },
	{ 0x4C56, 0x6A12 },
	{ 0x4C57, 0x69FA },
	{ 0x4C58, 0x3BC8 },
	{ 0x4C59, 0x6A2A },
	{ 0x4C5A, 0x3BCC },
	{ 0x4C5B, 0x6A10 },
	{ 0x4C5C, 0x3BCD },
	{ 0x4C5D, 0x3BC7 },
	{ 0x4C5E, 0x6A29 },
	{ 0x4C5F, 0x69F9 },
	{ 0x4C60, 0x69EA },
	{ 0x4C61, 0x6A2C },
	{ 0x4C62, 0x6A24 },
	{ 0x4C63, 0x4CB7 },
	{ 0x4C64, 0x69E9 },
	{ 0x4C65, 0x6B52 },
	{ 0x4C66, 0x6B4F },
	{ 0x4C67, 0x6B53 },
	{ 0x4C68, 0x3C43 },
	{ 0x4C69, 0x3CB6 },
	{ 0x4C6A, 0x6F10 },
	{ 0x4C6B, 0x6F65 },
	{ 0x4C6C, 0x6F75 },
	{ 0x4C6D, 0x3D51 },
	{ 0x4C6E, 0x3D4A },
	{ 0x4C6F, 0x3D4D },
	{ 0x4C70, 0x3D56 },
	{ 0x4C71, 0x6FD0 },
	{ 0x4C72, 0x3D53 },
	{ 0x4C73, 0x6F5C },
	{ 0x4C74, 0x6F3D },
	{ 0x4C75, 0x6F71 },
	{ 0x4C76, 0x3D59 },
	{ 0x4C77, 0x6F91 },
	{ 0x4C78, 0x6F0B },
	{ 0x4C79, 0x6F79 },
	{ 0x4C7A, 0x6F81 },
	{ 0x4C7B, 0x6F8F },
	{ 0x4C7C, 0x3D4E },
	{ 0x4C7D, 0x6F59 },
	{ 0x4C7E, 0x6F74 },
	{ 0x4D21, 0x3DEE },
	{ 0x4D22, 0x71AE },
	{ 0x4D23, 0x3DEC },
	{ 0x4D24, 0x71A3 },
	{ 0x4D25, 0x71AD },
	{ 0x4D26, 0x3DEB },
	{ 0x4D27, 0x3DEF },
	{ 0x4D28, 0x71AB },
	{ 0x4D29, 0x71A6 },
	{ 0x4D2A, 0x71A2 },
	{ 0x4D2B, 0x3DED },
	{ 0x4D2C, 0x52F2 },
	{ 0x4D2D, 0x7257 },
	{ 0x4D2E, 0x7255 },
	{ 0x4D2F, 0x7299 },
	{ 0x4D30, 0x734B },
	{ 0x4D31, 0x747A },
	{ 0x4D32, 0x3EF2 },
	{ 0x4D33, 0x3EEF },
	{ 0x4D34, 0x3EF1 },
	{ 0x4D35, 0x748C },
	{ 0x4D36, 0x7484 },
	{ 0x4D37, 0x3EED },
	{ 0x4D38, 0x3EF0 },
	{ 0x4D39, 0x7482 },
	{ 0x4D3A, 0x7493 },
	{ 0x4D3B, 0x747B },
	{ 0x4D3C, 0x3EEE },
	{ 0x4D3D, 0x7509 },
	{ 0x4D3E, 0x4C1B },
	{ 0x4D3F, 0x3F50 },
	{ 0x4D40, 0x3F66 },
	{ 0x4D41, 0x3684 },
	{ 0x4D42, 0x3FB8 },
	{ 0x4D43, 0x3FF6 },
	{ 0x4D44, 0x778A },
	{ 0x4D45, 0x4057 },
	{ 0x4D46, 0x7790 },
	{ 0x4D47, 0x405E },
	{ 0x4D48, 0x78C6 },
	{ 0x4D49, 0x78D3 },
	{ 0x4D4A, 0x78C0 },
	{ 0x4D4B, 0x78D2 },
	{ 0x4D4C, 0x78C7 },
	{ 0x4D4D, 0x78C2 },
	{ 0x4D4E, 0x4119 },
	{ 0x4D4F, 0x799F },
	{ 0x4D50, 0x799D },
	{ 0x4D51, 0x799E },
	{ 0x4D52, 0x4170 },
	{ 0x4D53, 0x7A41 },
	{ 0x4D54, 0x416E },
	{ 0x4D55, 0x7A38 },
	{ 0x4D56, 0x7A3A },
	{ 0x4D57, 0x7A42 },
	{ 0x4D58, 0x4172 },
	{ 0x4D59, 0x4176 },
	{ 0x4D5A, 0x7A3E },
	{ 0x4D5B, 0x7AB0 },
	{ 0x4D5C, 0x7BAE },
	{ 0x4D5D, 0x7BB3 },
	{ 0x4D5E, 0x4212 },
	{ 0x4D5F, 0x421F },
	{ 0x4D60, 0x7BBF },
	{ 0x4D61, 0x4211 },
	{ 0x4D62, 0x4216 },
	{ 0x4D63, 0x7BCD },
	{ 0x4D64, 0x4219 },
	{ 0x4D65, 0x7BB2 },
	{ 0x4D66, 0x4224 },
	{ 0x4D67, 0x4214 },
	{ 0x4D68, 0x4225 },
	{ 0x4D69, 0x4295 },
	{ 0x4D6A, 0x4296 },
	{ 0x4D6B, 0x4293 },
	{ 0x4D6C, 0x4294 },
	{ 0x4D6D, 0x7CC4 },
	{ 0x4D6E, 0x7CCD },
	{ 0x4D6F, 0x7CC2 },
	{ 0x4D70, 0x7CC6 },
	{ 0x4D71, 0x7CC3 },
	{ 0x4D72, 0x7CC9 },
	{ 0x4D73, 0x7CC7 },
	{ 0x4D74, 0x42A0 },
	{ 0x4D75, 0x7DF8 },
	{ 0x4D76, 0x42FB },
	{ 0x4D77, 0x7DED },
	{ 0x4D78, 0x7DE2 },
	{ 0x4D79, 0x42FC },
	{ 0x4D7A, 0x4300 },
	{ 0x4D7B, 0x42F8 },
	{ 0x4D7C, 0x7DDC },
	{ 0x4D7D, 0x7E02 },
	{ 0x4D7E, 0x7E01 },
	{ 0x4E21, 0x42F9 },
	{ 0x4E22, 0x7DD6 },
	{ 0x4E23, 0x4304 },
	{ 0x4E24, 0x7DE4 },
	{ 0x4E25, 0x7DFE },
	{ 0x4E26, 0x4303 },
	{ 0x4E27, 0x7E00 },
	{ 0x4E28, 0x7DFC },
	{ 0x4E29, 0x7DFD },
	{ 0x4E2A, 0x42F3 },
	{ 0x4E2B, 0x7DF5 },
	{ 0x4E2C, 0x7DFF },
	{ 0x4E2D, 0x42FA },
	{ 0x4E2E, 0x7DEB },
	{ 0x4E2F, 0x7DE5 },
	{ 0x4E30, 0x7F78 },
	{ 0x4E31, 0x7FAE },
	{ 0x4E32, 0x7FE7 },
	{ 0x4E33, 0x43BF },
	{ 0x4E34, 0x8065 },
	{ 0x4E35, 0x806A },
	{ 0x4E36, 0x8066 },
	{ 0x4E37, 0x8068 },
	{ 0x4E38, 0x806B },
	{ 0x4E39, 0x8194 },
	{ 0x4E3A, 0x81A1 },
	{ 0x4E3B, 0x8192 },
	{ 0x4E3C, 0x8196 },
	{ 0x4E3D, 0x8193 },
	{ 0x4E3E, 0x4479 },
	{ 0x4E3F, 0x4510 },
	{ 0x4E40, 0x8501 },
	{ 0x4E41, 0x4514 },
	{ 0x4E42, 0x84F8 },
	{ 0x4E43, 0x450E },
	{ 0x4E44, 0x84F5 },
	{ 0x4E45, 0x451A },
	{ 0x4E46, 0x8504 },
	{ 0x4E47, 0x4519 },
	{ 0x4E48, 0x4521 },
	{ 0x4E49, 0x4523 },
	{ 0x4E4A, 0x451F },
	{ 0x4E4B, 0x851B },
	{ 0x4E4C, 0x8503 },
	{ 0x4E4D, 0x8533 },
	{ 0x4E4E, 0x8534 },
	{ 0x4E4F, 0x84ED },
	{ 0x4E50, 0x4525 },
	{ 0x4E51, 0x452B },
	{ 0x4E52, 0x8535 },
	{ 0x4E53, 0x4516 },
	{ 0x4E54, 0x8505 },
	{ 0x4E55, 0x4522 },
	{ 0x4E56, 0x451B },
	{ 0x4E57, 0x45CE },
	{ 0x4E58, 0x45CF },
	{ 0x4E59, 0x877D },
	{ 0x4E5A, 0x45CB },
	{ 0x4E5B, 0x45D1 },
	{ 0x4E5C, 0x45CC },
	{ 0x4E5D, 0x8771 },
	{ 0x4E5E, 0x4617 },
	{ 0x4E5F, 0x885C },
	{ 0x4E60, 0x88E6 },
	{ 0x4E61, 0x890F },
	{ 0x4E62, 0x891B },
	{ 0x4E63, 0x4651 },
	{ 0x4E64, 0x89A9 },
	{ 0x4E65, 0x89A5 },
	{ 0x4E66, 0x89EE },
	{ 0x4E67, 0x8AB1 },
	{ 0x4E68, 0x46ED },
	{ 0x4E69, 0x8ACC },
	{ 0x4E6A, 0x8ACE },
	{ 0x4E6B, 0x46F4 },
	{ 0x4E6C, 0x8AB7 },
	{ 0x4E6D, 0x46F1 },
	{ 0x4E6E, 0x8AB5 },
	{ 0x4E6F, 0x8AE9 },
	{ 0x4E70, 0x8AB4 },
	{ 0x4E71, 0x46F8 },
	{ 0x4E72, 0x8AB3 },
	{ 0x4E73, 0x8AC1 },
	{ 0x4E74, 0x8AAF },
	{ 0x4E75, 0x8ACA },
	{ 0x4E76, 0x8AD0 },
	{ 0x4E77, 0x472F },
	{ 0x4E78, 0x475E },
	{ 0x4E79, 0x475D },
	{ 0x4E7A, 0x8C8E },
	{ 0x4E7B, 0x4776 },
	{ 0x4E7C, 0x4777 },
	{ 0x4E7D, 0x8CE9 },
	{ 0x4E7E, 0x8CDB },
	{ 0x4F21, 0x477E },
	{ 0x4F22, 0x8CEB },
	{ 0x4F23, 0x8DA4 },
	{ 0x4F24, 0x47B6 },
	{ 0x4F25, 0x8DA2 },
	{ 0x4F26, 0x8D9D },
	{ 0x4F27, 0x47B3 },
	{ 0x4F28, 0x47FC },
	{ 0x4F29, 0x4803 },
	{ 0x4F2A, 0x4800 },
	{ 0x4F2B, 0x8E2A },
	{ 0x4F2C, 0x8E28 },
	{ 0x4F2D, 0x480A },
	{ 0x4F2E, 0x4802 },
	{ 0x4F2F, 0x8EB8 },
	{ 0x4F30, 0x8EB6 },
	{ 0x4F31, 0x8EB9 },
	{ 0x4F32, 0x8EB7 },
	{ 0x4F33, 0x8F22 },
	{ 0x4F34, 0x8F2B },
	{ 0x4F35, 0x8F27 },
	{ 0x4F36, 0x8F19 },
	{ 0x4F37, 0x8FA4 },
	{ 0x4F38, 0x4887 },
	{ 0x4F39, 0x8FB3 },
	{ 0x4F3A, 0x48A6 },
	{ 0x4F3B, 0x9071 },
	{ 0x4F3C, 0x906A },
	{ 0x4F3D, 0x48A9 },
	{ 0x4F3E, 0x48DE },
	{ 0x4F3F, 0x9188 },
	{ 0x4F40, 0x918C },
	{ 0x4F41, 0x92BF },
	{ 0x4F42, 0x92B8 },
	{ 0x4F43, 0x92BE },
	{ 0x4F44, 0x92DC },
	{ 0x4F45, 0x92E5 },
	{ 0x4F46, 0x492E },
	{ 0x4F47, 0x492D },
	{ 0x4F48, 0x92D4 },
	{ 0x4F49, 0x92D6 },
	{ 0x4F4A, 0x4930 },
	{ 0x4F4B, 0x92DA },
	{ 0x4F4C, 0x92ED },
	{ 0x4F4D, 0x92F3 },
	{ 0x4F4E, 0x92DB },
	{ 0x4F4F, 0x492B },
	{ 0x4F50, 0x92B9 },
	{ 0x4F51, 0x92E2 },
	{ 0x4F52, 0x92EB },
	{ 0x4F53, 0x95AF },
	{ 0x4F54, 0x499E },
	{ 0x4F55, 0x95B2 },
	{ 0x4F56, 0x95B3 },
	{ 0x4F57, 0x499F },
	{ 0x4F58, 0x49E5 },
	{ 0x4F59, 0x49E4 },
	{ 0x4F5A, 0x96A3 },
	{ 0x4F5B, 0x96A5 },
	{ 0x4F5C, 0x49FD },
	{ 0x4F5D, 0x49FC },
	{ 0x4F5E, 0x4A17 },
	{ 0x4F5F, 0x4A19 },
	{ 0x4F60, 0x970A },
	{ 0x4F61, 0x4A18 },
	{ 0x4F62, 0x9787 },
	{ 0x4F63, 0x9789 },
	{ 0x4F64, 0x978C },
	{ 0x4F65, 0x97EF },
	{ 0x4F66, 0x982A },
	{ 0x4F67, 0x9822 },
	{ 0x4F68, 0x4ABF },
	{ 0x4F69, 0x981F },
	{ 0x4F6A, 0x4B3C },
	{ 0x4F6B, 0x9919 },
	{ 0x4F6C, 0x4B6B },
	{ 0x4F6D, 0x99CA },
	{ 0x4F6E, 0x99DA },
	{ 0x4F6F, 0x4B83 },
	{ 0x4F70, 0x4B81 },
	{ 0x4F71, 0x4B80 },
	{ 0x4F72, 0x99DE },
	{ 0x4F73, 0x99C8 },
	{ 0x4F74, 0x99E0 },
	{ 0x4F75, 0x4BCA },
	{ 0x4F76, 0x9AB6 },
	{ 0x4F77, 0x9AB5 },
	{ 0x4F78, 0x4BCE },
	{ 0x4F79, 0x9AF4 },
	{ 0x4F7A, 0x4BF6 },
	{ 0x4F7B, 0x9B6B },
	{ 0x4F7C, 0x9B69 },
	{ 0x4F7D, 0x9B72 },
	{ 0x4F7E, 0x9B63 },
	{ 0x5021, 0x4C39 },
	{ 0x5022, 0x9D0D },
	{ 0x5023, 0x4CAE },
	{ 0x5024, 0x9D01 },
	{ 0x5025, 0x9D0C },
	{ 0x5026, 0x4CB5 },
	{ 0x5027, 0x9CF8 },
	{ 0x5028, 0x4CB3 },
	{ 0x5029, 0x4CB4 },
	{ 0x502A, 0x9CFE },
	{ 0x502B, 0x9D02 },
	{ 0x502C, 0x9E84 },
	{ 0x502D, 0x4D22 },
	{ 0x502E, 0x9EAB },
	{ 0x502F, 0x9EAA },
	{ 0x5030, 0x511D },
	{ 0x5031, 0x5116 },
	{ 0x5032, 0x3499 },
	{ 0x5033, 0x512B },
	{ 0x5034, 0x511E },
	{ 0x5035, 0x511B },
	{ 0x5036, 0x5290 },
	{ 0x5037, 0x5294 },
	{ 0x5038, 0x5314 },
	{ 0x5039, 0x20B89 },
	{ 0x503A, 0x3602 },
	{ 0x503B, 0x5667 },
	{ 0x503C, 0x3601 },
	{ 0x503D, 0x567B },
	{ 0x503E, 0x36A1 },
	{ 0x503F, 0x565F },
	{ 0x5040, 0x5661 },
	{ 0x5041, 0x35FD },
	{ 0x5042, 0x3673 },
	{ 0x5043, 0x3674 },
	{ 0x5044, 0x3670 },
	{ 0x5045, 0x3676 },
	{ 0x5046, 0x3675 },
	{ 0x5047, 0x3672 },
	{ 0x5048, 0x58C3 },
	{ 0x5049, 0x58CA },
	{ 0x504A, 0x58BB },
	{ 0x504B, 0x58C0 },
	{ 0x504C, 0x58C4 },
	{ 0x504D, 0x5901 },
	{ 0x504E, 0x5B1F },
	{ 0x504F, 0x5B18 },
	{ 0x5050, 0x5B11 },
	{ 0x5051, 0x5B15 },
	{ 0x5052, 0x3729 },
	{ 0x5053, 0x5B12 },
	{ 0x5054, 0x5B1C },
	{ 0x5055, 0x372A },
	{ 0x5056, 0x5B22 },
	{ 0x5057, 0x5B79 },
	{ 0x5058, 0x5DA6 },
	{ 0x5059, 0x3816 },
	{ 0x505A, 0x5DB3 },
	{ 0x505B, 0x5DAB },
	{ 0x505C, 0x5EEA },
	{ 0x505D, 0x3899 },
	{ 0x505E, 0x5F5B },
	{ 0x505F, 0x38D3 },
	{ 0x5060, 0x38F5 },
	{ 0x5061, 0x61B7 },
	{ 0x5062, 0x61CE },
	{ 0x5063, 0x61B9 },
	{ 0x5064, 0x61BD },
	{ 0x5065, 0x61CF },
	{ 0x5066, 0x61C0 },
	{ 0x5067, 0x6199 },
	{ 0x5068, 0x6197 },
	{ 0x5069, 0x3994 },
	{ 0x506A, 0x61BB },
	{ 0x506B, 0x61D0 },
	{ 0x506C, 0x61C4 },
	{ 0x506D, 0x6231 },
	{ 0x506E, 0x3A56 },
	{ 0x506F, 0x64D3 },
	{ 0x5070, 0x64C0 },
	{ 0x5071, 0x3A59 },
	{ 0x5072, 0x3A58 },
	{ 0x5073, 0x3A55 },
	{ 0x5074, 0x3A52 },
	{ 0x5075, 0x64DC },
	{ 0x5076, 0x64D1 },
	{ 0x5077, 0x64C8 },
	{ 0x5078, 0x3A57 },
	{ 0x5079, 0x64D5 },
	{ 0x507A, 0x66C3 },
	{ 0x507B, 0x3B1B },
	{ 0x507C, 0x3B1C },
	{ 0x507D, 0x66BF },
	{ 0x507E, 0x66C5 },
	{ 0x5121, 0x3B19 },
	{ 0x5122, 0x66CD },
	{ 0x5123, 0x66C1 },
	{ 0x5124, 0x6706 },
	{ 0x5125, 0x3B3F },
	{ 0x5126, 0x6724 },
	{ 0x5127, 0x6A63 },
	{ 0x5128, 0x6A42 },
	{ 0x5129, 0x6A52 },
	{ 0x512A, 0x3BDB },
	{ 0x512B, 0x6A43 },
	{ 0x512C, 0x6A33 },
	{ 0x512D, 0x3BE2 },
	{ 0x512E, 0x6A6C },
	{ 0x512F, 0x6A57 },
	{ 0x5130, 0x3BD7 },
	{ 0x5131, 0x6A4C },
	{ 0x5132, 0x6A6E },
	{ 0x5133, 0x3BDE },
	{ 0x5134, 0x3BE5 },
	{ 0x5135, 0x3BE4 },
	{ 0x5136, 0x3BE6 },
	{ 0x5137, 0x3BD6 },
	{ 0x5138, 0x6A37 },
	{ 0x5139, 0x3BDF },
	{ 0x513A, 0x6A71 },
	{ 0x513B, 0x6A4A },
	{ 0x513C, 0x6A36 },
	{ 0x513D, 0x3BDC },
	{ 0x513E, 0x6A53 },
	{ 0x513F, 0x3BDA },
	{ 0x5140, 0x6A45 },
	{ 0x5141, 0x6A70 },
	{ 0x5142, 0x3BD3 },
	{ 0x5143, 0x3BD0 },
	{ 0x5144, 0x6A5C },
	{ 0x5145, 0x6B58 },
	{ 0x5146, 0x6B57 },
	{ 0x5147, 0x3C86 },
	{ 0x5148, 0x3C87 },
	{ 0x5149, 0x3CAD },
	{ 0x514A, 0x3CB7 },
	{ 0x514B, 0x3D58 },
	{ 0x514C, 0x3D6A },
	{ 0x514D, 0x6FBB },
	{ 0x514E, 0x3D62 },
	{ 0x514F, 0x3D61 },
	{ 0x5150, 0x6FBE },
	{ 0x5151, 0x3D69 },
	{ 0x5152, 0x3D6C },
	{ 0x5153, 0x3D65 },
	{ 0x5154, 0x6FB5 },
	{ 0x5155, 0x6FD3 },
	{ 0x5156, 0x6F9F },
	{ 0x5157, 0x3D66 },
	{ 0x5158, 0x6FB7 },
	{ 0x5159, 0x6FF5 },
	{ 0x515A, 0x71B7 },
	{ 0x515B, 0x3DF5 },
	{ 0x515C, 0x71BB },
	{ 0x515D, 0x3DF4 },
	{ 0x515E, 0x71D1 },
	{ 0x515F, 0x3DF7 },
	{ 0x5160, 0x71BA },
	{ 0x5161, 0x3DF8 },
	{ 0x5162, 0x71B6 },
	{ 0x5163, 0x71CC },
	{ 0x5164, 0x3DFB },
	{ 0x5165, 0x3DFC },
	{ 0x5166, 0x71D3 },
	{ 0x5167, 0x749B },
	{ 0x5168, 0x3EF5 },
	{ 0x5169, 0x3EF8 },
	{ 0x516A, 0x7496 },
	{ 0x516B, 0x74A2 },
	{ 0x516C, 0x749D },
	{ 0x516D, 0x750A },
	{ 0x516E, 0x750E },
	{ 0x516F, 0x3F3C },
	{ 0x5170, 0x7581 },
	{ 0x5171, 0x762C },
	{ 0x5172, 0x7637 },
	{ 0x5173, 0x7636 },
	{ 0x5174, 0x763B },
	{ 0x5175, 0x3FC5 },
	{ 0x5176, 0x76A1 },
	{ 0x5177, 0x4062 },
	{ 0x5178, 0x4063 },
	{ 0x5179, 0x7798 },
	{ 0x517A, 0x4067 },
	{ 0x517B, 0x7796 },
	{ 0x517C, 0x4066 },
	{ 0x517D, 0x40D9 },
	{ 0x517E, 0x40DB },
	{ 0x5221, 0x78D6 },
	{ 0x5222, 0x78EB },
	{ 0x5223, 0x40D8 },
	{ 0x5224, 0x78DC },
	{ 0x5225, 0x411B },
	{ 0x5226, 0x79A5 },
	{ 0x5227, 0x79A9 },
	{ 0x5228, 0x9834 },
	{ 0x5229, 0x7A53 },
	{ 0x522A, 0x7A45 },
	{ 0x522B, 0x4179 },
	{ 0x522C, 0x7A4F },
	{ 0x522D, 0x417D },
	{ 0x522E, 0x7ABD },
	{ 0x522F, 0x7ABB },
	{ 0x5230, 0x7AF1 },
	{ 0x5231, 0x422C },
	{ 0x5232, 0x4237 },
	{ 0x5233, 0x7BEC },
	{ 0x5234, 0x7BED },
	{ 0x5235, 0x4230 },
	{ 0x5236, 0x429A },
	{ 0x5237, 0x7CD3 },
	{ 0x5238, 0x4A00 },
	{ 0x5239, 0x7CE1 },
	{ 0x523A, 0x4305 },
	{ 0x523B, 0x7E19 },
	{ 0x523C, 0x4307 },
	{ 0x523D, 0x4309 },
	{ 0x523E, 0x430A },
	{ 0x523F, 0x7E27 },
	{ 0x5240, 0x7E26 },
	{ 0x5241, 0x4379 },
	{ 0x5242, 0x43C2 },
	{ 0x5243, 0x806E },
	{ 0x5244, 0x81AF },
	{ 0x5245, 0x4438 },
	{ 0x5246, 0x4437 },
	{ 0x5247, 0x81AD },
	{ 0x5248, 0x4421 },
	{ 0x5249, 0x81AA },
	{ 0x524A, 0x8218 },
	{ 0x524B, 0x445E },
	{ 0x524C, 0x453D },
	{ 0x524D, 0x4537 },
	{ 0x524E, 0x4540 },
	{ 0x524F, 0x856F },
	{ 0x5250, 0x854C },
	{ 0x5251, 0x451D },
	{ 0x5252, 0x8542 },
	{ 0x5253, 0x4533 },
	{ 0x5254, 0x855C },
	{ 0x5255, 0x8570 },
	{ 0x5256, 0x855F },
	{ 0x5257, 0x4535 },
	{ 0x5258, 0x855A },
	{ 0x5259, 0x854B },
	{ 0x525A, 0x853F },
	{ 0x525B, 0x878A },
	{ 0x525C, 0x45D8 },
	{ 0x525D, 0x878B },
	{ 0x525E, 0x87A1 },
	{ 0x525F, 0x878E },
	{ 0x5260, 0x45DC },
	{ 0x5261, 0x45DE },
	{ 0x5262, 0x8799 },
	{ 0x5263, 0x885E },
	{ 0x5264, 0x885F },
	{ 0x5265, 0x8924 },
	{ 0x5266, 0x89A7 },
	{ 0x5267, 0x8AEA },
	{ 0x5268, 0x8AFD },
	{ 0x5269, 0x8AF9 },
	{ 0x526A, 0x8AE3 },
	{ 0x526B, 0x8AE5 },
	{ 0x526C, 0x46FA },
	{ 0x526D, 0x46FB },
	{ 0x526E, 0x8AEC },
	{ 0x526F, 0x473D },
	{ 0x5270, 0x473B },
	{ 0x5271, 0x473F },
	{ 0x5272, 0x475F },
	{ 0x5273, 0x8CF2 },
	{ 0x5274, 0x477F },
	{ 0x5275, 0x8CEF },
	{ 0x5276, 0x4784 },
	{ 0x5277, 0x8DA6 },
	{ 0x5278, 0x47BC },
	{ 0x5279, 0x4814 },
	{ 0x527A, 0x480F },
	{ 0x527B, 0x8E3B },
	{ 0x527C, 0x8E43 },
	{ 0x527D, 0x480E },
	{ 0x527E, 0x8E32 },
	{ 0x5321, 0x8F31 },
	{ 0x5322, 0x8F30 },
	{ 0x5323, 0x4860 },
	{ 0x5324, 0x8F2D },
	{ 0x5325, 0x8F3C },
	{ 0x5326, 0x8FA7 },
	{ 0x5327, 0x8FA5 },
	{ 0x5328, 0x48AB },
	{ 0x5329, 0x48AC },
	{ 0x532A, 0x48AA },
	{ 0x532B, 0x9137 },
	{ 0x532C, 0x9195 },
	{ 0x532D, 0x918E },
	{ 0x532E, 0x4904 },
	{ 0x532F, 0x9196 },
	{ 0x5330, 0x4908 },
	{ 0x5331, 0x9345 },
	{ 0x5332, 0x930A },
	{ 0x5333, 0x4933 },
	{ 0x5334, 0x4934 },
	{ 0x5335, 0x92FD },
	{ 0x5336, 0x9317 },
	{ 0x5337, 0x931C },
	{ 0x5338, 0x9307 },
	{ 0x5339, 0x9331 },
	{ 0x533A, 0x9332 },
	{ 0x533B, 0x932C },
	{ 0x533C, 0x9330 },
	{ 0x533D, 0x9303 },
	{ 0x533E, 0x9305 },
	{ 0x533F, 0x49A2 },
	{ 0x5340, 0x95C2 },
	{ 0x5341, 0x49A4 },
	{ 0x5342, 0x95B8 },
	{ 0x5343, 0x49A5 },
	{ 0x5344, 0x95C1 },
	{ 0x5345, 0x49A7 },
	{ 0x5346, 0x49A6 },
	{ 0x5347, 0x49E7 },
	{ 0x5348, 0x96AB },
	{ 0x5349, 0x96B7 },
	{ 0x534A, 0x49FF },
	{ 0x534B, 0x49FE },
	{ 0x534C, 0x9715 },
	{ 0x534D, 0x9714 },
	{ 0x534E, 0x4A1D },
	{ 0x534F, 0x4A1C },
	{ 0x5350, 0x970C },
	{ 0x5351, 0x9717 },
	{ 0x5352, 0x4A67 },
	{ 0x5353, 0x9793 },
	{ 0x5354, 0x4A94 },
	{ 0x5355, 0x97D2 },
	{ 0x5356, 0x4AC5 },
	{ 0x5357, 0x4AC8 },
	{ 0x5358, 0x9836 },
	{ 0x5359, 0x9831 },
	{ 0x535A, 0x9833 },
	{ 0x535B, 0x983C },
	{ 0x535C, 0x982E },
	{ 0x535D, 0x983A },
	{ 0x535E, 0x4AC9 },
	{ 0x535F, 0x983D },
	{ 0x5360, 0x4AC7 },
	{ 0x5361, 0x98B5 },
	{ 0x5362, 0x9922 },
	{ 0x5363, 0x9923 },
	{ 0x5364, 0x9920 },
	{ 0x5365, 0x991C },
	{ 0x5366, 0x991D },
	{ 0x5367, 0x4B6C },
	{ 0x5368, 0x99A0 },
	{ 0x5369, 0x4B8A },
	{ 0x536A, 0x99EF },
	{ 0x536B, 0x99E8 },
	{ 0x536C, 0x99EB },
	{ 0x536D, 0x4B88 },
	{ 0x536E, 0x4B87 },
	{ 0x536F, 0x4B86 },
	{ 0x5370, 0x99E1 },
	{ 0x5371, 0x99E6 },
	{ 0x5372, 0x4BCF },
	{ 0x5373, 0x4BD0 },
	{ 0x5374, 0x9AF8 },
	{ 0x5375, 0x9AF5 },
	{ 0x5376, 0x4C1C },
	{ 0x5377, 0x4C23 },
	{ 0x5378, 0x9B83 },
	{ 0x5379, 0x9B94 },
	{ 0x537A, 0x9B84 },
	{ 0x537B, 0x4C49 },
	{ 0x537C, 0x9B8B },
	{ 0x537D, 0x9B8F },
	{ 0x537E, 0x4C43 },
	{ 0x5421, 0x9B8C },
	{ 0x5422, 0x4C48 },
	{ 0x5423, 0x9B89 },
	{ 0x5424, 0x4C47 },
	{ 0x5425, 0x9B8E },
	{ 0x5426, 0x4C46 },
	{ 0x5427, 0x4C3F },
	{ 0x5428, 0x4C44 },
	{ 0x5429, 0x9D24 },
	{ 0x542A, 0x9D0F },
	{ 0x542B, 0x4CBE },
	{ 0x542C, 0x9D13 },
	{ 0x542D, 0x9D0A },
	{ 0x542E, 0x4CC2 },
	{ 0x542F, 0x4CBA },
	{ 0x5430, 0x4CBC },
	{ 0x5431, 0x4CC6 },
	{ 0x5432, 0x9D2A },
	{ 0x5433, 0x9D1A },
	{ 0x5434, 0x4CC8 },
	{ 0x5435, 0x9D27 },
	{ 0x5436, 0x9D16 },
	{ 0x5437, 0x9D21 },
	{ 0x5438, 0x4D23 },
	{ 0x5439, 0x9E85 },
	{ 0x543A, 0x9EAC },
	{ 0x543B, 0x9EC6 },
	{ 0x543C, 0x9EC5 },
	{ 0x543D, 0x9ED7 },
	{ 0x543E, 0x9F53 },
	{ 0x543F, 0x349D },
	{ 0x5440, 0x5128 },
	{ 0x5441, 0x5127 },
	{ 0x5442, 0x51DF },
	{ 0x5443, 0x3524 },
	{ 0x5444, 0x5335 },
	{ 0x5445, 0x53B3 },
	{ 0x5446, 0x3607 },
	{ 0x5447, 0x568A },
	{ 0x5448, 0x567D },
	{ 0x5449, 0x5689 },
	{ 0x544A, 0x3679 },
	{ 0x544B, 0x58CD },
	{ 0x544C, 0x58D0 },
	{ 0x544D, 0x3678 },
	{ 0x544E, 0x5B2B },
	{ 0x544F, 0x5B33 },
	{ 0x5450, 0x5B29 },
	{ 0x5451, 0x5B35 },
	{ 0x5452, 0x5B31 },
	{ 0x5453, 0x5B37 },
	{ 0x5454, 0x5C36 },
	{ 0x5455, 0x5DBE },
	{ 0x5456, 0x3819 },
	{ 0x5457, 0x5DB9 },
	{ 0x5458, 0x381C },
	{ 0x5459, 0x5DBB },
	{ 0x545A, 0x3818 },
	{ 0x545B, 0x61E2 },
	{ 0x545C, 0x61DB },
	{ 0x545D, 0x61DD },
	{ 0x545E, 0x61DC },
	{ 0x545F, 0x61DA },
	{ 0x5460, 0x2F8AF },
	{ 0x5461, 0x61D9 },
	{ 0x5462, 0x39BD },
	{ 0x5463, 0x3A5D },
	{ 0x5464, 0x64DF },
	{ 0x5465, 0x3A5A },
	{ 0x5466, 0x3A5E },
	{ 0x5467, 0x64E1 },
	{ 0x5468, 0x3A5C },
	{ 0x5469, 0x64EE },
	{ 0x546A, 0x3A5B },
	{ 0x546B, 0x65B5 },
	{ 0x546C, 0x66D4 },
	{ 0x546D, 0x66D5 },
	{ 0x546E, 0x3B21 },
	{ 0x546F, 0x66D0 },
	{ 0x5470, 0x66D1 },
	{ 0x5471, 0x66CE },
	{ 0x5472, 0x66D7 },
	{ 0x5473, 0x3B20 },
	{ 0x5474, 0x3B32 },
	{ 0x5475, 0x6A7D },
	{ 0x5476, 0x6A8A },
	{ 0x5477, 0x3BF2 },
	{ 0x5478, 0x6AA7 },
	{ 0x5479, 0x3BF5 },
	{ 0x547A, 0x6A99 },
	{ 0x547B, 0x6A82 },
	{ 0x547C, 0x6A88 },
	{ 0x547D, 0x3BEE },
	{ 0x547E, 0x3BEC },
	{ 0x5521, 0x6A86 },
	{ 0x5522, 0x3BEA },
	{ 0x5523, 0x6A98 },
	{ 0x5524, 0x6A9D },
	{ 0x5525, 0x3BED },
	{ 0x5526, 0x3BF3 },
	{ 0x5527, 0x6A8F },
	{ 0x5528, 0x3BF6 },
	{ 0x5529, 0x6AAA },
	{ 0x552A, 0x3C48 },
	{ 0x552B, 0x6B5D },
	{ 0x552C, 0x3C49 },
	{ 0x552D, 0x6C0A },
	{ 0x552E, 0x3D75 },
	{ 0x552F, 0x6FD7 },
	{ 0x5530, 0x6FD6 },
	{ 0x5531, 0x6FE5 },
	{ 0x5532, 0x3D6F },
	{ 0x5533, 0x3D7B },
	{ 0x5534, 0x3D73 },
	{ 0x5535, 0x6FD9 },
	{ 0x5536, 0x6FDA },
	{ 0x5537, 0x6FEA },
	{ 0x5538, 0x3D70 },
	{ 0x5539, 0x6FF6 },
	{ 0x553A, 0x24039 },
	{ 0x553B, 0x3D78 },
	{ 0x553C, 0x71E3 },
	{ 0x553D, 0x3DFE },
	{ 0x553E, 0x71E9 },
	{ 0x553F, 0x3E00 },
	{ 0x5540, 0x71EB },
	{ 0x5541, 0x71EF },
	{ 0x5542, 0x71F3 },
	{ 0x5543, 0x71EA },
	{ 0x5544, 0x3E01 },
	{ 0x5545, 0x2F921 },
	{ 0x5546, 0x3E55 },
	{ 0x5547, 0x3E56 },
	{ 0x5548, 0x3E9D },
	{ 0x5549, 0x7371 },
	{ 0x554A, 0x3EF9 },
	{ 0x554B, 0x74AE },
	{ 0x554C, 0x3EFF },
	{ 0x554D, 0x74B3 },
	{ 0x554E, 0x3EFD },
	{ 0x554F, 0x74AC },
	{ 0x5550, 0x3F43 },
	{ 0x5551, 0x3F41 },
	{ 0x5552, 0x7583 },
	{ 0x5553, 0x7645 },
	{ 0x5554, 0x764E },
	{ 0x5555, 0x7644 },
	{ 0x5556, 0x76A3 },
	{ 0x5557, 0x76A5 },
	{ 0x5558, 0x77A6 },
	{ 0x5559, 0x77A4 },
	{ 0x555A, 0x406F },
	{ 0x555B, 0x77A9 },
	{ 0x555C, 0x77AF },
	{ 0x555D, 0x408A },
	{ 0x555E, 0x40E5 },
	{ 0x555F, 0x40E6 },
	{ 0x5560, 0x78F0 },
	{ 0x5561, 0x78F8 },
	{ 0x5562, 0x78F1 },
	{ 0x5563, 0x417F },
	{ 0x5564, 0x7A49 },
	{ 0x5565, 0x41B5 },
	{ 0x5566, 0x41B6 },
	{ 0x5567, 0x41BB },
	{ 0x5568, 0x7AC2 },
	{ 0x5569, 0x7AF2 },
	{ 0x556A, 0x7AF3 },
	{ 0x556B, 0x7BFA },
	{ 0x556C, 0x4240 },
	{ 0x556D, 0x7BF6 },
	{ 0x556E, 0x7BFC },
	{ 0x556F, 0x7C18 },
	{ 0x5570, 0x7C08 },
	{ 0x5571, 0x7C12 },
	{ 0x5572, 0x429D },
	{ 0x5573, 0x429C },
	{ 0x5574, 0x7CDB },
	{ 0x5575, 0x7CDA },
	{ 0x5576, 0x430F },
	{ 0x5577, 0x4311 },
	{ 0x5578, 0x430D },
	{ 0x5579, 0x7E2C },
	{ 0x557A, 0x7E4D },
	{ 0x557B, 0x4314 },
	{ 0x557C, 0x4313 },
	{ 0x557D, 0x7F46 },
	{ 0x557E, 0x7FF6 },
	{ 0x5621, 0x802B },
	{ 0x5622, 0x8074 },
	{ 0x5623, 0x81B8 },
	{ 0x5624, 0x81C8 },
	{ 0x5625, 0x4482 },
	{ 0x5626, 0x4483 },
	{ 0x5627, 0x454D },
	{ 0x5628, 0x8592 },
	{ 0x5629, 0x8593 },
	{ 0x562A, 0x454F },
	{ 0x562B, 0x857F },
	{ 0x562C, 0x85AB },
	{ 0x562D, 0x8597 },
	{ 0x562E, 0x454C },
	{ 0x562F, 0x4551 },
	{ 0x5630, 0x85AC },
	{ 0x5631, 0x45EE },
	{ 0x5632, 0x45E8 },
	{ 0x5633, 0x4CCB },
	{ 0x5634, 0x87CE },
	{ 0x5635, 0x45EB },
	{ 0x5636, 0x87CD },
	{ 0x5637, 0x45E2 },
	{ 0x5638, 0x45E6 },
	{ 0x5639, 0x87C1 },
	{ 0x563A, 0x87B1 },
	{ 0x563B, 0x87C7 },
	{ 0x563C, 0x45EC },
	{ 0x563D, 0x8940 },
	{ 0x563E, 0x4659 },
	{ 0x563F, 0x893F },
	{ 0x5640, 0x8939 },
	{ 0x5641, 0x465D },
	{ 0x5642, 0x8943 },
	{ 0x5643, 0x4657 },
	{ 0x5644, 0x465B },
	{ 0x5645, 0x4656 },
	{ 0x5646, 0x89AB },
	{ 0x5647, 0x46FE },
	{ 0x5648, 0x8B1F },
	{ 0x5649, 0x8B09 },
	{ 0x564A, 0x8B0C },
	{ 0x564B, 0x4700 },
	{ 0x564C, 0x4701 },
	{ 0x564D, 0x8C40 },
	{ 0x564E, 0x4742 },
	{ 0x564F, 0x8C96 },
	{ 0x5650, 0x4760 },
	{ 0x5651, 0x8CF6 },
	{ 0x5652, 0x8CF7 },
	{ 0x5653, 0x481D },
	{ 0x5654, 0x8E46 },
	{ 0x5655, 0x8E4F },
	{ 0x5656, 0x483E },
	{ 0x5657, 0x4869 },
	{ 0x5658, 0x4865 },
	{ 0x5659, 0x8F3D },
	{ 0x565A, 0x8F41 },
	{ 0x565B, 0x9366 },
	{ 0x565C, 0x9378 },
	{ 0x565D, 0x935D },
	{ 0x565E, 0x9369 },
	{ 0x565F, 0x9374 },
	{ 0x5660, 0x937D },
	{ 0x5661, 0x936E },
	{ 0x5662, 0x9372 },
	{ 0x5663, 0x9373 },
	{ 0x5664, 0x9362 },
	{ 0x5665, 0x9348 },
	{ 0x5666, 0x9353 },
	{ 0x5667, 0x935F },
	{ 0x5668, 0x9368 },
	{ 0x5669, 0x4938 },
	{ 0x566A, 0x937F },
	{ 0x566B, 0x936B },
	{ 0x566C, 0x49AE },
	{ 0x566D, 0x95C4 },
	{ 0x566E, 0x49AD },
	{ 0x566F, 0x96AF },
	{ 0x5670, 0x96AD },
	{ 0x5671, 0x96B2 },
	{ 0x5672, 0x4A02 },
	{ 0x5673, 0x4A1F },
	{ 0x5674, 0x971A },
	{ 0x5675, 0x971B },
	{ 0x5676, 0x4A22 },
	{ 0x5677, 0x4A20 },
	{ 0x5678, 0x2F9F5 },
	{ 0x5679, 0x4A6C },
	{ 0x567A, 0x979B },
	{ 0x567B, 0x979F },
	{ 0x567C, 0x4A68 },
	{ 0x567D, 0x4A6D },
	{ 0x567E, 0x4A6E },
	{ 0x5721, 0x4AA0 },
	{ 0x5722, 0x4ACE },
	{ 0x5723, 0x4AD0 },
	{ 0x5724, 0x4AD1 },
	{ 0x5725, 0x4ACB },
	{ 0x5726, 0x9840 },
	{ 0x5727, 0x4AD2 },
	{ 0x5728, 0x9847 },
	{ 0x5729, 0x4AD3 },
	{ 0x572A, 0x98B7 },
	{ 0x572B, 0x4B20 },
	{ 0x572C, 0x4B4E },
	{ 0x572D, 0x4B4B },
	{ 0x572E, 0x4B72 },
	{ 0x572F, 0x4B70 },
	{ 0x5730, 0x99A2 },
	{ 0x5731, 0x4B92 },
	{ 0x5732, 0x4B8F },
	{ 0x5733, 0x9A00 },
	{ 0x5734, 0x99F3 },
	{ 0x5735, 0x4B90 },
	{ 0x5736, 0x29937 },
	{ 0x5737, 0x99F5 },
	{ 0x5738, 0x4BD9 },
	{ 0x5739, 0x4BD5 },
	{ 0x573A, 0x9ABD },
	{ 0x573B, 0x9B00 },
	{ 0x573C, 0x9B02 },
	{ 0x573D, 0x4BFA },
	{ 0x573E, 0x9B34 },
	{ 0x573F, 0x9B49 },
	{ 0x5740, 0x9B9F },
	{ 0x5741, 0x4C4B },
	{ 0x5742, 0x9BA3 },
	{ 0x5743, 0x9BCD },
	{ 0x5744, 0x9B99 },
	{ 0x5745, 0x9B9D },
	{ 0x5746, 0x4CD0 },
	{ 0x5747, 0x4CCE },
	{ 0x5748, 0x9D39 },
	{ 0x5749, 0x4CCF },
	{ 0x574A, 0x9D44 },
	{ 0x574B, 0x4CC4 },
	{ 0x574C, 0x4CCC },
	{ 0x574D, 0x9D35 },
	{ 0x574E, 0x4CD2 },
	{ 0x574F, 0x4D35 },
	{ 0x5750, 0x9EAF },
	{ 0x5751, 0x3E03 },
	{ 0x5752, 0x512F },
	{ 0x5753, 0x349E },
	{ 0x5754, 0x34AF },
	{ 0x5755, 0x9F8E },
	{ 0x5756, 0x360C },
	{ 0x5757, 0x569F },
	{ 0x5758, 0x569B },
	{ 0x5759, 0x569E },
	{ 0x575A, 0x5696 },
	{ 0x575B, 0x5694 },
	{ 0x575C, 0x56A0 },
	{ 0x575D, 0x367C },
	{ 0x575E, 0x5B3B },
	{ 0x575F, 0x3730 },
	{ 0x5760, 0x3731 },
	{ 0x5761, 0x5B3A },
	{ 0x5762, 0x5DC1 },
	{ 0x5763, 0x5F4D },
	{ 0x5764, 0x5F5D },
	{ 0x5765, 0x61F3 },
	{ 0x5766, 0x39A1 },
	{ 0x5767, 0x399E },
	{ 0x5768, 0x3A68 },
	{ 0x5769, 0x3A61 },
	{ 0x576A, 0x64F6 },
	{ 0x576B, 0x64E5 },
	{ 0x576C, 0x64EA },
	{ 0x576D, 0x64E7 },
	{ 0x576E, 0x6505 },
	{ 0x576F, 0x3A65 },
	{ 0x5770, 0x64F9 },
	{ 0x5771, 0x3A66 },
	{ 0x5772, 0x3A6A },
	{ 0x5773, 0x3AAB },
	{ 0x5774, 0x6AAB },
	{ 0x5775, 0x6AED },
	{ 0x5776, 0x6AB2 },
	{ 0x5777, 0x6AB0 },
	{ 0x5778, 0x6AB5 },
	{ 0x5779, 0x6ABE },
	{ 0x577A, 0x6AC1 },
	{ 0x577B, 0x6AC8 },
	{ 0x577C, 0x3BF9 },
	{ 0x577D, 0x6AC0 },
	{ 0x577E, 0x6ABC },
	{ 0x5821, 0x6AB1 },
	{ 0x5822, 0x6AC4 },
	{ 0x5823, 0x6ABF },
	{ 0x5824, 0x3C58 },
	{ 0x5825, 0x3C8A },
	{ 0x5826, 0x7008 },
	{ 0x5827, 0x7003 },
	{ 0x5828, 0x6FFD },
	{ 0x5829, 0x7010 },
	{ 0x582A, 0x7002 },
	{ 0x582B, 0x7013 },
	{ 0x582C, 0x3E04 },
	{ 0x582D, 0x71FA },
	{ 0x582E, 0x7200 },
	{ 0x582F, 0x74B9 },
	{ 0x5830, 0x74BC },
	{ 0x5831, 0x3F02 },
	{ 0x5832, 0x765B },
	{ 0x5833, 0x7651 },
	{ 0x5834, 0x764F },
	{ 0x5835, 0x76EB },
	{ 0x5836, 0x77B8 },
	{ 0x5837, 0x4079 },
	{ 0x5838, 0x77B9 },
	{ 0x5839, 0x77C1 },
	{ 0x583A, 0x77C0 },
	{ 0x583B, 0x77BE },
	{ 0x583C, 0x790B },
	{ 0x583D, 0x40EB },
	{ 0x583E, 0x7907 },
	{ 0x583F, 0x790A },
	{ 0x5840, 0x7908 },
	{ 0x5841, 0x40E9 },
	{ 0x5842, 0x790D },
	{ 0x5843, 0x7906 },
	{ 0x5844, 0x7915 },
	{ 0x5845, 0x79AF },
	{ 0x5846, 0x4120 },
	{ 0x5847, 0x4121 },
	{ 0x5848, 0x4181 },
	{ 0x5849, 0x7AF5 },
	{ 0x584A, 0x424D },
	{ 0x584B, 0x4259 },
	{ 0x584C, 0x7C2E },
	{ 0x584D, 0x4258 },
	{ 0x584E, 0x7C1B },
	{ 0x584F, 0x25CD1 },
	{ 0x5850, 0x7C1A },
	{ 0x5851, 0x7C24 },
	{ 0x5852, 0x42A5 },
	{ 0x5853, 0x42A9 },
	{ 0x5854, 0x7CE6 },
	{ 0x5855, 0x7CE3 },
	{ 0x5856, 0x431A },
	{ 0x5857, 0x4319 },
	{ 0x5858, 0x7E5D },
	{ 0x5859, 0x7E4F },
	{ 0x585A, 0x7E66 },
	{ 0x585B, 0x7E5B },
	{ 0x585C, 0x7F47 },
	{ 0x585D, 0x7FB4 },
	{ 0x585E, 0x4396 },
	{ 0x585F, 0x4398 },
	{ 0x5860, 0x4397 },
	{ 0x5861, 0x7FFA },
	{ 0x5862, 0x802E },
	{ 0x5863, 0x265DF },
	{ 0x5864, 0x43C8 },
	{ 0x5865, 0x81CE },
	{ 0x5866, 0x4443 },
	{ 0x5867, 0x4445 },
	{ 0x5868, 0x8219 },
	{ 0x5869, 0x4552 },
	{ 0x586A, 0x4557 },
	{ 0x586B, 0x85CC },
	{ 0x586C, 0x85B2 },
	{ 0x586D, 0x4555 },
	{ 0x586E, 0x85BB },
	{ 0x586F, 0x85C1 },
	{ 0x5870, 0x4556 },
	{ 0x5871, 0x4558 },
	{ 0x5872, 0x45F2 },
	{ 0x5873, 0x87E9 },
	{ 0x5874, 0x87EE },
	{ 0x5875, 0x87F0 },
	{ 0x5876, 0x87D6 },
	{ 0x5877, 0x880E },
	{ 0x5878, 0x87DA },
	{ 0x5879, 0x8948 },
	{ 0x587A, 0x894A },
	{ 0x587B, 0x894E },
	{ 0x587C, 0x894D },
	{ 0x587D, 0x89B1 },
	{ 0x587E, 0x89B0 },
	{ 0x5921, 0x89B3 },
	{ 0x5922, 0x4707 },
	{ 0x5923, 0x8B38 },
	{ 0x5924, 0x8B32 },
	{ 0x5925, 0x4708 },
	{ 0x5926, 0x8B2D },
	{ 0x5927, 0x470A },
	{ 0x5928, 0x8B34 },
	{ 0x5929, 0x431B },
	{ 0x592A, 0x8B29 },
	{ 0x592B, 0x8C74 },
	{ 0x592C, 0x4761 },
	{ 0x592D, 0x4762 },
	{ 0x592E, 0x8D03 },
	{ 0x592F, 0x47C2 },
	{ 0x5930, 0x47C6 },
	{ 0x5931, 0x8DA9 },
	{ 0x5932, 0x8E58 },
	{ 0x5933, 0x481E },
	{ 0x5934, 0x4825 },
	{ 0x5935, 0x8EBF },
	{ 0x5936, 0x8EC1 },
	{ 0x5937, 0x8F4A },
	{ 0x5938, 0x8FAC },
	{ 0x5939, 0x48B0 },
	{ 0x593A, 0x9089 },
	{ 0x593B, 0x913D },
	{ 0x593C, 0x913C },
	{ 0x593D, 0x91A9 },
	{ 0x593E, 0x93A0 },
	{ 0x593F, 0x493D },
	{ 0x5940, 0x9390 },
	{ 0x5941, 0x493E },
	{ 0x5942, 0x9393 },
	{ 0x5943, 0x938B },
	{ 0x5944, 0x93AD },
	{ 0x5945, 0x93BB },
	{ 0x5946, 0x93B8 },
	{ 0x5947, 0x4946 },
	{ 0x5948, 0x4945 },
	{ 0x5949, 0x939C },
	{ 0x594A, 0x95D8 },
	{ 0x594B, 0x95D7 },
	{ 0x594C, 0x4A03 },
	{ 0x594D, 0x4A26 },
	{ 0x594E, 0x4A27 },
	{ 0x594F, 0x975D },
	{ 0x5950, 0x97A9 },
	{ 0x5951, 0x97DA },
	{ 0x5952, 0x4A98 },
	{ 0x5953, 0x4AAD },
	{ 0x5954, 0x4AD5 },
	{ 0x5955, 0x4ADA },
	{ 0x5956, 0x9854 },
	{ 0x5957, 0x4AD9 },
	{ 0x5958, 0x9855 },
	{ 0x5959, 0x984B },
	{ 0x595A, 0x4ADD },
	{ 0x595B, 0x983F },
	{ 0x595C, 0x98B9 },
	{ 0x595D, 0x4B15 },
	{ 0x595E, 0x4B16 },
	{ 0x595F, 0x4B17 },
	{ 0x5960, 0x4B21 },
	{ 0x5961, 0x9938 },
	{ 0x5962, 0x9936 },
	{ 0x5963, 0x9940 },
	{ 0x5964, 0x4B4C },
	{ 0x5965, 0x993B },
	{ 0x5966, 0x9939 },
	{ 0x5967, 0x99A4 },
	{ 0x5968, 0x4B96 },
	{ 0x5969, 0x4B98 },
	{ 0x596A, 0x9A08 },
	{ 0x596B, 0x9A0C },
	{ 0x596C, 0x4B9B },
	{ 0x596D, 0x9A10 },
	{ 0x596E, 0x4BFF },
	{ 0x596F, 0x9B07 },
	{ 0x5970, 0x4C25 },
	{ 0x5971, 0x9BD2 },
	{ 0x5972, 0x4C4F },
	{ 0x5973, 0x9BC2 },
	{ 0x5974, 0x9BBB },
	{ 0x5975, 0x9BCC },
	{ 0x5976, 0x9BCB },
	{ 0x5977, 0x4C56 },
	{ 0x5978, 0x4C54 },
	{ 0x5979, 0x9D4D },
	{ 0x597A, 0x9D63 },
	{ 0x597B, 0x9D4E },
	{ 0x597C, 0x4CD8 },
	{ 0x597D, 0x9D50 },
	{ 0x597E, 0x9D55 },
	{ 0x5A21, 0x4CD7 },
	{ 0x5A22, 0x9D5E },
	{ 0x5A23, 0x4D26 },
	{ 0x5A24, 0x9E90 },
	{ 0x5A25, 0x9EB2 },
	{ 0x5A26, 0x9EB1 },
	{ 0x5A27, 0x4D38 },
	{ 0x5A28, 0x9ECA },
	{ 0x5A29, 0x9F02 },
	{ 0x5A2A, 0x9F27 },
	{ 0x5A2B, 0x9F26 },
	{ 0x5A2C, 0x4D8A },
	{ 0x5A2D, 0x56AF },
	{ 0x5A2E, 0x58E0 },
	{ 0x5A2F, 0x58DC },
	{ 0x5A30, 0x3734 },
	{ 0x5A31, 0x5B39 },
	{ 0x5A32, 0x3735 },
	{ 0x5A33, 0x2F86A },
	{ 0x5A34, 0x5B7C },
	{ 0x5A35, 0x5BF3 },
	{ 0x5A36, 0x2F870 },
	{ 0x5A37, 0x37A1 },
	{ 0x5A38, 0x5C6B },
	{ 0x5A39, 0x5DC4 },
	{ 0x5A3A, 0x650B },
	{ 0x5A3B, 0x6508 },
	{ 0x5A3C, 0x650A },
	{ 0x5A3D, 0x3A6C },
	{ 0x5A3E, 0x3A6D },
	{ 0x5A3F, 0x65DC },
	{ 0x5A40, 0x3B29 },
	{ 0x5A41, 0x3B2A },
	{ 0x5A42, 0x66E1 },
	{ 0x5A43, 0x66DF },
	{ 0x5A44, 0x6ACE },
	{ 0x5A45, 0x6AD4 },
	{ 0x5A46, 0x6AE3 },
	{ 0x5A47, 0x6AD7 },
	{ 0x5A48, 0x6AE2 },
	{ 0x5A49, 0x3C00 },
	{ 0x5A4A, 0x3C08 },
	{ 0x5A4B, 0x3C06 },
	{ 0x5A4C, 0x3C05 },
	{ 0x5A4D, 0x6AD8 },
	{ 0x5A4E, 0x6AD5 },
	{ 0x5A4F, 0x6AD2 },
	{ 0x5A50, 0x3CB1 },
	{ 0x5A51, 0x3D88 },
	{ 0x5A52, 0x701E },
	{ 0x5A53, 0x702C },
	{ 0x5A54, 0x7025 },
	{ 0x5A55, 0x6FF3 },
	{ 0x5A56, 0x7204 },
	{ 0x5A57, 0x7208 },
	{ 0x5A58, 0x7215 },
	{ 0x5A59, 0x3E09 },
	{ 0x5A5A, 0x74C4 },
	{ 0x5A5B, 0x74C9 },
	{ 0x5A5C, 0x74C7 },
	{ 0x5A5D, 0x74C8 },
	{ 0x5A5E, 0x76A9 },
	{ 0x5A5F, 0x77C6 },
	{ 0x5A60, 0x77C5 },
	{ 0x5A61, 0x7918 },
	{ 0x5A62, 0x791A },
	{ 0x5A63, 0x7920 },
	{ 0x5A64, 0x4122 },
	{ 0x5A65, 0x7A66 },
	{ 0x5A66, 0x7A64 },
	{ 0x5A67, 0x7A6A },
	{ 0x5A68, 0x41D5 },
	{ 0x5A69, 0x4261 },
	{ 0x5A6A, 0x425D },
	{ 0x5A6B, 0x4262 },
	{ 0x5A6C, 0x424F },
	{ 0x5A6D, 0x4260 },
	{ 0x5A6E, 0x7C35 },
	{ 0x5A6F, 0x7C34 },
	{ 0x5A70, 0x42AA },
	{ 0x5A71, 0x4322 },
	{ 0x5A72, 0x7E6C },
	{ 0x5A73, 0x4321 },
	{ 0x5A74, 0x7E6E },
	{ 0x5A75, 0x7E71 },
	{ 0x5A76, 0x4446 },
	{ 0x5A77, 0x81D4 },
	{ 0x5A78, 0x81D6 },
	{ 0x5A79, 0x821A },
	{ 0x5A7A, 0x8262 },
	{ 0x5A7B, 0x8265 },
	{ 0x5A7C, 0x8276 },
	{ 0x5A7D, 0x85DB },
	{ 0x5A7E, 0x85D6 },
	{ 0x5B21, 0x4562 },
	{ 0x5B22, 0x85E7 },
	{ 0x5B23, 0x4560 },
	{ 0x5B24, 0x4564 },
	{ 0x5B25, 0x85F4 },
	{ 0x5B26, 0x2F9B6 },
	{ 0x5B27, 0x87FD },
	{ 0x5B28, 0x87D5 },
	{ 0x5B29, 0x8807 },
	{ 0x5B2A, 0x45F6 },
	{ 0x5B2B, 0x880F },
	{ 0x5B2C, 0x87F8 },
	{ 0x5B2D, 0x2F9C1 },
	{ 0x5B2E, 0x4619 },
	{ 0x5B2F, 0x8987 },
	{ 0x5B30, 0x4691 },
	{ 0x5B31, 0x89B5 },
	{ 0x5B32, 0x89F5 },
	{ 0x5B33, 0x470D },
	{ 0x5B34, 0x8B3F },
	{ 0x5B35, 0x8B43 },
	{ 0x5B36, 0x8B4C },
	{ 0x5B37, 0x4765 },
	{ 0x5B38, 0x8D0B },
	{ 0x5B39, 0x8E6B },
	{ 0x5B3A, 0x8E68 },
	{ 0x5B3B, 0x8E70 },
	{ 0x5B3C, 0x8E75 },
	{ 0x5B3D, 0x8E77 },
	{ 0x5B3E, 0x483F },
	{ 0x5B3F, 0x8EC3 },
	{ 0x5B40, 0x494B },
	{ 0x5B41, 0x93E9 },
	{ 0x5B42, 0x93EA },
	{ 0x5B43, 0x93CB },
	{ 0x5B44, 0x93C5 },
	{ 0x5B45, 0x93C6 },
	{ 0x5B46, 0x4948 },
	{ 0x5B47, 0x93ED },
	{ 0x5B48, 0x93D3 },
	{ 0x5B49, 0x4952 },
	{ 0x5B4A, 0x93E5 },
	{ 0x5B4B, 0x494A },
	{ 0x5B4C, 0x4951 },
	{ 0x5B4D, 0x93DB },
	{ 0x5B4E, 0x93EB },
	{ 0x5B4F, 0x93E0 },
	{ 0x5B50, 0x93C1 },
	{ 0x5B51, 0x4950 },
	{ 0x5B52, 0x494C },
	{ 0x5B53, 0x95DD },
	{ 0x5B54, 0x49EE },
	{ 0x5B55, 0x4A04 },
	{ 0x5B56, 0x4A06 },
	{ 0x5B57, 0x4A2D },
	{ 0x5B58, 0x4A2E },
	{ 0x5B59, 0x4A2F },
	{ 0x5B5A, 0x4A7B },
	{ 0x5B5B, 0x4A78 },
	{ 0x5B5C, 0x4A77 },
	{ 0x5B5D, 0x97B2 },
	{ 0x5B5E, 0x97B4 },
	{ 0x5B5F, 0x97B1 },
	{ 0x5B60, 0x97B5 },
	{ 0x5B61, 0x97F2 },
	{ 0x5B62, 0x4AA2 },
	{ 0x5B63, 0x4AA1 },
	{ 0x5B64, 0x4AE3 },
	{ 0x5B65, 0x9856 },
	{ 0x5B66, 0x4B1A },
	{ 0x5B67, 0x4B19 },
	{ 0x5B68, 0x4B57 },
	{ 0x5B69, 0x9944 },
	{ 0x5B6A, 0x4B9E },
	{ 0x5B6B, 0x9A26 },
	{ 0x5B6C, 0x9A1F },
	{ 0x5B6D, 0x9A18 },
	{ 0x5B6E, 0x9A21 },
	{ 0x5B6F, 0x9A17 },
	{ 0x5B70, 0x4BDD },
	{ 0x5B71, 0x9B09 },
	{ 0x5B72, 0x4C05 },
	{ 0x5B73, 0x4C28 },
	{ 0x5B74, 0x9BC5 },
	{ 0x5B75, 0x9BDF },
	{ 0x5B76, 0x4C60 },
	{ 0x5B77, 0x9BE3 },
	{ 0x5B78, 0x4C66 },
	{ 0x5B79, 0x9BE9 },
	{ 0x5B7A, 0x9BEE },
	{ 0x5B7B, 0x4C67 },
	{ 0x5B7C, 0x4C68 },
	{ 0x5B7D, 0x9D66 },
	{ 0x5B7E, 0x9D7A },
	{ 0x5C21, 0x4CDE },
	{ 0x5C22, 0x9D6E },
	{ 0x5C23, 0x9D91 },
	{ 0x5C24, 0x9D83 },
	{ 0x5C25, 0x9D76 },
	{ 0x5C26, 0x9D7E },
	{ 0x5C27, 0x9D6D },
	{ 0x5C28, 0x4CE1 },
	{ 0x5C29, 0x9E95 },
	{ 0x5C2A, 0x9EE3 },
	{ 0x5C2B, 0x4D69 },
	{ 0x5C2C, 0x4D77 },
	{ 0x5C2D, 0x9F03 },
	{ 0x5C2E, 0x9F04 },
	{ 0x5C2F, 0x2FA19 },
	{ 0x5C30, 0x9F17 },
	{ 0x5C31, 0x34A6 },
	{ 0x5C32, 0x5136 },
	{ 0x5C33, 0x34A5 },
	{ 0x5C34, 0x5336 },
	{ 0x5C35, 0x3614 },
	{ 0x5C36, 0x5B42 },
	{ 0x5C37, 0x3736 },
	{ 0x5C38, 0x3738 },
	{ 0x5C39, 0x5B44 },
	{ 0x5C3A, 0x5B46 },
	{ 0x5C3B, 0x5B7E },
	{ 0x5C3C, 0x5DCA },
	{ 0x5C3D, 0x5DC8 },
	{ 0x5C3E, 0x5DCC },
	{ 0x5C3F, 0x5EF0 },
	{ 0x5C40, 0x3A70 },
	{ 0x5C41, 0x6585 },
	{ 0x5C42, 0x66E5 },
	{ 0x5C43, 0x66E7 },
	{ 0x5C44, 0x3B2B },
	{ 0x5C45, 0x3C11 },
	{ 0x5C46, 0x3C0A },
	{ 0x5C47, 0x6AF4 },
	{ 0x5C48, 0x3C0D },
	{ 0x5C49, 0x6AE9 },
	{ 0x5C4A, 0x3C16 },
	{ 0x5C4B, 0x3C10 },
	{ 0x5C4C, 0x3C09 },
	{ 0x5C4D, 0x3C0E },
	{ 0x5C4E, 0x3C7A },
	{ 0x5C4F, 0x703D },
	{ 0x5C50, 0x3D8C },
	{ 0x5C51, 0x7036 },
	{ 0x5C52, 0x3D91 },
	{ 0x5C53, 0x7216 },
	{ 0x5C54, 0x3E0A },
	{ 0x5C55, 0x7212 },
	{ 0x5C56, 0x720F },
	{ 0x5C57, 0x7217 },
	{ 0x5C58, 0x7211 },
	{ 0x5C59, 0x720B },
	{ 0x5C5A, 0x3E08 },
	{ 0x5C5B, 0x3E0B },
	{ 0x5C5C, 0x74CD },
	{ 0x5C5D, 0x74D0 },
	{ 0x5C5E, 0x74CC },
	{ 0x5C5F, 0x74CE },
	{ 0x5C60, 0x74D1 },
	{ 0x5C61, 0x3F07 },
	{ 0x5C62, 0x7589 },
	{ 0x5C63, 0x40F2 },
	{ 0x5C64, 0x7A6F },
	{ 0x5C65, 0x7C4B },
	{ 0x5C66, 0x7C44 },
	{ 0x5C67, 0x7C55 },
	{ 0x5C68, 0x42AE },
	{ 0x5C69, 0x4324 },
	{ 0x5C6A, 0x4326 },
	{ 0x5C6B, 0x4327 },
	{ 0x5C6C, 0x7E7F },
	{ 0x5C6D, 0x8B71 },
	{ 0x5C6E, 0x4399 },
	{ 0x5C6F, 0x802F },
	{ 0x5C70, 0x807A },
	{ 0x5C71, 0x807B },
	{ 0x5C72, 0x807C },
	{ 0x5C73, 0x455F },
	{ 0x5C74, 0x456A },
	{ 0x5C75, 0x4571 },
	{ 0x5C76, 0x85FC },
	{ 0x5C77, 0x8610 },
	{ 0x5C78, 0x8602 },
	{ 0x5C79, 0x456C },
	{ 0x5C7A, 0x456F },
	{ 0x5C7B, 0x85EE },
	{ 0x5C7C, 0x8603 },
	{ 0x5C7D, 0x4568 },
	{ 0x5C7E, 0x860D },
	{ 0x5D21, 0x8613 },
	{ 0x5D22, 0x8608 },
	{ 0x5D23, 0x860F },
	{ 0x5D24, 0x8818 },
	{ 0x5D25, 0x8812 },
	{ 0x5D26, 0x4601 },
	{ 0x5D27, 0x4668 },
	{ 0x5D28, 0x8967 },
	{ 0x5D29, 0x8965 },
	{ 0x5D2A, 0x89BB },
	{ 0x5D2B, 0x8B69 },
	{ 0x5D2C, 0x8B62 },
	{ 0x5D2D, 0x4713 },
	{ 0x5D2E, 0x8B6E },
	{ 0x5D2F, 0x4716 },
	{ 0x5D30, 0x8B61 },
	{ 0x5D31, 0x4718 },
	{ 0x5D32, 0x8B64 },
	{ 0x5D33, 0x8B4D },
	{ 0x5D34, 0x8C51 },
	{ 0x5D35, 0x4789 },
	{ 0x5D36, 0x47C8 },
	{ 0x5D37, 0x8E83 },
	{ 0x5D38, 0x8EC6 },
	{ 0x5D39, 0x4884 },
	{ 0x5D3A, 0x941F },
	{ 0x5D3B, 0x4954 },
	{ 0x5D3C, 0x9404 },
	{ 0x5D3D, 0x9417 },
	{ 0x5D3E, 0x9408 },
	{ 0x5D3F, 0x9405 },
	{ 0x5D40, 0x4956 },
	{ 0x5D41, 0x93F3 },
	{ 0x5D42, 0x941E },
	{ 0x5D43, 0x9402 },
	{ 0x5D44, 0x941A },
	{ 0x5D45, 0x941B },
	{ 0x5D46, 0x9427 },
	{ 0x5D47, 0x941C },
	{ 0x5D48, 0x495A },
	{ 0x5D49, 0x96B5 },
	{ 0x5D4A, 0x4A05 },
	{ 0x5D4B, 0x4A07 },
	{ 0x5D4C, 0x9733 },
	{ 0x5D4D, 0x4A31 },
	{ 0x5D4E, 0x9734 },
	{ 0x5D4F, 0x9731 },
	{ 0x5D50, 0x97B8 },
	{ 0x5D51, 0x97BA },
	{ 0x5D52, 0x4AA3 },
	{ 0x5D53, 0x97FC },
	{ 0x5D54, 0x4AEB },
	{ 0x5D55, 0x4B1C },
	{ 0x5D56, 0x98C3 },
	{ 0x5D57, 0x4B5A },
	{ 0x5D58, 0x994D },
	{ 0x5D59, 0x4B5B },
	{ 0x5D5A, 0x9A2F },
	{ 0x5D5B, 0x4BA6 },
	{ 0x5D5C, 0x4BAA },
	{ 0x5D5D, 0x4BA5 },
	{ 0x5D5E, 0x9AC9 },
	{ 0x5D5F, 0x4BE1 },
	{ 0x5D60, 0x9AC8 },
	{ 0x5D61, 0x9AC4 },
	{ 0x5D62, 0x9B2A },
	{ 0x5D63, 0x9B38 },
	{ 0x5D64, 0x9B50 },
	{ 0x5D65, 0x4C2A },
	{ 0x5D66, 0x9C0A },
	{ 0x5D67, 0x9BFB },
	{ 0x5D68, 0x9C04 },
	{ 0x5D69, 0x9BFC },
	{ 0x5D6A, 0x9BFE },
	{ 0x5D6B, 0x4C72 },
	{ 0x5D6C, 0x4C6F },
	{ 0x5D6D, 0x4C73 },
	{ 0x5D6E, 0x9C02 },
	{ 0x5D6F, 0x9BF6 },
	{ 0x5D70, 0x9C1B },
	{ 0x5D71, 0x9BF9 },
	{ 0x5D72, 0x9C15 },
	{ 0x5D73, 0x9C10 },
	{ 0x5D74, 0x9BFF },
	{ 0x5D75, 0x9C00 },
	{ 0x5D76, 0x9C0C },
	{ 0x5D77, 0x4C6B },
	{ 0x5D78, 0x4CE6 },
	{ 0x5D79, 0x9D95 },
	{ 0x5D7A, 0x9DA5 },
	{ 0x5D7B, 0x4CE9 },
	{ 0x5D7C, 0x4CEC },
	{ 0x5D7D, 0x4CE8 },
	{ 0x5D7E, 0x4CF0 },
	{ 0x5E21, 0x9E98 },
	{ 0x5E22, 0x9EC1 },
	{ 0x5E23, 0x4D8C },
	{ 0x5E24, 0x9F5A },
	{ 0x5E25, 0x5164 },
	{ 0x5E26, 0x56BB },
	{ 0x5E27, 0x3615 },
	{ 0x5E28, 0x58E6 },
	{ 0x5E29, 0x5B49 },
	{ 0x5E2A, 0x5BF7 },
	{ 0x5E2B, 0x3771 },
	{ 0x5E2C, 0x3826 },
	{ 0x5E2D, 0x5DD0 },
	{ 0x5E2E, 0x38C6 },
	{ 0x5E2F, 0x5FC2 },
	{ 0x5E30, 0x39A8 },
	{ 0x5E31, 0x6511 },
	{ 0x5E32, 0x3A73 },
	{ 0x5E33, 0x6AFF },
	{ 0x5E34, 0x6AFE },
	{ 0x5E35, 0x6AFD },
	{ 0x5E36, 0x3C15 },
	{ 0x5E37, 0x6B01 },
	{ 0x5E38, 0x3D98 },
	{ 0x5E39, 0x3D97 },
	{ 0x5E3A, 0x704B },
	{ 0x5E3B, 0x704D },
	{ 0x5E3C, 0x7047 },
	{ 0x5E3D, 0x74D3 },
	{ 0x5E3E, 0x7668 },
	{ 0x5E3F, 0x7667 },
	{ 0x5E40, 0x3FD7 },
	{ 0x5E41, 0x4080 },
	{ 0x5E42, 0x77D1 },
	{ 0x5E43, 0x7930 },
	{ 0x5E44, 0x7932 },
	{ 0x5E45, 0x792E },
	{ 0x5E46, 0x4188 },
	{ 0x5E47, 0x9F9D },
	{ 0x5E48, 0x7AC9 },
	{ 0x5E49, 0x7AC8 },
	{ 0x5E4A, 0x4269 },
	{ 0x5E4B, 0x7C56 },
	{ 0x5E4C, 0x7C51 },
	{ 0x5E4D, 0x426B },
	{ 0x5E4E, 0x4329 },
	{ 0x5E4F, 0x4328 },
	{ 0x5E50, 0x7E85 },
	{ 0x5E51, 0x7E89 },
	{ 0x5E52, 0x7E8E },
	{ 0x5E53, 0x7E84 },
	{ 0x5E54, 0x445F },
	{ 0x5E55, 0x826A },
	{ 0x5E56, 0x862B },
	{ 0x5E57, 0x862F },
	{ 0x5E58, 0x8628 },
	{ 0x5E59, 0x4574 },
	{ 0x5E5A, 0x8616 },
	{ 0x5E5B, 0x8615 },
	{ 0x5E5C, 0x861D },
	{ 0x5E5D, 0x881A },
	{ 0x5E5E, 0x4602 },
	{ 0x5E5F, 0x466A },
	{ 0x5E60, 0x4694 },
	{ 0x5E61, 0x89BC },
	{ 0x5E62, 0x8B75 },
	{ 0x5E63, 0x8B7C },
	{ 0x5E64, 0x478A },
	{ 0x5E65, 0x8D11 },
	{ 0x5E66, 0x8D12 },
	{ 0x5E67, 0x8F5C },
	{ 0x5E68, 0x91BB },
	{ 0x5E69, 0x4964 },
	{ 0x5E6A, 0x93F4 },
	{ 0x5E6B, 0x495E },
	{ 0x5E6C, 0x4961 },
	{ 0x5E6D, 0x942D },
	{ 0x5E6E, 0x4965 },
	{ 0x5E6F, 0x4966 },
	{ 0x5E70, 0x96E4 },
	{ 0x5E71, 0x9737 },
	{ 0x5E72, 0x9736 },
	{ 0x5E73, 0x9767 },
	{ 0x5E74, 0x97BE },
	{ 0x5E75, 0x97BD },
	{ 0x5E76, 0x97E2 },
	{ 0x5E77, 0x9868 },
	{ 0x5E78, 0x9866 },
	{ 0x5E79, 0x98C8 },
	{ 0x5E7A, 0x98CA },
	{ 0x5E7B, 0x98C7 },
	{ 0x5E7C, 0x98DC },
	{ 0x5E7D, 0x4B5F },
	{ 0x5E7E, 0x994F },
	{ 0x5F21, 0x99A9 },
	{ 0x5F22, 0x9A3C },
	{ 0x5F23, 0x4BAF },
	{ 0x5F24, 0x9A3B },
	{ 0x5F25, 0x9ACE },
	{ 0x5F26, 0x4C0D },
	{ 0x5F27, 0x9B14 },
	{ 0x5F28, 0x9B53 },
	{ 0x5F29, 0x4C7C },
	{ 0x5F2A, 0x9C2E },
	{ 0x5F2B, 0x4C7A },
	{ 0x5F2C, 0x9C1F },
	{ 0x5F2D, 0x4C76 },
	{ 0x5F2E, 0x4C79 },
	{ 0x5F2F, 0x4C7D },
	{ 0x5F30, 0x4C77 },
	{ 0x5F31, 0x9DB0 },
	{ 0x5F32, 0x9DBD },
	{ 0x5F33, 0x4CF6 },
	{ 0x5F34, 0x4CF1 },
	{ 0x5F35, 0x9DAE },
	{ 0x5F36, 0x9DC4 },
	{ 0x5F37, 0x9E7B },
	{ 0x5F38, 0x400B },
	{ 0x5F39, 0x4D29 },
	{ 0x5F3A, 0x9E9E },
	{ 0x5F3B, 0x4D6F },
	{ 0x5F3C, 0x9F05 },
	{ 0x5F3D, 0x4D9A },
	{ 0x5F3E, 0x9F69 },
	{ 0x5F3F, 0x9FA1 },
	{ 0x5F40, 0x56C7 },
	{ 0x5F41, 0x571D },
	{ 0x5F42, 0x5B4A },
	{ 0x5F43, 0x5DD3 },
	{ 0x5F44, 0x3869 },
	{ 0x5F45, 0x5F72 },
	{ 0x5F46, 0x6202 },
	{ 0x5F47, 0x39AB },
	{ 0x5F48, 0x6235 },
	{ 0x5F49, 0x6527 },
	{ 0x5F4A, 0x651E },
	{ 0x5F4B, 0x651F },
	{ 0x5F4C, 0x3B2C },
	{ 0x5F4D, 0x3B2D },
	{ 0x5F4E, 0x6B07 },
	{ 0x5F4F, 0x6B06 },
	{ 0x5F50, 0x3C17 },
	{ 0x5F51, 0x3D9A },
	{ 0x5F52, 0x7054 },
	{ 0x5F53, 0x721C },
	{ 0x5F54, 0x7220 },
	{ 0x5F55, 0x7AF8 },
	{ 0x5F56, 0x426E },
	{ 0x5F57, 0x7C5D },
	{ 0x5F58, 0x7C58 },
	{ 0x5F59, 0x432C },
	{ 0x5F5A, 0x7E92 },
	{ 0x5F5B, 0x7F4E },
	{ 0x5F5C, 0x43CA },
	{ 0x5F5D, 0x4578 },
	{ 0x5F5E, 0x4606 },
	{ 0x5F5F, 0x8827 },
	{ 0x5F60, 0x4607 },
	{ 0x5F61, 0x8B81 },
	{ 0x5F62, 0x8B83 },
	{ 0x5F63, 0x4720 },
	{ 0x5F64, 0x8C44 },
	{ 0x5F65, 0x4753 },
	{ 0x5F66, 0x47CE },
	{ 0x5F67, 0x487A },
	{ 0x5F68, 0x4879 },
	{ 0x5F69, 0x9442 },
	{ 0x5F6A, 0x944D },
	{ 0x5F6B, 0x9454 },
	{ 0x5F6C, 0x944E },
	{ 0x5F6D, 0x496B },
	{ 0x5F6E, 0x9443 },
	{ 0x5F6F, 0x4967 },
	{ 0x5F70, 0x496D },
	{ 0x5F71, 0x973C },
	{ 0x5F72, 0x9740 },
	{ 0x5F73, 0x97C0 },
	{ 0x5F74, 0x4A85 },
	{ 0x5F75, 0x4AB0 },
	{ 0x5F76, 0x4AF3 },
	{ 0x5F77, 0x4B63 },
	{ 0x5F78, 0x995A },
	{ 0x5F79, 0x9A51 },
	{ 0x5F7A, 0x4BB6 },
	{ 0x5F7B, 0x9ADD },
	{ 0x5F7C, 0x4C82 },
	{ 0x5F7D, 0x4C7F },
	{ 0x5F7E, 0x9C38 },
	{ 0x6021, 0x4C86 },
	{ 0x6022, 0x9C45 },
	{ 0x6023, 0x9C3A },
	{ 0x6024, 0x4C84 },
	{ 0x6025, 0x9C35 },
	{ 0x6026, 0x4CFC },
	{ 0x6027, 0x4CFD },
	{ 0x6028, 0x4CFA },
	{ 0x6029, 0x9EF1 },
	{ 0x602A, 0x4D87 },
	{ 0x602B, 0x9F93 },
	{ 0x602C, 0x529A },
	{ 0x602D, 0x361A },
	{ 0x602E, 0x3619 },
	{ 0x602F, 0x8641 },
	{ 0x6030, 0x5DD7 },
	{ 0x6031, 0x3A75 },
	{ 0x6032, 0x6528 },
	{ 0x6033, 0x3C1A },
	{ 0x6034, 0x3C1B },
	{ 0x6035, 0x3C19 },
	{ 0x6036, 0x7053 },
	{ 0x6037, 0x7059 },
	{ 0x6038, 0x3D9C },
	{ 0x6039, 0x7221 },
	{ 0x603A, 0x3E10 },
	{ 0x603B, 0x766F },
	{ 0x603C, 0x7937 },
	{ 0x603D, 0x79B5 },
	{ 0x603E, 0x7C62 },
	{ 0x603F, 0x7C5E },
	{ 0x6040, 0x7CF5 },
	{ 0x6041, 0x457B },
	{ 0x6042, 0x457C },
	{ 0x6043, 0x863D },
	{ 0x6044, 0x4608 },
	{ 0x6045, 0x882D },
	{ 0x6046, 0x8989 },
	{ 0x6047, 0x8B8D },
	{ 0x6048, 0x8B87 },
	{ 0x6049, 0x8B90 },
	{ 0x604A, 0x8D1A },
	{ 0x604B, 0x8E99 },
	{ 0x604C, 0x4841 },
	{ 0x604D, 0x48E3 },
	{ 0x604E, 0x4972 },
	{ 0x604F, 0x945F },
	{ 0x6050, 0x4973 },
	{ 0x6051, 0x4968 },
	{ 0x6052, 0x9456 },
	{ 0x6053, 0x9461 },
	{ 0x6054, 0x945B },
	{ 0x6055, 0x945A },
	{ 0x6056, 0x945C },
	{ 0x6057, 0x9465 },
	{ 0x6058, 0x4A35 },
	{ 0x6059, 0x9741 },
	{ 0x605A, 0x4A88 },
	{ 0x605B, 0x4A9D },
	{ 0x605C, 0x986E },
	{ 0x605D, 0x986C },
	{ 0x605E, 0x986D },
	{ 0x605F, 0x4275 },
	{ 0x6060, 0x99AA },
	{ 0x6061, 0x9A5C },
	{ 0x6062, 0x9A58 },
	{ 0x6063, 0x9ADE },
	{ 0x6064, 0x4C8F },
	{ 0x6065, 0x9C4F },
	{ 0x6066, 0x9C51 },
	{ 0x6067, 0x4C8E },
	{ 0x6068, 0x9C53 },
	{ 0x6069, 0x4D05 },
	{ 0x606A, 0x4D04 },
	{ 0x606B, 0x4CFF },
	{ 0x606C, 0x9DFC },
	{ 0x606D, 0x9F39 },
	{ 0x606E, 0x4D9E },
	{ 0x606F, 0x513E },
	{ 0x6070, 0x3554 },
	{ 0x6071, 0x56D2 },
	{ 0x6072, 0x3681 },
	{ 0x6073, 0x5B4F },
	{ 0x6074, 0x6B14 },
	{ 0x6075, 0x40FA },
	{ 0x6076, 0x7A72 },
	{ 0x6077, 0x7A73 },
	{ 0x6078, 0x4332 },
	{ 0x6079, 0x4670 },
	{ 0x607A, 0x466E },
	{ 0x607B, 0x8B91 },
	{ 0x607C, 0x2F9D6 },
	{ 0x607D, 0x487C },
	{ 0x607E, 0x91BF },
	{ 0x6121, 0x4975 },
	{ 0x6122, 0x946C },
	{ 0x6123, 0x4974 },
	{ 0x6124, 0x4977 },
	{ 0x6125, 0x96E6 },
	{ 0x6126, 0x9745 },
	{ 0x6127, 0x4A37 },
	{ 0x6128, 0x97C8 },
	{ 0x6129, 0x97E4 },
	{ 0x612A, 0x995D },
	{ 0x612B, 0x4BBA },
	{ 0x612C, 0x9B21 },
	{ 0x612D, 0x4C11 },
	{ 0x612E, 0x9B2C },
	{ 0x612F, 0x9B57 },
	{ 0x6130, 0x4C92 },
	{ 0x6131, 0x4C99 },
	{ 0x6132, 0x9C5D },
	{ 0x6133, 0x9C61 },
	{ 0x6134, 0x9C65 },
	{ 0x6135, 0x9E08 },
	{ 0x6136, 0x4D0A },
	{ 0x6137, 0x4D2A },
	{ 0x6138, 0x4D2B },
	{ 0x6139, 0x4D44 },
	{ 0x613A, 0x4D79 },
	{ 0x613B, 0x9F45 },
	{ 0x613C, 0x34AA },
	{ 0x613D, 0x3748 },
	{ 0x613E, 0x6205 },
	{ 0x613F, 0x66EF },
	{ 0x6140, 0x6B1B },
	{ 0x6141, 0x6B1D },
	{ 0x6142, 0x7225 },
	{ 0x6143, 0x7224 },
	{ 0x6144, 0x7C6D },
	{ 0x6145, 0x42B4 },
	{ 0x6146, 0x8642 },
	{ 0x6147, 0x8649 },
	{ 0x6148, 0x460D },
	{ 0x6149, 0x8978 },
	{ 0x614A, 0x898A },
	{ 0x614B, 0x8B97 },
	{ 0x614C, 0x4754 },
	{ 0x614D, 0x8C9B },
	{ 0x614E, 0x8D1C },
	{ 0x614F, 0x4830 },
	{ 0x6150, 0x8EA2 },
	{ 0x6151, 0x4A09 },
	{ 0x6152, 0x4A38 },
	{ 0x6153, 0x4A36 },
	{ 0x6154, 0x4A8B },
	{ 0x6155, 0x4AF7 },
	{ 0x6156, 0x4B66 },
	{ 0x6157, 0x4BBD },
	{ 0x6158, 0x4C1E },
	{ 0x6159, 0x9C6C },
	{ 0x615A, 0x4C96 },
	{ 0x615B, 0x9C6F },
	{ 0x615C, 0x4D0D },
	{ 0x615D, 0x9E0E },
	{ 0x615E, 0x4D73 },
	{ 0x615F, 0x9F08 },
	{ 0x6160, 0x9F1D },
	{ 0x6161, 0x9FA3 },
	{ 0x6162, 0x373B },
	{ 0x6163, 0x373C },
	{ 0x6164, 0x5F60 },
	{ 0x6165, 0x6B1C },
	{ 0x6166, 0x3DA0 },
	{ 0x6167, 0x40FB },
	{ 0x6169, 0x7CF3 },
	{ 0x616A, 0x4581 },
	{ 0x616B, 0x8B9B },
	{ 0x616C, 0x8EA7 },
	{ 0x616D, 0x91C4 },
	{ 0x616E, 0x4978 },
	{ 0x616F, 0x947A },
	{ 0x6170, 0x4A8D },
	{ 0x6171, 0x4B73 },
	{ 0x6172, 0x9A61 },
	{ 0x6173, 0x9A63 },
	{ 0x6174, 0x9AD7 },
	{ 0x6175, 0x9C76 },
	{ 0x6176, 0x4DA6 },
	{ 0x6177, 0x9FA5 },
	{ 0x6178, 0x39AD },
	{ 0x6179, 0x7067 },
	{ 0x617A, 0x3E11 },
	{ 0x617B, 0x72AB },
	{ 0x617C, 0x864A },
	{ 0x617D, 0x897D },
	{ 0x617E, 0x8B9D },
	{ 0x6221, 0x8C53 },
	{ 0x6222, 0x8F65 },
	{ 0x6223, 0x947B },
	{ 0x6224, 0x4A39 },
	{ 0x6225, 0x98CD },
	{ 0x6226, 0x98DD },
	{ 0x6227, 0x4BBF },
	{ 0x6228, 0x9B30 },
	{ 0x6229, 0x9E16 },
	{ 0x622A, 0x4D0F },
	{ 0x622B, 0x4DA7 },
	{ 0x622C, 0x4DB5 },
	{ 0x622D, 0x3FDC },
	{ 0x622E, 0x4831 },
	{ 0x622F, 0x96E7 },
	{ 0x6230, 0x9E18 },
	{ 0x6231, 0x9EA2 },
	{ 0x6232, 0x4DA8 },
	{ 0x6233, 0x9F7C },
	{ 0x6234, 0x4125 },
	{ 0x6235, 0x7E9E },
	{ 0x6236, 0x9484 },
	{ 0x6237, 0x4BC1 },
	{ 0x6238, 0x9E1C },
	{ 0x6239, 0x4190 },
	{ 0x623A, 0x7C71 },
	{ 0x623B, 0x97CA },
	{ 0x623C, 0x4696 },
	{ 0x623D, 0x487F },
	{ 0x623E, 0x4D10 },
	{ 0x623F, 0x9EA3 },
	{ 0x6240, 0x4A0A },
	{ 0x6241, 0x9C7B },
	{ 0x6242, 0x9F97 },
	{ 0x6243, 0x4D12 },
	{ 0x6244, 0x4A3A },
	{ 0x6245, 0x9750 },
	{ 0x6246, 0x4A3B },
	{ 0x6448, 0x4F66 },
	{ 0x6449, 0x4F68 },
	{ 0x644A, 0x4FE7 },
	{ 0x644B, 0x503F },
	{ 0x644D, 0x50A6 },
	{ 0x644E, 0x510F },
	{ 0x644F, 0x523E },
	{ 0x6450, 0x5324 },
	{ 0x6451, 0x5365 },
	{ 0x6452, 0x539B },
	{ 0x6453, 0x517F },
	{ 0x6454, 0x54CB },
	{ 0x6455, 0x5573 },
	{ 0x6456, 0x5571 },
	{ 0x6457, 0x556B },
	{ 0x6458, 0x55F4 },
	{ 0x6459, 0x5622 },
	{ 0x645A, 0x5620 },
	{ 0x645B, 0x5692 },
	{ 0x645C, 0x56BA },
	{ 0x645D, 0x5691 },
	{ 0x645E, 0x56B0 },
	{ 0x645F, 0x5759 },
	{ 0x6460, 0x578A },
	{ 0x6461, 0x580F },
	{ 0x6462, 0x5812 },
	{ 0x6463, 0x5813 },
	{ 0x6464, 0x5847 },
	{ 0x6465, 0x589B },
	{ 0x6466, 0x5900 },
	{ 0x6467, 0x594D },
	{ 0x6468, 0x5AD1 },
	{ 0x6469, 0x5AD3 },
	{ 0x646A, 0x5B67 },
	{ 0x646B, 0x5C57 },
	{ 0x646C, 0x5C77 },
	{ 0x646D, 0x5CD5 },
	{ 0x646E, 0x5D75 },
	{ 0x646F, 0x5D8E },
	{ 0x6470, 0x5DA5 },
	{ 0x6471, 0x5DB6 },
	{ 0x6472, 0x5DBF },
	{ 0x6473, 0x5E65 },
	{ 0x6474, 0x5ECD },
	{ 0x6475, 0x5EED },
	{ 0x6476, 0x5F94 },
	{ 0x6477, 0x5F9A },
	{ 0x6478, 0x5FBA },
	{ 0x6479, 0x6125 },
	{ 0x647A, 0x6150 },
	{ 0x647B, 0x62A3 },
	{ 0x647C, 0x6360 },
	{ 0x647D, 0x6364 },
	{ 0x647E, 0x63B6 },
	{ 0x6521, 0x6403 },
	{ 0x6522, 0x64B6 },
	{ 0x6523, 0x651A },
	{ 0x6524, 0x7A25 },
	{ 0x6525, 0x5C21 },
	{ 0x6526, 0x66E2 },
	{ 0x6527, 0x6702 },
	{ 0x6528, 0x67A4 },
	{ 0x6529, 0x67AC },
	{ 0x652A, 0x6810 },
	{ 0x652B, 0x6806 },
	{ 0x652C, 0x685E },
	{ 0x652D, 0x685A },
	{ 0x652E, 0x692C },
	{ 0x652F, 0x6929 },
	{ 0x6530, 0x6A2D },
	{ 0x6531, 0x6A77 },
	{ 0x6532, 0x6A7A },
	{ 0x6533, 0x6ACA },
	{ 0x6534, 0x6AE6 },
	{ 0x6535, 0x6AF5 },
	{ 0x6536, 0x6B0D },
	{ 0x6537, 0x6B0E },
	{ 0x6538, 0x6BDC },
	{ 0x6539, 0x6BDD },
	{ 0x653A, 0x6BF6 },
	{ 0x653B, 0x6C1E },
	{ 0x653C, 0x6C63 },
	{ 0x653D, 0x6DA5 },
	{ 0x653E, 0x6E0F },
	{ 0x653F, 0x6E8A },
	{ 0x6540, 0x6E84 },
	{ 0x6541, 0x6E8B },
	{ 0x6542, 0x6E7C },
	{ 0x6543, 0x6F4C },
	{ 0x6544, 0x6F48 },
	{ 0x6545, 0x6F49 },
	{ 0x6546, 0x6F9D },
	{ 0x6547, 0x6F99 },
	{ 0x6548, 0x6FF8 },
	{ 0x6549, 0x702E },
	{ 0x654A, 0x702D },
	{ 0x654B, 0x705C },
	{ 0x654C, 0x79CC },
	{ 0x654D, 0x70BF },
	{ 0x654E, 0x70EA },
	{ 0x654F, 0x70E5 },
	{ 0x6550, 0x7111 },
	{ 0x6551, 0x7112 },
	{ 0x6552, 0x713F },
	{ 0x6553, 0x7139 },
	{ 0x6554, 0x713B },
	{ 0x6555, 0x713D },
	{ 0x6556, 0x7177 },
	{ 0x6557, 0x7175 },
	{ 0x6558, 0x7176 },
	{ 0x6559, 0x7171 },
	{ 0x655A, 0x7196 },
	{ 0x655B, 0x7193 },
	{ 0x655C, 0x71B4 },
	{ 0x655D, 0x71DD },
	{ 0x655E, 0x71DE },
	{ 0x655F, 0x720E },
	{ 0x6560, 0x5911 },
	{ 0x6561, 0x7218 },
	{ 0x6562, 0x7347 },
	{ 0x6563, 0x7348 },
	{ 0x6564, 0x73EF },
	{ 0x6565, 0x7412 },
	{ 0x6566, 0x743B },
	{ 0x6567, 0x74A4 },
	{ 0x6568, 0x748D },
	{ 0x6569, 0x74B4 },
	{ 0x656A, 0x7673 },
	{ 0x656B, 0x7677 },
	{ 0x656C, 0x76BC },
	{ 0x656D, 0x7819 },
	{ 0x656E, 0x781B },
	{ 0x656F, 0x783D },
	{ 0x6570, 0x7853 },
	{ 0x6571, 0x7854 },
	{ 0x6572, 0x7858 },
	{ 0x6573, 0x78B7 },
	{ 0x6574, 0x78D8 },
	{ 0x6575, 0x78EE },
	{ 0x6576, 0x7922 },
	{ 0x6577, 0x794D },
	{ 0x6578, 0x7986 },
	{ 0x6579, 0x7999 },
	{ 0x657A, 0x79A3 },
	{ 0x657B, 0x79BC },
	{ 0x657C, 0x7AA7 },
	{ 0x657D, 0x7B37 },
	{ 0x657E, 0x7B59 },
	{ 0x6621, 0x7BD0 },
	{ 0x6622, 0x7C2F },
	{ 0x6623, 0x7C32 },
	{ 0x6624, 0x7C42 },
	{ 0x6625, 0x7C4E },
	{ 0x6626, 0x7C68 },
	{ 0x6627, 0x7CA9 },
	{ 0x6628, 0x7CED },
	{ 0x6629, 0x7DD0 },
	{ 0x662A, 0x7E07 },
	{ 0x662B, 0x7DD3 },
	{ 0x662C, 0x7E64 },
	{ 0x662D, 0x7F40 },
	{ 0x662F, 0x8041 },
	{ 0x6630, 0x8063 },
	{ 0x6631, 0x80BB },
	{ 0x6632, 0x6711 },
	{ 0x6633, 0x6725 },
	{ 0x6634, 0x8248 },
	{ 0x6635, 0x8310 },
	{ 0x6636, 0x8362 },
	{ 0x6637, 0x8312 },
	{ 0x6638, 0x8421 },
	{ 0x6639, 0x841E },
	{ 0x663A, 0x84E2 },
	{ 0x663B, 0x84DE },
	{ 0x663C, 0x84E1 },
	{ 0x663D, 0x8573 },
	{ 0x663E, 0x85D4 },
	{ 0x663F, 0x85F5 },
	{ 0x6640, 0x8637 },
	{ 0x6641, 0x8645 },
	{ 0x6642, 0x8672 },
	{ 0x6643, 0x874A },
	{ 0x6644, 0x87A9 },
	{ 0x6645, 0x87A5 },
	{ 0x6646, 0x87F5 },
	{ 0x6647, 0x8834 },
	{ 0x6648, 0x8850 },
	{ 0x6649, 0x8887 },
	{ 0x664A, 0x8954 },
	{ 0x664B, 0x8984 },
	{ 0x664C, 0x8B03 },
	{ 0x664D, 0x8C52 },
	{ 0x664E, 0x8CD8 },
	{ 0x664F, 0x8D0C },
	{ 0x6650, 0x8D18 },
	{ 0x6651, 0x8DB0 },
	{ 0x6652, 0x8EBC },
	{ 0x6653, 0x8ED5 },
	{ 0x6654, 0x8FAA },
	{ 0x6655, 0x909C },
	{ 0x6657, 0x915C },
	{ 0x6658, 0x922B },
	{ 0x6659, 0x9221 },
	{ 0x665A, 0x9273 },
	{ 0x665B, 0x92F4 },
	{ 0x665C, 0x92F5 },
	{ 0x665D, 0x933F },
	{ 0x665E, 0x9342 },
	{ 0x665F, 0x9386 },
	{ 0x6660, 0x93BE },
	{ 0x6661, 0x93BC },
	{ 0x6662, 0x93BD },
	{ 0x6663, 0x93F1 },
	{ 0x6664, 0x93F2 },
	{ 0x6665, 0x93EF },
	{ 0x6666, 0x9422 },
	{ 0x6667, 0x9423 },
	{ 0x6668, 0x9424 },
	{ 0x6669, 0x9467 },
	{ 0x666A, 0x9466 },
	{ 0x666B, 0x9597 },
	{ 0x666C, 0x95CE },
	{ 0x666D, 0x95E7 },
	{ 0x666E, 0x973B },
	{ 0x666F, 0x974D },
	{ 0x6670, 0x98E4 },
	{ 0x6671, 0x9942 },
	{ 0x6672, 0x9B1D },
	{ 0x6673, 0x9B98 },
	{ 0x6675, 0x9D49 },
	{ 0x6676, 0x6449 },
	{ 0x6677, 0x5E71 },
	{ 0x6678, 0x5E85 },
	{ 0x6679, 0x61D3 },
	{ 0x667A, 0x990E },
	{ 0x667B, 0x8002 },
	{ 0x667C, 0x781E },
	{ 0x6721, 0x5528 },
	{ 0x6722, 0x5572 },
	{ 0x6723, 0x55BA },
	{ 0x6724, 0x55F0 },
	{ 0x6725, 0x55EE },
	{ 0x6726, 0x56B8 },
	{ 0x6727, 0x56B9 },
	{ 0x6728, 0x56C4 },
	{ 0x6729, 0x8053 },
	{ 0x672A, 0x92B0 }
};
/* CNS 11643 plane #4 */
cns_utf cns4_utf_tab[MAX_CNS4_NUM] = {
	{ 0x2121, 0x20086 },
	{ 0x2122, 0x4E40 },
	{ 0x2123, 0x4E41 },
	{ 0x2124, 0x4E5A },
	{ 0x2125, 0x21FE8 },
	{ 0x2126, 0x4E02 },
	{ 0x2127, 0x4E29 },
	{ 0x2128, 0x2010E },
	{ 0x2129, 0x20627 },
	{ 0x212A, 0x5202 },
	{ 0x212B, 0x353E },
	{ 0x212C, 0x5DDC },
	{ 0x212D, 0x2053C },
	{ 0x212E, 0x20675 },
	{ 0x212F, 0x2F828 },
	{ 0x2130, 0x5342 },
	{ 0x2131, 0x536A },
	{ 0x2132, 0x5B52 },
	{ 0x2133, 0x2193C },
	{ 0x2134, 0x2F875 },
	{ 0x2135, 0x2F878 },
	{ 0x2136, 0x5FC4 },
	{ 0x2137, 0x624C },
	{ 0x2138, 0x72AD },
	{ 0x2139, 0x4E12 },
	{ 0x213A, 0x4E2F },
	{ 0x213B, 0x4E96 },
	{ 0x213C, 0x4ED0 },
	{ 0x213D, 0x5142 },
	{ 0x213E, 0x5183 },
	{ 0x213F, 0x2F819 },
	{ 0x2140, 0x206A5 },
	{ 0x2141, 0x206AA },
	{ 0x2142, 0x2090F },
	{ 0x2143, 0x20A0E },
	{ 0x2144, 0x5383 },
	{ 0x2145, 0x53B8 },
	{ 0x2146, 0x20B9C },
	{ 0x2147, 0x20B9B },
	{ 0x2148, 0x2123C },
	{ 0x2149, 0x5928 },
	{ 0x214A, 0x21BC2 },
	{ 0x214B, 0x5C23 },
	{ 0x214C, 0x5E01 },
	{ 0x214D, 0x5F00 },
	{ 0x214E, 0x233B4 },
	{ 0x214F, 0x3CB8 },
	{ 0x2150, 0x706C },
	{ 0x2151, 0x722B },
	{ 0x2152, 0x5188 },
	{ 0x2153, 0x8279 },
	{ 0x2154, 0x8FB6 },
	{ 0x2155, 0x4E17 },
	{ 0x2156, 0x20065 },
	{ 0x2157, 0x340C },
	{ 0x2158, 0x201B2 },
	{ 0x2159, 0x3430 },
	{ 0x215A, 0x4EE2 },
	{ 0x215B, 0x4EDB },
	{ 0x215C, 0x20477 },
	{ 0x215D, 0x20542 },
	{ 0x215E, 0x51AD },
	{ 0x215F, 0x20633 },
	{ 0x2160, 0x51F7 },
	{ 0x2161, 0x34DA },
	{ 0x2162, 0x206AF },
	{ 0x2163, 0x20836 },
	{ 0x2164, 0x3513 },
	{ 0x2165, 0x531B },
	{ 0x2166, 0x5388 },
	{ 0x2167, 0x5387 },
	{ 0x2168, 0x20B22 },
	{ 0x2169, 0x53CF },
	{ 0x216A, 0x53FD },
	{ 0x216B, 0x3563 },
	{ 0x216C, 0x53E7 },
	{ 0x216D, 0x56DC },
	{ 0x216E, 0x211A3 },
	{ 0x216F, 0x56D9 },
	{ 0x2170, 0x5725 },
	{ 0x2171, 0x5727 },
	{ 0x2172, 0x5933 },
	{ 0x2173, 0x5C13 },
	{ 0x2174, 0x21C25 },
	{ 0x2175, 0x21C24 },
	{ 0x2176, 0x5C75 },
	{ 0x2177, 0x22052 },
	{ 0x2178, 0x22189 },
	{ 0x2179, 0x224BF },
	{ 0x217A, 0x39C4 },
	{ 0x217B, 0x39C3 },
	{ 0x217C, 0x66F1 },
	{ 0x217D, 0x233B5 },
	{ 0x217E, 0x2574C },
	{ 0x2221, 0x7F52 },
	{ 0x2222, 0x28E14 },
	{ 0x2223, 0x28E12 },
	{ 0x2224, 0x3401 },
	{ 0x2225, 0x200A3 },
	{ 0x2226, 0x200A2 },
	{ 0x2227, 0x4E51 },
	{ 0x2228, 0x4E6A },
	{ 0x2229, 0x201B6 },
	{ 0x222A, 0x4F0C },
	{ 0x222B, 0x201B5 },
	{ 0x222C, 0x201B4 },
	{ 0x222D, 0x4EFE },
	{ 0x222E, 0x4F1B },
	{ 0x222F, 0x201C2 },
	{ 0x2230, 0x201B8 },
	{ 0x2231, 0x343A },
	{ 0x2232, 0x20479 },
	{ 0x2233, 0x34AB },
	{ 0x2234, 0x5173 },
	{ 0x2235, 0x20508 },
	{ 0x2236, 0x518E },
	{ 0x2237, 0x2057A },
	{ 0x2238, 0x205B6 },
	{ 0x2239, 0x206BD },
	{ 0x223A, 0x206B7 },
	{ 0x223B, 0x206BC },
	{ 0x223C, 0x34DD },
	{ 0x223D, 0x206C4 },
	{ 0x223E, 0x206C9 },
	{ 0x223F, 0x52A5 },
	{ 0x2240, 0x3515 },
	{ 0x2241, 0x52A7 },
	{ 0x2242, 0x52A4 },
	{ 0x2243, 0x20930 },
	{ 0x2244, 0x20983 },
	{ 0x2245, 0x20985 },
	{ 0x2246, 0x20A12 },
	{ 0x2247, 0x20A34 },
	{ 0x2248, 0x53BD },
	{ 0x2249, 0x20AE4 },
	{ 0x224A, 0x20ADE },
	{ 0x224B, 0x20B2A },
	{ 0x224C, 0x5402 },
	{ 0x224D, 0x20BAF },
	{ 0x224E, 0x20BB4 },
	{ 0x224F, 0x20BB3 },
	{ 0x2250, 0x20BB1 },
	{ 0x2251, 0x572B },
	{ 0x2252, 0x591B },
	{ 0x2253, 0x5935 },
	{ 0x2254, 0x215DE },
	{ 0x2255, 0x36A7 },
	{ 0x2256, 0x36A5 },
	{ 0x2257, 0x216B8 },
	{ 0x2258, 0x216B0 },
	{ 0x2259, 0x36A6 },
	{ 0x225A, 0x219C2 },
	{ 0x225C, 0x5C17 },
	{ 0x225D, 0x377C },
	{ 0x225E, 0x21C2A },
	{ 0x225F, 0x5C70 },
	{ 0x2260, 0x5C7D },
	{ 0x2261, 0x37A9 },
	{ 0x2262, 0x21FE9 },
	{ 0x2263, 0x5DE9 },
	{ 0x2264, 0x22057 },
	{ 0x2265, 0x3834 },
	{ 0x2266, 0x3835 },
	{ 0x2267, 0x221B6 },
	{ 0x2268, 0x221D7 },
	{ 0x2269, 0x221DE },
	{ 0x226A, 0x38A8 },
	{ 0x226B, 0x5F19 },
	{ 0x226C, 0x5F1C },
	{ 0x226D, 0x5F75 },
	{ 0x226E, 0x224C2 },
	{ 0x226F, 0x225AB },
	{ 0x2270, 0x38FF },
	{ 0x2271, 0x5FC8 },
	{ 0x2272, 0x2298F },
	{ 0x2273, 0x39C7 },
	{ 0x2274, 0x39C6 },
	{ 0x2275, 0x39C8 },
	{ 0x2276, 0x22A6D },
	{ 0x2277, 0x22EB5 },
	{ 0x2278, 0x3AD0 },
	{ 0x2279, 0x3AD1 },
	{ 0x227A, 0x233C0 },
	{ 0x227B, 0x233BF },
	{ 0x227C, 0x3C59 },
	{ 0x227D, 0x239B9 },
	{ 0x227E, 0x23B1C },
	{ 0x2321, 0x6C12 },
	{ 0x2322, 0x3CBD },
	{ 0x2323, 0x23C80 },
	{ 0x2324, 0x24184 },
	{ 0x2325, 0x24185 },
	{ 0x2326, 0x3E28 },
	{ 0x2327, 0x72B3 },
	{ 0x2328, 0x24724 },
	{ 0x2329, 0x3EA9 },
	{ 0x232A, 0x7390 },
	{ 0x232B, 0x7536 },
	{ 0x232C, 0x2634C },
	{ 0x232D, 0x43CC },
	{ 0x232E, 0x26AF6 },
	{ 0x232F, 0x8281 },
	{ 0x2330, 0x8FB8 },
	{ 0x2331, 0x28670 },
	{ 0x2332, 0x48B4 },
	{ 0x2333, 0x28675 },
	{ 0x2334, 0x28E17 },
	{ 0x2335, 0x4E23 },
	{ 0x2336, 0x3416 },
	{ 0x2337, 0x342C },
	{ 0x2338, 0x201F1 },
	{ 0x2339, 0x4F2E },
	{ 0x233A, 0x201DA },
	{ 0x233B, 0x514F },
	{ 0x233C, 0x205B9 },
	{ 0x233D, 0x51BA },
	{ 0x233E, 0x34DF },
	{ 0x233F, 0x34E0 },
	{ 0x2340, 0x5222 },
	{ 0x2341, 0x206CE },
	{ 0x2342, 0x206D2 },
	{ 0x2343, 0x206D0 },
	{ 0x2344, 0x3517 },
	{ 0x2345, 0x20843 },
	{ 0x2346, 0x52AF },
	{ 0x2347, 0x52B0 },
	{ 0x2348, 0x52B1 },
	{ 0x2349, 0x2084D },
	{ 0x234A, 0x20934 },
	{ 0x234B, 0x352F },
	{ 0x234C, 0x209D9 },
	{ 0x234D, 0x5364 },
	{ 0x234E, 0x20A18 },
	{ 0x234F, 0x53D3 },
	{ 0x2350, 0x20B38 },
	{ 0x2351, 0x356A },
	{ 0x2352, 0x20BD7 },
	{ 0x2353, 0x3570 },
	{ 0x2354, 0x356D },
	{ 0x2355, 0x20BDC },
	{ 0x2356, 0x20BCB },
	{ 0x2357, 0x20BD6 },
	{ 0x2358, 0x20BD8 },
	{ 0x2359, 0x356E },
	{ 0x235A, 0x20BD1 },
	{ 0x235B, 0x2F83E },
	{ 0x235C, 0x2F83C },
	{ 0x235D, 0x20BD2 },
	{ 0x235E, 0x362B },
	{ 0x235F, 0x3628 },
	{ 0x2360, 0x21259 },
	{ 0x2362, 0x593F },
	{ 0x2363, 0x215E5 },
	{ 0x2364, 0x215E6 },
	{ 0x2365, 0x3692 },
	{ 0x2366, 0x215E8 },
	{ 0x2367, 0x598B },
	{ 0x2368, 0x216BD },
	{ 0x2369, 0x5991 },
	{ 0x236A, 0x5995 },
	{ 0x236B, 0x216BE },
	{ 0x236C, 0x21949 },
	{ 0x236D, 0x373F },
	{ 0x236E, 0x219CD },
	{ 0x236F, 0x5B8A },
	{ 0x2370, 0x374F },
	{ 0x2371, 0x3774 },
	{ 0x2372, 0x21B5E },
	{ 0x2373, 0x21BD0 },
	{ 0x2374, 0x377D },
	{ 0x2375, 0x21D06 },
	{ 0x2376, 0x37B7 },
	{ 0x2377, 0x37A3 },
	{ 0x2378, 0x37B0 },
	{ 0x2379, 0x37B1 },
	{ 0x237A, 0x5C87 },
	{ 0x237B, 0x37AB },
	{ 0x237C, 0x21D7C },
	{ 0x237D, 0x21D71 },
	{ 0x237E, 0x21FEF },
	{ 0x2421, 0x383A },
	{ 0x2422, 0x3837 },
	{ 0x2423, 0x5E0D },
	{ 0x2424, 0x3838 },
	{ 0x2425, 0x3840 },
	{ 0x2426, 0x2218D },
	{ 0x2427, 0x221B7 },
	{ 0x2428, 0x5E8E },
	{ 0x2429, 0x389F },
	{ 0x242A, 0x22333 },
	{ 0x242B, 0x2237F },
	{ 0x242C, 0x5F7A },
	{ 0x242D, 0x225F2 },
	{ 0x242E, 0x3904 },
	{ 0x242F, 0x3909 },
	{ 0x2430, 0x3906 },
	{ 0x2431, 0x38FD },
	{ 0x2432, 0x390A },
	{ 0x2433, 0x3907 },
	{ 0x2434, 0x22A2A },
	{ 0x2435, 0x22A8B },
	{ 0x2436, 0x39CA },
	{ 0x2437, 0x22A83 },
	{ 0x2438, 0x22A8A },
	{ 0x2439, 0x6290 },
	{ 0x243A, 0x39C9 },
	{ 0x243B, 0x22A8E },
	{ 0x243C, 0x629A },
	{ 0x243D, 0x22EB6 },
	{ 0x243E, 0x653C },
	{ 0x243F, 0x653A },
	{ 0x2440, 0x3A7F },
	{ 0x2441, 0x6598 },
	{ 0x2442, 0x230D8 },
	{ 0x2443, 0x3AD2 },
	{ 0x2444, 0x23156 },
	{ 0x2445, 0x233D2 },
	{ 0x2446, 0x6765 },
	{ 0x2447, 0x2F8DB },
	{ 0x2448, 0x3B43 },
	{ 0x2449, 0x233C2 },
	{ 0x244A, 0x23887 },
	{ 0x244B, 0x23881 },
	{ 0x244C, 0x239C2 },
	{ 0x244D, 0x239BC },
	{ 0x244E, 0x23B23 },
	{ 0x244F, 0x3CC1 },
	{ 0x2450, 0x23C93 },
	{ 0x2451, 0x3CC5 },
	{ 0x2452, 0x3DA3 },
	{ 0x2453, 0x2418D },
	{ 0x2454, 0x2418E },
	{ 0x2455, 0x3E2A },
	{ 0x2456, 0x3E5F },
	{ 0x2457, 0x2473B },
	{ 0x2458, 0x2474D },
	{ 0x2459, 0x3E5D },
	{ 0x245A, 0x24734 },
	{ 0x245B, 0x24731 },
	{ 0x245C, 0x248F2 },
	{ 0x245D, 0x248F0 },
	{ 0x245E, 0x3F17 },
	{ 0x245F, 0x24C15 },
	{ 0x2460, 0x24D28 },
	{ 0x2461, 0x3F71 },
	{ 0x2462, 0x3F72 },
	{ 0x2463, 0x24F25 },
	{ 0x2464, 0x250E7 },
	{ 0x2465, 0x400F },
	{ 0x2466, 0x250E9 },
	{ 0x2467, 0x25417 },
	{ 0x2468, 0x79C2 },
	{ 0x2469, 0x4191 },
	{ 0x246A, 0x2626C },
	{ 0x246B, 0x26280 },
	{ 0x246C, 0x2634B },
	{ 0x246D, 0x43B2 },
	{ 0x246E, 0x43CF },
	{ 0x246F, 0x43CE },
	{ 0x2470, 0x809E },
	{ 0x2471, 0x268DE },
	{ 0x2472, 0x268FB },
	{ 0x2473, 0x81EB },
	{ 0x2474, 0x26951 },
	{ 0x2475, 0x8289 },
	{ 0x2476, 0x4496 },
	{ 0x2477, 0x26B01 },
	{ 0x2478, 0x26B02 },
	{ 0x2479, 0x8296 },
	{ 0x247A, 0x26B05 },
	{ 0x247B, 0x8287 },
	{ 0x247C, 0x26B03 },
	{ 0x247D, 0x4497 },
	{ 0x247E, 0x28451 },
	{ 0x2521, 0x8FC0 },
	{ 0x2522, 0x488B },
	{ 0x2523, 0x8FC3 },
	{ 0x2524, 0x28453 },
	{ 0x2525, 0x2867A },
	{ 0x2526, 0x28678 },
	{ 0x2527, 0x28676 },
	{ 0x2528, 0x28679 },
	{ 0x2529, 0x2868F },
	{ 0x252A, 0x2867C },
	{ 0x252B, 0x9578 },
	{ 0x252C, 0x28E1B },
	{ 0x252D, 0x28E1C },
	{ 0x252E, 0x9625 },
	{ 0x252F, 0x23D92 },
	{ 0x2530, 0x4E75 },
	{ 0x2531, 0x4E74 },
	{ 0x2532, 0x2012E },
	{ 0x2533, 0x2012C },
	{ 0x2534, 0x342D },
	{ 0x2535, 0x2020C },
	{ 0x2536, 0x4F99 },
	{ 0x2537, 0x2020B },
	{ 0x2538, 0x3450 },
	{ 0x2539, 0x344B },
	{ 0x253A, 0x20205 },
	{ 0x253B, 0x344F },
	{ 0x253C, 0x344C },
	{ 0x253D, 0x2F805 },
	{ 0x253E, 0x4F71 },
	{ 0x253F, 0x5153 },
	{ 0x2540, 0x51BF },
	{ 0x2541, 0x205C2 },
	{ 0x2542, 0x205C3 },
	{ 0x2543, 0x51C0 },
	{ 0x2544, 0x20648 },
	{ 0x2545, 0x51EE },
	{ 0x2546, 0x20646 },
	{ 0x2547, 0x34E4 },
	{ 0x2548, 0x34E3 },
	{ 0x2549, 0x206EA },
	{ 0x254A, 0x34E1 },
	{ 0x254B, 0x206EB },
	{ 0x254C, 0x34E2 },
	{ 0x254D, 0x206EE },
	{ 0x254E, 0x523D },
	{ 0x254F, 0x3519 },
	{ 0x2550, 0x52BD },
	{ 0x2551, 0x530C },
	{ 0x2552, 0x208D8 },
	{ 0x2553, 0x24C1E },
	{ 0x2554, 0x209DF },
	{ 0x2555, 0x209DE },
	{ 0x2556, 0x3541 },
	{ 0x2557, 0x7F37 },
	{ 0x2558, 0x20A4F },
	{ 0x2559, 0x53C0 },
	{ 0x255A, 0x355E },
	{ 0x255B, 0x20C0D },
	{ 0x255C, 0x20C08 },
	{ 0x255D, 0x3579 },
	{ 0x255E, 0x20C09 },
	{ 0x255F, 0x546E },
	{ 0x2560, 0x5483 },
	{ 0x2561, 0x20C12 },
	{ 0x2562, 0x20C65 },
	{ 0x2563, 0x545E },
	{ 0x2564, 0x545D },
	{ 0x2565, 0x577E },
	{ 0x2566, 0x5779 },
	{ 0x2567, 0x21289 },
	{ 0x2568, 0x577A },
	{ 0x2569, 0x576C },
	{ 0x256A, 0x21284 },
	{ 0x256B, 0x2129E },
	{ 0x256C, 0x2128B },
	{ 0x256D, 0x3632 },
	{ 0x256E, 0x5787 },
	{ 0x256F, 0x21562 },
	{ 0x2570, 0x591D },
	{ 0x2571, 0x3694 },
	{ 0x2572, 0x5946 },
	{ 0x2573, 0x3697 },
	{ 0x2574, 0x215F9 },
	{ 0x2575, 0x5943 },
	{ 0x2576, 0x215F7 },
	{ 0x2577, 0x3696 },
	{ 0x2578, 0x3698 },
	{ 0x2579, 0x21606 },
	{ 0x257A, 0x216DD },
	{ 0x257B, 0x36B2 },
	{ 0x257C, 0x216D9 },
	{ 0x257D, 0x216DF },
	{ 0x257E, 0x216E2 },
	{ 0x2621, 0x36B9 },
	{ 0x2622, 0x5B61 },
	{ 0x2623, 0x5B66 },
	{ 0x2624, 0x200F1 },
	{ 0x2625, 0x5B90 },
	{ 0x2626, 0x3775 },
	{ 0x2627, 0x377F },
	{ 0x2628, 0x377E },
	{ 0x2629, 0x5C29 },
	{ 0x262A, 0x378F },
	{ 0x262B, 0x21C3F },
	{ 0x262C, 0x21C3E },
	{ 0x262D, 0x21D0B },
	{ 0x262E, 0x37BD },
	{ 0x262F, 0x5CB2 },
	{ 0x2630, 0x21D83 },
	{ 0x2631, 0x37BB },
	{ 0x2632, 0x37BC },
	{ 0x2633, 0x21D86 },
	{ 0x2634, 0x5CC0 },
	{ 0x2635, 0x2207C },
	{ 0x2636, 0x383D },
	{ 0x2637, 0x383E },
	{ 0x2638, 0x3874 },
	{ 0x2639, 0x221F7 },
	{ 0x263A, 0x387A },
	{ 0x263B, 0x3876 },
	{ 0x263C, 0x3878 },
	{ 0x263D, 0x3875 },
	{ 0x263E, 0x221FB },
	{ 0x263F, 0x2233B },
	{ 0x2640, 0x38AF },
	{ 0x2641, 0x38B0 },
	{ 0x2642, 0x38C7 },
	{ 0x2643, 0x38CC },
	{ 0x2644, 0x225F9 },
	{ 0x2645, 0x225CA },
	{ 0x2646, 0x3916 },
	{ 0x2647, 0x225FF },
	{ 0x2648, 0x3912 },
	{ 0x2649, 0x391D },
	{ 0x264A, 0x22609 },
	{ 0x264B, 0x22603 },
	{ 0x264C, 0x3915 },
	{ 0x264D, 0x390F },
	{ 0x264E, 0x3914 },
	{ 0x264F, 0x601F },
	{ 0x2650, 0x5FE2 },
	{ 0x2651, 0x22610 },
	{ 0x2652, 0x2299A },
	{ 0x2653, 0x2299F },
	{ 0x2654, 0x39B0 },
	{ 0x2655, 0x39BF },
	{ 0x2656, 0x39C0 },
	{ 0x2657, 0x22A87 },
	{ 0x2658, 0x39D2 },
	{ 0x2659, 0x39D9 },
	{ 0x265A, 0x22EB7 },
	{ 0x265B, 0x3A7A },
	{ 0x265C, 0x22F08 },
	{ 0x265D, 0x22EF9 },
	{ 0x265E, 0x3A81 },
	{ 0x265F, 0x3A82 },
	{ 0x2660, 0x22EF4 },
	{ 0x2661, 0x6616 },
	{ 0x2662, 0x65F9 },
	{ 0x2663, 0x3ADA },
	{ 0x2664, 0x26657 },
	{ 0x2665, 0x6788 },
	{ 0x2666, 0x233D6 },
	{ 0x2667, 0x679B },
	{ 0x2668, 0x2F8DE },
	{ 0x2669, 0x676E },
	{ 0x266A, 0x679E },
	{ 0x266B, 0x233D4 },
	{ 0x266C, 0x3C22 },
	{ 0x266D, 0x3C1F },
	{ 0x266E, 0x23890 },
	{ 0x266F, 0x2388D },
	{ 0x2670, 0x3C21 },
	{ 0x2671, 0x6B24 },
	{ 0x2672, 0x23960 },
	{ 0x2673, 0x239CE },
	{ 0x2674, 0x239CF },
	{ 0x2675, 0x3C5C },
	{ 0x2676, 0x6B7D },
	{ 0x2677, 0x239D1 },
	{ 0x2678, 0x3C7D },
	{ 0x2679, 0x3C8D },
	{ 0x267A, 0x3C8F },
	{ 0x267B, 0x6CE6 },
	{ 0x267C, 0x23CCA },
	{ 0x267D, 0x6CCB },
	{ 0x267E, 0x3CD0 },
	{ 0x2721, 0x23CB7 },
	{ 0x2722, 0x3CD8 },
	{ 0x2723, 0x23CB2 },
	{ 0x2724, 0x23CBB },
	{ 0x2725, 0x23CB9 },
	{ 0x2726, 0x6CB5 },
	{ 0x2727, 0x3DA7 },
	{ 0x2728, 0x2419E },
	{ 0x2729, 0x7097 },
	{ 0x272A, 0x241B2 },
	{ 0x272B, 0x709B },
	{ 0x272C, 0x3E12 },
	{ 0x272D, 0x2456F },
	{ 0x272E, 0x245AC },
	{ 0x272F, 0x3E2F },
	{ 0x2730, 0x24623 },
	{ 0x2731, 0x726B },
	{ 0x2732, 0x3E2E },
	{ 0x2733, 0x3E2C },
	{ 0x2734, 0x3E5C },
	{ 0x2735, 0x2476C },
	{ 0x2736, 0x72D5 },
	{ 0x2737, 0x24732 },
	{ 0x2738, 0x2475E },
	{ 0x2739, 0x3E62 },
	{ 0x273A, 0x3E67 },
	{ 0x273B, 0x3EB4 },
	{ 0x273C, 0x248FB },
	{ 0x273D, 0x24B29 },
	{ 0x273E, 0x24BBD },
	{ 0x273F, 0x24C1F },
	{ 0x2740, 0x7543 },
	{ 0x2741, 0x22341 },
	{ 0x2742, 0x24C1D },
	{ 0x2743, 0x759C },
	{ 0x2744, 0x24D31 },
	{ 0x2745, 0x24D2F },
	{ 0x2746, 0x3FEA },
	{ 0x2747, 0x25043 },
	{ 0x2748, 0x3FFB },
	{ 0x2749, 0x25041 },
	{ 0x274A, 0x4014 },
	{ 0x274B, 0x250F5 },
	{ 0x274C, 0x4013 },
	{ 0x274D, 0x4012 },
	{ 0x274E, 0x4010 },
	{ 0x274F, 0x4011 },
	{ 0x2750, 0x250F2 },
	{ 0x2751, 0x4086 },
	{ 0x2752, 0x77E4 },
	{ 0x2753, 0x4098 },
	{ 0x2754, 0x2541E },
	{ 0x2755, 0x25754 },
	{ 0x2756, 0x412A },
	{ 0x2757, 0x25756 },
	{ 0x2758, 0x25929 },
	{ 0x2759, 0x25927 },
	{ 0x275A, 0x25928 },
	{ 0x275B, 0x7ACE },
	{ 0x275C, 0x42B5 },
	{ 0x275D, 0x26279 },
	{ 0x275E, 0x2627E },
	{ 0x275F, 0x264B6 },
	{ 0x2760, 0x264B7 },
	{ 0x2761, 0x8013 },
	{ 0x2762, 0x43D6 },
	{ 0x2763, 0x43D8 },
	{ 0x2764, 0x80B7 },
	{ 0x2765, 0x43D9 },
	{ 0x2766, 0x43D4 },
	{ 0x2767, 0x43D7 },
	{ 0x2768, 0x2F981 },
	{ 0x2769, 0x80B9 },
	{ 0x276B, 0x2664D },
	{ 0x276C, 0x81E4 },
	{ 0x276D, 0x81FD },
	{ 0x276E, 0x820F },
	{ 0x276F, 0x4460 },
	{ 0x2770, 0x26A09 },
	{ 0x2771, 0x26A08 },
	{ 0x2772, 0x449E },
	{ 0x2773, 0x44A1 },
	{ 0x2774, 0x26B1E },
	{ 0x2775, 0x26B1A },
	{ 0x2776, 0x26B23 },
	{ 0x2777, 0x26B15 },
	{ 0x2778, 0x26B19 },
	{ 0x2779, 0x26B16 },
	{ 0x277A, 0x82BF },
	{ 0x277B, 0x82CA },
	{ 0x277C, 0x26B14 },
	{ 0x277D, 0x26B18 },
	{ 0x277E, 0x82C1 },
	{ 0x2821, 0x44A0 },
	{ 0x2822, 0x2721F },
	{ 0x2823, 0x275DD },
	{ 0x2824, 0x275DF },
	{ 0x2825, 0x28469 },
	{ 0x2826, 0x8FD0 },
	{ 0x2828, 0x2846C },
	{ 0x2829, 0x48B9 },
	{ 0x282A, 0x28693 },
	{ 0x282B, 0x90AE },
	{ 0x282C, 0x28695 },
	{ 0x282D, 0x28694 },
	{ 0x282E, 0x28691 },
	{ 0x282F, 0x28697 },
	{ 0x2830, 0x28E30 },
	{ 0x2831, 0x49C1 },
	{ 0x2832, 0x49C2 },
	{ 0x2833, 0x9638 },
	{ 0x2834, 0x2FA18 },
	{ 0x2835, 0x341C },
	{ 0x2836, 0x20231 },
	{ 0x2837, 0x345E },
	{ 0x2838, 0x4FBC },
	{ 0x2839, 0x3459 },
	{ 0x283A, 0x345C },
	{ 0x283B, 0x20236 },
	{ 0x283C, 0x345F },
	{ 0x283D, 0x4FE9 },
	{ 0x283E, 0x4FBD },
	{ 0x283F, 0x4FE2 },
	{ 0x2840, 0x5158 },
	{ 0x2841, 0x205C9 },
	{ 0x2842, 0x205CA },
	{ 0x2843, 0x34CE },
	{ 0x2844, 0x20718 },
	{ 0x2845, 0x20712 },
	{ 0x2846, 0x20719 },
	{ 0x2847, 0x20710 },
	{ 0x2848, 0x20716 },
	{ 0x2849, 0x52C6 },
	{ 0x284A, 0x2085F },
	{ 0x284B, 0x52C8 },
	{ 0x284C, 0x208DF },
	{ 0x284D, 0x20917 },
	{ 0x284E, 0x5328 },
	{ 0x284F, 0x2093C },
	{ 0x2850, 0x5329 },
	{ 0x2851, 0x209EA },
	{ 0x2852, 0x209E9 },
	{ 0x2853, 0x20A1C },
	{ 0x2854, 0x20A58 },
	{ 0x2855, 0x20A64 },
	{ 0x2856, 0x20AF3 },
	{ 0x2857, 0x355F },
	{ 0x2858, 0x20C97 },
	{ 0x2859, 0x3585 },
	{ 0x285A, 0x20C5A },
	{ 0x285B, 0x20C59 },
	{ 0x285C, 0x3586 },
	{ 0x285D, 0x20C8E },
	{ 0x285E, 0x57B4 },
	{ 0x285F, 0x212BC },
	{ 0x2860, 0x57A9 },
	{ 0x2861, 0x3687 },
	{ 0x2862, 0x2160D },
	{ 0x2863, 0x215FC },
	{ 0x2864, 0x2160C },
	{ 0x2865, 0x21707 },
	{ 0x2866, 0x2170A },
	{ 0x2867, 0x36CA },
	{ 0x2868, 0x21702 },
	{ 0x2869, 0x36C3 },
	{ 0x286A, 0x21726 },
	{ 0x286B, 0x21708 },
	{ 0x286C, 0x2171D },
	{ 0x286D, 0x36C2 },
	{ 0x286E, 0x5B68 },
	{ 0x286F, 0x2194E },
	{ 0x2870, 0x3741 },
	{ 0x2871, 0x219ED },
	{ 0x2872, 0x219EE },
	{ 0x2873, 0x219EF },
	{ 0x2874, 0x3780 },
	{ 0x2875, 0x3781 },
	{ 0x2876, 0x21C50 },
	{ 0x2877, 0x21C4C },
	{ 0x2878, 0x3793 },
	{ 0x2879, 0x3792 },
	{ 0x287A, 0x21C4F },
	{ 0x287B, 0x37C5 },
	{ 0x287C, 0x21DD4 },
	{ 0x287E, 0x21DB0 },
	{ 0x2921, 0x3846 },
	{ 0x2922, 0x3841 },
	{ 0x2923, 0x3845 },
	{ 0x2924, 0x3842 },
	{ 0x2925, 0x383F },
	{ 0x2926, 0x220A5 },
	{ 0x2927, 0x22209 },
	{ 0x2928, 0x3882 },
	{ 0x2929, 0x3881 },
	{ 0x292A, 0x387F },
	{ 0x292B, 0x38A5 },
	{ 0x292C, 0x5F2B },
	{ 0x292D, 0x38B3 },
	{ 0x292E, 0x38B5 },
	{ 0x292F, 0x223F3 },
	{ 0x2930, 0x223D7 },
	{ 0x2931, 0x5F8D },
	{ 0x2932, 0x38DA },
	{ 0x2933, 0x224DC },
	{ 0x2934, 0x38DB },
	{ 0x2935, 0x390D },
	{ 0x2936, 0x6018 },
	{ 0x2937, 0x390E },
	{ 0x2938, 0x2260B },
	{ 0x2939, 0x391E },
	{ 0x293A, 0x3925 },
	{ 0x293B, 0x3926 },
	{ 0x293C, 0x391C },
	{ 0x293D, 0x3921 },
	{ 0x293E, 0x6057 },
	{ 0x293F, 0x6048 },
	{ 0x2940, 0x3927 },
	{ 0x2941, 0x391A },
	{ 0x2942, 0x2263A },
	{ 0x2943, 0x2260D },
	{ 0x2944, 0x22611 },
	{ 0x2945, 0x6038 },
	{ 0x2946, 0x22620 },
	{ 0x2947, 0x22601 },
	{ 0x2948, 0x3924 },
	{ 0x2949, 0x22637 },
	{ 0x294A, 0x2F8A3 },
	{ 0x294B, 0x6071 },
	{ 0x294C, 0x229AA },
	{ 0x294D, 0x39C1 },
	{ 0x294E, 0x39E1 },
	{ 0x294F, 0x22AE7 },
	{ 0x2950, 0x22AE8 },
	{ 0x2951, 0x6312 },
	{ 0x2952, 0x39EB },
	{ 0x2953, 0x22AF5 },
	{ 0x2954, 0x39E2 },
	{ 0x2955, 0x39D7 },
	{ 0x2956, 0x39E9 },
	{ 0x2957, 0x22B35 },
	{ 0x2958, 0x22AE6 },
	{ 0x2959, 0x630A },
	{ 0x295A, 0x22AF8 },
	{ 0x295B, 0x6323 },
	{ 0x295C, 0x22AF1 },
	{ 0x295D, 0x3A84 },
	{ 0x295E, 0x22F14 },
	{ 0x295F, 0x22F15 },
	{ 0x2960, 0x22F09 },
	{ 0x2961, 0x3AB5 },
	{ 0x2962, 0x3ABC },
	{ 0x2963, 0x3ADC },
	{ 0x2964, 0x3ADE },
	{ 0x2965, 0x3ADF },
	{ 0x2966, 0x2317B },
	{ 0x2967, 0x662A },
	{ 0x2968, 0x2317E },
	{ 0x2969, 0x23366 },
	{ 0x296A, 0x23367 },
	{ 0x296B, 0x2340A },
	{ 0x296C, 0x3B54 },
	{ 0x296D, 0x67E0 },
	{ 0x296E, 0x67BE },
	{ 0x296F, 0x3B53 },
	{ 0x2970, 0x3C24 },
	{ 0x2971, 0x3C25 },
	{ 0x2972, 0x6B29 },
	{ 0x2973, 0x3C28 },
	{ 0x2974, 0x3C27 },
	{ 0x2975, 0x2389C },
	{ 0x2976, 0x23962 },
	{ 0x2977, 0x239E1 },
	{ 0x2978, 0x239DE },
	{ 0x2979, 0x239DF },
	{ 0x297A, 0x239E9 },
	{ 0x297B, 0x3C8B },
	{ 0x297C, 0x23CE4 },
	{ 0x297D, 0x23CF7 },
	{ 0x297E, 0x3CDC },
	{ 0x2A21, 0x6D43 },
	{ 0x2A22, 0x23CEA },
	{ 0x2A23, 0x23CF6 },
	{ 0x2A24, 0x23D12 },
	{ 0x2A25, 0x2F901 },
	{ 0x2A26, 0x70A6 },
	{ 0x2A27, 0x3DB2 },
	{ 0x2A28, 0x70C0 },
	{ 0x2A29, 0x241D9 },
	{ 0x2A2A, 0x722F },
	{ 0x2A2B, 0x2455F },
	{ 0x2A2C, 0x3E1B },
	{ 0x2A2D, 0x24573 },
	{ 0x2A2E, 0x3E32 },
	{ 0x2A2F, 0x7271 },
	{ 0x2A30, 0x2463F },
	{ 0x2A31, 0x24778 },
	{ 0x2A32, 0x3E6B },
	{ 0x2A33, 0x2477D },
	{ 0x2A34, 0x3E6C },
	{ 0x2A35, 0x3E6D },
	{ 0x2A36, 0x24912 },
	{ 0x2A37, 0x3EB9 },
	{ 0x2A38, 0x3EBA },
	{ 0x2A39, 0x3F09 },
	{ 0x2A3A, 0x3F0A },
	{ 0x2A3B, 0x24B2F },
	{ 0x2A3C, 0x74EA },
	{ 0x2A3D, 0x3F1B },
	{ 0x2A3E, 0x24B30 },
	{ 0x2A3F, 0x24BDB },
	{ 0x2A40, 0x7520 },
	{ 0x2A41, 0x3F58 },
	{ 0x2A42, 0x24C29 },
	{ 0x2A43, 0x3F5A },
	{ 0x2A44, 0x2F936 },
	{ 0x2A45, 0x24D40 },
	{ 0x2A46, 0x3F77 },
	{ 0x2A47, 0x24D3D },
	{ 0x2A48, 0x24D3E },
	{ 0x2A49, 0x3F79 },
	{ 0x2A4A, 0x75A9 },
	{ 0x2A4B, 0x24D38 },
	{ 0x2A4C, 0x7685 },
	{ 0x2A4D, 0x24F48 },
	{ 0x2A4E, 0x3FEB },
	{ 0x2A4F, 0x24FD0 },
	{ 0x2A50, 0x3FFD },
	{ 0x2A51, 0x3FFC },
	{ 0x2A52, 0x7706 },
	{ 0x2A53, 0x4015 },
	{ 0x2A54, 0x4018 },
	{ 0x2A55, 0x76F6 },
	{ 0x2A56, 0x4016 },
	{ 0x2A57, 0x4017 },
	{ 0x2A58, 0x4019 },
	{ 0x2A59, 0x7700 },
	{ 0x2A5A, 0x401B },
	{ 0x2A5B, 0x2510E },
	{ 0x2A5C, 0x25109 },
	{ 0x2A5D, 0x7702 },
	{ 0x2A5E, 0x25107 },
	{ 0x2A5F, 0x4087 },
	{ 0x2A60, 0x2535F },
	{ 0x2A61, 0x25360 },
	{ 0x2A62, 0x409C },
	{ 0x2A63, 0x2542A },
	{ 0x2A64, 0x409A },
	{ 0x2A65, 0x25429 },
	{ 0x2A66, 0x40FF },
	{ 0x2A67, 0x40FE },
	{ 0x2A68, 0x2564D },
	{ 0x2A69, 0x4131 },
	{ 0x2A6A, 0x412E },
	{ 0x2A6B, 0x4130 },
	{ 0x2A6C, 0x4132 },
	{ 0x2A6D, 0x2576C },
	{ 0x2A6F, 0x412F },
	{ 0x2A70, 0x25767 },
	{ 0x2A71, 0x4195 },
	{ 0x2A72, 0x4196 },
	{ 0x2A73, 0x25939 },
	{ 0x2A74, 0x25934 },
	{ 0x2A75, 0x25A59 },
	{ 0x2A76, 0x41C5 },
	{ 0x2A77, 0x427A },
	{ 0x2A78, 0x26223 },
	{ 0x2A79, 0x4342 },
	{ 0x2A7A, 0x26282 },
	{ 0x2A7B, 0x4354 },
	{ 0x2A7C, 0x26283 },
	{ 0x2A7D, 0x262A8 },
	{ 0x2A7E, 0x26355 },
	{ 0x2B21, 0x263F9 },
	{ 0x2B22, 0x263F8 },
	{ 0x2B23, 0x263FC },
	{ 0x2B24, 0x263FA },
	{ 0x2B25, 0x8009 },
	{ 0x2B26, 0x2F97A },
	{ 0x2B27, 0x439F },
	{ 0x2B28, 0x43A0 },
	{ 0x2B29, 0x43A2 },
	{ 0x2B2A, 0x43E0 },
	{ 0x2B2B, 0x26674 },
	{ 0x2B2C, 0x43E1 },
	{ 0x2B2D, 0x2666B },
	{ 0x2B2E, 0x26671 },
	{ 0x2B2F, 0x43DF },
	{ 0x2B30, 0x26676 },
	{ 0x2B31, 0x26A0E },
	{ 0x2B32, 0x4462 },
	{ 0x2B33, 0x4461 },
	{ 0x2B34, 0x26A10 },
	{ 0x2B35, 0x26A0F },
	{ 0x2B36, 0x44A7 },
	{ 0x2B37, 0x26B38 },
	{ 0x2B38, 0x26B39 },
	{ 0x2B39, 0x26B3A },
	{ 0x2B3A, 0x82DA },
	{ 0x2B3B, 0x26B37 },
	{ 0x2B3C, 0x26B3E },
	{ 0x2B3D, 0x830A },
	{ 0x2B3E, 0x4589 },
	{ 0x2B3F, 0x2719C },
	{ 0x2B40, 0x2722A },
	{ 0x2B41, 0x2723A },
	{ 0x2B42, 0x2722B },
	{ 0x2B43, 0x27228 },
	{ 0x2B44, 0x275AA },
	{ 0x2B45, 0x2760F },
	{ 0x2B46, 0x461D },
	{ 0x2B47, 0x27610 },
	{ 0x2B48, 0x277E6 },
	{ 0x2B49, 0x472A },
	{ 0x2B4A, 0x27D25 },
	{ 0x2B4B, 0x27E8E },
	{ 0x2B4C, 0x47D3 },
	{ 0x2B4D, 0x4842 },
	{ 0x2B4E, 0x4843 },
	{ 0x2B4F, 0x2848B },
	{ 0x2B50, 0x4891 },
	{ 0x2B51, 0x2848C },
	{ 0x2B52, 0x2849A },
	{ 0x2B53, 0x4890 },
	{ 0x2B54, 0x48BF },
	{ 0x2B55, 0x286B3 },
	{ 0x2B56, 0x48BC },
	{ 0x2B57, 0x286B2 },
	{ 0x2B58, 0x48C0 },
	{ 0x2B59, 0x49C7 },
	{ 0x2B5A, 0x49C5 },
	{ 0x2B5B, 0x9655 },
	{ 0x2B5C, 0x28E44 },
	{ 0x2B5D, 0x9652 },
	{ 0x2B5E, 0x4E35 },
	{ 0x2B5F, 0x20158 },
	{ 0x2B60, 0x202A7 },
	{ 0x2B61, 0x5034 },
	{ 0x2B62, 0x5001 },
	{ 0x2B63, 0x20263 },
	{ 0x2B64, 0x500A },
	{ 0x2B65, 0x3466 },
	{ 0x2B66, 0x2026A },
	{ 0x2B67, 0x20265 },
	{ 0x2B68, 0x2026B },
	{ 0x2B69, 0x34AD },
	{ 0x2B6A, 0x204ED },
	{ 0x2B6B, 0x205D9 },
	{ 0x2B6C, 0x2073B },
	{ 0x2B6D, 0x20732 },
	{ 0x2B6E, 0x5258 },
	{ 0x2B6F, 0x20735 },
	{ 0x2B70, 0x20731 },
	{ 0x2B71, 0x2073E },
	{ 0x2B72, 0x20743 },
	{ 0x2B73, 0x20736 },
	{ 0x2B74, 0x2086D },
	{ 0x2B75, 0x351D },
	{ 0x2B76, 0x208E4 },
	{ 0x2B77, 0x3531 },
	{ 0x2B78, 0x532B },
	{ 0x2B79, 0x209F4 },
	{ 0x2B7A, 0x354C },
	{ 0x2B7B, 0x20A69 },
	{ 0x2B7C, 0x20A6B },
	{ 0x2B7D, 0x3595 },
	{ 0x2B7E, 0x3591 },
	{ 0x2C21, 0x3594 },
	{ 0x2C22, 0x20CBF },
	{ 0x2C23, 0x20CC3 },
	{ 0x2C24, 0x20CAE },
	{ 0x2C25, 0x358F },
	{ 0x2C26, 0x54EC },
	{ 0x2C27, 0x20CB1 },
	{ 0x2C28, 0x5515 },
	{ 0x2C29, 0x54FE },
	{ 0x2C2A, 0x20CBB },
	{ 0x2C2B, 0x20CAF },
	{ 0x2C2C, 0x20CB0 },
	{ 0x2C2D, 0x54E3 },
	{ 0x2C2E, 0x5516 },
	{ 0x2C2F, 0x3640 },
	{ 0x2C30, 0x212EF },
	{ 0x2C31, 0x3641 },
	{ 0x2C32, 0x212ED },
	{ 0x2C33, 0x57D3 },
	{ 0x2C34, 0x212F0 },
	{ 0x2C35, 0x21593 },
	{ 0x2C36, 0x21634 },
	{ 0x2C37, 0x2162B },
	{ 0x2C38, 0x5959 },
	{ 0x2C39, 0x5A27 },
	{ 0x2C3A, 0x36D8 },
	{ 0x2C3B, 0x36D2 },
	{ 0x2C3C, 0x36DA },
	{ 0x2C3D, 0x5A28 },
	{ 0x2C3E, 0x5A10 },
	{ 0x2C3F, 0x36D7 },
	{ 0x2C40, 0x5A0E },
	{ 0x2C41, 0x3742 },
	{ 0x2C42, 0x3757 },
	{ 0x2C43, 0x21A04 },
	{ 0x2C44, 0x21A03 },
	{ 0x2C45, 0x21A02 },
	{ 0x2C46, 0x5BAF },
	{ 0x2C47, 0x21A05 },
	{ 0x2C48, 0x5BBA },
	{ 0x2C49, 0x5BB1 },
	{ 0x2C4A, 0x21A00 },
	{ 0x2C4B, 0x21B74 },
	{ 0x2C4C, 0x3778 },
	{ 0x2C4D, 0x3782 },
	{ 0x2C4E, 0x3797 },
	{ 0x2C4F, 0x21C65 },
	{ 0x2C50, 0x21C63 },
	{ 0x2C51, 0x37C9 },
	{ 0x2C52, 0x21DD7 },
	{ 0x2C53, 0x37C8 },
	{ 0x2C54, 0x37D6 },
	{ 0x2C55, 0x37CC },
	{ 0x2C56, 0x21DE8 },
	{ 0x2C57, 0x37D0 },
	{ 0x2C58, 0x21DDB },
	{ 0x2C59, 0x21DD8 },
	{ 0x2C5A, 0x37CE },
	{ 0x2C5B, 0x37C7 },
	{ 0x2C5C, 0x5CFC },
	{ 0x2C5D, 0x21E09 },
	{ 0x2C5E, 0x37CF },
	{ 0x2C5F, 0x37CB },
	{ 0x2C60, 0x5CF2 },
	{ 0x2C61, 0x5CFE },
	{ 0x2C62, 0x21DE5 },
	{ 0x2C63, 0x21DE7 },
	{ 0x2C64, 0x5DF8 },
	{ 0x2C65, 0x2203F },
	{ 0x2C66, 0x3847 },
	{ 0x2C67, 0x220C0 },
	{ 0x2C68, 0x3848 },
	{ 0x2C69, 0x220B9 },
	{ 0x2C6A, 0x220BA },
	{ 0x2C6B, 0x3883 },
	{ 0x2C6C, 0x3885 },
	{ 0x2C6D, 0x3884 },
	{ 0x2C6E, 0x22220 },
	{ 0x2C6F, 0x2234F },
	{ 0x2C70, 0x5F2C },
	{ 0x2C71, 0x38B8 },
	{ 0x2C72, 0x38BC },
	{ 0x2C73, 0x22491 },
	{ 0x2C74, 0x22490 },
	{ 0x2C75, 0x224EE },
	{ 0x2C76, 0x224F3 },
	{ 0x2C77, 0x224EC },
	{ 0x2C78, 0x224F1 },
	{ 0x2C79, 0x224EB },
	{ 0x2C7A, 0x224F2 },
	{ 0x2C7B, 0x224F4 },
	{ 0x2C7C, 0x224ED },
	{ 0x2C7D, 0x22641 },
	{ 0x2C7E, 0x22648 },
	{ 0x2D21, 0x22645 },
	{ 0x2D22, 0x3931 },
	{ 0x2D23, 0x3934 },
	{ 0x2D24, 0x3936 },
	{ 0x2D25, 0x6082 },
	{ 0x2D26, 0x2267F },
	{ 0x2D27, 0x2268B },
	{ 0x2D28, 0x3923 },
	{ 0x2D29, 0x2263B },
	{ 0x2D2A, 0x2264E },
	{ 0x2D2B, 0x393A },
	{ 0x2D2C, 0x6091 },
	{ 0x2D2D, 0x608F },
	{ 0x2D2E, 0x2267C },
	{ 0x2D2F, 0x39B4 },
	{ 0x2D30, 0x39B5 },
	{ 0x2D31, 0x39ED },
	{ 0x2D32, 0x39EC },
	{ 0x2D33, 0x39D8 },
	{ 0x2D34, 0x22AF0 },
	{ 0x2D35, 0x22B36 },
	{ 0x2D36, 0x22B3F },
	{ 0x2D37, 0x22B43 },
	{ 0x2D38, 0x22B31 },
	{ 0x2D39, 0x22B34 },
	{ 0x2D3A, 0x22B46 },
	{ 0x2D3B, 0x39F6 },
	{ 0x2D3C, 0x39E7 },
	{ 0x2D3D, 0x22B2F },
	{ 0x2D3E, 0x22EC3 },
	{ 0x2D3F, 0x3A7C },
	{ 0x2D40, 0x3A7B },
	{ 0x2D41, 0x22F36 },
	{ 0x2D42, 0x3A88 },
	{ 0x2D43, 0x6547 },
	{ 0x2D44, 0x654C },
	{ 0x2D45, 0x22F21 },
	{ 0x2D46, 0x2F8C8 },
	{ 0x2D47, 0x658A },
	{ 0x2D48, 0x23073 },
	{ 0x2D49, 0x3ABE },
	{ 0x2D4A, 0x230E6 },
	{ 0x2D4B, 0x3AE7 },
	{ 0x2D4C, 0x3AE5 },
	{ 0x2D4D, 0x3AEE },
	{ 0x2D4E, 0x67E1 },
	{ 0x2D4F, 0x684A },
	{ 0x2D50, 0x2343F },
	{ 0x2D51, 0x3B59 },
	{ 0x2D52, 0x3B5E },
	{ 0x2D53, 0x2346B },
	{ 0x2D54, 0x3B5A },
	{ 0x2D55, 0x683F },
	{ 0x2D56, 0x3B61 },
	{ 0x2D57, 0x3B58 },
	{ 0x2D58, 0x3B5B },
	{ 0x2D59, 0x67BD },
	{ 0x2D5A, 0x23471 },
	{ 0x2D5B, 0x3B5F },
	{ 0x2D5C, 0x2F8E2 },
	{ 0x2D5D, 0x3C2A },
	{ 0x2D5E, 0x3C2D },
	{ 0x2D5F, 0x238B0 },
	{ 0x2D60, 0x3C23 },
	{ 0x2D61, 0x3C2B },
	{ 0x2D62, 0x3C2C },
	{ 0x2D63, 0x239F3 },
	{ 0x2D64, 0x3C7E },
	{ 0x2D65, 0x2F8F5 },
	{ 0x2D66, 0x3C93 },
	{ 0x2D67, 0x3C99 },
	{ 0x2D68, 0x23B61 },
	{ 0x2D69, 0x23B5F },
	{ 0x2D6A, 0x3CB3 },
	{ 0x2D6B, 0x3CE7 },
	{ 0x2D6C, 0x3CEA },
	{ 0x2D6D, 0x23D28 },
	{ 0x2D6E, 0x23D1E },
	{ 0x2D6F, 0x23D29 },
	{ 0x2D70, 0x2F902 },
	{ 0x2D71, 0x23CEB },
	{ 0x2D72, 0x23D66 },
	{ 0x2D73, 0x3DB4 },
	{ 0x2D74, 0x241F6 },
	{ 0x2D75, 0x70C9 },
	{ 0x2D76, 0x3E17 },
	{ 0x2D77, 0x24560 },
	{ 0x2D78, 0x24577 },
	{ 0x2D79, 0x245BB },
	{ 0x2D7A, 0x3E21 },
	{ 0x2D7B, 0x245BC },
	{ 0x2D7C, 0x3E38 },
	{ 0x2D7D, 0x3E37 },
	{ 0x2D7E, 0x3E74 },
	{ 0x2E21, 0x3E73 },
	{ 0x2E22, 0x3E75 },
	{ 0x2E23, 0x247A2 },
	{ 0x2E24, 0x247B2 },
	{ 0x2E25, 0x2479E },
	{ 0x2E26, 0x3E76 },
	{ 0x2E27, 0x3E78 },
	{ 0x2E28, 0x2493A },
	{ 0x2E29, 0x24938 },
	{ 0x2E2A, 0x73BA },
	{ 0x2E2B, 0x3F0C },
	{ 0x2E2C, 0x3F20 },
	{ 0x2E2D, 0x3F1E },
	{ 0x2E2E, 0x24C4D },
	{ 0x2E2F, 0x3F5B },
	{ 0x2E30, 0x24C5E },
	{ 0x2E31, 0x3F5C },
	{ 0x2E32, 0x24D17 },
	{ 0x2E33, 0x3F83 },
	{ 0x2E34, 0x75C6 },
	{ 0x2E35, 0x3F80 },
	{ 0x2E36, 0x3F81 },
	{ 0x2E37, 0x3F7E },
	{ 0x2E38, 0x3F88 },
	{ 0x2E39, 0x3F85 },
	{ 0x2E3A, 0x3F89 },
	{ 0x2E3B, 0x3F7F },
	{ 0x2E3C, 0x3F8E },
	{ 0x2E3D, 0x24D64 },
	{ 0x2E3E, 0x24D67 },
	{ 0x2E3F, 0x3F84 },
	{ 0x2E40, 0x75B7 },
	{ 0x2E41, 0x768C },
	{ 0x2E42, 0x24F59 },
	{ 0x2E43, 0x768D },
	{ 0x2E44, 0x24FDA },
	{ 0x2E45, 0x3FEE },
	{ 0x2E46, 0x3FED },
	{ 0x2E47, 0x3FFE },
	{ 0x2E48, 0x25051 },
	{ 0x2E49, 0x3FFF },
	{ 0x2E4A, 0x25055 },
	{ 0x2E4B, 0x2513B },
	{ 0x2E4C, 0x25134 },
	{ 0x2E4D, 0x4023 },
	{ 0x2E4E, 0x25137 },
	{ 0x2E4F, 0x7717 },
	{ 0x2E50, 0x25131 },
	{ 0x2E51, 0x771C },
	{ 0x2E52, 0x401F },
	{ 0x2E53, 0x2513F },
	{ 0x2E54, 0x25159 },
	{ 0x2E55, 0x7714 },
	{ 0x2E56, 0x25361 },
	{ 0x2E57, 0x408F },
	{ 0x2E58, 0x4090 },
	{ 0x2E59, 0x25458 },
	{ 0x2E5A, 0x25462 },
	{ 0x2E5B, 0x25450 },
	{ 0x2E5C, 0x40A0 },
	{ 0x2E5D, 0x25451 },
	{ 0x2E5E, 0x40A6 },
	{ 0x2E5F, 0x409F },
	{ 0x2E60, 0x25446 },
	{ 0x2E61, 0x40A7 },
	{ 0x2E62, 0x40A1 },
	{ 0x2E63, 0x2562D },
	{ 0x2E64, 0x4102 },
	{ 0x2E65, 0x4136 },
	{ 0x2E66, 0x25948 },
	{ 0x2E67, 0x25951 },
	{ 0x2E68, 0x2594A },
	{ 0x2E69, 0x2594F },
	{ 0x2E6A, 0x25950 },
	{ 0x2E6B, 0x25949 },
	{ 0x2E6C, 0x25A63 },
	{ 0x2E6D, 0x41C8 },
	{ 0x2E6E, 0x25A66 },
	{ 0x2E6F, 0x25A60 },
	{ 0x2E70, 0x41D8 },
	{ 0x2E71, 0x7B0C },
	{ 0x2E72, 0x41DD },
	{ 0x2E73, 0x41DC },
	{ 0x2E74, 0x25AF1 },
	{ 0x2E75, 0x41D7 },
	{ 0x2E76, 0x25B07 },
	{ 0x2E77, 0x41DA },
	{ 0x2E78, 0x42BA },
	{ 0x2E79, 0x25F9B },
	{ 0x2E7A, 0x25FA3 },
	{ 0x2E7B, 0x25F9D },
	{ 0x2E7C, 0x42BE },
	{ 0x2E7D, 0x42C2 },
	{ 0x2E7E, 0x42BB },
	{ 0x2F21, 0x42C0 },
	{ 0x2F22, 0x25FA9 },
	{ 0x2F23, 0x25FA7 },
	{ 0x2F24, 0x25FA4 },
	{ 0x2F25, 0x7D23 },
	{ 0x2F26, 0x25FBA },
	{ 0x2F27, 0x221C1 },
	{ 0x2F28, 0x26226 },
	{ 0x2F29, 0x4343 },
	{ 0x2F2A, 0x4355 },
	{ 0x2F2B, 0x26294 },
	{ 0x2F2C, 0x26293 },
	{ 0x2F2D, 0x4357 },
	{ 0x2F2E, 0x4368 },
	{ 0x2F2F, 0x7F98 },
	{ 0x2F30, 0x7F90 },
	{ 0x2F31, 0x26407 },
	{ 0x2F32, 0x2640D },
	{ 0x2F33, 0x26402 },
	{ 0x2F34, 0x2640C },
	{ 0x2F35, 0x26409 },
	{ 0x2F36, 0x26408 },
	{ 0x2F37, 0x26413 },
	{ 0x2F38, 0x43A1 },
	{ 0x2F39, 0x264D2 },
	{ 0x2F3A, 0x803A },
	{ 0x2F3B, 0x2653E },
	{ 0x2F3C, 0x2653C },
	{ 0x2F3D, 0x26667 },
	{ 0x2F3E, 0x2669E },
	{ 0x2F3F, 0x43EA },
	{ 0x2F40, 0x266AD },
	{ 0x2F41, 0x43E7 },
	{ 0x2F42, 0x266D9 },
	{ 0x2F43, 0x26642 },
	{ 0x2F44, 0x266A3 },
	{ 0x2F45, 0x266A0 },
	{ 0x2F46, 0x43E8 },
	{ 0x2F47, 0x43E9 },
	{ 0x2F48, 0x2667C },
	{ 0x2F49, 0x26904 },
	{ 0x2F4A, 0x4454 },
	{ 0x2F4B, 0x26958 },
	{ 0x2F4C, 0x26960 },
	{ 0x2F4D, 0x269C9 },
	{ 0x2F4E, 0x269C8 },
	{ 0x2F4F, 0x8226 },
	{ 0x2F50, 0x4465 },
	{ 0x2F51, 0x26A1C },
	{ 0x2F52, 0x26A1A },
	{ 0x2F53, 0x448A },
	{ 0x2F54, 0x26B74 },
	{ 0x2F55, 0x44B0 },
	{ 0x2F56, 0x26B6E },
	{ 0x2F57, 0x26B6F },
	{ 0x2F58, 0x26B79 },
	{ 0x2F59, 0x44BC },
	{ 0x2F5A, 0x832E },
	{ 0x2F5B, 0x26B77 },
	{ 0x2F5C, 0x8355 },
	{ 0x2F5D, 0x831A },
	{ 0x2F5E, 0x44B8 },
	{ 0x2F5F, 0x833D },
	{ 0x2F60, 0x26B7C },
	{ 0x2F61, 0x44B2 },
	{ 0x2F62, 0x26B70 },
	{ 0x2F63, 0x8330 },
	{ 0x2F64, 0x44BD },
	{ 0x2F65, 0x26B7A },
	{ 0x2F66, 0x26B82 },
	{ 0x2F67, 0x458A },
	{ 0x2F68, 0x8651 },
	{ 0x2F69, 0x45A1 },
	{ 0x2F6A, 0x27244 },
	{ 0x2F6B, 0x45A2 },
	{ 0x2F6C, 0x27243 },
	{ 0x2F6D, 0x8688 },
	{ 0x2F6E, 0x27245 },
	{ 0x2F6F, 0x4615 },
	{ 0x2F70, 0x27625 },
	{ 0x2F71, 0x2761F },
	{ 0x2F72, 0x4620 },
	{ 0x2F73, 0x4673 },
	{ 0x2F74, 0x277E8 },
	{ 0x2F75, 0x898E },
	{ 0x2F76, 0x898D },
	{ 0x2F77, 0x27809 },
	{ 0x2F78, 0x278B7 },
	{ 0x2F79, 0x278B9 },
	{ 0x2F7A, 0x27964 },
	{ 0x2F7B, 0x27963 },
	{ 0x2F7C, 0x8A09 },
	{ 0x2F7D, 0x8A14 },
	{ 0x2F7E, 0x46B1 },
	{ 0x3021, 0x27962 },
	{ 0x3022, 0x27965 },
	{ 0x3023, 0x472B },
	{ 0x3024, 0x27BAC },
	{ 0x3025, 0x4745 },
	{ 0x3026, 0x27D2A },
	{ 0x3027, 0x4797 },
	{ 0x3028, 0x4798 },
	{ 0x3029, 0x27E96 },
	{ 0x302A, 0x47D5 },
	{ 0x302B, 0x27FC2 },
	{ 0x302C, 0x2F9DE },
	{ 0x302D, 0x4893 },
	{ 0x302E, 0x4896 },
	{ 0x302F, 0x9007 },
	{ 0x3030, 0x4894 },
	{ 0x3031, 0x284AA },
	{ 0x3032, 0x284B0 },
	{ 0x3033, 0x48C7 },
	{ 0x3034, 0x48C5 },
	{ 0x3035, 0x286D4 },
	{ 0x3036, 0x286CD },
	{ 0x3037, 0x286D6 },
	{ 0x3038, 0x48C4 },
	{ 0x3039, 0x287F0 },
	{ 0x303A, 0x9579 },
	{ 0x303B, 0x9584 },
	{ 0x303C, 0x49CE },
	{ 0x303D, 0x49CA },
	{ 0x303E, 0x49CC },
	{ 0x303F, 0x9657 },
	{ 0x3040, 0x49C9 },
	{ 0x3041, 0x96BA },
	{ 0x3043, 0x29D4B },
	{ 0x3044, 0x20162 },
	{ 0x3045, 0x346E },
	{ 0x3046, 0x202B7 },
	{ 0x3047, 0x5067 },
	{ 0x3048, 0x202AC },
	{ 0x3049, 0x202AB },
	{ 0x304A, 0x3471 },
	{ 0x304B, 0x202C1 },
	{ 0x304C, 0x34BB },
	{ 0x304D, 0x34D3 },
	{ 0x304E, 0x205E8 },
	{ 0x304F, 0x20769 },
	{ 0x3050, 0x2075D },
	{ 0x3051, 0x2075F },
	{ 0x3052, 0x34F3 },
	{ 0x3053, 0x34ED },
	{ 0x3054, 0x34F5 },
	{ 0x3055, 0x20764 },
	{ 0x3056, 0x20762 },
	{ 0x3057, 0x34F1 },
	{ 0x3058, 0x34F2 },
	{ 0x3059, 0x34F6 },
	{ 0x305A, 0x3520 },
	{ 0x305B, 0x208F9 },
	{ 0x305C, 0x3528 },
	{ 0x305D, 0x208EE },
	{ 0x305E, 0x5318 },
	{ 0x305F, 0x532C },
	{ 0x3060, 0x5359 },
	{ 0x3061, 0x209AB },
	{ 0x3062, 0x209AC },
	{ 0x3063, 0x209AA },
	{ 0x3064, 0x5368 },
	{ 0x3065, 0x537E },
	{ 0x3066, 0x20A86 },
	{ 0x3067, 0x20A7A },
	{ 0x3068, 0x53A1 },
	{ 0x3069, 0x20D28 },
	{ 0x306A, 0x35A1 },
	{ 0x306B, 0x555B },
	{ 0x306C, 0x35AA },
	{ 0x306D, 0x35A9 },
	{ 0x306E, 0x20D31 },
	{ 0x306F, 0x35B5 },
	{ 0x3070, 0x35A5 },
	{ 0x3071, 0x35A8 },
	{ 0x3072, 0x5542 },
	{ 0x3073, 0x35A7 },
	{ 0x3074, 0x5547 },
	{ 0x3075, 0x20D2D },
	{ 0x3076, 0x2F843 },
	{ 0x3077, 0x553D },
	{ 0x3078, 0x20D2B },
	{ 0x3079, 0x20D32 },
	{ 0x307A, 0x5560 },
	{ 0x307B, 0x57EB },
	{ 0x307C, 0x21329 },
	{ 0x307D, 0x21326 },
	{ 0x307E, 0x21353 },
	{ 0x3121, 0x364D },
	{ 0x3122, 0x21333 },
	{ 0x3123, 0x21334 },
	{ 0x3124, 0x2159D },
	{ 0x3125, 0x369C },
	{ 0x3126, 0x595F },
	{ 0x3127, 0x21641 },
	{ 0x3128, 0x36EA },
	{ 0x3129, 0x36E5 },
	{ 0x312A, 0x21791 },
	{ 0x312B, 0x21769 },
	{ 0x312C, 0x5B6F },
	{ 0x312D, 0x21A22 },
	{ 0x312E, 0x375E },
	{ 0x312F, 0x21A34 },
	{ 0x3130, 0x2F86D },
	{ 0x3131, 0x21B2E },
	{ 0x3132, 0x3786 },
	{ 0x3133, 0x3784 },
	{ 0x3134, 0x21BF4 },
	{ 0x3135, 0x5C5A },
	{ 0x3136, 0x21E28 },
	{ 0x3137, 0x37D9 },
	{ 0x3138, 0x21E1C },
	{ 0x3139, 0x37DE },
	{ 0x313A, 0x21E11 },
	{ 0x313B, 0x21E24 },
	{ 0x313C, 0x21E15 },
	{ 0x313D, 0x37DB },
	{ 0x313E, 0x21E16 },
	{ 0x313F, 0x21E54 },
	{ 0x3140, 0x21E23 },
	{ 0x3141, 0x21FFF },
	{ 0x3142, 0x3831 },
	{ 0x3143, 0x220CF },
	{ 0x3144, 0x220D0 },
	{ 0x3145, 0x384B },
	{ 0x3146, 0x220CE },
	{ 0x3147, 0x3849 },
	{ 0x3148, 0x384A },
	{ 0x3149, 0x384C },
	{ 0x314A, 0x221C7 },
	{ 0x314B, 0x2225C },
	{ 0x314C, 0x388A },
	{ 0x314D, 0x22236 },
	{ 0x314E, 0x3889 },
	{ 0x314F, 0x388B },
	{ 0x3150, 0x22243 },
	{ 0x3151, 0x38BB },
	{ 0x3152, 0x5FA2 },
	{ 0x3153, 0x5F9D },
	{ 0x3154, 0x38E4 },
	{ 0x3155, 0x2252A },
	{ 0x3156, 0x22501 },
	{ 0x3157, 0x5FA3 },
	{ 0x3158, 0x2250B },
	{ 0x3159, 0x2250F },
	{ 0x315A, 0x393B },
	{ 0x315B, 0x392E },
	{ 0x315C, 0x393E },
	{ 0x315D, 0x3946 },
	{ 0x315E, 0x3953 },
	{ 0x315F, 0x226DF },
	{ 0x3160, 0x3944 },
	{ 0x3161, 0x226D2 },
	{ 0x3162, 0x393F },
	{ 0x3163, 0x3942 },
	{ 0x3164, 0x394F },
	{ 0x3165, 0x226CD },
	{ 0x3166, 0x3952 },
	{ 0x3167, 0x394A },
	{ 0x3168, 0x60C2 },
	{ 0x3169, 0x226DB },
	{ 0x316A, 0x395A },
	{ 0x316B, 0x60A5 },
	{ 0x316C, 0x3949 },
	{ 0x316D, 0x226CF },
	{ 0x316E, 0x621C },
	{ 0x316F, 0x229C0 },
	{ 0x3170, 0x621D },
	{ 0x3171, 0x3A03 },
	{ 0x3172, 0x22B81 },
	{ 0x3173, 0x22B82 },
	{ 0x3174, 0x22B8A },
	{ 0x3175, 0x22BA8 },
	{ 0x3176, 0x22B8C },
	{ 0x3177, 0x6395 },
	{ 0x3178, 0x639A },
	{ 0x3179, 0x3A01 },
	{ 0x317A, 0x3A06 },
	{ 0x317B, 0x39FB },
	{ 0x317C, 0x39F9 },
	{ 0x317D, 0x22B8E },
	{ 0x317E, 0x3A05 },
	{ 0x3221, 0x39FA },
	{ 0x3222, 0x22B8B },
	{ 0x3223, 0x63A6 },
	{ 0x3224, 0x22B96 },
	{ 0x3225, 0x39FE },
	{ 0x3226, 0x22BCC },
	{ 0x3227, 0x3A7D },
	{ 0x3228, 0x3A8C },
	{ 0x3229, 0x22F4F },
	{ 0x322A, 0x22F4A },
	{ 0x322B, 0x6550 },
	{ 0x322C, 0x3A8E },
	{ 0x322D, 0x22F4B },
	{ 0x322E, 0x22F3D },
	{ 0x322F, 0x6552 },
	{ 0x3230, 0x22F44 },
	{ 0x3231, 0x22F49 },
	{ 0x3232, 0x2309E },
	{ 0x3233, 0x230F3 },
	{ 0x3234, 0x65C8 },
	{ 0x3235, 0x230F5 },
	{ 0x3236, 0x3AF0 },
	{ 0x3237, 0x3AF2 },
	{ 0x3238, 0x231B3 },
	{ 0x3239, 0x6658 },
	{ 0x323A, 0x3AF1 },
	{ 0x323B, 0x3AE6 },
	{ 0x323C, 0x231E5 },
	{ 0x323D, 0x231B6 },
	{ 0x323E, 0x2F8D8 },
	{ 0x323F, 0x6888 },
	{ 0x3240, 0x23486 },
	{ 0x3241, 0x3B6F },
	{ 0x3242, 0x3B6D },
	{ 0x3243, 0x3B69 },
	{ 0x3244, 0x234B6 },
	{ 0x3245, 0x23485 },
	{ 0x3246, 0x3B6E },
	{ 0x3247, 0x234AB },
	{ 0x3248, 0x3C2F },
	{ 0x3249, 0x3C30 },
	{ 0x324A, 0x3C63 },
	{ 0x324B, 0x23A0D },
	{ 0x324C, 0x23A8B },
	{ 0x324D, 0x23A8C },
	{ 0x324E, 0x6BB8 },
	{ 0x324F, 0x3C80 },
	{ 0x3250, 0x6BB9 },
	{ 0x3251, 0x3C9A },
	{ 0x3252, 0x3C94 },
	{ 0x3253, 0x3C96 },
	{ 0x3254, 0x3C95 },
	{ 0x3255, 0x3C97 },
	{ 0x3256, 0x23B72 },
	{ 0x3257, 0x3CF4 },
	{ 0x3258, 0x3CFE },
	{ 0x3259, 0x23D8F },
	{ 0x325A, 0x3D01 },
	{ 0x325B, 0x23D79 },
	{ 0x325C, 0x3D02 },
	{ 0x325D, 0x23D77 },
	{ 0x325E, 0x3CF9 },
	{ 0x325F, 0x23D90 },
	{ 0x3260, 0x23D88 },
	{ 0x3261, 0x23D80 },
	{ 0x3262, 0x23D9E },
	{ 0x3263, 0x3CF6 },
	{ 0x3264, 0x3CF7 },
	{ 0x3265, 0x23D82 },
	{ 0x3266, 0x23D34 },
	{ 0x3267, 0x23D89 },
	{ 0x3268, 0x3CFF },
	{ 0x3269, 0x23D85 },
	{ 0x326A, 0x23D7E },
	{ 0x326B, 0x23D7A },
	{ 0x326C, 0x23DA6 },
	{ 0x326D, 0x6E0B },
	{ 0x326E, 0x23DB5 },
	{ 0x326F, 0x241F4 },
	{ 0x3270, 0x3DBF },
	{ 0x3271, 0x3DBC },
	{ 0x3272, 0x7105 },
	{ 0x3273, 0x24229 },
	{ 0x3274, 0x24226 },
	{ 0x3275, 0x2422A },
	{ 0x3276, 0x3DBE },
	{ 0x3277, 0x3DC0 },
	{ 0x3278, 0x2457E },
	{ 0x3279, 0x3E3B },
	{ 0x327A, 0x3E39 },
	{ 0x327B, 0x2465B },
	{ 0x327C, 0x24661 },
	{ 0x327D, 0x24660 },
	{ 0x327E, 0x3E3C },
	{ 0x3321, 0x2479B },
	{ 0x3322, 0x7314 },
	{ 0x3323, 0x7304 },
	{ 0x3324, 0x247C3 },
	{ 0x3325, 0x3E7D },
	{ 0x3326, 0x247CD },
	{ 0x3327, 0x3E7F },
	{ 0x3328, 0x3E7A },
	{ 0x3329, 0x3E7C },
	{ 0x332A, 0x7305 },
	{ 0x332B, 0x3E7E },
	{ 0x332C, 0x7315 },
	{ 0x332D, 0x730D },
	{ 0x332E, 0x3E80 },
	{ 0x332F, 0x3EBF },
	{ 0x3330, 0x3EC3 },
	{ 0x3331, 0x24954 },
	{ 0x3332, 0x24959 },
	{ 0x3333, 0x3ECC },
	{ 0x3334, 0x3F0E },
	{ 0x3335, 0x3F0D },
	{ 0x3336, 0x24AF5 },
	{ 0x3337, 0x3F26 },
	{ 0x3338, 0x3F24 },
	{ 0x3339, 0x3F25 },
	{ 0x333A, 0x3F23 },
	{ 0x333B, 0x3F21 },
	{ 0x333C, 0x3F29 },
	{ 0x333D, 0x24C69 },
	{ 0x333E, 0x24C65 },
	{ 0x333F, 0x3F8F },
	{ 0x3340, 0x3F8D },
	{ 0x3341, 0x24D7C },
	{ 0x3342, 0x3F8B },
	{ 0x3343, 0x3F92 },
	{ 0x3344, 0x24D80 },
	{ 0x3345, 0x3F90 },
	{ 0x3346, 0x24F65 },
	{ 0x3347, 0x3FEF },
	{ 0x3348, 0x3FF0 },
	{ 0x3349, 0x24FDF },
	{ 0x334A, 0x25060 },
	{ 0x334B, 0x4001 },
	{ 0x334C, 0x2505E },
	{ 0x334D, 0x402E },
	{ 0x334E, 0x402D },
	{ 0x334F, 0x772E },
	{ 0x3350, 0x4028 },
	{ 0x3351, 0x4029 },
	{ 0x3352, 0x402C },
	{ 0x3353, 0x2518F },
	{ 0x3354, 0x25161 },
	{ 0x3355, 0x2515A },
	{ 0x3356, 0x7741 },
	{ 0x3357, 0x4088 },
	{ 0x3358, 0x25367 },
	{ 0x3359, 0x4092 },
	{ 0x335A, 0x4091 },
	{ 0x335B, 0x77EA },
	{ 0x335C, 0x253BB },
	{ 0x335D, 0x7844 },
	{ 0x335E, 0x40A9 },
	{ 0x335F, 0x40AC },
	{ 0x3360, 0x40AE },
	{ 0x3361, 0x40AA },
	{ 0x3362, 0x4106 },
	{ 0x3363, 0x4105 },
	{ 0x3364, 0x414A },
	{ 0x3365, 0x413E },
	{ 0x3366, 0x413C },
	{ 0x3367, 0x413B },
	{ 0x3368, 0x2579B },
	{ 0x3369, 0x4142 },
	{ 0x336A, 0x4141 },
	{ 0x336B, 0x4143 },
	{ 0x336C, 0x257A9 },
	{ 0x336D, 0x4145 },
	{ 0x336E, 0x25966 },
	{ 0x336F, 0x419A },
	{ 0x3370, 0x419B },
	{ 0x3371, 0x419F },
	{ 0x3372, 0x419E },
	{ 0x3373, 0x25A72 },
	{ 0x3374, 0x25A76 },
	{ 0x3375, 0x25B14 },
	{ 0x3376, 0x41DE },
	{ 0x3377, 0x41E2 },
	{ 0x3378, 0x41E6 },
	{ 0x3379, 0x25B0F },
	{ 0x337A, 0x7B29 },
	{ 0x337B, 0x41E3 },
	{ 0x337C, 0x7B27 },
	{ 0x337D, 0x41DF },
	{ 0x337E, 0x25E41 },
	{ 0x3421, 0x25E46 },
	{ 0x3422, 0x7C9D },
	{ 0x3423, 0x25E4B },
	{ 0x3424, 0x25E43 },
	{ 0x3425, 0x427E },
	{ 0x3426, 0x42C9 },
	{ 0x3427, 0x42CC },
	{ 0x3428, 0x25FC6 },
	{ 0x3429, 0x42D1 },
	{ 0x342A, 0x25FC7 },
	{ 0x342B, 0x42D0 },
	{ 0x342C, 0x25FCE },
	{ 0x342D, 0x42CF },
	{ 0x342E, 0x42C8 },
	{ 0x342F, 0x25FC9 },
	{ 0x3430, 0x42CD },
	{ 0x3431, 0x25FCB },
	{ 0x3432, 0x25FC5 },
	{ 0x3433, 0x4349 },
	{ 0x3434, 0x4347 },
	{ 0x3435, 0x4358 },
	{ 0x3436, 0x436B },
	{ 0x3437, 0x436C },
	{ 0x3438, 0x436A },
	{ 0x3439, 0x26369 },
	{ 0x343A, 0x4380 },
	{ 0x343B, 0x4382 },
	{ 0x343C, 0x4384 },
	{ 0x343D, 0x7FC8 },
	{ 0x343E, 0x4383 },
	{ 0x343F, 0x2641E },
	{ 0x3440, 0x264BA },
	{ 0x3441, 0x43B6 },
	{ 0x3442, 0x26552 },
	{ 0x3443, 0x26551 },
	{ 0x3444, 0x26553 },
	{ 0x3445, 0x2669F },
	{ 0x3446, 0x266DB },
	{ 0x3447, 0x8126 },
	{ 0x3448, 0x43F1 },
	{ 0x3449, 0x266E3 },
	{ 0x344A, 0x43F6 },
	{ 0x344B, 0x43F3 },
	{ 0x344C, 0x43F0 },
	{ 0x344D, 0x811C },
	{ 0x344E, 0x266D7 },
	{ 0x344F, 0x266E9 },
	{ 0x3450, 0x8128 },
	{ 0x3451, 0x43F5 },
	{ 0x3452, 0x43F4 },
	{ 0x3453, 0x43F7 },
	{ 0x3454, 0x266DE },
	{ 0x3455, 0x266DC },
	{ 0x3456, 0x2693C },
	{ 0x3457, 0x2F98B },
	{ 0x3458, 0x4455 },
	{ 0x3459, 0x26A22 },
	{ 0x345A, 0x26A32 },
	{ 0x345B, 0x26A23 },
	{ 0x345C, 0x448B },
	{ 0x345D, 0x44CB },
	{ 0x345E, 0x44C2 },
	{ 0x345F, 0x26BD4 },
	{ 0x3460, 0x26BC8 },
	{ 0x3461, 0x26BBC },
	{ 0x3462, 0x44CA },
	{ 0x3463, 0x44CC },
	{ 0x3464, 0x26BCD },
	{ 0x3465, 0x44C7 },
	{ 0x3466, 0x44C9 },
	{ 0x3467, 0x8370 },
	{ 0x3468, 0x26BBE },
	{ 0x3469, 0x44C6 },
	{ 0x346A, 0x26C40 },
	{ 0x346B, 0x26BD6 },
	{ 0x346C, 0x44C3 },
	{ 0x346D, 0x8382 },
	{ 0x346E, 0x26BBD },
	{ 0x346F, 0x83AC },
	{ 0x3470, 0x26BBA },
	{ 0x3471, 0x44C4 },
	{ 0x3472, 0x26BC0 },
	{ 0x3473, 0x2F99B },
	{ 0x3474, 0x2F99D },
	{ 0x3475, 0x26BC1 },
	{ 0x3476, 0x271A6 },
	{ 0x3477, 0x271A5 },
	{ 0x3478, 0x271A8 },
	{ 0x3479, 0x45A9 },
	{ 0x347A, 0x86AD },
	{ 0x347B, 0x45A8 },
	{ 0x347C, 0x45A6 },
	{ 0x347D, 0x2725F },
	{ 0x347E, 0x27270 },
	{ 0x3521, 0x2726A },
	{ 0x3522, 0x27265 },
	{ 0x3523, 0x27267 },
	{ 0x3524, 0x2726F },
	{ 0x3525, 0x27287 },
	{ 0x3526, 0x86CA },
	{ 0x3527, 0x8851 },
	{ 0x3528, 0x2763D },
	{ 0x3529, 0x27643 },
	{ 0x352A, 0x4622 },
	{ 0x352B, 0x27640 },
	{ 0x352C, 0x4626 },
	{ 0x352D, 0x4624 },
	{ 0x352E, 0x4625 },
	{ 0x352F, 0x889D },
	{ 0x3530, 0x462A },
	{ 0x3531, 0x4674 },
	{ 0x3532, 0x27818 },
	{ 0x3533, 0x4679 },
	{ 0x3534, 0x8990 },
	{ 0x3535, 0x467A },
	{ 0x3536, 0x27819 },
	{ 0x3537, 0x278C1 },
	{ 0x3538, 0x89D8 },
	{ 0x3539, 0x89D7 },
	{ 0x353A, 0x4697 },
	{ 0x353B, 0x278BC },
	{ 0x353C, 0x278C8 },
	{ 0x353D, 0x8A2E },
	{ 0x353E, 0x27971 },
	{ 0x353F, 0x46BC },
	{ 0x3540, 0x2796E },
	{ 0x3541, 0x46B3 },
	{ 0x3542, 0x27978 },
	{ 0x3543, 0x46BF },
	{ 0x3544, 0x46B7 },
	{ 0x3545, 0x2F9CD },
	{ 0x3546, 0x2797A },
	{ 0x3547, 0x27BB1 },
	{ 0x3548, 0x27BAF },
	{ 0x3549, 0x27BB0 },
	{ 0x354A, 0x4734 },
	{ 0x354B, 0x4746 },
	{ 0x354C, 0x4748 },
	{ 0x354D, 0x8C59 },
	{ 0x354E, 0x27CA8 },
	{ 0x354F, 0x27CA6 },
	{ 0x3550, 0x4756 },
	{ 0x3551, 0x4767 },
	{ 0x3552, 0x27D48 },
	{ 0x3553, 0x27D45 },
	{ 0x3554, 0x4768 },
	{ 0x3555, 0x4799 },
	{ 0x3556, 0x479A },
	{ 0x3557, 0x27EA0 },
	{ 0x3558, 0x27EA4 },
	{ 0x3559, 0x47D8 },
	{ 0x355A, 0x27FD4 },
	{ 0x355B, 0x47DB },
	{ 0x355C, 0x47DC },
	{ 0x355D, 0x47DD },
	{ 0x355E, 0x47D7 },
	{ 0x355F, 0x27FD2 },
	{ 0x3560, 0x28222 },
	{ 0x3561, 0x4849 },
	{ 0x3562, 0x484A },
	{ 0x3563, 0x8EDA },
	{ 0x3564, 0x282B7 },
	{ 0x3565, 0x282CC },
	{ 0x3566, 0x9033 },
	{ 0x3567, 0x284E6 },
	{ 0x3568, 0x9018 },
	{ 0x3569, 0x489A },
	{ 0x356A, 0x284C8 },
	{ 0x356B, 0x48CD },
	{ 0x356C, 0x48CA },
	{ 0x356D, 0x286F4 },
	{ 0x356E, 0x48CB },
	{ 0x356F, 0x286ED },
	{ 0x3570, 0x48CF },
	{ 0x3571, 0x2867E },
	{ 0x3572, 0x2F9E3 },
	{ 0x3573, 0x48CC },
	{ 0x3574, 0x48EA },
	{ 0x3575, 0x48ED },
	{ 0x3576, 0x287F9 },
	{ 0x3577, 0x287FD },
	{ 0x3578, 0x48E9 },
	{ 0x3579, 0x28807 },
	{ 0x357A, 0x491A },
	{ 0x357B, 0x91EF },
	{ 0x357C, 0x498D },
	{ 0x357D, 0x49D2 },
	{ 0x357E, 0x28E78 },
	{ 0x3621, 0x28E7A },
	{ 0x3622, 0x28E79 },
	{ 0x3623, 0x28F8A },
	{ 0x3624, 0x49F2 },
	{ 0x3625, 0x2907B },
	{ 0x3626, 0x291D5 },
	{ 0x3627, 0x291E9 },
	{ 0x3628, 0x4A3D },
	{ 0x3629, 0x291EB },
	{ 0x362A, 0x4A3E },
	{ 0x362B, 0x4AF8 },
	{ 0x362C, 0x4B23 },
	{ 0x362D, 0x9AD9 },
	{ 0x362E, 0x4EB4 },
	{ 0x362F, 0x2016C },
	{ 0x3630, 0x50A0 },
	{ 0x3631, 0x5090 },
	{ 0x3632, 0x3475 },
	{ 0x3633, 0x5086 },
	{ 0x3634, 0x5084 },
	{ 0x3635, 0x202FA },
	{ 0x3636, 0x508A },
	{ 0x3637, 0x3476 },
	{ 0x3638, 0x3473 },
	{ 0x3639, 0x509F },
	{ 0x363A, 0x50A1 },
	{ 0x363B, 0x20318 },
	{ 0x363C, 0x5093 },
	{ 0x363D, 0x34BD },
	{ 0x363E, 0x205F6 },
	{ 0x363F, 0x51D5 },
	{ 0x3640, 0x2078A },
	{ 0x3641, 0x20789 },
	{ 0x3642, 0x34F9 },
	{ 0x3643, 0x2077F },
	{ 0x3644, 0x20788 },
	{ 0x3645, 0x34FA },
	{ 0x3646, 0x20783 },
	{ 0x3647, 0x20784 },
	{ 0x3648, 0x20798 },
	{ 0x3649, 0x20763 },
	{ 0x364A, 0x20787 },
	{ 0x364B, 0x3521 },
	{ 0x364C, 0x2F827 },
	{ 0x364D, 0x3529 },
	{ 0x364E, 0x208F5 },
	{ 0x364F, 0x20950 },
	{ 0x3650, 0x3538 },
	{ 0x3651, 0x354E },
	{ 0x3652, 0x20A87 },
	{ 0x3653, 0x20A8A },
	{ 0x3654, 0x20B65 },
	{ 0x3655, 0x20DB7 },
	{ 0x3656, 0x20DC1 },
	{ 0x3657, 0x20DC7 },
	{ 0x3658, 0x35C8 },
	{ 0x3659, 0x35BC },
	{ 0x365A, 0x20DC5 },
	{ 0x365B, 0x20DCB },
	{ 0x365C, 0x5590 },
	{ 0x365D, 0x20DD1 },
	{ 0x365E, 0x35BB },
	{ 0x365F, 0x35C2 },
	{ 0x3660, 0x35C0 },
	{ 0x3661, 0x20DB8 },
	{ 0x3662, 0x20DCA },
	{ 0x3663, 0x35CA },
	{ 0x3664, 0x20DDE },
	{ 0x3665, 0x35C9 },
	{ 0x3666, 0x20DCE },
	{ 0x3667, 0x35B8 },
	{ 0x3668, 0x5710 },
	{ 0x3669, 0x5817 },
	{ 0x366A, 0x21368 },
	{ 0x366B, 0x364E },
	{ 0x366C, 0x2136B },
	{ 0x366D, 0x5844 },
	{ 0x366E, 0x3650 },
	{ 0x366F, 0x582B },
	{ 0x3670, 0x2136A },
	{ 0x3671, 0x5845 },
	{ 0x3672, 0x21366 },
	{ 0x3673, 0x21377 },
	{ 0x3674, 0x21396 },
	{ 0x3675, 0x2136E },
	{ 0x3676, 0x2F856 },
	{ 0x3677, 0x368A },
	{ 0x3678, 0x21657 },
	{ 0x3679, 0x5965 },
	{ 0x367A, 0x21656 },
	{ 0x367B, 0x2179C },
	{ 0x367C, 0x2179E },
	{ 0x367D, 0x36FC },
	{ 0x367E, 0x36F9 },
	{ 0x3721, 0x217A1 },
	{ 0x3722, 0x3763 },
	{ 0x3723, 0x21A42 },
	{ 0x3724, 0x5BCF },
	{ 0x3725, 0x21A46 },
	{ 0x3726, 0x21A3E },
	{ 0x3727, 0x21B33 },
	{ 0x3728, 0x3787 },
	{ 0x3729, 0x3788 },
	{ 0x372A, 0x21BFA },
	{ 0x372B, 0x379A },
	{ 0x372C, 0x21C97 },
	{ 0x372D, 0x21C9B },
	{ 0x372E, 0x21CAA },
	{ 0x372F, 0x5D56 },
	{ 0x3730, 0x21E73 },
	{ 0x3731, 0x21E7C },
	{ 0x3732, 0x37E9 },
	{ 0x3733, 0x21E86 },
	{ 0x3734, 0x37EA },
	{ 0x3735, 0x5D54 },
	{ 0x3736, 0x3850 },
	{ 0x3737, 0x220F3 },
	{ 0x3738, 0x220F0 },
	{ 0x3739, 0x3856 },
	{ 0x373A, 0x3852 },
	{ 0x373B, 0x384F },
	{ 0x373C, 0x3854 },
	{ 0x373D, 0x3851 },
	{ 0x373E, 0x220EC },
	{ 0x373F, 0x222AF },
	{ 0x3740, 0x388E },
	{ 0x3741, 0x388F },
	{ 0x3742, 0x22264 },
	{ 0x3743, 0x22268 },
	{ 0x3744, 0x2235A },
	{ 0x3745, 0x5F3D },
	{ 0x3746, 0x2251F },
	{ 0x3747, 0x22525 },
	{ 0x3748, 0x38ED },
	{ 0x3749, 0x38EB },
	{ 0x374A, 0x5FA4 },
	{ 0x374B, 0x226C6 },
	{ 0x374C, 0x226D6 },
	{ 0x374D, 0x226C3 },
	{ 0x374E, 0x3962 },
	{ 0x374F, 0x2272C },
	{ 0x3750, 0x395D },
	{ 0x3751, 0x2272E },
	{ 0x3752, 0x2275E },
	{ 0x3753, 0x22733 },
	{ 0x3754, 0x3961 },
	{ 0x3755, 0x3965 },
	{ 0x3756, 0x395C },
	{ 0x3757, 0x2272D },
	{ 0x3758, 0x22746 },
	{ 0x3759, 0x395F },
	{ 0x375A, 0x226C1 },
	{ 0x375B, 0x2273A },
	{ 0x375C, 0x229CC },
	{ 0x375D, 0x22B9D },
	{ 0x375E, 0x22B83 },
	{ 0x375F, 0x22BF6 },
	{ 0x3760, 0x63EC },
	{ 0x3761, 0x3A16 },
	{ 0x3762, 0x3A0A },
	{ 0x3763, 0x22BF8 },
	{ 0x3764, 0x3A0E },
	{ 0x3765, 0x3A12 },
	{ 0x3766, 0x22BFE },
	{ 0x3767, 0x22BF3 },
	{ 0x3768, 0x3A11 },
	{ 0x3769, 0x22BEB },
	{ 0x376A, 0x22BFA },
	{ 0x376B, 0x3A10 },
	{ 0x376C, 0x22C07 },
	{ 0x376D, 0x22BFC },
	{ 0x376E, 0x3A09 },
	{ 0x376F, 0x63FA },
	{ 0x3770, 0x3A15 },
	{ 0x3771, 0x63D4 },
	{ 0x3772, 0x22F72 },
	{ 0x3773, 0x22F73 },
	{ 0x3774, 0x22F74 },
	{ 0x3775, 0x3A91 },
	{ 0x3776, 0x3A95 },
	{ 0x3777, 0x3A93 },
	{ 0x3778, 0x3A92 },
	{ 0x3779, 0x3A8F },
	{ 0x377A, 0x22F5F },
	{ 0x377B, 0x22F60 },
	{ 0x377C, 0x230AA },
	{ 0x377D, 0x23134 },
	{ 0x377E, 0x3AF6 },
	{ 0x3821, 0x231B4 },
	{ 0x3822, 0x3AFB },
	{ 0x3823, 0x231F0 },
	{ 0x3824, 0x6675 },
	{ 0x3825, 0x3AF9 },
	{ 0x3826, 0x2320D },
	{ 0x3827, 0x231F3 },
	{ 0x3828, 0x2320F },
	{ 0x3829, 0x671C },
	{ 0x382A, 0x3B7D },
	{ 0x382B, 0x234C9 },
	{ 0x382C, 0x3B7A },
	{ 0x382D, 0x3B7F },
	{ 0x382E, 0x234C5 },
	{ 0x382F, 0x3B78 },
	{ 0x3830, 0x234D7 },
	{ 0x3831, 0x234CC },
	{ 0x3832, 0x68D9 },
	{ 0x3833, 0x234E7 },
	{ 0x3834, 0x3B70 },
	{ 0x3835, 0x3B82 },
	{ 0x3836, 0x234C1 },
	{ 0x3837, 0x3B84 },
	{ 0x3838, 0x234E8 },
	{ 0x3839, 0x3C33 },
	{ 0x383A, 0x238CB },
	{ 0x383B, 0x3C32 },
	{ 0x383C, 0x3C36 },
	{ 0x383D, 0x238C8 },
	{ 0x383E, 0x2397A },
	{ 0x383F, 0x3C56 },
	{ 0x3840, 0x23979 },
	{ 0x3841, 0x2397E },
	{ 0x3842, 0x3C67 },
	{ 0x3843, 0x23A1B },
	{ 0x3844, 0x3C65 },
	{ 0x3845, 0x3C64 },
	{ 0x3846, 0x3C66 },
	{ 0x3847, 0x23A1F },
	{ 0x3848, 0x23A19 },
	{ 0x3849, 0x3C81 },
	{ 0x384A, 0x3C82 },
	{ 0x384B, 0x3C83 },
	{ 0x384C, 0x3C9E },
	{ 0x384D, 0x23B89 },
	{ 0x384E, 0x6BF1 },
	{ 0x384F, 0x3C9D },
	{ 0x3850, 0x23B8B },
	{ 0x3851, 0x3D0F },
	{ 0x3852, 0x3D12 },
	{ 0x3853, 0x23E09 },
	{ 0x3854, 0x23DFE },
	{ 0x3855, 0x23E00 },
	{ 0x3856, 0x3D10 },
	{ 0x3857, 0x3D18 },
	{ 0x3858, 0x23E0B },
	{ 0x3859, 0x3D14 },
	{ 0x385A, 0x3D19 },
	{ 0x385B, 0x6E37 },
	{ 0x385D, 0x23E4A },
	{ 0x385E, 0x6E7D },
	{ 0x385F, 0x6E86 },
	{ 0x3860, 0x3DC8 },
	{ 0x3861, 0x3DC4 },
	{ 0x3862, 0x3DC6 },
	{ 0x3863, 0x24279 },
	{ 0x3864, 0x3DC7 },
	{ 0x3865, 0x3DC3 },
	{ 0x3866, 0x2426C },
	{ 0x3867, 0x24299 },
	{ 0x3868, 0x2F91B },
	{ 0x3869, 0x24262 },
	{ 0x386A, 0x24514 },
	{ 0x386B, 0x3E19 },
	{ 0x386C, 0x3E1C },
	{ 0x386D, 0x245C8 },
	{ 0x386E, 0x245D7 },
	{ 0x386F, 0x2460C },
	{ 0x3870, 0x3E41 },
	{ 0x3871, 0x24670 },
	{ 0x3872, 0x3E42 },
	{ 0x3873, 0x3E43 },
	{ 0x3874, 0x24671 },
	{ 0x3875, 0x247DF },
	{ 0x3876, 0x247E4 },
	{ 0x3877, 0x3E82 },
	{ 0x3878, 0x247E7 },
	{ 0x3879, 0x3E81 },
	{ 0x387A, 0x3E94 },
	{ 0x387B, 0x3E84 },
	{ 0x387C, 0x24990 },
	{ 0x387D, 0x3ED2 },
	{ 0x387E, 0x3F0F },
	{ 0x3921, 0x3F22 },
	{ 0x3922, 0x24B4C },
	{ 0x3923, 0x3F27 },
	{ 0x3924, 0x3F2A },
	{ 0x3925, 0x74FA },
	{ 0x3926, 0x3F28 },
	{ 0x3927, 0x24B4F },
	{ 0x3928, 0x3F60 },
	{ 0x3929, 0x24C7D },
	{ 0x392A, 0x24C7E },
	{ 0x392B, 0x24C7C },
	{ 0x392C, 0x7572 },
	{ 0x392D, 0x24C8D },
	{ 0x392E, 0x24D19 },
	{ 0x392F, 0x3F9B },
	{ 0x3930, 0x3F9C },
	{ 0x3931, 0x24DC0 },
	{ 0x3932, 0x3F93 },
	{ 0x3933, 0x3F94 },
	{ 0x3934, 0x75DC },
	{ 0x3935, 0x3FA0 },
	{ 0x3936, 0x3F99 },
	{ 0x3937, 0x24DB6 },
	{ 0x3938, 0x3FA1 },
	{ 0x3939, 0x24DA8 },
	{ 0x393A, 0x3FF1 },
	{ 0x393B, 0x24FEB },
	{ 0x393C, 0x24FE7 },
	{ 0x393D, 0x2506F },
	{ 0x393E, 0x251C7 },
	{ 0x393F, 0x4036 },
	{ 0x3940, 0x2519F },
	{ 0x3941, 0x4037 },
	{ 0x3942, 0x403F },
	{ 0x3943, 0x403C },
	{ 0x3944, 0x251C4 },
	{ 0x3945, 0x4034 },
	{ 0x3946, 0x4039 },
	{ 0x3947, 0x403B },
	{ 0x3948, 0x4035 },
	{ 0x3949, 0x4030 },
	{ 0x394A, 0x4032 },
	{ 0x394B, 0x4038 },
	{ 0x394C, 0x403E },
	{ 0x394D, 0x403A },
	{ 0x394E, 0x2519B },
	{ 0x394F, 0x25197 },
	{ 0x3950, 0x251C5 },
	{ 0x3951, 0x2536B },
	{ 0x3952, 0x253CE },
	{ 0x3953, 0x40B6 },
	{ 0x3954, 0x7867 },
	{ 0x3955, 0x254B1 },
	{ 0x3956, 0x254AE },
	{ 0x3957, 0x254B0 },
	{ 0x3958, 0x40B3 },
	{ 0x3959, 0x4109 },
	{ 0x395A, 0x7977 },
	{ 0x395B, 0x2573E },
	{ 0x395C, 0x257B5 },
	{ 0x395D, 0x257BA },
	{ 0x395E, 0x414C },
	{ 0x395F, 0x257B2 },
	{ 0x3960, 0x257B4 },
	{ 0x3961, 0x4153 },
	{ 0x3962, 0x414D },
	{ 0x3963, 0x4151 },
	{ 0x3964, 0x414F },
	{ 0x3965, 0x7A9B },
	{ 0x3966, 0x25977 },
	{ 0x3967, 0x41A2 },
	{ 0x3968, 0x25986 },
	{ 0x3969, 0x2597B },
	{ 0x396A, 0x41CD },
	{ 0x396B, 0x25A7E },
	{ 0x396C, 0x25B2E },
	{ 0x396D, 0x41E7 },
	{ 0x396E, 0x25B2F },
	{ 0x396F, 0x41F0 },
	{ 0x3970, 0x25B37 },
	{ 0x3971, 0x41E9 },
	{ 0x3972, 0x41EC },
	{ 0x3973, 0x25B32 },
	{ 0x3974, 0x41E8 },
	{ 0x3975, 0x41EE },
	{ 0x3976, 0x4202 },
	{ 0x3977, 0x25B36 },
	{ 0x3978, 0x25B39 },
	{ 0x3979, 0x25B35 },
	{ 0x397A, 0x25E5C },
	{ 0x397B, 0x4282 },
	{ 0x397C, 0x4283 },
	{ 0x397D, 0x4286 },
	{ 0x397E, 0x25E7B },
	{ 0x3A21, 0x25E61 },
	{ 0x3A22, 0x25FEE },
	{ 0x3A23, 0x25FEB },
	{ 0x3A24, 0x25FEF },
	{ 0x3A25, 0x26020 },
	{ 0x3A26, 0x7D2A },
	{ 0x3A27, 0x7D65 },
	{ 0x3A28, 0x434A },
	{ 0x3A29, 0x26230 },
	{ 0x3A2A, 0x435A },
	{ 0x3A2B, 0x7F64 },
	{ 0x3A2C, 0x262BE },
	{ 0x3A2D, 0x436E },
	{ 0x3A2E, 0x26367 },
	{ 0x3A2F, 0x2637C },
	{ 0x3A30, 0x4370 },
	{ 0x3A31, 0x436F },
	{ 0x3A32, 0x26424 },
	{ 0x3A33, 0x438A },
	{ 0x3A34, 0x4387 },
	{ 0x3A35, 0x4388 },
	{ 0x3A36, 0x26429 },
	{ 0x3A37, 0x264EF },
	{ 0x3A38, 0x8020 },
	{ 0x3A39, 0x43B7 },
	{ 0x3A3A, 0x43FD },
	{ 0x3A3B, 0x8120 },
	{ 0x3A3C, 0x2670D },
	{ 0x3A3D, 0x4405 },
	{ 0x3A3E, 0x813C },
	{ 0x3A3F, 0x4408 },
	{ 0x3A40, 0x4403 },
	{ 0x3A41, 0x4402 },
	{ 0x3A42, 0x4404 },
	{ 0x3A43, 0x3B39 },
	{ 0x3A44, 0x4409 },
	{ 0x3A45, 0x43FF },
	{ 0x3A46, 0x26764 },
	{ 0x3A47, 0x813F },
	{ 0x3A48, 0x26715 },
	{ 0x3A49, 0x43FC },
	{ 0x3A4A, 0x4401 },
	{ 0x3A4B, 0x440A },
	{ 0x3A4C, 0x81F0 },
	{ 0x3A4D, 0x81F5 },
	{ 0x3A4E, 0x446B },
	{ 0x3A4F, 0x446C },
	{ 0x3A50, 0x26A35 },
	{ 0x3A51, 0x26A36 },
	{ 0x3A52, 0x26A34 },
	{ 0x3A53, 0x26A37 },
	{ 0x3A54, 0x26C47 },
	{ 0x3A55, 0x26C2B },
	{ 0x3A56, 0x44DE },
	{ 0x3A57, 0x26C41 },
	{ 0x3A58, 0x26C43 },
	{ 0x3A59, 0x44DB },
	{ 0x3A5A, 0x26C42 },
	{ 0x3A5B, 0x44DD },
	{ 0x3A5C, 0x44E3 },
	{ 0x3A5D, 0x26C32 },
	{ 0x3A5E, 0x44E0 },
	{ 0x3A5F, 0x44D9 },
	{ 0x3A60, 0x44D8 },
	{ 0x3A61, 0x44E4 },
	{ 0x3A62, 0x26C44 },
	{ 0x3A63, 0x26C4A },
	{ 0x3A64, 0x44DA },
	{ 0x3A65, 0x44EF },
	{ 0x3A66, 0x2F9A0 },
	{ 0x3A67, 0x8415 },
	{ 0x3A68, 0x83BE },
	{ 0x3A69, 0x26C54 },
	{ 0x3A6A, 0x26C6E },
	{ 0x3A6B, 0x26C52 },
	{ 0x3A6C, 0x44D7 },
	{ 0x3A6D, 0x45B3 },
	{ 0x3A6E, 0x45BB },
	{ 0x3A6F, 0x86E5 },
	{ 0x3A70, 0x45B2 },
	{ 0x3A71, 0x86D2 },
	{ 0x3A72, 0x45AD },
	{ 0x3A73, 0x27292 },
	{ 0x3A74, 0x45AF },
	{ 0x3A75, 0x2F9B8 },
	{ 0x3A76, 0x86E0 },
	{ 0x3A77, 0x272BF },
	{ 0x3A78, 0x4616 },
	{ 0x3A79, 0x4628 },
	{ 0x3A7A, 0x4623 },
	{ 0x3A7B, 0x88B3 },
	{ 0x3A7C, 0x27641 },
	{ 0x3A7D, 0x27669 },
	{ 0x3A7E, 0x27665 },
	{ 0x3B21, 0x4675 },
	{ 0x3B22, 0x467E },
	{ 0x3B23, 0x467C },
	{ 0x3B24, 0x27822 },
	{ 0x3B25, 0x2781D },
	{ 0x3B26, 0x278D2 },
	{ 0x3B27, 0x278DA },
	{ 0x3B28, 0x278DB },
	{ 0x3B29, 0x46CE },
	{ 0x3B2A, 0x46CD },
	{ 0x3B2B, 0x46CF },
	{ 0x3B2C, 0x8A53 },
	{ 0x3B2D, 0x279A4 },
	{ 0x3B2E, 0x2799E },
	{ 0x3B2F, 0x8A37 },
	{ 0x3B30, 0x8A47 },
	{ 0x3B31, 0x8A5C },
	{ 0x3B32, 0x2799D },
	{ 0x3B33, 0x46C4 },
	{ 0x3B34, 0x46CC },
	{ 0x3B35, 0x46C8 },
	{ 0x3B36, 0x46C7 },
	{ 0x3B37, 0x279AD },
	{ 0x3B38, 0x279A6 },
	{ 0x3B39, 0x279A7 },
	{ 0x3B3A, 0x27BB3 },
	{ 0x3B3B, 0x27BE0 },
	{ 0x3B3C, 0x27C35 },
	{ 0x3B3D, 0x27C37 },
	{ 0x3B3E, 0x475A },
	{ 0x3B3F, 0x476A },
	{ 0x3B40, 0x27D4A },
	{ 0x3B41, 0x476B },
	{ 0x3B42, 0x476D },
	{ 0x3B43, 0x476F },
	{ 0x3B44, 0x27E5E },
	{ 0x3B45, 0x479E },
	{ 0x3B46, 0x27EC0 },
	{ 0x3B47, 0x47A4 },
	{ 0x3B48, 0x47A3 },
	{ 0x3B49, 0x47E4 },
	{ 0x3B4A, 0x47E8 },
	{ 0x3B4B, 0x47E9 },
	{ 0x3B4C, 0x47E0 },
	{ 0x3B4D, 0x47E3 },
	{ 0x3B4E, 0x27FF9 },
	{ 0x3B4F, 0x47EA },
	{ 0x3B50, 0x47E1 },
	{ 0x3B51, 0x47ED },
	{ 0x3B52, 0x4834 },
	{ 0x3B53, 0x4835 },
	{ 0x3B54, 0x4851 },
	{ 0x3B55, 0x8EF0 },
	{ 0x3B56, 0x284F0 },
	{ 0x3B57, 0x489D },
	{ 0x3B58, 0x284F3 },
	{ 0x3B59, 0x2851B },
	{ 0x3B5A, 0x284F2 },
	{ 0x3B5B, 0x284FB },
	{ 0x3B5C, 0x2871C },
	{ 0x3B5D, 0x28713 },
	{ 0x3B5E, 0x48D0 },
	{ 0x3B5F, 0x2870F },
	{ 0x3B60, 0x48EE },
	{ 0x3B61, 0x28816 },
	{ 0x3B62, 0x28811 },
	{ 0x3B63, 0x28812 },
	{ 0x3B64, 0x48F2 },
	{ 0x3B65, 0x2880E },
	{ 0x3B66, 0x921D },
	{ 0x3B67, 0x4988 },
	{ 0x3B68, 0x28C67 },
	{ 0x3B69, 0x28CF2 },
	{ 0x3B6A, 0x28CDA },
	{ 0x3B6B, 0x498F },
	{ 0x3B6C, 0x28CDC },
	{ 0x3B6D, 0x49D8 },
	{ 0x3B6E, 0x28F94 },
	{ 0x3B6F, 0x28F9B },
	{ 0x3B70, 0x28F92 },
	{ 0x3B71, 0x28F9A },
	{ 0x3B72, 0x29088 },
	{ 0x3B73, 0x29086 },
	{ 0x3B74, 0x4A3F },
	{ 0x3B75, 0x291EF },
	{ 0x3B76, 0x4A52 },
	{ 0x3B77, 0x976B },
	{ 0x3B78, 0x2925E },
	{ 0x3B79, 0x4A50 },
	{ 0x3B7A, 0x29458 },
	{ 0x3B7B, 0x4AB1 },
	{ 0x3B7C, 0x29456 },
	{ 0x3B7D, 0x29454 },
	{ 0x3B7E, 0x4AF9 },
	{ 0x3C21, 0x2959B },
	{ 0x3C22, 0x29696 },
	{ 0x3C23, 0x296A4 },
	{ 0x3C24, 0x4B26 },
	{ 0x3C25, 0x4B28 },
	{ 0x3C26, 0x2969A },
	{ 0x3C27, 0x29A12 },
	{ 0x3C28, 0x3480 },
	{ 0x3C29, 0x50C0 },
	{ 0x3C2A, 0x3481 },
	{ 0x3C2B, 0x2036B },
	{ 0x3C2C, 0x347E },
	{ 0x3C2D, 0x347F },
	{ 0x3C2E, 0x20337 },
	{ 0x3C2F, 0x2033C },
	{ 0x3C30, 0x2F80A },
	{ 0x3C31, 0x204F7 },
	{ 0x3C32, 0x34BE },
	{ 0x3C33, 0x20566 },
	{ 0x3C34, 0x34D6 },
	{ 0x3C35, 0x207A9 },
	{ 0x3C36, 0x207AE },
	{ 0x3C37, 0x207AD },
	{ 0x3C38, 0x207C8 },
	{ 0x3C39, 0x207A5 },
	{ 0x3C3A, 0x207B0 },
	{ 0x3C3B, 0x20895 },
	{ 0x3C3C, 0x52E5 },
	{ 0x3C3D, 0x20925 },
	{ 0x3C3E, 0x3534 },
	{ 0x3C3F, 0x20A99 },
	{ 0x3C40, 0x53AF },
	{ 0x3C41, 0x20B74 },
	{ 0x3C42, 0x20B70 },
	{ 0x3C43, 0x20B6F },
	{ 0x3C44, 0x20E41 },
	{ 0x3C45, 0x20E54 },
	{ 0x3C46, 0x35D5 },
	{ 0x3C47, 0x35D8 },
	{ 0x3C48, 0x20E40 },
	{ 0x3C49, 0x20E38 },
	{ 0x3C4A, 0x35D4 },
	{ 0x3C4B, 0x55D8 },
	{ 0x3C4C, 0x35D9 },
	{ 0x3C4D, 0x20E52 },
	{ 0x3C4E, 0x20E3A },
	{ 0x3C4F, 0x20E57 },
	{ 0x3C50, 0x2F84A },
	{ 0x3C51, 0x20E59 },
	{ 0x3C52, 0x5711 },
	{ 0x3C53, 0x5867 },
	{ 0x3C54, 0x213B4 },
	{ 0x3C55, 0x213C0 },
	{ 0x3C56, 0x365D },
	{ 0x3C57, 0x5843 },
	{ 0x3C58, 0x365E },
	{ 0x3C59, 0x3659 },
	{ 0x3C5A, 0x21375 },
	{ 0x3C5B, 0x365A },
	{ 0x3C5C, 0x36A0 },
	{ 0x3C5D, 0x21660 },
	{ 0x3C5E, 0x21647 },
	{ 0x3C5F, 0x3705 },
	{ 0x3C60, 0x217F0 },
	{ 0x3C61, 0x3707 },
	{ 0x3C62, 0x217EF },
	{ 0x3C63, 0x370E },
	{ 0x3C64, 0x370C },
	{ 0x3C65, 0x217EC },
	{ 0x3C66, 0x21983 },
	{ 0x3C67, 0x3745 },
	{ 0x3C68, 0x21984 },
	{ 0x3C69, 0x2198F },
	{ 0x3C6A, 0x3764 },
	{ 0x3C6B, 0x21A61 },
	{ 0x3C6C, 0x3765 },
	{ 0x3C6D, 0x21A69 },
	{ 0x3C6E, 0x5BDD },
	{ 0x3C6F, 0x3766 },
	{ 0x3C70, 0x21A62 },
	{ 0x3C71, 0x3789 },
	{ 0x3C72, 0x37EC },
	{ 0x3C73, 0x37F1 },
	{ 0x3C74, 0x5D70 },
	{ 0x3C75, 0x5D6A },
	{ 0x3C76, 0x37F0 },
	{ 0x3C77, 0x37F8 },
	{ 0x3C78, 0x5D74 },
	{ 0x3C79, 0x5D5F },
	{ 0x3C7A, 0x21EAE },
	{ 0x3C7B, 0x5D61 },
	{ 0x3C7C, 0x5D73 },
	{ 0x3C7D, 0x21EB2 },
	{ 0x3C7E, 0x37F2 },
	{ 0x3D21, 0x37F4 },
	{ 0x3D22, 0x2210B },
	{ 0x3D23, 0x3858 },
	{ 0x3D24, 0x22110 },
	{ 0x3D25, 0x2210D },
	{ 0x3D26, 0x385A },
	{ 0x3D27, 0x3859 },
	{ 0x3D28, 0x3857 },
	{ 0x3D29, 0x385B },
	{ 0x3D2A, 0x5E50 },
	{ 0x3D2B, 0x2227F },
	{ 0x3D2C, 0x22281 },
	{ 0x3D2D, 0x38A6 },
	{ 0x3D2E, 0x38C2 },
	{ 0x3D2F, 0x38C1 },
	{ 0x3D30, 0x5F3F },
	{ 0x3D31, 0x2240B },
	{ 0x3D32, 0x2254E },
	{ 0x3D33, 0x38EF },
	{ 0x3D34, 0x5FB0 },
	{ 0x3D35, 0x227EA },
	{ 0x3D36, 0x22745 },
	{ 0x3D37, 0x3968 },
	{ 0x3D38, 0x6135 },
	{ 0x3D39, 0x612D },
	{ 0x3D3A, 0x3973 },
	{ 0x3D3B, 0x396E },
	{ 0x3D3C, 0x3974 },
	{ 0x3D3D, 0x6102 },
	{ 0x3D3E, 0x3966 },
	{ 0x3D3F, 0x22728 },
	{ 0x3D40, 0x2275D },
	{ 0x3D41, 0x229DC },
	{ 0x3D42, 0x39B9 },
	{ 0x3D43, 0x6226 },
	{ 0x3D44, 0x229D4 },
	{ 0x3D45, 0x3A0C },
	{ 0x3D46, 0x22C64 },
	{ 0x3D47, 0x22C68 },
	{ 0x3D48, 0x3A20 },
	{ 0x3D49, 0x22C62 },
	{ 0x3D4A, 0x3A1D },
	{ 0x3D4B, 0x22C61 },
	{ 0x3D4C, 0x3A1C },
	{ 0x3D4D, 0x22C66 },
	{ 0x3D4E, 0x3A21 },
	{ 0x3D4F, 0x3A1A },
	{ 0x3D50, 0x3A19 },
	{ 0x3D51, 0x22BF2 },
	{ 0x3D52, 0x22C69 },
	{ 0x3D53, 0x22C67 },
	{ 0x3D54, 0x3A7E },
	{ 0x3D55, 0x22F9A },
	{ 0x3D56, 0x22F9B },
	{ 0x3D57, 0x22F85 },
	{ 0x3D58, 0x22F9C },
	{ 0x3D59, 0x3A9D },
	{ 0x3D5A, 0x22FA4 },
	{ 0x3D5B, 0x3A9E },
	{ 0x3D5C, 0x3A9C },
	{ 0x3D5D, 0x656E },
	{ 0x3D5E, 0x22F99 },
	{ 0x3D5F, 0x22F86 },
	{ 0x3D60, 0x22F90 },
	{ 0x3D61, 0x23081 },
	{ 0x3D62, 0x230AE },
	{ 0x3D63, 0x65B1 },
	{ 0x3D64, 0x65D4 },
	{ 0x3D65, 0x3ACD },
	{ 0x3D66, 0x23138 },
	{ 0x3D67, 0x3B0B },
	{ 0x3D68, 0x3B0A },
	{ 0x3D69, 0x6685 },
	{ 0x3D6A, 0x2353B },
	{ 0x3D6B, 0x3B8F },
	{ 0x3D6C, 0x6972 },
	{ 0x3D6D, 0x3B95 },
	{ 0x3D6E, 0x3B90 },
	{ 0x3D6F, 0x3B91 },
	{ 0x3D70, 0x2354C },
	{ 0x3D71, 0x693A },
	{ 0x3D72, 0x3BB9 },
	{ 0x3D73, 0x23547 },
	{ 0x3D74, 0x23535 },
	{ 0x3D75, 0x3B97 },
	{ 0x3D76, 0x3B9E },
	{ 0x3D77, 0x23533 },
	{ 0x3D78, 0x3B8B },
	{ 0x3D79, 0x23582 },
	{ 0x3D7A, 0x23540 },
	{ 0x3D7B, 0x3C3B },
	{ 0x3D7C, 0x3C3A },
	{ 0x3D7D, 0x3C3C },
	{ 0x3D7E, 0x3C3D },
	{ 0x3E21, 0x3C39 },
	{ 0x3E22, 0x3C3E },
	{ 0x3E23, 0x3C6B },
	{ 0x3E24, 0x3C6C },
	{ 0x3E25, 0x23A36 },
	{ 0x3E26, 0x23B0E },
	{ 0x3E27, 0x3CA2 },
	{ 0x3E28, 0x3CA1 },
	{ 0x3E29, 0x3C9F },
	{ 0x3E2A, 0x23BAD },
	{ 0x3E2B, 0x23BAA },
	{ 0x3E2C, 0x23E17 },
	{ 0x3E2D, 0x3D2D },
	{ 0x3E2E, 0x23E67 },
	{ 0x3E2F, 0x3D36 },
	{ 0x3E30, 0x3D2B },
	{ 0x3E31, 0x23E72 },
	{ 0x3E32, 0x3D37 },
	{ 0x3E33, 0x2F90A },
	{ 0x3E34, 0x23E61 },
	{ 0x3E35, 0x23EB0 },
	{ 0x3E36, 0x6EAD },
	{ 0x3E37, 0x3D25 },
	{ 0x3E38, 0x3D2F },
	{ 0x3E39, 0x3D2C },
	{ 0x3E3A, 0x23E6E },
	{ 0x3E3B, 0x23E64 },
	{ 0x3E3C, 0x3D32 },
	{ 0x3E3D, 0x23E8C },
	{ 0x3E3E, 0x23E66 },
	{ 0x3E3F, 0x6E95 },
	{ 0x3E40, 0x23E6B },
	{ 0x3E41, 0x23E5F },
	{ 0x3E42, 0x23E74 },
	{ 0x3E43, 0x23E65 },
	{ 0x3E44, 0x242BB },
	{ 0x3E45, 0x242BE },
	{ 0x3E46, 0x3DD5 },
	{ 0x3E47, 0x242B9 },
	{ 0x3E48, 0x3DD4 },
	{ 0x3E49, 0x3DD6 },
	{ 0x3E4A, 0x242EF },
	{ 0x3E4B, 0x3DD1 },
	{ 0x3E4C, 0x7243 },
	{ 0x3E4D, 0x245DA },
	{ 0x3E4E, 0x3E46 },
	{ 0x3E4F, 0x728F },
	{ 0x3E50, 0x24690 },
	{ 0x3E51, 0x247E9 },
	{ 0x3E52, 0x3E8C },
	{ 0x3E53, 0x3E8A },
	{ 0x3E54, 0x3E88 },
	{ 0x3E55, 0x24811 },
	{ 0x3E56, 0x2480D },
	{ 0x3E57, 0x247ED },
	{ 0x3E58, 0x24821 },
	{ 0x3E59, 0x3EDD },
	{ 0x3E5A, 0x24981 },
	{ 0x3E5B, 0x249B1 },
	{ 0x3E5C, 0x24B01 },
	{ 0x3E5D, 0x3F2D },
	{ 0x3E5E, 0x24B5E },
	{ 0x3E5F, 0x24B62 },
	{ 0x3E60, 0x3F2E },
	{ 0x3E61, 0x3F2C },
	{ 0x3E62, 0x3F2B },
	{ 0x3E63, 0x3F30 },
	{ 0x3E64, 0x24B5B },
	{ 0x3E65, 0x3F4E },
	{ 0x3E66, 0x24C96 },
	{ 0x3E67, 0x24C93 },
	{ 0x3E68, 0x3F64 },
	{ 0x3E69, 0x3F61 },
	{ 0x3E6A, 0x24C92 },
	{ 0x3E6B, 0x7575 },
	{ 0x3E6C, 0x2F939 },
	{ 0x3E6D, 0x3F70 },
	{ 0x3E6E, 0x3FA6 },
	{ 0x3E6F, 0x3FA4 },
	{ 0x3E70, 0x24DC4 },
	{ 0x3E71, 0x24DC7 },
	{ 0x3E72, 0x24DC3 },
	{ 0x3E73, 0x3FA8 },
	{ 0x3E74, 0x3FA2 },
	{ 0x3E75, 0x24DC8 },
	{ 0x3E76, 0x3FA7 },
	{ 0x3E77, 0x75EC },
	{ 0x3E78, 0x3FA5 },
	{ 0x3E79, 0x24DCA },
	{ 0x3E7A, 0x3FA9 },
	{ 0x3E7B, 0x24DC5 },
	{ 0x3E7C, 0x24DCF },
	{ 0x3E7D, 0x24DDC },
	{ 0x3E7E, 0x24F7C },
	{ 0x3F21, 0x25001 },
	{ 0x3F22, 0x403D },
	{ 0x3F23, 0x251D3 },
	{ 0x3F24, 0x251DC },
	{ 0x3F25, 0x4044 },
	{ 0x3F26, 0x4045 },
	{ 0x3F27, 0x4046 },
	{ 0x3F28, 0x251D4 },
	{ 0x3F29, 0x7757 },
	{ 0x3F2A, 0x251CC },
	{ 0x3F2B, 0x4047 },
	{ 0x3F2C, 0x4048 },
	{ 0x3F2D, 0x4042 },
	{ 0x3F2E, 0x251D6 },
	{ 0x3F2F, 0x251DB },
	{ 0x3F30, 0x4041 },
	{ 0x3F31, 0x251D5 },
	{ 0x3F32, 0x253D9 },
	{ 0x3F33, 0x4094 },
	{ 0x3F34, 0x253DD },
	{ 0x3F35, 0x253DC },
	{ 0x3F36, 0x253E0 },
	{ 0x3F37, 0x254CC },
	{ 0x3F38, 0x40C0 },
	{ 0x3F39, 0x40B8 },
	{ 0x3F3A, 0x40C1 },
	{ 0x3F3B, 0x40C2 },
	{ 0x3F3C, 0x40BB },
	{ 0x3F3D, 0x40BD },
	{ 0x3F3E, 0x40BF },
	{ 0x3F3F, 0x40B9 },
	{ 0x3F40, 0x40B7 },
	{ 0x3F41, 0x254D2 },
	{ 0x3F42, 0x40C7 },
	{ 0x3F43, 0x254D3 },
	{ 0x3F44, 0x410C },
	{ 0x3F45, 0x410B },
	{ 0x3F46, 0x797B },
	{ 0x3F47, 0x4110 },
	{ 0x3F48, 0x2568D },
	{ 0x3F49, 0x415D },
	{ 0x3F4A, 0x7A21 },
	{ 0x3F4B, 0x415A },
	{ 0x3F4C, 0x4158 },
	{ 0x3F4D, 0x4156 },
	{ 0x3F4E, 0x257D8 },
	{ 0x3F4F, 0x4154 },
	{ 0x3F50, 0x7A16 },
	{ 0x3F51, 0x257BC },
	{ 0x3F52, 0x41A8 },
	{ 0x3F53, 0x41A7 },
	{ 0x3F54, 0x41CF },
	{ 0x3F55, 0x41D0 },
	{ 0x3F56, 0x25A8A },
	{ 0x3F57, 0x7AE8 },
	{ 0x3F58, 0x25A8B },
	{ 0x3F59, 0x25A8D },
	{ 0x3F5A, 0x41D1 },
	{ 0x3F5B, 0x41EB },
	{ 0x3F5C, 0x25B53 },
	{ 0x3F5D, 0x41FB },
	{ 0x3F5E, 0x7B6A },
	{ 0x3F5F, 0x25B59 },
	{ 0x3F60, 0x41FD },
	{ 0x3F61, 0x41F8 },
	{ 0x3F62, 0x41F7 },
	{ 0x3F63, 0x4200 },
	{ 0x3F64, 0x25B56 },
	{ 0x3F65, 0x25B57 },
	{ 0x3F66, 0x41F6 },
	{ 0x3F67, 0x7B5F },
	{ 0x3F68, 0x25E73 },
	{ 0x3F69, 0x2601B },
	{ 0x3F6A, 0x42DF },
	{ 0x3F6B, 0x26021 },
	{ 0x3F6C, 0x26016 },
	{ 0x3F6D, 0x26018 },
	{ 0x3F6E, 0x42E2 },
	{ 0x3F6F, 0x42E4 },
	{ 0x3F70, 0x26044 },
	{ 0x3F71, 0x7D82 },
	{ 0x3F72, 0x26026 },
	{ 0x3F73, 0x42E3 },
	{ 0x3F74, 0x26236 },
	{ 0x3F75, 0x4359 },
	{ 0x3F76, 0x4371 },
	{ 0x3F77, 0x438E },
	{ 0x3F78, 0x438C },
	{ 0x3F79, 0x2643A },
	{ 0x3F7A, 0x43A4 },
	{ 0x3F7B, 0x264F4 },
	{ 0x3F7C, 0x8055 },
	{ 0x3F7D, 0x4414 },
	{ 0x3F7E, 0x26762 },
	{ 0x4021, 0x2675B },
	{ 0x4022, 0x2676A },
	{ 0x4023, 0x4411 },
	{ 0x4024, 0x26768 },
	{ 0x4025, 0x441B },
	{ 0x4026, 0x4412 },
	{ 0x4027, 0x440E },
	{ 0x4028, 0x4415 },
	{ 0x4029, 0x8168 },
	{ 0x402A, 0x4410 },
	{ 0x402B, 0x26781 },
	{ 0x402C, 0x4417 },
	{ 0x402D, 0x8246 },
	{ 0x402E, 0x8243 },
	{ 0x402F, 0x4470 },
	{ 0x4030, 0x44ED },
	{ 0x4031, 0x26CE7 },
	{ 0x4032, 0x44EE },
	{ 0x4033, 0x26CE6 },
	{ 0x4034, 0x26CD1 },
	{ 0x4035, 0x26D11 },
	{ 0x4036, 0x8481 },
	{ 0x4037, 0x26CD0 },
	{ 0x4038, 0x26CD9 },
	{ 0x4039, 0x26D0A },
	{ 0x403A, 0x44F4 },
	{ 0x403B, 0x26CDA },
	{ 0x403C, 0x26CDD },
	{ 0x403D, 0x26CC8 },
	{ 0x403E, 0x26CE2 },
	{ 0x403F, 0x26CE9 },
	{ 0x4040, 0x26CCB },
	{ 0x4041, 0x847C },
	{ 0x4042, 0x26CCC },
	{ 0x4043, 0x26CC1 },
	{ 0x4044, 0x846A },
	{ 0x4045, 0x26CDE },
	{ 0x4046, 0x8488 },
	{ 0x4047, 0x44F2 },
	{ 0x4048, 0x44F8 },
	{ 0x4049, 0x44F3 },
	{ 0x404A, 0x26D51 },
	{ 0x404B, 0x26D12 },
	{ 0x404C, 0x44FA },
	{ 0x404D, 0x26CE0 },
	{ 0x404E, 0x26D2B },
	{ 0x404F, 0x2F9B4 },
	{ 0x4050, 0x272D8 },
	{ 0x4051, 0x272D1 },
	{ 0x4052, 0x8710 },
	{ 0x4053, 0x272D2 },
	{ 0x4054, 0x272CD },
	{ 0x4055, 0x871F },
	{ 0x4056, 0x45B6 },
	{ 0x4057, 0x45B7 },
	{ 0x4058, 0x2733D },
	{ 0x4059, 0x870F },
	{ 0x405A, 0x272CA },
	{ 0x405B, 0x45BA },
	{ 0x405C, 0x272CB },
	{ 0x405D, 0x45BC },
	{ 0x405E, 0x272D7 },
	{ 0x405F, 0x275F4 },
	{ 0x4060, 0x463B },
	{ 0x4061, 0x88D3 },
	{ 0x4062, 0x462F },
	{ 0x4063, 0x27687 },
	{ 0x4064, 0x2768B },
	{ 0x4065, 0x27683 },
	{ 0x4066, 0x4637 },
	{ 0x4067, 0x4699 },
	{ 0x4068, 0x279C5 },
	{ 0x4069, 0x279D2 },
	{ 0x406A, 0x279C6 },
	{ 0x406B, 0x279D3 },
	{ 0x406C, 0x46D9 },
	{ 0x406D, 0x46D8 },
	{ 0x406E, 0x46D7 },
	{ 0x406F, 0x279F0 },
	{ 0x4070, 0x279CD },
	{ 0x4071, 0x279CC },
	{ 0x4072, 0x279DC },
	{ 0x4073, 0x279D6 },
	{ 0x4074, 0x4736 },
	{ 0x4075, 0x27BE6 },
	{ 0x4076, 0x27C41 },
	{ 0x4077, 0x27C3F },
	{ 0x4078, 0x8C87 },
	{ 0x4079, 0x27CC5 },
	{ 0x407A, 0x27CC0 },
	{ 0x407B, 0x27CC6 },
	{ 0x407C, 0x27CBE },
	{ 0x407D, 0x27CBF },
	{ 0x407E, 0x8CC6 },
	{ 0x4121, 0x4770 },
	{ 0x4122, 0x27D63 },
	{ 0x4123, 0x27ED3 },
	{ 0x4124, 0x27EDA },
	{ 0x4125, 0x27ED5 },
	{ 0x4126, 0x47A5 },
	{ 0x4127, 0x47A6 },
	{ 0x4128, 0x47A9 },
	{ 0x4129, 0x47EE },
	{ 0x412A, 0x4854 },
	{ 0x412B, 0x282EE },
	{ 0x412C, 0x4857 },
	{ 0x412D, 0x282FC },
	{ 0x412E, 0x28414 },
	{ 0x412F, 0x48A1 },
	{ 0x4130, 0x28523 },
	{ 0x4131, 0x28522 },
	{ 0x4132, 0x28530 },
	{ 0x4133, 0x286B5 },
	{ 0x4134, 0x48D3 },
	{ 0x4135, 0x28738 },
	{ 0x4136, 0x48D4 },
	{ 0x4137, 0x2873F },
	{ 0x4138, 0x48D7 },
	{ 0x4139, 0x90CC },
	{ 0x413A, 0x916D },
	{ 0x413B, 0x9170 },
	{ 0x413C, 0x48F7 },
	{ 0x413D, 0x48F6 },
	{ 0x413E, 0x48F9 },
	{ 0x413F, 0x48F8 },
	{ 0x4140, 0x9258 },
	{ 0x4141, 0x9242 },
	{ 0x4142, 0x9268 },
	{ 0x4143, 0x9269 },
	{ 0x4144, 0x28968 },
	{ 0x4145, 0x28967 },
	{ 0x4146, 0x9243 },
	{ 0x4147, 0x28965 },
	{ 0x4148, 0x9247 },
	{ 0x4149, 0x498A },
	{ 0x414A, 0x28C75 },
	{ 0x414B, 0x28CF7 },
	{ 0x414C, 0x28CF3 },
	{ 0x414D, 0x28CF6 },
	{ 0x414E, 0x4994 },
	{ 0x414F, 0x28D00 },
	{ 0x4150, 0x4993 },
	{ 0x4151, 0x28CFF },
	{ 0x4152, 0x28CF5 },
	{ 0x4153, 0x959D },
	{ 0x4154, 0x49DD },
	{ 0x4155, 0x49DC },
	{ 0x4156, 0x49F7 },
	{ 0x4157, 0x96CF },
	{ 0x4158, 0x29092 },
	{ 0x4159, 0x29206 },
	{ 0x415A, 0x4A42 },
	{ 0x415B, 0x29207 },
	{ 0x415C, 0x2926B },
	{ 0x415D, 0x4A54 },
	{ 0x415E, 0x2926C },
	{ 0x415F, 0x4A55 },
	{ 0x4160, 0x29393 },
	{ 0x4161, 0x4A8F },
	{ 0x4162, 0x29394 },
	{ 0x4163, 0x97F4 },
	{ 0x4164, 0x4AB4 },
	{ 0x4165, 0x4AB3 },
	{ 0x4166, 0x29462 },
	{ 0x4167, 0x29463 },
	{ 0x4168, 0x9809 },
	{ 0x4169, 0x2945F },
	{ 0x416A, 0x29464 },
	{ 0x416B, 0x2945B },
	{ 0x416C, 0x29459 },
	{ 0x416D, 0x4AFB },
	{ 0x416E, 0x4AFD },
	{ 0x416F, 0x295A4 },
	{ 0x4170, 0x295AC },
	{ 0x4171, 0x98AB },
	{ 0x4172, 0x4AFC },
	{ 0x4173, 0x296B5 },
	{ 0x4174, 0x4B2C },
	{ 0x4175, 0x4B2F },
	{ 0x4176, 0x296AE },
	{ 0x4177, 0x4B2B },
	{ 0x4178, 0x296C5 },
	{ 0x4179, 0x4B33 },
	{ 0x417A, 0x4B34 },
	{ 0x417B, 0x98FB },
	{ 0x417C, 0x2983B },
	{ 0x417D, 0x9AAC },
	{ 0x417E, 0x9AAE },
	{ 0x4221, 0x9AAA },
	{ 0x4222, 0x4BE8 },
	{ 0x4223, 0x29ABF },
	{ 0x4224, 0x29C2B },
	{ 0x4225, 0x29C84 },
	{ 0x4226, 0x29C80 },
	{ 0x4227, 0x29D4D },
	{ 0x4228, 0x29D4F },
	{ 0x4229, 0x9B5C },
	{ 0x422A, 0x29D4C },
	{ 0x422B, 0x29F92 },
	{ 0x422C, 0x4D5D },
	{ 0x422D, 0x50D2 },
	{ 0x422E, 0x3485 },
	{ 0x422F, 0x3488 },
	{ 0x4230, 0x203AE },
	{ 0x4231, 0x20379 },
	{ 0x4232, 0x348E },
	{ 0x4233, 0x3484 },
	{ 0x4234, 0x20371 },
	{ 0x4235, 0x50DF },
	{ 0x4236, 0x203B3 },
	{ 0x4237, 0x3483 },
	{ 0x4238, 0x2032C },
	{ 0x4239, 0x20377 },
	{ 0x423A, 0x2052F },
	{ 0x423B, 0x207C3 },
	{ 0x423C, 0x3502 },
	{ 0x423D, 0x207CD },
	{ 0x423E, 0x3506 },
	{ 0x423F, 0x3505 },
	{ 0x4240, 0x207C9 },
	{ 0x4241, 0x34FE },
	{ 0x4242, 0x3501 },
	{ 0x4243, 0x3500 },
	{ 0x4244, 0x207CE },
	{ 0x4245, 0x208A5 },
	{ 0x4246, 0x208A0 },
	{ 0x4247, 0x208FE },
	{ 0x4248, 0x20959 },
	{ 0x4249, 0x20A9A },
	{ 0x424A, 0x35E7 },
	{ 0x424B, 0x5619 },
	{ 0x424C, 0x20EE4 },
	{ 0x424D, 0x20ED7 },
	{ 0x424E, 0x20EDC },
	{ 0x424F, 0x35E6 },
	{ 0x4250, 0x20EE7 },
	{ 0x4251, 0x35ED },
	{ 0x4252, 0x35E2 },
	{ 0x4253, 0x35EB },
	{ 0x4254, 0x20EE5 },
	{ 0x4255, 0x35E8 },
	{ 0x4256, 0x35EC },
	{ 0x4257, 0x560A },
	{ 0x4258, 0x3624 },
	{ 0x4259, 0x589A },
	{ 0x425A, 0x21414 },
	{ 0x425B, 0x3662 },
	{ 0x425C, 0x213F1 },
	{ 0x425D, 0x3661 },
	{ 0x425E, 0x3660 },
	{ 0x425F, 0x3664 },
	{ 0x4260, 0x368B },
	{ 0x4261, 0x215B6 },
	{ 0x4262, 0x2166E },
	{ 0x4263, 0x2166C },
	{ 0x4264, 0x21681 },
	{ 0x4265, 0x21842 },
	{ 0x4266, 0x3719 },
	{ 0x4267, 0x3716 },
	{ 0x4268, 0x3718 },
	{ 0x4269, 0x3722 },
	{ 0x426A, 0x2181A },
	{ 0x426B, 0x371D },
	{ 0x426C, 0x3717 },
	{ 0x426D, 0x371E },
	{ 0x426E, 0x21827 },
	{ 0x426F, 0x21825 },
	{ 0x4270, 0x21817 },
	{ 0x4271, 0x2181C },
	{ 0x4272, 0x2183D },
	{ 0x4273, 0x21820 },
	{ 0x4274, 0x3769 },
	{ 0x4275, 0x376A },
	{ 0x4276, 0x21A81 },
	{ 0x4277, 0x376C },
	{ 0x4278, 0x377A },
	{ 0x4279, 0x378A },
	{ 0x427A, 0x21C09 },
	{ 0x427B, 0x21CC6 },
	{ 0x427C, 0x21CC4 },
	{ 0x427D, 0x379C },
	{ 0x427E, 0x21CC5 },
	{ 0x4321, 0x37FD },
	{ 0x4322, 0x37F9 },
	{ 0x4323, 0x21EEF },
	{ 0x4324, 0x37FF },
	{ 0x4325, 0x21EDF },
	{ 0x4326, 0x21EDE },
	{ 0x4327, 0x21EEE },
	{ 0x4328, 0x21EF5 },
	{ 0x4329, 0x21EEC },
	{ 0x432A, 0x37FC },
	{ 0x432B, 0x21EDD },
	{ 0x432C, 0x5D85 },
	{ 0x432D, 0x37FB },
	{ 0x432E, 0x3802 },
	{ 0x432F, 0x385F },
	{ 0x4330, 0x5E56 },
	{ 0x4331, 0x385E },
	{ 0x4332, 0x385D },
	{ 0x4333, 0x385C },
	{ 0x4334, 0x22122 },
	{ 0x4335, 0x5E51 },
	{ 0x4336, 0x3892 },
	{ 0x4337, 0x22297 },
	{ 0x4338, 0x22295 },
	{ 0x4339, 0x3894 },
	{ 0x433A, 0x3895 },
	{ 0x433B, 0x38D1 },
	{ 0x433C, 0x224A9 },
	{ 0x433D, 0x38F1 },
	{ 0x433E, 0x22553 },
	{ 0x433F, 0x5FB1 },
	{ 0x4340, 0x22556 },
	{ 0x4341, 0x22555 },
	{ 0x4342, 0x3977 },
	{ 0x4343, 0x396F },
	{ 0x4344, 0x227E3 },
	{ 0x4345, 0x227E2 },
	{ 0x4346, 0x3987 },
	{ 0x4347, 0x397D },
	{ 0x4348, 0x397C },
	{ 0x4349, 0x397E },
	{ 0x434A, 0x3985 },
	{ 0x434B, 0x398B },
	{ 0x434C, 0x3986 },
	{ 0x434D, 0x3980 },
	{ 0x434F, 0x227A9 },
	{ 0x4350, 0x3978 },
	{ 0x4351, 0x2F8AB },
	{ 0x4352, 0x22833 },
	{ 0x4353, 0x2280A },
	{ 0x4354, 0x39BA },
	{ 0x4355, 0x22A59 },
	{ 0x4356, 0x3A33 },
	{ 0x4357, 0x22CBC },
	{ 0x4358, 0x3A2D },
	{ 0x4359, 0x22CC4 },
	{ 0x435A, 0x22CC7 },
	{ 0x435B, 0x22CC6 },
	{ 0x435C, 0x3A37 },
	{ 0x435D, 0x645A },
	{ 0x435E, 0x6463 },
	{ 0x435F, 0x22CB8 },
	{ 0x4360, 0x22CDA },
	{ 0x4361, 0x3A2E },
	{ 0x4362, 0x22CB7 },
	{ 0x4363, 0x22CC0 },
	{ 0x4364, 0x3A3D },
	{ 0x4365, 0x22CCD },
	{ 0x4366, 0x3AA0 },
	{ 0x4367, 0x22FBC },
	{ 0x4368, 0x22FAB },
	{ 0x4369, 0x3AA3 },
	{ 0x436A, 0x23086 },
	{ 0x436B, 0x669B },
	{ 0x436C, 0x2325A },
	{ 0x436D, 0x66A3 },
	{ 0x436E, 0x3B0E },
	{ 0x436F, 0x669E },
	{ 0x4370, 0x23343 },
	{ 0x4371, 0x3BB6 },
	{ 0x4372, 0x235AC },
	{ 0x4373, 0x3BAB },
	{ 0x4374, 0x3BAD },
	{ 0x4375, 0x3BA6 },
	{ 0x4376, 0x235BE },
	{ 0x4377, 0x69B8 },
	{ 0x4378, 0x3BAA },
	{ 0x4379, 0x69BA },
	{ 0x437A, 0x3BB1 },
	{ 0x437B, 0x235AB },
	{ 0x437C, 0x3BA8 },
	{ 0x437D, 0x3BAF },
	{ 0x437E, 0x3BB0 },
	{ 0x4421, 0x3BA7 },
	{ 0x4422, 0x3BB2 },
	{ 0x4423, 0x3B9D },
	{ 0x4424, 0x3BA5 },
	{ 0x4425, 0x3BB5 },
	{ 0x4426, 0x21B3E },
	{ 0x4427, 0x69C7 },
	{ 0x4428, 0x69D7 },
	{ 0x4429, 0x238F9 },
	{ 0x442A, 0x3C41 },
	{ 0x442B, 0x238F3 },
	{ 0x442C, 0x238F7 },
	{ 0x442D, 0x6B70 },
	{ 0x442E, 0x23A45 },
	{ 0x442F, 0x23A48 },
	{ 0x4430, 0x3C72 },
	{ 0x4431, 0x6B9D },
	{ 0x4432, 0x3C6F },
	{ 0x4433, 0x3C71 },
	{ 0x4434, 0x23A44 },
	{ 0x4435, 0x3C85 },
	{ 0x4436, 0x23AAF },
	{ 0x4437, 0x23AB1 },
	{ 0x4438, 0x3CA4 },
	{ 0x4439, 0x3CA5 },
	{ 0x443A, 0x3CA6 },
	{ 0x443B, 0x23BCF },
	{ 0x443C, 0x3CA8 },
	{ 0x443D, 0x23BCB },
	{ 0x443E, 0x23BCD },
	{ 0x443F, 0x3CA3 },
	{ 0x4440, 0x23C50 },
	{ 0x4441, 0x23EEC },
	{ 0x4442, 0x23F1A },
	{ 0x4443, 0x6F16 },
	{ 0x4444, 0x6F24 },
	{ 0x4445, 0x23ED8 },
	{ 0x4446, 0x3D43 },
	{ 0x4447, 0x23ED0 },
	{ 0x4448, 0x23ED1 },
	{ 0x4449, 0x3D3D },
	{ 0x444A, 0x3D45 },
	{ 0x444B, 0x23E7B },
	{ 0x444C, 0x23ED2 },
	{ 0x444D, 0x3D44 },
	{ 0x444E, 0x23ED4 },
	{ 0x444F, 0x23EE7 },
	{ 0x4450, 0x23EDF },
	{ 0x4451, 0x23EDE },
	{ 0x4452, 0x6F45 },
	{ 0x4453, 0x23ED9 },
	{ 0x4454, 0x23ECF },
	{ 0x4455, 0x2430D },
	{ 0x4456, 0x3DE3 },
	{ 0x4457, 0x7179 },
	{ 0x4459, 0x3DDF },
	{ 0x445A, 0x3DE4 },
	{ 0x445B, 0x717A },
	{ 0x445C, 0x3DE5 },
	{ 0x445D, 0x24338 },
	{ 0x445E, 0x7254 },
	{ 0x445F, 0x3E22 },
	{ 0x4460, 0x3E4A },
	{ 0x4461, 0x246A9 },
	{ 0x4462, 0x3E49 },
	{ 0x4463, 0x3E44 },
	{ 0x4464, 0x3E4B },
	{ 0x4465, 0x3E87 },
	{ 0x4466, 0x3E89 },
	{ 0x4467, 0x3E92 },
	{ 0x4468, 0x3E91 },
	{ 0x4469, 0x3E90 },
	{ 0x446A, 0x3E8E },
	{ 0x446B, 0x2483E },
	{ 0x446C, 0x24846 },
	{ 0x446D, 0x249ED },
	{ 0x446E, 0x2F930 },
	{ 0x446F, 0x3F12 },
	{ 0x4470, 0x3F10 },
	{ 0x4471, 0x3F11 },
	{ 0x4472, 0x24B6C },
	{ 0x4473, 0x3F32 },
	{ 0x4474, 0x3F34 },
	{ 0x4475, 0x3F37 },
	{ 0x4476, 0x3F33 },
	{ 0x4477, 0x3F36 },
	{ 0x4478, 0x3F35 },
	{ 0x4479, 0x3F65 },
	{ 0x447A, 0x24CAC },
	{ 0x447B, 0x757C },
	{ 0x447C, 0x757B },
	{ 0x447D, 0x24DC9 },
	{ 0x447E, 0x7612 },
	{ 0x4521, 0x3FB0 },
	{ 0x4522, 0x24E12 },
	{ 0x4523, 0x3FAF },
	{ 0x4524, 0x3FAA },
	{ 0x4525, 0x24DFD },
	{ 0x4526, 0x24E01 },
	{ 0x4527, 0x24E11 },
	{ 0x4528, 0x3FAB },
	{ 0x4529, 0x24E89 },
	{ 0x452A, 0x24E05 },
	{ 0x452B, 0x24DFE },
	{ 0x452C, 0x24E0B },
	{ 0x452D, 0x24E20 },
	{ 0x452E, 0x24E04 },
	{ 0x452F, 0x24F88 },
	{ 0x4530, 0x3FF3 },
	{ 0x4531, 0x25002 },
	{ 0x4532, 0x3FF4 },
	{ 0x4533, 0x25003 },
	{ 0x4534, 0x76B6 },
	{ 0x4535, 0x76E0 },
	{ 0x4536, 0x4008 },
	{ 0x4537, 0x404E },
	{ 0x4538, 0x4055 },
	{ 0x4539, 0x404B },
	{ 0x453A, 0x25229 },
	{ 0x453B, 0x2523B },
	{ 0x453C, 0x404D },
	{ 0x453D, 0x7773 },
	{ 0x453E, 0x25206 },
	{ 0x453F, 0x4052 },
	{ 0x4540, 0x7772 },
	{ 0x4541, 0x404C },
	{ 0x4542, 0x7770 },
	{ 0x4543, 0x4050 },
	{ 0x4544, 0x4053 },
	{ 0x4545, 0x25203 },
	{ 0x4546, 0x4051 },
	{ 0x4547, 0x25378 },
	{ 0x4548, 0x25379 },
	{ 0x4549, 0x2537D },
	{ 0x454A, 0x4089 },
	{ 0x454B, 0x2537F },
	{ 0x454C, 0x4095 },
	{ 0x454D, 0x40CC },
	{ 0x454E, 0x40C8 },
	{ 0x454F, 0x40CE },
	{ 0x4550, 0x25532 },
	{ 0x4551, 0x40CA },
	{ 0x4552, 0x25500 },
	{ 0x4553, 0x789D },
	{ 0x4554, 0x25522 },
	{ 0x4555, 0x40CD },
	{ 0x4556, 0x256A9 },
	{ 0x4557, 0x415C },
	{ 0x4558, 0x4167 },
	{ 0x4559, 0x4169 },
	{ 0x455A, 0x4165 },
	{ 0x455B, 0x4162 },
	{ 0x455C, 0x25804 },
	{ 0x455D, 0x7A27 },
	{ 0x455E, 0x7A35 },
	{ 0x455F, 0x2F959 },
	{ 0x4560, 0x41AA },
	{ 0x4561, 0x259B8 },
	{ 0x4562, 0x25A9B },
	{ 0x4563, 0x41D2 },
	{ 0x4564, 0x7BA2 },
	{ 0x4565, 0x4203 },
	{ 0x4566, 0x420C },
	{ 0x4567, 0x25B92 },
	{ 0x4568, 0x4209 },
	{ 0x4569, 0x4206 },
	{ 0x456A, 0x4205 },
	{ 0x456B, 0x7B89 },
	{ 0x456C, 0x25B8F },
	{ 0x456D, 0x420B },
	{ 0x456E, 0x4208 },
	{ 0x456F, 0x25B98 },
	{ 0x4570, 0x7BA5 },
	{ 0x4571, 0x25BAE },
	{ 0x4572, 0x428E },
	{ 0x4573, 0x25E9D },
	{ 0x4574, 0x7CB6 },
	{ 0x4575, 0x42E8 },
	{ 0x4576, 0x26049 },
	{ 0x4577, 0x26050 },
	{ 0x4578, 0x26046 },
	{ 0x4579, 0x42EA },
	{ 0x457A, 0x2604E },
	{ 0x457B, 0x7DA5 },
	{ 0x457C, 0x7DC3 },
	{ 0x457D, 0x26055 },
	{ 0x457E, 0x42E9 },
	{ 0x4621, 0x42EB },
	{ 0x4622, 0x26064 },
	{ 0x4623, 0x42F0 },
	{ 0x4624, 0x26238 },
	{ 0x4625, 0x434B },
	{ 0x4626, 0x7FAB },
	{ 0x4627, 0x4373 },
	{ 0x4628, 0x4375 },
	{ 0x4629, 0x4392 },
	{ 0x462A, 0x4391 },
	{ 0x462B, 0x4393 },
	{ 0x462C, 0x8025 },
	{ 0x462D, 0x43A7 },
	{ 0x462E, 0x43A6 },
	{ 0x462F, 0x43A8 },
	{ 0x4630, 0x43AA },
	{ 0x4631, 0x264FE },
	{ 0x4632, 0x43A9 },
	{ 0x4633, 0x8059 },
	{ 0x4634, 0x43BB },
	{ 0x4635, 0x43BC },
	{ 0x4636, 0x43BA },
	{ 0x4637, 0x43BD },
	{ 0x4638, 0x4427 },
	{ 0x4639, 0x8185 },
	{ 0x463A, 0x267A6 },
	{ 0x463B, 0x4424 },
	{ 0x463C, 0x441E },
	{ 0x463D, 0x441F },
	{ 0x463E, 0x441D },
	{ 0x463F, 0x4420 },
	{ 0x4640, 0x4423 },
	{ 0x4641, 0x4429 },
	{ 0x4642, 0x4422 },
	{ 0x4643, 0x2679C },
	{ 0x4644, 0x26799 },
	{ 0x4645, 0x441C },
	{ 0x4646, 0x818E },
	{ 0x4647, 0x4428 },
	{ 0x4648, 0x267B5 },
	{ 0x4649, 0x267A3 },
	{ 0x464A, 0x267A0 },
	{ 0x464B, 0x267A7 },
	{ 0x464C, 0x2679B },
	{ 0x464D, 0x269DF },
	{ 0x464E, 0x269E1 },
	{ 0x464F, 0x4471 },
	{ 0x4650, 0x4473 },
	{ 0x4651, 0x4472 },
	{ 0x4652, 0x26A4D },
	{ 0x4653, 0x4502 },
	{ 0x4654, 0x26DF3 },
	{ 0x4655, 0x26D6F },
	{ 0x4656, 0x26D69 },
	{ 0x4657, 0x44FE },
	{ 0x4658, 0x84BE },
	{ 0x4659, 0x26D6B },
	{ 0x465A, 0x26D78 },
	{ 0x465B, 0x26D87 },
	{ 0x465C, 0x4508 },
	{ 0x465D, 0x26D85 },
	{ 0x465E, 0x26D82 },
	{ 0x465F, 0x26D90 },
	{ 0x4660, 0x4507 },
	{ 0x4661, 0x4504 },
	{ 0x4662, 0x26D80 },
	{ 0x4663, 0x26D67 },
	{ 0x4664, 0x4500 },
	{ 0x4665, 0x44FC },
	{ 0x4666, 0x26D61 },
	{ 0x4667, 0x4544 },
	{ 0x4668, 0x26D93 },
	{ 0x4669, 0x44F1 },
	{ 0x466A, 0x26DF2 },
	{ 0x466B, 0x26D86 },
	{ 0x466C, 0x84A6 },
	{ 0x466D, 0x4506 },
	{ 0x466E, 0x271CD },
	{ 0x466F, 0x271C4 },
	{ 0x4670, 0x45C6 },
	{ 0x4671, 0x45C3 },
	{ 0x4672, 0x45C1 },
	{ 0x4673, 0x45C2 },
	{ 0x4674, 0x2730F },
	{ 0x4675, 0x45C4 },
	{ 0x4676, 0x45C7 },
	{ 0x4677, 0x2730D },
	{ 0x4678, 0x45BF },
	{ 0x4679, 0x45D2 },
	{ 0x467A, 0x27373 },
	{ 0x467B, 0x45CA },
	{ 0x467C, 0x2F9BA },
	{ 0x467D, 0x2730A },
	{ 0x467E, 0x872F },
	{ 0x4721, 0x27308 },
	{ 0x4722, 0x27313 },
	{ 0x4723, 0x4613 },
	{ 0x4724, 0x275F8 },
	{ 0x4725, 0x4630 },
	{ 0x4726, 0x463E },
	{ 0x4727, 0x4639 },
	{ 0x4728, 0x276AB },
	{ 0x4729, 0x276A8 },
	{ 0x472A, 0x463C },
	{ 0x472B, 0x463F },
	{ 0x472C, 0x276A5 },
	{ 0x472D, 0x4634 },
	{ 0x472E, 0x463D },
	{ 0x472F, 0x276C3 },
	{ 0x4730, 0x276A4 },
	{ 0x4731, 0x4638 },
	{ 0x4732, 0x276D4 },
	{ 0x4733, 0x276BA },
	{ 0x4734, 0x277F1 },
	{ 0x4735, 0x89A0 },
	{ 0x4736, 0x4682 },
	{ 0x4737, 0x2783F },
	{ 0x4738, 0x4683 },
	{ 0x4739, 0x278EA },
	{ 0x473A, 0x469B },
	{ 0x473B, 0x279F7 },
	{ 0x473C, 0x46E0 },
	{ 0x473D, 0x46DD },
	{ 0x473E, 0x279FA },
	{ 0x473F, 0x279F5 },
	{ 0x4740, 0x46DE },
	{ 0x4741, 0x279FE },
	{ 0x4742, 0x46E3 },
	{ 0x4743, 0x46E5 },
	{ 0x4744, 0x27A00 },
	{ 0x4745, 0x8A97 },
	{ 0x4746, 0x46E2 },
	{ 0x4747, 0x27A02 },
	{ 0x4748, 0x279FB },
	{ 0x4749, 0x27A07 },
	{ 0x474A, 0x46DF },
	{ 0x474B, 0x27A1A },
	{ 0x474C, 0x472E },
	{ 0x474D, 0x27BB8 },
	{ 0x474E, 0x4737 },
	{ 0x474F, 0x4738 },
	{ 0x4750, 0x27BE9 },
	{ 0x4751, 0x27BEB },
	{ 0x4752, 0x27C50 },
	{ 0x4753, 0x27C4F },
	{ 0x4754, 0x8C8B },
	{ 0x4755, 0x27D86 },
	{ 0x4756, 0x3562 },
	{ 0x4757, 0x27D8E },
	{ 0x4758, 0x4794 },
	{ 0x4759, 0x4793 },
	{ 0x475A, 0x47AB },
	{ 0x475B, 0x47AD },
	{ 0x475C, 0x27EF0 },
	{ 0x475D, 0x27EFB },
	{ 0x475E, 0x47F5 },
	{ 0x475F, 0x47F7 },
	{ 0x4760, 0x28042 },
	{ 0x4761, 0x47F6 },
	{ 0x4762, 0x47F8 },
	{ 0x4763, 0x28085 },
	{ 0x4764, 0x47FB },
	{ 0x4765, 0x47F9 },
	{ 0x4766, 0x4858 },
	{ 0x4767, 0x485A },
	{ 0x4768, 0x28305 },
	{ 0x4769, 0x4859 },
	{ 0x476A, 0x8F0F },
	{ 0x476B, 0x4885 },
	{ 0x476C, 0x48A4 },
	{ 0x476D, 0x48D8 },
	{ 0x476E, 0x48D9 },
	{ 0x476F, 0x2874B },
	{ 0x4770, 0x48DD },
	{ 0x4771, 0x48C8 },
	{ 0x4772, 0x28763 },
	{ 0x4773, 0x48FA },
	{ 0x4774, 0x48FB },
	{ 0x4775, 0x9275 },
	{ 0x4776, 0x4927 },
	{ 0x4777, 0x929F },
	{ 0x4778, 0x492A },
	{ 0x4779, 0x4925 },
	{ 0x477A, 0x28999 },
	{ 0x477B, 0x4928 },
	{ 0x477C, 0x28C81 },
	{ 0x477D, 0x28D17 },
	{ 0x477E, 0x28D10 },
	{ 0x4821, 0x28D12 },
	{ 0x4822, 0x95A6 },
	{ 0x4823, 0x4995 },
	{ 0x4824, 0x969A },
	{ 0x4825, 0x28EFA },
	{ 0x4826, 0x28EF3 },
	{ 0x4827, 0x28EF2 },
	{ 0x4828, 0x28EF5 },
	{ 0x4829, 0x28EF6 },
	{ 0x482A, 0x28FBB },
	{ 0x482B, 0x28FC2 },
	{ 0x482C, 0x290A7 },
	{ 0x482D, 0x4A0F },
	{ 0x482E, 0x4A11 },
	{ 0x482F, 0x290A8 },
	{ 0x4830, 0x290A3 },
	{ 0x4831, 0x4A10 },
	{ 0x4832, 0x290AA },
	{ 0x4833, 0x4A15 },
	{ 0x4834, 0x4A13 },
	{ 0x4835, 0x9757 },
	{ 0x4836, 0x291DC },
	{ 0x4837, 0x4A47 },
	{ 0x4838, 0x4A46 },
	{ 0x4839, 0x2920F },
	{ 0x483A, 0x4A59 },
	{ 0x483B, 0x4A5B },
	{ 0x483C, 0x29279 },
	{ 0x483D, 0x4A5E },
	{ 0x483E, 0x2927F },
	{ 0x483F, 0x29285 },
	{ 0x4840, 0x4A5A },
	{ 0x4841, 0x4A91 },
	{ 0x4842, 0x4A92 },
	{ 0x4843, 0x4A90 },
	{ 0x4844, 0x4A93 },
	{ 0x4845, 0x2941B },
	{ 0x4846, 0x97F7 },
	{ 0x4847, 0x4ABE },
	{ 0x4848, 0x29477 },
	{ 0x4849, 0x29476 },
	{ 0x484A, 0x29498 },
	{ 0x484B, 0x4ABC },
	{ 0x484C, 0x4ABB },
	{ 0x484D, 0x4AB7 },
	{ 0x484E, 0x4AB9 },
	{ 0x484F, 0x2947A },
	{ 0x4850, 0x4B01 },
	{ 0x4851, 0x4AFE },
	{ 0x4852, 0x295BC },
	{ 0x4853, 0x295BA },
	{ 0x4854, 0x4B02 },
	{ 0x4855, 0x295B6 },
	{ 0x4856, 0x4AFF },
	{ 0x4857, 0x98B0 },
	{ 0x4858, 0x295B4 },
	{ 0x4859, 0x4B00 },
	{ 0x485A, 0x296CF },
	{ 0x485B, 0x4B37 },
	{ 0x485C, 0x4B3A },
	{ 0x485D, 0x4B6F },
	{ 0x485E, 0x4B77 },
	{ 0x485F, 0x4B79 },
	{ 0x4860, 0x99C6 },
	{ 0x4861, 0x2987B },
	{ 0x4862, 0x4BC8 },
	{ 0x4863, 0x29A1C },
	{ 0x4864, 0x29A21 },
	{ 0x4865, 0x29A1D },
	{ 0x4866, 0x29AC0 },
	{ 0x4867, 0x4BF2 },
	{ 0x4868, 0x29AFF },
	{ 0x4869, 0x4BF1 },
	{ 0x486A, 0x4BF0 },
	{ 0x486B, 0x9B62 },
	{ 0x486C, 0x29D56 },
	{ 0x486D, 0x4C34 },
	{ 0x486E, 0x29FA1 },
	{ 0x486F, 0x29FA2 },
	{ 0x4870, 0x29FA6 },
	{ 0x4871, 0x2A256 },
	{ 0x4872, 0x2A257 },
	{ 0x4873, 0x4D2C },
	{ 0x4874, 0x4D2D },
	{ 0x4875, 0x2A301 },
	{ 0x4876, 0x2A3ED },
	{ 0x4877, 0x2FA1C },
	{ 0x4878, 0x2A5F2 },
	{ 0x4879, 0x50FA },
	{ 0x487A, 0x203B8 },
	{ 0x487B, 0x3491 },
	{ 0x487C, 0x203C0 },
	{ 0x487D, 0x3494 },
	{ 0x487E, 0x203B7 },
	{ 0x4921, 0x203E1 },
	{ 0x4922, 0x34C4 },
	{ 0x4923, 0x350A },
	{ 0x4924, 0x207E8 },
	{ 0x4925, 0x5285 },
	{ 0x4926, 0x208B2 },
	{ 0x4927, 0x3552 },
	{ 0x4928, 0x20AAE },
	{ 0x4929, 0x3559 },
	{ 0x492A, 0x366F },
	{ 0x492B, 0x20F7E },
	{ 0x492C, 0x35F2 },
	{ 0x492D, 0x35F4 },
	{ 0x492E, 0x5643 },
	{ 0x492F, 0x20F76 },
	{ 0x4930, 0x35F1 },
	{ 0x4931, 0x563C },
	{ 0x4932, 0x20F96 },
	{ 0x4933, 0x366A },
	{ 0x4934, 0x21420 },
	{ 0x4935, 0x21421 },
	{ 0x4936, 0x21423 },
	{ 0x4937, 0x21429 },
	{ 0x4938, 0x21677 },
	{ 0x4939, 0x21851 },
	{ 0x493A, 0x3724 },
	{ 0x493B, 0x21856 },
	{ 0x493C, 0x3723 },
	{ 0x493D, 0x21888 },
	{ 0x493E, 0x21859 },
	{ 0x493F, 0x21855 },
	{ 0x4940, 0x3727 },
	{ 0x4941, 0x21997 },
	{ 0x4942, 0x21998 },
	{ 0x4943, 0x376D },
	{ 0x4944, 0x5BED },
	{ 0x4945, 0x376E },
	{ 0x4946, 0x376F },
	{ 0x4947, 0x21AA1 },
	{ 0x4948, 0x21AA3 },
	{ 0x4949, 0x5C35 },
	{ 0x494A, 0x379F },
	{ 0x494B, 0x380A },
	{ 0x494C, 0x3806 },
	{ 0x494D, 0x380E },
	{ 0x494E, 0x21F0A },
	{ 0x494F, 0x380D },
	{ 0x4950, 0x3805 },
	{ 0x4951, 0x21F3D },
	{ 0x4952, 0x21F0C },
	{ 0x4953, 0x380B },
	{ 0x4954, 0x3810 },
	{ 0x4955, 0x382E },
	{ 0x4956, 0x2213D },
	{ 0x4957, 0x22139 },
	{ 0x4958, 0x222B0 },
	{ 0x4959, 0x222B2 },
	{ 0x495A, 0x222AE },
	{ 0x495B, 0x3896 },
	{ 0x495C, 0x3897 },
	{ 0x495D, 0x38C4 },
	{ 0x495E, 0x5F47 },
	{ 0x495F, 0x38C5 },
	{ 0x4960, 0x22420 },
	{ 0x4961, 0x38D2 },
	{ 0x4962, 0x2256E },
	{ 0x4963, 0x2256D },
	{ 0x4964, 0x2256A },
	{ 0x4965, 0x3981 },
	{ 0x4966, 0x22832 },
	{ 0x4967, 0x398E },
	{ 0x4968, 0x3990 },
	{ 0x4969, 0x398F },
	{ 0x496A, 0x22839 },
	{ 0x496B, 0x3991 },
	{ 0x496C, 0x3995 },
	{ 0x496D, 0x3993 },
	{ 0x496E, 0x227A3 },
	{ 0x496F, 0x616D },
	{ 0x4970, 0x2287F },
	{ 0x4971, 0x22835 },
	{ 0x4972, 0x2283D },
	{ 0x4973, 0x229F4 },
	{ 0x4974, 0x229F5 },
	{ 0x4975, 0x3A3B },
	{ 0x4976, 0x3A48 },
	{ 0x4977, 0x22D48 },
	{ 0x4978, 0x22D28 },
	{ 0x4979, 0x3A46 },
	{ 0x497A, 0x3A47 },
	{ 0x497B, 0x22D27 },
	{ 0x497C, 0x22D32 },
	{ 0x497D, 0x22D2C },
	{ 0x497E, 0x3A4C },
	{ 0x4A21, 0x22D2E },
	{ 0x4A22, 0x3A4A },
	{ 0x4A23, 0x3A50 },
	{ 0x4A24, 0x3A43 },
	{ 0x4A25, 0x22D23 },
	{ 0x4A26, 0x22D31 },
	{ 0x4A27, 0x2F8C5 },
	{ 0x4A28, 0x3A49 },
	{ 0x4A29, 0x3AA6 },
	{ 0x4A2A, 0x3AA5 },
	{ 0x4A2B, 0x3AA4 },
	{ 0x4A2C, 0x22FC9 },
	{ 0x4A2D, 0x23089 },
	{ 0x4A2E, 0x3AB9 },
	{ 0x4A2F, 0x230BB },
	{ 0x4A30, 0x3ACE },
	{ 0x4A31, 0x3ACF },
	{ 0x4A32, 0x3B13 },
	{ 0x4A33, 0x23397 },
	{ 0x4A34, 0x23393 },
	{ 0x4A35, 0x23628 },
	{ 0x4A36, 0x3BC6 },
	{ 0x4A37, 0x3BC5 },
	{ 0x4A38, 0x3BCA },
	{ 0x4A39, 0x3BD9 },
	{ 0x4A3A, 0x3BC1 },
	{ 0x4A3B, 0x23618 },
	{ 0x4A3C, 0x2363B },
	{ 0x4A3D, 0x69F5 },
	{ 0x4A3E, 0x23627 },
	{ 0x4A3F, 0x23624 },
	{ 0x4A40, 0x2361B },
	{ 0x4A41, 0x23631 },
	{ 0x4A42, 0x3BCB },
	{ 0x4A43, 0x23626 },
	{ 0x4A44, 0x236A3 },
	{ 0x4A45, 0x2363F },
	{ 0x4A46, 0x23622 },
	{ 0x4A47, 0x23619 },
	{ 0x4A48, 0x6A03 },
	{ 0x4A49, 0x23641 },
	{ 0x4A4A, 0x2362B },
	{ 0x4A4B, 0x6A65 },
	{ 0x4A4C, 0x3C42 },
	{ 0x4A4D, 0x2390C },
	{ 0x4A4E, 0x6B75 },
	{ 0x4A4F, 0x3C74 },
	{ 0x4A50, 0x3C73 },
	{ 0x4A51, 0x23A4E },
	{ 0x4A52, 0x23AB9 },
	{ 0x4A53, 0x23AFA },
	{ 0x4A54, 0x23BE9 },
	{ 0x4A55, 0x23BE8 },
	{ 0x4A56, 0x23BE4 },
	{ 0x4A57, 0x6F8A },
	{ 0x4A58, 0x6F56 },
	{ 0x4A59, 0x3D52 },
	{ 0x4A5A, 0x23F5F },
	{ 0x4A5B, 0x23F5D },
	{ 0x4A5C, 0x23F52 },
	{ 0x4A5D, 0x3D50 },
	{ 0x4A5E, 0x23F74 },
	{ 0x4A5F, 0x3D4B },
	{ 0x4A60, 0x23F46 },
	{ 0x4A61, 0x3D4C },
	{ 0x4A62, 0x3D6D },
	{ 0x4A63, 0x23FAA },
	{ 0x4A64, 0x6F98 },
	{ 0x4A65, 0x23F4A },
	{ 0x4A66, 0x23F59 },
	{ 0x4A67, 0x23F4B },
	{ 0x4A68, 0x3D4F },
	{ 0x4A69, 0x6F68 },
	{ 0x4A6A, 0x3DF0 },
	{ 0x4A6B, 0x24350 },
	{ 0x4A6C, 0x7234 },
	{ 0x4A6D, 0x7245 },
	{ 0x4A6E, 0x3E4D },
	{ 0x4A6F, 0x3E4C },
	{ 0x4A70, 0x246D0 },
	{ 0x4A71, 0x3E4F },
	{ 0x4A72, 0x3E4E },
	{ 0x4A73, 0x3E50 },
	{ 0x4A74, 0x246CC },
	{ 0x4A75, 0x735C },
	{ 0x4A76, 0x3E96 },
	{ 0x4A77, 0x7356 },
	{ 0x4A78, 0x24864 },
	{ 0x4A79, 0x24865 },
	{ 0x4A7A, 0x3E97 },
	{ 0x4A7B, 0x3E95 },
	{ 0x4A7C, 0x3E98 },
	{ 0x4A7D, 0x2485C },
	{ 0x4A7E, 0x24A15 },
	{ 0x4B21, 0x3EEC },
	{ 0x4B22, 0x3EEB },
	{ 0x4B23, 0x3F13 },
	{ 0x4B24, 0x3F14 },
	{ 0x4B25, 0x3F38 },
	{ 0x4B26, 0x3F3A },
	{ 0x4B27, 0x3F39 },
	{ 0x4B28, 0x24B79 },
	{ 0x4B29, 0x3F68 },
	{ 0x4B2A, 0x3F67 },
	{ 0x4B2B, 0x24CC5 },
	{ 0x4B2C, 0x24CB8 },
	{ 0x4B2D, 0x24E2C },
	{ 0x4B2E, 0x3FBE },
	{ 0x4B2F, 0x3FBC },
	{ 0x4B30, 0x24E37 },
	{ 0x4B31, 0x24E35 },
	{ 0x4B32, 0x24E31 },
	{ 0x4B33, 0x3FBB },
	{ 0x4B34, 0x24E2F },
	{ 0x4B35, 0x3FBA },
	{ 0x4B36, 0x24E2B },
	{ 0x4B37, 0x3FB9 },
	{ 0x4B38, 0x3FB7 },
	{ 0x4B39, 0x24E2D },
	{ 0x4B3A, 0x24E2A },
	{ 0x4B3B, 0x3FC1 },
	{ 0x4B3C, 0x24F95 },
	{ 0x4B3D, 0x3FF7 },
	{ 0x4B3E, 0x2523E },
	{ 0x4B3F, 0x4060 },
	{ 0x4B40, 0x25247 },
	{ 0x4B41, 0x25245 },
	{ 0x4B42, 0x4059 },
	{ 0x4B43, 0x405C },
	{ 0x4B44, 0x405A },
	{ 0x4B45, 0x4058 },
	{ 0x4B46, 0x25252 },
	{ 0x4B47, 0x405B },
	{ 0x4B48, 0x25270 },
	{ 0x4B49, 0x25250 },
	{ 0x4B4A, 0x25258 },
	{ 0x4B4B, 0x25251 },
	{ 0x4B4C, 0x2523D },
	{ 0x4B4D, 0x405D },
	{ 0x4B4E, 0x25241 },
	{ 0x4B4F, 0x2520C },
	{ 0x4B50, 0x2523C },
	{ 0x4B51, 0x25386 },
	{ 0x4B52, 0x25383 },
	{ 0x4B53, 0x25389 },
	{ 0x4B54, 0x253F3 },
	{ 0x4B55, 0x40D4 },
	{ 0x4B56, 0x40D3 },
	{ 0x4B57, 0x78BF },
	{ 0x4B58, 0x40D2 },
	{ 0x4B59, 0x78BD },
	{ 0x4B5A, 0x2552D },
	{ 0x4B5B, 0x40D7 },
	{ 0x4B5C, 0x40D1 },
	{ 0x4B5D, 0x78E4 },
	{ 0x4B5E, 0x40D5 },
	{ 0x4B5F, 0x256C5 },
	{ 0x4B60, 0x2F955 },
	{ 0x4B61, 0x416D },
	{ 0x4B62, 0x416F },
	{ 0x4B63, 0x7A34 },
	{ 0x4B64, 0x4175 },
	{ 0x4B65, 0x416C },
	{ 0x4B66, 0x4174 },
	{ 0x4B67, 0x25843 },
	{ 0x4B68, 0x4173 },
	{ 0x4B69, 0x25837 },
	{ 0x4B6A, 0x25845 },
	{ 0x4B6B, 0x7A36 },
	{ 0x4B6C, 0x41AC },
	{ 0x4B6D, 0x259E5 },
	{ 0x4B6E, 0x25AA6 },
	{ 0x4B6F, 0x25BDB },
	{ 0x4B70, 0x4210 },
	{ 0x4B71, 0x25BDA },
	{ 0x4B72, 0x25BE6 },
	{ 0x4B73, 0x7BBA },
	{ 0x4B74, 0x7BBC },
	{ 0x4B75, 0x420F },
	{ 0x4B76, 0x7BC8 },
	{ 0x4B77, 0x4223 },
	{ 0x4B78, 0x7BC3 },
	{ 0x4B79, 0x421D },
	{ 0x4B7A, 0x7BB6 },
	{ 0x4B7B, 0x420E },
	{ 0x4B7C, 0x25BF8 },
	{ 0x4B7D, 0x25BE9 },
	{ 0x4B7E, 0x4215 },
	{ 0x4C21, 0x7BC2 },
	{ 0x4C22, 0x4213 },
	{ 0x4C23, 0x25BE8 },
	{ 0x4C24, 0x25BF6 },
	{ 0x4C25, 0x421B },
	{ 0x4C26, 0x7BC5 },
	{ 0x4C27, 0x4222 },
	{ 0x4C28, 0x4226 },
	{ 0x4C29, 0x25BE7 },
	{ 0x4C2A, 0x7BBD },
	{ 0x4C2B, 0x7BB0 },
	{ 0x4C2C, 0x4221 },
	{ 0x4C2D, 0x421C },
	{ 0x4C2E, 0x4217 },
	{ 0x4C2F, 0x25BD5 },
	{ 0x4C30, 0x421A },
	{ 0x4C31, 0x7BBB },
	{ 0x4C32, 0x25ED3 },
	{ 0x4C33, 0x25EC7 },
	{ 0x4C34, 0x25ED1 },
	{ 0x4C35, 0x4299 },
	{ 0x4C36, 0x25EC3 },
	{ 0x4C37, 0x4297 },
	{ 0x4C38, 0x26080 },
	{ 0x4C39, 0x26098 },
	{ 0x4C3A, 0x42FD },
	{ 0x4C3B, 0x26084 },
	{ 0x4C3C, 0x42F6 },
	{ 0x4C3D, 0x42FE },
	{ 0x4C3E, 0x42F5 },
	{ 0x4C3F, 0x42FF },
	{ 0x4C40, 0x42F7 },
	{ 0x4C41, 0x26097 },
	{ 0x4C42, 0x26083 },
	{ 0x4C43, 0x26081 },
	{ 0x4C44, 0x4301 },
	{ 0x4C45, 0x7E04 },
	{ 0x4C46, 0x2608C },
	{ 0x4C47, 0x26242 },
	{ 0x4C48, 0x263AB },
	{ 0x4C49, 0x4377 },
	{ 0x4C4A, 0x263A3 },
	{ 0x4C4B, 0x263A6 },
	{ 0x4C4C, 0x2645C },
	{ 0x4C4D, 0x26469 },
	{ 0x4C4E, 0x26467 },
	{ 0x4C4F, 0x43AB },
	{ 0x4C50, 0x2658B },
	{ 0x4C51, 0x265A8 },
	{ 0x4C52, 0x43C0 },
	{ 0x4C53, 0x267D8 },
	{ 0x4C54, 0x4431 },
	{ 0x4C55, 0x442E },
	{ 0x4C56, 0x2F989 },
	{ 0x4C57, 0x267DC },
	{ 0x4C58, 0x442C },
	{ 0x4C59, 0x267E0 },
	{ 0x4C5A, 0x267E5 },
	{ 0x4C5B, 0x4432 },
	{ 0x4C5C, 0x442F },
	{ 0x4C5D, 0x442B },
	{ 0x4C5E, 0x442D },
	{ 0x4C5F, 0x4433 },
	{ 0x4C60, 0x26918 },
	{ 0x4C61, 0x26919 },
	{ 0x4C62, 0x81F1 },
	{ 0x4C63, 0x4457 },
	{ 0x4C64, 0x445C },
	{ 0x4C65, 0x447B },
	{ 0x4C66, 0x26A5F },
	{ 0x4C67, 0x26A5E },
	{ 0x4C68, 0x447A },
	{ 0x4C69, 0x26E02 },
	{ 0x4C6A, 0x8522 },
	{ 0x4C6B, 0x4513 },
	{ 0x4C6C, 0x451E },
	{ 0x4C6D, 0x4517 },
	{ 0x4C6E, 0x4520 },
	{ 0x4C6F, 0x452A },
	{ 0x4C70, 0x4511 },
	{ 0x4C71, 0x4515 },
	{ 0x4C72, 0x450F },
	{ 0x4C73, 0x4518 },
	{ 0x4C74, 0x8538 },
	{ 0x4C75, 0x26E12 },
	{ 0x4C76, 0x26E36 },
	{ 0x4C77, 0x452C },
	{ 0x4C78, 0x8532 },
	{ 0x4C79, 0x2F9A8 },
	{ 0x4C7A, 0x8510 },
	{ 0x4C7B, 0x26E23 },
	{ 0x4C7C, 0x26E03 },
	{ 0x4C7D, 0x451C },
	{ 0x4C7E, 0x26E00 },
	{ 0x4D21, 0x4529 },
	{ 0x4D22, 0x26E46 },
	{ 0x4D23, 0x26E61 },
	{ 0x4D24, 0x4512 },
	{ 0x4D25, 0x854F },
	{ 0x4D26, 0x4597 },
	{ 0x4D27, 0x27384 },
	{ 0x4D28, 0x8772 },
	{ 0x4D29, 0x2736B },
	{ 0x4D2A, 0x27362 },
	{ 0x4D2B, 0x27356 },
	{ 0x4D2C, 0x2736A },
	{ 0x4D2D, 0x27352 },
	{ 0x4D2E, 0x27355 },
	{ 0x4D2F, 0x45D4 },
	{ 0x4D30, 0x45D0 },
	{ 0x4D31, 0x877C },
	{ 0x4D32, 0x27361 },
	{ 0x4D33, 0x2F9BB },
	{ 0x4D34, 0x27358 },
	{ 0x4D35, 0x27377 },
	{ 0x4D36, 0x45D3 },
	{ 0x4D37, 0x4614 },
	{ 0x4D38, 0x276D7 },
	{ 0x4D39, 0x4646 },
	{ 0x4D3A, 0x4645 },
	{ 0x4D3B, 0x276DE },
	{ 0x4D3C, 0x4643 },
	{ 0x4D3D, 0x276DF },
	{ 0x4D3E, 0x890D },
	{ 0x4D3F, 0x4644 },
	{ 0x4D40, 0x4648 },
	{ 0x4D41, 0x276D1 },
	{ 0x4D42, 0x4647 },
	{ 0x4D43, 0x276E2 },
	{ 0x4D44, 0x276E1 },
	{ 0x4D45, 0x276DD },
	{ 0x4D46, 0x8908 },
	{ 0x4D47, 0x4649 },
	{ 0x4D48, 0x4685 },
	{ 0x4D49, 0x2784B },
	{ 0x4D4A, 0x4684 },
	{ 0x4D4B, 0x2784E },
	{ 0x4D4C, 0x469D },
	{ 0x4D4D, 0x278FC },
	{ 0x4D4E, 0x469E },
	{ 0x4D4F, 0x46A0 },
	{ 0x4D50, 0x278FA },
	{ 0x4D51, 0x469C },
	{ 0x4D52, 0x278FB },
	{ 0x4D53, 0x469F },
	{ 0x4D54, 0x278FE },
	{ 0x4D55, 0x46F7 },
	{ 0x4D56, 0x46EA },
	{ 0x4D57, 0x27A31 },
	{ 0x4D58, 0x46EF },
	{ 0x4D59, 0x46E9 },
	{ 0x4D5A, 0x46F3 },
	{ 0x4D5B, 0x46F0 },
	{ 0x4D5C, 0x46EB },
	{ 0x4D5D, 0x27A38 },
	{ 0x4D5E, 0x46EC },
	{ 0x4D5F, 0x46F2 },
	{ 0x4D60, 0x46F5 },
	{ 0x4D61, 0x46EE },
	{ 0x4D62, 0x27A3A },
	{ 0x4D63, 0x27BBB },
	{ 0x4D64, 0x473A },
	{ 0x4D65, 0x474B },
	{ 0x4D66, 0x27C59 },
	{ 0x4D67, 0x474A },
	{ 0x4D68, 0x474C },
	{ 0x4D69, 0x27CDB },
	{ 0x4D6A, 0x27CDF },
	{ 0x4D6B, 0x27CE2 },
	{ 0x4D6C, 0x4779 },
	{ 0x4D6D, 0x477B },
	{ 0x4D6E, 0x4778 },
	{ 0x4D6F, 0x27D9E },
	{ 0x4D70, 0x27DA1 },
	{ 0x4D71, 0x47B5 },
	{ 0x4D72, 0x27F10 },
	{ 0x4D73, 0x47B4 },
	{ 0x4D74, 0x47B7 },
	{ 0x4D75, 0x8D9E },
	{ 0x4D76, 0x4809 },
	{ 0x4D77, 0x47FE },
	{ 0x4D78, 0x4808 },
	{ 0x4D79, 0x4807 },
	{ 0x4D7A, 0x28076 },
	{ 0x4D7B, 0x2807F },
	{ 0x4D7C, 0x2807D },
	{ 0x4D7D, 0x4806 },
	{ 0x4D7E, 0x4804 },
	{ 0x4E21, 0x4805 },
	{ 0x4E22, 0x47FF },
	{ 0x4E23, 0x480B },
	{ 0x4E24, 0x28082 },
	{ 0x4E25, 0x28257 },
	{ 0x4E26, 0x483B },
	{ 0x4E27, 0x485D },
	{ 0x4E28, 0x485C },
	{ 0x4E29, 0x485F },
	{ 0x4E2A, 0x485E },
	{ 0x4E2B, 0x8F28 },
	{ 0x4E2C, 0x2832E },
	{ 0x4E2D, 0x8F21 },
	{ 0x4E2E, 0x4883 },
	{ 0x4E2F, 0x2858B },
	{ 0x4E30, 0x2858D },
	{ 0x4E31, 0x48A7 },
	{ 0x4E32, 0x9066 },
	{ 0x4E33, 0x906C },
	{ 0x4E34, 0x28590 },
	{ 0x4E35, 0x48A8 },
	{ 0x4E36, 0x286EC },
	{ 0x4E37, 0x2876F },
	{ 0x4E38, 0x2876B },
	{ 0x4E39, 0x28771 },
	{ 0x4E3A, 0x28778 },
	{ 0x4E3B, 0x90F6 },
	{ 0x4E3C, 0x48E0 },
	{ 0x4E3D, 0x48DF },
	{ 0x4E3E, 0x48FE },
	{ 0x4E3F, 0x48FC },
	{ 0x4E40, 0x48FF },
	{ 0x4E41, 0x48FD },
	{ 0x4E42, 0x289AD },
	{ 0x4E43, 0x492C },
	{ 0x4E44, 0x92EC },
	{ 0x4E45, 0x92BA },
	{ 0x4E46, 0x92E3 },
	{ 0x4E47, 0x92BD },
	{ 0x4E48, 0x499D },
	{ 0x4E49, 0x28D2F },
	{ 0x4E4A, 0x95B4 },
	{ 0x4E4B, 0x28F78 },
	{ 0x4E4C, 0x4A40 },
	{ 0x4E4D, 0x291F8 },
	{ 0x4E4E, 0x29219 },
	{ 0x4E4F, 0x4A5F },
	{ 0x4E50, 0x2929B },
	{ 0x4E51, 0x29294 },
	{ 0x4E52, 0x29297 },
	{ 0x4E53, 0x29299 },
	{ 0x4E54, 0x293A6 },
	{ 0x4E55, 0x293A4 },
	{ 0x4E56, 0x293A7 },
	{ 0x4E57, 0x97D1 },
	{ 0x4E58, 0x29495 },
	{ 0x4E59, 0x4AC0 },
	{ 0x4E5A, 0x9823 },
	{ 0x4E5B, 0x29490 },
	{ 0x4E5C, 0x4AC1 },
	{ 0x4E5D, 0x4AC6 },
	{ 0x4E5E, 0x2949B },
	{ 0x4E5F, 0x295C4 },
	{ 0x4E60, 0x4B04 },
	{ 0x4E61, 0x4B05 },
	{ 0x4E62, 0x295C6 },
	{ 0x4E63, 0x990B },
	{ 0x4E64, 0x4B3E },
	{ 0x4E65, 0x4B3D },
	{ 0x4E66, 0x4B40 },
	{ 0x4E67, 0x4B3F },
	{ 0x4E68, 0x296E3 },
	{ 0x4E69, 0x4B42 },
	{ 0x4E6A, 0x296DF },
	{ 0x4E6B, 0x296DD },
	{ 0x4E6C, 0x296E7 },
	{ 0x4E6D, 0x4B84 },
	{ 0x4E6E, 0x4B82 },
	{ 0x4E6F, 0x4B7F },
	{ 0x4E70, 0x4B85 },
	{ 0x4E71, 0x29A2D },
	{ 0x4E72, 0x29A2C },
	{ 0x4E73, 0x4BCC },
	{ 0x4E74, 0x9AB2 },
	{ 0x4E75, 0x4BCB },
	{ 0x4E76, 0x4BCD },
	{ 0x4E77, 0x29A34 },
	{ 0x4E78, 0x29A38 },
	{ 0x4E79, 0x9ADB },
	{ 0x4E7A, 0x29B1D },
	{ 0x4E7B, 0x4BF5 },
	{ 0x4E7C, 0x29B1A },
	{ 0x4E7D, 0x29B1B },
	{ 0x4E7E, 0x29B14 },
	{ 0x4F21, 0x9AF0 },
	{ 0x4F22, 0x29B17 },
	{ 0x4F23, 0x29C21 },
	{ 0x4F24, 0x4C20 },
	{ 0x4F25, 0x4C21 },
	{ 0x4F26, 0x29CAA },
	{ 0x4F27, 0x29CA1 },
	{ 0x4F28, 0x4C37 },
	{ 0x4F29, 0x4C3E },
	{ 0x4F2A, 0x9B73 },
	{ 0x4F2B, 0x4C3D },
	{ 0x4F2C, 0x9B6E },
	{ 0x4F2D, 0x29D63 },
	{ 0x4F2E, 0x29D79 },
	{ 0x4F2F, 0x29D60 },
	{ 0x4F30, 0x9B65 },
	{ 0x4F31, 0x29D62 },
	{ 0x4F32, 0x4C3C },
	{ 0x4F33, 0x29D61 },
	{ 0x4F34, 0x4C38 },
	{ 0x4F35, 0x9B6A },
	{ 0x4F36, 0x29D70 },
	{ 0x4F37, 0x9B6D },
	{ 0x4F38, 0x29D6A },
	{ 0x4F39, 0x4C3B },
	{ 0x4F3A, 0x29FC8 },
	{ 0x4F3B, 0x4CB0 },
	{ 0x4F3C, 0x29FC5 },
	{ 0x4F3D, 0x29FBE },
	{ 0x4F3E, 0x29FC2 },
	{ 0x4F3F, 0x4CAD },
	{ 0x4F40, 0x4CB2 },
	{ 0x4F41, 0x4CB8 },
	{ 0x4F42, 0x9D0B },
	{ 0x4F43, 0x29FC7 },
	{ 0x4F44, 0x4CAF },
	{ 0x4F45, 0x29FB0 },
	{ 0x4F46, 0x29FCA },
	{ 0x4F47, 0x4D1A },
	{ 0x4F48, 0x9E76 },
	{ 0x4F49, 0x4D20 },
	{ 0x4F4A, 0x4D21 },
	{ 0x4F4B, 0x4D30 },
	{ 0x4F4C, 0x9EA8 },
	{ 0x4F4D, 0x4D2F },
	{ 0x4F4E, 0x2A30D },
	{ 0x4F4F, 0x2A307 },
	{ 0x4F50, 0x2A396 },
	{ 0x4F51, 0x2A3EF },
	{ 0x4F52, 0x4D5F },
	{ 0x4F53, 0x4D60 },
	{ 0x4F54, 0x2A41E },
	{ 0x4F55, 0x2A41D },
	{ 0x4F56, 0x9F11 },
	{ 0x4F57, 0x2A590 },
	{ 0x4F58, 0x203EB },
	{ 0x4F59, 0x348A },
	{ 0x4F5A, 0x5119 },
	{ 0x4F5B, 0x349C },
	{ 0x4F5C, 0x203EE },
	{ 0x4F5D, 0x349A },
	{ 0x4F5E, 0x203EF },
	{ 0x4F5F, 0x203EC },
	{ 0x4F60, 0x207FA },
	{ 0x4F61, 0x350C },
	{ 0x4F62, 0x350B },
	{ 0x4F63, 0x350D },
	{ 0x4F64, 0x5292 },
	{ 0x4F65, 0x20904 },
	{ 0x4F66, 0x20FD3 },
	{ 0x4F67, 0x35FE },
	{ 0x4F68, 0x20FD1 },
	{ 0x4F69, 0x20FFA },
	{ 0x4F6A, 0x35FF },
	{ 0x4F6B, 0x35FB },
	{ 0x4F6C, 0x35FC },
	{ 0x4F6D, 0x3609 },
	{ 0x4F6E, 0x20FC8 },
	{ 0x4F6F, 0x3600 },
	{ 0x4F70, 0x20FD5 },
	{ 0x4F71, 0x5675 },
	{ 0x4F72, 0x20FCD },
	{ 0x4F73, 0x20FD2 },
	{ 0x4F74, 0x20FFB },
	{ 0x4F75, 0x2122A },
	{ 0x4F76, 0x21488 },
	{ 0x4F77, 0x21461 },
	{ 0x4F78, 0x3671 },
	{ 0x4F79, 0x21463 },
	{ 0x4F7A, 0x21462 },
	{ 0x4F7B, 0x596F },
	{ 0x4F7C, 0x20057 },
	{ 0x4F7D, 0x218C8 },
	{ 0x4F7E, 0x21898 },
	{ 0x5021, 0x372B },
	{ 0x5022, 0x21AC1 },
	{ 0x5023, 0x21F3F },
	{ 0x5024, 0x21F41 },
	{ 0x5025, 0x3814 },
	{ 0x5026, 0x3811 },
	{ 0x5027, 0x3812 },
	{ 0x5028, 0x22152 },
	{ 0x5029, 0x3863 },
	{ 0x502A, 0x2215E },
	{ 0x502B, 0x386E },
	{ 0x502C, 0x389A },
	{ 0x502D, 0x222C7 },
	{ 0x502E, 0x389B },
	{ 0x502F, 0x22370 },
	{ 0x5030, 0x22427 },
	{ 0x5031, 0x38C8 },
	{ 0x5032, 0x22471 },
	{ 0x5033, 0x224B0 },
	{ 0x5034, 0x38F6 },
	{ 0x5035, 0x22842 },
	{ 0x5036, 0x22843 },
	{ 0x5037, 0x61A5 },
	{ 0x5038, 0x398C },
	{ 0x5039, 0x3997 },
	{ 0x503A, 0x39A2 },
	{ 0x503B, 0x61A0 },
	{ 0x503C, 0x22857 },
	{ 0x503D, 0x2289D },
	{ 0x503E, 0x22D89 },
	{ 0x503F, 0x22D8D },
	{ 0x5040, 0x22D8B },
	{ 0x5041, 0x22D80 },
	{ 0x5042, 0x22D92 },
	{ 0x5043, 0x22D8A },
	{ 0x5044, 0x22DC8 },
	{ 0x5045, 0x3A54 },
	{ 0x5046, 0x22D8F },
	{ 0x5047, 0x22D93 },
	{ 0x5048, 0x22D91 },
	{ 0x5049, 0x3AA8 },
	{ 0x504A, 0x22FF2 },
	{ 0x504B, 0x22FDE },
	{ 0x504C, 0x3AA9 },
	{ 0x504D, 0x230C8 },
	{ 0x504E, 0x65B4 },
	{ 0x504F, 0x65D8 },
	{ 0x5050, 0x66C2 },
	{ 0x5051, 0x3B18 },
	{ 0x5052, 0x3B17 },
	{ 0x5053, 0x3B1D },
	{ 0x5054, 0x232A7 },
	{ 0x5055, 0x232A1 },
	{ 0x5056, 0x3B31 },
	{ 0x5057, 0x2368C },
	{ 0x5058, 0x2367F },
	{ 0x5059, 0x3BD8 },
	{ 0x505A, 0x3BD5 },
	{ 0x505B, 0x2367B },
	{ 0x505C, 0x23695 },
	{ 0x505D, 0x23699 },
	{ 0x505E, 0x3BE1 },
	{ 0x505F, 0x2368E },
	{ 0x5060, 0x3BD4 },
	{ 0x5061, 0x236DA },
	{ 0x5062, 0x2368A },
	{ 0x5063, 0x2369C },
	{ 0x5064, 0x3BE3 },
	{ 0x5065, 0x2367E },
	{ 0x5066, 0x3C44 },
	{ 0x5067, 0x3C45 },
	{ 0x5068, 0x2391A },
	{ 0x5069, 0x23A55 },
	{ 0x506A, 0x3C76 },
	{ 0x506B, 0x3C75 },
	{ 0x506C, 0x23A60 },
	{ 0x506D, 0x6BA8 },
	{ 0x506E, 0x3C88 },
	{ 0x506F, 0x3CAA },
	{ 0x5070, 0x23BFB },
	{ 0x5071, 0x3CAB },
	{ 0x5072, 0x3CAC },
	{ 0x5073, 0x23BFD },
	{ 0x5074, 0x3D57 },
	{ 0x5075, 0x6F83 },
	{ 0x5076, 0x3D60 },
	{ 0x5077, 0x3D5D },
	{ 0x5078, 0x3D6B },
	{ 0x5079, 0x23FD0 },
	{ 0x507A, 0x3D63 },
	{ 0x507B, 0x3D67 },
	{ 0x507C, 0x23FC5 },
	{ 0x507D, 0x3D5E },
	{ 0x507E, 0x23FD2 },
	{ 0x5121, 0x24011 },
	{ 0x5122, 0x6FC5 },
	{ 0x5123, 0x71CD },
	{ 0x5124, 0x3DF9 },
	{ 0x5125, 0x3DF3 },
	{ 0x5126, 0x243AD },
	{ 0x5127, 0x243A4 },
	{ 0x5128, 0x243A9 },
	{ 0x5129, 0x243B0 },
	{ 0x512A, 0x2439D },
	{ 0x512B, 0x3DF6 },
	{ 0x512C, 0x24598 },
	{ 0x512D, 0x729C },
	{ 0x512E, 0x3E51 },
	{ 0x512F, 0x3E53 },
	{ 0x5130, 0x3E52 },
	{ 0x5131, 0x24892 },
	{ 0x5132, 0x3E9B },
	{ 0x5133, 0x2488A },
	{ 0x5134, 0x3E9C },
	{ 0x5135, 0x2488D },
	{ 0x5136, 0x24896 },
	{ 0x5137, 0x3EF7 },
	{ 0x5138, 0x7499 },
	{ 0x5139, 0x748F },
	{ 0x513A, 0x7491 },
	{ 0x513B, 0x24A45 },
	{ 0x513C, 0x24A4B },
	{ 0x513D, 0x24B0F },
	{ 0x513E, 0x24B16 },
	{ 0x513F, 0x3F3B },
	{ 0x5140, 0x24B8A },
	{ 0x5141, 0x3F3E },
	{ 0x5142, 0x3F3D },
	{ 0x5143, 0x24CC9 },
	{ 0x5144, 0x3F69 },
	{ 0x5145, 0x24CC8 },
	{ 0x5146, 0x24CCA },
	{ 0x5147, 0x24E64 },
	{ 0x5148, 0x3FC3 },
	{ 0x5149, 0x3FC4 },
	{ 0x514A, 0x3FC7 },
	{ 0x514B, 0x24E5D },
	{ 0x514C, 0x24E63 },
	{ 0x514D, 0x7639 },
	{ 0x514E, 0x3FC6 },
	{ 0x514F, 0x762E },
	{ 0x5150, 0x3FC8 },
	{ 0x5151, 0x24E88 },
	{ 0x5152, 0x24F3A },
	{ 0x5153, 0x24F39 },
	{ 0x5154, 0x769F },
	{ 0x5155, 0x76A0 },
	{ 0x5156, 0x3FE6 },
	{ 0x5157, 0x3FF8 },
	{ 0x5158, 0x25017 },
	{ 0x5159, 0x25093 },
	{ 0x515A, 0x4007 },
	{ 0x515B, 0x25095 },
	{ 0x515C, 0x4064 },
	{ 0x515D, 0x4068 },
	{ 0x515E, 0x25276 },
	{ 0x515F, 0x7794 },
	{ 0x5160, 0x4065 },
	{ 0x5161, 0x77AE },
	{ 0x5162, 0x25280 },
	{ 0x5163, 0x2527B },
	{ 0x5164, 0x4069 },
	{ 0x5165, 0x25248 },
	{ 0x5166, 0x252A8 },
	{ 0x5167, 0x25288 },
	{ 0x5168, 0x2538B },
	{ 0x5169, 0x2538A },
	{ 0x516A, 0x2538C },
	{ 0x516B, 0x253FC },
	{ 0x516C, 0x40DA },
	{ 0x516D, 0x40E0 },
	{ 0x516E, 0x78E6 },
	{ 0x516F, 0x25558 },
	{ 0x5170, 0x40DE },
	{ 0x5171, 0x25551 },
	{ 0x5172, 0x25555 },
	{ 0x5173, 0x25553 },
	{ 0x5174, 0x411C },
	{ 0x5175, 0x411D },
	{ 0x5176, 0x411A },
	{ 0x5177, 0x256DC },
	{ 0x5178, 0x417B },
	{ 0x5179, 0x417A },
	{ 0x517A, 0x417C },
	{ 0x517B, 0x2585C },
	{ 0x517C, 0x4178 },
	{ 0x517D, 0x4177 },
	{ 0x517E, 0x25865 },
	{ 0x5221, 0x2F95A },
	{ 0x5222, 0x41B1 },
	{ 0x5223, 0x259EE },
	{ 0x5224, 0x41B2 },
	{ 0x5225, 0x41B0 },
	{ 0x5226, 0x259F0 },
	{ 0x5227, 0x7ABC },
	{ 0x5228, 0x259F2 },
	{ 0x5229, 0x4236 },
	{ 0x522A, 0x25C35 },
	{ 0x522B, 0x422E },
	{ 0x522C, 0x25C22 },
	{ 0x522D, 0x7BD6 },
	{ 0x522E, 0x25C20 },
	{ 0x522F, 0x4234 },
	{ 0x5230, 0x25C2D },
	{ 0x5231, 0x25C28 },
	{ 0x5232, 0x25C26 },
	{ 0x5233, 0x25C3C },
	{ 0x5234, 0x422A },
	{ 0x5235, 0x25C38 },
	{ 0x5236, 0x4233 },
	{ 0x5237, 0x422D },
	{ 0x5238, 0x422F },
	{ 0x5239, 0x4231 },
	{ 0x523A, 0x422B },
	{ 0x523B, 0x4232 },
	{ 0x523C, 0x25C2A },
	{ 0x523D, 0x4235 },
	{ 0x523E, 0x25C1A },
	{ 0x523F, 0x25C30 },
	{ 0x5240, 0x25BE3 },
	{ 0x5241, 0x25C19 },
	{ 0x5242, 0x25EE9 },
	{ 0x5243, 0x25EE7 },
	{ 0x5244, 0x7CCF },
	{ 0x5245, 0x260D6 },
	{ 0x5246, 0x260C4 },
	{ 0x5247, 0x4308 },
	{ 0x5248, 0x26087 },
	{ 0x5249, 0x4306 },
	{ 0x524A, 0x260C7 },
	{ 0x524B, 0x260D9 },
	{ 0x524C, 0x7E18 },
	{ 0x524D, 0x260DF },
	{ 0x524E, 0x434D },
	{ 0x524F, 0x4361 },
	{ 0x5250, 0x2630A },
	{ 0x5251, 0x26301 },
	{ 0x5252, 0x263B1 },
	{ 0x5253, 0x4378 },
	{ 0x5254, 0x263C1 },
	{ 0x5255, 0x4394 },
	{ 0x5256, 0x4395 },
	{ 0x5257, 0x26476 },
	{ 0x5258, 0x2650D },
	{ 0x5259, 0x2650E },
	{ 0x525A, 0x43C1 },
	{ 0x525B, 0x43C3 },
	{ 0x525C, 0x806D },
	{ 0x525D, 0x26807 },
	{ 0x525E, 0x4439 },
	{ 0x525F, 0x26809 },
	{ 0x5260, 0x26816 },
	{ 0x5261, 0x443A },
	{ 0x5262, 0x443B },
	{ 0x5263, 0x4435 },
	{ 0x5264, 0x4436 },
	{ 0x5265, 0x2680E },
	{ 0x5266, 0x443C },
	{ 0x5267, 0x8190 },
	{ 0x5268, 0x26806 },
	{ 0x5269, 0x2691E },
	{ 0x526A, 0x2694A },
	{ 0x526B, 0x4458 },
	{ 0x526C, 0x447C },
	{ 0x526D, 0x447D },
	{ 0x526E, 0x448D },
	{ 0x526F, 0x448C },
	{ 0x5270, 0x26EA6 },
	{ 0x5271, 0x26E91 },
	{ 0x5272, 0x453B },
	{ 0x5273, 0x453F },
	{ 0x5274, 0x26EB8 },
	{ 0x5275, 0x26E96 },
	{ 0x5276, 0x4532 },
	{ 0x5277, 0x452D },
	{ 0x5278, 0x26EC5 },
	{ 0x5279, 0x452F },
	{ 0x527A, 0x4539 },
	{ 0x527B, 0x452E },
	{ 0x527C, 0x453A },
	{ 0x527D, 0x26F0A },
	{ 0x527E, 0x4536 },
	{ 0x5321, 0x4531 },
	{ 0x5322, 0x453E },
	{ 0x5323, 0x4538 },
	{ 0x5324, 0x8552 },
	{ 0x5325, 0x4534 },
	{ 0x5326, 0x26EB2 },
	{ 0x5327, 0x4541 },
	{ 0x5328, 0x26EB7 },
	{ 0x5329, 0x26EB4 },
	{ 0x532A, 0x26E89 },
	{ 0x532B, 0x26E8D },
	{ 0x532C, 0x4530 },
	{ 0x532D, 0x26E87 },
	{ 0x532E, 0x26EC2 },
	{ 0x532F, 0x26E9C },
	{ 0x5330, 0x26E92 },
	{ 0x5331, 0x4543 },
	{ 0x5332, 0x26ECA },
	{ 0x5333, 0x8550 },
	{ 0x5334, 0x26E8A },
	{ 0x5335, 0x271E0 },
	{ 0x5336, 0x4598 },
	{ 0x5337, 0x271E6 },
	{ 0x5338, 0x271E5 },
	{ 0x5339, 0x87A0 },
	{ 0x533A, 0x273A5 },
	{ 0x533B, 0x273B3 },
	{ 0x533C, 0x8786 },
	{ 0x533D, 0x45DA },
	{ 0x533E, 0x45D7 },
	{ 0x533F, 0x273B5 },
	{ 0x5340, 0x273AF },
	{ 0x5341, 0x8795 },
	{ 0x5342, 0x273B0 },
	{ 0x5343, 0x273CC },
	{ 0x5344, 0x878C },
	{ 0x5345, 0x273A2 },
	{ 0x5346, 0x273BE },
	{ 0x5347, 0x273C6 },
	{ 0x5348, 0x273AC },
	{ 0x5349, 0x273AE },
	{ 0x534A, 0x4618 },
	{ 0x534B, 0x8860 },
	{ 0x534C, 0x2F9C3 },
	{ 0x534D, 0x27708 },
	{ 0x534E, 0x27705 },
	{ 0x534F, 0x4652 },
	{ 0x5350, 0x8928 },
	{ 0x5351, 0x276FE },
	{ 0x5352, 0x464E },
	{ 0x5353, 0x8920 },
	{ 0x5354, 0x27700 },
	{ 0x5355, 0x464F },
	{ 0x5356, 0x4650 },
	{ 0x5357, 0x27864 },
	{ 0x5358, 0x27868 },
	{ 0x5359, 0x89A8 },
	{ 0x535A, 0x4686 },
	{ 0x535B, 0x4687 },
	{ 0x535C, 0x4689 },
	{ 0x535D, 0x2786A },
	{ 0x535E, 0x27869 },
	{ 0x535F, 0x2790D },
	{ 0x5360, 0x27912 },
	{ 0x5361, 0x46A2 },
	{ 0x5362, 0x46A3 },
	{ 0x5363, 0x2790F },
	{ 0x5364, 0x46A1 },
	{ 0x5365, 0x27A67 },
	{ 0x5366, 0x27A79 },
	{ 0x5367, 0x27A72 },
	{ 0x5368, 0x27A66 },
	{ 0x5369, 0x27A7C },
	{ 0x536A, 0x46F9 },
	{ 0x536B, 0x46FD },
	{ 0x536C, 0x27A68 },
	{ 0x536D, 0x27A85 },
	{ 0x536E, 0x27A76 },
	{ 0x536F, 0x27A74 },
	{ 0x5370, 0x27A71 },
	{ 0x5371, 0x27A64 },
	{ 0x5372, 0x473E },
	{ 0x5373, 0x473C },
	{ 0x5374, 0x27BF8 },
	{ 0x5375, 0x474D },
	{ 0x5376, 0x27C6C },
	{ 0x5377, 0x474E },
	{ 0x5378, 0x27CEB },
	{ 0x5379, 0x4781 },
	{ 0x537A, 0x4783 },
	{ 0x537B, 0x4782 },
	{ 0x537C, 0x27DB8 },
	{ 0x537D, 0x4780 },
	{ 0x537E, 0x4788 },
	{ 0x5421, 0x27F2D },
	{ 0x5422, 0x27F2E },
	{ 0x5423, 0x27F28 },
	{ 0x5424, 0x27F29 },
	{ 0x5425, 0x27F31 },
	{ 0x5426, 0x47B9 },
	{ 0x5427, 0x27F2F },
	{ 0x5428, 0x27F2A },
	{ 0x5429, 0x8E3A },
	{ 0x542A, 0x280A4 },
	{ 0x542B, 0x280B7 },
	{ 0x542C, 0x280BF },
	{ 0x542D, 0x4811 },
	{ 0x542E, 0x480D },
	{ 0x542F, 0x4810 },
	{ 0x5430, 0x4813 },
	{ 0x5431, 0x28263 },
	{ 0x5432, 0x483C },
	{ 0x5433, 0x4862 },
	{ 0x5434, 0x4863 },
	{ 0x5435, 0x28367 },
	{ 0x5436, 0x285BE },
	{ 0x5437, 0x2F9E0 },
	{ 0x5438, 0x28795 },
	{ 0x5439, 0x2879C },
	{ 0x543A, 0x4903 },
	{ 0x543B, 0x4906 },
	{ 0x543C, 0x4902 },
	{ 0x543D, 0x4901 },
	{ 0x543E, 0x28871 },
	{ 0x543F, 0x28872 },
	{ 0x5440, 0x4905 },
	{ 0x5441, 0x2886F },
	{ 0x5442, 0x9194 },
	{ 0x5443, 0x9311 },
	{ 0x5444, 0x289F1 },
	{ 0x5445, 0x9337 },
	{ 0x5446, 0x4936 },
	{ 0x5447, 0x289E8 },
	{ 0x5448, 0x4935 },
	{ 0x5449, 0x9343 },
	{ 0x544A, 0x2F9EA },
	{ 0x544B, 0x49A1 },
	{ 0x544C, 0x49A3 },
	{ 0x544D, 0x28D49 },
	{ 0x544E, 0x28D64 },
	{ 0x544F, 0x49A0 },
	{ 0x5450, 0x28D48 },
	{ 0x5451, 0x49EA },
	{ 0x5452, 0x96A6 },
	{ 0x5453, 0x49E8 },
	{ 0x5454, 0x28F2C },
	{ 0x5455, 0x28FE1 },
	{ 0x5456, 0x28FEF },
	{ 0x5457, 0x290C0 },
	{ 0x5458, 0x4A21 },
	{ 0x5459, 0x4A1B },
	{ 0x545A, 0x290D7 },
	{ 0x545B, 0x290D4 },
	{ 0x545C, 0x4A49 },
	{ 0x545D, 0x4A48 },
	{ 0x545E, 0x292AD },
	{ 0x545F, 0x9795 },
	{ 0x5460, 0x4A62 },
	{ 0x5461, 0x4A61 },
	{ 0x5462, 0x4A64 },
	{ 0x5463, 0x4A60 },
	{ 0x5464, 0x4A63 },
	{ 0x5465, 0x292AE },
	{ 0x5466, 0x292AC },
	{ 0x5467, 0x9796 },
	{ 0x5468, 0x4A66 },
	{ 0x5469, 0x4AAC },
	{ 0x546A, 0x4AAB },
	{ 0x546B, 0x29427 },
	{ 0x546C, 0x294AE },
	{ 0x546D, 0x4AC3 },
	{ 0x546E, 0x294B0 },
	{ 0x546F, 0x4AC4 },
	{ 0x5470, 0x9825 },
	{ 0x5471, 0x294C0 },
	{ 0x5472, 0x294C4 },
	{ 0x5473, 0x4B08 },
	{ 0x5474, 0x4B09 },
	{ 0x5475, 0x4B0A },
	{ 0x5476, 0x4B06 },
	{ 0x5477, 0x4B07 },
	{ 0x5478, 0x4B41 },
	{ 0x5479, 0x29707 },
	{ 0x547A, 0x4B45 },
	{ 0x547B, 0x296FD },
	{ 0x547C, 0x4B43 },
	{ 0x547D, 0x4B44 },
	{ 0x547E, 0x9926 },
	{ 0x5521, 0x9934 },
	{ 0x5522, 0x4B47 },
	{ 0x5523, 0x2FA04 },
	{ 0x5524, 0x2981B },
	{ 0x5525, 0x2981C },
	{ 0x5526, 0x4B71 },
	{ 0x5527, 0x298B2 },
	{ 0x5528, 0x298B4 },
	{ 0x5529, 0x298B7 },
	{ 0x552A, 0x298B1 },
	{ 0x552B, 0x298B3 },
	{ 0x552C, 0x298AE },
	{ 0x552D, 0x4B8B },
	{ 0x552E, 0x4BD4 },
	{ 0x552F, 0x4BD3 },
	{ 0x5530, 0x4BD1 },
	{ 0x5531, 0x9ABA },
	{ 0x5532, 0x4BD2 },
	{ 0x5533, 0x29A3F },
	{ 0x5534, 0x29B36 },
	{ 0x5535, 0x4BF7 },
	{ 0x5536, 0x4BF8 },
	{ 0x5537, 0x29B31 },
	{ 0x5538, 0x29B3B },
	{ 0x5539, 0x29B35 },
	{ 0x553A, 0x29B3A },
	{ 0x553B, 0x29B37 },
	{ 0x553C, 0x29C22 },
	{ 0x553D, 0x29C36 },
	{ 0x553E, 0x29C32 },
	{ 0x553F, 0x4C22 },
	{ 0x5540, 0x29CC0 },
	{ 0x5541, 0x4C45 },
	{ 0x5542, 0x4C41 },
	{ 0x5543, 0x9B81 },
	{ 0x5544, 0x4C40 },
	{ 0x5545, 0x9B8A },
	{ 0x5546, 0x29D85 },
	{ 0x5547, 0x9B7F },
	{ 0x5548, 0x4C42 },
	{ 0x5549, 0x29D89 },
	{ 0x554A, 0x4CC1 },
	{ 0x554B, 0x4CC5 },
	{ 0x554C, 0x29FE1 },
	{ 0x554D, 0x4CBB },
	{ 0x554E, 0x4CB9 },
	{ 0x554F, 0x4CBD },
	{ 0x5550, 0x4CC9 },
	{ 0x5551, 0x2A00A },
	{ 0x5552, 0x9D11 },
	{ 0x5553, 0x2A009 },
	{ 0x5554, 0x4CBF },
	{ 0x5555, 0x4CC7 },
	{ 0x5556, 0x29FE8 },
	{ 0x5557, 0x4CC3 },
	{ 0x5558, 0x4D24 },
	{ 0x5559, 0x4D31 },
	{ 0x555A, 0x4D33 },
	{ 0x555B, 0x2A318 },
	{ 0x555C, 0x4D32 },
	{ 0x555D, 0x4D34 },
	{ 0x555E, 0x4D52 },
	{ 0x555F, 0x4D61 },
	{ 0x5560, 0x9ED9 },
	{ 0x5561, 0x4D7A },
	{ 0x5562, 0x4D82 },
	{ 0x5563, 0x9F3C },
	{ 0x5564, 0x2A5C5 },
	{ 0x5565, 0x5123 },
	{ 0x5566, 0x2040D },
	{ 0x5567, 0x2040C },
	{ 0x5568, 0x20421 },
	{ 0x5569, 0x512C },
	{ 0x556A, 0x20616 },
	{ 0x556B, 0x2080E },
	{ 0x556C, 0x350F },
	{ 0x556D, 0x5295 },
	{ 0x556E, 0x20817 },
	{ 0x556F, 0x3523 },
	{ 0x5570, 0x3525 },
	{ 0x5571, 0x21048 },
	{ 0x5572, 0x3606 },
	{ 0x5573, 0x3608 },
	{ 0x5574, 0x5688 },
	{ 0x5575, 0x21055 },
	{ 0x5576, 0x21049 },
	{ 0x5577, 0x2104C },
	{ 0x5578, 0x568B },
	{ 0x5579, 0x2104F },
	{ 0x557A, 0x2103D },
	{ 0x557B, 0x367A },
	{ 0x557C, 0x3677 },
	{ 0x557D, 0x2148A },
	{ 0x557E, 0x214A8 },
	{ 0x5621, 0x2168A },
	{ 0x5622, 0x372E },
	{ 0x5623, 0x218CB },
	{ 0x5624, 0x372F },
	{ 0x5625, 0x218D5 },
	{ 0x5626, 0x221D4 },
	{ 0x5627, 0x381B },
	{ 0x5628, 0x3813 },
	{ 0x5629, 0x21F5C },
	{ 0x562A, 0x21F75 },
	{ 0x562B, 0x3866 },
	{ 0x562C, 0x22161 },
	{ 0x562D, 0x3865 },
	{ 0x562E, 0x21696 },
	{ 0x562F, 0x38F7 },
	{ 0x5630, 0x2258A },
	{ 0x5631, 0x228D0 },
	{ 0x5632, 0x61E1 },
	{ 0x5633, 0x61D7 },
	{ 0x5634, 0x22849 },
	{ 0x5635, 0x228CF },
	{ 0x5636, 0x399C },
	{ 0x5637, 0x22DD6 },
	{ 0x5638, 0x22D7F },
	{ 0x5639, 0x3A53 },
	{ 0x563A, 0x22DD2 },
	{ 0x563B, 0x22DCF },
	{ 0x563C, 0x23006 },
	{ 0x563D, 0x23009 },
	{ 0x563E, 0x3ABA },
	{ 0x563F, 0x65A3 },
	{ 0x5640, 0x3B22 },
	{ 0x5641, 0x66D3 },
	{ 0x5642, 0x23706 },
	{ 0x5643, 0x236F1 },
	{ 0x5644, 0x23704 },
	{ 0x5645, 0x6A8B },
	{ 0x5646, 0x236FA },
	{ 0x5647, 0x236F4 },
	{ 0x5648, 0x3BEB },
	{ 0x5649, 0x3BDD },
	{ 0x564A, 0x236F9 },
	{ 0x564B, 0x3BEF },
	{ 0x564C, 0x2368B },
	{ 0x564D, 0x23703 },
	{ 0x564E, 0x3C47 },
	{ 0x564F, 0x3C46 },
	{ 0x5650, 0x239A2 },
	{ 0x5651, 0x3C78 },
	{ 0x5652, 0x6BAC },
	{ 0x5653, 0x3C89 },
	{ 0x5654, 0x23C0C },
	{ 0x5655, 0x23C0B },
	{ 0x5656, 0x3D68 },
	{ 0x5657, 0x3D76 },
	{ 0x5658, 0x3D74 },
	{ 0x5659, 0x3D79 },
	{ 0x565A, 0x24024 },
	{ 0x565B, 0x3D7A },
	{ 0x565C, 0x3D77 },
	{ 0x565D, 0x2F914 },
	{ 0x565E, 0x3D71 },
	{ 0x565F, 0x24025 },
	{ 0x5660, 0x3D72 },
	{ 0x5661, 0x243F6 },
	{ 0x5662, 0x3DFF },
	{ 0x5663, 0x243FB },
	{ 0x5664, 0x3E05 },
	{ 0x5665, 0x24532 },
	{ 0x5666, 0x245FB },
	{ 0x5667, 0x3E54 },
	{ 0x5668, 0x246F2 },
	{ 0x5669, 0x246F3 },
	{ 0x566A, 0x3E9E },
	{ 0x566B, 0x3E9F },
	{ 0x566C, 0x7374 },
	{ 0x566D, 0x2489C },
	{ 0x566E, 0x24A72 },
	{ 0x566F, 0x3EFA },
	{ 0x5670, 0x24A74 },
	{ 0x5671, 0x3F44 },
	{ 0x5672, 0x3F3F },
	{ 0x5673, 0x3F40 },
	{ 0x5674, 0x24B86 },
	{ 0x5675, 0x3F42 },
	{ 0x5676, 0x24B8E },
	{ 0x5677, 0x24B90 },
	{ 0x5678, 0x3F51 },
	{ 0x5679, 0x24BCD },
	{ 0x567A, 0x24BF7 },
	{ 0x567B, 0x24CD6 },
	{ 0x567C, 0x24E84 },
	{ 0x567D, 0x24E95 },
	{ 0x567E, 0x24E8A },
	{ 0x5721, 0x7640 },
	{ 0x5722, 0x3FCA },
	{ 0x5723, 0x24E97 },
	{ 0x5724, 0x7641 },
	{ 0x5725, 0x3FCE },
	{ 0x5726, 0x3FC9 },
	{ 0x5727, 0x24FA0 },
	{ 0x5728, 0x24FA1 },
	{ 0x5729, 0x25022 },
	{ 0x572A, 0x250A6 },
	{ 0x572B, 0x250A4 },
	{ 0x572C, 0x4009 },
	{ 0x572D, 0x76E8 },
	{ 0x572E, 0x406C },
	{ 0x572F, 0x406E },
	{ 0x5730, 0x4070 },
	{ 0x5731, 0x406D },
	{ 0x5732, 0x406B },
	{ 0x5733, 0x4071 },
	{ 0x5734, 0x4072 },
	{ 0x5735, 0x252AF },
	{ 0x5736, 0x252B0 },
	{ 0x5737, 0x252BD },
	{ 0x5738, 0x408C },
	{ 0x5739, 0x40E4 },
	{ 0x573A, 0x25576 },
	{ 0x573B, 0x40E1 },
	{ 0x573C, 0x2557B },
	{ 0x573D, 0x25579 },
	{ 0x573E, 0x78F6 },
	{ 0x573F, 0x40E7 },
	{ 0x5740, 0x7900 },
	{ 0x5741, 0x40E2 },
	{ 0x5742, 0x411F },
	{ 0x5743, 0x256EE },
	{ 0x5744, 0x256F1 },
	{ 0x5745, 0x417E },
	{ 0x5746, 0x25894 },
	{ 0x5747, 0x4180 },
	{ 0x5748, 0x7A59 },
	{ 0x5749, 0x7A55 },
	{ 0x574A, 0x25891 },
	{ 0x574B, 0x41B9 },
	{ 0x574C, 0x41B7 },
	{ 0x574D, 0x41B8 },
	{ 0x574E, 0x25A10 },
	{ 0x574F, 0x41BA },
	{ 0x5750, 0x7AF4 },
	{ 0x5751, 0x25AAF },
	{ 0x5752, 0x41D3 },
	{ 0x5753, 0x423F },
	{ 0x5754, 0x7C04 },
	{ 0x5755, 0x4245 },
	{ 0x5756, 0x4241 },
	{ 0x5757, 0x7C15 },
	{ 0x5758, 0x4242 },
	{ 0x5759, 0x4243 },
	{ 0x575A, 0x423B },
	{ 0x575B, 0x4238 },
	{ 0x575C, 0x25C7B },
	{ 0x575D, 0x25C77 },
	{ 0x575E, 0x423A },
	{ 0x575F, 0x7BF5 },
	{ 0x5760, 0x25C80 },
	{ 0x5761, 0x25CC6 },
	{ 0x5762, 0x423C },
	{ 0x5763, 0x25C7C },
	{ 0x5764, 0x25C90 },
	{ 0x5765, 0x423E },
	{ 0x5766, 0x25CA3 },
	{ 0x5767, 0x25C7D },
	{ 0x5768, 0x25CBD },
	{ 0x5769, 0x429E },
	{ 0x576A, 0x429F },
	{ 0x576B, 0x42A1 },
	{ 0x576C, 0x25F13 },
	{ 0x576D, 0x429B },
	{ 0x576E, 0x4312 },
	{ 0x576F, 0x26111 },
	{ 0x5770, 0x26144 },
	{ 0x5771, 0x2610D },
	{ 0x5772, 0x4318 },
	{ 0x5773, 0x430C },
	{ 0x5774, 0x26314 },
	{ 0x5775, 0x4362 },
	{ 0x5776, 0x263B8 },
	{ 0x5777, 0x437A },
	{ 0x5778, 0x263B7 },
	{ 0x5779, 0x26483 },
	{ 0x577A, 0x43AE },
	{ 0x577B, 0x43AF },
	{ 0x577C, 0x26514 },
	{ 0x577D, 0x43AD },
	{ 0x577E, 0x2651C },
	{ 0x5821, 0x43C4 },
	{ 0x5822, 0x43C7 },
	{ 0x5823, 0x43C6 },
	{ 0x5824, 0x43C5 },
	{ 0x5825, 0x265D4 },
	{ 0x5826, 0x265D5 },
	{ 0x5827, 0x81C1 },
	{ 0x5828, 0x4440 },
	{ 0x5829, 0x26843 },
	{ 0x582A, 0x26842 },
	{ 0x582B, 0x443F },
	{ 0x582C, 0x4441 },
	{ 0x582D, 0x2F98A },
	{ 0x582E, 0x26841 },
	{ 0x582F, 0x2694E },
	{ 0x5830, 0x447F },
	{ 0x5831, 0x26A87 },
	{ 0x5832, 0x4486 },
	{ 0x5833, 0x4481 },
	{ 0x5834, 0x4480 },
	{ 0x5835, 0x448E },
	{ 0x5836, 0x454A },
	{ 0x5837, 0x26F39 },
	{ 0x5838, 0x4547 },
	{ 0x5839, 0x26F8F },
	{ 0x583A, 0x26F2A },
	{ 0x583B, 0x454B },
	{ 0x583C, 0x4546 },
	{ 0x583D, 0x454E },
	{ 0x583E, 0x857D },
	{ 0x583F, 0x26F2B },
	{ 0x5840, 0x85A5 },
	{ 0x5841, 0x26F50 },
	{ 0x5842, 0x4548 },
	{ 0x5843, 0x26F6E },
	{ 0x5844, 0x4545 },
	{ 0x5845, 0x26F3B },
	{ 0x5846, 0x26F53 },
	{ 0x5847, 0x26F5F },
	{ 0x5848, 0x26F2F },
	{ 0x5849, 0x26F30 },
	{ 0x584A, 0x26F38 },
	{ 0x584B, 0x26F4C },
	{ 0x584C, 0x271F1 },
	{ 0x584D, 0x45DB },
	{ 0x584E, 0x45E7 },
	{ 0x584F, 0x45E4 },
	{ 0x5850, 0x27407 },
	{ 0x5851, 0x27416 },
	{ 0x5852, 0x45E1 },
	{ 0x5853, 0x27414 },
	{ 0x5854, 0x45E9 },
	{ 0x5855, 0x273FB },
	{ 0x5856, 0x45E5 },
	{ 0x5857, 0x45E0 },
	{ 0x5858, 0x45E3 },
	{ 0x5859, 0x273F8 },
	{ 0x585A, 0x27410 },
	{ 0x585B, 0x2741D },
	{ 0x585C, 0x273FF },
	{ 0x585D, 0x2740B },
	{ 0x585E, 0x27404 },
	{ 0x585F, 0x45EA },
	{ 0x5860, 0x273FE },
	{ 0x5861, 0x275FF },
	{ 0x5862, 0x893A },
	{ 0x5863, 0x4654 },
	{ 0x5864, 0x4658 },
	{ 0x5865, 0x465C },
	{ 0x5866, 0x27723 },
	{ 0x5867, 0x4655 },
	{ 0x5868, 0x468B },
	{ 0x5869, 0x468C },
	{ 0x586A, 0x46A6 },
	{ 0x586B, 0x46A5 },
	{ 0x586C, 0x2792A },
	{ 0x586D, 0x27AA0 },
	{ 0x586E, 0x27A98 },
	{ 0x586F, 0x27A9C },
	{ 0x5870, 0x46FF },
	{ 0x5871, 0x27A9E },
	{ 0x5872, 0x27AA6 },
	{ 0x5873, 0x27AB5 },
	{ 0x5874, 0x27AB0 },
	{ 0x5875, 0x4730 },
	{ 0x5876, 0x4740 },
	{ 0x5877, 0x4741 },
	{ 0x5878, 0x27CF9 },
	{ 0x5879, 0x27CF5 },
	{ 0x587A, 0x4786 },
	{ 0x587B, 0x27DD2 },
	{ 0x587C, 0x47BF },
	{ 0x587D, 0x47BD },
	{ 0x587E, 0x27F50 },
	{ 0x5921, 0x27F4E },
	{ 0x5922, 0x27F4B },
	{ 0x5923, 0x27F52 },
	{ 0x5924, 0x27F4D },
	{ 0x5925, 0x47BE },
	{ 0x5926, 0x4819 },
	{ 0x5927, 0x280E4 },
	{ 0x5928, 0x481C },
	{ 0x5929, 0x280DA },
	{ 0x592A, 0x481B },
	{ 0x592B, 0x4817 },
	{ 0x592C, 0x4818 },
	{ 0x592D, 0x8E51 },
	{ 0x592E, 0x280DF },
	{ 0x592F, 0x280E8 },
	{ 0x5930, 0x483D },
	{ 0x5931, 0x486A },
	{ 0x5932, 0x4866 },
	{ 0x5933, 0x28370 },
	{ 0x5934, 0x28372 },
	{ 0x5935, 0x4867 },
	{ 0x5936, 0x28377 },
	{ 0x5937, 0x4868 },
	{ 0x5938, 0x48AD },
	{ 0x5939, 0x48AE },
	{ 0x593A, 0x285E6 },
	{ 0x593B, 0x287AA },
	{ 0x593C, 0x48D6 },
	{ 0x593D, 0x4909 },
	{ 0x593E, 0x2888C },
	{ 0x593F, 0x9198 },
	{ 0x5940, 0x28889 },
	{ 0x5941, 0x490C },
	{ 0x5942, 0x490A },
	{ 0x5943, 0x28A32 },
	{ 0x5944, 0x493B },
	{ 0x5945, 0x493A },
	{ 0x5946, 0x9384 },
	{ 0x5947, 0x9381 },
	{ 0x5948, 0x28A7A },
	{ 0x5949, 0x936F },
	{ 0x594A, 0x28C9E },
	{ 0x594B, 0x28CA0 },
	{ 0x594C, 0x28D70 },
	{ 0x594D, 0x49AF },
	{ 0x594E, 0x49AA },
	{ 0x594F, 0x49AB },
	{ 0x5950, 0x28D6E },
	{ 0x5951, 0x28D66 },
	{ 0x5952, 0x49B1 },
	{ 0x5953, 0x28D65 },
	{ 0x5954, 0x49AC },
	{ 0x5955, 0x49EC },
	{ 0x5956, 0x28F7F },
	{ 0x5957, 0x28FE0 },
	{ 0x5958, 0x4A01 },
	{ 0x5959, 0x28FFF },
	{ 0x595A, 0x290F6 },
	{ 0x595B, 0x290F7 },
	{ 0x595C, 0x290F5 },
	{ 0x595D, 0x4A23 },
	{ 0x595E, 0x290FC },
	{ 0x595F, 0x4A24 },
	{ 0x5960, 0x4A1E },
	{ 0x5961, 0x290F9 },
	{ 0x5962, 0x4A4A },
	{ 0x5963, 0x4A65 },
	{ 0x5964, 0x4A6A },
	{ 0x5965, 0x292CA },
	{ 0x5966, 0x292C3 },
	{ 0x5967, 0x292C6 },
	{ 0x5968, 0x4A69 },
	{ 0x5969, 0x293B8 },
	{ 0x596A, 0x293BD },
	{ 0x596B, 0x4A95 },
	{ 0x596C, 0x293BC },
	{ 0x596D, 0x29405 },
	{ 0x596E, 0x294E0 },
	{ 0x596F, 0x294E9 },
	{ 0x5970, 0x9842 },
	{ 0x5971, 0x294DF },
	{ 0x5972, 0x294EC },
	{ 0x5973, 0x4ACC },
	{ 0x5974, 0x294E5 },
	{ 0x5975, 0x294DE },
	{ 0x5976, 0x2FA00 },
	{ 0x5977, 0x4ACF },
	{ 0x5978, 0x294F0 },
	{ 0x5979, 0x294E3 },
	{ 0x597A, 0x4B0F },
	{ 0x597B, 0x295EC },
	{ 0x597C, 0x4B0E },
	{ 0x597D, 0x4B0B },
	{ 0x597E, 0x4B10 },
	{ 0x5A21, 0x4B0D },
	{ 0x5A22, 0x4B0C },
	{ 0x5A23, 0x295F2 },
	{ 0x5A24, 0x295EF },
	{ 0x5A25, 0x295E9 },
	{ 0x5A26, 0x296FB },
	{ 0x5A27, 0x4B46 },
	{ 0x5A28, 0x4B48 },
	{ 0x5A29, 0x9937 },
	{ 0x5A2A, 0x4B49 },
	{ 0x5A2B, 0x29737 },
	{ 0x5A2C, 0x298DE },
	{ 0x5A2D, 0x4B91 },
	{ 0x5A2E, 0x4B8E },
	{ 0x5A2F, 0x298DA },
	{ 0x5A30, 0x4BD8 },
	{ 0x5A31, 0x4BD6 },
	{ 0x5A32, 0x29A4B },
	{ 0x5A33, 0x4BDA },
	{ 0x5A34, 0x29A49 },
	{ 0x5A35, 0x4BD7 },
	{ 0x5A36, 0x29AD5 },
	{ 0x5A37, 0x9AFF },
	{ 0x5A38, 0x4BF9 },
	{ 0x5A39, 0x29B52 },
	{ 0x5A3A, 0x29B47 },
	{ 0x5A3B, 0x4BFC },
	{ 0x5A3C, 0x29B48 },
	{ 0x5A3D, 0x29CCC },
	{ 0x5A3E, 0x29CD0 },
	{ 0x5A3F, 0x9BA9 },
	{ 0x5A40, 0x4C4A },
	{ 0x5A41, 0x9BA7 },
	{ 0x5A42, 0x4C4E },
	{ 0x5A43, 0x9BB3 },
	{ 0x5A44, 0x9BAC },
	{ 0x5A45, 0x9BB0 },
	{ 0x5A46, 0x29D86 },
	{ 0x5A47, 0x29DA7 },
	{ 0x5A48, 0x29DA3 },
	{ 0x5A49, 0x9B9C },
	{ 0x5A4A, 0x29DB6 },
	{ 0x5A4B, 0x29DAD },
	{ 0x5A4C, 0x2A013 },
	{ 0x5A4D, 0x9D3C },
	{ 0x5A4E, 0x9D1C },
	{ 0x5A4F, 0x9D3A },
	{ 0x5A50, 0x4CD3 },
	{ 0x5A51, 0x4CCD },
	{ 0x5A52, 0x4CD1 },
	{ 0x5A53, 0x2A017 },
	{ 0x5A54, 0x2A022 },
	{ 0x5A55, 0x9D32 },
	{ 0x5A56, 0x9D34 },
	{ 0x5A57, 0x2A049 },
	{ 0x5A58, 0x2A026 },
	{ 0x5A59, 0x2FA0C },
	{ 0x5A5A, 0x2A03C },
	{ 0x5A5B, 0x2A028 },
	{ 0x5A5C, 0x2A2A8 },
	{ 0x5A5D, 0x9EC7 },
	{ 0x5A5E, 0x2A3FB },
	{ 0x5A5F, 0x4D62 },
	{ 0x5A60, 0x2A432 },
	{ 0x5A61, 0x2A4D6 },
	{ 0x5A62, 0x2A548 },
	{ 0x5A63, 0x4D83 },
	{ 0x5A64, 0x9F3F },
	{ 0x5A65, 0x2A5C6 },
	{ 0x5A66, 0x4D92 },
	{ 0x5A67, 0x349F },
	{ 0x5A68, 0x34A0 },
	{ 0x5A69, 0x20425 },
	{ 0x5A6A, 0x20426 },
	{ 0x5A6B, 0x20424 },
	{ 0x5A6C, 0x20433 },
	{ 0x5A6D, 0x20570 },
	{ 0x5A6E, 0x3527 },
	{ 0x5A6F, 0x20B90 },
	{ 0x5A70, 0x360B },
	{ 0x5A71, 0x21095 },
	{ 0x5A72, 0x210A1 },
	{ 0x5A73, 0x21092 },
	{ 0x5A74, 0x2108F },
	{ 0x5A75, 0x2109F },
	{ 0x5A76, 0x21096 },
	{ 0x5A77, 0x21098 },
	{ 0x5A78, 0x2109D },
	{ 0x5A79, 0x210A0 },
	{ 0x5A7A, 0x368D },
	{ 0x5A7B, 0x21697 },
	{ 0x5A7C, 0x218EB },
	{ 0x5A7D, 0x3770 },
	{ 0x5A7E, 0x21F87 },
	{ 0x5B21, 0x5EEB },
	{ 0x5B22, 0x22432 },
	{ 0x5B23, 0x399A },
	{ 0x5B24, 0x399F },
	{ 0x5B25, 0x399D },
	{ 0x5B26, 0x228D8 },
	{ 0x5B27, 0x228FB },
	{ 0x5B28, 0x22906 },
	{ 0x5B29, 0x399B },
	{ 0x5B2A, 0x228D1 },
	{ 0x5B2B, 0x61D5 },
	{ 0x5B2C, 0x2F8B0 },
	{ 0x5B2D, 0x3A60 },
	{ 0x5B2E, 0x3A64 },
	{ 0x5B2F, 0x3A69 },
	{ 0x5B30, 0x3A63 },
	{ 0x5B31, 0x3A67 },
	{ 0x5B32, 0x3A62 },
	{ 0x5B33, 0x22DF6 },
	{ 0x5B34, 0x22E04 },
	{ 0x5B35, 0x22DFE },
	{ 0x5B36, 0x6502 },
	{ 0x5B37, 0x22DFF },
	{ 0x5B38, 0x22DF7 },
	{ 0x5B39, 0x23018 },
	{ 0x5B3A, 0x3AAC },
	{ 0x5B3B, 0x23014 },
	{ 0x5B3C, 0x230CD },
	{ 0x5B3D, 0x23120 },
	{ 0x5B3E, 0x232DE },
	{ 0x5B3F, 0x3B26 },
	{ 0x5B40, 0x3B23 },
	{ 0x5B41, 0x3B25 },
	{ 0x5B42, 0x23745 },
	{ 0x5B43, 0x23753 },
	{ 0x5B44, 0x3BF8 },
	{ 0x5B45, 0x2374B },
	{ 0x5B46, 0x23755 },
	{ 0x5B47, 0x23741 },
	{ 0x5B48, 0x3BF7 },
	{ 0x5B49, 0x3BFB },
	{ 0x5B4A, 0x3BFA },
	{ 0x5B4B, 0x2375C },
	{ 0x5B4C, 0x23754 },
	{ 0x5B4D, 0x23A71 },
	{ 0x5B4E, 0x23AD0 },
	{ 0x5B4F, 0x3CB0 },
	{ 0x5B50, 0x3CAF },
	{ 0x5B51, 0x23C53 },
	{ 0x5B52, 0x24029 },
	{ 0x5B53, 0x2407E },
	{ 0x5B54, 0x3D7E },
	{ 0x5B55, 0x24079 },
	{ 0x5B56, 0x3D7D },
	{ 0x5B57, 0x3D80 },
	{ 0x5B58, 0x24070 },
	{ 0x5B59, 0x2406A },
	{ 0x5B5A, 0x3D7F },
	{ 0x5B5B, 0x3D86 },
	{ 0x5B5C, 0x24085 },
	{ 0x5B5D, 0x24064 },
	{ 0x5B5E, 0x7012 },
	{ 0x5B5F, 0x24078 },
	{ 0x5B60, 0x3D81 },
	{ 0x5B61, 0x24432 },
	{ 0x5B62, 0x24427 },
	{ 0x5B63, 0x2442F },
	{ 0x5B64, 0x3E24 },
	{ 0x5B65, 0x3E58 },
	{ 0x5B66, 0x3E57 },
	{ 0x5B67, 0x3EA0 },
	{ 0x5B68, 0x248BA },
	{ 0x5B69, 0x3EFE },
	{ 0x5B6A, 0x24A71 },
	{ 0x5B6B, 0x24A8C },
	{ 0x5B6C, 0x3F15 },
	{ 0x5B6D, 0x24B1A },
	{ 0x5B6E, 0x3F47 },
	{ 0x5B6F, 0x3F46 },
	{ 0x5B70, 0x24B98 },
	{ 0x5B71, 0x24CE4 },
	{ 0x5B72, 0x3F6B },
	{ 0x5B73, 0x3F6C },
	{ 0x5B74, 0x7585 },
	{ 0x5B75, 0x7654 },
	{ 0x5B76, 0x24EC2 },
	{ 0x5B77, 0x3FCC },
	{ 0x5B78, 0x24EBA },
	{ 0x5B79, 0x7655 },
	{ 0x5B7A, 0x24EC8 },
	{ 0x5B7B, 0x3FCB },
	{ 0x5B7C, 0x76A7 },
	{ 0x5B7D, 0x76A8 },
	{ 0x5B7E, 0x3FF9 },
	{ 0x5C21, 0x250B9 },
	{ 0x5C22, 0x250B8 },
	{ 0x5C23, 0x250A5 },
	{ 0x5C24, 0x252E2 },
	{ 0x5C25, 0x4078 },
	{ 0x5C26, 0x407A },
	{ 0x5C27, 0x4075 },
	{ 0x5C28, 0x252D9 },
	{ 0x5C29, 0x4076 },
	{ 0x5C2A, 0x4077 },
	{ 0x5C2B, 0x252AC },
	{ 0x5C2C, 0x252DD },
	{ 0x5C2D, 0x40EA },
	{ 0x5C2E, 0x40EE },
	{ 0x5C2F, 0x40ED },
	{ 0x5C30, 0x2559D },
	{ 0x5C31, 0x40EC },
	{ 0x5C32, 0x790F },
	{ 0x5C33, 0x25711 },
	{ 0x5C34, 0x25703 },
	{ 0x5C35, 0x4184 },
	{ 0x5C36, 0x4185 },
	{ 0x5C37, 0x4183 },
	{ 0x5C38, 0x258EE },
	{ 0x5C39, 0x41BC },
	{ 0x5C3A, 0x41BD },
	{ 0x5C3B, 0x41D4 },
	{ 0x5C3C, 0x25CA4 },
	{ 0x5C3D, 0x25CD8 },
	{ 0x5C3E, 0x25CDD },
	{ 0x5C3F, 0x25CDE },
	{ 0x5C40, 0x4255 },
	{ 0x5C41, 0x25CE7 },
	{ 0x5C42, 0x4250 },
	{ 0x5C43, 0x424C },
	{ 0x5C44, 0x4248 },
	{ 0x5C45, 0x25CD4 },
	{ 0x5C46, 0x4253 },
	{ 0x5C47, 0x25CCE },
	{ 0x5C48, 0x4257 },
	{ 0x5C49, 0x4254 },
	{ 0x5C4A, 0x424E },
	{ 0x5C4B, 0x424A },
	{ 0x5C4C, 0x4251 },
	{ 0x5C4D, 0x25CF1 },
	{ 0x5C4E, 0x25CD3 },
	{ 0x5C4F, 0x4249 },
	{ 0x5C50, 0x424B },
	{ 0x5C51, 0x4263 },
	{ 0x5C52, 0x25CCA },
	{ 0x5C53, 0x25CE9 },
	{ 0x5C54, 0x42A7 },
	{ 0x5C55, 0x42A6 },
	{ 0x5C56, 0x42A4 },
	{ 0x5C57, 0x25F1A },
	{ 0x5C58, 0x25F41 },
	{ 0x5C59, 0x2F968 },
	{ 0x5C5A, 0x7CE4 },
	{ 0x5C5B, 0x7CE5 },
	{ 0x5C5C, 0x2613D },
	{ 0x5C5D, 0x26140 },
	{ 0x5C5E, 0x7E65 },
	{ 0x5C5F, 0x7E4E },
	{ 0x5C60, 0x4317 },
	{ 0x5C61, 0x26143 },
	{ 0x5C62, 0x4316 },
	{ 0x5C63, 0x2613F },
	{ 0x5C64, 0x2613C },
	{ 0x5C65, 0x4363 },
	{ 0x5C66, 0x26321 },
	{ 0x5C67, 0x26320 },
	{ 0x5C68, 0x7F82 },
	{ 0x5C69, 0x263C6 },
	{ 0x5C6A, 0x437B },
	{ 0x5C6B, 0x437C },
	{ 0x5C6C, 0x263D1 },
	{ 0x5C6D, 0x263CA },
	{ 0x5C6E, 0x2648E },
	{ 0x5C6F, 0x26491 },
	{ 0x5C70, 0x43B0 },
	{ 0x5C71, 0x802D },
	{ 0x5C72, 0x265E3 },
	{ 0x5C73, 0x26888 },
	{ 0x5C74, 0x4442 },
	{ 0x5C75, 0x26870 },
	{ 0x5C76, 0x4444 },
	{ 0x5C77, 0x2699D },
	{ 0x5C78, 0x26A9D },
	{ 0x5C79, 0x26A91 },
	{ 0x5C7A, 0x26A98 },
	{ 0x5C7B, 0x26A99 },
	{ 0x5C7C, 0x4488 },
	{ 0x5C7D, 0x448F },
	{ 0x5C7E, 0x4553 },
	{ 0x5D21, 0x455B },
	{ 0x5D22, 0x26FBF },
	{ 0x5D23, 0x4559 },
	{ 0x5D24, 0x26FAE },
	{ 0x5D25, 0x26FB1 },
	{ 0x5D26, 0x26FCC },
	{ 0x5D27, 0x27004 },
	{ 0x5D28, 0x85CA },
	{ 0x5D29, 0x27016 },
	{ 0x5D2A, 0x26FCD },
	{ 0x5D2B, 0x4554 },
	{ 0x5D2C, 0x85BC },
	{ 0x5D2D, 0x26FE0 },
	{ 0x5D2E, 0x26FCB },
	{ 0x5D2F, 0x26FD4 },
	{ 0x5D30, 0x26FC9 },
	{ 0x5D31, 0x271FF },
	{ 0x5D32, 0x4599 },
	{ 0x5D33, 0x271FD },
	{ 0x5D34, 0x27457 },
	{ 0x5D35, 0x27452 },
	{ 0x5D36, 0x27450 },
	{ 0x5D37, 0x27445 },
	{ 0x5D38, 0x2744D },
	{ 0x5D39, 0x45F1 },
	{ 0x5D3A, 0x27453 },
	{ 0x5D3B, 0x45EF },
	{ 0x5D3C, 0x27482 },
	{ 0x5D3D, 0x27444 },
	{ 0x5D3E, 0x275CE },
	{ 0x5D3F, 0x275CF },
	{ 0x5D40, 0x275D2 },
	{ 0x5D41, 0x27602 },
	{ 0x5D42, 0x2774F },
	{ 0x5D43, 0x27758 },
	{ 0x5D44, 0x4662 },
	{ 0x5D45, 0x27743 },
	{ 0x5D46, 0x4663 },
	{ 0x5D47, 0x27752 },
	{ 0x5D48, 0x4660 },
	{ 0x5D49, 0x4661 },
	{ 0x5D4A, 0x465F },
	{ 0x5D4B, 0x27749 },
	{ 0x5D4C, 0x27753 },
	{ 0x5D4D, 0x2774D },
	{ 0x5D4E, 0x468D },
	{ 0x5D4F, 0x27884 },
	{ 0x5D50, 0x468E },
	{ 0x5D51, 0x27883 },
	{ 0x5D52, 0x27932 },
	{ 0x5D53, 0x27AE2 },
	{ 0x5D54, 0x4709 },
	{ 0x5D55, 0x27AE4 },
	{ 0x5D56, 0x27AD3 },
	{ 0x5D57, 0x4705 },
	{ 0x5D58, 0x27AD5 },
	{ 0x5D59, 0x27ADD },
	{ 0x5D5A, 0x4703 },
	{ 0x5D5B, 0x4706 },
	{ 0x5D5C, 0x27AEC },
	{ 0x5D5D, 0x27AE6 },
	{ 0x5D5E, 0x27AD2 },
	{ 0x5D5F, 0x27AFA },
	{ 0x5D60, 0x27ADA },
	{ 0x5D61, 0x4731 },
	{ 0x5D62, 0x27C06 },
	{ 0x5D63, 0x27C04 },
	{ 0x5D64, 0x474F },
	{ 0x5D65, 0x27C7B },
	{ 0x5D66, 0x27D04 },
	{ 0x5D67, 0x27D02 },
	{ 0x5D68, 0x4766 },
	{ 0x5D69, 0x8CFF },
	{ 0x5D6A, 0x47C4 },
	{ 0x5D6B, 0x27F60 },
	{ 0x5D6C, 0x47C3 },
	{ 0x5D6D, 0x47C1 },
	{ 0x5D6E, 0x47C5 },
	{ 0x5D6F, 0x28107 },
	{ 0x5D70, 0x28105 },
	{ 0x5D71, 0x2810C },
	{ 0x5D72, 0x4821 },
	{ 0x5D73, 0x2815A },
	{ 0x5D74, 0x481F },
	{ 0x5D75, 0x4822 },
	{ 0x5D76, 0x2811A },
	{ 0x5D77, 0x4827 },
	{ 0x5D78, 0x4820 },
	{ 0x5D79, 0x2838A },
	{ 0x5D7A, 0x486D },
	{ 0x5D7B, 0x486C },
	{ 0x5D7C, 0x486B },
	{ 0x5D7D, 0x486F },
	{ 0x5D7E, 0x4870 },
	{ 0x5E21, 0x2838C },
	{ 0x5E22, 0x28609 },
	{ 0x5E23, 0x288A6 },
	{ 0x5E24, 0x91A6 },
	{ 0x5E25, 0x288AC },
	{ 0x5E26, 0x288A9 },
	{ 0x5E27, 0x4942 },
	{ 0x5E28, 0x28A8B },
	{ 0x5E29, 0x93B6 },
	{ 0x5E2A, 0x28A8C },
	{ 0x5E2B, 0x4944 },
	{ 0x5E2C, 0x4940 },
	{ 0x5E2D, 0x28A88 },
	{ 0x5E2E, 0x28A89 },
	{ 0x5E2F, 0x493F },
	{ 0x5E30, 0x28A93 },
	{ 0x5E31, 0x93AB },
	{ 0x5E32, 0x498B },
	{ 0x5E33, 0x28D83 },
	{ 0x5E34, 0x28F4F },
	{ 0x5E35, 0x4A25 },
	{ 0x5E36, 0x4A28 },
	{ 0x5E37, 0x29120 },
	{ 0x5E38, 0x9721 },
	{ 0x5E39, 0x29236 },
	{ 0x5E3A, 0x292E2 },
	{ 0x5E3B, 0x4A75 },
	{ 0x5E3C, 0x4A72 },
	{ 0x5E3D, 0x292EE },
	{ 0x5E3E, 0x4A6F },
	{ 0x5E3F, 0x292E7 },
	{ 0x5E40, 0x292E9 },
	{ 0x5E41, 0x4A76 },
	{ 0x5E42, 0x4A71 },
	{ 0x5E43, 0x97A7 },
	{ 0x5E44, 0x292DF },
	{ 0x5E45, 0x4A97 },
	{ 0x5E46, 0x293C7 },
	{ 0x5E47, 0x4AD7 },
	{ 0x5E48, 0x29509 },
	{ 0x5E49, 0x4AD6 },
	{ 0x5E4A, 0x29501 },
	{ 0x5E4B, 0x4AD8 },
	{ 0x5E4C, 0x4ADC },
	{ 0x5E4D, 0x4ADB },
	{ 0x5E4E, 0x4AD4 },
	{ 0x5E4F, 0x983E },
	{ 0x5E50, 0x4B13 },
	{ 0x5E51, 0x4B11 },
	{ 0x5E52, 0x4B14 },
	{ 0x5E53, 0x29605 },
	{ 0x5E54, 0x2960C },
	{ 0x5E55, 0x29778 },
	{ 0x5E56, 0x2975D },
	{ 0x5E57, 0x4B51 },
	{ 0x5E58, 0x4B50 },
	{ 0x5E59, 0x4B53 },
	{ 0x5E5A, 0x4B54 },
	{ 0x5E5B, 0x4B52 },
	{ 0x5E5C, 0x2975E },
	{ 0x5E5D, 0x29760 },
	{ 0x5E5E, 0x29767 },
	{ 0x5E5F, 0x4B6D },
	{ 0x5E60, 0x2FA05 },
	{ 0x5E61, 0x298F4 },
	{ 0x5E62, 0x4B95 },
	{ 0x5E63, 0x4B99 },
	{ 0x5E64, 0x298F1 },
	{ 0x5E65, 0x4B9A },
	{ 0x5E66, 0x298FA },
	{ 0x5E67, 0x4B93 },
	{ 0x5E68, 0x4B97 },
	{ 0x5E69, 0x298F8 },
	{ 0x5E6A, 0x298F9 },
	{ 0x5E6B, 0x29909 },
	{ 0x5E6C, 0x298FD },
	{ 0x5E6D, 0x298F7 },
	{ 0x5E6E, 0x4BDC },
	{ 0x5E6F, 0x29A59 },
	{ 0x5E70, 0x4BFD },
	{ 0x5E71, 0x29B60 },
	{ 0x5E72, 0x29B68 },
	{ 0x5E73, 0x4BFE },
	{ 0x5E74, 0x4C00 },
	{ 0x5E75, 0x4C02 },
	{ 0x5E76, 0x4C01 },
	{ 0x5E77, 0x4C03 },
	{ 0x5E78, 0x29B6A },
	{ 0x5E79, 0x29C14 },
	{ 0x5E7A, 0x29C3E },
	{ 0x5E7B, 0x29CE4 },
	{ 0x5E7C, 0x4C27 },
	{ 0x5E7D, 0x4C26 },
	{ 0x5E7E, 0x4C24 },
	{ 0x5F21, 0x4C4C },
	{ 0x5F22, 0x9BBC },
	{ 0x5F23, 0x4C50 },
	{ 0x5F24, 0x4C55 },
	{ 0x5F25, 0x4C53 },
	{ 0x5F26, 0x9BB7 },
	{ 0x5F27, 0x4C52 },
	{ 0x5F28, 0x29DD2 },
	{ 0x5F29, 0x4C57 },
	{ 0x5F2A, 0x9BBE },
	{ 0x5F2B, 0x4C58 },
	{ 0x5F2C, 0x4CD6 },
	{ 0x5F2D, 0x2A058 },
	{ 0x5F2E, 0x2A050 },
	{ 0x5F2F, 0x4CD4 },
	{ 0x5F30, 0x2A05C },
	{ 0x5F31, 0x4CDA },
	{ 0x5F32, 0x4CD9 },
	{ 0x5F33, 0x28119 },
	{ 0x5F34, 0x9D62 },
	{ 0x5F35, 0x4CD5 },
	{ 0x5F36, 0x4CE4 },
	{ 0x5F37, 0x2FA0E },
	{ 0x5F38, 0x4CDC },
	{ 0x5F39, 0x4D1B },
	{ 0x5F3A, 0x9E8F },
	{ 0x5F3B, 0x4D37 },
	{ 0x5F3C, 0x4D36 },
	{ 0x5F3D, 0x4D4B },
	{ 0x5F3E, 0x9ECB },
	{ 0x5F3F, 0x4D66 },
	{ 0x5F40, 0x4D76 },
	{ 0x5F41, 0x2A4DF },
	{ 0x5F42, 0x4D7E },
	{ 0x5F43, 0x4D7D },
	{ 0x5F44, 0x4D7F },
	{ 0x5F45, 0x4D84 },
	{ 0x5F46, 0x4D8B },
	{ 0x5F47, 0x2A5D9 },
	{ 0x5F48, 0x4D94 },
	{ 0x5F49, 0x34A1 },
	{ 0x5F4A, 0x3511 },
	{ 0x5F4B, 0x20966 },
	{ 0x5F4C, 0x3610 },
	{ 0x5F4D, 0x56A9 },
	{ 0x5F4E, 0x210E1 },
	{ 0x5F4F, 0x210EF },
	{ 0x5F50, 0x210E8 },
	{ 0x5F51, 0x21233 },
	{ 0x5F52, 0x5913 },
	{ 0x5F53, 0x218FE },
	{ 0x5F54, 0x3732 },
	{ 0x5F55, 0x5BF4 },
	{ 0x5F56, 0x21AEF },
	{ 0x5F57, 0x21AEC },
	{ 0x5F58, 0x21CEC },
	{ 0x5F59, 0x21F9C },
	{ 0x5F5A, 0x3820 },
	{ 0x5F5B, 0x21F99 },
	{ 0x5F5C, 0x22170 },
	{ 0x5F5D, 0x2216E },
	{ 0x5F5E, 0x389D },
	{ 0x5F5F, 0x22441 },
	{ 0x5F60, 0x61EC },
	{ 0x5F61, 0x61EF },
	{ 0x5F62, 0x22902 },
	{ 0x5F63, 0x22901 },
	{ 0x5F64, 0x39A5 },
	{ 0x5F65, 0x22A1B },
	{ 0x5F66, 0x22E23 },
	{ 0x5F67, 0x22E25 },
	{ 0x5F68, 0x22E24 },
	{ 0x5F69, 0x22E26 },
	{ 0x5F6A, 0x22E33 },
	{ 0x5F6B, 0x22E2F },
	{ 0x5F6C, 0x2308F },
	{ 0x5F6D, 0x23356 },
	{ 0x5F6E, 0x3C02 },
	{ 0x5F6F, 0x3BFE },
	{ 0x5F70, 0x3C01 },
	{ 0x5F71, 0x6AD6 },
	{ 0x5F72, 0x3C03 },
	{ 0x5F73, 0x3BFF },
	{ 0x5F74, 0x23799 },
	{ 0x5F75, 0x3C04 },
	{ 0x5F76, 0x2F8ED },
	{ 0x5F77, 0x3C4A },
	{ 0x5F78, 0x23AD9 },
	{ 0x5F79, 0x3D87 },
	{ 0x5F7A, 0x240B7 },
	{ 0x5F7B, 0x3D84 },
	{ 0x5F7C, 0x240B6 },
	{ 0x5F7D, 0x3D85 },
	{ 0x5F7E, 0x7209 },
	{ 0x6021, 0x24454 },
	{ 0x6022, 0x24457 },
	{ 0x6023, 0x2447A },
	{ 0x6024, 0x3E59 },
	{ 0x6025, 0x7379 },
	{ 0x6026, 0x24A8E },
	{ 0x6027, 0x74C6 },
	{ 0x6028, 0x24A90 },
	{ 0x6029, 0x24AB9 },
	{ 0x602A, 0x3F04 },
	{ 0x602B, 0x3F49 },
	{ 0x602C, 0x3F48 },
	{ 0x602D, 0x24CEF },
	{ 0x602E, 0x3F6D },
	{ 0x602F, 0x3FD2 },
	{ 0x6030, 0x3FD3 },
	{ 0x6031, 0x24EE2 },
	{ 0x6032, 0x3FD1 },
	{ 0x6033, 0x24ED6 },
	{ 0x6034, 0x24ED8 },
	{ 0x6035, 0x24EDA },
	{ 0x6036, 0x24EDE },
	{ 0x6037, 0x3FE7 },
	{ 0x6038, 0x400A },
	{ 0x6039, 0x77C3 },
	{ 0x603A, 0x25308 },
	{ 0x603B, 0x25304 },
	{ 0x603C, 0x2530A },
	{ 0x603D, 0x2530B },
	{ 0x603E, 0x25302 },
	{ 0x603F, 0x40F0 },
	{ 0x6040, 0x255AA },
	{ 0x6041, 0x255C1 },
	{ 0x6042, 0x791F },
	{ 0x6043, 0x258D7 },
	{ 0x6044, 0x258D9 },
	{ 0x6045, 0x7A65 },
	{ 0x6046, 0x258DE },
	{ 0x6047, 0x258DA },
	{ 0x6048, 0x41BE },
	{ 0x6049, 0x41BF },
	{ 0x604A, 0x25A2A },
	{ 0x604B, 0x7AC6 },
	{ 0x604C, 0x7C3A },
	{ 0x604D, 0x25D31 },
	{ 0x604E, 0x7C36 },
	{ 0x604F, 0x25D2B },
	{ 0x6050, 0x25D2C },
	{ 0x6051, 0x25D29 },
	{ 0x6052, 0x25D2E },
	{ 0x6053, 0x425E },
	{ 0x6054, 0x25D27 },
	{ 0x6055, 0x25D28 },
	{ 0x6056, 0x425B },
	{ 0x6057, 0x25D5F },
	{ 0x6058, 0x25D30 },
	{ 0x6059, 0x25D24 },
	{ 0x605A, 0x7CEB },
	{ 0x605B, 0x42AB },
	{ 0x605C, 0x25F3A },
	{ 0x605D, 0x42AC },
	{ 0x605E, 0x25F39 },
	{ 0x605F, 0x25F40 },
	{ 0x6060, 0x26180 },
	{ 0x6061, 0x26184 },
	{ 0x6062, 0x431F },
	{ 0x6063, 0x431D },
	{ 0x6064, 0x26175 },
	{ 0x6065, 0x26176 },
	{ 0x6066, 0x431C },
	{ 0x6067, 0x2617C },
	{ 0x6068, 0x431E },
	{ 0x6069, 0x26178 },
	{ 0x606A, 0x2619B },
	{ 0x606B, 0x2617E },
	{ 0x606C, 0x2625A },
	{ 0x606D, 0x4364 },
	{ 0x606E, 0x2632C },
	{ 0x606F, 0x7F84 },
	{ 0x6070, 0x2649C },
	{ 0x6071, 0x26847 },
	{ 0x6072, 0x2688A },
	{ 0x6073, 0x4448 },
	{ 0x6074, 0x4447 },
	{ 0x6075, 0x26927 },
	{ 0x6076, 0x2704A },
	{ 0x6077, 0x455E },
	{ 0x6078, 0x4561 },
	{ 0x6079, 0x27027 },
	{ 0x607A, 0x85E0 },
	{ 0x607B, 0x85F3 },
	{ 0x607C, 0x2702E },
	{ 0x607D, 0x27026 },
	{ 0x607E, 0x27208 },
	{ 0x6121, 0x45F7 },
	{ 0x6122, 0x274BD },
	{ 0x6123, 0x27496 },
	{ 0x6124, 0x45F4 },
	{ 0x6125, 0x45F8 },
	{ 0x6126, 0x881E },
	{ 0x6127, 0x274BE },
	{ 0x6128, 0x2748E },
	{ 0x6129, 0x27774 },
	{ 0x612A, 0x4664 },
	{ 0x612B, 0x27780 },
	{ 0x612C, 0x4692 },
	{ 0x612D, 0x468F },
	{ 0x612E, 0x4690 },
	{ 0x612F, 0x89B4 },
	{ 0x6130, 0x4693 },
	{ 0x6131, 0x46A8 },
	{ 0x6132, 0x2793C },
	{ 0x6133, 0x2793D },
	{ 0x6134, 0x46A9 },
	{ 0x6135, 0x2793A },
	{ 0x6136, 0x27942 },
	{ 0x6137, 0x89F9 },
	{ 0x6138, 0x27B24 },
	{ 0x6139, 0x27B06 },
	{ 0x613A, 0x8B44 },
	{ 0x613B, 0x470E },
	{ 0x613C, 0x27B15 },
	{ 0x613D, 0x470F },
	{ 0x613E, 0x27B02 },
	{ 0x613F, 0x27B0C },
	{ 0x6140, 0x470B },
	{ 0x6141, 0x27B08 },
	{ 0x6142, 0x27B0A },
	{ 0x6143, 0x27B05 },
	{ 0x6144, 0x27B1C },
	{ 0x6145, 0x4710 },
	{ 0x6146, 0x4751 },
	{ 0x6147, 0x27C82 },
	{ 0x6148, 0x4750 },
	{ 0x6149, 0x27C86 },
	{ 0x614A, 0x4763 },
	{ 0x614B, 0x27E03 },
	{ 0x614C, 0x27F7B },
	{ 0x614D, 0x47C7 },
	{ 0x614E, 0x27F7A },
	{ 0x614F, 0x8E71 },
	{ 0x6150, 0x4824 },
	{ 0x6151, 0x4826 },
	{ 0x6152, 0x8E6E },
	{ 0x6153, 0x28180 },
	{ 0x6154, 0x8E79 },
	{ 0x6155, 0x28158 },
	{ 0x6156, 0x8EC4 },
	{ 0x6157, 0x4874 },
	{ 0x6158, 0x4873 },
	{ 0x6159, 0x4872 },
	{ 0x615A, 0x283AA },
	{ 0x615B, 0x283AB },
	{ 0x615C, 0x28436 },
	{ 0x615D, 0x2844A },
	{ 0x615E, 0x48B1 },
	{ 0x615F, 0x908C },
	{ 0x6160, 0x287D6 },
	{ 0x6161, 0x490E },
	{ 0x6162, 0x4911 },
	{ 0x6163, 0x4910 },
	{ 0x6164, 0x490F },
	{ 0x6165, 0x4912 },
	{ 0x6166, 0x4949 },
	{ 0x6167, 0x93C9 },
	{ 0x6168, 0x494F },
	{ 0x6169, 0x494D },
	{ 0x616A, 0x28B03 },
	{ 0x616B, 0x28ACF },
	{ 0x616C, 0x4955 },
	{ 0x616D, 0x28D9F },
	{ 0x616E, 0x28DA2 },
	{ 0x616F, 0x2902A },
	{ 0x6170, 0x2902F },
	{ 0x6171, 0x29144 },
	{ 0x6172, 0x29140 },
	{ 0x6173, 0x4A2C },
	{ 0x6174, 0x4A2B },
	{ 0x6175, 0x29311 },
	{ 0x6176, 0x2930F },
	{ 0x6177, 0x4A79 },
	{ 0x6178, 0x2930D },
	{ 0x6179, 0x29307 },
	{ 0x617A, 0x29303 },
	{ 0x617B, 0x4A7A },
	{ 0x617C, 0x97B0 },
	{ 0x617D, 0x4A99 },
	{ 0x617E, 0x4A9A },
	{ 0x6221, 0x29435 },
	{ 0x6222, 0x4AAE },
	{ 0x6223, 0x4AAF },
	{ 0x6224, 0x29504 },
	{ 0x6225, 0x4AE4 },
	{ 0x6226, 0x4AE1 },
	{ 0x6227, 0x4ADE },
	{ 0x6228, 0x4AE6 },
	{ 0x6229, 0x4ADF },
	{ 0x622A, 0x29526 },
	{ 0x622B, 0x4AE7 },
	{ 0x622C, 0x4AE2 },
	{ 0x622D, 0x4AE0 },
	{ 0x622E, 0x2951E },
	{ 0x622F, 0x4AE5 },
	{ 0x6230, 0x985A },
	{ 0x6231, 0x2960E },
	{ 0x6232, 0x4B18 },
	{ 0x6233, 0x2961D },
	{ 0x6234, 0x2961E },
	{ 0x6235, 0x2961F },
	{ 0x6236, 0x4B56 },
	{ 0x6237, 0x29788 },
	{ 0x6238, 0x9946 },
	{ 0x6239, 0x2978D },
	{ 0x623A, 0x29791 },
	{ 0x623B, 0x29780 },
	{ 0x623C, 0x4B6E },
	{ 0x623D, 0x29854 },
	{ 0x623E, 0x29855 },
	{ 0x623F, 0x4B9D },
	{ 0x6240, 0x4BA0 },
	{ 0x6241, 0x4B9C },
	{ 0x6242, 0x29925 },
	{ 0x6243, 0x2991A },
	{ 0x6244, 0x4BA1 },
	{ 0x6245, 0x4BA2 },
	{ 0x6246, 0x4B9F },
	{ 0x6247, 0x4BDF },
	{ 0x6248, 0x4BDE },
	{ 0x6249, 0x9AC3 },
	{ 0x624A, 0x4BEA },
	{ 0x624B, 0x29B88 },
	{ 0x624C, 0x4C06 },
	{ 0x624D, 0x29B7A },
	{ 0x624E, 0x4C04 },
	{ 0x624F, 0x9B0F },
	{ 0x6250, 0x29B80 },
	{ 0x6251, 0x29D1E },
	{ 0x6252, 0x29DFC },
	{ 0x6253, 0x29E25 },
	{ 0x6254, 0x4C5F },
	{ 0x6255, 0x9BF4 },
	{ 0x6256, 0x9BFA },
	{ 0x6257, 0x4C5C },
	{ 0x6258, 0x29E0B },
	{ 0x6259, 0x4C5E },
	{ 0x625A, 0x29E06 },
	{ 0x625B, 0x29E04 },
	{ 0x625C, 0x9BDD },
	{ 0x625D, 0x4C59 },
	{ 0x625E, 0x29DF9 },
	{ 0x625F, 0x29E00 },
	{ 0x6260, 0x4C64 },
	{ 0x6261, 0x4C5D },
	{ 0x6262, 0x4C62 },
	{ 0x6263, 0x29E02 },
	{ 0x6264, 0x4C65 },
	{ 0x6265, 0x29E07 },
	{ 0x6266, 0x9BED },
	{ 0x6267, 0x4C5B },
	{ 0x6268, 0x9BEF },
	{ 0x6269, 0x2A0B5 },
	{ 0x626A, 0x4CDD },
	{ 0x626B, 0x2A087 },
	{ 0x626C, 0x4CDF },
	{ 0x626D, 0x2A093 },
	{ 0x626E, 0x2FA0F },
	{ 0x626F, 0x4CE2 },
	{ 0x6270, 0x2A0BE },
	{ 0x6271, 0x2A266 },
	{ 0x6272, 0x4D27 },
	{ 0x6273, 0x2A2C7 },
	{ 0x6274, 0x2A2CF },
	{ 0x6275, 0x9E96 },
	{ 0x6276, 0x4D3A },
	{ 0x6277, 0x4D3C },
	{ 0x6278, 0x2A33D },
	{ 0x6279, 0x4D39 },
	{ 0x627A, 0x2A33C },
	{ 0x627B, 0x2A347 },
	{ 0x627C, 0x4D3D },
	{ 0x627D, 0x4D3B },
	{ 0x627E, 0x9EB3 },
	{ 0x6321, 0x4D4C },
	{ 0x6322, 0x2A3C3 },
	{ 0x6323, 0x4D68 },
	{ 0x6324, 0x9EE2 },
	{ 0x6325, 0x2A51B },
	{ 0x6326, 0x4D80 },
	{ 0x6327, 0x4D85 },
	{ 0x6328, 0x2A5C9 },
	{ 0x6329, 0x4D95 },
	{ 0x632A, 0x2A5DD },
	{ 0x632B, 0x4D96 },
	{ 0x632C, 0x2A693 },
	{ 0x632D, 0x9F8F },
	{ 0x632E, 0x2043D },
	{ 0x632F, 0x34A4 },
	{ 0x6330, 0x3512 },
	{ 0x6331, 0x56B1 },
	{ 0x6332, 0x3625 },
	{ 0x6333, 0x214E6 },
	{ 0x6334, 0x5B41 },
	{ 0x6335, 0x3737 },
	{ 0x6336, 0x21AF7 },
	{ 0x6337, 0x21FB0 },
	{ 0x6338, 0x21FAE },
	{ 0x633A, 0x3868 },
	{ 0x633B, 0x3867 },
	{ 0x633C, 0x389E },
	{ 0x633D, 0x2259F },
	{ 0x633E, 0x2259E },
	{ 0x633F, 0x22930 },
	{ 0x6340, 0x39AA },
	{ 0x6341, 0x2294F },
	{ 0x6342, 0x39A9 },
	{ 0x6343, 0x39A4 },
	{ 0x6344, 0x22927 },
	{ 0x6345, 0x22951 },
	{ 0x6346, 0x3A71 },
	{ 0x6347, 0x3A6F },
	{ 0x6348, 0x22E51 },
	{ 0x6349, 0x22E54 },
	{ 0x634A, 0x22E56 },
	{ 0x634B, 0x23027 },
	{ 0x634C, 0x3AAD },
	{ 0x634D, 0x23024 },
	{ 0x634E, 0x6AF6 },
	{ 0x634F, 0x3C0C },
	{ 0x6350, 0x6AF2 },
	{ 0x6351, 0x3C0B },
	{ 0x6352, 0x237EC },
	{ 0x6353, 0x237C4 },
	{ 0x6354, 0x3C0F },
	{ 0x6355, 0x3C79 },
	{ 0x6356, 0x240F8 },
	{ 0x6357, 0x240F6 },
	{ 0x6358, 0x240F7 },
	{ 0x6359, 0x240ED },
	{ 0x635A, 0x3D8D },
	{ 0x635B, 0x3D8F },
	{ 0x635C, 0x240F4 },
	{ 0x635D, 0x240EF },
	{ 0x635E, 0x3D8E },
	{ 0x635F, 0x3E0C },
	{ 0x6360, 0x2447F },
	{ 0x6361, 0x244A2 },
	{ 0x6362, 0x2447E },
	{ 0x6363, 0x3EA6 },
	{ 0x6364, 0x248C5 },
	{ 0x6365, 0x3EA3 },
	{ 0x6366, 0x3EA4 },
	{ 0x6367, 0x3EA5 },
	{ 0x6368, 0x7588 },
	{ 0x6369, 0x3F6E },
	{ 0x636A, 0x24EF1 },
	{ 0x636B, 0x24EF2 },
	{ 0x636C, 0x3FFA },
	{ 0x636D, 0x2502F },
	{ 0x636E, 0x407C },
	{ 0x636F, 0x407E },
	{ 0x6370, 0x407B },
	{ 0x6371, 0x407D },
	{ 0x6372, 0x25323 },
	{ 0x6373, 0x25329 },
	{ 0x6374, 0x408D },
	{ 0x6375, 0x40F4 },
	{ 0x6376, 0x40F3 },
	{ 0x6377, 0x2571B },
	{ 0x6378, 0x258EB },
	{ 0x6379, 0x4189 },
	{ 0x637A, 0x258EA },
	{ 0x637B, 0x25A33 },
	{ 0x637C, 0x41C0 },
	{ 0x637D, 0x25D63 },
	{ 0x637E, 0x4265 },
	{ 0x6421, 0x25D92 },
	{ 0x6422, 0x25D65 },
	{ 0x6423, 0x42AD },
	{ 0x6424, 0x4325 },
	{ 0x6425, 0x261A0 },
	{ 0x6426, 0x2F970 },
	{ 0x6427, 0x2625E },
	{ 0x6428, 0x43C9 },
	{ 0x6429, 0x268AA },
	{ 0x642A, 0x444A },
	{ 0x642B, 0x268A9 },
	{ 0x642C, 0x8267 },
	{ 0x642D, 0x4489 },
	{ 0x642E, 0x2709C },
	{ 0x642F, 0x4566 },
	{ 0x6430, 0x4570 },
	{ 0x6431, 0x27092 },
	{ 0x6432, 0x456D },
	{ 0x6433, 0x4569 },
	{ 0x6434, 0x4567 },
	{ 0x6435, 0x27086 },
	{ 0x6436, 0x4572 },
	{ 0x6437, 0x860E },
	{ 0x6438, 0x456E },
	{ 0x6439, 0x27083 },
	{ 0x643A, 0x459C },
	{ 0x643B, 0x45FC },
	{ 0x643C, 0x45FD },
	{ 0x643D, 0x4604 },
	{ 0x643E, 0x45FF },
	{ 0x643F, 0x2F9C2 },
	{ 0x6440, 0x45FE },
	{ 0x6441, 0x4600 },
	{ 0x6442, 0x274CE },
	{ 0x6443, 0x4666 },
	{ 0x6444, 0x4669 },
	{ 0x6445, 0x27793 },
	{ 0x6446, 0x46AA },
	{ 0x6447, 0x46AB },
	{ 0x6448, 0x4717 },
	{ 0x6449, 0x27B2E },
	{ 0x644A, 0x27B27 },
	{ 0x644B, 0x27B28 },
	{ 0x644C, 0x4715 },
	{ 0x644D, 0x8B5E },
	{ 0x644E, 0x4712 },
	{ 0x644F, 0x8D0E },
	{ 0x6450, 0x27E18 },
	{ 0x6451, 0x27E16 },
	{ 0x6452, 0x27F8D },
	{ 0x6453, 0x47CA },
	{ 0x6454, 0x27F8E },
	{ 0x6455, 0x47C9 },
	{ 0x6456, 0x47CB },
	{ 0x6457, 0x27F90 },
	{ 0x6458, 0x27F8F },
	{ 0x6459, 0x28181 },
	{ 0x645A, 0x4829 },
	{ 0x645B, 0x4828 },
	{ 0x645C, 0x2818A },
	{ 0x645D, 0x2818C },
	{ 0x645E, 0x2828D },
	{ 0x645F, 0x4840 },
	{ 0x6460, 0x4875 },
	{ 0x6461, 0x4876 },
	{ 0x6462, 0x283B2 },
	{ 0x6463, 0x4888 },
	{ 0x6464, 0x287D9 },
	{ 0x6465, 0x91B6 },
	{ 0x6466, 0x4957 },
	{ 0x6467, 0x9401 },
	{ 0x6468, 0x28B0D },
	{ 0x6469, 0x495F },
	{ 0x646A, 0x28B13 },
	{ 0x646B, 0x941D },
	{ 0x646C, 0x4958 },
	{ 0x646D, 0x495B },
	{ 0x646E, 0x28B1B },
	{ 0x646F, 0x942F },
	{ 0x6470, 0x28DAC },
	{ 0x6471, 0x49B3 },
	{ 0x6472, 0x28DB3 },
	{ 0x6473, 0x49EF },
	{ 0x6474, 0x2915E },
	{ 0x6475, 0x4A30 },
	{ 0x6476, 0x29160 },
	{ 0x6477, 0x29168 },
	{ 0x6478, 0x29163 },
	{ 0x6479, 0x29169 },
	{ 0x647A, 0x29167 },
	{ 0x647B, 0x4A41 },
	{ 0x647C, 0x4A4B },
	{ 0x647D, 0x29328 },
	{ 0x647E, 0x4A7D },
	{ 0x6521, 0x2932E },
	{ 0x6522, 0x29330 },
	{ 0x6523, 0x4A7C },
	{ 0x6524, 0x29326 },
	{ 0x6525, 0x29331 },
	{ 0x6526, 0x29341 },
	{ 0x6527, 0x97E0 },
	{ 0x6528, 0x293DA },
	{ 0x6529, 0x97DB },
	{ 0x652A, 0x2F9FA },
	{ 0x652B, 0x2940B },
	{ 0x652C, 0x9861 },
	{ 0x652D, 0x29534 },
	{ 0x652E, 0x29533 },
	{ 0x652F, 0x4AE8 },
	{ 0x6530, 0x4AEA },
	{ 0x6531, 0x4AE9 },
	{ 0x6532, 0x29539 },
	{ 0x6533, 0x2953B },
	{ 0x6534, 0x29540 },
	{ 0x6535, 0x29630 },
	{ 0x6536, 0x4B1B },
	{ 0x6537, 0x29632 },
	{ 0x6538, 0x29637 },
	{ 0x6539, 0x4B55 },
	{ 0x653A, 0x994A },
	{ 0x653B, 0x4B59 },
	{ 0x653C, 0x4B58 },
	{ 0x653D, 0x29781 },
	{ 0x653E, 0x2979F },
	{ 0x653F, 0x297A7 },
	{ 0x6540, 0x4BA4 },
	{ 0x6541, 0x4BA3 },
	{ 0x6542, 0x29944 },
	{ 0x6543, 0x29947 },
	{ 0x6544, 0x29948 },
	{ 0x6545, 0x2993D },
	{ 0x6546, 0x9A33 },
	{ 0x6547, 0x4BA7 },
	{ 0x6548, 0x29949 },
	{ 0x6549, 0x4BE0 },
	{ 0x654A, 0x29A80 },
	{ 0x654B, 0x29BA0 },
	{ 0x654C, 0x29B9D },
	{ 0x654D, 0x4C08 },
	{ 0x654E, 0x4C0A },
	{ 0x654F, 0x4C09 },
	{ 0x6550, 0x29B9C },
	{ 0x6551, 0x29C47 },
	{ 0x6552, 0x29D07 },
	{ 0x6553, 0x4C71 },
	{ 0x6554, 0x9C0F },
	{ 0x6555, 0x4C6C },
	{ 0x6556, 0x29E49 },
	{ 0x6557, 0x9C11 },
	{ 0x6558, 0x29E44 },
	{ 0x6559, 0x9C03 },
	{ 0x655A, 0x9C01 },
	{ 0x655B, 0x4C6E },
	{ 0x655C, 0x29EDF },
	{ 0x655D, 0x9C16 },
	{ 0x655E, 0x29E4C },
	{ 0x6560, 0x29E4F },
	{ 0x6561, 0x4CE0 },
	{ 0x6562, 0x4CEE },
	{ 0x6563, 0x2A0C1 },
	{ 0x6564, 0x4CEB },
	{ 0x6565, 0x2A0B9 },
	{ 0x6566, 0x2A0CB },
	{ 0x6567, 0x2A0CF },
	{ 0x6568, 0x2A0C4 },
	{ 0x6569, 0x9D93 },
	{ 0x656A, 0x4CEA },
	{ 0x656B, 0x4CEF },
	{ 0x656C, 0x4CE7 },
	{ 0x656D, 0x2A0CA },
	{ 0x656E, 0x2A0C3 },
	{ 0x656F, 0x2A2D0 },
	{ 0x6570, 0x2A351 },
	{ 0x6571, 0x4D48 },
	{ 0x6572, 0x4D49 },
	{ 0x6573, 0x2A3A8 },
	{ 0x6574, 0x2A3C7 },
	{ 0x6575, 0x2A3C6 },
	{ 0x6576, 0x4D4D },
	{ 0x6577, 0x2A3CA },
	{ 0x6578, 0x2A402 },
	{ 0x6579, 0x4D55 },
	{ 0x657A, 0x2A45D },
	{ 0x657B, 0x2A45A },
	{ 0x657C, 0x4D6A },
	{ 0x657D, 0x4D6C },
	{ 0x657E, 0x2A459 },
	{ 0x6621, 0x4D6B },
	{ 0x6622, 0x2A4CC },
	{ 0x6623, 0x2A51C },
	{ 0x6624, 0x2A5CC },
	{ 0x6625, 0x4D98 },
	{ 0x6626, 0x4D99 },
	{ 0x6627, 0x4D97 },
	{ 0x6628, 0x2A5E8 },
	{ 0x6629, 0x2A5EC },
	{ 0x662A, 0x2A5EA },
	{ 0x662B, 0x2A6AD },
	{ 0x662C, 0x2A6B0 },
	{ 0x662D, 0x2045F },
	{ 0x662E, 0x20458 },
	{ 0x662F, 0x20457 },
	{ 0x6630, 0x535B },
	{ 0x6631, 0x20B93 },
	{ 0x6632, 0x3616 },
	{ 0x6633, 0x2113B },
	{ 0x6634, 0x56BF },
	{ 0x6635, 0x21134 },
	{ 0x6636, 0x214F2 },
	{ 0x6637, 0x3739 },
	{ 0x6638, 0x21AFD },
	{ 0x6639, 0x21C1D },
	{ 0x663A, 0x3825 },
	{ 0x663B, 0x5DCE },
	{ 0x663C, 0x22304 },
	{ 0x663D, 0x22448 },
	{ 0x663E, 0x22958 },
	{ 0x663F, 0x22E4F },
	{ 0x6640, 0x3A74 },
	{ 0x6641, 0x22E6E },
	{ 0x6642, 0x22E72 },
	{ 0x6643, 0x3AAE },
	{ 0x6644, 0x2302E },
	{ 0x6645, 0x237FC },
	{ 0x6646, 0x237F4 },
	{ 0x6647, 0x23C36 },
	{ 0x6648, 0x2410E },
	{ 0x6649, 0x3D92 },
	{ 0x664A, 0x3D94 },
	{ 0x664B, 0x24114 },
	{ 0x664C, 0x3D95 },
	{ 0x664D, 0x24119 },
	{ 0x664E, 0x3E0D },
	{ 0x664F, 0x244A6 },
	{ 0x6650, 0x3E25 },
	{ 0x6651, 0x24AC9 },
	{ 0x6652, 0x24AC0 },
	{ 0x6653, 0x24ACC },
	{ 0x6654, 0x24B1B },
	{ 0x6655, 0x24BAA },
	{ 0x6656, 0x24BA8 },
	{ 0x6657, 0x24F03 },
	{ 0x6658, 0x3FD5 },
	{ 0x6659, 0x3FD6 },
	{ 0x665A, 0x76AC },
	{ 0x665B, 0x3FE8 },
	{ 0x665C, 0x25035 },
	{ 0x665D, 0x407F },
	{ 0x665E, 0x77D2 },
	{ 0x665F, 0x40F5 },
	{ 0x6660, 0x40F6 },
	{ 0x6661, 0x40F7 },
	{ 0x6662, 0x255D9 },
	{ 0x6663, 0x4124 },
	{ 0x6664, 0x418D },
	{ 0x6665, 0x418A },
	{ 0x6666, 0x25A3F },
	{ 0x6667, 0x25A3D },
	{ 0x6668, 0x426C },
	{ 0x6669, 0x4266 },
	{ 0x666A, 0x426A },
	{ 0x666B, 0x25D8B },
	{ 0x666C, 0x4267 },
	{ 0x666D, 0x426D },
	{ 0x666E, 0x4268 },
	{ 0x666F, 0x7C52 },
	{ 0x6670, 0x25D68 },
	{ 0x6671, 0x25D8A },
	{ 0x6672, 0x25F58 },
	{ 0x6673, 0x25F57 },
	{ 0x6674, 0x261CE },
	{ 0x6675, 0x261BC },
	{ 0x6676, 0x261C0 },
	{ 0x6677, 0x261C1 },
	{ 0x6678, 0x261BF },
	{ 0x6679, 0x261AB },
	{ 0x667A, 0x2625F },
	{ 0x667B, 0x4365 },
	{ 0x667C, 0x264A6 },
	{ 0x667D, 0x439A },
	{ 0x667E, 0x26529 },
	{ 0x6721, 0x43B1 },
	{ 0x6722, 0x444B },
	{ 0x6723, 0x444D },
	{ 0x6724, 0x444C },
	{ 0x6725, 0x444E },
	{ 0x6726, 0x268B8 },
	{ 0x6727, 0x4573 },
	{ 0x6728, 0x4575 },
	{ 0x6729, 0x270DD },
	{ 0x672A, 0x270D6 },
	{ 0x672B, 0x2F9B1 },
	{ 0x672C, 0x270D5 },
	{ 0x672D, 0x270E7 },
	{ 0x672E, 0x270D8 },
	{ 0x672F, 0x274EC },
	{ 0x6730, 0x4603 },
	{ 0x6731, 0x27500 },
	{ 0x6732, 0x27507 },
	{ 0x6733, 0x274FD },
	{ 0x6734, 0x274F1 },
	{ 0x6735, 0x274FF },
	{ 0x6736, 0x277AA },
	{ 0x6737, 0x277B0 },
	{ 0x6738, 0x27B48 },
	{ 0x6739, 0x471E },
	{ 0x673A, 0x27B53 },
	{ 0x673B, 0x8B73 },
	{ 0x673C, 0x27B4D },
	{ 0x673D, 0x4719 },
	{ 0x673E, 0x471C },
	{ 0x673F, 0x471A },
	{ 0x6740, 0x471D },
	{ 0x6741, 0x8B76 },
	{ 0x6742, 0x27B43 },
	{ 0x6743, 0x27B50 },
	{ 0x6744, 0x4743 },
	{ 0x6745, 0x4752 },
	{ 0x6746, 0x27C8C },
	{ 0x6747, 0x27E27 },
	{ 0x6748, 0x4795 },
	{ 0x6749, 0x27F99 },
	{ 0x674A, 0x47CC },
	{ 0x674B, 0x281B1 },
	{ 0x674C, 0x482B },
	{ 0x674D, 0x281B0 },
	{ 0x674E, 0x281AA },
	{ 0x674F, 0x281AC },
	{ 0x6750, 0x482A },
	{ 0x6751, 0x8EC7 },
	{ 0x6752, 0x4877 },
	{ 0x6753, 0x283C8 },
	{ 0x6754, 0x283CA },
	{ 0x6755, 0x28642 },
	{ 0x6756, 0x287E0 },
	{ 0x6757, 0x288E7 },
	{ 0x6758, 0x288E8 },
	{ 0x6759, 0x288E6 },
	{ 0x675A, 0x4913 },
	{ 0x675B, 0x4914 },
	{ 0x675C, 0x9434 },
	{ 0x675D, 0x28B5B },
	{ 0x675E, 0x28B56 },
	{ 0x675F, 0x495D },
	{ 0x6760, 0x28B5A },
	{ 0x6761, 0x4960 },
	{ 0x6762, 0x943E },
	{ 0x6763, 0x4962 },
	{ 0x6764, 0x28CB8 },
	{ 0x6765, 0x28DC5 },
	{ 0x6766, 0x49B2 },
	{ 0x6767, 0x49F0 },
	{ 0x6768, 0x29048 },
	{ 0x6769, 0x2917D },
	{ 0x676A, 0x2917C },
	{ 0x676B, 0x29181 },
	{ 0x676C, 0x29182 },
	{ 0x676D, 0x29162 },
	{ 0x676E, 0x4A4C },
	{ 0x676F, 0x29345 },
	{ 0x6770, 0x4A82 },
	{ 0x6771, 0x97BC },
	{ 0x6772, 0x4A81 },
	{ 0x6773, 0x4A9B },
	{ 0x6774, 0x293E3 },
	{ 0x6775, 0x4AA4 },
	{ 0x6776, 0x4AEE },
	{ 0x6777, 0x4AEC },
	{ 0x6778, 0x29550 },
	{ 0x6779, 0x4AED },
	{ 0x677A, 0x2954F },
	{ 0x677B, 0x4AF0 },
	{ 0x677C, 0x4AEF },
	{ 0x677D, 0x29639 },
	{ 0x677E, 0x4B1D },
	{ 0x6821, 0x2963A },
	{ 0x6822, 0x4B60 },
	{ 0x6823, 0x4B5E },
	{ 0x6824, 0x4B5D },
	{ 0x6825, 0x297C1 },
	{ 0x6826, 0x2994E },
	{ 0x6827, 0x2996E },
	{ 0x6828, 0x4BB1 },
	{ 0x6829, 0x4BAB },
	{ 0x682A, 0x4BAC },
	{ 0x682B, 0x4BAD },
	{ 0x682C, 0x29971 },
	{ 0x682D, 0x4BAE },
	{ 0x682E, 0x29A8C },
	{ 0x682F, 0x29A89 },
	{ 0x6830, 0x4BE2 },
	{ 0x6831, 0x29AE5 },
	{ 0x6832, 0x29BB3 },
	{ 0x6833, 0x29BB6 },
	{ 0x6834, 0x29BB4 },
	{ 0x6835, 0x29C4D },
	{ 0x6836, 0x9B39 },
	{ 0x6837, 0x29D13 },
	{ 0x6838, 0x29E78 },
	{ 0x6839, 0x9C2A },
	{ 0x683A, 0x4C7B },
	{ 0x683B, 0x9C26 },
	{ 0x683C, 0x4C78 },
	{ 0x683D, 0x4C75 },
	{ 0x683E, 0x9C27 },
	{ 0x683F, 0x29E72 },
	{ 0x6840, 0x4CF2 },
	{ 0x6841, 0x4CF4 },
	{ 0x6842, 0x4CF3 },
	{ 0x6843, 0x9DC0 },
	{ 0x6844, 0x9DC9 },
	{ 0x6845, 0x2A275 },
	{ 0x6846, 0x2A2DA },
	{ 0x6847, 0x2A2D7 },
	{ 0x6848, 0x4D3F },
	{ 0x6849, 0x4D3E },
	{ 0x684A, 0x4D40 },
	{ 0x684B, 0x4D4E },
	{ 0x684C, 0x4D57 },
	{ 0x684D, 0x4D59 },
	{ 0x684E, 0x4D58 },
	{ 0x684F, 0x2FA16 },
	{ 0x6850, 0x2A469 },
	{ 0x6851, 0x2A467 },
	{ 0x6852, 0x4D6E },
	{ 0x6853, 0x2A466 },
	{ 0x6854, 0x2A46F },
	{ 0x6855, 0x2A471 },
	{ 0x6856, 0x9EEC },
	{ 0x6857, 0x2A4CF },
	{ 0x6858, 0x2A523 },
	{ 0x6859, 0x4D81 },
	{ 0x685A, 0x4D86 },
	{ 0x685B, 0x2A5A5 },
	{ 0x685C, 0x4D8F },
	{ 0x685D, 0x2A5FE },
	{ 0x685E, 0x2A5FB },
	{ 0x685F, 0x2A5FD },
	{ 0x6860, 0x9F68 },
	{ 0x6861, 0x4D9B },
	{ 0x6862, 0x4DB1 },
	{ 0x6863, 0x4DB3 },
	{ 0x6864, 0x2116D },
	{ 0x6865, 0x373A },
	{ 0x6866, 0x21B05 },
	{ 0x6867, 0x21C20 },
	{ 0x6868, 0x3827 },
	{ 0x6869, 0x21FC8 },
	{ 0x686A, 0x21FC9 },
	{ 0x686B, 0x386A },
	{ 0x686C, 0x39AC },
	{ 0x686D, 0x23127 },
	{ 0x686E, 0x3C18 },
	{ 0x686F, 0x2381E },
	{ 0x6870, 0x23936 },
	{ 0x6871, 0x3C4C },
	{ 0x6872, 0x2413D },
	{ 0x6873, 0x3D96 },
	{ 0x6874, 0x248D7 },
	{ 0x6875, 0x3F4A },
	{ 0x6876, 0x24BAD },
	{ 0x6877, 0x24D00 },
	{ 0x6878, 0x4081 },
	{ 0x6879, 0x2533A },
	{ 0x687A, 0x4083 },
	{ 0x687B, 0x40F9 },
	{ 0x687C, 0x40F8 },
	{ 0x687D, 0x25726 },
	{ 0x687E, 0x418E },
	{ 0x6921, 0x418F },
	{ 0x6922, 0x41C1 },
	{ 0x6923, 0x25DB7 },
	{ 0x6924, 0x25DB6 },
	{ 0x6925, 0x25DC0 },
	{ 0x6926, 0x4270 },
	{ 0x6927, 0x25D9B },
	{ 0x6928, 0x4271 },
	{ 0x6929, 0x261D8 },
	{ 0x692A, 0x432A },
	{ 0x692B, 0x432D },
	{ 0x692C, 0x437D },
	{ 0x692D, 0x8032 },
	{ 0x692E, 0x8031 },
	{ 0x692F, 0x268C0 },
	{ 0x6930, 0x444F },
	{ 0x6931, 0x268BF },
	{ 0x6932, 0x26ABF },
	{ 0x6933, 0x4490 },
	{ 0x6934, 0x27120 },
	{ 0x6935, 0x270D0 },
	{ 0x6936, 0x2710E },
	{ 0x6937, 0x4579 },
	{ 0x6938, 0x2711D },
	{ 0x6939, 0x2711E },
	{ 0x693A, 0x27115 },
	{ 0x693B, 0x27114 },
	{ 0x693C, 0x2751E },
	{ 0x693D, 0x2752C },
	{ 0x693E, 0x4605 },
	{ 0x693F, 0x277B9 },
	{ 0x6940, 0x277B8 },
	{ 0x6941, 0x277B6 },
	{ 0x6942, 0x2789E },
	{ 0x6943, 0x2789C },
	{ 0x6944, 0x2794D },
	{ 0x6945, 0x89FD },
	{ 0x6946, 0x27B6E },
	{ 0x6947, 0x27B60 },
	{ 0x6948, 0x4721 },
	{ 0x6949, 0x27B64 },
	{ 0x694A, 0x27B62 },
	{ 0x694B, 0x261E5 },
	{ 0x694C, 0x4732 },
	{ 0x694D, 0x27FA3 },
	{ 0x694E, 0x47CD },
	{ 0x694F, 0x47CF },
	{ 0x6950, 0x283D2 },
	{ 0x6951, 0x283D5 },
	{ 0x6952, 0x908E },
	{ 0x6953, 0x4916 },
	{ 0x6954, 0x4915 },
	{ 0x6955, 0x49B5 },
	{ 0x6956, 0x4A08 },
	{ 0x6957, 0x29055 },
	{ 0x6958, 0x4A32 },
	{ 0x6959, 0x29193 },
	{ 0x695A, 0x4A33 },
	{ 0x695B, 0x4A34 },
	{ 0x695C, 0x4A3C },
	{ 0x695D, 0x29356 },
	{ 0x695E, 0x97C2 },
	{ 0x695F, 0x293E9 },
	{ 0x6960, 0x4A9C },
	{ 0x6961, 0x29445 },
	{ 0x6962, 0x4AF4 },
	{ 0x6963, 0x4AF2 },
	{ 0x6964, 0x2967C },
	{ 0x6965, 0x4B62 },
	{ 0x6966, 0x297D3 },
	{ 0x6967, 0x4B61 },
	{ 0x6968, 0x4B64 },
	{ 0x6969, 0x4BB5 },
	{ 0x696A, 0x9A4B },
	{ 0x696B, 0x4BB4 },
	{ 0x696C, 0x2998E },
	{ 0x696D, 0x29A97 },
	{ 0x696E, 0x4BE3 },
	{ 0x696F, 0x29A9B },
	{ 0x6970, 0x29A99 },
	{ 0x6971, 0x9B1C },
	{ 0x6972, 0x4C0E },
	{ 0x6973, 0x29BCF },
	{ 0x6974, 0x9B1B },
	{ 0x6975, 0x29C59 },
	{ 0x6976, 0x4C2C },
	{ 0x6977, 0x4C2B },
	{ 0x6978, 0x29D20 },
	{ 0x6979, 0x29D23 },
	{ 0x697A, 0x29D2A },
	{ 0x697B, 0x4C85 },
	{ 0x697C, 0x4C81 },
	{ 0x697D, 0x4C7E },
	{ 0x697E, 0x4C83 },
	{ 0x6A21, 0x4C80 },
	{ 0x6A22, 0x29EB0 },
	{ 0x6A23, 0x9C42 },
	{ 0x6A24, 0x2A12F },
	{ 0x6A25, 0x9DD4 },
	{ 0x6A26, 0x4CFB },
	{ 0x6A27, 0x4CF7 },
	{ 0x6A28, 0x2A132 },
	{ 0x6A29, 0x2A143 },
	{ 0x6A2A, 0x2A13F },
	{ 0x6A2B, 0x2A139 },
	{ 0x6A2C, 0x4CF8 },
	{ 0x6A2D, 0x2A130 },
	{ 0x6A2E, 0x2A2DD },
	{ 0x6A2F, 0x2A3DA },
	{ 0x6A30, 0x2A3DB },
	{ 0x6A31, 0x4D5A },
	{ 0x6A32, 0x2A484 },
	{ 0x6A33, 0x2A47F },
	{ 0x6A34, 0x2A472 },
	{ 0x6A35, 0x2A480 },
	{ 0x6A36, 0x2A4EE },
	{ 0x6A37, 0x4D78 },
	{ 0x6A38, 0x2A52A },
	{ 0x6A39, 0x2A522 },
	{ 0x6A3A, 0x2A571 },
	{ 0x6A3B, 0x2A5CD },
	{ 0x6A3C, 0x4D9D },
	{ 0x6A3D, 0x4D9C },
	{ 0x6A3E, 0x2A60F },
	{ 0x6A3F, 0x2A618 },
	{ 0x6A40, 0x2046A },
	{ 0x6A41, 0x34A9 },
	{ 0x6A42, 0x34BF },
	{ 0x6A43, 0x56D0 },
	{ 0x6A44, 0x56CF },
	{ 0x6A45, 0x21B0C },
	{ 0x6A46, 0x5DDA },
	{ 0x6A47, 0x225A6 },
	{ 0x6A48, 0x3A77 },
	{ 0x6A49, 0x3A76 },
	{ 0x6A4A, 0x23037 },
	{ 0x6A4B, 0x3ABB },
	{ 0x6A4C, 0x66EA },
	{ 0x6A4D, 0x23AE2 },
	{ 0x6A4E, 0x3D9B },
	{ 0x6A4F, 0x244BC },
	{ 0x6A50, 0x3E0F },
	{ 0x6A51, 0x3E5B },
	{ 0x6A52, 0x24AD5 },
	{ 0x6A53, 0x3F4C },
	{ 0x6A54, 0x3F6F },
	{ 0x6A55, 0x3FD9 },
	{ 0x6A56, 0x24F12 },
	{ 0x6A57, 0x4082 },
	{ 0x6A58, 0x2534B },
	{ 0x6A59, 0x25341 },
	{ 0x6A5A, 0x253A1 },
	{ 0x6A5B, 0x255EC },
	{ 0x6A5C, 0x4274 },
	{ 0x6A5D, 0x4272 },
	{ 0x6A5E, 0x25DD4 },
	{ 0x6A5F, 0x25DD8 },
	{ 0x6A60, 0x25DD9 },
	{ 0x6A61, 0x4273 },
	{ 0x6A62, 0x25DDA },
	{ 0x6A63, 0x25F6C },
	{ 0x6A64, 0x25F6D },
	{ 0x6A65, 0x42B1 },
	{ 0x6A66, 0x432E },
	{ 0x6A67, 0x261E7 },
	{ 0x6A68, 0x261EB },
	{ 0x6A69, 0x261EC },
	{ 0x6A6A, 0x26262 },
	{ 0x6A6B, 0x434E },
	{ 0x6A6C, 0x2652B },
	{ 0x6A6D, 0x2660D },
	{ 0x6A6E, 0x268CD },
	{ 0x6A6F, 0x26AC3 },
	{ 0x6A70, 0x2713F },
	{ 0x6A71, 0x2713C },
	{ 0x6A72, 0x2713E },
	{ 0x6A73, 0x2713D },
	{ 0x6A74, 0x2713A },
	{ 0x6A75, 0x27138 },
	{ 0x6A76, 0x27544 },
	{ 0x6A77, 0x27545 },
	{ 0x6A78, 0x460B },
	{ 0x6A79, 0x27548 },
	{ 0x6A7A, 0x27550 },
	{ 0x6A7B, 0x466C },
	{ 0x6A7C, 0x8B89 },
	{ 0x6A7D, 0x27B78 },
	{ 0x6A7E, 0x27B79 },
	{ 0x6B21, 0x478B },
	{ 0x6B22, 0x27E3E },
	{ 0x6B23, 0x47D0 },
	{ 0x6B24, 0x482D },
	{ 0x6B25, 0x28654 },
	{ 0x6B26, 0x48E4 },
	{ 0x6B27, 0x4971 },
	{ 0x6B28, 0x28BB9 },
	{ 0x6B29, 0x9458 },
	{ 0x6B2A, 0x496F },
	{ 0x6B2B, 0x2905F },
	{ 0x6B2C, 0x4A87 },
	{ 0x6B2D, 0x4AA5 },
	{ 0x6B2E, 0x29572 },
	{ 0x6B2F, 0x29575 },
	{ 0x6B30, 0x4B1E },
	{ 0x6B31, 0x4B65 },
	{ 0x6B32, 0x4BB9 },
	{ 0x6B33, 0x4BB7 },
	{ 0x6B34, 0x4BB8 },
	{ 0x6B35, 0x4BE4 },
	{ 0x6B36, 0x29AA3 },
	{ 0x6B37, 0x29AA5 },
	{ 0x6B38, 0x29BDC },
	{ 0x6B39, 0x29BDD },
	{ 0x6B3A, 0x29C5A },
	{ 0x6B3B, 0x4C8C },
	{ 0x6B3C, 0x4C89 },
	{ 0x6B3D, 0x4C8A },
	{ 0x6B3E, 0x29EDB },
	{ 0x6B3F, 0x29EDC },
	{ 0x6B40, 0x4C8B },
	{ 0x6B41, 0x2A1AB },
	{ 0x6B42, 0x2A184 },
	{ 0x6B43, 0x2A176 },
	{ 0x6B44, 0x4D01 },
	{ 0x6B45, 0x4CFE },
	{ 0x6B46, 0x9DE7 },
	{ 0x6B47, 0x4D03 },
	{ 0x6B48, 0x4D06 },
	{ 0x6B49, 0x2A183 },
	{ 0x6B4A, 0x9DEA },
	{ 0x6B4B, 0x9DF1 },
	{ 0x6B4C, 0x2A27F },
	{ 0x6B4D, 0x4D1D },
	{ 0x6B4E, 0x4D43 },
	{ 0x6B4F, 0x2A373 },
	{ 0x6B50, 0x2A3AD },
	{ 0x6B51, 0x2A3B0 },
	{ 0x6B52, 0x4D4F },
	{ 0x6B53, 0x2A40F },
	{ 0x6B54, 0x2A40C },
	{ 0x6B55, 0x4D5B },
	{ 0x6B56, 0x4D70 },
	{ 0x6B57, 0x2A579 },
	{ 0x6B58, 0x4D88 },
	{ 0x6B59, 0x2A577 },
	{ 0x6B5A, 0x2A57A },
	{ 0x6B5B, 0x4D89 },
	{ 0x6B5C, 0x9F44 },
	{ 0x6B5D, 0x2A632 },
	{ 0x6B5E, 0x2A627 },
	{ 0x6B5F, 0x2A62A },
	{ 0x6B60, 0x2A62C },
	{ 0x6B61, 0x9F6D },
	{ 0x6B62, 0x2A628 },
	{ 0x6B63, 0x2A629 },
	{ 0x6B64, 0x2A638 },
	{ 0x6B65, 0x2082F },
	{ 0x6B66, 0x2117B },
	{ 0x6B67, 0x21B0D },
	{ 0x6B68, 0x5DD9 },
	{ 0x6B69, 0x21FD6 },
	{ 0x6B6A, 0x21FD5 },
	{ 0x6B6B, 0x22EA1 },
	{ 0x6B6C, 0x2384C },
	{ 0x6B6D, 0x3D9E },
	{ 0x6B6E, 0x3D9F },
	{ 0x6B6F, 0x3EA7 },
	{ 0x6B70, 0x3F4B },
	{ 0x6B71, 0x3FDB },
	{ 0x6B72, 0x3FDA },
	{ 0x6B73, 0x24FC0 },
	{ 0x6B74, 0x77D6 },
	{ 0x6B75, 0x408E },
	{ 0x6B76, 0x4276 },
	{ 0x6B77, 0x25DF4 },
	{ 0x6B78, 0x4330 },
	{ 0x6B79, 0x432F },
	{ 0x6B7A, 0x261F0 },
	{ 0x6B7B, 0x4366 },
	{ 0x6B7C, 0x2633F },
	{ 0x6B7D, 0x457E },
	{ 0x6B7E, 0x2755D },
	{ 0x6C21, 0x27572 },
	{ 0x6C22, 0x27562 },
	{ 0x6C23, 0x883A },
	{ 0x6C24, 0x27566 },
	{ 0x6C25, 0x8975 },
	{ 0x6C26, 0x466F },
	{ 0x6C27, 0x27B88 },
	{ 0x6C28, 0x47D1 },
	{ 0x6C29, 0x482F },
	{ 0x6C2A, 0x281E8 },
	{ 0x6C2B, 0x281E4 },
	{ 0x6C2C, 0x48B2 },
	{ 0x6C2D, 0x4918 },
	{ 0x6C2E, 0x4917 },
	{ 0x6C2F, 0x288FF },
	{ 0x6C30, 0x4976 },
	{ 0x6C31, 0x291AF },
	{ 0x6C32, 0x291AE },
	{ 0x6C33, 0x4A4F },
	{ 0x6C34, 0x4A89 },
	{ 0x6C35, 0x293F2 },
	{ 0x6C36, 0x29448 },
	{ 0x6C37, 0x29581 },
	{ 0x6C38, 0x2957E },
	{ 0x6C39, 0x4AF5 },
	{ 0x6C3A, 0x4B1F },
	{ 0x6C3B, 0x29652 },
	{ 0x6C3C, 0x297EF },
	{ 0x6C3D, 0x9A5D },
	{ 0x6C3E, 0x4BE5 },
	{ 0x6C3F, 0x29AAD },
	{ 0x6C40, 0x29BE6 },
	{ 0x6C41, 0x4C10 },
	{ 0x6C42, 0x29BED },
	{ 0x6C43, 0x4C0F },
	{ 0x6C44, 0x29BE9 },
	{ 0x6C45, 0x29C61 },
	{ 0x6C46, 0x29C60 },
	{ 0x6C47, 0x29D33 },
	{ 0x6C48, 0x4C2F },
	{ 0x6C49, 0x4C30 },
	{ 0x6C4A, 0x9C64 },
	{ 0x6C4B, 0x29F0B },
	{ 0x6C4C, 0x29F08 },
	{ 0x6C4D, 0x4C93 },
	{ 0x6C4E, 0x4C94 },
	{ 0x6C4F, 0x29F07 },
	{ 0x6C50, 0x4D07 },
	{ 0x6C51, 0x4D09 },
	{ 0x6C52, 0x4D08 },
	{ 0x6C53, 0x2A1CA },
	{ 0x6C54, 0x4D0B },
	{ 0x6C55, 0x2A1C6 },
	{ 0x6C56, 0x9E0A },
	{ 0x6C57, 0x2A284 },
	{ 0x6C58, 0x2A2EB },
	{ 0x6C59, 0x2A37D },
	{ 0x6C5A, 0x4D50 },
	{ 0x6C5B, 0x4D71 },
	{ 0x6C5C, 0x2A49B },
	{ 0x6C5D, 0x2A4A2 },
	{ 0x6C5E, 0x2A4A1 },
	{ 0x6C5F, 0x2A4A0 },
	{ 0x6C60, 0x2A49C },
	{ 0x6C61, 0x4D7B },
	{ 0x6C62, 0x4D7C },
	{ 0x6C63, 0x2A580 },
	{ 0x6C64, 0x9F73 },
	{ 0x6C65, 0x2A640 },
	{ 0x6C66, 0x4DA1 },
	{ 0x6C67, 0x2A639 },
	{ 0x6C68, 0x2A63C },
	{ 0x6C69, 0x4DA0 },
	{ 0x6C6A, 0x4DA2 },
	{ 0x6C6B, 0x208CA },
	{ 0x6C6C, 0x361B },
	{ 0x6C6D, 0x21189 },
	{ 0x6C6E, 0x3682 },
	{ 0x6C6F, 0x2303C },
	{ 0x6C70, 0x23940 },
	{ 0x6C71, 0x24163 },
	{ 0x6C72, 0x24169 },
	{ 0x6C73, 0x3FE9 },
	{ 0x6C74, 0x25353 },
	{ 0x6C75, 0x4084 },
	{ 0x6C76, 0x77E1 },
	{ 0x6C77, 0x25917 },
	{ 0x6C78, 0x2591A },
	{ 0x6C79, 0x25E00 },
	{ 0x6C7A, 0x42B3 },
	{ 0x6C7B, 0x4334 },
	{ 0x6C7C, 0x4333 },
	{ 0x6C7D, 0x4580 },
	{ 0x6C7E, 0x2756F },
	{ 0x6D21, 0x278AB },
	{ 0x6D22, 0x46AD },
	{ 0x6D23, 0x27B91 },
	{ 0x6D24, 0x4744 },
	{ 0x6D25, 0x4755 },
	{ 0x6D26, 0x27FB1 },
	{ 0x6D27, 0x47D2 },
	{ 0x6D28, 0x281EF },
	{ 0x6D29, 0x28DF1 },
	{ 0x6D2A, 0x28DF2 },
	{ 0x6D2B, 0x291B7 },
	{ 0x6D2C, 0x291B5 },
	{ 0x6D2D, 0x4A8A },
	{ 0x6D2E, 0x29586 },
	{ 0x6D2F, 0x2965A },
	{ 0x6D30, 0x4B67 },
	{ 0x6D31, 0x299C6 },
	{ 0x6D32, 0x299CB },
	{ 0x6D33, 0x4BE6 },
	{ 0x6D34, 0x29AB2 },
	{ 0x6D35, 0x4C13 },
	{ 0x6D36, 0x29BF3 },
	{ 0x6D37, 0x9B2D },
	{ 0x6D38, 0x29F27 },
	{ 0x6D39, 0x4C97 },
	{ 0x6D3A, 0x9E0C },
	{ 0x6D3B, 0x2A1D5 },
	{ 0x6D3C, 0x2A1D8 },
	{ 0x6D3D, 0x4D0C },
	{ 0x6D3E, 0x2A1EC },
	{ 0x6D3F, 0x2A287 },
	{ 0x6D40, 0x2A2F2 },
	{ 0x6D41, 0x4D46 },
	{ 0x6D42, 0x4D5C },
	{ 0x6D43, 0x4D74 },
	{ 0x6D44, 0x4D72 },
	{ 0x6D45, 0x2A4AD },
	{ 0x6D46, 0x2A4B0 },
	{ 0x6D47, 0x2A4FD },
	{ 0x6D48, 0x9F1F },
	{ 0x6D49, 0x2A587 },
	{ 0x6D4A, 0x2A64A },
	{ 0x6D4B, 0x4DA4 },
	{ 0x6D4C, 0x4DA3 },
	{ 0x6D4D, 0x2A64E },
	{ 0x6D4E, 0x2A649 },
	{ 0x6D4F, 0x2A651 },
	{ 0x6D50, 0x2A64D },
	{ 0x6D51, 0x4DB4 },
	{ 0x6D52, 0x20472 },
	{ 0x6D53, 0x3536 },
	{ 0x6D54, 0x21B16 },
	{ 0x6D55, 0x2386D },
	{ 0x6D56, 0x23941 },
	{ 0x6D57, 0x3CB2 },
	{ 0x6D58, 0x24171 },
	{ 0x6D59, 0x24174 },
	{ 0x6D5A, 0x3F16 },
	{ 0x6D5B, 0x7C70 },
	{ 0x6D5C, 0x4277 },
	{ 0x6D5D, 0x25F7C },
	{ 0x6D5E, 0x457F },
	{ 0x6D5F, 0x2718A },
	{ 0x6D60, 0x27956 },
	{ 0x6D61, 0x487D },
	{ 0x6D62, 0x9479 },
	{ 0x6D63, 0x28BFA },
	{ 0x6D64, 0x974A },
	{ 0x6D65, 0x4A8C },
	{ 0x6D66, 0x2965B },
	{ 0x6D67, 0x4B68 },
	{ 0x6D68, 0x4BBE },
	{ 0x6D69, 0x4C15 },
	{ 0x6D6A, 0x2A1F5 },
	{ 0x6D6B, 0x2A1F0 },
	{ 0x6D6C, 0x2A2F3 },
	{ 0x6D6D, 0x2A37F },
	{ 0x6D6E, 0x2A413 },
	{ 0x6D6F, 0x4D75 },
	{ 0x6D70, 0x4DA5 },
	{ 0x6D71, 0x21B19 },
	{ 0x6D72, 0x22985 },
	{ 0x6D73, 0x22EB0 },
	{ 0x6D74, 0x24177 },
	{ 0x6D75, 0x255FF },
	{ 0x6D76, 0x4278 },
	{ 0x6D77, 0x4335 },
	{ 0x6D78, 0x7E9D },
	{ 0x6D79, 0x4582 },
	{ 0x6D7A, 0x27187 },
	{ 0x6D7B, 0x4583 },
	{ 0x6D7C, 0x2718B },
	{ 0x6D7D, 0x4671 },
	{ 0x6D7E, 0x27B9E },
	{ 0x6E21, 0x487E },
	{ 0x6E22, 0x4A8E },
	{ 0x6E23, 0x2958F },
	{ 0x6E24, 0x9960 },
	{ 0x6E25, 0x4B69 },
	{ 0x6E26, 0x29839 },
	{ 0x6E27, 0x299D4 },
	{ 0x6E28, 0x29AF1 },
	{ 0x6E29, 0x29C02 },
	{ 0x6E2A, 0x29C6B },
	{ 0x6E2B, 0x29D40 },
	{ 0x6E2C, 0x4C9A },
	{ 0x6E2D, 0x4C9B },
	{ 0x6E2E, 0x2A210 },
	{ 0x6E2F, 0x2A4BE },
	{ 0x6E30, 0x2A4B9 },
	{ 0x6E31, 0x4D90 },
	{ 0x6E32, 0x2A664 },
	{ 0x6E33, 0x9F9E },
	{ 0x6E34, 0x24AE9 },
	{ 0x6E35, 0x27190 },
	{ 0x6E36, 0x4586 },
	{ 0x6E37, 0x4585 },
	{ 0x6E38, 0x2721C },
	{ 0x6E39, 0x460E },
	{ 0x6E3A, 0x27592 },
	{ 0x6E3B, 0x278AE },
	{ 0x6E3C, 0x27BA3 },
	{ 0x6E3D, 0x4919 },
	{ 0x6E3E, 0x291C9 },
	{ 0x6E3F, 0x4BC0 },
	{ 0x6E40, 0x299D8 },
	{ 0x6E41, 0x29D44 },
	{ 0x6E42, 0x2A224 },
	{ 0x6E43, 0x9EF8 },
	{ 0x6E44, 0x9F3A },
	{ 0x6E45, 0x9F7D },
	{ 0x6E46, 0x2A670 },
	{ 0x6E47, 0x2A6D3 },
	{ 0x6E48, 0x400D },
	{ 0x6E49, 0x4C16 },
	{ 0x6E4A, 0x2A4C3 },
	{ 0x6E4B, 0x4DA9 },
	{ 0x6E4C, 0x4DAA },
	{ 0x6E4D, 0x4085 },
	{ 0x6E4E, 0x25E21 },
	{ 0x6E4F, 0x26ACA },
	{ 0x6E50, 0x2759C },
	{ 0x6E51, 0x29C73 },
	{ 0x6E52, 0x2A386 },
	{ 0x6E53, 0x2A5C1 },
	{ 0x6E54, 0x29C09 },
	{ 0x6E55, 0x9F96 },
	{ 0x6E56, 0x2A6D5 },
	{ 0x6E57, 0x4BC2 },
	{ 0x6E58, 0x4C31 },
	{ 0x6E59, 0x4D11 },
	{ 0x6E5A, 0x4DAB },
	{ 0x6E5B, 0x4C9C },
	{ 0x6E5C, 0x291D4 }
};
/* CNS 11643 plane #5 */
cns_utf cns5_utf_tab[MAX_CNS5_NUM] = {
	{ 0x2121, 0x200D1 },
	{ 0x2122, 0x200CB },
	{ 0x2123, 0x200C9 },
	{ 0x2124, 0x2010C },
	{ 0x2125, 0x20000 },
	{ 0x2126, 0x20087 },
	{ 0x2127, 0x2010D },
	{ 0x2128, 0x2010F },
	{ 0x2129, 0x2F81D },
	{ 0x212A, 0x22398 },
	{ 0x212B, 0x200D2 },
	{ 0x212C, 0x20111 },
	{ 0x212D, 0x2007E },
	{ 0x212E, 0x20AD3 },
	{ 0x212F, 0x21552 },
	{ 0x2130, 0x21CFE },
	{ 0x2131, 0x225A9 },
	{ 0x2132, 0x23942 },
	{ 0x2133, 0x20009 },
	{ 0x2134, 0x200D6 },
	{ 0x2135, 0x204DD },
	{ 0x2136, 0x204DC },
	{ 0x2137, 0x20502 },
	{ 0x2138, 0x20573 },
	{ 0x2139, 0x20676 },
	{ 0x213A, 0x206A7 },
	{ 0x213B, 0x206A8 },
	{ 0x213C, 0x20833 },
	{ 0x213D, 0x208CC },
	{ 0x213E, 0x20A0D },
	{ 0x213F, 0x20A2C },
	{ 0x2140, 0x20B1B },
	{ 0x2141, 0x355A },
	{ 0x2142, 0x20B1D },
	{ 0x2143, 0x20B99 },
	{ 0x2144, 0x2123E },
	{ 0x2145, 0x21D2D },
	{ 0x2146, 0x21D2F },
	{ 0x2147, 0x22399 },
	{ 0x2148, 0x233B3 },
	{ 0x2149, 0x239B6 },
	{ 0x214A, 0x23B1B },
	{ 0x214B, 0x244EF },
	{ 0x214C, 0x248E9 },
	{ 0x214D, 0x20014 },
	{ 0x214E, 0x20094 },
	{ 0x214F, 0x200E1 },
	{ 0x2150, 0x20506 },
	{ 0x2151, 0x2054A },
	{ 0x2152, 0x20544 },
	{ 0x2153, 0x20631 },
	{ 0x2154, 0x2067A },
	{ 0x2155, 0x206AD },
	{ 0x2156, 0x206AE },
	{ 0x2157, 0x206B1 },
	{ 0x2158, 0x20838 },
	{ 0x2159, 0x20837 },
	{ 0x215A, 0x2097D },
	{ 0x215B, 0x2097E },
	{ 0x215C, 0x20A2D },
	{ 0x215D, 0x20A32 },
	{ 0x215E, 0x20B23 },
	{ 0x215F, 0x20B26 },
	{ 0x2160, 0x2F83A },
	{ 0x2161, 0x20BA0 },
	{ 0x2162, 0x216A8 },
	{ 0x2163, 0x2193F },
	{ 0x2164, 0x219BC },
	{ 0x2165, 0x21BC4 },
	{ 0x2166, 0x21D3B },
	{ 0x2167, 0x22019 },
	{ 0x2168, 0x22018 },
	{ 0x2169, 0x221B3 },
	{ 0x216A, 0x223AA },
	{ 0x216B, 0x224BE },
	{ 0x216C, 0x225AC },
	{ 0x216D, 0x22A25 },
	{ 0x216E, 0x22A66 },
	{ 0x216F, 0x22A6B },
	{ 0x2170, 0x23943 },
	{ 0x2171, 0x239B5 },
	{ 0x2172, 0x23AEC },
	{ 0x2173, 0x23C76 },
	{ 0x2174, 0x3CBC },
	{ 0x2175, 0x24614 },
	{ 0x2176, 0x215DC },
	{ 0x2177, 0x2471C },
	{ 0x2178, 0x2471D },
	{ 0x2179, 0x264D0 },
	{ 0x217A, 0x26612 },
	{ 0x217B, 0x26AF3 },
	{ 0x217C, 0x28669 },
	{ 0x217D, 0x49B9 },
	{ 0x217E, 0x28E11 },
	{ 0x2221, 0x28E15 },
	{ 0x2222, 0x28E10 },
	{ 0x2223, 0x28E13 },
	{ 0x2224, 0x200A4 },
	{ 0x2225, 0x200A5 },
	{ 0x2226, 0x201D0 },
	{ 0x2227, 0x201BA },
	{ 0x2228, 0x201CB },
	{ 0x2229, 0x2057B },
	{ 0x222A, 0x20686 },
	{ 0x222B, 0x206BB },
	{ 0x222C, 0x206BA },
	{ 0x222D, 0x206C3 },
	{ 0x222E, 0x206B9 },
	{ 0x222F, 0x206C0 },
	{ 0x2230, 0x34DE },
	{ 0x2231, 0x20839 },
	{ 0x2232, 0x2083B },
	{ 0x2233, 0x20841 },
	{ 0x2234, 0x208D1 },
	{ 0x2235, 0x208CF },
	{ 0x2236, 0x208D2 },
	{ 0x2237, 0x2092E },
	{ 0x2238, 0x2096E },
	{ 0x2239, 0x2098C },
	{ 0x223A, 0x20988 },
	{ 0x223B, 0x20A35 },
	{ 0x223C, 0x3543 },
	{ 0x223D, 0x20A3A },
	{ 0x223E, 0x20A3B },
	{ 0x223F, 0x20A38 },
	{ 0x2240, 0x20A39 },
	{ 0x2241, 0x20B2E },
	{ 0x2242, 0x20B2C },
	{ 0x2243, 0x20BC8 },
	{ 0x2244, 0x20BB5 },
	{ 0x2245, 0x20BAD },
	{ 0x2246, 0x20BB0 },
	{ 0x2247, 0x20BAB },
	{ 0x2248, 0x211B3 },
	{ 0x2249, 0x211A9 },
	{ 0x224A, 0x216BB },
	{ 0x224B, 0x216B9 },
	{ 0x224C, 0x21B5A },
	{ 0x224D, 0x21BCD },
	{ 0x224E, 0x21C2B },
	{ 0x224F, 0x21D05 },
	{ 0x2250, 0x37AC },
	{ 0x2251, 0x37AA },
	{ 0x2252, 0x21D51 },
	{ 0x2253, 0x21D4B },
	{ 0x2254, 0x21FEA },
	{ 0x2255, 0x21FED },
	{ 0x2256, 0x22036 },
	{ 0x2257, 0x22062 },
	{ 0x2258, 0x22056 },
	{ 0x2259, 0x22055 },
	{ 0x225A, 0x22064 },
	{ 0x225B, 0x22058 },
	{ 0x225C, 0x5E07 },
	{ 0x225D, 0x221DA },
	{ 0x225E, 0x221D8 },
	{ 0x225F, 0x223AD },
	{ 0x2260, 0x223AB },
	{ 0x2261, 0x224C0 },
	{ 0x2262, 0x224C3 },
	{ 0x2263, 0x225B3 },
	{ 0x2264, 0x225B7 },
	{ 0x2265, 0x225BA },
	{ 0x2266, 0x5FCB },
	{ 0x2267, 0x38FE },
	{ 0x2268, 0x225C7 },
	{ 0x2269, 0x225B5 },
	{ 0x226A, 0x2298E },
	{ 0x226B, 0x22A73 },
	{ 0x226C, 0x22A6C },
	{ 0x226D, 0x22A74 },
	{ 0x226E, 0x2F8B4 },
	{ 0x226F, 0x22A72 },
	{ 0x2270, 0x22A71 },
	{ 0x2271, 0x22A82 },
	{ 0x2272, 0x22A70 },
	{ 0x2273, 0x2313F },
	{ 0x2274, 0x233BA },
	{ 0x2275, 0x233B8 },
	{ 0x2276, 0x239B7 },
	{ 0x2277, 0x24723 },
	{ 0x2278, 0x24721 },
	{ 0x2279, 0x2472B },
	{ 0x227A, 0x24726 },
	{ 0x227B, 0x24722 },
	{ 0x227C, 0x24D25 },
	{ 0x227D, 0x250E4 },
	{ 0x227E, 0x25415 },
	{ 0x2321, 0x264E4 },
	{ 0x2322, 0x26633 },
	{ 0x2323, 0x2662A },
	{ 0x2324, 0x26632 },
	{ 0x2325, 0x26629 },
	{ 0x2326, 0x26AFB },
	{ 0x2327, 0x2795B },
	{ 0x2328, 0x2795C },
	{ 0x2329, 0x27C28 },
	{ 0x232A, 0x2866F },
	{ 0x232B, 0x2866D },
	{ 0x232C, 0x2866B },
	{ 0x232D, 0x2866E },
	{ 0x232E, 0x28E16 },
	{ 0x232F, 0x20022 },
	{ 0x2330, 0x20116 },
	{ 0x2331, 0x20148 },
	{ 0x2332, 0x201D8 },
	{ 0x2333, 0x20200 },
	{ 0x2334, 0x3441 },
	{ 0x2335, 0x20480 },
	{ 0x2336, 0x204E4 },
	{ 0x2337, 0x34B4 },
	{ 0x2338, 0x204E7 },
	{ 0x2339, 0x2050C },
	{ 0x233A, 0x20553 },
	{ 0x233B, 0x205B7 },
	{ 0x233C, 0x20AE8 },
	{ 0x233D, 0x206D1 },
	{ 0x233E, 0x206E5 },
	{ 0x233F, 0x206D8 },
	{ 0x2340, 0x206D6 },
	{ 0x2341, 0x206DA },
	{ 0x2342, 0x206D9 },
	{ 0x2343, 0x206D5 },
	{ 0x2344, 0x206E6 },
	{ 0x2345, 0x206D4 },
	{ 0x2346, 0x206D3 },
	{ 0x2347, 0x20844 },
	{ 0x2348, 0x208D6 },
	{ 0x2349, 0x208D7 },
	{ 0x234A, 0x20913 },
	{ 0x234C, 0x20970 },
	{ 0x234D, 0x20992 },
	{ 0x234E, 0x209DB },
	{ 0x234F, 0x209DA },
	{ 0x2350, 0x20A41 },
	{ 0x2351, 0x20A43 },
	{ 0x2352, 0x20B33 },
	{ 0x2353, 0x20BF6 },
	{ 0x2354, 0x20BD4 },
	{ 0x2355, 0x20BDD },
	{ 0x2356, 0x20BD0 },
	{ 0x2357, 0x20C04 },
	{ 0x2358, 0x20BD9 },
	{ 0x2359, 0x20BDB },
	{ 0x235A, 0x20C05 },
	{ 0x235B, 0x20BD3 },
	{ 0x235C, 0x20BE1 },
	{ 0x235D, 0x21280 },
	{ 0x235E, 0x21277 },
	{ 0x235F, 0x21281 },
	{ 0x2360, 0x21282 },
	{ 0x2361, 0x21283 },
	{ 0x2362, 0x2F85C },
	{ 0x2363, 0x21561 },
	{ 0x2364, 0x21560 },
	{ 0x2365, 0x216D8 },
	{ 0x2366, 0x216D6 },
	{ 0x2367, 0x216D7 },
	{ 0x2368, 0x24605 },
	{ 0x2369, 0x2194D },
	{ 0x236A, 0x21948 },
	{ 0x236B, 0x21BD6 },
	{ 0x236C, 0x21BCF },
	{ 0x236D, 0x21BD9 },
	{ 0x236E, 0x21BD8 },
	{ 0x236F, 0x21C3D },
	{ 0x2370, 0x37B3 },
	{ 0x2371, 0x21D54 },
	{ 0x2372, 0x21D5B },
	{ 0x2373, 0x21D5C },
	{ 0x2374, 0x37B4 },
	{ 0x2375, 0x21D59 },
	{ 0x2376, 0x21D58 },
	{ 0x2377, 0x21D5A },
	{ 0x2378, 0x21D55 },
	{ 0x2379, 0x21D56 },
	{ 0x237A, 0x21D82 },
	{ 0x237B, 0x21FF0 },
	{ 0x237C, 0x2201C },
	{ 0x237D, 0x2206A },
	{ 0x237E, 0x22069 },
	{ 0x2421, 0x22071 },
	{ 0x2422, 0x22067 },
	{ 0x2423, 0x2206C },
	{ 0x2424, 0x2206E },
	{ 0x2425, 0x22079 },
	{ 0x2426, 0x2218B },
	{ 0x2427, 0x221B8 },
	{ 0x2428, 0x221E7 },
	{ 0x2429, 0x221E8 },
	{ 0x242A, 0x221E4 },
	{ 0x242B, 0x221E6 },
	{ 0x242C, 0x221E5 },
	{ 0x242D, 0x221F0 },
	{ 0x242E, 0x22383 },
	{ 0x242F, 0x223B7 },
	{ 0x2430, 0x223BB },
	{ 0x2431, 0x223B9 },
	{ 0x2432, 0x223C5 },
	{ 0x2433, 0x22453 },
	{ 0x2434, 0x224C4 },
	{ 0x2435, 0x224C6 },
	{ 0x2436, 0x224CB },
	{ 0x2437, 0x225C8 },
	{ 0x2438, 0x2F89F },
	{ 0x2439, 0x225C9 },
	{ 0x243A, 0x225DB },
	{ 0x243B, 0x22994 },
	{ 0x243C, 0x22A95 },
	{ 0x243D, 0x22A88 },
	{ 0x243E, 0x22A8D },
	{ 0x243F, 0x22EEC },
	{ 0x2440, 0x22EEE },
	{ 0x2441, 0x22EF1 },
	{ 0x2442, 0x2312E },
	{ 0x2443, 0x23149 },
	{ 0x2444, 0x2335F },
	{ 0x2445, 0x233D1 },
	{ 0x2446, 0x233CB },
	{ 0x2447, 0x23885 },
	{ 0x2448, 0x3C1D },
	{ 0x2449, 0x2394A },
	{ 0x244A, 0x23947 },
	{ 0x244B, 0x2394B },
	{ 0x244C, 0x239BB },
	{ 0x244D, 0x239C4 },
	{ 0x244E, 0x3C7C },
	{ 0x244F, 0x23B02 },
	{ 0x2450, 0x23C82 },
	{ 0x2451, 0x23C91 },
	{ 0x2452, 0x23C8F },
	{ 0x2453, 0x23C92 },
	{ 0x2454, 0x2418F },
	{ 0x2455, 0x24191 },
	{ 0x2456, 0x241B4 },
	{ 0x2457, 0x24192 },
	{ 0x2458, 0x244F4 },
	{ 0x2459, 0x245AA },
	{ 0x245A, 0x24735 },
	{ 0x245B, 0x24737 },
	{ 0x245C, 0x2473D },
	{ 0x245D, 0x2473C },
	{ 0x245E, 0x2472F },
	{ 0x245F, 0x24730 },
	{ 0x2460, 0x248F8 },
	{ 0x2461, 0x248EF },
	{ 0x2462, 0x24B26 },
	{ 0x2463, 0x3F55 },
	{ 0x2464, 0x24D26 },
	{ 0x2465, 0x24D27 },
	{ 0x2466, 0x24F41 },
	{ 0x2467, 0x24FC6 },
	{ 0x2468, 0x24FC7 },
	{ 0x2469, 0x250EB },
	{ 0x246A, 0x250E8 },
	{ 0x246B, 0x250EA },
	{ 0x246C, 0x2541A },
	{ 0x246D, 0x25419 },
	{ 0x246E, 0x4126 },
	{ 0x246F, 0x25923 },
	{ 0x2470, 0x25924 },
	{ 0x2471, 0x25E25 },
	{ 0x2472, 0x26635 },
	{ 0x2473, 0x26634 },
	{ 0x2474, 0x26A07 },
	{ 0x2475, 0x2721D },
	{ 0x2476, 0x277E1 },
	{ 0x2477, 0x27BAB },
	{ 0x2478, 0x28460 },
	{ 0x2479, 0x28677 },
	{ 0x247A, 0x2867D },
	{ 0x247B, 0x49BC },
	{ 0x247C, 0x28E1E },
	{ 0x247D, 0x28E1A },
	{ 0x247E, 0x28E1D },
	{ 0x2521, 0x2006B },
	{ 0x2522, 0x2012D },
	{ 0x2523, 0x2014C },
	{ 0x2524, 0x2022A },
	{ 0x2525, 0x344A },
	{ 0x2526, 0x20215 },
	{ 0x2527, 0x2022C },
	{ 0x2528, 0x20206 },
	{ 0x2529, 0x20208 },
	{ 0x252A, 0x2020A },
	{ 0x252B, 0x344E },
	{ 0x252C, 0x20556 },
	{ 0x252D, 0x20584 },
	{ 0x252E, 0x34C9 },
	{ 0x252F, 0x205C6 },
	{ 0x2530, 0x206F5 },
	{ 0x2531, 0x20709 },
	{ 0x2532, 0x206F8 },
	{ 0x2533, 0x206E8 },
	{ 0x2534, 0x206FB },
	{ 0x2535, 0x206E9 },
	{ 0x2536, 0x206F6 },
	{ 0x2537, 0x52B7 },
	{ 0x2538, 0x52B8 },
	{ 0x2539, 0x20852 },
	{ 0x253A, 0x52B6 },
	{ 0x253B, 0x52BA },
	{ 0x253C, 0x20854 },
	{ 0x253D, 0x20851 },
	{ 0x253E, 0x20939 },
	{ 0x253F, 0x2093A },
	{ 0x2540, 0x20998 },
	{ 0x2541, 0x20A4E },
	{ 0x2542, 0x357B },
	{ 0x2543, 0x20C36 },
	{ 0x2544, 0x20C0C },
	{ 0x2545, 0x20C10 },
	{ 0x2546, 0x20C32 },
	{ 0x2547, 0x20C11 },
	{ 0x2548, 0x20C18 },
	{ 0x2549, 0x20C1C },
	{ 0x254A, 0x20C1A },
	{ 0x254B, 0x20C19 },
	{ 0x254C, 0x20C0B },
	{ 0x254D, 0x20C0F },
	{ 0x254E, 0x20C1D },
	{ 0x254F, 0x20C21 },
	{ 0x2550, 0x20C13 },
	{ 0x2551, 0x20C1B },
	{ 0x2552, 0x20C15 },
	{ 0x2553, 0x3620 },
	{ 0x2554, 0x211D1 },
	{ 0x2555, 0x211C8 },
	{ 0x2556, 0x2128D },
	{ 0x2557, 0x212B5 },
	{ 0x2558, 0x3689 },
	{ 0x2559, 0x3695 },
	{ 0x255A, 0x215F8 },
	{ 0x255B, 0x216E0 },
	{ 0x255C, 0x216E1 },
	{ 0x255D, 0x36BE },
	{ 0x255E, 0x216DE },
	{ 0x255F, 0x216FE },
	{ 0x2560, 0x216DC },
	{ 0x2561, 0x21701 },
	{ 0x2562, 0x216FD },
	{ 0x2563, 0x21700 },
	{ 0x2564, 0x219D7 },
	{ 0x2565, 0x219D6 },
	{ 0x2566, 0x219D9 },
	{ 0x2567, 0x21B65 },
	{ 0x2568, 0x21BD2 },
	{ 0x2569, 0x21BDC },
	{ 0x256A, 0x21BE1 },
	{ 0x256B, 0x21BDE },
	{ 0x256C, 0x21C42 },
	{ 0x256D, 0x21C4B },
	{ 0x256E, 0x37C3 },
	{ 0x256F, 0x21D8E },
	{ 0x2570, 0x21D91 },
	{ 0x2571, 0x21D8B },
	{ 0x2572, 0x21D90 },
	{ 0x2573, 0x21D88 },
	{ 0x2574, 0x21D89 },
	{ 0x2575, 0x21D84 },
	{ 0x2576, 0x21DAA },
	{ 0x2577, 0x2208D },
	{ 0x2578, 0x2208F },
	{ 0x2579, 0x2207D },
	{ 0x257A, 0x2207F },
	{ 0x257B, 0x2207B },
	{ 0x257C, 0x22080 },
	{ 0x257D, 0x2207E },
	{ 0x257E, 0x22083 },
	{ 0x2621, 0x22081 },
	{ 0x2622, 0x22086 },
	{ 0x2623, 0x2208A },
	{ 0x2624, 0x221BD },
	{ 0x2625, 0x221BE },
	{ 0x2626, 0x3877 },
	{ 0x2627, 0x221F4 },
	{ 0x2628, 0x221F3 },
	{ 0x2629, 0x22202 },
	{ 0x262A, 0x221F6 },
	{ 0x262B, 0x221F5 },
	{ 0x262C, 0x221F2 },
	{ 0x262D, 0x22204 },
	{ 0x262E, 0x2233D },
	{ 0x262F, 0x223C6 },
	{ 0x2630, 0x22489 },
	{ 0x2631, 0x224D4 },
	{ 0x2632, 0x224D6 },
	{ 0x2633, 0x224D2 },
	{ 0x2634, 0x225FA },
	{ 0x2635, 0x22606 },
	{ 0x2636, 0x2260C },
	{ 0x2637, 0x2260A },
	{ 0x2638, 0x2260F },
	{ 0x2639, 0x22A2F },
	{ 0x263A, 0x39D4 },
	{ 0x263B, 0x22AB7 },
	{ 0x263C, 0x22ABE },
	{ 0x263D, 0x22ABC },
	{ 0x263E, 0x22AE2 },
	{ 0x263F, 0x22F06 },
	{ 0x2640, 0x22EF7 },
	{ 0x2641, 0x22F07 },
	{ 0x2642, 0x22EF6 },
	{ 0x2643, 0x23B35 },
	{ 0x2644, 0x2315F },
	{ 0x2645, 0x23165 },
	{ 0x2646, 0x23164 },
	{ 0x2647, 0x23161 },
	{ 0x2648, 0x2315A },
	{ 0x2649, 0x2315D },
	{ 0x264A, 0x2F8D7 },
	{ 0x264B, 0x233D7 },
	{ 0x264C, 0x233D5 },
	{ 0x264D, 0x233DE },
	{ 0x264E, 0x233E1 },
	{ 0x264F, 0x233E0 },
	{ 0x2650, 0x233D9 },
	{ 0x2651, 0x3B4C },
	{ 0x2652, 0x233DA },
	{ 0x2653, 0x233DF },
	{ 0x2654, 0x233F6 },
	{ 0x2655, 0x23403 },
	{ 0x2656, 0x3C20 },
	{ 0x2657, 0x23893 },
	{ 0x2658, 0x2388B },
	{ 0x2659, 0x23891 },
	{ 0x265A, 0x23892 },
	{ 0x265B, 0x2388A },
	{ 0x265C, 0x23889 },
	{ 0x265D, 0x2388F },
	{ 0x265E, 0x23956 },
	{ 0x265F, 0x23959 },
	{ 0x2660, 0x239CA },
	{ 0x2661, 0x239CC },
	{ 0x2662, 0x3C5B },
	{ 0x2663, 0x239D0 },
	{ 0x2664, 0x239CD },
	{ 0x2665, 0x239D6 },
	{ 0x2666, 0x239CB },
	{ 0x2667, 0x23A83 },
	{ 0x2668, 0x23A82 },
	{ 0x2669, 0x23B06 },
	{ 0x266A, 0x23B2A },
	{ 0x266B, 0x23B2C },
	{ 0x266C, 0x23B2B },
	{ 0x266D, 0x23B29 },
	{ 0x266E, 0x23CBD },
	{ 0x266F, 0x23CB3 },
	{ 0x2670, 0x23CBE },
	{ 0x2671, 0x23CC0 },
	{ 0x2672, 0x23CB5 },
	{ 0x2673, 0x23CB6 },
	{ 0x2674, 0x2419D },
	{ 0x2675, 0x2419F },
	{ 0x2676, 0x24620 },
	{ 0x2677, 0x3E2D },
	{ 0x2678, 0x2461E },
	{ 0x2679, 0x2461C },
	{ 0x267A, 0x24632 },
	{ 0x267B, 0x2461F },
	{ 0x267C, 0x2462B },
	{ 0x267D, 0x24621 },
	{ 0x267E, 0x24626 },
	{ 0x2721, 0x24624 },
	{ 0x2722, 0x2461D },
	{ 0x2723, 0x24627 },
	{ 0x2724, 0x2475B },
	{ 0x2725, 0x24759 },
	{ 0x2726, 0x24780 },
	{ 0x2727, 0x24755 },
	{ 0x2728, 0x24750 },
	{ 0x2729, 0x2475A },
	{ 0x272A, 0x24756 },
	{ 0x272B, 0x24763 },
	{ 0x272C, 0x24752 },
	{ 0x272D, 0x24758 },
	{ 0x272E, 0x3E63 },
	{ 0x272F, 0x24739 },
	{ 0x2730, 0x248F9 },
	{ 0x2731, 0x24B28 },
	{ 0x2732, 0x3F18 },
	{ 0x2733, 0x24BBC },
	{ 0x2734, 0x24BD6 },
	{ 0x2735, 0x24C05 },
	{ 0x2736, 0x24C20 },
	{ 0x2737, 0x3F74 },
	{ 0x2738, 0x24D33 },
	{ 0x2739, 0x24F46 },
	{ 0x273A, 0x24F42 },
	{ 0x273B, 0x24F43 },
	{ 0x273C, 0x24F47 },
	{ 0x273D, 0x24FCB },
	{ 0x273E, 0x25042 },
	{ 0x273F, 0x25045 },
	{ 0x2740, 0x250FD },
	{ 0x2741, 0x250F4 },
	{ 0x2742, 0x250F9 },
	{ 0x2743, 0x250FA },
	{ 0x2744, 0x2535E },
	{ 0x2745, 0x2541D },
	{ 0x2746, 0x4128 },
	{ 0x2747, 0x25758 },
	{ 0x2748, 0x25755 },
	{ 0x2749, 0x25A57 },
	{ 0x274A, 0x25A58 },
	{ 0x274B, 0x25AD9 },
	{ 0x274C, 0x25ADC },
	{ 0x274D, 0x25ADB },
	{ 0x274E, 0x25E27 },
	{ 0x274F, 0x25F85 },
	{ 0x2750, 0x25F87 },
	{ 0x2751, 0x25F8A },
	{ 0x2752, 0x2628B },
	{ 0x2753, 0x2634F },
	{ 0x2754, 0x26530 },
	{ 0x2755, 0x2652F },
	{ 0x2756, 0x26668 },
	{ 0x2757, 0x26649 },
	{ 0x2758, 0x43DA },
	{ 0x2759, 0x26648 },
	{ 0x275A, 0x2663F },
	{ 0x275B, 0x2664B },
	{ 0x275C, 0x2665C },
	{ 0x275D, 0x26646 },
	{ 0x275E, 0x26640 },
	{ 0x275F, 0x26A0D },
	{ 0x2760, 0x26B1B },
	{ 0x2761, 0x26B1D },
	{ 0x2762, 0x26B17 },
	{ 0x2763, 0x44A4 },
	{ 0x2764, 0x26B22 },
	{ 0x2765, 0x275A7 },
	{ 0x2766, 0x27608 },
	{ 0x2767, 0x27806 },
	{ 0x2768, 0x2847D },
	{ 0x2769, 0x488E },
	{ 0x276A, 0x28463 },
	{ 0x276B, 0x28464 },
	{ 0x276C, 0x2847F },
	{ 0x276D, 0x2846B },
	{ 0x276E, 0x2847C },
	{ 0x276F, 0x28468 },
	{ 0x2770, 0x28465 },
	{ 0x2771, 0x2846A },
	{ 0x2772, 0x28698 },
	{ 0x2773, 0x28699 },
	{ 0x2774, 0x286AE },
	{ 0x2775, 0x28E2B },
	{ 0x2776, 0x28E2D },
	{ 0x2777, 0x28E31 },
	{ 0x2778, 0x28E2E },
	{ 0x2779, 0x28E2F },
	{ 0x277A, 0x2006D },
	{ 0x277B, 0x20131 },
	{ 0x277C, 0x2022D },
	{ 0x277D, 0x20239 },
	{ 0x277E, 0x20238 },
	{ 0x2821, 0x345B },
	{ 0x2822, 0x2023A },
	{ 0x2823, 0x20235 },
	{ 0x2824, 0x20262 },
	{ 0x2825, 0x204EA },
	{ 0x2826, 0x204EB },
	{ 0x2827, 0x20515 },
	{ 0x2828, 0x205CC },
	{ 0x2829, 0x205C8 },
	{ 0x282A, 0x205CD },
	{ 0x282B, 0x205DB },
	{ 0x282C, 0x205CB },
	{ 0x282D, 0x20711 },
	{ 0x282E, 0x20726 },
	{ 0x282F, 0x20862 },
	{ 0x2830, 0x2085E },
	{ 0x2831, 0x20861 },
	{ 0x2832, 0x20941 },
	{ 0x2833, 0x2093F },
	{ 0x2834, 0x20975 },
	{ 0x2835, 0x23965 },
	{ 0x2836, 0x20B49 },
	{ 0x2837, 0x209EB },
	{ 0x2838, 0x20A1A },
	{ 0x2839, 0x20A57 },
	{ 0x283A, 0x20C6B },
	{ 0x283B, 0x20CA9 },
	{ 0x283C, 0x20C54 },
	{ 0x283D, 0x20C62 },
	{ 0x283E, 0x20CAA },
	{ 0x283F, 0x20C58 },
	{ 0x2840, 0x20C72 },
	{ 0x2841, 0x20C63 },
	{ 0x2842, 0x20C73 },
	{ 0x2843, 0x20C8B },
	{ 0x2844, 0x20C8C },
	{ 0x2845, 0x20C5C },
	{ 0x2846, 0x20C51 },
	{ 0x2847, 0x20C16 },
	{ 0x2848, 0x20C60 },
	{ 0x2849, 0x20C61 },
	{ 0x284A, 0x20C5E },
	{ 0x284B, 0x20C5D },
	{ 0x284C, 0x20C64 },
	{ 0x284D, 0x20C53 },
	{ 0x284E, 0x20C5F },
	{ 0x284F, 0x20C5B },
	{ 0x2850, 0x20C6E },
	{ 0x2851, 0x20C55 },
	{ 0x2852, 0x20C52 },
	{ 0x2853, 0x20C68 },
	{ 0x2854, 0x211D2 },
	{ 0x2855, 0x211D6 },
	{ 0x2856, 0x211D3 },
	{ 0x2857, 0x212B8 },
	{ 0x2858, 0x212BB },
	{ 0x2859, 0x212EB },
	{ 0x285A, 0x212E8 },
	{ 0x285B, 0x212B6 },
	{ 0x285C, 0x212EA },
	{ 0x285D, 0x212E7 },
	{ 0x285E, 0x212E9 },
	{ 0x285F, 0x21591 },
	{ 0x2860, 0x21610 },
	{ 0x2861, 0x2160E },
	{ 0x2862, 0x2160F },
	{ 0x2863, 0x2170B },
	{ 0x2864, 0x21703 },
	{ 0x2865, 0x2172B },
	{ 0x2866, 0x21709 },
	{ 0x2867, 0x21728 },
	{ 0x2868, 0x2172C },
	{ 0x2869, 0x21725 },
	{ 0x286A, 0x21727 },
	{ 0x286B, 0x2170F },
	{ 0x286C, 0x219E9 },
	{ 0x286D, 0x219EC },
	{ 0x286E, 0x3753 },
	{ 0x286F, 0x21B27 },
	{ 0x2870, 0x21B73 },
	{ 0x2871, 0x21BE2 },
	{ 0x2872, 0x21BE6 },
	{ 0x2873, 0x2F876 },
	{ 0x2874, 0x21C61 },
	{ 0x2875, 0x21C51 },
	{ 0x2876, 0x21D12 },
	{ 0x2877, 0x21D0E },
	{ 0x2878, 0x21DAD },
	{ 0x2879, 0x21DAF },
	{ 0x287A, 0x21DB1 },
	{ 0x287B, 0x21DD3 },
	{ 0x287C, 0x22094 },
	{ 0x287D, 0x22092 },
	{ 0x287E, 0x22090 },
	{ 0x2921, 0x2209D },
	{ 0x2922, 0x22093 },
	{ 0x2923, 0x22095 },
	{ 0x2924, 0x22098 },
	{ 0x2925, 0x22097 },
	{ 0x2926, 0x3880 },
	{ 0x2927, 0x2F88A },
	{ 0x2928, 0x22207 },
	{ 0x2929, 0x2220B },
	{ 0x292A, 0x22208 },
	{ 0x292B, 0x223D9 },
	{ 0x292C, 0x223D5 },
	{ 0x292D, 0x224D7 },
	{ 0x292E, 0x224DF },
	{ 0x292F, 0x38DD },
	{ 0x2930, 0x224DE },
	{ 0x2931, 0x224E3 },
	{ 0x2932, 0x224E2 },
	{ 0x2933, 0x38DE },
	{ 0x2934, 0x22647 },
	{ 0x2935, 0x3922 },
	{ 0x2936, 0x2263D },
	{ 0x2937, 0x22638 },
	{ 0x2938, 0x22A44 },
	{ 0x2939, 0x22A3A },
	{ 0x293A, 0x22AB8 },
	{ 0x293B, 0x22B2A },
	{ 0x293C, 0x22B00 },
	{ 0x293D, 0x22AF3 },
	{ 0x293E, 0x22AF2 },
	{ 0x293F, 0x22AEB },
	{ 0x2940, 0x22AFA },
	{ 0x2941, 0x22AED },
	{ 0x2942, 0x22AEC },
	{ 0x2943, 0x22AFF },
	{ 0x2944, 0x22AFB },
	{ 0x2945, 0x6306 },
	{ 0x2946, 0x22B4E },
	{ 0x2947, 0x22AEF },
	{ 0x2948, 0x22AF7 },
	{ 0x2949, 0x22F10 },
	{ 0x294A, 0x22F11 },
	{ 0x294B, 0x22F0C },
	{ 0x294C, 0x22F0B },
	{ 0x294D, 0x230DD },
	{ 0x294E, 0x23130 },
	{ 0x294F, 0x3ADB },
	{ 0x2950, 0x2317A },
	{ 0x2951, 0x23177 },
	{ 0x2952, 0x23328 },
	{ 0x2953, 0x23327 },
	{ 0x2954, 0x23365 },
	{ 0x2955, 0x2340E },
	{ 0x2956, 0x2340B },
	{ 0x2957, 0x23441 },
	{ 0x2958, 0x23413 },
	{ 0x2959, 0x2340F },
	{ 0x295A, 0x23412 },
	{ 0x295B, 0x23430 },
	{ 0x295C, 0x238A0 },
	{ 0x295D, 0x238A3 },
	{ 0x295E, 0x2389E },
	{ 0x295F, 0x23897 },
	{ 0x2960, 0x238A1 },
	{ 0x2961, 0x2389D },
	{ 0x2962, 0x2389B },
	{ 0x2963, 0x23963 },
	{ 0x2964, 0x239E3 },
	{ 0x2965, 0x239E4 },
	{ 0x2966, 0x239E6 },
	{ 0x2967, 0x239E7 },
	{ 0x2968, 0x239DD },
	{ 0x2969, 0x6B85 },
	{ 0x296A, 0x239EC },
	{ 0x296B, 0x239E5 },
	{ 0x296C, 0x239F1 },
	{ 0x296D, 0x23B3B },
	{ 0x296E, 0x23B39 },
	{ 0x296F, 0x23B3A },
	{ 0x2970, 0x23B3C },
	{ 0x2971, 0x23B3D },
	{ 0x2972, 0x23B47 },
	{ 0x2973, 0x23B3F },
	{ 0x2974, 0x23B44 },
	{ 0x2975, 0x23C48 },
	{ 0x2976, 0x23C49 },
	{ 0x2977, 0x23C60 },
	{ 0x2978, 0x23CE3 },
	{ 0x2979, 0x23CE9 },
	{ 0x297A, 0x23CF0 },
	{ 0x297B, 0x3CDA },
	{ 0x297C, 0x3CDB },
	{ 0x297D, 0x23CF2 },
	{ 0x297E, 0x23CED },
	{ 0x2A21, 0x23CEC },
	{ 0x2A22, 0x23CE6 },
	{ 0x2A23, 0x23D16 },
	{ 0x2A24, 0x3CD7 },
	{ 0x2A25, 0x241BC },
	{ 0x2A26, 0x241BE },
	{ 0x2A27, 0x241C0 },
	{ 0x2A28, 0x241E0 },
	{ 0x2A29, 0x24500 },
	{ 0x2A2A, 0x24502 },
	{ 0x2A2B, 0x244FE },
	{ 0x2A2C, 0x2455E },
	{ 0x2A2D, 0x245B3 },
	{ 0x2A2E, 0x245B7 },
	{ 0x2A2F, 0x2463A },
	{ 0x2A30, 0x24639 },
	{ 0x2A31, 0x2463E },
	{ 0x2A32, 0x24638 },
	{ 0x2A33, 0x2463D },
	{ 0x2A34, 0x2464F },
	{ 0x2A35, 0x2476E },
	{ 0x2A36, 0x2475F },
	{ 0x2A37, 0x24781 },
	{ 0x2A38, 0x24782 },
	{ 0x2A39, 0x24771 },
	{ 0x2A3A, 0x2477B },
	{ 0x2A3B, 0x24779 },
	{ 0x2A3C, 0x24777 },
	{ 0x2A3D, 0x24773 },
	{ 0x2A3E, 0x2476F },
	{ 0x2A3F, 0x24797 },
	{ 0x2A40, 0x2477E },
	{ 0x2A41, 0x248FC },
	{ 0x2A42, 0x24911 },
	{ 0x2A43, 0x24932 },
	{ 0x2A44, 0x24931 },
	{ 0x2A45, 0x24910 },
	{ 0x2A46, 0x24AEC },
	{ 0x2A47, 0x24AEB },
	{ 0x2A48, 0x24B2C },
	{ 0x2A49, 0x24B2D },
	{ 0x2A4A, 0x24BDA },
	{ 0x2A4B, 0x24C2E },
	{ 0x2A4C, 0x24C2C },
	{ 0x2A4D, 0x24C2A },
	{ 0x2A4E, 0x24C33 },
	{ 0x2A4F, 0x24C4B },
	{ 0x2A50, 0x24D18 },
	{ 0x2A51, 0x24D42 },
	{ 0x2A52, 0x24D3B },
	{ 0x2A53, 0x24D3F },
	{ 0x2A54, 0x24D41 },
	{ 0x2A55, 0x24D43 },
	{ 0x2A56, 0x24D3C },
	{ 0x2A57, 0x24F4C },
	{ 0x2A58, 0x24F4A },
	{ 0x2A59, 0x24F49 },
	{ 0x2A5A, 0x24F56 },
	{ 0x2A5B, 0x24FCF },
	{ 0x2A5C, 0x25047 },
	{ 0x2A5D, 0x25048 },
	{ 0x2A5E, 0x25046 },
	{ 0x2A5F, 0x2511B },
	{ 0x2A60, 0x25111 },
	{ 0x2A61, 0x25114 },
	{ 0x2A62, 0x2511D },
	{ 0x2A63, 0x25117 },
	{ 0x2A64, 0x2511E },
	{ 0x2A65, 0x2510B },
	{ 0x2A66, 0x2511C },
	{ 0x2A67, 0x25112 },
	{ 0x2A68, 0x25116 },
	{ 0x2A69, 0x2510D },
	{ 0x2A6A, 0x25115 },
	{ 0x2A6B, 0x25113 },
	{ 0x2A6C, 0x25118 },
	{ 0x2A6D, 0x401A },
	{ 0x2A6E, 0x253AC },
	{ 0x2A6F, 0x25444 },
	{ 0x2A70, 0x2542C },
	{ 0x2A71, 0x25445 },
	{ 0x2A72, 0x25766 },
	{ 0x2A73, 0x2576E },
	{ 0x2A74, 0x25765 },
	{ 0x2A75, 0x25768 },
	{ 0x2A76, 0x25784 },
	{ 0x2A77, 0x25938 },
	{ 0x2A78, 0x2593B },
	{ 0x2A79, 0x2593A },
	{ 0x2A7A, 0x2593F },
	{ 0x2A7B, 0x25ADF },
	{ 0x2A7C, 0x25ADD },
	{ 0x2A7D, 0x25ADE },
	{ 0x2A7E, 0x25AE2 },
	{ 0x2B21, 0x41D6 },
	{ 0x2B22, 0x25E2C },
	{ 0x2B23, 0x25E2F },
	{ 0x2B24, 0x25F8F },
	{ 0x2B25, 0x25F90 },
	{ 0x2B26, 0x25F8C },
	{ 0x2B27, 0x25F93 },
	{ 0x2B28, 0x26225 },
	{ 0x2B29, 0x26288 },
	{ 0x2B2A, 0x262A7 },
	{ 0x2B2B, 0x263F7 },
	{ 0x2B2C, 0x264BB },
	{ 0x2B2D, 0x26538 },
	{ 0x2B2E, 0x26539 },
	{ 0x2B2F, 0x26537 },
	{ 0x2B30, 0x26614 },
	{ 0x2B31, 0x2666E },
	{ 0x2B32, 0x2667B },
	{ 0x2B33, 0x43DE },
	{ 0x2B34, 0x2666C },
	{ 0x2B35, 0x2667F },
	{ 0x2B36, 0x26678 },
	{ 0x2B37, 0x2667A },
	{ 0x2B38, 0x2666F },
	{ 0x2B39, 0x43E5 },
	{ 0x2B3A, 0x268FE },
	{ 0x2B3B, 0x26B48 },
	{ 0x2B3C, 0x26B4B },
	{ 0x2B3D, 0x26B41 },
	{ 0x2B3E, 0x26B49 },
	{ 0x2B3F, 0x26B3B },
	{ 0x2B40, 0x2722D },
	{ 0x2B41, 0x275E3 },
	{ 0x2B42, 0x2761A },
	{ 0x2B43, 0x2760D },
	{ 0x2B44, 0x27613 },
	{ 0x2B45, 0x27611 },
	{ 0x2B46, 0x2761C },
	{ 0x2B47, 0x4672 },
	{ 0x2B48, 0x278B5 },
	{ 0x2B49, 0x46AF },
	{ 0x2B4A, 0x27C29 },
	{ 0x2B4B, 0x27CA1 },
	{ 0x2B4C, 0x27D24 },
	{ 0x2B4D, 0x27FBB },
	{ 0x2B4E, 0x282A1 },
	{ 0x2B4F, 0x28483 },
	{ 0x2B50, 0x2848D },
	{ 0x2B51, 0x28487 },
	{ 0x2B52, 0x28485 },
	{ 0x2B53, 0x2848A },
	{ 0x2B54, 0x284A3 },
	{ 0x2B55, 0x28489 },
	{ 0x2B56, 0x28484 },
	{ 0x2B57, 0x284A2 },
	{ 0x2B58, 0x286B1 },
	{ 0x2B59, 0x286B0 },
	{ 0x2B5A, 0x286AF },
	{ 0x2B5B, 0x286B6 },
	{ 0x2B5C, 0x286C9 },
	{ 0x2B5D, 0x286CA },
	{ 0x2B5E, 0x286C8 },
	{ 0x2B5F, 0x286B4 },
	{ 0x2B60, 0x28C59 },
	{ 0x2B61, 0x28CC9 },
	{ 0x2B62, 0x28E41 },
	{ 0x2B63, 0x28E4C },
	{ 0x2B64, 0x49C4 },
	{ 0x2B65, 0x28E45 },
	{ 0x2B66, 0x28E5A },
	{ 0x2B67, 0x200B9 },
	{ 0x2B68, 0x20294 },
	{ 0x2B69, 0x2026E },
	{ 0x2B6A, 0x202A2 },
	{ 0x2B6B, 0x20267 },
	{ 0x2B6C, 0x3463 },
	{ 0x2B6D, 0x202A3 },
	{ 0x2B6E, 0x20276 },
	{ 0x2B6F, 0x2026C },
	{ 0x2B70, 0x20264 },
	{ 0x2B71, 0x202A5 },
	{ 0x2B72, 0x20230 },
	{ 0x2B73, 0x202A6 },
	{ 0x2B74, 0x20269 },
	{ 0x2B75, 0x202A4 },
	{ 0x2B76, 0x20490 },
	{ 0x2B77, 0x2055F },
	{ 0x2B78, 0x20560 },
	{ 0x2B79, 0x205DA },
	{ 0x2B7A, 0x205D8 },
	{ 0x2B7B, 0x205DD },
	{ 0x2B7C, 0x34EC },
	{ 0x2B7D, 0x20759 },
	{ 0x2B7E, 0x2075B },
	{ 0x2C21, 0x2075A },
	{ 0x2C22, 0x20739 },
	{ 0x2C23, 0x20734 },
	{ 0x2C24, 0x20744 },
	{ 0x2C25, 0x20733 },
	{ 0x2C26, 0x2073C },
	{ 0x2C27, 0x20758 },
	{ 0x2C28, 0x2076A },
	{ 0x2C29, 0x2086F },
	{ 0x2C2A, 0x20872 },
	{ 0x2C2B, 0x20870 },
	{ 0x2C2C, 0x20871 },
	{ 0x2C2D, 0x2086E },
	{ 0x2C2E, 0x208F0 },
	{ 0x2C2F, 0x208EB },
	{ 0x2C30, 0x20949 },
	{ 0x2C31, 0x2094C },
	{ 0x2C32, 0x209F5 },
	{ 0x2C33, 0x20A20 },
	{ 0x2C34, 0x20A6A },
	{ 0x2C35, 0x20A72 },
	{ 0x2C36, 0x20B4B },
	{ 0x2C37, 0x20B5D },
	{ 0x2C38, 0x20C50 },
	{ 0x2C39, 0x20CF9 },
	{ 0x2C3A, 0x20CFA },
	{ 0x2C3B, 0x20CFB },
	{ 0x2C3C, 0x20D23 },
	{ 0x2C3D, 0x20CB7 },
	{ 0x2C3E, 0x20D22 },
	{ 0x2C3F, 0x20CB5 },
	{ 0x2C40, 0x20CC4 },
	{ 0x2C41, 0x20CB4 },
	{ 0x2C42, 0x20CEF },
	{ 0x2C43, 0x3598 },
	{ 0x2C44, 0x20CCD },
	{ 0x2C45, 0x20CF0 },
	{ 0x2C46, 0x20CB8 },
	{ 0x2C47, 0x20CCB },
	{ 0x2C48, 0x20CF1 },
	{ 0x2C49, 0x20CBA },
	{ 0x2C4A, 0x20D03 },
	{ 0x2C4B, 0x20CF8 },
	{ 0x2C4C, 0x20CB6 },
	{ 0x2C4D, 0x20CBC },
	{ 0x2C4E, 0x20CB3 },
	{ 0x2C4F, 0x20D21 },
	{ 0x2C50, 0x20CF7 },
	{ 0x2C51, 0x20CC2 },
	{ 0x2C52, 0x20CBE },
	{ 0x2C53, 0x20CC9 },
	{ 0x2C54, 0x20CBD },
	{ 0x2C55, 0x20CCE },
	{ 0x2C56, 0x20CB9 },
	{ 0x2C57, 0x20CC7 },
	{ 0x2C58, 0x20CCA },
	{ 0x2C59, 0x20CCC },
	{ 0x2C5A, 0x20D26 },
	{ 0x2C5B, 0x211E4 },
	{ 0x2C5C, 0x211E0 },
	{ 0x2C5D, 0x211F0 },
	{ 0x2C5E, 0x212EC },
	{ 0x2C5F, 0x21324 },
	{ 0x2C60, 0x21318 },
	{ 0x2C61, 0x2132F },
	{ 0x2C62, 0x21325 },
	{ 0x2C63, 0x21528 },
	{ 0x2C64, 0x21522 },
	{ 0x2C65, 0x2156A },
	{ 0x2C66, 0x20157 },
	{ 0x2C67, 0x21594 },
	{ 0x2C68, 0x21592 },
	{ 0x2C69, 0x2159C },
	{ 0x2C6A, 0x21622 },
	{ 0x2C6B, 0x21630 },
	{ 0x2C6C, 0x2161D },
	{ 0x2C6D, 0x21623 },
	{ 0x2C6E, 0x21735 },
	{ 0x2C6F, 0x21733 },
	{ 0x2C70, 0x2172F },
	{ 0x2C71, 0x2174D },
	{ 0x2C72, 0x21731 },
	{ 0x2C73, 0x2175B },
	{ 0x2C74, 0x2175A },
	{ 0x2C75, 0x21732 },
	{ 0x2C76, 0x2175C },
	{ 0x2C77, 0x21759 },
	{ 0x2C78, 0x2175D },
	{ 0x2C79, 0x21969 },
	{ 0x2C7A, 0x2196D },
	{ 0x2C7B, 0x22232 },
	{ 0x2C7C, 0x3758 },
	{ 0x2C7D, 0x21A0A },
	{ 0x2C7E, 0x21A20 },
	{ 0x2D21, 0x21A1F },
	{ 0x2D22, 0x21A0D },
	{ 0x2D23, 0x21BE8 },
	{ 0x2D24, 0x21BEC },
	{ 0x2D25, 0x21C77 },
	{ 0x2D26, 0x21C70 },
	{ 0x2D27, 0x21C71 },
	{ 0x2D28, 0x21DF8 },
	{ 0x2D29, 0x21DD6 },
	{ 0x2D2A, 0x21DD9 },
	{ 0x2D2B, 0x21DDE },
	{ 0x2D2C, 0x21DD5 },
	{ 0x2D2D, 0x21DE1 },
	{ 0x2D2E, 0x37D3 },
	{ 0x2D2F, 0x21DE2 },
	{ 0x2D30, 0x21DDD },
	{ 0x2D31, 0x21DE0 },
	{ 0x2D32, 0x21E0E },
	{ 0x2D33, 0x21E08 },
	{ 0x2D34, 0x21DDC },
	{ 0x2D35, 0x21E0A },
	{ 0x2D36, 0x21E0C },
	{ 0x2D37, 0x220B4 },
	{ 0x2D38, 0x220B1 },
	{ 0x2D39, 0x220B6 },
	{ 0x2D3A, 0x220BC },
	{ 0x2D3B, 0x2221D },
	{ 0x2D3C, 0x22224 },
	{ 0x2D3D, 0x22219 },
	{ 0x2D3E, 0x2221B },
	{ 0x2D3F, 0x22222 },
	{ 0x2D40, 0x2221A },
	{ 0x2D41, 0x2221C },
	{ 0x2D42, 0x22221 },
	{ 0x2D43, 0x223E6 },
	{ 0x2D44, 0x223E4 },
	{ 0x2D45, 0x223E7 },
	{ 0x2D46, 0x223EA },
	{ 0x2D47, 0x38E2 },
	{ 0x2D48, 0x2F89B },
	{ 0x2D49, 0x224F0 },
	{ 0x2D4A, 0x224F5 },
	{ 0x2D4B, 0x224EF },
	{ 0x2D4C, 0x22642 },
	{ 0x2D4D, 0x2266E },
	{ 0x2D4E, 0x2263C },
	{ 0x2D4F, 0x22697 },
	{ 0x2D50, 0x2268C },
	{ 0x2D51, 0x22681 },
	{ 0x2D52, 0x22671 },
	{ 0x2D53, 0x226CE },
	{ 0x2D54, 0x226BA },
	{ 0x2D55, 0x2267A },
	{ 0x2D56, 0x2267E },
	{ 0x2D57, 0x3954 },
	{ 0x2D58, 0x22672 },
	{ 0x2D59, 0x226BB },
	{ 0x2D5A, 0x392F },
	{ 0x2D5B, 0x22673 },
	{ 0x2D5C, 0x22682 },
	{ 0x2D5D, 0x39B6 },
	{ 0x2D5E, 0x229BA },
	{ 0x2D5F, 0x229B8 },
	{ 0x2D60, 0x22A4B },
	{ 0x2D61, 0x22A48 },
	{ 0x2D62, 0x22B2B },
	{ 0x2D63, 0x22AF4 },
	{ 0x2D64, 0x22B2C },
	{ 0x2D65, 0x22B42 },
	{ 0x2D66, 0x22B48 },
	{ 0x2D67, 0x22B44 },
	{ 0x2D68, 0x22B45 },
	{ 0x2D69, 0x22B3C },
	{ 0x2D6A, 0x22B37 },
	{ 0x2D6B, 0x22B33 },
	{ 0x2D6C, 0x22B41 },
	{ 0x2D6D, 0x22B32 },
	{ 0x2D6E, 0x22B87 },
	{ 0x2D6F, 0x22F27 },
	{ 0x2D70, 0x22F23 },
	{ 0x2D71, 0x22F2D },
	{ 0x2D72, 0x22F1F },
	{ 0x2D73, 0x22F2C },
	{ 0x2D74, 0x22F28 },
	{ 0x2D75, 0x23075 },
	{ 0x2D76, 0x23074 },
	{ 0x2D77, 0x230E7 },
	{ 0x2D78, 0x23132 },
	{ 0x2D79, 0x23131 },
	{ 0x2D7A, 0x23199 },
	{ 0x2D7B, 0x23196 },
	{ 0x2D7C, 0x23198 },
	{ 0x2D7D, 0x2319D },
	{ 0x2D7E, 0x23192 },
	{ 0x2E21, 0x23194 },
	{ 0x2E22, 0x23195 },
	{ 0x2E23, 0x23197 },
	{ 0x2E24, 0x266B9 },
	{ 0x2E25, 0x3B35 },
	{ 0x2E26, 0x23411 },
	{ 0x2E27, 0x2343B },
	{ 0x2E28, 0x23479 },
	{ 0x2E29, 0x23442 },
	{ 0x2E2A, 0x23443 },
	{ 0x2E2B, 0x3B5D },
	{ 0x2E2C, 0x23478 },
	{ 0x2E2D, 0x238AC },
	{ 0x2E2E, 0x3C29 },
	{ 0x2E2F, 0x238B1 },
	{ 0x2E30, 0x238B4 },
	{ 0x2E31, 0x238B3 },
	{ 0x2E32, 0x238AF },
	{ 0x2E33, 0x238AA },
	{ 0x2E34, 0x238B2 },
	{ 0x2E35, 0x23968 },
	{ 0x2E36, 0x239F2 },
	{ 0x2E37, 0x239FE },
	{ 0x2E38, 0x239F8 },
	{ 0x2E39, 0x239F9 },
	{ 0x2E3A, 0x239FF },
	{ 0x2E3B, 0x239F5 },
	{ 0x2E3C, 0x239F7 },
	{ 0x2E3D, 0x239FD },
	{ 0x2E3E, 0x23A00 },
	{ 0x2E3F, 0x23A88 },
	{ 0x2E40, 0x23B6E },
	{ 0x2E41, 0x23B5D },
	{ 0x2E42, 0x23B63 },
	{ 0x2E43, 0x23B60 },
	{ 0x2E44, 0x23C61 },
	{ 0x2E45, 0x23D37 },
	{ 0x2E46, 0x23D71 },
	{ 0x2E47, 0x23D23 },
	{ 0x2E48, 0x23D22 },
	{ 0x2E49, 0x23D1F },
	{ 0x2E4A, 0x23D25 },
	{ 0x2E4B, 0x241FD },
	{ 0x2E4C, 0x24211 },
	{ 0x2E4D, 0x24223 },
	{ 0x2E4E, 0x241F0 },
	{ 0x2E4F, 0x241EF },
	{ 0x2E50, 0x2450E },
	{ 0x2E51, 0x2450C },
	{ 0x2E52, 0x245BA },
	{ 0x2E53, 0x3E1F },
	{ 0x2E54, 0x24652 },
	{ 0x2E55, 0x24655 },
	{ 0x2E56, 0x24653 },
	{ 0x2E57, 0x24654 },
	{ 0x2E58, 0x24651 },
	{ 0x2E59, 0x24658 },
	{ 0x2E5A, 0x247B0 },
	{ 0x2E5B, 0x2479F },
	{ 0x2E5C, 0x3E72 },
	{ 0x2E5D, 0x247A1 },
	{ 0x2E5E, 0x2479A },
	{ 0x2E5F, 0x247BE },
	{ 0x2E60, 0x247A0 },
	{ 0x2E61, 0x24937 },
	{ 0x2E62, 0x3F0B },
	{ 0x2E63, 0x24AF1 },
	{ 0x2E64, 0x24AF2 },
	{ 0x2E65, 0x24B34 },
	{ 0x2E66, 0x24B37 },
	{ 0x2E67, 0x24B35 },
	{ 0x2E68, 0x2238C },
	{ 0x2E69, 0x24BDF },
	{ 0x2E6A, 0x24C4C },
	{ 0x2E6B, 0x24C4E },
	{ 0x2E6C, 0x24C64 },
	{ 0x2E6D, 0x24C63 },
	{ 0x2E6E, 0x24C36 },
	{ 0x2E6F, 0x24D58 },
	{ 0x2E70, 0x24D68 },
	{ 0x2E71, 0x24D5B },
	{ 0x2E72, 0x24D5F },
	{ 0x2E73, 0x24D59 },
	{ 0x2E74, 0x24D65 },
	{ 0x2E75, 0x24D60 },
	{ 0x2E76, 0x24D5E },
	{ 0x2E77, 0x24FD5 },
	{ 0x2E78, 0x24FD6 },
	{ 0x2E79, 0x2504E },
	{ 0x2E7A, 0x25052 },
	{ 0x2E7B, 0x25135 },
	{ 0x2E7C, 0x25139 },
	{ 0x2E7D, 0x25158 },
	{ 0x2E7E, 0x25141 },
	{ 0x2F21, 0x25157 },
	{ 0x2F22, 0x25138 },
	{ 0x2F23, 0x2513D },
	{ 0x2F24, 0x25132 },
	{ 0x2F25, 0x25144 },
	{ 0x2F26, 0x2F944 },
	{ 0x2F27, 0x25363 },
	{ 0x2F28, 0x25362 },
	{ 0x2F29, 0x253B8 },
	{ 0x2F2A, 0x253B0 },
	{ 0x2F2B, 0x253B1 },
	{ 0x2F2C, 0x2544D },
	{ 0x2F2D, 0x25463 },
	{ 0x2F2E, 0x25470 },
	{ 0x2F2F, 0x2544B },
	{ 0x2F30, 0x2544F },
	{ 0x2F31, 0x2544E },
	{ 0x2F32, 0x25453 },
	{ 0x2F33, 0x25447 },
	{ 0x2F34, 0x40A2 },
	{ 0x2F35, 0x25454 },
	{ 0x2F36, 0x25452 },
	{ 0x2F37, 0x25459 },
	{ 0x2F38, 0x2547E },
	{ 0x2F39, 0x2562B },
	{ 0x2F3A, 0x2562E },
	{ 0x2F3B, 0x2577F },
	{ 0x2F3C, 0x2577E },
	{ 0x2F3D, 0x25781 },
	{ 0x2F3E, 0x25783 },
	{ 0x2F3F, 0x25947 },
	{ 0x2F40, 0x25954 },
	{ 0x2F41, 0x2594D },
	{ 0x2F42, 0x2594C },
	{ 0x2F43, 0x2594B },
	{ 0x2F44, 0x25957 },
	{ 0x2F45, 0x25A65 },
	{ 0x2F46, 0x25A64 },
	{ 0x2F47, 0x25A61 },
	{ 0x2F48, 0x25A62 },
	{ 0x2F49, 0x25AF0 },
	{ 0x2F4A, 0x25AF3 },
	{ 0x2F4B, 0x25AF9 },
	{ 0x2F4C, 0x25AF4 },
	{ 0x2F4D, 0x25AF5 },
	{ 0x2F4E, 0x25AEF },
	{ 0x2F4F, 0x25AF8 },
	{ 0x2F50, 0x25AFC },
	{ 0x2F51, 0x25AF7 },
	{ 0x2F52, 0x25AFD },
	{ 0x2F53, 0x25B17 },
	{ 0x2F54, 0x25E34 },
	{ 0x2F55, 0x25E36 },
	{ 0x2F56, 0x25E38 },
	{ 0x2F57, 0x25FAF },
	{ 0x2F58, 0x25FAE },
	{ 0x2F59, 0x25FAC },
	{ 0x2F5A, 0x25FA2 },
	{ 0x2F5B, 0x26228 },
	{ 0x2F5C, 0x22EC2 },
	{ 0x2F5D, 0x2629C },
	{ 0x2F5E, 0x262B3 },
	{ 0x2F5F, 0x26290 },
	{ 0x2F60, 0x26406 },
	{ 0x2F61, 0x26404 },
	{ 0x2F62, 0x2640B },
	{ 0x2F63, 0x26405 },
	{ 0x2F64, 0x26540 },
	{ 0x2F65, 0x2654F },
	{ 0x2F66, 0x266AB },
	{ 0x2F67, 0x2669D },
	{ 0x2F68, 0x266B8 },
	{ 0x2F69, 0x266B2 },
	{ 0x2F6A, 0x266D2 },
	{ 0x2F6B, 0x266CF },
	{ 0x2F6C, 0x266A2 },
	{ 0x2F6D, 0x43EC },
	{ 0x2F6E, 0x266A5 },
	{ 0x2F6F, 0x266A9 },
	{ 0x2F70, 0x266A7 },
	{ 0x2F71, 0x266D0 },
	{ 0x2F72, 0x26902 },
	{ 0x2F73, 0x269CF },
	{ 0x2F74, 0x269D0 },
	{ 0x2F75, 0x26A16 },
	{ 0x2F76, 0x26A19 },
	{ 0x2F77, 0x26B75 },
	{ 0x2F78, 0x26B71 },
	{ 0x2F79, 0x26B91 },
	{ 0x2F7A, 0x26B72 },
	{ 0x2F7B, 0x26B8E },
	{ 0x2F7C, 0x26B6D },
	{ 0x2F7D, 0x26B88 },
	{ 0x2F7E, 0x26B73 },
	{ 0x3021, 0x44BB },
	{ 0x3022, 0x26B81 },
	{ 0x3023, 0x26B76 },
	{ 0x3024, 0x26B7B },
	{ 0x3025, 0x26B7F },
	{ 0x3026, 0x26B90 },
	{ 0x3027, 0x26B78 },
	{ 0x3028, 0x2724B },
	{ 0x3029, 0x27248 },
	{ 0x302A, 0x2725B },
	{ 0x302B, 0x27251 },
	{ 0x302C, 0x2723D },
	{ 0x302D, 0x27240 },
	{ 0x302E, 0x27246 },
	{ 0x302F, 0x2724D },
	{ 0x3030, 0x2723B },
	{ 0x3031, 0x2724A },
	{ 0x3032, 0x27241 },
	{ 0x3033, 0x2723E },
	{ 0x3034, 0x2724E },
	{ 0x3035, 0x275AC },
	{ 0x3036, 0x275E6 },
	{ 0x3037, 0x275E9 },
	{ 0x3038, 0x27629 },
	{ 0x3039, 0x4621 },
	{ 0x303A, 0x27633 },
	{ 0x303B, 0x2762E },
	{ 0x303C, 0x2761E },
	{ 0x303D, 0x461F },
	{ 0x303E, 0x2F9C5 },
	{ 0x303F, 0x27622 },
	{ 0x3040, 0x27627 },
	{ 0x3041, 0x277E7 },
	{ 0x3042, 0x2780B },
	{ 0x3043, 0x27966 },
	{ 0x3044, 0x27BAD },
	{ 0x3045, 0x27BAE },
	{ 0x3046, 0x8C38 },
	{ 0x3047, 0x27C2B },
	{ 0x3048, 0x27C2A },
	{ 0x3049, 0x27D2C },
	{ 0x304A, 0x27D2D },
	{ 0x304B, 0x4791 },
	{ 0x304C, 0x4796 },
	{ 0x304D, 0x27E8F },
	{ 0x304E, 0x27E93 },
	{ 0x304F, 0x27FC6 },
	{ 0x3050, 0x27FC5 },
	{ 0x3051, 0x28215 },
	{ 0x3052, 0x28213 },
	{ 0x3053, 0x282B1 },
	{ 0x3054, 0x282A9 },
	{ 0x3055, 0x8ECE },
	{ 0x3056, 0x284A8 },
	{ 0x3057, 0x284AB },
	{ 0x3058, 0x284BE },
	{ 0x3059, 0x284AC },
	{ 0x305A, 0x284A9 },
	{ 0x305B, 0x284A6 },
	{ 0x305C, 0x284C1 },
	{ 0x305D, 0x286CC },
	{ 0x305E, 0x286D1 },
	{ 0x305F, 0x286D3 },
	{ 0x3060, 0x286E4 },
	{ 0x3061, 0x286CB },
	{ 0x3062, 0x286E1 },
	{ 0x3063, 0x286D2 },
	{ 0x3064, 0x286E3 },
	{ 0x3065, 0x286CF },
	{ 0x3066, 0x286D0 },
	{ 0x3067, 0x286E5 },
	{ 0x3068, 0x2870E },
	{ 0x3069, 0x28CCC },
	{ 0x306A, 0x28CCA },
	{ 0x306B, 0x28CCB },
	{ 0x306C, 0x28E5C },
	{ 0x306D, 0x28E61 },
	{ 0x306E, 0x28E5D },
	{ 0x306F, 0x28E59 },
	{ 0x3070, 0x29077 },
	{ 0x3071, 0x29684 },
	{ 0x3072, 0x20041 },
	{ 0x3073, 0x200FD },
	{ 0x3074, 0x2011A },
	{ 0x3075, 0x20163 },
	{ 0x3076, 0x202B6 },
	{ 0x3077, 0x202B2 },
	{ 0x3078, 0x202E9 },
	{ 0x3079, 0x202E7 },
	{ 0x307A, 0x202D6 },
	{ 0x307B, 0x20330 },
	{ 0x307C, 0x202EC },
	{ 0x307D, 0x202DD },
	{ 0x307E, 0x202E8 },
	{ 0x3121, 0x202B0 },
	{ 0x3122, 0x202B5 },
	{ 0x3123, 0x202E1 },
	{ 0x3124, 0x20498 },
	{ 0x3125, 0x20499 },
	{ 0x3126, 0x34BC },
	{ 0x3127, 0x20593 },
	{ 0x3128, 0x205E5 },
	{ 0x3129, 0x34D8 },
	{ 0x312A, 0x20760 },
	{ 0x312B, 0x2075E },
	{ 0x312C, 0x34F4 },
	{ 0x312D, 0x2087B },
	{ 0x312E, 0x208F1 },
	{ 0x312F, 0x208F3 },
	{ 0x3130, 0x20A7F },
	{ 0x3131, 0x2F838 },
	{ 0x3132, 0x20B57 },
	{ 0x3133, 0x20B58 },
	{ 0x3134, 0x20D39 },
	{ 0x3135, 0x20DA7 },
	{ 0x3136, 0x20D35 },
	{ 0x3137, 0x20D60 },
	{ 0x3138, 0x20D51 },
	{ 0x3139, 0x20D62 },
	{ 0x313A, 0x20D42 },
	{ 0x313B, 0x20D3C },
	{ 0x313C, 0x20D43 },
	{ 0x313D, 0x20DAB },
	{ 0x313E, 0x20DA9 },
	{ 0x313F, 0x20DB4 },
	{ 0x3140, 0x20D79 },
	{ 0x3141, 0x20D6A },
	{ 0x3142, 0x20D3B },
	{ 0x3143, 0x20DAA },
	{ 0x3144, 0x20D33 },
	{ 0x3145, 0x20D37 },
	{ 0x3146, 0x20D27 },
	{ 0x3147, 0x20DA8 },
	{ 0x3148, 0x20D70 },
	{ 0x3149, 0x20D2F },
	{ 0x314A, 0x20D36 },
	{ 0x314B, 0x20DB5 },
	{ 0x314C, 0x20D30 },
	{ 0x314D, 0x20D3A },
	{ 0x314E, 0x20D38 },
	{ 0x314F, 0x20DB1 },
	{ 0x3150, 0x20DAC },
	{ 0x3151, 0x20D2E },
	{ 0x3152, 0x20D75 },
	{ 0x3153, 0x20DB0 },
	{ 0x3154, 0x211F7 },
	{ 0x3155, 0x21200 },
	{ 0x3156, 0x211F1 },
	{ 0x3157, 0x211F3 },
	{ 0x3158, 0x21360 },
	{ 0x3159, 0x21361 },
	{ 0x315A, 0x21332 },
	{ 0x315B, 0x2132D },
	{ 0x315C, 0x2134A },
	{ 0x315D, 0x2132A },
	{ 0x315E, 0x21567 },
	{ 0x315F, 0x215A2 },
	{ 0x3160, 0x215A3 },
	{ 0x3161, 0x2159E },
	{ 0x3162, 0x215A4 },
	{ 0x3163, 0x21644 },
	{ 0x3164, 0x21632 },
	{ 0x3165, 0x2179B },
	{ 0x3166, 0x21798 },
	{ 0x3167, 0x21799 },
	{ 0x3168, 0x2179A },
	{ 0x3169, 0x21766 },
	{ 0x316A, 0x21762 },
	{ 0x316B, 0x2176B },
	{ 0x316C, 0x24562 },
	{ 0x316D, 0x21767 },
	{ 0x316E, 0x21A3B },
	{ 0x316F, 0x21A23 },
	{ 0x3170, 0x21A29 },
	{ 0x3171, 0x21B7E },
	{ 0x3172, 0x21BF3 },
	{ 0x3173, 0x3785 },
	{ 0x3174, 0x21BF5 },
	{ 0x3175, 0x3783 },
	{ 0x3176, 0x21C80 },
	{ 0x3177, 0x21C7E },
	{ 0x3178, 0x21C7C },
	{ 0x3179, 0x21C7F },
	{ 0x317A, 0x21C7D },
	{ 0x317B, 0x21C81 },
	{ 0x317C, 0x21E25 },
	{ 0x317D, 0x21E29 },
	{ 0x317E, 0x21E17 },
	{ 0x3221, 0x21E63 },
	{ 0x3222, 0x21E67 },
	{ 0x3223, 0x21E65 },
	{ 0x3224, 0x21E2A },
	{ 0x3225, 0x21E68 },
	{ 0x3226, 0x21E26 },
	{ 0x3227, 0x21E64 },
	{ 0x3228, 0x21E1B },
	{ 0x3229, 0x21E62 },
	{ 0x322A, 0x21E69 },
	{ 0x322B, 0x21FFE },
	{ 0x322C, 0x22044 },
	{ 0x322D, 0x22042 },
	{ 0x322E, 0x220B7 },
	{ 0x322F, 0x220D2 },
	{ 0x3230, 0x220D4 },
	{ 0x3231, 0x220D7 },
	{ 0x3232, 0x220DC },
	{ 0x3233, 0x220D1 },
	{ 0x3234, 0x220D5 },
	{ 0x3235, 0x220CD },
	{ 0x3236, 0x220D8 },
	{ 0x3237, 0x2219A },
	{ 0x3238, 0x22242 },
	{ 0x3239, 0x22235 },
	{ 0x323A, 0x22258 },
	{ 0x323B, 0x22234 },
	{ 0x323C, 0x2223C },
	{ 0x323D, 0x2223B },
	{ 0x323E, 0x2223E },
	{ 0x323F, 0x2223D },
	{ 0x3240, 0x2225A },
	{ 0x3241, 0x22241 },
	{ 0x3242, 0x22238 },
	{ 0x3243, 0x22245 },
	{ 0x3244, 0x22233 },
	{ 0x3245, 0x22326 },
	{ 0x3246, 0x38BA },
	{ 0x3247, 0x223F7 },
	{ 0x3248, 0x223EF },
	{ 0x3249, 0x223F0 },
	{ 0x324A, 0x223EE },
	{ 0x324B, 0x2249D },
	{ 0x324C, 0x22506 },
	{ 0x324D, 0x22511 },
	{ 0x324E, 0x22508 },
	{ 0x324F, 0x22502 },
	{ 0x3250, 0x2250A },
	{ 0x3251, 0x22507 },
	{ 0x3252, 0x22691 },
	{ 0x3253, 0x2268E },
	{ 0x3254, 0x22685 },
	{ 0x3255, 0x226E8 },
	{ 0x3256, 0x22717 },
	{ 0x3257, 0x226D4 },
	{ 0x3258, 0x3969 },
	{ 0x3259, 0x226C4 },
	{ 0x325A, 0x226D5 },
	{ 0x325B, 0x3945 },
	{ 0x325C, 0x226D8 },
	{ 0x325D, 0x22680 },
	{ 0x325E, 0x226DE },
	{ 0x325F, 0x22742 },
	{ 0x3260, 0x229C7 },
	{ 0x3261, 0x229BF },
	{ 0x3262, 0x22B8D },
	{ 0x3263, 0x22B89 },
	{ 0x3264, 0x22B90 },
	{ 0x3265, 0x22B9A },
	{ 0x3266, 0x22BC8 },
	{ 0x3267, 0x22B92 },
	{ 0x3268, 0x22BA1 },
	{ 0x3269, 0x22B84 },
	{ 0x326A, 0x22F57 },
	{ 0x326B, 0x22F47 },
	{ 0x326C, 0x22F77 },
	{ 0x326D, 0x22F3A },
	{ 0x326E, 0x22F50 },
	{ 0x326F, 0x22F42 },
	{ 0x3270, 0x22F43 },
	{ 0x3271, 0x22FA3 },
	{ 0x3272, 0x23077 },
	{ 0x3273, 0x231B2 },
	{ 0x3274, 0x231E2 },
	{ 0x3275, 0x231BD },
	{ 0x3276, 0x23374 },
	{ 0x3277, 0x23482 },
	{ 0x3278, 0x234B8 },
	{ 0x3279, 0x3B6C },
	{ 0x327A, 0x234BA },
	{ 0x327B, 0x234B9 },
	{ 0x327C, 0x234BB },
	{ 0x327D, 0x23487 },
	{ 0x327E, 0x2F8E4 },
	{ 0x3321, 0x23483 },
	{ 0x3322, 0x234B7 },
	{ 0x3323, 0x20043 },
	{ 0x3324, 0x238CE },
	{ 0x3325, 0x238BA },
	{ 0x3326, 0x23973 },
	{ 0x3327, 0x23A09 },
	{ 0x3328, 0x23A0A },
	{ 0x3329, 0x23A0B },
	{ 0x332A, 0x23A07 },
	{ 0x332B, 0x23A05 },
	{ 0x332C, 0x23A0E },
	{ 0x332D, 0x23A97 },
	{ 0x332E, 0x23B77 },
	{ 0x332F, 0x23B7B },
	{ 0x3330, 0x23B7A },
	{ 0x3331, 0x23B74 },
	{ 0x3332, 0x23B79 },
	{ 0x3333, 0x23D86 },
	{ 0x3334, 0x23DF5 },
	{ 0x3335, 0x23DA5 },
	{ 0x3336, 0x23D9D },
	{ 0x3337, 0x23DBE },
	{ 0x3338, 0x23D96 },
	{ 0x3339, 0x23DE1 },
	{ 0x333A, 0x23DA4 },
	{ 0x333B, 0x23DA1 },
	{ 0x333C, 0x23DF6 },
	{ 0x333D, 0x3D04 },
	{ 0x333E, 0x23D8D },
	{ 0x333F, 0x23D8B },
	{ 0x3340, 0x23D78 },
	{ 0x3341, 0x23D98 },
	{ 0x3342, 0x23E0A },
	{ 0x3343, 0x2425D },
	{ 0x3344, 0x24227 },
	{ 0x3345, 0x2425F },
	{ 0x3346, 0x245C0 },
	{ 0x3347, 0x245C1 },
	{ 0x3348, 0x2466D },
	{ 0x3349, 0x2465E },
	{ 0x334A, 0x2468A },
	{ 0x334B, 0x24662 },
	{ 0x334C, 0x24664 },
	{ 0x334D, 0x3E3A },
	{ 0x334E, 0x247C0 },
	{ 0x334F, 0x247CA },
	{ 0x3350, 0x247D1 },
	{ 0x3351, 0x3E79 },
	{ 0x3352, 0x247C7 },
	{ 0x3353, 0x247CE },
	{ 0x3354, 0x7309 },
	{ 0x3355, 0x247C5 },
	{ 0x3356, 0x24936 },
	{ 0x3357, 0x24957 },
	{ 0x3358, 0x24977 },
	{ 0x3359, 0x24AF6 },
	{ 0x335A, 0x24AF7 },
	{ 0x335B, 0x24B55 },
	{ 0x335C, 0x24B44 },
	{ 0x335D, 0x24B3E },
	{ 0x335E, 0x24B42 },
	{ 0x335F, 0x24B52 },
	{ 0x3360, 0x24BE1 },
	{ 0x3361, 0x24C08 },
	{ 0x3362, 0x24C68 },
	{ 0x3363, 0x24C67 },
	{ 0x3364, 0x3F5D },
	{ 0x3365, 0x2F937 },
	{ 0x3366, 0x24D7E },
	{ 0x3367, 0x24D93 },
	{ 0x3368, 0x24D79 },
	{ 0x3369, 0x24D81 },
	{ 0x336A, 0x24D7D },
	{ 0x336B, 0x24D7B },
	{ 0x336C, 0x24D94 },
	{ 0x336D, 0x3F8A },
	{ 0x336E, 0x24F66 },
	{ 0x336F, 0x24FD9 },
	{ 0x3370, 0x24FE0 },
	{ 0x3371, 0x2F93E },
	{ 0x3372, 0x2505F },
	{ 0x3373, 0x2515F },
	{ 0x3374, 0x2515E },
	{ 0x3375, 0x25168 },
	{ 0x3376, 0x4027 },
	{ 0x3377, 0x25188 },
	{ 0x3378, 0x2516A },
	{ 0x3379, 0x2516C },
	{ 0x337A, 0x25166 },
	{ 0x337B, 0x25167 },
	{ 0x337C, 0x25189 },
	{ 0x337D, 0x25160 },
	{ 0x337E, 0x25185 },
	{ 0x3421, 0x2032A },
	{ 0x3422, 0x25368 },
	{ 0x3423, 0x253B9 },
	{ 0x3424, 0x253BA },
	{ 0x3425, 0x253BE },
	{ 0x3426, 0x2546F },
	{ 0x3427, 0x25480 },
	{ 0x3428, 0x25474 },
	{ 0x3429, 0x25481 },
	{ 0x342A, 0x2547A },
	{ 0x342B, 0x2549C },
	{ 0x342C, 0x25473 },
	{ 0x342D, 0x25482 },
	{ 0x342E, 0x2547F },
	{ 0x342F, 0x254A7 },
	{ 0x3430, 0x25479 },
	{ 0x3431, 0x25478 },
	{ 0x3432, 0x2547D },
	{ 0x3433, 0x254A8 },
	{ 0x3434, 0x2547C },
	{ 0x3435, 0x25668 },
	{ 0x3436, 0x2564E },
	{ 0x3437, 0x2579E },
	{ 0x3438, 0x4146 },
	{ 0x3439, 0x4140 },
	{ 0x343A, 0x25798 },
	{ 0x343B, 0x413F },
	{ 0x343C, 0x25785 },
	{ 0x343D, 0x2579C },
	{ 0x343E, 0x257C5 },
	{ 0x343F, 0x2579A },
	{ 0x3440, 0x25968 },
	{ 0x3441, 0x25965 },
	{ 0x3442, 0x25967 },
	{ 0x3443, 0x25961 },
	{ 0x3444, 0x25960 },
	{ 0x3445, 0x419D },
	{ 0x3446, 0x41CB },
	{ 0x3447, 0x25A7B },
	{ 0x3448, 0x41E1 },
	{ 0x3449, 0x25B19 },
	{ 0x344A, 0x25B0E },
	{ 0x344B, 0x25B31 },
	{ 0x344C, 0x25B12 },
	{ 0x344D, 0x25B10 },
	{ 0x344E, 0x25B15 },
	{ 0x344F, 0x25B3F },
	{ 0x3450, 0x25B1D },
	{ 0x3451, 0x25B1E },
	{ 0x3452, 0x25E4D },
	{ 0x3453, 0x25E48 },
	{ 0x3454, 0x25E45 },
	{ 0x3455, 0x25E42 },
	{ 0x3456, 0x25E49 },
	{ 0x3457, 0x25E4A },
	{ 0x3458, 0x25E47 },
	{ 0x3459, 0x427F },
	{ 0x345A, 0x25E4C },
	{ 0x345B, 0x25FCD },
	{ 0x345C, 0x25FD5 },
	{ 0x345D, 0x25FC4 },
	{ 0x345E, 0x25FCA },
	{ 0x345F, 0x25FC3 },
	{ 0x3460, 0x4346 },
	{ 0x3461, 0x26229 },
	{ 0x3462, 0x262B4 },
	{ 0x3463, 0x2636D },
	{ 0x3464, 0x26366 },
	{ 0x3465, 0x2636A },
	{ 0x3466, 0x26415 },
	{ 0x3467, 0x264D3 },
	{ 0x3468, 0x264EC },
	{ 0x3469, 0x26555 },
	{ 0x346A, 0x441A },
	{ 0x346B, 0x266D6 },
	{ 0x346C, 0x266D8 },
	{ 0x346D, 0x26751 },
	{ 0x346E, 0x266E0 },
	{ 0x346F, 0x26703 },
	{ 0x3470, 0x26704 },
	{ 0x3471, 0x266DA },
	{ 0x3472, 0x266EA },
	{ 0x3473, 0x26702 },
	{ 0x3474, 0x266D3 },
	{ 0x3475, 0x266E4 },
	{ 0x3476, 0x266E5 },
	{ 0x3477, 0x2693B },
	{ 0x3478, 0x26966 },
	{ 0x3479, 0x26A2C },
	{ 0x347A, 0x26A21 },
	{ 0x347B, 0x26A26 },
	{ 0x347C, 0x26AD4 },
	{ 0x347D, 0x26AD5 },
	{ 0x347E, 0x26AD9 },
	{ 0x3521, 0x26BD5 },
	{ 0x3522, 0x26BEB },
	{ 0x3523, 0x26BC5 },
	{ 0x3524, 0x44D3 },
	{ 0x3525, 0x26C27 },
	{ 0x3526, 0x26BF0 },
	{ 0x3527, 0x26BB9 },
	{ 0x3528, 0x26C18 },
	{ 0x3529, 0x26BEE },
	{ 0x352A, 0x44D0 },
	{ 0x352B, 0x26BB7 },
	{ 0x352C, 0x26BBB },
	{ 0x352D, 0x26BEF },
	{ 0x352E, 0x26BB8 },
	{ 0x352F, 0x26BDF },
	{ 0x3530, 0x26BDA },
	{ 0x3531, 0x26BE3 },
	{ 0x3532, 0x26BC9 },
	{ 0x3533, 0x26BEC },
	{ 0x3534, 0x271A4 },
	{ 0x3535, 0x458E },
	{ 0x3536, 0x271A3 },
	{ 0x3537, 0x2725E },
	{ 0x3538, 0x27261 },
	{ 0x3539, 0x27262 },
	{ 0x353A, 0x27263 },
	{ 0x353B, 0x2728E },
	{ 0x353C, 0x27269 },
	{ 0x353D, 0x2726B },
	{ 0x353E, 0x27285 },
	{ 0x353F, 0x2728D },
	{ 0x3540, 0x27264 },
	{ 0x3541, 0x2726D },
	{ 0x3542, 0x2764C },
	{ 0x3543, 0x27649 },
	{ 0x3544, 0x27647 },
	{ 0x3545, 0x27648 },
	{ 0x3546, 0x27642 },
	{ 0x3547, 0x27645 },
	{ 0x3548, 0x2765B },
	{ 0x3549, 0x2765D },
	{ 0x354A, 0x27646 },
	{ 0x354B, 0x27813 },
	{ 0x354C, 0x2781A },
	{ 0x354D, 0x2780E },
	{ 0x354E, 0x2780F },
	{ 0x354F, 0x2781B },
	{ 0x3550, 0x27812 },
	{ 0x3551, 0x278C3 },
	{ 0x3552, 0x278BE },
	{ 0x3553, 0x278BD },
	{ 0x3554, 0x27979 },
	{ 0x3555, 0x2797C },
	{ 0x3556, 0x46C3 },
	{ 0x3557, 0x46B6 },
	{ 0x3558, 0x27980 },
	{ 0x3559, 0x27975 },
	{ 0x355A, 0x2799B },
	{ 0x355B, 0x8A2F },
	{ 0x355C, 0x27974 },
	{ 0x355D, 0x46C0 },
	{ 0x355E, 0x46B8 },
	{ 0x355F, 0x22041 },
	{ 0x3560, 0x22494 },
	{ 0x3561, 0x27C30 },
	{ 0x3562, 0x27CA7 },
	{ 0x3563, 0x27CA5 },
	{ 0x3564, 0x27CA4 },
	{ 0x3565, 0x27D3A },
	{ 0x3566, 0x27E5B },
	{ 0x3567, 0x27E9F },
	{ 0x3568, 0x27EA8 },
	{ 0x3569, 0x27EB3 },
	{ 0x356A, 0x27EA1 },
	{ 0x356B, 0x27EA7 },
	{ 0x356C, 0x27EB2 },
	{ 0x356D, 0x27E9D },
	{ 0x356E, 0x27EA3 },
	{ 0x356F, 0x27EA2 },
	{ 0x3570, 0x27FEF },
	{ 0x3571, 0x27FD9 },
	{ 0x3572, 0x47D9 },
	{ 0x3573, 0x27FD5 },
	{ 0x3574, 0x27FDD },
	{ 0x3575, 0x27FDA },
	{ 0x3576, 0x27FEE },
	{ 0x3577, 0x27FD7 },
	{ 0x3578, 0x2821A },
	{ 0x3579, 0x28219 },
	{ 0x357A, 0x28218 },
	{ 0x357B, 0x282B3 },
	{ 0x357C, 0x282BF },
	{ 0x357D, 0x282BB },
	{ 0x357E, 0x282C0 },
	{ 0x3621, 0x282B9 },
	{ 0x3622, 0x282B8 },
	{ 0x3623, 0x282D5 },
	{ 0x3624, 0x28411 },
	{ 0x3625, 0x28410 },
	{ 0x3626, 0x284C3 },
	{ 0x3627, 0x284C2 },
	{ 0x3628, 0x284E9 },
	{ 0x3629, 0x284CD },
	{ 0x362A, 0x284E5 },
	{ 0x362B, 0x284CA },
	{ 0x362C, 0x284C7 },
	{ 0x362D, 0x284E8 },
	{ 0x362E, 0x286F1 },
	{ 0x362F, 0x2870C },
	{ 0x3630, 0x286EF },
	{ 0x3631, 0x286EE },
	{ 0x3632, 0x286F3 },
	{ 0x3633, 0x2870D },
	{ 0x3634, 0x286F6 },
	{ 0x3635, 0x286F0 },
	{ 0x3636, 0x48EC },
	{ 0x3637, 0x287F5 },
	{ 0x3638, 0x287F4 },
	{ 0x3639, 0x287F8 },
	{ 0x363A, 0x287FE },
	{ 0x363B, 0x28911 },
	{ 0x363C, 0x28922 },
	{ 0x363D, 0x28942 },
	{ 0x363E, 0x28C5C },
	{ 0x363F, 0x28C5A },
	{ 0x3640, 0x28C5D },
	{ 0x3641, 0x28CD1 },
	{ 0x3642, 0x28CD0 },
	{ 0x3643, 0x28E75 },
	{ 0x3644, 0x28E7B },
	{ 0x3645, 0x28F89 },
	{ 0x3646, 0x2944D },
	{ 0x3647, 0x29689 },
	{ 0x3648, 0x29692 },
	{ 0x3649, 0x2968C },
	{ 0x364A, 0x29688 },
	{ 0x364B, 0x29867 },
	{ 0x364C, 0x29868 },
	{ 0x364D, 0x20321 },
	{ 0x364E, 0x202F2 },
	{ 0x364F, 0x20309 },
	{ 0x3650, 0x202F8 },
	{ 0x3651, 0x202F0 },
	{ 0x3652, 0x202F3 },
	{ 0x3653, 0x202F5 },
	{ 0x3654, 0x202FB },
	{ 0x3655, 0x202F7 },
	{ 0x3656, 0x202EF },
	{ 0x3657, 0x2030B },
	{ 0x3658, 0x204A2 },
	{ 0x3659, 0x205F5 },
	{ 0x365A, 0x205F3 },
	{ 0x365B, 0x205F4 },
	{ 0x365C, 0x205F2 },
	{ 0x365D, 0x20698 },
	{ 0x365E, 0x20768 },
	{ 0x365F, 0x20780 },
	{ 0x3660, 0x20785 },
	{ 0x3661, 0x2078E },
	{ 0x3662, 0x2078F },
	{ 0x3663, 0x202F4 },
	{ 0x3664, 0x20786 },
	{ 0x3665, 0x207A4 },
	{ 0x3666, 0x20886 },
	{ 0x3667, 0x20889 },
	{ 0x3668, 0x20887 },
	{ 0x3669, 0x20885 },
	{ 0x366A, 0x52DC },
	{ 0x366B, 0x20888 },
	{ 0x366C, 0x20AFF },
	{ 0x366D, 0x20B66 },
	{ 0x366E, 0x35CC },
	{ 0x366F, 0x20DC3 },
	{ 0x3670, 0x35A2 },
	{ 0x3671, 0x20DC4 },
	{ 0x3672, 0x20E3B },
	{ 0x3673, 0x20DE7 },
	{ 0x3674, 0x20DF8 },
	{ 0x3675, 0x20DFB },
	{ 0x3676, 0x35B6 },
	{ 0x3677, 0x20DBE },
	{ 0x3678, 0x20DC6 },
	{ 0x3679, 0x35C5 },
	{ 0x367A, 0x35C6 },
	{ 0x367B, 0x20DFC },
	{ 0x367C, 0x20DC0 },
	{ 0x367D, 0x20E33 },
	{ 0x367E, 0x20DC9 },
	{ 0x3721, 0x20DFE },
	{ 0x3722, 0x20DDA },
	{ 0x3723, 0x20DCC },
	{ 0x3724, 0x20DBB },
	{ 0x3725, 0x20DFD },
	{ 0x3726, 0x20DDF },
	{ 0x3727, 0x20DCD },
	{ 0x3728, 0x20DC2 },
	{ 0x3729, 0x20DC8 },
	{ 0x372A, 0x20E32 },
	{ 0x372B, 0x20E2D },
	{ 0x372C, 0x20DD2 },
	{ 0x372D, 0x20E31 },
	{ 0x372E, 0x20DD3 },
	{ 0x372F, 0x20E2E },
	{ 0x3730, 0x20DCF },
	{ 0x3731, 0x211FF },
	{ 0x3732, 0x21209 },
	{ 0x3733, 0x211FC },
	{ 0x3734, 0x21372 },
	{ 0x3735, 0x213AA },
	{ 0x3736, 0x213AB },
	{ 0x3737, 0x213A7 },
	{ 0x3738, 0x2137B },
	{ 0x3739, 0x21376 },
	{ 0x373A, 0x213A8 },
	{ 0x373B, 0x213AC },
	{ 0x373C, 0x3683 },
	{ 0x373D, 0x5921 },
	{ 0x373E, 0x215AA },
	{ 0x373F, 0x20A03 },
	{ 0x3740, 0x215AC },
	{ 0x3741, 0x215AD },
	{ 0x3742, 0x215AB },
	{ 0x3743, 0x21650 },
	{ 0x3744, 0x21658 },
	{ 0x3745, 0x217DD },
	{ 0x3746, 0x36F8 },
	{ 0x3747, 0x217AE },
	{ 0x3748, 0x217A2 },
	{ 0x3749, 0x217AB },
	{ 0x374A, 0x217E3 },
	{ 0x374B, 0x217AF },
	{ 0x374C, 0x217E0 },
	{ 0x374D, 0x217E4 },
	{ 0x374E, 0x36F6 },
	{ 0x374F, 0x217A7 },
	{ 0x3750, 0x217AA },
	{ 0x3751, 0x217E2 },
	{ 0x3752, 0x217E1 },
	{ 0x3753, 0x217DF },
	{ 0x3754, 0x217AD },
	{ 0x3755, 0x217E5 },
	{ 0x3756, 0x217D1 },
	{ 0x3757, 0x217AC },
	{ 0x3758, 0x217D5 },
	{ 0x3759, 0x217A3 },
	{ 0x375A, 0x2179F },
	{ 0x375B, 0x21979 },
	{ 0x375C, 0x21976 },
	{ 0x375D, 0x21A43 },
	{ 0x375E, 0x21A3D },
	{ 0x375F, 0x21A47 },
	{ 0x3760, 0x21A44 },
	{ 0x3761, 0x21A3F },
	{ 0x3762, 0x21A5B },
	{ 0x3763, 0x21B7F },
	{ 0x3764, 0x21C9A },
	{ 0x3765, 0x21C9C },
	{ 0x3766, 0x379B },
	{ 0x3767, 0x21D1E },
	{ 0x3768, 0x21E88 },
	{ 0x3769, 0x21E6A },
	{ 0x376A, 0x21E76 },
	{ 0x376B, 0x21E72 },
	{ 0x376C, 0x21E70 },
	{ 0x376D, 0x21E7E },
	{ 0x376E, 0x21E6C },
	{ 0x376F, 0x21E6F },
	{ 0x3770, 0x21E75 },
	{ 0x3771, 0x21E77 },
	{ 0x3772, 0x21E78 },
	{ 0x3773, 0x21E8A },
	{ 0x3774, 0x21E79 },
	{ 0x3775, 0x21E94 },
	{ 0x3776, 0x22001 },
	{ 0x3777, 0x22105 },
	{ 0x3778, 0x220F1 },
	{ 0x3779, 0x220EE },
	{ 0x377A, 0x220EF },
	{ 0x377B, 0x22104 },
	{ 0x377C, 0x5E3F },
	{ 0x377D, 0x220FA },
	{ 0x377E, 0x22107 },
	{ 0x3821, 0x220F4 },
	{ 0x3822, 0x220F5 },
	{ 0x3823, 0x2219C },
	{ 0x3824, 0x2226D },
	{ 0x3825, 0x22269 },
	{ 0x3826, 0x22266 },
	{ 0x3827, 0x22262 },
	{ 0x3828, 0x22246 },
	{ 0x3829, 0x388D },
	{ 0x382A, 0x22265 },
	{ 0x382B, 0x2225D },
	{ 0x382C, 0x2225E },
	{ 0x382D, 0x2225F },
	{ 0x382E, 0x2238E },
	{ 0x382F, 0x22402 },
	{ 0x3830, 0x22406 },
	{ 0x3831, 0x22404 },
	{ 0x3832, 0x22403 },
	{ 0x3833, 0x22462 },
	{ 0x3834, 0x22527 },
	{ 0x3835, 0x22521 },
	{ 0x3836, 0x22520 },
	{ 0x3837, 0x22524 },
	{ 0x3838, 0x22529 },
	{ 0x3839, 0x22531 },
	{ 0x383A, 0x22523 },
	{ 0x383B, 0x22522 },
	{ 0x383C, 0x226DC },
	{ 0x383D, 0x2274D },
	{ 0x383E, 0x226E5 },
	{ 0x383F, 0x226D3 },
	{ 0x3840, 0x226EE },
	{ 0x3841, 0x226E6 },
	{ 0x3842, 0x3956 },
	{ 0x3843, 0x22736 },
	{ 0x3844, 0x22740 },
	{ 0x3845, 0x2283F },
	{ 0x3846, 0x2273D },
	{ 0x3847, 0x22744 },
	{ 0x3848, 0x395B },
	{ 0x3849, 0x2275F },
	{ 0x384A, 0x22729 },
	{ 0x384B, 0x22749 },
	{ 0x384C, 0x2278A },
	{ 0x384D, 0x2272A },
	{ 0x384E, 0x22787 },
	{ 0x384F, 0x2274C },
	{ 0x3850, 0x22731 },
	{ 0x3851, 0x22748 },
	{ 0x3852, 0x2272B },
	{ 0x3853, 0x2273B },
	{ 0x3854, 0x22741 },
	{ 0x3855, 0x226C9 },
	{ 0x3856, 0x22734 },
	{ 0x3857, 0x22753 },
	{ 0x3858, 0x22735 },
	{ 0x3859, 0x22747 },
	{ 0x385A, 0x22738 },
	{ 0x385B, 0x229D1 },
	{ 0x385C, 0x229D2 },
	{ 0x385D, 0x22A51 },
	{ 0x385E, 0x22A55 },
	{ 0x385F, 0x22A52 },
	{ 0x3860, 0x22A53 },
	{ 0x3861, 0x22B8F },
	{ 0x3862, 0x22BF4 },
	{ 0x3863, 0x22C47 },
	{ 0x3864, 0x22C0D },
	{ 0x3865, 0x22C1C },
	{ 0x3866, 0x22BFB },
	{ 0x3867, 0x22C19 },
	{ 0x3868, 0x22BF7 },
	{ 0x3869, 0x22BF9 },
	{ 0x386A, 0x22BF5 },
	{ 0x386B, 0x22BE9 },
	{ 0x386C, 0x22C0A },
	{ 0x386D, 0x22BEE },
	{ 0x386E, 0x22C0B },
	{ 0x386F, 0x22BFD },
	{ 0x3870, 0x22C06 },
	{ 0x3871, 0x22C02 },
	{ 0x3872, 0x22C16 },
	{ 0x3873, 0x22C18 },
	{ 0x3874, 0x22BF0 },
	{ 0x3875, 0x22ED4 },
	{ 0x3876, 0x22F66 },
	{ 0x3877, 0x22F6A },
	{ 0x3878, 0x22F75 },
	{ 0x3879, 0x22F76 },
	{ 0x387A, 0x22F80 },
	{ 0x387B, 0x22F6D },
	{ 0x387C, 0x3A96 },
	{ 0x387D, 0x22F69 },
	{ 0x387E, 0x22F67 },
	{ 0x3921, 0x22F68 },
	{ 0x3922, 0x22F5D },
	{ 0x3923, 0x230A4 },
	{ 0x3924, 0x230FE },
	{ 0x3925, 0x230FD },
	{ 0x3926, 0x231EC },
	{ 0x3927, 0x231E9 },
	{ 0x3928, 0x23221 },
	{ 0x3929, 0x231EB },
	{ 0x392A, 0x231E7 },
	{ 0x392B, 0x231F2 },
	{ 0x392C, 0x23220 },
	{ 0x392D, 0x2337A },
	{ 0x392E, 0x2352D },
	{ 0x392F, 0x2352E },
	{ 0x3930, 0x234CA },
	{ 0x3931, 0x2352F },
	{ 0x3932, 0x234C8 },
	{ 0x3933, 0x3B7E },
	{ 0x3934, 0x234CB },
	{ 0x3935, 0x234C3 },
	{ 0x3936, 0x23484 },
	{ 0x3937, 0x234D2 },
	{ 0x3938, 0x234C6 },
	{ 0x3939, 0x3B81 },
	{ 0x393A, 0x234CF },
	{ 0x393B, 0x234D5 },
	{ 0x393C, 0x234D4 },
	{ 0x393D, 0x234DD },
	{ 0x393E, 0x2352B },
	{ 0x393F, 0x235A3 },
	{ 0x3940, 0x234DB },
	{ 0x3941, 0x2352C },
	{ 0x3942, 0x23513 },
	{ 0x3943, 0x3C35 },
	{ 0x3944, 0x238D1 },
	{ 0x3945, 0x238CC },
	{ 0x3946, 0x238D5 },
	{ 0x3947, 0x238C9 },
	{ 0x3948, 0x238CF },
	{ 0x3949, 0x238D2 },
	{ 0x394A, 0x2397B },
	{ 0x394B, 0x2397C },
	{ 0x394C, 0x23A23 },
	{ 0x394D, 0x23A1D },
	{ 0x394E, 0x23A1C },
	{ 0x394F, 0x23A1E },
	{ 0x3950, 0x23A22 },
	{ 0x3951, 0x23A24 },
	{ 0x3952, 0x23A20 },
	{ 0x3953, 0x23A18 },
	{ 0x3954, 0x23A21 },
	{ 0x3955, 0x23B88 },
	{ 0x3956, 0x23B8A },
	{ 0x3957, 0x23B94 },
	{ 0x3958, 0x23B8F },
	{ 0x3959, 0x23B8E },
	{ 0x395A, 0x23B90 },
	{ 0x395B, 0x3C9B },
	{ 0x395C, 0x23BA7 },
	{ 0x395D, 0x23C64 },
	{ 0x395E, 0x3D00 },
	{ 0x395F, 0x23E18 },
	{ 0x3960, 0x23E14 },
	{ 0x3961, 0x23E1D },
	{ 0x3962, 0x23E05 },
	{ 0x3963, 0x23DFF },
	{ 0x3964, 0x23E1B },
	{ 0x3965, 0x23E1A },
	{ 0x3966, 0x23E19 },
	{ 0x3967, 0x23E03 },
	{ 0x3968, 0x23E0E },
	{ 0x3969, 0x23E47 },
	{ 0x396A, 0x23E04 },
	{ 0x396B, 0x23E5A },
	{ 0x396C, 0x23E07 },
	{ 0x396D, 0x23E20 },
	{ 0x396E, 0x2426A },
	{ 0x396F, 0x24266 },
	{ 0x3970, 0x2427A },
	{ 0x3971, 0x24265 },
	{ 0x3972, 0x242AF },
	{ 0x3973, 0x245CD },
	{ 0x3974, 0x245CF },
	{ 0x3975, 0x245D1 },
	{ 0x3976, 0x245CE },
	{ 0x3977, 0x2465F },
	{ 0x3978, 0x24677 },
	{ 0x3979, 0x24674 },
	{ 0x397A, 0x24688 },
	{ 0x397B, 0x24675 },
	{ 0x397C, 0x24689 },
	{ 0x397D, 0x24672 },
	{ 0x397E, 0x247C6 },
	{ 0x3A21, 0x247EA },
	{ 0x3A22, 0x247E0 },
	{ 0x3A23, 0x24807 },
	{ 0x3A24, 0x247E6 },
	{ 0x3A25, 0x247E5 },
	{ 0x3A26, 0x247DD },
	{ 0x3A27, 0x247E3 },
	{ 0x3A28, 0x247DA },
	{ 0x3A29, 0x249AE },
	{ 0x3A2A, 0x2497E },
	{ 0x3A2B, 0x2497D },
	{ 0x3A2C, 0x2497F },
	{ 0x3A2D, 0x3ED3 },
	{ 0x3A2E, 0x249D9 },
	{ 0x3A2F, 0x24AFA },
	{ 0x3A30, 0x24AFB },
	{ 0x3A31, 0x24B4D },
	{ 0x3A32, 0x24B54 },
	{ 0x3A33, 0x24B51 },
	{ 0x3A34, 0x24B50 },
	{ 0x3A35, 0x24D98 },
	{ 0x3A36, 0x24D95 },
	{ 0x3A37, 0x24D9D },
	{ 0x3A38, 0x24DC1 },
	{ 0x3A39, 0x24D9A },
	{ 0x3A3A, 0x24D9B },
	{ 0x3A3B, 0x3F9F },
	{ 0x3A3C, 0x24D9C },
	{ 0x3A3D, 0x24DD7 },
	{ 0x3A3E, 0x24DA4 },
	{ 0x3A3F, 0x24D96 },
	{ 0x3A40, 0x24DA0 },
	{ 0x3A41, 0x24F31 },
	{ 0x3A42, 0x24FE9 },
	{ 0x3A43, 0x2506E },
	{ 0x3A44, 0x2519A },
	{ 0x3A45, 0x251A5 },
	{ 0x3A46, 0x25194 },
	{ 0x3A47, 0x251A6 },
	{ 0x3A48, 0x25199 },
	{ 0x3A49, 0x2518B },
	{ 0x3A4A, 0x25198 },
	{ 0x3A4B, 0x25191 },
	{ 0x3A4C, 0x2518C },
	{ 0x3A4D, 0x251A1 },
	{ 0x3A4E, 0x251A3 },
	{ 0x3A4F, 0x251C6 },
	{ 0x3A50, 0x2536F },
	{ 0x3A51, 0x2536D },
	{ 0x3A52, 0x2536A },
	{ 0x3A53, 0x2536C },
	{ 0x3A54, 0x25371 },
	{ 0x3A55, 0x2536E },
	{ 0x3A56, 0x253DF },
	{ 0x3A57, 0x254AC },
	{ 0x3A58, 0x254AA },
	{ 0x3A59, 0x40B1 },
	{ 0x3A5A, 0x254B5 },
	{ 0x3A5B, 0x254AD },
	{ 0x3A5C, 0x254B2 },
	{ 0x3A5D, 0x254B3 },
	{ 0x3A5E, 0x254AB },
	{ 0x3A5F, 0x254B6 },
	{ 0x3A60, 0x254C7 },
	{ 0x3A61, 0x254C6 },
	{ 0x3A62, 0x2566C },
	{ 0x3A63, 0x25670 },
	{ 0x3A64, 0x257B3 },
	{ 0x3A65, 0x414B },
	{ 0x3A66, 0x2598C },
	{ 0x3A67, 0x25981 },
	{ 0x3A68, 0x25983 },
	{ 0x3A69, 0x2597D },
	{ 0x3A6A, 0x25985 },
	{ 0x3A6B, 0x25990 },
	{ 0x3A6C, 0x259A2 },
	{ 0x3A6D, 0x2598D },
	{ 0x3A6E, 0x2598F },
	{ 0x3A6F, 0x2597E },
	{ 0x3A70, 0x2598A },
	{ 0x3A71, 0x2597F },
	{ 0x3A72, 0x25976 },
	{ 0x3A73, 0x25987 },
	{ 0x3A74, 0x25978 },
	{ 0x3A75, 0x25A80 },
	{ 0x3A76, 0x25A82 },
	{ 0x3A77, 0x25A81 },
	{ 0x3A78, 0x25A83 },
	{ 0x3A79, 0x25B5A },
	{ 0x3A7A, 0x25B34 },
	{ 0x3A7B, 0x25B2C },
	{ 0x3A7C, 0x25B2A },
	{ 0x3A7D, 0x25B40 },
	{ 0x3A7E, 0x25B2D },
	{ 0x3B21, 0x25B33 },
	{ 0x3B22, 0x25B2B },
	{ 0x3B23, 0x25B4B },
	{ 0x3B24, 0x7B3F },
	{ 0x3B25, 0x25B3C },
	{ 0x3B26, 0x25E5A },
	{ 0x3B27, 0x25E77 },
	{ 0x3B28, 0x25E60 },
	{ 0x3B29, 0x25FFA },
	{ 0x3B2A, 0x25FF9 },
	{ 0x3B2B, 0x25FFC },
	{ 0x3B2C, 0x42D6 },
	{ 0x3B2D, 0x25FF5 },
	{ 0x3B2E, 0x25FE8 },
	{ 0x3B2F, 0x26009 },
	{ 0x3B30, 0x25FE7 },
	{ 0x3B31, 0x25FE6 },
	{ 0x3B32, 0x25FE9 },
	{ 0x3B33, 0x26232 },
	{ 0x3B34, 0x2622C },
	{ 0x3B35, 0x262BD },
	{ 0x3B36, 0x262BC },
	{ 0x3B37, 0x2637A },
	{ 0x3B38, 0x2637E },
	{ 0x3B39, 0x26379 },
	{ 0x3B3A, 0x4389 },
	{ 0x3B3B, 0x26423 },
	{ 0x3B3C, 0x26430 },
	{ 0x3B3D, 0x26428 },
	{ 0x3B3E, 0x264D4 },
	{ 0x3B3F, 0x26ACE },
	{ 0x3B40, 0x264F1 },
	{ 0x3B41, 0x264F0 },
	{ 0x3B42, 0x26560 },
	{ 0x3B43, 0x26565 },
	{ 0x3B44, 0x266A8 },
	{ 0x3B45, 0x2670A },
	{ 0x3B46, 0x2671B },
	{ 0x3B47, 0x26712 },
	{ 0x3B48, 0x26707 },
	{ 0x3B49, 0x2674F },
	{ 0x3B4A, 0x2670E },
	{ 0x3B4B, 0x26752 },
	{ 0x3B4C, 0x26716 },
	{ 0x3B4D, 0x4400 },
	{ 0x3B4E, 0x26753 },
	{ 0x3B4F, 0x26754 },
	{ 0x3B50, 0x2F984 },
	{ 0x3B51, 0x26756 },
	{ 0x3B52, 0x2696D },
	{ 0x3B53, 0x26972 },
	{ 0x3B54, 0x26A2F },
	{ 0x3B55, 0x26C2A },
	{ 0x3B56, 0x44DC },
	{ 0x3B57, 0x26C63 },
	{ 0x3B58, 0x26C84 },
	{ 0x3B59, 0x26CAF },
	{ 0x3B5A, 0x26C45 },
	{ 0x3B5B, 0x26C70 },
	{ 0x3B5C, 0x26C56 },
	{ 0x3B5D, 0x26C16 },
	{ 0x3B5E, 0x26C3D },
	{ 0x3B5F, 0x26C38 },
	{ 0x3B60, 0x26C6F },
	{ 0x3B61, 0x26C77 },
	{ 0x3B62, 0x26C2E },
	{ 0x3B63, 0x26C31 },
	{ 0x3B64, 0x26C4C },
	{ 0x3B65, 0x26C5F },
	{ 0x3B66, 0x26C75 },
	{ 0x3B67, 0x26C39 },
	{ 0x3B68, 0x26C3A },
	{ 0x3B69, 0x26C2C },
	{ 0x3B6A, 0x26C2D },
	{ 0x3B6B, 0x26C3F },
	{ 0x3B6C, 0x26C2F },
	{ 0x3B6D, 0x26C30 },
	{ 0x3B6E, 0x26C3E },
	{ 0x3B6F, 0x83D0 },
	{ 0x3B70, 0x4590 },
	{ 0x3B71, 0x271B2 },
	{ 0x3B72, 0x272B7 },
	{ 0x3B73, 0x2728F },
	{ 0x3B74, 0x45B1 },
	{ 0x3B75, 0x27296 },
	{ 0x3B76, 0x2729E },
	{ 0x3B77, 0x27297 },
	{ 0x3B78, 0x27295 },
	{ 0x3B79, 0x272A5 },
	{ 0x3B7A, 0x27298 },
	{ 0x3B7B, 0x86E7 },
	{ 0x3B7C, 0x272A3 },
	{ 0x3B7D, 0x2729A },
	{ 0x3B7E, 0x272AD },
	{ 0x3C21, 0x272A6 },
	{ 0x3C22, 0x272B6 },
	{ 0x3C23, 0x27299 },
	{ 0x3C24, 0x272AF },
	{ 0x3C25, 0x272AC },
	{ 0x3C26, 0x45AA },
	{ 0x3C27, 0x2729F },
	{ 0x3C28, 0x27294 },
	{ 0x3C29, 0x275EB },
	{ 0x3C2A, 0x2766F },
	{ 0x3C2B, 0x2766D },
	{ 0x3C2C, 0x2767E },
	{ 0x3C2D, 0x2766C },
	{ 0x3C2E, 0x27661 },
	{ 0x3C2F, 0x27663 },
	{ 0x3C30, 0x2766B },
	{ 0x3C31, 0x2765E },
	{ 0x3C32, 0x2763E },
	{ 0x3C33, 0x27664 },
	{ 0x3C34, 0x276AD },
	{ 0x3C35, 0x467D },
	{ 0x3C36, 0x27820 },
	{ 0x3C37, 0x278D1 },
	{ 0x3C38, 0x278D5 },
	{ 0x3C39, 0x279AE },
	{ 0x3C3A, 0x279AF },
	{ 0x3C3B, 0x2799F },
	{ 0x3C3C, 0x279A8 },
	{ 0x3C3D, 0x279CA },
	{ 0x3C3E, 0x27BE1 },
	{ 0x3C3F, 0x27C39 },
	{ 0x3C40, 0x27C38 },
	{ 0x3C41, 0x27C3B },
	{ 0x3C42, 0x27CAD },
	{ 0x3C43, 0x27CB5 },
	{ 0x3C44, 0x27CAF },
	{ 0x3C45, 0x27CB1 },
	{ 0x3C46, 0x27CAE },
	{ 0x3C47, 0x27CB4 },
	{ 0x3C48, 0x27CB0 },
	{ 0x3C49, 0x27D4B },
	{ 0x3C4A, 0x27D51 },
	{ 0x3C4B, 0x27D4C },
	{ 0x3C4C, 0x4769 },
	{ 0x3C4D, 0x27D60 },
	{ 0x3C4E, 0x27EBE },
	{ 0x3C4F, 0x27EB9 },
	{ 0x3C50, 0x27EB7 },
	{ 0x3C51, 0x27EB6 },
	{ 0x3C52, 0x47A1 },
	{ 0x3C53, 0x27EBD },
	{ 0x3C54, 0x27EB8 },
	{ 0x3C55, 0x27EC1 },
	{ 0x3C56, 0x27FF7 },
	{ 0x3C57, 0x27FF3 },
	{ 0x3C58, 0x27FF4 },
	{ 0x3C59, 0x27FFB },
	{ 0x3C5A, 0x27FFD },
	{ 0x3C5B, 0x27FF5 },
	{ 0x3C5C, 0x47E7 },
	{ 0x3C5D, 0x27FFA },
	{ 0x3C5E, 0x28014 },
	{ 0x3C5F, 0x47EC },
	{ 0x3C60, 0x27FF2 },
	{ 0x3C61, 0x27FFC },
	{ 0x3C62, 0x28000 },
	{ 0x3C63, 0x47DF },
	{ 0x3C64, 0x2822B },
	{ 0x3C65, 0x28229 },
	{ 0x3C66, 0x2822E },
	{ 0x3C67, 0x4833 },
	{ 0x3C68, 0x282D7 },
	{ 0x3C69, 0x282DB },
	{ 0x3C6A, 0x282D9 },
	{ 0x3C6B, 0x282D8 },
	{ 0x3C6C, 0x282E6 },
	{ 0x3C6D, 0x282D6 },
	{ 0x3C6E, 0x282D1 },
	{ 0x3C6F, 0x282E7 },
	{ 0x3C70, 0x282D0 },
	{ 0x3C71, 0x282DC },
	{ 0x3C72, 0x284ED },
	{ 0x3C73, 0x2851A },
	{ 0x3C74, 0x28519 },
	{ 0x3C75, 0x28516 },
	{ 0x3C76, 0x284EC },
	{ 0x3C77, 0x284EF },
	{ 0x3C78, 0x284EE },
	{ 0x3C79, 0x284F4 },
	{ 0x3C7A, 0x2852F },
	{ 0x3C7B, 0x28730 },
	{ 0x3C7C, 0x28719 },
	{ 0x3C7D, 0x28718 },
	{ 0x3C7E, 0x28711 },
	{ 0x3D21, 0x28716 },
	{ 0x3D22, 0x28712 },
	{ 0x3D23, 0x28710 },
	{ 0x3D24, 0x28714 },
	{ 0x3D25, 0x2880C },
	{ 0x3D26, 0x2880D },
	{ 0x3D27, 0x28910 },
	{ 0x3D28, 0x28929 },
	{ 0x3D29, 0x28928 },
	{ 0x3D2A, 0x28C65 },
	{ 0x3D2B, 0x28C66 },
	{ 0x3D2C, 0x28CDE },
	{ 0x3D2D, 0x28CDF },
	{ 0x3D2E, 0x28CE0 },
	{ 0x3D2F, 0x28CD9 },
	{ 0x3D30, 0x28CDB },
	{ 0x3D31, 0x28CD8 },
	{ 0x3D32, 0x28CE3 },
	{ 0x3D33, 0x28CD7 },
	{ 0x3D34, 0x28EA6 },
	{ 0x3D35, 0x28EA7 },
	{ 0x3D36, 0x28EBF },
	{ 0x3D37, 0x28EA8 },
	{ 0x3D38, 0x28E9F },
	{ 0x3D39, 0x28EA1 },
	{ 0x3D3A, 0x28EA2 },
	{ 0x3D3B, 0x28EAD },
	{ 0x3D3C, 0x28EA3 },
	{ 0x3D3D, 0x28EA0 },
	{ 0x3D3E, 0x29083 },
	{ 0x3D3F, 0x29085 },
	{ 0x3D40, 0x29082 },
	{ 0x3D41, 0x29084 },
	{ 0x3D42, 0x291EE },
	{ 0x3D43, 0x2925D },
	{ 0x3D44, 0x29392 },
	{ 0x3D45, 0x29455 },
	{ 0x3D46, 0x29453 },
	{ 0x3D47, 0x2F9FC },
	{ 0x3D48, 0x29451 },
	{ 0x3D49, 0x29452 },
	{ 0x3D4A, 0x29450 },
	{ 0x3D4B, 0x2959D },
	{ 0x3D4C, 0x29687 },
	{ 0x3D4D, 0x29697 },
	{ 0x3D4E, 0x2969B },
	{ 0x3D4F, 0x2969D },
	{ 0x3D50, 0x29869 },
	{ 0x3D51, 0x29A11 },
	{ 0x3D52, 0x4BEE },
	{ 0x3D53, 0x29C7A },
	{ 0x3D54, 0x4C32 },
	{ 0x3D55, 0x23244 },
	{ 0x3D56, 0x200C6 },
	{ 0x3D57, 0x20340 },
	{ 0x3D58, 0x2032E },
	{ 0x3D59, 0x20368 },
	{ 0x3D5A, 0x2032D },
	{ 0x3D5B, 0x20334 },
	{ 0x3D5C, 0x20332 },
	{ 0x3D5D, 0x20369 },
	{ 0x3D5E, 0x20331 },
	{ 0x3D5F, 0x2036A },
	{ 0x3D60, 0x2033E },
	{ 0x3D61, 0x2036F },
	{ 0x3D62, 0x20375 },
	{ 0x3D63, 0x204F6 },
	{ 0x3D64, 0x20520 },
	{ 0x3D65, 0x20528 },
	{ 0x3D66, 0x20567 },
	{ 0x3D67, 0x205FB },
	{ 0x3D68, 0x205FE },
	{ 0x3D69, 0x205FC },
	{ 0x3D6A, 0x205FD },
	{ 0x3D6B, 0x205FF },
	{ 0x3D6C, 0x205FA },
	{ 0x3D6D, 0x207AC },
	{ 0x3D6E, 0x207AF },
	{ 0x3D6F, 0x207B1 },
	{ 0x3D70, 0x34FC },
	{ 0x3D71, 0x207BF },
	{ 0x3D72, 0x207BE },
	{ 0x3D73, 0x207A7 },
	{ 0x3D74, 0x207AA },
	{ 0x3D75, 0x20894 },
	{ 0x3D76, 0x20893 },
	{ 0x3D77, 0x20899 },
	{ 0x3D78, 0x352A },
	{ 0x3D79, 0x208FA },
	{ 0x3D7A, 0x20956 },
	{ 0x3D7B, 0x20A22 },
	{ 0x3D7C, 0x20A91 },
	{ 0x3D7D, 0x20A92 },
	{ 0x3D7E, 0x20B08 },
	{ 0x3E21, 0x20B06 },
	{ 0x3E22, 0x20DD6 },
	{ 0x3E23, 0x20E37 },
	{ 0x3E24, 0x20E4B },
	{ 0x3E25, 0x20ECE },
	{ 0x3E26, 0x20ED0 },
	{ 0x3E27, 0x20E39 },
	{ 0x3E28, 0x20E64 },
	{ 0x3E29, 0x20ECF },
	{ 0x3E2A, 0x20E46 },
	{ 0x3E2B, 0x20E66 },
	{ 0x3E2C, 0x20E56 },
	{ 0x3E2D, 0x20E43 },
	{ 0x3E2E, 0x20E4A },
	{ 0x3E2F, 0x20E58 },
	{ 0x3E30, 0x20E65 },
	{ 0x3E31, 0x20E5A },
	{ 0x3E32, 0x20E5B },
	{ 0x3E33, 0x20E55 },
	{ 0x3E34, 0x20E50 },
	{ 0x3E35, 0x20E4C },
	{ 0x3E36, 0x20ECD },
	{ 0x3E37, 0x20E51 },
	{ 0x3E38, 0x20E47 },
	{ 0x3E39, 0x35D3 },
	{ 0x3E3A, 0x20E53 },
	{ 0x3E3B, 0x20E62 },
	{ 0x3E3C, 0x20ECC },
	{ 0x3E3D, 0x35D7 },
	{ 0x3E3E, 0x20E7F },
	{ 0x3E3F, 0x20E4D },
	{ 0x3E40, 0x2120A },
	{ 0x3E41, 0x2120C },
	{ 0x3E42, 0x2120F },
	{ 0x3E43, 0x213BB },
	{ 0x3E44, 0x213B9 },
	{ 0x3E45, 0x213EB },
	{ 0x3E46, 0x213AE },
	{ 0x3E47, 0x213C1 },
	{ 0x3E48, 0x213EA },
	{ 0x3E49, 0x213BE },
	{ 0x3E4A, 0x213BF },
	{ 0x3E4B, 0x213BA },
	{ 0x3E4C, 0x213B7 },
	{ 0x3E4D, 0x213B3 },
	{ 0x3E4E, 0x213E9 },
	{ 0x3E4F, 0x2156E },
	{ 0x3E50, 0x215AF },
	{ 0x3E51, 0x215B3 },
	{ 0x3E52, 0x215B2 },
	{ 0x3E53, 0x21668 },
	{ 0x3E54, 0x21669 },
	{ 0x3E55, 0x2166A },
	{ 0x3E56, 0x217DE },
	{ 0x3E57, 0x217EB },
	{ 0x3E58, 0x21811 },
	{ 0x3E59, 0x217ED },
	{ 0x3E5A, 0x217E9 },
	{ 0x3E5B, 0x217F7 },
	{ 0x3E5C, 0x217F4 },
	{ 0x3E5D, 0x217EA },
	{ 0x3E5E, 0x21812 },
	{ 0x3E5F, 0x217E8 },
	{ 0x3E60, 0x21813 },
	{ 0x3E61, 0x2198E },
	{ 0x3E62, 0x21986 },
	{ 0x3E63, 0x21A63 },
	{ 0x3E64, 0x21A65 },
	{ 0x3E65, 0x21B99 },
	{ 0x3E66, 0x21CC2 },
	{ 0x3E67, 0x21CAE },
	{ 0x3E68, 0x21CB0 },
	{ 0x3E69, 0x21CAD },
	{ 0x3E6A, 0x21EB4 },
	{ 0x3E6B, 0x21ED1 },
	{ 0x3E6C, 0x21EAD },
	{ 0x3E6D, 0x37F3 },
	{ 0x3E6E, 0x21EBD },
	{ 0x3E6F, 0x21EB7 },
	{ 0x3E70, 0x21EAB },
	{ 0x3E71, 0x21EAF },
	{ 0x3E72, 0x21EC1 },
	{ 0x3E73, 0x21EB5 },
	{ 0x3E74, 0x2210F },
	{ 0x3E75, 0x2210E },
	{ 0x3E76, 0x2211C },
	{ 0x3E77, 0x22113 },
	{ 0x3E78, 0x2210A },
	{ 0x3E79, 0x2211E },
	{ 0x3E7A, 0x22114 },
	{ 0x3E7B, 0x2211A },
	{ 0x3E7C, 0x221CB },
	{ 0x3E7D, 0x22287 },
	{ 0x3E7E, 0x22293 },
	{ 0x3F21, 0x3891 },
	{ 0x3F22, 0x22284 },
	{ 0x3F23, 0x22285 },
	{ 0x3F24, 0x22292 },
	{ 0x3F25, 0x22280 },
	{ 0x3F26, 0x2232B },
	{ 0x3F27, 0x22363 },
	{ 0x3F28, 0x2240A },
	{ 0x3F29, 0x38C0 },
	{ 0x3F2A, 0x22466 },
	{ 0x3F2B, 0x22534 },
	{ 0x3F2C, 0x22533 },
	{ 0x3F2D, 0x2254D },
	{ 0x3F2E, 0x22789 },
	{ 0x3F2F, 0x22757 },
	{ 0x3F30, 0x6117 },
	{ 0x3F31, 0x2274A },
	{ 0x3F32, 0x3963 },
	{ 0x3F33, 0x22739 },
	{ 0x3F34, 0x2273F },
	{ 0x3F35, 0x22790 },
	{ 0x3F36, 0x2278F },
	{ 0x3F37, 0x227B2 },
	{ 0x3F38, 0x2279F },
	{ 0x3F39, 0x22795 },
	{ 0x3F3A, 0x227A1 },
	{ 0x3F3B, 0x2279C },
	{ 0x3F3C, 0x2278E },
	{ 0x3F3D, 0x227A0 },
	{ 0x3F3E, 0x227AE },
	{ 0x3F3F, 0x22796 },
	{ 0x3F40, 0x227CA },
	{ 0x3F41, 0x227AC },
	{ 0x3F42, 0x3970 },
	{ 0x3F43, 0x227A6 },
	{ 0x3F44, 0x22797 },
	{ 0x3F45, 0x22793 },
	{ 0x3F46, 0x203B6 },
	{ 0x3F47, 0x229D6 },
	{ 0x3F48, 0x229E0 },
	{ 0x3F49, 0x229D8 },
	{ 0x3F4A, 0x22A56 },
	{ 0x3F4B, 0x22C6E },
	{ 0x3F4C, 0x22C7E },
	{ 0x3F4D, 0x22C74 },
	{ 0x3F4E, 0x22C77 },
	{ 0x3F4F, 0x22C80 },
	{ 0x3F50, 0x22C7A },
	{ 0x3F51, 0x22C6B },
	{ 0x3F52, 0x22C5F },
	{ 0x3F53, 0x22C76 },
	{ 0x3F54, 0x22CB0 },
	{ 0x3F55, 0x22C63 },
	{ 0x3F56, 0x22F92 },
	{ 0x3F57, 0x22F82 },
	{ 0x3F58, 0x22F9D },
	{ 0x3F59, 0x22F94 },
	{ 0x3F5A, 0x22F83 },
	{ 0x3F5B, 0x22F8B },
	{ 0x3F5C, 0x22F84 },
	{ 0x3F5D, 0x23057 },
	{ 0x3F5E, 0x23084 },
	{ 0x3F5F, 0x230B5 },
	{ 0x3F60, 0x23109 },
	{ 0x3F61, 0x231E6 },
	{ 0x3F62, 0x3B02 },
	{ 0x3F63, 0x23225 },
	{ 0x3F64, 0x23251 },
	{ 0x3F65, 0x2333E },
	{ 0x3F66, 0x2F8DA },
	{ 0x3F67, 0x23385 },
	{ 0x3F68, 0x2353F },
	{ 0x3F69, 0x23542 },
	{ 0x3F6A, 0x23538 },
	{ 0x3F6B, 0x2353A },
	{ 0x3F6C, 0x2354E },
	{ 0x3F6D, 0x23545 },
	{ 0x3F6E, 0x23539 },
	{ 0x3F6F, 0x23537 },
	{ 0x3F70, 0x23544 },
	{ 0x3F71, 0x2F8E7 },
	{ 0x3F72, 0x235A4 },
	{ 0x3F73, 0x2353D },
	{ 0x3F74, 0x23541 },
	{ 0x3F75, 0x238DF },
	{ 0x3F76, 0x238DE },
	{ 0x3F77, 0x238CA },
	{ 0x3F78, 0x238E9 },
	{ 0x3F79, 0x238E2 },
	{ 0x3F7A, 0x238E0 },
	{ 0x3F7B, 0x23989 },
	{ 0x3F7C, 0x23987 },
	{ 0x3F7D, 0x23A32 },
	{ 0x3F7E, 0x23A33 },
	{ 0x4021, 0x23AAC },
	{ 0x4022, 0x23AF9 },
	{ 0x4023, 0x23B0D },
	{ 0x4024, 0x23BB9 },
	{ 0x4025, 0x23E5E },
	{ 0x4026, 0x23E6A },
	{ 0x4027, 0x3D35 },
	{ 0x4028, 0x23E81 },
	{ 0x4029, 0x23E69 },
	{ 0x402A, 0x23EAC },
	{ 0x402B, 0x23E80 },
	{ 0x402C, 0x23E75 },
	{ 0x402D, 0x23E71 },
	{ 0x402E, 0x23E76 },
	{ 0x402F, 0x23E6F },
	{ 0x4030, 0x242B6 },
	{ 0x4031, 0x24303 },
	{ 0x4032, 0x242BF },
	{ 0x4033, 0x24301 },
	{ 0x4034, 0x242B2 },
	{ 0x4035, 0x242C4 },
	{ 0x4036, 0x245DB },
	{ 0x4037, 0x245DC },
	{ 0x4038, 0x245D8 },
	{ 0x4039, 0x29672 },
	{ 0x403A, 0x246B5 },
	{ 0x403B, 0x246A8 },
	{ 0x403C, 0x2468F },
	{ 0x403D, 0x2469E },
	{ 0x403E, 0x2468E },
	{ 0x403F, 0x247DE },
	{ 0x4040, 0x247E2 },
	{ 0x4041, 0x24820 },
	{ 0x4042, 0x2481D },
	{ 0x4043, 0x2481A },
	{ 0x4044, 0x24819 },
	{ 0x4045, 0x2482B },
	{ 0x4046, 0x24818 },
	{ 0x4047, 0x24810 },
	{ 0x4048, 0x2480E },
	{ 0x4049, 0x24824 },
	{ 0x404A, 0x2481F },
	{ 0x404B, 0x24813 },
	{ 0x404C, 0x24835 },
	{ 0x404D, 0x24983 },
	{ 0x404E, 0x3EE0 },
	{ 0x404F, 0x249D7 },
	{ 0x4050, 0x24B02 },
	{ 0x4051, 0x24B03 },
	{ 0x4052, 0x24B5C },
	{ 0x4053, 0x24B5F },
	{ 0x4054, 0x24BC7 },
	{ 0x4055, 0x24C9A },
	{ 0x4056, 0x24C97 },
	{ 0x4057, 0x24CA3 },
	{ 0x4058, 0x24DF7 },
	{ 0x4059, 0x24DC6 },
	{ 0x405A, 0x24DCC },
	{ 0x405B, 0x24DD6 },
	{ 0x405C, 0x24DCD },
	{ 0x405D, 0x24DF9 },
	{ 0x405E, 0x24DD9 },
	{ 0x405F, 0x24DD8 },
	{ 0x4060, 0x3F9A },
	{ 0x4061, 0x24DD1 },
	{ 0x4062, 0x24DCE },
	{ 0x4063, 0x24DD5 },
	{ 0x4064, 0x3FA3 },
	{ 0x4065, 0x24DD4 },
	{ 0x4066, 0x24DF8 },
	{ 0x4067, 0x24F7A },
	{ 0x4068, 0x24F79 },
	{ 0x4069, 0x24F7F },
	{ 0x406A, 0x24FF3 },
	{ 0x406B, 0x24FF5 },
	{ 0x406C, 0x24FF6 },
	{ 0x406D, 0x24FF4 },
	{ 0x406E, 0x24FF7 },
	{ 0x406F, 0x4005 },
	{ 0x4070, 0x25079 },
	{ 0x4071, 0x2519C },
	{ 0x4072, 0x251DF },
	{ 0x4073, 0x251F5 },
	{ 0x4074, 0x251FF },
	{ 0x4075, 0x251D1 },
	{ 0x4076, 0x251DA },
	{ 0x4077, 0x251CF },
	{ 0x4078, 0x251CD },
	{ 0x4079, 0x251DE },
	{ 0x407A, 0x251D8 },
	{ 0x407B, 0x23AAD },
	{ 0x407C, 0x251E0 },
	{ 0x407D, 0x251FE },
	{ 0x407E, 0x2519E },
	{ 0x4121, 0x25375 },
	{ 0x4122, 0x25373 },
	{ 0x4123, 0x25372 },
	{ 0x4124, 0x253D8 },
	{ 0x4125, 0x254D0 },
	{ 0x4126, 0x254D6 },
	{ 0x4127, 0x254D7 },
	{ 0x4128, 0x254CA },
	{ 0x4129, 0x254CD },
	{ 0x412A, 0x2568A },
	{ 0x412B, 0x25689 },
	{ 0x412C, 0x2568B },
	{ 0x412D, 0x257D3 },
	{ 0x412E, 0x257DA },
	{ 0x412F, 0x257CE },
	{ 0x4130, 0x257D2 },
	{ 0x4131, 0x415E },
	{ 0x4132, 0x257D4 },
	{ 0x4133, 0x257D7 },
	{ 0x4134, 0x257D5 },
	{ 0x4135, 0x257FB },
	{ 0x4136, 0x257CD },
	{ 0x4137, 0x257FA },
	{ 0x4138, 0x257D6 },
	{ 0x4139, 0x41A6 },
	{ 0x413A, 0x2599B },
	{ 0x413B, 0x2599E },
	{ 0x413C, 0x2599D },
	{ 0x413D, 0x259A4 },
	{ 0x413E, 0x2599F },
	{ 0x413F, 0x259A5 },
	{ 0x4140, 0x259A8 },
	{ 0x4141, 0x25A8F },
	{ 0x4142, 0x25A8C },
	{ 0x4143, 0x25A95 },
	{ 0x4144, 0x25B60 },
	{ 0x4145, 0x25B55 },
	{ 0x4146, 0x25B5C },
	{ 0x4147, 0x25B6F },
	{ 0x4148, 0x25B51 },
	{ 0x4149, 0x25B61 },
	{ 0x414A, 0x25BA7 },
	{ 0x414B, 0x25B5E },
	{ 0x414C, 0x25B62 },
	{ 0x414D, 0x25B54 },
	{ 0x414E, 0x25B6E },
	{ 0x414F, 0x25B52 },
	{ 0x4150, 0x25B58 },
	{ 0x4151, 0x25B6D },
	{ 0x4152, 0x25B5F },
	{ 0x4153, 0x25B6C },
	{ 0x4154, 0x25B50 },
	{ 0x4155, 0x25B5D },
	{ 0x4156, 0x25B8E },
	{ 0x4157, 0x25E72 },
	{ 0x4158, 0x25E78 },
	{ 0x4159, 0x25E75 },
	{ 0x415A, 0x25E76 },
	{ 0x415B, 0x25E7C },
	{ 0x415C, 0x25E7E },
	{ 0x415D, 0x25E7D },
	{ 0x415E, 0x26015 },
	{ 0x415F, 0x26014 },
	{ 0x4160, 0x2601D },
	{ 0x4161, 0x2601C },
	{ 0x4162, 0x26023 },
	{ 0x4163, 0x26057 },
	{ 0x4164, 0x262C8 },
	{ 0x4165, 0x435D },
	{ 0x4166, 0x262C9 },
	{ 0x4167, 0x262C5 },
	{ 0x4168, 0x26387 },
	{ 0x4169, 0x2638A },
	{ 0x416A, 0x26394 },
	{ 0x416B, 0x26439 },
	{ 0x416C, 0x26440 },
	{ 0x416D, 0x2643E },
	{ 0x416E, 0x26438 },
	{ 0x416F, 0x264D6 },
	{ 0x4170, 0x43B8 },
	{ 0x4171, 0x26577 },
	{ 0x4172, 0x26578 },
	{ 0x4173, 0x2657D },
	{ 0x4174, 0x266DD },
	{ 0x4175, 0x2675E },
	{ 0x4176, 0x26777 },
	{ 0x4177, 0x267D4 },
	{ 0x4178, 0x26766 },
	{ 0x4179, 0x2675F },
	{ 0x417A, 0x26773 },
	{ 0x417B, 0x26772 },
	{ 0x417C, 0x26797 },
	{ 0x417D, 0x2675A },
	{ 0x417E, 0x26796 },
	{ 0x4221, 0x2675D },
	{ 0x4222, 0x26765 },
	{ 0x4223, 0x26770 },
	{ 0x4224, 0x26775 },
	{ 0x4225, 0x26774 },
	{ 0x4226, 0x2675C },
	{ 0x4227, 0x26760 },
	{ 0x4228, 0x4434 },
	{ 0x4229, 0x2676D },
	{ 0x422A, 0x26941 },
	{ 0x422B, 0x26A3C },
	{ 0x422C, 0x26A3E },
	{ 0x422D, 0x446F },
	{ 0x422E, 0x26A49 },
	{ 0x422F, 0x26BE4 },
	{ 0x4230, 0x26D0C },
	{ 0x4231, 0x26D15 },
	{ 0x4232, 0x26D0E },
	{ 0x4233, 0x26CD4 },
	{ 0x4234, 0x26CC7 },
	{ 0x4235, 0x26D14 },
	{ 0x4236, 0x26CDB },
	{ 0x4237, 0x26D5F },
	{ 0x4238, 0x26CED },
	{ 0x4239, 0x26D09 },
	{ 0x423A, 0x26CCF },
	{ 0x423B, 0x26CFF },
	{ 0x423C, 0x26D1A },
	{ 0x423D, 0x26CF5 },
	{ 0x423E, 0x26CEE },
	{ 0x423F, 0x26CE5 },
	{ 0x4240, 0x26D0D },
	{ 0x4241, 0x26CDF },
	{ 0x4242, 0x26CEC },
	{ 0x4243, 0x26CD7 },
	{ 0x4244, 0x26D2C },
	{ 0x4245, 0x26CCD },
	{ 0x4246, 0x26CE3 },
	{ 0x4247, 0x26D00 },
	{ 0x4248, 0x26CEB },
	{ 0x4249, 0x26CFD },
	{ 0x424A, 0x26D0F },
	{ 0x424B, 0x26D2D },
	{ 0x424C, 0x26D50 },
	{ 0x424D, 0x26CFE },
	{ 0x424E, 0x26CC4 },
	{ 0x424F, 0x26CE1 },
	{ 0x4250, 0x26CF9 },
	{ 0x4251, 0x271BB },
	{ 0x4252, 0x271BC },
	{ 0x4253, 0x4594 },
	{ 0x4254, 0x4593 },
	{ 0x4255, 0x271BA },
	{ 0x4256, 0x272D0 },
	{ 0x4257, 0x272D6 },
	{ 0x4258, 0x272CE },
	{ 0x4259, 0x272E1 },
	{ 0x425A, 0x272D5 },
	{ 0x425B, 0x272CF },
	{ 0x425C, 0x272D3 },
	{ 0x425D, 0x8714 },
	{ 0x425E, 0x272D4 },
	{ 0x425F, 0x275B5 },
	{ 0x4260, 0x27690 },
	{ 0x4261, 0x276A1 },
	{ 0x4262, 0x27681 },
	{ 0x4263, 0x27685 },
	{ 0x4264, 0x2766E },
	{ 0x4265, 0x27688 },
	{ 0x4266, 0x27682 },
	{ 0x4267, 0x27686 },
	{ 0x4268, 0x2768F },
	{ 0x4269, 0x27689 },
	{ 0x426A, 0x27680 },
	{ 0x426B, 0x27684 },
	{ 0x426C, 0x88D1 },
	{ 0x426D, 0x27829 },
	{ 0x426E, 0x2782B },
	{ 0x426F, 0x2782A },
	{ 0x4270, 0x27830 },
	{ 0x4271, 0x278E2 },
	{ 0x4272, 0x278E3 },
	{ 0x4273, 0x278E1 },
	{ 0x4274, 0x279D5 },
	{ 0x4275, 0x279C4 },
	{ 0x4276, 0x279C9 },
	{ 0x4277, 0x279E0 },
	{ 0x4278, 0x279DF },
	{ 0x4279, 0x279CB },
	{ 0x427A, 0x279DD },
	{ 0x427B, 0x279E8 },
	{ 0x427C, 0x279D4 },
	{ 0x427D, 0x27A1C },
	{ 0x427E, 0x27BB5 },
	{ 0x4321, 0x27BB6 },
	{ 0x4322, 0x27BE5 },
	{ 0x4323, 0x27C45 },
	{ 0x4324, 0x27C49 },
	{ 0x4325, 0x27C40 },
	{ 0x4326, 0x27C46 },
	{ 0x4327, 0x27C44 },
	{ 0x4328, 0x27C4A },
	{ 0x4329, 0x27CC9 },
	{ 0x432A, 0x27CC4 },
	{ 0x432B, 0x27CC2 },
	{ 0x432C, 0x27D68 },
	{ 0x432D, 0x8CCB },
	{ 0x432E, 0x27D82 },
	{ 0x432F, 0x27D6B },
	{ 0x4330, 0x27D67 },
	{ 0x4331, 0x27D6C },
	{ 0x4332, 0x27D6D },
	{ 0x4333, 0x27D71 },
	{ 0x4334, 0x4792 },
	{ 0x4335, 0x27ED7 },
	{ 0x4336, 0x27ED2 },
	{ 0x4337, 0x27ED9 },
	{ 0x4338, 0x47AA },
	{ 0x4339, 0x27EBC },
	{ 0x433A, 0x27EDD },
	{ 0x433B, 0x27ED6 },
	{ 0x433C, 0x47A7 },
	{ 0x433D, 0x27ED8 },
	{ 0x433E, 0x28020 },
	{ 0x433F, 0x28016 },
	{ 0x4340, 0x28018 },
	{ 0x4341, 0x28015 },
	{ 0x4342, 0x28019 },
	{ 0x4343, 0x28027 },
	{ 0x4344, 0x28050 },
	{ 0x4345, 0x2801D },
	{ 0x4346, 0x2802C },
	{ 0x4347, 0x2801C },
	{ 0x4348, 0x28029 },
	{ 0x4349, 0x2802B },
	{ 0x434A, 0x28024 },
	{ 0x434B, 0x47EF },
	{ 0x434C, 0x28028 },
	{ 0x434D, 0x28239 },
	{ 0x434E, 0x282F2 },
	{ 0x434F, 0x282F0 },
	{ 0x4350, 0x8EED },
	{ 0x4351, 0x282ED },
	{ 0x4352, 0x282EF },
	{ 0x4353, 0x282EA },
	{ 0x4354, 0x28301 },
	{ 0x4355, 0x284BC },
	{ 0x4356, 0x2855C },
	{ 0x4357, 0x2855B },
	{ 0x4358, 0x2855A },
	{ 0x4359, 0x28526 },
	{ 0x435A, 0x28743 },
	{ 0x435B, 0x28733 },
	{ 0x435C, 0x2873A },
	{ 0x435D, 0x28737 },
	{ 0x435E, 0x28736 },
	{ 0x435F, 0x2873C },
	{ 0x4360, 0x28734 },
	{ 0x4361, 0x2874A },
	{ 0x4362, 0x2873B },
	{ 0x4363, 0x28735 },
	{ 0x4364, 0x2873D },
	{ 0x4365, 0x28740 },
	{ 0x4366, 0x2873E },
	{ 0x4367, 0x28717 },
	{ 0x4368, 0x28826 },
	{ 0x4369, 0x28824 },
	{ 0x436A, 0x28810 },
	{ 0x436B, 0x28836 },
	{ 0x436C, 0x28825 },
	{ 0x436D, 0x4922 },
	{ 0x436E, 0x28966 },
	{ 0x436F, 0x28C7F },
	{ 0x4370, 0x28C7A },
	{ 0x4371, 0x28CFB },
	{ 0x4372, 0x28CFD },
	{ 0x4373, 0x28CFC },
	{ 0x4374, 0x28CFA },
	{ 0x4375, 0x28ED6 },
	{ 0x4376, 0x28ED2 },
	{ 0x4377, 0x28EC8 },
	{ 0x4378, 0x28EC2 },
	{ 0x4379, 0x28EC7 },
	{ 0x437A, 0x28ECD },
	{ 0x437B, 0x28EC1 },
	{ 0x437C, 0x28EC6 },
	{ 0x437D, 0x28ECC },
	{ 0x437E, 0x28FA1 },
	{ 0x4421, 0x29095 },
	{ 0x4422, 0x29094 },
	{ 0x4423, 0x29097 },
	{ 0x4424, 0x29096 },
	{ 0x4425, 0x29093 },
	{ 0x4426, 0x290A1 },
	{ 0x4427, 0x29209 },
	{ 0x4428, 0x29208 },
	{ 0x4429, 0x29267 },
	{ 0x442A, 0x29265 },
	{ 0x442B, 0x29262 },
	{ 0x442C, 0x29261 },
	{ 0x442D, 0x29397 },
	{ 0x442E, 0x29401 },
	{ 0x442F, 0x29419 },
	{ 0x4430, 0x29418 },
	{ 0x4431, 0x2945C },
	{ 0x4432, 0x29467 },
	{ 0x4433, 0x2946C },
	{ 0x4434, 0x4AB5 },
	{ 0x4435, 0x2F9FD },
	{ 0x4436, 0x29466 },
	{ 0x4437, 0x29461 },
	{ 0x4438, 0x2946E },
	{ 0x4439, 0x2945D },
	{ 0x443A, 0x2945A },
	{ 0x443B, 0x295A2 },
	{ 0x443C, 0x295A9 },
	{ 0x443D, 0x295A5 },
	{ 0x443E, 0x295A6 },
	{ 0x443F, 0x295B2 },
	{ 0x4440, 0x295A3 },
	{ 0x4441, 0x296AC },
	{ 0x4442, 0x296AA },
	{ 0x4443, 0x296AF },
	{ 0x4444, 0x296AB },
	{ 0x4445, 0x296B1 },
	{ 0x4446, 0x296C6 },
	{ 0x4447, 0x296AD },
	{ 0x4448, 0x296B9 },
	{ 0x4449, 0x29870 },
	{ 0x444A, 0x4B75 },
	{ 0x444B, 0x29C0C },
	{ 0x444C, 0x29C81 },
	{ 0x444D, 0x29C83 },
	{ 0x444E, 0x29C7E },
	{ 0x444F, 0x29D51 },
	{ 0x4450, 0x29F99 },
	{ 0x4451, 0x29F94 },
	{ 0x4452, 0x29F95 },
	{ 0x4453, 0x2A2FE },
	{ 0x4454, 0x2A418 },
	{ 0x4455, 0x20105 },
	{ 0x4456, 0x20372 },
	{ 0x4457, 0x3482 },
	{ 0x4458, 0x20399 },
	{ 0x4459, 0x204AD },
	{ 0x445A, 0x20606 },
	{ 0x445B, 0x207C2 },
	{ 0x445C, 0x207CB },
	{ 0x445D, 0x207D5 },
	{ 0x445E, 0x207D2 },
	{ 0x445F, 0x207CC },
	{ 0x4460, 0x207D7 },
	{ 0x4461, 0x207C5 },
	{ 0x4462, 0x207CA },
	{ 0x4463, 0x52EC },
	{ 0x4464, 0x208A2 },
	{ 0x4465, 0x208A3 },
	{ 0x4466, 0x208A1 },
	{ 0x4467, 0x52E8 },
	{ 0x4468, 0x208A6 },
	{ 0x4469, 0x208A4 },
	{ 0x446A, 0x208FF },
	{ 0x446B, 0x20900 },
	{ 0x446C, 0x3535 },
	{ 0x446D, 0x20A06 },
	{ 0x446E, 0x20A25 },
	{ 0x446F, 0x20A9F },
	{ 0x4470, 0x20B7F },
	{ 0x4471, 0x20EEA },
	{ 0x4472, 0x20EEB },
	{ 0x4473, 0x20EDE },
	{ 0x4474, 0x20F18 },
	{ 0x4475, 0x20EE0 },
	{ 0x4476, 0x20EE8 },
	{ 0x4477, 0x20EDF },
	{ 0x4478, 0x20EF1 },
	{ 0x4479, 0x20EEC },
	{ 0x447A, 0x20F1A },
	{ 0x447B, 0x20EE6 },
	{ 0x447C, 0x20EE1 },
	{ 0x447D, 0x20F5D },
	{ 0x447E, 0x20077 },
	{ 0x4521, 0x20F1E },
	{ 0x4522, 0x35F0 },
	{ 0x4523, 0x20F80 },
	{ 0x4524, 0x21217 },
	{ 0x4525, 0x2141D },
	{ 0x4526, 0x213F7 },
	{ 0x4527, 0x213EF },
	{ 0x4528, 0x213EE },
	{ 0x4529, 0x213ED },
	{ 0x452A, 0x213F5 },
	{ 0x452B, 0x2141E },
	{ 0x452C, 0x215BD },
	{ 0x452D, 0x257FF },
	{ 0x452E, 0x215BE },
	{ 0x452F, 0x2166D },
	{ 0x4530, 0x21676 },
	{ 0x4531, 0x2184C },
	{ 0x4532, 0x21819 },
	{ 0x4533, 0x21848 },
	{ 0x4534, 0x2181E },
	{ 0x4535, 0x2184A },
	{ 0x4536, 0x21849 },
	{ 0x4537, 0x21826 },
	{ 0x4538, 0x21995 },
	{ 0x4539, 0x21A85 },
	{ 0x453A, 0x21A7E },
	{ 0x453B, 0x21A97 },
	{ 0x453C, 0x21A7D },
	{ 0x453D, 0x21B42 },
	{ 0x453E, 0x21B9E },
	{ 0x453F, 0x21C0C },
	{ 0x4540, 0x21C0B },
	{ 0x4541, 0x21C0E },
	{ 0x4542, 0x21CCF },
	{ 0x4543, 0x21ED8 },
	{ 0x4544, 0x21EE0 },
	{ 0x4545, 0x21EE8 },
	{ 0x4546, 0x21EE9 },
	{ 0x4547, 0x21EE2 },
	{ 0x4548, 0x21EE1 },
	{ 0x4549, 0x21EDA },
	{ 0x454A, 0x21EE3 },
	{ 0x454B, 0x21ED9 },
	{ 0x454C, 0x21EF0 },
	{ 0x454D, 0x21EE7 },
	{ 0x454E, 0x21EE4 },
	{ 0x454F, 0x22123 },
	{ 0x4550, 0x22131 },
	{ 0x4551, 0x22133 },
	{ 0x4552, 0x2210C },
	{ 0x4553, 0x269E0 },
	{ 0x4554, 0x22126 },
	{ 0x4555, 0x22124 },
	{ 0x4556, 0x22132 },
	{ 0x4557, 0x22127 },
	{ 0x4558, 0x22121 },
	{ 0x4559, 0x22130 },
	{ 0x455A, 0x221A2 },
	{ 0x455B, 0x221CC },
	{ 0x455C, 0x22296 },
	{ 0x455D, 0x2F88F },
	{ 0x455E, 0x22298 },
	{ 0x455F, 0x2229C },
	{ 0x4560, 0x2229B },
	{ 0x4561, 0x2236B },
	{ 0x4562, 0x22412 },
	{ 0x4563, 0x22414 },
	{ 0x4564, 0x2255A },
	{ 0x4565, 0x22554 },
	{ 0x4566, 0x22551 },
	{ 0x4567, 0x2255E },
	{ 0x4568, 0x22558 },
	{ 0x4569, 0x38F0 },
	{ 0x456A, 0x22559 },
	{ 0x456B, 0x2279A },
	{ 0x456C, 0x227F2 },
	{ 0x456D, 0x227AD },
	{ 0x456E, 0x22820 },
	{ 0x456F, 0x227F1 },
	{ 0x4570, 0x227F0 },
	{ 0x4571, 0x227F3 },
	{ 0x4572, 0x227F4 },
	{ 0x4573, 0x227E9 },
	{ 0x4574, 0x227FE },
	{ 0x4575, 0x2282E },
	{ 0x4576, 0x227E8 },
	{ 0x4577, 0x227E7 },
	{ 0x4578, 0x227FF },
	{ 0x4579, 0x227F5 },
	{ 0x457A, 0x229E5 },
	{ 0x457B, 0x229E7 },
	{ 0x457C, 0x229E6 },
	{ 0x457D, 0x229E9 },
	{ 0x457E, 0x22A58 },
	{ 0x4621, 0x22C6C },
	{ 0x4622, 0x22CD9 },
	{ 0x4623, 0x3A3E },
	{ 0x4624, 0x22CCB },
	{ 0x4625, 0x3A39 },
	{ 0x4626, 0x22CBE },
	{ 0x4627, 0x22CB5 },
	{ 0x4628, 0x22CD1 },
	{ 0x4629, 0x22CC2 },
	{ 0x462A, 0x22CB6 },
	{ 0x462B, 0x22CD3 },
	{ 0x462C, 0x2F8C2 },
	{ 0x462D, 0x22EDA },
	{ 0x462E, 0x3AA2 },
	{ 0x462F, 0x22FAE },
	{ 0x4630, 0x3AA1 },
	{ 0x4631, 0x22FAC },
	{ 0x4632, 0x22FA9 },
	{ 0x4633, 0x22FBA },
	{ 0x4634, 0x22FA7 },
	{ 0x4635, 0x22FB3 },
	{ 0x4636, 0x22FBD },
	{ 0x4637, 0x22FB1 },
	{ 0x4638, 0x2310E },
	{ 0x4639, 0x23111 },
	{ 0x463A, 0x2310F },
	{ 0x463B, 0x23252 },
	{ 0x463C, 0x2326A },
	{ 0x463D, 0x23254 },
	{ 0x463E, 0x23255 },
	{ 0x463F, 0x23253 },
	{ 0x4640, 0x23257 },
	{ 0x4641, 0x2F8D0 },
	{ 0x4642, 0x2325B },
	{ 0x4643, 0x23258 },
	{ 0x4644, 0x23259 },
	{ 0x4645, 0x3B3B },
	{ 0x4646, 0x235B8 },
	{ 0x4647, 0x235B5 },
	{ 0x4648, 0x235BF },
	{ 0x4649, 0x235C1 },
	{ 0x464A, 0x235BB },
	{ 0x464B, 0x3BB7 },
	{ 0x464C, 0x235C3 },
	{ 0x464D, 0x235AD },
	{ 0x464E, 0x235A8 },
	{ 0x464F, 0x235AE },
	{ 0x4650, 0x235AA },
	{ 0x4651, 0x235D0 },
	{ 0x4652, 0x235B1 },
	{ 0x4653, 0x235BC },
	{ 0x4654, 0x235B7 },
	{ 0x4655, 0x235B0 },
	{ 0x4656, 0x235FA },
	{ 0x4657, 0x235FB },
	{ 0x4658, 0x235B9 },
	{ 0x4659, 0x23907 },
	{ 0x465A, 0x238FC },
	{ 0x465B, 0x238FF },
	{ 0x465C, 0x238F2 },
	{ 0x465D, 0x238F8 },
	{ 0x465E, 0x238F4 },
	{ 0x465F, 0x3C57 },
	{ 0x4660, 0x3C70 },
	{ 0x4661, 0x23AAE },
	{ 0x4662, 0x23B0F },
	{ 0x4663, 0x23B10 },
	{ 0x4664, 0x29AC1 },
	{ 0x4665, 0x23BC7 },
	{ 0x4666, 0x23BC6 },
	{ 0x4667, 0x23BCE },
	{ 0x4668, 0x3CA7 },
	{ 0x4669, 0x23BDC },
	{ 0x466A, 0x23ED5 },
	{ 0x466B, 0x23ED3 },
	{ 0x466C, 0x23F20 },
	{ 0x466D, 0x23EE2 },
	{ 0x466E, 0x23EF1 },
	{ 0x466F, 0x23EDB },
	{ 0x4670, 0x23EEA },
	{ 0x4671, 0x23EEB },
	{ 0x4672, 0x23EE1 },
	{ 0x4673, 0x23EFF },
	{ 0x4674, 0x23ED6 },
	{ 0x4675, 0x23EE0 },
	{ 0x4676, 0x23ED7 },
	{ 0x4677, 0x23EE5 },
	{ 0x4678, 0x3D54 },
	{ 0x4679, 0x2431B },
	{ 0x467A, 0x24310 },
	{ 0x467B, 0x2430F },
	{ 0x467C, 0x2430E },
	{ 0x467D, 0x24339 },
	{ 0x467E, 0x2430A },
	{ 0x4721, 0x24314 },
	{ 0x4722, 0x2430C },
	{ 0x4723, 0x24523 },
	{ 0x4724, 0x2455A },
	{ 0x4725, 0x245E2 },
	{ 0x4726, 0x24693 },
	{ 0x4727, 0x246B0 },
	{ 0x4728, 0x246AB },
	{ 0x4729, 0x246BD },
	{ 0x472A, 0x246B1 },
	{ 0x472B, 0x2468D },
	{ 0x472C, 0x246AD },
	{ 0x472D, 0x246AA },
	{ 0x472E, 0x246AC },
	{ 0x472F, 0x246BC },
	{ 0x4730, 0x246C9 },
	{ 0x4731, 0x24847 },
	{ 0x4732, 0x24862 },
	{ 0x4733, 0x24840 },
	{ 0x4734, 0x24844 },
	{ 0x4735, 0x2483F },
	{ 0x4736, 0x24843 },
	{ 0x4737, 0x2483D },
	{ 0x4738, 0x24860 },
	{ 0x4739, 0x2485F },
	{ 0x473A, 0x2483A },
	{ 0x473B, 0x24842 },
	{ 0x473C, 0x2485E },
	{ 0x473D, 0x2485D },
	{ 0x473E, 0x249BC },
	{ 0x473F, 0x249E0 },
	{ 0x4740, 0x249EE },
	{ 0x4741, 0x249EB },
	{ 0x4742, 0x24A0D },
	{ 0x4743, 0x24B09 },
	{ 0x4744, 0x24B0C },
	{ 0x4745, 0x24B69 },
	{ 0x4746, 0x24B74 },
	{ 0x4747, 0x24B67 },
	{ 0x4748, 0x3F31 },
	{ 0x4749, 0x7527 },
	{ 0x474A, 0x24CAD },
	{ 0x474B, 0x24DFF },
	{ 0x474C, 0x24E16 },
	{ 0x474D, 0x24E08 },
	{ 0x474E, 0x24E09 },
	{ 0x474F, 0x24E00 },
	{ 0x4750, 0x24DFC },
	{ 0x4751, 0x24E13 },
	{ 0x4752, 0x24E14 },
	{ 0x4753, 0x24E0A },
	{ 0x4754, 0x2983E },
	{ 0x4755, 0x24E29 },
	{ 0x4756, 0x24E17 },
	{ 0x4757, 0x24E3B },
	{ 0x4758, 0x24DFB },
	{ 0x4759, 0x3FBF },
	{ 0x475A, 0x24E0E },
	{ 0x475B, 0x3FE4 },
	{ 0x475C, 0x25008 },
	{ 0x475D, 0x2521B },
	{ 0x475E, 0x2521A },
	{ 0x475F, 0x25219 },
	{ 0x4760, 0x25202 },
	{ 0x4761, 0x404A },
	{ 0x4762, 0x25217 },
	{ 0x4763, 0x25207 },
	{ 0x4764, 0x25213 },
	{ 0x4765, 0x25209 },
	{ 0x4766, 0x2520A },
	{ 0x4767, 0x25212 },
	{ 0x4768, 0x252AA },
	{ 0x4769, 0x25238 },
	{ 0x476A, 0x2537B },
	{ 0x476B, 0x2537C },
	{ 0x476C, 0x2537A },
	{ 0x476D, 0x253EA },
	{ 0x476E, 0x253EB },
	{ 0x476F, 0x253EF },
	{ 0x4770, 0x253F0 },
	{ 0x4771, 0x25509 },
	{ 0x4772, 0x25502 },
	{ 0x4773, 0x25501 },
	{ 0x4774, 0x2552B },
	{ 0x4775, 0x25507 },
	{ 0x4776, 0x40CF },
	{ 0x4777, 0x25528 },
	{ 0x4778, 0x254FB },
	{ 0x4779, 0x2552A },
	{ 0x477A, 0x254FE },
	{ 0x477B, 0x25504 },
	{ 0x477C, 0x25529 },
	{ 0x477D, 0x2550A },
	{ 0x477E, 0x798C },
	{ 0x4821, 0x256C2 },
	{ 0x4822, 0x7991 },
	{ 0x4823, 0x256A6 },
	{ 0x4824, 0x4114 },
	{ 0x4825, 0x22FC6 },
	{ 0x4826, 0x21C07 },
	{ 0x4827, 0x2580A },
	{ 0x4828, 0x257FD },
	{ 0x4829, 0x25806 },
	{ 0x482A, 0x2580D },
	{ 0x482B, 0x25809 },
	{ 0x482C, 0x2580B },
	{ 0x482D, 0x25800 },
	{ 0x482E, 0x25805 },
	{ 0x482F, 0x2583D },
	{ 0x4830, 0x259D5 },
	{ 0x4831, 0x259BF },
	{ 0x4832, 0x259BA },
	{ 0x4833, 0x259C7 },
	{ 0x4834, 0x25A98 },
	{ 0x4835, 0x25A9A },
	{ 0x4836, 0x420D },
	{ 0x4837, 0x25BA4 },
	{ 0x4838, 0x25B9C },
	{ 0x4839, 0x25B9D },
	{ 0x483A, 0x25BA2 },
	{ 0x483B, 0x25B96 },
	{ 0x483C, 0x25B95 },
	{ 0x483D, 0x25BA5 },
	{ 0x483E, 0x25BAA },
	{ 0x483F, 0x25BAD },
	{ 0x4840, 0x25B9A },
	{ 0x4841, 0x25BA3 },
	{ 0x4842, 0x25B97 },
	{ 0x4843, 0x25B90 },
	{ 0x4844, 0x25BAF },
	{ 0x4845, 0x25B8D },
	{ 0x4846, 0x4201 },
	{ 0x4847, 0x25BA8 },
	{ 0x4848, 0x25BEE },
	{ 0x4849, 0x25EA3 },
	{ 0x484A, 0x25E99 },
	{ 0x484B, 0x25EA1 },
	{ 0x484C, 0x25E9C },
	{ 0x484D, 0x25EA4 },
	{ 0x484E, 0x25ECB },
	{ 0x484F, 0x26056 },
	{ 0x4850, 0x26048 },
	{ 0x4851, 0x26059 },
	{ 0x4852, 0x2604A },
	{ 0x4853, 0x2605C },
	{ 0x4854, 0x42F1 },
	{ 0x4855, 0x2604F },
	{ 0x4856, 0x2604D },
	{ 0x4857, 0x2605D },
	{ 0x4858, 0x2623A },
	{ 0x4859, 0x262E3 },
	{ 0x485A, 0x262E1 },
	{ 0x485B, 0x262DE },
	{ 0x485C, 0x26397 },
	{ 0x485D, 0x2639A },
	{ 0x485E, 0x26448 },
	{ 0x485F, 0x2644A },
	{ 0x4860, 0x2644C },
	{ 0x4861, 0x2644E },
	{ 0x4862, 0x2644F },
	{ 0x4863, 0x2644B },
	{ 0x4864, 0x2644D },
	{ 0x4865, 0x26447 },
	{ 0x4866, 0x26451 },
	{ 0x4867, 0x264DA },
	{ 0x4868, 0x264F9 },
	{ 0x4869, 0x264FC },
	{ 0x486A, 0x264FB },
	{ 0x486B, 0x264FD },
	{ 0x486C, 0x264F8 },
	{ 0x486D, 0x264FA },
	{ 0x486E, 0x2658A },
	{ 0x486F, 0x2658E },
	{ 0x4870, 0x26588 },
	{ 0x4871, 0x26589 },
	{ 0x4872, 0x2658D },
	{ 0x4873, 0x26590 },
	{ 0x4874, 0x2F97E },
	{ 0x4875, 0x2671C },
	{ 0x4876, 0x267AB },
	{ 0x4877, 0x267A4 },
	{ 0x4878, 0x267A8 },
	{ 0x4879, 0x267AD },
	{ 0x487A, 0x2679F },
	{ 0x487B, 0x2679A },
	{ 0x487C, 0x267B0 },
	{ 0x487D, 0x267A5 },
	{ 0x487E, 0x267D5 },
	{ 0x4921, 0x267A2 },
	{ 0x4922, 0x267B2 },
	{ 0x4923, 0x2679D },
	{ 0x4924, 0x267A1 },
	{ 0x4925, 0x26915 },
	{ 0x4926, 0x26942 },
	{ 0x4927, 0x26973 },
	{ 0x4928, 0x26984 },
	{ 0x4929, 0x269DD },
	{ 0x492A, 0x26A5C },
	{ 0x492B, 0x26A4C },
	{ 0x492C, 0x4476 },
	{ 0x492D, 0x26A4B },
	{ 0x492E, 0x26C67 },
	{ 0x492F, 0x26DA8 },
	{ 0x4930, 0x26D7F },
	{ 0x4931, 0x26D8D },
	{ 0x4932, 0x26D8B },
	{ 0x4933, 0x26DF7 },
	{ 0x4934, 0x26DA9 },
	{ 0x4935, 0x26DF4 },
	{ 0x4936, 0x26D9A },
	{ 0x4937, 0x26D8C },
	{ 0x4938, 0x26D95 },
	{ 0x4939, 0x26D7E },
	{ 0x493A, 0x26D77 },
	{ 0x493B, 0x450A },
	{ 0x493C, 0x4503 },
	{ 0x493D, 0x26D71 },
	{ 0x493E, 0x26DFD },
	{ 0x493F, 0x26D88 },
	{ 0x4940, 0x26D99 },
	{ 0x4941, 0x26D6D },
	{ 0x4942, 0x26DD4 },
	{ 0x4943, 0x26D91 },
	{ 0x4944, 0x26D7D },
	{ 0x4945, 0x26D63 },
	{ 0x4946, 0x26D75 },
	{ 0x4947, 0x26DF9 },
	{ 0x4948, 0x26D8E },
	{ 0x4949, 0x26D74 },
	{ 0x494A, 0x26DD9 },
	{ 0x494B, 0x26D66 },
	{ 0x494C, 0x26DFA },
	{ 0x494D, 0x26DF5 },
	{ 0x494E, 0x8660 },
	{ 0x494F, 0x271C1 },
	{ 0x4950, 0x271C9 },
	{ 0x4951, 0x27303 },
	{ 0x4952, 0x2732C },
	{ 0x4953, 0x27334 },
	{ 0x4954, 0x27317 },
	{ 0x4955, 0x27309 },
	{ 0x4956, 0x27304 },
	{ 0x4957, 0x27306 },
	{ 0x4958, 0x2731A },
	{ 0x4959, 0x2730E },
	{ 0x495A, 0x27327 },
	{ 0x495B, 0x27305 },
	{ 0x495C, 0x27307 },
	{ 0x495D, 0x27319 },
	{ 0x495E, 0x27314 },
	{ 0x495F, 0x2730C },
	{ 0x4960, 0x2731D },
	{ 0x4961, 0x27322 },
	{ 0x4962, 0x27323 },
	{ 0x4963, 0x275BB },
	{ 0x4964, 0x275BC },
	{ 0x4965, 0x275BA },
	{ 0x4966, 0x276A9 },
	{ 0x4967, 0x276B5 },
	{ 0x4968, 0x276AC },
	{ 0x4969, 0x276AA },
	{ 0x496A, 0x276AF },
	{ 0x496B, 0x276B7 },
	{ 0x496C, 0x4635 },
	{ 0x496D, 0x4636 },
	{ 0x496E, 0x2783D },
	{ 0x496F, 0x27845 },
	{ 0x4970, 0x27848 },
	{ 0x4971, 0x2783C },
	{ 0x4972, 0x2783E },
	{ 0x4973, 0x278EC },
	{ 0x4974, 0x278ED },
	{ 0x4975, 0x278E9 },
	{ 0x4976, 0x27A0A },
	{ 0x4977, 0x27A0B },
	{ 0x4978, 0x279F8 },
	{ 0x4979, 0x27A04 },
	{ 0x497A, 0x279F6 },
	{ 0x497B, 0x279F9 },
	{ 0x497C, 0x27C53 },
	{ 0x497D, 0x27C52 },
	{ 0x497E, 0x27C60 },
	{ 0x4A21, 0x27C63 },
	{ 0x4A22, 0x27CCE },
	{ 0x4A23, 0x27CCD },
	{ 0x4A24, 0x27CD0 },
	{ 0x4A25, 0x27CCC },
	{ 0x4A26, 0x27D87 },
	{ 0x4A27, 0x27D8D },
	{ 0x4A28, 0x27D9D },
	{ 0x4A29, 0x4773 },
	{ 0x4A2A, 0x27E63 },
	{ 0x4A2B, 0x27EF4 },
	{ 0x4A2C, 0x27EF1 },
	{ 0x4A2D, 0x27EFF },
	{ 0x4A2E, 0x27EF5 },
	{ 0x4A2F, 0x27EFC },
	{ 0x4A30, 0x27EF2 },
	{ 0x4A31, 0x27EF6 },
	{ 0x4A32, 0x47B1 },
	{ 0x4A33, 0x27EFA },
	{ 0x4A34, 0x47AF },
	{ 0x4A35, 0x2802E },
	{ 0x4A36, 0x28045 },
	{ 0x4A37, 0x28043 },
	{ 0x4A38, 0x28051 },
	{ 0x4A39, 0x2804C },
	{ 0x4A3A, 0x28073 },
	{ 0x4A3B, 0x28047 },
	{ 0x4A3C, 0x2804B },
	{ 0x4A3D, 0x2804F },
	{ 0x4A3E, 0x47F4 },
	{ 0x4A3F, 0x28044 },
	{ 0x4A40, 0x2804D },
	{ 0x4A41, 0x2804E },
	{ 0x4A42, 0x2804A },
	{ 0x4A43, 0x28041 },
	{ 0x4A44, 0x28052 },
	{ 0x4A45, 0x2809F },
	{ 0x4A46, 0x28054 },
	{ 0x4A47, 0x28059 },
	{ 0x4A48, 0x280A2 },
	{ 0x4A49, 0x2824B },
	{ 0x4A4A, 0x28248 },
	{ 0x4A4B, 0x2830D },
	{ 0x4A4C, 0x2831F },
	{ 0x4A4D, 0x28308 },
	{ 0x4A4E, 0x2830E },
	{ 0x4A4F, 0x2831D },
	{ 0x4A50, 0x28304 },
	{ 0x4A51, 0x28418 },
	{ 0x4A52, 0x2841B },
	{ 0x4A53, 0x28566 },
	{ 0x4A54, 0x28562 },
	{ 0x4A55, 0x28583 },
	{ 0x4A56, 0x28567 },
	{ 0x4A57, 0x28762 },
	{ 0x4A58, 0x2874F },
	{ 0x4A59, 0x2874E },
	{ 0x4A5A, 0x28767 },
	{ 0x4A5B, 0x28753 },
	{ 0x4A5C, 0x2874D },
	{ 0x4A5D, 0x2874C },
	{ 0x4A5E, 0x28768 },
	{ 0x4A5F, 0x28751 },
	{ 0x4A60, 0x48DC },
	{ 0x4A61, 0x28758 },
	{ 0x4A62, 0x2875B },
	{ 0x4A63, 0x28750 },
	{ 0x4A64, 0x2876A },
	{ 0x4A65, 0x28839 },
	{ 0x4A66, 0x28838 },
	{ 0x4A67, 0x28982 },
	{ 0x4A68, 0x28984 },
	{ 0x4A69, 0x28986 },
	{ 0x4A6A, 0x28C80 },
	{ 0x4A6B, 0x28C86 },
	{ 0x4A6C, 0x28D25 },
	{ 0x4A6D, 0x28D11 },
	{ 0x4A6E, 0x4999 },
	{ 0x4A6F, 0x28D0E },
	{ 0x4A70, 0x28D15 },
	{ 0x4A71, 0x28D0F },
	{ 0x4A72, 0x28D18 },
	{ 0x4A73, 0x28D0D },
	{ 0x4A74, 0x28D13 },
	{ 0x4A75, 0x28D16 },
	{ 0x4A76, 0x28D19 },
	{ 0x4A77, 0x28F08 },
	{ 0x4A78, 0x28EF7 },
	{ 0x4A79, 0x28EFB },
	{ 0x4A7A, 0x28EFC },
	{ 0x4A7B, 0x28FB4 },
	{ 0x4A7C, 0x28FBE },
	{ 0x4A7D, 0x28FC1 },
	{ 0x4A7E, 0x290A6 },
	{ 0x4B21, 0x290A5 },
	{ 0x4B22, 0x290A2 },
	{ 0x4B23, 0x290A4 },
	{ 0x4B24, 0x29212 },
	{ 0x4B25, 0x2920E },
	{ 0x4B26, 0x2927A },
	{ 0x4B27, 0x29278 },
	{ 0x4B28, 0x2927D },
	{ 0x4B29, 0x2927E },
	{ 0x4B2A, 0x29281 },
	{ 0x4B2B, 0x29283 },
	{ 0x4B2C, 0x29280 },
	{ 0x4B2D, 0x29282 },
	{ 0x4B2E, 0x2939B },
	{ 0x4B2F, 0x29399 },
	{ 0x4B30, 0x2939C },
	{ 0x4B31, 0x2939A },
	{ 0x4B32, 0x293A1 },
	{ 0x4B33, 0x2941A },
	{ 0x4B34, 0x2941C },
	{ 0x4B35, 0x2948A },
	{ 0x4B36, 0x29479 },
	{ 0x4B37, 0x29473 },
	{ 0x4B38, 0x29475 },
	{ 0x4B39, 0x2947C },
	{ 0x4B3A, 0x29478 },
	{ 0x4B3B, 0x29460 },
	{ 0x4B3C, 0x29483 },
	{ 0x4B3D, 0x29470 },
	{ 0x4B3E, 0x4AB6 },
	{ 0x4B3F, 0x4ABD },
	{ 0x4B40, 0x29487 },
	{ 0x4B41, 0x29484 },
	{ 0x4B42, 0x2947B },
	{ 0x4B43, 0x2947E },
	{ 0x4B44, 0x29474 },
	{ 0x4B45, 0x295B9 },
	{ 0x4B46, 0x295B8 },
	{ 0x4B47, 0x295B7 },
	{ 0x4B48, 0x295B5 },
	{ 0x4B49, 0x296CC },
	{ 0x4B4A, 0x296CE },
	{ 0x4B4B, 0x296D1 },
	{ 0x4B4C, 0x9904 },
	{ 0x4B4D, 0x296CB },
	{ 0x4B4E, 0x999B },
	{ 0x4B4F, 0x2987E },
	{ 0x4B50, 0x2987A },
	{ 0x4B51, 0x29877 },
	{ 0x4B52, 0x2988C },
	{ 0x4B53, 0x298E1 },
	{ 0x4B54, 0x29A20 },
	{ 0x4B55, 0x29A1E },
	{ 0x4B56, 0x29AC2 },
	{ 0x4B57, 0x29B0F },
	{ 0x4B58, 0x29B00 },
	{ 0x4B59, 0x4BF4 },
	{ 0x4B5A, 0x29B10 },
	{ 0x4B5B, 0x29C0D },
	{ 0x4B5C, 0x29C0E },
	{ 0x4B5D, 0x29C8E },
	{ 0x4B5E, 0x29C8D },
	{ 0x4B5F, 0x29C8A },
	{ 0x4B60, 0x29C8B },
	{ 0x4B61, 0x29C8C },
	{ 0x4B62, 0x29C8F },
	{ 0x4B63, 0x29D57 },
	{ 0x4B64, 0x4C35 },
	{ 0x4B65, 0x29D55 },
	{ 0x4B66, 0x29D5B },
	{ 0x4B67, 0x29FAC },
	{ 0x4B68, 0x29FA7 },
	{ 0x4B69, 0x29FA0 },
	{ 0x4B6A, 0x29F9E },
	{ 0x4B6B, 0x4CAA },
	{ 0x4B6C, 0x2A28D },
	{ 0x4B6D, 0x4D1F },
	{ 0x4B6E, 0x2A393 },
	{ 0x4B6F, 0x2A394 },
	{ 0x4B70, 0x2A392 },
	{ 0x4B71, 0x20181 },
	{ 0x4B72, 0x203D6 },
	{ 0x4B73, 0x203C3 },
	{ 0x4B74, 0x203E4 },
	{ 0x4B75, 0x203E2 },
	{ 0x4B76, 0x20409 },
	{ 0x4B77, 0x203BF },
	{ 0x4B78, 0x203C8 },
	{ 0x4B79, 0x203C7 },
	{ 0x4B7A, 0x204B5 },
	{ 0x4B7B, 0x204B2 },
	{ 0x4B7C, 0x2060C },
	{ 0x4B7D, 0x2060B },
	{ 0x4B7E, 0x2060A },
	{ 0x4C21, 0x20605 },
	{ 0x4C22, 0x207D3 },
	{ 0x4C23, 0x207E6 },
	{ 0x4C24, 0x207E9 },
	{ 0x4C25, 0x207F0 },
	{ 0x4C26, 0x207EA },
	{ 0x4C27, 0x207E7 },
	{ 0x4C28, 0x208B1 },
	{ 0x4C29, 0x208B3 },
	{ 0x4C2A, 0x208B4 },
	{ 0x4C2B, 0x208B0 },
	{ 0x4C2C, 0x2095C },
	{ 0x4C2D, 0x2095D },
	{ 0x4C2E, 0x2095E },
	{ 0x4C2F, 0x209C0 },
	{ 0x4C30, 0x20AAF },
	{ 0x4C31, 0x3550 },
	{ 0x4C32, 0x20B86 },
	{ 0x4C33, 0x20B83 },
	{ 0x4C34, 0x20B84 },
	{ 0x4C35, 0x20F5C },
	{ 0x4C36, 0x20F70 },
	{ 0x4C37, 0x20F8C },
	{ 0x4C38, 0x20F7B },
	{ 0x4C39, 0x20F66 },
	{ 0x4C3A, 0x20F79 },
	{ 0x4C3B, 0x20F63 },
	{ 0x4C3C, 0x20FC5 },
	{ 0x4C3D, 0x20F6B },
	{ 0x4C3E, 0x20F6D },
	{ 0x4C3F, 0x20F72 },
	{ 0x4C40, 0x20F69 },
	{ 0x4C41, 0x20F75 },
	{ 0x4C42, 0x20F89 },
	{ 0x4C43, 0x20FC6 },
	{ 0x4C44, 0x20FA5 },
	{ 0x4C45, 0x203E7 },
	{ 0x4C46, 0x20F6A },
	{ 0x4C47, 0x20F97 },
	{ 0x4C48, 0x2145A },
	{ 0x4C49, 0x2145C },
	{ 0x4C4A, 0x21459 },
	{ 0x4C4B, 0x21424 },
	{ 0x4C4C, 0x21425 },
	{ 0x4C4D, 0x21430 },
	{ 0x4C4E, 0x21458 },
	{ 0x4C4F, 0x21431 },
	{ 0x4C50, 0x21576 },
	{ 0x4C51, 0x215C1 },
	{ 0x4C52, 0x21685 },
	{ 0x4C53, 0x2167D },
	{ 0x4C54, 0x21865 },
	{ 0x4C55, 0x21887 },
	{ 0x4C56, 0x21852 },
	{ 0x4C57, 0x21854 },
	{ 0x4C58, 0x2188A },
	{ 0x4C59, 0x21850 },
	{ 0x4C5A, 0x21886 },
	{ 0x4C5B, 0x2184F },
	{ 0x4C5C, 0x21868 },
	{ 0x4C5D, 0x2199D },
	{ 0x4C5E, 0x21AA0 },
	{ 0x4C5F, 0x21ABA },
	{ 0x4C60, 0x21ABD },
	{ 0x4C61, 0x21AB8 },
	{ 0x4C62, 0x21BA6 },
	{ 0x4C63, 0x377B },
	{ 0x4C64, 0x21CDE },
	{ 0x4C65, 0x21CD8 },
	{ 0x4C66, 0x21CD1 },
	{ 0x4C67, 0x21F13 },
	{ 0x4C68, 0x3809 },
	{ 0x4C69, 0x21F0E },
	{ 0x4C6A, 0x21F1B },
	{ 0x4C6B, 0x21F3A },
	{ 0x4C6C, 0x3807 },
	{ 0x4C6D, 0x21F1C },
	{ 0x4C6E, 0x21F12 },
	{ 0x4C6F, 0x21F16 },
	{ 0x4C70, 0x21F1A },
	{ 0x4C71, 0x21448 },
	{ 0x4C72, 0x2214B },
	{ 0x4C73, 0x22137 },
	{ 0x4C74, 0x22136 },
	{ 0x4C75, 0x22138 },
	{ 0x4C76, 0x2213A },
	{ 0x4C77, 0x22149 },
	{ 0x4C78, 0x2213C },
	{ 0x4C79, 0x2214A },
	{ 0x4C7A, 0x222B1 },
	{ 0x4C7B, 0x222C2 },
	{ 0x4C7C, 0x222B5 },
	{ 0x4C7D, 0x222C4 },
	{ 0x4C7E, 0x222B6 },
	{ 0x4D21, 0x2241E },
	{ 0x4D22, 0x2241F },
	{ 0x4D23, 0x224AF },
	{ 0x4D24, 0x2256B },
	{ 0x4D25, 0x2256F },
	{ 0x4D26, 0x22792 },
	{ 0x4D27, 0x227E4 },
	{ 0x4D28, 0x2282C },
	{ 0x4D29, 0x227EF },
	{ 0x4D2A, 0x6184 },
	{ 0x4D2B, 0x2284F },
	{ 0x4D2C, 0x22852 },
	{ 0x4D2D, 0x22850 },
	{ 0x4D2E, 0x2283A },
	{ 0x4D2F, 0x22837 },
	{ 0x4D30, 0x22847 },
	{ 0x4D31, 0x22864 },
	{ 0x4D32, 0x22840 },
	{ 0x4D33, 0x2283C },
	{ 0x4D34, 0x22845 },
	{ 0x4D35, 0x22841 },
	{ 0x4D36, 0x229F3 },
	{ 0x4D37, 0x39BB },
	{ 0x4D38, 0x22CC1 },
	{ 0x4D39, 0x22CB4 },
	{ 0x4D3A, 0x3A4B },
	{ 0x4D3B, 0x22D2A },
	{ 0x4D3C, 0x22D22 },
	{ 0x4D3D, 0x22D29 },
	{ 0x4D3E, 0x3A4D },
	{ 0x4D3F, 0x22D3E },
	{ 0x4D40, 0x22D3C },
	{ 0x4D41, 0x22D30 },
	{ 0x4D42, 0x22FC7 },
	{ 0x4D43, 0x22FD5 },
	{ 0x4D44, 0x22FD6 },
	{ 0x4D45, 0x22FD3 },
	{ 0x4D46, 0x22FCE },
	{ 0x4D47, 0x22FC8 },
	{ 0x4D48, 0x2305C },
	{ 0x4D49, 0x2305F },
	{ 0x4D4A, 0x23062 },
	{ 0x4D4B, 0x3AC2 },
	{ 0x4D4C, 0x230BD },
	{ 0x4D4D, 0x230BF },
	{ 0x4D4E, 0x2325C },
	{ 0x4D4F, 0x232B6 },
	{ 0x4D50, 0x3B1A },
	{ 0x4D51, 0x2329D },
	{ 0x4D52, 0x2327F },
	{ 0x4D53, 0x3B12 },
	{ 0x4D54, 0x23294 },
	{ 0x4D55, 0x23281 },
	{ 0x4D56, 0x23347 },
	{ 0x4D57, 0x23346 },
	{ 0x4D58, 0x3B3C },
	{ 0x4D59, 0x23394 },
	{ 0x4D5A, 0x23675 },
	{ 0x4D5B, 0x2361A },
	{ 0x4D5C, 0x2362A },
	{ 0x4D5D, 0x23632 },
	{ 0x4D5E, 0x23617 },
	{ 0x4D5F, 0x23623 },
	{ 0x4D60, 0x23674 },
	{ 0x4D61, 0x3BC3 },
	{ 0x4D62, 0x23676 },
	{ 0x4D63, 0x2362E },
	{ 0x4D64, 0x23625 },
	{ 0x4D65, 0x23620 },
	{ 0x4D66, 0x23671 },
	{ 0x4D67, 0x23616 },
	{ 0x4D68, 0x23670 },
	{ 0x4D69, 0x2362C },
	{ 0x4D6A, 0x2362F },
	{ 0x4D6B, 0x2361F },
	{ 0x4D6C, 0x23664 },
	{ 0x4D6D, 0x3BC0 },
	{ 0x4D6E, 0x23908 },
	{ 0x4D6F, 0x23914 },
	{ 0x4D70, 0x2390A },
	{ 0x4D71, 0x2390B },
	{ 0x4D72, 0x23A4F },
	{ 0x4D73, 0x23A59 },
	{ 0x4D74, 0x23A54 },
	{ 0x4D75, 0x23A51 },
	{ 0x4D76, 0x23AB6 },
	{ 0x4D77, 0x23BEC },
	{ 0x4D78, 0x23BED },
	{ 0x4D79, 0x23BEA },
	{ 0x4D7A, 0x23EEE },
	{ 0x4D7B, 0x23F5A },
	{ 0x4D7C, 0x23F73 },
	{ 0x4D7D, 0x23F65 },
	{ 0x4D7E, 0x23F61 },
	{ 0x4E21, 0x23F55 },
	{ 0x4E22, 0x23F6B },
	{ 0x4E23, 0x23F64 },
	{ 0x4E24, 0x23F5B },
	{ 0x4E25, 0x23F4C },
	{ 0x4E26, 0x23F6F },
	{ 0x4E27, 0x23F84 },
	{ 0x4E28, 0x23F70 },
	{ 0x4E29, 0x2435D },
	{ 0x4E2A, 0x24357 },
	{ 0x4E2B, 0x24366 },
	{ 0x4E2C, 0x24353 },
	{ 0x4E2D, 0x24398 },
	{ 0x4E2E, 0x24397 },
	{ 0x4E2F, 0x24528 },
	{ 0x4E30, 0x245EB },
	{ 0x4E31, 0x245EA },
	{ 0x4E32, 0x245E8 },
	{ 0x4E33, 0x245EC },
	{ 0x4E34, 0x245EF },
	{ 0x4E35, 0x246D1 },
	{ 0x4E36, 0x246CA },
	{ 0x4E37, 0x729F },
	{ 0x4E38, 0x246CF },
	{ 0x4E39, 0x246CD },
	{ 0x4E3A, 0x246CE },
	{ 0x4E3B, 0x24870 },
	{ 0x4E3C, 0x24867 },
	{ 0x4E3D, 0x24873 },
	{ 0x4E3E, 0x2486D },
	{ 0x4E3F, 0x24876 },
	{ 0x4E40, 0x24879 },
	{ 0x4E41, 0x2486A },
	{ 0x4E42, 0x2488B },
	{ 0x4E43, 0x24872 },
	{ 0x4E44, 0x24871 },
	{ 0x4E45, 0x2486E },
	{ 0x4E46, 0x2487A },
	{ 0x4E47, 0x24A16 },
	{ 0x4E48, 0x24A39 },
	{ 0x4E49, 0x24A3B },
	{ 0x4E4A, 0x24B10 },
	{ 0x4E4B, 0x24B96 },
	{ 0x4E4C, 0x24B7B },
	{ 0x4E4D, 0x24B7C },
	{ 0x4E4E, 0x24B7D },
	{ 0x4E4F, 0x24CBE },
	{ 0x4E50, 0x24E5C },
	{ 0x4E51, 0x24E38 },
	{ 0x4E52, 0x24E39 },
	{ 0x4E53, 0x24E2E },
	{ 0x4E54, 0x24E34 },
	{ 0x4E55, 0x24E32 },
	{ 0x4E56, 0x24E5B },
	{ 0x4E57, 0x24E33 },
	{ 0x4E58, 0x24E3C },
	{ 0x4E59, 0x3FE5 },
	{ 0x4E5A, 0x2500E },
	{ 0x4E5B, 0x2500F },
	{ 0x4E5C, 0x25010 },
	{ 0x4E5D, 0x25087 },
	{ 0x4E5E, 0x2525B },
	{ 0x4E5F, 0x25253 },
	{ 0x4E60, 0x405F },
	{ 0x4E61, 0x2525C },
	{ 0x4E62, 0x2523F },
	{ 0x4E63, 0x25259 },
	{ 0x4E64, 0x2524A },
	{ 0x4E65, 0x25244 },
	{ 0x4E66, 0x2524C },
	{ 0x4E67, 0x25240 },
	{ 0x4E68, 0x2525F },
	{ 0x4E69, 0x2525E },
	{ 0x4E6A, 0x2524E },
	{ 0x4E6B, 0x25254 },
	{ 0x4E6C, 0x25243 },
	{ 0x4E6D, 0x25287 },
	{ 0x4E6E, 0x25382 },
	{ 0x4E6F, 0x25385 },
	{ 0x4E70, 0x25531 },
	{ 0x4E71, 0x25547 },
	{ 0x4E72, 0x2552E },
	{ 0x4E73, 0x2552F },
	{ 0x4E74, 0x25548 },
	{ 0x4E75, 0x25534 },
	{ 0x4E76, 0x4118 },
	{ 0x4E77, 0x2059F },
	{ 0x4E78, 0x25832 },
	{ 0x4E79, 0x25836 },
	{ 0x4E7A, 0x25833 },
	{ 0x4E7B, 0x25831 },
	{ 0x4E7C, 0x25840 },
	{ 0x4E7D, 0x25841 },
	{ 0x4E7E, 0x259DD },
	{ 0x4F21, 0x259D2 },
	{ 0x4F22, 0x259D9 },
	{ 0x4F23, 0x41AD },
	{ 0x4F24, 0x259DF },
	{ 0x4F25, 0x259DB },
	{ 0x4F26, 0x259D8 },
	{ 0x4F27, 0x259D3 },
	{ 0x4F28, 0x259DE },
	{ 0x4F29, 0x259E0 },
	{ 0x4F2A, 0x259D4 },
	{ 0x4F2B, 0x259D7 },
	{ 0x4F2C, 0x259DA },
	{ 0x4F2D, 0x25AA7 },
	{ 0x4F2E, 0x25BFE },
	{ 0x4F2F, 0x25BDD },
	{ 0x4F30, 0x25C40 },
	{ 0x4F31, 0x25BE2 },
	{ 0x4F32, 0x421E },
	{ 0x4F33, 0x25BD6 },
	{ 0x4F34, 0x25BDE },
	{ 0x4F35, 0x25BEF },
	{ 0x4F36, 0x4227 },
	{ 0x4F37, 0x25BEB },
	{ 0x4F38, 0x25BEA },
	{ 0x4F39, 0x25BE4 },
	{ 0x4F3A, 0x25BD1 },
	{ 0x4F3B, 0x4218 },
	{ 0x4F3C, 0x25BEC },
	{ 0x4F3D, 0x25BFA },
	{ 0x4F3E, 0x25BD9 },
	{ 0x4F3F, 0x25BF3 },
	{ 0x4F40, 0x25BE1 },
	{ 0x4F41, 0x25BDC },
	{ 0x4F42, 0x25BE5 },
	{ 0x4F43, 0x25BDF },
	{ 0x4F44, 0x25BD4 },
	{ 0x4F45, 0x4220 },
	{ 0x4F46, 0x25C05 },
	{ 0x4F47, 0x25ED6 },
	{ 0x4F48, 0x25ED5 },
	{ 0x4F49, 0x25ED0 },
	{ 0x4F4A, 0x25EC8 },
	{ 0x4F4B, 0x25EC4 },
	{ 0x4F4C, 0x25EC9 },
	{ 0x4F4D, 0x25ECD },
	{ 0x4F4E, 0x25ED2 },
	{ 0x4F4F, 0x25ECC },
	{ 0x4F50, 0x25ECA },
	{ 0x4F51, 0x260A0 },
	{ 0x4F52, 0x26092 },
	{ 0x4F53, 0x42F4 },
	{ 0x4F54, 0x4302 },
	{ 0x4F55, 0x2608B },
	{ 0x4F56, 0x260A1 },
	{ 0x4F57, 0x26095 },
	{ 0x4F58, 0x26088 },
	{ 0x4F59, 0x26086 },
	{ 0x4F5A, 0x2608D },
	{ 0x4F5B, 0x26085 },
	{ 0x4F5C, 0x26091 },
	{ 0x4F5D, 0x26089 },
	{ 0x4F5E, 0x260A2 },
	{ 0x4F5F, 0x262F0 },
	{ 0x4F60, 0x262F3 },
	{ 0x4F61, 0x262F4 },
	{ 0x4F62, 0x262EF },
	{ 0x4F63, 0x26306 },
	{ 0x4F64, 0x263A2 },
	{ 0x4F65, 0x2645E },
	{ 0x4F66, 0x26463 },
	{ 0x4F67, 0x26460 },
	{ 0x4F68, 0x2645B },
	{ 0x4F69, 0x2647B },
	{ 0x4F6A, 0x26458 },
	{ 0x4F6B, 0x26459 },
	{ 0x4F6C, 0x2645D },
	{ 0x4F6D, 0x26505 },
	{ 0x4F6E, 0x26506 },
	{ 0x4F6F, 0x26502 },
	{ 0x4F70, 0x26503 },
	{ 0x4F71, 0x26504 },
	{ 0x4F72, 0x265A2 },
	{ 0x4F73, 0x265A7 },
	{ 0x4F74, 0x265A6 },
	{ 0x4F75, 0x265A4 },
	{ 0x4F76, 0x265AC },
	{ 0x4F77, 0x265A9 },
	{ 0x4F78, 0x267E7 },
	{ 0x4F79, 0x26801 },
	{ 0x4F7A, 0x267DF },
	{ 0x4F7B, 0x267D9 },
	{ 0x4F7C, 0x267E3 },
	{ 0x4F7D, 0x2680F },
	{ 0x4F7E, 0x2691A },
	{ 0x5021, 0x26945 },
	{ 0x5022, 0x26948 },
	{ 0x5023, 0x2697B },
	{ 0x5024, 0x26985 },
	{ 0x5025, 0x26986 },
	{ 0x5026, 0x269FE },
	{ 0x5027, 0x269FF },
	{ 0x5028, 0x26A64 },
	{ 0x5029, 0x26A71 },
	{ 0x502A, 0x26A72 },
	{ 0x502B, 0x26A61 },
	{ 0x502C, 0x26A62 },
	{ 0x502D, 0x26A6C },
	{ 0x502E, 0x26A60 },
	{ 0x502F, 0x26A5D },
	{ 0x5030, 0x26A63 },
	{ 0x5031, 0x26A67 },
	{ 0x5032, 0x26E01 },
	{ 0x5033, 0x26E2A },
	{ 0x5034, 0x26E30 },
	{ 0x5035, 0x26E06 },
	{ 0x5036, 0x26E7D },
	{ 0x5037, 0x26E22 },
	{ 0x5038, 0x26EB9 },
	{ 0x5039, 0x26E0A },
	{ 0x503A, 0x26E10 },
	{ 0x503B, 0x26D8F },
	{ 0x503C, 0x26E80 },
	{ 0x503D, 0x26E13 },
	{ 0x503E, 0x26E2E },
	{ 0x503F, 0x26E18 },
	{ 0x5040, 0x26E17 },
	{ 0x5041, 0x26E1A },
	{ 0x5042, 0x26E14 },
	{ 0x5043, 0x26E47 },
	{ 0x5044, 0x26E63 },
	{ 0x5045, 0x26E38 },
	{ 0x5046, 0x4524 },
	{ 0x5047, 0x26E7F },
	{ 0x5048, 0x26E21 },
	{ 0x5049, 0x26E37 },
	{ 0x504A, 0x26E31 },
	{ 0x504B, 0x26E1B },
	{ 0x504C, 0x26EA5 },
	{ 0x504D, 0x26F6C },
	{ 0x504E, 0x271D3 },
	{ 0x504F, 0x27388 },
	{ 0x5050, 0x2736E },
	{ 0x5051, 0x2735C },
	{ 0x5052, 0x27374 },
	{ 0x5053, 0x27354 },
	{ 0x5054, 0x27383 },
	{ 0x5055, 0x8770 },
	{ 0x5056, 0x27365 },
	{ 0x5057, 0x27360 },
	{ 0x5058, 0x27370 },
	{ 0x5059, 0x2736F },
	{ 0x505A, 0x2736D },
	{ 0x505B, 0x27372 },
	{ 0x505C, 0x2736C },
	{ 0x505D, 0x27376 },
	{ 0x505E, 0x27375 },
	{ 0x505F, 0x27359 },
	{ 0x5060, 0x273C7 },
	{ 0x5061, 0x275C1 },
	{ 0x5062, 0x275F9 },
	{ 0x5063, 0x276E3 },
	{ 0x5064, 0x276E7 },
	{ 0x5065, 0x276D6 },
	{ 0x5066, 0x276CF },
	{ 0x5067, 0x276DA },
	{ 0x5068, 0x276E9 },
	{ 0x5069, 0x276D2 },
	{ 0x506A, 0x27855 },
	{ 0x506B, 0x2784F },
	{ 0x506C, 0x2784D },
	{ 0x506D, 0x27851 },
	{ 0x506E, 0x27856 },
	{ 0x506F, 0x278F9 },
	{ 0x5070, 0x278F8 },
	{ 0x5071, 0x27906 },
	{ 0x5072, 0x27903 },
	{ 0x5073, 0x27909 },
	{ 0x5074, 0x278F7 },
	{ 0x5075, 0x278F5 },
	{ 0x5076, 0x27A47 },
	{ 0x5077, 0x27A45 },
	{ 0x5078, 0x27A3E },
	{ 0x5079, 0x27A46 },
	{ 0x507A, 0x27A29 },
	{ 0x507B, 0x27A34 },
	{ 0x507C, 0x27A3F },
	{ 0x507D, 0x27A44 },
	{ 0x507E, 0x27A35 },
	{ 0x5121, 0x27A5A },
	{ 0x5122, 0x27A2A },
	{ 0x5123, 0x27A33 },
	{ 0x5124, 0x27A37 },
	{ 0x5125, 0x27A43 },
	{ 0x5126, 0x27A39 },
	{ 0x5127, 0x27A30 },
	{ 0x5128, 0x27A5D },
	{ 0x5129, 0x27A32 },
	{ 0x512A, 0x27A27 },
	{ 0x512B, 0x27BBD },
	{ 0x512C, 0x27BBA },
	{ 0x512D, 0x27BBC },
	{ 0x512E, 0x27BF1 },
	{ 0x512F, 0x27BF0 },
	{ 0x5130, 0x27C61 },
	{ 0x5131, 0x27C5C },
	{ 0x5132, 0x27C58 },
	{ 0x5133, 0x27C5D },
	{ 0x5134, 0x27CDA },
	{ 0x5135, 0x27CD9 },
	{ 0x5136, 0x27CDD },
	{ 0x5137, 0x27CDC },
	{ 0x5138, 0x27CDE },
	{ 0x5139, 0x477D },
	{ 0x513A, 0x27DA0 },
	{ 0x513B, 0x27DA2 },
	{ 0x513C, 0x27F0F },
	{ 0x513D, 0x27F13 },
	{ 0x513E, 0x27F12 },
	{ 0x513F, 0x27F11 },
	{ 0x5140, 0x27F14 },
	{ 0x5141, 0x27F19 },
	{ 0x5142, 0x27F0E },
	{ 0x5143, 0x27F17 },
	{ 0x5144, 0x27F21 },
	{ 0x5145, 0x27F20 },
	{ 0x5146, 0x27F16 },
	{ 0x5147, 0x28078 },
	{ 0x5148, 0x8E37 },
	{ 0x5149, 0x28087 },
	{ 0x514A, 0x28079 },
	{ 0x514B, 0x28080 },
	{ 0x514C, 0x28077 },
	{ 0x514D, 0x28081 },
	{ 0x514E, 0x28046 },
	{ 0x514F, 0x2807A },
	{ 0x5150, 0x2809C },
	{ 0x5151, 0x28083 },
	{ 0x5152, 0x28084 },
	{ 0x5153, 0x280AD },
	{ 0x5154, 0x2809D },
	{ 0x5155, 0x2809E },
	{ 0x5156, 0x28255 },
	{ 0x5157, 0x28336 },
	{ 0x5158, 0x2832B },
	{ 0x5159, 0x28327 },
	{ 0x515A, 0x28346 },
	{ 0x515B, 0x2832C },
	{ 0x515C, 0x28345 },
	{ 0x515D, 0x28333 },
	{ 0x515E, 0x2832D },
	{ 0x515F, 0x28334 },
	{ 0x5160, 0x28322 },
	{ 0x5161, 0x4864 },
	{ 0x5162, 0x2841F },
	{ 0x5163, 0x285B3 },
	{ 0x5164, 0x2858C },
	{ 0x5165, 0x2858F },
	{ 0x5166, 0x285AF },
	{ 0x5167, 0x285AD },
	{ 0x5168, 0x2858E },
	{ 0x5169, 0x285AC },
	{ 0x516A, 0x285B0 },
	{ 0x516B, 0x285B1 },
	{ 0x516C, 0x285AE },
	{ 0x516D, 0x28599 },
	{ 0x516E, 0x286EB },
	{ 0x516F, 0x28774 },
	{ 0x5170, 0x28775 },
	{ 0x5171, 0x2878E },
	{ 0x5172, 0x2876D },
	{ 0x5173, 0x28770 },
	{ 0x5174, 0x2878C },
	{ 0x5175, 0x2884F },
	{ 0x5176, 0x28851 },
	{ 0x5177, 0x28858 },
	{ 0x5178, 0x2884C },
	{ 0x5179, 0x2884E },
	{ 0x517A, 0x28915 },
	{ 0x517B, 0x289BE },
	{ 0x517C, 0x289DB },
	{ 0x517D, 0x289B3 },
	{ 0x517E, 0x289AE },
	{ 0x5221, 0x28C87 },
	{ 0x5222, 0x28C8A },
	{ 0x5223, 0x28C88 },
	{ 0x5224, 0x28C8B },
	{ 0x5225, 0x28C8C },
	{ 0x5226, 0x28D44 },
	{ 0x5227, 0x28D2D },
	{ 0x5228, 0x28D2A },
	{ 0x5229, 0x28D31 },
	{ 0x522A, 0x28D2C },
	{ 0x522B, 0x28D45 },
	{ 0x522C, 0x28D30 },
	{ 0x522D, 0x28D29 },
	{ 0x522E, 0x28D46 },
	{ 0x522F, 0x28EF4 },
	{ 0x5230, 0x28F14 },
	{ 0x5231, 0x28F10 },
	{ 0x5232, 0x28F0F },
	{ 0x5233, 0x28F12 },
	{ 0x5234, 0x28F0B },
	{ 0x5235, 0x28F0C },
	{ 0x5236, 0x28F0A },
	{ 0x5237, 0x28F13 },
	{ 0x5238, 0x28F0E },
	{ 0x5239, 0x28FD9 },
	{ 0x523A, 0x28FD0 },
	{ 0x523B, 0x9703 },
	{ 0x523C, 0x290C1 },
	{ 0x523D, 0x290BF },
	{ 0x523E, 0x290BD },
	{ 0x523F, 0x290BC },
	{ 0x5240, 0x290BA },
	{ 0x5241, 0x290BB },
	{ 0x5242, 0x290D1 },
	{ 0x5243, 0x290BE },
	{ 0x5244, 0x290D0 },
	{ 0x5245, 0x290B9 },
	{ 0x5246, 0x2921A },
	{ 0x5247, 0x2921C },
	{ 0x5248, 0x2921B },
	{ 0x5249, 0x29291 },
	{ 0x524A, 0x29296 },
	{ 0x524B, 0x2929F },
	{ 0x524C, 0x2929C },
	{ 0x524D, 0x2929A },
	{ 0x524E, 0x2929D },
	{ 0x524F, 0x293AD },
	{ 0x5250, 0x293A5 },
	{ 0x5251, 0x293AE },
	{ 0x5252, 0x29403 },
	{ 0x5253, 0x29426 },
	{ 0x5254, 0x29420 },
	{ 0x5255, 0x29423 },
	{ 0x5256, 0x29424 },
	{ 0x5257, 0x29421 },
	{ 0x5258, 0x29428 },
	{ 0x5259, 0x29425 },
	{ 0x525A, 0x2941E },
	{ 0x525B, 0x29494 },
	{ 0x525C, 0x29493 },
	{ 0x525D, 0x2948F },
	{ 0x525E, 0x2949A },
	{ 0x525F, 0x294AD },
	{ 0x5260, 0x4AC2 },
	{ 0x5261, 0x295CA },
	{ 0x5262, 0x295C5 },
	{ 0x5263, 0x296BB },
	{ 0x5264, 0x296E1 },
	{ 0x5265, 0x296EA },
	{ 0x5266, 0x296E4 },
	{ 0x5267, 0x296ED },
	{ 0x5268, 0x296E6 },
	{ 0x5269, 0x296E0 },
	{ 0x526A, 0x296E8 },
	{ 0x526B, 0x296E5 },
	{ 0x526C, 0x2981A },
	{ 0x526D, 0x29894 },
	{ 0x526E, 0x29896 },
	{ 0x526F, 0x2989E },
	{ 0x5270, 0x29895 },
	{ 0x5271, 0x298A1 },
	{ 0x5272, 0x2988E },
	{ 0x5273, 0x2989B },
	{ 0x5274, 0x29892 },
	{ 0x5275, 0x29897 },
	{ 0x5276, 0x29899 },
	{ 0x5277, 0x29893 },
	{ 0x5278, 0x29A32 },
	{ 0x5279, 0x29A2F },
	{ 0x527A, 0x29A2E },
	{ 0x527B, 0x29A33 },
	{ 0x527C, 0x29B1C },
	{ 0x527D, 0x29B1E },
	{ 0x527E, 0x29B11 },
	{ 0x5321, 0x29B20 },
	{ 0x5322, 0x29B1F },
	{ 0x5323, 0x29B19 },
	{ 0x5324, 0x29B16 },
	{ 0x5325, 0x29CAC },
	{ 0x5326, 0x29CB9 },
	{ 0x5327, 0x29CB3 },
	{ 0x5328, 0x29CA6 },
	{ 0x5329, 0x29CA2 },
	{ 0x532A, 0x29CA9 },
	{ 0x532B, 0x29CA7 },
	{ 0x532C, 0x29D6C },
	{ 0x532D, 0x29D6D },
	{ 0x532E, 0x29D69 },
	{ 0x532F, 0x29D80 },
	{ 0x5330, 0x29D66 },
	{ 0x5331, 0x29D65 },
	{ 0x5332, 0x29D71 },
	{ 0x5333, 0x29D6B },
	{ 0x5334, 0x29FBD },
	{ 0x5335, 0x29FC1 },
	{ 0x5336, 0x29FD3 },
	{ 0x5337, 0x29FB6 },
	{ 0x5338, 0x4CAC },
	{ 0x5339, 0x29FB9 },
	{ 0x533A, 0x29FD4 },
	{ 0x533B, 0x29FB7 },
	{ 0x533C, 0x29FDB },
	{ 0x533D, 0x29FB8 },
	{ 0x533E, 0x29FC0 },
	{ 0x533F, 0x29FBC },
	{ 0x5340, 0x29FD5 },
	{ 0x5341, 0x29FBF },
	{ 0x5342, 0x29FC3 },
	{ 0x5343, 0x29FC9 },
	{ 0x5344, 0x2A258 },
	{ 0x5345, 0x2A290 },
	{ 0x5346, 0x2A295 },
	{ 0x5347, 0x2A297 },
	{ 0x5348, 0x2A309 },
	{ 0x5349, 0x2A308 },
	{ 0x534A, 0x2A306 },
	{ 0x534B, 0x2A305 },
	{ 0x534C, 0x2A310 },
	{ 0x534D, 0x2A397 },
	{ 0x534E, 0x2A395 },
	{ 0x534F, 0x2A3EE },
	{ 0x5350, 0x2A41F },
	{ 0x5351, 0x2FA1A },
	{ 0x5352, 0x21B4B },
	{ 0x5353, 0x2018E },
	{ 0x5354, 0x203E8 },
	{ 0x5355, 0x203F0 },
	{ 0x5356, 0x203F4 },
	{ 0x5357, 0x20406 },
	{ 0x5358, 0x203ED },
	{ 0x5359, 0x349B },
	{ 0x535A, 0x203E9 },
	{ 0x535B, 0x20400 },
	{ 0x535C, 0x204B8 },
	{ 0x535D, 0x2056D },
	{ 0x535E, 0x20804 },
	{ 0x535F, 0x20801 },
	{ 0x5360, 0x20803 },
	{ 0x5361, 0x20802 },
	{ 0x5362, 0x52F6 },
	{ 0x5363, 0x3526 },
	{ 0x5364, 0x20962 },
	{ 0x5365, 0x20ABA },
	{ 0x5366, 0x20B13 },
	{ 0x5367, 0x20FDE },
	{ 0x5368, 0x20FD7 },
	{ 0x5369, 0x20FE4 },
	{ 0x536A, 0x20FCE },
	{ 0x536B, 0x20FE3 },
	{ 0x536C, 0x20FDD },
	{ 0x536D, 0x2103A },
	{ 0x536E, 0x20FDB },
	{ 0x536F, 0x20FD6 },
	{ 0x5370, 0x20FE0 },
	{ 0x5371, 0x20FD4 },
	{ 0x5372, 0x20FCB },
	{ 0x5373, 0x20FE1 },
	{ 0x5374, 0x20FC9 },
	{ 0x5375, 0x20FDF },
	{ 0x5376, 0x2103C },
	{ 0x5377, 0x20FFC },
	{ 0x5378, 0x20FCF },
	{ 0x5379, 0x21479 },
	{ 0x537A, 0x21476 },
	{ 0x537B, 0x21478 },
	{ 0x537C, 0x21687 },
	{ 0x537D, 0x2189C },
	{ 0x537E, 0x218B1 },
	{ 0x5421, 0x218C1 },
	{ 0x5422, 0x2189A },
	{ 0x5423, 0x21892 },
	{ 0x5424, 0x41AF },
	{ 0x5425, 0x218C2 },
	{ 0x5426, 0x21896 },
	{ 0x5427, 0x218C0 },
	{ 0x5428, 0x21891 },
	{ 0x5429, 0x21895 },
	{ 0x542A, 0x219A2 },
	{ 0x542B, 0x21AC3 },
	{ 0x542C, 0x21AC0 },
	{ 0x542D, 0x21AC2 },
	{ 0x542E, 0x20B8A },
	{ 0x542F, 0x21BB0 },
	{ 0x5430, 0x21C16 },
	{ 0x5431, 0x21F46 },
	{ 0x5432, 0x21F4A },
	{ 0x5433, 0x21F3E },
	{ 0x5434, 0x21F45 },
	{ 0x5435, 0x21F42 },
	{ 0x5436, 0x3815 },
	{ 0x5437, 0x21F5B },
	{ 0x5438, 0x21F44 },
	{ 0x5439, 0x22004 },
	{ 0x543A, 0x24022 },
	{ 0x543B, 0x22155 },
	{ 0x543C, 0x22157 },
	{ 0x543D, 0x22151 },
	{ 0x543E, 0x2214E },
	{ 0x543F, 0x2215A },
	{ 0x5440, 0x222C6 },
	{ 0x5441, 0x222C3 },
	{ 0x5442, 0x389C },
	{ 0x5443, 0x222C5 },
	{ 0x5444, 0x222CC },
	{ 0x5445, 0x22371 },
	{ 0x5446, 0x22426 },
	{ 0x5447, 0x224B2 },
	{ 0x5448, 0x2257A },
	{ 0x5449, 0x22584 },
	{ 0x544A, 0x2257B },
	{ 0x544B, 0x22874 },
	{ 0x544C, 0x2288C },
	{ 0x544D, 0x22851 },
	{ 0x544E, 0x22848 },
	{ 0x544F, 0x2288D },
	{ 0x5450, 0x22892 },
	{ 0x5451, 0x22898 },
	{ 0x5452, 0x22893 },
	{ 0x5453, 0x228B0 },
	{ 0x5454, 0x2284E },
	{ 0x5455, 0x22896 },
	{ 0x5456, 0x22897 },
	{ 0x5457, 0x2289C },
	{ 0x5458, 0x228CA },
	{ 0x5459, 0x22D33 },
	{ 0x545A, 0x22D83 },
	{ 0x545B, 0x22D84 },
	{ 0x545C, 0x22D9A },
	{ 0x545D, 0x22D8C },
	{ 0x545E, 0x64CC },
	{ 0x545F, 0x22D99 },
	{ 0x5460, 0x22EE0 },
	{ 0x5461, 0x22FE4 },
	{ 0x5462, 0x22FF8 },
	{ 0x5463, 0x22FED },
	{ 0x5464, 0x22FF3 },
	{ 0x5465, 0x22FF4 },
	{ 0x5466, 0x22FF5 },
	{ 0x5467, 0x22FFD },
	{ 0x5468, 0x23119 },
	{ 0x5469, 0x2329E },
	{ 0x546A, 0x232C4 },
	{ 0x546B, 0x2329F },
	{ 0x546C, 0x2339B },
	{ 0x546D, 0x2339F },
	{ 0x546E, 0x2339A },
	{ 0x546F, 0x236AA },
	{ 0x5470, 0x2369D },
	{ 0x5471, 0x23692 },
	{ 0x5472, 0x236A2 },
	{ 0x5473, 0x236AF },
	{ 0x5474, 0x236EB },
	{ 0x5475, 0x236A0 },
	{ 0x5476, 0x236A1 },
	{ 0x5477, 0x23694 },
	{ 0x5478, 0x23698 },
	{ 0x5479, 0x2368F },
	{ 0x547A, 0x23687 },
	{ 0x547B, 0x23684 },
	{ 0x547C, 0x236A9 },
	{ 0x547D, 0x2367C },
	{ 0x547E, 0x23918 },
	{ 0x5521, 0x23A5F },
	{ 0x5522, 0x23A62 },
	{ 0x5523, 0x23A61 },
	{ 0x5524, 0x23AC0 },
	{ 0x5525, 0x23B15 },
	{ 0x5526, 0x23BFC },
	{ 0x5527, 0x23BF9 },
	{ 0x5528, 0x23FC8 },
	{ 0x5529, 0x23FC9 },
	{ 0x552A, 0x23FDE },
	{ 0x552B, 0x23FCA },
	{ 0x552C, 0x23FE2 },
	{ 0x552D, 0x3D64 },
	{ 0x552E, 0x3D6E },
	{ 0x552F, 0x24004 },
	{ 0x5530, 0x23FCC },
	{ 0x5531, 0x23FDD },
	{ 0x5532, 0x23FE4 },
	{ 0x5533, 0x23FD3 },
	{ 0x5534, 0x23FC7 },
	{ 0x5535, 0x23FC6 },
	{ 0x5536, 0x3D5F },
	{ 0x5537, 0x24037 },
	{ 0x5538, 0x243D8 },
	{ 0x5539, 0x243EE },
	{ 0x553A, 0x243B2 },
	{ 0x553B, 0x243A3 },
	{ 0x553C, 0x243B3 },
	{ 0x553D, 0x243ED },
	{ 0x553E, 0x243F8 },
	{ 0x553F, 0x24531 },
	{ 0x5540, 0x2455B },
	{ 0x5541, 0x24566 },
	{ 0x5542, 0x24569 },
	{ 0x5543, 0x24596 },
	{ 0x5544, 0x2459B },
	{ 0x5545, 0x245F7 },
	{ 0x5546, 0x245F3 },
	{ 0x5547, 0x245F4 },
	{ 0x5548, 0x245F5 },
	{ 0x5549, 0x246E2 },
	{ 0x554A, 0x246E7 },
	{ 0x554B, 0x246E5 },
	{ 0x554C, 0x246E9 },
	{ 0x554D, 0x246E6 },
	{ 0x554E, 0x246E3 },
	{ 0x554F, 0x24874 },
	{ 0x5550, 0x2487F },
	{ 0x5551, 0x2488F },
	{ 0x5552, 0x24890 },
	{ 0x5553, 0x24897 },
	{ 0x5554, 0x248A3 },
	{ 0x5555, 0x2488E },
	{ 0x5556, 0x24898 },
	{ 0x5557, 0x2488C },
	{ 0x5558, 0x24A42 },
	{ 0x5559, 0x24A44 },
	{ 0x555A, 0x24A69 },
	{ 0x555B, 0x24A43 },
	{ 0x555C, 0x24A68 },
	{ 0x555D, 0x3EF6 },
	{ 0x555E, 0x24B8D },
	{ 0x555F, 0x24B88 },
	{ 0x5560, 0x24B8B },
	{ 0x5561, 0x24B89 },
	{ 0x5562, 0x24CCC },
	{ 0x5563, 0x24D1F },
	{ 0x5564, 0x24E80 },
	{ 0x5565, 0x24E5E },
	{ 0x5566, 0x24E67 },
	{ 0x5567, 0x24E68 },
	{ 0x5568, 0x24E65 },
	{ 0x5569, 0x764A },
	{ 0x556A, 0x24E74 },
	{ 0x556B, 0x24E69 },
	{ 0x556C, 0x24E61 },
	{ 0x556D, 0x24E62 },
	{ 0x556E, 0x24E6C },
	{ 0x556F, 0x24E93 },
	{ 0x5570, 0x24E86 },
	{ 0x5571, 0x24F9D },
	{ 0x5572, 0x24F9B },
	{ 0x5573, 0x2501B },
	{ 0x5574, 0x25016 },
	{ 0x5575, 0x25019 },
	{ 0x5576, 0x25014 },
	{ 0x5577, 0x25018 },
	{ 0x5578, 0x25015 },
	{ 0x5579, 0x25099 },
	{ 0x557A, 0x25098 },
	{ 0x557B, 0x2525D },
	{ 0x557C, 0x25289 },
	{ 0x557D, 0x2527A },
	{ 0x557E, 0x2527D },
	{ 0x5621, 0x2524B },
	{ 0x5622, 0x4073 },
	{ 0x5623, 0x25278 },
	{ 0x5624, 0x2527F },
	{ 0x5625, 0x25277 },
	{ 0x5626, 0x2527E },
	{ 0x5627, 0x25279 },
	{ 0x5628, 0x252AB },
	{ 0x5629, 0x2527C },
	{ 0x562A, 0x25274 },
	{ 0x562B, 0x25275 },
	{ 0x562C, 0x252A7 },
	{ 0x562D, 0x2538D },
	{ 0x562E, 0x2554E },
	{ 0x562F, 0x25566 },
	{ 0x5630, 0x25561 },
	{ 0x5631, 0x2554D },
	{ 0x5632, 0x2554F },
	{ 0x5633, 0x40DD },
	{ 0x5634, 0x25554 },
	{ 0x5635, 0x2557C },
	{ 0x5636, 0x256DA },
	{ 0x5637, 0x256DE },
	{ 0x5638, 0x256D8 },
	{ 0x5639, 0x256DD },
	{ 0x563A, 0x256DF },
	{ 0x563B, 0x25866 },
	{ 0x563C, 0x25862 },
	{ 0x563D, 0x2585F },
	{ 0x563E, 0x25864 },
	{ 0x563F, 0x25863 },
	{ 0x5640, 0x25860 },
	{ 0x5641, 0x25888 },
	{ 0x5642, 0x2586A },
	{ 0x5643, 0x25867 },
	{ 0x5644, 0x25887 },
	{ 0x5645, 0x2583F },
	{ 0x5646, 0x2586C },
	{ 0x5647, 0x2586E },
	{ 0x5648, 0x258AD },
	{ 0x5649, 0x259F1 },
	{ 0x564A, 0x259F4 },
	{ 0x564B, 0x259F6 },
	{ 0x564C, 0x259F5 },
	{ 0x564D, 0x259F8 },
	{ 0x564E, 0x259FB },
	{ 0x564F, 0x259EC },
	{ 0x5650, 0x259EF },
	{ 0x5651, 0x259ED },
	{ 0x5652, 0x7AB9 },
	{ 0x5653, 0x259F7 },
	{ 0x5654, 0x259F9 },
	{ 0x5655, 0x259FD },
	{ 0x5656, 0x25AB1 },
	{ 0x5657, 0x25C36 },
	{ 0x5658, 0x25C1B },
	{ 0x5659, 0x25C32 },
	{ 0x565A, 0x25C42 },
	{ 0x565B, 0x25C4D },
	{ 0x565C, 0x25C1F },
	{ 0x565D, 0x25C21 },
	{ 0x565E, 0x25C1C },
	{ 0x565F, 0x25C31 },
	{ 0x5660, 0x25C2E },
	{ 0x5661, 0x25C47 },
	{ 0x5662, 0x25C3B },
	{ 0x5663, 0x25C41 },
	{ 0x5664, 0x25C18 },
	{ 0x5665, 0x25C39 },
	{ 0x5666, 0x25C1D },
	{ 0x5667, 0x25C27 },
	{ 0x5668, 0x25C23 },
	{ 0x5669, 0x7BD7 },
	{ 0x566A, 0x25EEE },
	{ 0x566B, 0x25EE8 },
	{ 0x566C, 0x25EE5 },
	{ 0x566D, 0x25EEF },
	{ 0x566E, 0x25EE4 },
	{ 0x566F, 0x25EEC },
	{ 0x5670, 0x25EF0 },
	{ 0x5671, 0x260D7 },
	{ 0x5672, 0x260D8 },
	{ 0x5673, 0x260D4 },
	{ 0x5674, 0x260CA },
	{ 0x5675, 0x260D2 },
	{ 0x5676, 0x260CB },
	{ 0x5677, 0x260D3 },
	{ 0x5678, 0x260E6 },
	{ 0x5679, 0x260E2 },
	{ 0x567A, 0x26249 },
	{ 0x567B, 0x26248 },
	{ 0x567C, 0x262FF },
	{ 0x567D, 0x26309 },
	{ 0x567E, 0x263B0 },
	{ 0x5721, 0x263AF },
	{ 0x5722, 0x2647C },
	{ 0x5723, 0x26478 },
	{ 0x5724, 0x2647A },
	{ 0x5725, 0x26472 },
	{ 0x5726, 0x26479 },
	{ 0x5727, 0x2647E },
	{ 0x5728, 0x2650C },
	{ 0x5729, 0x2650B },
	{ 0x572A, 0x265CD },
	{ 0x572B, 0x265BE },
	{ 0x572C, 0x265BC },
	{ 0x572D, 0x265BF },
	{ 0x572E, 0x265C0 },
	{ 0x572F, 0x265BD },
	{ 0x5730, 0x26838 },
	{ 0x5731, 0x26808 },
	{ 0x5732, 0x26805 },
	{ 0x5733, 0x2683B },
	{ 0x5734, 0x26810 },
	{ 0x5735, 0x2680C },
	{ 0x5736, 0x2680D },
	{ 0x5737, 0x26804 },
	{ 0x5738, 0x2683A },
	{ 0x5739, 0x26813 },
	{ 0x573A, 0x26837 },
	{ 0x573B, 0x26839 },
	{ 0x573C, 0x2691F },
	{ 0x573D, 0x2694B },
	{ 0x573E, 0x269EE },
	{ 0x573F, 0x26A75 },
	{ 0x5740, 0x26A78 },
	{ 0x5741, 0x26A7C },
	{ 0x5742, 0x26A74 },
	{ 0x5743, 0x26A76 },
	{ 0x5744, 0x26AEA },
	{ 0x5745, 0x26AEB },
	{ 0x5746, 0x26DFB },
	{ 0x5747, 0x26E19 },
	{ 0x5748, 0x26EA7 },
	{ 0x5749, 0x26E8C },
	{ 0x574A, 0x26EDC },
	{ 0x574B, 0x26E98 },
	{ 0x574C, 0x26EBE },
	{ 0x574D, 0x26E9E },
	{ 0x574E, 0x26F0F },
	{ 0x574F, 0x26E9F },
	{ 0x5750, 0x26EDD },
	{ 0x5751, 0x26E93 },
	{ 0x5752, 0x26EBB },
	{ 0x5753, 0x26EB6 },
	{ 0x5754, 0x26E90 },
	{ 0x5755, 0x26EA1 },
	{ 0x5756, 0x26EBD },
	{ 0x5757, 0x26EDE },
	{ 0x5758, 0x26E3A },
	{ 0x5759, 0x26F22 },
	{ 0x575A, 0x26E97 },
	{ 0x575B, 0x26E94 },
	{ 0x575C, 0x26EC3 },
	{ 0x575D, 0x26E8E },
	{ 0x575E, 0x26EA8 },
	{ 0x575F, 0x26E99 },
	{ 0x5760, 0x26EAD },
	{ 0x5761, 0x26E9B },
	{ 0x5762, 0x26EA2 },
	{ 0x5763, 0x26F21 },
	{ 0x5764, 0x26EAC },
	{ 0x5765, 0x26F0E },
	{ 0x5766, 0x26F31 },
	{ 0x5767, 0x271E1 },
	{ 0x5768, 0x271DE },
	{ 0x5769, 0x271DF },
	{ 0x576A, 0x271DC },
	{ 0x576B, 0x271DD },
	{ 0x576C, 0x271EC },
	{ 0x576D, 0x271E7 },
	{ 0x576E, 0x27369 },
	{ 0x576F, 0x273B8 },
	{ 0x5770, 0x273A1 },
	{ 0x5771, 0x273A8 },
	{ 0x5772, 0x273BA },
	{ 0x5773, 0x273C2 },
	{ 0x5774, 0x273A6 },
	{ 0x5775, 0x273A4 },
	{ 0x5776, 0x273A3 },
	{ 0x5777, 0x273AB },
	{ 0x5778, 0x273BC },
	{ 0x5779, 0x273B7 },
	{ 0x577A, 0x273BF },
	{ 0x577B, 0x273AD },
	{ 0x577C, 0x273B1 },
	{ 0x577D, 0x273CA },
	{ 0x577E, 0x273C4 },
	{ 0x5821, 0x273B9 },
	{ 0x5822, 0x275C8 },
	{ 0x5823, 0x275C6 },
	{ 0x5824, 0x275C7 },
	{ 0x5825, 0x2770A },
	{ 0x5826, 0x2770D },
	{ 0x5827, 0x276FB },
	{ 0x5828, 0x27703 },
	{ 0x5829, 0x27702 },
	{ 0x582A, 0x276FC },
	{ 0x582B, 0x276F9 },
	{ 0x582C, 0x276F8 },
	{ 0x582D, 0x2786E },
	{ 0x582E, 0x27863 },
	{ 0x582F, 0x27862 },
	{ 0x5830, 0x27861 },
	{ 0x5831, 0x2786B },
	{ 0x5832, 0x4688 },
	{ 0x5833, 0x2786F },
	{ 0x5834, 0x27866 },
	{ 0x5835, 0x2786C },
	{ 0x5836, 0x2790E },
	{ 0x5837, 0x27915 },
	{ 0x5838, 0x27916 },
	{ 0x5839, 0x27910 },
	{ 0x583A, 0x27917 },
	{ 0x583B, 0x27911 },
	{ 0x583C, 0x27A6E },
	{ 0x583D, 0x27A6C },
	{ 0x583E, 0x27A87 },
	{ 0x583F, 0x27A83 },
	{ 0x5840, 0x27A63 },
	{ 0x5841, 0x27ADC },
	{ 0x5842, 0x27BC0 },
	{ 0x5843, 0x27BF7 },
	{ 0x5844, 0x27BFA },
	{ 0x5845, 0x27C70 },
	{ 0x5846, 0x27C6A },
	{ 0x5847, 0x27C68 },
	{ 0x5848, 0x27C69 },
	{ 0x5849, 0x27C84 },
	{ 0x584A, 0x27CEC },
	{ 0x584B, 0x27CE7 },
	{ 0x584C, 0x27CEE },
	{ 0x584D, 0x27DBA },
	{ 0x584E, 0x27DB2 },
	{ 0x584F, 0x27DB5 },
	{ 0x5850, 0x27DCB },
	{ 0x5851, 0x2080B },
	{ 0x5852, 0x27DD0 },
	{ 0x5853, 0x27E6D },
	{ 0x5854, 0x27E6C },
	{ 0x5855, 0x47BB },
	{ 0x5856, 0x27F45 },
	{ 0x5857, 0x27F46 },
	{ 0x5858, 0x27F34 },
	{ 0x5859, 0x27F2C },
	{ 0x585A, 0x27F35 },
	{ 0x585B, 0x27F44 },
	{ 0x585C, 0x47BA },
	{ 0x585D, 0x27F76 },
	{ 0x585E, 0x280B1 },
	{ 0x585F, 0x280AA },
	{ 0x5860, 0x280A1 },
	{ 0x5861, 0x280B2 },
	{ 0x5862, 0x4812 },
	{ 0x5863, 0x280A6 },
	{ 0x5864, 0x280B5 },
	{ 0x5865, 0x280B4 },
	{ 0x5866, 0x280B8 },
	{ 0x5867, 0x280AF },
	{ 0x5868, 0x280B0 },
	{ 0x5869, 0x280A3 },
	{ 0x586A, 0x28262 },
	{ 0x586B, 0x28264 },
	{ 0x586C, 0x28356 },
	{ 0x586D, 0x28351 },
	{ 0x586E, 0x2834F },
	{ 0x586F, 0x28368 },
	{ 0x5870, 0x2834C },
	{ 0x5871, 0x28350 },
	{ 0x5872, 0x4861 },
	{ 0x5873, 0x28348 },
	{ 0x5874, 0x2834A },
	{ 0x5875, 0x28421 },
	{ 0x5876, 0x285E3 },
	{ 0x5877, 0x285B9 },
	{ 0x5878, 0x285DE },
	{ 0x5879, 0x285B7 },
	{ 0x587A, 0x285E1 },
	{ 0x587B, 0x285B6 },
	{ 0x587C, 0x285B5 },
	{ 0x587D, 0x285DF },
	{ 0x587E, 0x48E1 },
	{ 0x5921, 0x28797 },
	{ 0x5922, 0x2879A },
	{ 0x5923, 0x2879B },
	{ 0x5924, 0x28798 },
	{ 0x5925, 0x28792 },
	{ 0x5926, 0x28793 },
	{ 0x5927, 0x287D7 },
	{ 0x5928, 0x28773 },
	{ 0x5929, 0x2886B },
	{ 0x592A, 0x28874 },
	{ 0x592B, 0x28878 },
	{ 0x592C, 0x2886D },
	{ 0x592D, 0x28918 },
	{ 0x592E, 0x289E9 },
	{ 0x592F, 0x289F5 },
	{ 0x5930, 0x289EA },
	{ 0x5931, 0x28A2E },
	{ 0x5932, 0x289E7 },
	{ 0x5933, 0x289FE },
	{ 0x5934, 0x289E5 },
	{ 0x5935, 0x28A36 },
	{ 0x5936, 0x289F0 },
	{ 0x5937, 0x289E6 },
	{ 0x5938, 0x28A2C },
	{ 0x5939, 0x28C89 },
	{ 0x593A, 0x28C95 },
	{ 0x593B, 0x28C93 },
	{ 0x593C, 0x28D4D },
	{ 0x593D, 0x28D4A },
	{ 0x593E, 0x28D4F },
	{ 0x593F, 0x28D50 },
	{ 0x5940, 0x28D4B },
	{ 0x5941, 0x28F2A },
	{ 0x5942, 0x28F2B },
	{ 0x5943, 0x28F2F },
	{ 0x5944, 0x28F2E },
	{ 0x5945, 0x28F7C },
	{ 0x5946, 0x28FED },
	{ 0x5947, 0x28FE2 },
	{ 0x5948, 0x290E0 },
	{ 0x5949, 0x290DC },
	{ 0x594A, 0x290DA },
	{ 0x594B, 0x290D6 },
	{ 0x594C, 0x290F4 },
	{ 0x594D, 0x290D9 },
	{ 0x594E, 0x290D5 },
	{ 0x594F, 0x29222 },
	{ 0x5950, 0x29221 },
	{ 0x5951, 0x29224 },
	{ 0x5952, 0x29225 },
	{ 0x5953, 0x29226 },
	{ 0x5954, 0x29223 },
	{ 0x5955, 0x292AA },
	{ 0x5956, 0x292AF },
	{ 0x5957, 0x292B0 },
	{ 0x5958, 0x292AB },
	{ 0x5959, 0x293AF },
	{ 0x595A, 0x293B7 },
	{ 0x595B, 0x293B5 },
	{ 0x595C, 0x293B2 },
	{ 0x595D, 0x293B3 },
	{ 0x595E, 0x2942B },
	{ 0x595F, 0x294D8 },
	{ 0x5960, 0x294C2 },
	{ 0x5961, 0x294AF },
	{ 0x5962, 0x294BC },
	{ 0x5963, 0x294B8 },
	{ 0x5964, 0x294BE },
	{ 0x5965, 0x294B7 },
	{ 0x5966, 0x294B4 },
	{ 0x5967, 0x294BF },
	{ 0x5968, 0x294B3 },
	{ 0x5969, 0x294B1 },
	{ 0x596A, 0x294BB },
	{ 0x596B, 0x294BD },
	{ 0x596C, 0x294D6 },
	{ 0x596D, 0x294DD },
	{ 0x596E, 0x295D8 },
	{ 0x596F, 0x295D3 },
	{ 0x5970, 0x295D5 },
	{ 0x5971, 0x295E3 },
	{ 0x5972, 0x295E2 },
	{ 0x5973, 0x295D9 },
	{ 0x5974, 0x295DE },
	{ 0x5975, 0x295DF },
	{ 0x5976, 0x295DA },
	{ 0x5977, 0x295D4 },
	{ 0x5978, 0x296F3 },
	{ 0x5979, 0x296E2 },
	{ 0x597A, 0x2970D },
	{ 0x597B, 0x29701 },
	{ 0x597C, 0x29705 },
	{ 0x597D, 0x2971A },
	{ 0x597E, 0x29703 },
	{ 0x5A21, 0x2971F },
	{ 0x5A22, 0x29716 },
	{ 0x5A23, 0x296FA },
	{ 0x5A24, 0x296FC },
	{ 0x5A25, 0x2970A },
	{ 0x5A26, 0x999F },
	{ 0x5A27, 0x298BC },
	{ 0x5A28, 0x298CA },
	{ 0x5A29, 0x298B6 },
	{ 0x5A2A, 0x298C7 },
	{ 0x5A2B, 0x298BF },
	{ 0x5A2C, 0x4B89 },
	{ 0x5A2D, 0x298B9 },
	{ 0x5A2E, 0x4B8C },
	{ 0x5A2F, 0x298B0 },
	{ 0x5A30, 0x298B8 },
	{ 0x5A31, 0x298BD },
	{ 0x5A32, 0x29891 },
	{ 0x5A33, 0x298BB },
	{ 0x5A34, 0x298BE },
	{ 0x5A35, 0x29A3E },
	{ 0x5A36, 0x29A3D },
	{ 0x5A37, 0x29B38 },
	{ 0x5A38, 0x29B3D },
	{ 0x5A39, 0x29B39 },
	{ 0x5A3A, 0x29B33 },
	{ 0x5A3B, 0x29C33 },
	{ 0x5A3C, 0x29CBB },
	{ 0x5A3D, 0x29CC6 },
	{ 0x5A3E, 0x29CC5 },
	{ 0x5A3F, 0x29CC7 },
	{ 0x5A40, 0x29CCB },
	{ 0x5A41, 0x29CA8 },
	{ 0x5A42, 0x29CC8 },
	{ 0x5A43, 0x29CBE },
	{ 0x5A44, 0x29CC1 },
	{ 0x5A45, 0x29CBD },
	{ 0x5A46, 0x29D82 },
	{ 0x5A47, 0x29D9E },
	{ 0x5A48, 0x29D81 },
	{ 0x5A49, 0x29D84 },
	{ 0x5A4A, 0x9B8D },
	{ 0x5A4B, 0x29D96 },
	{ 0x5A4C, 0x29D8E },
	{ 0x5A4D, 0x29D88 },
	{ 0x5A4E, 0x29D87 },
	{ 0x5A4F, 0x29FE0 },
	{ 0x5A50, 0x2A00D },
	{ 0x5A51, 0x29FDF },
	{ 0x5A52, 0x29FE4 },
	{ 0x5A53, 0x29FE2 },
	{ 0x5A54, 0x29FDD },
	{ 0x5A55, 0x29FEC },
	{ 0x5A56, 0x29FDE },
	{ 0x5A57, 0x29FE7 },
	{ 0x5A58, 0x29FEA },
	{ 0x5A59, 0x29FE3 },
	{ 0x5A5A, 0x2A25C },
	{ 0x5A5B, 0x9E77 },
	{ 0x5A5C, 0x2A25D },
	{ 0x5A5D, 0x2A29C },
	{ 0x5A5E, 0x2A31D },
	{ 0x5A5F, 0x2A39D },
	{ 0x5A60, 0x2A39E },
	{ 0x5A61, 0x2A39B },
	{ 0x5A62, 0x2A3B5 },
	{ 0x5A63, 0x2A3B9 },
	{ 0x5A64, 0x2A3B6 },
	{ 0x5A65, 0x2A3F3 },
	{ 0x5A66, 0x2A3F2 },
	{ 0x5A67, 0x2A3F4 },
	{ 0x5A68, 0x2A426 },
	{ 0x5A69, 0x2A427 },
	{ 0x5A6A, 0x2A425 },
	{ 0x5A6B, 0x2A506 },
	{ 0x5A6C, 0x2A50B },
	{ 0x5A6D, 0x2A53A },
	{ 0x5A6E, 0x2A53C },
	{ 0x5A6F, 0x2040A },
	{ 0x5A70, 0x2040B },
	{ 0x5A71, 0x204BF },
	{ 0x5A72, 0x204FD },
	{ 0x5A73, 0x20618 },
	{ 0x5A74, 0x291DF },
	{ 0x5A75, 0x25390 },
	{ 0x5A76, 0x2069E },
	{ 0x5A77, 0x207FC },
	{ 0x5A78, 0x20810 },
	{ 0x5A79, 0x2080F },
	{ 0x5A7A, 0x2080D },
	{ 0x5A7B, 0x208B9 },
	{ 0x5A7C, 0x208B7 },
	{ 0x5A7D, 0x208BA },
	{ 0x5A7E, 0x2090A },
	{ 0x5B21, 0x21041 },
	{ 0x5B22, 0x2108B },
	{ 0x5B23, 0x21046 },
	{ 0x5B24, 0x21053 },
	{ 0x5B25, 0x210E2 },
	{ 0x5B26, 0x2103F },
	{ 0x5B27, 0x20F7C },
	{ 0x5B28, 0x2104B },
	{ 0x5B29, 0x2104E },
	{ 0x5B2A, 0x2108A },
	{ 0x5B2B, 0x21047 },
	{ 0x5B2C, 0x21493 },
	{ 0x5B2D, 0x27DCE },
	{ 0x5B2E, 0x2148C },
	{ 0x5B2F, 0x214AF },
	{ 0x5B30, 0x214C9 },
	{ 0x5B31, 0x215C6 },
	{ 0x5B32, 0x215C8 },
	{ 0x5B33, 0x21691 },
	{ 0x5B34, 0x218CF },
	{ 0x5B35, 0x218D4 },
	{ 0x5B36, 0x218CE },
	{ 0x5B37, 0x21ADD },
	{ 0x5B38, 0x21AD4 },
	{ 0x5B39, 0x21F49 },
	{ 0x5B3A, 0x21F63 },
	{ 0x5B3B, 0x21F5D },
	{ 0x5B3C, 0x381A },
	{ 0x5B3D, 0x21F67 },
	{ 0x5B3E, 0x21FBB },
	{ 0x5B3F, 0x21F60 },
	{ 0x5B40, 0x21F80 },
	{ 0x5B41, 0x2215F },
	{ 0x5B42, 0x22160 },
	{ 0x5B43, 0x222DA },
	{ 0x5B44, 0x222D2 },
	{ 0x5B45, 0x222DD },
	{ 0x5B46, 0x2258E },
	{ 0x5B47, 0x22588 },
	{ 0x5B48, 0x2256C },
	{ 0x5B49, 0x2289E },
	{ 0x5B4A, 0x228C9 },
	{ 0x5B4B, 0x228A4 },
	{ 0x5B4C, 0x3998 },
	{ 0x5B4D, 0x228D9 },
	{ 0x5B4E, 0x228D2 },
	{ 0x5B4F, 0x228DA },
	{ 0x5B50, 0x228DD },
	{ 0x5B51, 0x228CE },
	{ 0x5B52, 0x228FC },
	{ 0x5B53, 0x22A14 },
	{ 0x5B54, 0x22A60 },
	{ 0x5B55, 0x22DD7 },
	{ 0x5B56, 0x22DCB },
	{ 0x5B57, 0x22DCD },
	{ 0x5B58, 0x22DD5 },
	{ 0x5B59, 0x22EE7 },
	{ 0x5B5A, 0x23000 },
	{ 0x5B5B, 0x2300A },
	{ 0x5B5C, 0x2300F },
	{ 0x5B5D, 0x23002 },
	{ 0x5B5E, 0x23001 },
	{ 0x5B5F, 0x2311D },
	{ 0x5B60, 0x232CA },
	{ 0x5B61, 0x232CB },
	{ 0x5B62, 0x232CD },
	{ 0x5B63, 0x2334F },
	{ 0x5B64, 0x2339C },
	{ 0x5B65, 0x23680 },
	{ 0x5B66, 0x2370D },
	{ 0x5B67, 0x23702 },
	{ 0x5B68, 0x3BF1 },
	{ 0x5B69, 0x23707 },
	{ 0x5B6A, 0x236F7 },
	{ 0x5B6B, 0x236F8 },
	{ 0x5B6C, 0x236FD },
	{ 0x5B6D, 0x23724 },
	{ 0x5B6E, 0x236FB },
	{ 0x5B6F, 0x23739 },
	{ 0x5B70, 0x2373A },
	{ 0x5B71, 0x23922 },
	{ 0x5B72, 0x6BA9 },
	{ 0x5B73, 0x23A6A },
	{ 0x5B74, 0x23A6D },
	{ 0x5B75, 0x23A74 },
	{ 0x5B76, 0x23C0E },
	{ 0x5B77, 0x23FDF },
	{ 0x5B78, 0x2402B },
	{ 0x5B79, 0x23FE3 },
	{ 0x5B7A, 0x24026 },
	{ 0x5B7B, 0x2402A },
	{ 0x5B7C, 0x24023 },
	{ 0x5B7D, 0x24035 },
	{ 0x5B7E, 0x2404A },
	{ 0x5C21, 0x243FD },
	{ 0x5C22, 0x24400 },
	{ 0x5C23, 0x2441E },
	{ 0x5C24, 0x243FF },
	{ 0x5C25, 0x2459E },
	{ 0x5C26, 0x245FA },
	{ 0x5C27, 0x246F1 },
	{ 0x5C28, 0x24895 },
	{ 0x5C29, 0x248A8 },
	{ 0x5C2A, 0x248A6 },
	{ 0x5C2B, 0x24A6E },
	{ 0x5C2C, 0x24A83 },
	{ 0x5C2D, 0x24A6D },
	{ 0x5C2E, 0x24B8F },
	{ 0x5C2F, 0x3F6A },
	{ 0x5C30, 0x24CDF },
	{ 0x5C31, 0x24CD5 },
	{ 0x5C32, 0x24CE0 },
	{ 0x5C33, 0x24CD3 },
	{ 0x5C34, 0x24CD8 },
	{ 0x5C35, 0x24E8C },
	{ 0x5C36, 0x764B },
	{ 0x5C37, 0x24E94 },
	{ 0x5C38, 0x24E96 },
	{ 0x5C39, 0x24E85 },
	{ 0x5C3A, 0x24E8F },
	{ 0x5C3B, 0x24EA9 },
	{ 0x5C3C, 0x24E8E },
	{ 0x5C3D, 0x24E90 },
	{ 0x5C3E, 0x24EB8 },
	{ 0x5C3F, 0x24EC3 },
	{ 0x5C40, 0x24EBB },
	{ 0x5C41, 0x24FA5 },
	{ 0x5C42, 0x24FA2 },
	{ 0x5C43, 0x76A2 },
	{ 0x5C44, 0x24FA3 },
	{ 0x5C45, 0x250B5 },
	{ 0x5C46, 0x250AC },
	{ 0x5C47, 0x250A8 },
	{ 0x5C48, 0x252AD },
	{ 0x5C49, 0x252B8 },
	{ 0x5C4A, 0x252B4 },
	{ 0x5C4B, 0x252AE },
	{ 0x5C4C, 0x252B6 },
	{ 0x5C4D, 0x4485 },
	{ 0x5C4E, 0x252C1 },
	{ 0x5C4F, 0x252BF },
	{ 0x5C50, 0x25392 },
	{ 0x5C51, 0x25400 },
	{ 0x5C52, 0x25401 },
	{ 0x5C53, 0x25575 },
	{ 0x5C54, 0x25572 },
	{ 0x5C55, 0x25578 },
	{ 0x5C56, 0x25570 },
	{ 0x5C57, 0x2557E },
	{ 0x5C58, 0x2557D },
	{ 0x5C59, 0x2557F },
	{ 0x5C5A, 0x256EF },
	{ 0x5C5B, 0x2586D },
	{ 0x5C5C, 0x2588E },
	{ 0x5C5D, 0x2588F },
	{ 0x5C5E, 0x2588A },
	{ 0x5C5F, 0x2588D },
	{ 0x5C60, 0x25895 },
	{ 0x5C61, 0x2588B },
	{ 0x5C62, 0x2588C },
	{ 0x5C63, 0x258B0 },
	{ 0x5C64, 0x25893 },
	{ 0x5C65, 0x259FC },
	{ 0x5C66, 0x25A15 },
	{ 0x5C67, 0x25A0E },
	{ 0x5C68, 0x25A18 },
	{ 0x5C69, 0x25A11 },
	{ 0x5C6A, 0x25A0D },
	{ 0x5C6B, 0x25ABB },
	{ 0x5C6C, 0x25AB3 },
	{ 0x5C6D, 0x4239 },
	{ 0x5C6E, 0x25CA1 },
	{ 0x5C6F, 0x25C9A },
	{ 0x5C70, 0x25C84 },
	{ 0x5C71, 0x25CA0 },
	{ 0x5C72, 0x25C86 },
	{ 0x5C73, 0x25C9D },
	{ 0x5C74, 0x25CAA },
	{ 0x5C75, 0x25C78 },
	{ 0x5C76, 0x25C8D },
	{ 0x5C77, 0x25C8A },
	{ 0x5C78, 0x25CA6 },
	{ 0x5C79, 0x25C7A },
	{ 0x5C7A, 0x25C97 },
	{ 0x5C7B, 0x25C88 },
	{ 0x5C7C, 0x25C8E },
	{ 0x5C7D, 0x423D },
	{ 0x5C7E, 0x4244 },
	{ 0x5D21, 0x25C76 },
	{ 0x5D22, 0x25C81 },
	{ 0x5D23, 0x25C85 },
	{ 0x5D24, 0x25C75 },
	{ 0x5D25, 0x25CA8 },
	{ 0x5D26, 0x25C8F },
	{ 0x5D27, 0x25C91 },
	{ 0x5D28, 0x25CA2 },
	{ 0x5D29, 0x25C9C },
	{ 0x5D2A, 0x25C89 },
	{ 0x5D2B, 0x25C7F },
	{ 0x5D2C, 0x25C96 },
	{ 0x5D2D, 0x25C79 },
	{ 0x5D2E, 0x25C9F },
	{ 0x5D2F, 0x25CA7 },
	{ 0x5D30, 0x4246 },
	{ 0x5D31, 0x25C87 },
	{ 0x5D32, 0x25C9B },
	{ 0x5D33, 0x25CA5 },
	{ 0x5D34, 0x25C8B },
	{ 0x5D35, 0x25CC9 },
	{ 0x5D36, 0x25EFF },
	{ 0x5D37, 0x25F03 },
	{ 0x5D38, 0x25F00 },
	{ 0x5D39, 0x25F02 },
	{ 0x5D3A, 0x25F04 },
	{ 0x5D3B, 0x25F05 },
	{ 0x5D3C, 0x25EE6 },
	{ 0x5D3D, 0x25F1F },
	{ 0x5D3E, 0x26114 },
	{ 0x5D3F, 0x430E },
	{ 0x5D40, 0x2610C },
	{ 0x5D41, 0x2610F },
	{ 0x5D42, 0x26119 },
	{ 0x5D43, 0x2610B },
	{ 0x5D44, 0x26113 },
	{ 0x5D45, 0x260D5 },
	{ 0x5D46, 0x4310 },
	{ 0x5D47, 0x2611C },
	{ 0x5D48, 0x26250 },
	{ 0x5D49, 0x2624E },
	{ 0x5D4A, 0x26312 },
	{ 0x5D4B, 0x263B9 },
	{ 0x5D4C, 0x26485 },
	{ 0x5D4D, 0x26488 },
	{ 0x5D4E, 0x26490 },
	{ 0x5D4F, 0x26513 },
	{ 0x5D50, 0x265D0 },
	{ 0x5D51, 0x265D1 },
	{ 0x5D52, 0x265D2 },
	{ 0x5D53, 0x265D7 },
	{ 0x5D54, 0x265D6 },
	{ 0x5D55, 0x265E5 },
	{ 0x5D56, 0x26846 },
	{ 0x5D57, 0x2686B },
	{ 0x5D58, 0x26845 },
	{ 0x5D59, 0x2683F },
	{ 0x5D5A, 0x2683E },
	{ 0x5D5B, 0x443E },
	{ 0x5D5C, 0x2686A },
	{ 0x5D5D, 0x26868 },
	{ 0x5D5E, 0x2684C },
	{ 0x5D5F, 0x26923 },
	{ 0x5D60, 0x26922 },
	{ 0x5D61, 0x26997 },
	{ 0x5D62, 0x26991 },
	{ 0x5D63, 0x25AB5 },
	{ 0x5D64, 0x26998 },
	{ 0x5D65, 0x2699C },
	{ 0x5D66, 0x26A89 },
	{ 0x5D67, 0x4484 },
	{ 0x5D68, 0x26A8B },
	{ 0x5D69, 0x26A8A },
	{ 0x5D6A, 0x26A8D },
	{ 0x5D6B, 0x26A8E },
	{ 0x5D6C, 0x26A88 },
	{ 0x5D6D, 0x26F4E },
	{ 0x5D6E, 0x26F44 },
	{ 0x5D6F, 0x26F37 },
	{ 0x5D70, 0x26F75 },
	{ 0x5D71, 0x26F54 },
	{ 0x5D72, 0x26F76 },
	{ 0x5D73, 0x26F34 },
	{ 0x5D74, 0x26F6B },
	{ 0x5D75, 0x26F32 },
	{ 0x5D76, 0x26F57 },
	{ 0x5D77, 0x26F52 },
	{ 0x5D78, 0x26F45 },
	{ 0x5D79, 0x4549 },
	{ 0x5D7A, 0x26EB1 },
	{ 0x5D7B, 0x26F4B },
	{ 0x5D7C, 0x26F47 },
	{ 0x5D7D, 0x26F33 },
	{ 0x5D7E, 0x26F40 },
	{ 0x5E21, 0x26F3C },
	{ 0x5E22, 0x26F43 },
	{ 0x5E23, 0x26F4F },
	{ 0x5E24, 0x26F55 },
	{ 0x5E25, 0x26F41 },
	{ 0x5E26, 0x26FB2 },
	{ 0x5E27, 0x26FC0 },
	{ 0x5E28, 0x27434 },
	{ 0x5E29, 0x273F9 },
	{ 0x5E2A, 0x27419 },
	{ 0x5E2B, 0x2740D },
	{ 0x5E2C, 0x273FA },
	{ 0x5E2D, 0x2741E },
	{ 0x5E2E, 0x2741F },
	{ 0x5E2F, 0x2740E },
	{ 0x5E30, 0x27440 },
	{ 0x5E31, 0x27408 },
	{ 0x5E32, 0x45DF },
	{ 0x5E33, 0x27413 },
	{ 0x5E34, 0x2744C },
	{ 0x5E35, 0x45F0 },
	{ 0x5E36, 0x275CC },
	{ 0x5E37, 0x275CB },
	{ 0x5E38, 0x27724 },
	{ 0x5E39, 0x27725 },
	{ 0x5E3A, 0x2773D },
	{ 0x5E3B, 0x27720 },
	{ 0x5E3C, 0x27727 },
	{ 0x5E3D, 0x27726 },
	{ 0x5E3E, 0x2771D },
	{ 0x5E3F, 0x2771E },
	{ 0x5E40, 0x27732 },
	{ 0x5E41, 0x2776C },
	{ 0x5E42, 0x27759 },
	{ 0x5E43, 0x468A },
	{ 0x5E44, 0x2787A },
	{ 0x5E45, 0x27879 },
	{ 0x5E46, 0x2791B },
	{ 0x5E47, 0x2792E },
	{ 0x5E48, 0x27923 },
	{ 0x5E49, 0x27920 },
	{ 0x5E4A, 0x2791F },
	{ 0x5E4B, 0x27AB6 },
	{ 0x5E4C, 0x27AB9 },
	{ 0x5E4D, 0x27AA1 },
	{ 0x5E4E, 0x27AA3 },
	{ 0x5E4F, 0x27AA8 },
	{ 0x5E50, 0x27AAF },
	{ 0x5E51, 0x27A9A },
	{ 0x5E52, 0x27A99 },
	{ 0x5E53, 0x27AA2 },
	{ 0x5E54, 0x27A9D },
	{ 0x5E55, 0x4702 },
	{ 0x5E56, 0x27AAB },
	{ 0x5E57, 0x27BC9 },
	{ 0x5E58, 0x27BFE },
	{ 0x5E59, 0x27C00 },
	{ 0x5E5A, 0x27BFC },
	{ 0x5E5B, 0x27C07 },
	{ 0x5E5C, 0x27C75 },
	{ 0x5E5D, 0x27C72 },
	{ 0x5E5E, 0x27C73 },
	{ 0x5E5F, 0x27C74 },
	{ 0x5E60, 0x27CFA },
	{ 0x5E61, 0x27CFC },
	{ 0x5E62, 0x27CF8 },
	{ 0x5E63, 0x27CF6 },
	{ 0x5E64, 0x27CFB },
	{ 0x5E65, 0x27DCD },
	{ 0x5E66, 0x27DD1 },
	{ 0x5E67, 0x27DCF },
	{ 0x5E68, 0x27E74 },
	{ 0x5E69, 0x27E72 },
	{ 0x5E6A, 0x27E73 },
	{ 0x5E6B, 0x27F54 },
	{ 0x5E6C, 0x27F51 },
	{ 0x5E6D, 0x47C0 },
	{ 0x5E6E, 0x27F53 },
	{ 0x5E6F, 0x27F49 },
	{ 0x5E70, 0x27F4C },
	{ 0x5E71, 0x27F4A },
	{ 0x5E72, 0x27F4F },
	{ 0x5E73, 0x27F56 },
	{ 0x5E74, 0x28100 },
	{ 0x5E75, 0x280D5 },
	{ 0x5E76, 0x280D7 },
	{ 0x5E77, 0x280FF },
	{ 0x5E78, 0x280D9 },
	{ 0x5E79, 0x280E3 },
	{ 0x5E7A, 0x280D3 },
	{ 0x5E7B, 0x4815 },
	{ 0x5E7C, 0x280D8 },
	{ 0x5E7D, 0x280D4 },
	{ 0x5E7E, 0x280DE },
	{ 0x5F21, 0x28271 },
	{ 0x5F22, 0x28374 },
	{ 0x5F23, 0x28388 },
	{ 0x5F24, 0x2837F },
	{ 0x5F25, 0x2836B },
	{ 0x5F26, 0x28387 },
	{ 0x5F27, 0x28379 },
	{ 0x5F28, 0x28378 },
	{ 0x5F29, 0x28389 },
	{ 0x5F2A, 0x28380 },
	{ 0x5F2B, 0x28376 },
	{ 0x5F2C, 0x28429 },
	{ 0x5F2D, 0x28428 },
	{ 0x5F2E, 0x2842F },
	{ 0x5F2F, 0x285E5 },
	{ 0x5F30, 0x28604 },
	{ 0x5F31, 0x28603 },
	{ 0x5F32, 0x285F0 },
	{ 0x5F33, 0x285E8 },
	{ 0x5F34, 0x285EA },
	{ 0x5F35, 0x285F1 },
	{ 0x5F36, 0x28601 },
	{ 0x5F37, 0x28602 },
	{ 0x5F38, 0x287A9 },
	{ 0x5F39, 0x287AB },
	{ 0x5F3A, 0x287B7 },
	{ 0x5F3B, 0x287B6 },
	{ 0x5F3C, 0x48E2 },
	{ 0x5F3D, 0x288A0 },
	{ 0x5F3E, 0x2888E },
	{ 0x5F3F, 0x28886 },
	{ 0x5F40, 0x28887 },
	{ 0x5F41, 0x28885 },
	{ 0x5F42, 0x2888B },
	{ 0x5F43, 0x28888 },
	{ 0x5F44, 0x28890 },
	{ 0x5F45, 0x2891A },
	{ 0x5F46, 0x28934 },
	{ 0x5F47, 0x28A37 },
	{ 0x5F48, 0x28A2F },
	{ 0x5F49, 0x28A30 },
	{ 0x5F4A, 0x28A39 },
	{ 0x5F4B, 0x28A34 },
	{ 0x5F4C, 0x28A33 },
	{ 0x5F4D, 0x28A85 },
	{ 0x5F4E, 0x28A84 },
	{ 0x5F4F, 0x28A3A },
	{ 0x5F50, 0x28C9F },
	{ 0x5F51, 0x28D69 },
	{ 0x5F52, 0x28D6C },
	{ 0x5F53, 0x28D6A },
	{ 0x5F54, 0x28D67 },
	{ 0x5F55, 0x28D6B },
	{ 0x5F56, 0x28F3F },
	{ 0x5F57, 0x28F40 },
	{ 0x5F58, 0x2900B },
	{ 0x5F59, 0x290D2 },
	{ 0x5F5A, 0x290F8 },
	{ 0x5F5B, 0x29101 },
	{ 0x5F5C, 0x290FA },
	{ 0x5F5D, 0x29116 },
	{ 0x5F5E, 0x2F9F6 },
	{ 0x5F5F, 0x2922C },
	{ 0x5F60, 0x2922D },
	{ 0x5F61, 0x2922F },
	{ 0x5F62, 0x2922E },
	{ 0x5F63, 0x292C1 },
	{ 0x5F64, 0x292F5 },
	{ 0x5F65, 0x292C4 },
	{ 0x5F66, 0x292DE },
	{ 0x5F67, 0x292CC },
	{ 0x5F68, 0x292D2 },
	{ 0x5F69, 0x292C2 },
	{ 0x5F6A, 0x292CD },
	{ 0x5F6B, 0x292CF },
	{ 0x5F6C, 0x292DD },
	{ 0x5F6D, 0x292C8 },
	{ 0x5F6E, 0x293BA },
	{ 0x5F6F, 0x293BE },
	{ 0x5F70, 0x293BF },
	{ 0x5F71, 0x2942E },
	{ 0x5F72, 0x29430 },
	{ 0x5F73, 0x294E7 },
	{ 0x5F74, 0x294EE },
	{ 0x5F75, 0x294E8 },
	{ 0x5F76, 0x294E6 },
	{ 0x5F77, 0x294E2 },
	{ 0x5F78, 0x294E4 },
	{ 0x5F79, 0x294FB },
	{ 0x5F7A, 0x294FC },
	{ 0x5F7B, 0x294EA },
	{ 0x5F7C, 0x295ED },
	{ 0x5F7D, 0x295F6 },
	{ 0x5F7E, 0x295F3 },
	{ 0x6021, 0x295F4 },
	{ 0x6022, 0x295F1 },
	{ 0x6023, 0x295F7 },
	{ 0x6024, 0x295F5 },
	{ 0x6025, 0x295EA },
	{ 0x6026, 0x295EB },
	{ 0x6027, 0x29700 },
	{ 0x6028, 0x2972C },
	{ 0x6029, 0x29712 },
	{ 0x602A, 0x2973D },
	{ 0x602B, 0x29733 },
	{ 0x602C, 0x4B4D },
	{ 0x602D, 0x29730 },
	{ 0x602E, 0x29740 },
	{ 0x602F, 0x29731 },
	{ 0x6030, 0x29757 },
	{ 0x6031, 0x4B4A },
	{ 0x6032, 0x29735 },
	{ 0x6033, 0x29732 },
	{ 0x6034, 0x2972D },
	{ 0x6035, 0x29736 },
	{ 0x6036, 0x29738 },
	{ 0x6037, 0x29762 },
	{ 0x6038, 0x2975F },
	{ 0x6039, 0x2978A },
	{ 0x603A, 0x298D6 },
	{ 0x603B, 0x298D8 },
	{ 0x603C, 0x298DD },
	{ 0x603D, 0x298E4 },
	{ 0x603E, 0x298E3 },
	{ 0x603F, 0x29A4D },
	{ 0x6040, 0x29AD7 },
	{ 0x6041, 0x29B4A },
	{ 0x6042, 0x29B4C },
	{ 0x6043, 0x29B50 },
	{ 0x6044, 0x29B4B },
	{ 0x6045, 0x29B4E },
	{ 0x6046, 0x29B4F },
	{ 0x6047, 0x29C39 },
	{ 0x6048, 0x29CD2 },
	{ 0x6049, 0x29CCD },
	{ 0x604A, 0x29CD3 },
	{ 0x604B, 0x29CE1 },
	{ 0x604C, 0x29CCE },
	{ 0x604D, 0x29CD5 },
	{ 0x604E, 0x29CDD },
	{ 0x604F, 0x29CD4 },
	{ 0x6050, 0x29CCF },
	{ 0x6051, 0x29DCB },
	{ 0x6052, 0x29DA6 },
	{ 0x6053, 0x29DC2 },
	{ 0x6054, 0x29DA5 },
	{ 0x6055, 0x29DA9 },
	{ 0x6056, 0x29DA2 },
	{ 0x6057, 0x29DA4 },
	{ 0x6058, 0x29DB0 },
	{ 0x6059, 0x29DCC },
	{ 0x605A, 0x29DAF },
	{ 0x605B, 0x29DBF },
	{ 0x605C, 0x2A024 },
	{ 0x605D, 0x2A01A },
	{ 0x605E, 0x2A014 },
	{ 0x605F, 0x2A03A },
	{ 0x6060, 0x2A020 },
	{ 0x6061, 0x2A01B },
	{ 0x6062, 0x2A021 },
	{ 0x6063, 0x2A025 },
	{ 0x6064, 0x2A01E },
	{ 0x6065, 0x2A03F },
	{ 0x6066, 0x2A040 },
	{ 0x6067, 0x2A018 },
	{ 0x6068, 0x2A02C },
	{ 0x6069, 0x2A015 },
	{ 0x606A, 0x2A02D },
	{ 0x606B, 0x2A01F },
	{ 0x606C, 0x2A029 },
	{ 0x606D, 0x2A04B },
	{ 0x606E, 0x2A2B3 },
	{ 0x606F, 0x2A2A5 },
	{ 0x6070, 0x2A2A7 },
	{ 0x6071, 0x2A2AB },
	{ 0x6072, 0x2A2A6 },
	{ 0x6073, 0x2A2AA },
	{ 0x6074, 0x2A322 },
	{ 0x6075, 0x2A323 },
	{ 0x6076, 0x2A3A1 },
	{ 0x6077, 0x2A3A3 },
	{ 0x6078, 0x2A3A0 },
	{ 0x6079, 0x2A3BD },
	{ 0x607A, 0x2A3BA },
	{ 0x607B, 0x2A3FA },
	{ 0x607C, 0x2A3F8 },
	{ 0x607D, 0x2A3FC },
	{ 0x607E, 0x2A3F6 },
	{ 0x6121, 0x2A434 },
	{ 0x6122, 0x2A443 },
	{ 0x6123, 0x4D63 },
	{ 0x6124, 0x2A4D4 },
	{ 0x6125, 0x2A50D },
	{ 0x6126, 0x2A543 },
	{ 0x6127, 0x2A541 },
	{ 0x6128, 0x2A53D },
	{ 0x6129, 0x2A540 },
	{ 0x612A, 0x2A53E },
	{ 0x612B, 0x2A53F },
	{ 0x612C, 0x2A546 },
	{ 0x612D, 0x4D93 },
	{ 0x612E, 0x2A5D4 },
	{ 0x612F, 0x20435 },
	{ 0x6130, 0x20436 },
	{ 0x6131, 0x20432 },
	{ 0x6132, 0x2043A },
	{ 0x6133, 0x204C8 },
	{ 0x6134, 0x20536 },
	{ 0x6135, 0x2061E },
	{ 0x6136, 0x2061D },
	{ 0x6137, 0x2061F },
	{ 0x6138, 0x2081C },
	{ 0x6139, 0x2081D },
	{ 0x613A, 0x20820 },
	{ 0x613B, 0x350E },
	{ 0x613C, 0x208C0 },
	{ 0x613D, 0x2109A },
	{ 0x613E, 0x21093 },
	{ 0x613F, 0x210DD },
	{ 0x6140, 0x360A },
	{ 0x6141, 0x210A3 },
	{ 0x6142, 0x210A9 },
	{ 0x6143, 0x2109C },
	{ 0x6144, 0x2109B },
	{ 0x6145, 0x360D },
	{ 0x6146, 0x21097 },
	{ 0x6147, 0x214B1 },
	{ 0x6148, 0x214CA },
	{ 0x6149, 0x214B3 },
	{ 0x614A, 0x214CD },
	{ 0x614B, 0x218EA },
	{ 0x614C, 0x218EE },
	{ 0x614D, 0x218EF },
	{ 0x614E, 0x21ADF },
	{ 0x614F, 0x21B50 },
	{ 0x6150, 0x21BBB },
	{ 0x6151, 0x21F88 },
	{ 0x6152, 0x21F89 },
	{ 0x6153, 0x21F8C },
	{ 0x6154, 0x21F85 },
	{ 0x6155, 0x21F5E },
	{ 0x6156, 0x21F94 },
	{ 0x6157, 0x21F95 },
	{ 0x6158, 0x2216B },
	{ 0x6159, 0x2216A },
	{ 0x615A, 0x22169 },
	{ 0x615B, 0x222E3 },
	{ 0x615C, 0x222F1 },
	{ 0x615D, 0x22437 },
	{ 0x615E, 0x22433 },
	{ 0x615F, 0x22591 },
	{ 0x6160, 0x2258F },
	{ 0x6161, 0x22597 },
	{ 0x6162, 0x228D4 },
	{ 0x6163, 0x228DE },
	{ 0x6164, 0x228D3 },
	{ 0x6165, 0x228E0 },
	{ 0x6166, 0x22943 },
	{ 0x6167, 0x2290B },
	{ 0x6168, 0x228FF },
	{ 0x6169, 0x22904 },
	{ 0x616A, 0x22907 },
	{ 0x616B, 0x22DF9 },
	{ 0x616C, 0x22DFA },
	{ 0x616D, 0x22DFB },
	{ 0x616E, 0x22DF8 },
	{ 0x616F, 0x23012 },
	{ 0x6170, 0x23010 },
	{ 0x6171, 0x2311F },
	{ 0x6172, 0x232DF },
	{ 0x6173, 0x232E3 },
	{ 0x6174, 0x23352 },
	{ 0x6175, 0x233A9 },
	{ 0x6176, 0x23765 },
	{ 0x6177, 0x23787 },
	{ 0x6178, 0x23742 },
	{ 0x6179, 0x23752 },
	{ 0x617A, 0x2374C },
	{ 0x617B, 0x2369F },
	{ 0x617C, 0x23701 },
	{ 0x617D, 0x23748 },
	{ 0x617E, 0x2374F },
	{ 0x6221, 0x2377E },
	{ 0x6222, 0x2374D },
	{ 0x6223, 0x23758 },
	{ 0x6224, 0x23747 },
	{ 0x6225, 0x2375E },
	{ 0x6226, 0x23749 },
	{ 0x6227, 0x2374E },
	{ 0x6228, 0x2375D },
	{ 0x6229, 0x2375A },
	{ 0x622A, 0x23786 },
	{ 0x622B, 0x23751 },
	{ 0x622C, 0x23929 },
	{ 0x622D, 0x239A6 },
	{ 0x622E, 0x239A7 },
	{ 0x622F, 0x23A70 },
	{ 0x6230, 0x23A6F },
	{ 0x6231, 0x23AD3 },
	{ 0x6232, 0x23AD2 },
	{ 0x6233, 0x23C28 },
	{ 0x6234, 0x23C1B },
	{ 0x6235, 0x23C1A },
	{ 0x6236, 0x23C1C },
	{ 0x6237, 0x23C21 },
	{ 0x6238, 0x24032 },
	{ 0x6239, 0x24066 },
	{ 0x623A, 0x2407D },
	{ 0x623B, 0x24073 },
	{ 0x623C, 0x2407F },
	{ 0x623D, 0x24065 },
	{ 0x623E, 0x24080 },
	{ 0x623F, 0x24061 },
	{ 0x6240, 0x24075 },
	{ 0x6241, 0x2406E },
	{ 0x6242, 0x24067 },
	{ 0x6243, 0x24071 },
	{ 0x6244, 0x2406C },
	{ 0x6245, 0x24063 },
	{ 0x6246, 0x24062 },
	{ 0x6247, 0x24083 },
	{ 0x6248, 0x240B2 },
	{ 0x6249, 0x24081 },
	{ 0x624A, 0x2406F },
	{ 0x624B, 0x2406B },
	{ 0x624C, 0x24082 },
	{ 0x624D, 0x2408A },
	{ 0x624E, 0x24429 },
	{ 0x624F, 0x24430 },
	{ 0x6250, 0x24431 },
	{ 0x6251, 0x24597 },
	{ 0x6252, 0x24600 },
	{ 0x6253, 0x245FF },
	{ 0x6254, 0x248B6 },
	{ 0x6255, 0x248B5 },
	{ 0x6256, 0x248C3 },
	{ 0x6257, 0x24A8D },
	{ 0x6258, 0x24B18 },
	{ 0x6259, 0x24B9C },
	{ 0x625A, 0x24B9A },
	{ 0x625B, 0x24B99 },
	{ 0x625C, 0x24EB7 },
	{ 0x625D, 0x24EC4 },
	{ 0x625E, 0x24EC6 },
	{ 0x625F, 0x24EC7 },
	{ 0x6260, 0x24EBC },
	{ 0x6261, 0x24EC0 },
	{ 0x6262, 0x24EC5 },
	{ 0x6263, 0x24ECD },
	{ 0x6264, 0x24EC1 },
	{ 0x6265, 0x24EBE },
	{ 0x6266, 0x24FA7 },
	{ 0x6267, 0x24FB8 },
	{ 0x6268, 0x25023 },
	{ 0x6269, 0x4074 },
	{ 0x626A, 0x252E8 },
	{ 0x626B, 0x252DE },
	{ 0x626C, 0x252E3 },
	{ 0x626D, 0x252EF },
	{ 0x626E, 0x252DC },
	{ 0x626F, 0x252E4 },
	{ 0x6270, 0x252E1 },
	{ 0x6271, 0x252E5 },
	{ 0x6272, 0x25395 },
	{ 0x6273, 0x25394 },
	{ 0x6274, 0x25393 },
	{ 0x6275, 0x2538E },
	{ 0x6276, 0x25598 },
	{ 0x6277, 0x2559C },
	{ 0x6278, 0x25599 },
	{ 0x6279, 0x255A0 },
	{ 0x627A, 0x2559E },
	{ 0x627B, 0x25704 },
	{ 0x627C, 0x258D3 },
	{ 0x627D, 0x258B4 },
	{ 0x627E, 0x258BB },
	{ 0x6321, 0x258B7 },
	{ 0x6322, 0x258B8 },
	{ 0x6323, 0x258BD },
	{ 0x6324, 0x258B6 },
	{ 0x6325, 0x258B9 },
	{ 0x6326, 0x258B5 },
	{ 0x6327, 0x25A22 },
	{ 0x6328, 0x25A21 },
	{ 0x6329, 0x25AC3 },
	{ 0x632A, 0x25ABC },
	{ 0x632B, 0x25CFF },
	{ 0x632C, 0x25CE5 },
	{ 0x632D, 0x25CF7 },
	{ 0x632E, 0x25CD2 },
	{ 0x632F, 0x25D00 },
	{ 0x6330, 0x25CDB },
	{ 0x6331, 0x25CF0 },
	{ 0x6332, 0x25CE2 },
	{ 0x6333, 0x25CCD },
	{ 0x6334, 0x4256 },
	{ 0x6335, 0x25CE1 },
	{ 0x6336, 0x25CF2 },
	{ 0x6337, 0x25CDC },
	{ 0x6338, 0x25CCC },
	{ 0x6339, 0x25CD6 },
	{ 0x633A, 0x25CF3 },
	{ 0x633B, 0x25CFA },
	{ 0x633C, 0x25CF6 },
	{ 0x633D, 0x25CEC },
	{ 0x633E, 0x25CEA },
	{ 0x633F, 0x25CE3 },
	{ 0x6340, 0x25CD0 },
	{ 0x6341, 0x425A },
	{ 0x6342, 0x25C95 },
	{ 0x6343, 0x25CD5 },
	{ 0x6344, 0x25CF4 },
	{ 0x6345, 0x25CCB },
	{ 0x6346, 0x25CDA },
	{ 0x6347, 0x25CC8 },
	{ 0x6348, 0x25CDF },
	{ 0x6349, 0x25CF5 },
	{ 0x634A, 0x25CCF },
	{ 0x634B, 0x25CC7 },
	{ 0x634C, 0x25CD7 },
	{ 0x634D, 0x25F24 },
	{ 0x634E, 0x42A3 },
	{ 0x634F, 0x25F1C },
	{ 0x6350, 0x25F21 },
	{ 0x6351, 0x25F1E },
	{ 0x6352, 0x25F18 },
	{ 0x6353, 0x25F1B },
	{ 0x6354, 0x42A8 },
	{ 0x6355, 0x26146 },
	{ 0x6356, 0x2614B },
	{ 0x6357, 0x26148 },
	{ 0x6358, 0x26147 },
	{ 0x6359, 0x26167 },
	{ 0x635A, 0x26154 },
	{ 0x635B, 0x26315 },
	{ 0x635C, 0x26322 },
	{ 0x635D, 0x263C5 },
	{ 0x635E, 0x26329 },
	{ 0x635F, 0x263C7 },
	{ 0x6360, 0x2648D },
	{ 0x6361, 0x2651B },
	{ 0x6362, 0x26520 },
	{ 0x6363, 0x265E2 },
	{ 0x6364, 0x265E7 },
	{ 0x6365, 0x265E8 },
	{ 0x6366, 0x265E1 },
	{ 0x6367, 0x26872 },
	{ 0x6368, 0x2687B },
	{ 0x6369, 0x26874 },
	{ 0x636A, 0x26871 },
	{ 0x636B, 0x26879 },
	{ 0x636C, 0x26875 },
	{ 0x636D, 0x26890 },
	{ 0x636E, 0x26877 },
	{ 0x636F, 0x2687D },
	{ 0x6370, 0x2694F },
	{ 0x6371, 0x26950 },
	{ 0x6372, 0x269A3 },
	{ 0x6373, 0x269A2 },
	{ 0x6374, 0x269F4 },
	{ 0x6375, 0x26A94 },
	{ 0x6376, 0x26A9A },
	{ 0x6377, 0x26A9B },
	{ 0x6378, 0x26AA7 },
	{ 0x6379, 0x26A97 },
	{ 0x637A, 0x26A95 },
	{ 0x637B, 0x26A92 },
	{ 0x637C, 0x26A9C },
	{ 0x637D, 0x26A96 },
	{ 0x637E, 0x26FB6 },
	{ 0x6421, 0x26FB8 },
	{ 0x6422, 0x26FB0 },
	{ 0x6423, 0x27018 },
	{ 0x6424, 0x26FC5 },
	{ 0x6425, 0x26FB5 },
	{ 0x6426, 0x26FC2 },
	{ 0x6427, 0x27006 },
	{ 0x6428, 0x27019 },
	{ 0x6429, 0x26FB9 },
	{ 0x642A, 0x27015 },
	{ 0x642B, 0x26FD6 },
	{ 0x642C, 0x26FAC },
	{ 0x642D, 0x453C },
	{ 0x642E, 0x26FC6 },
	{ 0x642F, 0x26FB3 },
	{ 0x6430, 0x26FC3 },
	{ 0x6431, 0x26FCA },
	{ 0x6432, 0x26FCF },
	{ 0x6433, 0x26FBD },
	{ 0x6434, 0x26FCE },
	{ 0x6435, 0x27014 },
	{ 0x6436, 0x26FBA },
	{ 0x6437, 0x2701A },
	{ 0x6438, 0x26FC1 },
	{ 0x6439, 0x26FBB },
	{ 0x643A, 0x459B },
	{ 0x643B, 0x459A },
	{ 0x643C, 0x27201 },
	{ 0x643D, 0x271FC },
	{ 0x643E, 0x2745A },
	{ 0x643F, 0x27454 },
	{ 0x6440, 0x27461 },
	{ 0x6441, 0x2745C },
	{ 0x6442, 0x27455 },
	{ 0x6443, 0x2744A },
	{ 0x6444, 0x2744B },
	{ 0x6445, 0x27451 },
	{ 0x6446, 0x27469 },
	{ 0x6447, 0x2746B },
	{ 0x6448, 0x87F1 },
	{ 0x6449, 0x27466 },
	{ 0x644A, 0x27458 },
	{ 0x644B, 0x2745D },
	{ 0x644C, 0x27467 },
	{ 0x644D, 0x27456 },
	{ 0x644E, 0x27488 },
	{ 0x644F, 0x27464 },
	{ 0x6450, 0x2744E },
	{ 0x6451, 0x27757 },
	{ 0x6452, 0x2775A },
	{ 0x6453, 0x27751 },
	{ 0x6454, 0x2774A },
	{ 0x6455, 0x2774B },
	{ 0x6456, 0x465E },
	{ 0x6457, 0x27747 },
	{ 0x6458, 0x2776F },
	{ 0x6459, 0x2776A },
	{ 0x645A, 0x2776B },
	{ 0x645B, 0x27746 },
	{ 0x645C, 0x2776D },
	{ 0x645D, 0x27754 },
	{ 0x645E, 0x2776E },
	{ 0x645F, 0x2774C },
	{ 0x6460, 0x27878 },
	{ 0x6461, 0x27886 },
	{ 0x6462, 0x27882 },
	{ 0x6463, 0x46A7 },
	{ 0x6464, 0x27AE1 },
	{ 0x6465, 0x27AE5 },
	{ 0x6466, 0x27ADB },
	{ 0x6467, 0x27ADE },
	{ 0x6468, 0x27AD7 },
	{ 0x6469, 0x27C03 },
	{ 0x646A, 0x27C7C },
	{ 0x646B, 0x27C7E },
	{ 0x646C, 0x27D05 },
	{ 0x646D, 0x27D07 },
	{ 0x646E, 0x27DE6 },
	{ 0x646F, 0x27DE1 },
	{ 0x6470, 0x27DFB },
	{ 0x6471, 0x27DE5 },
	{ 0x6472, 0x27DE7 },
	{ 0x6473, 0x27DDF },
	{ 0x6474, 0x27DFF },
	{ 0x6475, 0x27E76 },
	{ 0x6476, 0x27F63 },
	{ 0x6477, 0x27F66 },
	{ 0x6478, 0x27F65 },
	{ 0x6479, 0x27F5E },
	{ 0x647A, 0x27F64 },
	{ 0x647B, 0x27F6B },
	{ 0x647C, 0x27F5F },
	{ 0x647D, 0x27F67 },
	{ 0x647E, 0x27F68 },
	{ 0x6521, 0x28108 },
	{ 0x6522, 0x28109 },
	{ 0x6523, 0x28117 },
	{ 0x6524, 0x28115 },
	{ 0x6525, 0x2811B },
	{ 0x6526, 0x2810B },
	{ 0x6527, 0x28128 },
	{ 0x6528, 0x2810E },
	{ 0x6529, 0x28118 },
	{ 0x652A, 0x28153 },
	{ 0x652B, 0x28145 },
	{ 0x652C, 0x2810D },
	{ 0x652D, 0x2810A },
	{ 0x652E, 0x28113 },
	{ 0x652F, 0x2814A },
	{ 0x6530, 0x28279 },
	{ 0x6531, 0x283A1 },
	{ 0x6532, 0x2838D },
	{ 0x6533, 0x283A2 },
	{ 0x6534, 0x28390 },
	{ 0x6535, 0x486E },
	{ 0x6536, 0x28431 },
	{ 0x6537, 0x28430 },
	{ 0x6538, 0x2861F },
	{ 0x6539, 0x28619 },
	{ 0x653A, 0x2860C },
	{ 0x653B, 0x2861E },
	{ 0x653C, 0x2861D },
	{ 0x653D, 0x28607 },
	{ 0x653E, 0x28766 },
	{ 0x653F, 0x287C5 },
	{ 0x6540, 0x287BA },
	{ 0x6541, 0x287BD },
	{ 0x6542, 0x287C2 },
	{ 0x6543, 0x287C3 },
	{ 0x6544, 0x287BF },
	{ 0x6545, 0x490D },
	{ 0x6546, 0x288A1 },
	{ 0x6547, 0x288A2 },
	{ 0x6548, 0x288A8 },
	{ 0x6549, 0x288A3 },
	{ 0x654A, 0x288AA },
	{ 0x654B, 0x288AF },
	{ 0x654C, 0x288B9 },
	{ 0x654D, 0x28937 },
	{ 0x654E, 0x28A8F },
	{ 0x654F, 0x4943 },
	{ 0x6550, 0x28A8E },
	{ 0x6551, 0x28A87 },
	{ 0x6552, 0x28A8A },
	{ 0x6553, 0x28A92 },
	{ 0x6554, 0x28A97 },
	{ 0x6555, 0x28A9F },
	{ 0x6556, 0x28B05 },
	{ 0x6557, 0x28CA9 },
	{ 0x6558, 0x28CA7 },
	{ 0x6559, 0x28D8A },
	{ 0x655A, 0x28D82 },
	{ 0x655B, 0x28D85 },
	{ 0x655C, 0x28D8B },
	{ 0x655D, 0x28D89 },
	{ 0x655E, 0x28D81 },
	{ 0x655F, 0x28D80 },
	{ 0x6560, 0x28D87 },
	{ 0x6561, 0x28D86 },
	{ 0x6562, 0x28F4D },
	{ 0x6563, 0x2901C },
	{ 0x6564, 0x2901F },
	{ 0x6565, 0x29121 },
	{ 0x6566, 0x2911D },
	{ 0x6567, 0x29122 },
	{ 0x6568, 0x290FE },
	{ 0x6569, 0x2911B },
	{ 0x656A, 0x2913A },
	{ 0x656B, 0x29137 },
	{ 0x656C, 0x29117 },
	{ 0x656D, 0x29138 },
	{ 0x656E, 0x29126 },
	{ 0x656F, 0x29118 },
	{ 0x6570, 0x29234 },
	{ 0x6571, 0x29235 },
	{ 0x6572, 0x29232 },
	{ 0x6573, 0x4A73 },
	{ 0x6574, 0x292E1 },
	{ 0x6575, 0x292FD },
	{ 0x6576, 0x292E3 },
	{ 0x6577, 0x292E8 },
	{ 0x6578, 0x292F9 },
	{ 0x6579, 0x292FF },
	{ 0x657A, 0x292FE },
	{ 0x657B, 0x4A74 },
	{ 0x657C, 0x292E0 },
	{ 0x657D, 0x29300 },
	{ 0x657E, 0x4A70 },
	{ 0x6621, 0x292EC },
	{ 0x6622, 0x292E4 },
	{ 0x6623, 0x292EF },
	{ 0x6624, 0x292FA },
	{ 0x6625, 0x293CA },
	{ 0x6626, 0x29431 },
	{ 0x6627, 0x29432 },
	{ 0x6628, 0x29434 },
	{ 0x6629, 0x29441 },
	{ 0x662A, 0x29500 },
	{ 0x662B, 0x29506 },
	{ 0x662C, 0x29508 },
	{ 0x662D, 0x29505 },
	{ 0x662E, 0x29503 },
	{ 0x662F, 0x2950B },
	{ 0x6630, 0x29502 },
	{ 0x6631, 0x2950A },
	{ 0x6632, 0x295F0 },
	{ 0x6633, 0x29613 },
	{ 0x6634, 0x2960A },
	{ 0x6635, 0x2960F },
	{ 0x6636, 0x29611 },
	{ 0x6637, 0x29608 },
	{ 0x6638, 0x2960B },
	{ 0x6639, 0x29612 },
	{ 0x663A, 0x2960D },
	{ 0x663B, 0x2975B },
	{ 0x663C, 0x29763 },
	{ 0x663D, 0x29761 },
	{ 0x663E, 0x29768 },
	{ 0x663F, 0x2975A },
	{ 0x6640, 0x2984E },
	{ 0x6641, 0x2984D },
	{ 0x6642, 0x29850 },
	{ 0x6643, 0x298FC },
	{ 0x6644, 0x29912 },
	{ 0x6645, 0x298F5 },
	{ 0x6646, 0x2991E },
	{ 0x6647, 0x298F0 },
	{ 0x6648, 0x298F3 },
	{ 0x6649, 0x298F2 },
	{ 0x664A, 0x29901 },
	{ 0x664B, 0x298EF },
	{ 0x664C, 0x298EE },
	{ 0x664D, 0x29916 },
	{ 0x664E, 0x298F6 },
	{ 0x664F, 0x298FB },
	{ 0x6650, 0x2991C },
	{ 0x6651, 0x4BDB },
	{ 0x6652, 0x29A5D },
	{ 0x6653, 0x29A60 },
	{ 0x6654, 0x29A66 },
	{ 0x6655, 0x29A5F },
	{ 0x6656, 0x29A61 },
	{ 0x6657, 0x29A5B },
	{ 0x6658, 0x29A62 },
	{ 0x6659, 0x29A57 },
	{ 0x665A, 0x29B69 },
	{ 0x665B, 0x29B6B },
	{ 0x665C, 0x29B61 },
	{ 0x665D, 0x29B77 },
	{ 0x665E, 0x29B5F },
	{ 0x665F, 0x29B63 },
	{ 0x6660, 0x29B62 },
	{ 0x6661, 0x29B65 },
	{ 0x6662, 0x29CEF },
	{ 0x6663, 0x29CE2 },
	{ 0x6664, 0x29D00 },
	{ 0x6665, 0x29CE8 },
	{ 0x6666, 0x29CF2 },
	{ 0x6667, 0x29CE7 },
	{ 0x6668, 0x4C29 },
	{ 0x6669, 0x29CE5 },
	{ 0x666A, 0x29DD5 },
	{ 0x666B, 0x29DD0 },
	{ 0x666C, 0x29DDA },
	{ 0x666D, 0x29DD3 },
	{ 0x666E, 0x4C51 },
	{ 0x666F, 0x29DD9 },
	{ 0x6670, 0x29DCF },
	{ 0x6671, 0x29DD6 },
	{ 0x6672, 0x29DD8 },
	{ 0x6673, 0x29DF5 },
	{ 0x6674, 0x29DCE },
	{ 0x6675, 0x29DD7 },
	{ 0x6676, 0x29DF4 },
	{ 0x6677, 0x29DCD },
	{ 0x6678, 0x29E01 },
	{ 0x6679, 0x9BBA },
	{ 0x667A, 0x2A052 },
	{ 0x667B, 0x2A055 },
	{ 0x667C, 0x2A05A },
	{ 0x667D, 0x2A04D },
	{ 0x667E, 0x2A054 },
	{ 0x6721, 0x2A053 },
	{ 0x6722, 0x2A05E },
	{ 0x6723, 0x2A067 },
	{ 0x6724, 0x2A065 },
	{ 0x6725, 0x2A04E },
	{ 0x6726, 0x4CDB },
	{ 0x6727, 0x2A04F },
	{ 0x6728, 0x2A061 },
	{ 0x6729, 0x2A06E },
	{ 0x672A, 0x2A051 },
	{ 0x672B, 0x2A05B },
	{ 0x672C, 0x2A263 },
	{ 0x672D, 0x2A2B7 },
	{ 0x672E, 0x2A2B6 },
	{ 0x672F, 0x2A2C3 },
	{ 0x6730, 0x2A2BB },
	{ 0x6731, 0x2A2B5 },
	{ 0x6732, 0x2A32E },
	{ 0x6733, 0x2A330 },
	{ 0x6734, 0x2A333 },
	{ 0x6735, 0x2A331 },
	{ 0x6736, 0x2A3A4 },
	{ 0x6737, 0x2A3C1 },
	{ 0x6738, 0x2A3BB },
	{ 0x6739, 0x2A3BE },
	{ 0x673A, 0x2A400 },
	{ 0x673B, 0x2A3FF },
	{ 0x673C, 0x2A440 },
	{ 0x673D, 0x4D65 },
	{ 0x673E, 0x2A43F },
	{ 0x673F, 0x2A444 },
	{ 0x6740, 0x4D64 },
	{ 0x6741, 0x4D67 },
	{ 0x6742, 0x2A4DB },
	{ 0x6743, 0x2A50F },
	{ 0x6744, 0x2A511 },
	{ 0x6745, 0x2A54E },
	{ 0x6746, 0x2A54D },
	{ 0x6747, 0x2A54B },
	{ 0x6748, 0x2A54C },
	{ 0x6749, 0x2A595 },
	{ 0x674A, 0x2043B },
	{ 0x674B, 0x20445 },
	{ 0x674C, 0x20444 },
	{ 0x674D, 0x2043E },
	{ 0x674E, 0x2043C },
	{ 0x674F, 0x2043F },
	{ 0x6750, 0x204CC },
	{ 0x6751, 0x204CE },
	{ 0x6752, 0x20622 },
	{ 0x6753, 0x20623 },
	{ 0x6754, 0x2069F },
	{ 0x6755, 0x208C5 },
	{ 0x6756, 0x208C4 },
	{ 0x6757, 0x210E9 },
	{ 0x6758, 0x21099 },
	{ 0x6759, 0x3611 },
	{ 0x675A, 0x210E6 },
	{ 0x675B, 0x210E7 },
	{ 0x675C, 0x210F7 },
	{ 0x675D, 0x214D2 },
	{ 0x675E, 0x3733 },
	{ 0x675F, 0x218FD },
	{ 0x6760, 0x2190C },
	{ 0x6761, 0x2190B },
	{ 0x6762, 0x21CED },
	{ 0x6763, 0x3821 },
	{ 0x6764, 0x3822 },
	{ 0x6765, 0x21F9B },
	{ 0x6766, 0x2200A },
	{ 0x6767, 0x2216F },
	{ 0x6768, 0x22175 },
	{ 0x6769, 0x222F2 },
	{ 0x676A, 0x222F8 },
	{ 0x676B, 0x2243E },
	{ 0x676C, 0x22924 },
	{ 0x676D, 0x2290E },
	{ 0x676E, 0x22916 },
	{ 0x676F, 0x22918 },
	{ 0x6770, 0x22910 },
	{ 0x6771, 0x22931 },
	{ 0x6772, 0x22944 },
	{ 0x6773, 0x39A6 },
	{ 0x6774, 0x22929 },
	{ 0x6775, 0x2292F },
	{ 0x6776, 0x2294B },
	{ 0x6777, 0x22936 },
	{ 0x6778, 0x39A3 },
	{ 0x6779, 0x22E34 },
	{ 0x677A, 0x22E00 },
	{ 0x677B, 0x22E2B },
	{ 0x677C, 0x23020 },
	{ 0x677D, 0x23021 },
	{ 0x677E, 0x2301E },
	{ 0x6821, 0x2301D },
	{ 0x6822, 0x232F5 },
	{ 0x6823, 0x232F2 },
	{ 0x6824, 0x232F6 },
	{ 0x6825, 0x23790 },
	{ 0x6826, 0x2379D },
	{ 0x6827, 0x2379C },
	{ 0x6828, 0x23792 },
	{ 0x6829, 0x23794 },
	{ 0x682A, 0x237D1 },
	{ 0x682B, 0x23793 },
	{ 0x682C, 0x237B7 },
	{ 0x682D, 0x23797 },
	{ 0x682E, 0x237B0 },
	{ 0x682F, 0x2379F },
	{ 0x6830, 0x237C9 },
	{ 0x6831, 0x2392D },
	{ 0x6832, 0x2392C },
	{ 0x6833, 0x23A77 },
	{ 0x6834, 0x23C2C },
	{ 0x6835, 0x240C0 },
	{ 0x6836, 0x240B9 },
	{ 0x6837, 0x24453 },
	{ 0x6838, 0x24540 },
	{ 0x6839, 0x24702 },
	{ 0x683A, 0x246FB },
	{ 0x683B, 0x3EA1 },
	{ 0x683C, 0x24A8B },
	{ 0x683D, 0x24AAE },
	{ 0x683E, 0x24AAB },
	{ 0x683F, 0x24BA1 },
	{ 0x6840, 0x2A2CD },
	{ 0x6841, 0x24CEA },
	{ 0x6842, 0x24EDD },
	{ 0x6843, 0x24EDC },
	{ 0x6844, 0x24ED9 },
	{ 0x6845, 0x24FAB },
	{ 0x6846, 0x24FAC },
	{ 0x6847, 0x24FAD },
	{ 0x6848, 0x24FB2 },
	{ 0x6849, 0x2502C },
	{ 0x684A, 0x2502B },
	{ 0x684B, 0x250C2 },
	{ 0x684C, 0x25300 },
	{ 0x684D, 0x2530D },
	{ 0x684E, 0x25306 },
	{ 0x684F, 0x252FF },
	{ 0x6850, 0x25303 },
	{ 0x6851, 0x25301 },
	{ 0x6852, 0x25310 },
	{ 0x6853, 0x2530F },
	{ 0x6854, 0x25305 },
	{ 0x6855, 0x25398 },
	{ 0x6856, 0x25397 },
	{ 0x6857, 0x25396 },
	{ 0x6858, 0x25399 },
	{ 0x6859, 0x255AC },
	{ 0x685A, 0x255AB },
	{ 0x685B, 0x25712 },
	{ 0x685C, 0x258D8 },
	{ 0x685D, 0x258DF },
	{ 0x685E, 0x258D6 },
	{ 0x685F, 0x25A2D },
	{ 0x6860, 0x25A32 },
	{ 0x6861, 0x25D3F },
	{ 0x6862, 0x25D2F },
	{ 0x6863, 0x25D26 },
	{ 0x6864, 0x25D3A },
	{ 0x6865, 0x25D39 },
	{ 0x6866, 0x425F },
	{ 0x6867, 0x25D3B },
	{ 0x6868, 0x25D35 },
	{ 0x6869, 0x25D2A },
	{ 0x686A, 0x25D21 },
	{ 0x686B, 0x25D38 },
	{ 0x686C, 0x25D37 },
	{ 0x686D, 0x25D34 },
	{ 0x686E, 0x425C },
	{ 0x686F, 0x25D22 },
	{ 0x6870, 0x25D36 },
	{ 0x6871, 0x25D44 },
	{ 0x6872, 0x25F45 },
	{ 0x6873, 0x25F3B },
	{ 0x6874, 0x25F36 },
	{ 0x6875, 0x25F42 },
	{ 0x6876, 0x2617A },
	{ 0x6877, 0x26186 },
	{ 0x6878, 0x2618B },
	{ 0x6879, 0x2617F },
	{ 0x687A, 0x26181 },
	{ 0x687B, 0x2632A },
	{ 0x687C, 0x263D5 },
	{ 0x687D, 0x2649F },
	{ 0x687E, 0x2649D },
	{ 0x6921, 0x26526 },
	{ 0x6922, 0x265F4 },
	{ 0x6923, 0x265F5 },
	{ 0x6924, 0x26815 },
	{ 0x6925, 0x2688E },
	{ 0x6926, 0x2688F },
	{ 0x6927, 0x26926 },
	{ 0x6928, 0x269A7 },
	{ 0x6929, 0x269AF },
	{ 0x692A, 0x26AAD },
	{ 0x692B, 0x26AAC },
	{ 0x692C, 0x26AAB },
	{ 0x692D, 0x26AAA },
	{ 0x692E, 0x2702F },
	{ 0x692F, 0x27021 },
	{ 0x6930, 0x27023 },
	{ 0x6931, 0x270A3 },
	{ 0x6932, 0x27049 },
	{ 0x6933, 0x2703A },
	{ 0x6934, 0x27048 },
	{ 0x6935, 0x2702D },
	{ 0x6936, 0x27025 },
	{ 0x6937, 0x27029 },
	{ 0x6938, 0x27032 },
	{ 0x6939, 0x27034 },
	{ 0x693A, 0x27024 },
	{ 0x693B, 0x2702C },
	{ 0x693C, 0x2704B },
	{ 0x693D, 0x2703B },
	{ 0x693E, 0x27020 },
	{ 0x693F, 0x27028 },
	{ 0x6940, 0x27498 },
	{ 0x6941, 0x45F5 },
	{ 0x6942, 0x27497 },
	{ 0x6943, 0x8804 },
	{ 0x6944, 0x2749D },
	{ 0x6945, 0x274A8 },
	{ 0x6946, 0x275D5 },
	{ 0x6947, 0x27777 },
	{ 0x6948, 0x27778 },
	{ 0x6949, 0x27772 },
	{ 0x694A, 0x27773 },
	{ 0x694B, 0x27802 },
	{ 0x694C, 0x2793B },
	{ 0x694D, 0x27AFE },
	{ 0x694E, 0x27B0B },
	{ 0x694F, 0x27AFF },
	{ 0x6950, 0x27B07 },
	{ 0x6951, 0x4711 },
	{ 0x6952, 0x470C },
	{ 0x6953, 0x27B30 },
	{ 0x6954, 0x27BCD },
	{ 0x6955, 0x27BCF },
	{ 0x6956, 0x27C10 },
	{ 0x6957, 0x27C0A },
	{ 0x6958, 0x27C83 },
	{ 0x6959, 0x27D15 },
	{ 0x695A, 0x27D0E },
	{ 0x695B, 0x27D0C },
	{ 0x695C, 0x27E02 },
	{ 0x695D, 0x27DFE },
	{ 0x695E, 0x27E05 },
	{ 0x695F, 0x27E15 },
	{ 0x6960, 0x27E08 },
	{ 0x6961, 0x27F7F },
	{ 0x6962, 0x27F77 },
	{ 0x6963, 0x27F7C },
	{ 0x6964, 0x27F82 },
	{ 0x6965, 0x27F7E },
	{ 0x6966, 0x27F78 },
	{ 0x6967, 0x27F7D },
	{ 0x6968, 0x27F79 },
	{ 0x6969, 0x27F81 },
	{ 0x696A, 0x2814B },
	{ 0x696B, 0x28163 },
	{ 0x696C, 0x28164 },
	{ 0x696D, 0x28156 },
	{ 0x696E, 0x28154 },
	{ 0x696F, 0x2814E },
	{ 0x6970, 0x28110 },
	{ 0x6971, 0x2814F },
	{ 0x6972, 0x28157 },
	{ 0x6973, 0x2815E },
	{ 0x6974, 0x28151 },
	{ 0x6975, 0x2816A },
	{ 0x6976, 0x28169 },
	{ 0x6977, 0x283AD },
	{ 0x6978, 0x283A4 },
	{ 0x6979, 0x283AC },
	{ 0x697A, 0x283A9 },
	{ 0x697B, 0x283AE },
	{ 0x697C, 0x2044C },
	{ 0x697D, 0x28650 },
	{ 0x697E, 0x28635 },
	{ 0x6A21, 0x28632 },
	{ 0x6A22, 0x287D8 },
	{ 0x6A23, 0x287D1 },
	{ 0x6A24, 0x287CF },
	{ 0x6A25, 0x287BE },
	{ 0x6A26, 0x288D5 },
	{ 0x6A27, 0x288C1 },
	{ 0x6A28, 0x288C6 },
	{ 0x6A29, 0x288C3 },
	{ 0x6A2A, 0x288C2 },
	{ 0x6A2B, 0x288C0 },
	{ 0x6A2C, 0x288C5 },
	{ 0x6A2D, 0x288C7 },
	{ 0x6A2E, 0x288BF },
	{ 0x6A2F, 0x288C4 },
	{ 0x6A30, 0x288D4 },
	{ 0x6A31, 0x28A90 },
	{ 0x6A32, 0x28AD2 },
	{ 0x6A33, 0x494E },
	{ 0x6A34, 0x28AD4 },
	{ 0x6A35, 0x28CAF },
	{ 0x6A36, 0x28CAE },
	{ 0x6A37, 0x28CB2 },
	{ 0x6A38, 0x28CAD },
	{ 0x6A39, 0x28D9C },
	{ 0x6A3A, 0x28DA0 },
	{ 0x6A3B, 0x28DB6 },
	{ 0x6A3C, 0x28F3D },
	{ 0x6A3D, 0x28F56 },
	{ 0x6A3E, 0x28F82 },
	{ 0x6A3F, 0x29028 },
	{ 0x6A40, 0x2902B },
	{ 0x6A41, 0x2913C },
	{ 0x6A42, 0x2913E },
	{ 0x6A43, 0x2913F },
	{ 0x6A44, 0x29142 },
	{ 0x6A45, 0x2913D },
	{ 0x6A46, 0x29141 },
	{ 0x6A47, 0x2913B },
	{ 0x6A48, 0x29149 },
	{ 0x6A49, 0x29143 },
	{ 0x6A4A, 0x29239 },
	{ 0x6A4B, 0x29238 },
	{ 0x6A4C, 0x29322 },
	{ 0x6A4D, 0x29308 },
	{ 0x6A4E, 0x2930C },
	{ 0x6A4F, 0x29306 },
	{ 0x6A50, 0x29313 },
	{ 0x6A51, 0x29304 },
	{ 0x6A52, 0x29320 },
	{ 0x6A53, 0x2931D },
	{ 0x6A54, 0x29305 },
	{ 0x6A55, 0x2930A },
	{ 0x6A56, 0x293D6 },
	{ 0x6A57, 0x293D7 },
	{ 0x6A58, 0x29436 },
	{ 0x6A59, 0x29437 },
	{ 0x6A5A, 0x29523 },
	{ 0x6A5B, 0x29522 },
	{ 0x6A5C, 0x29520 },
	{ 0x6A5D, 0x2951A },
	{ 0x6A5E, 0x2951D },
	{ 0x6A5F, 0x2961C },
	{ 0x6A60, 0x29620 },
	{ 0x6A61, 0x29677 },
	{ 0x6A62, 0x2977F },
	{ 0x6A63, 0x2978B },
	{ 0x6A64, 0x2977D },
	{ 0x6A65, 0x29799 },
	{ 0x6A66, 0x29784 },
	{ 0x6A67, 0x29789 },
	{ 0x6A68, 0x29785 },
	{ 0x6A69, 0x29783 },
	{ 0x6A6A, 0x29786 },
	{ 0x6A6B, 0x2979E },
	{ 0x6A6C, 0x29853 },
	{ 0x6A6D, 0x29917 },
	{ 0x6A6E, 0x4B94 },
	{ 0x6A6F, 0x29919 },
	{ 0x6A70, 0x29920 },
	{ 0x6A71, 0x2991F },
	{ 0x6A72, 0x29923 },
	{ 0x6A73, 0x29918 },
	{ 0x6A74, 0x29921 },
	{ 0x6A75, 0x29929 },
	{ 0x6A76, 0x29924 },
	{ 0x6A77, 0x29926 },
	{ 0x6A78, 0x29A5E },
	{ 0x6A79, 0x29A6F },
	{ 0x6A7A, 0x29A6E },
	{ 0x6A7B, 0x29A74 },
	{ 0x6A7C, 0x29A72 },
	{ 0x6A7D, 0x29A73 },
	{ 0x6A7E, 0x29B7D },
	{ 0x6B21, 0x29B7E },
	{ 0x6B22, 0x29B85 },
	{ 0x6B23, 0x29B7F },
	{ 0x6B24, 0x29B84 },
	{ 0x6B25, 0x29C44 },
	{ 0x6B26, 0x29CF5 },
	{ 0x6B27, 0x29CF8 },
	{ 0x6B28, 0x29D03 },
	{ 0x6B29, 0x29CF6 },
	{ 0x6B2A, 0x29E28 },
	{ 0x6B2B, 0x4C63 },
	{ 0x6B2C, 0x29E39 },
	{ 0x6B2D, 0x29DFB },
	{ 0x6B2E, 0x29E0E },
	{ 0x6B2F, 0x29DFD },
	{ 0x6B30, 0x29E1F },
	{ 0x6B31, 0x4C61 },
	{ 0x6B32, 0x29E03 },
	{ 0x6B33, 0x9BD8 },
	{ 0x6B34, 0x29E10 },
	{ 0x6B35, 0x4C5A },
	{ 0x6B36, 0x29E0D },
	{ 0x6B37, 0x29E27 },
	{ 0x6B38, 0x29E41 },
	{ 0x6B39, 0x2A072 },
	{ 0x6B3A, 0x2A078 },
	{ 0x6B3B, 0x2A080 },
	{ 0x6B3C, 0x4CE3 },
	{ 0x6B3D, 0x2A085 },
	{ 0x6B3E, 0x2A07B },
	{ 0x6B3F, 0x9D7C },
	{ 0x6B40, 0x2A07D },
	{ 0x6B41, 0x2A091 },
	{ 0x6B42, 0x2A088 },
	{ 0x6B43, 0x2A0AA },
	{ 0x6B44, 0x2A08D },
	{ 0x6B45, 0x2A089 },
	{ 0x6B46, 0x2A095 },
	{ 0x6B47, 0x2A09B },
	{ 0x6B48, 0x2A08C },
	{ 0x6B49, 0x2A09E },
	{ 0x6B4A, 0x2A07C },
	{ 0x6B4B, 0x2A086 },
	{ 0x6B4C, 0x2A084 },
	{ 0x6B4D, 0x2A268 },
	{ 0x6B4E, 0x2A2C5 },
	{ 0x6B4F, 0x2A2C4 },
	{ 0x6B50, 0x2A2C9 },
	{ 0x6B51, 0x2A2C6 },
	{ 0x6B52, 0x2A342 },
	{ 0x6B53, 0x2A345 },
	{ 0x6B54, 0x2A341 },
	{ 0x6B55, 0x2A344 },
	{ 0x6B56, 0x2A3A6 },
	{ 0x6B57, 0x2A3C2 },
	{ 0x6B58, 0x2A442 },
	{ 0x6B59, 0x2A449 },
	{ 0x6B5A, 0x2A448 },
	{ 0x6B5B, 0x2A44A },
	{ 0x6B5C, 0x2A44C },
	{ 0x6B5D, 0x2A44B },
	{ 0x6B5E, 0x2A517 },
	{ 0x6B5F, 0x2A518 },
	{ 0x6B60, 0x2A515 },
	{ 0x6B61, 0x2A552 },
	{ 0x6B62, 0x2A554 },
	{ 0x6B63, 0x2A553 },
	{ 0x6B64, 0x2A59A },
	{ 0x6B65, 0x2A59B },
	{ 0x6B66, 0x2A5DC },
	{ 0x6B67, 0x2A5E4 },
	{ 0x6B68, 0x2A691 },
	{ 0x6B69, 0x4DAF },
	{ 0x6B6A, 0x2A6BA },
	{ 0x6B6B, 0x20451 },
	{ 0x6B6C, 0x2045B },
	{ 0x6B6D, 0x204CF },
	{ 0x6B6E, 0x23305 },
	{ 0x6B6F, 0x21113 },
	{ 0x6B70, 0x21115 },
	{ 0x6B71, 0x21114 },
	{ 0x6B72, 0x21123 },
	{ 0x6B73, 0x3613 },
	{ 0x6B74, 0x21111 },
	{ 0x6B75, 0x21112 },
	{ 0x6B76, 0x3680 },
	{ 0x6B77, 0x214F0 },
	{ 0x6B78, 0x2169B },
	{ 0x6B79, 0x21912 },
	{ 0x6B7A, 0x21916 },
	{ 0x6B7B, 0x21917 },
	{ 0x6B7C, 0x219B5 },
	{ 0x6B7D, 0x21CF4 },
	{ 0x6B7E, 0x21FB1 },
	{ 0x6C21, 0x22179 },
	{ 0x6C22, 0x222FF },
	{ 0x6C23, 0x222FC },
	{ 0x6C24, 0x222FB },
	{ 0x6C25, 0x2243F },
	{ 0x6C26, 0x22444 },
	{ 0x6C27, 0x2259D },
	{ 0x6C28, 0x22932 },
	{ 0x6C29, 0x2294C },
	{ 0x6C2A, 0x2292B },
	{ 0x6C2B, 0x2295A },
	{ 0x6C2C, 0x22A1F },
	{ 0x6C2D, 0x22E01 },
	{ 0x6C2E, 0x22E2D },
	{ 0x6C2F, 0x22E27 },
	{ 0x6C30, 0x22E59 },
	{ 0x6C31, 0x22E5A },
	{ 0x6C32, 0x22E4D },
	{ 0x6C33, 0x22E58 },
	{ 0x6C34, 0x23023 },
	{ 0x6C35, 0x23025 },
	{ 0x6C36, 0x2302B },
	{ 0x6C37, 0x232FF },
	{ 0x6C38, 0x233AE },
	{ 0x6C39, 0x237CB },
	{ 0x6C3A, 0x237CA },
	{ 0x6C3B, 0x237D0 },
	{ 0x6C3C, 0x237CE },
	{ 0x6C3D, 0x237CC },
	{ 0x6C3E, 0x237D8 },
	{ 0x6C3F, 0x237C6 },
	{ 0x6C40, 0x237D2 },
	{ 0x6C41, 0x237CF },
	{ 0x6C42, 0x237C8 },
	{ 0x6C43, 0x23B17 },
	{ 0x6C44, 0x4DB0 },
	{ 0x6C45, 0x240C4 },
	{ 0x6C46, 0x29240 },
	{ 0x6C47, 0x240E9 },
	{ 0x6C48, 0x240F2 },
	{ 0x6C49, 0x240FC },
	{ 0x6C4A, 0x240EA },
	{ 0x6C4B, 0x240EB },
	{ 0x6C4C, 0x240FD },
	{ 0x6C4D, 0x24478 },
	{ 0x6C4E, 0x24477 },
	{ 0x6C4F, 0x24473 },
	{ 0x6C50, 0x2449E },
	{ 0x6C51, 0x24479 },
	{ 0x6C52, 0x245A2 },
	{ 0x6C53, 0x24603 },
	{ 0x6C54, 0x24704 },
	{ 0x6C55, 0x24705 },
	{ 0x6C56, 0x248CE },
	{ 0x6C57, 0x24ABF },
	{ 0x6C58, 0x24EF6 },
	{ 0x6C59, 0x24EF7 },
	{ 0x6C5A, 0x25031 },
	{ 0x6C5B, 0x25030 },
	{ 0x6C5C, 0x250C9 },
	{ 0x6C5D, 0x250C7 },
	{ 0x6C5E, 0x2531C },
	{ 0x6C5F, 0x25328 },
	{ 0x6C60, 0x2531A },
	{ 0x6C61, 0x2531E },
	{ 0x6C62, 0x2531B },
	{ 0x6C63, 0x2531F },
	{ 0x6C64, 0x255BF },
	{ 0x6C65, 0x255BB },
	{ 0x6C66, 0x255BC },
	{ 0x6C67, 0x255C0 },
	{ 0x6C68, 0x2571A },
	{ 0x6C69, 0x258EF },
	{ 0x6C6A, 0x258EC },
	{ 0x6C6B, 0x258E9 },
	{ 0x6C6C, 0x258F0 },
	{ 0x6C6D, 0x258FE },
	{ 0x6C6E, 0x25A34 },
	{ 0x6C6F, 0x25D6A },
	{ 0x6C70, 0x25D95 },
	{ 0x6C71, 0x25D6C },
	{ 0x6C72, 0x25D72 },
	{ 0x6C73, 0x25D67 },
	{ 0x6C74, 0x25D60 },
	{ 0x6C75, 0x25D6B },
	{ 0x6C76, 0x25D5E },
	{ 0x6C77, 0x25D6F },
	{ 0x6C78, 0x25D66 },
	{ 0x6C79, 0x7C46 },
	{ 0x6C7A, 0x25D62 },
	{ 0x6C7B, 0x25D5D },
	{ 0x6C7C, 0x25D5C },
	{ 0x6C7D, 0x2F965 },
	{ 0x6C7E, 0x25F50 },
	{ 0x6D21, 0x2619F },
	{ 0x6D22, 0x4323 },
	{ 0x6D23, 0x2619E },
	{ 0x6D24, 0x261A6 },
	{ 0x6D25, 0x26335 },
	{ 0x6D26, 0x26338 },
	{ 0x6D27, 0x26336 },
	{ 0x6D28, 0x2633A },
	{ 0x6D29, 0x263DC },
	{ 0x6D2A, 0x2687C },
	{ 0x6D2B, 0x268AB },
	{ 0x6D2C, 0x4449 },
	{ 0x6D2D, 0x268A8 },
	{ 0x6D2E, 0x268A7 },
	{ 0x6D2F, 0x2692B },
	{ 0x6D30, 0x2692C },
	{ 0x6D31, 0x26928 },
	{ 0x6D32, 0x2092B },
	{ 0x6D33, 0x269A9 },
	{ 0x6D34, 0x269AA },
	{ 0x6D35, 0x269AB },
	{ 0x6D36, 0x269F8 },
	{ 0x6D37, 0x26AB1 },
	{ 0x6D38, 0x26AF0 },
	{ 0x6D39, 0x26AEF },
	{ 0x6D3A, 0x270A8 },
	{ 0x6D3B, 0x2708B },
	{ 0x6D3C, 0x27094 },
	{ 0x6D3D, 0x2709E },
	{ 0x6D3E, 0x2708F },
	{ 0x6D3F, 0x27088 },
	{ 0x6D40, 0x2707E },
	{ 0x6D41, 0x27081 },
	{ 0x6D42, 0x27030 },
	{ 0x6D43, 0x2709B },
	{ 0x6D44, 0x27082 },
	{ 0x6D45, 0x27090 },
	{ 0x6D46, 0x27085 },
	{ 0x6D47, 0x2707F },
	{ 0x6D48, 0x270A9 },
	{ 0x6D49, 0x270DE },
	{ 0x6D4A, 0x2720D },
	{ 0x6D4B, 0x45FA },
	{ 0x6D4C, 0x274CF },
	{ 0x6D4D, 0x274CB },
	{ 0x6D4E, 0x274D8 },
	{ 0x6D4F, 0x274DD },
	{ 0x6D50, 0x274D3 },
	{ 0x6D51, 0x274D0 },
	{ 0x6D52, 0x274D5 },
	{ 0x6D53, 0x274D6 },
	{ 0x6D54, 0x275D6 },
	{ 0x6D55, 0x27792 },
	{ 0x6D56, 0x27795 },
	{ 0x6D57, 0x2A5CB },
	{ 0x6D58, 0x2778D },
	{ 0x6D59, 0x2779B },
	{ 0x6D5A, 0x2779D },
	{ 0x6D5B, 0x2778F },
	{ 0x6D5C, 0x2779E },
	{ 0x6D5D, 0x277A6 },
	{ 0x6D5E, 0x27896 },
	{ 0x6D5F, 0x27892 },
	{ 0x6D60, 0x27B16 },
	{ 0x6D61, 0x27B2A },
	{ 0x6D62, 0x27B29 },
	{ 0x6D63, 0x27B2C },
	{ 0x6D64, 0x27C15 },
	{ 0x6D65, 0x27C12 },
	{ 0x6D66, 0x27C11 },
	{ 0x6D67, 0x27C13 },
	{ 0x6D68, 0x27C88 },
	{ 0x6D69, 0x27C8B },
	{ 0x6D6A, 0x27C8A },
	{ 0x6D6B, 0x27C87 },
	{ 0x6D6C, 0x27D17 },
	{ 0x6D6D, 0x27D16 },
	{ 0x6D6E, 0x27D1A },
	{ 0x6D6F, 0x27E19 },
	{ 0x6D70, 0x27E17 },
	{ 0x6D71, 0x27F91 },
	{ 0x6D72, 0x27F94 },
	{ 0x6D73, 0x2818B },
	{ 0x6D74, 0x28190 },
	{ 0x6D75, 0x2818F },
	{ 0x6D76, 0x28186 },
	{ 0x6D77, 0x28183 },
	{ 0x6D78, 0x2818E },
	{ 0x6D79, 0x28187 },
	{ 0x6D7A, 0x281A8 },
	{ 0x6D7B, 0x28185 },
	{ 0x6D7C, 0x281A6 },
	{ 0x6D7D, 0x28182 },
	{ 0x6D7E, 0x281A7 },
	{ 0x6E21, 0x283B9 },
	{ 0x6E22, 0x283B7 },
	{ 0x6E23, 0x283B4 },
	{ 0x6E24, 0x283B6 },
	{ 0x6E25, 0x283B3 },
	{ 0x6E26, 0x283C6 },
	{ 0x6E27, 0x2863C },
	{ 0x6E28, 0x28640 },
	{ 0x6E29, 0x28638 },
	{ 0x6E2A, 0x28791 },
	{ 0x6E2B, 0x287A6 },
	{ 0x6E2C, 0x287DA },
	{ 0x6E2D, 0x288DA },
	{ 0x6E2E, 0x288D8 },
	{ 0x6E2F, 0x288D9 },
	{ 0x6E30, 0x288DB },
	{ 0x6E31, 0x288D7 },
	{ 0x6E32, 0x28B16 },
	{ 0x6E33, 0x28B12 },
	{ 0x6E34, 0x28B1F },
	{ 0x6E35, 0x4959 },
	{ 0x6E36, 0x28B14 },
	{ 0x6E37, 0x28B1A },
	{ 0x6E38, 0x28B10 },
	{ 0x6E39, 0x28CB3 },
	{ 0x6E3A, 0x28DAE },
	{ 0x6E3B, 0x28DC1 },
	{ 0x6E3C, 0x28DB0 },
	{ 0x6E3D, 0x28DAF },
	{ 0x6E3E, 0x28DB1 },
	{ 0x6E3F, 0x28DAD },
	{ 0x6E40, 0x28DB2 },
	{ 0x6E41, 0x28DC4 },
	{ 0x6E42, 0x2903C },
	{ 0x6E43, 0x2903F },
	{ 0x6E44, 0x29161 },
	{ 0x6E45, 0x29166 },
	{ 0x6E46, 0x2923C },
	{ 0x6E47, 0x2923B },
	{ 0x6E48, 0x2932C },
	{ 0x6E49, 0x4A7E },
	{ 0x6E4A, 0x2932A },
	{ 0x6E4B, 0x2933E },
	{ 0x6E4C, 0x2932F },
	{ 0x6E4D, 0x29332 },
	{ 0x6E4E, 0x29327 },
	{ 0x6E4F, 0x29329 },
	{ 0x6E50, 0x29340 },
	{ 0x6E51, 0x293DF },
	{ 0x6E52, 0x293DE },
	{ 0x6E53, 0x2943C },
	{ 0x6E54, 0x2943B },
	{ 0x6E55, 0x2943E },
	{ 0x6E56, 0x29521 },
	{ 0x6E57, 0x29546 },
	{ 0x6E58, 0x2953C },
	{ 0x6E59, 0x29536 },
	{ 0x6E5A, 0x29538 },
	{ 0x6E5B, 0x29535 },
	{ 0x6E5C, 0x29631 },
	{ 0x6E5D, 0x29636 },
	{ 0x6E5E, 0x2962D },
	{ 0x6E5F, 0x29633 },
	{ 0x6E60, 0x2962F },
	{ 0x6E61, 0x2962E },
	{ 0x6E62, 0x29635 },
	{ 0x6E63, 0x297AC },
	{ 0x6E64, 0x297A9 },
	{ 0x6E65, 0x297A6 },
	{ 0x6E66, 0x4BA8 },
	{ 0x6E67, 0x2994C },
	{ 0x6E68, 0x29943 },
	{ 0x6E69, 0x29941 },
	{ 0x6E6A, 0x2994F },
	{ 0x6E6B, 0x29942 },
	{ 0x6E6C, 0x29951 },
	{ 0x6E6D, 0x4BA9 },
	{ 0x6E6E, 0x29940 },
	{ 0x6E6F, 0x29950 },
	{ 0x6E70, 0x29945 },
	{ 0x6E71, 0x2994A },
	{ 0x6E72, 0x2994B },
	{ 0x6E73, 0x29A83 },
	{ 0x6E74, 0x29A82 },
	{ 0x6E75, 0x29A81 },
	{ 0x6E76, 0x29AE0 },
	{ 0x6E77, 0x29B98 },
	{ 0x6E78, 0x29B9F },
	{ 0x6E79, 0x29B9B },
	{ 0x6E7A, 0x29B9A },
	{ 0x6E7B, 0x29B99 },
	{ 0x6E7C, 0x29B96 },
	{ 0x6E7D, 0x29BAE },
	{ 0x6E7E, 0x29B9E },
	{ 0x6F21, 0x29D09 },
	{ 0x6F22, 0x29D0D },
	{ 0x6F23, 0x29E4E },
	{ 0x6F24, 0x29E4A },
	{ 0x6F25, 0x29E4D },
	{ 0x6F26, 0x29E40 },
	{ 0x6F27, 0x29E3E },
	{ 0x6F28, 0x29E48 },
	{ 0x6F29, 0x29E42 },
	{ 0x6F2A, 0x29E62 },
	{ 0x6F2B, 0x29E45 },
	{ 0x6F2C, 0x29E51 },
	{ 0x6F2D, 0x2A0C6 },
	{ 0x6F2E, 0x2A0D0 },
	{ 0x6F2F, 0x2A0C0 },
	{ 0x6F30, 0x2A0B7 },
	{ 0x6F31, 0x2A0C2 },
	{ 0x6F32, 0x2A0BC },
	{ 0x6F33, 0x2A0C5 },
	{ 0x6F34, 0x2A0DC },
	{ 0x6F35, 0x2A0DB },
	{ 0x6F36, 0x2A0D2 },
	{ 0x6F37, 0x2A0C7 },
	{ 0x6F38, 0x2A0B6 },
	{ 0x6F39, 0x2A0C9 },
	{ 0x6F3A, 0x2A0CC },
	{ 0x6F3B, 0x2A0D1 },
	{ 0x6F3C, 0x2A0CD },
	{ 0x6F3D, 0x2A0DA },
	{ 0x6F3E, 0x2A0BA },
	{ 0x6F3F, 0x2A0D3 },
	{ 0x6F40, 0x2A0CE },
	{ 0x6F41, 0x2A0F6 },
	{ 0x6F42, 0x2A0BD },
	{ 0x6F43, 0x2A0DD },
	{ 0x6F44, 0x2A0C8 },
	{ 0x6F45, 0x2A10D },
	{ 0x6F46, 0x2A135 },
	{ 0x6F47, 0x2A271 },
	{ 0x6F48, 0x2A26E },
	{ 0x6F49, 0x2A26F },
	{ 0x6F4A, 0x2A2D6 },
	{ 0x6F4B, 0x2A34C },
	{ 0x6F4C, 0x2A34F },
	{ 0x6F4D, 0x2A354 },
	{ 0x6F4E, 0x2A353 },
	{ 0x6F4F, 0x2A3C9 },
	{ 0x6F50, 0x2A3C8 },
	{ 0x6F51, 0x2A403 },
	{ 0x6F52, 0x4D54 },
	{ 0x6F53, 0x2A404 },
	{ 0x6F54, 0x4D56 },
	{ 0x6F55, 0x2A457 },
	{ 0x6F56, 0x2A452 },
	{ 0x6F57, 0x2A453 },
	{ 0x6F58, 0x4D6D },
	{ 0x6F59, 0x2A456 },
	{ 0x6F5A, 0x2A45C },
	{ 0x6F5B, 0x2A455 },
	{ 0x6F5C, 0x2A564 },
	{ 0x6F5D, 0x2A55D },
	{ 0x6F5E, 0x2A55E },
	{ 0x6F5F, 0x2A5A2 },
	{ 0x6F60, 0x2A5A3 },
	{ 0x6F61, 0x4D8E },
	{ 0x6F62, 0x2A5E7 },
	{ 0x6F63, 0x2A5E6 },
	{ 0x6F64, 0x2A698 },
	{ 0x6F65, 0x2A6AC },
	{ 0x6F66, 0x2A6AF },
	{ 0x6F67, 0x2A6AE },
	{ 0x6F68, 0x20459 },
	{ 0x6F69, 0x205A9 },
	{ 0x6F6A, 0x2082A },
	{ 0x6F6B, 0x208C7 },
	{ 0x6F6C, 0x21141 },
	{ 0x6F6D, 0x21137 },
	{ 0x6F6E, 0x21135 },
	{ 0x6F6F, 0x21133 },
	{ 0x6F70, 0x21139 },
	{ 0x6F71, 0x21132 },
	{ 0x6F72, 0x214FF },
	{ 0x6F73, 0x21501 },
	{ 0x6F74, 0x214F8 },
	{ 0x6F75, 0x2191B },
	{ 0x6F76, 0x21919 },
	{ 0x6F77, 0x21BBF },
	{ 0x6F78, 0x21FBC },
	{ 0x6F79, 0x21FBE },
	{ 0x6F7A, 0x21FBD },
	{ 0x6F7B, 0x2217D },
	{ 0x6F7C, 0x22446 },
	{ 0x6F7D, 0x22447 },
	{ 0x6F7E, 0x225A4 },
	{ 0x7021, 0x22A21 },
	{ 0x7022, 0x22A62 },
	{ 0x7023, 0x22E86 },
	{ 0x7024, 0x3A72 },
	{ 0x7025, 0x2302F },
	{ 0x7026, 0x23031 },
	{ 0x7027, 0x3C14 },
	{ 0x7028, 0x237F8 },
	{ 0x7029, 0x237F5 },
	{ 0x702A, 0x237F9 },
	{ 0x702B, 0x237F2 },
	{ 0x702C, 0x237FA },
	{ 0x702D, 0x237F3 },
	{ 0x702E, 0x23814 },
	{ 0x702F, 0x237FD },
	{ 0x7030, 0x2380F },
	{ 0x7031, 0x2380E },
	{ 0x7032, 0x23801 },
	{ 0x7033, 0x23937 },
	{ 0x7034, 0x23935 },
	{ 0x7035, 0x23934 },
	{ 0x7036, 0x23931 },
	{ 0x7037, 0x23A7A },
	{ 0x7038, 0x23A7B },
	{ 0x7039, 0x23C37 },
	{ 0x703A, 0x2412B },
	{ 0x703B, 0x240FB },
	{ 0x703C, 0x24116 },
	{ 0x703D, 0x24113 },
	{ 0x703E, 0x3D93 },
	{ 0x703F, 0x24111 },
	{ 0x7040, 0x2410F },
	{ 0x7041, 0x2411B },
	{ 0x7042, 0x24138 },
	{ 0x7043, 0x244A4 },
	{ 0x7044, 0x24709 },
	{ 0x7045, 0x24707 },
	{ 0x7046, 0x2470B },
	{ 0x7047, 0x248D3 },
	{ 0x7048, 0x248D1 },
	{ 0x7049, 0x248D8 },
	{ 0x704A, 0x24B1D },
	{ 0x704B, 0x24BA9 },
	{ 0x704C, 0x24BD0 },
	{ 0x704D, 0x27215 },
	{ 0x704E, 0x24F02 },
	{ 0x704F, 0x24F05 },
	{ 0x7050, 0x24F01 },
	{ 0x7051, 0x24F00 },
	{ 0x7052, 0x2532E },
	{ 0x7053, 0x25330 },
	{ 0x7054, 0x2532F },
	{ 0x7055, 0x25331 },
	{ 0x7056, 0x255D2 },
	{ 0x7057, 0x255D3 },
	{ 0x7058, 0x25902 },
	{ 0x7059, 0x25A40 },
	{ 0x705A, 0x25A42 },
	{ 0x705B, 0x25A3B },
	{ 0x705C, 0x25ACE },
	{ 0x705D, 0x25D98 },
	{ 0x705E, 0x25D8F },
	{ 0x705F, 0x25D94 },
	{ 0x7060, 0x25D91 },
	{ 0x7061, 0x426F },
	{ 0x7062, 0x25DBA },
	{ 0x7063, 0x25D90 },
	{ 0x7064, 0x25D86 },
	{ 0x7065, 0x25D9A },
	{ 0x7066, 0x25D8C },
	{ 0x7067, 0x25D93 },
	{ 0x7068, 0x25D87 },
	{ 0x7069, 0x25D88 },
	{ 0x706A, 0x25D97 },
	{ 0x706B, 0x25D8D },
	{ 0x706C, 0x25D9C },
	{ 0x706D, 0x25DBD },
	{ 0x706E, 0x25F3C },
	{ 0x706F, 0x25F59 },
	{ 0x7070, 0x42B0 },
	{ 0x7071, 0x261D1 },
	{ 0x7072, 0x261BB },
	{ 0x7073, 0x261BE },
	{ 0x7074, 0x2625D },
	{ 0x7075, 0x263E2 },
	{ 0x7076, 0x26605 },
	{ 0x7077, 0x268BA },
	{ 0x7078, 0x352E },
	{ 0x7079, 0x268F4 },
	{ 0x707A, 0x269B2 },
	{ 0x707B, 0x269F9 },
	{ 0x707C, 0x26AB7 },
	{ 0x707D, 0x26AB6 },
	{ 0x707E, 0x27089 },
	{ 0x7121, 0x270F9 },
	{ 0x7122, 0x270D9 },
	{ 0x7123, 0x270E8 },
	{ 0x7124, 0x270D4 },
	{ 0x7125, 0x270DB },
	{ 0x7126, 0x270E2 },
	{ 0x7127, 0x270DF },
	{ 0x7128, 0x270D1 },
	{ 0x7129, 0x270E9 },
	{ 0x712A, 0x270EA },
	{ 0x712B, 0x27213 },
	{ 0x712C, 0x27211 },
	{ 0x712D, 0x274FA },
	{ 0x712E, 0x274F8 },
	{ 0x712F, 0x274F4 },
	{ 0x7130, 0x274FB },
	{ 0x7131, 0x2750E },
	{ 0x7132, 0x27502 },
	{ 0x7133, 0x2750F },
	{ 0x7134, 0x27790 },
	{ 0x7135, 0x277AD },
	{ 0x7136, 0x277A9 },
	{ 0x7137, 0x27948 },
	{ 0x7138, 0x27B5A },
	{ 0x7139, 0x27B4F },
	{ 0x713A, 0x27B4E },
	{ 0x713B, 0x27B55 },
	{ 0x713C, 0x27B54 },
	{ 0x713D, 0x27B4A },
	{ 0x713E, 0x27BD5 },
	{ 0x713F, 0x27C18 },
	{ 0x7140, 0x27C8D },
	{ 0x7141, 0x27D1D },
	{ 0x7142, 0x27D19 },
	{ 0x7143, 0x27E26 },
	{ 0x7144, 0x27E28 },
	{ 0x7145, 0x27E2B },
	{ 0x7146, 0x27E7D },
	{ 0x7147, 0x27FA0 },
	{ 0x7148, 0x27F9A },
	{ 0x7149, 0x27F9B },
	{ 0x714A, 0x281B5 },
	{ 0x714B, 0x281AD },
	{ 0x714C, 0x281B2 },
	{ 0x714D, 0x28294 },
	{ 0x714E, 0x283C9 },
	{ 0x714F, 0x2864E },
	{ 0x7150, 0x2864F },
	{ 0x7151, 0x28644 },
	{ 0x7152, 0x28652 },
	{ 0x7153, 0x288E9 },
	{ 0x7154, 0x28939 },
	{ 0x7155, 0x4969 },
	{ 0x7156, 0x957E },
	{ 0x7157, 0x28DC7 },
	{ 0x7158, 0x28DD3 },
	{ 0x7159, 0x28DC6 },
	{ 0x715A, 0x28DC3 },
	{ 0x715B, 0x49B4 },
	{ 0x715C, 0x28DD2 },
	{ 0x715D, 0x28F66 },
	{ 0x715E, 0x2917F },
	{ 0x715F, 0x29180 },
	{ 0x7160, 0x29184 },
	{ 0x7161, 0x29185 },
	{ 0x7162, 0x291E3 },
	{ 0x7163, 0x4A4D },
	{ 0x7164, 0x29241 },
	{ 0x7165, 0x29244 },
	{ 0x7166, 0x29243 },
	{ 0x7167, 0x2934E },
	{ 0x7168, 0x2934F },
	{ 0x7169, 0x4A83 },
	{ 0x716A, 0x29349 },
	{ 0x716B, 0x2934A },
	{ 0x716C, 0x2934B },
	{ 0x716D, 0x29343 },
	{ 0x716E, 0x293E0 },
	{ 0x716F, 0x293E5 },
	{ 0x7170, 0x293E1 },
	{ 0x7171, 0x293E6 },
	{ 0x7172, 0x293E2 },
	{ 0x7173, 0x2940C },
	{ 0x7174, 0x29440 },
	{ 0x7175, 0x29549 },
	{ 0x7176, 0x2954A },
	{ 0x7177, 0x29554 },
	{ 0x7178, 0x2954C },
	{ 0x7179, 0x29555 },
	{ 0x717A, 0x29556 },
	{ 0x717B, 0x2963B },
	{ 0x717C, 0x2963D },
	{ 0x717D, 0x297A4 },
	{ 0x717E, 0x297A8 },
	{ 0x7221, 0x297C3 },
	{ 0x7222, 0x297BF },
	{ 0x7223, 0x297C8 },
	{ 0x7224, 0x297C2 },
	{ 0x7225, 0x297CA },
	{ 0x7226, 0x297CC },
	{ 0x7227, 0x297C9 },
	{ 0x7228, 0x297BE },
	{ 0x7229, 0x297CD },
	{ 0x722A, 0x297C7 },
	{ 0x722B, 0x297C5 },
	{ 0x722C, 0x2985D },
	{ 0x722D, 0x4BB0 },
	{ 0x722E, 0x2996C },
	{ 0x722F, 0x2996B },
	{ 0x7230, 0x29970 },
	{ 0x7231, 0x2996D },
	{ 0x7232, 0x2996F },
	{ 0x7233, 0x29989 },
	{ 0x7234, 0x29984 },
	{ 0x7235, 0x29A8D },
	{ 0x7236, 0x29A8A },
	{ 0x7237, 0x29A8E },
	{ 0x7238, 0x29A91 },
	{ 0x7239, 0x29BB5 },
	{ 0x723A, 0x29BB1 },
	{ 0x723B, 0x29BAF },
	{ 0x723C, 0x29BB9 },
	{ 0x723D, 0x29BB7 },
	{ 0x723E, 0x29BB0 },
	{ 0x723F, 0x4C0C },
	{ 0x7240, 0x29C17 },
	{ 0x7241, 0x4C18 },
	{ 0x7242, 0x29C4F },
	{ 0x7243, 0x29D19 },
	{ 0x7244, 0x29D10 },
	{ 0x7245, 0x29D18 },
	{ 0x7246, 0x29D11 },
	{ 0x7247, 0x29D1C },
	{ 0x7248, 0x29D12 },
	{ 0x7249, 0x29E76 },
	{ 0x724A, 0x29E71 },
	{ 0x724B, 0x9C20 },
	{ 0x724C, 0x29E7A },
	{ 0x724D, 0x29E7F },
	{ 0x724E, 0x9C22 },
	{ 0x724F, 0x29E73 },
	{ 0x7250, 0x29EAB },
	{ 0x7251, 0x9C1E },
	{ 0x7252, 0x29E77 },
	{ 0x7253, 0x29E74 },
	{ 0x7254, 0x29E7E },
	{ 0x7255, 0x29E9B },
	{ 0x7256, 0x29E84 },
	{ 0x7257, 0x29E7C },
	{ 0x7258, 0x2A129 },
	{ 0x7259, 0x2A12B },
	{ 0x725A, 0x2A10E },
	{ 0x725B, 0x2A100 },
	{ 0x725C, 0x2A10B },
	{ 0x725D, 0x2A0FE },
	{ 0x725E, 0x2A0FA },
	{ 0x725F, 0x2A117 },
	{ 0x7260, 0x2A0FF },
	{ 0x7261, 0x2A10C },
	{ 0x7262, 0x2A10F },
	{ 0x7263, 0x4CF5 },
	{ 0x7264, 0x2A102 },
	{ 0x7265, 0x2A101 },
	{ 0x7266, 0x2A0FC },
	{ 0x7267, 0x2A149 },
	{ 0x7268, 0x2A106 },
	{ 0x7269, 0x2A112 },
	{ 0x726A, 0x2A113 },
	{ 0x726B, 0x2A278 },
	{ 0x726C, 0x2A35B },
	{ 0x726D, 0x2A362 },
	{ 0x726E, 0x2A35F },
	{ 0x726F, 0x2A35D },
	{ 0x7270, 0x2A3AB },
	{ 0x7271, 0x2A3D5 },
	{ 0x7272, 0x2A3D4 },
	{ 0x7273, 0x2A3D3 },
	{ 0x7274, 0x2A407 },
	{ 0x7275, 0x2A46C },
	{ 0x7276, 0x2A470 },
	{ 0x7277, 0x2A46E },
	{ 0x7278, 0x2A468 },
	{ 0x7279, 0x2A46D },
	{ 0x727A, 0x2A477 },
	{ 0x727B, 0x2A46A },
	{ 0x727C, 0x2A4CE },
	{ 0x727D, 0x2A4EC },
	{ 0x727E, 0x2A569 },
	{ 0x7321, 0x2A568 },
	{ 0x7322, 0x2A5A6 },
	{ 0x7323, 0x2A5A9 },
	{ 0x7324, 0x2A5AA },
	{ 0x7325, 0x2A600 },
	{ 0x7326, 0x2A60D },
	{ 0x7327, 0x2A5F8 },
	{ 0x7328, 0x2A5FC },
	{ 0x7329, 0x2A60A },
	{ 0x732A, 0x2A5F7 },
	{ 0x732B, 0x2A601 },
	{ 0x732C, 0x2A6B6 },
	{ 0x732D, 0x2A6BB },
	{ 0x732E, 0x2A6B7 },
	{ 0x732F, 0x2A6B9 },
	{ 0x7330, 0x2A6CA },
	{ 0x7331, 0x20469 },
	{ 0x7332, 0x20625 },
	{ 0x7333, 0x21159 },
	{ 0x7334, 0x21507 },
	{ 0x7335, 0x21509 },
	{ 0x7336, 0x21922 },
	{ 0x7337, 0x21B07 },
	{ 0x7338, 0x21B04 },
	{ 0x7339, 0x2330F },
	{ 0x733A, 0x21CF8 },
	{ 0x733B, 0x21FC7 },
	{ 0x733C, 0x21FD1 },
	{ 0x733D, 0x2217E },
	{ 0x733E, 0x22308 },
	{ 0x733F, 0x2244A },
	{ 0x7340, 0x2F898 },
	{ 0x7341, 0x224B9 },
	{ 0x7342, 0x22E88 },
	{ 0x7343, 0x22E91 },
	{ 0x7344, 0x22E84 },
	{ 0x7345, 0x22E73 },
	{ 0x7346, 0x22E89 },
	{ 0x7347, 0x22E85 },
	{ 0x7348, 0x23033 },
	{ 0x7349, 0x23313 },
	{ 0x734A, 0x2381D },
	{ 0x734B, 0x2381F },
	{ 0x734C, 0x2381C },
	{ 0x734D, 0x23820 },
	{ 0x734E, 0x2381A },
	{ 0x734F, 0x2381B },
	{ 0x7350, 0x23939 },
	{ 0x7351, 0x239AF },
	{ 0x7352, 0x23AE5 },
	{ 0x7353, 0x23C3C },
	{ 0x7354, 0x24137 },
	{ 0x7355, 0x2413A },
	{ 0x7356, 0x244BB },
	{ 0x7357, 0x3E0E },
	{ 0x7358, 0x24710 },
	{ 0x7359, 0x2470D },
	{ 0x735A, 0x24BAF },
	{ 0x735B, 0x24C11 },
	{ 0x735C, 0x3FD8 },
	{ 0x735D, 0x24F0D },
	{ 0x735E, 0x24F0C },
	{ 0x735F, 0x24F0B },
	{ 0x7360, 0x250D4 },
	{ 0x7361, 0x2533D },
	{ 0x7362, 0x2533E },
	{ 0x7363, 0x2533B },
	{ 0x7364, 0x25343 },
	{ 0x7365, 0x25340 },
	{ 0x7366, 0x25346 },
	{ 0x7367, 0x25411 },
	{ 0x7368, 0x255DD },
	{ 0x7369, 0x255DF },
	{ 0x736A, 0x255EA },
	{ 0x736B, 0x2574A },
	{ 0x736C, 0x25906 },
	{ 0x736D, 0x25DC1 },
	{ 0x736E, 0x25DB9 },
	{ 0x736F, 0x25DC6 },
	{ 0x7370, 0x25DB8 },
	{ 0x7371, 0x25DBB },
	{ 0x7372, 0x25DC8 },
	{ 0x7373, 0x25DC5 },
	{ 0x7374, 0x25DBF },
	{ 0x7375, 0x25DC7 },
	{ 0x7376, 0x25DC4 },
	{ 0x7377, 0x25F65 },
	{ 0x7378, 0x25F67 },
	{ 0x7379, 0x261D7 },
	{ 0x737A, 0x261DB },
	{ 0x737B, 0x261D4 },
	{ 0x737C, 0x261D6 },
	{ 0x737D, 0x263E8 },
	{ 0x737E, 0x2660A },
	{ 0x7421, 0x26ABD },
	{ 0x7422, 0x26ABE },
	{ 0x7423, 0x2711A },
	{ 0x7424, 0x2710D },
	{ 0x7425, 0x2710F },
	{ 0x7426, 0x2711B },
	{ 0x7427, 0x27110 },
	{ 0x7428, 0x27111 },
	{ 0x7429, 0x27113 },
	{ 0x742A, 0x27218 },
	{ 0x742B, 0x27520 },
	{ 0x742C, 0x2751F },
	{ 0x742D, 0x27523 },
	{ 0x742E, 0x2751D },
	{ 0x742F, 0x27537 },
	{ 0x7430, 0x27525 },
	{ 0x7431, 0x27524 },
	{ 0x7432, 0x2752A },
	{ 0x7433, 0x27527 },
	{ 0x7434, 0x27533 },
	{ 0x7435, 0x27528 },
	{ 0x7436, 0x27534 },
	{ 0x7437, 0x277BA },
	{ 0x7438, 0x8970 },
	{ 0x7439, 0x2789D },
	{ 0x743A, 0x2794C },
	{ 0x743B, 0x27B5C },
	{ 0x743C, 0x27B6A },
	{ 0x743D, 0x27B5D },
	{ 0x743E, 0x27B65 },
	{ 0x743F, 0x27B63 },
	{ 0x7440, 0x27B5E },
	{ 0x7441, 0x27C19 },
	{ 0x7442, 0x27C97 },
	{ 0x7443, 0x27E3F },
	{ 0x7444, 0x27E33 },
	{ 0x7445, 0x27E32 },
	{ 0x7446, 0x27FA1 },
	{ 0x7447, 0x27FA5 },
	{ 0x7448, 0x27FA4 },
	{ 0x7449, 0x27FA2 },
	{ 0x744A, 0x281C1 },
	{ 0x744B, 0x482C },
	{ 0x744C, 0x281C7 },
	{ 0x744D, 0x281C4 },
	{ 0x744E, 0x281C6 },
	{ 0x744F, 0x281C5 },
	{ 0x7450, 0x281D4 },
	{ 0x7451, 0x281CA },
	{ 0x7452, 0x28653 },
	{ 0x7453, 0x288F1 },
	{ 0x7454, 0x28921 },
	{ 0x7455, 0x496E },
	{ 0x7456, 0x28BB7 },
	{ 0x7457, 0x28B92 },
	{ 0x7458, 0x28DD4 },
	{ 0x7459, 0x28F44 },
	{ 0x745A, 0x29198 },
	{ 0x745B, 0x2919B },
	{ 0x745C, 0x29191 },
	{ 0x745D, 0x29195 },
	{ 0x745E, 0x2919A },
	{ 0x745F, 0x29192 },
	{ 0x7460, 0x29353 },
	{ 0x7461, 0x29357 },
	{ 0x7462, 0x4A86 },
	{ 0x7463, 0x2935C },
	{ 0x7464, 0x2935D },
	{ 0x7465, 0x29364 },
	{ 0x7466, 0x293EA },
	{ 0x7467, 0x293ED },
	{ 0x7468, 0x29442 },
	{ 0x7469, 0x29443 },
	{ 0x746A, 0x29564 },
	{ 0x746B, 0x29561 },
	{ 0x746C, 0x29560 },
	{ 0x746D, 0x2967D },
	{ 0x746E, 0x297D4 },
	{ 0x746F, 0x297D5 },
	{ 0x7470, 0x297D9 },
	{ 0x7471, 0x29987 },
	{ 0x7472, 0x29999 },
	{ 0x7473, 0x2998C },
	{ 0x7474, 0x2998A },
	{ 0x7475, 0x2998F },
	{ 0x7476, 0x4BB3 },
	{ 0x7477, 0x2998B },
	{ 0x7478, 0x29982 },
	{ 0x7479, 0x2999B },
	{ 0x747A, 0x4BEB },
	{ 0x747B, 0x29BC8 },
	{ 0x747C, 0x29BC4 },
	{ 0x747D, 0x29BCC },
	{ 0x747E, 0x29BC7 },
	{ 0x7521, 0x29BC3 },
	{ 0x7522, 0x29BC6 },
	{ 0x7523, 0x29BCB },
	{ 0x7524, 0x29BCA },
	{ 0x7525, 0x29BC9 },
	{ 0x7526, 0x29BCD },
	{ 0x7527, 0x29C53 },
	{ 0x7528, 0x29D21 },
	{ 0x7529, 0x29D29 },
	{ 0x752A, 0x29D1D },
	{ 0x752B, 0x29D24 },
	{ 0x752C, 0x29D28 },
	{ 0x752D, 0x9C43 },
	{ 0x752E, 0x29EB1 },
	{ 0x752F, 0x29EB2 },
	{ 0x7530, 0x29EB5 },
	{ 0x7531, 0x29ED6 },
	{ 0x7532, 0x29EAF },
	{ 0x7533, 0x29ECA },
	{ 0x7534, 0x29EB8 },
	{ 0x7535, 0x2FA12 },
	{ 0x7536, 0x2FA11 },
	{ 0x7537, 0x2A145 },
	{ 0x7538, 0x2A147 },
	{ 0x7539, 0x2A134 },
	{ 0x753A, 0x2A16E },
	{ 0x753B, 0x2A142 },
	{ 0x753C, 0x2A131 },
	{ 0x753D, 0x2A12E },
	{ 0x753E, 0x2A156 },
	{ 0x753F, 0x2A138 },
	{ 0x7540, 0x2A137 },
	{ 0x7541, 0x2A14B },
	{ 0x7542, 0x2A12D },
	{ 0x7543, 0x2A133 },
	{ 0x7544, 0x2A136 },
	{ 0x7545, 0x9DE0 },
	{ 0x7546, 0x2A148 },
	{ 0x7547, 0x2A2DC },
	{ 0x7548, 0x4D42 },
	{ 0x7549, 0x2A366 },
	{ 0x754A, 0x2A36D },
	{ 0x754B, 0x2A363 },
	{ 0x754C, 0x2A364 },
	{ 0x754D, 0x4D41 },
	{ 0x754E, 0x2A367 },
	{ 0x754F, 0x2A3D9 },
	{ 0x7550, 0x2A40B },
	{ 0x7551, 0x2A47E },
	{ 0x7552, 0x2A48B },
	{ 0x7553, 0x2A526 },
	{ 0x7554, 0x2A52C },
	{ 0x7555, 0x2A529 },
	{ 0x7556, 0x2A56F },
	{ 0x7557, 0x2A56B },
	{ 0x7558, 0x2A56D },
	{ 0x7559, 0x2A56E },
	{ 0x755A, 0x2A61C },
	{ 0x755B, 0x2A611 },
	{ 0x755C, 0x2A610 },
	{ 0x755D, 0x2A624 },
	{ 0x755E, 0x2A612 },
	{ 0x755F, 0x2A615 },
	{ 0x7560, 0x2A617 },
	{ 0x7561, 0x4DAC },
	{ 0x7562, 0x2046F },
	{ 0x7563, 0x205AB },
	{ 0x7564, 0x2082E },
	{ 0x7565, 0x208C9 },
	{ 0x7566, 0x20B96 },
	{ 0x7567, 0x21185 },
	{ 0x7568, 0x216A0 },
	{ 0x7569, 0x2192B },
	{ 0x756A, 0x2230D },
	{ 0x756B, 0x23036 },
	{ 0x756D, 0x3B2F },
	{ 0x756E, 0x3B2E },
	{ 0x756F, 0x233B1 },
	{ 0x7570, 0x2384A },
	{ 0x7571, 0x23837 },
	{ 0x7572, 0x2383C },
	{ 0x7573, 0x23838 },
	{ 0x7574, 0x2383A },
	{ 0x7575, 0x2383E },
	{ 0x7576, 0x23849 },
	{ 0x7577, 0x3C4D },
	{ 0x7578, 0x3C7B },
	{ 0x7579, 0x23A80 },
	{ 0x757A, 0x23A7F },
	{ 0x757B, 0x23AE3 },
	{ 0x757C, 0x23C3F },
	{ 0x757D, 0x24152 },
	{ 0x757E, 0x2414E },
	{ 0x7621, 0x2414A },
	{ 0x7622, 0x2414B },
	{ 0x7623, 0x244D5 },
	{ 0x7624, 0x24AD8 },
	{ 0x7625, 0x24B20 },
	{ 0x7626, 0x24BB3 },
	{ 0x7627, 0x24BB1 },
	{ 0x7628, 0x24BB0 },
	{ 0x7629, 0x24F17 },
	{ 0x762A, 0x250D9 },
	{ 0x762B, 0x25349 },
	{ 0x762C, 0x25413 },
	{ 0x762D, 0x255ED },
	{ 0x762E, 0x255EB },
	{ 0x762F, 0x255EE },
	{ 0x7630, 0x2590A },
	{ 0x7631, 0x2590B },
	{ 0x7632, 0x25A4A },
	{ 0x7633, 0x25DD5 },
	{ 0x7634, 0x25DD7 },
	{ 0x7635, 0x25DDE },
	{ 0x7636, 0x25DDC },
	{ 0x7637, 0x25DEE },
	{ 0x7638, 0x25F70 },
	{ 0x7639, 0x42B2 },
	{ 0x763A, 0x261D9 },
	{ 0x763B, 0x263D7 },
	{ 0x763C, 0x268CB },
	{ 0x763D, 0x268C7 },
	{ 0x763E, 0x269FC },
	{ 0x763F, 0x2713B },
	{ 0x7640, 0x27139 },
	{ 0x7641, 0x2714B },
	{ 0x7642, 0x27143 },
	{ 0x7643, 0x27140 },
	{ 0x7644, 0x27146 },
	{ 0x7645, 0x2754D },
	{ 0x7646, 0x27543 },
	{ 0x7647, 0x27547 },
	{ 0x7648, 0x2754B },
	{ 0x7649, 0x27555 },
	{ 0x764A, 0x27552 },
	{ 0x764B, 0x27B5F },
	{ 0x764C, 0x4722 },
	{ 0x764D, 0x27B7C },
	{ 0x764E, 0x27B7B },
	{ 0x764F, 0x27FA8 },
	{ 0x7650, 0x27FA9 },
	{ 0x7651, 0x281DE },
	{ 0x7652, 0x281D7 },
	{ 0x7653, 0x281DD },
	{ 0x7654, 0x281D6 },
	{ 0x7655, 0x281D8 },
	{ 0x7656, 0x2829B },
	{ 0x7657, 0x283E0 },
	{ 0x7658, 0x283E8 },
	{ 0x7659, 0x283E6 },
	{ 0x765A, 0x288F8 },
	{ 0x765B, 0x288FB },
	{ 0x765C, 0x28BBB },
	{ 0x765D, 0x9459 },
	{ 0x765E, 0x28BB8 },
	{ 0x765F, 0x4970 },
	{ 0x7660, 0x28CC1 },
	{ 0x7661, 0x28CC0 },
	{ 0x7662, 0x291A4 },
	{ 0x7663, 0x291AB },
	{ 0x7664, 0x2924D },
	{ 0x7665, 0x29365 },
	{ 0x7666, 0x29367 },
	{ 0x7667, 0x2936A },
	{ 0x7668, 0x29366 },
	{ 0x7669, 0x29369 },
	{ 0x766A, 0x29573 },
	{ 0x766B, 0x29580 },
	{ 0x766C, 0x2956F },
	{ 0x766D, 0x29571 },
	{ 0x766E, 0x297E4 },
	{ 0x766F, 0x297E6 },
	{ 0x7670, 0x297E7 },
	{ 0x7671, 0x299A0 },
	{ 0x7672, 0x299A4 },
	{ 0x7673, 0x29AA2 },
	{ 0x7674, 0x29AA7 },
	{ 0x7675, 0x29AA4 },
	{ 0x7676, 0x29BDE },
	{ 0x7677, 0x29BDB },
	{ 0x7678, 0x29C58 },
	{ 0x7679, 0x29C5C },
	{ 0x767A, 0x29D2F },
	{ 0x767B, 0x29D2E },
	{ 0x767C, 0x29EDD },
	{ 0x767D, 0x29EE4 },
	{ 0x767E, 0x29ED8 },
	{ 0x7721, 0x29EE7 },
	{ 0x7722, 0x29EDA },
	{ 0x7723, 0x29E75 },
	{ 0x7724, 0x4C95 },
	{ 0x7725, 0x2A179 },
	{ 0x7726, 0x2A180 },
	{ 0x7727, 0x2A17F },
	{ 0x7728, 0x2A17C },
	{ 0x7729, 0x2A175 },
	{ 0x772A, 0x2A17B },
	{ 0x772B, 0x2A182 },
	{ 0x772C, 0x4D00 },
	{ 0x772D, 0x2A189 },
	{ 0x772E, 0x2A174 },
	{ 0x772F, 0x2A17D },
	{ 0x7730, 0x2A17A },
	{ 0x7731, 0x2A186 },
	{ 0x7732, 0x2A1A8 },
	{ 0x7733, 0x2A172 },
	{ 0x7734, 0x4D02 },
	{ 0x7735, 0x2A18B },
	{ 0x7736, 0x2A191 },
	{ 0x7737, 0x2A1B3 },
	{ 0x7738, 0x2A181 },
	{ 0x7739, 0x2A282 },
	{ 0x773A, 0x2A2E1 },
	{ 0x773B, 0x2A2E3 },
	{ 0x773C, 0x2A2E2 },
	{ 0x773D, 0x2A376 },
	{ 0x773E, 0x2A374 },
	{ 0x773F, 0x2A372 },
	{ 0x7740, 0x2A375 },
	{ 0x7741, 0x2A40E },
	{ 0x7742, 0x2A40D },
	{ 0x7743, 0x2A494 },
	{ 0x7744, 0x2A492 },
	{ 0x7745, 0x2A493 },
	{ 0x7746, 0x2A491 },
	{ 0x7747, 0x2A48F },
	{ 0x7748, 0x2A495 },
	{ 0x7749, 0x2A4D0 },
	{ 0x774A, 0x2A4F7 },
	{ 0x774B, 0x2A576 },
	{ 0x774C, 0x2A5AF },
	{ 0x774D, 0x4D9F },
	{ 0x774E, 0x2A626 },
	{ 0x774F, 0x2A625 },
	{ 0x7750, 0x2A62D },
	{ 0x7751, 0x2A6A0 },
	{ 0x7752, 0x2A6C3 },
	{ 0x7753, 0x204D7 },
	{ 0x7754, 0x20ACC },
	{ 0x7755, 0x21179 },
	{ 0x7756, 0x2117A },
	{ 0x7757, 0x21515 },
	{ 0x7758, 0x21FDB },
	{ 0x7759, 0x22185 },
	{ 0x775A, 0x22970 },
	{ 0x775B, 0x2297B },
	{ 0x775C, 0x22EA5 },
	{ 0x775D, 0x22E9F },
	{ 0x775E, 0x23317 },
	{ 0x775F, 0x233B2 },
	{ 0x7760, 0x23839 },
	{ 0x7761, 0x23840 },
	{ 0x7762, 0x2384E },
	{ 0x7763, 0x2393E },
	{ 0x7764, 0x23AE8 },
	{ 0x7765, 0x23AE7 },
	{ 0x7766, 0x24166 },
	{ 0x7767, 0x24161 },
	{ 0x7768, 0x244DA },
	{ 0x7769, 0x24714 },
	{ 0x776A, 0x248DF },
	{ 0x776B, 0x24F18 },
	{ 0x776C, 0x25039 },
	{ 0x776D, 0x2503A },
	{ 0x776E, 0x25730 },
	{ 0x776F, 0x25732 },
	{ 0x7770, 0x2590E },
	{ 0x7771, 0x25A4C },
	{ 0x7772, 0x25DE8 },
	{ 0x7773, 0x25DF1 },
	{ 0x7774, 0x25DEB },
	{ 0x7775, 0x25DEC },
	{ 0x7776, 0x25F74 },
	{ 0x7777, 0x25F73 },
	{ 0x7778, 0x261F1 },
	{ 0x7779, 0x26342 },
	{ 0x777A, 0x2633E },
	{ 0x777B, 0x26341 },
	{ 0x777C, 0x2652C },
	{ 0x777D, 0x268D2 },
	{ 0x777E, 0x269BB },
	{ 0x7821, 0x27158 },
	{ 0x7822, 0x27157 },
	{ 0x7823, 0x27156 },
	{ 0x7824, 0x2715A },
	{ 0x7825, 0x457D },
	{ 0x7826, 0x27561 },
	{ 0x7827, 0x27568 },
	{ 0x7828, 0x27565 },
	{ 0x7829, 0x2755F },
	{ 0x782A, 0x27564 },
	{ 0x782B, 0x2755E },
	{ 0x782C, 0x2755B },
	{ 0x782D, 0x27567 },
	{ 0x782E, 0x277C3 },
	{ 0x782F, 0x278A2 },
	{ 0x7830, 0x27953 },
	{ 0x7831, 0x27B7D },
	{ 0x7832, 0x27C20 },
	{ 0x7833, 0x27FAE },
	{ 0x7834, 0x27FAF },
	{ 0x7835, 0x27FB0 },
	{ 0x7836, 0x281E7 },
	{ 0x7837, 0x281E6 },
	{ 0x7838, 0x281E9 },
	{ 0x7839, 0x283F1 },
	{ 0x783A, 0x283EB },
	{ 0x783B, 0x283EA },
	{ 0x783C, 0x283E9 },
	{ 0x783D, 0x28663 },
	{ 0x783E, 0x28902 },
	{ 0x783F, 0x288FE },
	{ 0x7840, 0x28BDE },
	{ 0x7841, 0x28CC2 },
	{ 0x7842, 0x28DE6 },
	{ 0x7843, 0x28F5D },
	{ 0x7844, 0x291AD },
	{ 0x7845, 0x29375 },
	{ 0x7846, 0x29372 },
	{ 0x7847, 0x29377 },
	{ 0x7848, 0x4AF6 },
	{ 0x7849, 0x29651 },
	{ 0x784A, 0x297E8 },
	{ 0x784B, 0x297ED },
	{ 0x784C, 0x297EE },
	{ 0x784D, 0x299B9 },
	{ 0x784E, 0x299A1 },
	{ 0x784F, 0x299B6 },
	{ 0x7850, 0x29AAE },
	{ 0x7851, 0x29BE8 },
	{ 0x7852, 0x4C12 },
	{ 0x7853, 0x29C1E },
	{ 0x7854, 0x29D31 },
	{ 0x7855, 0x29D32 },
	{ 0x7856, 0x4C91 },
	{ 0x7857, 0x29F0E },
	{ 0x7858, 0x29F12 },
	{ 0x7859, 0x29F09 },
	{ 0x785A, 0x29F05 },
	{ 0x785B, 0x4C90 },
	{ 0x785C, 0x29F03 },
	{ 0x785D, 0x29F1F },
	{ 0x785E, 0x29F0D },
	{ 0x785F, 0x29F0C },
	{ 0x7860, 0x29F04 },
	{ 0x7861, 0x29F0A },
	{ 0x7862, 0x2A1C2 },
	{ 0x7863, 0x2A1BF },
	{ 0x7864, 0x2A1C9 },
	{ 0x7865, 0x2A1B2 },
	{ 0x7866, 0x2A1C1 },
	{ 0x7867, 0x2A1AF },
	{ 0x7868, 0x2A1B4 },
	{ 0x7869, 0x2A1B0 },
	{ 0x786A, 0x2A1B6 },
	{ 0x786B, 0x2A1B7 },
	{ 0x786C, 0x2A1BB },
	{ 0x786D, 0x2A1B1 },
	{ 0x786E, 0x2A2F0 },
	{ 0x786F, 0x2A378 },
	{ 0x7870, 0x2A37A },
	{ 0x7871, 0x2A379 },
	{ 0x7872, 0x2A3E4 },
	{ 0x7873, 0x2A3E6 },
	{ 0x7874, 0x2A49F },
	{ 0x7875, 0x2A49D },
	{ 0x7876, 0x2A498 },
	{ 0x7877, 0x2A499 },
	{ 0x7878, 0x2A4F9 },
	{ 0x7879, 0x2A530 },
	{ 0x787A, 0x2A582 },
	{ 0x787B, 0x2A581 },
	{ 0x787C, 0x2A5B3 },
	{ 0x787D, 0x2A57F },
	{ 0x787E, 0x2A63A },
	{ 0x7921, 0x2A63E },
	{ 0x7922, 0x2A648 },
	{ 0x7923, 0x21186 },
	{ 0x7924, 0x21936 },
	{ 0x7925, 0x21B13 },
	{ 0x7926, 0x21C22 },
	{ 0x7927, 0x21FDD },
	{ 0x7928, 0x225A7 },
	{ 0x7929, 0x2297D },
	{ 0x792A, 0x3A79 },
	{ 0x792B, 0x2331C },
	{ 0x792C, 0x23865 },
	{ 0x792D, 0x23860 },
	{ 0x792E, 0x23867 },
	{ 0x792F, 0x3C4E },
	{ 0x7930, 0x23B1A },
	{ 0x7931, 0x24AE3 },
	{ 0x7932, 0x25734 },
	{ 0x7933, 0x25918 },
	{ 0x7934, 0x25A52 },
	{ 0x7935, 0x25DFC },
	{ 0x7936, 0x25F79 },
	{ 0x7937, 0x25F78 },
	{ 0x7938, 0x25F76 },
	{ 0x7939, 0x261FA },
	{ 0x793A, 0x261F8 },
	{ 0x793B, 0x2652D },
	{ 0x793C, 0x268D6 },
	{ 0x793D, 0x269BD },
	{ 0x793E, 0x269BF },
	{ 0x793F, 0x269BE },
	{ 0x7940, 0x27144 },
	{ 0x7941, 0x27170 },
	{ 0x7942, 0x27162 },
	{ 0x7943, 0x2716E },
	{ 0x7944, 0x2756E },
	{ 0x7945, 0x2757C },
	{ 0x7946, 0x27574 },
	{ 0x7947, 0x27578 },
	{ 0x7948, 0x27570 },
	{ 0x7949, 0x27579 },
	{ 0x794A, 0x27571 },
	{ 0x794B, 0x277CC },
	{ 0x794C, 0x278A7 },
	{ 0x794D, 0x278A6 },
	{ 0x794E, 0x27B93 },
	{ 0x794F, 0x27C21 },
	{ 0x7950, 0x27C9C },
	{ 0x7951, 0x2829D },
	{ 0x7952, 0x283F4 },
	{ 0x7953, 0x283F3 },
	{ 0x7954, 0x28DF0 },
	{ 0x7955, 0x291B8 },
	{ 0x7956, 0x291B6 },
	{ 0x7957, 0x291BD },
	{ 0x7958, 0x29373 },
	{ 0x7959, 0x29382 },
	{ 0x795A, 0x29587 },
	{ 0x795B, 0x29656 },
	{ 0x795C, 0x29659 },
	{ 0x795D, 0x297F6 },
	{ 0x795E, 0x299C9 },
	{ 0x795F, 0x299C5 },
	{ 0x7960, 0x299C7 },
	{ 0x7961, 0x299CA },
	{ 0x7962, 0x299C2 },
	{ 0x7963, 0x299C4 },
	{ 0x7964, 0x29BF2 },
	{ 0x7965, 0x29BF0 },
	{ 0x7966, 0x29D3B },
	{ 0x7967, 0x29D3A },
	{ 0x7968, 0x29F26 },
	{ 0x7969, 0x29F28 },
	{ 0x796A, 0x29F34 },
	{ 0x796B, 0x29F2D },
	{ 0x796C, 0x2A1D7 },
	{ 0x796D, 0x2A1D2 },
	{ 0x796E, 0x2A1D6 },
	{ 0x796F, 0x2A1DC },
	{ 0x7970, 0x2A1D3 },
	{ 0x7971, 0x2A1D1 },
	{ 0x7972, 0x2A286 },
	{ 0x7973, 0x4D1E },
	{ 0x7974, 0x2A2EF },
	{ 0x7975, 0x2A2EE },
	{ 0x7976, 0x2A3E8 },
	{ 0x7977, 0x2A4AC },
	{ 0x7978, 0x2A4A9 },
	{ 0x7979, 0x2A4AA },
	{ 0x797A, 0x2A4AB },
	{ 0x797B, 0x2A4FB },
	{ 0x797C, 0x2A533 },
	{ 0x797D, 0x2A588 },
	{ 0x797E, 0x2A5B6 },
	{ 0x7A21, 0x2A5B7 },
	{ 0x7A22, 0x2A5D0 },
	{ 0x7A23, 0x2A5CF },
	{ 0x7A24, 0x2A64F },
	{ 0x7A25, 0x2A659 },
	{ 0x7A26, 0x2A64C },
	{ 0x7A27, 0x21B18 },
	{ 0x7A28, 0x21FE0 },
	{ 0x7A29, 0x23869 },
	{ 0x7A2A, 0x24173 },
	{ 0x7A2B, 0x24172 },
	{ 0x7A2C, 0x24AE8 },
	{ 0x7A2D, 0x255FB },
	{ 0x7A2E, 0x2591C },
	{ 0x7A2F, 0x25E09 },
	{ 0x7A30, 0x25E0A },
	{ 0x7A31, 0x25E08 },
	{ 0x7A32, 0x25F7D },
	{ 0x7A33, 0x25F7F },
	{ 0x7A34, 0x26267 },
	{ 0x7A35, 0x2717A },
	{ 0x7A36, 0x2717B },
	{ 0x7A37, 0x277D1 },
	{ 0x7A38, 0x2F9CB },
	{ 0x7A39, 0x27B9D },
	{ 0x7A3A, 0x27C9D },
	{ 0x7A3B, 0x281FC },
	{ 0x7A3C, 0x281FB },
	{ 0x7A3D, 0x281FD },
	{ 0x7A3E, 0x283F5 },
	{ 0x7A3F, 0x283F6 },
	{ 0x7A40, 0x28C0F },
	{ 0x7A41, 0x28C1D },
	{ 0x7A42, 0x291C7 },
	{ 0x7A43, 0x291C1 },
	{ 0x7A44, 0x291BF },
	{ 0x7A45, 0x29254 },
	{ 0x7A46, 0x2937F },
	{ 0x7A47, 0x293F5 },
	{ 0x7A48, 0x2958A },
	{ 0x7A49, 0x2958C },
	{ 0x7A4A, 0x2965C },
	{ 0x7A4B, 0x29865 },
	{ 0x7A4C, 0x299CF },
	{ 0x7A4D, 0x299D0 },
	{ 0x7A4E, 0x29AB8 },
	{ 0x7A4F, 0x29BFA },
	{ 0x7A50, 0x29C66 },
	{ 0x7A51, 0x29F40 },
	{ 0x7A52, 0x29F41 },
	{ 0x7A53, 0x9C72 },
	{ 0x7A54, 0x2A1F7 },
	{ 0x7A55, 0x2A1F3 },
	{ 0x7A56, 0x2A1EF },
	{ 0x7A57, 0x2A1F4 },
	{ 0x7A58, 0x2A1ED },
	{ 0x7A59, 0x2A1F2 },
	{ 0x7A5A, 0x2A1F1 },
	{ 0x7A5B, 0x2A1F9 },
	{ 0x7A5C, 0x2A4B4 },
	{ 0x7A5D, 0x2A4FC },
	{ 0x7A5E, 0x2A5BC },
	{ 0x7A5F, 0x2A65E },
	{ 0x7A60, 0x2A65B },
	{ 0x7A61, 0x2A65F },
	{ 0x7A62, 0x2A65D },
	{ 0x7A63, 0x2A6CF },
	{ 0x7A64, 0x2A6CE },
	{ 0x7A65, 0x2193A },
	{ 0x7A66, 0x21FE1 },
	{ 0x7A67, 0x22315 },
	{ 0x7A68, 0x22314 },
	{ 0x7A69, 0x24178 },
	{ 0x7A6A, 0x24179 },
	{ 0x7A6B, 0x244E6 },
	{ 0x7A6C, 0x24BB8 },
	{ 0x7A6D, 0x24F22 },
	{ 0x7A6E, 0x255FE },
	{ 0x7A6F, 0x268DB },
	{ 0x7A70, 0x26A06 },
	{ 0x7A71, 0x26AC8 },
	{ 0x7A72, 0x27189 },
	{ 0x7A73, 0x27586 },
	{ 0x7A74, 0x278AD },
	{ 0x7A75, 0x27B99 },
	{ 0x7A76, 0x27BD8 },
	{ 0x7A77, 0x27C23 },
	{ 0x7A78, 0x27D23 },
	{ 0x7A79, 0x27FB5 },
	{ 0x7A7A, 0x283F9 },
	{ 0x7A7B, 0x28907 },
	{ 0x7A7C, 0x28C1E },
	{ 0x7A7D, 0x28DFB },
	{ 0x7A7E, 0x28F72 },
	{ 0x7B21, 0x28F73 },
	{ 0x7B22, 0x29387 },
	{ 0x7B23, 0x29449 },
	{ 0x7B24, 0x2965D },
	{ 0x7B25, 0x297F8 },
	{ 0x7B26, 0x29C03 },
	{ 0x7B27, 0x29F4E },
	{ 0x7B28, 0x29F4D },
	{ 0x7B29, 0x29F50 },
	{ 0x7B2A, 0x29F55 },
	{ 0x7B2B, 0x2A209 },
	{ 0x7B2C, 0x2A207 },
	{ 0x7B2D, 0x2A20C },
	{ 0x7B2E, 0x2A203 },
	{ 0x7B2F, 0x2A206 },
	{ 0x7B30, 0x2A20B },
	{ 0x7B31, 0x2A20A },
	{ 0x7B32, 0x2A289 },
	{ 0x7B33, 0x2A4BB },
	{ 0x7B34, 0x2A4FF },
	{ 0x7B35, 0x2A536 },
	{ 0x7B36, 0x2A58B },
	{ 0x7B37, 0x2A666 },
	{ 0x7B38, 0x2A669 },
	{ 0x7B39, 0x2A667 },
	{ 0x7B3A, 0x2A6C2 },
	{ 0x7B3B, 0x2A6D2 },
	{ 0x7B3C, 0x21FE2 },
	{ 0x7B3D, 0x3828 },
	{ 0x7B3E, 0x22988 },
	{ 0x7B3F, 0x2335B },
	{ 0x7B40, 0x23876 },
	{ 0x7B41, 0x2417D },
	{ 0x7B42, 0x245A6 },
	{ 0x7B43, 0x2535A },
	{ 0x7B44, 0x25E17 },
	{ 0x7B45, 0x268DC },
	{ 0x7B46, 0x2718F },
	{ 0x7B47, 0x27594 },
	{ 0x7B48, 0x27595 },
	{ 0x7B49, 0x27FB6 },
	{ 0x7B4A, 0x28204 },
	{ 0x7B4B, 0x287EE },
	{ 0x7B4C, 0x2938A },
	{ 0x7B4D, 0x293F9 },
	{ 0x7B4E, 0x29C07 },
	{ 0x7B4F, 0x29C1F },
	{ 0x7B50, 0x29C2A },
	{ 0x7B51, 0x29D45 },
	{ 0x7B52, 0x29F5C },
	{ 0x7B53, 0x29F5B },
	{ 0x7B54, 0x29F61 },
	{ 0x7B55, 0x29F5D },
	{ 0x7B56, 0x2A218 },
	{ 0x7B57, 0x2A21F },
	{ 0x7B58, 0x2A383 },
	{ 0x7B59, 0x2A416 },
	{ 0x7B5A, 0x2A414 },
	{ 0x7B5B, 0x2A4BF },
	{ 0x7B5C, 0x2A4C0 },
	{ 0x7B5D, 0x2A673 },
	{ 0x7B5E, 0x2A6C0 },
	{ 0x7B5F, 0x21517 },
	{ 0x7B60, 0x22989 },
	{ 0x7B61, 0x2591E },
	{ 0x7B62, 0x2591F },
	{ 0x7B63, 0x25A54 },
	{ 0x7B64, 0x25E18 },
	{ 0x7B65, 0x26205 },
	{ 0x7B66, 0x27195 },
	{ 0x7B67, 0x27598 },
	{ 0x7B68, 0x2759B },
	{ 0x7B69, 0x27959 },
	{ 0x7B6A, 0x28208 },
	{ 0x7B6B, 0x28401 },
	{ 0x7B6C, 0x291CE },
	{ 0x7B6D, 0x293FA },
	{ 0x7B6E, 0x29ABE },
	{ 0x7B6F, 0x29D47 },
	{ 0x7B70, 0x29F6A },
	{ 0x7B71, 0x29F69 },
	{ 0x7B72, 0x29F68 },
	{ 0x7B73, 0x29F67 },
	{ 0x7B74, 0x2A225 },
	{ 0x7B75, 0x2A228 },
	{ 0x7B76, 0x2A4C4 },
	{ 0x7B77, 0x2A537 },
	{ 0x7B78, 0x2A58D },
	{ 0x7B79, 0x2A58C },
	{ 0x7B7A, 0x4D91 },
	{ 0x7B7B, 0x2F920 },
	{ 0x7B7C, 0x25E22 },
	{ 0x7B7D, 0x25F82 },
	{ 0x7B7E, 0x277D9 },
	{ 0x7C21, 0x28C38 },
	{ 0x7C22, 0x293FB },
	{ 0x7C23, 0x299E1 },
	{ 0x7C24, 0x29C72 },
	{ 0x7C25, 0x29D48 },
	{ 0x7C26, 0x29F6C },
	{ 0x7C27, 0x29F70 },
	{ 0x7C28, 0x2A231 },
	{ 0x7C29, 0x2A230 },
	{ 0x7C2A, 0x2A679 },
	{ 0x7C2B, 0x25E23 },
	{ 0x7C2C, 0x268F8 },
	{ 0x7C2D, 0x29C74 },
	{ 0x7C2E, 0x29F73 },
	{ 0x7C2F, 0x2A234 },
	{ 0x7C30, 0x2A387 },
	{ 0x7C31, 0x2A3B2 },
	{ 0x7C32, 0x2A5C2 },
	{ 0x7C33, 0x2A67D },
	{ 0x7C34, 0x21FE5 },
	{ 0x7C35, 0x2938C },
	{ 0x7C36, 0x29F77 },
	{ 0x7C37, 0x29F75 },
	{ 0x7C38, 0x2A238 },
	{ 0x7C39, 0x2A23A },
	{ 0x7C3A, 0x2A683 },
	{ 0x7C3B, 0x2A681 },
	{ 0x7C3C, 0x24180 },
	{ 0x7C3D, 0x27199 },
	{ 0x7C3E, 0x4587 },
	{ 0x7C3F, 0x2944A },
	{ 0x7C40, 0x29D4A },
	{ 0x7C41, 0x2A23C },
	{ 0x7C42, 0x2A6C8 },
	{ 0x7C43, 0x25604 },
	{ 0x7C44, 0x278AF },
	{ 0x7C45, 0x2A689 },
	{ 0x7C46, 0x2A2FA },
	{ 0x7C47, 0x29661 },
	{ 0x7C48, 0x2A23F },
	{ 0x7C49, 0x27193 },
	{ 0x7C4A, 0x2A4C9 },
	{ 0x7C4B, 0x277DE },
	{ 0x7C4C, 0x29391 },
	{ 0x7C4D, 0x2A68E },
	{ 0x7C4E, 0x2A68D },
	{ 0x7C4F, 0x27198 },
	{ 0x7C50, 0x269C5 },
	{ 0x7C51, 0x2A6A5 }
};
/* CNS 11643 plane #6 */
cns_utf cns6_utf_tab[MAX_CNS6_NUM] = {
	{ 0x2121, 0x2F802 },
	{ 0x2122, 0x20062 },
	{ 0x2123, 0x3405 },
	{ 0x2124, 0x20088 },
	{ 0x2125, 0x200D0 },
	{ 0x2126, 0x200CF },
	{ 0x2127, 0x2011E },
	{ 0x2128, 0x2011F },
	{ 0x2129, 0x20120 },
	{ 0x212A, 0x2090E },
	{ 0x212B, 0x2092C },
	{ 0x212C, 0x20061 },
	{ 0x212D, 0x20004 },
	{ 0x212E, 0x20005 },
	{ 0x212F, 0x20003 },
	{ 0x2130, 0x3404 },
	{ 0x2131, 0x2F801 },
	{ 0x2132, 0x2007D },
	{ 0x2133, 0x2008D },
	{ 0x2134, 0x201A3 },
	{ 0x2135, 0x201A4 },
	{ 0x2136, 0x204DB },
	{ 0x2137, 0x20500 },
	{ 0x2138, 0x2F81E },
	{ 0x2139, 0x206A3 },
	{ 0x213A, 0x20832 },
	{ 0x213B, 0x353F },
	{ 0x213C, 0x20AD4 },
	{ 0x213D, 0x20AD5 },
	{ 0x213E, 0x21C23 },
	{ 0x213F, 0x2232C },
	{ 0x2140, 0x2237A },
	{ 0x2141, 0x20503 },
	{ 0x2142, 0x20007 },
	{ 0x2143, 0x20008 },
	{ 0x2144, 0x2008F },
	{ 0x2145, 0x2009C },
	{ 0x2146, 0x200D5 },
	{ 0x2147, 0x20112 },
	{ 0x2148, 0x20113 },
	{ 0x2149, 0x20114 },
	{ 0x214A, 0x20121 },
	{ 0x214B, 0x201A8 },
	{ 0x214C, 0x201A6 },
	{ 0x214D, 0x20476 },
	{ 0x214E, 0x20501 },
	{ 0x214F, 0x2053D },
	{ 0x2150, 0x2F814 },
	{ 0x2151, 0x2053E },
	{ 0x2152, 0x20629 },
	{ 0x2153, 0x20677 },
	{ 0x2154, 0x20678 },
	{ 0x2155, 0x206A6 },
	{ 0x2156, 0x206A9 },
	{ 0x2157, 0x206AC },
	{ 0x2158, 0x20834 },
	{ 0x2159, 0x20504 },
	{ 0x215A, 0x2097B },
	{ 0x215B, 0x20A10 },
	{ 0x215C, 0x2062F },
	{ 0x215D, 0x20AD7 },
	{ 0x215E, 0x20B1C },
	{ 0x215F, 0x20B1F },
	{ 0x2160, 0x20B1A },
	{ 0x2161, 0x2F836 },
	{ 0x2162, 0x20B1E },
	{ 0x2163, 0x20B9E },
	{ 0x2164, 0x20B9A },
	{ 0x2165, 0x211A0 },
	{ 0x2166, 0x211A1 },
	{ 0x2167, 0x215D2 },
	{ 0x2168, 0x215D3 },
	{ 0x2169, 0x219B9 },
	{ 0x216A, 0x21B1D },
	{ 0x216B, 0x21B55 },
	{ 0x216C, 0x21CFF },
	{ 0x216D, 0x21FE7 },
	{ 0x216E, 0x382A },
	{ 0x216F, 0x22011 },
	{ 0x2170, 0x22013 },
	{ 0x2171, 0x22012 },
	{ 0x2172, 0x221AF },
	{ 0x2173, 0x221B1 },
	{ 0x2174, 0x2F890 },
	{ 0x2175, 0x2232D },
	{ 0x2176, 0x2237B },
	{ 0x2177, 0x2239D },
	{ 0x2178, 0x2239A },
	{ 0x2179, 0x38A7 },
	{ 0x217A, 0x2239F },
	{ 0x217B, 0x223A0 },
	{ 0x217C, 0x2239C },
	{ 0x217D, 0x224BD },
	{ 0x217E, 0x38FA },
	{ 0x2221, 0x225AA },
	{ 0x2222, 0x2306C },
	{ 0x2223, 0x23091 },
	{ 0x2224, 0x23C74 },
	{ 0x2225, 0x2456A },
	{ 0x2226, 0x2F929 },
	{ 0x2227, 0x25605 },
	{ 0x2228, 0x2626B },
	{ 0x2229, 0x2626A },
	{ 0x222A, 0x200E0 },
	{ 0x222B, 0x20012 },
	{ 0x222C, 0x3400 },
	{ 0x222D, 0x2007F },
	{ 0x222E, 0x200A0 },
	{ 0x222F, 0x20099 },
	{ 0x2230, 0x20095 },
	{ 0x2231, 0x2009E },
	{ 0x2232, 0x200DF },
	{ 0x2233, 0x200DE },
	{ 0x2234, 0x201AF },
	{ 0x2235, 0x201AD },
	{ 0x2236, 0x201B0 },
	{ 0x2237, 0x204DF },
	{ 0x2238, 0x20543 },
	{ 0x2239, 0x20541 },
	{ 0x223A, 0x20548 },
	{ 0x223B, 0x20575 },
	{ 0x223C, 0x2F81A },
	{ 0x223D, 0x20632 },
	{ 0x223E, 0x2067B },
	{ 0x223F, 0x20679 },
	{ 0x2240, 0x206B3 },
	{ 0x2241, 0x34DB },
	{ 0x2242, 0x20BA7 },
	{ 0x2243, 0x206B2 },
	{ 0x2244, 0x206B0 },
	{ 0x2245, 0x206B4 },
	{ 0x2246, 0x2F829 },
	{ 0x2247, 0x208CD },
	{ 0x2248, 0x208CE },
	{ 0x2249, 0x2F82B },
	{ 0x224A, 0x20910 },
	{ 0x224B, 0x20980 },
	{ 0x224C, 0x209D3 },
	{ 0x224D, 0x20A30 },
	{ 0x224E, 0x20098 },
	{ 0x224F, 0x20A2F },
	{ 0x2250, 0x20A31 },
	{ 0x2251, 0x20ADA },
	{ 0x2252, 0x20AD9 },
	{ 0x2253, 0x20B27 },
	{ 0x2254, 0x20B28 },
	{ 0x2255, 0x20B21 },
	{ 0x2256, 0x20B25 },
	{ 0x2257, 0x20BA6 },
	{ 0x2258, 0x20BA2 },
	{ 0x2259, 0x20BA1 },
	{ 0x225A, 0x20BA4 },
	{ 0x225B, 0x2F839 },
	{ 0x225C, 0x20BAA },
	{ 0x225D, 0x20BA5 },
	{ 0x225E, 0x20BA3 },
	{ 0x225F, 0x20064 },
	{ 0x2260, 0x2123F },
	{ 0x2261, 0x21244 },
	{ 0x2262, 0x2151B },
	{ 0x2263, 0x21553 },
	{ 0x2264, 0x21584 },
	{ 0x2265, 0x21586 },
	{ 0x2266, 0x215D5 },
	{ 0x2267, 0x2F860 },
	{ 0x2268, 0x2193E },
	{ 0x2269, 0x21940 },
	{ 0x226A, 0x21BCA },
	{ 0x226B, 0x21BC9 },
	{ 0x226C, 0x21C26 },
	{ 0x226D, 0x21D00 },
	{ 0x226E, 0x21D31 },
	{ 0x226F, 0x21D3C },
	{ 0x2270, 0x21D30 },
	{ 0x2271, 0x21D33 },
	{ 0x2272, 0x21D32 },
	{ 0x2273, 0x21D38 },
	{ 0x2274, 0x22034 },
	{ 0x2275, 0x22053 },
	{ 0x2276, 0x22054 },
	{ 0x2277, 0x221B4 },
	{ 0x2278, 0x221B2 },
	{ 0x2279, 0x2232F },
	{ 0x227A, 0x223A5 },
	{ 0x227B, 0x223A7 },
	{ 0x227C, 0x223A4 },
	{ 0x227D, 0x223A8 },
	{ 0x227E, 0x223A9 },
	{ 0x2321, 0x223A2 },
	{ 0x2322, 0x223A3 },
	{ 0x2323, 0x223A6 },
	{ 0x2324, 0x22481 },
	{ 0x2325, 0x22480 },
	{ 0x2326, 0x225AD },
	{ 0x2327, 0x22A24 },
	{ 0x2328, 0x22A65 },
	{ 0x2329, 0x22A68 },
	{ 0x232A, 0x22A69 },
	{ 0x232B, 0x2313C },
	{ 0x232C, 0x2313B },
	{ 0x232D, 0x2335D },
	{ 0x232E, 0x23944 },
	{ 0x232F, 0x24182 },
	{ 0x2330, 0x244F1 },
	{ 0x2331, 0x2456B },
	{ 0x2332, 0x2471B },
	{ 0x2333, 0x248EB },
	{ 0x2334, 0x24BBA },
	{ 0x2335, 0x24BD3 },
	{ 0x2336, 0x24D13 },
	{ 0x2337, 0x25922 },
	{ 0x2338, 0x26AF4 },
	{ 0x2339, 0x2820F },
	{ 0x233A, 0x28210 },
	{ 0x233B, 0x20507 },
	{ 0x233C, 0x29C0B },
	{ 0x233D, 0x29C0A },
	{ 0x233E, 0x20019 },
	{ 0x233F, 0x2001A },
	{ 0x2340, 0x20018 },
	{ 0x2341, 0x20066 },
	{ 0x2342, 0x20082 },
	{ 0x2343, 0x200A8 },
	{ 0x2344, 0x200E5 },
	{ 0x2345, 0x200E7 },
	{ 0x2346, 0x200E4 },
	{ 0x2347, 0x20115 },
	{ 0x2348, 0x20123 },
	{ 0x2349, 0x20124 },
	{ 0x234A, 0x20143 },
	{ 0x234B, 0x201C3 },
	{ 0x234C, 0x201BC },
	{ 0x234D, 0x201BB },
	{ 0x234E, 0x3438 },
	{ 0x234F, 0x201B7 },
	{ 0x2350, 0x201B9 },
	{ 0x2351, 0x201CF },
	{ 0x2352, 0x2F80D },
	{ 0x2353, 0x2047A },
	{ 0x2354, 0x2047B },
	{ 0x2355, 0x204E1 },
	{ 0x2356, 0x204E0 },
	{ 0x2357, 0x20509 },
	{ 0x2358, 0x2054D },
	{ 0x2359, 0x2F816 },
	{ 0x235A, 0x2054B },
	{ 0x235B, 0x20579 },
	{ 0x235C, 0x205B1 },
	{ 0x235D, 0x20636 },
	{ 0x235E, 0x20635 },
	{ 0x235F, 0x20637 },
	{ 0x2360, 0x20638 },
	{ 0x2361, 0x2067F },
	{ 0x2362, 0x20680 },
	{ 0x2363, 0x20681 },
	{ 0x2364, 0x26953 },
	{ 0x2365, 0x2067E },
	{ 0x2366, 0x206CD },
	{ 0x2367, 0x206BF },
	{ 0x2368, 0x206BE },
	{ 0x2369, 0x206C2 },
	{ 0x236A, 0x206B8 },
	{ 0x236B, 0x206C1 },
	{ 0x236C, 0x6530 },
	{ 0x236D, 0x20931 },
	{ 0x236E, 0x2092F },
	{ 0x236F, 0x2096F },
	{ 0x2370, 0x20982 },
	{ 0x2371, 0x353A },
	{ 0x2372, 0x20987 },
	{ 0x2373, 0x20986 },
	{ 0x2374, 0x2098D },
	{ 0x2375, 0x20994 },
	{ 0x2376, 0x209D7 },
	{ 0x2377, 0x209D4 },
	{ 0x2378, 0x209D8 },
	{ 0x2379, 0x20A16 },
	{ 0x237A, 0x20A14 },
	{ 0x237B, 0x20A2E },
	{ 0x237C, 0x20A36 },
	{ 0x237D, 0x20A37 },
	{ 0x237E, 0x21FEE },
	{ 0x2421, 0x20AE0 },
	{ 0x2422, 0x20AE5 },
	{ 0x2423, 0x20ADF },
	{ 0x2424, 0x20B2B },
	{ 0x2425, 0x20B29 },
	{ 0x2426, 0x20B2D },
	{ 0x2427, 0x20B2F },
	{ 0x2428, 0x20BB7 },
	{ 0x2429, 0x20BC9 },
	{ 0x242A, 0x20BC1 },
	{ 0x242B, 0x20BCA },
	{ 0x242C, 0x20BB2 },
	{ 0x242D, 0x20BAC },
	{ 0x242E, 0x20BAE },
	{ 0x242F, 0x211B2 },
	{ 0x2430, 0x211A8 },
	{ 0x2431, 0x211B0 },
	{ 0x2432, 0x211A7 },
	{ 0x2433, 0x2F851 },
	{ 0x2434, 0x21252 },
	{ 0x2435, 0x2124A },
	{ 0x2436, 0x21556 },
	{ 0x2437, 0x21555 },
	{ 0x2438, 0x2155F },
	{ 0x2439, 0x2155E },
	{ 0x243A, 0x21588 },
	{ 0x243B, 0x2F85D },
	{ 0x243C, 0x215DD },
	{ 0x243D, 0x215E2 },
	{ 0x243E, 0x215E1 },
	{ 0x243F, 0x215DF },
	{ 0x2440, 0x215E0 },
	{ 0x2441, 0x216AF },
	{ 0x2442, 0x216B1 },
	{ 0x2443, 0x216BA },
	{ 0x2444, 0x21945 },
	{ 0x2445, 0x21943 },
	{ 0x2446, 0x219BD },
	{ 0x2447, 0x219C8 },
	{ 0x2448, 0x2F86C },
	{ 0x2449, 0x219BE },
	{ 0x244A, 0x219BF },
	{ 0x244B, 0x2F874 },
	{ 0x244C, 0x21B59 },
	{ 0x244D, 0x21C29 },
	{ 0x244E, 0x21C2C },
	{ 0x244F, 0x21C2F },
	{ 0x2450, 0x21C2D },
	{ 0x2451, 0x21C2E },
	{ 0x2452, 0x21D04 },
	{ 0x2453, 0x21D02 },
	{ 0x2454, 0x21D01 },
	{ 0x2455, 0x21D40 },
	{ 0x2456, 0x21D4A },
	{ 0x2457, 0x21D3F },
	{ 0x2458, 0x21D4F },
	{ 0x2459, 0x21D41 },
	{ 0x245A, 0x21D4E },
	{ 0x245B, 0x21FEB },
	{ 0x245C, 0x21FEC },
	{ 0x245D, 0x200AC },
	{ 0x245E, 0x2205B },
	{ 0x245F, 0x22063 },
	{ 0x2460, 0x2205A },
	{ 0x2461, 0x22059 },
	{ 0x2462, 0x221DC },
	{ 0x2463, 0x221DB },
	{ 0x2464, 0x221D9 },
	{ 0x2465, 0x221E0 },
	{ 0x2466, 0x221DD },
	{ 0x2467, 0x20020 },
	{ 0x2468, 0x223B0 },
	{ 0x2469, 0x223B1 },
	{ 0x246A, 0x223B2 },
	{ 0x246B, 0x223B6 },
	{ 0x246C, 0x22451 },
	{ 0x246D, 0x22452 },
	{ 0x246E, 0x22450 },
	{ 0x246F, 0x22484 },
	{ 0x2470, 0x38C9 },
	{ 0x2471, 0x22483 },
	{ 0x2472, 0x225C3 },
	{ 0x2473, 0x225B8 },
	{ 0x2474, 0x225B9 },
	{ 0x2475, 0x225B2 },
	{ 0x2476, 0x22990 },
	{ 0x2477, 0x22A26 },
	{ 0x2478, 0x22A29 },
	{ 0x2479, 0x22A6E },
	{ 0x247A, 0x23140 },
	{ 0x247B, 0x2313E },
	{ 0x247C, 0x23141 },
	{ 0x247D, 0x2335E },
	{ 0x247E, 0x233BB },
	{ 0x2521, 0x233BC },
	{ 0x2522, 0x233B9 },
	{ 0x2523, 0x2F8EF },
	{ 0x2524, 0x23880 },
	{ 0x2525, 0x3C4F },
	{ 0x2526, 0x23945 },
	{ 0x2527, 0x239BA },
	{ 0x2528, 0x239BD },
	{ 0x2529, 0x23C56 },
	{ 0x252A, 0x23C55 },
	{ 0x252B, 0x23C75 },
	{ 0x252C, 0x23C77 },
	{ 0x252D, 0x23C81 },
	{ 0x252E, 0x2F8FA },
	{ 0x252F, 0x23C83 },
	{ 0x2530, 0x23C8B },
	{ 0x2531, 0x23C84 },
	{ 0x2532, 0x24186 },
	{ 0x2533, 0x24183 },
	{ 0x2534, 0x2418B },
	{ 0x2535, 0x2456D },
	{ 0x2536, 0x24616 },
	{ 0x2537, 0x24728 },
	{ 0x2538, 0x248EA },
	{ 0x2539, 0x24BD4 },
	{ 0x253A, 0x24C03 },
	{ 0x253B, 0x24D15 },
	{ 0x253C, 0x24F3D },
	{ 0x253D, 0x24F3E },
	{ 0x253E, 0x25416 },
	{ 0x253F, 0x2F94C },
	{ 0x2540, 0x25606 },
	{ 0x2541, 0x2574D },
	{ 0x2542, 0x26222 },
	{ 0x2543, 0x26273 },
	{ 0x2544, 0x2626D },
	{ 0x2545, 0x2626E },
	{ 0x2546, 0x264B1 },
	{ 0x2547, 0x2054E },
	{ 0x2548, 0x2662D },
	{ 0x2549, 0x43CD },
	{ 0x254A, 0x268F9 },
	{ 0x254B, 0x26952 },
	{ 0x254C, 0x26B00 },
	{ 0x254D, 0x26AFC },
	{ 0x254E, 0x26AFA },
	{ 0x254F, 0x4492 },
	{ 0x2550, 0x26AF7 },
	{ 0x2551, 0x26AF8 },
	{ 0x2552, 0x2F990 },
	{ 0x2553, 0x2F9C4 },
	{ 0x2554, 0x27C27 },
	{ 0x2555, 0x28211 },
	{ 0x2556, 0x200AE },
	{ 0x2557, 0x28450 },
	{ 0x2558, 0x2844F },
	{ 0x2559, 0x2844D },
	{ 0x255A, 0x28671 },
	{ 0x255B, 0x2F9E2 },
	{ 0x255C, 0x28672 },
	{ 0x255D, 0x28E18 },
	{ 0x255E, 0x20A44 },
	{ 0x255F, 0x20021 },
	{ 0x2560, 0x20067 },
	{ 0x2561, 0x200AF },
	{ 0x2562, 0x200B0 },
	{ 0x2563, 0x20029 },
	{ 0x2564, 0x20117 },
	{ 0x2565, 0x20122 },
	{ 0x2566, 0x2F803 },
	{ 0x2567, 0x20025 },
	{ 0x2568, 0x20128 },
	{ 0x2569, 0x201FF },
	{ 0x256A, 0x201D9 },
	{ 0x256B, 0x201DB },
	{ 0x256C, 0x201DE },
	{ 0x256D, 0x201F2 },
	{ 0x256E, 0x201FE },
	{ 0x256F, 0x201F4 },
	{ 0x2570, 0x201DD },
	{ 0x2571, 0x3445 },
	{ 0x2572, 0x2F804 },
	{ 0x2573, 0x20201 },
	{ 0x2574, 0x201DC },
	{ 0x2575, 0x2047D },
	{ 0x2576, 0x20481 },
	{ 0x2577, 0x2047E },
	{ 0x2578, 0x2047F },
	{ 0x2579, 0x204E5 },
	{ 0x257A, 0x2050F },
	{ 0x257B, 0x34B5 },
	{ 0x257C, 0x2050A },
	{ 0x257D, 0x34B6 },
	{ 0x257E, 0x2050B },
	{ 0x2621, 0x20551 },
	{ 0x2622, 0x20552 },
	{ 0x2623, 0x20550 },
	{ 0x2624, 0x205B8 },
	{ 0x2625, 0x2063D },
	{ 0x2626, 0x2063E },
	{ 0x2627, 0x2063C },
	{ 0x2628, 0x20687 },
	{ 0x2629, 0x206D7 },
	{ 0x262A, 0x206DB },
	{ 0x262B, 0x206CF },
	{ 0x262C, 0x206E0 },
	{ 0x262D, 0x2084C },
	{ 0x262E, 0x20842 },
	{ 0x262F, 0x208D4 },
	{ 0x2630, 0x20911 },
	{ 0x2631, 0x20914 },
	{ 0x2632, 0x20915 },
	{ 0x2633, 0x20912 },
	{ 0x2634, 0x20933 },
	{ 0x2635, 0x20935 },
	{ 0x2636, 0x3537 },
	{ 0x2637, 0x20971 },
	{ 0x2638, 0x3530 },
	{ 0x2639, 0x20991 },
	{ 0x263A, 0x20993 },
	{ 0x263B, 0x20995 },
	{ 0x263C, 0x209DC },
	{ 0x263D, 0x20A42 },
	{ 0x263E, 0x20A40 },
	{ 0x263F, 0x253A6 },
	{ 0x2640, 0x20AE6 },
	{ 0x2641, 0x2128F },
	{ 0x2642, 0x20B32 },
	{ 0x2643, 0x2F837 },
	{ 0x2644, 0x20B31 },
	{ 0x2645, 0x20BF5 },
	{ 0x2646, 0x20BCD },
	{ 0x2647, 0x20BDE },
	{ 0x2648, 0x20BD5 },
	{ 0x2649, 0x20BDA },
	{ 0x264A, 0x20BEE },
	{ 0x264B, 0x20BEC },
	{ 0x264C, 0x20BCF },
	{ 0x264D, 0x20BCE },
	{ 0x264E, 0x2F83D },
	{ 0x264F, 0x20BCC },
	{ 0x2650, 0x20BF3 },
	{ 0x2651, 0x211C1 },
	{ 0x2652, 0x211C4 },
	{ 0x2653, 0x211C6 },
	{ 0x2654, 0x211B4 },
	{ 0x2655, 0x211C3 },
	{ 0x2656, 0x211B8 },
	{ 0x2657, 0x211BB },
	{ 0x2658, 0x211B7 },
	{ 0x2659, 0x211BC },
	{ 0x265A, 0x211BF },
	{ 0x265B, 0x211C7 },
	{ 0x265C, 0x211BE },
	{ 0x265D, 0x21260 },
	{ 0x265E, 0x2125D },
	{ 0x265F, 0x21276 },
	{ 0x2660, 0x2126C },
	{ 0x2661, 0x21275 },
	{ 0x2662, 0x2125B },
	{ 0x2663, 0x21271 },
	{ 0x2664, 0x21273 },
	{ 0x2665, 0x21261 },
	{ 0x2666, 0x2125A },
	{ 0x2667, 0x21262 },
	{ 0x2668, 0x21272 },
	{ 0x2669, 0x2125F },
	{ 0x266A, 0x21258 },
	{ 0x266B, 0x2151E },
	{ 0x266C, 0x21558 },
	{ 0x266D, 0x2158B },
	{ 0x266E, 0x2158A },
	{ 0x266F, 0x215F4 },
	{ 0x2670, 0x215F0 },
	{ 0x2671, 0x216D2 },
	{ 0x2672, 0x216CD },
	{ 0x2673, 0x216CE },
	{ 0x2674, 0x216BC },
	{ 0x2675, 0x216D0 },
	{ 0x2676, 0x21946 },
	{ 0x2677, 0x21947 },
	{ 0x2678, 0x373E },
	{ 0x2679, 0x374D },
	{ 0x267A, 0x3751 },
	{ 0x267B, 0x219CE },
	{ 0x267C, 0x219CF },
	{ 0x267D, 0x219CC },
	{ 0x267E, 0x219CB },
	{ 0x2721, 0x2F872 },
	{ 0x2722, 0x21B60 },
	{ 0x2723, 0x21B5F },
	{ 0x2724, 0x21B5D },
	{ 0x2725, 0x21BD4 },
	{ 0x2726, 0x21C3A },
	{ 0x2727, 0x21C38 },
	{ 0x2728, 0x21C3C },
	{ 0x2729, 0x21C36 },
	{ 0x272A, 0x21D08 },
	{ 0x272B, 0x21D7E },
	{ 0x272C, 0x21D5E },
	{ 0x272D, 0x21D6E },
	{ 0x272E, 0x21D53 },
	{ 0x272F, 0x21D70 },
	{ 0x2730, 0x21D57 },
	{ 0x2731, 0x21D5D },
	{ 0x2732, 0x21D63 },
	{ 0x2733, 0x21D7A },
	{ 0x2734, 0x21D79 },
	{ 0x2735, 0x21D93 },
	{ 0x2736, 0x2F881 },
	{ 0x2737, 0x2201D },
	{ 0x2738, 0x22068 },
	{ 0x2739, 0x22073 },
	{ 0x273A, 0x22074 },
	{ 0x273B, 0x22066 },
	{ 0x273C, 0x2206F },
	{ 0x273D, 0x22075 },
	{ 0x273E, 0x2207A },
	{ 0x273F, 0x22070 },
	{ 0x2740, 0x2206D },
	{ 0x2741, 0x22065 },
	{ 0x2742, 0x2218A },
	{ 0x2743, 0x221ED },
	{ 0x2744, 0x221E9 },
	{ 0x2745, 0x221E3 },
	{ 0x2746, 0x221EF },
	{ 0x2747, 0x3873 },
	{ 0x2748, 0x221EA },
	{ 0x2749, 0x22331 },
	{ 0x274A, 0x2F891 },
	{ 0x274B, 0x22338 },
	{ 0x274C, 0x26B20 },
	{ 0x274D, 0x22335 },
	{ 0x274E, 0x2233A },
	{ 0x274F, 0x22381 },
	{ 0x2750, 0x22380 },
	{ 0x2751, 0x223B8 },
	{ 0x2752, 0x223C1 },
	{ 0x2753, 0x223BA },
	{ 0x2754, 0x22488 },
	{ 0x2755, 0x224CF },
	{ 0x2756, 0x224CA },
	{ 0x2757, 0x224C7 },
	{ 0x2758, 0x224C5 },
	{ 0x2759, 0x224C8 },
	{ 0x275A, 0x224D0 },
	{ 0x275B, 0x224C9 },
	{ 0x275C, 0x225BB },
	{ 0x275D, 0x225B6 },
	{ 0x275E, 0x225BD },
	{ 0x275F, 0x2F89D },
	{ 0x2760, 0x225B4 },
	{ 0x2761, 0x225C1 },
	{ 0x2762, 0x225D1 },
	{ 0x2763, 0x225D2 },
	{ 0x2764, 0x225CC },
	{ 0x2765, 0x225D4 },
	{ 0x2766, 0x225CB },
	{ 0x2767, 0x225CE },
	{ 0x2768, 0x225D5 },
	{ 0x2769, 0x225D8 },
	{ 0x276A, 0x22995 },
	{ 0x276B, 0x22993 },
	{ 0x276C, 0x22999 },
	{ 0x276D, 0x22996 },
	{ 0x276E, 0x39BE },
	{ 0x276F, 0x22A89 },
	{ 0x2770, 0x22A94 },
	{ 0x2771, 0x22A91 },
	{ 0x2772, 0x22A8F },
	{ 0x2773, 0x22A84 },
	{ 0x2774, 0x22A97 },
	{ 0x2775, 0x22A86 },
	{ 0x2776, 0x22A85 },
	{ 0x2777, 0x22A8C },
	{ 0x2778, 0x22EF2 },
	{ 0x2779, 0x22EED },
	{ 0x277A, 0x22EEF },
	{ 0x277B, 0x230D9 },
	{ 0x277C, 0x23146 },
	{ 0x277D, 0x23147 },
	{ 0x277E, 0x2314B },
	{ 0x2821, 0x23150 },
	{ 0x2822, 0x2314A },
	{ 0x2823, 0x2314E },
	{ 0x2824, 0x2314C },
	{ 0x2825, 0x23148 },
	{ 0x2826, 0x23363 },
	{ 0x2827, 0x23361 },
	{ 0x2828, 0x23362 },
	{ 0x2829, 0x23360 },
	{ 0x282A, 0x233C3 },
	{ 0x282B, 0x233C5 },
	{ 0x282C, 0x233C1 },
	{ 0x282D, 0x233D0 },
	{ 0x282E, 0x2F8DC },
	{ 0x282F, 0x23882 },
	{ 0x2830, 0x3C1E },
	{ 0x2831, 0x23886 },
	{ 0x2832, 0x23884 },
	{ 0x2833, 0x2394C },
	{ 0x2834, 0x23948 },
	{ 0x2835, 0x239B8 },
	{ 0x2836, 0x239BF },
	{ 0x2837, 0x239C1 },
	{ 0x2838, 0x239C6 },
	{ 0x2839, 0x239C5 },
	{ 0x283A, 0x239C7 },
	{ 0x283B, 0x239C0 },
	{ 0x283C, 0x239C3 },
	{ 0x283D, 0x23AED },
	{ 0x283E, 0x23B03 },
	{ 0x283F, 0x23B22 },
	{ 0x2840, 0x23B21 },
	{ 0x2841, 0x23C9F },
	{ 0x2842, 0x23C90 },
	{ 0x2843, 0x23C9E },
	{ 0x2844, 0x3CC8 },
	{ 0x2845, 0x23CA0 },
	{ 0x2846, 0x23C94 },
	{ 0x2847, 0x23C95 },
	{ 0x2848, 0x23CA1 },
	{ 0x2849, 0x3CC3 },
	{ 0x284A, 0x3CC7 },
	{ 0x284B, 0x2419A },
	{ 0x284C, 0x24190 },
	{ 0x284D, 0x244F2 },
	{ 0x284E, 0x244F3 },
	{ 0x284F, 0x2456E },
	{ 0x2850, 0x245AB },
	{ 0x2851, 0x245A9 },
	{ 0x2852, 0x2461A },
	{ 0x2853, 0x24618 },
	{ 0x2854, 0x2461B },
	{ 0x2855, 0x24760 },
	{ 0x2856, 0x2474C },
	{ 0x2857, 0x24742 },
	{ 0x2858, 0x24733 },
	{ 0x2859, 0x2473F },
	{ 0x285A, 0x2473E },
	{ 0x285B, 0x24738 },
	{ 0x285C, 0x24743 },
	{ 0x285D, 0x24746 },
	{ 0x285E, 0x24736 },
	{ 0x285F, 0x248EE },
	{ 0x2860, 0x248F5 },
	{ 0x2861, 0x248F4 },
	{ 0x2862, 0x3F56 },
	{ 0x2863, 0x24C1B },
	{ 0x2864, 0x3540 },
	{ 0x2865, 0x24D2B },
	{ 0x2866, 0x24D29 },
	{ 0x2867, 0x24D2A },
	{ 0x2868, 0x24D2E },
	{ 0x2869, 0x2503F },
	{ 0x286A, 0x250E6 },
	{ 0x286B, 0x253A7 },
	{ 0x286C, 0x253A8 },
	{ 0x286D, 0x25418 },
	{ 0x286E, 0x25608 },
	{ 0x286F, 0x25750 },
	{ 0x2870, 0x25753 },
	{ 0x2871, 0x25A56 },
	{ 0x2872, 0x25A55 },
	{ 0x2873, 0x2626F },
	{ 0x2874, 0x2627F },
	{ 0x2875, 0x264B3 },
	{ 0x2876, 0x2663A },
	{ 0x2877, 0x26638 },
	{ 0x2878, 0x26637 },
	{ 0x2879, 0x26636 },
	{ 0x287A, 0x20554 },
	{ 0x287B, 0x2F980 },
	{ 0x287C, 0x268DD },
	{ 0x287D, 0x268FC },
	{ 0x287E, 0x268FA },
	{ 0x2921, 0x26933 },
	{ 0x2922, 0x26B04 },
	{ 0x2923, 0x26B07 },
	{ 0x2924, 0x26B08 },
	{ 0x2925, 0x26B06 },
	{ 0x2926, 0x26B09 },
	{ 0x2927, 0x2F991 },
	{ 0x2928, 0x2F993 },
	{ 0x2929, 0x2721E },
	{ 0x292A, 0x2F9D2 },
	{ 0x292B, 0x2840B },
	{ 0x292C, 0x28443 },
	{ 0x292D, 0x28452 },
	{ 0x292E, 0x28458 },
	{ 0x292F, 0x2845E },
	{ 0x2930, 0x28668 },
	{ 0x2931, 0x2868D },
	{ 0x2932, 0x28682 },
	{ 0x2933, 0x2867B },
	{ 0x2934, 0x28C58 },
	{ 0x2935, 0x49BD },
	{ 0x2936, 0x2F800 },
	{ 0x2937, 0x2002C },
	{ 0x2938, 0x2002E },
	{ 0x2939, 0x2160B },
	{ 0x293A, 0x2002D },
	{ 0x293B, 0x20069 },
	{ 0x293C, 0x200B2 },
	{ 0x293D, 0x200B6 },
	{ 0x293E, 0x200A9 },
	{ 0x293F, 0x200ED },
	{ 0x2940, 0x20119 },
	{ 0x2941, 0x2014F },
	{ 0x2942, 0x20216 },
	{ 0x2943, 0x20203 },
	{ 0x2944, 0x2020E },
	{ 0x2945, 0x20204 },
	{ 0x2946, 0x20207 },
	{ 0x2947, 0x20210 },
	{ 0x2948, 0x20227 },
	{ 0x2949, 0x20228 },
	{ 0x294A, 0x2020D },
	{ 0x294B, 0x20229 },
	{ 0x294C, 0x2020F },
	{ 0x294D, 0x20222 },
	{ 0x294E, 0x20211 },
	{ 0x294F, 0x20485 },
	{ 0x2950, 0x20484 },
	{ 0x2951, 0x20483 },
	{ 0x2952, 0x2048A },
	{ 0x2953, 0x20486 },
	{ 0x2954, 0x20510 },
	{ 0x2955, 0x20558 },
	{ 0x2956, 0x2055A },
	{ 0x2957, 0x2070C },
	{ 0x2958, 0x205C4 },
	{ 0x2959, 0x205C5 },
	{ 0x295A, 0x20647 },
	{ 0x295B, 0x20649 },
	{ 0x295C, 0x2064A },
	{ 0x295D, 0x2064B },
	{ 0x295E, 0x221BB },
	{ 0x295F, 0x2068D },
	{ 0x2960, 0x2068B },
	{ 0x2961, 0x20707 },
	{ 0x2962, 0x20706 },
	{ 0x2963, 0x2F820 },
	{ 0x2964, 0x206EF },
	{ 0x2965, 0x206F0 },
	{ 0x2966, 0x206ED },
	{ 0x2967, 0x206F9 },
	{ 0x2968, 0x20702 },
	{ 0x2969, 0x206E7 },
	{ 0x296A, 0x206F4 },
	{ 0x296B, 0x206F7 },
	{ 0x296C, 0x206F1 },
	{ 0x296D, 0x20853 },
	{ 0x296E, 0x20855 },
	{ 0x296F, 0x351A },
	{ 0x2970, 0x208DA },
	{ 0x2971, 0x208D9 },
	{ 0x2972, 0x352C },
	{ 0x2973, 0x20938 },
	{ 0x2974, 0x20999 },
	{ 0x2975, 0x209A2 },
	{ 0x2976, 0x2099C },
	{ 0x2977, 0x2099A },
	{ 0x2978, 0x2099B },
	{ 0x2979, 0x209E5 },
	{ 0x297A, 0x209E3 },
	{ 0x297B, 0x209E1 },
	{ 0x297C, 0x209E0 },
	{ 0x297D, 0x209E2 },
	{ 0x297E, 0x209E4 },
	{ 0x2A22, 0x209E8 },
	{ 0x2A23, 0x2F82F },
	{ 0x2A24, 0x20A13 },
	{ 0x2A25, 0x20A56 },
	{ 0x2A26, 0x20A4B },
	{ 0x2A27, 0x20A4A },
	{ 0x2A28, 0x20A4D },
	{ 0x2A29, 0x20A4C },
	{ 0x2A2A, 0x3549 },
	{ 0x2A2B, 0x20AEA },
	{ 0x2A2C, 0x20AE9 },
	{ 0x2A2D, 0x20AEB },
	{ 0x2A2E, 0x20AEC },
	{ 0x2A2F, 0x20B3A },
	{ 0x2A30, 0x20B3C },
	{ 0x2A31, 0x20B39 },
	{ 0x2A32, 0x20B3B },
	{ 0x2A33, 0x20C14 },
	{ 0x2A34, 0x20C0E },
	{ 0x2A35, 0x20C35 },
	{ 0x2A36, 0x20C0A },
	{ 0x2A37, 0x20C3F },
	{ 0x2A38, 0x20C38 },
	{ 0x2A39, 0x357C },
	{ 0x2A3A, 0x20C4E },
	{ 0x2A3B, 0x20C17 },
	{ 0x2A3C, 0x2F83F },
	{ 0x2A3D, 0x20C1E },
	{ 0x2A3E, 0x211B6 },
	{ 0x2A3F, 0x211CE },
	{ 0x2A40, 0x211CA },
	{ 0x2A41, 0x211CB },
	{ 0x2A42, 0x211CC },
	{ 0x2A43, 0x211C9 },
	{ 0x2A44, 0x212B4 },
	{ 0x2A45, 0x212AC },
	{ 0x2A46, 0x21288 },
	{ 0x2A47, 0x21286 },
	{ 0x2A48, 0x2128C },
	{ 0x2A49, 0x21293 },
	{ 0x2A4A, 0x2128A },
	{ 0x2A4B, 0x212A4 },
	{ 0x2A4C, 0x21287 },
	{ 0x2A4D, 0x212A5 },
	{ 0x2A4E, 0x212A6 },
	{ 0x2A4F, 0x21285 },
	{ 0x2A50, 0x212A3 },
	{ 0x2A51, 0x2128E },
	{ 0x2A52, 0x2151F },
	{ 0x2A53, 0x21563 },
	{ 0x2A54, 0x2158D },
	{ 0x2A55, 0x215FA },
	{ 0x2A56, 0x215FB },
	{ 0x2A57, 0x21609 },
	{ 0x2A58, 0x215FE },
	{ 0x2A59, 0x215FF },
	{ 0x2A5A, 0x21602 },
	{ 0x2A5B, 0x21604 },
	{ 0x2A5C, 0x215FD },
	{ 0x2A5D, 0x21605 },
	{ 0x2A5E, 0x216F9 },
	{ 0x2A5F, 0x216F7 },
	{ 0x2A60, 0x216DB },
	{ 0x2A61, 0x216DA },
	{ 0x2A62, 0x21951 },
	{ 0x2A63, 0x21950 },
	{ 0x2A64, 0x21957 },
	{ 0x2A65, 0x219E2 },
	{ 0x2A66, 0x219D8 },
	{ 0x2A67, 0x219DA },
	{ 0x2A68, 0x219DC },
	{ 0x2A69, 0x21B20 },
	{ 0x2A6A, 0x21B1F },
	{ 0x2A6B, 0x21B69 },
	{ 0x2A6C, 0x21BDD },
	{ 0x2A6D, 0x21C40 },
	{ 0x2A6E, 0x21C41 },
	{ 0x2A6F, 0x21C43 },
	{ 0x2A70, 0x21D0D },
	{ 0x2A71, 0x21D0C },
	{ 0x2A72, 0x21D87 },
	{ 0x2A73, 0x21DA9 },
	{ 0x2A74, 0x21D92 },
	{ 0x2A75, 0x21D85 },
	{ 0x2A76, 0x37BF },
	{ 0x2A77, 0x21D8C },
	{ 0x2A78, 0x21DA2 },
	{ 0x2A79, 0x21D8F },
	{ 0x2A7A, 0x21D8A },
	{ 0x2A7B, 0x37BA },
	{ 0x2A7C, 0x21D8D },
	{ 0x2A7D, 0x21FF1 },
	{ 0x2A7E, 0x22037 },
	{ 0x2B21, 0x2208B },
	{ 0x2B22, 0x22087 },
	{ 0x2B23, 0x22082 },
	{ 0x2B24, 0x2218E },
	{ 0x2B25, 0x221BC },
	{ 0x2B26, 0x221F8 },
	{ 0x2B27, 0x221FA },
	{ 0x2B28, 0x221EB },
	{ 0x2B29, 0x221F9 },
	{ 0x2B2A, 0x221FC },
	{ 0x2B2B, 0x22205 },
	{ 0x2B2C, 0x2231B },
	{ 0x2B2D, 0x2231D },
	{ 0x2B2E, 0x2231E },
	{ 0x2B2F, 0x2F892 },
	{ 0x2B30, 0x2233C },
	{ 0x2B31, 0x2233E },
	{ 0x2B32, 0x22384 },
	{ 0x2B33, 0x223C8 },
	{ 0x2B34, 0x223C9 },
	{ 0x2B35, 0x223D3 },
	{ 0x2B36, 0x223C7 },
	{ 0x2B37, 0x223D2 },
	{ 0x2B38, 0x22455 },
	{ 0x2B39, 0x2F896 },
	{ 0x2B3A, 0x2248C },
	{ 0x2B3B, 0x2248A },
	{ 0x2B3C, 0x224D5 },
	{ 0x2B3D, 0x224D3 },
	{ 0x2B3E, 0x38D8 },
	{ 0x2B3F, 0x224D8 },
	{ 0x2B40, 0x225D0 },
	{ 0x2B41, 0x225EE },
	{ 0x2B42, 0x225F1 },
	{ 0x2B43, 0x225FB },
	{ 0x2B44, 0x225D3 },
	{ 0x2B45, 0x225EC },
	{ 0x2B46, 0x225CD },
	{ 0x2B47, 0x22615 },
	{ 0x2B48, 0x22626 },
	{ 0x2B49, 0x2260E },
	{ 0x2B4A, 0x22627 },
	{ 0x2B4B, 0x2262A },
	{ 0x2B4C, 0x22600 },
	{ 0x2B4D, 0x22604 },
	{ 0x2B4E, 0x22628 },
	{ 0x2B4F, 0x22608 },
	{ 0x2B50, 0x22614 },
	{ 0x2B51, 0x2299B },
	{ 0x2B52, 0x39B2 },
	{ 0x2B53, 0x229A1 },
	{ 0x2B54, 0x2299D },
	{ 0x2B55, 0x229A0 },
	{ 0x2B56, 0x2299E },
	{ 0x2B57, 0x229A2 },
	{ 0x2B58, 0x2299C },
	{ 0x2B59, 0x22A32 },
	{ 0x2B5A, 0x22A34 },
	{ 0x2B5B, 0x22A93 },
	{ 0x2B5C, 0x22A96 },
	{ 0x2B5D, 0x22A90 },
	{ 0x2B5E, 0x22AB4 },
	{ 0x2B5F, 0x22AB5 },
	{ 0x2B60, 0x2F8B6 },
	{ 0x2B61, 0x22AB6 },
	{ 0x2B62, 0x22AC2 },
	{ 0x2B63, 0x2F8B5 },
	{ 0x2B64, 0x22ABA },
	{ 0x2B65, 0x22A92 },
	{ 0x2B66, 0x22EFB },
	{ 0x2B67, 0x22F05 },
	{ 0x2B68, 0x22EF3 },
	{ 0x2B69, 0x22EFE },
	{ 0x2B6A, 0x22EFD },
	{ 0x2B6B, 0x2455D },
	{ 0x2B6C, 0x22EFA },
	{ 0x2B6D, 0x23043 },
	{ 0x2B6E, 0x23095 },
	{ 0x2B6F, 0x23094 },
	{ 0x2B70, 0x3AC4 },
	{ 0x2B71, 0x2316F },
	{ 0x2B72, 0x23173 },
	{ 0x2B73, 0x2315C },
	{ 0x2B74, 0x2315B },
	{ 0x2B75, 0x23166 },
	{ 0x2B76, 0x23174 },
	{ 0x2B77, 0x23163 },
	{ 0x2B78, 0x23167 },
	{ 0x2B79, 0x23160 },
	{ 0x2B7A, 0x23162 },
	{ 0x2B7B, 0x23171 },
	{ 0x2B7C, 0x23172 },
	{ 0x2B7D, 0x2315E },
	{ 0x2B7E, 0x23323 },
	{ 0x2C21, 0x23326 },
	{ 0x2C22, 0x23364 },
	{ 0x2C23, 0x2F8D6 },
	{ 0x2C24, 0x233F2 },
	{ 0x2C25, 0x23401 },
	{ 0x2C26, 0x233DD },
	{ 0x2C27, 0x233DC },
	{ 0x2C28, 0x233DB },
	{ 0x2C29, 0x233F3 },
	{ 0x2C2A, 0x233FD },
	{ 0x2C2B, 0x233D8 },
	{ 0x2C2C, 0x233F8 },
	{ 0x2C2D, 0x233FB },
	{ 0x2C2E, 0x23883 },
	{ 0x2C2F, 0x2388C },
	{ 0x2C30, 0x2388E },
	{ 0x2C31, 0x23949 },
	{ 0x2C32, 0x23954 },
	{ 0x2C33, 0x23952 },
	{ 0x2C34, 0x2394E },
	{ 0x2C35, 0x23958 },
	{ 0x2C36, 0x23951 },
	{ 0x2C37, 0x23955 },
	{ 0x2C38, 0x23953 },
	{ 0x2C39, 0x23957 },
	{ 0x2C3A, 0x23950 },
	{ 0x2C3B, 0x2394F },
	{ 0x2C3C, 0x2394D },
	{ 0x2C3D, 0x239D2 },
	{ 0x2C3E, 0x239D3 },
	{ 0x2C3F, 0x239C9 },
	{ 0x2C40, 0x239D4 },
	{ 0x2C41, 0x23AEF },
	{ 0x2C42, 0x2F8F8 },
	{ 0x2C43, 0x200B1 },
	{ 0x2C44, 0x23B05 },
	{ 0x2C45, 0x23B04 },
	{ 0x2C46, 0x23B2E },
	{ 0x2C47, 0x23B2D },
	{ 0x2C48, 0x23C45 },
	{ 0x2C49, 0x23C5B },
	{ 0x2C4A, 0x23C5A },
	{ 0x2C4B, 0x23C59 },
	{ 0x2C4C, 0x23C9D },
	{ 0x2C4D, 0x23C8E },
	{ 0x2C4E, 0x23CBC },
	{ 0x2C4F, 0x23CDD },
	{ 0x2C50, 0x23CBA },
	{ 0x2C51, 0x2F8FD },
	{ 0x2C52, 0x23CD8 },
	{ 0x2C53, 0x23CCB },
	{ 0x2C54, 0x23CD9 },
	{ 0x2C55, 0x23CDA },
	{ 0x2C56, 0x23CC4 },
	{ 0x2C57, 0x23CB8 },
	{ 0x2C58, 0x23CBF },
	{ 0x2C59, 0x23CDB },
	{ 0x2C5A, 0x23CC1 },
	{ 0x2C5B, 0x2F8FC },
	{ 0x2C5C, 0x23CC5 },
	{ 0x2C5D, 0x2F919 },
	{ 0x2C5E, 0x241B1 },
	{ 0x2C5F, 0x241AF },
	{ 0x2C60, 0x2F918 },
	{ 0x2C61, 0x244F7 },
	{ 0x2C62, 0x244F6 },
	{ 0x2C63, 0x244F8 },
	{ 0x2C64, 0x24550 },
	{ 0x2C65, 0x24551 },
	{ 0x2C66, 0x24571 },
	{ 0x2C67, 0x24570 },
	{ 0x2C68, 0x245B0 },
	{ 0x2C69, 0x245AF },
	{ 0x2C6A, 0x245AE },
	{ 0x2C6B, 0x245AD },
	{ 0x2C6C, 0x24625 },
	{ 0x2C6D, 0x2462C },
	{ 0x2C6E, 0x24622 },
	{ 0x2C6F, 0x24633 },
	{ 0x2C70, 0x24634 },
	{ 0x2C71, 0x3E2B },
	{ 0x2C72, 0x2473A },
	{ 0x2C73, 0x24740 },
	{ 0x2C74, 0x24768 },
	{ 0x2C75, 0x3E61 },
	{ 0x2C76, 0x24764 },
	{ 0x2C77, 0x2475C },
	{ 0x2C78, 0x24757 },
	{ 0x2C79, 0x24753 },
	{ 0x2C7A, 0x2474F },
	{ 0x2C7B, 0x24751 },
	{ 0x2C7C, 0x24754 },
	{ 0x2C7D, 0x24766 },
	{ 0x2C7E, 0x72DD },
	{ 0x2D21, 0x3EB2 },
	{ 0x2D22, 0x2490D },
	{ 0x2D23, 0x24908 },
	{ 0x2D24, 0x2F92B },
	{ 0x2D25, 0x248FA },
	{ 0x2D26, 0x24AEA },
	{ 0x2D27, 0x24B2A },
	{ 0x2D28, 0x24BBB },
	{ 0x2D29, 0x24BD5 },
	{ 0x2D2A, 0x24BD7 },
	{ 0x2D2B, 0x21DA4 },
	{ 0x2D2C, 0x200F0 },
	{ 0x2D2D, 0x200B5 },
	{ 0x2D2E, 0x24C06 },
	{ 0x2D2F, 0x24C28 },
	{ 0x2D30, 0x24C22 },
	{ 0x2D31, 0x24C21 },
	{ 0x2D32, 0x22456 },
	{ 0x2D33, 0x24C23 },
	{ 0x2D34, 0x211CD },
	{ 0x2D35, 0x24D30 },
	{ 0x2D36, 0x24D34 },
	{ 0x2D37, 0x24FC9 },
	{ 0x2D38, 0x24FCA },
	{ 0x2D39, 0x24FC8 },
	{ 0x2D3A, 0x2F93D },
	{ 0x2D3B, 0x25044 },
	{ 0x2D3C, 0x250F3 },
	{ 0x2D3D, 0x2F941 },
	{ 0x2D3E, 0x250F8 },
	{ 0x2D3F, 0x250FC },
	{ 0x2D40, 0x250F6 },
	{ 0x2D41, 0x250FB },
	{ 0x2D42, 0x250F7 },
	{ 0x2D43, 0x25100 },
	{ 0x2D44, 0x25102 },
	{ 0x2D45, 0x2F940 },
	{ 0x2D46, 0x2F94D },
	{ 0x2D47, 0x25424 },
	{ 0x2D48, 0x2560D },
	{ 0x2D49, 0x4129 },
	{ 0x2D4A, 0x25762 },
	{ 0x2D4B, 0x25930 },
	{ 0x2D4C, 0x2592B },
	{ 0x2D4D, 0x2592A },
	{ 0x2D4E, 0x4192 },
	{ 0x2D4F, 0x2592D },
	{ 0x2D50, 0x25ADA },
	{ 0x2D51, 0x25E28 },
	{ 0x2D52, 0x25F86 },
	{ 0x2D53, 0x26277 },
	{ 0x2D54, 0x2627C },
	{ 0x2D55, 0x26350 },
	{ 0x2D56, 0x2634E },
	{ 0x2D57, 0x263F2 },
	{ 0x2D58, 0x264B2 },
	{ 0x2D59, 0x264CE },
	{ 0x2D5A, 0x264CF },
	{ 0x2D5B, 0x264E5 },
	{ 0x2D5C, 0x23407 },
	{ 0x2D5D, 0x26535 },
	{ 0x2D5E, 0x26531 },
	{ 0x2D5F, 0x26613 },
	{ 0x2D60, 0x2662B },
	{ 0x2D61, 0x2662C },
	{ 0x2D62, 0x26645 },
	{ 0x2D63, 0x26660 },
	{ 0x2D64, 0x26641 },
	{ 0x2D65, 0x26658 },
	{ 0x2D66, 0x26647 },
	{ 0x2D67, 0x2665B },
	{ 0x2D68, 0x26650 },
	{ 0x2D69, 0x2F982 },
	{ 0x2D6A, 0x2665F },
	{ 0x2D6B, 0x2664A },
	{ 0x2D6C, 0x26656 },
	{ 0x2D6D, 0x26643 },
	{ 0x2D6E, 0x26644 },
	{ 0x2D6F, 0x26651 },
	{ 0x2D70, 0x268FD },
	{ 0x2D71, 0x26934 },
	{ 0x2D72, 0x26935 },
	{ 0x2D73, 0x26954 },
	{ 0x2D74, 0x26955 },
	{ 0x2D75, 0x26A0C },
	{ 0x2D76, 0x26A0B },
	{ 0x2D77, 0x26A0A },
	{ 0x2D78, 0x26AF9 },
	{ 0x2D79, 0x26B35 },
	{ 0x2D7A, 0x26B24 },
	{ 0x2D7B, 0x26B13 },
	{ 0x2D7C, 0x26B1C },
	{ 0x2D7D, 0x26B69 },
	{ 0x2D7E, 0x26B25 },
	{ 0x2E21, 0x26B21 },
	{ 0x2E22, 0x2F995 },
	{ 0x2E23, 0x2F996 },
	{ 0x2E24, 0x2F998 },
	{ 0x2E25, 0x27220 },
	{ 0x2E26, 0x275A9 },
	{ 0x2E27, 0x275A8 },
	{ 0x2E28, 0x275DE },
	{ 0x2E29, 0x27609 },
	{ 0x2E2A, 0x2760A },
	{ 0x2E2B, 0x2760B },
	{ 0x2E2C, 0x277E3 },
	{ 0x2E2D, 0x27807 },
	{ 0x2E2E, 0x278B2 },
	{ 0x2E2F, 0x278B3 },
	{ 0x2E30, 0x2795D },
	{ 0x2E31, 0x27E58 },
	{ 0x2E32, 0x27E86 },
	{ 0x2E33, 0x27E87 },
	{ 0x2E34, 0x27FB9 },
	{ 0x2E35, 0x27FB8 },
	{ 0x2E36, 0x2840C },
	{ 0x2E37, 0x28444 },
	{ 0x2E38, 0x28466 },
	{ 0x2E39, 0x28480 },
	{ 0x2E3A, 0x28475 },
	{ 0x2E3B, 0x2846D },
	{ 0x2E3C, 0x2847E },
	{ 0x2E3D, 0x28467 },
	{ 0x2E3E, 0x28481 },
	{ 0x2E3F, 0x28477 },
	{ 0x2E40, 0x286A8 },
	{ 0x2E41, 0x286A2 },
	{ 0x2E42, 0x286A5 },
	{ 0x2E43, 0x2869B },
	{ 0x2E44, 0x28C57 },
	{ 0x2E45, 0x28E0F },
	{ 0x2E46, 0x28E32 },
	{ 0x2E47, 0x28E2C },
	{ 0x2E48, 0x28E33 },
	{ 0x2E49, 0x291E7 },
	{ 0x2E4A, 0x2006E },
	{ 0x2E4B, 0x200B7 },
	{ 0x2E4C, 0x200F6 },
	{ 0x2E4D, 0x200F2 },
	{ 0x2E4E, 0x200F3 },
	{ 0x2E4F, 0x20517 },
	{ 0x2E50, 0x20130 },
	{ 0x2E51, 0x20154 },
	{ 0x2E52, 0x20153 },
	{ 0x2E53, 0x20252 },
	{ 0x2E54, 0x2023D },
	{ 0x2E55, 0x2023C },
	{ 0x2E56, 0x20234 },
	{ 0x2E57, 0x20233 },
	{ 0x2E58, 0x20254 },
	{ 0x2E59, 0x2022F },
	{ 0x2E5A, 0x3458 },
	{ 0x2E5B, 0x20255 },
	{ 0x2E5C, 0x2023F },
	{ 0x2E5D, 0x20237 },
	{ 0x2E5E, 0x20256 },
	{ 0x2E5F, 0x20261 },
	{ 0x2E60, 0x20258 },
	{ 0x2E61, 0x2F806 },
	{ 0x2E62, 0x2023B },
	{ 0x2E63, 0x20232 },
	{ 0x2E64, 0x2022E },
	{ 0x2E65, 0x2023E },
	{ 0x2E66, 0x2003B },
	{ 0x2E67, 0x2048C },
	{ 0x2E68, 0x2048D },
	{ 0x2E69, 0x20513 },
	{ 0x2E6A, 0x20516 },
	{ 0x2E6B, 0x20512 },
	{ 0x2E6C, 0x2055B },
	{ 0x2E6D, 0x2058A },
	{ 0x2E6E, 0x205D7 },
	{ 0x2E6F, 0x205CE },
	{ 0x2E70, 0x20650 },
	{ 0x2E71, 0x20651 },
	{ 0x2E72, 0x2064F },
	{ 0x2E73, 0x2068E },
	{ 0x2E74, 0x2068F },
	{ 0x2E75, 0x206F2 },
	{ 0x2E76, 0x2F821 },
	{ 0x2E77, 0x20728 },
	{ 0x2E78, 0x2071A },
	{ 0x2E79, 0x20725 },
	{ 0x2E7A, 0x2071D },
	{ 0x2E7B, 0x20714 },
	{ 0x2E7C, 0x20720 },
	{ 0x2E7D, 0x2071F },
	{ 0x2E7E, 0x2071B },
	{ 0x2F21, 0x20717 },
	{ 0x2F22, 0x20715 },
	{ 0x2F23, 0x2071C },
	{ 0x2F24, 0x20713 },
	{ 0x2F25, 0x2F825 },
	{ 0x2F26, 0x20860 },
	{ 0x2F27, 0x351C },
	{ 0x2F28, 0x20866 },
	{ 0x2F29, 0x208E3 },
	{ 0x2F2A, 0x208DE },
	{ 0x2F2B, 0x208E0 },
	{ 0x2F2C, 0x208E1 },
	{ 0x2F2D, 0x2091A },
	{ 0x2F2E, 0x2091B },
	{ 0x2F2F, 0x20918 },
	{ 0x2F30, 0x2091C },
	{ 0x2F31, 0x20919 },
	{ 0x2F32, 0x20942 },
	{ 0x2F33, 0x20940 },
	{ 0x2F34, 0x2093E },
	{ 0x2F35, 0x20944 },
	{ 0x2F36, 0x20974 },
	{ 0x2F37, 0x20943 },
	{ 0x2F38, 0x2F82D },
	{ 0x2F39, 0x209F2 },
	{ 0x2F3A, 0x20A1B },
	{ 0x2F3B, 0x20A19 },
	{ 0x2F3C, 0x20A1E },
	{ 0x2F3D, 0x2F830 },
	{ 0x2F3E, 0x20A5E },
	{ 0x2F3F, 0x20A66 },
	{ 0x2F40, 0x20A5D },
	{ 0x2F41, 0x20A5A },
	{ 0x2F42, 0x20A5F },
	{ 0x2F43, 0x20A60 },
	{ 0x2F44, 0x20A5B },
	{ 0x2F45, 0x20A5C },
	{ 0x2F46, 0x20A59 },
	{ 0x2F47, 0x20AF0 },
	{ 0x2F48, 0x20AF1 },
	{ 0x2F49, 0x20B43 },
	{ 0x2F4A, 0x20B40 },
	{ 0x2F4B, 0x20B42 },
	{ 0x2F4C, 0x20B41 },
	{ 0x2F4D, 0x20B3F },
	{ 0x2F4E, 0x20C57 },
	{ 0x2F4F, 0x20C69 },
	{ 0x2F50, 0x20C6F },
	{ 0x2F51, 0x20CAB },
	{ 0x2F52, 0x20C71 },
	{ 0x2F53, 0x20C93 },
	{ 0x2F54, 0x20C56 },
	{ 0x2F55, 0x20C90 },
	{ 0x2F56, 0x20C6D },
	{ 0x2F57, 0x20C6C },
	{ 0x2F58, 0x20C70 },
	{ 0x2F59, 0x20C66 },
	{ 0x2F5A, 0x20C67 },
	{ 0x2F5B, 0x211D7 },
	{ 0x2F5C, 0x211B5 },
	{ 0x2F5D, 0x211DB },
	{ 0x2F5E, 0x211D8 },
	{ 0x2F5F, 0x211D5 },
	{ 0x2F60, 0x211D4 },
	{ 0x2F61, 0x212BA },
	{ 0x2F62, 0x212B7 },
	{ 0x2F63, 0x212BE },
	{ 0x2F64, 0x212B9 },
	{ 0x2F65, 0x3637 },
	{ 0x2F66, 0x212E0 },
	{ 0x2F67, 0x212DD },
	{ 0x2F68, 0x212DE },
	{ 0x2F69, 0x24918 },
	{ 0x2F6A, 0x212D8 },
	{ 0x2F6B, 0x212BD },
	{ 0x2F6C, 0x212DB },
	{ 0x2F6D, 0x2151D },
	{ 0x2F6E, 0x21525 },
	{ 0x2F6F, 0x21721 },
	{ 0x2F70, 0x2170C },
	{ 0x2F71, 0x21729 },
	{ 0x2F72, 0x2172D },
	{ 0x2F73, 0x2171B },
	{ 0x2F74, 0x2170E },
	{ 0x2F75, 0x2171F },
	{ 0x2F76, 0x21704 },
	{ 0x2F77, 0x2171C },
	{ 0x2F78, 0x21705 },
	{ 0x2F79, 0x21706 },
	{ 0x2F7A, 0x21720 },
	{ 0x2F7B, 0x2170D },
	{ 0x2F7C, 0x2172A },
	{ 0x2F7D, 0x21723 },
	{ 0x2F7E, 0x21711 },
	{ 0x3021, 0x2195C },
	{ 0x3022, 0x21966 },
	{ 0x3023, 0x2195B },
	{ 0x3024, 0x2194F },
	{ 0x3025, 0x2195E },
	{ 0x3026, 0x2195D },
	{ 0x3027, 0x219F1 },
	{ 0x3028, 0x219EA },
	{ 0x3029, 0x219F4 },
	{ 0x302A, 0x219EB },
	{ 0x302B, 0x219F0 },
	{ 0x302C, 0x219FA },
	{ 0x302D, 0x219FB },
	{ 0x302E, 0x21B28 },
	{ 0x302F, 0x21B2C },
	{ 0x3030, 0x21B6B },
	{ 0x3031, 0x21B2A },
	{ 0x3032, 0x21B6A },
	{ 0x3033, 0x21B6F },
	{ 0x3034, 0x21BDB },
	{ 0x3035, 0x21BE0 },
	{ 0x3036, 0x24FD1 },
	{ 0x3037, 0x21BE3 },
	{ 0x3038, 0x21BE5 },
	{ 0x3039, 0x21BE7 },
	{ 0x303A, 0x21C4D },
	{ 0x303B, 0x21C55 },
	{ 0x303C, 0x21C54 },
	{ 0x303D, 0x21C53 },
	{ 0x303E, 0x21C52 },
	{ 0x303F, 0x21C4E },
	{ 0x3040, 0x21C60 },
	{ 0x3041, 0x221C0 },
	{ 0x3042, 0x21D0F },
	{ 0x3043, 0x21D11 },
	{ 0x3044, 0x21D13 },
	{ 0x3045, 0x21DC6 },
	{ 0x3046, 0x21DB3 },
	{ 0x3047, 0x21DC7 },
	{ 0x3048, 0x21DD2 },
	{ 0x3049, 0x21DB8 },
	{ 0x304A, 0x21DAC },
	{ 0x304B, 0x21DAE },
	{ 0x304C, 0x21DCF },
	{ 0x304D, 0x21DC5 },
	{ 0x304E, 0x2F87B },
	{ 0x304F, 0x21DCC },
	{ 0x3050, 0x21DAB },
	{ 0x3051, 0x21DC9 },
	{ 0x3052, 0x21DB9 },
	{ 0x3053, 0x21FFB },
	{ 0x3054, 0x21FF8 },
	{ 0x3055, 0x21FF7 },
	{ 0x3056, 0x21FF9 },
	{ 0x3057, 0x22020 },
	{ 0x3058, 0x2203B },
	{ 0x3059, 0x22039 },
	{ 0x305A, 0x2209E },
	{ 0x305B, 0x2209A },
	{ 0x305C, 0x220AA },
	{ 0x305D, 0x220AB },
	{ 0x305E, 0x220AF },
	{ 0x305F, 0x22096 },
	{ 0x3060, 0x220A9 },
	{ 0x3061, 0x220A6 },
	{ 0x3062, 0x22091 },
	{ 0x3063, 0x3843 },
	{ 0x3064, 0x220AE },
	{ 0x3065, 0x2209F },
	{ 0x3066, 0x220AC },
	{ 0x3067, 0x220A0 },
	{ 0x3068, 0x22192 },
	{ 0x3069, 0x22191 },
	{ 0x306A, 0x221BF },
	{ 0x306B, 0x22217 },
	{ 0x306C, 0x2220A },
	{ 0x306D, 0x2220C },
	{ 0x306E, 0x2234A },
	{ 0x306F, 0x22346 },
	{ 0x3070, 0x22334 },
	{ 0x3071, 0x22345 },
	{ 0x3072, 0x22343 },
	{ 0x3073, 0x22344 },
	{ 0x3074, 0x2F893 },
	{ 0x3075, 0x22387 },
	{ 0x3076, 0x22386 },
	{ 0x3077, 0x2238A },
	{ 0x3078, 0x223DA },
	{ 0x3079, 0x223D8 },
	{ 0x307A, 0x38B4 },
	{ 0x307B, 0x20518 },
	{ 0x307C, 0x20134 },
	{ 0x307D, 0x223D6 },
	{ 0x307E, 0x223D4 },
	{ 0x3121, 0x22454 },
	{ 0x3122, 0x22459 },
	{ 0x3123, 0x2245A },
	{ 0x3124, 0x22457 },
	{ 0x3125, 0x38E0 },
	{ 0x3126, 0x224DD },
	{ 0x3127, 0x224E9 },
	{ 0x3128, 0x224E0 },
	{ 0x3129, 0x22605 },
	{ 0x312A, 0x22612 },
	{ 0x312B, 0x22613 },
	{ 0x312C, 0x22607 },
	{ 0x312D, 0x22616 },
	{ 0x312E, 0x22623 },
	{ 0x312F, 0x22602 },
	{ 0x3130, 0x2F8A1 },
	{ 0x3131, 0x2264A },
	{ 0x3132, 0x22636 },
	{ 0x3133, 0x22640 },
	{ 0x3134, 0x22656 },
	{ 0x3135, 0x22643 },
	{ 0x3136, 0x2F8A0 },
	{ 0x3137, 0x2264B },
	{ 0x3138, 0x22646 },
	{ 0x3139, 0x2263E },
	{ 0x313A, 0x22649 },
	{ 0x313B, 0x229A7 },
	{ 0x313C, 0x229B6 },
	{ 0x313D, 0x229A6 },
	{ 0x313E, 0x229A8 },
	{ 0x313F, 0x229AC },
	{ 0x3140, 0x229A9 },
	{ 0x3141, 0x229AB },
	{ 0x3142, 0x22A38 },
	{ 0x3143, 0x22A37 },
	{ 0x3144, 0x22A39 },
	{ 0x3145, 0x22A41 },
	{ 0x3146, 0x22A3E },
	{ 0x3147, 0x22AC0 },
	{ 0x3148, 0x22ABB },
	{ 0x3149, 0x22ABF },
	{ 0x314A, 0x22ABD },
	{ 0x314B, 0x22AFE },
	{ 0x314C, 0x22B1E },
	{ 0x314D, 0x22AEE },
	{ 0x314E, 0x22AFC },
	{ 0x314F, 0x2F8B7 },
	{ 0x3150, 0x22AF9 },
	{ 0x3151, 0x22B06 },
	{ 0x3152, 0x22AE4 },
	{ 0x3153, 0x22AE9 },
	{ 0x3154, 0x22AE5 },
	{ 0x3155, 0x22B03 },
	{ 0x3156, 0x22AFD },
	{ 0x3157, 0x22B49 },
	{ 0x3158, 0x22EBE },
	{ 0x3159, 0x22F0A },
	{ 0x315A, 0x25626 },
	{ 0x315B, 0x22F18 },
	{ 0x315C, 0x22F0D },
	{ 0x315D, 0x22F0F },
	{ 0x315E, 0x22F0E },
	{ 0x315F, 0x22F20 },
	{ 0x3160, 0x23071 },
	{ 0x3161, 0x23099 },
	{ 0x3162, 0x230E2 },
	{ 0x3163, 0x230DF },
	{ 0x3164, 0x230DE },
	{ 0x3165, 0x23178 },
	{ 0x3166, 0x23179 },
	{ 0x3167, 0x3AE4 },
	{ 0x3168, 0x2317C },
	{ 0x3169, 0x2317D },
	{ 0x316A, 0x23184 },
	{ 0x316B, 0x2318B },
	{ 0x316C, 0x2318A },
	{ 0x316D, 0x2F8D2 },
	{ 0x316E, 0x23189 },
	{ 0x316F, 0x2332C },
	{ 0x3170, 0x23329 },
	{ 0x3171, 0x2336C },
	{ 0x3172, 0x6804 },
	{ 0x3173, 0x23409 },
	{ 0x3174, 0x23408 },
	{ 0x3175, 0x2340C },
	{ 0x3176, 0x2340D },
	{ 0x3177, 0x23410 },
	{ 0x3178, 0x3C26 },
	{ 0x3179, 0x2389F },
	{ 0x317A, 0x23898 },
	{ 0x317B, 0x238A2 },
	{ 0x317C, 0x2389A },
	{ 0x317D, 0x239D5 },
	{ 0x317E, 0x239E2 },
	{ 0x3221, 0x239F0 },
	{ 0x3222, 0x239EA },
	{ 0x3223, 0x239EB },
	{ 0x3224, 0x239ED },
	{ 0x3225, 0x239E8 },
	{ 0x3226, 0x239E0 },
	{ 0x3227, 0x23A85 },
	{ 0x3228, 0x23A86 },
	{ 0x3229, 0x23AF0 },
	{ 0x322A, 0x21E46 },
	{ 0x322B, 0x23B45 },
	{ 0x322C, 0x23B38 },
	{ 0x322D, 0x23B3E },
	{ 0x322E, 0x23B42 },
	{ 0x322F, 0x23B40 },
	{ 0x3230, 0x23C47 },
	{ 0x3231, 0x23C5C },
	{ 0x3232, 0x23C5E },
	{ 0x3233, 0x23CB4 },
	{ 0x3234, 0x23CC2 },
	{ 0x3235, 0x23D14 },
	{ 0x3236, 0x23CE5 },
	{ 0x3237, 0x23D15 },
	{ 0x3238, 0x23D11 },
	{ 0x3239, 0x2F8FF },
	{ 0x323A, 0x23CEE },
	{ 0x323B, 0x23CE7 },
	{ 0x323C, 0x23CF5 },
	{ 0x323D, 0x23CF4 },
	{ 0x323E, 0x23CE8 },
	{ 0x323F, 0x23D01 },
	{ 0x3240, 0x23CEF },
	{ 0x3241, 0x23CF1 },
	{ 0x3242, 0x2F900 },
	{ 0x3243, 0x241DB },
	{ 0x3244, 0x241BF },
	{ 0x3245, 0x241DA },
	{ 0x3246, 0x241C7 },
	{ 0x3247, 0x241DD },
	{ 0x3248, 0x2F91A },
	{ 0x3249, 0x241EB },
	{ 0x324A, 0x241E1 },
	{ 0x324B, 0x241C1 },
	{ 0x324C, 0x241BD },
	{ 0x324D, 0x24507 },
	{ 0x324E, 0x244FD },
	{ 0x324F, 0x24501 },
	{ 0x3250, 0x2450A },
	{ 0x3251, 0x24503 },
	{ 0x3252, 0x24572 },
	{ 0x3253, 0x24574 },
	{ 0x3254, 0x24575 },
	{ 0x3255, 0x245B2 },
	{ 0x3256, 0x245B1 },
	{ 0x3257, 0x245B4 },
	{ 0x3258, 0x2464C },
	{ 0x3259, 0x24642 },
	{ 0x325A, 0x24640 },
	{ 0x325B, 0x24649 },
	{ 0x325C, 0x2463C },
	{ 0x325D, 0x2464D },
	{ 0x325E, 0x2464A },
	{ 0x325F, 0x2463B },
	{ 0x3260, 0x24761 },
	{ 0x3261, 0x24774 },
	{ 0x3262, 0x2F926 },
	{ 0x3263, 0x2477F },
	{ 0x3264, 0x2477A },
	{ 0x3265, 0x24788 },
	{ 0x3266, 0x2477C },
	{ 0x3267, 0x3E6F },
	{ 0x3268, 0x24770 },
	{ 0x3269, 0x2490F },
	{ 0x326A, 0x24928 },
	{ 0x326B, 0x24913 },
	{ 0x326C, 0x2492A },
	{ 0x326D, 0x24AED },
	{ 0x326E, 0x24AEF },
	{ 0x326F, 0x24B2E },
	{ 0x3270, 0x24BC1 },
	{ 0x3271, 0x24BDD },
	{ 0x3272, 0x20B47 },
	{ 0x3273, 0x24C2D },
	{ 0x3274, 0x24C2B },
	{ 0x3275, 0x24C35 },
	{ 0x3276, 0x24C2F },
	{ 0x3277, 0x24C31 },
	{ 0x3278, 0x24C34 },
	{ 0x3279, 0x2F935 },
	{ 0x327A, 0x24C30 },
	{ 0x327B, 0x24D3A },
	{ 0x327C, 0x24D39 },
	{ 0x327D, 0x24D37 },
	{ 0x327E, 0x24D4B },
	{ 0x3321, 0x24D54 },
	{ 0x3322, 0x24D4D },
	{ 0x3323, 0x24D51 },
	{ 0x3324, 0x24D47 },
	{ 0x3325, 0x24F27 },
	{ 0x3326, 0x24F50 },
	{ 0x3327, 0x24F4D },
	{ 0x3328, 0x24F4E },
	{ 0x3329, 0x24F54 },
	{ 0x332A, 0x24FD2 },
	{ 0x332B, 0x24FCE },
	{ 0x332C, 0x2504B },
	{ 0x332D, 0x25049 },
	{ 0x332E, 0x25105 },
	{ 0x332F, 0x2510F },
	{ 0x3330, 0x25119 },
	{ 0x3331, 0x2F943 },
	{ 0x3332, 0x25106 },
	{ 0x3333, 0x2510C },
	{ 0x3334, 0x25129 },
	{ 0x3335, 0x25104 },
	{ 0x3336, 0x25108 },
	{ 0x3337, 0x25125 },
	{ 0x3338, 0x401C },
	{ 0x3339, 0x25103 },
	{ 0x333A, 0x25127 },
	{ 0x333B, 0x25110 },
	{ 0x333C, 0x2510A },
	{ 0x333D, 0x2F942 },
	{ 0x333E, 0x26B5D },
	{ 0x333F, 0x253AA },
	{ 0x3340, 0x253AB },
	{ 0x3341, 0x253A9 },
	{ 0x3342, 0x25441 },
	{ 0x3343, 0x2543A },
	{ 0x3344, 0x2543C },
	{ 0x3345, 0x2542B },
	{ 0x3346, 0x25449 },
	{ 0x3347, 0x25615 },
	{ 0x3348, 0x4100 },
	{ 0x3349, 0x25616 },
	{ 0x334A, 0x2F953 },
	{ 0x334B, 0x25631 },
	{ 0x334C, 0x23C4A },
	{ 0x334D, 0x2573C },
	{ 0x334E, 0x2577C },
	{ 0x334F, 0x2576D },
	{ 0x3350, 0x2576A },
	{ 0x3351, 0x25763 },
	{ 0x3352, 0x2576B },
	{ 0x3353, 0x2577B },
	{ 0x3354, 0x25764 },
	{ 0x3355, 0x2577A },
	{ 0x3356, 0x25769 },
	{ 0x3357, 0x2576F },
	{ 0x3358, 0x25937 },
	{ 0x3359, 0x25935 },
	{ 0x335A, 0x2593C },
	{ 0x335B, 0x25936 },
	{ 0x335C, 0x2593D },
	{ 0x335D, 0x2593E },
	{ 0x335E, 0x25AE1 },
	{ 0x335F, 0x25AE0 },
	{ 0x3360, 0x25E2D },
	{ 0x3361, 0x25E2B },
	{ 0x3362, 0x25F8D },
	{ 0x3363, 0x25F92 },
	{ 0x3364, 0x42B6 },
	{ 0x3365, 0x25F8E },
	{ 0x3366, 0x2F96B },
	{ 0x3367, 0x25F91 },
	{ 0x3368, 0x25F96 },
	{ 0x3369, 0x2627B },
	{ 0x336A, 0x26278 },
	{ 0x336B, 0x26281 },
	{ 0x336C, 0x26296 },
	{ 0x336D, 0x262A3 },
	{ 0x336E, 0x26295 },
	{ 0x336F, 0x26297 },
	{ 0x3370, 0x26354 },
	{ 0x3371, 0x26352 },
	{ 0x3372, 0x263F5 },
	{ 0x3373, 0x26400 },
	{ 0x3374, 0x263FB },
	{ 0x3375, 0x263F4 },
	{ 0x3376, 0x263F6 },
	{ 0x3377, 0x264E8 },
	{ 0x3378, 0x264EA },
	{ 0x3379, 0x2663E },
	{ 0x337A, 0x2663D },
	{ 0x337B, 0x2663B },
	{ 0x337C, 0x26680 },
	{ 0x337D, 0x43E4 },
	{ 0x337E, 0x26688 },
	{ 0x3421, 0x26681 },
	{ 0x3422, 0x26682 },
	{ 0x3423, 0x266CE },
	{ 0x3424, 0x26683 },
	{ 0x3425, 0x26677 },
	{ 0x3426, 0x26679 },
	{ 0x3427, 0x26673 },
	{ 0x3428, 0x2666D },
	{ 0x3429, 0x26670 },
	{ 0x342A, 0x2668D },
	{ 0x342B, 0x26675 },
	{ 0x342C, 0x2668C },
	{ 0x342D, 0x2666A },
	{ 0x342E, 0x26691 },
	{ 0x342F, 0x26689 },
	{ 0x3430, 0x2668E },
	{ 0x3431, 0x212DC },
	{ 0x3432, 0x268FF },
	{ 0x3433, 0x26959 },
	{ 0x3434, 0x269C7 },
	{ 0x3435, 0x26A12 },
	{ 0x3436, 0x26A14 },
	{ 0x3437, 0x26A13 },
	{ 0x3438, 0x26ACB },
	{ 0x3439, 0x26B42 },
	{ 0x343A, 0x44AD },
	{ 0x343B, 0x26B3D },
	{ 0x343C, 0x82FF },
	{ 0x343D, 0x26B40 },
	{ 0x343E, 0x26B44 },
	{ 0x343F, 0x26B62 },
	{ 0x3440, 0x26B43 },
	{ 0x3441, 0x26B3F },
	{ 0x3442, 0x26B45 },
	{ 0x3443, 0x26B3C },
	{ 0x3444, 0x2F997 },
	{ 0x3445, 0x26B46 },
	{ 0x3446, 0x26B47 },
	{ 0x3447, 0x2F9B3 },
	{ 0x3448, 0x2719E },
	{ 0x3449, 0x2719D },
	{ 0x344A, 0x2722C },
	{ 0x344B, 0x27229 },
	{ 0x344C, 0x2722F },
	{ 0x344D, 0x2722E },
	{ 0x344E, 0x27230 },
	{ 0x344F, 0x275E1 },
	{ 0x3450, 0x275E2 },
	{ 0x3451, 0x2760E },
	{ 0x3452, 0x27619 },
	{ 0x3453, 0x27612 },
	{ 0x3454, 0x278B4 },
	{ 0x3455, 0x27BDA },
	{ 0x3456, 0x27D26 },
	{ 0x3457, 0x27E59 },
	{ 0x3458, 0x27E5A },
	{ 0x3459, 0x27E88 },
	{ 0x345A, 0x27FC0 },
	{ 0x345B, 0x27FBA },
	{ 0x345C, 0x282A0 },
	{ 0x345D, 0x2F9DD },
	{ 0x345E, 0x282A2 },
	{ 0x345F, 0x28486 },
	{ 0x3460, 0x8FEC },
	{ 0x3461, 0x2849D },
	{ 0x3462, 0x28488 },
	{ 0x3463, 0x2848F },
	{ 0x3464, 0x2848E },
	{ 0x3465, 0x2849B },
	{ 0x3466, 0x286C1 },
	{ 0x3467, 0x286C3 },
	{ 0x3468, 0x286C4 },
	{ 0x3469, 0x28696 },
	{ 0x346A, 0x286C7 },
	{ 0x346B, 0x286C6 },
	{ 0x346C, 0x286BF },
	{ 0x346D, 0x48C3 },
	{ 0x346E, 0x2890F },
	{ 0x346F, 0x28E55 },
	{ 0x3470, 0x28E42 },
	{ 0x3471, 0x28E46 },
	{ 0x3472, 0x28E4B },
	{ 0x3473, 0x28E43 },
	{ 0x3474, 0x28E53 },
	{ 0x3475, 0x28E48 },
	{ 0x3476, 0x28E49 },
	{ 0x3477, 0x28E4A },
	{ 0x3478, 0x28E4E },
	{ 0x3479, 0x24BDE },
	{ 0x347A, 0x20691 },
	{ 0x347B, 0x2944B },
	{ 0x347C, 0x29680 },
	{ 0x347D, 0x29681 },
	{ 0x347E, 0x29683 },
	{ 0x3521, 0x2028A },
	{ 0x3522, 0x29682 },
	{ 0x3523, 0x22342 },
	{ 0x3524, 0x20922 },
	{ 0x3525, 0x20070 },
	{ 0x3526, 0x20071 },
	{ 0x3527, 0x200BC },
	{ 0x3528, 0x21D18 },
	{ 0x3529, 0x200BE },
	{ 0x352A, 0x200BA },
	{ 0x352B, 0x200F8 },
	{ 0x352C, 0x20137 },
	{ 0x352D, 0x20135 },
	{ 0x352E, 0x20AFC },
	{ 0x352F, 0x20156 },
	{ 0x3530, 0x20159 },
	{ 0x3531, 0x2015E },
	{ 0x3532, 0x2026D },
	{ 0x3533, 0x20291 },
	{ 0x3534, 0x20292 },
	{ 0x3535, 0x20268 },
	{ 0x3536, 0x20266 },
	{ 0x3537, 0x20273 },
	{ 0x3538, 0x3467 },
	{ 0x3539, 0x20296 },
	{ 0x353A, 0x2028B },
	{ 0x353B, 0x2028C },
	{ 0x353C, 0x20496 },
	{ 0x353D, 0x204EE },
	{ 0x353E, 0x2051C },
	{ 0x353F, 0x2051A },
	{ 0x3540, 0x20519 },
	{ 0x3541, 0x2051B },
	{ 0x3542, 0x2055D },
	{ 0x3543, 0x2055E },
	{ 0x3544, 0x2F818 },
	{ 0x3545, 0x205DC },
	{ 0x3546, 0x205E2 },
	{ 0x3547, 0x20652 },
	{ 0x3548, 0x20692 },
	{ 0x3549, 0x20730 },
	{ 0x354A, 0x20752 },
	{ 0x354B, 0x20742 },
	{ 0x354C, 0x20741 },
	{ 0x354D, 0x20745 },
	{ 0x354E, 0x20737 },
	{ 0x354F, 0x20740 },
	{ 0x3550, 0x2073F },
	{ 0x3551, 0x2073D },
	{ 0x3552, 0x20738 },
	{ 0x3553, 0x2073A },
	{ 0x3554, 0x20749 },
	{ 0x3555, 0x2086B },
	{ 0x3556, 0x20878 },
	{ 0x3557, 0x20879 },
	{ 0x3558, 0x2F826 },
	{ 0x3559, 0x2086C },
	{ 0x355A, 0x208E9 },
	{ 0x355B, 0x208E6 },
	{ 0x355C, 0x208E5 },
	{ 0x355D, 0x208EA },
	{ 0x355E, 0x208E7 },
	{ 0x355F, 0x208E8 },
	{ 0x3560, 0x2091F },
	{ 0x3561, 0x2094B },
	{ 0x3562, 0x2094A },
	{ 0x3563, 0x20953 },
	{ 0x3564, 0x20976 },
	{ 0x3565, 0x209A3 },
	{ 0x3566, 0x209A4 },
	{ 0x3567, 0x209F6 },
	{ 0x3568, 0x209F3 },
	{ 0x3569, 0x209F9 },
	{ 0x356A, 0x209F7 },
	{ 0x356B, 0x209FC },
	{ 0x356C, 0x20A1D },
	{ 0x356D, 0x20A6D },
	{ 0x356E, 0x20A71 },
	{ 0x356F, 0x20A6C },
	{ 0x3570, 0x20A6E },
	{ 0x3571, 0x20A70 },
	{ 0x3572, 0x20A6F },
	{ 0x3573, 0x20A67 },
	{ 0x3574, 0x20A68 },
	{ 0x3575, 0x20AFA },
	{ 0x3576, 0x20AF9 },
	{ 0x3577, 0x20B4E },
	{ 0x3578, 0x53DE },
	{ 0x3579, 0x20B4D },
	{ 0x357A, 0x20B4F },
	{ 0x357B, 0x20B4A },
	{ 0x357C, 0x20B4C },
	{ 0x357D, 0x3596 },
	{ 0x357E, 0x2F842 },
	{ 0x3621, 0x20CEE },
	{ 0x3622, 0x20CB2 },
	{ 0x3623, 0x20CC0 },
	{ 0x3624, 0x20CC1 },
	{ 0x3625, 0x20CF4 },
	{ 0x3626, 0x20CC8 },
	{ 0x3627, 0x20CC5 },
	{ 0x3628, 0x20CC6 },
	{ 0x3629, 0x20CAD },
	{ 0x362A, 0x211E2 },
	{ 0x362B, 0x211EA },
	{ 0x362C, 0x211E3 },
	{ 0x362D, 0x211E1 },
	{ 0x362E, 0x212F7 },
	{ 0x362F, 0x21301 },
	{ 0x3630, 0x21312 },
	{ 0x3631, 0x212F6 },
	{ 0x3632, 0x212F1 },
	{ 0x3633, 0x2131F },
	{ 0x3634, 0x212EE },
	{ 0x3635, 0x2F852 },
	{ 0x3636, 0x212F3 },
	{ 0x3637, 0x21315 },
	{ 0x3638, 0x21316 },
	{ 0x3639, 0x21317 },
	{ 0x363A, 0x212F8 },
	{ 0x363B, 0x21319 },
	{ 0x363C, 0x212F2 },
	{ 0x363D, 0x212F4 },
	{ 0x363E, 0x212F5 },
	{ 0x363F, 0x21313 },
	{ 0x3640, 0x21306 },
	{ 0x3641, 0x21526 },
	{ 0x3642, 0x21524 },
	{ 0x3643, 0x2155A },
	{ 0x3644, 0x22EC8 },
	{ 0x3645, 0x21597 },
	{ 0x3646, 0x21595 },
	{ 0x3647, 0x2159A },
	{ 0x3648, 0x2161F },
	{ 0x3649, 0x20AFB },
	{ 0x364A, 0x21629 },
	{ 0x364B, 0x21620 },
	{ 0x364C, 0x2F862 },
	{ 0x364D, 0x2F863 },
	{ 0x364E, 0x2174C },
	{ 0x364F, 0x21730 },
	{ 0x3650, 0x21738 },
	{ 0x3651, 0x2173D },
	{ 0x3652, 0x21751 },
	{ 0x3653, 0x2174F },
	{ 0x3654, 0x2174A },
	{ 0x3655, 0x21734 },
	{ 0x3656, 0x21736 },
	{ 0x3657, 0x5A30 },
	{ 0x3658, 0x2196A },
	{ 0x3659, 0x21968 },
	{ 0x365A, 0x21A1C },
	{ 0x365B, 0x21A0E },
	{ 0x365C, 0x21A1E },
	{ 0x365D, 0x3759 },
	{ 0x365E, 0x21A09 },
	{ 0x365F, 0x21A08 },
	{ 0x3660, 0x21A13 },
	{ 0x3661, 0x21A01 },
	{ 0x3662, 0x21A0F },
	{ 0x3663, 0x21A14 },
	{ 0x3664, 0x21A06 },
	{ 0x3665, 0x21A07 },
	{ 0x3666, 0x5BB2 },
	{ 0x3667, 0x2F873 },
	{ 0x3668, 0x3776 },
	{ 0x3669, 0x21B79 },
	{ 0x366A, 0x21BEA },
	{ 0x366B, 0x21BED },
	{ 0x366C, 0x21BE9 },
	{ 0x366D, 0x21BEE },
	{ 0x366E, 0x21C68 },
	{ 0x366F, 0x21C64 },
	{ 0x3670, 0x21C67 },
	{ 0x3671, 0x21C72 },
	{ 0x3672, 0x21C62 },
	{ 0x3673, 0x21C74 },
	{ 0x3674, 0x21C79 },
	{ 0x3675, 0x21D19 },
	{ 0x3676, 0x21D17 },
	{ 0x3677, 0x21D15 },
	{ 0x3678, 0x21D16 },
	{ 0x3679, 0x21DE6 },
	{ 0x367A, 0x262A4 },
	{ 0x367B, 0x21DEE },
	{ 0x367C, 0x37D2 },
	{ 0x367D, 0x21DDF },
	{ 0x367E, 0x21DE4 },
	{ 0x3721, 0x21DDA },
	{ 0x3722, 0x21DEA },
	{ 0x3723, 0x21DED },
	{ 0x3724, 0x21DE3 },
	{ 0x3725, 0x21DE9 },
	{ 0x3726, 0x21FFD },
	{ 0x3727, 0x20657 },
	{ 0x3728, 0x22021 },
	{ 0x3729, 0x220C6 },
	{ 0x372A, 0x220B8 },
	{ 0x372B, 0x220CB },
	{ 0x372C, 0x2F885 },
	{ 0x372D, 0x220BD },
	{ 0x372E, 0x220B5 },
	{ 0x372F, 0x220BB },
	{ 0x3730, 0x220BF },
	{ 0x3731, 0x220BE },
	{ 0x3732, 0x220B2 },
	{ 0x3733, 0x220C1 },
	{ 0x3734, 0x220C2 },
	{ 0x3735, 0x22199 },
	{ 0x3736, 0x221C6 },
	{ 0x3737, 0x2222C },
	{ 0x3738, 0x2222D },
	{ 0x3739, 0x22225 },
	{ 0x373A, 0x2221E },
	{ 0x373B, 0x2221F },
	{ 0x373C, 0x22223 },
	{ 0x373D, 0x22350 },
	{ 0x373E, 0x2234E },
	{ 0x373F, 0x2234D },
	{ 0x3740, 0x22352 },
	{ 0x3741, 0x223E9 },
	{ 0x3742, 0x223EC },
	{ 0x3743, 0x223E8 },
	{ 0x3744, 0x22458 },
	{ 0x3745, 0x2245C },
	{ 0x3746, 0x2245B },
	{ 0x3747, 0x2248F },
	{ 0x3748, 0x23972 },
	{ 0x3749, 0x224F6 },
	{ 0x374A, 0x22500 },
	{ 0x374B, 0x224FC },
	{ 0x374C, 0x224F8 },
	{ 0x374D, 0x224EA },
	{ 0x374E, 0x224FE },
	{ 0x374F, 0x224F7 },
	{ 0x3750, 0x224FD },
	{ 0x3751, 0x22670 },
	{ 0x3752, 0x22662 },
	{ 0x3753, 0x22644 },
	{ 0x3754, 0x3920 },
	{ 0x3755, 0x2264D },
	{ 0x3756, 0x2264C },
	{ 0x3757, 0x2263F },
	{ 0x3758, 0x22666 },
	{ 0x3759, 0x22635 },
	{ 0x375A, 0x3929 },
	{ 0x375B, 0x22634 },
	{ 0x375C, 0x2268D },
	{ 0x375D, 0x22684 },
	{ 0x375E, 0x3938 },
	{ 0x375F, 0x22686 },
	{ 0x3760, 0x22689 },
	{ 0x3761, 0x22687 },
	{ 0x3762, 0x22683 },
	{ 0x3763, 0x22675 },
	{ 0x3764, 0x22679 },
	{ 0x3765, 0x226AF },
	{ 0x3766, 0x226B0 },
	{ 0x3767, 0x229B7 },
	{ 0x3768, 0x229BB },
	{ 0x3769, 0x229B9 },
	{ 0x376A, 0x22A46 },
	{ 0x376B, 0x22A47 },
	{ 0x376C, 0x22A45 },
	{ 0x376D, 0x22AEA },
	{ 0x376E, 0x22AF6 },
	{ 0x376F, 0x22B68 },
	{ 0x3770, 0x22B39 },
	{ 0x3771, 0x2F8B9 },
	{ 0x3772, 0x22B3D },
	{ 0x3773, 0x22B3B },
	{ 0x3774, 0x22B4D },
	{ 0x3775, 0x22B30 },
	{ 0x3776, 0x22B4A },
	{ 0x3777, 0x22B3E },
	{ 0x3778, 0x22B40 },
	{ 0x3779, 0x22B4C },
	{ 0x377A, 0x22B47 },
	{ 0x377B, 0x22B38 },
	{ 0x377C, 0x22B52 },
	{ 0x377D, 0x22B3A },
	{ 0x377E, 0x22B53 },
	{ 0x3821, 0x22EC4 },
	{ 0x3822, 0x22EC1 },
	{ 0x3823, 0x22F1C },
	{ 0x3824, 0x22F1D },
	{ 0x3825, 0x22F2A },
	{ 0x3826, 0x22F1E },
	{ 0x3827, 0x22F2F },
	{ 0x3828, 0x22F22 },
	{ 0x3829, 0x22F2E },
	{ 0x382A, 0x22F25 },
	{ 0x382B, 0x3A89 },
	{ 0x382C, 0x3AB0 },
	{ 0x382D, 0x2304A },
	{ 0x382E, 0x2304B },
	{ 0x382F, 0x23076 },
	{ 0x3830, 0x3ABF },
	{ 0x3831, 0x230E8 },
	{ 0x3832, 0x230EF },
	{ 0x3833, 0x230E9 },
	{ 0x3834, 0x3AC5 },
	{ 0x3835, 0x230EA },
	{ 0x3836, 0x2F8CC },
	{ 0x3837, 0x3AEA },
	{ 0x3838, 0x2319B },
	{ 0x3839, 0x2319E },
	{ 0x383A, 0x23193 },
	{ 0x383B, 0x231A7 },
	{ 0x383C, 0x2319C },
	{ 0x383D, 0x231A0 },
	{ 0x383E, 0x2319A },
	{ 0x383F, 0x231AB },
	{ 0x3840, 0x231BE },
	{ 0x3841, 0x231A9 },
	{ 0x3842, 0x2332D },
	{ 0x3843, 0x2336E },
	{ 0x3844, 0x23444 },
	{ 0x3845, 0x2343D },
	{ 0x3846, 0x2343A },
	{ 0x3847, 0x23468 },
	{ 0x3848, 0x2343C },
	{ 0x3849, 0x2346A },
	{ 0x384A, 0x2F8E0 },
	{ 0x384B, 0x23438 },
	{ 0x384C, 0x23465 },
	{ 0x384D, 0x23439 },
	{ 0x384E, 0x2346D },
	{ 0x384F, 0x23436 },
	{ 0x3850, 0x2F8E3 },
	{ 0x3851, 0x2343E },
	{ 0x3852, 0x2347E },
	{ 0x3853, 0x23437 },
	{ 0x3854, 0x23899 },
	{ 0x3855, 0x238A9 },
	{ 0x3856, 0x238AD },
	{ 0x3857, 0x238A7 },
	{ 0x3858, 0x238A8 },
	{ 0x3859, 0x23966 },
	{ 0x385A, 0x23969 },
	{ 0x385B, 0x2396D },
	{ 0x385C, 0x23967 },
	{ 0x385D, 0x2396B },
	{ 0x385E, 0x2396A },
	{ 0x385F, 0x239EE },
	{ 0x3860, 0x23A01 },
	{ 0x3861, 0x23A03 },
	{ 0x3862, 0x239F4 },
	{ 0x3863, 0x239FB },
	{ 0x3864, 0x3C37 },
	{ 0x3865, 0x239F6 },
	{ 0x3866, 0x239FC },
	{ 0x3867, 0x23AF4 },
	{ 0x3868, 0x23B08 },
	{ 0x3869, 0x23B0A },
	{ 0x386A, 0x23B09 },
	{ 0x386B, 0x23B6D },
	{ 0x386C, 0x23B62 },
	{ 0x386D, 0x23B41 },
	{ 0x386E, 0x23B5E },
	{ 0x386F, 0x23B5C },
	{ 0x3870, 0x23CF3 },
	{ 0x3871, 0x23D26 },
	{ 0x3872, 0x3CE4 },
	{ 0x3873, 0x23D39 },
	{ 0x3874, 0x2F904 },
	{ 0x3875, 0x23D6C },
	{ 0x3876, 0x23D2B },
	{ 0x3877, 0x23D2E },
	{ 0x3878, 0x23D3B },
	{ 0x3879, 0x23D5E },
	{ 0x387A, 0x23DFB },
	{ 0x387B, 0x23D27 },
	{ 0x387C, 0x23D24 },
	{ 0x387D, 0x23D69 },
	{ 0x387E, 0x23D30 },
	{ 0x3921, 0x2F905 },
	{ 0x3922, 0x23D62 },
	{ 0x3923, 0x23D38 },
	{ 0x3924, 0x23D35 },
	{ 0x3925, 0x23D2A },
	{ 0x3926, 0x23D2C },
	{ 0x3927, 0x23D68 },
	{ 0x3928, 0x23D31 },
	{ 0x3929, 0x23D2F },
	{ 0x392A, 0x23D2D },
	{ 0x392B, 0x23D3A },
	{ 0x392C, 0x23D36 },
	{ 0x392D, 0x2F903 },
	{ 0x392E, 0x23D21 },
	{ 0x392F, 0x23D3C },
	{ 0x3930, 0x23D20 },
	{ 0x3931, 0x23D64 },
	{ 0x3932, 0x23D3E },
	{ 0x3933, 0x3CE8 },
	{ 0x3934, 0x241F7 },
	{ 0x3935, 0x24212 },
	{ 0x3936, 0x241F1 },
	{ 0x3937, 0x241F5 },
	{ 0x3938, 0x24222 },
	{ 0x3939, 0x241F2 },
	{ 0x393A, 0x241DF },
	{ 0x393B, 0x24215 },
	{ 0x393C, 0x24216 },
	{ 0x393D, 0x2457A },
	{ 0x393E, 0x24576 },
	{ 0x393F, 0x245BE },
	{ 0x3940, 0x3E20 },
	{ 0x3941, 0x245BD },
	{ 0x3942, 0x24609 },
	{ 0x3943, 0x24608 },
	{ 0x3944, 0x24657 },
	{ 0x3945, 0x247A3 },
	{ 0x3946, 0x247BF },
	{ 0x3947, 0x247B8 },
	{ 0x3948, 0x247AF },
	{ 0x3949, 0x2479C },
	{ 0x394A, 0x247A5 },
	{ 0x394B, 0x24772 },
	{ 0x394C, 0x24775 },
	{ 0x394D, 0x2479D },
	{ 0x394E, 0x24799 },
	{ 0x394F, 0x247B9 },
	{ 0x3950, 0x2494E },
	{ 0x3951, 0x24939 },
	{ 0x3952, 0x2493B },
	{ 0x3953, 0x24935 },
	{ 0x3954, 0x2493C },
	{ 0x3955, 0x24955 },
	{ 0x3956, 0x24AF0 },
	{ 0x3957, 0x24AF3 },
	{ 0x3958, 0x24AF4 },
	{ 0x3959, 0x24B3B },
	{ 0x395A, 0x24B3C },
	{ 0x395B, 0x24B3A },
	{ 0x395C, 0x24B36 },
	{ 0x395D, 0x24C07 },
	{ 0x395E, 0x20CEB },
	{ 0x395F, 0x24C55 },
	{ 0x3960, 0x24C50 },
	{ 0x3961, 0x24C4F },
	{ 0x3962, 0x24C52 },
	{ 0x3963, 0x24C56 },
	{ 0x3964, 0x200BD },
	{ 0x3965, 0x24C32 },
	{ 0x3966, 0x24D63 },
	{ 0x3967, 0x24D6B },
	{ 0x3968, 0x24D66 },
	{ 0x3969, 0x24D57 },
	{ 0x396A, 0x24D5D },
	{ 0x396B, 0x3F86 },
	{ 0x396C, 0x24D6D },
	{ 0x396D, 0x24D61 },
	{ 0x396E, 0x24D69 },
	{ 0x396F, 0x24D5A },
	{ 0x3970, 0x24D5C },
	{ 0x3971, 0x24D62 },
	{ 0x3972, 0x24F2A },
	{ 0x3973, 0x24F29 },
	{ 0x3974, 0x24F58 },
	{ 0x3975, 0x24F5A },
	{ 0x3976, 0x24FD7 },
	{ 0x3977, 0x24FDB },
	{ 0x3978, 0x24FDC },
	{ 0x3979, 0x24FDD },
	{ 0x397A, 0x24FD8 },
	{ 0x397B, 0x25054 },
	{ 0x397C, 0x2505B },
	{ 0x397D, 0x2505C },
	{ 0x397E, 0x25053 },
	{ 0x3A21, 0x2504F },
	{ 0x3A22, 0x25056 },
	{ 0x3A23, 0x25050 },
	{ 0x3A24, 0x2505A },
	{ 0x3A25, 0x2506B },
	{ 0x3A26, 0x25136 },
	{ 0x3A27, 0x25153 },
	{ 0x3A28, 0x2513A },
	{ 0x3A29, 0x2513C },
	{ 0x3A2A, 0x2513E },
	{ 0x3A2B, 0x25149 },
	{ 0x3A2C, 0x25140 },
	{ 0x3A2D, 0x2F946 },
	{ 0x3A2E, 0x2F947 },
	{ 0x3A2F, 0x25364 },
	{ 0x3A30, 0x25365 },
	{ 0x3A31, 0x253B5 },
	{ 0x3A32, 0x253B6 },
	{ 0x3A33, 0x253B2 },
	{ 0x3A34, 0x25448 },
	{ 0x3A35, 0x2544A },
	{ 0x3A36, 0x25472 },
	{ 0x3A37, 0x25469 },
	{ 0x3A38, 0x2545A },
	{ 0x3A39, 0x2544C },
	{ 0x3A3A, 0x2562C },
	{ 0x3A3B, 0x25630 },
	{ 0x3A3C, 0x2564B },
	{ 0x3A3D, 0x25649 },
	{ 0x3A3E, 0x25642 },
	{ 0x3A3F, 0x25644 },
	{ 0x3A40, 0x2564A },
	{ 0x3A41, 0x2564F },
	{ 0x3A42, 0x25792 },
	{ 0x3A43, 0x2F957 },
	{ 0x3A44, 0x25797 },
	{ 0x3A45, 0x25780 },
	{ 0x3A46, 0x25782 },
	{ 0x3A47, 0x25786 },
	{ 0x3A48, 0x25953 },
	{ 0x3A49, 0x2595E },
	{ 0x3A4A, 0x25952 },
	{ 0x3A4B, 0x2595B },
	{ 0x3A4C, 0x2594E },
	{ 0x3A4D, 0x25A6D },
	{ 0x3A4E, 0x25A6E },
	{ 0x3A4F, 0x25AFA },
	{ 0x3A50, 0x25AF6 },
	{ 0x3A51, 0x25AFB },
	{ 0x3A52, 0x25E33 },
	{ 0x3A53, 0x25E3D },
	{ 0x3A54, 0x25E37 },
	{ 0x3A55, 0x25E3E },
	{ 0x3A56, 0x25E35 },
	{ 0x3A57, 0x25F9A },
	{ 0x3A58, 0x25FAB },
	{ 0x3A59, 0x25FA6 },
	{ 0x3A5A, 0x25FB0 },
	{ 0x3A5B, 0x25F99 },
	{ 0x3A5C, 0x25FA0 },
	{ 0x3A5D, 0x25F9E },
	{ 0x3A5E, 0x25FA8 },
	{ 0x3A5F, 0x25FA1 },
	{ 0x3A60, 0x25FAA },
	{ 0x3A61, 0x25FAD },
	{ 0x3A62, 0x25FBB },
	{ 0x3A63, 0x25F9C },
	{ 0x3A64, 0x25FA5 },
	{ 0x3A65, 0x200B3 },
	{ 0x3A66, 0x26227 },
	{ 0x3A67, 0x2628D },
	{ 0x3A68, 0x2628E },
	{ 0x3A69, 0x2628F },
	{ 0x3A6A, 0x26292 },
	{ 0x3A6B, 0x4356 },
	{ 0x3A6C, 0x26291 },
	{ 0x3A6D, 0x262AD },
	{ 0x3A6E, 0x26357 },
	{ 0x3A6F, 0x26358 },
	{ 0x3A70, 0x2635E },
	{ 0x3A71, 0x2635D },
	{ 0x3A72, 0x2635C },
	{ 0x3A73, 0x2635B },
	{ 0x3A74, 0x4367 },
	{ 0x3A75, 0x2640A },
	{ 0x3A76, 0x26403 },
	{ 0x3A77, 0x2640E },
	{ 0x3A78, 0x264B8 },
	{ 0x3A79, 0x2654D },
	{ 0x3A7A, 0x2653F },
	{ 0x3A7B, 0x26547 },
	{ 0x3A7C, 0x2654B },
	{ 0x3A7D, 0x2654A },
	{ 0x3A7E, 0x2653D },
	{ 0x3B21, 0x8038 },
	{ 0x3B22, 0x26541 },
	{ 0x3B23, 0x2654C },
	{ 0x3B24, 0x8081 },
	{ 0x3B25, 0x26662 },
	{ 0x3B26, 0x26669 },
	{ 0x3B27, 0x26661 },
	{ 0x3B28, 0x43D1 },
	{ 0x3B29, 0x266AA },
	{ 0x3B2A, 0x266A6 },
	{ 0x3B2B, 0x266AC },
	{ 0x3B2C, 0x266BD },
	{ 0x3B2D, 0x266BB },
	{ 0x3B2E, 0x266A4 },
	{ 0x3B2F, 0x266BA },
	{ 0x3B30, 0x2669A },
	{ 0x3B31, 0x43EB },
	{ 0x3B32, 0x266A1 },
	{ 0x3B33, 0x266C1 },
	{ 0x3B34, 0x268E0 },
	{ 0x3B35, 0x2690A },
	{ 0x3B36, 0x26903 },
	{ 0x3B37, 0x26906 },
	{ 0x3B38, 0x26939 },
	{ 0x3B39, 0x2693A },
	{ 0x3B3A, 0x26936 },
	{ 0x3B3B, 0x2695B },
	{ 0x3B3C, 0x2695F },
	{ 0x3B3D, 0x2695E },
	{ 0x3B3E, 0x26967 },
	{ 0x3B3F, 0x26961 },
	{ 0x3B40, 0x26962 },
	{ 0x3B41, 0x2695D },
	{ 0x3B42, 0x269CA },
	{ 0x3B43, 0x269CC },
	{ 0x3B44, 0x269CE },
	{ 0x3B45, 0x26A18 },
	{ 0x3B46, 0x26A1D },
	{ 0x3B47, 0x26A1F },
	{ 0x3B48, 0x26A20 },
	{ 0x3B49, 0x26A17 },
	{ 0x3B4A, 0x26A15 },
	{ 0x3B4B, 0x26B1F },
	{ 0x3B4C, 0x26B27 },
	{ 0x3B4D, 0x26B26 },
	{ 0x3B4E, 0x21E10 },
	{ 0x3B4F, 0x26B8B },
	{ 0x3B50, 0x26BAE },
	{ 0x3B51, 0x26B8A },
	{ 0x3B52, 0x2F999 },
	{ 0x3B53, 0x26B92 },
	{ 0x3B54, 0x26B89 },
	{ 0x3B55, 0x26B87 },
	{ 0x3B56, 0x44B6 },
	{ 0x3B57, 0x26B8F },
	{ 0x3B58, 0x26B84 },
	{ 0x3B59, 0x26B83 },
	{ 0x3B5A, 0x26B8C },
	{ 0x3B5B, 0x26B93 },
	{ 0x3B5C, 0x26B8D },
	{ 0x3B5D, 0x26B98 },
	{ 0x3B5E, 0x26B7D },
	{ 0x3B5F, 0x26B7E },
	{ 0x3B60, 0x26BD2 },
	{ 0x3B61, 0x26B80 },
	{ 0x3B62, 0x26B99 },
	{ 0x3B63, 0x271AC },
	{ 0x3B64, 0x27250 },
	{ 0x3B65, 0x27255 },
	{ 0x3B66, 0x27242 },
	{ 0x3B67, 0x2723F },
	{ 0x3B68, 0x2723C },
	{ 0x3B69, 0x45A3 },
	{ 0x3B6A, 0x2724C },
	{ 0x3B6B, 0x27249 },
	{ 0x3B6C, 0x27257 },
	{ 0x3B6D, 0x27258 },
	{ 0x3B6E, 0x2724F },
	{ 0x3B6F, 0x2725C },
	{ 0x3B70, 0x27247 },
	{ 0x3B71, 0x2F9B7 },
	{ 0x3B72, 0x275AB },
	{ 0x3B73, 0x4610 },
	{ 0x3B74, 0x275AF },
	{ 0x3B75, 0x275AD },
	{ 0x3B76, 0x275E8 },
	{ 0x3B77, 0x275E7 },
	{ 0x3B78, 0x27630 },
	{ 0x3B79, 0x27626 },
	{ 0x3B7A, 0x2762F },
	{ 0x3B7B, 0x27628 },
	{ 0x3B7C, 0x2762B },
	{ 0x3B7D, 0x2761D },
	{ 0x3B7E, 0x2762D },
	{ 0x3C21, 0x27620 },
	{ 0x3C22, 0x2762A },
	{ 0x3C23, 0x2762C },
	{ 0x3C24, 0x27635 },
	{ 0x3C25, 0x27621 },
	{ 0x3C26, 0x27623 },
	{ 0x3C27, 0x27624 },
	{ 0x3C28, 0x27636 },
	{ 0x3C29, 0x27637 },
	{ 0x3C2A, 0x277E9 },
	{ 0x3C2B, 0x278BA },
	{ 0x3C2C, 0x278B8 },
	{ 0x3C2D, 0x2F9CC },
	{ 0x3C2E, 0x2796D },
	{ 0x3C2F, 0x2796A },
	{ 0x3C30, 0x27968 },
	{ 0x3C31, 0x27969 },
	{ 0x3C32, 0x2796B },
	{ 0x3C33, 0x27961 },
	{ 0x3C34, 0x27BDC },
	{ 0x3C35, 0x27BDB },
	{ 0x3C36, 0x27C2D },
	{ 0x3C37, 0x27C2C },
	{ 0x3C38, 0x27CA2 },
	{ 0x3C39, 0x27D2B },
	{ 0x3C3A, 0x27D32 },
	{ 0x3C3B, 0x2F9D7 },
	{ 0x3C3C, 0x27E94 },
	{ 0x3C3D, 0x27E92 },
	{ 0x3C3E, 0x27E90 },
	{ 0x3C3F, 0x27FC9 },
	{ 0x3C40, 0x27FC4 },
	{ 0x3C41, 0x27FC1 },
	{ 0x3C42, 0x27FC3 },
	{ 0x3C43, 0x27FCD },
	{ 0x3C44, 0x28214 },
	{ 0x3C45, 0x282A7 },
	{ 0x3C46, 0x282AF },
	{ 0x3C47, 0x282AA },
	{ 0x3C48, 0x2840D },
	{ 0x3C49, 0x28454 },
	{ 0x3C4A, 0x2845B },
	{ 0x3C4B, 0x28461 },
	{ 0x3C4C, 0x284AE },
	{ 0x3C4D, 0x284B3 },
	{ 0x3C4E, 0x284C0 },
	{ 0x3C4F, 0x284C4 },
	{ 0x3C50, 0x284BF },
	{ 0x3C51, 0x284CB },
	{ 0x3C52, 0x284AD },
	{ 0x3C53, 0x284A7 },
	{ 0x3C54, 0x284A4 },
	{ 0x3C55, 0x284BD },
	{ 0x3C56, 0x284AF },
	{ 0x3C57, 0x284B2 },
	{ 0x3C58, 0x284A5 },
	{ 0x3C59, 0x286E7 },
	{ 0x3C5A, 0x286E0 },
	{ 0x3C5B, 0x286CE },
	{ 0x3C5C, 0x286DE },
	{ 0x3C5D, 0x286D5 },
	{ 0x3C5E, 0x286DF },
	{ 0x3C5F, 0x286D9 },
	{ 0x3C60, 0x287F2 },
	{ 0x3C61, 0x28923 },
	{ 0x3C62, 0x28940 },
	{ 0x3C63, 0x491B },
	{ 0x3C64, 0x2893E },
	{ 0x3C65, 0x4987 },
	{ 0x3C66, 0x28CCF },
	{ 0x3C67, 0x20B54 },
	{ 0x3C68, 0x28E5B },
	{ 0x3C69, 0x28E58 },
	{ 0x3C6A, 0x28E62 },
	{ 0x3C6B, 0x28E5F },
	{ 0x3C6C, 0x28E67 },
	{ 0x3C6D, 0x28E63 },
	{ 0x3C6E, 0x28E5E },
	{ 0x3C6F, 0x28E60 },
	{ 0x3C70, 0x28F85 },
	{ 0x3C71, 0x28F86 },
	{ 0x3C72, 0x28F87 },
	{ 0x3C73, 0x291E8 },
	{ 0x3C74, 0x291E6 },
	{ 0x3C75, 0x29671 },
	{ 0x3C76, 0x29685 },
	{ 0x3C77, 0x2FA02 },
	{ 0x3C78, 0x29686 },
	{ 0x3C79, 0x29810 },
	{ 0x3C7A, 0x209F8 },
	{ 0x3C7B, 0x200BF },
	{ 0x3C7C, 0x20B61 },
	{ 0x3C7D, 0x200FE },
	{ 0x3C7E, 0x200FC },
	{ 0x3D21, 0x20139 },
	{ 0x3D22, 0x20161 },
	{ 0x3D23, 0x20160 },
	{ 0x3D24, 0x202E2 },
	{ 0x3D25, 0x202EA },
	{ 0x3D26, 0x202E3 },
	{ 0x3D27, 0x202B4 },
	{ 0x3D28, 0x202AE },
	{ 0x3D29, 0x202BE },
	{ 0x3D2A, 0x202B8 },
	{ 0x3D2B, 0x202A8 },
	{ 0x3D2C, 0x202AA },
	{ 0x3D2D, 0x202A9 },
	{ 0x3D2E, 0x202B3 },
	{ 0x3D2F, 0x202D5 },
	{ 0x3D30, 0x202AD },
	{ 0x3D31, 0x202B9 },
	{ 0x3D32, 0x202BB },
	{ 0x3D33, 0x202B1 },
	{ 0x3D34, 0x202C2 },
	{ 0x3D35, 0x2F808 },
	{ 0x3D36, 0x202EB },
	{ 0x3D37, 0x202BA },
	{ 0x3D38, 0x202D2 },
	{ 0x3D39, 0x202D4 },
	{ 0x3D3A, 0x204F1 },
	{ 0x3D3B, 0x2051D },
	{ 0x3D3C, 0x2F812 },
	{ 0x3D3D, 0x20562 },
	{ 0x3D3E, 0x2058C },
	{ 0x3D3F, 0x205E6 },
	{ 0x3D40, 0x205E7 },
	{ 0x3D41, 0x2065A },
	{ 0x3D42, 0x20658 },
	{ 0x3D43, 0x20659 },
	{ 0x3D44, 0x20696 },
	{ 0x3D45, 0x20697 },
	{ 0x3D46, 0x20761 },
	{ 0x3D47, 0x20767 },
	{ 0x3D48, 0x20771 },
	{ 0x3D49, 0x20765 },
	{ 0x3D4A, 0x2077D },
	{ 0x3D4B, 0x2077E },
	{ 0x3D4C, 0x2087D },
	{ 0x3D4D, 0x20884 },
	{ 0x3D4E, 0x2087C },
	{ 0x3D4F, 0x2087E },
	{ 0x3D50, 0x2087F },
	{ 0x3D51, 0x20880 },
	{ 0x3D52, 0x208EF },
	{ 0x3D53, 0x208F4 },
	{ 0x3D54, 0x2091E },
	{ 0x3D55, 0x2094E },
	{ 0x3D56, 0x209FB },
	{ 0x3D57, 0x209FA },
	{ 0x3D58, 0x209FD },
	{ 0x3D59, 0x2F831 },
	{ 0x3D5A, 0x2F832 },
	{ 0x3D5B, 0x20A79 },
	{ 0x3D5C, 0x20A7C },
	{ 0x3D5D, 0x20A7D },
	{ 0x3D5E, 0x20A84 },
	{ 0x3D5F, 0x20A7B },
	{ 0x3D60, 0x20A78 },
	{ 0x3D61, 0x3557 },
	{ 0x3D62, 0x20B5E },
	{ 0x3D63, 0x20B5A },
	{ 0x3D64, 0x20B5C },
	{ 0x3D65, 0x20B59 },
	{ 0x3D66, 0x20B55 },
	{ 0x3D67, 0x20B63 },
	{ 0x3D68, 0x20B56 },
	{ 0x3D69, 0x20B5F },
	{ 0x3D6A, 0x20B60 },
	{ 0x3D6B, 0x20B5B },
	{ 0x3D6C, 0x20D4A },
	{ 0x3D6D, 0x20D65 },
	{ 0x3D6E, 0x20DB3 },
	{ 0x3D6F, 0x20D2C },
	{ 0x3D70, 0x20D77 },
	{ 0x3D71, 0x20D3D },
	{ 0x3D72, 0x20D52 },
	{ 0x3D73, 0x20D61 },
	{ 0x3D74, 0x20D2A },
	{ 0x3D75, 0x20D3E },
	{ 0x3D76, 0x20D34 },
	{ 0x3D77, 0x20D29 },
	{ 0x3D78, 0x20DB2 },
	{ 0x3D79, 0x20DAD },
	{ 0x3D7A, 0x20D40 },
	{ 0x3D7B, 0x20D53 },
	{ 0x3D7C, 0x2F844 },
	{ 0x3D7D, 0x20D3F },
	{ 0x3D7E, 0x20D41 },
	{ 0x3E21, 0x20D72 },
	{ 0x3E22, 0x211F6 },
	{ 0x3E23, 0x211F5 },
	{ 0x3E24, 0x211F4 },
	{ 0x3E25, 0x211F2 },
	{ 0x3E26, 0x211F9 },
	{ 0x3E27, 0x21327 },
	{ 0x3E28, 0x21354 },
	{ 0x3E29, 0x21355 },
	{ 0x3E2A, 0x2132E },
	{ 0x3E2B, 0x2F854 },
	{ 0x3E2C, 0x2F853 },
	{ 0x3E2D, 0x2132C },
	{ 0x3E2E, 0x21338 },
	{ 0x3E2F, 0x21339 },
	{ 0x3E30, 0x21331 },
	{ 0x3E31, 0x2134F },
	{ 0x3E32, 0x21373 },
	{ 0x3E33, 0x21330 },
	{ 0x3E34, 0x2132B },
	{ 0x3E35, 0x21351 },
	{ 0x3E36, 0x2152C },
	{ 0x3E37, 0x2155B },
	{ 0x3E38, 0x2155C },
	{ 0x3E39, 0x21568 },
	{ 0x3E3A, 0x2156C },
	{ 0x3E3B, 0x2156B },
	{ 0x3E3C, 0x21569 },
	{ 0x3E3D, 0x2159F },
	{ 0x3E3E, 0x21638 },
	{ 0x3E3F, 0x2163C },
	{ 0x3E40, 0x2163A },
	{ 0x3E41, 0x21635 },
	{ 0x3E42, 0x369D },
	{ 0x3E43, 0x21639 },
	{ 0x3E44, 0x21636 },
	{ 0x3E45, 0x2163B },
	{ 0x3E46, 0x21760 },
	{ 0x3E47, 0x21761 },
	{ 0x3E48, 0x21763 },
	{ 0x3E49, 0x21764 },
	{ 0x3E4A, 0x21794 },
	{ 0x3E4B, 0x21793 },
	{ 0x3E4C, 0x2175E },
	{ 0x3E4D, 0x21768 },
	{ 0x3E4E, 0x2176A },
	{ 0x3E4F, 0x21765 },
	{ 0x3E50, 0x2F866 },
	{ 0x3E51, 0x21790 },
	{ 0x3E52, 0x2175F },
	{ 0x3E53, 0x21772 },
	{ 0x3E54, 0x2F865 },
	{ 0x3E55, 0x21A3C },
	{ 0x3E56, 0x21A27 },
	{ 0x3E57, 0x21A24 },
	{ 0x3E58, 0x21A26 },
	{ 0x3E59, 0x21A25 },
	{ 0x3E5A, 0x375F },
	{ 0x3E5B, 0x21A28 },
	{ 0x3E5C, 0x21A36 },
	{ 0x3E5D, 0x21B31 },
	{ 0x3E5E, 0x21B30 },
	{ 0x3E5F, 0x21B34 },
	{ 0x3E60, 0x21B81 },
	{ 0x3E61, 0x21B7D },
	{ 0x3E62, 0x21B82 },
	{ 0x3E63, 0x21B80 },
	{ 0x3E64, 0x3779 },
	{ 0x3E65, 0x202D3 },
	{ 0x3E66, 0x21BF2 },
	{ 0x3E67, 0x21C66 },
	{ 0x3E68, 0x21C8C },
	{ 0x3E69, 0x21C7B },
	{ 0x3E6A, 0x21C83 },
	{ 0x3E6B, 0x3798 },
	{ 0x3E6C, 0x21C8E },
	{ 0x3E6D, 0x21C7A },
	{ 0x3E6E, 0x21C92 },
	{ 0x3E6F, 0x21C91 },
	{ 0x3E70, 0x21C82 },
	{ 0x3E71, 0x21D1B },
	{ 0x3E72, 0x21D1C },
	{ 0x3E73, 0x21E27 },
	{ 0x3E74, 0x21E21 },
	{ 0x3E75, 0x37DC },
	{ 0x3E76, 0x5D2B },
	{ 0x3E77, 0x21E43 },
	{ 0x3E78, 0x37DF },
	{ 0x3E79, 0x21E18 },
	{ 0x3E7A, 0x21E7B },
	{ 0x3E7B, 0x21E1A },
	{ 0x3E7C, 0x21E4B },
	{ 0x3E7D, 0x21E4A },
	{ 0x3E7E, 0x21E4D },
	{ 0x3F21, 0x21E4F },
	{ 0x3F22, 0x21E19 },
	{ 0x3F23, 0x21E35 },
	{ 0x3F24, 0x21E13 },
	{ 0x3F25, 0x21E52 },
	{ 0x3F26, 0x21E14 },
	{ 0x3F27, 0x21E1E },
	{ 0x3F28, 0x21E2C },
	{ 0x3F29, 0x21E20 },
	{ 0x3F2A, 0x21E22 },
	{ 0x3F2B, 0x21E12 },
	{ 0x3F2C, 0x21E1F },
	{ 0x3F2D, 0x22000 },
	{ 0x3F2E, 0x22023 },
	{ 0x3F2F, 0x22040 },
	{ 0x3F30, 0x22043 },
	{ 0x3F31, 0x220E4 },
	{ 0x3F32, 0x220DB },
	{ 0x3F33, 0x220EA },
	{ 0x3F34, 0x220DD },
	{ 0x3F35, 0x220CC },
	{ 0x3F36, 0x220D9 },
	{ 0x3F37, 0x220E8 },
	{ 0x3F38, 0x220F6 },
	{ 0x3F39, 0x220E3 },
	{ 0x3F3A, 0x220D3 },
	{ 0x3F3B, 0x220DA },
	{ 0x3F3C, 0x220D6 },
	{ 0x3F3D, 0x220E7 },
	{ 0x3F3E, 0x2223A },
	{ 0x3F3F, 0x2223F },
	{ 0x3F40, 0x22240 },
	{ 0x3F41, 0x22248 },
	{ 0x3F42, 0x22259 },
	{ 0x3F43, 0x22237 },
	{ 0x3F44, 0x22244 },
	{ 0x3F45, 0x2F88C },
	{ 0x3F46, 0x2F88B },
	{ 0x3F47, 0x22255 },
	{ 0x3F48, 0x22239 },
	{ 0x3F49, 0x22354 },
	{ 0x3F4A, 0x22355 },
	{ 0x3F4B, 0x22356 },
	{ 0x3F4C, 0x22357 },
	{ 0x3F4D, 0x22358 },
	{ 0x3F4E, 0x22359 },
	{ 0x3F4F, 0x2238D },
	{ 0x3F50, 0x223F2 },
	{ 0x3F51, 0x223F8 },
	{ 0x3F52, 0x223F5 },
	{ 0x3F53, 0x223F6 },
	{ 0x3F54, 0x223FC },
	{ 0x3F55, 0x223FE },
	{ 0x3F56, 0x223F1 },
	{ 0x3F57, 0x223FD },
	{ 0x3F58, 0x2245E },
	{ 0x3F59, 0x22496 },
	{ 0x3F5A, 0x22497 },
	{ 0x3F5B, 0x2249C },
	{ 0x3F5C, 0x2249B },
	{ 0x3F5D, 0x22495 },
	{ 0x3F5E, 0x2F89A },
	{ 0x3F5F, 0x2251A },
	{ 0x3F60, 0x22509 },
	{ 0x3F61, 0x22504 },
	{ 0x3F62, 0x2250E },
	{ 0x3F63, 0x2251C },
	{ 0x3F64, 0x22518 },
	{ 0x3F65, 0x2250D },
	{ 0x3F66, 0x22510 },
	{ 0x3F67, 0x2250C },
	{ 0x3F68, 0x22503 },
	{ 0x3F69, 0x2267B },
	{ 0x3F6A, 0x226A6 },
	{ 0x3F6B, 0x22677 },
	{ 0x3F6C, 0x22688 },
	{ 0x3F6D, 0x22674 },
	{ 0x3F6E, 0x226DA },
	{ 0x3F6F, 0x22676 },
	{ 0x3F70, 0x22678 },
	{ 0x3F71, 0x2268A },
	{ 0x3F72, 0x2268F },
	{ 0x3F73, 0x2267D },
	{ 0x3F74, 0x22690 },
	{ 0x3F75, 0x226ED },
	{ 0x3F76, 0x226D9 },
	{ 0x3F77, 0x226D0 },
	{ 0x3F78, 0x2271A },
	{ 0x3F79, 0x226D7 },
	{ 0x3F7A, 0x226E2 },
	{ 0x3F7B, 0x226E1 },
	{ 0x3F7C, 0x226C5 },
	{ 0x3F7D, 0x226E0 },
	{ 0x3F7E, 0x226CA },
	{ 0x4021, 0x22725 },
	{ 0x4022, 0x226CC },
	{ 0x4023, 0x2F8B3 },
	{ 0x4024, 0x229C6 },
	{ 0x4025, 0x229C1 },
	{ 0x4026, 0x22A4D },
	{ 0x4027, 0x22B4B },
	{ 0x4028, 0x22B64 },
	{ 0x4029, 0x22B95 },
	{ 0x402A, 0x22B99 },
	{ 0x402B, 0x2F8BC },
	{ 0x402C, 0x22B94 },
	{ 0x402D, 0x22BA2 },
	{ 0x402E, 0x22BAE },
	{ 0x402F, 0x22B9E },
	{ 0x4030, 0x22BA7 },
	{ 0x4031, 0x22B86 },
	{ 0x4032, 0x39FD },
	{ 0x4033, 0x22BA4 },
	{ 0x4034, 0x22B91 },
	{ 0x4035, 0x22B93 },
	{ 0x4036, 0x2F8BB },
	{ 0x4037, 0x22B88 },
	{ 0x4038, 0x22ECD },
	{ 0x4039, 0x22ECA },
	{ 0x403A, 0x22F3F },
	{ 0x403B, 0x22F40 },
	{ 0x403C, 0x22F46 },
	{ 0x403D, 0x22F41 },
	{ 0x403E, 0x22F45 },
	{ 0x403F, 0x22F58 },
	{ 0x4040, 0x22F3B },
	{ 0x4041, 0x22F48 },
	{ 0x4042, 0x2304E },
	{ 0x4043, 0x23052 },
	{ 0x4044, 0x2304F },
	{ 0x4045, 0x2307B },
	{ 0x4046, 0x2307A },
	{ 0x4047, 0x230A0 },
	{ 0x4048, 0x2309F },
	{ 0x4049, 0x230FB },
	{ 0x404A, 0x230F7 },
	{ 0x404B, 0x231B8 },
	{ 0x404C, 0x231B9 },
	{ 0x404D, 0x231BB },
	{ 0x404E, 0x231B7 },
	{ 0x404F, 0x3AF4 },
	{ 0x4050, 0x231BA },
	{ 0x4051, 0x3AEF },
	{ 0x4052, 0x231DA },
	{ 0x4053, 0x231B5 },
	{ 0x4054, 0x231BF },
	{ 0x4055, 0x231BC },
	{ 0x4056, 0x231C0 },
	{ 0x4057, 0x2F8D3 },
	{ 0x4058, 0x2F8D9 },
	{ 0x4059, 0x23375 },
	{ 0x405A, 0x23379 },
	{ 0x405B, 0x23376 },
	{ 0x405C, 0x23435 },
	{ 0x405D, 0x23440 },
	{ 0x405E, 0x234C0 },
	{ 0x405F, 0x23481 },
	{ 0x4060, 0x234AD },
	{ 0x4061, 0x234AF },
	{ 0x4062, 0x234AC },
	{ 0x4063, 0x2348F },
	{ 0x4064, 0x234A8 },
	{ 0x4065, 0x234AA },
	{ 0x4066, 0x234A9 },
	{ 0x4067, 0x23488 },
	{ 0x4068, 0x2347F },
	{ 0x4069, 0x23480 },
	{ 0x406A, 0x234BC },
	{ 0x406B, 0x238AE },
	{ 0x406C, 0x238BB },
	{ 0x406D, 0x238BD },
	{ 0x406E, 0x3C31 },
	{ 0x406F, 0x23978 },
	{ 0x4070, 0x23974 },
	{ 0x4071, 0x23A0C },
	{ 0x4072, 0x23A11 },
	{ 0x4073, 0x23A08 },
	{ 0x4074, 0x23A06 },
	{ 0x4075, 0x23A10 },
	{ 0x4076, 0x23A8F },
	{ 0x4077, 0x23A90 },
	{ 0x4078, 0x23A8D },
	{ 0x4079, 0x23A8E },
	{ 0x407A, 0x23A96 },
	{ 0x407B, 0x23A95 },
	{ 0x407C, 0x23B0B },
	{ 0x407D, 0x23B0C },
	{ 0x407E, 0x23B7C },
	{ 0x4121, 0x23B73 },
	{ 0x4122, 0x23B75 },
	{ 0x4123, 0x23B76 },
	{ 0x4124, 0x23B7D },
	{ 0x4125, 0x23B78 },
	{ 0x4126, 0x23B71 },
	{ 0x4127, 0x23C4B },
	{ 0x4128, 0x23C4E },
	{ 0x4129, 0x23D33 },
	{ 0x412A, 0x23D32 },
	{ 0x412B, 0x3D03 },
	{ 0x412C, 0x23D91 },
	{ 0x412D, 0x23DE7 },
	{ 0x412E, 0x23DE9 },
	{ 0x412F, 0x23DA2 },
	{ 0x4130, 0x23D94 },
	{ 0x4131, 0x23D87 },
	{ 0x4132, 0x23DA3 },
	{ 0x4133, 0x23DDD },
	{ 0x4134, 0x23D7B },
	{ 0x4135, 0x23D83 },
	{ 0x4136, 0x23D81 },
	{ 0x4137, 0x23DDF },
	{ 0x4138, 0x23D7C },
	{ 0x4139, 0x23DE4 },
	{ 0x413A, 0x23DE2 },
	{ 0x413B, 0x23D93 },
	{ 0x413C, 0x23D7D },
	{ 0x413D, 0x23DBF },
	{ 0x413E, 0x23D9B },
	{ 0x413F, 0x23D8E },
	{ 0x4140, 0x23D9F },
	{ 0x4141, 0x3D09 },
	{ 0x4142, 0x23D8C },
	{ 0x4143, 0x23D7F },
	{ 0x4144, 0x23D9C },
	{ 0x4145, 0x23D84 },
	{ 0x4146, 0x23D42 },
	{ 0x4147, 0x23DE6 },
	{ 0x4148, 0x24251 },
	{ 0x4149, 0x2424A },
	{ 0x414A, 0x24264 },
	{ 0x414B, 0x24225 },
	{ 0x414C, 0x2422F },
	{ 0x414D, 0x2422E },
	{ 0x414E, 0x2422B },
	{ 0x414F, 0x24228 },
	{ 0x4150, 0x24232 },
	{ 0x4151, 0x2422D },
	{ 0x4152, 0x24231 },
	{ 0x4153, 0x24239 },
	{ 0x4154, 0x2422C },
	{ 0x4155, 0x24261 },
	{ 0x4156, 0x24511 },
	{ 0x4157, 0x24510 },
	{ 0x4158, 0x24512 },
	{ 0x4159, 0x24553 },
	{ 0x415A, 0x24555 },
	{ 0x415B, 0x2457B },
	{ 0x415C, 0x24581 },
	{ 0x415D, 0x2457D },
	{ 0x415E, 0x2457C },
	{ 0x415F, 0x245C2 },
	{ 0x4160, 0x245C5 },
	{ 0x4161, 0x2F922 },
	{ 0x4162, 0x245C4 },
	{ 0x4163, 0x2F923 },
	{ 0x4164, 0x2466B },
	{ 0x4165, 0x24668 },
	{ 0x4166, 0x3E3E },
	{ 0x4167, 0x2465C },
	{ 0x4168, 0x2465D },
	{ 0x4169, 0x2466A },
	{ 0x416A, 0x2F924 },
	{ 0x416B, 0x24C76 },
	{ 0x416C, 0x24776 },
	{ 0x416D, 0x3E77 },
	{ 0x416E, 0x247C4 },
	{ 0x416F, 0x247CB },
	{ 0x4170, 0x247C8 },
	{ 0x4171, 0x247D4 },
	{ 0x4172, 0x247D5 },
	{ 0x4173, 0x247C9 },
	{ 0x4174, 0x247D7 },
	{ 0x4175, 0x3E7B },
	{ 0x4176, 0x24978 },
	{ 0x4177, 0x2495A },
	{ 0x4178, 0x2495B },
	{ 0x4179, 0x2495C },
	{ 0x417A, 0x24956 },
	{ 0x417B, 0x24958 },
	{ 0x417C, 0x24971 },
	{ 0x417D, 0x269D4 },
	{ 0x417E, 0x24B40 },
	{ 0x4221, 0x2F933 },
	{ 0x4222, 0x24B3F },
	{ 0x4223, 0x24B43 },
	{ 0x4224, 0x24B41 },
	{ 0x4225, 0x24BE2 },
	{ 0x4226, 0x24BE0 },
	{ 0x4227, 0x24BE3 },
	{ 0x4228, 0x24C66 },
	{ 0x4229, 0x24C73 },
	{ 0x422A, 0x24C6C },
	{ 0x422B, 0x24C71 },
	{ 0x422C, 0x24C6A },
	{ 0x422D, 0x24C6D },
	{ 0x422E, 0x24C6E },
	{ 0x422F, 0x24C6B },
	{ 0x4230, 0x24D8C },
	{ 0x4231, 0x24D77 },
	{ 0x4232, 0x2F93A },
	{ 0x4233, 0x24D7F },
	{ 0x4234, 0x24D89 },
	{ 0x4235, 0x24D7A },
	{ 0x4236, 0x24D85 },
	{ 0x4237, 0x24D78 },
	{ 0x4238, 0x24D8A },
	{ 0x4239, 0x24D86 },
	{ 0x423A, 0x24F2C },
	{ 0x423B, 0x24F67 },
	{ 0x423C, 0x24F5B },
	{ 0x423D, 0x24FE5 },
	{ 0x423E, 0x24FE1 },
	{ 0x423F, 0x25061 },
	{ 0x4240, 0x25069 },
	{ 0x4241, 0x2506A },
	{ 0x4242, 0x25165 },
	{ 0x4243, 0x2516D },
	{ 0x4244, 0x25163 },
	{ 0x4245, 0x25186 },
	{ 0x4246, 0x2515C },
	{ 0x4247, 0x25162 },
	{ 0x4248, 0x2F948 },
	{ 0x4249, 0x25179 },
	{ 0x424A, 0x25169 },
	{ 0x424B, 0x25170 },
	{ 0x424C, 0x25176 },
	{ 0x424D, 0x2515D },
	{ 0x424E, 0x25187 },
	{ 0x424F, 0x2516E },
	{ 0x4250, 0x25171 },
	{ 0x4251, 0x2517C },
	{ 0x4252, 0x25173 },
	{ 0x4253, 0x2515B },
	{ 0x4254, 0x2516B },
	{ 0x4255, 0x253BF },
	{ 0x4256, 0x253C1 },
	{ 0x4257, 0x253BD },
	{ 0x4258, 0x253C9 },
	{ 0x4259, 0x253BC },
	{ 0x425A, 0x253C2 },
	{ 0x425B, 0x253C0 },
	{ 0x425C, 0x25492 },
	{ 0x425D, 0x254A9 },
	{ 0x425E, 0x2548F },
	{ 0x425F, 0x25476 },
	{ 0x4260, 0x2547B },
	{ 0x4261, 0x25475 },
	{ 0x4262, 0x254A4 },
	{ 0x4263, 0x25664 },
	{ 0x4264, 0x2573D },
	{ 0x4265, 0x257AF },
	{ 0x4266, 0x413A },
	{ 0x4268, 0x2579D },
	{ 0x4269, 0x25799 },
	{ 0x426A, 0x257B1 },
	{ 0x426B, 0x25963 },
	{ 0x426C, 0x25962 },
	{ 0x426D, 0x25964 },
	{ 0x426E, 0x25969 },
	{ 0x426F, 0x41A0 },
	{ 0x4270, 0x25A75 },
	{ 0x4271, 0x25A73 },
	{ 0x4272, 0x25A71 },
	{ 0x4273, 0x25A74 },
	{ 0x4274, 0x25B0C },
	{ 0x4275, 0x25B16 },
	{ 0x4276, 0x41E5 },
	{ 0x4277, 0x25B11 },
	{ 0x4278, 0x25B1F },
	{ 0x4279, 0x25B1A },
	{ 0x427A, 0x25B0D },
	{ 0x427B, 0x25B1B },
	{ 0x427C, 0x25B13 },
	{ 0x427D, 0x25E4E },
	{ 0x427E, 0x25E55 },
	{ 0x4321, 0x25E50 },
	{ 0x4322, 0x427D },
	{ 0x4323, 0x25FD2 },
	{ 0x4324, 0x25FD3 },
	{ 0x4325, 0x25FD1 },
	{ 0x4326, 0x25FF1 },
	{ 0x4327, 0x25FDC },
	{ 0x4328, 0x25FC8 },
	{ 0x4329, 0x25FCC },
	{ 0x432A, 0x25FD0 },
	{ 0x432B, 0x25FCF },
	{ 0x432C, 0x25FDF },
	{ 0x432D, 0x2622B },
	{ 0x432E, 0x2622E },
	{ 0x432F, 0x2622D },
	{ 0x4330, 0x2629D },
	{ 0x4331, 0x2629E },
	{ 0x4332, 0x2629F },
	{ 0x4333, 0x262A9 },
	{ 0x4334, 0x262A0 },
	{ 0x4335, 0x26298 },
	{ 0x4336, 0x262A1 },
	{ 0x4337, 0x262AB },
	{ 0x4338, 0x262AF },
	{ 0x4339, 0x2636E },
	{ 0x433A, 0x2635F },
	{ 0x433B, 0x2635A },
	{ 0x433C, 0x436D },
	{ 0x433D, 0x26365 },
	{ 0x433E, 0x26368 },
	{ 0x433F, 0x26372 },
	{ 0x4340, 0x26417 },
	{ 0x4341, 0x26416 },
	{ 0x4342, 0x26418 },
	{ 0x4343, 0x26419 },
	{ 0x4344, 0x2641A },
	{ 0x4345, 0x26422 },
	{ 0x4346, 0x2641B },
	{ 0x4347, 0x2641C },
	{ 0x4348, 0x264BE },
	{ 0x4349, 0x264EE },
	{ 0x434A, 0x2655A },
	{ 0x434B, 0x26550 },
	{ 0x434C, 0x26558 },
	{ 0x434D, 0x26554 },
	{ 0x434E, 0x26557 },
	{ 0x434F, 0x26556 },
	{ 0x4350, 0x26615 },
	{ 0x4351, 0x2669B },
	{ 0x4352, 0x26693 },
	{ 0x4353, 0x26692 },
	{ 0x4354, 0x26672 },
	{ 0x4355, 0x26698 },
	{ 0x4356, 0x26699 },
	{ 0x4357, 0x266DF },
	{ 0x4358, 0x43F8 },
	{ 0x4359, 0x266D5 },
	{ 0x435A, 0x8158 },
	{ 0x435B, 0x266D4 },
	{ 0x435C, 0x266F3 },
	{ 0x435D, 0x266F4 },
	{ 0x435E, 0x266E7 },
	{ 0x435F, 0x266E1 },
	{ 0x4360, 0x266E6 },
	{ 0x4361, 0x266EB },
	{ 0x4362, 0x266EC },
	{ 0x4363, 0x202DB },
	{ 0x4364, 0x4450 },
	{ 0x4365, 0x2690D },
	{ 0x4366, 0x2690C },
	{ 0x4367, 0x21B2F },
	{ 0x4368, 0x26968 },
	{ 0x4369, 0x26965 },
	{ 0x436A, 0x2696B },
	{ 0x436B, 0x26969 },
	{ 0x436C, 0x269D1 },
	{ 0x436D, 0x269D3 },
	{ 0x436E, 0x26A27 },
	{ 0x436F, 0x26A28 },
	{ 0x4370, 0x4468 },
	{ 0x4371, 0x4467 },
	{ 0x4372, 0x26A24 },
	{ 0x4373, 0x26AD7 },
	{ 0x4374, 0x26BCA },
	{ 0x4375, 0x26BC7 },
	{ 0x4376, 0x2F99E },
	{ 0x4377, 0x26BD8 },
	{ 0x4378, 0x26BE1 },
	{ 0x4379, 0x26BC6 },
	{ 0x437A, 0x26BF8 },
	{ 0x437B, 0x26BC3 },
	{ 0x437C, 0x26BF4 },
	{ 0x437D, 0x26C17 },
	{ 0x437E, 0x26BEA },
	{ 0x4421, 0x26BCB },
	{ 0x4422, 0x26B86 },
	{ 0x4423, 0x26BC4 },
	{ 0x4424, 0x26BD9 },
	{ 0x4425, 0x26C19 },
	{ 0x4426, 0x26BC2 },
	{ 0x4427, 0x26BE2 },
	{ 0x4428, 0x44CF },
	{ 0x4429, 0x26BDE },
	{ 0x442A, 0x26BED },
	{ 0x442B, 0x2F99C },
	{ 0x442C, 0x44CD },
	{ 0x442D, 0x26C1D },
	{ 0x442E, 0x26BDD },
	{ 0x442F, 0x26BDB },
	{ 0x4430, 0x26BE8 },
	{ 0x4431, 0x26BE9 },
	{ 0x4432, 0x26BBF },
	{ 0x4433, 0x26BE0 },
	{ 0x4434, 0x26BD1 },
	{ 0x4435, 0x26BDC },
	{ 0x4436, 0x26BCE },
	{ 0x4437, 0x26C1E },
	{ 0x4438, 0x26BCC },
	{ 0x4439, 0x26BF2 },
	{ 0x443A, 0x26BF3 },
	{ 0x443B, 0x2F99F },
	{ 0x443C, 0x2F9A2 },
	{ 0x443D, 0x2F9A3 },
	{ 0x443E, 0x2F9A1 },
	{ 0x443F, 0x271AB },
	{ 0x4440, 0x271AA },
	{ 0x4441, 0x271A7 },
	{ 0x4442, 0x271A9 },
	{ 0x4443, 0x27288 },
	{ 0x4444, 0x27275 },
	{ 0x4445, 0x27260 },
	{ 0x4446, 0x2726C },
	{ 0x4447, 0x27273 },
	{ 0x4448, 0x45AB },
	{ 0x4449, 0x2726E },
	{ 0x444A, 0x27274 },
	{ 0x444B, 0x27276 },
	{ 0x444C, 0x27268 },
	{ 0x444D, 0x27277 },
	{ 0x444E, 0x27286 },
	{ 0x444F, 0x275EA },
	{ 0x4450, 0x27651 },
	{ 0x4451, 0x27650 },
	{ 0x4452, 0x27658 },
	{ 0x4453, 0x2764D },
	{ 0x4454, 0x2764F },
	{ 0x4455, 0x2764E },
	{ 0x4456, 0x2765C },
	{ 0x4457, 0x27652 },
	{ 0x4458, 0x27644 },
	{ 0x4459, 0x2764A },
	{ 0x445A, 0x2764B },
	{ 0x445B, 0x277EA },
	{ 0x445C, 0x27810 },
	{ 0x445D, 0x27811 },
	{ 0x445E, 0x278CD },
	{ 0x445F, 0x278BF },
	{ 0x4460, 0x278C4 },
	{ 0x4461, 0x278D0 },
	{ 0x4462, 0x278CE },
	{ 0x4463, 0x278C0 },
	{ 0x4464, 0x278C2 },
	{ 0x4465, 0x278CF },
	{ 0x4466, 0x278C9 },
	{ 0x4467, 0x278BB },
	{ 0x4468, 0x27997 },
	{ 0x4469, 0x27992 },
	{ 0x446A, 0x2796F },
	{ 0x446B, 0x2797E },
	{ 0x446C, 0x2799A },
	{ 0x446D, 0x46C1 },
	{ 0x446E, 0x27986 },
	{ 0x446F, 0x27973 },
	{ 0x4470, 0x8A24 },
	{ 0x4471, 0x27977 },
	{ 0x4472, 0x2798F },
	{ 0x4473, 0x27970 },
	{ 0x4474, 0x27981 },
	{ 0x4475, 0x27982 },
	{ 0x4476, 0x27999 },
	{ 0x4477, 0x2797D },
	{ 0x4478, 0x2797F },
	{ 0x4479, 0x2797B },
	{ 0x447A, 0x27987 },
	{ 0x447B, 0x27BB2 },
	{ 0x447C, 0x27C2F },
	{ 0x447D, 0x27C34 },
	{ 0x447E, 0x27C2E },
	{ 0x4521, 0x27C32 },
	{ 0x4522, 0x4747 },
	{ 0x4523, 0x27CAA },
	{ 0x4524, 0x4757 },
	{ 0x4525, 0x27CA9 },
	{ 0x4526, 0x27D38 },
	{ 0x4527, 0x27D36 },
	{ 0x4528, 0x27D37 },
	{ 0x4529, 0x27D47 },
	{ 0x452A, 0x27D33 },
	{ 0x452B, 0x27D39 },
	{ 0x452C, 0x27D35 },
	{ 0x452D, 0x27D44 },
	{ 0x452E, 0x27EA5 },
	{ 0x452F, 0x27EA6 },
	{ 0x4530, 0x27E9E },
	{ 0x4531, 0x27FE3 },
	{ 0x4532, 0x27FDF },
	{ 0x4533, 0x27FD3 },
	{ 0x4534, 0x27FF1 },
	{ 0x4535, 0x27FE4 },
	{ 0x4536, 0x27FE0 },
	{ 0x4537, 0x27FD6 },
	{ 0x4538, 0x8DC3 },
	{ 0x4539, 0x27FE6 },
	{ 0x453A, 0x27FD8 },
	{ 0x453B, 0x27FDE },
	{ 0x453C, 0x27FDB },
	{ 0x453D, 0x27FDC },
	{ 0x453E, 0x2821B },
	{ 0x453F, 0x2821F },
	{ 0x4540, 0x2821D },
	{ 0x4541, 0x2821C },
	{ 0x4542, 0x2821E },
	{ 0x4543, 0x28220 },
	{ 0x4544, 0x28221 },
	{ 0x4545, 0x484E },
	{ 0x4546, 0x282B6 },
	{ 0x4547, 0x282BC },
	{ 0x4548, 0x282C6 },
	{ 0x4549, 0x282C7 },
	{ 0x454A, 0x282BA },
	{ 0x454B, 0x282BE },
	{ 0x454C, 0x282BD },
	{ 0x454D, 0x282B5 },
	{ 0x454E, 0x282B4 },
	{ 0x454F, 0x2840F },
	{ 0x4550, 0x28462 },
	{ 0x4551, 0x284EB },
	{ 0x4552, 0x284D9 },
	{ 0x4553, 0x284E4 },
	{ 0x4554, 0x284D7 },
	{ 0x4555, 0x284D8 },
	{ 0x4556, 0x284D6 },
	{ 0x4557, 0x284CE },
	{ 0x4558, 0x284DD },
	{ 0x4559, 0x284E7 },
	{ 0x455A, 0x284D2 },
	{ 0x455B, 0x284C5 },
	{ 0x455C, 0x284C9 },
	{ 0x455D, 0x284DB },
	{ 0x455E, 0x28692 },
	{ 0x455F, 0x2868A },
	{ 0x4560, 0x2868B },
	{ 0x4561, 0x28689 },
	{ 0x4562, 0x28708 },
	{ 0x4563, 0x28703 },
	{ 0x4564, 0x28706 },
	{ 0x4565, 0x28705 },
	{ 0x4566, 0x286F5 },
	{ 0x4567, 0x2870B },
	{ 0x4568, 0x286FB },
	{ 0x4569, 0x287FC },
	{ 0x456A, 0x28801 },
	{ 0x456B, 0x28802 },
	{ 0x456C, 0x287FA },
	{ 0x456D, 0x28808 },
	{ 0x456E, 0x287F7 },
	{ 0x456F, 0x28800 },
	{ 0x4570, 0x287FF },
	{ 0x4571, 0x28806 },
	{ 0x4572, 0x287F6 },
	{ 0x4573, 0x287FB },
	{ 0x4574, 0x2880A },
	{ 0x4575, 0x28925 },
	{ 0x4576, 0x28943 },
	{ 0x4577, 0x28944 },
	{ 0x4578, 0x28C64 },
	{ 0x4579, 0x28C62 },
	{ 0x457A, 0x28C5E },
	{ 0x457B, 0x28C5B },
	{ 0x457C, 0x28CD6 },
	{ 0x457D, 0x20072 },
	{ 0x457E, 0x200C2 },
	{ 0x4621, 0x28E77 },
	{ 0x4622, 0x28E82 },
	{ 0x4623, 0x28E7C },
	{ 0x4624, 0x28E7D },
	{ 0x4625, 0x28E86 },
	{ 0x4626, 0x28E81 },
	{ 0x4627, 0x28E84 },
	{ 0x4628, 0x28E76 },
	{ 0x4629, 0x28E83 },
	{ 0x462A, 0x28E7F },
	{ 0x462B, 0x28E7E },
	{ 0x462C, 0x28F88 },
	{ 0x462D, 0x28F8D },
	{ 0x462E, 0x28F8B },
	{ 0x462F, 0x28F91 },
	{ 0x4630, 0x28F8F },
	{ 0x4631, 0x2907C },
	{ 0x4632, 0x29079 },
	{ 0x4633, 0x2907A },
	{ 0x4634, 0x291EA },
	{ 0x4635, 0x2944C },
	{ 0x4636, 0x29599 },
	{ 0x4637, 0x202D1 },
	{ 0x4638, 0x2968B },
	{ 0x4639, 0x2968D },
	{ 0x463A, 0x2968A },
	{ 0x463B, 0x2968E },
	{ 0x463C, 0x29811 },
	{ 0x463D, 0x22256 },
	{ 0x463E, 0x2FA15 },
	{ 0x463F, 0x20074 },
	{ 0x4640, 0x200C3 },
	{ 0x4641, 0x200C4 },
	{ 0x4642, 0x2011B },
	{ 0x4643, 0x2015F },
	{ 0x4644, 0x2016A },
	{ 0x4645, 0x20169 },
	{ 0x4646, 0x2016B },
	{ 0x4647, 0x2030C },
	{ 0x4648, 0x202F6 },
	{ 0x4649, 0x202ED },
	{ 0x464A, 0x20329 },
	{ 0x464B, 0x202FE },
	{ 0x464C, 0x202F1 },
	{ 0x464D, 0x20317 },
	{ 0x464E, 0x202FF },
	{ 0x464F, 0x202EE },
	{ 0x4650, 0x202FD },
	{ 0x4651, 0x2031C },
	{ 0x4652, 0x202FC },
	{ 0x4653, 0x20300 },
	{ 0x4654, 0x20320 },
	{ 0x4655, 0x3477 },
	{ 0x4656, 0x202F9 },
	{ 0x4657, 0x20367 },
	{ 0x4658, 0x20308 },
	{ 0x4659, 0x2049E },
	{ 0x465A, 0x204F3 },
	{ 0x465B, 0x20525 },
	{ 0x465C, 0x20527 },
	{ 0x465D, 0x2051F },
	{ 0x465E, 0x20565 },
	{ 0x465F, 0x20563 },
	{ 0x4660, 0x20594 },
	{ 0x4661, 0x20597 },
	{ 0x4662, 0x205F1 },
	{ 0x4663, 0x2065F },
	{ 0x4664, 0x20662 },
	{ 0x4665, 0x51F2 },
	{ 0x4666, 0x20660 },
	{ 0x4667, 0x2F822 },
	{ 0x4668, 0x2078C },
	{ 0x4669, 0x20782 },
	{ 0x466A, 0x20790 },
	{ 0x466B, 0x2078B },
	{ 0x466C, 0x2078D },
	{ 0x466D, 0x20781 },
	{ 0x466E, 0x2079D },
	{ 0x466F, 0x2088E },
	{ 0x4670, 0x2088F },
	{ 0x4671, 0x20892 },
	{ 0x4672, 0x20923 },
	{ 0x4673, 0x20952 },
	{ 0x4674, 0x2F82E },
	{ 0x4675, 0x20A00 },
	{ 0x4676, 0x20A01 },
	{ 0x4677, 0x20A02 },
	{ 0x4678, 0x20A1F },
	{ 0x4679, 0x20A8C },
	{ 0x467A, 0x20A89 },
	{ 0x467B, 0x20A8B },
	{ 0x467C, 0x20A88 },
	{ 0x467D, 0x20A8D },
	{ 0x467E, 0x20A8F },
	{ 0x4721, 0x26385 },
	{ 0x4722, 0x20B00 },
	{ 0x4723, 0x20B05 },
	{ 0x4724, 0x20B01 },
	{ 0x4725, 0x20B68 },
	{ 0x4726, 0x20B6E },
	{ 0x4727, 0x20B67 },
	{ 0x4728, 0x20B75 },
	{ 0x4729, 0x55B6 },
	{ 0x472A, 0x2F845 },
	{ 0x472B, 0x20DD7 },
	{ 0x472C, 0x2F846 },
	{ 0x472D, 0x20048 },
	{ 0x472E, 0x20DD4 },
	{ 0x472F, 0x20DD8 },
	{ 0x4730, 0x2F847 },
	{ 0x4731, 0x2F848 },
	{ 0x4732, 0x20DBA },
	{ 0x4733, 0x2F849 },
	{ 0x4734, 0x20DDB },
	{ 0x4735, 0x20DBF },
	{ 0x4736, 0x20E35 },
	{ 0x4737, 0x20DBC },
	{ 0x4738, 0x20DD9 },
	{ 0x4739, 0x35C4 },
	{ 0x473A, 0x20DDD },
	{ 0x473B, 0x20E00 },
	{ 0x473C, 0x20DD5 },
	{ 0x473D, 0x20E30 },
	{ 0x473E, 0x20DBD },
	{ 0x473F, 0x20DDC },
	{ 0x4740, 0x211FD },
	{ 0x4741, 0x211FE },
	{ 0x4742, 0x21207 },
	{ 0x4743, 0x24517 },
	{ 0x4744, 0x2136F },
	{ 0x4745, 0x21369 },
	{ 0x4746, 0x21370 },
	{ 0x4747, 0x21367 },
	{ 0x4748, 0x213A9 },
	{ 0x4749, 0x21395 },
	{ 0x474A, 0x21390 },
	{ 0x474B, 0x2136C },
	{ 0x474C, 0x21397 },
	{ 0x474D, 0x21371 },
	{ 0x474E, 0x3652 },
	{ 0x474F, 0x21374 },
	{ 0x4750, 0x2136D },
	{ 0x4751, 0x2138E },
	{ 0x4752, 0x2152F },
	{ 0x4753, 0x2A31B },
	{ 0x4754, 0x215A9 },
	{ 0x4755, 0x2164E },
	{ 0x4756, 0x2F85F },
	{ 0x4757, 0x2165A },
	{ 0x4758, 0x21648 },
	{ 0x4759, 0x21655 },
	{ 0x475A, 0x2164C },
	{ 0x475B, 0x21649 },
	{ 0x475C, 0x2164F },
	{ 0x475D, 0x2164A },
	{ 0x475E, 0x217D6 },
	{ 0x475F, 0x217A0 },
	{ 0x4760, 0x217A9 },
	{ 0x4761, 0x2F867 },
	{ 0x4762, 0x2179D },
	{ 0x4763, 0x217D4 },
	{ 0x4764, 0x217A4 },
	{ 0x4765, 0x217A8 },
	{ 0x4766, 0x217A6 },
	{ 0x4767, 0x217E6 },
	{ 0x4768, 0x2197D },
	{ 0x4769, 0x21977 },
	{ 0x476A, 0x2197A },
	{ 0x476B, 0x21A41 },
	{ 0x476C, 0x21A49 },
	{ 0x476D, 0x21A59 },
	{ 0x476E, 0x21A45 },
	{ 0x476F, 0x21A48 },
	{ 0x4770, 0x21A40 },
	{ 0x4771, 0x21B8E },
	{ 0x4772, 0x21B95 },
	{ 0x4773, 0x21B90 },
	{ 0x4774, 0x21BF7 },
	{ 0x4775, 0x21BF8 },
	{ 0x4776, 0x21BF6 },
	{ 0x4777, 0x21BFB },
	{ 0x4778, 0x21C9E },
	{ 0x4779, 0x21C9D },
	{ 0x477A, 0x21C99 },
	{ 0x477B, 0x2F877 },
	{ 0x477C, 0x21CA3 },
	{ 0x477D, 0x21CA9 },
	{ 0x477E, 0x21C98 },
	{ 0x4821, 0x21CA0 },
	{ 0x4822, 0x21C96 },
	{ 0x4823, 0x21C94 },
	{ 0x4824, 0x21C95 },
	{ 0x4825, 0x21C9F },
	{ 0x4826, 0x21CA1 },
	{ 0x4827, 0x21D21 },
	{ 0x4828, 0x21D1D },
	{ 0x4829, 0x21D1F },
	{ 0x482A, 0x21E6D },
	{ 0x482B, 0x2F87C },
	{ 0x482C, 0x21E9A },
	{ 0x482D, 0x21E92 },
	{ 0x482E, 0x21E7A },
	{ 0x482F, 0x21E7D },
	{ 0x4830, 0x21EA1 },
	{ 0x4831, 0x21E9D },
	{ 0x4832, 0x21E99 },
	{ 0x4833, 0x21E6B },
	{ 0x4834, 0x21E6E },
	{ 0x4835, 0x2F87D },
	{ 0x4836, 0x22045 },
	{ 0x4837, 0x2F884 },
	{ 0x4838, 0x220FB },
	{ 0x4839, 0x220EB },
	{ 0x483A, 0x220F2 },
	{ 0x483B, 0x220F9 },
	{ 0x483C, 0x2F886 },
	{ 0x483D, 0x220F8 },
	{ 0x483E, 0x220ED },
	{ 0x483F, 0x22101 },
	{ 0x4840, 0x220F7 },
	{ 0x4841, 0x22106 },
	{ 0x4842, 0x2219B },
	{ 0x4843, 0x221CA },
	{ 0x4844, 0x386B },
	{ 0x4845, 0x5EC3 },
	{ 0x4846, 0x2226B },
	{ 0x4847, 0x2226C },
	{ 0x4848, 0x22274 },
	{ 0x4849, 0x22267 },
	{ 0x484A, 0x2225B },
	{ 0x484B, 0x22260 },
	{ 0x484C, 0x22276 },
	{ 0x484D, 0x22263 },
	{ 0x484E, 0x22261 },
	{ 0x484F, 0x22328 },
	{ 0x4850, 0x2235B },
	{ 0x4851, 0x2235E },
	{ 0x4852, 0x22360 },
	{ 0x4853, 0x2235D },
	{ 0x4854, 0x2235C },
	{ 0x4855, 0x223F4 },
	{ 0x4856, 0x22400 },
	{ 0x4857, 0x22408 },
	{ 0x4858, 0x22407 },
	{ 0x4859, 0x22401 },
	{ 0x485A, 0x22405 },
	{ 0x485B, 0x22464 },
	{ 0x485C, 0x22463 },
	{ 0x485D, 0x2249E },
	{ 0x485E, 0x224A0 },
	{ 0x485F, 0x224A1 },
	{ 0x4860, 0x2249F },
	{ 0x4861, 0x22526 },
	{ 0x4862, 0x2252D },
	{ 0x4863, 0x22528 },
	{ 0x4864, 0x2251D },
	{ 0x4865, 0x226EC },
	{ 0x4866, 0x226E3 },
	{ 0x4867, 0x226EB },
	{ 0x4868, 0x22716 },
	{ 0x4869, 0x226C8 },
	{ 0x486A, 0x2661B },
	{ 0x486B, 0x226E9 },
	{ 0x486C, 0x226E4 },
	{ 0x486D, 0x22724 },
	{ 0x486E, 0x226D1 },
	{ 0x486F, 0x3941 },
	{ 0x4870, 0x226DD },
	{ 0x4871, 0x226C2 },
	{ 0x4872, 0x226CB },
	{ 0x4873, 0x226C7 },
	{ 0x4874, 0x226E7 },
	{ 0x4875, 0x3950 },
	{ 0x4876, 0x226EA },
	{ 0x4877, 0x2274B },
	{ 0x4878, 0x2F8A5 },
	{ 0x4879, 0x22760 },
	{ 0x487A, 0x2277D },
	{ 0x487B, 0x2273E },
	{ 0x487C, 0x2F8A4 },
	{ 0x487D, 0x22752 },
	{ 0x487E, 0x2274E },
	{ 0x4921, 0x2273C },
	{ 0x4922, 0x22732 },
	{ 0x4923, 0x22730 },
	{ 0x4924, 0x22723 },
	{ 0x4925, 0x229CA },
	{ 0x4926, 0x229CB },
	{ 0x4927, 0x229C9 },
	{ 0x4928, 0x229C8 },
	{ 0x4929, 0x229CD },
	{ 0x492A, 0x22B98 },
	{ 0x492B, 0x22BA0 },
	{ 0x492C, 0x22B9F },
	{ 0x492D, 0x22B9C },
	{ 0x492E, 0x22BA3 },
	{ 0x492F, 0x22B97 },
	{ 0x4930, 0x2F8BE },
	{ 0x4931, 0x22BF1 },
	{ 0x4932, 0x22C09 },
	{ 0x4933, 0x22C03 },
	{ 0x4934, 0x22BEA },
	{ 0x4935, 0x22C45 },
	{ 0x4936, 0x22BED },
	{ 0x4937, 0x22C05 },
	{ 0x4938, 0x22C1A },
	{ 0x4939, 0x22C15 },
	{ 0x493A, 0x22C01 },
	{ 0x493B, 0x22BEC },
	{ 0x493C, 0x22C0E },
	{ 0x493D, 0x22C17 },
	{ 0x493E, 0x22C42 },
	{ 0x493F, 0x22C12 },
	{ 0x4940, 0x22C10 },
	{ 0x4941, 0x22BEF },
	{ 0x4942, 0x22BFF },
	{ 0x4943, 0x22C00 },
	{ 0x4944, 0x22C0C },
	{ 0x4945, 0x22C0F },
	{ 0x4946, 0x22C04 },
	{ 0x4947, 0x22C08 },
	{ 0x4948, 0x22C14 },
	{ 0x4949, 0x22C43 },
	{ 0x494A, 0x2F8BD },
	{ 0x494B, 0x22C1B },
	{ 0x494C, 0x22C11 },
	{ 0x494D, 0x22C13 },
	{ 0x494E, 0x22ECF },
	{ 0x494F, 0x22ECE },
	{ 0x4950, 0x22F6F },
	{ 0x4951, 0x22F6E },
	{ 0x4952, 0x22F7A },
	{ 0x4953, 0x22F70 },
	{ 0x4954, 0x22F64 },
	{ 0x4955, 0x22F5E },
	{ 0x4956, 0x22F6C },
	{ 0x4957, 0x2F8C9 },
	{ 0x4958, 0x22F5B },
	{ 0x4959, 0x22F61 },
	{ 0x495A, 0x22F65 },
	{ 0x495B, 0x2307F },
	{ 0x495C, 0x23080 },
	{ 0x495D, 0x2307C },
	{ 0x495E, 0x230A7 },
	{ 0x495F, 0x230A6 },
	{ 0x4960, 0x230A1 },
	{ 0x4961, 0x3AC0 },
	{ 0x4962, 0x230A8 },
	{ 0x4963, 0x230A3 },
	{ 0x4964, 0x230A2 },
	{ 0x4965, 0x230AD },
	{ 0x4966, 0x230A5 },
	{ 0x4967, 0x23101 },
	{ 0x4968, 0x230FF },
	{ 0x4969, 0x230FC },
	{ 0x496A, 0x23100 },
	{ 0x496B, 0x23135 },
	{ 0x496C, 0x231EE },
	{ 0x496D, 0x231EF },
	{ 0x496E, 0x231F6 },
	{ 0x496F, 0x231E8 },
	{ 0x4970, 0x231EA },
	{ 0x4971, 0x231E3 },
	{ 0x4972, 0x2321F },
	{ 0x4973, 0x3AFC },
	{ 0x4974, 0x231E4 },
	{ 0x4975, 0x231FA },
	{ 0x4976, 0x231F1 },
	{ 0x4977, 0x231FB },
	{ 0x4978, 0x2F8D4 },
	{ 0x4979, 0x2333D },
	{ 0x497A, 0x2333C },
	{ 0x497B, 0x3479 },
	{ 0x497C, 0x23378 },
	{ 0x497D, 0x23377 },
	{ 0x497E, 0x440B },
	{ 0x4A21, 0x234D1 },
	{ 0x4A22, 0x234C7 },
	{ 0x4A23, 0x234DF },
	{ 0x4A24, 0x234D0 },
	{ 0x4A25, 0x234E0 },
	{ 0x4A26, 0x234D6 },
	{ 0x4A27, 0x234D8 },
	{ 0x4A28, 0x23516 },
	{ 0x4A29, 0x2350E },
	{ 0x4A2A, 0x234D9 },
	{ 0x4A2B, 0x2350F },
	{ 0x4A2C, 0x23511 },
	{ 0x4A2D, 0x234CD },
	{ 0x4A2E, 0x23489 },
	{ 0x4A2F, 0x234CE },
	{ 0x4A30, 0x23514 },
	{ 0x4A31, 0x234DA },
	{ 0x4A32, 0x23512 },
	{ 0x4A33, 0x234D3 },
	{ 0x4A34, 0x234C2 },
	{ 0x4A35, 0x234E1 },
	{ 0x4A36, 0x234E9 },
	{ 0x4A37, 0x234EA },
	{ 0x4A38, 0x234DE },
	{ 0x4A39, 0x23515 },
	{ 0x4A3A, 0x238D9 },
	{ 0x4A3B, 0x238D6 },
	{ 0x4A3C, 0x238CD },
	{ 0x4A3D, 0x238D0 },
	{ 0x4A3E, 0x238D3 },
	{ 0x4A3F, 0x2F8F0 },
	{ 0x4A40, 0x23982 },
	{ 0x4A41, 0x23985 },
	{ 0x4A42, 0x2397F },
	{ 0x4A43, 0x2397D },
	{ 0x4A44, 0x23981 },
	{ 0x4A45, 0x23983 },
	{ 0x4A46, 0x23984 },
	{ 0x4A47, 0x284A0 },
	{ 0x4A48, 0x23A28 },
	{ 0x4A49, 0x23A0F },
	{ 0x4A4A, 0x23A17 },
	{ 0x4A4B, 0x23A1A },
	{ 0x4A4C, 0x23A25 },
	{ 0x4A4D, 0x2F8F7 },
	{ 0x4A4E, 0x23A9B },
	{ 0x4A4F, 0x23A99 },
	{ 0x4A50, 0x23B92 },
	{ 0x4A51, 0x23B8C },
	{ 0x4A52, 0x23B95 },
	{ 0x4A53, 0x23B8D },
	{ 0x4A54, 0x23BA3 },
	{ 0x4A55, 0x23B93 },
	{ 0x4A56, 0x23B91 },
	{ 0x4A57, 0x23DDB },
	{ 0x4A58, 0x23D99 },
	{ 0x4A59, 0x23D9A },
	{ 0x4A5A, 0x23E08 },
	{ 0x4A5B, 0x23E4C },
	{ 0x4A5C, 0x23E0D },
	{ 0x4A5D, 0x23E01 },
	{ 0x4A5E, 0x23E4E },
	{ 0x4A5F, 0x23E02 },
	{ 0x4A60, 0x23E4D },
	{ 0x4A61, 0x23E21 },
	{ 0x4A62, 0x23DFC },
	{ 0x4A63, 0x2F909 },
	{ 0x4A64, 0x23D8A },
	{ 0x4A65, 0x2F908 },
	{ 0x4A66, 0x23D95 },
	{ 0x4A67, 0x23E11 },
	{ 0x4A68, 0x23E12 },
	{ 0x4A69, 0x23E46 },
	{ 0x4A6A, 0x23E1C },
	{ 0x4A6B, 0x23E49 },
	{ 0x4A6C, 0x23E0C },
	{ 0x4A6D, 0x3D1E },
	{ 0x4A6E, 0x23E13 },
	{ 0x4A6F, 0x23E16 },
	{ 0x4A70, 0x23DFD },
	{ 0x4A71, 0x23E0F },
	{ 0x4A72, 0x23E1F },
	{ 0x4A73, 0x24230 },
	{ 0x4A74, 0x2426E },
	{ 0x4A75, 0x2426B },
	{ 0x4A76, 0x2429B },
	{ 0x4A77, 0x2427B },
	{ 0x4A78, 0x24263 },
	{ 0x4A79, 0x24297 },
	{ 0x4A7A, 0x2426D },
	{ 0x4A7B, 0x2429C },
	{ 0x4A7C, 0x24298 },
	{ 0x4A7D, 0x2426F },
	{ 0x4A7E, 0x24267 },
	{ 0x4B21, 0x24269 },
	{ 0x4B22, 0x24515 },
	{ 0x4B23, 0x24563 },
	{ 0x4B24, 0x24586 },
	{ 0x4B25, 0x2458A },
	{ 0x4B26, 0x24587 },
	{ 0x4B27, 0x24588 },
	{ 0x4B28, 0x24585 },
	{ 0x4B29, 0x24589 },
	{ 0x4B2A, 0x245CA },
	{ 0x4B2B, 0x245C7 },
	{ 0x4B2C, 0x245CB },
	{ 0x4B2D, 0x245CC },
	{ 0x4B2E, 0x245C9 },
	{ 0x4B2F, 0x2460D },
	{ 0x4B30, 0x24683 },
	{ 0x4B31, 0x24684 },
	{ 0x4B32, 0x24678 },
	{ 0x4B33, 0x24682 },
	{ 0x4B34, 0x24673 },
	{ 0x4B35, 0x24679 },
	{ 0x4B36, 0x2468C },
	{ 0x4B37, 0x247D0 },
	{ 0x4B38, 0x247CF },
	{ 0x4B39, 0x247D2 },
	{ 0x4B3A, 0x247D9 },
	{ 0x4B3B, 0x247CC },
	{ 0x4B3C, 0x247EB },
	{ 0x4B3D, 0x247FD },
	{ 0x4B3E, 0x247EC },
	{ 0x4B3F, 0x247E8 },
	{ 0x4B40, 0x247F8 },
	{ 0x4B41, 0x247FA },
	{ 0x4B42, 0x2F927 },
	{ 0x4B43, 0x3E85 },
	{ 0x4B44, 0x247E1 },
	{ 0x4B45, 0x247FB },
	{ 0x4B46, 0x248E7 },
	{ 0x4B47, 0x2F92E },
	{ 0x4B48, 0x249A5 },
	{ 0x4B49, 0x24991 },
	{ 0x4B4A, 0x249A6 },
	{ 0x4B4B, 0x2497C },
	{ 0x4B4C, 0x24992 },
	{ 0x4B4D, 0x249A2 },
	{ 0x4B4E, 0x249A0 },
	{ 0x4B4F, 0x24AFC },
	{ 0x4B50, 0x24AFE },
	{ 0x4B51, 0x24B57 },
	{ 0x4B52, 0x24B53 },
	{ 0x4B53, 0x24B58 },
	{ 0x4B54, 0x24BE7 },
	{ 0x4B55, 0x24C8E },
	{ 0x4B56, 0x2F938 },
	{ 0x4B57, 0x24C83 },
	{ 0x4B58, 0x24C8B },
	{ 0x4B59, 0x24C84 },
	{ 0x4B5A, 0x3F97 },
	{ 0x4B5B, 0x24DA2 },
	{ 0x4B5C, 0x24DB7 },
	{ 0x4B5D, 0x24DA9 },
	{ 0x4B5E, 0x24DA5 },
	{ 0x4B5F, 0x24D9F },
	{ 0x4B60, 0x24DAA },
	{ 0x4B61, 0x24D97 },
	{ 0x4B62, 0x24DA1 },
	{ 0x4B63, 0x24D9E },
	{ 0x4B64, 0x24DAB },
	{ 0x4B65, 0x24D99 },
	{ 0x4B66, 0x24DA3 },
	{ 0x4B67, 0x24F30 },
	{ 0x4B68, 0x24F32 },
	{ 0x4B69, 0x24F2F },
	{ 0x4B6A, 0x24F70 },
	{ 0x4B6B, 0x24F6C },
	{ 0x4B6C, 0x24F6F },
	{ 0x4B6D, 0x24FE8 },
	{ 0x4B6E, 0x24FEE },
	{ 0x4B6F, 0x24FEA },
	{ 0x4B70, 0x2506D },
	{ 0x4B71, 0x25076 },
	{ 0x4B72, 0x25070 },
	{ 0x4B73, 0x25071 },
	{ 0x4B74, 0x2506C },
	{ 0x4B75, 0x251EB },
	{ 0x4B76, 0x251B5 },
	{ 0x4B77, 0x25196 },
	{ 0x4B78, 0x25190 },
	{ 0x4B79, 0x2518D },
	{ 0x4B7A, 0x2F949 },
	{ 0x4B7B, 0x251A2 },
	{ 0x4B7C, 0x251B0 },
	{ 0x4B7D, 0x25192 },
	{ 0x4B7E, 0x251A0 },
	{ 0x4C21, 0x25193 },
	{ 0x4C22, 0x251C3 },
	{ 0x4C23, 0x2518E },
	{ 0x4C24, 0x251B6 },
	{ 0x4C25, 0x2519D },
	{ 0x4C26, 0x25195 },
	{ 0x4C27, 0x251B3 },
	{ 0x4C28, 0x251A4 },
	{ 0x4C29, 0x25370 },
	{ 0x4C2A, 0x253D4 },
	{ 0x4C2B, 0x4093 },
	{ 0x4C2C, 0x253CF },
	{ 0x4C2D, 0x20170 },
	{ 0x4C2E, 0x25494 },
	{ 0x4C2F, 0x7861 },
	{ 0x4C30, 0x254C0 },
	{ 0x4C31, 0x254B4 },
	{ 0x4C32, 0x254C1 },
	{ 0x4C33, 0x40B2 },
	{ 0x4C34, 0x254BD },
	{ 0x4C35, 0x254AF },
	{ 0x4C36, 0x25677 },
	{ 0x4C37, 0x25678 },
	{ 0x4C38, 0x2566B },
	{ 0x4C39, 0x2566D },
	{ 0x4C3A, 0x2566E },
	{ 0x4C3B, 0x25672 },
	{ 0x4C3C, 0x2566F },
	{ 0x4C3D, 0x25671 },
	{ 0x4C3E, 0x230AB },
	{ 0x4C3F, 0x2568C },
	{ 0x4C40, 0x2573F },
	{ 0x4C41, 0x257B6 },
	{ 0x4C42, 0x257B7 },
	{ 0x4C43, 0x7A06 },
	{ 0x4C44, 0x257BB },
	{ 0x4C45, 0x257B8 },
	{ 0x4C46, 0x2079C },
	{ 0x4C47, 0x257B9 },
	{ 0x4C48, 0x7A01 },
	{ 0x4C49, 0x2598B },
	{ 0x4C4A, 0x2597A },
	{ 0x4C4B, 0x25984 },
	{ 0x4C4C, 0x25988 },
	{ 0x4C4D, 0x25991 },
	{ 0x4C4E, 0x25979 },
	{ 0x4C4F, 0x2598E },
	{ 0x4C50, 0x25980 },
	{ 0x4C51, 0x25982 },
	{ 0x4C52, 0x2597C },
	{ 0x4C53, 0x41A4 },
	{ 0x4C54, 0x25A84 },
	{ 0x4C55, 0x25A7F },
	{ 0x4C56, 0x41F2 },
	{ 0x4C57, 0x25B3B },
	{ 0x4C58, 0x25B71 },
	{ 0x4C59, 0x25B3D },
	{ 0x4C5A, 0x25B30 },
	{ 0x4C5B, 0x41F1 },
	{ 0x4C5C, 0x25B3E },
	{ 0x4C5D, 0x25B38 },
	{ 0x4C5E, 0x25E5E },
	{ 0x4C5F, 0x25E64 },
	{ 0x4C60, 0x4281 },
	{ 0x4C61, 0x25E5D },
	{ 0x4C62, 0x25E6D },
	{ 0x4C63, 0x25E4F },
	{ 0x4C64, 0x25E62 },
	{ 0x4C65, 0x25E5F },
	{ 0x4C66, 0x25FEC },
	{ 0x4C67, 0x25FF2 },
	{ 0x4C68, 0x25FF4 },
	{ 0x4C69, 0x25FF7 },
	{ 0x4C6A, 0x25FF6 },
	{ 0x4C6B, 0x26007 },
	{ 0x4C6C, 0x25FED },
	{ 0x4C6D, 0x25FEA },
	{ 0x4C6E, 0x25FF0 },
	{ 0x4C6F, 0x25FF8 },
	{ 0x4C70, 0x25FF3 },
	{ 0x4C71, 0x42DC },
	{ 0x4C72, 0x2F972 },
	{ 0x4C73, 0x26231 },
	{ 0x4C74, 0x2622F },
	{ 0x4C75, 0x262B6 },
	{ 0x4C76, 0x262AE },
	{ 0x4C77, 0x262AA },
	{ 0x4C78, 0x262BF },
	{ 0x4C79, 0x262CC },
	{ 0x4C7A, 0x262C7 },
	{ 0x4C7B, 0x26C83 },
	{ 0x4C7C, 0x26380 },
	{ 0x4C7D, 0x2637B },
	{ 0x4C7E, 0x2637F },
	{ 0x4D21, 0x2637D },
	{ 0x4D22, 0x26383 },
	{ 0x4D23, 0x2F978 },
	{ 0x4D24, 0x26446 },
	{ 0x4D25, 0x2642D },
	{ 0x4D26, 0x26425 },
	{ 0x4D27, 0x26426 },
	{ 0x4D28, 0x2642C },
	{ 0x4D29, 0x26437 },
	{ 0x4D2A, 0x26431 },
	{ 0x4D2B, 0x26433 },
	{ 0x4D2C, 0x26432 },
	{ 0x4D2D, 0x26427 },
	{ 0x4D2E, 0x2642A },
	{ 0x4D2F, 0x2642E },
	{ 0x4D30, 0x2642F },
	{ 0x4D31, 0x264C0 },
	{ 0x4D32, 0x26571 },
	{ 0x4D33, 0x26561 },
	{ 0x4D34, 0x26562 },
	{ 0x4D35, 0x26566 },
	{ 0x4D36, 0x26618 },
	{ 0x4D37, 0x266C5 },
	{ 0x4D38, 0x266C3 },
	{ 0x4D39, 0x266C4 },
	{ 0x4D3A, 0x266C2 },
	{ 0x4D3B, 0x266AE },
	{ 0x4D3C, 0x26710 },
	{ 0x4D3D, 0x26708 },
	{ 0x4D3E, 0x2671F },
	{ 0x4D3F, 0x2673A },
	{ 0x4D40, 0x2673B },
	{ 0x4D41, 0x26736 },
	{ 0x4D42, 0x2670C },
	{ 0x4D43, 0x26706 },
	{ 0x4D44, 0x2672A },
	{ 0x4D45, 0x26757 },
	{ 0x4D46, 0x26750 },
	{ 0x4D47, 0x26720 },
	{ 0x4D48, 0x2F985 },
	{ 0x4D49, 0x2672C },
	{ 0x4D4A, 0x26721 },
	{ 0x4D4B, 0x2670B },
	{ 0x4D4C, 0x26719 },
	{ 0x4D4D, 0x26735 },
	{ 0x4D4E, 0x26718 },
	{ 0x4D4F, 0x2670F },
	{ 0x4D50, 0x26713 },
	{ 0x4D51, 0x26755 },
	{ 0x4D52, 0x26739 },
	{ 0x4D53, 0x2671A },
	{ 0x4D54, 0x440C },
	{ 0x4D55, 0x26717 },
	{ 0x4D56, 0x268E4 },
	{ 0x4D57, 0x268E9 },
	{ 0x4D58, 0x2458B },
	{ 0x4D59, 0x26910 },
	{ 0x4D5A, 0x26912 },
	{ 0x4D5B, 0x2693F },
	{ 0x4D5C, 0x2696E },
	{ 0x4D5D, 0x24518 },
	{ 0x4D5E, 0x2F98C },
	{ 0x4D5F, 0x269D6 },
	{ 0x4D60, 0x269D5 },
	{ 0x4D61, 0x269D7 },
	{ 0x4D62, 0x20B02 },
	{ 0x4D63, 0x446D },
	{ 0x4D64, 0x26A31 },
	{ 0x4D65, 0x26A30 },
	{ 0x4D66, 0x26A3A },
	{ 0x4D67, 0x26B85 },
	{ 0x4D68, 0x26B6B },
	{ 0x4D69, 0x26C48 },
	{ 0x4D6A, 0x26C4B },
	{ 0x4D6B, 0x26C37 },
	{ 0x4D6C, 0x26C7B },
	{ 0x4D6D, 0x26C6C },
	{ 0x4D6E, 0x26C85 },
	{ 0x4D6F, 0x26C65 },
	{ 0x4D70, 0x26C36 },
	{ 0x4D71, 0x26C86 },
	{ 0x4D72, 0x26C34 },
	{ 0x4D73, 0x26C68 },
	{ 0x4D74, 0x26C5A },
	{ 0x4D75, 0x26C58 },
	{ 0x4D76, 0x26C72 },
	{ 0x4D77, 0x26C6A },
	{ 0x4D78, 0x26BD3 },
	{ 0x4D79, 0x26C3C },
	{ 0x4D7A, 0x26C33 },
	{ 0x4D7B, 0x26C3B },
	{ 0x4D7C, 0x26C4D },
	{ 0x4D7D, 0x26C4F },
	{ 0x4D7E, 0x26C7C },
	{ 0x4E21, 0x26CB0 },
	{ 0x4E22, 0x26C5B },
	{ 0x4E23, 0x26C55 },
	{ 0x4E24, 0x26C64 },
	{ 0x4E25, 0x26C6B },
	{ 0x4E26, 0x26C53 },
	{ 0x4E27, 0x44E6 },
	{ 0x4E28, 0x26C57 },
	{ 0x4E29, 0x26C5E },
	{ 0x4E2A, 0x26C6D },
	{ 0x4E2B, 0x26C35 },
	{ 0x4E2C, 0x26C69 },
	{ 0x4E2D, 0x26C59 },
	{ 0x4E2E, 0x26C66 },
	{ 0x4E2F, 0x26C50 },
	{ 0x4E30, 0x26C51 },
	{ 0x4E31, 0x26C5C },
	{ 0x4E32, 0x26D5D },
	{ 0x4E33, 0x26C87 },
	{ 0x4E34, 0x26C78 },
	{ 0x4E35, 0x26C49 },
	{ 0x4E36, 0x26C4E },
	{ 0x4E37, 0x26BF1 },
	{ 0x4E38, 0x26C73 },
	{ 0x4E39, 0x26C88 },
	{ 0x4E3A, 0x26BCF },
	{ 0x4E3B, 0x2F9A4 },
	{ 0x4E3C, 0x271B1 },
	{ 0x4E3D, 0x271B3 },
	{ 0x4E3E, 0x2729C },
	{ 0x4E3F, 0x272A4 },
	{ 0x4E40, 0x27290 },
	{ 0x4E41, 0x272B8 },
	{ 0x4E42, 0x272A0 },
	{ 0x4E43, 0x2729D },
	{ 0x4E44, 0x272A8 },
	{ 0x4E45, 0x272A9 },
	{ 0x4E46, 0x2F9B9 },
	{ 0x4E47, 0x272B1 },
	{ 0x4E48, 0x27293 },
	{ 0x4E49, 0x2729B },
	{ 0x4E4A, 0x272A2 },
	{ 0x4E4B, 0x272A1 },
	{ 0x4E4C, 0x272B0 },
	{ 0x4E4D, 0x272A7 },
	{ 0x4E4E, 0x275B3 },
	{ 0x4E4F, 0x8849 },
	{ 0x4E50, 0x275B4 },
	{ 0x4E51, 0x275F1 },
	{ 0x4E52, 0x275ED },
	{ 0x4E53, 0x275EC },
	{ 0x4E54, 0x27668 },
	{ 0x4E55, 0x27675 },
	{ 0x4E56, 0x2766A },
	{ 0x4E57, 0x27662 },
	{ 0x4E58, 0x27667 },
	{ 0x4E59, 0x27660 },
	{ 0x4E5A, 0x27677 },
	{ 0x4E5B, 0x2765F },
	{ 0x4E5C, 0x27679 },
	{ 0x4E5D, 0x27823 },
	{ 0x4E5E, 0x27821 },
	{ 0x4E5F, 0x2781C },
	{ 0x4E60, 0x8999 },
	{ 0x4E61, 0x2781F },
	{ 0x4E62, 0x2781E },
	{ 0x4E63, 0x278D6 },
	{ 0x4E64, 0x278D3 },
	{ 0x4E65, 0x278D9 },
	{ 0x4E66, 0x278D7 },
	{ 0x4E67, 0x278D4 },
	{ 0x4E68, 0x278DC },
	{ 0x4E69, 0x278D8 },
	{ 0x4E6A, 0x279A3 },
	{ 0x4E6B, 0x46D1 },
	{ 0x4E6C, 0x279BE },
	{ 0x4E6D, 0x279A9 },
	{ 0x4E6E, 0x279A1 },
	{ 0x4E6F, 0x279A0 },
	{ 0x4E70, 0x279AB },
	{ 0x4E71, 0x279A2 },
	{ 0x4E72, 0x279BA },
	{ 0x4E73, 0x279C2 },
	{ 0x4E74, 0x2799C },
	{ 0x4E75, 0x279BB },
	{ 0x4E76, 0x279AA },
	{ 0x4E77, 0x279AC },
	{ 0x4E78, 0x279A5 },
	{ 0x4E79, 0x279C1 },
	{ 0x4E7A, 0x472C },
	{ 0x4E7B, 0x27BE2 },
	{ 0x4E7C, 0x27C36 },
	{ 0x4E7D, 0x27C3D },
	{ 0x4E7E, 0x27C3A },
	{ 0x4F21, 0x22461 },
	{ 0x4F22, 0x27C48 },
	{ 0x4F23, 0x27C3C },
	{ 0x4F24, 0x27CB7 },
	{ 0x4F25, 0x27CAC },
	{ 0x4F26, 0x27CB3 },
	{ 0x4F27, 0x27CB6 },
	{ 0x4F28, 0x27CB2 },
	{ 0x4F29, 0x476E },
	{ 0x4F2A, 0x27D5D },
	{ 0x4F2B, 0x27D49 },
	{ 0x4F2C, 0x27D4E },
	{ 0x4F2D, 0x27D4F },
	{ 0x4F2E, 0x27D4D },
	{ 0x4F2F, 0x27D5C },
	{ 0x4F30, 0x27E5D },
	{ 0x4F31, 0x27EBB },
	{ 0x4F32, 0x27ECE },
	{ 0x4F33, 0x27EBF },
	{ 0x4F34, 0x27EBA },
	{ 0x4F35, 0x27EC3 },
	{ 0x4F36, 0x47E5 },
	{ 0x4F37, 0x28006 },
	{ 0x4F38, 0x27FF8 },
	{ 0x4F39, 0x27FFE },
	{ 0x4F3A, 0x28013 },
	{ 0x4F3B, 0x27FF6 },
	{ 0x4F3C, 0x47E6 },
	{ 0x4F3D, 0x28234 },
	{ 0x4F3E, 0x2822D },
	{ 0x4F3F, 0x2822A },
	{ 0x4F40, 0x28235 },
	{ 0x4F41, 0x2822C },
	{ 0x4F42, 0x282D4 },
	{ 0x4F43, 0x282DA },
	{ 0x4F44, 0x282D3 },
	{ 0x4F45, 0x282D2 },
	{ 0x4F46, 0x282CE },
	{ 0x4F47, 0x282CF },
	{ 0x4F48, 0x489F },
	{ 0x4F49, 0x284FD },
	{ 0x4F4A, 0x2850B },
	{ 0x4F4B, 0x284FE },
	{ 0x4F4C, 0x284F8 },
	{ 0x4F4D, 0x284F7 },
	{ 0x4F4E, 0x28517 },
	{ 0x4F4F, 0x284FA },
	{ 0x4F50, 0x284F9 },
	{ 0x4F51, 0x28500 },
	{ 0x4F52, 0x284F5 },
	{ 0x4F53, 0x284F1 },
	{ 0x4F54, 0x28503 },
	{ 0x4F55, 0x28505 },
	{ 0x4F56, 0x2851C },
	{ 0x4F57, 0x286AC },
	{ 0x4F58, 0x2869A },
	{ 0x4F59, 0x286AD },
	{ 0x4F5A, 0x286A0 },
	{ 0x4F5B, 0x2871B },
	{ 0x4F5C, 0x28725 },
	{ 0x4F5D, 0x28724 },
	{ 0x4F5E, 0x28726 },
	{ 0x4F5F, 0x28727 },
	{ 0x4F60, 0x28728 },
	{ 0x4F61, 0x2872A },
	{ 0x4F62, 0x2871A },
	{ 0x4F63, 0x2872E },
	{ 0x4F64, 0x28715 },
	{ 0x4F65, 0x28815 },
	{ 0x4F66, 0x28814 },
	{ 0x4F67, 0x28817 },
	{ 0x4F68, 0x28818 },
	{ 0x4F69, 0x2880F },
	{ 0x4F6A, 0x28813 },
	{ 0x4F6B, 0x2880B },
	{ 0x4F6C, 0x28822 },
	{ 0x4F6D, 0x2137A },
	{ 0x4F6E, 0x28926 },
	{ 0x4F6F, 0x921F },
	{ 0x4F70, 0x28951 },
	{ 0x4F71, 0x2894D },
	{ 0x4F72, 0x2894E },
	{ 0x4F73, 0x2894A },
	{ 0x4F74, 0x2894B },
	{ 0x4F75, 0x2894C },
	{ 0x4F76, 0x28950 },
	{ 0x4F77, 0x28962 },
	{ 0x4F78, 0x2894F },
	{ 0x4F79, 0x28952 },
	{ 0x4F7A, 0x28C68 },
	{ 0x4F7B, 0x28C69 },
	{ 0x4F7C, 0x28CE5 },
	{ 0x4F7D, 0x28CF0 },
	{ 0x4F7E, 0x28CE1 },
	{ 0x5021, 0x28CE2 },
	{ 0x5022, 0x2F9F2 },
	{ 0x5023, 0x28EA5 },
	{ 0x5024, 0x28EA9 },
	{ 0x5025, 0x28EA4 },
	{ 0x5026, 0x28EAF },
	{ 0x5027, 0x28EAC },
	{ 0x5028, 0x28EAE },
	{ 0x5029, 0x28EAA },
	{ 0x502A, 0x28F95 },
	{ 0x502B, 0x28F99 },
	{ 0x502C, 0x28F93 },
	{ 0x502D, 0x28F9D },
	{ 0x502E, 0x28F98 },
	{ 0x502F, 0x28F9C },
	{ 0x5030, 0x28F97 },
	{ 0x5031, 0x4A0D },
	{ 0x5032, 0x29089 },
	{ 0x5033, 0x29087 },
	{ 0x5034, 0x291D7 },
	{ 0x5035, 0x291ED },
	{ 0x5036, 0x291F1 },
	{ 0x5037, 0x291F0 },
	{ 0x5038, 0x29205 },
	{ 0x5039, 0x29203 },
	{ 0x503A, 0x29204 },
	{ 0x503B, 0x2925F },
	{ 0x503C, 0x29457 },
	{ 0x503D, 0x2959C },
	{ 0x503E, 0x295A1 },
	{ 0x503F, 0x2959A },
	{ 0x5040, 0x2968F },
	{ 0x5041, 0x29693 },
	{ 0x5042, 0x2969E },
	{ 0x5043, 0x296A3 },
	{ 0x5044, 0x29698 },
	{ 0x5045, 0x29699 },
	{ 0x5046, 0x29695 },
	{ 0x5047, 0x2986E },
	{ 0x5048, 0x2986A },
	{ 0x5049, 0x29AF4 },
	{ 0x504A, 0x29AF7 },
	{ 0x504B, 0x29C79 },
	{ 0x504C, 0x29F8F },
	{ 0x504D, 0x29F91 },
	{ 0x504E, 0x2A00B },
	{ 0x504F, 0x2A502 },
	{ 0x5050, 0x20084 },
	{ 0x5051, 0x20104 },
	{ 0x5052, 0x20180 },
	{ 0x5053, 0x2032F },
	{ 0x5054, 0x2033F },
	{ 0x5055, 0x2033B },
	{ 0x5056, 0x20362 },
	{ 0x5057, 0x20344 },
	{ 0x5058, 0x20333 },
	{ 0x5059, 0x2035F },
	{ 0x505A, 0x2032B },
	{ 0x505B, 0x2F809 },
	{ 0x505C, 0x20339 },
	{ 0x505D, 0x20336 },
	{ 0x505E, 0x20348 },
	{ 0x505F, 0x20335 },
	{ 0x5060, 0x2036C },
	{ 0x5061, 0x20358 },
	{ 0x5062, 0x2033A },
	{ 0x5063, 0x204A8 },
	{ 0x5064, 0x204F4 },
	{ 0x5065, 0x20529 },
	{ 0x5066, 0x2059A },
	{ 0x5067, 0x20600 },
	{ 0x5068, 0x207BB },
	{ 0x5069, 0x207BD },
	{ 0x506A, 0x207B7 },
	{ 0x506B, 0x207B2 },
	{ 0x506C, 0x34F8 },
	{ 0x506D, 0x207A8 },
	{ 0x506E, 0x207AB },
	{ 0x506F, 0x207A6 },
	{ 0x5070, 0x207BC },
	{ 0x5071, 0x20897 },
	{ 0x5072, 0x20896 },
	{ 0x5073, 0x208F8 },
	{ 0x5074, 0x5313 },
	{ 0x5075, 0x20951 },
	{ 0x5076, 0x3533 },
	{ 0x5077, 0x209B5 },
	{ 0x5078, 0x209B4 },
	{ 0x5079, 0x209B6 },
	{ 0x507A, 0x353C },
	{ 0x507B, 0x209B7 },
	{ 0x507C, 0x20A05 },
	{ 0x507D, 0x20A23 },
	{ 0x507E, 0x20A95 },
	{ 0x5121, 0x20A98 },
	{ 0x5122, 0x354F },
	{ 0x5123, 0x20A94 },
	{ 0x5124, 0x20A93 },
	{ 0x5125, 0x20B07 },
	{ 0x5126, 0x20B73 },
	{ 0x5127, 0x20B71 },
	{ 0x5128, 0x20B72 },
	{ 0x5129, 0x20B78 },
	{ 0x512A, 0x20E5F },
	{ 0x512B, 0x20E6A },
	{ 0x512C, 0x20E67 },
	{ 0x512D, 0x20E6B },
	{ 0x512E, 0x20E69 },
	{ 0x512F, 0x20E8E },
	{ 0x5130, 0x20E49 },
	{ 0x5131, 0x20E80 },
	{ 0x5132, 0x35DC },
	{ 0x5133, 0x20E44 },
	{ 0x5134, 0x20E8F },
	{ 0x5135, 0x20E45 },
	{ 0x5136, 0x2F84C },
	{ 0x5137, 0x20E4F },
	{ 0x5138, 0x20E63 },
	{ 0x5139, 0x20E36 },
	{ 0x513A, 0x20E48 },
	{ 0x513B, 0x20E5C },
	{ 0x513C, 0x20E93 },
	{ 0x513D, 0x20E61 },
	{ 0x513E, 0x20E60 },
	{ 0x513F, 0x20E4E },
	{ 0x5140, 0x20E5E },
	{ 0x5141, 0x20E3F },
	{ 0x5142, 0x20EA4 },
	{ 0x5143, 0x55E0 },
	{ 0x5144, 0x20E68 },
	{ 0x5145, 0x2120B },
	{ 0x5146, 0x21211 },
	{ 0x5147, 0x2120D },
	{ 0x5148, 0x2120E },
	{ 0x5149, 0x213C2 },
	{ 0x514A, 0x2F857 },
	{ 0x514B, 0x213B0 },
	{ 0x514C, 0x213C3 },
	{ 0x514D, 0x213C8 },
	{ 0x514E, 0x21365 },
	{ 0x514F, 0x213D7 },
	{ 0x5150, 0x213BD },
	{ 0x5151, 0x213B8 },
	{ 0x5152, 0x213B6 },
	{ 0x5153, 0x213C7 },
	{ 0x5154, 0x213BC },
	{ 0x5155, 0x213B1 },
	{ 0x5156, 0x213AF },
	{ 0x5157, 0x2F85B },
	{ 0x5158, 0x21535 },
	{ 0x5159, 0x21530 },
	{ 0x515A, 0x2155D },
	{ 0x515B, 0x20B76 },
	{ 0x515C, 0x2156F },
	{ 0x515D, 0x215B0 },
	{ 0x515E, 0x2F85E },
	{ 0x515F, 0x215B4 },
	{ 0x5160, 0x2165C },
	{ 0x5161, 0x2165D },
	{ 0x5162, 0x21808 },
	{ 0x5163, 0x217EE },
	{ 0x5164, 0x2180B },
	{ 0x5165, 0x217F2 },
	{ 0x5166, 0x217FD },
	{ 0x5167, 0x217F1 },
	{ 0x5168, 0x21810 },
	{ 0x5169, 0x2F868 },
	{ 0x516A, 0x21814 },
	{ 0x516B, 0x2198B },
	{ 0x516C, 0x2198C },
	{ 0x516D, 0x21985 },
	{ 0x516E, 0x21A7A },
	{ 0x516F, 0x21A6C },
	{ 0x5170, 0x21A60 },
	{ 0x5171, 0x21A67 },
	{ 0x5172, 0x21A66 },
	{ 0x5173, 0x21A6A },
	{ 0x5174, 0x21A5F },
	{ 0x5175, 0x21A6D },
	{ 0x5176, 0x21A68 },
	{ 0x5177, 0x21A64 },
	{ 0x5178, 0x21B3A },
	{ 0x5179, 0x21B3B },
	{ 0x517A, 0x21B39 },
	{ 0x517B, 0x21C02 },
	{ 0x517C, 0x21C04 },
	{ 0x517D, 0x21C03 },
	{ 0x517E, 0x21CB4 },
	{ 0x5221, 0x21CB3 },
	{ 0x5222, 0x21CBB },
	{ 0x5223, 0x21CAC },
	{ 0x5224, 0x21CB6 },
	{ 0x5225, 0x21CB1 },
	{ 0x5226, 0x21CAF },
	{ 0x5227, 0x21CB5 },
	{ 0x5228, 0x21CBE },
	{ 0x5229, 0x21CB2 },
	{ 0x522A, 0x21D24 },
	{ 0x522B, 0x21EB6 },
	{ 0x522C, 0x21EB9 },
	{ 0x522D, 0x21EAC },
	{ 0x522E, 0x21EB0 },
	{ 0x522F, 0x21ED7 },
	{ 0x5230, 0x21EBB },
	{ 0x5231, 0x21EFE },
	{ 0x5232, 0x21ECB },
	{ 0x5233, 0x2F87F },
	{ 0x5234, 0x37F5 },
	{ 0x5235, 0x21EB3 },
	{ 0x5236, 0x21EBE },
	{ 0x5237, 0x21ECD },
	{ 0x5238, 0x21EBC },
	{ 0x5239, 0x21EBA },
	{ 0x523A, 0x21EC7 },
	{ 0x523B, 0x22116 },
	{ 0x523C, 0x2211B },
	{ 0x523D, 0x22117 },
	{ 0x523E, 0x22115 },
	{ 0x523F, 0x2219F },
	{ 0x5240, 0x2F88E },
	{ 0x5241, 0x22282 },
	{ 0x5242, 0x22283 },
	{ 0x5243, 0x2228E },
	{ 0x5244, 0x2226A },
	{ 0x5245, 0x22289 },
	{ 0x5246, 0x22294 },
	{ 0x5247, 0x22286 },
	{ 0x5248, 0x22290 },
	{ 0x5249, 0x22362 },
	{ 0x524A, 0x22390 },
	{ 0x524B, 0x2240C },
	{ 0x524C, 0x2240F },
	{ 0x524D, 0x38C3 },
	{ 0x524E, 0x224A5 },
	{ 0x524F, 0x224A7 },
	{ 0x5250, 0x224A6 },
	{ 0x5251, 0x224A4 },
	{ 0x5252, 0x22535 },
	{ 0x5253, 0x22538 },
	{ 0x5254, 0x22536 },
	{ 0x5255, 0x22543 },
	{ 0x5256, 0x22547 },
	{ 0x5257, 0x22537 },
	{ 0x5258, 0x22743 },
	{ 0x5259, 0x227A2 },
	{ 0x525A, 0x22751 },
	{ 0x525B, 0x22772 },
	{ 0x525C, 0x2276D },
	{ 0x525D, 0x2272F },
	{ 0x525E, 0x22754 },
	{ 0x525F, 0x2276E },
	{ 0x5260, 0x22755 },
	{ 0x5261, 0x22737 },
	{ 0x5262, 0x2274F },
	{ 0x5263, 0x22750 },
	{ 0x5264, 0x6139 },
	{ 0x5265, 0x2279E },
	{ 0x5266, 0x2F8A8 },
	{ 0x5267, 0x227B3 },
	{ 0x5268, 0x227A7 },
	{ 0x5269, 0x3971 },
	{ 0x526A, 0x227F9 },
	{ 0x526B, 0x22791 },
	{ 0x526C, 0x2F8A7 },
	{ 0x526D, 0x227B6 },
	{ 0x526E, 0x227DD },
	{ 0x526F, 0x22799 },
	{ 0x5270, 0x229DF },
	{ 0x5271, 0x229D5 },
	{ 0x5272, 0x247F5 },
	{ 0x5273, 0x22C28 },
	{ 0x5274, 0x22C40 },
	{ 0x5275, 0x22C71 },
	{ 0x5276, 0x22C98 },
	{ 0x5277, 0x22C95 },
	{ 0x5278, 0x22C65 },
	{ 0x5279, 0x22C78 },
	{ 0x527A, 0x22C7F },
	{ 0x527B, 0x22C60 },
	{ 0x527C, 0x22C7C },
	{ 0x527D, 0x22C96 },
	{ 0x527E, 0x22C6A },
	{ 0x5321, 0x22C79 },
	{ 0x5322, 0x22C73 },
	{ 0x5323, 0x22C72 },
	{ 0x5324, 0x22C7B },
	{ 0x5325, 0x22C70 },
	{ 0x5326, 0x22ED5 },
	{ 0x5327, 0x22ED7 },
	{ 0x5328, 0x22F8F },
	{ 0x5329, 0x22F89 },
	{ 0x532A, 0x22F9E },
	{ 0x532B, 0x22F87 },
	{ 0x532C, 0x22FA0 },
	{ 0x532D, 0x22F8D },
	{ 0x532E, 0x22F88 },
	{ 0x532F, 0x22F7F },
	{ 0x5330, 0x22F8C },
	{ 0x5331, 0x22F93 },
	{ 0x5332, 0x23059 },
	{ 0x5333, 0x295B0 },
	{ 0x5334, 0x230B1 },
	{ 0x5335, 0x251F4 },
	{ 0x5336, 0x230AF },
	{ 0x5337, 0x230B2 },
	{ 0x5338, 0x23108 },
	{ 0x5339, 0x2310A },
	{ 0x533A, 0x23136 },
	{ 0x533B, 0x23137 },
	{ 0x533C, 0x2F8CF },
	{ 0x533D, 0x3B01 },
	{ 0x533E, 0x23236 },
	{ 0x533F, 0x23229 },
	{ 0x5340, 0x2324A },
	{ 0x5341, 0x23226 },
	{ 0x5342, 0x23228 },
	{ 0x5343, 0x23224 },
	{ 0x5344, 0x2322A },
	{ 0x5345, 0x23248 },
	{ 0x5346, 0x23344 },
	{ 0x5347, 0x23384 },
	{ 0x5348, 0x2338C },
	{ 0x5349, 0x234C4 },
	{ 0x534A, 0x234DC },
	{ 0x534B, 0x23587 },
	{ 0x534C, 0x23553 },
	{ 0x534D, 0x2357F },
	{ 0x534E, 0x23531 },
	{ 0x534F, 0x23551 },
	{ 0x5350, 0x2354B },
	{ 0x5351, 0x23552 },
	{ 0x5352, 0x23580 },
	{ 0x5353, 0x235A5 },
	{ 0x5354, 0x23581 },
	{ 0x5355, 0x23543 },
	{ 0x5356, 0x23534 },
	{ 0x5357, 0x23536 },
	{ 0x5358, 0x23532 },
	{ 0x5359, 0x23548 },
	{ 0x535A, 0x23549 },
	{ 0x535B, 0x2353C },
	{ 0x535C, 0x2354D },
	{ 0x535D, 0x2354A },
	{ 0x535E, 0x2F8E6 },
	{ 0x535F, 0x2358A },
	{ 0x5360, 0x23546 },
	{ 0x5361, 0x2353E },
	{ 0x5362, 0x23583 },
	{ 0x5363, 0x23550 },
	{ 0x5364, 0x235B4 },
	{ 0x5365, 0x238F0 },
	{ 0x5366, 0x238E4 },
	{ 0x5367, 0x238E3 },
	{ 0x5368, 0x238E5 },
	{ 0x5369, 0x238E6 },
	{ 0x536A, 0x238E7 },
	{ 0x536B, 0x238E1 },
	{ 0x536C, 0x238EF },
	{ 0x536D, 0x238E8 },
	{ 0x536E, 0x238DD },
	{ 0x536F, 0x23903 },
	{ 0x5370, 0x23988 },
	{ 0x5371, 0x23A26 },
	{ 0x5372, 0x23A16 },
	{ 0x5373, 0x23A3B },
	{ 0x5374, 0x23A2F },
	{ 0x5375, 0x23A39 },
	{ 0x5376, 0x23A34 },
	{ 0x5377, 0x2F8F4 },
	{ 0x5378, 0x23A35 },
	{ 0x5379, 0x23A31 },
	{ 0x537A, 0x23A38 },
	{ 0x537B, 0x20B81 },
	{ 0x537C, 0x23AAA },
	{ 0x537D, 0x23AA3 },
	{ 0x537E, 0x23AA4 },
	{ 0x5421, 0x23AA0 },
	{ 0x5422, 0x23AA1 },
	{ 0x5423, 0x23AA9 },
	{ 0x5424, 0x23AA5 },
	{ 0x5425, 0x23BAF },
	{ 0x5426, 0x23BB1 },
	{ 0x5427, 0x23BAB },
	{ 0x5428, 0x23BAE },
	{ 0x5429, 0x23BB0 },
	{ 0x542A, 0x23BB3 },
	{ 0x542B, 0x23BAC },
	{ 0x542C, 0x23BA9 },
	{ 0x542D, 0x23BB2 },
	{ 0x542E, 0x23BA8 },
	{ 0x542F, 0x23BB4 },
	{ 0x5430, 0x23BC2 },
	{ 0x5431, 0x23C4F },
	{ 0x5432, 0x23C66 },
	{ 0x5433, 0x23E1E },
	{ 0x5434, 0x23E15 },
	{ 0x5435, 0x23E10 },
	{ 0x5436, 0x23E7F },
	{ 0x5437, 0x23E7E },
	{ 0x5438, 0x23E60 },
	{ 0x5439, 0x23ECC },
	{ 0x543A, 0x23EB2 },
	{ 0x543B, 0x23E62 },
	{ 0x543C, 0x23E8D },
	{ 0x543D, 0x23E8E },
	{ 0x543E, 0x23E77 },
	{ 0x543F, 0x23E7C },
	{ 0x5440, 0x23E8F },
	{ 0x5441, 0x23E5D },
	{ 0x5442, 0x23E6D },
	{ 0x5443, 0x23E63 },
	{ 0x5444, 0x23EAF },
	{ 0x5445, 0x23E90 },
	{ 0x5446, 0x23E7D },
	{ 0x5447, 0x23E7A },
	{ 0x5448, 0x23E06 },
	{ 0x5449, 0x2F90B },
	{ 0x544A, 0x23E68 },
	{ 0x544B, 0x23EB4 },
	{ 0x544C, 0x23E78 },
	{ 0x544D, 0x23EB1 },
	{ 0x544E, 0x6ED7 },
	{ 0x544F, 0x2F90C },
	{ 0x5450, 0x3D41 },
	{ 0x5451, 0x242E8 },
	{ 0x5452, 0x242E9 },
	{ 0x5453, 0x242C0 },
	{ 0x5454, 0x3DD7 },
	{ 0x5455, 0x242EA },
	{ 0x5456, 0x242B7 },
	{ 0x5457, 0x242BA },
	{ 0x5458, 0x242B5 },
	{ 0x5459, 0x2F91D },
	{ 0x545A, 0x242B4 },
	{ 0x545B, 0x242BC },
	{ 0x545C, 0x242C6 },
	{ 0x545D, 0x242B8 },
	{ 0x545E, 0x242BD },
	{ 0x545F, 0x242C2 },
	{ 0x5460, 0x2434D },
	{ 0x5461, 0x242F0 },
	{ 0x5462, 0x242C7 },
	{ 0x5463, 0x242C1 },
	{ 0x5464, 0x242C3 },
	{ 0x5465, 0x242F1 },
	{ 0x5466, 0x242EC },
	{ 0x5467, 0x3DE2 },
	{ 0x5468, 0x2451C },
	{ 0x5469, 0x24520 },
	{ 0x546A, 0x24558 },
	{ 0x546B, 0x24565 },
	{ 0x546C, 0x24564 },
	{ 0x546D, 0x2458C },
	{ 0x546E, 0x2458D },
	{ 0x546F, 0x245D9 },
	{ 0x5470, 0x245E0 },
	{ 0x5471, 0x24610 },
	{ 0x5472, 0x24694 },
	{ 0x5473, 0x24692 },
	{ 0x5474, 0x24696 },
	{ 0x5475, 0x24695 },
	{ 0x5476, 0x246BF },
	{ 0x5477, 0x246A0 },
	{ 0x5478, 0x3E45 },
	{ 0x5479, 0x247F4 },
	{ 0x547A, 0x247F6 },
	{ 0x547B, 0x247DC },
	{ 0x547C, 0x733D },
	{ 0x547D, 0x24816 },
	{ 0x547E, 0x24815 },
	{ 0x5521, 0x2481C },
	{ 0x5522, 0x2480F },
	{ 0x5523, 0x2482C },
	{ 0x5524, 0x24814 },
	{ 0x5525, 0x24825 },
	{ 0x5526, 0x24817 },
	{ 0x5527, 0x24812 },
	{ 0x5528, 0x2481E },
	{ 0x5529, 0x24980 },
	{ 0x552A, 0x249A8 },
	{ 0x552B, 0x249AF },
	{ 0x552C, 0x249D6 },
	{ 0x552D, 0x249E2 },
	{ 0x552E, 0x249B4 },
	{ 0x552F, 0x249B3 },
	{ 0x5530, 0x249B0 },
	{ 0x5531, 0x249B2 },
	{ 0x5532, 0x249A1 },
	{ 0x5533, 0x24B60 },
	{ 0x5534, 0x24B66 },
	{ 0x5535, 0x24B61 },
	{ 0x5536, 0x24B4E },
	{ 0x5537, 0x24B5D },
	{ 0x5538, 0x24B63 },
	{ 0x5539, 0x24BE6 },
	{ 0x553A, 0x24BEF },
	{ 0x553B, 0x24BEC },
	{ 0x553C, 0x24C98 },
	{ 0x553D, 0x24CA7 },
	{ 0x553E, 0x24C94 },
	{ 0x553F, 0x24C95 },
	{ 0x5540, 0x24C91 },
	{ 0x5541, 0x24C9D },
	{ 0x5542, 0x24C99 },
	{ 0x5543, 0x24C9B },
	{ 0x5544, 0x24C9C },
	{ 0x5545, 0x24D1D },
	{ 0x5546, 0x24D1C },
	{ 0x5547, 0x24DD0 },
	{ 0x5548, 0x24DE0 },
	{ 0x5549, 0x24DCB },
	{ 0x554A, 0x24DDB },
	{ 0x554B, 0x24DDA },
	{ 0x554C, 0x24DC2 },
	{ 0x554D, 0x24DD3 },
	{ 0x554E, 0x24DE5 },
	{ 0x554F, 0x24F7D },
	{ 0x5550, 0x24F7B },
	{ 0x5551, 0x24FFF },
	{ 0x5552, 0x3FF2 },
	{ 0x5553, 0x24FF9 },
	{ 0x5554, 0x25077 },
	{ 0x5555, 0x2507C },
	{ 0x5556, 0x25078 },
	{ 0x5557, 0x2507B },
	{ 0x5558, 0x2507A },
	{ 0x5559, 0x251D2 },
	{ 0x555A, 0x251CB },
	{ 0x555B, 0x251C9 },
	{ 0x555C, 0x251CE },
	{ 0x555D, 0x251E4 },
	{ 0x555E, 0x251CA },
	{ 0x555F, 0x251D0 },
	{ 0x5560, 0x22FA5 },
	{ 0x5561, 0x4049 },
	{ 0x5562, 0x251D9 },
	{ 0x5563, 0x251EE },
	{ 0x5564, 0x251DD },
	{ 0x5565, 0x25200 },
	{ 0x5566, 0x251E1 },
	{ 0x5567, 0x253DE },
	{ 0x5568, 0x253E2 },
	{ 0x5569, 0x253DA },
	{ 0x556A, 0x254CE },
	{ 0x556B, 0x2F94F },
	{ 0x556C, 0x254CF },
	{ 0x556D, 0x254DA },
	{ 0x556E, 0x254D1 },
	{ 0x556F, 0x254D4 },
	{ 0x5570, 0x254ED },
	{ 0x5571, 0x254CB },
	{ 0x5572, 0x254D5 },
	{ 0x5573, 0x254F1 },
	{ 0x5574, 0x2569C },
	{ 0x5575, 0x25688 },
	{ 0x5576, 0x25741 },
	{ 0x5577, 0x257D0 },
	{ 0x5578, 0x257F7 },
	{ 0x5579, 0x257CF },
	{ 0x557A, 0x257D1 },
	{ 0x557B, 0x257DB },
	{ 0x557C, 0x257DE },
	{ 0x557D, 0x257F8 },
	{ 0x557E, 0x257DC },
	{ 0x5621, 0x257D9 },
	{ 0x5622, 0x259A0 },
	{ 0x5623, 0x259B2 },
	{ 0x5624, 0x259A1 },
	{ 0x5625, 0x259AA },
	{ 0x5626, 0x259A9 },
	{ 0x5627, 0x41A9 },
	{ 0x5628, 0x259A6 },
	{ 0x5629, 0x2599C },
	{ 0x562A, 0x259B5 },
	{ 0x562B, 0x259A7 },
	{ 0x562C, 0x25A8E },
	{ 0x562D, 0x25A90 },
	{ 0x562E, 0x25A91 },
	{ 0x562F, 0x25B85 },
	{ 0x5630, 0x25B5B },
	{ 0x5631, 0x25B70 },
	{ 0x5632, 0x25B64 },
	{ 0x5633, 0x25B67 },
	{ 0x5634, 0x25B63 },
	{ 0x5635, 0x25B77 },
	{ 0x5636, 0x25B68 },
	{ 0x5637, 0x25B65 },
	{ 0x5638, 0x25B6A },
	{ 0x5639, 0x25B78 },
	{ 0x563A, 0x25B66 },
	{ 0x563B, 0x25E88 },
	{ 0x563C, 0x25E9E },
	{ 0x563D, 0x25E74 },
	{ 0x563E, 0x25E7A },
	{ 0x563F, 0x25E79 },
	{ 0x5640, 0x25E8B },
	{ 0x5641, 0x25E7F },
	{ 0x5642, 0x26013 },
	{ 0x5643, 0x2601E },
	{ 0x5644, 0x26017 },
	{ 0x5645, 0x2601A },
	{ 0x5646, 0x26022 },
	{ 0x5647, 0x26043 },
	{ 0x5648, 0x26019 },
	{ 0x5649, 0x2601F },
	{ 0x564A, 0x26027 },
	{ 0x564B, 0x26012 },
	{ 0x564C, 0x26024 },
	{ 0x564D, 0x26025 },
	{ 0x564E, 0x2035E },
	{ 0x564F, 0x26235 },
	{ 0x5650, 0x26234 },
	{ 0x5651, 0x262D1 },
	{ 0x5652, 0x262C4 },
	{ 0x5653, 0x262CA },
	{ 0x5654, 0x262C6 },
	{ 0x5655, 0x262CB },
	{ 0x5656, 0x262CD },
	{ 0x5657, 0x262E2 },
	{ 0x5658, 0x26389 },
	{ 0x5659, 0x2638B },
	{ 0x565A, 0x26386 },
	{ 0x565B, 0x26388 },
	{ 0x565C, 0x2638D },
	{ 0x565D, 0x2643B },
	{ 0x565E, 0x2643C },
	{ 0x565F, 0x2643D },
	{ 0x5660, 0x264F5 },
	{ 0x5661, 0x26579 },
	{ 0x5662, 0x26575 },
	{ 0x5663, 0x26582 },
	{ 0x5664, 0x2657F },
	{ 0x5665, 0x26585 },
	{ 0x5666, 0x26576 },
	{ 0x5667, 0x2657C },
	{ 0x5668, 0x2657E },
	{ 0x5669, 0x2657B },
	{ 0x566A, 0x26580 },
	{ 0x566B, 0x2657A },
	{ 0x566C, 0x22548 },
	{ 0x566D, 0x43CB },
	{ 0x566E, 0x2661D },
	{ 0x566F, 0x266F6 },
	{ 0x5670, 0x266F7 },
	{ 0x5671, 0x266F9 },
	{ 0x5672, 0x26763 },
	{ 0x5673, 0x2676C },
	{ 0x5674, 0x2676E },
	{ 0x5675, 0x26714 },
	{ 0x5676, 0x440D },
	{ 0x5677, 0x26767 },
	{ 0x5678, 0x2676F },
	{ 0x5679, 0x26769 },
	{ 0x567A, 0x26776 },
	{ 0x567B, 0x26795 },
	{ 0x567C, 0x26771 },
	{ 0x567D, 0x26761 },
	{ 0x567E, 0x26778 },
	{ 0x5721, 0x2676B },
	{ 0x5722, 0x26785 },
	{ 0x5723, 0x26784 },
	{ 0x5724, 0x26914 },
	{ 0x5725, 0x26976 },
	{ 0x5726, 0x259B6 },
	{ 0x5727, 0x26975 },
	{ 0x5728, 0x26974 },
	{ 0x5729, 0x269E2 },
	{ 0x572A, 0x26A3F },
	{ 0x572B, 0x26A44 },
	{ 0x572C, 0x26A3D },
	{ 0x572D, 0x26A47 },
	{ 0x572E, 0x26A48 },
	{ 0x572F, 0x26ADB },
	{ 0x5730, 0x26ADC },
	{ 0x5731, 0x26ADD },
	{ 0x5732, 0x26BE5 },
	{ 0x5733, 0x26BE6 },
	{ 0x5734, 0x26CC2 },
	{ 0x5735, 0x26D2E },
	{ 0x5736, 0x26D1D },
	{ 0x5737, 0x26CF8 },
	{ 0x5738, 0x26CF0 },
	{ 0x5739, 0x26CF6 },
	{ 0x573A, 0x26CC5 },
	{ 0x573B, 0x26CC6 },
	{ 0x573C, 0x26CFC },
	{ 0x573D, 0x26D52 },
	{ 0x573E, 0x26D2F },
	{ 0x573F, 0x26D10 },
	{ 0x5740, 0x26CF3 },
	{ 0x5741, 0x26CD2 },
	{ 0x5742, 0x26CEA },
	{ 0x5743, 0x26CDC },
	{ 0x5744, 0x26D1B },
	{ 0x5745, 0x26CFB },
	{ 0x5746, 0x26CC3 },
	{ 0x5747, 0x26D16 },
	{ 0x5748, 0x26D07 },
	{ 0x5749, 0x26CC9 },
	{ 0x574A, 0x26CD8 },
	{ 0x574B, 0x26D30 },
	{ 0x574C, 0x26D13 },
	{ 0x574D, 0x26D31 },
	{ 0x574E, 0x26CFA },
	{ 0x574F, 0x26CF2 },
	{ 0x5750, 0x26DE3 },
	{ 0x5751, 0x26CD5 },
	{ 0x5752, 0x26D01 },
	{ 0x5753, 0x26CF1 },
	{ 0x5754, 0x26D1C },
	{ 0x5755, 0x26CD6 },
	{ 0x5756, 0x26D08 },
	{ 0x5757, 0x26D0B },
	{ 0x5758, 0x26D17 },
	{ 0x5759, 0x26D20 },
	{ 0x575A, 0x26CCA },
	{ 0x575B, 0x26D32 },
	{ 0x575C, 0x26D05 },
	{ 0x575D, 0x26CE4 },
	{ 0x575E, 0x26CCE },
	{ 0x575F, 0x26D33 },
	{ 0x5760, 0x26D02 },
	{ 0x5761, 0x26D19 },
	{ 0x5762, 0x26D1E },
	{ 0x5763, 0x26CD3 },
	{ 0x5764, 0x26CF7 },
	{ 0x5765, 0x26CE8 },
	{ 0x5766, 0x26D1F },
	{ 0x5767, 0x26CF4 },
	{ 0x5768, 0x26DD8 },
	{ 0x5769, 0x271BF },
	{ 0x576A, 0x271BE },
	{ 0x576B, 0x271BD },
	{ 0x576C, 0x272DC },
	{ 0x576D, 0x272DD },
	{ 0x576E, 0x272AB },
	{ 0x576F, 0x272C9 },
	{ 0x5770, 0x272C8 },
	{ 0x5771, 0x272DF },
	{ 0x5772, 0x272D9 },
	{ 0x5773, 0x272DB },
	{ 0x5774, 0x272CC },
	{ 0x5775, 0x272E0 },
	{ 0x5776, 0x272EF },
	{ 0x5777, 0x272F3 },
	{ 0x5778, 0x272AE },
	{ 0x5779, 0x27301 },
	{ 0x577A, 0x275B7 },
	{ 0x577B, 0x275B9 },
	{ 0x577C, 0x275B6 },
	{ 0x577D, 0x275B8 },
	{ 0x577E, 0x275F6 },
	{ 0x5821, 0x275F3 },
	{ 0x5822, 0x275F5 },
	{ 0x5823, 0x275F2 },
	{ 0x5824, 0x27691 },
	{ 0x5825, 0x2769D },
	{ 0x5826, 0x2769B },
	{ 0x5827, 0x27692 },
	{ 0x5828, 0x2768D },
	{ 0x5829, 0x2769E },
	{ 0x582A, 0x2768C },
	{ 0x582B, 0x4631 },
	{ 0x582C, 0x2F9C7 },
	{ 0x582D, 0x27695 },
	{ 0x582E, 0x2F9C6 },
	{ 0x582F, 0x2768A },
	{ 0x5830, 0x2768E },
	{ 0x5831, 0x2769C },
	{ 0x5832, 0x277EF },
	{ 0x5833, 0x2782D },
	{ 0x5834, 0x27852 },
	{ 0x5835, 0x27835 },
	{ 0x5836, 0x27828 },
	{ 0x5837, 0x2782E },
	{ 0x5838, 0x278E5 },
	{ 0x5839, 0x279EA },
	{ 0x583A, 0x279F1 },
	{ 0x583B, 0x279EB },
	{ 0x583C, 0x279D8 },
	{ 0x583D, 0x279D0 },
	{ 0x583E, 0x279F3 },
	{ 0x583F, 0x279DB },
	{ 0x5840, 0x279CE },
	{ 0x5841, 0x46D5 },
	{ 0x5842, 0x279DA },
	{ 0x5843, 0x279D7 },
	{ 0x5844, 0x279E1 },
	{ 0x5845, 0x279F2 },
	{ 0x5846, 0x279C8 },
	{ 0x5847, 0x279D9 },
	{ 0x5848, 0x279DE },
	{ 0x5849, 0x279D1 },
	{ 0x584A, 0x279E7 },
	{ 0x584B, 0x279CF },
	{ 0x584C, 0x27BB7 },
	{ 0x584D, 0x27C47 },
	{ 0x584E, 0x27C42 },
	{ 0x584F, 0x27C43 },
	{ 0x5850, 0x2F9D3 },
	{ 0x5851, 0x27CC3 },
	{ 0x5852, 0x27CC1 },
	{ 0x5853, 0x27CC7 },
	{ 0x5854, 0x27D64 },
	{ 0x5855, 0x27D6A },
	{ 0x5856, 0x27D66 },
	{ 0x5857, 0x27D50 },
	{ 0x5858, 0x27D6E },
	{ 0x5859, 0x27D65 },
	{ 0x585A, 0x238EC },
	{ 0x585B, 0x27D7F },
	{ 0x585C, 0x2F9D5 },
	{ 0x585D, 0x27D9A },
	{ 0x585E, 0x27D69 },
	{ 0x585F, 0x27D72 },
	{ 0x5860, 0x27D6F },
	{ 0x5861, 0x27D7D },
	{ 0x5862, 0x27D70 },
	{ 0x5863, 0x27E60 },
	{ 0x5864, 0x27EC2 },
	{ 0x5865, 0x27EE7 },
	{ 0x5866, 0x27ED1 },
	{ 0x5867, 0x27EEB },
	{ 0x5868, 0x27ED4 },
	{ 0x5869, 0x27EDC },
	{ 0x586A, 0x27EDB },
	{ 0x586B, 0x28037 },
	{ 0x586C, 0x28025 },
	{ 0x586D, 0x2801F },
	{ 0x586E, 0x2801E },
	{ 0x586F, 0x28021 },
	{ 0x5870, 0x2801B },
	{ 0x5871, 0x28017 },
	{ 0x5872, 0x28022 },
	{ 0x5873, 0x2802A },
	{ 0x5874, 0x2801A },
	{ 0x5875, 0x2802D },
	{ 0x5876, 0x28023 },
	{ 0x5877, 0x28026 },
	{ 0x5878, 0x28036 },
	{ 0x5879, 0x27FFF },
	{ 0x587A, 0x2823A },
	{ 0x587B, 0x28240 },
	{ 0x587C, 0x28242 },
	{ 0x587D, 0x28238 },
	{ 0x587E, 0x2823B },
	{ 0x5921, 0x2823C },
	{ 0x5922, 0x28243 },
	{ 0x5923, 0x282E8 },
	{ 0x5924, 0x4856 },
	{ 0x5925, 0x282F9 },
	{ 0x5926, 0x282EB },
	{ 0x5927, 0x282F1 },
	{ 0x5928, 0x282E9 },
	{ 0x5929, 0x282EC },
	{ 0x592A, 0x28415 },
	{ 0x592B, 0x28447 },
	{ 0x592C, 0x28446 },
	{ 0x592D, 0x28445 },
	{ 0x592E, 0x28524 },
	{ 0x592F, 0x28556 },
	{ 0x5930, 0x28521 },
	{ 0x5931, 0x28527 },
	{ 0x5932, 0x2854D },
	{ 0x5933, 0x28531 },
	{ 0x5934, 0x2851E },
	{ 0x5935, 0x2852C },
	{ 0x5936, 0x2854F },
	{ 0x5937, 0x2852B },
	{ 0x5938, 0x28553 },
	{ 0x5939, 0x28551 },
	{ 0x593A, 0x28554 },
	{ 0x593B, 0x28529 },
	{ 0x593C, 0x28550 },
	{ 0x593D, 0x2851F },
	{ 0x593E, 0x28532 },
	{ 0x593F, 0x2852A },
	{ 0x5940, 0x2851D },
	{ 0x5941, 0x28528 },
	{ 0x5942, 0x2852E },
	{ 0x5943, 0x2852D },
	{ 0x5944, 0x286BC },
	{ 0x5945, 0x286BB },
	{ 0x5946, 0x286BD },
	{ 0x5947, 0x2F9E4 },
	{ 0x5948, 0x28747 },
	{ 0x5949, 0x28741 },
	{ 0x594A, 0x2F9E5 },
	{ 0x594B, 0x28749 },
	{ 0x594C, 0x48F4 },
	{ 0x594D, 0x2882E },
	{ 0x594E, 0x28827 },
	{ 0x594F, 0x2896A },
	{ 0x5950, 0x2897B },
	{ 0x5951, 0x28973 },
	{ 0x5952, 0x28975 },
	{ 0x5953, 0x28969 },
	{ 0x5954, 0x28979 },
	{ 0x5955, 0x28972 },
	{ 0x5956, 0x28C76 },
	{ 0x5957, 0x28C77 },
	{ 0x5958, 0x28C74 },
	{ 0x5959, 0x28C73 },
	{ 0x595A, 0x28D02 },
	{ 0x595B, 0x28CFE },
	{ 0x595C, 0x28D01 },
	{ 0x595D, 0x28CF9 },
	{ 0x595E, 0x28CF4 },
	{ 0x595F, 0x28ED3 },
	{ 0x5960, 0x28ED5 },
	{ 0x5961, 0x28ED8 },
	{ 0x5962, 0x28EC3 },
	{ 0x5963, 0x28ECA },
	{ 0x5964, 0x28ED0 },
	{ 0x5965, 0x28ECB },
	{ 0x5966, 0x28ECE },
	{ 0x5967, 0x28EC5 },
	{ 0x5968, 0x28EE6 },
	{ 0x5969, 0x28EC4 },
	{ 0x596A, 0x28EC0 },
	{ 0x596B, 0x28ED4 },
	{ 0x596C, 0x28EE8 },
	{ 0x596D, 0x28F76 },
	{ 0x596E, 0x28FA2 },
	{ 0x596F, 0x28FAE },
	{ 0x5970, 0x28FA8 },
	{ 0x5971, 0x28FA3 },
	{ 0x5972, 0x28FA7 },
	{ 0x5973, 0x28F96 },
	{ 0x5974, 0x28FA9 },
	{ 0x5975, 0x28FA5 },
	{ 0x5976, 0x28FAF },
	{ 0x5977, 0x28FA4 },
	{ 0x5978, 0x28FAB },
	{ 0x5979, 0x28FAA },
	{ 0x597A, 0x28FA6 },
	{ 0x597B, 0x28FA0 },
	{ 0x597C, 0x29098 },
	{ 0x597D, 0x291DB },
	{ 0x597E, 0x291F6 },
	{ 0x5A21, 0x291F5 },
	{ 0x5A22, 0x2920C },
	{ 0x5A23, 0x2920A },
	{ 0x5A24, 0x9775 },
	{ 0x5A25, 0x29268 },
	{ 0x5A26, 0x29263 },
	{ 0x5A27, 0x29266 },
	{ 0x5A28, 0x4A58 },
	{ 0x5A29, 0x29264 },
	{ 0x5A2A, 0x2926A },
	{ 0x5A2B, 0x29269 },
	{ 0x5A2C, 0x29395 },
	{ 0x5A2D, 0x29402 },
	{ 0x5A2E, 0x2946A },
	{ 0x5A2F, 0x2945E },
	{ 0x5A30, 0x29468 },
	{ 0x5A31, 0x29469 },
	{ 0x5A32, 0x29465 },
	{ 0x5A33, 0x2F9FE },
	{ 0x5A34, 0x295A7 },
	{ 0x5A35, 0x295AE },
	{ 0x5A36, 0x295A8 },
	{ 0x5A37, 0x295B3 },
	{ 0x5A38, 0x2969C },
	{ 0x5A39, 0x296A9 },
	{ 0x5A3A, 0x296B6 },
	{ 0x5A3B, 0x296B3 },
	{ 0x5A3C, 0x296B2 },
	{ 0x5A3D, 0x2FA03 },
	{ 0x5A3E, 0x296B8 },
	{ 0x5A3F, 0x296C0 },
	{ 0x5A40, 0x296BF },
	{ 0x5A41, 0x296BA },
	{ 0x5A42, 0x296A8 },
	{ 0x5A43, 0x2983C },
	{ 0x5A44, 0x29872 },
	{ 0x5A45, 0x29871 },
	{ 0x5A46, 0x29875 },
	{ 0x5A47, 0x29873 },
	{ 0x5A48, 0x29A17 },
	{ 0x5A49, 0x29A15 },
	{ 0x5A4A, 0x29A16 },
	{ 0x5A4B, 0x29A1B },
	{ 0x5A4C, 0x29AFA },
	{ 0x5A4D, 0x29AF9 },
	{ 0x5A4E, 0x29C2C },
	{ 0x5A4F, 0x29C85 },
	{ 0x5A50, 0x29C82 },
	{ 0x5A51, 0x29C7F },
	{ 0x5A52, 0x29C7D },
	{ 0x5A53, 0x29C88 },
	{ 0x5A54, 0x242F3 },
	{ 0x5A55, 0x29D4E },
	{ 0x5A56, 0x29D50 },
	{ 0x5A57, 0x29F93 },
	{ 0x5A58, 0x29F97 },
	{ 0x5A59, 0x29F98 },
	{ 0x5A5A, 0x29F9B },
	{ 0x5A5B, 0x29F9C },
	{ 0x5A5C, 0x29F96 },
	{ 0x5A5D, 0x2A28B },
	{ 0x5A5E, 0x2A2FD },
	{ 0x5A5F, 0x2A2FC },
	{ 0x5A60, 0x2FA17 },
	{ 0x5A61, 0x2398B },
	{ 0x5A62, 0x20108 },
	{ 0x5A63, 0x20107 },
	{ 0x5A64, 0x20373 },
	{ 0x5A65, 0x203A2 },
	{ 0x5A66, 0x203AF },
	{ 0x5A67, 0x20382 },
	{ 0x5A68, 0x2037B },
	{ 0x5A69, 0x20374 },
	{ 0x5A6A, 0x203B0 },
	{ 0x5A6B, 0x20376 },
	{ 0x5A6C, 0x203B9 },
	{ 0x5A6D, 0x2039E },
	{ 0x5A6E, 0x203B1 },
	{ 0x5A6F, 0x203A1 },
	{ 0x5A70, 0x203B2 },
	{ 0x5A71, 0x2036E },
	{ 0x5A72, 0x2F80B },
	{ 0x5A73, 0x3487 },
	{ 0x5A74, 0x20378 },
	{ 0x5A75, 0x2037A },
	{ 0x5A76, 0x20383 },
	{ 0x5A77, 0x2039A },
	{ 0x5A78, 0x204F8 },
	{ 0x5A79, 0x20531 },
	{ 0x5A7A, 0x20569 },
	{ 0x5A7B, 0x20568 },
	{ 0x5A7C, 0x2059C },
	{ 0x5A7D, 0x20604 },
	{ 0x5A7E, 0x20699 },
	{ 0x5B21, 0x207C7 },
	{ 0x5B22, 0x207C6 },
	{ 0x5B23, 0x207DC },
	{ 0x5B24, 0x207C4 },
	{ 0x5B25, 0x207D8 },
	{ 0x5B26, 0x207D4 },
	{ 0x5B27, 0x207DF },
	{ 0x5B28, 0x207D1 },
	{ 0x5B29, 0x207D0 },
	{ 0x5B2A, 0x207D6 },
	{ 0x5B2B, 0x207CF },
	{ 0x5B2C, 0x208AD },
	{ 0x5B2D, 0x208AF },
	{ 0x5B2E, 0x208A7 },
	{ 0x5B2F, 0x208FD },
	{ 0x5B30, 0x2095B },
	{ 0x5B31, 0x2095A },
	{ 0x5B32, 0x20A07 },
	{ 0x5B33, 0x20A9D },
	{ 0x5B34, 0x20A9B },
	{ 0x5B35, 0x20AAB },
	{ 0x5B36, 0x20AA4 },
	{ 0x5B37, 0x20A9C },
	{ 0x5B38, 0x20A9E },
	{ 0x5B39, 0x20AA5 },
	{ 0x5B3A, 0x20AAA },
	{ 0x5B3B, 0x20AA6 },
	{ 0x5B3C, 0x20B0E },
	{ 0x5B3D, 0x20B7E },
	{ 0x5B3E, 0x20B7C },
	{ 0x5B3F, 0x20EEE },
	{ 0x5B40, 0x20ED5 },
	{ 0x5B41, 0x20EE9 },
	{ 0x5B42, 0x20E42 },
	{ 0x5B43, 0x20EE2 },
	{ 0x5B44, 0x20F23 },
	{ 0x5B45, 0x20ED9 },
	{ 0x5B46, 0x20ED4 },
	{ 0x5B47, 0x20EE3 },
	{ 0x5B48, 0x20F15 },
	{ 0x5B49, 0x20EEF },
	{ 0x5B4A, 0x20EF0 },
	{ 0x5B4B, 0x20ED6 },
	{ 0x5B4C, 0x20EDD },
	{ 0x5B4D, 0x20EF6 },
	{ 0x5B4E, 0x20F1C },
	{ 0x5B4F, 0x20ED8 },
	{ 0x5B50, 0x20EDB },
	{ 0x5B51, 0x20EDA },
	{ 0x5B52, 0x20EED },
	{ 0x5B53, 0x21411 },
	{ 0x5B54, 0x21215 },
	{ 0x5B55, 0x21218 },
	{ 0x5B56, 0x2121A },
	{ 0x5B57, 0x2121F },
	{ 0x5B58, 0x21216 },
	{ 0x5B59, 0x2F84D },
	{ 0x5B5A, 0x21219 },
	{ 0x5B5B, 0x2F84B },
	{ 0x5B5C, 0x213F0 },
	{ 0x5B5D, 0x21409 },
	{ 0x5B5E, 0x2141B },
	{ 0x5B5F, 0x27BE7 },
	{ 0x5B60, 0x213F6 },
	{ 0x5B61, 0x213F4 },
	{ 0x5B62, 0x213B5 },
	{ 0x5B63, 0x21410 },
	{ 0x5B64, 0x213F2 },
	{ 0x5B65, 0x21415 },
	{ 0x5B66, 0x213F3 },
	{ 0x5B67, 0x213F8 },
	{ 0x5B68, 0x21539 },
	{ 0x5B69, 0x2153B },
	{ 0x5B6A, 0x21536 },
	{ 0x5B6B, 0x2140E },
	{ 0x5B6C, 0x21572 },
	{ 0x5B6D, 0x21574 },
	{ 0x5B6E, 0x215B9 },
	{ 0x5B6F, 0x215B7 },
	{ 0x5B70, 0x215B8 },
	{ 0x5B71, 0x21672 },
	{ 0x5B72, 0x2166B },
	{ 0x5B73, 0x2181D },
	{ 0x5B74, 0x21837 },
	{ 0x5B75, 0x21822 },
	{ 0x5B76, 0x21843 },
	{ 0x5B77, 0x2184D },
	{ 0x5B78, 0x21838 },
	{ 0x5B79, 0x2185B },
	{ 0x5B7A, 0x21879 },
	{ 0x5B7B, 0x2181B },
	{ 0x5B7C, 0x217F3 },
	{ 0x5B7D, 0x21991 },
	{ 0x5B7E, 0x21A7B },
	{ 0x5C21, 0x21A94 },
	{ 0x5C22, 0x2F86F },
	{ 0x5C23, 0x21A96 },
	{ 0x5C24, 0x21A7F },
	{ 0x5C25, 0x21A8F },
	{ 0x5C26, 0x21A84 },
	{ 0x5C27, 0x21A7C },
	{ 0x5C28, 0x21A8E },
	{ 0x5C29, 0x21A90 },
	{ 0x5C2A, 0x21A98 },
	{ 0x5C2B, 0x21A83 },
	{ 0x5C2C, 0x21A80 },
	{ 0x5C2D, 0x21A93 },
	{ 0x5C2E, 0x21A82 },
	{ 0x5C30, 0x21B3D },
	{ 0x5C31, 0x21B41 },
	{ 0x5C32, 0x21BA1 },
	{ 0x5C33, 0x21B9F },
	{ 0x5C34, 0x21C0A },
	{ 0x5C35, 0x21C0D },
	{ 0x5C36, 0x21CC8 },
	{ 0x5C37, 0x21CC9 },
	{ 0x5C38, 0x21CC7 },
	{ 0x5C39, 0x21CCD },
	{ 0x5C3A, 0x21D25 },
	{ 0x5C3B, 0x21EB1 },
	{ 0x5C3C, 0x21EDC },
	{ 0x5C3D, 0x2F880 },
	{ 0x5C3E, 0x21EE5 },
	{ 0x5C3F, 0x21EF4 },
	{ 0x5C40, 0x21EBF },
	{ 0x5C41, 0x21EDB },
	{ 0x5C42, 0x21EEA },
	{ 0x5C43, 0x21EF2 },
	{ 0x5C44, 0x37FA },
	{ 0x5C45, 0x21EF1 },
	{ 0x5C46, 0x21EED },
	{ 0x5C47, 0x21EE6 },
	{ 0x5C48, 0x22002 },
	{ 0x5C49, 0x2F882 },
	{ 0x5C4A, 0x22125 },
	{ 0x5C4B, 0x22118 },
	{ 0x5C4C, 0x2211F },
	{ 0x5C4D, 0x22120 },
	{ 0x5C4E, 0x221CF },
	{ 0x5C4F, 0x2229D },
	{ 0x5C50, 0x22299 },
	{ 0x5C51, 0x222A8 },
	{ 0x5C52, 0x22368 },
	{ 0x5C53, 0x22366 },
	{ 0x5C54, 0x22367 },
	{ 0x5C55, 0x22391 },
	{ 0x5C56, 0x22413 },
	{ 0x5C57, 0x22415 },
	{ 0x5C58, 0x2241D },
	{ 0x5C59, 0x22416 },
	{ 0x5C5A, 0x22419 },
	{ 0x5C5B, 0x2246B },
	{ 0x5C5C, 0x22468 },
	{ 0x5C5D, 0x2246A },
	{ 0x5C5E, 0x2246D },
	{ 0x5C5F, 0x22469 },
	{ 0x5C60, 0x224AA },
	{ 0x5C61, 0x22557 },
	{ 0x5C62, 0x22552 },
	{ 0x5C63, 0x22550 },
	{ 0x5C64, 0x2255F },
	{ 0x5C65, 0x22567 },
	{ 0x5C66, 0x2254F },
	{ 0x5C67, 0x38F2 },
	{ 0x5C68, 0x2255B },
	{ 0x5C69, 0x2255C },
	{ 0x5C6A, 0x2255D },
	{ 0x5C6B, 0x2281F },
	{ 0x5C6C, 0x2279D },
	{ 0x5C6D, 0x227B1 },
	{ 0x5C6E, 0x227B0 },
	{ 0x5C6F, 0x22794 },
	{ 0x5C70, 0x227C3 },
	{ 0x5C71, 0x227AF },
	{ 0x5C72, 0x227A8 },
	{ 0x5C73, 0x227DC },
	{ 0x5C74, 0x22798 },
	{ 0x5C75, 0x227C4 },
	{ 0x5C76, 0x227A4 },
	{ 0x5C77, 0x227AB },
	{ 0x5C78, 0x227AA },
	{ 0x5C79, 0x227A5 },
	{ 0x5C7A, 0x22821 },
	{ 0x5C7B, 0x227EB },
	{ 0x5C7C, 0x227E6 },
	{ 0x5C7D, 0x227F7 },
	{ 0x5C7E, 0x227F8 },
	{ 0x5D21, 0x227FC },
	{ 0x5D22, 0x227FA },
	{ 0x5D23, 0x227E0 },
	{ 0x5D24, 0x2F8AA },
	{ 0x5D25, 0x227F6 },
	{ 0x5D26, 0x2F8A9 },
	{ 0x5D27, 0x227E1 },
	{ 0x5D28, 0x229EC },
	{ 0x5D29, 0x229E2 },
	{ 0x5D2A, 0x229E4 },
	{ 0x5D2B, 0x229F9 },
	{ 0x5D2C, 0x22C6F },
	{ 0x5D2D, 0x23A4C },
	{ 0x5D2E, 0x22CBB },
	{ 0x5D2F, 0x22CE1 },
	{ 0x5D30, 0x22D00 },
	{ 0x5D31, 0x22CD8 },
	{ 0x5D32, 0x3A2F },
	{ 0x5D33, 0x22CD6 },
	{ 0x5D34, 0x22CE2 },
	{ 0x5D35, 0x22CC3 },
	{ 0x5D36, 0x22CB3 },
	{ 0x5D37, 0x22CD2 },
	{ 0x5D38, 0x2F8C1 },
	{ 0x5D39, 0x22CCE },
	{ 0x5D3A, 0x22CD0 },
	{ 0x5D3B, 0x22CD5 },
	{ 0x5D3C, 0x22CB9 },
	{ 0x5D3D, 0x22CBA },
	{ 0x5D3E, 0x22CCF },
	{ 0x5D3F, 0x22CBD },
	{ 0x5D40, 0x22EDB },
	{ 0x5D41, 0x22FAA },
	{ 0x5D42, 0x22FAD },
	{ 0x5D43, 0x22FB8 },
	{ 0x5D44, 0x22FB6 },
	{ 0x5D45, 0x22FB5 },
	{ 0x5D46, 0x22FAF },
	{ 0x5D47, 0x22FB4 },
	{ 0x5D48, 0x22FB7 },
	{ 0x5D49, 0x22FA8 },
	{ 0x5D4A, 0x22FB9 },
	{ 0x5D4B, 0x22FBE },
	{ 0x5D4C, 0x23082 },
	{ 0x5D4D, 0x230BC },
	{ 0x5D4E, 0x230B8 },
	{ 0x5D4F, 0x230B6 },
	{ 0x5D50, 0x230B9 },
	{ 0x5D51, 0x3AC1 },
	{ 0x5D52, 0x23110 },
	{ 0x5D53, 0x23227 },
	{ 0x5D54, 0x23269 },
	{ 0x5D55, 0x23270 },
	{ 0x5D56, 0x23256 },
	{ 0x5D57, 0x2326B },
	{ 0x5D58, 0x2327A },
	{ 0x5D59, 0x2326C },
	{ 0x5D5A, 0x2326D },
	{ 0x5D5B, 0x2F8D5 },
	{ 0x5D5C, 0x267C1 },
	{ 0x5D5D, 0x2338D },
	{ 0x5D5E, 0x23390 },
	{ 0x5D5F, 0x235B6 },
	{ 0x5D60, 0x23610 },
	{ 0x5D61, 0x23612 },
	{ 0x5D62, 0x235BA },
	{ 0x5D63, 0x235BD },
	{ 0x5D64, 0x23605 },
	{ 0x5D65, 0x235C2 },
	{ 0x5D66, 0x23607 },
	{ 0x5D67, 0x235F5 },
	{ 0x5D68, 0x2F8E9 },
	{ 0x5D69, 0x235AF },
	{ 0x5D6A, 0x235F4 },
	{ 0x5D6B, 0x235F7 },
	{ 0x5D6C, 0x235F8 },
	{ 0x5D6D, 0x23611 },
	{ 0x5D6E, 0x238F6 },
	{ 0x5D6F, 0x238F5 },
	{ 0x5D70, 0x238FB },
	{ 0x5D71, 0x23901 },
	{ 0x5D72, 0x23900 },
	{ 0x5D73, 0x23902 },
	{ 0x5D74, 0x238FE },
	{ 0x5D75, 0x238FA },
	{ 0x5D76, 0x238FD },
	{ 0x5D77, 0x3C40 },
	{ 0x5D78, 0x23A37 },
	{ 0x5D79, 0x23A49 },
	{ 0x5D7A, 0x23A4B },
	{ 0x5D7B, 0x23A46 },
	{ 0x5D7C, 0x23A47 },
	{ 0x5D7D, 0x23AB3 },
	{ 0x5D7E, 0x23AB2 },
	{ 0x5E21, 0x23AB0 },
	{ 0x5E22, 0x23AB7 },
	{ 0x5E23, 0x23B11 },
	{ 0x5E24, 0x23BCC },
	{ 0x5E25, 0x23BDF },
	{ 0x5E26, 0x23BD3 },
	{ 0x5E27, 0x23BD5 },
	{ 0x5E28, 0x23BDB },
	{ 0x5E29, 0x23BC5 },
	{ 0x5E2A, 0x23BC8 },
	{ 0x5E2B, 0x23BC9 },
	{ 0x5E2C, 0x23BE2 },
	{ 0x5E2D, 0x23BCA },
	{ 0x5E2E, 0x23BD1 },
	{ 0x5E2F, 0x23BD2 },
	{ 0x5E30, 0x23BDD },
	{ 0x5E31, 0x23E6C },
	{ 0x5E32, 0x23E73 },
	{ 0x5E33, 0x23F21 },
	{ 0x5E34, 0x23EF0 },
	{ 0x5E35, 0x23F1F },
	{ 0x5E36, 0x23F3B },
	{ 0x5E37, 0x23F22 },
	{ 0x5E38, 0x23F23 },
	{ 0x5E39, 0x23EE8 },
	{ 0x5E3A, 0x23EDD },
	{ 0x5E3B, 0x3D3F },
	{ 0x5E3C, 0x23F1B },
	{ 0x5E3D, 0x23EED },
	{ 0x5E3E, 0x2F90E },
	{ 0x5E3F, 0x23EF2 },
	{ 0x5E40, 0x3D46 },
	{ 0x5E41, 0x23EDC },
	{ 0x5E42, 0x23EE9 },
	{ 0x5E43, 0x23F1D },
	{ 0x5E44, 0x23EDA },
	{ 0x5E45, 0x23EE6 },
	{ 0x5E46, 0x24313 },
	{ 0x5E47, 0x24315 },
	{ 0x5E48, 0x24316 },
	{ 0x5E49, 0x2433C },
	{ 0x5E4A, 0x2430B },
	{ 0x5E4B, 0x2431C },
	{ 0x5E4C, 0x2433A },
	{ 0x5E4D, 0x2433D },
	{ 0x5E4E, 0x2439A },
	{ 0x5E4F, 0x2431D },
	{ 0x5E50, 0x24309 },
	{ 0x5E51, 0x24308 },
	{ 0x5E52, 0x2433B },
	{ 0x5E53, 0x24522 },
	{ 0x5E54, 0x24526 },
	{ 0x5E55, 0x24525 },
	{ 0x5E56, 0x24524 },
	{ 0x5E57, 0x2039B },
	{ 0x5E58, 0x2458F },
	{ 0x5E59, 0x24590 },
	{ 0x5E5A, 0x245E6 },
	{ 0x5E5B, 0x245E3 },
	{ 0x5E5C, 0x245E5 },
	{ 0x5E5D, 0x24611 },
	{ 0x5E5E, 0x2F925 },
	{ 0x5E5F, 0x246AE },
	{ 0x5E60, 0x246BE },
	{ 0x5E61, 0x246B4 },
	{ 0x5E62, 0x246B3 },
	{ 0x5E63, 0x246AF },
	{ 0x5E64, 0x24691 },
	{ 0x5E65, 0x246C2 },
	{ 0x5E66, 0x246B6 },
	{ 0x5E67, 0x246B2 },
	{ 0x5E68, 0x24857 },
	{ 0x5E69, 0x2483B },
	{ 0x5E6A, 0x24858 },
	{ 0x5E6B, 0x24851 },
	{ 0x5E6C, 0x24841 },
	{ 0x5E6D, 0x24839 },
	{ 0x5E6E, 0x3E8F },
	{ 0x5E6F, 0x24859 },
	{ 0x5E70, 0x24845 },
	{ 0x5E71, 0x24861 },
	{ 0x5E72, 0x248E8 },
	{ 0x5E73, 0x249FA },
	{ 0x5E74, 0x249EA },
	{ 0x5E75, 0x249EF },
	{ 0x5E76, 0x249F2 },
	{ 0x5E77, 0x249F0 },
	{ 0x5E78, 0x24B08 },
	{ 0x5E79, 0x24B70 },
	{ 0x5E7A, 0x24B6A },
	{ 0x5E7B, 0x24B73 },
	{ 0x5E7C, 0x24B68 },
	{ 0x5E7D, 0x24BC8 },
	{ 0x5E7E, 0x24BF2 },
	{ 0x5F21, 0x20B7B },
	{ 0x5F22, 0x24CAE },
	{ 0x5F23, 0x24CAB },
	{ 0x5F24, 0x24CB5 },
	{ 0x5F25, 0x24CAF },
	{ 0x5F26, 0x24CB2 },
	{ 0x5F27, 0x24CB6 },
	{ 0x5F28, 0x24CB0 },
	{ 0x5F29, 0x24D1E },
	{ 0x5F2A, 0x24E03 },
	{ 0x5F2B, 0x24E06 },
	{ 0x5F2C, 0x24E1F },
	{ 0x5F2D, 0x3FAC },
	{ 0x5F2E, 0x24E0F },
	{ 0x5F2F, 0x24E02 },
	{ 0x5F30, 0x24E19 },
	{ 0x5F31, 0x24E18 },
	{ 0x5F32, 0x24E22 },
	{ 0x5F33, 0x24E15 },
	{ 0x5F34, 0x24E07 },
	{ 0x5F35, 0x24E0D },
	{ 0x5F36, 0x24E24 },
	{ 0x5F37, 0x24E0C },
	{ 0x5F38, 0x24E1E },
	{ 0x5F39, 0x24F89 },
	{ 0x5F3A, 0x24F8A },
	{ 0x5F3B, 0x2500A },
	{ 0x5F3C, 0x2500B },
	{ 0x5F3D, 0x25007 },
	{ 0x5F3E, 0x25004 },
	{ 0x5F3F, 0x25009 },
	{ 0x5F40, 0x25084 },
	{ 0x5F41, 0x25083 },
	{ 0x5F42, 0x25218 },
	{ 0x5F43, 0x25214 },
	{ 0x5F44, 0x25205 },
	{ 0x5F45, 0x25216 },
	{ 0x5F46, 0x2520E },
	{ 0x5F47, 0x25211 },
	{ 0x5F48, 0x25208 },
	{ 0x5F49, 0x2520B },
	{ 0x5F4A, 0x25215 },
	{ 0x5F4B, 0x25085 },
	{ 0x5F4C, 0x25237 },
	{ 0x5F4D, 0x2522A },
	{ 0x5F4E, 0x2520D },
	{ 0x5F4F, 0x2520F },
	{ 0x5F50, 0x2537E },
	{ 0x5F51, 0x25376 },
	{ 0x5F52, 0x25377 },
	{ 0x5F53, 0x253EC },
	{ 0x5F54, 0x254FC },
	{ 0x5F55, 0x25508 },
	{ 0x5F56, 0x254FF },
	{ 0x5F57, 0x25503 },
	{ 0x5F58, 0x25510 },
	{ 0x5F59, 0x25505 },
	{ 0x5F5A, 0x25506 },
	{ 0x5F5B, 0x254FA },
	{ 0x5F5C, 0x256C7 },
	{ 0x5F5D, 0x256C0 },
	{ 0x5F5E, 0x256C3 },
	{ 0x5F5F, 0x256A7 },
	{ 0x5F60, 0x256A8 },
	{ 0x5F61, 0x256AB },
	{ 0x5F62, 0x256C1 },
	{ 0x5F63, 0x256AA },
	{ 0x5F64, 0x256C8 },
	{ 0x5F65, 0x25743 },
	{ 0x5F66, 0x25802 },
	{ 0x5F67, 0x2580E },
	{ 0x5F68, 0x25801 },
	{ 0x5F69, 0x257FE },
	{ 0x5F6A, 0x25803 },
	{ 0x5F6B, 0x4168 },
	{ 0x5F6C, 0x25822 },
	{ 0x5F6D, 0x25821 },
	{ 0x5F6E, 0x25807 },
	{ 0x5F6F, 0x25808 },
	{ 0x5F70, 0x2580C },
	{ 0x5F71, 0x259CA },
	{ 0x5F72, 0x259BC },
	{ 0x5F73, 0x259BE },
	{ 0x5F74, 0x259BD },
	{ 0x5F75, 0x2F95C },
	{ 0x5F76, 0x259BB },
	{ 0x5F77, 0x259B9 },
	{ 0x5F78, 0x41AB },
	{ 0x5F79, 0x259C5 },
	{ 0x5F7A, 0x25A99 },
	{ 0x5F7B, 0x25B6B },
	{ 0x5F7C, 0x25B93 },
	{ 0x5F7D, 0x25B94 },
	{ 0x5F7E, 0x25BA9 },
	{ 0x6021, 0x25BA0 },
	{ 0x6022, 0x25BA6 },
	{ 0x6023, 0x2F961 },
	{ 0x6024, 0x25BAB },
	{ 0x6025, 0x25B9E },
	{ 0x6026, 0x25B9B },
	{ 0x6027, 0x25B91 },
	{ 0x6028, 0x25B99 },
	{ 0x6029, 0x25EB6 },
	{ 0x602A, 0x25EB8 },
	{ 0x602B, 0x25E9A },
	{ 0x602C, 0x4291 },
	{ 0x602D, 0x25E98 },
	{ 0x602E, 0x25E9B },
	{ 0x602F, 0x25EB3 },
	{ 0x6030, 0x25EA2 },
	{ 0x6031, 0x222AA },
	{ 0x6032, 0x25EA0 },
	{ 0x6033, 0x25E9F },
	{ 0x6034, 0x2605B },
	{ 0x6035, 0x26070 },
	{ 0x6036, 0x26054 },
	{ 0x6037, 0x26071 },
	{ 0x6038, 0x26065 },
	{ 0x6039, 0x26051 },
	{ 0x603A, 0x2609D },
	{ 0x603B, 0x26061 },
	{ 0x603C, 0x2605A },
	{ 0x603D, 0x26074 },
	{ 0x603E, 0x2604C },
	{ 0x603F, 0x2604B },
	{ 0x6040, 0x2605E },
	{ 0x6041, 0x26058 },
	{ 0x6042, 0x26053 },
	{ 0x6043, 0x26052 },
	{ 0x6044, 0x2623B },
	{ 0x6045, 0x26239 },
	{ 0x6046, 0x262D6 },
	{ 0x6047, 0x262E7 },
	{ 0x6048, 0x262D7 },
	{ 0x6049, 0x262D8 },
	{ 0x604A, 0x262D9 },
	{ 0x604B, 0x262DA },
	{ 0x604C, 0x262DB },
	{ 0x604D, 0x262DC },
	{ 0x604E, 0x262E0 },
	{ 0x604F, 0x262E4 },
	{ 0x6050, 0x262DD },
	{ 0x6051, 0x262F5 },
	{ 0x6052, 0x262F1 },
	{ 0x6053, 0x26398 },
	{ 0x6054, 0x2639D },
	{ 0x6055, 0x26399 },
	{ 0x6056, 0x26450 },
	{ 0x6057, 0x26449 },
	{ 0x6058, 0x7FE4 },
	{ 0x6059, 0x26462 },
	{ 0x605A, 0x264D7 },
	{ 0x605B, 0x26501 },
	{ 0x605C, 0x264F7 },
	{ 0x605D, 0x2F97D },
	{ 0x605E, 0x2658C },
	{ 0x605F, 0x2659C },
	{ 0x6060, 0x8088 },
	{ 0x6061, 0x2661F },
	{ 0x6062, 0x2661E },
	{ 0x6063, 0x2673D },
	{ 0x6064, 0x2673F },
	{ 0x6065, 0x26711 },
	{ 0x6066, 0x26759 },
	{ 0x6067, 0x2673E },
	{ 0x6068, 0x26758 },
	{ 0x6069, 0x26800 },
	{ 0x606A, 0x2679E },
	{ 0x606B, 0x267B6 },
	{ 0x606C, 0x267AA },
	{ 0x606D, 0x267AF },
	{ 0x606E, 0x267AC },
	{ 0x606F, 0x4430 },
	{ 0x6070, 0x267C0 },
	{ 0x6071, 0x267A9 },
	{ 0x6072, 0x20B10 },
	{ 0x6073, 0x268EE },
	{ 0x6074, 0x26977 },
	{ 0x6075, 0x26979 },
	{ 0x6076, 0x2697A },
	{ 0x6077, 0x2697D },
	{ 0x6078, 0x2697F },
	{ 0x6079, 0x26983 },
	{ 0x607A, 0x26978 },
	{ 0x607B, 0x2697E },
	{ 0x607C, 0x269E4 },
	{ 0x607D, 0x269E6 },
	{ 0x607E, 0x269E5 },
	{ 0x6121, 0x445D },
	{ 0x6122, 0x26A4E },
	{ 0x6123, 0x26A59 },
	{ 0x6124, 0x4475 },
	{ 0x6125, 0x2F98E },
	{ 0x6126, 0x26A4F },
	{ 0x6127, 0x26A4A },
	{ 0x6128, 0x26AE3 },
	{ 0x6129, 0x26ADE },
	{ 0x612A, 0x26AE2 },
	{ 0x612B, 0x26C74 },
	{ 0x612C, 0x26CAC },
	{ 0x612D, 0x26C61 },
	{ 0x612E, 0x26C62 },
	{ 0x612F, 0x26C76 },
	{ 0x6130, 0x26C7A },
	{ 0x6131, 0x26C79 },
	{ 0x6132, 0x26C60 },
	{ 0x6133, 0x26D64 },
	{ 0x6134, 0x26E81 },
	{ 0x6135, 0x26DDF },
	{ 0x6136, 0x26D84 },
	{ 0x6137, 0x26D8A },
	{ 0x6138, 0x26D92 },
	{ 0x6139, 0x26D79 },
	{ 0x613A, 0x26DDE },
	{ 0x613B, 0x26D98 },
	{ 0x613C, 0x26D6C },
	{ 0x613D, 0x26DE1 },
	{ 0x613E, 0x2F9A5 },
	{ 0x613F, 0x26D7C },
	{ 0x6140, 0x26D72 },
	{ 0x6141, 0x26D81 },
	{ 0x6142, 0x26DE0 },
	{ 0x6143, 0x26D65 },
	{ 0x6144, 0x44FF },
	{ 0x6145, 0x26D6A },
	{ 0x6146, 0x26D97 },
	{ 0x6147, 0x26DAA },
	{ 0x6148, 0x26DD3 },
	{ 0x6149, 0x26DAB },
	{ 0x614A, 0x26D6E },
	{ 0x614B, 0x26DAC },
	{ 0x614C, 0x26D76 },
	{ 0x614D, 0x26D7B },
	{ 0x614E, 0x26DAD },
	{ 0x614F, 0x2F9A6 },
	{ 0x6150, 0x26D94 },
	{ 0x6151, 0x26DD7 },
	{ 0x6152, 0x26D70 },
	{ 0x6153, 0x26DD5 },
	{ 0x6154, 0x26DF1 },
	{ 0x6155, 0x26D7A },
	{ 0x6156, 0x26D68 },
	{ 0x6157, 0x26D96 },
	{ 0x6158, 0x450B },
	{ 0x6159, 0x26D73 },
	{ 0x615A, 0x26DAE },
	{ 0x615B, 0x26DDD },
	{ 0x615C, 0x26DDA },
	{ 0x615D, 0x26DAF },
	{ 0x615E, 0x26DB0 },
	{ 0x615F, 0x26DDB },
	{ 0x6160, 0x26D62 },
	{ 0x6161, 0x26DF8 },
	{ 0x6162, 0x271C2 },
	{ 0x6163, 0x271C7 },
	{ 0x6164, 0x271C8 },
	{ 0x6165, 0x271C5 },
	{ 0x6166, 0x271C3 },
	{ 0x6167, 0x271C6 },
	{ 0x6168, 0x272DE },
	{ 0x6169, 0x45C8 },
	{ 0x616A, 0x27311 },
	{ 0x616B, 0x27315 },
	{ 0x616C, 0x27328 },
	{ 0x616D, 0x27321 },
	{ 0x616E, 0x2732D },
	{ 0x616F, 0x27351 },
	{ 0x6170, 0x2732B },
	{ 0x6171, 0x27316 },
	{ 0x6172, 0x27324 },
	{ 0x6173, 0x27335 },
	{ 0x6174, 0x2731F },
	{ 0x6175, 0x27312 },
	{ 0x6176, 0x27310 },
	{ 0x6177, 0x27380 },
	{ 0x6178, 0x2733B },
	{ 0x6179, 0x27329 },
	{ 0x617A, 0x2732A },
	{ 0x617B, 0x2731B },
	{ 0x617C, 0x27318 },
	{ 0x617D, 0x27320 },
	{ 0x617E, 0x2733F },
	{ 0x6221, 0x2731C },
	{ 0x6222, 0x27326 },
	{ 0x6223, 0x2730B },
	{ 0x6224, 0x275BE },
	{ 0x6225, 0x275C4 },
	{ 0x6226, 0x275BD },
	{ 0x6227, 0x275FA },
	{ 0x6228, 0x275FB },
	{ 0x6229, 0x276B1 },
	{ 0x622A, 0x276B2 },
	{ 0x622B, 0x276B0 },
	{ 0x622C, 0x276B9 },
	{ 0x622D, 0x276A6 },
	{ 0x622E, 0x276BD },
	{ 0x622F, 0x276B6 },
	{ 0x6230, 0x276B8 },
	{ 0x6231, 0x276B4 },
	{ 0x6232, 0x276B3 },
	{ 0x6233, 0x276A7 },
	{ 0x6234, 0x276AE },
	{ 0x6235, 0x276BC },
	{ 0x6236, 0x277F2 },
	{ 0x6237, 0x277F3 },
	{ 0x6238, 0x277F4 },
	{ 0x6239, 0x2783B },
	{ 0x623A, 0x27840 },
	{ 0x623B, 0x27846 },
	{ 0x623C, 0x278F0 },
	{ 0x623D, 0x278EE },
	{ 0x623E, 0x278E8 },
	{ 0x623F, 0x278F1 },
	{ 0x6240, 0x278EB },
	{ 0x6241, 0x278EF },
	{ 0x6242, 0x279FC },
	{ 0x6243, 0x27A20 },
	{ 0x6244, 0x27A09 },
	{ 0x6245, 0x27A06 },
	{ 0x6246, 0x27A03 },
	{ 0x6247, 0x2F9CF },
	{ 0x6248, 0x27A19 },
	{ 0x6249, 0x27A24 },
	{ 0x624A, 0x27A1B },
	{ 0x624B, 0x27A1D },
	{ 0x624C, 0x279FD },
	{ 0x624D, 0x27A1E },
	{ 0x624E, 0x279F4 },
	{ 0x624F, 0x27A01 },
	{ 0x6250, 0x27A08 },
	{ 0x6251, 0x27A05 },
	{ 0x6252, 0x27A23 },
	{ 0x6253, 0x279FF },
	{ 0x6254, 0x27BEA },
	{ 0x6255, 0x27C4D },
	{ 0x6256, 0x27C4E },
	{ 0x6257, 0x27C56 },
	{ 0x6258, 0x27C57 },
	{ 0x6259, 0x27C51 },
	{ 0x625A, 0x27C55 },
	{ 0x625B, 0x27C54 },
	{ 0x625C, 0x27CCB },
	{ 0x625D, 0x27CD4 },
	{ 0x625E, 0x27CD1 },
	{ 0x625F, 0x27CCF },
	{ 0x6260, 0x27CD2 },
	{ 0x6261, 0x27CCA },
	{ 0x6262, 0x27CD6 },
	{ 0x6263, 0x27D8B },
	{ 0x6264, 0x27D88 },
	{ 0x6265, 0x27D85 },
	{ 0x6266, 0x27D89 },
	{ 0x6267, 0x21A9B },
	{ 0x6268, 0x27DBB },
	{ 0x6269, 0x27D8C },
	{ 0x626A, 0x4774 },
	{ 0x626B, 0x27D99 },
	{ 0x626C, 0x27D8A },
	{ 0x626D, 0x27EEC },
	{ 0x626E, 0x27EEF },
	{ 0x626F, 0x27EF9 },
	{ 0x6270, 0x27F09 },
	{ 0x6271, 0x27EF8 },
	{ 0x6272, 0x27EF3 },
	{ 0x6273, 0x27F00 },
	{ 0x6274, 0x27F1D },
	{ 0x6275, 0x47AC },
	{ 0x6276, 0x27EFD },
	{ 0x6277, 0x28048 },
	{ 0x6278, 0x2805C },
	{ 0x6279, 0x28055 },
	{ 0x627A, 0x2805E },
	{ 0x627B, 0x28049 },
	{ 0x627C, 0x28063 },
	{ 0x627D, 0x28060 },
	{ 0x627E, 0x28053 },
	{ 0x6321, 0x28062 },
	{ 0x6322, 0x28040 },
	{ 0x6323, 0x28249 },
	{ 0x6324, 0x2824A },
	{ 0x6325, 0x2824C },
	{ 0x6326, 0x2824D },
	{ 0x6327, 0x2830A },
	{ 0x6328, 0x28306 },
	{ 0x6329, 0x2832F },
	{ 0x632A, 0x28321 },
	{ 0x632B, 0x28307 },
	{ 0x632C, 0x28309 },
	{ 0x632D, 0x28302 },
	{ 0x632E, 0x28316 },
	{ 0x632F, 0x28303 },
	{ 0x6330, 0x2830B },
	{ 0x6331, 0x2830F },
	{ 0x6332, 0x28560 },
	{ 0x6333, 0x28568 },
	{ 0x6334, 0x2855E },
	{ 0x6335, 0x2855D },
	{ 0x6336, 0x28563 },
	{ 0x6337, 0x2855F },
	{ 0x6338, 0x28564 },
	{ 0x6339, 0x28578 },
	{ 0x633A, 0x28561 },
	{ 0x633B, 0x28569 },
	{ 0x633C, 0x28565 },
	{ 0x633D, 0x286DA },
	{ 0x633E, 0x286E6 },
	{ 0x633F, 0x286DB },
	{ 0x6340, 0x286DC },
	{ 0x6341, 0x28739 },
	{ 0x6342, 0x28757 },
	{ 0x6343, 0x28755 },
	{ 0x6344, 0x28765 },
	{ 0x6345, 0x28761 },
	{ 0x6346, 0x28754 },
	{ 0x6347, 0x28845 },
	{ 0x6348, 0x28841 },
	{ 0x6349, 0x2883E },
	{ 0x634A, 0x28837 },
	{ 0x634B, 0x28912 },
	{ 0x634C, 0x28913 },
	{ 0x634D, 0x2892C },
	{ 0x634E, 0x28996 },
	{ 0x634F, 0x2F9E9 },
	{ 0x6350, 0x2899C },
	{ 0x6351, 0x2899D },
	{ 0x6352, 0x28985 },
	{ 0x6353, 0x2F9E8 },
	{ 0x6354, 0x2899F },
	{ 0x6355, 0x289A3 },
	{ 0x6356, 0x28C82 },
	{ 0x6357, 0x28C83 },
	{ 0x6358, 0x2F9EE },
	{ 0x6359, 0x28D1D },
	{ 0x635A, 0x28D14 },
	{ 0x635B, 0x28D1F },
	{ 0x635C, 0x28D20 },
	{ 0x635D, 0x28E47 },
	{ 0x635E, 0x28E80 },
	{ 0x635F, 0x28EC9 },
	{ 0x6360, 0x28EF9 },
	{ 0x6361, 0x28F06 },
	{ 0x6362, 0x28EF0 },
	{ 0x6363, 0x28EF8 },
	{ 0x6364, 0x28EEF },
	{ 0x6365, 0x28EFD },
	{ 0x6366, 0x28EF1 },
	{ 0x6367, 0x28EFE },
	{ 0x6368, 0x28FB8 },
	{ 0x6369, 0x28FC0 },
	{ 0x636A, 0x28FC3 },
	{ 0x636B, 0x28FB5 },
	{ 0x636C, 0x28FB6 },
	{ 0x636D, 0x28FC9 },
	{ 0x636E, 0x2F9F3 },
	{ 0x636F, 0x28FBD },
	{ 0x6370, 0x28FBA },
	{ 0x6371, 0x28FBF },
	{ 0x6372, 0x28FB3 },
	{ 0x6373, 0x28FC6 },
	{ 0x6374, 0x28FB2 },
	{ 0x6375, 0x28FBC },
	{ 0x6376, 0x28FB7 },
	{ 0x6377, 0x28FB9 },
	{ 0x6378, 0x28FC8 },
	{ 0x6379, 0x290B5 },
	{ 0x637A, 0x290B3 },
	{ 0x637B, 0x4A16 },
	{ 0x637C, 0x290AC },
	{ 0x637D, 0x290A9 },
	{ 0x637E, 0x290AD },
	{ 0x6421, 0x29211 },
	{ 0x6422, 0x2920D },
	{ 0x6423, 0x29216 },
	{ 0x6424, 0x29289 },
	{ 0x6425, 0x2927C },
	{ 0x6426, 0x2928B },
	{ 0x6427, 0x2927B },
	{ 0x6428, 0x29288 },
	{ 0x6429, 0x29284 },
	{ 0x642A, 0x2939D },
	{ 0x642B, 0x29398 },
	{ 0x642C, 0x29488 },
	{ 0x642D, 0x29486 },
	{ 0x642E, 0x29482 },
	{ 0x642F, 0x2948B },
	{ 0x6430, 0x2F9FF },
	{ 0x6431, 0x29471 },
	{ 0x6432, 0x29472 },
	{ 0x6433, 0x29481 },
	{ 0x6434, 0x2948C },
	{ 0x6435, 0x29480 },
	{ 0x6436, 0x29489 },
	{ 0x6437, 0x295BB },
	{ 0x6438, 0x295C1 },
	{ 0x6439, 0x295BE },
	{ 0x643A, 0x2FA01 },
	{ 0x643B, 0x295BD },
	{ 0x643C, 0x296C1 },
	{ 0x643D, 0x296B4 },
	{ 0x643E, 0x296B7 },
	{ 0x643F, 0x296C8 },
	{ 0x6440, 0x4B3B },
	{ 0x6441, 0x296D3 },
	{ 0x6442, 0x296D0 },
	{ 0x6443, 0x296B0 },
	{ 0x6444, 0x296CA },
	{ 0x6445, 0x296CD },
	{ 0x6446, 0x29815 },
	{ 0x6447, 0x29819 },
	{ 0x6448, 0x29817 },
	{ 0x6449, 0x2983F },
	{ 0x644A, 0x29840 },
	{ 0x644B, 0x29844 },
	{ 0x644C, 0x2987C },
	{ 0x644D, 0x29878 },
	{ 0x644E, 0x29879 },
	{ 0x644F, 0x29888 },
	{ 0x6450, 0x2FA06 },
	{ 0x6451, 0x29889 },
	{ 0x6452, 0x2987D },
	{ 0x6453, 0x29A23 },
	{ 0x6454, 0x29A24 },
	{ 0x6455, 0x29A26 },
	{ 0x6456, 0x29A22 },
	{ 0x6457, 0x29A27 },
	{ 0x6458, 0x29A1F },
	{ 0x6459, 0x29AC9 },
	{ 0x645A, 0x29AC3 },
	{ 0x645B, 0x29B0A },
	{ 0x645C, 0x29B0B },
	{ 0x645D, 0x29B04 },
	{ 0x645E, 0x4BEF },
	{ 0x645F, 0x29B03 },
	{ 0x6460, 0x29B01 },
	{ 0x6461, 0x29B09 },
	{ 0x6462, 0x29C0F },
	{ 0x6463, 0x29C2E },
	{ 0x6464, 0x29C2D },
	{ 0x6465, 0x29C91 },
	{ 0x6466, 0x29C99 },
	{ 0x6467, 0x29C9E },
	{ 0x6468, 0x29C90 },
	{ 0x6469, 0x29C94 },
	{ 0x646A, 0x29C9D },
	{ 0x646B, 0x29C98 },
	{ 0x646C, 0x29C9B },
	{ 0x646D, 0x29C9C },
	{ 0x646E, 0x29C9A },
	{ 0x646F, 0x29D54 },
	{ 0x6470, 0x29F9D },
	{ 0x6471, 0x29F9F },
	{ 0x6472, 0x29FA3 },
	{ 0x6473, 0x29FA4 },
	{ 0x6474, 0x29FA5 },
	{ 0x6475, 0x2A302 },
	{ 0x6476, 0x2A417 },
	{ 0x6477, 0x2A41B },
	{ 0x6478, 0x2A419 },
	{ 0x6479, 0x2A4D1 },
	{ 0x647A, 0x21537 }
};

/* CNS 11643 plane #7 */
cns_utf cns7_utf_tab[MAX_CNS7_NUM] = {
	{ 0x2121, 0x20055 },
	{ 0x2122, 0x20182 },
	{ 0x2123, 0x20189 },
	{ 0x2124, 0x20187 },
	{ 0x2125, 0x203BE },
	{ 0x2126, 0x203BD },
	{ 0x2127, 0x203CA },
	{ 0x2128, 0x203D4 },
	{ 0x2129, 0x203BC },
	{ 0x212A, 0x203C4 },
	{ 0x212B, 0x203C1 },
	{ 0x212C, 0x203C2 },
	{ 0x212D, 0x203D7 },
	{ 0x212E, 0x20370 },
	{ 0x212F, 0x203BA },
	{ 0x2130, 0x203E3 },
	{ 0x2131, 0x203BB },
	{ 0x2132, 0x204B1 },
	{ 0x2133, 0x204B6 },
	{ 0x2134, 0x204B0 },
	{ 0x2135, 0x2056C },
	{ 0x2136, 0x2060D },
	{ 0x2137, 0x20607 },
	{ 0x2138, 0x207F1 },
	{ 0x2139, 0x207F5 },
	{ 0x213A, 0x207ED },
	{ 0x213B, 0x207EF },
	{ 0x213C, 0x207EB },
	{ 0x213D, 0x207EC },
	{ 0x213E, 0x207EE },
	{ 0x213F, 0x20807 },
	{ 0x2140, 0x209C4 },
	{ 0x2141, 0x20A08 },
	{ 0x2142, 0x20AB3 },
	{ 0x2143, 0x20AAD },
	{ 0x2144, 0x20AB0 },
	{ 0x2145, 0x20B11 },
	{ 0x2146, 0x2018A },
	{ 0x2147, 0x20F83 },
	{ 0x2148, 0x20F7A },
	{ 0x2149, 0x20F82 },
	{ 0x214A, 0x20F68 },
	{ 0x214B, 0x20F71 },
	{ 0x214C, 0x20FB0 },
	{ 0x214D, 0x20FAF },
	{ 0x214E, 0x35F6 },
	{ 0x214F, 0x20F6C },
	{ 0x2150, 0x20F6F },
	{ 0x2151, 0x20F62 },
	{ 0x2152, 0x20F65 },
	{ 0x2153, 0x20F81 },
	{ 0x2154, 0x20F7F },
	{ 0x2155, 0x20F64 },
	{ 0x2156, 0x20F73 },
	{ 0x2157, 0x20F6E },
	{ 0x2158, 0x20F67 },
	{ 0x2159, 0x20F74 },
	{ 0x215A, 0x20F7D },
	{ 0x215B, 0x20F78 },
	{ 0x215C, 0x20F85 },
	{ 0x215D, 0x20FAA },
	{ 0x215E, 0x20F88 },
	{ 0x215F, 0x20FA6 },
	{ 0x2160, 0x2F84E },
	{ 0x2161, 0x20F8A },
	{ 0x2162, 0x20F84 },
	{ 0x2163, 0x5655 },
	{ 0x2164, 0x21224 },
	{ 0x2165, 0x21222 },
	{ 0x2166, 0x21223 },
	{ 0x2167, 0x21432 },
	{ 0x2168, 0x2145B },
	{ 0x2169, 0x2144F },
	{ 0x216A, 0x3667 },
	{ 0x216B, 0x21426 },
	{ 0x216C, 0x2143E },
	{ 0x216D, 0x21442 },
	{ 0x216E, 0x21447 },
	{ 0x216F, 0x21422 },
	{ 0x2170, 0x2069B },
	{ 0x2171, 0x2144A },
	{ 0x2172, 0x2141F },
	{ 0x2173, 0x21449 },
	{ 0x2174, 0x2142B },
	{ 0x2175, 0x21433 },
	{ 0x2176, 0x2F858 },
	{ 0x2177, 0x2142A },
	{ 0x2178, 0x21428 },
	{ 0x2179, 0x2153D },
	{ 0x217A, 0x2153C },
	{ 0x217B, 0x215BF },
	{ 0x217C, 0x21679 },
	{ 0x217D, 0x21680 },
	{ 0x217E, 0x2167C },
	{ 0x2221, 0x2167A },
	{ 0x2222, 0x21678 },
	{ 0x2223, 0x21882 },
	{ 0x2224, 0x2185C },
	{ 0x2225, 0x2185A },
	{ 0x2226, 0x2184B },
	{ 0x2227, 0x2187C },
	{ 0x2228, 0x2187F },
	{ 0x2229, 0x2181F },
	{ 0x222A, 0x21889 },
	{ 0x222B, 0x2188B },
	{ 0x222C, 0x21857 },
	{ 0x222D, 0x2187E },
	{ 0x222E, 0x2187D },
	{ 0x222F, 0x21853 },
	{ 0x2230, 0x21A9F },
	{ 0x2231, 0x21ABC },
	{ 0x2232, 0x21AA5 },
	{ 0x2233, 0x21A86 },
	{ 0x2234, 0x21ADC },
	{ 0x2235, 0x21AA4 },
	{ 0x2236, 0x21AB6 },
	{ 0x2237, 0x21AA2 },
	{ 0x2238, 0x21AB4 },
	{ 0x2239, 0x21B48 },
	{ 0x223A, 0x21B46 },
	{ 0x223B, 0x21BA7 },
	{ 0x223C, 0x21C14 },
	{ 0x223D, 0x21C12 },
	{ 0x223E, 0x21C11 },
	{ 0x223F, 0x21CE1 },
	{ 0x2240, 0x21CD0 },
	{ 0x2241, 0x21D26 },
	{ 0x2242, 0x21D28 },
	{ 0x2243, 0x21D29 },
	{ 0x2244, 0x21F2F },
	{ 0x2245, 0x21F0D },
	{ 0x2246, 0x21F25 },
	{ 0x2247, 0x21F14 },
	{ 0x2248, 0x21F3C },
	{ 0x2249, 0x21F0B },
	{ 0x224A, 0x21F11 },
	{ 0x224B, 0x21F30 },
	{ 0x224C, 0x21F18 },
	{ 0x224D, 0x21F19 },
	{ 0x224E, 0x21F36 },
	{ 0x224F, 0x21F17 },
	{ 0x2250, 0x21F10 },
	{ 0x2251, 0x21F15 },
	{ 0x2252, 0x22003 },
	{ 0x2253, 0x22029 },
	{ 0x2254, 0x2204C },
	{ 0x2255, 0x2213F },
	{ 0x2256, 0x2213E },
	{ 0x2257, 0x22134 },
	{ 0x2258, 0x22142 },
	{ 0x2259, 0x22135 },
	{ 0x225A, 0x207F3 },
	{ 0x225B, 0x221CD },
	{ 0x225C, 0x221D1 },
	{ 0x225D, 0x221D2 },
	{ 0x225E, 0x222AD },
	{ 0x225F, 0x222BA },
	{ 0x2260, 0x222C1 },
	{ 0x2261, 0x222BB },
	{ 0x2262, 0x222B4 },
	{ 0x2263, 0x222BC },
	{ 0x2264, 0x2236C },
	{ 0x2265, 0x22392 },
	{ 0x2266, 0x22421 },
	{ 0x2267, 0x22424 },
	{ 0x2268, 0x23F19 },
	{ 0x2269, 0x224AD },
	{ 0x226A, 0x224AE },
	{ 0x226B, 0x224AB },
	{ 0x226C, 0x224AC },
	{ 0x226D, 0x22570 },
	{ 0x226E, 0x22576 },
	{ 0x226F, 0x22571 },
	{ 0x2270, 0x22577 },
	{ 0x2271, 0x617F },
	{ 0x2272, 0x227EC },
	{ 0x2273, 0x2281C },
	{ 0x2274, 0x227FB },
	{ 0x2275, 0x227EE },
	{ 0x2276, 0x228E2 },
	{ 0x2277, 0x227FD },
	{ 0x2278, 0x2281E },
	{ 0x2279, 0x2283B },
	{ 0x227A, 0x2284A },
	{ 0x227B, 0x2F8AE },
	{ 0x227C, 0x3992 },
	{ 0x227D, 0x2287D },
	{ 0x227E, 0x22856 },
	{ 0x2321, 0x22844 },
	{ 0x2322, 0x2284B },
	{ 0x2323, 0x229FA },
	{ 0x2324, 0x229E8 },
	{ 0x2325, 0x229F8 },
	{ 0x2326, 0x229FF },
	{ 0x2327, 0x229F7 },
	{ 0x2328, 0x229F6 },
	{ 0x2329, 0x229FE },
	{ 0x232A, 0x22A07 },
	{ 0x232B, 0x22A5D },
	{ 0x232C, 0x22CD4 },
	{ 0x232D, 0x2F8C3 },
	{ 0x232E, 0x22CC8 },
	{ 0x232F, 0x22CC5 },
	{ 0x2330, 0x2F8C0 },
	{ 0x2331, 0x22CC9 },
	{ 0x2332, 0x22D4D },
	{ 0x2333, 0x22D20 },
	{ 0x2334, 0x22D36 },
	{ 0x2335, 0x22D35 },
	{ 0x2336, 0x22D88 },
	{ 0x2337, 0x22D25 },
	{ 0x2338, 0x22D21 },
	{ 0x2339, 0x22D26 },
	{ 0x233A, 0x3A45 },
	{ 0x233B, 0x22D3F },
	{ 0x233C, 0x22D3B },
	{ 0x233D, 0x22D24 },
	{ 0x233E, 0x22D43 },
	{ 0x233F, 0x22D4E },
	{ 0x2340, 0x22D4F },
	{ 0x2341, 0x22D44 },
	{ 0x2342, 0x22D40 },
	{ 0x2343, 0x22D41 },
	{ 0x2344, 0x22D39 },
	{ 0x2345, 0x22D2B },
	{ 0x2346, 0x22EDD },
	{ 0x2347, 0x22EDE },
	{ 0x2348, 0x22FCD },
	{ 0x2349, 0x22FCB },
	{ 0x234A, 0x22FDB },
	{ 0x234B, 0x22FD8 },
	{ 0x234C, 0x22FD9 },
	{ 0x234D, 0x22FD2 },
	{ 0x234E, 0x22FCA },
	{ 0x234F, 0x22FD1 },
	{ 0x2350, 0x22FD4 },
	{ 0x2351, 0x22FF9 },
	{ 0x2352, 0x22FD0 },
	{ 0x2353, 0x2305E },
	{ 0x2354, 0x2305D },
	{ 0x2355, 0x2308A },
	{ 0x2356, 0x23114 },
	{ 0x2357, 0x23283 },
	{ 0x2358, 0x23284 },
	{ 0x2359, 0x2329B },
	{ 0x235A, 0x23282 },
	{ 0x235B, 0x2327D },
	{ 0x235C, 0x2327C },
	{ 0x235D, 0x23299 },
	{ 0x235E, 0x2327E },
	{ 0x235F, 0x2329A },
	{ 0x2360, 0x23295 },
	{ 0x2361, 0x2327B },
	{ 0x2362, 0x23286 },
	{ 0x2363, 0x23348 },
	{ 0x2364, 0x23392 },
	{ 0x2365, 0x235B2 },
	{ 0x2366, 0x23642 },
	{ 0x2367, 0x23672 },
	{ 0x2368, 0x23615 },
	{ 0x2369, 0x23630 },
	{ 0x236A, 0x23643 },
	{ 0x236B, 0x2365B },
	{ 0x236C, 0x2361D },
	{ 0x236D, 0x23673 },
	{ 0x236E, 0x2362D },
	{ 0x236F, 0x3BC9 },
	{ 0x2370, 0x23621 },
	{ 0x2371, 0x2361C },
	{ 0x2372, 0x2F8EA },
	{ 0x2373, 0x23629 },
	{ 0x2374, 0x2361E },
	{ 0x2375, 0x23633 },
	{ 0x2376, 0x23910 },
	{ 0x2377, 0x2390E },
	{ 0x2378, 0x2F8F1 },
	{ 0x2379, 0x2390D },
	{ 0x237A, 0x23911 },
	{ 0x237B, 0x23912 },
	{ 0x237C, 0x23917 },
	{ 0x237D, 0x23909 },
	{ 0x237E, 0x2390F },
	{ 0x2421, 0x23998 },
	{ 0x2422, 0x23994 },
	{ 0x2423, 0x23996 },
	{ 0x2424, 0x23999 },
	{ 0x2425, 0x23995 },
	{ 0x2426, 0x23997 },
	{ 0x2427, 0x23A50 },
	{ 0x2428, 0x23A52 },
	{ 0x2429, 0x23A4D },
	{ 0x242A, 0x23A57 },
	{ 0x242B, 0x23A53 },
	{ 0x242C, 0x23A56 },
	{ 0x242D, 0x23AB8 },
	{ 0x242E, 0x23B12 },
	{ 0x242F, 0x23BF1 },
	{ 0x2430, 0x23BF0 },
	{ 0x2431, 0x23BEE },
	{ 0x2432, 0x23BEF },
	{ 0x2433, 0x23BE5 },
	{ 0x2434, 0x23BEB },
	{ 0x2435, 0x23BE7 },
	{ 0x2436, 0x23BF2 },
	{ 0x2437, 0x23BE6 },
	{ 0x2438, 0x23BF7 },
	{ 0x2439, 0x23C09 },
	{ 0x243A, 0x23C6B },
	{ 0x243B, 0x23C6A },
	{ 0x243C, 0x23E79 },
	{ 0x243D, 0x23ECD },
	{ 0x243E, 0x23EEF },
	{ 0x243F, 0x23EE4 },
	{ 0x2440, 0x23EE3 },
	{ 0x2441, 0x23F6C },
	{ 0x2442, 0x23F67 },
	{ 0x2443, 0x23F62 },
	{ 0x2444, 0x23F58 },
	{ 0x2445, 0x23F69 },
	{ 0x2446, 0x23FAB },
	{ 0x2447, 0x23F57 },
	{ 0x2448, 0x23FAD },
	{ 0x2449, 0x23F54 },
	{ 0x244A, 0x23FAE },
	{ 0x244B, 0x23F76 },
	{ 0x244C, 0x23F49 },
	{ 0x244D, 0x23F45 },
	{ 0x244E, 0x23F4F },
	{ 0x244F, 0x2F90F },
	{ 0x2450, 0x23F50 },
	{ 0x2451, 0x23F7D },
	{ 0x2452, 0x23F44 },
	{ 0x2453, 0x23F66 },
	{ 0x2454, 0x23F48 },
	{ 0x2455, 0x23FA3 },
	{ 0x2456, 0x23F51 },
	{ 0x2457, 0x23F53 },
	{ 0x2458, 0x2F910 },
	{ 0x2459, 0x23F60 },
	{ 0x245A, 0x23F47 },
	{ 0x245B, 0x23F5E },
	{ 0x245C, 0x23F85 },
	{ 0x245D, 0x23FAC },
	{ 0x245E, 0x23F6D },
	{ 0x245F, 0x23F75 },
	{ 0x2460, 0x23FA8 },
	{ 0x2461, 0x3D55 },
	{ 0x2462, 0x23F43 },
	{ 0x2463, 0x23F4E },
	{ 0x2464, 0x23F5C },
	{ 0x2465, 0x23F56 },
	{ 0x2466, 0x23F6E },
	{ 0x2467, 0x23F63 },
	{ 0x2468, 0x23F6A },
	{ 0x2469, 0x24356 },
	{ 0x246A, 0x24312 },
	{ 0x246B, 0x2435C },
	{ 0x246C, 0x24358 },
	{ 0x246D, 0x24355 },
	{ 0x246E, 0x2437E },
	{ 0x246F, 0x243A8 },
	{ 0x2470, 0x24311 },
	{ 0x2471, 0x24359 },
	{ 0x2472, 0x2435A },
	{ 0x2473, 0x24367 },
	{ 0x2474, 0x24354 },
	{ 0x2475, 0x2435B },
	{ 0x2476, 0x243F0 },
	{ 0x2477, 0x24529 },
	{ 0x2478, 0x2452C },
	{ 0x2479, 0x2452A },
	{ 0x247A, 0x24527 },
	{ 0x247B, 0x24567 },
	{ 0x247C, 0x24568 },
	{ 0x247D, 0x24593 },
	{ 0x247E, 0x24595 },
	{ 0x2521, 0x2459A },
	{ 0x2522, 0x245EE },
	{ 0x2523, 0x245F1 },
	{ 0x2524, 0x245ED },
	{ 0x2525, 0x245E9 },
	{ 0x2526, 0x246CB },
	{ 0x2527, 0x246DF },
	{ 0x2528, 0x246DB },
	{ 0x2529, 0x2483C },
	{ 0x252A, 0x2484E },
	{ 0x252B, 0x2486C },
	{ 0x252C, 0x2487B },
	{ 0x252D, 0x2487C },
	{ 0x252E, 0x24883 },
	{ 0x252F, 0x2486B },
	{ 0x2530, 0x24866 },
	{ 0x2531, 0x24863 },
	{ 0x2532, 0x248A0 },
	{ 0x2533, 0x24885 },
	{ 0x2534, 0x24868 },
	{ 0x2535, 0x248A2 },
	{ 0x2536, 0x249EC },
	{ 0x2537, 0x3EE8 },
	{ 0x2538, 0x249E7 },
	{ 0x2539, 0x24A10 },
	{ 0x253A, 0x24A18 },
	{ 0x253B, 0x24A3A },
	{ 0x253C, 0x24A1A },
	{ 0x253D, 0x24A38 },
	{ 0x253E, 0x24A41 },
	{ 0x253F, 0x24A1B },
	{ 0x2540, 0x24A14 },
	{ 0x2541, 0x24A1C },
	{ 0x2542, 0x24A1D },
	{ 0x2543, 0x24B12 },
	{ 0x2544, 0x24B0D },
	{ 0x2545, 0x24B07 },
	{ 0x2546, 0x24B7E },
	{ 0x2547, 0x24B7F },
	{ 0x2548, 0x20AB9 },
	{ 0x2549, 0x24B80 },
	{ 0x254A, 0x24B7A },
	{ 0x254B, 0x24BF3 },
	{ 0x254C, 0x24CB9 },
	{ 0x254D, 0x24CBB },
	{ 0x254E, 0x24CBA },
	{ 0x254F, 0x24CBD },
	{ 0x2550, 0x24CB7 },
	{ 0x2551, 0x24CBF },
	{ 0x2552, 0x24D21 },
	{ 0x2553, 0x24E3A },
	{ 0x2554, 0x24E3D },
	{ 0x2555, 0x24E36 },
	{ 0x2556, 0x24E49 },
	{ 0x2557, 0x24E81 },
	{ 0x2558, 0x3FB6 },
	{ 0x2559, 0x24E3F },
	{ 0x255A, 0x24E4D },
	{ 0x255B, 0x24E3E },
	{ 0x255C, 0x3FBD },
	{ 0x255D, 0x24E30 },
	{ 0x255E, 0x24E4F },
	{ 0x255F, 0x24F37 },
	{ 0x2560, 0x24F98 },
	{ 0x2561, 0x24F99 },
	{ 0x2562, 0x25011 },
	{ 0x2563, 0x2500D },
	{ 0x2564, 0x25088 },
	{ 0x2565, 0x2508A },
	{ 0x2566, 0x2521C },
	{ 0x2567, 0x25255 },
	{ 0x2568, 0x25256 },
	{ 0x2569, 0x25262 },
	{ 0x256A, 0x25257 },
	{ 0x256B, 0x25242 },
	{ 0x256C, 0x25210 },
	{ 0x256D, 0x2524D },
	{ 0x256E, 0x2525A },
	{ 0x256F, 0x25266 },
	{ 0x2570, 0x25246 },
	{ 0x2571, 0x2287E },
	{ 0x2572, 0x2524F },
	{ 0x2573, 0x262F9 },
	{ 0x2574, 0x25387 },
	{ 0x2575, 0x25384 },
	{ 0x2576, 0x253F4 },
	{ 0x2577, 0x253F5 },
	{ 0x2578, 0x253F2 },
	{ 0x2579, 0x253F7 },
	{ 0x257A, 0x25545 },
	{ 0x257B, 0x2F950 },
	{ 0x257C, 0x25549 },
	{ 0x257D, 0x25535 },
	{ 0x257E, 0x254FD },
	{ 0x2621, 0x25530 },
	{ 0x2622, 0x25543 },
	{ 0x2623, 0x25546 },
	{ 0x2624, 0x40D6 },
	{ 0x2625, 0x25533 },
	{ 0x2626, 0x256C6 },
	{ 0x2627, 0x2F956 },
	{ 0x2628, 0x256D4 },
	{ 0x2629, 0x271D8 },
	{ 0x262A, 0x256E0 },
	{ 0x262B, 0x20FA7 },
	{ 0x262C, 0x25744 },
	{ 0x262D, 0x20398 },
	{ 0x262E, 0x25854 },
	{ 0x262F, 0x2583E },
	{ 0x2630, 0x25835 },
	{ 0x2631, 0x2583A },
	{ 0x2632, 0x4171 },
	{ 0x2633, 0x25834 },
	{ 0x2634, 0x25839 },
	{ 0x2635, 0x25846 },
	{ 0x2636, 0x2585A },
	{ 0x2637, 0x2585B },
	{ 0x2638, 0x2583C },
	{ 0x2639, 0x259DC },
	{ 0x263A, 0x259D6 },
	{ 0x263B, 0x259D0 },
	{ 0x263C, 0x2F95E },
	{ 0x263D, 0x25AAC },
	{ 0x263E, 0x2F95D },
	{ 0x263F, 0x25AA5 },
	{ 0x2640, 0x25BF4 },
	{ 0x2641, 0x25C24 },
	{ 0x2642, 0x25BE0 },
	{ 0x2643, 0x25BFD },
	{ 0x2644, 0x25BF2 },
	{ 0x2645, 0x25BFC },
	{ 0x2646, 0x25C02 },
	{ 0x2647, 0x25BF1 },
	{ 0x2648, 0x25BFF },
	{ 0x2649, 0x25BD2 },
	{ 0x264A, 0x25BD8 },
	{ 0x264B, 0x25BD3 },
	{ 0x264C, 0x25BF9 },
	{ 0x264D, 0x2F963 },
	{ 0x264E, 0x25BED },
	{ 0x264F, 0x25BF7 },
	{ 0x2650, 0x25BF0 },
	{ 0x2651, 0x25BD7 },
	{ 0x2652, 0x25C09 },
	{ 0x2653, 0x25BF5 },
	{ 0x2654, 0x25EC2 },
	{ 0x2655, 0x25EC5 },
	{ 0x2656, 0x25ECF },
	{ 0x2657, 0x4298 },
	{ 0x2658, 0x25EC1 },
	{ 0x2659, 0x25EC6 },
	{ 0x265A, 0x25ED4 },
	{ 0x265B, 0x25ECE },
	{ 0x265C, 0x2609B },
	{ 0x265D, 0x26099 },
	{ 0x265E, 0x2608F },
	{ 0x265F, 0x260B7 },
	{ 0x2660, 0x26082 },
	{ 0x2661, 0x26093 },
	{ 0x2662, 0x260B4 },
	{ 0x2663, 0x260C1 },
	{ 0x2664, 0x26090 },
	{ 0x2665, 0x2609A },
	{ 0x2666, 0x26094 },
	{ 0x2667, 0x2609C },
	{ 0x2668, 0x260B5 },
	{ 0x2669, 0x2F96F },
	{ 0x266A, 0x2F96E },
	{ 0x266B, 0x2609F },
	{ 0x266C, 0x2608E },
	{ 0x266D, 0x2609E },
	{ 0x266E, 0x2623C },
	{ 0x266F, 0x26247 },
	{ 0x2670, 0x26241 },
	{ 0x2671, 0x262EB },
	{ 0x2672, 0x262EC },
	{ 0x2673, 0x262ED },
	{ 0x2674, 0x262EE },
	{ 0x2675, 0x262DF },
	{ 0x2676, 0x262F2 },
	{ 0x2677, 0x2630D },
	{ 0x2678, 0x2630E },
	{ 0x2679, 0x20186 },
	{ 0x267A, 0x263A9 },
	{ 0x267B, 0x263A4 },
	{ 0x267C, 0x263A5 },
	{ 0x267D, 0x2645F },
	{ 0x267E, 0x2645A },
	{ 0x2721, 0x26466 },
	{ 0x2722, 0x26468 },
	{ 0x2723, 0x2646A },
	{ 0x2724, 0x26464 },
	{ 0x2725, 0x26465 },
	{ 0x2726, 0x264C1 },
	{ 0x2727, 0x264D8 },
	{ 0x2728, 0x2F97B },
	{ 0x2729, 0x264D9 },
	{ 0x272A, 0x26509 },
	{ 0x272B, 0x265AA },
	{ 0x272C, 0x265A3 },
	{ 0x272D, 0x265B9 },
	{ 0x272E, 0x259E2 },
	{ 0x272F, 0x265A5 },
	{ 0x2730, 0x265AB },
	{ 0x2731, 0x26620 },
	{ 0x2732, 0x26789 },
	{ 0x2733, 0x2678B },
	{ 0x2734, 0x267DB },
	{ 0x2735, 0x267E4 },
	{ 0x2736, 0x267EF },
	{ 0x2737, 0x267E2 },
	{ 0x2738, 0x267E9 },
	{ 0x2739, 0x267F0 },
	{ 0x273A, 0x267F3 },
	{ 0x273B, 0x267DD },
	{ 0x273C, 0x2681E },
	{ 0x273D, 0x2691D },
	{ 0x273E, 0x26946 },
	{ 0x273F, 0x2697C },
	{ 0x2740, 0x26980 },
	{ 0x2741, 0x26981 },
	{ 0x2742, 0x26982 },
	{ 0x2743, 0x26987 },
	{ 0x2744, 0x26988 },
	{ 0x2745, 0x2698A },
	{ 0x2746, 0x2698C },
	{ 0x2747, 0x269E7 },
	{ 0x2748, 0x269EB },
	{ 0x2749, 0x269EA },
	{ 0x274A, 0x26A68 },
	{ 0x274B, 0x26A6B },
	{ 0x274C, 0x26A69 },
	{ 0x274D, 0x26A66 },
	{ 0x274E, 0x26A6A },
	{ 0x274F, 0x26A65 },
	{ 0x2750, 0x26AE5 },
	{ 0x2751, 0x26AE4 },
	{ 0x2752, 0x26AE6 },
	{ 0x2753, 0x26D18 },
	{ 0x2754, 0x26E24 },
	{ 0x2755, 0x26E48 },
	{ 0x2756, 0x26E2F },
	{ 0x2757, 0x26E7E },
	{ 0x2758, 0x26D89 },
	{ 0x2759, 0x26E1E },
	{ 0x275A, 0x26E49 },
	{ 0x275B, 0x26E26 },
	{ 0x275C, 0x26E09 },
	{ 0x275D, 0x26E34 },
	{ 0x275E, 0x26E2D },
	{ 0x275F, 0x26E4A },
	{ 0x2760, 0x26E15 },
	{ 0x2761, 0x2F9A9 },
	{ 0x2762, 0x26E33 },
	{ 0x2763, 0x26E28 },
	{ 0x2764, 0x26E27 },
	{ 0x2765, 0x26E20 },
	{ 0x2766, 0x26E2B },
	{ 0x2767, 0x26E29 },
	{ 0x2768, 0x26E6A },
	{ 0x2769, 0x26E0B },
	{ 0x276A, 0x26E0E },
	{ 0x276B, 0x26E1C },
	{ 0x276C, 0x26DFF },
	{ 0x276D, 0x2F9AA },
	{ 0x276E, 0x26E35 },
	{ 0x276F, 0x26E11 },
	{ 0x2770, 0x26E4B },
	{ 0x2771, 0x26E4C },
	{ 0x2772, 0x26E1F },
	{ 0x2773, 0x26E0F },
	{ 0x2774, 0x26E39 },
	{ 0x2775, 0x26E68 },
	{ 0x2776, 0x26E1D },
	{ 0x2777, 0x26E08 },
	{ 0x2778, 0x26E0C },
	{ 0x2779, 0x26E0D },
	{ 0x277A, 0x26E62 },
	{ 0x277B, 0x26EAF },
	{ 0x277C, 0x26E32 },
	{ 0x277D, 0x26E2C },
	{ 0x277E, 0x26E64 },
	{ 0x2821, 0x26E04 },
	{ 0x2822, 0x26E16 },
	{ 0x2823, 0x26E4D },
	{ 0x2824, 0x26E07 },
	{ 0x2825, 0x26EAE },
	{ 0x2826, 0x271D4 },
	{ 0x2827, 0x271D1 },
	{ 0x2828, 0x271D5 },
	{ 0x2829, 0x271D0 },
	{ 0x282A, 0x27371 },
	{ 0x282B, 0x2735D },
	{ 0x282C, 0x2735B },
	{ 0x282D, 0x2737A },
	{ 0x282E, 0x2F9BD },
	{ 0x282F, 0x2737F },
	{ 0x2830, 0x27379 },
	{ 0x2831, 0x27367 },
	{ 0x2832, 0x2739E },
	{ 0x2833, 0x27394 },
	{ 0x2834, 0x27364 },
	{ 0x2835, 0x2735E },
	{ 0x2836, 0x27381 },
	{ 0x2837, 0x2735A },
	{ 0x2838, 0x27357 },
	{ 0x2839, 0x2737C },
	{ 0x283A, 0x27398 },
	{ 0x283B, 0x27366 },
	{ 0x283C, 0x2737E },
	{ 0x283D, 0x27382 },
	{ 0x283E, 0x27368 },
	{ 0x283F, 0x2735F },
	{ 0x2840, 0x27363 },
	{ 0x2841, 0x27397 },
	{ 0x2842, 0x45CD },
	{ 0x2843, 0x27353 },
	{ 0x2844, 0x2737B },
	{ 0x2845, 0x2737D },
	{ 0x2846, 0x27378 },
	{ 0x2847, 0x27406 },
	{ 0x2848, 0x275C0 },
	{ 0x2849, 0x275C2 },
	{ 0x284A, 0x275C3 },
	{ 0x284B, 0x276DC },
	{ 0x284C, 0x276E6 },
	{ 0x284D, 0x276EC },
	{ 0x284E, 0x276F2 },
	{ 0x284F, 0x276E8 },
	{ 0x2850, 0x276EB },
	{ 0x2851, 0x276EA },
	{ 0x2852, 0x276E5 },
	{ 0x2853, 0x276E0 },
	{ 0x2854, 0x276D0 },
	{ 0x2855, 0x276D8 },
	{ 0x2856, 0x276D5 },
	{ 0x2857, 0x276D3 },
	{ 0x2858, 0x276E4 },
	{ 0x2859, 0x276F3 },
	{ 0x285A, 0x276DB },
	{ 0x285B, 0x2772F },
	{ 0x285C, 0x277F9 },
	{ 0x285D, 0x2785D },
	{ 0x285E, 0x2785B },
	{ 0x285F, 0x2784C },
	{ 0x2860, 0x27858 },
	{ 0x2861, 0x27860 },
	{ 0x2862, 0x27853 },
	{ 0x2863, 0x27850 },
	{ 0x2864, 0x27907 },
	{ 0x2865, 0x27908 },
	{ 0x2866, 0x278F4 },
	{ 0x2867, 0x278F6 },
	{ 0x2868, 0x27904 },
	{ 0x2869, 0x278FD },
	{ 0x286A, 0x27905 },
	{ 0x286B, 0x27A28 },
	{ 0x286C, 0x27A56 },
	{ 0x286D, 0x27A42 },
	{ 0x286E, 0x27A5C },
	{ 0x286F, 0x27A3D },
	{ 0x2870, 0x27A2F },
	{ 0x2871, 0x27A2B },
	{ 0x2872, 0x27A58 },
	{ 0x2873, 0x27A61 },
	{ 0x2874, 0x27A2C },
	{ 0x2875, 0x27A51 },
	{ 0x2876, 0x27A50 },
	{ 0x2877, 0x27A3C },
	{ 0x2878, 0x27A36 },
	{ 0x2879, 0x46F6 },
	{ 0x287A, 0x27A60 },
	{ 0x287B, 0x27A5B },
	{ 0x287C, 0x27A2E },
	{ 0x287D, 0x27A40 },
	{ 0x287E, 0x27A5F },
	{ 0x2921, 0x27A26 },
	{ 0x2922, 0x27A2D },
	{ 0x2923, 0x27A5E },
	{ 0x2924, 0x27A3B },
	{ 0x2925, 0x27BEF },
	{ 0x2926, 0x27BF3 },
	{ 0x2927, 0x27BEE },
	{ 0x2928, 0x27BED },
	{ 0x2929, 0x27C5A },
	{ 0x292A, 0x27C62 },
	{ 0x292B, 0x27C5B },
	{ 0x292C, 0x27C5F },
	{ 0x292D, 0x27C5E },
	{ 0x292E, 0x27C64 },
	{ 0x292F, 0x27CE0 },
	{ 0x2930, 0x27CE1 },
	{ 0x2931, 0x27CE5 },
	{ 0x2932, 0x27DA5 },
	{ 0x2933, 0x27D9B },
	{ 0x2934, 0x27D9F },
	{ 0x2935, 0x27D9C },
	{ 0x2936, 0x477A },
	{ 0x2937, 0x27DAA },
	{ 0x2938, 0x27DA4 },
	{ 0x2939, 0x27DA3 },
	{ 0x293A, 0x27E67 },
	{ 0x293B, 0x27F26 },
	{ 0x293C, 0x27F1A },
	{ 0x293D, 0x47B8 },
	{ 0x293E, 0x27F1C },
	{ 0x293F, 0x27F15 },
	{ 0x2940, 0x27F1B },
	{ 0x2941, 0x27F18 },
	{ 0x2942, 0x27F1E },
	{ 0x2943, 0x27F25 },
	{ 0x2944, 0x2F9DC },
	{ 0x2945, 0x2807B },
	{ 0x2946, 0x28075 },
	{ 0x2947, 0x28093 },
	{ 0x2948, 0x2808F },
	{ 0x2949, 0x2807C },
	{ 0x294A, 0x2809B },
	{ 0x294B, 0x28088 },
	{ 0x294C, 0x28091 },
	{ 0x294D, 0x2807E },
	{ 0x294E, 0x4801 },
	{ 0x294F, 0x28086 },
	{ 0x2950, 0x2825B },
	{ 0x2951, 0x28254 },
	{ 0x2952, 0x28335 },
	{ 0x2953, 0x28340 },
	{ 0x2954, 0x28337 },
	{ 0x2955, 0x28329 },
	{ 0x2956, 0x28326 },
	{ 0x2957, 0x28323 },
	{ 0x2958, 0x28330 },
	{ 0x2959, 0x28320 },
	{ 0x295A, 0x28328 },
	{ 0x295B, 0x28332 },
	{ 0x295C, 0x2832A },
	{ 0x295D, 0x28331 },
	{ 0x295E, 0x28324 },
	{ 0x295F, 0x28341 },
	{ 0x2960, 0x28342 },
	{ 0x2961, 0x28343 },
	{ 0x2962, 0x28325 },
	{ 0x2963, 0x28338 },
	{ 0x2964, 0x2841C },
	{ 0x2965, 0x2841D },
	{ 0x2966, 0x2841E },
	{ 0x2967, 0x284F6 },
	{ 0x2968, 0x285A5 },
	{ 0x2969, 0x28589 },
	{ 0x296A, 0x2859D },
	{ 0x296B, 0x2858A },
	{ 0x296C, 0x28587 },
	{ 0x296D, 0x285AB },
	{ 0x296E, 0x28586 },
	{ 0x296F, 0x2859E },
	{ 0x2970, 0x28593 },
	{ 0x2971, 0x285A1 },
	{ 0x2972, 0x28588 },
	{ 0x2973, 0x285A3 },
	{ 0x2974, 0x2859F },
	{ 0x2975, 0x285A0 },
	{ 0x2976, 0x286FF },
	{ 0x2977, 0x28700 },
	{ 0x2978, 0x28702 },
	{ 0x2979, 0x286F8 },
	{ 0x297A, 0x286F7 },
	{ 0x297B, 0x28701 },
	{ 0x297C, 0x28787 },
	{ 0x297D, 0x28789 },
	{ 0x297E, 0x28776 },
	{ 0x2A21, 0x2876E },
	{ 0x2A22, 0x28777 },
	{ 0x2A23, 0x28782 },
	{ 0x2A24, 0x28785 },
	{ 0x2A25, 0x28783 },
	{ 0x2A26, 0x28784 },
	{ 0x2A27, 0x28857 },
	{ 0x2A28, 0x2884B },
	{ 0x2A29, 0x28856 },
	{ 0x2A2A, 0x2885D },
	{ 0x2A2B, 0x28860 },
	{ 0x2A2C, 0x2884D },
	{ 0x2A2D, 0x28855 },
	{ 0x2A2E, 0x28854 },
	{ 0x2A2F, 0x28853 },
	{ 0x2A30, 0x28850 },
	{ 0x2A31, 0x28863 },
	{ 0x2A32, 0x28862 },
	{ 0x2A33, 0x28917 },
	{ 0x2A34, 0x28916 },
	{ 0x2A35, 0x2892D },
	{ 0x2A36, 0x289D9 },
	{ 0x2A37, 0x289BF },
	{ 0x2A38, 0x492F },
	{ 0x2A39, 0x289B2 },
	{ 0x2A3A, 0x289AC },
	{ 0x2A3B, 0x289B0 },
	{ 0x2A3C, 0x289CF },
	{ 0x2A3D, 0x289B8 },
	{ 0x2A3E, 0x4931 },
	{ 0x2A3F, 0x289D3 },
	{ 0x2A40, 0x289B1 },
	{ 0x2A41, 0x289AF },
	{ 0x2A42, 0x289CE },
	{ 0x2A43, 0x289B4 },
	{ 0x2A44, 0x289B7 },
	{ 0x2A45, 0x289D5 },
	{ 0x2A46, 0x499C },
	{ 0x2A47, 0x28D38 },
	{ 0x2A48, 0x28D28 },
	{ 0x2A49, 0x28D3F },
	{ 0x2A4A, 0x28D40 },
	{ 0x2A4B, 0x28D41 },
	{ 0x2A4C, 0x28D33 },
	{ 0x2A4D, 0x28D2B },
	{ 0x2A4E, 0x28D2E },
	{ 0x2A4F, 0x28F11 },
	{ 0x2A50, 0x28F18 },
	{ 0x2A51, 0x28F17 },
	{ 0x2A52, 0x28F19 },
	{ 0x2A53, 0x28F16 },
	{ 0x2A54, 0x49E6 },
	{ 0x2A55, 0x28F0D },
	{ 0x2A56, 0x28F26 },
	{ 0x2A57, 0x28F79 },
	{ 0x2A58, 0x28FD8 },
	{ 0x2A59, 0x28FF3 },
	{ 0x2A5A, 0x28FD7 },
	{ 0x2A5B, 0x28FCC },
	{ 0x2A5C, 0x28FCF },
	{ 0x2A5D, 0x28FCB },
	{ 0x2A5E, 0x28FD1 },
	{ 0x2A5F, 0x28FCE },
	{ 0x2A60, 0x28FD4 },
	{ 0x2A61, 0x28FD5 },
	{ 0x2A62, 0x28FD3 },
	{ 0x2A63, 0x28FD6 },
	{ 0x2A64, 0x28FCD },
	{ 0x2A65, 0x28FDA },
	{ 0x2A66, 0x28FD2 },
	{ 0x2A67, 0x28FDE },
	{ 0x2A68, 0x290CC },
	{ 0x2A69, 0x290B8 },
	{ 0x2A6A, 0x290B7 },
	{ 0x2A6B, 0x290C2 },
	{ 0x2A6C, 0x290C3 },
	{ 0x2A6D, 0x291FA },
	{ 0x2A6E, 0x291F9 },
	{ 0x2A6F, 0x2921F },
	{ 0x2A70, 0x2921D },
	{ 0x2A71, 0x24382 },
	{ 0x2A72, 0x292A6 },
	{ 0x2A73, 0x29290 },
	{ 0x2A74, 0x2929E },
	{ 0x2A75, 0x29298 },
	{ 0x2A76, 0x29293 },
	{ 0x2A77, 0x29292 },
	{ 0x2A78, 0x292A5 },
	{ 0x2A79, 0x29295 },
	{ 0x2A7A, 0x293A9 },
	{ 0x2A7B, 0x293A8 },
	{ 0x2A7C, 0x293AA },
	{ 0x2A7D, 0x293AB },
	{ 0x2A7E, 0x293AC },
	{ 0x2B21, 0x2941F },
	{ 0x2B22, 0x29422 },
	{ 0x2B23, 0x294AA },
	{ 0x2B24, 0x29496 },
	{ 0x2B25, 0x29491 },
	{ 0x2B26, 0x294AB },
	{ 0x2B27, 0x294A2 },
	{ 0x2B28, 0x294A4 },
	{ 0x2B29, 0x2949D },
	{ 0x2B2A, 0x29497 },
	{ 0x2B2B, 0x2947D },
	{ 0x2B2C, 0x2949F },
	{ 0x2B2D, 0x2949C },
	{ 0x2B2E, 0x29499 },
	{ 0x2B2F, 0x294A6 },
	{ 0x2B30, 0x29492 },
	{ 0x2B31, 0x294A7 },
	{ 0x2B32, 0x295C9 },
	{ 0x2B33, 0x295C8 },
	{ 0x2B34, 0x295C7 },
	{ 0x2B35, 0x295CB },
	{ 0x2B36, 0x29674 },
	{ 0x2B37, 0x296C9 },
	{ 0x2B38, 0x4B38 },
	{ 0x2B39, 0x296D2 },
	{ 0x2B3A, 0x296DB },
	{ 0x2B3B, 0x296EB },
	{ 0x2B3C, 0x296E9 },
	{ 0x2B3D, 0x296EF },
	{ 0x2B3E, 0x296EE },
	{ 0x2B3F, 0x296F9 },
	{ 0x2B40, 0x296DE },
	{ 0x2B41, 0x29816 },
	{ 0x2B42, 0x29845 },
	{ 0x2B43, 0x2987F },
	{ 0x2B44, 0x29898 },
	{ 0x2B45, 0x2989F },
	{ 0x2B46, 0x29886 },
	{ 0x2B47, 0x29890 },
	{ 0x2B48, 0x2989A },
	{ 0x2B49, 0x2989D },
	{ 0x2B4A, 0x2988D },
	{ 0x2B4B, 0x2989C },
	{ 0x2B4C, 0x298A0 },
	{ 0x2B4D, 0x298A7 },
	{ 0x2B4E, 0x2988F },
	{ 0x2B4F, 0x29A41 },
	{ 0x2B50, 0x29A35 },
	{ 0x2B51, 0x29A37 },
	{ 0x2B52, 0x29A30 },
	{ 0x2B53, 0x29A3A },
	{ 0x2B54, 0x29A36 },
	{ 0x2B55, 0x2FA08 },
	{ 0x2B56, 0x29ACA },
	{ 0x2B57, 0x29B12 },
	{ 0x2B58, 0x29B15 },
	{ 0x2B59, 0x29B22 },
	{ 0x2B5A, 0x29B13 },
	{ 0x2B5B, 0x29B18 },
	{ 0x2B5C, 0x29B21 },
	{ 0x2B5D, 0x29C10 },
	{ 0x2B5E, 0x29C20 },
	{ 0x2B5F, 0x29C2F },
	{ 0x2B60, 0x29CA5 },
	{ 0x2B61, 0x29CA3 },
	{ 0x2B62, 0x29CB6 },
	{ 0x2B63, 0x29CAB },
	{ 0x2B64, 0x29D68 },
	{ 0x2B65, 0x29D67 },
	{ 0x2B66, 0x29D6F },
	{ 0x2B67, 0x29D77 },
	{ 0x2B68, 0x29D64 },
	{ 0x2B69, 0x29D78 },
	{ 0x2B6A, 0x4C3A },
	{ 0x2B6B, 0x29D76 },
	{ 0x2B6C, 0x29D6E },
	{ 0x2B6D, 0x4CB1 },
	{ 0x2B6E, 0x29FD0 },
	{ 0x2B6F, 0x29FB3 },
	{ 0x2B70, 0x29FCB },
	{ 0x2B71, 0x29FD6 },
	{ 0x2B72, 0x29FB1 },
	{ 0x2B73, 0x29FB4 },
	{ 0x2B74, 0x29FD7 },
	{ 0x2B75, 0x29FC6 },
	{ 0x2B76, 0x29FBA },
	{ 0x2B77, 0x29FD1 },
	{ 0x2B78, 0x29FD2 },
	{ 0x2B79, 0x29FB5 },
	{ 0x2B7A, 0x29FC4 },
	{ 0x2B7B, 0x29FCC },
	{ 0x2B7C, 0x29FBB },
	{ 0x2B7D, 0x29FB2 },
	{ 0x2B7E, 0x2A25B },
	{ 0x2C21, 0x2A25A },
	{ 0x2C22, 0x2A259 },
	{ 0x2C23, 0x2A299 },
	{ 0x2C24, 0x2A294 },
	{ 0x2C25, 0x2A296 },
	{ 0x2C26, 0x2A293 },
	{ 0x2C27, 0x2A291 },
	{ 0x2C28, 0x2A28F },
	{ 0x2C29, 0x2A298 },
	{ 0x2C2A, 0x2A30C },
	{ 0x2C2B, 0x2A30A },
	{ 0x2C2C, 0x2A30E },
	{ 0x2C2D, 0x2A312 },
	{ 0x2C2E, 0x2A311 },
	{ 0x2C2F, 0x2A30B },
	{ 0x2C30, 0x2A39A },
	{ 0x2C31, 0x4D47 },
	{ 0x2C32, 0x2A3B4 },
	{ 0x2C33, 0x4D51 },
	{ 0x2C34, 0x2A41C },
	{ 0x2C35, 0x2A420 },
	{ 0x2C36, 0x2A421 },
	{ 0x2C37, 0x2A4D3 },
	{ 0x2C38, 0x2A4D2 },
	{ 0x2C39, 0x2A538 },
	{ 0x2C3B, 0x24CCF },
	{ 0x2C3C, 0x2011D },
	{ 0x2C3D, 0x20192 },
	{ 0x2C3E, 0x2018F },
	{ 0x2C3F, 0x2018C },
	{ 0x2C40, 0x203EA },
	{ 0x2C41, 0x204B9 },
	{ 0x2C42, 0x2056E },
	{ 0x2C43, 0x205A0 },
	{ 0x2C44, 0x291DD },
	{ 0x2C45, 0x20612 },
	{ 0x2C46, 0x20617 },
	{ 0x2C47, 0x2066D },
	{ 0x2C48, 0x20805 },
	{ 0x2C49, 0x207FB },
	{ 0x2C4A, 0x207FD },
	{ 0x2C4B, 0x20806 },
	{ 0x2C4C, 0x20800 },
	{ 0x2C4D, 0x207FF },
	{ 0x2C4E, 0x207FE },
	{ 0x2C4F, 0x208B6 },
	{ 0x2C50, 0x20905 },
	{ 0x2C51, 0x20907 },
	{ 0x2C52, 0x20ABC },
	{ 0x2C53, 0x20ABB },
	{ 0x2C54, 0x20B8B },
	{ 0x2C55, 0x20B87 },
	{ 0x2C56, 0x27BFB },
	{ 0x2C57, 0x20FE7 },
	{ 0x2C58, 0x20FE6 },
	{ 0x2C59, 0x20FE2 },
	{ 0x2C5A, 0x285D3 },
	{ 0x2C5B, 0x20FD9 },
	{ 0x2C5C, 0x20FCA },
	{ 0x2C5D, 0x21012 },
	{ 0x2C5E, 0x21010 },
	{ 0x2C5F, 0x20FDC },
	{ 0x2C60, 0x20FD0 },
	{ 0x2C61, 0x20F8B },
	{ 0x2C62, 0x21013 },
	{ 0x2C63, 0x22A10 },
	{ 0x2C64, 0x20FDA },
	{ 0x2C65, 0x2F84F },
	{ 0x2C66, 0x20FFD },
	{ 0x2C67, 0x20FE5 },
	{ 0x2C68, 0x20FCC },
	{ 0x2C69, 0x21039 },
	{ 0x2C6A, 0x20FC7 },
	{ 0x2C6B, 0x20FD8 },
	{ 0x2C6C, 0x21460 },
	{ 0x2C6D, 0x21464 },
	{ 0x2C6E, 0x21486 },
	{ 0x2C6F, 0x2145E },
	{ 0x2C70, 0x21466 },
	{ 0x2C71, 0x2145F },
	{ 0x2C72, 0x21477 },
	{ 0x2C73, 0x21482 },
	{ 0x2C74, 0x21496 },
	{ 0x2C75, 0x2153E },
	{ 0x2C76, 0x21579 },
	{ 0x2C77, 0x2157A },
	{ 0x2C78, 0x21688 },
	{ 0x2C79, 0x21689 },
	{ 0x2C7A, 0x2168C },
	{ 0x2C7B, 0x243E0 },
	{ 0x2C7C, 0x2167B },
	{ 0x2C7D, 0x21686 },
	{ 0x2C7E, 0x21894 },
	{ 0x2D21, 0x21897 },
	{ 0x2D22, 0x218B7 },
	{ 0x2D23, 0x218B5 },
	{ 0x2D24, 0x218B8 },
	{ 0x2D25, 0x21893 },
	{ 0x2D26, 0x218B2 },
	{ 0x2D27, 0x218B4 },
	{ 0x2D28, 0x21899 },
	{ 0x2D29, 0x218C3 },
	{ 0x2D2A, 0x2189D },
	{ 0x2D2B, 0x2189B },
	{ 0x2D2C, 0x218A3 },
	{ 0x2D2D, 0x3747 },
	{ 0x2D2E, 0x2199F },
	{ 0x2D2F, 0x2199E },
	{ 0x2D30, 0x219A3 },
	{ 0x2D31, 0x219A0 },
	{ 0x2D32, 0x219A1 },
	{ 0x2D33, 0x21AC5 },
	{ 0x2D34, 0x21AC6 },
	{ 0x2D35, 0x21ABE },
	{ 0x2D36, 0x21AC4 },
	{ 0x2D37, 0x21ABF },
	{ 0x2D38, 0x21B4C },
	{ 0x2D39, 0x21B4A },
	{ 0x2D3A, 0x21BB1 },
	{ 0x2D3B, 0x21C15 },
	{ 0x2D3C, 0x21C17 },
	{ 0x2D3D, 0x21C10 },
	{ 0x2D3E, 0x21C18 },
	{ 0x2D3F, 0x21CE0 },
	{ 0x2D40, 0x21CDF },
	{ 0x2D41, 0x21D27 },
	{ 0x2D42, 0x21F43 },
	{ 0x2D43, 0x21F48 },
	{ 0x2D44, 0x21F1D },
	{ 0x2D45, 0x21F50 },
	{ 0x2D46, 0x21F58 },
	{ 0x2D47, 0x21F47 },
	{ 0x2D48, 0x21F54 },
	{ 0x2D49, 0x21F53 },
	{ 0x2D4A, 0x21F40 },
	{ 0x2D4B, 0x21F55 },
	{ 0x2D4C, 0x3817 },
	{ 0x2D4D, 0x21F5A },
	{ 0x2D4E, 0x22470 },
	{ 0x2D4F, 0x2215B },
	{ 0x2D50, 0x2214D },
	{ 0x2D51, 0x22156 },
	{ 0x2D52, 0x2214F },
	{ 0x2D53, 0x2F887 },
	{ 0x2D54, 0x22159 },
	{ 0x2D55, 0x2F888 },
	{ 0x2D56, 0x22154 },
	{ 0x2D57, 0x22153 },
	{ 0x2D58, 0x22150 },
	{ 0x2D59, 0x222B3 },
	{ 0x2D5A, 0x2236E },
	{ 0x2D5B, 0x38A3 },
	{ 0x2D5C, 0x2236F },
	{ 0x2D5D, 0x22393 },
	{ 0x2D5E, 0x22429 },
	{ 0x2D5F, 0x22425 },
	{ 0x2D60, 0x22428 },
	{ 0x2D61, 0x2246F },
	{ 0x2D62, 0x232B8 },
	{ 0x2D63, 0x2F897 },
	{ 0x2D64, 0x224B3 },
	{ 0x2D65, 0x22579 },
	{ 0x2D66, 0x2257E },
	{ 0x2D67, 0x2257C },
	{ 0x2D68, 0x22583 },
	{ 0x2D69, 0x2F8AC },
	{ 0x2D6A, 0x22800 },
	{ 0x2D6B, 0x22834 },
	{ 0x2D6C, 0x22865 },
	{ 0x2D6D, 0x22836 },
	{ 0x2D6E, 0x228A7 },
	{ 0x2D6F, 0x22859 },
	{ 0x2D70, 0x22858 },
	{ 0x2D71, 0x22831 },
	{ 0x2D72, 0x22862 },
	{ 0x2D73, 0x22838 },
	{ 0x2D74, 0x22873 },
	{ 0x2D75, 0x2283E },
	{ 0x2D76, 0x22855 },
	{ 0x2D77, 0x22854 },
	{ 0x2D78, 0x22895 },
	{ 0x2D79, 0x2F8AD },
	{ 0x2D7A, 0x228A5 },
	{ 0x2D7B, 0x22894 },
	{ 0x2D7C, 0x2289A },
	{ 0x2D7D, 0x2289B },
	{ 0x2D7E, 0x22899 },
	{ 0x2E21, 0x2289F },
	{ 0x2E22, 0x22853 },
	{ 0x2E23, 0x22A12 },
	{ 0x2E24, 0x22A0A },
	{ 0x2E25, 0x22A09 },
	{ 0x2E26, 0x22A0C },
	{ 0x2E27, 0x22A0B },
	{ 0x2E28, 0x22A0E },
	{ 0x2E29, 0x22A0D },
	{ 0x2E2A, 0x22A08 },
	{ 0x2E2B, 0x22D38 },
	{ 0x2E2C, 0x22D3A },
	{ 0x2E2D, 0x22D37 },
	{ 0x2E2E, 0x22D3D },
	{ 0x2E2F, 0x22D2D },
	{ 0x2E30, 0x22D82 },
	{ 0x2E31, 0x22D95 },
	{ 0x2E32, 0x22D87 },
	{ 0x2E33, 0x22D9D },
	{ 0x2E34, 0x22DB5 },
	{ 0x2E35, 0x22D81 },
	{ 0x2E36, 0x22DC7 },
	{ 0x2E37, 0x22D9B },
	{ 0x2E38, 0x22D98 },
	{ 0x2E39, 0x22D94 },
	{ 0x2E3A, 0x22D86 },
	{ 0x2E3B, 0x22D90 },
	{ 0x2E3C, 0x22D34 },
	{ 0x2E3D, 0x22D8E },
	{ 0x2E3E, 0x22D85 },
	{ 0x2E3F, 0x22DA6 },
	{ 0x2E40, 0x22D96 },
	{ 0x2E41, 0x22FEA },
	{ 0x2E42, 0x22FDF },
	{ 0x2E43, 0x232BD },
	{ 0x2E44, 0x22FF7 },
	{ 0x2E45, 0x22FEB },
	{ 0x2E46, 0x22FE0 },
	{ 0x2E47, 0x22FE8 },
	{ 0x2E48, 0x22FE1 },
	{ 0x2E49, 0x22FE9 },
	{ 0x2E4A, 0x22FEE },
	{ 0x2E4B, 0x22FE5 },
	{ 0x2E4C, 0x22FEC },
	{ 0x2E4D, 0x23063 },
	{ 0x2E4E, 0x230C6 },
	{ 0x2E4F, 0x230C2 },
	{ 0x2E50, 0x230C1 },
	{ 0x2E51, 0x230C0 },
	{ 0x2E52, 0x230C3 },
	{ 0x2E53, 0x23118 },
	{ 0x2E54, 0x232AE },
	{ 0x2E55, 0x232A3 },
	{ 0x2E56, 0x232C5 },
	{ 0x2E57, 0x232A0 },
	{ 0x2E58, 0x232B4 },
	{ 0x2E59, 0x232A5 },
	{ 0x2E5A, 0x3B1E },
	{ 0x2E5B, 0x232A4 },
	{ 0x2E5C, 0x232A8 },
	{ 0x2E5D, 0x232A6 },
	{ 0x2E5E, 0x236A8 },
	{ 0x2E5F, 0x2368D },
	{ 0x2E60, 0x23682 },
	{ 0x2E61, 0x2369E },
	{ 0x2E62, 0x23689 },
	{ 0x2E63, 0x23683 },
	{ 0x2E64, 0x23691 },
	{ 0x2E65, 0x236A6 },
	{ 0x2E66, 0x2369A },
	{ 0x2E67, 0x23690 },
	{ 0x2E68, 0x23685 },
	{ 0x2E69, 0x2367D },
	{ 0x2E6A, 0x2F8EC },
	{ 0x2E6B, 0x2369B },
	{ 0x2E6C, 0x236A5 },
	{ 0x2E6D, 0x236F0 },
	{ 0x2E6E, 0x23696 },
	{ 0x2E6F, 0x23688 },
	{ 0x2E70, 0x236D6 },
	{ 0x2E71, 0x236D8 },
	{ 0x2E72, 0x23686 },
	{ 0x2E73, 0x236A4 },
	{ 0x2E74, 0x23697 },
	{ 0x2E75, 0x2391C },
	{ 0x2E76, 0x23919 },
	{ 0x2E77, 0x2399E },
	{ 0x2E78, 0x2399F },
	{ 0x2E79, 0x2399D },
	{ 0x2E7A, 0x2399C },
	{ 0x2E7B, 0x23A5D },
	{ 0x2E7C, 0x23A5E },
	{ 0x2E7D, 0x23A73 },
	{ 0x2E7E, 0x23A63 },
	{ 0x2F21, 0x23ABE },
	{ 0x2F22, 0x23AC1 },
	{ 0x2F23, 0x23ABC },
	{ 0x2F24, 0x23ABF },
	{ 0x2F25, 0x23ABB },
	{ 0x2F26, 0x23ABD },
	{ 0x2F27, 0x23B13 },
	{ 0x2F28, 0x23B14 },
	{ 0x2F29, 0x23BF8 },
	{ 0x2F2A, 0x23BFA },
	{ 0x2F2B, 0x23C06 },
	{ 0x2F2C, 0x23BFE },
	{ 0x2F2D, 0x23C51 },
	{ 0x2F2E, 0x2400B },
	{ 0x2F2F, 0x23FF1 },
	{ 0x2F30, 0x23FA9 },
	{ 0x2F31, 0x23FD5 },
	{ 0x2F32, 0x23FDC },
	{ 0x2F33, 0x23FCB },
	{ 0x2F34, 0x23FF2 },
	{ 0x2F35, 0x2405F },
	{ 0x2F36, 0x23FDB },
	{ 0x2F37, 0x23FD6 },
	{ 0x2F38, 0x23FD9 },
	{ 0x2F39, 0x23FD1 },
	{ 0x2F3A, 0x23FCF },
	{ 0x2F3B, 0x23FD8 },
	{ 0x2F3C, 0x23FE0 },
	{ 0x2F3D, 0x23FD4 },
	{ 0x2F3E, 0x23FF3 },
	{ 0x2F3F, 0x24005 },
	{ 0x2F40, 0x23FCE },
	{ 0x2F41, 0x23FF4 },
	{ 0x2F42, 0x2F912 },
	{ 0x2F43, 0x23FDA },
	{ 0x2F44, 0x2400E },
	{ 0x2F45, 0x24006 },
	{ 0x2F46, 0x23FD7 },
	{ 0x2F47, 0x23FCD },
	{ 0x2F48, 0x24007 },
	{ 0x2F49, 0x23FE1 },
	{ 0x2F4A, 0x24008 },
	{ 0x2F4B, 0x243BE },
	{ 0x2F4C, 0x243EF },
	{ 0x2F4D, 0x243D9 },
	{ 0x2F4E, 0x243DA },
	{ 0x2F4F, 0x71D7 },
	{ 0x2F50, 0x243A0 },
	{ 0x2F51, 0x243DF },
	{ 0x2F52, 0x2439E },
	{ 0x2F53, 0x243BF },
	{ 0x2F54, 0x243AF },
	{ 0x2F55, 0x243A7 },
	{ 0x2F56, 0x243AA },
	{ 0x2F57, 0x243F4 },
	{ 0x2F58, 0x243AE },
	{ 0x2F59, 0x243B5 },
	{ 0x2F5A, 0x243B8 },
	{ 0x2F5B, 0x243DB },
	{ 0x2F5C, 0x243C0 },
	{ 0x2F5D, 0x243B7 },
	{ 0x2F5E, 0x243A2 },
	{ 0x2F5F, 0x243DD },
	{ 0x2F60, 0x243A1 },
	{ 0x2F61, 0x243A5 },
	{ 0x2F62, 0x243B4 },
	{ 0x2F63, 0x243A6 },
	{ 0x2F64, 0x243AB },
	{ 0x2F65, 0x243AC },
	{ 0x2F66, 0x2439F },
	{ 0x2F67, 0x243B1 },
	{ 0x2F68, 0x243FC },
	{ 0x2F69, 0x2452E },
	{ 0x2F6A, 0x24530 },
	{ 0x2F6B, 0x24599 },
	{ 0x2F6C, 0x245F8 },
	{ 0x2F6D, 0x245F6 },
	{ 0x2F6E, 0x246F4 },
	{ 0x2F6F, 0x246EB },
	{ 0x2F70, 0x246E1 },
	{ 0x2F71, 0x246E4 },
	{ 0x2F72, 0x24875 },
	{ 0x2F73, 0x24869 },
	{ 0x2F74, 0x3E9A },
	{ 0x2F75, 0x24899 },
	{ 0x2F76, 0x2489E },
	{ 0x2F77, 0x24894 },
	{ 0x2F78, 0x24893 },
	{ 0x2F79, 0x24891 },
	{ 0x2F7A, 0x24A19 },
	{ 0x2F7B, 0x24A17 },
	{ 0x2F7C, 0x24A49 },
	{ 0x2F7D, 0x24A47 },
	{ 0x2F7E, 0x24A48 },
	{ 0x3021, 0x24A52 },
	{ 0x3022, 0x24A40 },
	{ 0x3023, 0x24A63 },
	{ 0x3024, 0x24A46 },
	{ 0x3025, 0x24A5F },
	{ 0x3026, 0x24B0E },
	{ 0x3027, 0x24B85 },
	{ 0x3028, 0x24B87 },
	{ 0x3029, 0x24BCB },
	{ 0x302A, 0x24BCC },
	{ 0x302B, 0x24BC9 },
	{ 0x302C, 0x24CCB },
	{ 0x302D, 0x21CE7 },
	{ 0x302E, 0x24D20 },
	{ 0x302F, 0x24E5F },
	{ 0x3030, 0x24E60 },
	{ 0x3031, 0x24E6A },
	{ 0x3032, 0x24E76 },
	{ 0x3033, 0x24E73 },
	{ 0x3034, 0x24E71 },
	{ 0x3035, 0x24E66 },
	{ 0x3036, 0x3FC2 },
	{ 0x3037, 0x24E6B },
	{ 0x3038, 0x24E79 },
	{ 0x3039, 0x24E7B },
	{ 0x303A, 0x24F3C },
	{ 0x303B, 0x24F9E },
	{ 0x303C, 0x24F9C },
	{ 0x303D, 0x2501C },
	{ 0x303E, 0x2501E },
	{ 0x303F, 0x25021 },
	{ 0x3040, 0x25096 },
	{ 0x3041, 0x250A1 },
	{ 0x3042, 0x250B6 },
	{ 0x3043, 0x250A0 },
	{ 0x3044, 0x25094 },
	{ 0x3045, 0x25097 },
	{ 0x3046, 0x25281 },
	{ 0x3047, 0x25286 },
	{ 0x3048, 0x252C0 },
	{ 0x3049, 0x2528A },
	{ 0x304A, 0x2F94B },
	{ 0x304B, 0x25285 },
	{ 0x304C, 0x25295 },
	{ 0x304D, 0x25249 },
	{ 0x304E, 0x25282 },
	{ 0x304F, 0x25284 },
	{ 0x3050, 0x22878 },
	{ 0x3051, 0x25290 },
	{ 0x3052, 0x252B1 },
	{ 0x3053, 0x253FE },
	{ 0x3054, 0x253FB },
	{ 0x3055, 0x25550 },
	{ 0x3056, 0x25556 },
	{ 0x3057, 0x2555A },
	{ 0x3058, 0x2554C },
	{ 0x3059, 0x40DC },
	{ 0x305A, 0x25557 },
	{ 0x305B, 0x256E1 },
	{ 0x305C, 0x256D9 },
	{ 0x305D, 0x256DB },
	{ 0x305E, 0x256F4 },
	{ 0x305F, 0x25745 },
	{ 0x3060, 0x25747 },
	{ 0x3061, 0x25874 },
	{ 0x3062, 0x2586B },
	{ 0x3063, 0x25868 },
	{ 0x3064, 0x25869 },
	{ 0x3065, 0x25879 },
	{ 0x3066, 0x2F95B },
	{ 0x3067, 0x25880 },
	{ 0x3068, 0x25881 },
	{ 0x3069, 0x25861 },
	{ 0x306A, 0x25870 },
	{ 0x306B, 0x2586F },
	{ 0x306C, 0x25873 },
	{ 0x306D, 0x2585D },
	{ 0x306E, 0x259FA },
	{ 0x306F, 0x41B3 },
	{ 0x3070, 0x259F3 },
	{ 0x3071, 0x25A0A },
	{ 0x3072, 0x25A17 },
	{ 0x3073, 0x2F95F },
	{ 0x3074, 0x25AB0 },
	{ 0x3075, 0x25C3E },
	{ 0x3076, 0x25C46 },
	{ 0x3077, 0x25C4F },
	{ 0x3078, 0x25C44 },
	{ 0x3079, 0x25C69 },
	{ 0x307A, 0x25C33 },
	{ 0x307B, 0x25C2F },
	{ 0x307C, 0x25C4E },
	{ 0x307D, 0x25C3A },
	{ 0x307E, 0x25C2B },
	{ 0x3121, 0x25CA9 },
	{ 0x3122, 0x25C50 },
	{ 0x3123, 0x25C45 },
	{ 0x3124, 0x25C37 },
	{ 0x3125, 0x25C25 },
	{ 0x3126, 0x25C2C },
	{ 0x3127, 0x25C3F },
	{ 0x3128, 0x25C34 },
	{ 0x3129, 0x25C29 },
	{ 0x312A, 0x25C1E },
	{ 0x312B, 0x25C3D },
	{ 0x312C, 0x25EED },
	{ 0x312D, 0x2F966 },
	{ 0x312E, 0x25EF3 },
	{ 0x312F, 0x25EEA },
	{ 0x3130, 0x25EEB },
	{ 0x3131, 0x260CC },
	{ 0x3132, 0x260CE },
	{ 0x3133, 0x260D0 },
	{ 0x3134, 0x260E3 },
	{ 0x3135, 0x260E0 },
	{ 0x3136, 0x260D1 },
	{ 0x3137, 0x260DC },
	{ 0x3138, 0x260DD },
	{ 0x3139, 0x260F0 },
	{ 0x313A, 0x260DB },
	{ 0x313B, 0x260E5 },
	{ 0x313C, 0x260F1 },
	{ 0x313D, 0x260C9 },
	{ 0x313E, 0x260E8 },
	{ 0x313F, 0x260E7 },
	{ 0x3140, 0x260C8 },
	{ 0x3141, 0x260DE },
	{ 0x3142, 0x260CD },
	{ 0x3143, 0x260C5 },
	{ 0x3144, 0x260C6 },
	{ 0x3145, 0x260E4 },
	{ 0x3146, 0x260C3 },
	{ 0x3147, 0x262FB },
	{ 0x3148, 0x262FC },
	{ 0x3149, 0x262FE },
	{ 0x314A, 0x26303 },
	{ 0x314B, 0x26300 },
	{ 0x314C, 0x262FD },
	{ 0x314D, 0x26305 },
	{ 0x314E, 0x26313 },
	{ 0x314F, 0x263A7 },
	{ 0x3150, 0x263B4 },
	{ 0x3151, 0x26470 },
	{ 0x3152, 0x26474 },
	{ 0x3153, 0x26471 },
	{ 0x3154, 0x26475 },
	{ 0x3155, 0x2647D },
	{ 0x3156, 0x26473 },
	{ 0x3157, 0x264C4 },
	{ 0x3158, 0x264C3 },
	{ 0x3159, 0x264DE },
	{ 0x315A, 0x264DD },
	{ 0x315B, 0x26511 },
	{ 0x315C, 0x2650F },
	{ 0x315D, 0x26510 },
	{ 0x315E, 0x265C3 },
	{ 0x315F, 0x265C2 },
	{ 0x3160, 0x265CA },
	{ 0x3161, 0x265C1 },
	{ 0x3162, 0x26623 },
	{ 0x3163, 0x267B1 },
	{ 0x3164, 0x26824 },
	{ 0x3165, 0x26811 },
	{ 0x3166, 0x26825 },
	{ 0x3167, 0x2680A },
	{ 0x3168, 0x2681F },
	{ 0x3169, 0x26820 },
	{ 0x316A, 0x26814 },
	{ 0x316B, 0x26828 },
	{ 0x316C, 0x26803 },
	{ 0x316D, 0x26812 },
	{ 0x316E, 0x2680B },
	{ 0x316F, 0x26817 },
	{ 0x3170, 0x22A11 },
	{ 0x3171, 0x26949 },
	{ 0x3172, 0x26989 },
	{ 0x3173, 0x26990 },
	{ 0x3174, 0x2698F },
	{ 0x3175, 0x26996 },
	{ 0x3176, 0x26995 },
	{ 0x3177, 0x26993 },
	{ 0x3178, 0x269ED },
	{ 0x3179, 0x269F0 },
	{ 0x317A, 0x243DE },
	{ 0x317B, 0x26A85 },
	{ 0x317C, 0x26A77 },
	{ 0x317D, 0x26A7A },
	{ 0x317E, 0x26A84 },
	{ 0x3221, 0x26A79 },
	{ 0x3222, 0x26A7D },
	{ 0x3223, 0x26A7B },
	{ 0x3224, 0x26AED },
	{ 0x3225, 0x26AEC },
	{ 0x3226, 0x26DF6 },
	{ 0x3227, 0x26D9B },
	{ 0x3228, 0x26E9D },
	{ 0x3229, 0x26F11 },
	{ 0x322A, 0x26EC4 },
	{ 0x322B, 0x26EC8 },
	{ 0x322C, 0x26EDF },
	{ 0x322D, 0x26EBF },
	{ 0x322E, 0x26EB3 },
	{ 0x322F, 0x26EBA },
	{ 0x3230, 0x26F10 },
	{ 0x3231, 0x26F06 },
	{ 0x3232, 0x26E88 },
	{ 0x3233, 0x26E9A },
	{ 0x3234, 0x26EE0 },
	{ 0x3235, 0x26ECC },
	{ 0x3236, 0x26EB5 },
	{ 0x3237, 0x26EE1 },
	{ 0x3238, 0x26EBC },
	{ 0x3239, 0x26EC6 },
	{ 0x323A, 0x26F0B },
	{ 0x323B, 0x26EA4 },
	{ 0x323C, 0x26E95 },
	{ 0x323D, 0x26EA3 },
	{ 0x323E, 0x26EE2 },
	{ 0x323F, 0x26ECD },
	{ 0x3240, 0x26EE3 },
	{ 0x3241, 0x26EAB },
	{ 0x3242, 0x26ECB },
	{ 0x3243, 0x26E8F },
	{ 0x3244, 0x2F9AB },
	{ 0x3245, 0x26EA9 },
	{ 0x3246, 0x26F24 },
	{ 0x3247, 0x26EE4 },
	{ 0x3248, 0x26F12 },
	{ 0x3249, 0x26EE5 },
	{ 0x324A, 0x26F67 },
	{ 0x324B, 0x26EAA },
	{ 0x324C, 0x26EA0 },
	{ 0x324D, 0x26EE6 },
	{ 0x324E, 0x26EC1 },
	{ 0x324F, 0x26EE7 },
	{ 0x3250, 0x26F0D },
	{ 0x3251, 0x26E86 },
	{ 0x3252, 0x26EB0 },
	{ 0x3253, 0x26E8B },
	{ 0x3254, 0x26EE8 },
	{ 0x3255, 0x26EC9 },
	{ 0x3256, 0x26F19 },
	{ 0x3257, 0x26EC0 },
	{ 0x3258, 0x26F0C },
	{ 0x3259, 0x26EE9 },
	{ 0x325A, 0x26EEA },
	{ 0x325B, 0x271ED },
	{ 0x325C, 0x271E3 },
	{ 0x325D, 0x271E4 },
	{ 0x325E, 0x271E8 },
	{ 0x325F, 0x271D2 },
	{ 0x3260, 0x271E2 },
	{ 0x3261, 0x8666 },
	{ 0x3262, 0x273CF },
	{ 0x3263, 0x273D1 },
	{ 0x3264, 0x273C3 },
	{ 0x3265, 0x273C9 },
	{ 0x3266, 0x273EA },
	{ 0x3267, 0x273B4 },
	{ 0x3268, 0x273DC },
	{ 0x3269, 0x273BD },
	{ 0x326A, 0x273E6 },
	{ 0x326B, 0x273C8 },
	{ 0x326C, 0x273EC },
	{ 0x326D, 0x273B2 },
	{ 0x326E, 0x273A9 },
	{ 0x326F, 0x273D3 },
	{ 0x3270, 0x273C0 },
	{ 0x3271, 0x273E9 },
	{ 0x3272, 0x273D5 },
	{ 0x3273, 0x45D9 },
	{ 0x3274, 0x273C5 },
	{ 0x3275, 0x45DD },
	{ 0x3276, 0x273CB },
	{ 0x3277, 0x273D0 },
	{ 0x3278, 0x273D2 },
	{ 0x3279, 0x273E4 },
	{ 0x327A, 0x273E8 },
	{ 0x327B, 0x273CD },
	{ 0x327C, 0x273B6 },
	{ 0x327D, 0x273AA },
	{ 0x327E, 0x273D4 },
	{ 0x3321, 0x28449 },
	{ 0x3322, 0x273C1 },
	{ 0x3323, 0x273DD },
	{ 0x3324, 0x273CE },
	{ 0x3325, 0x275C9 },
	{ 0x3326, 0x275CA },
	{ 0x3327, 0x276FD },
	{ 0x3328, 0x276D9 },
	{ 0x3329, 0x276FF },
	{ 0x332A, 0x27704 },
	{ 0x332B, 0x276FA },
	{ 0x332C, 0x27706 },
	{ 0x332D, 0x27715 },
	{ 0x332E, 0x27711 },
	{ 0x332F, 0x27707 },
	{ 0x3330, 0x2770B },
	{ 0x3331, 0x277FC },
	{ 0x3332, 0x277FD },
	{ 0x3333, 0x2786D },
	{ 0x3334, 0x27865 },
	{ 0x3335, 0x27914 },
	{ 0x3336, 0x27913 },
	{ 0x3337, 0x2790C },
	{ 0x3338, 0x2790B },
	{ 0x3339, 0x27918 },
	{ 0x333A, 0x27922 },
	{ 0x333B, 0x27A7D },
	{ 0x333C, 0x27A6F },
	{ 0x333D, 0x27A75 },
	{ 0x333E, 0x27A7B },
	{ 0x333F, 0x27A80 },
	{ 0x3340, 0x27A7F },
	{ 0x3341, 0x27A96 },
	{ 0x3342, 0x27A6D },
	{ 0x3343, 0x27A6B },
	{ 0x3344, 0x27A86 },
	{ 0x3345, 0x27A73 },
	{ 0x3346, 0x27A62 },
	{ 0x3347, 0x27A77 },
	{ 0x3348, 0x27A81 },
	{ 0x3349, 0x27A69 },
	{ 0x334A, 0x27A82 },
	{ 0x334B, 0x27A97 },
	{ 0x334C, 0x27A84 },
	{ 0x334D, 0x46FC },
	{ 0x334E, 0x27A78 },
	{ 0x334F, 0x2F9D0 },
	{ 0x3350, 0x27A7A },
	{ 0x3351, 0x27A6A },
	{ 0x3352, 0x27A65 },
	{ 0x3353, 0x27A7E },
	{ 0x3354, 0x27A94 },
	{ 0x3355, 0x27BC2 },
	{ 0x3356, 0x27BC1 },
	{ 0x3357, 0x27BF9 },
	{ 0x3358, 0x27C71 },
	{ 0x3359, 0x27C6B },
	{ 0x335A, 0x27C6D },
	{ 0x335B, 0x27C6F },
	{ 0x335C, 0x27C6E },
	{ 0x335D, 0x27CF2 },
	{ 0x335E, 0x27CE8 },
	{ 0x335F, 0x27CEF },
	{ 0x3360, 0x27CE9 },
	{ 0x3361, 0x27CEA },
	{ 0x3362, 0x27CED },
	{ 0x3363, 0x27CF3 },
	{ 0x3364, 0x27CE6 },
	{ 0x3365, 0x27DC9 },
	{ 0x3366, 0x27DB4 },
	{ 0x3367, 0x27DB3 },
	{ 0x3368, 0x27DB9 },
	{ 0x3369, 0x27DCA },
	{ 0x336A, 0x27DB1 },
	{ 0x336B, 0x27DB6 },
	{ 0x336C, 0x27DC7 },
	{ 0x336D, 0x27DC4 },
	{ 0x336E, 0x27DB7 },
	{ 0x336F, 0x27E6F },
	{ 0x3370, 0x27F33 },
	{ 0x3371, 0x27F32 },
	{ 0x3372, 0x27F1F },
	{ 0x3373, 0x2F9D9 },
	{ 0x3374, 0x27F2B },
	{ 0x3375, 0x27F30 },
	{ 0x3376, 0x27F36 },
	{ 0x3377, 0x27F42 },
	{ 0x3378, 0x27F41 },
	{ 0x3379, 0x2F9D8 },
	{ 0x337A, 0x280A5 },
	{ 0x337B, 0x280AB },
	{ 0x337C, 0x280A9 },
	{ 0x337D, 0x280B3 },
	{ 0x337E, 0x280A7 },
	{ 0x3421, 0x280A0 },
	{ 0x3422, 0x280D2 },
	{ 0x3423, 0x280A8 },
	{ 0x3424, 0x280B6 },
	{ 0x3425, 0x280AC },
	{ 0x3426, 0x280AE },
	{ 0x3427, 0x280E6 },
	{ 0x3428, 0x28265 },
	{ 0x3429, 0x28347 },
	{ 0x342A, 0x28363 },
	{ 0x342B, 0x2834D },
	{ 0x342C, 0x2835F },
	{ 0x342D, 0x2834B },
	{ 0x342E, 0x28360 },
	{ 0x342F, 0x28349 },
	{ 0x3430, 0x28353 },
	{ 0x3431, 0x2F9DF },
	{ 0x3432, 0x8F3A },
	{ 0x3433, 0x28357 },
	{ 0x3434, 0x2834E },
	{ 0x3435, 0x28352 },
	{ 0x3436, 0x28354 },
	{ 0x3437, 0x28420 },
	{ 0x3438, 0x28422 },
	{ 0x3439, 0x285C1 },
	{ 0x343A, 0x285D7 },
	{ 0x343B, 0x285D5 },
	{ 0x343C, 0x285C4 },
	{ 0x343D, 0x285D0 },
	{ 0x343E, 0x285BB },
	{ 0x343F, 0x285E2 },
	{ 0x3440, 0x285CB },
	{ 0x3441, 0x285B8 },
	{ 0x3442, 0x285BF },
	{ 0x3443, 0x285D8 },
	{ 0x3444, 0x285C0 },
	{ 0x3445, 0x285BA },
	{ 0x3446, 0x285B4 },
	{ 0x3447, 0x285BC },
	{ 0x3448, 0x285D4 },
	{ 0x3449, 0x285ED },
	{ 0x344A, 0x285C2 },
	{ 0x344B, 0x285D9 },
	{ 0x344C, 0x285CC },
	{ 0x344D, 0x2872F },
	{ 0x344E, 0x28723 },
	{ 0x344F, 0x28796 },
	{ 0x3450, 0x2878D },
	{ 0x3451, 0x2879E },
	{ 0x3452, 0x28799 },
	{ 0x3453, 0x28883 },
	{ 0x3454, 0x4907 },
	{ 0x3455, 0x2886A },
	{ 0x3456, 0x28869 },
	{ 0x3457, 0x28875 },
	{ 0x3458, 0x2886C },
	{ 0x3459, 0x28880 },
	{ 0x345A, 0x2886E },
	{ 0x345B, 0x28881 },
	{ 0x345C, 0x28877 },
	{ 0x345D, 0x28876 },
	{ 0x345E, 0x28873 },
	{ 0x345F, 0x28870 },
	{ 0x3460, 0x28884 },
	{ 0x3461, 0x28919 },
	{ 0x3462, 0x289F2 },
	{ 0x3463, 0x933D },
	{ 0x3464, 0x289EC },
	{ 0x3465, 0x289EB },
	{ 0x3466, 0x289F6 },
	{ 0x3467, 0x289EF },
	{ 0x3468, 0x289F4 },
	{ 0x3469, 0x289EE },
	{ 0x346A, 0x289F3 },
	{ 0x346B, 0x289ED },
	{ 0x346C, 0x28C9B },
	{ 0x346D, 0x28C98 },
	{ 0x346E, 0x28C94 },
	{ 0x346F, 0x2147A },
	{ 0x3470, 0x28C9A },
	{ 0x3471, 0x2F9F0 },
	{ 0x3472, 0x28D4C },
	{ 0x3473, 0x49A8 },
	{ 0x3474, 0x28D57 },
	{ 0x3475, 0x28D51 },
	{ 0x3476, 0x28D62 },
	{ 0x3477, 0x28D52 },
	{ 0x3478, 0x28D5C },
	{ 0x3479, 0x28D53 },
	{ 0x347A, 0x2F9EF },
	{ 0x347B, 0x28E85 },
	{ 0x347C, 0x28F2D },
	{ 0x347D, 0x28F3E },
	{ 0x347E, 0x28F30 },
	{ 0x3521, 0x28F7D },
	{ 0x3522, 0x28FE6 },
	{ 0x3523, 0x28FF6 },
	{ 0x3524, 0x28FE4 },
	{ 0x3525, 0x28FE9 },
	{ 0x3526, 0x28FEC },
	{ 0x3527, 0x28FF2 },
	{ 0x3528, 0x28FE8 },
	{ 0x3529, 0x28FE3 },
	{ 0x352A, 0x28FEB },
	{ 0x352B, 0x28FF0 },
	{ 0x352C, 0x28FEA },
	{ 0x352D, 0x28FE7 },
	{ 0x352E, 0x28FFD },
	{ 0x352F, 0x28FE5 },
	{ 0x3530, 0x28FEE },
	{ 0x3531, 0x28FF5 },
	{ 0x3532, 0x28FF9 },
	{ 0x3533, 0x28FF1 },
	{ 0x3534, 0x28FF4 },
	{ 0x3535, 0x2F9F4 },
	{ 0x3536, 0x29011 },
	{ 0x3537, 0x290DE },
	{ 0x3538, 0x290D8 },
	{ 0x3539, 0x290DD },
	{ 0x353A, 0x290DB },
	{ 0x353B, 0x290D3 },
	{ 0x353C, 0x290E1 },
	{ 0x353D, 0x291DE },
	{ 0x353E, 0x291FC },
	{ 0x353F, 0x29228 },
	{ 0x3540, 0x292B7 },
	{ 0x3541, 0x292B8 },
	{ 0x3542, 0x292C7 },
	{ 0x3543, 0x292B2 },
	{ 0x3544, 0x292A9 },
	{ 0x3545, 0x292B9 },
	{ 0x3546, 0x292BC },
	{ 0x3547, 0x292B3 },
	{ 0x3548, 0x292D1 },
	{ 0x3549, 0x293B0 },
	{ 0x354A, 0x293B1 },
	{ 0x354B, 0x293B6 },
	{ 0x354C, 0x29404 },
	{ 0x354D, 0x2942C },
	{ 0x354E, 0x294C1 },
	{ 0x354F, 0x2949E },
	{ 0x3550, 0x294BA },
	{ 0x3551, 0x4ACA },
	{ 0x3552, 0x294D1 },
	{ 0x3553, 0x294D3 },
	{ 0x3554, 0x294D4 },
	{ 0x3555, 0x294D5 },
	{ 0x3556, 0x294C5 },
	{ 0x3557, 0x294B6 },
	{ 0x3558, 0x294B2 },
	{ 0x3559, 0x294B5 },
	{ 0x355A, 0x294C3 },
	{ 0x355B, 0x294B9 },
	{ 0x355C, 0x294C6 },
	{ 0x355D, 0x295D6 },
	{ 0x355E, 0x295E0 },
	{ 0x355F, 0x295DB },
	{ 0x3560, 0x295D7 },
	{ 0x3561, 0x295DD },
	{ 0x3562, 0x29715 },
	{ 0x3563, 0x2970C },
	{ 0x3564, 0x2970F },
	{ 0x3565, 0x2970E },
	{ 0x3566, 0x296FE },
	{ 0x3567, 0x29704 },
	{ 0x3568, 0x2970B },
	{ 0x3569, 0x29702 },
	{ 0x356A, 0x296FF },
	{ 0x356B, 0x29708 },
	{ 0x356C, 0x29710 },
	{ 0x356D, 0x29717 },
	{ 0x356E, 0x29713 },
	{ 0x356F, 0x29706 },
	{ 0x3570, 0x29709 },
	{ 0x3571, 0x29824 },
	{ 0x3572, 0x29826 },
	{ 0x3573, 0x29825 },
	{ 0x3574, 0x29848 },
	{ 0x3575, 0x298B5 },
	{ 0x3576, 0x298D2 },
	{ 0x3577, 0x298D5 },
	{ 0x3578, 0x298C4 },
	{ 0x3579, 0x298AF },
	{ 0x357A, 0x298AD },
	{ 0x357B, 0x298C1 },
	{ 0x357C, 0x298C0 },
	{ 0x357D, 0x298CC },
	{ 0x357E, 0x298CD },
	{ 0x3621, 0x298C3 },
	{ 0x3622, 0x298C8 },
	{ 0x3623, 0x298C5 },
	{ 0x3624, 0x298BA },
	{ 0x3625, 0x298D0 },
	{ 0x3626, 0x298C2 },
	{ 0x3627, 0x298CE },
	{ 0x3628, 0x4B8D },
	{ 0x3629, 0x29A43 },
	{ 0x362A, 0x29A42 },
	{ 0x362B, 0x29A40 },
	{ 0x362C, 0x29A31 },
	{ 0x362D, 0x29ACF },
	{ 0x362E, 0x29ACE },
	{ 0x362F, 0x29B30 },
	{ 0x3630, 0x29B34 },
	{ 0x3631, 0x29B32 },
	{ 0x3632, 0x29B43 },
	{ 0x3633, 0x29B3C },
	{ 0x3634, 0x29C11 },
	{ 0x3635, 0x29C35 },
	{ 0x3636, 0x29C34 },
	{ 0x3637, 0x29C37 },
	{ 0x3638, 0x29C31 },
	{ 0x3639, 0x29CBF },
	{ 0x363A, 0x29CBC },
	{ 0x363B, 0x29CC2 },
	{ 0x363C, 0x29CC9 },
	{ 0x363D, 0x29D83 },
	{ 0x363E, 0x29D8B },
	{ 0x363F, 0x29DA0 },
	{ 0x3640, 0x29D8D },
	{ 0x3641, 0x29D8C },
	{ 0x3642, 0x29D9A },
	{ 0x3643, 0x29D8A },
	{ 0x3644, 0x29D91 },
	{ 0x3645, 0x29FF1 },
	{ 0x3646, 0x2A00F },
	{ 0x3647, 0x2A001 },
	{ 0x3648, 0x2A007 },
	{ 0x3649, 0x2A00C },
	{ 0x364A, 0x4CC0 },
	{ 0x364B, 0x29FDC },
	{ 0x364C, 0x29FEE },
	{ 0x364D, 0x29FF7 },
	{ 0x364E, 0x29FF2 },
	{ 0x364F, 0x29FF8 },
	{ 0x3650, 0x29FEB },
	{ 0x3651, 0x4CCA },
	{ 0x3652, 0x29FE6 },
	{ 0x3653, 0x29FED },
	{ 0x3654, 0x29FE9 },
	{ 0x3655, 0x2A008 },
	{ 0x3656, 0x2A000 },
	{ 0x3657, 0x29FE5 },
	{ 0x3658, 0x29FFC },
	{ 0x3659, 0x2A261 },
	{ 0x365A, 0x2A25E },
	{ 0x365B, 0x2A25F },
	{ 0x365C, 0x4D25 },
	{ 0x365D, 0x2A29B },
	{ 0x365E, 0x2A316 },
	{ 0x365F, 0x2A315 },
	{ 0x3660, 0x2A320 },
	{ 0x3661, 0x2A314 },
	{ 0x3662, 0x2A31A },
	{ 0x3663, 0x2A317 },
	{ 0x3664, 0x2A39C },
	{ 0x3665, 0x4D4A },
	{ 0x3666, 0x2A3F1 },
	{ 0x3667, 0x4D53 },
	{ 0x3668, 0x2A3F0 },
	{ 0x3669, 0x2A428 },
	{ 0x366A, 0x2A424 },
	{ 0x366B, 0x2A42A },
	{ 0x366C, 0x2A42B },
	{ 0x366D, 0x2A4D5 },
	{ 0x366E, 0x2A504 },
	{ 0x366F, 0x2A505 },
	{ 0x3670, 0x2A591 },
	{ 0x3671, 0x2A592 },
	{ 0x3672, 0x2A6A6 },
	{ 0x3673, 0x20109 },
	{ 0x3674, 0x20422 },
	{ 0x3675, 0x2041A },
	{ 0x3676, 0x2040E },
	{ 0x3677, 0x2041B },
	{ 0x3678, 0x20408 },
	{ 0x3679, 0x250B3 },
	{ 0x367A, 0x2F81C },
	{ 0x367B, 0x2069D },
	{ 0x367C, 0x20812 },
	{ 0x367D, 0x2081E },
	{ 0x367E, 0x208BB },
	{ 0x3721, 0x208BF },
	{ 0x3722, 0x208BC },
	{ 0x3723, 0x20908 },
	{ 0x3724, 0x20909 },
	{ 0x3725, 0x20963 },
	{ 0x3726, 0x209C8 },
	{ 0x3727, 0x23728 },
	{ 0x3728, 0x20B8E },
	{ 0x3729, 0x20B8D },
	{ 0x372A, 0x21043 },
	{ 0x372B, 0x2104D },
	{ 0x372C, 0x2106D },
	{ 0x372D, 0x21042 },
	{ 0x372E, 0x21052 },
	{ 0x372F, 0x21051 },
	{ 0x3730, 0x21069 },
	{ 0x3731, 0x21050 },
	{ 0x3732, 0x21056 },
	{ 0x3733, 0x2106C },
	{ 0x3734, 0x21044 },
	{ 0x3735, 0x21045 },
	{ 0x3736, 0x2106B },
	{ 0x3737, 0x3605 },
	{ 0x3738, 0x21068 },
	{ 0x3739, 0x21057 },
	{ 0x373A, 0x2122E },
	{ 0x373B, 0x21231 },
	{ 0x373C, 0x2122D },
	{ 0x373D, 0x2148B },
	{ 0x373E, 0x214B2 },
	{ 0x373F, 0x2148D },
	{ 0x3740, 0x214A3 },
	{ 0x3741, 0x214A4 },
	{ 0x3742, 0x21490 },
	{ 0x3743, 0x21489 },
	{ 0x3744, 0x2148E },
	{ 0x3745, 0x21492 },
	{ 0x3746, 0x2157B },
	{ 0x3747, 0x21690 },
	{ 0x3748, 0x2168F },
	{ 0x3749, 0x218E9 },
	{ 0x374A, 0x218CD },
	{ 0x374B, 0x218C5 },
	{ 0x374C, 0x218D0 },
	{ 0x374D, 0x218C9 },
	{ 0x374E, 0x218D1 },
	{ 0x374F, 0x218C7 },
	{ 0x3750, 0x218D2 },
	{ 0x3751, 0x2185F },
	{ 0x3752, 0x218E1 },
	{ 0x3753, 0x218CC },
	{ 0x3754, 0x218C6 },
	{ 0x3755, 0x218E4 },
	{ 0x3756, 0x219A9 },
	{ 0x3757, 0x21AD3 },
	{ 0x3758, 0x21ADA },
	{ 0x3759, 0x21AD2 },
	{ 0x375A, 0x21ADB },
	{ 0x375B, 0x21B4D },
	{ 0x375C, 0x21B4E },
	{ 0x375D, 0x21C1C },
	{ 0x375E, 0x21CE8 },
	{ 0x375F, 0x21F6C },
	{ 0x3760, 0x21F5F },
	{ 0x3761, 0x21F66 },
	{ 0x3762, 0x21F64 },
	{ 0x3763, 0x21F78 },
	{ 0x3764, 0x21F65 },
	{ 0x3765, 0x21F6D },
	{ 0x3766, 0x21F61 },
	{ 0x3767, 0x21F7A },
	{ 0x3768, 0x22007 },
	{ 0x3769, 0x22166 },
	{ 0x376A, 0x22168 },
	{ 0x376B, 0x22162 },
	{ 0x376C, 0x222D3 },
	{ 0x376D, 0x222D4 },
	{ 0x376E, 0x222D1 },
	{ 0x376F, 0x222DC },
	{ 0x3770, 0x22373 },
	{ 0x3771, 0x22372 },
	{ 0x3772, 0x2242D },
	{ 0x3773, 0x2242C },
	{ 0x3774, 0x2242F },
	{ 0x3775, 0x22472 },
	{ 0x3776, 0x224B4 },
	{ 0x3777, 0x22589 },
	{ 0x3778, 0x228CD },
	{ 0x3779, 0x228A6 },
	{ 0x377A, 0x228A2 },
	{ 0x377B, 0x228A0 },
	{ 0x377C, 0x22846 },
	{ 0x377D, 0x228A1 },
	{ 0x377E, 0x26857 },
	{ 0x3821, 0x228A3 },
	{ 0x3822, 0x228B1 },
	{ 0x3823, 0x228DB },
	{ 0x3824, 0x228F6 },
	{ 0x3825, 0x228DC },
	{ 0x3826, 0x228D6 },
	{ 0x3827, 0x22A13 },
	{ 0x3828, 0x22D9C },
	{ 0x3829, 0x22D97 },
	{ 0x382A, 0x22DD8 },
	{ 0x382B, 0x22DE4 },
	{ 0x382C, 0x22DD4 },
	{ 0x382D, 0x22DE5 },
	{ 0x382E, 0x22DDB },
	{ 0x382F, 0x22DD0 },
	{ 0x3830, 0x22DDA },
	{ 0x3831, 0x22DCC },
	{ 0x3832, 0x22DDC },
	{ 0x3833, 0x22DED },
	{ 0x3834, 0x22DD3 },
	{ 0x3835, 0x22DD1 },
	{ 0x3836, 0x22DCE },
	{ 0x3837, 0x22DD9 },
	{ 0x3838, 0x22DDD },
	{ 0x3839, 0x2F8C6 },
	{ 0x383A, 0x22EE6 },
	{ 0x383B, 0x22EE5 },
	{ 0x383C, 0x22EE9 },
	{ 0x383D, 0x22FFF },
	{ 0x383E, 0x22FFE },
	{ 0x383F, 0x2300E },
	{ 0x3840, 0x2308C },
	{ 0x3841, 0x230CA },
	{ 0x3842, 0x230CB },
	{ 0x3843, 0x2311A },
	{ 0x3844, 0x232D7 },
	{ 0x3845, 0x232CF },
	{ 0x3846, 0x232D0 },
	{ 0x3847, 0x232C9 },
	{ 0x3848, 0x232CC },
	{ 0x3849, 0x232D3 },
	{ 0x384A, 0x233A4 },
	{ 0x384B, 0x233A3 },
	{ 0x384C, 0x23681 },
	{ 0x384D, 0x23726 },
	{ 0x384E, 0x236F3 },
	{ 0x384F, 0x23727 },
	{ 0x3850, 0x236F2 },
	{ 0x3851, 0x236FF },
	{ 0x3852, 0x236F5 },
	{ 0x3853, 0x236FC },
	{ 0x3854, 0x2370E },
	{ 0x3855, 0x3BF0 },
	{ 0x3856, 0x236F6 },
	{ 0x3857, 0x23700 },
	{ 0x3858, 0x23723 },
	{ 0x3859, 0x23705 },
	{ 0x385A, 0x23725 },
	{ 0x385B, 0x23708 },
	{ 0x385C, 0x23750 },
	{ 0x385D, 0x23925 },
	{ 0x385E, 0x23920 },
	{ 0x385F, 0x23923 },
	{ 0x3860, 0x23921 },
	{ 0x3861, 0x239A1 },
	{ 0x3862, 0x23A69 },
	{ 0x3863, 0x23A6C },
	{ 0x3864, 0x23A68 },
	{ 0x3865, 0x23A6B },
	{ 0x3866, 0x23ACC },
	{ 0x3867, 0x23ACD },
	{ 0x3868, 0x23C10 },
	{ 0x3869, 0x23C0D },
	{ 0x386A, 0x23C0A },
	{ 0x386B, 0x23C16 },
	{ 0x386C, 0x23C14 },
	{ 0x386D, 0x23C52 },
	{ 0x386E, 0x24028 },
	{ 0x386F, 0x2402E },
	{ 0x3870, 0x2402C },
	{ 0x3871, 0x2404D },
	{ 0x3872, 0x24049 },
	{ 0x3873, 0x24031 },
	{ 0x3874, 0x24030 },
	{ 0x3875, 0x24033 },
	{ 0x3876, 0x2402D },
	{ 0x3877, 0x24036 },
	{ 0x3878, 0x2403E },
	{ 0x3879, 0x2402F },
	{ 0x387A, 0x24027 },
	{ 0x387B, 0x24034 },
	{ 0x387C, 0x2404C },
	{ 0x387D, 0x243FE },
	{ 0x387E, 0x24412 },
	{ 0x3921, 0x2441F },
	{ 0x3922, 0x24417 },
	{ 0x3923, 0x243F5 },
	{ 0x3924, 0x24415 },
	{ 0x3925, 0x243F7 },
	{ 0x3926, 0x3E02 },
	{ 0x3927, 0x21F7D },
	{ 0x3928, 0x243FA },
	{ 0x3929, 0x243F9 },
	{ 0x392A, 0x2444B },
	{ 0x392B, 0x2459C },
	{ 0x392C, 0x2459D },
	{ 0x392D, 0x3E23 },
	{ 0x392E, 0x246F0 },
	{ 0x392F, 0x246F6 },
	{ 0x3930, 0x246EF },
	{ 0x3931, 0x2489D },
	{ 0x3932, 0x2489A },
	{ 0x3933, 0x248A7 },
	{ 0x3934, 0x248AF },
	{ 0x3935, 0x248AA },
	{ 0x3936, 0x24A64 },
	{ 0x3937, 0x24A86 },
	{ 0x3938, 0x24A75 },
	{ 0x3939, 0x24A70 },
	{ 0x393A, 0x24A84 },
	{ 0x393B, 0x24A6B },
	{ 0x393C, 0x24A85 },
	{ 0x393D, 0x24A6C },
	{ 0x393E, 0x24B17 },
	{ 0x393F, 0x24B94 },
	{ 0x3940, 0x24B93 },
	{ 0x3941, 0x24CD2 },
	{ 0x3942, 0x24CD7 },
	{ 0x3943, 0x24CD4 },
	{ 0x3944, 0x24EA6 },
	{ 0x3945, 0x24EA7 },
	{ 0x3946, 0x24E9C },
	{ 0x3947, 0x24E8B },
	{ 0x3948, 0x24E8D },
	{ 0x3949, 0x24E98 },
	{ 0x394A, 0x24EB9 },
	{ 0x394B, 0x24E9B },
	{ 0x394C, 0x24E9D },
	{ 0x394D, 0x24E99 },
	{ 0x394E, 0x24EA8 },
	{ 0x394F, 0x24E91 },
	{ 0x3950, 0x24E87 },
	{ 0x3951, 0x24E9A },
	{ 0x3952, 0x24FA6 },
	{ 0x3953, 0x2501F },
	{ 0x3954, 0x250A7 },
	{ 0x3955, 0x250B1 },
	{ 0x3956, 0x250B2 },
	{ 0x3957, 0x250B7 },
	{ 0x3958, 0x252D0 },
	{ 0x3959, 0x252B3 },
	{ 0x395A, 0x252B5 },
	{ 0x395B, 0x252C4 },
	{ 0x395C, 0x252C3 },
	{ 0x395D, 0x252BC },
	{ 0x395E, 0x252B2 },
	{ 0x395F, 0x252BA },
	{ 0x3960, 0x252BB },
	{ 0x3961, 0x252C2 },
	{ 0x3962, 0x252CD },
	{ 0x3963, 0x252BE },
	{ 0x3964, 0x252B7 },
	{ 0x3965, 0x2538F },
	{ 0x3966, 0x25403 },
	{ 0x3967, 0x25404 },
	{ 0x3968, 0x25571 },
	{ 0x3969, 0x25577 },
	{ 0x396A, 0x25574 },
	{ 0x396B, 0x2558B },
	{ 0x396C, 0x2557A },
	{ 0x396D, 0x2F951 },
	{ 0x396E, 0x2558C },
	{ 0x396F, 0x25573 },
	{ 0x3970, 0x256FF },
	{ 0x3971, 0x256FB },
	{ 0x3972, 0x256FD },
	{ 0x3973, 0x256F0 },
	{ 0x3974, 0x256F3 },
	{ 0x3975, 0x256FC },
	{ 0x3976, 0x256F2 },
	{ 0x3977, 0x25892 },
	{ 0x3978, 0x2589E },
	{ 0x3979, 0x258AE },
	{ 0x397A, 0x25896 },
	{ 0x397B, 0x25A14 },
	{ 0x397C, 0x25A12 },
	{ 0x397D, 0x25A13 },
	{ 0x397E, 0x25A16 },
	{ 0x3A21, 0x25A0F },
	{ 0x3A22, 0x25AB6 },
	{ 0x3A23, 0x25ABD },
	{ 0x3A24, 0x25C8C },
	{ 0x3A25, 0x25CAE },
	{ 0x3A26, 0x25CAC },
	{ 0x3A27, 0x25CAB },
	{ 0x3A28, 0x25C99 },
	{ 0x3A29, 0x25C92 },
	{ 0x3A2A, 0x25CBB },
	{ 0x3A2B, 0x25C9E },
	{ 0x3A2C, 0x25C7E },
	{ 0x3A2D, 0x25CAF },
	{ 0x3A2E, 0x25CBC },
	{ 0x3A2F, 0x25C98 },
	{ 0x3A30, 0x25F01 },
	{ 0x3A31, 0x25F09 },
	{ 0x3A32, 0x25F06 },
	{ 0x3A33, 0x2F967 },
	{ 0x3A34, 0x25F07 },
	{ 0x3A35, 0x25F08 },
	{ 0x3A36, 0x260CF },
	{ 0x3A37, 0x2610E },
	{ 0x3A38, 0x26132 },
	{ 0x3A39, 0x4315 },
	{ 0x3A3A, 0x26112 },
	{ 0x3A3B, 0x26116 },
	{ 0x3A3C, 0x26117 },
	{ 0x3A3D, 0x2611B },
	{ 0x3A3E, 0x26115 },
	{ 0x3A3F, 0x26131 },
	{ 0x3A40, 0x26118 },
	{ 0x3A41, 0x2611A },
	{ 0x3A42, 0x26110 },
	{ 0x3A43, 0x2610A },
	{ 0x3A44, 0x26109 },
	{ 0x3A45, 0x2624F },
	{ 0x3A46, 0x2F973 },
	{ 0x3A47, 0x2630F },
	{ 0x3A48, 0x26310 },
	{ 0x3A49, 0x2F975 },
	{ 0x3A4A, 0x26328 },
	{ 0x3A4B, 0x26311 },
	{ 0x3A4C, 0x26316 },
	{ 0x3A4D, 0x26317 },
	{ 0x3A4E, 0x26302 },
	{ 0x3A4F, 0x263BB },
	{ 0x3A50, 0x263BA },
	{ 0x3A51, 0x263C3 },
	{ 0x3A52, 0x263BC },
	{ 0x3A53, 0x2648A },
	{ 0x3A54, 0x26484 },
	{ 0x3A55, 0x26486 },
	{ 0x3A56, 0x264E0 },
	{ 0x3A57, 0x26517 },
	{ 0x3A58, 0x26518 },
	{ 0x3A59, 0x2651E },
	{ 0x3A5A, 0x26515 },
	{ 0x3A5B, 0x265D3 },
	{ 0x3A5C, 0x265DA },
	{ 0x3A5D, 0x265D9 },
	{ 0x3A5E, 0x267E6 },
	{ 0x3A5F, 0x267F4 },
	{ 0x3A60, 0x267E1 },
	{ 0x3A61, 0x26869 },
	{ 0x3A62, 0x26840 },
	{ 0x3A63, 0x26858 },
	{ 0x3A64, 0x2686C },
	{ 0x3A65, 0x2684D },
	{ 0x3A66, 0x26921 },
	{ 0x3A67, 0x26999 },
	{ 0x3A68, 0x269F1 },
	{ 0x3A69, 0x23F68 },
	{ 0x3A6A, 0x26A86 },
	{ 0x3A6B, 0x26F5B },
	{ 0x3A6C, 0x26F5C },
	{ 0x3A6D, 0x26F77 },
	{ 0x3A6E, 0x26F2C },
	{ 0x3A6F, 0x2F9AD },
	{ 0x3A70, 0x26F58 },
	{ 0x3A71, 0x26F64 },
	{ 0x3A72, 0x26F61 },
	{ 0x3A73, 0x26F48 },
	{ 0x3A74, 0x26F97 },
	{ 0x3A75, 0x26F59 },
	{ 0x3A76, 0x26F29 },
	{ 0x3A77, 0x26F62 },
	{ 0x3A78, 0x26F2E },
	{ 0x3A79, 0x26F68 },
	{ 0x3A7A, 0x26F90 },
	{ 0x3A7B, 0x26F3A },
	{ 0x3A7C, 0x26F3D },
	{ 0x3A7D, 0x26F5E },
	{ 0x3A7E, 0x26F46 },
	{ 0x3B21, 0x26F69 },
	{ 0x3B22, 0x26F65 },
	{ 0x3B23, 0x26F3E },
	{ 0x3B24, 0x26F49 },
	{ 0x3B25, 0x26F56 },
	{ 0x3B26, 0x26FE1 },
	{ 0x3B27, 0x26F78 },
	{ 0x3B28, 0x26F79 },
	{ 0x3B29, 0x26F66 },
	{ 0x3B2A, 0x26F4A },
	{ 0x3B2B, 0x26F35 },
	{ 0x3B2C, 0x26F7A },
	{ 0x3B2D, 0x26F92 },
	{ 0x3B2E, 0x26F60 },
	{ 0x3B2F, 0x26F36 },
	{ 0x3B30, 0x26F51 },
	{ 0x3B31, 0x26F42 },
	{ 0x3B32, 0x455D },
	{ 0x3B33, 0x26F3F },
	{ 0x3B34, 0x26F7B },
	{ 0x3B35, 0x26F5D },
	{ 0x3B36, 0x26F94 },
	{ 0x3B37, 0x26F6A },
	{ 0x3B38, 0x2F9B5 },
	{ 0x3B39, 0x271F2 },
	{ 0x3B3A, 0x273BB },
	{ 0x3B3B, 0x2741B },
	{ 0x3B3C, 0x2741A },
	{ 0x3B3D, 0x27433 },
	{ 0x3B3E, 0x27417 },
	{ 0x3B3F, 0x2740A },
	{ 0x3B40, 0x27415 },
	{ 0x3B41, 0x27412 },
	{ 0x3B42, 0x27401 },
	{ 0x3B43, 0x2742D },
	{ 0x3B44, 0x273FD },
	{ 0x3B45, 0x27423 },
	{ 0x3B46, 0x27405 },
	{ 0x3B47, 0x27411 },
	{ 0x3B48, 0x27400 },
	{ 0x3B49, 0x2741C },
	{ 0x3B4A, 0x27435 },
	{ 0x3B4B, 0x2742E },
	{ 0x3B4C, 0x27436 },
	{ 0x3B4D, 0x20ABF },
	{ 0x3B4E, 0x2742F },
	{ 0x3B4F, 0x2740C },
	{ 0x3B50, 0x27409 },
	{ 0x3B51, 0x27431 },
	{ 0x3B52, 0x273FC },
	{ 0x3B53, 0x2740F },
	{ 0x3B54, 0x27418 },
	{ 0x3B55, 0x27402 },
	{ 0x3B56, 0x27600 },
	{ 0x3B57, 0x2771F },
	{ 0x3B58, 0x27737 },
	{ 0x3B59, 0x465A },
	{ 0x3B5A, 0x27738 },
	{ 0x3B5B, 0x2772B },
	{ 0x3B5C, 0x2772E },
	{ 0x3B5D, 0x27721 },
	{ 0x3B5E, 0x27730 },
	{ 0x3B5F, 0x27729 },
	{ 0x3B60, 0x27731 },
	{ 0x3B61, 0x2F9C9 },
	{ 0x3B62, 0x27701 },
	{ 0x3B63, 0x2772C },
	{ 0x3B64, 0x27722 },
	{ 0x3B65, 0x277FF },
	{ 0x3B66, 0x27877 },
	{ 0x3B67, 0x27867 },
	{ 0x3B68, 0x2787F },
	{ 0x3B69, 0x2787D },
	{ 0x3B6A, 0x2787B },
	{ 0x3B6B, 0x2787E },
	{ 0x3B6C, 0x2791E },
	{ 0x3B6D, 0x2791C },
	{ 0x3B6E, 0x27921 },
	{ 0x3B6F, 0x27926 },
	{ 0x3B70, 0x27927 },
	{ 0x3B71, 0x27929 },
	{ 0x3B72, 0x2792C },
	{ 0x3B73, 0x2791D },
	{ 0x3B74, 0x2792B },
	{ 0x3B75, 0x27ABF },
	{ 0x3B76, 0x27AA4 },
	{ 0x3B77, 0x27AAA },
	{ 0x3B78, 0x27AAE },
	{ 0x3B79, 0x27A9F },
	{ 0x3B7A, 0x27AD0 },
	{ 0x3B7B, 0x27AB1 },
	{ 0x3B7C, 0x27AAD },
	{ 0x3B7D, 0x27A9B },
	{ 0x3B7E, 0x27AB2 },
	{ 0x3C21, 0x27AA9 },
	{ 0x3C22, 0x27AB3 },
	{ 0x3C23, 0x27AB4 },
	{ 0x3C24, 0x27ABA },
	{ 0x3C25, 0x27AA5 },
	{ 0x3C26, 0x27AB7 },
	{ 0x3C27, 0x27AAC },
	{ 0x3C28, 0x27ACB },
	{ 0x3C29, 0x27ACF },
	{ 0x3C2A, 0x27BC6 },
	{ 0x3C2B, 0x27C01 },
	{ 0x3C2C, 0x27BFF },
	{ 0x3C2D, 0x27BFD },
	{ 0x3C2E, 0x27C77 },
	{ 0x3C2F, 0x27C78 },
	{ 0x3C30, 0x27C76 },
	{ 0x3C31, 0x27CF7 },
	{ 0x3C32, 0x27DCC },
	{ 0x3C33, 0x4785 },
	{ 0x3C34, 0x27DD4 },
	{ 0x3C35, 0x27DD7 },
	{ 0x3C36, 0x27DD5 },
	{ 0x3C37, 0x27DD6 },
	{ 0x3C38, 0x27DD3 },
	{ 0x3C39, 0x27F5D },
	{ 0x3C3A, 0x27F55 },
	{ 0x3C3B, 0x280E0 },
	{ 0x3C3C, 0x28148 },
	{ 0x3C3D, 0x280EE },
	{ 0x3C3E, 0x280DB },
	{ 0x3C3F, 0x280E7 },
	{ 0x3C40, 0x280D6 },
	{ 0x3C41, 0x280E5 },
	{ 0x3C42, 0x280E1 },
	{ 0x3C43, 0x280DD },
	{ 0x3C44, 0x280E2 },
	{ 0x3C45, 0x28270 },
	{ 0x3C46, 0x28266 },
	{ 0x3C47, 0x2826F },
	{ 0x3C48, 0x2826E },
	{ 0x3C49, 0x28381 },
	{ 0x3C4A, 0x28369 },
	{ 0x3C4B, 0x2836E },
	{ 0x3C4C, 0x2836D },
	{ 0x3C4D, 0x2836C },
	{ 0x3C4E, 0x28384 },
	{ 0x3C4F, 0x28385 },
	{ 0x3C50, 0x28371 },
	{ 0x3C51, 0x28373 },
	{ 0x3C52, 0x2836A },
	{ 0x3C53, 0x2836F },
	{ 0x3C54, 0x2837B },
	{ 0x3C55, 0x2856A },
	{ 0x3C56, 0x2857C },
	{ 0x3C57, 0x2857D },
	{ 0x3C58, 0x28581 },
	{ 0x3C59, 0x285FA },
	{ 0x3C5A, 0x28605 },
	{ 0x3C5B, 0x285EB },
	{ 0x3C5C, 0x285FB },
	{ 0x3C5D, 0x285E9 },
	{ 0x3C5E, 0x285EF },
	{ 0x3C5F, 0x285FC },
	{ 0x3C60, 0x285E7 },
	{ 0x3C61, 0x2F9E1 },
	{ 0x3C62, 0x285EE },
	{ 0x3C63, 0x285FD },
	{ 0x3C64, 0x28732 },
	{ 0x3C65, 0x287A7 },
	{ 0x3C66, 0x287B5 },
	{ 0x3C67, 0x287B1 },
	{ 0x3C68, 0x287B9 },
	{ 0x3C69, 0x287A8 },
	{ 0x3C6A, 0x287B3 },
	{ 0x3C6B, 0x2F9E6 },
	{ 0x3C6C, 0x2888A },
	{ 0x3C6D, 0x28891 },
	{ 0x3C6E, 0x2888D },
	{ 0x3C6F, 0x28899 },
	{ 0x3C70, 0x490B },
	{ 0x3C71, 0x2889A },
	{ 0x3C72, 0x2889B },
	{ 0x3C73, 0x28892 },
	{ 0x3C74, 0x2888F },
	{ 0x3C75, 0x288AB },
	{ 0x3C76, 0x24CDB },
	{ 0x3C77, 0x4939 },
	{ 0x3C78, 0x28A75 },
	{ 0x3C79, 0x28A31 },
	{ 0x3C7A, 0x28A38 },
	{ 0x3C7B, 0x4937 },
	{ 0x3C7C, 0x28A35 },
	{ 0x3C7D, 0x28A69 },
	{ 0x3C7E, 0x28A3B },
	{ 0x3D21, 0x28A3D },
	{ 0x3D22, 0x28A6C },
	{ 0x3D23, 0x28A79 },
	{ 0x3D24, 0x28A3C },
	{ 0x3D25, 0x28A3E },
	{ 0x3D26, 0x28C97 },
	{ 0x3D27, 0x28CA5 },
	{ 0x3D28, 0x28CA2 },
	{ 0x3D29, 0x28C9D },
	{ 0x3D2A, 0x28CA1 },
	{ 0x3D2B, 0x28D68 },
	{ 0x3D2C, 0x28D6F },
	{ 0x3D2D, 0x28D6D },
	{ 0x3D2E, 0x28D72 },
	{ 0x3D2F, 0x28D75 },
	{ 0x3D30, 0x28D77 },
	{ 0x3D31, 0x28D79 },
	{ 0x3D32, 0x28EB5 },
	{ 0x3D33, 0x28EEA },
	{ 0x3D34, 0x28EAB },
	{ 0x3D35, 0x28F43 },
	{ 0x3D36, 0x28F41 },
	{ 0x3D37, 0x28F42 },
	{ 0x3D38, 0x29009 },
	{ 0x3D39, 0x29008 },
	{ 0x3D3A, 0x29006 },
	{ 0x3D3B, 0x29001 },
	{ 0x3D3C, 0x29003 },
	{ 0x3D3D, 0x29000 },
	{ 0x3D3E, 0x29004 },
	{ 0x3D3F, 0x2900A },
	{ 0x3D40, 0x2900E },
	{ 0x3D41, 0x2900D },
	{ 0x3D42, 0x29007 },
	{ 0x3D43, 0x2900F },
	{ 0x3D44, 0x29014 },
	{ 0x3D45, 0x29002 },
	{ 0x3D46, 0x29015 },
	{ 0x3D47, 0x2900C },
	{ 0x3D48, 0x29010 },
	{ 0x3D49, 0x29005 },
	{ 0x3D4A, 0x290FD },
	{ 0x3D4B, 0x290FF },
	{ 0x3D4C, 0x29104 },
	{ 0x3D4D, 0x29100 },
	{ 0x3D4E, 0x29109 },
	{ 0x3D4F, 0x2922B },
	{ 0x3D50, 0x2F9F7 },
	{ 0x3D51, 0x29231 },
	{ 0x3D52, 0x292DB },
	{ 0x3D53, 0x292C5 },
	{ 0x3D54, 0x292D3 },
	{ 0x3D55, 0x292CE },
	{ 0x3D56, 0x4A6B },
	{ 0x3D57, 0x292C9 },
	{ 0x3D58, 0x292BF },
	{ 0x3D59, 0x292CB },
	{ 0x3D5A, 0x292C0 },
	{ 0x3D5B, 0x292D0 },
	{ 0x3D5C, 0x292D4 },
	{ 0x3D5D, 0x293C1 },
	{ 0x3D5E, 0x293B9 },
	{ 0x3D5F, 0x293BB },
	{ 0x3D60, 0x293C3 },
	{ 0x3D61, 0x293C9 },
	{ 0x3D62, 0x29407 },
	{ 0x3D63, 0x2942D },
	{ 0x3D64, 0x294F8 },
	{ 0x3D65, 0x294E1 },
	{ 0x3D66, 0x294FA },
	{ 0x3D67, 0x294EF },
	{ 0x3D68, 0x294FD },
	{ 0x3D69, 0x4ACD },
	{ 0x3D6A, 0x294EB },
	{ 0x3D6B, 0x294F1 },
	{ 0x3D6C, 0x294ED },
	{ 0x3D6D, 0x294FE },
	{ 0x3D6E, 0x295F8 },
	{ 0x3D6F, 0x29603 },
	{ 0x3D70, 0x295EE },
	{ 0x3D71, 0x295E8 },
	{ 0x3D72, 0x29601 },
	{ 0x3D73, 0x296EC },
	{ 0x3D74, 0x29722 },
	{ 0x3D75, 0x29714 },
	{ 0x3D76, 0x29734 },
	{ 0x3D77, 0x2972F },
	{ 0x3D78, 0x29739 },
	{ 0x3D79, 0x29741 },
	{ 0x3D7A, 0x2973C },
	{ 0x3D7B, 0x29749 },
	{ 0x3D7C, 0x29758 },
	{ 0x3D7D, 0x2973A },
	{ 0x3D7E, 0x29742 },
	{ 0x3E21, 0x2973F },
	{ 0x3E22, 0x29822 },
	{ 0x3E23, 0x29823 },
	{ 0x3E24, 0x2984A },
	{ 0x3E25, 0x298DC },
	{ 0x3E26, 0x298D9 },
	{ 0x3E27, 0x298DB },
	{ 0x3E28, 0x298E2 },
	{ 0x3E29, 0x2FA07 },
	{ 0x3E2A, 0x298DF },
	{ 0x3E2B, 0x298E0 },
	{ 0x3E2C, 0x298D7 },
	{ 0x3E2D, 0x29A4F },
	{ 0x3E2E, 0x29A46 },
	{ 0x3E2F, 0x29A53 },
	{ 0x3E30, 0x29A55 },
	{ 0x3E31, 0x29A4E },
	{ 0x3E32, 0x29A4A },
	{ 0x3E33, 0x29A4C },
	{ 0x3E34, 0x29A63 },
	{ 0x3E35, 0x29B51 },
	{ 0x3E36, 0x29B53 },
	{ 0x3E37, 0x29B58 },
	{ 0x3E38, 0x29B4D },
	{ 0x3E39, 0x29B5A },
	{ 0x3E3A, 0x29B49 },
	{ 0x3E3B, 0x29B5D },
	{ 0x3E3C, 0x29C12 },
	{ 0x3E3D, 0x29C3C },
	{ 0x3E3E, 0x29CD1 },
	{ 0x3E3F, 0x29CDF },
	{ 0x3E40, 0x29CD6 },
	{ 0x3E41, 0x29CD8 },
	{ 0x3E42, 0x29CE0 },
	{ 0x3E43, 0x29CD9 },
	{ 0x3E44, 0x29DB1 },
	{ 0x3E45, 0x29DAC },
	{ 0x3E46, 0x29DAA },
	{ 0x3E47, 0x29DEE },
	{ 0x3E48, 0x29DBD },
	{ 0x3E49, 0x4C4D },
	{ 0x3E4A, 0x29DC3 },
	{ 0x3E4B, 0x29DA8 },
	{ 0x3E4C, 0x29DAE },
	{ 0x3E4D, 0x29DAB },
	{ 0x3E4E, 0x2A01D },
	{ 0x3E4F, 0x2A027 },
	{ 0x3E50, 0x2A038 },
	{ 0x3E51, 0x2A012 },
	{ 0x3E52, 0x2A048 },
	{ 0x3E53, 0x2A02B },
	{ 0x3E54, 0x2A016 },
	{ 0x3E55, 0x2A019 },
	{ 0x3E56, 0x2A03D },
	{ 0x3E57, 0x2A023 },
	{ 0x3E58, 0x2A02A },
	{ 0x3E59, 0x2A264 },
	{ 0x3E5A, 0x2A2AD },
	{ 0x3E5B, 0x2A2AC },
	{ 0x3E5C, 0x2FA14 },
	{ 0x3E5D, 0x2A2B1 },
	{ 0x3E5E, 0x2A2AF },
	{ 0x3E5F, 0x2A32C },
	{ 0x3E60, 0x2A324 },
	{ 0x3E61, 0x2A325 },
	{ 0x3E62, 0x2A328 },
	{ 0x3E63, 0x2A3F9 },
	{ 0x3E64, 0x2A3F7 },
	{ 0x3E65, 0x2A3FD },
	{ 0x3E66, 0x2A3FE },
	{ 0x3E67, 0x2A439 },
	{ 0x3E68, 0x2A433 },
	{ 0x3E69, 0x2A4D7 },
	{ 0x3E6A, 0x2A4D8 },
	{ 0x3E6B, 0x2A4E4 },
	{ 0x3E6C, 0x214A1 },
	{ 0x3E6D, 0x2A50E },
	{ 0x3E6E, 0x2A53B },
	{ 0x3E6F, 0x2A544 },
	{ 0x3E70, 0x2A542 },
	{ 0x3E71, 0x2A594 },
	{ 0x3E72, 0x2A593 },
	{ 0x3E73, 0x2A5D5 },
	{ 0x3E74, 0x2A6A7 },
	{ 0x3E75, 0x20431 },
	{ 0x3E76, 0x20423 },
	{ 0x3E77, 0x20428 },
	{ 0x3E78, 0x20427 },
	{ 0x3E79, 0x204C6 },
	{ 0x3E7A, 0x205A3 },
	{ 0x3E7B, 0x20621 },
	{ 0x3E7C, 0x2081B },
	{ 0x3E7D, 0x3510 },
	{ 0x3E7E, 0x208C1 },
	{ 0x3F21, 0x208C3 },
	{ 0x3F22, 0x2092A },
	{ 0x3F23, 0x20969 },
	{ 0x3F24, 0x20A27 },
	{ 0x3F25, 0x210B6 },
	{ 0x3F26, 0x210A7 },
	{ 0x3F27, 0x210A4 },
	{ 0x3F28, 0x210A6 },
	{ 0x3F29, 0x21090 },
	{ 0x3F2A, 0x2109E },
	{ 0x3F2B, 0x21094 },
	{ 0x3F2C, 0x210A8 },
	{ 0x3F2D, 0x210A5 },
	{ 0x3F2E, 0x210A2 },
	{ 0x3F2F, 0x21091 },
	{ 0x3F30, 0x367B },
	{ 0x3F31, 0x214BC },
	{ 0x3F32, 0x214BD },
	{ 0x3F33, 0x214B4 },
	{ 0x3F34, 0x214B0 },
	{ 0x3F35, 0x214E4 },
	{ 0x3F36, 0x21545 },
	{ 0x3F37, 0x2154B },
	{ 0x3F38, 0x2157E },
	{ 0x3F39, 0x2157F },
	{ 0x3F3A, 0x2157D },
	{ 0x3F3B, 0x215C3 },
	{ 0x3F3C, 0x218FC },
	{ 0x3F3D, 0x218F7 },
	{ 0x3F3E, 0x218F0 },
	{ 0x3F3F, 0x218ED },
	{ 0x3F40, 0x218F1 },
	{ 0x3F41, 0x218F8 },
	{ 0x3F42, 0x21AE9 },
	{ 0x3F43, 0x21CEB },
	{ 0x3F44, 0x381D },
	{ 0x3F45, 0x21F90 },
	{ 0x3F46, 0x21F8D },
	{ 0x3F47, 0x21F86 },
	{ 0x3F48, 0x21F91 },
	{ 0x3F49, 0x21F8A },
	{ 0x3F4A, 0x22008 },
	{ 0x3F4B, 0x22050 },
	{ 0x3F4C, 0x222EA },
	{ 0x3F4D, 0x222E6 },
	{ 0x3F4E, 0x222E2 },
	{ 0x3F4F, 0x222E7 },
	{ 0x3F50, 0x222ED },
	{ 0x3F51, 0x222E1 },
	{ 0x3F52, 0x22434 },
	{ 0x3F53, 0x22476 },
	{ 0x3F54, 0x22475 },
	{ 0x3F55, 0x22473 },
	{ 0x3F56, 0x224B5 },
	{ 0x3F57, 0x22590 },
	{ 0x3F58, 0x22592 },
	{ 0x3F59, 0x228E1 },
	{ 0x3F5A, 0x228DF },
	{ 0x3F5B, 0x228D5 },
	{ 0x3F5C, 0x228F2 },
	{ 0x3F5D, 0x228FE },
	{ 0x3F5E, 0x22913 },
	{ 0x3F5F, 0x2292E },
	{ 0x3F60, 0x22A19 },
	{ 0x3F61, 0x22E08 },
	{ 0x3F62, 0x64F5 },
	{ 0x3F63, 0x22E05 },
	{ 0x3F64, 0x22E09 },
	{ 0x3F65, 0x22E06 },
	{ 0x3F66, 0x22E03 },
	{ 0x3F67, 0x22DFD },
	{ 0x3F68, 0x22DFC },
	{ 0x3F69, 0x22E02 },
	{ 0x3F6A, 0x22E42 },
	{ 0x3F6B, 0x2301A },
	{ 0x3F6C, 0x23011 },
	{ 0x3F6D, 0x23015 },
	{ 0x3F6E, 0x23016 },
	{ 0x3F6F, 0x230CC },
	{ 0x3F70, 0x230CF },
	{ 0x3F71, 0x230D0 },
	{ 0x3F72, 0x23122 },
	{ 0x3F73, 0x2311E },
	{ 0x3F74, 0x23121 },
	{ 0x3F75, 0x232E5 },
	{ 0x3F76, 0x3B27 },
	{ 0x3F77, 0x23354 },
	{ 0x3F78, 0x232EF },
	{ 0x3F79, 0x23353 },
	{ 0x3F7A, 0x23351 },
	{ 0x3F7B, 0x233AD },
	{ 0x3F7C, 0x23767 },
	{ 0x3F7D, 0x23768 },
	{ 0x3F7E, 0x237A4 },
	{ 0x4021, 0x23777 },
	{ 0x4022, 0x23789 },
	{ 0x4023, 0x23744 },
	{ 0x4024, 0x2378B },
	{ 0x4025, 0x23779 },
	{ 0x4026, 0x2375B },
	{ 0x4027, 0x23743 },
	{ 0x4028, 0x23757 },
	{ 0x4029, 0x2374A },
	{ 0x402A, 0x2377C },
	{ 0x402B, 0x23746 },
	{ 0x402C, 0x2377B },
	{ 0x402D, 0x23756 },
	{ 0x402E, 0x239A8 },
	{ 0x402F, 0x23A76 },
	{ 0x4030, 0x23A72 },
	{ 0x4031, 0x23AD6 },
	{ 0x4032, 0x23AD8 },
	{ 0x4033, 0x23AD1 },
	{ 0x4034, 0x23C22 },
	{ 0x4035, 0x23C20 },
	{ 0x4036, 0x23C23 },
	{ 0x4037, 0x23C1E },
	{ 0x4038, 0x23C6E },
	{ 0x4039, 0x240A3 },
	{ 0x403A, 0x24077 },
	{ 0x403B, 0x240A6 },
	{ 0x403C, 0x2406D },
	{ 0x403D, 0x240A2 },
	{ 0x403E, 0x2407C },
	{ 0x403F, 0x24084 },
	{ 0x4040, 0x24068 },
	{ 0x4041, 0x24074 },
	{ 0x4042, 0x24086 },
	{ 0x4043, 0x240A5 },
	{ 0x4044, 0x2407B },
	{ 0x4045, 0x2407A },
	{ 0x4046, 0x24069 },
	{ 0x4047, 0x24072 },
	{ 0x4048, 0x24076 },
	{ 0x4049, 0x2444A },
	{ 0x404A, 0x24437 },
	{ 0x404B, 0x2442A },
	{ 0x404C, 0x2442D },
	{ 0x404D, 0x24446 },
	{ 0x404E, 0x24428 },
	{ 0x404F, 0x24426 },
	{ 0x4050, 0x24442 },
	{ 0x4051, 0x2442C },
	{ 0x4052, 0x24438 },
	{ 0x4053, 0x2442B },
	{ 0x4054, 0x24433 },
	{ 0x4055, 0x24445 },
	{ 0x4056, 0x24539 },
	{ 0x4057, 0x246F9 },
	{ 0x4058, 0x246FA },
	{ 0x4059, 0x248B8 },
	{ 0x405A, 0x248B7 },
	{ 0x405B, 0x248BB },
	{ 0x405C, 0x248B9 },
	{ 0x405D, 0x248B4 },
	{ 0x405E, 0x24A6F },
	{ 0x405F, 0x24A87 },
	{ 0x4060, 0x24A8F },
	{ 0x4061, 0x24AA2 },
	{ 0x4062, 0x24AA3 },
	{ 0x4063, 0x2F931 },
	{ 0x4064, 0x24B9B },
	{ 0x4065, 0x24B9D },
	{ 0x4066, 0x24BCE },
	{ 0x4067, 0x3FCF },
	{ 0x4068, 0x24EBD },
	{ 0x4069, 0x24EBF },
	{ 0x406A, 0x24E92 },
	{ 0x406B, 0x3FCD },
	{ 0x406C, 0x24EEF },
	{ 0x406D, 0x24EC9 },
	{ 0x406E, 0x24FA4 },
	{ 0x406F, 0x24FA8 },
	{ 0x4070, 0x24FAA },
	{ 0x4071, 0x25028 },
	{ 0x4072, 0x25024 },
	{ 0x4073, 0x25025 },
	{ 0x4074, 0x25026 },
	{ 0x4075, 0x250A9 },
	{ 0x4076, 0x250BA },
	{ 0x4077, 0x250BE },
	{ 0x4078, 0x250BC },
	{ 0x4079, 0x250C0 },
	{ 0x407A, 0x252F0 },
	{ 0x407B, 0x252DF },
	{ 0x407C, 0x252E0 },
	{ 0x407D, 0x252ED },
	{ 0x407E, 0x252DB },
	{ 0x4121, 0x252FB },
	{ 0x4122, 0x252B9 },
	{ 0x4123, 0x252DA },
	{ 0x4124, 0x252EB },
	{ 0x4125, 0x252EC },
	{ 0x4126, 0x2559A },
	{ 0x4127, 0x2559F },
	{ 0x4128, 0x2559B },
	{ 0x4129, 0x25597 },
	{ 0x412A, 0x255A1 },
	{ 0x412B, 0x2570F },
	{ 0x412C, 0x25705 },
	{ 0x412D, 0x25748 },
	{ 0x412E, 0x4182 },
	{ 0x412F, 0x258BC },
	{ 0x4130, 0x258BA },
	{ 0x4131, 0x25ABF },
	{ 0x4132, 0x25D01 },
	{ 0x4133, 0x25CE8 },
	{ 0x4134, 0x25CEF },
	{ 0x4135, 0x25CE4 },
	{ 0x4136, 0x25CE6 },
	{ 0x4137, 0x25D02 },
	{ 0x4138, 0x25CEB },
	{ 0x4139, 0x25CE0 },
	{ 0x413A, 0x25CED },
	{ 0x413B, 0x25CD9 },
	{ 0x413C, 0x2F964 },
	{ 0x413D, 0x25D14 },
	{ 0x413E, 0x25CEE },
	{ 0x413F, 0x4252 },
	{ 0x4140, 0x25D13 },
	{ 0x4141, 0x25CF9 },
	{ 0x4142, 0x25CF8 },
	{ 0x4143, 0x25F25 },
	{ 0x4144, 0x2F969 },
	{ 0x4145, 0x25F19 },
	{ 0x4146, 0x25F20 },
	{ 0x4147, 0x25F43 },
	{ 0x4148, 0x25F3F },
	{ 0x4149, 0x26145 },
	{ 0x414A, 0x2614C },
	{ 0x414B, 0x26149 },
	{ 0x414C, 0x2614F },
	{ 0x414D, 0x26141 },
	{ 0x414E, 0x2613E },
	{ 0x414F, 0x2614D },
	{ 0x4150, 0x26152 },
	{ 0x4151, 0x2614A },
	{ 0x4152, 0x2614E },
	{ 0x4153, 0x26173 },
	{ 0x4154, 0x26142 },
	{ 0x4155, 0x26151 },
	{ 0x4156, 0x26155 },
	{ 0x4157, 0x26150 },
	{ 0x4158, 0x2616C },
	{ 0x415A, 0x2616A },
	{ 0x415B, 0x26153 },
	{ 0x415C, 0x26168 },
	{ 0x415D, 0x26255 },
	{ 0x415E, 0x26256 },
	{ 0x415F, 0x2631C },
	{ 0x4160, 0x2631D },
	{ 0x4161, 0x7F80 },
	{ 0x4162, 0x2631E },
	{ 0x4163, 0x26323 },
	{ 0x4164, 0x2631F },
	{ 0x4165, 0x263E1 },
	{ 0x4166, 0x263CD },
	{ 0x4167, 0x263CB },
	{ 0x4168, 0x263CC },
	{ 0x4169, 0x263C8 },
	{ 0x416A, 0x263C9 },
	{ 0x416B, 0x2649B },
	{ 0x416C, 0x26494 },
	{ 0x416D, 0x26492 },
	{ 0x416E, 0x26496 },
	{ 0x416F, 0x26493 },
	{ 0x4170, 0x26495 },
	{ 0x4171, 0x2648F },
	{ 0x4172, 0x2651D },
	{ 0x4173, 0x26522 },
	{ 0x4174, 0x26521 },
	{ 0x4175, 0x265E9 },
	{ 0x4176, 0x265EF },
	{ 0x4177, 0x265E0 },
	{ 0x4178, 0x265E6 },
	{ 0x4179, 0x265E4 },
	{ 0x417A, 0x26829 },
	{ 0x417B, 0x2682C },
	{ 0x417C, 0x26876 },
	{ 0x417D, 0x26883 },
	{ 0x417E, 0x26878 },
	{ 0x4221, 0x2683C },
	{ 0x4222, 0x24443 },
	{ 0x4223, 0x2687A },
	{ 0x4224, 0x4451 },
	{ 0x4225, 0x268F2 },
	{ 0x4226, 0x2699E },
	{ 0x4227, 0x2699B },
	{ 0x4228, 0x2699A },
	{ 0x4229, 0x269F6 },
	{ 0x422A, 0x269F5 },
	{ 0x422B, 0x26AA5 },
	{ 0x422C, 0x26A93 },
	{ 0x422D, 0x26AA4 },
	{ 0x422E, 0x26E82 },
	{ 0x422F, 0x26EC7 },
	{ 0x4230, 0x26FB7 },
	{ 0x4231, 0x2701D },
	{ 0x4232, 0x26FE2 },
	{ 0x4233, 0x26FD7 },
	{ 0x4234, 0x26FE3 },
	{ 0x4235, 0x26FE4 },
	{ 0x4236, 0x26FBC },
	{ 0x4237, 0x26FD3 },
	{ 0x4238, 0x455A },
	{ 0x4239, 0x26F5A },
	{ 0x423A, 0x26FD2 },
	{ 0x423B, 0x26F2D },
	{ 0x423C, 0x2F9AF },
	{ 0x423D, 0x26FC4 },
	{ 0x423E, 0x26FD0 },
	{ 0x423F, 0x26FE5 },
	{ 0x4240, 0x27005 },
	{ 0x4241, 0x27007 },
	{ 0x4242, 0x26FE6 },
	{ 0x4243, 0x2701B },
	{ 0x4244, 0x26FE7 },
	{ 0x4245, 0x26FD8 },
	{ 0x4246, 0x26FBE },
	{ 0x4247, 0x27017 },
	{ 0x4248, 0x26FB4 },
	{ 0x4249, 0x26FD9 },
	{ 0x424A, 0x26FE8 },
	{ 0x424B, 0x26FAD },
	{ 0x424C, 0x26FAF },
	{ 0x424D, 0x26FC8 },
	{ 0x424E, 0x26FE9 },
	{ 0x424F, 0x26FEA },
	{ 0x4250, 0x271FE },
	{ 0x4251, 0x271FB },
	{ 0x4252, 0x27200 },
	{ 0x4253, 0x27472 },
	{ 0x4254, 0x27470 },
	{ 0x4255, 0x27446 },
	{ 0x4256, 0x27459 },
	{ 0x4257, 0x2745E },
	{ 0x4258, 0x27448 },
	{ 0x4259, 0x2744F },
	{ 0x425A, 0x27471 },
	{ 0x425B, 0x27460 },
	{ 0x425C, 0x2745F },
	{ 0x425D, 0x2746E },
	{ 0x425E, 0x27473 },
	{ 0x425F, 0x2F9C0 },
	{ 0x4260, 0x2F9BF },
	{ 0x4261, 0x27447 },
	{ 0x4262, 0x2746D },
	{ 0x4263, 0x2746F },
	{ 0x4264, 0x27481 },
	{ 0x4265, 0x2746C },
	{ 0x4266, 0x27478 },
	{ 0x4267, 0x27483 },
	{ 0x4268, 0x27449 },
	{ 0x4269, 0x27468 },
	{ 0x426A, 0x27474 },
	{ 0x426B, 0x27463 },
	{ 0x426C, 0x2746A },
	{ 0x426D, 0x26885 },
	{ 0x426E, 0x27465 },
	{ 0x426F, 0x27462 },
	{ 0x4270, 0x274C8 },
	{ 0x4271, 0x275D0 },
	{ 0x4272, 0x275D4 },
	{ 0x4273, 0x275D1 },
	{ 0x4274, 0x27603 },
	{ 0x4275, 0x27742 },
	{ 0x4276, 0x27763 },
	{ 0x4277, 0x27756 },
	{ 0x4278, 0x2775B },
	{ 0x4279, 0x27755 },
	{ 0x427A, 0x27750 },
	{ 0x427B, 0x2772D },
	{ 0x427C, 0x27744 },
	{ 0x427D, 0x27748 },
	{ 0x427E, 0x27745 },
	{ 0x4321, 0x27782 },
	{ 0x4322, 0x4665 },
	{ 0x4323, 0x27762 },
	{ 0x4324, 0x27885 },
	{ 0x4325, 0x2788D },
	{ 0x4326, 0x27936 },
	{ 0x4327, 0x2792F },
	{ 0x4328, 0x27931 },
	{ 0x4329, 0x27937 },
	{ 0x432A, 0x27AA7 },
	{ 0x432B, 0x27AD9 },
	{ 0x432C, 0x27AF0 },
	{ 0x432D, 0x27AF2 },
	{ 0x432E, 0x27AFD },
	{ 0x432F, 0x27AE8 },
	{ 0x4330, 0x27AEB },
	{ 0x4331, 0x27AEE },
	{ 0x4332, 0x27AE0 },
	{ 0x4333, 0x27AE9 },
	{ 0x4334, 0x27AED },
	{ 0x4335, 0x27AD6 },
	{ 0x4336, 0x27AF8 },
	{ 0x4337, 0x27AD4 },
	{ 0x4338, 0x27ADF },
	{ 0x4339, 0x27AE7 },
	{ 0x433A, 0x27AD8 },
	{ 0x433B, 0x27AE3 },
	{ 0x433C, 0x27AEF },
	{ 0x433D, 0x27B0F },
	{ 0x433E, 0x27BCA },
	{ 0x433F, 0x21546 },
	{ 0x4340, 0x27C05 },
	{ 0x4341, 0x27C0C },
	{ 0x4342, 0x27C0D },
	{ 0x4343, 0x27C7F },
	{ 0x4344, 0x27C80 },
	{ 0x4345, 0x27C81 },
	{ 0x4346, 0x27D01 },
	{ 0x4347, 0x27D03 },
	{ 0x4348, 0x27DF2 },
	{ 0x4349, 0x27DE2 },
	{ 0x434A, 0x27DE3 },
	{ 0x434B, 0x27DDE },
	{ 0x434C, 0x27DE9 },
	{ 0x434D, 0x27DE8 },
	{ 0x434E, 0x27DE0 },
	{ 0x434F, 0x27E01 },
	{ 0x4350, 0x27DF5 },
	{ 0x4351, 0x27DE4 },
	{ 0x4352, 0x8D01 },
	{ 0x4353, 0x27E77 },
	{ 0x4354, 0x27F74 },
	{ 0x4355, 0x27F6F },
	{ 0x4356, 0x27F62 },
	{ 0x4357, 0x27F61 },
	{ 0x4358, 0x27F6D },
	{ 0x4359, 0x27F73 },
	{ 0x435A, 0x27F6A },
	{ 0x435B, 0x27F69 },
	{ 0x435C, 0x28112 },
	{ 0x435D, 0x2812D },
	{ 0x435E, 0x28114 },
	{ 0x435F, 0x2810F },
	{ 0x4360, 0x28129 },
	{ 0x4361, 0x28116 },
	{ 0x4362, 0x28103 },
	{ 0x4363, 0x28146 },
	{ 0x4364, 0x2815C },
	{ 0x4365, 0x28111 },
	{ 0x4366, 0x28106 },
	{ 0x4367, 0x280DC },
	{ 0x4368, 0x2812B },
	{ 0x4369, 0x2812A },
	{ 0x436A, 0x2812C },
	{ 0x436B, 0x28127 },
	{ 0x436C, 0x2827A },
	{ 0x436D, 0x2839C },
	{ 0x436E, 0x28399 },
	{ 0x436F, 0x28395 },
	{ 0x4370, 0x2838B },
	{ 0x4371, 0x28398 },
	{ 0x4372, 0x28396 },
	{ 0x4373, 0x28432 },
	{ 0x4374, 0x285A4 },
	{ 0x4375, 0x285AA },
	{ 0x4376, 0x2861B },
	{ 0x4377, 0x48AF },
	{ 0x4378, 0x2860D },
	{ 0x4379, 0x2861C },
	{ 0x437A, 0x2860A },
	{ 0x437B, 0x28620 },
	{ 0x437C, 0x28608 },
	{ 0x437D, 0x2861A },
	{ 0x437E, 0x28613 },
	{ 0x4421, 0x28611 },
	{ 0x4422, 0x2875D },
	{ 0x4423, 0x2875F },
	{ 0x4424, 0x2875E },
	{ 0x4425, 0x28760 },
	{ 0x4426, 0x287BB },
	{ 0x4427, 0x287BC },
	{ 0x4428, 0x287C1 },
	{ 0x4429, 0x287C0 },
	{ 0x442A, 0x287C8 },
	{ 0x442B, 0x287CE },
	{ 0x442C, 0x288A7 },
	{ 0x442D, 0x288B2 },
	{ 0x442E, 0x288B6 },
	{ 0x442F, 0x288A5 },
	{ 0x4430, 0x288BA },
	{ 0x4431, 0x288B5 },
	{ 0x4432, 0x288AD },
	{ 0x4433, 0x288A4 },
	{ 0x4434, 0x288D3 },
	{ 0x4435, 0x288B0 },
	{ 0x4436, 0x288B1 },
	{ 0x4437, 0x2891D },
	{ 0x4438, 0x28A8D },
	{ 0x4439, 0x4941 },
	{ 0x443A, 0x28A91 },
	{ 0x443B, 0x28AB6 },
	{ 0x443C, 0x28AB7 },
	{ 0x443D, 0x28ABD },
	{ 0x443E, 0x28ABC },
	{ 0x443F, 0x28A96 },
	{ 0x4440, 0x28A94 },
	{ 0x4441, 0x28AA0 },
	{ 0x4442, 0x28CA8 },
	{ 0x4443, 0x28CA6 },
	{ 0x4444, 0x28D84 },
	{ 0x4445, 0x28D96 },
	{ 0x4446, 0x28D88 },
	{ 0x4447, 0x28D9A },
	{ 0x4448, 0x28ED1 },
	{ 0x4449, 0x28ECF },
	{ 0x444A, 0x28F50 },
	{ 0x444B, 0x28F51 },
	{ 0x444C, 0x28F4E },
	{ 0x444D, 0x28F80 },
	{ 0x444E, 0x28F81 },
	{ 0x444F, 0x2901B },
	{ 0x4450, 0x29017 },
	{ 0x4451, 0x29020 },
	{ 0x4452, 0x29019 },
	{ 0x4453, 0x2901A },
	{ 0x4454, 0x29021 },
	{ 0x4455, 0x2901E },
	{ 0x4456, 0x29018 },
	{ 0x4457, 0x2901D },
	{ 0x4458, 0x4A29 },
	{ 0x4459, 0x2912D },
	{ 0x445A, 0x29124 },
	{ 0x445B, 0x29127 },
	{ 0x445C, 0x2912E },
	{ 0x445D, 0x29125 },
	{ 0x445E, 0x2911C },
	{ 0x445F, 0x29119 },
	{ 0x4460, 0x4A2A },
	{ 0x4461, 0x29123 },
	{ 0x4462, 0x2911F },
	{ 0x4463, 0x2911A },
	{ 0x4464, 0x2912B },
	{ 0x4465, 0x2911E },
	{ 0x4466, 0x291E0 },
	{ 0x4467, 0x29233 },
	{ 0x4468, 0x292E6 },
	{ 0x4469, 0x292FC },
	{ 0x446A, 0x292E5 },
	{ 0x446B, 0x292F8 },
	{ 0x446C, 0x292F6 },
	{ 0x446D, 0x292EA },
	{ 0x446E, 0x292F2 },
	{ 0x446F, 0x292ED },
	{ 0x4470, 0x292EB },
	{ 0x4471, 0x292F0 },
	{ 0x4472, 0x292F1 },
	{ 0x4473, 0x293C6 },
	{ 0x4474, 0x293C8 },
	{ 0x4475, 0x293CE },
	{ 0x4476, 0x293C5 },
	{ 0x4477, 0x4A96 },
	{ 0x4478, 0x293CB },
	{ 0x4479, 0x29513 },
	{ 0x447A, 0x29514 },
	{ 0x447B, 0x29507 },
	{ 0x447C, 0x2950C },
	{ 0x447D, 0x2961A },
	{ 0x447E, 0x4B12 },
	{ 0x4521, 0x29617 },
	{ 0x4522, 0x29606 },
	{ 0x4523, 0x29616 },
	{ 0x4524, 0x29607 },
	{ 0x4525, 0x29610 },
	{ 0x4526, 0x29609 },
	{ 0x4527, 0x29619 },
	{ 0x4528, 0x29615 },
	{ 0x4529, 0x2976E },
	{ 0x452A, 0x2973B },
	{ 0x452B, 0x2973E },
	{ 0x452C, 0x2976C },
	{ 0x452D, 0x29765 },
	{ 0x452E, 0x29764 },
	{ 0x452F, 0x29759 },
	{ 0x4530, 0x2977C },
	{ 0x4531, 0x29770 },
	{ 0x4532, 0x29779 },
	{ 0x4533, 0x2982C },
	{ 0x4534, 0x29852 },
	{ 0x4535, 0x29851 },
	{ 0x4536, 0x2984C },
	{ 0x4537, 0x29900 },
	{ 0x4538, 0x29910 },
	{ 0x4539, 0x29913 },
	{ 0x453A, 0x298FF },
	{ 0x453B, 0x298FE },
	{ 0x453C, 0x298ED },
	{ 0x453D, 0x29A5A },
	{ 0x453E, 0x29A58 },
	{ 0x453F, 0x29A5C },
	{ 0x4540, 0x29ADA },
	{ 0x4541, 0x29B78 },
	{ 0x4542, 0x29B5E },
	{ 0x4543, 0x29B67 },
	{ 0x4544, 0x29B64 },
	{ 0x4545, 0x29C13 },
	{ 0x4546, 0x29C23 },
	{ 0x4547, 0x29C41 },
	{ 0x4548, 0x29C3F },
	{ 0x4549, 0x29C40 },
	{ 0x454A, 0x29CED },
	{ 0x454B, 0x29CE3 },
	{ 0x454C, 0x29CEA },
	{ 0x454D, 0x29CF0 },
	{ 0x454E, 0x29CE6 },
	{ 0x454F, 0x29CE9 },
	{ 0x4550, 0x29CF1 },
	{ 0x4551, 0x29CEE },
	{ 0x4552, 0x29DD4 },
	{ 0x4553, 0x29DD1 },
	{ 0x4554, 0x29DDC },
	{ 0x4555, 0x29DEC },
	{ 0x4556, 0x2A069 },
	{ 0x4557, 0x2A06D },
	{ 0x4558, 0x2A057 },
	{ 0x4559, 0x2A066 },
	{ 0x455A, 0x2A0F9 },
	{ 0x455B, 0x2A04A },
	{ 0x455C, 0x2A060 },
	{ 0x455D, 0x2A056 },
	{ 0x455E, 0x2A059 },
	{ 0x455F, 0x2A04C },
	{ 0x4560, 0x2A06A },
	{ 0x4561, 0x2A062 },
	{ 0x4562, 0x2A063 },
	{ 0x4563, 0x2A070 },
	{ 0x4564, 0x2A05F },
	{ 0x4565, 0x2FA0D },
	{ 0x4566, 0x2A064 },
	{ 0x4567, 0x2A05D },
	{ 0x4568, 0x2A068 },
	{ 0x4569, 0x2A09F },
	{ 0x456A, 0x2A2BA },
	{ 0x456B, 0x2A2B8 },
	{ 0x456C, 0x2A2BC },
	{ 0x456D, 0x2A2B9 },
	{ 0x456E, 0x2A2B4 },
	{ 0x456F, 0x2A33B },
	{ 0x4570, 0x2A32D },
	{ 0x4571, 0x2A338 },
	{ 0x4572, 0x2A32F },
	{ 0x4573, 0x2A332 },
	{ 0x4574, 0x2A441 },
	{ 0x4575, 0x2A4CB },
	{ 0x4576, 0x2A4DE },
	{ 0x4577, 0x2A4DD },
	{ 0x4578, 0x2A4DA },
	{ 0x4579, 0x2A4DC },
	{ 0x457A, 0x2A510 },
	{ 0x457B, 0x2A54F },
	{ 0x457C, 0x2A549 },
	{ 0x457D, 0x2A598 },
	{ 0x457E, 0x2A596 },
	{ 0x4621, 0x2A597 },
	{ 0x4622, 0x2A5C7 },
	{ 0x4623, 0x2019C },
	{ 0x4624, 0x2A5DA },
	{ 0x4625, 0x2A5D8 },
	{ 0x4626, 0x2A6A8 },
	{ 0x4627, 0x2010A },
	{ 0x4628, 0x2019D },
	{ 0x4629, 0x204CB },
	{ 0x462A, 0x20538 },
	{ 0x462B, 0x20539 },
	{ 0x462C, 0x205A6 },
	{ 0x462D, 0x20823 },
	{ 0x462E, 0x20822 },
	{ 0x462F, 0x20821 },
	{ 0x4630, 0x209CE },
	{ 0x4631, 0x20B92 },
	{ 0x4632, 0x20B91 },
	{ 0x4633, 0x210EC },
	{ 0x4634, 0x210E0 },
	{ 0x4635, 0x210ED },
	{ 0x4636, 0x21108 },
	{ 0x4637, 0x210E5 },
	{ 0x4638, 0x210EE },
	{ 0x4639, 0x210E4 },
	{ 0x463A, 0x210EB },
	{ 0x463B, 0x210E3 },
	{ 0x463C, 0x210EA },
	{ 0x463D, 0x2110A },
	{ 0x463E, 0x2F859 },
	{ 0x463F, 0x214D1 },
	{ 0x4640, 0x214E3 },
	{ 0x4641, 0x214D4 },
	{ 0x4642, 0x214D0 },
	{ 0x4643, 0x214D9 },
	{ 0x4644, 0x367E },
	{ 0x4645, 0x58E1 },
	{ 0x4646, 0x214DA },
	{ 0x4647, 0x214D3 },
	{ 0x4648, 0x2154C },
	{ 0x4649, 0x2154D },
	{ 0x464A, 0x2157C },
	{ 0x464B, 0x21580 },
	{ 0x464C, 0x215CC },
	{ 0x464D, 0x218FF },
	{ 0x464E, 0x21908 },
	{ 0x464F, 0x2A508 },
	{ 0x4650, 0x21901 },
	{ 0x4651, 0x2F86B },
	{ 0x4652, 0x21900 },
	{ 0x4653, 0x21AED },
	{ 0x4654, 0x21AF3 },
	{ 0x4655, 0x21AEE },
	{ 0x4656, 0x21AF1 },
	{ 0x4657, 0x21AF0 },
	{ 0x4658, 0x21ADE },
	{ 0x4659, 0x21B51 },
	{ 0x465A, 0x21F82 },
	{ 0x465B, 0x21FA9 },
	{ 0x465C, 0x21F98 },
	{ 0x465D, 0x21F9D },
	{ 0x465E, 0x21F9A },
	{ 0x465F, 0x21F9E },
	{ 0x4660, 0x21F9F },
	{ 0x4661, 0x21FA6 },
	{ 0x4662, 0x21FA7 },
	{ 0x4663, 0x22009 },
	{ 0x4664, 0x2202F },
	{ 0x4665, 0x22171 },
	{ 0x4666, 0x2216D },
	{ 0x4667, 0x22172 },
	{ 0x4668, 0x222EF },
	{ 0x4669, 0x222F0 },
	{ 0x466A, 0x2243B },
	{ 0x466B, 0x22439 },
	{ 0x466C, 0x2243C },
	{ 0x466D, 0x22438 },
	{ 0x466E, 0x24BFD },
	{ 0x466F, 0x2243A },
	{ 0x4670, 0x22478 },
	{ 0x4671, 0x22479 },
	{ 0x4672, 0x22477 },
	{ 0x4673, 0x22598 },
	{ 0x4674, 0x2259C },
	{ 0x4675, 0x22599 },
	{ 0x4676, 0x2259A },
	{ 0x4677, 0x22911 },
	{ 0x4678, 0x2290A },
	{ 0x4679, 0x228FD },
	{ 0x467A, 0x2290F },
	{ 0x467B, 0x22919 },
	{ 0x467C, 0x22903 },
	{ 0x467D, 0x22915 },
	{ 0x467E, 0x2290C },
	{ 0x4721, 0x22909 },
	{ 0x4722, 0x22912 },
	{ 0x4723, 0x22934 },
	{ 0x4724, 0x2292A },
	{ 0x4725, 0x22908 },
	{ 0x4726, 0x2292D },
	{ 0x4727, 0x22928 },
	{ 0x4728, 0x2F8B1 },
	{ 0x4729, 0x2292C },
	{ 0x472A, 0x22926 },
	{ 0x472B, 0x22933 },
	{ 0x472C, 0x39A7 },
	{ 0x472D, 0x22A1A },
	{ 0x472E, 0x22A1E },
	{ 0x472F, 0x22E07 },
	{ 0x4730, 0x22E2C },
	{ 0x4731, 0x22E32 },
	{ 0x4732, 0x22E28 },
	{ 0x4733, 0x22E31 },
	{ 0x4734, 0x22E29 },
	{ 0x4735, 0x22E30 },
	{ 0x4736, 0x22E2A },
	{ 0x4737, 0x22E44 },
	{ 0x4738, 0x22E2E },
	{ 0x4739, 0x230D1 },
	{ 0x473A, 0x23124 },
	{ 0x473B, 0x232F7 },
	{ 0x473C, 0x232F4 },
	{ 0x473D, 0x232F3 },
	{ 0x473E, 0x232F8 },
	{ 0x473F, 0x237B5 },
	{ 0x4740, 0x23796 },
	{ 0x4741, 0x23798 },
	{ 0x4742, 0x23795 },
	{ 0x4743, 0x23791 },
	{ 0x4744, 0x237B2 },
	{ 0x4745, 0x2379E },
	{ 0x4746, 0x23759 },
	{ 0x4747, 0x237A3 },
	{ 0x4748, 0x2379A },
	{ 0x4749, 0x2379B },
	{ 0x474A, 0x4320 },
	{ 0x474B, 0x26183 },
	{ 0x474C, 0x23ADA },
	{ 0x474D, 0x23ADF },
	{ 0x474E, 0x23B16 },
	{ 0x474F, 0x23C1F },
	{ 0x4750, 0x23C2D },
	{ 0x4751, 0x23C2E },
	{ 0x4752, 0x23C2B },
	{ 0x4753, 0x240B8 },
	{ 0x4754, 0x240BB },
	{ 0x4755, 0x240BF },
	{ 0x4756, 0x240BA },
	{ 0x4757, 0x240D5 },
	{ 0x4758, 0x240E3 },
	{ 0x4759, 0x240C1 },
	{ 0x475A, 0x240BE },
	{ 0x475B, 0x240BD },
	{ 0x475C, 0x240B4 },
	{ 0x475D, 0x240C2 },
	{ 0x475E, 0x240A1 },
	{ 0x475F, 0x24087 },
	{ 0x4760, 0x240D7 },
	{ 0x4761, 0x240CA },
	{ 0x4762, 0x240B5 },
	{ 0x4763, 0x240DA },
	{ 0x4764, 0x240D9 },
	{ 0x4765, 0x240B3 },
	{ 0x4766, 0x240D8 },
	{ 0x4767, 0x24467 },
	{ 0x4768, 0x24471 },
	{ 0x4769, 0x24462 },
	{ 0x476A, 0x2445C },
	{ 0x476B, 0x24468 },
	{ 0x476C, 0x24452 },
	{ 0x476D, 0x24456 },
	{ 0x476E, 0x21109 },
	{ 0x476F, 0x20442 },
	{ 0x4770, 0x245A0 },
	{ 0x4771, 0x24700 },
	{ 0x4772, 0x246FE },
	{ 0x4773, 0x246FF },
	{ 0x4774, 0x248CB },
	{ 0x4775, 0x2F928 },
	{ 0x4776, 0x248CA },
	{ 0x4777, 0x248A9 },
	{ 0x4778, 0x248C8 },
	{ 0x4779, 0x24AB4 },
	{ 0x477A, 0x24AAC },
	{ 0x477B, 0x24AAA },
	{ 0x477C, 0x24AA9 },
	{ 0x477D, 0x24C0E },
	{ 0x477E, 0x24CE9 },
	{ 0x4821, 0x24CED },
	{ 0x4822, 0x24CF2 },
	{ 0x4823, 0x24CEB },
	{ 0x4824, 0x24CEE },
	{ 0x4825, 0x24EE8 },
	{ 0x4826, 0x24EDB },
	{ 0x4827, 0x24ED7 },
	{ 0x4828, 0x24EE3 },
	{ 0x4829, 0x24EE5 },
	{ 0x482A, 0x24EEE },
	{ 0x482B, 0x24ED5 },
	{ 0x482C, 0x24FB3 },
	{ 0x482D, 0x2502D },
	{ 0x482E, 0x250C1 },
	{ 0x482F, 0x250C3 },
	{ 0x4830, 0x2530C },
	{ 0x4831, 0x2530E },
	{ 0x4832, 0x25307 },
	{ 0x4833, 0x25317 },
	{ 0x4834, 0x25309 },
	{ 0x4835, 0x25316 },
	{ 0x4836, 0x2539A },
	{ 0x4837, 0x2539C },
	{ 0x4838, 0x255B4 },
	{ 0x4839, 0x255B7 },
	{ 0x483A, 0x255B3 },
	{ 0x483B, 0x2154E },
	{ 0x483C, 0x25713 },
	{ 0x483D, 0x25714 },
	{ 0x483E, 0x258E6 },
	{ 0x483F, 0x258DC },
	{ 0x4840, 0x258E8 },
	{ 0x4841, 0x258E5 },
	{ 0x4842, 0x25A2E },
	{ 0x4843, 0x25A2C },
	{ 0x4844, 0x25A2B },
	{ 0x4845, 0x25ACD },
	{ 0x4846, 0x25D3D },
	{ 0x4847, 0x25D32 },
	{ 0x4848, 0x25D2D },
	{ 0x4849, 0x25D45 },
	{ 0x484A, 0x25D3E },
	{ 0x484B, 0x25D50 },
	{ 0x484C, 0x25D25 },
	{ 0x484D, 0x25D53 },
	{ 0x484E, 0x25D23 },
	{ 0x484F, 0x25F37 },
	{ 0x4850, 0x25F38 },
	{ 0x4851, 0x25F47 },
	{ 0x4852, 0x25F3D },
	{ 0x4853, 0x25F3E },
	{ 0x4854, 0x25F49 },
	{ 0x4855, 0x25F4A },
	{ 0x4856, 0x25F1D },
	{ 0x4857, 0x7CE9 },
	{ 0x4858, 0x261A5 },
	{ 0x4859, 0x2618C },
	{ 0x485A, 0x2618D },
	{ 0x485B, 0x26189 },
	{ 0x485C, 0x26196 },
	{ 0x485D, 0x26185 },
	{ 0x485E, 0x2618F },
	{ 0x485F, 0x26177 },
	{ 0x4860, 0x2618E },
	{ 0x4861, 0x26182 },
	{ 0x4862, 0x2618A },
	{ 0x4863, 0x26188 },
	{ 0x4864, 0x2617B },
	{ 0x4865, 0x26197 },
	{ 0x4866, 0x2617D },
	{ 0x4867, 0x26179 },
	{ 0x4868, 0x26259 },
	{ 0x4869, 0x26324 },
	{ 0x486A, 0x2632D },
	{ 0x486B, 0x2632E },
	{ 0x486C, 0x2632B },
	{ 0x486D, 0x2F976 },
	{ 0x486E, 0x263DA },
	{ 0x486F, 0x263D8 },
	{ 0x4870, 0x263D6 },
	{ 0x4871, 0x26487 },
	{ 0x4872, 0x264A0 },
	{ 0x4873, 0x26528 },
	{ 0x4874, 0x26525 },
	{ 0x4875, 0x2651F },
	{ 0x4876, 0x265F3 },
	{ 0x4877, 0x265F7 },
	{ 0x4878, 0x265F6 },
	{ 0x4879, 0x2682B },
	{ 0x487A, 0x2685B },
	{ 0x487B, 0x26848 },
	{ 0x487C, 0x81CB },
	{ 0x487D, 0x2685C },
	{ 0x487E, 0x2686D },
	{ 0x4921, 0x2689D },
	{ 0x4922, 0x26899 },
	{ 0x4923, 0x2688C },
	{ 0x4924, 0x26891 },
	{ 0x4925, 0x2689B },
	{ 0x4926, 0x2689A },
	{ 0x4927, 0x2689C },
	{ 0x4928, 0x26895 },
	{ 0x4929, 0x2688D },
	{ 0x492A, 0x26896 },
	{ 0x492B, 0x268A5 },
	{ 0x492C, 0x2692A },
	{ 0x492D, 0x269A1 },
	{ 0x492E, 0x269A4 },
	{ 0x492F, 0x269AD },
	{ 0x4930, 0x26AA9 },
	{ 0x4931, 0x26AAE },
	{ 0x4932, 0x26AB0 },
	{ 0x4933, 0x2700D },
	{ 0x4934, 0x26F63 },
	{ 0x4935, 0x26F71 },
	{ 0x4936, 0x27051 },
	{ 0x4937, 0x27054 },
	{ 0x4938, 0x2702A },
	{ 0x4939, 0x27044 },
	{ 0x493A, 0x27055 },
	{ 0x493B, 0x27099 },
	{ 0x493C, 0x27039 },
	{ 0x493D, 0x2703F },
	{ 0x493E, 0x2703E },
	{ 0x493F, 0x2704F },
	{ 0x4940, 0x2704D },
	{ 0x4941, 0x27035 },
	{ 0x4942, 0x27040 },
	{ 0x4943, 0x27031 },
	{ 0x4944, 0x26FD5 },
	{ 0x4945, 0x2702B },
	{ 0x4946, 0x27033 },
	{ 0x4947, 0x27041 },
	{ 0x4948, 0x27056 },
	{ 0x4949, 0x2704C },
	{ 0x494A, 0x27046 },
	{ 0x494B, 0x2703C },
	{ 0x494C, 0x27045 },
	{ 0x494D, 0x27043 },
	{ 0x494E, 0x2703D },
	{ 0x494F, 0x27070 },
	{ 0x4950, 0x27057 },
	{ 0x4951, 0x27038 },
	{ 0x4952, 0x27058 },
	{ 0x4953, 0x4565 },
	{ 0x4954, 0x27037 },
	{ 0x4955, 0x27207 },
	{ 0x4956, 0x27206 },
	{ 0x4957, 0x27209 },
	{ 0x4958, 0x274AB },
	{ 0x4959, 0x27490 },
	{ 0x495A, 0x27493 },
	{ 0x495B, 0x274BC },
	{ 0x495C, 0x274A9 },
	{ 0x495D, 0x2749E },
	{ 0x495E, 0x274BF },
	{ 0x495F, 0x274AA },
	{ 0x4960, 0x27491 },
	{ 0x4961, 0x274A4 },
	{ 0x4962, 0x2749A },
	{ 0x4963, 0x274A7 },
	{ 0x4964, 0x274A1 },
	{ 0x4965, 0x2749C },
	{ 0x4966, 0x274A2 },
	{ 0x4967, 0x2749B },
	{ 0x4968, 0x2749F },
	{ 0x4969, 0x27494 },
	{ 0x496A, 0x2748F },
	{ 0x496B, 0x272F0 },
	{ 0x496C, 0x27492 },
	{ 0x496D, 0x27495 },
	{ 0x496E, 0x274A5 },
	{ 0x496F, 0x274A6 },
	{ 0x4970, 0x27604 },
	{ 0x4971, 0x2779C },
	{ 0x4972, 0x27779 },
	{ 0x4973, 0x2777A },
	{ 0x4974, 0x2777E },
	{ 0x4975, 0x2777B },
	{ 0x4976, 0x27771 },
	{ 0x4977, 0x27781 },
	{ 0x4978, 0x2777F },
	{ 0x4979, 0x2777C },
	{ 0x497A, 0x2777D },
	{ 0x497B, 0x27775 },
	{ 0x497C, 0x27776 },
	{ 0x497D, 0x2788E },
	{ 0x497E, 0x2788F },
	{ 0x4A21, 0x2793E },
	{ 0x4A22, 0x2793F },
	{ 0x4A23, 0x27940 },
	{ 0x4A24, 0x27941 },
	{ 0x4A25, 0x4704 },
	{ 0x4A26, 0x27B0D },
	{ 0x4A27, 0x27B17 },
	{ 0x4A28, 0x27B10 },
	{ 0x4A29, 0x27B0E },
	{ 0x4A2A, 0x27AEA },
	{ 0x4A2B, 0x27B1D },
	{ 0x4A2C, 0x27B03 },
	{ 0x4A2D, 0x27B22 },
	{ 0x4A2E, 0x27B04 },
	{ 0x4A2F, 0x27B00 },
	{ 0x4A30, 0x27B20 },
	{ 0x4A31, 0x27B21 },
	{ 0x4A32, 0x27B23 },
	{ 0x4A33, 0x27B13 },
	{ 0x4A34, 0x27B09 },
	{ 0x4A35, 0x27B11 },
	{ 0x4A36, 0x27BCB },
	{ 0x4A37, 0x27BCE },
	{ 0x4A38, 0x27BD0 },
	{ 0x4A39, 0x27BCC },
	{ 0x4A3A, 0x27BD4 },
	{ 0x4A3B, 0x214DB },
	{ 0x4A3C, 0x27C09 },
	{ 0x4A3D, 0x27C0B },
	{ 0x4A3E, 0x27C85 },
	{ 0x4A3F, 0x27D06 },
	{ 0x4A40, 0x27D0D },
	{ 0x4A41, 0x4764 },
	{ 0x4A42, 0x27D14 },
	{ 0x4A43, 0x27D0F },
	{ 0x4A44, 0x27E09 },
	{ 0x4A45, 0x27E14 },
	{ 0x4A46, 0x27E0B },
	{ 0x4A47, 0x27DFC },
	{ 0x4A48, 0x27E04 },
	{ 0x4A49, 0x27E0A },
	{ 0x4A4A, 0x27E00 },
	{ 0x4A4B, 0x27DFD },
	{ 0x4A4C, 0x27E07 },
	{ 0x4A4D, 0x27E06 },
	{ 0x4A4E, 0x27E11 },
	{ 0x4A4F, 0x27E79 },
	{ 0x4A50, 0x27E78 },
	{ 0x4A51, 0x27F88 },
	{ 0x4A52, 0x27F80 },
	{ 0x4A53, 0x27F8B },
	{ 0x4A54, 0x28159 },
	{ 0x4A55, 0x28161 },
	{ 0x4A56, 0x28175 },
	{ 0x4A57, 0x4823 },
	{ 0x4A58, 0x28155 },
	{ 0x4A59, 0x2815B },
	{ 0x4A5A, 0x2815F },
	{ 0x4A5B, 0x28152 },
	{ 0x4A5C, 0x28162 },
	{ 0x4A5D, 0x28172 },
	{ 0x4A5E, 0x2815D },
	{ 0x4A5F, 0x28168 },
	{ 0x4A60, 0x28171 },
	{ 0x4A61, 0x28165 },
	{ 0x4A62, 0x28166 },
	{ 0x4A63, 0x28167 },
	{ 0x4A64, 0x28176 },
	{ 0x4A65, 0x2814C },
	{ 0x4A66, 0x28160 },
	{ 0x4A67, 0x28174 },
	{ 0x4A68, 0x28150 },
	{ 0x4A69, 0x2828A },
	{ 0x4A6A, 0x28281 },
	{ 0x4A6B, 0x28286 },
	{ 0x4A6C, 0x2827F },
	{ 0x4A6D, 0x28280 },
	{ 0x4A6E, 0x283A5 },
	{ 0x4A6F, 0x283A7 },
	{ 0x4A70, 0x283A8 },
	{ 0x4A71, 0x283A6 },
	{ 0x4A72, 0x283AF },
	{ 0x4A73, 0x26195 },
	{ 0x4A74, 0x283B1 },
	{ 0x4A75, 0x28435 },
	{ 0x4A76, 0x28439 },
	{ 0x4A77, 0x285C3 },
	{ 0x4A78, 0x28630 },
	{ 0x4A79, 0x2862A },
	{ 0x4A7A, 0x2862B },
	{ 0x4A7B, 0x2862D },
	{ 0x4A7C, 0x2862E },
	{ 0x4A7D, 0x2862C },
	{ 0x4A7E, 0x28623 },
	{ 0x4B21, 0x28621 },
	{ 0x4B22, 0x28622 },
	{ 0x4B23, 0x2876C },
	{ 0x4B24, 0x28781 },
	{ 0x4B25, 0x2878F },
	{ 0x4B26, 0x28780 },
	{ 0x4B27, 0x287D0 },
	{ 0x4B28, 0x287CD },
	{ 0x4B29, 0x287D5 },
	{ 0x4B2A, 0x287D4 },
	{ 0x4B2B, 0x288D1 },
	{ 0x4B2C, 0x288BE },
	{ 0x4B2D, 0x288CB },
	{ 0x4B2E, 0x288CE },
	{ 0x4B2F, 0x288BD },
	{ 0x4B30, 0x288D0 },
	{ 0x4B31, 0x28B04 },
	{ 0x4B32, 0x28AD5 },
	{ 0x4B33, 0x28AD0 },
	{ 0x4B34, 0x28AD3 },
	{ 0x4B35, 0x28AFB },
	{ 0x4B36, 0x28AD8 },
	{ 0x4B37, 0x28AD1 },
	{ 0x4B38, 0x28AFD },
	{ 0x4B39, 0x28AD9 },
	{ 0x4B3A, 0x28AD6 },
	{ 0x4B3B, 0x28AE6 },
	{ 0x4B3C, 0x28AF9 },
	{ 0x4B3D, 0x28DA1 },
	{ 0x4B3E, 0x28D9D },
	{ 0x4B3F, 0x28D9E },
	{ 0x4B40, 0x95D9 },
	{ 0x4B41, 0x28EFF },
	{ 0x4B42, 0x28F5F },
	{ 0x4B43, 0x28F57 },
	{ 0x4B44, 0x28F60 },
	{ 0x4B45, 0x28F59 },
	{ 0x4B46, 0x2902C },
	{ 0x4B47, 0x29025 },
	{ 0x4B48, 0x29027 },
	{ 0x4B49, 0x29030 },
	{ 0x4B4A, 0x29024 },
	{ 0x4B4B, 0x29026 },
	{ 0x4B4C, 0x2902D },
	{ 0x4B4D, 0x2902E },
	{ 0x4B4E, 0x29029 },
	{ 0x4B4F, 0x29031 },
	{ 0x4B50, 0x29145 },
	{ 0x4B51, 0x29147 },
	{ 0x4B52, 0x29152 },
	{ 0x4B53, 0x2914A },
	{ 0x4B54, 0x29150 },
	{ 0x4B55, 0x29146 },
	{ 0x4B56, 0x2914F },
	{ 0x4B57, 0x2914E },
	{ 0x4B58, 0x29153 },
	{ 0x4B59, 0x29321 },
	{ 0x4B5A, 0x29309 },
	{ 0x4B5B, 0x2931A },
	{ 0x4B5C, 0x2931B },
	{ 0x4B5D, 0x25315 },
	{ 0x4B5E, 0x29310 },
	{ 0x4B5F, 0x2F9F9 },
	{ 0x4B60, 0x29314 },
	{ 0x4B61, 0x2930E },
	{ 0x4B62, 0x29312 },
	{ 0x4B63, 0x2930B },
	{ 0x4B64, 0x293CF },
	{ 0x4B65, 0x293D2 },
	{ 0x4B66, 0x293D0 },
	{ 0x4B67, 0x293D4 },
	{ 0x4B68, 0x293D3 },
	{ 0x4B69, 0x293D1 },
	{ 0x4B6A, 0x20B18 },
	{ 0x4B6B, 0x2F9FB },
	{ 0x4B6C, 0x29409 },
	{ 0x4B6D, 0x2951C },
	{ 0x4B6E, 0x29527 },
	{ 0x4B6F, 0x29525 },
	{ 0x4B70, 0x2951B },
	{ 0x4B71, 0x29529 },
	{ 0x4B72, 0x2951F },
	{ 0x4B73, 0x29530 },
	{ 0x4B74, 0x29524 },
	{ 0x4B75, 0x29528 },
	{ 0x4B76, 0x29519 },
	{ 0x4B77, 0x2952F },
	{ 0x4B78, 0x29624 },
	{ 0x4B79, 0x29621 },
	{ 0x4B7A, 0x29625 },
	{ 0x4B7B, 0x29626 },
	{ 0x4B7C, 0x29627 },
	{ 0x4B7D, 0x29676 },
	{ 0x4B7E, 0x29766 },
	{ 0x4C21, 0x29775 },
	{ 0x4C22, 0x29769 },
	{ 0x4C23, 0x2977E },
	{ 0x4C24, 0x2978F },
	{ 0x4C25, 0x29774 },
	{ 0x4C26, 0x27210 },
	{ 0x4C27, 0x297AD },
	{ 0x4C28, 0x2982B },
	{ 0x4C29, 0x2982A },
	{ 0x4C2A, 0x29858 },
	{ 0x4C2B, 0x29922 },
	{ 0x4C2C, 0x2991D },
	{ 0x4C2D, 0x2992B },
	{ 0x4C2E, 0x2992C },
	{ 0x4C2F, 0x2992D },
	{ 0x4C30, 0x29933 },
	{ 0x4C31, 0x2991B },
	{ 0x4C32, 0x29927 },
	{ 0x4C33, 0x2992A },
	{ 0x4C34, 0x29928 },
	{ 0x4C35, 0x2993B },
	{ 0x4C36, 0x29A7E },
	{ 0x4C37, 0x29A71 },
	{ 0x4C38, 0x29A79 },
	{ 0x4C39, 0x29A78 },
	{ 0x4C3A, 0x29A70 },
	{ 0x4C3B, 0x29A6D },
	{ 0x4C3C, 0x29A7D },
	{ 0x4C3D, 0x29A75 },
	{ 0x4C3E, 0x29A76 },
	{ 0x4C3F, 0x29ADE },
	{ 0x4C40, 0x29B66 },
	{ 0x4C41, 0x29B83 },
	{ 0x4C42, 0x29B87 },
	{ 0x4C43, 0x29B7B },
	{ 0x4C44, 0x29B89 },
	{ 0x4C45, 0x29B86 },
	{ 0x4C46, 0x29B82 },
	{ 0x4C47, 0x29B7C },
	{ 0x4C48, 0x29B81 },
	{ 0x4C49, 0x29C43 },
	{ 0x4C4A, 0x29C45 },
	{ 0x4C4B, 0x29CF7 },
	{ 0x4C4C, 0x29CF9 },
	{ 0x4C4D, 0x29CFA },
	{ 0x4C4E, 0x29E05 },
	{ 0x4C4F, 0x29DFE },
	{ 0x4C50, 0x29E0F },
	{ 0x4C51, 0x29DFF },
	{ 0x4C52, 0x29DFA },
	{ 0x4C53, 0x29E09 },
	{ 0x4C54, 0x29E20 },
	{ 0x4C55, 0x29E0C },
	{ 0x4C56, 0x29E3C },
	{ 0x4C57, 0x29E22 },
	{ 0x4C58, 0x29DF8 },
	{ 0x4C59, 0x29E0A },
	{ 0x4C5A, 0x29E08 },
	{ 0x4C5B, 0x29DF7 },
	{ 0x4C5C, 0x2A08E },
	{ 0x4C5D, 0x2A077 },
	{ 0x4C5E, 0x2A08B },
	{ 0x4C5F, 0x2A0B4 },
	{ 0x4C60, 0x2A08A },
	{ 0x4C61, 0x2A09A },
	{ 0x4C62, 0x2A079 },
	{ 0x4C63, 0x2A083 },
	{ 0x4C64, 0x2A07F },
	{ 0x4C65, 0x2A0A1 },
	{ 0x4C66, 0x2A08F },
	{ 0x4C67, 0x2A0A3 },
	{ 0x4C68, 0x2A081 },
	{ 0x4C69, 0x2A094 },
	{ 0x4C6A, 0x2A07E },
	{ 0x4C6B, 0x2A082 },
	{ 0x4C6C, 0x2A090 },
	{ 0x4C6D, 0x2A0A5 },
	{ 0x4C6E, 0x2A0AD },
	{ 0x4C6F, 0x2A09D },
	{ 0x4C70, 0x2A267 },
	{ 0x4C71, 0x2A269 },
	{ 0x4C72, 0x2A2CB },
	{ 0x4C73, 0x2A2C8 },
	{ 0x4C74, 0x2A2D1 },
	{ 0x4C75, 0x2A340 },
	{ 0x4C76, 0x2A34B },
	{ 0x4C77, 0x2A349 },
	{ 0x4C78, 0x2A346 },
	{ 0x4C79, 0x2A33E },
	{ 0x4C7A, 0x2A343 },
	{ 0x4C7B, 0x2A33F },
	{ 0x4C7C, 0x2A3A5 },
	{ 0x4C7D, 0x2A3A7 },
	{ 0x4C7E, 0x2A44E },
	{ 0x4D21, 0x2A44D },
	{ 0x4D22, 0x2259B },
	{ 0x4D23, 0x2A4E5 },
	{ 0x4D24, 0x2A4E1 },
	{ 0x4D25, 0x2A4E2 },
	{ 0x4D26, 0x2A516 },
	{ 0x4D27, 0x2A514 },
	{ 0x4D28, 0x2FA1B },
	{ 0x4D29, 0x2A559 },
	{ 0x4D2A, 0x2A551 },
	{ 0x4D2B, 0x2A55F },
	{ 0x4D2C, 0x2A54A },
	{ 0x4D2D, 0x2A557 },
	{ 0x4D2E, 0x2A558 },
	{ 0x4D2F, 0x2A5CA },
	{ 0x4D30, 0x2A5DB },
	{ 0x4D31, 0x2A5DE },
	{ 0x4D32, 0x2A5E0 },
	{ 0x4D33, 0x2A5E1 },
	{ 0x4D34, 0x2A5DF },
	{ 0x4D35, 0x2A5E2 },
	{ 0x4D36, 0x2A5E3 },
	{ 0x4D37, 0x2A692 },
	{ 0x4D38, 0x2A6BF },
	{ 0x4D39, 0x2A6BE },
	{ 0x4D3A, 0x2010B },
	{ 0x4D3B, 0x20452 },
	{ 0x4D3C, 0x2044E },
	{ 0x4D3D, 0x34B9 },
	{ 0x4D3E, 0x2F813 },
	{ 0x4D3F, 0x205A7 },
	{ 0x4D40, 0x20826 },
	{ 0x4D41, 0x20827 },
	{ 0x4D42, 0x208C6 },
	{ 0x4D43, 0x2090B },
	{ 0x4D44, 0x2096A },
	{ 0x4D45, 0x20978 },
	{ 0x4D46, 0x2111A },
	{ 0x4D47, 0x21116 },
	{ 0x4D48, 0x21119 },
	{ 0x4D49, 0x21117 },
	{ 0x4D4A, 0x2111B },
	{ 0x4D4B, 0x21118 },
	{ 0x4D4C, 0x21120 },
	{ 0x4D4D, 0x21237 },
	{ 0x4D4E, 0x214EC },
	{ 0x4D4F, 0x21581 },
	{ 0x4D50, 0x2923D },
	{ 0x4D51, 0x2190F },
	{ 0x4D52, 0x219AD },
	{ 0x4D53, 0x21AFB },
	{ 0x4D54, 0x21B52 },
	{ 0x4D55, 0x21FAF },
	{ 0x4D56, 0x21FB7 },
	{ 0x4D57, 0x21FB2 },
	{ 0x4D58, 0x22178 },
	{ 0x4D59, 0x221AC },
	{ 0x4D5A, 0x22300 },
	{ 0x4D5B, 0x222FE },
	{ 0x4D5C, 0x22302 },
	{ 0x4D5D, 0x222FD },
	{ 0x4D5E, 0x22303 },
	{ 0x4D5F, 0x22440 },
	{ 0x4D60, 0x22443 },
	{ 0x4D61, 0x22442 },
	{ 0x4D62, 0x224B7 },
	{ 0x4D63, 0x225A2 },
	{ 0x4D64, 0x22900 },
	{ 0x4D65, 0x22935 },
	{ 0x4D66, 0x22941 },
	{ 0x4D67, 0x22905 },
	{ 0x4D68, 0x20453 },
	{ 0x4D69, 0x22950 },
	{ 0x4D6A, 0x2294E },
	{ 0x4D6B, 0x22953 },
	{ 0x4D6C, 0x22E53 },
	{ 0x4D6D, 0x22E50 },
	{ 0x4D6E, 0x22E57 },
	{ 0x4D6F, 0x22E5F },
	{ 0x4D70, 0x22E55 },
	{ 0x4D71, 0x22EEA },
	{ 0x4D72, 0x23026 },
	{ 0x4D73, 0x29830 },
	{ 0x4D74, 0x2302A },
	{ 0x4D75, 0x23028 },
	{ 0x4D76, 0x2302C },
	{ 0x4D77, 0x2302D },
	{ 0x4D78, 0x230D4 },
	{ 0x4D79, 0x23307 },
	{ 0x4D7A, 0x23358 },
	{ 0x4D7B, 0x23359 },
	{ 0x4D7C, 0x237C5 },
	{ 0x4D7D, 0x237CD },
	{ 0x4D7E, 0x237C7 },
	{ 0x4E21, 0x237E8 },
	{ 0x4E22, 0x3C4B },
	{ 0x4E23, 0x23932 },
	{ 0x4E24, 0x2A697 },
	{ 0x4E25, 0x23ADE },
	{ 0x4E26, 0x23C32 },
	{ 0x4E27, 0x20AC8 },
	{ 0x4E28, 0x2F915 },
	{ 0x4E29, 0x240F1 },
	{ 0x4E2A, 0x240F0 },
	{ 0x4E2B, 0x240EC },
	{ 0x4E2C, 0x24109 },
	{ 0x4E2D, 0x240F9 },
	{ 0x4E2E, 0x240F5 },
	{ 0x4E2F, 0x240FE },
	{ 0x4E30, 0x24474 },
	{ 0x4E31, 0x24481 },
	{ 0x4E32, 0x2447C },
	{ 0x4E33, 0x24475 },
	{ 0x4E34, 0x24489 },
	{ 0x4E35, 0x24482 },
	{ 0x4E36, 0x24497 },
	{ 0x4E37, 0x24486 },
	{ 0x4E38, 0x2447D },
	{ 0x4E39, 0x24493 },
	{ 0x4E3A, 0x2449C },
	{ 0x4E3B, 0x24476 },
	{ 0x4E3C, 0x24480 },
	{ 0x4E3D, 0x24545 },
	{ 0x4E3E, 0x206A1 },
	{ 0x4E3F, 0x24703 },
	{ 0x4E40, 0x248C9 },
	{ 0x4E41, 0x248CD },
	{ 0x4E42, 0x248D0 },
	{ 0x4E43, 0x24AAD },
	{ 0x4E44, 0x24AC5 },
	{ 0x4E45, 0x24BA2 },
	{ 0x4E46, 0x24CEC },
	{ 0x4E47, 0x24CF6 },
	{ 0x4E48, 0x24CF3 },
	{ 0x4E49, 0x24EF3 },
	{ 0x4E4A, 0x24EFA },
	{ 0x4E4B, 0x24EF9 },
	{ 0x4E4C, 0x24EF5 },
	{ 0x4E4D, 0x24EF4 },
	{ 0x4E4E, 0x24EF8 },
	{ 0x4E4F, 0x24FB6 },
	{ 0x4E50, 0x24FB4 },
	{ 0x4E51, 0x25032 },
	{ 0x4E52, 0x250CD },
	{ 