/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 *  under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
*/
/*
 * Copyright(c) 1998 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _CNS_UTF_H_
#define _CNS_UTF_H_

#include "public_struc.h"

/* maxium mapping number from CNS11643 to UTF8 */
#define MAX_CNS1_NUM		6081	/* plane #1 */
#define MAX_CNS2_NUM		7650	/* plane #2 */
#define MAX_CNS3_NUM		4197	/* plane #3 (originally plane #14) */

/* CNS 11643 plane #1, leave unicode (UTF8) to be -1 if no mapping available */
table_t cns1_utf_tab[MAX_CNS1_NUM] = {
	{ 0x2121, 0x3000 },
	{ 0x2122, 0xff0c },
	{ 0x2123, 0x3001 },
	{ 0x2124, 0x3002 },
	{ 0x2125, 0xff0e },
	{ 0x2126, 0x00b7 },
	{ 0x2127, 0xff1b },
	{ 0x2128, 0xff1a },
	{ 0x2129, 0xff1f },
	{ 0x212a, 0xff01 },
	{ 0x212b, 0xfe30 },
	{ 0x212c, 0x2026 },
	{ 0x212d, 0x2025 },
	{ 0x212e, 0xfe50 },
	{ 0x212f, 0xfe51 },
	{ 0x2130, 0xfe52 },
	{ 0x2131, 0xfe53 },
	{ 0x2132, 0xfe54 },
	{ 0x2133, 0xfe55 },
	{ 0x2134, 0xfe56 },
	{ 0x2135, 0xfe57 },
	{ 0x2136, 0xfe31 },
	{ 0x2137, 0x2014 },
	{ 0x2138, 0xfe32 },
	{ 0x2139, 0x2013 },
	{ 0x213e, 0xff08 },
	{ 0x213f, 0xff09 },
	{ 0x2140, 0xfe35 },
	{ 0x2141, 0xfe36 },
	{ 0x2142, 0xff5b },
	{ 0x2143, 0xff5d },
	{ 0x2144, 0xfe37 },
	{ 0x2145, 0xfe38 },
	{ 0x2146, 0x3014 },
	{ 0x2147, 0x3015 },
	{ 0x2148, 0xfe39 },
	{ 0x2149, 0xfe3a },
	{ 0x214a, 0x3010 },
	{ 0x214b, 0x3011 },
	{ 0x214c, 0xfe3b },
	{ 0x214d, 0xfe3c },
	{ 0x214e, 0x300a },
	{ 0x214f, 0x300b },
	{ 0x2150, 0xfe3d },
	{ 0x2151, 0xfe3e },
	{ 0x2152, 0x3008 },
	{ 0x2153, 0x3009 },
	{ 0x2154, 0xfe3f },
	{ 0x2155, 0xfe40 },
	{ 0x2156, 0x300c },
	{ 0x2157, 0x300d },
	{ 0x2158, 0xfe41 },
	{ 0x2159, 0xfe42 },
	{ 0x215a, 0x300e },
	{ 0x215b, 0x300f },
	{ 0x215c, 0xfe43 },
	{ 0x215d, 0xfe44 },
	{ 0x215e, 0xfe59 },
	{ 0x215f, 0xfe5a },
	{ 0x2160, 0xfe5b },
	{ 0x2161, 0xfe5c },
	{ 0x2162, 0xfe5d },
	{ 0x2163, 0xfe5e },
	{ 0x2164, 0x2018 },
	{ 0x2165, 0x2019 },
	{ 0x2166, 0x201c },
	{ 0x2167, 0x201d },
	{ 0x2168, 0x301d },
	{ 0x2169, 0x301e },
	{ 0x216a, 0x303a },
	{ 0x216b, 0x303b },
	{ 0x216c, 0xff03 },
	{ 0x216d, 0xff06 },
	{ 0x216e, 0xff0a },
	{ 0x216f, 0x203b },
	{ 0x2170, 0x00a7 },
	{ 0x2171, 0x3003 },
	{ 0x2172, 0x25cb },
	{ 0x2173, 0x25cf },
	{ 0x2174, 0x25b3 },
	{ 0x2175, 0x25b2 },
	{ 0x2176, 0x25ce },
	{ 0x2177, 0x2606 },
	{ 0x2178, 0x2605 },
	{ 0x2179, 0x25c7 },
	{ 0x217a, 0x25c6 },
	{ 0x217b, 0x25a1 },
	{ 0x217c, 0x25a0 },
	{ 0x217d, 0x25bd },
	{ 0x217e, 0x25bc },
	{ 0x2221, 0x32a3 },
	{ 0x2222, 0x2105 },
	{ 0x2223, 0x203e },
	{ 0x2224, 0x203f },
	{ 0x2225, 0xff3f },
	{ 0x2226, 0x2017 },
	{ 0x2227, 0xfe49 },
	{ 0x2228, 0xfe4a },
	{ 0x2229, 0xfe4d },
	{ 0x222a, 0xfe4e },
	{ 0x222b, 0xfe4b },
	{ 0x222c, 0xfe4c },
	{ 0x222d, 0xfe5f },
	{ 0x222e, 0xfe60 },
	{ 0x222f, 0xfe61 },
	{ 0x2230, 0xff0b },
	{ 0x2231, 0xff0d },
	{ 0x2232, 0x00d7 },
	{ 0x2233, 0x00f7 },
	{ 0x2234, 0x00b1 },
	{ 0x2235, 0x221a },
	{ 0x2236, 0xff1c },
	{ 0x2237, 0xff1e },
	{ 0x2238, 0xff1d },
	{ 0x2239, 0x2264 },
	{ 0x223a, 0x2265 },
	{ 0x223b, 0x2260 },
	{ 0x223c, 0x221e },
	{ 0x223d, 0x2252 },
	{ 0x223e, 0x2261 },
	{ 0x223f, 0xfe62 },
	{ 0x2240, 0xfe63 },
	{ 0x2241, 0xfe64 },
	{ 0x2242, 0xfe66 },
	{ 0x2243, 0xfe65 },
	{ 0x2244, 0x223c },
	{ 0x2245, 0x2229 },
	{ 0x2246, 0x222a },
	{ 0x2247, 0x22a5 },
	{ 0x2248, 0x2220 },
	{ 0x2249, 0x221f },
	{ 0x224a, 0x22bf },
	{ 0x224b, 0x33d2 },
	{ 0x224c, 0x33d1 },
	{ 0x224d, 0x222b },
	{ 0x224e, 0x222e },
	{ 0x224f, 0x2235 },
	{ 0x2250, 0x2234 },
	{ 0x2251, 0x2640 },
	{ 0x2252, 0x2642 },
	{ 0x2253, 0x2641 },
	{ 0x2254, 0x2609 },
	{ 0x2255, 0x2191 },
	{ 0x2256, 0x2193 },
	{ 0x2257, 0x2192 },
	{ 0x2258, 0x2190 },
	{ 0x2259, 0x2196 },
	{ 0x225a, 0x2197 },
	{ 0x225b, 0x2199 },
	{ 0x225c, 0x2198 },
	{ 0x225d, 0x2016 },
	{ 0x225e, 0xff5c },
	{ 0x225f, 0xff0f },
	{ 0x2260, 0xff3c },
	{ 0x2261, 0xfe67 },
	{ 0x2262, 0xfe68 },
	{ 0x2263, 0xff04 },
	{ 0x2264, 0x00a5 },
	{ 0x2265, 0x3012 },
	{ 0x2266, 0x00a2 },
	{ 0x2267, 0x00a3 },
	{ 0x2268, 0xff05 },
	{ 0x2269, 0xff20 },
	{ 0x226a, 0x2103 },
	{ 0x226b, 0x2109 },
	{ 0x226c, 0xfe69 },
	{ 0x226d, 0xfe6a },
	{ 0x226e, 0xfe6b },
	{ 0x226f, 0x33d5 },
	{ 0x2270, 0x339c },
	{ 0x2271, 0x339d },
	{ 0x2272, 0x339e },
	{ 0x2273, 0x33ce },
	{ 0x2274, 0x33a1 },
	{ 0x2275, 0x338e },
	{ 0x2276, 0x338f },
	{ 0x2277, 0x33c4 },
	{ 0x2278, 0x00b0 },
	{ 0x2279, 0x5159 },
	{ 0x227a, 0x515b },
	{ 0x227b, 0x515e },
	{ 0x227c, 0x515d },
	{ 0x227d, 0x5161 },
	{ 0x227e, 0x5163 },
	{ 0x2321, 0x55e7 },
	{ 0x2322, 0x74e9 },
	{ 0x2323, 0x7cce },
	{ 0x2324, 0x2581 },
	{ 0x2325, 0x2582 },
	{ 0x2326, 0x2583 },
	{ 0x2327, 0x2584 },
	{ 0x2328, 0x2585 },
	{ 0x2329, 0x2586 },
	{ 0x232a, 0x2587 },
	{ 0x232b, 0x2588 },
	{ 0x232c, 0x258f },
	{ 0x232d, 0x258e },
	{ 0x232e, 0x258d },
	{ 0x232f, 0x258c },
	{ 0x2330, 0x258b },
	{ 0x2331, 0x258a },
	{ 0x2332, 0x2589 },
	{ 0x2333, 0x253c },
	{ 0x2334, 0x2534 },
	{ 0x2335, 0x252c },
	{ 0x2336, 0x2524 },
	{ 0x2337, 0x251c },
	{ 0x2338, 0x2594 },
	{ 0x2339, 0x2500 },
	{ 0x233a, 0x2502 },
	{ 0x233b, 0x2595 },
	{ 0x233c, 0x250c },
	{ 0x233d, 0x2510 },
	{ 0x233e, 0x2514 },
	{ 0x233f, 0x2518 },
	{ 0x2340, 0x256d },
	{ 0x2341, 0x256e },
	{ 0x2342, 0x2570 },
	{ 0x2343, 0x256f },
	{ 0x2344, 0x2550 },
	{ 0x2345, 0x255e },
	{ 0x2346, 0x256a },
	{ 0x2347, 0x2561 },
	{ 0x2348, 0x25e2 },
	{ 0x2349, 0x25e3 },
	{ 0x234a, 0x25e5 },
	{ 0x234b, 0x25e4 },
	{ 0x234c, 0x2571 },
	{ 0x234d, 0x2572 },
	{ 0x234e, 0x2573 },
	{ 0x2421, 0xff10 },
	{ 0x2422, 0xff11 },
	{ 0x2423, 0xff12 },
	{ 0x2424, 0xff13 },
	{ 0x2425, 0xff14 },
	{ 0x2426, 0xff15 },
	{ 0x2427, 0xff16 },
	{ 0x2428, 0xff17 },
	{ 0x2429, 0xff18 },
	{ 0x242a, 0xff19 },
	{ 0x242b, 0x2160 },
	{ 0x242c, 0x2161 },
	{ 0x242d, 0x2162 },
	{ 0x242e, 0x2163 },
	{ 0x242f, 0x2164 },
	{ 0x2430, 0x2165 },
	{ 0x2431, 0x2166 },
	{ 0x2432, 0x2167 },
	{ 0x2433, 0x2168 },
	{ 0x2434, 0x2169 },
	{ 0x2435, 0x3021 },
	{ 0x2436, 0x3022 },
	{ 0x2437, 0x3023 },
	{ 0x2438, 0x3024 },
	{ 0x2439, 0x3025 },
	{ 0x243a, 0x3026 },
	{ 0x243b, 0x3027 },
	{ 0x243c, 0x3028 },
	{ 0x243d, 0x3029 },
	{ 0x243e, 0x303c },
	{ 0x243f, 0x303d },
	{ 0x2440, 0x303e },
	{ 0x2441, 0xff21 },
	{ 0x2442, 0xff22 },
	{ 0x2443, 0xff23 },
	{ 0x2444, 0xff24 },
	{ 0x2445, 0xff25 },
	{ 0x2446, 0xff26 },
	{ 0x2447, 0xff27 },
	{ 0x2448, 0xff28 },
	{ 0x2449, 0xff29 },
	{ 0x244a, 0xff2a },
	{ 0x244b, 0xff2b },
	{ 0x244c, 0xff2c },
	{ 0x244d, 0xff2d },
	{ 0x244e, 0xff2e },
	{ 0x244f, 0xff2f },
	{ 0x2450, 0xff30 },
	{ 0x2451, 0xff31 },
	{ 0x2452, 0xff32 },
	{ 0x2453, 0xff33 },
	{ 0x2454, 0xff34 },
	{ 0x2455, 0xff35 },
	{ 0x2456, 0xff36 },
	{ 0x2457, 0xff37 },
	{ 0x2458, 0xff38 },
	{ 0x2459, 0xff39 },
	{ 0x245a, 0xff3a },
	{ 0x245b, 0xff41 },
	{ 0x245c, 0xff42 },
	{ 0x245d, 0xff43 },
	{ 0x245e, 0xff44 },
	{ 0x245f, 0xff45 },
	{ 0x2460, 0xff46 },
	{ 0x2461, 0xff47 },
	{ 0x2462, 0xff48 },
	{ 0x2463, 0xff49 },
	{ 0x2464, 0xff4a },
	{ 0x2465, 0xff4b },
	{ 0x2466, 0xff4c },
	{ 0x2467, 0xff4d },
	{ 0x2468, 0xff4e },
	{ 0x2469, 0xff4f },
	{ 0x246a, 0xff50 },
	{ 0x246b, 0xff51 },
	{ 0x246c, 0xff52 },
	{ 0x246d, 0xff53 },
	{ 0x246e, 0xff54 },
	{ 0x246f, 0xff55 },
	{ 0x2470, 0xff56 },
	{ 0x2471, 0xff57 },
	{ 0x2472, 0xff58 },
	{ 0x2473, 0xff59 },
	{ 0x2474, 0xff5a },
	{ 0x2475, 0x0391 },
	{ 0x2476, 0x0392 },
	{ 0x2477, 0x0393 },
	{ 0x2478, 0x0394 },
	{ 0x2479, 0x0395 },
	{ 0x247a, 0x0396 },
	{ 0x247b, 0x0397 },
	{ 0x247c, 0x0398 },
	{ 0x247d, 0x0399 },
	{ 0x247e, 0x039a },
	{ 0x2521, 0x039b },
	{ 0x2522, 0x039c },
	{ 0x2523, 0x039d },
	{ 0x2524, 0x039e },
	{ 0x2525, 0x039f },
	{ 0x2526, 0x03a0 },
	{ 0x2527, 0x03a1 },
	{ 0x2528, 0x03a3 },
	{ 0x2529, 0x03a4 },
	{ 0x252a, 0x03a5 },
	{ 0x252b, 0x03a6 },
	{ 0x252c, 0x03a7 },
	{ 0x252d, 0x03a8 },
	{ 0x252e, 0x03a9 },
	{ 0x252f, 0x03b1 },
	{ 0x2530, 0x03b2 },
	{ 0x2531, 0x03b3 },
	{ 0x2532, 0x03b4 },
	{ 0x2533, 0x03b5 },
	{ 0x2534, 0x03b6 },
	{ 0x2535, 0x03b7 },
	{ 0x2536, 0x03b8 },
	{ 0x2537, 0x03b9 },
	{ 0x2538, 0x03ba },
	{ 0x2539, 0x03bb },
	{ 0x253a, 0x03bc },
	{ 0x253b, 0x03bd },
	{ 0x253c, 0x03be },
	{ 0x253d, 0x03bf },
	{ 0x253e, 0x03c0 },
	{ 0x253f, 0x03c1 },
	{ 0x2540, 0x03c3 },
	{ 0x2541, 0x03c4 },
	{ 0x2542, 0x03c5 },
	{ 0x2543, 0x03c6 },
	{ 0x2544, 0x03c7 },
	{ 0x2545, 0x03c8 },
	{ 0x2546, 0x03c9 },
	{ 0x2547, 0x3105 },
	{ 0x2548, 0x3106 },
	{ 0x2549, 0x3107 },
	{ 0x254a, 0x3108 },
	{ 0x254b, 0x3109 },
	{ 0x254c, 0x310a },
	{ 0x254d, 0x310b },
	{ 0x254e, 0x310c },
	{ 0x254f, 0x310d },
	{ 0x2550, 0x310e },
	{ 0x2551, 0x310f },
	{ 0x2552, 0x3110 },
	{ 0x2553, 0x3111 },
	{ 0x2554, 0x3112 },
	{ 0x2555, 0x3113 },
	{ 0x2556, 0x3114 },
	{ 0x2557, 0x3115 },
	{ 0x2558, 0x3116 },
	{ 0x2559, 0x3117 },
	{ 0x255a, 0x3118 },
	{ 0x255b, 0x3119 },
	{ 0x255c, 0x311a },
	{ 0x255d, 0x311b },
	{ 0x255e, 0x311c },
	{ 0x255f, 0x311d },
	{ 0x2560, 0x311e },
	{ 0x2561, 0x311f },
	{ 0x2562, 0x3120 },
	{ 0x2563, 0x3121 },
	{ 0x2564, 0x3122 },
	{ 0x2565, 0x3123 },
	{ 0x2566, 0x3124 },
	{ 0x2567, 0x3125 },
	{ 0x2568, 0x3126 },
	{ 0x2569, 0x3127 },
	{ 0x256a, 0x3128 },
	{ 0x256b, 0x3129 },
	{ 0x256c, 0x02d9 },
	{ 0x256d, 0x02c9 },
	{ 0x256e, 0x02ca },
	{ 0x256f, 0x02c7 },
	{ 0x2570, 0x02cb },
	{ 0x2621, 0x2460 },
	{ 0x2622, 0x2461 },
	{ 0x2623, 0x2462 },
	{ 0x2624, 0x2463 },
	{ 0x2625, 0x2464 },
	{ 0x2626, 0x2465 },
	{ 0x2627, 0x2466 },
	{ 0x2628, 0x2467 },
	{ 0x2629, 0x2468 },
	{ 0x262a, 0x2469 },
	{ 0x262b, 0x2474 },
	{ 0x262c, 0x2475 },
	{ 0x262d, 0x2476 },
	{ 0x262e, 0x2477 },
	{ 0x262f, 0x2478 },
	{ 0x2630, 0x2479 },
	{ 0x2631, 0x247a },
	{ 0x2632, 0x247b },
	{ 0x2633, 0x247c },
	{ 0x2634, 0x247d },
	{ 0x2635, 0x2170 },
	{ 0x2636, 0x2171 },
	{ 0x2637, 0x2172 },
	{ 0x2638, 0x2173 },
	{ 0x2639, 0x2174 },
	{ 0x263a, 0x2175 },
	{ 0x263b, 0x2176 },
	{ 0x263c, 0x2177 },
	{ 0x263d, 0x2178 },
	{ 0x263e, 0x2179 },
	{ 0x2721, (unsigned int)-1 },
	{ 0x2722, (unsigned int)-1 },
	{ 0x2723, (unsigned int)-1 },
	{ 0x2724, (unsigned int)-1 },
	{ 0x2725, (unsigned int)-1 },
	{ 0x2726, (unsigned int)-1 },
	{ 0x2727, (unsigned int)-1 },
	{ 0x2728, (unsigned int)-1 },
	{ 0x2729, (unsigned int)-1 },
	{ 0x272a, (unsigned int)-1 },
	{ 0x272b, (unsigned int)-1 },
	{ 0x272c, (unsigned int)-1 },
	{ 0x272d, (unsigned int)-1 },
	{ 0x272e, (unsigned int)-1 },
	{ 0x272f, (unsigned int)-1 },
	{ 0x2730, (unsigned int)-1 },
	{ 0x2731, (unsigned int)-1 },
	{ 0x2732, (unsigned int)-1 },
	{ 0x2733, (unsigned int)-1 },
	{ 0x2734, (unsigned int)-1 },
	{ 0x2735, (unsigned int)-1 },
	{ 0x2736, (unsigned int)-1 },
	{ 0x2737, (unsigned int)-1 },
	{ 0x2738, (unsigned int)-1 },
	{ 0x2739, (unsigned int)-1 },
	{ 0x273a, (unsigned int)-1 },
	{ 0x273b, (unsigned int)-1 },
	{ 0x273c, (unsigned int)-1 },
	{ 0x273d, (unsigned int)-1 },
	{ 0x273e, (unsigned int)-1 },
	{ 0x273f, (unsigned int)-1 },
	{ 0x2740, (unsigned int)-1 },
	{ 0x2741, (unsigned int)-1 },
	{ 0x2742, (unsigned int)-1 },
	{ 0x2743, (unsigned int)-1 },
	{ 0x2744, (unsigned int)-1 },
	{ 0x2745, (unsigned int)-1 },
	{ 0x2746, (unsigned int)-1 },
	{ 0x2747, (unsigned int)-1 },
	{ 0x2748, (unsigned int)-1 },
	{ 0x2749, (unsigned int)-1 },
	{ 0x274a, (unsigned int)-1 },
	{ 0x274b, (unsigned int)-1 },
	{ 0x274c, (unsigned int)-1 },
	{ 0x274d, (unsigned int)-1 },
	{ 0x274e, (unsigned int)-1 },
	{ 0x274f, (unsigned int)-1 },
	{ 0x2750, (unsigned int)-1 },
	{ 0x2751, (unsigned int)-1 },
	{ 0x2752, (unsigned int)-1 },
	{ 0x2753, (unsigned int)-1 },
	{ 0x2754, (unsigned int)-1 },
	{ 0x2755, (unsigned int)-1 },
	{ 0x2756, (unsigned int)-1 },
	{ 0x2757, (unsigned int)-1 },
	{ 0x2758, (unsigned int)-1 },
	{ 0x2759, (unsigned int)-1 },
	{ 0x275a, (unsigned int)-1 },
	{ 0x275b, (unsigned int)-1 },
	{ 0x275c, (unsigned int)-1 },
	{ 0x275d, (unsigned int)-1 },
	{ 0x275e, (unsigned int)-1 },
	{ 0x275f, (unsigned int)-1 },
	{ 0x2760, (unsigned int)-1 },
	{ 0x2761, (unsigned int)-1 },
	{ 0x2762, (unsigned int)-1 },
	{ 0x2763, (unsigned int)-1 },
	{ 0x2764, (unsigned int)-1 },
	{ 0x2765, (unsigned int)-1 },
	{ 0x2766, (unsigned int)-1 },
	{ 0x2767, (unsigned int)-1 },
	{ 0x2768, (unsigned int)-1 },
	{ 0x2769, (unsigned int)-1 },
	{ 0x276a, (unsigned int)-1 },
	{ 0x276b, (unsigned int)-1 },
	{ 0x276c, (unsigned int)-1 },
	{ 0x276d, (unsigned int)-1 },
	{ 0x276e, (unsigned int)-1 },
	{ 0x276f, (unsigned int)-1 },
	{ 0x2770, (unsigned int)-1 },
	{ 0x2771, (unsigned int)-1 },
	{ 0x2772, (unsigned int)-1 },
	{ 0x2773, (unsigned int)-1 },
	{ 0x2774, (unsigned int)-1 },
	{ 0x2775, (unsigned int)-1 },
	{ 0x2776, (unsigned int)-1 },
	{ 0x2777, (unsigned int)-1 },
	{ 0x2778, (unsigned int)-1 },
	{ 0x2779, (unsigned int)-1 },
	{ 0x277a, (unsigned int)-1 },
	{ 0x277b, (unsigned int)-1 },
	{ 0x277c, (unsigned int)-1 },
	{ 0x277d, (unsigned int)-1 },
	{ 0x277e, (unsigned int)-1 },
	{ 0x2821, (unsigned int)-1 },
	{ 0x2822, (unsigned int)-1 },
	{ 0x2823, (unsigned int)-1 },
	{ 0x2824, (unsigned int)-1 },
	{ 0x2825, (unsigned int)-1 },
	{ 0x2826, (unsigned int)-1 },
	{ 0x2827, (unsigned int)-1 },
	{ 0x2828, (unsigned int)-1 },
	{ 0x2829, (unsigned int)-1 },
	{ 0x282a, (unsigned int)-1 },
	{ 0x282b, (unsigned int)-1 },
	{ 0x282c, (unsigned int)-1 },
	{ 0x282d, (unsigned int)-1 },
	{ 0x282e, (unsigned int)-1 },
	{ 0x282f, (unsigned int)-1 },
	{ 0x2830, (unsigned int)-1 },
	{ 0x2831, (unsigned int)-1 },
	{ 0x2832, (unsigned int)-1 },
	{ 0x2833, (unsigned int)-1 },
	{ 0x2834, (unsigned int)-1 },
	{ 0x2835, (unsigned int)-1 },
	{ 0x2836, (unsigned int)-1 },
	{ 0x2837, (unsigned int)-1 },
	{ 0x2838, (unsigned int)-1 },
	{ 0x2839, (unsigned int)-1 },
	{ 0x283a, (unsigned int)-1 },
	{ 0x283b, (unsigned int)-1 },
	{ 0x283c, (unsigned int)-1 },
	{ 0x283d, (unsigned int)-1 },
	{ 0x283e, (unsigned int)-1 },
	{ 0x283f, (unsigned int)-1 },
	{ 0x2840, (unsigned int)-1 },
	{ 0x2841, (unsigned int)-1 },
	{ 0x2842, (unsigned int)-1 },
	{ 0x2843, (unsigned int)-1 },
	{ 0x2844, (unsigned int)-1 },
	{ 0x2845, (unsigned int)-1 },
	{ 0x2846, (unsigned int)-1 },
	{ 0x2847, (unsigned int)-1 },
	{ 0x2848, (unsigned int)-1 },
	{ 0x2849, (unsigned int)-1 },
	{ 0x284a, (unsigned int)-1 },
	{ 0x284b, (unsigned int)-1 },
	{ 0x284c, (unsigned int)-1 },
	{ 0x284d, (unsigned int)-1 },
	{ 0x284e, (unsigned int)-1 },
	{ 0x284f, (unsigned int)-1 },
	{ 0x2850, (unsigned int)-1 },
	{ 0x2851, (unsigned int)-1 },
	{ 0x2852, (unsigned int)-1 },
	{ 0x2853, (unsigned int)-1 },
	{ 0x2854, (unsigned int)-1 },
	{ 0x2855, (unsigned int)-1 },
	{ 0x2856, (unsigned int)-1 },
	{ 0x2857, (unsigned int)-1 },
	{ 0x2858, (unsigned int)-1 },
	{ 0x2859, (unsigned int)-1 },
	{ 0x285a, (unsigned int)-1 },
	{ 0x285b, (unsigned int)-1 },
	{ 0x285c, (unsigned int)-1 },
	{ 0x285d, (unsigned int)-1 },
	{ 0x285e, (unsigned int)-1 },
	{ 0x285f, (unsigned int)-1 },
	{ 0x2860, (unsigned int)-1 },
	{ 0x2861, (unsigned int)-1 },
	{ 0x2862, (unsigned int)-1 },
	{ 0x2863, (unsigned int)-1 },
	{ 0x2864, (unsigned int)-1 },
	{ 0x2865, (unsigned int)-1 },
	{ 0x2866, (unsigned int)-1 },
	{ 0x2867, (unsigned int)-1 },
	{ 0x2868, (unsigned int)-1 },
	{ 0x2869, (unsigned int)-1 },
	{ 0x286a, (unsigned int)-1 },
	{ 0x286b, (unsigned int)-1 },
	{ 0x286c, (unsigned int)-1 },
	{ 0x286d, (unsigned int)-1 },
	{ 0x286e, (unsigned int)-1 },
	{ 0x286f, (unsigned int)-1 },
	{ 0x2870, (unsigned int)-1 },
	{ 0x2871, (unsigned int)-1 },
	{ 0x2872, (unsigned int)-1 },
	{ 0x2873, (unsigned int)-1 },
	{ 0x2874, (unsigned int)-1 },
	{ 0x2875, (unsigned int)-1 },
	{ 0x2876, (unsigned int)-1 },
	{ 0x2877, (unsigned int)-1 },
	{ 0x2878, (unsigned int)-1 },
	{ 0x2879, (unsigned int)-1 },
	{ 0x287a, (unsigned int)-1 },
	{ 0x287b, (unsigned int)-1 },
	{ 0x287c, (unsigned int)-1 },
	{ 0x287d, (unsigned int)-1 },
	{ 0x287e, (unsigned int)-1 },
	{ 0x2921, (unsigned int)-1 },
	{ 0x2922, (unsigned int)-1 },
	{ 0x2923, (unsigned int)-1 },
	{ 0x2924, (unsigned int)-1 },
	{ 0x2925, (unsigned int)-1 },
	{ 0x2926, (unsigned int)-1 },
	{ 0x2927, (unsigned int)-1 },
	{ 0x2928, (unsigned int)-1 },
	{ 0x2929, (unsigned int)-1 },
	{ 0x292a, (unsigned int)-1 },
	{ 0x292b, (unsigned int)-1 },
	{ 0x292c, (unsigned int)-1 },
	{ 0x292d, (unsigned int)-1 },
	{ 0x292e, (unsigned int)-1 },
	{ 0x292f, (unsigned int)-1 },
	{ 0x2930, (unsigned int)-1 },
	{ 0x2931, (unsigned int)-1 },
	{ 0x2932, (unsigned int)-1 },
	{ 0x2933, (unsigned int)-1 },
	{ 0x2934, (unsigned int)-1 },
	{ 0x2935, (unsigned int)-1 },
	{ 0x2936, (unsigned int)-1 },
	{ 0x2937, (unsigned int)-1 },
	{ 0x2938, (unsigned int)-1 },
	{ 0x2939, (unsigned int)-1 },
	{ 0x4221, 0x2400 },
	{ 0x4222, 0x2401 },
	{ 0x4223, 0x2402 },
	{ 0x4224, 0x2403 },
	{ 0x4225, 0x2404 },
	{ 0x4226, 0x2405 },
	{ 0x4227, 0x2406 },
	{ 0x4228, 0x2407 },
	{ 0x4229, 0x2408 },
	{ 0x422a, 0x2409 },
	{ 0x422b, 0x240a },
	{ 0x422c, 0x240b },
	{ 0x422d, 0x240c },
	{ 0x422e, 0x240d },
	{ 0x422f, 0x240e },
	{ 0x4230, 0x240f },
	{ 0x4231, 0x2410 },
	{ 0x4232, 0x2411 },
	{ 0x4233, 0x2412 },
	{ 0x4234, 0x2413 },
	{ 0x4235, 0x2414 },
	{ 0x4236, 0x2415 },
	{ 0x4237, 0x2416 },
	{ 0x4238, 0x2417 },
	{ 0x4239, 0x2418 },
	{ 0x423a, 0x2419 },
	{ 0x423b, 0x241a },
	{ 0x423c, 0x241b },
	{ 0x423d, 0x241c },
	{ 0x423e, 0x241d },
	{ 0x423f, 0x241e },
	{ 0x4240, 0x241f },
	{ 0x4241, 0x2421 },
	{ 0x4421, 0x4e00 },
	{ 0x4422, 0x4e59 },
	{ 0x4423, 0x4e01 },
	{ 0x4424, 0x4e03 },
	{ 0x4425, 0x4e43 },
	{ 0x4426, 0x4e5d },
	{ 0x4427, 0x4e86 },
	{ 0x4428, 0x4e8c },
	{ 0x4429, 0x4eba },
	{ 0x442a, 0x513f },
	{ 0x442b, 0x5165 },
	{ 0x442c, 0x516b },
	{ 0x442d, 0x51e0 },
	{ 0x442e, 0x5200 },
	{ 0x442f, 0x5201 },
	{ 0x4430, 0x529b },
	{ 0x4431, 0x5315 },
	{ 0x4432, 0x5341 },
	{ 0x4433, 0x535c },
	{ 0x4434, 0x53c8 },
	{ 0x4435, 0x4e09 },
	{ 0x4436, 0x4e0b },
	{ 0x4437, 0x4e08 },
	{ 0x4438, 0x4e0a },
	{ 0x4439, 0x4e2b },
	{ 0x443a, 0x4e38 },
	{ 0x443b, 0x51e1 },
	{ 0x443c, 0x4e45 },
	{ 0x443d, 0x4e48 },
	{ 0x443e, 0x4e5f },
	{ 0x443f, 0x4e5e },
	{ 0x4440, 0x4e8e },
	{ 0x4441, 0x4ea1 },
	{ 0x4442, 0x5140 },
	{ 0x4443, 0x5203 },
	{ 0x4444, 0x52fa },
	{ 0x4445, 0x5343 },
	{ 0x4446, 0x53c9 },
	{ 0x4447, 0x53e3 },
	{ 0x4448, 0x571f },
	{ 0x4449, 0x58eb },
	{ 0x444a, 0x5915 },
	{ 0x444b, 0x5927 },
	{ 0x444c, 0x5973 },
	{ 0x444d, 0x5b50 },
	{ 0x444e, 0x5b51 },
	{ 0x444f, 0x5b53 },
	{ 0x4450, 0x5bf8 },
	{ 0x4451, 0x5c0f },
	{ 0x4452, 0x5c22 },
	{ 0x4453, 0x5c38 },
	{ 0x4454, 0x5c71 },
	{ 0x4455, 0x5ddd },
	{ 0x4456, 0x5de5 },
	{ 0x4457, 0x5df1 },
	{ 0x4458, 0x5df2 },
	{ 0x4459, 0x5df3 },
	{ 0x445a, 0x5dfe },
	{ 0x445b, 0x5e72 },
	{ 0x445c, 0x5efe },
	{ 0x445d, 0x5f0b },
	{ 0x445e, 0x5f13 },
	{ 0x445f, 0x624d },
	{ 0x4460, 0x4e11 },
	{ 0x4461, 0x4e10 },
	{ 0x4462, 0x4e0d },
	{ 0x4463, 0x4e2d },
	{ 0x4464, 0x4e30 },
	{ 0x4465, 0x4e39 },
	{ 0x4466, 0x4e4b },
	{ 0x4467, 0x5c39 },
	{ 0x4468, 0x4e88 },
	{ 0x4469, 0x4e91 },
	{ 0x446a, 0x4e95 },
	{ 0x446b, 0x4e92 },
	{ 0x446c, 0x4e94 },
	{ 0x446d, 0x4ea2 },
	{ 0x446e, 0x4ec1 },
	{ 0x446f, 0x4ec0 },
	{ 0x4470, 0x4ec3 },
	{ 0x4471, 0x4ec6 },
	{ 0x4472, 0x4ec7 },
	{ 0x4473, 0x4ecd },
	{ 0x4474, 0x4eca },
	{ 0x4475, 0x4ecb },
	{ 0x4476, 0x4ec4 },
	{ 0x4477, 0x5143 },
	{ 0x4478, 0x5141 },
	{ 0x4479, 0x5167 },
	{ 0x447a, 0x516d },
	{ 0x447b, 0x516e },
	{ 0x447c, 0x516c },
	{ 0x447d, 0x5197 },
	{ 0x447e, 0x51f6 },
	{ 0x4521, 0x5206 },
	{ 0x4522, 0x5207 },
	{ 0x4523, 0x5208 },
	{ 0x4524, 0x52fb },
	{ 0x4525, 0x52fe },
	{ 0x4526, 0x52ff },
	{ 0x4527, 0x5316 },
	{ 0x4528, 0x5339 },
	{ 0x4529, 0x5348 },
	{ 0x452a, 0x5347 },
	{ 0x452b, 0x5345 },
	{ 0x452c, 0x535e },
	{ 0x452d, 0x5384 },
	{ 0x452e, 0x53cb },
	{ 0x452f, 0x53ca },
	{ 0x4530, 0x53cd },
	{ 0x4531, 0x58ec },
	{ 0x4532, 0x5929 },
	{ 0x4533, 0x592b },
	{ 0x4534, 0x592a },
	{ 0x4535, 0x592d },
	{ 0x4536, 0x5b54 },
	{ 0x4537, 0x5c11 },
	{ 0x4538, 0x5c24 },
	{ 0x4539, 0x5c3a },
	{ 0x453a, 0x5c6f },
	{ 0x453b, 0x5df4 },
	{ 0x453c, 0x5e7b },
	{ 0x453d, 0x5eff },
	{ 0x453e, 0x5f14 },
	{ 0x453f, 0x5f15 },
	{ 0x4540, 0x5fc3 },
	{ 0x4541, 0x6208 },
	{ 0x4542, 0x6236 },
	{ 0x4543, 0x624b },
	{ 0x4544, 0x624e },
	{ 0x4545, 0x652f },
	{ 0x4546, 0x6587 },
	{ 0x4547, 0x6597 },
	{ 0x4548, 0x65a4 },
	{ 0x4549, 0x65b9 },
	{ 0x454a, 0x65e5 },
	{ 0x454b, 0x66f0 },
	{ 0x454c, 0x6708 },
	{ 0x454d, 0x6728 },
	{ 0x454e, 0x6b20 },
	{ 0x454f, 0x6b62 },
	{ 0x4550, 0x6b79 },
	{ 0x4551, 0x6bcb },
	{ 0x4552, 0x6bd4 },
	{ 0x4553, 0x6bdb },
	{ 0x4554, 0x6c0f },
	{ 0x4555, 0x6c34 },
	{ 0x4556, 0x706b },
	{ 0x4557, 0x722a },
	{ 0x4558, 0x7236 },
	{ 0x4559, 0x723b },
	{ 0x455a, 0x7247 },
	{ 0x455b, 0x7259 },
	{ 0x455c, 0x725b },
	{ 0x455d, 0x72ac },
	{ 0x455e, 0x738b },
	{ 0x455f, 0x4e19 },
	{ 0x4560, 0x4e16 },
	{ 0x4561, 0x4e15 },
	{ 0x4562, 0x4e14 },
	{ 0x4563, 0x4e18 },
	{ 0x4564, 0x4e3b },
	{ 0x4565, 0x4e4d },
	{ 0x4566, 0x4e4f },
	{ 0x4567, 0x4e4e },
	{ 0x4568, 0x4ee5 },
	{ 0x4569, 0x4ed8 },
	{ 0x456a, 0x4ed4 },
	{ 0x456b, 0x4ed5 },
	{ 0x456c, 0x4ed6 },
	{ 0x456d, 0x4ed7 },
	{ 0x456e, 0x4ee3 },
	{ 0x456f, 0x4ee4 },
	{ 0x4570, 0x4ed9 },
	{ 0x4571, 0x4ede },
	{ 0x4572, 0x5145 },
	{ 0x4573, 0x5144 },
	{ 0x4574, 0x5189 },
	{ 0x4575, 0x518a },
	{ 0x4576, 0x51ac },
	{ 0x4577, 0x51f9 },
	{ 0x4578, 0x51fa },
	{ 0x4579, 0x51f8 },
	{ 0x457a, 0x520a },
	{ 0x457b, 0x52a0 },
	{ 0x457c, 0x529f },
	{ 0x457d, 0x5305 },
	{ 0x457e, 0x5306 },
	{ 0x4621, 0x5317 },
	{ 0x4622, 0x531d },
	{ 0x4623, 0x4edf },
	{ 0x4624, 0x534a },
	{ 0x4625, 0x5349 },
	{ 0x4626, 0x5361 },
	{ 0x4627, 0x5360 },
	{ 0x4628, 0x536f },
	{ 0x4629, 0x536e },
	{ 0x462a, 0x53bb },
	{ 0x462b, 0x53ef },
	{ 0x462c, 0x53e4 },
	{ 0x462d, 0x53f3 },
	{ 0x462e, 0x53ec },
	{ 0x462f, 0x53ee },
	{ 0x4630, 0x53e9 },
	{ 0x4631, 0x53e8 },
	{ 0x4632, 0x53fc },
	{ 0x4633, 0x53f8 },
	{ 0x4634, 0x53f5 },
	{ 0x4635, 0x53eb },
	{ 0x4636, 0x53e6 },
	{ 0x4637, 0x53ea },
	{ 0x4638, 0x53f2 },
	{ 0x4639, 0x53f1 },
	{ 0x463a, 0x53f0 },
	{ 0x463b, 0x53e5 },
	{ 0x463c, 0x53ed },
	{ 0x463d, 0x53fb },
	{ 0x463e, 0x56db },
	{ 0x463f, 0x56da },
	{ 0x4640, 0x5916 },
	{ 0x4641, 0x592e },
	{ 0x4642, 0x5931 },
	{ 0x4643, 0x5974 },
	{ 0x4644, 0x5976 },
	{ 0x4645, 0x5b55 },
	{ 0x4646, 0x5b83 },
	{ 0x4647, 0x5c3c },
	{ 0x4648, 0x5de8 },
	{ 0x4649, 0x5de7 },
	{ 0x464a, 0x5de6 },
	{ 0x464b, 0x5e02 },
	{ 0x464c, 0x5e03 },
	{ 0x464d, 0x5e73 },
	{ 0x464e, 0x5e7c },
	{ 0x464f, 0x5f01 },
	{ 0x4650, 0x5f18 },
	{ 0x4651, 0x5f17 },
	{ 0x4652, 0x5fc5 },
	{ 0x4653, 0x620a },
	{ 0x4654, 0x6253 },
	{ 0x4655, 0x6254 },
	{ 0x4656, 0x6252 },
	{ 0x4657, 0x6251 },
	{ 0x4658, 0x65a5 },
	{ 0x4659, 0x65e6 },
	{ 0x465a, 0x672e },
	{ 0x465b, 0x672c },
	{ 0x465c, 0x672a },
	{ 0x465d, 0x672b },
	{ 0x465e, 0x672d },
	{ 0x465f, 0x6b63 },
	{ 0x4660, 0x6bcd },
	{ 0x4661, 0x6c11 },
	{ 0x4662, 0x6c10 },
	{ 0x4663, 0x6c38 },
	{ 0x4664, 0x6c41 },
	{ 0x4665, 0x6c40 },
	{ 0x4666, 0x6c3e },
	{ 0x4667, 0x72af },
	{ 0x4668, 0x7384 },
	{ 0x4669, 0x7389 },
	{ 0x466a, 0x74dc },
	{ 0x466b, 0x74e6 },
	{ 0x466c, 0x7518 },
	{ 0x466d, 0x751f },
	{ 0x466e, 0x7528 },
	{ 0x466f, 0x7529 },
	{ 0x4670, 0x7530 },
	{ 0x4671, 0x7531 },
	{ 0x4672, 0x7532 },
	{ 0x4673, 0x7533 },
	{ 0x4674, 0x758b },
	{ 0x4675, 0x767d },
	{ 0x4676, 0x76ae },
	{ 0x4677, 0x76bf },
	{ 0x4678, 0x76ee },
	{ 0x4679, 0x77db },
	{ 0x467a, 0x77e2 },
	{ 0x467b, 0x77f3 },
	{ 0x467c, 0x793a },
	{ 0x467d, 0x79be },
	{ 0x467e, 0x7a74 },
	{ 0x4721, 0x7acb },
	{ 0x4722, 0x4e1e },
	{ 0x4723, 0x4e1f },
	{ 0x4724, 0x4e52 },
	{ 0x4725, 0x4e53 },
	{ 0x4726, 0x4e69 },
	{ 0x4727, 0x4e99 },
	{ 0x4728, 0x4ea4 },
	{ 0x4729, 0x4ea6 },
	{ 0x472a, 0x4ea5 },
	{ 0x472b, 0x4eff },
	{ 0x472c, 0x4f09 },
	{ 0x472d, 0x4f19 },
	{ 0x472e, 0x4f0a },
	{ 0x472f, 0x4f15 },
	{ 0x4730, 0x4f0d },
	{ 0x4731, 0x4f10 },
	{ 0x4732, 0x4f11 },
	{ 0x4733, 0x4f0f },
	{ 0x4734, 0x4ef2 },
	{ 0x4735, 0x4ef6 },
	{ 0x4736, 0x4efb },
	{ 0x4737, 0x4ef0 },
	{ 0x4738, 0x4ef3 },
	{ 0x4739, 0x4efd },
	{ 0x473a, 0x4f01 },
	{ 0x473b, 0x4f0b },
	{ 0x473c, 0x5149 },
	{ 0x473d, 0x5147 },
	{ 0x473e, 0x5146 },
	{ 0x473f, 0x5148 },
	{ 0x4740, 0x5168 },
	{ 0x4741, 0x5171 },
	{ 0x4742, 0x518d },
	{ 0x4743, 0x51b0 },
	{ 0x4744, 0x5217 },
	{ 0x4745, 0x5211 },
	{ 0x4746, 0x5212 },
	{ 0x4747, 0x520e },
	{ 0x4748, 0x5216 },
	{ 0x4749, 0x52a3 },
	{ 0x474a, 0x5308 },
	{ 0x474b, 0x5321 },
	{ 0x474c, 0x5320 },
	{ 0x474d, 0x5370 },
	{ 0x474e, 0x5371 },
	{ 0x474f, 0x5409 },
	{ 0x4750, 0x540f },
	{ 0x4751, 0x540c },
	{ 0x4752, 0x540a },
	{ 0x4753, 0x5410 },
	{ 0x4754, 0x5401 },
	{ 0x4755, 0x540b },
	{ 0x4756, 0x5404 },
	{ 0x4757, 0x5411 },
	{ 0x4758, 0x540d },
	{ 0x4759, 0x5408 },
	{ 0x475a, 0x5403 },
	{ 0x475b, 0x540e },
	{ 0x475c, 0x5406 },
	{ 0x475d, 0x5412 },
	{ 0x475e, 0x56e0 },
	{ 0x475f, 0x56de },
	{ 0x4760, 0x56dd },
	{ 0x4761, 0x5733 },
	{ 0x4762, 0x5730 },
	{ 0x4763, 0x5728 },
	{ 0x4764, 0x572d },
	{ 0x4765, 0x572c },
	{ 0x4766, 0x572f },
	{ 0x4767, 0x5729 },
	{ 0x4768, 0x5919 },
	{ 0x4769, 0x591a },
	{ 0x476a, 0x5937 },
	{ 0x476b, 0x5938 },
	{ 0x476c, 0x5984 },
	{ 0x476d, 0x5978 },
	{ 0x476e, 0x5983 },
	{ 0x476f, 0x597d },
	{ 0x4770, 0x5979 },
	{ 0x4771, 0x5982 },
	{ 0x4772, 0x5981 },
	{ 0x4773, 0x5b57 },
	{ 0x4774, 0x5b58 },
	{ 0x4775, 0x5b87 },
	{ 0x4776, 0x5b88 },
	{ 0x4777, 0x5b85 },
	{ 0x4778, 0x5b89 },
	{ 0x4779, 0x5bfa },
	{ 0x477a, 0x5c16 },
	{ 0x477b, 0x5c79 },
	{ 0x477c, 0x5dde },
	{ 0x477d, 0x5e06 },
	{ 0x477e, 0x5e76 },
	{ 0x4821, 0x5e74 },
	{ 0x4822, 0x5f0f },
	{ 0x4823, 0x5f1b },
	{ 0x4824, 0x5fd9 },
	{ 0x4825, 0x5fd6 },
	{ 0x4826, 0x620e },
	{ 0x4827, 0x620c },
	{ 0x4828, 0x620d },
	{ 0x4829, 0x6210 },
	{ 0x482a, 0x6263 },
	{ 0x482b, 0x625b },
	{ 0x482c, 0x6258 },
	{ 0x482d, 0x6536 },
	{ 0x482e, 0x65e9 },
	{ 0x482f, 0x65e8 },
	{ 0x4830, 0x65ec },
	{ 0x4831, 0x65ed },
	{ 0x4832, 0x66f2 },
	{ 0x4833, 0x66f3 },
	{ 0x4834, 0x6709 },
	{ 0x4835, 0x673d },
	{ 0x4836, 0x6734 },
	{ 0x4837, 0x6731 },
	{ 0x4838, 0x6735 },
	{ 0x4839, 0x6b21 },
	{ 0x483a, 0x6b64 },
	{ 0x483b, 0x6b7b },
	{ 0x483c, 0x6c16 },
	{ 0x483d, 0x6c5d },
	{ 0x483e, 0x6c57 },
	{ 0x483f, 0x6c59 },
	{ 0x4840, 0x6c5f },
	{ 0x4841, 0x6c60 },
	{ 0x4842, 0x6c50 },
	{ 0x4843, 0x6c55 },
	{ 0x4844, 0x6c61 },
	{ 0x4845, 0x6c5b },
	{ 0x4846, 0x6c4d },
	{ 0x4847, 0x6c4e },
	{ 0x4848, 0x7070 },
	{ 0x4849, 0x725f },
	{ 0x484a, 0x725d },
	{ 0x484b, 0x767e },
	{ 0x484c, 0x7af9 },
	{ 0x484d, 0x7c73 },
	{ 0x484e, 0x7cf8 },
	{ 0x484f, 0x7f36 },
	{ 0x4850, 0x7f8a },
	{ 0x4851, 0x7fbd },
	{ 0x4852, 0x8001 },
	{ 0x4853, 0x8003 },
	{ 0x4854, 0x800c },
	{ 0x4855, 0x8012 },
	{ 0x4856, 0x8033 },
	{ 0x4857, 0x807f },
	{ 0x4858, 0x8089 },
	{ 0x4859, 0x808b },
	{ 0x485a, 0x808c },
	{ 0x485b, 0x81e3 },
	{ 0x485c, 0x81ea },
	{ 0x485d, 0x81f3 },
	{ 0x485e, 0x81fc },
	{ 0x485f, 0x820c },
	{ 0x4860, 0x821b },
	{ 0x4861, 0x821f },
	{ 0x4862, 0x826e },
	{ 0x4863, 0x8272 },
	{ 0x4864, 0x827e },
	{ 0x4865, 0x866b },
	{ 0x4866, 0x8840 },
	{ 0x4867, 0x884c },
	{ 0x4868, 0x8863 },
	{ 0x4869, 0x897f },
	{ 0x486a, 0x9621 },
	{ 0x486b, 0x4e32 },
	{ 0x486c, 0x4ea8 },
	{ 0x486d, 0x4f4d },
	{ 0x486e, 0x4f4f },
	{ 0x486f, 0x4f47 },
	{ 0x4870, 0x4f57 },
	{ 0x4871, 0x4f5e },
	{ 0x4872, 0x4f34 },
	{ 0x4873, 0x4f5b },
	{ 0x4874, 0x4f55 },
	{ 0x4875, 0x4f30 },
	{ 0x4876, 0x4f50 },
	{ 0x4877, 0x4f51 },
	{ 0x4878, 0x4f3d },
	{ 0x4879, 0x4f3a },
	{ 0x487a, 0x4f38 },
	{ 0x487b, 0x4f43 },
	{ 0x487c, 0x4f54 },
	{ 0x487d, 0x4f3c },
	{ 0x487e, 0x4f46 },
	{ 0x4921, 0x4f63 },
	{ 0x4922, 0x4f5c },
	{ 0x4923, 0x4f60 },
	{ 0x4924, 0x4f2f },
	{ 0x4925, 0x4f4e },
	{ 0x4926, 0x4f36 },
	{ 0x4927, 0x4f59 },
	{ 0x4928, 0x4f5d },
	{ 0x4929, 0x4f48 },
	{ 0x492a, 0x4f5a },
	{ 0x492b, 0x514c },
	{ 0x492c, 0x514b },
	{ 0x492d, 0x514d },
	{ 0x492e, 0x5175 },
	{ 0x492f, 0x51b6 },
	{ 0x4930, 0x51b7 },
	{ 0x4931, 0x5225 },
	{ 0x4932, 0x5224 },
	{ 0x4933, 0x5229 },
	{ 0x4934, 0x522a },
	{ 0x4935, 0x5228 },
	{ 0x4936, 0x52ab },
	{ 0x4937, 0x52a9 },
	{ 0x4938, 0x52aa },
	{ 0x4939, 0x52ac },
	{ 0x493a, 0x5323 },
	{ 0x493b, 0x5373 },
	{ 0x493c, 0x5375 },
	{ 0x493d, 0x541d },
	{ 0x493e, 0x542d },
	{ 0x493f, 0x541e },
	{ 0x4940, 0x543e },
	{ 0x4941, 0x5426 },
	{ 0x4942, 0x544e },
	{ 0x4943, 0x5427 },
	{ 0x4944, 0x5446 },
	{ 0x4945, 0x5443 },
	{ 0x4946, 0x5433 },
	{ 0x4947, 0x5448 },
	{ 0x4948, 0x5442 },
	{ 0x4949, 0x541b },
	{ 0x494a, 0x5429 },
	{ 0x494b, 0x544a },
	{ 0x494c, 0x5439 },
	{ 0x494d, 0x543b },
	{ 0x494e, 0x5438 },
	{ 0x494f, 0x542e },
	{ 0x4950, 0x5435 },
	{ 0x4951, 0x5436 },
	{ 0x4952, 0x5420 },
	{ 0x4953, 0x543c },
	{ 0x4954, 0x5440 },
	{ 0x4955, 0x5431 },
	{ 0x4956, 0x542b },
	{ 0x4957, 0x541f },
	{ 0x4958, 0x542c },
	{ 0x4959, 0x56ea },
	{ 0x495a, 0x56f0 },
	{ 0x495b, 0x56e4 },
	{ 0x495c, 0x56eb },
	{ 0x495d, 0x574a },
	{ 0x495e, 0x5751 },
	{ 0x495f, 0x5740 },
	{ 0x4960, 0x574d },
	{ 0x4961, 0x5747 },
	{ 0x4962, 0x574e },
	{ 0x4963, 0x573e },
	{ 0x4964, 0x5750 },
	{ 0x4965, 0x574f },
	{ 0x4966, 0x573b },
	{ 0x4967, 0x58ef },
	{ 0x4968, 0x593e },
	{ 0x4969, 0x599d },
	{ 0x496a, 0x5992 },
	{ 0x496b, 0x59a8 },
	{ 0x496c, 0x599e },
	{ 0x496d, 0x59a3 },
	{ 0x496e, 0x5999 },
	{ 0x496f, 0x5996 },
	{ 0x4970, 0x598d },
	{ 0x4971, 0x59a4 },
	{ 0x4972, 0x5993 },
	{ 0x4973, 0x598a },
	{ 0x4974, 0x59a5 },
	{ 0x4975, 0x5b5d },
	{ 0x4976, 0x5b5c },
	{ 0x4977, 0x5b5a },
	{ 0x4978, 0x5b5b },
	{ 0x4979, 0x5b8c },
	{ 0x497a, 0x5b8b },
	{ 0x497b, 0x5b8f },
	{ 0x497c, 0x5c2c },
	{ 0x497d, 0x5c40 },
	{ 0x497e, 0x5c41 },
	{ 0x4a21, 0x5c3f },
	{ 0x4a22, 0x5c3e },
	{ 0x4a23, 0x5c90 },
	{ 0x4a24, 0x5c91 },
	{ 0x4a25, 0x5c94 },
	{ 0x4a26, 0x5c8c },
	{ 0x4a27, 0x5deb },
	{ 0x4a28, 0x5e0c },
	{ 0x4a29, 0x5e8f },
	{ 0x4a2a, 0x5e87 },
	{ 0x4a2b, 0x5e8a },
	{ 0x4a2c, 0x5ef7 },
	{ 0x4a2d, 0x5f04 },
	{ 0x4a2e, 0x5f1f },
	{ 0x4a2f, 0x5f64 },
	{ 0x4a30, 0x5f62 },
	{ 0x4a31, 0x5f77 },
	{ 0x4a32, 0x5f79 },
	{ 0x4a33, 0x5fd8 },
	{ 0x4a34, 0x5fcc },
	{ 0x4a35, 0x5fd7 },
	{ 0x4a36, 0x5fcd },
	{ 0x4a37, 0x5ff1 },
	{ 0x4a38, 0x5feb },
	{ 0x4a39, 0x5ff8 },
	{ 0x4a3a, 0x5fea },
	{ 0x4a3b, 0x6212 },
	{ 0x4a3c, 0x6211 },
	{ 0x4a3d, 0x6284 },
	{ 0x4a3e, 0x6297 },
	{ 0x4a3f, 0x6296 },
	{ 0x4a40, 0x6280 },
	{ 0x4a41, 0x6276 },
	{ 0x4a42, 0x6289 },
	{ 0x4a43, 0x626d },
	{ 0x4a44, 0x628a },
	{ 0x4a45, 0x627c },
	{ 0x4a46, 0x627e },
	{ 0x4a47, 0x6279 },
	{ 0x4a48, 0x6273 },
	{ 0x4a49, 0x6292 },
	{ 0x4a4a, 0x626f },
	{ 0x4a4b, 0x6298 },
	{ 0x4a4c, 0x626e },
	{ 0x4a4d, 0x6295 },
	{ 0x4a4e, 0x6293 },
	{ 0x4a4f, 0x6291 },
	{ 0x4a50, 0x6286 },
	{ 0x4a51, 0x6539 },
	{ 0x4a52, 0x653b },
	{ 0x4a53, 0x6538 },
	{ 0x4a54, 0x65f1 },
	{ 0x4a55, 0x66f4 },
	{ 0x4a56, 0x675f },
	{ 0x4a57, 0x674e },
	{ 0x4a58, 0x674f },
	{ 0x4a59, 0x6750 },
	{ 0x4a5a, 0x6751 },
	{ 0x4a5b, 0x675c },
	{ 0x4a5c, 0x6756 },
	{ 0x4a5d, 0x675e },
	{ 0x4a5e, 0x6749 },
	{ 0x4a5f, 0x6746 },
	{ 0x4a60, 0x6760 },
	{ 0x4a61, 0x6753 },
	{ 0x4a62, 0x6757 },
	{ 0x4a63, 0x6b65 },
	{ 0x4a64, 0x6bcf },
	{ 0x4a65, 0x6c42 },
	{ 0x4a66, 0x6c5e },
	{ 0x4a67, 0x6c99 },
	{ 0x4a68, 0x6c81 },
	{ 0x4a69, 0x6c88 },
	{ 0x4a6a, 0x6c89 },
	{ 0x4a6b, 0x6c85 },
	{ 0x4a6c, 0x6c9b },
	{ 0x4a6d, 0x6c6a },
	{ 0x4a6e, 0x6c7a },
	{ 0x4a6f, 0x6c90 },
	{ 0x4a70, 0x6c70 },
	{ 0x4a71, 0x6c8c },
	{ 0x4a72, 0x6c68 },
	{ 0x4a73, 0x6c96 },
	{ 0x4a74, 0x6c92 },
	{ 0x4a75, 0x6c7d },
	{ 0x4a76, 0x6c83 },
	{ 0x4a77, 0x6c72 },
	{ 0x4a78, 0x6c7e },
	{ 0x4a79, 0x6c74 },
	{ 0x4a7a, 0x6c86 },
	{ 0x4a7b, 0x6c76 },
	{ 0x4a7c, 0x6c8d },
	{ 0x4a7d, 0x6c94 },
	{ 0x4a7e, 0x6c98 },
	{ 0x4b21, 0x6c82 },
	{ 0x4b22, 0x7076 },
	{ 0x4b23, 0x707c },
	{ 0x4b24, 0x707d },
	{ 0x4b25, 0x7078 },
	{ 0x4b26, 0x7262 },
	{ 0x4b27, 0x7261 },
	{ 0x4b28, 0x7260 },
	{ 0x4b29, 0x72c4 },
	{ 0x4b2a, 0x72c2 },
	{ 0x4b2b, 0x7396 },
	{ 0x4b2c, 0x752c },
	{ 0x4b2d, 0x752b },
	{ 0x4b2e, 0x7537 },
	{ 0x4b2f, 0x7538 },
	{ 0x4b30, 0x7682 },
	{ 0x4b31, 0x76ef },
	{ 0x4b32, 0x77e3 },
	{ 0x4b33, 0x79c1 },
	{ 0x4b34, 0x79c0 },
	{ 0x4b35, 0x79bf },
	{ 0x4b36, 0x7a76 },
	{ 0x4b37, 0x7cfb },
	{ 0x4b38, 0x7f55 },
	{ 0x4b39, 0x8096 },
	{ 0x4b3a, 0x8093 },
	{ 0x4b3b, 0x809d },
	{ 0x4b3c, 0x8098 },
	{ 0x4b3d, 0x809b },
	{ 0x4b3e, 0x809a },
	{ 0x4b3f, 0x80b2 },
	{ 0x4b40, 0x826f },
	{ 0x4b41, 0x8292 },
	{ 0x4b42, 0x828b },
	{ 0x4b43, 0x828d },
	{ 0x4b44, 0x898b },
	{ 0x4b45, 0x89d2 },
	{ 0x4b46, 0x8a00 },
	{ 0x4b47, 0x8c37 },
	{ 0x4b48, 0x8c46 },
	{ 0x4b49, 0x8c55 },
	{ 0x4b4a, 0x8c9d },
	{ 0x4b4b, 0x8d64 },
	{ 0x4b4c, 0x8d70 },
	{ 0x4b4d, 0x8db3 },
	{ 0x4b4e, 0x8eab },
	{ 0x4b4f, 0x8eca },
	{ 0x4b50, 0x8f9b },
	{ 0x4b51, 0x8fb0 },
	{ 0x4b52, 0x8fc2 },
	{ 0x4b53, 0x8fc6 },
	{ 0x4b54, 0x8fc5 },
	{ 0x4b55, 0x8fc4 },
	{ 0x4b56, 0x5de1 },
	{ 0x4b57, 0x9091 },
	{ 0x4b58, 0x90a2 },
	{ 0x4b59, 0x90aa },
	{ 0x4b5a, 0x90a6 },
	{ 0x4b5b, 0x90a3 },
	{ 0x4b5c, 0x9149 },
	{ 0x4b5d, 0x91c6 },
	{ 0x4b5e, 0x91cc },
	{ 0x4b5f, 0x9632 },
	{ 0x4b60, 0x962e },
	{ 0x4b61, 0x9631 },
	{ 0x4b62, 0x962a },
	{ 0x4b63, 0x962c },
	{ 0x4b64, 0x4e26 },
	{ 0x4b65, 0x4e56 },
	{ 0x4b66, 0x4e73 },
	{ 0x4b67, 0x4e8b },
	{ 0x4b68, 0x4e9b },
	{ 0x4b69, 0x4e9e },
	{ 0x4b6a, 0x4eab },
	{ 0x4b6b, 0x4eac },
	{ 0x4b6c, 0x4f6f },
	{ 0x4b6d, 0x4f9d },
	{ 0x4b6e, 0x4f8d },
	{ 0x4b6f, 0x4f73 },
	{ 0x4b70, 0x4f7f },
	{ 0x4b71, 0x4f6c },
	{ 0x4b72, 0x4f9b },
	{ 0x4b73, 0x4f8b },
	{ 0x4b74, 0x4f86 },
	{ 0x4b75, 0x4f83 },
	{ 0x4b76, 0x4f70 },
	{ 0x4b77, 0x4f75 },
	{ 0x4b78, 0x4f88 },
	{ 0x4b79, 0x4f69 },
	{ 0x4b7a, 0x4f7b },
	{ 0x4b7b, 0x4f96 },
	{ 0x4b7c, 0x4f7e },
	{ 0x4b7d, 0x4f8f },
	{ 0x4b7e, 0x4f91 },
	{ 0x4c21, 0x4f7a },
	{ 0x4c22, 0x5154 },
	{ 0x4c23, 0x5152 },
	{ 0x4c24, 0x5155 },
	{ 0x4c25, 0x5169 },
	{ 0x4c26, 0x5177 },
	{ 0x4c27, 0x5176 },
	{ 0x4c28, 0x5178 },
	{ 0x4c29, 0x51bd },
	{ 0x4c2a, 0x51fd },
	{ 0x4c2b, 0x523b },
	{ 0x4c2c, 0x5238 },
	{ 0x4c2d, 0x5237 },
	{ 0x4c2e, 0x523a },
	{ 0x4c2f, 0x5230 },
	{ 0x4c30, 0x522e },
	{ 0x4c31, 0x5236 },
	{ 0x4c32, 0x5241 },
	{ 0x4c33, 0x52be },
	{ 0x4c34, 0x52bb },
	{ 0x4c35, 0x5352 },
	{ 0x4c36, 0x5354 },
	{ 0x4c37, 0x5353 },
	{ 0x4c38, 0x5351 },
	{ 0x4c39, 0x5366 },
	{ 0x4c3a, 0x5377 },
	{ 0x4c3b, 0x5378 },
	{ 0x4c3c, 0x5379 },
	{ 0x4c3d, 0x53d6 },
	{ 0x4c3e, 0x53d4 },
	{ 0x4c3f, 0x53d7 },
	{ 0x4c40, 0x5473 },
	{ 0x4c41, 0x5475 },
	{ 0x4c42, 0x5496 },
	{ 0x4c43, 0x5478 },
	{ 0x4c44, 0x5495 },
	{ 0x4c45, 0x5480 },
	{ 0x4c46, 0x547b },
	{ 0x4c47, 0x5477 },
	{ 0x4c48, 0x5484 },
	{ 0x4c49, 0x5492 },
	{ 0x4c4a, 0x5486 },
	{ 0x4c4b, 0x547c },
	{ 0x4c4c, 0x5490 },
	{ 0x4c4d, 0x5471 },
	{ 0x4c4e, 0x5476 },
	{ 0x4c4f, 0x548c },
	{ 0x4c50, 0x549a },
	{ 0x4c51, 0x5462 },
	{ 0x4c52, 0x5468 },
	{ 0x4c53, 0x548b },
	{ 0x4c54, 0x547d },
	{ 0x4c55, 0x548e },
	{ 0x4c56, 0x56fa },
	{ 0x4c57, 0x5783 },
	{ 0x4c58, 0x5777 },
	{ 0x4c59, 0x576a },
	{ 0x4c5a, 0x5769 },
	{ 0x4c5b, 0x5761 },
	{ 0x4c5c, 0x5766 },
	{ 0x4c5d, 0x5764 },
	{ 0x4c5e, 0x577c },
	{ 0x4c5f, 0x591c },
	{ 0x4c60, 0x5949 },
	{ 0x4c61, 0x5947 },
	{ 0x4c62, 0x5948 },
	{ 0x4c63, 0x5944 },
	{ 0x4c64, 0x5954 },
	{ 0x4c65, 0x59be },
	{ 0x4c66, 0x59bb },
	{ 0x4c67, 0x59d4 },
	{ 0x4c68, 0x59b9 },
	{ 0x4c69, 0x59ae },
	{ 0x4c6a, 0x59d1 },
	{ 0x4c6b, 0x59c6 },
	{ 0x4c6c, 0x59d0 },
	{ 0x4c6d, 0x59cd },
	{ 0x4c6e, 0x59cb },
	{ 0x4c6f, 0x59d3 },
	{ 0x4c70, 0x59ca },
	{ 0x4c71, 0x59af },
	{ 0x4c72, 0x59b3 },
	{ 0x4c73, 0x59d2 },
	{ 0x4c74, 0x59c5 },
	{ 0x4c75, 0x5b5f },
	{ 0x4c76, 0x5b64 },
	{ 0x4c77, 0x5b63 },
	{ 0x4c78, 0x5b97 },
	{ 0x4c79, 0x5b9a },
	{ 0x4c7a, 0x5b98 },
	{ 0x4c7b, 0x5b9c },
	{ 0x4c7c, 0x5b99 },
	{ 0x4c7d, 0x5b9b },
	{ 0x4c7e, 0x5c1a },
	{ 0x4d21, 0x5c48 },
	{ 0x4d22, 0x5c45 },
	{ 0x4d23, 0x5c46 },
	{ 0x4d24, 0x5cb7 },
	{ 0x4d25, 0x5ca1 },
	{ 0x4d26, 0x5cb8 },
	{ 0x4d27, 0x5ca9 },
	{ 0x4d28, 0x5cab },
	{ 0x4d29, 0x5cb1 },
	{ 0x4d2a, 0x5cb3 },
	{ 0x4d2b, 0x5e18 },
	{ 0x4d2c, 0x5e1a },
	{ 0x4d2d, 0x5e16 },
	{ 0x4d2e, 0x5e15 },
	{ 0x4d2f, 0x5e1b },
	{ 0x4d30, 0x5e11 },
	{ 0x4d31, 0x5e78 },
	{ 0x4d32, 0x5e9a },
	{ 0x4d33, 0x5e97 },
	{ 0x4d34, 0x5e9c },
	{ 0x4d35, 0x5e95 },
	{ 0x4d36, 0x5e96 },
	{ 0x4d37, 0x5ef6 },
	{ 0x4d38, 0x5f26 },
	{ 0x4d39, 0x5f27 },
	{ 0x4d3a, 0x5f29 },
	{ 0x4d3b, 0x5f80 },
	{ 0x4d3c, 0x5f81 },
	{ 0x4d3d, 0x5f7f },
	{ 0x4d3e, 0x5f7c },
	{ 0x4d3f, 0x5fdd },
	{ 0x4d40, 0x5fe0 },
	{ 0x4d41, 0x5ffd },
	{ 0x4d42, 0x5ff5 },
	{ 0x4d43, 0x5fff },
	{ 0x4d44, 0x600f },
	{ 0x4d45, 0x6014 },
	{ 0x4d46, 0x602f },
	{ 0x4d47, 0x6035 },
	{ 0x4d48, 0x6016 },
	{ 0x4d49, 0x602a },
	{ 0x4d4a, 0x6015 },
	{ 0x4d4b, 0x6021 },
	{ 0x4d4c, 0x6027 },
	{ 0x4d4d, 0x6029 },
	{ 0x4d4e, 0x602b },
	{ 0x4d4f, 0x601b },
	{ 0x4d50, 0x6216 },
	{ 0x4d51, 0x6215 },
	{ 0x4d52, 0x623f },
	{ 0x4d53, 0x623e },
	{ 0x4d54, 0x6240 },
	{ 0x4d55, 0x627f },
	{ 0x4d56, 0x62c9 },
	{ 0x4d57, 0x62cc },
	{ 0x4d58, 0x62c4 },
	{ 0x4d59, 0x62bf },
	{ 0x4d5a, 0x62c2 },
	{ 0x4d5b, 0x62b9 },
	{ 0x4d5c, 0x62d2 },
	{ 0x4d5d, 0x62db },
	{ 0x4d5e, 0x62ab },
	{ 0x4d5f, 0x62d3 },
	{ 0x4d60, 0x62d4 },
	{ 0x4d61, 0x62cb },
	{ 0x4d62, 0x62c8 },
	{ 0x4d63, 0x62a8 },
	{ 0x4d64, 0x62bd },
	{ 0x4d65, 0x62bc },
	{ 0x4d66, 0x62d0 },
	{ 0x4d67, 0x62d9 },
	{ 0x4d68, 0x62c7 },
	{ 0x4d69, 0x62cd },
	{ 0x4d6a, 0x62b5 },
	{ 0x4d6b, 0x62da },
	{ 0x4d6c, 0x62b1 },
	{ 0x4d6d, 0x62d8 },
	{ 0x4d6e, 0x62d6 },
	{ 0x4d6f, 0x62d7 },
	{ 0x4d70, 0x62c6 },
	{ 0x4d71, 0x62ac },
	{ 0x4d72, 0x62ce },
	{ 0x4d73, 0x653e },
	{ 0x4d74, 0x65a7 },
	{ 0x4d75, 0x65bc },
	{ 0x4d76, 0x65fa },
	{ 0x4d77, 0x6614 },
	{ 0x4d78, 0x6613 },
	{ 0x4d79, 0x660c },
	{ 0x4d7a, 0x6606 },
	{ 0x4d7b, 0x6602 },
	{ 0x4d7c, 0x660e },
	{ 0x4d7d, 0x6600 },
	{ 0x4d7e, 0x660f },
	{ 0x4e21, 0x6615 },
	{ 0x4e22, 0x660a },
	{ 0x4e23, 0x6607 },
	{ 0x4e24, 0x670d },
	{ 0x4e25, 0x670b },
	{ 0x4e26, 0x676d },
	{ 0x4e27, 0x678b },
	{ 0x4e28, 0x6795 },
	{ 0x4e29, 0x6771 },
	{ 0x4e2a, 0x679c },
	{ 0x4e2b, 0x6773 },
	{ 0x4e2c, 0x6777 },
	{ 0x4e2d, 0x6787 },
	{ 0x4e2e, 0x679d },
	{ 0x4e2f, 0x6797 },
	{ 0x4e30, 0x676f },
	{ 0x4e31, 0x6770 },
	{ 0x4e32, 0x677f },
	{ 0x4e33, 0x6789 },
	{ 0x4e34, 0x677e },
	{ 0x4e35, 0x6790 },
	{ 0x4e36, 0x6775 },
	{ 0x4e37, 0x679a },
	{ 0x4e38, 0x6793 },
	{ 0x4e39, 0x677c },
	{ 0x4e3a, 0x676a },
	{ 0x4e3b, 0x6772 },
	{ 0x4e3c, 0x6b23 },
	{ 0x4e3d, 0x6b66 },
	{ 0x4e3e, 0x6b67 },
	{ 0x4e3f, 0x6b7f },
	{ 0x4e40, 0x6c13 },
	{ 0x4e41, 0x6c1b },
	{ 0x4e42, 0x6ce3 },
	{ 0x4e43, 0x6ce8 },
	{ 0x4e44, 0x6cf3 },
	{ 0x4e45, 0x6cb1 },
	{ 0x4e46, 0x6ccc },
	{ 0x4e47, 0x6ce5 },
	{ 0x4e48, 0x6cb3 },
	{ 0x4e49, 0x6cbd },
	{ 0x4e4a, 0x6cbe },
	{ 0x4e4b, 0x6cbc },
	{ 0x4e4c, 0x6ce2 },
	{ 0x4e4d, 0x6cab },
	{ 0x4e4e, 0x6cd5 },
	{ 0x4e4f, 0x6cd3 },
	{ 0x4e50, 0x6cb8 },
	{ 0x4e51, 0x6cc4 },
	{ 0x4e52, 0x6cb9 },
	{ 0x4e53, 0x6cc1 },
	{ 0x4e54, 0x6cae },
	{ 0x4e55, 0x6cd7 },
	{ 0x4e56, 0x6cc5 },
	{ 0x4e57, 0x6cf1 },
	{ 0x4e58, 0x6cbf },
	{ 0x4e59, 0x6cbb },
	{ 0x4e5a, 0x6ce1 },
	{ 0x4e5b, 0x6cdb },
	{ 0x4e5c, 0x6cca },
	{ 0x4e5d, 0x6cac },
	{ 0x4e5e, 0x6cef },
	{ 0x4e5f, 0x6cdc },
	{ 0x4e60, 0x6cd6 },
	{ 0x4e61, 0x6ce0 },
	{ 0x4e62, 0x7095 },
	{ 0x4e63, 0x708e },
	{ 0x4e64, 0x7092 },
	{ 0x4e65, 0x708a },
	{ 0x4e66, 0x7099 },
	{ 0x4e67, 0x722c },
	{ 0x4e68, 0x722d },
	{ 0x4e69, 0x7238 },
	{ 0x4e6a, 0x7248 },
	{ 0x4e6b, 0x7267 },
	{ 0x4e6c, 0x7269 },
	{ 0x4e6d, 0x72c0 },
	{ 0x4e6e, 0x72ce },
	{ 0x4e6f, 0x72d9 },
	{ 0x4e70, 0x72d7 },
	{ 0x4e71, 0x72d0 },
	{ 0x4e72, 0x73a9 },
	{ 0x4e73, 0x73a8 },
	{ 0x4e74, 0x739f },
	{ 0x4e75, 0x73ab },
	{ 0x4e76, 0x73a5 },
	{ 0x4e77, 0x753d },
	{ 0x4e78, 0x759d },
	{ 0x4e79, 0x7599 },
	{ 0x4e7a, 0x759a },
	{ 0x4e7b, 0x7684 },
	{ 0x4e7c, 0x76c2 },
	{ 0x4e7d, 0x76f2 },
	{ 0x4e7e, 0x76f4 },
	{ 0x4f21, 0x77e5 },
	{ 0x4f22, 0x77fd },
	{ 0x4f23, 0x793e },
	{ 0x4f24, 0x7940 },
	{ 0x4f25, 0x7941 },
	{ 0x4f26, 0x79c9 },
	{ 0x4f27, 0x79c8 },
	{ 0x4f28, 0x7a7a },
	{ 0x4f29, 0x7a79 },
	{ 0x4f2a, 0x7afa },
	{ 0x4f2b, 0x7cfe },
	{ 0x4f2c, 0x7f54 },
	{ 0x4f2d, 0x7f8c },
	{ 0x4f2e, 0x7f8b },
	{ 0x4f2f, 0x8005 },
	{ 0x4f30, 0x80ba },
	{ 0x4f31, 0x80a5 },
	{ 0x4f32, 0x80a2 },
	{ 0x4f33, 0x80b1 },
	{ 0x4f34, 0x80a1 },
	{ 0x4f35, 0x80ab },
	{ 0x4f36, 0x80a9 },
	{ 0x4f37, 0x80b4 },
	{ 0x4f38, 0x80aa },
	{ 0x4f39, 0x80af },
	{ 0x4f3a, 0x81e5 },
	{ 0x4f3b, 0x81fe },
	{ 0x4f3c, 0x820d },
	{ 0x4f3d, 0x82b3 },
	{ 0x4f3e, 0x829d },
	{ 0x4f3f, 0x8299 },
	{ 0x4f40, 0x82ad },
	{ 0x4f41, 0x82bd },
	{ 0x4f42, 0x829f },
	{ 0x4f43, 0x82b9 },
	{ 0x4f44, 0x82b1 },
	{ 0x4f45, 0x82ac },
	{ 0x4f46, 0x82a5 },
	{ 0x4f47, 0x82af },
	{ 0x4f48, 0x82b8 },
	{ 0x4f49, 0x82a3 },
	{ 0x4f4a, 0x82b0 },
	{ 0x4f4b, 0x82be },
	{ 0x4f4c, 0x82b7 },
	{ 0x4f4d, 0x864e },
	{ 0x4f4e, 0x8671 },
	{ 0x4f4f, 0x521d },
	{ 0x4f50, 0x8868 },
	{ 0x4f51, 0x8ecb },
	{ 0x4f52, 0x8fce },
	{ 0x4f53, 0x8fd4 },
	{ 0x4f54, 0x8fd1 },
	{ 0x4f55, 0x90b5 },
	{ 0x4f56, 0x90b8 },
	{ 0x4f57, 0x90b1 },
	{ 0x4f58, 0x90b6 },
	{ 0x4f59, 0x91c7 },
	{ 0x4f5a, 0x91d1 },
	{ 0x4f5b, 0x9577 },
	{ 0x4f5c, 0x9580 },
	{ 0x4f5d, 0x961c },
	{ 0x4f5e, 0x9640 },
	{ 0x4f5f, 0x963f },
	{ 0x4f60, 0x963b },
	{ 0x4f61, 0x9644 },
	{ 0x4f62, 0x9642 },
	{ 0x4f63, 0x96b9 },
	{ 0x4f64, 0x96e8 },
	{ 0x4f65, 0x9752 },
	{ 0x4f66, 0x975e },
	{ 0x4f67, 0x4e9f },
	{ 0x4f68, 0x4ead },
	{ 0x4f69, 0x4eae },
	{ 0x4f6a, 0x4fe1 },
	{ 0x4f6b, 0x4fb5 },
	{ 0x4f6c, 0x4faf },
	{ 0x4f6d, 0x4fbf },
	{ 0x4f6e, 0x4fe0 },
	{ 0x4f6f, 0x4fd1 },
	{ 0x4f70, 0x4fcf },
	{ 0x4f71, 0x4fdd },
	{ 0x4f72, 0x4fc3 },
	{ 0x4f73, 0x4fb6 },
	{ 0x4f74, 0x4fd8 },
	{ 0x4f75, 0x4fdf },
	{ 0x4f76, 0x4fca },
	{ 0x4f77, 0x4fd7 },
	{ 0x4f78, 0x4fae },
	{ 0x4f79, 0x4fd0 },
	{ 0x4f7a, 0x4fc4 },
	{ 0x4f7b, 0x4fc2 },
	{ 0x4f7c, 0x4fda },
	{ 0x4f7d, 0x4fce },
	{ 0x4f7e, 0x4fde },
	{ 0x5021, 0x4fb7 },
	{ 0x5022, 0x5157 },
	{ 0x5023, 0x5192 },
	{ 0x5024, 0x5191 },
	{ 0x5025, 0x51a0 },
	{ 0x5026, 0x524e },
	{ 0x5027, 0x5243 },
	{ 0x5028, 0x524a },
	{ 0x5029, 0x524d },
	{ 0x502a, 0x524c },
	{ 0x502b, 0x524b },
	{ 0x502c, 0x5247 },
	{ 0x502d, 0x52c7 },
	{ 0x502e, 0x52c9 },
	{ 0x502f, 0x52c3 },
	{ 0x5030, 0x52c1 },
	{ 0x5031, 0x530d },
	{ 0x5032, 0x5357 },
	{ 0x5033, 0x537b },
	{ 0x5034, 0x539a },
	{ 0x5035, 0x53db },
	{ 0x5036, 0x54ac },
	{ 0x5037, 0x54c0 },
	{ 0x5038, 0x54a8 },
	{ 0x5039, 0x54ce },
	{ 0x503a, 0x54c9 },
	{ 0x503b, 0x54b8 },
	{ 0x503c, 0x54a6 },
	{ 0x503d, 0x54b3 },
	{ 0x503e, 0x54c7 },
	{ 0x503f, 0x54c2 },
	{ 0x5040, 0x54bd },
	{ 0x5041, 0x54aa },
	{ 0x5042, 0x54c1 },
	{ 0x5043, 0x54c4 },
	{ 0x5044, 0x54c8 },
	{ 0x5045, 0x54af },
	{ 0x5046, 0x54ab },
	{ 0x5047, 0x54b1 },
	{ 0x5048, 0x54bb },
	{ 0x5049, 0x54a9 },
	{ 0x504a, 0x54a7 },
	{ 0x504b, 0x54bf },
	{ 0x504c, 0x56ff },
	{ 0x504d, 0x5782 },
	{ 0x504e, 0x578b },
	{ 0x504f, 0x57a0 },
	{ 0x5050, 0x57a3 },
	{ 0x5051, 0x57a2 },
	{ 0x5052, 0x57ce },
	{ 0x5053, 0x57ae },
	{ 0x5054, 0x5793 },
	{ 0x5055, 0x5955 },
	{ 0x5056, 0x5951 },
	{ 0x5057, 0x594f },
	{ 0x5058, 0x594e },
	{ 0x5059, 0x5950 },
	{ 0x505a, 0x59dc },
	{ 0x505b, 0x59d8 },
	{ 0x505c, 0x59ff },
	{ 0x505d, 0x59e3 },
	{ 0x505e, 0x59e8 },
	{ 0x505f, 0x5a03 },
	{ 0x5060, 0x59e5 },
	{ 0x5061, 0x59ea },
	{ 0x5062, 0x59da },
	{ 0x5063, 0x59e6 },
	{ 0x5064, 0x5a01 },
	{ 0x5065, 0x59fb },
	{ 0x5066, 0x5b69 },
	{ 0x5067, 0x5ba3 },
	{ 0x5068, 0x5ba6 },
	{ 0x5069, 0x5ba4 },
	{ 0x506a, 0x5ba2 },
	{ 0x506b, 0x5ba5 },
	{ 0x506c, 0x5c01 },
	{ 0x506d, 0x5c4e },
	{ 0x506e, 0x5c4f },
	{ 0x506f, 0x5c4d },
	{ 0x5070, 0x5c4b },
	{ 0x5071, 0x5cd9 },
	{ 0x5072, 0x5cd2 },
	{ 0x5073, 0x5df7 },
	{ 0x5074, 0x5e1d },
	{ 0x5075, 0x5e25 },
	{ 0x5076, 0x5e1f },
	{ 0x5077, 0x5e7d },
	{ 0x5078, 0x5ea0 },
	{ 0x5079, 0x5ea6 },
	{ 0x507a, 0x5efa },
	{ 0x507b, 0x5f08 },
	{ 0x507c, 0x5f2d },
	{ 0x507d, 0x5f65 },
	{ 0x507e, 0x5f88 },
	{ 0x5121, 0x5f85 },
	{ 0x5122, 0x5f8a },
	{ 0x5123, 0x5f8b },
	{ 0x5124, 0x5f87 },
	{ 0x5125, 0x5f8c },
	{ 0x5126, 0x5f89 },
	{ 0x5127, 0x6012 },
	{ 0x5128, 0x601d },
	{ 0x5129, 0x6020 },
	{ 0x512a, 0x6025 },
	{ 0x512b, 0x600e },
	{ 0x512c, 0x6028 },
	{ 0x512d, 0x604d },
	{ 0x512e, 0x6070 },
	{ 0x512f, 0x6068 },
	{ 0x5130, 0x6062 },
	{ 0x5131, 0x6046 },
	{ 0x5132, 0x6043 },
	{ 0x5133, 0x606c },
	{ 0x5134, 0x606b },
	{ 0x5135, 0x606a },
	{ 0x5136, 0x6064 },
	{ 0x5137, 0x6241 },
	{ 0x5138, 0x62dc },
	{ 0x5139, 0x6316 },
	{ 0x513a, 0x6309 },
	{ 0x513b, 0x62fc },
	{ 0x513c, 0x62ed },
	{ 0x513d, 0x6301 },
	{ 0x513e, 0x62ee },
	{ 0x513f, 0x62fd },
	{ 0x5140, 0x6307 },
	{ 0x5141, 0x62f1 },
	{ 0x5142, 0x62f7 },
	{ 0x5143, 0x62ef },
	{ 0x5144, 0x62ec },
	{ 0x5145, 0x62fe },
	{ 0x5146, 0x62f4 },
	{ 0x5147, 0x6311 },
	{ 0x5148, 0x6302 },
	{ 0x5149, 0x653f },
	{ 0x514a, 0x6545 },
	{ 0x514b, 0x65ab },
	{ 0x514c, 0x65bd },
	{ 0x514d, 0x65e2 },
	{ 0x514e, 0x6625 },
	{ 0x514f, 0x662d },
	{ 0x5150, 0x6620 },
	{ 0x5151, 0x6627 },
	{ 0x5152, 0x662f },
	{ 0x5153, 0x661f },
	{ 0x5154, 0x6628 },
	{ 0x5155, 0x6631 },
	{ 0x5156, 0x6624 },
	{ 0x5157, 0x66f7 },
	{ 0x5158, 0x67ff },
	{ 0x5159, 0x67d3 },
	{ 0x515a, 0x67f1 },
	{ 0x515b, 0x67d4 },
	{ 0x515c, 0x67d0 },
	{ 0x515d, 0x67ec },
	{ 0x515e, 0x67b6 },
	{ 0x515f, 0x67af },
	{ 0x5160, 0x67f5 },
	{ 0x5161, 0x67e9 },
	{ 0x5162, 0x67ef },
	{ 0x5163, 0x67c4 },
	{ 0x5164, 0x67d1 },
	{ 0x5165, 0x67b4 },
	{ 0x5166, 0x67da },
	{ 0x5167, 0x67e5 },
	{ 0x5168, 0x67b8 },
	{ 0x5169, 0x67cf },
	{ 0x516a, 0x67de },
	{ 0x516b, 0x67f3 },
	{ 0x516c, 0x67b0 },
	{ 0x516d, 0x67d9 },
	{ 0x516e, 0x67e2 },
	{ 0x516f, 0x67dd },
	{ 0x5170, 0x67d2 },
	{ 0x5171, 0x6b6a },
	{ 0x5172, 0x6b83 },
	{ 0x5173, 0x6b86 },
	{ 0x5174, 0x6bb5 },
	{ 0x5175, 0x6bd2 },
	{ 0x5176, 0x6bd7 },
	{ 0x5177, 0x6c1f },
	{ 0x5178, 0x6cc9 },
	{ 0x5179, 0x6d0b },
	{ 0x517a, 0x6d32 },
	{ 0x517b, 0x6d2a },
	{ 0x517c, 0x6d41 },
	{ 0x517d, 0x6d25 },
	{ 0x517e, 0x6d0c },
	{ 0x5221, 0x6d31 },
	{ 0x5222, 0x6d1e },
	{ 0x5223, 0x6d17 },
	{ 0x5224, 0x6d3b },
	{ 0x5225, 0x6d3d },
	{ 0x5226, 0x6d3e },
	{ 0x5227, 0x6d36 },
	{ 0x5228, 0x6d1b },
	{ 0x5229, 0x6cf5 },
	{ 0x522a, 0x6d39 },
	{ 0x522b, 0x6d27 },
	{ 0x522c, 0x6d38 },
	{ 0x522d, 0x6d29 },
	{ 0x522e, 0x6d2e },
	{ 0x522f, 0x6d35 },
	{ 0x5230, 0x6d0e },
	{ 0x5231, 0x6d2b },
	{ 0x5232, 0x70ab },
	{ 0x5233, 0x70ba },
	{ 0x5234, 0x70b3 },
	{ 0x5235, 0x70ac },
	{ 0x5236, 0x70af },
	{ 0x5237, 0x70ad },
	{ 0x5238, 0x70b8 },
	{ 0x5239, 0x70ae },
	{ 0x523a, 0x70a4 },
	{ 0x523b, 0x7230 },
	{ 0x523c, 0x7272 },
	{ 0x523d, 0x726f },
	{ 0x523e, 0x7274 },
	{ 0x523f, 0x72e9 },
	{ 0x5240, 0x72e0 },
	{ 0x5241, 0x72e1 },
	{ 0x5242, 0x73b7 },
	{ 0x5243, 0x73ca },
	{ 0x5244, 0x73bb },
	{ 0x5245, 0x73b2 },
	{ 0x5246, 0x73cd },
	{ 0x5247, 0x73c0 },
	{ 0x5248, 0x73b3 },
	{ 0x5249, 0x751a },
	{ 0x524a, 0x752d },
	{ 0x524b, 0x754f },
	{ 0x524c, 0x754c },
	{ 0x524d, 0x754e },
	{ 0x524e, 0x754b },
	{ 0x524f, 0x75ab },
	{ 0x5250, 0x75a4 },
	{ 0x5251, 0x75a5 },
	{ 0x5252, 0x75a2 },
	{ 0x5253, 0x75a3 },
	{ 0x5254, 0x7678 },
	{ 0x5255, 0x7686 },
	{ 0x5256, 0x7687 },
	{ 0x5257, 0x7688 },
	{ 0x5258, 0x76c8 },
	{ 0x5259, 0x76c6 },
	{ 0x525a, 0x76c3 },
	{ 0x525b, 0x76c5 },
	{ 0x525c, 0x7701 },
	{ 0x525d, 0x76f9 },
	{ 0x525e, 0x76f8 },
	{ 0x525f, 0x7709 },
	{ 0x5260, 0x770b },
	{ 0x5261, 0x76fe },
	{ 0x5262, 0x76fc },
	{ 0x5263, 0x7707 },
	{ 0x5264, 0x77dc },
	{ 0x5265, 0x7802 },
	{ 0x5266, 0x7814 },
	{ 0x5267, 0x780c },
	{ 0x5268, 0x780d },
	{ 0x5269, 0x7946 },
	{ 0x526a, 0x7949 },
	{ 0x526b, 0x7948 },
	{ 0x526c, 0x7947 },
	{ 0x526d, 0x79b9 },
	{ 0x526e, 0x79ba },
	{ 0x526f, 0x79d1 },
	{ 0x5270, 0x79d2 },
	{ 0x5271, 0x79cb },
	{ 0x5272, 0x7a7f },
	{ 0x5273, 0x7a81 },
	{ 0x5274, 0x7aff },
	{ 0x5275, 0x7afd },
	{ 0x5276, 0x7c7d },
	{ 0x5277, 0x7d02 },
	{ 0x5278, 0x7d05 },
	{ 0x5279, 0x7d00 },
	{ 0x527a, 0x7d09 },
	{ 0x527b, 0x7d07 },
	{ 0x527c, 0x7d04 },
	{ 0x527d, 0x7d06 },
	{ 0x527e, 0x7f38 },
	{ 0x5321, 0x7f8e },
	{ 0x5322, 0x7fbf },
	{ 0x5323, 0x8010 },
	{ 0x5324, 0x800d },
	{ 0x5325, 0x8011 },
	{ 0x5326, 0x8036 },
	{ 0x5327, 0x80d6 },
	{ 0x5328, 0x80e5 },
	{ 0x5329, 0x80da },
	{ 0x532a, 0x80c3 },
	{ 0x532b, 0x80c4 },
	{ 0x532c, 0x80cc },
	{ 0x532d, 0x80e1 },
	{ 0x532e, 0x80db },
	{ 0x532f, 0x80ce },
	{ 0x5330, 0x80de },
	{ 0x5331, 0x80e4 },
	{ 0x5332, 0x80dd },
	{ 0x5333, 0x81f4 },
	{ 0x5334, 0x8222 },
	{ 0x5335, 0x82e7 },
	{ 0x5336, 0x8303 },
	{ 0x5337, 0x8305 },
	{ 0x5338, 0x82e3 },
	{ 0x5339, 0x82db },
	{ 0x533a, 0x82e6 },
	{ 0x533b, 0x8304 },
	{ 0x533c, 0x82e5 },
	{ 0x533d, 0x8302 },
	{ 0x533e, 0x8309 },
	{ 0x533f, 0x82d2 },
	{ 0x5340, 0x82d7 },
	{ 0x5341, 0x82f1 },
	{ 0x5342, 0x8301 },
	{ 0x5343, 0x82dc },
	{ 0x5344, 0x82d4 },
	{ 0x5345, 0x82d1 },
	{ 0x5346, 0x82de },
	{ 0x5347, 0x82d3 },
	{ 0x5348, 0x82df },
	{ 0x5349, 0x82ef },
	{ 0x534a, 0x8306 },
	{ 0x534b, 0x8650 },
	{ 0x534c, 0x8679 },
	{ 0x534d, 0x867b },
	{ 0x534e, 0x867a },
	{ 0x534f, 0x884d },
	{ 0x5350, 0x886b },
	{ 0x5351, 0x8981 },
	{ 0x5352, 0x89d4 },
	{ 0x5353, 0x8a08 },
	{ 0x5354, 0x8a02 },
	{ 0x5355, 0x8a03 },
	{ 0x5356, 0x8c9e },
	{ 0x5357, 0x8ca0 },
	{ 0x5358, 0x8d74 },
	{ 0x5359, 0x8d73 },
	{ 0x535a, 0x8db4 },
	{ 0x535b, 0x8ecd },
	{ 0x535c, 0x8ecc },
	{ 0x535d, 0x8ff0 },
	{ 0x535e, 0x8fe6 },
	{ 0x535f, 0x8fe2 },
	{ 0x5360, 0x8fea },
	{ 0x5361, 0x8fe5 },
	{ 0x5362, 0x8fed },
	{ 0x5363, 0x8feb },
	{ 0x5364, 0x8fe4 },
	{ 0x5365, 0x8fe8 },
	{ 0x5366, 0x90ca },
	{ 0x5367, 0x90ce },
	{ 0x5368, 0x90c1 },
	{ 0x5369, 0x90c3 },
	{ 0x536a, 0x914b },
	{ 0x536b, 0x914a },
	{ 0x536c, 0x91cd },
	{ 0x536d, 0x9582 },
	{ 0x536e, 0x9650 },
	{ 0x536f, 0x964b },
	{ 0x5370, 0x964c },
	{ 0x5371, 0x964d },
	{ 0x5372, 0x9762 },
	{ 0x5373, 0x9769 },
	{ 0x5374, 0x97cb },
	{ 0x5375, 0x97ed },
	{ 0x5376, 0x97f3 },
	{ 0x5377, 0x9801 },
	{ 0x5378, 0x98a8 },
	{ 0x5379, 0x98db },
	{ 0x537a, 0x98df },
	{ 0x537b, 0x9996 },
	{ 0x537c, 0x9999 },
	{ 0x537d, 0x4e58 },
	{ 0x537e, 0x4eb3 },
	{ 0x5421, 0x500c },
	{ 0x5422, 0x500d },
	{ 0x5423, 0x5023 },
	{ 0x5424, 0x4fef },
	{ 0x5425, 0x5026 },
	{ 0x5426, 0x5025 },
	{ 0x5427, 0x4ff8 },
	{ 0x5428, 0x5029 },
	{ 0x5429, 0x5016 },
	{ 0x542a, 0x5006 },
	{ 0x542b, 0x503c },
	{ 0x542c, 0x501f },
	{ 0x542d, 0x501a },
	{ 0x542e, 0x5012 },
	{ 0x542f, 0x5011 },
	{ 0x5430, 0x4ffa },
	{ 0x5431, 0x5000 },
	{ 0x5432, 0x5014 },
	{ 0x5433, 0x5028 },
	{ 0x5434, 0x4ff1 },
	{ 0x5435, 0x5021 },
	{ 0x5436, 0x500b },
	{ 0x5437, 0x5019 },
	{ 0x5438, 0x5018 },
	{ 0x5439, 0x4ff3 },
	{ 0x543a, 0x4fee },
	{ 0x543b, 0x502d },
	{ 0x543c, 0x502a },
	{ 0x543d, 0x4ffe },
	{ 0x543e, 0x502b },
	{ 0x543f, 0x5009 },
	{ 0x5440, 0x517c },
	{ 0x5441, 0x51a4 },
	{ 0x5442, 0x51a5 },
	{ 0x5443, 0x51a2 },
	{ 0x5444, 0x51cd },
	{ 0x5445, 0x51cc },
	{ 0x5446, 0x51c6 },
	{ 0x5447, 0x51cb },
	{ 0x5448, 0x5256 },
	{ 0x5449, 0x525c },
	{ 0x544a, 0x5254 },
	{ 0x544b, 0x525b },
	{ 0x544c, 0x525d },
	{ 0x544d, 0x532a },
	{ 0x544e, 0x537f },
	{ 0x544f, 0x539f },
	{ 0x5450, 0x539d },
	{ 0x5451, 0x53df },
	{ 0x5452, 0x54e8 },
	{ 0x5453, 0x5510 },
	{ 0x5454, 0x5501 },
	{ 0x5455, 0x5537 },
	{ 0x5456, 0x54fc },
	{ 0x5457, 0x54e5 },
	{ 0x5458, 0x54f2 },
	{ 0x5459, 0x5506 },
	{ 0x545a, 0x54fa },
	{ 0x545b, 0x5514 },
	{ 0x545c, 0x54e9 },
	{ 0x545d, 0x54ed },
	{ 0x545e, 0x54e1 },
	{ 0x545f, 0x5509 },
	{ 0x5460, 0x54ee },
	{ 0x5461, 0x54ea },
	{ 0x5462, 0x54e6 },
	{ 0x5463, 0x5527 },
	{ 0x5464, 0x5507 },
	{ 0x5465, 0x54fd },
	{ 0x5466, 0x550f },
	{ 0x5467, 0x5703 },
	{ 0x5468, 0x5704 },
	{ 0x5469, 0x57c2 },
	{ 0x546a, 0x57d4 },
	{ 0x546b, 0x57cb },
	{ 0x546c, 0x57c3 },
	{ 0x546d, 0x5809 },
	{ 0x546e, 0x590f },
	{ 0x546f, 0x5957 },
	{ 0x5470, 0x5958 },
	{ 0x5471, 0x595a },
	{ 0x5472, 0x5a11 },
	{ 0x5473, 0x5a18 },
	{ 0x5474, 0x5a1c },
	{ 0x5475, 0x5a1f },
	{ 0x5476, 0x5a1b },
	{ 0x5477, 0x5a13 },
	{ 0x5478, 0x59ec },
	{ 0x5479, 0x5a20 },
	{ 0x547a, 0x5a23 },
	{ 0x547b, 0x5a29 },
	{ 0x547c, 0x5a25 },
	{ 0x547d, 0x5a0c },
	{ 0x547e, 0x5a09 },
	{ 0x5521, 0x5b6b },
	{ 0x5522, 0x5c58 },
	{ 0x5523, 0x5bb0 },
	{ 0x5524, 0x5bb3 },
	{ 0x5525, 0x5bb6 },
	{ 0x5526, 0x5bb4 },
	{ 0x5527, 0x5bae },
	{ 0x5528, 0x5bb5 },
	{ 0x5529, 0x5bb9 },
	{ 0x552a, 0x5bb8 },
	{ 0x552b, 0x5c04 },
	{ 0x552c, 0x5c51 },
	{ 0x552d, 0x5c55 },
	{ 0x552e, 0x5c50 },
	{ 0x552f, 0x5ced },
	{ 0x5530, 0x5cfd },
	{ 0x5531, 0x5cfb },
	{ 0x5532, 0x5cea },
	{ 0x5533, 0x5ce8 },
	{ 0x5534, 0x5cf0 },
	{ 0x5535, 0x5cf6 },
	{ 0x5536, 0x5d01 },
	{ 0x5537, 0x5cf4 },
	{ 0x5538, 0x5dee },
	{ 0x5539, 0x5e2d },
	{ 0x553a, 0x5e2b },
	{ 0x553b, 0x5eab },
	{ 0x553c, 0x5ead },
	{ 0x553d, 0x5ea7 },
	{ 0x553e, 0x5f31 },
	{ 0x553f, 0x5f92 },
	{ 0x5540, 0x5f91 },
	{ 0x5541, 0x5f90 },
	{ 0x5542, 0x6059 },
	{ 0x5543, 0x6063 },
	{ 0x5544, 0x6065 },
	{ 0x5545, 0x6050 },
	{ 0x5546, 0x6055 },
	{ 0x5547, 0x606d },
	{ 0x5548, 0x6069 },
	{ 0x5549, 0x606f },
	{ 0x554a, 0x6084 },
	{ 0x554b, 0x609f },
	{ 0x554c, 0x609a },
	{ 0x554d, 0x608d },
	{ 0x554e, 0x6094 },
	{ 0x554f, 0x608c },
	{ 0x5550, 0x6085 },
	{ 0x5551, 0x6096 },
	{ 0x5552, 0x6247 },
	{ 0x5553, 0x62f3 },
	{ 0x5554, 0x6308 },
	{ 0x5555, 0x62ff },
	{ 0x5556, 0x634e },
	{ 0x5557, 0x633e },
	{ 0x5558, 0x632f },
	{ 0x5559, 0x6355 },
	{ 0x555a, 0x6342 },
	{ 0x555b, 0x6346 },
	{ 0x555c, 0x634f },
	{ 0x555d, 0x6349 },
	{ 0x555e, 0x633a },
	{ 0x555f, 0x6350 },
	{ 0x5560, 0x633d },
	{ 0x5561, 0x632a },
	{ 0x5562, 0x632b },
	{ 0x5563, 0x6328 },
	{ 0x5564, 0x634d },
	{ 0x5565, 0x634c },
	{ 0x5566, 0x6548 },
	{ 0x5567, 0x6549 },
	{ 0x5568, 0x6599 },
	{ 0x5569, 0x65c1 },
	{ 0x556a, 0x65c5 },
	{ 0x556b, 0x6642 },
	{ 0x556c, 0x6649 },
	{ 0x556d, 0x664f },
	{ 0x556e, 0x6643 },
	{ 0x556f, 0x6652 },
	{ 0x5570, 0x664c },
	{ 0x5571, 0x6645 },
	{ 0x5572, 0x6641 },
	{ 0x5573, 0x66f8 },
	{ 0x5574, 0x6714 },
	{ 0x5575, 0x6715 },
	{ 0x5576, 0x6717 },
	{ 0x5577, 0x6821 },
	{ 0x5578, 0x6838 },
	{ 0x5579, 0x6848 },
	{ 0x557a, 0x6846 },
	{ 0x557b, 0x6853 },
	{ 0x557c, 0x6839 },
	{ 0x557d, 0x6842 },
	{ 0x557e, 0x6854 },
	{ 0x5621, 0x6829 },
	{ 0x5622, 0x68b3 },
	{ 0x5623, 0x6817 },
	{ 0x5624, 0x684c },
	{ 0x5625, 0x6851 },
	{ 0x5626, 0x683d },
	{ 0x5627, 0x67f4 },
	{ 0x5628, 0x6850 },
	{ 0x5629, 0x6840 },
	{ 0x562a, 0x683c },
	{ 0x562b, 0x6843 },
	{ 0x562c, 0x682a },
	{ 0x562d, 0x6845 },
	{ 0x562e, 0x6813 },
	{ 0x562f, 0x6818 },
	{ 0x5630, 0x6841 },
	{ 0x5631, 0x6b8a },
	{ 0x5632, 0x6b89 },
	{ 0x5633, 0x6bb7 },
	{ 0x5634, 0x6c23 },
	{ 0x5635, 0x6c27 },
	{ 0x5636, 0x6c28 },
	{ 0x5637, 0x6c26 },
	{ 0x5638, 0x6c24 },
	{ 0x5639, 0x6cf0 },
	{ 0x563a, 0x6d6a },
	{ 0x563b, 0x6d95 },
	{ 0x563c, 0x6d88 },
	{ 0x563d, 0x6d87 },
	{ 0x563e, 0x6d66 },
	{ 0x563f, 0x6d78 },
	{ 0x5640, 0x6d77 },
	{ 0x5641, 0x6d59 },
	{ 0x5642, 0x6d93 },
	{ 0x5643, 0x6d6c },
	{ 0x5644, 0x6d89 },
	{ 0x5645, 0x6d6e },
	{ 0x5646, 0x6d5a },
	{ 0x5647, 0x6d74 },
	{ 0x5648, 0x6d69 },
	{ 0x5649, 0x6d8c },
	{ 0x564a, 0x6d8a },
	{ 0x564b, 0x6d79 },
	{ 0x564c, 0x6d85 },
	{ 0x564d, 0x6d65 },
	{ 0x564e, 0x6d94 },
	{ 0x564f, 0x70ca },
	{ 0x5650, 0x70d8 },
	{ 0x5651, 0x70e4 },
	{ 0x5652, 0x70d9 },
	{ 0x5653, 0x70c8 },
	{ 0x5654, 0x70cf },
	{ 0x5655, 0x7239 },
	{ 0x5656, 0x7279 },
	{ 0x5657, 0x72fc },
	{ 0x5658, 0x72f9 },
	{ 0x5659, 0x72fd },
	{ 0x565a, 0x72f8 },
	{ 0x565b, 0x72f7 },
	{ 0x565c, 0x7386 },
	{ 0x565d, 0x73ed },
	{ 0x565e, 0x7409 },
	{ 0x565f, 0x73ee },
	{ 0x5660, 0x73e0 },
	{ 0x5661, 0x73ea },
	{ 0x5662, 0x73de },
	{ 0x5663, 0x7554 },
	{ 0x5664, 0x755d },
	{ 0x5665, 0x755c },
	{ 0x5666, 0x755a },
	{ 0x5667, 0x7559 },
	{ 0x5668, 0x75be },
	{ 0x5669, 0x75c5 },
	{ 0x566a, 0x75c7 },
	{ 0x566b, 0x75b2 },
	{ 0x566c, 0x75b3 },
	{ 0x566d, 0x75bd },
	{ 0x566e, 0x75bc },
	{ 0x566f, 0x75b9 },
	{ 0x5670, 0x75c2 },
	{ 0x5671, 0x75b8 },
	{ 0x5672, 0x768b },
	{ 0x5673, 0x76b0 },
	{ 0x5674, 0x76ca },
	{ 0x5675, 0x76cd },
	{ 0x5676, 0x76ce },
	{ 0x5677, 0x7729 },
	{ 0x5678, 0x771f },
	{ 0x5679, 0x7720 },
	{ 0x567a, 0x7728 },
	{ 0x567b, 0x77e9 },
	{ 0x567c, 0x7830 },
	{ 0x567d, 0x7827 },
	{ 0x567e, 0x7838 },
	{ 0x5721, 0x781d },
	{ 0x5722, 0x7834 },
	{ 0x5723, 0x7837 },
	{ 0x5724, 0x7825 },
	{ 0x5725, 0x782d },
	{ 0x5726, 0x7820 },
	{ 0x5727, 0x781f },
	{ 0x5728, 0x7832 },
	{ 0x5729, 0x7955 },
	{ 0x572a, 0x7950 },
	{ 0x572b, 0x7960 },
	{ 0x572c, 0x795f },
	{ 0x572d, 0x7956 },
	{ 0x572e, 0x795e },
	{ 0x572f, 0x795d },
	{ 0x5730, 0x7957 },
	{ 0x5731, 0x795a },
	{ 0x5732, 0x79e4 },
	{ 0x5733, 0x79e3 },
	{ 0x5734, 0x79e7 },
	{ 0x5735, 0x79df },
	{ 0x5736, 0x79e6 },
	{ 0x5737, 0x79e9 },
	{ 0x5738, 0x79d8 },
	{ 0x5739, 0x7a84 },
	{ 0x573a, 0x7a88 },
	{ 0x573b, 0x7ad9 },
	{ 0x573c, 0x7b06 },
	{ 0x573d, 0x7b11 },
	{ 0x573e, 0x7c89 },
	{ 0x573f, 0x7d21 },
	{ 0x5740, 0x7d17 },
	{ 0x5741, 0x7d0b },
	{ 0x5742, 0x7d0a },
	{ 0x5743, 0x7d20 },
	{ 0x5744, 0x7d22 },
	{ 0x5745, 0x7d14 },
	{ 0x5746, 0x7d10 },
	{ 0x5747, 0x7d15 },
	{ 0x5748, 0x7d1a },
	{ 0x5749, 0x7d1c },
	{ 0x574a, 0x7d0d },
	{ 0x574b, 0x7d19 },
	{ 0x574c, 0x7d1b },
	{ 0x574d, 0x7f3a },
	{ 0x574e, 0x7f5f },
	{ 0x574f, 0x7f94 },
	{ 0x5750, 0x7fc5 },
	{ 0x5751, 0x7fc1 },
	{ 0x5752, 0x8006 },
	{ 0x5753, 0x8004 },
	{ 0x5754, 0x8018 },
	{ 0x5755, 0x8015 },
	{ 0x5756, 0x8019 },
	{ 0x5757, 0x8017 },
	{ 0x5758, 0x803d },
	{ 0x5759, 0x803f },
	{ 0x575a, 0x80f1 },
	{ 0x575b, 0x8102 },
	{ 0x575c, 0x80f0 },
	{ 0x575d, 0x8105 },
	{ 0x575e, 0x80ed },
	{ 0x575f, 0x80f4 },
	{ 0x5760, 0x8106 },
	{ 0x5761, 0x80f8 },
	{ 0x5762, 0x80f3 },
	{ 0x5763, 0x8108 },
	{ 0x5764, 0x80fd },
	{ 0x5765, 0x810a },
	{ 0x5766, 0x80fc },
	{ 0x5767, 0x80ef },
	{ 0x5768, 0x81ed },
	{ 0x5769, 0x81ec },
	{ 0x576a, 0x8200 },
	{ 0x576b, 0x8210 },
	{ 0x576c, 0x822a },
	{ 0x576d, 0x822b },
	{ 0x576e, 0x8228 },
	{ 0x576f, 0x822c },
	{ 0x5770, 0x82bb },
	{ 0x5771, 0x832b },
	{ 0x5772, 0x8352 },
	{ 0x5773, 0x8354 },
	{ 0x5774, 0x834a },
	{ 0x5775, 0x8338 },
	{ 0x5776, 0x8350 },
	{ 0x5777, 0x8349 },
	{ 0x5778, 0x8335 },
	{ 0x5779, 0x8334 },
	{ 0x577a, 0x834f },
	{ 0x577b, 0x8332 },
	{ 0x577c, 0x8339 },
	{ 0x577d, 0x8336 },
	{ 0x577e, 0x8317 },
	{ 0x5821, 0x8340 },
	{ 0x5822, 0x8331 },
	{ 0x5823, 0x8328 },
	{ 0x5824, 0x8343 },
	{ 0x5825, 0x8654 },
	{ 0x5826, 0x868a },
	{ 0x5827, 0x86aa },
	{ 0x5828, 0x8693 },
	{ 0x5829, 0x86a4 },
	{ 0x582a, 0x86a9 },
	{ 0x582b, 0x868c },
	{ 0x582c, 0x86a3 },
	{ 0x582d, 0x869c },
	{ 0x582e, 0x8870 },
	{ 0x582f, 0x8877 },
	{ 0x5830, 0x8881 },
	{ 0x5831, 0x8882 },
	{ 0x5832, 0x887d },
	{ 0x5833, 0x8879 },
	{ 0x5834, 0x8a18 },
	{ 0x5835, 0x8a10 },
	{ 0x5836, 0x8a0e },
	{ 0x5837, 0x8a0c },
	{ 0x5838, 0x8a15 },
	{ 0x5839, 0x8a0a },
	{ 0x583a, 0x8a17 },
	{ 0x583b, 0x8a13 },
	{ 0x583c, 0x8a16 },
	{ 0x583d, 0x8a0f },
	{ 0x583e, 0x8a11 },
	{ 0x583f, 0x8c48 },
	{ 0x5840, 0x8c7a },
	{ 0x5841, 0x8c79 },
	{ 0x5842, 0x8ca1 },
	{ 0x5843, 0x8ca2 },
	{ 0x5844, 0x8d77 },
	{ 0x5845, 0x8eac },
	{ 0x5846, 0x8ed2 },
	{ 0x5847, 0x8ed4 },
	{ 0x5848, 0x8ecf },
	{ 0x5849, 0x8fb1 },
	{ 0x584a, 0x9001 },
	{ 0x584b, 0x9006 },
	{ 0x584c, 0x8ff7 },
	{ 0x584d, 0x9000 },
	{ 0x584e, 0x8ffa },
	{ 0x584f, 0x8ff4 },
	{ 0x5850, 0x9003 },
	{ 0x5851, 0x8ffd },
	{ 0x5852, 0x9005 },
	{ 0x5853, 0x8ff8 },
	{ 0x5854, 0x9095 },
	{ 0x5855, 0x90e1 },
	{ 0x5856, 0x90dd },
	{ 0x5857, 0x90e2 },
	{ 0x5858, 0x9152 },
	{ 0x5859, 0x914d },
	{ 0x585a, 0x914c },
	{ 0x585b, 0x91d8 },
	{ 0x585c, 0x91dd },
	{ 0x585d, 0x91d7 },
	{ 0x585e, 0x91dc },
	{ 0x585f, 0x91d9 },
	{ 0x5860, 0x9583 },
	{ 0x5861, 0x9662 },
	{ 0x5862, 0x9663 },
	{ 0x5863, 0x9661 },
	{ 0x5864, 0x965b },
	{ 0x5865, 0x965d },
	{ 0x5866, 0x9664 },
	{ 0x5867, 0x9658 },
	{ 0x5868, 0x965e },
	{ 0x5869, 0x96bb },
	{ 0x586a, 0x98e2 },
	{ 0x586b, 0x99ac },
	{ 0x586c, 0x9aa8 },
	{ 0x586d, 0x9ad8 },
	{ 0x586e, 0x9b25 },
	{ 0x586f, 0x9b32 },
	{ 0x5870, 0x9b3c },
	{ 0x5871, 0x4e7e },
	{ 0x5872, 0x507a },
	{ 0x5873, 0x507d },
	{ 0x5874, 0x505c },
	{ 0x5875, 0x5047 },
	{ 0x5876, 0x5043 },
	{ 0x5877, 0x504c },
	{ 0x5878, 0x505a },
	{ 0x5879, 0x5049 },
	{ 0x587a, 0x5065 },
	{ 0x587b, 0x5076 },
	{ 0x587c, 0x504e },
	{ 0x587d, 0x5055 },
	{ 0x587e, 0x5075 },
	{ 0x5921, 0x5074 },
	{ 0x5922, 0x5077 },
	{ 0x5923, 0x504f },
	{ 0x5924, 0x500f },
	{ 0x5925, 0x506f },
	{ 0x5926, 0x506d },
	{ 0x5927, 0x515c },
	{ 0x5928, 0x5195 },
	{ 0x5929, 0x51f0 },
	{ 0x592a, 0x526a },
	{ 0x592b, 0x526f },
	{ 0x592c, 0x52d2 },
	{ 0x592d, 0x52d9 },
	{ 0x592e, 0x52d8 },
	{ 0x592f, 0x52d5 },
	{ 0x5930, 0x5310 },
	{ 0x5931, 0x530f },
	{ 0x5932, 0x5319 },
	{ 0x5933, 0x533f },
	{ 0x5934, 0x5340 },
	{ 0x5935, 0x533e },
	{ 0x5936, 0x53c3 },
	{ 0x5937, 0x66fc },
	{ 0x5938, 0x5546 },
	{ 0x5939, 0x556a },
	{ 0x593a, 0x5566 },
	{ 0x593b, 0x5544 },
	{ 0x593c, 0x555e },
	{ 0x593d, 0x5561 },
	{ 0x593e, 0x5543 },
	{ 0x593f, 0x554a },
	{ 0x5940, 0x5531 },
	{ 0x5941, 0x5556 },
	{ 0x5942, 0x554f },
	{ 0x5943, 0x5555 },
	{ 0x5944, 0x552f },
	{ 0x5945, 0x5564 },
	{ 0x5946, 0x5538 },
	{ 0x5947, 0x552e },
	{ 0x5948, 0x555c },
	{ 0x5949, 0x552c },
	{ 0x594a, 0x5563 },
	{ 0x594b, 0x5533 },
	{ 0x594c, 0x5541 },
	{ 0x594d, 0x5557 },
	{ 0x594e, 0x5708 },
	{ 0x594f, 0x570b },
	{ 0x5950, 0x5709 },
	{ 0x5951, 0x57df },
	{ 0x5952, 0x5805 },
	{ 0x5953, 0x580a },
	{ 0x5954, 0x5806 },
	{ 0x5955, 0x57e0 },
	{ 0x5956, 0x57e4 },
	{ 0x5957, 0x57fa },
	{ 0x5958, 0x5802 },
	{ 0x5959, 0x5835 },
	{ 0x595a, 0x57f7 },
	{ 0x595b, 0x57f9 },
	{ 0x595c, 0x5920 },
	{ 0x595d, 0x5962 },
	{ 0x595e, 0x5a36 },
	{ 0x595f, 0x5a41 },
	{ 0x5960, 0x5a49 },
	{ 0x5961, 0x5a66 },
	{ 0x5962, 0x5a6a },
	{ 0x5963, 0x5a40 },
	{ 0x5964, 0x5a3c },
	{ 0x5965, 0x5a62 },
	{ 0x5966, 0x5a5a },
	{ 0x5967, 0x5a46 },
	{ 0x5968, 0x5a4a },
	{ 0x5969, 0x5b70 },
	{ 0x596a, 0x5bc7 },
	{ 0x596b, 0x5bc5 },
	{ 0x596c, 0x5bc4 },
	{ 0x596d, 0x5bc2 },
	{ 0x596e, 0x5bbf },
	{ 0x596f, 0x5bc6 },
	{ 0x5970, 0x5c09 },
	{ 0x5971, 0x5c08 },
	{ 0x5972, 0x5c07 },
	{ 0x5973, 0x5c60 },
	{ 0x5974, 0x5c5c },
	{ 0x5975, 0x5c5d },
	{ 0x5976, 0x5d07 },
	{ 0x5977, 0x5d06 },
	{ 0x5978, 0x5d0e },
	{ 0x5979, 0x5d1b },
	{ 0x597a, 0x5d16 },
	{ 0x597b, 0x5d22 },
	{ 0x597c, 0x5d11 },
	{ 0x597d, 0x5d29 },
	{ 0x597e, 0x5d14 },
	{ 0x5a21, 0x5d19 },
	{ 0x5a22, 0x5d24 },
	{ 0x5a23, 0x5d27 },
	{ 0x5a24, 0x5d17 },
	{ 0x5a25, 0x5de2 },
	{ 0x5a26, 0x5e38 },
	{ 0x5a27, 0x5e36 },
	{ 0x5a28, 0x5e33 },
	{ 0x5a29, 0x5e37 },
	{ 0x5a2a, 0x5eb7 },
	{ 0x5a2b, 0x5eb8 },
	{ 0x5a2c, 0x5eb6 },
	{ 0x5a2d, 0x5eb5 },
	{ 0x5a2e, 0x5ebe },
	{ 0x5a2f, 0x5f35 },
	{ 0x5a30, 0x5f37 },
	{ 0x5a31, 0x5f57 },
	{ 0x5a32, 0x5f6c },
	{ 0x5a33, 0x5f69 },
	{ 0x5a34, 0x5f6b },
	{ 0x5a35, 0x5f97 },
	{ 0x5a36, 0x5f99 },
	{ 0x5a37, 0x5f9e },
	{ 0x5a38, 0x5f98 },
	{ 0x5a39, 0x5fa1 },
	{ 0x5a3a, 0x5fa0 },
	{ 0x5a3b, 0x5f9c },
	{ 0x5a3c, 0x607f },
	{ 0x5a3d, 0x60a3 },
	{ 0x5a3e, 0x6089 },
	{ 0x5a3f, 0x60a0 },
	{ 0x5a40, 0x60a8 },
	{ 0x5a41, 0x60cb },
	{ 0x5a42, 0x60b4 },
	{ 0x5a43, 0x60e6 },
	{ 0x5a44, 0x60bd },
	{ 0x5a45, 0x60c5 },
	{ 0x5a46, 0x60bb },
	{ 0x5a47, 0x60b5 },
	{ 0x5a48, 0x60dc },
	{ 0x5a49, 0x60bc },
	{ 0x5a4a, 0x60d8 },
	{ 0x5a4b, 0x60d5 },
	{ 0x5a4c, 0x60c6 },
	{ 0x5a4d, 0x60df },
	{ 0x5a4e, 0x60b8 },
	{ 0x5a4f, 0x60da },
	{ 0x5a50, 0x60c7 },
	{ 0x5a51, 0x621a },
	{ 0x5a52, 0x621b },
	{ 0x5a53, 0x6248 },
	{ 0x5a54, 0x63a0 },
	{ 0x5a55, 0x63a7 },
	{ 0x5a56, 0x6372 },
	{ 0x5a57, 0x6396 },
	{ 0x5a58, 0x63a2 },
	{ 0x5a59, 0x63a5 },
	{ 0x5a5a, 0x6377 },
	{ 0x5a5b, 0x6367 },
	{ 0x5a5c, 0x6398 },
	{ 0x5a5d, 0x63aa },
	{ 0x5a5e, 0x6371 },
	{ 0x5a5f, 0x63a9 },
	{ 0x5a60, 0x6389 },
	{ 0x5a61, 0x6383 },
	{ 0x5a62, 0x639b },
	{ 0x5a63, 0x636b },
	{ 0x5a64, 0x63a8 },
	{ 0x5a65, 0x6384 },
	{ 0x5a66, 0x6388 },
	{ 0x5a67, 0x6399 },
	{ 0x5a68, 0x63a1 },
	{ 0x5a69, 0x63ac },
	{ 0x5a6a, 0x6392 },
	{ 0x5a6b, 0x638f },
	{ 0x5a6c, 0x6380 },
	{ 0x5a6d, 0x637b },
	{ 0x5a6e, 0x6369 },
	{ 0x5a6f, 0x6368 },
	{ 0x5a70, 0x637a },
	{ 0x5a71, 0x655d },
	{ 0x5a72, 0x6556 },
	{ 0x5a73, 0x6551 },
	{ 0x5a74, 0x6559 },
	{ 0x5a75, 0x6557 },
	{ 0x5a76, 0x555f },
	{ 0x5a77, 0x654f },
	{ 0x5a78, 0x6558 },
	{ 0x5a79, 0x6555 },
	{ 0x5a7a, 0x6554 },
	{ 0x5a7b, 0x659c },
	{ 0x5a7c, 0x659b },
	{ 0x5a7d, 0x65ac },
	{ 0x5a7e, 0x65cf },
	{ 0x5b21, 0x65cb },
	{ 0x5b22, 0x65cc },
	{ 0x5b23, 0x65ce },
	{ 0x5b24, 0x665d },
	{ 0x5b25, 0x665a },
	{ 0x5b26, 0x6664 },
	{ 0x5b27, 0x6668 },
	{ 0x5b28, 0x6666 },
	{ 0x5b29, 0x665e },
	{ 0x5b2a, 0x66f9 },
	{ 0x5b2b, 0x52d7 },
	{ 0x5b2c, 0x671b },
	{ 0x5b2d, 0x6881 },
	{ 0x5b2e, 0x68af },
	{ 0x5b2f, 0x68a2 },
	{ 0x5b30, 0x6893 },
	{ 0x5b31, 0x68b5 },
	{ 0x5b32, 0x687f },
	{ 0x5b33, 0x6876 },
	{ 0x5b34, 0x68b1 },
	{ 0x5b35, 0x68a7 },
	{ 0x5b36, 0x6897 },
	{ 0x5b37, 0x68b0 },
	{ 0x5b38, 0x6883 },
	{ 0x5b39, 0x68c4 },
	{ 0x5b3a, 0x68ad },
	{ 0x5b3b, 0x6886 },
	{ 0x5b3c, 0x6885 },
	{ 0x5b3d, 0x6894 },
	{ 0x5b3e, 0x689d },
	{ 0x5b3f, 0x68a8 },
	{ 0x5b40, 0x689f },
	{ 0x5b41, 0x68a1 },
	{ 0x5b42, 0x6882 },
	{ 0x5b43, 0x6b32 },
	{ 0x5b44, 0x6bba },
	{ 0x5b45, 0x6beb },
	{ 0x5b46, 0x6bec },
	{ 0x5b47, 0x6c2b },
	{ 0x5b48, 0x6d8e },
	{ 0x5b49, 0x6dbc },
	{ 0x5b4a, 0x6df3 },
	{ 0x5b4b, 0x6dd9 },
	{ 0x5b4c, 0x6db2 },
	{ 0x5b4d, 0x6de1 },
	{ 0x5b4e, 0x6dcc },
	{ 0x5b4f, 0x6de4 },
	{ 0x5b50, 0x6dfb },
	{ 0x5b51, 0x6dfa },
	{ 0x5b52, 0x6e05 },
	{ 0x5b53, 0x6dc7 },
	{ 0x5b54, 0x6dcb },
	{ 0x5b55, 0x6daf },
	{ 0x5b56, 0x6dd1 },
	{ 0x5b57, 0x6dae },
	{ 0x5b58, 0x6dde },
	{ 0x5b59, 0x6df9 },
	{ 0x5b5a, 0x6db8 },
	{ 0x5b5b, 0x6df7 },
	{ 0x5b5c, 0x6df5 },
	{ 0x5b5d, 0x6dc5 },
	{ 0x5b5e, 0x6dd2 },
	{ 0x5b5f, 0x6e1a },
	{ 0x5b60, 0x6db5 },
	{ 0x5b61, 0x6dda },
	{ 0x5b62, 0x6deb },
	{ 0x5b63, 0x6dd8 },
	{ 0x5b64, 0x6dea },
	{ 0x5b65, 0x6df1 },
	{ 0x5b66, 0x6dee },
	{ 0x5b67, 0x6de8 },
	{ 0x5b68, 0x6dc6 },
	{ 0x5b69, 0x6dc4 },
	{ 0x5b6a, 0x6daa },
	{ 0x5b6b, 0x6dec },
	{ 0x5b6c, 0x6dbf },
	{ 0x5b6d, 0x6de6 },
	{ 0x5b6e, 0x70f9 },
	{ 0x5b6f, 0x7109 },
	{ 0x5b70, 0x710a },
	{ 0x5b71, 0x70fd },
	{ 0x5b72, 0x70ef },
	{ 0x5b73, 0x723d },
	{ 0x5b74, 0x727d },
	{ 0x5b75, 0x7281 },
	{ 0x5b76, 0x731c },
	{ 0x5b77, 0x731b },
	{ 0x5b78, 0x7316 },
	{ 0x5b79, 0x7313 },
	{ 0x5b7a, 0x7319 },
	{ 0x5b7b, 0x7387 },
	{ 0x5b7c, 0x7405 },
	{ 0x5b7d, 0x740a },
	{ 0x5b7e, 0x7403 },
	{ 0x5c21, 0x7406 },
	{ 0x5c22, 0x73fe },
	{ 0x5c23, 0x740d },
	{ 0x5c24, 0x74e0 },
	{ 0x5c25, 0x74f6 },
	{ 0x5c26, 0x74f7 },
	{ 0x5c27, 0x751c },
	{ 0x5c28, 0x7522 },
	{ 0x5c29, 0x7565 },
	{ 0x5c2a, 0x7566 },
	{ 0x5c2b, 0x7562 },
	{ 0x5c2c, 0x7570 },
	{ 0x5c2d, 0x758f },
	{ 0x5c2e, 0x75d4 },
	{ 0x5c2f, 0x75d5 },
	{ 0x5c30, 0x75b5 },
	{ 0x5c31, 0x75ca },
	{ 0x5c32, 0x75cd },
	{ 0x5c33, 0x768e },
	{ 0x5c34, 0x76d4 },
	{ 0x5c35, 0x76d2 },
	{ 0x5c36, 0x76db },
	{ 0x5c37, 0x7737 },
	{ 0x5c38, 0x773e },
	{ 0x5c39, 0x773c },
	{ 0x5c3a, 0x7736 },
	{ 0x5c3b, 0x7738 },
	{ 0x5c3c, 0x773a },
	{ 0x5c3d, 0x786b },
	{ 0x5c3e, 0x7843 },
	{ 0x5c3f, 0x784e },
	{ 0x5c40, 0x7965 },
	{ 0x5c41, 0x7968 },
	{ 0x5c42, 0x796d },
	{ 0x5c43, 0x79fb },
	{ 0x5c44, 0x7a92 },
	{ 0x5c45, 0x7a95 },
	{ 0x5c46, 0x7b20 },
	{ 0x5c47, 0x7b28 },
	{ 0x5c48, 0x7b1b },
	{ 0x5c49, 0x7b2c },
	{ 0x5c4a, 0x7b26 },
	{ 0x5c4b, 0x7b19 },
	{ 0x5c4c, 0x7b1e },
	{ 0x5c4d, 0x7b2e },
	{ 0x5c4e, 0x7c92 },
	{ 0x5c4f, 0x7c97 },
	{ 0x5c50, 0x7c95 },
	{ 0x5c51, 0x7d46 },
	{ 0x5c52, 0x7d43 },
	{ 0x5c53, 0x7d71 },
	{ 0x5c54, 0x7d2e },
	{ 0x5c55, 0x7d39 },
	{ 0x5c56, 0x7d3c },
	{ 0x5c57, 0x7d40 },
	{ 0x5c58, 0x7d30 },
	{ 0x5c59, 0x7d33 },
	{ 0x5c5a, 0x7d44 },
	{ 0x5c5b, 0x7d2f },
	{ 0x5c5c, 0x7d42 },
	{ 0x5c5d, 0x7d32 },
	{ 0x5c5e, 0x7d31 },
	{ 0x5c5f, 0x7f3d },
	{ 0x5c60, 0x7f9e },
	{ 0x5c61, 0x7f9a },
	{ 0x5c62, 0x7fcc },
	{ 0x5c63, 0x7fce },
	{ 0x5c64, 0x7fd2 },
	{ 0x5c65, 0x801c },
	{ 0x5c66, 0x804a },
	{ 0x5c67, 0x8046 },
	{ 0x5c68, 0x812f },
	{ 0x5c69, 0x8116 },
	{ 0x5c6a, 0x8123 },
	{ 0x5c6b, 0x812b },
	{ 0x5c6c, 0x8129 },
	{ 0x5c6d, 0x8130 },
	{ 0x5c6e, 0x8124 },
	{ 0x5c6f, 0x8202 },
	{ 0x5c70, 0x8235 },
	{ 0x5c71, 0x8237 },
	{ 0x5c72, 0x8236 },
	{ 0x5c73, 0x8239 },
	{ 0x5c74, 0x838e },
	{ 0x5c75, 0x839e },
	{ 0x5c76, 0x8398 },
	{ 0x5c77, 0x8378 },
	{ 0x5c78, 0x83a2 },
	{ 0x5c79, 0x8396 },
	{ 0x5c7a, 0x83bd },
	{ 0x5c7b, 0x83ab },
	{ 0x5c7c, 0x8392 },
	{ 0x5c7d, 0x838a },
	{ 0x5c7e, 0x8393 },
	{ 0x5d21, 0x8389 },
	{ 0x5d22, 0x83a0 },
	{ 0x5d23, 0x8377 },
	{ 0x5d24, 0x837b },
	{ 0x5d25, 0x837c },
	{ 0x5d26, 0x8386 },
	{ 0x5d27, 0x83a7 },
	{ 0x5d28, 0x8655 },
	{ 0x5d29, 0x5f6a },
	{ 0x5d2a, 0x86c7 },
	{ 0x5d2b, 0x86c0 },
	{ 0x5d2c, 0x86b6 },
	{ 0x5d2d, 0x86c4 },
	{ 0x5d2e, 0x86b5 },
	{ 0x5d2f, 0x86c6 },
	{ 0x5d30, 0x86cb },
	{ 0x5d31, 0x86b1 },
	{ 0x5d32, 0x86af },
	{ 0x5d33, 0x86c9 },
	{ 0x5d34, 0x8853 },
	{ 0x5d35, 0x889e },
	{ 0x5d36, 0x8888 },
	{ 0x5d37, 0x88ab },
	{ 0x5d38, 0x8892 },
	{ 0x5d39, 0x8896 },
	{ 0x5d3a, 0x888d },
	{ 0x5d3b, 0x888b },
	{ 0x5d3c, 0x8993 },
	{ 0x5d3d, 0x898f },
	{ 0x5d3e, 0x8a2a },
	{ 0x5d3f, 0x8a1d },
	{ 0x5d40, 0x8a23 },
	{ 0x5d41, 0x8a25 },
	{ 0x5d42, 0x8a31 },
	{ 0x5d43, 0x8a2d },
	{ 0x5d44, 0x8a1f },
	{ 0x5d45, 0x8a1b },
	{ 0x5d46, 0x8a22 },
	{ 0x5d47, 0x8c49 },
	{ 0x5d48, 0x8c5a },
	{ 0x5d49, 0x8ca9 },
	{ 0x5d4a, 0x8cac },
	{ 0x5d4b, 0x8cab },
	{ 0x5d4c, 0x8ca8 },
	{ 0x5d4d, 0x8caa },
	{ 0x5d4e, 0x8ca7 },
	{ 0x5d4f, 0x8d67 },
	{ 0x5d50, 0x8d66 },
	{ 0x5d51, 0x8dbe },
	{ 0x5d52, 0x8dba },
	{ 0x5d53, 0x8edb },
	{ 0x5d54, 0x8edf },
	{ 0x5d55, 0x9019 },
	{ 0x5d56, 0x900d },
	{ 0x5d57, 0x901a },
	{ 0x5d58, 0x9017 },
	{ 0x5d59, 0x9023 },
	{ 0x5d5a, 0x901f },
	{ 0x5d5b, 0x901d },
	{ 0x5d5c, 0x9010 },
	{ 0x5d5d, 0x9015 },
	{ 0x5d5e, 0x901e },
	{ 0x5d5f, 0x9020 },
	{ 0x5d60, 0x900f },
	{ 0x5d61, 0x9022 },
	{ 0x5d62, 0x9016 },
	{ 0x5d63, 0x901b },
	{ 0x5d64, 0x9014 },
	{ 0x5d65, 0x90e8 },
	{ 0x5d66, 0x90ed },
	{ 0x5d67, 0x90fd },
	{ 0x5d68, 0x9157 },
	{ 0x5d69, 0x91ce },
	{ 0x5d6a, 0x91f5 },
	{ 0x5d6b, 0x91e6 },
	{ 0x5d6c, 0x91e3 },
	{ 0x5d6d, 0x91e7 },
	{ 0x5d6e, 0x91ed },
	{ 0x5d6f, 0x91e9 },
	{ 0x5d70, 0x9589 },
	{ 0x5d71, 0x966a },
	{ 0x5d72, 0x9675 },
	{ 0x5d73, 0x9673 },
	{ 0x5d74, 0x9678 },
	{ 0x5d75, 0x9670 },
	{ 0x5d76, 0x9674 },
	{ 0x5d77, 0x9676 },
	{ 0x5d78, 0x9677 },
	{ 0x5d79, 0x966c },
	{ 0x5d7a, 0x96c0 },
	{ 0x5d7b, 0x96ea },
	{ 0x5d7c, 0x96e9 },
	{ 0x5d7d, 0x7ae0 },
	{ 0x5d7e, 0x7adf },
	{ 0x5e21, 0x9802 },
	{ 0x5e22, 0x9803 },
	{ 0x5e23, 0x9b5a },
	{ 0x5e24, 0x9ce5 },
	{ 0x5e25, 0x9e75 },
	{ 0x5e26, 0x9e7f },
	{ 0x5e27, 0x9ea5 },
	{ 0x5e28, 0x9ebb },
	{ 0x5e29, 0x50a2 },
	{ 0x5e2a, 0x508d },
	{ 0x5e2b, 0x5085 },
	{ 0x5e2c, 0x5099 },
	{ 0x5e2d, 0x5091 },
	{ 0x5e2e, 0x5080 },
	{ 0x5e2f, 0x5096 },
	{ 0x5e30, 0x5098 },
	{ 0x5e31, 0x509a },
	{ 0x5e32, 0x6700 },
	{ 0x5e33, 0x51f1 },
	{ 0x5e34, 0x5272 },
	{ 0x5e35, 0x5274 },
	{ 0x5e36, 0x5275 },
	{ 0x5e37, 0x5269 },
	{ 0x5e38, 0x52de },
	{ 0x5e39, 0x52dd },
	{ 0x5e3a, 0x52db },
	{ 0x5e3b, 0x535a },
	{ 0x5e3c, 0x53a5 },
	{ 0x5e3d, 0x557b },
	{ 0x5e3e, 0x5580 },
	{ 0x5e3f, 0x55a7 },
	{ 0x5e40, 0x557c },
	{ 0x5e41, 0x558a },
	{ 0x5e42, 0x559d },
	{ 0x5e43, 0x5598 },
	{ 0x5e44, 0x5582 },
	{ 0x5e45, 0x559c },
	{ 0x5e46, 0x55aa },
	{ 0x5e47, 0x5594 },
	{ 0x5e48, 0x5587 },
	{ 0x5e49, 0x558b },
	{ 0x5e4a, 0x5583 },
	{ 0x5e4b, 0x55b3 },
	{ 0x5e4c, 0x55ae },
	{ 0x5e4d, 0x559f },
	{ 0x5e4e, 0x553e },
	{ 0x5e4f, 0x55b2 },
	{ 0x5e50, 0x559a },
	{ 0x5e51, 0x55bb },
	{ 0x5e52, 0x55ac },
	{ 0x5e53, 0x55b1 },
	{ 0x5e54, 0x557e },
	{ 0x5e55, 0x5589 },
	{ 0x5e56, 0x55ab },
	{ 0x5e57, 0x5599 },
	{ 0x5e58, 0x570d },
	{ 0x5e59, 0x582f },
	{ 0x5e5a, 0x582a },
	{ 0x5e5b, 0x5834 },
	{ 0x5e5c, 0x5824 },
	{ 0x5e5d, 0x5830 },
	{ 0x5e5e, 0x5831 },
	{ 0x5e5f, 0x5821 },
	{ 0x5e60, 0x581d },
	{ 0x5e61, 0x5820 },
	{ 0x5e62, 0x58f9 },
	{ 0x5e63, 0x58fa },
	{ 0x5e64, 0x5960 },
	{ 0x5e65, 0x5a77 },
	{ 0x5e66, 0x5a9a },
	{ 0x5e67, 0x5a7f },
	{ 0x5e68, 0x5a92 },
	{ 0x5e69, 0x5a9b },
	{ 0x5e6a, 0x5aa7 },
	{ 0x5e6b, 0x5b73 },
	{ 0x5e6c, 0x5b71 },
	{ 0x5e6d, 0x5bd2 },
	{ 0x5e6e, 0x5bcc },
	{ 0x5e6f, 0x5bd3 },
	{ 0x5e70, 0x5bd0 },
	{ 0x5e71, 0x5c0a },
	{ 0x5e72, 0x5c0b },
	{ 0x5e73, 0x5c31 },
	{ 0x5e74, 0x5d4c },
	{ 0x5e75, 0x5d50 },
	{ 0x5e76, 0x5d34 },
	{ 0x5e77, 0x5d47 },
	{ 0x5e78, 0x5dfd },
	{ 0x5e79, 0x5e45 },
	{ 0x5e7a, 0x5e3d },
	{ 0x5e7b, 0x5e40 },
	{ 0x5e7c, 0x5e43 },
	{ 0x5e7d, 0x5e7e },
	{ 0x5e7e, 0x5eca },
	{ 0x5f21, 0x5ec1 },
	{ 0x5f22, 0x5ec2 },
	{ 0x5f23, 0x5ec4 },
	{ 0x5f24, 0x5f3c },
	{ 0x5f25, 0x5f6d },
	{ 0x5f26, 0x5fa9 },
	{ 0x5f27, 0x5faa },
	{ 0x5f28, 0x5fa8 },
	{ 0x5f29, 0x60d1 },
	{ 0x5f2a, 0x60e1 },
	{ 0x5f2b, 0x60b2 },
	{ 0x5f2c, 0x60b6 },
	{ 0x5f2d, 0x60e0 },
	{ 0x5f2e, 0x611c },
	{ 0x5f2f, 0x6123 },
	{ 0x5f30, 0x60fa },
	{ 0x5f31, 0x6115 },
	{ 0x5f32, 0x60f0 },
	{ 0x5f33, 0x60fb },
	{ 0x5f34, 0x60f4 },
	{ 0x5f35, 0x6168 },
	{ 0x5f36, 0x60f1 },
	{ 0x5f37, 0x610e },
	{ 0x5f38, 0x60f6 },
	{ 0x5f39, 0x6109 },
	{ 0x5f3a, 0x6100 },
	{ 0x5f3b, 0x6112 },
	{ 0x5f3c, 0x621f },
	{ 0x5f3d, 0x6249 },
	{ 0x5f3e, 0x63a3 },
	{ 0x5f3f, 0x638c },
	{ 0x5f40, 0x63cf },
	{ 0x5f41, 0x63c0 },
	{ 0x5f42, 0x63e9 },
	{ 0x5f43, 0x63c9 },
	{ 0x5f44, 0x63c6 },
	{ 0x5f45, 0x63cd },
	{ 0x5f46, 0x63d2 },
	{ 0x5f47, 0x63e3 },
	{ 0x5f48, 0x63d0 },
	{ 0x5f49, 0x63e1 },
	{ 0x5f4a, 0x63d6 },
	{ 0x5f4b, 0x63ed },
	{ 0x5f4c, 0x63ee },
	{ 0x5f4d, 0x6376 },
	{ 0x5f4e, 0x63f4 },
	{ 0x5f4f, 0x63ea },
	{ 0x5f50, 0x63db },
	{ 0x5f51, 0x6452 },
	{ 0x5f52, 0x63da },
	{ 0x5f53, 0x63f9 },
	{ 0x5f54, 0x655e },
	{ 0x5f55, 0x6566 },
	{ 0x5f56, 0x6562 },
	{ 0x5f57, 0x6563 },
	{ 0x5f58, 0x6591 },
	{ 0x5f59, 0x6590 },
	{ 0x5f5a, 0x65af },
	{ 0x5f5b, 0x666e },
	{ 0x5f5c, 0x6670 },
	{ 0x5f5d, 0x6674 },
	{ 0x5f5e, 0x6676 },
	{ 0x5f5f, 0x666f },
	{ 0x5f60, 0x6691 },
	{ 0x5f61, 0x667a },
	{ 0x5f62, 0x667e },
	{ 0x5f63, 0x6677 },
	{ 0x5f64, 0x66fe },
	{ 0x5f65, 0x66ff },
	{ 0x5f66, 0x671f },
	{ 0x5f67, 0x671d },
	{ 0x5f68, 0x68fa },
	{ 0x5f69, 0x68d5 },
	{ 0x5f6a, 0x68e0 },
	{ 0x5f6b, 0x68d8 },
	{ 0x5f6c, 0x68d7 },
	{ 0x5f6d, 0x6905 },
	{ 0x5f6e, 0x68df },
	{ 0x5f6f, 0x68f5 },
	{ 0x5f70, 0x68ee },
	{ 0x5f71, 0x68e7 },
	{ 0x5f72, 0x68f9 },
	{ 0x5f73, 0x68d2 },
	{ 0x5f74, 0x68f2 },
	{ 0x5f75, 0x68e3 },
	{ 0x5f76, 0x68cb },
	{ 0x5f77, 0x68cd },
	{ 0x5f78, 0x690d },
	{ 0x5f79, 0x6912 },
	{ 0x5f7a, 0x690e },
	{ 0x5f7b, 0x68c9 },
	{ 0x5f7c, 0x68da },
	{ 0x5f7d, 0x696e },
	{ 0x5f7e, 0x68fb },
	{ 0x6021, 0x6b3e },
	{ 0x6022, 0x6b3a },
	{ 0x6023, 0x6b3d },
	{ 0x6024, 0x6b98 },
	{ 0x6025, 0x6b96 },
	{ 0x6026, 0x6bbc },
	{ 0x6027, 0x6bef },
	{ 0x6028, 0x6c2e },
	{ 0x6029, 0x6c2f },
	{ 0x602a, 0x6c2c },
	{ 0x602b, 0x6e2f },
	{ 0x602c, 0x6e38 },
	{ 0x602d, 0x6e54 },
	{ 0x602e, 0x6e21 },
	{ 0x602f, 0x6e32 },
	{ 0x6030, 0x6e67 },
	{ 0x6031, 0x6e4a },
	{ 0x6032, 0x6e20 },
	{ 0x6033, 0x6e25 },
	{ 0x6034, 0x6e23 },
	{ 0x6035, 0x6e1b },
	{ 0x6036, 0x6e5b },
	{ 0x6037, 0x6e58 },
	{ 0x6038, 0x6e24 },
	{ 0x6039, 0x6e56 },
	{ 0x603a, 0x6e6e },
	{ 0x603b, 0x6e2d },
	{ 0x603c, 0x6e26 },
	{ 0x603d, 0x6e6f },
	{ 0x603e, 0x6e34 },
	{ 0x603f, 0x6e4d },
	{ 0x6040, 0x6e3a },
	{ 0x6041, 0x6e2c },
	{ 0x6042, 0x6e43 },
	{ 0x6043, 0x6e1d },
	{ 0x6044, 0x6e3e },
	{ 0x6045, 0x6ecb },
	{ 0x6046, 0x6e89 },
	{ 0x6047, 0x6e19 },
	{ 0x6048, 0x6e4e },
	{ 0x6049, 0x6e63 },
	{ 0x604a, 0x6e44 },
	{ 0x604b, 0x6e72 },
	{ 0x604c, 0x6e69 },
	{ 0x604d, 0x6e5f },
	{ 0x604e, 0x7119 },
	{ 0x604f, 0x711a },
	{ 0x6050, 0x7126 },
	{ 0x6051, 0x7130 },
	{ 0x6052, 0x7121 },
	{ 0x6053, 0x7136 },
	{ 0x6054, 0x716e },
	{ 0x6055, 0x711c },
	{ 0x6056, 0x724c },
	{ 0x6057, 0x7284 },
	{ 0x6058, 0x7280 },
	{ 0x6059, 0x7336 },
	{ 0x605a, 0x7325 },
	{ 0x605b, 0x7334 },
	{ 0x605c, 0x7329 },
	{ 0x605d, 0x743a },
	{ 0x605e, 0x742a },
	{ 0x605f, 0x7433 },
	{ 0x6060, 0x7422 },
	{ 0x6061, 0x7425 },
	{ 0x6062, 0x7435 },
	{ 0x6063, 0x7436 },
	{ 0x6064, 0x7434 },
	{ 0x6065, 0x742f },
	{ 0x6066, 0x741b },
	{ 0x6067, 0x7426 },
	{ 0x6068, 0x7428 },
	{ 0x6069, 0x7525 },
	{ 0x606a, 0x7526 },
	{ 0x606b, 0x756b },
	{ 0x606c, 0x756a },
	{ 0x606d, 0x75e2 },
	{ 0x606e, 0x75db },
	{ 0x606f, 0x75e3 },
	{ 0x6070, 0x75d9 },
	{ 0x6071, 0x75d8 },
	{ 0x6072, 0x75de },
	{ 0x6073, 0x75e0 },
	{ 0x6074, 0x767b },
	{ 0x6075, 0x767c },
	{ 0x6076, 0x7696 },
	{ 0x6077, 0x7693 },
	{ 0x6078, 0x76b4 },
	{ 0x6079, 0x76dc },
	{ 0x607a, 0x774f },
	{ 0x607b, 0x77ed },
	{ 0x607c, 0x785d },
	{ 0x607d, 0x786c },
	{ 0x607e, 0x786f },
	{ 0x6121, 0x7a0d },
	{ 0x6122, 0x7a08 },
	{ 0x6123, 0x7a0b },
	{ 0x6124, 0x7a05 },
	{ 0x6125, 0x7a00 },
	{ 0x6126, 0x7a98 },
	{ 0x6127, 0x7a97 },
	{ 0x6128, 0x7a96 },
	{ 0x6129, 0x7ae5 },
	{ 0x612a, 0x7ae3 },
	{ 0x612b, 0x7b49 },
	{ 0x612c, 0x7b56 },
	{ 0x612d, 0x7b46 },
	{ 0x612e, 0x7b50 },
	{ 0x612f, 0x7b52 },
	{ 0x6130, 0x7b54 },
	{ 0x6131, 0x7b4d },
	{ 0x6132, 0x7b4b },
	{ 0x6133, 0x7b4f },
	{ 0x6134, 0x7b51 },
	{ 0x6135, 0x7c9f },
	{ 0x6136, 0x7ca5 },
	{ 0x6137, 0x7d5e },
	{ 0x6138, 0x7d50 },
	{ 0x6139, 0x7d68 },
	{ 0x613a, 0x7d55 },
	{ 0x613b, 0x7d2b },
	{ 0x613c, 0x7d6e },
	{ 0x613d, 0x7d72 },
	{ 0x613e, 0x7d61 },
	{ 0x613f, 0x7d66 },
	{ 0x6140, 0x7d62 },
	{ 0x6141, 0x7d70 },
	{ 0x6142, 0x7d73 },
	{ 0x6143, 0x5584 },
	{ 0x6144, 0x7fd4 },
	{ 0x6145, 0x7fd5 },
	{ 0x6146, 0x800b },
	{ 0x6147, 0x8052 },
	{ 0x6148, 0x8085 },
	{ 0x6149, 0x8155 },
	{ 0x614a, 0x8154 },
	{ 0x614b, 0x814b },
	{ 0x614c, 0x8151 },
	{ 0x614d, 0x814e },
	{ 0x614e, 0x8139 },
	{ 0x614f, 0x8146 },
	{ 0x6150, 0x813e },
	{ 0x6151, 0x814c },
	{ 0x6152, 0x8153 },
	{ 0x6153, 0x8174 },
	{ 0x6154, 0x8212 },
	{ 0x6155, 0x821c },
	{ 0x6156, 0x83e9 },
	{ 0x6157, 0x8403 },
	{ 0x6158, 0x83f8 },
	{ 0x6159, 0x840d },
	{ 0x615a, 0x83e0 },
	{ 0x615b, 0x83c5 },
	{ 0x615c, 0x840b },
	{ 0x615d, 0x83c1 },
	{ 0x615e, 0x83ef },
	{ 0x615f, 0x83f1 },
	{ 0x6160, 0x83f4 },
	{ 0x6161, 0x8457 },
	{ 0x6162, 0x840a },
	{ 0x6163, 0x83f0 },
	{ 0x6164, 0x840c },
	{ 0x6165, 0x83cc },
	{ 0x6166, 0x83fd },
	{ 0x6167, 0x83f2 },
	{ 0x6168, 0x83ca },
	{ 0x6169, 0x8438 },
	{ 0x616a, 0x840e },
	{ 0x616b, 0x8404 },
	{ 0x616c, 0x83dc },
	{ 0x616d, 0x8407 },
	{ 0x616e, 0x83d4 },
	{ 0x616f, 0x83df },
	{ 0x6170, 0x865b },
	{ 0x6171, 0x86df },
	{ 0x6172, 0x86d9 },
	{ 0x6173, 0x86ed },
	{ 0x6174, 0x86d4 },
	{ 0x6175, 0x86db },
	{ 0x6176, 0x86e4 },
	{ 0x6177, 0x86d0 },
	{ 0x6178, 0x86de },
	{ 0x6179, 0x8857 },
	{ 0x617a, 0x88c1 },
	{ 0x617b, 0x88c2 },
	{ 0x617c, 0x88b1 },
	{ 0x617d, 0x8983 },
	{ 0x617e, 0x8996 },
	{ 0x6221, 0x8a3b },
	{ 0x6222, 0x8a60 },
	{ 0x6223, 0x8a55 },
	{ 0x6224, 0x8a5e },
	{ 0x6225, 0x8a3c },
	{ 0x6226, 0x8a41 },
	{ 0x6227, 0x8a54 },
	{ 0x6228, 0x8a5b },
	{ 0x6229, 0x8a50 },
	{ 0x622a, 0x8a46 },
	{ 0x622b, 0x8a34 },
	{ 0x622c, 0x8a3a },
	{ 0x622d, 0x8a36 },
	{ 0x622e, 0x8a56 },
	{ 0x622f, 0x8c61 },
	{ 0x6230, 0x8c82 },
	{ 0x6231, 0x8caf },
	{ 0x6232, 0x8cbc },
	{ 0x6233, 0x8cb3 },
	{ 0x6234, 0x8cbd },
	{ 0x6235, 0x8cc1 },
	{ 0x6236, 0x8cbb },
	{ 0x6237, 0x8cc0 },
	{ 0x6238, 0x8cb4 },
	{ 0x6239, 0x8cb7 },
	{ 0x623a, 0x8cb6 },
	{ 0x623b, 0x8cbf },
	{ 0x623c, 0x8cb8 },
	{ 0x623d, 0x8d8a },
	{ 0x623e, 0x8d85 },
	{ 0x623f, 0x8d81 },
	{ 0x6240, 0x8dce },
	{ 0x6241, 0x8ddd },
	{ 0x6242, 0x8dcb },
	{ 0x6243, 0x8dda },
	{ 0x6244, 0x8dd1 },
	{ 0x6245, 0x8dcc },
	{ 0x6246, 0x8ddb },
	{ 0x6247, 0x8dc6 },
	{ 0x6248, 0x8efb },
	{ 0x6249, 0x8ef8 },
	{ 0x624a, 0x8efc },
	{ 0x624b, 0x8f9c },
	{ 0x624c, 0x902e },
	{ 0x624d, 0x9035 },
	{ 0x624e, 0x9031 },
	{ 0x624f, 0x9038 },
	{ 0x6250, 0x9032 },
	{ 0x6251, 0x9036 },
	{ 0x6252, 0x9102 },
	{ 0x6253, 0x90f5 },
	{ 0x6254, 0x9109 },
	{ 0x6255, 0x90fe },
	{ 0x6256, 0x9163 },
	{ 0x6257, 0x9165 },
	{ 0x6258, 0x91cf },
	{ 0x6259, 0x9214 },
	{ 0x625a, 0x9215 },
	{ 0x625b, 0x9223 },
	{ 0x625c, 0x9209 },
	{ 0x625d, 0x921e },
	{ 0x625e, 0x920d },
	{ 0x625f, 0x9210 },
	{ 0x6260, 0x9207 },
	{ 0x6261, 0x9211 },
	{ 0x6262, 0x9594 },
	{ 0x6263, 0x958f },
	{ 0x6264, 0x958b },
	{ 0x6265, 0x9591 },
	{ 0x6266, 0x9593 },
	{ 0x6267, 0x9592 },
	{ 0x6268, 0x958e },
	{ 0x6269, 0x968a },
	{ 0x626a, 0x968e },
	{ 0x626b, 0x968b },
	{ 0x626c, 0x967d },
	{ 0x626d, 0x9685 },
	{ 0x626e, 0x9686 },
	{ 0x626f, 0x968d },
	{ 0x6270, 0x9672 },
	{ 0x6271, 0x9684 },
	{ 0x6272, 0x96c1 },
	{ 0x6273, 0x96c5 },
	{ 0x6274, 0x96c4 },
	{ 0x6275, 0x96c6 },
	{ 0x6276, 0x96c7 },
	{ 0x6277, 0x96ef },
	{ 0x6278, 0x96f2 },
	{ 0x6279, 0x97cc },
	{ 0x627a, 0x9805 },
	{ 0x627b, 0x9806 },
	{ 0x627c, 0x9808 },
	{ 0x627d, 0x98e7 },
	{ 0x627e, 0x98ea },
	{ 0x6321, 0x98ef },
	{ 0x6322, 0x98e9 },
	{ 0x6323, 0x98f2 },
	{ 0x6324, 0x98ed },
	{ 0x6325, 0x99ae },
	{ 0x6326, 0x99ad },
	{ 0x6327, 0x9ec3 },
	{ 0x6328, 0x9ecd },
	{ 0x6329, 0x9ed1 },
	{ 0x632a, 0x4e82 },
	{ 0x632b, 0x50ad },
	{ 0x632c, 0x50b5 },
	{ 0x632d, 0x50b2 },
	{ 0x632e, 0x50b3 },
	{ 0x632f, 0x50c5 },
	{ 0x6330, 0x50be },
	{ 0x6331, 0x50ac },
	{ 0x6332, 0x50b7 },
	{ 0x6333, 0x50bb },
	{ 0x6334, 0x50af },
	{ 0x6335, 0x50c7 },
	{ 0x6336, 0x527f },
	{ 0x6337, 0x5277 },
	{ 0x6338, 0x527d },
	{ 0x6339, 0x52df },
	{ 0x633a, 0x52e6 },
	{ 0x633b, 0x52e4 },
	{ 0x633c, 0x52e2 },
	{ 0x633d, 0x52e3 },
	{ 0x633e, 0x532f },
	{ 0x633f, 0x55df },
	{ 0x6340, 0x55e8 },
	{ 0x6341, 0x55d3 },
	{ 0x6342, 0x55e6 },
	{ 0x6343, 0x55ce },
	{ 0x6344, 0x55dc },
	{ 0x6345, 0x55c7 },
	{ 0x6346, 0x55d1 },
	{ 0x6347, 0x55e3 },
	{ 0x6348, 0x55e4 },
	{ 0x6349, 0x55ef },
	{ 0x634a, 0x55da },
	{ 0x634b, 0x55e1 },
	{ 0x634c, 0x55c5 },
	{ 0x634d, 0x55c6 },
	{ 0x634e, 0x55e5 },
	{ 0x634f, 0x55c9 },
	{ 0x6350, 0x5712 },
	{ 0x6351, 0x5713 },
	{ 0x6352, 0x585e },
	{ 0x6353, 0x5851 },
	{ 0x6354, 0x5858 },
	{ 0x6355, 0x5857 },
	{ 0x6356, 0x585a },
	{ 0x6357, 0x5854 },
	{ 0x6358, 0x586b },
	{ 0x6359, 0x584c },
	{ 0x635a, 0x586d },
	{ 0x635b, 0x584a },
	{ 0x635c, 0x5862 },
	{ 0x635d, 0x5852 },
	{ 0x635e, 0x584b },
	{ 0x635f, 0x5967 },
	{ 0x6360, 0x5ac1 },
	{ 0x6361, 0x5ac9 },
	{ 0x6362, 0x5acc },
	{ 0x6363, 0x5abe },
	{ 0x6364, 0x5abd },
	{ 0x6365, 0x5abc },
	{ 0x6366, 0x5ab3 },
	{ 0x6367, 0x5ac2 },
	{ 0x6368, 0x5ab2 },
	{ 0x6369, 0x5d69 },
	{ 0x636a, 0x5d6f },
	{ 0x636b, 0x5e4c },
	{ 0x636c, 0x5e79 },
	{ 0x636d, 0x5ec9 },
	{ 0x636e, 0x5ec8 },
	{ 0x636f, 0x5f12 },
	{ 0x6370, 0x5f59 },
	{ 0x6371, 0x5fac },
	{ 0x6372, 0x5fae },
	{ 0x6373, 0x611a },
	{ 0x6374, 0x610f },
	{ 0x6375, 0x6148 },
	{ 0x6376, 0x611f },
	{ 0x6377, 0x60f3 },
	{ 0x6378, 0x611b },
	{ 0x6379, 0x60f9 },
	{ 0x637a, 0x6101 },
	{ 0x637b, 0x6108 },
	{ 0x637c, 0x614e },
	{ 0x637d, 0x614c },
	{ 0x637e, 0x6144 },
	{ 0x6421, 0x614d },
	{ 0x6422, 0x613e },
	{ 0x6423, 0x6134 },
	{ 0x6424, 0x6127 },
	{ 0x6425, 0x610d },
	{ 0x6426, 0x6106 },
	{ 0x6427, 0x6137 },
	{ 0x6428, 0x6221 },
	{ 0x6429, 0x6222 },
	{ 0x642a, 0x6413 },
	{ 0x642b, 0x643e },
	{ 0x642c, 0x641e },
	{ 0x642d, 0x642a },
	{ 0x642e, 0x642d },
	{ 0x642f, 0x643d },
	{ 0x6430, 0x642c },
	{ 0x6431, 0x640f },
	{ 0x6432, 0x641c },
	{ 0x6433, 0x6414 },
	{ 0x6434, 0x640d },
	{ 0x6435, 0x6436 },
	{ 0x6436, 0x6416 },
	{ 0x6437, 0x6417 },
	{ 0x6438, 0x6406 },
	{ 0x6439, 0x656c },
	{ 0x643a, 0x659f },
	{ 0x643b, 0x65b0 },
	{ 0x643c, 0x6697 },
	{ 0x643d, 0x6689 },
	{ 0x643e, 0x6687 },
	{ 0x643f, 0x6688 },
	{ 0x6440, 0x6696 },
	{ 0x6441, 0x6684 },
	{ 0x6442, 0x6698 },
	{ 0x6443, 0x668d },
	{ 0x6444, 0x6703 },
	{ 0x6445, 0x6994 },
	{ 0x6446, 0x696d },
	{ 0x6447, 0x695a },
	{ 0x6448, 0x6977 },
	{ 0x6449, 0x6960 },
	{ 0x644a, 0x6954 },
	{ 0x644b, 0x6975 },
	{ 0x644c, 0x6930 },
	{ 0x644d, 0x6982 },
	{ 0x644e, 0x694a },
	{ 0x644f, 0x6968 },
	{ 0x6450, 0x696b },
	{ 0x6451, 0x695e },
	{ 0x6452, 0x6953 },
	{ 0x6453, 0x6979 },
	{ 0x6454, 0x6986 },
	{ 0x6455, 0x695d },
	{ 0x6456, 0x6963 },
	{ 0x6457, 0x695b },
	{ 0x6458, 0x6b47 },
	{ 0x6459, 0x6b72 },
	{ 0x645a, 0x6bc0 },
	{ 0x645b, 0x6bbf },
	{ 0x645c, 0x6bd3 },
	{ 0x645d, 0x6bfd },
	{ 0x645e, 0x6ea2 },
	{ 0x645f, 0x6eaf },
	{ 0x6460, 0x6ed3 },
	{ 0x6461, 0x6eb6 },
	{ 0x6462, 0x6ec2 },
	{ 0x6463, 0x6e90 },
	{ 0x6464, 0x6e9d },
	{ 0x6465, 0x6ec7 },
	{ 0x6466, 0x6ec5 },
	{ 0x6467, 0x6ea5 },
	{ 0x6468, 0x6e98 },
	{ 0x6469, 0x6ebc },
	{ 0x646a, 0x6eba },
	{ 0x646b, 0x6eab },
	{ 0x646c, 0x6ed1 },
	{ 0x646d, 0x6e96 },
	{ 0x646e, 0x6e9c },
	{ 0x646f, 0x6ec4 },
	{ 0x6470, 0x6ed4 },
	{ 0x6471, 0x6eaa },
	{ 0x6472, 0x6ea7 },
	{ 0x6473, 0x6eb4 },
	{ 0x6474, 0x714e },
	{ 0x6475, 0x7159 },
	{ 0x6476, 0x7169 },
	{ 0x6477, 0x7164 },
	{ 0x6478, 0x7149 },
	{ 0x6479, 0x7167 },
	{ 0x647a, 0x715c },
	{ 0x647b, 0x716c },
	{ 0x647c, 0x7166 },
	{ 0x647d, 0x714c },
	{ 0x647e, 0x7165 },
	{ 0x6521, 0x715e },
	{ 0x6522, 0x7146 },
	{ 0x6523, 0x7168 },
	{ 0x6524, 0x7156 },
	{ 0x6525, 0x723a },
	{ 0x6526, 0x7252 },
	{ 0x6527, 0x7337 },
	{ 0x6528, 0x7345 },
	{ 0x6529, 0x733f },
	{ 0x652a, 0x733e },
	{ 0x652b, 0x746f },
	{ 0x652c, 0x745a },
	{ 0x652d, 0x7455 },
	{ 0x652e, 0x745f },
	{ 0x652f, 0x745e },
	{ 0x6530, 0x7441 },
	{ 0x6531, 0x743f },
	{ 0x6532, 0x7459 },
	{ 0x6533, 0x745b },
	{ 0x6534, 0x745c },
	{ 0x6535, 0x7576 },
	{ 0x6536, 0x7578 },
	{ 0x6537, 0x7600 },
	{ 0x6538, 0x75f0 },
	{ 0x6539, 0x7601 },
	{ 0x653a, 0x75f2 },
	{ 0x653b, 0x75f1 },
	{ 0x653c, 0x75fa },
	{ 0x653d, 0x75ff },
	{ 0x653e, 0x75f4 },
	{ 0x653f, 0x75f3 },
	{ 0x6540, 0x76de },
	{ 0x6541, 0x76df },
	{ 0x6542, 0x775b },
	{ 0x6543, 0x776b },
	{ 0x6544, 0x7766 },
	{ 0x6545, 0x775e },
	{ 0x6546, 0x7763 },
	{ 0x6547, 0x7779 },
	{ 0x6548, 0x776a },
	{ 0x6549, 0x776c },
	{ 0x654a, 0x775c },
	{ 0x654b, 0x7765 },
	{ 0x654c, 0x7768 },
	{ 0x654d, 0x7762 },
	{ 0x654e, 0x77ee },
	{ 0x654f, 0x788e },
	{ 0x6550, 0x78b0 },
	{ 0x6551, 0x7897 },
	{ 0x6552, 0x7898 },
	{ 0x6553, 0x788c },
	{ 0x6554, 0x7889 },
	{ 0x6555, 0x787c },
	{ 0x6556, 0x7891 },
	{ 0x6557, 0x7893 },
	{ 0x6558, 0x787f },
	{ 0x6559, 0x797a },
	{ 0x655a, 0x797f },
	{ 0x655b, 0x7981 },
	{ 0x655c, 0x842c },
	{ 0x655d, 0x79bd },
	{ 0x655e, 0x7a1c },
	{ 0x655f, 0x7a1a },
	{ 0x6560, 0x7a20 },
	{ 0x6561, 0x7a14 },
	{ 0x6562, 0x7a1f },
	{ 0x6563, 0x7a1e },
	{ 0x6564, 0x7a9f },
	{ 0x6565, 0x7aa0 },
	{ 0x6566, 0x7b77 },
	{ 0x6567, 0x7bc0 },
	{ 0x6568, 0x7b60 },
	{ 0x6569, 0x7b6e },
	{ 0x656a, 0x7b67 },
	{ 0x656b, 0x7cb1 },
	{ 0x656c, 0x7cb3 },
	{ 0x656d, 0x7cb5 },
	{ 0x656e, 0x7d93 },
	{ 0x656f, 0x7d79 },
	{ 0x6570, 0x7d91 },
	{ 0x6571, 0x7d81 },
	{ 0x6572, 0x7d8f },
	{ 0x6573, 0x7d5b },
	{ 0x6574, 0x7f6e },
	{ 0x6575, 0x7f69 },
	{ 0x6576, 0x7f6a },
	{ 0x6577, 0x7f72 },
	{ 0x6578, 0x7fa9 },
	{ 0x6579, 0x7fa8 },
	{ 0x657a, 0x7fa4 },
	{ 0x657b, 0x8056 },
	{ 0x657c, 0x8058 },
	{ 0x657d, 0x8086 },
	{ 0x657e, 0x8084 },
	{ 0x6621, 0x8171 },
	{ 0x6622, 0x8170 },
	{ 0x6623, 0x8178 },
	{ 0x6624, 0x8165 },
	{ 0x6625, 0x816e },
	{ 0x6626, 0x8173 },
	{ 0x6627, 0x816b },
	{ 0x6628, 0x8179 },
	{ 0x6629, 0x817a },
	{ 0x662a, 0x8166 },
	{ 0x662b, 0x8205 },
	{ 0x662c, 0x8247 },
	{ 0x662d, 0x8482 },
	{ 0x662e, 0x8477 },
	{ 0x662f, 0x843d },
	{ 0x6630, 0x8431 },
	{ 0x6631, 0x8475 },
	{ 0x6632, 0x8466 },
	{ 0x6633, 0x846b },
	{ 0x6634, 0x8449 },
	{ 0x6635, 0x846c },
	{ 0x6636, 0x845b },
	{ 0x6637, 0x843c },
	{ 0x6638, 0x8435 },
	{ 0x6639, 0x8461 },
	{ 0x663a, 0x8463 },
	{ 0x663b, 0x8469 },
	{ 0x663c, 0x846d },
	{ 0x663d, 0x8446 },
	{ 0x663e, 0x865e },
	{ 0x663f, 0x865c },
	{ 0x6640, 0x865f },
	{ 0x6641, 0x86f9 },
	{ 0x6642, 0x8713 },
	{ 0x6643, 0x8708 },
	{ 0x6644, 0x8707 },
	{ 0x6645, 0x8700 },
	{ 0x6646, 0x86fe },
	{ 0x6647, 0x86fb },
	{ 0x6648, 0x8702 },
	{ 0x6649, 0x8703 },
	{ 0x664a, 0x8706 },
	{ 0x664b, 0x870a },
	{ 0x664c, 0x8859 },
	{ 0x664d, 0x88df },
	{ 0x664e, 0x88d4 },
	{ 0x664f, 0x88d9 },
	{ 0x6650, 0x88dc },
	{ 0x6651, 0x88d8 },
	{ 0x6652, 0x88dd },
	{ 0x6653, 0x88e1 },
	{ 0x6654, 0x88ca },
	{ 0x6655, 0x88d5 },
	{ 0x6656, 0x88d2 },
	{ 0x6657, 0x899c },
	{ 0x6658, 0x89e3 },
	{ 0x6659, 0x8a6b },
	{ 0x665a, 0x8a72 },
	{ 0x665b, 0x8a73 },
	{ 0x665c, 0x8a66 },
	{ 0x665d, 0x8a69 },
	{ 0x665e, 0x8a70 },
	{ 0x665f, 0x8a87 },
	{ 0x6660, 0x8a7c },
	{ 0x6661, 0x8a63 },
	{ 0x6662, 0x8aa0 },
	{ 0x6663, 0x8a71 },
	{ 0x6664, 0x8a85 },
	{ 0x6665, 0x8a6d },
	{ 0x6666, 0x8a62 },
	{ 0x6667, 0x8a6e },
	{ 0x6668, 0x8a6c },
	{ 0x6669, 0x8a79 },
	{ 0x666a, 0x8a7b },
	{ 0x666b, 0x8a3e },
	{ 0x666c, 0x8a68 },
	{ 0x666d, 0x8c62 },
	{ 0x666e, 0x8c8a },
	{ 0x666f, 0x8c89 },
	{ 0x6670, 0x8cca },
	{ 0x6671, 0x8cc7 },
	{ 0x6672, 0x8cc8 },
	{ 0x6673, 0x8cc4 },
	{ 0x6674, 0x8cb2 },
	{ 0x6675, 0x8cc3 },
	{ 0x6676, 0x8cc2 },
	{ 0x6677, 0x8cc5 },
	{ 0x6678, 0x8de1 },
	{ 0x6679, 0x8ddf },
	{ 0x667a, 0x8de8 },
	{ 0x667b, 0x8def },
	{ 0x667c, 0x8df3 },
	{ 0x667d, 0x8dfa },
	{ 0x667e, 0x8dea },
	{ 0x6721, 0x8de4 },
	{ 0x6722, 0x8de6 },
	{ 0x6723, 0x8eb2 },
	{ 0x6724, 0x8f03 },
	{ 0x6725, 0x8f09 },
	{ 0x6726, 0x8efe },
	{ 0x6727, 0x8f0a },
	{ 0x6728, 0x8f9f },
	{ 0x6729, 0x8fb2 },
	{ 0x672a, 0x904b },
	{ 0x672b, 0x904a },
	{ 0x672c, 0x9053 },
	{ 0x672d, 0x9042 },
	{ 0x672e, 0x9054 },
	{ 0x672f, 0x903c },
	{ 0x6730, 0x9055 },
	{ 0x6731, 0x9050 },
	{ 0x6732, 0x9047 },
	{ 0x6733, 0x904f },
	{ 0x6734, 0x904e },
	{ 0x6735, 0x904d },
	{ 0x6736, 0x9051 },
	{ 0x6737, 0x903e },
	{ 0x6738, 0x9041 },
	{ 0x6739, 0x9112 },
	{ 0x673a, 0x9117 },
	{ 0x673b, 0x916c },
	{ 0x673c, 0x916a },
	{ 0x673d, 0x9169 },
	{ 0x673e, 0x91c9 },
	{ 0x673f, 0x9237 },
	{ 0x6740, 0x9257 },
	{ 0x6741, 0x9238 },
	{ 0x6742, 0x923d },
	{ 0x6743, 0x9240 },
	{ 0x6744, 0x923e },
	{ 0x6745, 0x925b },
	{ 0x6746, 0x924b },
	{ 0x6747, 0x9264 },
	{ 0x6748, 0x9251 },
	{ 0x6749, 0x9234 },
	{ 0x674a, 0x9249 },
	{ 0x674b, 0x924d },
	{ 0x674c, 0x9245 },
	{ 0x674d, 0x9239 },
	{ 0x674e, 0x923f },
	{ 0x674f, 0x925a },
	{ 0x6750, 0x9598 },
	{ 0x6751, 0x9698 },
	{ 0x6752, 0x9694 },
	{ 0x6753, 0x9695 },
	{ 0x6754, 0x96cd },
	{ 0x6755, 0x96cb },
	{ 0x6756, 0x96c9 },
	{ 0x6757, 0x96ca },
	{ 0x6758, 0x96f7 },
	{ 0x6759, 0x96fb },
	{ 0x675a, 0x96f9 },
	{ 0x675b, 0x96f6 },
	{ 0x675c, 0x9756 },
	{ 0x675d, 0x9774 },
	{ 0x675e, 0x9776 },
	{ 0x675f, 0x9810 },
	{ 0x6760, 0x9811 },
	{ 0x6761, 0x9813 },
	{ 0x6762, 0x980a },
	{ 0x6763, 0x9812 },
	{ 0x6764, 0x980c },
	{ 0x6765, 0x98fc },
	{ 0x6766, 0x98f4 },
	{ 0x6767, 0x98fd },
	{ 0x6768, 0x98fe },
	{ 0x6769, 0x99b3 },
	{ 0x676a, 0x99b1 },
	{ 0x676b, 0x99b4 },
	{ 0x676c, 0x9ae1 },
	{ 0x676d, 0x9ce9 },
	{ 0x676e, 0x9e82 },
	{ 0x676f, 0x9f0e },
	{ 0x6770, 0x9f13 },
	{ 0x6771, 0x9f20 },
	{ 0x6772, 0x50e7 },
	{ 0x6773, 0x50ee },
	{ 0x6774, 0x50e5 },
	{ 0x6775, 0x50d6 },
	{ 0x6776, 0x50ed },
	{ 0x6777, 0x50da },
	{ 0x6778, 0x50d5 },
	{ 0x6779, 0x50cf },
	{ 0x677a, 0x50d1 },
	{ 0x677b, 0x50f1 },
	{ 0x677c, 0x50ce },
	{ 0x677d, 0x50e9 },
	{ 0x677e, 0x5162 },
	{ 0x6821, 0x51f3 },
	{ 0x6822, 0x5283 },
	{ 0x6823, 0x5282 },
	{ 0x6824, 0x5331 },
	{ 0x6825, 0x53ad },
	{ 0x6826, 0x55fe },
	{ 0x6827, 0x5600 },
	{ 0x6828, 0x561b },
	{ 0x6829, 0x5617 },
	{ 0x682a, 0x55fd },
	{ 0x682b, 0x5614 },
	{ 0x682c, 0x5606 },
	{ 0x682d, 0x5609 },
	{ 0x682e, 0x560d },
	{ 0x682f, 0x560e },
	{ 0x6830, 0x55f7 },
	{ 0x6831, 0x5616 },
	{ 0x6832, 0x561f },
	{ 0x6833, 0x5608 },
	{ 0x6834, 0x5610 },
	{ 0x6835, 0x55f6 },
	{ 0x6836, 0x5718 },
	{ 0x6837, 0x5716 },
	{ 0x6838, 0x5875 },
	{ 0x6839, 0x587e },
	{ 0x683a, 0x5883 },
	{ 0x683b, 0x5893 },
	{ 0x683c, 0x588a },
	{ 0x683d, 0x5879 },
	{ 0x683e, 0x5885 },
	{ 0x683f, 0x587d },
	{ 0x6840, 0x58fd },
	{ 0x6841, 0x5925 },
	{ 0x6842, 0x5922 },
	{ 0x6843, 0x5924 },
	{ 0x6844, 0x596a },
	{ 0x6845, 0x5969 },
	{ 0x6846, 0x5ae1 },
	{ 0x6847, 0x5ae6 },
	{ 0x6848, 0x5ae9 },
	{ 0x6849, 0x5ad7 },
	{ 0x684a, 0x5ad6 },
	{ 0x684b, 0x5ad8 },
	{ 0x684c, 0x5ae3 },
	{ 0x684d, 0x5b75 },
	{ 0x684e, 0x5bde },
	{ 0x684f, 0x5be7 },
	{ 0x6850, 0x5be1 },
	{ 0x6851, 0x5be5 },
	{ 0x6852, 0x5be6 },
	{ 0x6853, 0x5be8 },
	{ 0x6854, 0x5be2 },
	{ 0x6855, 0x5be4 },
	{ 0x6856, 0x5bdf },
	{ 0x6857, 0x5c0d },
	{ 0x6858, 0x5c62 },
	{ 0x6859, 0x5d84 },
	{ 0x685a, 0x5d87 },
	{ 0x685b, 0x5e5b },
	{ 0x685c, 0x5e63 },
	{ 0x685d, 0x5e55 },
	{ 0x685e, 0x5e57 },
	{ 0x685f, 0x5e54 },
	{ 0x6860, 0x5ed3 },
	{ 0x6861, 0x5ed6 },
	{ 0x6862, 0x5f0a },
	{ 0x6863, 0x5f46 },
	{ 0x6864, 0x5f70 },
	{ 0x6865, 0x5fb9 },
	{ 0x6866, 0x6147 },
	{ 0x6867, 0x613f },
	{ 0x6868, 0x614b },
	{ 0x6869, 0x6177 },
	{ 0x686a, 0x6162 },
	{ 0x686b, 0x6163 },
	{ 0x686c, 0x615f },
	{ 0x686d, 0x615a },
	{ 0x686e, 0x6158 },
	{ 0x686f, 0x6175 },
	{ 0x6870, 0x622a },
	{ 0x6871, 0x6487 },
	{ 0x6872, 0x6458 },
	{ 0x6873, 0x6454 },
	{ 0x6874, 0x64a4 },
	{ 0x6875, 0x6478 },
	{ 0x6876, 0x645f },
	{ 0x6877, 0x647a },
	{ 0x6878, 0x6451 },
	{ 0x6879, 0x6467 },
	{ 0x687a, 0x6434 },
	{ 0x687b, 0x646d },
	{ 0x687c, 0x647b },
	{ 0x687d, 0x6572 },
	{ 0x687e, 0x65a1 },
	{ 0x6921, 0x65d7 },
	{ 0x6922, 0x65d6 },
	{ 0x6923, 0x66a2 },
	{ 0x6924, 0x66a8 },
	{ 0x6925, 0x669d },
	{ 0x6926, 0x699c },
	{ 0x6927, 0x69a8 },
	{ 0x6928, 0x6995 },
	{ 0x6929, 0x69c1 },
	{ 0x692a, 0x69ae },
	{ 0x692b, 0x69d3 },
	{ 0x692c, 0x69cb },
	{ 0x692d, 0x699b },
	{ 0x692e, 0x69b7 },
	{ 0x692f, 0x69bb },
	{ 0x6930, 0x69ab },
	{ 0x6931, 0x69b4 },
	{ 0x6932, 0x69d0 },
	{ 0x6933, 0x69cd },
	{ 0x6934, 0x69ad },
	{ 0x6935, 0x69cc },
	{ 0x6936, 0x69a6 },
	{ 0x6937, 0x69c3 },
	{ 0x6938, 0x69a3 },
	{ 0x6939, 0x6b49 },
	{ 0x693a, 0x6b4c },
	{ 0x693b, 0x6c33 },
	{ 0x693c, 0x6f33 },
	{ 0x693d, 0x6f14 },
	{ 0x693e, 0x6efe },
	{ 0x693f, 0x6f13 },
	{ 0x6940, 0x6ef4 },
	{ 0x6941, 0x6f29 },
	{ 0x6942, 0x6f3e },
	{ 0x6943, 0x6f20 },
	{ 0x6944, 0x6f2c },
	{ 0x6945, 0x6f0f },
	{ 0x6946, 0x6f02 },
	{ 0x6947, 0x6f22 },
	{ 0x6948, 0x6eff },
	{ 0x6949, 0x6eef },
	{ 0x694a, 0x6f06 },
	{ 0x694b, 0x6f31 },
	{ 0x694c, 0x6f38 },
	{ 0x694d, 0x6f32 },
	{ 0x694e, 0x6f23 },
	{ 0x694f, 0x6f15 },
	{ 0x6950, 0x6f2b },
	{ 0x6951, 0x6f2f },
	{ 0x6952, 0x6f88 },
	{ 0x6953, 0x6f2a },
	{ 0x6954, 0x6eec },
	{ 0x6955, 0x6f01 },
	{ 0x6956, 0x6ef2 },
	{ 0x6957, 0x6ecc },
	{ 0x6958, 0x6ef7 },
	{ 0x6959, 0x7194 },
	{ 0x695a, 0x7199 },
	{ 0x695b, 0x717d },
	{ 0x695c, 0x718a },
	{ 0x695d, 0x7184 },
	{ 0x695e, 0x7192 },
	{ 0x695f, 0x723e },
	{ 0x6960, 0x7292 },
	{ 0x6961, 0x7296 },
	{ 0x6962, 0x7344 },
	{ 0x6963, 0x7350 },
	{ 0x6964, 0x7464 },
	{ 0x6965, 0x7463 },
	{ 0x6966, 0x746a },
	{ 0x6967, 0x7470 },
	{ 0x6968, 0x746d },
	{ 0x6969, 0x7504 },
	{ 0x696a, 0x7591 },
	{ 0x696b, 0x7627 },
	{ 0x696c, 0x760d },
	{ 0x696d, 0x760b },
	{ 0x696e, 0x7609 },
	{ 0x696f, 0x7613 },
	{ 0x6970, 0x76e1 },
	{ 0x6971, 0x76e3 },
	{ 0x6972, 0x7784 },
	{ 0x6973, 0x777d },
	{ 0x6974, 0x777f },
	{ 0x6975, 0x7761 },
	{ 0x6976, 0x78c1 },
	{ 0x6977, 0x789f },
	{ 0x6978, 0x78a7 },
	{ 0x6979, 0x78b3 },
	{ 0x697a, 0x78a9 },
	{ 0x697b, 0x78a3 },
	{ 0x697c, 0x798e },
	{ 0x697d, 0x798f },
	{ 0x697e, 0x798d },
	{ 0x6a21, 0x7a2e },
	{ 0x6a22, 0x7a31 },
	{ 0x6a23, 0x7aaa },
	{ 0x6a24, 0x7aa9 },
	{ 0x6a25, 0x7aed },
	{ 0x6a26, 0x7aef },
	{ 0x6a27, 0x7ba1 },
	{ 0x6a28, 0x7b95 },
	{ 0x6a29, 0x7b8b },
	{ 0x6a2a, 0x7b75 },
	{ 0x6a2b, 0x7b97 },
	{ 0x6a2c, 0x7b9d },
	{ 0x6a2d, 0x7b94 },
	{ 0x6a2e, 0x7b8f },
	{ 0x6a2f, 0x7bb8 },
	{ 0x6a30, 0x7b87 },
	{ 0x6a31, 0x7b84 },
	{ 0x6a32, 0x7cb9 },
	{ 0x6a33, 0x7cbd },
	{ 0x6a34, 0x7cbe },
	{ 0x6a35, 0x7dbb },
	{ 0x6a36, 0x7db0 },
	{ 0x6a37, 0x7d9c },
	{ 0x6a38, 0x7dbd },
	{ 0x6a39, 0x7dbe },
	{ 0x6a3a, 0x7da0 },
	{ 0x6a3b, 0x7dca },
	{ 0x6a3c, 0x7db4 },
	{ 0x6a3d, 0x7db2 },
	{ 0x6a3e, 0x7db1 },
	{ 0x6a3f, 0x7dba },
	{ 0x6a40, 0x7da2 },
	{ 0x6a41, 0x7dbf },
	{ 0x6a42, 0x7db5 },
	{ 0x6a43, 0x7db8 },
	{ 0x6a44, 0x7dad },
	{ 0x6a45, 0x7dd2 },
	{ 0x6a46, 0x7dc7 },
	{ 0x6a47, 0x7dac },
	{ 0x6a48, 0x7f70 },
	{ 0x6a49, 0x7fe0 },
	{ 0x6a4a, 0x7fe1 },
	{ 0x6a4b, 0x7fdf },
	{ 0x6a4c, 0x805e },
	{ 0x6a4d, 0x805a },
	{ 0x6a4e, 0x8087 },
	{ 0x6a4f, 0x8150 },
	{ 0x6a50, 0x8180 },
	{ 0x6a51, 0x818f },
	{ 0x6a52, 0x8188 },
	{ 0x6a53, 0x818a },
	{ 0x6a54, 0x817f },
	{ 0x6a55, 0x8182 },
	{ 0x6a56, 0x81e7 },
	{ 0x6a57, 0x81fa },
	{ 0x6a58, 0x8207 },
	{ 0x6a59, 0x8214 },
	{ 0x6a5a, 0x821e },
	{ 0x6a5b, 0x824b },
	{ 0x6a5c, 0x84c9 },
	{ 0x6a5d, 0x84bf },
	{ 0x6a5e, 0x84c6 },
	{ 0x6a5f, 0x84c4 },
	{ 0x6a60, 0x8499 },
	{ 0x6a61, 0x849e },
	{ 0x6a62, 0x84b2 },
	{ 0x6a63, 0x849c },
	{ 0x6a64, 0x84cb },
	{ 0x6a65, 0x84b8 },
	{ 0x6a66, 0x84c0 },
	{ 0x6a67, 0x84d3 },
	{ 0x6a68, 0x8490 },
	{ 0x6a69, 0x84bc },
	{ 0x6a6a, 0x84d1 },
	{ 0x6a6b, 0x84ca },
	{ 0x6a6c, 0x873f },
	{ 0x6a6d, 0x871c },
	{ 0x6a6e, 0x873b },
	{ 0x6a6f, 0x8722 },
	{ 0x6a70, 0x8725 },
	{ 0x6a71, 0x8734 },
	{ 0x6a72, 0x8718 },
	{ 0x6a73, 0x8755 },
	{ 0x6a74, 0x8737 },
	{ 0x6a75, 0x8729 },
	{ 0x6a76, 0x88f3 },
	{ 0x6a77, 0x8902 },
	{ 0x6a78, 0x88f4 },
	{ 0x6a79, 0x88f9 },
	{ 0x6a7a, 0x88f8 },
	{ 0x6a7b, 0x88fd },
	{ 0x6a7c, 0x88e8 },
	{ 0x6a7d, 0x891a },
	{ 0x6a7e, 0x88ef },
	{ 0x6b21, 0x8aa6 },
	{ 0x6b22, 0x8a8c },
	{ 0x6b23, 0x8a9e },
	{ 0x6b24, 0x8aa3 },
	{ 0x6b25, 0x8a8d },
	{ 0x6b26, 0x8aa1 },
	{ 0x6b27, 0x8a93 },
	{ 0x6b28, 0x8aa4 },
	{ 0x6b29, 0x8aaa },
	{ 0x6b2a, 0x8aa5 },
	{ 0x6b2b, 0x8aa8 },
	{ 0x6b2c, 0x8a98 },
	{ 0x6b2d, 0x8a91 },
	{ 0x6b2e, 0x8a9a },
	{ 0x6b2f, 0x8aa7 },
	{ 0x6b30, 0x8c6a },
	{ 0x6b31, 0x8c8d },
	{ 0x6b32, 0x8c8c },
	{ 0x6b33, 0x8cd3 },
	{ 0x6b34, 0x8cd1 },
	{ 0x6b35, 0x8cd2 },
	{ 0x6b36, 0x8d6b },
	{ 0x6b37, 0x8d99 },
	{ 0x6b38, 0x8d95 },
	{ 0x6b39, 0x8dfc },
	{ 0x6b3a, 0x8f14 },
	{ 0x6b3b, 0x8f12 },
	{ 0x6b3c, 0x8f15 },
	{ 0x6b3d, 0x8f13 },
	{ 0x6b3e, 0x8fa3 },
	{ 0x6b3f, 0x9060 },
	{ 0x6b40, 0x9058 },
	{ 0x6b41, 0x905c },
	{ 0x6b42, 0x9063 },
	{ 0x6b43, 0x9059 },
	{ 0x6b44, 0x905e },
	{ 0x6b45, 0x9062 },
	{ 0x6b46, 0x905d },
	{ 0x6b47, 0x905b },
	{ 0x6b48, 0x9119 },
	{ 0x6b49, 0x9118 },
	{ 0x6b4a, 0x911e },
	{ 0x6b4b, 0x9175 },
	{ 0x6b4c, 0x9178 },
	{ 0x6b4d, 0x9177 },
	{ 0x6b4e, 0x9174 },
	{ 0x6b4f, 0x9278 },
	{ 0x6b50, 0x92ac },
	{ 0x6b51, 0x9280 },
	{ 0x6b52, 0x9285 },
	{ 0x6b53, 0x9298 },
	{ 0x6b54, 0x9296 },
	{ 0x6b55, 0x927b },
	{ 0x6b56, 0x9293 },
	{ 0x6b57, 0x929c },
	{ 0x6b58, 0x92a8 },
	{ 0x6b59, 0x927c },
	{ 0x6b5a, 0x9291 },
	{ 0x6b5b, 0x95a1 },
	{ 0x6b5c, 0x95a8 },
	{ 0x6b5d, 0x95a9 },
	{ 0x6b5e, 0x95a3 },
	{ 0x6b5f, 0x95a5 },
	{ 0x6b60, 0x95a4 },
	{ 0x6b61, 0x9699 },
	{ 0x6b62, 0x969c },
	{ 0x6b63, 0x969b },
	{ 0x6b64, 0x96cc },
	{ 0x6b65, 0x96d2 },
	{ 0x6b66, 0x9700 },
	{ 0x6b67, 0x977c },
	{ 0x6b68, 0x9785 },
	{ 0x6b69, 0x97f6 },
	{ 0x6b6a, 0x9817 },
	{ 0x6b6b, 0x9818 },
	{ 0x6b6c, 0x98af },
	{ 0x6b6d, 0x98b1 },
	{ 0x6b6e, 0x9903 },
	{ 0x6b6f, 0x9905 },
	{ 0x6b70, 0x990c },
	{ 0x6b71, 0x9909 },
	{ 0x6b72, 0x99c1 },
	{ 0x6b73, 0x9aaf },
	{ 0x6b74, 0x9ab0 },
	{ 0x6b75, 0x9ae6 },
	{ 0x6b76, 0x9b41 },
	{ 0x6b77, 0x9b42 },
	{ 0x6b78, 0x9cf4 },
	{ 0x6b79, 0x9cf6 },
	{ 0x6b7a, 0x9cf3 },
	{ 0x6b7b, 0x9ebc },
	{ 0x6b7c, 0x9f3b },
	{ 0x6b7d, 0x9f4a },
	{ 0x6b7e, 0x5104 },
	{ 0x6c21, 0x5100 },
	{ 0x6c22, 0x50fb },
	{ 0x6c23, 0x50f5 },
	{ 0x6c24, 0x50f9 },
	{ 0x6c25, 0x5102 },
	{ 0x6c26, 0x5108 },
	{ 0x6c27, 0x5109 },
	{ 0x6c28, 0x5105 },
	{ 0x6c29, 0x51dc },
	{ 0x6c2a, 0x5287 },
	{ 0x6c2b, 0x5288 },
	{ 0x6c2c, 0x5289 },
	{ 0x6c2d, 0x528d },
	{ 0x6c2e, 0x528a },
	{ 0x6c2f, 0x52f0 },
	{ 0x6c30, 0x53b2 },
	{ 0x6c31, 0x562e },
	{ 0x6c32, 0x563b },
	{ 0x6c33, 0x5639 },
	{ 0x6c34, 0x5632 },
	{ 0x6c35, 0x563f },
	{ 0x6c36, 0x5634 },
	{ 0x6c37, 0x5629 },
	{ 0x6c38, 0x5653 },
	{ 0x6c39, 0x564e },
	{ 0x6c3a, 0x5657 },
	{ 0x6c3b, 0x5674 },
	{ 0x6c3c, 0x5636 },
	{ 0x6c3d, 0x562f },
	{ 0x6c3e, 0x5630 },
	{ 0x6c3f, 0x5880 },
	{ 0x6c40, 0x589f },
	{ 0x6c41, 0x589e },
	{ 0x6c42, 0x58b3 },
	{ 0x6c43, 0x589c },
	{ 0x6c44, 0x58ae },
	{ 0x6c45, 0x58a9 },
	{ 0x6c46, 0x58a6 },
	{ 0x6c47, 0x596d },
	{ 0x6c48, 0x5b09 },
	{ 0x6c49, 0x5afb },
	{ 0x6c4a, 0x5b0b },
	{ 0x6c4b, 0x5af5 },
	{ 0x6c4c, 0x5b0c },
	{ 0x6c4d, 0x5b08 },
	{ 0x6c4e, 0x5bee },
	{ 0x6c4f, 0x5bec },
	{ 0x6c50, 0x5be9 },
	{ 0x6c51, 0x5beb },
	{ 0x6c52, 0x5c64 },
	{ 0x6c53, 0x5c65 },
	{ 0x6c54, 0x5d9d },
	{ 0x6c55, 0x5d94 },
	{ 0x6c56, 0x5e62 },
	{ 0x6c57, 0x5e5f },
	{ 0x6c58, 0x5e61 },
	{ 0x6c59, 0x5ee2 },
	{ 0x6c5a, 0x5eda },
	{ 0x6c5b, 0x5edf },
	{ 0x6c5c, 0x5edd },
	{ 0x6c5d, 0x5ee3 },
	{ 0x6c5e, 0x5ee0 },
	{ 0x6c5f, 0x5f48 },
	{ 0x6c60, 0x5f71 },
	{ 0x6c61, 0x5fb7 },
	{ 0x6c62, 0x5fb5 },
	{ 0x6c63, 0x6176 },
	{ 0x6c64, 0x6167 },
	{ 0x6c65, 0x616e },
	{ 0x6c66, 0x615d },
	{ 0x6c67, 0x6155 },
	{ 0x6c68, 0x6182 },
	{ 0x6c69, 0x617c },
	{ 0x6c6a, 0x6170 },
	{ 0x6c6b, 0x616b },
	{ 0x6c6c, 0x617e },
	{ 0x6c6d, 0x61a7 },
	{ 0x6c6e, 0x6190 },
	{ 0x6c6f, 0x61ab },
	{ 0x6c70, 0x618e },
	{ 0x6c71, 0x61ac },
	{ 0x6c72, 0x619a },
	{ 0x6c73, 0x61a4 },
	{ 0x6c74, 0x6194 },
	{ 0x6c75, 0x61ae },
	{ 0x6c76, 0x622e },
	{ 0x6c77, 0x6469 },
	{ 0x6c78, 0x646f },
	{ 0x6c79, 0x6479 },
	{ 0x6c7a, 0x649e },
	{ 0x6c7b, 0x64b2 },
	{ 0x6c7c, 0x6488 },
	{ 0x6c7d, 0x6490 },
	{ 0x6c7e, 0x64b0 },
	{ 0x6d21, 0x64a5 },
	{ 0x6d22, 0x6493 },
	{ 0x6d23, 0x6495 },
	{ 0x6d24, 0x64a9 },
	{ 0x6d25, 0x6492 },
	{ 0x6d26, 0x64ae },
	{ 0x6d27, 0x64ad },
	{ 0x6d28, 0x64ab },
	{ 0x6d29, 0x649a },
	{ 0x6d2a, 0x64ac },
	{ 0x6d2b, 0x6499 },
	{ 0x6d2c, 0x64a2 },
	{ 0x6d2d, 0x64b3 },
	{ 0x6d2e, 0x6575 },
	{ 0x6d2f, 0x6577 },
	{ 0x6d30, 0x6578 },
	{ 0x6d31, 0x66ae },
	{ 0x6d32, 0x66ab },
	{ 0x6d33, 0x66b4 },
	{ 0x6d34, 0x66b1 },
	{ 0x6d35, 0x6a23 },
	{ 0x6d36, 0x6a1f },
	{ 0x6d37, 0x69e8 },
	{ 0x6d38, 0x6a01 },
	{ 0x6d39, 0x6a1e },
	{ 0x6d3a, 0x6a19 },
	{ 0x6d3b, 0x69fd },
	{ 0x6d3c, 0x6a21 },
	{ 0x6d3d, 0x6a13 },
	{ 0x6d3e, 0x6a0a },
	{ 0x6d3f, 0x69f3 },
	{ 0x6d40, 0x6a02 },
	{ 0x6d41, 0x6a05 },
	{ 0x6d42, 0x69ed },
	{ 0x6d43, 0x6a11 },
	{ 0x6d44, 0x6b50 },
	{ 0x6d45, 0x6b4e },
	{ 0x6d46, 0x6ba4 },
	{ 0x6d47, 0x6bc5 },
	{ 0x6d48, 0x6bc6 },
	{ 0x6d49, 0x6f3f },
	{ 0x6d4a, 0x6f7c },
	{ 0x6d4b, 0x6f84 },
	{ 0x6d4c, 0x6f51 },
	{ 0x6d4d, 0x6f66 },
	{ 0x6d4e, 0x6f54 },
	{ 0x6d4f, 0x6f86 },
	{ 0x6d50, 0x6f6d },
	{ 0x6d51, 0x6f5b },
	{ 0x6d52, 0x6f78 },
	{ 0x6d53, 0x6f6e },
	{ 0x6d54, 0x6f8e },
	{ 0x6d55, 0x6f7a },
	{ 0x6d56, 0x6f70 },
	{ 0x6d57, 0x6f64 },
	{ 0x6d58, 0x6f97 },
	{ 0x6d59, 0x6f58 },
	{ 0x6d5a, 0x6ed5 },
	{ 0x6d5b, 0x6f6f },
	{ 0x6d5c, 0x6f60 },
	{ 0x6d5d, 0x6f5f },
	{ 0x6d5e, 0x719f },
	{ 0x6d5f, 0x71ac },
	{ 0x6d60, 0x71b1 },
	{ 0x6d61, 0x71a8 },
	{ 0x6d62, 0x7256 },
	{ 0x6d63, 0x729b },
	{ 0x6d64, 0x734e },
	{ 0x6d65, 0x7357 },
	{ 0x6d66, 0x7469 },
	{ 0x6d67, 0x748b },
	{ 0x6d68, 0x7483 },
	{ 0x6d69, 0x747e },
	{ 0x6d6a, 0x7480 },
	{ 0x6d6b, 0x757f },
	{ 0x6d6c, 0x7620 },
	{ 0x6d6d, 0x7629 },
	{ 0x6d6e, 0x761f },
	{ 0x6d6f, 0x7624 },
	{ 0x6d70, 0x7626 },
	{ 0x6d71, 0x7621 },
	{ 0x6d72, 0x7622 },
	{ 0x6d73, 0x769a },
	{ 0x6d74, 0x76ba },
	{ 0x6d75, 0x76e4 },
	{ 0x6d76, 0x778e },
	{ 0x6d77, 0x7787 },
	{ 0x6d78, 0x778c },
	{ 0x6d79, 0x7791 },
	{ 0x6d7a, 0x778b },
	{ 0x6d7b, 0x78cb },
	{ 0x6d7c, 0x78c5 },
	{ 0x6d7d, 0x78ba },
	{ 0x6d7e, 0x78ca },
	{ 0x6e21, 0x78be },
	{ 0x6e22, 0x78d5 },
	{ 0x6e23, 0x78bc },
	{ 0x6e24, 0x78d0 },
	{ 0x6e25, 0x7a3f },
	{ 0x6e26, 0x7a3c },
	{ 0x6e27, 0x7a40 },
	{ 0x6e28, 0x7a3d },
	{ 0x6e29, 0x7a37 },
	{ 0x6e2a, 0x7a3b },
	{ 0x6e2b, 0x7aaf },
	{ 0x6e2c, 0x7aae },
	{ 0x6e2d, 0x7bad },
	{ 0x6e2e, 0x7bb1 },
	{ 0x6e2f, 0x7bc4 },
	{ 0x6e30, 0x7bb4 },
	{ 0x6e31, 0x7bc6 },
	{ 0x6e32, 0x7bc7 },
	{ 0x6e33, 0x7bc1 },
	{ 0x6e34, 0x7ba0 },
	{ 0x6e35, 0x7bcc },
	{ 0x6e36, 0x7cca },
	{ 0x6e37, 0x7de0 },
	{ 0x6e38, 0x7df4 },
	{ 0x6e39, 0x7def },
	{ 0x6e3a, 0x7dfb },
	{ 0x6e3b, 0x7dd8 },
	{ 0x6e3c, 0x7dec },
	{ 0x6e3d, 0x7ddd },
	{ 0x6e3e, 0x7de8 },
	{ 0x6e3f, 0x7de3 },
	{ 0x6e40, 0x7dda },
	{ 0x6e41, 0x7dde },
	{ 0x6e42, 0x7de9 },
	{ 0x6e43, 0x7d9e },
	{ 0x6e44, 0x7dd9 },
	{ 0x6e45, 0x7df2 },
	{ 0x6e46, 0x7df9 },
	{ 0x6e47, 0x7f75 },
	{ 0x6e48, 0x7f77 },
	{ 0x6e49, 0x7faf },
	{ 0x6e4a, 0x7fe9 },
	{ 0x6e4b, 0x8026 },
	{ 0x6e4c, 0x819b },
	{ 0x6e4d, 0x819c },
	{ 0x6e4e, 0x819d },
	{ 0x6e4f, 0x81a0 },
	{ 0x6e50, 0x819a },
	{ 0x6e51, 0x8198 },
	{ 0x6e52, 0x8517 },
	{ 0x6e53, 0x853d },
	{ 0x6e54, 0x851a },
	{ 0x6e55, 0x84ee },
	{ 0x6e56, 0x852c },
	{ 0x6e57, 0x852d },
	{ 0x6e58, 0x8513 },
	{ 0x6e59, 0x8511 },
	{ 0x6e5a, 0x8523 },
	{ 0x6e5b, 0x8521 },
	{ 0x6e5c, 0x8514 },
	{ 0x6e5d, 0x84ec },
	{ 0x6e5e, 0x8525 },
	{ 0x6e5f, 0x84ff },
	{ 0x6e60, 0x8506 },
	{ 0x6e61, 0x8782 },
	{ 0x6e62, 0x8774 },
	{ 0x6e63, 0x8776 },
	{ 0x6e64, 0x8760 },
	{ 0x6e65, 0x8766 },
	{ 0x6e66, 0x8778 },
	{ 0x6e67, 0x8768 },
	{ 0x6e68, 0x8759 },
	{ 0x6e69, 0x8757 },
	{ 0x6e6a, 0x874c },
	{ 0x6e6b, 0x8753 },
	{ 0x6e6c, 0x885b },
	{ 0x6e6d, 0x885d },
	{ 0x6e6e, 0x8910 },
	{ 0x6e6f, 0x8907 },
	{ 0x6e70, 0x8912 },
	{ 0x6e71, 0x8913 },
	{ 0x6e72, 0x8915 },
	{ 0x6e73, 0x890a },
	{ 0x6e74, 0x8abc },
	{ 0x6e75, 0x8ad2 },
	{ 0x6e76, 0x8ac7 },
	{ 0x6e77, 0x8ac4 },
	{ 0x6e78, 0x8a95 },
	{ 0x6e79, 0x8acb },
	{ 0x6e7a, 0x8af8 },
	{ 0x6e7b, 0x8ab2 },
	{ 0x6e7c, 0x8ac9 },
	{ 0x6e7d, 0x8ac2 },
	{ 0x6e7e, 0x8abf },
	{ 0x6f21, 0x8ab0 },
	{ 0x6f22, 0x8ad6 },
	{ 0x6f23, 0x8acd },
	{ 0x6f24, 0x8ab6 },
	{ 0x6f25, 0x8ab9 },
	{ 0x6f26, 0x8adb },
	{ 0x6f27, 0x8c4c },
	{ 0x6f28, 0x8c4e },
	{ 0x6f29, 0x8c6c },
	{ 0x6f2a, 0x8ce0 },
	{ 0x6f2b, 0x8cde },
	{ 0x6f2c, 0x8ce6 },
	{ 0x6f2d, 0x8ce4 },
	{ 0x6f2e, 0x8cec },
	{ 0x6f2f, 0x8ced },
	{ 0x6f30, 0x8ce2 },
	{ 0x6f31, 0x8ce3 },
	{ 0x6f32, 0x8cdc },
	{ 0x6f33, 0x8cea },
	{ 0x6f34, 0x8ce1 },
	{ 0x6f35, 0x8d6d },
	{ 0x6f36, 0x8d9f },
	{ 0x6f37, 0x8da3 },
	{ 0x6f38, 0x8e2b },
	{ 0x6f39, 0x8e10 },
	{ 0x6f3a, 0x8e1d },
	{ 0x6f3b, 0x8e22 },
	{ 0x6f3c, 0x8e0f },
	{ 0x6f3d, 0x8e29 },
	{ 0x6f3e, 0x8e1f },
	{ 0x6f3f, 0x8e21 },
	{ 0x6f40, 0x8e1e },
	{ 0x6f41, 0x8eba },
	{ 0x6f42, 0x8f1d },
	{ 0x6f43, 0x8f1b },
	{ 0x6f44, 0x8f1f },
	{ 0x6f45, 0x8f29 },
	{ 0x6f46, 0x8f26 },
	{ 0x6f47, 0x8f2a },
	{ 0x6f48, 0x8f1c },
	{ 0x6f49, 0x8f1e },
	{ 0x6f4a, 0x8f25 },
	{ 0x6f4b, 0x9069 },
	{ 0x6f4c, 0x906e },
	{ 0x6f4d, 0x9068 },
	{ 0x6f4e, 0x906d },
	{ 0x6f4f, 0x9077 },
	{ 0x6f50, 0x9130 },
	{ 0x6f51, 0x912d },
	{ 0x6f52, 0x9127 },
	{ 0x6f53, 0x9131 },
	{ 0x6f54, 0x9187 },
	{ 0x6f55, 0x9189 },
	{ 0x6f56, 0x918b },
	{ 0x6f57, 0x9183 },
	{ 0x6f58, 0x92c5 },
	{ 0x6f59, 0x92bb },
	{ 0x6f5a, 0x92b7 },
	{ 0x6f5b, 0x92ea },
	{ 0x6f5c, 0x92e4 },
	{ 0x6f5d, 0x92c1 },
	{ 0x6f5e, 0x92b3 },
	{ 0x6f5f, 0x92bc },
	{ 0x6f60, 0x92d2 },
	{ 0x6f61, 0x92c7 },
	{ 0x6f62, 0x92f0 },
	{ 0x6f63, 0x92b2 },
	{ 0x6f64, 0x95ad },
	{ 0x6f65, 0x95b1 },
	{ 0x6f66, 0x9704 },
	{ 0x6f67, 0x9706 },
	{ 0x6f68, 0x9707 },
	{ 0x6f69, 0x9709 },
	{ 0x6f6a, 0x9760 },
	{ 0x6f6b, 0x978d },
	{ 0x6f6c, 0x978b },
	{ 0x6f6d, 0x978f },
	{ 0x6f6e, 0x9821 },
	{ 0x6f6f, 0x982b },
	{ 0x6f70, 0x981c },
	{ 0x6f71, 0x98b3 },
	{ 0x6f72, 0x990a },
	{ 0x6f73, 0x9913 },
	{ 0x6f74, 0x9912 },
	{ 0x6f75, 0x9918 },
	{ 0x6f76, 0x99dd },
	{ 0x6f77, 0x99d0 },
	{ 0x6f78, 0x99df },
	{ 0x6f79, 0x99db },
	{ 0x6f7a, 0x99d1 },
	{ 0x6f7b, 0x99d5 },
	{ 0x6f7c, 0x99d2 },
	{ 0x6f7d, 0x99d9 },
	{ 0x6f7e, 0x9ab7 },
	{ 0x7021, 0x9aee },
	{ 0x7022, 0x9aef },
	{ 0x7023, 0x9b27 },
	{ 0x7024, 0x9b45 },
	{ 0x7025, 0x9b44 },
	{ 0x7026, 0x9b77 },
	{ 0x7027, 0x9b6f },
	{ 0x7028, 0x9d06 },
	{ 0x7029, 0x9d09 },
	{ 0x702a, 0x9d03 },
	{ 0x702b, 0x9ea9 },
	{ 0x702c, 0x9ebe },
	{ 0x702d, 0x9ece },
	{ 0x702e, 0x58a8 },
	{ 0x702f, 0x9f52 },
	{ 0x7030, 0x5112 },
	{ 0x7031, 0x5118 },
	{ 0x7032, 0x5114 },
	{ 0x7033, 0x5110 },
	{ 0x7034, 0x5115 },
	{ 0x7035, 0x5180 },
	{ 0x7036, 0x51aa },
	{ 0x7037, 0x51dd },
	{ 0x7038, 0x5291 },
	{ 0x7039, 0x5293 },
	{ 0x703a, 0x52f3 },
	{ 0x703b, 0x5659 },
	{ 0x703c, 0x566b },
	{ 0x703d, 0x5679 },
	{ 0x703e, 0x5669 },
	{ 0x703f, 0x5664 },
	{ 0x7040, 0x5678 },
	{ 0x7041, 0x566a },
	{ 0x7042, 0x5668 },
	{ 0x7043, 0x5665 },
	{ 0x7044, 0x5671 },
	{ 0x7045, 0x566f },
	{ 0x7046, 0x566c },
	{ 0x7047, 0x5662 },
	{ 0x7048, 0x5676 },
	{ 0x7049, 0x58c1 },
	{ 0x704a, 0x58be },
	{ 0x704b, 0x58c7 },
	{ 0x704c, 0x58c5 },
	{ 0x704d, 0x596e },
	{ 0x704e, 0x5b1d },
	{ 0x704f, 0x5b34 },
	{ 0x7050, 0x5b78 },
	{ 0x7051, 0x5bf0 },
	{ 0x7052, 0x5c0e },
	{ 0x7053, 0x5f4a },
	{ 0x7054, 0x61b2 },
	{ 0x7055, 0x6191 },
	{ 0x7056, 0x61a9 },
	{ 0x7057, 0x618a },
	{ 0x7058, 0x61cd },
	{ 0x7059, 0x61b6 },
	{ 0x705a, 0x61be },
	{ 0x705b, 0x61ca },
	{ 0x705c, 0x61c8 },
	{ 0x705d, 0x6230 },
	{ 0x705e, 0x64c5 },
	{ 0x705f, 0x64c1 },
	{ 0x7060, 0x64cb },
	{ 0x7061, 0x64bb },
	{ 0x7062, 0x64bc },
	{ 0x7063, 0x64da },
	{ 0x7064, 0x64c4 },
	{ 0x7065, 0x64c7 },
	{ 0x7066, 0x64c2 },
	{ 0x7067, 0x64cd },
	{ 0x7068, 0x64bf },
	{ 0x7069, 0x64d2 },
	{ 0x706a, 0x64d4 },
	{ 0x706b, 0x64be },
	{ 0x706c, 0x6574 },
	{ 0x706d, 0x66c6 },
	{ 0x706e, 0x66c9 },
	{ 0x706f, 0x66b9 },
	{ 0x7070, 0x66c4 },
	{ 0x7071, 0x66c7 },
	{ 0x7072, 0x66b8 },
	{ 0x7073, 0x6a3d },
	{ 0x7074, 0x6a38 },
	{ 0x7075, 0x6a3a },
	{ 0x7076, 0x6a59 },
	{ 0x7077, 0x6a6b },
	{ 0x7078, 0x6a58 },
	{ 0x7079, 0x6a39 },
	{ 0x707a, 0x6a44 },
	{ 0x707b, 0x6a62 },
	{ 0x707c, 0x6a61 },
	{ 0x707d, 0x6a4b },
	{ 0x707e, 0x6a47 },
	{ 0x7121, 0x6a35 },
	{ 0x7122, 0x6a5f },
	{ 0x7123, 0x6a48 },
	{ 0x7124, 0x6b59 },
	{ 0x7125, 0x6b77 },
	{ 0x7126, 0x6c05 },
	{ 0x7127, 0x6fc2 },
	{ 0x7128, 0x6fb1 },
	{ 0x7129, 0x6fa1 },
	{ 0x712a, 0x6fc3 },
	{ 0x712b, 0x6fa4 },
	{ 0x712c, 0x6fc1 },
	{ 0x712d, 0x6fa7 },
	{ 0x712e, 0x6fb3 },
	{ 0x712f, 0x6fc0 },
	{ 0x7130, 0x6fb9 },
	{ 0x7131, 0x6fb6 },
	{ 0x7132, 0x6fa6 },
	{ 0x7133, 0x6fa0 },
	{ 0x7134, 0x6fb4 },
	{ 0x7135, 0x71be },
	{ 0x7136, 0x71c9 },
	{ 0x7137, 0x71d0 },
	{ 0x7138, 0x71d2 },
	{ 0x7139, 0x71c8 },
	{ 0x713a, 0x71d5 },
	{ 0x713b, 0x71b9 },
	{ 0x713c, 0x71ce },
	{ 0x713d, 0x71d9 },
	{ 0x713e, 0x71dc },
	{ 0x713f, 0x71c3 },
	{ 0x7140, 0x71c4 },
	{ 0x7141, 0x7368 },
	{ 0x7142, 0x749c },
	{ 0x7143, 0x74a3 },
	{ 0x7144, 0x7498 },
	{ 0x7145, 0x749f },
	{ 0x7146, 0x749e },
	{ 0x7147, 0x74e2 },
	{ 0x7148, 0x750c },
	{ 0x7149, 0x750d },
	{ 0x714a, 0x7634 },
	{ 0x714b, 0x7638 },
	{ 0x714c, 0x763a },
	{ 0x714d, 0x76e7 },
	{ 0x714e, 0x76e5 },
	{ 0x714f, 0x77a0 },
	{ 0x7150, 0x779e },
	{ 0x7151, 0x779f },
	{ 0x7152, 0x77a5 },
	{ 0x7153, 0x78e8 },
	{ 0x7154, 0x78da },
	{ 0x7155, 0x78ec },
	{ 0x7156, 0x78e7 },
	{ 0x7157, 0x79a6 },
	{ 0x7158, 0x7a4d },
	{ 0x7159, 0x7a4e },
	{ 0x715a, 0x7a46 },
	{ 0x715b, 0x7a4c },
	{ 0x715c, 0x7a4b },
	{ 0x715d, 0x7aba },
	{ 0x715e, 0x7bd9 },
	{ 0x715f, 0x7c11 },
	{ 0x7160, 0x7bc9 },
	{ 0x7161, 0x7be4 },
	{ 0x7162, 0x7bdb },
	{ 0x7163, 0x7be1 },
	{ 0x7164, 0x7be9 },
	{ 0x7165, 0x7be6 },
	{ 0x7166, 0x7cd5 },
	{ 0x7167, 0x7cd6 },
	{ 0x7168, 0x7e0a },
	{ 0x7169, 0x7e11 },
	{ 0x716a, 0x7e08 },
	{ 0x716b, 0x7e1b },
	{ 0x716c, 0x7e23 },
	{ 0x716d, 0x7e1e },
	{ 0x716e, 0x7e1d },
	{ 0x716f, 0x7e09 },
	{ 0x7170, 0x7e10 },
	{ 0x7171, 0x7f79 },
	{ 0x7172, 0x7fb2 },
	{ 0x7173, 0x7ff0 },
	{ 0x7174, 0x7ff1 },
	{ 0x7175, 0x7fee },
	{ 0x7176, 0x8028 },
	{ 0x7177, 0x81b3 },
	{ 0x7178, 0x81a9 },
	{ 0x7179, 0x81a8 },
	{ 0x717a, 0x81fb },
	{ 0x717b, 0x8208 },
	{ 0x717c, 0x8258 },
	{ 0x717d, 0x8259 },
	{ 0x717e, 0x854a },
	{ 0x7221, 0x8559 },
	{ 0x7222, 0x8548 },
	{ 0x7223, 0x8568 },
	{ 0x7224, 0x8569 },
	{ 0x7225, 0x8543 },
	{ 0x7226, 0x8549 },
	{ 0x7227, 0x856d },
	{ 0x7228, 0x856a },
	{ 0x7229, 0x855e },
	{ 0x722a, 0x8783 },
	{ 0x722b, 0x879f },
	{ 0x722c, 0x879e },
	{ 0x722d, 0x87a2 },
	{ 0x722e, 0x878d },
	{ 0x722f, 0x8861 },
	{ 0x7230, 0x892a },
	{ 0x7231, 0x8932 },
	{ 0x7232, 0x8925 },
	{ 0x7233, 0x892b },
	{ 0x7234, 0x8921 },
	{ 0x7235, 0x89aa },
	{ 0x7236, 0x89a6 },
	{ 0x7237, 0x8ae6 },
	{ 0x7238, 0x8afa },
	{ 0x7239, 0x8aeb },
	{ 0x723a, 0x8af1 },
	{ 0x723b, 0x8b00 },
	{ 0x723c, 0x8adc },
	{ 0x723d, 0x8ae7 },
	{ 0x723e, 0x8aee },
	{ 0x723f, 0x8afe },
	{ 0x7240, 0x8b01 },
	{ 0x7241, 0x8b02 },
	{ 0x7242, 0x8af7 },
	{ 0x7243, 0x8aed },
	{ 0x7244, 0x8af3 },
	{ 0x7245, 0x8af6 },
	{ 0x7246, 0x8afc },
	{ 0x7247, 0x8c6b },
	{ 0x7248, 0x8c6d },
	{ 0x7249, 0x8c93 },
	{ 0x724a, 0x8cf4 },
	{ 0x724b, 0x8e44 },
	{ 0x724c, 0x8e31 },
	{ 0x724d, 0x8e34 },
	{ 0x724e, 0x8e42 },
	{ 0x724f, 0x8e39 },
	{ 0x7250, 0x8e35 },
	{ 0x7251, 0x8f3b },
	{ 0x7252, 0x8f2f },
	{ 0x7253, 0x8f38 },
	{ 0x7254, 0x8f33 },
	{ 0x7255, 0x8fa8 },
	{ 0x7256, 0x8fa6 },
	{ 0x7257, 0x9075 },
	{ 0x7258, 0x9074 },
	{ 0x7259, 0x9078 },
	{ 0x725a, 0x9072 },
	{ 0x725b, 0x907c },
	{ 0x725c, 0x907a },
	{ 0x725d, 0x9134 },
	{ 0x725e, 0x9192 },
	{ 0x725f, 0x9320 },
	{ 0x7260, 0x9336 },
	{ 0x7261, 0x92f8 },
	{ 0x7262, 0x9333 },
	{ 0x7263, 0x932f },
	{ 0x7264, 0x9322 },
	{ 0x7265, 0x92fc },
	{ 0x7266, 0x932b },
	{ 0x7267, 0x9304 },
	{ 0x7268, 0x931a },
	{ 0x7269, 0x9310 },
	{ 0x726a, 0x9326 },
	{ 0x726b, 0x9321 },
	{ 0x726c, 0x9315 },
	{ 0x726d, 0x932e },
	{ 0x726e, 0x9319 },
	{ 0x726f, 0x95bb },
	{ 0x7270, 0x96a7 },
	{ 0x7271, 0x96a8 },
	{ 0x7272, 0x96aa },
	{ 0x7273, 0x96d5 },
	{ 0x7274, 0x970e },
	{ 0x7275, 0x9711 },
	{ 0x7276, 0x9716 },
	{ 0x7277, 0x970d },
	{ 0x7278, 0x9713 },
	{ 0x7279, 0x970f },
	{ 0x727a, 0x975b },
	{ 0x727b, 0x975c },
	{ 0x727c, 0x9766 },
	{ 0x727d, 0x9798 },
	{ 0x727e, 0x9830 },
	{ 0x7321, 0x9838 },
	{ 0x7322, 0x983b },
	{ 0x7323, 0x9837 },
	{ 0x7324, 0x982d },
	{ 0x7325, 0x9839 },
	{ 0x7326, 0x9824 },
	{ 0x7327, 0x9910 },
	{ 0x7328, 0x9928 },
	{ 0x7329, 0x991e },
	{ 0x732a, 0x991b },
	{ 0x732b, 0x9921 },
	{ 0x732c, 0x991a },
	{ 0x732d, 0x99ed },
	{ 0x732e, 0x99e2 },
	{ 0x732f, 0x99f1 },
	{ 0x7330, 0x9ab8 },
	{ 0x7331, 0x9abc },
	{ 0x7332, 0x9afb },
	{ 0x7333, 0x9aed },
	{ 0x7334, 0x9b28 },
	{ 0x7335, 0x9b91 },
	{ 0x7336, 0x9d15 },
	{ 0x7337, 0x9d23 },
	{ 0x7338, 0x9d26 },
	{ 0x7339, 0x9d28 },
	{ 0x733a, 0x9d12 },
	{ 0x733b, 0x9d1b },
	{ 0x733c, 0x9ed8 },
	{ 0x733d, 0x9ed4 },
	{ 0x733e, 0x9f8d },
	{ 0x733f, 0x9f9c },
	{ 0x7340, 0x512a },
	{ 0x7341, 0x511f },
	{ 0x7342, 0x5121 },
	{ 0x7343, 0x5132 },
	{ 0x7344, 0x52f5 },
	{ 0x7345, 0x568e },
	{ 0x7346, 0x5680 },
	{ 0x7347, 0x5690 },
	{ 0x7348, 0x5685 },
	{ 0x7349, 0x5687 },
	{ 0x734a, 0x568f },
	{ 0x734b, 0x58d5 },
	{ 0x734c, 0x58d3 },
	{ 0x734d, 0x58d1 },
	{ 0x734e, 0x58ce },
	{ 0x734f, 0x5b30 },
	{ 0x7350, 0x5b2a },
	{ 0x7351, 0x5b24 },
	{ 0x7352, 0x5b7a },
	{ 0x7353, 0x5c37 },
	{ 0x7354, 0x5c68 },
	{ 0x7355, 0x5dbc },
	{ 0x7356, 0x5dba },
	{ 0x7357, 0x5dbd },
	{ 0x7358, 0x5db8 },
	{ 0x7359, 0x5e6b },
	{ 0x735a, 0x5f4c },
	{ 0x735b, 0x5fbd },
	{ 0x735c, 0x61c9 },
	{ 0x735d, 0x61c2 },
	{ 0x735e, 0x61c7 },
	{ 0x735f, 0x61e6 },
	{ 0x7360, 0x61cb },
	{ 0x7361, 0x6232 },
	{ 0x7362, 0x6234 },
	{ 0x7363, 0x64ce },
	{ 0x7364, 0x64ca },
	{ 0x7365, 0x64d8 },
	{ 0x7366, 0x64e0 },
	{ 0x7367, 0x64f0 },
	{ 0x7368, 0x64e6 },
	{ 0x7369, 0x64ec },
	{ 0x736a, 0x64f1 },
	{ 0x736b, 0x64e2 },
	{ 0x736c, 0x64ed },
	{ 0x736d, 0x6582 },
	{ 0x736e, 0x6583 },
	{ 0x736f, 0x66d9 },
	{ 0x7370, 0x66d6 },
	{ 0x7371, 0x6a80 },
	{ 0x7372, 0x6a94 },
	{ 0x7373, 0x6a84 },
	{ 0x7374, 0x6aa2 },
	{ 0x7375, 0x6a9c },
	{ 0x7376, 0x6adb },
	{ 0x7377, 0x6aa3 },
	{ 0x7378, 0x6a7e },
	{ 0x7379, 0x6a97 },
	{ 0x737a, 0x6a90 },
	{ 0x737b, 0x6aa0 },
	{ 0x737c, 0x6b5c },
	{ 0x737d, 0x6bae },
	{ 0x737e, 0x6bda },
	{ 0x7421, 0x6c08 },
	{ 0x7422, 0x6fd8 },
	{ 0x7423, 0x6ff1 },
	{ 0x7424, 0x6fdf },
	{ 0x7425, 0x6fe0 },
	{ 0x7426, 0x6fdb },
	{ 0x7427, 0x6fe4 },
	{ 0x7428, 0x6feb },
	{ 0x7429, 0x6fef },
	{ 0x742a, 0x6f80 },
	{ 0x742b, 0x6fec },
	{ 0x742c, 0x6fe1 },
	{ 0x742d, 0x6fe9 },
	{ 0x742e, 0x6fd5 },
	{ 0x742f, 0x6fee },
	{ 0x7430, 0x6ff0 },
	{ 0x7431, 0x71e7 },
	{ 0x7432, 0x71df },
	{ 0x7433, 0x71ee },
	{ 0x7434, 0x71e6 },
	{ 0x7435, 0x71e5 },
	{ 0x7436, 0x71ed },
	{ 0x7437, 0x71ec },
	{ 0x7438, 0x71f4 },
	{ 0x7439, 0x71e0 },
	{ 0x743a, 0x7235 },
	{ 0x743b, 0x7246 },
	{ 0x743c, 0x7370 },
	{ 0x743d, 0x7372 },
	{ 0x743e, 0x74a9 },
	{ 0x743f, 0x74b0 },
	{ 0x7440, 0x74a6 },
	{ 0x7441, 0x74a8 },
	{ 0x7442, 0x7646 },
	{ 0x7443, 0x7642 },
	{ 0x7444, 0x764c },
	{ 0x7445, 0x76ea },
	{ 0x7446, 0x77b3 },
	{ 0x7447, 0x77aa },
	{ 0x7448, 0x77b0 },
	{ 0x7449, 0x77ac },
	{ 0x744a, 0x77a7 },
	{ 0x744b, 0x77ad },
	{ 0x744c, 0x77ef },
	{ 0x744d, 0x78f7 },
	{ 0x744e, 0x78fa },
	{ 0x744f, 0x78f4 },
	{ 0x7450, 0x78ef },
	{ 0x7451, 0x7901 },
	{ 0x7452, 0x79a7 },
	{ 0x7453, 0x79aa },
	{ 0x7454, 0x7a57 },
	{ 0x7455, 0x7abf },
	{ 0x7456, 0x7c07 },
	{ 0x7457, 0x7c0d },
	{ 0x7458, 0x7bfe },
	{ 0x7459, 0x7bf7 },
	{ 0x745a, 0x7c0c },
	{ 0x745b, 0x7be0 },
	{ 0x745c, 0x7ce0 },
	{ 0x745d, 0x7cdc },
	{ 0x745e, 0x7cde },
	{ 0x745f, 0x7ce2 },
	{ 0x7460, 0x7cdf },
	{ 0x7461, 0x7cd9 },
	{ 0x7462, 0x7cdd },
	{ 0x7463, 0x7e2e },
	{ 0x7464, 0x7e3e },
	{ 0x7465, 0x7e46 },
	{ 0x7466, 0x7e37 },
	{ 0x7467, 0x7e32 },
	{ 0x7468, 0x7e43 },
	{ 0x7469, 0x7e2b },
	{ 0x746a, 0x7e3d },
	{ 0x746b, 0x7e31 },
	{ 0x746c, 0x7e45 },
	{ 0x746d, 0x7e41 },
	{ 0x746e, 0x7e34 },
	{ 0x746f, 0x7e39 },
	{ 0x7470, 0x7e48 },
	{ 0x7471, 0x7e35 },
	{ 0x7472, 0x7e3f },
	{ 0x7473, 0x7e2f },
	{ 0x7474, 0x7f44 },
	{ 0x7475, 0x7ff3 },
	{ 0x7476, 0x7ffc },
	{ 0x7477, 0x8071 },
	{ 0x7478, 0x8072 },
	{ 0x7479, 0x8070 },
	{ 0x747a, 0x806f },
	{ 0x747b, 0x8073 },
	{ 0x747c, 0x81c6 },
	{ 0x747d, 0x81c3 },
	{ 0x747e, 0x81ba },
	{ 0x7521, 0x81c2 },
	{ 0x7522, 0x81c0 },
	{ 0x7523, 0x81bf },
	{ 0x7524, 0x81bd },
	{ 0x7525, 0x81c9 },
	{ 0x7526, 0x81be },
	{ 0x7527, 0x81e8 },
	{ 0x7528, 0x8209 },
	{ 0x7529, 0x8271 },
	{ 0x752a, 0x85aa },
	{ 0x752b, 0x8584 },
	{ 0x752c, 0x857e },
	{ 0x752d, 0x859c },
	{ 0x752e, 0x8591 },
	{ 0x752f, 0x8594 },
	{ 0x7530, 0x85af },
	{ 0x7531, 0x859b },
	{ 0x7532, 0x8587 },
	{ 0x7533, 0x85a8 },
	{ 0x7534, 0x858a },
	{ 0x7535, 0x85a6 },
	{ 0x7536, 0x8667 },
	{ 0x7537, 0x87c0 },
	{ 0x7538, 0x87d1 },
	{ 0x7539, 0x87b3 },
	{ 0x753a, 0x87d2 },
	{ 0x753b, 0x87c6 },
	{ 0x753c, 0x87ab },
	{ 0x753d, 0x87bb },
	{ 0x753e, 0x87ba },
	{ 0x753f, 0x87c8 },
	{ 0x7540, 0x87cb },
	{ 0x7541, 0x893b },
	{ 0x7542, 0x8936 },
	{ 0x7543, 0x8944 },
	{ 0x7544, 0x8938 },
	{ 0x7545, 0x893d },
	{ 0x7546, 0x89ac },
	{ 0x7547, 0x8b0e },
	{ 0x7548, 0x8b17 },
	{ 0x7549, 0x8b19 },
	{ 0x754a, 0x8b1b },
	{ 0x754b, 0x8b0a },
	{ 0x754c, 0x8b20 },
	{ 0x754d, 0x8b1d },
	{ 0x754e, 0x8b04 },
	{ 0x754f, 0x8b10 },
	{ 0x7550, 0x8c41 },
	{ 0x7551, 0x8c3f },
	{ 0x7552, 0x8c73 },
	{ 0x7553, 0x8cfa },
	{ 0x7554, 0x8cfd },
	{ 0x7555, 0x8cfc },
	{ 0x7556, 0x8cf8 },
	{ 0x7557, 0x8cfb },
	{ 0x7558, 0x8da8 },
	{ 0x7559, 0x8e49 },
	{ 0x755a, 0x8e4b },
	{ 0x755b, 0x8e48 },
	{ 0x755c, 0x8e4a },
	{ 0x755d, 0x8f44 },
	{ 0x755e, 0x8f3e },
	{ 0x755f, 0x8f42 },
	{ 0x7560, 0x8f45 },
	{ 0x7561, 0x8f3f },
	{ 0x7562, 0x907f },
	{ 0x7563, 0x907d },
	{ 0x7564, 0x9084 },
	{ 0x7565, 0x9081 },
	{ 0x7566, 0x9082 },
	{ 0x7567, 0x9080 },
	{ 0x7568, 0x9139 },
	{ 0x7569, 0x91a3 },
	{ 0x756a, 0x919e },
	{ 0x756b, 0x919c },
	{ 0x756c, 0x934d },
	{ 0x756d, 0x9382 },
	{ 0x756e, 0x9328 },
	{ 0x756f, 0x9375 },
	{ 0x7570, 0x934a },
	{ 0x7571, 0x9365 },
	{ 0x7572, 0x934b },
	{ 0x7573, 0x9318 },
	{ 0x7574, 0x937e },
	{ 0x7575, 0x936c },
	{ 0x7576, 0x935b },
	{ 0x7577, 0x9370 },
	{ 0x7578, 0x935a },
	{ 0x7579, 0x9354 },
	{ 0x757a, 0x95ca },
	{ 0x757b, 0x95cb },
	{ 0x757c, 0x95cc },
	{ 0x757d, 0x95c8 },
	{ 0x757e, 0x95c6 },
	{ 0x7621, 0x96b1 },
	{ 0x7622, 0x96b8 },
	{ 0x7623, 0x96d6 },
	{ 0x7624, 0x971c },
	{ 0x7625, 0x971e },
	{ 0x7626, 0x97a0 },
	{ 0x7627, 0x97d3 },
	{ 0x7628, 0x9846 },
	{ 0x7629, 0x98b6 },
	{ 0x762a, 0x9935 },
	{ 0x762b, 0x9a01 },
	{ 0x762c, 0x99ff },
	{ 0x762d, 0x9bae },
	{ 0x762e, 0x9bab },
	{ 0x762f, 0x9baa },
	{ 0x7630, 0x9bad },
	{ 0x7631, 0x9d3b },
	{ 0x7632, 0x9d3f },
	{ 0x7633, 0x9e8b },
	{ 0x7634, 0x9ecf },
	{ 0x7635, 0x9ede },
	{ 0x7636, 0x9edc },
	{ 0x7637, 0x9edd },
	{ 0x7638, 0x9edb },
	{ 0x7639, 0x9f3e },
	{ 0x763a, 0x9f4b },
	{ 0x763b, 0x53e2 },
	{ 0x763c, 0x5695 },
	{ 0x763d, 0x56ae },
	{ 0x763e, 0x58d9 },
	{ 0x763f, 0x58d8 },
	{ 0x7640, 0x5b38 },
	{ 0x7641, 0x5f5e },
	{ 0x7642, 0x61e3 },
	{ 0x7643, 0x6233 },
	{ 0x7644, 0x64f4 },
	{ 0x7645, 0x64f2 },
	{ 0x7646, 0x64fe },
	{ 0x7647, 0x6506 },
	{ 0x7648, 0x64fa },
	{ 0x7649, 0x64fb },
	{ 0x764a, 0x64f7 },
	{ 0x764b, 0x65b7 },
	{ 0x764c, 0x66dc },
	{ 0x764d, 0x6726 },
	{ 0x764e, 0x6ab3 },
	{ 0x764f, 0x6aac },
	{ 0x7650, 0x6ac3 },
	{ 0x7651, 0x6abb },
	{ 0x7652, 0x6ab8 },
	{ 0x7653, 0x6ac2 },
	{ 0x7654, 0x6aae },
	{ 0x7655, 0x6aaf },
	{ 0x7656, 0x6b5f },
	{ 0x7657, 0x6b78 },
	{ 0x7658, 0x6baf },
	{ 0x7659, 0x7009 },
	{ 0x765a, 0x700b },
	{ 0x765b, 0x6ffe },
	{ 0x765c, 0x7006 },
	{ 0x765d, 0x6ffa },
	{ 0x765e, 0x7011 },
	{ 0x765f, 0x700f },
	{ 0x7660, 0x71fb },
	{ 0x7661, 0x71fc },
	{ 0x7662, 0x71fe },
	{ 0x7663, 0x71f8 },
	{ 0x7664, 0x7377 },
	{ 0x7665, 0x7375 },
	{ 0x7666, 0x74a7 },
	{ 0x7667, 0x74bf },
	{ 0x7668, 0x7515 },
	{ 0x7669, 0x7656 },
	{ 0x766a, 0x7658 },
	{ 0x766b, 0x7652 },
	{ 0x766c, 0x77bd },
	{ 0x766d, 0x77bf },
	{ 0x766e, 0x77bb },
	{ 0x766f, 0x77bc },
	{ 0x7670, 0x790e },
	{ 0x7671, 0x79ae },
	{ 0x7672, 0x7a61 },
	{ 0x7673, 0x7a62 },
	{ 0x7674, 0x7a60 },
	{ 0x7675, 0x7ac4 },
	{ 0x7676, 0x7ac5 },
	{ 0x7677, 0x7c2b },
	{ 0x7678, 0x7c27 },
	{ 0x7679, 0x7c2a },
	{ 0x767a, 0x7c1e },
	{ 0x767b, 0x7c23 },
	{ 0x767c, 0x7c21 },
	{ 0x767d, 0x7ce7 },
	{ 0x767e, 0x7e54 },
	{ 0x7721, 0x7e55 },
	{ 0x7722, 0x7e5e },
	{ 0x7723, 0x7e5a },
	{ 0x7724, 0x7e61 },
	{ 0x7725, 0x7e52 },
	{ 0x7726, 0x7e59 },
	{ 0x7727, 0x7f48 },
	{ 0x7728, 0x7ff9 },
	{ 0x7729, 0x7ffb },
	{ 0x772a, 0x8077 },
	{ 0x772b, 0x8076 },
	{ 0x772c, 0x81cd },
	{ 0x772d, 0x81cf },
	{ 0x772e, 0x820a },
	{ 0x772f, 0x85cf },
	{ 0x7730, 0x85a9 },
	{ 0x7731, 0x85cd },
	{ 0x7732, 0x85d0 },
	{ 0x7733, 0x85c9 },
	{ 0x7734, 0x85b0 },
	{ 0x7735, 0x85ba },
	{ 0x7736, 0x85b9 },
	{ 0x7737, 0x87ef },
	{ 0x7738, 0x87ec },
	{ 0x7739, 0x87f2 },
	{ 0x773a, 0x87e0 },
	{ 0x773b, 0x8986 },
	{ 0x773c, 0x89b2 },
	{ 0x773d, 0x89f4 },
	{ 0x773e, 0x8b28 },
	{ 0x773f, 0x8b39 },
	{ 0x7740, 0x8b2c },
	{ 0x7741, 0x8b2b },
	{ 0x7742, 0x8c50 },
	{ 0x7743, 0x8d05 },
	{ 0x7744, 0x8e59 },
	{ 0x7745, 0x8e63 },
	{ 0x7746, 0x8e66 },
	{ 0x7747, 0x8e64 },
	{ 0x7748, 0x8e5f },
	{ 0x7749, 0x8e55 },
	{ 0x774a, 0x8ec0 },
	{ 0x774b, 0x8f49 },
	{ 0x774c, 0x8f4d },
	{ 0x774d, 0x9087 },
	{ 0x774e, 0x9083 },
	{ 0x774f, 0x9088 },
	{ 0x7750, 0x91ab },
	{ 0x7751, 0x91ac },
	{ 0x7752, 0x91d0 },
	{ 0x7753, 0x9394 },
	{ 0x7754, 0x938a },
	{ 0x7755, 0x9396 },
	{ 0x7756, 0x93a2 },
	{ 0x7757, 0x93b3 },
	{ 0x7758, 0x93ae },
	{ 0x7759, 0x93ac },
	{ 0x775a, 0x93b0 },
	{ 0x775b, 0x9398 },
	{ 0x775c, 0x939a },
	{ 0x775d, 0x9397 },
	{ 0x775e, 0x95d4 },
	{ 0x775f, 0x95d6 },
	{ 0x7760, 0x95d0 },
	{ 0x7761, 0x95d5 },
	{ 0x7762, 0x96e2 },
	{ 0x7763, 0x96dc },
	{ 0x7764, 0x96d9 },
	{ 0x7765, 0x96db },
	{ 0x7766, 0x96de },
	{ 0x7767, 0x9724 },
	{ 0x7768, 0x97a3 },
	{ 0x7769, 0x97a6 },
	{ 0x776a, 0x97ad },
	{ 0x776b, 0x97f9 },
	{ 0x776c, 0x984d },
	{ 0x776d, 0x984f },
	{ 0x776e, 0x984c },
	{ 0x776f, 0x984e },
	{ 0x7770, 0x9853 },
	{ 0x7771, 0x98ba },
	{ 0x7772, 0x993e },
	{ 0x7773, 0x993f },
	{ 0x7774, 0x993d },
	{ 0x7775, 0x992e },
	{ 0x7776, 0x99a5 },
	{ 0x7777, 0x9a0e },
	{ 0x7778, 0x9ac1 },
	{ 0x7779, 0x9b03 },
	{ 0x777a, 0x9b06 },
	{ 0x777b, 0x9b4f },
	{ 0x777c, 0x9b4e },
	{ 0x777d, 0x9b4d },
	{ 0x777e, 0x9bca },
	{ 0x7821, 0x9bc9 },
	{ 0x7822, 0x9bfd },
	{ 0x7823, 0x9bc8 },
	{ 0x7824, 0x9bc0 },
	{ 0x7825, 0x9d51 },
	{ 0x7826, 0x9d5d },
	{ 0x7827, 0x9d60 },
	{ 0x7828, 0x9ee0 },
	{ 0x7829, 0x9f15 },
	{ 0x782a, 0x9f2c },
	{ 0x782b, 0x5133 },
	{ 0x782c, 0x56a5 },
	{ 0x782d, 0x56a8 },
	{ 0x782e, 0x58de },
	{ 0x782f, 0x58df },
	{ 0x7830, 0x58e2 },
	{ 0x7831, 0x5bf5 },
	{ 0x7832, 0x9f90 },
	{ 0x7833, 0x5eec },
	{ 0x7834, 0x61f2 },
	{ 0x7835, 0x61f7 },
	{ 0x7836, 0x61f6 },
	{ 0x7837, 0x61f5 },
	{ 0x7838, 0x6500 },
	{ 0x7839, 0x650f },
	{ 0x783a, 0x66e0 },
	{ 0x783b, 0x66dd },
	{ 0x783c, 0x6ae5 },
	{ 0x783d, 0x6add },
	{ 0x783e, 0x6ada },
	{ 0x783f, 0x6ad3 },
	{ 0x7840, 0x701b },
	{ 0x7841, 0x701f },
	{ 0x7842, 0x7028 },
	{ 0x7843, 0x701a },
	{ 0x7844, 0x701d },
	{ 0x7845, 0x7015 },
	{ 0x7846, 0x7018 },
	{ 0x7847, 0x7206 },
	{ 0x7848, 0x720d },
	{ 0x7849, 0x7258 },
	{ 0x784a, 0x72a2 },
	{ 0x784b, 0x7378 },
	{ 0x784c, 0x737a },
	{ 0x784d, 0x74bd },
	{ 0x784e, 0x74ca },
	{ 0x784f, 0x74e3 },
	{ 0x7850, 0x7587 },
	{ 0x7851, 0x7586 },
	{ 0x7852, 0x765f },
	{ 0x7853, 0x7661 },
	{ 0x7854, 0x77c7 },
	{ 0x7855, 0x7919 },
	{ 0x7856, 0x79b1 },
	{ 0x7857, 0x7a6b },
	{ 0x7858, 0x7a69 },
	{ 0x7859, 0x7c3e },
	{ 0x785a, 0x7c3f },
	{ 0x785b, 0x7c38 },
	{ 0x785c, 0x7c3d },
	{ 0x785d, 0x7c37 },
	{ 0x785e, 0x7c40 },
	{ 0x785f, 0x7e6b },
	{ 0x7860, 0x7e6d },
	{ 0x7861, 0x7e79 },
	{ 0x7862, 0x7e69 },
	{ 0x7863, 0x7e6a },
	{ 0x7864, 0x7e73 },
	{ 0x7865, 0x7f85 },
	{ 0x7866, 0x7fb6 },
	{ 0x7867, 0x7fb9 },
	{ 0x7868, 0x7fb8 },
	{ 0x7869, 0x81d8 },
	{ 0x786a, 0x85e9 },
	{ 0x786b, 0x85dd },
	{ 0x786c, 0x85ea },
	{ 0x786d, 0x85d5 },
	{ 0x786e, 0x85e4 },
	{ 0x786f, 0x85e5 },
	{ 0x7870, 0x85f7 },
	{ 0x7871, 0x87fb },
	{ 0x7872, 0x8805 },
	{ 0x7873, 0x880d },
	{ 0x7874, 0x87f9 },
	{ 0x7875, 0x87fe },
	{ 0x7876, 0x8960 },
	{ 0x7877, 0x895f },
	{ 0x7878, 0x8956 },
	{ 0x7879, 0x895e },
	{ 0x787a, 0x8b41 },
	{ 0x787b, 0x8b5c },
	{ 0x787c, 0x8b58 },
	{ 0x787d, 0x8b49 },
	{ 0x787e, 0x8b5a },
	{ 0x7921, 0x8b4e },
	{ 0x7922, 0x8b4f },
	{ 0x7923, 0x8b46 },
	{ 0x7924, 0x8b59 },
	{ 0x7925, 0x8d08 },
	{ 0x7926, 0x8d0a },
	{ 0x7927, 0x8e7c },
	{ 0x7928, 0x8e72 },
	{ 0x7929, 0x8e87 },
	{ 0x792a, 0x8e76 },
	{ 0x792b, 0x8e6c },
	{ 0x792c, 0x8e7a },
	{ 0x792d, 0x8e74 },
	{ 0x792e, 0x8f54 },
	{ 0x792f, 0x8f4e },
	{ 0x7930, 0x8fad },
	{ 0x7931, 0x908a },
	{ 0x7932, 0x908b },
	{ 0x7933, 0x91b1 },
	{ 0x7934, 0x91ae },
	{ 0x7935, 0x93e1 },
	{ 0x7936, 0x93d1 },
	{ 0x7937, 0x93df },
	{ 0x7938, 0x93c3 },
	{ 0x7939, 0x93c8 },
	{ 0x793a, 0x93dc },
	{ 0x793b, 0x93dd },
	{ 0x793c, 0x93d6 },
	{ 0x793d, 0x93e2 },
	{ 0x793e, 0x93cd },
	{ 0x793f, 0x93d8 },
	{ 0x7940, 0x93e4 },
	{ 0x7941, 0x93d7 },
	{ 0x7942, 0x93e8 },
	{ 0x7943, 0x95dc },
	{ 0x7944, 0x96b4 },
	{ 0x7945, 0x96e3 },
	{ 0x7946, 0x972a },
	{ 0x7947, 0x9727 },
	{ 0x7948, 0x9761 },
	{ 0x7949, 0x97dc },
	{ 0x794a, 0x97fb },
	{ 0x794b, 0x985e },
	{ 0x794c, 0x9858 },
	{ 0x794d, 0x985b },
	{ 0x794e, 0x98bc },
	{ 0x794f, 0x9945 },
	{ 0x7950, 0x9949 },
	{ 0x7951, 0x9a16 },
	{ 0x7952, 0x9a19 },
	{ 0x7953, 0x9b0d },
	{ 0x7954, 0x9be8 },
	{ 0x7955, 0x9be7 },
	{ 0x7956, 0x9bd6 },
	{ 0x7957, 0x9bdb },
	{ 0x7958, 0x9d89 },
	{ 0x7959, 0x9d61 },
	{ 0x795a, 0x9d72 },
	{ 0x795b, 0x9d6a },
	{ 0x795c, 0x9d6c },
	{ 0x795d, 0x9e92 },
	{ 0x795e, 0x9e97 },
	{ 0x795f, 0x9e93 },
	{ 0x7960, 0x9eb4 },
	{ 0x7961, 0x52f8 },
	{ 0x7962, 0x56b7 },
	{ 0x7963, 0x56b6 },
	{ 0x7964, 0x56b4 },
	{ 0x7965, 0x56bc },
	{ 0x7966, 0x58e4 },
	{ 0x7967, 0x5b40 },
	{ 0x7968, 0x5b43 },
	{ 0x7969, 0x5b7d },
	{ 0x796a, 0x5bf6 },
	{ 0x796b, 0x5dc9 },
	{ 0x796c, 0x61f8 },
	{ 0x796d, 0x61fa },
	{ 0x796e, 0x6518 },
	{ 0x796f, 0x6514 },
	{ 0x7970, 0x6519 },
	{ 0x7971, 0x66e6 },
	{ 0x7972, 0x6727 },
	{ 0x7973, 0x6aec },
	{ 0x7974, 0x703e },
	{ 0x7975, 0x7030 },
	{ 0x7976, 0x7032 },
	{ 0x7977, 0x7210 },
	{ 0x7978, 0x737b },
	{ 0x7979, 0x74cf },
	{ 0x797a, 0x7662 },
	{ 0x797b, 0x7665 },
	{ 0x797c, 0x7926 },
	{ 0x797d, 0x792a },
	{ 0x797e, 0x792c },
	{ 0x7a21, 0x792b },
	{ 0x7a22, 0x7ac7 },
	{ 0x7a23, 0x7af6 },
	{ 0x7a24, 0x7c4c },
	{ 0x7a25, 0x7c43 },
	{ 0x7a26, 0x7c4d },
	{ 0x7a27, 0x7cef },
	{ 0x7a28, 0x7cf0 },
	{ 0x7a29, 0x8fae },
	{ 0x7a2a, 0x7e7d },
	{ 0x7a2b, 0x7e7c },
	{ 0x7a2c, 0x7e82 },
	{ 0x7a2d, 0x7f4c },
	{ 0x7a2e, 0x8000 },
	{ 0x7a2f, 0x81da },
	{ 0x7a30, 0x8266 },
	{ 0x7a31, 0x85fb },
	{ 0x7a32, 0x85f9 },
	{ 0x7a33, 0x8611 },
	{ 0x7a34, 0x85fa },
	{ 0x7a35, 0x8606 },
	{ 0x7a36, 0x860b },
	{ 0x7a37, 0x8607 },
	{ 0x7a38, 0x860a },
	{ 0x7a39, 0x8814 },
	{ 0x7a3a, 0x8815 },
	{ 0x7a3b, 0x8964 },
	{ 0x7a3c, 0x89ba },
	{ 0x7a3d, 0x89f8 },
	{ 0x7a3e, 0x8b70 },
	{ 0x7a3f, 0x8b6c },
	{ 0x7a40, 0x8b66 },
	{ 0x7a41, 0x8b6f },
	{ 0x7a42, 0x8b5f },
	{ 0x7a43, 0x8b6b },
	{ 0x7a44, 0x8d0f },
	{ 0x7a45, 0x8d0d },
	{ 0x7a46, 0x8e89 },
	{ 0x7a47, 0x8e81 },
	{ 0x7a48, 0x8e85 },
	{ 0x7a49, 0x8e82 },
	{ 0x7a4a, 0x91b4 },
	{ 0x7a4b, 0x91cb },
	{ 0x7a4c, 0x9418 },
	{ 0x7a4d, 0x9403 },
	{ 0x7a4e, 0x93fd },
	{ 0x7a4f, 0x95e1 },
	{ 0x7a50, 0x9730 },
	{ 0x7a51, 0x98c4 },
	{ 0x7a52, 0x9952 },
	{ 0x7a53, 0x9951 },
	{ 0x7a54, 0x99a8 },
	{ 0x7a55, 0x9a2b },
	{ 0x7a56, 0x9a30 },
	{ 0x7a57, 0x9a37 },
	{ 0x7a58, 0x9a35 },
	{ 0x7a59, 0x9c13 },
	{ 0x7a5a, 0x9c0d },
	{ 0x7a5b, 0x9e79 },
	{ 0x7a5c, 0x9eb5 },
	{ 0x7a5d, 0x9ee8 },
	{ 0x7a5e, 0x9f2f },
	{ 0x7a5f, 0x9f5f },
	{ 0x7a60, 0x9f63 },
	{ 0x7a61, 0x9f61 },
	{ 0x7a62, 0x5137 },
	{ 0x7a63, 0x5138 },
	{ 0x7a64, 0x56c1 },
	{ 0x7a65, 0x56c0 },
	{ 0x7a66, 0x56c2 },
	{ 0x7a67, 0x5914 },
	{ 0x7a68, 0x5c6c },
	{ 0x7a69, 0x5dcd },
	{ 0x7a6a, 0x61fc },
	{ 0x7a6b, 0x61fe },
	{ 0x7a6c, 0x651d },
	{ 0x7a6d, 0x651c },
	{ 0x7a6e, 0x6595 },
	{ 0x7a6f, 0x66e9 },
	{ 0x7a70, 0x6afb },
	{ 0x7a71, 0x6b04 },
	{ 0x7a72, 0x6afa },
	{ 0x7a73, 0x6bb2 },
	{ 0x7a74, 0x704c },
	{ 0x7a75, 0x721b },
	{ 0x7a76, 0x72a7 },
	{ 0x7a77, 0x74d6 },
	{ 0x7a78, 0x74d4 },
	{ 0x7a79, 0x7669 },
	{ 0x7a7a, 0x77d3 },
	{ 0x7a7b, 0x7c50 },
	{ 0x7a7c, 0x7e8f },
	{ 0x7a7d, 0x7e8c },
	{ 0x7a7e, 0x7fbc },
	{ 0x7b21, 0x8617 },
	{ 0x7b22, 0x862d },
	{ 0x7b23, 0x861a },
	{ 0x7b24, 0x8823 },
	{ 0x7b25, 0x8822 },
	{ 0x7b26, 0x8821 },
	{ 0x7b27, 0x881f },
	{ 0x7b28, 0x896a },
	{ 0x7b29, 0x896c },
	{ 0x7b2a, 0x89bd },
	{ 0x7b2b, 0x8b74 },
	{ 0x7b2c, 0x8b77 },
	{ 0x7b2d, 0x8b7d },
	{ 0x7b2e, 0x8d13 },
	{ 0x7b2f, 0x8e8a },
	{ 0x7b30, 0x8e8d },
	{ 0x7b31, 0x8e8b },
	{ 0x7b32, 0x8f5f },
	{ 0x7b33, 0x8faf },
	{ 0x7b34, 0x91ba },
	{ 0x7b35, 0x942e },
	{ 0x7b36, 0x9433 },
	{ 0x7b37, 0x9435 },
	{ 0x7b38, 0x943a },
	{ 0x7b39, 0x9438 },
	{ 0x7b3a, 0x9432 },
	{ 0x7b3b, 0x942b },
	{ 0x7b3c, 0x95e2 },
	{ 0x7b3d, 0x9738 },
	{ 0x7b3e, 0x9739 },
	{ 0x7b3f, 0x9732 },
	{ 0x7b40, 0x97ff },
	{ 0x7b41, 0x9867 },
	{ 0x7b42, 0x9865 },
	{ 0x7b43, 0x9957 },
	{ 0x7b44, 0x9a45 },
	{ 0x7b45, 0x9a43 },
	{ 0x7b46, 0x9a40 },
	{ 0x7b47, 0x9a3e },
	{ 0x7b48, 0x9acf },
	{ 0x7b49, 0x9b54 },
	{ 0x7b4a, 0x9b51 },
	{ 0x7b4b, 0x9c2d },
	{ 0x7b4c, 0x9c25 },
	{ 0x7b4d, 0x9daf },
	{ 0x7b4e, 0x9db4 },
	{ 0x7b4f, 0x9dc2 },
	{ 0x7b50, 0x9db8 },
	{ 0x7b51, 0x9e9d },
	{ 0x7b52, 0x9eef },
	{ 0x7b53, 0x9f19 },
	{ 0x7b54, 0x9f5c },
	{ 0x7b55, 0x9f66 },
	{ 0x7b56, 0x9f67 },
	{ 0x7b57, 0x513c },
	{ 0x7b58, 0x513b },
	{ 0x7b59, 0x56c8 },
	{ 0x7b5a, 0x56ca },
	{ 0x7b5b, 0x56c9 },
	{ 0x7b5c, 0x5b7f },
	{ 0x7b5d, 0x5dd4 },
	{ 0x7b5e, 0x5dd2 },
	{ 0x7b5f, 0x5f4e },
	{ 0x7b60, 0x61ff },
	{ 0x7b61, 0x6524 },
	{ 0x7b62, 0x6b0a },
	{ 0x7b63, 0x6b61 },
	{ 0x7b64, 0x7051 },
	{ 0x7b65, 0x7058 },
	{ 0x7b66, 0x7380 },
	{ 0x7b67, 0x74e4 },
	{ 0x7b68, 0x758a },
	{ 0x7b69, 0x766e },
	{ 0x7b6a, 0x766c },
	{ 0x7b6b, 0x79b3 },
	{ 0x7b6c, 0x7c60 },
	{ 0x7b6d, 0x7c5f },
	{ 0x7b6e, 0x807e },
	{ 0x7b6f, 0x807d },
	{ 0x7b70, 0x81df },
	{ 0x7b71, 0x8972 },
	{ 0x7b72, 0x896f },
	{ 0x7b73, 0x89fc },
	{ 0x7b74, 0x8b80 },
	{ 0x7b75, 0x8d16 },
	{ 0x7b76, 0x8d17 },
	{ 0x7b77, 0x8e91 },
	{ 0x7b78, 0x8e93 },
	{ 0x7b79, 0x8f61 },
	{ 0x7b7a, 0x9148 },
	{ 0x7b7b, 0x9444 },
	{ 0x7b7c, 0x9451 },
	{ 0x7b7d, 0x9452 },
	{ 0x7b7e, 0x973d },
	{ 0x7c21, 0x973e },
	{ 0x7c22, 0x97c3 },
	{ 0x7c23, 0x97c1 },
	{ 0x7c24, 0x986b },
	{ 0x7c25, 0x9955 },
	{ 0x7c26, 0x9a55 },
	{ 0x7c27, 0x9a4d },
	{ 0x7c28, 0x9ad2 },
	{ 0x7c29, 0x9b1a },
	{ 0x7c2a, 0x9c49 },
	{ 0x7c2b, 0x9c31 },
	{ 0x7c2c, 0x9c3e },
	{ 0x7c2d, 0x9c3b },
	{ 0x7c2e, 0x9dd3 },
	{ 0x7c2f, 0x9dd7 },
	{ 0x7c30, 0x9f34 },
	{ 0x7c31, 0x9f6c },
	{ 0x7c32, 0x9f6a },
	{ 0x7c33, 0x9f94 },
	{ 0x7c34, 0x56cc },
	{ 0x7c35, 0x5dd6 },
	{ 0x7c36, 0x6200 },
	{ 0x7c37, 0x6523 },
	{ 0x7c38, 0x652b },
	{ 0x7c39, 0x652a },
	{ 0x7c3a, 0x66ec },
	{ 0x7c3b, 0x6b10 },
	{ 0x7c3c, 0x74da },
	{ 0x7c3d, 0x7aca },
	{ 0x7c3e, 0x7c64 },
	{ 0x7c3f, 0x7c63 },
	{ 0x7c40, 0x7c65 },
	{ 0x7c41, 0x7e93 },
	{ 0x7c42, 0x7e96 },
	{ 0x7c43, 0x7e94 },
	{ 0x7c44, 0x81e2 },
	{ 0x7c45, 0x8638 },
	{ 0x7c46, 0x863f },
	{ 0x7c47, 0x8831 },
	{ 0x7c48, 0x8b8a },
	{ 0x7c49, 0x9090 },
	{ 0x7c4a, 0x908f },
	{ 0x7c4b, 0x9463 },
	{ 0x7c4c, 0x9460 },
	{ 0x7c4d, 0x9464 },
	{ 0x7c4e, 0x9768 },
	{ 0x7c4f, 0x986f },
	{ 0x7c50, 0x995c },
	{ 0x7c51, 0x9a5a },
	{ 0x7c52, 0x9a5b },
	{ 0x7c53, 0x9a57 },
	{ 0x7c54, 0x9ad3 },
	{ 0x7c55, 0x9ad4 },
	{ 0x7c56, 0x9ad1 },
	{ 0x7c57, 0x9c54 },
	{ 0x7c58, 0x9c57 },
	{ 0x7c59, 0x9c56 },
	{ 0x7c5a, 0x9de5 },
	{ 0x7c5b, 0x9e9f },
	{ 0x7c5c, 0x9ef4 },
	{ 0x7c5d, 0x56d1 },
	{ 0x7c5e, 0x58e9 },
	{ 0x7c5f, 0x652c },
	{ 0x7c60, 0x705e },
	{ 0x7c61, 0x7671 },
	{ 0x7c62, 0x7672 },
	{ 0x7c63, 0x77d7 },
	{ 0x7c64, 0x7f50 },
	{ 0x7c65, 0x7f88 },
	{ 0x7c66, 0x8836 },
	{ 0x7c67, 0x8839 },
	{ 0x7c68, 0x8862 },
	{ 0x7c69, 0x8b93 },
	{ 0x7c6a, 0x8b92 },
	{ 0x7c6b, 0x8b96 },
	{ 0x7c6c, 0x8277 },
	{ 0x7c6d, 0x8d1b },
	{ 0x7c6e, 0x91c0 },
	{ 0x7c6f, 0x946a },
	{ 0x7c70, 0x9742 },
	{ 0x7c71, 0x9748 },
	{ 0x7c72, 0x9744 },
	{ 0x7c73, 0x97c6 },
	{ 0x7c74, 0x9870 },
	{ 0x7c75, 0x9a5f },
	{ 0x7c76, 0x9b22 },
	{ 0x7c77, 0x9b58 },
	{ 0x7c78, 0x9c5f },
	{ 0x7c79, 0x9df9 },
	{ 0x7c7a, 0x9dfa },
	{ 0x7c7b, 0x9e7c },
	{ 0x7c7c, 0x9e7d },
	{ 0x7c7d, 0x9f07 },
	{ 0x7c7e, 0x9f77 },
	{ 0x7d21, 0x9f72 },
	{ 0x7d22, 0x5ef3 },
	{ 0x7d23, 0x6b16 },
	{ 0x7d24, 0x7063 },
	{ 0x7d25, 0x7c6c },
	{ 0x7d26, 0x7c6e },
	{ 0x7d27, 0x883b },
	{ 0x7d28, 0x89c0 },
	{ 0x7d29, 0x8ea1 },
	{ 0x7d2a, 0x91c1 },
	{ 0x7d2b, 0x9472 },
	{ 0x7d2c, 0x9470 },
	{ 0x7d2d, 0x9871 },
	{ 0x7d2e, 0x995e },
	{ 0x7d2f, 0x9ad6 },
	{ 0x7d30, 0x9b23 },
	{ 0x7d31, 0x9ecc },
	{ 0x7d32, 0x7064 },
	{ 0x7d33, 0x77da },
	{ 0x7d34, 0x8b9a },
	{ 0x7d35, 0x9477 },
	{ 0x7d36, 0x97c9 },
	{ 0x7d37, 0x9a62 },
	{ 0x7d38, 0x9a65 },
	{ 0x7d39, 0x7e9c },
	{ 0x7d3a, 0x8b9c },
	{ 0x7d3b, 0x8eaa },
	{ 0x7d3c, 0x91c5 },
	{ 0x7d3d, 0x947d },
	{ 0x7d3e, 0x947e },
	{ 0x7d3f, 0x947c },
	{ 0x7d40, 0x9c77 },
	{ 0x7d41, 0x9c78 },
	{ 0x7d42, 0x9ef7 },
	{ 0x7d43, 0x8c54 },
	{ 0x7d44, 0x947f },
	{ 0x7d45, 0x9e1a },
	{ 0x7d46, 0x7228 },
	{ 0x7d47, 0x9a6a },
	{ 0x7d48, 0x9b31 },
	{ 0x7d49, 0x9e1b },
	{ 0x7d4a, 0x9e1e },
	{ 0x7d4b, 0x7c72 }
};

/* CNS 11643 plane #2, leave unicode (UTF8) to be -1 if no mapping available */
table_t cns2_utf_tab[MAX_CNS2_NUM] = {
	{ 0x2121, 0x4e42 },
	{ 0x2122, 0x4e5c },
	{ 0x2123, 0x51f5 },
	{ 0x2124, 0x531a },
	{ 0x2125, 0x5382 },
	{ 0x2126, 0x4e07 },
	{ 0x2127, 0x4e0c },
	{ 0x2128, 0x4e47 },
	{ 0x2129, 0x4e8d },
	{ 0x212a, 0x56d7 },
	{ 0x212b, 0x5c6e },
	{ 0x212c, 0x5f73 },
	{ 0x212d, 0x4e0f },
	{ 0x212e, 0x5187 },
	{ 0x212f, 0x4e0e },
	{ 0x2130, 0x4e2e },
	{ 0x2131, 0x4e93 },
	{ 0x2132, 0x4ec2 },
	{ 0x2133, 0x4ec9 },
	{ 0x2134, 0x4ec8 },
	{ 0x2135, 0x5198 },
	{ 0x2136, 0x52fc },
	{ 0x2137, 0x536c },
	{ 0x2138, 0x53b9 },
	{ 0x2139, 0x5720 },
	{ 0x213a, 0x5903 },
	{ 0x213b, 0x592c },
	{ 0x213c, 0x5c10 },
	{ 0x213d, 0x5dff },
	{ 0x213e, 0x65e1 },
	{ 0x213f, 0x6bb3 },
	{ 0x2140, 0x6bcc },
	{ 0x2141, 0x6c14 },
	{ 0x2142, 0x723f },
	{ 0x2143, 0x4e31 },
	{ 0x2144, 0x4e3c },
	{ 0x2145, 0x4ee8 },
	{ 0x2146, 0x4edc },
	{ 0x2147, 0x4ee9 },
	{ 0x2148, 0x4ee1 },
	{ 0x2149, 0x4edd },
	{ 0x214a, 0x4eda },
	{ 0x214b, 0x520c },
	{ 0x214c, 0x5209 },
	{ 0x214d, 0x531c },
	{ 0x214e, 0x534c },
	{ 0x214f, 0x5722 },
	{ 0x2150, 0x5723 },
	{ 0x2151, 0x5917 },
	{ 0x2152, 0x592f },
	{ 0x2153, 0x5b81 },
	{ 0x2154, 0x5b84 },
	{ 0x2155, 0x5c12 },
	{ 0x2156, 0x5c3b },
	{ 0x2157, 0x5c74 },
	{ 0x2158, 0x5c73 },
	{ 0x2159, 0x5e04 },
	{ 0x215a, 0x5e80 },
	{ 0x215b, 0x5e82 },
	{ 0x215c, 0x5fc9 },
	{ 0x215d, 0x6209 },
	{ 0x215e, 0x6250 },
	{ 0x215f, 0x6c15 },
	{ 0x2160, 0x6c36 },
	{ 0x2161, 0x6c43 },
	{ 0x2162, 0x6c3f },
	{ 0x2163, 0x6c3b },
	{ 0x2164, 0x72ae },
	{ 0x2165, 0x72b0 },
	{ 0x2166, 0x738a },
	{ 0x2167, 0x79b8 },
	{ 0x2168, 0x808a },
	{ 0x2169, 0x961e },
	{ 0x216a, 0x4f0e },
	{ 0x216b, 0x4f18 },
	{ 0x216c, 0x4f2c },
	{ 0x216d, 0x4ef5 },
	{ 0x216e, 0x4f14 },
	{ 0x216f, 0x4ef1 },
	{ 0x2170, 0x4f00 },
	{ 0x2171, 0x4ef7 },
	{ 0x2172, 0x4f08 },
	{ 0x2173, 0x4f1d },
	{ 0x2174, 0x4f02 },
	{ 0x2175, 0x4f05 },
	{ 0x2176, 0x4f22 },
	{ 0x2177, 0x4f13 },
	{ 0x2178, 0x4f04 },
	{ 0x2179, 0x4ef4 },
	{ 0x217a, 0x4f12 },
	{ 0x217b, 0x51b1 },
	{ 0x217c, 0x5213 },
	{ 0x217d, 0x5210 },
	{ 0x217e, 0x52a6 },
	{ 0x2221, 0x5322 },
	{ 0x2222, 0x531f },
	{ 0x2223, 0x534d },
	{ 0x2224, 0x538a },
	{ 0x2225, 0x5407 },
	{ 0x2226, 0x56e1 },
	{ 0x2227, 0x56df },
	{ 0x2228, 0x572e },
	{ 0x2229, 0x572a },
	{ 0x222a, 0x5734 },
	{ 0x222b, 0x593c },
	{ 0x222c, 0x5980 },
	{ 0x222d, 0x597c },
	{ 0x222e, 0x5985 },
	{ 0x222f, 0x597b },
	{ 0x2230, 0x597e },
	{ 0x2231, 0x5977 },
	{ 0x2232, 0x597f },
	{ 0x2233, 0x5b56 },
	{ 0x2234, 0x5c15 },
	{ 0x2235, 0x5c25 },
	{ 0x2236, 0x5c7c },
	{ 0x2237, 0x5c7a },
	{ 0x2238, 0x5c7b },
	{ 0x2239, 0x5c7e },
	{ 0x223a, 0x5ddf },
	{ 0x223b, 0x5e75 },
	{ 0x223c, 0x5e84 },
	{ 0x223d, 0x5f02 },
	{ 0x223e, 0x5f1a },
	{ 0x223f, 0x5f74 },
	{ 0x2240, 0x5fd5 },
	{ 0x2241, 0x5fd4 },
	{ 0x2242, 0x5fcf },
	{ 0x2243, 0x625c },
	{ 0x2244, 0x625e },
	{ 0x2245, 0x6264 },
	{ 0x2246, 0x6261 },
	{ 0x2247, 0x6266 },
	{ 0x2248, 0x6262 },
	{ 0x2249, 0x6259 },
	{ 0x224a, 0x6260 },
	{ 0x224b, 0x625a },
	{ 0x224c, 0x6265 },
	{ 0x224d, 0x6537 },
	{ 0x224e, 0x65ef },
	{ 0x224f, 0x65ee },
	{ 0x2250, 0x673e },
	{ 0x2251, 0x6739 },
	{ 0x2252, 0x6738 },
	{ 0x2253, 0x673b },
	{ 0x2254, 0x673a },
	{ 0x2255, 0x673f },
	{ 0x2256, 0x673c },
	{ 0x2257, 0x6733 },
	{ 0x2258, 0x6c18 },
	{ 0x2259, 0x6c46 },
	{ 0x225a, 0x6c52 },
	{ 0x225b, 0x6c5c },
	{ 0x225c, 0x6c4f },
	{ 0x225d, 0x6c4a },
	{ 0x225e, 0x6c54 },
	{ 0x225f, 0x6c4b },
	{ 0x2260, 0x6c4c },
	{ 0x2261, 0x7071 },
	{ 0x2262, 0x725e },
	{ 0x2263, 0x72b4 },
	{ 0x2264, 0x72b5 },
	{ 0x2265, 0x738e },
	{ 0x2266, 0x752a },
	{ 0x2267, 0x767f },
	{ 0x2268, 0x7a75 },
	{ 0x2269, 0x7f51 },
	{ 0x226a, 0x8278 },
	{ 0x226b, 0x827c },
	{ 0x226c, 0x8280 },
	{ 0x226d, 0x827d },
	{ 0x226e, 0x827f },
	{ 0x226f, 0x864d },
	{ 0x2270, 0x897e },
	{ 0x2271, 0x9099 },
	{ 0x2272, 0x9097 },
	{ 0x2273, 0x9098 },
	{ 0x2274, 0x909b },
	{ 0x2275, 0x9094 },
	{ 0x2276, 0x9622 },
	{ 0x2277, 0x9624 },
	{ 0x2278, 0x9620 },
	{ 0x2279, 0x9623 },
	{ 0x227a, 0x4f56 },
	{ 0x227b, 0x4f3b },
	{ 0x227c, 0x4f62 },
	{ 0x227d, 0x4f49 },
	{ 0x227e, 0x4f53 },
	{ 0x2321, 0x4f64 },
	{ 0x2322, 0x4f3e },
	{ 0x2323, 0x4f67 },
	{ 0x2324, 0x4f52 },
	{ 0x2325, 0x4f5f },
	{ 0x2326, 0x4f41 },
	{ 0x2327, 0x4f58 },
	{ 0x2328, 0x4f2d },
	{ 0x2329, 0x4f33 },
	{ 0x232a, 0x4f3f },
	{ 0x232b, 0x4f61 },
	{ 0x232c, 0x518f },
	{ 0x232d, 0x51b9 },
	{ 0x232e, 0x521c },
	{ 0x232f, 0x521e },
	{ 0x2330, 0x5221 },
	{ 0x2331, 0x52ad },
	{ 0x2332, 0x52ae },
	{ 0x2333, 0x5309 },
	{ 0x2334, 0x5363 },
	{ 0x2335, 0x5372 },
	{ 0x2336, 0x538e },
	{ 0x2337, 0x538f },
	{ 0x2338, 0x5430 },
	{ 0x2339, 0x5437 },
	{ 0x233a, 0x542a },
	{ 0x233b, 0x5454 },
	{ 0x233c, 0x5445 },
	{ 0x233d, 0x5419 },
	{ 0x233e, 0x541c },
	{ 0x233f, 0x5425 },
	{ 0x2340, 0x5418 },
	{ 0x2341, 0x543d },
	{ 0x2342, 0x544f },
	{ 0x2343, 0x5441 },
	{ 0x2344, 0x5428 },
	{ 0x2345, 0x5424 },
	{ 0x2346, 0x5447 },
	{ 0x2347, 0x56ee },
	{ 0x2348, 0x56e7 },
	{ 0x2349, 0x56e5 },
	{ 0x234a, 0x5741 },
	{ 0x234b, 0x5745 },
	{ 0x234c, 0x574c },
	{ 0x234d, 0x5749 },
	{ 0x234e, 0x574b },
	{ 0x234f, 0x5752 },
	{ 0x2350, 0x5906 },
	{ 0x2351, 0x5940 },
	{ 0x2352, 0x59a6 },
	{ 0x2353, 0x5998 },
	{ 0x2354, 0x59a0 },
	{ 0x2355, 0x5997 },
	{ 0x2356, 0x598e },
	{ 0x2357, 0x59a2 },
	{ 0x2358, 0x5990 },
	{ 0x2359, 0x598f },
	{ 0x235a, 0x59a7 },
	{ 0x235b, 0x59a1 },
	{ 0x235c, 0x5b8e },
	{ 0x235d, 0x5b92 },
	{ 0x235e, 0x5c28 },
	{ 0x235f, 0x5c2a },
	{ 0x2360, 0x5c8d },
	{ 0x2361, 0x5c8f },
	{ 0x2362, 0x5c88 },
	{ 0x2363, 0x5c8b },
	{ 0x2364, 0x5c89 },
	{ 0x2365, 0x5c92 },
	{ 0x2366, 0x5c8a },
	{ 0x2367, 0x5c86 },
	{ 0x2368, 0x5c93 },
	{ 0x2369, 0x5c95 },
	{ 0x236a, 0x5de0 },
	{ 0x236b, 0x5e0a },
	{ 0x236c, 0x5e0e },
	{ 0x236d, 0x5e8b },
	{ 0x236e, 0x5e89 },
	{ 0x236f, 0x5e8c },
	{ 0x2370, 0x5e88 },
	{ 0x2371, 0x5e8d },
	{ 0x2372, 0x5f05 },
	{ 0x2373, 0x5f1d },
	{ 0x2374, 0x5f78 },
	{ 0x2375, 0x5f76 },
	{ 0x2376, 0x5fd2 },
	{ 0x2377, 0x5fd1 },
	{ 0x2378, 0x5fd0 },
	{ 0x2379, 0x5fed },
	{ 0x237a, 0x5fe8 },
	{ 0x237b, 0x5fee },
	{ 0x237c, 0x5ff3 },
	{ 0x237d, 0x5fe1 },
	{ 0x237e, 0x5fe4 },
	{ 0x2421, 0x5fe3 },
	{ 0x2422, 0x5ffa },
	{ 0x2423, 0x5fef },
	{ 0x2424, 0x5ff7 },
	{ 0x2425, 0x5ffb },
	{ 0x2426, 0x6000 },
	{ 0x2427, 0x5ff4 },
	{ 0x2428, 0x623a },
	{ 0x2429, 0x6283 },
	{ 0x242a, 0x628c },
	{ 0x242b, 0x628e },
	{ 0x242c, 0x628f },
	{ 0x242d, 0x6294 },
	{ 0x242e, 0x6287 },
	{ 0x242f, 0x6271 },
	{ 0x2430, 0x627b },
	{ 0x2431, 0x627a },
	{ 0x2432, 0x6270 },
	{ 0x2433, 0x6281 },
	{ 0x2434, 0x6288 },
	{ 0x2435, 0x6277 },
	{ 0x2436, 0x627d },
	{ 0x2437, 0x6272 },
	{ 0x2438, 0x6274 },
	{ 0x2439, 0x65f0 },
	{ 0x243a, 0x65f4 },
	{ 0x243b, 0x65f3 },
	{ 0x243c, 0x65f2 },
	{ 0x243d, 0x65f5 },
	{ 0x243e, 0x6745 },
	{ 0x243f, 0x6747 },
	{ 0x2440, 0x6759 },
	{ 0x2441, 0x6755 },
	{ 0x2442, 0x674c },
	{ 0x2443, 0x6748 },
	{ 0x2444, 0x675d },
	{ 0x2445, 0x674d },
	{ 0x2446, 0x675a },
	{ 0x2447, 0x674b },
	{ 0x2448, 0x6bd0 },
	{ 0x2449, 0x6c19 },
	{ 0x244a, 0x6c1a },
	{ 0x244b, 0x6c78 },
	{ 0x244c, 0x6c67 },
	{ 0x244d, 0x6c6b },
	{ 0x244e, 0x6c84 },
	{ 0x244f, 0x6c8b },
	{ 0x2450, 0x6c8f },
	{ 0x2451, 0x6c71 },
	{ 0x2452, 0x6c6f },
	{ 0x2453, 0x6c69 },
	{ 0x2454, 0x6c9a },
	{ 0x2455, 0x6c6d },
	{ 0x2456, 0x6c87 },
	{ 0x2457, 0x6c95 },
	{ 0x2458, 0x6c9c },
	{ 0x2459, 0x6c66 },
	{ 0x245a, 0x6c73 },
	{ 0x245b, 0x6c65 },
	{ 0x245c, 0x6c7b },
	{ 0x245d, 0x6c8e },
	{ 0x245e, 0x7074 },
	{ 0x245f, 0x707a },
	{ 0x2460, 0x7263 },
	{ 0x2461, 0x72bf },
	{ 0x2462, 0x72bd },
	{ 0x2463, 0x72c3 },
	{ 0x2464, 0x72c6 },
	{ 0x2465, 0x72c1 },
	{ 0x2466, 0x72ba },
	{ 0x2467, 0x72c5 },
	{ 0x2468, 0x7395 },
	{ 0x2469, 0x7397 },
	{ 0x246a, 0x7393 },
	{ 0x246b, 0x7394 },
	{ 0x246c, 0x7392 },
	{ 0x246d, 0x753a },
	{ 0x246e, 0x7539 },
	{ 0x246f, 0x7594 },
	{ 0x2470, 0x7595 },
	{ 0x2471, 0x7681 },
	{ 0x2472, 0x793d },
	{ 0x2473, 0x8034 },
	{ 0x2474, 0x8095 },
	{ 0x2475, 0x8099 },
	{ 0x2476, 0x8090 },
	{ 0x2477, 0x8092 },
	{ 0x2478, 0x809c },
	{ 0x2479, 0x8290 },
	{ 0x247a, 0x828f },
	{ 0x247b, 0x8285 },
	{ 0x247c, 0x828e },
	{ 0x247d, 0x8291 },
	{ 0x247e, 0x8293 },
	{ 0x2521, 0x828a },
	{ 0x2522, 0x8283 },
	{ 0x2523, 0x8284 },
	{ 0x2524, 0x8c78 },
	{ 0x2525, 0x8fc9 },
	{ 0x2526, 0x8fbf },
	{ 0x2527, 0x909f },
	{ 0x2528, 0x90a1 },
	{ 0x2529, 0x90a5 },
	{ 0x252a, 0x909e },
	{ 0x252b, 0x90a7 },
	{ 0x252c, 0x90a0 },
	{ 0x252d, 0x9630 },
	{ 0x252e, 0x9628 },
	{ 0x252f, 0x962f },
	{ 0x2530, 0x962d },
	{ 0x2531, 0x4e33 },
	{ 0x2532, 0x4f98 },
	{ 0x2533, 0x4f7c },
	{ 0x2534, 0x4f85 },
	{ 0x2535, 0x4f7d },
	{ 0x2536, 0x4f80 },
	{ 0x2537, 0x4f87 },
	{ 0x2538, 0x4f76 },
	{ 0x2539, 0x4f74 },
	{ 0x253a, 0x4f89 },
	{ 0x253b, 0x4f84 },
	{ 0x253c, 0x4f77 },
	{ 0x253d, 0x4f4c },
	{ 0x253e, 0x4f97 },
	{ 0x253f, 0x4f6a },
	{ 0x2540, 0x4f9a },
	{ 0x2541, 0x4f79 },
	{ 0x2542, 0x4f81 },
	{ 0x2543, 0x4f78 },
	{ 0x2544, 0x4f90 },
	{ 0x2545, 0x4f9c },
	{ 0x2546, 0x4f94 },
	{ 0x2547, 0x4f9e },
	{ 0x2548, 0x4f92 },
	{ 0x2549, 0x4f82 },
	{ 0x254a, 0x4f95 },
	{ 0x254b, 0x4f6b },
	{ 0x254c, 0x4f6e },
	{ 0x254d, 0x519e },
	{ 0x254e, 0x51bc },
	{ 0x254f, 0x51be },
	{ 0x2550, 0x5235 },
	{ 0x2551, 0x5232 },
	{ 0x2552, 0x5233 },
	{ 0x2553, 0x5246 },
	{ 0x2554, 0x5231 },
	{ 0x2555, 0x52bc },
	{ 0x2556, 0x530a },
	{ 0x2557, 0x530b },
	{ 0x2558, 0x533c },
	{ 0x2559, 0x5392 },
	{ 0x255a, 0x5394 },
	{ 0x255b, 0x5487 },
	{ 0x255c, 0x547f },
	{ 0x255d, 0x5481 },
	{ 0x255e, 0x5491 },
	{ 0x255f, 0x5482 },
	{ 0x2560, 0x5488 },
	{ 0x2561, 0x546b },
	{ 0x2562, 0x547a },
	{ 0x2563, 0x547e },
	{ 0x2564, 0x5465 },
	{ 0x2565, 0x546c },
	{ 0x2566, 0x5474 },
	{ 0x2567, 0x5466 },
	{ 0x2568, 0x548d },
	{ 0x2569, 0x546f },
	{ 0x256a, 0x5461 },
	{ 0x256b, 0x5460 },
	{ 0x256c, 0x5498 },
	{ 0x256d, 0x5463 },
	{ 0x256e, 0x5467 },
	{ 0x256f, 0x5464 },
	{ 0x2570, 0x56f7 },
	{ 0x2571, 0x56f9 },
	{ 0x2572, 0x576f },
	{ 0x2573, 0x5772 },
	{ 0x2574, 0x576d },
	{ 0x2575, 0x576b },
	{ 0x2576, 0x5771 },
	{ 0x2577, 0x5770 },
	{ 0x2578, 0x5776 },
	{ 0x2579, 0x5780 },
	{ 0x257a, 0x5775 },
	{ 0x257b, 0x577b },
	{ 0x257c, 0x5773 },
	{ 0x257d, 0x5774 },
	{ 0x257e, 0x5762 },
	{ 0x2621, 0x5768 },
	{ 0x2622, 0x577d },
	{ 0x2623, 0x590c },
	{ 0x2624, 0x5945 },
	{ 0x2625, 0x59b5 },
	{ 0x2626, 0x59ba },
	{ 0x2627, 0x59cf },
	{ 0x2628, 0x59ce },
	{ 0x2629, 0x59b2 },
	{ 0x262a, 0x59cc },
	{ 0x262b, 0x59c1 },
	{ 0x262c, 0x59b6 },
	{ 0x262d, 0x59bc },
	{ 0x262e, 0x59c3 },
	{ 0x262f, 0x59d6 },
	{ 0x2630, 0x59b1 },
	{ 0x2631, 0x59bd },
	{ 0x2632, 0x59c0 },
	{ 0x2633, 0x59c8 },
	{ 0x2634, 0x59b4 },
	{ 0x2635, 0x59c7 },
	{ 0x2636, 0x5b62 },
	{ 0x2637, 0x5b65 },
	{ 0x2638, 0x5b93 },
	{ 0x2639, 0x5b95 },
	{ 0x263a, 0x5c44 },
	{ 0x263b, 0x5c47 },
	{ 0x263c, 0x5cae },
	{ 0x263d, 0x5ca4 },
	{ 0x263e, 0x5ca0 },
	{ 0x263f, 0x5cb5 },
	{ 0x2640, 0x5caf },
	{ 0x2641, 0x5ca8 },
	{ 0x2642, 0x5cac },
	{ 0x2643, 0x5c9f },
	{ 0x2644, 0x5ca3 },
	{ 0x2645, 0x5cad },
	{ 0x2646, 0x5ca2 },
	{ 0x2647, 0x5caa },
	{ 0x2648, 0x5ca7 },
	{ 0x2649, 0x5c9d },
	{ 0x264a, 0x5ca5 },
	{ 0x264b, 0x5cb6 },
	{ 0x264c, 0x5cb0 },
	{ 0x264d, 0x5ca6 },
	{ 0x264e, 0x5e17 },
	{ 0x264f, 0x5e14 },
	{ 0x2650, 0x5e19 },
	{ 0x2651, 0x5f28 },
	{ 0x2652, 0x5f22 },
	{ 0x2653, 0x5f23 },
	{ 0x2654, 0x5f24 },
	{ 0x2655, 0x5f54 },
	{ 0x2656, 0x5f82 },
	{ 0x2657, 0x5f7e },
	{ 0x2658, 0x5f7d },
	{ 0x2659, 0x5fde },
	{ 0x265a, 0x5fe5 },
	{ 0x265b, 0x602d },
	{ 0x265c, 0x6026 },
	{ 0x265d, 0x6019 },
	{ 0x265e, 0x6032 },
	{ 0x265f, 0x600b },
	{ 0x2660, 0x6034 },
	{ 0x2661, 0x600a },
	{ 0x2662, 0x6017 },
	{ 0x2663, 0x6033 },
	{ 0x2664, 0x601a },
	{ 0x2665, 0x601e },
	{ 0x2666, 0x602c },
	{ 0x2667, 0x6022 },
	{ 0x2668, 0x600d },
	{ 0x2669, 0x6010 },
	{ 0x266a, 0x602e },
	{ 0x266b, 0x6013 },
	{ 0x266c, 0x6011 },
	{ 0x266d, 0x600c },
	{ 0x266e, 0x6009 },
	{ 0x266f, 0x601c },
	{ 0x2670, 0x6214 },
	{ 0x2671, 0x623d },
	{ 0x2672, 0x62ad },
	{ 0x2673, 0x62b4 },
	{ 0x2674, 0x62d1 },
	{ 0x2675, 0x62be },
	{ 0x2676, 0x62aa },
	{ 0x2677, 0x62b6 },
	{ 0x2678, 0x62ca },
	{ 0x2679, 0x62ae },
	{ 0x267a, 0x62b3 },
	{ 0x267b, 0x62af },
	{ 0x267c, 0x62bb },
	{ 0x267d, 0x62a9 },
	{ 0x267e, 0x62b0 },
	{ 0x2721, 0x62b8 },
	{ 0x2722, 0x653d },
	{ 0x2723, 0x65a8 },
	{ 0x2724, 0x65bb },
	{ 0x2725, 0x6609 },
	{ 0x2726, 0x65fc },
	{ 0x2727, 0x6604 },
	{ 0x2728, 0x6612 },
	{ 0x2729, 0x6608 },
	{ 0x272a, 0x65fb },
	{ 0x272b, 0x6603 },
	{ 0x272c, 0x660b },
	{ 0x272d, 0x660d },
	{ 0x272e, 0x6605 },
	{ 0x272f, 0x65fd },
	{ 0x2730, 0x6611 },
	{ 0x2731, 0x6610 },
	{ 0x2732, 0x66f6 },
	{ 0x2733, 0x670a },
	{ 0x2734, 0x6785 },
	{ 0x2735, 0x676c },
	{ 0x2736, 0x678e },
	{ 0x2737, 0x6792 },
	{ 0x2738, 0x6776 },
	{ 0x2739, 0x677b },
	{ 0x273a, 0x6798 },
	{ 0x273b, 0x6786 },
	{ 0x273c, 0x6784 },
	{ 0x273d, 0x6774 },
	{ 0x273e, 0x678d },
	{ 0x273f, 0x678c },
	{ 0x2740, 0x677a },
	{ 0x2741, 0x679f },
	{ 0x2742, 0x6791 },
	{ 0x2743, 0x6799 },
	{ 0x2744, 0x6783 },
	{ 0x2745, 0x677d },
	{ 0x2746, 0x6781 },
	{ 0x2747, 0x6778 },
	{ 0x2748, 0x6779 },
	{ 0x2749, 0x6794 },
	{ 0x274a, 0x6b25 },
	{ 0x274b, 0x6b80 },
	{ 0x274c, 0x6b7e },
	{ 0x274d, 0x6bde },
	{ 0x274e, 0x6c1d },
	{ 0x274f, 0x6c93 },
	{ 0x2750, 0x6cec },
	{ 0x2751, 0x6ceb },
	{ 0x2752, 0x6cee },
	{ 0x2753, 0x6cd9 },
	{ 0x2754, 0x6cb6 },
	{ 0x2755, 0x6cd4 },
	{ 0x2756, 0x6cad },
	{ 0x2757, 0x6ce7 },
	{ 0x2758, 0x6cb7 },
	{ 0x2759, 0x6cd0 },
	{ 0x275a, 0x6cc2 },
	{ 0x275b, 0x6cba },
	{ 0x275c, 0x6cc3 },
	{ 0x275d, 0x6cc6 },
	{ 0x275e, 0x6ced },
	{ 0x275f, 0x6cf2 },
	{ 0x2760, 0x6cd2 },
	{ 0x2761, 0x6cdd },
	{ 0x2762, 0x6cb4 },
	{ 0x2763, 0x6c8a },
	{ 0x2764, 0x6c9d },
	{ 0x2765, 0x6c80 },
	{ 0x2766, 0x6cde },
	{ 0x2767, 0x6cc0 },
	{ 0x2768, 0x6d30 },
	{ 0x2769, 0x6ccd },
	{ 0x276a, 0x6cc7 },
	{ 0x276b, 0x6cb0 },
	{ 0x276c, 0x6cf9 },
	{ 0x276d, 0x6ccf },
	{ 0x276e, 0x6ce9 },
	{ 0x276f, 0x6cd1 },
	{ 0x2770, 0x7094 },
	{ 0x2771, 0x7098 },
	{ 0x2772, 0x7085 },
	{ 0x2773, 0x7093 },
	{ 0x2774, 0x7086 },
	{ 0x2775, 0x7084 },
	{ 0x2776, 0x7091 },
	{ 0x2777, 0x7096 },
	{ 0x2778, 0x7082 },
	{ 0x2779, 0x709a },
	{ 0x277a, 0x7083 },
	{ 0x277b, 0x726a },
	{ 0x277c, 0x72d6 },
	{ 0x277d, 0x72cb },
	{ 0x277e, 0x72d8 },
	{ 0x2821, 0x72c9 },
	{ 0x2822, 0x72dc },
	{ 0x2823, 0x72d2 },
	{ 0x2824, 0x72d4 },
	{ 0x2825, 0x72da },
	{ 0x2826, 0x72cc },
	{ 0x2827, 0x72d1 },
	{ 0x2828, 0x73a4 },
	{ 0x2829, 0x73a1 },
	{ 0x282a, 0x73ad },
	{ 0x282b, 0x73a6 },
	{ 0x282c, 0x73a2 },
	{ 0x282d, 0x73a0 },
	{ 0x282e, 0x73ac },
	{ 0x282f, 0x739d },
	{ 0x2830, 0x74dd },
	{ 0x2831, 0x74e8 },
	{ 0x2832, 0x753f },
	{ 0x2833, 0x7540 },
	{ 0x2834, 0x753e },
	{ 0x2835, 0x758c },
	{ 0x2836, 0x7598 },
	{ 0x2837, 0x76af },
	{ 0x2838, 0x76f3 },
	{ 0x2839, 0x76f1 },
	{ 0x283a, 0x76f0 },
	{ 0x283b, 0x76f5 },
	{ 0x283c, 0x77f8 },
	{ 0x283d, 0x77fc },
	{ 0x283e, 0x77f9 },
	{ 0x283f, 0x77fb },
	{ 0x2840, 0x77fa },
	{ 0x2841, 0x77f7 },
	{ 0x2842, 0x7942 },
	{ 0x2843, 0x793f },
	{ 0x2844, 0x79c5 },
	{ 0x2845, 0x7a78 },
	{ 0x2846, 0x7a7b },
	{ 0x2847, 0x7afb },
	{ 0x2848, 0x7c75 },
	{ 0x2849, 0x7cfd },
	{ 0x284a, 0x8035 },
	{ 0x284b, 0x808f },
	{ 0x284c, 0x80ae },
	{ 0x284d, 0x80a3 },
	{ 0x284e, 0x80b8 },
	{ 0x284f, 0x80b5 },
	{ 0x2850, 0x80ad },
	{ 0x2851, 0x8220 },
	{ 0x2852, 0x82a0 },
	{ 0x2853, 0x82c0 },
	{ 0x2854, 0x82ab },
	{ 0x2855, 0x829a },
	{ 0x2856, 0x8298 },
	{ 0x2857, 0x829b },
	{ 0x2858, 0x82b5 },
	{ 0x2859, 0x82a7 },
	{ 0x285a, 0x82ae },
	{ 0x285b, 0x82bc },
	{ 0x285c, 0x829e },
	{ 0x285d, 0x82ba },
	{ 0x285e, 0x82b4 },
	{ 0x285f, 0x82a8 },
	{ 0x2860, 0x82a1 },
	{ 0x2861, 0x82a9 },
	{ 0x2862, 0x82c2 },
	{ 0x2863, 0x82a4 },
	{ 0x2864, 0x82c3 },
	{ 0x2865, 0x82b6 },
	{ 0x2866, 0x82a2 },
	{ 0x2867, 0x8670 },
	{ 0x2868, 0x866f },
	{ 0x2869, 0x866d },
	{ 0x286a, 0x866e },
	{ 0x286b, 0x8c56 },
	{ 0x286c, 0x8fd2 },
	{ 0x286d, 0x8fcb },
	{ 0x286e, 0x8fd3 },
	{ 0x286f, 0x8fcd },
	{ 0x2870, 0x8fd6 },
	{ 0x2871, 0x8fd5 },
	{ 0x2872, 0x8fd7 },
	{ 0x2873, 0x90b2 },
	{ 0x2874, 0x90b4 },
	{ 0x2875, 0x90af },
	{ 0x2876, 0x90b3 },
	{ 0x2877, 0x90b0 },
	{ 0x2878, 0x9639 },
	{ 0x2879, 0x963d },
	{ 0x287a, 0x963c },
	{ 0x287b, 0x963a },
	{ 0x287c, 0x9643 },
	{ 0x287d, 0x4fcd },
	{ 0x287e, 0x4fc5 },
	{ 0x2921, 0x4fd3 },
	{ 0x2922, 0x4fb2 },
	{ 0x2923, 0x4fc9 },
	{ 0x2924, 0x4fcb },
	{ 0x2925, 0x4fc1 },
	{ 0x2926, 0x4fd4 },
	{ 0x2927, 0x4fdc },
	{ 0x2928, 0x4fd9 },
	{ 0x2929, 0x4fbb },
	{ 0x292a, 0x4fb3 },
	{ 0x292b, 0x4fdb },
	{ 0x292c, 0x4fc7 },
	{ 0x292d, 0x4fd6 },
	{ 0x292e, 0x4fba },
	{ 0x292f, 0x4fc0 },
	{ 0x2930, 0x4fb9 },
	{ 0x2931, 0x4fec },
	{ 0x2932, 0x5244 },
	{ 0x2933, 0x5249 },
	{ 0x2934, 0x52c0 },
	{ 0x2935, 0x52c2 },
	{ 0x2936, 0x533d },
	{ 0x2937, 0x537c },
	{ 0x2938, 0x5397 },
	{ 0x2939, 0x5396 },
	{ 0x293a, 0x5399 },
	{ 0x293b, 0x5398 },
	{ 0x293c, 0x54ba },
	{ 0x293d, 0x54a1 },
	{ 0x293e, 0x54ad },
	{ 0x293f, 0x54a5 },
	{ 0x2940, 0x54cf },
	{ 0x2941, 0x54c3 },
	{ 0x2942, 0x830d },
	{ 0x2943, 0x54b7 },
	{ 0x2944, 0x54ae },
	{ 0x2945, 0x54d6 },
	{ 0x2946, 0x54b6 },
	{ 0x2947, 0x54c5 },
	{ 0x2948, 0x54c6 },
	{ 0x2949, 0x54a0 },
	{ 0x294a, 0x5470 },
	{ 0x294b, 0x54bc },
	{ 0x294c, 0x54a2 },
	{ 0x294d, 0x54be },
	{ 0x294e, 0x5472 },
	{ 0x294f, 0x54de },
	{ 0x2950, 0x54b0 },
	{ 0x2951, 0x57b5 },
	{ 0x2952, 0x579e },
	{ 0x2953, 0x579f },
	{ 0x2954, 0x57a4 },
	{ 0x2955, 0x578c },
	{ 0x2956, 0x5797 },
	{ 0x2957, 0x579d },
	{ 0x2958, 0x579b },
	{ 0x2959, 0x5794 },
	{ 0x295a, 0x5798 },
	{ 0x295b, 0x578f },
	{ 0x295c, 0x5799 },
	{ 0x295d, 0x57a5 },
	{ 0x295e, 0x579a },
	{ 0x295f, 0x5795 },
	{ 0x2960, 0x58f4 },
	{ 0x2961, 0x590d },
	{ 0x2962, 0x5953 },
	{ 0x2963, 0x59e1 },
	{ 0x2964, 0x59de },
	{ 0x2965, 0x59ee },
	{ 0x2966, 0x5a00 },
	{ 0x2967, 0x59f1 },
	{ 0x2968, 0x59dd },
	{ 0x2969, 0x59fa },
	{ 0x296a, 0x59fd },
	{ 0x296b, 0x59fc },
	{ 0x296c, 0x59f6 },
	{ 0x296d, 0x59e4 },
	{ 0x296e, 0x59f2 },
	{ 0x296f, 0x59f7 },
	{ 0x2970, 0x59db },
	{ 0x2971, 0x59e9 },
	{ 0x2972, 0x59f3 },
	{ 0x2973, 0x59f5 },
	{ 0x2974, 0x59e0 },
	{ 0x2975, 0x59fe },
	{ 0x2976, 0x59f4 },
	{ 0x2977, 0x59ed },
	{ 0x2978, 0x5ba8 },
	{ 0x2979, 0x5c4c },
	{ 0x297a, 0x5cd0 },
	{ 0x297b, 0x5cd8 },
	{ 0x297c, 0x5ccc },
	{ 0x297d, 0x5cd7 },
	{ 0x297e, 0x5ccb },
	{ 0x2a21, 0x5cdb },
	{ 0x2a22, 0x5cde },
	{ 0x2a23, 0x5cda },
	{ 0x2a24, 0x5cc9 },
	{ 0x2a25, 0x5cc7 },
	{ 0x2a26, 0x5cca },
	{ 0x2a27, 0x5cd6 },
	{ 0x2a28, 0x5cd3 },
	{ 0x2a29, 0x5cd4 },
	{ 0x2a2a, 0x5ccf },
	{ 0x2a2b, 0x5cc8 },
	{ 0x2a2c, 0x5cc6 },
	{ 0x2a2d, 0x5cce },
	{ 0x2a2e, 0x5cdf },
	{ 0x2a2f, 0x5cf8 },
	{ 0x2a30, 0x5df9 },
	{ 0x2a31, 0x5e21 },
	{ 0x2a32, 0x5e22 },
	{ 0x2a33, 0x5e23 },
	{ 0x2a34, 0x5e20 },
	{ 0x2a35, 0x5e24 },
	{ 0x2a36, 0x5eb0 },
	{ 0x2a37, 0x5ea4 },
	{ 0x2a38, 0x5ea2 },
	{ 0x2a39, 0x5e9b },
	{ 0x2a3a, 0x5ea3 },
	{ 0x2a3b, 0x5ea5 },
	{ 0x2a3c, 0x5f07 },
	{ 0x2a3d, 0x5f2e },
	{ 0x2a3e, 0x5f56 },
	{ 0x2a3f, 0x5f86 },
	{ 0x2a40, 0x6037 },
	{ 0x2a41, 0x6039 },
	{ 0x2a42, 0x6054 },
	{ 0x2a43, 0x6072 },
	{ 0x2a44, 0x605e },
	{ 0x2a45, 0x6045 },
	{ 0x2a46, 0x6053 },
	{ 0x2a47, 0x6047 },
	{ 0x2a48, 0x6049 },
	{ 0x2a49, 0x605b },
	{ 0x2a4a, 0x604c },
	{ 0x2a4b, 0x6040 },
	{ 0x2a4c, 0x6042 },
	{ 0x2a4d, 0x605f },
	{ 0x2a4e, 0x6024 },
	{ 0x2a4f, 0x6044 },
	{ 0x2a50, 0x6058 },
	{ 0x2a51, 0x6066 },
	{ 0x2a52, 0x606e },
	{ 0x2a53, 0x6242 },
	{ 0x2a54, 0x6243 },
	{ 0x2a55, 0x62cf },
	{ 0x2a56, 0x630d },
	{ 0x2a57, 0x630b },
	{ 0x2a58, 0x62f5 },
	{ 0x2a59, 0x630e },
	{ 0x2a5a, 0x6303 },
	{ 0x2a5b, 0x62eb },
	{ 0x2a5c, 0x62f9 },
	{ 0x2a5d, 0x630f },
	{ 0x2a5e, 0x630c },
	{ 0x2a5f, 0x62f8 },
	{ 0x2a60, 0x62f6 },
	{ 0x2a61, 0x6300 },
	{ 0x2a62, 0x6313 },
	{ 0x2a63, 0x6314 },
	{ 0x2a64, 0x62fa },
	{ 0x2a65, 0x6315 },
	{ 0x2a66, 0x62fb },
	{ 0x2a67, 0x62f0 },
	{ 0x2a68, 0x6541 },
	{ 0x2a69, 0x6543 },
	{ 0x2a6a, 0x65aa },
	{ 0x2a6b, 0x65bf },
	{ 0x2a6c, 0x6636 },
	{ 0x2a6d, 0x6621 },
	{ 0x2a6e, 0x6632 },
	{ 0x2a6f, 0x6635 },
	{ 0x2a70, 0x661c },
	{ 0x2a71, 0x6626 },
	{ 0x2a72, 0x6622 },
	{ 0x2a73, 0x6633 },
	{ 0x2a74, 0x662b },
	{ 0x2a75, 0x663a },
	{ 0x2a76, 0x661d },
	{ 0x2a77, 0x6634 },
	{ 0x2a78, 0x6639 },
	{ 0x2a79, 0x662e },
	{ 0x2a7a, 0x670f },
	{ 0x2a7b, 0x6710 },
	{ 0x2a7c, 0x67c1 },
	{ 0x2a7d, 0x67f2 },
	{ 0x2a7e, 0x67c8 },
	{ 0x2b21, 0x67ba },
	{ 0x2b22, 0x67dc },
	{ 0x2b23, 0x67bb },
	{ 0x2b24, 0x67f8 },
	{ 0x2b25, 0x67d8 },
	{ 0x2b26, 0x67c0 },
	{ 0x2b27, 0x67b7 },
	{ 0x2b28, 0x67c5 },
	{ 0x2b29, 0x67eb },
	{ 0x2b2a, 0x67e4 },
	{ 0x2b2b, 0x67df },
	{ 0x2b2c, 0x67b5 },
	{ 0x2b2d, 0x67cd },
	{ 0x2b2e, 0x67b3 },
	{ 0x2b2f, 0x67f7 },
	{ 0x2b30, 0x67f6 },
	{ 0x2b31, 0x67ee },
	{ 0x2b32, 0x67e3 },
	{ 0x2b33, 0x67c2 },
	{ 0x2b34, 0x67b9 },
	{ 0x2b35, 0x67ce },
	{ 0x2b36, 0x67e7 },
	{ 0x2b37, 0x67f0 },
	{ 0x2b38, 0x67b2 },
	{ 0x2b39, 0x67fc },
	{ 0x2b3a, 0x67c6 },
	{ 0x2b3b, 0x67ed },
	{ 0x2b3c, 0x67cc },
	{ 0x2b3d, 0x67ae },
	{ 0x2b3e, 0x67e6 },
	{ 0x2b3f, 0x67db },
	{ 0x2b40, 0x67fa },
	{ 0x2b41, 0x67c9 },
	{ 0x2b42, 0x67ca },
	{ 0x2b43, 0x67c3 },
	{ 0x2b44, 0x67ea },
	{ 0x2b45, 0x67cb },
	{ 0x2b46, 0x6b28 },
	{ 0x2b47, 0x6b82 },
	{ 0x2b48, 0x6b84 },
	{ 0x2b49, 0x6bb6 },
	{ 0x2b4a, 0x6bd6 },
	{ 0x2b4b, 0x6bd8 },
	{ 0x2b4c, 0x6be0 },
	{ 0x2b4d, 0x6c20 },
	{ 0x2b4e, 0x6c21 },
	{ 0x2b4f, 0x6d28 },
	{ 0x2b50, 0x6d34 },
	{ 0x2b51, 0x6d2d },
	{ 0x2b52, 0x6d1f },
	{ 0x2b53, 0x6d3c },
	{ 0x2b54, 0x6d3f },
	{ 0x2b55, 0x6d12 },
	{ 0x2b56, 0x6d0a },
	{ 0x2b57, 0x6cda },
	{ 0x2b58, 0x6d33 },
	{ 0x2b59, 0x6d04 },
	{ 0x2b5a, 0x6d19 },
	{ 0x2b5b, 0x6d3a },
	{ 0x2b5c, 0x6d1a },
	{ 0x2b5d, 0x6d11 },
	{ 0x2b5e, 0x6d00 },
	{ 0x2b5f, 0x6d1d },
	{ 0x2b60, 0x6d42 },
	{ 0x2b61, 0x6d01 },
	{ 0x2b62, 0x6d18 },
	{ 0x2b63, 0x6d37 },
	{ 0x2b64, 0x6d03 },
	{ 0x2b65, 0x6d0f },
	{ 0x2b66, 0x6d40 },
	{ 0x2b67, 0x6d07 },
	{ 0x2b68, 0x6d20 },
	{ 0x2b69, 0x6d2c },
	{ 0x2b6a, 0x6d08 },
	{ 0x2b6b, 0x6d22 },
	{ 0x2b6c, 0x6d09 },
	{ 0x2b6d, 0x6d10 },
	{ 0x2b6e, 0x70b7 },
	{ 0x2b6f, 0x709f },
	{ 0x2b70, 0x70be },
	{ 0x2b71, 0x70b1 },
	{ 0x2b72, 0x70b0 },
	{ 0x2b73, 0x70a1 },
	{ 0x2b74, 0x70b4 },
	{ 0x2b75, 0x70b5 },
	{ 0x2b76, 0x70a9 },
	{ 0x2b77, 0x7241 },
	{ 0x2b78, 0x7249 },
	{ 0x2b79, 0x724a },
	{ 0x2b7a, 0x726c },
	{ 0x2b7b, 0x7270 },
	{ 0x2b7c, 0x7273 },
	{ 0x2b7d, 0x726e },
	{ 0x2b7e, 0x72ca },
	{ 0x2c21, 0x72e4 },
	{ 0x2c22, 0x72e8 },
	{ 0x2c23, 0x72eb },
	{ 0x2c24, 0x72df },
	{ 0x2c25, 0x72ea },
	{ 0x2c26, 0x72e6 },
	{ 0x2c27, 0x72e3 },
	{ 0x2c28, 0x7385 },
	{ 0x2c29, 0x73cc },
	{ 0x2c2a, 0x73c2 },
	{ 0x2c2b, 0x73c8 },
	{ 0x2c2c, 0x73c5 },
	{ 0x2c2d, 0x73b9 },
	{ 0x2c2e, 0x73b6 },
	{ 0x2c2f, 0x73b5 },
	{ 0x2c30, 0x73b4 },
	{ 0x2c31, 0x73eb },
	{ 0x2c32, 0x73bf },
	{ 0x2c33, 0x73c7 },
	{ 0x2c34, 0x73be },
	{ 0x2c35, 0x73c3 },
	{ 0x2c36, 0x73c6 },
	{ 0x2c37, 0x73b8 },
	{ 0x2c38, 0x73cb },
	{ 0x2c39, 0x74ec },
	{ 0x2c3a, 0x74ee },
	{ 0x2c3b, 0x752e },
	{ 0x2c3c, 0x7547 },
	{ 0x2c3d, 0x7548 },
	{ 0x2c3e, 0x75a7 },
	{ 0x2c3f, 0x75aa },
	{ 0x2c40, 0x7679 },
	{ 0x2c41, 0x76c4 },
	{ 0x2c42, 0x7708 },
	{ 0x2c43, 0x7703 },
	{ 0x2c44, 0x7704 },
	{ 0x2c45, 0x7705 },
	{ 0x2c46, 0x770a },
	{ 0x2c47, 0x76f7 },
	{ 0x2c48, 0x76fb },
	{ 0x2c49, 0x76fa },
	{ 0x2c4a, 0x77e7 },
	{ 0x2c4b, 0x77e8 },
	{ 0x2c4c, 0x7806 },
	{ 0x2c4d, 0x7811 },
	{ 0x2c4e, 0x7812 },
	{ 0x2c4f, 0x7805 },
	{ 0x2c50, 0x7810 },
	{ 0x2c51, 0x780f },
	{ 0x2c52, 0x780e },
	{ 0x2c53, 0x7809 },
	{ 0x2c54, 0x7803 },
	{ 0x2c55, 0x7813 },
	{ 0x2c56, 0x794a },
	{ 0x2c57, 0x794c },
	{ 0x2c58, 0x794b },
	{ 0x2c59, 0x7945 },
	{ 0x2c5a, 0x7944 },
	{ 0x2c5b, 0x79d5 },
	{ 0x2c5c, 0x79cd },
	{ 0x2c5d, 0x79cf },
	{ 0x2c5e, 0x79d6 },
	{ 0x2c5f, 0x79ce },
	{ 0x2c60, 0x7a80 },
	{ 0x2c61, 0x7a7e },
	{ 0x2c62, 0x7ad1 },
	{ 0x2c63, 0x7b00 },
	{ 0x2c64, 0x7b01 },
	{ 0x2c65, 0x7c7a },
	{ 0x2c66, 0x7c78 },
	{ 0x2c67, 0x7c79 },
	{ 0x2c68, 0x7c7f },
	{ 0x2c69, 0x7c80 },
	{ 0x2c6a, 0x7c81 },
	{ 0x2c6b, 0x7d03 },
	{ 0x2c6c, 0x7d08 },
	{ 0x2c6d, 0x7d01 },
	{ 0x2c6e, 0x7f58 },
	{ 0x2c6f, 0x7f91 },
	{ 0x2c70, 0x7f8d },
	{ 0x2c71, 0x7fbe },
	{ 0x2c72, 0x8007 },
	{ 0x2c73, 0x800e },
	{ 0x2c74, 0x800f },
	{ 0x2c75, 0x8014 },
	{ 0x2c76, 0x8037 },
	{ 0x2c77, 0x80d8 },
	{ 0x2c78, 0x80c7 },
	{ 0x2c79, 0x80e0 },
	{ 0x2c7a, 0x80d1 },
	{ 0x2c7b, 0x80c8 },
	{ 0x2c7c, 0x80c2 },
	{ 0x2c7d, 0x80d0 },
	{ 0x2c7e, 0x80c5 },
	{ 0x2d21, 0x80e3 },
	{ 0x2d22, 0x80d9 },
	{ 0x2d23, 0x80dc },
	{ 0x2d24, 0x80ca },
	{ 0x2d25, 0x80d5 },
	{ 0x2d26, 0x80c9 },
	{ 0x2d27, 0x80cf },
	{ 0x2d28, 0x80d7 },
	{ 0x2d29, 0x80e6 },
	{ 0x2d2a, 0x80cd },
	{ 0x2d2b, 0x81ff },
	{ 0x2d2c, 0x8221 },
	{ 0x2d2d, 0x8294 },
	{ 0x2d2e, 0x82d9 },
	{ 0x2d2f, 0x82fe },
	{ 0x2d30, 0x82f9 },
	{ 0x2d31, 0x8307 },
	{ 0x2d32, 0x82e8 },
	{ 0x2d33, 0x8300 },
	{ 0x2d34, 0x82d5 },
	{ 0x2d35, 0x833a },
	{ 0x2d36, 0x82eb },
	{ 0x2d37, 0x82d6 },
	{ 0x2d38, 0x82f4 },
	{ 0x2d39, 0x82ec },
	{ 0x2d3a, 0x82e1 },
	{ 0x2d3b, 0x82f2 },
	{ 0x2d3c, 0x82f5 },
	{ 0x2d3d, 0x830c },
	{ 0x2d3e, 0x82fb },
	{ 0x2d3f, 0x82f6 },
	{ 0x2d40, 0x82f0 },
	{ 0x2d41, 0x82ea },
	{ 0x2d42, 0x82e4 },
	{ 0x2d43, 0x82e0 },
	{ 0x2d44, 0x82fa },
	{ 0x2d45, 0x82f3 },
	{ 0x2d46, 0x82ed },
	{ 0x2d47, 0x8677 },
	{ 0x2d48, 0x8674 },
	{ 0x2d49, 0x867c },
	{ 0x2d4a, 0x8673 },
	{ 0x2d4b, 0x8841 },
	{ 0x2d4c, 0x884e },
	{ 0x2d4d, 0x8867 },
	{ 0x2d4e, 0x886a },
	{ 0x2d4f, 0x8869 },
	{ 0x2d50, 0x89d3 },
	{ 0x2d51, 0x8a04 },
	{ 0x2d52, 0x8a07 },
	{ 0x2d53, 0x8d72 },
	{ 0x2d54, 0x8fe3 },
	{ 0x2d55, 0x8fe1 },
	{ 0x2d56, 0x8fee },
	{ 0x2d57, 0x8fe0 },
	{ 0x2d58, 0x90f1 },
	{ 0x2d59, 0x90bd },
	{ 0x2d5a, 0x90bf },
	{ 0x2d5b, 0x90d5 },
	{ 0x2d5c, 0x90c5 },
	{ 0x2d5d, 0x90be },
	{ 0x2d5e, 0x90c7 },
	{ 0x2d5f, 0x90cb },
	{ 0x2d60, 0x90c8 },
	{ 0x2d61, 0x91d4 },
	{ 0x2d62, 0x91d3 },
	{ 0x2d63, 0x9654 },
	{ 0x2d64, 0x964f },
	{ 0x2d65, 0x9651 },
	{ 0x2d66, 0x9653 },
	{ 0x2d67, 0x964a },
	{ 0x2d68, 0x964e },
	{ 0x2d69, 0x501e },
	{ 0x2d6a, 0x5005 },
	{ 0x2d6b, 0x5007 },
	{ 0x2d6c, 0x5013 },
	{ 0x2d6d, 0x5022 },
	{ 0x2d6e, 0x5030 },
	{ 0x2d6f, 0x501b },
	{ 0x2d70, 0x4ff5 },
	{ 0x2d71, 0x4ff4 },
	{ 0x2d72, 0x5033 },
	{ 0x2d73, 0x5037 },
	{ 0x2d74, 0x502c },
	{ 0x2d75, 0x4ff6 },
	{ 0x2d76, 0x4ff7 },
	{ 0x2d77, 0x5017 },
	{ 0x2d78, 0x501c },
	{ 0x2d79, 0x5020 },
	{ 0x2d7a, 0x5027 },
	{ 0x2d7b, 0x5035 },
	{ 0x2d7c, 0x502f },
	{ 0x2d7d, 0x5031 },
	{ 0x2d7e, 0x500e },
	{ 0x2e21, 0x515a },
	{ 0x2e22, 0x5194 },
	{ 0x2e23, 0x5193 },
	{ 0x2e24, 0x51ca },
	{ 0x2e25, 0x51c4 },
	{ 0x2e26, 0x51c5 },
	{ 0x2e27, 0x51c8 },
	{ 0x2e28, 0x51ce },
	{ 0x2e29, 0x5261 },
	{ 0x2e2a, 0x525a },
	{ 0x2e2b, 0x5252 },
	{ 0x2e2c, 0x525e },
	{ 0x2e2d, 0x525f },
	{ 0x2e2e, 0x5255 },
	{ 0x2e2f, 0x5262 },
	{ 0x2e30, 0x52cd },
	{ 0x2e31, 0x530e },
	{ 0x2e32, 0x539e },
	{ 0x2e33, 0x5526 },
	{ 0x2e34, 0x54e2 },
	{ 0x2e35, 0x5517 },
	{ 0x2e36, 0x5512 },
	{ 0x2e37, 0x54e7 },
	{ 0x2e38, 0x54f3 },
	{ 0x2e39, 0x54e4 },
	{ 0x2e3a, 0x551a },
	{ 0x2e3b, 0x54ff },
	{ 0x2e3c, 0x5504 },
	{ 0x2e3d, 0x5508 },
	{ 0x2e3e, 0x54eb },
	{ 0x2e3f, 0x5511 },
	{ 0x2e40, 0x5505 },
	{ 0x2e41, 0x54f1 },
	{ 0x2e42, 0x550a },
	{ 0x2e43, 0x54fb },
	{ 0x2e44, 0x54f7 },
	{ 0x2e45, 0x54f8 },
	{ 0x2e46, 0x54e0 },
	{ 0x2e47, 0x550e },
	{ 0x2e48, 0x5503 },
	{ 0x2e49, 0x550b },
	{ 0x2e4a, 0x5701 },
	{ 0x2e4b, 0x5702 },
	{ 0x2e4c, 0x57cc },
	{ 0x2e4d, 0x5832 },
	{ 0x2e4e, 0x57d5 },
	{ 0x2e4f, 0x57d2 },
	{ 0x2e50, 0x57ba },
	{ 0x2e51, 0x57c6 },
	{ 0x2e52, 0x57bd },
	{ 0x2e53, 0x57bc },
	{ 0x2e54, 0x57b8 },
	{ 0x2e55, 0x57b6 },
	{ 0x2e56, 0x57bf },
	{ 0x2e57, 0x57c7 },
	{ 0x2e58, 0x57d0 },
	{ 0x2e59, 0x57b9 },
	{ 0x2e5a, 0x57c1 },
	{ 0x2e5b, 0x590e },
	{ 0x2e5c, 0x594a },
	{ 0x2e5d, 0x5a19 },
	{ 0x2e5e, 0x5a16 },
	{ 0x2e5f, 0x5a2d },
	{ 0x2e60, 0x5a2e },
	{ 0x2e61, 0x5a15 },
	{ 0x2e62, 0x5a0f },
	{ 0x2e63, 0x5a17 },
	{ 0x2e64, 0x5a0a },
	{ 0x2e65, 0x5a1e },
	{ 0x2e66, 0x5a33 },
	{ 0x2e67, 0x5b6c },
	{ 0x2e68, 0x5ba7 },
	{ 0x2e69, 0x5bad },
	{ 0x2e6a, 0x5bac },
	{ 0x2e6b, 0x5c03 },
	{ 0x2e6c, 0x5c56 },
	{ 0x2e6d, 0x5c54 },
	{ 0x2e6e, 0x5cec },
	{ 0x2e6f, 0x5cff },
	{ 0x2e70, 0x5cee },
	{ 0x2e71, 0x5cf1 },
	{ 0x2e72, 0x5cf7 },
	{ 0x2e73, 0x5d00 },
	{ 0x2e74, 0x5cf9 },
	{ 0x2e75, 0x5e29 },
	{ 0x2e76, 0x5e28 },
	{ 0x2e77, 0x5ea8 },
	{ 0x2e78, 0x5eae },
	{ 0x2e79, 0x5eaa },
	{ 0x2e7a, 0x5eac },
	{ 0x2e7b, 0x5f33 },
	{ 0x2e7c, 0x5f30 },
	{ 0x2e7d, 0x5f67 },
	{ 0x2e7e, 0x605d },
	{ 0x2f21, 0x605a },
	{ 0x2f22, 0x6067 },
	{ 0x2f23, 0x6041 },
	{ 0x2f24, 0x60a2 },
	{ 0x2f25, 0x6088 },
	{ 0x2f26, 0x6080 },
	{ 0x2f27, 0x6092 },
	{ 0x2f28, 0x6081 },
	{ 0x2f29, 0x609d },
	{ 0x2f2a, 0x6083 },
	{ 0x2f2b, 0x6095 },
	{ 0x2f2c, 0x609b },
	{ 0x2f2d, 0x6097 },
	{ 0x2f2e, 0x6087 },
	{ 0x2f2f, 0x609c },
	{ 0x2f30, 0x608e },
	{ 0x2f31, 0x6219 },
	{ 0x2f32, 0x6246 },
	{ 0x2f33, 0x62f2 },
	{ 0x2f34, 0x6310 },
	{ 0x2f35, 0x6356 },
	{ 0x2f36, 0x632c },
	{ 0x2f37, 0x6344 },
	{ 0x2f38, 0x6345 },
	{ 0x2f39, 0x6336 },
	{ 0x2f3a, 0x6343 },
	{ 0x2f3b, 0x63e4 },
	{ 0x2f3c, 0x6339 },
	{ 0x2f3d, 0x634b },
	{ 0x2f3e, 0x634a },
	{ 0x2f3f, 0x633c },
	{ 0x2f40, 0x6329 },
	{ 0x2f41, 0x6341 },
	{ 0x2f42, 0x6334 },
	{ 0x2f43, 0x6358 },
	{ 0x2f44, 0x6354 },
	{ 0x2f45, 0x6359 },
	{ 0x2f46, 0x632d },
	{ 0x2f47, 0x6347 },
	{ 0x2f48, 0x6333 },
	{ 0x2f49, 0x635a },
	{ 0x2f4a, 0x6351 },
	{ 0x2f4b, 0x6338 },
	{ 0x2f4c, 0x6357 },
	{ 0x2f4d, 0x6340 },
	{ 0x2f4e, 0x6348 },
	{ 0x2f4f, 0x654a },
	{ 0x2f50, 0x6546 },
	{ 0x2f51, 0x65c6 },
	{ 0x2f52, 0x65c3 },
	{ 0x2f53, 0x65c4 },
	{ 0x2f54, 0x65c2 },
	{ 0x2f55, 0x664a },
	{ 0x2f56, 0x665f },
	{ 0x2f57, 0x6647 },
	{ 0x2f58, 0x6651 },
	{ 0x2f59, 0x6712 },
	{ 0x2f5a, 0x6713 },
	{ 0x2f5b, 0x681f },
	{ 0x2f5c, 0x681a },
	{ 0x2f5d, 0x6849 },
	{ 0x2f5e, 0x6832 },
	{ 0x2f5f, 0x6833 },
	{ 0x2f60, 0x683b },
	{ 0x2f61, 0x684b },
	{ 0x2f62, 0x684f },
	{ 0x2f63, 0x6816 },
	{ 0x2f64, 0x6831 },
	{ 0x2f65, 0x681c },
	{ 0x2f66, 0x6835 },
	{ 0x2f67, 0x682b },
	{ 0x2f68, 0x682d },
	{ 0x2f69, 0x682f },
	{ 0x2f6a, 0x684e },
	{ 0x2f6b, 0x6844 },
	{ 0x2f6c, 0x6834 },
	{ 0x2f6d, 0x681d },
	{ 0x2f6e, 0x6812 },
	{ 0x2f6f, 0x6814 },
	{ 0x2f70, 0x6826 },
	{ 0x2f71, 0x6828 },
	{ 0x2f72, 0x682e },
	{ 0x2f73, 0x684d },
	{ 0x2f74, 0x683a },
	{ 0x2f75, 0x6825 },
	{ 0x2f76, 0x6820 },
	{ 0x2f77, 0x6b2c },
	{ 0x2f78, 0x6b2f },
	{ 0x2f79, 0x6b2d },
	{ 0x2f7a, 0x6b31 },
	{ 0x2f7b, 0x6b34 },
	{ 0x2f7c, 0x6b6d },
	{ 0x2f7d, 0x8082 },
	{ 0x2f7e, 0x6b88 },
	{ 0x3021, 0x6be6 },
	{ 0x3022, 0x6be4 },
	{ 0x3023, 0x6be8 },
	{ 0x3024, 0x6be3 },
	{ 0x3025, 0x6be2 },
	{ 0x3026, 0x6be7 },
	{ 0x3027, 0x6c25 },
	{ 0x3028, 0x6d7a },
	{ 0x3029, 0x6d63 },
	{ 0x302a, 0x6d64 },
	{ 0x302b, 0x6d76 },
	{ 0x302c, 0x6d0d },
	{ 0x302d, 0x6d61 },
	{ 0x302e, 0x6d92 },
	{ 0x302f, 0x6d58 },
	{ 0x3030, 0x6d62 },
	{ 0x3031, 0x6d6d },
	{ 0x3032, 0x6d6f },
	{ 0x3033, 0x6d91 },
	{ 0x3034, 0x6d8d },
	{ 0x3035, 0x6def },
	{ 0x3036, 0x6d7f },
	{ 0x3037, 0x6d86 },
	{ 0x3038, 0x6d5e },
	{ 0x3039, 0x6d67 },
	{ 0x303a, 0x6d60 },
	{ 0x303b, 0x6d97 },
	{ 0x303c, 0x6d70 },
	{ 0x303d, 0x6d7c },
	{ 0x303e, 0x6d5f },
	{ 0x303f, 0x6d82 },
	{ 0x3040, 0x6d98 },
	{ 0x3041, 0x6d2f },
	{ 0x3042, 0x6d68 },
	{ 0x3043, 0x6d8b },
	{ 0x3044, 0x6d7e },
	{ 0x3045, 0x6d80 },
	{ 0x3046, 0x6d84 },
	{ 0x3047, 0x6d16 },
	{ 0x3048, 0x6d83 },
	{ 0x3049, 0x6d7b },
	{ 0x304a, 0x6d7d },
	{ 0x304b, 0x6d75 },
	{ 0x304c, 0x6d90 },
	{ 0x304d, 0x70dc },
	{ 0x304e, 0x70d3 },
	{ 0x304f, 0x70d1 },
	{ 0x3050, 0x70dd },
	{ 0x3051, 0x70cb },
	{ 0x3052, 0x7f39 },
	{ 0x3053, 0x70e2 },
	{ 0x3054, 0x70d7 },
	{ 0x3055, 0x70d2 },
	{ 0x3056, 0x70de },
	{ 0x3057, 0x70e0 },
	{ 0x3058, 0x70d4 },
	{ 0x3059, 0x70cd },
	{ 0x305a, 0x70c5 },
	{ 0x305b, 0x70c6 },
	{ 0x305c, 0x70c7 },
	{ 0x305d, 0x70da },
	{ 0x305e, 0x70ce },
	{ 0x305f, 0x70e1 },
	{ 0x3060, 0x7242 },
	{ 0x3061, 0x7278 },
	{ 0x3062, 0x7277 },
	{ 0x3063, 0x7276 },
	{ 0x3064, 0x7300 },
	{ 0x3065, 0x72fa },
	{ 0x3066, 0x72f4 },
	{ 0x3067, 0x72fe },
	{ 0x3068, 0x72f6 },
	{ 0x3069, 0x72f3 },
	{ 0x306a, 0x72fb },
	{ 0x306b, 0x7301 },
	{ 0x306c, 0x73d3 },
	{ 0x306d, 0x73d9 },
	{ 0x306e, 0x73e5 },
	{ 0x306f, 0x73d6 },
	{ 0x3070, 0x73bc },
	{ 0x3071, 0x73e7 },
	{ 0x3072, 0x73e3 },
	{ 0x3073, 0x73e9 },
	{ 0x3074, 0x73dc },
	{ 0x3075, 0x73d2 },
	{ 0x3076, 0x73db },
	{ 0x3077, 0x73d4 },
	{ 0x3078, 0x73dd },
	{ 0x3079, 0x73da },
	{ 0x307a, 0x73d7 },
	{ 0x307b, 0x73d8 },
	{ 0x307c, 0x73e8 },
	{ 0x307d, 0x74de },
	{ 0x307e, 0x74df },
	{ 0x3121, 0x74f4 },
	{ 0x3122, 0x74f5 },
	{ 0x3123, 0x7521 },
	{ 0x3124, 0x755b },
	{ 0x3125, 0x755f },
	{ 0x3126, 0x75b0 },
	{ 0x3127, 0x75c1 },
	{ 0x3128, 0x75bb },
	{ 0x3129, 0x75c4 },
	{ 0x312a, 0x75c0 },
	{ 0x312b, 0x75bf },
	{ 0x312c, 0x75b6 },
	{ 0x312d, 0x75ba },
	{ 0x312e, 0x768a },
	{ 0x312f, 0x76c9 },
	{ 0x3130, 0x771d },
	{ 0x3131, 0x771b },
	{ 0x3132, 0x7710 },
	{ 0x3133, 0x7713 },
	{ 0x3134, 0x7712 },
	{ 0x3135, 0x7723 },
	{ 0x3136, 0x7711 },
	{ 0x3137, 0x7715 },
	{ 0x3138, 0x7719 },
	{ 0x3139, 0x771a },
	{ 0x313a, 0x7722 },
	{ 0x313b, 0x7727 },
	{ 0x313c, 0x7823 },
	{ 0x313d, 0x782c },
	{ 0x313e, 0x7822 },
	{ 0x313f, 0x7835 },
	{ 0x3140, 0x782f },
	{ 0x3141, 0x7828 },
	{ 0x3142, 0x782e },
	{ 0x3143, 0x782b },
	{ 0x3144, 0x7821 },
	{ 0x3145, 0x7829 },
	{ 0x3146, 0x7833 },
	{ 0x3147, 0x782a },
	{ 0x3148, 0x7831 },
	{ 0x3149, 0x7954 },
	{ 0x314a, 0x795b },
	{ 0x314b, 0x794f },
	{ 0x314c, 0x795c },
	{ 0x314d, 0x7953 },
	{ 0x314e, 0x7952 },
	{ 0x314f, 0x7951 },
	{ 0x3150, 0x79eb },
	{ 0x3151, 0x79ec },
	{ 0x3152, 0x79e0 },
	{ 0x3153, 0x79ee },
	{ 0x3154, 0x79ed },
	{ 0x3155, 0x79ea },
	{ 0x3156, 0x79dc },
	{ 0x3157, 0x79de },
	{ 0x3158, 0x79dd },
	{ 0x3159, 0x7a86 },
	{ 0x315a, 0x7a89 },
	{ 0x315b, 0x7a85 },
	{ 0x315c, 0x7a8b },
	{ 0x315d, 0x7a8c },
	{ 0x315e, 0x7a8a },
	{ 0x315f, 0x7a87 },
	{ 0x3160, 0x7ad8 },
	{ 0x3161, 0x7b10 },
	{ 0x3162, 0x7b04 },
	{ 0x3163, 0x7b13 },
	{ 0x3164, 0x7b05 },
	{ 0x3165, 0x7b0f },
	{ 0x3166, 0x7b08 },
	{ 0x3167, 0x7b0a },
	{ 0x3168, 0x7b0e },
	{ 0x3169, 0x7b09 },
	{ 0x316a, 0x7b12 },
	{ 0x316b, 0x7c84 },
	{ 0x316c, 0x7c91 },
	{ 0x316d, 0x7c8a },
	{ 0x316e, 0x7c8c },
	{ 0x316f, 0x7c88 },
	{ 0x3170, 0x7c8d },
	{ 0x3171, 0x7c85 },
	{ 0x3172, 0x7d1e },
	{ 0x3173, 0x7d1d },
	{ 0x3174, 0x7d11 },
	{ 0x3175, 0x7d0e },
	{ 0x3176, 0x7d18 },
	{ 0x3177, 0x7d16 },
	{ 0x3178, 0x7d13 },
	{ 0x3179, 0x7d1f },
	{ 0x317a, 0x7d12 },
	{ 0x317b, 0x7d0f },
	{ 0x317c, 0x7d0c },
	{ 0x317d, 0x7f5c },
	{ 0x317e, 0x7f61 },
	{ 0x3221, 0x7f5e },
	{ 0x3222, 0x7f60 },
	{ 0x3223, 0x7f5d },
	{ 0x3224, 0x7f5b },
	{ 0x3225, 0x7f96 },
	{ 0x3226, 0x7f92 },
	{ 0x3227, 0x7fc3 },
	{ 0x3228, 0x7fc2 },
	{ 0x3229, 0x7fc0 },
	{ 0x322a, 0x8016 },
	{ 0x322b, 0x803e },
	{ 0x322c, 0x8039 },
	{ 0x322d, 0x80fa },
	{ 0x322e, 0x80f2 },
	{ 0x322f, 0x80f9 },
	{ 0x3230, 0x80f5 },
	{ 0x3231, 0x8101 },
	{ 0x3232, 0x80fb },
	{ 0x3233, 0x8100 },
	{ 0x3234, 0x8201 },
	{ 0x3235, 0x822f },
	{ 0x3236, 0x8225 },
	{ 0x3237, 0x8333 },
	{ 0x3238, 0x832d },
	{ 0x3239, 0x8344 },
	{ 0x323a, 0x8319 },
	{ 0x323b, 0x8351 },
	{ 0x323c, 0x8325 },
	{ 0x323d, 0x8356 },
	{ 0x323e, 0x833f },
	{ 0x323f, 0x8341 },
	{ 0x3240, 0x8326 },
	{ 0x3241, 0x831c },
	{ 0x3242, 0x8322 },
	{ 0x3243, 0x8342 },
	{ 0x3244, 0x834e },
	{ 0x3245, 0x831b },
	{ 0x3246, 0x832a },
	{ 0x3247, 0x8308 },
	{ 0x3248, 0x833c },
	{ 0x3249, 0x834d },
	{ 0x324a, 0x8316 },
	{ 0x324b, 0x8324 },
	{ 0x324c, 0x8320 },
	{ 0x324d, 0x8337 },
	{ 0x324e, 0x832f },
	{ 0x324f, 0x8329 },
	{ 0x3250, 0x8347 },
	{ 0x3251, 0x8345 },
	{ 0x3252, 0x834c },
	{ 0x3253, 0x8353 },
	{ 0x3254, 0x831e },
	{ 0x3255, 0x832c },
	{ 0x3256, 0x834b },
	{ 0x3257, 0x8327 },
	{ 0x3258, 0x8348 },
	{ 0x3259, 0x8653 },
	{ 0x325a, 0x8652 },
	{ 0x325b, 0x86a2 },
	{ 0x325c, 0x86a8 },
	{ 0x325d, 0x8696 },
	{ 0x325e, 0x868d },
	{ 0x325f, 0x8691 },
	{ 0x3260, 0x869e },
	{ 0x3261, 0x8687 },
	{ 0x3262, 0x8697 },
	{ 0x3263, 0x8686 },
	{ 0x3264, 0x868b },
	{ 0x3265, 0x869a },
	{ 0x3266, 0x8685 },
	{ 0x3267, 0x86a5 },
	{ 0x3268, 0x8699 },
	{ 0x3269, 0x86a1 },
	{ 0x326a, 0x86a7 },
	{ 0x326b, 0x8695 },
	{ 0x326c, 0x8698 },
	{ 0x326d, 0x868e },
	{ 0x326e, 0x869d },
	{ 0x326f, 0x8690 },
	{ 0x3270, 0x8694 },
	{ 0x3271, 0x8843 },
	{ 0x3272, 0x8844 },
	{ 0x3273, 0x886d },
	{ 0x3274, 0x8875 },
	{ 0x3275, 0x8876 },
	{ 0x3276, 0x8872 },
	{ 0x3277, 0x8880 },
	{ 0x3278, 0x8871 },
	{ 0x3279, 0x887f },
	{ 0x327a, 0x886f },
	{ 0x327b, 0x8883 },
	{ 0x327c, 0x887e },
	{ 0x327d, 0x8874 },
	{ 0x327e, 0x887c },
	{ 0x3321, 0x8a12 },
	{ 0x3322, 0x8c47 },
	{ 0x3323, 0x8c57 },
	{ 0x3324, 0x8c7b },
	{ 0x3325, 0x8ca4 },
	{ 0x3326, 0x8ca3 },
	{ 0x3327, 0x8d76 },
	{ 0x3328, 0x8d78 },
	{ 0x3329, 0x8db5 },
	{ 0x332a, 0x8db7 },
	{ 0x332b, 0x8db6 },
	{ 0x332c, 0x8ed1 },
	{ 0x332d, 0x8ed3 },
	{ 0x332e, 0x8ffe },
	{ 0x332f, 0x8ff5 },
	{ 0x3330, 0x9002 },
	{ 0x3331, 0x8fff },
	{ 0x3332, 0x8ffb },
	{ 0x3333, 0x9004 },
	{ 0x3334, 0x8ffc },
	{ 0x3335, 0x8ff6 },
	{ 0x3336, 0x90d6 },
	{ 0x3337, 0x90e0 },
	{ 0x3338, 0x90d9 },
	{ 0x3339, 0x90da },
	{ 0x333a, 0x90e3 },
	{ 0x333b, 0x90df },
	{ 0x333c, 0x90e5 },
	{ 0x333d, 0x90d8 },
	{ 0x333e, 0x90db },
	{ 0x333f, 0x90d7 },
	{ 0x3340, 0x90dc },
	{ 0x3341, 0x90e4 },
	{ 0x3342, 0x9150 },
	{ 0x3343, 0x914e },
	{ 0x3344, 0x914f },
	{ 0x3345, 0x91d5 },
	{ 0x3346, 0x91e2 },
	{ 0x3347, 0x91da },
	{ 0x3348, 0x965c },
	{ 0x3349, 0x965f },
	{ 0x334a, 0x96bc },
	{ 0x334b, 0x98e3 },
	{ 0x334c, 0x9adf },
	{ 0x334d, 0x9b2f },
	{ 0x334e, 0x4e7f },
	{ 0x334f, 0x5070 },
	{ 0x3350, 0x506a },
	{ 0x3351, 0x5061 },
	{ 0x3352, 0x505e },
	{ 0x3353, 0x5060 },
	{ 0x3354, 0x5053 },
	{ 0x3355, 0x504b },
	{ 0x3356, 0x505d },
	{ 0x3357, 0x5072 },
	{ 0x3358, 0x5048 },
	{ 0x3359, 0x504d },
	{ 0x335a, 0x5041 },
	{ 0x335b, 0x505b },
	{ 0x335c, 0x504a },
	{ 0x335d, 0x5062 },
	{ 0x335e, 0x5015 },
	{ 0x335f, 0x5045 },
	{ 0x3360, 0x505f },
	{ 0x3361, 0x5069 },
	{ 0x3362, 0x506b },
	{ 0x3363, 0x5063 },
	{ 0x3364, 0x5064 },
	{ 0x3365, 0x5046 },
	{ 0x3366, 0x5040 },
	{ 0x3367, 0x506e },
	{ 0x3368, 0x5073 },
	{ 0x3369, 0x5057 },
	{ 0x336a, 0x5051 },
	{ 0x336b, 0x51d0 },
	{ 0x336c, 0x526b },
	{ 0x336d, 0x526d },
	{ 0x336e, 0x526c },
	{ 0x336f, 0x526e },
	{ 0x3370, 0x52d6 },
	{ 0x3371, 0x52d3 },
	{ 0x3372, 0x532d },
	{ 0x3373, 0x539c },
	{ 0x3374, 0x5575 },
	{ 0x3375, 0x5576 },
	{ 0x3376, 0x553c },
	{ 0x3377, 0x554d },
	{ 0x3378, 0x5550 },
	{ 0x3379, 0x5534 },
	{ 0x337a, 0x552a },
	{ 0x337b, 0x5551 },
	{ 0x337c, 0x5562 },
	{ 0x337d, 0x5536 },
	{ 0x337e, 0x5535 },
	{ 0x3421, 0x5530 },
	{ 0x3422, 0x5552 },
	{ 0x3423, 0x5545 },
	{ 0x3424, 0x550c },
	{ 0x3425, 0x5532 },
	{ 0x3426, 0x5565 },
	{ 0x3427, 0x554e },
	{ 0x3428, 0x5539 },
	{ 0x3429, 0x5548 },
	{ 0x342a, 0x552d },
	{ 0x342b, 0x553b },
	{ 0x342c, 0x5540 },
	{ 0x342d, 0x554b },
	{ 0x342e, 0x570a },
	{ 0x342f, 0x5707 },
	{ 0x3430, 0x57fb },
	{ 0x3431, 0x5814 },
	{ 0x3432, 0x57e2 },
	{ 0x3433, 0x57f6 },
	{ 0x3434, 0x57dc },
	{ 0x3435, 0x57f4 },
	{ 0x3436, 0x5800 },
	{ 0x3437, 0x57ed },
	{ 0x3438, 0x57fd },
	{ 0x3439, 0x5808 },
	{ 0x343a, 0x57f8 },
	{ 0x343b, 0x580b },
	{ 0x343c, 0x57f3 },
	{ 0x343d, 0x57cf },
	{ 0x343e, 0x5807 },
	{ 0x343f, 0x57ee },
	{ 0x3440, 0x57e3 },
	{ 0x3441, 0x57f2 },
	{ 0x3442, 0x57e5 },
	{ 0x3443, 0x57ec },
	{ 0x3444, 0x57e1 },
	{ 0x3445, 0x580e },
	{ 0x3446, 0x57fc },
	{ 0x3447, 0x5810 },
	{ 0x3448, 0x57e7 },
	{ 0x3449, 0x5801 },
	{ 0x344a, 0x580c },
	{ 0x344b, 0x57f1 },
	{ 0x344c, 0x57e9 },
	{ 0x344d, 0x57f0 },
	{ 0x344e, 0x580d },
	{ 0x344f, 0x5804 },
	{ 0x3450, 0x595c },
	{ 0x3451, 0x5a60 },
	{ 0x3452, 0x5a58 },
	{ 0x3453, 0x5a55 },
	{ 0x3454, 0x5a67 },
	{ 0x3455, 0x5a5e },
	{ 0x3456, 0x5a38 },
	{ 0x3457, 0x5a35 },
	{ 0x3458, 0x5a6d },
	{ 0x3459, 0x5a50 },
	{ 0x345a, 0x5a5f },
	{ 0x345b, 0x5a65 },
	{ 0x345c, 0x5a6c },
	{ 0x345d, 0x5a53 },
	{ 0x345e, 0x5a64 },
	{ 0x345f, 0x5a57 },
	{ 0x3460, 0x5a43 },
	{ 0x3461, 0x5a5d },
	{ 0x3462, 0x5a52 },
	{ 0x3463, 0x5a44 },
	{ 0x3464, 0x5a5b },
	{ 0x3465, 0x5a48 },
	{ 0x3466, 0x5a8e },
	{ 0x3467, 0x5a3e },
	{ 0x3468, 0x5a4d },
	{ 0x3469, 0x5a39 },
	{ 0x346a, 0x5a4c },
	{ 0x346b, 0x5a70 },
	{ 0x346c, 0x5a69 },
	{ 0x346d, 0x5a47 },
	{ 0x346e, 0x5a51 },
	{ 0x346f, 0x5a56 },
	{ 0x3470, 0x5a42 },
	{ 0x3471, 0x5a5c },
	{ 0x3472, 0x5b72 },
	{ 0x3473, 0x5b6e },
	{ 0x3474, 0x5bc1 },
	{ 0x3475, 0x5bc0 },
	{ 0x3476, 0x5c59 },
	{ 0x3477, 0x5d1e },
	{ 0x3478, 0x5d0b },
	{ 0x3479, 0x5d1d },
	{ 0x347a, 0x5d1a },
	{ 0x347b, 0x5d20 },
	{ 0x347c, 0x5d0c },
	{ 0x347d, 0x5d28 },
	{ 0x347e, 0x5d0d },
	{ 0x3521, 0x5d26 },
	{ 0x3522, 0x5d25 },
	{ 0x3523, 0x5d0f },
	{ 0x3524, 0x5d30 },
	{ 0x3525, 0x5d12 },
	{ 0x3526, 0x5d23 },
	{ 0x3527, 0x5d1f },
	{ 0x3528, 0x5d2e },
	{ 0x3529, 0x5e3e },
	{ 0x352a, 0x5e34 },
	{ 0x352b, 0x5eb1 },
	{ 0x352c, 0x5eb4 },
	{ 0x352d, 0x5eb9 },
	{ 0x352e, 0x5eb2 },
	{ 0x352f, 0x5eb3 },
	{ 0x3530, 0x5f36 },
	{ 0x3531, 0x5f38 },
	{ 0x3532, 0x5f9b },
	{ 0x3533, 0x5f96 },
	{ 0x3534, 0x5f9f },
	{ 0x3535, 0x608a },
	{ 0x3536, 0x6090 },
	{ 0x3537, 0x6086 },
	{ 0x3538, 0x60be },
	{ 0x3539, 0x60b0 },
	{ 0x353a, 0x60ba },
	{ 0x353b, 0x60d3 },
	{ 0x353c, 0x60d4 },
	{ 0x353d, 0x60cf },
	{ 0x353e, 0x60e4 },
	{ 0x353f, 0x60d9 },
	{ 0x3540, 0x60dd },
	{ 0x3541, 0x60c8 },
	{ 0x3542, 0x60b1 },
	{ 0x3543, 0x60db },
	{ 0x3544, 0x60b7 },
	{ 0x3545, 0x60ca },
	{ 0x3546, 0x60bf },
	{ 0x3547, 0x60c3 },
	{ 0x3548, 0x60cd },
	{ 0x3549, 0x60c0 },
	{ 0x354a, 0x6332 },
	{ 0x354b, 0x6365 },
	{ 0x354c, 0x638a },
	{ 0x354d, 0x6382 },
	{ 0x354e, 0x637d },
	{ 0x354f, 0x63bd },
	{ 0x3550, 0x639e },
	{ 0x3551, 0x63ad },
	{ 0x3552, 0x639d },
	{ 0x3553, 0x6397 },
	{ 0x3554, 0x63ab },
	{ 0x3555, 0x638e },
	{ 0x3556, 0x636f },
	{ 0x3557, 0x6387 },
	{ 0x3558, 0x6390 },
	{ 0x3559, 0x636e },
	{ 0x355a, 0x63af },
	{ 0x355b, 0x6375 },
	{ 0x355c, 0x639c },
	{ 0x355d, 0x636d },
	{ 0x355e, 0x63ae },
	{ 0x355f, 0x637c },
	{ 0x3560, 0x63a4 },
	{ 0x3561, 0x633b },
	{ 0x3562, 0x639f },
	{ 0x3563, 0x6378 },
	{ 0x3564, 0x6385 },
	{ 0x3565, 0x6381 },
	{ 0x3566, 0x6391 },
	{ 0x3567, 0x638d },
	{ 0x3568, 0x6370 },
	{ 0x3569, 0x6553 },
	{ 0x356a, 0x65cd },
	{ 0x356b, 0x6665 },
	{ 0x356c, 0x6661 },
	{ 0x356d, 0x665b },
	{ 0x356e, 0x6659 },
	{ 0x356f, 0x665c },
	{ 0x3570, 0x6662 },
	{ 0x3571, 0x6718 },
	{ 0x3572, 0x6879 },
	{ 0x3573, 0x6887 },
	{ 0x3574, 0x6890 },
	{ 0x3575, 0x689c },
	{ 0x3576, 0x686d },
	{ 0x3577, 0x686e },
	{ 0x3578, 0x68ae },
	{ 0x3579, 0x68ab },
	{ 0x357a, 0x6956 },
	{ 0x357b, 0x686f },
	{ 0x357c, 0x68a3 },
	{ 0x357d, 0x68ac },
	{ 0x357e, 0x68a9 },
	{ 0x3621, 0x6875 },
	{ 0x3622, 0x6874 },
	{ 0x3623, 0x68b2 },
	{ 0x3624, 0x688f },
	{ 0x3625, 0x6877 },
	{ 0x3626, 0x6892 },
	{ 0x3627, 0x687c },
	{ 0x3628, 0x686b },
	{ 0x3629, 0x6872 },
	{ 0x362a, 0x68aa },
	{ 0x362b, 0x6880 },
	{ 0x362c, 0x6871 },
	{ 0x362d, 0x687e },
	{ 0x362e, 0x689b },
	{ 0x362f, 0x6896 },
	{ 0x3630, 0x688b },
	{ 0x3631, 0x68a0 },
	{ 0x3632, 0x6889 },
	{ 0x3633, 0x68a4 },
	{ 0x3634, 0x6878 },
	{ 0x3635, 0x687b },
	{ 0x3636, 0x6891 },
	{ 0x3637, 0x688c },
	{ 0x3638, 0x688a },
	{ 0x3639, 0x687d },
	{ 0x363a, 0x6b36 },
	{ 0x363b, 0x6b33 },
	{ 0x363c, 0x6b37 },
	{ 0x363d, 0x6b38 },
	{ 0x363e, 0x6b91 },
	{ 0x363f, 0x6b8f },
	{ 0x3640, 0x6b8d },
	{ 0x3641, 0x6b8e },
	{ 0x3642, 0x6b8c },
	{ 0x3643, 0x6c2a },
	{ 0x3644, 0x6dc0 },
	{ 0x3645, 0x6dab },
	{ 0x3646, 0x6db4 },
	{ 0x3647, 0x6db3 },
	{ 0x3648, 0x6e74 },
	{ 0x3649, 0x6dac },
	{ 0x364a, 0x6de9 },
	{ 0x364b, 0x6de2 },
	{ 0x364c, 0x6db7 },
	{ 0x364d, 0x6df6 },
	{ 0x364e, 0x6dd4 },
	{ 0x364f, 0x6e00 },
	{ 0x3650, 0x6dc8 },
	{ 0x3651, 0x6de0 },
	{ 0x3652, 0x6ddf },
	{ 0x3653, 0x6dd6 },
	{ 0x3654, 0x6dbe },
	{ 0x3655, 0x6de5 },
	{ 0x3656, 0x6ddc },
	{ 0x3657, 0x6ddd },
	{ 0x3658, 0x6ddb },
	{ 0x3659, 0x6df4 },
	{ 0x365a, 0x6dca },
	{ 0x365b, 0x6dbd },
	{ 0x365c, 0x6ded },
	{ 0x365d, 0x6df0 },
	{ 0x365e, 0x6dba },
	{ 0x365f, 0x6dd5 },
	{ 0x3660, 0x6dc2 },
	{ 0x3661, 0x6dcf },
	{ 0x3662, 0x6dc9 },
	{ 0x3663, 0x6dd0 },
	{ 0x3664, 0x6df2 },
	{ 0x3665, 0x6dd3 },
	{ 0x3666, 0x6dfd },
	{ 0x3667, 0x6dd7 },
	{ 0x3668, 0x6dcd },
	{ 0x3669, 0x6de3 },
	{ 0x366a, 0x6dbb },
	{ 0x366b, 0x70fa },
	{ 0x366c, 0x710d },
	{ 0x366d, 0x70f7 },
	{ 0x366e, 0x7117 },
	{ 0x366f, 0x70f4 },
	{ 0x3670, 0x710c },
	{ 0x3671, 0x70f0 },
	{ 0x3672, 0x7104 },
	{ 0x3673, 0x70f3 },
	{ 0x3674, 0x7110 },
	{ 0x3675, 0x70fc },
	{ 0x3676, 0x70ff },
	{ 0x3677, 0x7106 },
	{ 0x3678, 0x7113 },
	{ 0x3679, 0x7100 },
	{ 0x367a, 0x70f8 },
	{ 0x367b, 0x70f6 },
	{ 0x367c, 0x710b },
	{ 0x367d, 0x7102 },
	{ 0x367e, 0x710e },
	{ 0x3721, 0x727e },
	{ 0x3722, 0x727b },
	{ 0x3723, 0x727c },
	{ 0x3724, 0x727f },
	{ 0x3725, 0x731d },
	{ 0x3726, 0x7317 },
	{ 0x3727, 0x7307 },
	{ 0x3728, 0x7311 },
	{ 0x3729, 0x7318 },
	{ 0x372a, 0x730a },
	{ 0x372b, 0x7308 },
	{ 0x372c, 0x72ff },
	{ 0x372d, 0x730f },
	{ 0x372e, 0x731e },
	{ 0x372f, 0x7388 },
	{ 0x3730, 0x73f6 },
	{ 0x3731, 0x73f8 },
	{ 0x3732, 0x73f5 },
	{ 0x3733, 0x7404 },
	{ 0x3734, 0x7401 },
	{ 0x3735, 0x73fd },
	{ 0x3736, 0x7407 },
	{ 0x3737, 0x7400 },
	{ 0x3738, 0x73fa },
	{ 0x3739, 0x73fc },
	{ 0x373a, 0x73ff },
	{ 0x373b, 0x740c },
	{ 0x373c, 0x740b },
	{ 0x373d, 0x73f4 },
	{ 0x373e, 0x7408 },
	{ 0x373f, 0x7564 },
	{ 0x3740, 0x7563 },
	{ 0x3741, 0x75ce },
	{ 0x3742, 0x75d2 },
	{ 0x3743, 0x75cf },
	{ 0x3744, 0x75cb },
	{ 0x3745, 0x75cc },
	{ 0x3746, 0x75d1 },
	{ 0x3747, 0x75d0 },
	{ 0x3748, 0x768f },
	{ 0x3749, 0x7689 },
	{ 0x374a, 0x76d3 },
	{ 0x374b, 0x7739 },
	{ 0x374c, 0x772f },
	{ 0x374d, 0x772d },
	{ 0x374e, 0x7731 },
	{ 0x374f, 0x7732 },
	{ 0x3750, 0x7734 },
	{ 0x3751, 0x7733 },
	{ 0x3752, 0x773d },
	{ 0x3753, 0x7725 },
	{ 0x3754, 0x773b },
	{ 0x3755, 0x7735 },
	{ 0x3756, 0x7848 },
	{ 0x3757, 0x7852 },
	{ 0x3758, 0x7849 },
	{ 0x3759, 0x784d },
	{ 0x375a, 0x784a },
	{ 0x375b, 0x784c },
	{ 0x375c, 0x7826 },
	{ 0x375d, 0x7845 },
	{ 0x375e, 0x7850 },
	{ 0x375f, 0x7964 },
	{ 0x3760, 0x7967 },
	{ 0x3761, 0x7969 },
	{ 0x3762, 0x796a },
	{ 0x3763, 0x7963 },
	{ 0x3764, 0x796b },
	{ 0x3765, 0x7961 },
	{ 0x3766, 0x79bb },
	{ 0x3767, 0x79fa },
	{ 0x3768, 0x79f8 },
	{ 0x3769, 0x79f6 },
	{ 0x376a, 0x79f7 },
	{ 0x376b, 0x7a8f },
	{ 0x376c, 0x7a94 },
	{ 0x376d, 0x7a90 },
	{ 0x376e, 0x7b35 },
	{ 0x376f, 0x7b3b },
	{ 0x3770, 0x7b34 },
	{ 0x3771, 0x7b25 },
	{ 0x3772, 0x7b30 },
	{ 0x3773, 0x7b22 },
	{ 0x3774, 0x7b24 },
	{ 0x3775, 0x7b33 },
	{ 0x3776, 0x7b18 },
	{ 0x3777, 0x7b2a },
	{ 0x3778, 0x7b1d },
	{ 0x3779, 0x7b31 },
	{ 0x377a, 0x7b2b },
	{ 0x377b, 0x7b2d },
	{ 0x377c, 0x7b2f },
	{ 0x377d, 0x7b32 },
	{ 0x377e, 0x7b38 },
	{ 0x3821, 0x7b1a },
	{ 0x3822, 0x7b23 },
	{ 0x3823, 0x7c94 },
	{ 0x3824, 0x7c98 },
	{ 0x3825, 0x7c96 },
	{ 0x3826, 0x7ca3 },
	{ 0x3827, 0x7d35 },
	{ 0x3828, 0x7d3d },
	{ 0x3829, 0x7d38 },
	{ 0x382a, 0x7d36 },
	{ 0x382b, 0x7d3a },
	{ 0x382c, 0x7d45 },
	{ 0x382d, 0x7d2c },
	{ 0x382e, 0x7d29 },
	{ 0x382f, 0x7d41 },
	{ 0x3830, 0x7d47 },
	{ 0x3831, 0x7d3e },
	{ 0x3832, 0x7d3f },
	{ 0x3833, 0x7d4a },
	{ 0x3834, 0x7d3b },
	{ 0x3835, 0x7d28 },
	{ 0x3836, 0x7f63 },
	{ 0x3837, 0x7f95 },
	{ 0x3838, 0x7f9c },
	{ 0x3839, 0x7f9d },
	{ 0x383a, 0x7f9b },
	{ 0x383b, 0x7fca },
	{ 0x383c, 0x7fcb },
	{ 0x383d, 0x7fcd },
	{ 0x383e, 0x7fd0 },
	{ 0x383f, 0x7fd1 },
	{ 0x3840, 0x7fc7 },
	{ 0x3841, 0x7fcf },
	{ 0x3842, 0x7fc9 },
	{ 0x3843, 0x801f },
	{ 0x3844, 0x801e },
	{ 0x3845, 0x801b },
	{ 0x3846, 0x8047 },
	{ 0x3847, 0x8043 },
	{ 0x3848, 0x8048 },
	{ 0x3849, 0x8118 },
	{ 0x384a, 0x8125 },
	{ 0x384b, 0x8119 },
	{ 0x384c, 0x811b },
	{ 0x384d, 0x812d },
	{ 0x384e, 0x811f },
	{ 0x384f, 0x812c },
	{ 0x3850, 0x811e },
	{ 0x3851, 0x8121 },
	{ 0x3852, 0x8115 },
	{ 0x3853, 0x8127 },
	{ 0x3854, 0x811d },
	{ 0x3855, 0x8122 },
	{ 0x3856, 0x8211 },
	{ 0x3857, 0x8238 },
	{ 0x3858, 0x8233 },
	{ 0x3859, 0x823a },
	{ 0x385a, 0x8234 },
	{ 0x385b, 0x8232 },
	{ 0x385c, 0x8274 },
	{ 0x385d, 0x8390 },
	{ 0x385e, 0x83a3 },
	{ 0x385f, 0x83a8 },
	{ 0x3860, 0x838d },
	{ 0x3861, 0x837a },
	{ 0x3862, 0x8373 },
	{ 0x3863, 0x83a4 },
	{ 0x3864, 0x8374 },
	{ 0x3865, 0x838f },
	{ 0x3866, 0x8381 },
	{ 0x3867, 0x8395 },
	{ 0x3868, 0x8399 },
	{ 0x3869, 0x8375 },
	{ 0x386a, 0x8394 },
	{ 0x386b, 0x83a9 },
	{ 0x386c, 0x837d },
	{ 0x386d, 0x8383 },
	{ 0x386e, 0x838c },
	{ 0x386f, 0x839d },
	{ 0x3870, 0x839b },
	{ 0x3871, 0x83aa },
	{ 0x3872, 0x838b },
	{ 0x3873, 0x837e },
	{ 0x3874, 0x83a5 },
	{ 0x3875, 0x83af },
	{ 0x3876, 0x8388 },
	{ 0x3877, 0x8397 },
	{ 0x3878, 0x83b0 },
	{ 0x3879, 0x837f },
	{ 0x387a, 0x83a6 },
	{ 0x387b, 0x8387 },
	{ 0x387c, 0x83ae },
	{ 0x387d, 0x8376 },
	{ 0x387e, 0x8659 },
	{ 0x3921, 0x8656 },
	{ 0x3922, 0x86bf },
	{ 0x3923, 0x86b7 },
	{ 0x3924, 0x86c2 },
	{ 0x3925, 0x86c1 },
	{ 0x3926, 0x86c5 },
	{ 0x3927, 0x86ba },
	{ 0x3928, 0x86b0 },
	{ 0x3929, 0x86c8 },
	{ 0x392a, 0x86b9 },
	{ 0x392b, 0x86b3 },
	{ 0x392c, 0x86b8 },
	{ 0x392d, 0x86cc },
	{ 0x392e, 0x86b4 },
	{ 0x392f, 0x86bb },
	{ 0x3930, 0x86bc },
	{ 0x3931, 0x86c3 },
	{ 0x3932, 0x86bd },
	{ 0x3933, 0x86be },
	{ 0x3934, 0x8852 },
	{ 0x3935, 0x8889 },
	{ 0x3936, 0x8895 },
	{ 0x3937, 0x88a8 },
	{ 0x3938, 0x88a2 },
	{ 0x3939, 0x88aa },
	{ 0x393a, 0x889a },
	{ 0x393b, 0x8891 },
	{ 0x393c, 0x88a1 },
	{ 0x393d, 0x889f },
	{ 0x393e, 0x8898 },
	{ 0x393f, 0x88a7 },
	{ 0x3940, 0x8899 },
	{ 0x3941, 0x889b },
	{ 0x3942, 0x8897 },
	{ 0x3943, 0x88a4 },
	{ 0x3944, 0x88ac },
	{ 0x3945, 0x888c },
	{ 0x3946, 0x8893 },
	{ 0x3947, 0x888e },
	{ 0x3948, 0x8982 },
	{ 0x3949, 0x89d6 },
	{ 0x394a, 0x89d9 },
	{ 0x394b, 0x89d5 },
	{ 0x394c, 0x8a30 },
	{ 0x394d, 0x8a27 },
	{ 0x394e, 0x8a2c },
	{ 0x394f, 0x8a1e },
	{ 0x3950, 0x8c39 },
	{ 0x3951, 0x8c3b },
	{ 0x3952, 0x8c5c },
	{ 0x3953, 0x8c5d },
	{ 0x3954, 0x8c7d },
	{ 0x3955, 0x8ca5 },
	{ 0x3956, 0x8d7d },
	{ 0x3957, 0x8d7b },
	{ 0x3958, 0x8d79 },
	{ 0x3959, 0x8dbc },
	{ 0x395a, 0x8dc2 },
	{ 0x395b, 0x8db9 },
	{ 0x395c, 0x8dbf },
	{ 0x395d, 0x8dc1 },
	{ 0x395e, 0x8ed8 },
	{ 0x395f, 0x8ede },
	{ 0x3960, 0x8edd },
	{ 0x3961, 0x8edc },
	{ 0x3962, 0x8ed7 },
	{ 0x3963, 0x8ee0 },
	{ 0x3964, 0x8ee1 },
	{ 0x3965, 0x9024 },
	{ 0x3966, 0x900b },
	{ 0x3967, 0x9011 },
	{ 0x3968, 0x901c },
	{ 0x3969, 0x900c },
	{ 0x396a, 0x9021 },
	{ 0x396b, 0x90ef },
	{ 0x396c, 0x90ea },
	{ 0x396d, 0x90f0 },
	{ 0x396e, 0x90f4 },
	{ 0x396f, 0x90f2 },
	{ 0x3970, 0x90f3 },
	{ 0x3971, 0x90d4 },
	{ 0x3972, 0x90eb },
	{ 0x3973, 0x90ec },
	{ 0x3974, 0x90e9 },
	{ 0x3975, 0x9156 },
	{ 0x3976, 0x9158 },
	{ 0x3977, 0x915a },
	{ 0x3978, 0x9153 },
	{ 0x3979, 0x9155 },
	{ 0x397a, 0x91ec },
	{ 0x397b, 0x91f4 },
	{ 0x397c, 0x91f1 },
	{ 0x397d, 0x91f3 },
	{ 0x397e, 0x91f8 },
	{ 0x3a21, 0x91e4 },
	{ 0x3a22, 0x91f9 },
	{ 0x3a23, 0x91ea },
	{ 0x3a24, 0x91eb },
	{ 0x3a25, 0x91f7 },
	{ 0x3a26, 0x91e8 },
	{ 0x3a27, 0x91ee },
	{ 0x3a28, 0x957a },
	{ 0x3a29, 0x9586 },
	{ 0x3a2a, 0x9588 },
	{ 0x3a2b, 0x967c },
	{ 0x3a2c, 0x966d },
	{ 0x3a2d, 0x966b },
	{ 0x3a2e, 0x9671 },
	{ 0x3a2f, 0x966f },
	{ 0x3a30, 0x96bf },
	{ 0x3a31, 0x976a },
	{ 0x3a32, 0x9804 },
	{ 0x3a33, 0x98e5 },
	{ 0x3a34, 0x9997 },
	{ 0x3a35, 0x509b },
	{ 0x3a36, 0x5095 },
	{ 0x3a37, 0x5094 },
	{ 0x3a38, 0x509e },
	{ 0x3a39, 0x508b },
	{ 0x3a3a, 0x50a3 },
	{ 0x3a3b, 0x5083 },
	{ 0x3a3c, 0x508c },
	{ 0x3a3d, 0x508e },
	{ 0x3a3e, 0x509d },
	{ 0x3a3f, 0x5068 },
	{ 0x3a40, 0x509c },
	{ 0x3a41, 0x5092 },
	{ 0x3a42, 0x5082 },
	{ 0x3a43, 0x5087 },
	{ 0x3a44, 0x515f },
	{ 0x3a45, 0x51d4 },
	{ 0x3a46, 0x5312 },
	{ 0x3a47, 0x5311 },
	{ 0x3a48, 0x53a4 },
	{ 0x3a49, 0x53a7 },
	{ 0x3a4a, 0x5591 },
	{ 0x3a4b, 0x55a8 },
	{ 0x3a4c, 0x55a5 },
	{ 0x3a4d, 0x55ad },
	{ 0x3a4e, 0x5577 },
	{ 0x3a4f, 0x5645 },
	{ 0x3a50, 0x55a2 },
	{ 0x3a51, 0x5593 },
	{ 0x3a52, 0x5588 },
	{ 0x3a53, 0x558f },
	{ 0x3a54, 0x55b5 },
	{ 0x3a55, 0x5581 },
	{ 0x3a56, 0x55a3 },
	{ 0x3a57, 0x5592 },
	{ 0x3a58, 0x55a4 },
	{ 0x3a59, 0x557d },
	{ 0x3a5a, 0x558c },
	{ 0x3a5b, 0x55a6 },
	{ 0x3a5c, 0x557f },
	{ 0x3a5d, 0x5595 },
	{ 0x3a5e, 0x55a1 },
	{ 0x3a5f, 0x558e },
	{ 0x3a60, 0x570c },
	{ 0x3a61, 0x5829 },
	{ 0x3a62, 0x5837 },
	{ 0x3a63, 0x5819 },
	{ 0x3a64, 0x581e },
	{ 0x3a65, 0x5827 },
	{ 0x3a66, 0x5823 },
	{ 0x3a67, 0x5828 },
	{ 0x3a68, 0x57f5 },
	{ 0x3a69, 0x5848 },
	{ 0x3a6a, 0x5825 },
	{ 0x3a6b, 0x581c },
	{ 0x3a6c, 0x581b },
	{ 0x3a6d, 0x5833 },
	{ 0x3a6e, 0x583f },
	{ 0x3a6f, 0x5836 },
	{ 0x3a70, 0x582e },
	{ 0x3a71, 0x5839 },
	{ 0x3a72, 0x5838 },
	{ 0x3a73, 0x582d },
	{ 0x3a74, 0x582c },
	{ 0x3a75, 0x583b },
	{ 0x3a76, 0x5961 },
	{ 0x3a77, 0x5aaf },
	{ 0x3a78, 0x5a94 },
	{ 0x3a79, 0x5a9f },
	{ 0x3a7a, 0x5a7a },
	{ 0x3a7b, 0x5aa2 },
	{ 0x3a7c, 0x5a9e },
	{ 0x3a7d, 0x5a78 },
	{ 0x3a7e, 0x5aa6 },
	{ 0x3b21, 0x5a7c },
	{ 0x3b22, 0x5aa5 },
	{ 0x3b23, 0x5aac },
	{ 0x3b24, 0x5a95 },
	{ 0x3b25, 0x5aae },
	{ 0x3b26, 0x5a37 },
	{ 0x3b27, 0x5a84 },
	{ 0x3b28, 0x5a8a },
	{ 0x3b29, 0x5a97 },
	{ 0x3b2a, 0x5a83 },
	{ 0x3b2b, 0x5a8b },
	{ 0x3b2c, 0x5aa9 },
	{ 0x3b2d, 0x5a7b },
	{ 0x3b2e, 0x5a7d },
	{ 0x3b2f, 0x5a8c },
	{ 0x3b30, 0x5a9c },
	{ 0x3b31, 0x5a8f },
	{ 0x3b32, 0x5a93 },
	{ 0x3b33, 0x5a9d },
	{ 0x3b34, 0x5bea },
	{ 0x3b35, 0x5bcd },
	{ 0x3b36, 0x5bcb },
	{ 0x3b37, 0x5bd4 },
	{ 0x3b38, 0x5bd1 },
	{ 0x3b39, 0x5bca },
	{ 0x3b3a, 0x5bce },
	{ 0x3b3b, 0x5c0c },
	{ 0x3b3c, 0x5c30 },
	{ 0x3b3d, 0x5d37 },
	{ 0x3b3e, 0x5d43 },
	{ 0x3b3f, 0x5d6b },
	{ 0x3b40, 0x5d41 },
	{ 0x3b41, 0x5d4b },
	{ 0x3b42, 0x5d3f },
	{ 0x3b43, 0x5d35 },
	{ 0x3b44, 0x5d51 },
	{ 0x3b45, 0x5d4e },
	{ 0x3b46, 0x5d55 },
	{ 0x3b47, 0x5d33 },
	{ 0x3b48, 0x5d3a },
	{ 0x3b49, 0x5d52 },
	{ 0x3b4a, 0x5d3d },
	{ 0x3b4b, 0x5d31 },
	{ 0x3b4c, 0x5d59 },
	{ 0x3b4d, 0x5d42 },
	{ 0x3b4e, 0x5d39 },
	{ 0x3b4f, 0x5d49 },
	{ 0x3b50, 0x5d38 },
	{ 0x3b51, 0x5d3c },
	{ 0x3b52, 0x5d32 },
	{ 0x3b53, 0x5d36 },
	{ 0x3b54, 0x5d40 },
	{ 0x3b55, 0x5d45 },
	{ 0x3b56, 0x5e44 },
	{ 0x3b57, 0x5e41 },
	{ 0x3b58, 0x5f58 },
	{ 0x3b59, 0x5fa6 },
	{ 0x3b5a, 0x5fa5 },
	{ 0x3b5b, 0x5fab },
	{ 0x3b5c, 0x60c9 },
	{ 0x3b5d, 0x60b9 },
	{ 0x3b5e, 0x60cc },
	{ 0x3b5f, 0x60e2 },
	{ 0x3b60, 0x60ce },
	{ 0x3b61, 0x60c4 },
	{ 0x3b62, 0x6114 },
	{ 0x3b63, 0x60f2 },
	{ 0x3b64, 0x610a },
	{ 0x3b65, 0x6116 },
	{ 0x3b66, 0x6105 },
	{ 0x3b67, 0x60f5 },
	{ 0x3b68, 0x6113 },
	{ 0x3b69, 0x60f8 },
	{ 0x3b6a, 0x60fc },
	{ 0x3b6b, 0x60fe },
	{ 0x3b6c, 0x60c1 },
	{ 0x3b6d, 0x6103 },
	{ 0x3b6e, 0x6118 },
	{ 0x3b6f, 0x611d },
	{ 0x3b70, 0x6110 },
	{ 0x3b71, 0x60ff },
	{ 0x3b72, 0x6104 },
	{ 0x3b73, 0x610b },
	{ 0x3b74, 0x624a },
	{ 0x3b75, 0x6394 },
	{ 0x3b76, 0x63b1 },
	{ 0x3b77, 0x63b0 },
	{ 0x3b78, 0x63ce },
	{ 0x3b79, 0x63e5 },
	{ 0x3b7a, 0x63e8 },
	{ 0x3b7b, 0x63ef },
	{ 0x3b7c, 0x63c3 },
	{ 0x3b7d, 0x649d },
	{ 0x3b7e, 0x63f3 },
	{ 0x3c21, 0x63ca },
	{ 0x3c22, 0x63e0 },
	{ 0x3c23, 0x63f6 },
	{ 0x3c24, 0x63d5 },
	{ 0x3c25, 0x63f2 },
	{ 0x3c26, 0x63f5 },
	{ 0x3c27, 0x6461 },
	{ 0x3c28, 0x63df },
	{ 0x3c29, 0x63be },
	{ 0x3c2a, 0x63dd },
	{ 0x3c2b, 0x63dc },
	{ 0x3c2c, 0x63c4 },
	{ 0x3c2d, 0x63d8 },
	{ 0x3c2e, 0x63d3 },
	{ 0x3c2f, 0x63c2 },
	{ 0x3c30, 0x63c7 },
	{ 0x3c31, 0x63cc },
	{ 0x3c32, 0x63cb },
	{ 0x3c33, 0x63c8 },
	{ 0x3c34, 0x63f0 },
	{ 0x3c35, 0x63d7 },
	{ 0x3c36, 0x63d9 },
	{ 0x3c37, 0x6532 },
	{ 0x3c38, 0x6567 },
	{ 0x3c39, 0x656a },
	{ 0x3c3a, 0x6564 },
	{ 0x3c3b, 0x655c },
	{ 0x3c3c, 0x6568 },
	{ 0x3c3d, 0x6565 },
	{ 0x3c3e, 0x658c },
	{ 0x3c3f, 0x659d },
	{ 0x3c40, 0x659e },
	{ 0x3c41, 0x65ae },
	{ 0x3c42, 0x65d0 },
	{ 0x3c43, 0x65d2 },
	{ 0x3c44, 0x667c },
	{ 0x3c45, 0x666c },
	{ 0x3c46, 0x667b },
	{ 0x3c47, 0x6680 },
	{ 0x3c48, 0x6671 },
	{ 0x3c49, 0x6679 },
	{ 0x3c4a, 0x666a },
	{ 0x3c4b, 0x6672 },
	{ 0x3c4c, 0x6701 },
	{ 0x3c4d, 0x690c },
	{ 0x3c4e, 0x68d3 },
	{ 0x3c4f, 0x6904 },
	{ 0x3c50, 0x68dc },
	{ 0x3c51, 0x692a },
	{ 0x3c52, 0x68ec },
	{ 0x3c53, 0x68ea },
	{ 0x3c54, 0x68f1 },
	{ 0x3c55, 0x690f },
	{ 0x3c56, 0x68d6 },
	{ 0x3c57, 0x68f7 },
	{ 0x3c58, 0x68eb },
	{ 0x3c59, 0x68e4 },
	{ 0x3c5a, 0x68f6 },
	{ 0x3c5b, 0x6913 },
	{ 0x3c5c, 0x6910 },
	{ 0x3c5d, 0x68f3 },
	{ 0x3c5e, 0x68e1 },
	{ 0x3c5f, 0x6907 },
	{ 0x3c60, 0x68cc },
	{ 0x3c61, 0x6908 },
	{ 0x3c62, 0x6970 },
	{ 0x3c63, 0x68b4 },
	{ 0x3c64, 0x6911 },
	{ 0x3c65, 0x68ef },
	{ 0x3c66, 0x68c6 },
	{ 0x3c67, 0x6914 },
	{ 0x3c68, 0x68f8 },
	{ 0x3c69, 0x68d0 },
	{ 0x3c6a, 0x68fd },
	{ 0x3c6b, 0x68fc },
	{ 0x3c6c, 0x68e8 },
	{ 0x3c6d, 0x690b },
	{ 0x3c6e, 0x690a },
	{ 0x3c6f, 0x6917 },
	{ 0x3c70, 0x68ce },
	{ 0x3c71, 0x68c8 },
	{ 0x3c72, 0x68dd },
	{ 0x3c73, 0x68de },
	{ 0x3c74, 0x68e6 },
	{ 0x3c75, 0x68f4 },
	{ 0x3c76, 0x68d1 },
	{ 0x3c77, 0x6906 },
	{ 0x3c78, 0x68d4 },
	{ 0x3c79, 0x68e9 },
	{ 0x3c7a, 0x6915 },
	{ 0x3c7b, 0x6925 },
	{ 0x3c7c, 0x68c7 },
	{ 0x3c7d, 0x6b39 },
	{ 0x3c7e, 0x6b3b },
	{ 0x3d21, 0x6b3f },
	{ 0x3d22, 0x6b3c },
	{ 0x3d23, 0x6b94 },
	{ 0x3d24, 0x6b97 },
	{ 0x3d25, 0x6b99 },
	{ 0x3d26, 0x6b95 },
	{ 0x3d27, 0x6bbd },
	{ 0x3d28, 0x6bf0 },
	{ 0x3d29, 0x6bf2 },
	{ 0x3d2a, 0x6bf3 },
	{ 0x3d2b, 0x6c30 },
	{ 0x3d2c, 0x6dfc },
	{ 0x3d2d, 0x6e46 },
	{ 0x3d2e, 0x6e47 },
	{ 0x3d2f, 0x6e1f },
	{ 0x3d30, 0x6e49 },
	{ 0x3d31, 0x6e88 },
	{ 0x3d32, 0x6e3c },
	{ 0x3d33, 0x6e3d },
	{ 0x3d34, 0x6e45 },
	{ 0x3d35, 0x6e62 },
	{ 0x3d36, 0x6e2b },
	{ 0x3d37, 0x6e3f },
	{ 0x3d38, 0x6e41 },
	{ 0x3d39, 0x6e5d },
	{ 0x3d3a, 0x6e73 },
	{ 0x3d3b, 0x6e1c },
	{ 0x3d3c, 0x6e33 },
	{ 0x3d3d, 0x6e4b },
	{ 0x3d3e, 0x6e40 },
	{ 0x3d3f, 0x6e51 },
	{ 0x3d40, 0x6e3b },
	{ 0x3d41, 0x6e03 },
	{ 0x3d42, 0x6e2e },
	{ 0x3d43, 0x6e5e },
	{ 0x3d44, 0x6e68 },
	{ 0x3d45, 0x6e5c },
	{ 0x3d46, 0x6e61 },
	{ 0x3d47, 0x6e31 },
	{ 0x3d48, 0x6e28 },
	{ 0x3d49, 0x6e60 },
	{ 0x3d4a, 0x6e71 },
	{ 0x3d4b, 0x6e6b },
	{ 0x3d4c, 0x6e39 },
	{ 0x3d4d, 0x6e22 },
	{ 0x3d4e, 0x6e30 },
	{ 0x3d4f, 0x6e53 },
	{ 0x3d50, 0x6e65 },
	{ 0x3d51, 0x6e27 },
	{ 0x3d52, 0x6e78 },
	{ 0x3d53, 0x6e64 },
	{ 0x3d54, 0x6e77 },
	{ 0x3d55, 0x6e55 },
	{ 0x3d56, 0x6e79 },
	{ 0x3d57, 0x6e52 },
	{ 0x3d58, 0x6e66 },
	{ 0x3d59, 0x6e35 },
	{ 0x3d5a, 0x6e36 },
	{ 0x3d5b, 0x6e5a },
	{ 0x3d5c, 0x7120 },
	{ 0x3d5d, 0x711e },
	{ 0x3d5e, 0x712f },
	{ 0x3d5f, 0x70fb },
	{ 0x3d60, 0x712e },
	{ 0x3d61, 0x7131 },
	{ 0x3d62, 0x7123 },
	{ 0x3d63, 0x7125 },
	{ 0x3d64, 0x7122 },
	{ 0x3d65, 0x7132 },
	{ 0x3d66, 0x711f },
	{ 0x3d67, 0x7128 },
	{ 0x3d68, 0x713a },
	{ 0x3d69, 0x711b },
	{ 0x3d6a, 0x724b },
	{ 0x3d6b, 0x725a },
	{ 0x3d6c, 0x7288 },
	{ 0x3d6d, 0x7289 },
	{ 0x3d6e, 0x7286 },
	{ 0x3d6f, 0x7285 },
	{ 0x3d70, 0x728b },
	{ 0x3d71, 0x7312 },
	{ 0x3d72, 0x730b },
	{ 0x3d73, 0x7330 },
	{ 0x3d74, 0x7322 },
	{ 0x3d75, 0x7331 },
	{ 0x3d76, 0x7333 },
	{ 0x3d77, 0x7327 },
	{ 0x3d78, 0x7332 },
	{ 0x3d79, 0x732d },
	{ 0x3d7a, 0x7326 },
	{ 0x3d7b, 0x7323 },
	{ 0x3d7c, 0x7335 },
	{ 0x3d7d, 0x730c },
	{ 0x3d7e, 0x742e },
	{ 0x3e21, 0x742c },
	{ 0x3e22, 0x7430 },
	{ 0x3e23, 0x742b },
	{ 0x3e24, 0x7416 },
	{ 0x3e25, 0x741a },
	{ 0x3e26, 0x7421 },
	{ 0x3e27, 0x742d },
	{ 0x3e28, 0x7431 },
	{ 0x3e29, 0x7424 },
	{ 0x3e2a, 0x7423 },
	{ 0x3e2b, 0x741d },
	{ 0x3e2c, 0x7429 },
	{ 0x3e2d, 0x7420 },
	{ 0x3e2e, 0x7432 },
	{ 0x3e2f, 0x74fb },
	{ 0x3e30, 0x752f },
	{ 0x3e31, 0x756f },
	{ 0x3e32, 0x756c },
	{ 0x3e33, 0x75e7 },
	{ 0x3e34, 0x75da },
	{ 0x3e35, 0x75e1 },
	{ 0x3e36, 0x75e6 },
	{ 0x3e37, 0x75dd },
	{ 0x3e38, 0x75df },
	{ 0x3e39, 0x75e4 },
	{ 0x3e3a, 0x75d7 },
	{ 0x3e3b, 0x7695 },
	{ 0x3e3c, 0x7692 },
	{ 0x3e3d, 0x76da },
	{ 0x3e3e, 0x7746 },
	{ 0x3e3f, 0x7747 },
	{ 0x3e40, 0x7744 },
	{ 0x3e41, 0x774d },
	{ 0x3e42, 0x7745 },
	{ 0x3e43, 0x774a },
	{ 0x3e44, 0x774e },
	{ 0x3e45, 0x774b },
	{ 0x3e46, 0x774c },
	{ 0x3e47, 0x77de },
	{ 0x3e48, 0x77ec },
	{ 0x3e49, 0x7860 },
	{ 0x3e4a, 0x7864 },
	{ 0x3e4b, 0x7865 },
	{ 0x3e4c, 0x785c },
	{ 0x3e4d, 0x786d },
	{ 0x3e4e, 0x7871 },
	{ 0x3e4f, 0x786a },
	{ 0x3e50, 0x786e },
	{ 0x3e51, 0x7870 },
	{ 0x3e52, 0x7869 },
	{ 0x3e53, 0x7868 },
	{ 0x3e54, 0x785e },
	{ 0x3e55, 0x7862 },
	{ 0x3e56, 0x7974 },
	{ 0x3e57, 0x7973 },
	{ 0x3e58, 0x7972 },
	{ 0x3e59, 0x7970 },
	{ 0x3e5a, 0x7a02 },
	{ 0x3e5b, 0x7a0a },
	{ 0x3e5c, 0x7a03 },
	{ 0x3e5d, 0x7a0c },
	{ 0x3e5e, 0x7a04 },
	{ 0x3e5f, 0x7a99 },
	{ 0x3e60, 0x7ae6 },
	{ 0x3e61, 0x7ae4 },
	{ 0x3e62, 0x7b4a },
	{ 0x3e63, 0x7b47 },
	{ 0x3e64, 0x7b44 },
	{ 0x3e65, 0x7b48 },
	{ 0x3e66, 0x7b4c },
	{ 0x3e67, 0x7b4e },
	{ 0x3e68, 0x7b40 },
	{ 0x3e69, 0x7b58 },
	{ 0x3e6a, 0x7b45 },
	{ 0x3e6b, 0x7ca2 },
	{ 0x3e6c, 0x7c9e },
	{ 0x3e6d, 0x7ca8 },
	{ 0x3e6e, 0x7ca1 },
	{ 0x3e6f, 0x7d58 },
	{ 0x3e70, 0x7d6f },
	{ 0x3e71, 0x7d63 },
	{ 0x3e72, 0x7d53 },
	{ 0x3e73, 0x7d56 },
	{ 0x3e74, 0x7d67 },
	{ 0x3e75, 0x7d6a },
	{ 0x3e76, 0x7d4f },
	{ 0x3e77, 0x7d6d },
	{ 0x3e78, 0x7d5c },
	{ 0x3e79, 0x7d6b },
	{ 0x3e7a, 0x7d52 },
	{ 0x3e7b, 0x7d54 },
	{ 0x3e7c, 0x7d69 },
	{ 0x3e7d, 0x7d51 },
	{ 0x3e7e, 0x7d5f },
	{ 0x3f21, 0x7d4e },
	{ 0x3f22, 0x7f3e },
	{ 0x3f23, 0x7f3f },
	{ 0x3f24, 0x7f65 },
	{ 0x3f25, 0x7f66 },
	{ 0x3f26, 0x7fa2 },
	{ 0x3f27, 0x7fa0 },
	{ 0x3f28, 0x7fa1 },
	{ 0x3f29, 0x7fd7 },
	{ 0x3f2a, 0x8051 },
	{ 0x3f2b, 0x804f },
	{ 0x3f2c, 0x8050 },
	{ 0x3f2d, 0x80fe },
	{ 0x3f2e, 0x80d4 },
	{ 0x3f2f, 0x8143 },
	{ 0x3f30, 0x814a },
	{ 0x3f31, 0x8152 },
	{ 0x3f32, 0x814f },
	{ 0x3f33, 0x8147 },
	{ 0x3f34, 0x813d },
	{ 0x3f35, 0x814d },
	{ 0x3f36, 0x813a },
	{ 0x3f37, 0x81e6 },
	{ 0x3f38, 0x81ee },
	{ 0x3f39, 0x81f7 },
	{ 0x3f3a, 0x81f8 },
	{ 0x3f3b, 0x81f9 },
	{ 0x3f3c, 0x8204 },
	{ 0x3f3d, 0x823c },
	{ 0x3f3e, 0x823d },
	{ 0x3f3f, 0x823f },
	{ 0x3f40, 0x8275 },
	{ 0x3f41, 0x833b },
	{ 0x3f42, 0x83cf },
	{ 0x3f43, 0x83f9 },
	{ 0x3f44, 0x8423 },
	{ 0x3f45, 0x83c0 },
	{ 0x3f46, 0x83e8 },
	{ 0x3f47, 0x8412 },
	{ 0x3f48, 0x83e7 },
	{ 0x3f49, 0x83e4 },
	{ 0x3f4a, 0x83fc },
	{ 0x3f4b, 0x83f6 },
	{ 0x3f4c, 0x8410 },
	{ 0x3f4d, 0x83c6 },
	{ 0x3f4e, 0x83c8 },
	{ 0x3f4f, 0x83eb },
	{ 0x3f50, 0x83e3 },
	{ 0x3f51, 0x83bf },
	{ 0x3f52, 0x8401 },
	{ 0x3f53, 0x83dd },
	{ 0x3f54, 0x83e5 },
	{ 0x3f55, 0x83d8 },
	{ 0x3f56, 0x83ff },
	{ 0x3f57, 0x83e1 },
	{ 0x3f58, 0x83cb },
	{ 0x3f59, 0x83ce },
	{ 0x3f5a, 0x83d6 },
	{ 0x3f5b, 0x83f5 },
	{ 0x3f5c, 0x83c9 },
	{ 0x3f5d, 0x8409 },
	{ 0x3f5e, 0x840f },
	{ 0x3f5f, 0x83de },
	{ 0x3f60, 0x8411 },
	{ 0x3f61, 0x8406 },
	{ 0x3f62, 0x83c2 },
	{ 0x3f63, 0x83f3 },
	{ 0x3f64, 0x83d5 },
	{ 0x3f65, 0x83fa },
	{ 0x3f66, 0x83c7 },
	{ 0x3f67, 0x83d1 },
	{ 0x3f68, 0x83ea },
	{ 0x3f69, 0x8413 },
	{ 0x3f6a, 0x839a },
	{ 0x3f6b, 0x83c3 },
	{ 0x3f6c, 0x83ec },
	{ 0x3f6d, 0x83ee },
	{ 0x3f6e, 0x83c4 },
	{ 0x3f6f, 0x83fb },
	{ 0x3f70, 0x83d7 },
	{ 0x3f71, 0x83e2 },
	{ 0x3f72, 0x841b },
	{ 0x3f73, 0x83db },
	{ 0x3f74, 0x83fe },
	{ 0x3f75, 0x86d8 },
	{ 0x3f76, 0x86e2 },
	{ 0x3f77, 0x86e6 },
	{ 0x3f78, 0x86d3 },
	{ 0x3f79, 0x86e3 },
	{ 0x3f7a, 0x86da },
	{ 0x3f7b, 0x86ea },
	{ 0x3f7c, 0x86dd },
	{ 0x3f7d, 0x86eb },
	{ 0x3f7e, 0x86dc },
	{ 0x4021, 0x86ec },
	{ 0x4022, 0x86e9 },
	{ 0x4023, 0x86d7 },
	{ 0x4024, 0x86e8 },
	{ 0x4025, 0x86d1 },
	{ 0x4026, 0x8848 },
	{ 0x4027, 0x8856 },
	{ 0x4028, 0x8855 },
	{ 0x4029, 0x88ba },
	{ 0x402a, 0x88d7 },
	{ 0x402b, 0x88b9 },
	{ 0x402c, 0x88b8 },
	{ 0x402d, 0x88c0 },
	{ 0x402e, 0x88be },
	{ 0x402f, 0x88b6 },
	{ 0x4030, 0x88bc },
	{ 0x4031, 0x88b7 },
	{ 0x4032, 0x88bd },
	{ 0x4033, 0x88b2 },
	{ 0x4034, 0x8901 },
	{ 0x4035, 0x88c9 },
	{ 0x4036, 0x8995 },
	{ 0x4037, 0x8998 },
	{ 0x4038, 0x8997 },
	{ 0x4039, 0x89dd },
	{ 0x403a, 0x89da },
	{ 0x403b, 0x89db },
	{ 0x403c, 0x8a4e },
	{ 0x403d, 0x8a4d },
	{ 0x403e, 0x8a39 },
	{ 0x403f, 0x8a59 },
	{ 0x4040, 0x8a40 },
	{ 0x4041, 0x8a57 },
	{ 0x4042, 0x8a58 },
	{ 0x4043, 0x8a44 },
	{ 0x4044, 0x8a45 },
	{ 0x4045, 0x8a52 },
	{ 0x4046, 0x8a48 },
	{ 0x4047, 0x8a51 },
	{ 0x4048, 0x8a4a },
	{ 0x4049, 0x8a4c },
	{ 0x404a, 0x8a4f },
	{ 0x404b, 0x8c5f },
	{ 0x404c, 0x8c81 },
	{ 0x404d, 0x8c80 },
	{ 0x404e, 0x8cba },
	{ 0x404f, 0x8cbe },
	{ 0x4050, 0x8cb0 },
	{ 0x4051, 0x8cb9 },
	{ 0x4052, 0x8cb5 },
	{ 0x4053, 0x8d84 },
	{ 0x4054, 0x8d80 },
	{ 0x4055, 0x8d89 },
	{ 0x4056, 0x8dd8 },
	{ 0x4057, 0x8dd3 },
	{ 0x4058, 0x8dcd },
	{ 0x4059, 0x8dc7 },
	{ 0x405a, 0x8dd6 },
	{ 0x405b, 0x8ddc },
	{ 0x405c, 0x8dcf },
	{ 0x405d, 0x8dd5 },
	{ 0x405e, 0x8dd9 },
	{ 0x405f, 0x8dc8 },
	{ 0x4060, 0x8dd7 },
	{ 0x4061, 0x8dc5 },
	{ 0x4062, 0x8eef },
	{ 0x4063, 0x8ef7 },
	{ 0x4064, 0x8efa },
	{ 0x4065, 0x8ef9 },
	{ 0x4066, 0x8ee6 },
	{ 0x4067, 0x8eee },
	{ 0x4068, 0x8ee5 },
	{ 0x4069, 0x8ef5 },
	{ 0x406a, 0x8ee7 },
	{ 0x406b, 0x8ee8 },
	{ 0x406c, 0x8ef6 },
	{ 0x406d, 0x8eeb },
	{ 0x406e, 0x8ef1 },
	{ 0x406f, 0x8eec },
	{ 0x4070, 0x8ef4 },
	{ 0x4071, 0x8ee9 },
	{ 0x4072, 0x902d },
	{ 0x4073, 0x9034 },
	{ 0x4074, 0x902f },
	{ 0x4075, 0x9106 },
	{ 0x4076, 0x912c },
	{ 0x4077, 0x9104 },
	{ 0x4078, 0x90ff },
	{ 0x4079, 0x90fc },
	{ 0x407a, 0x9108 },
	{ 0x407b, 0x90f9 },
	{ 0x407c, 0x90fb },
	{ 0x407d, 0x9101 },
	{ 0x407e, 0x9100 },
	{ 0x4121, 0x9107 },
	{ 0x4122, 0x9105 },
	{ 0x4123, 0x9103 },
	{ 0x4124, 0x9161 },
	{ 0x4125, 0x9164 },
	{ 0x4126, 0x915f },
	{ 0x4127, 0x9162 },
	{ 0x4128, 0x9160 },
	{ 0x4129, 0x9201 },
	{ 0x412a, 0x920a },
	{ 0x412b, 0x9225 },
	{ 0x412c, 0x9203 },
	{ 0x412d, 0x921a },
	{ 0x412e, 0x9226 },
	{ 0x412f, 0x920f },
	{ 0x4130, 0x920c },
	{ 0x4131, 0x9200 },
	{ 0x4132, 0x9212 },
	{ 0x4133, 0x91ff },
	{ 0x4134, 0x91fd },
	{ 0x4135, 0x9206 },
	{ 0x4136, 0x9204 },
	{ 0x4137, 0x9227 },
	{ 0x4138, 0x9202 },
	{ 0x4139, 0x921c },
	{ 0x413a, 0x9224 },
	{ 0x413b, 0x9219 },
	{ 0x413c, 0x9217 },
	{ 0x413d, 0x9205 },
	{ 0x413e, 0x9216 },
	{ 0x413f, 0x957b },
	{ 0x4140, 0x958d },
	{ 0x4141, 0x958c },
	{ 0x4142, 0x9590 },
	{ 0x4143, 0x9687 },
	{ 0x4144, 0x967e },
	{ 0x4145, 0x9688 },
	{ 0x4146, 0x9689 },
	{ 0x4147, 0x9683 },
	{ 0x4148, 0x9680 },
	{ 0x4149, 0x96c2 },
	{ 0x414a, 0x96c8 },
	{ 0x414b, 0x96c3 },
	{ 0x414c, 0x96f1 },
	{ 0x414d, 0x96f0 },
	{ 0x414e, 0x976c },
	{ 0x414f, 0x9770 },
	{ 0x4150, 0x976e },
	{ 0x4151, 0x9807 },
	{ 0x4152, 0x98a9 },
	{ 0x4153, 0x98eb },
	{ 0x4154, 0x9ce6 },
	{ 0x4155, 0x9ef9 },
	{ 0x4156, 0x4e83 },
	{ 0x4157, 0x4e84 },
	{ 0x4158, 0x4eb6 },
	{ 0x4159, 0x50bd },
	{ 0x415a, 0x50bf },
	{ 0x415b, 0x50c6 },
	{ 0x415c, 0x50ae },
	{ 0x415d, 0x50c4 },
	{ 0x415e, 0x50ca },
	{ 0x415f, 0x50b4 },
	{ 0x4160, 0x50c8 },
	{ 0x4161, 0x50c2 },
	{ 0x4162, 0x50b0 },
	{ 0x4163, 0x50c1 },
	{ 0x4164, 0x50ba },
	{ 0x4165, 0x50b1 },
	{ 0x4166, 0x50cb },
	{ 0x4167, 0x50c9 },
	{ 0x4168, 0x50b6 },
	{ 0x4169, 0x50b8 },
	{ 0x416a, 0x51d7 },
	{ 0x416b, 0x527a },
	{ 0x416c, 0x5278 },
	{ 0x416d, 0x527b },
	{ 0x416e, 0x527c },
	{ 0x416f, 0x55c3 },
	{ 0x4170, 0x55db },
	{ 0x4171, 0x55cc },
	{ 0x4172, 0x55d0 },
	{ 0x4173, 0x55cb },
	{ 0x4174, 0x55ca },
	{ 0x4175, 0x55dd },
	{ 0x4176, 0x55c0 },
	{ 0x4177, 0x55d4 },
	{ 0x4178, 0x55c4 },
	{ 0x4179, 0x55e9 },
	{ 0x417a, 0x55bf },
	{ 0x417b, 0x55d2 },
	{ 0x417c, 0x558d },
	{ 0x417d, 0x55cf },
	{ 0x417e, 0x55d5 },
	{ 0x4221, 0x55e2 },
	{ 0x4222, 0x55d6 },
	{ 0x4223, 0x55c8 },
	{ 0x4224, 0x55f2 },
	{ 0x4225, 0x55cd },
	{ 0x4226, 0x55d9 },
	{ 0x4227, 0x55c2 },
	{ 0x4228, 0x5714 },
	{ 0x4229, 0x5853 },
	{ 0x422a, 0x5868 },
	{ 0x422b, 0x5864 },
	{ 0x422c, 0x584f },
	{ 0x422d, 0x584d },
	{ 0x422e, 0x5849 },
	{ 0x422f, 0x586f },
	{ 0x4230, 0x5855 },
	{ 0x4231, 0x584e },
	{ 0x4232, 0x585d },
	{ 0x4233, 0x5859 },
	{ 0x4234, 0x5865 },
	{ 0x4235, 0x585b },
	{ 0x4236, 0x583d },
	{ 0x4237, 0x5863 },
	{ 0x4238, 0x5871 },
	{ 0x4239, 0x58fc },
	{ 0x423a, 0x5ac7 },
	{ 0x423b, 0x5ac4 },
	{ 0x423c, 0x5acb },
	{ 0x423d, 0x5aba },
	{ 0x423e, 0x5ab8 },
	{ 0x423f, 0x5ab1 },
	{ 0x4240, 0x5ab5 },
	{ 0x4241, 0x5ab0 },
	{ 0x4242, 0x5abf },
	{ 0x4243, 0x5ac8 },
	{ 0x4244, 0x5abb },
	{ 0x4245, 0x5ac6 },
	{ 0x4246, 0x5ab7 },
	{ 0x4247, 0x5ac0 },
	{ 0x4248, 0x5aca },
	{ 0x4249, 0x5ab4 },
	{ 0x424a, 0x5ab6 },
	{ 0x424b, 0x5acd },
	{ 0x424c, 0x5ab9 },
	{ 0x424d, 0x5a90 },
	{ 0x424e, 0x5bd6 },
	{ 0x424f, 0x5bd8 },
	{ 0x4250, 0x5bd9 },
	{ 0x4251, 0x5c1f },
	{ 0x4252, 0x5c33 },
	{ 0x4253, 0x5d71 },
	{ 0x4254, 0x5d63 },
	{ 0x4255, 0x5d4a },
	{ 0x4256, 0x5d65 },
	{ 0x4257, 0x5d72 },
	{ 0x4258, 0x5d6c },
	{ 0x4259, 0x5d5e },
	{ 0x425a, 0x5d68 },
	{ 0x425b, 0x5d67 },
	{ 0x425c, 0x5d62 },
	{ 0x425d, 0x5df0 },
	{ 0x425e, 0x5e4f },
	{ 0x425f, 0x5e4e },
	{ 0x4260, 0x5e4a },
	{ 0x4261, 0x5e4d },
	{ 0x4262, 0x5e4b },
	{ 0x4263, 0x5ec5 },
	{ 0x4264, 0x5ecc },
	{ 0x4265, 0x5ec6 },
	{ 0x4266, 0x5ecb },
	{ 0x4267, 0x5ec7 },
	{ 0x4268, 0x5f40 },
	{ 0x4269, 0x5faf },
	{ 0x426a, 0x5fad },
	{ 0x426b, 0x60f7 },
	{ 0x426c, 0x6149 },
	{ 0x426d, 0x614a },
	{ 0x426e, 0x612b },
	{ 0x426f, 0x6145 },
	{ 0x4270, 0x6136 },
	{ 0x4271, 0x6132 },
	{ 0x4272, 0x612e },
	{ 0x4273, 0x6146 },
	{ 0x4274, 0x612f },
	{ 0x4275, 0x614f },
	{ 0x4276, 0x6129 },
	{ 0x4277, 0x6140 },
	{ 0x4278, 0x6220 },
	{ 0x4279, 0x9168 },
	{ 0x427a, 0x6223 },
	{ 0x427b, 0x6225 },
	{ 0x427c, 0x6224 },
	{ 0x427d, 0x63c5 },
	{ 0x427e, 0x63f1 },
	{ 0x4321, 0x63eb },
	{ 0x4322, 0x6410 },
	{ 0x4323, 0x6412 },
	{ 0x4324, 0x6409 },
	{ 0x4325, 0x6420 },
	{ 0x4326, 0x6424 },
	{ 0x4327, 0x6433 },
	{ 0x4328, 0x6443 },
	{ 0x4329, 0x641f },
	{ 0x432a, 0x6415 },
	{ 0x432b, 0x6418 },
	{ 0x432c, 0x6439 },
	{ 0x432d, 0x6437 },
	{ 0x432e, 0x6422 },
	{ 0x432f, 0x6423 },
	{ 0x4330, 0x640c },
	{ 0x4331, 0x6426 },
	{ 0x4332, 0x6430 },
	{ 0x4333, 0x6428 },
	{ 0x4334, 0x6441 },
	{ 0x4335, 0x6435 },
	{ 0x4336, 0x642f },
	{ 0x4337, 0x640a },
	{ 0x4338, 0x641a },
	{ 0x4339, 0x6440 },
	{ 0x433a, 0x6425 },
	{ 0x433b, 0x6427 },
	{ 0x433c, 0x640b },
	{ 0x433d, 0x63e7 },
	{ 0x433e, 0x641b },
	{ 0x433f, 0x642e },
	{ 0x4340, 0x6421 },
	{ 0x4341, 0x640e },
	{ 0x4342, 0x656f },
	{ 0x4343, 0x6592 },
	{ 0x4344, 0x65d3 },
	{ 0x4345, 0x6686 },
	{ 0x4346, 0x668c },
	{ 0x4347, 0x6695 },
	{ 0x4348, 0x6690 },
	{ 0x4349, 0x668b },
	{ 0x434a, 0x668a },
	{ 0x434b, 0x6699 },
	{ 0x434c, 0x6694 },
	{ 0x434d, 0x6678 },
	{ 0x434e, 0x6720 },
	{ 0x434f, 0x6966 },
	{ 0x4350, 0x695f },
	{ 0x4351, 0x6938 },
	{ 0x4352, 0x694e },
	{ 0x4353, 0x6962 },
	{ 0x4354, 0x6971 },
	{ 0x4355, 0x693f },
	{ 0x4356, 0x6945 },
	{ 0x4357, 0x696a },
	{ 0x4358, 0x6939 },
	{ 0x4359, 0x6942 },
	{ 0x435a, 0x6957 },
	{ 0x435b, 0x6959 },
	{ 0x435c, 0x697a },
	{ 0x435d, 0x6948 },
	{ 0x435e, 0x6949 },
	{ 0x435f, 0x6935 },
	{ 0x4360, 0x696c },
	{ 0x4361, 0x6933 },
	{ 0x4362, 0x693d },
	{ 0x4363, 0x6965 },
	{ 0x4364, 0x68f0 },
	{ 0x4365, 0x6978 },
	{ 0x4366, 0x6934 },
	{ 0x4367, 0x6969 },
	{ 0x4368, 0x6940 },
	{ 0x4369, 0x696f },
	{ 0x436a, 0x6944 },
	{ 0x436b, 0x6976 },
	{ 0x436c, 0x6958 },
	{ 0x436d, 0x6941 },
	{ 0x436e, 0x6974 },
	{ 0x436f, 0x694c },
	{ 0x4370, 0x693b },
	{ 0x4371, 0x694b },
	{ 0x4372, 0x6937 },
	{ 0x4373, 0x695c },
	{ 0x4374, 0x694f },
	{ 0x4375, 0x6951 },
	{ 0x4376, 0x6932 },
	{ 0x4377, 0x6952 },
	{ 0x4378, 0x692f },
	{ 0x4379, 0x697b },
	{ 0x437a, 0x693c },
	{ 0x437b, 0x6b46 },
	{ 0x437c, 0x6b45 },
	{ 0x437d, 0x6b43 },
	{ 0x437e, 0x6b42 },
	{ 0x4421, 0x6b48 },
	{ 0x4422, 0x6b41 },
	{ 0x4423, 0x6b9b },
	{ 0x4424, 0x6bfb },
	{ 0x4425, 0x6bfc },
	{ 0x4426, 0x6bf9 },
	{ 0x4427, 0x6bf7 },
	{ 0x4428, 0x6bf8 },
	{ 0x4429, 0x6e9b },
	{ 0x442a, 0x6ed6 },
	{ 0x442b, 0x6ec8 },
	{ 0x442c, 0x6e8f },
	{ 0x442d, 0x6ec0 },
	{ 0x442e, 0x6e9f },
	{ 0x442f, 0x6e93 },
	{ 0x4430, 0x6e94 },
	{ 0x4431, 0x6ea0 },
	{ 0x4432, 0x6eb1 },
	{ 0x4433, 0x6eb9 },
	{ 0x4434, 0x6ec6 },
	{ 0x4435, 0x6ed2 },
	{ 0x4436, 0x6ebd },
	{ 0x4437, 0x6ec1 },
	{ 0x4438, 0x6e9e },
	{ 0x4439, 0x6ec9 },
	{ 0x443a, 0x6eb7 },
	{ 0x443b, 0x6eb0 },
	{ 0x443c, 0x6ecd },
	{ 0x443d, 0x6ea6 },
	{ 0x443e, 0x6ecf },
	{ 0x443f, 0x6eb2 },
	{ 0x4440, 0x6ebe },
	{ 0x4441, 0x6ec3 },
	{ 0x4442, 0x6edc },
	{ 0x4443, 0x6ed8 },
	{ 0x4444, 0x6e99 },
	{ 0x4445, 0x6e92 },
	{ 0x4446, 0x6e8e },
	{ 0x4447, 0x6e8d },
	{ 0x4448, 0x6ea4 },
	{ 0x4449, 0x6ea1 },
	{ 0x444a, 0x6ebf },
	{ 0x444b, 0x6eb3 },
	{ 0x444c, 0x6ed0 },
	{ 0x444d, 0x6eca },
	{ 0x444e, 0x6e97 },
	{ 0x444f, 0x6eae },
	{ 0x4450, 0x6ea3 },
	{ 0x4451, 0x7147 },
	{ 0x4452, 0x7154 },
	{ 0x4453, 0x7152 },
	{ 0x4454, 0x7163 },
	{ 0x4455, 0x7160 },
	{ 0x4456, 0x7141 },
	{ 0x4457, 0x715d },
	{ 0x4458, 0x7162 },
	{ 0x4459, 0x7172 },
	{ 0x445a, 0x7178 },
	{ 0x445b, 0x716a },
	{ 0x445c, 0x7161 },
	{ 0x445d, 0x7142 },
	{ 0x445e, 0x7158 },
	{ 0x445f, 0x7143 },
	{ 0x4460, 0x714b },
	{ 0x4461, 0x7170 },
	{ 0x4462, 0x715f },
	{ 0x4463, 0x7150 },
	{ 0x4464, 0x7153 },
	{ 0x4465, 0x7144 },
	{ 0x4466, 0x714d },
	{ 0x4467, 0x715a },
	{ 0x4468, 0x724f },
	{ 0x4469, 0x728d },
	{ 0x446a, 0x728c },
	{ 0x446b, 0x7291 },
	{ 0x446c, 0x7290 },
	{ 0x446d, 0x728e },
	{ 0x446e, 0x733c },
	{ 0x446f, 0x7342 },
	{ 0x4470, 0x733b },
	{ 0x4471, 0x733a },
	{ 0x4472, 0x7340 },
	{ 0x4473, 0x734a },
	{ 0x4474, 0x7349 },
	{ 0x4475, 0x7444 },
	{ 0x4476, 0x744a },
	{ 0x4477, 0x744b },
	{ 0x4478, 0x7452 },
	{ 0x4479, 0x7451 },
	{ 0x447a, 0x7457 },
	{ 0x447b, 0x7440 },
	{ 0x447c, 0x744f },
	{ 0x447d, 0x7450 },
	{ 0x447e, 0x744e },
	{ 0x4521, 0x7442 },
	{ 0x4522, 0x7446 },
	{ 0x4523, 0x744d },
	{ 0x4524, 0x7454 },
	{ 0x4525, 0x74e1 },
	{ 0x4526, 0x74ff },
	{ 0x4527, 0x74fe },
	{ 0x4528, 0x74fd },
	{ 0x4529, 0x751d },
	{ 0x452a, 0x7579 },
	{ 0x452b, 0x7577 },
	{ 0x452c, 0x6983 },
	{ 0x452d, 0x75ef },
	{ 0x452e, 0x760f },
	{ 0x452f, 0x7603 },
	{ 0x4530, 0x75f7 },
	{ 0x4531, 0x75fe },
	{ 0x4532, 0x75fc },
	{ 0x4533, 0x75f9 },
	{ 0x4534, 0x75f8 },
	{ 0x4535, 0x7610 },
	{ 0x4536, 0x75fb },
	{ 0x4537, 0x75f6 },
	{ 0x4538, 0x75ed },
	{ 0x4539, 0x75f5 },
	{ 0x453a, 0x75fd },
	{ 0x453b, 0x7699 },
	{ 0x453c, 0x76b5 },
	{ 0x453d, 0x76dd },
	{ 0x453e, 0x7755 },
	{ 0x453f, 0x775f },
	{ 0x4540, 0x7760 },
	{ 0x4541, 0x7752 },
	{ 0x4542, 0x7756 },
	{ 0x4543, 0x775a },
	{ 0x4544, 0x7769 },
	{ 0x4545, 0x7767 },
	{ 0x4546, 0x7754 },
	{ 0x4547, 0x7759 },
	{ 0x4548, 0x776d },
	{ 0x4549, 0x77e0 },
	{ 0x454a, 0x7887 },
	{ 0x454b, 0x789a },
	{ 0x454c, 0x7894 },
	{ 0x454d, 0x788f },
	{ 0x454e, 0x7884 },
	{ 0x454f, 0x7895 },
	{ 0x4550, 0x7885 },
	{ 0x4551, 0x7886 },
	{ 0x4552, 0x78a1 },
	{ 0x4553, 0x7883 },
	{ 0x4554, 0x7879 },
	{ 0x4555, 0x7899 },
	{ 0x4556, 0x7880 },
	{ 0x4557, 0x7896 },
	{ 0x4558, 0x787b },
	{ 0x4559, 0x797c },
	{ 0x455a, 0x7982 },
	{ 0x455b, 0x797d },
	{ 0x455c, 0x7979 },
	{ 0x455d, 0x7a11 },
	{ 0x455e, 0x7a18 },
	{ 0x455f, 0x7a19 },
	{ 0x4560, 0x7a12 },
	{ 0x4561, 0x7a17 },
	{ 0x4562, 0x7a15 },
	{ 0x4563, 0x7a22 },
	{ 0x4564, 0x7a13 },
	{ 0x4565, 0x7a1b },
	{ 0x4566, 0x7a10 },
	{ 0x4567, 0x7aa3 },
	{ 0x4568, 0x7aa2 },
	{ 0x4569, 0x7a9e },
	{ 0x456a, 0x7aeb },
	{ 0x456b, 0x7b66 },
	{ 0x456c, 0x7b64 },
	{ 0x456d, 0x7b6d },
	{ 0x456e, 0x7b74 },
	{ 0x456f, 0x7b69 },
	{ 0x4570, 0x7b72 },
	{ 0x4571, 0x7b65 },
	{ 0x4572, 0x7b73 },
	{ 0x4573, 0x7b71 },
	{ 0x4574, 0x7b70 },
	{ 0x4575, 0x7b61 },
	{ 0x4576, 0x7b78 },
	{ 0x4577, 0x7b76 },
	{ 0x4578, 0x7b63 },
	{ 0x4579, 0x7cb2 },
	{ 0x457a, 0x7cb4 },
	{ 0x457b, 0x7caf },
	{ 0x457c, 0x7d88 },
	{ 0x457d, 0x7d86 },
	{ 0x457e, 0x7d80 },
	{ 0x4621, 0x7d8d },
	{ 0x4622, 0x7d7f },
	{ 0x4623, 0x7d85 },
	{ 0x4624, 0x7d7a },
	{ 0x4625, 0x7d8e },
	{ 0x4626, 0x7d7b },
	{ 0x4627, 0x7d83 },
	{ 0x4628, 0x7d7c },
	{ 0x4629, 0x7d8c },
	{ 0x462a, 0x7d94 },
	{ 0x462b, 0x7d84 },
	{ 0x462c, 0x7d7d },
	{ 0x462d, 0x7d92 },
	{ 0x462e, 0x7f6d },
	{ 0x462f, 0x7f6b },
	{ 0x4630, 0x7f67 },
	{ 0x4631, 0x7f68 },
	{ 0x4632, 0x7f6c },
	{ 0x4633, 0x7fa6 },
	{ 0x4634, 0x7fa5 },
	{ 0x4635, 0x7fa7 },
	{ 0x4636, 0x7fdb },
	{ 0x4637, 0x7fdc },
	{ 0x4638, 0x8021 },
	{ 0x4639, 0x8164 },
	{ 0x463a, 0x8160 },
	{ 0x463b, 0x8177 },
	{ 0x463c, 0x815c },
	{ 0x463d, 0x8169 },
	{ 0x463e, 0x815b },
	{ 0x463f, 0x8162 },
	{ 0x4640, 0x8172 },
	{ 0x4641, 0x6721 },
	{ 0x4642, 0x815e },
	{ 0x4643, 0x8176 },
	{ 0x4644, 0x8167 },
	{ 0x4645, 0x816f },
	{ 0x4646, 0x8144 },
	{ 0x4647, 0x8161 },
	{ 0x4648, 0x821d },
	{ 0x4649, 0x8249 },
	{ 0x464a, 0x8244 },
	{ 0x464b, 0x8240 },
	{ 0x464c, 0x8242 },
	{ 0x464d, 0x8245 },
	{ 0x464e, 0x84f1 },
	{ 0x464f, 0x843f },
	{ 0x4650, 0x8456 },
	{ 0x4651, 0x8476 },
	{ 0x4652, 0x8479 },
	{ 0x4653, 0x848f },
	{ 0x4654, 0x848d },
	{ 0x4655, 0x8465 },
	{ 0x4656, 0x8451 },
	{ 0x4657, 0x8440 },
	{ 0x4658, 0x8486 },
	{ 0x4659, 0x8467 },
	{ 0x465a, 0x8430 },
	{ 0x465b, 0x844d },
	{ 0x465c, 0x847d },
	{ 0x465d, 0x845a },
	{ 0x465e, 0x8459 },
	{ 0x465f, 0x8474 },
	{ 0x4660, 0x8473 },
	{ 0x4661, 0x845d },
	{ 0x4662, 0x8507 },
	{ 0x4663, 0x845e },
	{ 0x4664, 0x8437 },
	{ 0x4665, 0x843a },
	{ 0x4666, 0x8434 },
	{ 0x4667, 0x847a },
	{ 0x4668, 0x8443 },
	{ 0x4669, 0x8478 },
	{ 0x466a, 0x8432 },
	{ 0x466b, 0x8445 },
	{ 0x466c, 0x8429 },
	{ 0x466d, 0x83d9 },
	{ 0x466e, 0x844b },
	{ 0x466f, 0x842f },
	{ 0x4670, 0x8442 },
	{ 0x4671, 0x842d },
	{ 0x4672, 0x845f },
	{ 0x4673, 0x8470 },
	{ 0x4674, 0x8439 },
	{ 0x4675, 0x844e },
	{ 0x4676, 0x844c },
	{ 0x4677, 0x8452 },
	{ 0x4678, 0x846f },
	{ 0x4679, 0x84c5 },
	{ 0x467a, 0x848e },
	{ 0x467b, 0x843b },
	{ 0x467c, 0x8447 },
	{ 0x467d, 0x8436 },
	{ 0x467e, 0x8433 },
	{ 0x4721, 0x8468 },
	{ 0x4722, 0x847e },
	{ 0x4723, 0x8444 },
	{ 0x4724, 0x842b },
	{ 0x4725, 0x8460 },
	{ 0x4726, 0x8454 },
	{ 0x4727, 0x846e },
	{ 0x4728, 0x8450 },
	{ 0x4729, 0x870b },
	{ 0x472a, 0x8704 },
	{ 0x472b, 0x86f7 },
	{ 0x472c, 0x870c },
	{ 0x472d, 0x86fa },
	{ 0x472e, 0x86d6 },
	{ 0x472f, 0x86f5 },
	{ 0x4730, 0x874d },
	{ 0x4731, 0x86f8 },
	{ 0x4732, 0x870e },
	{ 0x4733, 0x8709 },
	{ 0x4734, 0x8701 },
	{ 0x4735, 0x86f6 },
	{ 0x4736, 0x870d },
	{ 0x4737, 0x8705 },
	{ 0x4738, 0x88d6 },
	{ 0x4739, 0x88cb },
	{ 0x473a, 0x88cd },
	{ 0x473b, 0x88ce },
	{ 0x473c, 0x88de },
	{ 0x473d, 0x88db },
	{ 0x473e, 0x88da },
	{ 0x473f, 0x88cc },
	{ 0x4740, 0x88d0 },
	{ 0x4741, 0x8985 },
	{ 0x4742, 0x899b },
	{ 0x4743, 0x89df },
	{ 0x4744, 0x89e5 },
	{ 0x4745, 0x89e4 },
	{ 0x4746, 0x89e1 },
	{ 0x4747, 0x89e0 },
	{ 0x4748, 0x89e2 },
	{ 0x4749, 0x89dc },
	{ 0x474a, 0x89e6 },
	{ 0x474b, 0x8a76 },
	{ 0x474c, 0x8a86 },
	{ 0x474d, 0x8a7f },
	{ 0x474e, 0x8a61 },
	{ 0x474f, 0x8a3f },
	{ 0x4750, 0x8a77 },
	{ 0x4751, 0x8a82 },
	{ 0x4752, 0x8a84 },
	{ 0x4753, 0x8a75 },
	{ 0x4754, 0x8a83 },
	{ 0x4755, 0x8a81 },
	{ 0x4756, 0x8a74 },
	{ 0x4757, 0x8a7a },
	{ 0x4758, 0x8c3c },
	{ 0x4759, 0x8c4b },
	{ 0x475a, 0x8c4a },
	{ 0x475b, 0x8c65 },
	{ 0x475c, 0x8c64 },
	{ 0x475d, 0x8c66 },
	{ 0x475e, 0x8c86 },
	{ 0x475f, 0x8c84 },
	{ 0x4760, 0x8c85 },
	{ 0x4761, 0x8ccc },
	{ 0x4762, 0x8d68 },
	{ 0x4763, 0x8d69 },
	{ 0x4764, 0x8d91 },
	{ 0x4765, 0x8d8c },
	{ 0x4766, 0x8d8e },
	{ 0x4767, 0x8d8f },
	{ 0x4768, 0x8d8d },
	{ 0x4769, 0x8d93 },
	{ 0x476a, 0x8d94 },
	{ 0x476b, 0x8d90 },
	{ 0x476c, 0x8d92 },
	{ 0x476d, 0x8df0 },
	{ 0x476e, 0x8de0 },
	{ 0x476f, 0x8dec },
	{ 0x4770, 0x8df1 },
	{ 0x4771, 0x8dee },
	{ 0x4772, 0x8dd0 },
	{ 0x4773, 0x8de9 },
	{ 0x4774, 0x8de3 },
	{ 0x4775, 0x8de2 },
	{ 0x4776, 0x8de7 },
	{ 0x4777, 0x8df2 },
	{ 0x4778, 0x8deb },
	{ 0x4779, 0x8df4 },
	{ 0x477a, 0x8f06 },
	{ 0x477b, 0x8eff },
	{ 0x477c, 0x8f01 },
	{ 0x477d, 0x8f00 },
	{ 0x477e, 0x8f05 },
	{ 0x4821, 0x8f07 },
	{ 0x4822, 0x8f08 },
	{ 0x4823, 0x8f02 },
	{ 0x4824, 0x8f0b },
	{ 0x4825, 0x9052 },
	{ 0x4826, 0x903f },
	{ 0x4827, 0x9044 },
	{ 0x4828, 0x9049 },
	{ 0x4829, 0x903d },
	{ 0x482a, 0x9110 },
	{ 0x482b, 0x910d },
	{ 0x482c, 0x910f },
	{ 0x482d, 0x9111 },
	{ 0x482e, 0x9116 },
	{ 0x482f, 0x9114 },
	{ 0x4830, 0x910b },
	{ 0x4831, 0x910e },
	{ 0x4832, 0x916e },
	{ 0x4833, 0x916f },
	{ 0x4834, 0x9248 },
	{ 0x4835, 0x9252 },
	{ 0x4836, 0x9230 },
	{ 0x4837, 0x923a },
	{ 0x4838, 0x9266 },
	{ 0x4839, 0x9233 },
	{ 0x483a, 0x9265 },
	{ 0x483b, 0x925e },
	{ 0x483c, 0x9283 },
	{ 0x483d, 0x922e },
	{ 0x483e, 0x924a },
	{ 0x483f, 0x9246 },
	{ 0x4840, 0x926d },
	{ 0x4841, 0x926c },
	{ 0x4842, 0x924f },
	{ 0x4843, 0x9260 },
	{ 0x4844, 0x9267 },
	{ 0x4845, 0x926f },
	{ 0x4846, 0x9236 },
	{ 0x4847, 0x9261 },
	{ 0x4848, 0x9270 },
	{ 0x4849, 0x9231 },
	{ 0x484a, 0x9254 },
	{ 0x484b, 0x9263 },
	{ 0x484c, 0x9250 },
	{ 0x484d, 0x9272 },
	{ 0x484e, 0x924e },
	{ 0x484f, 0x9253 },
	{ 0x4850, 0x924c },
	{ 0x4851, 0x9256 },
	{ 0x4852, 0x9232 },
	{ 0x4853, 0x959f },
	{ 0x4854, 0x959c },
	{ 0x4855, 0x959e },
	{ 0x4856, 0x959b },
	{ 0x4857, 0x9692 },
	{ 0x4858, 0x9693 },
	{ 0x4859, 0x9691 },
	{ 0x485a, 0x9697 },
	{ 0x485b, 0x96ce },
	{ 0x485c, 0x96fa },
	{ 0x485d, 0x96fd },
	{ 0x485e, 0x96f8 },
	{ 0x485f, 0x96f5 },
	{ 0x4860, 0x9773 },
	{ 0x4861, 0x9777 },
	{ 0x4862, 0x9778 },
	{ 0x4863, 0x9772 },
	{ 0x4864, 0x980f },
	{ 0x4865, 0x980d },
	{ 0x4866, 0x980e },
	{ 0x4867, 0x98ac },
	{ 0x4868, 0x98f6 },
	{ 0x4869, 0x98f9 },
	{ 0x486a, 0x99af },
	{ 0x486b, 0x99b2 },
	{ 0x486c, 0x99b0 },
	{ 0x486d, 0x99b5 },
	{ 0x486e, 0x9aad },
	{ 0x486f, 0x9aab },
	{ 0x4870, 0x9b5b },
	{ 0x4871, 0x9cea },
	{ 0x4872, 0x9ced },
	{ 0x4873, 0x9ce7 },
	{ 0x4874, 0x9e80 },
	{ 0x4875, 0x9efd },
	{ 0x4876, 0x50e6 },
	{ 0x4877, 0x50d4 },
	{ 0x4878, 0x50d7 },
	{ 0x4879, 0x50e8 },
	{ 0x487a, 0x50f3 },
	{ 0x487b, 0x50db },
	{ 0x487c, 0x50ea },
	{ 0x487d, 0x50dd },
	{ 0x487e, 0x50e4 },
	{ 0x4921, 0x50d3 },
	{ 0x4922, 0x50ec },
	{ 0x4923, 0x50f0 },
	{ 0x4924, 0x50ef },
	{ 0x4925, 0x50e3 },
	{ 0x4926, 0x50e0 },
	{ 0x4927, 0x51d8 },
	{ 0x4928, 0x5280 },
	{ 0x4929, 0x5281 },
	{ 0x492a, 0x52e9 },
	{ 0x492b, 0x52eb },
	{ 0x492c, 0x5330 },
	{ 0x492d, 0x53ac },
	{ 0x492e, 0x5627 },
	{ 0x492f, 0x5615 },
	{ 0x4930, 0x560c },
	{ 0x4931, 0x5612 },
	{ 0x4932, 0x55fc },
	{ 0x4933, 0x560f },
	{ 0x4934, 0x561c },
	{ 0x4935, 0x5601 },
	{ 0x4936, 0x5613 },
	{ 0x4937, 0x5602 },
	{ 0x4938, 0x55fa },
	{ 0x4939, 0x561d },
	{ 0x493a, 0x5604 },
	{ 0x493b, 0x55ff },
	{ 0x493c, 0x55f9 },
	{ 0x493d, 0x5889 },
	{ 0x493e, 0x587c },
	{ 0x493f, 0x5890 },
	{ 0x4940, 0x5898 },
	{ 0x4941, 0x5886 },
	{ 0x4942, 0x5881 },
	{ 0x4943, 0x587f },
	{ 0x4944, 0x5874 },
	{ 0x4945, 0x588b },
	{ 0x4946, 0x587a },
	{ 0x4947, 0x5887 },
	{ 0x4948, 0x5891 },
	{ 0x4949, 0x588e },
	{ 0x494a, 0x5876 },
	{ 0x494b, 0x5882 },
	{ 0x494c, 0x5888 },
	{ 0x494d, 0x587b },
	{ 0x494e, 0x5894 },
	{ 0x494f, 0x588f },
	{ 0x4950, 0x58fe },
	{ 0x4951, 0x596b },
	{ 0x4952, 0x5adc },
	{ 0x4953, 0x5aee },
	{ 0x4954, 0x5ae5 },
	{ 0x4955, 0x5ad5 },
	{ 0x4956, 0x5aea },
	{ 0x4957, 0x5ada },
	{ 0x4958, 0x5aed },
	{ 0x4959, 0x5aeb },
	{ 0x495a, 0x5af3 },
	{ 0x495b, 0x5ae2 },
	{ 0x495c, 0x5ae0 },
	{ 0x495d, 0x5adb },
	{ 0x495e, 0x5aec },
	{ 0x495f, 0x5ade },
	{ 0x4960, 0x5add },
	{ 0x4961, 0x5ad9 },
	{ 0x4962, 0x5ae8 },
	{ 0x4963, 0x5adf },
	{ 0x4964, 0x5b77 },
	{ 0x4965, 0x5be0 },
	{ 0x4966, 0x5be3 },
	{ 0x4967, 0x5c63 },
	{ 0x4968, 0x5d82 },
	{ 0x4969, 0x5d80 },
	{ 0x496a, 0x5d7d },
	{ 0x496b, 0x5d86 },
	{ 0x496c, 0x5d7a },
	{ 0x496d, 0x5d81 },
	{ 0x496e, 0x5d77 },
	{ 0x496f, 0x5d8a },
	{ 0x4970, 0x5d89 },
	{ 0x4971, 0x5d88 },
	{ 0x4972, 0x5d7e },
	{ 0x4973, 0x5d7c },
	{ 0x4974, 0x5d8d },
	{ 0x4975, 0x5d79 },
	{ 0x4976, 0x5d7f },
	{ 0x4977, 0x5e58 },
	{ 0x4978, 0x5e59 },
	{ 0x4979, 0x5e53 },
	{ 0x497a, 0x5ed8 },
	{ 0x497b, 0x5ed1 },
	{ 0x497c, 0x5ed7 },
	{ 0x497d, 0x5ece },
	{ 0x497e, 0x5edc },
	{ 0x4a21, 0x5ed5 },
	{ 0x4a22, 0x5ed9 },
	{ 0x4a23, 0x5ed2 },
	{ 0x4a24, 0x5ed4 },
	{ 0x4a25, 0x5f44 },
	{ 0x4a26, 0x5f43 },
	{ 0x4a27, 0x5f6f },
	{ 0x4a28, 0x5fb6 },
	{ 0x4a29, 0x612c },
	{ 0x4a2a, 0x6128 },
	{ 0x4a2b, 0x6141 },
	{ 0x4a2c, 0x615e },
	{ 0x4a2d, 0x6171 },
	{ 0x4a2e, 0x6173 },
	{ 0x4a2f, 0x6152 },
	{ 0x4a30, 0x6153 },
	{ 0x4a31, 0x6172 },
	{ 0x4a32, 0x616c },
	{ 0x4a33, 0x6180 },
	{ 0x4a34, 0x6174 },
	{ 0x4a35, 0x6154 },
	{ 0x4a36, 0x617a },
	{ 0x4a37, 0x615b },
	{ 0x4a38, 0x6165 },
	{ 0x4a39, 0x613b },
	{ 0x4a3a, 0x616a },
	{ 0x4a3b, 0x6161 },
	{ 0x4a3c, 0x6156 },
	{ 0x4a3d, 0x6229 },
	{ 0x4a3e, 0x6227 },
	{ 0x4a3f, 0x622b },
	{ 0x4a40, 0x642b },
	{ 0x4a41, 0x644d },
	{ 0x4a42, 0x645b },
	{ 0x4a43, 0x645d },
	{ 0x4a44, 0x6474 },
	{ 0x4a45, 0x6476 },
	{ 0x4a46, 0x6472 },
	{ 0x4a47, 0x6473 },
	{ 0x4a48, 0x647d },
	{ 0x4a49, 0x6475 },
	{ 0x4a4a, 0x6466 },
	{ 0x4a4b, 0x64a6 },
	{ 0x4a4c, 0x644e },
	{ 0x4a4d, 0x6482 },
	{ 0x4a4e, 0x645e },
	{ 0x4a4f, 0x645c },
	{ 0x4a50, 0x644b },
	{ 0x4a51, 0x6453 },
	{ 0x4a52, 0x6460 },
	{ 0x4a53, 0x6450 },
	{ 0x4a54, 0x647f },
	{ 0x4a55, 0x643f },
	{ 0x4a56, 0x646c },
	{ 0x4a57, 0x646b },
	{ 0x4a58, 0x6459 },
	{ 0x4a59, 0x6465 },
	{ 0x4a5a, 0x6477 },
	{ 0x4a5b, 0x6573 },
	{ 0x4a5c, 0x65a0 },
	{ 0x4a5d, 0x66a1 },
	{ 0x4a5e, 0x66a0 },
	{ 0x4a5f, 0x669f },
	{ 0x4a60, 0x6705 },
	{ 0x4a61, 0x6704 },
	{ 0x4a62, 0x6722 },
	{ 0x4a63, 0x69b1 },
	{ 0x4a64, 0x69b6 },
	{ 0x4a65, 0x69c9 },
	{ 0x4a66, 0x69a0 },
	{ 0x4a67, 0x69ce },
	{ 0x4a68, 0x6996 },
	{ 0x4a69, 0x69b0 },
	{ 0x4a6a, 0x69ac },
	{ 0x4a6b, 0x69bc },
	{ 0x4a6c, 0x6991 },
	{ 0x4a6d, 0x6999 },
	{ 0x4a6e, 0x698e },
	{ 0x4a6f, 0x69a7 },
	{ 0x4a70, 0x698d },
	{ 0x4a71, 0x69a9 },
	{ 0x4a72, 0x69be },
	{ 0x4a73, 0x69af },
	{ 0x4a74, 0x69bf },
	{ 0x4a75, 0x69c4 },
	{ 0x4a76, 0x69bd },
	{ 0x4a77, 0x69a4 },
	{ 0x4a78, 0x69d4 },
	{ 0x4a79, 0x69b9 },
	{ 0x4a7a, 0x69ca },
	{ 0x4a7b, 0x699a },
	{ 0x4a7c, 0x69cf },
	{ 0x4a7d, 0x69b3 },
	{ 0x4a7e, 0x6993 },
	{ 0x4b21, 0x69aa },
	{ 0x4b22, 0x69a1 },
	{ 0x4b23, 0x699e },
	{ 0x4b24, 0x69d9 },
	{ 0x4b25, 0x6997 },
	{ 0x4b26, 0x6990 },
	{ 0x4b27, 0x69c2 },
	{ 0x4b28, 0x69b5 },
	{ 0x4b29, 0x69a5 },
	{ 0x4b2a, 0x69c6 },
	{ 0x4b2b, 0x6b4a },
	{ 0x4b2c, 0x6b4d },
	{ 0x4b2d, 0x6b4b },
	{ 0x4b2e, 0x6b9e },
	{ 0x4b2f, 0x6b9f },
	{ 0x4b30, 0x6ba0 },
	{ 0x4b31, 0x6bc3 },
	{ 0x4b32, 0x6bc4 },
	{ 0x4b33, 0x6bfe },
	{ 0x4b34, 0x6ece },
	{ 0x4b35, 0x6ef5 },
	{ 0x4b36, 0x6ef1 },
	{ 0x4b37, 0x6f03 },
	{ 0x4b38, 0x6f25 },
	{ 0x4b39, 0x6ef8 },
	{ 0x4b3a, 0x6f37 },
	{ 0x4b3b, 0x6efb },
	{ 0x4b3c, 0x6f2e },
	{ 0x4b3d, 0x6f09 },
	{ 0x4b3e, 0x6f4e },
	{ 0x4b3f, 0x6f19 },
	{ 0x4b40, 0x6f1a },
	{ 0x4b41, 0x6f27 },
	{ 0x4b42, 0x6f18 },
	{ 0x4b43, 0x6f3b },
	{ 0x4b44, 0x6f12 },
	{ 0x4b45, 0x6eed },
	{ 0x4b46, 0x6f0a },
	{ 0x4b47, 0x6f36 },
	{ 0x4b48, 0x6f73 },
	{ 0x4b49, 0x6ef9 },
	{ 0x4b4a, 0x6eee },
	{ 0x4b4b, 0x6f2d },
	{ 0x4b4c, 0x6f40 },
	{ 0x4b4d, 0x6f30 },
	{ 0x4b4e, 0x6f3c },
	{ 0x4b4f, 0x6f35 },
	{ 0x4b50, 0x6eeb },
	{ 0x4b51, 0x6f07 },
	{ 0x4b52, 0x6f0e },
	{ 0x4b53, 0x6f43 },
	{ 0x4b54, 0x6f05 },
	{ 0x4b55, 0x6efd },
	{ 0x4b56, 0x6ef6 },
	{ 0x4b57, 0x6f39 },
	{ 0x4b58, 0x6f1c },
	{ 0x4b59, 0x6efc },
	{ 0x4b5a, 0x6f3a },
	{ 0x4b5b, 0x6f1f },
	{ 0x4b5c, 0x6f0d },
	{ 0x4b5d, 0x6f1e },
	{ 0x4b5e, 0x6f08 },
	{ 0x4b5f, 0x6f21 },
	{ 0x4b60, 0x7187 },
	{ 0x4b61, 0x7190 },
	{ 0x4b62, 0x7189 },
	{ 0x4b63, 0x7180 },
	{ 0x4b64, 0x7185 },
	{ 0x4b65, 0x7182 },
	{ 0x4b66, 0x718f },
	{ 0x4b67, 0x717b },
	{ 0x4b68, 0x7186 },
	{ 0x4b69, 0x7181 },
	{ 0x4b6a, 0x7197 },
	{ 0x4b6b, 0x7244 },
	{ 0x4b6c, 0x7253 },
	{ 0x4b6d, 0x7297 },
	{ 0x4b6e, 0x7295 },
	{ 0x4b6f, 0x7293 },
	{ 0x4b70, 0x7343 },
	{ 0x4b71, 0x734d },
	{ 0x4b72, 0x7351 },
	{ 0x4b73, 0x734c },
	{ 0x4b74, 0x7462 },
	{ 0x4b75, 0x7473 },
	{ 0x4b76, 0x7471 },
	{ 0x4b77, 0x7475 },
	{ 0x4b78, 0x7472 },
	{ 0x4b79, 0x7467 },
	{ 0x4b7a, 0x746e },
	{ 0x4b7b, 0x7500 },
	{ 0x4b7c, 0x7502 },
	{ 0x4b7d, 0x7503 },
	{ 0x4b7e, 0x757d },
	{ 0x4c21, 0x7590 },
	{ 0x4c22, 0x7616 },
	{ 0x4c23, 0x7608 },
	{ 0x4c24, 0x760c },
	{ 0x4c25, 0x7615 },
	{ 0x4c26, 0x7611 },
	{ 0x4c27, 0x760a },
	{ 0x4c28, 0x7614 },
	{ 0x4c29, 0x76b8 },
	{ 0x4c2a, 0x7781 },
	{ 0x4c2b, 0x777c },
	{ 0x4c2c, 0x7785 },
	{ 0x4c2d, 0x7782 },
	{ 0x4c2e, 0x776e },
	{ 0x4c2f, 0x7780 },
	{ 0x4c30, 0x776f },
	{ 0x4c31, 0x777e },
	{ 0x4c32, 0x7783 },
	{ 0x4c33, 0x78b2 },
	{ 0x4c34, 0x78aa },
	{ 0x4c35, 0x78b4 },
	{ 0x4c36, 0x78ad },
	{ 0x4c37, 0x78a8 },
	{ 0x4c38, 0x787e },
	{ 0x4c39, 0x78ab },
	{ 0x4c3a, 0x789e },
	{ 0x4c3b, 0x78a5 },
	{ 0x4c3c, 0x78a0 },
	{ 0x4c3d, 0x78ac },
	{ 0x4c3e, 0x78a2 },
	{ 0x4c3f, 0x78a4 },
	{ 0x4c40, 0x7998 },
	{ 0x4c41, 0x798a },
	{ 0x4c42, 0x798b },
	{ 0x4c43, 0x7996 },
	{ 0x4c44, 0x7995 },
	{ 0x4c45, 0x7994 },
	{ 0x4c46, 0x7993 },
	{ 0x4c47, 0x7997 },
	{ 0x4c48, 0x7988 },
	{ 0x4c49, 0x7992 },
	{ 0x4c4a, 0x7990 },
	{ 0x4c4b, 0x7a2b },
	{ 0x4c4c, 0x7a4a },
	{ 0x4c4d, 0x7a30 },
	{ 0x4c4e, 0x7a2f },
	{ 0x4c4f, 0x7a28 },
	{ 0x4c50, 0x7a26 },
	{ 0x4c51, 0x7aa8 },
	{ 0x4c52, 0x7aab },
	{ 0x4c53, 0x7aac },
	{ 0x4c54, 0x7aee },
	{ 0x4c55, 0x7b88 },
	{ 0x4c56, 0x7b9c },
	{ 0x4c57, 0x7b8a },
	{ 0x4c58, 0x7b91 },
	{ 0x4c59, 0x7b90 },
	{ 0x4c5a, 0x7b96 },
	{ 0x4c5b, 0x7b8d },
	{ 0x4c5c, 0x7b8c },
	{ 0x4c5d, 0x7b9b },
	{ 0x4c5e, 0x7b8e },
	{ 0x4c5f, 0x7b85 },
	{ 0x4c60, 0x7b98 },
	{ 0x4c61, 0x5284 },
	{ 0x4c62, 0x7b99 },
	{ 0x4c63, 0x7ba4 },
	{ 0x4c64, 0x7b82 },
	{ 0x4c65, 0x7cbb },
	{ 0x4c66, 0x7cbf },
	{ 0x4c67, 0x7cbc },
	{ 0x4c68, 0x7cba },
	{ 0x4c69, 0x7da7 },
	{ 0x4c6a, 0x7db7 },
	{ 0x4c6b, 0x7dc2 },
	{ 0x4c6c, 0x7da3 },
	{ 0x4c6d, 0x7daa },
	{ 0x4c6e, 0x7dc1 },
	{ 0x4c6f, 0x7dc0 },
	{ 0x4c70, 0x7dc5 },
	{ 0x4c71, 0x7d9d },
	{ 0x4c72, 0x7dce },
	{ 0x4c73, 0x7dc4 },
	{ 0x4c74, 0x7dc6 },
	{ 0x4c75, 0x7dcb },
	{ 0x4c76, 0x7dcc },
	{ 0x4c77, 0x7daf },
	{ 0x4c78, 0x7db9 },
	{ 0x4c79, 0x7d96 },
	{ 0x4c7a, 0x7dbc },
	{ 0x4c7b, 0x7d9f },
	{ 0x4c7c, 0x7da6 },
	{ 0x4c7d, 0x7dae },
	{ 0x4c7e, 0x7da9 },
	{ 0x4d21, 0x7da1 },
	{ 0x4d22, 0x7dc9 },
	{ 0x4d23, 0x7f73 },
	{ 0x4d24, 0x7fe2 },
	{ 0x4d25, 0x7fe3 },
	{ 0x4d26, 0x7fe5 },
	{ 0x4d27, 0x7fde },
	{ 0x4d28, 0x8024 },
	{ 0x4d29, 0x805d },
	{ 0x4d2a, 0x805c },
	{ 0x4d2b, 0x8189 },
	{ 0x4d2c, 0x8186 },
	{ 0x4d2d, 0x8183 },
	{ 0x4d2e, 0x8187 },
	{ 0x4d2f, 0x818d },
	{ 0x4d30, 0x818c },
	{ 0x4d31, 0x818b },
	{ 0x4d32, 0x8215 },
	{ 0x4d33, 0x8497 },
	{ 0x4d34, 0x84a4 },
	{ 0x4d35, 0x84a1 },
	{ 0x4d36, 0x849f },
	{ 0x4d37, 0x84ba },
	{ 0x4d38, 0x84ce },
	{ 0x4d39, 0x84c2 },
	{ 0x4d3a, 0x84ac },
	{ 0x4d3b, 0x84ae },
	{ 0x4d3c, 0x84ab },
	{ 0x4d3d, 0x84b9 },
	{ 0x4d3e, 0x84b4 },
	{ 0x4d3f, 0x84c1 },
	{ 0x4d40, 0x84cd },
	{ 0x4d41, 0x84aa },
	{ 0x4d42, 0x849a },
	{ 0x4d43, 0x84b1 },
	{ 0x4d44, 0x84d0 },
	{ 0x4d45, 0x849d },
	{ 0x4d46, 0x84a7 },
	{ 0x4d47, 0x84bb },
	{ 0x4d48, 0x84a2 },
	{ 0x4d49, 0x8494 },
	{ 0x4d4a, 0x84c7 },
	{ 0x4d4b, 0x84cc },
	{ 0x4d4c, 0x849b },
	{ 0x4d4d, 0x84a9 },
	{ 0x4d4e, 0x84af },
	{ 0x4d4f, 0x84a8 },
	{ 0x4d50, 0x84d6 },
	{ 0x4d51, 0x8498 },
	{ 0x4d52, 0x84b6 },
	{ 0x4d53, 0x84cf },
	{ 0x4d54, 0x84a0 },
	{ 0x4d55, 0x84d7 },
	{ 0x4d56, 0x84d4 },
	{ 0x4d57, 0x84d2 },
	{ 0x4d58, 0x84db },
	{ 0x4d59, 0x84b0 },
	{ 0x4d5a, 0x8491 },
	{ 0x4d5b, 0x8661 },
	{ 0x4d5c, 0x8733 },
	{ 0x4d5d, 0x8723 },
	{ 0x4d5e, 0x8728 },
	{ 0x4d5f, 0x876b },
	{ 0x4d60, 0x8740 },
	{ 0x4d61, 0x872e },
	{ 0x4d62, 0x871e },
	{ 0x4d63, 0x8721 },
	{ 0x4d64, 0x8719 },
	{ 0x4d65, 0x871b },
	{ 0x4d66, 0x8743 },
	{ 0x4d67, 0x872c },
	{ 0x4d68, 0x8741 },
	{ 0x4d69, 0x873e },
	{ 0x4d6a, 0x8746 },
	{ 0x4d6b, 0x8720 },
	{ 0x4d6c, 0x8732 },
	{ 0x4d6d, 0x872a },
	{ 0x4d6e, 0x872d },
	{ 0x4d6f, 0x873c },
	{ 0x4d70, 0x8712 },
	{ 0x4d71, 0x873a },
	{ 0x4d72, 0x8731 },
	{ 0x4d73, 0x8735 },
	{ 0x4d74, 0x8742 },
	{ 0x4d75, 0x8726 },
	{ 0x4d76, 0x8727 },
	{ 0x4d77, 0x8738 },
	{ 0x4d78, 0x8724 },
	{ 0x4d79, 0x871a },
	{ 0x4d7a, 0x8730 },
	{ 0x4d7b, 0x8711 },
	{ 0x4d7c, 0x88f7 },
	{ 0x4d7d, 0x88e7 },
	{ 0x4d7e, 0x88f1 },
	{ 0x4e21, 0x88f2 },
	{ 0x4e22, 0x88fa },
	{ 0x4e23, 0x88fe },
	{ 0x4e24, 0x88ee },
	{ 0x4e25, 0x88fc },
	{ 0x4e26, 0x88f6 },
	{ 0x4e27, 0x88fb },
	{ 0x4e28, 0x88f0 },
	{ 0x4e29, 0x88ec },
	{ 0x4e2a, 0x88eb },
	{ 0x4e2b, 0x899d },
	{ 0x4e2c, 0x89a1 },
	{ 0x4e2d, 0x899f },
	{ 0x4e2e, 0x899e },
	{ 0x4e2f, 0x89e9 },
	{ 0x4e30, 0x89eb },
	{ 0x4e31, 0x89e8 },
	{ 0x4e32, 0x8aab },
	{ 0x4e33, 0x8a99 },
	{ 0x4e34, 0x8a8b },
	{ 0x4e35, 0x8a92 },
	{ 0x4e36, 0x8a8f },
	{ 0x4e37, 0x8a96 },
	{ 0x4e38, 0x8c3d },
	{ 0x4e39, 0x8c68 },
	{ 0x4e3a, 0x8c69 },
	{ 0x4e3b, 0x8cd5 },
	{ 0x4e3c, 0x8ccf },
	{ 0x4e3d, 0x8cd7 },
	{ 0x4e3e, 0x8d96 },
	{ 0x4e3f, 0x8e09 },
	{ 0x4e40, 0x8e02 },
	{ 0x4e41, 0x8dff },
	{ 0x4e42, 0x8e0d },
	{ 0x4e43, 0x8dfd },
	{ 0x4e44, 0x8e0a },
	{ 0x4e45, 0x8e03 },
	{ 0x4e46, 0x8e07 },
	{ 0x4e47, 0x8e06 },
	{ 0x4e48, 0x8e05 },
	{ 0x4e49, 0x8dfe },
	{ 0x4e4a, 0x8e00 },
	{ 0x4e4b, 0x8e04 },
	{ 0x4e4c, 0x8f10 },
	{ 0x4e4d, 0x8f11 },
	{ 0x4e4e, 0x8f0e },
	{ 0x4e4f, 0x8f0d },
	{ 0x4e50, 0x9123 },
	{ 0x4e51, 0x911c },
	{ 0x4e52, 0x9120 },
	{ 0x4e53, 0x9122 },
	{ 0x4e54, 0x911f },
	{ 0x4e55, 0x911d },
	{ 0x4e56, 0x911a },
	{ 0x4e57, 0x9124 },
	{ 0x4e58, 0x9121 },
	{ 0x4e59, 0x911b },
	{ 0x4e5a, 0x917a },
	{ 0x4e5b, 0x9172 },
	{ 0x4e5c, 0x9179 },
	{ 0x4e5d, 0x9173 },
	{ 0x4e5e, 0x92a5 },
	{ 0x4e5f, 0x92a4 },
	{ 0x4e60, 0x9276 },
	{ 0x4e61, 0x929b },
	{ 0x4e62, 0x927a },
	{ 0x4e63, 0x92a0 },
	{ 0x4e64, 0x9294 },
	{ 0x4e65, 0x92aa },
	{ 0x4e66, 0x928d },
	{ 0x4e67, 0x92a6 },
	{ 0x4e68, 0x929a },
	{ 0x4e69, 0x92ab },
	{ 0x4e6a, 0x9279 },
	{ 0x4e6b, 0x9297 },
	{ 0x4e6c, 0x927f },
	{ 0x4e6d, 0x92a3 },
	{ 0x4e6e, 0x92ee },
	{ 0x4e6f, 0x928e },
	{ 0x4e70, 0x9282 },
	{ 0x4e71, 0x9295 },
	{ 0x4e72, 0x92a2 },
	{ 0x4e73, 0x927d },
	{ 0x4e74, 0x9288 },
	{ 0x4e75, 0x92a1 },
	{ 0x4e76, 0x928a },
	{ 0x4e77, 0x9286 },
	{ 0x4e78, 0x928c },
	{ 0x4e79, 0x9299 },
	{ 0x4e7a, 0x92a7 },
	{ 0x4e7b, 0x927e },
	{ 0x4e7c, 0x9287 },
	{ 0x4e7d, 0x92a9 },
	{ 0x4e7e, 0x929d },
	{ 0x4f21, 0x928b },
	{ 0x4f22, 0x922d },
	{ 0x4f23, 0x969e },
	{ 0x4f24, 0x96a1 },
	{ 0x4f25, 0x96ff },
	{ 0x4f26, 0x9758 },
	{ 0x4f27, 0x977d },
	{ 0x4f28, 0x977a },
	{ 0x4f29, 0x977e },
	{ 0x4f2a, 0x9783 },
	{ 0x4f2b, 0x9780 },
	{ 0x4f2c, 0x9782 },
	{ 0x4f2d, 0x977b },
	{ 0x4f2e, 0x9784 },
	{ 0x4f2f, 0x9781 },
	{ 0x4f30, 0x977f },
	{ 0x4f31, 0x97ce },
	{ 0x4f32, 0x97cd },
	{ 0x4f33, 0x9816 },
	{ 0x4f34, 0x98ad },
	{ 0x4f35, 0x98ae },
	{ 0x4f36, 0x9902 },
	{ 0x4f37, 0x9900 },
	{ 0x4f38, 0x9907 },
	{ 0x4f39, 0x999d },
	{ 0x4f3a, 0x999c },
	{ 0x4f3b, 0x99c3 },
	{ 0x4f3c, 0x99b9 },
	{ 0x4f3d, 0x99bb },
	{ 0x4f3e, 0x99ba },
	{ 0x4f3f, 0x99c2 },
	{ 0x4f40, 0x99bd },
	{ 0x4f41, 0x99c7 },
	{ 0x4f42, 0x9ab1 },
	{ 0x4f43, 0x9ae3 },
	{ 0x4f44, 0x9ae7 },
	{ 0x4f45, 0x9b3e },
	{ 0x4f46, 0x9b3f },
	{ 0x4f47, 0x9b60 },
	{ 0x4f48, 0x9b61 },
	{ 0x4f49, 0x9b5f },
	{ 0x4f4a, 0x9cf1 },
	{ 0x4f4b, 0x9cf2 },
	{ 0x4f4c, 0x9cf5 },
	{ 0x4f4d, 0x9ea7 },
	{ 0x4f4e, 0x50ff },
	{ 0x4f4f, 0x5103 },
	{ 0x4f50, 0x5130 },
	{ 0x4f51, 0x50f8 },
	{ 0x4f52, 0x5106 },
	{ 0x4f53, 0x5107 },
	{ 0x4f54, 0x50f6 },
	{ 0x4f55, 0x50fe },
	{ 0x4f56, 0x510b },
	{ 0x4f57, 0x510c },
	{ 0x4f58, 0x50fd },
	{ 0x4f59, 0x510a },
	{ 0x4f5a, 0x528b },
	{ 0x4f5b, 0x528c },
	{ 0x4f5c, 0x52f1 },
	{ 0x4f5d, 0x52ef },
	{ 0x4f5e, 0x5648 },
	{ 0x4f5f, 0x5642 },
	{ 0x4f60, 0x564c },
	{ 0x4f61, 0x5635 },
	{ 0x4f62, 0x5641 },
	{ 0x4f63, 0x564a },
	{ 0x4f64, 0x5649 },
	{ 0x4f65, 0x5646 },
	{ 0x4f66, 0x5658 },
	{ 0x4f67, 0x565a },
	{ 0x4f68, 0x5640 },
	{ 0x4f69, 0x5633 },
	{ 0x4f6a, 0x563d },
	{ 0x4f6b, 0x562c },
	{ 0x4f6c, 0x563e },
	{ 0x4f6d, 0x5638 },
	{ 0x4f6e, 0x562a },
	{ 0x4f6f, 0x563a },
	{ 0x4f70, 0x571a },
	{ 0x4f71, 0x58ab },
	{ 0x4f72, 0x589d },
	{ 0x4f73, 0x58b1 },
	{ 0x4f74, 0x58a0 },
	{ 0x4f75, 0x58a3 },
	{ 0x4f76, 0x58af },
	{ 0x4f77, 0x58ac },
	{ 0x4f78, 0x58a5 },
	{ 0x4f79, 0x58a1 },
	{ 0x4f7a, 0x58ff },
	{ 0x4f7b, 0x5aff },
	{ 0x4f7c, 0x5af4 },
	{ 0x4f7d, 0x5afd },
	{ 0x4f7e, 0x5af7 },
	{ 0x5021, 0x5af6 },
	{ 0x5022, 0x5b03 },
	{ 0x5023, 0x5af8 },
	{ 0x5024, 0x5b02 },
	{ 0x5025, 0x5af9 },
	{ 0x5026, 0x5b01 },
	{ 0x5027, 0x5b07 },
	{ 0x5028, 0x5b05 },
	{ 0x5029, 0x5b0f },
	{ 0x502a, 0x5c67 },
	{ 0x502b, 0x5d99 },
	{ 0x502c, 0x5d97 },
	{ 0x502d, 0x5d9f },
	{ 0x502e, 0x5d92 },
	{ 0x502f, 0x5da2 },
	{ 0x5030, 0x5d93 },
	{ 0x5031, 0x5d95 },
	{ 0x5032, 0x5da0 },
	{ 0x5033, 0x5d9c },
	{ 0x5034, 0x5da1 },
	{ 0x5035, 0x5d9a },
	{ 0x5036, 0x5d9e },
	{ 0x5037, 0x5e69 },
	{ 0x5038, 0x5e5d },
	{ 0x5039, 0x5e60 },
	{ 0x503a, 0x5e5c },
	{ 0x503b, 0x7df3 },
	{ 0x503c, 0x5edb },
	{ 0x503d, 0x5ede },
	{ 0x503e, 0x5ee1 },
	{ 0x503f, 0x5f49 },
	{ 0x5040, 0x5fb2 },
	{ 0x5041, 0x618b },
	{ 0x5042, 0x6183 },
	{ 0x5043, 0x6179 },
	{ 0x5044, 0x61b1 },
	{ 0x5045, 0x61b0 },
	{ 0x5046, 0x61a2 },
	{ 0x5047, 0x6189 },
	{ 0x5048, 0x619b },
	{ 0x5049, 0x6193 },
	{ 0x504a, 0x61af },
	{ 0x504b, 0x61ad },
	{ 0x504c, 0x619f },
	{ 0x504d, 0x6192 },
	{ 0x504e, 0x61aa },
	{ 0x504f, 0x61a1 },
	{ 0x5050, 0x618d },
	{ 0x5051, 0x6166 },
	{ 0x5052, 0x61b3 },
	{ 0x5053, 0x622d },
	{ 0x5054, 0x646e },
	{ 0x5055, 0x6470 },
	{ 0x5056, 0x6496 },
	{ 0x5057, 0x64a0 },
	{ 0x5058, 0x6485 },
	{ 0x5059, 0x6497 },
	{ 0x505a, 0x649c },
	{ 0x505b, 0x648f },
	{ 0x505c, 0x648b },
	{ 0x505d, 0x648a },
	{ 0x505e, 0x648c },
	{ 0x505f, 0x64a3 },
	{ 0x5060, 0x649f },
	{ 0x5061, 0x6468 },
	{ 0x5062, 0x64b1 },
	{ 0x5063, 0x6498 },
	{ 0x5064, 0x6576 },
	{ 0x5065, 0x657a },
	{ 0x5066, 0x6579 },
	{ 0x5067, 0x657b },
	{ 0x5068, 0x65b2 },
	{ 0x5069, 0x65b3 },
	{ 0x506a, 0x66b5 },
	{ 0x506b, 0x66b0 },
	{ 0x506c, 0x66a9 },
	{ 0x506d, 0x66b2 },
	{ 0x506e, 0x66b7 },
	{ 0x506f, 0x66aa },
	{ 0x5070, 0x66af },
	{ 0x5071, 0x6a00 },
	{ 0x5072, 0x6a06 },
	{ 0x5073, 0x6a17 },
	{ 0x5074, 0x69e5 },
	{ 0x5075, 0x69f8 },
	{ 0x5076, 0x6a15 },
	{ 0x5077, 0x69f1 },
	{ 0x5078, 0x69e4 },
	{ 0x5079, 0x6a20 },
	{ 0x507a, 0x69ff },
	{ 0x507b, 0x69ec },
	{ 0x507c, 0x69e2 },
	{ 0x507d, 0x6a1b },
	{ 0x507e, 0x6a1d },
	{ 0x5121, 0x69fe },
	{ 0x5122, 0x6a27 },
	{ 0x5123, 0x69f2 },
	{ 0x5124, 0x69ee },
	{ 0x5125, 0x6a14 },
	{ 0x5126, 0x69f7 },
	{ 0x5127, 0x69e7 },
	{ 0x5128, 0x6a40 },
	{ 0x5129, 0x6a08 },
	{ 0x512a, 0x69e6 },
	{ 0x512b, 0x69fb },
	{ 0x512c, 0x6a0d },
	{ 0x512d, 0x69fc },
	{ 0x512e, 0x69eb },
	{ 0x512f, 0x6a09 },
	{ 0x5130, 0x6a04 },
	{ 0x5131, 0x6a18 },
	{ 0x5132, 0x6a25 },
	{ 0x5133, 0x6a0f },
	{ 0x5134, 0x69f6 },
	{ 0x5135, 0x6a26 },
	{ 0x5136, 0x6a07 },
	{ 0x5137, 0x69f4 },
	{ 0x5138, 0x6a16 },
	{ 0x5139, 0x6b51 },
	{ 0x513a, 0x6ba5 },
	{ 0x513b, 0x6ba3 },
	{ 0x513c, 0x6ba2 },
	{ 0x513d, 0x6ba6 },
	{ 0x513e, 0x6c01 },
	{ 0x513f, 0x6c00 },
	{ 0x5140, 0x6bff },
	{ 0x5141, 0x6c02 },
	{ 0x5142, 0x6f41 },
	{ 0x5143, 0x6f26 },
	{ 0x5144, 0x6f7e },
	{ 0x5145, 0x6f87 },
	{ 0x5146, 0x6fc6 },
	{ 0x5147, 0x6f92 },
	{ 0x5148, 0x6f8d },
	{ 0x5149, 0x6f89 },
	{ 0x514a, 0x6f8c },
	{ 0x514b, 0x6f62 },
	{ 0x514c, 0x6f4f },
	{ 0x514d, 0x6f85 },
	{ 0x514e, 0x6f5a },
	{ 0x514f, 0x6f96 },
	{ 0x5150, 0x6f76 },
	{ 0x5151, 0x6f6c },
	{ 0x5152, 0x6f82 },
	{ 0x5153, 0x6f55 },
	{ 0x5154, 0x6f72 },
	{ 0x5155, 0x6f52 },
	{ 0x5156, 0x6f50 },
	{ 0x5157, 0x6f57 },
	{ 0x5158, 0x6f94 },
	{ 0x5159, 0x6f93 },
	{ 0x515a, 0x6f5d },
	{ 0x515b, 0x6f00 },
	{ 0x515c, 0x6f61 },
	{ 0x515d, 0x6f6b },
	{ 0x515e, 0x6f7d },
	{ 0x515f, 0x6f67 },
	{ 0x5160, 0x6f90 },
	{ 0x5161, 0x6f53 },
	{ 0x5162, 0x6f8b },
	{ 0x5163, 0x6f69 },
	{ 0x5164, 0x6f7f },
	{ 0x5165, 0x6f95 },
	{ 0x5166, 0x6f63 },
	{ 0x5167, 0x6f77 },
	{ 0x5168, 0x6f6a },
	{ 0x5169, 0x6f7b },
	{ 0x516a, 0x71b2 },
	{ 0x516b, 0x71af },
	{ 0x516c, 0x719b },
	{ 0x516d, 0x71b0 },
	{ 0x516e, 0x71a0 },
	{ 0x516f, 0x719a },
	{ 0x5170, 0x71a9 },
	{ 0x5171, 0x71b5 },
	{ 0x5172, 0x719d },
	{ 0x5173, 0x71a5 },
	{ 0x5174, 0x719e },
	{ 0x5175, 0x71a4 },
	{ 0x5176, 0x71a1 },
	{ 0x5177, 0x71aa },
	{ 0x5178, 0x719c },
	{ 0x5179, 0x71a7 },
	{ 0x517a, 0x71b3 },
	{ 0x517b, 0x7298 },
	{ 0x517c, 0x729a },
	{ 0x517d, 0x7358 },
	{ 0x517e, 0x7352 },
	{ 0x5221, 0x735e },
	{ 0x5222, 0x735f },
	{ 0x5223, 0x7360 },
	{ 0x5224, 0x735d },
	{ 0x5225, 0x735b },
	{ 0x5226, 0x7361 },
	{ 0x5227, 0x735a },
	{ 0x5228, 0x7359 },
	{ 0x5229, 0x7362 },
	{ 0x522a, 0x7487 },
	{ 0x522b, 0x7489 },
	{ 0x522c, 0x748a },
	{ 0x522d, 0x7486 },
	{ 0x522e, 0x7481 },
	{ 0x522f, 0x747d },
	{ 0x5230, 0x7485 },
	{ 0x5231, 0x7488 },
	{ 0x5232, 0x747c },
	{ 0x5233, 0x7479 },
	{ 0x5234, 0x7508 },
	{ 0x5235, 0x7507 },
	{ 0x5236, 0x757e },
	{ 0x5237, 0x7625 },
	{ 0x5238, 0x761e },
	{ 0x5239, 0x7619 },
	{ 0x523a, 0x761d },
	{ 0x523b, 0x761c },
	{ 0x523c, 0x7623 },
	{ 0x523d, 0x761a },
	{ 0x523e, 0x7628 },
	{ 0x523f, 0x761b },
	{ 0x5240, 0x769c },
	{ 0x5241, 0x769d },
	{ 0x5242, 0x769e },
	{ 0x5243, 0x769b },
	{ 0x5244, 0x778d },
	{ 0x5245, 0x778f },
	{ 0x5246, 0x7789 },
	{ 0x5247, 0x7788 },
	{ 0x5248, 0x78cd },
	{ 0x5249, 0x78bb },
	{ 0x524a, 0x78cf },
	{ 0x524b, 0x78cc },
	{ 0x524c, 0x78d1 },
	{ 0x524d, 0x78ce },
	{ 0x524e, 0x78d4 },
	{ 0x524f, 0x78c8 },
	{ 0x5250, 0x78c3 },
	{ 0x5251, 0x78c4 },
	{ 0x5252, 0x78c9 },
	{ 0x5253, 0x799a },
	{ 0x5254, 0x79a1 },
	{ 0x5255, 0x79a0 },
	{ 0x5256, 0x799c },
	{ 0x5257, 0x79a2 },
	{ 0x5258, 0x799b },
	{ 0x5259, 0x6b76 },
	{ 0x525a, 0x7a39 },
	{ 0x525b, 0x7ab2 },
	{ 0x525c, 0x7ab4 },
	{ 0x525d, 0x7ab3 },
	{ 0x525e, 0x7bb7 },
	{ 0x525f, 0x7bcb },
	{ 0x5260, 0x7bbe },
	{ 0x5261, 0x7bac },
	{ 0x5262, 0x7bce },
	{ 0x5263, 0x7baf },
	{ 0x5264, 0x7bb9 },
	{ 0x5265, 0x7bca },
	{ 0x5266, 0x7bb5 },
	{ 0x5267, 0x7cc5 },
	{ 0x5268, 0x7cc8 },
	{ 0x5269, 0x7ccc },
	{ 0x526a, 0x7ccb },
	{ 0x526b, 0x7df7 },
	{ 0x526c, 0x7ddb },
	{ 0x526d, 0x7dea },
	{ 0x526e, 0x7de7 },
	{ 0x526f, 0x7dd7 },
	{ 0x5270, 0x7de1 },
	{ 0x5271, 0x7e03 },
	{ 0x5272, 0x7dfa },
	{ 0x5273, 0x7de6 },
	{ 0x5274, 0x7df6 },
	{ 0x5275, 0x7df1 },
	{ 0x5276, 0x7df0 },
	{ 0x5277, 0x7dee },
	{ 0x5278, 0x7ddf },
	{ 0x5279, 0x7f76 },
	{ 0x527a, 0x7fac },
	{ 0x527b, 0x7fb0 },
	{ 0x527c, 0x7fad },
	{ 0x527d, 0x7fed },
	{ 0x527e, 0x7feb },
	{ 0x5321, 0x7fea },
	{ 0x5322, 0x7fec },
	{ 0x5323, 0x7fe6 },
	{ 0x5324, 0x7fe8 },
	{ 0x5325, 0x8064 },
	{ 0x5326, 0x8067 },
	{ 0x5327, 0x81a3 },
	{ 0x5328, 0x819f },
	{ 0x5329, 0x819e },
	{ 0x532a, 0x8195 },
	{ 0x532b, 0x81a2 },
	{ 0x532c, 0x8199 },
	{ 0x532d, 0x8197 },
	{ 0x532e, 0x8216 },
	{ 0x532f, 0x824f },
	{ 0x5330, 0x8253 },
	{ 0x5331, 0x8252 },
	{ 0x5332, 0x8250 },
	{ 0x5333, 0x824e },
	{ 0x5334, 0x8251 },
	{ 0x5335, 0x8524 },
	{ 0x5336, 0x853b },
	{ 0x5337, 0x850f },
	{ 0x5338, 0x8500 },
	{ 0x5339, 0x8529 },
	{ 0x533a, 0x850e },
	{ 0x533b, 0x8509 },
	{ 0x533c, 0x850d },
	{ 0x533d, 0x851f },
	{ 0x533e, 0x850a },
	{ 0x533f, 0x8527 },
	{ 0x5340, 0x851c },
	{ 0x5341, 0x84fb },
	{ 0x5342, 0x852b },
	{ 0x5343, 0x84fa },
	{ 0x5344, 0x8508 },
	{ 0x5345, 0x850c },
	{ 0x5346, 0x84f4 },
	{ 0x5347, 0x852a },
	{ 0x5348, 0x84f2 },
	{ 0x5349, 0x8515 },
	{ 0x534a, 0x84f7 },
	{ 0x534b, 0x84eb },
	{ 0x534c, 0x84f3 },
	{ 0x534d, 0x84fc },
	{ 0x534e, 0x8512 },
	{ 0x534f, 0x84ea },
	{ 0x5350, 0x84e9 },
	{ 0x5351, 0x8516 },
	{ 0x5352, 0x84fe },
	{ 0x5353, 0x8528 },
	{ 0x5354, 0x851d },
	{ 0x5355, 0x852e },
	{ 0x5356, 0x8502 },
	{ 0x5357, 0x84fd },
	{ 0x5358, 0x851e },
	{ 0x5359, 0x84f6 },
	{ 0x535a, 0x8531 },
	{ 0x535b, 0x8526 },
	{ 0x535c, 0x84e7 },
	{ 0x535d, 0x84e8 },
	{ 0x535e, 0x84f0 },
	{ 0x535f, 0x84ef },
	{ 0x5360, 0x84f9 },
	{ 0x5361, 0x8518 },
	{ 0x5362, 0x8520 },
	{ 0x5363, 0x8530 },
	{ 0x5364, 0x850b },
	{ 0x5365, 0x8519 },
	{ 0x5366, 0x852f },
	{ 0x5367, 0x8662 },
	{ 0x5368, 0x8756 },
	{ 0x5369, 0x8763 },
	{ 0x536a, 0x8764 },
	{ 0x536b, 0x8777 },
	{ 0x536c, 0x87e1 },
	{ 0x536d, 0x8773 },
	{ 0x536e, 0x8758 },
	{ 0x536f, 0x8754 },
	{ 0x5370, 0x875b },
	{ 0x5371, 0x8752 },
	{ 0x5372, 0x8761 },
	{ 0x5373, 0x875a },
	{ 0x5374, 0x8751 },
	{ 0x5375, 0x875e },
	{ 0x5376, 0x876d },
	{ 0x5377, 0x876a },
	{ 0x5378, 0x8750 },
	{ 0x5379, 0x874e },
	{ 0x537a, 0x875f },
	{ 0x537b, 0x875d },
	{ 0x537c, 0x876f },
	{ 0x537d, 0x876c },
	{ 0x537e, 0x877a },
	{ 0x5421, 0x876e },
	{ 0x5422, 0x875c },
	{ 0x5423, 0x8765 },
	{ 0x5424, 0x874f },
	{ 0x5425, 0x877b },
	{ 0x5426, 0x8775 },
	{ 0x5427, 0x8762 },
	{ 0x5428, 0x8767 },
	{ 0x5429, 0x8769 },
	{ 0x542a, 0x885a },
	{ 0x542b, 0x8905 },
	{ 0x542c, 0x890c },
	{ 0x542d, 0x8914 },
	{ 0x542e, 0x890b },
	{ 0x542f, 0x8917 },
	{ 0x5430, 0x8918 },
	{ 0x5431, 0x8919 },
	{ 0x5432, 0x8906 },
	{ 0x5433, 0x8916 },
	{ 0x5434, 0x8911 },
	{ 0x5435, 0x890e },
	{ 0x5436, 0x8909 },
	{ 0x5437, 0x89a2 },
	{ 0x5438, 0x89a4 },
	{ 0x5439, 0x89a3 },
	{ 0x543a, 0x89ed },
	{ 0x543b, 0x89f0 },
	{ 0x543c, 0x89ec },
	{ 0x543d, 0x8acf },
	{ 0x543e, 0x8ac6 },
	{ 0x543f, 0x8ab8 },
	{ 0x5440, 0x8ad3 },
	{ 0x5441, 0x8ad1 },
	{ 0x5442, 0x8ad4 },
	{ 0x5443, 0x8ad5 },
	{ 0x5444, 0x8abb },
	{ 0x5445, 0x8ad7 },
	{ 0x5446, 0x8abe },
	{ 0x5447, 0x8ac0 },
	{ 0x5448, 0x8ac5 },
	{ 0x5449, 0x8ad8 },
	{ 0x544a, 0x8ac3 },
	{ 0x544b, 0x8aba },
	{ 0x544c, 0x8abd },
	{ 0x544d, 0x8ad9 },
	{ 0x544e, 0x8c3e },
	{ 0x544f, 0x8c4d },
	{ 0x5450, 0x8c8f },
	{ 0x5451, 0x8ce5 },
	{ 0x5452, 0x8cdf },
	{ 0x5453, 0x8cd9 },
	{ 0x5454, 0x8ce8 },
	{ 0x5455, 0x8cda },
	{ 0x5456, 0x8cdd },
	{ 0x5457, 0x8ce7 },
	{ 0x5458, 0x8da0 },
	{ 0x5459, 0x8d9c },
	{ 0x545a, 0x8da1 },
	{ 0x545b, 0x8d9b },
	{ 0x545c, 0x8e20 },
	{ 0x545d, 0x8e23 },
	{ 0x545e, 0x8e25 },
	{ 0x545f, 0x8e24 },
	{ 0x5460, 0x8e2e },
	{ 0x5461, 0x8e15 },
	{ 0x5462, 0x8e1b },
	{ 0x5463, 0x8e16 },
	{ 0x5464, 0x8e11 },
	{ 0x5465, 0x8e19 },
	{ 0x5466, 0x8e26 },
	{ 0x5467, 0x8e27 },
	{ 0x5468, 0x8e14 },
	{ 0x5469, 0x8e12 },
	{ 0x546a, 0x8e18 },
	{ 0x546b, 0x8e13 },
	{ 0x546c, 0x8e1c },
	{ 0x546d, 0x8e17 },
	{ 0x546e, 0x8e1a },
	{ 0x546f, 0x8f2c },
	{ 0x5470, 0x8f24 },
	{ 0x5471, 0x8f18 },
	{ 0x5472, 0x8f1a },
	{ 0x5473, 0x8f20 },
	{ 0x5474, 0x8f23 },
	{ 0x5475, 0x8f16 },
	{ 0x5476, 0x8f17 },
	{ 0x5477, 0x9073 },
	{ 0x5478, 0x9070 },
	{ 0x5479, 0x906f },
	{ 0x547a, 0x9067 },
	{ 0x547b, 0x906b },
	{ 0x547c, 0x912f },
	{ 0x547d, 0x912b },
	{ 0x547e, 0x9129 },
	{ 0x5521, 0x912a },
	{ 0x5522, 0x9132 },
	{ 0x5523, 0x9126 },
	{ 0x5524, 0x912e },
	{ 0x5525, 0x9185 },
	{ 0x5526, 0x9186 },
	{ 0x5527, 0x918a },
	{ 0x5528, 0x9181 },
	{ 0x5529, 0x9182 },
	{ 0x552a, 0x9184 },
	{ 0x552b, 0x9180 },
	{ 0x552c, 0x92d0 },
	{ 0x552d, 0x92c3 },
	{ 0x552e, 0x92c4 },
	{ 0x552f, 0x92c0 },
	{ 0x5530, 0x92d9 },
	{ 0x5531, 0x92b6 },
	{ 0x5532, 0x92cf },
	{ 0x5533, 0x92f1 },
	{ 0x5534, 0x92df },
	{ 0x5535, 0x92d8 },
	{ 0x5536, 0x92e9 },
	{ 0x5537, 0x92d7 },
	{ 0x5538, 0x92dd },
	{ 0x5539, 0x92cc },
	{ 0x553a, 0x92ef },
	{ 0x553b, 0x92c2 },
	{ 0x553c, 0x92e8 },
	{ 0x553d, 0x92ca },
	{ 0x553e, 0x92c8 },
	{ 0x553f, 0x92ce },
	{ 0x5540, 0x92e6 },
	{ 0x5541, 0x92cd },
	{ 0x5542, 0x92d5 },
	{ 0x5543, 0x92c9 },
	{ 0x5544, 0x92e0 },
	{ 0x5545, 0x92de },
	{ 0x5546, 0x92e7 },
	{ 0x5547, 0x92d1 },
	{ 0x5548, 0x92d3 },
	{ 0x5549, 0x92b5 },
	{ 0x554a, 0x92e1 },
	{ 0x554b, 0x9325 },
	{ 0x554c, 0x92c6 },
	{ 0x554d, 0x92b4 },
	{ 0x554e, 0x957c },
	{ 0x554f, 0x95ac },
	{ 0x5550, 0x95ab },
	{ 0x5551, 0x95ae },
	{ 0x5552, 0x95b0 },
	{ 0x5553, 0x96a4 },
	{ 0x5554, 0x96a2 },
	{ 0x5555, 0x96d3 },
	{ 0x5556, 0x9705 },
	{ 0x5557, 0x9708 },
	{ 0x5558, 0x9702 },
	{ 0x5559, 0x975a },
	{ 0x555a, 0x978a },
	{ 0x555b, 0x978e },
	{ 0x555c, 0x9788 },
	{ 0x555d, 0x97d0 },
	{ 0x555e, 0x97cf },
	{ 0x555f, 0x981e },
	{ 0x5560, 0x981d },
	{ 0x5561, 0x9826 },
	{ 0x5562, 0x9829 },
	{ 0x5563, 0x9828 },
	{ 0x5564, 0x9820 },
	{ 0x5565, 0x981b },
	{ 0x5566, 0x9827 },
	{ 0x5567, 0x98b2 },
	{ 0x5568, 0x9908 },
	{ 0x5569, 0x98fa },
	{ 0x556a, 0x9911 },
	{ 0x556b, 0x9914 },
	{ 0x556c, 0x9916 },
	{ 0x556d, 0x9917 },
	{ 0x556e, 0x9915 },
	{ 0x556f, 0x99dc },
	{ 0x5570, 0x99cd },
	{ 0x5571, 0x99cf },
	{ 0x5572, 0x99d3 },
	{ 0x5573, 0x99d4 },
	{ 0x5574, 0x99ce },
	{ 0x5575, 0x99c9 },
	{ 0x5576, 0x99d6 },
	{ 0x5577, 0x99d8 },
	{ 0x5578, 0x99cb },
	{ 0x5579, 0x99d7 },
	{ 0x557a, 0x99cc },
	{ 0x557b, 0x9ab3 },
	{ 0x557c, 0x9aec },
	{ 0x557d, 0x9aeb },
	{ 0x557e, 0x9af3 },
	{ 0x5621, 0x9af2 },
	{ 0x5622, 0x9af1 },
	{ 0x5623, 0x9b46 },
	{ 0x5624, 0x9b43 },
	{ 0x5625, 0x9b67 },
	{ 0x5626, 0x9b74 },
	{ 0x5627, 0x9b71 },
	{ 0x5628, 0x9b66 },
	{ 0x5629, 0x9b76 },
	{ 0x562a, 0x9b75 },
	{ 0x562b, 0x9b70 },
	{ 0x562c, 0x9b68 },
	{ 0x562d, 0x9b64 },
	{ 0x562e, 0x9b6c },
	{ 0x562f, 0x9cfc },
	{ 0x5630, 0x9cfa },
	{ 0x5631, 0x9cfd },
	{ 0x5632, 0x9cff },
	{ 0x5633, 0x9cf7 },
	{ 0x5634, 0x9d07 },
	{ 0x5635, 0x9d00 },
	{ 0x5636, 0x9cf9 },
	{ 0x5637, 0x9cfb },
	{ 0x5638, 0x9d08 },
	{ 0x5639, 0x9d05 },
	{ 0x563a, 0x9d04 },
	{ 0x563b, 0x9e83 },
	{ 0x563c, 0x9ed3 },
	{ 0x563d, 0x9f0f },
	{ 0x563e, 0x9f10 },
	{ 0x563f, 0x511c },
	{ 0x5640, 0x5113 },
	{ 0x5641, 0x5117 },
	{ 0x5642, 0x511a },
	{ 0x5643, 0x5111 },
	{ 0x5644, 0x51de },
	{ 0x5645, 0x5334 },
	{ 0x5646, 0x53e1 },
	{ 0x5647, 0x5670 },
	{ 0x5648, 0x5660 },
	{ 0x5649, 0x566e },
	{ 0x564a, 0x5673 },
	{ 0x564b, 0x5666 },
	{ 0x564c, 0x5663 },
	{ 0x564d, 0x566d },
	{ 0x564e, 0x5672 },
	{ 0x564f, 0x565e },
	{ 0x5650, 0x5677 },
	{ 0x5651, 0x571c },
	{ 0x5652, 0x571b },
	{ 0x5653, 0x58c8 },
	{ 0x5654, 0x58bd },
	{ 0x5655, 0x58c9 },
	{ 0x5656, 0x58bf },
	{ 0x5657, 0x58ba },
	{ 0x5658, 0x58c2 },
	{ 0x5659, 0x58bc },
	{ 0x565a, 0x58c6 },
	{ 0x565b, 0x5b17 },
	{ 0x565c, 0x5b19 },
	{ 0x565d, 0x5b1b },
	{ 0x565e, 0x5b21 },
	{ 0x565f, 0x5b14 },
	{ 0x5660, 0x5b13 },
	{ 0x5661, 0x5b10 },
	{ 0x5662, 0x5b16 },
	{ 0x5663, 0x5b28 },
	{ 0x5664, 0x5b1a },
	{ 0x5665, 0x5b20 },
	{ 0x5666, 0x5b1e },
	{ 0x5667, 0x5bef },
	{ 0x5668, 0x5dac },
	{ 0x5669, 0x5db1 },
	{ 0x566a, 0x5da9 },
	{ 0x566b, 0x5da7 },
	{ 0x566c, 0x5db5 },
	{ 0x566d, 0x5db0 },
	{ 0x566e, 0x5dae },
	{ 0x566f, 0x5daa },
	{ 0x5670, 0x5da8 },
	{ 0x5671, 0x5db2 },
	{ 0x5672, 0x5dad },
	{ 0x5673, 0x5daf },
	{ 0x5674, 0x5db4 },
	{ 0x5675, 0x5e67 },
	{ 0x5676, 0x5e68 },
	{ 0x5677, 0x5e66 },
	{ 0x5678, 0x5e6f },
	{ 0x5679, 0x5ee9 },
	{ 0x567a, 0x5ee7 },
	{ 0x567b, 0x5ee6 },
	{ 0x567c, 0x5ee8 },
	{ 0x567d, 0x5ee5 },
	{ 0x567e, 0x5f4b },
	{ 0x5721, 0x5fbc },
	{ 0x5722, 0x5fbb },
	{ 0x5723, 0x619d },
	{ 0x5724, 0x61a8 },
	{ 0x5725, 0x6196 },
	{ 0x5726, 0x61c5 },
	{ 0x5727, 0x61b4 },
	{ 0x5728, 0x61c6 },
	{ 0x5729, 0x61c1 },
	{ 0x572a, 0x61cc },
	{ 0x572b, 0x61ba },
	{ 0x572c, 0x61bf },
	{ 0x572d, 0x61b8 },
	{ 0x572e, 0x618c },
	{ 0x572f, 0x64d7 },
	{ 0x5730, 0x64d6 },
	{ 0x5731, 0x64d0 },
	{ 0x5732, 0x64cf },
	{ 0x5733, 0x64c9 },
	{ 0x5734, 0x64bd },
	{ 0x5735, 0x6489 },
	{ 0x5736, 0x64c3 },
	{ 0x5737, 0x64db },
	{ 0x5738, 0x64f3 },
	{ 0x5739, 0x64d9 },
	{ 0x573a, 0x6533 },
	{ 0x573b, 0x657f },
	{ 0x573c, 0x657c },
	{ 0x573d, 0x65a2 },
	{ 0x573e, 0x66c8 },
	{ 0x573f, 0x66be },
	{ 0x5740, 0x66c0 },
	{ 0x5741, 0x66ca },
	{ 0x5742, 0x66cb },
	{ 0x5743, 0x66cf },
	{ 0x5744, 0x66bd },
	{ 0x5745, 0x66bb },
	{ 0x5746, 0x66ba },
	{ 0x5747, 0x66cc },
	{ 0x5748, 0x6723 },
	{ 0x5749, 0x6a34 },
	{ 0x574a, 0x6a66 },
	{ 0x574b, 0x6a49 },
	{ 0x574c, 0x6a67 },
	{ 0x574d, 0x6a32 },
	{ 0x574e, 0x6a68 },
	{ 0x574f, 0x6a3e },
	{ 0x5750, 0x6a5d },
	{ 0x5751, 0x6a6d },
	{ 0x5752, 0x6a76 },
	{ 0x5753, 0x6a5b },
	{ 0x5754, 0x6a51 },
	{ 0x5755, 0x6a28 },
	{ 0x5756, 0x6a5a },
	{ 0x5757, 0x6a3b },
	{ 0x5758, 0x6a3f },
	{ 0x5759, 0x6a41 },
	{ 0x575a, 0x6a6a },
	{ 0x575b, 0x6a64 },
	{ 0x575c, 0x6a50 },
	{ 0x575d, 0x6a4f },
	{ 0x575e, 0x6a54 },
	{ 0x575f, 0x6a6f },
	{ 0x5760, 0x6a69 },
	{ 0x5761, 0x6a60 },
	{ 0x5762, 0x6a3c },
	{ 0x5763, 0x6a5e },
	{ 0x5764, 0x6a56 },
	{ 0x5765, 0x6a55 },
	{ 0x5766, 0x6a4d },
	{ 0x5767, 0x6a4e },
	{ 0x5768, 0x6a46 },
	{ 0x5769, 0x6b55 },
	{ 0x576a, 0x6b54 },
	{ 0x576b, 0x6b56 },
	{ 0x576c, 0x6ba7 },
	{ 0x576d, 0x6baa },
	{ 0x576e, 0x6bab },
	{ 0x576f, 0x6bc8 },
	{ 0x5770, 0x6bc7 },
	{ 0x5771, 0x6c04 },
	{ 0x5772, 0x6c03 },
	{ 0x5773, 0x6c06 },
	{ 0x5774, 0x6fad },
	{ 0x5775, 0x6fcb },
	{ 0x5776, 0x6fa3 },
	{ 0x5777, 0x6fc7 },
	{ 0x5778, 0x6fbc },
	{ 0x5779, 0x6fce },
	{ 0x577a, 0x6fc8 },
	{ 0x577b, 0x6f5e },
	{ 0x577c, 0x6fc4 },
	{ 0x577d, 0x6fbd },
	{ 0x577e, 0x6f9e },
	{ 0x5821, 0x6fca },
	{ 0x5822, 0x6fa8 },
	{ 0x5823, 0x7004 },
	{ 0x5824, 0x6fa5 },
	{ 0x5825, 0x6fae },
	{ 0x5826, 0x6fba },
	{ 0x5827, 0x6fac },
	{ 0x5828, 0x6faa },
	{ 0x5829, 0x6fcf },
	{ 0x582a, 0x6fbf },
	{ 0x582b, 0x6fb8 },
	{ 0x582c, 0x6fa2 },
	{ 0x582d, 0x6fc9 },
	{ 0x582e, 0x6fab },
	{ 0x582f, 0x6fcd },
	{ 0x5830, 0x6faf },
	{ 0x5831, 0x6fb2 },
	{ 0x5832, 0x6fb0 },
	{ 0x5833, 0x71c5 },
	{ 0x5834, 0x71c2 },
	{ 0x5835, 0x71bf },
	{ 0x5836, 0x71b8 },
	{ 0x5837, 0x71d6 },
	{ 0x5838, 0x71c0 },
	{ 0x5839, 0x71c1 },
	{ 0x583a, 0x71cb },
	{ 0x583b, 0x71d4 },
	{ 0x583c, 0x71ca },
	{ 0x583d, 0x71c7 },
	{ 0x583e, 0x71cf },
	{ 0x583f, 0x71bd },
	{ 0x5840, 0x71d8 },
	{ 0x5841, 0x71bc },
	{ 0x5842, 0x71c6 },
	{ 0x5843, 0x71da },
	{ 0x5844, 0x71db },
	{ 0x5845, 0x729d },
	{ 0x5846, 0x729e },
	{ 0x5847, 0x7369 },
	{ 0x5848, 0x7366 },
	{ 0x5849, 0x7367 },
	{ 0x584a, 0x736c },
	{ 0x584b, 0x7365 },
	{ 0x584c, 0x736b },
	{ 0x584d, 0x736a },
	{ 0x584e, 0x747f },
	{ 0x584f, 0x749a },
	{ 0x5850, 0x74a0 },
	{ 0x5851, 0x7494 },
	{ 0x5852, 0x7492 },
	{ 0x5853, 0x7495 },
	{ 0x5854, 0x74a1 },
	{ 0x5855, 0x750b },
	{ 0x5856, 0x7580 },
	{ 0x5857, 0x762f },
	{ 0x5858, 0x762d },
	{ 0x5859, 0x7631 },
	{ 0x585a, 0x763d },
	{ 0x585b, 0x7633 },
	{ 0x585c, 0x763c },
	{ 0x585d, 0x7635 },
	{ 0x585e, 0x7632 },
	{ 0x585f, 0x7630 },
	{ 0x5860, 0x76bb },
	{ 0x5861, 0x76e6 },
	{ 0x5862, 0x779a },
	{ 0x5863, 0x779d },
	{ 0x5864, 0x77a1 },
	{ 0x5865, 0x779c },
	{ 0x5866, 0x779b },
	{ 0x5867, 0x77a2 },
	{ 0x5868, 0x77a3 },
	{ 0x5869, 0x7795 },
	{ 0x586a, 0x7799 },
	{ 0x586b, 0x7797 },
	{ 0x586c, 0x78dd },
	{ 0x586d, 0x78e9 },
	{ 0x586e, 0x78e5 },
	{ 0x586f, 0x78ea },
	{ 0x5870, 0x78de },
	{ 0x5871, 0x78e3 },
	{ 0x5872, 0x78db },
	{ 0x5873, 0x78e1 },
	{ 0x5874, 0x78e2 },
	{ 0x5875, 0x78ed },
	{ 0x5876, 0x78df },
	{ 0x5877, 0x78e0 },
	{ 0x5878, 0x79a4 },
	{ 0x5879, 0x7a44 },
	{ 0x587a, 0x7a48 },
	{ 0x587b, 0x7a47 },
	{ 0x587c, 0x7ab6 },
	{ 0x587d, 0x7ab8 },
	{ 0x587e, 0x7ab5 },
	{ 0x5921, 0x7ab1 },
	{ 0x5922, 0x7ab7 },
	{ 0x5923, 0x7bde },
	{ 0x5924, 0x7be3 },
	{ 0x5925, 0x7be7 },
	{ 0x5926, 0x7bdd },
	{ 0x5927, 0x7bd5 },
	{ 0x5928, 0x7be5 },
	{ 0x5929, 0x7bda },
	{ 0x592a, 0x7be8 },
	{ 0x592b, 0x7bf9 },
	{ 0x592c, 0x7bd4 },
	{ 0x592d, 0x7bea },
	{ 0x592e, 0x7be2 },
	{ 0x592f, 0x7bdc },
	{ 0x5930, 0x7beb },
	{ 0x5931, 0x7bd8 },
	{ 0x5932, 0x7bdf },
	{ 0x5933, 0x7cd2 },
	{ 0x5934, 0x7cd4 },
	{ 0x5935, 0x7cd7 },
	{ 0x5936, 0x7cd0 },
	{ 0x5937, 0x7cd1 },
	{ 0x5938, 0x7e12 },
	{ 0x5939, 0x7e21 },
	{ 0x593a, 0x7e17 },
	{ 0x593b, 0x7e0c },
	{ 0x593c, 0x7e1f },
	{ 0x593d, 0x7e20 },
	{ 0x593e, 0x7e13 },
	{ 0x593f, 0x7e0e },
	{ 0x5940, 0x7e1c },
	{ 0x5941, 0x7e15 },
	{ 0x5942, 0x7e1a },
	{ 0x5943, 0x7e22 },
	{ 0x5944, 0x7e0b },
	{ 0x5945, 0x7e0f },
	{ 0x5946, 0x7e16 },
	{ 0x5947, 0x7e0d },
	{ 0x5948, 0x7e14 },
	{ 0x5949, 0x7e25 },
	{ 0x594a, 0x7e24 },
	{ 0x594b, 0x7f43 },
	{ 0x594c, 0x7f7b },
	{ 0x594d, 0x7f7c },
	{ 0x594e, 0x7f7a },
	{ 0x594f, 0x7fb1 },
	{ 0x5950, 0x7fef },
	{ 0x5951, 0x802a },
	{ 0x5952, 0x8029 },
	{ 0x5953, 0x806c },
	{ 0x5954, 0x81b1 },
	{ 0x5955, 0x81a6 },
	{ 0x5956, 0x81ae },
	{ 0x5957, 0x81b9 },
	{ 0x5958, 0x81b5 },
	{ 0x5959, 0x81ab },
	{ 0x595a, 0x81b0 },
	{ 0x595b, 0x81ac },
	{ 0x595c, 0x81b4 },
	{ 0x595d, 0x81b2 },
	{ 0x595e, 0x81b7 },
	{ 0x595f, 0x81a7 },
	{ 0x5960, 0x81f2 },
	{ 0x5961, 0x8255 },
	{ 0x5962, 0x8256 },
	{ 0x5963, 0x8257 },
	{ 0x5964, 0x8556 },
	{ 0x5965, 0x8545 },
	{ 0x5966, 0x856b },
	{ 0x5967, 0x854d },
	{ 0x5968, 0x8553 },
	{ 0x5969, 0x8561 },
	{ 0x596a, 0x8558 },
	{ 0x596b, 0x8540 },
	{ 0x596c, 0x8546 },
	{ 0x596d, 0x8564 },
	{ 0x596e, 0x8541 },
	{ 0x596f, 0x8562 },
	{ 0x5970, 0x8544 },
	{ 0x5971, 0x8551 },
	{ 0x5972, 0x8547 },
	{ 0x5973, 0x8563 },
	{ 0x5974, 0x853e },
	{ 0x5975, 0x855b },
	{ 0x5976, 0x8571 },
	{ 0x5977, 0x854e },
	{ 0x5978, 0x856e },
	{ 0x5979, 0x8575 },
	{ 0x597a, 0x8555 },
	{ 0x597b, 0x8567 },
	{ 0x597c, 0x8560 },
	{ 0x597d, 0x858c },
	{ 0x597e, 0x8566 },
	{ 0x5a21, 0x855d },
	{ 0x5a22, 0x8554 },
	{ 0x5a23, 0x8565 },
	{ 0x5a24, 0x856c },
	{ 0x5a25, 0x8663 },
	{ 0x5a26, 0x8665 },
	{ 0x5a27, 0x8664 },
	{ 0x5a28, 0x87a4 },
	{ 0x5a29, 0x879b },
	{ 0x5a2a, 0x878f },
	{ 0x5a2b, 0x8797 },
	{ 0x5a2c, 0x8793 },
	{ 0x5a2d, 0x8792 },
	{ 0x5a2e, 0x8788 },
	{ 0x5a2f, 0x8781 },
	{ 0x5a30, 0x8796 },
	{ 0x5a31, 0x8798 },
	{ 0x5a32, 0x8779 },
	{ 0x5a33, 0x8787 },
	{ 0x5a34, 0x87a3 },
	{ 0x5a35, 0x8785 },
	{ 0x5a36, 0x8790 },
	{ 0x5a37, 0x8791 },
	{ 0x5a38, 0x879d },
	{ 0x5a39, 0x8784 },
	{ 0x5a3a, 0x8794 },
	{ 0x5a3b, 0x879c },
	{ 0x5a3c, 0x879a },
	{ 0x5a3d, 0x8789 },
	{ 0x5a3e, 0x891e },
	{ 0x5a3f, 0x8926 },
	{ 0x5a40, 0x8930 },
	{ 0x5a41, 0x892d },
	{ 0x5a42, 0x892e },
	{ 0x5a43, 0x8927 },
	{ 0x5a44, 0x8931 },
	{ 0x5a45, 0x8922 },
	{ 0x5a46, 0x8929 },
	{ 0x5a47, 0x8923 },
	{ 0x5a48, 0x892f },
	{ 0x5a49, 0x892c },
	{ 0x5a4a, 0x891f },
	{ 0x5a4b, 0x89f1 },
	{ 0x5a4c, 0x8ae0 },
	{ 0x5a4d, 0x8ae2 },
	{ 0x5a4e, 0x8af2 },
	{ 0x5a4f, 0x8af4 },
	{ 0x5a50, 0x8af5 },
	{ 0x5a51, 0x8add },
	{ 0x5a52, 0x8b14 },
	{ 0x5a53, 0x8ae4 },
	{ 0x5a54, 0x8adf },
	{ 0x5a55, 0x8af0 },
	{ 0x5a56, 0x8ac8 },
	{ 0x5a57, 0x8ade },
	{ 0x5a58, 0x8ae1 },
	{ 0x5a59, 0x8ae8 },
	{ 0x5a5a, 0x8aff },
	{ 0x5a5b, 0x8aef },
	{ 0x5a5c, 0x8afb },
	{ 0x5a5d, 0x8c91 },
	{ 0x5a5e, 0x8c92 },
	{ 0x5a5f, 0x8c90 },
	{ 0x5a60, 0x8cf5 },
	{ 0x5a61, 0x8cee },
	{ 0x5a62, 0x8cf1 },
	{ 0x5a63, 0x8cf0 },
	{ 0x5a64, 0x8cf3 },
	{ 0x5a65, 0x8d6c },
	{ 0x5a66, 0x8d6e },
	{ 0x5a67, 0x8da5 },
	{ 0x5a68, 0x8da7 },
	{ 0x5a69, 0x8e33 },
	{ 0x5a6a, 0x8e3e },
	{ 0x5a6b, 0x8e38 },
	{ 0x5a6c, 0x8e40 },
	{ 0x5a6d, 0x8e45 },
	{ 0x5a6e, 0x8e36 },
	{ 0x5a6f, 0x8e3c },
	{ 0x5a70, 0x8e3d },
	{ 0x5a71, 0x8e41 },
	{ 0x5a72, 0x8e30 },
	{ 0x5a73, 0x8e3f },
	{ 0x5a74, 0x8ebd },
	{ 0x5a75, 0x8f36 },
	{ 0x5a76, 0x8f2e },
	{ 0x5a77, 0x8f35 },
	{ 0x5a78, 0x8f32 },
	{ 0x5a79, 0x8f39 },
	{ 0x5a7a, 0x8f37 },
	{ 0x5a7b, 0x8f34 },
	{ 0x5a7c, 0x9076 },
	{ 0x5a7d, 0x9079 },
	{ 0x5a7e, 0x907b },
	{ 0x5b21, 0x9086 },
	{ 0x5b22, 0x90fa },
	{ 0x5b23, 0x9133 },
	{ 0x5b24, 0x9135 },
	{ 0x5b25, 0x9136 },
	{ 0x5b26, 0x9193 },
	{ 0x5b27, 0x9190 },
	{ 0x5b28, 0x9191 },
	{ 0x5b29, 0x918d },
	{ 0x5b2a, 0x918f },
	{ 0x5b2b, 0x9327 },
	{ 0x5b2c, 0x931e },
	{ 0x5b2d, 0x9308 },
	{ 0x5b2e, 0x931f },
	{ 0x5b2f, 0x9306 },
	{ 0x5b30, 0x930f },
	{ 0x5b31, 0x937a },
	{ 0x5b32, 0x9338 },
	{ 0x5b33, 0x933c },
	{ 0x5b34, 0x931b },
	{ 0x5b35, 0x9323 },
	{ 0x5b36, 0x9312 },
	{ 0x5b37, 0x9301 },
	{ 0x5b38, 0x9346 },
	{ 0x5b39, 0x932d },
	{ 0x5b3a, 0x930e },
	{ 0x5b3b, 0x930d },
	{ 0x5b3c, 0x92cb },
	{ 0x5b3d, 0x931d },
	{ 0x5b3e, 0x92fa },
	{ 0x5b3f, 0x9313 },
	{ 0x5b40, 0x92f9 },
	{ 0x5b41, 0x92f7 },
	{ 0x5b42, 0x9334 },
	{ 0x5b43, 0x9302 },
	{ 0x5b44, 0x9324 },
	{ 0x5b45, 0x92ff },
	{ 0x5b46, 0x9329 },
	{ 0x5b47, 0x9339 },
	{ 0x5b48, 0x9335 },
	{ 0x5b49, 0x932a },
	{ 0x5b4a, 0x9314 },
	{ 0x5b4b, 0x930c },
	{ 0x5b4c, 0x930b },
	{ 0x5b4d, 0x92fe },
	{ 0x5b4e, 0x9309 },
	{ 0x5b4f, 0x9300 },
	{ 0x5b50, 0x92fb },
	{ 0x5b51, 0x9316 },
	{ 0x5b52, 0x95bc },
	{ 0x5b53, 0x95cd },
	{ 0x5b54, 0x95be },
	{ 0x5b55, 0x95b9 },
	{ 0x5b56, 0x95ba },
	{ 0x5b57, 0x95b6 },
	{ 0x5b58, 0x95bf },
	{ 0x5b59, 0x95b5 },
	{ 0x5b5a, 0x95bd },
	{ 0x5b5b, 0x96a9 },
	{ 0x5b5c, 0x96d4 },
	{ 0x5b5d, 0x970b },
	{ 0x5b5e, 0x9712 },
	{ 0x5b5f, 0x9710 },
	{ 0x5b60, 0x9799 },
	{ 0x5b61, 0x9797 },
	{ 0x5b62, 0x9794 },
	{ 0x5b63, 0x97f0 },
	{ 0x5b64, 0x97f8 },
	{ 0x5b65, 0x9835 },
	{ 0x5b66, 0x982f },
	{ 0x5b67, 0x9832 },
	{ 0x5b68, 0x9924 },
	{ 0x5b69, 0x991f },
	{ 0x5b6a, 0x9927 },
	{ 0x5b6b, 0x9929 },
	{ 0x5b6c, 0x999e },
	{ 0x5b6d, 0x99ee },
	{ 0x5b6e, 0x99ec },
	{ 0x5b6f, 0x99e5 },
	{ 0x5b70, 0x99e4 },
	{ 0x5b71, 0x99f0 },
	{ 0x5b72, 0x99e3 },
	{ 0x5b73, 0x99ea },
	{ 0x5b74, 0x99e9 },
	{ 0x5b75, 0x99e7 },
	{ 0x5b76, 0x9ab9 },
	{ 0x5b77, 0x9abf },
	{ 0x5b78, 0x9ab4 },
	{ 0x5b79, 0x9abb },
	{ 0x5b7a, 0x9af6 },
	{ 0x5b7b, 0x9afa },
	{ 0x5b7c, 0x9af9 },
	{ 0x5b7d, 0x9af7 },
	{ 0x5b7e, 0x9b33 },
	{ 0x5c21, 0x9b80 },
	{ 0x5c22, 0x9b85 },
	{ 0x5c23, 0x9b87 },
	{ 0x5c24, 0x9b7c },
	{ 0x5c25, 0x9b7e },
	{ 0x5c26, 0x9b7b },
	{ 0x5c27, 0x9b82 },
	{ 0x5c28, 0x9b93 },
	{ 0x5c29, 0x9b92 },
	{ 0x5c2a, 0x9b90 },
	{ 0x5c2b, 0x9b7a },
	{ 0x5c2c, 0x9b95 },
	{ 0x5c2d, 0x9b7d },
	{ 0x5c2e, 0x9b88 },
	{ 0x5c2f, 0x9d25 },
	{ 0x5c30, 0x9d17 },
	{ 0x5c31, 0x9d20 },
	{ 0x5c32, 0x9d1e },
	{ 0x5c33, 0x9d14 },
	{ 0x5c34, 0x9d29 },
	{ 0x5c35, 0x9d1d },
	{ 0x5c36, 0x9d18 },
	{ 0x5c37, 0x9d22 },
	{ 0x5c38, 0x9d10 },
	{ 0x5c39, 0x9d19 },
	{ 0x5c3a, 0x9d1f },
	{ 0x5c3b, 0x9e88 },
	{ 0x5c3c, 0x9e86 },
	{ 0x5c3d, 0x9e87 },
	{ 0x5c3e, 0x9eae },
	{ 0x5c3f, 0x9ead },
	{ 0x5c40, 0x9ed5 },
	{ 0x5c41, 0x9ed6 },
	{ 0x5c42, 0x9efa },
	{ 0x5c43, 0x9f12 },
	{ 0x5c44, 0x9f3d },
	{ 0x5c45, 0x5126 },
	{ 0x5c46, 0x5125 },
	{ 0x5c47, 0x5122 },
	{ 0x5c48, 0x5124 },
	{ 0x5c49, 0x5120 },
	{ 0x5c4a, 0x5129 },
	{ 0x5c4b, 0x52f4 },
	{ 0x5c4c, 0x5693 },
	{ 0x5c4d, 0x568c },
	{ 0x5c4e, 0x568d },
	{ 0x5c4f, 0x5686 },
	{ 0x5c50, 0x5684 },
	{ 0x5c51, 0x5683 },
	{ 0x5c52, 0x567e },
	{ 0x5c53, 0x5682 },
	{ 0x5c54, 0x567f },
	{ 0x5c55, 0x5681 },
	{ 0x5c56, 0x58d6 },
	{ 0x5c57, 0x58d4 },
	{ 0x5c58, 0x58cf },
	{ 0x5c59, 0x58d2 },
	{ 0x5c5a, 0x5b2d },
	{ 0x5c5b, 0x5b25 },
	{ 0x5c5c, 0x5b32 },
	{ 0x5c5d, 0x5b23 },
	{ 0x5c5e, 0x5b2c },
	{ 0x5c5f, 0x5b27 },
	{ 0x5c60, 0x5b26 },
	{ 0x5c61, 0x5b2f },
	{ 0x5c62, 0x5b2e },
	{ 0x5c63, 0x5b7b },
	{ 0x5c64, 0x5bf1 },
	{ 0x5c65, 0x5bf2 },
	{ 0x5c66, 0x5db7 },
	{ 0x5c67, 0x5e6c },
	{ 0x5c68, 0x5e6a },
	{ 0x5c69, 0x5fbe },
	{ 0x5c6a, 0x61c3 },
	{ 0x5c6b, 0x61b5 },
	{ 0x5c6c, 0x61bc },
	{ 0x5c6d, 0x61e7 },
	{ 0x5c6e, 0x61e0 },
	{ 0x5c6f, 0x61e5 },
	{ 0x5c70, 0x61e4 },
	{ 0x5c71, 0x61e8 },
	{ 0x5c72, 0x61de },
	{ 0x5c73, 0x64ef },
	{ 0x5c74, 0x64e9 },
	{ 0x5c75, 0x64e3 },
	{ 0x5c76, 0x64eb },
	{ 0x5c77, 0x64e4 },
	{ 0x5c78, 0x64e8 },
	{ 0x5c79, 0x6581 },
	{ 0x5c7a, 0x6580 },
	{ 0x5c7b, 0x65b6 },
	{ 0x5c7c, 0x65da },
	{ 0x5c7d, 0x66d2 },
	{ 0x5c7e, 0x6a8d },
	{ 0x5d21, 0x6a96 },
	{ 0x5d22, 0x6a81 },
	{ 0x5d23, 0x6aa5 },
	{ 0x5d24, 0x6a89 },
	{ 0x5d25, 0x6a9f },
	{ 0x5d26, 0x6a9b },
	{ 0x5d27, 0x6aa1 },
	{ 0x5d28, 0x6a9e },
	{ 0x5d29, 0x6a87 },
	{ 0x5d2a, 0x6a93 },
	{ 0x5d2b, 0x6a8e },
	{ 0x5d2c, 0x6a95 },
	{ 0x5d2d, 0x6a83 },
	{ 0x5d2e, 0x6aa8 },
	{ 0x5d2f, 0x6aa4 },
	{ 0x5d30, 0x6a91 },
	{ 0x5d31, 0x6a7f },
	{ 0x5d32, 0x6aa6 },
	{ 0x5d33, 0x6a9a },
	{ 0x5d34, 0x6a85 },
	{ 0x5d35, 0x6a8c },
	{ 0x5d36, 0x6a92 },
	{ 0x5d37, 0x6b5b },
	{ 0x5d38, 0x6bad },
	{ 0x5d39, 0x6c09 },
	{ 0x5d3a, 0x6fcc },
	{ 0x5d3b, 0x6fa9 },
	{ 0x5d3c, 0x6ff4 },
	{ 0x5d3d, 0x6fd4 },
	{ 0x5d3e, 0x6fe3 },
	{ 0x5d3f, 0x6fdc },
	{ 0x5d40, 0x6fed },
	{ 0x5d41, 0x6fe7 },
	{ 0x5d42, 0x6fe6 },
	{ 0x5d43, 0x6fde },
	{ 0x5d44, 0x6ff2 },
	{ 0x5d45, 0x6fdd },
	{ 0x5d46, 0x6fe2 },
	{ 0x5d47, 0x6fe8 },
	{ 0x5d48, 0x71e1 },
	{ 0x5d49, 0x71f1 },
	{ 0x5d4a, 0x71e8 },
	{ 0x5d4b, 0x71f2 },
	{ 0x5d4c, 0x71e4 },
	{ 0x5d4d, 0x71f0 },
	{ 0x5d4e, 0x71e2 },
	{ 0x5d4f, 0x7373 },
	{ 0x5d50, 0x736e },
	{ 0x5d51, 0x736f },
	{ 0x5d52, 0x7497 },
	{ 0x5d53, 0x74b2 },
	{ 0x5d54, 0x74ab },
	{ 0x5d55, 0x7490 },
	{ 0x5d56, 0x74aa },
	{ 0x5d57, 0x74ad },
	{ 0x5d58, 0x74b1 },
	{ 0x5d59, 0x74a5 },
	{ 0x5d5a, 0x74af },
	{ 0x5d5b, 0x7510 },
	{ 0x5d5c, 0x7511 },
	{ 0x5d5d, 0x7512 },
	{ 0x5d5e, 0x750f },
	{ 0x5d5f, 0x7584 },
	{ 0x5d60, 0x7643 },
	{ 0x5d61, 0x7648 },
	{ 0x5d62, 0x7649 },
	{ 0x5d63, 0x7647 },
	{ 0x5d64, 0x76a4 },
	{ 0x5d65, 0x76e9 },
	{ 0x5d66, 0x77b5 },
	{ 0x5d67, 0x77ab },
	{ 0x5d68, 0x77b2 },
	{ 0x5d69, 0x77b7 },
	{ 0x5d6a, 0x77b6 },
	{ 0x5d6b, 0x77b4 },
	{ 0x5d6c, 0x77b1 },
	{ 0x5d6d, 0x77a8 },
	{ 0x5d6e, 0x77f0 },
	{ 0x5d6f, 0x78f3 },
	{ 0x5d70, 0x78fd },
	{ 0x5d71, 0x7902 },
	{ 0x5d72, 0x78fb },
	{ 0x5d73, 0x78fc },
	{ 0x5d74, 0x78ff },
	{ 0x5d75, 0x78f2 },
	{ 0x5d76, 0x7905 },
	{ 0x5d77, 0x78f9 },
	{ 0x5d78, 0x78fe },
	{ 0x5d79, 0x7904 },
	{ 0x5d7a, 0x79ab },
	{ 0x5d7b, 0x79a8 },
	{ 0x5d7c, 0x7a5c },
	{ 0x5d7d, 0x7a5b },
	{ 0x5d7e, 0x7a56 },
	{ 0x5e21, 0x7a58 },
	{ 0x5e22, 0x7a54 },
	{ 0x5e23, 0x7a5a },
	{ 0x5e24, 0x7abe },
	{ 0x5e25, 0x7ac0 },
	{ 0x5e26, 0x7ac1 },
	{ 0x5e27, 0x7c05 },
	{ 0x5e28, 0x7c0f },
	{ 0x5e29, 0x7bf2 },
	{ 0x5e2a, 0x7c00 },
	{ 0x5e2b, 0x7bff },
	{ 0x5e2c, 0x7bfb },
	{ 0x5e2d, 0x7c0e },
	{ 0x5e2e, 0x7bf4 },
	{ 0x5e2f, 0x7c0b },
	{ 0x5e30, 0x7bf3 },
	{ 0x5e31, 0x7c02 },
	{ 0x5e32, 0x7c09 },
	{ 0x5e33, 0x7c03 },
	{ 0x5e34, 0x7c01 },
	{ 0x5e35, 0x7bf8 },
	{ 0x5e36, 0x7bfd },
	{ 0x5e37, 0x7c06 },
	{ 0x5e38, 0x7bf0 },
	{ 0x5e39, 0x7bf1 },
	{ 0x5e3a, 0x7c10 },
	{ 0x5e3b, 0x7c0a },
	{ 0x5e3c, 0x7ce8 },
	{ 0x5e3d, 0x7e2d },
	{ 0x5e3e, 0x7e3c },
	{ 0x5e3f, 0x7e42 },
	{ 0x5e40, 0x7e33 },
	{ 0x5e41, 0x9848 },
	{ 0x5e42, 0x7e38 },
	{ 0x5e43, 0x7e2a },
	{ 0x5e44, 0x7e49 },
	{ 0x5e45, 0x7e40 },
	{ 0x5e46, 0x7e47 },
	{ 0x5e47, 0x7e29 },
	{ 0x5e48, 0x7e4c },
	{ 0x5e49, 0x7e30 },
	{ 0x5e4a, 0x7e3b },
	{ 0x5e4b, 0x7e36 },
	{ 0x5e4c, 0x7e44 },
	{ 0x5e4d, 0x7e3a },
	{ 0x5e4e, 0x7f45 },
	{ 0x5e4f, 0x7f7f },
	{ 0x5e50, 0x7f7e },
	{ 0x5e51, 0x7f7d },
	{ 0x5e52, 0x7ff4 },
	{ 0x5e53, 0x7ff2 },
	{ 0x5e54, 0x802c },
	{ 0x5e55, 0x81bb },
	{ 0x5e56, 0x81c4 },
	{ 0x5e57, 0x81cc },
	{ 0x5e58, 0x81ca },
	{ 0x5e59, 0x81c5 },
	{ 0x5e5a, 0x81c7 },
	{ 0x5e5b, 0x81bc },
	{ 0x5e5c, 0x81e9 },
	{ 0x5e5d, 0x825b },
	{ 0x5e5e, 0x825a },
	{ 0x5e5f, 0x825c },
	{ 0x5e60, 0x8583 },
	{ 0x5e61, 0x8580 },
	{ 0x5e62, 0x858f },
	{ 0x5e63, 0x85a7 },
	{ 0x5e64, 0x8595 },
	{ 0x5e65, 0x85a0 },
	{ 0x5e66, 0x858b },
	{ 0x5e67, 0x85a3 },
	{ 0x5e68, 0x857b },
	{ 0x5e69, 0x85a4 },
	{ 0x5e6a, 0x859a },
	{ 0x5e6b, 0x859e },
	{ 0x5e6c, 0x8577 },
	{ 0x5e6d, 0x857c },
	{ 0x5e6e, 0x8589 },
	{ 0x5e6f, 0x85a1 },
	{ 0x5e70, 0x857a },
	{ 0x5e71, 0x8578 },
	{ 0x5e72, 0x8557 },
	{ 0x5e73, 0x858e },
	{ 0x5e74, 0x8596 },
	{ 0x5e75, 0x8586 },
	{ 0x5e76, 0x858d },
	{ 0x5e77, 0x8599 },
	{ 0x5e78, 0x859d },
	{ 0x5e79, 0x8581 },
	{ 0x5e7a, 0x85a2 },
	{ 0x5e7b, 0x8582 },
	{ 0x5e7c, 0x8588 },
	{ 0x5e7d, 0x8585 },
	{ 0x5e7e, 0x8579 },
	{ 0x5f21, 0x8576 },
	{ 0x5f22, 0x8598 },
	{ 0x5f23, 0x8590 },
	{ 0x5f24, 0x859f },
	{ 0x5f25, 0x8668 },
	{ 0x5f26, 0x87be },
	{ 0x5f27, 0x87aa },
	{ 0x5f28, 0x87ad },
	{ 0x5f29, 0x87c5 },
	{ 0x5f2a, 0x87b0 },
	{ 0x5f2b, 0x87ac },
	{ 0x5f2c, 0x87b9 },
	{ 0x5f2d, 0x87b5 },
	{ 0x5f2e, 0x87bc },
	{ 0x5f2f, 0x87ae },
	{ 0x5f30, 0x87c9 },
	{ 0x5f31, 0x87c3 },
	{ 0x5f32, 0x87c2 },
	{ 0x5f33, 0x87cc },
	{ 0x5f34, 0x87b7 },
	{ 0x5f35, 0x87af },
	{ 0x5f36, 0x87c4 },
	{ 0x5f37, 0x87ca },
	{ 0x5f38, 0x87b4 },
	{ 0x5f39, 0x87b6 },
	{ 0x5f3a, 0x87bf },
	{ 0x5f3b, 0x87b8 },
	{ 0x5f3c, 0x87bd },
	{ 0x5f3d, 0x87de },
	{ 0x5f3e, 0x87b2 },
	{ 0x5f3f, 0x8935 },
	{ 0x5f40, 0x8933 },
	{ 0x5f41, 0x893c },
	{ 0x5f42, 0x893e },
	{ 0x5f43, 0x8941 },
	{ 0x5f44, 0x8952 },
	{ 0x5f45, 0x8937 },
	{ 0x5f46, 0x8942 },
	{ 0x5f47, 0x89ad },
	{ 0x5f48, 0x89af },
	{ 0x5f49, 0x89ae },
	{ 0x5f4a, 0x89f2 },
	{ 0x5f4b, 0x89f3 },
	{ 0x5f4c, 0x8b1e },
	{ 0x5f4d, 0x8b18 },
	{ 0x5f4e, 0x8b16 },
	{ 0x5f4f, 0x8b11 },
	{ 0x5f50, 0x8b05 },
	{ 0x5f51, 0x8b0b },
	{ 0x5f52, 0x8b22 },
	{ 0x5f53, 0x8b0f },
	{ 0x5f54, 0x8b12 },
	{ 0x5f55, 0x8b15 },
	{ 0x5f56, 0x8b07 },
	{ 0x5f57, 0x8b0d },
	{ 0x5f58, 0x8b08 },
	{ 0x5f59, 0x8b06 },
	{ 0x5f5a, 0x8b1c },
	{ 0x5f5b, 0x8b13 },
	{ 0x5f5c, 0x8b1a },
	{ 0x5f5d, 0x8c4f },
	{ 0x5f5e, 0x8c70 },
	{ 0x5f5f, 0x8c72 },
	{ 0x5f60, 0x8c71 },
	{ 0x5f61, 0x8c6f },
	{ 0x5f62, 0x8c95 },
	{ 0x5f63, 0x8c94 },
	{ 0x5f64, 0x8cf9 },
	{ 0x5f65, 0x8d6f },
	{ 0x5f66, 0x8e4e },
	{ 0x5f67, 0x8e4d },
	{ 0x5f68, 0x8e53 },
	{ 0x5f69, 0x8e50 },
	{ 0x5f6a, 0x8e4c },
	{ 0x5f6b, 0x8e47 },
	{ 0x5f6c, 0x8f43 },
	{ 0x5f6d, 0x8f40 },
	{ 0x5f6e, 0x9085 },
	{ 0x5f6f, 0x907e },
	{ 0x5f70, 0x9138 },
	{ 0x5f71, 0x919a },
	{ 0x5f72, 0x91a2 },
	{ 0x5f73, 0x919b },
	{ 0x5f74, 0x9199 },
	{ 0x5f75, 0x919f },
	{ 0x5f76, 0x91a1 },
	{ 0x5f77, 0x919d },
	{ 0x5f78, 0x91a0 },
	{ 0x5f79, 0x93a1 },
	{ 0x5f7a, 0x9383 },
	{ 0x5f7b, 0x93af },
	{ 0x5f7c, 0x9364 },
	{ 0x5f7d, 0x9356 },
	{ 0x5f7e, 0x9347 },
	{ 0x6021, 0x937c },
	{ 0x6022, 0x9358 },
	{ 0x6023, 0x935c },
	{ 0x6024, 0x9376 },
	{ 0x6025, 0x9349 },
	{ 0x6026, 0x9350 },
	{ 0x6027, 0x9351 },
	{ 0x6028, 0x9360 },
	{ 0x6029, 0x936d },
	{ 0x602a, 0x938f },
	{ 0x602b, 0x934c },
	{ 0x602c, 0x936a },
	{ 0x602d, 0x9379 },
	{ 0x602e, 0x9357 },
	{ 0x602f, 0x9355 },
	{ 0x6030, 0x9352 },
	{ 0x6031, 0x934f },
	{ 0x6032, 0x9371 },
	{ 0x6033, 0x9377 },
	{ 0x6034, 0x937b },
	{ 0x6035, 0x9361 },
	{ 0x6036, 0x935e },
	{ 0x6037, 0x9363 },
	{ 0x6038, 0x9367 },
	{ 0x6039, 0x934e },
	{ 0x603a, 0x9359 },
	{ 0x603b, 0x95c7 },
	{ 0x603c, 0x95c0 },
	{ 0x603d, 0x95c9 },
	{ 0x603e, 0x95c3 },
	{ 0x603f, 0x95c5 },
	{ 0x6040, 0x95b7 },
	{ 0x6041, 0x96ae },
	{ 0x6042, 0x96b0 },
	{ 0x6043, 0x96ac },
	{ 0x6044, 0x9720 },
	{ 0x6045, 0x971f },
	{ 0x6046, 0x9718 },
	{ 0x6047, 0x971d },
	{ 0x6048, 0x9719 },
	{ 0x6049, 0x979a },
	{ 0x604a, 0x97a1 },
	{ 0x604b, 0x979c },
	{ 0x604c, 0x979e },
	{ 0x604d, 0x979d },
	{ 0x604e, 0x97d5 },
	{ 0x604f, 0x97d4 },
	{ 0x6050, 0x97f1 },
	{ 0x6051, 0x9841 },
	{ 0x6052, 0x9844 },
	{ 0x6053, 0x984a },
	{ 0x6054, 0x9849 },
	{ 0x6055, 0x9845 },
	{ 0x6056, 0x9843 },
	{ 0x6057, 0x9925 },
	{ 0x6058, 0x992b },
	{ 0x6059, 0x992c },
	{ 0x605a, 0x992a },
	{ 0x605b, 0x9933 },
	{ 0x605c, 0x9932 },
	{ 0x605d, 0x992f },
	{ 0x605e, 0x992d },
	{ 0x605f, 0x9931 },
	{ 0x6060, 0x9930 },
	{ 0x6061, 0x9998 },
	{ 0x6062, 0x99a3 },
	{ 0x6063, 0x99a1 },
	{ 0x6064, 0x9a02 },
	{ 0x6065, 0x99fa },
	{ 0x6066, 0x99f4 },
	{ 0x6067, 0x99f7 },
	{ 0x6068, 0x99f9 },
	{ 0x6069, 0x99f8 },
	{ 0x606a, 0x99f6 },
	{ 0x606b, 0x99fb },
	{ 0x606c, 0x99fd },
	{ 0x606d, 0x99fe },
	{ 0x606e, 0x99fc },
	{ 0x606f, 0x9a03 },
	{ 0x6070, 0x9abe },
	{ 0x6071, 0x9afe },
	{ 0x6072, 0x9afd },
	{ 0x6073, 0x9b01 },
	{ 0x6074, 0x9afc },
	{ 0x6075, 0x9b48 },
	{ 0x6076, 0x9b9a },
	{ 0x6077, 0x9ba8 },
	{ 0x6078, 0x9b9e },
	{ 0x6079, 0x9b9b },
	{ 0x607a, 0x9ba6 },
	{ 0x607b, 0x9ba1 },
	{ 0x607c, 0x9ba5 },
	{ 0x607d, 0x9ba4 },
	{ 0x607e, 0x9b86 },
	{ 0x6121, 0x9ba2 },
	{ 0x6122, 0x9ba0 },
	{ 0x6123, 0x9baf },
	{ 0x6124, 0x9d33 },
	{ 0x6125, 0x9d41 },
	{ 0x6126, 0x9d67 },
	{ 0x6127, 0x9d36 },
	{ 0x6128, 0x9d2e },
	{ 0x6129, 0x9d2f },
	{ 0x612a, 0x9d31 },
	{ 0x612b, 0x9d38 },
	{ 0x612c, 0x9d30 },
	{ 0x612d, 0x9d45 },
	{ 0x612e, 0x9d42 },
	{ 0x612f, 0x9d43 },
	{ 0x6130, 0x9d3e },
	{ 0x6131, 0x9d37 },
	{ 0x6132, 0x9d40 },
	{ 0x6133, 0x9d3d },
	{ 0x6134, 0x7ff5 },
	{ 0x6135, 0x9d2d },
	{ 0x6136, 0x9e8a },
	{ 0x6137, 0x9e89 },
	{ 0x6138, 0x9e8d },
	{ 0x6139, 0x9eb0 },
	{ 0x613a, 0x9ec8 },
	{ 0x613b, 0x9eda },
	{ 0x613c, 0x9efb },
	{ 0x613d, 0x9eff },
	{ 0x613e, 0x9f24 },
	{ 0x613f, 0x9f23 },
	{ 0x6140, 0x9f22 },
	{ 0x6141, 0x9f54 },
	{ 0x6142, 0x9fa0 },
	{ 0x6143, 0x5131 },
	{ 0x6144, 0x512d },
	{ 0x6145, 0x512e },
	{ 0x6146, 0x5698 },
	{ 0x6147, 0x569c },
	{ 0x6148, 0x5697 },
	{ 0x6149, 0x569a },
	{ 0x614a, 0x569d },
	{ 0x614b, 0x5699 },
	{ 0x614c, 0x5970 },
	{ 0x614d, 0x5b3c },
	{ 0x614e, 0x5c69 },
	{ 0x614f, 0x5c6a },
	{ 0x6150, 0x5dc0 },
	{ 0x6151, 0x5e6d },
	{ 0x6152, 0x5e6e },
	{ 0x6153, 0x61d8 },
	{ 0x6154, 0x61df },
	{ 0x6155, 0x61ed },
	{ 0x6156, 0x61ee },
	{ 0x6157, 0x61f1 },
	{ 0x6158, 0x61ea },
	{ 0x6159, 0x61f0 },
	{ 0x615a, 0x61eb },
	{ 0x615b, 0x61d6 },
	{ 0x615c, 0x61e9 },
	{ 0x615d, 0x64ff },
	{ 0x615e, 0x6504 },
	{ 0x615f, 0x64fd },
	{ 0x6160, 0x64f8 },
	{ 0x6161, 0x6501 },
	{ 0x6162, 0x6503 },
	{ 0x6163, 0x64fc },
	{ 0x6164, 0x6594 },
	{ 0x6165, 0x65db },
	{ 0x6166, 0x66da },
	{ 0x6167, 0x66db },
	{ 0x6168, 0x66d8 },
	{ 0x6169, 0x6ac5 },
	{ 0x616a, 0x6ab9 },
	{ 0x616b, 0x6abd },
	{ 0x616c, 0x6ae1 },
	{ 0x616d, 0x6ac6 },
	{ 0x616e, 0x6aba },
	{ 0x616f, 0x6ab6 },
	{ 0x6170, 0x6ab7 },
	{ 0x6171, 0x6ac7 },
	{ 0x6172, 0x6ab4 },
	{ 0x6173, 0x6aad },
	{ 0x6174, 0x6b5e },
	{ 0x6175, 0x6bc9 },
	{ 0x6176, 0x6c0b },
	{ 0x6177, 0x7007 },
	{ 0x6178, 0x700c },
	{ 0x6179, 0x700d },
	{ 0x617a, 0x7001 },
	{ 0x617b, 0x7005 },
	{ 0x617c, 0x7014 },
	{ 0x617d, 0x700e },
	{ 0x617e, 0x6fff },
	{ 0x6221, 0x7000 },
	{ 0x6222, 0x6ffb },
	{ 0x6223, 0x7026 },
	{ 0x6224, 0x6ffc },
	{ 0x6225, 0x6ff7 },
	{ 0x6226, 0x700a },
	{ 0x6227, 0x7201 },
	{ 0x6228, 0x71ff },
	{ 0x6229, 0x71f9 },
	{ 0x622a, 0x7203 },
	{ 0x622b, 0x71fd },
	{ 0x622c, 0x7376 },
	{ 0x622d, 0x74b8 },
	{ 0x622e, 0x74c0 },
	{ 0x622f, 0x74b5 },
	{ 0x6230, 0x74c1 },
	{ 0x6231, 0x74be },
	{ 0x6232, 0x74b6 },
	{ 0x6233, 0x74bb },
	{ 0x6234, 0x74c2 },
	{ 0x6235, 0x7514 },
	{ 0x6236, 0x7513 },
	{ 0x6237, 0x765c },
	{ 0x6238, 0x7664 },
	{ 0x6239, 0x7659 },
	{ 0x623a, 0x7650 },
	{ 0x623b, 0x7653 },
	{ 0x623c, 0x7657 },
	{ 0x623d, 0x765a },
	{ 0x623e, 0x76a6 },
	{ 0x623f, 0x76bd },
	{ 0x6240, 0x76ec },
	{ 0x6241, 0x77c2 },
	{ 0x6242, 0x77ba },
	{ 0x6243, 0x790c },
	{ 0x6244, 0x7913 },
	{ 0x6245, 0x7914 },
	{ 0x6246, 0x7909 },
	{ 0x6247, 0x7910 },
	{ 0x6248, 0x7912 },
	{ 0x6249, 0x7911 },
	{ 0x624a, 0x79ad },
	{ 0x624b, 0x79ac },
	{ 0x624c, 0x7a5f },
	{ 0x624d, 0x7c1c },
	{ 0x624e, 0x7c29 },
	{ 0x624f, 0x7c19 },
	{ 0x6250, 0x7c20 },
	{ 0x6251, 0x7c1f },
	{ 0x6252, 0x7c2d },
	{ 0x6253, 0x7c1d },
	{ 0x6254, 0x7c26 },
	{ 0x6255, 0x7c28 },
	{ 0x6256, 0x7c22 },
	{ 0x6257, 0x7c25 },
	{ 0x6258, 0x7c30 },
	{ 0x6259, 0x7e5c },
	{ 0x625a, 0x7e50 },
	{ 0x625b, 0x7e56 },
	{ 0x625c, 0x7e63 },
	{ 0x625d, 0x7e58 },
	{ 0x625e, 0x7e62 },
	{ 0x625f, 0x7e5f },
	{ 0x6260, 0x7e51 },
	{ 0x6261, 0x7e60 },
	{ 0x6262, 0x7e57 },
	{ 0x6263, 0x7e53 },
	{ 0x6264, 0x7fb5 },
	{ 0x6265, 0x7fb3 },
	{ 0x6266, 0x7ff7 },
	{ 0x6267, 0x7ff8 },
	{ 0x6268, 0x8075 },
	{ 0x6269, 0x81d1 },
	{ 0x626a, 0x81d2 },
	{ 0x626b, 0x81d0 },
	{ 0x626c, 0x825f },
	{ 0x626d, 0x825e },
	{ 0x626e, 0x85b4 },
	{ 0x626f, 0x85c6 },
	{ 0x6270, 0x85c0 },
	{ 0x6271, 0x85c3 },
	{ 0x6272, 0x85c2 },
	{ 0x6273, 0x85b3 },
	{ 0x6274, 0x85b5 },
	{ 0x6275, 0x85bd },
	{ 0x6276, 0x85c7 },
	{ 0x6277, 0x85c4 },
	{ 0x6278, 0x85bf },
	{ 0x6279, 0x85cb },
	{ 0x627a, 0x85ce },
	{ 0x627b, 0x85c8 },
	{ 0x627c, 0x85c5 },
	{ 0x627d, 0x85b1 },
	{ 0x627e, 0x85b6 },
	{ 0x6321, 0x85d2 },
	{ 0x6322, 0x8624 },
	{ 0x6323, 0x85b8 },
	{ 0x6324, 0x85b7 },
	{ 0x6325, 0x85be },
	{ 0x6326, 0x8669 },
	{ 0x6327, 0x87e7 },
	{ 0x6328, 0x87e6 },
	{ 0x6329, 0x87e2 },
	{ 0x632a, 0x87db },
	{ 0x632b, 0x87eb },
	{ 0x632c, 0x87ea },
	{ 0x632d, 0x87e5 },
	{ 0x632e, 0x87df },
	{ 0x632f, 0x87f3 },
	{ 0x6330, 0x87e4 },
	{ 0x6331, 0x87d4 },
	{ 0x6332, 0x87dc },
	{ 0x6333, 0x87d3 },
	{ 0x6334, 0x87ed },
	{ 0x6335, 0x87d8 },
	{ 0x6336, 0x87e3 },
	{ 0x6337, 0x87d7 },
	{ 0x6338, 0x87d9 },
	{ 0x6339, 0x8801 },
	{ 0x633a, 0x87f4 },
	{ 0x633b, 0x87e8 },
	{ 0x633c, 0x87dd },
	{ 0x633d, 0x8953 },
	{ 0x633e, 0x894b },
	{ 0x633f, 0x894f },
	{ 0x6340, 0x894c },
	{ 0x6341, 0x8946 },
	{ 0x6342, 0x8950 },
	{ 0x6343, 0x8951 },
	{ 0x6344, 0x8949 },
	{ 0x6345, 0x8b2a },
	{ 0x6346, 0x8b27 },
	{ 0x6347, 0x8b23 },
	{ 0x6348, 0x8b33 },
	{ 0x6349, 0x8b30 },
	{ 0x634a, 0x8b35 },
	{ 0x634b, 0x8b47 },
	{ 0x634c, 0x8b2f },
	{ 0x634d, 0x8b3c },
	{ 0x634e, 0x8b3e },
	{ 0x634f, 0x8b31 },
	{ 0x6350, 0x8b25 },
	{ 0x6351, 0x8b37 },
	{ 0x6352, 0x8b26 },
	{ 0x6353, 0x8b36 },
	{ 0x6354, 0x8b2e },
	{ 0x6355, 0x8b24 },
	{ 0x6356, 0x8b3b },
	{ 0x6357, 0x8b3d },
	{ 0x6358, 0x8b3a },
	{ 0x6359, 0x8c42 },
	{ 0x635a, 0x8c75 },
	{ 0x635b, 0x8c99 },
	{ 0x635c, 0x8c98 },
	{ 0x635d, 0x8c97 },
	{ 0x635e, 0x8cfe },
	{ 0x635f, 0x8d04 },
	{ 0x6360, 0x8d02 },
	{ 0x6361, 0x8d00 },
	{ 0x6362, 0x8e5c },
	{ 0x6363, 0x8e62 },
	{ 0x6364, 0x8e60 },
	{ 0x6365, 0x8e57 },
	{ 0x6366, 0x8e56 },
	{ 0x6367, 0x8e5e },
	{ 0x6368, 0x8e65 },
	{ 0x6369, 0x8e67 },
	{ 0x636a, 0x8e5b },
	{ 0x636b, 0x8e5a },
	{ 0x636c, 0x8e61 },
	{ 0x636d, 0x8e5d },
	{ 0x636e, 0x8e69 },
	{ 0x636f, 0x8e54 },
	{ 0x6370, 0x8f46 },
	{ 0x6371, 0x8f47 },
	{ 0x6372, 0x8f48 },
	{ 0x6373, 0x8f4b },
	{ 0x6374, 0x9128 },
	{ 0x6375, 0x913a },
	{ 0x6376, 0x913b },
	{ 0x6377, 0x913e },
	{ 0x6378, 0x91a8 },
	{ 0x6379, 0x91a5 },
	{ 0x637a, 0x91a7 },
	{ 0x637b, 0x91af },
	{ 0x637c, 0x91aa },
	{ 0x637d, 0x93b5 },
	{ 0x637e, 0x938c },
	{ 0x6421, 0x9392 },
	{ 0x6422, 0x93b7 },
	{ 0x6423, 0x939b },
	{ 0x6424, 0x939d },
	{ 0x6425, 0x9389 },
	{ 0x6426, 0x93a7 },
	{ 0x6427, 0x938e },
	{ 0x6428, 0x93aa },
	{ 0x6429, 0x939e },
	{ 0x642a, 0x93a6 },
	{ 0x642b, 0x9395 },
	{ 0x642c, 0x9388 },
	{ 0x642d, 0x9399 },
	{ 0x642e, 0x939f },
	{ 0x642f, 0x9380 },
	{ 0x6430, 0x938d },
	{ 0x6431, 0x93b1 },
	{ 0x6432, 0x9391 },
	{ 0x6433, 0x93b2 },
	{ 0x6434, 0x93a4 },
	{ 0x6435, 0x93a8 },
	{ 0x6436, 0x93b4 },
	{ 0x6437, 0x93a3 },
	{ 0x6438, 0x95d2 },
	{ 0x6439, 0x95d3 },
	{ 0x643a, 0x95d1 },
	{ 0x643b, 0x96b3 },
	{ 0x643c, 0x96d7 },
	{ 0x643d, 0x96da },
	{ 0x643e, 0x5dc2 },
	{ 0x643f, 0x96df },
	{ 0x6440, 0x96d8 },
	{ 0x6441, 0x96dd },
	{ 0x6442, 0x9723 },
	{ 0x6443, 0x9722 },
	{ 0x6444, 0x9725 },
	{ 0x6445, 0x97ac },
	{ 0x6446, 0x97ae },
	{ 0x6447, 0x97a8 },
	{ 0x6448, 0x97ab },
	{ 0x6449, 0x97a4 },
	{ 0x644a, 0x97aa },
	{ 0x644b, 0x97a2 },
	{ 0x644c, 0x97a5 },
	{ 0x644d, 0x97d7 },
	{ 0x644e, 0x97d9 },
	{ 0x644f, 0x97d6 },
	{ 0x6450, 0x97d8 },
	{ 0x6451, 0x97fa },
	{ 0x6452, 0x9850 },
	{ 0x6453, 0x9851 },
	{ 0x6454, 0x9852 },
	{ 0x6455, 0x98b8 },
	{ 0x6456, 0x9941 },
	{ 0x6457, 0x993c },
	{ 0x6458, 0x993a },
	{ 0x6459, 0x9a0f },
	{ 0x645a, 0x9a0b },
	{ 0x645b, 0x9a09 },
	{ 0x645c, 0x9a0d },
	{ 0x645d, 0x9a04 },
	{ 0x645e, 0x9a11 },
	{ 0x645f, 0x9a0a },
	{ 0x6460, 0x9a05 },
	{ 0x6461, 0x9a07 },
	{ 0x6462, 0x9a06 },
	{ 0x6463, 0x9ac0 },
	{ 0x6464, 0x9adc },
	{ 0x6465, 0x9b08 },
	{ 0x6466, 0x9b04 },
	{ 0x6467, 0x9b05 },
	{ 0x6468, 0x9b29 },
	{ 0x6469, 0x9b35 },
	{ 0x646a, 0x9b4a },
	{ 0x646b, 0x9b4c },
	{ 0x646c, 0x9b4b },
	{ 0x646d, 0x9bc7 },
	{ 0x646e, 0x9bc6 },
	{ 0x646f, 0x9bc3 },
	{ 0x6470, 0x9bbf },
	{ 0x6471, 0x9bc1 },
	{ 0x6472, 0x9bb5 },
	{ 0x6473, 0x9bb8 },
	{ 0x6474, 0x9bd3 },
	{ 0x6475, 0x9bb6 },
	{ 0x6476, 0x9bc4 },
	{ 0x6477, 0x9bb9 },
	{ 0x6478, 0x9bbd },
	{ 0x6479, 0x9d5c },
	{ 0x647a, 0x9d53 },
	{ 0x647b, 0x9d4f },
	{ 0x647c, 0x9d4a },
	{ 0x647d, 0x9d5b },
	{ 0x647e, 0x9d4b },
	{ 0x6521, 0x9d59 },
	{ 0x6522, 0x9d56 },
	{ 0x6523, 0x9d4c },
	{ 0x6524, 0x9d57 },
	{ 0x6525, 0x9d52 },
	{ 0x6526, 0x9d54 },
	{ 0x6527, 0x9d5f },
	{ 0x6528, 0x9d58 },
	{ 0x6529, 0x9d5a },
	{ 0x652a, 0x9e8e },
	{ 0x652b, 0x9e8c },
	{ 0x652c, 0x9edf },
	{ 0x652d, 0x9f01 },
	{ 0x652e, 0x9f00 },
	{ 0x652f, 0x9f16 },
	{ 0x6530, 0x9f25 },
	{ 0x6531, 0x9f2b },
	{ 0x6532, 0x9f2a },
	{ 0x6533, 0x9f29 },
	{ 0x6534, 0x9f28 },
	{ 0x6535, 0x9f4c },
	{ 0x6536, 0x9f55 },
	{ 0x6537, 0x5134 },
	{ 0x6538, 0x5135 },
	{ 0x6539, 0x5296 },
	{ 0x653a, 0x52f7 },
	{ 0x653b, 0x53b4 },
	{ 0x653c, 0x56ab },
	{ 0x653d, 0x56ad },
	{ 0x653e, 0x56a6 },
	{ 0x653f, 0x56a7 },
	{ 0x6540, 0x56aa },
	{ 0x6541, 0x56ac },
	{ 0x6542, 0x58da },
	{ 0x6543, 0x58dd },
	{ 0x6544, 0x58db },
	{ 0x6545, 0x5912 },
	{ 0x6546, 0x5b3d },
	{ 0x6547, 0x5b3e },
	{ 0x6548, 0x5b3f },
	{ 0x6549, 0x5dc3 },
	{ 0x654a, 0x5e70 },
	{ 0x654b, 0x5fbf },
	{ 0x654c, 0x61fb },
	{ 0x654d, 0x6507 },
	{ 0x654e, 0x6510 },
	{ 0x654f, 0x650d },
	{ 0x6550, 0x6509 },
	{ 0x6551, 0x650c },
	{ 0x6552, 0x650e },
	{ 0x6553, 0x6584 },
	{ 0x6554, 0x65de },
	{ 0x6555, 0x65dd },
	{ 0x6556, 0x66de },
	{ 0x6557, 0x6ae7 },
	{ 0x6558, 0x6ae0 },
	{ 0x6559, 0x6acc },
	{ 0x655a, 0x6ad1 },
	{ 0x655b, 0x6ad9 },
	{ 0x655c, 0x6acb },
	{ 0x655d, 0x6adf },
	{ 0x655e, 0x6adc },
	{ 0x655f, 0x6ad0 },
	{ 0x6560, 0x6aeb },
	{ 0x6561, 0x6acf },
	{ 0x6562, 0x6acd },
	{ 0x6563, 0x6ade },
	{ 0x6564, 0x6b60 },
	{ 0x6565, 0x6bb0 },
	{ 0x6566, 0x6c0c },
	{ 0x6567, 0x7019 },
	{ 0x6568, 0x7027 },
	{ 0x6569, 0x7020 },
	{ 0x656a, 0x7016 },
	{ 0x656b, 0x702b },
	{ 0x656c, 0x7021 },
	{ 0x656d, 0x7022 },
	{ 0x656e, 0x7023 },
	{ 0x656f, 0x7029 },
	{ 0x6570, 0x7017 },
	{ 0x6571, 0x7024 },
	{ 0x6572, 0x701c },
	{ 0x6573, 0x720c },
	{ 0x6574, 0x720a },
	{ 0x6575, 0x7207 },
	{ 0x6576, 0x7202 },
	{ 0x6577, 0x7205 },
	{ 0x6578, 0x72a5 },
	{ 0x6579, 0x72a6 },
	{ 0x657a, 0x72a4 },
	{ 0x657b, 0x72a3 },
	{ 0x657c, 0x72a1 },
	{ 0x657d, 0x74cb },
	{ 0x657e, 0x74c5 },
	{ 0x6621, 0x74b7 },
	{ 0x6622, 0x74c3 },
	{ 0x6623, 0x7516 },
	{ 0x6624, 0x7660 },
	{ 0x6625, 0x77c9 },
	{ 0x6626, 0x77ca },
	{ 0x6627, 0x77c4 },
	{ 0x6628, 0x77f1 },
	{ 0x6629, 0x791d },
	{ 0x662a, 0x791b },
	{ 0x662b, 0x7921 },
	{ 0x662c, 0x791c },
	{ 0x662d, 0x7917 },
	{ 0x662e, 0x791e },
	{ 0x662f, 0x79b0 },
	{ 0x6630, 0x7a67 },
	{ 0x6631, 0x7a68 },
	{ 0x6632, 0x7c33 },
	{ 0x6633, 0x7c3c },
	{ 0x6634, 0x7c39 },
	{ 0x6635, 0x7c2c },
	{ 0x6636, 0x7c3b },
	{ 0x6637, 0x7cec },
	{ 0x6638, 0x7cea },
	{ 0x6639, 0x7e76 },
	{ 0x663a, 0x7e75 },
	{ 0x663b, 0x7e78 },
	{ 0x663c, 0x7e70 },
	{ 0x663d, 0x7e77 },
	{ 0x663e, 0x7e6f },
	{ 0x663f, 0x7e7a },
	{ 0x6640, 0x7e72 },
	{ 0x6641, 0x7e74 },
	{ 0x6642, 0x7e68 },
	{ 0x6643, 0x7f4b },
	{ 0x6644, 0x7f4a },
	{ 0x6645, 0x7f83 },
	{ 0x6646, 0x7f86 },
	{ 0x6647, 0x7fb7 },
	{ 0x6648, 0x7ffd },
	{ 0x6649, 0x7ffe },
	{ 0x664a, 0x8078 },
	{ 0x664b, 0x81d7 },
	{ 0x664c, 0x81d5 },
	{ 0x664d, 0x820b },
	{ 0x664e, 0x8264 },
	{ 0x664f, 0x8261 },
	{ 0x6650, 0x8263 },
	{ 0x6651, 0x85eb },
	{ 0x6652, 0x85f1 },
	{ 0x6653, 0x85ed },
	{ 0x6654, 0x85d9 },
	{ 0x6655, 0x85e1 },
	{ 0x6656, 0x85e8 },
	{ 0x6657, 0x85da },
	{ 0x6658, 0x85d7 },
	{ 0x6659, 0x85ec },
	{ 0x665a, 0x85f2 },
	{ 0x665b, 0x85f8 },
	{ 0x665c, 0x85d8 },
	{ 0x665d, 0x85df },
	{ 0x665e, 0x85e3 },
	{ 0x665f, 0x85dc },
	{ 0x6660, 0x85d1 },
	{ 0x6661, 0x85f0 },
	{ 0x6662, 0x85e6 },
	{ 0x6663, 0x85ef },
	{ 0x6664, 0x85de },
	{ 0x6665, 0x85e2 },
	{ 0x6666, 0x8800 },
	{ 0x6667, 0x87fa },
	{ 0x6668, 0x8803 },
	{ 0x6669, 0x87f6 },
	{ 0x666a, 0x87f7 },
	{ 0x666b, 0x8809 },
	{ 0x666c, 0x880c },
	{ 0x666d, 0x880b },
	{ 0x666e, 0x8806 },
	{ 0x666f, 0x87fc },
	{ 0x6670, 0x8808 },
	{ 0x6671, 0x87ff },
	{ 0x6672, 0x880a },
	{ 0x6673, 0x8802 },
	{ 0x6674, 0x8962 },
	{ 0x6675, 0x895a },
	{ 0x6676, 0x895b },
	{ 0x6677, 0x8957 },
	{ 0x6678, 0x8961 },
	{ 0x6679, 0x895c },
	{ 0x667a, 0x8958 },
	{ 0x667b, 0x895d },
	{ 0x667c, 0x8959 },
	{ 0x667d, 0x8988 },
	{ 0x667e, 0x89b7 },
	{ 0x6721, 0x89b6 },
	{ 0x6722, 0x89f6 },
	{ 0x6723, 0x8b50 },
	{ 0x6724, 0x8b48 },
	{ 0x6725, 0x8b4a },
	{ 0x6726, 0x8b40 },
	{ 0x6727, 0x8b53 },
	{ 0x6728, 0x8b56 },
	{ 0x6729, 0x8b54 },
	{ 0x672a, 0x8b4b },
	{ 0x672b, 0x8b55 },
	{ 0x672c, 0x8b51 },
	{ 0x672d, 0x8b42 },
	{ 0x672e, 0x8b52 },
	{ 0x672f, 0x8b57 },
	{ 0x6730, 0x8c43 },
	{ 0x6731, 0x8c77 },
	{ 0x6732, 0x8c76 },
	{ 0x6733, 0x8c9a },
	{ 0x6734, 0x8d06 },
	{ 0x6735, 0x8d07 },
	{ 0x6736, 0x8d09 },
	{ 0x6737, 0x8dac },
	{ 0x6738, 0x8daa },
	{ 0x6739, 0x8dad },
	{ 0x673a, 0x8dab },
	{ 0x673b, 0x8e6d },
	{ 0x673c, 0x8e78 },
	{ 0x673d, 0x8e73 },
	{ 0x673e, 0x8e6a },
	{ 0x673f, 0x8e6f },
	{ 0x6740, 0x8e7b },
	{ 0x6741, 0x8ec2 },
	{ 0x6742, 0x8f52 },
	{ 0x6743, 0x8f51 },
	{ 0x6744, 0x8f4f },
	{ 0x6745, 0x8f50 },
	{ 0x6746, 0x8f53 },
	{ 0x6747, 0x8fb4 },
	{ 0x6748, 0x9140 },
	{ 0x6749, 0x913f },
	{ 0x674a, 0x91b0 },
	{ 0x674b, 0x91ad },
	{ 0x674c, 0x93de },
	{ 0x674d, 0x93c7 },
	{ 0x674e, 0x93cf },
	{ 0x674f, 0x93c2 },
	{ 0x6750, 0x93da },
	{ 0x6751, 0x93d0 },
	{ 0x6752, 0x93f9 },
	{ 0x6753, 0x93ec },
	{ 0x6754, 0x93cc },
	{ 0x6755, 0x93d9 },
	{ 0x6756, 0x93a9 },
	{ 0x6757, 0x93e6 },
	{ 0x6758, 0x93ca },
	{ 0x6759, 0x93d4 },
	{ 0x675a, 0x93ee },
	{ 0x675b, 0x93e3 },
	{ 0x675c, 0x93d5 },
	{ 0x675d, 0x93c4 },
	{ 0x675e, 0x93ce },
	{ 0x675f, 0x93c0 },
	{ 0x6760, 0x93d2 },
	{ 0x6761, 0x93a5 },
	{ 0x6762, 0x93e7 },
	{ 0x6763, 0x957d },
	{ 0x6764, 0x95da },
	{ 0x6765, 0x95db },
	{ 0x6766, 0x96e1 },
	{ 0x6767, 0x9729 },
	{ 0x6768, 0x972b },
	{ 0x6769, 0x972c },
	{ 0x676a, 0x9728 },
	{ 0x676b, 0x9726 },
	{ 0x676c, 0x97b3 },
	{ 0x676d, 0x97b7 },
	{ 0x676e, 0x97b6 },
	{ 0x676f, 0x97dd },
	{ 0x6770, 0x97de },
	{ 0x6771, 0x97df },
	{ 0x6772, 0x985c },
	{ 0x6773, 0x9859 },
	{ 0x6774, 0x985d },
	{ 0x6775, 0x9857 },
	{ 0x6776, 0x98bf },
	{ 0x6777, 0x98bd },
	{ 0x6778, 0x98bb },
	{ 0x6779, 0x98be },
	{ 0x677a, 0x9948 },
	{ 0x677b, 0x9947 },
	{ 0x677c, 0x9943 },
	{ 0x677d, 0x99a6 },
	{ 0x677e, 0x99a7 },
	{ 0x6821, 0x9a1a },
	{ 0x6822, 0x9a15 },
	{ 0x6823, 0x9a25 },
	{ 0x6824, 0x9a1d },
	{ 0x6825, 0x9a24 },
	{ 0x6826, 0x9a1b },
	{ 0x6827, 0x9a22 },
	{ 0x6828, 0x9a20 },
	{ 0x6829, 0x9a27 },
	{ 0x682a, 0x9a23 },
	{ 0x682b, 0x9a1e },
	{ 0x682c, 0x9a1c },
	{ 0x682d, 0x9a14 },
	{ 0x682e, 0x9ac2 },
	{ 0x682f, 0x9b0b },
	{ 0x6830, 0x9b0a },
	{ 0x6831, 0x9b0e },
	{ 0x6832, 0x9b0c },
	{ 0x6833, 0x9b37 },
	{ 0x6834, 0x9bea },
	{ 0x6835, 0x9beb },
	{ 0x6836, 0x9be0 },
	{ 0x6837, 0x9bde },
	{ 0x6838, 0x9be4 },
	{ 0x6839, 0x9be6 },
	{ 0x683a, 0x9be2 },
	{ 0x683b, 0x9bf0 },
	{ 0x683c, 0x9bd4 },
	{ 0x683d, 0x9bd7 },
	{ 0x683e, 0x9bec },
	{ 0x683f, 0x9bdc },
	{ 0x6840, 0x9bd9 },
	{ 0x6841, 0x9be5 },
	{ 0x6842, 0x9bd5 },
	{ 0x6843, 0x9be1 },
	{ 0x6844, 0x9bda },
	{ 0x6845, 0x9d77 },
	{ 0x6846, 0x9d81 },
	{ 0x6847, 0x9d8a },
	{ 0x6848, 0x9d84 },
	{ 0x6849, 0x9d88 },
	{ 0x684a, 0x9d71 },
	{ 0x684b, 0x9d80 },
	{ 0x684c, 0x9d78 },
	{ 0x684d, 0x9d86 },
	{ 0x684e, 0x9d8b },
	{ 0x684f, 0x9d8c },
	{ 0x6850, 0x9d7d },
	{ 0x6851, 0x9d6b },
	{ 0x6852, 0x9d74 },
	{ 0x6853, 0x9d75 },
	{ 0x6854, 0x9d70 },
	{ 0x6855, 0x9d69 },
	{ 0x6856, 0x9d85 },
	{ 0x6857, 0x9d73 },
	{ 0x6858, 0x9d7b },
	{ 0x6859, 0x9d82 },
	{ 0x685a, 0x9d6f },
	{ 0x685b, 0x9d79 },
	{ 0x685c, 0x9d7f },
	{ 0x685d, 0x9d87 },
	{ 0x685e, 0x9d68 },
	{ 0x685f, 0x9e94 },
	{ 0x6860, 0x9e91 },
	{ 0x6861, 0x9ec0 },
	{ 0x6862, 0x9efc },
	{ 0x6863, 0x9f2d },
	{ 0x6864, 0x9f40 },
	{ 0x6865, 0x9f41 },
	{ 0x6866, 0x9f4d },
	{ 0x6867, 0x9f56 },
	{ 0x6868, 0x9f57 },
	{ 0x6869, 0x9f58 },
	{ 0x686a, 0x5337 },
	{ 0x686b, 0x56b2 },
	{ 0x686c, 0x56b5 },
	{ 0x686d, 0x56b3 },
	{ 0x686e, 0x58e3 },
	{ 0x686f, 0x5b45 },
	{ 0x6870, 0x5dc6 },
	{ 0x6871, 0x5dc7 },
	{ 0x6872, 0x5eee },
	{ 0x6873, 0x5eef },
	{ 0x6874, 0x5fc0 },
	{ 0x6875, 0x5fc1 },
	{ 0x6876, 0x61f9 },
	{ 0x6877, 0x6517 },
	{ 0x6878, 0x6516 },
	{ 0x6879, 0x6515 },
	{ 0x687a, 0x6513 },
	{ 0x687b, 0x65df },
	{ 0x687c, 0x66e8 },
	{ 0x687d, 0x66e3 },
	{ 0x687e, 0x66e4 },
	{ 0x6921, 0x6af3 },
	{ 0x6922, 0x6af0 },
	{ 0x6923, 0x6aea },
	{ 0x6924, 0x6ae8 },
	{ 0x6925, 0x6af9 },
	{ 0x6926, 0x6af1 },
	{ 0x6927, 0x6aee },
	{ 0x6928, 0x6aef },
	{ 0x6929, 0x703c },
	{ 0x692a, 0x7035 },
	{ 0x692b, 0x702f },
	{ 0x692c, 0x7037 },
	{ 0x692d, 0x7034 },
	{ 0x692e, 0x7031 },
	{ 0x692f, 0x7042 },
	{ 0x6930, 0x7038 },
	{ 0x6931, 0x703f },
	{ 0x6932, 0x703a },
	{ 0x6933, 0x7039 },
	{ 0x6934, 0x702a },
	{ 0x6935, 0x7040 },
	{ 0x6936, 0x703b },
	{ 0x6937, 0x7033 },
	{ 0x6938, 0x7041 },
	{ 0x6939, 0x7213 },
	{ 0x693a, 0x7214 },
	{ 0x693b, 0x72a8 },
	{ 0x693c, 0x737d },
	{ 0x693d, 0x737c },
	{ 0x693e, 0x74ba },
	{ 0x693f, 0x76ab },
	{ 0x6940, 0x76aa },
	{ 0x6941, 0x76be },
	{ 0x6942, 0x76ed },
	{ 0x6943, 0x77cc },
	{ 0x6944, 0x77ce },
	{ 0x6945, 0x77cf },
	{ 0x6946, 0x77cd },
	{ 0x6947, 0x77f2 },
	{ 0x6948, 0x7925 },
	{ 0x6949, 0x7923 },
	{ 0x694a, 0x7927 },
	{ 0x694b, 0x7928 },
	{ 0x694c, 0x7924 },
	{ 0x694d, 0x7929 },
	{ 0x694e, 0x79b2 },
	{ 0x694f, 0x7a6e },
	{ 0x6950, 0x7a6c },
	{ 0x6951, 0x7a6d },
	{ 0x6952, 0x7af7 },
	{ 0x6953, 0x7c49 },
	{ 0x6954, 0x7c48 },
	{ 0x6955, 0x7c4a },
	{ 0x6956, 0x7c47 },
	{ 0x6957, 0x7c45 },
	{ 0x6958, 0x7cee },
	{ 0x6959, 0x7e7b },
	{ 0x695a, 0x7e7e },
	{ 0x695b, 0x7e81 },
	{ 0x695c, 0x7e80 },
	{ 0x695d, 0x7fba },
	{ 0x695e, 0x7fff },
	{ 0x695f, 0x8079 },
	{ 0x6960, 0x81db },
	{ 0x6961, 0x81d9 },
	{ 0x6962, 0x8268 },
	{ 0x6963, 0x8269 },
	{ 0x6964, 0x8622 },
	{ 0x6965, 0x85ff },
	{ 0x6966, 0x8601 },
	{ 0x6967, 0x85fe },
	{ 0x6968, 0x861b },
	{ 0x6969, 0x8600 },
	{ 0x696a, 0x85f6 },
	{ 0x696b, 0x8604 },
	{ 0x696c, 0x8609 },
	{ 0x696d, 0x8605 },
	{ 0x696e, 0x860c },
	{ 0x696f, 0x85fd },
	{ 0x6970, 0x8819 },
	{ 0x6971, 0x8810 },
	{ 0x6972, 0x8811 },
	{ 0x6973, 0x8817 },
	{ 0x6974, 0x8813 },
	{ 0x6975, 0x8816 },
	{ 0x6976, 0x8963 },
	{ 0x6977, 0x8966 },
	{ 0x6978, 0x89b9 },
	{ 0x6979, 0x89f7 },
	{ 0x697a, 0x8b60 },
	{ 0x697b, 0x8b6a },
	{ 0x697c, 0x8b5d },
	{ 0x697d, 0x8b68 },
	{ 0x697e, 0x8b63 },
	{ 0x6a21, 0x8b65 },
	{ 0x6a22, 0x8b67 },
	{ 0x6a23, 0x8b6d },
	{ 0x6a24, 0x8dae },
	{ 0x6a25, 0x8e86 },
	{ 0x6a26, 0x8e88 },
	{ 0x6a27, 0x8e84 },
	{ 0x6a28, 0x8f59 },
	{ 0x6a29, 0x8f56 },
	{ 0x6a2a, 0x8f57 },
	{ 0x6a2b, 0x8f55 },
	{ 0x6a2c, 0x8f58 },
	{ 0x6a2d, 0x8f5a },
	{ 0x6a2e, 0x908d },
	{ 0x6a2f, 0x9143 },
	{ 0x6a30, 0x9141 },
	{ 0x6a31, 0x91b7 },
	{ 0x6a32, 0x91b5 },
	{ 0x6a33, 0x91b2 },
	{ 0x6a34, 0x91b3 },
	{ 0x6a35, 0x940b },
	{ 0x6a36, 0x9413 },
	{ 0x6a37, 0x93fb },
	{ 0x6a38, 0x9420 },
	{ 0x6a39, 0x940f },
	{ 0x6a3a, 0x9414 },
	{ 0x6a3b, 0x93fe },
	{ 0x6a3c, 0x9415 },
	{ 0x6a3d, 0x9410 },
	{ 0x6a3e, 0x9428 },
	{ 0x6a3f, 0x9419 },
	{ 0x6a40, 0x940d },
	{ 0x6a41, 0x93f5 },
	{ 0x6a42, 0x9400 },
	{ 0x6a43, 0x93f7 },
	{ 0x6a44, 0x9407 },
	{ 0x6a45, 0x940e },
	{ 0x6a46, 0x9416 },
	{ 0x6a47, 0x9412 },
	{ 0x6a48, 0x93fa },
	{ 0x6a49, 0x9409 },
	{ 0x6a4a, 0x93f8 },
	{ 0x6a4b, 0x943c },
	{ 0x6a4c, 0x940a },
	{ 0x6a4d, 0x93ff },
	{ 0x6a4e, 0x93fc },
	{ 0x6a4f, 0x940c },
	{ 0x6a50, 0x93f6 },
	{ 0x6a51, 0x9411 },
	{ 0x6a52, 0x9406 },
	{ 0x6a53, 0x95de },
	{ 0x6a54, 0x95e0 },
	{ 0x6a55, 0x95df },
	{ 0x6a56, 0x972e },
	{ 0x6a57, 0x972f },
	{ 0x6a58, 0x97b9 },
	{ 0x6a59, 0x97bb },
	{ 0x6a5a, 0x97fd },
	{ 0x6a5b, 0x97fe },
	{ 0x6a5c, 0x9860 },
	{ 0x6a5d, 0x9862 },
	{ 0x6a5e, 0x9863 },
	{ 0x6a5f, 0x985f },
	{ 0x6a60, 0x98c1 },
	{ 0x6a61, 0x98c2 },
	{ 0x6a62, 0x9950 },
	{ 0x6a63, 0x994e },
	{ 0x6a64, 0x9959 },
	{ 0x6a65, 0x994c },
	{ 0x6a66, 0x994b },
	{ 0x6a67, 0x9953 },
	{ 0x6a68, 0x9a32 },
	{ 0x6a69, 0x9a34 },
	{ 0x6a6a, 0x9a31 },
	{ 0x6a6b, 0x9a2c },
	{ 0x6a6c, 0x9a2a },
	{ 0x6a6d, 0x9a36 },
	{ 0x6a6e, 0x9a29 },
	{ 0x6a6f, 0x9a2e },
	{ 0x6a70, 0x9a38 },
	{ 0x6a71, 0x9a2d },
	{ 0x6a72, 0x9ac7 },
	{ 0x6a73, 0x9aca },
	{ 0x6a74, 0x9ac6 },
	{ 0x6a75, 0x9b10 },
	{ 0x6a76, 0x9b12 },
	{ 0x6a77, 0x9b11 },
	{ 0x6a78, 0x9c0b },
	{ 0x6a79, 0x9c08 },
	{ 0x6a7a, 0x9bf7 },
	{ 0x6a7b, 0x9c05 },
	{ 0x6a7c, 0x9c12 },
	{ 0x6a7d, 0x9bf8 },
	{ 0x6a7e, 0x9c40 },
	{ 0x6b21, 0x9c07 },
	{ 0x6b22, 0x9c0e },
	{ 0x6b23, 0x9c06 },
	{ 0x6b24, 0x9c17 },
	{ 0x6b25, 0x9c14 },
	{ 0x6b26, 0x9c09 },
	{ 0x6b27, 0x9d9f },
	{ 0x6b28, 0x9d99 },
	{ 0x6b29, 0x9da4 },
	{ 0x6b2a, 0x9d9d },
	{ 0x6b2b, 0x9d92 },
	{ 0x6b2c, 0x9d98 },
	{ 0x6b2d, 0x9d90 },
	{ 0x6b2e, 0x9d9b },
	{ 0x6b2f, 0x9da0 },
	{ 0x6b30, 0x9d94 },
	{ 0x6b31, 0x9d9c },
	{ 0x6b32, 0x9daa },
	{ 0x6b33, 0x9d97 },
	{ 0x6b34, 0x9da1 },
	{ 0x6b35, 0x9d9a },
	{ 0x6b36, 0x9da2 },
	{ 0x6b37, 0x9da8 },
	{ 0x6b38, 0x9d9e },
	{ 0x6b39, 0x9da3 },
	{ 0x6b3a, 0x9dbf },
	{ 0x6b3b, 0x9da9 },
	{ 0x6b3c, 0x9d96 },
	{ 0x6b3d, 0x9da6 },
	{ 0x6b3e, 0x9da7 },
	{ 0x6b3f, 0x9e99 },
	{ 0x6b40, 0x9e9b },
	{ 0x6b41, 0x9e9a },
	{ 0x6b42, 0x9ee5 },
	{ 0x6b43, 0x9ee4 },
	{ 0x6b44, 0x9ee7 },
	{ 0x6b45, 0x9ee6 },
	{ 0x6b46, 0x9f30 },
	{ 0x6b47, 0x9f2e },
	{ 0x6b48, 0x9f5b },
	{ 0x6b49, 0x9f60 },
	{ 0x6b4a, 0x9f5e },
	{ 0x6b4b, 0x9f5d },
	{ 0x6b4c, 0x9f59 },
	{ 0x6b4d, 0x9f91 },
	{ 0x6b4e, 0x513a },
	{ 0x6b4f, 0x5139 },
	{ 0x6b50, 0x5298 },
	{ 0x6b51, 0x5297 },
	{ 0x6b52, 0x56c3 },
	{ 0x6b53, 0x56bd },
	{ 0x6b54, 0x56be },
	{ 0x6b55, 0x5b48 },
	{ 0x6b56, 0x5b47 },
	{ 0x6b57, 0x5dcb },
	{ 0x6b58, 0x5dcf },
	{ 0x6b59, 0x5ef1 },
	{ 0x6b5a, 0x61fd },
	{ 0x6b5b, 0x651b },
	{ 0x6b5c, 0x6b02 },
	{ 0x6b5d, 0x6afc },
	{ 0x6b5e, 0x6b03 },
	{ 0x6b5f, 0x6af8 },
	{ 0x6b60, 0x6b00 },
	{ 0x6b61, 0x7043 },
	{ 0x6b62, 0x7044 },
	{ 0x6b63, 0x704a },
	{ 0x6b64, 0x7048 },
	{ 0x6b65, 0x7049 },
	{ 0x6b66, 0x7045 },
	{ 0x6b67, 0x7046 },
	{ 0x6b68, 0x721d },
	{ 0x6b69, 0x721a },
	{ 0x6b6a, 0x7219 },
	{ 0x6b6b, 0x737e },
	{ 0x6b6c, 0x7517 },
	{ 0x6b6d, 0x766a },
	{ 0x6b6e, 0x77d0 },
	{ 0x6b6f, 0x792d },
	{ 0x6b70, 0x7931 },
	{ 0x6b71, 0x792f },
	{ 0x6b72, 0x7c54 },
	{ 0x6b73, 0x7c53 },
	{ 0x6b74, 0x7cf2 },
	{ 0x6b75, 0x7e8a },
	{ 0x6b76, 0x7e87 },
	{ 0x6b77, 0x7e88 },
	{ 0x6b78, 0x7e8b },
	{ 0x6b79, 0x7e86 },
	{ 0x6b7a, 0x7e8d },
	{ 0x6b7b, 0x7f4d },
	{ 0x6b7c, 0x7fbb },
	{ 0x6b7d, 0x8030 },
	{ 0x6b7e, 0x81dd },
	{ 0x6c21, 0x8618 },
	{ 0x6c22, 0x862a },
	{ 0x6c23, 0x8626 },
	{ 0x6c24, 0x861f },
	{ 0x6c25, 0x8623 },
	{ 0x6c26, 0x861c },
	{ 0x6c27, 0x8619 },
	{ 0x6c28, 0x8627 },
	{ 0x6c29, 0x862e },
	{ 0x6c2a, 0x8621 },
	{ 0x6c2b, 0x8620 },
	{ 0x6c2c, 0x8629 },
	{ 0x6c2d, 0x861e },
	{ 0x6c2e, 0x8625 },
	{ 0x6c2f, 0x8829 },
	{ 0x6c30, 0x881d },
	{ 0x6c31, 0x881b },
	{ 0x6c32, 0x8820 },
	{ 0x6c33, 0x8824 },
	{ 0x6c34, 0x881c },
	{ 0x6c35, 0x882b },
	{ 0x6c36, 0x884a },
	{ 0x6c37, 0x896d },
	{ 0x6c38, 0x8969 },
	{ 0x6c39, 0x896e },
	{ 0x6c3a, 0x896b },
	{ 0x6c3b, 0x89fa },
	{ 0x6c3c, 0x8b79 },
	{ 0x6c3d, 0x8b78 },
	{ 0x6c3e, 0x8b45 },
	{ 0x6c3f, 0x8b7a },
	{ 0x6c40, 0x8b7b },
	{ 0x6c41, 0x8d10 },
	{ 0x6c42, 0x8d14 },
	{ 0x6c43, 0x8daf },
	{ 0x6c44, 0x8e8e },
	{ 0x6c45, 0x8e8c },
	{ 0x6c46, 0x8f5e },
	{ 0x6c47, 0x8f5b },
	{ 0x6c48, 0x8f5d },
	{ 0x6c49, 0x9146 },
	{ 0x6c4a, 0x9144 },
	{ 0x6c4b, 0x9145 },
	{ 0x6c4c, 0x91b9 },
	{ 0x6c4d, 0x943f },
	{ 0x6c4e, 0x943b },
	{ 0x6c4f, 0x9436 },
	{ 0x6c50, 0x9429 },
	{ 0x6c51, 0x943d },
	{ 0x6c52, 0x9430 },
	{ 0x6c53, 0x9439 },
	{ 0x6c54, 0x942a },
	{ 0x6c55, 0x9437 },
	{ 0x6c56, 0x942c },
	{ 0x6c57, 0x9440 },
	{ 0x6c58, 0x9431 },
	{ 0x6c59, 0x95e5 },
	{ 0x6c5a, 0x95e4 },
	{ 0x6c5b, 0x95e3 },
	{ 0x6c5c, 0x9735 },
	{ 0x6c5d, 0x973a },
	{ 0x6c5e, 0x97bf },
	{ 0x6c5f, 0x97e1 },
	{ 0x6c60, 0x9864 },
	{ 0x6c61, 0x98c9 },
	{ 0x6c62, 0x98c6 },
	{ 0x6c63, 0x98c0 },
	{ 0x6c64, 0x9958 },
	{ 0x6c65, 0x9956 },
	{ 0x6c66, 0x9a39 },
	{ 0x6c67, 0x9a3d },
	{ 0x6c68, 0x9a46 },
	{ 0x6c69, 0x9a44 },
	{ 0x6c6a, 0x9a42 },
	{ 0x6c6b, 0x9a41 },
	{ 0x6c6c, 0x9a3a },
	{ 0x6c6d, 0x9a3f },
	{ 0x6c6e, 0x9acd },
	{ 0x6c6f, 0x9b15 },
	{ 0x6c70, 0x9b17 },
	{ 0x6c71, 0x9b18 },
	{ 0x6c72, 0x9b16 },
	{ 0x6c73, 0x9b3a },
	{ 0x6c74, 0x9b52 },
	{ 0x6c75, 0x9c2b },
	{ 0x6c76, 0x9c1d },
	{ 0x6c77, 0x9c1c },
	{ 0x6c78, 0x9c2c },
	{ 0x6c79, 0x9c23 },
	{ 0x6c7a, 0x9c28 },
	{ 0x6c7b, 0x9c29 },
	{ 0x6c7c, 0x9c24 },
	{ 0x6c7d, 0x9c21 },
	{ 0x6c7e, 0x9db7 },
	{ 0x6d21, 0x9db6 },
	{ 0x6d22, 0x9dbc },
	{ 0x6d23, 0x9dc1 },
	{ 0x6d24, 0x9dc7 },
	{ 0x6d25, 0x9dca },
	{ 0x6d26, 0x9dcf },
	{ 0x6d27, 0x9dbe },
	{ 0x6d28, 0x9dc5 },
	{ 0x6d29, 0x9dc3 },
	{ 0x6d2a, 0x9dbb },
	{ 0x6d2b, 0x9db5 },
	{ 0x6d2c, 0x9dce },
	{ 0x6d2d, 0x9db9 },
	{ 0x6d2e, 0x9dba },
	{ 0x6d2f, 0x9dac },
	{ 0x6d30, 0x9dc8 },
	{ 0x6d31, 0x9db1 },
	{ 0x6d32, 0x9dad },
	{ 0x6d33, 0x9dcc },
	{ 0x6d34, 0x9db3 },
	{ 0x6d35, 0x9dcd },
	{ 0x6d36, 0x9db2 },
	{ 0x6d37, 0x9e7a },
	{ 0x6d38, 0x9e9c },
	{ 0x6d39, 0x9eeb },
	{ 0x6d3a, 0x9eee },
	{ 0x6d3b, 0x9eed },
	{ 0x6d3c, 0x9f1b },
	{ 0x6d3d, 0x9f18 },
	{ 0x6d3e, 0x9f1a },
	{ 0x6d3f, 0x9f31 },
	{ 0x6d40, 0x9f4e },
	{ 0x6d41, 0x9f65 },
	{ 0x6d42, 0x9f64 },
	{ 0x6d43, 0x9f92 },
	{ 0x6d44, 0x4eb9 },
	{ 0x6d45, 0x56c6 },
	{ 0x6d46, 0x56c5 },
	{ 0x6d47, 0x56cb },
	{ 0x6d48, 0x5971 },
	{ 0x6d49, 0x5b4b },
	{ 0x6d4a, 0x5b4c },
	{ 0x6d4b, 0x5dd5 },
	{ 0x6d4c, 0x5dd1 },
	{ 0x6d4d, 0x5ef2 },
	{ 0x6d4e, 0x6521 },
	{ 0x6d4f, 0x6520 },
	{ 0x6d50, 0x6526 },
	{ 0x6d51, 0x6522 },
	{ 0x6d52, 0x6b0b },
	{ 0x6d53, 0x6b08 },
	{ 0x6d54, 0x6b09 },
	{ 0x6d55, 0x6c0d },
	{ 0x6d56, 0x7055 },
	{ 0x6d57, 0x7056 },
	{ 0x6d58, 0x7057 },
	{ 0x6d59, 0x7052 },
	{ 0x6d5a, 0x721e },
	{ 0x6d5b, 0x721f },
	{ 0x6d5c, 0x72a9 },
	{ 0x6d5d, 0x737f },
	{ 0x6d5e, 0x74d8 },
	{ 0x6d5f, 0x74d5 },
	{ 0x6d60, 0x74d9 },
	{ 0x6d61, 0x74d7 },
	{ 0x6d62, 0x766d },
	{ 0x6d63, 0x76ad },
	{ 0x6d64, 0x7935 },
	{ 0x6d65, 0x79b4 },
	{ 0x6d66, 0x7a70 },
	{ 0x6d67, 0x7a71 },
	{ 0x6d68, 0x7c57 },
	{ 0x6d69, 0x7c5c },
	{ 0x6d6a, 0x7c59 },
	{ 0x6d6b, 0x7c5b },
	{ 0x6d6c, 0x7c5a },
	{ 0x6d6d, 0x7cf4 },
	{ 0x6d6e, 0x7cf1 },
	{ 0x6d6f, 0x7e91 },
	{ 0x6d70, 0x7f4f },
	{ 0x6d71, 0x7f87 },
	{ 0x6d72, 0x81de },
	{ 0x6d73, 0x826b },
	{ 0x6d74, 0x8634 },
	{ 0x6d75, 0x8635 },
	{ 0x6d76, 0x8633 },
	{ 0x6d77, 0x862c },
	{ 0x6d78, 0x8632 },
	{ 0x6d79, 0x8636 },
	{ 0x6d7a, 0x882c },
	{ 0x6d7b, 0x8828 },
	{ 0x6d7c, 0x8826 },
	{ 0x6d7d, 0x882a },
	{ 0x6d7e, 0x8825 },
	{ 0x6e21, 0x8971 },
	{ 0x6e22, 0x89bf },
	{ 0x6e23, 0x89be },
	{ 0x6e24, 0x89fb },
	{ 0x6e25, 0x8b7e },
	{ 0x6e26, 0x8b84 },
	{ 0x6e27, 0x8b82 },
	{ 0x6e28, 0x8b86 },
	{ 0x6e29, 0x8b85 },
	{ 0x6e2a, 0x8b7f },
	{ 0x6e2b, 0x8d15 },
	{ 0x6e2c, 0x8e95 },
	{ 0x6e2d, 0x8e94 },
	{ 0x6e2e, 0x8e9a },
	{ 0x6e2f, 0x8e92 },
	{ 0x6e30, 0x8e90 },
	{ 0x6e31, 0x8e96 },
	{ 0x6e32, 0x8e97 },
	{ 0x6e33, 0x8f60 },
	{ 0x6e34, 0x8f62 },
	{ 0x6e35, 0x9147 },
	{ 0x6e36, 0x944c },
	{ 0x6e37, 0x9450 },
	{ 0x6e38, 0x944a },
	{ 0x6e39, 0x944b },
	{ 0x6e3a, 0x944f },
	{ 0x6e3b, 0x9447 },
	{ 0x6e3c, 0x9445 },
	{ 0x6e3d, 0x9448 },
	{ 0x6e3e, 0x9449 },
	{ 0x6e3f, 0x9446 },
	{ 0x6e40, 0x973f },
	{ 0x6e41, 0x97e3 },
	{ 0x6e42, 0x986a },
	{ 0x6e43, 0x9869 },
	{ 0x6e44, 0x98cb },
	{ 0x6e45, 0x9954 },
	{ 0x6e46, 0x995b },
	{ 0x6e47, 0x9a4e },
	{ 0x6e48, 0x9a53 },
	{ 0x6e49, 0x9a54 },
	{ 0x6e4a, 0x9a4c },
	{ 0x6e4b, 0x9a4f },
	{ 0x6e4c, 0x9a48 },
	{ 0x6e4d, 0x9a4a },
	{ 0x6e4e, 0x9a49 },
	{ 0x6e4f, 0x9a52 },
	{ 0x6e50, 0x9a50 },
	{ 0x6e51, 0x9ad0 },
	{ 0x6e52, 0x9b19 },
	{ 0x6e53, 0x9b2b },
	{ 0x6e54, 0x9b3b },
	{ 0x6e55, 0x9b56 },
	{ 0x6e56, 0x9b55 },
	{ 0x6e57, 0x9c46 },
	{ 0x6e58, 0x9c48 },
	{ 0x6e59, 0x9c3f },
	{ 0x6e5a, 0x9c44 },
	{ 0x6e5b, 0x9c39 },
	{ 0x6e5c, 0x9c33 },
	{ 0x6e5d, 0x9c41 },
	{ 0x6e5e, 0x9c3c },
	{ 0x6e5f, 0x9c37 },
	{ 0x6e60, 0x9c34 },
	{ 0x6e61, 0x9c32 },
	{ 0x6e62, 0x9c3d },
	{ 0x6e63, 0x9c36 },
	{ 0x6e64, 0x9ddb },
	{ 0x6e65, 0x9dd2 },
	{ 0x6e66, 0x9dde },
	{ 0x6e67, 0x9dda },
	{ 0x6e68, 0x9dcb },
	{ 0x6e69, 0x9dd0 },
	{ 0x6e6a, 0x9ddc },
	{ 0x6e6b, 0x9dd1 },
	{ 0x6e6c, 0x9ddf },
	{ 0x6e6d, 0x9de9 },
	{ 0x6e6e, 0x9dd9 },
	{ 0x6e6f, 0x9dd8 },
	{ 0x6e70, 0x9dd6 },
	{ 0x6e71, 0x9df5 },
	{ 0x6e72, 0x9dd5 },
	{ 0x6e73, 0x9ddd },
	{ 0x6e74, 0x9eb6 },
	{ 0x6e75, 0x9ef0 },
	{ 0x6e76, 0x9f35 },
	{ 0x6e77, 0x9f33 },
	{ 0x6e78, 0x9f32 },
	{ 0x6e79, 0x9f42 },
	{ 0x6e7a, 0x9f6b },
	{ 0x6e7b, 0x9f95 },
	{ 0x6e7c, 0x9fa2 },
	{ 0x6e7d, 0x513d },
	{ 0x6e7e, 0x5299 },
	{ 0x6f21, 0x58e8 },
	{ 0x6f22, 0x58e7 },
	{ 0x6f23, 0x5972 },
	{ 0x6f24, 0x5b4d },
	{ 0x6f25, 0x5dd8 },
	{ 0x6f26, 0x882f },
	{ 0x6f27, 0x5f4f },
	{ 0x6f28, 0x6201 },
	{ 0x6f29, 0x6203 },
	{ 0x6f2a, 0x6204 },
	{ 0x6f2b, 0x6529 },
	{ 0x6f2c, 0x6525 },
	{ 0x6f2d, 0x6596 },
	{ 0x6f2e, 0x66eb },
	{ 0x6f2f, 0x6b11 },
	{ 0x6f30, 0x6b12 },
	{ 0x6f31, 0x6b0f },
	{ 0x6f32, 0x6bca },
	{ 0x6f33, 0x705b },
	{ 0x6f34, 0x705a },
	{ 0x6f35, 0x7222 },
	{ 0x6f36, 0x7382 },
	{ 0x6f37, 0x7381 },
	{ 0x6f38, 0x7383 },
	{ 0x6f39, 0x7670 },
	{ 0x6f3a, 0x77d4 },
	{ 0x6f3b, 0x7c67 },
	{ 0x6f3c, 0x7c66 },
	{ 0x6f3d, 0x7e95 },
	{ 0x6f3e, 0x826c },
	{ 0x6f3f, 0x863a },
	{ 0x6f40, 0x8640 },
	{ 0x6f41, 0x8639 },
	{ 0x6f42, 0x863c },
	{ 0x6f43, 0x8631 },
	{ 0x6f44, 0x863b },
	{ 0x6f45, 0x863e },
	{ 0x6f46, 0x8830 },
	{ 0x6f47, 0x8832 },
	{ 0x6f48, 0x882e },
	{ 0x6f49, 0x8833 },
	{ 0x6f4a, 0x8976 },
	{ 0x6f4b, 0x8974 },
	{ 0x6f4c, 0x8973 },
	{ 0x6f4d, 0x89fe },
	{ 0x6f4e, 0x8b8c },
	{ 0x6f4f, 0x8b8e },
	{ 0x6f50, 0x8b8b },
	{ 0x6f51, 0x8b88 },
	{ 0x6f52, 0x8c45 },
	{ 0x6f53, 0x8d19 },
	{ 0x6f54, 0x8e98 },
	{ 0x6f55, 0x8f64 },
	{ 0x6f56, 0x8f63 },
	{ 0x6f57, 0x91bc },
	{ 0x6f58, 0x9462 },
	{ 0x6f59, 0x9455 },
	{ 0x6f5a, 0x945d },
	{ 0x6f5b, 0x9457 },
	{ 0x6f5c, 0x945e },
	{ 0x6f5d, 0x97c4 },
	{ 0x6f5e, 0x97c5 },
	{ 0x6f5f, 0x9800 },
	{ 0x6f60, 0x9a56 },
	{ 0x6f61, 0x9a59 },
	{ 0x6f62, 0x9b1e },
	{ 0x6f63, 0x9b1f },
	{ 0x6f64, 0x9b20 },
	{ 0x6f65, 0x9c52 },
	{ 0x6f66, 0x9c58 },
	{ 0x6f67, 0x9c50 },
	{ 0x6f68, 0x9c4a },
	{ 0x6f69, 0x9c4d },
	{ 0x6f6a, 0x9c4b },
	{ 0x6f6b, 0x9c55 },
	{ 0x6f6c, 0x9c59 },
	{ 0x6f6d, 0x9c4c },
	{ 0x6f6e, 0x9c4e },
	{ 0x6f6f, 0x9dfb },
	{ 0x6f70, 0x9df7 },
	{ 0x6f71, 0x9def },
	{ 0x6f72, 0x9de3 },
	{ 0x6f73, 0x9deb },
	{ 0x6f74, 0x9df8 },
	{ 0x6f75, 0x9de4 },
	{ 0x6f76, 0x9df6 },
	{ 0x6f77, 0x9de1 },
	{ 0x6f78, 0x9dee },
	{ 0x6f79, 0x9de6 },
	{ 0x6f7a, 0x9df2 },
	{ 0x6f7b, 0x9df0 },
	{ 0x6f7c, 0x9de2 },
	{ 0x6f7d, 0x9dec },
	{ 0x6f7e, 0x9df4 },
	{ 0x7021, 0x9df3 },
	{ 0x7022, 0x9de8 },
	{ 0x7023, 0x9ded },
	{ 0x7024, 0x9ec2 },
	{ 0x7025, 0x9ed0 },
	{ 0x7026, 0x9ef2 },
	{ 0x7027, 0x9ef3 },
	{ 0x7028, 0x9f06 },
	{ 0x7029, 0x9f1c },
	{ 0x702a, 0x9f38 },
	{ 0x702b, 0x9f37 },
	{ 0x702c, 0x9f36 },
	{ 0x702d, 0x9f43 },
	{ 0x702e, 0x9f4f },
	{ 0x702f, 0x9f71 },
	{ 0x7030, 0x9f70 },
	{ 0x7031, 0x9f6e },
	{ 0x7032, 0x9f6f },
	{ 0x7033, 0x56d3 },
	{ 0x7034, 0x56cd },
	{ 0x7035, 0x5b4e },
	{ 0x7036, 0x5c6d },
	{ 0x7037, 0x652d },
	{ 0x7038, 0x66ed },
	{ 0x7039, 0x66ee },
	{ 0x703a, 0x6b13 },
	{ 0x703b, 0x705f },
	{ 0x703c, 0x7061 },
	{ 0x703d, 0x705d },
	{ 0x703e, 0x7060 },
	{ 0x703f, 0x7223 },
	{ 0x7040, 0x74db },
	{ 0x7041, 0x74e5 },
	{ 0x7042, 0x77d5 },
	{ 0x7043, 0x7938 },
	{ 0x7044, 0x79b7 },
	{ 0x7045, 0x79b6 },
	{ 0x7046, 0x7c6a },
	{ 0x7047, 0x7e97 },
	{ 0x7048, 0x7f89 },
	{ 0x7049, 0x826d },
	{ 0x704a, 0x8643 },
	{ 0x704b, 0x8838 },
	{ 0x704c, 0x8837 },
	{ 0x704d, 0x8835 },
	{ 0x704e, 0x884b },
	{ 0x704f, 0x8b94 },
	{ 0x7050, 0x8b95 },
	{ 0x7051, 0x8e9e },
	{ 0x7052, 0x8e9f },
	{ 0x7053, 0x8ea0 },
	{ 0x7054, 0x8e9d },
	{ 0x7055, 0x91be },
	{ 0x7056, 0x91bd },
	{ 0x7057, 0x91c2 },
	{ 0x7058, 0x946b },
	{ 0x7059, 0x9468 },
	{ 0x705a, 0x9469 },
	{ 0x705b, 0x96e5 },
	{ 0x705c, 0x9746 },
	{ 0x705d, 0x9743 },
	{ 0x705e, 0x9747 },
	{ 0x705f, 0x97c7 },
	{ 0x7060, 0x97e5 },
	{ 0x7061, 0x9a5e },
	{ 0x7062, 0x9ad5 },
	{ 0x7063, 0x9b59 },
	{ 0x7064, 0x9c63 },
	{ 0x7065, 0x9c67 },
	{ 0x7066, 0x9c66 },
	{ 0x7067, 0x9c62 },
	{ 0x7068, 0x9c5e },
	{ 0x7069, 0x9c60 },
	{ 0x706a, 0x9e02 },
	{ 0x706b, 0x9dfe },
	{ 0x706c, 0x9e07 },
	{ 0x706d, 0x9e03 },
	{ 0x706e, 0x9e06 },
	{ 0x706f, 0x9e05 },
	{ 0x7070, 0x9e00 },
	{ 0x7071, 0x9e01 },
	{ 0x7072, 0x9e09 },
	{ 0x7073, 0x9dff },
	{ 0x7074, 0x9dfd },
	{ 0x7075, 0x9e04 },
	{ 0x7076, 0x9ea0 },
	{ 0x7077, 0x9f1e },
	{ 0x7078, 0x9f46 },
	{ 0x7079, 0x9f74 },
	{ 0x707a, 0x9f75 },
	{ 0x707b, 0x9f76 },
	{ 0x707c, 0x56d4 },
	{ 0x707d, 0x652e },
	{ 0x707e, 0x65b8 },
	{ 0x7121, 0x6b18 },
	{ 0x7122, 0x6b19 },
	{ 0x7123, 0x6b17 },
	{ 0x7124, 0x6b1a },
	{ 0x7125, 0x7062 },
	{ 0x7126, 0x7226 },
	{ 0x7127, 0x72aa },
	{ 0x7128, 0x77d8 },
	{ 0x7129, 0x77d9 },
	{ 0x712a, 0x7939 },
	{ 0x712b, 0x7c69 },
	{ 0x712c, 0x7c6b },
	{ 0x712d, 0x7cf6 },
	{ 0x712e, 0x7e9a },
	{ 0x712f, 0x7e98 },
	{ 0x7130, 0x7e9b },
	{ 0x7131, 0x7e99 },
	{ 0x7132, 0x81e0 },
	{ 0x7133, 0x81e1 },
	{ 0x7134, 0x8646 },
	{ 0x7135, 0x8647 },
	{ 0x7136, 0x8648 },
	{ 0x7137, 0x8979 },
	{ 0x7138, 0x897a },
	{ 0x7139, 0x897c },
	{ 0x713a, 0x897b },
	{ 0x713b, 0x89ff },
	{ 0x713c, 0x8b98 },
	{ 0x713d, 0x8b99 },
	{ 0x713e, 0x8ea5 },
	{ 0x713f, 0x8ea4 },
	{ 0x7140, 0x8ea3 },
	{ 0x7141, 0x946e },
	{ 0x7142, 0x946d },
	{ 0x7143, 0x946f },
	{ 0x7144, 0x9471 },
	{ 0x7145, 0x9473 },
	{ 0x7146, 0x9749 },
	{ 0x7147, 0x9872 },
	{ 0x7148, 0x995f },
	{ 0x7149, 0x9c68 },
	{ 0x714a, 0x9c6e },
	{ 0x714b, 0x9c6d },
	{ 0x714c, 0x9e0b },
	{ 0x714d, 0x9e0d },
	{ 0x714e, 0x9e10 },
	{ 0x714f, 0x9e0f },
	{ 0x7150, 0x9e12 },
	{ 0x7151, 0x9e11 },
	{ 0x7152, 0x9ea1 },
	{ 0x7153, 0x9ef5 },
	{ 0x7154, 0x9f09 },
	{ 0x7155, 0x9f47 },
	{ 0x7156, 0x9f78 },
	{ 0x7157, 0x9f7b },
	{ 0x7158, 0x9f7a },
	{ 0x7159, 0x9f79 },
	{ 0x715a, 0x571e },
	{ 0x715b, 0x7066 },
	{ 0x715c, 0x7c6f },
	{ 0x715d, 0x883c },
	{ 0x715e, 0x8db2 },
	{ 0x715f, 0x8ea6 },
	{ 0x7160, 0x91c3 },
	{ 0x7161, 0x9474 },
	{ 0x7162, 0x9478 },
	{ 0x7163, 0x9476 },
	{ 0x7164, 0x9475 },
	{ 0x7165, 0x9a60 },
	{ 0x7166, 0x9b2e },
	{ 0x7167, 0x9c74 },
	{ 0x7168, 0x9c73 },
	{ 0x7169, 0x9c71 },
	{ 0x716a, 0x9c75 },
	{ 0x716b, 0x9e14 },
	{ 0x716c, 0x9e13 },
	{ 0x716d, 0x9ef6 },
	{ 0x716e, 0x9f0a },
	{ 0x716f, 0x9fa4 },
	{ 0x7170, 0x7068 },
	{ 0x7171, 0x7065 },
	{ 0x7172, 0x7cf7 },
	{ 0x7173, 0x866a },
	{ 0x7174, 0x883e },
	{ 0x7175, 0x883d },
	{ 0x7176, 0x883f },
	{ 0x7177, 0x8b9e },
	{ 0x7178, 0x8c9c },
	{ 0x7179, 0x8ea9 },
	{ 0x717a, 0x8ec9 },
	{ 0x717b, 0x974b },
	{ 0x717c, 0x9873 },
	{ 0x717d, 0x9874 },
	{ 0x717e, 0x98cc },
	{ 0x7221, 0x9961 },
	{ 0x7222, 0x99ab },
	{ 0x7223, 0x9a64 },
	{ 0x7224, 0x9a66 },
	{ 0x7225, 0x9a67 },
	{ 0x7226, 0x9b24 },
	{ 0x7227, 0x9e15 },
	{ 0x7228, 0x9e17 },
	{ 0x7229, 0x9f48 },
	{ 0x722a, 0x6207 },
	{ 0x722b, 0x6b1e },
	{ 0x722c, 0x7227 },
	{ 0x722d, 0x864c },
	{ 0x722e, 0x8ea8 },
	{ 0x722f, 0x9482 },
	{ 0x7230, 0x9480 },
	{ 0x7231, 0x9481 },
	{ 0x7232, 0x9a69 },
	{ 0x7233, 0x9a68 },
	{ 0x7234, 0x9e19 },
	{ 0x7235, 0x864b },
	{ 0x7236, 0x8b9f },
	{ 0x7237, 0x9483 },
	{ 0x7238, 0x9c79 },
	{ 0x7239, 0x9eb7 },
	{ 0x723a, 0x7675 },
	{ 0x723b, 0x9a6b },
	{ 0x723c, 0x9c7a },
	{ 0x723d, 0x9e1d },
	{ 0x723e, 0x7069 },
	{ 0x723f, 0x706a },
	{ 0x7240, 0x7229 },
	{ 0x7241, 0x9ea4 },
	{ 0x7242, 0x9f7e },
	{ 0x7243, 0x9f49 },
	{ 0x7244, 0x9f98 }
};

/* CNS 11643 plane #3, leave unicode (UTF8) to be -1 if no mapping available */
table_t cns3_utf_tab[MAX_CNS3_NUM] = {
	{ 0x2121, 0x4e28 },
	{ 0x2122, 0x4e36 },
	{ 0x2123, 0x4e3f },
	{ 0x2124, 0x4e85 },
	{ 0x2125, 0x4e05 },
	{ 0x2126, 0x4e04 },
	{ 0x2127, 0x5182 },
	{ 0x2128, 0x5196 },
	{ 0x2129, 0x5338 },
	{ 0x212a, 0x5369 },
	{ 0x212b, 0x53b6 },
	{ 0x212c, 0x4e2a },
	{ 0x212d, 0x4e87 },
	{ 0x212e, 0x4e49 },
	{ 0x212f, 0x51e2 },
	{ 0x2130, 0x4e46 },
	{ 0x2131, 0x4e8f },
	{ 0x2132, 0x4ebc },
	{ 0x2133, 0x4ebe },
	{ 0x2134, 0x5166 },
	{ 0x2135, 0x51e3 },
	{ 0x2136, 0x5204 },
	{ 0x2137, 0x529c },
	{ 0x2139, 0x5902 },
	{ 0x213a, 0x590a },
	{ 0x213b, 0x5b80 },
	{ 0x213c, 0x5ddb },
	{ 0x213d, 0x5e7a },
	{ 0x213e, 0x5e7f },
	{ 0x213f, 0x5ef4 },
	{ 0x2140, 0x5f50 },
	{ 0x2141, 0x5f51 },
	{ 0x2142, 0x5f61 },
	{ 0x2143, 0x961d },
	{ 0x2145, 0x4e63 },
	{ 0x2146, 0x4e62 },
	{ 0x2147, 0x4ea3 },
	{ 0x2148, 0x5185 },
	{ 0x2149, 0x4ec5 },
	{ 0x214a, 0x4ecf },
	{ 0x214b, 0x4ece },
	{ 0x214c, 0x4ecc },
	{ 0x214d, 0x5184 },
	{ 0x214e, 0x5186 },
	{ 0x2151, 0x51e4 },
	{ 0x2152, 0x5205 },
	{ 0x2153, 0x529e },
	{ 0x2154, 0x529d },
	{ 0x2155, 0x52fd },
	{ 0x2156, 0x5300 },
	{ 0x2157, 0x533a },
	{ 0x2159, 0x5346 },
	{ 0x215a, 0x535d },
	{ 0x215b, 0x5386 },
	{ 0x215c, 0x53b7 },
	{ 0x215e, 0x53cc },
	{ 0x2160, 0x53ce },
	{ 0x2161, 0x5721 },
	{ 0x2163, 0x5e00 },
	{ 0x2164, 0x5f0c },
	{ 0x2165, 0x6237 },
	{ 0x2166, 0x6238 },
	{ 0x2167, 0x6534 },
	{ 0x2168, 0x6535 },
	{ 0x2169, 0x65e0 },
	{ 0x216b, 0x738d },
	{ 0x216c, 0x4e97 },
	{ 0x216d, 0x4ee0 },
	{ 0x2170, 0x4ee7 },
	{ 0x2172, 0x4ee6 },
	{ 0x2177, 0x56d8 },
	{ 0x2178, 0x518b },
	{ 0x2179, 0x518c },
	{ 0x217a, 0x5199 },
	{ 0x217b, 0x51e5 },
	{ 0x217d, 0x520b },
	{ 0x2222, 0x5304 },
	{ 0x2223, 0x5303 },
	{ 0x2224, 0x5307 },
	{ 0x2226, 0x531e },
	{ 0x2227, 0x535f },
	{ 0x2228, 0x536d },
	{ 0x2229, 0x5389 },
	{ 0x222a, 0x53ba },
	{ 0x222b, 0x53d0 },
	{ 0x222d, 0x53f6 },
	{ 0x222e, 0x53f7 },
	{ 0x222f, 0x53f9 },
	{ 0x2231, 0x53f4 },
	{ 0x2234, 0x5724 },
	{ 0x2235, 0x5904 },
	{ 0x2236, 0x5918 },
	{ 0x2237, 0x5932 },
	{ 0x2238, 0x5930 },
	{ 0x2239, 0x5934 },
	{ 0x223b, 0x5975 },
	{ 0x223d, 0x5b82 },
	{ 0x223e, 0x5bf9 },
	{ 0x223f, 0x5c14 },
	{ 0x2247, 0x5e81 },
	{ 0x2248, 0x5e83 },
	{ 0x2249, 0x5f0d },
	{ 0x224a, 0x5f52 },
	{ 0x224c, 0x5fca },
	{ 0x224d, 0x5fc7 },
	{ 0x224e, 0x6239 },
	{ 0x2250, 0x624f },
	{ 0x2251, 0x65e7 },
	{ 0x2252, 0x672f },
	{ 0x2253, 0x6b7a },
	{ 0x2254, 0x6c39 },
	{ 0x2257, 0x6c37 },
	{ 0x2258, 0x6c44 },
	{ 0x2259, 0x6c45 },
	{ 0x225a, 0x738c },
	{ 0x225b, 0x7592 },
	{ 0x225c, 0x7676 },
	{ 0x225d, 0x9093 },
	{ 0x225e, 0x9092 },
	{ 0x2261, 0x4e21 },
	{ 0x2262, 0x4e20 },
	{ 0x2263, 0x4e22 },
	{ 0x2264, 0x4e68 },
	{ 0x2265, 0x4e89 },
	{ 0x2266, 0x4e98 },
	{ 0x2267, 0x4ef9 },
	{ 0x2268, 0x4eef },
	{ 0x226b, 0x4ef8 },
	{ 0x226c, 0x4f06 },
	{ 0x226d, 0x4f03 },
	{ 0x226e, 0x4efc },
	{ 0x226f, 0x4eee },
	{ 0x2270, 0x4f16 },
	{ 0x2272, 0x4f28 },
	{ 0x2273, 0x4f1c },
	{ 0x2274, 0x4f07 },
	{ 0x2275, 0x4f1a },
	{ 0x2276, 0x4efa },
	{ 0x2277, 0x4f17 },
	{ 0x2278, 0x514a },
	{ 0x227a, 0x5172 },
	{ 0x227c, 0x51b4 },
	{ 0x227d, 0x51b3 },
	{ 0x227e, 0x51b2 },
	{ 0x2322, 0x51e8 },
	{ 0x2324, 0x5214 },
	{ 0x2325, 0x520f },
	{ 0x2326, 0x5215 },
	{ 0x2327, 0x5218 },
	{ 0x2328, 0x52a8 },
	{ 0x232a, 0x534b },
	{ 0x232b, 0x534f },
	{ 0x232d, 0x5350 },
	{ 0x232f, 0x538b },
	{ 0x2331, 0x53be },
	{ 0x2333, 0x53d2 },
	{ 0x2334, 0x5416 },
	{ 0x2335, 0x53ff },
	{ 0x2337, 0x5400 },
	{ 0x2339, 0x5405 },
	{ 0x233a, 0x5413 },
	{ 0x233b, 0x5415 },
	{ 0x233e, 0x56e3 },
	{ 0x233f, 0x5735 },
	{ 0x2340, 0x5736 },
	{ 0x2341, 0x5731 },
	{ 0x2342, 0x5732 },
	{ 0x2343, 0x58ee },
	{ 0x2344, 0x5905 },
	{ 0x2345, 0x4e54 },
	{ 0x2347, 0x5936 },
	{ 0x234b, 0x597a },
	{ 0x234d, 0x5986 },
	{ 0x2350, 0x5b86 },
	{ 0x2351, 0x5f53 },
	{ 0x2352, 0x5c18 },
	{ 0x2354, 0x5c3d },
	{ 0x2355, 0x5c78 },
	{ 0x235a, 0x5c80 },
	{ 0x235c, 0x5e08 },
	{ 0x2361, 0x5ef5 },
	{ 0x2362, 0x5f0e },
	{ 0x2366, 0x5fd3 },
	{ 0x2367, 0x5fda },
	{ 0x2369, 0x5fdb },
	{ 0x236b, 0x620f },
	{ 0x236c, 0x625d },
	{ 0x236d, 0x625f },
	{ 0x236e, 0x6267 },
	{ 0x236f, 0x6257 },
	{ 0x2370, 0x9f50 },
	{ 0x2372, 0x65eb },
	{ 0x2373, 0x65ea },
	{ 0x2375, 0x6737 },
	{ 0x2377, 0x6732 },
	{ 0x2378, 0x6736 },
	{ 0x2379, 0x6b22 },
	{ 0x237a, 0x6bce },
	{ 0x237c, 0x6c58 },
	{ 0x237d, 0x6c51 },
	{ 0x237e, 0x6c77 },
	{ 0x2421, 0x6c3c },
	{ 0x2423, 0x6c5a },
	{ 0x2425, 0x6c53 },
	{ 0x2426, 0x706f },
	{ 0x2427, 0x7072 },
	{ 0x2428, 0x706e },
	{ 0x242b, 0x7073 },
	{ 0x242c, 0x72b1 },
	{ 0x242d, 0x72b2 },
	{ 0x242f, 0x738f },
	{ 0x2433, 0x793c },
	{ 0x2435, 0x808d },
	{ 0x2436, 0x808e },
	{ 0x2438, 0x827b },
	{ 0x243a, 0x8d71 },
	{ 0x243b, 0x8fb9 },
	{ 0x243c, 0x9096 },
	{ 0x243d, 0x909a },
	{ 0x243f, 0x4e24 },
	{ 0x2440, 0x4e71 },
	{ 0x2442, 0x4e9c },
	{ 0x2443, 0x4f45 },
	{ 0x2444, 0x4f4a },
	{ 0x2445, 0x4f39 },
	{ 0x2446, 0x4f37 },
	{ 0x2448, 0x4f32 },
	{ 0x2449, 0x4f42 },
	{ 0x244b, 0x4f44 },
	{ 0x244c, 0x4f4b },
	{ 0x244e, 0x4f40 },
	{ 0x244f, 0x4f35 },
	{ 0x2450, 0x4f31 },
	{ 0x2451, 0x5151 },
	{ 0x2453, 0x5150 },
	{ 0x2454, 0x514e },
	{ 0x2457, 0x519d },
	{ 0x2459, 0x51b5 },
	{ 0x245a, 0x51b8 },
	{ 0x245b, 0x51ec },
	{ 0x245c, 0x5223 },
	{ 0x245d, 0x5227 },
	{ 0x245e, 0x5226 },
	{ 0x245f, 0x521f },
	{ 0x2460, 0x522b },
	{ 0x2461, 0x5220 },
	{ 0x2462, 0x52b4 },
	{ 0x2463, 0x52b3 },
	{ 0x2465, 0x5325 },
	{ 0x2466, 0x533b },
	{ 0x2467, 0x5374 },
	{ 0x246d, 0x544d },
	{ 0x2470, 0x543a },
	{ 0x2473, 0x5444 },
	{ 0x2474, 0x544c },
	{ 0x2475, 0x5423 },
	{ 0x2476, 0x541a },
	{ 0x2477, 0x5432 },
	{ 0x2478, 0x544b },
	{ 0x2479, 0x5421 },
	{ 0x247b, 0x5434 },
	{ 0x247c, 0x5449 },
	{ 0x247d, 0x5450 },
	{ 0x247e, 0x5422 },
	{ 0x2521, 0x543f },
	{ 0x2522, 0x5451 },
	{ 0x2523, 0x545a },
	{ 0x2524, 0x542f },
	{ 0x2526, 0x56e9 },
	{ 0x2527, 0x56f2 },
	{ 0x2528, 0x56f3 },
	{ 0x2529, 0x56ef },
	{ 0x252a, 0x56ed },
	{ 0x252b, 0x56ec },
	{ 0x252c, 0x56e6 },
	{ 0x252d, 0x5748 },
	{ 0x252f, 0x5744 },
	{ 0x2530, 0x573f },
	{ 0x2531, 0x573c },
	{ 0x2532, 0x5753 },
	{ 0x2533, 0x5756 },
	{ 0x2535, 0x575f },
	{ 0x2536, 0x5743 },
	{ 0x2537, 0x5758 },
	{ 0x2538, 0x5757 },
	{ 0x253c, 0x5746 },
	{ 0x253e, 0x573d },
	{ 0x2540, 0x5742 },
	{ 0x2541, 0x5754 },
	{ 0x2542, 0x5755 },
	{ 0x2543, 0x58f1 },
	{ 0x2544, 0x58f2 },
	{ 0x2545, 0x58f0 },
	{ 0x2546, 0x590b },
	{ 0x2547, 0x9ea6 },
	{ 0x2548, 0x56f1 },
	{ 0x2549, 0x593d },
	{ 0x254b, 0x5994 },
	{ 0x254c, 0x598c },
	{ 0x254e, 0x599c },
	{ 0x2551, 0x599f },
	{ 0x2553, 0x599b },
	{ 0x2555, 0x5989 },
	{ 0x2556, 0x599a },
	{ 0x2558, 0x6588 },
	{ 0x255a, 0x5b8d },
	{ 0x255c, 0x5bfe },
	{ 0x255d, 0x5bff },
	{ 0x255e, 0x5bfd },
	{ 0x255f, 0x5c2b },
	{ 0x2561, 0x5c84 },
	{ 0x2562, 0x5c8e },
	{ 0x2563, 0x5c9c },
	{ 0x2566, 0x5c85 },
	{ 0x2567, 0x5df5 },
	{ 0x2568, 0x5e09 },
	{ 0x256b, 0x5e0b },
	{ 0x256d, 0x5e92 },
	{ 0x256e, 0x5e90 },
	{ 0x256f, 0x5f03 },
	{ 0x2571, 0x5f1e },
	{ 0x2572, 0x5f63 },
	{ 0x2574, 0x5fe7 },
	{ 0x2575, 0x5ffe },
	{ 0x2576, 0x5fe6 },
	{ 0x2577, 0x5fdc },
	{ 0x2578, 0x5fce },
	{ 0x257a, 0x5ffc },
	{ 0x257b, 0x5fdf },
	{ 0x257c, 0x5fec },
	{ 0x257d, 0x5ff6 },
	{ 0x2621, 0x5ff2 },
	{ 0x2622, 0x5ff0 },
	{ 0x2623, 0x5ff9 },
	{ 0x2625, 0x6213 },
	{ 0x2628, 0x623b },
	{ 0x2629, 0x623c },
	{ 0x262a, 0x6282 },
	{ 0x262e, 0x6278 },
	{ 0x262f, 0x628b },
	{ 0x2631, 0x629e },
	{ 0x2632, 0x62a5 },
	{ 0x2633, 0x629b },
	{ 0x2634, 0x629c },
	{ 0x2635, 0x6299 },
	{ 0x2636, 0x628d },
	{ 0x2637, 0x6285 },
	{ 0x2638, 0x629d },
	{ 0x2639, 0x6275 },
	{ 0x263d, 0x65f6 },
	{ 0x2641, 0x66f5 },
	{ 0x2642, 0x675b },
	{ 0x2644, 0x6754 },
	{ 0x2645, 0x6752 },
	{ 0x2647, 0x6758 },
	{ 0x2648, 0x6744 },
	{ 0x2649, 0x674a },
	{ 0x264a, 0x6761 },
	{ 0x264c, 0x6c7f },
	{ 0x264d, 0x6c91 },
	{ 0x264e, 0x6c9e },
	{ 0x2650, 0x6c6e },
	{ 0x2651, 0x6c7c },
	{ 0x2652, 0x6c9f },
	{ 0x2653, 0x6c75 },
	{ 0x2655, 0x6c56 },
	{ 0x2656, 0x6ca2 },
	{ 0x2657, 0x6c79 },
	{ 0x2659, 0x6ca1 },
	{ 0x265b, 0x6caa },
	{ 0x265c, 0x6ca0 },
	{ 0x265e, 0x7079 },
	{ 0x265f, 0x7077 },
	{ 0x2660, 0x707e },
	{ 0x2662, 0x7075 },
	{ 0x2663, 0x707b },
	{ 0x2664, 0x7264 },
	{ 0x2666, 0x72bb },
	{ 0x2667, 0x72bc },
	{ 0x2668, 0x72c7 },
	{ 0x2669, 0x72b9 },
	{ 0x266a, 0x72be },
	{ 0x266b, 0x72b6 },
	{ 0x266e, 0x7398 },
	{ 0x2673, 0x7593 },
	{ 0x2674, 0x7680 },
	{ 0x2676, 0x7683 },
	{ 0x2677, 0x76c0 },
	{ 0x2678, 0x76c1 },
	{ 0x267b, 0x77f4 },
	{ 0x267c, 0x77f5 },
	{ 0x267e, 0x7acc },
	{ 0x2721, 0x7acd },
	{ 0x2722, 0x7cfa },
	{ 0x2723, 0x809f },
	{ 0x2724, 0x8091 },
	{ 0x2725, 0x8097 },
	{ 0x2726, 0x8094 },
	{ 0x2728, 0x8286 },
	{ 0x2729, 0x828c },
	{ 0x272b, 0x8295 },
	{ 0x272d, 0x866c },
	{ 0x272f, 0x8fb5 },
	{ 0x2730, 0x8fbe },
	{ 0x2731, 0x8fc7 },
	{ 0x2733, 0x8fc1 },
	{ 0x2734, 0x90a9 },
	{ 0x2735, 0x90a4 },
	{ 0x2739, 0x90a8 },
	{ 0x273a, 0x9627 },
	{ 0x273b, 0x9626 },
	{ 0x273c, 0x962b },
	{ 0x273d, 0x9633 },
	{ 0x273e, 0x9634 },
	{ 0x273f, 0x9629 },
	{ 0x2740, 0x4e3d },
	{ 0x2742, 0x4e9d },
	{ 0x2743, 0x4f93 },
	{ 0x2744, 0x4f8a },
	{ 0x2747, 0x4f6d },
	{ 0x2748, 0x4f8e },
	{ 0x2749, 0x4fa0 },
	{ 0x274a, 0x4fa2 },
	{ 0x274b, 0x4fa1 },
	{ 0x274c, 0x4f9f },
	{ 0x274d, 0x4fa3 },
	{ 0x274f, 0x4f72 },
	{ 0x2751, 0x4f8c },
	{ 0x2752, 0x5156 },
	{ 0x2755, 0x5190 },
	{ 0x2759, 0x51ed },
	{ 0x275a, 0x51fe },
	{ 0x275b, 0x522f },
	{ 0x275d, 0x523c },
	{ 0x275e, 0x5234 },
	{ 0x275f, 0x5239 },
	{ 0x2760, 0x52b9 },
	{ 0x2761, 0x52b5 },
	{ 0x2762, 0x52bf },
	{ 0x2763, 0x5355 },
	{ 0x2765, 0x5376 },
	{ 0x2766, 0x537a },
	{ 0x2767, 0x5393 },
	{ 0x2769, 0x53c1 },
	{ 0x276a, 0x53c2 },
	{ 0x276b, 0x53d5 },
	{ 0x276c, 0x5485 },
	{ 0x276e, 0x545f },
	{ 0x276f, 0x5493 },
	{ 0x2770, 0x5489 },
	{ 0x2771, 0x5479 },
	{ 0x2772, 0x9efe },
	{ 0x2773, 0x548f },
	{ 0x2774, 0x5469 },
	{ 0x2775, 0x546d },
	{ 0x2777, 0x5494 },
	{ 0x2778, 0x546a },
	{ 0x2779, 0x548a },
	{ 0x277b, 0x56fd },
	{ 0x277c, 0x56fb },
	{ 0x277d, 0x56f8 },
	{ 0x2821, 0x56fc },
	{ 0x2822, 0x56f6 },
	{ 0x2823, 0x5765 },
	{ 0x2824, 0x5781 },
	{ 0x2825, 0x5763 },
	{ 0x2826, 0x5767 },
	{ 0x2828, 0x576e },
	{ 0x2829, 0x5778 },
	{ 0x282a, 0x577f },
	{ 0x282d, 0x58f3 },
	{ 0x282e, 0x594b },
	{ 0x282f, 0x594c },
	{ 0x2833, 0x59ad },
	{ 0x2835, 0x59c4 },
	{ 0x2837, 0x59c2 },
	{ 0x2838, 0x59b0 },
	{ 0x283d, 0x59bf },
	{ 0x283f, 0x59c9 },
	{ 0x2840, 0x59b8 },
	{ 0x2841, 0x59ac },
	{ 0x2845, 0x59b7 },
	{ 0x2846, 0x59d7 },
	{ 0x2848, 0x5b60 },
	{ 0x284a, 0x5b96 },
	{ 0x284b, 0x5b9e },
	{ 0x284c, 0x5b94 },
	{ 0x284d, 0x5b9f },
	{ 0x284e, 0x5b9d },
	{ 0x2850, 0x5c00 },
	{ 0x2851, 0x5c19 },
	{ 0x2854, 0x5c49 },
	{ 0x2855, 0x5c4a },
	{ 0x2857, 0x5cbb },
	{ 0x2858, 0x5cc1 },
	{ 0x285c, 0x5cb9 },
	{ 0x285d, 0x5c9e },
	{ 0x285e, 0x5cb4 },
	{ 0x285f, 0x5cba },
	{ 0x2860, 0x5df6 },
	{ 0x2861, 0x5e13 },
	{ 0x2862, 0x5e12 },
	{ 0x2863, 0x5e77 },
	{ 0x2865, 0x5e98 },
	{ 0x2867, 0x5e99 },
	{ 0x2868, 0x5e9d },
	{ 0x2869, 0x5ef8 },
	{ 0x286b, 0x5ef9 },
	{ 0x286d, 0x5f06 },
	{ 0x286e, 0x5f21 },
	{ 0x2870, 0x5f25 },
	{ 0x2871, 0x5f55 },
	{ 0x2875, 0x5f84 },
	{ 0x2876, 0x5f83 },
	{ 0x2877, 0x6030 },
	{ 0x2878, 0x6007 },
	{ 0x287a, 0x6036 },
	{ 0x287e, 0x5fe9 },
	{ 0x2921, 0x603d },
	{ 0x2922, 0x6008 },
	{ 0x2925, 0x62ba },
	{ 0x2926, 0x62b2 },
	{ 0x2928, 0x62b7 },
	{ 0x2929, 0x62e4 },
	{ 0x292a, 0x62a7 },
	{ 0x292e, 0x62d5 },
	{ 0x292f, 0x62e1 },
	{ 0x2930, 0x62dd },
	{ 0x2931, 0x62a6 },
	{ 0x2932, 0x62c1 },
	{ 0x2933, 0x62c5 },
	{ 0x2934, 0x62c0 },
	{ 0x2935, 0x62df },
	{ 0x2936, 0x62e0 },
	{ 0x2937, 0x62de },
	{ 0x2939, 0x6589 },
	{ 0x293b, 0x65a6 },
	{ 0x293c, 0x65ba },
	{ 0x293e, 0x65ff },
	{ 0x2940, 0x6617 },
	{ 0x2941, 0x6618 },
	{ 0x2942, 0x6601 },
	{ 0x2943, 0x65fe },
	{ 0x2945, 0x670c },
	{ 0x2947, 0x676b },
	{ 0x2948, 0x6796 },
	{ 0x2949, 0x6782 },
	{ 0x294a, 0x678a },
	{ 0x294c, 0x67a3 },
	{ 0x294e, 0x67a2 },
	{ 0x294f, 0x678f },
	{ 0x2951, 0x67f9 },
	{ 0x2952, 0x6780 },
	{ 0x2953, 0x6b26 },
	{ 0x2954, 0x6b27 },
	{ 0x2955, 0x6b68 },
	{ 0x2956, 0x6b69 },
	{ 0x2958, 0x6b81 },
	{ 0x2959, 0x6bb4 },
	{ 0x295a, 0x6bd1 },
	{ 0x295d, 0x6c1c },
	{ 0x2963, 0x6c97 },
	{ 0x2964, 0x6c6c },
	{ 0x2965, 0x6cdf },
	{ 0x2967, 0x6cea },
	{ 0x2969, 0x6ce4 },
	{ 0x296a, 0x6cd8 },
	{ 0x296b, 0x6cb2 },
	{ 0x296c, 0x6cce },
	{ 0x296d, 0x6cc8 },
	{ 0x296f, 0x708b },
	{ 0x2970, 0x7088 },
	{ 0x2971, 0x7090 },
	{ 0x2972, 0x708f },
	{ 0x2974, 0x7087 },
	{ 0x2975, 0x7089 },
	{ 0x2976, 0x708d },
	{ 0x2977, 0x7081 },
	{ 0x2979, 0x708c },
	{ 0x297c, 0x7240 },
	{ 0x2a21, 0x7265 },
	{ 0x2a22, 0x7266 },
	{ 0x2a23, 0x7268 },
	{ 0x2a26, 0x72cd },
	{ 0x2a27, 0x72d3 },
	{ 0x2a28, 0x72db },
	{ 0x2a2a, 0x72cf },
	{ 0x2a2b, 0x73a7 },
	{ 0x2a2c, 0x73a3 },
	{ 0x2a2d, 0x739e },
	{ 0x2a2f, 0x73af },
	{ 0x2a32, 0x73aa },
	{ 0x2a33, 0x739c },
	{ 0x2a35, 0x7542 },
	{ 0x2a36, 0x7544 },
	{ 0x2a37, 0x753b },
	{ 0x2a38, 0x7541 },
	{ 0x2a3a, 0x759b },
	{ 0x2a3b, 0x759e },
	{ 0x2a3d, 0x79c4 },
	{ 0x2a3e, 0x79c3 },
	{ 0x2a3f, 0x79c6 },
	{ 0x2a42, 0x79c7 },
	{ 0x2a44, 0x79ca },
	{ 0x2a47, 0x7acf },
	{ 0x2a48, 0x7c76 },
	{ 0x2a49, 0x7c74 },
	{ 0x2a4a, 0x7cff },
	{ 0x2a4b, 0x7cfc },
	{ 0x2a4e, 0x7f59 },
	{ 0x2a4f, 0x80a8 },
	{ 0x2a52, 0x80b0 },
	{ 0x2a54, 0x80b3 },
	{ 0x2a56, 0x80a4 },
	{ 0x2a57, 0x80b6 },
	{ 0x2a58, 0x80a7 },
	{ 0x2a59, 0x80ac },
	{ 0x2a5b, 0x80a6 },
	{ 0x2a5c, 0x5367 },
	{ 0x2a5d, 0x820e },
	{ 0x2a5e, 0x82c4 },
	{ 0x2a5f, 0x833e },
	{ 0x2a60, 0x829c },
	{ 0x2a66, 0x82aa },
	{ 0x2a68, 0x82c9 },
	{ 0x2a6b, 0x82a6 },
	{ 0x2a6c, 0x82b2 },
	{ 0x2a70, 0x8fcc },
	{ 0x2a71, 0x8fd9 },
	{ 0x2a72, 0x8fca },
	{ 0x2a73, 0x8fd8 },
	{ 0x2a74, 0x8fcf },
	{ 0x2a75, 0x90b7 },
	{ 0x2a77, 0x90ad },
	{ 0x2a78, 0x90b9 },
	{ 0x2a79, 0x9637 },
	{ 0x2a7b, 0x9641 },
	{ 0x2a7c, 0x963e },
	{ 0x2a7d, 0x96b6 },
	{ 0x2a7e, 0x9751 },
	{ 0x2b21, 0x9763 },
	{ 0x2b22, 0x4e57 },
	{ 0x2b23, 0x4e79 },
	{ 0x2b24, 0x4eb2 },
	{ 0x2b25, 0x4eb0 },
	{ 0x2b26, 0x4eaf },
	{ 0x2b27, 0x4eb1 },
	{ 0x2b28, 0x4fd2 },
	{ 0x2b29, 0x4fd5 },
	{ 0x2b2b, 0x4fbe },
	{ 0x2b2c, 0x4fb8 },
	{ 0x2b2d, 0x4fb0 },
	{ 0x2b2e, 0x4fb1 },
	{ 0x2b2f, 0x4fc8 },
	{ 0x2b32, 0x4fc6 },
	{ 0x2b33, 0x4fcc },
	{ 0x2b34, 0x4fe5 },
	{ 0x2b35, 0x4fe3 },
	{ 0x2b36, 0x4fb4 },
	{ 0x2b37, 0x516a },
	{ 0x2b39, 0x519f },
	{ 0x2b3b, 0x51c1 },
	{ 0x2b3d, 0x51c2 },
	{ 0x2b3e, 0x51c3 },
	{ 0x2b3f, 0x5245 },
	{ 0x2b40, 0x5248 },
	{ 0x2b43, 0x524f },
	{ 0x2b46, 0x52c5 },
	{ 0x2b47, 0x52ca },
	{ 0x2b48, 0x52c4 },
	{ 0x2b49, 0x5327 },
	{ 0x2b4a, 0x5358 },
	{ 0x2b4b, 0x537d },
	{ 0x2b4d, 0x53dd },
	{ 0x2b4e, 0x53dc },
	{ 0x2b4f, 0x53da },
	{ 0x2b50, 0x53d9 },
	{ 0x2b51, 0x54b9 },
	{ 0x2b53, 0x54d0 },
	{ 0x2b54, 0x54b4 },
	{ 0x2b55, 0x54ca },
	{ 0x2b57, 0x54a3 },
	{ 0x2b58, 0x54da },
	{ 0x2b59, 0x54a4 },
	{ 0x2b5b, 0x54b2 },
	{ 0x2b5c, 0x549e },
	{ 0x2b5d, 0x549f },
	{ 0x2b5e, 0x54b5 },
	{ 0x2b61, 0x54cd },
	{ 0x2b63, 0x54cc },
	{ 0x2b65, 0x5700 },
	{ 0x2b66, 0x57ac },
	{ 0x2b67, 0x5791 },
	{ 0x2b68, 0x578e },
	{ 0x2b69, 0x578d },
	{ 0x2b6a, 0x5792 },
	{ 0x2b6b, 0x57a1 },
	{ 0x2b6c, 0x5790 },
	{ 0x2b6d, 0x57a6 },
	{ 0x2b6e, 0x57a8 },
	{ 0x2b70, 0x579c },
	{ 0x2b71, 0x5796 },
	{ 0x2b72, 0x57a7 },
	{ 0x2b77, 0x58f5 },
	{ 0x2b79, 0x5909 },
	{ 0x2b7a, 0x5908 },
	{ 0x2b7c, 0x5952 },
	{ 0x2c21, 0x59df },
	{ 0x2c23, 0x59eb },
	{ 0x2c24, 0x59ef },
	{ 0x2c25, 0x59f0 },
	{ 0x2c26, 0x59d5 },
	{ 0x2c27, 0x5a0d },
	{ 0x2c28, 0x5a04 },
	{ 0x2c29, 0x59f9 },
	{ 0x2c2a, 0x5a02 },
	{ 0x2c2b, 0x59f8 },
	{ 0x2c2c, 0x59e2 },
	{ 0x2c2d, 0x59d9 },
	{ 0x2c2e, 0x59e7 },
	{ 0x2c2f, 0x5b6a },
	{ 0x2c32, 0x5bab },
	{ 0x2c34, 0x5c1b },
	{ 0x2c35, 0x5c2f },
	{ 0x2c37, 0x663c },
	{ 0x2c3b, 0x5cd1 },
	{ 0x2c3c, 0x5cdc },
	{ 0x2c3d, 0x5ce6 },
	{ 0x2c3e, 0x5ce1 },
	{ 0x2c3f, 0x5ccd },
	{ 0x2c41, 0x5ce2 },
	{ 0x2c42, 0x5cdd },
	{ 0x2c43, 0x5ce5 },
	{ 0x2c44, 0x5dfb },
	{ 0x2c45, 0x5dfa },
	{ 0x2c46, 0x5e1e },
	{ 0x2c48, 0x5ea1 },
	{ 0x2c4b, 0x5efc },
	{ 0x2c4c, 0x5efb },
	{ 0x2c4d, 0x5f2f },
	{ 0x2c50, 0x5f66 },
	{ 0x2c54, 0x605c },
	{ 0x2c56, 0x604e },
	{ 0x2c57, 0x6051 },
	{ 0x2c5a, 0x6023 },
	{ 0x2c5b, 0x6031 },
	{ 0x2c5c, 0x607c },
	{ 0x2c5d, 0x6052 },
	{ 0x2c5f, 0x6060 },
	{ 0x2c60, 0x604a },
	{ 0x2c61, 0x6061 },
	{ 0x2c63, 0x6218 },
	{ 0x2c6b, 0x631f },
	{ 0x2c6c, 0x6317 },
	{ 0x2c6d, 0x62ea },
	{ 0x2c6e, 0x6321 },
	{ 0x2c6f, 0x6304 },
	{ 0x2c70, 0x6305 },
	{ 0x2c72, 0x6531 },
	{ 0x2c73, 0x6544 },
	{ 0x2c74, 0x6540 },
	{ 0x2c76, 0x6542 },
	{ 0x2c77, 0x65be },
	{ 0x2c79, 0x6629 },
	{ 0x2c7a, 0x661b },
	{ 0x2c7c, 0x6623 },
	{ 0x2c7d, 0x662c },
	{ 0x2c7e, 0x661a },
	{ 0x2d21, 0x6630 },
	{ 0x2d22, 0x663b },
	{ 0x2d23, 0x661e },
	{ 0x2d24, 0x6637 },
	{ 0x2d25, 0x6638 },
	{ 0x2d27, 0x670e },
	{ 0x2d2a, 0x67e8 },
	{ 0x2d2b, 0x67d6 },
	{ 0x2d2d, 0x67c7 },
	{ 0x2d2e, 0x67bc },
	{ 0x2d2f, 0x6852 },
	{ 0x2d30, 0x67bf },
	{ 0x2d31, 0x67d5 },
	{ 0x2d32, 0x67fe },
	{ 0x2d33, 0x8363 },
	{ 0x2d34, 0x67fb },
	{ 0x2d36, 0x67b1 },
	{ 0x2d37, 0x6801 },
	{ 0x2d38, 0x6805 },
	{ 0x2d39, 0x6800 },
	{ 0x2d3a, 0x67d7 },
	{ 0x2d3c, 0x6b2a },
	{ 0x2d3d, 0x6b6b },
	{ 0x2d42, 0x6be1 },
	{ 0x2d45, 0x6d23 },
	{ 0x2d46, 0x6cff },
	{ 0x2d47, 0x6d14 },
	{ 0x2d48, 0x6d05 },
	{ 0x2d49, 0x6d13 },
	{ 0x2d4a, 0x6d06 },
	{ 0x2d4b, 0x6d21 },
	{ 0x2d4d, 0x6d15 },
	{ 0x2d4e, 0x6caf },
	{ 0x2d4f, 0x6cf4 },
	{ 0x2d50, 0x6d02 },
	{ 0x2d51, 0x6d45 },
	{ 0x2d53, 0x6d26 },
	{ 0x2d55, 0x6d44 },
	{ 0x2d57, 0x6d24 },
	{ 0x2d58, 0x70a5 },
	{ 0x2d5a, 0x70a3 },
	{ 0x2d5c, 0x70a2 },
	{ 0x2d5d, 0x70bb },
	{ 0x2d5e, 0x70a0 },
	{ 0x2d5f, 0x70aa },
	{ 0x2d62, 0x70a8 },
	{ 0x2d63, 0x70b6 },
	{ 0x2d64, 0x70b2 },
	{ 0x2d65, 0x70a7 },
	{ 0x2d68, 0x70b9 },
	{ 0x2d69, 0x722e },
	{ 0x2d6b, 0x723c },
	{ 0x2d6d, 0x726d },
	{ 0x2d70, 0x72e7 },
	{ 0x2d71, 0x72ed },
	{ 0x2d73, 0x72ec },
	{ 0x2d74, 0x72e5 },
	{ 0x2d75, 0x72e2 },
	{ 0x2d77, 0x73c4 },
	{ 0x2d78, 0x73bd },
	{ 0x2d79, 0x73cf },
	{ 0x2d7a, 0x73c9 },
	{ 0x2d7b, 0x73c1 },
	{ 0x2d7c, 0x73d0 },
	{ 0x2d7e, 0x73ce },
	{ 0x2e21, 0x74ed },
	{ 0x2e22, 0x74eb },
	{ 0x2e24, 0x74ef },
	{ 0x2e25, 0x7549 },
	{ 0x2e26, 0x7550 },
	{ 0x2e27, 0x7546 },
	{ 0x2e28, 0x754a },
	{ 0x2e2a, 0x754d },
	{ 0x2e2b, 0x75a6 },
	{ 0x2e2f, 0x75a8 },
	{ 0x2e32, 0x76c7 },
	{ 0x2e33, 0x76ff },
	{ 0x2e35, 0x76fd },
	{ 0x2e36, 0x77e6 },
	{ 0x2e37, 0x780a },
	{ 0x2e39, 0x7804 },
	{ 0x2e3a, 0x780b },
	{ 0x2e3b, 0x7807 },
	{ 0x2e3d, 0x7815 },
	{ 0x2e3e, 0x7808 },
	{ 0x2e40, 0x79d3 },
	{ 0x2e41, 0x79d4 },
	{ 0x2e42, 0x79d0 },
	{ 0x2e43, 0x79d7 },
	{ 0x2e44, 0x7a7c },
	{ 0x2e47, 0x7a7d },
	{ 0x2e48, 0x7a83 },
	{ 0x2e49, 0x7a82 },
	{ 0x2e4b, 0x7ad4 },
	{ 0x2e4c, 0x7ad5 },
	{ 0x2e4d, 0x7ad3 },
	{ 0x2e4e, 0x7ad0 },
	{ 0x2e4f, 0x7ad2 },
	{ 0x2e50, 0x7afe },
	{ 0x2e51, 0x7afc },
	{ 0x2e52, 0x7c77 },
	{ 0x2e53, 0x7c7c },
	{ 0x2e54, 0x7c7b },
	{ 0x2e5d, 0x7f8f },
	{ 0x2e5e, 0x80d3 },
	{ 0x2e60, 0x80cb },
	{ 0x2e61, 0x80d2 },
	{ 0x2e63, 0x8109 },
	{ 0x2e64, 0x80e2 },
	{ 0x2e65, 0x80df },
	{ 0x2e66, 0x80c6 },
	{ 0x2e68, 0x8224 },
	{ 0x2e69, 0x82f7 },
	{ 0x2e6a, 0x82d8 },
	{ 0x2e6b, 0x82dd },
	{ 0x2e6e, 0x82f8 },
	{ 0x2e6f, 0x82fc },
	{ 0x2e72, 0x82e9 },
	{ 0x2e74, 0x82ee },
	{ 0x2e76, 0x82d0 },
	{ 0x2e77, 0x830e },
	{ 0x2e78, 0x82e2 },
	{ 0x2e79, 0x830b },
	{ 0x2e7a, 0x82fd },
	{ 0x2e7b, 0x5179 },
	{ 0x2e7c, 0x8676 },
	{ 0x2e7e, 0x8678 },
	{ 0x2f23, 0x8675 },
	{ 0x2f24, 0x867d },
	{ 0x2f26, 0x8842 },
	{ 0x2f27, 0x8866 },
	{ 0x2f29, 0x898c },
	{ 0x2f2a, 0x8a05 },
	{ 0x2f2c, 0x8a06 },
	{ 0x2f2e, 0x8c9f },
	{ 0x2f30, 0x8ff1 },
	{ 0x2f31, 0x8fe7 },
	{ 0x2f32, 0x8fe9 },
	{ 0x2f33, 0x8fef },
	{ 0x2f34, 0x90c2 },
	{ 0x2f35, 0x90bc },
	{ 0x2f37, 0x90c6 },
	{ 0x2f38, 0x90c0 },
	{ 0x2f3b, 0x90cd },
	{ 0x2f3c, 0x90c9 },
	{ 0x2f3e, 0x90c4 },
	{ 0x2f40, 0x9581 },
	{ 0x2f42, 0x9cec },
	{ 0x2f43, 0x5032 },
	{ 0x2f44, 0x4ff9 },
	{ 0x2f45, 0x501d },
	{ 0x2f46, 0x4fff },
	{ 0x2f47, 0x5004 },
	{ 0x2f48, 0x4ff0 },
	{ 0x2f49, 0x5003 },
	{ 0x2f4b, 0x5002 },
	{ 0x2f4c, 0x4ffc },
	{ 0x2f4d, 0x4ff2 },
	{ 0x2f4e, 0x5024 },
	{ 0x2f4f, 0x5008 },
	{ 0x2f50, 0x5036 },
	{ 0x2f51, 0x502e },
	{ 0x2f53, 0x5010 },
	{ 0x2f54, 0x5038 },
	{ 0x2f55, 0x5039 },
	{ 0x2f56, 0x4ffd },
	{ 0x2f57, 0x5056 },
	{ 0x2f58, 0x4ffb },
	{ 0x2f59, 0x51a3 },
	{ 0x2f5a, 0x51a6 },
	{ 0x2f5b, 0x51a1 },
	{ 0x2f5e, 0x51c7 },
	{ 0x2f5f, 0x51c9 },
	{ 0x2f60, 0x5260 },
	{ 0x2f61, 0x5264 },
	{ 0x2f62, 0x5259 },
	{ 0x2f63, 0x5265 },
	{ 0x2f64, 0x5267 },
	{ 0x2f65, 0x5257 },
	{ 0x2f66, 0x5263 },
	{ 0x2f68, 0x5253 },
	{ 0x2f6a, 0x52cf },
	{ 0x2f6c, 0x52ce },
	{ 0x2f6d, 0x52d0 },
	{ 0x2f6e, 0x52d1 },
	{ 0x2f6f, 0x52cc },
	{ 0x2f73, 0x550d },
	{ 0x2f74, 0x54f4 },
	{ 0x2f76, 0x5513 },
	{ 0x2f77, 0x54ef },
	{ 0x2f78, 0x54f5 },
	{ 0x2f79, 0x54f9 },
	{ 0x2f7a, 0x5502 },
	{ 0x2f7b, 0x5500 },
	{ 0x2f7e, 0x5518 },
	{ 0x3021, 0x54f0 },
	{ 0x3022, 0x54f6 },
	{ 0x3025, 0x5519 },
	{ 0x3027, 0x5705 },
	{ 0x3028, 0x57c9 },
	{ 0x302a, 0x57b7 },
	{ 0x302b, 0x57cd },
	{ 0x302f, 0x57be },
	{ 0x3030, 0x57bb },
	{ 0x3032, 0x57db },
	{ 0x3033, 0x57c8 },
	{ 0x3034, 0x57c4 },
	{ 0x3035, 0x57c5 },
	{ 0x3036, 0x57d1 },
	{ 0x3037, 0x57ca },
	{ 0x3038, 0x57c0 },
	{ 0x303b, 0x5a21 },
	{ 0x303c, 0x5a2a },
	{ 0x303e, 0x5a1d },
	{ 0x3040, 0x5a0b },
	{ 0x3045, 0x5a22 },
	{ 0x3048, 0x5a24 },
	{ 0x304a, 0x5a14 },
	{ 0x304b, 0x5a31 },
	{ 0x304d, 0x5a2f },
	{ 0x304e, 0x5a1a },
	{ 0x304f, 0x5a12 },
	{ 0x3052, 0x5a26 },
	{ 0x3055, 0x5bbc },
	{ 0x3056, 0x5bbb },
	{ 0x3057, 0x5bb7 },
	{ 0x3058, 0x5c05 },
	{ 0x3059, 0x5c06 },
	{ 0x305a, 0x5c52 },
	{ 0x305b, 0x5c53 },
	{ 0x305e, 0x5cfa },
	{ 0x305f, 0x5ceb },
	{ 0x3061, 0x5cf3 },
	{ 0x3062, 0x5cf5 },
	{ 0x3063, 0x5ce9 },
	{ 0x3064, 0x5cef },
	{ 0x3066, 0x5e2a },
	{ 0x3067, 0x5e30 },
	{ 0x3068, 0x5e2e },
	{ 0x3069, 0x5e2c },
	{ 0x306a, 0x5e2f },
	{ 0x306b, 0x5eaf },
	{ 0x306c, 0x5ea9 },
	{ 0x306e, 0x5efd },
	{ 0x306f, 0x5f32 },
	{ 0x3070, 0x5f8e },
	{ 0x3071, 0x5f93 },
	{ 0x3072, 0x5f8f },
	{ 0x3073, 0x604f },
	{ 0x3074, 0x6099 },
	{ 0x3076, 0x607e },
	{ 0x3078, 0x6074 },
	{ 0x3079, 0x604b },
	{ 0x307a, 0x6073 },
	{ 0x307b, 0x6075 },
	{ 0x307e, 0x6056 },
	{ 0x3121, 0x60a9 },
	{ 0x3122, 0x608b },
	{ 0x3123, 0x60a6 },
	{ 0x3125, 0x6093 },
	{ 0x3126, 0x60ae },
	{ 0x3127, 0x609e },
	{ 0x3128, 0x60a7 },
	{ 0x3129, 0x6245 },
	{ 0x312c, 0x632e },
	{ 0x312e, 0x6352 },
	{ 0x312f, 0x6330 },
	{ 0x3130, 0x635b },
	{ 0x3132, 0x6319 },
	{ 0x3133, 0x631b },
	{ 0x3135, 0x6331 },
	{ 0x3136, 0x635d },
	{ 0x3137, 0x6337 },
	{ 0x3138, 0x6335 },
	{ 0x3139, 0x6353 },
	{ 0x313b, 0x635c },
	{ 0x313c, 0x633f },
	{ 0x313d, 0x654b },
	{ 0x3140, 0x658b },
	{ 0x3142, 0x659a },
	{ 0x3143, 0x6650 },
	{ 0x3144, 0x6646 },
	{ 0x3145, 0x664e },
	{ 0x3146, 0x6640 },
	{ 0x3148, 0x664b },
	{ 0x3149, 0x6648 },
	{ 0x314b, 0x6660 },
	{ 0x314c, 0x6644 },
	{ 0x314d, 0x664d },
	{ 0x314f, 0x6837 },
	{ 0x3150, 0x6824 },
	{ 0x3153, 0x681b },
	{ 0x3154, 0x6836 },
	{ 0x3156, 0x682c },
	{ 0x3157, 0x6819 },
	{ 0x3158, 0x6856 },
	{ 0x3159, 0x6847 },
	{ 0x315a, 0x683e },
	{ 0x315b, 0x681e },
	{ 0x315d, 0x6815 },
	{ 0x315e, 0x6822 },
	{ 0x315f, 0x6827 },
	{ 0x3160, 0x6859 },
	{ 0x3161, 0x6858 },
	{ 0x3162, 0x6855 },
	{ 0x3163, 0x6830 },
	{ 0x3164, 0x6823 },
	{ 0x3165, 0x6b2e },
	{ 0x3166, 0x6b2b },
	{ 0x3167, 0x6b30 },
	{ 0x3168, 0x6b6c },
	{ 0x316a, 0x6b8b },
	{ 0x316c, 0x6be9 },
	{ 0x316d, 0x6bea },
	{ 0x316e, 0x6be5 },
	{ 0x316f, 0x6d6b },
	{ 0x3172, 0x6d73 },
	{ 0x3173, 0x6d57 },
	{ 0x3176, 0x6d5d },
	{ 0x3177, 0x6d56 },
	{ 0x3178, 0x6d8f },
	{ 0x3179, 0x6d5b },
	{ 0x317a, 0x6d1c },
	{ 0x317b, 0x6d9a },
	{ 0x317c, 0x6d9b },
	{ 0x317d, 0x6d99 },
	{ 0x3221, 0x6d81 },
	{ 0x3222, 0x6d71 },
	{ 0x3225, 0x6d72 },
	{ 0x3226, 0x6d5c },
	{ 0x3227, 0x6d96 },
	{ 0x3228, 0x70c4 },
	{ 0x3229, 0x70db },
	{ 0x322a, 0x70cc },
	{ 0x322b, 0x70d0 },
	{ 0x322c, 0x70e3 },
	{ 0x322d, 0x70df },
	{ 0x322f, 0x70d6 },
	{ 0x3230, 0x70ee },
	{ 0x3231, 0x70d5 },
	{ 0x3236, 0x727a },
	{ 0x3238, 0x72f5 },
	{ 0x3239, 0x7302 },
	{ 0x323c, 0x73e2 },
	{ 0x323d, 0x73ec },
	{ 0x323e, 0x73d5 },
	{ 0x323f, 0x73f9 },
	{ 0x3240, 0x73df },
	{ 0x3241, 0x73e6 },
	{ 0x3246, 0x73e4 },
	{ 0x3247, 0x73e1 },
	{ 0x3248, 0x74f3 },
	{ 0x324d, 0x7556 },
	{ 0x324e, 0x7555 },
	{ 0x324f, 0x7558 },
	{ 0x3250, 0x7557 },
	{ 0x3251, 0x755e },
	{ 0x3252, 0x75c3 },
	{ 0x3255, 0x75b4 },
	{ 0x3257, 0x75b1 },
	{ 0x325a, 0x76cb },
	{ 0x325b, 0x76cc },
	{ 0x325c, 0x772a },
	{ 0x325e, 0x7716 },
	{ 0x325f, 0x770f },
	{ 0x3262, 0x773f },
	{ 0x3263, 0x772b },
	{ 0x3264, 0x770e },
	{ 0x3265, 0x7724 },
	{ 0x3267, 0x7721 },
	{ 0x3268, 0x7718 },
	{ 0x3269, 0x77dd },
	{ 0x326c, 0x7824 },
	{ 0x326d, 0x7836 },
	{ 0x326f, 0x7958 },
	{ 0x3270, 0x7959 },
	{ 0x3272, 0x7962 },
	{ 0x3273, 0x79da },
	{ 0x3274, 0x79d9 },
	{ 0x3276, 0x79e1 },
	{ 0x3277, 0x79e5 },
	{ 0x3278, 0x79e8 },
	{ 0x3279, 0x79db },
	{ 0x327b, 0x79e2 },
	{ 0x327c, 0x79f0 },
	{ 0x3323, 0x7ada },
	{ 0x3324, 0x7add },
	{ 0x3326, 0x7adb },
	{ 0x3327, 0x7adc },
	{ 0x332a, 0x7b0d },
	{ 0x332b, 0x7b0b },
	{ 0x332c, 0x7b14 },
	{ 0x332d, 0x7c8e },
	{ 0x332e, 0x7c86 },
	{ 0x3330, 0x7c87 },
	{ 0x3331, 0x7c83 },
	{ 0x3332, 0x7c8b },
	{ 0x3337, 0x7d24 },
	{ 0x333b, 0x7d25 },
	{ 0x333c, 0x7f62 },
	{ 0x333d, 0x7f93 },
	{ 0x333e, 0x7f99 },
	{ 0x333f, 0x7f97 },
	{ 0x3342, 0x7fc4 },
	{ 0x3343, 0x7fc6 },
	{ 0x3344, 0x800a },
	{ 0x3347, 0x8040 },
	{ 0x3348, 0x803c },
	{ 0x3349, 0x803b },
	{ 0x334a, 0x80f6 },
	{ 0x334b, 0x80ff },
	{ 0x334c, 0x80ee },
	{ 0x334d, 0x8104 },
	{ 0x334e, 0x8103 },
	{ 0x334f, 0x8107 },
	{ 0x3352, 0x80f7 },
	{ 0x3355, 0x822d },
	{ 0x3357, 0x8227 },
	{ 0x3358, 0x8229 },
	{ 0x3359, 0x831f },
	{ 0x335a, 0x8357 },
	{ 0x335f, 0x8321 },
	{ 0x3362, 0x8318 },
	{ 0x3363, 0x8358 },
	{ 0x3369, 0x8684 },
	{ 0x336a, 0x869f },
	{ 0x336b, 0x869b },
	{ 0x336c, 0x8689 },
	{ 0x336d, 0x86a6 },
	{ 0x336e, 0x8692 },
	{ 0x336f, 0x868f },
	{ 0x3370, 0x86a0 },
	{ 0x3371, 0x884f },
	{ 0x3372, 0x8878 },
	{ 0x3373, 0x887a },
	{ 0x3374, 0x886e },
	{ 0x3375, 0x887b },
	{ 0x3376, 0x8884 },
	{ 0x3377, 0x8873 },
	{ 0x337a, 0x8a0d },
	{ 0x337b, 0x8a0b },
	{ 0x337c, 0x8a19 },
	{ 0x3425, 0x8ff9 },
	{ 0x3426, 0x9009 },
	{ 0x3427, 0x9008 },
	{ 0x3429, 0x90de },
	{ 0x342a, 0x9151 },
	{ 0x342d, 0x91db },
	{ 0x342e, 0x91df },
	{ 0x342f, 0x91de },
	{ 0x3430, 0x91d6 },
	{ 0x3431, 0x91e0 },
	{ 0x3432, 0x9585 },
	{ 0x3433, 0x9660 },
	{ 0x3434, 0x9659 },
	{ 0x3436, 0x9656 },
	{ 0x3439, 0x96bd },
	{ 0x343c, 0x5042 },
	{ 0x343d, 0x5059 },
	{ 0x343f, 0x5044 },
	{ 0x3440, 0x5066 },
	{ 0x3441, 0x5052 },
	{ 0x3442, 0x5054 },
	{ 0x3443, 0x5071 },
	{ 0x3444, 0x5050 },
	{ 0x3445, 0x507b },
	{ 0x3446, 0x507c },
	{ 0x3447, 0x5058 },
	{ 0x344a, 0x5079 },
	{ 0x344b, 0x506c },
	{ 0x344c, 0x5078 },
	{ 0x344d, 0x51a8 },
	{ 0x344e, 0x51d1 },
	{ 0x344f, 0x51cf },
	{ 0x3450, 0x5268 },
	{ 0x3451, 0x5276 },
	{ 0x3452, 0x52d4 },
	{ 0x3454, 0x53a0 },
	{ 0x3455, 0x53c4 },
	{ 0x3457, 0x5558 },
	{ 0x3458, 0x554c },
	{ 0x3459, 0x5568 },
	{ 0x345b, 0x5549 },
	{ 0x345e, 0x555d },
	{ 0x345f, 0x5529 },
	{ 0x3461, 0x5554 },
	{ 0x3462, 0x5553 },
	{ 0x3464, 0x555a },
	{ 0x3466, 0x553a },
	{ 0x3467, 0x553f },
	{ 0x3468, 0x552b },
	{ 0x3469, 0x57ea },
	{ 0x346b, 0x57ef },
	{ 0x346e, 0x57dd },
	{ 0x346f, 0x57fe },
	{ 0x3471, 0x57de },
	{ 0x3472, 0x57e6 },
	{ 0x3474, 0x57e8 },
	{ 0x3475, 0x57ff },
	{ 0x3476, 0x5803 },
	{ 0x3477, 0x58f7 },
	{ 0x3478, 0x68a6 },
	{ 0x3479, 0x591f },
	{ 0x347b, 0x595b },
	{ 0x347c, 0x595d },
	{ 0x347d, 0x595e },
	{ 0x3522, 0x5a2b },
	{ 0x3524, 0x5a3b },
	{ 0x3527, 0x5a61 },
	{ 0x3528, 0x5a3a },
	{ 0x3529, 0x5a6e },
	{ 0x352a, 0x5a4b },
	{ 0x352b, 0x5a6b },
	{ 0x352e, 0x5a45 },
	{ 0x352f, 0x5a4e },
	{ 0x3530, 0x5a68 },
	{ 0x3531, 0x5a3d },
	{ 0x3532, 0x5a71 },
	{ 0x3533, 0x5a3f },
	{ 0x3534, 0x5a6f },
	{ 0x3535, 0x5a75 },
	{ 0x3537, 0x5a73 },
	{ 0x3538, 0x5a2c },
	{ 0x3539, 0x5a59 },
	{ 0x353a, 0x5a54 },
	{ 0x353b, 0x5a4f },
	{ 0x353c, 0x5a63 },
	{ 0x353f, 0x5bc8 },
	{ 0x3541, 0x5bc3 },
	{ 0x3543, 0x5c5b },
	{ 0x3544, 0x5c61 },
	{ 0x3546, 0x5d21 },
	{ 0x3547, 0x5d0a },
	{ 0x3548, 0x5d09 },
	{ 0x354a, 0x5d2c },
	{ 0x354b, 0x5d08 },
	{ 0x354e, 0x5d2a },
	{ 0x354f, 0x5d15 },
	{ 0x3551, 0x5d10 },
	{ 0x3552, 0x5d13 },
	{ 0x3554, 0x5d2f },
	{ 0x3555, 0x5d18 },
	{ 0x3557, 0x5de3 },
	{ 0x3558, 0x5e39 },
	{ 0x3559, 0x5e35 },
	{ 0x355a, 0x5e3a },
	{ 0x355b, 0x5e32 },
	{ 0x3560, 0x5ebb },
	{ 0x3561, 0x5eba },
	{ 0x3562, 0x5f34 },
	{ 0x3563, 0x5f39 },
	{ 0x3568, 0x6098 },
	{ 0x356a, 0x60d0 },
	{ 0x356e, 0x60d7 },
	{ 0x356f, 0x60aa },
	{ 0x3571, 0x60a1 },
	{ 0x3572, 0x60a4 },
	{ 0x3574, 0x60ee },
	{ 0x3576, 0x60e7 },
	{ 0x3579, 0x60de },
	{ 0x357c, 0x637e },
	{ 0x357d, 0x638b },
	{ 0x3622, 0x6379 },
	{ 0x3623, 0x6386 },
	{ 0x3624, 0x6393 },
	{ 0x3626, 0x6373 },
	{ 0x3627, 0x636a },
	{ 0x3629, 0x636c },
	{ 0x362b, 0x637f },
	{ 0x362d, 0x63b2 },
	{ 0x362e, 0x63ba },
	{ 0x3631, 0x6366 },
	{ 0x3632, 0x6374 },
	{ 0x3634, 0x655a },
	{ 0x3636, 0x654e },
	{ 0x3637, 0x654d },
	{ 0x3638, 0x658d },
	{ 0x3639, 0x658e },
	{ 0x363a, 0x65ad },
	{ 0x363c, 0x65c7 },
	{ 0x363d, 0x65ca },
	{ 0x363f, 0x65c9 },
	{ 0x3641, 0x65e3 },
	{ 0x3642, 0x6657 },
	{ 0x3644, 0x6663 },
	{ 0x3645, 0x6667 },
	{ 0x3646, 0x671a },
	{ 0x3647, 0x6719 },
	{ 0x3648, 0x6716 },
	{ 0x364b, 0x689e },
	{ 0x364c, 0x68b6 },
	{ 0x364d, 0x6898 },
	{ 0x364e, 0x6873 },
	{ 0x3650, 0x689a },
	{ 0x3651, 0x688e },
	{ 0x3652, 0x68b7 },
	{ 0x3653, 0x68db },
	{ 0x3654, 0x68a5 },
	{ 0x3655, 0x686c },
	{ 0x3656, 0x68c1 },
	{ 0x3657, 0x6884 },
	{ 0x365a, 0x6895 },
	{ 0x365b, 0x687a },
	{ 0x365c, 0x6899 },
	{ 0x365e, 0x68b8 },
	{ 0x365f, 0x68b9 },
	{ 0x3660, 0x6870 },
	{ 0x3662, 0x6b35 },
	{ 0x3664, 0x6b90 },
	{ 0x3665, 0x6bbb },
	{ 0x3666, 0x6bed },
	{ 0x366a, 0x6dc1 },
	{ 0x366b, 0x6dc3 },
	{ 0x366c, 0x6dce },
	{ 0x366f, 0x6dad },
	{ 0x3670, 0x6e04 },
	{ 0x3672, 0x6db9 },
	{ 0x3674, 0x6de7 },
	{ 0x3676, 0x6e08 },
	{ 0x3677, 0x6e06 },
	{ 0x3679, 0x6e0a },
	{ 0x367a, 0x6db0 },
	{ 0x367c, 0x6df8 },
	{ 0x367d, 0x6e0c },
	{ 0x3721, 0x6db1 },
	{ 0x3723, 0x6e02 },
	{ 0x3724, 0x6e07 },
	{ 0x3725, 0x6e09 },
	{ 0x3726, 0x6e01 },
	{ 0x3727, 0x6e17 },
	{ 0x3728, 0x6dff },
	{ 0x3729, 0x6e12 },
	{ 0x372c, 0x7103 },
	{ 0x372d, 0x7107 },
	{ 0x372e, 0x7101 },
	{ 0x372f, 0x70f5 },
	{ 0x3730, 0x70f1 },
	{ 0x3731, 0x7108 },
	{ 0x3732, 0x70f2 },
	{ 0x3733, 0x710f },
	{ 0x3735, 0x70fe },
	{ 0x3739, 0x731a },
	{ 0x373a, 0x7310 },
	{ 0x373b, 0x730e },
	{ 0x373c, 0x7402 },
	{ 0x373d, 0x73f3 },
	{ 0x3740, 0x73fb },
	{ 0x3744, 0x751b },
	{ 0x3745, 0x7523 },
	{ 0x3746, 0x7561 },
	{ 0x3747, 0x7568 },
	{ 0x3749, 0x7567 },
	{ 0x374a, 0x75d3 },
	{ 0x374d, 0x7690 },
	{ 0x3750, 0x76d5 },
	{ 0x3751, 0x76d7 },
	{ 0x3752, 0x76d6 },
	{ 0x3753, 0x7730 },
	{ 0x3755, 0x7726 },
	{ 0x3757, 0x7740 },
	{ 0x3759, 0x771e },
	{ 0x375d, 0x7847 },
	{ 0x375f, 0x784b },
	{ 0x3760, 0x7851 },
	{ 0x3761, 0x784f },
	{ 0x3762, 0x7842 },
	{ 0x3763, 0x7846 },
	{ 0x3765, 0x796e },
	{ 0x3766, 0x796c },
	{ 0x3767, 0x79f2 },
	{ 0x3769, 0x79f1 },
	{ 0x376a, 0x79f5 },
	{ 0x376b, 0x79f3 },
	{ 0x376c, 0x79f9 },
	{ 0x3770, 0x7a9a },
	{ 0x3771, 0x7a93 },
	{ 0x3772, 0x7a91 },
	{ 0x3773, 0x7ae1 },
	{ 0x3776, 0x7b21 },
	{ 0x3777, 0x7b1c },
	{ 0x3778, 0x7b16 },
	{ 0x3779, 0x7b17 },
	{ 0x377a, 0x7b36 },
	{ 0x377b, 0x7b1f },
	{ 0x377d, 0x7c93 },
	{ 0x377e, 0x7c99 },
	{ 0x3821, 0x7c9a },
	{ 0x3822, 0x7c9c },
	{ 0x3824, 0x7d49 },
	{ 0x3826, 0x7d34 },
	{ 0x3827, 0x7d37 },
	{ 0x3829, 0x7d2d },
	{ 0x382b, 0x7d4c },
	{ 0x382e, 0x7d48 },
	{ 0x3831, 0x7f3b },
	{ 0x3836, 0x8008 },
	{ 0x3837, 0x801a },
	{ 0x3839, 0x801d },
	{ 0x383b, 0x8049 },
	{ 0x383c, 0x8045 },
	{ 0x383d, 0x8044 },
	{ 0x383e, 0x7c9b },
	{ 0x3841, 0x812a },
	{ 0x3842, 0x812e },
	{ 0x3845, 0x8131 },
	{ 0x3847, 0x811a },
	{ 0x3848, 0x8134 },
	{ 0x3849, 0x8117 },
	{ 0x384d, 0x831d },
	{ 0x384e, 0x8371 },
	{ 0x384f, 0x8384 },
	{ 0x3850, 0x8380 },
	{ 0x3851, 0x8372 },
	{ 0x3852, 0x83a1 },
	{ 0x3854, 0x8379 },
	{ 0x3855, 0x8391 },
	{ 0x3857, 0x839f },
	{ 0x3858, 0x83ad },
	{ 0x385b, 0x8323 },
	{ 0x385d, 0x8385 },
	{ 0x385e, 0x839c },
	{ 0x385f, 0x83b7 },
	{ 0x3860, 0x8658 },
	{ 0x3861, 0x865a },
	{ 0x3863, 0x8657 },
	{ 0x3864, 0x86b2 },
	{ 0x3866, 0x86ae },
	{ 0x386a, 0x8845 },
	{ 0x386b, 0x889c },
	{ 0x386c, 0x8894 },
	{ 0x386d, 0x88a3 },
	{ 0x386e, 0x888f },
	{ 0x386f, 0x88a5 },
	{ 0x3870, 0x88a9 },
	{ 0x3871, 0x88a6 },
	{ 0x3872, 0x888a },
	{ 0x3873, 0x88a0 },
	{ 0x3874, 0x8890 },
	{ 0x3875, 0x8992 },
	{ 0x3876, 0x8991 },
	{ 0x3877, 0x8994 },
	{ 0x3879, 0x8a26 },
	{ 0x387a, 0x8a32 },
	{ 0x387b, 0x8a28 },
	{ 0x387e, 0x8a1c },
	{ 0x3922, 0x8a2b },
	{ 0x3923, 0x8a20 },
	{ 0x3925, 0x8a29 },
	{ 0x3929, 0x8a21 },
	{ 0x392a, 0x8c3a },
	{ 0x392c, 0x8c5b },
	{ 0x392d, 0x8c58 },
	{ 0x392e, 0x8c7c },
	{ 0x3930, 0x8ca6 },
	{ 0x3931, 0x8cae },
	{ 0x3932, 0x8cad },
	{ 0x3933, 0x8d65 },
	{ 0x3935, 0x8d7e },
	{ 0x3937, 0x8d7c },
	{ 0x3938, 0x8d7f },
	{ 0x3939, 0x8d7a },
	{ 0x393a, 0x8dbd },
	{ 0x393d, 0x8dc0 },
	{ 0x393e, 0x8dbb },
	{ 0x393f, 0x8ead },
	{ 0x3940, 0x8eaf },
	{ 0x3941, 0x8ed6 },
	{ 0x3947, 0x8ed9 },
	{ 0x394a, 0x9012 },
	{ 0x394b, 0x900e },
	{ 0x394c, 0x9025 },
	{ 0x394e, 0x9013 },
	{ 0x394f, 0x90ee },
	{ 0x3951, 0x90ab },
	{ 0x3952, 0x90f7 },
	{ 0x3954, 0x9159 },
	{ 0x3955, 0x9154 },
	{ 0x3956, 0x91f2 },
	{ 0x3957, 0x91f0 },
	{ 0x3958, 0x91e5 },
	{ 0x3959, 0x91f6 },
	{ 0x395c, 0x9587 },
	{ 0x395e, 0x965a },
	{ 0x3961, 0x966e },
	{ 0x3965, 0x9679 },
	{ 0x3967, 0x98e1 },
	{ 0x3968, 0x98e6 },
	{ 0x396a, 0x9ec4 },
	{ 0x396b, 0x9ed2 },
	{ 0x396c, 0x4e80 },
	{ 0x396e, 0x4e81 },
	{ 0x396f, 0x508f },
	{ 0x3970, 0x5097 },
	{ 0x3971, 0x5088 },
	{ 0x3972, 0x5089 },
	{ 0x3975, 0x5081 },
	{ 0x3976, 0x5160 },
	{ 0x3979, 0x5e42 },
	{ 0x397a, 0x51d3 },
	{ 0x397d, 0x51d2 },
	{ 0x397e, 0x51d6 },
	{ 0x3a21, 0x5273 },
	{ 0x3a23, 0x5270 },
	{ 0x3a27, 0x53a8 },
	{ 0x3a28, 0x53a6 },
	{ 0x3a29, 0x53c5 },
	{ 0x3a2a, 0x5597 },
	{ 0x3a2b, 0x55de },
	{ 0x3a2e, 0x5596 },
	{ 0x3a2f, 0x55b4 },
	{ 0x3a31, 0x5585 },
	{ 0x3a33, 0x559b },
	{ 0x3a34, 0x55a0 },
	{ 0x3a36, 0x5559 },
	{ 0x3a38, 0x5586 },
	{ 0x3a3b, 0x55af },
	{ 0x3a3c, 0x557a },
	{ 0x3a40, 0x559e },
	{ 0x3a42, 0x55a9 },
	{ 0x3a43, 0x570f },
	{ 0x3a44, 0x570e },
	{ 0x3a45, 0x581a },
	{ 0x3a47, 0x581f },
	{ 0x3a49, 0x583c },
	{ 0x3a4a, 0x5818 },
	{ 0x3a4b, 0x583e },
	{ 0x3a4c, 0x5826 },
	{ 0x3a4e, 0x583a },
	{ 0x3a50, 0x5822 },
	{ 0x3a52, 0x58fb },
	{ 0x3a53, 0x5963 },
	{ 0x3a54, 0x5964 },
	{ 0x3a56, 0x5aa8 },
	{ 0x3a57, 0x5aa3 },
	{ 0x3a58, 0x5a82 },
	{ 0x3a59, 0x5a88 },
	{ 0x3a5a, 0x5aa1 },
	{ 0x3a5b, 0x5a85 },
	{ 0x3a5c, 0x5a98 },
	{ 0x3a5e, 0x5a99 },
	{ 0x3a60, 0x5a89 },
	{ 0x3a61, 0x5a81 },
	{ 0x3a62, 0x5a96 },
	{ 0x3a63, 0x5a80 },
	{ 0x3a66, 0x5a91 },
	{ 0x3a6b, 0x5acf },
	{ 0x3a72, 0x5a87 },
	{ 0x3a73, 0x5aa0 },
	{ 0x3a75, 0x5a79 },
	{ 0x3a77, 0x5a86 },
	{ 0x3a78, 0x5aab },
	{ 0x3a79, 0x5aaa },
	{ 0x3a7a, 0x5aa4 },
	{ 0x3a7b, 0x5a8d },
	{ 0x3a7c, 0x5a7e },
	{ 0x3a7e, 0x5bd5 },
	{ 0x3b24, 0x5c1e },
	{ 0x3b25, 0x5c5f },
	{ 0x3b26, 0x5c5e },
	{ 0x3b27, 0x5d44 },
	{ 0x3b28, 0x5d3e },
	{ 0x3b2a, 0x5d48 },
	{ 0x3b2b, 0x5d1c },
	{ 0x3b2d, 0x5d5b },
	{ 0x3b2e, 0x5d4d },
	{ 0x3b31, 0x5d57 },
	{ 0x3b33, 0x5d53 },
	{ 0x3b34, 0x5d4f },
	{ 0x3b36, 0x5d3b },
	{ 0x3b37, 0x5d46 },
	{ 0x3b3a, 0x5e46 },
	{ 0x3b3b, 0x5e47 },
	{ 0x3b3d, 0x5e48 },
	{ 0x3b3e, 0x5ec0 },
	{ 0x3b3f, 0x5ebd },
	{ 0x3b40, 0x5ebf },
	{ 0x3b42, 0x5f11 },
	{ 0x3b44, 0x5f3e },
	{ 0x3b45, 0x5f3b },
	{ 0x3b47, 0x5f3a },
	{ 0x3b4b, 0x5fa7 },
	{ 0x3b4d, 0x60ea },
	{ 0x3b4f, 0x6107 },
	{ 0x3b50, 0x6122 },
	{ 0x3b51, 0x610c },
	{ 0x3b54, 0x60b3 },
	{ 0x3b55, 0x60d6 },
	{ 0x3b56, 0x60d2 },
	{ 0x3b58, 0x60e3 },
	{ 0x3b59, 0x60e5 },
	{ 0x3b5a, 0x60e9 },
	{ 0x3b5d, 0x6111 },
	{ 0x3b5e, 0x60fd },
	{ 0x3b61, 0x611e },
	{ 0x3b62, 0x6120 },
	{ 0x3b63, 0x6121 },
	{ 0x3b64, 0x621e },
	{ 0x3b66, 0x63e2 },
	{ 0x3b67, 0x63de },
	{ 0x3b68, 0x63e6 },
	{ 0x3b6d, 0x63f8 },
	{ 0x3b6f, 0x63fe },
	{ 0x3b70, 0x63c1 },
	{ 0x3b71, 0x63bf },
	{ 0x3b72, 0x63f7 },
	{ 0x3b73, 0x63d1 },
	{ 0x3b74, 0x655f },
	{ 0x3b75, 0x6560 },
	{ 0x3b76, 0x6561 },
	{ 0x3b79, 0x65d1 },
	{ 0x3b7c, 0x667d },
	{ 0x3b7d, 0x666b },
	{ 0x3b7e, 0x667f },
	{ 0x3c23, 0x6673 },
	{ 0x3c24, 0x6681 },
	{ 0x3c25, 0x666d },
	{ 0x3c26, 0x6669 },
	{ 0x3c29, 0x671e },
	{ 0x3c2a, 0x68ed },
	{ 0x3c2f, 0x6903 },
	{ 0x3c31, 0x68fe },
	{ 0x3c32, 0x68e5 },
	{ 0x3c33, 0x691e },
	{ 0x3c34, 0x6902 },
	{ 0x3c37, 0x6909 },
	{ 0x3c38, 0x68ca },
	{ 0x3c39, 0x6900 },
	{ 0x3c3b, 0x6901 },
	{ 0x3c3c, 0x6918 },
	{ 0x3c3d, 0x68e2 },
	{ 0x3c3e, 0x68cf },
	{ 0x3c40, 0x692e },
	{ 0x3c41, 0x68c5 },
	{ 0x3c42, 0x68ff },
	{ 0x3c44, 0x691c },
	{ 0x3c45, 0x68c3 },
	{ 0x3c47, 0x6b6f },
	{ 0x3c49, 0x6b6e },
	{ 0x3c4b, 0x6bbe },
	{ 0x3c4d, 0x6bf4 },
	{ 0x3c4e, 0x6c2d },
	{ 0x3c50, 0x6db6 },
	{ 0x3c51, 0x6e75 },
	{ 0x3c52, 0x6e1e },
	{ 0x3c54, 0x6e18 },
	{ 0x3c56, 0x6e48 },
	{ 0x3c58, 0x6e4f },
	{ 0x3c5a, 0x6e42 },
	{ 0x3c5b, 0x6e6a },
	{ 0x3c5c, 0x6e70 },
	{ 0x3c5d, 0x6dfe },
	{ 0x3c60, 0x6e6d },
	{ 0x3c62, 0x6e7b },
	{ 0x3c63, 0x6e7e },
	{ 0x3c64, 0x6e59 },
	{ 0x3c66, 0x6e57 },
	{ 0x3c68, 0x6e80 },
	{ 0x3c69, 0x6e50 },
	{ 0x3c6b, 0x6e29 },
	{ 0x3c6c, 0x6e76 },
	{ 0x3c6d, 0x6e2a },
	{ 0x3c6e, 0x6e4c },
	{ 0x3c6f, 0x712a },
	{ 0x3c71, 0x7135 },
	{ 0x3c72, 0x712c },
	{ 0x3c73, 0x7137 },
	{ 0x3c74, 0x711d },
	{ 0x3c77, 0x7138 },
	{ 0x3c79, 0x7134 },
	{ 0x3c7a, 0x712b },
	{ 0x3c7b, 0x7133 },
	{ 0x3c7c, 0x7127 },
	{ 0x3c7d, 0x7124 },
	{ 0x3d21, 0x712d },
	{ 0x3d22, 0x7232 },
	{ 0x3d23, 0x7283 },
	{ 0x3d24, 0x7282 },
	{ 0x3d25, 0x7287 },
	{ 0x3d26, 0x7306 },
	{ 0x3d27, 0x7324 },
	{ 0x3d28, 0x7338 },
	{ 0x3d29, 0x732a },
	{ 0x3d2a, 0x732c },
	{ 0x3d2b, 0x732b },
	{ 0x3d2d, 0x732f },
	{ 0x3d2e, 0x7328 },
	{ 0x3d2f, 0x7417 },
	{ 0x3d32, 0x7419 },
	{ 0x3d33, 0x7438 },
	{ 0x3d35, 0x741f },
	{ 0x3d36, 0x7414 },
	{ 0x3d37, 0x743c },
	{ 0x3d38, 0x73f7 },
	{ 0x3d39, 0x741c },
	{ 0x3d3a, 0x7415 },
	{ 0x3d3b, 0x7418 },
	{ 0x3d3c, 0x7439 },
	{ 0x3d3d, 0x74f9 },
	{ 0x3d3e, 0x7524 },
	{ 0x3d42, 0x756e },
	{ 0x3d43, 0x756d },
	{ 0x3d44, 0x7571 },
	{ 0x3d45, 0x758e },
	{ 0x3d47, 0x75e5 },
	{ 0x3d4c, 0x7694 },
	{ 0x3d4d, 0x76b3 },
	{ 0x3d4f, 0x76d9 },
	{ 0x3d51, 0x7748 },
	{ 0x3d52, 0x7749 },
	{ 0x3d53, 0x7743 },
	{ 0x3d56, 0x7742 },
	{ 0x3d57, 0x77df },
	{ 0x3d59, 0x7863 },
	{ 0x3d5a, 0x7876 },
	{ 0x3d5c, 0x785f },
	{ 0x3d5d, 0x7866 },
	{ 0x3d5e, 0x7966 },
	{ 0x3d5f, 0x7971 },
	{ 0x3d62, 0x7976 },
	{ 0x3d63, 0x7984 },
	{ 0x3d64, 0x7975 },
	{ 0x3d65, 0x79ff },
	{ 0x3d66, 0x7a07 },
	{ 0x3d68, 0x7a0e },
	{ 0x3d69, 0x7a09 },
	{ 0x3d70, 0x7ae7 },
	{ 0x3d71, 0x7ae2 },
	{ 0x3d72, 0x7b55 },
	{ 0x3d75, 0x7b43 },
	{ 0x3d76, 0x7b57 },
	{ 0x3d77, 0x7b6c },
	{ 0x3d78, 0x7b42 },
	{ 0x3d79, 0x7b53 },
	{ 0x3d7b, 0x7b41 },
	{ 0x3d7e, 0x7ca7 },
	{ 0x3e21, 0x7ca0 },
	{ 0x3e22, 0x7ca6 },
	{ 0x3e23, 0x7ca4 },
	{ 0x3e24, 0x7d74 },
	{ 0x3e26, 0x7d59 },
	{ 0x3e28, 0x7d60 },
	{ 0x3e29, 0x7d57 },
	{ 0x3e2a, 0x7d6c },
	{ 0x3e2b, 0x7d7e },
	{ 0x3e2c, 0x7d64 },
	{ 0x3e2e, 0x7d5a },
	{ 0x3e2f, 0x7d5d },
	{ 0x3e33, 0x7d76 },
	{ 0x3e34, 0x7d4d },
	{ 0x3e35, 0x7d75 },
	{ 0x3e37, 0x7fd3 },
	{ 0x3e38, 0x7fd6 },
	{ 0x3e3b, 0x8060 },
	{ 0x3e3c, 0x804e },
	{ 0x3e3d, 0x8145 },
	{ 0x3e3e, 0x813b },
	{ 0x3e40, 0x8148 },
	{ 0x3e41, 0x8142 },
	{ 0x3e42, 0x8149 },
	{ 0x3e43, 0x8140 },
	{ 0x3e44, 0x8114 },
	{ 0x3e45, 0x8141 },
	{ 0x3e47, 0x81ef },
	{ 0x3e48, 0x81f6 },
	{ 0x3e49, 0x8203 },
	{ 0x3e4b, 0x83ed },
	{ 0x3e4d, 0x83da },
	{ 0x3e4e, 0x8418 },
	{ 0x3e4f, 0x83d2 },
	{ 0x3e50, 0x8408 },
	{ 0x3e52, 0x8400 },
	{ 0x3e56, 0x8417 },
	{ 0x3e57, 0x8346 },
	{ 0x3e58, 0x8414 },
	{ 0x3e59, 0x83d3 },
	{ 0x3e5a, 0x8405 },
	{ 0x3e5b, 0x841f },
	{ 0x3e5c, 0x8402 },
	{ 0x3e5d, 0x8416 },
	{ 0x3e5e, 0x83cd },
	{ 0x3e5f, 0x83e6 },
	{ 0x3e61, 0x865d },
	{ 0x3e62, 0x86d5 },
	{ 0x3e63, 0x86e1 },
	{ 0x3e68, 0x86ee },
	{ 0x3e69, 0x8847 },
	{ 0x3e6a, 0x8846 },
	{ 0x3e6d, 0x88bb },
	{ 0x3e6f, 0x88bf },
	{ 0x3e70, 0x88b4 },
	{ 0x3e72, 0x88b5 },
	{ 0x3e74, 0x899a },
	{ 0x3e75, 0x8a43 },
	{ 0x3e78, 0x8a5a },
	{ 0x3e7c, 0x8a35 },
	{ 0x3e7d, 0x8a38 },
	{ 0x3e7e, 0x8a42 },
	{ 0x3f21, 0x8a49 },
	{ 0x3f22, 0x8a5d },
	{ 0x3f23, 0x8a4b },
	{ 0x3f24, 0x8a3d },
	{ 0x3f29, 0x8c60 },
	{ 0x3f2a, 0x8c5e },
	{ 0x3f2b, 0x8c7f },
	{ 0x3f2c, 0x8c7e },
	{ 0x3f2d, 0x8c83 },
	{ 0x3f2f, 0x8cb1 },
	{ 0x3f30, 0x8d87 },
	{ 0x3f33, 0x8d88 },
	{ 0x3f34, 0x8d83 },
	{ 0x3f37, 0x8d86 },
	{ 0x3f38, 0x8d8b },
	{ 0x3f39, 0x8d82 },
	{ 0x3f3a, 0x8dca },
	{ 0x3f3b, 0x8dd2 },
	{ 0x3f3e, 0x8dd4 },
	{ 0x3f3f, 0x8dc9 },
	{ 0x3f40, 0x8eb0 },
	{ 0x3f44, 0x8ef2 },
	{ 0x3f45, 0x8ee4 },
	{ 0x3f46, 0x8ef3 },
	{ 0x3f47, 0x8eea },
	{ 0x3f49, 0x8efd },
	{ 0x3f4b, 0x8f9d },
	{ 0x3f4c, 0x902b },
	{ 0x3f4d, 0x902a },
	{ 0x3f4f, 0x9028 },
	{ 0x3f50, 0x9029 },
	{ 0x3f51, 0x902c },
	{ 0x3f54, 0x903a },
	{ 0x3f55, 0x9030 },
	{ 0x3f56, 0x9037 },
	{ 0x3f57, 0x903b },
	{ 0x3f59, 0x910a },
	{ 0x3f5d, 0x91fe },
	{ 0x3f5e, 0x9220 },
	{ 0x3f60, 0x920b },
	{ 0x3f62, 0x9218 },
	{ 0x3f63, 0x9222 },
	{ 0x3f65, 0x921b },
	{ 0x3f66, 0x9208 },
	{ 0x3f68, 0x920e },
	{ 0x3f69, 0x9213 },
	{ 0x3f6c, 0x9595 },
	{ 0x3f70, 0x968c },
	{ 0x3f71, 0x967b },
	{ 0x3f72, 0x967f },
	{ 0x3f73, 0x9681 },
	{ 0x3f75, 0x9682 },
	{ 0x3f7b, 0x96ee },
	{ 0x3f7c, 0x96ed },
	{ 0x3f7e, 0x96ec },
	{ 0x4021, 0x975f },
	{ 0x4022, 0x976f },
	{ 0x4024, 0x976d },
	{ 0x402b, 0x98f0 },
	{ 0x402f, 0x9aa9 },
	{ 0x4032, 0x9ae0 },
	{ 0x4033, 0x4eb7 },
	{ 0x4036, 0x50cc },
	{ 0x4037, 0x50bc },
	{ 0x4039, 0x50aa },
	{ 0x403a, 0x50b9 },
	{ 0x403c, 0x50ab },
	{ 0x403d, 0x50c3 },
	{ 0x403e, 0x50cd },
	{ 0x403f, 0x517e },
	{ 0x4040, 0x527e },
	{ 0x4041, 0x5279 },
	{ 0x4044, 0x52e1 },
	{ 0x4045, 0x52e0 },
	{ 0x4046, 0x52e7 },
	{ 0x4047, 0x5380 },
	{ 0x4048, 0x53ab },
	{ 0x4049, 0x53aa },
	{ 0x404a, 0x53a9 },
	{ 0x404b, 0x53e0 },
	{ 0x404c, 0x55ea },
	{ 0x404e, 0x55d7 },
	{ 0x4051, 0x55c1 },
	{ 0x4052, 0x5715 },
	{ 0x4054, 0x586c },
	{ 0x4056, 0x585c },
	{ 0x4057, 0x5850 },
	{ 0x4058, 0x5861 },
	{ 0x4059, 0x586a },
	{ 0x405a, 0x5869 },
	{ 0x405b, 0x5856 },
	{ 0x405c, 0x5860 },
	{ 0x405d, 0x5866 },
	{ 0x405e, 0x585f },
	{ 0x405f, 0x5923 },
	{ 0x4060, 0x5966 },
	{ 0x4061, 0x5968 },
	{ 0x4064, 0x5ace },
	{ 0x4066, 0x5ac5 },
	{ 0x4067, 0x5ac3 },
	{ 0x406a, 0x5ad0 },
	{ 0x4071, 0x5b74 },
	{ 0x4072, 0x5b76 },
	{ 0x4073, 0x5bdc },
	{ 0x4074, 0x5bd7 },
	{ 0x4075, 0x5bda },
	{ 0x4076, 0x5bdb },
	{ 0x4078, 0x5c20 },
	{ 0x4079, 0x5d6d },
	{ 0x407a, 0x5d66 },
	{ 0x407c, 0x5d64 },
	{ 0x407d, 0x5d6e },
	{ 0x4121, 0x5d60 },
	{ 0x4122, 0x5f42 },
	{ 0x4123, 0x5f5a },
	{ 0x4124, 0x5f6e },
	{ 0x4127, 0x6130 },
	{ 0x4128, 0x613a },
	{ 0x4129, 0x612a },
	{ 0x412a, 0x6143 },
	{ 0x412b, 0x6119 },
	{ 0x412c, 0x6131 },
	{ 0x412e, 0x613d },
	{ 0x4132, 0x6408 },
	{ 0x4133, 0x6432 },
	{ 0x4134, 0x6438 },
	{ 0x4136, 0x6431 },
	{ 0x4138, 0x6419 },
	{ 0x413a, 0x6411 },
	{ 0x413d, 0x6429 },
	{ 0x413e, 0x641d },
	{ 0x4142, 0x643c },
	{ 0x4144, 0x6446 },
	{ 0x4145, 0x6447 },
	{ 0x4148, 0x643a },
	{ 0x4149, 0x6407 },
	{ 0x414b, 0x656b },
	{ 0x414d, 0x6570 },
	{ 0x414e, 0x656d },
	{ 0x4150, 0x65e4 },
	{ 0x4151, 0x6693 },
	{ 0x4156, 0x668f },
	{ 0x4159, 0x6692 },
	{ 0x415b, 0x668e },
	{ 0x415d, 0x6946 },
	{ 0x4165, 0x6931 },
	{ 0x4168, 0x693e },
	{ 0x416a, 0x697c },
	{ 0x416b, 0x6943 },
	{ 0x416d, 0x6973 },
	{ 0x416f, 0x6955 },
	{ 0x4172, 0x6985 },
	{ 0x4173, 0x694d },
	{ 0x4174, 0x6950 },
	{ 0x4175, 0x6947 },
	{ 0x4176, 0x6967 },
	{ 0x4177, 0x6936 },
	{ 0x4178, 0x6964 },
	{ 0x4179, 0x6961 },
	{ 0x417b, 0x697d },
	{ 0x417c, 0x6b44 },
	{ 0x417d, 0x6b40 },
	{ 0x417e, 0x6b71 },
	{ 0x4221, 0x6b73 },
	{ 0x4222, 0x6b9c },
	{ 0x4226, 0x6bc1 },
	{ 0x4228, 0x6bfa },
	{ 0x4229, 0x6c31 },
	{ 0x422a, 0x6c32 },
	{ 0x422d, 0x6eb8 },
	{ 0x422e, 0x6ea8 },
	{ 0x4230, 0x6e91 },
	{ 0x4231, 0x6ebb },
	{ 0x4233, 0x6e9a },
	{ 0x4236, 0x6ea9 },
	{ 0x4239, 0x6eb5 },
	{ 0x423a, 0x6e6c },
	{ 0x423b, 0x6ee8 },
	{ 0x423d, 0x6edd },
	{ 0x423e, 0x6eda },
	{ 0x423f, 0x6ee6 },
	{ 0x4240, 0x6eac },
	{ 0x4244, 0x6ed9 },
	{ 0x4245, 0x6ee3 },
	{ 0x4246, 0x6ee9 },
	{ 0x4247, 0x6edb },
	{ 0x4249, 0x716f },
	{ 0x424c, 0x7148 },
	{ 0x424e, 0x714a },
	{ 0x424f, 0x716b },
	{ 0x4251, 0x714f },
	{ 0x4252, 0x7157 },
	{ 0x4253, 0x7174 },
	{ 0x4257, 0x7145 },
	{ 0x4258, 0x7151 },
	{ 0x4259, 0x716d },
	{ 0x425b, 0x7251 },
	{ 0x425c, 0x7250 },
	{ 0x425d, 0x724e },
	{ 0x425f, 0x7341 },
	{ 0x4261, 0x732e },
	{ 0x4262, 0x7346 },
	{ 0x4264, 0x7427 },
	{ 0x4266, 0x7448 },
	{ 0x4267, 0x7453 },
	{ 0x4268, 0x743d },
	{ 0x426a, 0x745d },
	{ 0x426b, 0x7456 },
	{ 0x426d, 0x741e },
	{ 0x426e, 0x7447 },
	{ 0x426f, 0x7443 },
	{ 0x4270, 0x7458 },
	{ 0x4271, 0x7449 },
	{ 0x4273, 0x744c },
	{ 0x4274, 0x7445 },
	{ 0x4275, 0x743e },
	{ 0x4277, 0x7501 },
	{ 0x4278, 0x751e },
	{ 0x427b, 0x757a },
	{ 0x427c, 0x75ee },
	{ 0x427d, 0x7602 },
	{ 0x427e, 0x7697 },
	{ 0x4321, 0x7698 },
	{ 0x4325, 0x775d },
	{ 0x4326, 0x7764 },
	{ 0x4327, 0x7753 },
	{ 0x4328, 0x7758 },
	{ 0x4329, 0x7882 },
	{ 0x432a, 0x7890 },
	{ 0x432b, 0x788a },
	{ 0x432d, 0x787a },
	{ 0x432e, 0x787d },
	{ 0x4330, 0x788b },
	{ 0x4331, 0x7878 },
	{ 0x4334, 0x788d },
	{ 0x4335, 0x7888 },
	{ 0x4336, 0x7892 },
	{ 0x4337, 0x7881 },
	{ 0x4338, 0x797e },
	{ 0x4339, 0x7983 },
	{ 0x433d, 0x7980 },
	{ 0x4341, 0x7a0f },
	{ 0x4344, 0x7a1d },
	{ 0x4346, 0x7aa1 },
	{ 0x4347, 0x7aa4 },
	{ 0x4349, 0x7ae9 },
	{ 0x434a, 0x7aea },
	{ 0x434c, 0x7b62 },
	{ 0x434d, 0x7b6b },
	{ 0x434f, 0x7b5e },
	{ 0x4351, 0x7b79 },
	{ 0x4354, 0x7b6f },
	{ 0x4355, 0x7b68 },
	{ 0x4358, 0x7cae },
	{ 0x435c, 0x7cb0 },
	{ 0x435e, 0x7d90 },
	{ 0x4360, 0x7d8a },
	{ 0x4362, 0x7d8b },
	{ 0x4363, 0x7d99 },
	{ 0x4364, 0x7d95 },
	{ 0x4366, 0x7d87 },
	{ 0x4367, 0x7d78 },
	{ 0x4368, 0x7d97 },
	{ 0x4369, 0x7d89 },
	{ 0x436a, 0x7d98 },
	{ 0x436e, 0x7fa3 },
	{ 0x4372, 0x7fdd },
	{ 0x4373, 0x8057 },
	{ 0x4375, 0x8163 },
	{ 0x4376, 0x816a },
	{ 0x4377, 0x816c },
	{ 0x437b, 0x815d },
	{ 0x437c, 0x8175 },
	{ 0x437e, 0x815f },
	{ 0x4422, 0x817d },
	{ 0x4423, 0x816d },
	{ 0x4426, 0x8241 },
	{ 0x4427, 0x844f },
	{ 0x4428, 0x8484 },
	{ 0x442a, 0x847f },
	{ 0x442c, 0x8448 },
	{ 0x442d, 0x842a },
	{ 0x442e, 0x847b },
	{ 0x442f, 0x8472 },
	{ 0x4430, 0x8464 },
	{ 0x4431, 0x842e },
	{ 0x4432, 0x845c },
	{ 0x4433, 0x8453 },
	{ 0x4435, 0x8441 },
	{ 0x4436, 0x84c8 },
	{ 0x4438, 0x8462 },
	{ 0x4439, 0x8480 },
	{ 0x443a, 0x843e },
	{ 0x443b, 0x8483 },
	{ 0x443c, 0x8471 },
	{ 0x443e, 0x844a },
	{ 0x443f, 0x8455 },
	{ 0x4440, 0x8458 },
	{ 0x4444, 0x86fc },
	{ 0x4445, 0x86fd },
	{ 0x4446, 0x8715 },
	{ 0x4448, 0x8716 },
	{ 0x4449, 0x86ff },
	{ 0x444d, 0x8858 },
	{ 0x444e, 0x88cf },
	{ 0x444f, 0x88e0 },
	{ 0x4454, 0x89e7 },
	{ 0x4455, 0x8a6a },
	{ 0x4456, 0x8a80 },
	{ 0x4458, 0x8a6f },
	{ 0x4459, 0x8a65 },
	{ 0x445b, 0x8a78 },
	{ 0x445c, 0x8a7d },
	{ 0x445d, 0x8a88 },
	{ 0x4460, 0x8a64 },
	{ 0x4461, 0x8a7e },
	{ 0x4463, 0x8a67 },
	{ 0x4464, 0x8c63 },
	{ 0x4465, 0x8c88 },
	{ 0x4467, 0x8ccd },
	{ 0x4469, 0x8cc9 },
	{ 0x446b, 0x8ded },
	{ 0x4473, 0x8eb1 },
	{ 0x4476, 0x8f04 },
	{ 0x4477, 0x8f9e },
	{ 0x4478, 0x8fa0 },
	{ 0x4479, 0x9043 },
	{ 0x447a, 0x9046 },
	{ 0x447b, 0x9048 },
	{ 0x447c, 0x9045 },
	{ 0x447d, 0x9040 },
	{ 0x447e, 0x904c },
	{ 0x4523, 0x910c },
	{ 0x4524, 0x9113 },
	{ 0x4525, 0x9115 },
	{ 0x4527, 0x916b },
	{ 0x4528, 0x9167 },
	{ 0x4529, 0x925d },
	{ 0x452a, 0x9255 },
	{ 0x452b, 0x9235 },
	{ 0x452d, 0x9259 },
	{ 0x452e, 0x922f },
	{ 0x452f, 0x923c },
	{ 0x4530, 0x928f },
	{ 0x4531, 0x925c },
	{ 0x4532, 0x926a },
	{ 0x4533, 0x9262 },
	{ 0x4534, 0x925f },
	{ 0x4535, 0x926b },
	{ 0x4536, 0x926e },
	{ 0x4537, 0x923b },
	{ 0x4538, 0x9244 },
	{ 0x4539, 0x9241 },
	{ 0x453a, 0x959a },
	{ 0x453c, 0x9599 },
	{ 0x4540, 0x968f },
	{ 0x4542, 0x9696 },
	{ 0x4546, 0x96f4 },
	{ 0x4547, 0x96fc },
	{ 0x4549, 0x9755 },
	{ 0x454b, 0x9779 },
	{ 0x454f, 0x97ee },
	{ 0x4550, 0x97f5 },
	{ 0x4552, 0x980b },
	{ 0x4554, 0x98f3 },
	{ 0x4557, 0x98f7 },
	{ 0x4558, 0x98ff },
	{ 0x4559, 0x98f5 },
	{ 0x455b, 0x98ec },
	{ 0x455c, 0x98f1 },
	{ 0x455f, 0x999a },
	{ 0x4561, 0x9ae2 },
	{ 0x4562, 0x9b3d },
	{ 0x4563, 0x9b5d },
	{ 0x4564, 0x9ce8 },
	{ 0x4566, 0x9ceb },
	{ 0x4567, 0x9cef },
	{ 0x4568, 0x9cee },
	{ 0x4569, 0x9e81 },
	{ 0x456a, 0x9f14 },
	{ 0x456b, 0x50d0 },
	{ 0x456c, 0x50d9 },
	{ 0x456d, 0x50dc },
	{ 0x456e, 0x50d8 },
	{ 0x4570, 0x50e1 },
	{ 0x4571, 0x50eb },
	{ 0x4574, 0x50f4 },
	{ 0x4575, 0x50e2 },
	{ 0x4576, 0x50de },
	{ 0x457a, 0x51f4 },
	{ 0x457e, 0x52ed },
	{ 0x4621, 0x52ea },
	{ 0x4623, 0x5332 },
	{ 0x4625, 0x53ae },
	{ 0x4626, 0x53b0 },
	{ 0x4628, 0x55fb },
	{ 0x4629, 0x5603 },
	{ 0x462a, 0x560b },
	{ 0x462c, 0x5607 },
	{ 0x462e, 0x55f8 },
	{ 0x4630, 0x5628 },
	{ 0x4631, 0x561e },
	{ 0x4633, 0x5618 },
	{ 0x4634, 0x5611 },
	{ 0x4635, 0x5651 },
	{ 0x4636, 0x5605 },
	{ 0x4637, 0x5717 },
	{ 0x4638, 0x5892 },
	{ 0x463a, 0x588c },
	{ 0x463c, 0x5878 },
	{ 0x463d, 0x5884 },
	{ 0x463e, 0x5873 },
	{ 0x463f, 0x58ad },
	{ 0x4640, 0x5897 },
	{ 0x4641, 0x5895 },
	{ 0x4642, 0x5877 },
	{ 0x4643, 0x5872 },
	{ 0x4644, 0x5896 },
	{ 0x4645, 0x588d },
	{ 0x4646, 0x5910 },
	{ 0x4648, 0x596c },
	{ 0x464a, 0x5ae7 },
	{ 0x464c, 0x5ae4 },
	{ 0x464f, 0x5aef },
	{ 0x4650, 0x5626 },
	{ 0x4653, 0x5af0 },
	{ 0x4654, 0x5d7b },
	{ 0x4656, 0x5d83 },
	{ 0x4659, 0x5d8b },
	{ 0x465a, 0x5d8c },
	{ 0x465c, 0x5d78 },
	{ 0x465d, 0x5e52 },
	{ 0x4660, 0x5ed0 },
	{ 0x4661, 0x5ecf },
	{ 0x4663, 0x5fb3 },
	{ 0x4664, 0x5fb4 },
	{ 0x4668, 0x617b },
	{ 0x466a, 0x616f },
	{ 0x466b, 0x6181 },
	{ 0x466c, 0x613c },
	{ 0x466d, 0x6142 },
	{ 0x466e, 0x6138 },
	{ 0x466f, 0x6133 },
	{ 0x4671, 0x6160 },
	{ 0x4672, 0x6169 },
	{ 0x4673, 0x617d },
	{ 0x4674, 0x6186 },
	{ 0x4675, 0x622c },
	{ 0x4676, 0x6228 },
	{ 0x4678, 0x644c },
	{ 0x467a, 0x6457 },
	{ 0x467b, 0x647c },
	{ 0x467e, 0x6455 },
	{ 0x4721, 0x6462 },
	{ 0x4722, 0x6471 },
	{ 0x4723, 0x646a },
	{ 0x4724, 0x6456 },
	{ 0x4725, 0x643b },
	{ 0x4726, 0x6481 },
	{ 0x4728, 0x644f },
	{ 0x4729, 0x647e },
	{ 0x472a, 0x6464 },
	{ 0x4730, 0x6571 },
	{ 0x4733, 0x66a5 },
	{ 0x4734, 0x669a },
	{ 0x4735, 0x669c },
	{ 0x4737, 0x66a6 },
	{ 0x4739, 0x66a4 },
	{ 0x473a, 0x698f },
	{ 0x473b, 0x69c5 },
	{ 0x473c, 0x69c8 },
	{ 0x473d, 0x6992 },
	{ 0x473e, 0x69b2 },
	{ 0x4742, 0x69e3 },
	{ 0x4743, 0x69c0 },
	{ 0x4744, 0x69d6 },
	{ 0x4745, 0x69d1 },
	{ 0x4746, 0x699f },
	{ 0x4747, 0x69a2 },
	{ 0x4748, 0x69d2 },
	{ 0x474c, 0x69e1 },
	{ 0x474d, 0x69d5 },
	{ 0x474e, 0x699d },
	{ 0x4751, 0x6998 },
	{ 0x4753, 0x6b74 },
	{ 0x4754, 0x6ba1 },
	{ 0x4756, 0x6ef0 },
	{ 0x4757, 0x6ef3 },
	{ 0x475a, 0x6f1b },
	{ 0x475b, 0x6f0c },
	{ 0x475c, 0x6f1d },
	{ 0x475d, 0x6f34 },
	{ 0x475e, 0x6f28 },
	{ 0x475f, 0x6f17 },
	{ 0x4761, 0x6f44 },
	{ 0x4762, 0x6f42 },
	{ 0x4763, 0x6f04 },
	{ 0x4764, 0x6f11 },
	{ 0x4765, 0x6efa },
	{ 0x4766, 0x6f4a },
	{ 0x4767, 0x7191 },
	{ 0x4768, 0x718e },
	{ 0x476a, 0x718b },
	{ 0x476b, 0x718d },
	{ 0x476c, 0x717f },
	{ 0x476d, 0x718c },
	{ 0x476e, 0x717e },
	{ 0x476f, 0x717c },
	{ 0x4770, 0x7183 },
	{ 0x4772, 0x7188 },
	{ 0x4775, 0x7294 },
	{ 0x4777, 0x7355 },
	{ 0x4778, 0x7353 },
	{ 0x4779, 0x734f },
	{ 0x477a, 0x7354 },
	{ 0x477b, 0x746c },
	{ 0x477c, 0x7465 },
	{ 0x477d, 0x7466 },
	{ 0x477e, 0x7461 },
	{ 0x4821, 0x746b },
	{ 0x4822, 0x7468 },
	{ 0x4823, 0x7476 },
	{ 0x4825, 0x7460 },
	{ 0x4827, 0x7474 },
	{ 0x4828, 0x7506 },
	{ 0x4829, 0x760e },
	{ 0x482b, 0x7607 },
	{ 0x482e, 0x76b9 },
	{ 0x4830, 0x76b7 },
	{ 0x4831, 0x76e2 },
	{ 0x4833, 0x7774 },
	{ 0x4834, 0x7777 },
	{ 0x4835, 0x7776 },
	{ 0x4836, 0x7775 },
	{ 0x4838, 0x7778 },
	{ 0x4839, 0x7771 },
	{ 0x483b, 0x777a },
	{ 0x483c, 0x715b },
	{ 0x483d, 0x777b },
	{ 0x483e, 0x78a6 },
	{ 0x483f, 0x78ae },
	{ 0x4840, 0x78b8 },
	{ 0x4844, 0x78b1 },
	{ 0x4845, 0x78af },
	{ 0x4847, 0x7989 },
	{ 0x4848, 0x7987 },
	{ 0x484b, 0x7a29 },
	{ 0x484d, 0x7a2a },
	{ 0x484f, 0x7a2d },
	{ 0x4850, 0x7a2c },
	{ 0x4852, 0x7a32 },
	{ 0x4854, 0x7aec },
	{ 0x4855, 0x7af0 },
	{ 0x4856, 0x7b81 },
	{ 0x4857, 0x7b9e },
	{ 0x4858, 0x7b83 },
	{ 0x485a, 0x7b92 },
	{ 0x485c, 0x7ba3 },
	{ 0x485d, 0x7b9f },
	{ 0x485e, 0x7b93 },
	{ 0x4860, 0x7b86 },
	{ 0x4861, 0x7cb8 },
	{ 0x4862, 0x7cb7 },
	{ 0x4868, 0x7dc8 },
	{ 0x4869, 0x7db6 },
	{ 0x486b, 0x7dd1 },
	{ 0x486d, 0x7da8 },
	{ 0x486e, 0x7dab },
	{ 0x4870, 0x7db3 },
	{ 0x4871, 0x7dcd },
	{ 0x4873, 0x7dcf },
	{ 0x4874, 0x7da4 },
	{ 0x4877, 0x7f41 },
	{ 0x4878, 0x7f6f },
	{ 0x4879, 0x7f71 },
	{ 0x4922, 0x8023 },
	{ 0x4923, 0x805b },
	{ 0x4925, 0x8061 },
	{ 0x4926, 0x805f },
	{ 0x4927, 0x8181 },
	{ 0x492a, 0x8184 },
	{ 0x492b, 0x8213 },
	{ 0x492d, 0x824a },
	{ 0x492e, 0x824c },
	{ 0x4932, 0x84bd },
	{ 0x4933, 0x8495 },
	{ 0x4935, 0x8492 },
	{ 0x4936, 0x84c3 },
	{ 0x4938, 0x8496 },
	{ 0x4939, 0x84a5 },
	{ 0x493a, 0x84b5 },
	{ 0x493b, 0x84b3 },
	{ 0x493c, 0x84a3 },
	{ 0x493d, 0x84e4 },
	{ 0x493e, 0x84d8 },
	{ 0x493f, 0x84d5 },
	{ 0x4941, 0x84b7 },
	{ 0x4942, 0x84ad },
	{ 0x4943, 0x84da },
	{ 0x4944, 0x8493 },
	{ 0x4945, 0x8736 },
	{ 0x4949, 0x873d },
	{ 0x494a, 0x872b },
	{ 0x494b, 0x8747 },
	{ 0x494c, 0x8739 },
	{ 0x494e, 0x8745 },
	{ 0x494f, 0x871d },
	{ 0x4951, 0x88ff },
	{ 0x4952, 0x88ea },
	{ 0x4954, 0x88f5 },
	{ 0x4956, 0x8900 },
	{ 0x4957, 0x88ed },
	{ 0x4958, 0x8903 },
	{ 0x4959, 0x88e9 },
	{ 0x495c, 0x89ea },
	{ 0x495e, 0x8a9b },
	{ 0x495f, 0x8a8e },
	{ 0x4960, 0x8aa2 },
	{ 0x4962, 0x8a9c },
	{ 0x4963, 0x8a94 },
	{ 0x4964, 0x8a90 },
	{ 0x4965, 0x8aa9 },
	{ 0x4966, 0x8aac },
	{ 0x4968, 0x8a9f },
	{ 0x496b, 0x8a9d },
	{ 0x496d, 0x8c67 },
	{ 0x4970, 0x8cd0 },
	{ 0x4971, 0x8cd6 },
	{ 0x4972, 0x8cd4 },
	{ 0x4973, 0x8d98 },
	{ 0x4974, 0x8d9a },
	{ 0x4975, 0x8d97 },
	{ 0x4979, 0x8e0b },
	{ 0x497a, 0x8e08 },
	{ 0x497b, 0x8e01 },
	{ 0x497c, 0x8eb4 },
	{ 0x497d, 0x8eb3 },
	{ 0x4a21, 0x8fa1 },
	{ 0x4a22, 0x8fa2 },
	{ 0x4a24, 0x905a },
	{ 0x4a26, 0x9061 },
	{ 0x4a27, 0x905f },
	{ 0x4a2a, 0x9125 },
	{ 0x4a2b, 0x917b },
	{ 0x4a2c, 0x9176 },
	{ 0x4a2d, 0x917c },
	{ 0x4a2f, 0x9289 },
	{ 0x4a30, 0x92f6 },
	{ 0x4a31, 0x92b1 },
	{ 0x4a32, 0x92ad },
	{ 0x4a33, 0x9292 },
	{ 0x4a34, 0x9281 },
	{ 0x4a35, 0x9284 },
	{ 0x4a37, 0x92ae },
	{ 0x4a38, 0x9290 },
	{ 0x4a39, 0x929e },
	{ 0x4a3d, 0x95a2 },
	{ 0x4a3e, 0x95a7 },
	{ 0x4a44, 0x96a0 },
	{ 0x4a45, 0x969d },
	{ 0x4a46, 0x969f },
	{ 0x4a47, 0x96d0 },
	{ 0x4a49, 0x96d1 },
	{ 0x4a4c, 0x9759 },
	{ 0x4a4e, 0x9764 },
	{ 0x4a52, 0x9819 },
	{ 0x4a54, 0x9814 },
	{ 0x4a55, 0x9815 },
	{ 0x4a56, 0x981a },
	{ 0x4a5b, 0x9906 },
	{ 0x4a5d, 0x98f8 },
	{ 0x4a5e, 0x9901 },
	{ 0x4a60, 0x99be },
	{ 0x4a61, 0x99bc },
	{ 0x4a62, 0x99b7 },
	{ 0x4a63, 0x99b6 },
	{ 0x4a64, 0x99c0 },
	{ 0x4a66, 0x99b8 },
	{ 0x4a6a, 0x99c4 },
	{ 0x4a6c, 0x99bf },
	{ 0x4a6e, 0x9ada },
	{ 0x4a6f, 0x9ae4 },
	{ 0x4a70, 0x9ae9 },
	{ 0x4a71, 0x9ae8 },
	{ 0x4a72, 0x9aea },
	{ 0x4a73, 0x9ae5 },
	{ 0x4a75, 0x9b26 },
	{ 0x4a78, 0x9b40 },
	{ 0x4b22, 0x9ebd },
	{ 0x4b27, 0x510e },
	{ 0x4b29, 0x50f7 },
	{ 0x4b2b, 0x50fc },
	{ 0x4b2c, 0x510d },
	{ 0x4b2d, 0x5101 },
	{ 0x4b2e, 0x51da },
	{ 0x4b2f, 0x51d9 },
	{ 0x4b30, 0x51db },
	{ 0x4b31, 0x5286 },
	{ 0x4b32, 0x528e },
	{ 0x4b33, 0x52ee },
	{ 0x4b34, 0x5333 },
	{ 0x4b35, 0x53b1 },
	{ 0x4b37, 0x5647 },
	{ 0x4b38, 0x562d },
	{ 0x4b39, 0x5654 },
	{ 0x4b3b, 0x564b },
	{ 0x4b3c, 0x5652 },
	{ 0x4b3d, 0x5631 },
	{ 0x4b3e, 0x5644 },
	{ 0x4b3f, 0x5656 },
	{ 0x4b40, 0x5650 },
	{ 0x4b41, 0x562b },
	{ 0x4b43, 0x564d },
	{ 0x4b44, 0x5637 },
	{ 0x4b45, 0x564f },
	{ 0x4b46, 0x58a2 },
	{ 0x4b47, 0x58b7 },
	{ 0x4b49, 0x58b2 },
	{ 0x4b4b, 0x58aa },
	{ 0x4b4c, 0x58b5 },
	{ 0x4b4d, 0x58b0 },
	{ 0x4b4f, 0x58b4 },
	{ 0x4b50, 0x58a4 },
	{ 0x4b51, 0x58a7 },
	{ 0x4b53, 0x5926 },
	{ 0x4b54, 0x5afe },
	{ 0x4b56, 0x5b04 },
	{ 0x4b58, 0x5afc },
	{ 0x4b5a, 0x5b06 },
	{ 0x4b5b, 0x5b0a },
	{ 0x4b5c, 0x5afa },
	{ 0x4b5d, 0x5b0d },
	{ 0x4b5e, 0x5b00 },
	{ 0x4b5f, 0x5b0e },
	{ 0x4b63, 0x5d91 },
	{ 0x4b65, 0x5d8f },
	{ 0x4b66, 0x5d90 },
	{ 0x4b67, 0x5d98 },
	{ 0x4b68, 0x5da4 },
	{ 0x4b69, 0x5d9b },
	{ 0x4b6a, 0x5da3 },
	{ 0x4b6b, 0x5d96 },
	{ 0x4b6c, 0x5de4 },
	{ 0x4b6d, 0x5e5a },
	{ 0x4b70, 0x5e5e },
	{ 0x4b72, 0x5fb8 },
	{ 0x4b73, 0x6157 },
	{ 0x4b74, 0x615c },
	{ 0x4b75, 0x61a6 },
	{ 0x4b76, 0x6195 },
	{ 0x4b77, 0x6188 },
	{ 0x4b79, 0x61a3 },
	{ 0x4b7a, 0x618f },
	{ 0x4b7c, 0x6164 },
	{ 0x4b7e, 0x6159 },
	{ 0x4c21, 0x6178 },
	{ 0x4c23, 0x6185 },
	{ 0x4c24, 0x6187 },
	{ 0x4c25, 0x619e },
	{ 0x4c28, 0x6198 },
	{ 0x4c29, 0x619c },
	{ 0x4c2c, 0x622f },
	{ 0x4c2d, 0x6480 },
	{ 0x4c2e, 0x649b },
	{ 0x4c2f, 0x648e },
	{ 0x4c30, 0x648d },
	{ 0x4c31, 0x6494 },
	{ 0x4c32, 0x64c6 },
	{ 0x4c34, 0x64a8 },
	{ 0x4c35, 0x6483 },
	{ 0x4c37, 0x64b9 },
	{ 0x4c38, 0x6486 },
	{ 0x4c39, 0x64b4 },
	{ 0x4c3a, 0x64af },
	{ 0x4c3b, 0x6491 },
	{ 0x4c3d, 0x64aa },
	{ 0x4c3e, 0x64a1 },
	{ 0x4c3f, 0x64a7 },
	{ 0x4c40, 0x66b6 },
	{ 0x4c41, 0x66b3 },
	{ 0x4c43, 0x66bc },
	{ 0x4c44, 0x66ac },
	{ 0x4c46, 0x66ad },
	{ 0x4c47, 0x6a0e },
	{ 0x4c49, 0x6a1c },
	{ 0x4c4a, 0x6a1a },
	{ 0x4c4d, 0x6a0b },
	{ 0x4c4f, 0x69ef },
	{ 0x4c50, 0x6a0c },
	{ 0x4c51, 0x69f0 },
	{ 0x4c52, 0x6a22 },
	{ 0x4c54, 0x69d8 },
	{ 0x4c56, 0x6a12 },
	{ 0x4c57, 0x69fa },
	{ 0x4c59, 0x6a2a },
	{ 0x4c5b, 0x6a10 },
	{ 0x4c5e, 0x6a29 },
	{ 0x4c5f, 0x69f9 },
	{ 0x4c60, 0x69ea },
	{ 0x4c61, 0x6a2c },
	{ 0x4c62, 0x6a24 },
	{ 0x4c64, 0x69e9 },
	{ 0x4c65, 0x6b52 },
	{ 0x4c66, 0x6b4f },
	{ 0x4c67, 0x6b53 },
	{ 0x4c6a, 0x6f10 },
	{ 0x4c6b, 0x6f65 },
	{ 0x4c6c, 0x6f75 },
	{ 0x4c71, 0x6fd0 },
	{ 0x4c73, 0x6f5c },
	{ 0x4c74, 0x6f3d },
	{ 0x4c75, 0x6f71 },
	{ 0x4c77, 0x6f91 },
	{ 0x4c78, 0x6f0b },
	{ 0x4c79, 0x6f79 },
	{ 0x4c7a, 0x6f81 },
	{ 0x4c7b, 0x6f8f },
	{ 0x4c7d, 0x6f59 },
	{ 0x4c7e, 0x6f74 },
	{ 0x4d22, 0x71ae },
	{ 0x4d24, 0x71a3 },
	{ 0x4d25, 0x71ad },
	{ 0x4d28, 0x71ab },
	{ 0x4d29, 0x71a6 },
	{ 0x4d2a, 0x71a2 },
	{ 0x4d2c, 0x52f2 },
	{ 0x4d2d, 0x7257 },
	{ 0x4d2e, 0x7255 },
	{ 0x4d2f, 0x7299 },
	{ 0x4d30, 0x734b },
	{ 0x4d31, 0x747a },
	{ 0x4d35, 0x748c },
	{ 0x4d36, 0x7484 },
	{ 0x4d39, 0x7482 },
	{ 0x4d3a, 0x7493 },
	{ 0x4d3b, 0x747b },
	{ 0x4d3d, 0x7509 },
	{ 0x4d44, 0x778a },
	{ 0x4d46, 0x7790 },
	{ 0x4d48, 0x78c6 },
	{ 0x4d49, 0x78d3 },
	{ 0x4d4a, 0x78c0 },
	{ 0x4d4b, 0x78d2 },
	{ 0x4d4c, 0x78c7 },
	{ 0x4d4d, 0x78c2 },
	{ 0x4d4f, 0x799f },
	{ 0x4d50, 0x799d },
	{ 0x4d51, 0x799e },
	{ 0x4d53, 0x7a41 },
	{ 0x4d55, 0x7a38 },
	{ 0x4d56, 0x7a3a },
	{ 0x4d57, 0x7a42 },
	{ 0x4d5a, 0x7a3e },
	{ 0x4d5b, 0x7ab0 },
	{ 0x4d5c, 0x7bae },
	{ 0x4d5d, 0x7bb3 },
	{ 0x4d60, 0x7bbf },
	{ 0x4d63, 0x7bcd },
	{ 0x4d65, 0x7bb2 },
	{ 0x4d6d, 0x7cc4 },
	{ 0x4d6e, 0x7ccd },
	{ 0x4d6f, 0x7cc2 },
	{ 0x4d70, 0x7cc6 },
	{ 0x4d71, 0x7cc3 },
	{ 0x4d72, 0x7cc9 },
	{ 0x4d73, 0x7cc7 },
	{ 0x4d75, 0x7df8 },
	{ 0x4d77, 0x7ded },
	{ 0x4d78, 0x7de2 },
	{ 0x4d7c, 0x7ddc },
	{ 0x4d7d, 0x7e02 },
	{ 0x4d7e, 0x7e01 },
	{ 0x4e22, 0x7dd6 },
	{ 0x4e24, 0x7de4 },
	{ 0x4e25, 0x7dfe },
	{ 0x4e27, 0x7e00 },
	{ 0x4e28, 0x7dfc },
	{ 0x4e29, 0x7dfd },
	{ 0x4e2b, 0x7df5 },
	{ 0x4e2c, 0x7dff },
	{ 0x4e2e, 0x7deb },
	{ 0x4e2f, 0x7de5 },
	{ 0x4e30, 0x7f78 },
	{ 0x4e31, 0x7fae },
	{ 0x4e32, 0x7fe7 },
	{ 0x4e34, 0x8065 },
	{ 0x4e35, 0x806a },
	{ 0x4e36, 0x8066 },
	{ 0x4e37, 0x8068 },
	{ 0x4e38, 0x806b },
	{ 0x4e39, 0x8194 },
	{ 0x4e3a, 0x81a1 },
	{ 0x4e3b, 0x8192 },
	{ 0x4e3c, 0x8196 },
	{ 0x4e3d, 0x8193 },
	{ 0x4e40, 0x8501 },
	{ 0x4e42, 0x84f8 },
	{ 0x4e44, 0x84f5 },
	{ 0x4e46, 0x8504 },
	{ 0x4e4b, 0x851b },
	{ 0x4e4c, 0x8503 },
	{ 0x4e4d, 0x8533 },
	{ 0x4e4e, 0x8534 },
	{ 0x4e4f, 0x84ed },
	{ 0x4e52, 0x8535 },
	{ 0x4e54, 0x8505 },
	{ 0x4e59, 0x877d },
	{ 0x4e5d, 0x8771 },
	{ 0x4e5f, 0x885c },
	{ 0x4e60, 0x88e6 },
	{ 0x4e61, 0x890f },
	{ 0x4e62, 0x891b },
	{ 0x4e64, 0x89a9 },
	{ 0x4e65, 0x89a5 },
	{ 0x4e66, 0x89ee },
	{ 0x4e67, 0x8ab1 },
	{ 0x4e69, 0x8acc },
	{ 0x4e6a, 0x8ace },
	{ 0x4e6c, 0x8ab7 },
	{ 0x4e6e, 0x8ab5 },
	{ 0x4e6f, 0x8ae9 },
	{ 0x4e70, 0x8ab4 },
	{ 0x4e72, 0x8ab3 },
	{ 0x4e73, 0x8ac1 },
	{ 0x4e74, 0x8aaf },
	{ 0x4e75, 0x8aca },
	{ 0x4e76, 0x8ad0 },
	{ 0x4e7a, 0x8c8e },
	{ 0x4e7d, 0x8ce9 },
	{ 0x4e7e, 0x8cdb },
	{ 0x4f22, 0x8ceb },
	{ 0x4f23, 0x8da4 },
	{ 0x4f25, 0x8da2 },
	{ 0x4f26, 0x8d9d },
	{ 0x4f2b, 0x8e2a },
	{ 0x4f2c, 0x8e28 },
	{ 0x4f2f, 0x8eb8 },
	{ 0x4f30, 0x8eb6 },
	{ 0x4f31, 0x8eb9 },
	{ 0x4f32, 0x8eb7 },
	{ 0x4f33, 0x8f22 },
	{ 0x4f34, 0x8f2b },
	{ 0x4f35, 0x8f27 },
	{ 0x4f36, 0x8f19 },
	{ 0x4f37, 0x8fa4 },
	{ 0x4f39, 0x8fb3 },
	{ 0x4f3b, 0x9071 },
	{ 0x4f3c, 0x906a },
	{ 0x4f3f, 0x9188 },
	{ 0x4f40, 0x918c },
	{ 0x4f41, 0x92bf },
	{ 0x4f42, 0x92b8 },
	{ 0x4f43, 0x92be },
	{ 0x4f44, 0x92dc },
	{ 0x4f45, 0x92e5 },
	{ 0x4f48, 0x92d4 },
	{ 0x4f49, 0x92d6 },
	{ 0x4f4b, 0x92da },
	{ 0x4f4c, 0x92ed },
	{ 0x4f4d, 0x92f3 },
	{ 0x4f4e, 0x92db },
	{ 0x4f50, 0x92b9 },
	{ 0x4f51, 0x92e2 },
	{ 0x4f52, 0x92eb },
	{ 0x4f53, 0x95af },
	{ 0x4f55, 0x95b2 },
	{ 0x4f56, 0x95b3 },
	{ 0x4f5a, 0x96a3 },
	{ 0x4f5b, 0x96a5 },
	{ 0x4f60, 0x970a },
	{ 0x4f62, 0x9787 },
	{ 0x4f63, 0x9789 },
	{ 0x4f64, 0x978c },
	{ 0x4f65, 0x97ef },
	{ 0x4f66, 0x982a },
	{ 0x4f67, 0x9822 },
	{ 0x4f69, 0x981f },
	{ 0x4f6b, 0x9919 },
	{ 0x4f6d, 0x99ca },
	{ 0x4f6e, 0x99da },
	{ 0x4f72, 0x99de },
	{ 0x4f73, 0x99c8 },
	{ 0x4f74, 0x99e0 },
	{ 0x4f76, 0x9ab6 },
	{ 0x4f77, 0x9ab5 },
	{ 0x4f79, 0x9af4 },
	{ 0x4f7b, 0x9b6b },
	{ 0x4f7c, 0x9b69 },
	{ 0x4f7d, 0x9b72 },
	{ 0x4f7e, 0x9b63 },
	{ 0x5022, 0x9d0d },
	{ 0x5024, 0x9d01 },
	{ 0x5025, 0x9d0c },
	{ 0x5027, 0x9cf8 },
	{ 0x502a, 0x9cfe },
	{ 0x502b, 0x9d02 },
	{ 0x502c, 0x9e84 },
	{ 0x502e, 0x9eab },
	{ 0x502f, 0x9eaa },
	{ 0x5030, 0x511d },
	{ 0x5031, 0x5116 },
	{ 0x5033, 0x512b },
	{ 0x5034, 0x511e },
	{ 0x5035, 0x511b },
	{ 0x5036, 0x5290 },
	{ 0x5037, 0x5294 },
	{ 0x5038, 0x5314 },
	{ 0x503b, 0x5667 },
	{ 0x503d, 0x567b },
	{ 0x503f, 0x565f },
	{ 0x5040, 0x5661 },
	{ 0x5048, 0x58c3 },
	{ 0x5049, 0x58ca },
	{ 0x504a, 0x58bb },
	{ 0x504b, 0x58c0 },
	{ 0x504c, 0x58c4 },
	{ 0x504d, 0x5901 },
	{ 0x504e, 0x5b1f },
	{ 0x504f, 0x5b18 },
	{ 0x5050, 0x5b11 },
	{ 0x5051, 0x5b15 },
	{ 0x5053, 0x5b12 },
	{ 0x5054, 0x5b1c },
	{ 0x5056, 0x5b22 },
	{ 0x5057, 0x5b79 },
	{ 0x5058, 0x5da6 },
	{ 0x505a, 0x5db3 },
	{ 0x505b, 0x5dab },
	{ 0x505c, 0x5eea },
	{ 0x505e, 0x5f5b },
	{ 0x5061, 0x61b7 },
	{ 0x5062, 0x61ce },
	{ 0x5063, 0x61b9 },
	{ 0x5064, 0x61bd },
	{ 0x5065, 0x61cf },
	{ 0x5066, 0x61c0 },
	{ 0x5067, 0x6199 },
	{ 0x5068, 0x6197 },
	{ 0x506a, 0x61bb },
	{ 0x506b, 0x61d0 },
	{ 0x506c, 0x61c4 },
	{ 0x506d, 0x6231 },
	{ 0x506f, 0x64d3 },
	{ 0x5070, 0x64c0 },
	{ 0x5075, 0x64dc },
	{ 0x5076, 0x64d1 },
	{ 0x5077, 0x64c8 },
	{ 0x5079, 0x64d5 },
	{ 0x507a, 0x66c3 },
	{ 0x507d, 0x66bf },
	{ 0x507e, 0x66c5 },
	{ 0x5122, 0x66cd },
	{ 0x5123, 0x66c1 },
	{ 0x5124, 0x6706 },
	{ 0x5126, 0x6724 },
	{ 0x5127, 0x6a63 },
	{ 0x5128, 0x6a42 },
	{ 0x5129, 0x6a52 },
	{ 0x512b, 0x6a43 },
	{ 0x512c, 0x6a33 },
	{ 0x512e, 0x6a6c },
	{ 0x512f, 0x6a57 },
	{ 0x5131, 0x6a4c },
	{ 0x5132, 0x6a6e },
	{ 0x5138, 0x6a37 },
	{ 0x513a, 0x6a71 },
	{ 0x513b, 0x6a4a },
	{ 0x513c, 0x6a36 },
	{ 0x513e, 0x6a53 },
	{ 0x5140, 0x6a45 },
	{ 0x5141, 0x6a70 },
	{ 0x5144, 0x6a5c },
	{ 0x5145, 0x6b58 },
	{ 0x5146, 0x6b57 },
	{ 0x514d, 0x6fbb },
	{ 0x5150, 0x6fbe },
	{ 0x5154, 0x6fb5 },
	{ 0x5155, 0x6fd3 },
	{ 0x5156, 0x6f9f },
	{ 0x5158, 0x6fb7 },
	{ 0x5159, 0x6ff5 },
	{ 0x515a, 0x71b7 },
	{ 0x515c, 0x71bb },
	{ 0x515e, 0x71d1 },
	{ 0x5160, 0x71ba },
	{ 0x5162, 0x71b6 },
	{ 0x5163, 0x71cc },
	{ 0x5166, 0x71d3 },
	{ 0x5167, 0x749b },
	{ 0x516a, 0x7496 },
	{ 0x516b, 0x74a2 },
	{ 0x516c, 0x749d },
	{ 0x516d, 0x750a },
	{ 0x516e, 0x750e },
	{ 0x5170, 0x7581 },
	{ 0x5171, 0x762c },
	{ 0x5172, 0x7637 },
	{ 0x5173, 0x7636 },
	{ 0x5174, 0x763b },
	{ 0x5176, 0x76a1 },
	{ 0x5179, 0x7798 },
	{ 0x517b, 0x7796 },
	{ 0x5221, 0x78d6 },
	{ 0x5222, 0x78eb },
	{ 0x5224, 0x78dc },
	{ 0x5226, 0x79a5 },
	{ 0x5227, 0x79a9 },
	{ 0x5228, 0x9834 },
	{ 0x5229, 0x7a53 },
	{ 0x522a, 0x7a45 },
	{ 0x522c, 0x7a4f },
	{ 0x522e, 0x7abd },
	{ 0x522f, 0x7abb },
	{ 0x5230, 0x7af1 },
	{ 0x5233, 0x7bec },
	{ 0x5234, 0x7bed },
	{ 0x5237, 0x7cd3 },
	{ 0x5239, 0x7ce1 },
	{ 0x523b, 0x7e19 },
	{ 0x523f, 0x7e27 },
	{ 0x5240, 0x7e26 },
	{ 0x5243, 0x806e },
	{ 0x5244, 0x81af },
	{ 0x5247, 0x81ad },
	{ 0x5249, 0x81aa },
	{ 0x524a, 0x8218 },
	{ 0x524f, 0x856f },
	{ 0x5250, 0x854c },
	{ 0x5252, 0x8542 },
	{ 0x5254, 0x855c },
	{ 0x5255, 0x8570 },
	{ 0x5256, 0x855f },
	{ 0x5258, 0x855a },
	{ 0x5259, 0x854b },
	{ 0x525a, 0x853f },
	{ 0x525b, 0x878a },
	{ 0x525d, 0x878b },
	{ 0x525e, 0x87a1 },
	{ 0x525f, 0x878e },
	{ 0x5262, 0x8799 },
	{ 0x5263, 0x885e },
	{ 0x5264, 0x885f },
	{ 0x5265, 0x8924 },
	{ 0x5266, 0x89a7 },
	{ 0x5267, 0x8aea },
	{ 0x5268, 0x8afd },
	{ 0x5269, 0x8af9 },
	{ 0x526a, 0x8ae3 },
	{ 0x526b, 0x8ae5 },
	{ 0x526e, 0x8aec },
	{ 0x5273, 0x8cf2 },
	{ 0x5275, 0x8cef },
	{ 0x5277, 0x8da6 },
	{ 0x527b, 0x8e3b },
	{ 0x527c, 0x8e43 },
	{ 0x527e, 0x8e32 },
	{ 0x5321, 0x8f31 },
	{ 0x5322, 0x8f30 },
	{ 0x5324, 0x8f2d },
	{ 0x5325, 0x8f3c },
	{ 0x5326, 0x8fa7 },
	{ 0x5327, 0x8fa5 },
	{ 0x532b, 0x9137 },
	{ 0x532c, 0x9195 },
	{ 0x532d, 0x918e },
	{ 0x532f, 0x9196 },
	{ 0x5331, 0x9345 },
	{ 0x5332, 0x930a },
	{ 0x5335, 0x92fd },
	{ 0x5336, 0x9317 },
	{ 0x5337, 0x931c },
	{ 0x5338, 0x9307 },
	{ 0x5339, 0x9331 },
	{ 0x533a, 0x9332 },
	{ 0x533b, 0x932c },
	{ 0x533c, 0x9330 },
	{ 0x533d, 0x9303 },
	{ 0x533e, 0x9305 },
	{ 0x5340, 0x95c2 },
	{ 0x5342, 0x95b8 },
	{ 0x5344, 0x95c1 },
	{ 0x5348, 0x96ab },
	{ 0x5349, 0x96b7 },
	{ 0x534c, 0x9715 },
	{ 0x534d, 0x9714 },
	{ 0x5350, 0x970c },
	{ 0x5351, 0x9717 },
	{ 0x5353, 0x9793 },
	{ 0x5355, 0x97d2 },
	{ 0x5358, 0x9836 },
	{ 0x5359, 0x9831 },
	{ 0x535a, 0x9833 },
	{ 0x535b, 0x983c },
	{ 0x535c, 0x982e },
	{ 0x535d, 0x983a },
	{ 0x535f, 0x983d },
	{ 0x5361, 0x98b5 },
	{ 0x5362, 0x9922 },
	{ 0x5363, 0x9923 },
	{ 0x5364, 0x9920 },
	{ 0x5365, 0x991c },
	{ 0x5366, 0x991d },
	{ 0x5368, 0x99a0 },
	{ 0x536a, 0x99ef },
	{ 0x536b, 0x99e8 },
	{ 0x536c, 0x99eb },
	{ 0x5370, 0x99e1 },
	{ 0x5371, 0x99e6 },
	{ 0x5374, 0x9af8 },
	{ 0x5375, 0x9af5 },
	{ 0x5378, 0x9b83 },
	{ 0x5379, 0x9b94 },
	{ 0x537a, 0x9b84 },
	{ 0x537c, 0x9b8b },
	{ 0x537d, 0x9b8f },
	{ 0x5421, 0x9b8c },
	{ 0x5423, 0x9b89 },
	{ 0x5425, 0x9b8e },
	{ 0x5429, 0x9d24 },
	{ 0x542a, 0x9d0f },
	{ 0x542c, 0x9d13 },
	{ 0x542d, 0x9d0a },
	{ 0x5432, 0x9d2a },
	{ 0x5433, 0x9d1a },
	{ 0x5435, 0x9d27 },
	{ 0x5436, 0x9d16 },
	{ 0x5437, 0x9d21 },
	{ 0x5439, 0x9e85 },
	{ 0x543a, 0x9eac },
	{ 0x543b, 0x9ec6 },
	{ 0x543c, 0x9ec5 },
	{ 0x543d, 0x9ed7 },
	{ 0x543e, 0x9f53 },
	{ 0x5440, 0x5128 },
	{ 0x5441, 0x5127 },
	{ 0x5442, 0x51df },
	{ 0x5444, 0x5335 },
	{ 0x5445, 0x53b3 },
	{ 0x5447, 0x568a },
	{ 0x5448, 0x567d },
	{ 0x5449, 0x5689 },
	{ 0x544b, 0x58cd },
	{ 0x544c, 0x58d0 },
	{ 0x544e, 0x5b2b },
	{ 0x544f, 0x5b33 },
	{ 0x5450, 0x5b29 },
	{ 0x5451, 0x5b35 },
	{ 0x5452, 0x5b31 },
	{ 0x5453, 0x5b37 },
	{ 0x5454, 0x5c36 },
	{ 0x5455, 0x5dbe },
	{ 0x5457, 0x5db9 },
	{ 0x5459, 0x5dbb },
	{ 0x545b, 0x61e2 },
	{ 0x545c, 0x61db },
	{ 0x545d, 0x61dd },
	{ 0x545e, 0x61dc },
	{ 0x545f, 0x61da },
	{ 0x5461, 0x61d9 },
	{ 0x5464, 0x64df },
	{ 0x5467, 0x64e1 },
	{ 0x5469, 0x64ee },
	{ 0x546b, 0x65b5 },
	{ 0x546c, 0x66d4 },
	{ 0x546d, 0x66d5 },
	{ 0x546f, 0x66d0 },
	{ 0x5470, 0x66d1 },
	{ 0x5471, 0x66ce },
	{ 0x5472, 0x66d7 },
	{ 0x5475, 0x6a7d },
	{ 0x5476, 0x6a8a },
	{ 0x5478, 0x6aa7 },
	{ 0x547a, 0x6a99 },
	{ 0x547b, 0x6a82 },
	{ 0x547c, 0x6a88 },
	{ 0x5521, 0x6a86 },
	{ 0x5523, 0x6a98 },
	{ 0x5524, 0x6a9d },
	{ 0x5527, 0x6a8f },
	{ 0x5529, 0x6aaa },
	{ 0x552b, 0x6b5d },
	{ 0x552d, 0x6c0a },
	{ 0x552f, 0x6fd7 },
	{ 0x5530, 0x6fd6 },
	{ 0x5531, 0x6fe5 },
	{ 0x5535, 0x6fd9 },
	{ 0x5536, 0x6fda },
	{ 0x5537, 0x6fea },
	{ 0x5539, 0x6ff6 },
	{ 0x553c, 0x71e3 },
	{ 0x553e, 0x71e9 },
	{ 0x5540, 0x71eb },
	{ 0x5541, 0x71ef },
	{ 0x5542, 0x71f3 },
	{ 0x5543, 0x71ea },
	{ 0x5549, 0x7371 },
	{ 0x554b, 0x74ae },
	{ 0x554d, 0x74b3 },
	{ 0x554f, 0x74ac },
	{ 0x5552, 0x7583 },
	{ 0x5553, 0x7645 },
	{ 0x5554, 0x764e },
	{ 0x5555, 0x7644 },
	{ 0x5556, 0x76a3 },
	{ 0x5557, 0x76a5 },
	{ 0x5558, 0x77a6 },
	{ 0x5559, 0x77a4 },
	{ 0x555b, 0x77a9 },
	{ 0x555c, 0x77af },
	{ 0x5560, 0x78f0 },
	{ 0x5561, 0x78f8 },
	{ 0x5562, 0x78f1 },
	{ 0x5564, 0x7a49 },
	{ 0x5568, 0x7ac2 },
	{ 0x5569, 0x7af2 },
	{ 0x556a, 0x7af3 },
	{ 0x556b, 0x7bfa },
	{ 0x556d, 0x7bf6 },
	{ 0x556e, 0x7bfc },
	{ 0x556f, 0x7c18 },
	{ 0x5570, 0x7c08 },
	{ 0x5571, 0x7c12 },
	{ 0x5574, 0x7cdb },
	{ 0x5575, 0x7cda },
	{ 0x5579, 0x7e2c },
	{ 0x557a, 0x7e4d },
	{ 0x557d, 0x7f46 },
	{ 0x557e, 0x7ff6 },
	{ 0x5621, 0x802b },
	{ 0x5622, 0x8074 },
	{ 0x5623, 0x81b8 },
	{ 0x5624, 0x81c8 },
	{ 0x5628, 0x8592 },
	{ 0x5629, 0x8593 },
	{ 0x562b, 0x857f },
	{ 0x562c, 0x85ab },
	{ 0x562d, 0x8597 },
	{ 0x5630, 0x85ac },
	{ 0x5634, 0x87ce },
	{ 0x5636, 0x87cd },
	{ 0x5639, 0x87c1 },
	{ 0x563a, 0x87b1 },
	{ 0x563b, 0x87c7 },
	{ 0x563d, 0x8940 },
	{ 0x563f, 0x893f },
	{ 0x5640, 0x8939 },
	{ 0x5642, 0x8943 },
	{ 0x5646, 0x89ab },
	{ 0x5648, 0x8b1f },
	{ 0x5649, 0x8b09 },
	{ 0x564a, 0x8b0c },
	{ 0x564d, 0x8c40 },
	{ 0x564f, 0x8c96 },
	{ 0x5651, 0x8cf6 },
	{ 0x5652, 0x8cf7 },
	{ 0x5654, 0x8e46 },
	{ 0x5655, 0x8e4f },
	{ 0x5659, 0x8f3d },
	{ 0x565a, 0x8f41 },
	{ 0x565b, 0x9366 },
	{ 0x565c, 0x9378 },
	{ 0x565d, 0x935d },
	{ 0x565e, 0x9369 },
	{ 0x565f, 0x9374 },
	{ 0x5660, 0x937d },
	{ 0x5661, 0x936e },
	{ 0x5662, 0x9372 },
	{ 0x5663, 0x9373 },
	{ 0x5664, 0x9362 },
	{ 0x5665, 0x9348 },
	{ 0x5666, 0x9353 },
	{ 0x5667, 0x935f },
	{ 0x5668, 0x9368 },
	{ 0x566a, 0x937f },
	{ 0x566b, 0x936b },
	{ 0x566d, 0x95c4 },
	{ 0x566f, 0x96af },
	{ 0x5670, 0x96ad },
	{ 0x5671, 0x96b2 },
	{ 0x5674, 0x971a },
	{ 0x5675, 0x971b },
	{ 0x567a, 0x979b },
	{ 0x567b, 0x979f },
	{ 0x5726, 0x9840 },
	{ 0x5728, 0x9847 },
	{ 0x572a, 0x98b7 },
	{ 0x5730, 0x99a2 },
	{ 0x5733, 0x9a00 },
	{ 0x5734, 0x99f3 },
	{ 0x5737, 0x99f5 },
	{ 0x573a, 0x9abd },
	{ 0x573b, 0x9b00 },
	{ 0x573c, 0x9b02 },
	{ 0x573e, 0x9b34 },
	{ 0x573f, 0x9b49 },
	{ 0x5740, 0x9b9f },
	{ 0x5742, 0x9ba3 },
	{ 0x5743, 0x9bcd },
	{ 0x5744, 0x9b99 },
	{ 0x5745, 0x9b9d },
	{ 0x5748, 0x9d39 },
	{ 0x574a, 0x9d44 },
	{ 0x574d, 0x9d35 },
	{ 0x5750, 0x9eaf },
	{ 0x5752, 0x512f },
	{ 0x5755, 0x9f8e },
	{ 0x5757, 0x569f },
	{ 0x5758, 0x569b },
	{ 0x5759, 0x569e },
	{ 0x575a, 0x5696 },
	{ 0x575b, 0x5694 },
	{ 0x575c, 0x56a0 },
	{ 0x575e, 0x5b3b },
	{ 0x5761, 0x5b3a },
	{ 0x5762, 0x5dc1 },
	{ 0x5763, 0x5f4d },
	{ 0x5764, 0x5f5d },
	{ 0x5765, 0x61f3 },
	{ 0x576a, 0x64f6 },
	{ 0x576b, 0x64e5 },
	{ 0x576c, 0x64ea },
	{ 0x576d, 0x64e7 },
	{ 0x576e, 0x6505 },
	{ 0x5770, 0x64f9 },
	{ 0x5774, 0x6aab },
	{ 0x5775, 0x6aed },
	{ 0x5776, 0x6ab2 },
	{ 0x5777, 0x6ab0 },
	{ 0x5778, 0x6ab5 },
	{ 0x5779, 0x6abe },
	{ 0x577a, 0x6ac1 },
	{ 0x577b, 0x6ac8 },
	{ 0x577d, 0x6ac0 },
	{ 0x577e, 0x6abc },
	{ 0x5821, 0x6ab1 },
	{ 0x5822, 0x6ac4 },
	{ 0x5823, 0x6abf },
	{ 0x5826, 0x7008 },
	{ 0x5827, 0x7003 },
	{ 0x5828, 0x6ffd },
	{ 0x5829, 0x7010 },
	{ 0x582a, 0x7002 },
	{ 0x582b, 0x7013 },
	{ 0x582d, 0x71fa },
	{ 0x582e, 0x7200 },
	{ 0x582f, 0x74b9 },
	{ 0x5830, 0x74bc },
	{ 0x5832, 0x765b },
	{ 0x5833, 0x7651 },
	{ 0x5834, 0x764f },
	{ 0x5835, 0x76eb },
	{ 0x5836, 0x77b8 },
	{ 0x5838, 0x77b9 },
	{ 0x5839, 0x77c1 },
	{ 0x583a, 0x77c0 },
	{ 0x583b, 0x77be },
	{ 0x583c, 0x790b },
	{ 0x583e, 0x7907 },
	{ 0x583f, 0x790a },
	{ 0x5840, 0x7908 },
	{ 0x5842, 0x790d },
	{ 0x5843, 0x7906 },
	{ 0x5844, 0x7915 },
	{ 0x5845, 0x79af },
	{ 0x5849, 0x7af5 },
	{ 0x584c, 0x7c2e },
	{ 0x584e, 0x7c1b },
	{ 0x5850, 0x7c1a },
	{ 0x5851, 0x7c24 },
	{ 0x5854, 0x7ce6 },
	{ 0x5855, 0x7ce3 },
	{ 0x5858, 0x7e5d },
	{ 0x5859, 0x7e4f },
	{ 0x585a, 0x7e66 },
	{ 0x585b, 0x7e5b },
	{ 0x585c, 0x7f47 },
	{ 0x585d, 0x7fb4 },
	{ 0x5861, 0x7ffa },
	{ 0x5862, 0x802e },
	{ 0x5865, 0x81ce },
	{ 0x5868, 0x8219 },
	{ 0x586b, 0x85cc },
	{ 0x586c, 0x85b2 },
	{ 0x586e, 0x85bb },
	{ 0x586f, 0x85c1 },
	{ 0x5873, 0x87e9 },
	{ 0x5874, 0x87ee },
	{ 0x5875, 0x87f0 },
	{ 0x5876, 0x87d6 },
	{ 0x5877, 0x880e },
	{ 0x5878, 0x87da },
	{ 0x5879, 0x8948 },
	{ 0x587a, 0x894a },
	{ 0x587b, 0x894e },
	{ 0x587c, 0x894d },
	{ 0x587d, 0x89b1 },
	{ 0x587e, 0x89b0 },
	{ 0x5921, 0x89b3 },
	{ 0x5923, 0x8b38 },
	{ 0x5924, 0x8b32 },
	{ 0x5926, 0x8b2d },
	{ 0x5928, 0x8b34 },
	{ 0x592a, 0x8b29 },
	{ 0x592b, 0x8c74 },
	{ 0x592e, 0x8d03 },
	{ 0x5931, 0x8da9 },
	{ 0x5932, 0x8e58 },
	{ 0x5935, 0x8ebf },
	{ 0x5936, 0x8ec1 },
	{ 0x5937, 0x8f4a },
	{ 0x5938, 0x8fac },
	{ 0x593a, 0x9089 },
	{ 0x593b, 0x913d },
	{ 0x593c, 0x913c },
	{ 0x593d, 0x91a9 },
	{ 0x593e, 0x93a0 },
	{ 0x5940, 0x9390 },
	{ 0x5942, 0x9393 },
	{ 0x5943, 0x938b },
	{ 0x5944, 0x93ad },
	{ 0x5945, 0x93bb },
	{ 0x5946, 0x93b8 },
	{ 0x5949, 0x939c },
	{ 0x594a, 0x95d8 },
	{ 0x594b, 0x95d7 },
	{ 0x594f, 0x975d },
	{ 0x5950, 0x97a9 },
	{ 0x5951, 0x97da },
	{ 0x5956, 0x9854 },
	{ 0x5958, 0x9855 },
	{ 0x5959, 0x984b },
	{ 0x595b, 0x983f },
	{ 0x595c, 0x98b9 },
	{ 0x5961, 0x9938 },
	{ 0x5962, 0x9936 },
	{ 0x5963, 0x9940 },
	{ 0x5965, 0x993b },
	{ 0x5966, 0x9939 },
	{ 0x5967, 0x99a4 },
	{ 0x596a, 0x9a08 },
	{ 0x596b, 0x9a0c },
	{ 0x596d, 0x9a10 },
	{ 0x596f, 0x9b07 },
	{ 0x5971, 0x9bd2 },
	{ 0x5973, 0x9bc2 },
	{ 0x5974, 0x9bbb },
	{ 0x5975, 0x9bcc },
	{ 0x5976, 0x9bcb },
	{ 0x5979, 0x9d4d },
	{ 0x597a, 0x9d63 },
	{ 0x597b, 0x9d4e },
	{ 0x597d, 0x9d50 },
	{ 0x597e, 0x9d55 },
	{ 0x5a22, 0x9d5e },
	{ 0x5a24, 0x9e90 },
	{ 0x5a25, 0x9eb2 },
	{ 0x5a26, 0x9eb1 },
	{ 0x5a28, 0x9eca },
	{ 0x5a29, 0x9f02 },
	{ 0x5a2a, 0x9f27 },
	{ 0x5a2b, 0x9f26 },
	{ 0x5a2d, 0x56af },
	{ 0x5a2e, 0x58e0 },
	{ 0x5a2f, 0x58dc },
	{ 0x5a31, 0x5b39 },
	{ 0x5a34, 0x5b7c },
	{ 0x5a35, 0x5bf3 },
	{ 0x5a38, 0x5c6b },
	{ 0x5a39, 0x5dc4 },
	{ 0x5a3a, 0x650b },
	{ 0x5a3b, 0x6508 },
	{ 0x5a3c, 0x650a },
	{ 0x5a3f, 0x65dc },
	{ 0x5a42, 0x66e1 },
	{ 0x5a43, 0x66df },
	{ 0x5a44, 0x6ace },
	{ 0x5a45, 0x6ad4 },
	{ 0x5a46, 0x6ae3 },
	{ 0x5a47, 0x6ad7 },
	{ 0x5a48, 0x6ae2 },
	{ 0x5a4d, 0x6ad8 },
	{ 0x5a4e, 0x6ad5 },
	{ 0x5a4f, 0x6ad2 },
	{ 0x5a52, 0x701e },
	{ 0x5a53, 0x702c },
	{ 0x5a54, 0x7025 },
	{ 0x5a55, 0x6ff3 },
	{ 0x5a56, 0x7204 },
	{ 0x5a57, 0x7208 },
	{ 0x5a58, 0x7215 },
	{ 0x5a5a, 0x74c4 },
	{ 0x5a5b, 0x74c9 },
	{ 0x5a5c, 0x74c7 },
	{ 0x5a5d, 0x74c8 },
	{ 0x5a5e, 0x76a9 },
	{ 0x5a5f, 0x77c6 },
	{ 0x5a60, 0x77c5 },
	{ 0x5a61, 0x7918 },
	{ 0x5a62, 0x791a },
	{ 0x5a63, 0x7920 },
	{ 0x5a65, 0x7a66 },
	{ 0x5a66, 0x7a64 },
	{ 0x5a67, 0x7a6a },
	{ 0x5a6e, 0x7c35 },
	{ 0x5a6f, 0x7c34 },
	{ 0x5a72, 0x7e6c },
	{ 0x5a74, 0x7e6e },
	{ 0x5a75, 0x7e71 },
	{ 0x5a77, 0x81d4 },
	{ 0x5a78, 0x81d6 },
	{ 0x5a79, 0x821a },
	{ 0x5a7a, 0x8262 },
	{ 0x5a7b, 0x8265 },
	{ 0x5a7c, 0x8276 },
	{ 0x5a7d, 0x85db },
	{ 0x5a7e, 0x85d6 },
	{ 0x5b22, 0x85e7 },
	{ 0x5b25, 0x85f4 },
	{ 0x5b27, 0x87fd },
	{ 0x5b28, 0x87d5 },
	{ 0x5b29, 0x8807 },
	{ 0x5b2b, 0x880f },
	{ 0x5b2c, 0x87f8 },
	{ 0x5b2f, 0x8987 },
	{ 0x5b31, 0x89b5 },
	{ 0x5b32, 0x89f5 },
	{ 0x5b34, 0x8b3f },
	{ 0x5b35, 0x8b43 },
	{ 0x5b36, 0x8b4c },
	{ 0x5b38, 0x8d0b },
	{ 0x5b39, 0x8e6b },
	{ 0x5b3a, 0x8e68 },
	{ 0x5b3b, 0x8e70 },
	{ 0x5b3c, 0x8e75 },
	{ 0x5b3d, 0x8e77 },
	{ 0x5b3f, 0x8ec3 },
	{ 0x5b41, 0x93e9 },
	{ 0x5b42, 0x93ea },
	{ 0x5b43, 0x93cb },
	{ 0x5b44, 0x93c5 },
	{ 0x5b45, 0x93c6 },
	{ 0x5b47, 0x93ed },
	{ 0x5b48, 0x93d3 },
	{ 0x5b4a, 0x93e5 },
	{ 0x5b4d, 0x93db },
	{ 0x5b4e, 0x93eb },
	{ 0x5b4f, 0x93e0 },
	{ 0x5b50, 0x93c1 },
	{ 0x5b53, 0x95dd },
	{ 0x5b5d, 0x97b2 },
	{ 0x5b5e, 0x97b4 },
	{ 0x5b5f, 0x97b1 },
	{ 0x5b60, 0x97b5 },
	{ 0x5b61, 0x97f2 },
	{ 0x5b65, 0x9856 },
	{ 0x5b69, 0x9944 },
	{ 0x5b6b, 0x9a26 },
	{ 0x5b6c, 0x9a1f },
	{ 0x5b6d, 0x9a18 },
	{ 0x5b6e, 0x9a21 },
	{ 0x5b6f, 0x9a17 },
	{ 0x5b71, 0x9b09 },
	{ 0x5b74, 0x9bc5 },
	{ 0x5b75, 0x9bdf },
	{ 0x5b77, 0x9be3 },
	{ 0x5b79, 0x9be9 },
	{ 0x5b7a, 0x9bee },
	{ 0x5b7d, 0x9d66 },
	{ 0x5b7e, 0x9d7a },
	{ 0x5c22, 0x9d6e },
	{ 0x5c23, 0x9d91 },
	{ 0x5c24, 0x9d83 },
	{ 0x5c25, 0x9d76 },
	{ 0x5c26, 0x9d7e },
	{ 0x5c27, 0x9d6d },
	{ 0x5c29, 0x9e95 },
	{ 0x5c2a, 0x9ee3 },
	{ 0x5c2d, 0x9f03 },
	{ 0x5c2e, 0x9f04 },
	{ 0x5c30, 0x9f17 },
	{ 0x5c32, 0x5136 },
	{ 0x5c34, 0x5336 },
	{ 0x5c36, 0x5b42 },
	{ 0x5c39, 0x5b44 },
	{ 0x5c3a, 0x5b46 },
	{ 0x5c3b, 0x5b7e },
	{ 0x5c3c, 0x5dca },
	{ 0x5c3d, 0x5dc8 },
	{ 0x5c3e, 0x5dcc },
	{ 0x5c3f, 0x5ef0 },
	{ 0x5c41, 0x6585 },
	{ 0x5c42, 0x66e5 },
	{ 0x5c43, 0x66e7 },
	{ 0x5c47, 0x6af4 },
	{ 0x5c49, 0x6ae9 },
	{ 0x5c4f, 0x703d },
	{ 0x5c51, 0x7036 },
	{ 0x5c53, 0x7216 },
	{ 0x5c55, 0x7212 },
	{ 0x5c56, 0x720f },
	{ 0x5c57, 0x7217 },
	{ 0x5c58, 0x7211 },
	{ 0x5c59, 0x720b },
	{ 0x5c5c, 0x74cd },
	{ 0x5c5d, 0x74d0 },
	{ 0x5c5e, 0x74cc },
	{ 0x5c5f, 0x74ce },
	{ 0x5c60, 0x74d1 },
	{ 0x5c62, 0x7589 },
	{ 0x5c64, 0x7a6f },
	{ 0x5c65, 0x7c4b },
	{ 0x5c66, 0x7c44 },
	{ 0x5c6c, 0x7e7f },
	{ 0x5c6d, 0x8b71 },
	{ 0x5c6f, 0x802f },
	{ 0x5c70, 0x807a },
	{ 0x5c71, 0x807b },
	{ 0x5c72, 0x807c },
	{ 0x5c76, 0x85fc },
	{ 0x5c77, 0x8610 },
	{ 0x5c78, 0x8602 },
	{ 0x5c7b, 0x85ee },
	{ 0x5c7c, 0x8603 },
	{ 0x5c7e, 0x860d },
	{ 0x5d21, 0x8613 },
	{ 0x5d22, 0x8608 },
	{ 0x5d23, 0x860f },
	{ 0x5d24, 0x8818 },
	{ 0x5d25, 0x8812 },
	{ 0x5d28, 0x8967 },
	{ 0x5d29, 0x8965 },
	{ 0x5d2a, 0x89bb },
	{ 0x5d2b, 0x8b69 },
	{ 0x5d2c, 0x8b62 },
	{ 0x5d2e, 0x8b6e },
	{ 0x5d30, 0x8b61 },
	{ 0x5d32, 0x8b64 },
	{ 0x5d33, 0x8b4d },
	{ 0x5d34, 0x8c51 },
	{ 0x5d37, 0x8e83 },
	{ 0x5d38, 0x8ec6 },
	{ 0x5d3a, 0x941f },
	{ 0x5d3c, 0x9404 },
	{ 0x5d3d, 0x9417 },
	{ 0x5d3e, 0x9408 },
	{ 0x5d3f, 0x9405 },
	{ 0x5d41, 0x93f3 },
	{ 0x5d42, 0x941e },
	{ 0x5d43, 0x9402 },
	{ 0x5d44, 0x941a },
	{ 0x5d45, 0x941b },
	{ 0x5d46, 0x9427 },
	{ 0x5d47, 0x941c },
	{ 0x5d49, 0x96b5 },
	{ 0x5d4c, 0x9733 },
	{ 0x5d4e, 0x9734 },
	{ 0x5d4f, 0x9731 },
	{ 0x5d50, 0x97b8 },
	{ 0x5d51, 0x97ba },
	{ 0x5d53, 0x97fc },
	{ 0x5d56, 0x98c3 },
	{ 0x5d58, 0x994d },
	{ 0x5d5a, 0x9a2f },
	{ 0x5d5e, 0x9ac9 },
	{ 0x5d60, 0x9ac8 },
	{ 0x5d61, 0x9ac4 },
	{ 0x5d62, 0x9b2a },
	{ 0x5d63, 0x9b38 },
	{ 0x5d64, 0x9b50 },
	{ 0x5d66, 0x9c0a },
	{ 0x5d67, 0x9bfb },
	{ 0x5d68, 0x9c04 },
	{ 0x5d69, 0x9bfc },
	{ 0x5d6a, 0x9bfe },
	{ 0x5d6e, 0x9c02 },
	{ 0x5d6f, 0x9bf6 },
	{ 0x5d70, 0x9c1b },
	{ 0x5d71, 0x9bf9 },
	{ 0x5d72, 0x9c15 },
	{ 0x5d73, 0x9c10 },
	{ 0x5d74, 0x9bff },
	{ 0x5d75, 0x9c00 },
	{ 0x5d76, 0x9c0c },
	{ 0x5d79, 0x9d95 },
	{ 0x5d7a, 0x9da5 },
	{ 0x5e21, 0x9e98 },
	{ 0x5e22, 0x9ec1 },
	{ 0x5e24, 0x9f5a },
	{ 0x5e25, 0x5164 },
	{ 0x5e26, 0x56bb },
	{ 0x5e28, 0x58e6 },
	{ 0x5e29, 0x5b49 },
	{ 0x5e2a, 0x5bf7 },
	{ 0x5e2d, 0x5dd0 },
	{ 0x5e2f, 0x5fc2 },
	{ 0x5e31, 0x6511 },
	{ 0x5e33, 0x6aff },
	{ 0x5e34, 0x6afe },
	{ 0x5e35, 0x6afd },
	{ 0x5e37, 0x6b01 },
	{ 0x5e3a, 0x704b },
	{ 0x5e3b, 0x704d },
	{ 0x5e3c, 0x7047 },
	{ 0x5e3d, 0x74d3 },
	{ 0x5e3e, 0x7668 },
	{ 0x5e3f, 0x7667 },
	{ 0x5e42, 0x77d1 },
	{ 0x5e43, 0x7930 },
	{ 0x5e44, 0x7932 },
	{ 0x5e45, 0x792e },
	{ 0x5e47, 0x9f9d },
	{ 0x5e48, 0x7ac9 },
	{ 0x5e49, 0x7ac8 },
	{ 0x5e4b, 0x7c56 },
	{ 0x5e4c, 0x7c51 },
	{ 0x5e50, 0x7e85 },
	{ 0x5e51, 0x7e89 },
	{ 0x5e52, 0x7e8e },
	{ 0x5e53, 0x7e84 },
	{ 0x5e55, 0x826a },
	{ 0x5e56, 0x862b },
	{ 0x5e57, 0x862f },
	{ 0x5e58, 0x8628 },
	{ 0x5e5a, 0x8616 },
	{ 0x5e5b, 0x8615 },
	{ 0x5e5c, 0x861d },
	{ 0x5e5d, 0x881a },
	{ 0x5e61, 0x89bc },
	{ 0x5e62, 0x8b75 },
	{ 0x5e63, 0x8b7c },
	{ 0x5e65, 0x8d11 },
	{ 0x5e66, 0x8d12 },
	{ 0x5e67, 0x8f5c },
	{ 0x5e68, 0x91bb },
	{ 0x5e6a, 0x93f4 },
	{ 0x5e6d, 0x942d },
	{ 0x5e70, 0x96e4 },
	{ 0x5e71, 0x9737 },
	{ 0x5e72, 0x9736 },
	{ 0x5e73, 0x9767 },
	{ 0x5e74, 0x97be },
	{ 0x5e75, 0x97bd },
	{ 0x5e76, 0x97e2 },
	{ 0x5e77, 0x9868 },
	{ 0x5e78, 0x9866 },
	{ 0x5e79, 0x98c8 },
	{ 0x5e7a, 0x98ca },
	{ 0x5e7b, 0x98c7 },
	{ 0x5e7c, 0x98dc },
	{ 0x5e7e, 0x994f },
	{ 0x5f21, 0x99a9 },
	{ 0x5f22, 0x9a3c },
	{ 0x5f24, 0x9a3b },
	{ 0x5f25, 0x9ace },
	{ 0x5f27, 0x9b14 },
	{ 0x5f28, 0x9b53 },
	{ 0x5f2a, 0x9c2e },
	{ 0x5f2c, 0x9c1f },
	{ 0x5f31, 0x9db0 },
	{ 0x5f32, 0x9dbd },
	{ 0x5f35, 0x9dae },
	{ 0x5f36, 0x9dc4 },
	{ 0x5f37, 0x9e7b },
	{ 0x5f3a, 0x9e9e },
	{ 0x5f3c, 0x9f05 },
	{ 0x5f3e, 0x9f69 },
	{ 0x5f3f, 0x9fa1 },
	{ 0x5f40, 0x56c7 },
	{ 0x5f41, 0x571d },
	{ 0x5f42, 0x5b4a },
	{ 0x5f43, 0x5dd3 },
	{ 0x5f45, 0x5f72 },
	{ 0x5f46, 0x6202 },
	{ 0x5f48, 0x6235 },
	{ 0x5f49, 0x6527 },
	{ 0x5f4a, 0x651e },
	{ 0x5f4b, 0x651f },
	{ 0x5f4e, 0x6b07 },
	{ 0x5f4f, 0x6b06 },
	{ 0x5f52, 0x7054 },
	{ 0x5f53, 0x721c },
	{ 0x5f54, 0x7220 },
	{ 0x5f55, 0x7af8 },
	{ 0x5f57, 0x7c5d },
	{ 0x5f58, 0x7c58 },
	{ 0x5f5a, 0x7e92 },
	{ 0x5f5b, 0x7f4e },
	{ 0x5f5f, 0x8827 },
	{ 0x5f61, 0x8b81 },
	{ 0x5f62, 0x8b83 },
	{ 0x5f64, 0x8c44 },
	{ 0x5f69, 0x9442 },
	{ 0x5f6a, 0x944d },
	{ 0x5f6b, 0x9454 },
	{ 0x5f6c, 0x944e },
	{ 0x5f6e, 0x9443 },
	{ 0x5f71, 0x973c },
	{ 0x5f72, 0x9740 },
	{ 0x5f73, 0x97c0 },
	{ 0x5f78, 0x995a },
	{ 0x5f79, 0x9a51 },
	{ 0x5f7b, 0x9add },
	{ 0x5f7e, 0x9c38 },
	{ 0x6022, 0x9c45 },
	{ 0x6023, 0x9c3a },
	{ 0x6025, 0x9c35 },
	{ 0x6029, 0x9ef1 },
	{ 0x602b, 0x9f93 },
	{ 0x602c, 0x529a },
	{ 0x602f, 0x8641 },
	{ 0x6030, 0x5dd7 },
	{ 0x6032, 0x6528 },
	{ 0x6036, 0x7053 },
	{ 0x6037, 0x7059 },
	{ 0x6039, 0x7221 },
	{ 0x603b, 0x766f },
	{ 0x603c, 0x7937 },
	{ 0x603d, 0x79b5 },
	{ 0x603e, 0x7c62 },
	{ 0x603f, 0x7c5e },
	{ 0x6040, 0x7cf5 },
	{ 0x6043, 0x863d },
	{ 0x6045, 0x882d },
	{ 0x6046, 0x8989 },
	{ 0x6047, 0x8b8d },
	{ 0x6048, 0x8b87 },
	{ 0x6049, 0x8b90 },
	{ 0x604a, 0x8d1a },
	{ 0x604b, 0x8e99 },
	{ 0x604f, 0x945f },
	{ 0x6052, 0x9456 },
	{ 0x6053, 0x9461 },
	{ 0x6054, 0x945b },
	{ 0x6055, 0x945a },
	{ 0x6056, 0x945c },
	{ 0x6057, 0x9465 },
	{ 0x6059, 0x9741 },
	{ 0x605c, 0x986e },
	{ 0x605d, 0x986c },
	{ 0x605e, 0x986d },
	{ 0x6060, 0x99aa },
	{ 0x6061, 0x9a5c },
	{ 0x6062, 0x9a58 },
	{ 0x6063, 0x9ade },
	{ 0x6065, 0x9c4f },
	{ 0x6066, 0x9c51 },
	{ 0x6068, 0x9c53 },
	{ 0x606c, 0x9dfc },
	{ 0x606d, 0x9f39 },
	{ 0x606f, 0x513e },
	{ 0x6071, 0x56d2 },
	{ 0x6073, 0x5b4f },
	{ 0x6074, 0x6b14 },
	{ 0x6076, 0x7a72 },
	{ 0x6077, 0x7a73 },
	{ 0x607b, 0x8b91 },
	{ 0x607e, 0x91bf },
	{ 0x6122, 0x946c },
	{ 0x6125, 0x96e6 },
	{ 0x6126, 0x9745 },
	{ 0x6128, 0x97c8 },
	{ 0x6129, 0x97e4 },
	{ 0x612a, 0x995d },
	{ 0x612c, 0x9b21 },
	{ 0x612e, 0x9b2c },
	{ 0x612f, 0x9b57 },
	{ 0x6132, 0x9c5d },
	{ 0x6133, 0x9c61 },
	{ 0x6134, 0x9c65 },
	{ 0x6135, 0x9e08 },
	{ 0x613b, 0x9f45 },
	{ 0x613e, 0x6205 },
	{ 0x613f, 0x66ef },
	{ 0x6140, 0x6b1b },
	{ 0x6141, 0x6b1d },
	{ 0x6142, 0x7225 },
	{ 0x6143, 0x7224 },
	{ 0x6144, 0x7c6d },
	{ 0x6146, 0x8642 },
	{ 0x6147, 0x8649 },
	{ 0x6149, 0x8978 },
	{ 0x614a, 0x898a },
	{ 0x614b, 0x8b97 },
	{ 0x614d, 0x8c9b },
	{ 0x614e, 0x8d1c },
	{ 0x6150, 0x8ea2 },
	{ 0x6159, 0x9c6c },
	{ 0x615b, 0x9c6f },
	{ 0x615d, 0x9e0e },
	{ 0x615f, 0x9f08 },
	{ 0x6160, 0x9f1d },
	{ 0x6161, 0x9fa3 },
	{ 0x6164, 0x5f60 },
	{ 0x6165, 0x6b1c },
	{ 0x6169, 0x7cf3 },
	{ 0x616b, 0x8b9b },
	{ 0x616c, 0x8ea7 },
	{ 0x616d, 0x91c4 },
	{ 0x616f, 0x947a },
	{ 0x6172, 0x9a61 },
	{ 0x6173, 0x9a63 },
	{ 0x6174, 0x9ad7 },
	{ 0x6175, 0x9c76 },
	{ 0x6177, 0x9fa5 },
	{ 0x6179, 0x7067 },
	{ 0x617b, 0x72ab },
	{ 0x617c, 0x864a },
	{ 0x617d, 0x897d },
	{ 0x617e, 0x8b9d },
	{ 0x6221, 0x8c53 },
	{ 0x6222, 0x8f65 },
	{ 0x6223, 0x947b },
	{ 0x6225, 0x98cd },
	{ 0x6226, 0x98dd },
	{ 0x6228, 0x9b30 },
	{ 0x6229, 0x9e16 },
	{ 0x622f, 0x96e7 },
	{ 0x6230, 0x9e18 },
	{ 0x6231, 0x9ea2 },
	{ 0x6233, 0x9f7c },
	{ 0x6235, 0x7e9e },
	{ 0x6236, 0x9484 },
	{ 0x6238, 0x9e1c },
	{ 0x623a, 0x7c71 },
	{ 0x623b, 0x97ca },
	{ 0x623f, 0x9ea3 },
	{ 0x6241, 0x9c7b },
	{ 0x6242, 0x9f97 },
	{ 0x6245, 0x9750 },
	{ 0x6249, 0x5727 },
	{ 0x624a, 0x5c13 },
	{ 0x6251, 0x5fc8 },
	{ 0x6257, 0x6765 },
	{ 0x625a, 0x52bd },
	{ 0x625c, 0x5b66 },
	{ 0x625e, 0x65f9 },
	{ 0x625f, 0x6788 },
	{ 0x6260, 0x6ce6 },
	{ 0x6261, 0x6ccb },
	{ 0x6263, 0x4fbd },
	{ 0x6264, 0x5f8d },
	{ 0x6266, 0x6018 },
	{ 0x6267, 0x6048 },
	{ 0x6269, 0x6b29 },
	{ 0x626a, 0x70a6 },
	{ 0x626c, 0x7706 },
	{ 0x6270, 0x5a10 },
	{ 0x6271, 0x5cfc },
	{ 0x6272, 0x5cfe },
	{ 0x6279, 0x70c9 },
	{ 0x6323, 0x9579 },
	{ 0x6325, 0x96ba },
	{ 0x632d, 0x7b29 },
	{ 0x632e, 0x8128 },
	{ 0x6330, 0x8a2e },
	{ 0x6334, 0x9ad9 },
	{ 0x6336, 0x582b },
	{ 0x6337, 0x5845 },
	{ 0x6339, 0x63fa },
	{ 0x633d, 0x6e86 },
	{ 0x6343, 0x5867 },
	{ 0x6345, 0x5bdd },
	{ 0x6346, 0x656e },
	{ 0x634a, 0x8c87 },
	{ 0x634c, 0x50d2 },
	{ 0x634d, 0x50df },
	{ 0x6352, 0x69ba },
	{ 0x6354, 0x6b9d },
	{ 0x6356, 0x8059 },
	{ 0x6363, 0x6f8a },
	{ 0x6366, 0x7bc3 },
	{ 0x6367, 0x7bc2 },
	{ 0x636c, 0x90f6 },
	{ 0x636e, 0x9823 },
	{ 0x6374, 0x71cd },
	{ 0x6375, 0x7499 },
	{ 0x637b, 0x9842 },
	{ 0x6422, 0x7f84 },
	{ 0x6428, 0x8d0e },
	{ 0x642a, 0x9861 },
	{ 0x642d, 0x8b73 },
	{ 0x642f, 0x9c27 },
	{ 0x6431, 0x9458 },
	{ 0x6432, 0x77d6 },
	{ 0x6433, 0x9b2d },
	{ 0x6448, 0x4f66 },
	{ 0x6449, 0x4f68 },
	{ 0x644a, 0x4fe7 },
	{ 0x644b, 0x503f },
	{ 0x644d, 0x50a6 },
	{ 0x644e, 0x510f },
	{ 0x644f, 0x523e },
	{ 0x6450, 0x5324 },
	{ 0x6451, 0x5365 },
	{ 0x6452, 0x539b },
	{ 0x6453, 0x517f },
	{ 0x6454, 0x54cb },
	{ 0x6455, 0x5573 },
	{ 0x6456, 0x5571 },
	{ 0x6457, 0x556b },
	{ 0x6458, 0x55f4 },
	{ 0x6459, 0x5622 },
	{ 0x645a, 0x5620 },
	{ 0x645b, 0x5692 },
	{ 0x645c, 0x56ba },
	{ 0x645d, 0x5691 },
	{ 0x645e, 0x56b0 },
	{ 0x645f, 0x5759 },
	{ 0x6460, 0x578a },
	{ 0x6461, 0x580f },
	{ 0x6462, 0x5812 },
	{ 0x6463, 0x5813 },
	{ 0x6464, 0x5847 },
	{ 0x6465, 0x589b },
	{ 0x6466, 0x5900 },
	{ 0x6467, 0x594d },
	{ 0x6468, 0x5ad1 },
	{ 0x6469, 0x5ad3 },
	{ 0x646a, 0x5b67 },
	{ 0x646b, 0x5c57 },
	{ 0x646c, 0x5c77 },
	{ 0x646d, 0x5cd5 },
	{ 0x646e, 0x5d75 },
	{ 0x646f, 0x5d8e },
	{ 0x6470, 0x5da5 },
	{ 0x6471, 0x5db6 },
	{ 0x6472, 0x5dbf },
	{ 0x6473, 0x5e65 },
	{ 0x6474, 0x5ecd },
	{ 0x6475, 0x5eed },
	{ 0x6476, 0x5f94 },
	{ 0x6477, 0x5f9a },
	{ 0x6478, 0x5fba },
	{ 0x6479, 0x6125 },
	{ 0x647a, 0x6150 },
	{ 0x647b, 0x62a3 },
	{ 0x647c, 0x6360 },
	{ 0x647d, 0x6364 },
	{ 0x647e, 0x63b6 },
	{ 0x6521, 0x6403 },
	{ 0x6522, 0x64b6 },
	{ 0x6523, 0x651a },
	{ 0x6524, 0x7a25 },
	{ 0x6525, 0x5c21 },
	{ 0x6526, 0x66e2 },
	{ 0x6527, 0x6702 },
	{ 0x6528, 0x67a4 },
	{ 0x6529, 0x67ac },
	{ 0x652a, 0x6810 },
	{ 0x652b, 0x6806 },
	{ 0x652c, 0x685e },
	{ 0x652d, 0x685a },
	{ 0x652e, 0x692c },
	{ 0x652f, 0x6929 },
	{ 0x6530, 0x6a2d },
	{ 0x6531, 0x6a77 },
	{ 0x6532, 0x6a7a },
	{ 0x6533, 0x6aca },
	{ 0x6534, 0x6ae6 },
	{ 0x6535, 0x6af5 },
	{ 0x6536, 0x6b0d },
	{ 0x6537, 0x6b0e },
	{ 0x6538, 0x6bdc },
	{ 0x6539, 0x6bdd },
	{ 0x653a, 0x6bf6 },
	{ 0x653b, 0x6c1e },
	{ 0x653c, 0x6c63 },
	{ 0x653d, 0x6da5 },
	{ 0x653e, 0x6e0f },
	{ 0x653f, 0x6e8a },
	{ 0x6540, 0x6e84 },
	{ 0x6541, 0x6e8b },
	{ 0x6542, 0x6e7c },
	{ 0x6543, 0x6f4c },
	{ 0x6544, 0x6f48 },
	{ 0x6545, 0x6f49 },
	{ 0x6546, 0x6f9d },
	{ 0x6547, 0x6f99 },
	{ 0x6548, 0x6ff8 },
	{ 0x6549, 0x702e },
	{ 0x654a, 0x702d },
	{ 0x654b, 0x705c },
	{ 0x654c, 0x79cc },
	{ 0x654d, 0x70bf },
	{ 0x654e, 0x70ea },
	{ 0x654f, 0x70e5 },
	{ 0x6550, 0x7111 },
	{ 0x6551, 0x7112 },
	{ 0x6552, 0x713f },
	{ 0x6553, 0x7139 },
	{ 0x6554, 0x713b },
	{ 0x6555, 0x713d },
	{ 0x6556, 0x7177 },
	{ 0x6557, 0x7175 },
	{ 0x6558, 0x7176 },
	{ 0x6559, 0x7171 },
	{ 0x655a, 0x7196 },
	{ 0x655b, 0x7193 },
	{ 0x655c, 0x71b4 },
	{ 0x655d, 0x71dd },
	{ 0x655e, 0x71de },
	{ 0x655f, 0x720e },
	{ 0x6560, 0x5911 },
	{ 0x6561, 0x7218 },
	{ 0x6562, 0x7347 },
	{ 0x6563, 0x7348 },
	{ 0x6564, 0x73ef },
	{ 0x6565, 0x7412 },
	{ 0x6566, 0x743b },
	{ 0x6567, 0x74a4 },
	{ 0x6568, 0x748d },
	{ 0x6569, 0x74b4 },
	{ 0x656a, 0x7673 },
	{ 0x656b, 0x7677 },
	{ 0x656c, 0x76bc },
	{ 0x656d, 0x7819 },
	{ 0x656e, 0x781b },
	{ 0x656f, 0x783d },
	{ 0x6570, 0x7853 },
	{ 0x6571, 0x7854 },
	{ 0x6572, 0x7858 },
	{ 0x6573, 0x78b7 },
	{ 0x6574, 0x78d8 },
	{ 0x6575, 0x78ee },
	{ 0x6576, 0x7922 },
	{ 0x6577, 0x794d },
	{ 0x6578, 0x7986 },
	{ 0x6579, 0x7999 },
	{ 0x657a, 0x79a3 },
	{ 0x657b, 0x79bc },
	{ 0x657c, 0x7aa7 },
	{ 0x657d, 0x7b37 },
	{ 0x657e, 0x7b59 },
	{ 0x6621, 0x7bd0 },
	{ 0x6622, 0x7c2f },
	{ 0x6623, 0x7c32 },
	{ 0x6624, 0x7c42 },
	{ 0x6625, 0x7c4e },
	{ 0x6626, 0x7c68 },
	{ 0x6627, 0x7ca9 },
	{ 0x6628, 0x7ced },
	{ 0x6629, 0x7dd0 },
	{ 0x662a, 0x7e07 },
	{ 0x662b, 0x7dd3 },
	{ 0x662c, 0x7e64 },
	{ 0x662d, 0x7f40 },
	{ 0x662f, 0x8041 },
	{ 0x6630, 0x8063 },
	{ 0x6631, 0x80bb },
	{ 0x6632, 0x6711 },
	{ 0x6633, 0x6725 },
	{ 0x6634, 0x8248 },
	{ 0x6635, 0x8310 },
	{ 0x6636, 0x8362 },
	{ 0x6637, 0x8312 },
	{ 0x6638, 0x8421 },
	{ 0x6639, 0x841e },
	{ 0x663a, 0x84e2 },
	{ 0x663b, 0x84de },
	{ 0x663c, 0x84e1 },
	{ 0x663d, 0x8573 },
	{ 0x663e, 0x85d4 },
	{ 0x663f, 0x85f5 },
	{ 0x6640, 0x8637 },
	{ 0x6641, 0x8645 },
	{ 0x6642, 0x8672 },
	{ 0x6643, 0x874a },
	{ 0x6644, 0x87a9 },
	{ 0x6645, 0x87a5 },
	{ 0x6646, 0x87f5 },
	{ 0x6647, 0x8834 },
	{ 0x6648, 0x8850 },
	{ 0x6649, 0x8887 },
	{ 0x664a, 0x8954 },
	{ 0x664b, 0x8984 },
	{ 0x664c, 0x8b03 },
	{ 0x664d, 0x8c52 },
	{ 0x664e, 0x8cd8 },
	{ 0x664f, 0x8d0c },
	{ 0x6650, 0x8d18 },
	{ 0x6651, 0x8db0 },
	{ 0x6652, 0x8ebc },
	{ 0x6653, 0x8ed5 },
	{ 0x6654, 0x8faa },
	{ 0x6655, 0x909c },
	{ 0x6657, 0x915c },
	{ 0x6658, 0x922b },
	{ 0x6659, 0x9221 },
	{ 0x665a, 0x9273 },
	{ 0x665b, 0x92f4 },
	{ 0x665c, 0x92f5 },
	{ 0x665d, 0x933f },
	{ 0x665e, 0x9342 },
	{ 0x665f, 0x9386 },
	{ 0x6660, 0x93be },
	{ 0x6661, 0x93bc },
	{ 0x6662, 0x93bd },
	{ 0x6663, 0x93f1 },
	{ 0x6664, 0x93f2 },
	{ 0x6665, 0x93ef },
	{ 0x6666, 0x9422 },
	{ 0x6667, 0x9423 },
	{ 0x6668, 0x9424 },
	{ 0x6669, 0x9467 },
	{ 0x666a, 0x9466 },
	{ 0x666b, 0x9597 },
	{ 0x666c, 0x95ce },
	{ 0x666d, 0x95e7 },
	{ 0x666e, 0x973b },
	{ 0x666f, 0x974d },
	{ 0x6670, 0x98e4 },
	{ 0x6671, 0x9942 },
	{ 0x6672, 0x9b1d },
	{ 0x6673, 0x9b98 },
	{ 0x6675, 0x9d49 },
	{ 0x6676, 0x6449 },
	{ 0x6677, 0x5e71 },
	{ 0x6678, 0x5e85 },
	{ 0x6679, 0x61d3 },
	{ 0x667a, 0x990e },
	{ 0x667b, 0x8002 },
	{ 0x667c, 0x781e },
	{ 0x6721, 0x5528 },
	{ 0x6722, 0x5572 },
	{ 0x6723, 0x55ba },
	{ 0x6724, 0x55f0 },
	{ 0x6725, 0x55ee },
	{ 0x6726, 0x56b8 },
	{ 0x6727, 0x56b9 },
	{ 0x6728, 0x56c4 },
	{ 0x6729, 0x8053 },
	{ 0x672a, 0x92b0 }
};

#endif
