/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _CNS_BIG5_H_

#define _CNS_BIG5_H_

#include "public_struc.h"

/* maxium mapping number from CNS11643 to Big-5 */
#define MAX_CNS1_NUM		6085	/* plane #1 */
#define MAX_CNS2_NUM		7650	/* plane #2 */
#define MAX_CNS3_NUM		8	/* plane #3 */

/* CNS 11643-1992 plane #1 to Big-5 conversion table */
table_t	cns_big5_tab1[MAX_CNS1_NUM] = {
	{ 0x2121, 0xa140 },
	{ 0x2122, 0xa141 },
	{ 0x2123, 0xa142 },
	{ 0x2124, 0xa143 },
	{ 0x2125, 0xa144 },
	{ 0x2126, 0xa145 },
	{ 0x2127, 0xa146 },
	{ 0x2128, 0xa147 },
	{ 0x2129, 0xa148 },
	{ 0x212a, 0xa149 },
	{ 0x212b, 0xa14a },
	{ 0x212c, 0xa14b },
	{ 0x212d, 0xa14c },
	{ 0x212e, 0xa14d },
	{ 0x212f, 0xa14e },
	{ 0x2130, 0xa14f },
	{ 0x2131, 0xa150 },
	{ 0x2132, 0xa151 },
	{ 0x2133, 0xa152 },
	{ 0x2134, 0xa153 },
	{ 0x2135, 0xa154 },
	{ 0x2136, 0xa155 },
	{ 0x2137, 0xa156 },
	{ 0x2138, 0xa157 },
	{ 0x2139, 0xa158 },
	{ 0x213a, 0xa159 },
	{ 0x213b, 0xa15a },
	{ 0x213c, 0xa15b },
	{ 0x213d, 0xa15c },
	{ 0x213e, 0xa15d },
	{ 0x213f, 0xa15e },
	{ 0x2140, 0xa15f },
	{ 0x2141, 0xa160 },
	{ 0x2142, 0xa161 },
	{ 0x2143, 0xa162 },
	{ 0x2144, 0xa163 },
	{ 0x2145, 0xa164 },
	{ 0x2146, 0xa165 },
	{ 0x2147, 0xa166 },
	{ 0x2148, 0xa167 },
	{ 0x2149, 0xa168 },
	{ 0x214a, 0xa169 },
	{ 0x214b, 0xa16a },
	{ 0x214c, 0xa16b },
	{ 0x214d, 0xa16c },
	{ 0x214e, 0xa16d },
	{ 0x214f, 0xa16e },
	{ 0x2150, 0xa16f },
	{ 0x2151, 0xa170 },
	{ 0x2152, 0xa171 },
	{ 0x2153, 0xa172 },
	{ 0x2154, 0xa173 },
	{ 0x2155, 0xa174 },
	{ 0x2156, 0xa175 },
	{ 0x2157, 0xa176 },
	{ 0x2158, 0xa177 },
	{ 0x2159, 0xa178 },
	{ 0x215a, 0xa179 },
	{ 0x215b, 0xa17a },
	{ 0x215c, 0xa17b },
	{ 0x215d, 0xa17c },
	{ 0x215e, 0xa17d },
	{ 0x215f, 0xa17e },
	{ 0x2160, 0xa1a1 },
	{ 0x2161, 0xa1a2 },
	{ 0x2162, 0xa1a3 },
	{ 0x2163, 0xa1a4 },
	{ 0x2164, 0xa1a5 },
	{ 0x2165, 0xa1a6 },
	{ 0x2166, 0xa1a7 },
	{ 0x2167, 0xa1a8 },
	{ 0x2168, 0xa1a9 },
	{ 0x2169, 0xa1aa },
	{ 0x216a, 0xa1ab },
	{ 0x216b, 0xa1ac },
	{ 0x216c, 0xa1ad },
	{ 0x216d, 0xa1ae },
	{ 0x216e, 0xa1af },
	{ 0x216f, 0xa1b0 },
	{ 0x2170, 0xa1b1 },
	{ 0x2171, 0xa1b2 },
	{ 0x2172, 0xa1b3 },
	{ 0x2173, 0xa1b4 },
	{ 0x2174, 0xa1b5 },
	{ 0x2175, 0xa1b6 },
	{ 0x2176, 0xa1b7 },
	{ 0x2177, 0xa1b8 },
	{ 0x2178, 0xa1b9 },
	{ 0x2179, 0xa1ba },
	{ 0x217a, 0xa1bb },
	{ 0x217b, 0xa1bc },
	{ 0x217c, 0xa1bd },
	{ 0x217d, 0xa1be },
	{ 0x217e, 0xa1bf },
	{ 0x2221, 0xa1c0 },
	{ 0x2222, 0xa1c1 },
	{ 0x2223, 0xa1c2 },
	{ 0x2224, 0xa1c3 },
	{ 0x2225, 0xa1c4 },
	{ 0x2226, 0xa1c5 },
	{ 0x2227, 0xa1c6 },
	{ 0x2228, 0xa1c7 },
	{ 0x2229, 0xa1c8 },
	{ 0x222a, 0xa1c9 },
	{ 0x222b, 0xa1ca },
	{ 0x222c, 0xa1cb },
	{ 0x222d, 0xa1cc },
	{ 0x222e, 0xa1cd },
	{ 0x222f, 0xa1ce },
	{ 0x2230, 0xa1cf },
	{ 0x2231, 0xa1d0 },
	{ 0x2232, 0xa1d1 },
	{ 0x2233, 0xa1d2 },
	{ 0x2234, 0xa1d3 },
	{ 0x2235, 0xa1d4 },
	{ 0x2236, 0xa1d5 },
	{ 0x2237, 0xa1d6 },
	{ 0x2238, 0xa1d7 },
	{ 0x2239, 0xa1d8 },
	{ 0x223a, 0xa1d9 },
	{ 0x223b, 0xa1da },
	{ 0x223c, 0xa1db },
	{ 0x223d, 0xa1dc },
	{ 0x223e, 0xa1dd },
	{ 0x223f, 0xa1de },
	{ 0x2240, 0xa1df },
	{ 0x2241, 0xa1e0 },
	{ 0x2242, 0xa1e1 },
	{ 0x2243, 0xa1e2 },
	{ 0x2244, 0xa1e3 },
	{ 0x2245, 0xa1e4 },
	{ 0x2246, 0xa1e5 },
	{ 0x2247, 0xa1e6 },
	{ 0x2248, 0xa1e7 },
	{ 0x2249, 0xa1e8 },
	{ 0x224a, 0xa1e9 },
	{ 0x224b, 0xa1ea },
	{ 0x224c, 0xa1eb },
	{ 0x224d, 0xa1ec },
	{ 0x224e, 0xa1ed },
	{ 0x224f, 0xa1ee },
	{ 0x2250, 0xa1ef },
	{ 0x2251, 0xa1f0 },
	{ 0x2252, 0xa1f1 },
	{ 0x2253, 0xa1f2 },
	{ 0x2254, 0xa1f3 },
	{ 0x2255, 0xa1f4 },
	{ 0x2256, 0xa1f5 },
	{ 0x2257, 0xa1f6 },
	{ 0x2258, 0xa1f7 },
	{ 0x2259, 0xa1f8 },
	{ 0x225a, 0xa1f9 },
	{ 0x225b, 0xa1fa },
	{ 0x225c, 0xa1fb },
	{ 0x225d, 0xa1fc },
	{ 0x225e, 0xa1fd },
	{ 0x225f, 0xa1fe },
	{ 0x2260, 0xa240 },
	{ 0x2261, 0xa241 },
	{ 0x2262, 0xa242 },
	{ 0x2263, 0xa243 },
	{ 0x2264, 0xa244 },
	{ 0x2265, 0xa245 },
	{ 0x2266, 0xa246 },
	{ 0x2267, 0xa247 },
	{ 0x2268, 0xa248 },
	{ 0x2269, 0xa249 },
	{ 0x226a, 0xa24a },
	{ 0x226b, 0xa24b },
	{ 0x226c, 0xa24c },
	{ 0x226d, 0xa24d },
	{ 0x226e, 0xa24e },
	{ 0x226f, 0xa24f },
	{ 0x2270, 0xa250 },
	{ 0x2271, 0xa251 },
	{ 0x2272, 0xa252 },
	{ 0x2273, 0xa253 },
	{ 0x2274, 0xa254 },
	{ 0x2275, 0xa255 },
	{ 0x2276, 0xa256 },
	{ 0x2277, 0xa257 },
	{ 0x2278, 0xa258 },
	{ 0x2279, 0xa259 },
	{ 0x227a, 0xa25a },
	{ 0x227b, 0xa25b },
	{ 0x227c, 0xa25c },
	{ 0x227d, 0xa25d },
	{ 0x227e, 0xa25e },
	{ 0x2321, 0xa25f },
	{ 0x2322, 0xa260 },
	{ 0x2323, 0xa261 },
	{ 0x2324, 0xa262 },
	{ 0x2325, 0xa263 },
	{ 0x2326, 0xa264 },
	{ 0x2327, 0xa265 },
	{ 0x2328, 0xa266 },
	{ 0x2329, 0xa267 },
	{ 0x232a, 0xa268 },
	{ 0x232b, 0xa269 },
	{ 0x232c, 0xa26a },
	{ 0x232d, 0xa26b },
	{ 0x232e, 0xa26c },
	{ 0x232f, 0xa26d },
	{ 0x2330, 0xa26e },
	{ 0x2331, 0xa26f },
	{ 0x2332, 0xa270 },
	{ 0x2333, 0xa271 },
	{ 0x2334, 0xa272 },
	{ 0x2335, 0xa273 },
	{ 0x2336, 0xa274 },
	{ 0x2337, 0xa275 },
	{ 0x2338, 0xa276 },
	{ 0x2339, 0xa277 },
	{ 0x233a, 0xa278 },
	{ 0x233b, 0xa279 },
	{ 0x233c, 0xa27a },
	{ 0x233d, 0xa27b },
	{ 0x233e, 0xa27c },
	{ 0x233f, 0xa27d },
	{ 0x2340, 0xa27e },
	{ 0x2341, 0xa2a1 },
	{ 0x2342, 0xa2a2 },
	{ 0x2343, 0xa2a3 },
	{ 0x2344, 0xa2a4 },
	{ 0x2345, 0xa2a5 },
	{ 0x2346, 0xa2a6 },
	{ 0x2347, 0xa2a7 },
	{ 0x2348, 0xa2a8 },
	{ 0x2349, 0xa2a9 },
	{ 0x234a, 0xa2aa },
	{ 0x234b, 0xa2ab },
	{ 0x234c, 0xa2ac },
	{ 0x234d, 0xa2ad },
	{ 0x234e, 0xa2ae },
	{ 0x2421, 0xa2af },
	{ 0x2422, 0xa2b0 },
	{ 0x2423, 0xa2b1 },
	{ 0x2424, 0xa2b2 },
	{ 0x2425, 0xa2b3 },
	{ 0x2426, 0xa2b4 },
	{ 0x2427, 0xa2b5 },
	{ 0x2428, 0xa2b6 },
	{ 0x2429, 0xa2b7 },
	{ 0x242a, 0xa2b8 },
	{ 0x242b, 0xa2b9 },
	{ 0x242c, 0xa2ba },
	{ 0x242d, 0xa2bb },
	{ 0x242e, 0xa2bc },
	{ 0x242f, 0xa2bd },
	{ 0x2430, 0xa2be },
	{ 0x2431, 0xa2bf },
	{ 0x2432, 0xa2c0 },
	{ 0x2433, 0xa2c1 },
	{ 0x2434, 0xa2c2 },
	{ 0x2435, 0xa2c3 },
	{ 0x2436, 0xa2c4 },
	{ 0x2437, 0xa2c5 },
	{ 0x2438, 0xa2c6 },
	{ 0x2439, 0xa2c7 },
	{ 0x243a, 0xa2c8 },
	{ 0x243b, 0xa2c9 },
	{ 0x243c, 0xa2ca },
	{ 0x243d, 0xa2cb },
	{ 0x243e, 0xa2cc },
	{ 0x243f, 0xa2cd },
	{ 0x2440, 0xa2ce },
	{ 0x2441, 0xa2cf },
	{ 0x2442, 0xa2d0 },
	{ 0x2443, 0xa2d1 },
	{ 0x2444, 0xa2d2 },
	{ 0x2445, 0xa2d3 },
	{ 0x2446, 0xa2d4 },
	{ 0x2447, 0xa2d5 },
	{ 0x2448, 0xa2d6 },
	{ 0x2449, 0xa2d7 },
	{ 0x244a, 0xa2d8 },
	{ 0x244b, 0xa2d9 },
	{ 0x244c, 0xa2da },
	{ 0x244d, 0xa2db },
	{ 0x244e, 0xa2dc },
	{ 0x244f, 0xa2dd },
	{ 0x2450, 0xa2de },
	{ 0x2451, 0xa2df },
	{ 0x2452, 0xa2e0 },
	{ 0x2453, 0xa2e1 },
	{ 0x2454, 0xa2e2 },
	{ 0x2455, 0xa2e3 },
	{ 0x2456, 0xa2e4 },
	{ 0x2457, 0xa2e5 },
	{ 0x2458, 0xa2e6 },
	{ 0x2459, 0xa2e7 },
	{ 0x245a, 0xa2e8 },
	{ 0x245b, 0xa2e9 },
	{ 0x245c, 0xa2ea },
	{ 0x245d, 0xa2eb },
	{ 0x245e, 0xa2ec },
	{ 0x245f, 0xa2ed },
	{ 0x2460, 0xa2ee },
	{ 0x2461, 0xa2ef },
	{ 0x2462, 0xa2f0 },
	{ 0x2463, 0xa2f1 },
	{ 0x2464, 0xa2f2 },
	{ 0x2465, 0xa2f3 },
	{ 0x2466, 0xa2f4 },
	{ 0x2467, 0xa2f5 },
	{ 0x2468, 0xa2f6 },
	{ 0x2469, 0xa2f7 },
	{ 0x246a, 0xa2f8 },
	{ 0x246b, 0xa2f9 },
	{ 0x246c, 0xa2fa },
	{ 0x246d, 0xa2fb },
	{ 0x246e, 0xa2fc },
	{ 0x246f, 0xa2fd },
	{ 0x2470, 0xa2fe },
	{ 0x2471, 0xa340 },
	{ 0x2472, 0xa341 },
	{ 0x2473, 0xa342 },
	{ 0x2474, 0xa343 },
	{ 0x2475, 0xa344 },
	{ 0x2476, 0xa345 },
	{ 0x2477, 0xa346 },
	{ 0x2478, 0xa347 },
	{ 0x2479, 0xa348 },
	{ 0x247a, 0xa349 },
	{ 0x247b, 0xa34a },
	{ 0x247c, 0xa34b },
	{ 0x247d, 0xa34c },
	{ 0x247e, 0xa34d },
	{ 0x2521, 0xa34e },
	{ 0x2522, 0xa34f },
	{ 0x2523, 0xa350 },
	{ 0x2524, 0xa351 },
	{ 0x2525, 0xa352 },
	{ 0x2526, 0xa353 },
	{ 0x2527, 0xa354 },
	{ 0x2528, 0xa355 },
	{ 0x2529, 0xa356 },
	{ 0x252a, 0xa357 },
	{ 0x252b, 0xa358 },
	{ 0x252c, 0xa359 },
	{ 0x252d, 0xa35a },
	{ 0x252e, 0xa35b },
	{ 0x252f, 0xa35c },
	{ 0x2530, 0xa35d },
	{ 0x2531, 0xa35e },
	{ 0x2532, 0xa35f },
	{ 0x2533, 0xa360 },
	{ 0x2534, 0xa361 },
	{ 0x2535, 0xa362 },
	{ 0x2536, 0xa363 },
	{ 0x2537, 0xa364 },
	{ 0x2538, 0xa365 },
	{ 0x2539, 0xa366 },
	{ 0x253a, 0xa367 },
	{ 0x253b, 0xa368 },
	{ 0x253c, 0xa369 },
	{ 0x253d, 0xa36a },
	{ 0x253e, 0xa36b },
	{ 0x253f, 0xa36c },
	{ 0x2540, 0xa36d },
	{ 0x2541, 0xa36e },
	{ 0x2542, 0xa36f },
	{ 0x2543, 0xa370 },
	{ 0x2544, 0xa371 },
	{ 0x2545, 0xa372 },
	{ 0x2546, 0xa373 },
	{ 0x2547, 0xa374 },
	{ 0x2548, 0xa375 },
	{ 0x2549, 0xa376 },
	{ 0x254a, 0xa377 },
	{ 0x254b, 0xa378 },
	{ 0x254c, 0xa379 },
	{ 0x254d, 0xa37a },
	{ 0x254e, 0xa37b },
	{ 0x254f, 0xa37c },
	{ 0x2550, 0xa37d },
	{ 0x2551, 0xa37e },
	{ 0x2552, 0xa3a1 },
	{ 0x2553, 0xa3a2 },
	{ 0x2554, 0xa3a3 },
	{ 0x2555, 0xa3a4 },
	{ 0x2556, 0xa3a5 },
	{ 0x2557, 0xa3a6 },
	{ 0x2558, 0xa3a7 },
	{ 0x2559, 0xa3a8 },
	{ 0x255a, 0xa3a9 },
	{ 0x255b, 0xa3aa },
	{ 0x255c, 0xa3ab },
	{ 0x255d, 0xa3ac },
	{ 0x255e, 0xa3ad },
	{ 0x255f, 0xa3ae },
	{ 0x2560, 0xa3af },
	{ 0x2561, 0xa3b0 },
	{ 0x2562, 0xa3b1 },
	{ 0x2563, 0xa3b2 },
	{ 0x2564, 0xa3b3 },
	{ 0x2565, 0xa3b4 },
	{ 0x2566, 0xa3b5 },
	{ 0x2567, 0xa3b6 },
	{ 0x2568, 0xa3b7 },
	{ 0x2569, 0xa3b8 },
	{ 0x256a, 0xa3b9 },
	{ 0x256b, 0xa3ba },
	{ 0x256c, 0xa3bb },
	{ 0x256d, 0xa3bc },
	{ 0x256e, 0xa3bd },
	{ 0x256f, 0xa3be },
	{ 0x2570, 0xa3bf },
	{ 0x2621, 0xa3e1 },
	{ 0x2622, 0xa3e2 },
	{ 0x2623, 0xa3e3 },
	{ 0x2624, 0xa3e4 },
	{ 0x2625, 0xa3e5 },
	{ 0x2626, 0xa3e6 },
	{ 0x2627, 0xa3e7 },
	{ 0x2628, 0xa3e8 },
	{ 0x2629, 0xa3e9 },
	{ 0x262a, 0xa3ea },
	{ 0x262b, 0xa3eb },
	{ 0x262c, 0xa3ec },
	{ 0x262d, 0xa3ed },
	{ 0x262e, 0xa3ee },
	{ 0x262f, 0xa3ef },
	{ 0x2630, 0xa3f0 },
	{ 0x2631, 0xa3f1 },
	{ 0x2632, 0xa3f2 },
	{ 0x2633, 0xa3f3 },
	{ 0x2634, 0xa3f4 },
	{ 0x2635, 0xa3f5 },
	{ 0x2636, 0xa3f6 },
	{ 0x2637, 0xa3f7 },
	{ 0x2638, 0xa3f8 },
	{ 0x2639, 0xa3f9 },
	{ 0x263a, 0xa3fa },
	{ 0x263b, 0xa3fb },
	{ 0x263c, 0xa3fc },
	{ 0x263d, 0xa3fd },
	{ 0x263e, 0xa3fe },
	{ 0x2721, 0 },
	{ 0x2722, 0 },
	{ 0x2723, 0 },
	{ 0x2724, 0 },
	{ 0x2725, 0 },
	{ 0x2726, 0 },
	{ 0x2727, 0 },
	{ 0x2728, 0 },
	{ 0x2729, 0 },
	{ 0x272a, 0 },
	{ 0x272b, 0 },
	{ 0x272c, 0 },
	{ 0x272d, 0 },
	{ 0x272e, 0 },
	{ 0x272f, 0 },
	{ 0x2730, 0 },
	{ 0x2731, 0 },
	{ 0x2732, 0 },
	{ 0x2733, 0 },
	{ 0x2734, 0 },
	{ 0x2735, 0 },
	{ 0x2736, 0 },
	{ 0x2737, 0 },
	{ 0x2738, 0 },
	{ 0x2739, 0 },
	{ 0x273a, 0 },
	{ 0x273b, 0 },
	{ 0x273c, 0 },
	{ 0x273d, 0 },
	{ 0x273e, 0 },
	{ 0x273f, 0 },
	{ 0x2740, 0 },
	{ 0x2741, 0 },
	{ 0x2742, 0 },
	{ 0x2743, 0 },
	{ 0x2744, 0 },
	{ 0x2745, 0 },
	{ 0x2746, 0 },
	{ 0x2747, 0 },
	{ 0x2748, 0 },
	{ 0x2749, 0 },
	{ 0x274a, 0 },
	{ 0x274b, 0 },
	{ 0x274c, 0 },
	{ 0x274d, 0 },
	{ 0x274e, 0 },
	{ 0x274f, 0 },
	{ 0x2750, 0 },
	{ 0x2751, 0 },
	{ 0x2752, 0 },
	{ 0x2753, 0 },
	{ 0x2754, 0 },
	{ 0x2755, 0 },
	{ 0x2756, 0 },
	{ 0x2757, 0 },
	{ 0x2758, 0 },
	{ 0x2759, 0 },
	{ 0x275a, 0 },
	{ 0x275b, 0 },
	{ 0x275c, 0 },
	{ 0x275d, 0 },
	{ 0x275e, 0 },
	{ 0x275f, 0 },
	{ 0x2760, 0 },
	{ 0x2761, 0 },
	{ 0x2762, 0 },
	{ 0x2763, 0 },
	{ 0x2764, 0 },
	{ 0x2765, 0 },
	{ 0x2766, 0 },
	{ 0x2767, 0 },
	{ 0x2768, 0 },
	{ 0x2769, 0 },
	{ 0x276a, 0 },
	{ 0x276b, 0 },
	{ 0x276c, 0 },
	{ 0x276d, 0 },
	{ 0x276e, 0 },
	{ 0x276f, 0 },
	{ 0x2770, 0 },
	{ 0x2771, 0 },
	{ 0x2772, 0 },
	{ 0x2773, 0 },
	{ 0x2774, 0 },
	{ 0x2775, 0 },
	{ 0x2776, 0 },
	{ 0x2777, 0 },
	{ 0x2778, 0 },
	{ 0x2779, 0 },
	{ 0x277a, 0 },
	{ 0x277b, 0 },
	{ 0x277c, 0 },
	{ 0x277d, 0 },
	{ 0x277e, 0 },
	{ 0x2821, 0 },
	{ 0x2822, 0 },
	{ 0x2823, 0 },
	{ 0x2824, 0 },
	{ 0x2825, 0 },
	{ 0x2826, 0 },
	{ 0x2827, 0 },
	{ 0x2828, 0 },
	{ 0x2829, 0 },
	{ 0x282a, 0 },
	{ 0x282b, 0 },
	{ 0x282c, 0 },
	{ 0x282d, 0 },
	{ 0x282e, 0 },
	{ 0x282f, 0 },
	{ 0x2830, 0 },
	{ 0x2831, 0 },
	{ 0x2832, 0 },
	{ 0x2833, 0 },
	{ 0x2834, 0 },
	{ 0x2835, 0 },
	{ 0x2836, 0 },
	{ 0x2837, 0 },
	{ 0x2838, 0 },
	{ 0x2839, 0 },
	{ 0x283a, 0 },
	{ 0x283b, 0 },
	{ 0x283c, 0 },
	{ 0x283d, 0 },
	{ 0x283e, 0 },
	{ 0x283f, 0 },
	{ 0x2840, 0 },
	{ 0x2841, 0 },
	{ 0x2842, 0 },
	{ 0x2843, 0 },
	{ 0x2844, 0 },
	{ 0x2845, 0 },
	{ 0x2846, 0 },
	{ 0x2847, 0 },
	{ 0x2848, 0 },
	{ 0x2849, 0 },
	{ 0x284a, 0 },
	{ 0x284b, 0 },
	{ 0x284c, 0 },
	{ 0x284d, 0 },
	{ 0x284e, 0 },
	{ 0x284f, 0 },
	{ 0x2850, 0 },
	{ 0x2851, 0 },
	{ 0x2852, 0 },
	{ 0x2853, 0 },
	{ 0x2854, 0 },
	{ 0x2855, 0 },
	{ 0x2856, 0 },
	{ 0x2857, 0 },
	{ 0x2858, 0 },
	{ 0x2859, 0 },
	{ 0x285a, 0 },
	{ 0x285b, 0 },
	{ 0x285c, 0 },
	{ 0x285d, 0 },
	{ 0x285e, 0 },
	{ 0x285f, 0 },
	{ 0x2860, 0 },
	{ 0x2861, 0 },
	{ 0x2862, 0 },
	{ 0x2863, 0 },
	{ 0x2864, 0 },
	{ 0x2865, 0 },
	{ 0x2866, 0 },
	{ 0x2867, 0 },
	{ 0x2868, 0 },
	{ 0x2869, 0 },
	{ 0x286a, 0 },
	{ 0x286b, 0 },
	{ 0x286c, 0 },
	{ 0x286d, 0 },
	{ 0x286e, 0 },
	{ 0x286f, 0 },
	{ 0x2870, 0 },
	{ 0x2871, 0 },
	{ 0x2872, 0 },
	{ 0x2873, 0 },
	{ 0x2874, 0 },
	{ 0x2875, 0 },
	{ 0x2876, 0 },
	{ 0x2877, 0 },
	{ 0x2878, 0 },
	{ 0x2879, 0 },
	{ 0x287a, 0 },
	{ 0x287b, 0 },
	{ 0x287c, 0 },
	{ 0x287d, 0 },
	{ 0x287e, 0 },
	{ 0x2921, 0 },
	{ 0x2922, 0 },
	{ 0x2923, 0 },
	{ 0x2924, 0 },
	{ 0x2925, 0 },
	{ 0x2926, 0 },
	{ 0x2927, 0 },
	{ 0x2928, 0 },
	{ 0x2929, 0 },
	{ 0x292a, 0 },
	{ 0x292b, 0 },
	{ 0x292c, 0 },
	{ 0x292d, 0 },
	{ 0x292e, 0 },
	{ 0x292f, 0 },
	{ 0x2930, 0 },
	{ 0x2931, 0 },
	{ 0x2932, 0 },
	{ 0x2933, 0 },
	{ 0x2934, 0 },
	{ 0x2935, 0 },
	{ 0x2936, 0 },
	{ 0x2937, 0 },
	{ 0x2938, 0 },
	{ 0x2939, 0 },
	{ 0x4221, 0xa3c0 },
	{ 0x4222, 0xa3c1 },
	{ 0x4223, 0xa3c2 },
	{ 0x4224, 0xa3c3 },
	{ 0x4225, 0xa3c4 },
	{ 0x4226, 0xa3c5 },
	{ 0x4227, 0xa3c6 },
	{ 0x4228, 0xa3c7 },
	{ 0x4229, 0xa3c8 },
	{ 0x422a, 0xa3c9 },
	{ 0x422b, 0xa3ca },
	{ 0x422c, 0xa3cb },
	{ 0x422d, 0xa3cc },
	{ 0x422e, 0xa3cd },
	{ 0x422f, 0xa3ce },
	{ 0x4230, 0xa3cf },
	{ 0x4231, 0xa3d0 },
	{ 0x4232, 0xa3d1 },
	{ 0x4233, 0xa3d2 },
	{ 0x4234, 0xa3d3 },
	{ 0x4235, 0xa3d4 },
	{ 0x4236, 0xa3d5 },
	{ 0x4237, 0xa3d6 },
	{ 0x4238, 0xa3d7 },
	{ 0x4239, 0xa3d8 },
	{ 0x423a, 0xa3d9 },
	{ 0x423b, 0xa3da },
	{ 0x423c, 0xa3db },
	{ 0x423d, 0xa3dc },
	{ 0x423e, 0xa3dd },
	{ 0x423f, 0xa3de },
	{ 0x4240, 0xa3df },
	{ 0x4241, 0xa3e0 },
	{ 0x4421, 0xa440 },
	{ 0x4422, 0xa441 },
	{ 0x4423, 0xa442 },
	{ 0x4424, 0xa443 },
	{ 0x4425, 0xa444 },
	{ 0x4426, 0xa445 },
	{ 0x4427, 0xa446 },
	{ 0x4428, 0xa447 },
	{ 0x4429, 0xa448 },
	{ 0x442a, 0xa449 },
	{ 0x442b, 0xa44a },
	{ 0x442c, 0xa44b },
	{ 0x442d, 0xa44c },
	{ 0x442e, 0xa44d },
	{ 0x442f, 0xa44e },
	{ 0x4430, 0xa44f },
	{ 0x4431, 0xa450 },
	{ 0x4432, 0xa451 },
	{ 0x4433, 0xa452 },
	{ 0x4434, 0xa453 },
	{ 0x4435, 0xa454 },
	{ 0x4436, 0xa455 },
	{ 0x4437, 0xa456 },
	{ 0x4438, 0xa457 },
	{ 0x4439, 0xa458 },
	{ 0x443a, 0xa459 },
	{ 0x443b, 0xa45a },
	{ 0x443c, 0xa45b },
	{ 0x443d, 0xa45c },
	{ 0x443e, 0xa45d },
	{ 0x443f, 0xa45e },
	{ 0x4440, 0xa45f },
	{ 0x4441, 0xa460 },
	{ 0x4442, 0xa461 },
	{ 0x4443, 0xa462 },
	{ 0x4444, 0xa463 },
	{ 0x4445, 0xa464 },
	{ 0x4446, 0xa465 },
	{ 0x4447, 0xa466 },
	{ 0x4448, 0xa467 },
	{ 0x4449, 0xa468 },
	{ 0x444a, 0xa469 },
	{ 0x444b, 0xa46a },
	{ 0x444c, 0xa46b },
	{ 0x444d, 0xa46c },
	{ 0x444e, 0xa46d },
	{ 0x444f, 0xa46e },
	{ 0x4450, 0xa46f },
	{ 0x4451, 0xa470 },
	{ 0x4452, 0xa471 },
	{ 0x4453, 0xa472 },
	{ 0x4454, 0xa473 },
	{ 0x4455, 0xa474 },
	{ 0x4456, 0xa475 },
	{ 0x4457, 0xa476 },
	{ 0x4458, 0xa477 },
	{ 0x4459, 0xa478 },
	{ 0x445a, 0xa479 },
	{ 0x445b, 0xa47a },
	{ 0x445c, 0xa47b },
	{ 0x445d, 0xa47c },
	{ 0x445e, 0xa47d },
	{ 0x445f, 0xa47e },
	{ 0x4460, 0xa4a1 },
	{ 0x4461, 0xa4a2 },
	{ 0x4462, 0xa4a3 },
	{ 0x4463, 0xa4a4 },
	{ 0x4464, 0xa4a5 },
	{ 0x4465, 0xa4a6 },
	{ 0x4466, 0xa4a7 },
	{ 0x4467, 0xa4a8 },
	{ 0x4468, 0xa4a9 },
	{ 0x4469, 0xa4aa },
	{ 0x446a, 0xa4ab },
	{ 0x446b, 0xa4ac },
	{ 0x446c, 0xa4ad },
	{ 0x446d, 0xa4ae },
	{ 0x446e, 0xa4af },
	{ 0x446f, 0xa4b0 },
	{ 0x4470, 0xa4b1 },
	{ 0x4471, 0xa4b2 },
	{ 0x4472, 0xa4b3 },
	{ 0x4473, 0xa4b4 },
	{ 0x4474, 0xa4b5 },
	{ 0x4475, 0xa4b6 },
	{ 0x4476, 0xa4b7 },
	{ 0x4477, 0xa4b8 },
	{ 0x4478, 0xa4b9 },
	{ 0x4479, 0xa4ba },
	{ 0x447a, 0xa4bb },
	{ 0x447b, 0xa4bc },
	{ 0x447c, 0xa4bd },
	{ 0x447d, 0xa4be },
	{ 0x447e, 0xa4bf },
	{ 0x4521, 0xa4c0 },
	{ 0x4522, 0xa4c1 },
	{ 0x4523, 0xa4c2 },
	{ 0x4524, 0xa4c3 },
	{ 0x4525, 0xa4c4 },
	{ 0x4526, 0xa4c5 },
	{ 0x4527, 0xa4c6 },
	{ 0x4528, 0xa4c7 },
	{ 0x4529, 0xa4c8 },
	{ 0x452a, 0xa4c9 },
	{ 0x452b, 0xa4ca },
	{ 0x452c, 0xa4cb },
	{ 0x452d, 0xa4cc },
	{ 0x452e, 0xa4cd },
	{ 0x452f, 0xa4ce },
	{ 0x4530, 0xa4cf },
	{ 0x4531, 0xa4d0 },
	{ 0x4532, 0xa4d1 },
	{ 0x4533, 0xa4d2 },
	{ 0x4534, 0xa4d3 },
	{ 0x4535, 0xa4d4 },
	{ 0x4536, 0xa4d5 },
	{ 0x4537, 0xa4d6 },
	{ 0x4538, 0xa4d7 },
	{ 0x4539, 0xa4d8 },
	{ 0x453a, 0xa4d9 },
	{ 0x453b, 0xa4da },
	{ 0x453c, 0xa4db },
	{ 0x453d, 0xa4dc },
	{ 0x453e, 0xa4dd },
	{ 0x453f, 0xa4de },
	{ 0x4540, 0xa4df },
	{ 0x4541, 0xa4e0 },
	{ 0x4542, 0xa4e1 },
	{ 0x4543, 0xa4e2 },
	{ 0x4544, 0xa4e3 },
	{ 0x4545, 0xa4e4 },
	{ 0x4546, 0xa4e5 },
	{ 0x4547, 0xa4e6 },
	{ 0x4548, 0xa4e7 },
	{ 0x4549, 0xa4e8 },
	{ 0x454a, 0xa4e9 },
	{ 0x454b, 0xa4ea },
	{ 0x454c, 0xa4eb },
	{ 0x454d, 0xa4ec },
	{ 0x454e, 0xa4ed },
	{ 0x454f, 0xa4ee },
	{ 0x4550, 0xa4ef },
	{ 0x4551, 0xa4f0 },
	{ 0x4552, 0xa4f1 },
	{ 0x4553, 0xa4f2 },
	{ 0x4554, 0xa4f3 },
	{ 0x4555, 0xa4f4 },
	{ 0x4556, 0xa4f5 },
	{ 0x4557, 0xa4f6 },
	{ 0x4558, 0xa4f7 },
	{ 0x4559, 0xa4f8 },
	{ 0x455a, 0xa4f9 },
	{ 0x455b, 0xa4fa },
	{ 0x455c, 0xa4fb },
	{ 0x455d, 0xa4fc },
	{ 0x455e, 0xa4fd },
	{ 0x455f, 0xa4fe },
	{ 0x4560, 0xa540 },
	{ 0x4561, 0xa541 },
	{ 0x4562, 0xa542 },
	{ 0x4563, 0xa543 },
	{ 0x4564, 0xa544 },
	{ 0x4565, 0xa545 },
	{ 0x4566, 0xa546 },
	{ 0x4567, 0xa547 },
	{ 0x4568, 0xa548 },
	{ 0x4569, 0xa549 },
	{ 0x456a, 0xa54a },
	{ 0x456b, 0xa54b },
	{ 0x456c, 0xa54c },
	{ 0x456d, 0xa54d },
	{ 0x456e, 0xa54e },
	{ 0x456f, 0xa54f },
	{ 0x4570, 0xa550 },
	{ 0x4571, 0xa551 },
	{ 0x4572, 0xa552 },
	{ 0x4573, 0xa553 },
	{ 0x4574, 0xa554 },
	{ 0x4575, 0xa555 },
	{ 0x4576, 0xa556 },
	{ 0x4577, 0xa557 },
	{ 0x4578, 0xa558 },
	{ 0x4579, 0xa559 },
	{ 0x457a, 0xa55a },
	{ 0x457b, 0xa55b },
	{ 0x457c, 0xa55c },
	{ 0x457d, 0xa55d },
	{ 0x457e, 0xa55e },
	{ 0x4621, 0xa55f },
	{ 0x4622, 0xa560 },
	{ 0x4623, 0xa561 },
	{ 0x4624, 0xa562 },
	{ 0x4625, 0xa563 },
	{ 0x4626, 0xa564 },
	{ 0x4627, 0xa565 },
	{ 0x4628, 0xa566 },
	{ 0x4629, 0xa567 },
	{ 0x462a, 0xa568 },
	{ 0x462b, 0xa569 },
	{ 0x462c, 0xa56a },
	{ 0x462d, 0xa56b },
	{ 0x462e, 0xa56c },
	{ 0x462f, 0xa56d },
	{ 0x4630, 0xa56e },
	{ 0x4631, 0xa56f },
	{ 0x4632, 0xa570 },
	{ 0x4633, 0xa571 },
	{ 0x4634, 0xa572 },
	{ 0x4635, 0xa573 },
	{ 0x4636, 0xa574 },
	{ 0x4637, 0xa575 },
	{ 0x4638, 0xa576 },
	{ 0x4639, 0xa577 },
	{ 0x463a, 0xa578 },
	{ 0x463b, 0xa579 },
	{ 0x463c, 0xa57a },
	{ 0x463d, 0xa57b },
	{ 0x463e, 0xa57c },
	{ 0x463f, 0xa57d },
	{ 0x4640, 0xa57e },
	{ 0x4641, 0xa5a1 },
	{ 0x4642, 0xa5a2 },
	{ 0x4643, 0xa5a3 },
	{ 0x4644, 0xa5a4 },
	{ 0x4645, 0xa5a5 },
	{ 0x4646, 0xa5a6 },
	{ 0x4647, 0xa5a7 },
	{ 0x4648, 0xa5a8 },
	{ 0x4649, 0xa5a9 },
	{ 0x464a, 0xa5aa },
	{ 0x464b, 0xa5ab },
	{ 0x464c, 0xa5ac },
	{ 0x464d, 0xa5ad },
	{ 0x464e, 0xa5ae },
	{ 0x464f, 0xa5af },
	{ 0x4650, 0xa5b0 },
	{ 0x4651, 0xa5b1 },
	{ 0x4652, 0xa5b2 },
	{ 0x4653, 0xa5b3 },
	{ 0x4654, 0xa5b4 },
	{ 0x4655, 0xa5b5 },
	{ 0x4656, 0xa5b6 },
	{ 0x4657, 0xa5b7 },
	{ 0x4658, 0xa5b8 },
	{ 0x4659, 0xa5b9 },
	{ 0x465a, 0xa5ba },
	{ 0x465b, 0xa5bb },
	{ 0x465c, 0xa5bc },
	{ 0x465d, 0xa5bd },
	{ 0x465e, 0xa5be },
	{ 0x465f, 0xa5bf },
	{ 0x4660, 0xa5c0 },
	{ 0x4661, 0xa5c1 },
	{ 0x4662, 0xa5c2 },
	{ 0x4663, 0xa5c3 },
	{ 0x4664, 0xa5c4 },
	{ 0x4665, 0xa5c5 },
	{ 0x4666, 0xa5c6 },
	{ 0x4667, 0xa5c7 },
	{ 0x4668, 0xa5c8 },
	{ 0x4669, 0xa5c9 },
	{ 0x466a, 0xa5ca },
	{ 0x466b, 0xa5cb },
	{ 0x466c, 0xa5cc },
	{ 0x466d, 0xa5cd },
	{ 0x466e, 0xa5ce },
	{ 0x466f, 0xa5cf },
	{ 0x4670, 0xa5d0 },
	{ 0x4671, 0xa5d1 },
	{ 0x4672, 0xa5d2 },
	{ 0x4673, 0xa5d3 },
	{ 0x4674, 0xa5d4 },
	{ 0x4675, 0xa5d5 },
	{ 0x4676, 0xa5d6 },
	{ 0x4677, 0xa5d7 },
	{ 0x4678, 0xa5d8 },
	{ 0x4679, 0xa5d9 },
	{ 0x467a, 0xa5da },
	{ 0x467b, 0xa5db },
	{ 0x467c, 0xa5dc },
	{ 0x467d, 0xa5dd },
	{ 0x467e, 0xa5de },
	{ 0x4721, 0xa5df },
	{ 0x4722, 0xa5e0 },
	{ 0x4723, 0xa5e1 },
	{ 0x4724, 0xa5e2 },
	{ 0x4725, 0xa5e3 },
	{ 0x4726, 0xa5e4 },
	{ 0x4727, 0xa5e5 },
	{ 0x4728, 0xa5e6 },
	{ 0x4729, 0xa5e7 },
	{ 0x472a, 0xa5e8 },
	{ 0x472b, 0xa5e9 },
	{ 0x472c, 0xa5ea },
	{ 0x472d, 0xa5eb },
	{ 0x472e, 0xa5ec },
	{ 0x472f, 0xa5ed },
	{ 0x4730, 0xa5ee },
	{ 0x4731, 0xa5ef },
	{ 0x4732, 0xa5f0 },
	{ 0x4733, 0xa5f1 },
	{ 0x4734, 0xa5f2 },
	{ 0x4735, 0xa5f3 },
	{ 0x4736, 0xa5f4 },
	{ 0x4737, 0xa5f5 },
	{ 0x4738, 0xa5f6 },
	{ 0x4739, 0xa5f7 },
	{ 0x473a, 0xa5f8 },
	{ 0x473b, 0xa5f9 },
	{ 0x473c, 0xa5fa },
	{ 0x473d, 0xa5fb },
	{ 0x473e, 0xa5fc },
	{ 0x473f, 0xa5fd },
	{ 0x4740, 0xa5fe },
	{ 0x4741, 0xa640 },
	{ 0x4742, 0xa641 },
	{ 0x4743, 0xa642 },
	{ 0x4744, 0xa643 },
	{ 0x4745, 0xa644 },
	{ 0x4746, 0xa645 },
	{ 0x4747, 0xa646 },
	{ 0x4748, 0xa647 },
	{ 0x4749, 0xa648 },
	{ 0x474a, 0xa649 },
	{ 0x474b, 0xa64a },
	{ 0x474c, 0xa64b },
	{ 0x474d, 0xa64c },
	{ 0x474e, 0xa64d },
	{ 0x474f, 0xa64e },
	{ 0x4750, 0xa64f },
	{ 0x4751, 0xa650 },
	{ 0x4752, 0xa651 },
	{ 0x4753, 0xa652 },
	{ 0x4754, 0xa653 },
	{ 0x4755, 0xa654 },
	{ 0x4756, 0xa655 },
	{ 0x4757, 0xa656 },
	{ 0x4758, 0xa657 },
	{ 0x4759, 0xa658 },
	{ 0x475a, 0xa659 },
	{ 0x475b, 0xa65a },
	{ 0x475c, 0xa65b },
	{ 0x475d, 0xa65c },
	{ 0x475e, 0xa65d },
	{ 0x475f, 0xa65e },
	{ 0x4760, 0xa65f },
	{ 0x4761, 0xa660 },
	{ 0x4762, 0xa661 },
	{ 0x4763, 0xa662 },
	{ 0x4764, 0xa663 },
	{ 0x4765, 0xa664 },
	{ 0x4766, 0xa665 },
	{ 0x4767, 0xa666 },
	{ 0x4768, 0xa667 },
	{ 0x4769, 0xa668 },
	{ 0x476a, 0xa669 },
	{ 0x476b, 0xa66a },
	{ 0x476c, 0xa66b },
	{ 0x476d, 0xa66c },
	{ 0x476e, 0xa66d },
	{ 0x476f, 0xa66e },
	{ 0x4770, 0xa66f },
	{ 0x4771, 0xa670 },
	{ 0x4772, 0xa671 },
	{ 0x4773, 0xa672 },
	{ 0x4774, 0xa673 },
	{ 0x4775, 0xa674 },
	{ 0x4776, 0xa675 },
	{ 0x4777, 0xa676 },
	{ 0x4778, 0xa677 },
	{ 0x4779, 0xa678 },
	{ 0x477a, 0xa679 },
	{ 0x477b, 0xa67a },
	{ 0x477c, 0xa67b },
	{ 0x477d, 0xa67c },
	{ 0x477e, 0xa67d },
	{ 0x4821, 0xa67e },
	{ 0x4822, 0xa6a1 },
	{ 0x4823, 0xa6a2 },
	{ 0x4824, 0xa6a3 },
	{ 0x4825, 0xa6a4 },
	{ 0x4826, 0xa6a5 },
	{ 0x4827, 0xa6a6 },
	{ 0x4828, 0xa6a7 },
	{ 0x4829, 0xa6a8 },
	{ 0x482a, 0xa6a9 },
	{ 0x482b, 0xa6aa },
	{ 0x482c, 0xa6ab },
	{ 0x482d, 0xa6ac },
	{ 0x482e, 0xa6ad },
	{ 0x482f, 0xa6ae },
	{ 0x4830, 0xa6af },
	{ 0x4831, 0xa6b0 },
	{ 0x4832, 0xa6b1 },
	{ 0x4833, 0xa6b2 },
	{ 0x4834, 0xa6b3 },
	{ 0x4835, 0xa6b4 },
	{ 0x4836, 0xa6b5 },
	{ 0x4837, 0xa6b6 },
	{ 0x4838, 0xa6b7 },
	{ 0x4839, 0xa6b8 },
	{ 0x483a, 0xa6b9 },
	{ 0x483b, 0xa6ba },
	{ 0x483c, 0xa6bb },
	{ 0x483d, 0xa6bc },
	{ 0x483e, 0xa6bd },
	{ 0x483f, 0xa6be },
	{ 0x4840, 0xa6bf },
	{ 0x4841, 0xa6c0 },
	{ 0x4842, 0xa6c1 },
	{ 0x4843, 0xa6c2 },
	{ 0x4844, 0xa6c3 },
	{ 0x4845, 0xa6c4 },
	{ 0x4846, 0xa6c5 },
	{ 0x4847, 0xa6c6 },
	{ 0x4848, 0xa6c7 },
	{ 0x4849, 0xa6c8 },
	{ 0x484a, 0xa6c9 },
	{ 0x484b, 0xa6ca },
	{ 0x484c, 0xa6cb },
	{ 0x484d, 0xa6cc },
	{ 0x484e, 0xa6cd },
	{ 0x484f, 0xa6ce },
	{ 0x4850, 0xa6cf },
	{ 0x4851, 0xa6d0 },
	{ 0x4852, 0xa6d1 },
	{ 0x4853, 0xa6d2 },
	{ 0x4854, 0xa6d3 },
	{ 0x4855, 0xa6d4 },
	{ 0x4856, 0xa6d5 },
	{ 0x4857, 0xa6d6 },
	{ 0x4858, 0xa6d7 },
	{ 0x4859, 0xa6d8 },
	{ 0x485a, 0xa6d9 },
	{ 0x485b, 0xa6da },
	{ 0x485c, 0xa6db },
	{ 0x485d, 0xa6dc },
	{ 0x485e, 0xa6dd },
	{ 0x485f, 0xa6de },
	{ 0x4860, 0xa6df },
	{ 0x4861, 0xa6e0 },
	{ 0x4862, 0xa6e1 },
	{ 0x4863, 0xa6e2 },
	{ 0x4864, 0xa6e3 },
	{ 0x4865, 0xa6e4 },
	{ 0x4866, 0xa6e5 },
	{ 0x4867, 0xa6e6 },
	{ 0x4868, 0xa6e7 },
	{ 0x4869, 0xa6e8 },
	{ 0x486a, 0xa6e9 },
	{ 0x486b, 0xa6ea },
	{ 0x486c, 0xa6eb },
	{ 0x486d, 0xa6ec },
	{ 0x486e, 0xa6ed },
	{ 0x486f, 0xa6ee },
	{ 0x4870, 0xa6ef },
	{ 0x4871, 0xa6f0 },
	{ 0x4872, 0xa6f1 },
	{ 0x4873, 0xa6f2 },
	{ 0x4874, 0xa6f3 },
	{ 0x4875, 0xa6f4 },
	{ 0x4876, 0xa6f5 },
	{ 0x4877, 0xa6f6 },
	{ 0x4878, 0xa6f7 },
	{ 0x4879, 0xa6f8 },
	{ 0x487a, 0xa6f9 },
	{ 0x487b, 0xa6fa },
	{ 0x487c, 0xa6fb },
	{ 0x487d, 0xa6fc },
	{ 0x487e, 0xa6fd },
	{ 0x4921, 0xa6fe },
	{ 0x4922, 0xa740 },
	{ 0x4923, 0xa741 },
	{ 0x4924, 0xa742 },
	{ 0x4925, 0xa743 },
	{ 0x4926, 0xa744 },
	{ 0x4927, 0xa745 },
	{ 0x4928, 0xa746 },
	{ 0x4929, 0xa747 },
	{ 0x492a, 0xa748 },
	{ 0x492b, 0xa749 },
	{ 0x492c, 0xa74a },
	{ 0x492d, 0xa74b },
	{ 0x492e, 0xa74c },
	{ 0x492f, 0xa74d },
	{ 0x4930, 0xa74e },
	{ 0x4931, 0xa74f },
	{ 0x4932, 0xa750 },
	{ 0x4933, 0xa751 },
	{ 0x4934, 0xa752 },
	{ 0x4935, 0xa753 },
	{ 0x4936, 0xa754 },
	{ 0x4937, 0xa755 },
	{ 0x4938, 0xa756 },
	{ 0x4939, 0xa757 },
	{ 0x493a, 0xa758 },
	{ 0x493b, 0xa759 },
	{ 0x493c, 0xa75a },
	{ 0x493d, 0xa75b },
	{ 0x493e, 0xa75c },
	{ 0x493f, 0xa75d },
	{ 0x4940, 0xa75e },
	{ 0x4941, 0xa75f },
	{ 0x4942, 0xa760 },
	{ 0x4943, 0xa761 },
	{ 0x4944, 0xa762 },
	{ 0x4945, 0xa763 },
	{ 0x4946, 0xa764 },
	{ 0x4947, 0xa765 },
	{ 0x4948, 0xa766 },
	{ 0x4949, 0xa767 },
	{ 0x494a, 0xa768 },
	{ 0x494b, 0xa769 },
	{ 0x494c, 0xa76a },
	{ 0x494d, 0xa76b },
	{ 0x494e, 0xa76c },
	{ 0x494f, 0xa76d },
	{ 0x4950, 0xa76e },
	{ 0x4951, 0xa76f },
	{ 0x4952, 0xa770 },
	{ 0x4953, 0xa771 },
	{ 0x4954, 0xa772 },
	{ 0x4955, 0xa773 },
	{ 0x4956, 0xa774 },
	{ 0x4957, 0xa775 },
	{ 0x4958, 0xa776 },
	{ 0x4959, 0xa777 },
	{ 0x495a, 0xa778 },
	{ 0x495b, 0xa779 },
	{ 0x495c, 0xa77a },
	{ 0x495d, 0xa77b },
	{ 0x495e, 0xa77c },
	{ 0x495f, 0xa77d },
	{ 0x4960, 0xa77e },
	{ 0x4961, 0xa7a1 },
	{ 0x4962, 0xa7a2 },
	{ 0x4963, 0xa7a3 },
	{ 0x4964, 0xa7a4 },
	{ 0x4965, 0xa7a5 },
	{ 0x4966, 0xa7a6 },
	{ 0x4967, 0xa7a7 },
	{ 0x4968, 0xa7a8 },
	{ 0x4969, 0xa7a9 },
	{ 0x496a, 0xa7aa },
	{ 0x496b, 0xa7ab },
	{ 0x496c, 0xa7ac },
	{ 0x496d, 0xa7ad },
	{ 0x496e, 0xa7ae },
	{ 0x496f, 0xa7af },
	{ 0x4970, 0xa7b0 },
	{ 0x4971, 0xa7b1 },
	{ 0x4972, 0xa7b2 },
	{ 0x4973, 0xa7b3 },
	{ 0x4974, 0xa7b4 },
	{ 0x4975, 0xa7b5 },
	{ 0x4976, 0xa7b6 },
	{ 0x4977, 0xa7b7 },
	{ 0x4978, 0xa7b8 },
	{ 0x4979, 0xa7b9 },
	{ 0x497a, 0xa7ba },
	{ 0x497b, 0xa7bb },
	{ 0x497c, 0xa7bc },
	{ 0x497d, 0xa7bd },
	{ 0x497e, 0xa7be },
	{ 0x4a21, 0xa7bf },
	{ 0x4a22, 0xa7c0 },
	{ 0x4a23, 0xa7c1 },
	{ 0x4a24, 0xa7c2 },
	{ 0x4a25, 0xa7c3 },
	{ 0x4a26, 0xa7c4 },
	{ 0x4a27, 0xa7c5 },
	{ 0x4a28, 0xa7c6 },
	{ 0x4a29, 0xa7c7 },
	{ 0x4a2a, 0xa7c8 },
	{ 0x4a2b, 0xa7c9 },
	{ 0x4a2c, 0xa7ca },
	{ 0x4a2d, 0xa7cb },
	{ 0x4a2e, 0xa7cc },
	{ 0x4a2f, 0xa7cd },
	{ 0x4a30, 0xa7ce },
	{ 0x4a31, 0xa7cf },
	{ 0x4a32, 0xa7d0 },
	{ 0x4a33, 0xa7d1 },
	{ 0x4a34, 0xa7d2 },
	{ 0x4a35, 0xa7d3 },
	{ 0x4a36, 0xa7d4 },
	{ 0x4a37, 0xa7d5 },
	{ 0x4a38, 0xa7d6 },
	{ 0x4a39, 0xa7d7 },
	{ 0x4a3a, 0xa7d8 },
	{ 0x4a3b, 0xa7d9 },
	{ 0x4a3c, 0xa7da },
	{ 0x4a3d, 0xa7db },
	{ 0x4a3e, 0xa7dc },
	{ 0x4a3f, 0xa7dd },
	{ 0x4a40, 0xa7de },
	{ 0x4a41, 0xa7df },
	{ 0x4a42, 0xa7e0 },
	{ 0x4a43, 0xa7e1 },
	{ 0x4a44, 0xa7e2 },
	{ 0x4a45, 0xa7e3 },
	{ 0x4a46, 0xa7e4 },
	{ 0x4a47, 0xa7e5 },
	{ 0x4a48, 0xa7e6 },
	{ 0x4a49, 0xa7e7 },
	{ 0x4a4a, 0xa7e8 },
	{ 0x4a4b, 0xa7e9 },
	{ 0x4a4c, 0xa7ea },
	{ 0x4a4d, 0xa7eb },
	{ 0x4a4e, 0xa7ec },
	{ 0x4a4f, 0xa7ed },
	{ 0x4a50, 0xa7ee },
	{ 0x4a51, 0xa7ef },
	{ 0x4a52, 0xa7f0 },
	{ 0x4a53, 0xa7f1 },
	{ 0x4a54, 0xa7f2 },
	{ 0x4a55, 0xa7f3 },
	{ 0x4a56, 0xa7f4 },
	{ 0x4a57, 0xa7f5 },
	{ 0x4a58, 0xa7f6 },
	{ 0x4a59, 0xa7f7 },
	{ 0x4a5a, 0xa7f8 },
	{ 0x4a5b, 0xa7f9 },
	{ 0x4a5c, 0xa7fa },
	{ 0x4a5d, 0xa7fb },
	{ 0x4a5e, 0xa7fc },
	{ 0x4a5f, 0xa7fd },
	{ 0x4a60, 0xa7fe },
	{ 0x4a61, 0xa840 },
	{ 0x4a62, 0xa841 },
	{ 0x4a63, 0xa842 },
	{ 0x4a64, 0xa843 },
	{ 0x4a65, 0xa844 },
	{ 0x4a66, 0xa845 },
	{ 0x4a67, 0xa846 },
	{ 0x4a68, 0xa847 },
	{ 0x4a69, 0xa848 },
	{ 0x4a6a, 0xa849 },
	{ 0x4a6b, 0xa84a },
	{ 0x4a6c, 0xa84b },
	{ 0x4a6d, 0xa84c },
	{ 0x4a6e, 0xa84d },
	{ 0x4a6f, 0xa84e },
	{ 0x4a70, 0xa84f },
	{ 0x4a71, 0xa850 },
	{ 0x4a72, 0xa851 },
	{ 0x4a73, 0xa852 },
	{ 0x4a74, 0xa853 },
	{ 0x4a75, 0xa854 },
	{ 0x4a76, 0xa855 },
	{ 0x4a77, 0xa856 },
	{ 0x4a78, 0xa857 },
	{ 0x4a79, 0xa858 },
	{ 0x4a7a, 0xa859 },
	{ 0x4a7b, 0xa85a },
	{ 0x4a7c, 0xa85b },
	{ 0x4a7d, 0xa85c },
	{ 0x4a7e, 0xa85d },
	{ 0x4b21, 0xa85e },
	{ 0x4b22, 0xa85f },
	{ 0x4b23, 0xa860 },
	{ 0x4b24, 0xa861 },
	{ 0x4b25, 0xa862 },
	{ 0x4b26, 0xa863 },
	{ 0x4b27, 0xa864 },
	{ 0x4b28, 0xa865 },
	{ 0x4b29, 0xa866 },
	{ 0x4b2a, 0xa867 },
	{ 0x4b2b, 0xa868 },
	{ 0x4b2c, 0xa869 },
	{ 0x4b2d, 0xa86a },
	{ 0x4b2e, 0xa86b },
	{ 0x4b2f, 0xa86c },
	{ 0x4b30, 0xa86d },
	{ 0x4b31, 0xa86e },
	{ 0x4b32, 0xa86f },
	{ 0x4b33, 0xa870 },
	{ 0x4b34, 0xa871 },
	{ 0x4b35, 0xa872 },
	{ 0x4b36, 0xa873 },
	{ 0x4b37, 0xa874 },
	{ 0x4b38, 0xa875 },
	{ 0x4b39, 0xa876 },
	{ 0x4b3a, 0xa877 },
	{ 0x4b3b, 0xa878 },
	{ 0x4b3c, 0xa879 },
	{ 0x4b3d, 0xa87a },
	{ 0x4b3e, 0xa87b },
	{ 0x4b3f, 0xa87c },
	{ 0x4b40, 0xa87d },
	{ 0x4b41, 0xa87e },
	{ 0x4b42, 0xa8a1 },
	{ 0x4b43, 0xa8a2 },
	{ 0x4b44, 0xa8a3 },
	{ 0x4b45, 0xa8a4 },
	{ 0x4b46, 0xa8a5 },
	{ 0x4b47, 0xa8a6 },
	{ 0x4b48, 0xa8a7 },
	{ 0x4b49, 0xa8a8 },
	{ 0x4b4a, 0xa8a9 },
	{ 0x4b4b, 0xa8aa },
	{ 0x4b4c, 0xa8ab },
	{ 0x4b4d, 0xa8ac },
	{ 0x4b4e, 0xa8ad },
	{ 0x4b4f, 0xa8ae },
	{ 0x4b50, 0xa8af },
	{ 0x4b51, 0xa8b0 },
	{ 0x4b52, 0xa8b1 },
	{ 0x4b53, 0xa8b2 },
	{ 0x4b54, 0xa8b3 },
	{ 0x4b55, 0xa8b4 },
	{ 0x4b56, 0xa8b5 },
	{ 0x4b57, 0xa8b6 },
	{ 0x4b58, 0xa8b7 },
	{ 0x4b59, 0xa8b8 },
	{ 0x4b5a, 0xa8b9 },
	{ 0x4b5b, 0xa8ba },
	{ 0x4b5c, 0xa8bb },
	{ 0x4b5d, 0xa8bc },
	{ 0x4b5e, 0xa8bd },
	{ 0x4b5f, 0xa8be },
	{ 0x4b60, 0xa8bf },
	{ 0x4b61, 0xa8c0 },
	{ 0x4b62, 0xa8c1 },
	{ 0x4b63, 0xa8c2 },
	{ 0x4b64, 0xa8c3 },
	{ 0x4b65, 0xa8c4 },
	{ 0x4b66, 0xa8c5 },
	{ 0x4b67, 0xa8c6 },
	{ 0x4b68, 0xa8c7 },
	{ 0x4b69, 0xa8c8 },
	{ 0x4b6a, 0xa8c9 },
	{ 0x4b6b, 0xa8ca },
	{ 0x4b6c, 0xa8cb },
	{ 0x4b6d, 0xa8cc },
	{ 0x4b6e, 0xa8cd },
	{ 0x4b6f, 0xa8ce },
	{ 0x4b70, 0xa8cf },
	{ 0x4b71, 0xa8d0 },
	{ 0x4b72, 0xa8d1 },
	{ 0x4b73, 0xa8d2 },
	{ 0x4b74, 0xa8d3 },
	{ 0x4b75, 0xa8d4 },
	{ 0x4b76, 0xa8d5 },
	{ 0x4b77, 0xa8d6 },
	{ 0x4b78, 0xa8d7 },
	{ 0x4b79, 0xa8d8 },
	{ 0x4b7a, 0xa8d9 },
	{ 0x4b7b, 0xa8da },
	{ 0x4b7c, 0xa8db },
	{ 0x4b7d, 0xa8dc },
	{ 0x4b7e, 0xa8dd },
	{ 0x4c21, 0xa8de },
	{ 0x4c22, 0xa8df },
	{ 0x4c23, 0xa8e0 },
	{ 0x4c24, 0xa8e1 },
	{ 0x4c25, 0xa8e2 },
	{ 0x4c26, 0xa8e3 },
	{ 0x4c27, 0xa8e4 },
	{ 0x4c28, 0xa8e5 },
	{ 0x4c29, 0xa8e6 },
	{ 0x4c2a, 0xa8e7 },
	{ 0x4c2b, 0xa8e8 },
	{ 0x4c2c, 0xa8e9 },
	{ 0x4c2d, 0xa8ea },
	{ 0x4c2e, 0xa8eb },
	{ 0x4c2f, 0xa8ec },
	{ 0x4c30, 0xa8ed },
	{ 0x4c31, 0xa8ee },
	{ 0x4c32, 0xa8ef },
	{ 0x4c33, 0xa8f0 },
	{ 0x4c34, 0xa8f1 },
	{ 0x4c35, 0xa8f2 },
	{ 0x4c36, 0xa8f3 },
	{ 0x4c37, 0xa8f4 },
	{ 0x4c38, 0xa8f5 },
	{ 0x4c39, 0xa8f6 },
	{ 0x4c3a, 0xa8f7 },
	{ 0x4c3b, 0xa8f8 },
	{ 0x4c3c, 0xa8f9 },
	{ 0x4c3d, 0xa8fa },
	{ 0x4c3e, 0xa8fb },
	{ 0x4c3f, 0xa8fc },
	{ 0x4c40, 0xa8fd },
	{ 0x4c41, 0xa8fe },
	{ 0x4c42, 0xa940 },
	{ 0x4c43, 0xa941 },
	{ 0x4c44, 0xa942 },
	{ 0x4c45, 0xa943 },
	{ 0x4c46, 0xa944 },
	{ 0x4c47, 0xa945 },
	{ 0x4c48, 0xa946 },
	{ 0x4c49, 0xa947 },
	{ 0x4c4a, 0xa948 },
	{ 0x4c4b, 0xa949 },
	{ 0x4c4c, 0xa94a },
	{ 0x4c4d, 0xa94b },
	{ 0x4c4e, 0xa94c },
	{ 0x4c4f, 0xa94d },
	{ 0x4c50, 0xa94e },
	{ 0x4c51, 0xa94f },
	{ 0x4c52, 0xa950 },
	{ 0x4c53, 0xa951 },
	{ 0x4c54, 0xa952 },
	{ 0x4c55, 0xa953 },
	{ 0x4c56, 0xa954 },
	{ 0x4c57, 0xa955 },
	{ 0x4c58, 0xa956 },
	{ 0x4c59, 0xa957 },
	{ 0x4c5a, 0xa958 },
	{ 0x4c5b, 0xa959 },
	{ 0x4c5c, 0xa95a },
	{ 0x4c5d, 0xa95b },
	{ 0x4c5e, 0xa95c },
	{ 0x4c5f, 0xa95d },
	{ 0x4c60, 0xa95e },
	{ 0x4c61, 0xa95f },
	{ 0x4c62, 0xa960 },
	{ 0x4c63, 0xa961 },
	{ 0x4c64, 0xa962 },
	{ 0x4c65, 0xa963 },
	{ 0x4c66, 0xa964 },
	{ 0x4c67, 0xa965 },
	{ 0x4c68, 0xa966 },
	{ 0x4c69, 0xa967 },
	{ 0x4c6a, 0xa968 },
	{ 0x4c6b, 0xa969 },
	{ 0x4c6c, 0xa96a },
	{ 0x4c6d, 0xa96b },
	{ 0x4c6e, 0xa96c },
	{ 0x4c6f, 0xa96d },
	{ 0x4c70, 0xa96e },
	{ 0x4c71, 0xa96f },
	{ 0x4c72, 0xa970 },
	{ 0x4c73, 0xa971 },
	{ 0x4c74, 0xa972 },
	{ 0x4c75, 0xa973 },
	{ 0x4c76, 0xa974 },
	{ 0x4c77, 0xa975 },
	{ 0x4c78, 0xa976 },
	{ 0x4c79, 0xa977 },
	{ 0x4c7a, 0xa978 },
	{ 0x4c7b, 0xa979 },
	{ 0x4c7c, 0xa97a },
	{ 0x4c7d, 0xa97b },
	{ 0x4c7e, 0xa97c },
	{ 0x4d21, 0xa97d },
	{ 0x4d22, 0xa97e },
	{ 0x4d23, 0xa9a1 },
	{ 0x4d24, 0xa9a2 },
	{ 0x4d25, 0xa9a3 },
	{ 0x4d26, 0xa9a4 },
	{ 0x4d27, 0xa9a5 },
	{ 0x4d28, 0xa9a6 },
	{ 0x4d29, 0xa9a7 },
	{ 0x4d2a, 0xa9a8 },
	{ 0x4d2b, 0xa9a9 },
	{ 0x4d2c, 0xa9aa },
	{ 0x4d2d, 0xa9ab },
	{ 0x4d2e, 0xa9ac },
	{ 0x4d2f, 0xa9ad },
	{ 0x4d30, 0xa9ae },
	{ 0x4d31, 0xa9af },
	{ 0x4d32, 0xa9b0 },
	{ 0x4d33, 0xa9b1 },
	{ 0x4d34, 0xa9b2 },
	{ 0x4d35, 0xa9b3 },
	{ 0x4d36, 0xa9b4 },
	{ 0x4d37, 0xa9b5 },
	{ 0x4d38, 0xa9b6 },
	{ 0x4d39, 0xa9b7 },
	{ 0x4d3a, 0xa9b8 },
	{ 0x4d3b, 0xa9b9 },
	{ 0x4d3c, 0xa9ba },
	{ 0x4d3d, 0xa9bb },
	{ 0x4d3e, 0xa9bc },
	{ 0x4d3f, 0xa9bd },
	{ 0x4d40, 0xa9be },
	{ 0x4d41, 0xa9bf },
	{ 0x4d42, 0xa9c0 },
	{ 0x4d43, 0xa9c1 },
	{ 0x4d44, 0xa9c2 },
	{ 0x4d45, 0xa9c3 },
	{ 0x4d46, 0xa9c4 },
	{ 0x4d47, 0xa9c5 },
	{ 0x4d48, 0xa9c6 },
	{ 0x4d49, 0xa9c7 },
	{ 0x4d4a, 0xa9c8 },
	{ 0x4d4b, 0xa9c9 },
	{ 0x4d4c, 0xa9ca },
	{ 0x4d4d, 0xa9cb },
	{ 0x4d4e, 0xa9cc },
	{ 0x4d4f, 0xa9cd },
	{ 0x4d50, 0xa9ce },
	{ 0x4d51, 0xa9cf },
	{ 0x4d52, 0xa9d0 },
	{ 0x4d53, 0xa9d1 },
	{ 0x4d54, 0xa9d2 },
	{ 0x4d55, 0xa9d3 },
	{ 0x4d56, 0xa9d4 },
	{ 0x4d57, 0xa9d5 },
	{ 0x4d58, 0xa9d6 },
	{ 0x4d59, 0xa9d7 },
	{ 0x4d5a, 0xa9d8 },
	{ 0x4d5b, 0xa9d9 },
	{ 0x4d5c, 0xa9da },
	{ 0x4d5d, 0xa9db },
	{ 0x4d5e, 0xa9dc },
	{ 0x4d5f, 0xa9dd },
	{ 0x4d60, 0xa9de },
	{ 0x4d61, 0xa9df },
	{ 0x4d62, 0xa9e0 },
	{ 0x4d63, 0xa9e1 },
	{ 0x4d64, 0xa9e2 },
	{ 0x4d65, 0xa9e3 },
	{ 0x4d66, 0xa9e4 },
	{ 0x4d67, 0xa9e5 },
	{ 0x4d68, 0xa9e6 },
	{ 0x4d69, 0xa9e7 },
	{ 0x4d6a, 0xa9e8 },
	{ 0x4d6b, 0xa9e9 },
	{ 0x4d6c, 0xa9ea },
	{ 0x4d6d, 0xa9eb },
	{ 0x4d6e, 0xa9ec },
	{ 0x4d6f, 0xa9ed },
	{ 0x4d70, 0xa9ee },
	{ 0x4d71, 0xa9ef },
	{ 0x4d72, 0xa9f0 },
	{ 0x4d73, 0xa9f1 },
	{ 0x4d74, 0xa9f2 },
	{ 0x4d75, 0xa9f3 },
	{ 0x4d76, 0xa9f4 },
	{ 0x4d77, 0xa9f5 },
	{ 0x4d78, 0xa9f6 },
	{ 0x4d79, 0xa9f7 },
	{ 0x4d7a, 0xa9f8 },
	{ 0x4d7b, 0xa9f9 },
	{ 0x4d7c, 0xa9fa },
	{ 0x4d7d, 0xa9fb },
	{ 0x4d7e, 0xa9fc },
	{ 0x4e21, 0xa9fd },
	{ 0x4e22, 0xa9fe },
	{ 0x4e23, 0xaa40 },
	{ 0x4e24, 0xaa41 },
	{ 0x4e25, 0xaa42 },
	{ 0x4e26, 0xaa43 },
	{ 0x4e27, 0xaa44 },
	{ 0x4e28, 0xaa45 },
	{ 0x4e29, 0xaa46 },
	{ 0x4e2a, 0xaa47 },
	{ 0x4e2b, 0xaa48 },
	{ 0x4e2c, 0xaa49 },
	{ 0x4e2d, 0xaa4a },
	{ 0x4e2e, 0xaa4b },
	{ 0x4e2f, 0xaa4c },
	{ 0x4e30, 0xaa4d },
	{ 0x4e31, 0xaa4e },
	{ 0x4e32, 0xaa4f },
	{ 0x4e33, 0xaa50 },
	{ 0x4e34, 0xaa51 },
	{ 0x4e35, 0xaa52 },
	{ 0x4e36, 0xaa53 },
	{ 0x4e37, 0xaa54 },
	{ 0x4e38, 0xaa55 },
	{ 0x4e39, 0xaa56 },
	{ 0x4e3a, 0xaa57 },
	{ 0x4e3b, 0xaa58 },
	{ 0x4e3c, 0xaa59 },
	{ 0x4e3d, 0xaa5a },
	{ 0x4e3e, 0xaa5b },
	{ 0x4e3f, 0xaa5c },
	{ 0x4e40, 0xaa5d },
	{ 0x4e41, 0xaa5e },
	{ 0x4e42, 0xaa5f },
	{ 0x4e43, 0xaa60 },
	{ 0x4e44, 0xaa61 },
	{ 0x4e45, 0xaa62 },
	{ 0x4e46, 0xaa63 },
	{ 0x4e47, 0xaa64 },
	{ 0x4e48, 0xaa65 },
	{ 0x4e49, 0xaa66 },
	{ 0x4e4a, 0xaa67 },
	{ 0x4e4b, 0xaa68 },
	{ 0x4e4c, 0xaa69 },
	{ 0x4e4d, 0xaa6a },
	{ 0x4e4e, 0xaa6b },
	{ 0x4e4f, 0xaa6c },
	{ 0x4e50, 0xaa6d },
	{ 0x4e51, 0xaa6e },
	{ 0x4e52, 0xaa6f },
	{ 0x4e53, 0xaa70 },
	{ 0x4e54, 0xaa71 },
	{ 0x4e55, 0xaa72 },
	{ 0x4e56, 0xaa73 },
	{ 0x4e57, 0xaa74 },
	{ 0x4e58, 0xaa75 },
	{ 0x4e59, 0xaa76 },
	{ 0x4e5a, 0xaa77 },
	{ 0x4e5b, 0xaa78 },
	{ 0x4e5c, 0xaa79 },
	{ 0x4e5d, 0xaa7a },
	{ 0x4e5e, 0xaa7b },
	{ 0x4e5f, 0xaa7c },
	{ 0x4e60, 0xaa7d },
	{ 0x4e61, 0xaa7e },
	{ 0x4e62, 0xaaa1 },
	{ 0x4e63, 0xaaa2 },
	{ 0x4e64, 0xaaa3 },
	{ 0x4e65, 0xaaa4 },
	{ 0x4e66, 0xaaa5 },
	{ 0x4e67, 0xaaa6 },
	{ 0x4e68, 0xaaa7 },
	{ 0x4e69, 0xaaa8 },
	{ 0x4e6a, 0xaaa9 },
	{ 0x4e6b, 0xaaaa },
	{ 0x4e6c, 0xaaab },
	{ 0x4e6d, 0xaaac },
	{ 0x4e6e, 0xaaad },
	{ 0x4e6f, 0xaaae },
	{ 0x4e70, 0xaaaf },
	{ 0x4e71, 0xaab0 },
	{ 0x4e72, 0xaab1 },
	{ 0x4e73, 0xaab2 },
	{ 0x4e74, 0xaab3 },
	{ 0x4e75, 0xaab4 },
	{ 0x4e76, 0xaab5 },
	{ 0x4e77, 0xaab6 },
	{ 0x4e78, 0xaab7 },
	{ 0x4e79, 0xaab8 },
	{ 0x4e7a, 0xaab9 },
	{ 0x4e7b, 0xaaba },
	{ 0x4e7c, 0xaabb },
	{ 0x4e7d, 0xaabc },
	{ 0x4e7e, 0xaabd },
	{ 0x4f21, 0xaabe },
	{ 0x4f22, 0xaabf },
	{ 0x4f23, 0xaac0 },
	{ 0x4f24, 0xaac1 },
	{ 0x4f25, 0xaac2 },
	{ 0x4f26, 0xaac3 },
	{ 0x4f27, 0xaac4 },
	{ 0x4f28, 0xaac5 },
	{ 0x4f29, 0xaac6 },
	{ 0x4f2a, 0xaac7 },
	{ 0x4f2b, 0xaac8 },
	{ 0x4f2c, 0xaac9 },
	{ 0x4f2d, 0xaaca },
	{ 0x4f2e, 0xaacb },
	{ 0x4f2f, 0xaacc },
	{ 0x4f30, 0xaacd },
	{ 0x4f31, 0xaace },
	{ 0x4f32, 0xaacf },
	{ 0x4f33, 0xaad0 },
	{ 0x4f34, 0xaad1 },
	{ 0x4f35, 0xaad2 },
	{ 0x4f36, 0xaad3 },
	{ 0x4f37, 0xaad4 },
	{ 0x4f38, 0xaad5 },
	{ 0x4f39, 0xaad6 },
	{ 0x4f3a, 0xaad7 },
	{ 0x4f3b, 0xaad8 },
	{ 0x4f3c, 0xaad9 },
	{ 0x4f3d, 0xaada },
	{ 0x4f3e, 0xaadb },
	{ 0x4f3f, 0xaadc },
	{ 0x4f40, 0xaadd },
	{ 0x4f41, 0xaade },
	{ 0x4f42, 0xaadf },
	{ 0x4f43, 0xaae0 },
	{ 0x4f44, 0xaae1 },
	{ 0x4f45, 0xaae2 },
	{ 0x4f46, 0xaae3 },
	{ 0x4f47, 0xaae4 },
	{ 0x4f48, 0xaae5 },
	{ 0x4f49, 0xaae6 },
	{ 0x4f4a, 0xaae7 },
	{ 0x4f4b, 0xaae8 },
	{ 0x4f4c, 0xaae9 },
	{ 0x4f4d, 0xaaea },
	{ 0x4f4e, 0xaaeb },
	{ 0x4f4f, 0xaaec },
	{ 0x4f50, 0xaaed },
	{ 0x4f51, 0xaaee },
	{ 0x4f52, 0xaaef },
	{ 0x4f53, 0xaaf0 },
	{ 0x4f54, 0xaaf1 },
	{ 0x4f55, 0xaaf2 },
	{ 0x4f56, 0xaaf3 },
	{ 0x4f57, 0xaaf4 },
	{ 0x4f58, 0xaaf5 },
	{ 0x4f59, 0xaaf6 },
	{ 0x4f5a, 0xaaf7 },
	{ 0x4f5b, 0xaaf8 },
	{ 0x4f5c, 0xaaf9 },
	{ 0x4f5d, 0xaafa },
	{ 0x4f5e, 0xaafb },
	{ 0x4f5f, 0xaafc },
	{ 0x4f60, 0xaafd },
	{ 0x4f61, 0xaafe },
	{ 0x4f62, 0xab40 },
	{ 0x4f63, 0xab41 },
	{ 0x4f64, 0xab42 },
	{ 0x4f65, 0xab43 },
	{ 0x4f66, 0xab44 },
	{ 0x4f67, 0xab45 },
	{ 0x4f68, 0xab46 },
	{ 0x4f69, 0xab47 },
	{ 0x4f6a, 0xab48 },
	{ 0x4f6b, 0xab49 },
	{ 0x4f6c, 0xab4a },
	{ 0x4f6d, 0xab4b },
	{ 0x4f6e, 0xab4c },
	{ 0x4f6f, 0xab4d },
	{ 0x4f70, 0xab4e },
	{ 0x4f71, 0xab4f },
	{ 0x4f72, 0xab50 },
	{ 0x4f73, 0xab51 },
	{ 0x4f74, 0xab52 },
	{ 0x4f75, 0xab53 },
	{ 0x4f76, 0xab54 },
	{ 0x4f77, 0xab55 },
	{ 0x4f78, 0xab56 },
	{ 0x4f79, 0xab57 },
	{ 0x4f7a, 0xab58 },
	{ 0x4f7b, 0xab59 },
	{ 0x4f7c, 0xab5a },
	{ 0x4f7d, 0xab5b },
	{ 0x4f7e, 0xab5c },
	{ 0x5021, 0xab5d },
	{ 0x5022, 0xab5e },
	{ 0x5023, 0xab5f },
	{ 0x5024, 0xab60 },
	{ 0x5025, 0xab61 },
	{ 0x5026, 0xab62 },
	{ 0x5027, 0xab63 },
	{ 0x5028, 0xab64 },
	{ 0x5029, 0xab65 },
	{ 0x502a, 0xab66 },
	{ 0x502b, 0xab67 },
	{ 0x502c, 0xab68 },
	{ 0x502d, 0xab69 },
	{ 0x502e, 0xab6a },
	{ 0x502f, 0xab6b },
	{ 0x5030, 0xab6c },
	{ 0x5031, 0xab6d },
	{ 0x5032, 0xab6e },
	{ 0x5033, 0xab6f },
	{ 0x5034, 0xab70 },
	{ 0x5035, 0xab71 },
	{ 0x5036, 0xab72 },
	{ 0x5037, 0xab73 },
	{ 0x5038, 0xab74 },
	{ 0x5039, 0xab75 },
	{ 0x503a, 0xab76 },
	{ 0x503b, 0xab77 },
	{ 0x503c, 0xab78 },
	{ 0x503d, 0xab79 },
	{ 0x503e, 0xab7a },
	{ 0x503f, 0xab7b },
	{ 0x5040, 0xab7c },
	{ 0x5041, 0xab7d },
	{ 0x5042, 0xab7e },
	{ 0x5043, 0xaba1 },
	{ 0x5044, 0xaba2 },
	{ 0x5045, 0xaba3 },
	{ 0x5046, 0xaba4 },
	{ 0x5047, 0xaba5 },
	{ 0x5048, 0xaba6 },
	{ 0x5049, 0xaba7 },
	{ 0x504a, 0xaba8 },
	{ 0x504b, 0xaba9 },
	{ 0x504c, 0xabaa },
	{ 0x504d, 0xabab },
	{ 0x504e, 0xabac },
	{ 0x504f, 0xabad },
	{ 0x5050, 0xabae },
	{ 0x5051, 0xabaf },
	{ 0x5052, 0xabb0 },
	{ 0x5053, 0xabb1 },
	{ 0x5054, 0xabb2 },
	{ 0x5055, 0xabb3 },
	{ 0x5056, 0xabb4 },
	{ 0x5057, 0xabb5 },
	{ 0x5058, 0xabb6 },
	{ 0x5059, 0xabb7 },
	{ 0x505a, 0xabb8 },
	{ 0x505b, 0xabb9 },
	{ 0x505c, 0xabba },
	{ 0x505d, 0xabbb },
	{ 0x505e, 0xabbc },
	{ 0x505f, 0xabbd },
	{ 0x5060, 0xabbe },
	{ 0x5061, 0xabbf },
	{ 0x5062, 0xabc0 },
	{ 0x5063, 0xabc1 },
	{ 0x5064, 0xabc2 },
	{ 0x5065, 0xabc3 },
	{ 0x5066, 0xabc4 },
	{ 0x5067, 0xabc5 },
	{ 0x5068, 0xabc6 },
	{ 0x5069, 0xabc7 },
	{ 0x506a, 0xabc8 },
	{ 0x506b, 0xabc9 },
	{ 0x506c, 0xabca },
	{ 0x506d, 0xabcb },
	{ 0x506e, 0xabcc },
	{ 0x506f, 0xabcd },
	{ 0x5070, 0xabce },
	{ 0x5071, 0xabcf },
	{ 0x5072, 0xabd0 },
	{ 0x5073, 0xabd1 },
	{ 0x5074, 0xabd2 },
	{ 0x5075, 0xabd3 },
	{ 0x5076, 0xabd4 },
	{ 0x5077, 0xabd5 },
	{ 0x5078, 0xabd6 },
	{ 0x5079, 0xabd7 },
	{ 0x507a, 0xabd8 },
	{ 0x507b, 0xabd9 },
	{ 0x507c, 0xabda },
	{ 0x507d, 0xabdb },
	{ 0x507e, 0xabdc },
	{ 0x5121, 0xabdd },
	{ 0x5122, 0xabde },
	{ 0x5123, 0xabdf },
	{ 0x5124, 0xabe0 },
	{ 0x5125, 0xabe1 },
	{ 0x5126, 0xabe2 },
	{ 0x5127, 0xabe3 },
	{ 0x5128, 0xabe4 },
	{ 0x5129, 0xabe5 },
	{ 0x512a, 0xabe6 },
	{ 0x512b, 0xabe7 },
	{ 0x512c, 0xabe8 },
	{ 0x512d, 0xabe9 },
	{ 0x512e, 0xabea },
	{ 0x512f, 0xabeb },
	{ 0x5130, 0xabec },
	{ 0x5131, 0xabed },
	{ 0x5132, 0xabee },
	{ 0x5133, 0xabef },
	{ 0x5134, 0xabf0 },
	{ 0x5135, 0xabf1 },
	{ 0x5136, 0xabf2 },
	{ 0x5137, 0xabf3 },
	{ 0x5138, 0xabf4 },
	{ 0x5139, 0xabf5 },
	{ 0x513a, 0xabf6 },
	{ 0x513b, 0xabf7 },
	{ 0x513c, 0xabf8 },
	{ 0x513d, 0xabf9 },
	{ 0x513e, 0xabfa },
	{ 0x513f, 0xabfb },
	{ 0x5140, 0xabfc },
	{ 0x5141, 0xabfd },
	{ 0x5142, 0xabfe },
	{ 0x5143, 0xac40 },
	{ 0x5144, 0xac41 },
	{ 0x5145, 0xac42 },
	{ 0x5146, 0xac43 },
	{ 0x5147, 0xac44 },
	{ 0x5148, 0xac45 },
	{ 0x5149, 0xac46 },
	{ 0x514a, 0xac47 },
	{ 0x514b, 0xac48 },
	{ 0x514c, 0xac49 },
	{ 0x514d, 0xac4a },
	{ 0x514e, 0xac4b },
	{ 0x514f, 0xac4c },
	{ 0x5150, 0xac4d },
	{ 0x5151, 0xac4e },
	{ 0x5152, 0xac4f },
	{ 0x5153, 0xac50 },
	{ 0x5154, 0xac51 },
	{ 0x5155, 0xac52 },
	{ 0x5156, 0xac53 },
	{ 0x5157, 0xac54 },
	{ 0x5158, 0xac55 },
	{ 0x5159, 0xac56 },
	{ 0x515a, 0xac57 },
	{ 0x515b, 0xac58 },
	{ 0x515c, 0xac59 },
	{ 0x515d, 0xac5a },
	{ 0x515e, 0xac5b },
	{ 0x515f, 0xac5c },
	{ 0x5160, 0xac5d },
	{ 0x5161, 0xac5e },
	{ 0x5162, 0xac5f },
	{ 0x5163, 0xac60 },
	{ 0x5164, 0xac61 },
	{ 0x5165, 0xac62 },
	{ 0x5166, 0xac63 },
	{ 0x5167, 0xac64 },
	{ 0x5168, 0xac65 },
	{ 0x5169, 0xac66 },
	{ 0x516a, 0xac67 },
	{ 0x516b, 0xac68 },
	{ 0x516c, 0xac69 },
	{ 0x516d, 0xac6a },
	{ 0x516e, 0xac6b },
	{ 0x516f, 0xac6c },
	{ 0x5170, 0xac6d },
	{ 0x5171, 0xac6e },
	{ 0x5172, 0xac6f },
	{ 0x5173, 0xac70 },
	{ 0x5174, 0xac71 },
	{ 0x5175, 0xac72 },
	{ 0x5176, 0xac73 },
	{ 0x5177, 0xac74 },
	{ 0x5178, 0xac75 },
	{ 0x5179, 0xac76 },
	{ 0x517a, 0xac77 },
	{ 0x517b, 0xac78 },
	{ 0x517c, 0xac79 },
	{ 0x517d, 0xac7a },
	{ 0x517e, 0xac7b },
	{ 0x5221, 0xac7c },
	{ 0x5222, 0xac7d },
	{ 0x5223, 0xac7e },
	{ 0x5224, 0xaca1 },
	{ 0x5225, 0xaca2 },
	{ 0x5226, 0xaca3 },
	{ 0x5227, 0xaca4 },
	{ 0x5228, 0xaca5 },
	{ 0x5229, 0xaca6 },
	{ 0x522a, 0xaca7 },
	{ 0x522b, 0xaca8 },
	{ 0x522c, 0xaca9 },
	{ 0x522d, 0xacaa },
	{ 0x522e, 0xacab },
	{ 0x522f, 0xacac },
	{ 0x5230, 0xacad },
	{ 0x5231, 0xacae },
	{ 0x5232, 0xacaf },
	{ 0x5233, 0xacb0 },
	{ 0x5234, 0xacb1 },
	{ 0x5235, 0xacb2 },
	{ 0x5236, 0xacb3 },
	{ 0x5237, 0xacb4 },
	{ 0x5238, 0xacb5 },
	{ 0x5239, 0xacb6 },
	{ 0x523a, 0xacb7 },
	{ 0x523b, 0xacb8 },
	{ 0x523c, 0xacb9 },
	{ 0x523d, 0xacba },
	{ 0x523e, 0xacbb },
	{ 0x523f, 0xacbc },
	{ 0x5240, 0xacbd },
	{ 0x5241, 0xacbe },
	{ 0x5242, 0xacbf },
	{ 0x5243, 0xacc0 },
	{ 0x5244, 0xacc1 },
	{ 0x5245, 0xacc2 },
	{ 0x5246, 0xacc3 },
	{ 0x5247, 0xacc4 },
	{ 0x5248, 0xacc5 },
	{ 0x5249, 0xacc6 },
	{ 0x524a, 0xacc7 },
	{ 0x524b, 0xacc8 },
	{ 0x524c, 0xacc9 },
	{ 0x524d, 0xacca },
	{ 0x524e, 0xaccb },
	{ 0x524f, 0xaccc },
	{ 0x5250, 0xaccd },
	{ 0x5251, 0xacce },
	{ 0x5252, 0xaccf },
	{ 0x5253, 0xacd0 },
	{ 0x5254, 0xacd1 },
	{ 0x5255, 0xacd2 },
	{ 0x5256, 0xacd3 },
	{ 0x5257, 0xacd4 },
	{ 0x5258, 0xacd5 },
	{ 0x5259, 0xacd6 },
	{ 0x525a, 0xacd7 },
	{ 0x525b, 0xacd8 },
	{ 0x525c, 0xacd9 },
	{ 0x525d, 0xacda },
	{ 0x525e, 0xacdb },
	{ 0x525f, 0xacdc },
	{ 0x5260, 0xacdd },
	{ 0x5261, 0xacde },
	{ 0x5262, 0xacdf },
	{ 0x5263, 0xace0 },
	{ 0x5264, 0xace1 },
	{ 0x5265, 0xace2 },
	{ 0x5266, 0xace3 },
	{ 0x5267, 0xace4 },
	{ 0x5268, 0xace5 },
	{ 0x5269, 0xace6 },
	{ 0x526a, 0xace7 },
	{ 0x526b, 0xace8 },
	{ 0x526c, 0xace9 },
	{ 0x526d, 0xacea },
	{ 0x526e, 0xaceb },
	{ 0x526f, 0xacec },
	{ 0x5270, 0xaced },
	{ 0x5271, 0xacee },
	{ 0x5272, 0xacef },
	{ 0x5273, 0xacf0 },
	{ 0x5274, 0xacf1 },
	{ 0x5275, 0xacf2 },
	{ 0x5276, 0xacf3 },
	{ 0x5277, 0xacf4 },
	{ 0x5278, 0xacf5 },
	{ 0x5279, 0xacf6 },
	{ 0x527a, 0xacf7 },
	{ 0x527b, 0xacf8 },
	{ 0x527c, 0xacf9 },
	{ 0x527d, 0xacfa },
	{ 0x527e, 0xacfb },
	{ 0x5321, 0xacfc },
	{ 0x5322, 0xacfd },
	{ 0x5323, 0xad40 },
	{ 0x5324, 0xad41 },
	{ 0x5325, 0xad42 },
	{ 0x5326, 0xad43 },
	{ 0x5327, 0xad44 },
	{ 0x5328, 0xad45 },
	{ 0x5329, 0xad46 },
	{ 0x532a, 0xad47 },
	{ 0x532b, 0xad48 },
	{ 0x532c, 0xad49 },
	{ 0x532d, 0xad4a },
	{ 0x532e, 0xad4b },
	{ 0x532f, 0xad4c },
	{ 0x5330, 0xad4d },
	{ 0x5331, 0xad4e },
	{ 0x5332, 0xad4f },
	{ 0x5333, 0xad50 },
	{ 0x5334, 0xad51 },
	{ 0x5335, 0xad52 },
	{ 0x5336, 0xad53 },
	{ 0x5337, 0xad54 },
	{ 0x5338, 0xad55 },
	{ 0x5339, 0xad56 },
	{ 0x533a, 0xad57 },
	{ 0x533b, 0xad58 },
	{ 0x533c, 0xad59 },
	{ 0x533d, 0xad5a },
	{ 0x533e, 0xad5b },
	{ 0x533f, 0xad5c },
	{ 0x5340, 0xad5d },
	{ 0x5341, 0xad5e },
	{ 0x5342, 0xad5f },
	{ 0x5343, 0xad60 },
	{ 0x5344, 0xad61 },
	{ 0x5345, 0xad62 },
	{ 0x5346, 0xad63 },
	{ 0x5347, 0xad64 },
	{ 0x5348, 0xad65 },
	{ 0x5349, 0xad66 },
	{ 0x534a, 0xad67 },
	{ 0x534b, 0xad68 },
	{ 0x534c, 0xad69 },
	{ 0x534d, 0xad6a },
	{ 0x534e, 0xad6b },
	{ 0x534f, 0xad6c },
	{ 0x5350, 0xad6d },
	{ 0x5351, 0xad6e },
	{ 0x5352, 0xad6f },
	{ 0x5353, 0xad70 },
	{ 0x5354, 0xad71 },
	{ 0x5355, 0xad72 },
	{ 0x5356, 0xad73 },
	{ 0x5357, 0xad74 },
	{ 0x5358, 0xad75 },
	{ 0x5359, 0xad76 },
	{ 0x535a, 0xad77 },
	{ 0x535b, 0xad78 },
	{ 0x535c, 0xad79 },
	{ 0x535d, 0xad7a },
	{ 0x535e, 0xad7b },
	{ 0x535f, 0xad7c },
	{ 0x5360, 0xad7d },
	{ 0x5361, 0xad7e },
	{ 0x5362, 0xada1 },
	{ 0x5363, 0xada2 },
	{ 0x5364, 0xada3 },
	{ 0x5365, 0xada4 },
	{ 0x5366, 0xada5 },
	{ 0x5367, 0xada6 },
	{ 0x5368, 0xada7 },
	{ 0x5369, 0xada8 },
	{ 0x536a, 0xada9 },
	{ 0x536b, 0xadaa },
	{ 0x536c, 0xadab },
	{ 0x536d, 0xadac },
	{ 0x536e, 0xadad },
	{ 0x536f, 0xadae },
	{ 0x5370, 0xadaf },
	{ 0x5371, 0xadb0 },
	{ 0x5372, 0xadb1 },
	{ 0x5373, 0xadb2 },
	{ 0x5374, 0xadb3 },
	{ 0x5375, 0xadb4 },
	{ 0x5376, 0xadb5 },
	{ 0x5377, 0xadb6 },
	{ 0x5378, 0xadb7 },
	{ 0x5379, 0xadb8 },
	{ 0x537a, 0xadb9 },
	{ 0x537b, 0xadba },
	{ 0x537c, 0xadbb },
	{ 0x537d, 0xadbc },
	{ 0x537e, 0xadbd },
	{ 0x5421, 0xadbe },
	{ 0x5422, 0xadbf },
	{ 0x5423, 0xadc0 },
	{ 0x5424, 0xadc1 },
	{ 0x5425, 0xadc2 },
	{ 0x5426, 0xadc3 },
	{ 0x5427, 0xadc4 },
	{ 0x5428, 0xadc5 },
	{ 0x5429, 0xadc6 },
	{ 0x542a, 0xadc7 },
	{ 0x542b, 0xadc8 },
	{ 0x542c, 0xadc9 },
	{ 0x542d, 0xadca },
	{ 0x542e, 0xadcb },
	{ 0x542f, 0xadcc },
	{ 0x5430, 0xadcd },
	{ 0x5431, 0xadce },
	{ 0x5432, 0xadcf },
	{ 0x5433, 0xadd0 },
	{ 0x5434, 0xadd1 },
	{ 0x5435, 0xadd2 },
	{ 0x5436, 0xadd3 },
	{ 0x5437, 0xadd4 },
	{ 0x5438, 0xadd5 },
	{ 0x5439, 0xadd6 },
	{ 0x543a, 0xadd7 },
	{ 0x543b, 0xadd8 },
	{ 0x543c, 0xadd9 },
	{ 0x543d, 0xadda },
	{ 0x543e, 0xaddb },
	{ 0x543f, 0xaddc },
	{ 0x5440, 0xaddd },
	{ 0x5441, 0xadde },
	{ 0x5442, 0xaddf },
	{ 0x5443, 0xade0 },
	{ 0x5444, 0xade1 },
	{ 0x5445, 0xade2 },
	{ 0x5446, 0xade3 },
	{ 0x5447, 0xade4 },
	{ 0x5448, 0xade5 },
	{ 0x5449, 0xade6 },
	{ 0x544a, 0xade7 },
	{ 0x544b, 0xade8 },
	{ 0x544c, 0xade9 },
	{ 0x544d, 0xadea },
	{ 0x544e, 0xadeb },
	{ 0x544f, 0xadec },
	{ 0x5450, 0xaded },
	{ 0x5451, 0xadee },
	{ 0x5452, 0xadef },
	{ 0x5453, 0xadf0 },
	{ 0x5454, 0xadf1 },
	{ 0x5455, 0xadf2 },
	{ 0x5456, 0xadf3 },
	{ 0x5457, 0xadf4 },
	{ 0x5458, 0xadf5 },
	{ 0x5459, 0xadf6 },
	{ 0x545a, 0xadf7 },
	{ 0x545b, 0xadf8 },
	{ 0x545c, 0xadf9 },
	{ 0x545d, 0xadfa },
	{ 0x545e, 0xadfb },
	{ 0x545f, 0xadfc },
	{ 0x5460, 0xadfd },
	{ 0x5461, 0xadfe },
	{ 0x5462, 0xae40 },
	{ 0x5463, 0xae41 },
	{ 0x5464, 0xae42 },
	{ 0x5465, 0xae43 },
	{ 0x5466, 0xae44 },
	{ 0x5467, 0xae45 },
	{ 0x5468, 0xae46 },
	{ 0x5469, 0xae47 },
	{ 0x546a, 0xae48 },
	{ 0x546b, 0xae49 },
	{ 0x546c, 0xae4a },
	{ 0x546d, 0xae4b },
	{ 0x546e, 0xae4c },
	{ 0x546f, 0xae4d },
	{ 0x5470, 0xae4e },
	{ 0x5471, 0xae4f },
	{ 0x5472, 0xae50 },
	{ 0x5473, 0xae51 },
	{ 0x5474, 0xae52 },
	{ 0x5475, 0xae53 },
	{ 0x5476, 0xae54 },
	{ 0x5477, 0xae55 },
	{ 0x5478, 0xae56 },
	{ 0x5479, 0xae57 },
	{ 0x547a, 0xae58 },
	{ 0x547b, 0xae59 },
	{ 0x547c, 0xae5a },
	{ 0x547d, 0xae5b },
	{ 0x547e, 0xae5c },
	{ 0x5521, 0xae5d },
	{ 0x5522, 0xae5e },
	{ 0x5523, 0xae5f },
	{ 0x5524, 0xae60 },
	{ 0x5525, 0xae61 },
	{ 0x5526, 0xae62 },
	{ 0x5527, 0xae63 },
	{ 0x5528, 0xae64 },
	{ 0x5529, 0xae65 },
	{ 0x552a, 0xae66 },
	{ 0x552b, 0xae67 },
	{ 0x552c, 0xae68 },
	{ 0x552d, 0xae69 },
	{ 0x552e, 0xae6a },
	{ 0x552f, 0xae6b },
	{ 0x5530, 0xae6c },
	{ 0x5531, 0xae6d },
	{ 0x5532, 0xae6e },
	{ 0x5533, 0xae6f },
	{ 0x5534, 0xae70 },
	{ 0x5535, 0xae71 },
	{ 0x5536, 0xae72 },
	{ 0x5537, 0xae73 },
	{ 0x5538, 0xae74 },
	{ 0x5539, 0xae75 },
	{ 0x553a, 0xae76 },
	{ 0x553b, 0xae77 },
	{ 0x553c, 0xae78 },
	{ 0x553d, 0xae79 },
	{ 0x553e, 0xae7a },
	{ 0x553f, 0xae7b },
	{ 0x5540, 0xae7c },
	{ 0x5541, 0xae7d },
	{ 0x5542, 0xae7e },
	{ 0x5543, 0xaea1 },
	{ 0x5544, 0xaea2 },
	{ 0x5545, 0xaea3 },
	{ 0x5546, 0xaea4 },
	{ 0x5547, 0xaea5 },
	{ 0x5548, 0xaea6 },
	{ 0x5549, 0xaea7 },
	{ 0x554a, 0xaea8 },
	{ 0x554b, 0xaea9 },
	{ 0x554c, 0xaeaa },
	{ 0x554d, 0xaeab },
	{ 0x554e, 0xaeac },
	{ 0x554f, 0xaead },
	{ 0x5550, 0xaeae },
	{ 0x5551, 0xaeaf },
	{ 0x5552, 0xaeb0 },
	{ 0x5553, 0xaeb1 },
	{ 0x5554, 0xaeb2 },
	{ 0x5555, 0xaeb3 },
	{ 0x5556, 0xaeb4 },
	{ 0x5557, 0xaeb5 },
	{ 0x5558, 0xaeb6 },
	{ 0x5559, 0xaeb7 },
	{ 0x555a, 0xaeb8 },
	{ 0x555b, 0xaeb9 },
	{ 0x555c, 0xaeba },
	{ 0x555d, 0xaebb },
	{ 0x555e, 0xaebc },
	{ 0x555f, 0xaebd },
	{ 0x5560, 0xaebe },
	{ 0x5561, 0xaebf },
	{ 0x5562, 0xaec0 },
	{ 0x5563, 0xaec1 },
	{ 0x5564, 0xaec2 },
	{ 0x5565, 0xaec3 },
	{ 0x5566, 0xaec4 },
	{ 0x5567, 0xaec5 },
	{ 0x5568, 0xaec6 },
	{ 0x5569, 0xaec7 },
	{ 0x556a, 0xaec8 },
	{ 0x556b, 0xaec9 },
	{ 0x556c, 0xaeca },
	{ 0x556d, 0xaecb },
	{ 0x556e, 0xaecc },
	{ 0x556f, 0xaecd },
	{ 0x5570, 0xaece },
	{ 0x5571, 0xaecf },
	{ 0x5572, 0xaed0 },
	{ 0x5573, 0xaed1 },
	{ 0x5574, 0xaed2 },
	{ 0x5575, 0xaed3 },
	{ 0x5576, 0xaed4 },
	{ 0x5577, 0xaed5 },
	{ 0x5578, 0xaed6 },
	{ 0x5579, 0xaed7 },
	{ 0x557a, 0xaed8 },
	{ 0x557b, 0xaed9 },
	{ 0x557c, 0xaeda },
	{ 0x557d, 0xaedb },
	{ 0x557e, 0xaedc },
	{ 0x5621, 0xaedd },
	{ 0x5622, 0xaede },
	{ 0x5623, 0xaedf },
	{ 0x5624, 0xaee0 },
	{ 0x5625, 0xaee1 },
	{ 0x5626, 0xaee2 },
	{ 0x5627, 0xaee3 },
	{ 0x5628, 0xaee4 },
	{ 0x5629, 0xaee5 },
	{ 0x562a, 0xaee6 },
	{ 0x562b, 0xaee7 },
	{ 0x562c, 0xaee8 },
	{ 0x562d, 0xaee9 },
	{ 0x562e, 0xaeea },
	{ 0x562f, 0xaeeb },
	{ 0x5630, 0xaeec },
	{ 0x5631, 0xaeed },
	{ 0x5632, 0xaeee },
	{ 0x5633, 0xaeef },
	{ 0x5634, 0xaef0 },
	{ 0x5635, 0xaef1 },
	{ 0x5636, 0xaef2 },
	{ 0x5637, 0xaef3 },
	{ 0x5638, 0xaef4 },
	{ 0x5639, 0xaef5 },
	{ 0x563a, 0xaef6 },
	{ 0x563b, 0xaef7 },
	{ 0x563c, 0xaef8 },
	{ 0x563d, 0xaef9 },
	{ 0x563e, 0xaefa },
	{ 0x563f, 0xaefb },
	{ 0x5640, 0xaefc },
	{ 0x5641, 0xaefd },
	{ 0x5642, 0xaefe },
	{ 0x5643, 0xaf40 },
	{ 0x5644, 0xaf41 },
	{ 0x5645, 0xaf42 },
	{ 0x5646, 0xaf43 },
	{ 0x5647, 0xaf44 },
	{ 0x5648, 0xaf45 },
	{ 0x5649, 0xaf46 },
	{ 0x564a, 0xaf47 },
	{ 0x564b, 0xaf48 },
	{ 0x564c, 0xaf49 },
	{ 0x564d, 0xaf4a },
	{ 0x564e, 0xaf4b },
	{ 0x564f, 0xaf4c },
	{ 0x5650, 0xaf4d },
	{ 0x5651, 0xaf4e },
	{ 0x5652, 0xaf4f },
	{ 0x5653, 0xaf50 },
	{ 0x5654, 0xaf51 },
	{ 0x5655, 0xaf52 },
	{ 0x5656, 0xaf53 },
	{ 0x5657, 0xaf54 },
	{ 0x5658, 0xaf55 },
	{ 0x5659, 0xaf56 },
	{ 0x565a, 0xaf57 },
	{ 0x565b, 0xaf58 },
	{ 0x565c, 0xaf59 },
	{ 0x565d, 0xaf5a },
	{ 0x565e, 0xaf5b },
	{ 0x565f, 0xaf5c },
	{ 0x5660, 0xaf5d },
	{ 0x5661, 0xaf5e },
	{ 0x5662, 0xaf5f },
	{ 0x5663, 0xaf60 },
	{ 0x5664, 0xaf61 },
	{ 0x5665, 0xaf62 },
	{ 0x5666, 0xaf63 },
	{ 0x5667, 0xaf64 },
	{ 0x5668, 0xaf65 },
	{ 0x5669, 0xaf66 },
	{ 0x566a, 0xaf67 },
	{ 0x566b, 0xaf68 },
	{ 0x566c, 0xaf69 },
	{ 0x566d, 0xaf6a },
	{ 0x566e, 0xaf6b },
	{ 0x566f, 0xaf6c },
	{ 0x5670, 0xaf6d },
	{ 0x5671, 0xaf6e },
	{ 0x5672, 0xaf6f },
	{ 0x5673, 0xaf70 },
	{ 0x5674, 0xaf71 },
	{ 0x5675, 0xaf72 },
	{ 0x5676, 0xaf73 },
	{ 0x5677, 0xaf74 },
	{ 0x5678, 0xaf75 },
	{ 0x5679, 0xaf76 },
	{ 0x567a, 0xaf77 },
	{ 0x567b, 0xaf78 },
	{ 0x567c, 0xaf79 },
	{ 0x567d, 0xaf7a },
	{ 0x567e, 0xaf7b },
	{ 0x5721, 0xaf7c },
	{ 0x5722, 0xaf7d },
	{ 0x5723, 0xaf7e },
	{ 0x5724, 0xafa1 },
	{ 0x5725, 0xafa2 },
	{ 0x5726, 0xafa3 },
	{ 0x5727, 0xafa4 },
	{ 0x5728, 0xafa5 },
	{ 0x5729, 0xafa6 },
	{ 0x572a, 0xafa7 },
	{ 0x572b, 0xafa8 },
	{ 0x572c, 0xafa9 },
	{ 0x572d, 0xafaa },
	{ 0x572e, 0xafab },
	{ 0x572f, 0xafac },
	{ 0x5730, 0xafad },
	{ 0x5731, 0xafae },
	{ 0x5732, 0xafaf },
	{ 0x5733, 0xafb0 },
	{ 0x5734, 0xafb1 },
	{ 0x5735, 0xafb2 },
	{ 0x5736, 0xafb3 },
	{ 0x5737, 0xafb4 },
	{ 0x5738, 0xafb5 },
	{ 0x5739, 0xafb6 },
	{ 0x573a, 0xafb7 },
	{ 0x573b, 0xafb8 },
	{ 0x573c, 0xafb9 },
	{ 0x573d, 0xafba },
	{ 0x573e, 0xafbb },
	{ 0x573f, 0xafbc },
	{ 0x5740, 0xafbd },
	{ 0x5741, 0xafbe },
	{ 0x5742, 0xafbf },
	{ 0x5743, 0xafc0 },
	{ 0x5744, 0xafc1 },
	{ 0x5745, 0xafc2 },
	{ 0x5746, 0xafc3 },
	{ 0x5747, 0xafc4 },
	{ 0x5748, 0xafc5 },
	{ 0x5749, 0xafc6 },
	{ 0x574a, 0xafc7 },
	{ 0x574b, 0xafc8 },
	{ 0x574c, 0xafc9 },
	{ 0x574d, 0xafca },
	{ 0x574e, 0xafcb },
	{ 0x574f, 0xafcc },
	{ 0x5750, 0xafcd },
	{ 0x5751, 0xafce },
	{ 0x5752, 0xafcf },
	{ 0x5753, 0xacfe },
	{ 0x5754, 0xafd0 },
	{ 0x5755, 0xafd1 },
	{ 0x5756, 0xafd2 },
	{ 0x5757, 0xafd3 },
	{ 0x5758, 0xafd4 },
	{ 0x5759, 0xafd5 },
	{ 0x575a, 0xafd6 },
	{ 0x575b, 0xafd7 },
	{ 0x575c, 0xafd8 },
	{ 0x575d, 0xafd9 },
	{ 0x575e, 0xafda },
	{ 0x575f, 0xafdb },
	{ 0x5760, 0xafdc },
	{ 0x5761, 0xafdd },
	{ 0x5762, 0xafde },
	{ 0x5763, 0xafdf },
	{ 0x5764, 0xafe0 },
	{ 0x5765, 0xafe1 },
	{ 0x5766, 0xafe2 },
	{ 0x5767, 0xafe3 },
	{ 0x5768, 0xafe4 },
	{ 0x5769, 0xafe5 },
	{ 0x576a, 0xafe6 },
	{ 0x576b, 0xafe7 },
	{ 0x576c, 0xafe8 },
	{ 0x576d, 0xafe9 },
	{ 0x576e, 0xafea },
	{ 0x576f, 0xafeb },
	{ 0x5770, 0xafec },
	{ 0x5771, 0xafed },
	{ 0x5772, 0xafee },
	{ 0x5773, 0xafef },
	{ 0x5774, 0xaff0 },
	{ 0x5775, 0xaff1 },
	{ 0x5776, 0xaff2 },
	{ 0x5777, 0xaff3 },
	{ 0x5778, 0xaff4 },
	{ 0x5779, 0xaff5 },
	{ 0x577a, 0xaff6 },
	{ 0x577b, 0xaff7 },
	{ 0x577c, 0xaff8 },
	{ 0x577d, 0xaff9 },
	{ 0x577e, 0xaffa },
	{ 0x5821, 0xaffb },
	{ 0x5822, 0xaffc },
	{ 0x5823, 0xaffd },
	{ 0x5824, 0xaffe },
	{ 0x5825, 0xb040 },
	{ 0x5826, 0xb041 },
	{ 0x5827, 0xb042 },
	{ 0x5828, 0xb043 },
	{ 0x5829, 0xb044 },
	{ 0x582a, 0xb045 },
	{ 0x582b, 0xb046 },
	{ 0x582c, 0xb047 },
	{ 0x582d, 0xb048 },
	{ 0x582e, 0xb049 },
	{ 0x582f, 0xb04a },
	{ 0x5830, 0xb04b },
	{ 0x5831, 0xb04c },
	{ 0x5832, 0xb04d },
	{ 0x5833, 0xb04e },
	{ 0x5834, 0xb04f },
	{ 0x5835, 0xb050 },
	{ 0x5836, 0xb051 },
	{ 0x5837, 0xb052 },
	{ 0x5838, 0xb053 },
	{ 0x5839, 0xb054 },
	{ 0x583a, 0xb055 },
	{ 0x583b, 0xb056 },
	{ 0x583c, 0xb057 },
	{ 0x583d, 0xb058 },
	{ 0x583e, 0xb059 },
	{ 0x583f, 0xb05a },
	{ 0x5840, 0xb05b },
	{ 0x5841, 0xb05c },
	{ 0x5842, 0xb05d },
	{ 0x5843, 0xb05e },
	{ 0x5844, 0xb05f },
	{ 0x5845, 0xb060 },
	{ 0x5846, 0xb061 },
	{ 0x5847, 0xb062 },
	{ 0x5848, 0xb063 },
	{ 0x5849, 0xb064 },
	{ 0x584a, 0xb065 },
	{ 0x584b, 0xb066 },
	{ 0x584c, 0xb067 },
	{ 0x584d, 0xb068 },
	{ 0x584e, 0xb069 },
	{ 0x584f, 0xb06a },
	{ 0x5850, 0xb06b },
	{ 0x5851, 0xb06c },
	{ 0x5852, 0xb06d },
	{ 0x5853, 0xb06e },
	{ 0x5854, 0xb06f },
	{ 0x5855, 0xb070 },
	{ 0x5856, 0xb071 },
	{ 0x5857, 0xb072 },
	{ 0x5858, 0xb073 },
	{ 0x5859, 0xb074 },
	{ 0x585a, 0xb075 },
	{ 0x585b, 0xb076 },
	{ 0x585c, 0xb077 },
	{ 0x585d, 0xb078 },
	{ 0x585e, 0xb079 },
	{ 0x585f, 0xb07a },
	{ 0x5860, 0xb07b },
	{ 0x5861, 0xb07c },
	{ 0x5862, 0xb07d },
	{ 0x5863, 0xb07e },
	{ 0x5864, 0xb0a1 },
	{ 0x5865, 0xb0a2 },
	{ 0x5866, 0xb0a3 },
	{ 0x5867, 0xb0a4 },
	{ 0x5868, 0xb0a5 },
	{ 0x5869, 0xb0a6 },
	{ 0x586a, 0xb0a7 },
	{ 0x586b, 0xb0a8 },
	{ 0x586c, 0xb0a9 },
	{ 0x586d, 0xb0aa },
	{ 0x586e, 0xb0ab },
	{ 0x586f, 0xb0ac },
	{ 0x5870, 0xb0ad },
	{ 0x5871, 0xb0ae },
	{ 0x5872, 0xb0af },
	{ 0x5873, 0xb0b0 },
	{ 0x5874, 0xb0b1 },
	{ 0x5875, 0xb0b2 },
	{ 0x5876, 0xb0b3 },
	{ 0x5877, 0xb0b4 },
	{ 0x5878, 0xb0b5 },
	{ 0x5879, 0xb0b6 },
	{ 0x587a, 0xb0b7 },
	{ 0x587b, 0xb0b8 },
	{ 0x587c, 0xb0b9 },
	{ 0x587d, 0xb0ba },
	{ 0x587e, 0xb0bb },
	{ 0x5921, 0xb0bc },
	{ 0x5922, 0xb0bd },
	{ 0x5923, 0xb0be },
	{ 0x5924, 0xb0bf },
	{ 0x5925, 0xb0c0 },
	{ 0x5926, 0xb0c1 },
	{ 0x5927, 0xb0c2 },
	{ 0x5928, 0xb0c3 },
	{ 0x5929, 0xb0c4 },
	{ 0x592a, 0xb0c5 },
	{ 0x592b, 0xb0c6 },
	{ 0x592c, 0xb0c7 },
	{ 0x592d, 0xb0c8 },
	{ 0x592e, 0xb0c9 },
	{ 0x592f, 0xb0ca },
	{ 0x5930, 0xb0cb },
	{ 0x5931, 0xb0cc },
	{ 0x5932, 0xb0cd },
	{ 0x5933, 0xb0ce },
	{ 0x5934, 0xb0cf },
	{ 0x5935, 0xb0d0 },
	{ 0x5936, 0xb0d1 },
	{ 0x5937, 0xb0d2 },
	{ 0x5938, 0xb0d3 },
	{ 0x5939, 0xb0d4 },
	{ 0x593a, 0xb0d5 },
	{ 0x593b, 0xb0d6 },
	{ 0x593c, 0xb0d7 },
	{ 0x593d, 0xb0d8 },
	{ 0x593e, 0xb0d9 },
	{ 0x593f, 0xb0da },
	{ 0x5940, 0xb0db },
	{ 0x5941, 0xb0dc },
	{ 0x5942, 0xb0dd },
	{ 0x5943, 0xb0de },
	{ 0x5944, 0xb0df },
	{ 0x5945, 0xb0e0 },
	{ 0x5946, 0xb0e1 },
	{ 0x5947, 0xb0e2 },
	{ 0x5948, 0xb0e3 },
	{ 0x5949, 0xb0e4 },
	{ 0x594a, 0xb0e5 },
	{ 0x594b, 0xb0e6 },
	{ 0x594c, 0xb0e7 },
	{ 0x594d, 0xb0e8 },
	{ 0x594e, 0xb0e9 },
	{ 0x594f, 0xb0ea },
	{ 0x5950, 0xb0eb },
	{ 0x5951, 0xb0ec },
	{ 0x5952, 0xb0ed },
	{ 0x5953, 0xb0ee },
	{ 0x5954, 0xb0ef },
	{ 0x5955, 0xb0f0 },
	{ 0x5956, 0xb0f1 },
	{ 0x5957, 0xb0f2 },
	{ 0x5958, 0xb0f3 },
	{ 0x5959, 0xb0f4 },
	{ 0x595a, 0xb0f5 },
	{ 0x595b, 0xb0f6 },
	{ 0x595c, 0xb0f7 },
	{ 0x595d, 0xb0f8 },
	{ 0x595e, 0xb0f9 },
	{ 0x595f, 0xb0fa },
	{ 0x5960, 0xb0fb },
	{ 0x5961, 0xb0fc },
	{ 0x5962, 0xb0fd },
	{ 0x5963, 0xb0fe },
	{ 0x5964, 0xb140 },
	{ 0x5965, 0xb141 },
	{ 0x5966, 0xb142 },
	{ 0x5967, 0xb143 },
	{ 0x5968, 0xb144 },
	{ 0x5969, 0xb145 },
	{ 0x596a, 0xb146 },
	{ 0x596b, 0xb147 },
	{ 0x596c, 0xb148 },
	{ 0x596d, 0xb149 },
	{ 0x596e, 0xb14a },
	{ 0x596f, 0xb14b },
	{ 0x5970, 0xb14c },
	{ 0x5971, 0xb14d },
	{ 0x5972, 0xb14e },
	{ 0x5973, 0xb14f },
	{ 0x5974, 0xb150 },
	{ 0x5975, 0xb151 },
	{ 0x5976, 0xb152 },
	{ 0x5977, 0xb153 },
	{ 0x5978, 0xb154 },
	{ 0x5979, 0xb155 },
	{ 0x597a, 0xb156 },
	{ 0x597b, 0xb157 },
	{ 0x597c, 0xb158 },
	{ 0x597d, 0xb159 },
	{ 0x597e, 0xb15a },
	{ 0x5a21, 0xb15b },
	{ 0x5a22, 0xb15c },
	{ 0x5a23, 0xb15d },
	{ 0x5a24, 0xb15e },
	{ 0x5a25, 0xb15f },
	{ 0x5a26, 0xb160 },
	{ 0x5a27, 0xb161 },
	{ 0x5a28, 0xb162 },
	{ 0x5a29, 0xb163 },
	{ 0x5a2a, 0xb164 },
	{ 0x5a2b, 0xb165 },
	{ 0x5a2c, 0xb166 },
	{ 0x5a2d, 0xb167 },
	{ 0x5a2e, 0xb168 },
	{ 0x5a2f, 0xb169 },
	{ 0x5a30, 0xb16a },
	{ 0x5a31, 0xb16b },
	{ 0x5a32, 0xb16c },
	{ 0x5a33, 0xb16d },
	{ 0x5a34, 0xb16e },
	{ 0x5a35, 0xb16f },
	{ 0x5a36, 0xb170 },
	{ 0x5a37, 0xb171 },
	{ 0x5a38, 0xb172 },
	{ 0x5a39, 0xb173 },
	{ 0x5a3a, 0xb174 },
	{ 0x5a3b, 0xb175 },
	{ 0x5a3c, 0xb176 },
	{ 0x5a3d, 0xb177 },
	{ 0x5a3e, 0xb178 },
	{ 0x5a3f, 0xb179 },
	{ 0x5a40, 0xb17a },
	{ 0x5a41, 0xb17b },
	{ 0x5a42, 0xb17c },
	{ 0x5a43, 0xb17d },
	{ 0x5a44, 0xb17e },
	{ 0x5a45, 0xb1a1 },
	{ 0x5a46, 0xb1a2 },
	{ 0x5a47, 0xb1a3 },
	{ 0x5a48, 0xb1a4 },
	{ 0x5a49, 0xb1a5 },
	{ 0x5a4a, 0xb1a6 },
	{ 0x5a4b, 0xb1a7 },
	{ 0x5a4c, 0xb1a8 },
	{ 0x5a4d, 0xb1a9 },
	{ 0x5a4e, 0xb1aa },
	{ 0x5a4f, 0xb1ab },
	{ 0x5a50, 0xb1ac },
	{ 0x5a51, 0xb1ad },
	{ 0x5a52, 0xb1ae },
	{ 0x5a53, 0xb1af },
	{ 0x5a54, 0xb1b0 },
	{ 0x5a55, 0xb1b1 },
	{ 0x5a56, 0xb1b2 },
	{ 0x5a57, 0xb1b3 },
	{ 0x5a58, 0xb1b4 },
	{ 0x5a59, 0xb1b5 },
	{ 0x5a5a, 0xb1b6 },
	{ 0x5a5b, 0xb1b7 },
	{ 0x5a5c, 0xb1b8 },
	{ 0x5a5d, 0xb1b9 },
	{ 0x5a5e, 0xb1ba },
	{ 0x5a5f, 0xb1bb },
	{ 0x5a60, 0xb1bc },
	{ 0x5a61, 0xb1bd },
	{ 0x5a62, 0xb1be },
	{ 0x5a63, 0xb1bf },
	{ 0x5a64, 0xb1c0 },
	{ 0x5a65, 0xb1c1 },
	{ 0x5a66, 0xb1c2 },
	{ 0x5a67, 0xb1c3 },
	{ 0x5a68, 0xb1c4 },
	{ 0x5a69, 0xb1c5 },
	{ 0x5a6a, 0xb1c6 },
	{ 0x5a6b, 0xb1c7 },
	{ 0x5a6c, 0xb1c8 },
	{ 0x5a6d, 0xb1c9 },
	{ 0x5a6e, 0xb1ca },
	{ 0x5a6f, 0xb1cb },
	{ 0x5a70, 0xb1cc },
	{ 0x5a71, 0xb1cd },
	{ 0x5a72, 0xb1ce },
	{ 0x5a73, 0xb1cf },
	{ 0x5a74, 0xb1d0 },
	{ 0x5a75, 0xb1d1 },
	{ 0x5a76, 0xb1d2 },
	{ 0x5a77, 0xb1d3 },
	{ 0x5a78, 0xb1d4 },
	{ 0x5a79, 0xb1d5 },
	{ 0x5a7a, 0xb1d6 },
	{ 0x5a7b, 0xb1d7 },
	{ 0x5a7c, 0xb1d8 },
	{ 0x5a7d, 0xb1d9 },
	{ 0x5a7e, 0xb1da },
	{ 0x5b21, 0xb1db },
	{ 0x5b22, 0xb1dc },
	{ 0x5b23, 0xb1dd },
	{ 0x5b24, 0xb1de },
	{ 0x5b25, 0xb1df },
	{ 0x5b26, 0xb1e0 },
	{ 0x5b27, 0xb1e1 },
	{ 0x5b28, 0xb1e2 },
	{ 0x5b29, 0xb1e3 },
	{ 0x5b2a, 0xb1e4 },
	{ 0x5b2b, 0xb1e5 },
	{ 0x5b2c, 0xb1e6 },
	{ 0x5b2d, 0xb1e7 },
	{ 0x5b2e, 0xb1e8 },
	{ 0x5b2f, 0xb1e9 },
	{ 0x5b30, 0xb1ea },
	{ 0x5b31, 0xb1eb },
	{ 0x5b32, 0xb1ec },
	{ 0x5b33, 0xb1ed },
	{ 0x5b34, 0xb1ee },
	{ 0x5b35, 0xb1ef },
	{ 0x5b36, 0xb1f0 },
	{ 0x5b37, 0xb1f1 },
	{ 0x5b38, 0xb1f2 },
	{ 0x5b39, 0xb1f3 },
	{ 0x5b3a, 0xb1f4 },
	{ 0x5b3b, 0xb1f5 },
	{ 0x5b3c, 0xb1f6 },
	{ 0x5b3d, 0xb1f7 },
	{ 0x5b3e, 0xb1f8 },
	{ 0x5b3f, 0xb1f9 },
	{ 0x5b40, 0xb1fa },
	{ 0x5b41, 0xb1fb },
	{ 0x5b42, 0xb1fc },
	{ 0x5b43, 0xb1fd },
	{ 0x5b44, 0xb1fe },
	{ 0x5b45, 0xb240 },
	{ 0x5b46, 0xb241 },
	{ 0x5b47, 0xb242 },
	{ 0x5b48, 0xb243 },
	{ 0x5b49, 0xb244 },
	{ 0x5b4a, 0xb245 },
	{ 0x5b4b, 0xb246 },
	{ 0x5b4c, 0xb247 },
	{ 0x5b4d, 0xb248 },
	{ 0x5b4e, 0xb249 },
	{ 0x5b4f, 0xb24a },
	{ 0x5b50, 0xb24b },
	{ 0x5b51, 0xb24c },
	{ 0x5b52, 0xb24d },
	{ 0x5b53, 0xb24e },
	{ 0x5b54, 0xb24f },
	{ 0x5b55, 0xb250 },
	{ 0x5b56, 0xb251 },
	{ 0x5b57, 0xb252 },
	{ 0x5b58, 0xb253 },
	{ 0x5b59, 0xb254 },
	{ 0x5b5a, 0xb255 },
	{ 0x5b5b, 0xb256 },
	{ 0x5b5c, 0xb257 },
	{ 0x5b5d, 0xb258 },
	{ 0x5b5e, 0xb259 },
	{ 0x5b5f, 0xb25a },
	{ 0x5b60, 0xb25b },
	{ 0x5b61, 0xb25c },
	{ 0x5b62, 0xb25d },
	{ 0x5b63, 0xb25e },
	{ 0x5b64, 0xb25f },
	{ 0x5b65, 0xb260 },
	{ 0x5b66, 0xb261 },
	{ 0x5b67, 0xb262 },
	{ 0x5b68, 0xb263 },
	{ 0x5b69, 0xb264 },
	{ 0x5b6a, 0xb265 },
	{ 0x5b6b, 0xb266 },
	{ 0x5b6c, 0xb267 },
	{ 0x5b6d, 0xb268 },
	{ 0x5b6e, 0xb269 },
	{ 0x5b6f, 0xb26a },
	{ 0x5b70, 0xb26b },
	{ 0x5b71, 0xb26c },
	{ 0x5b72, 0xb26d },
	{ 0x5b73, 0xb26e },
	{ 0x5b74, 0xb26f },
	{ 0x5b75, 0xb270 },
	{ 0x5b76, 0xb271 },
	{ 0x5b77, 0xb272 },
	{ 0x5b78, 0xb273 },
	{ 0x5b79, 0xb274 },
	{ 0x5b7a, 0xb275 },
	{ 0x5b7b, 0xb276 },
	{ 0x5b7c, 0xb277 },
	{ 0x5b7d, 0xb278 },
	{ 0x5b7e, 0xb279 },
	{ 0x5c21, 0xb27a },
	{ 0x5c22, 0xb27b },
	{ 0x5c23, 0xb27c },
	{ 0x5c24, 0xb27d },
	{ 0x5c25, 0xb27e },
	{ 0x5c26, 0xb2a1 },
	{ 0x5c27, 0xb2a2 },
	{ 0x5c28, 0xb2a3 },
	{ 0x5c29, 0xb2a4 },
	{ 0x5c2a, 0xb2a5 },
	{ 0x5c2b, 0xb2a6 },
	{ 0x5c2c, 0xb2a7 },
	{ 0x5c2d, 0xb2a8 },
	{ 0x5c2e, 0xb2a9 },
	{ 0x5c2f, 0xb2aa },
	{ 0x5c30, 0xb2ab },
	{ 0x5c31, 0xb2ac },
	{ 0x5c32, 0xb2ad },
	{ 0x5c33, 0xb2ae },
	{ 0x5c34, 0xb2af },
	{ 0x5c35, 0xb2b0 },
	{ 0x5c36, 0xb2b1 },
	{ 0x5c37, 0xb2b2 },
	{ 0x5c38, 0xb2b3 },
	{ 0x5c39, 0xb2b4 },
	{ 0x5c3a, 0xb2b5 },
	{ 0x5c3b, 0xb2b6 },
	{ 0x5c3c, 0xb2b7 },
	{ 0x5c3d, 0xb2b8 },
	{ 0x5c3e, 0xb2b9 },
	{ 0x5c3f, 0xb2ba },
	{ 0x5c40, 0xb2bb },
	{ 0x5c41, 0xb2bc },
	{ 0x5c42, 0xb2bd },
	{ 0x5c43, 0xb2be },
	{ 0x5c44, 0xb2bf },
	{ 0x5c45, 0xb2c0 },
	{ 0x5c46, 0xb2c1 },
	{ 0x5c47, 0xb2c2 },
	{ 0x5c48, 0xb2c3 },
	{ 0x5c49, 0xb2c4 },
	{ 0x5c4a, 0xb2c5 },
	{ 0x5c4b, 0xb2c6 },
	{ 0x5c4c, 0xb2c7 },
	{ 0x5c4d, 0xb2c8 },
	{ 0x5c4e, 0xb2c9 },
	{ 0x5c4f, 0xb2ca },
	{ 0x5c50, 0xb2cb },
	{ 0x5c51, 0xb2cc },
	{ 0x5c52, 0xb2cd },
	{ 0x5c53, 0xb2ce },
	{ 0x5c54, 0xb2cf },
	{ 0x5c55, 0xb2d0 },
	{ 0x5c56, 0xb2d1 },
	{ 0x5c57, 0xb2d2 },
	{ 0x5c58, 0xb2d3 },
	{ 0x5c59, 0xb2d4 },
	{ 0x5c5a, 0xb2d5 },
	{ 0x5c5b, 0xb2d6 },
	{ 0x5c5c, 0xb2d7 },
	{ 0x5c5d, 0xb2d8 },
	{ 0x5c5e, 0xb2d9 },
	{ 0x5c5f, 0xb2da },
	{ 0x5c60, 0xb2db },
	{ 0x5c61, 0xb2dc },
	{ 0x5c62, 0xb2dd },
	{ 0x5c63, 0xb2de },
	{ 0x5c64, 0xb2df },
	{ 0x5c65, 0xb2e0 },
	{ 0x5c66, 0xb2e1 },
	{ 0x5c67, 0xb2e2 },
	{ 0x5c68, 0xb2e3 },
	{ 0x5c69, 0xb2e4 },
	{ 0x5c6a, 0xb2e5 },
	{ 0x5c6b, 0xb2e6 },
	{ 0x5c6c, 0xb2e7 },
	{ 0x5c6d, 0xb2e8 },
	{ 0x5c6e, 0xb2e9 },
	{ 0x5c6f, 0xb2ea },
	{ 0x5c70, 0xb2eb },
	{ 0x5c71, 0xb2ec },
	{ 0x5c72, 0xb2ed },
	{ 0x5c73, 0xb2ee },
	{ 0x5c74, 0xb2ef },
	{ 0x5c75, 0xb2f0 },
	{ 0x5c76, 0xb2f1 },
	{ 0x5c77, 0xb2f2 },
	{ 0x5c78, 0xb2f3 },
	{ 0x5c79, 0xb2f4 },
	{ 0x5c7a, 0xb2f5 },
	{ 0x5c7b, 0xb2f6 },
	{ 0x5c7c, 0xb2f7 },
	{ 0x5c7d, 0xb2f8 },
	{ 0x5c7e, 0xb2f9 },
	{ 0x5d21, 0xb2fa },
	{ 0x5d22, 0xb2fb },
	{ 0x5d23, 0xb2fc },
	{ 0x5d24, 0xb2fd },
	{ 0x5d25, 0xb2fe },
	{ 0x5d26, 0xb340 },
	{ 0x5d27, 0xb341 },
	{ 0x5d28, 0xb342 },
	{ 0x5d29, 0xb343 },
	{ 0x5d2a, 0xb344 },
	{ 0x5d2b, 0xb345 },
	{ 0x5d2c, 0xb346 },
	{ 0x5d2d, 0xb347 },
	{ 0x5d2e, 0xb348 },
	{ 0x5d2f, 0xb349 },
	{ 0x5d30, 0xb34a },
	{ 0x5d31, 0xb34b },
	{ 0x5d32, 0xb34c },
	{ 0x5d33, 0xb34d },
	{ 0x5d34, 0xb34e },
	{ 0x5d35, 0xb34f },
	{ 0x5d36, 0xb350 },
	{ 0x5d37, 0xb351 },
	{ 0x5d38, 0xb352 },
	{ 0x5d39, 0xb353 },
	{ 0x5d3a, 0xb354 },
	{ 0x5d3b, 0xb355 },
	{ 0x5d3c, 0xb356 },
	{ 0x5d3d, 0xb357 },
	{ 0x5d3e, 0xb358 },
	{ 0x5d3f, 0xb359 },
	{ 0x5d40, 0xb35a },
	{ 0x5d41, 0xb35b },
	{ 0x5d42, 0xb35c },
	{ 0x5d43, 0xb35d },
	{ 0x5d44, 0xb35e },
	{ 0x5d45, 0xb35f },
	{ 0x5d46, 0xb360 },
	{ 0x5d47, 0xb361 },
	{ 0x5d48, 0xb362 },
	{ 0x5d49, 0xb363 },
	{ 0x5d4a, 0xb364 },
	{ 0x5d4b, 0xb365 },
	{ 0x5d4c, 0xb366 },
	{ 0x5d4d, 0xb367 },
	{ 0x5d4e, 0xb368 },
	{ 0x5d4f, 0xb369 },
	{ 0x5d50, 0xb36a },
	{ 0x5d51, 0xb36b },
	{ 0x5d52, 0xb36c },
	{ 0x5d53, 0xb36d },
	{ 0x5d54, 0xb36e },
	{ 0x5d55, 0xb36f },
	{ 0x5d56, 0xb370 },
	{ 0x5d57, 0xb371 },
	{ 0x5d58, 0xb372 },
	{ 0x5d59, 0xb373 },
	{ 0x5d5a, 0xb374 },
	{ 0x5d5b, 0xb375 },
	{ 0x5d5c, 0xb376 },
	{ 0x5d5d, 0xb377 },
	{ 0x5d5e, 0xb378 },
	{ 0x5d5f, 0xb379 },
	{ 0x5d60, 0xb37a },
	{ 0x5d61, 0xb37b },
	{ 0x5d62, 0xb37c },
	{ 0x5d63, 0xb37d },
	{ 0x5d64, 0xb37e },
	{ 0x5d65, 0xb3a1 },
	{ 0x5d66, 0xb3a2 },
	{ 0x5d67, 0xb3a3 },
	{ 0x5d68, 0xb3a4 },
	{ 0x5d69, 0xb3a5 },
	{ 0x5d6a, 0xb3a6 },
	{ 0x5d6b, 0xb3a7 },
	{ 0x5d6c, 0xb3a8 },
	{ 0x5d6d, 0xb3a9 },
	{ 0x5d6e, 0xb3aa },
	{ 0x5d6f, 0xb3ab },
	{ 0x5d70, 0xb3ac },
	{ 0x5d71, 0xb3ad },
	{ 0x5d72, 0xb3ae },
	{ 0x5d73, 0xb3af },
	{ 0x5d74, 0xb3b0 },
	{ 0x5d75, 0xb3b1 },
	{ 0x5d76, 0xb3b2 },
	{ 0x5d77, 0xb3b3 },
	{ 0x5d78, 0xb3b4 },
	{ 0x5d79, 0xb3b5 },
	{ 0x5d7a, 0xb3b6 },
	{ 0x5d7b, 0xb3b7 },
	{ 0x5d7c, 0xb3b8 },
	{ 0x5d7d, 0xb3b9 },
	{ 0x5d7e, 0xb3ba },
	{ 0x5e21, 0xb3bb },
	{ 0x5e22, 0xb3bc },
	{ 0x5e23, 0xb3bd },
	{ 0x5e24, 0xb3be },
	{ 0x5e25, 0xb3bf },
	{ 0x5e26, 0xb3c0 },
	{ 0x5e27, 0xb3c1 },
	{ 0x5e28, 0xb3c2 },
	{ 0x5e29, 0xb3c3 },
	{ 0x5e2a, 0xb3c4 },
	{ 0x5e2b, 0xb3c5 },
	{ 0x5e2c, 0xb3c6 },
	{ 0x5e2d, 0xb3c7 },
	{ 0x5e2e, 0xb3c8 },
	{ 0x5e2f, 0xb3c9 },
	{ 0x5e30, 0xb3ca },
	{ 0x5e31, 0xb3cb },
	{ 0x5e32, 0xb3cc },
	{ 0x5e33, 0xb3cd },
	{ 0x5e34, 0xb3ce },
	{ 0x5e35, 0xb3cf },
	{ 0x5e36, 0xb3d0 },
	{ 0x5e37, 0xb3d1 },
	{ 0x5e38, 0xb3d2 },
	{ 0x5e39, 0xb3d3 },
	{ 0x5e3a, 0xb3d4 },
	{ 0x5e3b, 0xb3d5 },
	{ 0x5e3c, 0xb3d6 },
	{ 0x5e3d, 0xb3d7 },
	{ 0x5e3e, 0xb3d8 },
	{ 0x5e3f, 0xb3d9 },
	{ 0x5e40, 0xb3da },
	{ 0x5e41, 0xb3db },
	{ 0x5e42, 0xb3dc },
	{ 0x5e43, 0xb3dd },
	{ 0x5e44, 0xb3de },
	{ 0x5e45, 0xb3df },
	{ 0x5e46, 0xb3e0 },
	{ 0x5e47, 0xb3e1 },
	{ 0x5e48, 0xb3e2 },
	{ 0x5e49, 0xb3e3 },
	{ 0x5e4a, 0xb3e4 },
	{ 0x5e4b, 0xb3e5 },
	{ 0x5e4c, 0xb3e6 },
	{ 0x5e4d, 0xb3e7 },
	{ 0x5e4e, 0xb3e8 },
	{ 0x5e4f, 0xb3e9 },
	{ 0x5e50, 0xb3ea },
	{ 0x5e51, 0xb3eb },
	{ 0x5e52, 0xb3ec },
	{ 0x5e53, 0xb3ed },
	{ 0x5e54, 0xb3ee },
	{ 0x5e55, 0xb3ef },
	{ 0x5e56, 0xb3f0 },
	{ 0x5e57, 0xb3f1 },
	{ 0x5e58, 0xb3f2 },
	{ 0x5e59, 0xb3f3 },
	{ 0x5e5a, 0xb3f4 },
	{ 0x5e5b, 0xb3f5 },
	{ 0x5e5c, 0xb3f6 },
	{ 0x5e5d, 0xb3f7 },
	{ 0x5e5e, 0xb3f8 },
	{ 0x5e5f, 0xb3f9 },
	{ 0x5e60, 0xb3fa },
	{ 0x5e61, 0xb3fb },
	{ 0x5e62, 0xb3fc },
	{ 0x5e63, 0xb3fd },
	{ 0x5e64, 0xb3fe },
	{ 0x5e65, 0xb440 },
	{ 0x5e66, 0xb441 },
	{ 0x5e67, 0xb442 },
	{ 0x5e68, 0xb443 },
	{ 0x5e69, 0xb444 },
	{ 0x5e6a, 0xb445 },
	{ 0x5e6b, 0xb446 },
	{ 0x5e6c, 0xb447 },
	{ 0x5e6d, 0xb448 },
	{ 0x5e6e, 0xb449 },
	{ 0x5e6f, 0xb44a },
	{ 0x5e70, 0xb44b },
	{ 0x5e71, 0xb44c },
	{ 0x5e72, 0xb44d },
	{ 0x5e73, 0xb44e },
	{ 0x5e74, 0xb44f },
	{ 0x5e75, 0xb450 },
	{ 0x5e76, 0xb451 },
	{ 0x5e77, 0xb452 },
	{ 0x5e78, 0xb453 },
	{ 0x5e79, 0xb454 },
	{ 0x5e7a, 0xb455 },
	{ 0x5e7b, 0xb456 },
	{ 0x5e7c, 0xb457 },
	{ 0x5e7d, 0xb458 },
	{ 0x5e7e, 0xb459 },
	{ 0x5f21, 0xb45a },
	{ 0x5f22, 0xb45b },
	{ 0x5f23, 0xb45c },
	{ 0x5f24, 0xb45d },
	{ 0x5f25, 0xb45e },
	{ 0x5f26, 0xb45f },
	{ 0x5f27, 0xb460 },
	{ 0x5f28, 0xb461 },
	{ 0x5f29, 0xb462 },
	{ 0x5f2a, 0xb463 },
	{ 0x5f2b, 0xb464 },
	{ 0x5f2c, 0xb465 },
	{ 0x5f2d, 0xb466 },
	{ 0x5f2e, 0xb467 },
	{ 0x5f2f, 0xb468 },
	{ 0x5f30, 0xb469 },
	{ 0x5f31, 0xb46a },
	{ 0x5f32, 0xb46b },
	{ 0x5f33, 0xb46c },
	{ 0x5f34, 0xb46d },
	{ 0x5f35, 0xb46e },
	{ 0x5f36, 0xb46f },
	{ 0x5f37, 0xb470 },
	{ 0x5f38, 0xb471 },
	{ 0x5f39, 0xb472 },
	{ 0x5f3a, 0xb473 },
	{ 0x5f3b, 0xb474 },
	{ 0x5f3c, 0xb475 },
	{ 0x5f3d, 0xb476 },
	{ 0x5f3e, 0xb477 },
	{ 0x5f3f, 0xb478 },
	{ 0x5f40, 0xb479 },
	{ 0x5f41, 0xb47a },
	{ 0x5f42, 0xb47b },
	{ 0x5f43, 0xb47c },
	{ 0x5f44, 0xb47d },
	{ 0x5f45, 0xb47e },
	{ 0x5f46, 0xb4a1 },
	{ 0x5f47, 0xb4a2 },
	{ 0x5f48, 0xb4a3 },
	{ 0x5f49, 0xb4a4 },
	{ 0x5f4a, 0xb4a5 },
	{ 0x5f4b, 0xb4a6 },
	{ 0x5f4c, 0xb4a7 },
	{ 0x5f4d, 0xb4a8 },
	{ 0x5f4e, 0xb4a9 },
	{ 0x5f4f, 0xb4aa },
	{ 0x5f50, 0xb4ab },
	{ 0x5f51, 0xb4ac },
	{ 0x5f52, 0xb4ad },
	{ 0x5f53, 0xb4ae },
	{ 0x5f54, 0xb4af },
	{ 0x5f55, 0xb4b0 },
	{ 0x5f56, 0xb4b1 },
	{ 0x5f57, 0xb4b2 },
	{ 0x5f58, 0xb4b3 },
	{ 0x5f59, 0xb4b4 },
	{ 0x5f5a, 0xb4b5 },
	{ 0x5f5b, 0xb4b6 },
	{ 0x5f5c, 0xb4b7 },
	{ 0x5f5d, 0xb4b8 },
	{ 0x5f5e, 0xb4b9 },
	{ 0x5f5f, 0xb4ba },
	{ 0x5f60, 0xb4bb },
	{ 0x5f61, 0xb4bc },
	{ 0x5f62, 0xb4bd },
	{ 0x5f63, 0xb4be },
	{ 0x5f64, 0xb4bf },
	{ 0x5f65, 0xb4c0 },
	{ 0x5f66, 0xb4c1 },
	{ 0x5f67, 0xb4c2 },
	{ 0x5f68, 0xb4c3 },
	{ 0x5f69, 0xb4c4 },
	{ 0x5f6a, 0xb4c5 },
	{ 0x5f6b, 0xb4c6 },
	{ 0x5f6c, 0xb4c7 },
	{ 0x5f6d, 0xb4c8 },
	{ 0x5f6e, 0xb4c9 },
	{ 0x5f6f, 0xb4ca },
	{ 0x5f70, 0xb4cb },
	{ 0x5f71, 0xb4cc },
	{ 0x5f72, 0xb4cd },
	{ 0x5f73, 0xb4ce },
	{ 0x5f74, 0xb4cf },
	{ 0x5f75, 0xb4d0 },
	{ 0x5f76, 0xb4d1 },
	{ 0x5f77, 0xb4d2 },
	{ 0x5f78, 0xb4d3 },
	{ 0x5f79, 0xb4d4 },
	{ 0x5f7a, 0xb4d5 },
	{ 0x5f7b, 0xb4d6 },
	{ 0x5f7c, 0xb4d7 },
	{ 0x5f7d, 0xb4d8 },
	{ 0x5f7e, 0xb4d9 },
	{ 0x6021, 0xb4da },
	{ 0x6022, 0xb4db },
	{ 0x6023, 0xb4dc },
	{ 0x6024, 0xb4dd },
	{ 0x6025, 0xb4de },
	{ 0x6026, 0xb4df },
	{ 0x6027, 0xb4e0 },
	{ 0x6028, 0xb4e1 },
	{ 0x6029, 0xb4e2 },
	{ 0x602a, 0xb4e3 },
	{ 0x602b, 0xb4e4 },
	{ 0x602c, 0xb4e5 },
	{ 0x602d, 0xb4e6 },
	{ 0x602e, 0xb4e7 },
	{ 0x602f, 0xb4e8 },
	{ 0x6030, 0xb4e9 },
	{ 0x6031, 0xb4ea },
	{ 0x6032, 0xb4eb },
	{ 0x6033, 0xb4ec },
	{ 0x6034, 0xb4ed },
	{ 0x6035, 0xb4ee },
	{ 0x6036, 0xb4ef },
	{ 0x6037, 0xb4f0 },
	{ 0x6038, 0xb4f1 },
	{ 0x6039, 0xb4f2 },
	{ 0x603a, 0xb4f3 },
	{ 0x603b, 0xb4f4 },
	{ 0x603c, 0xb4f5 },
	{ 0x603d, 0xb4f6 },
	{ 0x603e, 0xb4f7 },
	{ 0x603f, 0xb4f8 },
	{ 0x6040, 0xb4f9 },
	{ 0x6041, 0xb4fa },
	{ 0x6042, 0xb4fb },
	{ 0x6043, 0xb4fc },
	{ 0x6044, 0xb4fd },
	{ 0x6045, 0xb4fe },
	{ 0x6046, 0xb540 },
	{ 0x6047, 0xb541 },
	{ 0x6048, 0xb542 },
	{ 0x6049, 0xb543 },
	{ 0x604a, 0xb544 },
	{ 0x604b, 0xb545 },
	{ 0x604c, 0xb546 },
	{ 0x604d, 0xb547 },
	{ 0x604e, 0xb548 },
	{ 0x604f, 0xb549 },
	{ 0x6050, 0xb54a },
	{ 0x6051, 0xb54b },
	{ 0x6052, 0xb54c },
	{ 0x6053, 0xb54d },
	{ 0x6054, 0xb54e },
	{ 0x6055, 0xb54f },
	{ 0x6056, 0xb550 },
	{ 0x6057, 0xb551 },
	{ 0x6058, 0xb552 },
	{ 0x6059, 0xb553 },
	{ 0x605a, 0xb554 },
	{ 0x605b, 0xb555 },
	{ 0x605c, 0xb556 },
	{ 0x605d, 0xb557 },
	{ 0x605e, 0xb558 },
	{ 0x605f, 0xb559 },
	{ 0x6060, 0xb55a },
	{ 0x6061, 0xb55b },
	{ 0x6062, 0xb55c },
	{ 0x6063, 0xb55d },
	{ 0x6064, 0xb55e },
	{ 0x6065, 0xb55f },
	{ 0x6066, 0xb560 },
	{ 0x6067, 0xb561 },
	{ 0x6068, 0xb562 },
	{ 0x6069, 0xb563 },
	{ 0x606a, 0xb564 },
	{ 0x606b, 0xb565 },
	{ 0x606c, 0xb566 },
	{ 0x606d, 0xb567 },
	{ 0x606e, 0xb568 },
	{ 0x606f, 0xb569 },
	{ 0x6070, 0xb56a },
	{ 0x6071, 0xb56b },
	{ 0x6072, 0xb56c },
	{ 0x6073, 0xb56d },
	{ 0x6074, 0xb56e },
	{ 0x6075, 0xb56f },
	{ 0x6076, 0xb570 },
	{ 0x6077, 0xb571 },
	{ 0x6078, 0xb572 },
	{ 0x6079, 0xb573 },
	{ 0x607a, 0xb574 },
	{ 0x607b, 0xb575 },
	{ 0x607c, 0xb576 },
	{ 0x607d, 0xb577 },
	{ 0x607e, 0xb578 },
	{ 0x6121, 0xb579 },
	{ 0x6122, 0xb57a },
	{ 0x6123, 0xb57b },
	{ 0x6124, 0xb57c },
	{ 0x6125, 0xb57d },
	{ 0x6126, 0xb57e },
	{ 0x6127, 0xb5a1 },
	{ 0x6128, 0xb5a2 },
	{ 0x6129, 0xb5a3 },
	{ 0x612a, 0xb5a4 },
	{ 0x612b, 0xb5a5 },
	{ 0x612c, 0xb5a6 },
	{ 0x612d, 0xb5a7 },
	{ 0x612e, 0xb5a8 },
	{ 0x612f, 0xb5a9 },
	{ 0x6130, 0xb5aa },
	{ 0x6131, 0xb5ab },
	{ 0x6132, 0xb5ac },
	{ 0x6133, 0xb5ad },
	{ 0x6134, 0xb5ae },
	{ 0x6135, 0xb5af },
	{ 0x6136, 0xb5b0 },
	{ 0x6137, 0xb5b1 },
	{ 0x6138, 0xb5b2 },
	{ 0x6139, 0xb5b3 },
	{ 0x613a, 0xb5b4 },
	{ 0x613b, 0xb5b5 },
	{ 0x613c, 0xb5b6 },
	{ 0x613d, 0xb5b7 },
	{ 0x613e, 0xb5b8 },
	{ 0x613f, 0xb5b9 },
	{ 0x6140, 0xb5ba },
	{ 0x6141, 0xb5bb },
	{ 0x6142, 0xb5bc },
	{ 0x6143, 0xb5bd },
	{ 0x6144, 0xb5be },
	{ 0x6145, 0xb5bf },
	{ 0x6146, 0xb5c0 },
	{ 0x6147, 0xb5c1 },
	{ 0x6148, 0xb5c2 },
	{ 0x6149, 0xb5c3 },
	{ 0x614a, 0xb5c4 },
	{ 0x614b, 0xb5c5 },
	{ 0x614c, 0xb5c6 },
	{ 0x614d, 0xb5c7 },
	{ 0x614e, 0xb5c8 },
	{ 0x614f, 0xb5c9 },
	{ 0x6150, 0xb5ca },
	{ 0x6151, 0xb5cb },
	{ 0x6152, 0xb5cc },
	{ 0x6153, 0xb5cd },
	{ 0x6154, 0xb5ce },
	{ 0x6155, 0xb5cf },
	{ 0x6156, 0xb5d0 },
	{ 0x6157, 0xb5d1 },
	{ 0x6158, 0xb5d2 },
	{ 0x6159, 0xb5d3 },
	{ 0x615a, 0xb5d4 },
	{ 0x615b, 0xb5d5 },
	{ 0x615c, 0xb5d6 },
	{ 0x615d, 0xb5d7 },
	{ 0x615e, 0xb5d8 },
	{ 0x615f, 0xb5d9 },
	{ 0x6160, 0xb5da },
	{ 0x6161, 0xb5db },
	{ 0x6162, 0xb5dc },
	{ 0x6163, 0xb5dd },
	{ 0x6164, 0xb5de },
	{ 0x6165, 0xb5df },
	{ 0x6166, 0xb5e0 },
	{ 0x6167, 0xb5e1 },
	{ 0x6168, 0xb5e2 },
	{ 0x6169, 0xb5e3 },
	{ 0x616a, 0xb5e4 },
	{ 0x616b, 0xb5e5 },
	{ 0x616c, 0xb5e6 },
	{ 0x616d, 0xb5e7 },
	{ 0x616e, 0xb5e8 },
	{ 0x616f, 0xb5e9 },
	{ 0x6170, 0xb5ea },
	{ 0x6171, 0xb5eb },
	{ 0x6172, 0xb5ec },
	{ 0x6173, 0xb5ed },
	{ 0x6174, 0xb5ee },
	{ 0x6175, 0xb5ef },
	{ 0x6176, 0xb5f0 },
	{ 0x6177, 0xb5f1 },
	{ 0x6178, 0xb5f2 },
	{ 0x6179, 0xb5f3 },
	{ 0x617a, 0xb5f4 },
	{ 0x617b, 0xb5f5 },
	{ 0x617c, 0xb5f6 },
	{ 0x617d, 0xb5f7 },
	{ 0x617e, 0xb5f8 },
	{ 0x6221, 0xb5f9 },
	{ 0x6222, 0xb5fa },
	{ 0x6223, 0xb5fb },
	{ 0x6224, 0xb5fc },
	{ 0x6225, 0xb5fd },
	{ 0x6226, 0xb5fe },
	{ 0x6227, 0xb640 },
	{ 0x6228, 0xb641 },
	{ 0x6229, 0xb642 },
	{ 0x622a, 0xb643 },
	{ 0x622b, 0xb644 },
	{ 0x622c, 0xb645 },
	{ 0x622d, 0xb646 },
	{ 0x622e, 0xb647 },
	{ 0x622f, 0xb648 },
	{ 0x6230, 0xb649 },
	{ 0x6231, 0xb64a },
	{ 0x6232, 0xb64b },
	{ 0x6233, 0xb64c },
	{ 0x6234, 0xb64d },
	{ 0x6235, 0xb64e },
	{ 0x6236, 0xb64f },
	{ 0x6237, 0xb650 },
	{ 0x6238, 0xb651 },
	{ 0x6239, 0xb652 },
	{ 0x623a, 0xb653 },
	{ 0x623b, 0xb654 },
	{ 0x623c, 0xb655 },
	{ 0x623d, 0xb656 },
	{ 0x623e, 0xb657 },
	{ 0x623f, 0xb658 },
	{ 0x6240, 0xb659 },
	{ 0x6241, 0xb65a },
	{ 0x6242, 0xb65b },
	{ 0x6243, 0xb65c },
	{ 0x6244, 0xb65d },
	{ 0x6245, 0xb65e },
	{ 0x6246, 0xb65f },
	{ 0x6247, 0xb660 },
	{ 0x6248, 0xb661 },
	{ 0x6249, 0xb662 },
	{ 0x624a, 0xb663 },
	{ 0x624b, 0xb664 },
	{ 0x624c, 0xb665 },
	{ 0x624d, 0xb666 },
	{ 0x624e, 0xb667 },
	{ 0x624f, 0xb668 },
	{ 0x6250, 0xb669 },
	{ 0x6251, 0xb66a },
	{ 0x6252, 0xb66b },
	{ 0x6253, 0xb66c },
	{ 0x6254, 0xb66d },
	{ 0x6255, 0xb66e },
	{ 0x6256, 0xb66f },
	{ 0x6257, 0xb670 },
	{ 0x6258, 0xb671 },
	{ 0x6259, 0xb672 },
	{ 0x625a, 0xb673 },
	{ 0x625b, 0xb674 },
	{ 0x625c, 0xb675 },
	{ 0x625d, 0xb676 },
	{ 0x625e, 0xb677 },
	{ 0x625f, 0xb678 },
	{ 0x6260, 0xb679 },
	{ 0x6261, 0xb67a },
	{ 0x6262, 0xb67b },
	{ 0x6263, 0xb67c },
	{ 0x6264, 0xb67d },
	{ 0x6265, 0xb67e },
	{ 0x6266, 0xb6a1 },
	{ 0x6267, 0xb6a2 },
	{ 0x6268, 0xb6a3 },
	{ 0x6269, 0xb6a4 },
	{ 0x626a, 0xb6a5 },
	{ 0x626b, 0xb6a6 },
	{ 0x626c, 0xb6a7 },
	{ 0x626d, 0xb6a8 },
	{ 0x626e, 0xb6a9 },
	{ 0x626f, 0xb6aa },
	{ 0x6270, 0xb6ab },
	{ 0x6271, 0xb6ac },
	{ 0x6272, 0xb6ad },
	{ 0x6273, 0xb6ae },
	{ 0x6274, 0xb6af },
	{ 0x6275, 0xb6b0 },
	{ 0x6276, 0xb6b1 },
	{ 0x6277, 0xb6b2 },
	{ 0x6278, 0xb6b3 },
	{ 0x6279, 0xb6b4 },
	{ 0x627a, 0xb6b5 },
	{ 0x627b, 0xb6b6 },
	{ 0x627c, 0xb6b7 },
	{ 0x627d, 0xb6b8 },
	{ 0x627e, 0xb6b9 },
	{ 0x6321, 0xb6ba },
	{ 0x6322, 0xb6bb },
	{ 0x6323, 0xb6bc },
	{ 0x6324, 0xb6bd },
	{ 0x6325, 0xb6be },
	{ 0x6326, 0xb6bf },
	{ 0x6327, 0xb6c0 },
	{ 0x6328, 0xb6c1 },
	{ 0x6329, 0xb6c2 },
	{ 0x632a, 0xb6c3 },
	{ 0x632b, 0xb6c4 },
	{ 0x632c, 0xb6c5 },
	{ 0x632d, 0xb6c6 },
	{ 0x632e, 0xb6c7 },
	{ 0x632f, 0xb6c8 },
	{ 0x6330, 0xb6c9 },
	{ 0x6331, 0xb6ca },
	{ 0x6332, 0xb6cb },
	{ 0x6333, 0xb6cc },
	{ 0x6334, 0xb6cd },
	{ 0x6335, 0xb6ce },
	{ 0x6336, 0xb6cf },
	{ 0x6337, 0xb6d0 },
	{ 0x6338, 0xb6d1 },
	{ 0x6339, 0xb6d2 },
	{ 0x633a, 0xb6d3 },
	{ 0x633b, 0xb6d4 },
	{ 0x633c, 0xb6d5 },
	{ 0x633d, 0xb6d6 },
	{ 0x633e, 0xb6d7 },
	{ 0x633f, 0xb6d8 },
	{ 0x6340, 0xb6d9 },
	{ 0x6341, 0xb6da },
	{ 0x6342, 0xb6db },
	{ 0x6343, 0xb6dc },
	{ 0x6344, 0xb6dd },
	{ 0x6345, 0xb6de },
	{ 0x6346, 0xb6df },
	{ 0x6347, 0xb6e0 },
	{ 0x6348, 0xb6e1 },
	{ 0x6349, 0xb6e2 },
	{ 0x634a, 0xb6e3 },
	{ 0x634b, 0xb6e4 },
	{ 0x634c, 0xb6e5 },
	{ 0x634d, 0xb6e6 },
	{ 0x634e, 0xb6e7 },
	{ 0x634f, 0xb6e8 },
	{ 0x6350, 0xb6e9 },
	{ 0x6351, 0xb6ea },
	{ 0x6352, 0xb6eb },
	{ 0x6353, 0xb6ec },
	{ 0x6354, 0xb6ed },
	{ 0x6355, 0xb6ee },
	{ 0x6356, 0xb6ef },
	{ 0x6357, 0xb6f0 },
	{ 0x6358, 0xb6f1 },
	{ 0x6359, 0xb6f2 },
	{ 0x635a, 0xb6f3 },
	{ 0x635b, 0xb6f4 },
	{ 0x635c, 0xb6f5 },
	{ 0x635d, 0xb6f6 },
	{ 0x635e, 0xb6f7 },
	{ 0x635f, 0xb6f8 },
	{ 0x6360, 0xb6f9 },
	{ 0x6361, 0xb6fa },
	{ 0x6362, 0xb6fb },
	{ 0x6363, 0xb6fc },
	{ 0x6364, 0xb6fd },
	{ 0x6365, 0xb6fe },
	{ 0x6366, 0xb740 },
	{ 0x6367, 0xb741 },
	{ 0x6368, 0xb742 },
	{ 0x6369, 0xb743 },
	{ 0x636a, 0xb744 },
	{ 0x636b, 0xb745 },
	{ 0x636c, 0xb746 },
	{ 0x636d, 0xb747 },
	{ 0x636e, 0xb748 },
	{ 0x636f, 0xb749 },
	{ 0x6370, 0xb74a },
	{ 0x6371, 0xb74b },
	{ 0x6372, 0xb74c },
	{ 0x6373, 0xb74d },
	{ 0x6374, 0xb74e },
	{ 0x6375, 0xb74f },
	{ 0x6376, 0xb750 },
	{ 0x6377, 0xb751 },
	{ 0x6378, 0xb752 },
	{ 0x6379, 0xb753 },
	{ 0x637a, 0xb754 },
	{ 0x637b, 0xb755 },
	{ 0x637c, 0xb756 },
	{ 0x637d, 0xb757 },
	{ 0x637e, 0xb758 },
	{ 0x6421, 0xb759 },
	{ 0x6422, 0xb75a },
	{ 0x6423, 0xb75b },
	{ 0x6424, 0xb75c },
	{ 0x6425, 0xb75d },
	{ 0x6426, 0xb75e },
	{ 0x6427, 0xb75f },
	{ 0x6428, 0xb760 },
	{ 0x6429, 0xb761 },
	{ 0x642a, 0xb762 },
	{ 0x642b, 0xb763 },
	{ 0x642c, 0xb764 },
	{ 0x642d, 0xb765 },
	{ 0x642e, 0xb766 },
	{ 0x642f, 0xb767 },
	{ 0x6430, 0xb768 },
	{ 0x6431, 0xb769 },
	{ 0x6432, 0xb76a },
	{ 0x6433, 0xb76b },
	{ 0x6434, 0xb76c },
	{ 0x6435, 0xb76d },
	{ 0x6436, 0xb76e },
	{ 0x6437, 0xb76f },
	{ 0x6438, 0xb770 },
	{ 0x6439, 0xb771 },
	{ 0x643a, 0xb772 },
	{ 0x643b, 0xb773 },
	{ 0x643c, 0xb774 },
	{ 0x643d, 0xb775 },
	{ 0x643e, 0xb776 },
	{ 0x643f, 0xb777 },
	{ 0x6440, 0xb778 },
	{ 0x6441, 0xb779 },
	{ 0x6442, 0xb77a },
	{ 0x6443, 0xb77b },
	{ 0x6444, 0xb77c },
	{ 0x6445, 0xb77d },
	{ 0x6446, 0xb77e },
	{ 0x6447, 0xb7a1 },
	{ 0x6448, 0xb7a2 },
	{ 0x6449, 0xb7a3 },
	{ 0x644a, 0xb7a4 },
	{ 0x644b, 0xb7a5 },
	{ 0x644c, 0xb7a6 },
	{ 0x644d, 0xb7a7 },
	{ 0x644e, 0xb7a8 },
	{ 0x644f, 0xb7a9 },
	{ 0x6450, 0xb7aa },
	{ 0x6451, 0xb7ab },
	{ 0x6452, 0xb7ac },
	{ 0x6453, 0xb7ad },
	{ 0x6454, 0xb7ae },
	{ 0x6455, 0xb7af },
	{ 0x6456, 0xb7b0 },
	{ 0x6457, 0xb7b1 },
	{ 0x6458, 0xb7b2 },
	{ 0x6459, 0xb7b3 },
	{ 0x645a, 0xb7b4 },
	{ 0x645b, 0xb7b5 },
	{ 0x645c, 0xb7b6 },
	{ 0x645d, 0xb7b7 },
	{ 0x645e, 0xb7b8 },
	{ 0x645f, 0xb7b9 },
	{ 0x6460, 0xb7ba },
	{ 0x6461, 0xb7bb },
	{ 0x6462, 0xb7bc },
	{ 0x6463, 0xb7bd },
	{ 0x6464, 0xb7be },
	{ 0x6465, 0xb7bf },
	{ 0x6466, 0xb7c0 },
	{ 0x6467, 0xb7c1 },
	{ 0x6468, 0xb7c2 },
	{ 0x6469, 0xb7c3 },
	{ 0x646a, 0xb7c4 },
	{ 0x646b, 0xb7c5 },
	{ 0x646c, 0xb7c6 },
	{ 0x646d, 0xb7c7 },
	{ 0x646e, 0xb7c8 },
	{ 0x646f, 0xb7c9 },
	{ 0x6470, 0xb7ca },
	{ 0x6471, 0xb7cb },
	{ 0x6472, 0xb7cc },
	{ 0x6473, 0xb7cd },
	{ 0x6474, 0xb7ce },
	{ 0x6475, 0xb7cf },
	{ 0x6476, 0xb7d0 },
	{ 0x6477, 0xb7d1 },
	{ 0x6478, 0xb7d2 },
	{ 0x6479, 0xb7d3 },
	{ 0x647a, 0xb7d4 },
	{ 0x647b, 0xb7d5 },
	{ 0x647c, 0xb7d6 },
	{ 0x647d, 0xb7d7 },
	{ 0x647e, 0xb7d8 },
	{ 0x6521, 0xb7d9 },
	{ 0x6522, 0xb7da },
	{ 0x6523, 0xb7db },
	{ 0x6524, 0xb7dc },
	{ 0x6525, 0xb7dd },
	{ 0x6526, 0xb7de },
	{ 0x6527, 0xb7df },
	{ 0x6528, 0xb7e0 },
	{ 0x6529, 0xb7e1 },
	{ 0x652a, 0xb7e2 },
	{ 0x652b, 0xb7e3 },
	{ 0x652c, 0xb7e4 },
	{ 0x652d, 0xb7e5 },
	{ 0x652e, 0xb7e6 },
	{ 0x652f, 0xb7e7 },
	{ 0x6530, 0xb7e8 },
	{ 0x6531, 0xb7e9 },
	{ 0x6532, 0xb7ea },
	{ 0x6533, 0xb7eb },
	{ 0x6534, 0xb7ec },
	{ 0x6535, 0xb7ed },
	{ 0x6536, 0xb7ee },
	{ 0x6537, 0xb7ef },
	{ 0x6538, 0xb7f0 },
	{ 0x6539, 0xb7f1 },
	{ 0x653a, 0xb7f2 },
	{ 0x653b, 0xb7f3 },
	{ 0x653c, 0xb7f4 },
	{ 0x653d, 0xb7f5 },
	{ 0x653e, 0xb7f6 },
	{ 0x653f, 0xb7f7 },
	{ 0x6540, 0xb7f8 },
	{ 0x6541, 0xb7f9 },
	{ 0x6542, 0xb7fa },
	{ 0x6543, 0xb7fb },
	{ 0x6544, 0xb7fc },
	{ 0x6545, 0xb7fd },
	{ 0x6546, 0xb7fe },
	{ 0x6547, 0xb840 },
	{ 0x6548, 0xb841 },
	{ 0x6549, 0xb842 },
	{ 0x654a, 0xb843 },
	{ 0x654b, 0xb844 },
	{ 0x654c, 0xb845 },
	{ 0x654d, 0xb846 },
	{ 0x654e, 0xb847 },
	{ 0x654f, 0xb848 },
	{ 0x6550, 0xb849 },
	{ 0x6551, 0xb84a },
	{ 0x6552, 0xb84b },
	{ 0x6553, 0xb84c },
	{ 0x6554, 0xb84d },
	{ 0x6555, 0xb84e },
	{ 0x6556, 0xb84f },
	{ 0x6557, 0xb850 },
	{ 0x6558, 0xb851 },
	{ 0x6559, 0xb852 },
	{ 0x655a, 0xb853 },
	{ 0x655b, 0xb854 },
	{ 0x655c, 0xb855 },
	{ 0x655d, 0xb856 },
	{ 0x655e, 0xb857 },
	{ 0x655f, 0xb858 },
	{ 0x6560, 0xb859 },
	{ 0x6561, 0xb85a },
	{ 0x6562, 0xb85b },
	{ 0x6563, 0xb85c },
	{ 0x6564, 0xb85d },
	{ 0x6565, 0xb85e },
	{ 0x6566, 0xb85f },
	{ 0x6567, 0xb860 },
	{ 0x6568, 0xb861 },
	{ 0x6569, 0xb862 },
	{ 0x656a, 0xb863 },
	{ 0x656b, 0xb864 },
	{ 0x656c, 0xb865 },
	{ 0x656d, 0xb866 },
	{ 0x656e, 0xb867 },
	{ 0x656f, 0xb868 },
	{ 0x6570, 0xb869 },
	{ 0x6571, 0xb86a },
	{ 0x6572, 0xb86b },
	{ 0x6573, 0xb86c },
	{ 0x6574, 0xb86d },
	{ 0x6575, 0xb86e },
	{ 0x6576, 0xb86f },
	{ 0x6577, 0xb870 },
	{ 0x6578, 0xb871 },
	{ 0x6579, 0xb872 },
	{ 0x657a, 0xb873 },
	{ 0x657b, 0xb874 },
	{ 0x657c, 0xb875 },
	{ 0x657d, 0xb876 },
	{ 0x657e, 0xb877 },
	{ 0x6621, 0xb878 },
	{ 0x6622, 0xb879 },
	{ 0x6623, 0xb87a },
	{ 0x6624, 0xb87b },
	{ 0x6625, 0xb87c },
	{ 0x6626, 0xb87d },
	{ 0x6627, 0xb87e },
	{ 0x6628, 0xb8a1 },
	{ 0x6629, 0xb8a2 },
	{ 0x662a, 0xb8a3 },
	{ 0x662b, 0xb8a4 },
	{ 0x662c, 0xb8a5 },
	{ 0x662d, 0xb8a6 },
	{ 0x662e, 0xb8a7 },
	{ 0x662f, 0xb8a8 },
	{ 0x6630, 0xb8a9 },
	{ 0x6631, 0xb8aa },
	{ 0x6632, 0xb8ab },
	{ 0x6633, 0xb8ac },
	{ 0x6634, 0xb8ad },
	{ 0x6635, 0xb8ae },
	{ 0x6636, 0xb8af },
	{ 0x6637, 0xb8b0 },
	{ 0x6638, 0xb8b1 },
	{ 0x6639, 0xb8b2 },
	{ 0x663a, 0xb8b3 },
	{ 0x663b, 0xb8b4 },
	{ 0x663c, 0xb8b5 },
	{ 0x663d, 0xb8b6 },
	{ 0x663e, 0xb8b7 },
	{ 0x663f, 0xb8b8 },
	{ 0x6640, 0xb8b9 },
	{ 0x6641, 0xb8ba },
	{ 0x6642, 0xb8bb },
	{ 0x6643, 0xb8bc },
	{ 0x6644, 0xb8bd },
	{ 0x6645, 0xb8be },
	{ 0x6646, 0xb8bf },
	{ 0x6647, 0xb8c0 },
	{ 0x6648, 0xb8c1 },
	{ 0x6649, 0xb8c2 },
	{ 0x664a, 0xb8c3 },
	{ 0x664b, 0xb8c4 },
	{ 0x664c, 0xb8c5 },
	{ 0x664d, 0xb8c6 },
	{ 0x664e, 0xb8c7 },
	{ 0x664f, 0xb8c8 },
	{ 0x6650, 0xb8c9 },
	{ 0x6651, 0xb8ca },
	{ 0x6652, 0xb8cb },
	{ 0x6653, 0xb8cc },
	{ 0x6654, 0xb8cd },
	{ 0x6655, 0xb8ce },
	{ 0x6656, 0xb8cf },
	{ 0x6657, 0xb8d0 },
	{ 0x6658, 0xb8d1 },
	{ 0x6659, 0xb8d2 },
	{ 0x665a, 0xb8d3 },
	{ 0x665b, 0xb8d4 },
	{ 0x665c, 0xb8d5 },
	{ 0x665d, 0xb8d6 },
	{ 0x665e, 0xb8d7 },
	{ 0x665f, 0xb8d8 },
	{ 0x6660, 0xb8d9 },
	{ 0x6661, 0xb8da },
	{ 0x6662, 0xb8db },
	{ 0x6663, 0xb8dc },
	{ 0x6664, 0xb8dd },
	{ 0x6665, 0xb8de },
	{ 0x6666, 0xb8df },
	{ 0x6667, 0xb8e0 },
	{ 0x6668, 0xb8e1 },
	{ 0x6669, 0xb8e2 },
	{ 0x666a, 0xb8e3 },
	{ 0x666b, 0xb8e4 },
	{ 0x666c, 0xb8e5 },
	{ 0x666d, 0xb8e6 },
	{ 0x666e, 0xb8e7 },
	{ 0x666f, 0xb8e8 },
	{ 0x6670, 0xb8e9 },
	{ 0x6671, 0xb8ea },
	{ 0x6672, 0xb8eb },
	{ 0x6673, 0xb8ec },
	{ 0x6674, 0xb8ed },
	{ 0x6675, 0xb8ee },
	{ 0x6676, 0xb8ef },
	{ 0x6677, 0xb8f0 },
	{ 0x6678, 0xb8f1 },
	{ 0x6679, 0xb8f2 },
	{ 0x667a, 0xb8f3 },
	{ 0x667b, 0xb8f4 },
	{ 0x667c, 0xb8f5 },
	{ 0x667d, 0xb8f6 },
	{ 0x667e, 0xb8f7 },
	{ 0x6721, 0xb8f8 },
	{ 0x6722, 0xb8f9 },
	{ 0x6723, 0xb8fa },
	{ 0x6724, 0xb8fb },
	{ 0x6725, 0xb8fc },
	{ 0x6726, 0xb8fd },
	{ 0x6727, 0xb8fe },
	{ 0x6728, 0xb940 },
	{ 0x6729, 0xb941 },
	{ 0x672a, 0xb942 },
	{ 0x672b, 0xb943 },
	{ 0x672c, 0xb944 },
	{ 0x672d, 0xb945 },
	{ 0x672e, 0xb946 },
	{ 0x672f, 0xb947 },
	{ 0x6730, 0xb948 },
	{ 0x6731, 0xb949 },
	{ 0x6732, 0xb94a },
	{ 0x6733, 0xb94b },
	{ 0x6734, 0xb94c },
	{ 0x6735, 0xb94d },
	{ 0x6736, 0xb94e },
	{ 0x6737, 0xb94f },
	{ 0x6738, 0xb950 },
	{ 0x6739, 0xb951 },
	{ 0x673a, 0xb952 },
	{ 0x673b, 0xb953 },
	{ 0x673c, 0xb954 },
	{ 0x673d, 0xb955 },
	{ 0x673e, 0xb956 },
	{ 0x673f, 0xb957 },
	{ 0x6740, 0xb958 },
	{ 0x6741, 0xb959 },
	{ 0x6742, 0xb95a },
	{ 0x6743, 0xb95b },
	{ 0x6744, 0xb95c },
	{ 0x6745, 0xb95d },
	{ 0x6746, 0xb95e },
	{ 0x6747, 0xb95f },
	{ 0x6748, 0xb960 },
	{ 0x6749, 0xb961 },
	{ 0x674a, 0xb962 },
	{ 0x674b, 0xb963 },
	{ 0x674c, 0xb964 },
	{ 0x674d, 0xb965 },
	{ 0x674e, 0xb966 },
	{ 0x674f, 0xb967 },
	{ 0x6750, 0xb968 },
	{ 0x6751, 0xb969 },
	{ 0x6752, 0xb96a },
	{ 0x6753, 0xb96b },
	{ 0x6754, 0xb96c },
	{ 0x6755, 0xb96d },
	{ 0x6756, 0xb96e },
	{ 0x6757, 0xb96f },
	{ 0x6758, 0xb970 },
	{ 0x6759, 0xb971 },
	{ 0x675a, 0xb972 },
	{ 0x675b, 0xb973 },
	{ 0x675c, 0xb974 },
	{ 0x675d, 0xb975 },
	{ 0x675e, 0xb976 },
	{ 0x675f, 0xb977 },
	{ 0x6760, 0xb978 },
	{ 0x6761, 0xb979 },
	{ 0x6762, 0xb97a },
	{ 0x6763, 0xb97b },
	{ 0x6764, 0xb97c },
	{ 0x6765, 0xb97d },
	{ 0x6766, 0xb97e },
	{ 0x6767, 0xb9a1 },
	{ 0x6768, 0xb9a2 },
	{ 0x6769, 0xb9a3 },
	{ 0x676a, 0xb9a4 },
	{ 0x676b, 0xb9a5 },
	{ 0x676c, 0xb9a6 },
	{ 0x676d, 0xb9a7 },
	{ 0x676e, 0xb9a8 },
	{ 0x676f, 0xb9a9 },
	{ 0x6770, 0xb9aa },
	{ 0x6771, 0xb9ab },
	{ 0x6772, 0xb9ac },
	{ 0x6773, 0xb9ad },
	{ 0x6774, 0xb9ae },
	{ 0x6775, 0xb9af },
	{ 0x6776, 0xb9b0 },
	{ 0x6777, 0xb9b1 },
	{ 0x6778, 0xb9b2 },
	{ 0x6779, 0xb9b3 },
	{ 0x677a, 0xb9b4 },
	{ 0x677b, 0xb9b5 },
	{ 0x677c, 0xb9b6 },
	{ 0x677d, 0xb9b7 },
	{ 0x677e, 0xb9b8 },
	{ 0x6821, 0xb9b9 },
	{ 0x6822, 0xb9ba },
	{ 0x6823, 0xb9bb },
	{ 0x6824, 0xb9bc },
	{ 0x6825, 0xb9bd },
	{ 0x6826, 0xb9be },
	{ 0x6827, 0xb9bf },
	{ 0x6828, 0xb9c0 },
	{ 0x6829, 0xb9c1 },
	{ 0x682a, 0xb9c2 },
	{ 0x682b, 0xb9c3 },
	{ 0x682c, 0xb9c4 },
	{ 0x682d, 0xb9c5 },
	{ 0x682e, 0xb9c6 },
	{ 0x682f, 0xb9c7 },
	{ 0x6830, 0xb9c8 },
	{ 0x6831, 0xb9c9 },
	{ 0x6832, 0xb9ca },
	{ 0x6833, 0xb9cb },
	{ 0x6834, 0xb9cc },
	{ 0x6835, 0xb9cd },
	{ 0x6836, 0xb9ce },
	{ 0x6837, 0xb9cf },
	{ 0x6838, 0xb9d0 },
	{ 0x6839, 0xb9d1 },
	{ 0x683a, 0xb9d2 },
	{ 0x683b, 0xb9d3 },
	{ 0x683c, 0xb9d4 },
	{ 0x683d, 0xb9d5 },
	{ 0x683e, 0xb9d6 },
	{ 0x683f, 0xb9d7 },
	{ 0x6840, 0xb9d8 },
	{ 0x6841, 0xb9d9 },
	{ 0x6842, 0xb9da },
	{ 0x6843, 0xb9db },
	{ 0x6844, 0xb9dc },
	{ 0x6845, 0xb9dd },
	{ 0x6846, 0xb9de },
	{ 0x6847, 0xb9df },
	{ 0x6848, 0xb9e0 },
	{ 0x6849, 0xb9e1 },
	{ 0x684a, 0xb9e2 },
	{ 0x684b, 0xb9e3 },
	{ 0x684c, 0xb9e4 },
	{ 0x684d, 0xb9e5 },
	{ 0x684e, 0xb9e6 },
	{ 0x684f, 0xb9e7 },
	{ 0x6850, 0xb9e8 },
	{ 0x6851, 0xb9e9 },
	{ 0x6852, 0xb9ea },
	{ 0x6853, 0xb9eb },
	{ 0x6854, 0xb9ec },
	{ 0x6855, 0xb9ed },
	{ 0x6856, 0xb9ee },
	{ 0x6857, 0xb9ef },
	{ 0x6858, 0xb9f0 },
	{ 0x6859, 0xb9f1 },
	{ 0x685a, 0xb9f2 },
	{ 0x685b, 0xb9f3 },
	{ 0x685c, 0xb9f4 },
	{ 0x685d, 0xb9f5 },
	{ 0x685e, 0xb9f6 },
	{ 0x685f, 0xb9f7 },
	{ 0x6860, 0xb9f8 },
	{ 0x6861, 0xb9f9 },
	{ 0x6862, 0xb9fa },
	{ 0x6863, 0xb9fb },
	{ 0x6864, 0xb9fc },
	{ 0x6865, 0xb9fd },
	{ 0x6866, 0xb9fe },
	{ 0x6867, 0xba40 },
	{ 0x6868, 0xba41 },
	{ 0x6869, 0xba42 },
	{ 0x686a, 0xba43 },
	{ 0x686b, 0xba44 },
	{ 0x686c, 0xba45 },
	{ 0x686d, 0xba46 },
	{ 0x686e, 0xba47 },
	{ 0x686f, 0xba48 },
	{ 0x6870, 0xba49 },
	{ 0x6871, 0xba4a },
	{ 0x6872, 0xba4b },
	{ 0x6873, 0xba4c },
	{ 0x6874, 0xba4d },
	{ 0x6875, 0xba4e },
	{ 0x6876, 0xba4f },
	{ 0x6877, 0xba50 },
	{ 0x6878, 0xba51 },
	{ 0x6879, 0xba52 },
	{ 0x687a, 0xba53 },
	{ 0x687b, 0xba54 },
	{ 0x687c, 0xba55 },
	{ 0x687d, 0xba56 },
	{ 0x687e, 0xba57 },
	{ 0x6921, 0xba58 },
	{ 0x6922, 0xba59 },
	{ 0x6923, 0xba5a },
	{ 0x6924, 0xba5b },
	{ 0x6925, 0xba5c },
	{ 0x6926, 0xba5d },
	{ 0x6927, 0xba5e },
	{ 0x6928, 0xba5f },
	{ 0x6929, 0xba60 },
	{ 0x692a, 0xba61 },
	{ 0x692b, 0xba62 },
	{ 0x692c, 0xba63 },
	{ 0x692d, 0xba64 },
	{ 0x692e, 0xba65 },
	{ 0x692f, 0xba66 },
	{ 0x6930, 0xba67 },
	{ 0x6931, 0xba68 },
	{ 0x6932, 0xba69 },
	{ 0x6933, 0xba6a },
	{ 0x6934, 0xba6b },
	{ 0x6935, 0xba6c },
	{ 0x6936, 0xba6d },
	{ 0x6937, 0xba6e },
	{ 0x6938, 0xba6f },
	{ 0x6939, 0xba70 },
	{ 0x693a, 0xba71 },
	{ 0x693b, 0xba72 },
	{ 0x693c, 0xba73 },
	{ 0x693d, 0xba74 },
	{ 0x693e, 0xba75 },
	{ 0x693f, 0xba76 },
	{ 0x6940, 0xba77 },
	{ 0x6941, 0xba78 },
	{ 0x6942, 0xba79 },
	{ 0x6943, 0xba7a },
	{ 0x6944, 0xba7b },
	{ 0x6945, 0xba7c },
	{ 0x6946, 0xba7d },
	{ 0x6947, 0xba7e },
	{ 0x6948, 0xbaa1 },
	{ 0x6949, 0xbaa2 },
	{ 0x694a, 0xbaa3 },
	{ 0x694b, 0xbaa4 },
	{ 0x694c, 0xbaa5 },
	{ 0x694d, 0xbaa6 },
	{ 0x694e, 0xbaa7 },
	{ 0x694f, 0xbaa8 },
	{ 0x6950, 0xbaa9 },
	{ 0x6951, 0xbaaa },
	{ 0x6952, 0xbaab },
	{ 0x6953, 0xbaac },
	{ 0x6954, 0xbaad },
	{ 0x6955, 0xbaae },
	{ 0x6956, 0xbaaf },
	{ 0x6957, 0xbab0 },
	{ 0x6958, 0xbab1 },
	{ 0x6959, 0xbab2 },
	{ 0x695a, 0xbab3 },
	{ 0x695b, 0xbab4 },
	{ 0x695c, 0xbab5 },
	{ 0x695d, 0xbab6 },
	{ 0x695e, 0xbab7 },
	{ 0x695f, 0xbab8 },
	{ 0x6960, 0xbab9 },
	{ 0x6961, 0xbaba },
	{ 0x6962, 0xbabb },
	{ 0x6963, 0xbabc },
	{ 0x6964, 0xbabd },
	{ 0x6965, 0xbabe },
	{ 0x6966, 0xbabf },
	{ 0x6967, 0xbac0 },
	{ 0x6968, 0xbac1 },
	{ 0x6969, 0xbac2 },
	{ 0x696a, 0xbac3 },
	{ 0x696b, 0xbac4 },
	{ 0x696c, 0xbac5 },
	{ 0x696d, 0xbac6 },
	{ 0x696e, 0xbac7 },
	{ 0x696f, 0xbac8 },
	{ 0x6970, 0xbac9 },
	{ 0x6971, 0xbaca },
	{ 0x6972, 0xbacb },
	{ 0x6973, 0xbacc },
	{ 0x6974, 0xbacd },
	{ 0x6975, 0xbace },
	{ 0x6976, 0xbacf },
	{ 0x6977, 0xbad0 },
	{ 0x6978, 0xbad1 },
	{ 0x6979, 0xbad2 },
	{ 0x697a, 0xbad3 },
	{ 0x697b, 0xbad4 },
	{ 0x697c, 0xbad5 },
	{ 0x697d, 0xbad6 },
	{ 0x697e, 0xbad7 },
	{ 0x6a21, 0xbad8 },
	{ 0x6a22, 0xbad9 },
	{ 0x6a23, 0xbada },
	{ 0x6a24, 0xbadb },
	{ 0x6a25, 0xbadc },
	{ 0x6a26, 0xbadd },
	{ 0x6a27, 0xbade },
	{ 0x6a28, 0xbadf },
	{ 0x6a29, 0xbae0 },
	{ 0x6a2a, 0xbae1 },
	{ 0x6a2b, 0xbae2 },
	{ 0x6a2c, 0xbae3 },
	{ 0x6a2d, 0xbae4 },
	{ 0x6a2e, 0xbae5 },
	{ 0x6a2f, 0xbae6 },
	{ 0x6a30, 0xbae7 },
	{ 0x6a31, 0xbae8 },
	{ 0x6a32, 0xbae9 },
	{ 0x6a33, 0xbaea },
	{ 0x6a34, 0xbaeb },
	{ 0x6a35, 0xbaec },
	{ 0x6a36, 0xbaed },
	{ 0x6a37, 0xbaee },
	{ 0x6a38, 0xbaef },
	{ 0x6a39, 0xbaf0 },
	{ 0x6a3a, 0xbaf1 },
	{ 0x6a3b, 0xbaf2 },
	{ 0x6a3c, 0xbaf3 },
	{ 0x6a3d, 0xbaf4 },
	{ 0x6a3e, 0xbaf5 },
	{ 0x6a3f, 0xbaf6 },
	{ 0x6a40, 0xbaf7 },
	{ 0x6a41, 0xbaf8 },
	{ 0x6a42, 0xbaf9 },
	{ 0x6a43, 0xbafa },
	{ 0x6a44, 0xbafb },
	{ 0x6a45, 0xbafc },
	{ 0x6a46, 0xbafd },
	{ 0x6a47, 0xbafe },
	{ 0x6a48, 0xbb40 },
	{ 0x6a49, 0xbb41 },
	{ 0x6a4a, 0xbb42 },
	{ 0x6a4b, 0xbb43 },
	{ 0x6a4c, 0xbb44 },
	{ 0x6a4d, 0xbb45 },
	{ 0x6a4e, 0xbb46 },
	{ 0x6a4f, 0xbb47 },
	{ 0x6a50, 0xbb48 },
	{ 0x6a51, 0xbb49 },
	{ 0x6a52, 0xbb4a },
	{ 0x6a53, 0xbb4b },
	{ 0x6a54, 0xbb4c },
	{ 0x6a55, 0xbb4d },
	{ 0x6a56, 0xbb4e },
	{ 0x6a57, 0xbb4f },
	{ 0x6a58, 0xbb50 },
	{ 0x6a59, 0xbb51 },
	{ 0x6a5a, 0xbb52 },
	{ 0x6a5b, 0xbb53 },
	{ 0x6a5c, 0xbb54 },
	{ 0x6a5d, 0xbb55 },
	{ 0x6a5e, 0xbb56 },
	{ 0x6a5f, 0xbb57 },
	{ 0x6a60, 0xbb58 },
	{ 0x6a61, 0xbb59 },
	{ 0x6a62, 0xbb5a },
	{ 0x6a63, 0xbb5b },
	{ 0x6a64, 0xbb5c },
	{ 0x6a65, 0xbb5d },
	{ 0x6a66, 0xbb5e },
	{ 0x6a67, 0xbb5f },
	{ 0x6a68, 0xbb60 },
	{ 0x6a69, 0xbb61 },
	{ 0x6a6a, 0xbb62 },
	{ 0x6a6b, 0xbb63 },
	{ 0x6a6c, 0xbb64 },
	{ 0x6a6d, 0xbb65 },
	{ 0x6a6e, 0xbb66 },
	{ 0x6a6f, 0xbb67 },
	{ 0x6a70, 0xbb68 },
	{ 0x6a71, 0xbb69 },
	{ 0x6a72, 0xbb6a },
	{ 0x6a73, 0xbb6b },
	{ 0x6a74, 0xbb6c },
	{ 0x6a75, 0xbb6d },
	{ 0x6a76, 0xbb6e },
	{ 0x6a77, 0xbb6f },
	{ 0x6a78, 0xbb70 },
	{ 0x6a79, 0xbb71 },
	{ 0x6a7a, 0xbb72 },
	{ 0x6a7b, 0xbb73 },
	{ 0x6a7c, 0xbb74 },
	{ 0x6a7d, 0xbb75 },
	{ 0x6a7e, 0xbb76 },
	{ 0x6b21, 0xbb77 },
	{ 0x6b22, 0xbb78 },
	{ 0x6b23, 0xbb79 },
	{ 0x6b24, 0xbb7a },
	{ 0x6b25, 0xbb7b },
	{ 0x6b26, 0xbb7c },
	{ 0x6b27, 0xbb7d },
	{ 0x6b28, 0xbb7e },
	{ 0x6b29, 0xbba1 },
	{ 0x6b2a, 0xbba2 },
	{ 0x6b2b, 0xbba3 },
	{ 0x6b2c, 0xbba4 },
	{ 0x6b2d, 0xbba5 },
	{ 0x6b2e, 0xbba6 },
	{ 0x6b2f, 0xbba7 },
	{ 0x6b30, 0xbba8 },
	{ 0x6b31, 0xbba9 },
	{ 0x6b32, 0xbbaa },
	{ 0x6b33, 0xbbab },
	{ 0x6b34, 0xbbac },
	{ 0x6b35, 0xbbad },
	{ 0x6b36, 0xbbae },
	{ 0x6b37, 0xbbaf },
	{ 0x6b38, 0xbbb0 },
	{ 0x6b39, 0xbbb1 },
	{ 0x6b3a, 0xbbb2 },
	{ 0x6b3b, 0xbbb3 },
	{ 0x6b3c, 0xbbb4 },
	{ 0x6b3d, 0xbbb5 },
	{ 0x6b3e, 0xbbb6 },
	{ 0x6b3f, 0xbbb7 },
	{ 0x6b40, 0xbbb8 },
	{ 0x6b41, 0xbbb9 },
	{ 0x6b42, 0xbbba },
	{ 0x6b43, 0xbbbb },
	{ 0x6b44, 0xbbbc },
	{ 0x6b45, 0xbbbd },
	{ 0x6b46, 0xbbbe },
	{ 0x6b47, 0xbbbf },
	{ 0x6b48, 0xbbc0 },
	{ 0x6b49, 0xbbc1 },
	{ 0x6b4a, 0xbbc2 },
	{ 0x6b4b, 0xbbc3 },
	{ 0x6b4c, 0xbbc4 },
	{ 0x6b4d, 0xbbc5 },
	{ 0x6b4e, 0xbbc6 },
	{ 0x6b4f, 0xbbc7 },
	{ 0x6b50, 0xbe52 },
	{ 0x6b51, 0xbbc8 },
	{ 0x6b52, 0xbbc9 },
	{ 0x6b53, 0xbbca },
	{ 0x6b54, 0xbbcb },
	{ 0x6b55, 0xbbcc },
	{ 0x6b56, 0xbbcd },
	{ 0x6b57, 0xbbce },
	{ 0x6b58, 0xbbcf },
	{ 0x6b59, 0xbbd0 },
	{ 0x6b5a, 0xbbd1 },
	{ 0x6b5b, 0xbbd2 },
	{ 0x6b5c, 0xbbd3 },
	{ 0x6b5d, 0xbbd4 },
	{ 0x6b5e, 0xbbd5 },
	{ 0x6b5f, 0xbbd6 },
	{ 0x6b60, 0xbbd7 },
	{ 0x6b61, 0xbbd8 },
	{ 0x6b62, 0xbbd9 },
	{ 0x6b63, 0xbbda },
	{ 0x6b64, 0xbbdb },
	{ 0x6b65, 0xbbdc },
	{ 0x6b66, 0xbbdd },
	{ 0x6b67, 0xbbde },
	{ 0x6b68, 0xbbdf },
	{ 0x6b69, 0xbbe0 },
	{ 0x6b6a, 0xbbe1 },
	{ 0x6b6b, 0xbbe2 },
	{ 0x6b6c, 0xbbe3 },
	{ 0x6b6d, 0xbbe4 },
	{ 0x6b6e, 0xbbe5 },
	{ 0x6b6f, 0xbbe6 },
	{ 0x6b70, 0xbbe7 },
	{ 0x6b71, 0xbbe8 },
	{ 0x6b72, 0xbbe9 },
	{ 0x6b73, 0xbbea },
	{ 0x6b74, 0xbbeb },
	{ 0x6b75, 0xbbec },
	{ 0x6b76, 0xbbed },
	{ 0x6b77, 0xbbee },
	{ 0x6b78, 0xbbef },
	{ 0x6b79, 0xbbf0 },
	{ 0x6b7a, 0xbbf1 },
	{ 0x6b7b, 0xbbf2 },
	{ 0x6b7c, 0xbbf3 },
	{ 0x6b7d, 0xbbf4 },
	{ 0x6b7e, 0xbbf5 },
	{ 0x6c21, 0xbbf6 },
	{ 0x6c22, 0xbbf7 },
	{ 0x6c23, 0xbbf8 },
	{ 0x6c24, 0xbbf9 },
	{ 0x6c25, 0xbbfa },
	{ 0x6c26, 0xbbfb },
	{ 0x6c27, 0xbbfc },
	{ 0x6c28, 0xbbfd },
	{ 0x6c29, 0xbbfe },
	{ 0x6c2a, 0xbc40 },
	{ 0x6c2b, 0xbc41 },
	{ 0x6c2c, 0xbc42 },
	{ 0x6c2d, 0xbc43 },
	{ 0x6c2e, 0xbc44 },
	{ 0x6c2f, 0xbc45 },
	{ 0x6c30, 0xbc46 },
	{ 0x6c31, 0xbc47 },
	{ 0x6c32, 0xbc48 },
	{ 0x6c33, 0xbc49 },
	{ 0x6c34, 0xbc4a },
	{ 0x6c35, 0xbc4b },
	{ 0x6c36, 0xbc4c },
	{ 0x6c37, 0xbc4d },
	{ 0x6c38, 0xbc4e },
	{ 0x6c39, 0xbc4f },
	{ 0x6c3a, 0xbc50 },
	{ 0x6c3b, 0xbc51 },
	{ 0x6c3c, 0xbc52 },
	{ 0x6c3d, 0xbc53 },
	{ 0x6c3e, 0xbc54 },
	{ 0x6c3f, 0xbc55 },
	{ 0x6c40, 0xbc56 },
	{ 0x6c41, 0xbc57 },
	{ 0x6c42, 0xbc58 },
	{ 0x6c43, 0xbc59 },
	{ 0x6c44, 0xbc5a },
	{ 0x6c45, 0xbc5b },
	{ 0x6c46, 0xbc5c },
	{ 0x6c47, 0xbc5d },
	{ 0x6c48, 0xbc5e },
	{ 0x6c49, 0xbc5f },
	{ 0x6c4a, 0xbc60 },
	{ 0x6c4b, 0xbc61 },
	{ 0x6c4c, 0xbc62 },
	{ 0x6c4d, 0xbc63 },
	{ 0x6c4e, 0xbc64 },
	{ 0x6c4f, 0xbc65 },
	{ 0x6c50, 0xbc66 },
	{ 0x6c51, 0xbc67 },
	{ 0x6c52, 0xbc68 },
	{ 0x6c53, 0xbc69 },
	{ 0x6c54, 0xbc6a },
	{ 0x6c55, 0xbc6b },
	{ 0x6c56, 0xbc6c },
	{ 0x6c57, 0xbc6d },
	{ 0x6c58, 0xbc6e },
	{ 0x6c59, 0xbc6f },
	{ 0x6c5a, 0xbc70 },
	{ 0x6c5b, 0xbc71 },
	{ 0x6c5c, 0xbc72 },
	{ 0x6c5d, 0xbc73 },
	{ 0x6c5e, 0xbc74 },
	{ 0x6c5f, 0xbc75 },
	{ 0x6c60, 0xbc76 },
	{ 0x6c61, 0xbc77 },
	{ 0x6c62, 0xbc78 },
	{ 0x6c63, 0xbc79 },
	{ 0x6c64, 0xbc7a },
	{ 0x6c65, 0xbc7b },
	{ 0x6c66, 0xbc7c },
	{ 0x6c67, 0xbc7d },
	{ 0x6c68, 0xbc7e },
	{ 0x6c69, 0xbca1 },
	{ 0x6c6a, 0xbca2 },
	{ 0x6c6b, 0xbca3 },
	{ 0x6c6c, 0xbca4 },
	{ 0x6c6d, 0xbca5 },
	{ 0x6c6e, 0xbca6 },
	{ 0x6c6f, 0xbca7 },
	{ 0x6c70, 0xbca8 },
	{ 0x6c71, 0xbca9 },
	{ 0x6c72, 0xbcaa },
	{ 0x6c73, 0xbcab },
	{ 0x6c74, 0xbcac },
	{ 0x6c75, 0xbcad },
	{ 0x6c76, 0xbcae },
	{ 0x6c77, 0xbcaf },
	{ 0x6c78, 0xbcb0 },
	{ 0x6c79, 0xbcb1 },
	{ 0x6c7a, 0xbcb2 },
	{ 0x6c7b, 0xbcb3 },
	{ 0x6c7c, 0xbcb4 },
	{ 0x6c7d, 0xbcb5 },
	{ 0x6c7e, 0xbcb6 },
	{ 0x6d21, 0xbcb7 },
	{ 0x6d22, 0xbcb8 },
	{ 0x6d23, 0xbcb9 },
	{ 0x6d24, 0xbcba },
	{ 0x6d25, 0xbcbb },
	{ 0x6d26, 0xbcbc },
	{ 0x6d27, 0xbcbd },
	{ 0x6d28, 0xbcbe },
	{ 0x6d29, 0xbcbf },
	{ 0x6d2a, 0xbcc0 },
	{ 0x6d2b, 0xbcc1 },
	{ 0x6d2c, 0xbcc2 },
	{ 0x6d2d, 0xbcc3 },
	{ 0x6d2e, 0xbcc4 },
	{ 0x6d2f, 0xbcc5 },
	{ 0x6d30, 0xbcc6 },
	{ 0x6d31, 0xbcc7 },
	{ 0x6d32, 0xbcc8 },
	{ 0x6d33, 0xbcc9 },
	{ 0x6d34, 0xbcca },
	{ 0x6d35, 0xbccb },
	{ 0x6d36, 0xbccc },
	{ 0x6d37, 0xbccd },
	{ 0x6d38, 0xbcce },
	{ 0x6d39, 0xbccf },
	{ 0x6d3a, 0xbcd0 },
	{ 0x6d3b, 0xbcd1 },
	{ 0x6d3c, 0xbcd2 },
	{ 0x6d3d, 0xbcd3 },
	{ 0x6d3e, 0xbcd4 },
	{ 0x6d3f, 0xbcd5 },
	{ 0x6d40, 0xbcd6 },
	{ 0x6d41, 0xbcd7 },
	{ 0x6d42, 0xbcd8 },
	{ 0x6d43, 0xbcd9 },
	{ 0x6d44, 0xbcda },
	{ 0x6d45, 0xbcdb },
	{ 0x6d46, 0xbcdc },
	{ 0x6d47, 0xbcdd },
	{ 0x6d48, 0xbcde },
	{ 0x6d49, 0xbcdf },
	{ 0x6d4a, 0xbce0 },
	{ 0x6d4b, 0xbce1 },
	{ 0x6d4c, 0xbce2 },
	{ 0x6d4d, 0xbce3 },
	{ 0x6d4e, 0xbce4 },
	{ 0x6d4f, 0xbce5 },
	{ 0x6d50, 0xbce6 },
	{ 0x6d51, 0xbce7 },
	{ 0x6d52, 0xbce8 },
	{ 0x6d53, 0xbce9 },
	{ 0x6d54, 0xbcea },
	{ 0x6d55, 0xbceb },
	{ 0x6d56, 0xbcec },
	{ 0x6d57, 0xbced },
	{ 0x6d58, 0xbcee },
	{ 0x6d59, 0xbcef },
	{ 0x6d5a, 0xbcf0 },
	{ 0x6d5b, 0xbcf1 },
	{ 0x6d5c, 0xbcf2 },
	{ 0x6d5d, 0xbcf3 },
	{ 0x6d5e, 0xbcf4 },
	{ 0x6d5f, 0xbcf5 },
	{ 0x6d60, 0xbcf6 },
	{ 0x6d61, 0xbcf7 },
	{ 0x6d62, 0xbcf8 },
	{ 0x6d63, 0xbcf9 },
	{ 0x6d64, 0xbcfa },
	{ 0x6d65, 0xbcfb },
	{ 0x6d66, 0xbcfc },
	{ 0x6d67, 0xbcfd },
	{ 0x6d68, 0xbcfe },
	{ 0x6d69, 0xbd40 },
	{ 0x6d6a, 0xbd41 },
	{ 0x6d6b, 0xbd42 },
	{ 0x6d6c, 0xbd43 },
	{ 0x6d6d, 0xbd44 },
	{ 0x6d6e, 0xbd45 },
	{ 0x6d6f, 0xbd46 },
	{ 0x6d70, 0xbd47 },
	{ 0x6d71, 0xbd48 },
	{ 0x6d72, 0xbd49 },
	{ 0x6d73, 0xbd4a },
	{ 0x6d74, 0xbd4b },
	{ 0x6d75, 0xbd4c },
	{ 0x6d76, 0xbd4d },
	{ 0x6d77, 0xbd4e },
	{ 0x6d78, 0xbd4f },
	{ 0x6d79, 0xbd50 },
	{ 0x6d7a, 0xbd51 },
	{ 0x6d7b, 0xbd52 },
	{ 0x6d7c, 0xbd53 },
	{ 0x6d7d, 0xbd54 },
	{ 0x6d7e, 0xbd55 },
	{ 0x6e21, 0xbd56 },
	{ 0x6e22, 0xbd57 },
	{ 0x6e23, 0xbd58 },
	{ 0x6e24, 0xbd59 },
	{ 0x6e25, 0xbd5a },
	{ 0x6e26, 0xbd5b },
	{ 0x6e27, 0xbd5c },
	{ 0x6e28, 0xbd5d },
	{ 0x6e29, 0xbd5e },
	{ 0x6e2a, 0xbd5f },
	{ 0x6e2b, 0xbd60 },
	{ 0x6e2c, 0xbd61 },
	{ 0x6e2d, 0xbd62 },
	{ 0x6e2e, 0xbd63 },
	{ 0x6e2f, 0xbd64 },
	{ 0x6e30, 0xbd65 },
	{ 0x6e31, 0xbd66 },
	{ 0x6e32, 0xbd67 },
	{ 0x6e33, 0xbd68 },
	{ 0x6e34, 0xbd69 },
	{ 0x6e35, 0xbd6a },
	{ 0x6e36, 0xbd6b },
	{ 0x6e37, 0xbd6c },
	{ 0x6e38, 0xbd6d },
	{ 0x6e39, 0xbd6e },
	{ 0x6e3a, 0xbd6f },
	{ 0x6e3b, 0xbd70 },
	{ 0x6e3c, 0xbd71 },
	{ 0x6e3d, 0xbd72 },
	{ 0x6e3e, 0xbd73 },
	{ 0x6e3f, 0xbd74 },
	{ 0x6e40, 0xbd75 },
	{ 0x6e41, 0xbd76 },
	{ 0x6e42, 0xbd77 },
	{ 0x6e43, 0xbd78 },
	{ 0x6e44, 0xbd79 },
	{ 0x6e45, 0xbd7a },
	{ 0x6e46, 0xbd7b },
	{ 0x6e47, 0xbd7c },
	{ 0x6e48, 0xbd7d },
	{ 0x6e49, 0xbd7e },
	{ 0x6e4a, 0xbda1 },
	{ 0x6e4b, 0xbda2 },
	{ 0x6e4c, 0xbda3 },
	{ 0x6e4d, 0xbda4 },
	{ 0x6e4e, 0xbda5 },
	{ 0x6e4f, 0xbda6 },
	{ 0x6e50, 0xbda7 },
	{ 0x6e51, 0xbda8 },
	{ 0x6e52, 0xbda9 },
	{ 0x6e53, 0xbdaa },
	{ 0x6e54, 0xbdab },
	{ 0x6e55, 0xbdac },
	{ 0x6e56, 0xbdad },
	{ 0x6e57, 0xbdae },
	{ 0x6e58, 0xbdaf },
	{ 0x6e59, 0xbdb0 },
	{ 0x6e5a, 0xbdb1 },
	{ 0x6e5b, 0xbdb2 },
	{ 0x6e5c, 0xbdb3 },
	{ 0x6e5d, 0xbdb4 },
	{ 0x6e5e, 0xbdb5 },
	{ 0x6e5f, 0xbdb6 },
	{ 0x6e60, 0xbdb7 },
	{ 0x6e61, 0xbdb8 },
	{ 0x6e62, 0xbdb9 },
	{ 0x6e63, 0xbdba },
	{ 0x6e64, 0xbdbb },
	{ 0x6e65, 0xbdbc },
	{ 0x6e66, 0xbdbd },
	{ 0x6e67, 0xbdbe },
	{ 0x6e68, 0xbdbf },
	{ 0x6e69, 0xbdc0 },
	{ 0x6e6a, 0xbdc1 },
	{ 0x6e6b, 0xbdc2 },
	{ 0x6e6c, 0xbdc3 },
	{ 0x6e6d, 0xbdc4 },
	{ 0x6e6e, 0xbdc5 },
	{ 0x6e6f, 0xbdc6 },
	{ 0x6e70, 0xbdc7 },
	{ 0x6e71, 0xbdc8 },
	{ 0x6e72, 0xbdc9 },
	{ 0x6e73, 0xbdca },
	{ 0x6e74, 0xbdcb },
	{ 0x6e75, 0xbdcc },
	{ 0x6e76, 0xbdcd },
	{ 0x6e77, 0xbdce },
	{ 0x6e78, 0xbdcf },
	{ 0x6e79, 0xbdd0 },
	{ 0x6e7a, 0xbdd1 },
	{ 0x6e7b, 0xbdd2 },
	{ 0x6e7c, 0xbdd3 },
	{ 0x6e7d, 0xbdd4 },
	{ 0x6e7e, 0xbdd5 },
	{ 0x6f21, 0xbdd6 },
	{ 0x6f22, 0xbdd7 },
	{ 0x6f23, 0xbdd8 },
	{ 0x6f24, 0xbdd9 },
	{ 0x6f25, 0xbdda },
	{ 0x6f26, 0xbddb },
	{ 0x6f27, 0xbddc },
	{ 0x6f28, 0xbddd },
	{ 0x6f29, 0xbdde },
	{ 0x6f2a, 0xbddf },
	{ 0x6f2b, 0xbde0 },
	{ 0x6f2c, 0xbde1 },
	{ 0x6f2d, 0xbde2 },
	{ 0x6f2e, 0xbde3 },
	{ 0x6f2f, 0xbde4 },
	{ 0x6f30, 0xbde5 },
	{ 0x6f31, 0xbde6 },
	{ 0x6f32, 0xbde7 },
	{ 0x6f33, 0xbde8 },
	{ 0x6f34, 0xbde9 },
	{ 0x6f35, 0xbdea },
	{ 0x6f36, 0xbdeb },
	{ 0x6f37, 0xbdec },
	{ 0x6f38, 0xbded },
	{ 0x6f39, 0xbdee },
	{ 0x6f3a, 0xbdef },
	{ 0x6f3b, 0xbdf0 },
	{ 0x6f3c, 0xbdf1 },
	{ 0x6f3d, 0xbdf2 },
	{ 0x6f3e, 0xbdf3 },
	{ 0x6f3f, 0xbdf4 },
	{ 0x6f40, 0xbdf5 },
	{ 0x6f41, 0xbdf6 },
	{ 0x6f42, 0xbdf7 },
	{ 0x6f43, 0xbdf8 },
	{ 0x6f44, 0xbdf9 },
	{ 0x6f45, 0xbdfa },
	{ 0x6f46, 0xbdfb },
	{ 0x6f47, 0xbdfc },
	{ 0x6f48, 0xbdfd },
	{ 0x6f49, 0xbdfe },
	{ 0x6f4a, 0xbe40 },
	{ 0x6f4b, 0xbe41 },
	{ 0x6f4c, 0xbe42 },
	{ 0x6f4d, 0xbe43 },
	{ 0x6f4e, 0xbe44 },
	{ 0x6f4f, 0xbe45 },
	{ 0x6f50, 0xbe46 },
	{ 0x6f51, 0xbe47 },
	{ 0x6f52, 0xbe48 },
	{ 0x6f53, 0xbe49 },
	{ 0x6f54, 0xbe4a },
	{ 0x6f55, 0xbe4b },
	{ 0x6f56, 0xbe4c },
	{ 0x6f57, 0xbe4d },
	{ 0x6f58, 0xbe4e },
	{ 0x6f59, 0xbe4f },
	{ 0x6f5a, 0xbe50 },
	{ 0x6f5b, 0xbe51 },
	{ 0x6f5c, 0xbe53 },
	{ 0x6f5d, 0xbe54 },
	{ 0x6f5e, 0xbe55 },
	{ 0x6f5f, 0xbe56 },
	{ 0x6f60, 0xbe57 },
	{ 0x6f61, 0xbe58 },
	{ 0x6f62, 0xbe59 },
	{ 0x6f63, 0xbe5a },
	{ 0x6f64, 0xbe5b },
	{ 0x6f65, 0xbe5c },
	{ 0x6f66, 0xbe5d },
	{ 0x6f67, 0xbe5e },
	{ 0x6f68, 0xbe5f },
	{ 0x6f69, 0xbe60 },
	{ 0x6f6a, 0xbe61 },
	{ 0x6f6b, 0xbe62 },
	{ 0x6f6c, 0xbe63 },
	{ 0x6f6d, 0xbe64 },
	{ 0x6f6e, 0xbe65 },
	{ 0x6f6f, 0xbe66 },
	{ 0x6f70, 0xbe67 },
	{ 0x6f71, 0xbe68 },
	{ 0x6f72, 0xbe69 },
	{ 0x6f73, 0xbe6a },
	{ 0x6f74, 0xbe6b },
	{ 0x6f75, 0xbe6c },
	{ 0x6f76, 0xbe6d },
	{ 0x6f77, 0xbe6e },
	{ 0x6f78, 0xbe6f },
	{ 0x6f79, 0xbe70 },
	{ 0x6f7a, 0xbe71 },
	{ 0x6f7b, 0xbe72 },
	{ 0x6f7c, 0xbe73 },
	{ 0x6f7d, 0xbe74 },
	{ 0x6f7e, 0xbe75 },
	{ 0x7021, 0xbe76 },
	{ 0x7022, 0xbe77 },
	{ 0x7023, 0xbe78 },
	{ 0x7024, 0xbe79 },
	{ 0x7025, 0xbe7a },
	{ 0x7026, 0xbe7b },
	{ 0x7027, 0xbe7c },
	{ 0x7028, 0xbe7d },
	{ 0x7029, 0xbe7e },
	{ 0x702a, 0xbea1 },
	{ 0x702b, 0xbea2 },
	{ 0x702c, 0xbea3 },
	{ 0x702d, 0xbea4 },
	{ 0x702e, 0xbea5 },
	{ 0x702f, 0xbea6 },
	{ 0x7030, 0xbea7 },
	{ 0x7031, 0xbea8 },
	{ 0x7032, 0xbea9 },
	{ 0x7033, 0xbeaa },
	{ 0x7034, 0xbeab },
	{ 0x7035, 0xbeac },
	{ 0x7036, 0xbead },
	{ 0x7037, 0xbeae },
	{ 0x7038, 0xbeaf },
	{ 0x7039, 0xbeb0 },
	{ 0x703a, 0xbeb1 },
	{ 0x703b, 0xbeb2 },
	{ 0x703c, 0xbeb3 },
	{ 0x703d, 0xbeb4 },
	{ 0x703e, 0xbeb5 },
	{ 0x703f, 0xbeb6 },
	{ 0x7040, 0xbeb7 },
	{ 0x7041, 0xbeb8 },
	{ 0x7042, 0xbeb9 },
	{ 0x7043, 0xbeba },
	{ 0x7044, 0xbebb },
	{ 0x7045, 0xbebc },
	{ 0x7046, 0xbebd },
	{ 0x7047, 0xbebe },
	{ 0x7048, 0xbebf },
	{ 0x7049, 0xbec0 },
	{ 0x704a, 0xbec1 },
	{ 0x704b, 0xbec2 },
	{ 0x704c, 0xbec3 },
	{ 0x704d, 0xbec4 },
	{ 0x704e, 0xbec5 },
	{ 0x704f, 0xbec6 },
	{ 0x7050, 0xbec7 },
	{ 0x7051, 0xbec8 },
	{ 0x7052, 0xbec9 },
	{ 0x7053, 0xbeca },
	{ 0x7054, 0xbecb },
	{ 0x7055, 0xbecc },
	{ 0x7056, 0xbecd },
	{ 0x7057, 0xbece },
	{ 0x7058, 0xbecf },
	{ 0x7059, 0xbed0 },
	{ 0x705a, 0xbed1 },
	{ 0x705b, 0xbed2 },
	{ 0x705c, 0xbed3 },
	{ 0x705d, 0xbed4 },
	{ 0x705e, 0xbed5 },
	{ 0x705f, 0xbed6 },
	{ 0x7060, 0xbed7 },
	{ 0x7061, 0xbed8 },
	{ 0x7062, 0xbed9 },
	{ 0x7063, 0xbeda },
	{ 0x7064, 0xbedb },
	{ 0x7065, 0xbedc },
	{ 0x7066, 0xbedd },
	{ 0x7067, 0xbede },
	{ 0x7068, 0xbedf },
	{ 0x7069, 0xbee0 },
	{ 0x706a, 0xbee1 },
	{ 0x706b, 0xbee2 },
	{ 0x706c, 0xbee3 },
	{ 0x706d, 0xbee4 },
	{ 0x706e, 0xbee5 },
	{ 0x706f, 0xbee6 },
	{ 0x7070, 0xbee7 },
	{ 0x7071, 0xbee8 },
	{ 0x7072, 0xbee9 },
	{ 0x7073, 0xbeea },
	{ 0x7074, 0xbeeb },
	{ 0x7075, 0xbeec },
	{ 0x7076, 0xbeed },
	{ 0x7077, 0xbeee },
	{ 0x7078, 0xbeef },
	{ 0x7079, 0xbef0 },
	{ 0x707a, 0xbef1 },
	{ 0x707b, 0xbef2 },
	{ 0x707c, 0xbef3 },
	{ 0x707d, 0xbef4 },
	{ 0x707e, 0xbef5 },
	{ 0x7121, 0xbef6 },
	{ 0x7122, 0xbef7 },
	{ 0x7123, 0xbef8 },
	{ 0x7124, 0xbef9 },
	{ 0x7125, 0xbefa },
	{ 0x7126, 0xbefb },
	{ 0x7127, 0xbefc },
	{ 0x7128, 0xbefd },
	{ 0x7129, 0xbefe },
	{ 0x712a, 0xbf40 },
	{ 0x712b, 0xbf41 },
	{ 0x712c, 0xbf42 },
	{ 0x712d, 0xbf43 },
	{ 0x712e, 0xbf44 },
	{ 0x712f, 0xbf45 },
	{ 0x7130, 0xbf46 },
	{ 0x7131, 0xbf47 },
	{ 0x7132, 0xbf48 },
	{ 0x7133, 0xbf49 },
	{ 0x7134, 0xbf4a },
	{ 0x7135, 0xbf4b },
	{ 0x7136, 0xbf4c },
	{ 0x7137, 0xbf4d },
	{ 0x7138, 0xbf4e },
	{ 0x7139, 0xbf4f },
	{ 0x713a, 0xbf50 },
	{ 0x713b, 0xbf51 },
	{ 0x713c, 0xbf52 },
	{ 0x713d, 0xbf53 },
	{ 0x713e, 0xbf54 },
	{ 0x713f, 0xbf55 },
	{ 0x7140, 0xbf56 },
	{ 0x7141, 0xbf57 },
	{ 0x7142, 0xbf58 },
	{ 0x7143, 0xbf59 },
	{ 0x7144, 0xbf5a },
	{ 0x7145, 0xbf5b },
	{ 0x7146, 0xbf5c },
	{ 0x7147, 0xbf5d },
	{ 0x7148, 0xbf5e },
	{ 0x7149, 0xbf5f },
	{ 0x714a, 0xbf60 },
	{ 0x714b, 0xbf61 },
	{ 0x714c, 0xbf62 },
	{ 0x714d, 0xbf63 },
	{ 0x714e, 0xbf64 },
	{ 0x714f, 0xbf65 },
	{ 0x7150, 0xbf66 },
	{ 0x7151, 0xbf67 },
	{ 0x7152, 0xbf68 },
	{ 0x7153, 0xbf69 },
	{ 0x7154, 0xbf6a },
	{ 0x7155, 0xbf6b },
	{ 0x7156, 0xbf6c },
	{ 0x7157, 0xbf6d },
	{ 0x7158, 0xbf6e },
	{ 0x7159, 0xbf6f },
	{ 0x715a, 0xbf70 },
	{ 0x715b, 0xbf71 },
	{ 0x715c, 0xbf72 },
	{ 0x715d, 0xbf73 },
	{ 0x715e, 0xbf74 },
	{ 0x715f, 0xbf75 },
	{ 0x7160, 0xbf76 },
	{ 0x7161, 0xbf77 },
	{ 0x7162, 0xbf78 },
	{ 0x7163, 0xbf79 },
	{ 0x7164, 0xbf7a },
	{ 0x7165, 0xbf7b },
	{ 0x7166, 0xbf7c },
	{ 0x7167, 0xbf7d },
	{ 0x7168, 0xbf7e },
	{ 0x7169, 0xbfa1 },
	{ 0x716a, 0xbfa2 },
	{ 0x716b, 0xbfa3 },
	{ 0x716c, 0xbfa4 },
	{ 0x716d, 0xbfa5 },
	{ 0x716e, 0xbfa6 },
	{ 0x716f, 0xbfa7 },
	{ 0x7170, 0xbfa8 },
	{ 0x7171, 0xbfa9 },
	{ 0x7172, 0xbfaa },
	{ 0x7173, 0xbfab },
	{ 0x7174, 0xbfac },
	{ 0x7175, 0xbfad },
	{ 0x7176, 0xbfae },
	{ 0x7177, 0xbfaf },
	{ 0x7178, 0xbfb0 },
	{ 0x7179, 0xbfb1 },
	{ 0x717a, 0xbfb2 },
	{ 0x717b, 0xbfb3 },
	{ 0x717c, 0xbfb4 },
	{ 0x717d, 0xbfb5 },
	{ 0x717e, 0xbfb6 },
	{ 0x7221, 0xbfb7 },
	{ 0x7222, 0xbfb8 },
	{ 0x7223, 0xbfb9 },
	{ 0x7224, 0xbfba },
	{ 0x7225, 0xbfbb },
	{ 0x7226, 0xbfbc },
	{ 0x7227, 0xbfbd },
	{ 0x7228, 0xbfbe },
	{ 0x7229, 0xbfbf },
	{ 0x722a, 0xbfc0 },
	{ 0x722b, 0xbfc1 },
	{ 0x722c, 0xbfc2 },
	{ 0x722d, 0xbfc3 },
	{ 0x722e, 0xbfc4 },
	{ 0x722f, 0xbfc5 },
	{ 0x7230, 0xbfc6 },
	{ 0x7231, 0xbfc7 },
	{ 0x7232, 0xbfc8 },
	{ 0x7233, 0xbfc9 },
	{ 0x7234, 0xbfca },
	{ 0x7235, 0xbfcb },
	{ 0x7236, 0xbfcc },
	{ 0x7237, 0xbfcd },
	{ 0x7238, 0xbfce },
	{ 0x7239, 0xbfcf },
	{ 0x723a, 0xbfd0 },
	{ 0x723b, 0xbfd1 },
	{ 0x723c, 0xbfd2 },
	{ 0x723d, 0xbfd3 },
	{ 0x723e, 0xbfd4 },
	{ 0x723f, 0xbfd5 },
	{ 0x7240, 0xbfd6 },
	{ 0x7241, 0xbfd7 },
	{ 0x7242, 0xbfd8 },
	{ 0x7243, 0xbfd9 },
	{ 0x7244, 0xbfda },
	{ 0x7245, 0xbfdb },
	{ 0x7246, 0xbfdc },
	{ 0x7247, 0xbfdd },
	{ 0x7248, 0xbfde },
	{ 0x7249, 0xbfdf },
	{ 0x724a, 0xbfe0 },
	{ 0x724b, 0xbfe1 },
	{ 0x724c, 0xbfe2 },
	{ 0x724d, 0xbfe3 },
	{ 0x724e, 0xbfe4 },
	{ 0x724f, 0xbfe5 },
	{ 0x7250, 0xbfe6 },
	{ 0x7251, 0xbfe7 },
	{ 0x7252, 0xbfe8 },
	{ 0x7253, 0xbfe9 },
	{ 0x7254, 0xbfea },
	{ 0x7255, 0xbfeb },
	{ 0x7256, 0xbfec },
	{ 0x7257, 0xbfed },
	{ 0x7258, 0xbfee },
	{ 0x7259, 0xbfef },
	{ 0x725a, 0xbff0 },
	{ 0x725b, 0xbff1 },
	{ 0x725c, 0xbff2 },
	{ 0x725d, 0xbff3 },
	{ 0x725e, 0xbff4 },
	{ 0x725f, 0xbff5 },
	{ 0x7260, 0xbff6 },
	{ 0x7261, 0xbff7 },
	{ 0x7262, 0xbff8 },
	{ 0x7263, 0xbff9 },
	{ 0x7264, 0xbffa },
	{ 0x7265, 0xbffb },
	{ 0x7266, 0xbffc },
	{ 0x7267, 0xbffd },
	{ 0x7268, 0xbffe },
	{ 0x7269, 0xc040 },
	{ 0x726a, 0xc041 },
	{ 0x726b, 0xc042 },
	{ 0x726c, 0xc043 },
	{ 0x726d, 0xc044 },
	{ 0x726e, 0xc045 },
	{ 0x726f, 0xc046 },
	{ 0x7270, 0xc047 },
	{ 0x7271, 0xc048 },
	{ 0x7272, 0xc049 },
	{ 0x7273, 0xc04a },
	{ 0x7274, 0xc04b },
	{ 0x7275, 0xc04c },
	{ 0x7276, 0xc04d },
	{ 0x7277, 0xc04e },
	{ 0x7278, 0xc04f },
	{ 0x7279, 0xc050 },
	{ 0x727a, 0xc051 },
	{ 0x727b, 0xc052 },
	{ 0x727c, 0xc053 },
	{ 0x727d, 0xc054 },
	{ 0x727e, 0xc055 },
	{ 0x7321, 0xc056 },
	{ 0x7322, 0xc057 },
	{ 0x7323, 0xc058 },
	{ 0x7324, 0xc059 },
	{ 0x7325, 0xc05a },
	{ 0x7326, 0xc05b },
	{ 0x7327, 0xc05c },
	{ 0x7328, 0xc05d },
	{ 0x7329, 0xc05e },
	{ 0x732a, 0xc05f },
	{ 0x732b, 0xc060 },
	{ 0x732c, 0xc061 },
	{ 0x732d, 0xc062 },
	{ 0x732e, 0xc063 },
	{ 0x732f, 0xc064 },
	{ 0x7330, 0xc065 },
	{ 0x7331, 0xc066 },
	{ 0x7332, 0xc067 },
	{ 0x7333, 0xc068 },
	{ 0x7334, 0xc069 },
	{ 0x7335, 0xc06a },
	{ 0x7336, 0xc06b },
	{ 0x7337, 0xc06c },
	{ 0x7338, 0xc06d },
	{ 0x7339, 0xc06e },
	{ 0x733a, 0xc06f },
	{ 0x733b, 0xc070 },
	{ 0x733c, 0xc071 },
	{ 0x733d, 0xc072 },
	{ 0x733e, 0xc073 },
	{ 0x733f, 0xc074 },
	{ 0x7340, 0xc075 },
	{ 0x7341, 0xc076 },
	{ 0x7342, 0xc077 },
	{ 0x7343, 0xc078 },
	{ 0x7344, 0xc079 },
	{ 0x7345, 0xc07a },
	{ 0x7346, 0xc07b },
	{ 0x7347, 0xc07c },
	{ 0x7348, 0xc07d },
	{ 0x7349, 0xc07e },
	{ 0x734a, 0xc0a1 },
	{ 0x734b, 0xc0a2 },
	{ 0x734c, 0xc0a3 },
	{ 0x734d, 0xc0a4 },
	{ 0x734e, 0xc0a5 },
	{ 0x734f, 0xc0a6 },
	{ 0x7350, 0xc0a7 },
	{ 0x7351, 0xc0a8 },
	{ 0x7352, 0xc0a9 },
	{ 0x7353, 0xc0aa },
	{ 0x7354, 0xc0ab },
	{ 0x7355, 0xc0ac },
	{ 0x7356, 0xc0ad },
	{ 0x7357, 0xc0ae },
	{ 0x7358, 0xc0af },
	{ 0x7359, 0xc0b0 },
	{ 0x735a, 0xc0b1 },
	{ 0x735b, 0xc0b2 },
	{ 0x735c, 0xc0b3 },
	{ 0x735d, 0xc0b4 },
	{ 0x735e, 0xc0b5 },
	{ 0x735f, 0xc0b6 },
	{ 0x7360, 0xc0b7 },
	{ 0x7361, 0xc0b8 },
	{ 0x7362, 0xc0b9 },
	{ 0x7363, 0xc0ba },
	{ 0x7364, 0xc0bb },
	{ 0x7365, 0xc0bc },
	{ 0x7366, 0xc0bd },
	{ 0x7367, 0xc0be },
	{ 0x7368, 0xc0bf },
	{ 0x7369, 0xc0c0 },
	{ 0x736a, 0xc0c1 },
	{ 0x736b, 0xc0c2 },
	{ 0x736c, 0xc0c3 },
	{ 0x736d, 0xc0c4 },
	{ 0x736e, 0xc0c5 },
	{ 0x736f, 0xc0c6 },
	{ 0x7370, 0xc0c7 },
	{ 0x7371, 0xc0c8 },
	{ 0x7372, 0xc0c9 },
	{ 0x7373, 0xc0ca },
	{ 0x7374, 0xc0cb },
	{ 0x7375, 0xc0cc },
	{ 0x7376, 0xc0cd },
	{ 0x7377, 0xc0ce },
	{ 0x7378, 0xc0cf },
	{ 0x7379, 0xc0d0 },
	{ 0x737a, 0xc0d1 },
	{ 0x737b, 0xc0d2 },
	{ 0x737c, 0xc0d3 },
	{ 0x737d, 0xc0d4 },
	{ 0x737e, 0xc0d5 },
	{ 0x7421, 0xc0d6 },
	{ 0x7422, 0xc0d7 },
	{ 0x7423, 0xc0d8 },
	{ 0x7424, 0xc0d9 },
	{ 0x7425, 0xc0da },
	{ 0x7426, 0xc0db },
	{ 0x7427, 0xc0dc },
	{ 0x7428, 0xc0dd },
	{ 0x7429, 0xc0de },
	{ 0x742a, 0xc0df },
	{ 0x742b, 0xc0e0 },
	{ 0x742c, 0xc0e1 },
	{ 0x742d, 0xc0e2 },
	{ 0x742e, 0xc0e3 },
	{ 0x742f, 0xc0e4 },
	{ 0x7430, 0xc0e5 },
	{ 0x7431, 0xc0e6 },
	{ 0x7432, 0xc0e7 },
	{ 0x7433, 0xc0e8 },
	{ 0x7434, 0xc0e9 },
	{ 0x7435, 0xc0ea },
	{ 0x7436, 0xc0eb },
	{ 0x7437, 0xc0ec },
	{ 0x7438, 0xc0ed },
	{ 0x7439, 0xc0ee },
	{ 0x743a, 0xc0ef },
	{ 0x743b, 0xc0f0 },
	{ 0x743c, 0xc0f1 },
	{ 0x743d, 0xc0f2 },
	{ 0x743e, 0xc0f3 },
	{ 0x743f, 0xc0f4 },
	{ 0x7440, 0xc0f5 },
	{ 0x7441, 0xc0f6 },
	{ 0x7442, 0xc0f7 },
	{ 0x7443, 0xc0f8 },
	{ 0x7444, 0xc0f9 },
	{ 0x7445, 0xc0fa },
	{ 0x7446, 0xc0fb },
	{ 0x7447, 0xc0fc },
	{ 0x7448, 0xc0fd },
	{ 0x7449, 0xc0fe },
	{ 0x744a, 0xc140 },
	{ 0x744b, 0xc141 },
	{ 0x744c, 0xc142 },
	{ 0x744d, 0xc143 },
	{ 0x744e, 0xc144 },
	{ 0x744f, 0xc145 },
	{ 0x7450, 0xc146 },
	{ 0x7451, 0xc147 },
	{ 0x7452, 0xc148 },
	{ 0x7453, 0xc149 },
	{ 0x7454, 0xc14a },
	{ 0x7455, 0xc14b },
	{ 0x7456, 0xc14c },
	{ 0x7457, 0xc14d },
	{ 0x7458, 0xc14e },
	{ 0x7459, 0xc14f },
	{ 0x745a, 0xc150 },
	{ 0x745b, 0xc151 },
	{ 0x745c, 0xc152 },
	{ 0x745d, 0xc153 },
	{ 0x745e, 0xc154 },
	{ 0x745f, 0xc155 },
	{ 0x7460, 0xc156 },
	{ 0x7461, 0xc157 },
	{ 0x7462, 0xc158 },
	{ 0x7463, 0xc159 },
	{ 0x7464, 0xc15a },
	{ 0x7465, 0xc15b },
	{ 0x7466, 0xc15c },
	{ 0x7467, 0xc15d },
	{ 0x7468, 0xc15e },
	{ 0x7469, 0xc15f },
	{ 0x746a, 0xc160 },
	{ 0x746b, 0xc161 },
	{ 0x746c, 0xc162 },
	{ 0x746d, 0xc163 },
	{ 0x746e, 0xc164 },
	{ 0x746f, 0xc165 },
	{ 0x7470, 0xc166 },
	{ 0x7471, 0xc167 },
	{ 0x7472, 0xc168 },
	{ 0x7473, 0xc169 },
	{ 0x7474, 0xc16a },
	{ 0x7475, 0xc16b },
	{ 0x7476, 0xc16c },
	{ 0x7477, 0xc16d },
	{ 0x7478, 0xc16e },
	{ 0x7479, 0xc16f },
	{ 0x747a, 0xc170 },
	{ 0x747b, 0xc171 },
	{ 0x747c, 0xc172 },
	{ 0x747d, 0xc173 },
	{ 0x747e, 0xc174 },
	{ 0x7521, 0xc175 },
	{ 0x7522, 0xc176 },
	{ 0x7523, 0xc177 },
	{ 0x7524, 0xc178 },
	{ 0x7525, 0xc179 },
	{ 0x7526, 0xc17a },
	{ 0x7527, 0xc17b },
	{ 0x7528, 0xc17c },
	{ 0x7529, 0xc17d },
	{ 0x752a, 0xc17e },
	{ 0x752b, 0xc1a1 },
	{ 0x752c, 0xc1a2 },
	{ 0x752d, 0xc1a3 },
	{ 0x752e, 0xc1a4 },
	{ 0x752f, 0xc1a5 },
	{ 0x7530, 0xc1a6 },
	{ 0x7531, 0xc1a7 },
	{ 0x7532, 0xc1a8 },
	{ 0x7533, 0xc1a9 },
	{ 0x7534, 0xc1aa },
	{ 0x7535, 0xc2cb },
	{ 0x7536, 0xc1ab },
	{ 0x7537, 0xc1ac },
	{ 0x7538, 0xc1ad },
	{ 0x7539, 0xc1ae },
	{ 0x753a, 0xc1af },
	{ 0x753b, 0xc1b0 },
	{ 0x753c, 0xc1b1 },
	{ 0x753d, 0xc1b2 },
	{ 0x753e, 0xc1b3 },
	{ 0x753f, 0xc1b4 },
	{ 0x7540, 0xc1b5 },
	{ 0x7541, 0xc1b6 },
	{ 0x7542, 0xc1b7 },
	{ 0x7543, 0xc1b8 },
	{ 0x7544, 0xc1b9 },
	{ 0x7545, 0xc1ba },
	{ 0x7546, 0xc1bb },
	{ 0x7547, 0xc1bc },
	{ 0x7548, 0xc1bd },
	{ 0x7549, 0xc1be },
	{ 0x754a, 0xc1bf },
	{ 0x754b, 0xc1c0 },
	{ 0x754c, 0xc1c1 },
	{ 0x754d, 0xc1c2 },
	{ 0x754e, 0xc1c3 },
	{ 0x754f, 0xc1c4 },
	{ 0x7550, 0xc1c5 },
	{ 0x7551, 0xc1c6 },
	{ 0x7552, 0xc1c7 },
	{ 0x7553, 0xc1c8 },
	{ 0x7554, 0xc1c9 },
	{ 0x7555, 0xc1ca },
	{ 0x7556, 0xc1cb },
	{ 0x7557, 0xc1cc },
	{ 0x7558, 0xc1cd },
	{ 0x7559, 0xc1ce },
	{ 0x755a, 0xc1cf },
	{ 0x755b, 0xc1d0 },
	{ 0x755c, 0xc1d1 },
	{ 0x755d, 0xc1d2 },
	{ 0x755e, 0xc1d3 },
	{ 0x755f, 0xc1d4 },
	{ 0x7560, 0xc1d5 },
	{ 0x7561, 0xc1d6 },
	{ 0x7562, 0xc1d7 },
	{ 0x7563, 0xc1d8 },
	{ 0x7564, 0xc1d9 },
	{ 0x7565, 0xc1da },
	{ 0x7566, 0xc1db },
	{ 0x7567, 0xc1dc },
	{ 0x7568, 0xc1dd },
	{ 0x7569, 0xc1de },
	{ 0x756a, 0xc1df },
	{ 0x756b, 0xc1e0 },
	{ 0x756c, 0xc1e1 },
	{ 0x756d, 0xc1e2 },
	{ 0x756e, 0xc1e3 },
	{ 0x756f, 0xc1e4 },
	{ 0x7570, 0xc1e5 },
	{ 0x7571, 0xc1e6 },
	{ 0x7572, 0xc1e7 },
	{ 0x7573, 0xc1e8 },
	{ 0x7574, 0xc1e9 },
	{ 0x7575, 0xc1ea },
	{ 0x7576, 0xc1eb },
	{ 0x7577, 0xc1ec },
	{ 0x7578, 0xc1ed },
	{ 0x7579, 0xc1ee },
	{ 0x757a, 0xc1ef },
	{ 0x757b, 0xc1f0 },
	{ 0x757c, 0xc1f1 },
	{ 0x757d, 0xc1f2 },
	{ 0x757e, 0xc1f3 },
	{ 0x7621, 0xc1f4 },
	{ 0x7622, 0xc1f5 },
	{ 0x7623, 0xc1f6 },
	{ 0x7624, 0xc1f7 },
	{ 0x7625, 0xc1f8 },
	{ 0x7626, 0xc1f9 },
	{ 0x7627, 0xc1fa },
	{ 0x7628, 0xc1fb },
	{ 0x7629, 0xc1fc },
	{ 0x762a, 0xc1fd },
	{ 0x762b, 0xc1fe },
	{ 0x762c, 0xc240 },
	{ 0x762d, 0xc241 },
	{ 0x762e, 0xc242 },
	{ 0x762f, 0xc243 },
	{ 0x7630, 0xc244 },
	{ 0x7631, 0xc245 },
	{ 0x7632, 0xc246 },
	{ 0x7633, 0xc247 },
	{ 0x7634, 0xc248 },
	{ 0x7635, 0xc249 },
	{ 0x7636, 0xc24a },
	{ 0x7637, 0xc24b },
	{ 0x7638, 0xc24c },
	{ 0x7639, 0xc24d },
	{ 0x763a, 0xc24e },
	{ 0x763b, 0xc24f },
	{ 0x763c, 0xc250 },
	{ 0x763d, 0xc251 },
	{ 0x763e, 0xc252 },
	{ 0x763f, 0xc253 },
	{ 0x7640, 0xc254 },
	{ 0x7641, 0 },
	{ 0x7642, 0xc256 },
	{ 0x7643, 0xc257 },
	{ 0x7644, 0xc258 },
	{ 0x7645, 0xc259 },
	{ 0x7646, 0xc25a },
	{ 0x7647, 0xc25b },
	{ 0x7648, 0xc25c },
	{ 0x7649, 0xc25d },
	{ 0x764a, 0xc25e },
	{ 0x764b, 0xc25f },
	{ 0x764c, 0xc260 },
	{ 0x764d, 0xc261 },
	{ 0x764e, 0xc262 },
	{ 0x764f, 0xc263 },
	{ 0x7650, 0xc264 },
	{ 0x7651, 0xc265 },
	{ 0x7652, 0xc266 },
	{ 0x7653, 0xc267 },
	{ 0x7654, 0xc268 },
	{ 0x7655, 0xc269 },
	{ 0x7656, 0xc26a },
	{ 0x7657, 0xc26b },
	{ 0x7658, 0xc26c },
	{ 0x7659, 0xc26d },
	{ 0x765a, 0xc26e },
	{ 0x765b, 0xc26f },
	{ 0x765c, 0xc270 },
	{ 0x765d, 0xc271 },
	{ 0x765e, 0xc272 },
	{ 0x765f, 0xc273 },
	{ 0x7660, 0xc274 },
	{ 0x7661, 0xc275 },
	{ 0x7662, 0xc276 },
	{ 0x7663, 0xc277 },
	{ 0x7664, 0xc278 },
	{ 0x7665, 0xc279 },
	{ 0x7666, 0xc27a },
	{ 0x7667, 0xc27b },
	{ 0x7668, 0xc27c },
	{ 0x7669, 0xc27d },
	{ 0x766a, 0xc27e },
	{ 0x766b, 0xc2a1 },
	{ 0x766c, 0xc2a2 },
	{ 0x766d, 0xc2a3 },
	{ 0x766e, 0xc2a4 },
	{ 0x766f, 0xc2a5 },
	{ 0x7670, 0xc2a6 },
	{ 0x7671, 0xc2a7 },
	{ 0x7672, 0xc2a8 },
	{ 0x7673, 0xc2a9 },
	{ 0x7674, 0xc2aa },
	{ 0x7675, 0xc2ab },
	{ 0x7676, 0xc2ac },
	{ 0x7677, 0xc2ad },
	{ 0x7678, 0xc2ae },
	{ 0x7679, 0xc2af },
	{ 0x767a, 0xc2b0 },
	{ 0x767b, 0xc2b1 },
	{ 0x767c, 0xc2b2 },
	{ 0x767d, 0xc2b3 },
	{ 0x767e, 0xc2b4 },
	{ 0x7721, 0xc2b5 },
	{ 0x7722, 0xc2b6 },
	{ 0x7723, 0xc2b7 },
	{ 0x7724, 0xc2b8 },
	{ 0x7725, 0xc2b9 },
	{ 0x7726, 0xc2ba },
	{ 0x7727, 0xc2bb },
	{ 0x7728, 0xc2bc },
	{ 0x7729, 0xc2bd },
	{ 0x772a, 0xc2be },
	{ 0x772b, 0xc2bf },
	{ 0x772c, 0xc2c0 },
	{ 0x772d, 0xc2c1 },
	{ 0x772e, 0xc2c2 },
	{ 0x772f, 0xc2c3 },
	{ 0x7730, 0xc2c4 },
	{ 0x7731, 0xc2c5 },
	{ 0x7732, 0xc2c6 },
	{ 0x7733, 0xc2c7 },
	{ 0x7734, 0xc2c8 },
	{ 0x7735, 0xc2c9 },
	{ 0x7736, 0xc2ca },
	{ 0x7737, 0xc2cc },
	{ 0x7738, 0xc2cd },
	{ 0x7739, 0xc2ce },
	{ 0x773a, 0xc2cf },
	{ 0x773b, 0xc2d0 },
	{ 0x773c, 0xc2d1 },
	{ 0x773d, 0xc2d2 },
	{ 0x773e, 0xc2d3 },
	{ 0x773f, 0xc2d4 },
	{ 0x7740, 0xc2d5 },
	{ 0x7741, 0xc2d6 },
	{ 0x7742, 0xc2d7 },
	{ 0x7743, 0xc2d8 },
	{ 0x7744, 0xc2d9 },
	{ 0x7745, 0xc2da },
	{ 0x7746, 0xc2db },
	{ 0x7747, 0xc2dc },
	{ 0x7748, 0xc2dd },
	{ 0x7749, 0xc2de },
	{ 0x774a, 0xc2df },
	{ 0x774b, 0xc2e0 },
	{ 0x774c, 0xc2e1 },
	{ 0x774d, 0xc2e2 },
	{ 0x774e, 0xc2e3 },
	{ 0x774f, 0xc2e4 },
	{ 0x7750, 0xc2e5 },
	{ 0x7751, 0xc2e6 },
	{ 0x7752, 0xc2e7 },
	{ 0x7753, 0xc2e8 },
	{ 0x7754, 0xc2e9 },
	{ 0x7755, 0xc2ea },
	{ 0x7756, 0xc2eb },
	{ 0x7757, 0xc2ec },
	{ 0x7758, 0xc2ed },
	{ 0x7759, 0xc2ee },
	{ 0x775a, 0xc2ef },
	{ 0x775b, 0xc2f0 },
	{ 0x775c, 0xc2f1 },
	{ 0x775d, 0xc2f2 },
	{ 0x775e, 0xc2f3 },
	{ 0x775f, 0xc2f4 },
	{ 0x7760, 0xc2f5 },
	{ 0x7761, 0xc2f6 },
	{ 0x7762, 0xc2f7 },
	{ 0x7763, 0xc2f8 },
	{ 0x7764, 0xc2f9 },
	{ 0x7765, 0xc2fa },
	{ 0x7766, 0xc2fb },
	{ 0x7767, 0xc2fc },
	{ 0x7768, 0xc2fd },
	{ 0x7769, 0xc2fe },
	{ 0x776a, 0xc340 },
	{ 0x776b, 0xc341 },
	{ 0x776c, 0xc342 },
	{ 0x776d, 0xc343 },
	{ 0x776e, 0xc344 },
	{ 0x776f, 0xc345 },
	{ 0x7770, 0xc346 },
	{ 0x7771, 0xc347 },
	{ 0x7772, 0xc348 },
	{ 0x7773, 0xc349 },
	{ 0x7774, 0xc34a },
	{ 0x7775, 0xc34b },
	{ 0x7776, 0xc34c },
	{ 0x7777, 0xc34d },
	{ 0x7778, 0xc34e },
	{ 0x7779, 0xc34f },
	{ 0x777a, 0xc350 },
	{ 0x777b, 0xc351 },
	{ 0x777c, 0xc352 },
	{ 0x777d, 0xc353 },
	{ 0x777e, 0xc354 },
	{ 0x7821, 0xc355 },
	{ 0x7822, 0xc356 },
	{ 0x7823, 0xc357 },
	{ 0x7824, 0xc358 },
	{ 0x7825, 0xc359 },
	{ 0x7826, 0xc35a },
	{ 0x7827, 0xc35b },
	{ 0x7828, 0xc35c },
	{ 0x7829, 0xc35d },
	{ 0x782a, 0xc35e },
	{ 0x782b, 0xc35f },
	{ 0x782c, 0xc360 },
	{ 0x782d, 0xc456 },
	{ 0x782e, 0xc361 },
	{ 0x782f, 0xc362 },
	{ 0x7830, 0xc363 },
	{ 0x7831, 0xc364 },
	{ 0x7832, 0xc365 },
	{ 0x7833, 0xc366 },
	{ 0x7834, 0xc367 },
	{ 0x7835, 0xc368 },
	{ 0x7836, 0xc369 },
	{ 0x7837, 0xc36a },
	{ 0x7838, 0xc36b },
	{ 0x7839, 0xc36c },
	{ 0x783a, 0xc36d },
	{ 0x783b, 0xc36e },
	{ 0x783c, 0xc36f },
	{ 0x783d, 0xc370 },
	{ 0x783e, 0xc371 },
	{ 0x783f, 0xc372 },
	{ 0x7840, 0xc373 },
	{ 0x7841, 0xc374 },
	{ 0x7842, 0xc375 },
	{ 0x7843, 0xc376 },
	{ 0x7844, 0xc377 },
	{ 0x7845, 0xc378 },
	{ 0x7846, 0xc379 },
	{ 0x7847, 0xc37a },
	{ 0x7848, 0xc37b },
	{ 0x7849, 0xc37c },
	{ 0x784a, 0xc37d },
	{ 0x784b, 0xc37e },
	{ 0x784c, 0xc3a1 },
	{ 0x784d, 0xc3a2 },
	{ 0x784e, 0xc3a3 },
	{ 0x784f, 0xc3a4 },
	{ 0x7850, 0xc3a5 },
	{ 0x7851, 0xc3a6 },
	{ 0x7852, 0xc3a7 },
	{ 0x7853, 0xc3a8 },
	{ 0x7854, 0xc3a9 },
	{ 0x7855, 0xc3aa },
	{ 0x7856, 0xc3ab },
	{ 0x7857, 0xc3ac },
	{ 0x7858, 0xc3ad },
	{ 0x7859, 0xc3ae },
	{ 0x785a, 0xc3af },
	{ 0x785b, 0xc3b0 },
	{ 0x785c, 0xc3b1 },
	{ 0x785d, 0xc3b2 },
	{ 0x785e, 0xc3b3 },
	{ 0x785f, 0xc3b4 },
	{ 0x7860, 0xc3b5 },
	{ 0x7861, 0xc3b6 },
	{ 0x7862, 0xc3b7 },
	{ 0x7863, 0xc3b8 },
	{ 0x7864, 0xc3ba },
	{ 0x7865, 0xc3b9 },
	{ 0x7866, 0xc3bb },
	{ 0x7867, 0xc3bc },
	{ 0x7868, 0xc3bd },
	{ 0x7869, 0xc3be },
	{ 0x786a, 0xc3bf },
	{ 0x786b, 0xc3c0 },
	{ 0x786c, 0xc3c1 },
	{ 0x786d, 0xc3c2 },
	{ 0x786e, 0xc3c3 },
	{ 0x786f, 0xc3c4 },
	{ 0x7870, 0xc3c5 },
	{ 0x7871, 0xc3c6 },
	{ 0x7872, 0xc3c7 },
	{ 0x7873, 0xc3c8 },
	{ 0x7874, 0xc3c9 },
	{ 0x7875, 0xc3ca },
	{ 0x7876, 0xc3cb },
	{ 0x7877, 0xc3cc },
	{ 0x7878, 0xc3cd },
	{ 0x7879, 0xc3ce },
	{ 0x787a, 0xc3cf },
	{ 0x787b, 0xc3d0 },
	{ 0x787c, 0xc3d1 },
	{ 0x787d, 0xc3d2 },
	{ 0x787e, 0xc3d3 },
	{ 0x7921, 0xc3d4 },
	{ 0x7922, 0xc3d5 },
	{ 0x7923, 0xc3d6 },
	{ 0x7924, 0xc3d7 },
	{ 0x7925, 0xc3d8 },
	{ 0x7926, 0xc3d9 },
	{ 0x7927, 0xc3da },
	{ 0x7928, 0xc3db },
	{ 0x7929, 0xc3dc },
	{ 0x792a, 0xc3dd },
	{ 0x792b, 0xc3de },
	{ 0x792c, 0xc3df },
	{ 0x792d, 0xc3e0 },
	{ 0x792e, 0xc3e1 },
	{ 0x792f, 0xc3e2 },
	{ 0x7930, 0xc3e3 },
	{ 0x7931, 0xc3e4 },
	{ 0x7932, 0xc3e5 },
	{ 0x7933, 0xc3e6 },
	{ 0x7934, 0xc3e7 },
	{ 0x7935, 0xc3e8 },
	{ 0x7936, 0xc3e9 },
	{ 0x7937, 0xc3ea },
	{ 0x7938, 0xc3eb },
	{ 0x7939, 0xc3ec },
	{ 0x793a, 0xc3ed },
	{ 0x793b, 0xc3ee },
	{ 0x793c, 0xc3ef },
	{ 0x793d, 0xc3f0 },
	{ 0x793e, 0xc3f1 },
	{ 0x793f, 0xc3f2 },
	{ 0x7940, 0xc3f3 },
	{ 0x7941, 0xc3f4 },
	{ 0x7942, 0xc3f5 },
	{ 0x7943, 0xc3f6 },
	{ 0x7944, 0xc3f7 },
	{ 0x7945, 0xc3f8 },
	{ 0x7946, 0xc3f9 },
	{ 0x7947, 0xc3fa },
	{ 0x7948, 0xc3fb },
	{ 0x7949, 0xc3fc },
	{ 0x794a, 0xc3fd },
	{ 0x794b, 0xc3fe },
	{ 0x794c, 0xc440 },
	{ 0x794d, 0xc441 },
	{ 0x794e, 0xc442 },
	{ 0x794f, 0xc443 },
	{ 0x7950, 0xc444 },
	{ 0x7951, 0xc445 },
	{ 0x7952, 0xc446 },
	{ 0x7953, 0xc447 },
	{ 0x7954, 0xc448 },
	{ 0x7955, 0xc449 },
	{ 0x7956, 0xc44a },
	{ 0x7957, 0xc44b },
	{ 0x7958, 0xc44c },
	{ 0x7959, 0xc44d },
	{ 0x795a, 0xc44e },
	{ 0x795b, 0xc44f },
	{ 0x795c, 0xc450 },
	{ 0x795d, 0xc451 },
	{ 0x795e, 0xc452 },
	{ 0x795f, 0xc453 },
	{ 0x7960, 0xc454 },
	{ 0x7961, 0xc455 },
	{ 0x7962, 0xc457 },
	{ 0x7963, 0xc458 },
	{ 0x7964, 0xc459 },
	{ 0x7965, 0xc45a },
	{ 0x7966, 0xc45b },
	{ 0x7967, 0xc45c },
	{ 0x7968, 0xc45d },
	{ 0x7969, 0xc45e },
	{ 0x796a, 0xc45f },
	{ 0x796b, 0xc460 },
	{ 0x796c, 0xc461 },
	{ 0x796d, 0xc462 },
	{ 0x796e, 0xc463 },
	{ 0x796f, 0xc464 },
	{ 0x7970, 0xc465 },
	{ 0x7971, 0xc466 },
	{ 0x7972, 0xc467 },
	{ 0x7973, 0xc468 },
	{ 0x7974, 0xc469 },
	{ 0x7975, 0xc46a },
	{ 0x7976, 0xc46b },
	{ 0x7977, 0xc46c },
	{ 0x7978, 0xc46d },
	{ 0x7979, 0xc46e },
	{ 0x797a, 0xc46f },
	{ 0x797b, 0xc470 },
	{ 0x797c, 0xc471 },
	{ 0x797d, 0xc472 },
	{ 0x797e, 0xc473 },
	{ 0x7a21, 0xc474 },
	{ 0x7a22, 0xc475 },
	{ 0x7a23, 0xc476 },
	{ 0x7a24, 0xc477 },
	{ 0x7a25, 0xc478 },
	{ 0x7a26, 0xc479 },
	{ 0x7a27, 0xc47a },
	{ 0x7a28, 0xc47b },
	{ 0x7a29, 0xc47c },
	{ 0x7a2a, 0xc47d },
	{ 0x7a2b, 0xc47e },
	{ 0x7a2c, 0xc4a1 },
	{ 0x7a2d, 0xc4a2 },
	{ 0x7a2e, 0xc4a3 },
	{ 0x7a2f, 0xc4a4 },
	{ 0x7a30, 0xc4a5 },
	{ 0x7a31, 0xc4a6 },
	{ 0x7a32, 0xc4a7 },
	{ 0x7a33, 0xc4a8 },
	{ 0x7a34, 0xc4a9 },
	{ 0x7a35, 0xc4aa },
	{ 0x7a36, 0xc4ab },
	{ 0x7a37, 0xc4ac },
	{ 0x7a38, 0xc4ad },
	{ 0x7a39, 0xc4ae },
	{ 0x7a3a, 0xc4af },
	{ 0x7a3b, 0xc4b0 },
	{ 0x7a3c, 0xc4b1 },
	{ 0x7a3d, 0xc4b2 },
	{ 0x7a3e, 0xc4b3 },
	{ 0x7a3f, 0xc4b4 },
	{ 0x7a40, 0xc4b5 },
	{ 0x7a41, 0xc4b6 },
	{ 0x7a42, 0xc4b7 },
	{ 0x7a43, 0xc4b8 },
	{ 0x7a44, 0xc4b9 },
	{ 0x7a45, 0xc4ba },
	{ 0x7a46, 0xc4bb },
	{ 0x7a47, 0xc4bc },
	{ 0x7a48, 0xc4bd },
	{ 0x7a49, 0xc4be },
	{ 0x7a4a, 0xc4bf },
	{ 0x7a4b, 0xc4c0 },
	{ 0x7a4c, 0xc4c1 },
	{ 0x7a4d, 0xc4c2 },
	{ 0x7a4e, 0xc4c3 },
	{ 0x7a4f, 0xc4c4 },
	{ 0x7a50, 0xc4c5 },
	{ 0x7a51, 0xc4c6 },
	{ 0x7a52, 0xc4c7 },
	{ 0x7a53, 0xc4c8 },
	{ 0x7a54, 0xc4c9 },
	{ 0x7a55, 0xc4ca },
	{ 0x7a56, 0xc4cb },
	{ 0x7a57, 0xc4cc },
	{ 0x7a58, 0xc4cd },
	{ 0x7a59, 0xc4ce },
	{ 0x7a5a, 0xc4cf },
	{ 0x7a5b, 0xc4d0 },
	{ 0x7a5c, 0xc4d1 },
	{ 0x7a5d, 0xc4d2 },
	{ 0x7a5e, 0xc4d3 },
	{ 0x7a5f, 0xc4d4 },
	{ 0x7a60, 0xc4d5 },
	{ 0x7a61, 0xc4d6 },
	{ 0x7a62, 0xc4d7 },
	{ 0x7a63, 0xc4d8 },
	{ 0x7a64, 0xc4d9 },
	{ 0x7a65, 0xc4da },
	{ 0x7a66, 0xc4db },
	{ 0x7a67, 0xc4dc },
	{ 0x7a68, 0xc4dd },
	{ 0x7a69, 0xc4de },
	{ 0x7a6a, 0xc4df },
	{ 0x7a6b, 0xc4e0 },
	{ 0x7a6c, 0xc4e1 },
	{ 0x7a6d, 0xc4e2 },
	{ 0x7a6e, 0xc4e3 },
	{ 0x7a6f, 0xc4e4 },
	{ 0x7a70, 0xc4e5 },
	{ 0x7a71, 0xc4e6 },
	{ 0x7a72, 0xc4e7 },
	{ 0x7a73, 0xc4e8 },
	{ 0x7a74, 0xc4e9 },
	{ 0x7a75, 0xc4ea },
	{ 0x7a76, 0xc4eb },
	{ 0x7a77, 0xc4ec },
	{ 0x7a78, 0xc4ed },
	{ 0x7a79, 0xc4ee },
	{ 0x7a7a, 0xc4ef },
	{ 0x7a7b, 0xc4f0 },
	{ 0x7a7c, 0xc4f1 },
	{ 0x7a7d, 0xc4f2 },
	{ 0x7a7e, 0xc4f3 },
	{ 0x7b21, 0xc4f4 },
	{ 0x7b22, 0xc4f5 },
	{ 0x7b23, 0xc4f6 },
	{ 0x7b24, 0xc4f7 },
	{ 0x7b25, 0xc4f8 },
	{ 0x7b26, 0xc4f9 },
	{ 0x7b27, 0xc4fa },
	{ 0x7b28, 0xc4fb },
	{ 0x7b29, 0xc4fc },
	{ 0x7b2a, 0xc4fd },
	{ 0x7b2b, 0xc4fe },
	{ 0x7b2c, 0xc540 },
	{ 0x7b2d, 0xc541 },
	{ 0x7b2e, 0xc542 },
	{ 0x7b2f, 0xc543 },
	{ 0x7b30, 0xc544 },
	{ 0x7b31, 0xc545 },
	{ 0x7b32, 0xc546 },
	{ 0x7b33, 0xc547 },
	{ 0x7b34, 0xc548 },
	{ 0x7b35, 0xc549 },
	{ 0x7b36, 0xc54a },
	{ 0x7b37, 0xc54b },
	{ 0x7b38, 0xc54c },
	{ 0x7b39, 0xc54d },
	{ 0x7b3a, 0xc54e },
	{ 0x7b3b, 0xc54f },
	{ 0x7b3c, 0xc550 },
	{ 0x7b3d, 0xc551 },
	{ 0x7b3e, 0xc552 },
	{ 0x7b3f, 0xc553 },
	{ 0x7b40, 0xc554 },
	{ 0x7b41, 0xc555 },
	{ 0x7b42, 0xc556 },
	{ 0x7b43, 0xc557 },
	{ 0x7b44, 0xc558 },
	{ 0x7b45, 0xc559 },
	{ 0x7b46, 0xc55a },
	{ 0x7b47, 0xc55b },
	{ 0x7b48, 0xc55c },
	{ 0x7b49, 0xc55d },
	{ 0x7b4a, 0xc55e },
	{ 0x7b4b, 0xc55f },
	{ 0x7b4c, 0xc560 },
	{ 0x7b4d, 0xc561 },
	{ 0x7b4e, 0xc562 },
	{ 0x7b4f, 0xc563 },
	{ 0x7b50, 0xc564 },
	{ 0x7b51, 0xc565 },
	{ 0x7b52, 0xc566 },
	{ 0x7b53, 0xc567 },
	{ 0x7b54, 0xc568 },
	{ 0x7b55, 0xc569 },
	{ 0x7b56, 0xc56a },
	{ 0x7b57, 0xc56b },
	{ 0x7b58, 0xc56c },
	{ 0x7b59, 0xc56d },
	{ 0x7b5a, 0xc56e },
	{ 0x7b5b, 0xc56f },
	{ 0x7b5c, 0xc570 },
	{ 0x7b5d, 0xc571 },
	{ 0x7b5e, 0xc572 },
	{ 0x7b5f, 0xc573 },
	{ 0x7b60, 0xc574 },
	{ 0x7b61, 0xc575 },
	{ 0x7b62, 0xc576 },
	{ 0x7b63, 0xc577 },
	{ 0x7b64, 0xc578 },
	{ 0x7b65, 0xc579 },
	{ 0x7b66, 0xc57a },
	{ 0x7b67, 0xc57b },
	{ 0x7b68, 0xc57c },
	{ 0x7b69, 0xc57d },
	{ 0x7b6a, 0xc57e },
	{ 0x7b6b, 0xc5a1 },
	{ 0x7b6c, 0xc5a2 },
	{ 0x7b6d, 0xc5a3 },
	{ 0x7b6e, 0xc5a4 },
	{ 0x7b6f, 0xc5a5 },
	{ 0x7b70, 0xc5a6 },
	{ 0x7b71, 0xc5a7 },
	{ 0x7b72, 0xc5a8 },
	{ 0x7b73, 0xc5a9 },
	{ 0x7b74, 0xc5aa },
	{ 0x7b75, 0xc5ab },
	{ 0x7b76, 0xc5ac },
	{ 0x7b77, 0xc5ad },
	{ 0x7b78, 0xc5ae },
	{ 0x7b79, 0xc5af },
	{ 0x7b7a, 0xc5b0 },
	{ 0x7b7b, 0xc5b1 },
	{ 0x7b7c, 0xc5b2 },
	{ 0x7b7d, 0xc5b3 },
	{ 0x7b7e, 0xc5b4 },
	{ 0x7c21, 0xc5b5 },
	{ 0x7c22, 0xc5b6 },
	{ 0x7c23, 0xc5b7 },
	{ 0x7c24, 0xc5b8 },
	{ 0x7c25, 0xc5b9 },
	{ 0x7c26, 0xc5ba },
	{ 0x7c27, 0xc5bb },
	{ 0x7c28, 0xc5bc },
	{ 0x7c29, 0xc5bd },
	{ 0x7c2a, 0xc5be },
	{ 0x7c2b, 0xc5bf },
	{ 0x7c2c, 0xc5c0 },
	{ 0x7c2d, 0xc5c1 },
	{ 0x7c2e, 0xc5c2 },
	{ 0x7c2f, 0xc5c3 },
	{ 0x7c30, 0xc5c4 },
	{ 0x7c31, 0xc5c5 },
	{ 0x7c32, 0xc5c6 },
	{ 0x7c33, 0xc5c7 },
	{ 0x7c34, 0xc5c8 },
	{ 0x7c35, 0xc5c9 },
	{ 0x7c36, 0xc5ca },
	{ 0x7c37, 0xc5cb },
	{ 0x7c38, 0xc5cc },
	{ 0x7c39, 0xc5cd },
	{ 0x7c3a, 0xc5ce },
	{ 0x7c3b, 0xc5cf },
	{ 0x7c3c, 0xc5d0 },
	{ 0x7c3d, 0xc5d1 },
	{ 0x7c3e, 0xc5d2 },
	{ 0x7c3f, 0xc5d3 },
	{ 0x7c40, 0xc5d4 },
	{ 0x7c41, 0xc5d5 },
	{ 0x7c42, 0xc5d6 },
	{ 0x7c43, 0xc5d7 },
	{ 0x7c44, 0xc5d8 },
	{ 0x7c45, 0xc5d9 },
	{ 0x7c46, 0xc5da },
	{ 0x7c47, 0xc5db },
	{ 0x7c48, 0xc5dc },
	{ 0x7c49, 0xc5dd },
	{ 0x7c4a, 0xc5de },
	{ 0x7c4b, 0xc5df },
	{ 0x7c4c, 0xc5e0 },
	{ 0x7c4d, 0xc5e1 },
	{ 0x7c4e, 0xc5e2 },
	{ 0x7c4f, 0xc5e3 },
	{ 0x7c50, 0xc5e4 },
	{ 0x7c51, 0xc5e5 },
	{ 0x7c52, 0xc5e6 },
	{ 0x7c53, 0xc5e7 },
	{ 0x7c54, 0xc5e8 },
	{ 0x7c55, 0xc5e9 },
	{ 0x7c56, 0xc5ea },
	{ 0x7c57, 0xc5eb },
	{ 0x7c58, 0xc5ec },
	{ 0x7c59, 0xc5ed },
	{ 0x7c5a, 0xc5ee },
	{ 0x7c5b, 0xc5ef },
	{ 0x7c5c, 0xc5f0 },
	{ 0x7c5d, 0xc5f1 },
	{ 0x7c5e, 0xc5f2 },
	{ 0x7c5f, 0xc5f3 },
	{ 0x7c60, 0xc5f4 },
	{ 0x7c61, 0xc5f5 },
	{ 0x7c62, 0xc5f6 },
	{ 0x7c63, 0xc5f7 },
	{ 0x7c64, 0xc5f8 },
	{ 0x7c65, 0xc5f9 },
	{ 0x7c66, 0xc5fa },
	{ 0x7c67, 0xc5fb },
	{ 0x7c68, 0xc5fc },
	{ 0x7c69, 0xc5fd },
	{ 0x7c6a, 0xc5fe },
	{ 0x7c6b, 0xc640 },
	{ 0x7c6c, 0xc641 },
	{ 0x7c6d, 0xc642 },
	{ 0x7c6e, 0xc643 },
	{ 0x7c6f, 0xc644 },
	{ 0x7c70, 0xc645 },
	{ 0x7c71, 0xc646 },
	{ 0x7c72, 0xc647 },
	{ 0x7c73, 0xc648 },
	{ 0x7c74, 0xc649 },
	{ 0x7c75, 0xc64a },
	{ 0x7c76, 0xc64b },
	{ 0x7c77, 0xc64c },
	{ 0x7c78, 0xc64d },
	{ 0x7c79, 0xc64e },
	{ 0x7c7a, 0xc64f },
	{ 0x7c7b, 0xc650 },
	{ 0x7c7c, 0xc651 },
	{ 0x7c7d, 0xc652 },
	{ 0x7c7e, 0xc653 },
	{ 0x7d21, 0xc654 },
	{ 0x7d22, 0xc655 },
	{ 0x7d23, 0xc656 },
	{ 0x7d24, 0xc657 },
	{ 0x7d25, 0xc658 },
	{ 0x7d26, 0xc659 },
	{ 0x7d27, 0xc65a },
	{ 0x7d28, 0xc65b },
	{ 0x7d29, 0xc65c },
	{ 0x7d2a, 0xc65d },
	{ 0x7d2b, 0xc65e },
	{ 0x7d2c, 0xc65f },
	{ 0x7d2d, 0xc660 },
	{ 0x7d2e, 0xc661 },
	{ 0x7d2f, 0xc662 },
	{ 0x7d30, 0xc663 },
	{ 0x7d31, 0xc664 },
	{ 0x7d32, 0xc665 },
	{ 0x7d33, 0xc666 },
	{ 0x7d34, 0xc667 },
	{ 0x7d35, 0xc668 },
	{ 0x7d36, 0xc669 },
	{ 0x7d37, 0xc66a },
	{ 0x7d38, 0xc66b },
	{ 0x7d39, 0xc66c },
	{ 0x7d3a, 0xc66d },
	{ 0x7d3b, 0xc66e },
	{ 0x7d3c, 0xc66f },
	{ 0x7d3d, 0xc670 },
	{ 0x7d3e, 0xc671 },
	{ 0x7d3f, 0xc672 },
	{ 0x7d40, 0xc673 },
	{ 0x7d41, 0xc674 },
	{ 0x7d42, 0xc675 },
	{ 0x7d43, 0xc676 },
	{ 0x7d44, 0xc677 },
	{ 0x7d45, 0xc678 },
	{ 0x7d46, 0xc679 },
	{ 0x7d47, 0xc67a },
	{ 0x7d48, 0xc67b },
	{ 0x7d49, 0xc67c },
	{ 0x7d4a, 0xc67d },
	{ 0x7d4b, 0xc67e }
};

/* CNS 11643-1992 plane #2 to Big-5 conversion table */
table_t	cns_big5_tab2[MAX_CNS2_NUM] = {
	{ 0x2121, 0xc940 },
	{ 0x2122, 0xc941 },
	{ 0x2123, 0xc942 },
	{ 0x2124, 0xc943 },
	{ 0x2125, 0xc944 },
	{ 0x2126, 0xc945 },
	{ 0x2127, 0xc946 },
	{ 0x2128, 0xc947 },
	{ 0x2129, 0xc948 },
	{ 0x212a, 0xc949 },
	{ 0x212b, 0xc94b },
	{ 0x212c, 0xc94c },
	{ 0x212d, 0xc94d },
	{ 0x212e, 0xc94e },
	{ 0x212f, 0xc94f },
	{ 0x2130, 0xc950 },
	{ 0x2131, 0xc951 },
	{ 0x2132, 0xc952 },
	{ 0x2133, 0xc953 },
	{ 0x2134, 0xc954 },
	{ 0x2135, 0xc955 },
	{ 0x2136, 0xc956 },
	{ 0x2137, 0xc957 },
	{ 0x2138, 0xc958 },
	{ 0x2139, 0xc959 },
	{ 0x213a, 0xc95a },
	{ 0x213b, 0xc95b },
	{ 0x213c, 0xc95c },
	{ 0x213d, 0xc95d },
	{ 0x213e, 0xc95e },
	{ 0x213f, 0xc95f },
	{ 0x2140, 0xc960 },
	{ 0x2141, 0xc961 },
	{ 0x2142, 0xc962 },
	{ 0x2143, 0xc963 },
	{ 0x2144, 0xc964 },
	{ 0x2145, 0xc965 },
	{ 0x2146, 0xc966 },
	{ 0x2147, 0xc967 },
	{ 0x2148, 0xc968 },
	{ 0x2149, 0xc969 },
	{ 0x214a, 0xc96a },
	{ 0x214b, 0xc96b },
	{ 0x214c, 0xc9be },
	{ 0x214d, 0xc96c },
	{ 0x214e, 0xc96d },
	{ 0x214f, 0xc96e },
	{ 0x2150, 0xc96f },
	{ 0x2151, 0xc970 },
	{ 0x2152, 0xc971 },
	{ 0x2153, 0xc972 },
	{ 0x2154, 0xc973 },
	{ 0x2155, 0xc974 },
	{ 0x2156, 0xc975 },
	{ 0x2157, 0xc976 },
	{ 0x2158, 0xc977 },
	{ 0x2159, 0xc978 },
	{ 0x215a, 0xc979 },
	{ 0x215b, 0xc97a },
	{ 0x215c, 0xc97b },
	{ 0x215d, 0xc97c },
	{ 0x215e, 0xc97d },
	{ 0x215f, 0xc97e },
	{ 0x2160, 0xc9a1 },
	{ 0x2161, 0xc9a2 },
	{ 0x2162, 0xc9a3 },
	{ 0x2163, 0xc9a4 },
	{ 0x2164, 0xc9a5 },
	{ 0x2165, 0xc9a6 },
	{ 0x2166, 0xc9a7 },
	{ 0x2167, 0xc9a8 },
	{ 0x2168, 0xc9a9 },
	{ 0x2169, 0xc9aa },
	{ 0x216a, 0xc9ab },
	{ 0x216b, 0xc9ac },
	{ 0x216c, 0xc9ad },
	{ 0x216d, 0xc9ae },
	{ 0x216e, 0xc9af },
	{ 0x216f, 0xc9b0 },
	{ 0x2170, 0xc9b1 },
	{ 0x2171, 0xc9b2 },
	{ 0x2172, 0xc9b3 },
	{ 0x2173, 0xc9b4 },
	{ 0x2174, 0xc9b5 },
	{ 0x2175, 0xc9b6 },
	{ 0x2176, 0xc9b7 },
	{ 0x2177, 0xc9b8 },
	{ 0x2178, 0xc9b9 },
	{ 0x2179, 0xc9ba },
	{ 0x217a, 0xc9bb },
	{ 0x217b, 0xc9bc },
	{ 0x217c, 0xc9bd },
	{ 0x217d, 0xc9bf },
	{ 0x217e, 0xc9c0 },
	{ 0x2221, 0xc9c1 },
	{ 0x2222, 0xc9c2 },
	{ 0x2223, 0xc9c3 },
	{ 0x2224, 0xc9c4 },
	{ 0x2225, 0xc9c5 },
	{ 0x2226, 0xc9c6 },
	{ 0x2227, 0xc9c7 },
	{ 0x2228, 0xc9c8 },
	{ 0x2229, 0xc9c9 },
	{ 0x222a, 0xc9ca },
	{ 0x222b, 0xc9cb },
	{ 0x222c, 0xc9cc },
	{ 0x222d, 0xc9cd },
	{ 0x222e, 0xc9ce },
	{ 0x222f, 0xc9cf },
	{ 0x2230, 0xc9d0 },
	{ 0x2231, 0xc9d1 },
	{ 0x2232, 0xc9d2 },
	{ 0x2233, 0xc9d3 },
	{ 0x2234, 0xc9d4 },
	{ 0x2235, 0xc9d5 },
	{ 0x2236, 0xc9d6 },
	{ 0x2237, 0xc9d7 },
	{ 0x2238, 0xc9d8 },
	{ 0x2239, 0xc9d9 },
	{ 0x223a, 0xc9da },
	{ 0x223b, 0xc9db },
	{ 0x223c, 0xc9dc },
	{ 0x223d, 0xc9dd },
	{ 0x223e, 0xc9de },
	{ 0x223f, 0xc9df },
	{ 0x2240, 0xc9e0 },
	{ 0x2241, 0xc9e1 },
	{ 0x2242, 0xc9e2 },
	{ 0x2243, 0xc9e3 },
	{ 0x2244, 0xc9e4 },
	{ 0x2245, 0xc9e5 },
	{ 0x2246, 0xc9e6 },
	{ 0x2247, 0xc9e7 },
	{ 0x2248, 0xc9e8 },
	{ 0x2249, 0xc9e9 },
	{ 0x224a, 0xc9ea },
	{ 0x224b, 0xc9eb },
	{ 0x224c, 0xc9ec },
	{ 0x224d, 0xcaf7 },
	{ 0x224e, 0xc9ed },
	{ 0x224f, 0xc9ee },
	{ 0x2250, 0xc9ef },
	{ 0x2251, 0xc9f0 },
	{ 0x2252, 0xc9f1 },
	{ 0x2253, 0xc9f2 },
	{ 0x2254, 0xc9f3 },
	{ 0x2255, 0xc9f4 },
	{ 0x2256, 0xc9f5 },
	{ 0x2257, 0xc9f6 },
	{ 0x2258, 0xc9f7 },
	{ 0x2259, 0xc9f8 },
	{ 0x225a, 0xc9f9 },
	{ 0x225b, 0xc9fa },
	{ 0x225c, 0xc9fb },
	{ 0x225d, 0xc9fc },
	{ 0x225e, 0xc9fd },
	{ 0x225f, 0xc9fe },
	{ 0x2260, 0xca40 },
	{ 0x2261, 0xca41 },
	{ 0x2262, 0xca42 },
	{ 0x2263, 0xca43 },
	{ 0x2264, 0xca44 },
	{ 0x2265, 0xca45 },
	{ 0x2266, 0xca46 },
	{ 0x2267, 0xca47 },
	{ 0x2268, 0xca48 },
	{ 0x2269, 0xca49 },
	{ 0x226a, 0xca4a },
	{ 0x226b, 0xca4b },
	{ 0x226c, 0xca4c },
	{ 0x226d, 0xca4d },
	{ 0x226e, 0xca4e },
	{ 0x226f, 0xca4f },
	{ 0x2270, 0xca50 },
	{ 0x2271, 0xca51 },
	{ 0x2272, 0xca52 },
	{ 0x2273, 0xca53 },
	{ 0x2274, 0xca54 },
	{ 0x2275, 0xca55 },
	{ 0x2276, 0xca56 },
	{ 0x2277, 0xca57 },
	{ 0x2278, 0xca58 },
	{ 0x2279, 0xca59 },
	{ 0x227a, 0xca5a },
	{ 0x227b, 0xca5b },
	{ 0x227c, 0xca5c },
	{ 0x227d, 0xca5d },
	{ 0x227e, 0xca5e },
	{ 0x2321, 0xca5f },
	{ 0x2322, 0xca60 },
	{ 0x2323, 0xca61 },
	{ 0x2324, 0xca62 },
	{ 0x2325, 0xca63 },
	{ 0x2326, 0xca64 },
	{ 0x2327, 0xca65 },
	{ 0x2328, 0xca66 },
	{ 0x2329, 0xca67 },
	{ 0x232a, 0xca68 },
	{ 0x232b, 0xca69 },
	{ 0x232c, 0xca6a },
	{ 0x232d, 0xca6b },
	{ 0x232e, 0xca6c },
	{ 0x232f, 0xca6d },
	{ 0x2330, 0xca6e },
	{ 0x2331, 0xca6f },
	{ 0x2332, 0xca70 },
	{ 0x2333, 0xca71 },
	{ 0x2334, 0xca72 },
	{ 0x2335, 0xca73 },
	{ 0x2336, 0xca74 },
	{ 0x2337, 0xca75 },
	{ 0x2338, 0xca76 },
	{ 0x2339, 0xca77 },
	{ 0x233a, 0xca78 },
	{ 0x233b, 0xca79 },
	{ 0x233c, 0xca7a },
	{ 0x233d, 0xca7b },
	{ 0x233e, 0xca7c },
	{ 0x233f, 0xca7d },
	{ 0x2340, 0xca7e },
	{ 0x2341, 0xcaa1 },
	{ 0x2342, 0xcaa2 },
	{ 0x2343, 0xcaa3 },
	{ 0x2344, 0xcaa4 },
	{ 0x2345, 0xcaa5 },
	{ 0x2346, 0xcaa6 },
	{ 0x2347, 0xcaa7 },
	{ 0x2348, 0xcaa8 },
	{ 0x2349, 0xcaa9 },
	{ 0x234a, 0xcaaa },
	{ 0x234b, 0xcaab },
	{ 0x234c, 0xcaac },
	{ 0x234d, 0xcaad },
	{ 0x234e, 0xcaae },
	{ 0x234f, 0xcaaf },
	{ 0x2350, 0xcab0 },
	{ 0x2351, 0xcab1 },
	{ 0x2352, 0xcab2 },
	{ 0x2353, 0xcab3 },
	{ 0x2354, 0xcab4 },
	{ 0x2355, 0xcab5 },
	{ 0x2356, 0xcab6 },
	{ 0x2357, 0xcab7 },
	{ 0x2358, 0xcab8 },
	{ 0x2359, 0xcab9 },
	{ 0x235a, 0xcaba },
	{ 0x235b, 0xcabb },
	{ 0x235c, 0xcabc },
	{ 0x235d, 0xcabd },
	{ 0x235e, 0xcabe },
	{ 0x235f, 0xcabf },
	{ 0x2360, 0xcac0 },
	{ 0x2361, 0xcac1 },
	{ 0x2362, 0xcac2 },
	{ 0x2363, 0xcac3 },
	{ 0x2364, 0xcac4 },
	{ 0x2365, 0xcac5 },
	{ 0x2366, 0xcac6 },
	{ 0x2367, 0xcac7 },
	{ 0x2368, 0xcac8 },
	{ 0x2369, 0xcac9 },
	{ 0x236a, 0xcaca },
	{ 0x236b, 0xcacb },
	{ 0x236c, 0xcacc },
	{ 0x236d, 0xcacd },
	{ 0x236e, 0xcace },
	{ 0x236f, 0xcacf },
	{ 0x2370, 0xcad0 },
	{ 0x2371, 0xcad1 },
	{ 0x2372, 0xcad2 },
	{ 0x2373, 0xcad3 },
	{ 0x2374, 0xcad4 },
	{ 0x2375, 0xcad5 },
	{ 0x2376, 0xcad6 },
	{ 0x2377, 0xcad7 },
	{ 0x2378, 0xcad8 },
	{ 0x2379, 0xcad9 },
	{ 0x237a, 0xcada },
	{ 0x237b, 0xcadb },
	{ 0x237c, 0xcadc },
	{ 0x237d, 0xcadd },
	{ 0x237e, 0xcade },
	{ 0x2421, 0xcadf },
	{ 0x2422, 0xcae0 },
	{ 0x2423, 0xcae1 },
	{ 0x2424, 0xcae2 },
	{ 0x2425, 0xcae3 },
	{ 0x2426, 0xcae4 },
	{ 0x2427, 0xcae5 },
	{ 0x2428, 0xcae6 },
	{ 0x2429, 0xcae7 },
	{ 0x242a, 0xcae8 },
	{ 0x242b, 0xcae9 },
	{ 0x242c, 0xcaea },
	{ 0x242d, 0xcaeb },
	{ 0x242e, 0xcaec },
	{ 0x242f, 0xcaed },
	{ 0x2430, 0xcaee },
	{ 0x2431, 0xcaef },
	{ 0x2432, 0xcaf0 },
	{ 0x2433, 0xcaf1 },
	{ 0x2434, 0xcaf2 },
	{ 0x2435, 0xcaf3 },
	{ 0x2436, 0xcaf4 },
	{ 0x2437, 0xcaf5 },
	{ 0x2438, 0xcaf6 },
	{ 0x2439, 0xcaf8 },
	{ 0x243a, 0xcaf9 },
	{ 0x243b, 0xcafa },
	{ 0x243c, 0xcafb },
	{ 0x243d, 0xcafc },
	{ 0x243e, 0xcafd },
	{ 0x243f, 0xcafe },
	{ 0x2440, 0xcb40 },
	{ 0x2441, 0xcb41 },
	{ 0x2442, 0xcb42 },
	{ 0x2443, 0xcb43 },
	{ 0x2444, 0xcb44 },
	{ 0x2445, 0xcb45 },
	{ 0x2446, 0xcb46 },
	{ 0x2447, 0xcb47 },
	{ 0x2448, 0xcb48 },
	{ 0x2449, 0xcb49 },
	{ 0x244a, 0xcb4a },
	{ 0x244b, 0xcb4b },
	{ 0x244c, 0xcb4c },
	{ 0x244d, 0xcb4d },
	{ 0x244e, 0xcb4e },
	{ 0x244f, 0xcb4f },
	{ 0x2450, 0xcb50 },
	{ 0x2451, 0xcb51 },
	{ 0x2452, 0xcb52 },
	{ 0x2453, 0xcb53 },
	{ 0x2454, 0xcb54 },
	{ 0x2455, 0xcb55 },
	{ 0x2456, 0xcb56 },
	{ 0x2457, 0xcb57 },
	{ 0x2458, 0xcb58 },
	{ 0x2459, 0xcb59 },
	{ 0x245a, 0xcb5a },
	{ 0x245b, 0xcb5b },
	{ 0x245c, 0xcb5c },
	{ 0x245d, 0xcb5d },
	{ 0x245e, 0xcb5e },
	{ 0x245f, 0xcb5f },
	{ 0x2460, 0xcb60 },
	{ 0x2461, 0xcb61 },
	{ 0x2462, 0xcb62 },
	{ 0x2463, 0xcb63 },
	{ 0x2464, 0xcb64 },
	{ 0x2465, 0xcb65 },
	{ 0x2466, 0xcb66 },
	{ 0x2467, 0xcb67 },
	{ 0x2468, 0xcb68 },
	{ 0x2469, 0xcb69 },
	{ 0x246a, 0xcb6a },
	{ 0x246b, 0xcb6b },
	{ 0x246c, 0xcb6c },
	{ 0x246d, 0xcb6d },
	{ 0x246e, 0xcb6e },
	{ 0x246f, 0xcb6f },
	{ 0x2470, 0xcb70 },
	{ 0x2471, 0xcb71 },
	{ 0x2472, 0xcb72 },
	{ 0x2473, 0xcb73 },
	{ 0x2474, 0xcb74 },
	{ 0x2475, 0xcb75 },
	{ 0x2476, 0xcb76 },
	{ 0x2477, 0xcb77 },
	{ 0x2478, 0xcb78 },
	{ 0x2479, 0xcb79 },
	{ 0x247a, 0xcb7a },
	{ 0x247b, 0xcb7b },
	{ 0x247c, 0xcb7c },
	{ 0x247d, 0xcb7d },
	{ 0x247e, 0xcb7e },
	{ 0x2521, 0xcba1 },
	{ 0x2522, 0xcba2 },
	{ 0x2523, 0xcba3 },
	{ 0x2524, 0xcba4 },
	{ 0x2525, 0xcba5 },
	{ 0x2526, 0xcba6 },
	{ 0x2527, 0xcba7 },
	{ 0x2528, 0xcba8 },
	{ 0x2529, 0xcba9 },
	{ 0x252a, 0xcbaa },
	{ 0x252b, 0xcbab },
	{ 0x252c, 0xcbac },
	{ 0x252d, 0xcbad },
	{ 0x252e, 0xcbae },
	{ 0x252f, 0xcbaf },
	{ 0x2530, 0xcbb0 },
	{ 0x2531, 0xcbb1 },
	{ 0x2532, 0xcbb2 },
	{ 0x2533, 0xcbb3 },
	{ 0x2534, 0xcbb4 },
	{ 0x2535, 0xcbb5 },
	{ 0x2536, 0xcbb6 },
	{ 0x2537, 0xcbb7 },
	{ 0x2538, 0xcbb8 },
	{ 0x2539, 0xcbb9 },
	{ 0x253a, 0xcbba },
	{ 0x253b, 0xcbbb },
	{ 0x253c, 0xcbbc },
	{ 0x253d, 0xcbbd },
	{ 0x253e, 0xcbbe },
	{ 0x253f, 0xcbbf },
	{ 0x2540, 0xcbc0 },
	{ 0x2541, 0xcbc1 },
	{ 0x2542, 0xcbc2 },
	{ 0x2543, 0xcbc3 },
	{ 0x2544, 0xcbc4 },
	{ 0x2545, 0xcbc5 },
	{ 0x2546, 0xcbc6 },
	{ 0x2547, 0xcbc7 },
	{ 0x2548, 0xcbc8 },
	{ 0x2549, 0xcbc9 },
	{ 0x254a, 0xcbca },
	{ 0x254b, 0xcbcb },
	{ 0x254c, 0xcbcc },
	{ 0x254d, 0xcbcd },
	{ 0x254e, 0xcbce },
	{ 0x254f, 0xcbcf },
	{ 0x2550, 0xcbd0 },
	{ 0x2551, 0xcbd1 },
	{ 0x2552, 0xcbd2 },
	{ 0x2553, 0xcbd3 },
	{ 0x2554, 0xcbd4 },
	{ 0x2555, 0xcbd5 },
	{ 0x2556, 0xcbd6 },
	{ 0x2557, 0xcbd7 },
	{ 0x2558, 0xcbd8 },
	{ 0x2559, 0xcbd9 },
	{ 0x255a, 0xcbda },
	{ 0x255b, 0xcbdb },
	{ 0x255c, 0xcbdc },
	{ 0x255d, 0xcbdd },
	{ 0x255e, 0xcbde },
	{ 0x255f, 0xcbdf },
	{ 0x2560, 0xcbe0 },
	{ 0x2561, 0xcbe1 },
	{ 0x2562, 0xcbe2 },
	{ 0x2563, 0xcbe3 },
	{ 0x2564, 0xcbe4 },
	{ 0x2565, 0xcbe5 },
	{ 0x2566, 0xcbe6 },
	{ 0x2567, 0xcbe7 },
	{ 0x2568, 0xcbe8 },
	{ 0x2569, 0xcbe9 },
	{ 0x256a, 0xcbea },
	{ 0x256b, 0xcbeb },
	{ 0x256c, 0xcbec },
	{ 0x256d, 0xcbed },
	{ 0x256e, 0xcbee },
	{ 0x256f, 0xcbef },
	{ 0x2570, 0xcbf0 },
	{ 0x2571, 0xcbf1 },
	{ 0x2572, 0xcbf2 },
	{ 0x2573, 0xcbf3 },
	{ 0x2574, 0xcbf4 },
	{ 0x2575, 0xcbf5 },
	{ 0x2576, 0xcbf6 },
	{ 0x2577, 0xcbf7 },
	{ 0x2578, 0xcbf8 },
	{ 0x2579, 0xcbf9 },
	{ 0x257a, 0xcbfa },
	{ 0x257b, 0xcbfb },
	{ 0x257c, 0xcbfc },
	{ 0x257d, 0xcbfd },
	{ 0x257e, 0xcbfe },
	{ 0x2621, 0xcc40 },
	{ 0x2622, 0xcc41 },
	{ 0x2623, 0xcc42 },
	{ 0x2624, 0xcc43 },
	{ 0x2625, 0xcc44 },
	{ 0x2626, 0xcc45 },
	{ 0x2627, 0xcc46 },
	{ 0x2628, 0xcc47 },
	{ 0x2629, 0xcc48 },
	{ 0x262a, 0xcc49 },
	{ 0x262b, 0xcc4a },
	{ 0x262c, 0xcc4b },
	{ 0x262d, 0xcc4c },
	{ 0x262e, 0xcc4d },
	{ 0x262f, 0xcc4e },
	{ 0x2630, 0xcc4f },
	{ 0x2631, 0xcc50 },
	{ 0x2632, 0xcc51 },
	{ 0x2633, 0xcc52 },
	{ 0x2634, 0xcc53 },
	{ 0x2635, 0xcc54 },
	{ 0x2636, 0xcc55 },
	{ 0x2637, 0xcc56 },
	{ 0x2638, 0xcc57 },
	{ 0x2639, 0xcc58 },
	{ 0x263a, 0xcc59 },
	{ 0x263b, 0xcc5a },
	{ 0x263c, 0xcc5b },
	{ 0x263d, 0xcc5c },
	{ 0x263e, 0xcc5d },
	{ 0x263f, 0xcc5e },
	{ 0x2640, 0xcc5f },
	{ 0x2641, 0xcc60 },
	{ 0x2642, 0xcc61 },
	{ 0x2643, 0xcc62 },
	{ 0x2644, 0xcc63 },
	{ 0x2645, 0xcc64 },
	{ 0x2646, 0xcc65 },
	{ 0x2647, 0xcc66 },
	{ 0x2648, 0xcc67 },
	{ 0x2649, 0xcc68 },
	{ 0x264a, 0xcc69 },
	{ 0x264b, 0xcc6a },
	{ 0x264c, 0xcc6b },
	{ 0x264d, 0xcc6c },
	{ 0x264e, 0xcc6d },
	{ 0x264f, 0xcc6e },
	{ 0x2650, 0xcc6f },
	{ 0x2651, 0xcc70 },
	{ 0x2652, 0xcc71 },
	{ 0x2653, 0xcc72 },
	{ 0x2654, 0xcc73 },
	{ 0x2655, 0xcc74 },
	{ 0x2656, 0xcc75 },
	{ 0x2657, 0xcc76 },
	{ 0x2658, 0xcc77 },
	{ 0x2659, 0xcc78 },
	{ 0x265a, 0xcc79 },
	{ 0x265b, 0xcc7a },
	{ 0x265c, 0xcc7b },
	{ 0x265d, 0xcc7c },
	{ 0x265e, 0xcc7d },
	{ 0x265f, 0xcc7e },
	{ 0x2660, 0xcca1 },
	{ 0x2661, 0xcca2 },
	{ 0x2662, 0xcca3 },
	{ 0x2663, 0xcca4 },
	{ 0x2664, 0xcca5 },
	{ 0x2665, 0xcca6 },
	{ 0x2666, 0xcca7 },
	{ 0x2667, 0xcca8 },
	{ 0x2668, 0xcca9 },
	{ 0x2669, 0xccaa },
	{ 0x266a, 0xccab },
	{ 0x266b, 0xccac },
	{ 0x266c, 0xccad },
	{ 0x266d, 0xccae },
	{ 0x266e, 0xccaf },
	{ 0x266f, 0xccb0 },
	{ 0x2670, 0xccb1 },
	{ 0x2671, 0xccb2 },
	{ 0x2672, 0xccb3 },
	{ 0x2673, 0xccb4 },
	{ 0x2674, 0xccb5 },
	{ 0x2675, 0xccb6 },
	{ 0x2676, 0xccb7 },
	{ 0x2677, 0xccb8 },
	{ 0x2678, 0xccb9 },
	{ 0x2679, 0xccba },
	{ 0x267a, 0xccbb },
	{ 0x267b, 0xccbc },
	{ 0x267c, 0xccbd },
	{ 0x267d, 0xccbe },
	{ 0x267e, 0xccbf },
	{ 0x2721, 0xccc0 },
	{ 0x2722, 0xccc1 },
	{ 0x2723, 0xccc2 },
	{ 0x2724, 0xccc3 },
	{ 0x2725, 0xccc4 },
	{ 0x2726, 0xccc5 },
	{ 0x2727, 0xccc6 },
	{ 0x2728, 0xccc7 },
	{ 0x2729, 0xccc8 },
	{ 0x272a, 0xccc9 },
	{ 0x272b, 0xccca },
	{ 0x272c, 0xcccb },
	{ 0x272d, 0xcccc },
	{ 0x272e, 0xcccd },
	{ 0x272f, 0xccce },
	{ 0x2730, 0xcccf },
	{ 0x2731, 0xccd0 },
	{ 0x2732, 0xccd1 },
	{ 0x2733, 0xccd2 },
	{ 0x2734, 0xccd3 },
	{ 0x2735, 0xccd4 },
	{ 0x2736, 0xccd5 },
	{ 0x2737, 0xccd6 },
	{ 0x2738, 0xccd7 },
	{ 0x2739, 0xccd8 },
	{ 0x273a, 0xccd9 },
	{ 0x273b, 0xccda },
	{ 0x273c, 0xccdb },
	{ 0x273d, 0xccdc },
	{ 0x273e, 0xccdd },
	{ 0x273f, 0xccde },
	{ 0x2740, 0xccdf },
	{ 0x2741, 0xcce0 },
	{ 0x2742, 0xcce1 },
	{ 0x2743, 0xcce2 },
	{ 0x2744, 0xcce3 },
	{ 0x2745, 0xcce4 },
	{ 0x2746, 0xcce5 },
	{ 0x2747, 0xcce6 },
	{ 0x2748, 0xcce7 },
	{ 0x2749, 0xcce8 },
	{ 0x274a, 0xcce9 },
	{ 0x274b, 0xccea },
	{ 0x274c, 0xcceb },
	{ 0x274d, 0xccec },
	{ 0x274e, 0xcced },
	{ 0x274f, 0xccee },
	{ 0x2750, 0xccef },
	{ 0x2751, 0xccf0 },
	{ 0x2752, 0xccf1 },
	{ 0x2753, 0xccf2 },
	{ 0x2754, 0xccf3 },
	{ 0x2755, 0xccf4 },
	{ 0x2756, 0xccf5 },
	{ 0x2757, 0xccf6 },
	{ 0x2758, 0xccf7 },
	{ 0x2759, 0xccf8 },
	{ 0x275a, 0xccf9 },
	{ 0x275b, 0xccfa },
	{ 0x275c, 0xccfb },
	{ 0x275d, 0xccfc },
	{ 0x275e, 0xccfd },
	{ 0x275f, 0xccfe },
	{ 0x2760, 0xcd40 },
	{ 0x2761, 0xcd41 },
	{ 0x2762, 0xcd42 },
	{ 0x2763, 0xcd43 },
	{ 0x2764, 0xcd44 },
	{ 0x2765, 0xcd45 },
	{ 0x2766, 0xcd46 },
	{ 0x2767, 0xcd47 },
	{ 0x2768, 0xcd48 },
	{ 0x2769, 0xcd49 },
	{ 0x276a, 0xcd4a },
	{ 0x276b, 0xcd4b },
	{ 0x276c, 0xcd4c },
	{ 0x276d, 0xcd4d },
	{ 0x276e, 0xcd4e },
	{ 0x276f, 0xcd4f },
	{ 0x2770, 0xcd50 },
	{ 0x2771, 0xcd51 },
	{ 0x2772, 0xcd52 },
	{ 0x2773, 0xcd53 },
	{ 0x2774, 0xcd54 },
	{ 0x2775, 0xcd55 },
	{ 0x2776, 0xcd56 },
	{ 0x2777, 0xcd57 },
	{ 0x2778, 0xcd58 },
	{ 0x2779, 0xcd59 },
	{ 0x277a, 0xcd5a },
	{ 0x277b, 0xcd5b },
	{ 0x277c, 0xcd5c },
	{ 0x277d, 0xcd5d },
	{ 0x277e, 0xcd5e },
	{ 0x2821, 0xcd5f },
	{ 0x2822, 0xcd60 },
	{ 0x2823, 0xcd61 },
	{ 0x2824, 0xcd62 },
	{ 0x2825, 0xcd63 },
	{ 0x2826, 0xcd64 },
	{ 0x2827, 0xcd65 },
	{ 0x2828, 0xcd66 },
	{ 0x2829, 0xcd67 },
	{ 0x282a, 0xcd68 },
	{ 0x282b, 0xcd69 },
	{ 0x282c, 0xcd6a },
	{ 0x282d, 0xcd6b },
	{ 0x282e, 0xcd6c },
	{ 0x282f, 0xcd6d },
	{ 0x2830, 0xcd6e },
	{ 0x2831, 0xcd6f },
	{ 0x2832, 0xcd70 },
	{ 0x2833, 0xcd71 },
	{ 0x2834, 0xcd72 },
	{ 0x2835, 0xcd73 },
	{ 0x2836, 0xcd74 },
	{ 0x2837, 0xcd75 },
	{ 0x2838, 0xcd76 },
	{ 0x2839, 0xcd77 },
	{ 0x283a, 0xcd78 },
	{ 0x283b, 0xcd79 },
	{ 0x283c, 0xcd7a },
	{ 0x283d, 0xcd7b },
	{ 0x283e, 0xcd7c },
	{ 0x283f, 0xcd7d },
	{ 0x2840, 0xcd7e },
	{ 0x2841, 0xcda1 },
	{ 0x2842, 0xcda2 },
	{ 0x2843, 0xcda3 },
	{ 0x2844, 0xcda4 },
	{ 0x2845, 0xcda5 },
	{ 0x2846, 0xcda6 },
	{ 0x2847, 0xcda7 },
	{ 0x2848, 0xcda8 },
	{ 0x2849, 0xcda9 },
	{ 0x284a, 0xcdaa },
	{ 0x284b, 0xcdab },
	{ 0x284c, 0xcdac },
	{ 0x284d, 0xcdad },
	{ 0x284e, 0xcdae },
	{ 0x284f, 0xcdaf },
	{ 0x2850, 0xcdb0 },
	{ 0x2851, 0xcdb1 },
	{ 0x2852, 0xcdb2 },
	{ 0x2853, 0xcdb3 },
	{ 0x2854, 0xcdb4 },
	{ 0x2855, 0xcdb5 },
	{ 0x2856, 0xcdb6 },
	{ 0x2857, 0xcdb7 },
	{ 0x2858, 0xcdb8 },
	{ 0x2859, 0xcdb9 },
	{ 0x285a, 0xcdba },
	{ 0x285b, 0xcdbb },
	{ 0x285c, 0xcdbc },
	{ 0x285d, 0xcdbd },
	{ 0x285e, 0xcdbe },
	{ 0x285f, 0xcdbf },
	{ 0x2860, 0xcdc0 },
	{ 0x2861, 0xcdc1 },
	{ 0x2862, 0xcdc2 },
	{ 0x2863, 0xcdc3 },
	{ 0x2864, 0xcdc4 },
	{ 0x2865, 0xcdc5 },
	{ 0x2866, 0xcdc6 },
	{ 0x2867, 0xcdc7 },
	{ 0x2868, 0xcdc8 },
	{ 0x2869, 0xcdc9 },
	{ 0x286a, 0xcdca },
	{ 0x286b, 0xcdcb },
	{ 0x286c, 0xcdcc },
	{ 0x286d, 0xcdcd },
	{ 0x286e, 0xcdce },
	{ 0x286f, 0xcdcf },
	{ 0x2870, 0xcdd0 },
	{ 0x2871, 0xcdd1 },
	{ 0x2872, 0xcdd2 },
	{ 0x2873, 0xcdd3 },
	{ 0x2874, 0xcdd4 },
	{ 0x2875, 0xcdd5 },
	{ 0x2876, 0xcdd6 },
	{ 0x2877, 0xcdd7 },
	{ 0x2878, 0xcdd8 },
	{ 0x2879, 0xcdd9 },
	{ 0x287a, 0xcdda },
	{ 0x287b, 0xcddb },
	{ 0x287c, 0xcddc },
	{ 0x287d, 0xcddd },
	{ 0x287e, 0xcdde },
	{ 0x2921, 0xcddf },
	{ 0x2922, 0xcde0 },
	{ 0x2923, 0xcde1 },
	{ 0x2924, 0xcde2 },
	{ 0x2925, 0xcde3 },
	{ 0x2926, 0xcde4 },
	{ 0x2927, 0xcde5 },
	{ 0x2928, 0xcde6 },
	{ 0x2929, 0xcde7 },
	{ 0x292a, 0xcde8 },
	{ 0x292b, 0xcde9 },
	{ 0x292c, 0xcdea },
	{ 0x292d, 0xcdeb },
	{ 0x292e, 0xcdec },
	{ 0x292f, 0xcded },
	{ 0x2930, 0xcdee },
	{ 0x2931, 0xcdef },
	{ 0x2932, 0xcdf0 },
	{ 0x2933, 0xcdf1 },
	{ 0x2934, 0xcdf2 },
	{ 0x2935, 0xcdf3 },
	{ 0x2936, 0xcdf4 },
	{ 0x2937, 0xcdf5 },
	{ 0x2938, 0xcdf6 },
	{ 0x2939, 0xcdf7 },
	{ 0x293a, 0xcdf8 },
	{ 0x293b, 0xcdf9 },
	{ 0x293c, 0xcdfa },
	{ 0x293d, 0xcdfb },
	{ 0x293e, 0xcdfc },
	{ 0x293f, 0xcdfd },
	{ 0x2940, 0xcdfe },
	{ 0x2941, 0xce40 },
	{ 0x2942, 0xce41 },
	{ 0x2943, 0xce42 },
	{ 0x2944, 0xce43 },
	{ 0x2945, 0xce44 },
	{ 0x2946, 0xce45 },
	{ 0x2947, 0xce46 },
	{ 0x2948, 0xce47 },
	{ 0x2949, 0xce48 },
	{ 0x294a, 0xce49 },
	{ 0x294b, 0xce4a },
	{ 0x294c, 0xce4b },
	{ 0x294d, 0xce4c },
	{ 0x294e, 0xce4d },
	{ 0x294f, 0xce4e },
	{ 0x2950, 0xce4f },
	{ 0x2951, 0xce50 },
	{ 0x2952, 0xce51 },
	{ 0x2953, 0xce52 },
	{ 0x2954, 0xce53 },
	{ 0x2955, 0xce54 },
	{ 0x2956, 0xce55 },
	{ 0x2957, 0xce56 },
	{ 0x2958, 0xce57 },
	{ 0x2959, 0xce58 },
	{ 0x295a, 0xce59 },
	{ 0x295b, 0xce5a },
	{ 0x295c, 0xce5b },
	{ 0x295d, 0xce5c },
	{ 0x295e, 0xce5d },
	{ 0x295f, 0xce5e },
	{ 0x2960, 0xce5f },
	{ 0x2961, 0xce60 },
	{ 0x2962, 0xce61 },
	{ 0x2963, 0xce62 },
	{ 0x2964, 0xce63 },
	{ 0x2965, 0xce64 },
	{ 0x2966, 0xce65 },
	{ 0x2967, 0xce66 },
	{ 0x2968, 0xce67 },
	{ 0x2969, 0xce68 },
	{ 0x296a, 0xce69 },
	{ 0x296b, 0xce6a },
	{ 0x296c, 0xce6b },
	{ 0x296d, 0xce6c },
	{ 0x296e, 0xce6d },
	{ 0x296f, 0xce6e },
	{ 0x2970, 0xce6f },
	{ 0x2971, 0xce70 },
	{ 0x2972, 0xce71 },
	{ 0x2973, 0xce72 },
	{ 0x2974, 0xce73 },
	{ 0x2975, 0xce74 },
	{ 0x2976, 0xce75 },
	{ 0x2977, 0xce76 },
	{ 0x2978, 0xce77 },
	{ 0x2979, 0xce78 },
	{ 0x297a, 0xce79 },
	{ 0x297b, 0xce7a },
	{ 0x297c, 0xce7b },
	{ 0x297d, 0xce7c },
	{ 0x297e, 0xce7d },
	{ 0x2a21, 0xce7e },
	{ 0x2a22, 0xcea1 },
	{ 0x2a23, 0xcea2 },
	{ 0x2a24, 0xcea3 },
	{ 0x2a25, 0xcea4 },
	{ 0x2a26, 0xcea5 },
	{ 0x2a27, 0xcea6 },
	{ 0x2a28, 0xcea7 },
	{ 0x2a29, 0xcea8 },
	{ 0x2a2a, 0xcea9 },
	{ 0x2a2b, 0xceaa },
	{ 0x2a2c, 0xceab },
	{ 0x2a2d, 0xceac },
	{ 0x2a2e, 0xcead },
	{ 0x2a2f, 0xceae },
	{ 0x2a30, 0xceaf },
	{ 0x2a31, 0xceb0 },
	{ 0x2a32, 0xceb1 },
	{ 0x2a33, 0xceb2 },
	{ 0x2a34, 0xceb3 },
	{ 0x2a35, 0xceb4 },
	{ 0x2a36, 0xceb5 },
	{ 0x2a37, 0xceb6 },
	{ 0x2a38, 0xceb7 },
	{ 0x2a39, 0xceb8 },
	{ 0x2a3a, 0xceb9 },
	{ 0x2a3b, 0xceba },
	{ 0x2a3c, 0xcebb },
	{ 0x2a3d, 0xcebc },
	{ 0x2a3e, 0xcebd },
	{ 0x2a3f, 0xcebe },
	{ 0x2a40, 0xcebf },
	{ 0x2a41, 0xcec0 },
	{ 0x2a42, 0xcec1 },
	{ 0x2a43, 0xcec2 },
	{ 0x2a44, 0xcec3 },
	{ 0x2a45, 0xcec4 },
	{ 0x2a46, 0xcec5 },
	{ 0x2a47, 0xcec6 },
	{ 0x2a48, 0xcec7 },
	{ 0x2a49, 0xcec8 },
	{ 0x2a4a, 0xcec9 },
	{ 0x2a4b, 0xceca },
	{ 0x2a4c, 0xcecb },
	{ 0x2a4d, 0xcecc },
	{ 0x2a4e, 0xcecd },
	{ 0x2a4f, 0xcece },
	{ 0x2a50, 0xcecf },
	{ 0x2a51, 0xced0 },
	{ 0x2a52, 0xced1 },
	{ 0x2a53, 0xced2 },
	{ 0x2a54, 0xced3 },
	{ 0x2a55, 0xced4 },
	{ 0x2a56, 0xced5 },
	{ 0x2a57, 0xced6 },
	{ 0x2a58, 0xced7 },
	{ 0x2a59, 0xced8 },
	{ 0x2a5a, 0xced9 },
	{ 0x2a5b, 0xceda },
	{ 0x2a5c, 0xcedb },
	{ 0x2a5d, 0xcedc },
	{ 0x2a5e, 0xcedd },
	{ 0x2a5f, 0xcede },
	{ 0x2a60, 0xcedf },
	{ 0x2a61, 0xcee0 },
	{ 0x2a62, 0xcee1 },
	{ 0x2a63, 0xcee2 },
	{ 0x2a64, 0xcee3 },
	{ 0x2a65, 0xcee4 },
	{ 0x2a66, 0xcee5 },
	{ 0x2a67, 0xcee6 },
	{ 0x2a68, 0xcee7 },
	{ 0x2a69, 0xcee8 },
	{ 0x2a6a, 0xcee9 },
	{ 0x2a6b, 0xceea },
	{ 0x2a6c, 0xceeb },
	{ 0x2a6d, 0xceec },
	{ 0x2a6e, 0xceed },
	{ 0x2a6f, 0xceee },
	{ 0x2a70, 0xceef },
	{ 0x2a71, 0xcef0 },
	{ 0x2a72, 0xcef1 },
	{ 0x2a73, 0xcef2 },
	{ 0x2a74, 0xcef3 },
	{ 0x2a75, 0xcef4 },
	{ 0x2a76, 0xcef5 },
	{ 0x2a77, 0xcef6 },
	{ 0x2a78, 0xcef7 },
	{ 0x2a79, 0xcef8 },
	{ 0x2a7a, 0xcef9 },
	{ 0x2a7b, 0xcefa },
	{ 0x2a7c, 0xcefb },
	{ 0x2a7d, 0xcefc },
	{ 0x2a7e, 0xcefd },
	{ 0x2b21, 0xcefe },
	{ 0x2b22, 0xcf40 },
	{ 0x2b23, 0xcf41 },
	{ 0x2b24, 0xcf42 },
	{ 0x2b25, 0xcf43 },
	{ 0x2b26, 0xcf44 },
	{ 0x2b27, 0xcf45 },
	{ 0x2b28, 0xcf46 },
	{ 0x2b29, 0xcf47 },
	{ 0x2b2a, 0xcf48 },
	{ 0x2b2b, 0xcf49 },
	{ 0x2b2c, 0xcf4a },
	{ 0x2b2d, 0xcf4b },
	{ 0x2b2e, 0xcf4c },
	{ 0x2b2f, 0xcf4d },
	{ 0x2b30, 0xcf4e },
	{ 0x2b31, 0xcf4f },
	{ 0x2b32, 0xcf50 },
	{ 0x2b33, 0xcf51 },
	{ 0x2b34, 0xcf52 },
	{ 0x2b35, 0xcf53 },
	{ 0x2b36, 0xcf54 },
	{ 0x2b37, 0xcf55 },
	{ 0x2b38, 0xcf56 },
	{ 0x2b39, 0xcf57 },
	{ 0x2b3a, 0xcf58 },
	{ 0x2b3b, 0xcf59 },
	{ 0x2b3c, 0xcf5a },
	{ 0x2b3d, 0xcf5b },
	{ 0x2b3e, 0xcf5c },
	{ 0x2b3f, 0xcf5d },
	{ 0x2b40, 0xcf5e },
	{ 0x2b41, 0xcf5f },
	{ 0x2b42, 0xcf60 },
	{ 0x2b43, 0xcf61 },
	{ 0x2b44, 0xcf62 },
	{ 0x2b45, 0xcf63 },
	{ 0x2b46, 0xcf64 },
	{ 0x2b47, 0xcf65 },
	{ 0x2b48, 0xcf66 },
	{ 0x2b49, 0xcf67 },
	{ 0x2b4a, 0xcf68 },
	{ 0x2b4b, 0xcf69 },
	{ 0x2b4c, 0xcf6a },
	{ 0x2b4d, 0xcf6b },
	{ 0x2b4e, 0xcf6c },
	{ 0x2b4f, 0xcf6d },
	{ 0x2b50, 0xcf6e },
	{ 0x2b51, 0xcf6f },
	{ 0x2b52, 0xcf70 },
	{ 0x2b53, 0xcf71 },
	{ 0x2b54, 0xcf72 },
	{ 0x2b55, 0xcf73 },
	{ 0x2b56, 0xcf74 },
	{ 0x2b57, 0xcf75 },
	{ 0x2b58, 0xcf76 },
	{ 0x2b59, 0xcf77 },
	{ 0x2b5a, 0xcf78 },
	{ 0x2b5b, 0xcf79 },
	{ 0x2b5c, 0xcf7a },
	{ 0x2b5d, 0xcf7b },
	{ 0x2b5e, 0xcf7c },
	{ 0x2b5f, 0xcf7d },
	{ 0x2b60, 0xcf7e },
	{ 0x2b61, 0xcfa1 },
	{ 0x2b62, 0xcfa2 },
	{ 0x2b63, 0xcfa3 },
	{ 0x2b64, 0xcfa4 },
	{ 0x2b65, 0xcfa5 },
	{ 0x2b66, 0xcfa6 },
	{ 0x2b67, 0xcfa7 },
	{ 0x2b68, 0xcfa8 },
	{ 0x2b69, 0xcfa9 },
	{ 0x2b6a, 0xcfaa },
	{ 0x2b6b, 0xcfab },
	{ 0x2b6c, 0xcfac },
	{ 0x2b6d, 0xcfad },
	{ 0x2b6e, 0xcfae },
	{ 0x2b6f, 0xcfaf },
	{ 0x2b70, 0xcfb0 },
	{ 0x2b71, 0xcfb1 },
	{ 0x2b72, 0xcfb2 },
	{ 0x2b73, 0xcfb3 },
	{ 0x2b74, 0xcfb4 },
	{ 0x2b75, 0xcfb5 },
	{ 0x2b76, 0xcfb6 },
	{ 0x2b77, 0xcfb7 },
	{ 0x2b78, 0xcfb8 },
	{ 0x2b79, 0xcfb9 },
	{ 0x2b7a, 0xcfba },
	{ 0x2b7b, 0xcfbb },
	{ 0x2b7c, 0xcfbc },
	{ 0x2b7d, 0xcfbd },
	{ 0x2b7e, 0xcfbe },
	{ 0x2c21, 0xcfbf },
	{ 0x2c22, 0xcfc0 },
	{ 0x2c23, 0xcfc1 },
	{ 0x2c24, 0xcfc2 },
	{ 0x2c25, 0xcfc3 },
	{ 0x2c26, 0xcfc4 },
	{ 0x2c27, 0xcfc5 },
	{ 0x2c28, 0xcfc6 },
	{ 0x2c29, 0xcfc7 },
	{ 0x2c2a, 0xcfc8 },
	{ 0x2c2b, 0xcfc9 },
	{ 0x2c2c, 0xcfca },
	{ 0x2c2d, 0xcfcb },
	{ 0x2c2e, 0xcfcc },
	{ 0x2c2f, 0xcfcd },
	{ 0x2c30, 0xcfce },
	{ 0x2c31, 0xcfcf },
	{ 0x2c32, 0xcfd0 },
	{ 0x2c33, 0xcfd1 },
	{ 0x2c34, 0xcfd2 },
	{ 0x2c35, 0xcfd3 },
	{ 0x2c36, 0xcfd4 },
	{ 0x2c37, 0xcfd5 },
	{ 0x2c38, 0xcfd6 },
	{ 0x2c39, 0xcfd7 },
	{ 0x2c3a, 0xcfd8 },
	{ 0x2c3b, 0xcfd9 },
	{ 0x2c3c, 0xcfda },
	{ 0x2c3d, 0xcfdb },
	{ 0x2c3e, 0xcfdc },
	{ 0x2c3f, 0xcfdd },
	{ 0x2c40, 0xcfde },
	{ 0x2c41, 0xcfdf },
	{ 0x2c42, 0xcfe0 },
	{ 0x2c43, 0xcfe1 },
	{ 0x2c44, 0xcfe2 },
	{ 0x2c45, 0xcfe3 },
	{ 0x2c46, 0xcfe4 },
	{ 0x2c47, 0xcfe5 },
	{ 0x2c48, 0xcfe6 },
	{ 0x2c49, 0xcfe7 },
	{ 0x2c4a, 0xcfe8 },
	{ 0x2c4b, 0xcfe9 },
	{ 0x2c4c, 0xcfea },
	{ 0x2c4d, 0xcfeb },
	{ 0x2c4e, 0xcfec },
	{ 0x2c4f, 0xcfed },
	{ 0x2c50, 0xcfee },
	{ 0x2c51, 0xcfef },
	{ 0x2c52, 0xcff0 },
	{ 0x2c53, 0xcff1 },
	{ 0x2c54, 0xcff2 },
	{ 0x2c55, 0xcff3 },
	{ 0x2c56, 0xcff4 },
	{ 0x2c57, 0xcff5 },
	{ 0x2c58, 0xcff6 },
	{ 0x2c59, 0xcff7 },
	{ 0x2c5a, 0xcff8 },
	{ 0x2c5b, 0xcff9 },
	{ 0x2c5c, 0xcffa },
	{ 0x2c5d, 0xcffb },
	{ 0x2c5e, 0xcffc },
	{ 0x2c5f, 0xcffd },
	{ 0x2c60, 0xcffe },
	{ 0x2c61, 0xd040 },
	{ 0x2c62, 0xd041 },
	{ 0x2c63, 0xd042 },
	{ 0x2c64, 0xd043 },
	{ 0x2c65, 0xd044 },
	{ 0x2c66, 0xd045 },
	{ 0x2c67, 0xd046 },
	{ 0x2c68, 0xd047 },
	{ 0x2c69, 0xd048 },
	{ 0x2c6a, 0xd049 },
	{ 0x2c6b, 0xd04a },
	{ 0x2c6c, 0xd04b },
	{ 0x2c6d, 0xd04c },
	{ 0x2c6e, 0xd04d },
	{ 0x2c6f, 0xd04e },
	{ 0x2c70, 0xd04f },
	{ 0x2c71, 0xd050 },
	{ 0x2c72, 0xd051 },
	{ 0x2c73, 0xd052 },
	{ 0x2c74, 0xd053 },
	{ 0x2c75, 0xd054 },
	{ 0x2c76, 0xd055 },
	{ 0x2c77, 0xd056 },
	{ 0x2c78, 0xd057 },
	{ 0x2c79, 0xd058 },
	{ 0x2c7a, 0xd059 },
	{ 0x2c7b, 0xd05a },
	{ 0x2c7c, 0xd05b },
	{ 0x2c7d, 0xd05c },
	{ 0x2c7e, 0xd05d },
	{ 0x2d21, 0xd05e },
	{ 0x2d22, 0xd05f },
	{ 0x2d23, 0xd060 },
	{ 0x2d24, 0xd061 },
	{ 0x2d25, 0xd062 },
	{ 0x2d26, 0xd063 },
	{ 0x2d27, 0xd064 },
	{ 0x2d28, 0xd065 },
	{ 0x2d29, 0xd066 },
	{ 0x2d2a, 0xd067 },
	{ 0x2d2b, 0xd068 },
	{ 0x2d2c, 0xd069 },
	{ 0x2d2d, 0xd06a },
	{ 0x2d2e, 0xd06b },
	{ 0x2d2f, 0xd06c },
	{ 0x2d30, 0xd06d },
	{ 0x2d31, 0xd06e },
	{ 0x2d32, 0xd06f },
	{ 0x2d33, 0xd070 },
	{ 0x2d34, 0xd071 },
	{ 0x2d35, 0xd072 },
	{ 0x2d36, 0xd073 },
	{ 0x2d37, 0xd074 },
	{ 0x2d38, 0xd075 },
	{ 0x2d39, 0xd076 },
	{ 0x2d3a, 0xd077 },
	{ 0x2d3b, 0xd078 },
	{ 0x2d3c, 0xd079 },
	{ 0x2d3d, 0xd07a },
	{ 0x2d3e, 0xd07b },
	{ 0x2d3f, 0xd07c },
	{ 0x2d40, 0xd07d },
	{ 0x2d41, 0xd07e },
	{ 0x2d42, 0xd0a1 },
	{ 0x2d43, 0xd0a2 },
	{ 0x2d44, 0xd0a3 },
	{ 0x2d45, 0xd0a4 },
	{ 0x2d46, 0xd0a5 },
	{ 0x2d47, 0xd0a6 },
	{ 0x2d48, 0xd0a7 },
	{ 0x2d49, 0xd0a8 },
	{ 0x2d4a, 0xd0a9 },
	{ 0x2d4b, 0xd0aa },
	{ 0x2d4c, 0xd0ab },
	{ 0x2d4d, 0xd0ac },
	{ 0x2d4e, 0xd0ad },
	{ 0x2d4f, 0xd0ae },
	{ 0x2d50, 0xd0af },
	{ 0x2d51, 0xd0b0 },
	{ 0x2d52, 0xd0b1 },
	{ 0x2d53, 0xd0b2 },
	{ 0x2d54, 0xd0b3 },
	{ 0x2d55, 0xd0b4 },
	{ 0x2d56, 0xd0b5 },
	{ 0x2d57, 0xd0b6 },
	{ 0x2d58, 0xd0b7 },
	{ 0x2d59, 0xd0b8 },
	{ 0x2d5a, 0xd0b9 },
	{ 0x2d5b, 0xd0ba },
	{ 0x2d5c, 0xd0bb },
	{ 0x2d5d, 0xd0bc },
	{ 0x2d5e, 0xd0bd },
	{ 0x2d5f, 0xd0be },
	{ 0x2d60, 0xd0bf },
	{ 0x2d61, 0xd0c0 },
	{ 0x2d62, 0xd0c1 },
	{ 0x2d63, 0xd0c2 },
	{ 0x2d64, 0xd0c3 },
	{ 0x2d65, 0xd0c4 },
	{ 0x2d66, 0xd0c5 },
	{ 0x2d67, 0xd0c6 },
	{ 0x2d68, 0xd0c7 },
	{ 0x2d69, 0xd0c8 },
	{ 0x2d6a, 0xd0c9 },
	{ 0x2d6b, 0xd0ca },
	{ 0x2d6c, 0xd0cb },
	{ 0x2d6d, 0xd0cc },
	{ 0x2d6e, 0xd0cd },
	{ 0x2d6f, 0xd0ce },
	{ 0x2d70, 0xd0cf },
	{ 0x2d71, 0xd0d0 },
	{ 0x2d72, 0xd0d1 },
	{ 0x2d73, 0xd0d2 },
	{ 0x2d74, 0xd0d3 },
	{ 0x2d75, 0xd0d4 },
	{ 0x2d76, 0xd0d5 },
	{ 0x2d77, 0xd0d6 },
	{ 0x2d78, 0xd0d7 },
	{ 0x2d79, 0xd0d8 },
	{ 0x2d7a, 0xd0d9 },
	{ 0x2d7b, 0xd0da },
	{ 0x2d7c, 0xd0db },
	{ 0x2d7d, 0xd0dc },
	{ 0x2d7e, 0xd0dd },
	{ 0x2e21, 0xd0de },
	{ 0x2e22, 0xd0df },
	{ 0x2e23, 0xd0e0 },
	{ 0x2e24, 0xd0e1 },
	{ 0x2e25, 0xd0e2 },
	{ 0x2e26, 0xd0e3 },
	{ 0x2e27, 0xd0e4 },
	{ 0x2e28, 0xd0e5 },
	{ 0x2e29, 0xd0e6 },
	{ 0x2e2a, 0xd0e7 },
	{ 0x2e2b, 0xd0e8 },
	{ 0x2e2c, 0xd0e9 },
	{ 0x2e2d, 0xd0ea },
	{ 0x2e2e, 0xd0eb },
	{ 0x2e2f, 0xd0ec },
	{ 0x2e30, 0xd0ed },
	{ 0x2e31, 0xd0ee },
	{ 0x2e32, 0xd0ef },
	{ 0x2e33, 0xd0f0 },
	{ 0x2e34, 0xd0f1 },
	{ 0x2e35, 0xd0f2 },
	{ 0x2e36, 0xd0f3 },
	{ 0x2e37, 0xd0f4 },
	{ 0x2e38, 0xd0f5 },
	{ 0x2e39, 0xd0f6 },
	{ 0x2e3a, 0xd0f7 },
	{ 0x2e3b, 0xd0f8 },
	{ 0x2e3c, 0xd0f9 },
	{ 0x2e3d, 0xd0fa },
	{ 0x2e3e, 0xd0fb },
	{ 0x2e3f, 0xd0fc },
	{ 0x2e40, 0xd0fd },
	{ 0x2e41, 0xd0fe },
	{ 0x2e42, 0xd140 },
	{ 0x2e43, 0xd141 },
	{ 0x2e44, 0xd142 },
	{ 0x2e45, 0xd143 },
	{ 0x2e46, 0xd144 },
	{ 0x2e47, 0xd145 },
	{ 0x2e48, 0xd146 },
	{ 0x2e49, 0xd147 },
	{ 0x2e4a, 0xd148 },
	{ 0x2e4b, 0xd149 },
	{ 0x2e4c, 0xd14a },
	{ 0x2e4d, 0xd14b },
	{ 0x2e4e, 0xd14c },
	{ 0x2e4f, 0xd14d },
	{ 0x2e50, 0xd14e },
	{ 0x2e51, 0xd14f },
	{ 0x2e52, 0xd150 },
	{ 0x2e53, 0xd151 },
	{ 0x2e54, 0xd152 },
	{ 0x2e55, 0xd153 },
	{ 0x2e56, 0xd154 },
	{ 0x2e57, 0xd155 },
	{ 0x2e58, 0xd156 },
	{ 0x2e59, 0xd157 },
	{ 0x2e5a, 0xd158 },
	{ 0x2e5b, 0xd159 },
	{ 0x2e5c, 0xd15a },
	{ 0x2e5d, 0xd15b },
	{ 0x2e5e, 0xd15c },
	{ 0x2e5f, 0xd15d },
	{ 0x2e60, 0xd15e },
	{ 0x2e61, 0xd15f },
	{ 0x2e62, 0xd160 },
	{ 0x2e63, 0xd161 },
	{ 0x2e64, 0xd162 },
	{ 0x2e65, 0xd163 },
	{ 0x2e66, 0xd164 },
	{ 0x2e67, 0xd165 },
	{ 0x2e68, 0xd166 },
	{ 0x2e69, 0xd167 },
	{ 0x2e6a, 0xd168 },
	{ 0x2e6b, 0xd169 },
	{ 0x2e6c, 0xd16a },
	{ 0x2e6d, 0xd16b },
	{ 0x2e6e, 0xd16c },
	{ 0x2e6f, 0xd16d },
	{ 0x2e70, 0xd16e },
	{ 0x2e71, 0xd16f },
	{ 0x2e72, 0xd170 },
	{ 0x2e73, 0xd171 },
	{ 0x2e74, 0xd172 },
	{ 0x2e75, 0xd173 },
	{ 0x2e76, 0xd174 },
	{ 0x2e77, 0xd175 },
	{ 0x2e78, 0xd176 },
	{ 0x2e79, 0xd177 },
	{ 0x2e7a, 0xd178 },
	{ 0x2e7b, 0xd179 },
	{ 0x2e7c, 0xd17a },
	{ 0x2e7d, 0xd17b },
	{ 0x2e7e, 0xd17c },
	{ 0x2f21, 0xd17d },
	{ 0x2f22, 0xd17e },
	{ 0x2f23, 0xd1a1 },
	{ 0x2f24, 0xd1a2 },
	{ 0x2f25, 0xd1a3 },
	{ 0x2f26, 0xd1a4 },
	{ 0x2f27, 0xd1a5 },
	{ 0x2f28, 0xd1a6 },
	{ 0x2f29, 0xd1a7 },
	{ 0x2f2a, 0xd1a8 },
	{ 0x2f2b, 0xd1a9 },
	{ 0x2f2c, 0xd1aa },
	{ 0x2f2d, 0xd1ab },
	{ 0x2f2e, 0xd1ac },
	{ 0x2f2f, 0xd1ad },
	{ 0x2f30, 0xd1ae },
	{ 0x2f31, 0xd1af },
	{ 0x2f32, 0xd1b0 },
	{ 0x2f33, 0xd1b1 },
	{ 0x2f34, 0xd1b2 },
	{ 0x2f35, 0xd1b3 },
	{ 0x2f36, 0xd1b4 },
	{ 0x2f37, 0xd1b5 },
	{ 0x2f38, 0xd1b6 },
	{ 0x2f39, 0xd1b7 },
	{ 0x2f3a, 0xd1b8 },
	{ 0x2f3b, 0xd1b9 },
	{ 0x2f3c, 0xd1ba },
	{ 0x2f3d, 0xd1bb },
	{ 0x2f3e, 0xd1bc },
	{ 0x2f3f, 0xd1bd },
	{ 0x2f40, 0xd1be },
	{ 0x2f41, 0xd1bf },
	{ 0x2f42, 0xd1c0 },
	{ 0x2f43, 0xd1c1 },
	{ 0x2f44, 0xd1c2 },
	{ 0x2f45, 0xd1c3 },
	{ 0x2f46, 0xd1c4 },
	{ 0x2f47, 0xd1c5 },
	{ 0x2f48, 0xd1c6 },
	{ 0x2f49, 0xd1c7 },
	{ 0x2f4a, 0xd1c8 },
	{ 0x2f4b, 0xd1c9 },
	{ 0x2f4c, 0xd1ca },
	{ 0x2f4d, 0xd1cb },
	{ 0x2f4e, 0xd1cc },
	{ 0x2f4f, 0xd1cd },
	{ 0x2f50, 0xd1ce },
	{ 0x2f51, 0xd1cf },
	{ 0x2f52, 0xd1d0 },
	{ 0x2f53, 0xd1d1 },
	{ 0x2f54, 0xd1d2 },
	{ 0x2f55, 0xd1d3 },
	{ 0x2f56, 0xd1d4 },
	{ 0x2f57, 0xd1d5 },
	{ 0x2f58, 0xd1d6 },
	{ 0x2f59, 0xd1d7 },
	{ 0x2f5a, 0xd1d8 },
	{ 0x2f5b, 0xd1d9 },
	{ 0x2f5c, 0xd1da },
	{ 0x2f5d, 0xd1db },
	{ 0x2f5e, 0xd1dc },
	{ 0x2f5f, 0xd1dd },
	{ 0x2f60, 0xd1de },
	{ 0x2f61, 0xd1df },
	{ 0x2f62, 0xd1e0 },
	{ 0x2f63, 0xd1e1 },
	{ 0x2f64, 0xd1e2 },
	{ 0x2f65, 0xd1e3 },
	{ 0x2f66, 0xd1e4 },
	{ 0x2f67, 0xd1e5 },
	{ 0x2f68, 0xd1e6 },
	{ 0x2f69, 0xd1e7 },
	{ 0x2f6a, 0xd1e8 },
	{ 0x2f6b, 0xd1e9 },
	{ 0x2f6c, 0xd1ea },
	{ 0x2f6d, 0xd1eb },
	{ 0x2f6e, 0xd1ec },
	{ 0x2f6f, 0xd1ed },
	{ 0x2f70, 0xd1ee },
	{ 0x2f71, 0xd1ef },
	{ 0x2f72, 0xd1f0 },
	{ 0x2f73, 0xd1f1 },
	{ 0x2f74, 0xd1f2 },
	{ 0x2f75, 0xd1f3 },
	{ 0x2f76, 0xd1f4 },
	{ 0x2f77, 0xd1f5 },
	{ 0x2f78, 0xd1f6 },
	{ 0x2f79, 0xd1f7 },
	{ 0x2f7a, 0xd1f8 },
	{ 0x2f7b, 0xd1f9 },
	{ 0x2f7c, 0xd1fa },
	{ 0x2f7d, 0xd1fb },
	{ 0x2f7e, 0xd1fc },
	{ 0x3021, 0xd1fd },
	{ 0x3022, 0xd1fe },
	{ 0x3023, 0xd240 },
	{ 0x3024, 0xd241 },
	{ 0x3025, 0xd242 },
	{ 0x3026, 0xd243 },
	{ 0x3027, 0xd244 },
	{ 0x3028, 0xd245 },
	{ 0x3029, 0xd246 },
	{ 0x302a, 0xd247 },
	{ 0x302b, 0xd248 },
	{ 0x302c, 0xd249 },
	{ 0x302d, 0xd24a },
	{ 0x302e, 0xd24b },
	{ 0x302f, 0xd24c },
	{ 0x3030, 0xd24d },
	{ 0x3031, 0xd24e },
	{ 0x3032, 0xd24f },
	{ 0x3033, 0xd250 },
	{ 0x3034, 0xd251 },
	{ 0x3035, 0xd252 },
	{ 0x3036, 0xd253 },
	{ 0x3037, 0xd254 },
	{ 0x3038, 0xd255 },
	{ 0x3039, 0xd256 },
	{ 0x303a, 0xd257 },
	{ 0x303b, 0xd258 },
	{ 0x303c, 0xd259 },
	{ 0x303d, 0xd25a },
	{ 0x303e, 0xd25b },
	{ 0x303f, 0xd25c },
	{ 0x3040, 0xd25d },
	{ 0x3041, 0xd25e },
	{ 0x3042, 0xd25f },
	{ 0x3043, 0xd260 },
	{ 0x3044, 0xd261 },
	{ 0x3045, 0xd262 },
	{ 0x3046, 0xd263 },
	{ 0x3047, 0xd264 },
	{ 0x3048, 0xd265 },
	{ 0x3049, 0xd266 },
	{ 0x304a, 0xd267 },
	{ 0x304b, 0xd268 },
	{ 0x304c, 0xd269 },
	{ 0x304d, 0xd26a },
	{ 0x304e, 0xd26b },
	{ 0x304f, 0xd26c },
	{ 0x3050, 0xd26d },
	{ 0x3051, 0xd26e },
	{ 0x3052, 0xd26f },
	{ 0x3053, 0xd270 },
	{ 0x3054, 0xd271 },
	{ 0x3055, 0xd272 },
	{ 0x3056, 0xd273 },
	{ 0x3057, 0xd274 },
	{ 0x3058, 0xd275 },
	{ 0x3059, 0xd276 },
	{ 0x305a, 0xd277 },
	{ 0x305b, 0xd278 },
	{ 0x305c, 0xd279 },
	{ 0x305d, 0xd27a },
	{ 0x305e, 0xd27b },
	{ 0x305f, 0xd27c },
	{ 0x3060, 0xd27d },
	{ 0x3061, 0xd27e },
	{ 0x3062, 0xd2a1 },
	{ 0x3063, 0xd2a2 },
	{ 0x3064, 0xd2a3 },
	{ 0x3065, 0xd2a4 },
	{ 0x3066, 0xd2a5 },
	{ 0x3067, 0xd2a6 },
	{ 0x3068, 0xd2a7 },
	{ 0x3069, 0xd2a8 },
	{ 0x306a, 0xd2a9 },
	{ 0x306b, 0xd2aa },
	{ 0x306c, 0xd2ab },
	{ 0x306d, 0xd2ac },
	{ 0x306e, 0xd2ad },
	{ 0x306f, 0xd2ae },
	{ 0x3070, 0xd2af },
	{ 0x3071, 0xd2b0 },
	{ 0x3072, 0xd2b1 },
	{ 0x3073, 0xd2b2 },
	{ 0x3074, 0xd2b3 },
	{ 0x3075, 0xd2b4 },
	{ 0x3076, 0xd2b5 },
	{ 0x3077, 0xd2b6 },
	{ 0x3078, 0xd2b7 },
	{ 0x3079, 0xd2b8 },
	{ 0x307a, 0xd2b9 },
	{ 0x307b, 0xd2ba },
	{ 0x307c, 0xd2bb },
	{ 0x307d, 0xd2bc },
	{ 0x307e, 0xd2bd },
	{ 0x3121, 0xd2be },
	{ 0x3122, 0xd2bf },
	{ 0x3123, 0xd2c0 },
	{ 0x3124, 0xd2c1 },
	{ 0x3125, 0xd2c2 },
	{ 0x3126, 0xd2c3 },
	{ 0x3127, 0xd2c4 },
	{ 0x3128, 0xd2c5 },
	{ 0x3129, 0xd2c6 },
	{ 0x312a, 0xd2c7 },
	{ 0x312b, 0xd2c8 },
	{ 0x312c, 0xd2c9 },
	{ 0x312d, 0xd2ca },
	{ 0x312e, 0xd2cb },
	{ 0x312f, 0xd2cc },
	{ 0x3130, 0xd2cd },
	{ 0x3131, 0xd2ce },
	{ 0x3132, 0xd2cf },
	{ 0x3133, 0xd2d0 },
	{ 0x3134, 0xd2d1 },
	{ 0x3135, 0xd2d2 },
	{ 0x3136, 0xd2d3 },
	{ 0x3137, 0xd2d4 },
	{ 0x3138, 0xd2d5 },
	{ 0x3139, 0xd2d6 },
	{ 0x313a, 0xd2d7 },
	{ 0x313b, 0xd2d8 },
	{ 0x313c, 0xd2d9 },
	{ 0x313d, 0xd2da },
	{ 0x313e, 0xd2db },
	{ 0x313f, 0xd2dc },
	{ 0x3140, 0xd2dd },
	{ 0x3141, 0xd2de },
	{ 0x3142, 0xd2df },
	{ 0x3143, 0xd2e0 },
	{ 0x3144, 0xd2e1 },
	{ 0x3145, 0xd2e2 },
	{ 0x3146, 0xd2e3 },
	{ 0x3147, 0xd2e4 },
	{ 0x3148, 0xd2e5 },
	{ 0x3149, 0xd2e6 },
	{ 0x314a, 0xd2e7 },
	{ 0x314b, 0xd2e8 },
	{ 0x314c, 0xd2e9 },
	{ 0x314d, 0xd2ea },
	{ 0x314e, 0xd2eb },
	{ 0x314f, 0xd2ec },
	{ 0x3150, 0xd2ed },
	{ 0x3151, 0xd2ee },
	{ 0x3152, 0xd2ef },
	{ 0x3153, 0xd2f0 },
	{ 0x3154, 0xd2f1 },
	{ 0x3155, 0xd2f2 },
	{ 0x3156, 0xd2f3 },
	{ 0x3157, 0xd2f4 },
	{ 0x3158, 0xd2f5 },
	{ 0x3159, 0xd2f6 },
	{ 0x315a, 0xd2f7 },
	{ 0x315b, 0xd2f8 },
	{ 0x315c, 0xd2f9 },
	{ 0x315d, 0xd2fa },
	{ 0x315e, 0xd2fb },
	{ 0x315f, 0xd2fc },
	{ 0x3160, 0xd2fd },
	{ 0x3161, 0xd2fe },
	{ 0x3162, 0xd340 },
	{ 0x3163, 0xd341 },
	{ 0x3164, 0xd342 },
	{ 0x3165, 0xd343 },
	{ 0x3166, 0xd344 },
	{ 0x3167, 0xd345 },
	{ 0x3168, 0xd346 },
	{ 0x3169, 0xd347 },
	{ 0x316a, 0xd348 },
	{ 0x316b, 0xd349 },
	{ 0x316c, 0xd34a },
	{ 0x316d, 0xd34b },
	{ 0x316e, 0xd34c },
	{ 0x316f, 0xd34d },
	{ 0x3170, 0xd34e },
	{ 0x3171, 0xd34f },
	{ 0x3172, 0xd350 },
	{ 0x3173, 0xd351 },
	{ 0x3174, 0xd352 },
	{ 0x3175, 0xd353 },
	{ 0x3176, 0xd354 },
	{ 0x3177, 0xd355 },
	{ 0x3178, 0xd356 },
	{ 0x3179, 0xd357 },
	{ 0x317a, 0xd358 },
	{ 0x317b, 0xd359 },
	{ 0x317c, 0xd35a },
	{ 0x317d, 0xd35b },
	{ 0x317e, 0xd35c },
	{ 0x3221, 0xd35d },
	{ 0x3222, 0xd35e },
	{ 0x3223, 0xd35f },
	{ 0x3224, 0xd360 },
	{ 0x3225, 0xd361 },
	{ 0x3226, 0xd362 },
	{ 0x3227, 0xd363 },
	{ 0x3228, 0xd364 },
	{ 0x3229, 0xd365 },
	{ 0x322a, 0xd366 },
	{ 0x322b, 0xd367 },
	{ 0x322c, 0xd368 },
	{ 0x322d, 0xd369 },
	{ 0x322e, 0xd36a },
	{ 0x322f, 0xd36b },
	{ 0x3230, 0xd36c },
	{ 0x3231, 0xd36d },
	{ 0x3232, 0xd36e },
	{ 0x3233, 0xd36f },
	{ 0x3234, 0xd370 },
	{ 0x3235, 0xd371 },
	{ 0x3236, 0xd372 },
	{ 0x3237, 0xd373 },
	{ 0x3238, 0xd374 },
	{ 0x3239, 0xd375 },
	{ 0x323a, 0xd376 },
	{ 0x323b, 0xd377 },
	{ 0x323c, 0xd378 },
	{ 0x323d, 0xd379 },
	{ 0x323e, 0xd37a },
	{ 0x323f, 0xd37b },
	{ 0x3240, 0xd37c },
	{ 0x3241, 0xd37d },
	{ 0x3242, 0xd37e },
	{ 0x3243, 0xd3a1 },
	{ 0x3244, 0xd3a2 },
	{ 0x3245, 0xd3a3 },
	{ 0x3246, 0xd3a4 },
	{ 0x3247, 0xd3a5 },
	{ 0x3248, 0xd3a6 },
	{ 0x3249, 0xd3a7 },
	{ 0x324a, 0xd3a8 },
	{ 0x324b, 0xd3a9 },
	{ 0x324c, 0xd3aa },
	{ 0x324d, 0xd3ab },
	{ 0x324e, 0xd3ac },
	{ 0x324f, 0xd3ad },
	{ 0x3250, 0xd3ae },
	{ 0x3251, 0xd3af },
	{ 0x3252, 0xd3b0 },
	{ 0x3253, 0xd3b1 },
	{ 0x3254, 0xd3b2 },
	{ 0x3255, 0xd3b3 },
	{ 0x3256, 0xd3b4 },
	{ 0x3257, 0xd3b5 },
	{ 0x3258, 0xd3b6 },
	{ 0x3259, 0xd3b7 },
	{ 0x325a, 0xd3b8 },
	{ 0x325b, 0xd3b9 },
	{ 0x325c, 0xd3ba },
	{ 0x325d, 0xd3bb },
	{ 0x325e, 0xd3bc },
	{ 0x325f, 0xd3bd },
	{ 0x3260, 0xd3be },
	{ 0x3261, 0xd3bf },
	{ 0x3262, 0xd3c0 },
	{ 0x3263, 0xd3c1 },
	{ 0x3264, 0xd3c2 },
	{ 0x3265, 0xd3c3 },
	{ 0x3266, 0xd3c4 },
	{ 0x3267, 0xd3c5 },
	{ 0x3268, 0xd3c6 },
	{ 0x3269, 0xd3c7 },
	{ 0x326a, 0xd3c8 },
	{ 0x326b, 0xd3c9 },
	{ 0x326c, 0xd3ca },
	{ 0x326d, 0xd3cb },
	{ 0x326e, 0xd3cc },
	{ 0x326f, 0xd3cd },
	{ 0x3270, 0xd3ce },
	{ 0x3271, 0xd3cf },
	{ 0x3272, 0xd3d0 },
	{ 0x3273, 0xd3d1 },
	{ 0x3274, 0xd3d2 },
	{ 0x3275, 0xd3d3 },
	{ 0x3276, 0xd3d4 },
	{ 0x3277, 0xd3d5 },
	{ 0x3278, 0xd3d6 },
	{ 0x3279, 0xd3d7 },
	{ 0x327a, 0xd3d8 },
	{ 0x327b, 0xd3d9 },
	{ 0x327c, 0xd3da },
	{ 0x327d, 0xd3db },
	{ 0x327e, 0xd3dc },
	{ 0x3321, 0xd3dd },
	{ 0x3322, 0xd3de },
	{ 0x3323, 0xd3df },
	{ 0x3324, 0xd3e0 },
	{ 0x3325, 0xd3e1 },
	{ 0x3326, 0xd3e2 },
	{ 0x3327, 0xd3e3 },
	{ 0x3328, 0xd3e4 },
	{ 0x3329, 0xd3e5 },
	{ 0x332a, 0xd3e6 },
	{ 0x332b, 0xd3e7 },
	{ 0x332c, 0xd3e8 },
	{ 0x332d, 0xd3e9 },
	{ 0x332e, 0xd3ea },
	{ 0x332f, 0xd3eb },
	{ 0x3330, 0xd3ec },
	{ 0x3331, 0xd3ed },
	{ 0x3332, 0xd3ee },
	{ 0x3333, 0xd3ef },
	{ 0x3334, 0xd3f0 },
	{ 0x3335, 0xd3f1 },
	{ 0x3336, 0xd3f2 },
	{ 0x3337, 0xd3f3 },
	{ 0x3338, 0xd3f4 },
	{ 0x3339, 0xd3f5 },
	{ 0x333a, 0xd3f6 },
	{ 0x333b, 0xd3f7 },
	{ 0x333c, 0xd3f8 },
	{ 0x333d, 0xd3f9 },
	{ 0x333e, 0xd3fa },
	{ 0x333f, 0xd3fb },
	{ 0x3340, 0xd3fc },
	{ 0x3341, 0xd3fd },
	{ 0x3342, 0xd3fe },
	{ 0x3343, 0xd440 },
	{ 0x3344, 0xd441 },
	{ 0x3345, 0xd442 },
	{ 0x3346, 0xd443 },
	{ 0x3347, 0xd444 },
	{ 0x3348, 0xd445 },
	{ 0x3349, 0xd446 },
	{ 0x334a, 0xd447 },
	{ 0x334b, 0xd448 },
	{ 0x334c, 0xd449 },
	{ 0x334d, 0xd44a },
	{ 0x334e, 0xd44b },
	{ 0x334f, 0xd44c },
	{ 0x3350, 0xd44d },
	{ 0x3351, 0xd44e },
	{ 0x3352, 0xd44f },
	{ 0x3353, 0xd450 },
	{ 0x3354, 0xd451 },
	{ 0x3355, 0xd452 },
	{ 0x3356, 0xd453 },
	{ 0x3357, 0xd454 },
	{ 0x3358, 0xd455 },
	{ 0x3359, 0xd456 },
	{ 0x335a, 0xd457 },
	{ 0x335b, 0xd458 },
	{ 0x335c, 0xd459 },
	{ 0x335d, 0xd45a },
	{ 0x335e, 0xd45b },
	{ 0x335f, 0xd45c },
	{ 0x3360, 0xd45d },
	{ 0x3361, 0xd45e },
	{ 0x3362, 0xd45f },
	{ 0x3363, 0xd460 },
	{ 0x3364, 0xd461 },
	{ 0x3365, 0xd462 },
	{ 0x3366, 0xd463 },
	{ 0x3367, 0xd464 },
	{ 0x3368, 0xd465 },
	{ 0x3369, 0xd466 },
	{ 0x336a, 0xd467 },
	{ 0x336b, 0xd468 },
	{ 0x336c, 0xd469 },
	{ 0x336d, 0xd46a },
	{ 0x336e, 0xd46b },
	{ 0x336f, 0xd46c },
	{ 0x3370, 0xd46d },
	{ 0x3371, 0xd46e },
	{ 0x3372, 0xd46f },
	{ 0x3373, 0xd470 },
	{ 0x3374, 0xd471 },
	{ 0x3375, 0xd472 },
	{ 0x3376, 0xd473 },
	{ 0x3377, 0xd474 },
	{ 0x3378, 0xd475 },
	{ 0x3379, 0xd476 },
	{ 0x337a, 0xd477 },
	{ 0x337b, 0xd478 },
	{ 0x337c, 0xd479 },
	{ 0x337d, 0xd47a },
	{ 0x337e, 0xd47b },
	{ 0x3421, 0xd47c },
	{ 0x3422, 0xd47d },
	{ 0x3423, 0xd47e },
	{ 0x3424, 0xd4a1 },
	{ 0x3425, 0xd4a2 },
	{ 0x3426, 0xd4a3 },
	{ 0x3427, 0xd4a4 },
	{ 0x3428, 0xd4a5 },
	{ 0x3429, 0xd4a6 },
	{ 0x342a, 0xd4a7 },
	{ 0x342b, 0xd4a8 },
	{ 0x342c, 0xd4a9 },
	{ 0x342d, 0xd4aa },
	{ 0x342e, 0xd4ab },
	{ 0x342f, 0xd4ac },
	{ 0x3430, 0xd4ad },
	{ 0x3431, 0xd4ae },
	{ 0x3432, 0xd4af },
	{ 0x3433, 0xd4b0 },
	{ 0x3434, 0xd4b1 },
	{ 0x3435, 0xd4b2 },
	{ 0x3436, 0xd4b3 },
	{ 0x3437, 0xd4b4 },
	{ 0x3438, 0xd4b5 },
	{ 0x3439, 0xd4b6 },
	{ 0x343a, 0xd4b7 },
	{ 0x343b, 0xd4b8 },
	{ 0x343c, 0xd4b9 },
	{ 0x343d, 0xd4ba },
	{ 0x343e, 0xd4bb },
	{ 0x343f, 0xd4bc },
	{ 0x3440, 0xd4bd },
	{ 0x3441, 0xd4be },
	{ 0x3442, 0xd4bf },
	{ 0x3443, 0xd4c0 },
	{ 0x3444, 0xd4c1 },
	{ 0x3445, 0xd4c2 },
	{ 0x3446, 0xd4c3 },
	{ 0x3447, 0xd4c4 },
	{ 0x3448, 0xd4c5 },
	{ 0x3449, 0xd4c6 },
	{ 0x344a, 0xd4c7 },
	{ 0x344b, 0xd4c8 },
	{ 0x344c, 0xd4c9 },
	{ 0x344d, 0xd4ca },
	{ 0x344e, 0xd4cb },
	{ 0x344f, 0xd4cc },
	{ 0x3450, 0xd4cd },
	{ 0x3451, 0xd4ce },
	{ 0x3452, 0xd4cf },
	{ 0x3453, 0xd4d0 },
	{ 0x3454, 0xd4d1 },
	{ 0x3455, 0xd4d2 },
	{ 0x3456, 0xd4d3 },
	{ 0x3457, 0xd4d4 },
	{ 0x3458, 0xd4d5 },
	{ 0x3459, 0xd4d6 },
	{ 0x345a, 0xd4d7 },
	{ 0x345b, 0xd4d8 },
	{ 0x345c, 0xd4d9 },
	{ 0x345d, 0xd4da },
	{ 0x345e, 0xd4db },
	{ 0x345f, 0xd4dc },
	{ 0x3460, 0xd4dd },
	{ 0x3461, 0xd4de },
	{ 0x3462, 0xd4df },
	{ 0x3463, 0xd4e0 },
	{ 0x3464, 0xd4e1 },
	{ 0x3465, 0xd4e2 },
	{ 0x3466, 0xd4e3 },
	{ 0x3467, 0xd4e4 },
	{ 0x3468, 0xd4e5 },
	{ 0x3469, 0xd4e6 },
	{ 0x346a, 0xd4e7 },
	{ 0x346b, 0xd4e8 },
	{ 0x346c, 0xd4e9 },
	{ 0x346d, 0xd4ea },
	{ 0x346e, 0xd4eb },
	{ 0x346f, 0xd4ec },
	{ 0x3470, 0xd4ed },
	{ 0x3471, 0xd4ee },
	{ 0x3472, 0xd4ef },
	{ 0x3473, 0xd4f0 },
	{ 0x3474, 0xd4f1 },
	{ 0x3475, 0xd4f2 },
	{ 0x3476, 0xd4f3 },
	{ 0x3477, 0xd4f4 },
	{ 0x3478, 0xd4f5 },
	{ 0x3479, 0xd4f6 },
	{ 0x347a, 0xd4f7 },
	{ 0x347b, 0xd4f8 },
	{ 0x347c, 0xd4f9 },
	{ 0x347d, 0xd4fa },
	{ 0x347e, 0xd4fb },
	{ 0x3521, 0xd4fc },
	{ 0x3522, 0xd4fd },
	{ 0x3523, 0xd4fe },
	{ 0x3524, 0xd540 },
	{ 0x3525, 0xd541 },
	{ 0x3526, 0xd542 },
	{ 0x3527, 0xd543 },
	{ 0x3528, 0xd544 },
	{ 0x3529, 0xd545 },
	{ 0x352a, 0xd546 },
	{ 0x352b, 0xd547 },
	{ 0x352c, 0xd548 },
	{ 0x352d, 0xd549 },
	{ 0x352e, 0xd54a },
	{ 0x352f, 0xd54b },
	{ 0x3530, 0xd54c },
	{ 0x3531, 0xd54d },
	{ 0x3532, 0xd54e },
	{ 0x3533, 0xd54f },
	{ 0x3534, 0xd550 },
	{ 0x3535, 0xd551 },
	{ 0x3536, 0xd552 },
	{ 0x3537, 0xd553 },
	{ 0x3538, 0xd554 },
	{ 0x3539, 0xd555 },
	{ 0x353a, 0xd556 },
	{ 0x353b, 0xd557 },
	{ 0x353c, 0xd558 },
	{ 0x353d, 0xd559 },
	{ 0x353e, 0xd55a },
	{ 0x353f, 0xd55b },
	{ 0x3540, 0xd55c },
	{ 0x3541, 0xd55d },
	{ 0x3542, 0xd55e },
	{ 0x3543, 0xd55f },
	{ 0x3544, 0xd560 },
	{ 0x3545, 0xd561 },
	{ 0x3546, 0xd562 },
	{ 0x3547, 0xd563 },
	{ 0x3548, 0xd564 },
	{ 0x3549, 0xd565 },
	{ 0x354a, 0xd566 },
	{ 0x354b, 0xd567 },
	{ 0x354c, 0xd568 },
	{ 0x354d, 0xd569 },
	{ 0x354e, 0xd56a },
	{ 0x354f, 0xd56b },
	{ 0x3550, 0xd56c },
	{ 0x3551, 0xd56d },
	{ 0x3552, 0xd56e },
	{ 0x3553, 0xd56f },
	{ 0x3554, 0xd570 },
	{ 0x3555, 0xd571 },
	{ 0x3556, 0xd572 },
	{ 0x3557, 0xd573 },
	{ 0x3558, 0xd574 },
	{ 0x3559, 0xd575 },
	{ 0x355a, 0xd576 },
	{ 0x355b, 0xd577 },
	{ 0x355c, 0xd578 },
	{ 0x355d, 0xd579 },
	{ 0x355e, 0xd57a },
	{ 0x355f, 0xd57b },
	{ 0x3560, 0xd57c },
	{ 0x3561, 0xd57d },
	{ 0x3562, 0xd57e },
	{ 0x3563, 0xd5a1 },
	{ 0x3564, 0xd5a2 },
	{ 0x3565, 0xd5a3 },
	{ 0x3566, 0xd5a4 },
	{ 0x3567, 0xd5a5 },
	{ 0x3568, 0xd5a6 },
	{ 0x3569, 0xd5a7 },
	{ 0x356a, 0xd5a8 },
	{ 0x356b, 0xd5a9 },
	{ 0x356c, 0xd5aa },
	{ 0x356d, 0xd5ab },
	{ 0x356e, 0xd5ac },
	{ 0x356f, 0xd5ad },
	{ 0x3570, 0xd5ae },
	{ 0x3571, 0xd5af },
	{ 0x3572, 0xd5b0 },
	{ 0x3573, 0xd5b1 },
	{ 0x3574, 0xd5b2 },
	{ 0x3575, 0xd5b3 },
	{ 0x3576, 0xd5b4 },
	{ 0x3577, 0xd5b5 },
	{ 0x3578, 0xd5b6 },
	{ 0x3579, 0xd5b7 },
	{ 0x357a, 0xd5b8 },
	{ 0x357b, 0xd5b9 },
	{ 0x357c, 0xd5ba },
	{ 0x357d, 0xd5bb },
	{ 0x357e, 0xd5bc },
	{ 0x3621, 0xd5bd },
	{ 0x3622, 0xd5be },
	{ 0x3623, 0xd5bf },
	{ 0x3624, 0xd5c0 },
	{ 0x3625, 0xd5c1 },
	{ 0x3626, 0xd5c2 },
	{ 0x3627, 0xd5c3 },
	{ 0x3628, 0xd5c4 },
	{ 0x3629, 0xd5c5 },
	{ 0x362a, 0xd5c6 },
	{ 0x362b, 0xd5c7 },
	{ 0x362c, 0xd5c8 },
	{ 0x362d, 0xd5c9 },
	{ 0x362e, 0xd5ca },
	{ 0x362f, 0xd5cb },
	{ 0x3630, 0xd5cc },
	{ 0x3631, 0xd5cd },
	{ 0x3632, 0xd5ce },
	{ 0x3633, 0xd5cf },
	{ 0x3634, 0xd5d0 },
	{ 0x3635, 0xd5d1 },
	{ 0x3636, 0xd5d2 },
	{ 0x3637, 0xd5d3 },
	{ 0x3638, 0xd5d4 },
	{ 0x3639, 0xd5d5 },
	{ 0x363a, 0xd5d6 },
	{ 0x363b, 0xd5d7 },
	{ 0x363c, 0xd5d8 },
	{ 0x363d, 0xd5d9 },
	{ 0x363e, 0xd5da },
	{ 0x363f, 0xd5db },
	{ 0x3640, 0xd5dc },
	{ 0x3641, 0xd5dd },
	{ 0x3642, 0xd5de },
	{ 0x3643, 0xd5df },
	{ 0x3644, 0xd5e0 },
	{ 0x3645, 0xd5e1 },
	{ 0x3646, 0xd5e2 },
	{ 0x3647, 0xd5e3 },
	{ 0x3648, 0xd5e4 },
	{ 0x3649, 0xd5e5 },
	{ 0x364a, 0xd5e6 },
	{ 0x364b, 0xd5e7 },
	{ 0x364c, 0xd5e8 },
	{ 0x364d, 0xd5e9 },
	{ 0x364e, 0xd5ea },
	{ 0x364f, 0xd5eb },
	{ 0x3650, 0xd5ec },
	{ 0x3651, 0xd5ed },
	{ 0x3652, 0xd5ee },
	{ 0x3653, 0xd5ef },
	{ 0x3654, 0xd5f0 },
	{ 0x3655, 0xd5f1 },
	{ 0x3656, 0xd5f2 },
	{ 0x3657, 0xd5f3 },
	{ 0x3658, 0xd5f4 },
	{ 0x3659, 0xd5f5 },
	{ 0x365a, 0xd5f6 },
	{ 0x365b, 0xd5f7 },
	{ 0x365c, 0xd5f8 },
	{ 0x365d, 0xd5f9 },
	{ 0x365e, 0xd5fa },
	{ 0x365f, 0xd5fb },
	{ 0x3660, 0xd5fc },
	{ 0x3661, 0xd5fd },
	{ 0x3662, 0xd5fe },
	{ 0x3663, 0xd640 },
	{ 0x3664, 0xd641 },
	{ 0x3665, 0xd642 },
	{ 0x3666, 0xd643 },
	{ 0x3667, 0xd644 },
	{ 0x3668, 0xd645 },
	{ 0x3669, 0xd646 },
	{ 0x366a, 0xd647 },
	{ 0x366b, 0xd648 },
	{ 0x366c, 0xd649 },
	{ 0x366d, 0xd64a },
	{ 0x366e, 0xd64b },
	{ 0x366f, 0xd64c },
	{ 0x3670, 0xd64d },
	{ 0x3671, 0xd64e },
	{ 0x3672, 0xd64f },
	{ 0x3673, 0xd650 },
	{ 0x3674, 0xd651 },
	{ 0x3675, 0xd652 },
	{ 0x3676, 0xd653 },
	{ 0x3677, 0xd654 },
	{ 0x3678, 0xd655 },
	{ 0x3679, 0xd656 },
	{ 0x367a, 0xd657 },
	{ 0x367b, 0xd658 },
	{ 0x367c, 0xd659 },
	{ 0x367d, 0xd65a },
	{ 0x367e, 0xd65b },
	{ 0x3721, 0xd65c },
	{ 0x3722, 0xd65d },
	{ 0x3723, 0xd65e },
	{ 0x3724, 0xd65f },
	{ 0x3725, 0xd660 },
	{ 0x3726, 0xd661 },
	{ 0x3727, 0xd662 },
	{ 0x3728, 0xd663 },
	{ 0x3729, 0xd664 },
	{ 0x372a, 0xd665 },
	{ 0x372b, 0xd666 },
	{ 0x372c, 0xd667 },
	{ 0x372d, 0xd668 },
	{ 0x372e, 0xd669 },
	{ 0x372f, 0xd66a },
	{ 0x3730, 0xd66b },
	{ 0x3731, 0xd66c },
	{ 0x3732, 0xd66d },
	{ 0x3733, 0xd66e },
	{ 0x3734, 0xd66f },
	{ 0x3735, 0xd670 },
	{ 0x3736, 0xd671 },
	{ 0x3737, 0xd672 },
	{ 0x3738, 0xd673 },
	{ 0x3739, 0xd674 },
	{ 0x373a, 0xd675 },
	{ 0x373b, 0xd676 },
	{ 0x373c, 0xd677 },
	{ 0x373d, 0xd678 },
	{ 0x373e, 0xd679 },
	{ 0x373f, 0xd67a },
	{ 0x3740, 0xd67b },
	{ 0x3741, 0xd67c },
	{ 0x3742, 0xd67d },
	{ 0x3743, 0xd67e },
	{ 0x3744, 0xd6a1 },
	{ 0x3745, 0xd6a2 },
	{ 0x3746, 0xd6a3 },
	{ 0x3747, 0xd6a4 },
	{ 0x3748, 0xd6a5 },
	{ 0x3749, 0xd6a6 },
	{ 0x374a, 0xd6a7 },
	{ 0x374b, 0xd6a8 },
	{ 0x374c, 0xd6a9 },
	{ 0x374d, 0xd6aa },
	{ 0x374e, 0xd6ab },
	{ 0x374f, 0xd6ac },
	{ 0x3750, 0xd6ad },
	{ 0x3751, 0xd6ae },
	{ 0x3752, 0xd6af },
	{ 0x3753, 0xd6b0 },
	{ 0x3754, 0xd6b1 },
	{ 0x3755, 0xd6b2 },
	{ 0x3756, 0xd6b3 },
	{ 0x3757, 0xd6b4 },
	{ 0x3758, 0xd6b5 },
	{ 0x3759, 0xd6b6 },
	{ 0x375a, 0xd6b7 },
	{ 0x375b, 0xd6b8 },
	{ 0x375c, 0xd6b9 },
	{ 0x375d, 0xd6ba },
	{ 0x375e, 0xd6bb },
	{ 0x375f, 0xd6bc },
	{ 0x3760, 0xd6bd },
	{ 0x3761, 0xd6be },
	{ 0x3762, 0xd6bf },
	{ 0x3763, 0xd6c0 },
	{ 0x3764, 0xd6c1 },
	{ 0x3765, 0xd6c2 },
	{ 0x3766, 0xd6c3 },
	{ 0x3767, 0xd6c4 },
	{ 0x3768, 0xd6c5 },
	{ 0x3769, 0xd6c6 },
	{ 0x376a, 0xd6c7 },
	{ 0x376b, 0xd6c8 },
	{ 0x376c, 0xd6c9 },
	{ 0x376d, 0xd6ca },
	{ 0x376e, 0xd6cb },
	{ 0x376f, 0xdadf },
	{ 0x3770, 0xd6cd },
	{ 0x3771, 0xd6ce },
	{ 0x3772, 0xd6cf },
	{ 0x3773, 0xd6d0 },
	{ 0x3774, 0xd6d1 },
	{ 0x3775, 0xd6d2 },
	{ 0x3776, 0xd6d3 },
	{ 0x3777, 0xd6d4 },
	{ 0x3778, 0xd6d5 },
	{ 0x3779, 0xd6d6 },
	{ 0x377a, 0xd6d7 },
	{ 0x377b, 0xd6d8 },
	{ 0x377c, 0xd6d9 },
	{ 0x377d, 0xd6da },
	{ 0x377e, 0xd6db },
	{ 0x3821, 0xd6dc },
	{ 0x3822, 0xd6dd },
	{ 0x3823, 0xd6de },
	{ 0x3824, 0xd6df },
	{ 0x3825, 0xd6e0 },
	{ 0x3826, 0xd6e1 },
	{ 0x3827, 0xd6e2 },
	{ 0x3828, 0xd6e3 },
	{ 0x3829, 0xd6e4 },
	{ 0x382a, 0xd6e5 },
	{ 0x382b, 0xd6e6 },
	{ 0x382c, 0xd6e7 },
	{ 0x382d, 0xd6e8 },
	{ 0x382e, 0xd6e9 },
	{ 0x382f, 0xd6ea },
	{ 0x3830, 0xd6eb },
	{ 0x3831, 0xd6ec },
	{ 0x3832, 0xd6ed },
	{ 0x3833, 0xd6ee },
	{ 0x3834, 0xd6ef },
	{ 0x3835, 0xd6f0 },
	{ 0x3836, 0xd6f1 },
	{ 0x3837, 0xd6f2 },
	{ 0x3838, 0xd6f3 },
	{ 0x3839, 0xd6f4 },
	{ 0x383a, 0xd6f5 },
	{ 0x383b, 0xd6f6 },
	{ 0x383c, 0xd6f7 },
	{ 0x383d, 0xd6f8 },
	{ 0x383e, 0xd6f9 },
	{ 0x383f, 0xd6fa },
	{ 0x3840, 0xd6fb },
	{ 0x3841, 0xd6fc },
	{ 0x3842, 0xd6fd },
	{ 0x3843, 0xd6fe },
	{ 0x3844, 0xd740 },
	{ 0x3845, 0xd741 },
	{ 0x3846, 0xd742 },
	{ 0x3847, 0xd743 },
	{ 0x3848, 0xd744 },
	{ 0x3849, 0xd745 },
	{ 0x384a, 0xd746 },
	{ 0x384b, 0xd747 },
	{ 0x384c, 0xd748 },
	{ 0x384d, 0xd749 },
	{ 0x384e, 0xd74a },
	{ 0x384f, 0xd74b },
	{ 0x3850, 0xd74c },
	{ 0x3851, 0xd74d },
	{ 0x3852, 0xd74e },
	{ 0x3853, 0xd74f },
	{ 0x3854, 0xd750 },
	{ 0x3855, 0xd751 },
	{ 0x3856, 0xd752 },
	{ 0x3857, 0xd753 },
	{ 0x3858, 0xd754 },
	{ 0x3859, 0xd755 },
	{ 0x385a, 0xd756 },
	{ 0x385b, 0xd757 },
	{ 0x385c, 0xd758 },
	{ 0x385d, 0xd759 },
	{ 0x385e, 0xd75a },
	{ 0x385f, 0xd75b },
	{ 0x3860, 0xd75c },
	{ 0x3861, 0xd75d },
	{ 0x3862, 0xd75e },
	{ 0x3863, 0xd75f },
	{ 0x3864, 0xd760 },
	{ 0x3865, 0xd761 },
	{ 0x3866, 0xd762 },
	{ 0x3867, 0xd763 },
	{ 0x3868, 0xd764 },
	{ 0x3869, 0xd765 },
	{ 0x386a, 0xd766 },
	{ 0x386b, 0xd767 },
	{ 0x386c, 0xd768 },
	{ 0x386d, 0xd769 },
	{ 0x386e, 0xd76a },
	{ 0x386f, 0xd76b },
	{ 0x3870, 0xd76c },
	{ 0x3871, 0xd76d },
	{ 0x3872, 0xd76e },
	{ 0x3873, 0xd76f },
	{ 0x3874, 0xd770 },
	{ 0x3875, 0xd771 },
	{ 0x3876, 0xd772 },
	{ 0x3877, 0xd773 },
	{ 0x3878, 0xd774 },
	{ 0x3879, 0xd775 },
	{ 0x387a, 0xd776 },
	{ 0x387b, 0xd777 },
	{ 0x387c, 0xd778 },
	{ 0x387d, 0xd779 },
	{ 0x387e, 0xd77b },
	{ 0x3921, 0xd77c },
	{ 0x3922, 0xd77d },
	{ 0x3923, 0xd77e },
	{ 0x3924, 0xd7a1 },
	{ 0x3925, 0xd7a2 },
	{ 0x3926, 0xd7a3 },
	{ 0x3927, 0xd7a4 },
	{ 0x3928, 0xd7a5 },
	{ 0x3929, 0xd7a6 },
	{ 0x392a, 0xd7a7 },
	{ 0x392b, 0xd7a8 },
	{ 0x392c, 0xd7a9 },
	{ 0x392d, 0xd7aa },
	{ 0x392e, 0xd7ab },
	{ 0x392f, 0xd7ac },
	{ 0x3930, 0xd7ad },
	{ 0x3931, 0xd7ae },
	{ 0x3932, 0xd7af },
	{ 0x3933, 0xd7b0 },
	{ 0x3934, 0xd7b1 },
	{ 0x3935, 0xd7b2 },
	{ 0x3936, 0xd7b3 },
	{ 0x3937, 0xd7b4 },
	{ 0x3938, 0xd7b5 },
	{ 0x3939, 0xd7b6 },
	{ 0x393a, 0xd7b7 },
	{ 0x393b, 0xd7b8 },
	{ 0x393c, 0xd7b9 },
	{ 0x393d, 0xd7ba },
	{ 0x393e, 0xd7bb },
	{ 0x393f, 0xd7bc },
	{ 0x3940, 0xd7bd },
	{ 0x3941, 0xd7be },
	{ 0x3942, 0xd7bf },
	{ 0x3943, 0xd7c0 },
	{ 0x3944, 0xd7c1 },
	{ 0x3945, 0xd7c2 },
	{ 0x3946, 0xd7c3 },
	{ 0x3947, 0xd7c4 },
	{ 0x3948, 0xd7c5 },
	{ 0x3949, 0xd7c6 },
	{ 0x394a, 0xd7c7 },
	{ 0x394b, 0xd7c8 },
	{ 0x394c, 0xd7c9 },
	{ 0x394d, 0xd7ca },
	{ 0x394e, 0xd7cb },
	{ 0x394f, 0xd7cc },
	{ 0x3950, 0xd7cd },
	{ 0x3951, 0xd7ce },
	{ 0x3952, 0xd7cf },
	{ 0x3953, 0xd7d0 },
	{ 0x3954, 0xd7d1 },
	{ 0x3955, 0xd7d2 },
	{ 0x3956, 0xd7d3 },
	{ 0x3957, 0xd7d4 },
	{ 0x3958, 0xd7d5 },
	{ 0x3959, 0xd7d6 },
	{ 0x395a, 0xd7d7 },
	{ 0x395b, 0xd7d8 },
	{ 0x395c, 0xd7d9 },
	{ 0x395d, 0xd7da },
	{ 0x395e, 0xd7db },
	{ 0x395f, 0xd7dc },
	{ 0x3960, 0xd7dd },
	{ 0x3961, 0xd7de },
	{ 0x3962, 0xd7df },
	{ 0x3963, 0xd7e0 },
	{ 0x3964, 0xd7e1 },
	{ 0x3965, 0xd7e2 },
	{ 0x3966, 0xd7e3 },
	{ 0x3967, 0xd7e4 },
	{ 0x3968, 0xd7e5 },
	{ 0x3969, 0xd7e6 },
	{ 0x396a, 0xd7e7 },
	{ 0x396b, 0xd7e8 },
	{ 0x396c, 0xd7e9 },
	{ 0x396d, 0xd7ea },
	{ 0x396e, 0xd7eb },
	{ 0x396f, 0xd7ec },
	{ 0x3970, 0xd7ed },
	{ 0x3971, 0xd7ee },
	{ 0x3972, 0xd7ef },
	{ 0x3973, 0xd7f0 },
	{ 0x3974, 0xd7f1 },
	{ 0x3975, 0xd7f2 },
	{ 0x3976, 0xd7f3 },
	{ 0x3977, 0xd7f4 },
	{ 0x3978, 0xd7f5 },
	{ 0x3979, 0xd7f6 },
	{ 0x397a, 0xd7f7 },
	{ 0x397b, 0xd7f8 },
	{ 0x397c, 0xd7f9 },
	{ 0x397d, 0xd7fa },
	{ 0x397e, 0xd7fb },
	{ 0x3a21, 0xd7fc },
	{ 0x3a22, 0xd7fd },
	{ 0x3a23, 0xd7fe },
	{ 0x3a24, 0xd840 },
	{ 0x3a25, 0xd841 },
	{ 0x3a26, 0xd842 },
	{ 0x3a27, 0xd843 },
	{ 0x3a28, 0xd844 },
	{ 0x3a29, 0xd845 },
	{ 0x3a2a, 0xd846 },
	{ 0x3a2b, 0xd847 },
	{ 0x3a2c, 0xd848 },
	{ 0x3a2d, 0xd849 },
	{ 0x3a2e, 0xd84a },
	{ 0x3a2f, 0xd84b },
	{ 0x3a30, 0xd84c },
	{ 0x3a31, 0xd84d },
	{ 0x3a32, 0xd84e },
	{ 0x3a33, 0xd84f },
	{ 0x3a34, 0xd850 },
	{ 0x3a35, 0xd851 },
	{ 0x3a36, 0xd852 },
	{ 0x3a37, 0xd853 },
	{ 0x3a38, 0xd854 },
	{ 0x3a39, 0xd855 },
	{ 0x3a3a, 0xd856 },
	{ 0x3a3b, 0xd857 },
	{ 0x3a3c, 0xd858 },
	{ 0x3a3d, 0xd859 },
	{ 0x3a3e, 0xd85a },
	{ 0x3a3f, 0xd85b },
	{ 0x3a40, 0xd85c },
	{ 0x3a41, 0xd85d },
	{ 0x3a42, 0xd85e },
	{ 0x3a43, 0xd85f },
	{ 0x3a44, 0xd860 },
	{ 0x3a45, 0xd861 },
	{ 0x3a46, 0xd862 },
	{ 0x3a47, 0xd863 },
	{ 0x3a48, 0xd864 },
	{ 0x3a49, 0xd865 },
	{ 0x3a4a, 0xd866 },
	{ 0x3a4b, 0xd867 },
	{ 0x3a4c, 0xd868 },
	{ 0x3a4d, 0xd869 },
	{ 0x3a4e, 0xd86a },
	{ 0x3a4f, 0xd86b },
	{ 0x3a50, 0xd86c },
	{ 0x3a51, 0xd86d },
	{ 0x3a52, 0xd86e },
	{ 0x3a53, 0xd86f },
	{ 0x3a54, 0xd870 },
	{ 0x3a55, 0xd871 },
	{ 0x3a56, 0xd872 },
	{ 0x3a57, 0xd873 },
	{ 0x3a58, 0xd874 },
	{ 0x3a59, 0xd875 },
	{ 0x3a5a, 0xd876 },
	{ 0x3a5b, 0xd877 },
	{ 0x3a5c, 0xd878 },
	{ 0x3a5d, 0xd879 },
	{ 0x3a5e, 0xd87a },
	{ 0x3a5f, 0xd87b },
	{ 0x3a60, 0xd87c },
	{ 0x3a61, 0xd87d },
	{ 0x3a62, 0xd87e },
	{ 0x3a63, 0xd8a1 },
	{ 0x3a64, 0xd8a2 },
	{ 0x3a65, 0xd8a3 },
	{ 0x3a66, 0xd8a4 },
	{ 0x3a67, 0xd8a5 },
	{ 0x3a68, 0xd8a6 },
	{ 0x3a69, 0xd8a7 },
	{ 0x3a6a, 0xd8a8 },
	{ 0x3a6b, 0xd8a9 },
	{ 0x3a6c, 0xd8aa },
	{ 0x3a6d, 0xd8ab },
	{ 0x3a6e, 0xd8ac },
	{ 0x3a6f, 0xd8ad },
	{ 0x3a70, 0xd8ae },
	{ 0x3a71, 0xd8af },
	{ 0x3a72, 0xd8b0 },
	{ 0x3a73, 0xd8b1 },
	{ 0x3a74, 0xd8b2 },
	{ 0x3a75, 0xd8b3 },
	{ 0x3a76, 0xd8b4 },
	{ 0x3a77, 0xd8b5 },
	{ 0x3a78, 0xd8b6 },
	{ 0x3a79, 0xd8b7 },
	{ 0x3a7a, 0xd8b8 },
	{ 0x3a7b, 0xd8b9 },
	{ 0x3a7c, 0xd8ba },
	{ 0x3a7d, 0xd8bb },
	{ 0x3a7e, 0xd8bc },
	{ 0x3b21, 0xd8bd },
	{ 0x3b22, 0xd8be },
	{ 0x3b23, 0xd8bf },
	{ 0x3b24, 0xd8c0 },
	{ 0x3b25, 0xd8c1 },
	{ 0x3b26, 0xd8c2 },
	{ 0x3b27, 0xd8c3 },
	{ 0x3b28, 0xd8c4 },
	{ 0x3b29, 0xd8c5 },
	{ 0x3b2a, 0xd8c6 },
	{ 0x3b2b, 0xd8c7 },
	{ 0x3b2c, 0xd8c8 },
	{ 0x3b2d, 0xd8c9 },
	{ 0x3b2e, 0xd8ca },
	{ 0x3b2f, 0xd8cb },
	{ 0x3b30, 0xd8cc },
	{ 0x3b31, 0xd8cd },
	{ 0x3b32, 0xd8ce },
	{ 0x3b33, 0xd8cf },
	{ 0x3b34, 0xd8d0 },
	{ 0x3b35, 0xd8d1 },
	{ 0x3b36, 0xd8d2 },
	{ 0x3b37, 0xd8d3 },
	{ 0x3b38, 0xd8d4 },
	{ 0x3b39, 0xd8d5 },
	{ 0x3b3a, 0xd8d6 },
	{ 0x3b3b, 0xd8d7 },
	{ 0x3b3c, 0xd8d8 },
	{ 0x3b3d, 0xd8d9 },
	{ 0x3b3e, 0xd8da },
	{ 0x3b3f, 0xd8db },
	{ 0x3b40, 0xd8dc },
	{ 0x3b41, 0xd8dd },
	{ 0x3b42, 0xd8de },
	{ 0x3b43, 0xd8df },
	{ 0x3b44, 0xd8e0 },
	{ 0x3b45, 0xd8e1 },
	{ 0x3b46, 0xd8e2 },
	{ 0x3b47, 0xd8e3 },
	{ 0x3b48, 0xd8e4 },
	{ 0x3b49, 0xd8e5 },
	{ 0x3b4a, 0xd8e6 },
	{ 0x3b4b, 0xd8e7 },
	{ 0x3b4c, 0xd8e8 },
	{ 0x3b4d, 0xd8e9 },
	{ 0x3b4e, 0xd8ea },
	{ 0x3b4f, 0xd8eb },
	{ 0x3b50, 0xd8ec },
	{ 0x3b51, 0xd8ed },
	{ 0x3b52, 0xd8ee },
	{ 0x3b53, 0xd8ef },
	{ 0x3b54, 0xd8f0 },
	{ 0x3b55, 0xd8f1 },
	{ 0x3b56, 0xd8f2 },
	{ 0x3b57, 0xd8f3 },
	{ 0x3b58, 0xd8f4 },
	{ 0x3b59, 0xd8f5 },
	{ 0x3b5a, 0xd8f6 },
	{ 0x3b5b, 0xd8f7 },
	{ 0x3b5c, 0xd8f8 },
	{ 0x3b5d, 0xd8f9 },
	{ 0x3b5e, 0xd8fa },
	{ 0x3b5f, 0xd8fb },
	{ 0x3b60, 0xd8fc },
	{ 0x3b61, 0xd8fd },
	{ 0x3b62, 0xd8fe },
	{ 0x3b63, 0xd940 },
	{ 0x3b64, 0xd941 },
	{ 0x3b65, 0xd942 },
	{ 0x3b66, 0xd943 },
	{ 0x3b67, 0xd944 },
	{ 0x3b68, 0xd945 },
	{ 0x3b69, 0xd946 },
	{ 0x3b6a, 0xd947 },
	{ 0x3b6b, 0xd948 },
	{ 0x3b6c, 0xd949 },
	{ 0x3b6d, 0xd94a },
	{ 0x3b6e, 0xd94b },
	{ 0x3b6f, 0xd94c },
	{ 0x3b70, 0xd94d },
	{ 0x3b71, 0xd94e },
	{ 0x3b72, 0xd94f },
	{ 0x3b73, 0xd950 },
	{ 0x3b74, 0xd951 },
	{ 0x3b75, 0xd952 },
	{ 0x3b76, 0xd953 },
	{ 0x3b77, 0xd954 },
	{ 0x3b78, 0xd955 },
	{ 0x3b79, 0xd956 },
	{ 0x3b7a, 0xd957 },
	{ 0x3b7b, 0xd958 },
	{ 0x3b7c, 0xd959 },
	{ 0x3b7d, 0xd95a },
	{ 0x3b7e, 0xd95b },
	{ 0x3c21, 0xd95c },
	{ 0x3c22, 0xd95d },
	{ 0x3c23, 0xd95e },
	{ 0x3c24, 0xd95f },
	{ 0x3c25, 0xd960 },
	{ 0x3c26, 0xd961 },
	{ 0x3c27, 0xd962 },
	{ 0x3c28, 0xd963 },
	{ 0x3c29, 0xd964 },
	{ 0x3c2a, 0xd965 },
	{ 0x3c2b, 0xd966 },
	{ 0x3c2c, 0xd967 },
	{ 0x3c2d, 0xd968 },
	{ 0x3c2e, 0xd969 },
	{ 0x3c2f, 0xd96a },
	{ 0x3c30, 0xd96b },
	{ 0x3c31, 0xd96c },
	{ 0x3c32, 0xd96d },
	{ 0x3c33, 0xd96e },
	{ 0x3c34, 0xd96f },
	{ 0x3c35, 0xd970 },
	{ 0x3c36, 0xd971 },
	{ 0x3c37, 0xd972 },
	{ 0x3c38, 0xd973 },
	{ 0x3c39, 0xd974 },
	{ 0x3c3a, 0xd975 },
	{ 0x3c3b, 0xd976 },
	{ 0x3c3c, 0xd977 },
	{ 0x3c3d, 0xd978 },
	{ 0x3c3e, 0xd979 },
	{ 0x3c3f, 0xd97a },
	{ 0x3c40, 0xd97b },
	{ 0x3c41, 0xd97c },
	{ 0x3c42, 0xd97d },
	{ 0x3c43, 0xd97e },
	{ 0x3c44, 0xd9a1 },
	{ 0x3c45, 0xd9a2 },
	{ 0x3c46, 0xd9a3 },
	{ 0x3c47, 0xd9a4 },
	{ 0x3c48, 0xd9a5 },
	{ 0x3c49, 0xd9a6 },
	{ 0x3c4a, 0xd9a7 },
	{ 0x3c4b, 0xd9a8 },
	{ 0x3c4c, 0xd9a9 },
	{ 0x3c4d, 0xd9aa },
	{ 0x3c4e, 0xd9ab },
	{ 0x3c4f, 0xd9ac },
	{ 0x3c50, 0xd9ad },
	{ 0x3c51, 0xd9ae },
	{ 0x3c52, 0xd9af },
	{ 0x3c53, 0xd9b0 },
	{ 0x3c54, 0xd9b1 },
	{ 0x3c55, 0xd9b2 },
	{ 0x3c56, 0xd9b3 },
	{ 0x3c57, 0xd9b4 },
	{ 0x3c58, 0xd9b5 },
	{ 0x3c59, 0xd9b6 },
	{ 0x3c5a, 0xd9b7 },
	{ 0x3c5b, 0xd9b8 },
	{ 0x3c5c, 0xd9b9 },
	{ 0x3c5d, 0xd9ba },
	{ 0x3c5e, 0xd9bb },
	{ 0x3c5f, 0xd9bc },
	{ 0x3c60, 0xd9bd },
	{ 0x3c61, 0xd9be },
	{ 0x3c62, 0xd9bf },
	{ 0x3c63, 0xd9c0 },
	{ 0x3c64, 0xd9c1 },
	{ 0x3c65, 0xd9c2 },
	{ 0x3c66, 0xd9c3 },
	{ 0x3c67, 0xd9c4 },
	{ 0x3c68, 0xd9c5 },
	{ 0x3c69, 0xd9c6 },
	{ 0x3c6a, 0xd9c7 },
	{ 0x3c6b, 0xd9c8 },
	{ 0x3c6c, 0xd9c9 },
	{ 0x3c6d, 0xd9ca },
	{ 0x3c6e, 0xd9cb },
	{ 0x3c6f, 0xd9cc },
	{ 0x3c70, 0xd9cd },
	{ 0x3c71, 0xd9ce },
	{ 0x3c72, 0xd9cf },
	{ 0x3c73, 0xd9d0 },
	{ 0x3c74, 0xd9d1 },
	{ 0x3c75, 0xd9d2 },
	{ 0x3c76, 0xd9d3 },
	{ 0x3c77, 0xd9d4 },
	{ 0x3c78, 0xd9d5 },
	{ 0x3c79, 0xd9d6 },
	{ 0x3c7a, 0xd9d7 },
	{ 0x3c7b, 0xd9d8 },
	{ 0x3c7c, 0xd9d9 },
	{ 0x3c7d, 0xd9da },
	{ 0x3c7e, 0xd9db },
	{ 0x3d21, 0xd9dc },
	{ 0x3d22, 0xd9dd },
	{ 0x3d23, 0xd9de },
	{ 0x3d24, 0xd9df },
	{ 0x3d25, 0xd9e0 },
	{ 0x3d26, 0xd9e1 },
	{ 0x3d27, 0xd9e2 },
	{ 0x3d28, 0xd9e3 },
	{ 0x3d29, 0xd9e4 },
	{ 0x3d2a, 0xd9e5 },
	{ 0x3d2b, 0xd9e6 },
	{ 0x3d2c, 0xd9e7 },
	{ 0x3d2d, 0xd9e8 },
	{ 0x3d2e, 0xd9e9 },
	{ 0x3d2f, 0xd9ea },
	{ 0x3d30, 0xd9eb },
	{ 0x3d31, 0xd9ec },
	{ 0x3d32, 0xd9ed },
	{ 0x3d33, 0xd9ee },
	{ 0x3d34, 0xd9ef },
	{ 0x3d35, 0xd9f0 },
	{ 0x3d36, 0xd9f1 },
	{ 0x3d37, 0xd9f2 },
	{ 0x3d38, 0xd9f3 },
	{ 0x3d39, 0xd9f4 },
	{ 0x3d3a, 0xd9f5 },
	{ 0x3d3b, 0xd9f6 },
	{ 0x3d3c, 0xd9f7 },
	{ 0x3d3d, 0xd9f8 },
	{ 0x3d3e, 0xd9f9 },
	{ 0x3d3f, 0xd9fa },
	{ 0x3d40, 0xd9fb },
	{ 0x3d41, 0xd9fc },
	{ 0x3d42, 0xd9fd },
	{ 0x3d43, 0xd9fe },
	{ 0x3d44, 0xda40 },
	{ 0x3d45, 0xda41 },
	{ 0x3d46, 0xda42 },
	{ 0x3d47, 0xda43 },
	{ 0x3d48, 0xda44 },
	{ 0x3d49, 0xda45 },
	{ 0x3d4a, 0xda46 },
	{ 0x3d4b, 0xda47 },
	{ 0x3d4c, 0xda48 },
	{ 0x3d4d, 0xda49 },
	{ 0x3d4e, 0xda4a },
	{ 0x3d4f, 0xda4b },
	{ 0x3d50, 0xda4c },
	{ 0x3d51, 0xda4d },
	{ 0x3d52, 0xda4e },
	{ 0x3d53, 0xda4f },
	{ 0x3d54, 0xda50 },
	{ 0x3d55, 0xda51 },
	{ 0x3d56, 0xda52 },
	{ 0x3d57, 0xda53 },
	{ 0x3d58, 0xda54 },
	{ 0x3d59, 0xda55 },
	{ 0x3d5a, 0xda56 },
	{ 0x3d5b, 0xda57 },
	{ 0x3d5c, 0xda58 },
	{ 0x3d5d, 0xda59 },
	{ 0x3d5e, 0xda5a },
	{ 0x3d5f, 0xda5b },
	{ 0x3d60, 0xda5c },
	{ 0x3d61, 0xda5d },
	{ 0x3d62, 0xda5e },
	{ 0x3d63, 0xda5f },
	{ 0x3d64, 0xda60 },
	{ 0x3d65, 0xda61 },
	{ 0x3d66, 0xda62 },
	{ 0x3d67, 0xda63 },
	{ 0x3d68, 0xda64 },
	{ 0x3d69, 0xda65 },
	{ 0x3d6a, 0xda66 },
	{ 0x3d6b, 0xda67 },
	{ 0x3d6c, 0xda68 },
	{ 0x3d6d, 0xda69 },
	{ 0x3d6e, 0xda6a },
	{ 0x3d6f, 0xda6b },
	{ 0x3d70, 0xda6c },
	{ 0x3d71, 0xda6d },
	{ 0x3d72, 0xda6e },
	{ 0x3d73, 0xda6f },
	{ 0x3d74, 0xda70 },
	{ 0x3d75, 0xda71 },
	{ 0x3d76, 0xda72 },
	{ 0x3d77, 0xda73 },
	{ 0x3d78, 0xda74 },
	{ 0x3d79, 0xda75 },
	{ 0x3d7a, 0xda76 },
	{ 0x3d7b, 0xda77 },
	{ 0x3d7c, 0xda78 },
	{ 0x3d7d, 0xda79 },
	{ 0x3d7e, 0xda7a },
	{ 0x3e21, 0xda7b },
	{ 0x3e22, 0xda7c },
	{ 0x3e23, 0xda7d },
	{ 0x3e24, 0xda7e },
	{ 0x3e25, 0xdaa1 },
	{ 0x3e26, 0xdaa2 },
	{ 0x3e27, 0xdaa3 },
	{ 0x3e28, 0xdaa4 },
	{ 0x3e29, 0xdaa5 },
	{ 0x3e2a, 0xdaa6 },
	{ 0x3e2b, 0xdaa7 },
	{ 0x3e2c, 0xdaa8 },
	{ 0x3e2d, 0xdaa9 },
	{ 0x3e2e, 0xdaaa },
	{ 0x3e2f, 0xdaab },
	{ 0x3e30, 0xdaac },
	{ 0x3e31, 0xdaad },
	{ 0x3e32, 0xdaae },
	{ 0x3e33, 0xdaaf },
	{ 0x3e34, 0xdab0 },
	{ 0x3e35, 0xdab1 },
	{ 0x3e36, 0xdab2 },
	{ 0x3e37, 0xdab3 },
	{ 0x3e38, 0xdab4 },
	{ 0x3e39, 0xdab5 },
	{ 0x3e3a, 0xdab6 },
	{ 0x3e3b, 0xdab7 },
	{ 0x3e3c, 0xdab8 },
	{ 0x3e3d, 0xdab9 },
	{ 0x3e3e, 0xdaba },
	{ 0x3e3f, 0xdabb },
	{ 0x3e40, 0xdabc },
	{ 0x3e41, 0xdabd },
	{ 0x3e42, 0xdabe },
	{ 0x3e43, 0xdabf },
	{ 0x3e44, 0xdac0 },
	{ 0x3e45, 0xdac1 },
	{ 0x3e46, 0xdac2 },
	{ 0x3e47, 0xdac3 },
	{ 0x3e48, 0xdac4 },
	{ 0x3e49, 0xdac5 },
	{ 0x3e4a, 0xdac6 },
	{ 0x3e4b, 0xdac7 },
	{ 0x3e4c, 0xdac8 },
	{ 0x3e4d, 0xdac9 },
	{ 0x3e4e, 0xdaca },
	{ 0x3e4f, 0xdacb },
	{ 0x3e50, 0xdacc },
	{ 0x3e51, 0xdacd },
	{ 0x3e52, 0xdace },
	{ 0x3e53, 0xdacf },
	{ 0x3e54, 0xdad0 },
	{ 0x3e55, 0xdad1 },
	{ 0x3e56, 0xdad2 },
	{ 0x3e57, 0xdad3 },
	{ 0x3e58, 0xdad4 },
	{ 0x3e59, 0xdad5 },
	{ 0x3e5a, 0xdad6 },
	{ 0x3e5b, 0xdad7 },
	{ 0x3e5c, 0xdad8 },
	{ 0x3e5d, 0xdad9 },
	{ 0x3e5e, 0xdada },
	{ 0x3e5f, 0xdadb },
	{ 0x3e60, 0xdadc },
	{ 0x3e61, 0xdadd },
	{ 0x3e62, 0xdade },
	{ 0x3e63, 0xd6cc },
	{ 0x3e64, 0xdae0 },
	{ 0x3e65, 0xdae1 },
	{ 0x3e66, 0xdae2 },
	{ 0x3e67, 0xdae3 },
	{ 0x3e68, 0xdae4 },
	{ 0x3e69, 0xdae5 },
	{ 0x3e6a, 0xdae6 },
	{ 0x3e6b, 0xdae7 },
	{ 0x3e6c, 0xdae8 },
	{ 0x3e6d, 0xdae9 },
	{ 0x3e6e, 0xdaea },
	{ 0x3e6f, 0xdaeb },
	{ 0x3e70, 0xdaec },
	{ 0x3e71, 0xdaed },
	{ 0x3e72, 0xdaee },
	{ 0x3e73, 0xdaef },
	{ 0x3e74, 0xdaf0 },
	{ 0x3e75, 0xdaf1 },
	{ 0x3e76, 0xdaf2 },
	{ 0x3e77, 0xdaf3 },
	{ 0x3e78, 0xdaf4 },
	{ 0x3e79, 0xdaf5 },
	{ 0x3e7a, 0xdaf6 },
	{ 0x3e7b, 0xdaf7 },
	{ 0x3e7c, 0xdaf8 },
	{ 0x3e7d, 0xdaf9 },
	{ 0x3e7e, 0xdafa },
	{ 0x3f21, 0xdafb },
	{ 0x3f22, 0xdafc },
	{ 0x3f23, 0xdafd },
	{ 0x3f24, 0xdafe },
	{ 0x3f25, 0xdb40 },
	{ 0x3f26, 0xdb41 },
	{ 0x3f27, 0xdb42 },
	{ 0x3f28, 0xdb43 },
	{ 0x3f29, 0xdb44 },
	{ 0x3f2a, 0xdb45 },
	{ 0x3f2b, 0xdb46 },
	{ 0x3f2c, 0xdb47 },
	{ 0x3f2d, 0xdb48 },
	{ 0x3f2e, 0xdb49 },
	{ 0x3f2f, 0xdb4a },
	{ 0x3f30, 0xdb4b },
	{ 0x3f31, 0xdb4c },
	{ 0x3f32, 0xdb4d },
	{ 0x3f33, 0xdb4e },
	{ 0x3f34, 0xdb4f },
	{ 0x3f35, 0xdb50 },
	{ 0x3f36, 0xdb51 },
	{ 0x3f37, 0xdb52 },
	{ 0x3f38, 0xdb53 },
	{ 0x3f39, 0xdb54 },
	{ 0x3f3a, 0xdb55 },
	{ 0x3f3b, 0xdb56 },
	{ 0x3f3c, 0xdb57 },
	{ 0x3f3d, 0xdb58 },
	{ 0x3f3e, 0xdb59 },
	{ 0x3f3f, 0xdb5a },
	{ 0x3f40, 0xdb5b },
	{ 0x3f41, 0xdb5c },
	{ 0x3f42, 0xdb5d },
	{ 0x3f43, 0xdb5e },
	{ 0x3f44, 0xdb5f },
	{ 0x3f45, 0xdb60 },
	{ 0x3f46, 0xdb61 },
	{ 0x3f47, 0xdb62 },
	{ 0x3f48, 0xdb63 },
	{ 0x3f49, 0xdb64 },
	{ 0x3f4a, 0xdb65 },
	{ 0x3f4b, 0xdb66 },
	{ 0x3f4c, 0xdb67 },
	{ 0x3f4d, 0xdb68 },
	{ 0x3f4e, 0xdb69 },
	{ 0x3f4f, 0xdb6a },
	{ 0x3f50, 0xdb6b },
	{ 0x3f51, 0xdb6c },
	{ 0x3f52, 0xdb6d },
	{ 0x3f53, 0xdb6e },
	{ 0x3f54, 0xdb6f },
	{ 0x3f55, 0xdb70 },
	{ 0x3f56, 0xdb71 },
	{ 0x3f57, 0xdb72 },
	{ 0x3f58, 0xdb73 },
	{ 0x3f59, 0xdb74 },
	{ 0x3f5a, 0xdb75 },
	{ 0x3f5b, 0xdb76 },
	{ 0x3f5c, 0xdb77 },
	{ 0x3f5d, 0xdb78 },
	{ 0x3f5e, 0xdb79 },
	{ 0x3f5f, 0xdb7a },
	{ 0x3f60, 0xdb7b },
	{ 0x3f61, 0xdb7c },
	{ 0x3f62, 0xdb7d },
	{ 0x3f63, 0xdb7e },
	{ 0x3f64, 0xdba1 },
	{ 0x3f65, 0xdba2 },
	{ 0x3f66, 0xdba3 },
	{ 0x3f67, 0xdba4 },
	{ 0x3f68, 0xdba5 },
	{ 0x3f69, 0xdba6 },
	{ 0x3f6a, 0xd77a },
	{ 0x3f6b, 0xdba7 },
	{ 0x3f6c, 0xdba8 },
	{ 0x3f6d, 0xdba9 },
	{ 0x3f6e, 0xdbaa },
	{ 0x3f6f, 0xdbab },
	{ 0x3f70, 0xdbac },
	{ 0x3f71, 0xdbad },
	{ 0x3f72, 0xdbae },
	{ 0x3f73, 0xdbaf },
	{ 0x3f74, 0xdbb0 },
	{ 0x3f75, 0xdbb1 },
	{ 0x3f76, 0xdbb2 },
	{ 0x3f77, 0xdbb3 },
	{ 0x3f78, 0xdbb4 },
	{ 0x3f79, 0xdbb5 },
	{ 0x3f7a, 0xdbb6 },
	{ 0x3f7b, 0xdbb7 },
	{ 0x3f7c, 0xdbb8 },
	{ 0x3f7d, 0xdbb9 },
	{ 0x3f7e, 0xdbba },
	{ 0x4021, 0xdbbb },
	{ 0x4022, 0xdbbc },
	{ 0x4023, 0xdbbd },
	{ 0x4024, 0xdbbe },
	{ 0x4025, 0xdbbf },
	{ 0x4026, 0xdbc0 },
	{ 0x4027, 0xdbc1 },
	{ 0x4028, 0xdbc2 },
	{ 0x4029, 0xdbc3 },
	{ 0x402a, 0xdbc4 },
	{ 0x402b, 0xdbc5 },
	{ 0x402c, 0xdbc6 },
	{ 0x402d, 0xdbc7 },
	{ 0x402e, 0xdbc8 },
	{ 0x402f, 0xdbc9 },
	{ 0x4030, 0xdbca },
	{ 0x4031, 0xdbcb },
	{ 0x4032, 0xdbcc },
	{ 0x4033, 0xdbcd },
	{ 0x4034, 0xdbce },
	{ 0x4035, 0xdbcf },
	{ 0x4036, 0xdbd0 },
	{ 0x4037, 0xdbd1 },
	{ 0x4038, 0xdbd2 },
	{ 0x4039, 0xdbd3 },
	{ 0x403a, 0xdbd4 },
	{ 0x403b, 0xdbd5 },
	{ 0x403c, 0xdbd6 },
	{ 0x403d, 0xdbd7 },
	{ 0x403e, 0xdbd8 },
	{ 0x403f, 0xdbd9 },
	{ 0x4040, 0xdbda },
	{ 0x4041, 0xdbdb },
	{ 0x4042, 0xdbdc },
	{ 0x4043, 0xdbdd },
	{ 0x4044, 0xdbde },
	{ 0x4045, 0xdbdf },
	{ 0x4046, 0xdbe0 },
	{ 0x4047, 0xdbe1 },
	{ 0x4048, 0xdbe2 },
	{ 0x4049, 0xdbe3 },
	{ 0x404a, 0xdbe4 },
	{ 0x404b, 0xdbe5 },
	{ 0x404c, 0xdbe6 },
	{ 0x404d, 0xdbe7 },
	{ 0x404e, 0xdbe8 },
	{ 0x404f, 0xdbe9 },
	{ 0x4050, 0xdbea },
	{ 0x4051, 0xdbeb },
	{ 0x4052, 0xdbec },
	{ 0x4053, 0xdbed },
	{ 0x4054, 0xdbee },
	{ 0x4055, 0xdbef },
	{ 0x4056, 0xdbf0 },
	{ 0x4057, 0xdbf1 },
	{ 0x4058, 0xdbf2 },
	{ 0x4059, 0xdbf3 },
	{ 0x405a, 0xdbf4 },
	{ 0x405b, 0xdbf5 },
	{ 0x405c, 0xdbf6 },
	{ 0x405d, 0xdbf7 },
	{ 0x405e, 0xdbf8 },
	{ 0x405f, 0xdbf9 },
	{ 0x4060, 0xdbfa },
	{ 0x4061, 0xdbfb },
	{ 0x4062, 0xdbfc },
	{ 0x4063, 0xdbfd },
	{ 0x4064, 0xdbfe },
	{ 0x4065, 0xdc40 },
	{ 0x4066, 0xdc41 },
	{ 0x4067, 0xdc42 },
	{ 0x4068, 0xdc43 },
	{ 0x4069, 0xdc44 },
	{ 0x406a, 0xdc45 },
	{ 0x406b, 0xdc46 },
	{ 0x406c, 0xdc47 },
	{ 0x406d, 0xdc48 },
	{ 0x406e, 0xdc49 },
	{ 0x406f, 0xdc4a },
	{ 0x4070, 0xdc4b },
	{ 0x4071, 0xdc4c },
	{ 0x4072, 0xdc4d },
	{ 0x4073, 0xdc4e },
	{ 0x4074, 0xdc4f },
	{ 0x4075, 0xdc50 },
	{ 0x4076, 0xdc51 },
	{ 0x4077, 0xdc52 },
	{ 0x4078, 0xdc53 },
	{ 0x4079, 0xdc54 },
	{ 0x407a, 0xdc55 },
	{ 0x407b, 0xdc56 },
	{ 0x407c, 0xdc57 },
	{ 0x407d, 0xdc58 },
	{ 0x407e, 0xdc59 },
	{ 0x4121, 0xdc5a },
	{ 0x4122, 0xdc5b },
	{ 0x4123, 0xdc5c },
	{ 0x4124, 0xdc5d },
	{ 0x4125, 0xdc5e },
	{ 0x4126, 0xdc5f },
	{ 0x4127, 0xdc60 },
	{ 0x4128, 0xdc61 },
	{ 0x4129, 0xdc62 },
	{ 0x412a, 0xdc63 },
	{ 0x412b, 0xdc64 },
	{ 0x412c, 0xdc65 },
	{ 0x412d, 0xdc66 },
	{ 0x412e, 0xdc67 },
	{ 0x412f, 0xdc68 },
	{ 0x4130, 0xdc69 },
	{ 0x4131, 0xdc6a },
	{ 0x4132, 0xdc6b },
	{ 0x4133, 0xdc6c },
	{ 0x4134, 0xdc6d },
	{ 0x4135, 0xdc6e },
	{ 0x4136, 0xdc6f },
	{ 0x4137, 0xdc70 },
	{ 0x4138, 0xdc71 },
	{ 0x4139, 0xdc72 },
	{ 0x413a, 0xdc73 },
	{ 0x413b, 0xdc74 },
	{ 0x413c, 0xdc75 },
	{ 0x413d, 0xdc76 },
	{ 0x413e, 0xdc77 },
	{ 0x413f, 0xdc78 },
	{ 0x4140, 0xdc79 },
	{ 0x4141, 0xdc7a },
	{ 0x4142, 0xdc7b },
	{ 0x4143, 0xdc7c },
	{ 0x4144, 0xdc7d },
	{ 0x4145, 0xdc7e },
	{ 0x4146, 0xdca1 },
	{ 0x4147, 0xdca2 },
	{ 0x4148, 0xdca3 },
	{ 0x4149, 0xdca4 },
	{ 0x414a, 0xdca5 },
	{ 0x414b, 0xdca6 },
	{ 0x414c, 0xdca7 },
	{ 0x414d, 0xdca8 },
	{ 0x414e, 0xdca9 },
	{ 0x414f, 0xdcaa },
	{ 0x4150, 0xdcab },
	{ 0x4151, 0xdcac },
	{ 0x4152, 0xdcad },
	{ 0x4153, 0xdcae },
	{ 0x4154, 0xdcaf },
	{ 0x4155, 0xdcb0 },
	{ 0x4156, 0xdcb1 },
	{ 0x4157, 0xdcb2 },
	{ 0x4158, 0xdcb3 },
	{ 0x4159, 0xdcb4 },
	{ 0x415a, 0xdcb5 },
	{ 0x415b, 0xdcb6 },
	{ 0x415c, 0xdcb7 },
	{ 0x415d, 0xdcb8 },
	{ 0x415e, 0xdcb9 },
	{ 0x415f, 0xdcba },
	{ 0x4160, 0xdcbb },
	{ 0x4161, 0xdcbc },
	{ 0x4162, 0xdcbd },
	{ 0x4163, 0xdcbe },
	{ 0x4164, 0xdcbf },
	{ 0x4165, 0xdcc0 },
	{ 0x4166, 0xdcc1 },
	{ 0x4167, 0xdcc2 },
	{ 0x4168, 0xdcc3 },
	{ 0x4169, 0xdcc4 },
	{ 0x416a, 0xdcc5 },
	{ 0x416b, 0xdcc6 },
	{ 0x416c, 0xdcc7 },
	{ 0x416d, 0xdcc8 },
	{ 0x416e, 0xdcc9 },
	{ 0x416f, 0xdcca },
	{ 0x4170, 0xdccb },
	{ 0x4171, 0xdccc },
	{ 0x4172, 0xdccd },
	{ 0x4173, 0xdcce },
	{ 0x4174, 0xdccf },
	{ 0x4175, 0xdcd0 },
	{ 0x4176, 0xdcd1 },
	{ 0x4177, 0xdcd2 },
	{ 0x4178, 0xdcd3 },
	{ 0x4179, 0xdcd4 },
	{ 0x417a, 0xdcd5 },
	{ 0x417b, 0xdcd6 },
	{ 0x417c, 0xdcd7 },
	{ 0x417d, 0xdcd8 },
	{ 0x417e, 0xdcd9 },
	{ 0x4221, 0xdcda },
	{ 0x4222, 0xdcdb },
	{ 0x4223, 0xdcdc },
	{ 0x4224, 0xdcdd },
	{ 0x4225, 0xdcde },
	{ 0x4226, 0xdcdf },
	{ 0x4227, 0xdce0 },
	{ 0x4228, 0xdce1 },
	{ 0x4229, 0xdce2 },
	{ 0x422a, 0xdce3 },
	{ 0x422b, 0xdce4 },
	{ 0x422c, 0xdce5 },
	{ 0x422d, 0xdce6 },
	{ 0x422e, 0xdce7 },
	{ 0x422f, 0xdce8 },
	{ 0x4230, 0xdce9 },
	{ 0x4231, 0xdcea },
	{ 0x4232, 0xdceb },
	{ 0x4233, 0xdcec },
	{ 0x4234, 0xdced },
	{ 0x4235, 0xdcee },
	{ 0x4236, 0xdcef },
	{ 0x4237, 0xdcf0 },
	{ 0x4238, 0xdcf1 },
	{ 0x4239, 0xdcf2 },
	{ 0x423a, 0xdcf3 },
	{ 0x423b, 0xdcf4 },
	{ 0x423c, 0xdcf5 },
	{ 0x423d, 0xdcf6 },
	{ 0x423e, 0xdcf7 },
	{ 0x423f, 0xdcf8 },
	{ 0x4240, 0xdcf9 },
	{ 0x4241, 0xdcfa },
	{ 0x4242, 0xdcfb },
	{ 0x4243, 0xdcfc },
	{ 0x4244, 0xdcfd },
	{ 0x4245, 0xdcfe },
	{ 0x4246, 0xdd40 },
	{ 0x4247, 0xdd41 },
	{ 0x4248, 0xdd42 },
	{ 0x4249, 0xdd43 },
	{ 0x424a, 0xdd44 },
	{ 0x424b, 0xdd45 },
	{ 0x424c, 0xdd46 },
	{ 0x424d, 0xdd47 },
	{ 0x424e, 0xdd48 },
	{ 0x424f, 0xdd49 },
	{ 0x4250, 0xdd4a },
	{ 0x4251, 0xdd4b },
	{ 0x4252, 0xdd4c },
	{ 0x4253, 0xdd4d },
	{ 0x4254, 0xdd4e },
	{ 0x4255, 0xdd4f },
	{ 0x4256, 0xdd50 },
	{ 0x4257, 0xdd51 },
	{ 0x4258, 0xdd52 },
	{ 0x4259, 0xdd53 },
	{ 0x425a, 0xdd54 },
	{ 0x425b, 0xdd55 },
	{ 0x425c, 0xdd56 },
	{ 0x425d, 0xdd57 },
	{ 0x425e, 0xdd58 },
	{ 0x425f, 0xdd59 },
	{ 0x4260, 0xdd5a },
	{ 0x4261, 0xdd5b },
	{ 0x4262, 0xdd5c },
	{ 0x4263, 0xdd5d },
	{ 0x4264, 0xdd5e },
	{ 0x4265, 0xdd5f },
	{ 0x4266, 0xdd60 },
	{ 0x4267, 0xdd61 },
	{ 0x4268, 0xdd62 },
	{ 0x4269, 0xdd63 },
	{ 0x426a, 0xdd64 },
	{ 0x426b, 0xdd65 },
	{ 0x426c, 0xdd66 },
	{ 0x426d, 0xdd67 },
	{ 0x426e, 0xdd68 },
	{ 0x426f, 0xdd69 },
	{ 0x4270, 0xdd6a },
	{ 0x4271, 0xdd6b },
	{ 0x4272, 0xdd6c },
	{ 0x4273, 0xdd6d },
	{ 0x4274, 0xdd6e },
	{ 0x4275, 0xdd6f },
	{ 0x4276, 0xdd70 },
	{ 0x4277, 0xdd71 },
	{ 0x4278, 0xdd72 },
	{ 0x4279, 0xdd73 },
	{ 0x427a, 0xdd74 },
	{ 0x427b, 0xdd75 },
	{ 0x427c, 0xdd76 },
	{ 0x427d, 0xdd77 },
	{ 0x427e, 0xdd78 },
	{ 0x4321, 0xdd79 },
	{ 0x4322, 0xdd7a },
	{ 0x4323, 0xdd7b },
	{ 0x4324, 0xdd7c },
	{ 0x4325, 0xdd7d },
	{ 0x4326, 0xdd7e },
	{ 0x4327, 0xdda1 },
	{ 0x4328, 0xdda2 },
	{ 0x4329, 0xdda3 },
	{ 0x432a, 0xdda4 },
	{ 0x432b, 0xdda5 },
	{ 0x432c, 0xdda6 },
	{ 0x432d, 0xdda7 },
	{ 0x432e, 0xdda8 },
	{ 0x432f, 0xdda9 },
	{ 0x4330, 0xddaa },
	{ 0x4331, 0xddab },
	{ 0x4332, 0xddac },
	{ 0x4333, 0xddad },
	{ 0x4334, 0xddae },
	{ 0x4335, 0xddaf },
	{ 0x4336, 0xddb0 },
	{ 0x4337, 0xddb1 },
	{ 0x4338, 0xddb2 },
	{ 0x4339, 0xddb3 },
	{ 0x433a, 0xddb4 },
	{ 0x433b, 0xddb5 },
	{ 0x433c, 0xddb6 },
	{ 0x433d, 0xddb7 },
	{ 0x433e, 0xddb8 },
	{ 0x433f, 0xddb9 },
	{ 0x4340, 0xddba },
	{ 0x4341, 0xddbb },
	{ 0x4342, 0xddbc },
	{ 0x4343, 0xddbd },
	{ 0x4344, 0xddbe },
	{ 0x4345, 0xddbf },
	{ 0x4346, 0xddc0 },
	{ 0x4347, 0xddc1 },
	{ 0x4348, 0xddc2 },
	{ 0x4349, 0xddc3 },
	{ 0x434a, 0xddc4 },
	{ 0x434b, 0xddc5 },
	{ 0x434c, 0xddc6 },
	{ 0x434d, 0xddc7 },
	{ 0x434e, 0xddc8 },
	{ 0x434f, 0xddc9 },
	{ 0x4350, 0xddca },
	{ 0x4351, 0xddcb },
	{ 0x4352, 0xddcc },
	{ 0x4353, 0xddcd },
	{ 0x4354, 0xddce },
	{ 0x4355, 0xddcf },
	{ 0x4356, 0xddd0 },
	{ 0x4357, 0xddd1 },
	{ 0x4358, 0xddd2 },
	{ 0x4359, 0xddd3 },
	{ 0x435a, 0xddd4 },
	{ 0x435b, 0xddd5 },
	{ 0x435c, 0xddd6 },
	{ 0x435d, 0xddd7 },
	{ 0x435e, 0xddd8 },
	{ 0x435f, 0xddd9 },
	{ 0x4360, 0xddda },
	{ 0x4361, 0xdddb },
	{ 0x4362, 0xdddc },
	{ 0x4363, 0xdddd },
	{ 0x4364, 0xddde },
	{ 0x4365, 0xdddf },
	{ 0x4366, 0xdde0 },
	{ 0x4367, 0xdde1 },
	{ 0x4368, 0xdde2 },
	{ 0x4369, 0xdde3 },
	{ 0x436a, 0xdde4 },
	{ 0x436b, 0xdde5 },
	{ 0x436c, 0xdde6 },
	{ 0x436d, 0xdde7 },
	{ 0x436e, 0xdde8 },
	{ 0x436f, 0xdde9 },
	{ 0x4370, 0xddea },
	{ 0x4371, 0xddeb },
	{ 0x4372, 0xddec },
	{ 0x4373, 0xdded },
	{ 0x4374, 0xddee },
	{ 0x4375, 0xddef },
	{ 0x4376, 0xddf0 },
	{ 0x4377, 0xddf1 },
	{ 0x4378, 0xddf2 },
	{ 0x4379, 0xddf3 },
	{ 0x437a, 0xddf4 },
	{ 0x437b, 0xddf5 },
	{ 0x437c, 0xddf6 },
	{ 0x437d, 0xddf7 },
	{ 0x437e, 0xddf8 },
	{ 0x4421, 0xddf9 },
	{ 0x4422, 0xddfa },
	{ 0x4423, 0xddfb },
	{ 0x4424, 0xddfd },
	{ 0x4425, 0xddfe },
	{ 0x4426, 0xde40 },
	{ 0x4427, 0xde41 },
	{ 0x4428, 0xde42 },
	{ 0x4429, 0xde43 },
	{ 0x442a, 0xde44 },
	{ 0x442b, 0xde45 },
	{ 0x442c, 0xde46 },
	{ 0x442d, 0xde47 },
	{ 0x442e, 0xde48 },
	{ 0x442f, 0xde49 },
	{ 0x4430, 0xde4a },
	{ 0x4431, 0xde4b },
	{ 0x4432, 0xde4c },
	{ 0x4433, 0xde4d },
	{ 0x4434, 0xde4e },
	{ 0x4435, 0xde4f },
	{ 0x4436, 0xde50 },
	{ 0x4437, 0xde51 },
	{ 0x4438, 0xde52 },
	{ 0x4439, 0xde53 },
	{ 0x443a, 0xde54 },
	{ 0x443b, 0xde55 },
	{ 0x443c, 0xde56 },
	{ 0x443d, 0xde57 },
	{ 0x443e, 0xde58 },
	{ 0x443f, 0xde59 },
	{ 0x4440, 0xde5a },
	{ 0x4441, 0xde5b },
	{ 0x4442, 0xde5c },
	{ 0x4443, 0xde5d },
	{ 0x4444, 0xde5e },
	{ 0x4445, 0xde5f },
	{ 0x4446, 0xde60 },
	{ 0x4447, 0xde61 },
	{ 0x4448, 0xde62 },
	{ 0x4449, 0xde63 },
	{ 0x444a, 0xde64 },
	{ 0x444b, 0xde65 },
	{ 0x444c, 0xde66 },
	{ 0x444d, 0xde67 },
	{ 0x444e, 0xde68 },
	{ 0x444f, 0xde69 },
	{ 0x4450, 0xde6a },
	{ 0x4451, 0xde6b },
	{ 0x4452, 0xde6c },
	{ 0x4453, 0xde6d },
	{ 0x4454, 0xde6e },
	{ 0x4455, 0xde6f },
	{ 0x4456, 0xde70 },
	{ 0x4457, 0xde71 },
	{ 0x4458, 0xde72 },
	{ 0x4459, 0xde73 },
	{ 0x445a, 0xde74 },
	{ 0x445b, 0xde75 },
	{ 0x445c, 0xde76 },
	{ 0x445d, 0xde77 },
	{ 0x445e, 0xde78 },
	{ 0x445f, 0xde79 },
	{ 0x4460, 0xde7a },
	{ 0x4461, 0xde7b },
	{ 0x4462, 0xde7c },
	{ 0x4463, 0xde7d },
	{ 0x4464, 0xde7e },
	{ 0x4465, 0xdea1 },
	{ 0x4466, 0xdea2 },
	{ 0x4467, 0xdea3 },
	{ 0x4468, 0xdea4 },
	{ 0x4469, 0xdea5 },
	{ 0x446a, 0xdea6 },
	{ 0x446b, 0xdea7 },
	{ 0x446c, 0xdea8 },
	{ 0x446d, 0xdea9 },
	{ 0x446e, 0xdeaa },
	{ 0x446f, 0xdeab },
	{ 0x4470, 0xdeac },
	{ 0x4471, 0xdead },
	{ 0x4472, 0xdeae },
	{ 0x4473, 0xdeaf },
	{ 0x4474, 0xdeb0 },
	{ 0x4475, 0xdeb1 },
	{ 0x4476, 0xdeb2 },
	{ 0x4477, 0xdeb3 },
	{ 0x4478, 0xdeb4 },
	{ 0x4479, 0xdeb5 },
	{ 0x447a, 0xdeb6 },
	{ 0x447b, 0xdeb7 },
	{ 0x447c, 0xdeb8 },
	{ 0x447d, 0xdeb9 },
	{ 0x447e, 0xdeba },
	{ 0x4521, 0xdebb },
	{ 0x4522, 0xdebc },
	{ 0x4523, 0xdebd },
	{ 0x4524, 0xdebe },
	{ 0x4525, 0xdebf },
	{ 0x4526, 0xdec0 },
	{ 0x4527, 0xdec1 },
	{ 0x4528, 0xdec2 },
	{ 0x4529, 0xdec3 },
	{ 0x452a, 0xdec4 },
	{ 0x452b, 0xdec5 },
	{ 0x452c, 0xdec6 },
	{ 0x452d, 0xdec7 },
	{ 0x452e, 0xdec8 },
	{ 0x452f, 0xdec9 },
	{ 0x4530, 0xdeca },
	{ 0x4531, 0xdecb },
	{ 0x4532, 0xdecc },
	{ 0x4533, 0xdecd },
	{ 0x4534, 0xdece },
	{ 0x4535, 0xdecf },
	{ 0x4536, 0xded0 },
	{ 0x4537, 0xded1 },
	{ 0x4538, 0xded2 },
	{ 0x4539, 0xded3 },
	{ 0x453a, 0xded4 },
	{ 0x453b, 0xded5 },
	{ 0x453c, 0xded6 },
	{ 0x453d, 0xded7 },
	{ 0x453e, 0xded8 },
	{ 0x453f, 0xded9 },
	{ 0x4540, 0xdeda },
	{ 0x4541, 0xdedb },
	{ 0x4542, 0xdedc },
	{ 0x4543, 0xdedd },
	{ 0x4544, 0xdede },
	{ 0x4545, 0xdedf },
	{ 0x4546, 0xdee0 },
	{ 0x4547, 0xdee1 },
	{ 0x4548, 0xdee2 },
	{ 0x4549, 0xdee3 },
	{ 0x454a, 0xdee4 },
	{ 0x454b, 0xdee5 },
	{ 0x454c, 0xdee6 },
	{ 0x454d, 0xdee7 },
	{ 0x454e, 0xdee8 },
	{ 0x454f, 0xdee9 },
	{ 0x4550, 0xdeea },
	{ 0x4551, 0xdeeb },
	{ 0x4552, 0xdeec },
	{ 0x4553, 0xdeed },
	{ 0x4554, 0xdeee },
	{ 0x4555, 0xdeef },
	{ 0x4556, 0xdef0 },
	{ 0x4557, 0xdef1 },
	{ 0x4558, 0xdef2 },
	{ 0x4559, 0xdef3 },
	{ 0x455a, 0xdef4 },
	{ 0x455b, 0xdef5 },
	{ 0x455c, 0xdef6 },
	{ 0x455d, 0xdef7 },
	{ 0x455e, 0xdef8 },
	{ 0x455f, 0xdef9 },
	{ 0x4560, 0xdefa },
	{ 0x4561, 0xdefb },
	{ 0x4562, 0xdefc },
	{ 0x4563, 0xdefd },
	{ 0x4564, 0xdefe },
	{ 0x4565, 0xdf40 },
	{ 0x4566, 0xdf41 },
	{ 0x4567, 0xdf42 },
	{ 0x4568, 0xdf43 },
	{ 0x4569, 0xdf44 },
	{ 0x456a, 0xdf45 },
	{ 0x456b, 0xdf46 },
	{ 0x456c, 0xdf47 },
	{ 0x456d, 0xdf48 },
	{ 0x456e, 0xdf49 },
	{ 0x456f, 0xdf4a },
	{ 0x4570, 0xdf4b },
	{ 0x4571, 0xdf4c },
	{ 0x4572, 0xdf4d },
	{ 0x4573, 0xdf4e },
	{ 0x4574, 0xdf4f },
	{ 0x4575, 0xdf50 },
	{ 0x4576, 0xdf51 },
	{ 0x4577, 0xdf52 },
	{ 0x4578, 0xdf53 },
	{ 0x4579, 0xdf54 },
	{ 0x457a, 0xdf55 },
	{ 0x457b, 0xdf56 },
	{ 0x457c, 0xdf57 },
	{ 0x457d, 0xdf58 },
	{ 0x457e, 0xdf59 },
	{ 0x4621, 0xdf5a },
	{ 0x4622, 0xdf5b },
	{ 0x4623, 0xdf5c },
	{ 0x4624, 0xdf5d },
	{ 0x4625, 0xdf5e },
	{ 0x4626, 0xdf5f },
	{ 0x4627, 0xdf60 },
	{ 0x4628, 0xdf61 },
	{ 0x4629, 0xdf62 },
	{ 0x462a, 0xdf63 },
	{ 0x462b, 0xdf64 },
	{ 0x462c, 0xdf65 },
	{ 0x462d, 0xdf66 },
	{ 0x462e, 0xdf67 },
	{ 0x462f, 0xdf68 },
	{ 0x4630, 0xdf69 },
	{ 0x4631, 0xdf6a },
	{ 0x4632, 0xdf6b },
	{ 0x4633, 0xdf6c },
	{ 0x4634, 0xdf6d },
	{ 0x4635, 0xdf6e },
	{ 0x4636, 0xdf6f },
	{ 0x4637, 0xdf70 },
	{ 0x4638, 0xdf71 },
	{ 0x4639, 0xdf72 },
	{ 0x463a, 0xdf73 },
	{ 0x463b, 0xdf74 },
	{ 0x463c, 0xdf75 },
	{ 0x463d, 0xdf76 },
	{ 0x463e, 0xdf77 },
	{ 0x463f, 0xdf78 },
	{ 0x4640, 0xdf79 },
	{ 0x4641, 0xdf7a },
	{ 0x4642, 0xdf7b },
	{ 0x4643, 0xdf7c },
	{ 0x4644, 0xdf7d },
	{ 0x4645, 0xdf7e },
	{ 0x4646, 0xdfa1 },
	{ 0x4647, 0xdfa2 },
	{ 0x4648, 0xdfa3 },
	{ 0x4649, 0xdfa4 },
	{ 0x464a, 0xdfa5 },
	{ 0x464b, 0xdfa6 },
	{ 0x464c, 0xdfa7 },
	{ 0x464d, 0xdfa8 },
	{ 0x464e, 0xdfa9 },
	{ 0x464f, 0xdfaa },
	{ 0x4650, 0xdfab },
	{ 0x4651, 0xdfac },
	{ 0x4652, 0xdfad },
	{ 0x4653, 0xdfae },
	{ 0x4654, 0xdfaf },
	{ 0x4655, 0xdfb0 },
	{ 0x4656, 0xdfb1 },
	{ 0x4657, 0xdfb2 },
	{ 0x4658, 0xdfb3 },
	{ 0x4659, 0xdfb4 },
	{ 0x465a, 0xdfb5 },
	{ 0x465b, 0xdfb6 },
	{ 0x465c, 0xdfb7 },
	{ 0x465d, 0xdfb8 },
	{ 0x465e, 0xdfb9 },
	{ 0x465f, 0xdfba },
	{ 0x4660, 0xdfbb },
	{ 0x4661, 0xdfbc },
	{ 0x4662, 0xdfbd },
	{ 0x4663, 0xdfbe },
	{ 0x4664, 0xdfbf },
	{ 0x4665, 0xdfc0 },
	{ 0x4666, 0xdfc1 },
	{ 0x4667, 0xdfc2 },
	{ 0x4668, 0xdfc3 },
	{ 0x4669, 0xdfc4 },
	{ 0x466a, 0xdfc5 },
	{ 0x466b, 0xdfc6 },
	{ 0x466c, 0xdfc7 },
	{ 0x466d, 0xdfc8 },
	{ 0x466e, 0xdfc9 },
	{ 0x466f, 0xdfca },
	{ 0x4670, 0xdfcb },
	{ 0x4671, 0xdfcc },
	{ 0x4672, 0xdfcd },
	{ 0x4673, 0xdfce },
	{ 0x4674, 0xdfcf },
	{ 0x4675, 0xdfd0 },
	{ 0x4676, 0xdfd1 },
	{ 0x4677, 0xdfd2 },
	{ 0x4678, 0xdfd3 },
	{ 0x4679, 0xdfd4 },
	{ 0x467a, 0xdfd5 },
	{ 0x467b, 0xdfd6 },
	{ 0x467c, 0xdfd7 },
	{ 0x467d, 0xdfd8 },
	{ 0x467e, 0xdfd9 },
	{ 0x4721, 0xdfda },
	{ 0x4722, 0xdfdb },
	{ 0x4723, 0xdfdc },
	{ 0x4724, 0xdfdd },
	{ 0x4725, 0xdfde },
	{ 0x4726, 0xdfdf },
	{ 0x4727, 0xdfe0 },
	{ 0x4728, 0xdfe1 },
	{ 0x4729, 0xdfe2 },
	{ 0x472a, 0xdfe3 },
	{ 0x472b, 0xdfe4 },
	{ 0x472c, 0xdfe5 },
	{ 0x472d, 0xdfe6 },
	{ 0x472e, 0xdfe7 },
	{ 0x472f, 0xdfe8 },
	{ 0x4730, 0xdfe9 },
	{ 0x4731, 0xdfea },
	{ 0x4732, 0xdfeb },
	{ 0x4733, 0xdfec },
	{ 0x4734, 0xdfed },
	{ 0x4735, 0xdfee },
	{ 0x4736, 0xdfef },
	{ 0x4737, 0xdff0 },
	{ 0x4738, 0xdff1 },
	{ 0x4739, 0xdff2 },
	{ 0x473a, 0xdff3 },
	{ 0x473b, 0xdff4 },
	{ 0x473c, 0xdff5 },
	{ 0x473d, 0xdff6 },
	{ 0x473e, 0xdff7 },
	{ 0x473f, 0xdff8 },
	{ 0x4740, 0xdff9 },
	{ 0x4741, 0xdffa },
	{ 0x4742, 0xdffb },
	{ 0x4743, 0xdffc },
	{ 0x4744, 0xdffd },
	{ 0x4745, 0xdffe },
	{ 0x4746, 0xe040 },
	{ 0x4747, 0xe041 },
	{ 0x4748, 0xe042 },
	{ 0x4749, 0xe043 },
	{ 0x474a, 0xe044 },
	{ 0x474b, 0xe045 },
	{ 0x474c, 0xe046 },
	{ 0x474d, 0xe047 },
	{ 0x474e, 0xe048 },
	{ 0x474f, 0xe049 },
	{ 0x4750, 0xe04a },
	{ 0x4751, 0xe04b },
	{ 0x4752, 0xe04c },
	{ 0x4753, 0xe04d },
	{ 0x4754, 0xe04e },
	{ 0x4755, 0xe04f },
	{ 0x4756, 0xe050 },
	{ 0x4757, 0xe051 },
	{ 0x4758, 0xe052 },
	{ 0x4759, 0xe053 },
	{ 0x475a, 0xe054 },
	{ 0x475b, 0xe055 },
	{ 0x475c, 0xe056 },
	{ 0x475d, 0xe057 },
	{ 0x475e, 0xe058 },
	{ 0x475f, 0xe059 },
	{ 0x4760, 0xe05a },
	{ 0x4761, 0xe05b },
	{ 0x4762, 0xe05c },
	{ 0x4763, 0xe05d },
	{ 0x4764, 0xe05e },
	{ 0x4765, 0xe05f },
	{ 0x4766, 0xe060 },
	{ 0x4767, 0xe061 },
	{ 0x4768, 0xe062 },
	{ 0x4769, 0xe063 },
	{ 0x476a, 0xe064 },
	{ 0x476b, 0xe065 },
	{ 0x476c, 0xe066 },
	{ 0x476d, 0xe067 },
	{ 0x476e, 0xe068 },
	{ 0x476f, 0xe069 },
	{ 0x4770, 0xe06a },
	{ 0x4771, 0xe06b },
	{ 0x4772, 0xe06c },
	{ 0x4773, 0xe06d },
	{ 0x4774, 0xe06e },
	{ 0x4775, 0xe06f },
	{ 0x4776, 0xe070 },
	{ 0x4777, 0xe071 },
	{ 0x4778, 0xe072 },
	{ 0x4779, 0xe073 },
	{ 0x477a, 0xe074 },
	{ 0x477b, 0xe075 },
	{ 0x477c, 0xe076 },
	{ 0x477d, 0xe077 },
	{ 0x477e, 0xe078 },
	{ 0x4821, 0xe079 },
	{ 0x4822, 0xe07a },
	{ 0x4823, 0xe07b },
	{ 0x4824, 0xe07c },
	{ 0x4825, 0xe07d },
	{ 0x4826, 0xe07e },
	{ 0x4827, 0xe0a1 },
	{ 0x4828, 0xe0a2 },
	{ 0x4829, 0xe0a3 },
	{ 0x482a, 0xe0a4 },
	{ 0x482b, 0xe0a5 },
	{ 0x482c, 0xe0a6 },
	{ 0x482d, 0xe0a7 },
	{ 0x482e, 0xe0a8 },
	{ 0x482f, 0xe0a9 },
	{ 0x4830, 0xe0aa },
	{ 0x4831, 0xe0ab },
	{ 0x4832, 0xe0ac },
	{ 0x4833, 0xe0ad },
	{ 0x4834, 0xe0ae },
	{ 0x4835, 0xe0af },
	{ 0x4836, 0xe0b0 },
	{ 0x4837, 0xe0b1 },
	{ 0x4838, 0xe0b2 },
	{ 0x4839, 0xe0b3 },
	{ 0x483a, 0xe0b4 },
	{ 0x483b, 0xe0b5 },
	{ 0x483c, 0xe0b6 },
	{ 0x483d, 0xe0b7 },
	{ 0x483e, 0xe0b8 },
	{ 0x483f, 0xe0b9 },
	{ 0x4840, 0xe0ba },
	{ 0x4841, 0xe0bb },
	{ 0x4842, 0xe0bc },
	{ 0x4843, 0xe0bd },
	{ 0x4844, 0xe0be },
	{ 0x4845, 0xe0bf },
	{ 0x4846, 0xe0c0 },
	{ 0x4847, 0xe0c1 },
	{ 0x4848, 0xe0c2 },
	{ 0x4849, 0xe0c3 },
	{ 0x484a, 0xe0c4 },
	{ 0x484b, 0xe0c5 },
	{ 0x484c, 0xe0c6 },
	{ 0x484d, 0xe0c7 },
	{ 0x484e, 0xe0c8 },
	{ 0x484f, 0xe0c9 },
	{ 0x4850, 0xe0ca },
	{ 0x4851, 0xe0cb },
	{ 0x4852, 0xe0cc },
	{ 0x4853, 0xe0cd },
	{ 0x4854, 0xe0ce },
	{ 0x4855, 0xe0cf },
	{ 0x4856, 0xe0d0 },
	{ 0x4857, 0xe0d1 },
	{ 0x4858, 0xe0d2 },
	{ 0x4859, 0xe0d3 },
	{ 0x485a, 0xe0d4 },
	{ 0x485b, 0xe0d5 },
	{ 0x485c, 0xe0d6 },
	{ 0x485d, 0xe0d7 },
	{ 0x485e, 0xe0d8 },
	{ 0x485f, 0xe0d9 },
	{ 0x4860, 0xe0da },
	{ 0x4861, 0xe0db },
	{ 0x4862, 0xe0dc },
	{ 0x4863, 0xe0dd },
	{ 0x4864, 0xe0de },
	{ 0x4865, 0xe0df },
	{ 0x4866, 0xe0e0 },
	{ 0x4867, 0xe0e1 },
	{ 0x4868, 0xe0e2 },
	{ 0x4869, 0xe0e3 },
	{ 0x486a, 0xe0e4 },
	{ 0x486b, 0xe0e5 },
	{ 0x486c, 0xe0e6 },
	{ 0x486d, 0xe0e7 },
	{ 0x486e, 0xe0e8 },
	{ 0x486f, 0xe0e9 },
	{ 0x4870, 0xe0ea },
	{ 0x4871, 0xe0eb },
	{ 0x4872, 0xe0ec },
	{ 0x4873, 0xe0ed },
	{ 0x4874, 0xe0ee },
	{ 0x4875, 0xe0ef },
	{ 0x4876, 0xe0f0 },
	{ 0x4877, 0xe0f1 },
	{ 0x4878, 0xe0f2 },
	{ 0x4879, 0xe0f3 },
	{ 0x487a, 0xe0f4 },
	{ 0x487b, 0xe0f5 },
	{ 0x487c, 0xe0f6 },
	{ 0x487d, 0xe0f7 },
	{ 0x487e, 0xe0f8 },
	{ 0x4921, 0xe0f9 },
	{ 0x4922, 0xe0fa },
	{ 0x4923, 0xe0fb },
	{ 0x4924, 0xe0fc },
	{ 0x4925, 0xe0fd },
	{ 0x4926, 0xe0fe },
	{ 0x4927, 0xe140 },
	{ 0x4928, 0xe141 },
	{ 0x4929, 0xe142 },
	{ 0x492a, 0xe143 },
	{ 0x492b, 0xe144 },
	{ 0x492c, 0xe145 },
	{ 0x492d, 0xe146 },
	{ 0x492e, 0xe147 },
	{ 0x492f, 0xe148 },
	{ 0x4930, 0xe149 },
	{ 0x4931, 0xe14a },
	{ 0x4932, 0xe14b },
	{ 0x4933, 0xe14c },
	{ 0x4934, 0xe14d },
	{ 0x4935, 0xe14e },
	{ 0x4936, 0xe14f },
	{ 0x4937, 0xe150 },
	{ 0x4938, 0xe151 },
	{ 0x4939, 0xe152 },
	{ 0x493a, 0xe153 },
	{ 0x493b, 0xe154 },
	{ 0x493c, 0xe155 },
	{ 0x493d, 0xe156 },
	{ 0x493e, 0xe157 },
	{ 0x493f, 0xe158 },
	{ 0x4940, 0xe159 },
	{ 0x4941, 0xe15a },
	{ 0x4942, 0xe15b },
	{ 0x4943, 0xe15c },
	{ 0x4944, 0xe15d },
	{ 0x4945, 0xe15e },
	{ 0x4946, 0xe15f },
	{ 0x4947, 0xe160 },
	{ 0x4948, 0xe161 },
	{ 0x4949, 0xe162 },
	{ 0x494a, 0xe163 },
	{ 0x494b, 0xe164 },
	{ 0x494c, 0xe165 },
	{ 0x494d, 0xe166 },
	{ 0x494e, 0xe167 },
	{ 0x494f, 0xe168 },
	{ 0x4950, 0xe169 },
	{ 0x4951, 0xe16a },
	{ 0x4952, 0xe16b },
	{ 0x4953, 0xe16c },
	{ 0x4954, 0xe16d },
	{ 0x4955, 0xe16e },
	{ 0x4956, 0xe16f },
	{ 0x4957, 0xe170 },
	{ 0x4958, 0xe171 },
	{ 0x4959, 0xe172 },
	{ 0x495a, 0xe173 },
	{ 0x495b, 0xe174 },
	{ 0x495c, 0xe175 },
	{ 0x495d, 0xe176 },
	{ 0x495e, 0xe177 },
	{ 0x495f, 0xe178 },
	{ 0x4960, 0xe179 },
	{ 0x4961, 0xe17a },
	{ 0x4962, 0xe17b },
	{ 0x4963, 0xe17c },
	{ 0x4964, 0xe17d },
	{ 0x4965, 0xe17e },
	{ 0x4966, 0xe1a1 },
	{ 0x4967, 0xe1a2 },
	{ 0x4968, 0xe1a3 },
	{ 0x4969, 0xe1a4 },
	{ 0x496a, 0xe1a5 },
	{ 0x496b, 0xe1a6 },
	{ 0x496c, 0xe1a7 },
	{ 0x496d, 0xe1a8 },
	{ 0x496e, 0xe1a9 },
	{ 0x496f, 0xe1aa },
	{ 0x4970, 0xe1ab },
	{ 0x4971, 0xe1ac },
	{ 0x4972, 0xe1ad },
	{ 0x4973, 0xe1ae },
	{ 0x4974, 0xe1af },
	{ 0x4975, 0xe1b0 },
	{ 0x4976, 0xe1b1 },
	{ 0x4977, 0xe1b2 },
	{ 0x4978, 0xe1b3 },
	{ 0x4979, 0xe1b4 },
	{ 0x497a, 0xe1b5 },
	{ 0x497b, 0xe1b6 },
	{ 0x497c, 0xe1b7 },
	{ 0x497d, 0xe1b8 },
	{ 0x497e, 0xe1b9 },
	{ 0x4a21, 0xe1ba },
	{ 0x4a22, 0xe1bb },
	{ 0x4a23, 0xe1bc },
	{ 0x4a24, 0xe1bd },
	{ 0x4a25, 0xe1be },
	{ 0x4a26, 0xe1bf },
	{ 0x4a27, 0xe1c0 },
	{ 0x4a28, 0xe1c1 },
	{ 0x4a29, 0xe1c2 },
	{ 0x4a2a, 0xe1c3 },
	{ 0x4a2b, 0xe1c4 },
	{ 0x4a2c, 0xe1c5 },
	{ 0x4a2d, 0xe1c6 },
	{ 0x4a2e, 0xe1c7 },
	{ 0x4a2f, 0xe1c8 },
	{ 0x4a30, 0xe1c9 },
	{ 0x4a31, 0xe1ca },
	{ 0x4a32, 0xe1cb },
	{ 0x4a33, 0xe1cc },
	{ 0x4a34, 0xe1cd },
	{ 0x4a35, 0xe1ce },
	{ 0x4a36, 0xe1cf },
	{ 0x4a37, 0xe1d0 },
	{ 0x4a38, 0xe1d1 },
	{ 0x4a39, 0xe1d2 },
	{ 0x4a3a, 0xe1d3 },
	{ 0x4a3b, 0xe1d4 },
	{ 0x4a3c, 0xe1d5 },
	{ 0x4a3d, 0xe1d6 },
	{ 0x4a3e, 0xe1d7 },
	{ 0x4a3f, 0xe1d8 },
	{ 0x4a40, 0xe1d9 },
	{ 0x4a41, 0xe1da },
	{ 0x4a42, 0xe1db },
	{ 0x4a43, 0xe1dc },
	{ 0x4a44, 0xe1dd },
	{ 0x4a45, 0xe1de },
	{ 0x4a46, 0xe1df },
	{ 0x4a47, 0xe1e0 },
	{ 0x4a48, 0xe1e1 },
	{ 0x4a49, 0xe1e2 },
	{ 0x4a4a, 0xe1e3 },
	{ 0x4a4b, 0xe1e4 },
	{ 0x4a4c, 0xe1e5 },
	{ 0x4a4d, 0xe1e6 },
	{ 0x4a4e, 0xe1e7 },
	{ 0x4a4f, 0xe1e8 },
	{ 0x4a50, 0xe1e9 },
	{ 0x4a51, 0xe1ea },
	{ 0x4a52, 0xe1eb },
	{ 0x4a53, 0xe1ec },
	{ 0x4a54, 0xe1ed },
	{ 0x4a55, 0xe1ee },
	{ 0x4a56, 0xe1ef },
	{ 0x4a57, 0xe1f0 },
	{ 0x4a58, 0xe1f1 },
	{ 0x4a59, 0xe1f2 },
	{ 0x4a5a, 0xe1f3 },
	{ 0x4a5b, 0xe1f4 },
	{ 0x4a5c, 0xe1f5 },
	{ 0x4a5d, 0xe1f6 },
	{ 0x4a5e, 0xe1f7 },
	{ 0x4a5f, 0xe1f8 },
	{ 0x4a60, 0xe1f9 },
	{ 0x4a61, 0xe1fa },
	{ 0x4a62, 0xe1fb },
	{ 0x4a63, 0xe1fc },
	{ 0x4a64, 0xe1fd },
	{ 0x4a65, 0xe1fe },
	{ 0x4a66, 0xe240 },
	{ 0x4a67, 0xe241 },
	{ 0x4a68, 0xe242 },
	{ 0x4a69, 0xe243 },
	{ 0x4a6a, 0xe244 },
	{ 0x4a6b, 0xe245 },
	{ 0x4a6c, 0xe246 },
	{ 0x4a6d, 0xe247 },
	{ 0x4a6e, 0xe248 },
	{ 0x4a6f, 0xe249 },
	{ 0x4a70, 0xe24a },
	{ 0x4a71, 0xe24b },
	{ 0x4a72, 0xe24c },
	{ 0x4a73, 0xe24d },
	{ 0x4a74, 0xe24e },
	{ 0x4a75, 0xe24f },
	{ 0x4a76, 0xe250 },
	{ 0x4a77, 0xe251 },
	{ 0x4a78, 0xe252 },
	{ 0x4a79, 0xe253 },
	{ 0x4a7a, 0xe254 },
	{ 0x4a7b, 0xe255 },
	{ 0x4a7c, 0xe256 },
	{ 0x4a7d, 0xe257 },
	{ 0x4a7e, 0xe258 },
	{ 0x4b21, 0xe259 },
	{ 0x4b22, 0xe25a },
	{ 0x4b23, 0xe25b },
	{ 0x4b24, 0xe25c },
	{ 0x4b25, 0xe25d },
	{ 0x4b26, 0xe25e },
	{ 0x4b27, 0xe25f },
	{ 0x4b28, 0xe260 },
	{ 0x4b29, 0xe261 },
	{ 0x4b2a, 0xe262 },
	{ 0x4b2b, 0xe263 },
	{ 0x4b2c, 0xe264 },
	{ 0x4b2d, 0xe265 },
	{ 0x4b2e, 0xe266 },
	{ 0x4b2f, 0xe267 },
	{ 0x4b30, 0xe268 },
	{ 0x4b31, 0xe269 },
	{ 0x4b32, 0xe26a },
	{ 0x4b33, 0xe26b },
	{ 0x4b34, 0xe26c },
	{ 0x4b35, 0xe26d },
	{ 0x4b36, 0xe26e },
	{ 0x4b37, 0xe26f },
	{ 0x4b38, 0xe270 },
	{ 0x4b39, 0xe271 },
	{ 0x4b3a, 0xe272 },
	{ 0x4b3b, 0xe273 },
	{ 0x4b3c, 0xe274 },
	{ 0x4b3d, 0xe275 },
	{ 0x4b3e, 0xe276 },
	{ 0x4b3f, 0xe277 },
	{ 0x4b40, 0xe278 },
	{ 0x4b41, 0xe279 },
	{ 0x4b42, 0xe27a },
	{ 0x4b43, 0xe27b },
	{ 0x4b44, 0xe27c },
	{ 0x4b45, 0xe27d },
	{ 0x4b46, 0xe27e },
	{ 0x4b47, 0xe2a1 },
	{ 0x4b48, 0xe2a2 },
	{ 0x4b49, 0xe2a3 },
	{ 0x4b4a, 0xe2a4 },
	{ 0x4b4b, 0xe2a5 },
	{ 0x4b4c, 0xe2a6 },
	{ 0x4b4d, 0xe2a7 },
	{ 0x4b4e, 0xe2a8 },
	{ 0x4b4f, 0xe2a9 },
	{ 0x4b50, 0xe2aa },
	{ 0x4b51, 0xe2ab },
	{ 0x4b52, 0xe2ac },
	{ 0x4b53, 0xe2ad },
	{ 0x4b54, 0xe2ae },
	{ 0x4b55, 0xe2af },
	{ 0x4b56, 0xe2b0 },
	{ 0x4b57, 0xe2b1 },
	{ 0x4b58, 0xe2b2 },
	{ 0x4b59, 0xe2b3 },
	{ 0x4b5a, 0xe2b4 },
	{ 0x4b5b, 0xe2b5 },
	{ 0x4b5c, 0xe2b6 },
	{ 0x4b5d, 0xe2b7 },
	{ 0x4b5e, 0xe2b8 },
	{ 0x4b5f, 0xe2b9 },
	{ 0x4b60, 0xe2ba },
	{ 0x4b61, 0xe2bb },
	{ 0x4b62, 0xe2bc },
	{ 0x4b63, 0xe2bd },
	{ 0x4b64, 0xe2be },
	{ 0x4b65, 0xe2bf },
	{ 0x4b66, 0xe2c0 },
	{ 0x4b67, 0xe2c1 },
	{ 0x4b68, 0xe2c2 },
	{ 0x4b69, 0xe2c3 },
	{ 0x4b6a, 0xe2c4 },
	{ 0x4b6b, 0xe2c5 },
	{ 0x4b6c, 0xe2c6 },
	{ 0x4b6d, 0xe2c7 },
	{ 0x4b6e, 0xe2c8 },
	{ 0x4b6f, 0xe2c9 },
	{ 0x4b70, 0xe2ca },
	{ 0x4b71, 0xe2cb },
	{ 0x4b72, 0xe2cc },
	{ 0x4b73, 0xe2cd },
	{ 0x4b74, 0xe2ce },
	{ 0x4b75, 0xe2cf },
	{ 0x4b76, 0xe2d0 },
	{ 0x4b77, 0xe2d1 },
	{ 0x4b78, 0xe2d2 },
	{ 0x4b79, 0xe2d3 },
	{ 0x4b7a, 0xe2d4 },
	{ 0x4b7b, 0xe2d5 },
	{ 0x4b7c, 0xe2d6 },
	{ 0x4b7d, 0xe2d7 },
	{ 0x4b7e, 0xe2d8 },
	{ 0x4c21, 0xe2d9 },
	{ 0x4c22, 0xe2da },
	{ 0x4c23, 0xe2db },
	{ 0x4c24, 0xe2dc },
	{ 0x4c25, 0xe2dd },
	{ 0x4c26, 0xe2de },
	{ 0x4c27, 0xe2df },
	{ 0x4c28, 0xe2e0 },
	{ 0x4c29, 0xe2e1 },
	{ 0x4c2a, 0xe2e2 },
	{ 0x4c2b, 0xe2e3 },
	{ 0x4c2c, 0xe2e4 },
	{ 0x4c2d, 0xe2e5 },
	{ 0x4c2e, 0xe2e6 },
	{ 0x4c2f, 0xe2e7 },
	{ 0x4c30, 0xe2e8 },
	{ 0x4c31, 0xe2e9 },
	{ 0x4c32, 0xe2ea },
	{ 0x4c33, 0xe2eb },
	{ 0x4c34, 0xe2ec },
	{ 0x4c35, 0xe2ed },
	{ 0x4c36, 0xe2ee },
	{ 0x4c37, 0xe2ef },
	{ 0x4c38, 0xe2f0 },
	{ 0x4c39, 0xe2f1 },
	{ 0x4c3a, 0xe2f2 },
	{ 0x4c3b, 0xe2f3 },
	{ 0x4c3c, 0xe2f4 },
	{ 0x4c3d, 0xe2f5 },
	{ 0x4c3e, 0xe2f6 },
	{ 0x4c3f, 0xe2f7 },
	{ 0x4c40, 0xe2f8 },
	{ 0x4c41, 0xe2f9 },
	{ 0x4c42, 0xe2fa },
	{ 0x4c43, 0xe2fb },
	{ 0x4c44, 0xe2fc },
	{ 0x4c45, 0xe2fd },
	{ 0x4c46, 0xe2fe },
	{ 0x4c47, 0xe340 },
	{ 0x4c48, 0xe341 },
	{ 0x4c49, 0xe342 },
	{ 0x4c4a, 0xe343 },
	{ 0x4c4b, 0xe344 },
	{ 0x4c4c, 0xe345 },
	{ 0x4c4d, 0xe346 },
	{ 0x4c4e, 0xe347 },
	{ 0x4c4f, 0xe348 },
	{ 0x4c50, 0xe349 },
	{ 0x4c51, 0xe34a },
	{ 0x4c52, 0xe34b },
	{ 0x4c53, 0xe34c },
	{ 0x4c54, 0xe34d },
	{ 0x4c55, 0xe34e },
	{ 0x4c56, 0xe34f },
	{ 0x4c57, 0xe350 },
	{ 0x4c58, 0xe351 },
	{ 0x4c59, 0xe352 },
	{ 0x4c5a, 0xe353 },
	{ 0x4c5b, 0xe354 },
	{ 0x4c5c, 0xe355 },
	{ 0x4c5d, 0xe356 },
	{ 0x4c5e, 0xe357 },
	{ 0x4c5f, 0xe358 },
	{ 0x4c60, 0xe359 },
	{ 0x4c61, 0xe35a },
	{ 0x4c62, 0xe35b },
	{ 0x4c63, 0xe35c },
	{ 0x4c64, 0xe35d },
	{ 0x4c65, 0xe35e },
	{ 0x4c66, 0xe35f },
	{ 0x4c67, 0xe360 },
	{ 0x4c68, 0xe361 },
	{ 0x4c69, 0xe362 },
	{ 0x4c6a, 0xe363 },
	{ 0x4c6b, 0xe364 },
	{ 0x4c6c, 0xe365 },
	{ 0x4c6d, 0xe366 },
	{ 0x4c6e, 0xe367 },
	{ 0x4c6f, 0xe368 },
	{ 0x4c70, 0xe369 },
	{ 0x4c71, 0xe36a },
	{ 0x4c72, 0xe36b },
	{ 0x4c73, 0xe36c },
	{ 0x4c74, 0xe36d },
	{ 0x4c75, 0xe36e },
	{ 0x4c76, 0xe36f },
	{ 0x4c77, 0xe370 },
	{ 0x4c78, 0xe371 },
	{ 0x4c79, 0xe372 },
	{ 0x4c7a, 0xe373 },
	{ 0x4c7b, 0xe374 },
	{ 0x4c7c, 0xe375 },
	{ 0x4c7d, 0xe376 },
	{ 0x4c7e, 0xe377 },
	{ 0x4d21, 0xe378 },
	{ 0x4d22, 0xe379 },
	{ 0x4d23, 0xe37a },
	{ 0x4d24, 0xe37b },
	{ 0x4d25, 0xe37c },
	{ 0x4d26, 0xe37d },
	{ 0x4d27, 0xe37e },
	{ 0x4d28, 0xe3a1 },
	{ 0x4d29, 0xe3a2 },
	{ 0x4d2a, 0xe3a3 },
	{ 0x4d2b, 0xe3a4 },
	{ 0x4d2c, 0xe3a5 },
	{ 0x4d2d, 0xe3a6 },
	{ 0x4d2e, 0xe3a7 },
	{ 0x4d2f, 0xe3a8 },
	{ 0x4d30, 0xe3a9 },
	{ 0x4d31, 0xe3aa },
	{ 0x4d32, 0xe3ab },
	{ 0x4d33, 0xe3ac },
	{ 0x4d34, 0xe3ad },
	{ 0x4d35, 0xe3ae },
	{ 0x4d36, 0xe3af },
	{ 0x4d37, 0xe3b0 },
	{ 0x4d38, 0xe3b1 },
	{ 0x4d39, 0xe3b2 },
	{ 0x4d3a, 0xe3b3 },
	{ 0x4d3b, 0xe3b4 },
	{ 0x4d3c, 0xe3b5 },
	{ 0x4d3d, 0xe3b6 },
	{ 0x4d3e, 0xe3b7 },
	{ 0x4d3f, 0xe3b8 },
	{ 0x4d40, 0xe3b9 },
	{ 0x4d41, 0xe3ba },
	{ 0x4d42, 0xe3bb },
	{ 0x4d43, 0xe3bc },
	{ 0x4d44, 0xe3bd },
	{ 0x4d45, 0xe3be },
	{ 0x4d46, 0xe3bf },
	{ 0x4d47, 0xe3c0 },
	{ 0x4d48, 0xe3c1 },
	{ 0x4d49, 0xe3c2 },
	{ 0x4d4a, 0xe3c3 },
	{ 0x4d4b, 0xe3c4 },
	{ 0x4d4c, 0xe3c5 },
	{ 0x4d4d, 0xe3c6 },
	{ 0x4d4e, 0xe3c7 },
	{ 0x4d4f, 0xe3c8 },
	{ 0x4d50, 0xe3c9 },
	{ 0x4d51, 0xe3ca },
	{ 0x4d52, 0xe3cb },
	{ 0x4d53, 0xe3cc },
	{ 0x4d54, 0xe3cd },
	{ 0x4d55, 0xe3ce },
	{ 0x4d56, 0xe3cf },
	{ 0x4d57, 0xe3d0 },
	{ 0x4d58, 0xe3d1 },
	{ 0x4d59, 0xe3d2 },
	{ 0x4d5a, 0xe3d3 },
	{ 0x4d5b, 0xe3d4 },
	{ 0x4d5c, 0xe3d5 },
	{ 0x4d5d, 0xe3d6 },
	{ 0x4d5e, 0xe3d7 },
	{ 0x4d5f, 0xe3d8 },
	{ 0x4d60, 0xe3d9 },
	{ 0x4d61, 0xe3da },
	{ 0x4d62, 0xe3db },
	{ 0x4d63, 0xe3dc },
	{ 0x4d64, 0xe3dd },
	{ 0x4d65, 0xe3de },
	{ 0x4d66, 0xe3df },
	{ 0x4d67, 0xe3e0 },
	{ 0x4d68, 0xe3e1 },
	{ 0x4d69, 0xe3e2 },
	{ 0x4d6a, 0xe3e3 },
	{ 0x4d6b, 0xe3e4 },
	{ 0x4d6c, 0xe3e5 },
	{ 0x4d6d, 0xe3e6 },
	{ 0x4d6e, 0xe3e7 },
	{ 0x4d6f, 0xe3e8 },
	{ 0x4d70, 0xe3e9 },
	{ 0x4d71, 0xe3ea },
	{ 0x4d72, 0xe3eb },
	{ 0x4d73, 0xe3ec },
	{ 0x4d74, 0xe3ed },
	{ 0x4d75, 0xe3ee },
	{ 0x4d76, 0xe3ef },
	{ 0x4d77, 0xe3f0 },
	{ 0x4d78, 0xe3f1 },
	{ 0x4d79, 0xe3f2 },
	{ 0x4d7a, 0xe3f3 },
	{ 0x4d7b, 0xe3f4 },
	{ 0x4d7c, 0xe3f5 },
	{ 0x4d7d, 0xe3f6 },
	{ 0x4d7e, 0xe3f7 },
	{ 0x4e21, 0xe3f8 },
	{ 0x4e22, 0xe3f9 },
	{ 0x4e23, 0xe3fa },
	{ 0x4e24, 0xe3fb },
	{ 0x4e25, 0xe3fc },
	{ 0x4e26, 0xe3fd },
	{ 0x4e27, 0xe3fe },
	{ 0x4e28, 0xe440 },
	{ 0x4e29, 0xe441 },
	{ 0x4e2a, 0xe442 },
	{ 0x4e2b, 0xe443 },
	{ 0x4e2c, 0xe444 },
	{ 0x4e2d, 0xe445 },
	{ 0x4e2e, 0xe446 },
	{ 0x4e2f, 0xe447 },
	{ 0x4e30, 0xe448 },
	{ 0x4e31, 0xe449 },
	{ 0x4e32, 0xe44a },
	{ 0x4e33, 0xe44b },
	{ 0x4e34, 0xe44c },
	{ 0x4e35, 0xe44d },
	{ 0x4e36, 0xe44e },
	{ 0x4e37, 0xe44f },
	{ 0x4e38, 0xe450 },
	{ 0x4e39, 0xe451 },
	{ 0x4e3a, 0xe452 },
	{ 0x4e3b, 0xe453 },
	{ 0x4e3c, 0xe454 },
	{ 0x4e3d, 0xe455 },
	{ 0x4e3e, 0xe456 },
	{ 0x4e3f, 0xe457 },
	{ 0x4e40, 0xe458 },
	{ 0x4e41, 0xe459 },
	{ 0x4e42, 0xe45a },
	{ 0x4e43, 0xe45b },
	{ 0x4e44, 0xe45c },
	{ 0x4e45, 0xe45d },
	{ 0x4e46, 0xe45e },
	{ 0x4e47, 0xe45f },
	{ 0x4e48, 0xe460 },
	{ 0x4e49, 0xe461 },
	{ 0x4e4a, 0xe462 },
	{ 0x4e4b, 0xe463 },
	{ 0x4e4c, 0xe464 },
	{ 0x4e4d, 0xe465 },
	{ 0x4e4e, 0xe466 },
	{ 0x4e4f, 0xe467 },
	{ 0x4e50, 0xe468 },
	{ 0x4e51, 0xe469 },
	{ 0x4e52, 0xe46a },
	{ 0x4e53, 0xe46b },
	{ 0x4e54, 0xe46c },
	{ 0x4e55, 0xe46d },
	{ 0x4e56, 0xe46e },
	{ 0x4e57, 0xe46f },
	{ 0x4e58, 0xe470 },
	{ 0x4e59, 0xe471 },
	{ 0x4e5a, 0xe472 },
	{ 0x4e5b, 0xe473 },
	{ 0x4e5c, 0xe474 },
	{ 0x4e5d, 0xe475 },
	{ 0x4e5e, 0xe476 },
	{ 0x4e5f, 0xe477 },
	{ 0x4e60, 0xe478 },
	{ 0x4e61, 0xe479 },
	{ 0x4e62, 0xe47a },
	{ 0x4e63, 0xe47b },
	{ 0x4e64, 0xe47c },
	{ 0x4e65, 0xe47d },
	{ 0x4e66, 0xe47e },
	{ 0x4e67, 0xe4a1 },
	{ 0x4e68, 0xe4a2 },
	{ 0x4e69, 0xe4a3 },
	{ 0x4e6a, 0xe4a4 },
	{ 0x4e6b, 0xe4a5 },
	{ 0x4e6c, 0xe4a6 },
	{ 0x4e6d, 0xe4a7 },
	{ 0x4e6e, 0xe4a8 },
	{ 0x4e6f, 0xe4a9 },
	{ 0x4e70, 0xe4aa },
	{ 0x4e71, 0xe4ab },
	{ 0x4e72, 0xe4ac },
	{ 0x4e73, 0xe4ad },
	{ 0x4e74, 0xe4ae },
	{ 0x4e75, 0xe4af },
	{ 0x4e76, 0xe4b0 },
	{ 0x4e77, 0xe4b1 },
	{ 0x4e78, 0xe4b2 },
	{ 0x4e79, 0xe4b3 },
	{ 0x4e7a, 0xe4b4 },
	{ 0x4e7b, 0xe4b5 },
	{ 0x4e7c, 0xe4b6 },
	{ 0x4e7d, 0xe4b7 },
	{ 0x4e7e, 0xe4b8 },
	{ 0x4f21, 0xe4b9 },
	{ 0x4f22, 0xe4ba },
	{ 0x4f23, 0xe4bb },
	{ 0x4f24, 0xe4bc },
	{ 0x4f25, 0xe4bd },
	{ 0x4f26, 0xe4be },
	{ 0x4f27, 0xe4bf },
	{ 0x4f28, 0xe4c0 },
	{ 0x4f29, 0xe4c1 },
	{ 0x4f2a, 0xe4c2 },
	{ 0x4f2b, 0xe4c3 },
	{ 0x4f2c, 0xe4c4 },
	{ 0x4f2d, 0xe4c5 },
	{ 0x4f2e, 0xe4c6 },
	{ 0x4f2f, 0xe4c7 },
	{ 0x4f30, 0xe4c8 },
	{ 0x4f31, 0xe4c9 },
	{ 0x4f32, 0xe4ca },
	{ 0x4f33, 0xe4cb },
	{ 0x4f34, 0xe4cc },
	{ 0x4f35, 0xe4cd },
	{ 0x4f36, 0xe4ce },
	{ 0x4f37, 0xe4cf },
	{ 0x4f38, 0xe4d0 },
	{ 0x4f39, 0xe4d1 },
	{ 0x4f3a, 0xe4d2 },
	{ 0x4f3b, 0xe4d3 },
	{ 0x4f3c, 0xe4d4 },
	{ 0x4f3d, 0xe4d5 },
	{ 0x4f3e, 0xe4d6 },
	{ 0x4f3f, 0xe4d7 },
	{ 0x4f40, 0xe4d8 },
	{ 0x4f41, 0xe4d9 },
	{ 0x4f42, 0xe4da },
	{ 0x4f43, 0xe4db },
	{ 0x4f44, 0xe4dc },
	{ 0x4f45, 0xe4dd },
	{ 0x4f46, 0xe4de },
	{ 0x4f47, 0xe4df },
	{ 0x4f48, 0xe4e0 },
	{ 0x4f49, 0xe4e1 },
	{ 0x4f4a, 0xe4e2 },
	{ 0x4f4b, 0xe4e3 },
	{ 0x4f4c, 0xe4e4 },
	{ 0x4f4d, 0xe4e5 },
	{ 0x4f4e, 0xe4e6 },
	{ 0x4f4f, 0xe4e7 },
	{ 0x4f50, 0xe4e8 },
	{ 0x4f51, 0xe4e9 },
	{ 0x4f52, 0xe4ea },
	{ 0x4f53, 0xe4eb },
	{ 0x4f54, 0xe4ec },
	{ 0x4f55, 0xe4ed },
	{ 0x4f56, 0xe4ee },
	{ 0x4f57, 0xe4ef },
	{ 0x4f58, 0xe4f0 },
	{ 0x4f59, 0xe4f1 },
	{ 0x4f5a, 0xe4f2 },
	{ 0x4f5b, 0xe4f3 },
	{ 0x4f5c, 0xe4f4 },
	{ 0x4f5d, 0xe4f5 },
	{ 0x4f5e, 0xe4f6 },
	{ 0x4f5f, 0xe4f7 },
	{ 0x4f60, 0xe4f8 },
	{ 0x4f61, 0xe4f9 },
	{ 0x4f62, 0xe4fa },
	{ 0x4f63, 0xe4fb },
	{ 0x4f64, 0xe4fc },
	{ 0x4f65, 0xe4fd },
	{ 0x4f66, 0xe4fe },
	{ 0x4f67, 0xe540 },
	{ 0x4f68, 0xe541 },
	{ 0x4f69, 0xe542 },
	{ 0x4f6a, 0xe543 },
	{ 0x4f6b, 0xe544 },
	{ 0x4f6c, 0xe545 },
	{ 0x4f6d, 0xe546 },
	{ 0x4f6e, 0xe547 },
	{ 0x4f6f, 0xe548 },
	{ 0x4f70, 0xe549 },
	{ 0x4f71, 0xe54a },
	{ 0x4f72, 0xe54b },
	{ 0x4f73, 0xe54c },
	{ 0x4f74, 0xe54d },
	{ 0x4f75, 0xe54e },
	{ 0x4f76, 0xe54f },
	{ 0x4f77, 0xe550 },
	{ 0x4f78, 0xe551 },
	{ 0x4f79, 0xe552 },
	{ 0x4f7a, 0xe553 },
	{ 0x4f7b, 0xe554 },
	{ 0x4f7c, 0xe555 },
	{ 0x4f7d, 0xe556 },
	{ 0x4f7e, 0xe557 },
	{ 0x5021, 0xe558 },
	{ 0x5022, 0xe559 },
	{ 0x5023, 0xe55a },
	{ 0x5024, 0xe55b },
	{ 0x5025, 0xe55c },
	{ 0x5026, 0xe55d },
	{ 0x5027, 0xe55e },
	{ 0x5028, 0xe55f },
	{ 0x5029, 0xe560 },
	{ 0x502a, 0xe561 },
	{ 0x502b, 0xe562 },
	{ 0x502c, 0xe563 },
	{ 0x502d, 0xe564 },
	{ 0x502e, 0xe565 },
	{ 0x502f, 0xe566 },
	{ 0x5030, 0xe567 },
	{ 0x5031, 0xe568 },
	{ 0x5032, 0xe569 },
	{ 0x5033, 0xe56a },
	{ 0x5034, 0xe56b },
	{ 0x5035, 0xe56c },
	{ 0x5036, 0xe56d },
	{ 0x5037, 0xe56e },
	{ 0x5038, 0xe56f },
	{ 0x5039, 0xe570 },
	{ 0x503a, 0xe571 },
	{ 0x503b, 0xe572 },
	{ 0x503c, 0xe573 },
	{ 0x503d, 0xe574 },
	{ 0x503e, 0xe575 },
	{ 0x503f, 0xe576 },
	{ 0x5040, 0xe577 },
	{ 0x5041, 0xe578 },
	{ 0x5042, 0xe579 },
	{ 0x5043, 0xe57a },
	{ 0x5044, 0xe57b },
	{ 0x5045, 0xe57c },
	{ 0x5046, 0xe57d },
	{ 0x5047, 0xe57e },
	{ 0x5048, 0xe5a1 },
	{ 0x5049, 0xe5a2 },
	{ 0x504a, 0xe5a3 },
	{ 0x504b, 0xe5a4 },
	{ 0x504c, 0xe5a5 },
	{ 0x504d, 0xe5a6 },
	{ 0x504e, 0xe5a7 },
	{ 0x504f, 0xe5a8 },
	{ 0x5050, 0xe5a9 },
	{ 0x5051, 0xe5aa },
	{ 0x5052, 0xe5ab },
	{ 0x5053, 0xe5ac },
	{ 0x5054, 0xe5ad },
	{ 0x5055, 0xe5ae },
	{ 0x5056, 0xe5af },
	{ 0x5057, 0xe5b0 },
	{ 0x5058, 0xe5b1 },
	{ 0x5059, 0xe5b2 },
	{ 0x505a, 0xe5b3 },
	{ 0x505b, 0xe5b4 },
	{ 0x505c, 0xe5b5 },
	{ 0x505d, 0xe5b6 },
	{ 0x505e, 0xe5b7 },
	{ 0x505f, 0xe5b8 },
	{ 0x5060, 0xe5b9 },
	{ 0x5061, 0xe5ba },
	{ 0x5062, 0xe5bb },
	{ 0x5063, 0xe5bc },
	{ 0x5064, 0xe5bd },
	{ 0x5065, 0xe5be },
	{ 0x5066, 0xe5bf },
	{ 0x5067, 0xe5c0 },
	{ 0x5068, 0xe5c1 },
	{ 0x5069, 0xe5c2 },
	{ 0x506a, 0xe5c3 },
	{ 0x506b, 0xe5c4 },
	{ 0x506c, 0xe5c5 },
	{ 0x506d, 0xe5c6 },
	{ 0x506e, 0xe5c7 },
	{ 0x506f, 0xe5c8 },
	{ 0x5070, 0xe5c9 },
	{ 0x5071, 0xe5ca },
	{ 0x5072, 0xe5cb },
	{ 0x5073, 0xe5cc },
	{ 0x5074, 0xe5cd },
	{ 0x5075, 0xe5ce },
	{ 0x5076, 0xe5cf },
	{ 0x5077, 0xe5d0 },
	{ 0x5078, 0xe5d1 },
	{ 0x5079, 0xe5d2 },
	{ 0x507a, 0xe5d3 },
	{ 0x507b, 0xe5d4 },
	{ 0x507c, 0xe5d5 },
	{ 0x507d, 0xe5d6 },
	{ 0x507e, 0xe5d7 },
	{ 0x5121, 0xe5d8 },
	{ 0x5122, 0xe5d9 },
	{ 0x5123, 0xe5da },
	{ 0x5124, 0xe5db },
	{ 0x5125, 0xe5dc },
	{ 0x5126, 0xe5dd },
	{ 0x5127, 0xe5de },
	{ 0x5128, 0xe5df },
	{ 0x5129, 0xe5e0 },
	{ 0x512a, 0xe5e1 },
	{ 0x512b, 0xe5e2 },
	{ 0x512c, 0xe5e3 },
	{ 0x512d, 0xe5e4 },
	{ 0x512e, 0xe5e5 },
	{ 0x512f, 0xe5e6 },
	{ 0x5130, 0xe5e7 },
	{ 0x5131, 0xe5e8 },
	{ 0x5132, 0xe5e9 },
	{ 0x5133, 0xe5ea },
	{ 0x5134, 0xe5eb },
	{ 0x5135, 0xe5ec },
	{ 0x5136, 0xe5ed },
	{ 0x5137, 0xe5ee },
	{ 0x5138, 0xe5ef },
	{ 0x5139, 0xe5f0 },
	{ 0x513a, 0xe5f1 },
	{ 0x513b, 0xe5f2 },
	{ 0x513c, 0xe5f3 },
	{ 0x513d, 0xe5f4 },
	{ 0x513e, 0xe5f5 },
	{ 0x513f, 0xe5f6 },
	{ 0x5140, 0xe5f7 },
	{ 0x5141, 0xe5f8 },
	{ 0x5142, 0xe5f9 },
	{ 0x5143, 0xe5fa },
	{ 0x5144, 0xe5fb },
	{ 0x5145, 0xe5fc },
	{ 0x5146, 0xe5fd },
	{ 0x5147, 0xe5fe },
	{ 0x5148, 0xe640 },
	{ 0x5149, 0xe641 },
	{ 0x514a, 0xe642 },
	{ 0x514b, 0xe643 },
	{ 0x514c, 0xe644 },
	{ 0x514d, 0xe645 },
	{ 0x514e, 0xe646 },
	{ 0x514f, 0xe647 },
	{ 0x5150, 0xe648 },
	{ 0x5151, 0xe649 },
	{ 0x5152, 0xe64a },
	{ 0x5153, 0xe64b },
	{ 0x5154, 0xe64c },
	{ 0x5155, 0xe64d },
	{ 0x5156, 0xe64e },
	{ 0x5157, 0xe64f },
	{ 0x5158, 0xe650 },
	{ 0x5159, 0xe651 },
	{ 0x515a, 0xe652 },
	{ 0x515b, 0xe653 },
	{ 0x515c, 0xe654 },
	{ 0x515d, 0xe655 },
	{ 0x515e, 0xe656 },
	{ 0x515f, 0xe657 },
	{ 0x5160, 0xe658 },
	{ 0x5161, 0xe659 },
	{ 0x5162, 0xe65a },
	{ 0x5163, 0xe65b },
	{ 0x5164, 0xe65c },
	{ 0x5165, 0xe65d },
	{ 0x5166, 0xe65e },
	{ 0x5167, 0xe65f },
	{ 0x5168, 0xe660 },
	{ 0x5169, 0xe661 },
	{ 0x516a, 0xe662 },
	{ 0x516b, 0xe663 },
	{ 0x516c, 0xe664 },
	{ 0x516d, 0xe665 },
	{ 0x516e, 0xe666 },
	{ 0x516f, 0xe667 },
	{ 0x5170, 0xe668 },
	{ 0x5171, 0xe669 },
	{ 0x5172, 0xe66a },
	{ 0x5173, 0xe66b },
	{ 0x5174, 0xe66c },
	{ 0x5175, 0xe66d },
	{ 0x5176, 0xe66e },
	{ 0x5177, 0xe66f },
	{ 0x5178, 0xe670 },
	{ 0x5179, 0xe671 },
	{ 0x517a, 0xe672 },
	{ 0x517b, 0xe673 },
	{ 0x517c, 0xe674 },
	{ 0x517d, 0xe675 },
	{ 0x517e, 0xe676 },
	{ 0x5221, 0xe677 },
	{ 0x5222, 0xe678 },
	{ 0x5223, 0xe679 },
	{ 0x5224, 0xe67a },
	{ 0x5225, 0xe67b },
	{ 0x5226, 0xe67c },
	{ 0x5227, 0xe67d },
	{ 0x5228, 0xe67e },
	{ 0x5229, 0xe6a1 },
	{ 0x522a, 0xe6a2 },
	{ 0x522b, 0xe6a3 },
	{ 0x522c, 0xe6a4 },
	{ 0x522d, 0xe6a5 },
	{ 0x522e, 0xe6a6 },
	{ 0x522f, 0xe6a7 },
	{ 0x5230, 0xe6a8 },
	{ 0x5231, 0xe6a9 },
	{ 0x5232, 0xe6aa },
	{ 0x5233, 0xe6ab },
	{ 0x5234, 0xe6ac },
	{ 0x5235, 0xe6ad },
	{ 0x5236, 0xe6ae },
	{ 0x5237, 0xe6af },
	{ 0x5238, 0xe6b0 },
	{ 0x5239, 0xe6b1 },
	{ 0x523a, 0xe6b2 },
	{ 0x523b, 0xe6b3 },
	{ 0x523c, 0xe6b4 },
	{ 0x523d, 0xe6b5 },
	{ 0x523e, 0xe6b6 },
	{ 0x523f, 0xe6b7 },
	{ 0x5240, 0xe6b8 },
	{ 0x5241, 0xe6b9 },
	{ 0x5242, 0xe6ba },
	{ 0x5243, 0xe6bb },
	{ 0x5244, 0xe6bc },
	{ 0x5245, 0xe6bd },
	{ 0x5246, 0xe6be },
	{ 0x5247, 0xe6bf },
	{ 0x5248, 0xe6c0 },
	{ 0x5249, 0xe6c1 },
	{ 0x524a, 0xe6c2 },
	{ 0x524b, 0xe6c3 },
	{ 0x524c, 0xe6c4 },
	{ 0x524d, 0xe6c5 },
	{ 0x524e, 0xe6c6 },
	{ 0x524f, 0xe6c7 },
	{ 0x5250, 0xe6c8 },
	{ 0x5251, 0xe6c9 },
	{ 0x5252, 0xe6ca },
	{ 0x5253, 0xe6cb },
	{ 0x5254, 0xe6cc },
	{ 0x5255, 0xe6cd },
	{ 0x5256, 0xe6ce },
	{ 0x5257, 0xe6cf },
	{ 0x5258, 0xe6d0 },
	{ 0x5259, 0xe6d1 },
	{ 0x525a, 0xe6d2 },
	{ 0x525b, 0xe6d3 },
	{ 0x525c, 0xe6d4 },
	{ 0x525d, 0xe6d5 },
	{ 0x525e, 0xe6d6 },
	{ 0x525f, 0xe6d7 },
	{ 0x5260, 0xe6d8 },
	{ 0x5261, 0xe6d9 },
	{ 0x5262, 0xe6da },
	{ 0x5263, 0xe6db },
	{ 0x5264, 0xe6dc },
	{ 0x5265, 0xe6dd },
	{ 0x5266, 0xe6de },
	{ 0x5267, 0xe6df },
	{ 0x5268, 0xe6e0 },
	{ 0x5269, 0xe6e1 },
	{ 0x526a, 0xe6e2 },
	{ 0x526b, 0xe6e3 },
	{ 0x526c, 0xe6e4 },
	{ 0x526d, 0xe6e5 },
	{ 0x526e, 0xe6e6 },
	{ 0x526f, 0xe6e7 },
	{ 0x5270, 0xe6e8 },
	{ 0x5271, 0xe6e9 },
	{ 0x5272, 0xe6ea },
	{ 0x5273, 0xe6eb },
	{ 0x5274, 0xe6ec },
	{ 0x5275, 0xe6ed },
	{ 0x5276, 0xe6ee },
	{ 0x5277, 0xe6ef },
	{ 0x5278, 0xe6f0 },
	{ 0x5279, 0xe6f1 },
	{ 0x527a, 0xe6f2 },
	{ 0x527b, 0xe6f3 },
	{ 0x527c, 0xe6f4 },
	{ 0x527d, 0xe6f5 },
	{ 0x527e, 0xe6f6 },
	{ 0x5321, 0xe6f7 },
	{ 0x5322, 0xe6f8 },
	{ 0x5323, 0xe6f9 },
	{ 0x5324, 0xe6fa },
	{ 0x5325, 0xe6fb },
	{ 0x5326, 0xe6fc },
	{ 0x5327, 0xe6fd },
	{ 0x5328, 0xe6fe },
	{ 0x5329, 0xe740 },
	{ 0x532a, 0xe741 },
	{ 0x532b, 0xe742 },
	{ 0x532c, 0xe743 },
	{ 0x532d, 0xe744 },
	{ 0x532e, 0xe745 },
	{ 0x532f, 0xe746 },
	{ 0x5330, 0xe747 },
	{ 0x5331, 0xe748 },
	{ 0x5332, 0xe749 },
	{ 0x5333, 0xe74a },
	{ 0x5334, 0xe74b },
	{ 0x5335, 0xe74c },
	{ 0x5336, 0xe74d },
	{ 0x5337, 0xe74e },
	{ 0x5338, 0xe74f },
	{ 0x5339, 0xe750 },
	{ 0x533a, 0xe751 },
	{ 0x533b, 0xe752 },
	{ 0x533c, 0xe753 },
	{ 0x533d, 0xe754 },
	{ 0x533e, 0xe755 },
	{ 0x533f, 0xe756 },
	{ 0x5340, 0xe757 },
	{ 0x5341, 0xe758 },
	{ 0x5342, 0xe759 },
	{ 0x5343, 0xe75a },
	{ 0x5344, 0xe75b },
	{ 0x5345, 0xe75c },
	{ 0x5346, 0xe75d },
	{ 0x5347, 0xe75e },
	{ 0x5348, 0xe75f },
	{ 0x5349, 0xe760 },
	{ 0x534a, 0xe761 },
	{ 0x534b, 0xe762 },
	{ 0x534c, 0xe763 },
	{ 0x534d, 0xe764 },
	{ 0x534e, 0xe765 },
	{ 0x534f, 0xe766 },
	{ 0x5350, 0xe767 },
	{ 0x5351, 0xe768 },
	{ 0x5352, 0xe769 },
	{ 0x5353, 0xe76a },
	{ 0x5354, 0xe76b },
	{ 0x5355, 0xe76c },
	{ 0x5356, 0xe76d },
	{ 0x5357, 0xe76e },
	{ 0x5358, 0xe76f },
	{ 0x5359, 0xe770 },
	{ 0x535a, 0xe771 },
	{ 0x535b, 0xe772 },
	{ 0x535c, 0xe773 },
	{ 0x535d, 0xe774 },
	{ 0x535e, 0xe775 },
	{ 0x535f, 0xe776 },
	{ 0x5360, 0xe777 },
	{ 0x5361, 0xe778 },
	{ 0x5362, 0xe779 },
	{ 0x5363, 0xe77a },
	{ 0x5364, 0xe77b },
	{ 0x5365, 0xe77c },
	{ 0x5366, 0xe77d },
	{ 0x5367, 0xe77e },
	{ 0x5368, 0xe7a1 },
	{ 0x5369, 0xe7a2 },
	{ 0x536a, 0xe7a3 },
	{ 0x536b, 0xe7a4 },
	{ 0x536c, 0xe7a5 },
	{ 0x536d, 0xe7a6 },
	{ 0x536e, 0xe7a7 },
	{ 0x536f, 0xe7a8 },
	{ 0x5370, 0xe7a9 },
	{ 0x5371, 0xe7aa },
	{ 0x5372, 0xe7ab },
	{ 0x5373, 0xe7ac },
	{ 0x5374, 0xe7ad },
	{ 0x5375, 0xe7ae },
	{ 0x5376, 0xe7af },
	{ 0x5377, 0xe7b0 },
	{ 0x5378, 0xe7b1 },
	{ 0x5379, 0xe7b2 },
	{ 0x537a, 0xe7b3 },
	{ 0x537b, 0xe7b4 },
	{ 0x537c, 0xe7b5 },
	{ 0x537d, 0xe7b6 },
	{ 0x537e, 0xe7b7 },
	{ 0x5421, 0xe7b8 },
	{ 0x5422, 0xe7b9 },
	{ 0x5423, 0xe7ba },
	{ 0x5424, 0xe7bb },
	{ 0x5425, 0xe7bc },
	{ 0x5426, 0xe7bd },
	{ 0x5427, 0xe7be },
	{ 0x5428, 0xe7bf },
	{ 0x5429, 0xe7c0 },
	{ 0x542a, 0xe7c1 },
	{ 0x542b, 0xe7c2 },
	{ 0x542c, 0xe7c3 },
	{ 0x542d, 0xe7c4 },
	{ 0x542e, 0xe7c5 },
	{ 0x542f, 0xe7c6 },
	{ 0x5430, 0xe7c7 },
	{ 0x5431, 0xe7c8 },
	{ 0x5432, 0xe7c9 },
	{ 0x5433, 0xe7ca },
	{ 0x5434, 0xe7cb },
	{ 0x5435, 0xe7cc },
	{ 0x5436, 0xe7cd },
	{ 0x5437, 0xe7ce },
	{ 0x5438, 0xe7cf },
	{ 0x5439, 0xe7d0 },
	{ 0x543a, 0xe7d1 },
	{ 0x543b, 0xe7d2 },
	{ 0x543c, 0xe7d3 },
	{ 0x543d, 0xe7d4 },
	{ 0x543e, 0xe7d5 },
	{ 0x543f, 0xe7d6 },
	{ 0x5440, 0xe7d7 },
	{ 0x5441, 0xe7d8 },
	{ 0x5442, 0xe7d9 },
	{ 0x5443, 0xe7da },
	{ 0x5444, 0xe7db },
	{ 0x5445, 0xe7dc },
	{ 0x5446, 0xe7dd },
	{ 0x5447, 0xe7de },
	{ 0x5448, 0xe7df },
	{ 0x5449, 0xe7e0 },
	{ 0x544a, 0xe7e1 },
	{ 0x544b, 0xe7e2 },
	{ 0x544c, 0xe7e3 },
	{ 0x544d, 0xe7e4 },
	{ 0x544e, 0xe7e5 },
	{ 0x544f, 0xe7e6 },
	{ 0x5450, 0xe7e7 },
	{ 0x5451, 0xe7e8 },
	{ 0x5452, 0xe7e9 },
	{ 0x5453, 0xe7ea },
	{ 0x5454, 0xe7eb },
	{ 0x5455, 0xe7ec },
	{ 0x5456, 0xe7ed },
	{ 0x5457, 0xe7ee },
	{ 0x5458, 0xe7ef },
	{ 0x5459, 0xe7f0 },
	{ 0x545a, 0xe7f1 },
	{ 0x545b, 0xe7f2 },
	{ 0x545c, 0xe7f3 },
	{ 0x545d, 0xe7f4 },
	{ 0x545e, 0xe7f5 },
	{ 0x545f, 0xe7f6 },
	{ 0x5460, 0xe7f7 },
	{ 0x5461, 0xe7f8 },
	{ 0x5462, 0xe7f9 },
	{ 0x5463, 0xe7fa },
	{ 0x5464, 0xe7fb },
	{ 0x5465, 0xe7fc },
	{ 0x5466, 0xe7fd },
	{ 0x5467, 0xe7fe },
	{ 0x5468, 0xe840 },
	{ 0x5469, 0xe841 },
	{ 0x546a, 0xe842 },
	{ 0x546b, 0xe843 },
	{ 0x546c, 0xe844 },
	{ 0x546d, 0xe845 },
	{ 0x546e, 0xe846 },
	{ 0x546f, 0xe847 },
	{ 0x5470, 0xe848 },
	{ 0x5471, 0xe849 },
	{ 0x5472, 0xe84a },
	{ 0x5473, 0xe84b },
	{ 0x5474, 0xe84c },
	{ 0x5475, 0xe84d },
	{ 0x5476, 0xe84e },
	{ 0x5477, 0xe84f },
	{ 0x5478, 0xe850 },
	{ 0x5479, 0xe851 },
	{ 0x547a, 0xe852 },
	{ 0x547b, 0xe853 },
	{ 0x547c, 0xe854 },
	{ 0x547d, 0xe855 },
	{ 0x547e, 0xe856 },
	{ 0x5521, 0xe857 },
	{ 0x5522, 0xe858 },
	{ 0x5523, 0xe859 },
	{ 0x5524, 0xe85a },
	{ 0x5525, 0xe85b },
	{ 0x5526, 0xe85c },
	{ 0x5527, 0xe85d },
	{ 0x5528, 0xe85e },
	{ 0x5529, 0xe85f },
	{ 0x552a, 0xe860 },
	{ 0x552b, 0xe861 },
	{ 0x552c, 0xe862 },
	{ 0x552d, 0xe863 },
	{ 0x552e, 0xe864 },
	{ 0x552f, 0xe865 },
	{ 0x5530, 0xe866 },
	{ 0x5531, 0xe867 },
	{ 0x5532, 0xe868 },
	{ 0x5533, 0xe869 },
	{ 0x5534, 0xe86a },
	{ 0x5535, 0xe86b },
	{ 0x5536, 0xe86c },
	{ 0x5537, 0xe86d },
	{ 0x5538, 0xe86e },
	{ 0x5539, 0xe86f },
	{ 0x553a, 0xe870 },
	{ 0x553b, 0xe871 },
	{ 0x553c, 0xe872 },
	{ 0x553d, 0xe873 },
	{ 0x553e, 0xe874 },
	{ 0x553f, 0xe875 },
	{ 0x5540, 0xe876 },
	{ 0x5541, 0xe877 },
	{ 0x5542, 0xe878 },
	{ 0x5543, 0xe879 },
	{ 0x5544, 0xe87a },
	{ 0x5545, 0xe87b },
	{ 0x5546, 0xe87c },
	{ 0x5547, 0xe87d },
	{ 0x5548, 0xe87e },
	{ 0x5549, 0xe8a1 },
	{ 0x554a, 0xe8a2 },
	{ 0x554b, 0xebf1 },
	{ 0x554c, 0xe8a3 },
	{ 0x554d, 0xe8a4 },
	{ 0x554e, 0xe8a5 },
	{ 0x554f, 0xe8a6 },
	{ 0x5550, 0xe8a7 },
	{ 0x5551, 0xe8a8 },
	{ 0x5552, 0xe8a9 },
	{ 0x5553, 0xe8aa },
	{ 0x5554, 0xe8ab },
	{ 0x5555, 0xe8ac },
	{ 0x5556, 0xe8ad },
	{ 0x5557, 0xe8ae },
	{ 0x5558, 0xe8af },
	{ 0x5559, 0xe8b0 },
	{ 0x555a, 0xe8b1 },
	{ 0x555b, 0xe8b2 },
	{ 0x555c, 0xe8b3 },
	{ 0x555d, 0xe8b4 },
	{ 0x555e, 0xe8b5 },
	{ 0x555f, 0xe8b6 },
	{ 0x5560, 0xe8b7 },
	{ 0x5561, 0xe8b8 },
	{ 0x5562, 0xe8b9 },
	{ 0x5563, 0xe8ba },
	{ 0x5564, 0xe8bb },
	{ 0x5565, 0xe8bc },
	{ 0x5566, 0xe8bd },
	{ 0x5567, 0xe8be },
	{ 0x5568, 0xe8bf },
	{ 0x5569, 0xe8c0 },
	{ 0x556a, 0xe8c1 },
	{ 0x556b, 0xe8c2 },
	{ 0x556c, 0xe8c3 },
	{ 0x556d, 0xe8c4 },
	{ 0x556e, 0xe8c5 },
	{ 0x556f, 0xe8c6 },
	{ 0x5570, 0xe8c7 },
	{ 0x5571, 0xe8c8 },
	{ 0x5572, 0xe8c9 },
	{ 0x5573, 0xe8ca },
	{ 0x5574, 0xe8cb },
	{ 0x5575, 0xe8cc },
	{ 0x5576, 0xe8cd },
	{ 0x5577, 0xe8ce },
	{ 0x5578, 0xe8cf },
	{ 0x5579, 0xe8d0 },
	{ 0x557a, 0xe8d1 },
	{ 0x557b, 0xe8d2 },
	{ 0x557c, 0xe8d3 },
	{ 0x557d, 0xe8d4 },
	{ 0x557e, 0xe8d5 },
	{ 0x5621, 0xe8d6 },
	{ 0x5622, 0xe8d7 },
	{ 0x5623, 0xe8d8 },
	{ 0x5624, 0xe8d9 },
	{ 0x5625, 0xe8da },
	{ 0x5626, 0xe8db },
	{ 0x5627, 0xe8dc },
	{ 0x5628, 0xe8dd },
	{ 0x5629, 0xe8de },
	{ 0x562a, 0xe8df },
	{ 0x562b, 0xe8e0 },
	{ 0x562c, 0xe8e1 },
	{ 0x562d, 0xe8e2 },
	{ 0x562e, 0xe8e3 },
	{ 0x562f, 0xe8e4 },
	{ 0x5630, 0xe8e5 },
	{ 0x5631, 0xe8e6 },
	{ 0x5632, 0xe8e7 },
	{ 0x5633, 0xe8e8 },
	{ 0x5634, 0xe8e9 },
	{ 0x5635, 0xe8ea },
	{ 0x5636, 0xe8eb },
	{ 0x5637, 0xe8ec },
	{ 0x5638, 0xe8ed },
	{ 0x5639, 0xe8ee },
	{ 0x563a, 0xe8ef },
	{ 0x563b, 0xe8f0 },
	{ 0x563c, 0xe8f1 },
	{ 0x563d, 0xe8f2 },
	{ 0x563e, 0xe8f3 },
	{ 0x563f, 0xe8f4 },
	{ 0x5640, 0xe8f5 },
	{ 0x5641, 0xe8f6 },
	{ 0x5642, 0xe8f7 },
	{ 0x5643, 0xe8f8 },
	{ 0x5644, 0xe8f9 },
	{ 0x5645, 0xe8fa },
	{ 0x5646, 0xe8fb },
	{ 0x5647, 0xe8fc },
	{ 0x5648, 0xe8fd },
	{ 0x5649, 0xe8fe },
	{ 0x564a, 0xe940 },
	{ 0x564b, 0xe941 },
	{ 0x564c, 0xe942 },
	{ 0x564d, 0xe943 },
	{ 0x564e, 0xe944 },
	{ 0x564f, 0xe945 },
	{ 0x5650, 0xe946 },
	{ 0x5651, 0xe947 },
	{ 0x5652, 0xe948 },
	{ 0x5653, 0xe949 },
	{ 0x5654, 0xe94a },
	{ 0x5655, 0xe94b },
	{ 0x5656, 0xe94c },
	{ 0x5657, 0xe94d },
	{ 0x5658, 0xe94e },
	{ 0x5659, 0xe94f },
	{ 0x565a, 0xe950 },
	{ 0x565b, 0xe951 },
	{ 0x565c, 0xe952 },
	{ 0x565d, 0xe953 },
	{ 0x565e, 0xe954 },
	{ 0x565f, 0xe955 },
	{ 0x5660, 0xe956 },
	{ 0x5661, 0xe957 },
	{ 0x5662, 0xe958 },
	{ 0x5663, 0xe959 },
	{ 0x5664, 0xe95a },
	{ 0x5665, 0xe95b },
	{ 0x5666, 0xe95c },
	{ 0x5667, 0xe95d },
	{ 0x5668, 0xe95e },
	{ 0x5669, 0xe95f },
	{ 0x566a, 0xe960 },
	{ 0x566b, 0xe961 },
	{ 0x566c, 0xe962 },
	{ 0x566d, 0xe963 },
	{ 0x566e, 0xe964 },
	{ 0x566f, 0xe965 },
	{ 0x5670, 0xe966 },
	{ 0x5671, 0xe967 },
	{ 0x5672, 0xe968 },
	{ 0x5673, 0xe969 },
	{ 0x5674, 0xe96a },
	{ 0x5675, 0xe96b },
	{ 0x5676, 0xe96c },
	{ 0x5677, 0xe96d },
	{ 0x5678, 0xe96e },
	{ 0x5679, 0xe96f },
	{ 0x567a, 0xe970 },
	{ 0x567b, 0xe971 },
	{ 0x567c, 0xe972 },
	{ 0x567d, 0xe973 },
	{ 0x567e, 0xe974 },
	{ 0x5721, 0xe975 },
	{ 0x5722, 0xecde },
	{ 0x5723, 0xe976 },
	{ 0x5724, 0xe977 },
	{ 0x5725, 0xe978 },
	{ 0x5726, 0xe979 },
	{ 0x5727, 0xe97a },
	{ 0x5728, 0xe97b },
	{ 0x5729, 0xe97c },
	{ 0x572a, 0xe97d },
	{ 0x572b, 0xe97e },
	{ 0x572c, 0xe9a1 },
	{ 0x572d, 0xe9a2 },
	{ 0x572e, 0xe9a3 },
	{ 0x572f, 0xe9a4 },
	{ 0x5730, 0xe9a5 },
	{ 0x5731, 0xe9a6 },
	{ 0x5732, 0xe9a7 },
	{ 0x5733, 0xe9a8 },
	{ 0x5734, 0xe9a9 },
	{ 0x5735, 0xe9aa },
	{ 0x5736, 0xe9ab },
	{ 0x5737, 0xe9ac },
	{ 0x5738, 0xe9ad },
	{ 0x5739, 0xe9ae },
	{ 0x573a, 0xe9af },
	{ 0x573b, 0xe9b0 },
	{ 0x573c, 0xe9b1 },
	{ 0x573d, 0xe9b2 },
	{ 0x573e, 0xe9b3 },
	{ 0x573f, 0xe9b4 },
	{ 0x5740, 0xe9b5 },
	{ 0x5741, 0xe9b6 },
	{ 0x5742, 0xe9b7 },
	{ 0x5743, 0xe9b8 },
	{ 0x5744, 0xe9b9 },
	{ 0x5745, 0xe9ba },
	{ 0x5746, 0xe9bb },
	{ 0x5747, 0xe9bc },
	{ 0x5748, 0xe9bd },
	{ 0x5749, 0xe9be },
	{ 0x574a, 0xe9bf },
	{ 0x574b, 0xe9c0 },
	{ 0x574c, 0xe9c1 },
	{ 0x574d, 0xe9c2 },
	{ 0x574e, 0xe9c3 },
	{ 0x574f, 0xe9c4 },
	{ 0x5750, 0xe9c5 },
	{ 0x5751, 0xe9c6 },
	{ 0x5752, 0xe9c7 },
	{ 0x5753, 0xe9c8 },
	{ 0x5754, 0xe9c9 },
	{ 0x5755, 0xe9ca },
	{ 0x5756, 0xe9cb },
	{ 0x5757, 0xe9cc },
	{ 0x5758, 0xe9cd },
	{ 0x5759, 0xe9ce },
	{ 0x575a, 0xe9cf },
	{ 0x575b, 0xe9d0 },
	{ 0x575c, 0xe9d1 },
	{ 0x575d, 0xe9d2 },
	{ 0x575e, 0xe9d3 },
	{ 0x575f, 0xe9d4 },
	{ 0x5760, 0xe9d5 },
	{ 0x5761, 0xe9d6 },
	{ 0x5762, 0xe9d7 },
	{ 0x5763, 0xe9d8 },
	{ 0x5764, 0xe9d9 },
	{ 0x5765, 0xe9da },
	{ 0x5766, 0xe9db },
	{ 0x5767, 0xe9dc },
	{ 0x5768, 0xe9dd },
	{ 0x5769, 0xe9de },
	{ 0x576a, 0xe9df },
	{ 0x576b, 0xe9e0 },
	{ 0x576c, 0xe9e1 },
	{ 0x576d, 0xe9e2 },
	{ 0x576e, 0xe9e3 },
	{ 0x576f, 0xe9e4 },
	{ 0x5770, 0xe9e5 },
	{ 0x5771, 0xe9e6 },
	{ 0x5772, 0xe9e7 },
	{ 0x5773, 0xe9e8 },
	{ 0x5774, 0xe9e9 },
	{ 0x5775, 0xe9ea },
	{ 0x5776, 0xe9eb },
	{ 0x5777, 0xe9ec },
	{ 0x5778, 0xe9ed },
	{ 0x5779, 0xe9ee },
	{ 0x577a, 0xe9ef },
	{ 0x577b, 0xe9f0 },
	{ 0x577c, 0xe9f1 },
	{ 0x577d, 0xe9f2 },
	{ 0x577e, 0xe9f3 },
	{ 0x5821, 0xe9f4 },
	{ 0x5822, 0xe9f5 },
	{ 0x5823, 0xe9f6 },
	{ 0x5824, 0xe9f7 },
	{ 0x5825, 0xe9f8 },
	{ 0x5826, 0xe9f9 },
	{ 0x5827, 0xe9fa },
	{ 0x5828, 0xe9fb },
	{ 0x5829, 0xe9fc },
	{ 0x582a, 0xe9fd },
	{ 0x582b, 0xe9fe },
	{ 0x582c, 0xea40 },
	{ 0x582d, 0xea41 },
	{ 0x582e, 0xea42 },
	{ 0x582f, 0xea43 },
	{ 0x5830, 0xea44 },
	{ 0x5831, 0xea45 },
	{ 0x5832, 0xea46 },
	{ 0x5833, 0xea47 },
	{ 0x5834, 0xea48 },
	{ 0x5835, 0xea49 },
	{ 0x5836, 0xea4a },
	{ 0x5837, 0xea4b },
	{ 0x5838, 0xea4c },
	{ 0x5839, 0xea4d },
	{ 0x583a, 0xea4e },
	{ 0x583b, 0xea4f },
	{ 0x583c, 0xea50 },
	{ 0x583d, 0xea51 },
	{ 0x583e, 0xea52 },
	{ 0x583f, 0xea53 },
	{ 0x5840, 0xea54 },
	{ 0x5841, 0xea55 },
	{ 0x5842, 0xea56 },
	{ 0x5843, 0xea57 },
	{ 0x5844, 0xea58 },
	{ 0x5845, 0xea59 },
	{ 0x5846, 0xea5a },
	{ 0x5847, 0xea5b },
	{ 0x5848, 0xea5c },
	{ 0x5849, 0xea5d },
	{ 0x584a, 0xea5e },
	{ 0x584b, 0xea5f },
	{ 0x584c, 0xea60 },
	{ 0x584d, 0xea61 },
	{ 0x584e, 0xea62 },
	{ 0x584f, 0xea63 },
	{ 0x5850, 0xea64 },
	{ 0x5851, 0xea65 },
	{ 0x5852, 0xea66 },
	{ 0x5853, 0xea67 },
	{ 0x5854, 0xea68 },
	{ 0x5855, 0xea69 },
	{ 0x5856, 0xea6a },
	{ 0x5857, 0xea6b },
	{ 0x5858, 0xea6c },
	{ 0x5859, 0xea6d },
	{ 0x585a, 0xea6e },
	{ 0x585b, 0xea6f },
	{ 0x585c, 0xea70 },
	{ 0x585d, 0xea71 },
	{ 0x585e, 0xea72 },
	{ 0x585f, 0xea73 },
	{ 0x5860, 0xea74 },
	{ 0x5861, 0xea75 },
	{ 0x5862, 0xea76 },
	{ 0x5863, 0xea77 },
	{ 0x5864, 0xea78 },
	{ 0x5865, 0xea79 },
	{ 0x5866, 0xea7a },
	{ 0x5867, 0xea7b },
	{ 0x5868, 0xea7c },
	{ 0x5869, 0xea7d },
	{ 0x586a, 0xea7e },
	{ 0x586b, 0xeaa1 },
	{ 0x586c, 0xeaa2 },
	{ 0x586d, 0xeaa3 },
	{ 0x586e, 0xeaa4 },
	{ 0x586f, 0xeaa5 },
	{ 0x5870, 0xeaa6 },
	{ 0x5871, 0xeaa7 },
	{ 0x5872, 0xeaa8 },
	{ 0x5873, 0xeaa9 },
	{ 0x5874, 0xeaaa },
	{ 0x5875, 0xeaab },
	{ 0x5876, 0xeaac },
	{ 0x5877, 0xeaad },
	{ 0x5878, 0xeaae },
	{ 0x5879, 0xeaaf },
	{ 0x587a, 0xeab0 },
	{ 0x587b, 0xeab1 },
	{ 0x587c, 0xeab2 },
	{ 0x587d, 0xeab3 },
	{ 0x587e, 0xeab4 },
	{ 0x5921, 0xeab5 },
	{ 0x5922, 0xeab6 },
	{ 0x5923, 0xeab7 },
	{ 0x5924, 0xeab8 },
	{ 0x5925, 0xeab9 },
	{ 0x5926, 0xeaba },
	{ 0x5927, 0xeabb },
	{ 0x5928, 0xeabc },
	{ 0x5929, 0xeabd },
	{ 0x592a, 0xeabe },
	{ 0x592b, 0xeabf },
	{ 0x592c, 0xeac0 },
	{ 0x592d, 0xeac1 },
	{ 0x592e, 0xeac2 },
	{ 0x592f, 0xeac3 },
	{ 0x5930, 0xeac4 },
	{ 0x5931, 0xeac5 },
	{ 0x5932, 0xeac6 },
	{ 0x5933, 0xeac7 },
	{ 0x5934, 0xeac8 },
	{ 0x5935, 0xeac9 },
	{ 0x5936, 0xeaca },
	{ 0x5937, 0xeacb },
	{ 0x5938, 0xeacc },
	{ 0x5939, 0xeacd },
	{ 0x593a, 0xeace },
	{ 0x593b, 0xeacf },
	{ 0x593c, 0xead0 },
	{ 0x593d, 0xead1 },
	{ 0x593e, 0xead2 },
	{ 0x593f, 0xead3 },
	{ 0x5940, 0xead4 },
	{ 0x5941, 0xead5 },
	{ 0x5942, 0xead6 },
	{ 0x5943, 0xead7 },
	{ 0x5944, 0xead8 },
	{ 0x5945, 0xead9 },
	{ 0x5946, 0xeada },
	{ 0x5947, 0xeadb },
	{ 0x5948, 0xeadc },
	{ 0x5949, 0xeadd },
	{ 0x594a, 0xeade },
	{ 0x594b, 0xeadf },
	{ 0x594c, 0xeae0 },
	{ 0x594d, 0xeae1 },
	{ 0x594e, 0xeae2 },
	{ 0x594f, 0xeae3 },
	{ 0x5950, 0xeae4 },
	{ 0x5951, 0xeae5 },
	{ 0x5952, 0xeae6 },
	{ 0x5953, 0xeae7 },
	{ 0x5954, 0xeae8 },
	{ 0x5955, 0xeae9 },
	{ 0x5956, 0xeaea },
	{ 0x5957, 0xeaeb },
	{ 0x5958, 0xeaec },
	{ 0x5959, 0xeaed },
	{ 0x595a, 0xeaee },
	{ 0x595b, 0xeaef },
	{ 0x595c, 0xeaf0 },
	{ 0x595d, 0xeaf1 },
	{ 0x595e, 0xeaf2 },
	{ 0x595f, 0xeaf3 },
	{ 0x5960, 0xeaf4 },
	{ 0x5961, 0xeaf5 },
	{ 0x5962, 0xeaf6 },
	{ 0x5963, 0xeaf7 },
	{ 0x5964, 0xeaf8 },
	{ 0x5965, 0xeaf9 },
	{ 0x5966, 0xeafa },
	{ 0x5967, 0xeafb },
	{ 0x5968, 0xeafc },
	{ 0x5969, 0xeafd },
	{ 0x596a, 0xeafe },
	{ 0x596b, 0xeb40 },
	{ 0x596c, 0xeb41 },
	{ 0x596d, 0xeb42 },
	{ 0x596e, 0xeb43 },
	{ 0x596f, 0xeb44 },
	{ 0x5970, 0xeb45 },
	{ 0x5971, 0xeb46 },
	{ 0x5972, 0xeb47 },
	{ 0x5973, 0xeb48 },
	{ 0x5974, 0xeb49 },
	{ 0x5975, 0xeb4a },
	{ 0x5976, 0xeb4b },
	{ 0x5977, 0xeb4c },
	{ 0x5978, 0xeb4d },
	{ 0x5979, 0xeb4e },
	{ 0x597a, 0xeb4f },
	{ 0x597b, 0xeb50 },
	{ 0x597c, 0xeb51 },
	{ 0x597d, 0xeb52 },
	{ 0x597e, 0xeb53 },
	{ 0x5a21, 0xeb54 },
	{ 0x5a22, 0xeb55 },
	{ 0x5a23, 0xeb56 },
	{ 0x5a24, 0xeb57 },
	{ 0x5a25, 0xeb58 },
	{ 0x5a26, 0xeb59 },
	{ 0x5a27, 0xeb5a },
	{ 0x5a28, 0xf0cb },
	{ 0x5a29, 0xeb5b },
	{ 0x5a2a, 0xeb5c },
	{ 0x5a2b, 0xeb5d },
	{ 0x5a2c, 0xeb5e },
	{ 0x5a2d, 0xeb5f },
	{ 0x5a2e, 0xeb60 },
	{ 0x5a2f, 0xeb61 },
	{ 0x5a30, 0xeb62 },
	{ 0x5a31, 0xeb63 },
	{ 0x5a32, 0xeb64 },
	{ 0x5a33, 0xeb65 },
	{ 0x5a34, 0xeb66 },
	{ 0x5a35, 0xeb67 },
	{ 0x5a36, 0xeb68 },
	{ 0x5a37, 0xeb69 },
	{ 0x5a38, 0xeb6a },
	{ 0x5a39, 0xeb6b },
	{ 0x5a3a, 0xeb6c },
	{ 0x5a3b, 0xeb6d },
	{ 0x5a3c, 0xeb6e },
	{ 0x5a3d, 0xeb6f },
	{ 0x5a3e, 0xeb70 },
	{ 0x5a3f, 0xeb71 },
	{ 0x5a40, 0xeb72 },
	{ 0x5a41, 0xeb73 },
	{ 0x5a42, 0xeb74 },
	{ 0x5a43, 0xeb75 },
	{ 0x5a44, 0xeb76 },
	{ 0x5a45, 0xeb77 },
	{ 0x5a46, 0xeb78 },
	{ 0x5a47, 0xeb79 },
	{ 0x5a48, 0xeb7a },
	{ 0x5a49, 0xeb7b },
	{ 0x5a4a, 0xeb7c },
	{ 0x5a4b, 0xeb7d },
	{ 0x5a4c, 0xeb7e },
	{ 0x5a4d, 0xeba1 },
	{ 0x5a4e, 0xeba2 },
	{ 0x5a4f, 0xeba3 },
	{ 0x5a50, 0xeba4 },
	{ 0x5a51, 0xeba5 },
	{ 0x5a52, 0xeba6 },
	{ 0x5a53, 0xeba7 },
	{ 0x5a54, 0xeba8 },
	{ 0x5a55, 0xeba9 },
	{ 0x5a56, 0xebaa },
	{ 0x5a57, 0xebab },
	{ 0x5a58, 0xebac },
	{ 0x5a59, 0xebad },
	{ 0x5a5a, 0xebae },
	{ 0x5a5b, 0xebaf },
	{ 0x5a5c, 0xebb0 },
	{ 0x5a5d, 0xebb1 },
	{ 0x5a5e, 0xebb2 },
	{ 0x5a5f, 0xebb3 },
	{ 0x5a60, 0xebb4 },
	{ 0x5a61, 0xebb5 },
	{ 0x5a62, 0xebb6 },
	{ 0x5a63, 0xebb7 },
	{ 0x5a64, 0xebb8 },
	{ 0x5a65, 0xebb9 },
	{ 0x5a66, 0xebba },
	{ 0x5a67, 0xebbb },
	{ 0x5a68, 0xebbc },
	{ 0x5a69, 0xebbd },
	{ 0x5a6a, 0xebbe },
	{ 0x5a6b, 0xebbf },
	{ 0x5a6c, 0xebc0 },
	{ 0x5a6d, 0xebc1 },
	{ 0x5a6e, 0xebc2 },
	{ 0x5a6f, 0xebc3 },
	{ 0x5a70, 0xebc4 },
	{ 0x5a71, 0xebc5 },
	{ 0x5a72, 0xebc6 },
	{ 0x5a73, 0xebc7 },
	{ 0x5a74, 0xebc8 },
	{ 0x5a75, 0xebc9 },
	{ 0x5a76, 0xebca },
	{ 0x5a77, 0xebcb },
	{ 0x5a78, 0xebcc },
	{ 0x5a79, 0xebcd },
	{ 0x5a7a, 0xebce },
	{ 0x5a7b, 0xebcf },
	{ 0x5a7c, 0xebd0 },
	{ 0x5a7d, 0xebd1 },
	{ 0x5a7e, 0xebd2 },
	{ 0x5b21, 0xebd3 },
	{ 0x5b22, 0xebd4 },
	{ 0x5b23, 0xebd5 },
	{ 0x5b24, 0xebd6 },
	{ 0x5b25, 0xebd7 },
	{ 0x5b26, 0xebd8 },
	{ 0x5b27, 0xebd9 },
	{ 0x5b28, 0xebda },
	{ 0x5b29, 0xebdb },
	{ 0x5b2a, 0xebdc },
	{ 0x5b2b, 0xebdd },
	{ 0x5b2c, 0xebde },
	{ 0x5b2d, 0xebdf },
	{ 0x5b2e, 0xebe0 },
	{ 0x5b2f, 0xebe1 },
	{ 0x5b30, 0xebe2 },
	{ 0x5b31, 0xebe3 },
	{ 0x5b32, 0xebe4 },
	{ 0x5b33, 0xebe5 },
	{ 0x5b34, 0xebe6 },
	{ 0x5b35, 0xebe7 },
	{ 0x5b36, 0xebe8 },
	{ 0x5b37, 0xebe9 },
	{ 0x5b38, 0xebea },
	{ 0x5b39, 0xebeb },
	{ 0x5b3a, 0xebec },
	{ 0x5b3b, 0xebed },
	{ 0x5b3c, 0xebee },
	{ 0x5b3d, 0xebef },
	{ 0x5b3e, 0xebf0 },
	{ 0x5b3f, 0xebf2 },
	{ 0x5b40, 0xebf3 },
	{ 0x5b41, 0xebf4 },
	{ 0x5b42, 0xebf5 },
	{ 0x5b43, 0xebf6 },
	{ 0x5b44, 0xebf7 },
	{ 0x5b45, 0xebf8 },
	{ 0x5b46, 0xebf9 },
	{ 0x5b47, 0xebfa },
	{ 0x5b48, 0xebfb },
	{ 0x5b49, 0xebfc },
	{ 0x5b4a, 0xebfd },
	{ 0x5b4b, 0xebfe },
	{ 0x5b4c, 0xec40 },
	{ 0x5b4d, 0xec41 },
	{ 0x5b4e, 0xec42 },
	{ 0x5b4f, 0xec43 },
	{ 0x5b50, 0xec44 },
	{ 0x5b51, 0xec45 },
	{ 0x5b52, 0xec46 },
	{ 0x5b53, 0xec47 },
	{ 0x5b54, 0xec48 },
	{ 0x5b55, 0xec49 },
	{ 0x5b56, 0xec4a },
	{ 0x5b57, 0xec4b },
	{ 0x5b58, 0xec4c },
	{ 0x5b59, 0xec4d },
	{ 0x5b5a, 0xec4e },
	{ 0x5b5b, 0xec4f },
	{ 0x5b5c, 0xec50 },
	{ 0x5b5d, 0xec51 },
	{ 0x5b5e, 0xec52 },
	{ 0x5b5f, 0xec53 },
	{ 0x5b60, 0xec54 },
	{ 0x5b61, 0xec55 },
	{ 0x5b62, 0xec56 },
	{ 0x5b63, 0xec57 },
	{ 0x5b64, 0xec58 },
	{ 0x5b65, 0xec59 },
	{ 0x5b66, 0xec5a },
	{ 0x5b67, 0xec5b },
	{ 0x5b68, 0xec5c },
	{ 0x5b69, 0xec5d },
	{ 0x5b6a, 0xec5e },
	{ 0x5b6b, 0xec5f },
	{ 0x5b6c, 0xec60 },
	{ 0x5b6d, 0xec61 },
	{ 0x5b6e, 0xec62 },
	{ 0x5b6f, 0xec63 },
	{ 0x5b70, 0xec64 },
	{ 0x5b71, 0xec65 },
	{ 0x5b72, 0xec66 },
	{ 0x5b73, 0xec67 },
	{ 0x5b74, 0xec68 },
	{ 0x5b75, 0xec69 },
	{ 0x5b76, 0xec6a },
	{ 0x5b77, 0xec6b },
	{ 0x5b78, 0xec6c },
	{ 0x5b79, 0xec6d },
	{ 0x5b7a, 0xec6e },
	{ 0x5b7b, 0xec6f },
	{ 0x5b7c, 0xec70 },
	{ 0x5b7d, 0xec71 },
	{ 0x5b7e, 0xec72 },
	{ 0x5c21, 0xec73 },
	{ 0x5c22, 0xec74 },
	{ 0x5c23, 0xec75 },
	{ 0x5c24, 0xec76 },
	{ 0x5c25, 0xec77 },
	{ 0x5c26, 0xec78 },
	{ 0x5c27, 0xec79 },
	{ 0x5c28, 0xec7a },
	{ 0x5c29, 0xec7b },
	{ 0x5c2a, 0xec7c },
	{ 0x5c2b, 0xec7d },
	{ 0x5c2c, 0xec7e },
	{ 0x5c2d, 0xeca1 },
	{ 0x5c2e, 0xeca2 },
	{ 0x5c2f, 0xeca3 },
	{ 0x5c30, 0xeca4 },
	{ 0x5c31, 0xeca5 },
	{ 0x5c32, 0xeca6 },
	{ 0x5c33, 0xeca7 },
	{ 0x5c34, 0xeca8 },
	{ 0x5c35, 0xeca9 },
	{ 0x5c36, 0xecaa },
	{ 0x5c37, 0xecab },
	{ 0x5c38, 0xecac },
	{ 0x5c39, 0xecad },
	{ 0x5c3a, 0xecae },
	{ 0x5c3b, 0xecaf },
	{ 0x5c3c, 0xecb0 },
	{ 0x5c3d, 0xecb1 },
	{ 0x5c3e, 0xecb2 },
	{ 0x5c3f, 0xecb3 },
	{ 0x5c40, 0xecb4 },
	{ 0x5c41, 0xecb5 },
	{ 0x5c42, 0xecb6 },
	{ 0x5c43, 0xecb7 },
	{ 0x5c44, 0xecb8 },
	{ 0x5c45, 0xecb9 },
	{ 0x5c46, 0xecba },
	{ 0x5c47, 0xecbb },
	{ 0x5c48, 0xecbc },
	{ 0x5c49, 0xecbd },
	{ 0x5c4a, 0xecbe },
	{ 0x5c4b, 0xecbf },
	{ 0x5c4c, 0xecc0 },
	{ 0x5c4d, 0xecc1 },
	{ 0x5c4e, 0xecc2 },
	{ 0x5c4f, 0xecc3 },
	{ 0x5c50, 0xecc4 },
	{ 0x5c51, 0xecc5 },
	{ 0x5c52, 0xecc6 },
	{ 0x5c53, 0xecc7 },
	{ 0x5c54, 0xecc8 },
	{ 0x5c55, 0xecc9 },
	{ 0x5c56, 0xecca },
	{ 0x5c57, 0xeccb },
	{ 0x5c58, 0xeccc },
	{ 0x5c59, 0xeccd },
	{ 0x5c5a, 0xecce },
	{ 0x5c5b, 0xeccf },
	{ 0x5c5c, 0xecd0 },
	{ 0x5c5d, 0xecd1 },
	{ 0x5c5e, 0xecd2 },
	{ 0x5c5f, 0xecd3 },
	{ 0x5c60, 0xecd4 },
	{ 0x5c61, 0xecd5 },
	{ 0x5c62, 0xecd6 },
	{ 0x5c63, 0xecd7 },
	{ 0x5c64, 0xecd8 },
	{ 0x5c65, 0xecd9 },
	{ 0x5c66, 0xecda },
	{ 0x5c67, 0xecdb },
	{ 0x5c68, 0xecdc },
	{ 0x5c69, 0xecdd },
	{ 0x5c6a, 0xecdf },
	{ 0x5c6b, 0xece0 },
	{ 0x5c6c, 0xece1 },
	{ 0x5c6d, 0xece2 },
	{ 0x5c6e, 0xece3 },
	{ 0x5c6f, 0xece4 },
	{ 0x5c70, 0xece5 },
	{ 0x5c71, 0xece6 },
	{ 0x5c72, 0xece7 },
	{ 0x5c73, 0xece8 },
	{ 0x5c74, 0xece9 },
	{ 0x5c75, 0xecea },
	{ 0x5c76, 0xeceb },
	{ 0x5c77, 0xecec },
	{ 0x5c78, 0xeced },
	{ 0x5c79, 0xecee },
	{ 0x5c7a, 0xecef },
	{ 0x5c7b, 0xecf0 },
	{ 0x5c7c, 0xecf1 },
	{ 0x5c7d, 0xecf2 },
	{ 0x5c7e, 0xecf3 },
	{ 0x5d21, 0xecf4 },
	{ 0x5d22, 0xecf5 },
	{ 0x5d23, 0xecf6 },
	{ 0x5d24, 0xecf7 },
	{ 0x5d25, 0xecf8 },
	{ 0x5d26, 0xecf9 },
	{ 0x5d27, 0xecfa },
	{ 0x5d28, 0xecfb },
	{ 0x5d29, 0xecfc },
	{ 0x5d2a, 0xecfd },
	{ 0x5d2b, 0xecfe },
	{ 0x5d2c, 0xed40 },
	{ 0x5d2d, 0xed41 },
	{ 0x5d2e, 0xed42 },
	{ 0x5d2f, 0xed43 },
	{ 0x5d30, 0xed44 },
	{ 0x5d31, 0xed45 },
	{ 0x5d32, 0xed46 },
	{ 0x5d33, 0xed47 },
	{ 0x5d34, 0xed48 },
	{ 0x5d35, 0xed49 },
	{ 0x5d36, 0xed4a },
	{ 0x5d37, 0xed4b },
	{ 0x5d38, 0xed4c },
	{ 0x5d39, 0xed4d },
	{ 0x5d3a, 0xed4e },
	{ 0x5d3b, 0xed4f },
	{ 0x5d3c, 0xed50 },
	{ 0x5d3d, 0xed51 },
	{ 0x5d3e, 0xed52 },
	{ 0x5d3f, 0xed53 },
	{ 0x5d40, 0xed54 },
	{ 0x5d41, 0xed55 },
	{ 0x5d42, 0xed56 },
	{ 0x5d43, 0xed57 },
	{ 0x5d44, 0xed58 },
	{ 0x5d45, 0xed59 },
	{ 0x5d46, 0xed5a },
	{ 0x5d47, 0xed5b },
	{ 0x5d48, 0xed5c },
	{ 0x5d49, 0xed5d },
	{ 0x5d4a, 0xed5e },
	{ 0x5d4b, 0xed5f },
	{ 0x5d4c, 0xed60 },
	{ 0x5d4d, 0xed61 },
	{ 0x5d4e, 0xed62 },
	{ 0x5d4f, 0xed63 },
	{ 0x5d50, 0xed64 },
	{ 0x5d51, 0xed65 },
	{ 0x5d52, 0xed66 },
	{ 0x5d53, 0xed67 },
	{ 0x5d54, 0xed68 },
	{ 0x5d55, 0xed69 },
	{ 0x5d56, 0xed6a },
	{ 0x5d57, 0xed6b },
	{ 0x5d58, 0xed6c },
	{ 0x5d59, 0xed6d },
	{ 0x5d5a, 0xed6e },
	{ 0x5d5b, 0xed6f },
	{ 0x5d5c, 0xed70 },
	{ 0x5d5d, 0xed71 },
	{ 0x5d5e, 0xed72 },
	{ 0x5d5f, 0xed73 },
	{ 0x5d60, 0xed74 },
	{ 0x5d61, 0xed75 },
	{ 0x5d62, 0xed76 },
	{ 0x5d63, 0xed77 },
	{ 0x5d64, 0xed78 },
	{ 0x5d65, 0xed79 },
	{ 0x5d66, 0xed7a },
	{ 0x5d67, 0xed7b },
	{ 0x5d68, 0xed7c },
	{ 0x5d69, 0xed7d },
	{ 0x5d6a, 0xed7e },
	{ 0x5d6b, 0xeda1 },
	{ 0x5d6c, 0xeda2 },
	{ 0x5d6d, 0xeda3 },
	{ 0x5d6e, 0xeda4 },
	{ 0x5d6f, 0xeda5 },
	{ 0x5d70, 0xeda6 },
	{ 0x5d71, 0xeda7 },
	{ 0x5d72, 0xeda8 },
	{ 0x5d73, 0xeda9 },
	{ 0x5d74, 0xf056 },
	{ 0x5d75, 0xedaa },
	{ 0x5d76, 0xedab },
	{ 0x5d77, 0xedac },
	{ 0x5d78, 0xedad },
	{ 0x5d79, 0xedae },
	{ 0x5d7a, 0xedaf },
	{ 0x5d7b, 0xedb0 },
	{ 0x5d7c, 0xedb1 },
	{ 0x5d7d, 0xedb2 },
	{ 0x5d7e, 0xedb3 },
	{ 0x5e21, 0xedb4 },
	{ 0x5e22, 0xedb5 },
	{ 0x5e23, 0xedb6 },
	{ 0x5e24, 0xedb7 },
	{ 0x5e25, 0xedb8 },
	{ 0x5e26, 0xedb9 },
	{ 0x5e27, 0xedba },
	{ 0x5e28, 0xedbb },
	{ 0x5e29, 0xedbc },
	{ 0x5e2a, 0xedbd },
	{ 0x5e2b, 0xedbe },
	{ 0x5e2c, 0xedbf },
	{ 0x5e2d, 0xedc0 },
	{ 0x5e2e, 0xedc1 },
	{ 0x5e2f, 0xedc2 },
	{ 0x5e30, 0xedc3 },
	{ 0x5e31, 0xedc4 },
	{ 0x5e32, 0xedc5 },
	{ 0x5e33, 0xedc6 },
	{ 0x5e34, 0xedc7 },
	{ 0x5e35, 0xedc8 },
	{ 0x5e36, 0xedc9 },
	{ 0x5e37, 0xedca },
	{ 0x5e38, 0xedcb },
	{ 0x5e39, 0xedcc },
	{ 0x5e3a, 0xedcd },
	{ 0x5e3b, 0xedce },
	{ 0x5e3c, 0xedcf },
	{ 0x5e3d, 0xedd0 },
	{ 0x5e3e, 0xedd1 },
	{ 0x5e3f, 0xedd2 },
	{ 0x5e40, 0xedd3 },
	{ 0x5e41, 0xedd4 },
	{ 0x5e42, 0xedd5 },
	{ 0x5e43, 0xedd6 },
	{ 0x5e44, 0xedd7 },
	{ 0x5e45, 0xedd8 },
	{ 0x5e46, 0xedd9 },
	{ 0x5e47, 0xedda },
	{ 0x5e48, 0xeddb },
	{ 0x5e49, 0xeddc },
	{ 0x5e4a, 0xeddd },
	{ 0x5e4b, 0xedde },
	{ 0x5e4c, 0xeddf },
	{ 0x5e4d, 0xede0 },
	{ 0x5e4e, 0xede1 },
	{ 0x5e4f, 0xede2 },
	{ 0x5e50, 0xede3 },
	{ 0x5e51, 0xede4 },
	{ 0x5e52, 0xede5 },
	{ 0x5e53, 0xede6 },
	{ 0x5e54, 0xede7 },
	{ 0x5e55, 0xede8 },
	{ 0x5e56, 0xede9 },
	{ 0x5e57, 0xedea },
	{ 0x5e58, 0xedeb },
	{ 0x5e59, 0xedec },
	{ 0x5e5a, 0xeded },
	{ 0x5e5b, 0xedee },
	{ 0x5e5c, 0xedef },
	{ 0x5e5d, 0xedf0 },
	{ 0x5e5e, 0xedf1 },
	{ 0x5e5f, 0xedf2 },
	{ 0x5e60, 0xedf3 },
	{ 0x5e61, 0xedf4 },
	{ 0x5e62, 0xedf5 },
	{ 0x5e63, 0xedf6 },
	{ 0x5e64, 0xedf7 },
	{ 0x5e65, 0xedf8 },
	{ 0x5e66, 0xedf9 },
	{ 0x5e67, 0xedfa },
	{ 0x5e68, 0xedfb },
	{ 0x5e69, 0xedfc },
	{ 0x5e6a, 0xedfd },
	{ 0x5e6b, 0xedfe },
	{ 0x5e6c, 0xee40 },
	{ 0x5e6d, 0xee41 },
	{ 0x5e6e, 0xee42 },
	{ 0x5e6f, 0xee43 },
	{ 0x5e70, 0xee44 },
	{ 0x5e71, 0xee45 },
	{ 0x5e72, 0xee46 },
	{ 0x5e73, 0xee47 },
	{ 0x5e74, 0xee48 },
	{ 0x5e75, 0xee49 },
	{ 0x5e76, 0xee4a },
	{ 0x5e77, 0xee4b },
	{ 0x5e78, 0xee4c },
	{ 0x5e79, 0xee4d },
	{ 0x5e7a, 0xee4e },
	{ 0x5e7b, 0xee4f },
	{ 0x5e7c, 0xee50 },
	{ 0x5e7d, 0xee51 },
	{ 0x5e7e, 0xee52 },
	{ 0x5f21, 0xee53 },
	{ 0x5f22, 0xee54 },
	{ 0x5f23, 0xee55 },
	{ 0x5f24, 0xee56 },
	{ 0x5f25, 0xee57 },
	{ 0x5f26, 0xee58 },
	{ 0x5f27, 0xee59 },
	{ 0x5f28, 0xee5a },
	{ 0x5f29, 0xee5b },
	{ 0x5f2a, 0xee5c },
	{ 0x5f2b, 0xee5d },
	{ 0x5f2c, 0xee5e },
	{ 0x5f2d, 0xee5f },
	{ 0x5f2e, 0xee60 },
	{ 0x5f2f, 0xee61 },
	{ 0x5f30, 0xee62 },
	{ 0x5f31, 0xee63 },
	{ 0x5f32, 0xee64 },
	{ 0x5f33, 0xee65 },
	{ 0x5f34, 0xee66 },
	{ 0x5f35, 0xee67 },
	{ 0x5f36, 0xee68 },
	{ 0x5f37, 0xee69 },
	{ 0x5f38, 0xee6a },
	{ 0x5f39, 0xee6b },
	{ 0x5f3a, 0xee6c },
	{ 0x5f3b, 0xee6d },
	{ 0x5f3c, 0xee6e },
	{ 0x5f3d, 0xee6f },
	{ 0x5f3e, 0xee70 },
	{ 0x5f3f, 0xee71 },
	{ 0x5f40, 0xee72 },
	{ 0x5f41, 0xee73 },
	{ 0x5f42, 0xee74 },
	{ 0x5f43, 0xee75 },
	{ 0x5f44, 0xee76 },
	{ 0x5f45, 0xee77 },
	{ 0x5f46, 0xee78 },
	{ 0x5f47, 0xee79 },
	{ 0x5f48, 0xee7a },
	{ 0x5f49, 0xee7b },
	{ 0x5f4a, 0xee7c },
	{ 0x5f4b, 0xee7d },
	{ 0x5f4c, 0xee7e },
	{ 0x5f4d, 0xeea1 },
	{ 0x5f4e, 0xeea2 },
	{ 0x5f4f, 0xeea3 },
	{ 0x5f50, 0xeea4 },
	{ 0x5f51, 0xeea5 },
	{ 0x5f52, 0xeea6 },
	{ 0x5f53, 0xeea7 },
	{ 0x5f54, 0xeea8 },
	{ 0x5f55, 0xeea9 },
	{ 0x5f56, 0xeeaa },
	{ 0x5f57, 0xeeab },
	{ 0x5f58, 0xeeac },
	{ 0x5f59, 0xeead },
	{ 0x5f5a, 0xeeae },
	{ 0x5f5b, 0xeeaf },
	{ 0x5f5c, 0xeeb0 },
	{ 0x5f5d, 0xeeb1 },
	{ 0x5f5e, 0xeeb2 },
	{ 0x5f5f, 0xeeb3 },
	{ 0x5f60, 0xeeb4 },
	{ 0x5f61, 0xeeb5 },
	{ 0x5f62, 0xeeb6 },
	{ 0x5f63, 0xeeb7 },
	{ 0x5f64, 0xeeb8 },
	{ 0x5f65, 0xeeb9 },
	{ 0x5f66, 0xeeba },
	{ 0x5f67, 0xeebb },
	{ 0x5f68, 0xeebc },
	{ 0x5f69, 0xeebd },
	{ 0x5f6a, 0xeebe },
	{ 0x5f6b, 0xeebf },
	{ 0x5f6c, 0xeec0 },
	{ 0x5f6d, 0xeec1 },
	{ 0x5f6e, 0xeec2 },
	{ 0x5f6f, 0xeec3 },
	{ 0x5f70, 0xeec4 },
	{ 0x5f71, 0xeec5 },
	{ 0x5f72, 0xeec6 },
	{ 0x5f73, 0xeec7 },
	{ 0x5f74, 0xeec8 },
	{ 0x5f75, 0xeec9 },
	{ 0x5f76, 0xeeca },
	{ 0x5f77, 0xeecb },
	{ 0x5f78, 0xeecc },
	{ 0x5f79, 0xeecd },
	{ 0x5f7a, 0xeece },
	{ 0x5f7b, 0xeecf },
	{ 0x5f7c, 0xeed0 },
	{ 0x5f7d, 0xeed1 },
	{ 0x5f7e, 0xeed2 },
	{ 0x6021, 0xeed3 },
	{ 0x6022, 0xeed4 },
	{ 0x6023, 0xeed5 },
	{ 0x6024, 0xeed6 },
	{ 0x6025, 0xeed7 },
	{ 0x6026, 0xeed8 },
	{ 0x6027, 0xeed9 },
	{ 0x6028, 0xeeda },
	{ 0x6029, 0xeedb },
	{ 0x602a, 0xeedc },
	{ 0x602b, 0xeedd },
	{ 0x602c, 0xeede },
	{ 0x602d, 0xeedf },
	{ 0x602e, 0xeee0 },
	{ 0x602f, 0xeee1 },
	{ 0x6030, 0xeee2 },
	{ 0x6031, 0xeee3 },
	{ 0x6032, 0xeee4 },
	{ 0x6033, 0xeee5 },
	{ 0x6034, 0xeee6 },
	{ 0x6035, 0xeee7 },
	{ 0x6036, 0xeee8 },
	{ 0x6037, 0xeee9 },
	{ 0x6038, 0xeeea },
	{ 0x6039, 0xeeec },
	{ 0x603a, 0xeeed },
	{ 0x603b, 0xeeee },
	{ 0x603c, 0xeeef },
	{ 0x603d, 0xeef0 },
	{ 0x603e, 0xeef1 },
	{ 0x603f, 0xeef2 },
	{ 0x6040, 0xeef3 },
	{ 0x6041, 0xeef4 },
	{ 0x6042, 0xeef5 },
	{ 0x6043, 0xeef6 },
	{ 0x6044, 0xeef7 },
	{ 0x6045, 0xeef8 },
	{ 0x6046, 0xeef9 },
	{ 0x6047, 0xeefa },
	{ 0x6048, 0xeefb },
	{ 0x6049, 0xeefc },
	{ 0x604a, 0xeefd },
	{ 0x604b, 0xeefe },
	{ 0x604c, 0xef40 },
	{ 0x604d, 0xef41 },
	{ 0x604e, 0xef42 },
	{ 0x604f, 0xef43 },
	{ 0x6050, 0xef44 },
	{ 0x6051, 0xef45 },
	{ 0x6052, 0xef46 },
	{ 0x6053, 0xef47 },
	{ 0x6054, 0xef48 },
	{ 0x6055, 0xef49 },
	{ 0x6056, 0xef4a },
	{ 0x6057, 0xef4b },
	{ 0x6058, 0xef4c },
	{ 0x6059, 0xef4d },
	{ 0x605a, 0xef4e },
	{ 0x605b, 0xef4f },
	{ 0x605c, 0xef50 },
	{ 0x605d, 0xef51 },
	{ 0x605e, 0xef52 },
	{ 0x605f, 0xef53 },
	{ 0x6060, 0xef54 },
	{ 0x6061, 0xef55 },
	{ 0x6062, 0xef56 },
	{ 0x6063, 0xef57 },
	{ 0x6064, 0xef58 },
	{ 0x6065, 0xef59 },
	{ 0x6066, 0xef5a },
	{ 0x6067, 0xef5b },
	{ 0x6068, 0xef5c },
	{ 0x6069, 0xef5d },
	{ 0x606a, 0xef5e },
	{ 0x606b, 0xef5f },
	{ 0x606c, 0xef60 },
	{ 0x606d, 0xef61 },
	{ 0x606e, 0xef62 },
	{ 0x606f, 0xef63 },
	{ 0x6070, 0xef64 },
	{ 0x6071, 0xef65 },
	{ 0x6072, 0xef66 },
	{ 0x6073, 0xef67 },
	{ 0x6074, 0xef68 },
	{ 0x6075, 0xef69 },
	{ 0x6076, 0xef6a },
	{ 0x6077, 0xef6b },
	{ 0x6078, 0xef6c },
	{ 0x6079, 0xef6d },
	{ 0x607a, 0xef6e },
	{ 0x607b, 0xef6f },
	{ 0x607c, 0xef70 },
	{ 0x607d, 0xef71 },
	{ 0x607e, 0xef72 },
	{ 0x6121, 0xef73 },
	{ 0x6122, 0xef74 },
	{ 0x6123, 0xef75 },
	{ 0x6124, 0xef76 },
	{ 0x6125, 0xef77 },
	{ 0x6126, 0xef78 },
	{ 0x6127, 0xef79 },
	{ 0x6128, 0xef7a },
	{ 0x6129, 0xef7b },
	{ 0x612a, 0xef7c },
	{ 0x612b, 0xef7d },
	{ 0x612c, 0xef7e },
	{ 0x612d, 0xefa1 },
	{ 0x612e, 0xefa2 },
	{ 0x612f, 0xefa3 },
	{ 0x6130, 0xefa4 },
	{ 0x6131, 0xefa5 },
	{ 0x6132, 0xefa6 },
	{ 0x6133, 0xefa7 },
	{ 0x6134, 0xefa8 },
	{ 0x6135, 0xefa9 },
	{ 0x6136, 0xefaa },
	{ 0x6137, 0xefab },
	{ 0x6138, 0xefac },
	{ 0x6139, 0xefad },
	{ 0x613a, 0xefae },
	{ 0x613b, 0xefaf },
	{ 0x613c, 0xefb0 },
	{ 0x613d, 0xefb1 },
	{ 0x613e, 0xefb2 },
	{ 0x613f, 0xefb3 },
	{ 0x6140, 0xefb4 },
	{ 0x6141, 0xefb5 },
	{ 0x6142, 0xefb6 },
	{ 0x6143, 0xefb7 },
	{ 0x6144, 0xefb8 },
	{ 0x6145, 0xefb9 },
	{ 0x6146, 0xefba },
	{ 0x6147, 0xefbb },
	{ 0x6148, 0xefbc },
	{ 0x6149, 0xefbd },
	{ 0x614a, 0xefbe },
	{ 0x614b, 0xefbf },
	{ 0x614c, 0xefc0 },
	{ 0x614d, 0xefc1 },
	{ 0x614e, 0xefc2 },
	{ 0x614f, 0xefc3 },
	{ 0x6150, 0xefc4 },
	{ 0x6151, 0xefc5 },
	{ 0x6152, 0xefc6 },
	{ 0x6153, 0xefc7 },
	{ 0x6154, 0xefc8 },
	{ 0x6155, 0xefc9 },
	{ 0x6156, 0xefca },
	{ 0x6157, 0xefcb },
	{ 0x6158, 0xefcc },
	{ 0x6159, 0xefcd },
	{ 0x615a, 0xefce },
	{ 0x615b, 0xefcf },
	{ 0x615c, 0xefd0 },
	{ 0x615d, 0xefd1 },
	{ 0x615e, 0xefd2 },
	{ 0x615f, 0xefd3 },
	{ 0x6160, 0xefd4 },
	{ 0x6161, 0xefd5 },
	{ 0x6162, 0xefd6 },
	{ 0x6163, 0xefd7 },
	{ 0x6164, 0xefd8 },
	{ 0x6165, 0xefd9 },
	{ 0x6166, 0xefda },
	{ 0x6167, 0xefdb },
	{ 0x6168, 0xefdc },
	{ 0x6169, 0xefdd },
	{ 0x616a, 0xefde },
	{ 0x616b, 0xefdf },
	{ 0x616c, 0xefe0 },
	{ 0x616d, 0xefe1 },
	{ 0x616e, 0xefe2 },
	{ 0x616f, 0xefe3 },
	{ 0x6170, 0xefe4 },
	{ 0x6171, 0xefe5 },
	{ 0x6172, 0xefe6 },
	{ 0x6173, 0xefe7 },
	{ 0x6174, 0xefe8 },
	{ 0x6175, 0xefe9 },
	{ 0x6176, 0xefea },
	{ 0x6177, 0xefeb },
	{ 0x6178, 0xefec },
	{ 0x6179, 0xefed },
	{ 0x617a, 0xefee },
	{ 0x617b, 0xefef },
	{ 0x617c, 0xeff0 },
	{ 0x617d, 0xeff1 },
	{ 0x617e, 0xeff2 },
	{ 0x6221, 0xeff3 },
	{ 0x6222, 0xeff4 },
	{ 0x6223, 0xeff5 },
	{ 0x6224, 0xeff6 },
	{ 0x6225, 0xeff7 },
	{ 0x6226, 0xeff8 },
	{ 0x6227, 0xeff9 },
	{ 0x6228, 0xeffa },
	{ 0x6229, 0xeffb },
	{ 0x622a, 0xeffc },
	{ 0x622b, 0xeffd },
	{ 0x622c, 0xeffe },
	{ 0x622d, 0xf040 },
	{ 0x622e, 0xf041 },
	{ 0x622f, 0xf042 },
	{ 0x6230, 0xf043 },
	{ 0x6231, 0xf044 },
	{ 0x6232, 0xf045 },
	{ 0x6233, 0xf046 },
	{ 0x6234, 0xf047 },
	{ 0x6235, 0xf048 },
	{ 0x6236, 0xf049 },
	{ 0x6237, 0xf04a },
	{ 0x6238, 0xf04b },
	{ 0x6239, 0xf04c },
	{ 0x623a, 0xf04d },
	{ 0x623b, 0xf04e },
	{ 0x623c, 0xf04f },
	{ 0x623d, 0xf050 },
	{ 0x623e, 0xf051 },
	{ 0x623f, 0xf052 },
	{ 0x6240, 0xf053 },
	{ 0x6241, 0xf054 },
	{ 0x6242, 0xf055 },
	{ 0x6243, 0xf057 },
	{ 0x6244, 0xf058 },
	{ 0x6245, 0xf059 },
	{ 0x6246, 0xf05a },
	{ 0x6247, 0xf05b },
	{ 0x6248, 0xf05c },
	{ 0x6249, 0xf05d },
	{ 0x624a, 0xf05e },
	{ 0x624b, 0xf05f },
	{ 0x624c, 0xf060 },
	{ 0x624d, 0xf061 },
	{ 0x624e, 0xf062 },
	{ 0x624f, 0xf063 },
	{ 0x6250, 0xf064 },
	{ 0x6251, 0xf065 },
	{ 0x6252, 0xf066 },
	{ 0x6253, 0xf067 },
	{ 0x6254, 0xf068 },
	{ 0x6255, 0xf069 },
	{ 0x6256, 0xf06a },
	{ 0x6257, 0xf06b },
	{ 0x6258, 0xf06c },
	{ 0x6259, 0xf06d },
	{ 0x625a, 0xf06e },
	{ 0x625b, 0xf06f },
	{ 0x625c, 0xf070 },
	{ 0x625d, 0xf071 },
	{ 0x625e, 0xf072 },
	{ 0x625f, 0xf073 },
	{ 0x6260, 0xf074 },
	{ 0x6261, 0xf075 },
	{ 0x6262, 0xf076 },
	{ 0x6263, 0xf077 },
	{ 0x6264, 0xf078 },
	{ 0x6265, 0xf079 },
	{ 0x6266, 0xf07a },
	{ 0x6267, 0xf07b },
	{ 0x6268, 0xf07c },
	{ 0x6269, 0xf07d },
	{ 0x626a, 0xf07e },
	{ 0x626b, 0xf0a1 },
	{ 0x626c, 0xf0a2 },
	{ 0x626d, 0xf0a3 },
	{ 0x626e, 0xf0a4 },
	{ 0x626f, 0xf0a5 },
	{ 0x6270, 0xf0a6 },
	{ 0x6271, 0xf0a7 },
	{ 0x6272, 0xf0a8 },
	{ 0x6273, 0xf0a9 },
	{ 0x6274, 0xf0aa },
	{ 0x6275, 0xf0ab },
	{ 0x6276, 0xf0ac },
	{ 0x6277, 0xf0ad },
	{ 0x6278, 0xf0ae },
	{ 0x6279, 0xf0af },
	{ 0x627a, 0xf0b0 },
	{ 0x627b, 0xf0b1 },
	{ 0x627c, 0xf0b2 },
	{ 0x627d, 0xf0b3 },
	{ 0x627e, 0xf0b4 },
	{ 0x6321, 0xf0b5 },
	{ 0x6322, 0xf0b6 },
	{ 0x6323, 0xf0b7 },
	{ 0x6324, 0xf0b8 },
	{ 0x6325, 0xf0b9 },
	{ 0x6326, 0xf0ba },
	{ 0x6327, 0xf0bb },
	{ 0x6328, 0xf0bc },
	{ 0x6329, 0xf0bd },
	{ 0x632a, 0xf0be },
	{ 0x632b, 0xf0bf },
	{ 0x632c, 0xf0c0 },
	{ 0x632d, 0xf0c1 },
	{ 0x632e, 0xf0c2 },
	{ 0x632f, 0xf0c3 },
	{ 0x6330, 0xf0c4 },
	{ 0x6331, 0xf0c5 },
	{ 0x6332, 0xf0c6 },
	{ 0x6333, 0xf0c7 },
	{ 0x6334, 0xf0c8 },
	{ 0x6335, 0xf0c9 },
	{ 0x6336, 0xf0ca },
	{ 0x6337, 0xf0cc },
	{ 0x6338, 0xf0cd },
	{ 0x6339, 0xf0ce },
	{ 0x633a, 0xf0cf },
	{ 0x633b, 0xf0d0 },
	{ 0x633c, 0xf0d1 },
	{ 0x633d, 0xf0d2 },
	{ 0x633e, 0xf0d3 },
	{ 0x633f, 0xf0d4 },
	{ 0x6340, 0xf0d5 },
	{ 0x6341, 0xf0d6 },
	{ 0x6342, 0xf0d7 },
	{ 0x6343, 0xf0d8 },
	{ 0x6344, 0xf0d9 },
	{ 0x6345, 0xf0da },
	{ 0x6346, 0xf0db },
	{ 0x6347, 0xf0dc },
	{ 0x6348, 0xf0dd },
	{ 0x6349, 0xf0de },
	{ 0x634a, 0xf0df },
	{ 0x634b, 0xf0e0 },
	{ 0x634c, 0xf0e1 },
	{ 0x634d, 0xf0e2 },
	{ 0x634e, 0xf0e3 },
	{ 0x634f, 0xf0e4 },
	{ 0x6350, 0xf0e5 },
	{ 0x6351, 0xf0e6 },
	{ 0x6352, 0xf0e7 },
	{ 0x6353, 0xf0e8 },
	{ 0x6354, 0xf0e9 },
	{ 0x6355, 0xf0ea },
	{ 0x6356, 0xf0eb },
	{ 0x6357, 0xf0ec },
	{ 0x6358, 0xf0ed },
	{ 0x6359, 0xf0ee },
	{ 0x635a, 0xf0ef },
	{ 0x635b, 0xf0f0 },
	{ 0x635c, 0xf0f1 },
	{ 0x635d, 0xf0f2 },
	{ 0x635e, 0xf0f3 },
	{ 0x635f, 0xf0f4 },
	{ 0x6360, 0xf0f5 },
	{ 0x6361, 0xf0f6 },
	{ 0x6362, 0xf0f7 },
	{ 0x6363, 0xf0f8 },
	{ 0x6364, 0xf0f9 },
	{ 0x6365, 0xf0fa },
	{ 0x6366, 0xf0fb },
	{ 0x6367, 0xf0fc },
	{ 0x6368, 0xf0fd },
	{ 0x6369, 0xf0fe },
	{ 0x636a, 0xf140 },
	{ 0x636b, 0xf141 },
	{ 0x636c, 0xf142 },
	{ 0x636d, 0xf143 },
	{ 0x636e, 0xf144 },
	{ 0x636f, 0xf145 },
	{ 0x6370, 0xf146 },
	{ 0x6371, 0xf147 },
	{ 0x6372, 0xf148 },
	{ 0x6373, 0xf149 },
	{ 0x6374, 0xf14a },
	{ 0x6375, 0xf14b },
	{ 0x6376, 0xf14c },
	{ 0x6377, 0xf14d },
	{ 0x6378, 0xf14e },
	{ 0x6379, 0xf14f },
	{ 0x637a, 0xf150 },
	{ 0x637b, 0xf151 },
	{ 0x637c, 0xf152 },
	{ 0x637d, 0xf153 },
	{ 0x637e, 0xf154 },
	{ 0x6421, 0xf155 },
	{ 0x6422, 0xf156 },
	{ 0x6423, 0xf157 },
	{ 0x6424, 0xf158 },
	{ 0x6425, 0xf159 },
	{ 0x6426, 0xf15a },
	{ 0x6427, 0xf15b },
	{ 0x6428, 0xf15c },
	{ 0x6429, 0xf15d },
	{ 0x642a, 0xf15e },
	{ 0x642b, 0xf15f },
	{ 0x642c, 0xf160 },
	{ 0x642d, 0xf161 },
	{ 0x642e, 0xf162 },
	{ 0x642f, 0xeeeb },
	{ 0x6430, 0xf163 },
	{ 0x6431, 0xf164 },
	{ 0x6432, 0xf165 },
	{ 0x6433, 0xf166 },
	{ 0x6434, 0xf167 },
	{ 0x6435, 0xf168 },
	{ 0x6436, 0xf169 },
	{ 0x6437, 0xf16a },
	{ 0x6438, 0xf16c },
	{ 0x6439, 0xf16d },
	{ 0x643a, 0xf16e },
	{ 0x643b, 0xf16f },
	{ 0x643c, 0xf170 },
	{ 0x643d, 0xf171 },
	{ 0x643e, 0xf172 },
	{ 0x643f, 0xf173 },
	{ 0x6440, 0xf174 },
	{ 0x6441, 0xf175 },
	{ 0x6442, 0xf176 },
	{ 0x6443, 0xf177 },
	{ 0x6444, 0xf178 },
	{ 0x6445, 0xf179 },
	{ 0x6446, 0xf17a },
	{ 0x6447, 0xf17b },
	{ 0x6448, 0xf17c },
	{ 0x6449, 0xf17d },
	{ 0x644a, 0xf17e },
	{ 0x644b, 0xf1a1 },
	{ 0x644c, 0xf1a2 },
	{ 0x644d, 0xf1a3 },
	{ 0x644e, 0xf1a4 },
	{ 0x644f, 0xf1a5 },
	{ 0x6450, 0xf1a6 },
	{ 0x6451, 0xf1a7 },
	{ 0x6452, 0xf1a8 },
	{ 0x6453, 0xf1a9 },
	{ 0x6454, 0xf1aa },
	{ 0x6455, 0xf1ab },
	{ 0x6456, 0xf1ac },
	{ 0x6457, 0xf1ad },
	{ 0x6458, 0xf1ae },
	{ 0x6459, 0xf1af },
	{ 0x645a, 0xf1b0 },
	{ 0x645b, 0xf1b1 },
	{ 0x645c, 0xf1b2 },
	{ 0x645d, 0xf1b3 },
	{ 0x645e, 0xf1b4 },
	{ 0x645f, 0xf1b5 },
	{ 0x6460, 0xf1b6 },
	{ 0x6461, 0xf1b7 },
	{ 0x6462, 0xf1b8 },
	{ 0x6463, 0xf1b9 },
	{ 0x6464, 0xf1ba },
	{ 0x6465, 0xf1bb },
	{ 0x6466, 0xf1bc },
	{ 0x6467, 0xf1bd },
	{ 0x6468, 0xf1be },
	{ 0x6469, 0xf1bf },
	{ 0x646a, 0xf1c0 },
	{ 0x646b, 0xf1c1 },
	{ 0x646c, 0xf1c2 },
	{ 0x646d, 0xf1c3 },
	{ 0x646e, 0xf1c4 },
	{ 0x646f, 0xf1c5 },
	{ 0x6470, 0xf1c6 },
	{ 0x6471, 0xf1c7 },
	{ 0x6472, 0xf1c8 },
	{ 0x6473, 0xf1c9 },
	{ 0x6474, 0xf1ca },
	{ 0x6475, 0xf1cb },
	{ 0x6476, 0xf1cc },
	{ 0x6477, 0xf1cd },
	{ 0x6478, 0xf1ce },
	{ 0x6479, 0xf1cf },
	{ 0x647a, 0xf1d0 },
	{ 0x647b, 0xf1d1 },
	{ 0x647c, 0xf1d2 },
	{ 0x647d, 0xf1d3 },
	{ 0x647e, 0xf1d4 },
	{ 0x6521, 0xf1d5 },
	{ 0x6522, 0xf1d6 },
	{ 0x6523, 0xf1d7 },
	{ 0x6524, 0xf1d8 },
	{ 0x6525, 0xf1d9 },
	{ 0x6526, 0xf1da },
	{ 0x6527, 0xf1db },
	{ 0x6528, 0xf1dc },
	{ 0x6529, 0xf1dd },
	{ 0x652a, 0xf1de },
	{ 0x652b, 0xf1df },
	{ 0x652c, 0xf1e0 },
	{ 0x652d, 0xf1e1 },
	{ 0x652e, 0xf1e2 },
	{ 0x652f, 0xf1e3 },
	{ 0x6530, 0xf1e4 },
	{ 0x6531, 0xf1e5 },
	{ 0x6532, 0xf1e6 },
	{ 0x6533, 0xf1e7 },
	{ 0x6534, 0xf1e8 },
	{ 0x6535, 0xf1e9 },
	{ 0x6536, 0xf1ea },
	{ 0x6537, 0xf1eb },
	{ 0x6538, 0xf1ec },
	{ 0x6539, 0xf1ed },
	{ 0x653a, 0xf1ee },
	{ 0x653b, 0xf1ef },
	{ 0x653c, 0xf1f0 },
	{ 0x653d, 0xf1f1 },
	{ 0x653e, 0xf1f2 },
	{ 0x653f, 0xf1f3 },
	{ 0x6540, 0xf1f4 },
	{ 0x6541, 0xf1f5 },
	{ 0x6542, 0xf1f6 },
	{ 0x6543, 0xf1f7 },
	{ 0x6544, 0xf1f8 },
	{ 0x6545, 0xf1f9 },
	{ 0x6546, 0xf1fa },
	{ 0x6547, 0xf1fb },
	{ 0x6548, 0xf1fc },
	{ 0x6549, 0xf1fd },
	{ 0x654a, 0xf1fe },
	{ 0x654b, 0xf240 },
	{ 0x654c, 0xf241 },
	{ 0x654d, 0xf242 },
	{ 0x654e, 0xf243 },
	{ 0x654f, 0xf244 },
	{ 0x6550, 0xf245 },
	{ 0x6551, 0xf246 },
	{ 0x6552, 0xf247 },
	{ 0x6553, 0xf248 },
	{ 0x6554, 0xf249 },
	{ 0x6555, 0xf24a },
	{ 0x6556, 0xf24b },
	{ 0x6557, 0xf24c },
	{ 0x6558, 0xf24d },
	{ 0x6559, 0xf24e },
	{ 0x655a, 0xf24f },
	{ 0x655b, 0xf250 },
	{ 0x655c, 0xf251 },
	{ 0x655d, 0xf252 },
	{ 0x655e, 0xf253 },
	{ 0x655f, 0xf254 },
	{ 0x6560, 0xf255 },
	{ 0x6561, 0xf256 },
	{ 0x6562, 0xf257 },
	{ 0x6563, 0xf258 },
	{ 0x6564, 0xf259 },
	{ 0x6565, 0xf25a },
	{ 0x6566, 0xf25b },
	{ 0x6567, 0xf25c },
	{ 0x6568, 0xf25d },
	{ 0x6569, 0xf25e },
	{ 0x656a, 0xf25f },
	{ 0x656b, 0xf260 },
	{ 0x656c, 0xf261 },
	{ 0x656d, 0xf262 },
	{ 0x656e, 0xf263 },
	{ 0x656f, 0xf264 },
	{ 0x6570, 0xf265 },
	{ 0x6571, 0xf266 },
	{ 0x6572, 0xf267 },
	{ 0x6573, 0xf269 },
	{ 0x6574, 0xf26a },
	{ 0x6575, 0xf26b },
	{ 0x6576, 0xf26c },
	{ 0x6577, 0xf26d },
	{ 0x6578, 0xf26e },
	{ 0x6579, 0xf26f },
	{ 0x657a, 0xf270 },
	{ 0x657b, 0xf271 },
	{ 0x657c, 0xf272 },
	{ 0x657d, 0xf273 },
	{ 0x657e, 0xf274 },
	{ 0x6621, 0xf275 },
	{ 0x6622, 0xf276 },
	{ 0x6623, 0xf277 },
	{ 0x6624, 0xf278 },
	{ 0x6625, 0xf279 },
	{ 0x6626, 0xf27a },
	{ 0x6627, 0xf27b },
	{ 0x6628, 0xf27c },
	{ 0x6629, 0xf27d },
	{ 0x662a, 0xf27e },
	{ 0x662b, 0xf2a1 },
	{ 0x662c, 0xf2a2 },
	{ 0x662d, 0xf2a3 },
	{ 0x662e, 0xf2a4 },
	{ 0x662f, 0xf2a5 },
	{ 0x6630, 0xf2a6 },
	{ 0x6631, 0xf2a7 },
	{ 0x6632, 0xf2a8 },
	{ 0x6633, 0xf2a9 },
	{ 0x6634, 0xf2aa },
	{ 0x6635, 0xf2ab },
	{ 0x6636, 0xf2ac },
	{ 0x6637, 0xf2ad },
	{ 0x6638, 0xf2ae },
	{ 0x6639, 0xf2af },
	{ 0x663a, 0xf2b0 },
	{ 0x663b, 0xf2b1 },
	{ 0x663c, 0xf2b2 },
	{ 0x663d, 0xf2b3 },
	{ 0x663e, 0xf2b4 },
	{ 0x663f, 0xf2b5 },
	{ 0x6640, 0xf2b6 },
	{ 0x6641, 0xf2b7 },
	{ 0x6642, 0xf2b8 },
	{ 0x6643, 0xf2b9 },
	{ 0x6644, 0xf2ba },
	{ 0x6645, 0xf2bb },
	{ 0x6646, 0xf2bc },
	{ 0x6647, 0xf2bd },
	{ 0x6648, 0xf2be },
	{ 0x6649, 0xf2bf },
	{ 0x664a, 0xf2c0 },
	{ 0x664b, 0xf2c1 },
	{ 0x664c, 0xf2c2 },
	{ 0x664d, 0xf4b5 },
	{ 0x664e, 0xf2c3 },
	{ 0x664f, 0xf2c4 },
	{ 0x6650, 0xf2c5 },
	{ 0x6651, 0xf2c6 },
	{ 0x6652, 0xf2c7 },
	{ 0x6653, 0xf2c8 },
	{ 0x6654, 0xf2c9 },
	{ 0x6655, 0xf2ca },
	{ 0x6656, 0xf2cb },
	{ 0x6657, 0xf2cc },
	{ 0x6658, 0xf2cd },
	{ 0x6659, 0xf2ce },
	{ 0x665a, 0xf2cf },
	{ 0x665b, 0xf2d0 },
	{ 0x665c, 0xf2d1 },
	{ 0x665d, 0xf2d2 },
	{ 0x665e, 0xf2d3 },
	{ 0x665f, 0xf2d4 },
	{ 0x6660, 0xf2d5 },
	{ 0x6661, 0xf2d6 },
	{ 0x6662, 0xf2d7 },
	{ 0x6663, 0xf2d8 },
	{ 0x6664, 0xf2d9 },
	{ 0x6665, 0xf2da },
	{ 0x6666, 0xf2db },
	{ 0x6667, 0xf2dc },
	{ 0x6668, 0xf2dd },
	{ 0x6669, 0xf2de },
	{ 0x666a, 0xf2df },
	{ 0x666b, 0xf2e0 },
	{ 0x666c, 0xf2e1 },
	{ 0x666d, 0xf2e2 },
	{ 0x666e, 0xf2e3 },
	{ 0x666f, 0xf2e4 },
	{ 0x6670, 0xf2e5 },
	{ 0x6671, 0xf2e6 },
	{ 0x6672, 0xf2e7 },
	{ 0x6673, 0xf2e8 },
	{ 0x6674, 0xf2e9 },
	{ 0x6675, 0xf2ea },
	{ 0x6676, 0xf2eb },
	{ 0x6677, 0xf2ec },
	{ 0x6678, 0xf2ed },
	{ 0x6679, 0xf2ee },
	{ 0x667a, 0xf2ef },
	{ 0x667b, 0xf2f0 },
	{ 0x667c, 0xf2f1 },
	{ 0x667d, 0xf2f2 },
	{ 0x667e, 0xf2f3 },
	{ 0x6721, 0xf2f4 },
	{ 0x6722, 0xf2f5 },
	{ 0x6723, 0xf2f6 },
	{ 0x6724, 0xf2f7 },
	{ 0x6725, 0xf2f8 },
	{ 0x6726, 0xf2f9 },
	{ 0x6727, 0xf2fa },
	{ 0x6728, 0xf2fb },
	{ 0x6729, 0xf2fc },
	{ 0x672a, 0xf2fd },
	{ 0x672b, 0xf2fe },
	{ 0x672c, 0xf340 },
	{ 0x672d, 0xf341 },
	{ 0x672e, 0xf342 },
	{ 0x672f, 0xf343 },
	{ 0x6730, 0xf344 },
	{ 0x6731, 0xf345 },
	{ 0x6732, 0xf346 },
	{ 0x6733, 0xf347 },
	{ 0x6734, 0xf348 },
	{ 0x6735, 0xf349 },
	{ 0x6736, 0xf34a },
	{ 0x6737, 0xf34b },
	{ 0x6738, 0xf34c },
	{ 0x6739, 0xf34d },
	{ 0x673a, 0xf34e },
	{ 0x673b, 0xf34f },
	{ 0x673c, 0xf350 },
	{ 0x673d, 0xf351 },
	{ 0x673e, 0xf352 },
	{ 0x673f, 0xf353 },
	{ 0x6740, 0xf354 },
	{ 0x6741, 0xf355 },
	{ 0x6742, 0xf356 },
	{ 0x6743, 0xf357 },
	{ 0x6744, 0xf358 },
	{ 0x6745, 0xf359 },
	{ 0x6746, 0xf35a },
	{ 0x6747, 0xf35b },
	{ 0x6748, 0xf35c },
	{ 0x6749, 0xf35d },
	{ 0x674a, 0xf35e },
	{ 0x674b, 0xf35f },
	{ 0x674c, 0xf360 },
	{ 0x674d, 0xf361 },
	{ 0x674e, 0xf362 },
	{ 0x674f, 0xf363 },
	{ 0x6750, 0xf364 },
	{ 0x6751, 0xf365 },
	{ 0x6752, 0xf366 },
	{ 0x6753, 0xf367 },
	{ 0x6754, 0xf368 },
	{ 0x6755, 0xf369 },
	{ 0x6756, 0xf36a },
	{ 0x6757, 0xf36b },
	{ 0x6758, 0xf36c },
	{ 0x6759, 0xf36d },
	{ 0x675a, 0xf36e },
	{ 0x675b, 0xf36f },
	{ 0x675c, 0xf370 },
	{ 0x675d, 0xf371 },
	{ 0x675e, 0xf372 },
	{ 0x675f, 0xf373 },
	{ 0x6760, 0xf374 },
	{ 0x6761, 0xf16b },
	{ 0x6762, 0xf375 },
	{ 0x6763, 0xf376 },
	{ 0x6764, 0xf377 },
	{ 0x6765, 0xf378 },
	{ 0x6766, 0xf379 },
	{ 0x6767, 0xf37a },
	{ 0x6768, 0xf37b },
	{ 0x6769, 0xf37c },
	{ 0x676a, 0xf37d },
	{ 0x676b, 0xf37e },
	{ 0x676c, 0xf3a1 },
	{ 0x676d, 0xf3a2 },
	{ 0x676e, 0xf3a3 },
	{ 0x676f, 0xf3a4 },
	{ 0x6770, 0xf3a5 },
	{ 0x6771, 0xf3a6 },
	{ 0x6772, 0xf3a7 },
	{ 0x6773, 0xf3a8 },
	{ 0x6774, 0xf3a9 },
	{ 0x6775, 0xf3aa },
	{ 0x6776, 0xf3ab },
	{ 0x6777, 0xf3ac },
	{ 0x6778, 0xf3ad },
	{ 0x6779, 0xf3ae },
	{ 0x677a, 0xf3af },
	{ 0x677b, 0xf3b0 },
	{ 0x677c, 0xf3b1 },
	{ 0x677d, 0xf3b2 },
	{ 0x677e, 0xf3b3 },
	{ 0x6821, 0xf3b4 },
	{ 0x6822, 0xf3b5 },
	{ 0x6823, 0xf3b6 },
	{ 0x6824, 0xf3b7 },
	{ 0x6825, 0xf3b8 },
	{ 0x6826, 0xf3b9 },
	{ 0x6827, 0xf3ba },
	{ 0x6828, 0xf3bb },
	{ 0x6829, 0xf3bc },
	{ 0x682a, 0xf3bd },
	{ 0x682b, 0xf3be },
	{ 0x682c, 0xf3bf },
	{ 0x682d, 0xf3c0 },
	{ 0x682e, 0xf3c1 },
	{ 0x682f, 0xf3c2 },
	{ 0x6830, 0xf3c3 },
	{ 0x6831, 0xf3c4 },
	{ 0x6832, 0xf3c5 },
	{ 0x6833, 0xf3c6 },
	{ 0x6834, 0xf3c7 },
	{ 0x6835, 0xf3c8 },
	{ 0x6836, 0xf3c9 },
	{ 0x6837, 0xf3ca },
	{ 0x6838, 0xf3cb },
	{ 0x6839, 0xf3cc },
	{ 0x683a, 0xf3cd },
	{ 0x683b, 0xf3ce },
	{ 0x683c, 0xf3cf },
	{ 0x683d, 0xf3d0 },
	{ 0x683e, 0xf3d1 },
	{ 0x683f, 0xf3d2 },
	{ 0x6840, 0xf3d3 },
	{ 0x6841, 0xf3d4 },
	{ 0x6842, 0xf3d5 },
	{ 0x6843, 0xf3d6 },
	{ 0x6844, 0xf3d7 },
	{ 0x6845, 0xf3d8 },
	{ 0x6846, 0xf3d9 },
	{ 0x6847, 0xf3da },
	{ 0x6848, 0xf3db },
	{ 0x6849, 0xf3dc },
	{ 0x684a, 0xf3dd },
	{ 0x684b, 0xf3de },
	{ 0x684c, 0xf3df },
	{ 0x684d, 0xf3e0 },
	{ 0x684e, 0xf3e1 },
	{ 0x684f, 0xf3e2 },
	{ 0x6850, 0xf3e3 },
	{ 0x6851, 0xf3e4 },
	{ 0x6852, 0xf3e5 },
	{ 0x6853, 0xf3e6 },
	{ 0x6854, 0xf3e7 },
	{ 0x6855, 0xf3e8 },
	{ 0x6856, 0xf3e9 },
	{ 0x6857, 0xf3ea },
	{ 0x6858, 0xf3eb },
	{ 0x6859, 0xf3ec },
	{ 0x685a, 0xf3ed },
	{ 0x685b, 0xf3ee },
	{ 0x685c, 0xf3ef },
	{ 0x685d, 0xf3f0 },
	{ 0x685e, 0xf3f1 },
	{ 0x685f, 0xf3f2 },
	{ 0x6860, 0xf3f3 },
	{ 0x6861, 0xf3f4 },
	{ 0x6862, 0xf3f5 },
	{ 0x6863, 0xf3f6 },
	{ 0x6864, 0xf3f7 },
	{ 0x6865, 0xf3f8 },
	{ 0x6866, 0xf3f9 },
	{ 0x6867, 0xf3fa },
	{ 0x6868, 0xf3fb },
	{ 0x6869, 0xf3fc },
	{ 0x686a, 0xf3fd },
	{ 0x686b, 0xf3fe },
	{ 0x686c, 0xf440 },
	{ 0x686d, 0xf441 },
	{ 0x686e, 0xf442 },
	{ 0x686f, 0xf443 },
	{ 0x6870, 0xf444 },
	{ 0x6871, 0xf445 },
	{ 0x6872, 0xf446 },
	{ 0x6873, 0xf447 },
	{ 0x6874, 0xf448 },
	{ 0x6875, 0xf449 },
	{ 0x6876, 0xf44a },
	{ 0x6877, 0xf44b },
	{ 0x6878, 0xf44c },
	{ 0x6879, 0xf44d },
	{ 0x687a, 0xf44e },
	{ 0x687b, 0xf44f },
	{ 0x687c, 0xf450 },
	{ 0x687d, 0xf451 },
	{ 0x687e, 0xf452 },
	{ 0x6921, 0xf453 },
	{ 0x6922, 0xf454 },
	{ 0x6923, 0xf455 },
	{ 0x6924, 0xf456 },
	{ 0x6925, 0xf457 },
	{ 0x6926, 0xf458 },
	{ 0x6927, 0xf459 },
	{ 0x6928, 0xf45a },
	{ 0x6929, 0xf45b },
	{ 0x692a, 0xf45c },
	{ 0x692b, 0xf45d },
	{ 0x692c, 0xf45e },
	{ 0x692d, 0xf45f },
	{ 0x692e, 0xf460 },
	{ 0x692f, 0xf461 },
	{ 0x6930, 0xf462 },
	{ 0x6931, 0xf463 },
	{ 0x6932, 0xf464 },
	{ 0x6933, 0xf465 },
	{ 0x6934, 0xf268 },
	{ 0x6935, 0xf466 },
	{ 0x6936, 0xf467 },
	{ 0x6937, 0xf468 },
	{ 0x6938, 0xf469 },
	{ 0x6939, 0xf46a },
	{ 0x693a, 0xf46b },
	{ 0x693b, 0xf46c },
	{ 0x693c, 0xf46d },
	{ 0x693d, 0xf46e },
	{ 0x693e, 0xf46f },
	{ 0x693f, 0xf470 },
	{ 0x6940, 0xf471 },
	{ 0x6941, 0xf472 },
	{ 0x6942, 0xf473 },
	{ 0x6943, 0xf474 },
	{ 0x6944, 0xf475 },
	{ 0x6945, 0xf476 },
	{ 0x6946, 0xf477 },
	{ 0x6947, 0xf478 },
	{ 0x6948, 0xf479 },
	{ 0x6949, 0xf47a },
	{ 0x694a, 0xf47b },
	{ 0x694b, 0xf47c },
	{ 0x694c, 0xf47d },
	{ 0x694d, 0xf47e },
	{ 0x694e, 0xf4a1 },
	{ 0x694f, 0xf4a2 },
	{ 0x6950, 0xf4a3 },
	{ 0x6951, 0xf4a4 },
	{ 0x6952, 0xf4a5 },
	{ 0x6953, 0xf4a6 },
	{ 0x6954, 0xf4a7 },
	{ 0x6955, 0xf4a8 },
	{ 0x6956, 0xf4a9 },
	{ 0x6957, 0xf4aa },
	{ 0x6958, 0xf4ab },
	{ 0x6959, 0xf4ac },
	{ 0x695a, 0xf4ad },
	{ 0x695b, 0xf4ae },
	{ 0x695c, 0xf4af },
	{ 0x695d, 0xf4b0 },
	{ 0x695e, 0xf4b1 },
	{ 0x695f, 0xf4b2 },
	{ 0x6960, 0xf4b3 },
	{ 0x6961, 0xf4b4 },
	{ 0x6962, 0xf4b6 },
	{ 0x6963, 0xf4b7 },
	{ 0x6964, 0xf4b8 },
	{ 0x6965, 0xf4b9 },
	{ 0x6966, 0xf4ba },
	{ 0x6967, 0xf4bb },
	{ 0x6968, 0xf4bc },
	{ 0x6969, 0xf4bd },
	{ 0x696a, 0xf4be },
	{ 0x696b, 0xf4bf },
	{ 0x696c, 0xf4c0 },
	{ 0x696d, 0xf4c1 },
	{ 0x696e, 0xf4c2 },
	{ 0x696f, 0xf4c3 },
	{ 0x6970, 0xf4c4 },
	{ 0x6971, 0xf4c5 },
	{ 0x6972, 0xf4c6 },
	{ 0x6973, 0xf4c7 },
	{ 0x6974, 0xf4c8 },
	{ 0x6975, 0xf4c9 },
	{ 0x6976, 0xf4ca },
	{ 0x6977, 0xf4cb },
	{ 0x6978, 0xf4cc },
	{ 0x6979, 0xf4cd },
	{ 0x697a, 0xf4ce },
	{ 0x697b, 0xf4cf },
	{ 0x697c, 0xf4d0 },
	{ 0x697d, 0xf4d1 },
	{ 0x697e, 0xf4d2 },
	{ 0x6a21, 0xf4d3 },
	{ 0x6a22, 0xf4d4 },
	{ 0x6a23, 0xf4d5 },
	{ 0x6a24, 0xf4d6 },
	{ 0x6a25, 0xf4d7 },
	{ 0x6a26, 0xf4d8 },
	{ 0x6a27, 0xf4d9 },
	{ 0x6a28, 0xf4da },
	{ 0x6a29, 0xf4db },
	{ 0x6a2a, 0xf4dc },
	{ 0x6a2b, 0xf4dd },
	{ 0x6a2c, 0xf4de },
	{ 0x6a2d, 0xf4df },
	{ 0x6a2e, 0xf4e0 },
	{ 0x6a2f, 0xf4e1 },
	{ 0x6a30, 0xf4e2 },
	{ 0x6a31, 0xf4e3 },
	{ 0x6a32, 0xf4e4 },
	{ 0x6a33, 0xf4e5 },
	{ 0x6a34, 0xf4e6 },
	{ 0x6a35, 0xf4e7 },
	{ 0x6a36, 0xf4e8 },
	{ 0x6a37, 0xf4e9 },
	{ 0x6a38, 0xf4ea },
	{ 0x6a39, 0xf4eb },
	{ 0x6a3a, 0xf4ec },
	{ 0x6a3b, 0xf4ed },
	{ 0x6a3c, 0xf4ee },
	{ 0x6a3d, 0xf4ef },
	{ 0x6a3e, 0xf4f0 },
	{ 0x6a3f, 0xf4f1 },
	{ 0x6a40, 0xf4f2 },
	{ 0x6a41, 0xf4f3 },
	{ 0x6a42, 0xf4f4 },
	{ 0x6a43, 0xf4f5 },
	{ 0x6a44, 0xf4f6 },
	{ 0x6a45, 0xf4f7 },
	{ 0x6a46, 0xf4f8 },
	{ 0x6a47, 0xf4f9 },
	{ 0x6a48, 0xf4fa },
	{ 0x6a49, 0xf4fb },
	{ 0x6a4a, 0xf4fc },
	{ 0x6a4b, 0xf663 },
	{ 0x6a4c, 0xf4fd },
	{ 0x6a4d, 0xf4fe },
	{ 0x6a4e, 0xf540 },
	{ 0x6a4f, 0xf541 },
	{ 0x6a50, 0xf542 },
	{ 0x6a51, 0xf543 },
	{ 0x6a52, 0xf544 },
	{ 0x6a53, 0xf545 },
	{ 0x6a54, 0xf546 },
	{ 0x6a55, 0xf547 },
	{ 0x6a56, 0xf548 },
	{ 0x6a57, 0xf549 },
	{ 0x6a58, 0xf54a },
	{ 0x6a59, 0xf54b },
	{ 0x6a5a, 0xf54c },
	{ 0x6a5b, 0xf54d },
	{ 0x6a5c, 0xf54e },
	{ 0x6a5d, 0xf54f },
	{ 0x6a5e, 0xf550 },
	{ 0x6a5f, 0xf551 },
	{ 0x6a60, 0xf552 },
	{ 0x6a61, 0xf553 },
	{ 0x6a62, 0xf554 },
	{ 0x6a63, 0xf555 },
	{ 0x6a64, 0xf556 },
	{ 0x6a65, 0xf557 },
	{ 0x6a66, 0xf558 },
	{ 0x6a67, 0xf559 },
	{ 0x6a68, 0xf55a },
	{ 0x6a69, 0xf55b },
	{ 0x6a6a, 0xf55c },
	{ 0x6a6b, 0xf55d },
	{ 0x6a6c, 0xf55e },
	{ 0x6a6d, 0xf55f },
	{ 0x6a6e, 0xf560 },
	{ 0x6a6f, 0xf561 },
	{ 0x6a70, 0xf562 },
	{ 0x6a71, 0xf563 },
	{ 0x6a72, 0xf564 },
	{ 0x6a73, 0xf565 },
	{ 0x6a74, 0xf566 },
	{ 0x6a75, 0xf567 },
	{ 0x6a76, 0xf568 },
	{ 0x6a77, 0xf569 },
	{ 0x6a78, 0xf56a },
	{ 0x6a79, 0xf56b },
	{ 0x6a7a, 0xf56c },
	{ 0x6a7b, 0xf56d },
	{ 0x6a7c, 0xf56e },
	{ 0x6a7d, 0xf56f },
	{ 0x6a7e, 0xf570 },
	{ 0x6b21, 0xf571 },
	{ 0x6b22, 0xf572 },
	{ 0x6b23, 0xf573 },
	{ 0x6b24, 0xf574 },
	{ 0x6b25, 0xf575 },
	{ 0x6b26, 0xf576 },
	{ 0x6b27, 0xf577 },
	{ 0x6b28, 0xf578 },
	{ 0x6b29, 0xf579 },
	{ 0x6b2a, 0xf57a },
	{ 0x6b2b, 0xf57b },
	{ 0x6b2c, 0xf57c },
	{ 0x6b2d, 0xf57d },
	{ 0x6b2e, 0xf57e },
	{ 0x6b2f, 0xf5a1 },
	{ 0x6b30, 0xf5a2 },
	{ 0x6b31, 0xf5a3 },
	{ 0x6b32, 0xf5a4 },
	{ 0x6b33, 0xf5a5 },
	{ 0x6b34, 0xf5a6 },
	{ 0x6b35, 0xf5a7 },
	{ 0x6b36, 0xf5a8 },
	{ 0x6b37, 0xf5a9 },
	{ 0x6b38, 0xf5aa },
	{ 0x6b39, 0xf5ab },
	{ 0x6b3a, 0xf5ac },
	{ 0x6b3b, 0xf5ad },
	{ 0x6b3c, 0xf5ae },
	{ 0x6b3d, 0xf5af },
	{ 0x6b3e, 0xf5b0 },
	{ 0x6b3f, 0xf5b1 },
	{ 0x6b40, 0xf5b2 },
	{ 0x6b41, 0xf5b3 },
	{ 0x6b42, 0xf5b4 },
	{ 0x6b43, 0xf5b5 },
	{ 0x6b44, 0xf5b6 },
	{ 0x6b45, 0xf5b7 },
	{ 0x6b46, 0xf5b8 },
	{ 0x6b47, 0xf5b9 },
	{ 0x6b48, 0xf5ba },
	{ 0x6b49, 0xf5bb },
	{ 0x6b4a, 0xf5bc },
	{ 0x6b4b, 0xf5bd },
	{ 0x6b4c, 0xf5be },
	{ 0x6b4d, 0xf5bf },
	{ 0x6b4e, 0xf5c0 },
	{ 0x6b4f, 0xf5c1 },
	{ 0x6b50, 0xf5c2 },
	{ 0x6b51, 0xf5c3 },
	{ 0x6b52, 0xf5c4 },
	{ 0x6b53, 0xf5c5 },
	{ 0x6b54, 0xf5c6 },
	{ 0x6b55, 0xf5c7 },
	{ 0x6b56, 0xf5c8 },
	{ 0x6b57, 0xf5c9 },
	{ 0x6b58, 0xf5ca },
	{ 0x6b59, 0xf5cb },
	{ 0x6b5a, 0xf5cc },
	{ 0x6b5b, 0xf5cd },
	{ 0x6b5c, 0xf5ce },
	{ 0x6b5d, 0xf5cf },
	{ 0x6b5e, 0xf5d0 },
	{ 0x6b5f, 0xf5d1 },
	{ 0x6b60, 0xf5d2 },
	{ 0x6b61, 0xf5d3 },
	{ 0x6b62, 0xf5d4 },
	{ 0x6b63, 0xf5d5 },
	{ 0x6b64, 0xf5d6 },
	{ 0x6b65, 0xf5d7 },
	{ 0x6b66, 0xf5d8 },
	{ 0x6b67, 0xf5d9 },
	{ 0x6b68, 0xf5da },
	{ 0x6b69, 0xf5db },
	{ 0x6b6a, 0xf5dc },
	{ 0x6b6b, 0xf5dd },
	{ 0x6b6c, 0xf5de },
	{ 0x6b6d, 0xf5df },
	{ 0x6b6e, 0xf5e0 },
	{ 0x6b6f, 0xf5e1 },
	{ 0x6b70, 0xf5e2 },
	{ 0x6b71, 0xf5e3 },
	{ 0x6b72, 0xf5e4 },
	{ 0x6b73, 0xf5e5 },
	{ 0x6b74, 0xf5e6 },
	{ 0x6b75, 0xf5e7 },
	{ 0x6b76, 0xf5e8 },
	{ 0x6b77, 0xf5e9 },
	{ 0x6b78, 0xf5ea },
	{ 0x6b79, 0xf5eb },
	{ 0x6b7a, 0xf5ec },
	{ 0x6b7b, 0xf5ed },
	{ 0x6b7c, 0xf5ee },
	{ 0x6b7d, 0xf5ef },
	{ 0x6b7e, 0xf5f0 },
	{ 0x6c21, 0xf5f1 },
	{ 0x6c22, 0xf5f2 },
	{ 0x6c23, 0xf5f3 },
	{ 0x6c24, 0xf5f4 },
	{ 0x6c25, 0xf5f5 },
	{ 0x6c26, 0xf5f6 },
	{ 0x6c27, 0xf5f7 },
	{ 0x6c28, 0xf5f8 },
	{ 0x6c29, 0xf5f9 },
	{ 0x6c2a, 0xf5fa },
	{ 0x6c2b, 0xf5fb },
	{ 0x6c2c, 0xf5fc },
	{ 0x6c2d, 0xf5fd },
	{ 0x6c2e, 0xf5fe },
	{ 0x6c2f, 0xf640 },
	{ 0x6c30, 0xf641 },
	{ 0x6c31, 0xf642 },
	{ 0x6c32, 0xf643 },
	{ 0x6c33, 0xf644 },
	{ 0x6c34, 0xf645 },
	{ 0x6c35, 0xf646 },
	{ 0x6c36, 0xf647 },
	{ 0x6c37, 0xf648 },
	{ 0x6c38, 0xf649 },
	{ 0x6c39, 0xf64a },
	{ 0x6c3a, 0xf64b },
	{ 0x6c3b, 0xf64c },
	{ 0x6c3c, 0xf64d },
	{ 0x6c3d, 0xf64e },
	{ 0x6c3e, 0xf64f },
	{ 0x6c3f, 0xf650 },
	{ 0x6c40, 0xf651 },
	{ 0x6c41, 0xf652 },
	{ 0x6c42, 0xf653 },
	{ 0x6c43, 0xf654 },
	{ 0x6c44, 0xf655 },
	{ 0x6c45, 0xf656 },
	{ 0x6c46, 0xf657 },
	{ 0x6c47, 0xf658 },
	{ 0x6c48, 0xf659 },
	{ 0x6c49, 0xf65a },
	{ 0x6c4a, 0xf65b },
	{ 0x6c4b, 0xf65c },
	{ 0x6c4c, 0xf65d },
	{ 0x6c4d, 0xf65e },
	{ 0x6c4e, 0xf65f },
	{ 0x6c4f, 0xf660 },
	{ 0x6c50, 0xf661 },
	{ 0x6c51, 0xf662 },
	{ 0x6c52, 0xf664 },
	{ 0x6c53, 0xf665 },
	{ 0x6c54, 0xf666 },
	{ 0x6c55, 0xf667 },
	{ 0x6c56, 0xf668 },
	{ 0x6c57, 0xf669 },
	{ 0x6c58, 0xf66a },
	{ 0x6c59, 0xf66b },
	{ 0x6c5a, 0xf66c },
	{ 0x6c5b, 0xf66d },
	{ 0x6c5c, 0xf66e },
	{ 0x6c5d, 0xf66f },
	{ 0x6c5e, 0xf670 },
	{ 0x6c5f, 0xf671 },
	{ 0x6c60, 0xf672 },
	{ 0x6c61, 0xf673 },
	{ 0x6c62, 0xf674 },
	{ 0x6c63, 0xf675 },
	{ 0x6c64, 0xf676 },
	{ 0x6c65, 0xf677 },
	{ 0x6c66, 0xf678 },
	{ 0x6c67, 0xf679 },
	{ 0x6c68, 0xf67a },
	{ 0x6c69, 0xf67b },
	{ 0x6c6a, 0xf67c },
	{ 0x6c6b, 0xf67d },
	{ 0x6c6c, 0xf67e },
	{ 0x6c6d, 0xf6a1 },
	{ 0x6c6e, 0xf6a2 },
	{ 0x6c6f, 0xf6a3 },
	{ 0x6c70, 0xf6a4 },
	{ 0x6c71, 0xf6a5 },
	{ 0x6c72, 0xf6a6 },
	{ 0x6c73, 0xf6a7 },
	{ 0x6c74, 0xf6a8 },
	{ 0x6c75, 0xf6a9 },
	{ 0x6c76, 0xf6aa },
	{ 0x6c77, 0xf6ab },
	{ 0x6c78, 0xf6ac },
	{ 0x6c79, 0xf6ad },
	{ 0x6c7a, 0xf6ae },
	{ 0x6c7b, 0xf6af },
	{ 0x6c7c, 0xf6b0 },
	{ 0x6c7d, 0xf6b1 },
	{ 0x6c7e, 0xf6b2 },
	{ 0x6d21, 0xf6b3 },
	{ 0x6d22, 0xf6b4 },
	{ 0x6d23, 0xf6b5 },
	{ 0x6d24, 0xf6b6 },
	{ 0x6d25, 0xf6b7 },
	{ 0x6d26, 0xf6b8 },
	{ 0x6d27, 0xf6b9 },
	{ 0x6d28, 0xf6ba },
	{ 0x6d29, 0xf6bb },
	{ 0x6d2a, 0xf6bc },
	{ 0x6d2b, 0xf6bd },
	{ 0x6d2c, 0xf6be },
	{ 0x6d2d, 0xf6bf },
	{ 0x6d2e, 0xf6c0 },
	{ 0x6d2f, 0xf6c1 },
	{ 0x6d30, 0xf6c2 },
	{ 0x6d31, 0xf6c3 },
	{ 0x6d32, 0xf6c4 },
	{ 0x6d33, 0xf6c5 },
	{ 0x6d34, 0xf6c6 },
	{ 0x6d35, 0xf6c7 },
	{ 0x6d36, 0xf6c8 },
	{ 0x6d37, 0xf6c9 },
	{ 0x6d38, 0xf6ca },
	{ 0x6d39, 0xf6cb },
	{ 0x6d3a, 0xf6cc },
	{ 0x6d3b, 0xf6cd },
	{ 0x6d3c, 0xf6ce },
	{ 0x6d3d, 0xf6cf },
	{ 0x6d3e, 0xf6d0 },
	{ 0x6d3f, 0xf6d1 },
	{ 0x6d40, 0xf6d2 },
	{ 0x6d41, 0xf6d3 },
	{ 0x6d42, 0xf6d4 },
	{ 0x6d43, 0xf6d5 },
	{ 0x6d44, 0xf6d6 },
	{ 0x6d45, 0xf6d7 },
	{ 0x6d46, 0xf6d8 },
	{ 0x6d47, 0xf6d9 },
	{ 0x6d48, 0xf6da },
	{ 0x6d49, 0xf6db },
	{ 0x6d4a, 0xf6dc },
	{ 0x6d4b, 0xf6dd },
	{ 0x6d4c, 0xf6de },
	{ 0x6d4d, 0xf6df },
	{ 0x6d4e, 0xf6e0 },
	{ 0x6d4f, 0xf6e1 },
	{ 0x6d50, 0xf6e2 },
	{ 0x6d51, 0xf6e3 },
	{ 0x6d52, 0xf6e4 },
	{ 0x6d53, 0xf6e5 },
	{ 0x6d54, 0xf6e6 },
	{ 0x6d55, 0xf6e7 },
	{ 0x6d56, 0xf6e8 },
	{ 0x6d57, 0xf6e9 },
	{ 0x6d58, 0xf6ea },
	{ 0x6d59, 0xf6eb },
	{ 0x6d5a, 0xf6ec },
	{ 0x6d5b, 0xf6ed },
	{ 0x6d5c, 0xf6ee },
	{ 0x6d5d, 0xf6ef },
	{ 0x6d5e, 0xf6f0 },
	{ 0x6d5f, 0xf6f1 },
	{ 0x6d60, 0xf6f2 },
	{ 0x6d61, 0xf6f3 },
	{ 0x6d62, 0xf6f4 },
	{ 0x6d63, 0xf6f5 },
	{ 0x6d64, 0xf6f6 },
	{ 0x6d65, 0xf6f7 },
	{ 0x6d66, 0xf6f8 },
	{ 0x6d67, 0xf6f9 },
	{ 0x6d68, 0xf6fa },
	{ 0x6d69, 0xf6fb },
	{ 0x6d6a, 0xf6fc },
	{ 0x6d6b, 0xf6fd },
	{ 0x6d6c, 0xf6fe },
	{ 0x6d6d, 0xf740 },
	{ 0x6d6e, 0xf741 },
	{ 0x6d6f, 0xf742 },
	{ 0x6d70, 0xf743 },
	{ 0x6d71, 0xf744 },
	{ 0x6d72, 0xf745 },
	{ 0x6d73, 0xf746 },
	{ 0x6d74, 0xf747 },
	{ 0x6d75, 0xf748 },
	{ 0x6d76, 0xf749 },
	{ 0x6d77, 0xf74a },
	{ 0x6d78, 0xf74b },
	{ 0x6d79, 0xf74c },
	{ 0x6d7a, 0xf74d },
	{ 0x6d7b, 0xf74e },
	{ 0x6d7c, 0xf74f },
	{ 0x6d7d, 0xf750 },
	{ 0x6d7e, 0xf751 },
	{ 0x6e21, 0xf752 },
	{ 0x6e22, 0xf753 },
	{ 0x6e23, 0xf754 },
	{ 0x6e24, 0xf755 },
	{ 0x6e25, 0xf756 },
	{ 0x6e26, 0xf757 },
	{ 0x6e27, 0xf758 },
	{ 0x6e28, 0xf759 },
	{ 0x6e29, 0xf75a },
	{ 0x6e2a, 0xf75b },
	{ 0x6e2b, 0xf75c },
	{ 0x6e2c, 0xf75d },
	{ 0x6e2d, 0xf75e },
	{ 0x6e2e, 0xf75f },
	{ 0x6e2f, 0xf760 },
	{ 0x6e30, 0xf761 },
	{ 0x6e31, 0xf762 },
	{ 0x6e32, 0xf763 },
	{ 0x6e33, 0xf764 },
	{ 0x6e34, 0xf765 },
	{ 0x6e35, 0xf766 },
	{ 0x6e36, 0xf767 },
	{ 0x6e37, 0xf768 },
	{ 0x6e38, 0xf769 },
	{ 0x6e39, 0xf76a },
	{ 0x6e3a, 0xf76b },
	{ 0x6e3b, 0xf76c },
	{ 0x6e3c, 0xf76d },
	{ 0x6e3d, 0xf76e },
	{ 0x6e3e, 0xf76f },
	{ 0x6e3f, 0xf770 },
	{ 0x6e40, 0xf771 },
	{ 0x6e41, 0xf772 },
	{ 0x6e42, 0xf773 },
	{ 0x6e43, 0xf774 },
	{ 0x6e44, 0xf775 },
	{ 0x6e45, 0xf776 },
	{ 0x6e46, 0xf777 },
	{ 0x6e47, 0xf778 },
	{ 0x6e48, 0xf779 },
	{ 0x6e49, 0xf77a },
	{ 0x6e4a, 0xf77b },
	{ 0x6e4b, 0xf77c },
	{ 0x6e4c, 0xf77d },
	{ 0x6e4d, 0xf77e },
	{ 0x6e4e, 0xf7a1 },
	{ 0x6e4f, 0xf7a2 },
	{ 0x6e50, 0xf7a3 },
	{ 0x6e51, 0xf7a4 },
	{ 0x6e52, 0xf7a5 },
	{ 0x6e53, 0xf7a6 },
	{ 0x6e54, 0xf7a7 },
	{ 0x6e55, 0xf7a8 },
	{ 0x6e56, 0xf7a9 },
	{ 0x6e57, 0xf7aa },
	{ 0x6e58, 0xf7ab },
	{ 0x6e59, 0xf7ac },
	{ 0x6e5a, 0xf7ad },
	{ 0x6e5b, 0xf7ae },
	{ 0x6e5c, 0xf7af },
	{ 0x6e5d, 0xf7b0 },
	{ 0x6e5e, 0xf7b1 },
	{ 0x6e5f, 0xf7b2 },
	{ 0x6e60, 0xf7b3 },
	{ 0x6e61, 0xf7b4 },
	{ 0x6e62, 0xf7b5 },
	{ 0x6e63, 0xf7b6 },
	{ 0x6e64, 0xf7b7 },
	{ 0x6e65, 0xf7b8 },
	{ 0x6e66, 0xf7b9 },
	{ 0x6e67, 0xf7ba },
	{ 0x6e68, 0xf7bb },
	{ 0x6e69, 0xf7bc },
	{ 0x6e6a, 0xf7bd },
	{ 0x6e6b, 0xf7be },
	{ 0x6e6c, 0xf7bf },
	{ 0x6e6d, 0xf7c0 },
	{ 0x6e6e, 0xf7c1 },
	{ 0x6e6f, 0xf7c2 },
	{ 0x6e70, 0xf7c3 },
	{ 0x6e71, 0xf7c4 },
	{ 0x6e72, 0xf7c5 },
	{ 0x6e73, 0xf7c6 },
	{ 0x6e74, 0xf7c7 },
	{ 0x6e75, 0xf7c8 },
	{ 0x6e76, 0xf7c9 },
	{ 0x6e77, 0xf7ca },
	{ 0x6e78, 0xf7cb },
	{ 0x6e79, 0xf7cc },
	{ 0x6e7a, 0xf7cd },
	{ 0x6e7b, 0xf7ce },
	{ 0x6e7c, 0xf7cf },
	{ 0x6e7d, 0xf7d0 },
	{ 0x6e7e, 0xf7d1 },
	{ 0x6f21, 0xf7d2 },
	{ 0x6f22, 0xf7d3 },
	{ 0x6f23, 0xf7d4 },
	{ 0x6f24, 0xf7d5 },
	{ 0x6f25, 0xf7d6 },
	{ 0x6f26, 0xf7d7 },
	{ 0x6f27, 0xf7d8 },
	{ 0x6f28, 0xf7d9 },
	{ 0x6f29, 0xf7da },
	{ 0x6f2a, 0xf7db },
	{ 0x6f2b, 0xf7dc },
	{ 0x6f2c, 0xf7dd },
	{ 0x6f2d, 0xf7de },
	{ 0x6f2e, 0xf7df },
	{ 0x6f2f, 0xf7e0 },
	{ 0x6f30, 0xf7e1 },
	{ 0x6f31, 0xf7e2 },
	{ 0x6f32, 0xf7e3 },
	{ 0x6f33, 0xf7e4 },
	{ 0x6f34, 0xf7e5 },
	{ 0x6f35, 0xf7e6 },
	{ 0x6f36, 0xf7e7 },
	{ 0x6f37, 0xf7e8 },
	{ 0x6f38, 0xf7e9 },
	{ 0x6f39, 0xf7ea },
	{ 0x6f3a, 0xf7eb },
	{ 0x6f3b, 0xf7ec },
	{ 0x6f3c, 0xf7ed },
	{ 0x6f3d, 0xf7ee },
	{ 0x6f3e, 0xf7ef },
	{ 0x6f3f, 0xf7f0 },
	{ 0x6f40, 0xf7f1 },
	{ 0x6f41, 0xf7f2 },
	{ 0x6f42, 0xf7f3 },
	{ 0x6f43, 0xf7f4 },
	{ 0x6f44, 0xf7f5 },
	{ 0x6f45, 0xf7f6 },
	{ 0x6f46, 0xf7f7 },
	{ 0x6f47, 0xf7f8 },
	{ 0x6f48, 0xf7f9 },
	{ 0x6f49, 0xf7fa },
	{ 0x6f4a, 0xf7fb },
	{ 0x6f4b, 0xf7fc },
	{ 0x6f4c, 0xf7fd },
	{ 0x6f4d, 0xf7fe },
	{ 0x6f4e, 0xf840 },
	{ 0x6f4f, 0xf841 },
	{ 0x6f50, 0xf842 },
	{ 0x6f51, 0xf843 },
	{ 0x6f52, 0xf844 },
	{ 0x6f53, 0xf845 },
	{ 0x6f54, 0xf846 },
	{ 0x6f55, 0xf847 },
	{ 0x6f56, 0xf848 },
	{ 0x6f57, 0xf849 },
	{ 0x6f58, 0xf84a },
	{ 0x6f59, 0xf84b },
	{ 0x6f5a, 0xf84c },
	{ 0x6f5b, 0xf84d },
	{ 0x6f5c, 0xf84e },
	{ 0x6f5d, 0xf84f },
	{ 0x6f5e, 0xf850 },
	{ 0x6f5f, 0xf851 },
	{ 0x6f60, 0xf852 },
	{ 0x6f61, 0xf853 },
	{ 0x6f62, 0xf854 },
	{ 0x6f63, 0xf855 },
	{ 0x6f64, 0xf856 },
	{ 0x6f65, 0xf857 },
	{ 0x6f66, 0xf858 },
	{ 0x6f67, 0xf859 },
	{ 0x6f68, 0xf85a },
	{ 0x6f69, 0xf85b },
	{ 0x6f6a, 0xf85c },
	{ 0x6f6b, 0xf85d },
	{ 0x6f6c, 0xf85e },
	{ 0x6f6d, 0xf85f },
	{ 0x6f6e, 0xf860 },
	{ 0x6f6f, 0xf861 },
	{ 0x6f70, 0xf862 },
	{ 0x6f71, 0xf863 },
	{ 0x6f72, 0xf864 },
	{ 0x6f73, 0xf865 },
	{ 0x6f74, 0xf866 },
	{ 0x6f75, 0xf867 },
	{ 0x6f76, 0xf868 },
	{ 0x6f77, 0xf869 },
	{ 0x6f78, 0xf86a },
	{ 0x6f79, 0xf86b },
	{ 0x6f7a, 0xf86c },
	{ 0x6f7b, 0xf86d },
	{ 0x6f7c, 0xf86e },
	{ 0x6f7d, 0xf86f },
	{ 0x6f7e, 0xf870 },
	{ 0x7021, 0xf871 },
	{ 0x7022, 0xf872 },
	{ 0x7023, 0xf873 },
	{ 0x7024, 0xf874 },
	{ 0x7025, 0xf875 },
	{ 0x7026, 0xf876 },
	{ 0x7027, 0xf877 },
	{ 0x7028, 0xf878 },
	{ 0x7029, 0xf879 },
	{ 0x702a, 0xf87a },
	{ 0x702b, 0xf87b },
	{ 0x702c, 0xf87c },
	{ 0x702d, 0xf87d },
	{ 0x702e, 0xf87e },
	{ 0x702f, 0xf8a1 },
	{ 0x7030, 0xf8a2 },
	{ 0x7031, 0xf8a3 },
	{ 0x7032, 0xf8a4 },
	{ 0x7033, 0xf8a5 },
	{ 0x7034, 0xf8a6 },
	{ 0x7035, 0xf8a7 },
	{ 0x7036, 0xf8a8 },
	{ 0x7037, 0xf8a9 },
	{ 0x7038, 0xf8aa },
	{ 0x7039, 0xf8ab },
	{ 0x703a, 0xf8ac },
	{ 0x703b, 0xf8ad },
	{ 0x703c, 0xf8ae },
	{ 0x703d, 0xf8af },
	{ 0x703e, 0xf8b0 },
	{ 0x703f, 0xf8b1 },
	{ 0x7040, 0xf8b2 },
	{ 0x7041, 0xf8b3 },
	{ 0x7042, 0xf8b4 },
	{ 0x7043, 0xf8b5 },
	{ 0x7044, 0xf8b6 },
	{ 0x7045, 0xf8b7 },
	{ 0x7046, 0xf8b8 },
	{ 0x7047, 0xf8b9 },
	{ 0x7048, 0xf8ba },
	{ 0x7049, 0xf8bb },
	{ 0x704a, 0xf8bc },
	{ 0x704b, 0xf8bd },
	{ 0x704c, 0xf8be },
	{ 0x704d, 0xf8bf },
	{ 0x704e, 0xf8c0 },
	{ 0x704f, 0xf8c1 },
	{ 0x7050, 0xf8c2 },
	{ 0x7051, 0xf8c3 },
	{ 0x7052, 0xf8c4 },
	{ 0x7053, 0xf8c5 },
	{ 0x7054, 0xf8c6 },
	{ 0x7055, 0xf8c7 },
	{ 0x7056, 0xf8c8 },
	{ 0x7057, 0xf8c9 },
	{ 0x7058, 0xf8ca },
	{ 0x7059, 0xf8cb },
	{ 0x705a, 0xf8cc },
	{ 0x705b, 0xf8cd },
	{ 0x705c, 0xf8ce },
	{ 0x705d, 0xf8cf },
	{ 0x705e, 0xf8d0 },
	{ 0x705f, 0xf8d1 },
	{ 0x7060, 0xf8d2 },
	{ 0x7061, 0xf8d3 },
	{ 0x7062, 0xf8d4 },
	{ 0x7063, 0xf8d5 },
	{ 0x7064, 0xf8d6 },
	{ 0x7065, 0xf8d7 },
	{ 0x7066, 0xf8d8 },
	{ 0x7067, 0xf8d9 },
	{ 0x7068, 0xf8da },
	{ 0x7069, 0xf8db },
	{ 0x706a, 0xf8dc },
	{ 0x706b, 0xf8dd },
	{ 0x706c, 0xf8de },
	{ 0x706d, 0xf8df },
	{ 0x706e, 0xf8e0 },
	{ 0x706f, 0xf8e1 },
	{ 0x7070, 0xf8e2 },
	{ 0x7071, 0xf8e3 },
	{ 0x7072, 0xf8e4 },
	{ 0x7073, 0xf8e5 },
	{ 0x7074, 0xf8e6 },
	{ 0x7075, 0xf8e7 },
	{ 0x7076, 0xf8e8 },
	{ 0x7077, 0xf8e9 },
	{ 0x7078, 0xf8ea },
	{ 0x7079, 0xf8eb },
	{ 0x707a, 0xf8ec },
	{ 0x707b, 0xf8ed },
	{ 0x707c, 0xf8ee },
	{ 0x707d, 0xf8ef },
	{ 0x707e, 0xf8f0 },
	{ 0x7121, 0xf8f1 },
	{ 0x7122, 0xf8f2 },
	{ 0x7123, 0xf8f3 },
	{ 0x7124, 0xf8f4 },
	{ 0x7125, 0xf8f5 },
	{ 0x7126, 0xf8f6 },
	{ 0x7127, 0xf8f7 },
	{ 0x7128, 0xf8f8 },
	{ 0x7129, 0xf8f9 },
	{ 0x712a, 0xf8fa },
	{ 0x712b, 0xf8fb },
	{ 0x712c, 0xf8fc },
	{ 0x712d, 0xf8fd },
	{ 0x712e, 0xf8fe },
	{ 0x712f, 0xf940 },
	{ 0x7130, 0xf941 },
	{ 0x7131, 0xf942 },
	{ 0x7132, 0xf943 },
	{ 0x7133, 0xf944 },
	{ 0x7134, 0xf945 },
	{ 0x7135, 0xf946 },
	{ 0x7136, 0xf947 },
	{ 0x7137, 0xf948 },
	{ 0x7138, 0xf949 },
	{ 0x7139, 0xf94a },
	{ 0x713a, 0xf94b },
	{ 0x713b, 0xf94c },
	{ 0x713c, 0xf94d },
	{ 0x713d, 0xf94e },
	{ 0x713e, 0xf94f },
	{ 0x713f, 0xf950 },
	{ 0x7140, 0xf951 },
	{ 0x7141, 0xf952 },
	{ 0x7142, 0xf953 },
	{ 0x7143, 0xf954 },
	{ 0x7144, 0xf955 },
	{ 0x7145, 0xf956 },
	{ 0x7146, 0xf957 },
	{ 0x7147, 0xf958 },
	{ 0x7148, 0xf959 },
	{ 0x7149, 0xf95a },
	{ 0x714a, 0xf95b },
	{ 0x714b, 0xf95c },
	{ 0x714c, 0xf95d },
	{ 0x714d, 0xf95e },
	{ 0x714e, 0xf95f },
	{ 0x714f, 0xf960 },
	{ 0x7150, 0xf961 },
	{ 0x7151, 0xf962 },
	{ 0x7152, 0xf963 },
	{ 0x7153, 0xf964 },
	{ 0x7154, 0xf965 },
	{ 0x7155, 0xf966 },
	{ 0x7156, 0xf967 },
	{ 0x7157, 0xf968 },
	{ 0x7158, 0xf969 },
	{ 0x7159, 0xf96a },
	{ 0x715a, 0xf96b },
	{ 0x715b, 0xf96c },
	{ 0x715c, 0xf96d },
	{ 0x715d, 0xf96e },
	{ 0x715e, 0xf96f },
	{ 0x715f, 0xf970 },
	{ 0x7160, 0xf971 },
	{ 0x7161, 0xf972 },
	{ 0x7162, 0xf973 },
	{ 0x7163, 0xf974 },
	{ 0x7164, 0xf975 },
	{ 0x7165, 0xf976 },
	{ 0x7166, 0xf9c4 },
	{ 0x7167, 0xf977 },
	{ 0x7168, 0xf978 },
	{ 0x7169, 0xf979 },
	{ 0x716a, 0xf97a },
	{ 0x716b, 0xf97b },
	{ 0x716c, 0xf97c },
	{ 0x716d, 0xf97d },
	{ 0x716e, 0xf97e },
	{ 0x716f, 0xf9a1 },
	{ 0x7170, 0xf9a2 },
	{ 0x7171, 0xf9a3 },
	{ 0x7172, 0xf9a4 },
	{ 0x7173, 0xf9a5 },
	{ 0x7174, 0xf9a6 },
	{ 0x7175, 0xf9a7 },
	{ 0x7176, 0xf9a8 },
	{ 0x7177, 0xf9a9 },
	{ 0x7178, 0xf9aa },
	{ 0x7179, 0xf9ab },
	{ 0x717a, 0xf9ac },
	{ 0x717b, 0xf9ad },
	{ 0x717c, 0xf9ae },
	{ 0x717d, 0xf9af },
	{ 0x717e, 0xf9b0 },
	{ 0x7221, 0xf9b1 },
	{ 0x7222, 0xf9b2 },
	{ 0x7223, 0xf9b3 },
	{ 0x7224, 0xf9b4 },
	{ 0x7225, 0xf9b5 },
	{ 0x7226, 0xf9b6 },
	{ 0x7227, 0xf9b7 },
	{ 0x7228, 0xf9b8 },
	{ 0x7229, 0xf9b9 },
	{ 0x722a, 0xf9ba },
	{ 0x722b, 0xf9bb },
	{ 0x722c, 0xf9bc },
	{ 0x722d, 0xf9bd },
	{ 0x722e, 0xf9be },
	{ 0x722f, 0xf9bf },
	{ 0x7230, 0xf9c0 },
	{ 0x7231, 0xf9c1 },
	{ 0x7232, 0xf9c2 },
	{ 0x7233, 0xf9c3 },
	{ 0x7234, 0xf9c5 },
	{ 0x7235, 0xf9c7 },
	{ 0x7236, 0xf9c8 },
	{ 0x7237, 0xf9c9 },
	{ 0x7238, 0xf9ca },
	{ 0x7239, 0xf9cb },
	{ 0x723a, 0xf9cc },
	{ 0x723b, 0xf9cd },
	{ 0x723c, 0xf9ce },
	{ 0x723d, 0xf9cf },
	{ 0x723e, 0xf9d0 },
	{ 0x723f, 0xf9d1 },
	{ 0x7240, 0xf9c6 },
	{ 0x7241, 0xf9d2 },
	{ 0x7242, 0xf9d3 },
	{ 0x7243, 0xf9d4 },
	{ 0x7244, 0xf9d5 }
};

/* CNS 11643-1992 plane #3 to Big-5 conversion table */
table_t	cns_big5_tab3[MAX_CNS3_NUM] = {
        { 0x2c5d, 0xf9da },
        { 0x3d7e, 0xf9db },
        { 0x4337, 0xf9d6 },
        { 0x444e, 0xf9d8 },
        { 0x4b5c, 0xf9dc },
        { 0x4f50, 0xf9d7 },
        { 0x504a, 0xf9d9 },
	{ 0x5764, 0xc255 }
};
#endif
