/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 *  under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
*/

/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 */


/* maxium mapping number from Big-5 Plus to UTF8 */
#define MAX_BIG5P_NUM		24066	/* Maximum number of Big-5 Plus */

typedef struct big5p_utf {
	unsigned long	big5pcode;
	unsigned long	unicode;
} big5p_utf;

/* Big-5 Plus to Unicode mapping table */
big5p_utf	big5p_utf_tab[MAX_BIG5P_NUM] = {
	{ 0x8140, 0x8488 },
	{ 0x8141, 0x8710 },
	{ 0x8142, 0x871F },
	{ 0x8143, 0x870F },
	{ 0x8144, 0x88D3 },
	{ 0x8145, 0x8C87 },
	{ 0x8146, 0x8CC6 },
	{ 0x8147, 0x90CC },
	{ 0x8148, 0x916D },
	{ 0x8149, 0x9258 },
	{ 0x814A, 0x9242 },
	{ 0x814B, 0x9268 },
	{ 0x814C, 0x9269 },
	{ 0x814D, 0x9243 },
	{ 0x814E, 0x9247 },
	{ 0x814F, 0x959D },
	{ 0x8150, 0x96CF },
	{ 0x8151, 0x97F4 },
	{ 0x8152, 0x9809 },
	{ 0x8153, 0x98AB },
	{ 0x8154, 0x98FB },
	{ 0x8155, 0x9AAC },
	{ 0x8156, 0x9AAE },
	{ 0x8157, 0x9AAA },
	{ 0x8158, 0x9B5C },
	{ 0x8159, 0x50DF },
	{ 0x815A, 0x5619 },
	{ 0x815B, 0x560A },
	{ 0x815C, 0x589A },
	{ 0x815D, 0x5D85 },
	{ 0x815E, 0x5E56 },
	{ 0x815F, 0x5E51 },
	{ 0x8160, 0x5FB1 },
	{ 0x8161, 0x645A },
	{ 0x8162, 0x6463 },
	{ 0x8163, 0x669B },
	{ 0x8164, 0x66A3 },
	{ 0x8165, 0x669E },
	{ 0x8166, 0x69B8 },
	{ 0x8167, 0x69BA },
	{ 0x8168, 0x69C7 },
	{ 0x8169, 0x69D7 },
	{ 0x816A, 0x6B70 },
	{ 0x816B, 0x6B9D },
	{ 0x816C, 0x6F16 },
	{ 0x816D, 0x6F24 },
	{ 0x816E, 0x6F45 },
	{ 0x816F, 0x7179 },
	{ 0x8170, 0x717A },
	{ 0x8171, 0x7254 },
	{ 0x8172, 0x757C },
	{ 0x8173, 0x757B },
	{ 0x8174, 0x7612 },
	{ 0x8175, 0x76B6 },
	{ 0x8176, 0x76E0 },
	{ 0x8177, 0x7773 },
	{ 0x8178, 0x7772 },
	{ 0x8179, 0x7770 },
	{ 0x817A, 0x789D },
	{ 0x817B, 0x7A27 },
	{ 0x817C, 0x7A35 },
	{ 0x817D, 0x7BA2 },
	{ 0x817E, 0x7B89 },
	{ 0x817F, 0xFFFD },
	{ 0x8180, 0x4E28 },
	{ 0x8181, 0x4E05 },
	{ 0x8182, 0x4E04 },
	{ 0x8183, 0x4E2A },
	{ 0x8184, 0x4E87 },
	{ 0x8185, 0x4E49 },
	{ 0x8186, 0x51E2 },
	{ 0x8187, 0x4E46 },
	{ 0x8188, 0x4E8F },
	{ 0x8189, 0x4EBC },
	{ 0x818A, 0x4EBE },
	{ 0x818B, 0x5166 },
	{ 0x818C, 0x51E3 },
	{ 0x818D, 0x5204 },
	{ 0x818E, 0x529C },
	{ 0x818F, 0x5344 },
	{ 0x8190, 0x5F51 },
	{ 0x8191, 0x961D },
	{ 0x8192, 0x4E63 },
	{ 0x8193, 0x4E62 },
	{ 0x8194, 0x4EA3 },
	{ 0x8195, 0x5185 },
	{ 0x8196, 0x4EC5 },
	{ 0x8197, 0x4ECF },
	{ 0x8198, 0x4ECE },
	{ 0x8199, 0x4ECC },
	{ 0x819A, 0x5184 },
	{ 0x819B, 0x5186 },
	{ 0x819C, 0x51E4 },
	{ 0x819D, 0x5205 },
	{ 0x819E, 0x529E },
	{ 0x819F, 0x529D },
	{ 0x81A0, 0x52FD },
	{ 0x81A1, 0x7BA5 },
	{ 0x81A2, 0x7CB6 },
	{ 0x81A3, 0x7DA5 },
	{ 0x81A4, 0x7DC3 },
	{ 0x81A5, 0x7FAB },
	{ 0x81A6, 0x8025 },
	{ 0x81A7, 0x8059 },
	{ 0x81A8, 0x8185 },
	{ 0x81A9, 0x818E },
	{ 0x81AA, 0x84BE },
	{ 0x81AB, 0x84A6 },
	{ 0x81AC, 0x872F },
	{ 0x81AD, 0x89A0 },
	{ 0x81AE, 0x8A97 },
	{ 0x81AF, 0x8C8B },
	{ 0x81B0, 0x8F0F },
	{ 0x81B1, 0x9275 },
	{ 0x81B2, 0x929F },
	{ 0x81B3, 0x95A6 },
	{ 0x81B4, 0x969A },
	{ 0x81B5, 0x9757 },
	{ 0x81B6, 0x97F7 },
	{ 0x81B7, 0x98B0 },
	{ 0x81B8, 0x99C6 },
	{ 0x81B9, 0x50FA },
	{ 0x81BA, 0x5285 },
	{ 0x81BB, 0x5643 },
	{ 0x81BC, 0x563C },
	{ 0x81BD, 0x5BED },
	{ 0x81BE, 0x5C35 },
	{ 0x81BF, 0x5F47 },
	{ 0x81C0, 0x616D },
	{ 0x81C1, 0x69F5 },
	{ 0x81C2, 0x6A03 },
	{ 0x81C3, 0x6A65 },
	{ 0x81C4, 0x6B75 },
	{ 0x81C5, 0x6F56 },
	{ 0x81C6, 0x6F98 },
	{ 0x81C7, 0x6F68 },
	{ 0x81C8, 0x7234 },
	{ 0x81C9, 0x7245 },
	{ 0x81CA, 0x735C },
	{ 0x81CB, 0x7356 },
	{ 0x81CC, 0x78BF },
	{ 0x81CD, 0x78BD },
	{ 0x81CE, 0x78E4 },
	{ 0x81CF, 0x7A34 },
	{ 0x81D0, 0x7A36 },
	{ 0x81D1, 0x7BBA },
	{ 0x81D2, 0x7BBC },
	{ 0x81D3, 0x7BC8 },
	{ 0x81D4, 0x7BC3 },
	{ 0x81D5, 0x7BB6 },
	{ 0x81D6, 0x7BC2 },
	{ 0x81D7, 0x7BC5 },
	{ 0x81D8, 0x7BBD },
	{ 0x81D9, 0x7BB0 },
	{ 0x81DA, 0x7BBB },
	{ 0x81DB, 0x7E04 },
	{ 0x81DC, 0x81F1 },
	{ 0x81DD, 0x8522 },
	{ 0x81DE, 0x8538 },
	{ 0x81DF, 0x8532 },
	{ 0x81E0, 0x8510 },
	{ 0x81E1, 0x854F },
	{ 0x81E2, 0x877C },
	{ 0x81E3, 0x890D },
	{ 0x81E4, 0x8908 },
	{ 0x81E5, 0x8D9E },
	{ 0x81E6, 0x8F28 },
	{ 0x81E7, 0x8F21 },
	{ 0x81E8, 0x9066 },
	{ 0x81E9, 0x906C },
	{ 0x81EA, 0x90F6 },
	{ 0x81EB, 0x92EC },
	{ 0x81EC, 0x92BA },
	{ 0x81ED, 0x92E3 },
	{ 0x81EE, 0x92BD },
	{ 0x81EF, 0x95B4 },
	{ 0x81F0, 0x97D1 },
	{ 0x81F1, 0x9823 },
	{ 0x81F2, 0x990B },
	{ 0x81F3, 0x9AB2 },
	{ 0x81F4, 0x9ADB },
	{ 0x81F5, 0x9B73 },
	{ 0x81F6, 0x9B6E },
	{ 0x81F7, 0x9B65 },
	{ 0x81F8, 0x9B6A },
	{ 0x81F9, 0x9B6D },
	{ 0x81FA, 0x9D0B },
	{ 0x81FB, 0x9E76 },
	{ 0x81FC, 0x9F11 },
	{ 0x81FD, 0x5119 },
	{ 0x81FE, 0x5675 },
	{ 0x8240, 0x596F },
	{ 0x8241, 0x61A5 },
	{ 0x8242, 0x61A0 },
	{ 0x8243, 0x65B4 },
	{ 0x8244, 0x65D8 },
	{ 0x8245, 0x66C2 },
	{ 0x8246, 0x6BA8 },
	{ 0x8247, 0x6F83 },
	{ 0x8248, 0x6FC5 },
	{ 0x8249, 0x71CD },
	{ 0x824A, 0x729C },
	{ 0x824B, 0x7499 },
	{ 0x824C, 0x7639 },
	{ 0x824D, 0x762E },
	{ 0x824E, 0x769F },
	{ 0x824F, 0x76A0 },
	{ 0x8250, 0x7794 },
	{ 0x8251, 0x77AE },
	{ 0x8252, 0x78E6 },
	{ 0x8253, 0x7ABC },
	{ 0x8254, 0x7BD6 },
	{ 0x8255, 0x7CCF },
	{ 0x8256, 0x7E18 },
	{ 0x8257, 0x806D },
	{ 0x8258, 0x8190 },
	{ 0x8259, 0x8552 },
	{ 0x825A, 0x8550 },
	{ 0x825B, 0x87A0 },
	{ 0x825C, 0x8786 },
	{ 0x825D, 0x8795 },
	{ 0x825E, 0x8860 },
	{ 0x825F, 0x8928 },
	{ 0x8260, 0x8920 },
	{ 0x8261, 0x89A8 },
	{ 0x8262, 0x8E3A },
	{ 0x8263, 0x9194 },
	{ 0x8264, 0x9311 },
	{ 0x8265, 0x9337 },
	{ 0x8266, 0x9343 },
	{ 0x8267, 0x96A6 },
	{ 0x8268, 0x9795 },
	{ 0x8269, 0x9796 },
	{ 0x826A, 0x9825 },
	{ 0x826B, 0x9926 },
	{ 0x826C, 0x9934 },
	{ 0x826D, 0x9B8A },
	{ 0x826E, 0x9B7F },
	{ 0x826F, 0x9D11 },
	{ 0x8270, 0x9ED9 },
	{ 0x8271, 0x9F3C },
	{ 0x8272, 0x5123 },
	{ 0x8273, 0x512C },
	{ 0x8274, 0x5295 },
	{ 0x8275, 0x5688 },
	{ 0x8276, 0x568B },
	{ 0x8277, 0x61E1 },
	{ 0x8278, 0x61D7 },
	{ 0x8279, 0x65A3 },
	{ 0x827A, 0x66D3 },
	{ 0x827B, 0x6A8B },
	{ 0x827C, 0x6BAC },
	{ 0x827D, 0x7374 },
	{ 0x827E, 0x7640 },
	{ 0x827F, 0xFFFD },
	{ 0x8280, 0x5300 },
	{ 0x8281, 0x533A },
	{ 0x8282, 0x5346 },
	{ 0x8283, 0x535D },
	{ 0x8284, 0x5386 },
	{ 0x8285, 0x53B7 },
	{ 0x8286, 0x53CC },
	{ 0x8287, 0x53CE },
	{ 0x8288, 0x5721 },
	{ 0x8289, 0x5E00 },
	{ 0x828A, 0x5F0C },
	{ 0x828B, 0x6237 },
	{ 0x828C, 0x6238 },
	{ 0x828D, 0x6535 },
	{ 0x828E, 0x738D },
	{ 0x828F, 0x4E97 },
	{ 0x8290, 0x4EE0 },
	{ 0x8291, 0x4EE7 },
	{ 0x8292, 0x4EE6 },
	{ 0x8293, 0x56D8 },
	{ 0x8294, 0x518B },
	{ 0x8295, 0x518C },
	{ 0x8296, 0x5199 },
	{ 0x8297, 0x51E5 },
	{ 0x8298, 0x520B },
	{ 0x8299, 0x5304 },
	{ 0x829A, 0x5303 },
	{ 0x829B, 0x5307 },
	{ 0x829C, 0x531E },
	{ 0x829D, 0x535F },
	{ 0x829E, 0x536D },
	{ 0x829F, 0x5389 },
	{ 0x82A0, 0x53BA },
	{ 0x82A1, 0x7641 },
	{ 0x82A2, 0x76E8 },
	{ 0x82A3, 0x78F6 },
	{ 0x82A4, 0x7900 },
	{ 0x82A5, 0x7A59 },
	{ 0x82A6, 0x7A55 },
	{ 0x82A7, 0x7AF4 },
	{ 0x82A8, 0x7C04 },
	{ 0x82A9, 0x7C15 },
	{ 0x82AA, 0x7BF5 },
	{ 0x82AB, 0x81C1 },
	{ 0x82AC, 0x857D },
	{ 0x82AD, 0x85A5 },
	{ 0x82AE, 0x893A },
	{ 0x82AF, 0x8E51 },
	{ 0x82B0, 0x9198 },
	{ 0x82B1, 0x9381 },
	{ 0x82B2, 0x936F },
	{ 0x82B3, 0x9842 },
	{ 0x82B4, 0x9937 },
	{ 0x82B5, 0x9BA9 },
	{ 0x82B6, 0x9BA7 },
	{ 0x82B7, 0x9BAC },
	{ 0x82B8, 0x9B9C },
	{ 0x82B9, 0x9D3C },
	{ 0x82BA, 0x9D1C },
	{ 0x82BB, 0x9D3A },
	{ 0x82BC, 0x9D32 },
	{ 0x82BD, 0x9D34 },
	{ 0x82BE, 0x9F3F },
	{ 0x82BF, 0x5EEB },
	{ 0x82C0, 0x61D5 },
	{ 0x82C1, 0x6502 },
	{ 0x82C2, 0x7012 },
	{ 0x82C3, 0x7585 },
	{ 0x82C4, 0x7654 },
	{ 0x82C5, 0x7655 },
	{ 0x82C6, 0x76A7 },
	{ 0x82C7, 0x76A8 },
	{ 0x82C8, 0x790F },
	{ 0x82C9, 0x7CE4 },
	{ 0x82CA, 0x7CE5 },
	{ 0x82CB, 0x7E65 },
	{ 0x82CC, 0x7E4E },
	{ 0x82CD, 0x7F82 },
	{ 0x82CE, 0x802D },
	{ 0x82CF, 0x85CA },
	{ 0x82D0, 0x85BC },
	{ 0x82D1, 0x8CFF },
	{ 0x82D2, 0x91A6 },
	{ 0x82D3, 0x93B6 },
	{ 0x82D4, 0x93AB },
	{ 0x82D5, 0x97A7 },
	{ 0x82D6, 0x983E },
	{ 0x82D7, 0x9BBC },
	{ 0x82D8, 0x9BB7 },
	{ 0x82D9, 0x9BBE },
	{ 0x82DA, 0x9D62 },
	{ 0x82DB, 0x9E8F },
	{ 0x82DC, 0x9ECB },
	{ 0x82DD, 0x56A9 },
	{ 0x82DE, 0x5913 },
	{ 0x82DF, 0x5BF4 },
	{ 0x82E0, 0x61EC },
	{ 0x82E1, 0x61EF },
	{ 0x82E2, 0x6AD6 },
	{ 0x82E3, 0x7209 },
	{ 0x82E4, 0x7379 },
	{ 0x82E5, 0x74C6 },
	{ 0x82E6, 0x77C3 },
	{ 0x82E7, 0x791F },
	{ 0x82E8, 0x7A65 },
	{ 0x82E9, 0x7AC6 },
	{ 0x82EA, 0x7C3A },
	{ 0x82EB, 0x7CEB },
	{ 0x82EC, 0x7F84 },
	{ 0x82ED, 0x85E0 },
	{ 0x82EE, 0x85F3 },
	{ 0x82EF, 0x881E },
	{ 0x82F0, 0x89B4 },
	{ 0x82F1, 0x89F9 },
	{ 0x82F2, 0x8B44 },
	{ 0x82F3, 0x8E71 },
	{ 0x82F4, 0x8E6E },
	{ 0x82F5, 0x8E79 },
	{ 0x82F6, 0x8EC4 },
	{ 0x82F7, 0x908C },
	{ 0x82F8, 0x93C9 },
	{ 0x82F9, 0x97B0 },
	{ 0x82FA, 0x985A },
	{ 0x82FB, 0x9946 },
	{ 0x82FC, 0x9AC3 },
	{ 0x82FD, 0x9B0F },
	{ 0x82FE, 0x9BF4 },
	{ 0x8340, 0x9BFA },
	{ 0x8341, 0x9BDD },
	{ 0x8342, 0x9BED },
	{ 0x8343, 0x9BEF },
	{ 0x8344, 0x9E96 },
	{ 0x8345, 0x9EB3 },
	{ 0x8346, 0x9EE2 },
	{ 0x8347, 0x9F8F },
	{ 0x8348, 0x56B1 },
	{ 0x8349, 0x5B41 },
	{ 0x834A, 0x6AF6 },
	{ 0x834B, 0x6AF2 },
	{ 0x834C, 0x7588 },
	{ 0x834D, 0x8267 },
	{ 0x834E, 0x860E },
	{ 0x834F, 0x8D0E },
	{ 0x8350, 0x91B6 },
	{ 0x8351, 0x942F },
	{ 0x8352, 0x97E0 },
	{ 0x8353, 0x97DB },
	{ 0x8354, 0x9861 },
	{ 0x8355, 0x9A33 },
	{ 0x8356, 0x9C0F },
	{ 0x8357, 0x9C11 },
	{ 0x8358, 0x9C03 },
	{ 0x8359, 0x9C01 },
	{ 0x835A, 0x9C16 },
	{ 0x835B, 0x9D93 },
	{ 0x835C, 0x535B },
	{ 0x835D, 0x56BF },
	{ 0x835E, 0x5DCE },
	{ 0x835F, 0x76AC },
	{ 0x8360, 0x77D2 },
	{ 0x8361, 0x7C52 },
	{ 0x8362, 0x8B76 },
	{ 0x8363, 0x8EC7 },
	{ 0x8364, 0x9434 },
	{ 0x8365, 0x943E },
	{ 0x8366, 0x97BC },
	{ 0x8367, 0x9B39 },
	{ 0x8368, 0x9C2A },
	{ 0x8369, 0x9C26 },
	{ 0x836A, 0x9C27 },
	{ 0x836B, 0x9DC0 },
	{ 0x836C, 0x9DC9 },
	{ 0x836D, 0x9EEC },
	{ 0x836E, 0x9F68 },
	{ 0x836F, 0x8032 },
	{ 0x8370, 0x8031 },
	{ 0x8371, 0x89FD },
	{ 0x8372, 0x908E },
	{ 0x8373, 0x97C2 },
	{ 0x8374, 0x9A4B },
	{ 0x8375, 0x9B1C },
	{ 0x8376, 0x9B1B },
	{ 0x8377, 0x9C42 },
	{ 0x8378, 0x56D0 },
	{ 0x8379, 0x56CF },
	{ 0x837A, 0x5DDA },
	{ 0x837B, 0x66EA },
	{ 0x837C, 0x8B89 },
	{ 0x837D, 0x9458 },
	{ 0x837E, 0x9DE7 },
	{ 0x837F, 0xFFFD },
	{ 0x8380, 0x53D0 },
	{ 0x8381, 0x53F6 },
	{ 0x8382, 0x53F7 },
	{ 0x8383, 0x53F9 },
	{ 0x8384, 0x53F4 },
	{ 0x8385, 0x5724 },
	{ 0x8386, 0x5904 },
	{ 0x8387, 0x5918 },
	{ 0x8388, 0x5932 },
	{ 0x8389, 0x5930 },
	{ 0x838A, 0x5934 },
	{ 0x838B, 0x5975 },
	{ 0x838C, 0x5B82 },
	{ 0x838D, 0x5BF9 },
	{ 0x838E, 0x5C14 },
	{ 0x838F, 0x5E81 },
	{ 0x8390, 0x5E83 },
	{ 0x8391, 0x5F0D },
	{ 0x8392, 0x5F52 },
	{ 0x8393, 0x5FCA },
	{ 0x8394, 0x5FC7 },
	{ 0x8395, 0x6239 },
	{ 0x8396, 0x624F },
	{ 0x8397, 0x65E7 },
	{ 0x8398, 0x672F },
	{ 0x8399, 0x6B7A },
	{ 0x839A, 0x6C39 },
	{ 0x839B, 0x6C37 },
	{ 0x839C, 0x6C44 },
	{ 0x839D, 0x6C45 },
	{ 0x839E, 0x738C },
	{ 0x839F, 0x9093 },
	{ 0x83A0, 0x9092 },
	{ 0x83A1, 0x9DEA },
	{ 0x83A2, 0x9DF1 },
	{ 0x83A3, 0x9F44 },
	{ 0x83A4, 0x9F6D },
	{ 0x83A5, 0x5DD9 },
	{ 0x83A6, 0x883A },
	{ 0x83A7, 0x8975 },
	{ 0x83A8, 0x9A5D },
	{ 0x83A9, 0x9C64 },
	{ 0x83AA, 0x9E0A },
	{ 0x83AB, 0x9F73 },
	{ 0x83AC, 0x77E1 },
	{ 0x83AD, 0x9B2D },
	{ 0x83AE, 0x9E0C },
	{ 0x83AF, 0x9F1F },
	{ 0x83B0, 0x7C70 },
	{ 0x83B1, 0x9479 },
	{ 0x83B2, 0x974A },
	{ 0x83B3, 0x7E9D },
	{ 0x83B4, 0x9960 },
	{ 0x83B5, 0x9F9E },
	{ 0x83B6, 0x9EF8 },
	{ 0x83B7, 0x9F3A },
	{ 0x83B8, 0x9F7D },
	{ 0x83B9, 0x9F96 },
	{ 0x83BA, 0x6729 },
	{ 0x83BB, 0x5E07 },
	{ 0x83BC, 0x5FCB },
	{ 0x83BD, 0x52B7 },
	{ 0x83BE, 0x52B8 },
	{ 0x83BF, 0x52B6 },
	{ 0x83C0, 0x52BA },
	{ 0x83C1, 0x6306 },
	{ 0x83C2, 0x6B85 },
	{ 0x83C3, 0x8C38 },
	{ 0x83C4, 0x7309 },
	{ 0x83C5, 0x8A2F },
	{ 0x83C6, 0x52DC },
	{ 0x83C7, 0x5921 },
	{ 0x83C8, 0x5E3F },
	{ 0x83C9, 0x7B3F },
	{ 0x83CA, 0x83D0 },
	{ 0x83CB, 0x86E7 },
	{ 0x83CC, 0x6117 },
	{ 0x83CD, 0x8714 },
	{ 0x83CE, 0x88D1 },
	{ 0x83CF, 0x8CCB },
	{ 0x83D0, 0x8EED },
	{ 0x83D1, 0x52EC },
	{ 0x83D2, 0x52E8 },
	{ 0x83D3, 0x7527 },
	{ 0x83D4, 0x798C },
	{ 0x83D5, 0x7991 },
	{ 0x83D6, 0x8660 },
	{ 0x83D7, 0x9904 },
	{ 0x83D8, 0x999B },
	{ 0x83D9, 0x729F },
	{ 0x83DA, 0x8770 },
	{ 0x83DB, 0x8E37 },
	{ 0x83DC, 0x9703 },
	{ 0x83DD, 0x52F6 },
	{ 0x83DE, 0x64CC },
	{ 0x83DF, 0x764A },
	{ 0x83E0, 0x7AB9 },
	{ 0x83E1, 0x7BD7 },
	{ 0x83E2, 0x999F },
	{ 0x83E3, 0x9B8D },
	{ 0x83E4, 0x9E77 },
	{ 0x83E5, 0x764B },
	{ 0x83E6, 0x76A2 },
	{ 0x83E7, 0x87F1 },
	{ 0x83E8, 0x9BBA },
	{ 0x83E9, 0x8804 },
	{ 0x83EA, 0x9BD8 },
	{ 0x83EB, 0x9D7C },
	{ 0x83EC, 0x7C46 },
	{ 0x83ED, 0x9D8D },
	{ 0x83EE, 0x957E },
	{ 0x83EF, 0x9C20 },
	{ 0x83F0, 0x9C22 },
	{ 0x83F1, 0x9C1E },
	{ 0x83F2, 0x8970 },
	{ 0x83F3, 0x9C43 },
	{ 0x83F4, 0x9DE0 },
	{ 0x83F5, 0x9459 },
	{ 0x83F6, 0x9C72 },
	{ 0x83F7, 0x6530 },
	{ 0x83F8, 0x72DD },
	{ 0x83F9, 0x6804 },
	{ 0x83FA, 0x82FF },
	{ 0x83FB, 0x8FEC },
	{ 0x83FC, 0x53DE },
	{ 0x83FD, 0x5A30 },
	{ 0x83FE, 0x5BB2 },
	{ 0x8440, 0xFFFD },
	{ 0x8441, 0xFFFD },
	{ 0x8442, 0xFFFD },
	{ 0x8443, 0xFFFD },
	{ 0x8444, 0xFFFD },
	{ 0x8445, 0xFFFD },
	{ 0x8446, 0xFFFD },
	{ 0x8447, 0xFFFD },
	{ 0x8448, 0xFFFD },
	{ 0x8449, 0xFFFD },
	{ 0x844A, 0xFFFD },
	{ 0x844B, 0xFFFD },
	{ 0x844C, 0xFFFD },
	{ 0x844D, 0xFFFD },
	{ 0x844E, 0xFFFD },
	{ 0x844F, 0xFFFD },
	{ 0x8450, 0xFFFD },
	{ 0x8451, 0xFFFD },
	{ 0x8452, 0xFFFD },
	{ 0x8453, 0xFFFD },
	{ 0x8454, 0xFFFD },
	{ 0x8455, 0xFFFD },
	{ 0x8456, 0xFFFD },
	{ 0x8457, 0xFFFD },
	{ 0x8458, 0xFFFD },
	{ 0x8459, 0xFFFD },
	{ 0x845A, 0xFFFD },
	{ 0x845B, 0xFFFD },
	{ 0x845C, 0xFFFD },
	{ 0x845D, 0xFFFD },
	{ 0x845E, 0xFFFD },
	{ 0x845F, 0xFFFD },
	{ 0x8460, 0xFFFD },
	{ 0x8461, 0xFFFD },
	{ 0x8462, 0xFFFD },
	{ 0x8463, 0xFFFD },
	{ 0x8464, 0xFFFD },
	{ 0x8465, 0xFFFD },
	{ 0x8466, 0xFFFD },
	{ 0x8467, 0xFFFD },
	{ 0x8468, 0xFFFD },
	{ 0x8469, 0xFFFD },
	{ 0x846A, 0xFFFD },
	{ 0x846B, 0xFFFD },
	{ 0x846C, 0xFFFD },
	{ 0x846D, 0xFFFD },
	{ 0x846E, 0xFFFD },
	{ 0x846F, 0xFFFD },
	{ 0x8470, 0xFFFD },
	{ 0x8471, 0xFFFD },
	{ 0x8472, 0xFFFD },
	{ 0x8473, 0xFFFD },
	{ 0x8474, 0xFFFD },
	{ 0x8475, 0xFFFD },
	{ 0x8476, 0xFFFD },
	{ 0x8477, 0xFFFD },
	{ 0x8478, 0xFFFD },
	{ 0x8479, 0xFFFD },
	{ 0x847A, 0xFFFD },
	{ 0x847B, 0xFFFD },
	{ 0x847C, 0xFFFD },
	{ 0x847D, 0xFFFD },
	{ 0x847E, 0xFFFD },
	{ 0x847F, 0xFFFD },
	{ 0x8480, 0x4E21 },
	{ 0x8481, 0x4E20 },
	{ 0x8482, 0x4E22 },
	{ 0x8483, 0x4E68 },
	{ 0x8484, 0x4E89 },
	{ 0x8485, 0x4E98 },
	{ 0x8486, 0x4EF9 },
	{ 0x8487, 0x4EEF },
	{ 0x8488, 0x4EF8 },
	{ 0x8489, 0x4F06 },
	{ 0x848A, 0x4F03 },
	{ 0x848B, 0x4EFC },
	{ 0x848C, 0x4EEE },
	{ 0x848D, 0x4F16 },
	{ 0x848E, 0x4F28 },
	{ 0x848F, 0x4F1C },
	{ 0x8490, 0x4F07 },
	{ 0x8491, 0x4F1A },
	{ 0x8492, 0x4EFA },
	{ 0x8493, 0x4F17 },
	{ 0x8494, 0x514A },
	{ 0x8495, 0x5172 },
	{ 0x8496, 0x51B4 },
	{ 0x8497, 0x51B3 },
	{ 0x8498, 0x51B2 },
	{ 0x8499, 0x51E8 },
	{ 0x849A, 0x5214 },
	{ 0x849B, 0x520F },
	{ 0x849C, 0x5215 },
	{ 0x849D, 0x5218 },
	{ 0x849E, 0x52A8 },
	{ 0x849F, 0x534B },
	{ 0x84A0, 0x534F },
	{ 0x84A1, 0xFFFD },
	{ 0x84A2, 0xFFFD },
	{ 0x84A3, 0xFFFD },
	{ 0x84A4, 0xFFFD },
	{ 0x84A5, 0xFFFD },
	{ 0x84A6, 0xFFFD },
	{ 0x84A7, 0xFFFD },
	{ 0x84A8, 0xFFFD },
	{ 0x84A9, 0xFFFD },
	{ 0x84AA, 0xFFFD },
	{ 0x84AB, 0xFFFD },
	{ 0x84AC, 0xFFFD },
	{ 0x84AD, 0xFFFD },
	{ 0x84AE, 0xFFFD },
	{ 0x84AF, 0xFFFD },
	{ 0x84B0, 0xFFFD },
	{ 0x84B1, 0xFFFD },
	{ 0x84B2, 0xFFFD },
	{ 0x84B3, 0xFFFD },
	{ 0x84B4, 0xFFFD },
	{ 0x84B5, 0xFFFD },
	{ 0x84B6, 0xFFFD },
	{ 0x84B7, 0xFFFD },
	{ 0x84B8, 0xFFFD },
	{ 0x84B9, 0xFFFD },
	{ 0x84BA, 0xFFFD },
	{ 0x84BB, 0xFFFD },
	{ 0x84BC, 0xFFFD },
	{ 0x84BD, 0xFFFD },
	{ 0x84BE, 0xFFFD },
	{ 0x84BF, 0xFFFD },
	{ 0x84C0, 0xFFFD },
	{ 0x84C1, 0xFFFD },
	{ 0x84C2, 0xFFFD },
	{ 0x84C3, 0xFFFD },
	{ 0x84C4, 0xFFFD },
	{ 0x84C5, 0xFFFD },
	{ 0x84C6, 0xFFFD },
	{ 0x84C7, 0xFFFD },
	{ 0x84C8, 0xFFFD },
	{ 0x84C9, 0xFFFD },
	{ 0x84CA, 0xFFFD },
	{ 0x84CB, 0xFFFD },
	{ 0x84CC, 0xFFFD },
	{ 0x84CD, 0xFFFD },
	{ 0x84CE, 0xFFFD },
	{ 0x84CF, 0xFFFD },
	{ 0x84D0, 0xFFFD },
	{ 0x84D1, 0xFFFD },
	{ 0x84D2, 0xFFFD },
	{ 0x84D3, 0xFFFD },
	{ 0x84D4, 0xFFFD },
	{ 0x84D5, 0xFFFD },
	{ 0x84D6, 0xFFFD },
	{ 0x84D7, 0xFFFD },
	{ 0x84D8, 0xFFFD },
	{ 0x84D9, 0xFFFD },
	{ 0x84DA, 0xFFFD },
	{ 0x84DB, 0xFFFD },
	{ 0x84DC, 0xFFFD },
	{ 0x84DD, 0xFFFD },
	{ 0x84DE, 0xFFFD },
	{ 0x84DF, 0xFFFD },
	{ 0x84E0, 0xFFFD },
	{ 0x84E1, 0xFFFD },
	{ 0x84E2, 0xFFFD },
	{ 0x84E3, 0xFFFD },
	{ 0x84E4, 0xFFFD },
	{ 0x84E5, 0xFFFD },
	{ 0x84E6, 0xFFFD },
	{ 0x84E7, 0xFFFD },
	{ 0x84E8, 0xFFFD },
	{ 0x84E9, 0xFFFD },
	{ 0x84EA, 0xFFFD },
	{ 0x84EB, 0xFFFD },
	{ 0x84EC, 0xFFFD },
	{ 0x84ED, 0xFFFD },
	{ 0x84EE, 0xFFFD },
	{ 0x84EF, 0xFFFD },
	{ 0x84F0, 0xFFFD },
	{ 0x84F1, 0xFFFD },
	{ 0x84F2, 0xFFFD },
	{ 0x84F3, 0xFFFD },
	{ 0x84F4, 0xFFFD },
	{ 0x84F5, 0xFFFD },
	{ 0x84F6, 0xFFFD },
	{ 0x84F7, 0xFFFD },
	{ 0x84F8, 0xFFFD },
	{ 0x84F9, 0xFFFD },
	{ 0x84FA, 0xFFFD },
	{ 0x84FB, 0xFFFD },
	{ 0x84FC, 0xFFFD },
	{ 0x84FD, 0xFFFD },
	{ 0x84FE, 0xFFFD },
	{ 0x8540, 0xFFFD },
	{ 0x8541, 0xFFFD },
	{ 0x8542, 0xFFFD },
	{ 0x8543, 0xFFFD },
	{ 0x8544, 0xFFFD },
	{ 0x8545, 0xFFFD },
	{ 0x8546, 0xFFFD },
	{ 0x8547, 0xFFFD },
	{ 0x8548, 0xFFFD },
	{ 0x8549, 0xFFFD },
	{ 0x854A, 0xFFFD },
	{ 0x854B, 0xFFFD },
	{ 0x854C, 0xFFFD },
	{ 0x854D, 0xFFFD },
	{ 0x854E, 0xFFFD },
	{ 0x854F, 0xFFFD },
	{ 0x8550, 0xFFFD },
	{ 0x8551, 0xFFFD },
	{ 0x8552, 0xFFFD },
	{ 0x8553, 0xFFFD },
	{ 0x8554, 0xFFFD },
	{ 0x8555, 0xFFFD },
	{ 0x8556, 0xFFFD },
	{ 0x8557, 0xFFFD },
	{ 0x8558, 0xFFFD },
	{ 0x8559, 0xFFFD },
	{ 0x855A, 0xFFFD },
	{ 0x855B, 0xFFFD },
	{ 0x855C, 0xFFFD },
	{ 0x855D, 0xFFFD },
	{ 0x855E, 0xFFFD },
	{ 0x855F, 0xFFFD },
	{ 0x8560, 0xFFFD },
	{ 0x8561, 0xFFFD },
	{ 0x8562, 0xFFFD },
	{ 0x8563, 0xFFFD },
	{ 0x8564, 0xFFFD },
	{ 0x8565, 0xFFFD },
	{ 0x8566, 0xFFFD },
	{ 0x8567, 0xFFFD },
	{ 0x8568, 0xFFFD },
	{ 0x8569, 0xFFFD },
	{ 0x856A, 0xFFFD },
	{ 0x856B, 0xFFFD },
	{ 0x856C, 0xFFFD },
	{ 0x856D, 0xFFFD },
	{ 0x856E, 0xFFFD },
	{ 0x856F, 0xFFFD },
	{ 0x8570, 0xFFFD },
	{ 0x8571, 0xFFFD },
	{ 0x8572, 0xFFFD },
	{ 0x8573, 0xFFFD },
	{ 0x8574, 0xFFFD },
	{ 0x8575, 0xFFFD },
	{ 0x8576, 0xFFFD },
	{ 0x8577, 0xFFFD },
	{ 0x8578, 0xFFFD },
	{ 0x8579, 0xFFFD },
	{ 0x857A, 0xFFFD },
	{ 0x857B, 0xFFFD },
	{ 0x857C, 0xFFFD },
	{ 0x857D, 0xFFFD },
	{ 0x857E, 0xFFFD },
	{ 0x857F, 0xFFFD },
	{ 0x8580, 0x5350 },
	{ 0x8581, 0x538B },
	{ 0x8582, 0x53BE },
	{ 0x8583, 0x53D2 },
	{ 0x8584, 0x5416 },
	{ 0x8585, 0x53FF },
	{ 0x8586, 0x5400 },
	{ 0x8587, 0x5405 },
	{ 0x8588, 0x5413 },
	{ 0x8589, 0x5415 },
	{ 0x858A, 0x56E3 },
	{ 0x858B, 0x5735 },
	{ 0x858C, 0x5736 },
	{ 0x858D, 0x5731 },
	{ 0x858E, 0x5732 },
	{ 0x858F, 0x58EE },
	{ 0x8590, 0x5905 },
	{ 0x8591, 0x4E54 },
	{ 0x8592, 0x5936 },
	{ 0x8593, 0x597A },
	{ 0x8594, 0x5986 },
	{ 0x8595, 0x5B86 },
	{ 0x8596, 0x5F53 },
	{ 0x8597, 0x5C18 },
	{ 0x8598, 0x5C3D },
	{ 0x8599, 0x5C78 },
	{ 0x859A, 0x5C80 },
	{ 0x859B, 0x5E08 },
	{ 0x859C, 0x5EF5 },
	{ 0x859D, 0x5F0E },
	{ 0x859E, 0x5FD3 },
	{ 0x859F, 0x5FDA },
	{ 0x85A0, 0x5FDB },
	{ 0x85A1, 0xFFFD },
	{ 0x85A2, 0xFFFD },
	{ 0x85A3, 0xFFFD },
	{ 0x85A4, 0xFFFD },
	{ 0x85A5, 0xFFFD },
	{ 0x85A6, 0xFFFD },
	{ 0x85A7, 0xFFFD },
	{ 0x85A8, 0xFFFD },
	{ 0x85A9, 0xFFFD },
	{ 0x85AA, 0xFFFD },
	{ 0x85AB, 0xFFFD },
	{ 0x85AC, 0xFFFD },
	{ 0x85AD, 0xFFFD },
	{ 0x85AE, 0xFFFD },
	{ 0x85AF, 0xFFFD },
	{ 0x85B0, 0xFFFD },
	{ 0x85B1, 0xFFFD },
	{ 0x85B2, 0xFFFD },
	{ 0x85B3, 0xFFFD },
	{ 0x85B4, 0xFFFD },
	{ 0x85B5, 0xFFFD },
	{ 0x85B6, 0xFFFD },
	{ 0x85B7, 0xFFFD },
	{ 0x85B8, 0xFFFD },
	{ 0x85B9, 0xFFFD },
	{ 0x85BA, 0xFFFD },
	{ 0x85BB, 0xFFFD },
	{ 0x85BC, 0xFFFD },
	{ 0x85BD, 0xFFFD },
	{ 0x85BE, 0xFFFD },
	{ 0x85BF, 0xFFFD },
	{ 0x85C0, 0xFFFD },
	{ 0x85C1, 0xFFFD },
	{ 0x85C2, 0xFFFD },
	{ 0x85C3, 0xFFFD },
	{ 0x85C4, 0xFFFD },
	{ 0x85C5, 0xFFFD },
	{ 0x85C6, 0xFFFD },
	{ 0x85C7, 0xFFFD },
	{ 0x85C8, 0xFFFD },
	{ 0x85C9, 0xFFFD },
	{ 0x85CA, 0xFFFD },
	{ 0x85CB, 0xFFFD },
	{ 0x85CC, 0xFFFD },
	{ 0x85CD, 0xFFFD },
	{ 0x85CE, 0xFFFD },
	{ 0x85CF, 0xFFFD },
	{ 0x85D0, 0xFFFD },
	{ 0x85D1, 0xFFFD },
	{ 0x85D2, 0xFFFD },
	{ 0x85D3, 0xFFFD },
	{ 0x85D4, 0xFFFD },
	{ 0x85D5, 0xFFFD },
	{ 0x85D6, 0xFFFD },
	{ 0x85D7, 0xFFFD },
	{ 0x85D8, 0xFFFD },
	{ 0x85D9, 0xFFFD },
	{ 0x85DA, 0xFFFD },
	{ 0x85DB, 0xFFFD },
	{ 0x85DC, 0xFFFD },
	{ 0x85DD, 0xFFFD },
	{ 0x85DE, 0xFFFD },
	{ 0x85DF, 0xFFFD },
	{ 0x85E0, 0xFFFD },
	{ 0x85E1, 0xFFFD },
	{ 0x85E2, 0xFFFD },
	{ 0x85E3, 0xFFFD },
	{ 0x85E4, 0xFFFD },
	{ 0x85E5, 0xFFFD },
	{ 0x85E6, 0xFFFD },
	{ 0x85E7, 0xFFFD },
	{ 0x85E8, 0xFFFD },
	{ 0x85E9, 0xFFFD },
	{ 0x85EA, 0xFFFD },
	{ 0x85EB, 0xFFFD },
	{ 0x85EC, 0xFFFD },
	{ 0x85ED, 0xFFFD },
	{ 0x85EE, 0xFFFD },
	{ 0x85EF, 0xFFFD },
	{ 0x85F0, 0xFFFD },
	{ 0x85F1, 0xFFFD },
	{ 0x85F2, 0xFFFD },
	{ 0x85F3, 0xFFFD },
	{ 0x85F4, 0xFFFD },
	{ 0x85F5, 0xFFFD },
	{ 0x85F6, 0xFFFD },
	{ 0x85F7, 0xFFFD },
	{ 0x85F8, 0xFFFD },
	{ 0x85F9, 0xFFFD },
	{ 0x85FA, 0xFFFD },
	{ 0x85FB, 0xFFFD },
	{ 0x85FC, 0xFFFD },
	{ 0x85FD, 0xFFFD },
	{ 0x85FE, 0xFFFD },
	{ 0x8640, 0xFFFD },
	{ 0x8641, 0xFFFD },
	{ 0x8642, 0xFFFD },
	{ 0x8643, 0xFFFD },
	{ 0x8644, 0xFFFD },
	{ 0x8645, 0xFFFD },
	{ 0x8646, 0xFFFD },
	{ 0x8647, 0xFFFD },
	{ 0x8648, 0xFFFD },
	{ 0x8649, 0xFFFD },
	{ 0x864A, 0xFFFD },
	{ 0x864B, 0xFFFD },
	{ 0x864C, 0xFFFD },
	{ 0x864D, 0xFFFD },
	{ 0x864E, 0xFFFD },
	{ 0x864F, 0xFFFD },
	{ 0x8650, 0xFFFD },
	{ 0x8651, 0xFFFD },
	{ 0x8652, 0xFFFD },
	{ 0x8653, 0xFFFD },
	{ 0x8654, 0xFFFD },
	{ 0x8655, 0xFFFD },
	{ 0x8656, 0xFFFD },
	{ 0x8657, 0xFFFD },
	{ 0x8658, 0xFFFD },
	{ 0x8659, 0xFFFD },
	{ 0x865A, 0xFFFD },
	{ 0x865B, 0xFFFD },
	{ 0x865C, 0xFFFD },
	{ 0x865D, 0xFFFD },
	{ 0x865E, 0xFFFD },
	{ 0x865F, 0xFFFD },
	{ 0x8660, 0xFFFD },
	{ 0x8661, 0xFFFD },
	{ 0x8662, 0xFFFD },
	{ 0x8663, 0xFFFD },
	{ 0x8664, 0xFFFD },
	{ 0x8665, 0xFFFD },
	{ 0x8666, 0xFFFD },
	{ 0x8667, 0xFFFD },
	{ 0x8668, 0xFFFD },
	{ 0x8669, 0xFFFD },
	{ 0x866A, 0xFFFD },
	{ 0x866B, 0xFFFD },
	{ 0x866C, 0xFFFD },
	{ 0x866D, 0xFFFD },
	{ 0x866E, 0xFFFD },
	{ 0x866F, 0xFFFD },
	{ 0x8670, 0xFFFD },
	{ 0x8671, 0xFFFD },
	{ 0x8672, 0xFFFD },
	{ 0x8673, 0xFFFD },
	{ 0x8674, 0xFFFD },
	{ 0x8675, 0xFFFD },
	{ 0x8676, 0xFFFD },
	{ 0x8677, 0xFFFD },
	{ 0x8678, 0xFFFD },
	{ 0x8679, 0xFFFD },
	{ 0x867A, 0xFFFD },
	{ 0x867B, 0xFFFD },
	{ 0x867C, 0xFFFD },
	{ 0x867D, 0xFFFD },
	{ 0x867E, 0xFFFD },
	{ 0x867F, 0xFFFD },
	{ 0x8680, 0x620F },
	{ 0x8681, 0x625D },
	{ 0x8682, 0x625F },
	{ 0x8683, 0x6267 },
	{ 0x8684, 0x6257 },
	{ 0x8685, 0x9F50 },
	{ 0x8686, 0x65EB },
	{ 0x8687, 0x65EA },
	{ 0x8688, 0x6737 },
	{ 0x8689, 0x6732 },
	{ 0x868A, 0x6736 },
	{ 0x868B, 0x6B22 },
	{ 0x868C, 0x6BCE },
	{ 0x868D, 0x6C58 },
	{ 0x868E, 0x6C51 },
	{ 0x868F, 0x6C77 },
	{ 0x8690, 0x6C3C },
	{ 0x8691, 0x6C5A },
	{ 0x8692, 0x6C53 },
	{ 0x8693, 0x706F },
	{ 0x8694, 0x7072 },
	{ 0x8695, 0x706E },
	{ 0x8696, 0x7073 },
	{ 0x8697, 0x72B1 },
	{ 0x8698, 0x72B2 },
	{ 0x8699, 0x738F },
	{ 0x869A, 0x793C },
	{ 0x869B, 0x808D },
	{ 0x869C, 0x808E },
	{ 0x869D, 0x827B },
	{ 0x869E, 0x8D71 },
	{ 0x869F, 0x8FB9 },
	{ 0x86A0, 0x9096 },
	{ 0x86A1, 0xFFFD },
	{ 0x86A2, 0xFFFD },
	{ 0x86A3, 0xFFFD },
	{ 0x86A4, 0xFFFD },
	{ 0x86A5, 0xFFFD },
	{ 0x86A6, 0xFFFD },
	{ 0x86A7, 0xFFFD },
	{ 0x86A8, 0xFFFD },
	{ 0x86A9, 0xFFFD },
	{ 0x86AA, 0xFFFD },
	{ 0x86AB, 0xFFFD },
	{ 0x86AC, 0xFFFD },
	{ 0x86AD, 0xFFFD },
	{ 0x86AE, 0xFFFD },
	{ 0x86AF, 0xFFFD },
	{ 0x86B0, 0xFFFD },
	{ 0x86B1, 0xFFFD },
	{ 0x86B2, 0xFFFD },
	{ 0x86B3, 0xFFFD },
	{ 0x86B4, 0xFFFD },
	{ 0x86B5, 0xFFFD },
	{ 0x86B6, 0xFFFD },
	{ 0x86B7, 0xFFFD },
	{ 0x86B8, 0xFFFD },
	{ 0x86B9, 0xFFFD },
	{ 0x86BA, 0xFFFD },
	{ 0x86BB, 0xFFFD },
	{ 0x86BC, 0xFFFD },
	{ 0x86BD, 0xFFFD },
	{ 0x86BE, 0xFFFD },
	{ 0x86BF, 0xFFFD },
	{ 0x86C0, 0xFFFD },
	{ 0x86C1, 0xFFFD },
	{ 0x86C2, 0xFFFD },
	{ 0x86C3, 0xFFFD },
	{ 0x86C4, 0xFFFD },
	{ 0x86C5, 0xFFFD },
	{ 0x86C6, 0xFFFD },
	{ 0x86C7, 0xFFFD },
	{ 0x86C8, 0xFFFD },
	{ 0x86C9, 0xFFFD },
	{ 0x86CA, 0xFFFD },
	{ 0x86CB, 0xFFFD },
	{ 0x86CC, 0xFFFD },
	{ 0x86CD, 0xFFFD },
	{ 0x86CE, 0xFFFD },
	{ 0x86CF, 0xFFFD },
	{ 0x86D0, 0xFFFD },
	{ 0x86D1, 0xFFFD },
	{ 0x86D2, 0xFFFD },
	{ 0x86D3, 0xFFFD },
	{ 0x86D4, 0xFFFD },
	{ 0x86D5, 0xFFFD },
	{ 0x86D6, 0xFFFD },
	{ 0x86D7, 0xFFFD },
	{ 0x86D8, 0xFFFD },
	{ 0x86D9, 0xFFFD },
	{ 0x86DA, 0xFFFD },
	{ 0x86DB, 0xFFFD },
	{ 0x86DC, 0xFFFD },
	{ 0x86DD, 0xFFFD },
	{ 0x86DE, 0xFFFD },
	{ 0x86DF, 0xFFFD },
	{ 0x86E0, 0xFFFD },
	{ 0x86E1, 0xFFFD },
	{ 0x86E2, 0xFFFD },
	{ 0x86E3, 0xFFFD },
	{ 0x86E4, 0xFFFD },
	{ 0x86E5, 0xFFFD },
	{ 0x86E6, 0xFFFD },
	{ 0x86E7, 0xFFFD },
	{ 0x86E8, 0xFFFD },
	{ 0x86E9, 0xFFFD },
	{ 0x86EA, 0xFFFD },
	{ 0x86EB, 0xFFFD },
	{ 0x86EC, 0xFFFD },
	{ 0x86ED, 0xFFFD },
	{ 0x86EE, 0xFFFD },
	{ 0x86EF, 0xFFFD },
	{ 0x86F0, 0xFFFD },
	{ 0x86F1, 0xFFFD },
	{ 0x86F2, 0xFFFD },
	{ 0x86F3, 0xFFFD },
	{ 0x86F4, 0xFFFD },
	{ 0x86F5, 0xFFFD },
	{ 0x86F6, 0xFFFD },
	{ 0x86F7, 0xFFFD },
	{ 0x86F8, 0xFFFD },
	{ 0x86F9, 0xFFFD },
	{ 0x86FA, 0xFFFD },
	{ 0x86FB, 0xFFFD },
	{ 0x86FC, 0xFFFD },
	{ 0x86FD, 0xFFFD },
	{ 0x86FE, 0xFFFD },
	{ 0x8740, 0xFFFD },
	{ 0x8741, 0xFFFD },
	{ 0x8742, 0xFFFD },
	{ 0x8743, 0xFFFD },
	{ 0x8744, 0xFFFD },
	{ 0x8745, 0xFFFD },
	{ 0x8746, 0xFFFD },
	{ 0x8747, 0xFFFD },
	{ 0x8748, 0xFFFD },
	{ 0x8749, 0xFFFD },
	{ 0x874A, 0xFFFD },
	{ 0x874B, 0xFFFD },
	{ 0x874C, 0xFFFD },
	{ 0x874D, 0xFFFD },
	{ 0x874E, 0xFFFD },
	{ 0x874F, 0xFFFD },
	{ 0x8750, 0xFFFD },
	{ 0x8751, 0xFFFD },
	{ 0x8752, 0xFFFD },
	{ 0x8753, 0xFFFD },
	{ 0x8754, 0xFFFD },
	{ 0x8755, 0xFFFD },
	{ 0x8756, 0xFFFD },
	{ 0x8757, 0xFFFD },
	{ 0x8758, 0xFFFD },
	{ 0x8759, 0xFFFD },
	{ 0x875A, 0xFFFD },
	{ 0x875B, 0xFFFD },
	{ 0x875C, 0xFFFD },
	{ 0x875D, 0xFFFD },
	{ 0x875E, 0xFFFD },
	{ 0x875F, 0xFFFD },
	{ 0x8760, 0xFFFD },
	{ 0x8761, 0xFFFD },
	{ 0x8762, 0xFFFD },
	{ 0x8763, 0xFFFD },
	{ 0x8764, 0xFFFD },
	{ 0x8765, 0xFFFD },
	{ 0x8766, 0xFFFD },
	{ 0x8767, 0xFFFD },
	{ 0x8768, 0xFFFD },
	{ 0x8769, 0xFFFD },
	{ 0x876A, 0xFFFD },
	{ 0x876B, 0xFFFD },
	{ 0x876C, 0xFFFD },
	{ 0x876D, 0xFFFD },
	{ 0x876E, 0xFFFD },
	{ 0x876F, 0xFFFD },
	{ 0x8770, 0xFFFD },
	{ 0x8771, 0xFFFD },
	{ 0x8772, 0xFFFD },
	{ 0x8773, 0xFFFD },
	{ 0x8774, 0xFFFD },
	{ 0x8775, 0xFFFD },
	{ 0x8776, 0xFFFD },
	{ 0x8777, 0xFFFD },
	{ 0x8778, 0xFFFD },
	{ 0x8779, 0xFFFD },
	{ 0x877A, 0xFFFD },
	{ 0x877B, 0xFFFD },
	{ 0x877C, 0xFFFD },
	{ 0x877D, 0xFFFD },
	{ 0x877E, 0xFFFD },
	{ 0x877F, 0xFFFD },
	{ 0x8780, 0x909A },
	{ 0x8781, 0x4E24 },
	{ 0x8782, 0x4E71 },
	{ 0x8783, 0x4E9C },
	{ 0x8784, 0x4F45 },
	{ 0x8785, 0x4F4A },
	{ 0x8786, 0x4F39 },
	{ 0x8787, 0x4F37 },
	{ 0x8788, 0x4F32 },
	{ 0x8789, 0x4F42 },
	{ 0x878A, 0x4F44 },
	{ 0x878B, 0x4F4B },
	{ 0x878C, 0x4F40 },
	{ 0x878D, 0x4F35 },
	{ 0x878E, 0x4F31 },
	{ 0x878F, 0x5151 },
	{ 0x8790, 0x5150 },
	{ 0x8791, 0x514E },
	{ 0x8792, 0x519D },
	{ 0x8793, 0x51B5 },
	{ 0x8794, 0x51B8 },
	{ 0x8795, 0x51EC },
	{ 0x8796, 0x5223 },
	{ 0x8797, 0x5227 },
	{ 0x8798, 0x5226 },
	{ 0x8799, 0x521F },
	{ 0x879A, 0x522B },
	{ 0x879B, 0x5220 },
	{ 0x879C, 0x52B4 },
	{ 0x879D, 0x52B3 },
	{ 0x879E, 0x5325 },
	{ 0x879F, 0x533B },
	{ 0x87A0, 0x5374 },
	{ 0x87A1, 0xFFFD },
	{ 0x87A2, 0xFFFD },
	{ 0x87A3, 0xFFFD },
	{ 0x87A4, 0xFFFD },
	{ 0x87A5, 0xFFFD },
	{ 0x87A6, 0xFFFD },
	{ 0x87A7, 0xFFFD },
	{ 0x87A8, 0xFFFD },
	{ 0x87A9, 0xFFFD },
	{ 0x87AA, 0xFFFD },
	{ 0x87AB, 0xFFFD },
	{ 0x87AC, 0xFFFD },
	{ 0x87AD, 0xFFFD },
	{ 0x87AE, 0xFFFD },
	{ 0x87AF, 0xFFFD },
	{ 0x87B0, 0xFFFD },
	{ 0x87B1, 0xFFFD },
	{ 0x87B2, 0xFFFD },
	{ 0x87B3, 0xFFFD },
	{ 0x87B4, 0xFFFD },
	{ 0x87B5, 0xFFFD },
	{ 0x87B6, 0xFFFD },
	{ 0x87B7, 0xFFFD },
	{ 0x87B8, 0xFFFD },
	{ 0x87B9, 0xFFFD },
	{ 0x87BA, 0xFFFD },
	{ 0x87BB, 0xFFFD },
	{ 0x87BC, 0xFFFD },
	{ 0x87BD, 0xFFFD },
	{ 0x87BE, 0xFFFD },
	{ 0x87BF, 0xFFFD },
	{ 0x87C0, 0xFFFD },
	{ 0x87C1, 0xFFFD },
	{ 0x87C2, 0xFFFD },
	{ 0x87C3, 0xFFFD },
	{ 0x87C4, 0xFFFD },
	{ 0x87C5, 0xFFFD },
	{ 0x87C6, 0xFFFD },
	{ 0x87C7, 0xFFFD },
	{ 0x87C8, 0xFFFD },
	{ 0x87C9, 0xFFFD },
	{ 0x87CA, 0xFFFD },
	{ 0x87CB, 0xFFFD },
	{ 0x87CC, 0xFFFD },
	{ 0x87CD, 0xFFFD },
	{ 0x87CE, 0xFFFD },
	{ 0x87CF, 0xFFFD },
	{ 0x87D0, 0xFFFD },
	{ 0x87D1, 0xFFFD },
	{ 0x87D2, 0xFFFD },
	{ 0x87D3, 0xFFFD },
	{ 0x87D4, 0xFFFD },
	{ 0x87D5, 0xFFFD },
	{ 0x87D6, 0xFFFD },
	{ 0x87D7, 0xFFFD },
	{ 0x87D8, 0xFFFD },
	{ 0x87D9, 0xFFFD },
	{ 0x87DA, 0xFFFD },
	{ 0x87DB, 0xFFFD },
	{ 0x87DC, 0xFFFD },
	{ 0x87DD, 0xFFFD },
	{ 0x87DE, 0xFFFD },
	{ 0x87DF, 0xFFFD },
	{ 0x87E0, 0xFFFD },
	{ 0x87E1, 0xFFFD },
	{ 0x87E2, 0xFFFD },
	{ 0x87E3, 0xFFFD },
	{ 0x87E4, 0xFFFD },
	{ 0x87E5, 0xFFFD },
	{ 0x87E6, 0xFFFD },
	{ 0x87E7, 0xFFFD },
	{ 0x87E8, 0xFFFD },
	{ 0x87E9, 0xFFFD },
	{ 0x87EA, 0xFFFD },
	{ 0x87EB, 0xFFFD },
	{ 0x87EC, 0xFFFD },
	{ 0x87ED, 0xFFFD },
	{ 0x87EE, 0xFFFD },
	{ 0x87EF, 0xFFFD },
	{ 0x87F0, 0xFFFD },
	{ 0x87F1, 0xFFFD },
	{ 0x87F2, 0xFFFD },
	{ 0x87F3, 0xFFFD },
	{ 0x87F4, 0xFFFD },
	{ 0x87F5, 0xFFFD },
	{ 0x87F6, 0xFFFD },
	{ 0x87F7, 0xFFFD },
	{ 0x87F8, 0xFFFD },
	{ 0x87F9, 0xFFFD },
	{ 0x87FA, 0xFFFD },
	{ 0x87FB, 0xFFFD },
	{ 0x87FC, 0xFFFD },
	{ 0x87FD, 0xFFFD },
	{ 0x87FE, 0xFFFD },
	{ 0x8840, 0xFFFD },
	{ 0x8841, 0xFFFD },
	{ 0x8842, 0xFFFD },
	{ 0x8843, 0xFFFD },
	{ 0x8844, 0xFFFD },
	{ 0x8845, 0xFFFD },
	{ 0x8846, 0xFFFD },
	{ 0x8847, 0xFFFD },
	{ 0x8848, 0xFFFD },
	{ 0x8849, 0xFFFD },
	{ 0x884A, 0xFFFD },
	{ 0x884B, 0xFFFD },
	{ 0x884C, 0xFFFD },
	{ 0x884D, 0xFFFD },
	{ 0x884E, 0xFFFD },
	{ 0x884F, 0xFFFD },
	{ 0x8850, 0xFFFD },
	{ 0x8851, 0xFFFD },
	{ 0x8852, 0xFFFD },
	{ 0x8853, 0xFFFD },
	{ 0x8854, 0xFFFD },
	{ 0x8855, 0xFFFD },
	{ 0x8856, 0xFFFD },
	{ 0x8857, 0xFFFD },
	{ 0x8858, 0xFFFD },
	{ 0x8859, 0xFFFD },
	{ 0x885A, 0xFFFD },
	{ 0x885B, 0xFFFD },
	{ 0x885C, 0xFFFD },
	{ 0x885D, 0xFFFD },
	{ 0x885E, 0xFFFD },
	{ 0x885F, 0xFFFD },
	{ 0x8860, 0xFFFD },
	{ 0x8861, 0xFFFD },
	{ 0x8862, 0xFFFD },
	{ 0x8863, 0xFFFD },
	{ 0x8864, 0xFFFD },
	{ 0x8865, 0xFFFD },
	{ 0x8866, 0xFFFD },
	{ 0x8867, 0xFFFD },
	{ 0x8868, 0xFFFD },
	{ 0x8869, 0xFFFD },
	{ 0x886A, 0xFFFD },
	{ 0x886B, 0xFFFD },
	{ 0x886C, 0xFFFD },
	{ 0x886D, 0xFFFD },
	{ 0x886E, 0xFFFD },
	{ 0x886F, 0xFFFD },
	{ 0x8870, 0xFFFD },
	{ 0x8871, 0xFFFD },
	{ 0x8872, 0xFFFD },
	{ 0x8873, 0xFFFD },
	{ 0x8874, 0xFFFD },
	{ 0x8875, 0xFFFD },
	{ 0x8876, 0xFFFD },
	{ 0x8877, 0xFFFD },
	{ 0x8878, 0xFFFD },
	{ 0x8879, 0xFFFD },
	{ 0x887A, 0xFFFD },
	{ 0x887B, 0xFFFD },
	{ 0x887C, 0xFFFD },
	{ 0x887D, 0xFFFD },
	{ 0x887E, 0xFFFD },
	{ 0x887F, 0xFFFD },
	{ 0x8880, 0x544D },
	{ 0x8881, 0x543A },
	{ 0x8882, 0x5444 },
	{ 0x8883, 0x544C },
	{ 0x8884, 0x5423 },
	{ 0x8885, 0x541A },
	{ 0x8886, 0x5432 },
	{ 0x8887, 0x544B },
	{ 0x8888, 0x5421 },
	{ 0x8889, 0x5434 },
	{ 0x888A, 0x5449 },
	{ 0x888B, 0x5450 },
	{ 0x888C, 0x5422 },
	{ 0x888D, 0x543F },
	{ 0x888E, 0x5451 },
	{ 0x888F, 0x545A },
	{ 0x8890, 0x542F },
	{ 0x8891, 0x56E9 },
	{ 0x8892, 0x56F2 },
	{ 0x8893, 0x56F3 },
	{ 0x8894, 0x56EF },
	{ 0x8895, 0x56ED },
	{ 0x8896, 0x56EC },
	{ 0x8897, 0x56E6 },
	{ 0x8898, 0x5748 },
	{ 0x8899, 0x5744 },
	{ 0x889A, 0x573F },
	{ 0x889B, 0x573C },
	{ 0x889C, 0x5753 },
	{ 0x889D, 0x5756 },
	{ 0x889E, 0x575F },
	{ 0x889F, 0x5743 },
	{ 0x88A0, 0x5758 },
	{ 0x88A1, 0xFFFD },
	{ 0x88A2, 0xFFFD },
	{ 0x88A3, 0xFFFD },
	{ 0x88A4, 0xFFFD },
	{ 0x88A5, 0xFFFD },
	{ 0x88A6, 0xFFFD },
	{ 0x88A7, 0xFFFD },
	{ 0x88A8, 0xFFFD },
	{ 0x88A9, 0xFFFD },
	{ 0x88AA, 0xFFFD },
	{ 0x88AB, 0xFFFD },
	{ 0x88AC, 0xFFFD },
	{ 0x88AD, 0xFFFD },
	{ 0x88AE, 0xFFFD },
	{ 0x88AF, 0xFFFD },
	{ 0x88B0, 0xFFFD },
	{ 0x88B1, 0xFFFD },
	{ 0x88B2, 0xFFFD },
	{ 0x88B3, 0xFFFD },
	{ 0x88B4, 0xFFFD },
	{ 0x88B5, 0xFFFD },
	{ 0x88B6, 0xFFFD },
	{ 0x88B7, 0xFFFD },
	{ 0x88B8, 0xFFFD },
	{ 0x88B9, 0xFFFD },
	{ 0x88BA, 0xFFFD },
	{ 0x88BB, 0xFFFD },
	{ 0x88BC, 0xFFFD },
	{ 0x88BD, 0xFFFD },
	{ 0x88BE, 0xFFFD },
	{ 0x88BF, 0xFFFD },
	{ 0x88C0, 0xFFFD },
	{ 0x88C1, 0xFFFD },
	{ 0x88C2, 0xFFFD },
	{ 0x88C3, 0xFFFD },
	{ 0x88C4, 0xFFFD },
	{ 0x88C5, 0xFFFD },
	{ 0x88C6, 0xFFFD },
	{ 0x88C7, 0xFFFD },
	{ 0x88C8, 0xFFFD },
	{ 0x88C9, 0xFFFD },
	{ 0x88CA, 0xFFFD },
	{ 0x88CB, 0xFFFD },
	{ 0x88CC, 0xFFFD },
	{ 0x88CD, 0xFFFD },
	{ 0x88CE, 0xFFFD },
	{ 0x88CF, 0xFFFD },
	{ 0x88D0, 0xFFFD },
	{ 0x88D1, 0xFFFD },
	{ 0x88D2, 0xFFFD },
	{ 0x88D3, 0xFFFD },
	{ 0x88D4, 0xFFFD },
	{ 0x88D5, 0xFFFD },
	{ 0x88D6, 0xFFFD },
	{ 0x88D7, 0xFFFD },
	{ 0x88D8, 0xFFFD },
	{ 0x88D9, 0xFFFD },
	{ 0x88DA, 0xFFFD },
	{ 0x88DB, 0xFFFD },
	{ 0x88DC, 0xFFFD },
	{ 0x88DD, 0xFFFD },
	{ 0x88DE, 0xFFFD },
	{ 0x88DF, 0xFFFD },
	{ 0x88E0, 0xFFFD },
	{ 0x88E1, 0xFFFD },
	{ 0x88E2, 0xFFFD },
	{ 0x88E3, 0xFFFD },
	{ 0x88E4, 0xFFFD },
	{ 0x88E5, 0xFFFD },
	{ 0x88E6, 0xFFFD },
	{ 0x88E7, 0xFFFD },
	{ 0x88E8, 0xFFFD },
	{ 0x88E9, 0xFFFD },
	{ 0x88EA, 0xFFFD },
	{ 0x88EB, 0xFFFD },
	{ 0x88EC, 0xFFFD },
	{ 0x88ED, 0xFFFD },
	{ 0x88EE, 0xFFFD },
	{ 0x88EF, 0xFFFD },
	{ 0x88F0, 0xFFFD },
	{ 0x88F1, 0xFFFD },
	{ 0x88F2, 0xFFFD },
	{ 0x88F3, 0xFFFD },
	{ 0x88F4, 0xFFFD },
	{ 0x88F5, 0xFFFD },
	{ 0x88F6, 0xFFFD },
	{ 0x88F7, 0xFFFD },
	{ 0x88F8, 0xFFFD },
	{ 0x88F9, 0xFFFD },
	{ 0x88FA, 0xFFFD },
	{ 0x88FB, 0xFFFD },
	{ 0x88FC, 0xFFFD },
	{ 0x88FD, 0xFFFD },
	{ 0x88FE, 0xFFFD },
	{ 0x8940, 0xFFFD },
	{ 0x8941, 0xFFFD },
	{ 0x8942, 0xFFFD },
	{ 0x8943, 0xFFFD },
	{ 0x8944, 0xFFFD },
	{ 0x8945, 0xFFFD },
	{ 0x8946, 0xFFFD },
	{ 0x8947, 0xFFFD },
	{ 0x8948, 0xFFFD },
	{ 0x8949, 0xFFFD },
	{ 0x894A, 0xFFFD },
	{ 0x894B, 0xFFFD },
	{ 0x894C, 0xFFFD },
	{ 0x894D, 0xFFFD },
	{ 0x894E, 0xFFFD },
	{ 0x894F, 0xFFFD },
	{ 0x8950, 0xFFFD },
	{ 0x8951, 0xFFFD },
	{ 0x8952, 0xFFFD },
	{ 0x8953, 0xFFFD },
	{ 0x8954, 0xFFFD },
	{ 0x8955, 0xFFFD },
	{ 0x8956, 0xFFFD },
	{ 0x8957, 0xFFFD },
	{ 0x8958, 0xFFFD },
	{ 0x8959, 0xFFFD },
	{ 0x895A, 0xFFFD },
	{ 0x895B, 0xFFFD },
	{ 0x895C, 0xFFFD },
	{ 0x895D, 0xFFFD },
	{ 0x895E, 0xFFFD },
	{ 0x895F, 0xFFFD },
	{ 0x8960, 0xFFFD },
	{ 0x8961, 0xFFFD },
	{ 0x8962, 0xFFFD },
	{ 0x8963, 0xFFFD },
	{ 0x8964, 0xFFFD },
	{ 0x8965, 0xFFFD },
	{ 0x8966, 0xFFFD },
	{ 0x8967, 0xFFFD },
	{ 0x8968, 0xFFFD },
	{ 0x8969, 0xFFFD },
	{ 0x896A, 0xFFFD },
	{ 0x896B, 0xFFFD },
	{ 0x896C, 0xFFFD },
	{ 0x896D, 0xFFFD },
	{ 0x896E, 0xFFFD },
	{ 0x896F, 0xFFFD },
	{ 0x8970, 0xFFFD },
	{ 0x8971, 0xFFFD },
	{ 0x8972, 0xFFFD },
	{ 0x8973, 0xFFFD },
	{ 0x8974, 0xFFFD },
	{ 0x8975, 0xFFFD },
	{ 0x8976, 0xFFFD },
	{ 0x8977, 0xFFFD },
	{ 0x8978, 0xFFFD },
	{ 0x8979, 0xFFFD },
	{ 0x897A, 0xFFFD },
	{ 0x897B, 0xFFFD },
	{ 0x897C, 0xFFFD },
	{ 0x897D, 0xFFFD },
	{ 0x897E, 0xFFFD },
	{ 0x897F, 0xFFFD },
	{ 0x8980, 0x5757 },
	{ 0x8981, 0x5746 },
	{ 0x8982, 0x573D },
	{ 0x8983, 0x5742 },
	{ 0x8984, 0x5754 },
	{ 0x8985, 0x5755 },
	{ 0x8986, 0x58F1 },
	{ 0x8987, 0x58F2 },
	{ 0x8988, 0x58F0 },
	{ 0x8989, 0x590B },
	{ 0x898A, 0x9EA6 },
	{ 0x898B, 0x56F1 },
	{ 0x898C, 0x593D },
	{ 0x898D, 0x5994 },
	{ 0x898E, 0x598C },
	{ 0x898F, 0x599C },
	{ 0x8990, 0x599F },
	{ 0x8991, 0x599B },
	{ 0x8992, 0x5989 },
	{ 0x8993, 0x599A },
	{ 0x8994, 0x6588 },
	{ 0x8995, 0x5B8D },
	{ 0x8996, 0x5BFE },
	{ 0x8997, 0x5BFF },
	{ 0x8998, 0x5BFD },
	{ 0x8999, 0x5C2B },
	{ 0x899A, 0x5C84 },
	{ 0x899B, 0x5C8E },
	{ 0x899C, 0x5C9C },
	{ 0x899D, 0x5C85 },
	{ 0x899E, 0x5DF5 },
	{ 0x899F, 0x5E09 },
	{ 0x89A0, 0x5E0B },
	{ 0x89A1, 0xFFFD },
	{ 0x89A2, 0xFFFD },
	{ 0x89A3, 0xFFFD },
	{ 0x89A4, 0xFFFD },
	{ 0x89A5, 0xFFFD },
	{ 0x89A6, 0xFFFD },
	{ 0x89A7, 0xFFFD },
	{ 0x89A8, 0xFFFD },
	{ 0x89A9, 0xFFFD },
	{ 0x89AA, 0xFFFD },
	{ 0x89AB, 0xFFFD },
	{ 0x89AC, 0xFFFD },
	{ 0x89AD, 0xFFFD },
	{ 0x89AE, 0xFFFD },
	{ 0x89AF, 0xFFFD },
	{ 0x89B0, 0xFFFD },
	{ 0x89B1, 0xFFFD },
	{ 0x89B2, 0xFFFD },
	{ 0x89B3, 0xFFFD },
	{ 0x89B4, 0xFFFD },
	{ 0x89B5, 0xFFFD },
	{ 0x89B6, 0xFFFD },
	{ 0x89B7, 0xFFFD },
	{ 0x89B8, 0xFFFD },
	{ 0x89B9, 0xFFFD },
	{ 0x89BA, 0xFFFD },
	{ 0x89BB, 0xFFFD },
	{ 0x89BC, 0xFFFD },
	{ 0x89BD, 0xFFFD },
	{ 0x89BE, 0xFFFD },
	{ 0x89BF, 0xFFFD },
	{ 0x89C0, 0xFFFD },
	{ 0x89C1, 0xFFFD },
	{ 0x89C2, 0xFFFD },
	{ 0x89C3, 0xFFFD },
	{ 0x89C4, 0xFFFD },
	{ 0x89C5, 0xFFFD },
	{ 0x89C6, 0xFFFD },
	{ 0x89C7, 0xFFFD },
	{ 0x89C8, 0xFFFD },
	{ 0x89C9, 0xFFFD },
	{ 0x89CA, 0xFFFD },
	{ 0x89CB, 0xFFFD },
	{ 0x89CC, 0xFFFD },
	{ 0x89CD, 0xFFFD },
	{ 0x89CE, 0xFFFD },
	{ 0x89CF, 0xFFFD },
	{ 0x89D0, 0xFFFD },
	{ 0x89D1, 0xFFFD },
	{ 0x89D2, 0xFFFD },
	{ 0x89D3, 0xFFFD },
	{ 0x89D4, 0xFFFD },
	{ 0x89D5, 0xFFFD },
	{ 0x89D6, 0xFFFD },
	{ 0x89D7, 0xFFFD },
	{ 0x89D8, 0xFFFD },
	{ 0x89D9, 0xFFFD },
	{ 0x89DA, 0xFFFD },
	{ 0x89DB, 0xFFFD },
	{ 0x89DC, 0xFFFD },
	{ 0x89DD, 0xFFFD },
	{ 0x89DE, 0xFFFD },
	{ 0x89DF, 0xFFFD },
	{ 0x89E0, 0xFFFD },
	{ 0x89E1, 0xFFFD },
	{ 0x89E2, 0xFFFD },
	{ 0x89E3, 0xFFFD },
	{ 0x89E4, 0xFFFD },
	{ 0x89E5, 0xFFFD },
	{ 0x89E6, 0xFFFD },
	{ 0x89E7, 0xFFFD },
	{ 0x89E8, 0xFFFD },
	{ 0x89E9, 0xFFFD },
	{ 0x89EA, 0xFFFD },
	{ 0x89EB, 0xFFFD },
	{ 0x89EC, 0xFFFD },
	{ 0x89ED, 0xFFFD },
	{ 0x89EE, 0xFFFD },
	{ 0x89EF, 0xFFFD },
	{ 0x89F0, 0xFFFD },
	{ 0x89F1, 0xFFFD },
	{ 0x89F2, 0xFFFD },
	{ 0x89F3, 0xFFFD },
	{ 0x89F4, 0xFFFD },
	{ 0x89F5, 0xFFFD },
	{ 0x89F6, 0xFFFD },
	{ 0x89F7, 0xFFFD },
	{ 0x89F8, 0xFFFD },
	{ 0x89F9, 0xFFFD },
	{ 0x89FA, 0xFFFD },
	{ 0x89FB, 0xFFFD },
	{ 0x89FC, 0xFFFD },
	{ 0x89FD, 0xFFFD },
	{ 0x89FE, 0xFFFD },
	{ 0x8A40, 0xFFFD },
	{ 0x8A41, 0xFFFD },
	{ 0x8A42, 0xFFFD },
	{ 0x8A43, 0xFFFD },
	{ 0x8A44, 0xFFFD },
	{ 0x8A45, 0xFFFD },
	{ 0x8A46, 0xFFFD },
	{ 0x8A47, 0xFFFD },
	{ 0x8A48, 0xFFFD },
	{ 0x8A49, 0xFFFD },
	{ 0x8A4A, 0xFFFD },
	{ 0x8A4B, 0xFFFD },
	{ 0x8A4C, 0xFFFD },
	{ 0x8A4D, 0xFFFD },
	{ 0x8A4E, 0xFFFD },
	{ 0x8A4F, 0xFFFD },
	{ 0x8A50, 0xFFFD },
	{ 0x8A51, 0xFFFD },
	{ 0x8A52, 0xFFFD },
	{ 0x8A53, 0xFFFD },
	{ 0x8A54, 0xFFFD },
	{ 0x8A55, 0xFFFD },
	{ 0x8A56, 0xFFFD },
	{ 0x8A57, 0xFFFD },
	{ 0x8A58, 0xFFFD },
	{ 0x8A59, 0xFFFD },
	{ 0x8A5A, 0xFFFD },
	{ 0x8A5B, 0xFFFD },
	{ 0x8A5C, 0xFFFD },
	{ 0x8A5D, 0xFFFD },
	{ 0x8A5E, 0xFFFD },
	{ 0x8A5F, 0xFFFD },
	{ 0x8A60, 0xFFFD },
	{ 0x8A61, 0xFFFD },
	{ 0x8A62, 0xFFFD },
	{ 0x8A63, 0xFFFD },
	{ 0x8A64, 0xFFFD },
	{ 0x8A65, 0xFFFD },
	{ 0x8A66, 0xFFFD },
	{ 0x8A67, 0xFFFD },
	{ 0x8A68, 0xFFFD },
	{ 0x8A69, 0xFFFD },
	{ 0x8A6A, 0xFFFD },
	{ 0x8A6B, 0xFFFD },
	{ 0x8A6C, 0xFFFD },
	{ 0x8A6D, 0xFFFD },
	{ 0x8A6E, 0xFFFD },
	{ 0x8A6F, 0xFFFD },
	{ 0x8A70, 0xFFFD },
	{ 0x8A71, 0xFFFD },
	{ 0x8A72, 0xFFFD },
	{ 0x8A73, 0xFFFD },
	{ 0x8A74, 0xFFFD },
	{ 0x8A75, 0xFFFD },
	{ 0x8A76, 0xFFFD },
	{ 0x8A77, 0xFFFD },
	{ 0x8A78, 0xFFFD },
	{ 0x8A79, 0xFFFD },
	{ 0x8A7A, 0xFFFD },
	{ 0x8A7B, 0xFFFD },
	{ 0x8A7C, 0xFFFD },
	{ 0x8A7D, 0xFFFD },
	{ 0x8A7E, 0xFFFD },
	{ 0x8A7F, 0xFFFD },
	{ 0x8A80, 0x5E92 },
	{ 0x8A81, 0x5E90 },
	{ 0x8A82, 0x5F03 },
	{ 0x8A83, 0x5F1E },
	{ 0x8A84, 0x5F63 },
	{ 0x8A85, 0x5FE7 },
	{ 0x8A86, 0x5FFE },
	{ 0x8A87, 0x5FE6 },
	{ 0x8A88, 0x5FDC },
	{ 0x8A89, 0x5FCE },
	{ 0x8A8A, 0x5FFC },
	{ 0x8A8B, 0x5FDF },
	{ 0x8A8C, 0x5FEC },
	{ 0x8A8D, 0x5FF6 },
	{ 0x8A8E, 0x5FF2 },
	{ 0x8A8F, 0x5FF0 },
	{ 0x8A90, 0x5FF9 },
	{ 0x8A91, 0x6213 },
	{ 0x8A92, 0x623B },
	{ 0x8A93, 0x623C },
	{ 0x8A94, 0x6282 },
	{ 0x8A95, 0x6278 },
	{ 0x8A96, 0x628B },
	{ 0x8A97, 0x629E },
	{ 0x8A98, 0x62A5 },
	{ 0x8A99, 0x629B },
	{ 0x8A9A, 0x629C },
	{ 0x8A9B, 0x6299 },
	{ 0x8A9C, 0x628D },
	{ 0x8A9D, 0x6285 },
	{ 0x8A9E, 0x629D },
	{ 0x8A9F, 0x6275 },
	{ 0x8AA0, 0x65F6 },
	{ 0x8AA1, 0xFFFD },
	{ 0x8AA2, 0xFFFD },
	{ 0x8AA3, 0xFFFD },
	{ 0x8AA4, 0xFFFD },
	{ 0x8AA5, 0xFFFD },
	{ 0x8AA6, 0xFFFD },
	{ 0x8AA7, 0xFFFD },
	{ 0x8AA8, 0xFFFD },
	{ 0x8AA9, 0xFFFD },
	{ 0x8AAA, 0xFFFD },
	{ 0x8AAB, 0xFFFD },
	{ 0x8AAC, 0xFFFD },
	{ 0x8AAD, 0xFFFD },
	{ 0x8AAE, 0xFFFD },
	{ 0x8AAF, 0xFFFD },
	{ 0x8AB0, 0xFFFD },
	{ 0x8AB1, 0xFFFD },
	{ 0x8AB2, 0xFFFD },
	{ 0x8AB3, 0xFFFD },
	{ 0x8AB4, 0xFFFD },
	{ 0x8AB5, 0xFFFD },
	{ 0x8AB6, 0xFFFD },
	{ 0x8AB7, 0xFFFD },
	{ 0x8AB8, 0xFFFD },
	{ 0x8AB9, 0xFFFD },
	{ 0x8ABA, 0xFFFD },
	{ 0x8ABB, 0xFFFD },
	{ 0x8ABC, 0xFFFD },
	{ 0x8ABD, 0xFFFD },
	{ 0x8ABE, 0xFFFD },
	{ 0x8ABF, 0xFFFD },
	{ 0x8AC0, 0xFFFD },
	{ 0x8AC1, 0xFFFD },
	{ 0x8AC2, 0xFFFD },
	{ 0x8AC3, 0xFFFD },
	{ 0x8AC4, 0xFFFD },
	{ 0x8AC5, 0xFFFD },
	{ 0x8AC6, 0xFFFD },
	{ 0x8AC7, 0xFFFD },
	{ 0x8AC8, 0xFFFD },
	{ 0x8AC9, 0xFFFD },
	{ 0x8ACA, 0xFFFD },
	{ 0x8ACB, 0xFFFD },
	{ 0x8ACC, 0xFFFD },
	{ 0x8ACD, 0xFFFD },
	{ 0x8ACE, 0xFFFD },
	{ 0x8ACF, 0xFFFD },
	{ 0x8AD0, 0xFFFD },
	{ 0x8AD1, 0xFFFD },
	{ 0x8AD2, 0xFFFD },
	{ 0x8AD3, 0xFFFD },
	{ 0x8AD4, 0xFFFD },
	{ 0x8AD5, 0xFFFD },
	{ 0x8AD6, 0xFFFD },
	{ 0x8AD7, 0xFFFD },
	{ 0x8AD8, 0xFFFD },
	{ 0x8AD9, 0xFFFD },
	{ 0x8ADA, 0xFFFD },
	{ 0x8ADB, 0xFFFD },
	{ 0x8ADC, 0xFFFD },
	{ 0x8ADD, 0xFFFD },
	{ 0x8ADE, 0xFFFD },
	{ 0x8ADF, 0xFFFD },
	{ 0x8AE0, 0xFFFD },
	{ 0x8AE1, 0xFFFD },
	{ 0x8AE2, 0xFFFD },
	{ 0x8AE3, 0xFFFD },
	{ 0x8AE4, 0xFFFD },
	{ 0x8AE5, 0xFFFD },
	{ 0x8AE6, 0xFFFD },
	{ 0x8AE7, 0xFFFD },
	{ 0x8AE8, 0xFFFD },
	{ 0x8AE9, 0xFFFD },
	{ 0x8AEA, 0xFFFD },
	{ 0x8AEB, 0xFFFD },
	{ 0x8AEC, 0xFFFD },
	{ 0x8AED, 0xFFFD },
	{ 0x8AEE, 0xFFFD },
	{ 0x8AEF, 0xFFFD },
	{ 0x8AF0, 0xFFFD },
	{ 0x8AF1, 0xFFFD },
	{ 0x8AF2, 0xFFFD },
	{ 0x8AF3, 0xFFFD },
	{ 0x8AF4, 0xFFFD },
	{ 0x8AF5, 0xFFFD },
	{ 0x8AF6, 0xFFFD },
	{ 0x8AF7, 0xFFFD },
	{ 0x8AF8, 0xFFFD },
	{ 0x8AF9, 0xFFFD },
	{ 0x8AFA, 0xFFFD },
	{ 0x8AFB, 0xFFFD },
	{ 0x8AFC, 0xFFFD },
	{ 0x8AFD, 0xFFFD },
	{ 0x8AFE, 0xFFFD },
	{ 0x8B40, 0xFFFD },
	{ 0x8B41, 0xFFFD },
	{ 0x8B42, 0xFFFD },
	{ 0x8B43, 0xFFFD },
	{ 0x8B44, 0xFFFD },
	{ 0x8B45, 0xFFFD },
	{ 0x8B46, 0xFFFD },
	{ 0x8B47, 0xFFFD },
	{ 0x8B48, 0xFFFD },
	{ 0x8B49, 0xFFFD },
	{ 0x8B4A, 0xFFFD },
	{ 0x8B4B, 0xFFFD },
	{ 0x8B4C, 0xFFFD },
	{ 0x8B4D, 0xFFFD },
	{ 0x8B4E, 0xFFFD },
	{ 0x8B4F, 0xFFFD },
	{ 0x8B50, 0xFFFD },
	{ 0x8B51, 0xFFFD },
	{ 0x8B52, 0xFFFD },
	{ 0x8B53, 0xFFFD },
	{ 0x8B54, 0xFFFD },
	{ 0x8B55, 0xFFFD },
	{ 0x8B56, 0xFFFD },
	{ 0x8B57, 0xFFFD },
	{ 0x8B58, 0xFFFD },
	{ 0x8B59, 0xFFFD },
	{ 0x8B5A, 0xFFFD },
	{ 0x8B5B, 0xFFFD },
	{ 0x8B5C, 0xFFFD },
	{ 0x8B5D, 0xFFFD },
	{ 0x8B5E, 0xFFFD },
	{ 0x8B5F, 0xFFFD },
	{ 0x8B60, 0xFFFD },
	{ 0x8B61, 0xFFFD },
	{ 0x8B62, 0xFFFD },
	{ 0x8B63, 0xFFFD },
	{ 0x8B64, 0xFFFD },
	{ 0x8B65, 0xFFFD },
	{ 0x8B66, 0xFFFD },
	{ 0x8B67, 0xFFFD },
	{ 0x8B68, 0xFFFD },
	{ 0x8B69, 0xFFFD },
	{ 0x8B6A, 0xFFFD },
	{ 0x8B6B, 0xFFFD },
	{ 0x8B6C, 0xFFFD },
	{ 0x8B6D, 0xFFFD },
	{ 0x8B6E, 0xFFFD },
	{ 0x8B6F, 0xFFFD },
	{ 0x8B70, 0xFFFD },
	{ 0x8B71, 0xFFFD },
	{ 0x8B72, 0xFFFD },
	{ 0x8B73, 0xFFFD },
	{ 0x8B74, 0xFFFD },
	{ 0x8B75, 0xFFFD },
	{ 0x8B76, 0xFFFD },
	{ 0x8B77, 0xFFFD },
	{ 0x8B78, 0xFFFD },
	{ 0x8B79, 0xFFFD },
	{ 0x8B7A, 0xFFFD },
	{ 0x8B7B, 0xFFFD },
	{ 0x8B7C, 0xFFFD },
	{ 0x8B7D, 0xFFFD },
	{ 0x8B7E, 0xFFFD },
	{ 0x8B7F, 0xFFFD },
	{ 0x8B80, 0x66F5 },
	{ 0x8B81, 0x675B },
	{ 0x8B82, 0x6754 },
	{ 0x8B83, 0x6752 },
	{ 0x8B84, 0x6758 },
	{ 0x8B85, 0x6744 },
	{ 0x8B86, 0x674A },
	{ 0x8B87, 0x6761 },
	{ 0x8B88, 0x6C7F },
	{ 0x8B89, 0x6C91 },
	{ 0x8B8A, 0x6C9E },
	{ 0x8B8B, 0x6C6E },
	{ 0x8B8C, 0x6C7C },
	{ 0x8B8D, 0x6C9F },
	{ 0x8B8E, 0x6C75 },
	{ 0x8B8F, 0x6C56 },
	{ 0x8B90, 0x6CA2 },
	{ 0x8B91, 0x6C79 },
	{ 0x8B92, 0x6CA1 },
	{ 0x8B93, 0x6CAA },
	{ 0x8B94, 0x6CA0 },
	{ 0x8B95, 0x7079 },
	{ 0x8B96, 0x7077 },
	{ 0x8B97, 0x707E },
	{ 0x8B98, 0x7075 },
	{ 0x8B99, 0x707B },
	{ 0x8B9A, 0x7264 },
	{ 0x8B9B, 0x72BB },
	{ 0x8B9C, 0x72BC },
	{ 0x8B9D, 0x72C7 },
	{ 0x8B9E, 0x72B9 },
	{ 0x8B9F, 0x72BE },
	{ 0x8BA0, 0x72B6 },
	{ 0x8BA1, 0xFFFD },
	{ 0x8BA2, 0xFFFD },
	{ 0x8BA3, 0xFFFD },
	{ 0x8BA4, 0xFFFD },
	{ 0x8BA5, 0xFFFD },
	{ 0x8BA6, 0xFFFD },
	{ 0x8BA7, 0xFFFD },
	{ 0x8BA8, 0xFFFD },
	{ 0x8BA9, 0xFFFD },
	{ 0x8BAA, 0xFFFD },
	{ 0x8BAB, 0xFFFD },
	{ 0x8BAC, 0xFFFD },
	{ 0x8BAD, 0xFFFD },
	{ 0x8BAE, 0xFFFD },
	{ 0x8BAF, 0xFFFD },
	{ 0x8BB0, 0xFFFD },
	{ 0x8BB1, 0xFFFD },
	{ 0x8BB2, 0xFFFD },
	{ 0x8BB3, 0xFFFD },
	{ 0x8BB4, 0xFFFD },
	{ 0x8BB5, 0xFFFD },
	{ 0x8BB6, 0xFFFD },
	{ 0x8BB7, 0xFFFD },
	{ 0x8BB8, 0xFFFD },
	{ 0x8BB9, 0xFFFD },
	{ 0x8BBA, 0xFFFD },
	{ 0x8BBB, 0xFFFD },
	{ 0x8BBC, 0xFFFD },
	{ 0x8BBD, 0xFFFD },
	{ 0x8BBE, 0xFFFD },
	{ 0x8BBF, 0xFFFD },
	{ 0x8BC0, 0xFFFD },
	{ 0x8BC1, 0xFFFD },
	{ 0x8BC2, 0xFFFD },
	{ 0x8BC3, 0xFFFD },
	{ 0x8BC4, 0xFFFD },
	{ 0x8BC5, 0xFFFD },
	{ 0x8BC6, 0xFFFD },
	{ 0x8BC7, 0xFFFD },
	{ 0x8BC8, 0xFFFD },
	{ 0x8BC9, 0xFFFD },
	{ 0x8BCA, 0xFFFD },
	{ 0x8BCB, 0xFFFD },
	{ 0x8BCC, 0xFFFD },
	{ 0x8BCD, 0xFFFD },
	{ 0x8BCE, 0xFFFD },
	{ 0x8BCF, 0xFFFD },
	{ 0x8BD0, 0xFFFD },
	{ 0x8BD1, 0xFFFD },
	{ 0x8BD2, 0xFFFD },
	{ 0x8BD3, 0xFFFD },
	{ 0x8BD4, 0xFFFD },
	{ 0x8BD5, 0xFFFD },
	{ 0x8BD6, 0xFFFD },
	{ 0x8BD7, 0xFFFD },
	{ 0x8BD8, 0xFFFD },
	{ 0x8BD9, 0xFFFD },
	{ 0x8BDA, 0xFFFD },
	{ 0x8BDB, 0xFFFD },
	{ 0x8BDC, 0xFFFD },
	{ 0x8BDD, 0xFFFD },
	{ 0x8BDE, 0xFFFD },
	{ 0x8BDF, 0xFFFD },
	{ 0x8BE0, 0xFFFD },
	{ 0x8BE1, 0xFFFD },
	{ 0x8BE2, 0xFFFD },
	{ 0x8BE3, 0xFFFD },
	{ 0x8BE4, 0xFFFD },
	{ 0x8BE5, 0xFFFD },
	{ 0x8BE6, 0xFFFD },
	{ 0x8BE7, 0xFFFD },
	{ 0x8BE8, 0xFFFD },
	{ 0x8BE9, 0xFFFD },
	{ 0x8BEA, 0xFFFD },
	{ 0x8BEB, 0xFFFD },
	{ 0x8BEC, 0xFFFD },
	{ 0x8BED, 0xFFFD },
	{ 0x8BEE, 0xFFFD },
	{ 0x8BEF, 0xFFFD },
	{ 0x8BF0, 0xFFFD },
	{ 0x8BF1, 0xFFFD },
	{ 0x8BF2, 0xFFFD },
	{ 0x8BF3, 0xFFFD },
	{ 0x8BF4, 0xFFFD },
	{ 0x8BF5, 0xFFFD },
	{ 0x8BF6, 0xFFFD },
	{ 0x8BF7, 0xFFFD },
	{ 0x8BF8, 0xFFFD },
	{ 0x8BF9, 0xFFFD },
	{ 0x8BFA, 0xFFFD },
	{ 0x8BFB, 0xFFFD },
	{ 0x8BFC, 0xFFFD },
	{ 0x8BFD, 0xFFFD },
	{ 0x8BFE, 0xFFFD },
	{ 0x8C40, 0xFFFD },
	{ 0x8C41, 0xFFFD },
	{ 0x8C42, 0xFFFD },
	{ 0x8C43, 0xFFFD },
	{ 0x8C44, 0xFFFD },
	{ 0x8C45, 0xFFFD },
	{ 0x8C46, 0xFFFD },
	{ 0x8C47, 0xFFFD },
	{ 0x8C48, 0xFFFD },
	{ 0x8C49, 0xFFFD },
	{ 0x8C4A, 0xFFFD },
	{ 0x8C4B, 0xFFFD },
	{ 0x8C4C, 0xFFFD },
	{ 0x8C4D, 0xFFFD },
	{ 0x8C4E, 0xFFFD },
	{ 0x8C4F, 0xFFFD },
	{ 0x8C50, 0xFFFD },
	{ 0x8C51, 0xFFFD },
	{ 0x8C52, 0xFFFD },
	{ 0x8C53, 0xFFFD },
	{ 0x8C54, 0xFFFD },
	{ 0x8C55, 0xFFFD },
	{ 0x8C56, 0xFFFD },
	{ 0x8C57, 0xFFFD },
	{ 0x8C58, 0xFFFD },
	{ 0x8C59, 0xFFFD },
	{ 0x8C5A, 0xFFFD },
	{ 0x8C5B, 0xFFFD },
	{ 0x8C5C, 0xFFFD },
	{ 0x8C5D, 0xFFFD },
	{ 0x8C5E, 0xFFFD },
	{ 0x8C5F, 0xFFFD },
	{ 0x8C60, 0xFFFD },
	{ 0x8C61, 0xFFFD },
	{ 0x8C62, 0xFFFD },
	{ 0x8C63, 0xFFFD },
	{ 0x8C64, 0xFFFD },
	{ 0x8C65, 0xFFFD },
	{ 0x8C66, 0xFFFD },
	{ 0x8C67, 0xFFFD },
	{ 0x8C68, 0xFFFD },
	{ 0x8C69, 0xFFFD },
	{ 0x8C6A, 0xFFFD },
	{ 0x8C6B, 0xFFFD },
	{ 0x8C6C, 0xFFFD },
	{ 0x8C6D, 0xFFFD },
	{ 0x8C6E, 0xFFFD },
	{ 0x8C6F, 0xFFFD },
	{ 0x8C70, 0xFFFD },
	{ 0x8C71, 0xFFFD },
	{ 0x8C72, 0xFFFD },
	{ 0x8C73, 0xFFFD },
	{ 0x8C74, 0xFFFD },
	{ 0x8C75, 0xFFFD },
	{ 0x8C76, 0xFFFD },
	{ 0x8C77, 0xFFFD },
	{ 0x8C78, 0xFFFD },
	{ 0x8C79, 0xFFFD },
	{ 0x8C7A, 0xFFFD },
	{ 0x8C7B, 0xFFFD },
	{ 0x8C7C, 0xFFFD },
	{ 0x8C7D, 0xFFFD },
	{ 0x8C7E, 0xFFFD },
	{ 0x8C7F, 0xFFFD },
	{ 0x8C80, 0x7398 },
	{ 0x8C81, 0x7593 },
	{ 0x8C82, 0x7680 },
	{ 0x8C83, 0x7683 },
	{ 0x8C84, 0x76C0 },
	{ 0x8C85, 0x76C1 },
	{ 0x8C86, 0x77F4 },
	{ 0x8C87, 0x77F5 },
	{ 0x8C88, 0x7ACC },
	{ 0x8C89, 0x7ACD },
	{ 0x8C8A, 0x7CFA },
	{ 0x8C8B, 0x809F },
	{ 0x8C8C, 0x8091 },
	{ 0x8C8D, 0x8097 },
	{ 0x8C8E, 0x8094 },
	{ 0x8C8F, 0x8286 },
	{ 0x8C90, 0x828C },
	{ 0x8C91, 0x8295 },
	{ 0x8C92, 0x866C },
	{ 0x8C93, 0x8FBE },
	{ 0x8C94, 0x8FC7 },
	{ 0x8C95, 0x8FC1 },
	{ 0x8C96, 0x90A9 },
	{ 0x8C97, 0x90A4 },
	{ 0x8C98, 0x90A8 },
	{ 0x8C99, 0x9627 },
	{ 0x8C9A, 0x9626 },
	{ 0x8C9B, 0x962B },
	{ 0x8C9C, 0x9633 },
	{ 0x8C9D, 0x9634 },
	{ 0x8C9E, 0x9629 },
	{ 0x8C9F, 0x4E3D },
	{ 0x8CA0, 0x4E9D },
	{ 0x8CA1, 0xFFFD },
	{ 0x8CA2, 0xFFFD },
	{ 0x8CA3, 0xFFFD },
	{ 0x8CA4, 0xFFFD },
	{ 0x8CA5, 0xFFFD },
	{ 0x8CA6, 0xFFFD },
	{ 0x8CA7, 0xFFFD },
	{ 0x8CA8, 0xFFFD },
	{ 0x8CA9, 0xFFFD },
	{ 0x8CAA, 0xFFFD },
	{ 0x8CAB, 0xFFFD },
	{ 0x8CAC, 0xFFFD },
	{ 0x8CAD, 0xFFFD },
	{ 0x8CAE, 0xFFFD },
	{ 0x8CAF, 0xFFFD },
	{ 0x8CB0, 0xFFFD },
	{ 0x8CB1, 0xFFFD },
	{ 0x8CB2, 0xFFFD },
	{ 0x8CB3, 0xFFFD },
	{ 0x8CB4, 0xFFFD },
	{ 0x8CB5, 0xFFFD },
	{ 0x8CB6, 0xFFFD },
	{ 0x8CB7, 0xFFFD },
	{ 0x8CB8, 0xFFFD },
	{ 0x8CB9, 0xFFFD },
	{ 0x8CBA, 0xFFFD },
	{ 0x8CBB, 0xFFFD },
	{ 0x8CBC, 0xFFFD },
	{ 0x8CBD, 0xFFFD },
	{ 0x8CBE, 0xFFFD },
	{ 0x8CBF, 0xFFFD },
	{ 0x8CC0, 0xFFFD },
	{ 0x8CC1, 0xFFFD },
	{ 0x8CC2, 0xFFFD },
	{ 0x8CC3, 0xFFFD },
	{ 0x8CC4, 0xFFFD },
	{ 0x8CC5, 0xFFFD },
	{ 0x8CC6, 0xFFFD },
	{ 0x8CC7, 0xFFFD },
	{ 0x8CC8, 0xFFFD },
	{ 0x8CC9, 0xFFFD },
	{ 0x8CCA, 0xFFFD },
	{ 0x8CCB, 0xFFFD },
	{ 0x8CCC, 0xFFFD },
	{ 0x8CCD, 0xFFFD },
	{ 0x8CCE, 0xFFFD },
	{ 0x8CCF, 0xFFFD },
	{ 0x8CD0, 0xFFFD },
	{ 0x8CD1, 0xFFFD },
	{ 0x8CD2, 0xFFFD },
	{ 0x8CD3, 0xFFFD },
	{ 0x8CD4, 0xFFFD },
	{ 0x8CD5, 0xFFFD },
	{ 0x8CD6, 0xFFFD },
	{ 0x8CD7, 0xFFFD },
	{ 0x8CD8, 0xFFFD },
	{ 0x8CD9, 0xFFFD },
	{ 0x8CDA, 0xFFFD },
	{ 0x8CDB, 0xFFFD },
	{ 0x8CDC, 0xFFFD },
	{ 0x8CDD, 0xFFFD },
	{ 0x8CDE, 0xFFFD },
	{ 0x8CDF, 0xFFFD },
	{ 0x8CE0, 0xFFFD },
	{ 0x8CE1, 0xFFFD },
	{ 0x8CE2, 0xFFFD },
	{ 0x8CE3, 0xFFFD },
	{ 0x8CE4, 0xFFFD },
	{ 0x8CE5, 0xFFFD },
	{ 0x8CE6, 0xFFFD },
	{ 0x8CE7, 0xFFFD },
	{ 0x8CE8, 0xFFFD },
	{ 0x8CE9, 0xFFFD },
	{ 0x8CEA, 0xFFFD },
	{ 0x8CEB, 0xFFFD },
	{ 0x8CEC, 0xFFFD },
	{ 0x8CED, 0xFFFD },
	{ 0x8CEE, 0xFFFD },
	{ 0x8CEF, 0xFFFD },
	{ 0x8CF0, 0xFFFD },
	{ 0x8CF1, 0xFFFD },
	{ 0x8CF2, 0xFFFD },
	{ 0x8CF3, 0xFFFD },
	{ 0x8CF4, 0xFFFD },
	{ 0x8CF5, 0xFFFD },
	{ 0x8CF6, 0xFFFD },
	{ 0x8CF7, 0xFFFD },
	{ 0x8CF8, 0xFFFD },
	{ 0x8CF9, 0xFFFD },
	{ 0x8CFA, 0xFFFD },
	{ 0x8CFB, 0xFFFD },
	{ 0x8CFC, 0xFFFD },
	{ 0x8CFD, 0xFFFD },
	{ 0x8CFE, 0xFFFD },
	{ 0x8D40, 0xFFFD },
	{ 0x8D41, 0xFFFD },
	{ 0x8D42, 0xFFFD },
	{ 0x8D43, 0xFFFD },
	{ 0x8D44, 0xFFFD },
	{ 0x8D45, 0xFFFD },
	{ 0x8D46, 0xFFFD },
	{ 0x8D47, 0xFFFD },
	{ 0x8D48, 0xFFFD },
	{ 0x8D49, 0xFFFD },
	{ 0x8D4A, 0xFFFD },
	{ 0x8D4B, 0xFFFD },
	{ 0x8D4C, 0xFFFD },
	{ 0x8D4D, 0xFFFD },
	{ 0x8D4E, 0xFFFD },
	{ 0x8D4F, 0xFFFD },
	{ 0x8D50, 0xFFFD },
	{ 0x8D51, 0xFFFD },
	{ 0x8D52, 0xFFFD },
	{ 0x8D53, 0xFFFD },
	{ 0x8D54, 0xFFFD },
	{ 0x8D55, 0xFFFD },
	{ 0x8D56, 0xFFFD },
	{ 0x8D57, 0xFFFD },
	{ 0x8D58, 0xFFFD },
	{ 0x8D59, 0xFFFD },
	{ 0x8D5A, 0xFFFD },
	{ 0x8D5B, 0xFFFD },
	{ 0x8D5C, 0xFFFD },
	{ 0x8D5D, 0xFFFD },
	{ 0x8D5E, 0xFFFD },
	{ 0x8D5F, 0xFFFD },
	{ 0x8D60, 0xFFFD },
	{ 0x8D61, 0xFFFD },
	{ 0x8D62, 0xFFFD },
	{ 0x8D63, 0xFFFD },
	{ 0x8D64, 0xFFFD },
	{ 0x8D65, 0xFFFD },
	{ 0x8D66, 0xFFFD },
	{ 0x8D67, 0xFFFD },
	{ 0x8D68, 0xFFFD },
	{ 0x8D69, 0xFFFD },
	{ 0x8D6A, 0xFFFD },
	{ 0x8D6B, 0xFFFD },
	{ 0x8D6C, 0xFFFD },
	{ 0x8D6D, 0xFFFD },
	{ 0x8D6E, 0xFFFD },
	{ 0x8D6F, 0xFFFD },
	{ 0x8D70, 0xFFFD },
	{ 0x8D71, 0xFFFD },
	{ 0x8D72, 0xFFFD },
	{ 0x8D73, 0xFFFD },
	{ 0x8D74, 0xFFFD },
	{ 0x8D75, 0xFFFD },
	{ 0x8D76, 0xFFFD },
	{ 0x8D77, 0xFFFD },
	{ 0x8D78, 0xFFFD },
	{ 0x8D79, 0xFFFD },
	{ 0x8D7A, 0xFFFD },
	{ 0x8D7B, 0xFFFD },
	{ 0x8D7C, 0xFFFD },
	{ 0x8D7D, 0xFFFD },
	{ 0x8D7E, 0xFFFD },
	{ 0x8D7F, 0xFFFD },
	{ 0x8D80, 0x4F93 },
	{ 0x8D81, 0x4F8A },
	{ 0x8D82, 0x4F6D },
	{ 0x8D83, 0x4F8E },
	{ 0x8D84, 0x4FA0 },
	{ 0x8D85, 0x4FA2 },
	{ 0x8D86, 0x4FA1 },
	{ 0x8D87, 0x4F9F },
	{ 0x8D88, 0x4FA3 },
	{ 0x8D89, 0x4F72 },
	{ 0x8D8A, 0x4F8C },
	{ 0x8D8B, 0x5156 },
	{ 0x8D8C, 0x5190 },
	{ 0x8D8D, 0x51ED },
	{ 0x8D8E, 0x51FE },
	{ 0x8D8F, 0x522F },
	{ 0x8D90, 0x523C },
	{ 0x8D91, 0x5234 },
	{ 0x8D92, 0x5239 },
	{ 0x8D93, 0x52B9 },
	{ 0x8D94, 0x52B5 },
	{ 0x8D95, 0x52BF },
	{ 0x8D96, 0x5355 },
	{ 0x8D97, 0x5376 },
	{ 0x8D98, 0x537A },
	{ 0x8D99, 0x5393 },
	{ 0x8D9A, 0x53C1 },
	{ 0x8D9B, 0x53C2 },
	{ 0x8D9C, 0x53D5 },
	{ 0x8D9D, 0x5485 },
	{ 0x8D9E, 0x545F },
	{ 0x8D9F, 0x5493 },
	{ 0x8DA0, 0x5489 },
	{ 0x8DA1, 0xFFFD },
	{ 0x8DA2, 0xFFFD },
	{ 0x8DA3, 0xFFFD },
	{ 0x8DA4, 0xFFFD },
	{ 0x8DA5, 0xFFFD },
	{ 0x8DA6, 0xFFFD },
	{ 0x8DA7, 0xFFFD },
	{ 0x8DA8, 0xFFFD },
	{ 0x8DA9, 0xFFFD },
	{ 0x8DAA, 0xFFFD },
	{ 0x8DAB, 0xFFFD },
	{ 0x8DAC, 0xFFFD },
	{ 0x8DAD, 0xFFFD },
	{ 0x8DAE, 0xFFFD },
	{ 0x8DAF, 0xFFFD },
	{ 0x8DB0, 0xFFFD },
	{ 0x8DB1, 0xFFFD },
	{ 0x8DB2, 0xFFFD },
	{ 0x8DB3, 0xFFFD },
	{ 0x8DB4, 0xFFFD },
	{ 0x8DB5, 0xFFFD },
	{ 0x8DB6, 0xFFFD },
	{ 0x8DB7, 0xFFFD },
	{ 0x8DB8, 0xFFFD },
	{ 0x8DB9, 0xFFFD },
	{ 0x8DBA, 0xFFFD },
	{ 0x8DBB, 0xFFFD },
	{ 0x8DBC, 0xFFFD },
	{ 0x8DBD, 0xFFFD },
	{ 0x8DBE, 0xFFFD },
	{ 0x8DBF, 0xFFFD },
	{ 0x8DC0, 0xFFFD },
	{ 0x8DC1, 0xFFFD },
	{ 0x8DC2, 0xFFFD },
	{ 0x8DC3, 0xFFFD },
	{ 0x8DC4, 0xFFFD },
	{ 0x8DC5, 0xFFFD },
	{ 0x8DC6, 0xFFFD },
	{ 0x8DC7, 0xFFFD },
	{ 0x8DC8, 0xFFFD },
	{ 0x8DC9, 0xFFFD },
	{ 0x8DCA, 0xFFFD },
	{ 0x8DCB, 0xFFFD },
	{ 0x8DCC, 0xFFFD },
	{ 0x8DCD, 0xFFFD },
	{ 0x8DCE, 0xFFFD },
	{ 0x8DCF, 0xFFFD },
	{ 0x8DD0, 0xFFFD },
	{ 0x8DD1, 0xFFFD },
	{ 0x8DD2, 0xFFFD },
	{ 0x8DD3, 0xFFFD },
	{ 0x8DD4, 0xFFFD },
	{ 0x8DD5, 0xFFFD },
	{ 0x8DD6, 0xFFFD },
	{ 0x8DD7, 0xFFFD },
	{ 0x8DD8, 0xFFFD },
	{ 0x8DD9, 0xFFFD },
	{ 0x8DDA, 0xFFFD },
	{ 0x8DDB, 0xFFFD },
	{ 0x8DDC, 0xFFFD },
	{ 0x8DDD, 0xFFFD },
	{ 0x8DDE, 0xFFFD },
	{ 0x8DDF, 0xFFFD },
	{ 0x8DE0, 0xFFFD },
	{ 0x8DE1, 0xFFFD },
	{ 0x8DE2, 0xFFFD },
	{ 0x8DE3, 0xFFFD },
	{ 0x8DE4, 0xFFFD },
	{ 0x8DE5, 0xFFFD },
	{ 0x8DE6, 0xFFFD },
	{ 0x8DE7, 0xFFFD },
	{ 0x8DE8, 0xFFFD },
	{ 0x8DE9, 0xFFFD },
	{ 0x8DEA, 0xFFFD },
	{ 0x8DEB, 0xFFFD },
	{ 0x8DEC, 0xFFFD },
	{ 0x8DED, 0xFFFD },
	{ 0x8DEE, 0xFFFD },
	{ 0x8DEF, 0xFFFD },
	{ 0x8DF0, 0xFFFD },
	{ 0x8DF1, 0xFFFD },
	{ 0x8DF2, 0xFFFD },
	{ 0x8DF3, 0xFFFD },
	{ 0x8DF4, 0xFFFD },
	{ 0x8DF5, 0xFFFD },
	{ 0x8DF6, 0xFFFD },
	{ 0x8DF7, 0xFFFD },
	{ 0x8DF8, 0xFFFD },
	{ 0x8DF9, 0xFFFD },
	{ 0x8DFA, 0xFFFD },
	{ 0x8DFB, 0xFFFD },
	{ 0x8DFC, 0xFFFD },
	{ 0x8DFD, 0xFFFD },
	{ 0x8DFE, 0xFFFD },
	{ 0x8E40, 0x8038 },
	{ 0x8E41, 0x8081 },
	{ 0x8E42, 0x8158 },
	{ 0x8E43, 0x8A24 },
	{ 0x8E44, 0x8DC3 },
	{ 0x8E45, 0x51F2 },
	{ 0x8E46, 0x55B6 },
	{ 0x8E47, 0x5EC3 },
	{ 0x8E48, 0x7861 },
	{ 0x8E49, 0x7A01 },
	{ 0x8E4A, 0x8849 },
	{ 0x8E4B, 0x8999 },
	{ 0x8E4C, 0x921F },
	{ 0x8E4D, 0x5313 },
	{ 0x8E4E, 0x55E0 },
	{ 0x8E4F, 0x6139 },
	{ 0x8E50, 0x6ED7 },
	{ 0x8E51, 0x733D },
	{ 0x8E52, 0x9775 },
	{ 0x8E53, 0x7FE4 },
	{ 0x8E54, 0x8088 },
	{ 0x8E55, 0x5655 },
	{ 0x8E56, 0x617F },
	{ 0x8E57, 0x71D7 },
	{ 0x8E58, 0x8666 },
	{ 0x8E59, 0x8F3A },
	{ 0x8E5A, 0x933D },
	{ 0x8E5B, 0x64F5 },
	{ 0x8E5C, 0x7F80 },
	{ 0x8E5D, 0x8D01 },
	{ 0x8E5E, 0x58E1 },
	{ 0x8E5F, 0x7CE9 },
	{ 0x8E60, 0x81CB },
	{ 0x8E61, 0x95D9 },
	{ 0x8E62, 0x6707 },
	{ 0x8E63, 0x9A47 },
	{ 0x8E64, 0x7674 },
	{ 0x8E65, 0x5301 },
	{ 0x8E66, 0x53FA },
	{ 0x8E67, 0x9F99 },
	{ 0x8E68, 0x6C49 },
	{ 0x8E69, 0x8FB7 },
	{ 0x8E6A, 0x4F29 },
	{ 0x8E6B, 0x534E },
	{ 0x8E6C, 0x5C81 },
	{ 0x8E6D, 0x5F10 },
	{ 0x8E6E, 0x6268 },
	{ 0x8E6F, 0x6742 },
	{ 0x8E70, 0x6740 },
	{ 0x8E71, 0x51EA },
	{ 0x8E72, 0x6C62 },
	{ 0x8E73, 0x7391 },
	{ 0x8E74, 0x8FBB },
	{ 0x8E75, 0x8FBC },
	{ 0x8E76, 0x56E8 },
	{ 0x8E77, 0x575B },
	{ 0x8E78, 0x5C97 },
	{ 0x8E79, 0x6762 },
	{ 0x8E7A, 0x62A4 },
	{ 0x8E7B, 0x6766 },
	{ 0x8E7C, 0x6CA3 },
	{ 0x8E7D, 0x707F },
	{ 0x8E7E, 0x77F6 },
	{ 0x8E7F, 0xFFFD },
	{ 0x8E80, 0x5479 },
	{ 0x8E81, 0x9EFE },
	{ 0x8E82, 0x548F },
	{ 0x8E83, 0x5469 },
	{ 0x8E84, 0x546D },
	{ 0x8E85, 0x5494 },
	{ 0x8E86, 0x546A },
	{ 0x8E87, 0x548A },
	{ 0x8E88, 0x56FD },
	{ 0x8E89, 0x56FB },
	{ 0x8E8A, 0x56F8 },
	{ 0x8E8B, 0x56FC },
	{ 0x8E8C, 0x56F6 },
	{ 0x8E8D, 0x5765 },
	{ 0x8E8E, 0x5781 },
	{ 0x8E8F, 0x5763 },
	{ 0x8E90, 0x5767 },
	{ 0x8E91, 0x576E },
	{ 0x8E92, 0x5778 },
	{ 0x8E93, 0x577F },
	{ 0x8E94, 0x58F3 },
	{ 0x8E95, 0x594B },
	{ 0x8E96, 0x594C },
	{ 0x8E97, 0x59AD },
	{ 0x8E98, 0x59C4 },
	{ 0x8E99, 0x59C2 },
	{ 0x8E9A, 0x59B0 },
	{ 0x8E9B, 0x59BF },
	{ 0x8E9C, 0x59C9 },
	{ 0x8E9D, 0x59B8 },
	{ 0x8E9E, 0x59AC },
	{ 0x8E9F, 0x59B7 },
	{ 0x8EA0, 0x59D7 },
	{ 0x8EA1, 0x8FC8 },
	{ 0x8EA2, 0x4FAB },
	{ 0x8EA3, 0x5C2D },
	{ 0x8EA4, 0x549C },
	{ 0x8EA5, 0x5788 },
	{ 0x8EA6, 0x62C3 },
	{ 0x8EA7, 0x6619 },
	{ 0x8EA8, 0x67A1 },
	{ 0x8EA9, 0x67A6 },
	{ 0x8EAA, 0x77FE },
	{ 0x8EAB, 0x7F57 },
	{ 0x8EAC, 0x82C5 },
	{ 0x8EAD, 0x8FDF },
	{ 0x8EAE, 0x8FDC },
	{ 0x8EAF, 0x4FE4 },
	{ 0x8EB0, 0x551B },
	{ 0x8EB1, 0x57AA },
	{ 0x8EB2, 0x57AB },
	{ 0x8EB3, 0x5BA9 },
	{ 0x8EB4, 0x6811 },
	{ 0x8EB5, 0x7551 },
	{ 0x8EB6, 0x7553 },
	{ 0x8EB7, 0x7818 },
	{ 0x8EB8, 0x7AD7 },
	{ 0x8EB9, 0x7C7E },
	{ 0x8EBA, 0x867E },
	{ 0x8EBB, 0x5266 },
	{ 0x8EBC, 0x5520 },
	{ 0x8EBD, 0x5521 },
	{ 0x8EBE, 0x57D7 },
	{ 0x8EBF, 0x5BBE },
	{ 0x8EC0, 0x6857 },
	{ 0x8EC1, 0x7F3C },
	{ 0x8EC2, 0x8273 },
	{ 0x8EC3, 0x96BE },
	{ 0x8EC4, 0x66FA },
	{ 0x8EC5, 0x5A72 },
	{ 0x8EC6, 0x68BD },
	{ 0x8EC7, 0x6E15 },
	{ 0x8EC8, 0x7413 },
	{ 0x8EC9, 0x74F8 },
	{ 0x8ECA, 0x7B3D },
	{ 0x8ECB, 0x76D8 },
	{ 0x8ECC, 0x79FC },
	{ 0x8ECD, 0x7B39 },
	{ 0x8ECE, 0x7D4B },
	{ 0x8ECF, 0x83B9 },
	{ 0x8ED0, 0x86CF },
	{ 0x8ED1, 0x8EAE },
	{ 0x8ED2, 0x96EB },
	{ 0x8ED3, 0x55B0 },
	{ 0x8ED4, 0x5840 },
	{ 0x8ED5, 0x5842 },
	{ 0x8ED6, 0x692B },
	{ 0x8ED7, 0x6916 },
	{ 0x8ED8, 0x691B },
	{ 0x8ED9, 0x6927 },
	{ 0x8EDA, 0x6BF5 },
	{ 0x8EDB, 0x6E82 },
	{ 0x8EDC, 0x6E7A },
	{ 0x8EDD, 0x7129 },
	{ 0x8EDE, 0x7CAB },
	{ 0x8EDF, 0x7CAC },
	{ 0x8EE0, 0x83F7 },
	{ 0x8EE1, 0x9596 },
	{ 0x8EE2, 0x55F1 },
	{ 0x8EE3, 0x5F41 },
	{ 0x8EE4, 0x698A },
	{ 0x8EE5, 0x698C },
	{ 0x8EE6, 0x6980 },
	{ 0x8EE7, 0x697F },
	{ 0x8EE8, 0x789C },
	{ 0x8EE9, 0x7B7B },
	{ 0x8EEA, 0x90D2 },
	{ 0x8EEB, 0x95A0 },
	{ 0x8EEC, 0x51A9 },
	{ 0x8EED, 0x7195 },
	{ 0x8EEE, 0x7198 },
	{ 0x8EEF, 0x7478 },
	{ 0x8EF0, 0x78B9 },
	{ 0x8EF1, 0x7A33 },
	{ 0x8EF2, 0x7CC0 },
	{ 0x8EF3, 0x7CC1 },
	{ 0x8EF4, 0x8744 },
	{ 0x8EF5, 0x9064 },
	{ 0x8EF6, 0x9277 },
	{ 0x8EF7, 0x92AF },
	{ 0x8EF8, 0x5E64 },
	{ 0x8EF9, 0x6A2B },
	{ 0x8EFA, 0x6F46 },
	{ 0x8EFB, 0x6F9A },
	{ 0x8EFC, 0x92F2 },
	{ 0x8EFD, 0x9B79 },
	{ 0x8EFE, 0x567A },
	{ 0x8F40, 0x5F5C },
	{ 0x8F41, 0x65D9 },
	{ 0x8F42, 0x6A72 },
	{ 0x8F43, 0x6A78 },
	{ 0x8F44, 0x6B5A },
	{ 0x8F45, 0x8EBE },
	{ 0x8F46, 0x933B },
	{ 0x8F47, 0x9340 },
	{ 0x8F48, 0x933A },
	{ 0x8F49, 0x9B96 },
	{ 0x8F4A, 0x71F5 },
	{ 0x8F4B, 0x7A50 },
	{ 0x8F4C, 0x9387 },
	{ 0x8F4D, 0x9385 },
	{ 0x8F4E, 0x9BB1 },
	{ 0x8F4F, 0x9D47 },
	{ 0x8F50, 0x93B9 },
	{ 0x8F51, 0x93BF },
	{ 0x8F52, 0x9BCF },
	{ 0x8F53, 0x9D64 },
	{ 0x8F54, 0x9EBF },
	{ 0x8F55, 0x89B8 },
	{ 0x8F56, 0x9BF3 },
	{ 0x8F57, 0x7C4F },
	{ 0x8F58, 0x9425 },
	{ 0x8F59, 0x95E6 },
	{ 0x8F5A, 0x9C2F },
	{ 0x8F5B, 0x6B0C },
	{ 0x8F5C, 0x9C47 },
	{ 0x8F5D, 0x7936 },
	{ 0x8F5E, 0x6B15 },
	{ 0x8F5F, 0x53B5 },
	{ 0x8F60, 0x4F66 },
	{ 0x8F61, 0x4F68 },
	{ 0x8F62, 0x4FE7 },
	{ 0x8F63, 0x503F },
	{ 0x8F64, 0x50A6 },
	{ 0x8F65, 0x510F },
	{ 0x8F66, 0x523E },
	{ 0x8F67, 0x5324 },
	{ 0x8F68, 0x5365 },
	{ 0x8F69, 0x539B },
	{ 0x8F6A, 0x517F },
	{ 0x8F6B, 0x54CB },
	{ 0x8F6C, 0x5573 },
	{ 0x8F6D, 0x5571 },
	{ 0x8F6E, 0x556B },
	{ 0x8F6F, 0x55F4 },
	{ 0x8F70, 0x5622 },
	{ 0x8F71, 0x5620 },
	{ 0x8F72, 0x5692 },
	{ 0x8F73, 0x56BA },
	{ 0x8F74, 0x5691 },
	{ 0x8F75, 0x56B0 },
	{ 0x8F76, 0x5759 },
	{ 0x8F77, 0x578A },
	{ 0x8F78, 0x580F },
	{ 0x8F79, 0x5812 },
	{ 0x8F7A, 0x5813 },
	{ 0x8F7B, 0x5847 },
	{ 0x8F7C, 0x589B },
	{ 0x8F7D, 0x5900 },
	{ 0x8F7E, 0x594D },
	{ 0x8F7F, 0xFFFD },
	{ 0x8F80, 0x5B60 },
	{ 0x8F81, 0x5B96 },
	{ 0x8F82, 0x5B9E },
	{ 0x8F83, 0x5B94 },
	{ 0x8F84, 0x5B9F },
	{ 0x8F85, 0x5B9D },
	{ 0x8F86, 0x5C00 },
	{ 0x8F87, 0x5C19 },
	{ 0x8F88, 0x5C49 },
	{ 0x8F89, 0x5C4A },
	{ 0x8F8A, 0x5CBB },
	{ 0x8F8B, 0x5CC1 },
	{ 0x8F8C, 0x5CB9 },
	{ 0x8F8D, 0x5C9E },
	{ 0x8F8E, 0x5CB4 },
	{ 0x8F8F, 0x5CBA },
	{ 0x8F90, 0x5DF6 },
	{ 0x8F91, 0x5E13 },
	{ 0x8F92, 0x5E12 },
	{ 0x8F93, 0x5E77 },
	{ 0x8F94, 0x5E98 },
	{ 0x8F95, 0x5E99 },
	{ 0x8F96, 0x5E9D },
	{ 0x8F97, 0x5EF8 },
	{ 0x8F98, 0x5EF9 },
	{ 0x8F99, 0x5F06 },
	{ 0x8F9A, 0x5F21 },
	{ 0x8F9B, 0x5F25 },
	{ 0x8F9C, 0x5F55 },
	{ 0x8F9D, 0x5F84 },
	{ 0x8F9E, 0x5F83 },
	{ 0x8F9F, 0x6030 },
	{ 0x8FA0, 0x6007 },
	{ 0x8FA1, 0x5AD1 },
	{ 0x8FA2, 0x5AD3 },
	{ 0x8FA3, 0x5B67 },
	{ 0x8FA4, 0x5C57 },
	{ 0x8FA5, 0x5C77 },
	{ 0x8FA6, 0x5CD5 },
	{ 0x8FA7, 0x5D75 },
	{ 0x8FA8, 0x5D8E },
	{ 0x8FA9, 0x5DA5 },
	{ 0x8FAA, 0x5DB6 },
	{ 0x8FAB, 0x5DBF },
	{ 0x8FAC, 0x5E65 },
	{ 0x8FAD, 0x5ECD },
	{ 0x8FAE, 0x5EED },
	{ 0x8FAF, 0x5F94 },
	{ 0x8FB0, 0x5F9A },
	{ 0x8FB1, 0x5FBA },
	{ 0x8FB2, 0x6125 },
	{ 0x8FB3, 0x6150 },
	{ 0x8FB4, 0x62A3 },
	{ 0x8FB5, 0x6360 },
	{ 0x8FB6, 0x6364 },
	{ 0x8FB7, 0x63B6 },
	{ 0x8FB8, 0x6403 },
	{ 0x8FB9, 0x64B6 },
	{ 0x8FBA, 0x651A },
	{ 0x8FBB, 0x7A25 },
	{ 0x8FBC, 0x5C21 },
	{ 0x8FBD, 0x66E2 },
	{ 0x8FBE, 0x6702 },
	{ 0x8FBF, 0x67A4 },
	{ 0x8FC0, 0x67AC },
	{ 0x8FC1, 0x6810 },
	{ 0x8FC2, 0x6806 },
	{ 0x8FC3, 0x685E },
	{ 0x8FC4, 0x685A },
	{ 0x8FC5, 0x692C },
	{ 0x8FC6, 0x6929 },
	{ 0x8FC7, 0x6A2D },
	{ 0x8FC8, 0x6A77 },
	{ 0x8FC9, 0x6A7A },
	{ 0x8FCA, 0x6ACA },
	{ 0x8FCB, 0x6AE6 },
	{ 0x8FCC, 0x6AF5 },
	{ 0x8FCD, 0x6B0D },
	{ 0x8FCE, 0x6B0E },
	{ 0x8FCF, 0x6BDC },
	{ 0x8FD0, 0x6BDD },
	{ 0x8FD1, 0x6BF6 },
	{ 0x8FD2, 0x6C1E },
	{ 0x8FD3, 0x6C63 },
	{ 0x8FD4, 0x6DA5 },
	{ 0x8FD5, 0x6E0F },
	{ 0x8FD6, 0x6E8A },
	{ 0x8FD7, 0x6E84 },
	{ 0x8FD8, 0x6E8B },
	{ 0x8FD9, 0x6E7C },
	{ 0x8FDA, 0x6F4C },
	{ 0x8FDB, 0x6F48 },
	{ 0x8FDC, 0x6F49 },
	{ 0x8FDD, 0x6F9D },
	{ 0x8FDE, 0x6F99 },
	{ 0x8FDF, 0x6FF8 },
	{ 0x8FE0, 0x702E },
	{ 0x8FE1, 0x702D },
	{ 0x8FE2, 0x705C },
	{ 0x8FE3, 0x79CC },
	{ 0x8FE4, 0x70BF },
	{ 0x8FE5, 0x70EA },
	{ 0x8FE6, 0x70E5 },
	{ 0x8FE7, 0x7111 },
	{ 0x8FE8, 0x7112 },
	{ 0x8FE9, 0x713F },
	{ 0x8FEA, 0x7139 },
	{ 0x8FEB, 0x713B },
	{ 0x8FEC, 0x713D },
	{ 0x8FED, 0x7177 },
	{ 0x8FEE, 0x7175 },
	{ 0x8FEF, 0x7176 },
	{ 0x8FF0, 0x7171 },
	{ 0x8FF1, 0x7196 },
	{ 0x8FF2, 0x7193 },
	{ 0x8FF3, 0x71B4 },
	{ 0x8FF4, 0x71DD },
	{ 0x8FF5, 0x71DE },
	{ 0x8FF6, 0x720E },
	{ 0x8FF7, 0x5911 },
	{ 0x8FF8, 0x7218 },
	{ 0x8FF9, 0x7347 },
	{ 0x8FFA, 0x7348 },
	{ 0x8FFB, 0x73EF },
	{ 0x8FFC, 0x7412 },
	{ 0x8FFD, 0x743B },
	{ 0x8FFE, 0x74A4 },
	{ 0x9040, 0x748D },
	{ 0x9041, 0x74B4 },
	{ 0x9042, 0x7673 },
	{ 0x9043, 0x7677 },
	{ 0x9044, 0x76BC },
	{ 0x9045, 0x7819 },
	{ 0x9046, 0x781B },
	{ 0x9047, 0x783D },
	{ 0x9048, 0x7853 },
	{ 0x9049, 0x7854 },
	{ 0x904A, 0x7858 },
	{ 0x904B, 0x78B7 },
	{ 0x904C, 0x78D8 },
	{ 0x904D, 0x78EE },
	{ 0x904E, 0x7922 },
	{ 0x904F, 0x794D },
	{ 0x9050, 0x7986 },
	{ 0x9051, 0x7999 },
	{ 0x9052, 0x79A3 },
	{ 0x9053, 0x79BC },
	{ 0x9054, 0x7AA7 },
	{ 0x9055, 0x7B37 },
	{ 0x9056, 0x7B59 },
	{ 0x9057, 0x7BD0 },
	{ 0x9058, 0x7C2F },
	{ 0x9059, 0x7C32 },
	{ 0x905A, 0x7C42 },
	{ 0x905B, 0x7C4E },
	{ 0x905C, 0x7C68 },
	{ 0x905D, 0x7CA9 },
	{ 0x905E, 0x7CED },
	{ 0x905F, 0x7DD0 },
	{ 0x9060, 0x7E07 },
	{ 0x9061, 0x7DD3 },
	{ 0x9062, 0x7E64 },
	{ 0x9063, 0x7F40 },
	{ 0x9064, 0x8041 },
	{ 0x9065, 0x8063 },
	{ 0x9066, 0x80BB },
	{ 0x9067, 0x6711 },
	{ 0x9068, 0x6725 },
	{ 0x9069, 0x8248 },
	{ 0x906A, 0x8310 },
	{ 0x906B, 0x8362 },
	{ 0x906C, 0x8312 },
	{ 0x906D, 0x8421 },
	{ 0x906E, 0x841E },
	{ 0x906F, 0x84E2 },
	{ 0x9070, 0x84DE },
	{ 0x9071, 0x84E1 },
	{ 0x9072, 0x8573 },
	{ 0x9073, 0x85D4 },
	{ 0x9074, 0x85F5 },
	{ 0x9075, 0x8637 },
	{ 0x9076, 0x8645 },
	{ 0x9077, 0x8672 },
	{ 0x9078, 0x874A },
	{ 0x9079, 0x87A9 },
	{ 0x907A, 0x87A5 },
	{ 0x907B, 0x87F5 },
	{ 0x907C, 0x8834 },
	{ 0x907D, 0x8850 },
	{ 0x907E, 0x8887 },
	{ 0x907F, 0xFFFD },
	{ 0x9080, 0x6036 },
	{ 0x9081, 0x5FE9 },
	{ 0x9082, 0x603D },
	{ 0x9083, 0x6008 },
	{ 0x9084, 0x62BA },
	{ 0x9085, 0x62B2 },
	{ 0x9086, 0x62B7 },
	{ 0x9087, 0x62E4 },
	{ 0x9088, 0x62A7 },
	{ 0x9089, 0x62D5 },
	{ 0x908A, 0x62E1 },
	{ 0x908B, 0x62DD },
	{ 0x908C, 0x62A6 },
	{ 0x908D, 0x62C1 },
	{ 0x908E, 0x62C5 },
	{ 0x908F, 0x62C0 },
	{ 0x9090, 0x62DF },
	{ 0x9091, 0x62E0 },
	{ 0x9092, 0x62DE },
	{ 0x9093, 0x6589 },
	{ 0x9094, 0x65A6 },
	{ 0x9095, 0x65BA },
	{ 0x9096, 0x65FF },
	{ 0x9097, 0x6617 },
	{ 0x9098, 0x6618 },
	{ 0x9099, 0x6601 },
	{ 0x909A, 0x65FE },
	{ 0x909B, 0x670C },
	{ 0x909C, 0x676B },
	{ 0x909D, 0x6796 },
	{ 0x909E, 0x6782 },
	{ 0x909F, 0x678A },
	{ 0x90A0, 0x67A3 },
	{ 0x90A1, 0x8954 },
	{ 0x90A2, 0x8984 },
	{ 0x90A3, 0x8B03 },
	{ 0x90A4, 0x8C52 },
	{ 0x90A5, 0x8CD8 },
	{ 0x90A6, 0x8D0C },
	{ 0x90A7, 0x8D18 },
	{ 0x90A8, 0x8DB0 },
	{ 0x90A9, 0x8EBC },
	{ 0x90AA, 0x8ED5 },
	{ 0x90AB, 0x8FAA },
	{ 0x90AC, 0x909C },
	{ 0x90AD, 0x915C },
	{ 0x90AE, 0x922B },
	{ 0x90AF, 0x9221 },
	{ 0x90B0, 0x9273 },
	{ 0x90B1, 0x92F4 },
	{ 0x90B2, 0x92F5 },
	{ 0x90B3, 0x933F },
	{ 0x90B4, 0x9342 },
	{ 0x90B5, 0x9386 },
	{ 0x90B6, 0x93BE },
	{ 0x90B7, 0x93BC },
	{ 0x90B8, 0x93BD },
	{ 0x90B9, 0x93F1 },
	{ 0x90BA, 0x93F2 },
	{ 0x90BB, 0x93EF },
	{ 0x90BC, 0x9422 },
	{ 0x90BD, 0x9423 },
	{ 0x90BE, 0x9424 },
	{ 0x90BF, 0x9467 },
	{ 0x90C0, 0x9466 },
	{ 0x90C1, 0x9597 },
	{ 0x90C2, 0x95CE },
	{ 0x90C3, 0x95E7 },
	{ 0x90C4, 0x973B },
	{ 0x90C5, 0x974D },
	{ 0x90C6, 0x98E4 },
	{ 0x90C7, 0x9942 },
	{ 0x90C8, 0x9B1D },
	{ 0x90C9, 0x9B98 },
	{ 0x90CA, 0x9D49 },
	{ 0x90CB, 0x6449 },
	{ 0x90CC, 0x5E71 },
	{ 0x90CD, 0x5E85 },
	{ 0x90CE, 0x61D3 },
	{ 0x90CF, 0x990E },
	{ 0x90D0, 0x8002 },
	{ 0x90D1, 0x781E },
	{ 0x90D2, 0x5528 },
	{ 0x90D3, 0x5572 },
	{ 0x90D4, 0x55BA },
	{ 0x90D5, 0x55F0 },
	{ 0x90D6, 0x55EE },
	{ 0x90D7, 0x56B8 },
	{ 0x90D8, 0x56B9 },
	{ 0x90D9, 0x56C4 },
	{ 0x90DA, 0x8053 },
	{ 0x90DB, 0x92B0 },
	{ 0x90DC, 0x4E13 },
	{ 0x90DD, 0x4E1A },
	{ 0x90DE, 0x4E1B },
	{ 0x90DF, 0x4E1C },
	{ 0x90E0, 0x4E1D },
	{ 0x90E1, 0x4E25 },
	{ 0x90E2, 0x4E27 },
	{ 0x90E3, 0x4E2C },
	{ 0x90E4, 0x4E34 },
	{ 0x90E5, 0x4E3A },
	{ 0x90E6, 0x4E3E },
	{ 0x90E7, 0x4E4C },
	{ 0x90E8, 0x4E50 },
	{ 0x90E9, 0x4E60 },
	{ 0x90EA, 0x4E61 },
	{ 0x90EB, 0x4E66 },
	{ 0x90EC, 0x4E70 },
	{ 0x90ED, 0x4E78 },
	{ 0x90EE, 0x4E9A },
	{ 0x90EF, 0x4EA7 },
	{ 0x90F0, 0x4EA9 },
	{ 0x90F1, 0x4EAA },
	{ 0x90F2, 0x4EB5 },
	{ 0x90F3, 0x4EB8 },
	{ 0x90F4, 0x4EBB },
	{ 0x90F5, 0x4EBF },
	{ 0x90F6, 0x4ED1 },
	{ 0x90F7, 0x4ED3 },
	{ 0x90F8, 0x4EEA },
	{ 0x90F9, 0x4EEB },
	{ 0x90FA, 0x4EEC },
	{ 0x90FB, 0x4F1E },
	{ 0x90FC, 0x4F1F },
	{ 0x90FD, 0x4F20 },
	{ 0x90FE, 0x4F21 },
	{ 0x9140, 0x4F23 },
	{ 0x9141, 0x4F24 },
	{ 0x9142, 0x4F25 },
	{ 0x9143, 0x4F26 },
	{ 0x9144, 0x4F27 },
	{ 0x9145, 0x4F2A },
	{ 0x9146, 0x4F2B },
	{ 0x9147, 0x4F65 },
	{ 0x9148, 0x4FA5 },
	{ 0x9149, 0x4FA6 },
	{ 0x914A, 0x4FA7 },
	{ 0x914B, 0x4FA8 },
	{ 0x914C, 0x4FA9 },
	{ 0x914D, 0x4FAA },
	{ 0x914E, 0x4FAC },
	{ 0x914F, 0x4FE6 },
	{ 0x9150, 0x4FE8 },
	{ 0x9151, 0x4FEA },
	{ 0x9152, 0x4FEB },
	{ 0x9153, 0x4FED },
	{ 0x9154, 0x503A },
	{ 0x9155, 0x503D },
	{ 0x9156, 0x503E },
	{ 0x9157, 0x507E },
	{ 0x9158, 0x507F },
	{ 0x9159, 0x50A4 },
	{ 0x915A, 0x50A5 },
	{ 0x915B, 0x50A7 },
	{ 0x915C, 0x50A8 },
	{ 0x915D, 0x50A9 },
	{ 0x915E, 0x5170 },
	{ 0x915F, 0x5174 },
	{ 0x9160, 0x517B },
	{ 0x9161, 0x517D },
	{ 0x9162, 0x5181 },
	{ 0x9163, 0x519A },
	{ 0x9164, 0x519B },
	{ 0x9165, 0x519C },
	{ 0x9166, 0x51A7 },
	{ 0x9167, 0x51AE },
	{ 0x9168, 0x51AF },
	{ 0x9169, 0x51BB },
	{ 0x916A, 0x51EB },
	{ 0x916B, 0x51EF },
	{ 0x916C, 0x51FB },
	{ 0x916D, 0x51FC },
	{ 0x916E, 0x51FF },
	{ 0x916F, 0x520D },
	{ 0x9170, 0x5219 },
	{ 0x9171, 0x521A },
	{ 0x9172, 0x521B },
	{ 0x9173, 0x522C },
	{ 0x9174, 0x522D },
	{ 0x9175, 0x523F },
	{ 0x9176, 0x5240 },
	{ 0x9177, 0x5242 },
	{ 0x9178, 0x5250 },
	{ 0x9179, 0x5251 },
	{ 0x917A, 0x528F },
	{ 0x917B, 0x52A1 },
	{ 0x917C, 0x52A2 },
	{ 0x917D, 0x52B2 },
	{ 0x917E, 0x52CB },
	{ 0x917F, 0xFFFD },
	{ 0x9180, 0x67A2 },
	{ 0x9181, 0x678F },
	{ 0x9182, 0x67F9 },
	{ 0x9183, 0x6780 },
	{ 0x9184, 0x6B26 },
	{ 0x9185, 0x6B27 },
	{ 0x9186, 0x6B68 },
	{ 0x9187, 0x6B69 },
	{ 0x9188, 0x6B81 },
	{ 0x9189, 0x6BB4 },
	{ 0x918A, 0x6BD1 },
	{ 0x918B, 0x6C1C },
	{ 0x918C, 0x6C97 },
	{ 0x918D, 0x6C6C },
	{ 0x918E, 0x6CDF },
	{ 0x918F, 0x6CEA },
	{ 0x9190, 0x6CE4 },
	{ 0x9191, 0x6CD8 },
	{ 0x9192, 0x6CB2 },
	{ 0x9193, 0x6CCE },
	{ 0x9194, 0x6CC8 },
	{ 0x9195, 0x708B },
	{ 0x9196, 0x7088 },
	{ 0x9197, 0x7090 },
	{ 0x9198, 0x708F },
	{ 0x9199, 0x7087 },
	{ 0x919A, 0x7089 },
	{ 0x919B, 0x708D },
	{ 0x919C, 0x7081 },
	{ 0x919D, 0x708C },
	{ 0x919E, 0x7240 },
	{ 0x919F, 0x7265 },
	{ 0x91A0, 0x7266 },
	{ 0x91A1, 0x52DA },
	{ 0x91A2, 0x5326 },
	{ 0x91A3, 0x532E },
	{ 0x91A4, 0x5356 },
	{ 0x91A5, 0x5362 },
	{ 0x91A6, 0x536B },
	{ 0x91A7, 0x5385 },
	{ 0x91A8, 0x538C },
	{ 0x91A9, 0x538D },
	{ 0x91AA, 0x5390 },
	{ 0x91AB, 0x5395 },
	{ 0x91AC, 0x53A2 },
	{ 0x91AD, 0x53A3 },
	{ 0x91AE, 0x53BF },
	{ 0x91AF, 0x53C6 },
	{ 0x91B0, 0x53C7 },
	{ 0x91B1, 0x53D1 },
	{ 0x91B2, 0x53D8 },
	{ 0x91B3, 0x53FE },
	{ 0x91B4, 0x5417 },
	{ 0x91B5, 0x5452 },
	{ 0x91B6, 0x5453 },
	{ 0x91B7, 0x5456 },
	{ 0x91B8, 0x5457 },
	{ 0x91B9, 0x5458 },
	{ 0x91BA, 0x5459 },
	{ 0x91BB, 0x545B },
	{ 0x91BC, 0x545C },
	{ 0x91BD, 0x5497 },
	{ 0x91BE, 0x5499 },
	{ 0x91BF, 0x549B },
	{ 0x91C0, 0x549D },
	{ 0x91C1, 0x54D1 },
	{ 0x91C2, 0x54D2 },
	{ 0x91C3, 0x54D3 },
	{ 0x91C4, 0x54D4 },
	{ 0x91C5, 0x54D5 },
	{ 0x91C6, 0x54D7 },
	{ 0x91C7, 0x54D9 },
	{ 0x91C8, 0x54DC },
	{ 0x91C9, 0x54DD },
	{ 0x91CA, 0x54DF },
	{ 0x91CB, 0x551D },
	{ 0x91CC, 0x551E },
	{ 0x91CD, 0x5522 },
	{ 0x91CE, 0x5523 },
	{ 0x91CF, 0x5524 },
	{ 0x91D0, 0x5525 },
	{ 0x91D1, 0x5567 },
	{ 0x91D2, 0x556C },
	{ 0x91D3, 0x556D },
	{ 0x91D4, 0x556E },
	{ 0x91D5, 0x556F },
	{ 0x91D6, 0x5570 },
	{ 0x91D7, 0x5574 },
	{ 0x91D8, 0x5578 },
	{ 0x91D9, 0x5579 },
	{ 0x91DA, 0x55B7 },
	{ 0x91DB, 0x55B9 },
	{ 0x91DC, 0x55BC },
	{ 0x91DD, 0x55BE },
	{ 0x91DE, 0x55EB },
	{ 0x91DF, 0x55EC },
	{ 0x91E0, 0x55F3 },
	{ 0x91E1, 0x55F5 },
	{ 0x91E2, 0x5621 },
	{ 0x91E3, 0x5623 },
	{ 0x91E4, 0x5624 },
	{ 0x91E5, 0x5625 },
	{ 0x91E6, 0x565C },
	{ 0x91E7, 0x565D },
	{ 0x91E8, 0x567C },
	{ 0x91E9, 0x56A1 },
	{ 0x91EA, 0x56A3 },
	{ 0x91EB, 0x56A4 },
	{ 0x91EC, 0x56D6 },
	{ 0x91ED, 0x56E2 },
	{ 0x91EE, 0x56F4 },
	{ 0x91EF, 0x56F5 },
	{ 0x91F0, 0x56FE },
	{ 0x91F1, 0x5706 },
	{ 0x91F2, 0x5719 },
	{ 0x91F3, 0x5739 },
	{ 0x91F4, 0x573A },
	{ 0x91F5, 0x575A },
	{ 0x91F6, 0x575C },
	{ 0x91F7, 0x575D },
	{ 0x91F8, 0x575E },
	{ 0x91F9, 0x5760 },
	{ 0x91FA, 0x5784 },
	{ 0x91FB, 0x5785 },
	{ 0x91FC, 0x57AD },
	{ 0x91FD, 0x57AF },
	{ 0x91FE, 0x57B1 },
	{ 0x9240, 0x57B2 },
	{ 0x9241, 0x57D8 },
	{ 0x9242, 0x57D9 },
	{ 0x9243, 0x57DA },
	{ 0x9244, 0x5811 },
	{ 0x9245, 0x5816 },
	{ 0x9246, 0x5846 },
	{ 0x9247, 0x5899 },
	{ 0x9248, 0x58B6 },
	{ 0x9249, 0x58CB },
	{ 0x924A, 0x58EA },
	{ 0x924B, 0x58F6 },
	{ 0x924C, 0x58F8 },
	{ 0x924D, 0x5907 },
	{ 0x924E, 0x5939 },
	{ 0x924F, 0x593A },
	{ 0x9250, 0x5941 },
	{ 0x9251, 0x5942 },
	{ 0x9252, 0x5956 },
	{ 0x9253, 0x5987 },
	{ 0x9254, 0x5988 },
	{ 0x9255, 0x59A9 },
	{ 0x9256, 0x59AA },
	{ 0x9257, 0x59AB },
	{ 0x9258, 0x5A05 },
	{ 0x9259, 0x5A06 },
	{ 0x925A, 0x5A07 },
	{ 0x925B, 0x5A08 },
	{ 0x925C, 0x5A32 },
	{ 0x925D, 0x5A34 },
	{ 0x925E, 0x5A74 },
	{ 0x925F, 0x5A76 },
	{ 0x9260, 0x5AAD },
	{ 0x9261, 0x5AD2 },
	{ 0x9262, 0x5AD4 },
	{ 0x9263, 0x5AF1 },
	{ 0x9264, 0x5AF2 },
	{ 0x9265, 0x5B59 },
	{ 0x9266, 0x5B6D },
	{ 0x9267, 0x5BA0 },
	{ 0x9268, 0x5BA1 },
	{ 0x9269, 0x5BAA },
	{ 0x926A, 0x5BBD },
	{ 0x926B, 0x5BFB },
	{ 0x926C, 0x5BFC },
	{ 0x926D, 0x5C1C },
	{ 0x926E, 0x5C1D },
	{ 0x926F, 0x5C27 },
	{ 0x9270, 0x5C34 },
	{ 0x9271, 0x5C42 },
	{ 0x9272, 0x5C43 },
	{ 0x9273, 0x5C66 },
	{ 0x9274, 0x5C72 },
	{ 0x9275, 0x5C7F },
	{ 0x9276, 0x5C82 },
	{ 0x9277, 0x5C83 },
	{ 0x9278, 0x5C96 },
	{ 0x9279, 0x5C98 },
	{ 0x927A, 0x5C99 },
	{ 0x927B, 0x5C9A },
	{ 0x927C, 0x5C9B },
	{ 0x927D, 0x5CBD },
	{ 0x927E, 0x5CBF },
	{ 0x927F, 0xFFFD },
	{ 0x9280, 0x7268 },
	{ 0x9281, 0x72CD },
	{ 0x9282, 0x72D3 },
	{ 0x9283, 0x72DB },
	{ 0x9284, 0x72CF },
	{ 0x9285, 0x73A7 },
	{ 0x9286, 0x73A3 },
	{ 0x9287, 0x739E },
	{ 0x9288, 0x73AF },
	{ 0x9289, 0x73AA },
	{ 0x928A, 0x739C },
	{ 0x928B, 0x7542 },
	{ 0x928C, 0x7544 },
	{ 0x928D, 0x753B },
	{ 0x928E, 0x7541 },
	{ 0x928F, 0x759B },
	{ 0x9290, 0x759E },
	{ 0x9291, 0x79C4 },
	{ 0x9292, 0x79C3 },
	{ 0x9293, 0x79C6 },
	{ 0x9294, 0x79C7 },
	{ 0x9295, 0x79CA },
	{ 0x9296, 0x7ACF },
	{ 0x9297, 0x7C76 },
	{ 0x9298, 0x7C74 },
	{ 0x9299, 0x7CFF },
	{ 0x929A, 0x7CFC },
	{ 0x929B, 0x7F59 },
	{ 0x929C, 0x80A8 },
	{ 0x929D, 0x80B0 },
	{ 0x929E, 0x80B3 },
	{ 0x929F, 0x80A4 },
	{ 0x92A0, 0x80B6 },
	{ 0x92A1, 0x5CC2 },
	{ 0x92A2, 0x5CC3 },
	{ 0x92A3, 0x5CC4 },
	{ 0x92A4, 0x5CE3 },
	{ 0x92A5, 0x5CE4 },
	{ 0x92A6, 0x5CE7 },
	{ 0x92A7, 0x5D02 },
	{ 0x92A8, 0x5D03 },
	{ 0x92A9, 0x5D04 },
	{ 0x92AA, 0x5D05 },
	{ 0x92AB, 0x5D2D },
	{ 0x92AC, 0x5D58 },
	{ 0x92AD, 0x5D5A },
	{ 0x92AE, 0x5D5D },
	{ 0x92AF, 0x5DC5 },
	{ 0x92B0, 0x5DEF },
	{ 0x92B1, 0x5E05 },
	{ 0x92B2, 0x5E0F },
	{ 0x92B3, 0x5E10 },
	{ 0x92B4, 0x5E1C },
	{ 0x92B5, 0x5E26 },
	{ 0x92B6, 0x5E27 },
	{ 0x92B7, 0x5E31 },
	{ 0x92B8, 0x5E3B },
	{ 0x92B9, 0x5E3C },
	{ 0x92BA, 0x5E86 },
	{ 0x92BB, 0x5E91 },
	{ 0x92BC, 0x5E93 },
	{ 0x92BD, 0x5E94 },
	{ 0x92BE, 0x5E9E },
	{ 0x92BF, 0x5E9F },
	{ 0x92C0, 0x5EBC },
	{ 0x92C1, 0x5F20 },
	{ 0x92C2, 0x5F2A },
	{ 0x92C3, 0x5F5F },
	{ 0x92C4, 0x5F68 },
	{ 0x92C5, 0x5F7B },
	{ 0x92C6, 0x5F95 },
	{ 0x92C7, 0x6001 },
	{ 0x92C8, 0x6002 },
	{ 0x92C9, 0x6003 },
	{ 0x92CA, 0x6004 },
	{ 0x92CB, 0x6005 },
	{ 0x92CC, 0x6006 },
	{ 0x92CD, 0x603B },
	{ 0x92CE, 0x603C },
	{ 0x92CF, 0x603F },
	{ 0x92D0, 0x6076 },
	{ 0x92D1, 0x6078 },
	{ 0x92D2, 0x6079 },
	{ 0x92D3, 0x607A },
	{ 0x92D4, 0x607B },
	{ 0x92D5, 0x607D },
	{ 0x92D6, 0x60AB },
	{ 0x92D7, 0x60AC },
	{ 0x92D8, 0x60AD },
	{ 0x92D9, 0x60AF },
	{ 0x92DA, 0x60EB },
	{ 0x92DB, 0x60EC },
	{ 0x92DC, 0x60ED },
	{ 0x92DD, 0x60EF },
	{ 0x92DE, 0x6124 },
	{ 0x92DF, 0x6126 },
	{ 0x92E0, 0x6151 },
	{ 0x92E1, 0x61D1 },
	{ 0x92E2, 0x61D2 },
	{ 0x92E3, 0x61D4 },
	{ 0x92E4, 0x6206 },
	{ 0x92E5, 0x620B },
	{ 0x92E6, 0x6217 },
	{ 0x92E7, 0x6269 },
	{ 0x92E8, 0x626A },
	{ 0x92E9, 0x626B },
	{ 0x92EA, 0x626C },
	{ 0x92EB, 0x629F },
	{ 0x92EC, 0x62A0 },
	{ 0x92ED, 0x62A1 },
	{ 0x92EE, 0x62A2 },
	{ 0x92EF, 0x62E2 },
	{ 0x92F0, 0x62E3 },
	{ 0x92F1, 0x62E6 },
	{ 0x92F2, 0x62E7 },
	{ 0x92F3, 0x62E8 },
	{ 0x92F4, 0x62E9 },
	{ 0x92F5, 0x631A },
	{ 0x92F6, 0x631C },
	{ 0x92F7, 0x631D },
	{ 0x92F8, 0x631E },
	{ 0x92F9, 0x6320 },
	{ 0x92FA, 0x6322 },
	{ 0x92FB, 0x6324 },
	{ 0x92FC, 0x6325 },
	{ 0x92FD, 0x6326 },
	{ 0x92FE, 0x635E },
	{ 0x9340, 0x635F },
	{ 0x9341, 0x6361 },
	{ 0x9342, 0x6362 },
	{ 0x9343, 0x6363 },
	{ 0x9344, 0x63B3 },
	{ 0x9345, 0x63B7 },
	{ 0x9346, 0x63B8 },
	{ 0x9347, 0x63B9 },
	{ 0x9348, 0x63BC },
	{ 0x9349, 0x63FB },
	{ 0x934A, 0x63FC },
	{ 0x934B, 0x63FD },
	{ 0x934C, 0x63FF },
	{ 0x934D, 0x6400 },
	{ 0x934E, 0x6401 },
	{ 0x934F, 0x6402 },
	{ 0x9350, 0x6404 },
	{ 0x9351, 0x6405 },
	{ 0x9352, 0x6444 },
	{ 0x9353, 0x6445 },
	{ 0x9354, 0x6448 },
	{ 0x9355, 0x644A },
	{ 0x9356, 0x6484 },
	{ 0x9357, 0x64B5 },
	{ 0x9358, 0x64B7 },
	{ 0x9359, 0x64B8 },
	{ 0x935A, 0x64BA },
	{ 0x935B, 0x64DD },
	{ 0x935C, 0x64DE },
	{ 0x935D, 0x6512 },
	{ 0x935E, 0x6569 },
	{ 0x935F, 0x6586 },
	{ 0x9360, 0x658F },
	{ 0x9361, 0x6593 },
	{ 0x9362, 0x65A9 },
	{ 0x9363, 0x65F7 },
	{ 0x9364, 0x65F8 },
	{ 0x9365, 0x663D },
	{ 0x9366, 0x663E },
	{ 0x9367, 0x6653 },
	{ 0x9368, 0x6654 },
	{ 0x9369, 0x6655 },
	{ 0x936A, 0x6656 },
	{ 0x936B, 0x6682 },
	{ 0x936C, 0x66A7 },
	{ 0x936D, 0x6743 },
	{ 0x936E, 0x6767 },
	{ 0x936F, 0x6768 },
	{ 0x9370, 0x6769 },
	{ 0x9371, 0x67A5 },
	{ 0x9372, 0x67A7 },
	{ 0x9373, 0x67A8 },
	{ 0x9374, 0x67AA },
	{ 0x9375, 0x67AB },
	{ 0x9376, 0x67AD },
	{ 0x9377, 0x67FD },
	{ 0x9378, 0x6807 },
	{ 0x9379, 0x6808 },
	{ 0x937A, 0x6809 },
	{ 0x937B, 0x680A },
	{ 0x937C, 0x680B },
	{ 0x937D, 0x680C },
	{ 0x937E, 0x680E },
	{ 0x937F, 0xFFFD },
	{ 0x9380, 0x80A7 },
	{ 0x9381, 0x80AC },
	{ 0x9382, 0x80A6 },
	{ 0x9383, 0x5367 },
	{ 0x9384, 0x820E },
	{ 0x9385, 0x82C4 },
	{ 0x9386, 0x833E },
	{ 0x9387, 0x829C },
	{ 0x9388, 0x82AA },
	{ 0x9389, 0x82C9 },
	{ 0x938A, 0x82A6 },
	{ 0x938B, 0x82B2 },
	{ 0x938C, 0x8FCC },
	{ 0x938D, 0x8FD9 },
	{ 0x938E, 0x8FCA },
	{ 0x938F, 0x8FD8 },
	{ 0x9390, 0x8FCF },
	{ 0x9391, 0x90B7 },
	{ 0x9392, 0x90AD },
	{ 0x9393, 0x90B9 },
	{ 0x9394, 0x9637 },
	{ 0x9395, 0x9641 },
	{ 0x9396, 0x963E },
	{ 0x9397, 0x9751 },
	{ 0x9398, 0x9763 },
	{ 0x9399, 0x4E57 },
	{ 0x939A, 0x4E79 },
	{ 0x939B, 0x4EB2 },
	{ 0x939C, 0x4EB0 },
	{ 0x939D, 0x4EAF },
	{ 0x939E, 0x4EB1 },
	{ 0x939F, 0x4FD2 },
	{ 0x93A0, 0x4FD5 },
	{ 0x93A1, 0x680F },
	{ 0x93A2, 0x6860 },
	{ 0x93A3, 0x6861 },
	{ 0x93A4, 0x6862 },
	{ 0x93A5, 0x6864 },
	{ 0x93A6, 0x6865 },
	{ 0x93A7, 0x6866 },
	{ 0x93A8, 0x6868 },
	{ 0x93A9, 0x6869 },
	{ 0x93AA, 0x686A },
	{ 0x93AB, 0x68BE },
	{ 0x93AC, 0x68BF },
	{ 0x93AD, 0x68C0 },
	{ 0x93AE, 0x691D },
	{ 0x93AF, 0x691F },
	{ 0x93B0, 0x6920 },
	{ 0x93B1, 0x6924 },
	{ 0x93B2, 0x692D },
	{ 0x93B3, 0x6984 },
	{ 0x93B4, 0x6987 },
	{ 0x93B5, 0x6988 },
	{ 0x93B6, 0x6989 },
	{ 0x93B7, 0x69DA },
	{ 0x93B8, 0x69DB },
	{ 0x93B9, 0x69DC },
	{ 0x93BA, 0x69DF },
	{ 0x93BB, 0x69E0 },
	{ 0x93BC, 0x6A2F },
	{ 0x93BD, 0x6A31 },
	{ 0x93BE, 0x6A79 },
	{ 0x93BF, 0x6A7C },
	{ 0x93C0, 0x6AA9 },
	{ 0x93C1, 0x6B7C },
	{ 0x93C2, 0x6B87 },
	{ 0x93C3, 0x6B92 },
	{ 0x93C4, 0x6B93 },
	{ 0x93C5, 0x6B9A },
	{ 0x93C6, 0x6BC2 },
	{ 0x93C7, 0x6BD5 },
	{ 0x93C8, 0x6BD9 },
	{ 0x93C9, 0x6C07 },
	{ 0x93CA, 0x6C22 },
	{ 0x93CB, 0x6C29 },
	{ 0x93CC, 0x6C47 },
	{ 0x93CD, 0x6C48 },
	{ 0x93CE, 0x6C64 },
	{ 0x93CF, 0x6CA4 },
	{ 0x93D0, 0x6CA5 },
	{ 0x93D1, 0x6CA6 },
	{ 0x93D2, 0x6CA7 },
	{ 0x93D3, 0x6CA8 },
	{ 0x93D4, 0x6CA9 },
	{ 0x93D5, 0x6CF6 },
	{ 0x93D6, 0x6CF7 },
	{ 0x93D7, 0x6CF8 },
	{ 0x93D8, 0x6CFA },
	{ 0x93D9, 0x6CFB },
	{ 0x93DA, 0x6CFC },
	{ 0x93DB, 0x6CFD },
	{ 0x93DC, 0x6CFE },
	{ 0x93DD, 0x6D46 },
	{ 0x93DE, 0x6D47 },
	{ 0x93DF, 0x6D48 },
	{ 0x93E0, 0x6D49 },
	{ 0x93E1, 0x6D4A },
	{ 0x93E2, 0x6D4B },
	{ 0x93E3, 0x6D4D },
	{ 0x93E4, 0x6D4E },
	{ 0x93E5, 0x6D4F },
	{ 0x93E6, 0x6D50 },
	{ 0x93E7, 0x6D51 },
	{ 0x93E8, 0x6D52 },
	{ 0x93E9, 0x6D53 },
	{ 0x93EA, 0x6D54 },
	{ 0x93EB, 0x6D55 },
	{ 0x93EC, 0x6D9D },
	{ 0x93ED, 0x6D9F },
	{ 0x93EE, 0x6DA0 },
	{ 0x93EF, 0x6DA1 },
	{ 0x93F0, 0x6DA2 },
	{ 0x93F1, 0x6DA3 },
	{ 0x93F2, 0x6DA4 },
	{ 0x93F3, 0x6DA6 },
	{ 0x93F4, 0x6DA7 },
	{ 0x93F5, 0x6DA8 },
	{ 0x93F6, 0x6DA9 },
	{ 0x93F7, 0x6E0D },
	{ 0x93F8, 0x6E0E },
	{ 0x93F9, 0x6E10 },
	{ 0x93FA, 0x6E11 },
	{ 0x93FB, 0x6E14 },
	{ 0x93FC, 0x6E16 },
	{ 0x93FD, 0x6E81 },
	{ 0x93FE, 0x6E83 },
	{ 0x9440, 0x6E85 },
	{ 0x9441, 0x6E87 },
	{ 0x9442, 0x6EDF },
	{ 0x9443, 0x6EE0 },
	{ 0x9444, 0x6EE1 },
	{ 0x9445, 0x6EE2 },
	{ 0x9446, 0x6EE4 },
	{ 0x9447, 0x6EE5 },
	{ 0x9448, 0x6EE7 },
	{ 0x9449, 0x6EEA },
	{ 0x944A, 0x6F47 },
	{ 0x944B, 0x6F4B },
	{ 0x944C, 0x6F4D },
	{ 0x944D, 0x6F9B },
	{ 0x944E, 0x6F9C },
	{ 0x944F, 0x6FD1 },
	{ 0x9450, 0x6FD2 },
	{ 0x9451, 0x704F },
	{ 0x9452, 0x706D },
	{ 0x9453, 0x7080 },
	{ 0x9454, 0x709C },
	{ 0x9455, 0x709D },
	{ 0x9456, 0x709E },
	{ 0x9457, 0x70BC },
	{ 0x9458, 0x70BD },
	{ 0x9459, 0x70C1 },
	{ 0x945A, 0x70C2 },
	{ 0x945B, 0x70C3 },
	{ 0x945C, 0x70E6 },
	{ 0x945D, 0x70E7 },
	{ 0x945E, 0x70E8 },
	{ 0x945F, 0x70E9 },
	{ 0x9460, 0x70EB },
	{ 0x9461, 0x70EC },
	{ 0x9462, 0x70ED },
	{ 0x9463, 0x7115 },
	{ 0x9464, 0x7116 },
	{ 0x9465, 0x7118 },
	{ 0x9466, 0x7140 },
	{ 0x9467, 0x71F7 },
	{ 0x9468, 0x7231 },
	{ 0x9469, 0x7237 },
	{ 0x946A, 0x724D },
	{ 0x946B, 0x7275 },
	{ 0x946C, 0x728A },
	{ 0x946D, 0x72B7 },
	{ 0x946E, 0x72B8 },
	{ 0x946F, 0x72C8 },
	{ 0x9470, 0x72DE },
	{ 0x9471, 0x72EE },
	{ 0x9472, 0x72EF },
	{ 0x9473, 0x72F0 },
	{ 0x9474, 0x72F1 },
	{ 0x9475, 0x72F2 },
	{ 0x9476, 0x7303 },
	{ 0x9477, 0x7321 },
	{ 0x9478, 0x736D },
	{ 0x9479, 0x7399 },
	{ 0x947A, 0x739A },
	{ 0x947B, 0x739B },
	{ 0x947C, 0x73AE },
	{ 0x947D, 0x73B0 },
	{ 0x947E, 0x73B1 },
	{ 0x947F, 0xFFFD },
	{ 0x9480, 0x4FBE },
	{ 0x9481, 0x4FB8 },
	{ 0x9482, 0x4FB0 },
	{ 0x9483, 0x4FB1 },
	{ 0x9484, 0x4FC8 },
	{ 0x9485, 0x4FC6 },
	{ 0x9486, 0x4FCC },
	{ 0x9487, 0x4FE5 },
	{ 0x9488, 0x4FE3 },
	{ 0x9489, 0x4FB4 },
	{ 0x948A, 0x516A },
	{ 0x948B, 0x519F },
	{ 0x948C, 0x51C1 },
	{ 0x948D, 0x51C2 },
	{ 0x948E, 0x51C3 },
	{ 0x948F, 0x5245 },
	{ 0x9490, 0x5248 },
	{ 0x9491, 0x524F },
	{ 0x9492, 0x52C5 },
	{ 0x9493, 0x52CA },
	{ 0x9494, 0x52C4 },
	{ 0x9495, 0x5327 },
	{ 0x9496, 0x5358 },
	{ 0x9497, 0x537D },
	{ 0x9498, 0x53DD },
	{ 0x9499, 0x53DC },
	{ 0x949A, 0x53DA },
	{ 0x949B, 0x53D9 },
	{ 0x949C, 0x54B9 },
	{ 0x949D, 0x54D0 },
	{ 0x949E, 0x54B4 },
	{ 0x949F, 0x54CA },
	{ 0x94A0, 0x54A3 },
	{ 0x94A1, 0x73D1 },
	{ 0x94A2, 0x73F0 },
	{ 0x94A3, 0x73F2 },
	{ 0x94A4, 0x740E },
	{ 0x94A5, 0x740F },
	{ 0x94A6, 0x7410 },
	{ 0x94A7, 0x7437 },
	{ 0x94A8, 0x7477 },
	{ 0x94A9, 0x748E },
	{ 0x94AA, 0x74D2 },
	{ 0x94AB, 0x7519 },
	{ 0x94AC, 0x7534 },
	{ 0x94AD, 0x7535 },
	{ 0x94AE, 0x7545 },
	{ 0x94AF, 0x758D },
	{ 0x94B0, 0x7596 },
	{ 0x94B1, 0x759F },
	{ 0x94B2, 0x75A0 },
	{ 0x94B3, 0x75A1 },
	{ 0x94B4, 0x75AC },
	{ 0x94B5, 0x75AD },
	{ 0x94B6, 0x75AE },
	{ 0x94B7, 0x75AF },
	{ 0x94B8, 0x75C8 },
	{ 0x94B9, 0x75C9 },
	{ 0x94BA, 0x75D6 },
	{ 0x94BB, 0x75E8 },
	{ 0x94BC, 0x75EA },
	{ 0x94BD, 0x75EB },
	{ 0x94BE, 0x7605 },
	{ 0x94BF, 0x7617 },
	{ 0x94C0, 0x7618 },
	{ 0x94C1, 0x762A },
	{ 0x94C2, 0x762B },
	{ 0x94C3, 0x763E },
	{ 0x94C4, 0x763F },
	{ 0x94C5, 0x765D },
	{ 0x94C6, 0x765E },
	{ 0x94C7, 0x7663 },
	{ 0x94C8, 0x7666 },
	{ 0x94C9, 0x766B },
	{ 0x94CA, 0x7691 },
	{ 0x94CB, 0x76B1 },
	{ 0x94CC, 0x76B2 },
	{ 0x94CD, 0x76CF },
	{ 0x94CE, 0x76D0 },
	{ 0x94CF, 0x76D1 },
	{ 0x94D0, 0x770D },
	{ 0x94D1, 0x772C },
	{ 0x94D2, 0x7750 },
	{ 0x94D3, 0x7751 },
	{ 0x94D4, 0x7786 },
	{ 0x94D5, 0x7792 },
	{ 0x94D6, 0x7793 },
	{ 0x94D7, 0x77CB },
	{ 0x94D8, 0x77EB },
	{ 0x94D9, 0x77FF },
	{ 0x94DA, 0x7800 },
	{ 0x94DB, 0x7801 },
	{ 0x94DC, 0x7816 },
	{ 0x94DD, 0x7817 },
	{ 0x94DE, 0x781A },
	{ 0x94DF, 0x781C },
	{ 0x94E0, 0x7839 },
	{ 0x94E1, 0x783B },
	{ 0x94E2, 0x783E },
	{ 0x94E3, 0x7840 },
	{ 0x94E4, 0x7841 },
	{ 0x94E5, 0x7855 },
	{ 0x94E6, 0x7856 },
	{ 0x94E7, 0x7857 },
	{ 0x94E8, 0x7859 },
	{ 0x94E9, 0x785A },
	{ 0x94EA, 0x785B },
	{ 0x94EB, 0x7875 },
	{ 0x94EC, 0x7877 },
	{ 0x94ED, 0x789B },
	{ 0x94EE, 0x78D7 },
	{ 0x94EF, 0x78D9 },
	{ 0x94F0, 0x7903 },
	{ 0x94F1, 0x7933 },
	{ 0x94F2, 0x7943 },
	{ 0x94F3, 0x794E },
	{ 0x94F4, 0x796F },
	{ 0x94F5, 0x7978 },
	{ 0x94F6, 0x79EF },
	{ 0x94F7, 0x79FE },
	{ 0x94F8, 0x7A06 },
	{ 0x94F9, 0x7A23 },
	{ 0x94FA, 0x7A51 },
	{ 0x94FB, 0x7A52 },
	{ 0x94FC, 0x7A5E },
	{ 0x94FD, 0x7A77 },
	{ 0x94FE, 0x7A8D },
	{ 0x9540, 0x7A8E },
	{ 0x9541, 0x7A9C },
	{ 0x9542, 0x7A9D },
	{ 0x9543, 0x7AA5 },
	{ 0x9544, 0x7AA6 },
	{ 0x9545, 0x7AAD },
	{ 0x9546, 0x7AD6 },
	{ 0x9547, 0x7ADE },
	{ 0x9548, 0x7B03 },
	{ 0x9549, 0x7B15 },
	{ 0x954A, 0x7B3A },
	{ 0x954B, 0x7B3C },
	{ 0x954C, 0x7B3E },
	{ 0x954D, 0x7B5A },
	{ 0x954E, 0x7B5B },
	{ 0x954F, 0x7B5C },
	{ 0x9550, 0x7B7C },
	{ 0x9551, 0x7B7E },
	{ 0x9552, 0x7B7F },
	{ 0x9553, 0x7B80 },
	{ 0x9554, 0x7BA6 },
	{ 0x9555, 0x7BA7 },
	{ 0x9556, 0x7BA8 },
	{ 0x9557, 0x7BA9 },
	{ 0x9558, 0x7BAB },
	{ 0x9559, 0x7BD1 },
	{ 0x955A, 0x7BD3 },
	{ 0x955B, 0x7BEE },
	{ 0x955C, 0x7BEF },
	{ 0x955D, 0x7C16 },
	{ 0x955E, 0x7C41 },
	{ 0x955F, 0x7CAA },
	{ 0x9560, 0x7CF9 },
	{ 0x9561, 0x7D27 },
	{ 0x9562, 0x7D77 },
	{ 0x9563, 0x7DD4 },
	{ 0x9564, 0x7E06 },
	{ 0x9565, 0x7E9F },
	{ 0x9566, 0x7EA0 },
	{ 0x9567, 0x7EA1 },
	{ 0x9568, 0x7EA2 },
	{ 0x9569, 0x7EA3 },
	{ 0x956A, 0x7EA4 },
	{ 0x956B, 0x7EA5 },
	{ 0x956C, 0x7EA6 },
	{ 0x956D, 0x7EA7 },
	{ 0x956E, 0x7EA8 },
	{ 0x956F, 0x7EA9 },
	{ 0x9570, 0x7EAA },
	{ 0x9571, 0x7EAB },
	{ 0x9572, 0x7EAC },
	{ 0x9573, 0x7EAD },
	{ 0x9574, 0x7EAE },
	{ 0x9575, 0x7EAF },
	{ 0x9576, 0x7EB0 },
	{ 0x9577, 0x7EB1 },
	{ 0x9578, 0x7EB2 },
	{ 0x9579, 0x7EB3 },
	{ 0x957A, 0x7EB4 },
	{ 0x957B, 0x7EB5 },
	{ 0x957C, 0x7EB6 },
	{ 0x957D, 0x7EB7 },
	{ 0x957E, 0x7EB8 },
	{ 0x957F, 0xFFFD },
	{ 0x9580, 0x54DA },
	{ 0x9581, 0x54A4 },
	{ 0x9582, 0x54B2 },
	{ 0x9583, 0x549E },
	{ 0x9584, 0x549F },
	{ 0x9585, 0x54B5 },
	{ 0x9586, 0x54CD },
	{ 0x9587, 0x54CC },
	{ 0x9588, 0x5700 },
	{ 0x9589, 0x57AC },
	{ 0x958A, 0x5791 },
	{ 0x958B, 0x578E },
	{ 0x958C, 0x578D },
	{ 0x958D, 0x5792 },
	{ 0x958E, 0x57A1 },
	{ 0x958F, 0x5790 },
	{ 0x9590, 0x57A6 },
	{ 0x9591, 0x57A8 },
	{ 0x9592, 0x579C },
	{ 0x9593, 0x5796 },
	{ 0x9594, 0x57A7 },
	{ 0x9595, 0x58F5 },
	{ 0x9596, 0x5909 },
	{ 0x9597, 0x5908 },
	{ 0x9598, 0x5952 },
	{ 0x9599, 0x59DF },
	{ 0x959A, 0x59EB },
	{ 0x959B, 0x59EF },
	{ 0x959C, 0x59F0 },
	{ 0x959D, 0x59D5 },
	{ 0x959E, 0x5A0D },
	{ 0x959F, 0x5A04 },
	{ 0x95A0, 0x59F9 },
	{ 0x95A1, 0x7EB9 },
	{ 0x95A2, 0x7EBA },
	{ 0x95A3, 0x7EBB },
	{ 0x95A4, 0x7EBC },
	{ 0x95A5, 0x7EBD },
	{ 0x95A6, 0x7EBE },
	{ 0x95A7, 0x7EBF },
	{ 0x95A8, 0x7EC0 },
	{ 0x95A9, 0x7EC1 },
	{ 0x95AA, 0x7EC2 },
	{ 0x95AB, 0x7EC3 },
	{ 0x95AC, 0x7EC4 },
	{ 0x95AD, 0x7EC5 },
	{ 0x95AE, 0x7EC6 },
	{ 0x95AF, 0x7EC7 },
	{ 0x95B0, 0x7EC8 },
	{ 0x95B1, 0x7EC9 },
	{ 0x95B2, 0x7ECA },
	{ 0x95B3, 0x7ECB },
	{ 0x95B4, 0x7ECC },
	{ 0x95B5, 0x7ECD },
	{ 0x95B6, 0x7ECE },
	{ 0x95B7, 0x7ECF },
	{ 0x95B8, 0x7ED0 },
	{ 0x95B9, 0x7ED1 },
	{ 0x95BA, 0x7ED2 },
	{ 0x95BB, 0x7ED3 },
	{ 0x95BC, 0x7ED4 },
	{ 0x95BD, 0x7ED5 },
	{ 0x95BE, 0x7ED6 },
	{ 0x95BF, 0x7ED7 },
	{ 0x95C0, 0x7ED8 },
	{ 0x95C1, 0x7ED9 },
	{ 0x95C2, 0x7EDA },
	{ 0x95C3, 0x7EDB },
	{ 0x95C4, 0x7EDC },
	{ 0x95C5, 0x7EDD },
	{ 0x95C6, 0x7EDE },
	{ 0x95C7, 0x7EDF },
	{ 0x95C8, 0x7EE0 },
	{ 0x95C9, 0x7EE1 },
	{ 0x95CA, 0x7EE2 },
	{ 0x95CB, 0x7EE3 },
	{ 0x95CC, 0x7EE4 },
	{ 0x95CD, 0x7EE5 },
	{ 0x95CE, 0x7EE6 },
	{ 0x95CF, 0x7EE7 },
	{ 0x95D0, 0x7EE8 },
	{ 0x95D1, 0x7EE9 },
	{ 0x95D2, 0x7EEA },
	{ 0x95D3, 0x7EEB },
	{ 0x95D4, 0x7EEC },
	{ 0x95D5, 0x7EED },
	{ 0x95D6, 0x7EEE },
	{ 0x95D7, 0x7EEF },
	{ 0x95D8, 0x7EF0 },
	{ 0x95D9, 0x7EF1 },
	{ 0x95DA, 0x7EF2 },
	{ 0x95DB, 0x7EF3 },
	{ 0x95DC, 0x7EF4 },
	{ 0x95DD, 0x7EF5 },
	{ 0x95DE, 0x7EF6 },
	{ 0x95DF, 0x7EF7 },
	{ 0x95E0, 0x7EF8 },
	{ 0x95E1, 0x7EF9 },
	{ 0x95E2, 0x7EFA },
	{ 0x95E3, 0x7EFB },
	{ 0x95E4, 0x7EFC },
	{ 0x95E5, 0x7EFD },
	{ 0x95E6, 0x7EFE },
	{ 0x95E7, 0x7EFF },
	{ 0x95E8, 0x7F00 },
	{ 0x95E9, 0x7F01 },
	{ 0x95EA, 0x7F02 },
	{ 0x95EB, 0x7F03 },
	{ 0x95EC, 0x7F04 },
	{ 0x95ED, 0x7F05 },
	{ 0x95EE, 0x7F06 },
	{ 0x95EF, 0x7F07 },
	{ 0x95F0, 0x7F08 },
	{ 0x95F1, 0x7F09 },
	{ 0x95F2, 0x7F0A },
	{ 0x95F3, 0x7F0B },
	{ 0x95F4, 0x7F0C },
	{ 0x95F5, 0x7F0D },
	{ 0x95F6, 0x7F0E },
	{ 0x95F7, 0x7F0F },
	{ 0x95F8, 0x7F10 },
	{ 0x95F9, 0x7F11 },
	{ 0x95FA, 0x7F12 },
	{ 0x95FB, 0x7F13 },
	{ 0x95FC, 0x7F14 },
	{ 0x95FD, 0x7F15 },
	{ 0x95FE, 0x7F16 },
	{ 0x9640, 0x7F17 },
	{ 0x9641, 0x7F18 },
	{ 0x9642, 0x7F19 },
	{ 0x9643, 0x7F1A },
	{ 0x9644, 0x7F1B },
	{ 0x9645, 0x7F1C },
	{ 0x9646, 0x7F1D },
	{ 0x9647, 0x7F1E },
	{ 0x9648, 0x7F1F },
	{ 0x9649, 0x7F20 },
	{ 0x964A, 0x7F21 },
	{ 0x964B, 0x7F22 },
	{ 0x964C, 0x7F23 },
	{ 0x964D, 0x7F24 },
	{ 0x964E, 0x7F25 },
	{ 0x964F, 0x7F26 },
	{ 0x9650, 0x7F27 },
	{ 0x9651, 0x7F28 },
	{ 0x9652, 0x7F29 },
	{ 0x9653, 0x7F2A },
	{ 0x9654, 0x7F2B },
	{ 0x9655, 0x7F2C },
	{ 0x9656, 0x7F2D },
	{ 0x9657, 0x7F2E },
	{ 0x9658, 0x7F2F },
	{ 0x9659, 0x7F30 },
	{ 0x965A, 0x7F31 },
	{ 0x965B, 0x7F32 },
	{ 0x965C, 0x7F33 },
	{ 0x965D, 0x7F34 },
	{ 0x965E, 0x7F35 },
	{ 0x965F, 0x7F42 },
	{ 0x9660, 0x7F49 },
	{ 0x9661, 0x7F56 },
	{ 0x9662, 0x7F5A },
	{ 0x9663, 0x7F74 },
	{ 0x9664, 0x7F81 },
	{ 0x9665, 0x7F9F },
	{ 0x9666, 0x7FD8 },
	{ 0x9667, 0x7FD9 },
	{ 0x9668, 0x7FDA },
	{ 0x9669, 0x8022 },
	{ 0x966A, 0x8027 },
	{ 0x966B, 0x8042 },
	{ 0x966C, 0x804B },
	{ 0x966D, 0x804C },
	{ 0x966E, 0x804D },
	{ 0x966F, 0x8054 },
	{ 0x9670, 0x8069 },
	{ 0x9671, 0x8080 },
	{ 0x9672, 0x8083 },
	{ 0x9673, 0x80A0 },
	{ 0x9674, 0x80BC },
	{ 0x9675, 0x80BD },
	{ 0x9676, 0x80BE },
	{ 0x9677, 0x80BF },
	{ 0x9678, 0x80C0 },
	{ 0x9679, 0x80C1 },
	{ 0x967A, 0x80E7 },
	{ 0x967B, 0x80E8 },
	{ 0x967C, 0x80E9 },
	{ 0x967D, 0x80EA },
	{ 0x967E, 0x80EB },
	{ 0x967F, 0xFFFD },
	{ 0x9680, 0x5A02 },
	{ 0x9681, 0x59F8 },
	{ 0x9682, 0x59E2 },
	{ 0x9683, 0x59D9 },
	{ 0x9684, 0x59E7 },
	{ 0x9685, 0x5B6A },
	{ 0x9686, 0x5BAB },
	{ 0x9687, 0x5C1B },
	{ 0x9688, 0x5C2F },
	{ 0x9689, 0x663C },
	{ 0x968A, 0x5CD1 },
	{ 0x968B, 0x5CDC },
	{ 0x968C, 0x5CE6 },
	{ 0x968D, 0x5CE1 },
	{ 0x968E, 0x5CCD },
	{ 0x968F, 0x5CE2 },
	{ 0x9690, 0x5CDD },
	{ 0x9691, 0x5CE5 },
	{ 0x9692, 0x5DFB },
	{ 0x9693, 0x5DFA },
	{ 0x9694, 0x5E1E },
	{ 0x9695, 0x5EA1 },
	{ 0x9696, 0x5EFC },
	{ 0x9697, 0x5EFB },
	{ 0x9698, 0x5F2F },
	{ 0x9699, 0x5F66 },
	{ 0x969A, 0x605C },
	{ 0x969B, 0x604E },
	{ 0x969C, 0x6051 },
	{ 0x969D, 0x6023 },
	{ 0x969E, 0x6031 },
	{ 0x969F, 0x607C },
	{ 0x96A0, 0x6060 },
	{ 0x96A1, 0x80EC },
	{ 0x96A2, 0x810C },
	{ 0x96A3, 0x810D },
	{ 0x96A4, 0x810E },
	{ 0x96A5, 0x810F },
	{ 0x96A6, 0x8110 },
	{ 0x96A7, 0x8111 },
	{ 0x96A8, 0x8112 },
	{ 0x96A9, 0x8113 },
	{ 0x96AA, 0x8132 },
	{ 0x96AB, 0x8136 },
	{ 0x96AC, 0x8137 },
	{ 0x96AD, 0x8138 },
	{ 0x96AE, 0x8156 },
	{ 0x96AF, 0x8159 },
	{ 0x96B0, 0x815A },
	{ 0x96B1, 0x817B },
	{ 0x96B2, 0x817C },
	{ 0x96B3, 0x817E },
	{ 0x96B4, 0x8191 },
	{ 0x96B5, 0x81A5 },
	{ 0x96B6, 0x81B6 },
	{ 0x96B7, 0x81DC },
	{ 0x96B8, 0x8206 },
	{ 0x96B9, 0x8223 },
	{ 0x96BA, 0x8230 },
	{ 0x96BB, 0x8231 },
	{ 0x96BC, 0x823B },
	{ 0x96BD, 0x823E },
	{ 0x96BE, 0x8254 },
	{ 0x96BF, 0x8270 },
	{ 0x96C0, 0x8282 },
	{ 0x96C1, 0x8288 },
	{ 0x96C2, 0x8297 },
	{ 0x96C3, 0x82C7 },
	{ 0x96C4, 0x82C8 },
	{ 0x96C5, 0x82CB },
	{ 0x96C6, 0x82CC },
	{ 0x96C7, 0x82CD },
	{ 0x96C8, 0x82CE },
	{ 0x96C9, 0x82CF },
	{ 0x96CA, 0x830F },
	{ 0x96CB, 0x8311 },
	{ 0x96CC, 0x8313 },
	{ 0x96CD, 0x8314 },
	{ 0x96CE, 0x8315 },
	{ 0x96CF, 0x8359 },
	{ 0x96D0, 0x835A },
	{ 0x96D1, 0x835B },
	{ 0x96D2, 0x835C },
	{ 0x96D3, 0x835D },
	{ 0x96D4, 0x835E },
	{ 0x96D5, 0x835F },
	{ 0x96D6, 0x8360 },
	{ 0x96D7, 0x8361 },
	{ 0x96D8, 0x8364 },
	{ 0x96D9, 0x8365 },
	{ 0x96DA, 0x8366 },
	{ 0x96DB, 0x8367 },
	{ 0x96DC, 0x8368 },
	{ 0x96DD, 0x8369 },
	{ 0x96DE, 0x836A },
	{ 0x96DF, 0x836B },
	{ 0x96E0, 0x836C },
	{ 0x96E1, 0x836D },
	{ 0x96E2, 0x836E },
	{ 0x96E3, 0x836F },
	{ 0x96E4, 0x83B2 },
	{ 0x96E5, 0x83B3 },
	{ 0x96E6, 0x83B4 },
	{ 0x96E7, 0x83B6 },
	{ 0x96E8, 0x83B8 },
	{ 0x96E9, 0x83BA },
	{ 0x96EA, 0x83BC },
	{ 0x96EB, 0x841A },
	{ 0x96EC, 0x841C },
	{ 0x96ED, 0x841D },
	{ 0x96EE, 0x8424 },
	{ 0x96EF, 0x8425 },
	{ 0x96F0, 0x8426 },
	{ 0x96F1, 0x8427 },
	{ 0x96F2, 0x8428 },
	{ 0x96F3, 0x8487 },
	{ 0x96F4, 0x8489 },
	{ 0x96F5, 0x848C },
	{ 0x96F6, 0x84DD },
	{ 0x96F7, 0x84DF },
	{ 0x96F8, 0x84E0 },
	{ 0x96F9, 0x84E3 },
	{ 0x96FA, 0x84E5 },
	{ 0x96FB, 0x84E6 },
	{ 0x96FC, 0x8537 },
	{ 0x96FD, 0x8539 },
	{ 0x96FE, 0x853A },
	{ 0x9740, 0x853C },
	{ 0x9741, 0x8572 },
	{ 0x9742, 0x8574 },
	{ 0x9743, 0x85D3 },
	{ 0x9744, 0x8614 },
	{ 0x9745, 0x864F },
	{ 0x9746, 0x867F },
	{ 0x9747, 0x8680 },
	{ 0x9748, 0x8681 },
	{ 0x9749, 0x8682 },
	{ 0x974A, 0x8683 },
	{ 0x974B, 0x86AC },
	{ 0x974C, 0x86F0 },
	{ 0x974D, 0x86F1 },
	{ 0x974E, 0x86F2 },
	{ 0x974F, 0x86F3 },
	{ 0x9750, 0x86F4 },
	{ 0x9751, 0x8717 },
	{ 0x9752, 0x8748 },
	{ 0x9753, 0x877E },
	{ 0x9754, 0x8780 },
	{ 0x9755, 0x87A8 },
	{ 0x9756, 0x87CF },
	{ 0x9757, 0x8854 },
	{ 0x9758, 0x8865 },
	{ 0x9759, 0x886C },
	{ 0x975A, 0x8885 },
	{ 0x975B, 0x8886 },
	{ 0x975C, 0x88AD },
	{ 0x975D, 0x88AF },
	{ 0x975E, 0x88C6 },
	{ 0x975F, 0x88C7 },
	{ 0x9760, 0x88C8 },
	{ 0x9761, 0x88E2 },
	{ 0x9762, 0x88E3 },
	{ 0x9763, 0x88E4 },
	{ 0x9764, 0x88E5 },
	{ 0x9765, 0x8934 },
	{ 0x9766, 0x8947 },
	{ 0x9767, 0x8955 },
	{ 0x9768, 0x8980 },
	{ 0x9769, 0x89C1 },
	{ 0x976A, 0x89C2 },
	{ 0x976B, 0x89C3 },
	{ 0x976C, 0x89C4 },
	{ 0x976D, 0x89C5 },
	{ 0x976E, 0x89C6 },
	{ 0x976F, 0x89C7 },
	{ 0x9770, 0x89C8 },
	{ 0x9771, 0x89C9 },
	{ 0x9772, 0x89CA },
	{ 0x9773, 0x89CB },
	{ 0x9774, 0x89CC },
	{ 0x9775, 0x89CD },
	{ 0x9776, 0x89CE },
	{ 0x9777, 0x89CF },
	{ 0x9778, 0x89D0 },
	{ 0x9779, 0x89D1 },
	{ 0x977A, 0x89DE },
	{ 0x977B, 0x89EF },
	{ 0x977C, 0x8A01 },
	{ 0x977D, 0x8A1A },
	{ 0x977E, 0x8A5F },
	{ 0x977F, 0xFFFD },
	{ 0x9780, 0x604A },
	{ 0x9781, 0x6061 },
	{ 0x9782, 0x6218 },
	{ 0x9783, 0x631F },
	{ 0x9784, 0x6317 },
	{ 0x9785, 0x62EA },
	{ 0x9786, 0x6321 },
	{ 0x9787, 0x6304 },
	{ 0x9788, 0x6305 },
	{ 0x9789, 0x6531 },
	{ 0x978A, 0x6544 },
	{ 0x978B, 0x6540 },
	{ 0x978C, 0x6542 },
	{ 0x978D, 0x65BE },
	{ 0x978E, 0x6629 },
	{ 0x978F, 0x661B },
	{ 0x9790, 0x6623 },
	{ 0x9791, 0x662C },
	{ 0x9792, 0x661A },
	{ 0x9793, 0x6630 },
	{ 0x9794, 0x663B },
	{ 0x9795, 0x661E },
	{ 0x9796, 0x6637 },
	{ 0x9797, 0x6638 },
	{ 0x9798, 0x670E },
	{ 0x9799, 0x67E8 },
	{ 0x979A, 0x67D6 },
	{ 0x979B, 0x67C7 },
	{ 0x979C, 0x67BC },
	{ 0x979D, 0x6852 },
	{ 0x979E, 0x67BF },
	{ 0x979F, 0x67D5 },
	{ 0x97A0, 0x67FE },
	{ 0x97A1, 0x8A8A },
	{ 0x97A2, 0x8BA0 },
	{ 0x97A3, 0x8BA1 },
	{ 0x97A4, 0x8BA2 },
	{ 0x97A5, 0x8BA3 },
	{ 0x97A6, 0x8BA4 },
	{ 0x97A7, 0x8BA5 },
	{ 0x97A8, 0x8BA6 },
	{ 0x97A9, 0x8BA7 },
	{ 0x97AA, 0x8BA8 },
	{ 0x97AB, 0x8BA9 },
	{ 0x97AC, 0x8BAA },
	{ 0x97AD, 0x8BAB },
	{ 0x97AE, 0x8BAC },
	{ 0x97AF, 0x8BAD },
	{ 0x97B0, 0x8BAE },
	{ 0x97B1, 0x8BAF },
	{ 0x97B2, 0x8BB0 },
	{ 0x97B3, 0x8BB1 },
	{ 0x97B4, 0x8BB2 },
	{ 0x97B5, 0x8BB3 },
	{ 0x97B6, 0x8BB4 },
	{ 0x97B7, 0x8BB5 },
	{ 0x97B8, 0x8BB6 },
	{ 0x97B9, 0x8BB7 },
	{ 0x97BA, 0x8BB8 },
	{ 0x97BB, 0x8BB9 },
	{ 0x97BC, 0x8BBA },
	{ 0x97BD, 0x8BBB },
	{ 0x97BE, 0x8BBC },
	{ 0x97BF, 0x8BBD },
	{ 0x97C0, 0x8BBE },
	{ 0x97C1, 0x8BBF },
	{ 0x97C2, 0x8BC0 },
	{ 0x97C3, 0x8BC1 },
	{ 0x97C4, 0x8BC2 },
	{ 0x97C5, 0x8BC3 },
	{ 0x97C6, 0x8BC4 },
	{ 0x97C7, 0x8BC5 },
	{ 0x97C8, 0x8BC6 },
	{ 0x97C9, 0x8BC7 },
	{ 0x97CA, 0x8BC8 },
	{ 0x97CB, 0x8BC9 },
	{ 0x97CC, 0x8BCA },
	{ 0x97CD, 0x8BCB },
	{ 0x97CE, 0x8BCC },
	{ 0x97CF, 0x8BCD },
	{ 0x97D0, 0x8BCE },
	{ 0x97D1, 0x8BCF },
	{ 0x97D2, 0x8BD0 },
	{ 0x97D3, 0x8BD1 },
	{ 0x97D4, 0x8BD2 },
	{ 0x97D5, 0x8BD3 },
	{ 0x97D6, 0x8BD4 },
	{ 0x97D7, 0x8BD5 },
	{ 0x97D8, 0x8BD6 },
	{ 0x97D9, 0x8BD7 },
	{ 0x97DA, 0x8BD8 },
	{ 0x97DB, 0x8BD9 },
	{ 0x97DC, 0x8BDA },
	{ 0x97DD, 0x8BDB },
	{ 0x97DE, 0x8BDC },
	{ 0x97DF, 0x8BDD },
	{ 0x97E0, 0x8BDE },
	{ 0x97E1, 0x8BDF },
	{ 0x97E2, 0x8BE0 },
	{ 0x97E3, 0x8BE1 },
	{ 0x97E4, 0x8BE2 },
	{ 0x97E5, 0x8BE3 },
	{ 0x97E6, 0x8BE4 },
	{ 0x97E7, 0x8BE5 },
	{ 0x97E8, 0x8BE6 },
	{ 0x97E9, 0x8BE7 },
	{ 0x97EA, 0x8BE8 },
	{ 0x97EB, 0x8BE9 },
	{ 0x97EC, 0x8BEA },
	{ 0x97ED, 0x8BEB },
	{ 0x97EE, 0x8BEC },
	{ 0x97EF, 0x8BED },
	{ 0x97F0, 0x8BEE },
	{ 0x97F1, 0x8BEF },
	{ 0x97F2, 0x8BF0 },
	{ 0x97F3, 0x8BF1 },
	{ 0x97F4, 0x8BF2 },
	{ 0x97F5, 0x8BF3 },
	{ 0x97F6, 0x8BF4 },
	{ 0x97F7, 0x8BF5 },
	{ 0x97F8, 0x8BF6 },
	{ 0x97F9, 0x8BF7 },
	{ 0x97FA, 0x8BF8 },
	{ 0x97FB, 0x8BF9 },
	{ 0x97FC, 0x8BFA },
	{ 0x97FD, 0x8BFB },
	{ 0x97FE, 0x8BFC },
	{ 0x9840, 0x8BFD },
	{ 0x9841, 0x8BFE },
	{ 0x9842, 0x8BFF },
	{ 0x9843, 0x8C00 },
	{ 0x9844, 0x8C01 },
	{ 0x9845, 0x8C02 },
	{ 0x9846, 0x8C03 },
	{ 0x9847, 0x8C04 },
	{ 0x9848, 0x8C05 },
	{ 0x9849, 0x8C06 },
	{ 0x984A, 0x8C07 },
	{ 0x984B, 0x8C08 },
	{ 0x984C, 0x8C09 },
	{ 0x984D, 0x8C0A },
	{ 0x984E, 0x8C0B },
	{ 0x984F, 0x8C0C },
	{ 0x9850, 0x8C0D },
	{ 0x9851, 0x8C0E },
	{ 0x9852, 0x8C0F },
	{ 0x9853, 0x8C10 },
	{ 0x9854, 0x8C11 },
	{ 0x9855, 0x8C12 },
	{ 0x9856, 0x8C13 },
	{ 0x9857, 0x8C14 },
	{ 0x9858, 0x8C15 },
	{ 0x9859, 0x8C16 },
	{ 0x985A, 0x8C17 },
	{ 0x985B, 0x8C18 },
	{ 0x985C, 0x8C19 },
	{ 0x985D, 0x8C1A },
	{ 0x985E, 0x8C1B },
	{ 0x985F, 0x8C1C },
	{ 0x9860, 0x8C1D },
	{ 0x9861, 0x8C1E },
	{ 0x9862, 0x8C1F },
	{ 0x9863, 0x8C20 },
	{ 0x9864, 0x8C21 },
	{ 0x9865, 0x8C22 },
	{ 0x9866, 0x8C23 },
	{ 0x9867, 0x8C24 },
	{ 0x9868, 0x8C25 },
	{ 0x9869, 0x8C26 },
	{ 0x986A, 0x8C27 },
	{ 0x986B, 0x8C28 },
	{ 0x986C, 0x8C29 },
	{ 0x986D, 0x8C2A },
	{ 0x986E, 0x8C2B },
	{ 0x986F, 0x8C2C },
	{ 0x9870, 0x8C2D },
	{ 0x9871, 0x8C2E },
	{ 0x9872, 0x8C2F },
	{ 0x9873, 0x8C30 },
	{ 0x9874, 0x8C31 },
	{ 0x9875, 0x8C32 },
	{ 0x9876, 0x8C33 },
	{ 0x9877, 0x8C34 },
	{ 0x9878, 0x8C35 },
	{ 0x9879, 0x8C36 },
	{ 0x987A, 0x8C6E },
	{ 0x987B, 0x8D1D },
	{ 0x987C, 0x8D1E },
	{ 0x987D, 0x8D1F },
	{ 0x987E, 0x8D20 },
	{ 0x987F, 0xFFFD },
	{ 0x9880, 0x8363 },
	{ 0x9881, 0x67FB },
	{ 0x9882, 0x67B1 },
	{ 0x9883, 0x6801 },
	{ 0x9884, 0x6805 },
	{ 0x9885, 0x6800 },
	{ 0x9886, 0x67D7 },
	{ 0x9887, 0x6B2A },
	{ 0x9888, 0x6B6B },
	{ 0x9889, 0x6BE1 },
	{ 0x988A, 0x6D23 },
	{ 0x988B, 0x6CFF },
	{ 0x988C, 0x6D14 },
	{ 0x988D, 0x6D05 },
	{ 0x988E, 0x6D13 },
	{ 0x988F, 0x6D06 },
	{ 0x9890, 0x6D21 },
	{ 0x9891, 0x6D15 },
	{ 0x9892, 0x6CAF },
	{ 0x9893, 0x6CF4 },
	{ 0x9894, 0x6D02 },
	{ 0x9895, 0x6D45 },
	{ 0x9896, 0x6D26 },
	{ 0x9897, 0x6D44 },
	{ 0x9898, 0x6D24 },
	{ 0x9899, 0x70A5 },
	{ 0x989A, 0x70A3 },
	{ 0x989B, 0x70A2 },
	{ 0x989C, 0x70BB },
	{ 0x989D, 0x70A0 },
	{ 0x989E, 0x70AA },
	{ 0x989F, 0x70A8 },
	{ 0x98A0, 0x70B6 },
	{ 0x98A1, 0x8D21 },
	{ 0x98A2, 0x8D22 },
	{ 0x98A3, 0x8D23 },
	{ 0x98A4, 0x8D24 },
	{ 0x98A5, 0x8D25 },
	{ 0x98A6, 0x8D26 },
	{ 0x98A7, 0x8D27 },
	{ 0x98A8, 0x8D28 },
	{ 0x98A9, 0x8D29 },
	{ 0x98AA, 0x8D2A },
	{ 0x98AB, 0x8D2B },
	{ 0x98AC, 0x8D2C },
	{ 0x98AD, 0x8D2D },
	{ 0x98AE, 0x8D2E },
	{ 0x98AF, 0x8D2F },
	{ 0x98B0, 0x8D30 },
	{ 0x98B1, 0x8D31 },
	{ 0x98B2, 0x8D32 },
	{ 0x98B3, 0x8D33 },
	{ 0x98B4, 0x8D34 },
	{ 0x98B5, 0x8D35 },
	{ 0x98B6, 0x8D36 },
	{ 0x98B7, 0x8D37 },
	{ 0x98B8, 0x8D38 },
	{ 0x98B9, 0x8D39 },
	{ 0x98BA, 0x8D3A },
	{ 0x98BB, 0x8D3B },
	{ 0x98BC, 0x8D3C },
	{ 0x98BD, 0x8D3D },
	{ 0x98BE, 0x8D3E },
	{ 0x98BF, 0x8D3F },
	{ 0x98C0, 0x8D40 },
	{ 0x98C1, 0x8D41 },
	{ 0x98C2, 0x8D42 },
	{ 0x98C3, 0x8D43 },
	{ 0x98C4, 0x8D44 },
	{ 0x98C5, 0x8D45 },
	{ 0x98C6, 0x8D46 },
	{ 0x98C7, 0x8D47 },
	{ 0x98C8, 0x8D48 },
	{ 0x98C9, 0x8D49 },
	{ 0x98CA, 0x8D4A },
	{ 0x98CB, 0x8D4B },
	{ 0x98CC, 0x8D4C },
	{ 0x98CD, 0x8D4D },
	{ 0x98CE, 0x8D4E },
	{ 0x98CF, 0x8D4F },
	{ 0x98D0, 0x8D50 },
	{ 0x98D1, 0x8D51 },
	{ 0x98D2, 0x8D52 },
	{ 0x98D3, 0x8D53 },
	{ 0x98D4, 0x8D54 },
	{ 0x98D5, 0x8D55 },
	{ 0x98D6, 0x8D56 },
	{ 0x98D7, 0x8D57 },
	{ 0x98D8, 0x8D58 },
	{ 0x98D9, 0x8D59 },
	{ 0x98DA, 0x8D5A },
	{ 0x98DB, 0x8D5B },
	{ 0x98DC, 0x8D5C },
	{ 0x98DD, 0x8D5D },
	{ 0x98DE, 0x8D5E },
	{ 0x98DF, 0x8D5F },
	{ 0x98E0, 0x8D60 },
	{ 0x98E1, 0x8D61 },
	{ 0x98E2, 0x8D62 },
	{ 0x98E3, 0x8D63 },
	{ 0x98E4, 0x8D6A },
	{ 0x98E5, 0x8D75 },
	{ 0x98E6, 0x8DB1 },
	{ 0x98E7, 0x8DB8 },
	{ 0x98E8, 0x8DC4 },
	{ 0x98E9, 0x8DDE },
	{ 0x98EA, 0x8DF6 },
	{ 0x98EB, 0x8DF7 },
	{ 0x98EC, 0x8DF8 },
	{ 0x98ED, 0x8DF9 },
	{ 0x98EE, 0x8DFB },
	{ 0x98EF, 0x8E0C },
	{ 0x98F0, 0x8E0E },
	{ 0x98F1, 0x8E2C },
	{ 0x98F2, 0x8E2D },
	{ 0x98F3, 0x8E2F },
	{ 0x98F4, 0x8E52 },
	{ 0x98F5, 0x8E7E },
	{ 0x98F6, 0x8E7F },
	{ 0x98F7, 0x8E80 },
	{ 0x98F8, 0x8E8F },
	{ 0x98F9, 0x8E9C },
	{ 0x98FA, 0x8ECE },
	{ 0x98FB, 0x8F66 },
	{ 0x98FC, 0x8F67 },
	{ 0x98FD, 0x8F68 },
	{ 0x98FE, 0x8F69 },
	{ 0x9940, 0x8F6A },
	{ 0x9941, 0x8F6B },
	{ 0x9942, 0x8F6C },
	{ 0x9943, 0x8F6D },
	{ 0x9944, 0x8F6E },
	{ 0x9945, 0x8F6F },
	{ 0x9946, 0x8F70 },
	{ 0x9947, 0x8F71 },
	{ 0x9948, 0x8F72 },
	{ 0x9949, 0x8F73 },
	{ 0x994A, 0x8F74 },
	{ 0x994B, 0x8F75 },
	{ 0x994C, 0x8F76 },
	{ 0x994D, 0x8F77 },
	{ 0x994E, 0x8F78 },
	{ 0x994F, 0x8F79 },
	{ 0x9950, 0x8F7A },
	{ 0x9951, 0x8F7B },
	{ 0x9952, 0x8F7C },
	{ 0x9953, 0x8F7D },
	{ 0x9954, 0x8F7E },
	{ 0x9955, 0x8F7F },
	{ 0x9956, 0x8F80 },
	{ 0x9957, 0x8F81 },
	{ 0x9958, 0x8F82 },
	{ 0x9959, 0x8F83 },
	{ 0x995A, 0x8F84 },
	{ 0x995B, 0x8F85 },
	{ 0x995C, 0x8F86 },
	{ 0x995D, 0x8F87 },
	{ 0x995E, 0x8F88 },
	{ 0x995F, 0x8F89 },
	{ 0x9960, 0x8F8A },
	{ 0x9961, 0x8F8B },
	{ 0x9962, 0x8F8C },
	{ 0x9963, 0x8F8D },
	{ 0x9964, 0x8F8E },
	{ 0x9965, 0x8F8F },
	{ 0x9966, 0x8F90 },
	{ 0x9967, 0x8F91 },
	{ 0x9968, 0x8F92 },
	{ 0x9969, 0x8F93 },
	{ 0x996A, 0x8F94 },
	{ 0x996B, 0x8F95 },
	{ 0x996C, 0x8F96 },
	{ 0x996D, 0x8F97 },
	{ 0x996E, 0x8F98 },
	{ 0x996F, 0x8F99 },
	{ 0x9970, 0x8F9A },
	{ 0x9971, 0x8FA9 },
	{ 0x9972, 0x8FAB },
	{ 0x9973, 0x8FBD },
	{ 0x9974, 0x8FDB },
	{ 0x9975, 0x8FDD },
	{ 0x9976, 0x8FDE },
	{ 0x9977, 0x8FF3 },
	{ 0x9978, 0x900A },
	{ 0x9979, 0x9026 },
	{ 0x997A, 0x9057 },
	{ 0x997B, 0x909D },
	{ 0x997C, 0x90AC },
	{ 0x997D, 0x90BA },
	{ 0x997E, 0x90BB },
	{ 0x997F, 0xFFFD },
	{ 0x9980, 0x70B2 },
	{ 0x9981, 0x70A7 },
	{ 0x9982, 0x70B9 },
	{ 0x9983, 0x722E },
	{ 0x9984, 0x723C },
	{ 0x9985, 0x726D },
	{ 0x9986, 0x72E7 },
	{ 0x9987, 0x72ED },
	{ 0x9988, 0x72EC },
	{ 0x9989, 0x72E5 },
	{ 0x998A, 0x72E2 },
	{ 0x998B, 0x73C4 },
	{ 0x998C, 0x73BD },
	{ 0x998D, 0x73CF },
	{ 0x998E, 0x73C9 },
	{ 0x998F, 0x73C1 },
	{ 0x9990, 0x73D0 },
	{ 0x9991, 0x73CE },
	{ 0x9992, 0x74ED },
	{ 0x9993, 0x74EB },
	{ 0x9994, 0x74EF },
	{ 0x9995, 0x7549 },
	{ 0x9996, 0x7550 },
	{ 0x9997, 0x7546 },
	{ 0x9998, 0x754A },
	{ 0x9999, 0x754D },
	{ 0x999A, 0x75A6 },
	{ 0x999B, 0x75A8 },
	{ 0x999C, 0x76C7 },
	{ 0x999D, 0x76FF },
	{ 0x999E, 0x76FD },
	{ 0x999F, 0x77E6 },
	{ 0x99A0, 0x780A },
	{ 0x99A1, 0x90CF },
	{ 0x99A2, 0x90D0 },
	{ 0x99A3, 0x90D1 },
	{ 0x99A4, 0x90D3 },
	{ 0x99A5, 0x90E6 },
	{ 0x99A6, 0x90E7 },
	{ 0x99A7, 0x90F8 },
	{ 0x99A8, 0x9142 },
	{ 0x99A9, 0x915D },
	{ 0x99AA, 0x915E },
	{ 0x99AB, 0x9166 },
	{ 0x99AC, 0x9171 },
	{ 0x99AD, 0x917D },
	{ 0x99AE, 0x917E },
	{ 0x99AF, 0x917F },
	{ 0x99B0, 0x91CA },
	{ 0x99B1, 0x91D2 },
	{ 0x99B2, 0x91FA },
	{ 0x99B3, 0x922A },
	{ 0x99B4, 0x9274 },
	{ 0x99B5, 0x933E },
	{ 0x99B6, 0x9341 },
	{ 0x99B7, 0x93F0 },
	{ 0x99B8, 0x9426 },
	{ 0x99B9, 0x9485 },
	{ 0x99BA, 0x9486 },
	{ 0x99BB, 0x9487 },
	{ 0x99BC, 0x9488 },
	{ 0x99BD, 0x9489 },
	{ 0x99BE, 0x948A },
	{ 0x99BF, 0x948B },
	{ 0x99C0, 0x948C },
	{ 0x99C1, 0x948D },
	{ 0x99C2, 0x948E },
	{ 0x99C3, 0x948F },
	{ 0x99C4, 0x9490 },
	{ 0x99C5, 0x9491 },
	{ 0x99C6, 0x9492 },
	{ 0x99C7, 0x9493 },
	{ 0x99C8, 0x9494 },
	{ 0x99C9, 0x9495 },
	{ 0x99CA, 0x9496 },
	{ 0x99CB, 0x9497 },
	{ 0x99CC, 0x9498 },
	{ 0x99CD, 0x9499 },
	{ 0x99CE, 0x949A },
	{ 0x99CF, 0x949B },
	{ 0x99D0, 0x949C },
	{ 0x99D1, 0x949D },
	{ 0x99D2, 0x949E },
	{ 0x99D3, 0x949F },
	{ 0x99D4, 0x94A0 },
	{ 0x99D5, 0x94A1 },
	{ 0x99D6, 0x94A2 },
	{ 0x99D7, 0x94A3 },
	{ 0x99D8, 0x94A4 },
	{ 0x99D9, 0x94A5 },
	{ 0x99DA, 0x94A6 },
	{ 0x99DB, 0x94A7 },
	{ 0x99DC, 0x94A8 },
	{ 0x99DD, 0x94A9 },
	{ 0x99DE, 0x94AA },
	{ 0x99DF, 0x94AB },
	{ 0x99E0, 0x94AC },
	{ 0x99E1, 0x94AD },
	{ 0x99E2, 0x94AE },
	{ 0x99E3, 0x94AF },
	{ 0x99E4, 0x94B0 },
	{ 0x99E5, 0x94B1 },
	{ 0x99E6, 0x94B2 },
	{ 0x99E7, 0x94B3 },
	{ 0x99E8, 0x94B4 },
	{ 0x99E9, 0x94B5 },
	{ 0x99EA, 0x94B6 },
	{ 0x99EB, 0x94B7 },
	{ 0x99EC, 0x94B8 },
	{ 0x99ED, 0x94B9 },
	{ 0x99EE, 0x94BA },
	{ 0x99EF, 0x94BB },
	{ 0x99F0, 0x94BC },
	{ 0x99F1, 0x94BD },
	{ 0x99F2, 0x94BE },
	{ 0x99F3, 0x94BF },
	{ 0x99F4, 0x94C0 },
	{ 0x99F5, 0x94C1 },
	{ 0x99F6, 0x94C2 },
	{ 0x99F7, 0x94C3 },
	{ 0x99F8, 0x94C4 },
	{ 0x99F9, 0x94C5 },
	{ 0x99FA, 0x94C6 },
	{ 0x99FB, 0x94C7 },
	{ 0x99FC, 0x94C8 },
	{ 0x99FD, 0x94C9 },
	{ 0x99FE, 0x94CA },
	{ 0x9A40, 0x94CB },
	{ 0x9A41, 0x94CC },
	{ 0x9A42, 0x94CD },
	{ 0x9A43, 0x94CE },
	{ 0x9A44, 0x94CF },
	{ 0x9A45, 0x94D0 },
	{ 0x9A46, 0x94D1 },
	{ 0x9A47, 0x94D2 },
	{ 0x9A48, 0x94D3 },
	{ 0x9A49, 0x94D4 },
	{ 0x9A4A, 0x94D5 },
	{ 0x9A4B, 0x94D6 },
	{ 0x9A4C, 0x94D7 },
	{ 0x9A4D, 0x94D8 },
	{ 0x9A4E, 0x94D9 },
	{ 0x9A4F, 0x94DA },
	{ 0x9A50, 0x94DB },
	{ 0x9A51, 0x94DC },
	{ 0x9A52, 0x94DD },
	{ 0x9A53, 0x94DE },
	{ 0x9A54, 0x94DF },
	{ 0x9A55, 0x94E0 },
	{ 0x9A56, 0x94E1 },
	{ 0x9A57, 0x94E2 },
	{ 0x9A58, 0x94E3 },
	{ 0x9A59, 0x94E4 },
	{ 0x9A5A, 0x94E5 },
	{ 0x9A5B, 0x94E6 },
	{ 0x9A5C, 0x94E7 },
	{ 0x9A5D, 0x94E8 },
	{ 0x9A5E, 0x94E9 },
	{ 0x9A5F, 0x94EA },
	{ 0x9A60, 0x94EB },
	{ 0x9A61, 0x94EC },
	{ 0x9A62, 0x94ED },
	{ 0x9A63, 0x94EE },
	{ 0x9A64, 0x94EF },
	{ 0x9A65, 0x94F0 },
	{ 0x9A66, 0x94F1 },
	{ 0x9A67, 0x94F2 },
	{ 0x9A68, 0x94F3 },
	{ 0x9A69, 0x94F4 },
	{ 0x9A6A, 0x94F5 },
	{ 0x9A6B, 0x94F6 },
	{ 0x9A6C, 0x94F7 },
	{ 0x9A6D, 0x94F8 },
	{ 0x9A6E, 0x94F9 },
	{ 0x9A6F, 0x94FA },
	{ 0x9A70, 0x94FB },
	{ 0x9A71, 0x94FC },
	{ 0x9A72, 0x94FD },
	{ 0x9A73, 0x94FE },
	{ 0x9A74, 0x94FF },
	{ 0x9A75, 0x9500 },
	{ 0x9A76, 0x9501 },
	{ 0x9A77, 0x9502 },
	{ 0x9A78, 0x9503 },
	{ 0x9A79, 0x9504 },
	{ 0x9A7A, 0x9505 },
	{ 0x9A7B, 0x9506 },
	{ 0x9A7C, 0x9507 },
	{ 0x9A7D, 0x9508 },
	{ 0x9A7E, 0x9509 },
	{ 0x9A7F, 0xFFFD },
	{ 0x9A80, 0x7804 },
	{ 0x9A81, 0x780B },
	{ 0x9A82, 0x7807 },
	{ 0x9A83, 0x7815 },
	{ 0x9A84, 0x7808 },
	{ 0x9A85, 0x79D3 },
	{ 0x9A86, 0x79D4 },
	{ 0x9A87, 0x79D0 },
	{ 0x9A88, 0x79D7 },
	{ 0x9A89, 0x7A7C },
	{ 0x9A8A, 0x7A7D },
	{ 0x9A8B, 0x7A83 },
	{ 0x9A8C, 0x7A82 },
	{ 0x9A8D, 0x7AD4 },
	{ 0x9A8E, 0x7AD5 },
	{ 0x9A8F, 0x7AD3 },
	{ 0x9A90, 0x7AD0 },
	{ 0x9A91, 0x7AD2 },
	{ 0x9A92, 0x7AFE },
	{ 0x9A93, 0x7AFC },
	{ 0x9A94, 0x7C77 },
	{ 0x9A95, 0x7C7C },
	{ 0x9A96, 0x7C7B },
	{ 0x9A97, 0x7F8F },
	{ 0x9A98, 0x80D3 },
	{ 0x9A99, 0x80CB },
	{ 0x9A9A, 0x80D2 },
	{ 0x9A9B, 0x8109 },
	{ 0x9A9C, 0x80E2 },
	{ 0x9A9D, 0x80DF },
	{ 0x9A9E, 0x80C6 },
	{ 0x9A9F, 0x8224 },
	{ 0x9AA0, 0x82F7 },
	{ 0x9AA1, 0x950A },
	{ 0x9AA2, 0x950B },
	{ 0x9AA3, 0x950C },
	{ 0x9AA4, 0x950D },
	{ 0x9AA5, 0x950E },
	{ 0x9AA6, 0x950F },
	{ 0x9AA7, 0x9510 },
	{ 0x9AA8, 0x9511 },
	{ 0x9AA9, 0x9512 },
	{ 0x9AAA, 0x9513 },
	{ 0x9AAB, 0x9514 },
	{ 0x9AAC, 0x9515 },
	{ 0x9AAD, 0x9516 },
	{ 0x9AAE, 0x9517 },
	{ 0x9AAF, 0x9518 },
	{ 0x9AB0, 0x9519 },
	{ 0x9AB1, 0x951A },
	{ 0x9AB2, 0x951B },
	{ 0x9AB3, 0x951C },
	{ 0x9AB4, 0x951D },
	{ 0x9AB5, 0x951E },
	{ 0x9AB6, 0x951F },
	{ 0x9AB7, 0x9520 },
	{ 0x9AB8, 0x9521 },
	{ 0x9AB9, 0x9522 },
	{ 0x9ABA, 0x9523 },
	{ 0x9ABB, 0x9524 },
	{ 0x9ABC, 0x9525 },
	{ 0x9ABD, 0x9526 },
	{ 0x9ABE, 0x9527 },
	{ 0x9ABF, 0x9528 },
	{ 0x9AC0, 0x9529 },
	{ 0x9AC1, 0x952A },
	{ 0x9AC2, 0x952B },
	{ 0x9AC3, 0x952C },
	{ 0x9AC4, 0x952D },
	{ 0x9AC5, 0x952E },
	{ 0x9AC6, 0x952F },
	{ 0x9AC7, 0x9530 },
	{ 0x9AC8, 0x9531 },
	{ 0x9AC9, 0x9532 },
	{ 0x9ACA, 0x9533 },
	{ 0x9ACB, 0x9534 },
	{ 0x9ACC, 0x9535 },
	{ 0x9ACD, 0x9536 },
	{ 0x9ACE, 0x9537 },
	{ 0x9ACF, 0x9538 },
	{ 0x9AD0, 0x9539 },
	{ 0x9AD1, 0x953A },
	{ 0x9AD2, 0x953B },
	{ 0x9AD3, 0x953C },
	{ 0x9AD4, 0x953D },
	{ 0x9AD5, 0x953E },
	{ 0x9AD6, 0x953F },
	{ 0x9AD7, 0x9540 },
	{ 0x9AD8, 0x9541 },
	{ 0x9AD9, 0x9542 },
	{ 0x9ADA, 0x9543 },
	{ 0x9ADB, 0x9544 },
	{ 0x9ADC, 0x9545 },
	{ 0x9ADD, 0x9546 },
	{ 0x9ADE, 0x9547 },
	{ 0x9ADF, 0x9548 },
	{ 0x9AE0, 0x9549 },
	{ 0x9AE1, 0x954A },
	{ 0x9AE2, 0x954B },
	{ 0x9AE3, 0x954C },
	{ 0x9AE4, 0x954D },
	{ 0x9AE5, 0x954E },
	{ 0x9AE6, 0x954F },
	{ 0x9AE7, 0x9550 },
	{ 0x9AE8, 0x9551 },
	{ 0x9AE9, 0x9552 },
	{ 0x9AEA, 0x9553 },
	{ 0x9AEB, 0x9554 },
	{ 0x9AEC, 0x9555 },
	{ 0x9AED, 0x9556 },
	{ 0x9AEE, 0x9557 },
	{ 0x9AEF, 0x9558 },
	{ 0x9AF0, 0x9559 },
	{ 0x9AF1, 0x955A },
	{ 0x9AF2, 0x955B },
	{ 0x9AF3, 0x955C },
	{ 0x9AF4, 0x955D },
	{ 0x9AF5, 0x955E },
	{ 0x9AF6, 0x955F },
	{ 0x9AF7, 0x9560 },
	{ 0x9AF8, 0x9561 },
	{ 0x9AF9, 0x9562 },
	{ 0x9AFA, 0x9563 },
	{ 0x9AFB, 0x9564 },
	{ 0x9AFC, 0x9565 },
	{ 0x9AFD, 0x9566 },
	{ 0x9AFE, 0x9567 },
	{ 0x9B40, 0x9568 },
	{ 0x9B41, 0x9569 },
	{ 0x9B42, 0x956A },
	{ 0x9B43, 0x956B },
	{ 0x9B44, 0x956C },
	{ 0x9B45, 0x956D },
	{ 0x9B46, 0x956E },
	{ 0x9B47, 0x956F },
	{ 0x9B48, 0x9570 },
	{ 0x9B49, 0x9571 },
	{ 0x9B4A, 0x9572 },
	{ 0x9B4B, 0x9573 },
	{ 0x9B4C, 0x9574 },
	{ 0x9B4D, 0x9575 },
	{ 0x9B4E, 0x9576 },
	{ 0x9B4F, 0x957F },
	{ 0x9B50, 0x95E8 },
	{ 0x9B51, 0x95E9 },
	{ 0x9B52, 0x95EA },
	{ 0x9B53, 0x95EB },
	{ 0x9B54, 0x95EC },
	{ 0x9B55, 0x95ED },
	{ 0x9B56, 0x95EE },
	{ 0x9B57, 0x95EF },
	{ 0x9B58, 0x95F0 },
	{ 0x9B59, 0x95F1 },
	{ 0x9B5A, 0x95F2 },
	{ 0x9B5B, 0x95F3 },
	{ 0x9B5C, 0x95F4 },
	{ 0x9B5D, 0x95F5 },
	{ 0x9B5E, 0x95F6 },
	{ 0x9B5F, 0x95F7 },
	{ 0x9B60, 0x95F8 },
	{ 0x9B61, 0x95F9 },
	{ 0x9B62, 0x95FA },
	{ 0x9B63, 0x95FB },
	{ 0x9B64, 0x95FC },
	{ 0x9B65, 0x95FD },
	{ 0x9B66, 0x95FE },
	{ 0x9B67, 0x95FF },
	{ 0x9B68, 0x9600 },
	{ 0x9B69, 0x9601 },
	{ 0x9B6A, 0x9602 },
	{ 0x9B6B, 0x9603 },
	{ 0x9B6C, 0x9604 },
	{ 0x9B6D, 0x9605 },
	{ 0x9B6E, 0x9606 },
	{ 0x9B6F, 0x9607 },
	{ 0x9B70, 0x9608 },
	{ 0x9B71, 0x9609 },
	{ 0x9B72, 0x960A },
	{ 0x9B73, 0x960B },
	{ 0x9B74, 0x960C },
	{ 0x9B75, 0x960D },
	{ 0x9B76, 0x960E },
	{ 0x9B77, 0x960F },
	{ 0x9B78, 0x9610 },
	{ 0x9B79, 0x9611 },
	{ 0x9B7A, 0x9612 },
	{ 0x9B7B, 0x9613 },
	{ 0x9B7C, 0x9614 },
	{ 0x9B7D, 0x9615 },
	{ 0x9B7E, 0x9616 },
	{ 0x9B7F, 0xFFFD },
	{ 0x9B80, 0x82D8 },
	{ 0x9B81, 0x82DD },
	{ 0x9B82, 0x82F8 },
	{ 0x9B83, 0x82FC },
	{ 0x9B84, 0x82E9 },
	{ 0x9B85, 0x82EE },
	{ 0x9B86, 0x82D0 },
	{ 0x9B87, 0x830E },
	{ 0x9B88, 0x82E2 },
	{ 0x9B89, 0x830B },
	{ 0x9B8A, 0x82FD },
	{ 0x9B8B, 0x5179 },
	{ 0x9B8C, 0x8676 },
	{ 0x9B8D, 0x8678 },
	{ 0x9B8E, 0x8675 },
	{ 0x9B8F, 0x867D },
	{ 0x9B90, 0x8842 },
	{ 0x9B91, 0x8866 },
	{ 0x9B92, 0x898C },
	{ 0x9B93, 0x8A05 },
	{ 0x9B94, 0x8A06 },
	{ 0x9B95, 0x8C9F },
	{ 0x9B96, 0x8FF1 },
	{ 0x9B97, 0x8FE7 },
	{ 0x9B98, 0x8FE9 },
	{ 0x9B99, 0x8FEF },
	{ 0x9B9A, 0x90C2 },
	{ 0x9B9B, 0x90BC },
	{ 0x9B9C, 0x90C6 },
	{ 0x9B9D, 0x90C0 },
	{ 0x9B9E, 0x90CD },
	{ 0x9B9F, 0x90C9 },
	{ 0x9BA0, 0x90C4 },
	{ 0x9BA1, 0x9617 },
	{ 0x9BA2, 0x9618 },
	{ 0x9BA3, 0x9619 },
	{ 0x9BA4, 0x961A },
	{ 0x9BA5, 0x961B },
	{ 0x9BA6, 0x961F },
	{ 0x9BA7, 0x9635 },
	{ 0x9BA8, 0x9636 },
	{ 0x9BA9, 0x9645 },
	{ 0x9BAA, 0x9646 },
	{ 0x9BAB, 0x9647 },
	{ 0x9BAC, 0x9648 },
	{ 0x9BAD, 0x9649 },
	{ 0x9BAE, 0x9667 },
	{ 0x9BAF, 0x9668 },
	{ 0x9BB0, 0x9669 },
	{ 0x9BB1, 0x9690 },
	{ 0x9BB2, 0x96E0 },
	{ 0x9BB3, 0x96F3 },
	{ 0x9BB4, 0x96FE },
	{ 0x9BB5, 0x9701 },
	{ 0x9BB6, 0x972D },
	{ 0x9BB7, 0x9753 },
	{ 0x9BB8, 0x9754 },
	{ 0x9BB9, 0x9765 },
	{ 0x9BBA, 0x9791 },
	{ 0x9BBB, 0x9792 },
	{ 0x9BBC, 0x97AF },
	{ 0x9BBD, 0x97E6 },
	{ 0x9BBE, 0x97E7 },
	{ 0x9BBF, 0x97E8 },
	{ 0x9BC0, 0x97E9 },
	{ 0x9BC1, 0x97EA },
	{ 0x9BC2, 0x97EB },
	{ 0x9BC3, 0x97EC },
	{ 0x9BC4, 0x9875 },
	{ 0x9BC5, 0x9876 },
	{ 0x9BC6, 0x9877 },
	{ 0x9BC7, 0x9878 },
	{ 0x9BC8, 0x9879 },
	{ 0x9BC9, 0x987A },
	{ 0x9BCA, 0x987B },
	{ 0x9BCB, 0x987C },
	{ 0x9BCC, 0x987D },
	{ 0x9BCD, 0x987E },
	{ 0x9BCE, 0x987F },
	{ 0x9BCF, 0x9880 },
	{ 0x9BD0, 0x9881 },
	{ 0x9BD1, 0x9882 },
	{ 0x9BD2, 0x9883 },
	{ 0x9BD3, 0x9884 },
	{ 0x9BD4, 0x9885 },
	{ 0x9BD5, 0x9886 },
	{ 0x9BD6, 0x9887 },
	{ 0x9BD7, 0x9888 },
	{ 0x9BD8, 0x9889 },
	{ 0x9BD9, 0x988A },
	{ 0x9BDA, 0x988B },
	{ 0x9BDB, 0x988C },
	{ 0x9BDC, 0x988D },
	{ 0x9BDD, 0x988E },
	{ 0x9BDE, 0x988F },
	{ 0x9BDF, 0x9890 },
	{ 0x9BE0, 0x9891 },
	{ 0x9BE1, 0x9892 },
	{ 0x9BE2, 0x9893 },
	{ 0x9BE3, 0x9894 },
	{ 0x9BE4, 0x9895 },
	{ 0x9BE5, 0x9896 },
	{ 0x9BE6, 0x9897 },
	{ 0x9BE7, 0x9898 },
	{ 0x9BE8, 0x9899 },
	{ 0x9BE9, 0x989A },
	{ 0x9BEA, 0x989B },
	{ 0x9BEB, 0x989C },
	{ 0x9BEC, 0x989D },
	{ 0x9BED, 0x989E },
	{ 0x9BEE, 0x989F },
	{ 0x9BEF, 0x98A0 },
	{ 0x9BF0, 0x98A1 },
	{ 0x9BF1, 0x98A2 },
	{ 0x9BF2, 0x98A3 },
	{ 0x9BF3, 0x98A4 },
	{ 0x9BF4, 0x98A5 },
	{ 0x9BF5, 0x98A6 },
	{ 0x9BF6, 0x98A7 },
	{ 0x9BF7, 0x98CE },
	{ 0x9BF8, 0x98CF },
	{ 0x9BF9, 0x98D0 },
	{ 0x9BFA, 0x98D1 },
	{ 0x9BFB, 0x98D2 },
	{ 0x9BFC, 0x98D3 },
	{ 0x9BFD, 0x98D4 },
	{ 0x9BFE, 0x98D5 },
	{ 0x9C40, 0x98D6 },
	{ 0x9C41, 0x98D7 },
	{ 0x9C42, 0x98D8 },
	{ 0x9C43, 0x98D9 },
	{ 0x9C44, 0x98DA },
	{ 0x9C45, 0x98DE },
	{ 0x9C46, 0x98E0 },
	{ 0x9C47, 0x98E8 },
	{ 0x9C48, 0x990D },
	{ 0x9C49, 0x990F },
	{ 0x9C4A, 0x9962 },
	{ 0x9C4B, 0x9963 },
	{ 0x9C4C, 0x9964 },
	{ 0x9C4D, 0x9965 },
	{ 0x9C4E, 0x9966 },
	{ 0x9C4F, 0x9967 },
	{ 0x9C50, 0x9968 },
	{ 0x9C51, 0x9969 },
	{ 0x9C52, 0x996A },
	{ 0x9C53, 0x996B },
	{ 0x9C54, 0x996C },
	{ 0x9C55, 0x996D },
	{ 0x9C56, 0x996E },
	{ 0x9C57, 0x996F },
	{ 0x9C58, 0x9970 },
	{ 0x9C59, 0x9971 },
	{ 0x9C5A, 0x9972 },
	{ 0x9C5B, 0x9973 },
	{ 0x9C5C, 0x9974 },
	{ 0x9C5D, 0x9975 },
	{ 0x9C5E, 0x9976 },
	{ 0x9C5F, 0x9977 },
	{ 0x9C60, 0x9978 },
	{ 0x9C61, 0x9979 },
	{ 0x9C62, 0x997A },
	{ 0x9C63, 0x997B },
	{ 0x9C64, 0x997C },
	{ 0x9C65, 0x997D },
	{ 0x9C66, 0x997E },
	{ 0x9C67, 0x997F },
	{ 0x9C68, 0x9980 },
	{ 0x9C69, 0x9981 },
	{ 0x9C6A, 0x9982 },
	{ 0x9C6B, 0x9983 },
	{ 0x9C6C, 0x9984 },
	{ 0x9C6D, 0x9985 },
	{ 0x9C6E, 0x9986 },
	{ 0x9C6F, 0x9987 },
	{ 0x9C70, 0x9988 },
	{ 0x9C71, 0x9989 },
	{ 0x9C72, 0x998A },
	{ 0x9C73, 0x998B },
	{ 0x9C74, 0x998C },
	{ 0x9C75, 0x998D },
	{ 0x9C76, 0x998E },
	{ 0x9C77, 0x998F },
	{ 0x9C78, 0x9990 },
	{ 0x9C79, 0x9991 },
	{ 0x9C7A, 0x9992 },
	{ 0x9C7B, 0x9993 },
	{ 0x9C7C, 0x9994 },
	{ 0x9C7D, 0x9995 },
	{ 0x9C7E, 0x9A6C },
	{ 0x9C7F, 0xFFFD },
	{ 0x9C80, 0x9581 },
	{ 0x9C81, 0x9CEC },
	{ 0x9C82, 0x5032 },
	{ 0x9C83, 0x4FF9 },
	{ 0x9C84, 0x501D },
	{ 0x9C85, 0x4FFF },
	{ 0x9C86, 0x5004 },
	{ 0x9C87, 0x4FF0 },
	{ 0x9C88, 0x5003 },
	{ 0x9C89, 0x5002 },
	{ 0x9C8A, 0x4FFC },
	{ 0x9C8B, 0x4FF2 },
	{ 0x9C8C, 0x5024 },
	{ 0x9C8D, 0x5008 },
	{ 0x9C8E, 0x5036 },
	{ 0x9C8F, 0x502E },
	{ 0x9C90, 0x5010 },
	{ 0x9C91, 0x5038 },
	{ 0x9C92, 0x5039 },
	{ 0x9C93, 0x4FFD },
	{ 0x9C94, 0x5056 },
	{ 0x9C95, 0x4FFB },
	{ 0x9C96, 0x51A3 },
	{ 0x9C97, 0x51A6 },
	{ 0x9C98, 0x51A1 },
	{ 0x9C99, 0x51C7 },
	{ 0x9C9A, 0x51C9 },
	{ 0x9C9B, 0x5260 },
	{ 0x9C9C, 0x5264 },
	{ 0x9C9D, 0x5259 },
	{ 0x9C9E, 0x5265 },
	{ 0x9C9F, 0x5267 },
	{ 0x9CA0, 0x5257 },
	{ 0x9CA1, 0x9A6D },
	{ 0x9CA2, 0x9A6E },
	{ 0x9CA3, 0x9A6F },
	{ 0x9CA4, 0x9A70 },
	{ 0x9CA5, 0x9A71 },
	{ 0x9CA6, 0x9A72 },
	{ 0x9CA7, 0x9A73 },
	{ 0x9CA8, 0x9A74 },
	{ 0x9CA9, 0x9A75 },
	{ 0x9CAA, 0x9A76 },
	{ 0x9CAB, 0x9A77 },
	{ 0x9CAC, 0x9A78 },
	{ 0x9CAD, 0x9A79 },
	{ 0x9CAE, 0x9A7A },
	{ 0x9CAF, 0x9A7B },
	{ 0x9CB0, 0x9A7C },
	{ 0x9CB1, 0x9A7D },
	{ 0x9CB2, 0x9A7E },
	{ 0x9CB3, 0x9A7F },
	{ 0x9CB4, 0x9A80 },
	{ 0x9CB5, 0x9A81 },
	{ 0x9CB6, 0x9A82 },
	{ 0x9CB7, 0x9A83 },
	{ 0x9CB8, 0x9A84 },
	{ 0x9CB9, 0x9A85 },
	{ 0x9CBA, 0x9A86 },
	{ 0x9CBB, 0x9A87 },
	{ 0x9CBC, 0x9A88 },
	{ 0x9CBD, 0x9A89 },
	{ 0x9CBE, 0x9A8A },
	{ 0x9CBF, 0x9A8B },
	{ 0x9CC0, 0x9A8C },
	{ 0x9CC1, 0x9A8D },
	{ 0x9CC2, 0x9A8E },
	{ 0x9CC3, 0x9A8F },
	{ 0x9CC4, 0x9A90 },
	{ 0x9CC5, 0x9A91 },
	{ 0x9CC6, 0x9A92 },
	{ 0x9CC7, 0x9A93 },
	{ 0x9CC8, 0x9A94 },
	{ 0x9CC9, 0x9A95 },
	{ 0x9CCA, 0x9A96 },
	{ 0x9CCB, 0x9A97 },
	{ 0x9CCC, 0x9A98 },
	{ 0x9CCD, 0x9A99 },
	{ 0x9CCE, 0x9A9A },
	{ 0x9CCF, 0x9A9B },
	{ 0x9CD0, 0x9A9C },
	{ 0x9CD1, 0x9A9D },
	{ 0x9CD2, 0x9A9E },
	{ 0x9CD3, 0x9A9F },
	{ 0x9CD4, 0x9AA0 },
	{ 0x9CD5, 0x9AA1 },
	{ 0x9CD6, 0x9AA2 },
	{ 0x9CD7, 0x9AA3 },
	{ 0x9CD8, 0x9AA4 },
	{ 0x9CD9, 0x9AA5 },
	{ 0x9CDA, 0x9AA6 },
	{ 0x9CDB, 0x9AA7 },
	{ 0x9CDC, 0x9ACB },
	{ 0x9CDD, 0x9ACC },
	{ 0x9CDE, 0x9B13 },
	{ 0x9CDF, 0x9B47 },
	{ 0x9CE0, 0x9C7C },
	{ 0x9CE1, 0x9C7D },
	{ 0x9CE2, 0x9C7E },
	{ 0x9CE3, 0x9C7F },
	{ 0x9CE4, 0x9C80 },
	{ 0x9CE5, 0x9C81 },
	{ 0x9CE6, 0x9C82 },
	{ 0x9CE7, 0x9C83 },
	{ 0x9CE8, 0x9C84 },
	{ 0x9CE9, 0x9C85 },
	{ 0x9CEA, 0x9C86 },
	{ 0x9CEB, 0x9C87 },
	{ 0x9CEC, 0x9C88 },
	{ 0x9CED, 0x9C89 },
	{ 0x9CEE, 0x9C8A },
	{ 0x9CEF, 0x9C8B },
	{ 0x9CF0, 0x9C8C },
	{ 0x9CF1, 0x9C8D },
	{ 0x9CF2, 0x9C8E },
	{ 0x9CF3, 0x9C8F },
	{ 0x9CF4, 0x9C90 },
	{ 0x9CF5, 0x9C91 },
	{ 0x9CF6, 0x9C92 },
	{ 0x9CF7, 0x9C93 },
	{ 0x9CF8, 0x9C94 },
	{ 0x9CF9, 0x9C95 },
	{ 0x9CFA, 0x9C96 },
	{ 0x9CFB, 0x9C97 },
	{ 0x9CFC, 0x9C98 },
	{ 0x9CFD, 0x9C99 },
	{ 0x9CFE, 0x9C9A },
	{ 0x9D40, 0x9C9B },
	{ 0x9D41, 0x9C9C },
	{ 0x9D42, 0x9C9D },
	{ 0x9D43, 0x9C9E },
	{ 0x9D44, 0x9C9F },
	{ 0x9D45, 0x9CA0 },
	{ 0x9D46, 0x9CA1 },
	{ 0x9D47, 0x9CA2 },
	{ 0x9D48, 0x9CA3 },
	{ 0x9D49, 0x9CA4 },
	{ 0x9D4A, 0x9CA5 },
	{ 0x9D4B, 0x9CA6 },
	{ 0x9D4C, 0x9CA7 },
	{ 0x9D4D, 0x9CA8 },
	{ 0x9D4E, 0x9CA9 },
	{ 0x9D4F, 0x9CAA },
	{ 0x9D50, 0x9CAB },
	{ 0x9D51, 0x9CAC },
	{ 0x9D52, 0x9CAD },
	{ 0x9D53, 0x9CAE },
	{ 0x9D54, 0x9CAF },
	{ 0x9D55, 0x9CB0 },
	{ 0x9D56, 0x9CB1 },
	{ 0x9D57, 0x9CB2 },
	{ 0x9D58, 0x9CB3 },
	{ 0x9D59, 0x9CB4 },
	{ 0x9D5A, 0x9CB5 },
	{ 0x9D5B, 0x9CB6 },
	{ 0x9D5C, 0x9CB7 },
	{ 0x9D5D, 0x9CB8 },
	{ 0x9D5E, 0x9CB9 },
	{ 0x9D5F, 0x9CBA },
	{ 0x9D60, 0x9CBB },
	{ 0x9D61, 0x9CBC },
	{ 0x9D62, 0x9CBD },
	{ 0x9D63, 0x9CBE },
	{ 0x9D64, 0x9CBF },
	{ 0x9D65, 0x9CC0 },
	{ 0x9D66, 0x9CC1 },
	{ 0x9D67, 0x9CC2 },
	{ 0x9D68, 0x9CC3 },
	{ 0x9D69, 0x9CC4 },
	{ 0x9D6A, 0x9CC5 },
	{ 0x9D6B, 0x9CC6 },
	{ 0x9D6C, 0x9CC7 },
	{ 0x9D6D, 0x9CC8 },
	{ 0x9D6E, 0x9CC9 },
	{ 0x9D6F, 0x9CCA },
	{ 0x9D70, 0x9CCB },
	{ 0x9D71, 0x9CCC },
	{ 0x9D72, 0x9CCD },
	{ 0x9D73, 0x9CCE },
	{ 0x9D74, 0x9CCF },
	{ 0x9D75, 0x9CD0 },
	{ 0x9D76, 0x9CD1 },
	{ 0x9D77, 0x9CD2 },
	{ 0x9D78, 0x9CD3 },
	{ 0x9D79, 0x9CD4 },
	{ 0x9D7A, 0x9CD5 },
	{ 0x9D7B, 0x9CD6 },
	{ 0x9D7C, 0x9CD7 },
	{ 0x9D7D, 0x9CD8 },
	{ 0x9D7E, 0x9CD9 },
	{ 0x9D7F, 0xFFFD },
	{ 0x9D80, 0x5263 },
	{ 0x9D81, 0x5253 },
	{ 0x9D82, 0x52CF },
	{ 0x9D83, 0x52CE },
	{ 0x9D84, 0x52D0 },
	{ 0x9D85, 0x52D1 },
	{ 0x9D86, 0x52CC },
	{ 0x9D87, 0x550D },
	{ 0x9D88, 0x54F4 },
	{ 0x9D89, 0x5513 },
	{ 0x9D8A, 0x54EF },
	{ 0x9D8B, 0x54F5 },
	{ 0x9D8C, 0x54F9 },
	{ 0x9D8D, 0x5502 },
	{ 0x9D8E, 0x5500 },
	{ 0x9D8F, 0x5518 },
	{ 0x9D90, 0x54F0 },
	{ 0x9D91, 0x54F6 },
	{ 0x9D92, 0x5519 },
	{ 0x9D93, 0x5705 },
	{ 0x9D94, 0x57C9 },
	{ 0x9D95, 0x57B7 },
	{ 0x9D96, 0x57CD },
	{ 0x9D97, 0x57BE },
	{ 0x9D98, 0x57BB },
	{ 0x9D99, 0x57DB },
	{ 0x9D9A, 0x57C8 },
	{ 0x9D9B, 0x57C4 },
	{ 0x9D9C, 0x57C5 },
	{ 0x9D9D, 0x57D1 },
	{ 0x9D9E, 0x57CA },
	{ 0x9D9F, 0x57C0 },
	{ 0x9DA0, 0x5A21 },
	{ 0x9DA1, 0x9CDA },
	{ 0x9DA2, 0x9CDB },
	{ 0x9DA3, 0x9CDC },
	{ 0x9DA4, 0x9CDD },
	{ 0x9DA5, 0x9CDE },
	{ 0x9DA6, 0x9CDF },
	{ 0x9DA7, 0x9CE0 },
	{ 0x9DA8, 0x9CE1 },
	{ 0x9DA9, 0x9CE2 },
	{ 0x9DAA, 0x9CE3 },
	{ 0x9DAB, 0x9CE4 },
	{ 0x9DAC, 0x9E1F },
	{ 0x9DAD, 0x9E20 },
	{ 0x9DAE, 0x9E21 },
	{ 0x9DAF, 0x9E22 },
	{ 0x9DB0, 0x9E23 },
	{ 0x9DB1, 0x9E24 },
	{ 0x9DB2, 0x9E25 },
	{ 0x9DB3, 0x9E26 },
	{ 0x9DB4, 0x9E27 },
	{ 0x9DB5, 0x9E28 },
	{ 0x9DB6, 0x9E29 },
	{ 0x9DB7, 0x9E2A },
	{ 0x9DB8, 0x9E2B },
	{ 0x9DB9, 0x9E2C },
	{ 0x9DBA, 0x9E2D },
	{ 0x9DBB, 0x9E2E },
	{ 0x9DBC, 0x9E2F },
	{ 0x9DBD, 0x9E30 },
	{ 0x9DBE, 0x9E31 },
	{ 0x9DBF, 0x9E32 },
	{ 0x9DC0, 0x9E33 },
	{ 0x9DC1, 0x9E34 },
	{ 0x9DC2, 0x9E35 },
	{ 0x9DC3, 0x9E36 },
	{ 0x9DC4, 0x9E37 },
	{ 0x9DC5, 0x9E38 },
	{ 0x9DC6, 0x9E39 },
	{ 0x9DC7, 0x9E3A },
	{ 0x9DC8, 0x9E3B },
	{ 0x9DC9, 0x9E3C },
	{ 0x9DCA, 0x9E3D },
	{ 0x9DCB, 0x9E3E },
	{ 0x9DCC, 0x9E3F },
	{ 0x9DCD, 0x9E40 },
	{ 0x9DCE, 0x9E41 },
	{ 0x9DCF, 0x9E42 },
	{ 0x9DD0, 0x9E43 },
	{ 0x9DD1, 0x9E44 },
	{ 0x9DD2, 0x9E45 },
	{ 0x9DD3, 0x9E46 },
	{ 0x9DD4, 0x9E47 },
	{ 0x9DD5, 0x9E48 },
	{ 0x9DD6, 0x9E49 },
	{ 0x9DD7, 0x9E4A },
	{ 0x9DD8, 0x9E4B },
	{ 0x9DD9, 0x9E4C },
	{ 0x9DDA, 0x9E4D },
	{ 0x9DDB, 0x9E4E },
	{ 0x9DDC, 0x9E4F },
	{ 0x9DDD, 0x9E50 },
	{ 0x9DDE, 0x9E51 },
	{ 0x9DDF, 0x9E52 },
	{ 0x9DE0, 0x9E53 },
	{ 0x9DE1, 0x9E54 },
	{ 0x9DE2, 0x9E55 },
	{ 0x9DE3, 0x9E56 },
	{ 0x9DE4, 0x9E57 },
	{ 0x9DE5, 0x9E58 },
	{ 0x9DE6, 0x9E59 },
	{ 0x9DE7, 0x9E5A },
	{ 0x9DE8, 0x9E5B },
	{ 0x9DE9, 0x9E5C },
	{ 0x9DEA, 0x9E5D },
	{ 0x9DEB, 0x9E5E },
	{ 0x9DEC, 0x9E5F },
	{ 0x9DED, 0x9E60 },
	{ 0x9DEE, 0x9E61 },
	{ 0x9DEF, 0x9E62 },
	{ 0x9DF0, 0x9E63 },
	{ 0x9DF1, 0x9E64 },
	{ 0x9DF2, 0x9E65 },
	{ 0x9DF3, 0x9E66 },
	{ 0x9DF4, 0x9E67 },
	{ 0x9DF5, 0x9E68 },
	{ 0x9DF6, 0x9E69 },
	{ 0x9DF7, 0x9E6A },
	{ 0x9DF8, 0x9E6B },
	{ 0x9DF9, 0x9E6C },
	{ 0x9DFA, 0x9E6D },
	{ 0x9DFB, 0x9E6E },
	{ 0x9DFC, 0x9E6F },
	{ 0x9DFD, 0x9E70 },
	{ 0x9DFE, 0x9E71 },
	{ 0x9E40, 0x9E72 },
	{ 0x9E41, 0x9E73 },
	{ 0x9E42, 0x9E74 },
	{ 0x9E43, 0x9E7E },
	{ 0x9E44, 0x9EC9 },
	{ 0x9E45, 0x9EE1 },
	{ 0x9E46, 0x9EE9 },
	{ 0x9E47, 0x9EEA },
	{ 0x9E48, 0x9F0B },
	{ 0x9E49, 0x9F0C },
	{ 0x9E4A, 0x9F0D },
	{ 0x9E4B, 0x9F51 },
	{ 0x9E4C, 0x9F7F },
	{ 0x9E4D, 0x9F80 },
	{ 0x9E4E, 0x9F81 },
	{ 0x9E4F, 0x9F82 },
	{ 0x9E50, 0x9F83 },
	{ 0x9E51, 0x9F84 },
	{ 0x9E52, 0x9F85 },
	{ 0x9E53, 0x9F86 },
	{ 0x9E54, 0x9F87 },
	{ 0x9E55, 0x9F88 },
	{ 0x9E56, 0x9F89 },
	{ 0x9E57, 0x9F8A },
	{ 0x9E58, 0x9F8B },
	{ 0x9E59, 0x9F8C },
	{ 0x9E5A, 0x9F9A },
	{ 0x9E5B, 0x9F9B },
	{ 0x9E5C, 0x9F9F },
	{ 0x9E5D, 0x4E06 },
	{ 0x9E5E, 0x4E37 },
	{ 0x9E5F, 0x4E44 },
	{ 0x9E60, 0x4E4A },
	{ 0x9E61, 0x4E55 },
	{ 0x9E62, 0x4E5B },
	{ 0x9E63, 0x4E64 },
	{ 0x9E64, 0x4E65 },
	{ 0x9E65, 0x4E67 },
	{ 0x9E66, 0x4E6B },
	{ 0x9E67, 0x4E6C },
	{ 0x9E68, 0x4E6D },
	{ 0x9E69, 0x4E6E },
	{ 0x9E6A, 0x4E6F },
	{ 0x9E6B, 0x4E72 },
	{ 0x9E6C, 0x4E76 },
	{ 0x9E6D, 0x4E77 },
	{ 0x9E6E, 0x4E7A },
	{ 0x9E6F, 0x4E7B },
	{ 0x9E70, 0x4E7C },
	{ 0x9E71, 0x4E7D },
	{ 0x9E72, 0x4E8A },
	{ 0x9E73, 0x4E90 },
	{ 0x9E74, 0x4EBD },
	{ 0x9E75, 0x4ED2 },
	{ 0x9E76, 0x4EED },
	{ 0x9E77, 0x4FA4 },
	{ 0x9E78, 0x4FAD },
	{ 0x9E79, 0x503B },
	{ 0x9E7A, 0x50F2 },
	{ 0x9E7B, 0x516F },
	{ 0x9E7C, 0x517A },
	{ 0x9E7D, 0x51E6 },
	{ 0x9E7E, 0x51E7 },
	{ 0x9E7F, 0xFFFD },
	{ 0x9E80, 0x5A2A },
	{ 0x9E81, 0x5A1D },
	{ 0x9E82, 0x5A0B },
	{ 0x9E83, 0x5A22 },
	{ 0x9E84, 0x5A24 },
	{ 0x9E85, 0x5A14 },
	{ 0x9E86, 0x5A31 },
	{ 0x9E87, 0x5A2F },
	{ 0x9E88, 0x5A1A },
	{ 0x9E89, 0x5A12 },
	{ 0x9E8A, 0x5A26 },
	{ 0x9E8B, 0x5BBC },
	{ 0x9E8C, 0x5BBB },
	{ 0x9E8D, 0x5BB7 },
	{ 0x9E8E, 0x5C05 },
	{ 0x9E8F, 0x5C06 },
	{ 0x9E90, 0x5C52 },
	{ 0x9E91, 0x5C53 },
	{ 0x9E92, 0x5CFA },
	{ 0x9E93, 0x5CEB },
	{ 0x9E94, 0x5CF3 },
	{ 0x9E95, 0x5CF5 },
	{ 0x9E96, 0x5CE9 },
	{ 0x9E97, 0x5CEF },
	{ 0x9E98, 0x5E2A },
	{ 0x9E99, 0x5E30 },
	{ 0x9E9A, 0x5E2E },
	{ 0x9E9B, 0x5E2C },
	{ 0x9E9C, 0x5E2F },
	{ 0x9E9D, 0x5EAF },
	{ 0x9E9E, 0x5EA9 },
	{ 0x9E9F, 0x5EFD },
	{ 0x9EA0, 0x5F32 },
	{ 0x9EA1, 0x51E9 },
	{ 0x9EA2, 0x5271 },
	{ 0x9EA3, 0x5302 },
	{ 0x9EA4, 0x5381 },
	{ 0x9EA5, 0x5391 },
	{ 0x9EA6, 0x53BC },
	{ 0x9EA7, 0x5414 },
	{ 0x9EA8, 0x5455 },
	{ 0x9EA9, 0x54D8 },
	{ 0x9EAA, 0x54DB },
	{ 0x9EAB, 0x551C },
	{ 0x9EAC, 0x551F },
	{ 0x9EAD, 0x5569 },
	{ 0x9EAE, 0x55B8 },
	{ 0x9EAF, 0x55BD },
	{ 0x9EB0, 0x55ED },
	{ 0x9EB1, 0x561A },
	{ 0x9EB2, 0x565B },
	{ 0x9EB3, 0x56A2 },
	{ 0x9EB4, 0x56CE },
	{ 0x9EB5, 0x56D5 },
	{ 0x9EB6, 0x5726 },
	{ 0x9EB7, 0x5737 },
	{ 0x9EB8, 0x5738 },
	{ 0x9EB9, 0x5786 },
	{ 0x9EBA, 0x5789 },
	{ 0x9EBB, 0x57B0 },
	{ 0x9EBC, 0x57B3 },
	{ 0x9EBD, 0x57D6 },
	{ 0x9EBE, 0x5815 },
	{ 0x9EBF, 0x5841 },
	{ 0x9EC0, 0x586E },
	{ 0x9EC1, 0x5870 },
	{ 0x9EC2, 0x58B8 },
	{ 0x9EC3, 0x58B9 },
	{ 0x9EC4, 0x58CC },
	{ 0x9EC5, 0x58D7 },
	{ 0x9EC6, 0x58E5 },
	{ 0x9EC7, 0x58ED },
	{ 0x9EC8, 0x591E },
	{ 0x9EC9, 0x593B },
	{ 0x9ECA, 0x5B36 },
	{ 0x9ECB, 0x5B5E },
	{ 0x9ECC, 0x5B91 },
	{ 0x9ECD, 0x5BC9 },
	{ 0x9ECE, 0x5C02 },
	{ 0x9ECF, 0x5C26 },
	{ 0x9ED0, 0x5C2E },
	{ 0x9ED1, 0x5C32 },
	{ 0x9ED2, 0x5C76 },
	{ 0x9ED3, 0x5CBC },
	{ 0x9ED4, 0x5CBE },
	{ 0x9ED5, 0x5CC5 },
	{ 0x9ED6, 0x5CE0 },
	{ 0x9ED7, 0x5D2B },
	{ 0x9ED8, 0x5D5C },
	{ 0x9ED9, 0x5D76 },
	{ 0x9EDA, 0x5DEA },
	{ 0x9EDB, 0x5DEC },
	{ 0x9EDC, 0x5DED },
	{ 0x9EDD, 0x5DFC },
	{ 0x9EDE, 0x5E49 },
	{ 0x9EDF, 0x5EE4 },
	{ 0x9EE0, 0x5F09 },
	{ 0x9EE1, 0x5F16 },
	{ 0x9EE2, 0x5F45 },
	{ 0x9EE3, 0x5FC6 },
	{ 0x9EE4, 0x603A },
	{ 0x9EE5, 0x603E },
	{ 0x9EE6, 0x6077 },
	{ 0x9EE7, 0x6184 },
	{ 0x9EE8, 0x61F4 },
	{ 0x9EE9, 0x6244 },
	{ 0x9EEA, 0x6255 },
	{ 0x9EEB, 0x6256 },
	{ 0x9EEC, 0x62E5 },
	{ 0x9EED, 0x6318 },
	{ 0x9EEE, 0x6327 },
	{ 0x9EEF, 0x63B4 },
	{ 0x9EF0, 0x63B5 },
	{ 0x9EF1, 0x63BB },
	{ 0x9EF2, 0x6442 },
	{ 0x9EF3, 0x655B },
	{ 0x9EF4, 0x657D },
	{ 0x9EF5, 0x657E },
	{ 0x9EF6, 0x65C0 },
	{ 0x9EF7, 0x65D5 },
	{ 0x9EF8, 0x663F },
	{ 0x9EF9, 0x6683 },
	{ 0x9EFA, 0x66FB },
	{ 0x9EFB, 0x66FD },
	{ 0x9EFC, 0x6730 },
	{ 0x9EFD, 0x6741 },
	{ 0x9EFE, 0x6763 },
	{ 0x9F40, 0x6764 },
	{ 0x9F41, 0x67A0 },
	{ 0x9F42, 0x67A9 },
	{ 0x9F43, 0x6802 },
	{ 0x9F44, 0x6803 },
	{ 0x9F45, 0x680D },
	{ 0x9F46, 0x685B },
	{ 0x9F47, 0x685C },
	{ 0x9F48, 0x685D },
	{ 0x9F49, 0x685F },
	{ 0x9F4A, 0x6863 },
	{ 0x9F4B, 0x6867 },
	{ 0x9F4C, 0x688D },
	{ 0x9F4D, 0x68BA },
	{ 0x9F4E, 0x68BB },
	{ 0x9F4F, 0x68BC },
	{ 0x9F50, 0x68C2 },
	{ 0x9F51, 0x6919 },
	{ 0x9F52, 0x691A },
	{ 0x9F53, 0x6921 },
	{ 0x9F54, 0x6922 },
	{ 0x9F55, 0x6923 },
	{ 0x9F56, 0x6926 },
	{ 0x9F57, 0x6928 },
	{ 0x9F58, 0x697E },
	{ 0x9F59, 0x6981 },
	{ 0x9F5A, 0x698B },
	{ 0x9F5B, 0x69DD },
	{ 0x9F5C, 0x69DE },
	{ 0x9F5D, 0x6A2E },
	{ 0x9F5E, 0x6A30 },
	{ 0x9F5F, 0x6A73 },
	{ 0x9F60, 0x6A74 },
	{ 0x9F61, 0x6A75 },
	{ 0x9F62, 0x6A7B },
	{ 0x9F63, 0x6AC9 },
	{ 0x9F64, 0x6AE4 },
	{ 0x9F65, 0x6AF7 },
	{ 0x9F66, 0x6B05 },
	{ 0x9F67, 0x6B1F },
	{ 0x9F68, 0x6BA9 },
	{ 0x9F69, 0x6BB1 },
	{ 0x9F6A, 0x6BDF },
	{ 0x9F6B, 0x6BEE },
	{ 0x9F6C, 0x6C0E },
	{ 0x9F6D, 0x6C17 },
	{ 0x9F6E, 0x6C35 },
	{ 0x9F6F, 0x6C3A },
	{ 0x9F70, 0x6C3D },
	{ 0x9F71, 0x6D4C },
	{ 0x9F72, 0x6D9C },
	{ 0x9F73, 0x6D9E },
	{ 0x9F74, 0x6E13 },
	{ 0x9F75, 0x6E7F },
	{ 0x9F76, 0x6E8C },
	{ 0x9F77, 0x6EDE },
	{ 0x9F78, 0x6FF9 },
	{ 0x9F79, 0x704E },
	{ 0x9F7A, 0x7050 },
	{ 0x9F7B, 0x7114 },
	{ 0x9F7C, 0x713C },
	{ 0x9F7D, 0x713E },
	{ 0x9F7E, 0x7155 },
	{ 0x9F7F, 0xFFFD },
	{ 0x9F80, 0x5F8E },
	{ 0x9F81, 0x5F93 },
	{ 0x9F82, 0x5F8F },
	{ 0x9F83, 0x604F },
	{ 0x9F84, 0x6099 },
	{ 0x9F85, 0x607E },
	{ 0x9F86, 0x6074 },
	{ 0x9F87, 0x604B },
	{ 0x9F88, 0x6073 },
	{ 0x9F89, 0x6075 },
	{ 0x9F8A, 0x6056 },
	{ 0x9F8B, 0x60A9 },
	{ 0x9F8C, 0x608B },
	{ 0x9F8D, 0x60A6 },
	{ 0x9F8E, 0x6093 },
	{ 0x9F8F, 0x60AE },
	{ 0x9F90, 0x609E },
	{ 0x9F91, 0x60A7 },
	{ 0x9F92, 0x6245 },
	{ 0x9F93, 0x632E },
	{ 0x9F94, 0x6352 },
	{ 0x9F95, 0x6330 },
	{ 0x9F96, 0x635B },
	{ 0x9F97, 0x6319 },
	{ 0x9F98, 0x631B },
	{ 0x9F99, 0x6331 },
	{ 0x9F9A, 0x635D },
	{ 0x9F9B, 0x6337 },
	{ 0x9F9C, 0x6335 },
	{ 0x9F9D, 0x6353 },
	{ 0x9F9E, 0x635C },
	{ 0x9F9F, 0x633F },
	{ 0x9FA0, 0x654B },
	{ 0x9FA1, 0x7173 },
	{ 0x9FA2, 0x71F6 },
	{ 0x9FA3, 0x7233 },
	{ 0x9FA4, 0x725C },
	{ 0x9FA5, 0x72A0 },
	{ 0x9FA6, 0x731F },
	{ 0x9FA7, 0x7320 },
	{ 0x9FA8, 0x7339 },
	{ 0x9FA9, 0x7363 },
	{ 0x9FAA, 0x7364 },
	{ 0x9FAB, 0x73F1 },
	{ 0x9FAC, 0x7411 },
	{ 0x9FAD, 0x748F },
	{ 0x9FAE, 0x7491 },
	{ 0x9FAF, 0x74E7 },
	{ 0x9FB0, 0x74F0 },
	{ 0x9FB1, 0x74F1 },
	{ 0x9FB2, 0x74F2 },
	{ 0x9FB3, 0x74FC },
	{ 0x9FB4, 0x7505 },
	{ 0x9FB5, 0x753C },
	{ 0x9FB6, 0x7552 },
	{ 0x9FB7, 0x7560 },
	{ 0x9FB8, 0x7569 },
	{ 0x9FB9, 0x7573 },
	{ 0x9FBA, 0x7574 },
	{ 0x9FBB, 0x7582 },
	{ 0x9FBC, 0x7597 },
	{ 0x9FBD, 0x75E9 },
	{ 0x9FBE, 0x7604 },
	{ 0x9FBF, 0x7606 },
	{ 0x9FC0, 0x764D },
	{ 0x9FC1, 0x767A },
	{ 0x9FC2, 0x770C },
	{ 0x9FC3, 0x77C8 },
	{ 0x9FC4, 0x783A },
	{ 0x9FC5, 0x783C },
	{ 0x9FC6, 0x783F },
	{ 0x9FC7, 0x7872 },
	{ 0x9FC8, 0x7873 },
	{ 0x9FC9, 0x7874 },
	{ 0x9FCA, 0x78B5 },
	{ 0x9FCB, 0x78B6 },
	{ 0x9FCC, 0x78F5 },
	{ 0x9FCD, 0x7916 },
	{ 0x9FCE, 0x7934 },
	{ 0x9FCF, 0x793B },
	{ 0x9FD0, 0x7985 },
	{ 0x9FD1, 0x79F4 },
	{ 0x9FD2, 0x79FD },
	{ 0x9FD3, 0x7A24 },
	{ 0x9FD4, 0x7A43 },
	{ 0x9FD5, 0x7A5D },
	{ 0x9FD6, 0x7A63 },
	{ 0x9FD7, 0x7AC3 },
	{ 0x9FD8, 0x7B02 },
	{ 0x9FD9, 0x7B07 },
	{ 0x9FDA, 0x7B5D },
	{ 0x9FDB, 0x7B7A },
	{ 0x9FDC, 0x7B7D },
	{ 0x9FDD, 0x7B9A },
	{ 0x9FDE, 0x7BAA },
	{ 0x9FDF, 0x7BCF },
	{ 0x9FE0, 0x7BD2 },
	{ 0x9FE1, 0x7C13 },
	{ 0x9FE2, 0x7C14 },
	{ 0x9FE3, 0x7C17 },
	{ 0x9FE4, 0x7C31 },
	{ 0x9FE5, 0x7C61 },
	{ 0x9FE6, 0x7C82 },
	{ 0x9FE7, 0x7C8F },
	{ 0x9FE8, 0x7C90 },
	{ 0x9FE9, 0x7CAD },
	{ 0x9FEA, 0x7CD8 },
	{ 0x9FEB, 0x7D26 },
	{ 0x9FEC, 0x7D9A },
	{ 0x9FED, 0x7D9B },
	{ 0x9FEE, 0x7DD5 },
	{ 0x9FEF, 0x7E05 },
	{ 0x9FF0, 0x7E28 },
	{ 0x9FF1, 0x7E4A },
	{ 0x9FF2, 0x7E4B },
	{ 0x9FF3, 0x7E67 },
	{ 0x9FF4, 0x7E83 },
	{ 0x9FF5, 0x7E90 },
	{ 0x9FF6, 0x7F53 },
	{ 0x9FF7, 0x7FAA },
	{ 0x9FF8, 0x8062 },
	{ 0x9FF9, 0x810B },
	{ 0x9FFA, 0x8133 },
	{ 0x9FFB, 0x8135 },
	{ 0x9FFC, 0x8157 },
	{ 0x9FFD, 0x81A4 },
	{ 0x9FFE, 0x81D3 },
	{ 0xA040, 0x8217 },
	{ 0xA041, 0x822E },
	{ 0xA042, 0x824D },
	{ 0xA043, 0x825D },
	{ 0xA044, 0x8260 },
	{ 0xA045, 0x827A },
	{ 0xA046, 0x82C6 },
	{ 0xA047, 0x83B1 },
	{ 0xA048, 0x83B5 },
	{ 0xA049, 0x83BB },
	{ 0xA04A, 0x8419 },
	{ 0xA04B, 0x8420 },
	{ 0xA04C, 0x8422 },
	{ 0xA04D, 0x8485 },
	{ 0xA04E, 0x848A },
	{ 0xA04F, 0x848B },
	{ 0xA050, 0x84D9 },
	{ 0xA051, 0x84DC },
	{ 0xA052, 0x8536 },
	{ 0xA053, 0x85AD },
	{ 0xA054, 0x85AE },
	{ 0xA055, 0x8612 },
	{ 0xA056, 0x8630 },
	{ 0xA057, 0x8644 },
	{ 0xA058, 0x86AB },
	{ 0xA059, 0x86CD },
	{ 0xA05A, 0x86CE },
	{ 0xA05B, 0x86EF },
	{ 0xA05C, 0x8749 },
	{ 0xA05D, 0x874B },
	{ 0xA05E, 0x877F },
	{ 0xA05F, 0x87A6 },
	{ 0xA060, 0x87A7 },
	{ 0xA061, 0x87D0 },
	{ 0xA062, 0x8864 },
	{ 0xA063, 0x88AE },
	{ 0xA064, 0x88B0 },
	{ 0xA065, 0x88C3 },
	{ 0xA066, 0x88C4 },
	{ 0xA067, 0x88C5 },
	{ 0xA068, 0x8904 },
	{ 0xA069, 0x891C },
	{ 0xA06A, 0x891D },
	{ 0xA06B, 0x8945 },
	{ 0xA06C, 0x8968 },
	{ 0xA06D, 0x8977 },
	{ 0xA06E, 0x8A33 },
	{ 0xA06F, 0x8A89 },
	{ 0xA070, 0x8AAD },
	{ 0xA071, 0x8AAE },
	{ 0xA072, 0x8ADA },
	{ 0xA073, 0x8B21 },
	{ 0xA074, 0x8B5B },
	{ 0xA075, 0x8B72 },
	{ 0xA076, 0x8B8F },
	{ 0xA077, 0x8CCE },
	{ 0xA078, 0x8DE5 },
	{ 0xA079, 0x8DF5 },
	{ 0xA07A, 0x8E7D },
	{ 0xA07B, 0x8E9B },
	{ 0xA07C, 0x8EB5 },
	{ 0xA07D, 0x8EBB },
	{ 0xA07E, 0x8EC5 },
	{ 0xA07F, 0xFFFD },
	{ 0xA080, 0x658B },
	{ 0xA081, 0x659A },
	{ 0xA082, 0x6650 },
	{ 0xA083, 0x6646 },
	{ 0xA084, 0x664E },
	{ 0xA085, 0x6640 },
	{ 0xA086, 0x664B },
	{ 0xA087, 0x6648 },
	{ 0xA088, 0x6660 },
	{ 0xA089, 0x6644 },
	{ 0xA08A, 0x664D },
	{ 0xA08B, 0x6837 },
	{ 0xA08C, 0x6824 },
	{ 0xA08D, 0x681B },
	{ 0xA08E, 0x6836 },
	{ 0xA08F, 0x682C },
	{ 0xA090, 0x6819 },
	{ 0xA091, 0x6856 },
	{ 0xA092, 0x6847 },
	{ 0xA093, 0x683E },
	{ 0xA094, 0x681E },
	{ 0xA095, 0x6815 },
	{ 0xA096, 0x6822 },
	{ 0xA097, 0x6827 },
	{ 0xA098, 0x6859 },
	{ 0xA099, 0x6858 },
	{ 0xA09A, 0x6855 },
	{ 0xA09B, 0x6830 },
	{ 0xA09C, 0x6823 },
	{ 0xA09D, 0x6B2E },
	{ 0xA09E, 0x6B2B },
	{ 0xA09F, 0x6B30 },
	{ 0xA0A0, 0x6B6C },
	{ 0xA0A1, 0x8EC8 },
	{ 0xA0A2, 0x8EE2 },
	{ 0xA0A3, 0x8EE3 },
	{ 0xA0A4, 0x8F0C },
	{ 0xA0A5, 0x8F4C },
	{ 0xA0A6, 0x8FBA },
	{ 0xA0A7, 0x8FDA },
	{ 0xA0A8, 0x8FF2 },
	{ 0xA0A9, 0x9027 },
	{ 0xA0AA, 0x9039 },
	{ 0xA0AB, 0x9056 },
	{ 0xA0AC, 0x9065 },
	{ 0xA0AD, 0x915B },
	{ 0xA0AE, 0x9197 },
	{ 0xA0AF, 0x91A4 },
	{ 0xA0B0, 0x91B8 },
	{ 0xA0B1, 0x91C8 },
	{ 0xA0B2, 0x91E1 },
	{ 0xA0B3, 0x91FB },
	{ 0xA0B4, 0x91FC },
	{ 0xA0B5, 0x9228 },
	{ 0xA0B6, 0x9229 },
	{ 0xA0B7, 0x922C },
	{ 0xA0B8, 0x9271 },
	{ 0xA0B9, 0x9344 },
	{ 0xA0BA, 0x93BA },
	{ 0xA0BB, 0x9421 },
	{ 0xA0BC, 0x9441 },
	{ 0xA0BD, 0x9453 },
	{ 0xA0BE, 0x958A },
	{ 0xA0BF, 0x95AA },
	{ 0xA0C0, 0x95CF },
	{ 0xA0C1, 0x9665 },
	{ 0xA0C2, 0x9666 },
	{ 0xA0C3, 0x967A },
	{ 0xA0C4, 0x974C },
	{ 0xA0C5, 0x974E },
	{ 0xA0C6, 0x974F },
	{ 0xA0C7, 0x9771 },
	{ 0xA0C8, 0x9786 },
	{ 0xA0C9, 0x9790 },
	{ 0xA0CA, 0x982C },
	{ 0xA0CB, 0x98AA },
	{ 0xA0CC, 0x98B4 },
	{ 0xA0CD, 0x98C5 },
	{ 0xA0CE, 0x98EE },
	{ 0xA0CF, 0x99C5 },
	{ 0xA0D0, 0x99F2 },
	{ 0xA0D1, 0x9A12 },
	{ 0xA0D2, 0x9A13 },
	{ 0xA0D3, 0x9A28 },
	{ 0xA0D4, 0x9AC5 },
	{ 0xA0D5, 0x9B36 },
	{ 0xA0D6, 0x9B5E },
	{ 0xA0D7, 0x9B78 },
	{ 0xA0D8, 0x9B97 },
	{ 0xA0D9, 0x9BB2 },
	{ 0xA0DA, 0x9BB4 },
	{ 0xA0DB, 0x9BCE },
	{ 0xA0DC, 0x9BD0 },
	{ 0xA0DD, 0x9BD1 },
	{ 0xA0DE, 0x9BF1 },
	{ 0xA0DF, 0x9BF2 },
	{ 0xA0E0, 0x9BF5 },
	{ 0xA0E1, 0x9C18 },
	{ 0xA0E2, 0x9C19 },
	{ 0xA0E3, 0x9C1A },
	{ 0xA0E4, 0x9C30 },
	{ 0xA0E5, 0x9C5A },
	{ 0xA0E6, 0x9C5B },
	{ 0xA0E7, 0x9C5C },
	{ 0xA0E8, 0x9C69 },
	{ 0xA0E9, 0x9C6A },
	{ 0xA0EA, 0x9C6B },
	{ 0xA0EB, 0x9C70 },
	{ 0xA0EC, 0x9CF0 },
	{ 0xA0ED, 0x9D0E },
	{ 0xA0EE, 0x9D2B },
	{ 0xA0EF, 0x9D2C },
	{ 0xA0F0, 0x9D46 },
	{ 0xA0F1, 0x9D48 },
	{ 0xA0F2, 0x9D65 },
	{ 0xA0F3, 0x9D8E },
	{ 0xA0F4, 0x9D8F },
	{ 0xA0F5, 0x9DAB },
	{ 0xA0F6, 0x9DC6 },
	{ 0xA0F7, 0x9E78 },
	{ 0xA0F8, 0x9EB8 },
	{ 0xA0F9, 0x9EB9 },
	{ 0xA0FA, 0x9EBA },
	{ 0xA0FB, 0x9F21 },
	{ 0xA0FC, 0x9F62 },
	{ 0xA0FD, 0xFFFD },
	{ 0xA0FE, 0xFFFD },
	{ 0xA140, 0x3000 },
	{ 0xA141, 0xFF0C },
	{ 0xA142, 0x3001 },
	{ 0xA143, 0x3002 },
	{ 0xA144, 0xFF0E },
	{ 0xA145, 0x2027 },
	{ 0xA146, 0xFF1B },
	{ 0xA147, 0xFF1A },
	{ 0xA148, 0xFF1F },
	{ 0xA149, 0xFF01 },
	{ 0xA14A, 0xFE30 },
	{ 0xA14B, 0x2026 },
	{ 0xA14C, 0x2025 },
	{ 0xA14D, 0xFE50 },
	{ 0xA14E, 0xFE51 },
	{ 0xA14F, 0xFE52 },
	{ 0xA150, 0x00B7 },
	{ 0xA151, 0xFE54 },
	{ 0xA152, 0xFE55 },
	{ 0xA153, 0xFE56 },
	{ 0xA154, 0xFE57 },
	{ 0xA155, 0xFF5C },
	{ 0xA156, 0x2015 },
	{ 0xA157, 0xFE31 },
	{ 0xA158, 0x2014 },
	{ 0xA159, 0xFE33 },
	{ 0xA15A, 0x2574 },
	{ 0xA15B, 0xFE34 },
	{ 0xA15C, 0xFE4F },
	{ 0xA15D, 0xFF08 },
	{ 0xA15E, 0xFF09 },
	{ 0xA15F, 0xFE35 },
	{ 0xA160, 0xFE36 },
	{ 0xA161, 0xFF5B },
	{ 0xA162, 0xFF5D },
	{ 0xA163, 0xFE37 },
	{ 0xA164, 0xFE38 },
	{ 0xA165, 0x3014 },
	{ 0xA166, 0x3015 },
	{ 0xA167, 0xFE39 },
	{ 0xA168, 0xFE3A },
	{ 0xA169, 0x3010 },
	{ 0xA16A, 0x3011 },
	{ 0xA16B, 0xFE3B },
	{ 0xA16C, 0xFE3C },
	{ 0xA16D, 0x300A },
	{ 0xA16E, 0x300B },
	{ 0xA16F, 0xFE3D },
	{ 0xA170, 0xFE3E },
	{ 0xA171, 0x3008 },
	{ 0xA172, 0x3009 },
	{ 0xA173, 0xFE3F },
	{ 0xA174, 0xFE40 },
	{ 0xA175, 0x300C },
	{ 0xA176, 0x300D },
	{ 0xA177, 0xFE41 },
	{ 0xA178, 0xFE42 },
	{ 0xA179, 0x300E },
	{ 0xA17A, 0x300F },
	{ 0xA17B, 0xFE43 },
	{ 0xA17C, 0xFE44 },
	{ 0xA17D, 0xFE59 },
	{ 0xA17E, 0xFE5A },
	{ 0xA17F, 0xFFFD },
	{ 0xA180, 0x6B8B },
	{ 0xA181, 0x6BE9 },
	{ 0xA182, 0x6BEA },
	{ 0xA183, 0x6BE5 },
	{ 0xA184, 0x6D6B },
	{ 0xA185, 0x6D73 },
	{ 0xA186, 0x6D57 },
	{ 0xA187, 0x6D5D },
	{ 0xA188, 0x6D56 },
	{ 0xA189, 0x6D8F },
	{ 0xA18A, 0x6D5B },
	{ 0xA18B, 0x6D1C },
	{ 0xA18C, 0x6D9A },
	{ 0xA18D, 0x6D9B },
	{ 0xA18E, 0x6D99 },
	{ 0xA18F, 0x6D81 },
	{ 0xA190, 0x6D71 },
	{ 0xA191, 0x6D72 },
	{ 0xA192, 0x6D5C },
	{ 0xA193, 0x6D96 },
	{ 0xA194, 0x70C4 },
	{ 0xA195, 0x70DB },
	{ 0xA196, 0x70CC },
	{ 0xA197, 0x70D0 },
	{ 0xA198, 0x70E3 },
	{ 0xA199, 0x70DF },
	{ 0xA19A, 0x70D6 },
	{ 0xA19B, 0x70EE },
	{ 0xA19C, 0x70D5 },
	{ 0xA19D, 0x727A },
	{ 0xA19E, 0x72F5 },
	{ 0xA19F, 0x7302 },
	{ 0xA1A0, 0x73E2 },
	{ 0xA1A1, 0xFE5B },
	{ 0xA1A2, 0xFE5C },
	{ 0xA1A3, 0xFE5D },
	{ 0xA1A4, 0xFE5E },
	{ 0xA1A5, 0x2018 },
	{ 0xA1A6, 0x2019 },
	{ 0xA1A7, 0x201C },
	{ 0xA1A8, 0x201D },
	{ 0xA1A9, 0x301D },
	{ 0xA1AA, 0x301E },
	{ 0xA1AB, 0x2035 },
	{ 0xA1AC, 0x2032 },
	{ 0xA1AD, 0xFF03 },
	{ 0xA1AE, 0xFF06 },
	{ 0xA1AF, 0xFF0A },
	{ 0xA1B0, 0x203B },
	{ 0xA1B1, 0x00A7 },
	{ 0xA1B2, 0x3003 },
	{ 0xA1B3, 0x25CB },
	{ 0xA1B4, 0x25CF },
	{ 0xA1B5, 0x25B3 },
	{ 0xA1B6, 0x25B2 },
	{ 0xA1B7, 0x25CE },
	{ 0xA1B8, 0x2606 },
	{ 0xA1B9, 0x2605 },
	{ 0xA1BA, 0x25C7 },
	{ 0xA1BB, 0x25C6 },
	{ 0xA1BC, 0x25A1 },
	{ 0xA1BD, 0x25A0 },
	{ 0xA1BE, 0x25BD },
	{ 0xA1BF, 0x25BC },
	{ 0xA1C0, 0x32A3 },
	{ 0xA1C1, 0x2105 },
	{ 0xA1C2, 0x203E },
	{ 0xA1C3, 0xFFE3 },
	{ 0xA1C4, 0xFF3F },
	{ 0xA1C5, 0x02CD },
	{ 0xA1C6, 0xFE49 },
	{ 0xA1C7, 0xFE4A },
	{ 0xA1C8, 0xFE4D },
	{ 0xA1C9, 0xFE4E },
	{ 0xA1CA, 0xFE4B },
	{ 0xA1CB, 0xFE4C },
	{ 0xA1CC, 0xFE5F },
	{ 0xA1CD, 0xFE60 },
	{ 0xA1CE, 0xFE61 },
	{ 0xA1CF, 0xFF0B },
	{ 0xA1D0, 0xFF0D },
	{ 0xA1D1, 0x00D7 },
	{ 0xA1D2, 0x00F7 },
	{ 0xA1D3, 0x00B1 },
	{ 0xA1D4, 0x221A },
	{ 0xA1D5, 0xFF1C },
	{ 0xA1D6, 0xFF1E },
	{ 0xA1D7, 0xFF1D },
	{ 0xA1D8, 0x2266 },
	{ 0xA1D9, 0x2267 },
	{ 0xA1DA, 0x2260 },
	{ 0xA1DB, 0x221E },
	{ 0xA1DC, 0x2252 },
	{ 0xA1DD, 0x2261 },
	{ 0xA1DE, 0xFE62 },
	{ 0xA1DF, 0xFE63 },
	{ 0xA1E0, 0xFE64 },
	{ 0xA1E1, 0xFE65 },
	{ 0xA1E2, 0xFE66 },
	{ 0xA1E3, 0xFF5E },
	{ 0xA1E4, 0x2229 },
	{ 0xA1E5, 0x222A },
	{ 0xA1E6, 0x22A5 },
	{ 0xA1E7, 0x2220 },
	{ 0xA1E8, 0x221F },
	{ 0xA1E9, 0x22BF },
	{ 0xA1EA, 0x33D2 },
	{ 0xA1EB, 0x33D1 },
	{ 0xA1EC, 0x222B },
	{ 0xA1ED, 0x222E },
	{ 0xA1EE, 0x2235 },
	{ 0xA1EF, 0x2234 },
	{ 0xA1F0, 0x2640 },
	{ 0xA1F1, 0x2642 },
	{ 0xA1F2, 0x2295 },
	{ 0xA1F3, 0x2299 },
	{ 0xA1F4, 0x2191 },
	{ 0xA1F5, 0x2193 },
	{ 0xA1F6, 0x2190 },
	{ 0xA1F7, 0x2192 },
	{ 0xA1F8, 0x2196 },
	{ 0xA1F9, 0x2197 },
	{ 0xA1FA, 0x2199 },
	{ 0xA1FB, 0x2198 },
	{ 0xA1FC, 0x2225 },
	{ 0xA1FD, 0x2223 },
	{ 0xA1FE, 0xFF0F },
	{ 0xA240, 0xFF3C },
	{ 0xA241, 0x2215 },
	{ 0xA242, 0xFE68 },
	{ 0xA243, 0xFF04 },
	{ 0xA244, 0xFFE5 },
	{ 0xA245, 0x3012 },
	{ 0xA246, 0xFFE0 },
	{ 0xA247, 0xFFE1 },
	{ 0xA248, 0xFF05 },
	{ 0xA249, 0xFF20 },
	{ 0xA24A, 0x2103 },
	{ 0xA24B, 0x2109 },
	{ 0xA24C, 0xFE69 },
	{ 0xA24D, 0xFE6A },
	{ 0xA24E, 0xFE6B },
	{ 0xA24F, 0x33D5 },
	{ 0xA250, 0x339C },
	{ 0xA251, 0x339D },
	{ 0xA252, 0x339E },
	{ 0xA253, 0x33CE },
	{ 0xA254, 0x33A1 },
	{ 0xA255, 0x338E },
	{ 0xA256, 0x338F },
	{ 0xA257, 0x33C4 },
	{ 0xA258, 0x00B0 },
	{ 0xA259, 0x5159 },
	{ 0xA25A, 0x515B },
	{ 0xA25B, 0x515E },
	{ 0xA25C, 0x515D },
	{ 0xA25D, 0x5161 },
	{ 0xA25E, 0x5163 },
	{ 0xA25F, 0x55E7 },
	{ 0xA260, 0x74E9 },
	{ 0xA261, 0x7CCE },
	{ 0xA262, 0x2581 },
	{ 0xA263, 0x2582 },
	{ 0xA264, 0x2583 },
	{ 0xA265, 0x2584 },
	{ 0xA266, 0x2585 },
	{ 0xA267, 0x2586 },
	{ 0xA268, 0x2587 },
	{ 0xA269, 0x2588 },
	{ 0xA26A, 0x258F },
	{ 0xA26B, 0x258E },
	{ 0xA26C, 0x258D },
	{ 0xA26D, 0x258C },
	{ 0xA26E, 0x258B },
	{ 0xA26F, 0x258A },
	{ 0xA270, 0x2589 },
	{ 0xA271, 0x253C },
	{ 0xA272, 0x2534 },
	{ 0xA273, 0x252C },
	{ 0xA274, 0x2524 },
	{ 0xA275, 0x251C },
	{ 0xA276, 0x2594 },
	{ 0xA277, 0x2500 },
	{ 0xA278, 0x2502 },
	{ 0xA279, 0x2595 },
	{ 0xA27A, 0x250C },
	{ 0xA27B, 0x2510 },
	{ 0xA27C, 0x2514 },
	{ 0xA27D, 0x2518 },
	{ 0xA27E, 0x256D },
	{ 0xA27F, 0xFFFD },
	{ 0xA280, 0x73EC },
	{ 0xA281, 0x73D5 },
	{ 0xA282, 0x73F9 },
	{ 0xA283, 0x73DF },
	{ 0xA284, 0x73E6 },
	{ 0xA285, 0x73E4 },
	{ 0xA286, 0x73E1 },
	{ 0xA287, 0x74F3 },
	{ 0xA288, 0x7556 },
	{ 0xA289, 0x7555 },
	{ 0xA28A, 0x7558 },
	{ 0xA28B, 0x7557 },
	{ 0xA28C, 0x755E },
	{ 0xA28D, 0x75C3 },
	{ 0xA28E, 0x75B4 },
	{ 0xA28F, 0x75B1 },
	{ 0xA290, 0x76CB },
	{ 0xA291, 0x76CC },
	{ 0xA292, 0x772A },
	{ 0xA293, 0x7716 },
	{ 0xA294, 0x770F },
	{ 0xA295, 0x773F },
	{ 0xA296, 0x772B },
	{ 0xA297, 0x770E },
	{ 0xA298, 0x7724 },
	{ 0xA299, 0x7721 },
	{ 0xA29A, 0x7718 },
	{ 0xA29B, 0x77DD },
	{ 0xA29C, 0x7824 },
	{ 0xA29D, 0x7836 },
	{ 0xA29E, 0x7958 },
	{ 0xA29F, 0x7959 },
	{ 0xA2A0, 0x7962 },
	{ 0xA2A1, 0x256E },
	{ 0xA2A2, 0x2570 },
	{ 0xA2A3, 0x256F },
	{ 0xA2A4, 0x2501 },
	{ 0xA2A5, 0x251D },
	{ 0xA2A6, 0x253F },
	{ 0xA2A7, 0x2525 },
	{ 0xA2A8, 0x25E2 },
	{ 0xA2A9, 0x25E3 },
	{ 0xA2AA, 0x25E5 },
	{ 0xA2AB, 0x25E4 },
	{ 0xA2AC, 0x2571 },
	{ 0xA2AD, 0x2572 },
	{ 0xA2AE, 0x2573 },
	{ 0xA2AF, 0xFF10 },
	{ 0xA2B0, 0xFF11 },
	{ 0xA2B1, 0xFF12 },
	{ 0xA2B2, 0xFF13 },
	{ 0xA2B3, 0xFF14 },
	{ 0xA2B4, 0xFF15 },
	{ 0xA2B5, 0xFF16 },
	{ 0xA2B6, 0xFF17 },
	{ 0xA2B7, 0xFF18 },
	{ 0xA2B8, 0xFF19 },
	{ 0xA2B9, 0x2160 },
	{ 0xA2BA, 0x2161 },
	{ 0xA2BB, 0x2162 },
	{ 0xA2BC, 0x2163 },
	{ 0xA2BD, 0x2164 },
	{ 0xA2BE, 0x2165 },
	{ 0xA2BF, 0x2166 },
	{ 0xA2C0, 0x2167 },
	{ 0xA2C1, 0x2168 },
	{ 0xA2C2, 0x2169 },
	{ 0xA2C3, 0x3021 },
	{ 0xA2C4, 0x3022 },
	{ 0xA2C5, 0x3023 },
	{ 0xA2C6, 0x3024 },
	{ 0xA2C7, 0x3025 },
	{ 0xA2C8, 0x3026 },
	{ 0xA2C9, 0x3027 },
	{ 0xA2CA, 0x3028 },
	{ 0xA2CB, 0x3029 },
	{ 0xA2CC, 0x5341 },
	{ 0xA2CD, 0x5344 },
	{ 0xA2CE, 0x5345 },
	{ 0xA2CF, 0xFF21 },
	{ 0xA2D0, 0xFF22 },
	{ 0xA2D1, 0xFF23 },
	{ 0xA2D2, 0xFF24 },
	{ 0xA2D3, 0xFF25 },
	{ 0xA2D4, 0xFF26 },
	{ 0xA2D5, 0xFF27 },
	{ 0xA2D6, 0xFF28 },
	{ 0xA2D7, 0xFF29 },
	{ 0xA2D8, 0xFF2A },
	{ 0xA2D9, 0xFF2B },
	{ 0xA2DA, 0xFF2C },
	{ 0xA2DB, 0xFF2D },
	{ 0xA2DC, 0xFF2E },
	{ 0xA2DD, 0xFF2F },
	{ 0xA2DE, 0xFF30 },
	{ 0xA2DF, 0xFF31 },
	{ 0xA2E0, 0xFF32 },
	{ 0xA2E1, 0xFF33 },
	{ 0xA2E2, 0xFF34 },
	{ 0xA2E3, 0xFF35 },
	{ 0xA2E4, 0xFF36 },
	{ 0xA2E5, 0xFF37 },
	{ 0xA2E6, 0xFF38 },
	{ 0xA2E7, 0xFF39 },
	{ 0xA2E8, 0xFF3A },
	{ 0xA2E9, 0xFF41 },
	{ 0xA2EA, 0xFF42 },
	{ 0xA2EB, 0xFF43 },
	{ 0xA2EC, 0xFF44 },
	{ 0xA2ED, 0xFF45 },
	{ 0xA2EE, 0xFF46 },
	{ 0xA2EF, 0xFF47 },
	{ 0xA2F0, 0xFF48 },
	{ 0xA2F1, 0xFF49 },
	{ 0xA2F2, 0xFF4A },
	{ 0xA2F3, 0xFF4B },
	{ 0xA2F4, 0xFF4C },
	{ 0xA2F5, 0xFF4D },
	{ 0xA2F6, 0xFF4E },
	{ 0xA2F7, 0xFF4F },
	{ 0xA2F8, 0xFF50 },
	{ 0xA2F9, 0xFF51 },
	{ 0xA2FA, 0xFF52 },
	{ 0xA2FB, 0xFF53 },
	{ 0xA2FC, 0xFF54 },
	{ 0xA2FD, 0xFF55 },
	{ 0xA2FE, 0xFF56 },
	{ 0xA340, 0xFF57 },
	{ 0xA341, 0xFF58 },
	{ 0xA342, 0xFF59 },
	{ 0xA343, 0xFF5A },
	{ 0xA344, 0x0391 },
	{ 0xA345, 0x0392 },
	{ 0xA346, 0x0393 },
	{ 0xA347, 0x0394 },
	{ 0xA348, 0x0395 },
	{ 0xA349, 0x0396 },
	{ 0xA34A, 0x0397 },
	{ 0xA34B, 0x0398 },
	{ 0xA34C, 0x0399 },
	{ 0xA34D, 0x039A },
	{ 0xA34E, 0x039B },
	{ 0xA34F, 0x039C },
	{ 0xA350, 0x039D },
	{ 0xA351, 0x039E },
	{ 0xA352, 0x039F },
	{ 0xA353, 0x03A0 },
	{ 0xA354, 0x03A1 },
	{ 0xA355, 0x03A3 },
	{ 0xA356, 0x03A4 },
	{ 0xA357, 0x03A5 },
	{ 0xA358, 0x03A6 },
	{ 0xA359, 0x03A7 },
	{ 0xA35A, 0x03A8 },
	{ 0xA35B, 0x03A9 },
	{ 0xA35C, 0x03B1 },
	{ 0xA35D, 0x03B2 },
	{ 0xA35E, 0x03B3 },
	{ 0xA35F, 0x03B4 },
	{ 0xA360, 0x03B5 },
	{ 0xA361, 0x03B6 },
	{ 0xA362, 0x03B7 },
	{ 0xA363, 0x03B8 },
	{ 0xA364, 0x03B9 },
	{ 0xA365, 0x03BA },
	{ 0xA366, 0x03BB },
	{ 0xA367, 0x03BC },
	{ 0xA368, 0x03BD },
	{ 0xA369, 0x03BE },
	{ 0xA36A, 0x03BF },
	{ 0xA36B, 0x03C0 },
	{ 0xA36C, 0x03C1 },
	{ 0xA36D, 0x03C3 },
	{ 0xA36E, 0x03C4 },
	{ 0xA36F, 0x03C5 },
	{ 0xA370, 0x03C6 },
	{ 0xA371, 0x03C7 },
	{ 0xA372, 0x03C8 },
	{ 0xA373, 0x03C9 },
	{ 0xA374, 0x3105 },
	{ 0xA375, 0x3106 },
	{ 0xA376, 0x3107 },
	{ 0xA377, 0x3108 },
	{ 0xA378, 0x3109 },
	{ 0xA379, 0x310A },
	{ 0xA37A, 0x310B },
	{ 0xA37B, 0x310C },
	{ 0xA37C, 0x310D },
	{ 0xA37D, 0x310E },
	{ 0xA37E, 0x310F },
	{ 0xA37F, 0xFFFD },
	{ 0xA380, 0x79DA },
	{ 0xA381, 0x79D9 },
	{ 0xA382, 0x79E1 },
	{ 0xA383, 0x79E5 },
	{ 0xA384, 0x79E8 },
	{ 0xA385, 0x79DB },
	{ 0xA386, 0x79E2 },
	{ 0xA387, 0x79F0 },
	{ 0xA388, 0x7ADA },
	{ 0xA389, 0x7ADD },
	{ 0xA38A, 0x7ADB },
	{ 0xA38B, 0x7ADC },
	{ 0xA38C, 0x7B0D },
	{ 0xA38D, 0x7B0B },
	{ 0xA38E, 0x7B14 },
	{ 0xA38F, 0x7C8E },
	{ 0xA390, 0x7C86 },
	{ 0xA391, 0x7C87 },
	{ 0xA392, 0x7C83 },
	{ 0xA393, 0x7C8B },
	{ 0xA394, 0x7D24 },
	{ 0xA395, 0x7D25 },
	{ 0xA396, 0x7F62 },
	{ 0xA397, 0x7F93 },
	{ 0xA398, 0x7F99 },
	{ 0xA399, 0x7F97 },
	{ 0xA39A, 0x7FC4 },
	{ 0xA39B, 0x7FC6 },
	{ 0xA39C, 0x800A },
	{ 0xA39D, 0x8040 },
	{ 0xA39E, 0x803C },
	{ 0xA39F, 0x803B },
	{ 0xA3A0, 0x80F6 },
	{ 0xA3A1, 0x3110 },
	{ 0xA3A2, 0x3111 },
	{ 0xA3A3, 0x3112 },
	{ 0xA3A4, 0x3113 },
	{ 0xA3A5, 0x3114 },
	{ 0xA3A6, 0x3115 },
	{ 0xA3A7, 0x3116 },
	{ 0xA3A8, 0x3117 },
	{ 0xA3A9, 0x3118 },
	{ 0xA3AA, 0x3119 },
	{ 0xA3AB, 0x311A },
	{ 0xA3AC, 0x311B },
	{ 0xA3AD, 0x311C },
	{ 0xA3AE, 0x311D },
	{ 0xA3AF, 0x311E },
	{ 0xA3B0, 0x311F },
	{ 0xA3B1, 0x3120 },
	{ 0xA3B2, 0x3121 },
	{ 0xA3B3, 0x3122 },
	{ 0xA3B4, 0x3123 },
	{ 0xA3B5, 0x3124 },
	{ 0xA3B6, 0x3125 },
	{ 0xA3B7, 0x3126 },
	{ 0xA3B8, 0x3127 },
	{ 0xA3B9, 0x3128 },
	{ 0xA3BA, 0x3129 },
	{ 0xA3BB, 0x02D9 },
	{ 0xA3BC, 0x02C9 },
	{ 0xA3BD, 0x02CA },
	{ 0xA3BE, 0x02C7 },
	{ 0xA3BF, 0x02CB },
	{ 0xA3C0, 0x2400 },
	{ 0xA3C1, 0x2401 },
	{ 0xA3C2, 0x2402 },
	{ 0xA3C3, 0x2403 },
	{ 0xA3C4, 0x2404 },
	{ 0xA3C5, 0x2405 },
	{ 0xA3C6, 0x2406 },
	{ 0xA3C7, 0x2407 },
	{ 0xA3C8, 0x2408 },
	{ 0xA3C9, 0x2409 },
	{ 0xA3CA, 0x240A },
	{ 0xA3CB, 0x240B },
	{ 0xA3CC, 0x240C },
	{ 0xA3CD, 0x240D },
	{ 0xA3CE, 0x240E },
	{ 0xA3CF, 0x240F },
	{ 0xA3D0, 0x2410 },
	{ 0xA3D1, 0x2411 },
	{ 0xA3D2, 0x2412 },
	{ 0xA3D3, 0x2413 },
	{ 0xA3D4, 0x2414 },
	{ 0xA3D5, 0x2415 },
	{ 0xA3D6, 0x2416 },
	{ 0xA3D7, 0x2417 },
	{ 0xA3D8, 0x2418 },
	{ 0xA3D9, 0x2419 },
	{ 0xA3DA, 0x241A },
	{ 0xA3DB, 0x241B },
	{ 0xA3DC, 0x241C },
	{ 0xA3DD, 0x241D },
	{ 0xA3DE, 0x241E },
	{ 0xA3DF, 0x241F },
	{ 0xA3E0, 0x2421 },
	{ 0xA3E1, 0x532C },
	{ 0xA3E2, 0x5359 },
	{ 0xA3E3, 0x5368 },
	{ 0xA3E4, 0x537E },
	{ 0xA3E5, 0x53A1 },
	{ 0xA3E6, 0x555B },
	{ 0xA3E7, 0x5542 },
	{ 0xA3E8, 0x5547 },
	{ 0xA3E9, 0x553D },
	{ 0xA3EA, 0x5560 },
	{ 0xA3EB, 0x57EB },
	{ 0xA3EC, 0x595F },
	{ 0xA3ED, 0x5B6F },
	{ 0xA3EE, 0x5C5A },
	{ 0xA3EF, 0x5FA2 },
	{ 0xA3F0, 0x5F9D },
	{ 0xA3F1, 0x5FA3 },
	{ 0xA3F2, 0x60C2 },
	{ 0xA3F3, 0x60A5 },
	{ 0xA3F4, 0x621C },
	{ 0xA3F5, 0x621D },
	{ 0xA3F6, 0x6395 },
	{ 0xA3F7, 0x639A },
	{ 0xA3F8, 0x63A6 },
	{ 0xA3F9, 0x6550 },
	{ 0xA3FA, 0x6552 },
	{ 0xA3FB, 0x65C8 },
	{ 0xA3FC, 0x6658 },
	{ 0xA3FD, 0x6888 },
	{ 0xA3FE, 0x6BB8 },
	{ 0xA440, 0x4E00 },
	{ 0xA441, 0x4E59 },
	{ 0xA442, 0x4E01 },
	{ 0xA443, 0x4E03 },
	{ 0xA444, 0x4E43 },
	{ 0xA445, 0x4E5D },
	{ 0xA446, 0x4E86 },
	{ 0xA447, 0x4E8C },
	{ 0xA448, 0x4EBA },
	{ 0xA449, 0x513F },
	{ 0xA44A, 0x5165 },
	{ 0xA44B, 0x516B },
	{ 0xA44C, 0x51E0 },
	{ 0xA44D, 0x5200 },
	{ 0xA44E, 0x5201 },
	{ 0xA44F, 0x529B },
	{ 0xA450, 0x5315 },
	{ 0xA451, 0x5341 },
	{ 0xA452, 0x535C },
	{ 0xA453, 0x53C8 },
	{ 0xA454, 0x4E09 },
	{ 0xA455, 0x4E0B },
	{ 0xA456, 0x4E08 },
	{ 0xA457, 0x4E0A },
	{ 0xA458, 0x4E2B },
	{ 0xA459, 0x4E38 },
	{ 0xA45A, 0x51E1 },
	{ 0xA45B, 0x4E45 },
	{ 0xA45C, 0x4E48 },
	{ 0xA45D, 0x4E5F },
	{ 0xA45E, 0x4E5E },
	{ 0xA45F, 0x4E8E },
	{ 0xA460, 0x4EA1 },
	{ 0xA461, 0x5140 },
	{ 0xA462, 0x5203 },
	{ 0xA463, 0x52FA },
	{ 0xA464, 0x5343 },
	{ 0xA465, 0x53C9 },
	{ 0xA466, 0x53E3 },
	{ 0xA467, 0x571F },
	{ 0xA468, 0x58EB },
	{ 0xA469, 0x5915 },
	{ 0xA46A, 0x5927 },
	{ 0xA46B, 0x5973 },
	{ 0xA46C, 0x5B50 },
	{ 0xA46D, 0x5B51 },
	{ 0xA46E, 0x5B53 },
	{ 0xA46F, 0x5BF8 },
	{ 0xA470, 0x5C0F },
	{ 0xA471, 0x5C22 },
	{ 0xA472, 0x5C38 },
	{ 0xA473, 0x5C71 },
	{ 0xA474, 0x5DDD },
	{ 0xA475, 0x5DE5 },
	{ 0xA476, 0x5DF1 },
	{ 0xA477, 0x5DF2 },
	{ 0xA478, 0x5DF3 },
	{ 0xA479, 0x5DFE },
	{ 0xA47A, 0x5E72 },
	{ 0xA47B, 0x5EFE },
	{ 0xA47C, 0x5F0B },
	{ 0xA47D, 0x5F13 },
	{ 0xA47E, 0x624D },
	{ 0xA47F, 0xFFFD },
	{ 0xA480, 0x80FF },
	{ 0xA481, 0x80EE },
	{ 0xA482, 0x8104 },
	{ 0xA483, 0x8103 },
	{ 0xA484, 0x8107 },
	{ 0xA485, 0x80F7 },
	{ 0xA486, 0x822D },
	{ 0xA487, 0x8227 },
	{ 0xA488, 0x8229 },
	{ 0xA489, 0x831F },
	{ 0xA48A, 0x8357 },
	{ 0xA48B, 0x8321 },
	{ 0xA48C, 0x8318 },
	{ 0xA48D, 0x8358 },
	{ 0xA48E, 0x8684 },
	{ 0xA48F, 0x869F },
	{ 0xA490, 0x869B },
	{ 0xA491, 0x8689 },
	{ 0xA492, 0x86A6 },
	{ 0xA493, 0x8692 },
	{ 0xA494, 0x868F },
	{ 0xA495, 0x86A0 },
	{ 0xA496, 0x884F },
	{ 0xA497, 0x8878 },
	{ 0xA498, 0x887A },
	{ 0xA499, 0x886E },
	{ 0xA49A, 0x887B },
	{ 0xA49B, 0x8884 },
	{ 0xA49C, 0x8873 },
	{ 0xA49D, 0x8A0D },
	{ 0xA49E, 0x8A0B },
	{ 0xA49F, 0x8A19 },
	{ 0xA4A0, 0x8ED0 },
	{ 0xA4A1, 0x4E11 },
	{ 0xA4A2, 0x4E10 },
	{ 0xA4A3, 0x4E0D },
	{ 0xA4A4, 0x4E2D },
	{ 0xA4A5, 0x4E30 },
	{ 0xA4A6, 0x4E39 },
	{ 0xA4A7, 0x4E4B },
	{ 0xA4A8, 0x5C39 },
	{ 0xA4A9, 0x4E88 },
	{ 0xA4AA, 0x4E91 },
	{ 0xA4AB, 0x4E95 },
	{ 0xA4AC, 0x4E92 },
	{ 0xA4AD, 0x4E94 },
	{ 0xA4AE, 0x4EA2 },
	{ 0xA4AF, 0x4EC1 },
	{ 0xA4B0, 0x4EC0 },
	{ 0xA4B1, 0x4EC3 },
	{ 0xA4B2, 0x4EC6 },
	{ 0xA4B3, 0x4EC7 },
	{ 0xA4B4, 0x4ECD },
	{ 0xA4B5, 0x4ECA },
	{ 0xA4B6, 0x4ECB },
	{ 0xA4B7, 0x4EC4 },
	{ 0xA4B8, 0x5143 },
	{ 0xA4B9, 0x5141 },
	{ 0xA4BA, 0x5167 },
	{ 0xA4BB, 0x516D },
	{ 0xA4BC, 0x516E },
	{ 0xA4BD, 0x516C },
	{ 0xA4BE, 0x5197 },
	{ 0xA4BF, 0x51F6 },
	{ 0xA4C0, 0x5206 },
	{ 0xA4C1, 0x5207 },
	{ 0xA4C2, 0x5208 },
	{ 0xA4C3, 0x52FB },
	{ 0xA4C4, 0x52FE },
	{ 0xA4C5, 0x52FF },
	{ 0xA4C6, 0x5316 },
	{ 0xA4C7, 0x5339 },
	{ 0xA4C8, 0x5348 },
	{ 0xA4C9, 0x5347 },
	{ 0xA4CA, 0x5345 },
	{ 0xA4CB, 0x535E },
	{ 0xA4CC, 0x5384 },
	{ 0xA4CD, 0x53CB },
	{ 0xA4CE, 0x53CA },
	{ 0xA4CF, 0x53CD },
	{ 0xA4D0, 0x58EC },
	{ 0xA4D1, 0x5929 },
	{ 0xA4D2, 0x592B },
	{ 0xA4D3, 0x592A },
	{ 0xA4D4, 0x592D },
	{ 0xA4D5, 0x5B54 },
	{ 0xA4D6, 0x5C11 },
	{ 0xA4D7, 0x5C24 },
	{ 0xA4D8, 0x5C3A },
	{ 0xA4D9, 0x5C6F },
	{ 0xA4DA, 0x5DF4 },
	{ 0xA4DB, 0x5E7B },
	{ 0xA4DC, 0x5EFF },
	{ 0xA4DD, 0x5F14 },
	{ 0xA4DE, 0x5F15 },
	{ 0xA4DF, 0x5FC3 },
	{ 0xA4E0, 0x6208 },
	{ 0xA4E1, 0x6236 },
	{ 0xA4E2, 0x624B },
	{ 0xA4E3, 0x624E },
	{ 0xA4E4, 0x652F },
	{ 0xA4E5, 0x6587 },
	{ 0xA4E6, 0x6597 },
	{ 0xA4E7, 0x65A4 },
	{ 0xA4E8, 0x65B9 },
	{ 0xA4E9, 0x65E5 },
	{ 0xA4EA, 0x66F0 },
	{ 0xA4EB, 0x6708 },
	{ 0xA4EC, 0x6728 },
	{ 0xA4ED, 0x6B20 },
	{ 0xA4EE, 0x6B62 },
	{ 0xA4EF, 0x6B79 },
	{ 0xA4F0, 0x6BCB },
	{ 0xA4F1, 0x6BD4 },
	{ 0xA4F2, 0x6BDB },
	{ 0xA4F3, 0x6C0F },
	{ 0xA4F4, 0x6C34 },
	{ 0xA4F5, 0x706B },
	{ 0xA4F6, 0x722A },
	{ 0xA4F7, 0x7236 },
	{ 0xA4F8, 0x723B },
	{ 0xA4F9, 0x7247 },
	{ 0xA4FA, 0x7259 },
	{ 0xA4FB, 0x725B },
	{ 0xA4FC, 0x72AC },
	{ 0xA4FD, 0x738B },
	{ 0xA4FE, 0x4E19 },
	{ 0xA540, 0x4E16 },
	{ 0xA541, 0x4E15 },
	{ 0xA542, 0x4E14 },
	{ 0xA543, 0x4E18 },
	{ 0xA544, 0x4E3B },
	{ 0xA545, 0x4E4D },
	{ 0xA546, 0x4E4F },
	{ 0xA547, 0x4E4E },
	{ 0xA548, 0x4EE5 },
	{ 0xA549, 0x4ED8 },
	{ 0xA54A, 0x4ED4 },
	{ 0xA54B, 0x4ED5 },
	{ 0xA54C, 0x4ED6 },
	{ 0xA54D, 0x4ED7 },
	{ 0xA54E, 0x4EE3 },
	{ 0xA54F, 0x4EE4 },
	{ 0xA550, 0x4ED9 },
	{ 0xA551, 0x4EDE },
	{ 0xA552, 0x5145 },
	{ 0xA553, 0x5144 },
	{ 0xA554, 0x5189 },
	{ 0xA555, 0x518A },
	{ 0xA556, 0x51AC },
	{ 0xA557, 0x51F9 },
	{ 0xA558, 0x51FA },
	{ 0xA559, 0x51F8 },
	{ 0xA55A, 0x520A },
	{ 0xA55B, 0x52A0 },
	{ 0xA55C, 0x529F },
	{ 0xA55D, 0x5305 },
	{ 0xA55E, 0x5306 },
	{ 0xA55F, 0x5317 },
	{ 0xA560, 0x531D },
	{ 0xA561, 0x4EDF },
	{ 0xA562, 0x534A },
	{ 0xA563, 0x5349 },
	{ 0xA564, 0x5361 },
	{ 0xA565, 0x5360 },
	{ 0xA566, 0x536F },
	{ 0xA567, 0x536E },
	{ 0xA568, 0x53BB },
	{ 0xA569, 0x53EF },
	{ 0xA56A, 0x53E4 },
	{ 0xA56B, 0x53F3 },
	{ 0xA56C, 0x53EC },
	{ 0xA56D, 0x53EE },
	{ 0xA56E, 0x53E9 },
	{ 0xA56F, 0x53E8 },
	{ 0xA570, 0x53FC },
	{ 0xA571, 0x53F8 },
	{ 0xA572, 0x53F5 },
	{ 0xA573, 0x53EB },
	{ 0xA574, 0x53E6 },
	{ 0xA575, 0x53EA },
	{ 0xA576, 0x53F2 },
	{ 0xA577, 0x53F1 },
	{ 0xA578, 0x53F0 },
	{ 0xA579, 0x53E5 },
	{ 0xA57A, 0x53ED },
	{ 0xA57B, 0x53FB },
	{ 0xA57C, 0x56DB },
	{ 0xA57D, 0x56DA },
	{ 0xA57E, 0x5916 },
	{ 0xA57F, 0xFFFD },
	{ 0xA580, 0x8FF9 },
	{ 0xA581, 0x9009 },
	{ 0xA582, 0x9008 },
	{ 0xA583, 0x90DE },
	{ 0xA584, 0x9151 },
	{ 0xA585, 0x91DB },
	{ 0xA586, 0x91DF },
	{ 0xA587, 0x91DE },
	{ 0xA588, 0x91D6 },
	{ 0xA589, 0x91E0 },
	{ 0xA58A, 0x9585 },
	{ 0xA58B, 0x9660 },
	{ 0xA58C, 0x9659 },
	{ 0xA58D, 0x9656 },
	{ 0xA58E, 0x96BD },
	{ 0xA58F, 0x5042 },
	{ 0xA590, 0x5059 },
	{ 0xA591, 0x5044 },
	{ 0xA592, 0x5066 },
	{ 0xA593, 0x5052 },
	{ 0xA594, 0x5054 },
	{ 0xA595, 0x5071 },
	{ 0xA596, 0x5050 },
	{ 0xA597, 0x507B },
	{ 0xA598, 0x507C },
	{ 0xA599, 0x5058 },
	{ 0xA59A, 0x5079 },
	{ 0xA59B, 0x506C },
	{ 0xA59C, 0x5078 },
	{ 0xA59D, 0x51A8 },
	{ 0xA59E, 0x51D1 },
	{ 0xA59F, 0x51CF },
	{ 0xA5A0, 0x5268 },
	{ 0xA5A1, 0x592E },
	{ 0xA5A2, 0x5931 },
	{ 0xA5A3, 0x5974 },
	{ 0xA5A4, 0x5976 },
	{ 0xA5A5, 0x5B55 },
	{ 0xA5A6, 0x5B83 },
	{ 0xA5A7, 0x5C3C },
	{ 0xA5A8, 0x5DE8 },
	{ 0xA5A9, 0x5DE7 },
	{ 0xA5AA, 0x5DE6 },
	{ 0xA5AB, 0x5E02 },
	{ 0xA5AC, 0x5E03 },
	{ 0xA5AD, 0x5E73 },
	{ 0xA5AE, 0x5E7C },
	{ 0xA5AF, 0x5F01 },
	{ 0xA5B0, 0x5F18 },
	{ 0xA5B1, 0x5F17 },
	{ 0xA5B2, 0x5FC5 },
	{ 0xA5B3, 0x620A },
	{ 0xA5B4, 0x6253 },
	{ 0xA5B5, 0x6254 },
	{ 0xA5B6, 0x6252 },
	{ 0xA5B7, 0x6251 },
	{ 0xA5B8, 0x65A5 },
	{ 0xA5B9, 0x65E6 },
	{ 0xA5BA, 0x672E },
	{ 0xA5BB, 0x672C },
	{ 0xA5BC, 0x672A },
	{ 0xA5BD, 0x672B },
	{ 0xA5BE, 0x672D },
	{ 0xA5BF, 0x6B63 },
	{ 0xA5C0, 0x6BCD },
	{ 0xA5C1, 0x6C11 },
	{ 0xA5C2, 0x6C10 },
	{ 0xA5C3, 0x6C38 },
	{ 0xA5C4, 0x6C41 },
	{ 0xA5C5, 0x6C40 },
	{ 0xA5C6, 0x6C3E },
	{ 0xA5C7, 0x72AF },
	{ 0xA5C8, 0x7384 },
	{ 0xA5C9, 0x7389 },
	{ 0xA5CA, 0x74DC },
	{ 0xA5CB, 0x74E6 },
	{ 0xA5CC, 0x7518 },
	{ 0xA5CD, 0x751F },
	{ 0xA5CE, 0x7528 },
	{ 0xA5CF, 0x7529 },
	{ 0xA5D0, 0x7530 },
	{ 0xA5D1, 0x7531 },
	{ 0xA5D2, 0x7532 },
	{ 0xA5D3, 0x7533 },
	{ 0xA5D4, 0x758B },
	{ 0xA5D5, 0x767D },
	{ 0xA5D6, 0x76AE },
	{ 0xA5D7, 0x76BF },
	{ 0xA5D8, 0x76EE },
	{ 0xA5D9, 0x77DB },
	{ 0xA5DA, 0x77E2 },
	{ 0xA5DB, 0x77F3 },
	{ 0xA5DC, 0x793A },
	{ 0xA5DD, 0x79BE },
	{ 0xA5DE, 0x7A74 },
	{ 0xA5DF, 0x7ACB },
	{ 0xA5E0, 0x4E1E },
	{ 0xA5E1, 0x4E1F },
	{ 0xA5E2, 0x4E52 },
	{ 0xA5E3, 0x4E53 },
	{ 0xA5E4, 0x4E69 },
	{ 0xA5E5, 0x4E99 },
	{ 0xA5E6, 0x4EA4 },
	{ 0xA5E7, 0x4EA6 },
	{ 0xA5E8, 0x4EA5 },
	{ 0xA5E9, 0x4EFF },
	{ 0xA5EA, 0x4F09 },
	{ 0xA5EB, 0x4F19 },
	{ 0xA5EC, 0x4F0A },
	{ 0xA5ED, 0x4F15 },
	{ 0xA5EE, 0x4F0D },
	{ 0xA5EF, 0x4F10 },
	{ 0xA5F0, 0x4F11 },
	{ 0xA5F1, 0x4F0F },
	{ 0xA5F2, 0x4EF2 },
	{ 0xA5F3, 0x4EF6 },
	{ 0xA5F4, 0x4EFB },
	{ 0xA5F5, 0x4EF0 },
	{ 0xA5F6, 0x4EF3 },
	{ 0xA5F7, 0x4EFD },
	{ 0xA5F8, 0x4F01 },
	{ 0xA5F9, 0x4F0B },
	{ 0xA5FA, 0x5149 },
	{ 0xA5FB, 0x5147 },
	{ 0xA5FC, 0x5146 },
	{ 0xA5FD, 0x5148 },
	{ 0xA5FE, 0x5168 },
	{ 0xA640, 0x5171 },
	{ 0xA641, 0x518D },
	{ 0xA642, 0x51B0 },
	{ 0xA643, 0x5217 },
	{ 0xA644, 0x5211 },
	{ 0xA645, 0x5212 },
	{ 0xA646, 0x520E },
	{ 0xA647, 0x5216 },
	{ 0xA648, 0x52A3 },
	{ 0xA649, 0x5308 },
	{ 0xA64A, 0x5321 },
	{ 0xA64B, 0x5320 },
	{ 0xA64C, 0x5370 },
	{ 0xA64D, 0x5371 },
	{ 0xA64E, 0x5409 },
	{ 0xA64F, 0x540F },
	{ 0xA650, 0x540C },
	{ 0xA651, 0x540A },
	{ 0xA652, 0x5410 },
	{ 0xA653, 0x5401 },
	{ 0xA654, 0x540B },
	{ 0xA655, 0x5404 },
	{ 0xA656, 0x5411 },
	{ 0xA657, 0x540D },
	{ 0xA658, 0x5408 },
	{ 0xA659, 0x5403 },
	{ 0xA65A, 0x540E },
	{ 0xA65B, 0x5406 },
	{ 0xA65C, 0x5412 },
	{ 0xA65D, 0x56E0 },
	{ 0xA65E, 0x56DE },
	{ 0xA65F, 0x56DD },
	{ 0xA660, 0x5733 },
	{ 0xA661, 0x5730 },
	{ 0xA662, 0x5728 },
	{ 0xA663, 0x572D },
	{ 0xA664, 0x572C },
	{ 0xA665, 0x572F },
	{ 0xA666, 0x5729 },
	{ 0xA667, 0x5919 },
	{ 0xA668, 0x591A },
	{ 0xA669, 0x5937 },
	{ 0xA66A, 0x5938 },
	{ 0xA66B, 0x5984 },
	{ 0xA66C, 0x5978 },
	{ 0xA66D, 0x5983 },
	{ 0xA66E, 0x597D },
	{ 0xA66F, 0x5979 },
	{ 0xA670, 0x5982 },
	{ 0xA671, 0x5981 },
	{ 0xA672, 0x5B57 },
	{ 0xA673, 0x5B58 },
	{ 0xA674, 0x5B87 },
	{ 0xA675, 0x5B88 },
	{ 0xA676, 0x5B85 },
	{ 0xA677, 0x5B89 },
	{ 0xA678, 0x5BFA },
	{ 0xA679, 0x5C16 },
	{ 0xA67A, 0x5C79 },
	{ 0xA67B, 0x5DDE },
	{ 0xA67C, 0x5E06 },
	{ 0xA67D, 0x5E76 },
	{ 0xA67E, 0x5E74 },
	{ 0xA67F, 0xFFFD },
	{ 0xA680, 0x5276 },
	{ 0xA681, 0x52D4 },
	{ 0xA682, 0x53A0 },
	{ 0xA683, 0x53C4 },
	{ 0xA684, 0x5558 },
	{ 0xA685, 0x554C },
	{ 0xA686, 0x5568 },
	{ 0xA687, 0x5549 },
	{ 0xA688, 0x555D },
	{ 0xA689, 0x5529 },
	{ 0xA68A, 0x5554 },
	{ 0xA68B, 0x5553 },
	{ 0xA68C, 0x555A },
	{ 0xA68D, 0x553A },
	{ 0xA68E, 0x553F },
	{ 0xA68F, 0x552B },
	{ 0xA690, 0x57EA },
	{ 0xA691, 0x57EF },
	{ 0xA692, 0x57DD },
	{ 0xA693, 0x57FE },
	{ 0xA694, 0x57DE },
	{ 0xA695, 0x57E6 },
	{ 0xA696, 0x57E8 },
	{ 0xA697, 0x57FF },
	{ 0xA698, 0x5803 },
	{ 0xA699, 0x58F7 },
	{ 0xA69A, 0x68A6 },
	{ 0xA69B, 0x591F },
	{ 0xA69C, 0x595B },
	{ 0xA69D, 0x595D },
	{ 0xA69E, 0x595E },
	{ 0xA69F, 0x5A2B },
	{ 0xA6A0, 0x5A3B },
	{ 0xA6A1, 0x5F0F },
	{ 0xA6A2, 0x5F1B },
	{ 0xA6A3, 0x5FD9 },
	{ 0xA6A4, 0x5FD6 },
	{ 0xA6A5, 0x620E },
	{ 0xA6A6, 0x620C },
	{ 0xA6A7, 0x620D },
	{ 0xA6A8, 0x6210 },
	{ 0xA6A9, 0x6263 },
	{ 0xA6AA, 0x625B },
	{ 0xA6AB, 0x6258 },
	{ 0xA6AC, 0x6536 },
	{ 0xA6AD, 0x65E9 },
	{ 0xA6AE, 0x65E8 },
	{ 0xA6AF, 0x65EC },
	{ 0xA6B0, 0x65ED },
	{ 0xA6B1, 0x66F2 },
	{ 0xA6B2, 0x66F3 },
	{ 0xA6B3, 0x6709 },
	{ 0xA6B4, 0x673D },
	{ 0xA6B5, 0x6734 },
	{ 0xA6B6, 0x6731 },
	{ 0xA6B7, 0x6735 },
	{ 0xA6B8, 0x6B21 },
	{ 0xA6B9, 0x6B64 },
	{ 0xA6BA, 0x6B7B },
	{ 0xA6BB, 0x6C16 },
	{ 0xA6BC, 0x6C5D },
	{ 0xA6BD, 0x6C57 },
	{ 0xA6BE, 0x6C59 },
	{ 0xA6BF, 0x6C5F },
	{ 0xA6C0, 0x6C60 },
	{ 0xA6C1, 0x6C50 },
	{ 0xA6C2, 0x6C55 },
	{ 0xA6C3, 0x6C61 },
	{ 0xA6C4, 0x6C5B },
	{ 0xA6C5, 0x6C4D },
	{ 0xA6C6, 0x6C4E },
	{ 0xA6C7, 0x7070 },
	{ 0xA6C8, 0x725F },
	{ 0xA6C9, 0x725D },
	{ 0xA6CA, 0x767E },
	{ 0xA6CB, 0x7AF9 },
	{ 0xA6CC, 0x7C73 },
	{ 0xA6CD, 0x7CF8 },
	{ 0xA6CE, 0x7F36 },
	{ 0xA6CF, 0x7F8A },
	{ 0xA6D0, 0x7FBD },
	{ 0xA6D1, 0x8001 },
	{ 0xA6D2, 0x8003 },
	{ 0xA6D3, 0x800C },
	{ 0xA6D4, 0x8012 },
	{ 0xA6D5, 0x8033 },
	{ 0xA6D6, 0x807F },
	{ 0xA6D7, 0x8089 },
	{ 0xA6D8, 0x808B },
	{ 0xA6D9, 0x808C },
	{ 0xA6DA, 0x81E3 },
	{ 0xA6DB, 0x81EA },
	{ 0xA6DC, 0x81F3 },
	{ 0xA6DD, 0x81FC },
	{ 0xA6DE, 0x820C },
	{ 0xA6DF, 0x821B },
	{ 0xA6E0, 0x821F },
	{ 0xA6E1, 0x826E },
	{ 0xA6E2, 0x8272 },
	{ 0xA6E3, 0x827E },
	{ 0xA6E4, 0x866B },
	{ 0xA6E5, 0x8840 },
	{ 0xA6E6, 0x884C },
	{ 0xA6E7, 0x8863 },
	{ 0xA6E8, 0x897F },
	{ 0xA6E9, 0x9621 },
	{ 0xA6EA, 0x4E32 },
	{ 0xA6EB, 0x4EA8 },
	{ 0xA6EC, 0x4F4D },
	{ 0xA6ED, 0x4F4F },
	{ 0xA6EE, 0x4F47 },
	{ 0xA6EF, 0x4F57 },
	{ 0xA6F0, 0x4F5E },
	{ 0xA6F1, 0x4F34 },
	{ 0xA6F2, 0x4F5B },
	{ 0xA6F3, 0x4F55 },
	{ 0xA6F4, 0x4F30 },
	{ 0xA6F5, 0x4F50 },
	{ 0xA6F6, 0x4F51 },
	{ 0xA6F7, 0x4F3D },
	{ 0xA6F8, 0x4F3A },
	{ 0xA6F9, 0x4F38 },
	{ 0xA6FA, 0x4F43 },
	{ 0xA6FB, 0x4F54 },
	{ 0xA6FC, 0x4F3C },
	{ 0xA6FD, 0x4F46 },
	{ 0xA6FE, 0x4F63 },
	{ 0xA740, 0x4F5C },
	{ 0xA741, 0x4F60 },
	{ 0xA742, 0x4F2F },
	{ 0xA743, 0x4F4E },
	{ 0xA744, 0x4F36 },
	{ 0xA745, 0x4F59 },
	{ 0xA746, 0x4F5D },
	{ 0xA747, 0x4F48 },
	{ 0xA748, 0x4F5A },
	{ 0xA749, 0x514C },
	{ 0xA74A, 0x514B },
	{ 0xA74B, 0x514D },
	{ 0xA74C, 0x5175 },
	{ 0xA74D, 0x51B6 },
	{ 0xA74E, 0x51B7 },
	{ 0xA74F, 0x5225 },
	{ 0xA750, 0x5224 },
	{ 0xA751, 0x5229 },
	{ 0xA752, 0x522A },
	{ 0xA753, 0x5228 },
	{ 0xA754, 0x52AB },
	{ 0xA755, 0x52A9 },
	{ 0xA756, 0x52AA },
	{ 0xA757, 0x52AC },
	{ 0xA758, 0x5323 },
	{ 0xA759, 0x5373 },
	{ 0xA75A, 0x5375 },
	{ 0xA75B, 0x541D },
	{ 0xA75C, 0x542D },
	{ 0xA75D, 0x541E },
	{ 0xA75E, 0x543E },
	{ 0xA75F, 0x5426 },
	{ 0xA760, 0x544E },
	{ 0xA761, 0x5427 },
	{ 0xA762, 0x5446 },
	{ 0xA763, 0x5443 },
	{ 0xA764, 0x5433 },
	{ 0xA765, 0x5448 },
	{ 0xA766, 0x5442 },
	{ 0xA767, 0x541B },
	{ 0xA768, 0x5429 },
	{ 0xA769, 0x544A },
	{ 0xA76A, 0x5439 },
	{ 0xA76B, 0x543B },
	{ 0xA76C, 0x5438 },
	{ 0xA76D, 0x542E },
	{ 0xA76E, 0x5435 },
	{ 0xA76F, 0x5436 },
	{ 0xA770, 0x5420 },
	{ 0xA771, 0x543C },
	{ 0xA772, 0x5440 },
	{ 0xA773, 0x5431 },
	{ 0xA774, 0x542B },
	{ 0xA775, 0x541F },
	{ 0xA776, 0x542C },
	{ 0xA777, 0x56EA },
	{ 0xA778, 0x56F0 },
	{ 0xA779, 0x56E4 },
	{ 0xA77A, 0x56EB },
	{ 0xA77B, 0x574A },
	{ 0xA77C, 0x5751 },
	{ 0xA77D, 0x5740 },
	{ 0xA77E, 0x574D },
	{ 0xA77F, 0xFFFD },
	{ 0xA780, 0x5A61 },
	{ 0xA781, 0x5A3A },
	{ 0xA782, 0x5A6E },
	{ 0xA783, 0x5A4B },
	{ 0xA784, 0x5A6B },
	{ 0xA785, 0x5A45 },
	{ 0xA786, 0x5A4E },
	{ 0xA787, 0x5A68 },
	{ 0xA788, 0x5A3D },
	{ 0xA789, 0x5A71 },
	{ 0xA78A, 0x5A3F },
	{ 0xA78B, 0x5A6F },
	{ 0xA78C, 0x5A75 },
	{ 0xA78D, 0x5A73 },
	{ 0xA78E, 0x5A2C },
	{ 0xA78F, 0x5A59 },
	{ 0xA790, 0x5A54 },
	{ 0xA791, 0x5A4F },
	{ 0xA792, 0x5A63 },
	{ 0xA793, 0x5BC8 },
	{ 0xA794, 0x5BC3 },
	{ 0xA795, 0x5C5B },
	{ 0xA796, 0x5C61 },
	{ 0xA797, 0x5D21 },
	{ 0xA798, 0x5D0A },
	{ 0xA799, 0x5D09 },
	{ 0xA79A, 0x5D2C },
	{ 0xA79B, 0x5D08 },
	{ 0xA79C, 0x5D2A },
	{ 0xA79D, 0x5D15 },
	{ 0xA79E, 0x5D10 },
	{ 0xA79F, 0x5D13 },
	{ 0xA7A0, 0x5D2F },
	{ 0xA7A1, 0x5747 },
	{ 0xA7A2, 0x574E },
	{ 0xA7A3, 0x573E },
	{ 0xA7A4, 0x5750 },
	{ 0xA7A5, 0x574F },
	{ 0xA7A6, 0x573B },
	{ 0xA7A7, 0x58EF },
	{ 0xA7A8, 0x593E },
	{ 0xA7A9, 0x599D },
	{ 0xA7AA, 0x5992 },
	{ 0xA7AB, 0x59A8 },
	{ 0xA7AC, 0x599E },
	{ 0xA7AD, 0x59A3 },
	{ 0xA7AE, 0x5999 },
	{ 0xA7AF, 0x5996 },
	{ 0xA7B0, 0x598D },
	{ 0xA7B1, 0x59A4 },
	{ 0xA7B2, 0x5993 },
	{ 0xA7B3, 0x598A },
	{ 0xA7B4, 0x59A5 },
	{ 0xA7B5, 0x5B5D },
	{ 0xA7B6, 0x5B5C },
	{ 0xA7B7, 0x5B5A },
	{ 0xA7B8, 0x5B5B },
	{ 0xA7B9, 0x5B8C },
	{ 0xA7BA, 0x5B8B },
	{ 0xA7BB, 0x5B8F },
	{ 0xA7BC, 0x5C2C },
	{ 0xA7BD, 0x5C40 },
	{ 0xA7BE, 0x5C41 },
	{ 0xA7BF, 0x5C3F },
	{ 0xA7C0, 0x5C3E },
	{ 0xA7C1, 0x5C90 },
	{ 0xA7C2, 0x5C91 },
	{ 0xA7C3, 0x5C94 },
	{ 0xA7C4, 0x5C8C },
	{ 0xA7C5, 0x5DEB },
	{ 0xA7C6, 0x5E0C },
	{ 0xA7C7, 0x5E8F },
	{ 0xA7C8, 0x5E87 },
	{ 0xA7C9, 0x5E8A },
	{ 0xA7CA, 0x5EF7 },
	{ 0xA7CB, 0x5F04 },
	{ 0xA7CC, 0x5F1F },
	{ 0xA7CD, 0x5F64 },
	{ 0xA7CE, 0x5F62 },
	{ 0xA7CF, 0x5F77 },
	{ 0xA7D0, 0x5F79 },
	{ 0xA7D1, 0x5FD8 },
	{ 0xA7D2, 0x5FCC },
	{ 0xA7D3, 0x5FD7 },
	{ 0xA7D4, 0x5FCD },
	{ 0xA7D5, 0x5FF1 },
	{ 0xA7D6, 0x5FEB },
	{ 0xA7D7, 0x5FF8 },
	{ 0xA7D8, 0x5FEA },
	{ 0xA7D9, 0x6212 },
	{ 0xA7DA, 0x6211 },
	{ 0xA7DB, 0x6284 },
	{ 0xA7DC, 0x6297 },
	{ 0xA7DD, 0x6296 },
	{ 0xA7DE, 0x6280 },
	{ 0xA7DF, 0x6276 },
	{ 0xA7E0, 0x6289 },
	{ 0xA7E1, 0x626D },
	{ 0xA7E2, 0x628A },
	{ 0xA7E3, 0x627C },
	{ 0xA7E4, 0x627E },
	{ 0xA7E5, 0x6279 },
	{ 0xA7E6, 0x6273 },
	{ 0xA7E7, 0x6292 },
	{ 0xA7E8, 0x626F },
	{ 0xA7E9, 0x6298 },
	{ 0xA7EA, 0x626E },
	{ 0xA7EB, 0x6295 },
	{ 0xA7EC, 0x6293 },
	{ 0xA7ED, 0x6291 },
	{ 0xA7EE, 0x6286 },
	{ 0xA7EF, 0x6539 },
	{ 0xA7F0, 0x653B },
	{ 0xA7F1, 0x6538 },
	{ 0xA7F2, 0x65F1 },
	{ 0xA7F3, 0x66F4 },
	{ 0xA7F4, 0x675F },
	{ 0xA7F5, 0x674E },
	{ 0xA7F6, 0x674F },
	{ 0xA7F7, 0x6750 },
	{ 0xA7F8, 0x6751 },
	{ 0xA7F9, 0x675C },
	{ 0xA7FA, 0x6756 },
	{ 0xA7FB, 0x675E },
	{ 0xA7FC, 0x6749 },
	{ 0xA7FD, 0x6746 },
	{ 0xA7FE, 0x6760 },
	{ 0xA840, 0x6753 },
	{ 0xA841, 0x6757 },
	{ 0xA842, 0x6B65 },
	{ 0xA843, 0x6BCF },
	{ 0xA844, 0x6C42 },
	{ 0xA845, 0x6C5E },
	{ 0xA846, 0x6C99 },
	{ 0xA847, 0x6C81 },
	{ 0xA848, 0x6C88 },
	{ 0xA849, 0x6C89 },
	{ 0xA84A, 0x6C85 },
	{ 0xA84B, 0x6C9B },
	{ 0xA84C, 0x6C6A },
	{ 0xA84D, 0x6C7A },
	{ 0xA84E, 0x6C90 },
	{ 0xA84F, 0x6C70 },
	{ 0xA850, 0x6C8C },
	{ 0xA851, 0x6C68 },
	{ 0xA852, 0x6C96 },
	{ 0xA853, 0x6C92 },
	{ 0xA854, 0x6C7D },
	{ 0xA855, 0x6C83 },
	{ 0xA856, 0x6C72 },
	{ 0xA857, 0x6C7E },
	{ 0xA858, 0x6C74 },
	{ 0xA859, 0x6C86 },
	{ 0xA85A, 0x6C76 },
	{ 0xA85B, 0x6C8D },
	{ 0xA85C, 0x6C94 },
	{ 0xA85D, 0x6C98 },
	{ 0xA85E, 0x6C82 },
	{ 0xA85F, 0x7076 },
	{ 0xA860, 0x707C },
	{ 0xA861, 0x707D },
	{ 0xA862, 0x7078 },
	{ 0xA863, 0x7262 },
	{ 0xA864, 0x7261 },
	{ 0xA865, 0x7260 },
	{ 0xA866, 0x72C4 },
	{ 0xA867, 0x72C2 },
	{ 0xA868, 0x7396 },
	{ 0xA869, 0x752C },
	{ 0xA86A, 0x752B },
	{ 0xA86B, 0x7537 },
	{ 0xA86C, 0x7538 },
	{ 0xA86D, 0x7682 },
	{ 0xA86E, 0x76EF },
	{ 0xA86F, 0x77E3 },
	{ 0xA870, 0x79C1 },
	{ 0xA871, 0x79C0 },
	{ 0xA872, 0x79BF },
	{ 0xA873, 0x7A76 },
	{ 0xA874, 0x7CFB },
	{ 0xA875, 0x7F55 },
	{ 0xA876, 0x8096 },
	{ 0xA877, 0x8093 },
	{ 0xA878, 0x809D },
	{ 0xA879, 0x8098 },
	{ 0xA87A, 0x809B },
	{ 0xA87B, 0x809A },
	{ 0xA87C, 0x80B2 },
	{ 0xA87D, 0x826F },
	{ 0xA87E, 0x8292 },
	{ 0xA87F, 0xFFFD },
	{ 0xA880, 0x5D18 },
	{ 0xA881, 0x5DE3 },
	{ 0xA882, 0x5E39 },
	{ 0xA883, 0x5E35 },
	{ 0xA884, 0x5E3A },
	{ 0xA885, 0x5E32 },
	{ 0xA886, 0x5EBB },
	{ 0xA887, 0x5EBA },
	{ 0xA888, 0x5F34 },
	{ 0xA889, 0x5F39 },
	{ 0xA88A, 0x6098 },
	{ 0xA88B, 0x60D0 },
	{ 0xA88C, 0x60D7 },
	{ 0xA88D, 0x60AA },
	{ 0xA88E, 0x60A1 },
	{ 0xA88F, 0x60A4 },
	{ 0xA890, 0x60EE },
	{ 0xA891, 0x60E7 },
	{ 0xA892, 0x60E8 },
	{ 0xA893, 0x60DE },
	{ 0xA894, 0x637E },
	{ 0xA895, 0x638B },
	{ 0xA896, 0x6379 },
	{ 0xA897, 0x6386 },
	{ 0xA898, 0x6393 },
	{ 0xA899, 0x6373 },
	{ 0xA89A, 0x636A },
	{ 0xA89B, 0x636C },
	{ 0xA89C, 0x637F },
	{ 0xA89D, 0x63B2 },
	{ 0xA89E, 0x63BA },
	{ 0xA89F, 0x6366 },
	{ 0xA8A0, 0x6374 },
	{ 0xA8A1, 0x828B },
	{ 0xA8A2, 0x828D },
	{ 0xA8A3, 0x898B },
	{ 0xA8A4, 0x89D2 },
	{ 0xA8A5, 0x8A00 },
	{ 0xA8A6, 0x8C37 },
	{ 0xA8A7, 0x8C46 },
	{ 0xA8A8, 0x8C55 },
	{ 0xA8A9, 0x8C9D },
	{ 0xA8AA, 0x8D64 },
	{ 0xA8AB, 0x8D70 },
	{ 0xA8AC, 0x8DB3 },
	{ 0xA8AD, 0x8EAB },
	{ 0xA8AE, 0x8ECA },
	{ 0xA8AF, 0x8F9B },
	{ 0xA8B0, 0x8FB0 },
	{ 0xA8B1, 0x8FC2 },
	{ 0xA8B2, 0x8FC6 },
	{ 0xA8B3, 0x8FC5 },
	{ 0xA8B4, 0x8FC4 },
	{ 0xA8B5, 0x5DE1 },
	{ 0xA8B6, 0x9091 },
	{ 0xA8B7, 0x90A2 },
	{ 0xA8B8, 0x90AA },
	{ 0xA8B9, 0x90A6 },
	{ 0xA8BA, 0x90A3 },
	{ 0xA8BB, 0x9149 },
	{ 0xA8BC, 0x91C6 },
	{ 0xA8BD, 0x91CC },
	{ 0xA8BE, 0x9632 },
	{ 0xA8BF, 0x962E },
	{ 0xA8C0, 0x9631 },
	{ 0xA8C1, 0x962A },
	{ 0xA8C2, 0x962C },
	{ 0xA8C3, 0x4E26 },
	{ 0xA8C4, 0x4E56 },
	{ 0xA8C5, 0x4E73 },
	{ 0xA8C6, 0x4E8B },
	{ 0xA8C7, 0x4E9B },
	{ 0xA8C8, 0x4E9E },
	{ 0xA8C9, 0x4EAB },
	{ 0xA8CA, 0x4EAC },
	{ 0xA8CB, 0x4F6F },
	{ 0xA8CC, 0x4F9D },
	{ 0xA8CD, 0x4F8D },
	{ 0xA8CE, 0x4F73 },
	{ 0xA8CF, 0x4F7F },
	{ 0xA8D0, 0x4F6C },
	{ 0xA8D1, 0x4F9B },
	{ 0xA8D2, 0x4F8B },
	{ 0xA8D3, 0x4F86 },
	{ 0xA8D4, 0x4F83 },
	{ 0xA8D5, 0x4F70 },
	{ 0xA8D6, 0x4F75 },
	{ 0xA8D7, 0x4F88 },
	{ 0xA8D8, 0x4F69 },
	{ 0xA8D9, 0x4F7B },
	{ 0xA8DA, 0x4F96 },
	{ 0xA8DB, 0x4F7E },
	{ 0xA8DC, 0x4F8F },
	{ 0xA8DD, 0x4F91 },
	{ 0xA8DE, 0x4F7A },
	{ 0xA8DF, 0x5154 },
	{ 0xA8E0, 0x5152 },
	{ 0xA8E1, 0x5155 },
	{ 0xA8E2, 0x5169 },
	{ 0xA8E3, 0x5177 },
	{ 0xA8E4, 0x5176 },
	{ 0xA8E5, 0x5178 },
	{ 0xA8E6, 0x51BD },
	{ 0xA8E7, 0x51FD },
	{ 0xA8E8, 0x523B },
	{ 0xA8E9, 0x5238 },
	{ 0xA8EA, 0x5237 },
	{ 0xA8EB, 0x523A },
	{ 0xA8EC, 0x5230 },
	{ 0xA8ED, 0x522E },
	{ 0xA8EE, 0x5236 },
	{ 0xA8EF, 0x5241 },
	{ 0xA8F0, 0x52BE },
	{ 0xA8F1, 0x52BB },
	{ 0xA8F2, 0x5352 },
	{ 0xA8F3, 0x5354 },
	{ 0xA8F4, 0x5353 },
	{ 0xA8F5, 0x5351 },
	{ 0xA8F6, 0x5366 },
	{ 0xA8F7, 0x5377 },
	{ 0xA8F8, 0x5378 },
	{ 0xA8F9, 0x5379 },
	{ 0xA8FA, 0x53D6 },
	{ 0xA8FB, 0x53D4 },
	{ 0xA8FC, 0x53D7 },
	{ 0xA8FD, 0x5473 },
	{ 0xA8FE, 0x5475 },
	{ 0xA940, 0x5496 },
	{ 0xA941, 0x5478 },
	{ 0xA942, 0x5495 },
	{ 0xA943, 0x5480 },
	{ 0xA944, 0x547B },
	{ 0xA945, 0x5477 },
	{ 0xA946, 0x5484 },
	{ 0xA947, 0x5492 },
	{ 0xA948, 0x5486 },
	{ 0xA949, 0x547C },
	{ 0xA94A, 0x5490 },
	{ 0xA94B, 0x5471 },
	{ 0xA94C, 0x5476 },
	{ 0xA94D, 0x548C },
	{ 0xA94E, 0x549A },
	{ 0xA94F, 0x5462 },
	{ 0xA950, 0x5468 },
	{ 0xA951, 0x548B },
	{ 0xA952, 0x547D },
	{ 0xA953, 0x548E },
	{ 0xA954, 0x56FA },
	{ 0xA955, 0x5783 },
	{ 0xA956, 0x5777 },
	{ 0xA957, 0x576A },
	{ 0xA958, 0x5769 },
	{ 0xA959, 0x5761 },
	{ 0xA95A, 0x5766 },
	{ 0xA95B, 0x5764 },
	{ 0xA95C, 0x577C },
	{ 0xA95D, 0x591C },
	{ 0xA95E, 0x5949 },
	{ 0xA95F, 0x5947 },
	{ 0xA960, 0x5948 },
	{ 0xA961, 0x5944 },
	{ 0xA962, 0x5954 },
	{ 0xA963, 0x59BE },
	{ 0xA964, 0x59BB },
	{ 0xA965, 0x59D4 },
	{ 0xA966, 0x59B9 },
	{ 0xA967, 0x59AE },
	{ 0xA968, 0x59D1 },
	{ 0xA969, 0x59C6 },
	{ 0xA96A, 0x59D0 },
	{ 0xA96B, 0x59CD },
	{ 0xA96C, 0x59CB },
	{ 0xA96D, 0x59D3 },
	{ 0xA96E, 0x59CA },
	{ 0xA96F, 0x59AF },
	{ 0xA970, 0x59B3 },
	{ 0xA971, 0x59D2 },
	{ 0xA972, 0x59C5 },
	{ 0xA973, 0x5B5F },
	{ 0xA974, 0x5B64 },
	{ 0xA975, 0x5B63 },
	{ 0xA976, 0x5B97 },
	{ 0xA977, 0x5B9A },
	{ 0xA978, 0x5B98 },
	{ 0xA979, 0x5B9C },
	{ 0xA97A, 0x5B99 },
	{ 0xA97B, 0x5B9B },
	{ 0xA97C, 0x5C1A },
	{ 0xA97D, 0x5C48 },
	{ 0xA97E, 0x5C45 },
	{ 0xA97F, 0xFFFD },
	{ 0xA980, 0x655A },
	{ 0xA981, 0x654E },
	{ 0xA982, 0x654D },
	{ 0xA983, 0x658D },
	{ 0xA984, 0x658E },
	{ 0xA985, 0x65AD },
	{ 0xA986, 0x65C7 },
	{ 0xA987, 0x65CA },
	{ 0xA988, 0x65C9 },
	{ 0xA989, 0x65E3 },
	{ 0xA98A, 0x6657 },
	{ 0xA98B, 0x6663 },
	{ 0xA98C, 0x6667 },
	{ 0xA98D, 0x671A },
	{ 0xA98E, 0x6719 },
	{ 0xA98F, 0x6716 },
	{ 0xA990, 0x689E },
	{ 0xA991, 0x68B6 },
	{ 0xA992, 0x6898 },
	{ 0xA993, 0x6873 },
	{ 0xA994, 0x689A },
	{ 0xA995, 0x688E },
	{ 0xA996, 0x68B7 },
	{ 0xA997, 0x68DB },
	{ 0xA998, 0x68A5 },
	{ 0xA999, 0x686C },
	{ 0xA99A, 0x68C1 },
	{ 0xA99B, 0x6884 },
	{ 0xA99C, 0x6895 },
	{ 0xA99D, 0x687A },
	{ 0xA99E, 0x6899 },
	{ 0xA99F, 0x68B8 },
	{ 0xA9A0, 0x68B9 },
	{ 0xA9A1, 0x5C46 },
	{ 0xA9A2, 0x5CB7 },
	{ 0xA9A3, 0x5CA1 },
	{ 0xA9A4, 0x5CB8 },
	{ 0xA9A5, 0x5CA9 },
	{ 0xA9A6, 0x5CAB },
	{ 0xA9A7, 0x5CB1 },
	{ 0xA9A8, 0x5CB3 },
	{ 0xA9A9, 0x5E18 },
	{ 0xA9AA, 0x5E1A },
	{ 0xA9AB, 0x5E16 },
	{ 0xA9AC, 0x5E15 },
	{ 0xA9AD, 0x5E1B },
	{ 0xA9AE, 0x5E11 },
	{ 0xA9AF, 0x5E78 },
	{ 0xA9B0, 0x5E9A },
	{ 0xA9B1, 0x5E97 },
	{ 0xA9B2, 0x5E9C },
	{ 0xA9B3, 0x5E95 },
	{ 0xA9B4, 0x5E96 },
	{ 0xA9B5, 0x5EF6 },
	{ 0xA9B6, 0x5F26 },
	{ 0xA9B7, 0x5F27 },
	{ 0xA9B8, 0x5F29 },
	{ 0xA9B9, 0x5F80 },
	{ 0xA9BA, 0x5F81 },
	{ 0xA9BB, 0x5F7F },
	{ 0xA9BC, 0x5F7C },
	{ 0xA9BD, 0x5FDD },
	{ 0xA9BE, 0x5FE0 },
	{ 0xA9BF, 0x5FFD },
	{ 0xA9C0, 0x5FF5 },
	{ 0xA9C1, 0x5FFF },
	{ 0xA9C2, 0x600F },
	{ 0xA9C3, 0x6014 },
	{ 0xA9C4, 0x602F },
	{ 0xA9C5, 0x6035 },
	{ 0xA9C6, 0x6016 },
	{ 0xA9C7, 0x602A },
	{ 0xA9C8, 0x6015 },
	{ 0xA9C9, 0x6021 },
	{ 0xA9CA, 0x6027 },
	{ 0xA9CB, 0x6029 },
	{ 0xA9CC, 0x602B },
	{ 0xA9CD, 0x601B },
	{ 0xA9CE, 0x6216 },
	{ 0xA9CF, 0x6215 },
	{ 0xA9D0, 0x623F },
	{ 0xA9D1, 0x623E },
	{ 0xA9D2, 0x6240 },
	{ 0xA9D3, 0x627F },
	{ 0xA9D4, 0x62C9 },
	{ 0xA9D5, 0x62CC },
	{ 0xA9D6, 0x62C4 },
	{ 0xA9D7, 0x62BF },
	{ 0xA9D8, 0x62C2 },
	{ 0xA9D9, 0x62B9 },
	{ 0xA9DA, 0x62D2 },
	{ 0xA9DB, 0x62DB },
	{ 0xA9DC, 0x62AB },
	{ 0xA9DD, 0x62D3 },
	{ 0xA9DE, 0x62D4 },
	{ 0xA9DF, 0x62CB },
	{ 0xA9E0, 0x62C8 },
	{ 0xA9E1, 0x62A8 },
	{ 0xA9E2, 0x62BD },
	{ 0xA9E3, 0x62BC },
	{ 0xA9E4, 0x62D0 },
	{ 0xA9E5, 0x62D9 },
	{ 0xA9E6, 0x62C7 },
	{ 0xA9E7, 0x62CD },
	{ 0xA9E8, 0x62B5 },
	{ 0xA9E9, 0x62DA },
	{ 0xA9EA, 0x62B1 },
	{ 0xA9EB, 0x62D8 },
	{ 0xA9EC, 0x62D6 },
	{ 0xA9ED, 0x62D7 },
	{ 0xA9EE, 0x62C6 },
	{ 0xA9EF, 0x62AC },
	{ 0xA9F0, 0x62CE },
	{ 0xA9F1, 0x653E },
	{ 0xA9F2, 0x65A7 },
	{ 0xA9F3, 0x65BC },
	{ 0xA9F4, 0x65FA },
	{ 0xA9F5, 0x6614 },
	{ 0xA9F6, 0x6613 },
	{ 0xA9F7, 0x660C },
	{ 0xA9F8, 0x6606 },
	{ 0xA9F9, 0x6602 },
	{ 0xA9FA, 0x660E },
	{ 0xA9FB, 0x6600 },
	{ 0xA9FC, 0x660F },
	{ 0xA9FD, 0x6615 },
	{ 0xA9FE, 0x660A },
	{ 0xAA40, 0x6607 },
	{ 0xAA41, 0x670D },
	{ 0xAA42, 0x670B },
	{ 0xAA43, 0x676D },
	{ 0xAA44, 0x678B },
	{ 0xAA45, 0x6795 },
	{ 0xAA46, 0x6771 },
	{ 0xAA47, 0x679C },
	{ 0xAA48, 0x6773 },
	{ 0xAA49, 0x6777 },
	{ 0xAA4A, 0x6787 },
	{ 0xAA4B, 0x679D },
	{ 0xAA4C, 0x6797 },
	{ 0xAA4D, 0x676F },
	{ 0xAA4E, 0x6770 },
	{ 0xAA4F, 0x677F },
	{ 0xAA50, 0x6789 },
	{ 0xAA51, 0x677E },
	{ 0xAA52, 0x6790 },
	{ 0xAA53, 0x6775 },
	{ 0xAA54, 0x679A },
	{ 0xAA55, 0x6793 },
	{ 0xAA56, 0x677C },
	{ 0xAA57, 0x676A },
	{ 0xAA58, 0x6772 },
	{ 0xAA59, 0x6B23 },
	{ 0xAA5A, 0x6B66 },
	{ 0xAA5B, 0x6B67 },
	{ 0xAA5C, 0x6B7F },
	{ 0xAA5D, 0x6C13 },
	{ 0xAA5E, 0x6C1B },
	{ 0xAA5F, 0x6CE3 },
	{ 0xAA60, 0x6CE8 },
	{ 0xAA61, 0x6CF3 },
	{ 0xAA62, 0x6CB1 },
	{ 0xAA63, 0x6CCC },
	{ 0xAA64, 0x6CE5 },
	{ 0xAA65, 0x6CB3 },
	{ 0xAA66, 0x6CBD },
	{ 0xAA67, 0x6CBE },
	{ 0xAA68, 0x6CBC },
	{ 0xAA69, 0x6CE2 },
	{ 0xAA6A, 0x6CAB },
	{ 0xAA6B, 0x6CD5 },
	{ 0xAA6C, 0x6CD3 },
	{ 0xAA6D, 0x6CB8 },
	{ 0xAA6E, 0x6CC4 },
	{ 0xAA6F, 0x6CB9 },
	{ 0xAA70, 0x6CC1 },
	{ 0xAA71, 0x6CAE },
	{ 0xAA72, 0x6CD7 },
	{ 0xAA73, 0x6CC5 },
	{ 0xAA74, 0x6CF1 },
	{ 0xAA75, 0x6CBF },
	{ 0xAA76, 0x6CBB },
	{ 0xAA77, 0x6CE1 },
	{ 0xAA78, 0x6CDB },
	{ 0xAA79, 0x6CCA },
	{ 0xAA7A, 0x6CAC },
	{ 0xAA7B, 0x6CEF },
	{ 0xAA7C, 0x6CDC },
	{ 0xAA7D, 0x6CD6 },
	{ 0xAA7E, 0x6CE0 },
	{ 0xAA7F, 0xFFFD },
	{ 0xAA80, 0x6870 },
	{ 0xAA81, 0x6B35 },
	{ 0xAA82, 0x6B90 },
	{ 0xAA83, 0x6BBB },
	{ 0xAA84, 0x6BED },
	{ 0xAA85, 0x6DC1 },
	{ 0xAA86, 0x6DC3 },
	{ 0xAA87, 0x6DCE },
	{ 0xAA88, 0x6DAD },
	{ 0xAA89, 0x6E04 },
	{ 0xAA8A, 0x6DB9 },
	{ 0xAA8B, 0x6DE7 },
	{ 0xAA8C, 0x6E08 },
	{ 0xAA8D, 0x6E06 },
	{ 0xAA8E, 0x6E0A },
	{ 0xAA8F, 0x6DB0 },
	{ 0xAA90, 0x6DF8 },
	{ 0xAA91, 0x6E0C },
	{ 0xAA92, 0x6DB1 },
	{ 0xAA93, 0x6E02 },
	{ 0xAA94, 0x6E07 },
	{ 0xAA95, 0x6E09 },
	{ 0xAA96, 0x6E01 },
	{ 0xAA97, 0x6E17 },
	{ 0xAA98, 0x6DFF },
	{ 0xAA99, 0x6E12 },
	{ 0xAA9A, 0x7103 },
	{ 0xAA9B, 0x7107 },
	{ 0xAA9C, 0x7101 },
	{ 0xAA9D, 0x70F5 },
	{ 0xAA9E, 0x70F1 },
	{ 0xAA9F, 0x7108 },
	{ 0xAAA0, 0x70F2 },
	{ 0xAAA1, 0x7095 },
	{ 0xAAA2, 0x708E },
	{ 0xAAA3, 0x7092 },
	{ 0xAAA4, 0x708A },
	{ 0xAAA5, 0x7099 },
	{ 0xAAA6, 0x722C },
	{ 0xAAA7, 0x722D },
	{ 0xAAA8, 0x7238 },
	{ 0xAAA9, 0x7248 },
	{ 0xAAAA, 0x7267 },
	{ 0xAAAB, 0x7269 },
	{ 0xAAAC, 0x72C0 },
	{ 0xAAAD, 0x72CE },
	{ 0xAAAE, 0x72D9 },
	{ 0xAAAF, 0x72D7 },
	{ 0xAAB0, 0x72D0 },
	{ 0xAAB1, 0x73A9 },
	{ 0xAAB2, 0x73A8 },
	{ 0xAAB3, 0x739F },
	{ 0xAAB4, 0x73AB },
	{ 0xAAB5, 0x73A5 },
	{ 0xAAB6, 0x753D },
	{ 0xAAB7, 0x759D },
	{ 0xAAB8, 0x7599 },
	{ 0xAAB9, 0x759A },
	{ 0xAABA, 0x7684 },
	{ 0xAABB, 0x76C2 },
	{ 0xAABC, 0x76F2 },
	{ 0xAABD, 0x76F4 },
	{ 0xAABE, 0x77E5 },
	{ 0xAABF, 0x77FD },
	{ 0xAAC0, 0x793E },
	{ 0xAAC1, 0x7940 },
	{ 0xAAC2, 0x7941 },
	{ 0xAAC3, 0x79C9 },
	{ 0xAAC4, 0x79C8 },
	{ 0xAAC5, 0x7A7A },
	{ 0xAAC6, 0x7A79 },
	{ 0xAAC7, 0x7AFA },
	{ 0xAAC8, 0x7CFE },
	{ 0xAAC9, 0x7F54 },
	{ 0xAACA, 0x7F8C },
	{ 0xAACB, 0x7F8B },
	{ 0xAACC, 0x8005 },
	{ 0xAACD, 0x80BA },
	{ 0xAACE, 0x80A5 },
	{ 0xAACF, 0x80A2 },
	{ 0xAAD0, 0x80B1 },
	{ 0xAAD1, 0x80A1 },
	{ 0xAAD2, 0x80AB },
	{ 0xAAD3, 0x80A9 },
	{ 0xAAD4, 0x80B4 },
	{ 0xAAD5, 0x80AA },
	{ 0xAAD6, 0x80AF },
	{ 0xAAD7, 0x81E5 },
	{ 0xAAD8, 0x81FE },
	{ 0xAAD9, 0x820D },
	{ 0xAADA, 0x82B3 },
	{ 0xAADB, 0x829D },
	{ 0xAADC, 0x8299 },
	{ 0xAADD, 0x82AD },
	{ 0xAADE, 0x82BD },
	{ 0xAADF, 0x829F },
	{ 0xAAE0, 0x82B9 },
	{ 0xAAE1, 0x82B1 },
	{ 0xAAE2, 0x82AC },
	{ 0xAAE3, 0x82A5 },
	{ 0xAAE4, 0x82AF },
	{ 0xAAE5, 0x82B8 },
	{ 0xAAE6, 0x82A3 },
	{ 0xAAE7, 0x82B0 },
	{ 0xAAE8, 0x82BE },
	{ 0xAAE9, 0x82B7 },
	{ 0xAAEA, 0x864E },
	{ 0xAAEB, 0x8671 },
	{ 0xAAEC, 0x521D },
	{ 0xAAED, 0x8868 },
	{ 0xAAEE, 0x8ECB },
	{ 0xAAEF, 0x8FCE },
	{ 0xAAF0, 0x8FD4 },
	{ 0xAAF1, 0x8FD1 },
	{ 0xAAF2, 0x90B5 },
	{ 0xAAF3, 0x90B8 },
	{ 0xAAF4, 0x90B1 },
	{ 0xAAF5, 0x90B6 },
	{ 0xAAF6, 0x91C7 },
	{ 0xAAF7, 0x91D1 },
	{ 0xAAF8, 0x9577 },
	{ 0xAAF9, 0x9580 },
	{ 0xAAFA, 0x961C },
	{ 0xAAFB, 0x9640 },
	{ 0xAAFC, 0x963F },
	{ 0xAAFD, 0x963B },
	{ 0xAAFE, 0x9644 },
	{ 0xAB40, 0x9642 },
	{ 0xAB41, 0x96B9 },
	{ 0xAB42, 0x96E8 },
	{ 0xAB43, 0x9752 },
	{ 0xAB44, 0x975E },
	{ 0xAB45, 0x4E9F },
	{ 0xAB46, 0x4EAD },
	{ 0xAB47, 0x4EAE },
	{ 0xAB48, 0x4FE1 },
	{ 0xAB49, 0x4FB5 },
	{ 0xAB4A, 0x4FAF },
	{ 0xAB4B, 0x4FBF },
	{ 0xAB4C, 0x4FE0 },
	{ 0xAB4D, 0x4FD1 },
	{ 0xAB4E, 0x4FCF },
	{ 0xAB4F, 0x4FDD },
	{ 0xAB50, 0x4FC3 },
	{ 0xAB51, 0x4FB6 },
	{ 0xAB52, 0x4FD8 },
	{ 0xAB53, 0x4FDF },
	{ 0xAB54, 0x4FCA },
	{ 0xAB55, 0x4FD7 },
	{ 0xAB56, 0x4FAE },
	{ 0xAB57, 0x4FD0 },
	{ 0xAB58, 0x4FC4 },
	{ 0xAB59, 0x4FC2 },
	{ 0xAB5A, 0x4FDA },
	{ 0xAB5B, 0x4FCE },
	{ 0xAB5C, 0x4FDE },
	{ 0xAB5D, 0x4FB7 },
	{ 0xAB5E, 0x5157 },
	{ 0xAB5F, 0x5192 },
	{ 0xAB60, 0x5191 },
	{ 0xAB61, 0x51A0 },
	{ 0xAB62, 0x524E },
	{ 0xAB63, 0x5243 },
	{ 0xAB64, 0x524A },
	{ 0xAB65, 0x524D },
	{ 0xAB66, 0x524C },
	{ 0xAB67, 0x524B },
	{ 0xAB68, 0x5247 },
	{ 0xAB69, 0x52C7 },
	{ 0xAB6A, 0x52C9 },
	{ 0xAB6B, 0x52C3 },
	{ 0xAB6C, 0x52C1 },
	{ 0xAB6D, 0x530D },
	{ 0xAB6E, 0x5357 },
	{ 0xAB6F, 0x537B },
	{ 0xAB70, 0x539A },
	{ 0xAB71, 0x53DB },
	{ 0xAB72, 0x54AC },
	{ 0xAB73, 0x54C0 },
	{ 0xAB74, 0x54A8 },
	{ 0xAB75, 0x54CE },
	{ 0xAB76, 0x54C9 },
	{ 0xAB77, 0x54B8 },
	{ 0xAB78, 0x54A6 },
	{ 0xAB79, 0x54B3 },
	{ 0xAB7A, 0x54C7 },
	{ 0xAB7B, 0x54C2 },
	{ 0xAB7C, 0x54BD },
	{ 0xAB7D, 0x54AA },
	{ 0xAB7E, 0x54C1 },
	{ 0xAB7F, 0xFFFD },
	{ 0xAB80, 0x710F },
	{ 0xAB81, 0x70FE },
	{ 0xAB82, 0x731A },
	{ 0xAB83, 0x7310 },
	{ 0xAB84, 0x730E },
	{ 0xAB85, 0x7402 },
	{ 0xAB86, 0x73F3 },
	{ 0xAB87, 0x73FB },
	{ 0xAB88, 0x751B },
	{ 0xAB89, 0x7523 },
	{ 0xAB8A, 0x7561 },
	{ 0xAB8B, 0x7568 },
	{ 0xAB8C, 0x7567 },
	{ 0xAB8D, 0x75D3 },
	{ 0xAB8E, 0x7690 },
	{ 0xAB8F, 0x76D5 },
	{ 0xAB90, 0x76D7 },
	{ 0xAB91, 0x76D6 },
	{ 0xAB92, 0x7730 },
	{ 0xAB93, 0x7726 },
	{ 0xAB94, 0x7740 },
	{ 0xAB95, 0x771E },
	{ 0xAB96, 0x7847 },
	{ 0xAB97, 0x784B },
	{ 0xAB98, 0x7851 },
	{ 0xAB99, 0x784F },
	{ 0xAB9A, 0x7842 },
	{ 0xAB9B, 0x7846 },
	{ 0xAB9C, 0x796E },
	{ 0xAB9D, 0x796C },
	{ 0xAB9E, 0x79F2 },
	{ 0xAB9F, 0x79F1 },
	{ 0xABA0, 0x79F5 },
	{ 0xABA1, 0x54C4 },
	{ 0xABA2, 0x54C8 },
	{ 0xABA3, 0x54AF },
	{ 0xABA4, 0x54AB },
	{ 0xABA5, 0x54B1 },
	{ 0xABA6, 0x54BB },
	{ 0xABA7, 0x54A9 },
	{ 0xABA8, 0x54A7 },
	{ 0xABA9, 0x54BF },
	{ 0xABAA, 0x56FF },
	{ 0xABAB, 0x5782 },
	{ 0xABAC, 0x578B },
	{ 0xABAD, 0x57A0 },
	{ 0xABAE, 0x57A3 },
	{ 0xABAF, 0x57A2 },
	{ 0xABB0, 0x57CE },
	{ 0xABB1, 0x57AE },
	{ 0xABB2, 0x5793 },
	{ 0xABB3, 0x5955 },
	{ 0xABB4, 0x5951 },
	{ 0xABB5, 0x594F },
	{ 0xABB6, 0x594E },
	{ 0xABB7, 0x5950 },
	{ 0xABB8, 0x59DC },
	{ 0xABB9, 0x59D8 },
	{ 0xABBA, 0x59FF },
	{ 0xABBB, 0x59E3 },
	{ 0xABBC, 0x59E8 },
	{ 0xABBD, 0x5A03 },
	{ 0xABBE, 0x59E5 },
	{ 0xABBF, 0x59EA },
	{ 0xABC0, 0x59DA },
	{ 0xABC1, 0x59E6 },
	{ 0xABC2, 0x5A01 },
	{ 0xABC3, 0x59FB },
	{ 0xABC4, 0x5B69 },
	{ 0xABC5, 0x5BA3 },
	{ 0xABC6, 0x5BA6 },
	{ 0xABC7, 0x5BA4 },
	{ 0xABC8, 0x5BA2 },
	{ 0xABC9, 0x5BA5 },
	{ 0xABCA, 0x5C01 },
	{ 0xABCB, 0x5C4E },
	{ 0xABCC, 0x5C4F },
	{ 0xABCD, 0x5C4D },
	{ 0xABCE, 0x5C4B },
	{ 0xABCF, 0x5CD9 },
	{ 0xABD0, 0x5CD2 },
	{ 0xABD1, 0x5DF7 },
	{ 0xABD2, 0x5E1D },
	{ 0xABD3, 0x5E25 },
	{ 0xABD4, 0x5E1F },
	{ 0xABD5, 0x5E7D },
	{ 0xABD6, 0x5EA0 },
	{ 0xABD7, 0x5EA6 },
	{ 0xABD8, 0x5EFA },
	{ 0xABD9, 0x5F08 },
	{ 0xABDA, 0x5F2D },
	{ 0xABDB, 0x5F65 },
	{ 0xABDC, 0x5F88 },
	{ 0xABDD, 0x5F85 },
	{ 0xABDE, 0x5F8A },
	{ 0xABDF, 0x5F8B },
	{ 0xABE0, 0x5F87 },
	{ 0xABE1, 0x5F8C },
	{ 0xABE2, 0x5F89 },
	{ 0xABE3, 0x6012 },
	{ 0xABE4, 0x601D },
	{ 0xABE5, 0x6020 },
	{ 0xABE6, 0x6025 },
	{ 0xABE7, 0x600E },
	{ 0xABE8, 0x6028 },
	{ 0xABE9, 0x604D },
	{ 0xABEA, 0x6070 },
	{ 0xABEB, 0x6068 },
	{ 0xABEC, 0x6062 },
	{ 0xABED, 0x6046 },
	{ 0xABEE, 0x6043 },
	{ 0xABEF, 0x606C },
	{ 0xABF0, 0x606B },
	{ 0xABF1, 0x606A },
	{ 0xABF2, 0x6064 },
	{ 0xABF3, 0x6241 },
	{ 0xABF4, 0x62DC },
	{ 0xABF5, 0x6316 },
	{ 0xABF6, 0x6309 },
	{ 0xABF7, 0x62FC },
	{ 0xABF8, 0x62ED },
	{ 0xABF9, 0x6301 },
	{ 0xABFA, 0x62EE },
	{ 0xABFB, 0x62FD },
	{ 0xABFC, 0x6307 },
	{ 0xABFD, 0x62F1 },
	{ 0xABFE, 0x62F7 },
	{ 0xAC40, 0x62EF },
	{ 0xAC41, 0x62EC },
	{ 0xAC42, 0x62FE },
	{ 0xAC43, 0x62F4 },
	{ 0xAC44, 0x6311 },
	{ 0xAC45, 0x6302 },
	{ 0xAC46, 0x653F },
	{ 0xAC47, 0x6545 },
	{ 0xAC48, 0x65AB },
	{ 0xAC49, 0x65BD },
	{ 0xAC4A, 0x65E2 },
	{ 0xAC4B, 0x6625 },
	{ 0xAC4C, 0x662D },
	{ 0xAC4D, 0x6620 },
	{ 0xAC4E, 0x6627 },
	{ 0xAC4F, 0x662F },
	{ 0xAC50, 0x661F },
	{ 0xAC51, 0x6628 },
	{ 0xAC52, 0x6631 },
	{ 0xAC53, 0x6624 },
	{ 0xAC54, 0x66F7 },
	{ 0xAC55, 0x67FF },
	{ 0xAC56, 0x67D3 },
	{ 0xAC57, 0x67F1 },
	{ 0xAC58, 0x67D4 },
	{ 0xAC59, 0x67D0 },
	{ 0xAC5A, 0x67EC },
	{ 0xAC5B, 0x67B6 },
	{ 0xAC5C, 0x67AF },
	{ 0xAC5D, 0x67F5 },
	{ 0xAC5E, 0x67E9 },
	{ 0xAC5F, 0x67EF },
	{ 0xAC60, 0x67C4 },
	{ 0xAC61, 0x67D1 },
	{ 0xAC62, 0x67B4 },
	{ 0xAC63, 0x67DA },
	{ 0xAC64, 0x67E5 },
	{ 0xAC65, 0x67B8 },
	{ 0xAC66, 0x67CF },
	{ 0xAC67, 0x67DE },
	{ 0xAC68, 0x67F3 },
	{ 0xAC69, 0x67B0 },
	{ 0xAC6A, 0x67D9 },
	{ 0xAC6B, 0x67E2 },
	{ 0xAC6C, 0x67DD },
	{ 0xAC6D, 0x67D2 },
	{ 0xAC6E, 0x6B6A },
	{ 0xAC6F, 0x6B83 },
	{ 0xAC70, 0x6B86 },
	{ 0xAC71, 0x6BB5 },
	{ 0xAC72, 0x6BD2 },
	{ 0xAC73, 0x6BD7 },
	{ 0xAC74, 0x6C1F },
	{ 0xAC75, 0x6CC9 },
	{ 0xAC76, 0x6D0B },
	{ 0xAC77, 0x6D32 },
	{ 0xAC78, 0x6D2A },
	{ 0xAC79, 0x6D41 },
	{ 0xAC7A, 0x6D25 },
	{ 0xAC7B, 0x6D0C },
	{ 0xAC7C, 0x6D31 },
	{ 0xAC7D, 0x6D1E },
	{ 0xAC7E, 0x6D17 },
	{ 0xAC7F, 0xFFFD },
	{ 0xAC80, 0x79F3 },
	{ 0xAC81, 0x79F9 },
	{ 0xAC82, 0x7A9A },
	{ 0xAC83, 0x7A93 },
	{ 0xAC84, 0x7A91 },
	{ 0xAC85, 0x7AE1 },
	{ 0xAC86, 0x7B21 },
	{ 0xAC87, 0x7B1C },
	{ 0xAC88, 0x7B16 },
	{ 0xAC89, 0x7B17 },
	{ 0xAC8A, 0x7B36 },
	{ 0xAC8B, 0x7B1F },
	{ 0xAC8C, 0x7C93 },
	{ 0xAC8D, 0x7C99 },
	{ 0xAC8E, 0x7C9A },
	{ 0xAC8F, 0x7C9C },
	{ 0xAC90, 0x7D49 },
	{ 0xAC91, 0x7D34 },
	{ 0xAC92, 0x7D37 },
	{ 0xAC93, 0x7D2D },
	{ 0xAC94, 0x7D4C },
	{ 0xAC95, 0x7D48 },
	{ 0xAC96, 0x7F3B },
	{ 0xAC97, 0x8008 },
	{ 0xAC98, 0x801A },
	{ 0xAC99, 0x801D },
	{ 0xAC9A, 0x8049 },
	{ 0xAC9B, 0x8045 },
	{ 0xAC9C, 0x8044 },
	{ 0xAC9D, 0x7C9B },
	{ 0xAC9E, 0x812A },
	{ 0xAC9F, 0x812E },
	{ 0xACA0, 0x8131 },
	{ 0xACA1, 0x6D3B },
	{ 0xACA2, 0x6D3D },
	{ 0xACA3, 0x6D3E },
	{ 0xACA4, 0x6D36 },
	{ 0xACA5, 0x6D1B },
	{ 0xACA6, 0x6CF5 },
	{ 0xACA7, 0x6D39 },
	{ 0xACA8, 0x6D27 },
	{ 0xACA9, 0x6D38 },
	{ 0xACAA, 0x6D29 },
	{ 0xACAB, 0x6D2E },
	{ 0xACAC, 0x6D35 },
	{ 0xACAD, 0x6D0E },
	{ 0xACAE, 0x6D2B },
	{ 0xACAF, 0x70AB },
	{ 0xACB0, 0x70BA },
	{ 0xACB1, 0x70B3 },
	{ 0xACB2, 0x70AC },
	{ 0xACB3, 0x70AF },
	{ 0xACB4, 0x70AD },
	{ 0xACB5, 0x70B8 },
	{ 0xACB6, 0x70AE },
	{ 0xACB7, 0x70A4 },
	{ 0xACB8, 0x7230 },
	{ 0xACB9, 0x7272 },
	{ 0xACBA, 0x726F },
	{ 0xACBB, 0x7274 },
	{ 0xACBC, 0x72E9 },
	{ 0xACBD, 0x72E0 },
	{ 0xACBE, 0x72E1 },
	{ 0xACBF, 0x73B7 },
	{ 0xACC0, 0x73CA },
	{ 0xACC1, 0x73BB },
	{ 0xACC2, 0x73B2 },
	{ 0xACC3, 0x73CD },
	{ 0xACC4, 0x73C0 },
	{ 0xACC5, 0x73B3 },
	{ 0xACC6, 0x751A },
	{ 0xACC7, 0x752D },
	{ 0xACC8, 0x754F },
	{ 0xACC9, 0x754C },
	{ 0xACCA, 0x754E },
	{ 0xACCB, 0x754B },
	{ 0xACCC, 0x75AB },
	{ 0xACCD, 0x75A4 },
	{ 0xACCE, 0x75A5 },
	{ 0xACCF, 0x75A2 },
	{ 0xACD0, 0x75A3 },
	{ 0xACD1, 0x7678 },
	{ 0xACD2, 0x7686 },
	{ 0xACD3, 0x7687 },
	{ 0xACD4, 0x7688 },
	{ 0xACD5, 0x76C8 },
	{ 0xACD6, 0x76C6 },
	{ 0xACD7, 0x76C3 },
	{ 0xACD8, 0x76C5 },
	{ 0xACD9, 0x7701 },
	{ 0xACDA, 0x76F9 },
	{ 0xACDB, 0x76F8 },
	{ 0xACDC, 0x7709 },
	{ 0xACDD, 0x770B },
	{ 0xACDE, 0x76FE },
	{ 0xACDF, 0x76FC },
	{ 0xACE0, 0x7707 },
	{ 0xACE1, 0x77DC },
	{ 0xACE2, 0x7802 },
	{ 0xACE3, 0x7814 },
	{ 0xACE4, 0x780C },
	{ 0xACE5, 0x780D },
	{ 0xACE6, 0x7946 },
	{ 0xACE7, 0x7949 },
	{ 0xACE8, 0x7948 },
	{ 0xACE9, 0x7947 },
	{ 0xACEA, 0x79B9 },
	{ 0xACEB, 0x79BA },
	{ 0xACEC, 0x79D1 },
	{ 0xACED, 0x79D2 },
	{ 0xACEE, 0x79CB },
	{ 0xACEF, 0x7A7F },
	{ 0xACF0, 0x7A81 },
	{ 0xACF1, 0x7AFF },
	{ 0xACF2, 0x7AFD },
	{ 0xACF3, 0x7C7D },
	{ 0xACF4, 0x7D02 },
	{ 0xACF5, 0x7D05 },
	{ 0xACF6, 0x7D00 },
	{ 0xACF7, 0x7D09 },
	{ 0xACF8, 0x7D07 },
	{ 0xACF9, 0x7D04 },
	{ 0xACFA, 0x7D06 },
	{ 0xACFB, 0x7F38 },
	{ 0xACFC, 0x7F8E },
	{ 0xACFD, 0x7FBF },
	{ 0xACFE, 0x8004 },
	{ 0xAD40, 0x8010 },
	{ 0xAD41, 0x800D },
	{ 0xAD42, 0x8011 },
	{ 0xAD43, 0x8036 },
	{ 0xAD44, 0x80D6 },
	{ 0xAD45, 0x80E5 },
	{ 0xAD46, 0x80DA },
	{ 0xAD47, 0x80C3 },
	{ 0xAD48, 0x80C4 },
	{ 0xAD49, 0x80CC },
	{ 0xAD4A, 0x80E1 },
	{ 0xAD4B, 0x80DB },
	{ 0xAD4C, 0x80CE },
	{ 0xAD4D, 0x80DE },
	{ 0xAD4E, 0x80E4 },
	{ 0xAD4F, 0x80DD },
	{ 0xAD50, 0x81F4 },
	{ 0xAD51, 0x8222 },
	{ 0xAD52, 0x82E7 },
	{ 0xAD53, 0x8303 },
	{ 0xAD54, 0x8305 },
	{ 0xAD55, 0x82E3 },
	{ 0xAD56, 0x82DB },
	{ 0xAD57, 0x82E6 },
	{ 0xAD58, 0x8304 },
	{ 0xAD59, 0x82E5 },
	{ 0xAD5A, 0x8302 },
	{ 0xAD5B, 0x8309 },
	{ 0xAD5C, 0x82D2 },
	{ 0xAD5D, 0x82D7 },
	{ 0xAD5E, 0x82F1 },
	{ 0xAD5F, 0x8301 },
	{ 0xAD60, 0x82DC },
	{ 0xAD61, 0x82D4 },
	{ 0xAD62, 0x82D1 },
	{ 0xAD63, 0x82DE },
	{ 0xAD64, 0x82D3 },
	{ 0xAD65, 0x82DF },
	{ 0xAD66, 0x82EF },
	{ 0xAD67, 0x8306 },
	{ 0xAD68, 0x8650 },
	{ 0xAD69, 0x8679 },
	{ 0xAD6A, 0x867B },
	{ 0xAD6B, 0x867A },
	{ 0xAD6C, 0x884D },
	{ 0xAD6D, 0x886B },
	{ 0xAD6E, 0x8981 },
	{ 0xAD6F, 0x89D4 },
	{ 0xAD70, 0x8A08 },
	{ 0xAD71, 0x8A02 },
	{ 0xAD72, 0x8A03 },
	{ 0xAD73, 0x8C9E },
	{ 0xAD74, 0x8CA0 },
	{ 0xAD75, 0x8D74 },
	{ 0xAD76, 0x8D73 },
	{ 0xAD77, 0x8DB4 },
	{ 0xAD78, 0x8ECD },
	{ 0xAD79, 0x8ECC },
	{ 0xAD7A, 0x8FF0 },
	{ 0xAD7B, 0x8FE6 },
	{ 0xAD7C, 0x8FE2 },
	{ 0xAD7D, 0x8FEA },
	{ 0xAD7E, 0x8FE5 },
	{ 0xAD7F, 0xFFFD },
	{ 0xAD80, 0x811A },
	{ 0xAD81, 0x8134 },
	{ 0xAD82, 0x8117 },
	{ 0xAD83, 0x831D },
	{ 0xAD84, 0x8371 },
	{ 0xAD85, 0x8384 },
	{ 0xAD86, 0x8380 },
	{ 0xAD87, 0x8372 },
	{ 0xAD88, 0x83A1 },
	{ 0xAD89, 0x8379 },
	{ 0xAD8A, 0x8391 },
	{ 0xAD8B, 0x839F },
	{ 0xAD8C, 0x83AD },
	{ 0xAD8D, 0x8323 },
	{ 0xAD8E, 0x8385 },
	{ 0xAD8F, 0x839C },
	{ 0xAD90, 0x83B7 },
	{ 0xAD91, 0x8658 },
	{ 0xAD92, 0x865A },
	{ 0xAD93, 0x8657 },
	{ 0xAD94, 0x86B2 },
	{ 0xAD95, 0x86AE },
	{ 0xAD96, 0x8845 },
	{ 0xAD97, 0x889C },
	{ 0xAD98, 0x8894 },
	{ 0xAD99, 0x88A3 },
	{ 0xAD9A, 0x888F },
	{ 0xAD9B, 0x88A5 },
	{ 0xAD9C, 0x88A9 },
	{ 0xAD9D, 0x88A6 },
	{ 0xAD9E, 0x888A },
	{ 0xAD9F, 0x88A0 },
	{ 0xADA0, 0x8890 },
	{ 0xADA1, 0x8FED },
	{ 0xADA2, 0x8FEB },
	{ 0xADA3, 0x8FE4 },
	{ 0xADA4, 0x8FE8 },
	{ 0xADA5, 0x90CA },
	{ 0xADA6, 0x90CE },
	{ 0xADA7, 0x90C1 },
	{ 0xADA8, 0x90C3 },
	{ 0xADA9, 0x914B },
	{ 0xADAA, 0x914A },
	{ 0xADAB, 0x91CD },
	{ 0xADAC, 0x9582 },
	{ 0xADAD, 0x9650 },
	{ 0xADAE, 0x964B },
	{ 0xADAF, 0x964C },
	{ 0xADB0, 0x964D },
	{ 0xADB1, 0x9762 },
	{ 0xADB2, 0x9769 },
	{ 0xADB3, 0x97CB },
	{ 0xADB4, 0x97ED },
	{ 0xADB5, 0x97F3 },
	{ 0xADB6, 0x9801 },
	{ 0xADB7, 0x98A8 },
	{ 0xADB8, 0x98DB },
	{ 0xADB9, 0x98DF },
	{ 0xADBA, 0x9996 },
	{ 0xADBB, 0x9999 },
	{ 0xADBC, 0x4E58 },
	{ 0xADBD, 0x4EB3 },
	{ 0xADBE, 0x500C },
	{ 0xADBF, 0x500D },
	{ 0xADC0, 0x5023 },
	{ 0xADC1, 0x4FEF },
	{ 0xADC2, 0x5026 },
	{ 0xADC3, 0x5025 },
	{ 0xADC4, 0x4FF8 },
	{ 0xADC5, 0x5029 },
	{ 0xADC6, 0x5016 },
	{ 0xADC7, 0x5006 },
	{ 0xADC8, 0x503C },
	{ 0xADC9, 0x501F },
	{ 0xADCA, 0x501A },
	{ 0xADCB, 0x5012 },
	{ 0xADCC, 0x5011 },
	{ 0xADCD, 0x4FFA },
	{ 0xADCE, 0x5000 },
	{ 0xADCF, 0x5014 },
	{ 0xADD0, 0x5028 },
	{ 0xADD1, 0x4FF1 },
	{ 0xADD2, 0x5021 },
	{ 0xADD3, 0x500B },
	{ 0xADD4, 0x5019 },
	{ 0xADD5, 0x5018 },
	{ 0xADD6, 0x4FF3 },
	{ 0xADD7, 0x4FEE },
	{ 0xADD8, 0x502D },
	{ 0xADD9, 0x502A },
	{ 0xADDA, 0x4FFE },
	{ 0xADDB, 0x502B },
	{ 0xADDC, 0x5009 },
	{ 0xADDD, 0x517C },
	{ 0xADDE, 0x51A4 },
	{ 0xADDF, 0x51A5 },
	{ 0xADE0, 0x51A2 },
	{ 0xADE1, 0x51CD },
	{ 0xADE2, 0x51CC },
	{ 0xADE3, 0x51C6 },
	{ 0xADE4, 0x51CB },
	{ 0xADE5, 0x5256 },
	{ 0xADE6, 0x525C },
	{ 0xADE7, 0x5254 },
	{ 0xADE8, 0x525B },
	{ 0xADE9, 0x525D },
	{ 0xADEA, 0x532A },
	{ 0xADEB, 0x537F },
	{ 0xADEC, 0x539F },
	{ 0xADED, 0x539D },
	{ 0xADEE, 0x53DF },
	{ 0xADEF, 0x54E8 },
	{ 0xADF0, 0x5510 },
	{ 0xADF1, 0x5501 },
	{ 0xADF2, 0x5537 },
	{ 0xADF3, 0x54FC },
	{ 0xADF4, 0x54E5 },
	{ 0xADF5, 0x54F2 },
	{ 0xADF6, 0x5506 },
	{ 0xADF7, 0x54FA },
	{ 0xADF8, 0x5514 },
	{ 0xADF9, 0x54E9 },
	{ 0xADFA, 0x54ED },
	{ 0xADFB, 0x54E1 },
	{ 0xADFC, 0x5509 },
	{ 0xADFD, 0x54EE },
	{ 0xADFE, 0x54EA },
	{ 0xAE40, 0x54E6 },
	{ 0xAE41, 0x5527 },
	{ 0xAE42, 0x5507 },
	{ 0xAE43, 0x54FD },
	{ 0xAE44, 0x550F },
	{ 0xAE45, 0x5703 },
	{ 0xAE46, 0x5704 },
	{ 0xAE47, 0x57C2 },
	{ 0xAE48, 0x57D4 },
	{ 0xAE49, 0x57CB },
	{ 0xAE4A, 0x57C3 },
	{ 0xAE4B, 0x5809 },
	{ 0xAE4C, 0x590F },
	{ 0xAE4D, 0x5957 },
	{ 0xAE4E, 0x5958 },
	{ 0xAE4F, 0x595A },
	{ 0xAE50, 0x5A11 },
	{ 0xAE51, 0x5A18 },
	{ 0xAE52, 0x5A1C },
	{ 0xAE53, 0x5A1F },
	{ 0xAE54, 0x5A1B },
	{ 0xAE55, 0x5A13 },
	{ 0xAE56, 0x59EC },
	{ 0xAE57, 0x5A20 },
	{ 0xAE58, 0x5A23 },
	{ 0xAE59, 0x5A29 },
	{ 0xAE5A, 0x5A25 },
	{ 0xAE5B, 0x5A0C },
	{ 0xAE5C, 0x5A09 },
	{ 0xAE5D, 0x5B6B },
	{ 0xAE5E, 0x5C58 },
	{ 0xAE5F, 0x5BB0 },
	{ 0xAE60, 0x5BB3 },
	{ 0xAE61, 0x5BB6 },
	{ 0xAE62, 0x5BB4 },
	{ 0xAE63, 0x5BAE },
	{ 0xAE64, 0x5BB5 },
	{ 0xAE65, 0x5BB9 },
	{ 0xAE66, 0x5BB8 },
	{ 0xAE67, 0x5C04 },
	{ 0xAE68, 0x5C51 },
	{ 0xAE69, 0x5C55 },
	{ 0xAE6A, 0x5C50 },
	{ 0xAE6B, 0x5CED },
	{ 0xAE6C, 0x5CFD },
	{ 0xAE6D, 0x5CFB },
	{ 0xAE6E, 0x5CEA },
	{ 0xAE6F, 0x5CE8 },
	{ 0xAE70, 0x5CF0 },
	{ 0xAE71, 0x5CF6 },
	{ 0xAE72, 0x5D01 },
	{ 0xAE73, 0x5CF4 },
	{ 0xAE74, 0x5DEE },
	{ 0xAE75, 0x5E2D },
	{ 0xAE76, 0x5E2B },
	{ 0xAE77, 0x5EAB },
	{ 0xAE78, 0x5EAD },
	{ 0xAE79, 0x5EA7 },
	{ 0xAE7A, 0x5F31 },
	{ 0xAE7B, 0x5F92 },
	{ 0xAE7C, 0x5F91 },
	{ 0xAE7D, 0x5F90 },
	{ 0xAE7E, 0x6059 },
	{ 0xAE7F, 0xFFFD },
	{ 0xAE80, 0x8992 },
	{ 0xAE81, 0x8991 },
	{ 0xAE82, 0x8994 },
	{ 0xAE83, 0x8A26 },
	{ 0xAE84, 0x8A32 },
	{ 0xAE85, 0x8A28 },
	{ 0xAE86, 0x8A1C },
	{ 0xAE87, 0x8A2B },
	{ 0xAE88, 0x8A20 },
	{ 0xAE89, 0x8A29 },
	{ 0xAE8A, 0x8A21 },
	{ 0xAE8B, 0x8C3A },
	{ 0xAE8C, 0x8C5B },
	{ 0xAE8D, 0x8C58 },
	{ 0xAE8E, 0x8C7C },
	{ 0xAE8F, 0x8CA6 },
	{ 0xAE90, 0x8CAE },
	{ 0xAE91, 0x8CAD },
	{ 0xAE92, 0x8D65 },
	{ 0xAE93, 0x8D7E },
	{ 0xAE94, 0x8D7C },
	{ 0xAE95, 0x8D7F },
	{ 0xAE96, 0x8D7A },
	{ 0xAE97, 0x8DBD },
	{ 0xAE98, 0x8DC0 },
	{ 0xAE99, 0x8DBB },
	{ 0xAE9A, 0x8EAD },
	{ 0xAE9B, 0x8EAF },
	{ 0xAE9C, 0x8ED6 },
	{ 0xAE9D, 0x8ED9 },
	{ 0xAE9E, 0x9012 },
	{ 0xAE9F, 0x900E },
	{ 0xAEA0, 0x9025 },
	{ 0xAEA1, 0x6063 },
	{ 0xAEA2, 0x6065 },
	{ 0xAEA3, 0x6050 },
	{ 0xAEA4, 0x6055 },
	{ 0xAEA5, 0x606D },
	{ 0xAEA6, 0x6069 },
	{ 0xAEA7, 0x606F },
	{ 0xAEA8, 0x6084 },
	{ 0xAEA9, 0x609F },
	{ 0xAEAA, 0x609A },
	{ 0xAEAB, 0x608D },
	{ 0xAEAC, 0x6094 },
	{ 0xAEAD, 0x608C },
	{ 0xAEAE, 0x6085 },
	{ 0xAEAF, 0x6096 },
	{ 0xAEB0, 0x6247 },
	{ 0xAEB1, 0x62F3 },
	{ 0xAEB2, 0x6308 },
	{ 0xAEB3, 0x62FF },
	{ 0xAEB4, 0x634E },
	{ 0xAEB5, 0x633E },
	{ 0xAEB6, 0x632F },
	{ 0xAEB7, 0x6355 },
	{ 0xAEB8, 0x6342 },
	{ 0xAEB9, 0x6346 },
	{ 0xAEBA, 0x634F },
	{ 0xAEBB, 0x6349 },
	{ 0xAEBC, 0x633A },
	{ 0xAEBD, 0x6350 },
	{ 0xAEBE, 0x633D },
	{ 0xAEBF, 0x632A },
	{ 0xAEC0, 0x632B },
	{ 0xAEC1, 0x6328 },
	{ 0xAEC2, 0x634D },
	{ 0xAEC3, 0x634C },
	{ 0xAEC4, 0x6548 },
	{ 0xAEC5, 0x6549 },
	{ 0xAEC6, 0x6599 },
	{ 0xAEC7, 0x65C1 },
	{ 0xAEC8, 0x65C5 },
	{ 0xAEC9, 0x6642 },
	{ 0xAECA, 0x6649 },
	{ 0xAECB, 0x664F },
	{ 0xAECC, 0x6643 },
	{ 0xAECD, 0x6652 },
	{ 0xAECE, 0x664C },
	{ 0xAECF, 0x6645 },
	{ 0xAED0, 0x6641 },
	{ 0xAED1, 0x66F8 },
	{ 0xAED2, 0x6714 },
	{ 0xAED3, 0x6715 },
	{ 0xAED4, 0x6717 },
	{ 0xAED5, 0x6821 },
	{ 0xAED6, 0x6838 },
	{ 0xAED7, 0x6848 },
	{ 0xAED8, 0x6846 },
	{ 0xAED9, 0x6853 },
	{ 0xAEDA, 0x6839 },
	{ 0xAEDB, 0x6842 },
	{ 0xAEDC, 0x6854 },
	{ 0xAEDD, 0x6829 },
	{ 0xAEDE, 0x68B3 },
	{ 0xAEDF, 0x6817 },
	{ 0xAEE0, 0x684C },
	{ 0xAEE1, 0x6851 },
	{ 0xAEE2, 0x683D },
	{ 0xAEE3, 0x67F4 },
	{ 0xAEE4, 0x6850 },
	{ 0xAEE5, 0x6840 },
	{ 0xAEE6, 0x683C },
	{ 0xAEE7, 0x6843 },
	{ 0xAEE8, 0x682A },
	{ 0xAEE9, 0x6845 },
	{ 0xAEEA, 0x6813 },
	{ 0xAEEB, 0x6818 },
	{ 0xAEEC, 0x6841 },
	{ 0xAEED, 0x6B8A },
	{ 0xAEEE, 0x6B89 },
	{ 0xAEEF, 0x6BB7 },
	{ 0xAEF0, 0x6C23 },
	{ 0xAEF1, 0x6C27 },
	{ 0xAEF2, 0x6C28 },
	{ 0xAEF3, 0x6C26 },
	{ 0xAEF4, 0x6C24 },
	{ 0xAEF5, 0x6CF0 },
	{ 0xAEF6, 0x6D6A },
	{ 0xAEF7, 0x6D95 },
	{ 0xAEF8, 0x6D88 },
	{ 0xAEF9, 0x6D87 },
	{ 0xAEFA, 0x6D66 },
	{ 0xAEFB, 0x6D78 },
	{ 0xAEFC, 0x6D77 },
	{ 0xAEFD, 0x6D59 },
	{ 0xAEFE, 0x6D93 },
	{ 0xAF40, 0x6D6C },
	{ 0xAF41, 0x6D89 },
	{ 0xAF42, 0x6D6E },
	{ 0xAF43, 0x6D5A },
	{ 0xAF44, 0x6D74 },
	{ 0xAF45, 0x6D69 },
	{ 0xAF46, 0x6D8C },
	{ 0xAF47, 0x6D8A },
	{ 0xAF48, 0x6D79 },
	{ 0xAF49, 0x6D85 },
	{ 0xAF4A, 0x6D65 },
	{ 0xAF4B, 0x6D94 },
	{ 0xAF4C, 0x70CA },
	{ 0xAF4D, 0x70D8 },
	{ 0xAF4E, 0x70E4 },
	{ 0xAF4F, 0x70D9 },
	{ 0xAF50, 0x70C8 },
	{ 0xAF51, 0x70CF },
	{ 0xAF52, 0x7239 },
	{ 0xAF53, 0x7279 },
	{ 0xAF54, 0x72FC },
	{ 0xAF55, 0x72F9 },
	{ 0xAF56, 0x72FD },
	{ 0xAF57, 0x72F8 },
	{ 0xAF58, 0x72F7 },
	{ 0xAF59, 0x7386 },
	{ 0xAF5A, 0x73ED },
	{ 0xAF5B, 0x7409 },
	{ 0xAF5C, 0x73EE },
	{ 0xAF5D, 0x73E0 },
	{ 0xAF5E, 0x73EA },
	{ 0xAF5F, 0x73DE },
	{ 0xAF60, 0x7554 },
	{ 0xAF61, 0x755D },
	{ 0xAF62, 0x755C },
	{ 0xAF63, 0x755A },
	{ 0xAF64, 0x7559 },
	{ 0xAF65, 0x75BE },
	{ 0xAF66, 0x75C5 },
	{ 0xAF67, 0x75C7 },
	{ 0xAF68, 0x75B2 },
	{ 0xAF69, 0x75B3 },
	{ 0xAF6A, 0x75BD },
	{ 0xAF6B, 0x75BC },
	{ 0xAF6C, 0x75B9 },
	{ 0xAF6D, 0x75C2 },
	{ 0xAF6E, 0x75B8 },
	{ 0xAF6F, 0x768B },
	{ 0xAF70, 0x76B0 },
	{ 0xAF71, 0x76CA },
	{ 0xAF72, 0x76CD },
	{ 0xAF73, 0x76CE },
	{ 0xAF74, 0x7729 },
	{ 0xAF75, 0x771F },
	{ 0xAF76, 0x7720 },
	{ 0xAF77, 0x7728 },
	{ 0xAF78, 0x77E9 },
	{ 0xAF79, 0x7830 },
	{ 0xAF7A, 0x7827 },
	{ 0xAF7B, 0x7838 },
	{ 0xAF7C, 0x781D },
	{ 0xAF7D, 0x7834 },
	{ 0xAF7E, 0x7837 },
	{ 0xAF7F, 0xFFFD },
	{ 0xAF80, 0x9013 },
	{ 0xAF81, 0x90EE },
	{ 0xAF82, 0x90AB },
	{ 0xAF83, 0x90F7 },
	{ 0xAF84, 0x9159 },
	{ 0xAF85, 0x9154 },
	{ 0xAF86, 0x91F2 },
	{ 0xAF87, 0x91F0 },
	{ 0xAF88, 0x91E5 },
	{ 0xAF89, 0x91F6 },
	{ 0xAF8A, 0x9587 },
	{ 0xAF8B, 0x965A },
	{ 0xAF8C, 0x966E },
	{ 0xAF8D, 0x9679 },
	{ 0xAF8E, 0x98E1 },
	{ 0xAF8F, 0x98E6 },
	{ 0xAF90, 0x9EC4 },
	{ 0xAF91, 0x9ED2 },
	{ 0xAF92, 0x4E80 },
	{ 0xAF93, 0x4E81 },
	{ 0xAF94, 0x508F },
	{ 0xAF95, 0x5097 },
	{ 0xAF96, 0x5088 },
	{ 0xAF97, 0x5089 },
	{ 0xAF98, 0x5081 },
	{ 0xAF99, 0x5160 },
	{ 0xAF9A, 0x5E42 },
	{ 0xAF9B, 0x51D3 },
	{ 0xAF9C, 0x51D2 },
	{ 0xAF9D, 0x51D6 },
	{ 0xAF9E, 0x5273 },
	{ 0xAF9F, 0x5270 },
	{ 0xAFA0, 0x53A8 },
	{ 0xAFA1, 0x7825 },
	{ 0xAFA2, 0x782D },
	{ 0xAFA3, 0x7820 },
	{ 0xAFA4, 0x781F },
	{ 0xAFA5, 0x7832 },
	{ 0xAFA6, 0x7955 },
	{ 0xAFA7, 0x7950 },
	{ 0xAFA8, 0x7960 },
	{ 0xAFA9, 0x795F },
	{ 0xAFAA, 0x7956 },
	{ 0xAFAB, 0x795E },
	{ 0xAFAC, 0x795D },
	{ 0xAFAD, 0x7957 },
	{ 0xAFAE, 0x795A },
	{ 0xAFAF, 0x79E4 },
	{ 0xAFB0, 0x79E3 },
	{ 0xAFB1, 0x79E7 },
	{ 0xAFB2, 0x79DF },
	{ 0xAFB3, 0x79E6 },
	{ 0xAFB4, 0x79E9 },
	{ 0xAFB5, 0x79D8 },
	{ 0xAFB6, 0x7A84 },
	{ 0xAFB7, 0x7A88 },
	{ 0xAFB8, 0x7AD9 },
	{ 0xAFB9, 0x7B06 },
	{ 0xAFBA, 0x7B11 },
	{ 0xAFBB, 0x7C89 },
	{ 0xAFBC, 0x7D21 },
	{ 0xAFBD, 0x7D17 },
	{ 0xAFBE, 0x7D0B },
	{ 0xAFBF, 0x7D0A },
	{ 0xAFC0, 0x7D20 },
	{ 0xAFC1, 0x7D22 },
	{ 0xAFC2, 0x7D14 },
	{ 0xAFC3, 0x7D10 },
	{ 0xAFC4, 0x7D15 },
	{ 0xAFC5, 0x7D1A },
	{ 0xAFC6, 0x7D1C },
	{ 0xAFC7, 0x7D0D },
	{ 0xAFC8, 0x7D19 },
	{ 0xAFC9, 0x7D1B },
	{ 0xAFCA, 0x7F3A },
	{ 0xAFCB, 0x7F5F },
	{ 0xAFCC, 0x7F94 },
	{ 0xAFCD, 0x7FC5 },
	{ 0xAFCE, 0x7FC1 },
	{ 0xAFCF, 0x8006 },
	{ 0xAFD0, 0x8018 },
	{ 0xAFD1, 0x8015 },
	{ 0xAFD2, 0x8019 },
	{ 0xAFD3, 0x8017 },
	{ 0xAFD4, 0x803D },
	{ 0xAFD5, 0x803F },
	{ 0xAFD6, 0x80F1 },
	{ 0xAFD7, 0x8102 },
	{ 0xAFD8, 0x80F0 },
	{ 0xAFD9, 0x8105 },
	{ 0xAFDA, 0x80ED },
	{ 0xAFDB, 0x80F4 },
	{ 0xAFDC, 0x8106 },
	{ 0xAFDD, 0x80F8 },
	{ 0xAFDE, 0x80F3 },
	{ 0xAFDF, 0x8108 },
	{ 0xAFE0, 0x80FD },
	{ 0xAFE1, 0x810A },
	{ 0xAFE2, 0x80FC },
	{ 0xAFE3, 0x80EF },
	{ 0xAFE4, 0x81ED },
	{ 0xAFE5, 0x81EC },
	{ 0xAFE6, 0x8200 },
	{ 0xAFE7, 0x8210 },
	{ 0xAFE8, 0x822A },
	{ 0xAFE9, 0x822B },
	{ 0xAFEA, 0x8228 },
	{ 0xAFEB, 0x822C },
	{ 0xAFEC, 0x82BB },
	{ 0xAFED, 0x832B },
	{ 0xAFEE, 0x8352 },
	{ 0xAFEF, 0x8354 },
	{ 0xAFF0, 0x834A },
	{ 0xAFF1, 0x8338 },
	{ 0xAFF2, 0x8350 },
	{ 0xAFF3, 0x8349 },
	{ 0xAFF4, 0x8335 },
	{ 0xAFF5, 0x8334 },
	{ 0xAFF6, 0x834F },
	{ 0xAFF7, 0x8332 },
	{ 0xAFF8, 0x8339 },
	{ 0xAFF9, 0x8336 },
	{ 0xAFFA, 0x8317 },
	{ 0xAFFB, 0x8340 },
	{ 0xAFFC, 0x8331 },
	{ 0xAFFD, 0x8328 },
	{ 0xAFFE, 0x8343 },
	{ 0xB040, 0x8654 },
	{ 0xB041, 0x868A },
	{ 0xB042, 0x86AA },
	{ 0xB043, 0x8693 },
	{ 0xB044, 0x86A4 },
	{ 0xB045, 0x86A9 },
	{ 0xB046, 0x868C },
	{ 0xB047, 0x86A3 },
	{ 0xB048, 0x869C },
	{ 0xB049, 0x8870 },
	{ 0xB04A, 0x8877 },
	{ 0xB04B, 0x8881 },
	{ 0xB04C, 0x8882 },
	{ 0xB04D, 0x887D },
	{ 0xB04E, 0x8879 },
	{ 0xB04F, 0x8A18 },
	{ 0xB050, 0x8A10 },
	{ 0xB051, 0x8A0E },
	{ 0xB052, 0x8A0C },
	{ 0xB053, 0x8A15 },
	{ 0xB054, 0x8A0A },
	{ 0xB055, 0x8A17 },
	{ 0xB056, 0x8A13 },
	{ 0xB057, 0x8A16 },
	{ 0xB058, 0x8A0F },
	{ 0xB059, 0x8A11 },
	{ 0xB05A, 0x8C48 },
	{ 0xB05B, 0x8C7A },
	{ 0xB05C, 0x8C79 },
	{ 0xB05D, 0x8CA1 },
	{ 0xB05E, 0x8CA2 },
	{ 0xB05F, 0x8D77 },
	{ 0xB060, 0x8EAC },
	{ 0xB061, 0x8ED2 },
	{ 0xB062, 0x8ED4 },
	{ 0xB063, 0x8ECF },
	{ 0xB064, 0x8FB1 },
	{ 0xB065, 0x9001 },
	{ 0xB066, 0x9006 },
	{ 0xB067, 0x8FF7 },
	{ 0xB068, 0x9000 },
	{ 0xB069, 0x8FFA },
	{ 0xB06A, 0x8FF4 },
	{ 0xB06B, 0x9003 },
	{ 0xB06C, 0x8FFD },
	{ 0xB06D, 0x9005 },
	{ 0xB06E, 0x8FF8 },
	{ 0xB06F, 0x9095 },
	{ 0xB070, 0x90E1 },
	{ 0xB071, 0x90DD },
	{ 0xB072, 0x90E2 },
	{ 0xB073, 0x9152 },
	{ 0xB074, 0x914D },
	{ 0xB075, 0x914C },
	{ 0xB076, 0x91D8 },
	{ 0xB077, 0x91DD },
	{ 0xB078, 0x91D7 },
	{ 0xB079, 0x91DC },
	{ 0xB07A, 0x91D9 },
	{ 0xB07B, 0x9583 },
	{ 0xB07C, 0x9662 },
	{ 0xB07D, 0x9663 },
	{ 0xB07E, 0x9661 },
	{ 0xB07F, 0xFFFD },
	{ 0xB080, 0x53A6 },
	{ 0xB081, 0x53C5 },
	{ 0xB082, 0x5597 },
	{ 0xB083, 0x55DE },
	{ 0xB084, 0x5596 },
	{ 0xB085, 0x55B4 },
	{ 0xB086, 0x5585 },
	{ 0xB087, 0x559B },
	{ 0xB088, 0x55A0 },
	{ 0xB089, 0x5559 },
	{ 0xB08A, 0x5586 },
	{ 0xB08B, 0x55AF },
	{ 0xB08C, 0x557A },
	{ 0xB08D, 0x559E },
	{ 0xB08E, 0x55A9 },
	{ 0xB08F, 0x570F },
	{ 0xB090, 0x570E },
	{ 0xB091, 0x581A },
	{ 0xB092, 0x581F },
	{ 0xB093, 0x583C },
	{ 0xB094, 0x5818 },
	{ 0xB095, 0x583E },
	{ 0xB096, 0x5826 },
	{ 0xB097, 0x583A },
	{ 0xB098, 0x5822 },
	{ 0xB099, 0x58FB },
	{ 0xB09A, 0x5963 },
	{ 0xB09B, 0x5964 },
	{ 0xB09C, 0x5AA8 },
	{ 0xB09D, 0x5AA3 },
	{ 0xB09E, 0x5A82 },
	{ 0xB09F, 0x5A88 },
	{ 0xB0A0, 0x5AA1 },
	{ 0xB0A1, 0x965B },
	{ 0xB0A2, 0x965D },
	{ 0xB0A3, 0x9664 },
	{ 0xB0A4, 0x9658 },
	{ 0xB0A5, 0x965E },
	{ 0xB0A6, 0x96BB },
	{ 0xB0A7, 0x98E2 },
	{ 0xB0A8, 0x99AC },
	{ 0xB0A9, 0x9AA8 },
	{ 0xB0AA, 0x9AD8 },
	{ 0xB0AB, 0x9B25 },
	{ 0xB0AC, 0x9B32 },
	{ 0xB0AD, 0x9B3C },
	{ 0xB0AE, 0x4E7E },
	{ 0xB0AF, 0x507A },
	{ 0xB0B0, 0x507D },
	{ 0xB0B1, 0x505C },
	{ 0xB0B2, 0x5047 },
	{ 0xB0B3, 0x5043 },
	{ 0xB0B4, 0x504C },
	{ 0xB0B5, 0x505A },
	{ 0xB0B6, 0x5049 },
	{ 0xB0B7, 0x5065 },
	{ 0xB0B8, 0x5076 },
	{ 0xB0B9, 0x504E },
	{ 0xB0BA, 0x5055 },
	{ 0xB0BB, 0x5075 },
	{ 0xB0BC, 0x5074 },
	{ 0xB0BD, 0x5077 },
	{ 0xB0BE, 0x504F },
	{ 0xB0BF, 0x500F },
	{ 0xB0C0, 0x506F },
	{ 0xB0C1, 0x506D },
	{ 0xB0C2, 0x515C },
	{ 0xB0C3, 0x5195 },
	{ 0xB0C4, 0x51F0 },
	{ 0xB0C5, 0x526A },
	{ 0xB0C6, 0x526F },
	{ 0xB0C7, 0x52D2 },
	{ 0xB0C8, 0x52D9 },
	{ 0xB0C9, 0x52D8 },
	{ 0xB0CA, 0x52D5 },
	{ 0xB0CB, 0x5310 },
	{ 0xB0CC, 0x530F },
	{ 0xB0CD, 0x5319 },
	{ 0xB0CE, 0x533F },
	{ 0xB0CF, 0x5340 },
	{ 0xB0D0, 0x533E },
	{ 0xB0D1, 0x53C3 },
	{ 0xB0D2, 0x66FC },
	{ 0xB0D3, 0x5546 },
	{ 0xB0D4, 0x556A },
	{ 0xB0D5, 0x5566 },
	{ 0xB0D6, 0x5544 },
	{ 0xB0D7, 0x555E },
	{ 0xB0D8, 0x5561 },
	{ 0xB0D9, 0x5543 },
	{ 0xB0DA, 0x554A },
	{ 0xB0DB, 0x5531 },
	{ 0xB0DC, 0x5556 },
	{ 0xB0DD, 0x554F },
	{ 0xB0DE, 0x5555 },
	{ 0xB0DF, 0x552F },
	{ 0xB0E0, 0x5564 },
	{ 0xB0E1, 0x5538 },
	{ 0xB0E2, 0x552E },
	{ 0xB0E3, 0x555C },
	{ 0xB0E4, 0x552C },
	{ 0xB0E5, 0x5563 },
	{ 0xB0E6, 0x5533 },
	{ 0xB0E7, 0x5541 },
	{ 0xB0E8, 0x5557 },
	{ 0xB0E9, 0x5708 },
	{ 0xB0EA, 0x570B },
	{ 0xB0EB, 0x5709 },
	{ 0xB0EC, 0x57DF },
	{ 0xB0ED, 0x5805 },
	{ 0xB0EE, 0x580A },
	{ 0xB0EF, 0x5806 },
	{ 0xB0F0, 0x57E0 },
	{ 0xB0F1, 0x57E4 },
	{ 0xB0F2, 0x57FA },
	{ 0xB0F3, 0x5802 },
	{ 0xB0F4, 0x5835 },
	{ 0xB0F5, 0x57F7 },
	{ 0xB0F6, 0x57F9 },
	{ 0xB0F7, 0x5920 },
	{ 0xB0F8, 0x5962 },
	{ 0xB0F9, 0x5A36 },
	{ 0xB0FA, 0x5A41 },
	{ 0xB0FB, 0x5A49 },
	{ 0xB0FC, 0x5A66 },
	{ 0xB0FD, 0x5A6A },
	{ 0xB0FE, 0x5A40 },
	{ 0xB140, 0x5A3C },
	{ 0xB141, 0x5A62 },
	{ 0xB142, 0x5A5A },
	{ 0xB143, 0x5A46 },
	{ 0xB144, 0x5A4A },
	{ 0xB145, 0x5B70 },
	{ 0xB146, 0x5BC7 },
	{ 0xB147, 0x5BC5 },
	{ 0xB148, 0x5BC4 },
	{ 0xB149, 0x5BC2 },
	{ 0xB14A, 0x5BBF },
	{ 0xB14B, 0x5BC6 },
	{ 0xB14C, 0x5C09 },
	{ 0xB14D, 0x5C08 },
	{ 0xB14E, 0x5C07 },
	{ 0xB14F, 0x5C60 },
	{ 0xB150, 0x5C5C },
	{ 0xB151, 0x5C5D },
	{ 0xB152, 0x5D07 },
	{ 0xB153, 0x5D06 },
	{ 0xB154, 0x5D0E },
	{ 0xB155, 0x5D1B },
	{ 0xB156, 0x5D16 },
	{ 0xB157, 0x5D22 },
	{ 0xB158, 0x5D11 },
	{ 0xB159, 0x5D29 },
	{ 0xB15A, 0x5D14 },
	{ 0xB15B, 0x5D19 },
	{ 0xB15C, 0x5D24 },
	{ 0xB15D, 0x5D27 },
	{ 0xB15E, 0x5D17 },
	{ 0xB15F, 0x5DE2 },
	{ 0xB160, 0x5E38 },
	{ 0xB161, 0x5E36 },
	{ 0xB162, 0x5E33 },
	{ 0xB163, 0x5E37 },
	{ 0xB164, 0x5EB7 },
	{ 0xB165, 0x5EB8 },
	{ 0xB166, 0x5EB6 },
	{ 0xB167, 0x5EB5 },
	{ 0xB168, 0x5EBE },
	{ 0xB169, 0x5F35 },
	{ 0xB16A, 0x5F37 },
	{ 0xB16B, 0x5F57 },
	{ 0xB16C, 0x5F6C },
	{ 0xB16D, 0x5F69 },
	{ 0xB16E, 0x5F6B },
	{ 0xB16F, 0x5F97 },
	{ 0xB170, 0x5F99 },
	{ 0xB171, 0x5F9E },
	{ 0xB172, 0x5F98 },
	{ 0xB173, 0x5FA1 },
	{ 0xB174, 0x5FA0 },
	{ 0xB175, 0x5F9C },
	{ 0xB176, 0x607F },
	{ 0xB177, 0x60A3 },
	{ 0xB178, 0x6089 },
	{ 0xB179, 0x60A0 },
	{ 0xB17A, 0x60A8 },
	{ 0xB17B, 0x60CB },
	{ 0xB17C, 0x60B4 },
	{ 0xB17D, 0x60E6 },
	{ 0xB17E, 0x60BD },
	{ 0xB17F, 0xFFFD },
	{ 0xB180, 0x5A85 },
	{ 0xB181, 0x5A98 },
	{ 0xB182, 0x5A99 },
	{ 0xB183, 0x5A89 },
	{ 0xB184, 0x5A81 },
	{ 0xB185, 0x5A96 },
	{ 0xB186, 0x5A80 },
	{ 0xB187, 0x5A91 },
	{ 0xB188, 0x5ACF },
	{ 0xB189, 0x5A87 },
	{ 0xB18A, 0x5AA0 },
	{ 0xB18B, 0x5A79 },
	{ 0xB18C, 0x5A86 },
	{ 0xB18D, 0x5AAB },
	{ 0xB18E, 0x5AAA },
	{ 0xB18F, 0x5AA4 },
	{ 0xB190, 0x5A8D },
	{ 0xB191, 0x5A7E },
	{ 0xB192, 0x5BD5 },
	{ 0xB193, 0x5C1E },
	{ 0xB194, 0x5C5F },
	{ 0xB195, 0x5C5E },
	{ 0xB196, 0x5D44 },
	{ 0xB197, 0x5D3E },
	{ 0xB198, 0x5D48 },
	{ 0xB199, 0x5D1C },
	{ 0xB19A, 0x5D5B },
	{ 0xB19B, 0x5D4D },
	{ 0xB19C, 0x5D57 },
	{ 0xB19D, 0x5D53 },
	{ 0xB19E, 0x5D4F },
	{ 0xB19F, 0x5D3B },
	{ 0xB1A0, 0x5D46 },
	{ 0xB1A1, 0x60C5 },
	{ 0xB1A2, 0x60BB },
	{ 0xB1A3, 0x60B5 },
	{ 0xB1A4, 0x60DC },
	{ 0xB1A5, 0x60BC },
	{ 0xB1A6, 0x60D8 },
	{ 0xB1A7, 0x60D5 },
	{ 0xB1A8, 0x60C6 },
	{ 0xB1A9, 0x60DF },
	{ 0xB1AA, 0x60B8 },
	{ 0xB1AB, 0x60DA },
	{ 0xB1AC, 0x60C7 },
	{ 0xB1AD, 0x621A },
	{ 0xB1AE, 0x621B },
	{ 0xB1AF, 0x6248 },
	{ 0xB1B0, 0x63A0 },
	{ 0xB1B1, 0x63A7 },
	{ 0xB1B2, 0x6372 },
	{ 0xB1B3, 0x6396 },
	{ 0xB1B4, 0x63A2 },
	{ 0xB1B5, 0x63A5 },
	{ 0xB1B6, 0x6377 },
	{ 0xB1B7, 0x6367 },
	{ 0xB1B8, 0x6398 },
	{ 0xB1B9, 0x63AA },
	{ 0xB1BA, 0x6371 },
	{ 0xB1BB, 0x63A9 },
	{ 0xB1BC, 0x6389 },
	{ 0xB1BD, 0x6383 },
	{ 0xB1BE, 0x639B },
	{ 0xB1BF, 0x636B },
	{ 0xB1C0, 0x63A8 },
	{ 0xB1C1, 0x6384 },
	{ 0xB1C2, 0x6388 },
	{ 0xB1C3, 0x6399 },
	{ 0xB1C4, 0x63A1 },
	{ 0xB1C5, 0x63AC },
	{ 0xB1C6, 0x6392 },
	{ 0xB1C7, 0x638F },
	{ 0xB1C8, 0x6380 },
	{ 0xB1C9, 0x637B },
	{ 0xB1CA, 0x6369 },
	{ 0xB1CB, 0x6368 },
	{ 0xB1CC, 0x637A },
	{ 0xB1CD, 0x655D },
	{ 0xB1CE, 0x6556 },
	{ 0xB1CF, 0x6551 },
	{ 0xB1D0, 0x6559 },
	{ 0xB1D1, 0x6557 },
	{ 0xB1D2, 0x555F },
	{ 0xB1D3, 0x654F },
	{ 0xB1D4, 0x6558 },
	{ 0xB1D5, 0x6555 },
	{ 0xB1D6, 0x6554 },
	{ 0xB1D7, 0x659C },
	{ 0xB1D8, 0x659B },
	{ 0xB1D9, 0x65AC },
	{ 0xB1DA, 0x65CF },
	{ 0xB1DB, 0x65CB },
	{ 0xB1DC, 0x65CC },
	{ 0xB1DD, 0x65CE },
	{ 0xB1DE, 0x665D },
	{ 0xB1DF, 0x665A },
	{ 0xB1E0, 0x6664 },
	{ 0xB1E1, 0x6668 },
	{ 0xB1E2, 0x6666 },
	{ 0xB1E3, 0x665E },
	{ 0xB1E4, 0x66F9 },
	{ 0xB1E5, 0x52D7 },
	{ 0xB1E6, 0x671B },
	{ 0xB1E7, 0x6881 },
	{ 0xB1E8, 0x68AF },
	{ 0xB1E9, 0x68A2 },
	{ 0xB1EA, 0x6893 },
	{ 0xB1EB, 0x68B5 },
	{ 0xB1EC, 0x687F },
	{ 0xB1ED, 0x6876 },
	{ 0xB1EE, 0x68B1 },
	{ 0xB1EF, 0x68A7 },
	{ 0xB1F0, 0x6897 },
	{ 0xB1F1, 0x68B0 },
	{ 0xB1F2, 0x6883 },
	{ 0xB1F3, 0x68C4 },
	{ 0xB1F4, 0x68AD },
	{ 0xB1F5, 0x6886 },
	{ 0xB1F6, 0x6885 },
	{ 0xB1F7, 0x6894 },
	{ 0xB1F8, 0x689D },
	{ 0xB1F9, 0x68A8 },
	{ 0xB1FA, 0x689F },
	{ 0xB1FB, 0x68A1 },
	{ 0xB1FC, 0x6882 },
	{ 0xB1FD, 0x6B32 },
	{ 0xB1FE, 0x6BBA },
	{ 0xB240, 0x6BEB },
	{ 0xB241, 0x6BEC },
	{ 0xB242, 0x6C2B },
	{ 0xB243, 0x6D8E },
	{ 0xB244, 0x6DBC },
	{ 0xB245, 0x6DF3 },
	{ 0xB246, 0x6DD9 },
	{ 0xB247, 0x6DB2 },
	{ 0xB248, 0x6DE1 },
	{ 0xB249, 0x6DCC },
	{ 0xB24A, 0x6DE4 },
	{ 0xB24B, 0x6DFB },
	{ 0xB24C, 0x6DFA },
	{ 0xB24D, 0x6E05 },
	{ 0xB24E, 0x6DC7 },
	{ 0xB24F, 0x6DCB },
	{ 0xB250, 0x6DAF },
	{ 0xB251, 0x6DD1 },
	{ 0xB252, 0x6DAE },
	{ 0xB253, 0x6DDE },
	{ 0xB254, 0x6DF9 },
	{ 0xB255, 0x6DB8 },
	{ 0xB256, 0x6DF7 },
	{ 0xB257, 0x6DF5 },
	{ 0xB258, 0x6DC5 },
	{ 0xB259, 0x6DD2 },
	{ 0xB25A, 0x6E1A },
	{ 0xB25B, 0x6DB5 },
	{ 0xB25C, 0x6DDA },
	{ 0xB25D, 0x6DEB },
	{ 0xB25E, 0x6DD8 },
	{ 0xB25F, 0x6DEA },
	{ 0xB260, 0x6DF1 },
	{ 0xB261, 0x6DEE },
	{ 0xB262, 0x6DE8 },
	{ 0xB263, 0x6DC6 },
	{ 0xB264, 0x6DC4 },
	{ 0xB265, 0x6DAA },
	{ 0xB266, 0x6DEC },
	{ 0xB267, 0x6DBF },
	{ 0xB268, 0x6DE6 },
	{ 0xB269, 0x70F9 },
	{ 0xB26A, 0x7109 },
	{ 0xB26B, 0x710A },
	{ 0xB26C, 0x70FD },
	{ 0xB26D, 0x70EF },
	{ 0xB26E, 0x723D },
	{ 0xB26F, 0x727D },
	{ 0xB270, 0x7281 },
	{ 0xB271, 0x731C },
	{ 0xB272, 0x731B },
	{ 0xB273, 0x7316 },
	{ 0xB274, 0x7313 },
	{ 0xB275, 0x7319 },
	{ 0xB276, 0x7387 },
	{ 0xB277, 0x7405 },
	{ 0xB278, 0x740A },
	{ 0xB279, 0x7403 },
	{ 0xB27A, 0x7406 },
	{ 0xB27B, 0x73FE },
	{ 0xB27C, 0x740D },
	{ 0xB27D, 0x74E0 },
	{ 0xB27E, 0x74F6 },
	{ 0xB27F, 0xFFFD },
	{ 0xB280, 0x5E46 },
	{ 0xB281, 0x5E47 },
	{ 0xB282, 0x5E48 },
	{ 0xB283, 0x5EC0 },
	{ 0xB284, 0x5EBD },
	{ 0xB285, 0x5EBF },
	{ 0xB286, 0x5F11 },
	{ 0xB287, 0x5F3E },
	{ 0xB288, 0x5F3B },
	{ 0xB289, 0x5F3A },
	{ 0xB28A, 0x5FA7 },
	{ 0xB28B, 0x60EA },
	{ 0xB28C, 0x6107 },
	{ 0xB28D, 0x6122 },
	{ 0xB28E, 0x610C },
	{ 0xB28F, 0x60B3 },
	{ 0xB290, 0x60D6 },
	{ 0xB291, 0x60D2 },
	{ 0xB292, 0x60E3 },
	{ 0xB293, 0x60E5 },
	{ 0xB294, 0x60E9 },
	{ 0xB295, 0x6111 },
	{ 0xB296, 0x60FD },
	{ 0xB297, 0x611E },
	{ 0xB298, 0x6120 },
	{ 0xB299, 0x6121 },
	{ 0xB29A, 0x621E },
	{ 0xB29B, 0x63E2 },
	{ 0xB29C, 0x63DE },
	{ 0xB29D, 0x63E6 },
	{ 0xB29E, 0x63F8 },
	{ 0xB29F, 0x63FE },
	{ 0xB2A0, 0x63C1 },
	{ 0xB2A1, 0x74F7 },
	{ 0xB2A2, 0x751C },
	{ 0xB2A3, 0x7522 },
	{ 0xB2A4, 0x7565 },
	{ 0xB2A5, 0x7566 },
	{ 0xB2A6, 0x7562 },
	{ 0xB2A7, 0x7570 },
	{ 0xB2A8, 0x758F },
	{ 0xB2A9, 0x75D4 },
	{ 0xB2AA, 0x75D5 },
	{ 0xB2AB, 0x75B5 },
	{ 0xB2AC, 0x75CA },
	{ 0xB2AD, 0x75CD },
	{ 0xB2AE, 0x768E },
	{ 0xB2AF, 0x76D4 },
	{ 0xB2B0, 0x76D2 },
	{ 0xB2B1, 0x76DB },
	{ 0xB2B2, 0x7737 },
	{ 0xB2B3, 0x773E },
	{ 0xB2B4, 0x773C },
	{ 0xB2B5, 0x7736 },
	{ 0xB2B6, 0x7738 },
	{ 0xB2B7, 0x773A },
	{ 0xB2B8, 0x786B },
	{ 0xB2B9, 0x7843 },
	{ 0xB2BA, 0x784E },
	{ 0xB2BB, 0x7965 },
	{ 0xB2BC, 0x7968 },
	{ 0xB2BD, 0x796D },
	{ 0xB2BE, 0x79FB },
	{ 0xB2BF, 0x7A92 },
	{ 0xB2C0, 0x7A95 },
	{ 0xB2C1, 0x7B20 },
	{ 0xB2C2, 0x7B28 },
	{ 0xB2C3, 0x7B1B },
	{ 0xB2C4, 0x7B2C },
	{ 0xB2C5, 0x7B26 },
	{ 0xB2C6, 0x7B19 },
	{ 0xB2C7, 0x7B1E },
	{ 0xB2C8, 0x7B2E },
	{ 0xB2C9, 0x7C92 },
	{ 0xB2CA, 0x7C97 },
	{ 0xB2CB, 0x7C95 },
	{ 0xB2CC, 0x7D46 },
	{ 0xB2CD, 0x7D43 },
	{ 0xB2CE, 0x7D71 },
	{ 0xB2CF, 0x7D2E },
	{ 0xB2D0, 0x7D39 },
	{ 0xB2D1, 0x7D3C },
	{ 0xB2D2, 0x7D40 },
	{ 0xB2D3, 0x7D30 },
	{ 0xB2D4, 0x7D33 },
	{ 0xB2D5, 0x7D44 },
	{ 0xB2D6, 0x7D2F },
	{ 0xB2D7, 0x7D42 },
	{ 0xB2D8, 0x7D32 },
	{ 0xB2D9, 0x7D31 },
	{ 0xB2DA, 0x7F3D },
	{ 0xB2DB, 0x7F9E },
	{ 0xB2DC, 0x7F9A },
	{ 0xB2DD, 0x7FCC },
	{ 0xB2DE, 0x7FCE },
	{ 0xB2DF, 0x7FD2 },
	{ 0xB2E0, 0x801C },
	{ 0xB2E1, 0x804A },
	{ 0xB2E2, 0x8046 },
	{ 0xB2E3, 0x812F },
	{ 0xB2E4, 0x8116 },
	{ 0xB2E5, 0x8123 },
	{ 0xB2E6, 0x812B },
	{ 0xB2E7, 0x8129 },
	{ 0xB2E8, 0x8130 },
	{ 0xB2E9, 0x8124 },
	{ 0xB2EA, 0x8202 },
	{ 0xB2EB, 0x8235 },
	{ 0xB2EC, 0x8237 },
	{ 0xB2ED, 0x8236 },
	{ 0xB2EE, 0x8239 },
	{ 0xB2EF, 0x838E },
	{ 0xB2F0, 0x839E },
	{ 0xB2F1, 0x8398 },
	{ 0xB2F2, 0x8378 },
	{ 0xB2F3, 0x83A2 },
	{ 0xB2F4, 0x8396 },
	{ 0xB2F5, 0x83BD },
	{ 0xB2F6, 0x83AB },
	{ 0xB2F7, 0x8392 },
	{ 0xB2F8, 0x838A },
	{ 0xB2F9, 0x8393 },
	{ 0xB2FA, 0x8389 },
	{ 0xB2FB, 0x83A0 },
	{ 0xB2FC, 0x8377 },
	{ 0xB2FD, 0x837B },
	{ 0xB2FE, 0x837C },
	{ 0xB340, 0x8386 },
	{ 0xB341, 0x83A7 },
	{ 0xB342, 0x8655 },
	{ 0xB343, 0x5F6A },
	{ 0xB344, 0x86C7 },
	{ 0xB345, 0x86C0 },
	{ 0xB346, 0x86B6 },
	{ 0xB347, 0x86C4 },
	{ 0xB348, 0x86B5 },
	{ 0xB349, 0x86C6 },
	{ 0xB34A, 0x86CB },
	{ 0xB34B, 0x86B1 },
	{ 0xB34C, 0x86AF },
	{ 0xB34D, 0x86C9 },
	{ 0xB34E, 0x8853 },
	{ 0xB34F, 0x889E },
	{ 0xB350, 0x8888 },
	{ 0xB351, 0x88AB },
	{ 0xB352, 0x8892 },
	{ 0xB353, 0x8896 },
	{ 0xB354, 0x888D },
	{ 0xB355, 0x888B },
	{ 0xB356, 0x8993 },
	{ 0xB357, 0x898F },
	{ 0xB358, 0x8A2A },
	{ 0xB359, 0x8A1D },
	{ 0xB35A, 0x8A23 },
	{ 0xB35B, 0x8A25 },
	{ 0xB35C, 0x8A31 },
	{ 0xB35D, 0x8A2D },
	{ 0xB35E, 0x8A1F },
	{ 0xB35F, 0x8A1B },
	{ 0xB360, 0x8A22 },
	{ 0xB361, 0x8C49 },
	{ 0xB362, 0x8C5A },
	{ 0xB363, 0x8CA9 },
	{ 0xB364, 0x8CAC },
	{ 0xB365, 0x8CAB },
	{ 0xB366, 0x8CA8 },
	{ 0xB367, 0x8CAA },
	{ 0xB368, 0x8CA7 },
	{ 0xB369, 0x8D67 },
	{ 0xB36A, 0x8D66 },
	{ 0xB36B, 0x8DBE },
	{ 0xB36C, 0x8DBA },
	{ 0xB36D, 0x8EDB },
	{ 0xB36E, 0x8EDF },
	{ 0xB36F, 0x9019 },
	{ 0xB370, 0x900D },
	{ 0xB371, 0x901A },
	{ 0xB372, 0x9017 },
	{ 0xB373, 0x9023 },
	{ 0xB374, 0x901F },
	{ 0xB375, 0x901D },
	{ 0xB376, 0x9010 },
	{ 0xB377, 0x9015 },
	{ 0xB378, 0x901E },
	{ 0xB379, 0x9020 },
	{ 0xB37A, 0x900F },
	{ 0xB37B, 0x9022 },
	{ 0xB37C, 0x9016 },
	{ 0xB37D, 0x901B },
	{ 0xB37E, 0x9014 },
	{ 0xB37F, 0xFFFD },
	{ 0xB380, 0x63BF },
	{ 0xB381, 0x63F7 },
	{ 0xB382, 0x63D1 },
	{ 0xB383, 0x655F },
	{ 0xB384, 0x6560 },
	{ 0xB385, 0x6561 },
	{ 0xB386, 0x65D1 },
	{ 0xB387, 0x667D },
	{ 0xB388, 0x666B },
	{ 0xB389, 0x667F },
	{ 0xB38A, 0x6673 },
	{ 0xB38B, 0x6681 },
	{ 0xB38C, 0x666D },
	{ 0xB38D, 0x6669 },
	{ 0xB38E, 0x671E },
	{ 0xB38F, 0x68ED },
	{ 0xB390, 0x6903 },
	{ 0xB391, 0x68FE },
	{ 0xB392, 0x68E5 },
	{ 0xB393, 0x691E },
	{ 0xB394, 0x6902 },
	{ 0xB395, 0x6909 },
	{ 0xB396, 0x68CA },
	{ 0xB397, 0x6900 },
	{ 0xB398, 0x6901 },
	{ 0xB399, 0x6918 },
	{ 0xB39A, 0x68E2 },
	{ 0xB39B, 0x68CF },
	{ 0xB39C, 0x692E },
	{ 0xB39D, 0x68C5 },
	{ 0xB39E, 0x68FF },
	{ 0xB39F, 0x691C },
	{ 0xB3A0, 0x68C3 },
	{ 0xB3A1, 0x90E8 },
	{ 0xB3A2, 0x90ED },
	{ 0xB3A3, 0x90FD },
	{ 0xB3A4, 0x9157 },
	{ 0xB3A5, 0x91CE },
	{ 0xB3A6, 0x91F5 },
	{ 0xB3A7, 0x91E6 },
	{ 0xB3A8, 0x91E3 },
	{ 0xB3A9, 0x91E7 },
	{ 0xB3AA, 0x91ED },
	{ 0xB3AB, 0x91E9 },
	{ 0xB3AC, 0x9589 },
	{ 0xB3AD, 0x966A },
	{ 0xB3AE, 0x9675 },
	{ 0xB3AF, 0x9673 },
	{ 0xB3B0, 0x9678 },
	{ 0xB3B1, 0x9670 },
	{ 0xB3B2, 0x9674 },
	{ 0xB3B3, 0x9676 },
	{ 0xB3B4, 0x9677 },
	{ 0xB3B5, 0x966C },
	{ 0xB3B6, 0x96C0 },
	{ 0xB3B7, 0x96EA },
	{ 0xB3B8, 0x96E9 },
	{ 0xB3B9, 0x7AE0 },
	{ 0xB3BA, 0x7ADF },
	{ 0xB3BB, 0x9802 },
	{ 0xB3BC, 0x9803 },
	{ 0xB3BD, 0x9B5A },
	{ 0xB3BE, 0x9CE5 },
	{ 0xB3BF, 0x9E75 },
	{ 0xB3C0, 0x9E7F },
	{ 0xB3C1, 0x9EA5 },
	{ 0xB3C2, 0x9EBB },
	{ 0xB3C3, 0x50A2 },
	{ 0xB3C4, 0x508D },
	{ 0xB3C5, 0x5085 },
	{ 0xB3C6, 0x5099 },
	{ 0xB3C7, 0x5091 },
	{ 0xB3C8, 0x5080 },
	{ 0xB3C9, 0x5096 },
	{ 0xB3CA, 0x5098 },
	{ 0xB3CB, 0x509A },
	{ 0xB3CC, 0x6700 },
	{ 0xB3CD, 0x51F1 },
	{ 0xB3CE, 0x5272 },
	{ 0xB3CF, 0x5274 },
	{ 0xB3D0, 0x5275 },
	{ 0xB3D1, 0x5269 },
	{ 0xB3D2, 0x52DE },
	{ 0xB3D3, 0x52DD },
	{ 0xB3D4, 0x52DB },
	{ 0xB3D5, 0x535A },
	{ 0xB3D6, 0x53A5 },
	{ 0xB3D7, 0x557B },
	{ 0xB3D8, 0x5580 },
	{ 0xB3D9, 0x55A7 },
	{ 0xB3DA, 0x557C },
	{ 0xB3DB, 0x558A },
	{ 0xB3DC, 0x559D },
	{ 0xB3DD, 0x5598 },
	{ 0xB3DE, 0x5582 },
	{ 0xB3DF, 0x559C },
	{ 0xB3E0, 0x55AA },
	{ 0xB3E1, 0x5594 },
	{ 0xB3E2, 0x5587 },
	{ 0xB3E3, 0x558B },
	{ 0xB3E4, 0x5583 },
	{ 0xB3E5, 0x55B3 },
	{ 0xB3E6, 0x55AE },
	{ 0xB3E7, 0x559F },
	{ 0xB3E8, 0x553E },
	{ 0xB3E9, 0x55B2 },
	{ 0xB3EA, 0x559A },
	{ 0xB3EB, 0x55BB },
	{ 0xB3EC, 0x55AC },
	{ 0xB3ED, 0x55B1 },
	{ 0xB3EE, 0x557E },
	{ 0xB3EF, 0x5589 },
	{ 0xB3F0, 0x55AB },
	{ 0xB3F1, 0x5599 },
	{ 0xB3F2, 0x570D },
	{ 0xB3F3, 0x582F },
	{ 0xB3F4, 0x582A },
	{ 0xB3F5, 0x5834 },
	{ 0xB3F6, 0x5824 },
	{ 0xB3F7, 0x5830 },
	{ 0xB3F8, 0x5831 },
	{ 0xB3F9, 0x5821 },
	{ 0xB3FA, 0x581D },
	{ 0xB3FB, 0x5820 },
	{ 0xB3FC, 0x58F9 },
	{ 0xB3FD, 0x58FA },
	{ 0xB3FE, 0x5960 },
	{ 0xB440, 0x5A77 },
	{ 0xB441, 0x5A9A },
	{ 0xB442, 0x5A7F },
	{ 0xB443, 0x5A92 },
	{ 0xB444, 0x5A9B },
	{ 0xB445, 0x5AA7 },
	{ 0xB446, 0x5B73 },
	{ 0xB447, 0x5B71 },
	{ 0xB448, 0x5BD2 },
	{ 0xB449, 0x5BCC },
	{ 0xB44A, 0x5BD3 },
	{ 0xB44B, 0x5BD0 },
	{ 0xB44C, 0x5C0A },
	{ 0xB44D, 0x5C0B },
	{ 0xB44E, 0x5C31 },
	{ 0xB44F, 0x5D4C },
	{ 0xB450, 0x5D50 },
	{ 0xB451, 0x5D34 },
	{ 0xB452, 0x5D47 },
	{ 0xB453, 0x5DFD },
	{ 0xB454, 0x5E45 },
	{ 0xB455, 0x5E3D },
	{ 0xB456, 0x5E40 },
	{ 0xB457, 0x5E43 },
	{ 0xB458, 0x5E7E },
	{ 0xB459, 0x5ECA },
	{ 0xB45A, 0x5EC1 },
	{ 0xB45B, 0x5EC2 },
	{ 0xB45C, 0x5EC4 },
	{ 0xB45D, 0x5F3C },
	{ 0xB45E, 0x5F6D },
	{ 0xB45F, 0x5FA9 },
	{ 0xB460, 0x5FAA },
	{ 0xB461, 0x5FA8 },
	{ 0xB462, 0x60D1 },
	{ 0xB463, 0x60E1 },
	{ 0xB464, 0x60B2 },
	{ 0xB465, 0x60B6 },
	{ 0xB466, 0x60E0 },
	{ 0xB467, 0x611C },
	{ 0xB468, 0x6123 },
	{ 0xB469, 0x60FA },
	{ 0xB46A, 0x6115 },
	{ 0xB46B, 0x60F0 },
	{ 0xB46C, 0x60FB },
	{ 0xB46D, 0x60F4 },
	{ 0xB46E, 0x6168 },
	{ 0xB46F, 0x60F1 },
	{ 0xB470, 0x610E },
	{ 0xB471, 0x60F6 },
	{ 0xB472, 0x6109 },
	{ 0xB473, 0x6100 },
	{ 0xB474, 0x6112 },
	{ 0xB475, 0x621F },
	{ 0xB476, 0x6249 },
	{ 0xB477, 0x63A3 },
	{ 0xB478, 0x638C },
	{ 0xB479, 0x63CF },
	{ 0xB47A, 0x63C0 },
	{ 0xB47B, 0x63E9 },
	{ 0xB47C, 0x63C9 },
	{ 0xB47D, 0x63C6 },
	{ 0xB47E, 0x63CD },
	{ 0xB47F, 0xFFFD },
	{ 0xB480, 0x6B6F },
	{ 0xB481, 0x6B6E },
	{ 0xB482, 0x6BBE },
	{ 0xB483, 0x6BF4 },
	{ 0xB484, 0x6C2D },
	{ 0xB485, 0x6DB6 },
	{ 0xB486, 0x6E75 },
	{ 0xB487, 0x6E1E },
	{ 0xB488, 0x6E18 },
	{ 0xB489, 0x6E48 },
	{ 0xB48A, 0x6E4F },
	{ 0xB48B, 0x6E42 },
	{ 0xB48C, 0x6E6A },
	{ 0xB48D, 0x6E70 },
	{ 0xB48E, 0x6DFE },
	{ 0xB48F, 0x6E6D },
	{ 0xB490, 0x6E7B },
	{ 0xB491, 0x6E7E },
	{ 0xB492, 0x6E59 },
	{ 0xB493, 0x6E57 },
	{ 0xB494, 0x6E80 },
	{ 0xB495, 0x6E50 },
	{ 0xB496, 0x6E29 },
	{ 0xB497, 0x6E76 },
	{ 0xB498, 0x6E2A },
	{ 0xB499, 0x6E4C },
	{ 0xB49A, 0x712A },
	{ 0xB49B, 0x7135 },
	{ 0xB49C, 0x712C },
	{ 0xB49D, 0x7137 },
	{ 0xB49E, 0x711D },
	{ 0xB49F, 0x7138 },
	{ 0xB4A0, 0x7134 },
	{ 0xB4A1, 0x63D2 },
	{ 0xB4A2, 0x63E3 },
	{ 0xB4A3, 0x63D0 },
	{ 0xB4A4, 0x63E1 },
	{ 0xB4A5, 0x63D6 },
	{ 0xB4A6, 0x63ED },
	{ 0xB4A7, 0x63EE },
	{ 0xB4A8, 0x6376 },
	{ 0xB4A9, 0x63F4 },
	{ 0xB4AA, 0x63EA },
	{ 0xB4AB, 0x63DB },
	{ 0xB4AC, 0x6452 },
	{ 0xB4AD, 0x63DA },
	{ 0xB4AE, 0x63F9 },
	{ 0xB4AF, 0x655E },
	{ 0xB4B0, 0x6566 },
	{ 0xB4B1, 0x6562 },
	{ 0xB4B2, 0x6563 },
	{ 0xB4B3, 0x6591 },
	{ 0xB4B4, 0x6590 },
	{ 0xB4B5, 0x65AF },
	{ 0xB4B6, 0x666E },
	{ 0xB4B7, 0x6670 },
	{ 0xB4B8, 0x6674 },
	{ 0xB4B9, 0x6676 },
	{ 0xB4BA, 0x666F },
	{ 0xB4BB, 0x6691 },
	{ 0xB4BC, 0x667A },
	{ 0xB4BD, 0x667E },
	{ 0xB4BE, 0x6677 },
	{ 0xB4BF, 0x66FE },
	{ 0xB4C0, 0x66FF },
	{ 0xB4C1, 0x671F },
	{ 0xB4C2, 0x671D },
	{ 0xB4C3, 0x68FA },
	{ 0xB4C4, 0x68D5 },
	{ 0xB4C5, 0x68E0 },
	{ 0xB4C6, 0x68D8 },
	{ 0xB4C7, 0x68D7 },
	{ 0xB4C8, 0x6905 },
	{ 0xB4C9, 0x68DF },
	{ 0xB4CA, 0x68F5 },
	{ 0xB4CB, 0x68EE },
	{ 0xB4CC, 0x68E7 },
	{ 0xB4CD, 0x68F9 },
	{ 0xB4CE, 0x68D2 },
	{ 0xB4CF, 0x68F2 },
	{ 0xB4D0, 0x68E3 },
	{ 0xB4D1, 0x68CB },
	{ 0xB4D2, 0x68CD },
	{ 0xB4D3, 0x690D },
	{ 0xB4D4, 0x6912 },
	{ 0xB4D5, 0x690E },
	{ 0xB4D6, 0x68C9 },
	{ 0xB4D7, 0x68DA },
	{ 0xB4D8, 0x696E },
	{ 0xB4D9, 0x68FB },
	{ 0xB4DA, 0x6B3E },
	{ 0xB4DB, 0x6B3A },
	{ 0xB4DC, 0x6B3D },
	{ 0xB4DD, 0x6B98 },
	{ 0xB4DE, 0x6B96 },
	{ 0xB4DF, 0x6BBC },
	{ 0xB4E0, 0x6BEF },
	{ 0xB4E1, 0x6C2E },
	{ 0xB4E2, 0x6C2F },
	{ 0xB4E3, 0x6C2C },
	{ 0xB4E4, 0x6E2F },
	{ 0xB4E5, 0x6E38 },
	{ 0xB4E6, 0x6E54 },
	{ 0xB4E7, 0x6E21 },
	{ 0xB4E8, 0x6E32 },
	{ 0xB4E9, 0x6E67 },
	{ 0xB4EA, 0x6E4A },
	{ 0xB4EB, 0x6E20 },
	{ 0xB4EC, 0x6E25 },
	{ 0xB4ED, 0x6E23 },
	{ 0xB4EE, 0x6E1B },
	{ 0xB4EF, 0x6E5B },
	{ 0xB4F0, 0x6E58 },
	{ 0xB4F1, 0x6E24 },
	{ 0xB4F2, 0x6E56 },
	{ 0xB4F3, 0x6E6E },
	{ 0xB4F4, 0x6E2D },
	{ 0xB4F5, 0x6E26 },
	{ 0xB4F6, 0x6E6F },
	{ 0xB4F7, 0x6E34 },
	{ 0xB4F8, 0x6E4D },
	{ 0xB4F9, 0x6E3A },
	{ 0xB4FA, 0x6E2C },
	{ 0xB4FB, 0x6E43 },
	{ 0xB4FC, 0x6E1D },
	{ 0xB4FD, 0x6E3E },
	{ 0xB4FE, 0x6ECB },
	{ 0xB540, 0x6E89 },
	{ 0xB541, 0x6E19 },
	{ 0xB542, 0x6E4E },
	{ 0xB543, 0x6E63 },
	{ 0xB544, 0x6E44 },
	{ 0xB545, 0x6E72 },
	{ 0xB546, 0x6E69 },
	{ 0xB547, 0x6E5F },
	{ 0xB548, 0x7119 },
	{ 0xB549, 0x711A },
	{ 0xB54A, 0x7126 },
	{ 0xB54B, 0x7130 },
	{ 0xB54C, 0x7121 },
	{ 0xB54D, 0x7136 },
	{ 0xB54E, 0x716E },
	{ 0xB54F, 0x711C },
	{ 0xB550, 0x724C },
	{ 0xB551, 0x7284 },
	{ 0xB552, 0x7280 },
	{ 0xB553, 0x7336 },
	{ 0xB554, 0x7325 },
	{ 0xB555, 0x7334 },
	{ 0xB556, 0x7329 },
	{ 0xB557, 0x743A },
	{ 0xB558, 0x742A },
	{ 0xB559, 0x7433 },
	{ 0xB55A, 0x7422 },
	{ 0xB55B, 0x7425 },
	{ 0xB55C, 0x7435 },
	{ 0xB55D, 0x7436 },
	{ 0xB55E, 0x7434 },
	{ 0xB55F, 0x742F },
	{ 0xB560, 0x741B },
	{ 0xB561, 0x7426 },
	{ 0xB562, 0x7428 },
	{ 0xB563, 0x7525 },
	{ 0xB564, 0x7526 },
	{ 0xB565, 0x756B },
	{ 0xB566, 0x756A },
	{ 0xB567, 0x75E2 },
	{ 0xB568, 0x75DB },
	{ 0xB569, 0x75E3 },
	{ 0xB56A, 0x75D9 },
	{ 0xB56B, 0x75D8 },
	{ 0xB56C, 0x75DE },
	{ 0xB56D, 0x75E0 },
	{ 0xB56E, 0x767B },
	{ 0xB56F, 0x767C },
	{ 0xB570, 0x7696 },
	{ 0xB571, 0x7693 },
	{ 0xB572, 0x76B4 },
	{ 0xB573, 0x76DC },
	{ 0xB574, 0x774F },
	{ 0xB575, 0x77ED },
	{ 0xB576, 0x785D },
	{ 0xB577, 0x786C },
	{ 0xB578, 0x786F },
	{ 0xB579, 0x7A0D },
	{ 0xB57A, 0x7A08 },
	{ 0xB57B, 0x7A0B },
	{ 0xB57C, 0x7A05 },
	{ 0xB57D, 0x7A00 },
	{ 0xB57E, 0x7A98 },
	{ 0xB57F, 0xFFFD },
	{ 0xB580, 0x712B },
	{ 0xB581, 0x7133 },
	{ 0xB582, 0x7127 },
	{ 0xB583, 0x7124 },
	{ 0xB584, 0x712D },
	{ 0xB585, 0x7232 },
	{ 0xB586, 0x7283 },
	{ 0xB587, 0x7282 },
	{ 0xB588, 0x7287 },
	{ 0xB589, 0x7306 },
	{ 0xB58A, 0x7324 },
	{ 0xB58B, 0x7338 },
	{ 0xB58C, 0x732A },
	{ 0xB58D, 0x732C },
	{ 0xB58E, 0x732B },
	{ 0xB58F, 0x732F },
	{ 0xB590, 0x7328 },
	{ 0xB591, 0x7417 },
	{ 0xB592, 0x7419 },
	{ 0xB593, 0x7438 },
	{ 0xB594, 0x741F },
	{ 0xB595, 0x7414 },
	{ 0xB596, 0x743C },
	{ 0xB597, 0x73F7 },
	{ 0xB598, 0x741C },
	{ 0xB599, 0x7415 },
	{ 0xB59A, 0x7418 },
	{ 0xB59B, 0x7439 },
	{ 0xB59C, 0x74F9 },
	{ 0xB59D, 0x7524 },
	{ 0xB59E, 0x756E },
	{ 0xB59F, 0x756D },
	{ 0xB5A0, 0x7571 },
	{ 0xB5A1, 0x7A97 },
	{ 0xB5A2, 0x7A96 },
	{ 0xB5A3, 0x7AE5 },
	{ 0xB5A4, 0x7AE3 },
	{ 0xB5A5, 0x7B49 },
	{ 0xB5A6, 0x7B56 },
	{ 0xB5A7, 0x7B46 },
	{ 0xB5A8, 0x7B50 },
	{ 0xB5A9, 0x7B52 },
	{ 0xB5AA, 0x7B54 },
	{ 0xB5AB, 0x7B4D },
	{ 0xB5AC, 0x7B4B },
	{ 0xB5AD, 0x7B4F },
	{ 0xB5AE, 0x7B51 },
	{ 0xB5AF, 0x7C9F },
	{ 0xB5B0, 0x7CA5 },
	{ 0xB5B1, 0x7D5E },
	{ 0xB5B2, 0x7D50 },
	{ 0xB5B3, 0x7D68 },
	{ 0xB5B4, 0x7D55 },
	{ 0xB5B5, 0x7D2B },
	{ 0xB5B6, 0x7D6E },
	{ 0xB5B7, 0x7D72 },
	{ 0xB5B8, 0x7D61 },
	{ 0xB5B9, 0x7D66 },
	{ 0xB5BA, 0x7D62 },
	{ 0xB5BB, 0x7D70 },
	{ 0xB5BC, 0x7D73 },
	{ 0xB5BD, 0x5584 },
	{ 0xB5BE, 0x7FD4 },
	{ 0xB5BF, 0x7FD5 },
	{ 0xB5C0, 0x800B },
	{ 0xB5C1, 0x8052 },
	{ 0xB5C2, 0x8085 },
	{ 0xB5C3, 0x8155 },
	{ 0xB5C4, 0x8154 },
	{ 0xB5C5, 0x814B },
	{ 0xB5C6, 0x8151 },
	{ 0xB5C7, 0x814E },
	{ 0xB5C8, 0x8139 },
	{ 0xB5C9, 0x8146 },
	{ 0xB5CA, 0x813E },
	{ 0xB5CB, 0x814C },
	{ 0xB5CC, 0x8153 },
	{ 0xB5CD, 0x8174 },
	{ 0xB5CE, 0x8212 },
	{ 0xB5CF, 0x821C },
	{ 0xB5D0, 0x83E9 },
	{ 0xB5D1, 0x8403 },
	{ 0xB5D2, 0x83F8 },
	{ 0xB5D3, 0x840D },
	{ 0xB5D4, 0x83E0 },
	{ 0xB5D5, 0x83C5 },
	{ 0xB5D6, 0x840B },
	{ 0xB5D7, 0x83C1 },
	{ 0xB5D8, 0x83EF },
	{ 0xB5D9, 0x83F1 },
	{ 0xB5DA, 0x83F4 },
	{ 0xB5DB, 0x8457 },
	{ 0xB5DC, 0x840A },
	{ 0xB5DD, 0x83F0 },
	{ 0xB5DE, 0x840C },
	{ 0xB5DF, 0x83CC },
	{ 0xB5E0, 0x83FD },
	{ 0xB5E1, 0x83F2 },
	{ 0xB5E2, 0x83CA },
	{ 0xB5E3, 0x8438 },
	{ 0xB5E4, 0x840E },
	{ 0xB5E5, 0x8404 },
	{ 0xB5E6, 0x83DC },
	{ 0xB5E7, 0x8407 },
	{ 0xB5E8, 0x83D4 },
	{ 0xB5E9, 0x83DF },
	{ 0xB5EA, 0x865B },
	{ 0xB5EB, 0x86DF },
	{ 0xB5EC, 0x86D9 },
	{ 0xB5ED, 0x86ED },
	{ 0xB5EE, 0x86D4 },
	{ 0xB5EF, 0x86DB },
	{ 0xB5F0, 0x86E4 },
	{ 0xB5F1, 0x86D0 },
	{ 0xB5F2, 0x86DE },
	{ 0xB5F3, 0x8857 },
	{ 0xB5F4, 0x88C1 },
	{ 0xB5F5, 0x88C2 },
	{ 0xB5F6, 0x88B1 },
	{ 0xB5F7, 0x8983 },
	{ 0xB5F8, 0x8996 },
	{ 0xB5F9, 0x8A3B },
	{ 0xB5FA, 0x8A60 },
	{ 0xB5FB, 0x8A55 },
	{ 0xB5FC, 0x8A5E },
	{ 0xB5FD, 0x8A3C },
	{ 0xB5FE, 0x8A41 },
	{ 0xB640, 0x8A54 },
	{ 0xB641, 0x8A5B },
	{ 0xB642, 0x8A50 },
	{ 0xB643, 0x8A46 },
	{ 0xB644, 0x8A34 },
	{ 0xB645, 0x8A3A },
	{ 0xB646, 0x8A36 },
	{ 0xB647, 0x8A56 },
	{ 0xB648, 0x8C61 },
	{ 0xB649, 0x8C82 },
	{ 0xB64A, 0x8CAF },
	{ 0xB64B, 0x8CBC },
	{ 0xB64C, 0x8CB3 },
	{ 0xB64D, 0x8CBD },
	{ 0xB64E, 0x8CC1 },
	{ 0xB64F, 0x8CBB },
	{ 0xB650, 0x8CC0 },
	{ 0xB651, 0x8CB4 },
	{ 0xB652, 0x8CB7 },
	{ 0xB653, 0x8CB6 },
	{ 0xB654, 0x8CBF },
	{ 0xB655, 0x8CB8 },
	{ 0xB656, 0x8D8A },
	{ 0xB657, 0x8D85 },
	{ 0xB658, 0x8D81 },
	{ 0xB659, 0x8DCE },
	{ 0xB65A, 0x8DDD },
	{ 0xB65B, 0x8DCB },
	{ 0xB65C, 0x8DDA },
	{ 0xB65D, 0x8DD1 },
	{ 0xB65E, 0x8DCC },
	{ 0xB65F, 0x8DDB },
	{ 0xB660, 0x8DC6 },
	{ 0xB661, 0x8EFB },
	{ 0xB662, 0x8EF8 },
	{ 0xB663, 0x8EFC },
	{ 0xB664, 0x8F9C },
	{ 0xB665, 0x902E },
	{ 0xB666, 0x9035 },
	{ 0xB667, 0x9031 },
	{ 0xB668, 0x9038 },
	{ 0xB669, 0x9032 },
	{ 0xB66A, 0x9036 },
	{ 0xB66B, 0x9102 },
	{ 0xB66C, 0x90F5 },
	{ 0xB66D, 0x9109 },
	{ 0xB66E, 0x90FE },
	{ 0xB66F, 0x9163 },
	{ 0xB670, 0x9165 },
	{ 0xB671, 0x91CF },
	{ 0xB672, 0x9214 },
	{ 0xB673, 0x9215 },
	{ 0xB674, 0x9223 },
	{ 0xB675, 0x9209 },
	{ 0xB676, 0x921E },
	{ 0xB677, 0x920D },
	{ 0xB678, 0x9210 },
	{ 0xB679, 0x9207 },
	{ 0xB67A, 0x9211 },
	{ 0xB67B, 0x9594 },
	{ 0xB67C, 0x958F },
	{ 0xB67D, 0x958B },
	{ 0xB67E, 0x9591 },
	{ 0xB67F, 0xFFFD },
	{ 0xB680, 0x758E },
	{ 0xB681, 0x75E5 },
	{ 0xB682, 0x7694 },
	{ 0xB683, 0x76B3 },
	{ 0xB684, 0x76D9 },
	{ 0xB685, 0x7748 },
	{ 0xB686, 0x7749 },
	{ 0xB687, 0x7743 },
	{ 0xB688, 0x7742 },
	{ 0xB689, 0x77DF },
	{ 0xB68A, 0x7863 },
	{ 0xB68B, 0x7876 },
	{ 0xB68C, 0x785F },
	{ 0xB68D, 0x7866 },
	{ 0xB68E, 0x7966 },
	{ 0xB68F, 0x7971 },
	{ 0xB690, 0x7976 },
	{ 0xB691, 0x7984 },
	{ 0xB692, 0x7975 },
	{ 0xB693, 0x79FF },
	{ 0xB694, 0x7A07 },
	{ 0xB695, 0x7A0E },
	{ 0xB696, 0x7A09 },
	{ 0xB697, 0x7AE7 },
	{ 0xB698, 0x7AE2 },
	{ 0xB699, 0x7B55 },
	{ 0xB69A, 0x7B43 },
	{ 0xB69B, 0x7B57 },
	{ 0xB69C, 0x7B6C },
	{ 0xB69D, 0x7B42 },
	{ 0xB69E, 0x7B53 },
	{ 0xB69F, 0x7B41 },
	{ 0xB6A0, 0x7CA0 },
	{ 0xB6A1, 0x9593 },
	{ 0xB6A2, 0x9592 },
	{ 0xB6A3, 0x958E },
	{ 0xB6A4, 0x968A },
	{ 0xB6A5, 0x968E },
	{ 0xB6A6, 0x968B },
	{ 0xB6A7, 0x967D },
	{ 0xB6A8, 0x9685 },
	{ 0xB6A9, 0x9686 },
	{ 0xB6AA, 0x968D },
	{ 0xB6AB, 0x9672 },
	{ 0xB6AC, 0x9684 },
	{ 0xB6AD, 0x96C1 },
	{ 0xB6AE, 0x96C5 },
	{ 0xB6AF, 0x96C4 },
	{ 0xB6B0, 0x96C6 },
	{ 0xB6B1, 0x96C7 },
	{ 0xB6B2, 0x96EF },
	{ 0xB6B3, 0x96F2 },
	{ 0xB6B4, 0x97CC },
	{ 0xB6B5, 0x9805 },
	{ 0xB6B6, 0x9806 },
	{ 0xB6B7, 0x9808 },
	{ 0xB6B8, 0x98E7 },
	{ 0xB6B9, 0x98EA },
	{ 0xB6BA, 0x98EF },
	{ 0xB6BB, 0x98E9 },
	{ 0xB6BC, 0x98F2 },
	{ 0xB6BD, 0x98ED },
	{ 0xB6BE, 0x99AE },
	{ 0xB6BF, 0x99AD },
	{ 0xB6C0, 0x9EC3 },
	{ 0xB6C1, 0x9ECD },
	{ 0xB6C2, 0x9ED1 },
	{ 0xB6C3, 0x4E82 },
	{ 0xB6C4, 0x50AD },
	{ 0xB6C5, 0x50B5 },
	{ 0xB6C6, 0x50B2 },
	{ 0xB6C7, 0x50B3 },
	{ 0xB6C8, 0x50C5 },
	{ 0xB6C9, 0x50BE },
	{ 0xB6CA, 0x50AC },
	{ 0xB6CB, 0x50B7 },
	{ 0xB6CC, 0x50BB },
	{ 0xB6CD, 0x50AF },
	{ 0xB6CE, 0x50C7 },
	{ 0xB6CF, 0x527F },
	{ 0xB6D0, 0x5277 },
	{ 0xB6D1, 0x527D },
	{ 0xB6D2, 0x52DF },
	{ 0xB6D3, 0x52E6 },
	{ 0xB6D4, 0x52E4 },
	{ 0xB6D5, 0x52E2 },
	{ 0xB6D6, 0x52E3 },
	{ 0xB6D7, 0x532F },
	{ 0xB6D8, 0x55DF },
	{ 0xB6D9, 0x55E8 },
	{ 0xB6DA, 0x55D3 },
	{ 0xB6DB, 0x55E6 },
	{ 0xB6DC, 0x55CE },
	{ 0xB6DD, 0x55DC },
	{ 0xB6DE, 0x55C7 },
	{ 0xB6DF, 0x55D1 },
	{ 0xB6E0, 0x55E3 },
	{ 0xB6E1, 0x55E4 },
	{ 0xB6E2, 0x55EF },
	{ 0xB6E3, 0x55DA },
	{ 0xB6E4, 0x55E1 },
	{ 0xB6E5, 0x55C5 },
	{ 0xB6E6, 0x55C6 },
	{ 0xB6E7, 0x55E5 },
	{ 0xB6E8, 0x55C9 },
	{ 0xB6E9, 0x5712 },
	{ 0xB6EA, 0x5713 },
	{ 0xB6EB, 0x585E },
	{ 0xB6EC, 0x5851 },
	{ 0xB6ED, 0x5858 },
	{ 0xB6EE, 0x5857 },
	{ 0xB6EF, 0x585A },
	{ 0xB6F0, 0x5854 },
	{ 0xB6F1, 0x586B },
	{ 0xB6F2, 0x584C },
	{ 0xB6F3, 0x586D },
	{ 0xB6F4, 0x584A },
	{ 0xB6F5, 0x5862 },
	{ 0xB6F6, 0x5852 },
	{ 0xB6F7, 0x584B },
	{ 0xB6F8, 0x5967 },
	{ 0xB6F9, 0x5AC1 },
	{ 0xB6FA, 0x5AC9 },
	{ 0xB6FB, 0x5ACC },
	{ 0xB6FC, 0x5ABE },
	{ 0xB6FD, 0x5ABD },
	{ 0xB6FE, 0x5ABC },
	{ 0xB740, 0x5AB3 },
	{ 0xB741, 0x5AC2 },
	{ 0xB742, 0x5AB2 },
	{ 0xB743, 0x5D69 },
	{ 0xB744, 0x5D6F },
	{ 0xB745, 0x5E4C },
	{ 0xB746, 0x5E79 },
	{ 0xB747, 0x5EC9 },
	{ 0xB748, 0x5EC8 },
	{ 0xB749, 0x5F12 },
	{ 0xB74A, 0x5F59 },
	{ 0xB74B, 0x5FAC },
	{ 0xB74C, 0x5FAE },
	{ 0xB74D, 0x611A },
	{ 0xB74E, 0x610F },
	{ 0xB74F, 0x6148 },
	{ 0xB750, 0x611F },
	{ 0xB751, 0x60F3 },
	{ 0xB752, 0x611B },
	{ 0xB753, 0x60F9 },
	{ 0xB754, 0x6101 },
	{ 0xB755, 0x6108 },
	{ 0xB756, 0x614E },
	{ 0xB757, 0x614C },
	{ 0xB758, 0x6144 },
	{ 0xB759, 0x614D },
	{ 0xB75A, 0x613E },
	{ 0xB75B, 0x6134 },
	{ 0xB75C, 0x6127 },
	{ 0xB75D, 0x610D },
	{ 0xB75E, 0x6106 },
	{ 0xB75F, 0x6137 },
	{ 0xB760, 0x6221 },
	{ 0xB761, 0x6222 },
	{ 0xB762, 0x6413 },
	{ 0xB763, 0x643E },
	{ 0xB764, 0x641E },
	{ 0xB765, 0x642A },
	{ 0xB766, 0x642D },
	{ 0xB767, 0x643D },
	{ 0xB768, 0x642C },
	{ 0xB769, 0x640F },
	{ 0xB76A, 0x641C },
	{ 0xB76B, 0x6414 },
	{ 0xB76C, 0x640D },
	{ 0xB76D, 0x6436 },
	{ 0xB76E, 0x6416 },
	{ 0xB76F, 0x6417 },
	{ 0xB770, 0x6406 },
	{ 0xB771, 0x656C },
	{ 0xB772, 0x659F },
	{ 0xB773, 0x65B0 },
	{ 0xB774, 0x6697 },
	{ 0xB775, 0x6689 },
	{ 0xB776, 0x6687 },
	{ 0xB777, 0x6688 },
	{ 0xB778, 0x6696 },
	{ 0xB779, 0x6684 },
	{ 0xB77A, 0x6698 },
	{ 0xB77B, 0x668D },
	{ 0xB77C, 0x6703 },
	{ 0xB77D, 0x6994 },
	{ 0xB77E, 0x696D },
	{ 0xB77F, 0xFFFD },
	{ 0xB780, 0x7CA6 },
	{ 0xB781, 0x7CA4 },
	{ 0xB782, 0x7D74 },
	{ 0xB783, 0x7D59 },
	{ 0xB784, 0x7D60 },
	{ 0xB785, 0x7D57 },
	{ 0xB786, 0x7D6C },
	{ 0xB787, 0x7D7E },
	{ 0xB788, 0x7D64 },
	{ 0xB789, 0x7D5A },
	{ 0xB78A, 0x7D5D },
	{ 0xB78B, 0x7D76 },
	{ 0xB78C, 0x7D4D },
	{ 0xB78D, 0x7D75 },
	{ 0xB78E, 0x7FD3 },
	{ 0xB78F, 0x7FD6 },
	{ 0xB790, 0x8060 },
	{ 0xB791, 0x804E },
	{ 0xB792, 0x8145 },
	{ 0xB793, 0x813B },
	{ 0xB794, 0x8148 },
	{ 0xB795, 0x8142 },
	{ 0xB796, 0x8149 },
	{ 0xB797, 0x8140 },
	{ 0xB798, 0x8114 },
	{ 0xB799, 0x8141 },
	{ 0xB79A, 0x81EF },
	{ 0xB79B, 0x81F6 },
	{ 0xB79C, 0x8203 },
	{ 0xB79D, 0x83ED },
	{ 0xB79E, 0x83DA },
	{ 0xB79F, 0x8418 },
	{ 0xB7A0, 0x83D2 },
	{ 0xB7A1, 0x695A },
	{ 0xB7A2, 0x6977 },
	{ 0xB7A3, 0x6960 },
	{ 0xB7A4, 0x6954 },
	{ 0xB7A5, 0x6975 },
	{ 0xB7A6, 0x6930 },
	{ 0xB7A7, 0x6982 },
	{ 0xB7A8, 0x694A },
	{ 0xB7A9, 0x6968 },
	{ 0xB7AA, 0x696B },
	{ 0xB7AB, 0x695E },
	{ 0xB7AC, 0x6953 },
	{ 0xB7AD, 0x6979 },
	{ 0xB7AE, 0x6986 },
	{ 0xB7AF, 0x695D },
	{ 0xB7B0, 0x6963 },
	{ 0xB7B1, 0x695B },
	{ 0xB7B2, 0x6B47 },
	{ 0xB7B3, 0x6B72 },
	{ 0xB7B4, 0x6BC0 },
	{ 0xB7B5, 0x6BBF },
	{ 0xB7B6, 0x6BD3 },
	{ 0xB7B7, 0x6BFD },
	{ 0xB7B8, 0x6EA2 },
	{ 0xB7B9, 0x6EAF },
	{ 0xB7BA, 0x6ED3 },
	{ 0xB7BB, 0x6EB6 },
	{ 0xB7BC, 0x6EC2 },
	{ 0xB7BD, 0x6E90 },
	{ 0xB7BE, 0x6E9D },
	{ 0xB7BF, 0x6EC7 },
	{ 0xB7C0, 0x6EC5 },
	{ 0xB7C1, 0x6EA5 },
	{ 0xB7C2, 0x6E98 },
	{ 0xB7C3, 0x6EBC },
	{ 0xB7C4, 0x6EBA },
	{ 0xB7C5, 0x6EAB },
	{ 0xB7C6, 0x6ED1 },
	{ 0xB7C7, 0x6E96 },
	{ 0xB7C8, 0x6E9C },
	{ 0xB7C9, 0x6EC4 },
	{ 0xB7CA, 0x6ED4 },
	{ 0xB7CB, 0x6EAA },
	{ 0xB7CC, 0x6EA7 },
	{ 0xB7CD, 0x6EB4 },
	{ 0xB7CE, 0x714E },
	{ 0xB7CF, 0x7159 },
	{ 0xB7D0, 0x7169 },
	{ 0xB7D1, 0x7164 },
	{ 0xB7D2, 0x7149 },
	{ 0xB7D3, 0x7167 },
	{ 0xB7D4, 0x715C },
	{ 0xB7D5, 0x716C },
	{ 0xB7D6, 0x7166 },
	{ 0xB7D7, 0x714C },
	{ 0xB7D8, 0x7165 },
	{ 0xB7D9, 0x715E },
	{ 0xB7DA, 0x7146 },
	{ 0xB7DB, 0x7168 },
	{ 0xB7DC, 0x7156 },
	{ 0xB7DD, 0x723A },
	{ 0xB7DE, 0x7252 },
	{ 0xB7DF, 0x7337 },
	{ 0xB7E0, 0x7345 },
	{ 0xB7E1, 0x733F },
	{ 0xB7E2, 0x733E },
	{ 0xB7E3, 0x746F },
	{ 0xB7E4, 0x745A },
	{ 0xB7E5, 0x7455 },
	{ 0xB7E6, 0x745F },
	{ 0xB7E7, 0x745E },
	{ 0xB7E8, 0x7441 },
	{ 0xB7E9, 0x743F },
	{ 0xB7EA, 0x7459 },
	{ 0xB7EB, 0x745B },
	{ 0xB7EC, 0x745C },
	{ 0xB7ED, 0x7576 },
	{ 0xB7EE, 0x7578 },
	{ 0xB7EF, 0x7600 },
	{ 0xB7F0, 0x75F0 },
	{ 0xB7F1, 0x7601 },
	{ 0xB7F2, 0x75F2 },
	{ 0xB7F3, 0x75F1 },
	{ 0xB7F4, 0x75FA },
	{ 0xB7F5, 0x75FF },
	{ 0xB7F6, 0x75F4 },
	{ 0xB7F7, 0x75F3 },
	{ 0xB7F8, 0x76DE },
	{ 0xB7F9, 0x76DF },
	{ 0xB7FA, 0x775B },
	{ 0xB7FB, 0x776B },
	{ 0xB7FC, 0x7766 },
	{ 0xB7FD, 0x775E },
	{ 0xB7FE, 0x7763 },
	{ 0xB840, 0x7779 },
	{ 0xB841, 0x776A },
	{ 0xB842, 0x776C },
	{ 0xB843, 0x775C },
	{ 0xB844, 0x7765 },
	{ 0xB845, 0x7768 },
	{ 0xB846, 0x7762 },
	{ 0xB847, 0x77EE },
	{ 0xB848, 0x788E },
	{ 0xB849, 0x78B0 },
	{ 0xB84A, 0x7897 },
	{ 0xB84B, 0x7898 },
	{ 0xB84C, 0x788C },
	{ 0xB84D, 0x7889 },
	{ 0xB84E, 0x787C },
	{ 0xB84F, 0x7891 },
	{ 0xB850, 0x7893 },
	{ 0xB851, 0x787F },
	{ 0xB852, 0x797A },
	{ 0xB853, 0x797F },
	{ 0xB854, 0x7981 },
	{ 0xB855, 0x842C },
	{ 0xB856, 0x79BD },
	{ 0xB857, 0x7A1C },
	{ 0xB858, 0x7A1A },
	{ 0xB859, 0x7A20 },
	{ 0xB85A, 0x7A14 },
	{ 0xB85B, 0x7A1F },
	{ 0xB85C, 0x7A1E },
	{ 0xB85D, 0x7A9F },
	{ 0xB85E, 0x7AA0 },
	{ 0xB85F, 0x7B77 },
	{ 0xB860, 0x7BC0 },
	{ 0xB861, 0x7B60 },
	{ 0xB862, 0x7B6E },
	{ 0xB863, 0x7B67 },
	{ 0xB864, 0x7CB1 },
	{ 0xB865, 0x7CB3 },
	{ 0xB866, 0x7CB5 },
	{ 0xB867, 0x7D93 },
	{ 0xB868, 0x7D79 },
	{ 0xB869, 0x7D91 },
	{ 0xB86A, 0x7D81 },
	{ 0xB86B, 0x7D8F },
	{ 0xB86C, 0x7D5B },
	{ 0xB86D, 0x7F6E },
	{ 0xB86E, 0x7F69 },
	{ 0xB86F, 0x7F6A },
	{ 0xB870, 0x7F72 },
	{ 0xB871, 0x7FA9 },
	{ 0xB872, 0x7FA8 },
	{ 0xB873, 0x7FA4 },
	{ 0xB874, 0x8056 },
	{ 0xB875, 0x8058 },
	{ 0xB876, 0x8086 },
	{ 0xB877, 0x8084 },
	{ 0xB878, 0x8171 },
	{ 0xB879, 0x8170 },
	{ 0xB87A, 0x8178 },
	{ 0xB87B, 0x8165 },
	{ 0xB87C, 0x816E },
	{ 0xB87D, 0x8173 },
	{ 0xB87E, 0x816B },
	{ 0xB87F, 0xFFFD },
	{ 0xB880, 0x8408 },
	{ 0xB881, 0x8400 },
	{ 0xB882, 0x8417 },
	{ 0xB883, 0x8346 },
	{ 0xB884, 0x8414 },
	{ 0xB885, 0x83D3 },
	{ 0xB886, 0x8405 },
	{ 0xB887, 0x841F },
	{ 0xB888, 0x8402 },
	{ 0xB889, 0x8416 },
	{ 0xB88A, 0x83CD },
	{ 0xB88B, 0x83E6 },
	{ 0xB88C, 0x865D },
	{ 0xB88D, 0x86D5 },
	{ 0xB88E, 0x86E1 },
	{ 0xB88F, 0x86EE },
	{ 0xB890, 0x8847 },
	{ 0xB891, 0x8846 },
	{ 0xB892, 0x88BB },
	{ 0xB893, 0x88BF },
	{ 0xB894, 0x88B4 },
	{ 0xB895, 0x88B5 },
	{ 0xB896, 0x899A },
	{ 0xB897, 0x8A43 },
	{ 0xB898, 0x8A5A },
	{ 0xB899, 0x8A35 },
	{ 0xB89A, 0x8A38 },
	{ 0xB89B, 0x8A42 },
	{ 0xB89C, 0x8A49 },
	{ 0xB89D, 0x8A5D },
	{ 0xB89E, 0x8A4B },
	{ 0xB89F, 0x8A3D },
	{ 0xB8A0, 0x8C60 },
	{ 0xB8A1, 0x8179 },
	{ 0xB8A2, 0x817A },
	{ 0xB8A3, 0x8166 },
	{ 0xB8A4, 0x8205 },
	{ 0xB8A5, 0x8247 },
	{ 0xB8A6, 0x8482 },
	{ 0xB8A7, 0x8477 },
	{ 0xB8A8, 0x843D },
	{ 0xB8A9, 0x8431 },
	{ 0xB8AA, 0x8475 },
	{ 0xB8AB, 0x8466 },
	{ 0xB8AC, 0x846B },
	{ 0xB8AD, 0x8449 },
	{ 0xB8AE, 0x846C },
	{ 0xB8AF, 0x845B },
	{ 0xB8B0, 0x843C },
	{ 0xB8B1, 0x8435 },
	{ 0xB8B2, 0x8461 },
	{ 0xB8B3, 0x8463 },
	{ 0xB8B4, 0x8469 },
	{ 0xB8B5, 0x846D },
	{ 0xB8B6, 0x8446 },
	{ 0xB8B7, 0x865E },
	{ 0xB8B8, 0x865C },
	{ 0xB8B9, 0x865F },
	{ 0xB8BA, 0x86F9 },
	{ 0xB8BB, 0x8713 },
	{ 0xB8BC, 0x8708 },
	{ 0xB8BD, 0x8707 },
	{ 0xB8BE, 0x8700 },
	{ 0xB8BF, 0x86FE },
	{ 0xB8C0, 0x86FB },
	{ 0xB8C1, 0x8702 },
	{ 0xB8C2, 0x8703 },
	{ 0xB8C3, 0x8706 },
	{ 0xB8C4, 0x870A },
	{ 0xB8C5, 0x8859 },
	{ 0xB8C6, 0x88DF },
	{ 0xB8C7, 0x88D4 },
	{ 0xB8C8, 0x88D9 },
	{ 0xB8C9, 0x88DC },
	{ 0xB8CA, 0x88D8 },
	{ 0xB8CB, 0x88DD },
	{ 0xB8CC, 0x88E1 },
	{ 0xB8CD, 0x88CA },
	{ 0xB8CE, 0x88D5 },
	{ 0xB8CF, 0x88D2 },
	{ 0xB8D0, 0x899C },
	{ 0xB8D1, 0x89E3 },
	{ 0xB8D2, 0x8A6B },
	{ 0xB8D3, 0x8A72 },
	{ 0xB8D4, 0x8A73 },
	{ 0xB8D5, 0x8A66 },
	{ 0xB8D6, 0x8A69 },
	{ 0xB8D7, 0x8A70 },
	{ 0xB8D8, 0x8A87 },
	{ 0xB8D9, 0x8A7C },
	{ 0xB8DA, 0x8A63 },
	{ 0xB8DB, 0x8AA0 },
	{ 0xB8DC, 0x8A71 },
	{ 0xB8DD, 0x8A85 },
	{ 0xB8DE, 0x8A6D },
	{ 0xB8DF, 0x8A62 },
	{ 0xB8E0, 0x8A6E },
	{ 0xB8E1, 0x8A6C },
	{ 0xB8E2, 0x8A79 },
	{ 0xB8E3, 0x8A7B },
	{ 0xB8E4, 0x8A3E },
	{ 0xB8E5, 0x8A68 },
	{ 0xB8E6, 0x8C62 },
	{ 0xB8E7, 0x8C8A },
	{ 0xB8E8, 0x8C89 },
	{ 0xB8E9, 0x8CCA },
	{ 0xB8EA, 0x8CC7 },
	{ 0xB8EB, 0x8CC8 },
	{ 0xB8EC, 0x8CC4 },
	{ 0xB8ED, 0x8CB2 },
	{ 0xB8EE, 0x8CC3 },
	{ 0xB8EF, 0x8CC2 },
	{ 0xB8F0, 0x8CC5 },
	{ 0xB8F1, 0x8DE1 },
	{ 0xB8F2, 0x8DDF },
	{ 0xB8F3, 0x8DE8 },
	{ 0xB8F4, 0x8DEF },
	{ 0xB8F5, 0x8DF3 },
	{ 0xB8F6, 0x8DFA },
	{ 0xB8F7, 0x8DEA },
	{ 0xB8F8, 0x8DE4 },
	{ 0xB8F9, 0x8DE6 },
	{ 0xB8FA, 0x8EB2 },
	{ 0xB8FB, 0x8F03 },
	{ 0xB8FC, 0x8F09 },
	{ 0xB8FD, 0x8EFE },
	{ 0xB8FE, 0x8F0A },
	{ 0xB940, 0x8F9F },
	{ 0xB941, 0x8FB2 },
	{ 0xB942, 0x904B },
	{ 0xB943, 0x904A },
	{ 0xB944, 0x9053 },
	{ 0xB945, 0x9042 },
	{ 0xB946, 0x9054 },
	{ 0xB947, 0x903C },
	{ 0xB948, 0x9055 },
	{ 0xB949, 0x9050 },
	{ 0xB94A, 0x9047 },
	{ 0xB94B, 0x904F },
	{ 0xB94C, 0x904E },
	{ 0xB94D, 0x904D },
	{ 0xB94E, 0x9051 },
	{ 0xB94F, 0x903E },
	{ 0xB950, 0x9041 },
	{ 0xB951, 0x9112 },
	{ 0xB952, 0x9117 },
	{ 0xB953, 0x916C },
	{ 0xB954, 0x916A },
	{ 0xB955, 0x9169 },
	{ 0xB956, 0x91C9 },
	{ 0xB957, 0x9237 },
	{ 0xB958, 0x9257 },
	{ 0xB959, 0x9238 },
	{ 0xB95A, 0x923D },
	{ 0xB95B, 0x9240 },
	{ 0xB95C, 0x923E },
	{ 0xB95D, 0x925B },
	{ 0xB95E, 0x924B },
	{ 0xB95F, 0x9264 },
	{ 0xB960, 0x9251 },
	{ 0xB961, 0x9234 },
	{ 0xB962, 0x9249 },
	{ 0xB963, 0x924D },
	{ 0xB964, 0x9245 },
	{ 0xB965, 0x9239 },
	{ 0xB966, 0x923F },
	{ 0xB967, 0x925A },
	{ 0xB968, 0x9598 },
	{ 0xB969, 0x9698 },
	{ 0xB96A, 0x9694 },
	{ 0xB96B, 0x9695 },
	{ 0xB96C, 0x96CD },
	{ 0xB96D, 0x96CB },
	{ 0xB96E, 0x96C9 },
	{ 0xB96F, 0x96CA },
	{ 0xB970, 0x96F7 },
	{ 0xB971, 0x96FB },
	{ 0xB972, 0x96F9 },
	{ 0xB973, 0x96F6 },
	{ 0xB974, 0x9756 },
	{ 0xB975, 0x9774 },
	{ 0xB976, 0x9776 },
	{ 0xB977, 0x9810 },
	{ 0xB978, 0x9811 },
	{ 0xB979, 0x9813 },
	{ 0xB97A, 0x980A },
	{ 0xB97B, 0x9812 },
	{ 0xB97C, 0x980C },
	{ 0xB97D, 0x98FC },
	{ 0xB97E, 0x98F4 },
	{ 0xB97F, 0xFFFD },
	{ 0xB980, 0x8C5E },
	{ 0xB981, 0x8C7F },
	{ 0xB982, 0x8C7E },
	{ 0xB983, 0x8C83 },
	{ 0xB984, 0x8CB1 },
	{ 0xB985, 0x8D87 },
	{ 0xB986, 0x8D88 },
	{ 0xB987, 0x8D83 },
	{ 0xB988, 0x8D86 },
	{ 0xB989, 0x8D8B },
	{ 0xB98A, 0x8D82 },
	{ 0xB98B, 0x8DCA },
	{ 0xB98C, 0x8DD2 },
	{ 0xB98D, 0x8DD4 },
	{ 0xB98E, 0x8DC9 },
	{ 0xB98F, 0x8EB0 },
	{ 0xB990, 0x8EF2 },
	{ 0xB991, 0x8EE4 },
	{ 0xB992, 0x8EF3 },
	{ 0xB993, 0x8EEA },
	{ 0xB994, 0x8EFD },
	{ 0xB995, 0x8F9D },
	{ 0xB996, 0x902B },
	{ 0xB997, 0x902A },
	{ 0xB998, 0x9028 },
	{ 0xB999, 0x9029 },
	{ 0xB99A, 0x902C },
	{ 0xB99B, 0x903A },
	{ 0xB99C, 0x9030 },
	{ 0xB99D, 0x9037 },
	{ 0xB99E, 0x903B },
	{ 0xB99F, 0x910A },
	{ 0xB9A0, 0x91FE },
	{ 0xB9A1, 0x98FD },
	{ 0xB9A2, 0x98FE },
	{ 0xB9A3, 0x99B3 },
	{ 0xB9A4, 0x99B1 },
	{ 0xB9A5, 0x99B4 },
	{ 0xB9A6, 0x9AE1 },
	{ 0xB9A7, 0x9CE9 },
	{ 0xB9A8, 0x9E82 },
	{ 0xB9A9, 0x9F0E },
	{ 0xB9AA, 0x9F13 },
	{ 0xB9AB, 0x9F20 },
	{ 0xB9AC, 0x50E7 },
	{ 0xB9AD, 0x50EE },
	{ 0xB9AE, 0x50E5 },
	{ 0xB9AF, 0x50D6 },
	{ 0xB9B0, 0x50ED },
	{ 0xB9B1, 0x50DA },
	{ 0xB9B2, 0x50D5 },
	{ 0xB9B3, 0x50CF },
	{ 0xB9B4, 0x50D1 },
	{ 0xB9B5, 0x50F1 },
	{ 0xB9B6, 0x50CE },
	{ 0xB9B7, 0x50E9 },
	{ 0xB9B8, 0x5162 },
	{ 0xB9B9, 0x51F3 },
	{ 0xB9BA, 0x5283 },
	{ 0xB9BB, 0x5282 },
	{ 0xB9BC, 0x5331 },
	{ 0xB9BD, 0x53AD },
	{ 0xB9BE, 0x55FE },
	{ 0xB9BF, 0x5600 },
	{ 0xB9C0, 0x561B },
	{ 0xB9C1, 0x5617 },
	{ 0xB9C2, 0x55FD },
	{ 0xB9C3, 0x5614 },
	{ 0xB9C4, 0x5606 },
	{ 0xB9C5, 0x5609 },
	{ 0xB9C6, 0x560D },
	{ 0xB9C7, 0x560E },
	{ 0xB9C8, 0x55F7 },
	{ 0xB9C9, 0x5616 },
	{ 0xB9CA, 0x561F },
	{ 0xB9CB, 0x5608 },
	{ 0xB9CC, 0x5610 },
	{ 0xB9CD, 0x55F6 },
	{ 0xB9CE, 0x5718 },
	{ 0xB9CF, 0x5716 },
	{ 0xB9D0, 0x5875 },
	{ 0xB9D1, 0x587E },
	{ 0xB9D2, 0x5883 },
	{ 0xB9D3, 0x5893 },
	{ 0xB9D4, 0x588A },
	{ 0xB9D5, 0x5879 },
	{ 0xB9D6, 0x5885 },
	{ 0xB9D7, 0x587D },
	{ 0xB9D8, 0x58FD },
	{ 0xB9D9, 0x5925 },
	{ 0xB9DA, 0x5922 },
	{ 0xB9DB, 0x5924 },
	{ 0xB9DC, 0x596A },
	{ 0xB9DD, 0x5969 },
	{ 0xB9DE, 0x5AE1 },
	{ 0xB9DF, 0x5AE6 },
	{ 0xB9E0, 0x5AE9 },
	{ 0xB9E1, 0x5AD7 },
	{ 0xB9E2, 0x5AD6 },
	{ 0xB9E3, 0x5AD8 },
	{ 0xB9E4, 0x5AE3 },
	{ 0xB9E5, 0x5B75 },
	{ 0xB9E6, 0x5BDE },
	{ 0xB9E7, 0x5BE7 },
	{ 0xB9E8, 0x5BE1 },
	{ 0xB9E9, 0x5BE5 },
	{ 0xB9EA, 0x5BE6 },
	{ 0xB9EB, 0x5BE8 },
	{ 0xB9EC, 0x5BE2 },
	{ 0xB9ED, 0x5BE4 },
	{ 0xB9EE, 0x5BDF },
	{ 0xB9EF, 0x5C0D },
	{ 0xB9F0, 0x5C62 },
	{ 0xB9F1, 0x5D84 },
	{ 0xB9F2, 0x5D87 },
	{ 0xB9F3, 0x5E5B },
	{ 0xB9F4, 0x5E63 },
	{ 0xB9F5, 0x5E55 },
	{ 0xB9F6, 0x5E57 },
	{ 0xB9F7, 0x5E54 },
	{ 0xB9F8, 0x5ED3 },
	{ 0xB9F9, 0x5ED6 },
	{ 0xB9FA, 0x5F0A },
	{ 0xB9FB, 0x5F46 },
	{ 0xB9FC, 0x5F70 },
	{ 0xB9FD, 0x5FB9 },
	{ 0xB9FE, 0x6147 },
	{ 0xBA40, 0x613F },
	{ 0xBA41, 0x614B },
	{ 0xBA42, 0x6177 },
	{ 0xBA43, 0x6162 },
	{ 0xBA44, 0x6163 },
	{ 0xBA45, 0x615F },
	{ 0xBA46, 0x615A },
	{ 0xBA47, 0x6158 },
	{ 0xBA48, 0x6175 },
	{ 0xBA49, 0x622A },
	{ 0xBA4A, 0x6487 },
	{ 0xBA4B, 0x6458 },
	{ 0xBA4C, 0x6454 },
	{ 0xBA4D, 0x64A4 },
	{ 0xBA4E, 0x6478 },
	{ 0xBA4F, 0x645F },
	{ 0xBA50, 0x647A },
	{ 0xBA51, 0x6451 },
	{ 0xBA52, 0x6467 },
	{ 0xBA53, 0x6434 },
	{ 0xBA54, 0x646D },
	{ 0xBA55, 0x647B },
	{ 0xBA56, 0x6572 },
	{ 0xBA57, 0x65A1 },
	{ 0xBA58, 0x65D7 },
	{ 0xBA59, 0x65D6 },
	{ 0xBA5A, 0x66A2 },
	{ 0xBA5B, 0x66A8 },
	{ 0xBA5C, 0x669D },
	{ 0xBA5D, 0x699C },
	{ 0xBA5E, 0x69A8 },
	{ 0xBA5F, 0x6995 },
	{ 0xBA60, 0x69C1 },
	{ 0xBA61, 0x69AE },
	{ 0xBA62, 0x69D3 },
	{ 0xBA63, 0x69CB },
	{ 0xBA64, 0x699B },
	{ 0xBA65, 0x69B7 },
	{ 0xBA66, 0x69BB },
	{ 0xBA67, 0x69AB },
	{ 0xBA68, 0x69B4 },
	{ 0xBA69, 0x69D0 },
	{ 0xBA6A, 0x69CD },
	{ 0xBA6B, 0x69AD },
	{ 0xBA6C, 0x69CC },
	{ 0xBA6D, 0x69A6 },
	{ 0xBA6E, 0x69C3 },
	{ 0xBA6F, 0x69A3 },
	{ 0xBA70, 0x6B49 },
	{ 0xBA71, 0x6B4C },
	{ 0xBA72, 0x6C33 },
	{ 0xBA73, 0x6F33 },
	{ 0xBA74, 0x6F14 },
	{ 0xBA75, 0x6EFE },
	{ 0xBA76, 0x6F13 },
	{ 0xBA77, 0x6EF4 },
	{ 0xBA78, 0x6F29 },
	{ 0xBA79, 0x6F3E },
	{ 0xBA7A, 0x6F20 },
	{ 0xBA7B, 0x6F2C },
	{ 0xBA7C, 0x6F0F },
	{ 0xBA7D, 0x6F02 },
	{ 0xBA7E, 0x6F22 },
	{ 0xBA7F, 0xFFFD },
	{ 0xBA80, 0x9220 },
	{ 0xBA81, 0x920B },
	{ 0xBA82, 0x9218 },
	{ 0xBA83, 0x9222 },
	{ 0xBA84, 0x921B },
	{ 0xBA85, 0x9208 },
	{ 0xBA86, 0x920E },
	{ 0xBA87, 0x9213 },
	{ 0xBA88, 0x9595 },
	{ 0xBA89, 0x968C },
	{ 0xBA8A, 0x967B },
	{ 0xBA8B, 0x967F },
	{ 0xBA8C, 0x9681 },
	{ 0xBA8D, 0x9682 },
	{ 0xBA8E, 0x96EE },
	{ 0xBA8F, 0x96ED },
	{ 0xBA90, 0x96EC },
	{ 0xBA91, 0x975F },
	{ 0xBA92, 0x976F },
	{ 0xBA93, 0x976D },
	{ 0xBA94, 0x98F0 },
	{ 0xBA95, 0x9AA9 },
	{ 0xBA96, 0x9AE0 },
	{ 0xBA97, 0x4EB7 },
	{ 0xBA98, 0x50CC },
	{ 0xBA99, 0x50BC },
	{ 0xBA9A, 0x50AA },
	{ 0xBA9B, 0x50B9 },
	{ 0xBA9C, 0x50AB },
	{ 0xBA9D, 0x50C3 },
	{ 0xBA9E, 0x50CD },
	{ 0xBA9F, 0x517E },
	{ 0xBAA0, 0x527E },
	{ 0xBAA1, 0x6EFF },
	{ 0xBAA2, 0x6EEF },
	{ 0xBAA3, 0x6F06 },
	{ 0xBAA4, 0x6F31 },
	{ 0xBAA5, 0x6F38 },
	{ 0xBAA6, 0x6F32 },
	{ 0xBAA7, 0x6F23 },
	{ 0xBAA8, 0x6F15 },
	{ 0xBAA9, 0x6F2B },
	{ 0xBAAA, 0x6F2F },
	{ 0xBAAB, 0x6F88 },
	{ 0xBAAC, 0x6F2A },
	{ 0xBAAD, 0x6EEC },
	{ 0xBAAE, 0x6F01 },
	{ 0xBAAF, 0x6EF2 },
	{ 0xBAB0, 0x6ECC },
	{ 0xBAB1, 0x6EF7 },
	{ 0xBAB2, 0x7194 },
	{ 0xBAB3, 0x7199 },
	{ 0xBAB4, 0x717D },
	{ 0xBAB5, 0x718A },
	{ 0xBAB6, 0x7184 },
	{ 0xBAB7, 0x7192 },
	{ 0xBAB8, 0x723E },
	{ 0xBAB9, 0x7292 },
	{ 0xBABA, 0x7296 },
	{ 0xBABB, 0x7344 },
	{ 0xBABC, 0x7350 },
	{ 0xBABD, 0x7464 },
	{ 0xBABE, 0x7463 },
	{ 0xBABF, 0x746A },
	{ 0xBAC0, 0x7470 },
	{ 0xBAC1, 0x746D },
	{ 0xBAC2, 0x7504 },
	{ 0xBAC3, 0x7591 },
	{ 0xBAC4, 0x7627 },
	{ 0xBAC5, 0x760D },
	{ 0xBAC6, 0x760B },
	{ 0xBAC7, 0x7609 },
	{ 0xBAC8, 0x7613 },
	{ 0xBAC9, 0x76E1 },
	{ 0xBACA, 0x76E3 },
	{ 0xBACB, 0x7784 },
	{ 0xBACC, 0x777D },
	{ 0xBACD, 0x777F },
	{ 0xBACE, 0x7761 },
	{ 0xBACF, 0x78C1 },
	{ 0xBAD0, 0x789F },
	{ 0xBAD1, 0x78A7 },
	{ 0xBAD2, 0x78B3 },
	{ 0xBAD3, 0x78A9 },
	{ 0xBAD4, 0x78A3 },
	{ 0xBAD5, 0x798E },
	{ 0xBAD6, 0x798F },
	{ 0xBAD7, 0x798D },
	{ 0xBAD8, 0x7A2E },
	{ 0xBAD9, 0x7A31 },
	{ 0xBADA, 0x7AAA },
	{ 0xBADB, 0x7AA9 },
	{ 0xBADC, 0x7AED },
	{ 0xBADD, 0x7AEF },
	{ 0xBADE, 0x7BA1 },
	{ 0xBADF, 0x7B95 },
	{ 0xBAE0, 0x7B8B },
	{ 0xBAE1, 0x7B75 },
	{ 0xBAE2, 0x7B97 },
	{ 0xBAE3, 0x7B9D },
	{ 0xBAE4, 0x7B94 },
	{ 0xBAE5, 0x7B8F },
	{ 0xBAE6, 0x7BB8 },
	{ 0xBAE7, 0x7B87 },
	{ 0xBAE8, 0x7B84 },
	{ 0xBAE9, 0x7CB9 },
	{ 0xBAEA, 0x7CBD },
	{ 0xBAEB, 0x7CBE },
	{ 0xBAEC, 0x7DBB },
	{ 0xBAED, 0x7DB0 },
	{ 0xBAEE, 0x7D9C },
	{ 0xBAEF, 0x7DBD },
	{ 0xBAF0, 0x7DBE },
	{ 0xBAF1, 0x7DA0 },
	{ 0xBAF2, 0x7DCA },
	{ 0xBAF3, 0x7DB4 },
	{ 0xBAF4, 0x7DB2 },
	{ 0xBAF5, 0x7DB1 },
	{ 0xBAF6, 0x7DBA },
	{ 0xBAF7, 0x7DA2 },
	{ 0xBAF8, 0x7DBF },
	{ 0xBAF9, 0x7DB5 },
	{ 0xBAFA, 0x7DB8 },
	{ 0xBAFB, 0x7DAD },
	{ 0xBAFC, 0x7DD2 },
	{ 0xBAFD, 0x7DC7 },
	{ 0xBAFE, 0x7DAC },
	{ 0xBB40, 0x7F70 },
	{ 0xBB41, 0x7FE0 },
	{ 0xBB42, 0x7FE1 },
	{ 0xBB43, 0x7FDF },
	{ 0xBB44, 0x805E },
	{ 0xBB45, 0x805A },
	{ 0xBB46, 0x8087 },
	{ 0xBB47, 0x8150 },
	{ 0xBB48, 0x8180 },
	{ 0xBB49, 0x818F },
	{ 0xBB4A, 0x8188 },
	{ 0xBB4B, 0x818A },
	{ 0xBB4C, 0x817F },
	{ 0xBB4D, 0x8182 },
	{ 0xBB4E, 0x81E7 },
	{ 0xBB4F, 0x81FA },
	{ 0xBB50, 0x8207 },
	{ 0xBB51, 0x8214 },
	{ 0xBB52, 0x821E },
	{ 0xBB53, 0x824B },
	{ 0xBB54, 0x84C9 },
	{ 0xBB55, 0x84BF },
	{ 0xBB56, 0x84C6 },
	{ 0xBB57, 0x84C4 },
	{ 0xBB58, 0x8499 },
	{ 0xBB59, 0x849E },
	{ 0xBB5A, 0x84B2 },
	{ 0xBB5B, 0x849C },
	{ 0xBB5C, 0x84CB },
	{ 0xBB5D, 0x84B8 },
	{ 0xBB5E, 0x84C0 },
	{ 0xBB5F, 0x84D3 },
	{ 0xBB60, 0x8490 },
	{ 0xBB61, 0x84BC },
	{ 0xBB62, 0x84D1 },
	{ 0xBB63, 0x84CA },
	{ 0xBB64, 0x873F },
	{ 0xBB65, 0x871C },
	{ 0xBB66, 0x873B },
	{ 0xBB67, 0x8722 },
	{ 0xBB68, 0x8725 },
	{ 0xBB69, 0x8734 },
	{ 0xBB6A, 0x8718 },
	{ 0xBB6B, 0x8755 },
	{ 0xBB6C, 0x8737 },
	{ 0xBB6D, 0x8729 },
	{ 0xBB6E, 0x88F3 },
	{ 0xBB6F, 0x8902 },
	{ 0xBB70, 0x88F4 },
	{ 0xBB71, 0x88F9 },
	{ 0xBB72, 0x88F8 },
	{ 0xBB73, 0x88FD },
	{ 0xBB74, 0x88E8 },
	{ 0xBB75, 0x891A },
	{ 0xBB76, 0x88EF },
	{ 0xBB77, 0x8AA6 },
	{ 0xBB78, 0x8A8C },
	{ 0xBB79, 0x8A9E },
	{ 0xBB7A, 0x8AA3 },
	{ 0xBB7B, 0x8A8D },
	{ 0xBB7C, 0x8AA1 },
	{ 0xBB7D, 0x8A93 },
	{ 0xBB7E, 0x8AA4 },
	{ 0xBB7F, 0xFFFD },
	{ 0xBB80, 0x5279 },
	{ 0xBB81, 0x52E1 },
	{ 0xBB82, 0x52E0 },
	{ 0xBB83, 0x52E7 },
	{ 0xBB84, 0x5380 },
	{ 0xBB85, 0x53AB },
	{ 0xBB86, 0x53AA },
	{ 0xBB87, 0x53A9 },
	{ 0xBB88, 0x53E0 },
	{ 0xBB89, 0x55EA },
	{ 0xBB8A, 0x55D7 },
	{ 0xBB8B, 0x55C1 },
	{ 0xBB8C, 0x5715 },
	{ 0xBB8D, 0x586C },
	{ 0xBB8E, 0x585C },
	{ 0xBB8F, 0x5850 },
	{ 0xBB90, 0x5861 },
	{ 0xBB91, 0x586A },
	{ 0xBB92, 0x5869 },
	{ 0xBB93, 0x5856 },
	{ 0xBB94, 0x5860 },
	{ 0xBB95, 0x5866 },
	{ 0xBB96, 0x585F },
	{ 0xBB97, 0x5923 },
	{ 0xBB98, 0x5966 },
	{ 0xBB99, 0x5968 },
	{ 0xBB9A, 0x5ACE },
	{ 0xBB9B, 0x5AC5 },
	{ 0xBB9C, 0x5AC3 },
	{ 0xBB9D, 0x5AD0 },
	{ 0xBB9E, 0x5B74 },
	{ 0xBB9F, 0x5B76 },
	{ 0xBBA0, 0x5BDC },
	{ 0xBBA1, 0x8AAA },
	{ 0xBBA2, 0x8AA5 },
	{ 0xBBA3, 0x8AA8 },
	{ 0xBBA4, 0x8A98 },
	{ 0xBBA5, 0x8A91 },
	{ 0xBBA6, 0x8A9A },
	{ 0xBBA7, 0x8AA7 },
	{ 0xBBA8, 0x8C6A },
	{ 0xBBA9, 0x8C8D },
	{ 0xBBAA, 0x8C8C },
	{ 0xBBAB, 0x8CD3 },
	{ 0xBBAC, 0x8CD1 },
	{ 0xBBAD, 0x8CD2 },
	{ 0xBBAE, 0x8D6B },
	{ 0xBBAF, 0x8D99 },
	{ 0xBBB0, 0x8D95 },
	{ 0xBBB1, 0x8DFC },
	{ 0xBBB2, 0x8F14 },
	{ 0xBBB3, 0x8F12 },
	{ 0xBBB4, 0x8F15 },
	{ 0xBBB5, 0x8F13 },
	{ 0xBBB6, 0x8FA3 },
	{ 0xBBB7, 0x9060 },
	{ 0xBBB8, 0x9058 },
	{ 0xBBB9, 0x905C },
	{ 0xBBBA, 0x9063 },
	{ 0xBBBB, 0x9059 },
	{ 0xBBBC, 0x905E },
	{ 0xBBBD, 0x9062 },
	{ 0xBBBE, 0x905D },
	{ 0xBBBF, 0x905B },
	{ 0xBBC0, 0x9119 },
	{ 0xBBC1, 0x9118 },
	{ 0xBBC2, 0x911E },
	{ 0xBBC3, 0x9175 },
	{ 0xBBC4, 0x9178 },
	{ 0xBBC5, 0x9177 },
	{ 0xBBC6, 0x9174 },
	{ 0xBBC7, 0x9278 },
	{ 0xBBC8, 0x9280 },
	{ 0xBBC9, 0x9285 },
	{ 0xBBCA, 0x9298 },
	{ 0xBBCB, 0x9296 },
	{ 0xBBCC, 0x927B },
	{ 0xBBCD, 0x9293 },
	{ 0xBBCE, 0x929C },
	{ 0xBBCF, 0x92A8 },
	{ 0xBBD0, 0x927C },
	{ 0xBBD1, 0x9291 },
	{ 0xBBD2, 0x95A1 },
	{ 0xBBD3, 0x95A8 },
	{ 0xBBD4, 0x95A9 },
	{ 0xBBD5, 0x95A3 },
	{ 0xBBD6, 0x95A5 },
	{ 0xBBD7, 0x95A4 },
	{ 0xBBD8, 0x9699 },
	{ 0xBBD9, 0x969C },
	{ 0xBBDA, 0x969B },
	{ 0xBBDB, 0x96CC },
	{ 0xBBDC, 0x96D2 },
	{ 0xBBDD, 0x9700 },
	{ 0xBBDE, 0x977C },
	{ 0xBBDF, 0x9785 },
	{ 0xBBE0, 0x97F6 },
	{ 0xBBE1, 0x9817 },
	{ 0xBBE2, 0x9818 },
	{ 0xBBE3, 0x98AF },
	{ 0xBBE4, 0x98B1 },
	{ 0xBBE5, 0x9903 },
	{ 0xBBE6, 0x9905 },
	{ 0xBBE7, 0x990C },
	{ 0xBBE8, 0x9909 },
	{ 0xBBE9, 0x99C1 },
	{ 0xBBEA, 0x9AAF },
	{ 0xBBEB, 0x9AB0 },
	{ 0xBBEC, 0x9AE6 },
	{ 0xBBED, 0x9B41 },
	{ 0xBBEE, 0x9B42 },
	{ 0xBBEF, 0x9CF4 },
	{ 0xBBF0, 0x9CF6 },
	{ 0xBBF1, 0x9CF3 },
	{ 0xBBF2, 0x9EBC },
	{ 0xBBF3, 0x9F3B },
	{ 0xBBF4, 0x9F4A },
	{ 0xBBF5, 0x5104 },
	{ 0xBBF6, 0x5100 },
	{ 0xBBF7, 0x50FB },
	{ 0xBBF8, 0x50F5 },
	{ 0xBBF9, 0x50F9 },
	{ 0xBBFA, 0x5102 },
	{ 0xBBFB, 0x5108 },
	{ 0xBBFC, 0x5109 },
	{ 0xBBFD, 0x5105 },
	{ 0xBBFE, 0x51DC },
	{ 0xBC40, 0x5287 },
	{ 0xBC41, 0x5288 },
	{ 0xBC42, 0x5289 },
	{ 0xBC43, 0x528D },
	{ 0xBC44, 0x528A },
	{ 0xBC45, 0x52F0 },
	{ 0xBC46, 0x53B2 },
	{ 0xBC47, 0x562E },
	{ 0xBC48, 0x563B },
	{ 0xBC49, 0x5639 },
	{ 0xBC4A, 0x5632 },
	{ 0xBC4B, 0x563F },
	{ 0xBC4C, 0x5634 },
	{ 0xBC4D, 0x5629 },
	{ 0xBC4E, 0x5653 },
	{ 0xBC4F, 0x564E },
	{ 0xBC50, 0x5657 },
	{ 0xBC51, 0x5674 },
	{ 0xBC52, 0x5636 },
	{ 0xBC53, 0x562F },
	{ 0xBC54, 0x5630 },
	{ 0xBC55, 0x5880 },
	{ 0xBC56, 0x589F },
	{ 0xBC57, 0x589E },
	{ 0xBC58, 0x58B3 },
	{ 0xBC59, 0x589C },
	{ 0xBC5A, 0x58AE },
	{ 0xBC5B, 0x58A9 },
	{ 0xBC5C, 0x58A6 },
	{ 0xBC5D, 0x596D },
	{ 0xBC5E, 0x5B09 },
	{ 0xBC5F, 0x5AFB },
	{ 0xBC60, 0x5B0B },
	{ 0xBC61, 0x5AF5 },
	{ 0xBC62, 0x5B0C },
	{ 0xBC63, 0x5B08 },
	{ 0xBC64, 0x5BEE },
	{ 0xBC65, 0x5BEC },
	{ 0xBC66, 0x5BE9 },
	{ 0xBC67, 0x5BEB },
	{ 0xBC68, 0x5C64 },
	{ 0xBC69, 0x5C65 },
	{ 0xBC6A, 0x5D9D },
	{ 0xBC6B, 0x5D94 },
	{ 0xBC6C, 0x5E62 },
	{ 0xBC6D, 0x5E5F },
	{ 0xBC6E, 0x5E61 },
	{ 0xBC6F, 0x5EE2 },
	{ 0xBC70, 0x5EDA },
	{ 0xBC71, 0x5EDF },
	{ 0xBC72, 0x5EDD },
	{ 0xBC73, 0x5EE3 },
	{ 0xBC74, 0x5EE0 },
	{ 0xBC75, 0x5F48 },
	{ 0xBC76, 0x5F71 },
	{ 0xBC77, 0x5FB7 },
	{ 0xBC78, 0x5FB5 },
	{ 0xBC79, 0x6176 },
	{ 0xBC7A, 0x6167 },
	{ 0xBC7B, 0x616E },
	{ 0xBC7C, 0x615D },
	{ 0xBC7D, 0x6155 },
	{ 0xBC7E, 0x6182 },
	{ 0xBC7F, 0xFFFD },
	{ 0xBC80, 0x5BD7 },
	{ 0xBC81, 0x5BDA },
	{ 0xBC82, 0x5BDB },
	{ 0xBC83, 0x5C20 },
	{ 0xBC84, 0x5D6D },
	{ 0xBC85, 0x5D66 },
	{ 0xBC86, 0x5D64 },
	{ 0xBC87, 0x5D6E },
	{ 0xBC88, 0x5D60 },
	{ 0xBC89, 0x5F42 },
	{ 0xBC8A, 0x5F5A },
	{ 0xBC8B, 0x5F6E },
	{ 0xBC8C, 0x6130 },
	{ 0xBC8D, 0x613A },
	{ 0xBC8E, 0x612A },
	{ 0xBC8F, 0x6143 },
	{ 0xBC90, 0x6119 },
	{ 0xBC91, 0x6131 },
	{ 0xBC92, 0x613D },
	{ 0xBC93, 0x6408 },
	{ 0xBC94, 0x6432 },
	{ 0xBC95, 0x6438 },
	{ 0xBC96, 0x6431 },
	{ 0xBC97, 0x6419 },
	{ 0xBC98, 0x6411 },
	{ 0xBC99, 0x6429 },
	{ 0xBC9A, 0x641D },
	{ 0xBC9B, 0x643C },
	{ 0xBC9C, 0x6446 },
	{ 0xBC9D, 0x6447 },
	{ 0xBC9E, 0x643A },
	{ 0xBC9F, 0x6407 },
	{ 0xBCA0, 0x656B },
	{ 0xBCA1, 0x617C },
	{ 0xBCA2, 0x6170 },
	{ 0xBCA3, 0x616B },
	{ 0xBCA4, 0x617E },
	{ 0xBCA5, 0x61A7 },
	{ 0xBCA6, 0x6190 },
	{ 0xBCA7, 0x61AB },
	{ 0xBCA8, 0x618E },
	{ 0xBCA9, 0x61AC },
	{ 0xBCAA, 0x619A },
	{ 0xBCAB, 0x61A4 },
	{ 0xBCAC, 0x6194 },
	{ 0xBCAD, 0x61AE },
	{ 0xBCAE, 0x622E },
	{ 0xBCAF, 0x6469 },
	{ 0xBCB0, 0x646F },
	{ 0xBCB1, 0x6479 },
	{ 0xBCB2, 0x649E },
	{ 0xBCB3, 0x64B2 },
	{ 0xBCB4, 0x6488 },
	{ 0xBCB5, 0x6490 },
	{ 0xBCB6, 0x64B0 },
	{ 0xBCB7, 0x64A5 },
	{ 0xBCB8, 0x6493 },
	{ 0xBCB9, 0x6495 },
	{ 0xBCBA, 0x64A9 },
	{ 0xBCBB, 0x6492 },
	{ 0xBCBC, 0x64AE },
	{ 0xBCBD, 0x64AD },
	{ 0xBCBE, 0x64AB },
	{ 0xBCBF, 0x649A },
	{ 0xBCC0, 0x64AC },
	{ 0xBCC1, 0x6499 },
	{ 0xBCC2, 0x64A2 },
	{ 0xBCC3, 0x64B3 },
	{ 0xBCC4, 0x6575 },
	{ 0xBCC5, 0x6577 },
	{ 0xBCC6, 0x6578 },
	{ 0xBCC7, 0x66AE },
	{ 0xBCC8, 0x66AB },
	{ 0xBCC9, 0x66B4 },
	{ 0xBCCA, 0x66B1 },
	{ 0xBCCB, 0x6A23 },
	{ 0xBCCC, 0x6A1F },
	{ 0xBCCD, 0x69E8 },
	{ 0xBCCE, 0x6A01 },
	{ 0xBCCF, 0x6A1E },
	{ 0xBCD0, 0x6A19 },
	{ 0xBCD1, 0x69FD },
	{ 0xBCD2, 0x6A21 },
	{ 0xBCD3, 0x6A13 },
	{ 0xBCD4, 0x6A0A },
	{ 0xBCD5, 0x69F3 },
	{ 0xBCD6, 0x6A02 },
	{ 0xBCD7, 0x6A05 },
	{ 0xBCD8, 0x69ED },
	{ 0xBCD9, 0x6A11 },
	{ 0xBCDA, 0x6B50 },
	{ 0xBCDB, 0x6B4E },
	{ 0xBCDC, 0x6BA4 },
	{ 0xBCDD, 0x6BC5 },
	{ 0xBCDE, 0x6BC6 },
	{ 0xBCDF, 0x6F3F },
	{ 0xBCE0, 0x6F7C },
	{ 0xBCE1, 0x6F84 },
	{ 0xBCE2, 0x6F51 },
	{ 0xBCE3, 0x6F66 },
	{ 0xBCE4, 0x6F54 },
	{ 0xBCE5, 0x6F86 },
	{ 0xBCE6, 0x6F6D },
	{ 0xBCE7, 0x6F5B },
	{ 0xBCE8, 0x6F78 },
	{ 0xBCE9, 0x6F6E },
	{ 0xBCEA, 0x6F8E },
	{ 0xBCEB, 0x6F7A },
	{ 0xBCEC, 0x6F70 },
	{ 0xBCED, 0x6F64 },
	{ 0xBCEE, 0x6F97 },
	{ 0xBCEF, 0x6F58 },
	{ 0xBCF0, 0x6ED5 },
	{ 0xBCF1, 0x6F6F },
	{ 0xBCF2, 0x6F60 },
	{ 0xBCF3, 0x6F5F },
	{ 0xBCF4, 0x719F },
	{ 0xBCF5, 0x71AC },
	{ 0xBCF6, 0x71B1 },
	{ 0xBCF7, 0x71A8 },
	{ 0xBCF8, 0x7256 },
	{ 0xBCF9, 0x729B },
	{ 0xBCFA, 0x734E },
	{ 0xBCFB, 0x7357 },
	{ 0xBCFC, 0x7469 },
	{ 0xBCFD, 0x748B },
	{ 0xBCFE, 0x7483 },
	{ 0xBD40, 0x747E },
	{ 0xBD41, 0x7480 },
	{ 0xBD42, 0x757F },
	{ 0xBD43, 0x7620 },
	{ 0xBD44, 0x7629 },
	{ 0xBD45, 0x761F },
	{ 0xBD46, 0x7624 },
	{ 0xBD47, 0x7626 },
	{ 0xBD48, 0x7621 },
	{ 0xBD49, 0x7622 },
	{ 0xBD4A, 0x769A },
	{ 0xBD4B, 0x76BA },
	{ 0xBD4C, 0x76E4 },
	{ 0xBD4D, 0x778E },
	{ 0xBD4E, 0x7787 },
	{ 0xBD4F, 0x778C },
	{ 0xBD50, 0x7791 },
	{ 0xBD51, 0x778B },
	{ 0xBD52, 0x78CB },
	{ 0xBD53, 0x78C5 },
	{ 0xBD54, 0x78BA },
	{ 0xBD55, 0x78CA },
	{ 0xBD56, 0x78BE },
	{ 0xBD57, 0x78D5 },
	{ 0xBD58, 0x78BC },
	{ 0xBD59, 0x78D0 },
	{ 0xBD5A, 0x7A3F },
	{ 0xBD5B, 0x7A3C },
	{ 0xBD5C, 0x7A40 },
	{ 0xBD5D, 0x7A3D },
	{ 0xBD5E, 0x7A37 },
	{ 0xBD5F, 0x7A3B },
	{ 0xBD60, 0x7AAF },
	{ 0xBD61, 0x7AAE },
	{ 0xBD62, 0x7BAD },
	{ 0xBD63, 0x7BB1 },
	{ 0xBD64, 0x7BC4 },
	{ 0xBD65, 0x7BB4 },
	{ 0xBD66, 0x7BC6 },
	{ 0xBD67, 0x7BC7 },
	{ 0xBD68, 0x7BC1 },
	{ 0xBD69, 0x7BA0 },
	{ 0xBD6A, 0x7BCC },
	{ 0xBD6B, 0x7CCA },
	{ 0xBD6C, 0x7DE0 },
	{ 0xBD6D, 0x7DF4 },
	{ 0xBD6E, 0x7DEF },
	{ 0xBD6F, 0x7DFB },
	{ 0xBD70, 0x7DD8 },
	{ 0xBD71, 0x7DEC },
	{ 0xBD72, 0x7DDD },
	{ 0xBD73, 0x7DE8 },
	{ 0xBD74, 0x7DE3 },
	{ 0xBD75, 0x7DDA },
	{ 0xBD76, 0x7DDE },
	{ 0xBD77, 0x7DE9 },
	{ 0xBD78, 0x7D9E },
	{ 0xBD79, 0x7DD9 },
	{ 0xBD7A, 0x7DF2 },
	{ 0xBD7B, 0x7DF9 },
	{ 0xBD7C, 0x7F75 },
	{ 0xBD7D, 0x7F77 },
	{ 0xBD7E, 0x7FAF },
	{ 0xBD7F, 0xFFFD },
	{ 0xBD80, 0x6570 },
	{ 0xBD81, 0x656D },
	{ 0xBD82, 0x65E4 },
	{ 0xBD83, 0x6693 },
	{ 0xBD84, 0x668F },
	{ 0xBD85, 0x6692 },
	{ 0xBD86, 0x668E },
	{ 0xBD87, 0x6946 },
	{ 0xBD88, 0x6931 },
	{ 0xBD89, 0x693E },
	{ 0xBD8A, 0x697C },
	{ 0xBD8B, 0x6943 },
	{ 0xBD8C, 0x6973 },
	{ 0xBD8D, 0x6955 },
	{ 0xBD8E, 0x6985 },
	{ 0xBD8F, 0x694D },
	{ 0xBD90, 0x6950 },
	{ 0xBD91, 0x6947 },
	{ 0xBD92, 0x6967 },
	{ 0xBD93, 0x6936 },
	{ 0xBD94, 0x6964 },
	{ 0xBD95, 0x6961 },
	{ 0xBD96, 0x697D },
	{ 0xBD97, 0x6B44 },
	{ 0xBD98, 0x6B40 },
	{ 0xBD99, 0x6B71 },
	{ 0xBD9A, 0x6B73 },
	{ 0xBD9B, 0x6B9C },
	{ 0xBD9C, 0x6BC1 },
	{ 0xBD9D, 0x6BFA },
	{ 0xBD9E, 0x6C31 },
	{ 0xBD9F, 0x6C32 },
	{ 0xBDA0, 0x6EB8 },
	{ 0xBDA1, 0x7FE9 },
	{ 0xBDA2, 0x8026 },
	{ 0xBDA3, 0x819B },
	{ 0xBDA4, 0x819C },
	{ 0xBDA5, 0x819D },
	{ 0xBDA6, 0x81A0 },
	{ 0xBDA7, 0x819A },
	{ 0xBDA8, 0x8198 },
	{ 0xBDA9, 0x8517 },
	{ 0xBDAA, 0x853D },
	{ 0xBDAB, 0x851A },
	{ 0xBDAC, 0x84EE },
	{ 0xBDAD, 0x852C },
	{ 0xBDAE, 0x852D },
	{ 0xBDAF, 0x8513 },
	{ 0xBDB0, 0x8511 },
	{ 0xBDB1, 0x8523 },
	{ 0xBDB2, 0x8521 },
	{ 0xBDB3, 0x8514 },
	{ 0xBDB4, 0x84EC },
	{ 0xBDB5, 0x8525 },
	{ 0xBDB6, 0x84FF },
	{ 0xBDB7, 0x8506 },
	{ 0xBDB8, 0x8782 },
	{ 0xBDB9, 0x8774 },
	{ 0xBDBA, 0x8776 },
	{ 0xBDBB, 0x8760 },
	{ 0xBDBC, 0x8766 },
	{ 0xBDBD, 0x8778 },
	{ 0xBDBE, 0x8768 },
	{ 0xBDBF, 0x8759 },
	{ 0xBDC0, 0x8757 },
	{ 0xBDC1, 0x874C },
	{ 0xBDC2, 0x8753 },
	{ 0xBDC3, 0x885B },
	{ 0xBDC4, 0x885D },
	{ 0xBDC5, 0x8910 },
	{ 0xBDC6, 0x8907 },
	{ 0xBDC7, 0x8912 },
	{ 0xBDC8, 0x8913 },
	{ 0xBDC9, 0x8915 },
	{ 0xBDCA, 0x890A },
	{ 0xBDCB, 0x8ABC },
	{ 0xBDCC, 0x8AD2 },
	{ 0xBDCD, 0x8AC7 },
	{ 0xBDCE, 0x8AC4 },
	{ 0xBDCF, 0x8A95 },
	{ 0xBDD0, 0x8ACB },
	{ 0xBDD1, 0x8AF8 },
	{ 0xBDD2, 0x8AB2 },
	{ 0xBDD3, 0x8AC9 },
	{ 0xBDD4, 0x8AC2 },
	{ 0xBDD5, 0x8ABF },
	{ 0xBDD6, 0x8AB0 },
	{ 0xBDD7, 0x8AD6 },
	{ 0xBDD8, 0x8ACD },
	{ 0xBDD9, 0x8AB6 },
	{ 0xBDDA, 0x8AB9 },
	{ 0xBDDB, 0x8ADB },
	{ 0xBDDC, 0x8C4C },
	{ 0xBDDD, 0x8C4E },
	{ 0xBDDE, 0x8C6C },
	{ 0xBDDF, 0x8CE0 },
	{ 0xBDE0, 0x8CDE },
	{ 0xBDE1, 0x8CE6 },
	{ 0xBDE2, 0x8CE4 },
	{ 0xBDE3, 0x8CEC },
	{ 0xBDE4, 0x8CED },
	{ 0xBDE5, 0x8CE2 },
	{ 0xBDE6, 0x8CE3 },
	{ 0xBDE7, 0x8CDC },
	{ 0xBDE8, 0x8CEA },
	{ 0xBDE9, 0x8CE1 },
	{ 0xBDEA, 0x8D6D },
	{ 0xBDEB, 0x8D9F },
	{ 0xBDEC, 0x8DA3 },
	{ 0xBDED, 0x8E2B },
	{ 0xBDEE, 0x8E10 },
	{ 0xBDEF, 0x8E1D },
	{ 0xBDF0, 0x8E22 },
	{ 0xBDF1, 0x8E0F },
	{ 0xBDF2, 0x8E29 },
	{ 0xBDF3, 0x8E1F },
	{ 0xBDF4, 0x8E21 },
	{ 0xBDF5, 0x8E1E },
	{ 0xBDF6, 0x8EBA },
	{ 0xBDF7, 0x8F1D },
	{ 0xBDF8, 0x8F1B },
	{ 0xBDF9, 0x8F1F },
	{ 0xBDFA, 0x8F29 },
	{ 0xBDFB, 0x8F26 },
	{ 0xBDFC, 0x8F2A },
	{ 0xBDFD, 0x8F1C },
	{ 0xBDFE, 0x8F1E },
	{ 0xBE40, 0x8F25 },
	{ 0xBE41, 0x9069 },
	{ 0xBE42, 0x906E },
	{ 0xBE43, 0x9068 },
	{ 0xBE44, 0x906D },
	{ 0xBE45, 0x9077 },
	{ 0xBE46, 0x9130 },
	{ 0xBE47, 0x912D },
	{ 0xBE48, 0x9127 },
	{ 0xBE49, 0x9131 },
	{ 0xBE4A, 0x9187 },
	{ 0xBE4B, 0x9189 },
	{ 0xBE4C, 0x918B },
	{ 0xBE4D, 0x9183 },
	{ 0xBE4E, 0x92C5 },
	{ 0xBE4F, 0x92BB },
	{ 0xBE50, 0x92B7 },
	{ 0xBE51, 0x92EA },
	{ 0xBE52, 0x92AC },
	{ 0xBE53, 0x92E4 },
	{ 0xBE54, 0x92C1 },
	{ 0xBE55, 0x92B3 },
	{ 0xBE56, 0x92BC },
	{ 0xBE57, 0x92D2 },
	{ 0xBE58, 0x92C7 },
	{ 0xBE59, 0x92F0 },
	{ 0xBE5A, 0x92B2 },
	{ 0xBE5B, 0x95AD },
	{ 0xBE5C, 0x95B1 },
	{ 0xBE5D, 0x9704 },
	{ 0xBE5E, 0x9706 },
	{ 0xBE5F, 0x9707 },
	{ 0xBE60, 0x9709 },
	{ 0xBE61, 0x9760 },
	{ 0xBE62, 0x978D },
	{ 0xBE63, 0x978B },
	{ 0xBE64, 0x978F },
	{ 0xBE65, 0x9821 },
	{ 0xBE66, 0x982B },
	{ 0xBE67, 0x981C },
	{ 0xBE68, 0x98B3 },
	{ 0xBE69, 0x990A },
	{ 0xBE6A, 0x9913 },
	{ 0xBE6B, 0x9912 },
	{ 0xBE6C, 0x9918 },
	{ 0xBE6D, 0x99DD },
	{ 0xBE6E, 0x99D0 },
	{ 0xBE6F, 0x99DF },
	{ 0xBE70, 0x99DB },
	{ 0xBE71, 0x99D1 },
	{ 0xBE72, 0x99D5 },
	{ 0xBE73, 0x99D2 },
	{ 0xBE74, 0x99D9 },
	{ 0xBE75, 0x9AB7 },
	{ 0xBE76, 0x9AEE },
	{ 0xBE77, 0x9AEF },
	{ 0xBE78, 0x9B27 },
	{ 0xBE79, 0x9B45 },
	{ 0xBE7A, 0x9B44 },
	{ 0xBE7B, 0x9B77 },
	{ 0xBE7C, 0x9B6F },
	{ 0xBE7D, 0x9D06 },
	{ 0xBE7E, 0x9D09 },
	{ 0xBE7F, 0xFFFD },
	{ 0xBE80, 0x6EA8 },
	{ 0xBE81, 0x6E91 },
	{ 0xBE82, 0x6EBB },
	{ 0xBE83, 0x6E9A },
	{ 0xBE84, 0x6EA9 },
	{ 0xBE85, 0x6EB5 },
	{ 0xBE86, 0x6E6C },
	{ 0xBE87, 0x6EE8 },
	{ 0xBE88, 0x6EDD },
	{ 0xBE89, 0x6EDA },
	{ 0xBE8A, 0x6EE6 },
	{ 0xBE8B, 0x6EAC },
	{ 0xBE8C, 0x6ED9 },
	{ 0xBE8D, 0x6EE3 },
	{ 0xBE8E, 0x6EE9 },
	{ 0xBE8F, 0x6EDB },
	{ 0xBE90, 0x716F },
	{ 0xBE91, 0x7148 },
	{ 0xBE92, 0x714A },
	{ 0xBE93, 0x716B },
	{ 0xBE94, 0x714F },
	{ 0xBE95, 0x7157 },
	{ 0xBE96, 0x7174 },
	{ 0xBE97, 0x7145 },
	{ 0xBE98, 0x7151 },
	{ 0xBE99, 0x716D },
	{ 0xBE9A, 0x7251 },
	{ 0xBE9B, 0x7250 },
	{ 0xBE9C, 0x724E },
	{ 0xBE9D, 0x7341 },
	{ 0xBE9E, 0x732E },
	{ 0xBE9F, 0x7346 },
	{ 0xBEA0, 0x7427 },
	{ 0xBEA1, 0x9D03 },
	{ 0xBEA2, 0x9EA9 },
	{ 0xBEA3, 0x9EBE },
	{ 0xBEA4, 0x9ECE },
	{ 0xBEA5, 0x58A8 },
	{ 0xBEA6, 0x9F52 },
	{ 0xBEA7, 0x5112 },
	{ 0xBEA8, 0x5118 },
	{ 0xBEA9, 0x5114 },
	{ 0xBEAA, 0x5110 },
	{ 0xBEAB, 0x5115 },
	{ 0xBEAC, 0x5180 },
	{ 0xBEAD, 0x51AA },
	{ 0xBEAE, 0x51DD },
	{ 0xBEAF, 0x5291 },
	{ 0xBEB0, 0x5293 },
	{ 0xBEB1, 0x52F3 },
	{ 0xBEB2, 0x5659 },
	{ 0xBEB3, 0x566B },
	{ 0xBEB4, 0x5679 },
	{ 0xBEB5, 0x5669 },
	{ 0xBEB6, 0x5664 },
	{ 0xBEB7, 0x5678 },
	{ 0xBEB8, 0x566A },
	{ 0xBEB9, 0x5668 },
	{ 0xBEBA, 0x5665 },
	{ 0xBEBB, 0x5671 },
	{ 0xBEBC, 0x566F },
	{ 0xBEBD, 0x566C },
	{ 0xBEBE, 0x5662 },
	{ 0xBEBF, 0x5676 },
	{ 0xBEC0, 0x58C1 },
	{ 0xBEC1, 0x58BE },
	{ 0xBEC2, 0x58C7 },
	{ 0xBEC3, 0x58C5 },
	{ 0xBEC4, 0x596E },
	{ 0xBEC5, 0x5B1D },
	{ 0xBEC6, 0x5B34 },
	{ 0xBEC7, 0x5B78 },
	{ 0xBEC8, 0x5BF0 },
	{ 0xBEC9, 0x5C0E },
	{ 0xBECA, 0x5F4A },
	{ 0xBECB, 0x61B2 },
	{ 0xBECC, 0x6191 },
	{ 0xBECD, 0x61A9 },
	{ 0xBECE, 0x618A },
	{ 0xBECF, 0x61CD },
	{ 0xBED0, 0x61B6 },
	{ 0xBED1, 0x61BE },
	{ 0xBED2, 0x61CA },
	{ 0xBED3, 0x61C8 },
	{ 0xBED4, 0x6230 },
	{ 0xBED5, 0x64C5 },
	{ 0xBED6, 0x64C1 },
	{ 0xBED7, 0x64CB },
	{ 0xBED8, 0x64BB },
	{ 0xBED9, 0x64BC },
	{ 0xBEDA, 0x64DA },
	{ 0xBEDB, 0x64C4 },
	{ 0xBEDC, 0x64C7 },
	{ 0xBEDD, 0x64C2 },
	{ 0xBEDE, 0x64CD },
	{ 0xBEDF, 0x64BF },
	{ 0xBEE0, 0x64D2 },
	{ 0xBEE1, 0x64D4 },
	{ 0xBEE2, 0x64BE },
	{ 0xBEE3, 0x6574 },
	{ 0xBEE4, 0x66C6 },
	{ 0xBEE5, 0x66C9 },
	{ 0xBEE6, 0x66B9 },
	{ 0xBEE7, 0x66C4 },
	{ 0xBEE8, 0x66C7 },
	{ 0xBEE9, 0x66B8 },
	{ 0xBEEA, 0x6A3D },
	{ 0xBEEB, 0x6A38 },
	{ 0xBEEC, 0x6A3A },
	{ 0xBEED, 0x6A59 },
	{ 0xBEEE, 0x6A6B },
	{ 0xBEEF, 0x6A58 },
	{ 0xBEF0, 0x6A39 },
	{ 0xBEF1, 0x6A44 },
	{ 0xBEF2, 0x6A62 },
	{ 0xBEF3, 0x6A61 },
	{ 0xBEF4, 0x6A4B },
	{ 0xBEF5, 0x6A47 },
	{ 0xBEF6, 0x6A35 },
	{ 0xBEF7, 0x6A5F },
	{ 0xBEF8, 0x6A48 },
	{ 0xBEF9, 0x6B59 },
	{ 0xBEFA, 0x6B77 },
	{ 0xBEFB, 0x6C05 },
	{ 0xBEFC, 0x6FC2 },
	{ 0xBEFD, 0x6FB1 },
	{ 0xBEFE, 0x6FA1 },
	{ 0xBF40, 0x6FC3 },
	{ 0xBF41, 0x6FA4 },
	{ 0xBF42, 0x6FC1 },
	{ 0xBF43, 0x6FA7 },
	{ 0xBF44, 0x6FB3 },
	{ 0xBF45, 0x6FC0 },
	{ 0xBF46, 0x6FB9 },
	{ 0xBF47, 0x6FB6 },
	{ 0xBF48, 0x6FA6 },
	{ 0xBF49, 0x6FA0 },
	{ 0xBF4A, 0x6FB4 },
	{ 0xBF4B, 0x71BE },
	{ 0xBF4C, 0x71C9 },
	{ 0xBF4D, 0x71D0 },
	{ 0xBF4E, 0x71D2 },
	{ 0xBF4F, 0x71C8 },
	{ 0xBF50, 0x71D5 },
	{ 0xBF51, 0x71B9 },
	{ 0xBF52, 0x71CE },
	{ 0xBF53, 0x71D9 },
	{ 0xBF54, 0x71DC },
	{ 0xBF55, 0x71C3 },
	{ 0xBF56, 0x71C4 },
	{ 0xBF57, 0x7368 },
	{ 0xBF58, 0x749C },
	{ 0xBF59, 0x74A3 },
	{ 0xBF5A, 0x7498 },
	{ 0xBF5B, 0x749F },
	{ 0xBF5C, 0x749E },
	{ 0xBF5D, 0x74E2 },
	{ 0xBF5E, 0x750C },
	{ 0xBF5F, 0x750D },
	{ 0xBF60, 0x7634 },
	{ 0xBF61, 0x7638 },
	{ 0xBF62, 0x763A },
	{ 0xBF63, 0x76E7 },
	{ 0xBF64, 0x76E5 },
	{ 0xBF65, 0x77A0 },
	{ 0xBF66, 0x779E },
	{ 0xBF67, 0x779F },
	{ 0xBF68, 0x77A5 },
	{ 0xBF69, 0x78E8 },
	{ 0xBF6A, 0x78DA },
	{ 0xBF6B, 0x78EC },
	{ 0xBF6C, 0x78E7 },
	{ 0xBF6D, 0x79A6 },
	{ 0xBF6E, 0x7A4D },
	{ 0xBF6F, 0x7A4E },
	{ 0xBF70, 0x7A46 },
	{ 0xBF71, 0x7A4C },
	{ 0xBF72, 0x7A4B },
	{ 0xBF73, 0x7ABA },
	{ 0xBF74, 0x7BD9 },
	{ 0xBF75, 0x7C11 },
	{ 0xBF76, 0x7BC9 },
	{ 0xBF77, 0x7BE4 },
	{ 0xBF78, 0x7BDB },
	{ 0xBF79, 0x7BE1 },
	{ 0xBF7A, 0x7BE9 },
	{ 0xBF7B, 0x7BE6 },
	{ 0xBF7C, 0x7CD5 },
	{ 0xBF7D, 0x7CD6 },
	{ 0xBF7E, 0x7E0A },
	{ 0xBF7F, 0xFFFD },
	{ 0xBF80, 0x7448 },
	{ 0xBF81, 0x7453 },
	{ 0xBF82, 0x743D },
	{ 0xBF83, 0x745D },
	{ 0xBF84, 0x7456 },
	{ 0xBF85, 0x741E },
	{ 0xBF86, 0x7447 },
	{ 0xBF87, 0x7443 },
	{ 0xBF88, 0x7458 },
	{ 0xBF89, 0x7449 },
	{ 0xBF8A, 0x744C },
	{ 0xBF8B, 0x7445 },
	{ 0xBF8C, 0x743E },
	{ 0xBF8D, 0x7501 },
	{ 0xBF8E, 0x751E },
	{ 0xBF8F, 0x757A },
	{ 0xBF90, 0x75EE },
	{ 0xBF91, 0x7602 },
	{ 0xBF92, 0x7697 },
	{ 0xBF93, 0x7698 },
	{ 0xBF94, 0x775D },
	{ 0xBF95, 0x7764 },
	{ 0xBF96, 0x7753 },
	{ 0xBF97, 0x7758 },
	{ 0xBF98, 0x7882 },
	{ 0xBF99, 0x7890 },
	{ 0xBF9A, 0x788A },
	{ 0xBF9B, 0x787A },
	{ 0xBF9C, 0x787D },
	{ 0xBF9D, 0x788B },
	{ 0xBF9E, 0x7878 },
	{ 0xBF9F, 0x788D },
	{ 0xBFA0, 0x7888 },
	{ 0xBFA1, 0x7E11 },
	{ 0xBFA2, 0x7E08 },
	{ 0xBFA3, 0x7E1B },
	{ 0xBFA4, 0x7E23 },
	{ 0xBFA5, 0x7E1E },
	{ 0xBFA6, 0x7E1D },
	{ 0xBFA7, 0x7E09 },
	{ 0xBFA8, 0x7E10 },
	{ 0xBFA9, 0x7F79 },
	{ 0xBFAA, 0x7FB2 },
	{ 0xBFAB, 0x7FF0 },
	{ 0xBFAC, 0x7FF1 },
	{ 0xBFAD, 0x7FEE },
	{ 0xBFAE, 0x8028 },
	{ 0xBFAF, 0x81B3 },
	{ 0xBFB0, 0x81A9 },
	{ 0xBFB1, 0x81A8 },
	{ 0xBFB2, 0x81FB },
	{ 0xBFB3, 0x8208 },
	{ 0xBFB4, 0x8258 },
	{ 0xBFB5, 0x8259 },
	{ 0xBFB6, 0x854A },
	{ 0xBFB7, 0x8559 },
	{ 0xBFB8, 0x8548 },
	{ 0xBFB9, 0x8568 },
	{ 0xBFBA, 0x8569 },
	{ 0xBFBB, 0x8543 },
	{ 0xBFBC, 0x8549 },
	{ 0xBFBD, 0x856D },
	{ 0xBFBE, 0x856A },
	{ 0xBFBF, 0x855E },
	{ 0xBFC0, 0x8783 },
	{ 0xBFC1, 0x879F },
	{ 0xBFC2, 0x879E },
	{ 0xBFC3, 0x87A2 },
	{ 0xBFC4, 0x878D },
	{ 0xBFC5, 0x8861 },
	{ 0xBFC6, 0x892A },
	{ 0xBFC7, 0x8932 },
	{ 0xBFC8, 0x8925 },
	{ 0xBFC9, 0x892B },
	{ 0xBFCA, 0x8921 },
	{ 0xBFCB, 0x89AA },
	{ 0xBFCC, 0x89A6 },
	{ 0xBFCD, 0x8AE6 },
	{ 0xBFCE, 0x8AFA },
	{ 0xBFCF, 0x8AEB },
	{ 0xBFD0, 0x8AF1 },
	{ 0xBFD1, 0x8B00 },
	{ 0xBFD2, 0x8ADC },
	{ 0xBFD3, 0x8AE7 },
	{ 0xBFD4, 0x8AEE },
	{ 0xBFD5, 0x8AFE },
	{ 0xBFD6, 0x8B01 },
	{ 0xBFD7, 0x8B02 },
	{ 0xBFD8, 0x8AF7 },
	{ 0xBFD9, 0x8AED },
	{ 0xBFDA, 0x8AF3 },
	{ 0xBFDB, 0x8AF6 },
	{ 0xBFDC, 0x8AFC },
	{ 0xBFDD, 0x8C6B },
	{ 0xBFDE, 0x8C6D },
	{ 0xBFDF, 0x8C93 },
	{ 0xBFE0, 0x8CF4 },
	{ 0xBFE1, 0x8E44 },
	{ 0xBFE2, 0x8E31 },
	{ 0xBFE3, 0x8E34 },
	{ 0xBFE4, 0x8E42 },
	{ 0xBFE5, 0x8E39 },
	{ 0xBFE6, 0x8E35 },
	{ 0xBFE7, 0x8F3B },
	{ 0xBFE8, 0x8F2F },
	{ 0xBFE9, 0x8F38 },
	{ 0xBFEA, 0x8F33 },
	{ 0xBFEB, 0x8FA8 },
	{ 0xBFEC, 0x8FA6 },
	{ 0xBFED, 0x9075 },
	{ 0xBFEE, 0x9074 },
	{ 0xBFEF, 0x9078 },
	{ 0xBFF0, 0x9072 },
	{ 0xBFF1, 0x907C },
	{ 0xBFF2, 0x907A },
	{ 0xBFF3, 0x9134 },
	{ 0xBFF4, 0x9192 },
	{ 0xBFF5, 0x9320 },
	{ 0xBFF6, 0x9336 },
	{ 0xBFF7, 0x92F8 },
	{ 0xBFF8, 0x9333 },
	{ 0xBFF9, 0x932F },
	{ 0xBFFA, 0x9322 },
	{ 0xBFFB, 0x92FC },
	{ 0xBFFC, 0x932B },
	{ 0xBFFD, 0x9304 },
	{ 0xBFFE, 0x931A },
	{ 0xC040, 0x9310 },
	{ 0xC041, 0x9326 },
	{ 0xC042, 0x9321 },
	{ 0xC043, 0x9315 },
	{ 0xC044, 0x932E },
	{ 0xC045, 0x9319 },
	{ 0xC046, 0x95BB },
	{ 0xC047, 0x96A7 },
	{ 0xC048, 0x96A8 },
	{ 0xC049, 0x96AA },
	{ 0xC04A, 0x96D5 },
	{ 0xC04B, 0x970E },
	{ 0xC04C, 0x9711 },
	{ 0xC04D, 0x9716 },
	{ 0xC04E, 0x970D },
	{ 0xC04F, 0x9713 },
	{ 0xC050, 0x970F },
	{ 0xC051, 0x975B },
	{ 0xC052, 0x975C },
	{ 0xC053, 0x9766 },
	{ 0xC054, 0x9798 },
	{ 0xC055, 0x9830 },
	{ 0xC056, 0x9838 },
	{ 0xC057, 0x983B },
	{ 0xC058, 0x9837 },
	{ 0xC059, 0x982D },
	{ 0xC05A, 0x9839 },
	{ 0xC05B, 0x9824 },
	{ 0xC05C, 0x9910 },
	{ 0xC05D, 0x9928 },
	{ 0xC05E, 0x991E },
	{ 0xC05F, 0x991B },
	{ 0xC060, 0x9921 },
	{ 0xC061, 0x991A },
	{ 0xC062, 0x99ED },
	{ 0xC063, 0x99E2 },
	{ 0xC064, 0x99F1 },
	{ 0xC065, 0x9AB8 },
	{ 0xC066, 0x9ABC },
	{ 0xC067, 0x9AFB },
	{ 0xC068, 0x9AED },
	{ 0xC069, 0x9B28 },
	{ 0xC06A, 0x9B91 },
	{ 0xC06B, 0x9D15 },
	{ 0xC06C, 0x9D23 },
	{ 0xC06D, 0x9D26 },
	{ 0xC06E, 0x9D28 },
	{ 0xC06F, 0x9D12 },
	{ 0xC070, 0x9D1B },
	{ 0xC071, 0x9ED8 },
	{ 0xC072, 0x9ED4 },
	{ 0xC073, 0x9F8D },
	{ 0xC074, 0x9F9C },
	{ 0xC075, 0x512A },
	{ 0xC076, 0x511F },
	{ 0xC077, 0x5121 },
	{ 0xC078, 0x5132 },
	{ 0xC079, 0x52F5 },
	{ 0xC07A, 0x568E },
	{ 0xC07B, 0x5680 },
	{ 0xC07C, 0x5690 },
	{ 0xC07D, 0x5685 },
	{ 0xC07E, 0x5687 },
	{ 0xC07F, 0xFFFD },
	{ 0xC080, 0x7892 },
	{ 0xC081, 0x797E },
	{ 0xC082, 0x7983 },
	{ 0xC083, 0x7980 },
	{ 0xC084, 0x7A0F },
	{ 0xC085, 0x7A1D },
	{ 0xC086, 0x7AA1 },
	{ 0xC087, 0x7AA4 },
	{ 0xC088, 0x7AE9 },
	{ 0xC089, 0x7AEA },
	{ 0xC08A, 0x7B62 },
	{ 0xC08B, 0x7B6B },
	{ 0xC08C, 0x7B5E },
	{ 0xC08D, 0x7B79 },
	{ 0xC08E, 0x7B6F },
	{ 0xC08F, 0x7B68 },
	{ 0xC090, 0x7CAE },
	{ 0xC091, 0x7CB0 },
	{ 0xC092, 0x7D90 },
	{ 0xC093, 0x7D8A },
	{ 0xC094, 0x7D8B },
	{ 0xC095, 0x7D99 },
	{ 0xC096, 0x7D95 },
	{ 0xC097, 0x7D87 },
	{ 0xC098, 0x7D78 },
	{ 0xC099, 0x7D97 },
	{ 0xC09A, 0x7D89 },
	{ 0xC09B, 0x7D98 },
	{ 0xC09C, 0x7FA3 },
	{ 0xC09D, 0x7FDD },
	{ 0xC09E, 0x8057 },
	{ 0xC09F, 0x8163 },
	{ 0xC0A0, 0x816A },
	{ 0xC0A1, 0x568F },
	{ 0xC0A2, 0x58D5 },
	{ 0xC0A3, 0x58D3 },
	{ 0xC0A4, 0x58D1 },
	{ 0xC0A5, 0x58CE },
	{ 0xC0A6, 0x5B30 },
	{ 0xC0A7, 0x5B2A },
	{ 0xC0A8, 0x5B24 },
	{ 0xC0A9, 0x5B7A },
	{ 0xC0AA, 0x5C37 },
	{ 0xC0AB, 0x5C68 },
	{ 0xC0AC, 0x5DBC },
	{ 0xC0AD, 0x5DBA },
	{ 0xC0AE, 0x5DBD },
	{ 0xC0AF, 0x5DB8 },
	{ 0xC0B0, 0x5E6B },
	{ 0xC0B1, 0x5F4C },
	{ 0xC0B2, 0x5FBD },
	{ 0xC0B3, 0x61C9 },
	{ 0xC0B4, 0x61C2 },
	{ 0xC0B5, 0x61C7 },
	{ 0xC0B6, 0x61E6 },
	{ 0xC0B7, 0x61CB },
	{ 0xC0B8, 0x6232 },
	{ 0xC0B9, 0x6234 },
	{ 0xC0BA, 0x64CE },
	{ 0xC0BB, 0x64CA },
	{ 0xC0BC, 0x64D8 },
	{ 0xC0BD, 0x64E0 },
	{ 0xC0BE, 0x64F0 },
	{ 0xC0BF, 0x64E6 },
	{ 0xC0C0, 0x64EC },
	{ 0xC0C1, 0x64F1 },
	{ 0xC0C2, 0x64E2 },
	{ 0xC0C3, 0x64ED },
	{ 0xC0C4, 0x6582 },
	{ 0xC0C5, 0x6583 },
	{ 0xC0C6, 0x66D9 },
	{ 0xC0C7, 0x66D6 },
	{ 0xC0C8, 0x6A80 },
	{ 0xC0C9, 0x6A94 },
	{ 0xC0CA, 0x6A84 },
	{ 0xC0CB, 0x6AA2 },
	{ 0xC0CC, 0x6A9C },
	{ 0xC0CD, 0x6ADB },
	{ 0xC0CE, 0x6AA3 },
	{ 0xC0CF, 0x6A7E },
	{ 0xC0D0, 0x6A97 },
	{ 0xC0D1, 0x6A90 },
	{ 0xC0D2, 0x6AA0 },
	{ 0xC0D3, 0x6B5C },
	{ 0xC0D4, 0x6BAE },
	{ 0xC0D5, 0x6BDA },
	{ 0xC0D6, 0x6C08 },
	{ 0xC0D7, 0x6FD8 },
	{ 0xC0D8, 0x6FF1 },
	{ 0xC0D9, 0x6FDF },
	{ 0xC0DA, 0x6FE0 },
	{ 0xC0DB, 0x6FDB },
	{ 0xC0DC, 0x6FE4 },
	{ 0xC0DD, 0x6FEB },
	{ 0xC0DE, 0x6FEF },
	{ 0xC0DF, 0x6F80 },
	{ 0xC0E0, 0x6FEC },
	{ 0xC0E1, 0x6FE1 },
	{ 0xC0E2, 0x6FE9 },
	{ 0xC0E3, 0x6FD5 },
	{ 0xC0E4, 0x6FEE },
	{ 0xC0E5, 0x6FF0 },
	{ 0xC0E6, 0x71E7 },
	{ 0xC0E7, 0x71DF },
	{ 0xC0E8, 0x71EE },
	{ 0xC0E9, 0x71E6 },
	{ 0xC0EA, 0x71E5 },
	{ 0xC0EB, 0x71ED },
	{ 0xC0EC, 0x71EC },
	{ 0xC0ED, 0x71F4 },
	{ 0xC0EE, 0x71E0 },
	{ 0xC0EF, 0x7235 },
	{ 0xC0F0, 0x7246 },
	{ 0xC0F1, 0x7370 },
	{ 0xC0F2, 0x7372 },
	{ 0xC0F3, 0x74A9 },
	{ 0xC0F4, 0x74B0 },
	{ 0xC0F5, 0x74A6 },
	{ 0xC0F6, 0x74A8 },
	{ 0xC0F7, 0x7646 },
	{ 0xC0F8, 0x7642 },
	{ 0xC0F9, 0x764C },
	{ 0xC0FA, 0x76EA },
	{ 0xC0FB, 0x77B3 },
	{ 0xC0FC, 0x77AA },
	{ 0xC0FD, 0x77B0 },
	{ 0xC0FE, 0x77AC },
	{ 0xC140, 0x77A7 },
	{ 0xC141, 0x77AD },
	{ 0xC142, 0x77EF },
	{ 0xC143, 0x78F7 },
	{ 0xC144, 0x78FA },
	{ 0xC145, 0x78F4 },
	{ 0xC146, 0x78EF },
	{ 0xC147, 0x7901 },
	{ 0xC148, 0x79A7 },
	{ 0xC149, 0x79AA },
	{ 0xC14A, 0x7A57 },
	{ 0xC14B, 0x7ABF },
	{ 0xC14C, 0x7C07 },
	{ 0xC14D, 0x7C0D },
	{ 0xC14E, 0x7BFE },
	{ 0xC14F, 0x7BF7 },
	{ 0xC150, 0x7C0C },
	{ 0xC151, 0x7BE0 },
	{ 0xC152, 0x7CE0 },
	{ 0xC153, 0x7CDC },
	{ 0xC154, 0x7CDE },
	{ 0xC155, 0x7CE2 },
	{ 0xC156, 0x7CDF },
	{ 0xC157, 0x7CD9 },
	{ 0xC158, 0x7CDD },
	{ 0xC159, 0x7E2E },
	{ 0xC15A, 0x7E3E },
	{ 0xC15B, 0x7E46 },
	{ 0xC15C, 0x7E37 },
	{ 0xC15D, 0x7E32 },
	{ 0xC15E, 0x7E43 },
	{ 0xC15F, 0x7E2B },
	{ 0xC160, 0x7E3D },
	{ 0xC161, 0x7E31 },
	{ 0xC162, 0x7E45 },
	{ 0xC163, 0x7E41 },
	{ 0xC164, 0x7E34 },
	{ 0xC165, 0x7E39 },
	{ 0xC166, 0x7E48 },
	{ 0xC167, 0x7E35 },
	{ 0xC168, 0x7E3F },
	{ 0xC169, 0x7E2F },
	{ 0xC16A, 0x7F44 },
	{ 0xC16B, 0x7FF3 },
	{ 0xC16C, 0x7FFC },
	{ 0xC16D, 0x8071 },
	{ 0xC16E, 0x8072 },
	{ 0xC16F, 0x8070 },
	{ 0xC170, 0x806F },
	{ 0xC171, 0x8073 },
	{ 0xC172, 0x81C6 },
	{ 0xC173, 0x81C3 },
	{ 0xC174, 0x81BA },
	{ 0xC175, 0x81C2 },
	{ 0xC176, 0x81C0 },
	{ 0xC177, 0x81BF },
	{ 0xC178, 0x81BD },
	{ 0xC179, 0x81C9 },
	{ 0xC17A, 0x81BE },
	{ 0xC17B, 0x81E8 },
	{ 0xC17C, 0x8209 },
	{ 0xC17D, 0x8271 },
	{ 0xC17E, 0x85AA },
	{ 0xC17F, 0xFFFD },
	{ 0xC180, 0x816C },
	{ 0xC181, 0x815D },
	{ 0xC182, 0x8175 },
	{ 0xC183, 0x815F },
	{ 0xC184, 0x817D },
	{ 0xC185, 0x816D },
	{ 0xC186, 0x8241 },
	{ 0xC187, 0x844F },
	{ 0xC188, 0x8484 },
	{ 0xC189, 0x847F },
	{ 0xC18A, 0x8448 },
	{ 0xC18B, 0x842A },
	{ 0xC18C, 0x847B },
	{ 0xC18D, 0x8472 },
	{ 0xC18E, 0x8464 },
	{ 0xC18F, 0x842E },
	{ 0xC190, 0x845C },
	{ 0xC191, 0x8453 },
	{ 0xC192, 0x8441 },
	{ 0xC193, 0x84C8 },
	{ 0xC194, 0x8462 },
	{ 0xC195, 0x8480 },
	{ 0xC196, 0x843E },
	{ 0xC197, 0x8483 },
	{ 0xC198, 0x8471 },
	{ 0xC199, 0x844A },
	{ 0xC19A, 0x8455 },
	{ 0xC19B, 0x8458 },
	{ 0xC19C, 0x86FC },
	{ 0xC19D, 0x86FD },
	{ 0xC19E, 0x8715 },
	{ 0xC19F, 0x8716 },
	{ 0xC1A0, 0x86FF },
	{ 0xC1A1, 0x8584 },
	{ 0xC1A2, 0x857E },
	{ 0xC1A3, 0x859C },
	{ 0xC1A4, 0x8591 },
	{ 0xC1A5, 0x8594 },
	{ 0xC1A6, 0x85AF },
	{ 0xC1A7, 0x859B },
	{ 0xC1A8, 0x8587 },
	{ 0xC1A9, 0x85A8 },
	{ 0xC1AA, 0x858A },
	{ 0xC1AB, 0x8667 },
	{ 0xC1AC, 0x87C0 },
	{ 0xC1AD, 0x87D1 },
	{ 0xC1AE, 0x87B3 },
	{ 0xC1AF, 0x87D2 },
	{ 0xC1B0, 0x87C6 },
	{ 0xC1B1, 0x87AB },
	{ 0xC1B2, 0x87BB },
	{ 0xC1B3, 0x87BA },
	{ 0xC1B4, 0x87C8 },
	{ 0xC1B5, 0x87CB },
	{ 0xC1B6, 0x893B },
	{ 0xC1B7, 0x8936 },
	{ 0xC1B8, 0x8944 },
	{ 0xC1B9, 0x8938 },
	{ 0xC1BA, 0x893D },
	{ 0xC1BB, 0x89AC },
	{ 0xC1BC, 0x8B0E },
	{ 0xC1BD, 0x8B17 },
	{ 0xC1BE, 0x8B19 },
	{ 0xC1BF, 0x8B1B },
	{ 0xC1C0, 0x8B0A },
	{ 0xC1C1, 0x8B20 },
	{ 0xC1C2, 0x8B1D },
	{ 0xC1C3, 0x8B04 },
	{ 0xC1C4, 0x8B10 },
	{ 0xC1C5, 0x8C41 },
	{ 0xC1C6, 0x8C3F },
	{ 0xC1C7, 0x8C73 },
	{ 0xC1C8, 0x8CFA },
	{ 0xC1C9, 0x8CFD },
	{ 0xC1CA, 0x8CFC },
	{ 0xC1CB, 0x8CF8 },
	{ 0xC1CC, 0x8CFB },
	{ 0xC1CD, 0x8DA8 },
	{ 0xC1CE, 0x8E49 },
	{ 0xC1CF, 0x8E4B },
	{ 0xC1D0, 0x8E48 },
	{ 0xC1D1, 0x8E4A },
	{ 0xC1D2, 0x8F44 },
	{ 0xC1D3, 0x8F3E },
	{ 0xC1D4, 0x8F42 },
	{ 0xC1D5, 0x8F45 },
	{ 0xC1D6, 0x8F3F },
	{ 0xC1D7, 0x907F },
	{ 0xC1D8, 0x907D },
	{ 0xC1D9, 0x9084 },
	{ 0xC1DA, 0x9081 },
	{ 0xC1DB, 0x9082 },
	{ 0xC1DC, 0x9080 },
	{ 0xC1DD, 0x9139 },
	{ 0xC1DE, 0x91A3 },
	{ 0xC1DF, 0x919E },
	{ 0xC1E0, 0x919C },
	{ 0xC1E1, 0x934D },
	{ 0xC1E2, 0x9382 },
	{ 0xC1E3, 0x9328 },
	{ 0xC1E4, 0x9375 },
	{ 0xC1E5, 0x934A },
	{ 0xC1E6, 0x9365 },
	{ 0xC1E7, 0x934B },
	{ 0xC1E8, 0x9318 },
	{ 0xC1E9, 0x937E },
	{ 0xC1EA, 0x936C },
	{ 0xC1EB, 0x935B },
	{ 0xC1EC, 0x9370 },
	{ 0xC1ED, 0x935A },
	{ 0xC1EE, 0x9354 },
	{ 0xC1EF, 0x95CA },
	{ 0xC1F0, 0x95CB },
	{ 0xC1F1, 0x95CC },
	{ 0xC1F2, 0x95C8 },
	{ 0xC1F3, 0x95C6 },
	{ 0xC1F4, 0x96B1 },
	{ 0xC1F5, 0x96B8 },
	{ 0xC1F6, 0x96D6 },
	{ 0xC1F7, 0x971C },
	{ 0xC1F8, 0x971E },
	{ 0xC1F9, 0x97A0 },
	{ 0xC1FA, 0x97D3 },
	{ 0xC1FB, 0x9846 },
	{ 0xC1FC, 0x98B6 },
	{ 0xC1FD, 0x9935 },
	{ 0xC1FE, 0x9A01 },
	{ 0xC240, 0x99FF },
	{ 0xC241, 0x9BAE },
	{ 0xC242, 0x9BAB },
	{ 0xC243, 0x9BAA },
	{ 0xC244, 0x9BAD },
	{ 0xC245, 0x9D3B },
	{ 0xC246, 0x9D3F },
	{ 0xC247, 0x9E8B },
	{ 0xC248, 0x9ECF },
	{ 0xC249, 0x9EDE },
	{ 0xC24A, 0x9EDC },
	{ 0xC24B, 0x9EDD },
	{ 0xC24C, 0x9EDB },
	{ 0xC24D, 0x9F3E },
	{ 0xC24E, 0x9F4B },
	{ 0xC24F, 0x53E2 },
	{ 0xC250, 0x5695 },
	{ 0xC251, 0x56AE },
	{ 0xC252, 0x58D9 },
	{ 0xC253, 0x58D8 },
	{ 0xC254, 0x5B38 },
	{ 0xC255, 0x5F5E },
	{ 0xC256, 0x61E3 },
	{ 0xC257, 0x6233 },
	{ 0xC258, 0x64F4 },
	{ 0xC259, 0x64F2 },
	{ 0xC25A, 0x64FE },
	{ 0xC25B, 0x6506 },
	{ 0xC25C, 0x64FA },
	{ 0xC25D, 0x64FB },
	{ 0xC25E, 0x64F7 },
	{ 0xC25F, 0x65B7 },
	{ 0xC260, 0x66DC },
	{ 0xC261, 0x6726 },
	{ 0xC262, 0x6AB3 },
	{ 0xC263, 0x6AAC },
	{ 0xC264, 0x6AC3 },
	{ 0xC265, 0x6ABB },
	{ 0xC266, 0x6AB8 },
	{ 0xC267, 0x6AC2 },
	{ 0xC268, 0x6AAE },
	{ 0xC269, 0x6AAF },
	{ 0xC26A, 0x6B5F },
	{ 0xC26B, 0x6B78 },
	{ 0xC26C, 0x6BAF },
	{ 0xC26D, 0x7009 },
	{ 0xC26E, 0x700B },
	{ 0xC26F, 0x6FFE },
	{ 0xC270, 0x7006 },
	{ 0xC271, 0x6FFA },
	{ 0xC272, 0x7011 },
	{ 0xC273, 0x700F },
	{ 0xC274, 0x71FB },
	{ 0xC275, 0x71FC },
	{ 0xC276, 0x71FE },
	{ 0xC277, 0x71F8 },
	{ 0xC278, 0x7377 },
	{ 0xC279, 0x7375 },
	{ 0xC27A, 0x74A7 },
	{ 0xC27B, 0x74BF },
	{ 0xC27C, 0x7515 },
	{ 0xC27D, 0x7656 },
	{ 0xC27E, 0x7658 },
	{ 0xC27F, 0xFFFD },
	{ 0xC280, 0x8858 },
	{ 0xC281, 0x88E0 },
	{ 0xC282, 0x89E7 },
	{ 0xC283, 0x8A6A },
	{ 0xC284, 0x8A80 },
	{ 0xC285, 0x8A6F },
	{ 0xC286, 0x8A65 },
	{ 0xC287, 0x8A78 },
	{ 0xC288, 0x8A7D },
	{ 0xC289, 0x8A88 },
	{ 0xC28A, 0x8A64 },
	{ 0xC28B, 0x8A7E },
	{ 0xC28C, 0x8A67 },
	{ 0xC28D, 0x8C63 },
	{ 0xC28E, 0x8C88 },
	{ 0xC28F, 0x8CCD },
	{ 0xC290, 0x8CC9 },
	{ 0xC291, 0x8DED },
	{ 0xC292, 0x8EB1 },
	{ 0xC293, 0x8F04 },
	{ 0xC294, 0x8F9E },
	{ 0xC295, 0x8FA0 },
	{ 0xC296, 0x9043 },
	{ 0xC297, 0x9046 },
	{ 0xC298, 0x9048 },
	{ 0xC299, 0x9045 },
	{ 0xC29A, 0x9040 },
	{ 0xC29B, 0x904C },
	{ 0xC29C, 0x910C },
	{ 0xC29D, 0x9113 },
	{ 0xC29E, 0x9115 },
	{ 0xC29F, 0x916B },
	{ 0xC2A0, 0x9167 },
	{ 0xC2A1, 0x7652 },
	{ 0xC2A2, 0x77BD },
	{ 0xC2A3, 0x77BF },
	{ 0xC2A4, 0x77BB },
	{ 0xC2A5, 0x77BC },
	{ 0xC2A6, 0x790E },
	{ 0xC2A7, 0x79AE },
	{ 0xC2A8, 0x7A61 },
	{ 0xC2A9, 0x7A62 },
	{ 0xC2AA, 0x7A60 },
	{ 0xC2AB, 0x7AC4 },
	{ 0xC2AC, 0x7AC5 },
	{ 0xC2AD, 0x7C2B },
	{ 0xC2AE, 0x7C27 },
	{ 0xC2AF, 0x7C2A },
	{ 0xC2B0, 0x7C1E },
	{ 0xC2B1, 0x7C23 },
	{ 0xC2B2, 0x7C21 },
	{ 0xC2B3, 0x7CE7 },
	{ 0xC2B4, 0x7E54 },
	{ 0xC2B5, 0x7E55 },
	{ 0xC2B6, 0x7E5E },
	{ 0xC2B7, 0x7E5A },
	{ 0xC2B8, 0x7E61 },
	{ 0xC2B9, 0x7E52 },
	{ 0xC2BA, 0x7E59 },
	{ 0xC2BB, 0x7F48 },
	{ 0xC2BC, 0x7FF9 },
	{ 0xC2BD, 0x7FFB },
	{ 0xC2BE, 0x8077 },
	{ 0xC2BF, 0x8076 },
	{ 0xC2C0, 0x81CD },
	{ 0xC2C1, 0x81CF },
	{ 0xC2C2, 0x820A },
	{ 0xC2C3, 0x85CF },
	{ 0xC2C4, 0x85A9 },
	{ 0xC2C5, 0x85CD },
	{ 0xC2C6, 0x85D0 },
	{ 0xC2C7, 0x85C9 },
	{ 0xC2C8, 0x85B0 },
	{ 0xC2C9, 0x85BA },
	{ 0xC2CA, 0x85B9 },
	{ 0xC2CB, 0x85A6 },
	{ 0xC2CC, 0x87EF },
	{ 0xC2CD, 0x87EC },
	{ 0xC2CE, 0x87F2 },
	{ 0xC2CF, 0x87E0 },
	{ 0xC2D0, 0x8986 },
	{ 0xC2D1, 0x89B2 },
	{ 0xC2D2, 0x89F4 },
	{ 0xC2D3, 0x8B28 },
	{ 0xC2D4, 0x8B39 },
	{ 0xC2D5, 0x8B2C },
	{ 0xC2D6, 0x8B2B },
	{ 0xC2D7, 0x8C50 },
	{ 0xC2D8, 0x8D05 },
	{ 0xC2D9, 0x8E59 },
	{ 0xC2DA, 0x8E63 },
	{ 0xC2DB, 0x8E66 },
	{ 0xC2DC, 0x8E64 },
	{ 0xC2DD, 0x8E5F },
	{ 0xC2DE, 0x8E55 },
	{ 0xC2DF, 0x8EC0 },
	{ 0xC2E0, 0x8F49 },
	{ 0xC2E1, 0x8F4D },
	{ 0xC2E2, 0x9087 },
	{ 0xC2E3, 0x9083 },
	{ 0xC2E4, 0x9088 },
	{ 0xC2E5, 0x91AB },
	{ 0xC2E6, 0x91AC },
	{ 0xC2E7, 0x91D0 },
	{ 0xC2E8, 0x9394 },
	{ 0xC2E9, 0x938A },
	{ 0xC2EA, 0x9396 },
	{ 0xC2EB, 0x93A2 },
	{ 0xC2EC, 0x93B3 },
	{ 0xC2ED, 0x93AE },
	{ 0xC2EE, 0x93AC },
	{ 0xC2EF, 0x93B0 },
	{ 0xC2F0, 0x9398 },
	{ 0xC2F1, 0x939A },
	{ 0xC2F2, 0x9397 },
	{ 0xC2F3, 0x95D4 },
	{ 0xC2F4, 0x95D6 },
	{ 0xC2F5, 0x95D0 },
	{ 0xC2F6, 0x95D5 },
	{ 0xC2F7, 0x96E2 },
	{ 0xC2F8, 0x96DC },
	{ 0xC2F9, 0x96D9 },
	{ 0xC2FA, 0x96DB },
	{ 0xC2FB, 0x96DE },
	{ 0xC2FC, 0x9724 },
	{ 0xC2FD, 0x97A3 },
	{ 0xC2FE, 0x97A6 },
	{ 0xC340, 0x97AD },
	{ 0xC341, 0x97F9 },
	{ 0xC342, 0x984D },
	{ 0xC343, 0x984F },
	{ 0xC344, 0x984C },
	{ 0xC345, 0x984E },
	{ 0xC346, 0x9853 },
	{ 0xC347, 0x98BA },
	{ 0xC348, 0x993E },
	{ 0xC349, 0x993F },
	{ 0xC34A, 0x993D },
	{ 0xC34B, 0x992E },
	{ 0xC34C, 0x99A5 },
	{ 0xC34D, 0x9A0E },
	{ 0xC34E, 0x9AC1 },
	{ 0xC34F, 0x9B03 },
	{ 0xC350, 0x9B06 },
	{ 0xC351, 0x9B4F },
	{ 0xC352, 0x9B4E },
	{ 0xC353, 0x9B4D },
	{ 0xC354, 0x9BCA },
	{ 0xC355, 0x9BC9 },
	{ 0xC356, 0x9BFD },
	{ 0xC357, 0x9BC8 },
	{ 0xC358, 0x9BC0 },
	{ 0xC359, 0x9D51 },
	{ 0xC35A, 0x9D5D },
	{ 0xC35B, 0x9D60 },
	{ 0xC35C, 0x9EE0 },
	{ 0xC35D, 0x9F15 },
	{ 0xC35E, 0x9F2C },
	{ 0xC35F, 0x5133 },
	{ 0xC360, 0x56A5 },
	{ 0xC361, 0x58DE },
	{ 0xC362, 0x58DF },
	{ 0xC363, 0x58E2 },
	{ 0xC364, 0x5BF5 },
	{ 0xC365, 0x9F90 },
	{ 0xC366, 0x5EEC },
	{ 0xC367, 0x61F2 },
	{ 0xC368, 0x61F7 },
	{ 0xC369, 0x61F6 },
	{ 0xC36A, 0x61F5 },
	{ 0xC36B, 0x6500 },
	{ 0xC36C, 0x650F },
	{ 0xC36D, 0x66E0 },
	{ 0xC36E, 0x66DD },
	{ 0xC36F, 0x6AE5 },
	{ 0xC370, 0x6ADD },
	{ 0xC371, 0x6ADA },
	{ 0xC372, 0x6AD3 },
	{ 0xC373, 0x701B },
	{ 0xC374, 0x701F },
	{ 0xC375, 0x7028 },
	{ 0xC376, 0x701A },
	{ 0xC377, 0x701D },
	{ 0xC378, 0x7015 },
	{ 0xC379, 0x7018 },
	{ 0xC37A, 0x7206 },
	{ 0xC37B, 0x720D },
	{ 0xC37C, 0x7258 },
	{ 0xC37D, 0x72A2 },
	{ 0xC37E, 0x7378 },
	{ 0xC37F, 0xFFFD },
	{ 0xC380, 0x925D },
	{ 0xC381, 0x9255 },
	{ 0xC382, 0x9235 },
	{ 0xC383, 0x9259 },
	{ 0xC384, 0x922F },
	{ 0xC385, 0x923C },
	{ 0xC386, 0x928F },
	{ 0xC387, 0x925C },
	{ 0xC388, 0x926A },
	{ 0xC389, 0x9262 },
	{ 0xC38A, 0x925F },
	{ 0xC38B, 0x926B },
	{ 0xC38C, 0x926E },
	{ 0xC38D, 0x923B },
	{ 0xC38E, 0x9244 },
	{ 0xC38F, 0x9241 },
	{ 0xC390, 0x959A },
	{ 0xC391, 0x9599 },
	{ 0xC392, 0x968F },
	{ 0xC393, 0x9696 },
	{ 0xC394, 0x96F4 },
	{ 0xC395, 0x96FC },
	{ 0xC396, 0x9755 },
	{ 0xC397, 0x9779 },
	{ 0xC398, 0x97EE },
	{ 0xC399, 0x97F5 },
	{ 0xC39A, 0x980B },
	{ 0xC39B, 0x98F3 },
	{ 0xC39C, 0x98F7 },
	{ 0xC39D, 0x98FF },
	{ 0xC39E, 0x98F5 },
	{ 0xC39F, 0x98EC },
	{ 0xC3A0, 0x98F1 },
	{ 0xC3A1, 0x737A },
	{ 0xC3A2, 0x74BD },
	{ 0xC3A3, 0x74CA },
	{ 0xC3A4, 0x74E3 },
	{ 0xC3A5, 0x7587 },
	{ 0xC3A6, 0x7586 },
	{ 0xC3A7, 0x765F },
	{ 0xC3A8, 0x7661 },
	{ 0xC3A9, 0x77C7 },
	{ 0xC3AA, 0x7919 },
	{ 0xC3AB, 0x79B1 },
	{ 0xC3AC, 0x7A6B },
	{ 0xC3AD, 0x7A69 },
	{ 0xC3AE, 0x7C3E },
	{ 0xC3AF, 0x7C3F },
	{ 0xC3B0, 0x7C38 },
	{ 0xC3B1, 0x7C3D },
	{ 0xC3B2, 0x7C37 },
	{ 0xC3B3, 0x7C40 },
	{ 0xC3B4, 0x7E6B },
	{ 0xC3B5, 0x7E6D },
	{ 0xC3B6, 0x7E79 },
	{ 0xC3B7, 0x7E69 },
	{ 0xC3B8, 0x7E6A },
	{ 0xC3B9, 0x7F85 },
	{ 0xC3BA, 0x7E73 },
	{ 0xC3BB, 0x7FB6 },
	{ 0xC3BC, 0x7FB9 },
	{ 0xC3BD, 0x7FB8 },
	{ 0xC3BE, 0x81D8 },
	{ 0xC3BF, 0x85E9 },
	{ 0xC3C0, 0x85DD },
	{ 0xC3C1, 0x85EA },
	{ 0xC3C2, 0x85D5 },
	{ 0xC3C3, 0x85E4 },
	{ 0xC3C4, 0x85E5 },
	{ 0xC3C5, 0x85F7 },
	{ 0xC3C6, 0x87FB },
	{ 0xC3C7, 0x8805 },
	{ 0xC3C8, 0x880D },
	{ 0xC3C9, 0x87F9 },
	{ 0xC3CA, 0x87FE },
	{ 0xC3CB, 0x8960 },
	{ 0xC3CC, 0x895F },
	{ 0xC3CD, 0x8956 },
	{ 0xC3CE, 0x895E },
	{ 0xC3CF, 0x8B41 },
	{ 0xC3D0, 0x8B5C },
	{ 0xC3D1, 0x8B58 },
	{ 0xC3D2, 0x8B49 },
	{ 0xC3D3, 0x8B5A },
	{ 0xC3D4, 0x8B4E },
	{ 0xC3D5, 0x8B4F },
	{ 0xC3D6, 0x8B46 },
	{ 0xC3D7, 0x8B59 },
	{ 0xC3D8, 0x8D08 },
	{ 0xC3D9, 0x8D0A },
	{ 0xC3DA, 0x8E7C },
	{ 0xC3DB, 0x8E72 },
	{ 0xC3DC, 0x8E87 },
	{ 0xC3DD, 0x8E76 },
	{ 0xC3DE, 0x8E6C },
	{ 0xC3DF, 0x8E7A },
	{ 0xC3E0, 0x8E74 },
	{ 0xC3E1, 0x8F54 },
	{ 0xC3E2, 0x8F4E },
	{ 0xC3E3, 0x8FAD },
	{ 0xC3E4, 0x908A },
	{ 0xC3E5, 0x908B },
	{ 0xC3E6, 0x91B1 },
	{ 0xC3E7, 0x91AE },
	{ 0xC3E8, 0x93E1 },
	{ 0xC3E9, 0x93D1 },
	{ 0xC3EA, 0x93DF },
	{ 0xC3EB, 0x93C3 },
	{ 0xC3EC, 0x93C8 },
	{ 0xC3ED, 0x93DC },
	{ 0xC3EE, 0x93DD },
	{ 0xC3EF, 0x93D6 },
	{ 0xC3F0, 0x93E2 },
	{ 0xC3F1, 0x93CD },
	{ 0xC3F2, 0x93D8 },
	{ 0xC3F3, 0x93E4 },
	{ 0xC3F4, 0x93D7 },
	{ 0xC3F5, 0x93E8 },
	{ 0xC3F6, 0x95DC },
	{ 0xC3F7, 0x96B4 },
	{ 0xC3F8, 0x96E3 },
	{ 0xC3F9, 0x972A },
	{ 0xC3FA, 0x9727 },
	{ 0xC3FB, 0x9761 },
	{ 0xC3FC, 0x97DC },
	{ 0xC3FD, 0x97FB },
	{ 0xC3FE, 0x985E },
	{ 0xC440, 0x9858 },
	{ 0xC441, 0x985B },
	{ 0xC442, 0x98BC },
	{ 0xC443, 0x9945 },
	{ 0xC444, 0x9949 },
	{ 0xC445, 0x9A16 },
	{ 0xC446, 0x9A19 },
	{ 0xC447, 0x9B0D },
	{ 0xC448, 0x9BE8 },
	{ 0xC449, 0x9BE7 },
	{ 0xC44A, 0x9BD6 },
	{ 0xC44B, 0x9BDB },
	{ 0xC44C, 0x9D89 },
	{ 0xC44D, 0x9D61 },
	{ 0xC44E, 0x9D72 },
	{ 0xC44F, 0x9D6A },
	{ 0xC450, 0x9D6C },
	{ 0xC451, 0x9E92 },
	{ 0xC452, 0x9E97 },
	{ 0xC453, 0x9E93 },
	{ 0xC454, 0x9EB4 },
	{ 0xC455, 0x52F8 },
	{ 0xC456, 0x56A8 },
	{ 0xC457, 0x56B7 },
	{ 0xC458, 0x56B6 },
	{ 0xC459, 0x56B4 },
	{ 0xC45A, 0x56BC },
	{ 0xC45B, 0x58E4 },
	{ 0xC45C, 0x5B40 },
	{ 0xC45D, 0x5B43 },
	{ 0xC45E, 0x5B7D },
	{ 0xC45F, 0x5BF6 },
	{ 0xC460, 0x5DC9 },
	{ 0xC461, 0x61F8 },
	{ 0xC462, 0x61FA },
	{ 0xC463, 0x6518 },
	{ 0xC464, 0x6514 },
	{ 0xC465, 0x6519 },
	{ 0xC466, 0x66E6 },
	{ 0xC467, 0x6727 },
	{ 0xC468, 0x6AEC },
	{ 0xC469, 0x703E },
	{ 0xC46A, 0x7030 },
	{ 0xC46B, 0x7032 },
	{ 0xC46C, 0x7210 },
	{ 0xC46D, 0x737B },
	{ 0xC46E, 0x74CF },
	{ 0xC46F, 0x7662 },
	{ 0xC470, 0x7665 },
	{ 0xC471, 0x7926 },
	{ 0xC472, 0x792A },
	{ 0xC473, 0x792C },
	{ 0xC474, 0x792B },
	{ 0xC475, 0x7AC7 },
	{ 0xC476, 0x7AF6 },
	{ 0xC477, 0x7C4C },
	{ 0xC478, 0x7C43 },
	{ 0xC479, 0x7C4D },
	{ 0xC47A, 0x7CEF },
	{ 0xC47B, 0x7CF0 },
	{ 0xC47C, 0x8FAE },
	{ 0xC47D, 0x7E7D },
	{ 0xC47E, 0x7E7C },
	{ 0xC47F, 0xFFFD },
	{ 0xC480, 0x999A },
	{ 0xC481, 0x9AE2 },
	{ 0xC482, 0x9B3D },
	{ 0xC483, 0x9B5D },
	{ 0xC484, 0x9CE8 },
	{ 0xC485, 0x9CEB },
	{ 0xC486, 0x9CEF },
	{ 0xC487, 0x9CEE },
	{ 0xC488, 0x9E81 },
	{ 0xC489, 0x9F14 },
	{ 0xC48A, 0x50D0 },
	{ 0xC48B, 0x50D9 },
	{ 0xC48C, 0x50DC },
	{ 0xC48D, 0x50D8 },
	{ 0xC48E, 0x50E1 },
	{ 0xC48F, 0x50EB },
	{ 0xC490, 0x50F4 },
	{ 0xC491, 0x50E2 },
	{ 0xC492, 0x50DE },
	{ 0xC493, 0x51F4 },
	{ 0xC494, 0x52ED },
	{ 0xC495, 0x52EA },
	{ 0xC496, 0x5332 },
	{ 0xC497, 0x53AE },
	{ 0xC498, 0x53B0 },
	{ 0xC499, 0x55FB },
	{ 0xC49A, 0x5603 },
	{ 0xC49B, 0x560B },
	{ 0xC49C, 0x5607 },
	{ 0xC49D, 0x55F8 },
	{ 0xC49E, 0x5628 },
	{ 0xC49F, 0x561E },
	{ 0xC4A0, 0x5618 },
	{ 0xC4A1, 0x7E82 },
	{ 0xC4A2, 0x7F4C },
	{ 0xC4A3, 0x8000 },
	{ 0xC4A4, 0x81DA },
	{ 0xC4A5, 0x8266 },
	{ 0xC4A6, 0x85FB },
	{ 0xC4A7, 0x85F9 },
	{ 0xC4A8, 0x8611 },
	{ 0xC4A9, 0x85FA },
	{ 0xC4AA, 0x8606 },
	{ 0xC4AB, 0x860B },
	{ 0xC4AC, 0x8607 },
	{ 0xC4AD, 0x860A },
	{ 0xC4AE, 0x8814 },
	{ 0xC4AF, 0x8815 },
	{ 0xC4B0, 0x8964 },
	{ 0xC4B1, 0x89BA },
	{ 0xC4B2, 0x89F8 },
	{ 0xC4B3, 0x8B70 },
	{ 0xC4B4, 0x8B6C },
	{ 0xC4B5, 0x8B66 },
	{ 0xC4B6, 0x8B6F },
	{ 0xC4B7, 0x8B5F },
	{ 0xC4B8, 0x8B6B },
	{ 0xC4B9, 0x8D0F },
	{ 0xC4BA, 0x8D0D },
	{ 0xC4BB, 0x8E89 },
	{ 0xC4BC, 0x8E81 },
	{ 0xC4BD, 0x8E85 },
	{ 0xC4BE, 0x8E82 },
	{ 0xC4BF, 0x91B4 },
	{ 0xC4C0, 0x91CB },
	{ 0xC4C1, 0x9418 },
	{ 0xC4C2, 0x9403 },
	{ 0xC4C3, 0x93FD },
	{ 0xC4C4, 0x95E1 },
	{ 0xC4C5, 0x9730 },
	{ 0xC4C6, 0x98C4 },
	{ 0xC4C7, 0x9952 },
	{ 0xC4C8, 0x9951 },
	{ 0xC4C9, 0x99A8 },
	{ 0xC4CA, 0x9A2B },
	{ 0xC4CB, 0x9A30 },
	{ 0xC4CC, 0x9A37 },
	{ 0xC4CD, 0x9A35 },
	{ 0xC4CE, 0x9C13 },
	{ 0xC4CF, 0x9C0D },
	{ 0xC4D0, 0x9E79 },
	{ 0xC4D1, 0x9EB5 },
	{ 0xC4D2, 0x9EE8 },
	{ 0xC4D3, 0x9F2F },
	{ 0xC4D4, 0x9F5F },
	{ 0xC4D5, 0x9F63 },
	{ 0xC4D6, 0x9F61 },
	{ 0xC4D7, 0x5137 },
	{ 0xC4D8, 0x5138 },
	{ 0xC4D9, 0x56C1 },
	{ 0xC4DA, 0x56C0 },
	{ 0xC4DB, 0x56C2 },
	{ 0xC4DC, 0x5914 },
	{ 0xC4DD, 0x5C6C },
	{ 0xC4DE, 0x5DCD },
	{ 0xC4DF, 0x61FC },
	{ 0xC4E0, 0x61FE },
	{ 0xC4E1, 0x651D },
	{ 0xC4E2, 0x651C },
	{ 0xC4E3, 0x6595 },
	{ 0xC4E4, 0x66E9 },
	{ 0xC4E5, 0x6AFB },
	{ 0xC4E6, 0x6B04 },
	{ 0xC4E7, 0x6AFA },
	{ 0xC4E8, 0x6BB2 },
	{ 0xC4E9, 0x704C },
	{ 0xC4EA, 0x721B },
	{ 0xC4EB, 0x72A7 },
	{ 0xC4EC, 0x74D6 },
	{ 0xC4ED, 0x74D4 },
	{ 0xC4EE, 0x7669 },
	{ 0xC4EF, 0x77D3 },
	{ 0xC4F0, 0x7C50 },
	{ 0xC4F1, 0x7E8F },
	{ 0xC4F2, 0x7E8C },
	{ 0xC4F3, 0x7FBC },
	{ 0xC4F4, 0x8617 },
	{ 0xC4F5, 0x862D },
	{ 0xC4F6, 0x861A },
	{ 0xC4F7, 0x8823 },
	{ 0xC4F8, 0x8822 },
	{ 0xC4F9, 0x8821 },
	{ 0xC4FA, 0x881F },
	{ 0xC4FB, 0x896A },
	{ 0xC4FC, 0x896C },
	{ 0xC4FD, 0x89BD },
	{ 0xC4FE, 0x8B74 },
	{ 0xC540, 0x8B77 },
	{ 0xC541, 0x8B7D },
	{ 0xC542, 0x8D13 },
	{ 0xC543, 0x8E8A },
	{ 0xC544, 0x8E8D },
	{ 0xC545, 0x8E8B },
	{ 0xC546, 0x8F5F },
	{ 0xC547, 0x8FAF },
	{ 0xC548, 0x91BA },
	{ 0xC549, 0x942E },
	{ 0xC54A, 0x9433 },
	{ 0xC54B, 0x9435 },
	{ 0xC54C, 0x943A },
	{ 0xC54D, 0x9438 },
	{ 0xC54E, 0x9432 },
	{ 0xC54F, 0x942B },
	{ 0xC550, 0x95E2 },
	{ 0xC551, 0x9738 },
	{ 0xC552, 0x9739 },
	{ 0xC553, 0x9732 },
	{ 0xC554, 0x97FF },
	{ 0xC555, 0x9867 },
	{ 0xC556, 0x9865 },
	{ 0xC557, 0x9957 },
	{ 0xC558, 0x9A45 },
	{ 0xC559, 0x9A43 },
	{ 0xC55A, 0x9A40 },
	{ 0xC55B, 0x9A3E },
	{ 0xC55C, 0x9ACF },
	{ 0xC55D, 0x9B54 },
	{ 0xC55E, 0x9B51 },
	{ 0xC55F, 0x9C2D },
	{ 0xC560, 0x9C25 },
	{ 0xC561, 0x9DAF },
	{ 0xC562, 0x9DB4 },
	{ 0xC563, 0x9DC2 },
	{ 0xC564, 0x9DB8 },
	{ 0xC565, 0x9E9D },
	{ 0xC566, 0x9EEF },
	{ 0xC567, 0x9F19 },
	{ 0xC568, 0x9F5C },
	{ 0xC569, 0x9F66 },
	{ 0xC56A, 0x9F67 },
	{ 0xC56B, 0x513C },
	{ 0xC56C, 0x513B },
	{ 0xC56D, 0x56C8 },
	{ 0xC56E, 0x56CA },
	{ 0xC56F, 0x56C9 },
	{ 0xC570, 0x5B7F },
	{ 0xC571, 0x5DD4 },
	{ 0xC572, 0x5DD2 },
	{ 0xC573, 0x5F4E },
	{ 0xC574, 0x61FF },
	{ 0xC575, 0x6524 },
	{ 0xC576, 0x6B0A },
	{ 0xC577, 0x6B61 },
	{ 0xC578, 0x7051 },
	{ 0xC579, 0x7058 },
	{ 0xC57A, 0x7380 },
	{ 0xC57B, 0x74E4 },
	{ 0xC57C, 0x758A },
	{ 0xC57D, 0x766E },
	{ 0xC57E, 0x766C },
	{ 0xC57F, 0xFFFD },
	{ 0xC580, 0x5611 },
	{ 0xC581, 0x5651 },
	{ 0xC582, 0x5605 },
	{ 0xC583, 0x5717 },
	{ 0xC584, 0x5892 },
	{ 0xC585, 0x588C },
	{ 0xC586, 0x5878 },
	{ 0xC587, 0x5884 },
	{ 0xC588, 0x5873 },
	{ 0xC589, 0x58AD },
	{ 0xC58A, 0x5897 },
	{ 0xC58B, 0x5895 },
	{ 0xC58C, 0x5877 },
	{ 0xC58D, 0x5872 },
	{ 0xC58E, 0x5896 },
	{ 0xC58F, 0x588D },
	{ 0xC590, 0x5910 },
	{ 0xC591, 0x596C },
	{ 0xC592, 0x5AE7 },
	{ 0xC593, 0x5AE4 },
	{ 0xC594, 0x5AEF },
	{ 0xC595, 0x5626 },
	{ 0xC596, 0x5AF0 },
	{ 0xC597, 0x5D7B },
	{ 0xC598, 0x5D83 },
	{ 0xC599, 0x5D8B },
	{ 0xC59A, 0x5D8C },
	{ 0xC59B, 0x5D78 },
	{ 0xC59C, 0x5E52 },
	{ 0xC59D, 0x5ED0 },
	{ 0xC59E, 0x5ECF },
	{ 0xC59F, 0x5FB3 },
	{ 0xC5A0, 0x5FB4 },
	{ 0xC5A1, 0x79B3 },
	{ 0xC5A2, 0x7C60 },
	{ 0xC5A3, 0x7C5F },
	{ 0xC5A4, 0x807E },
	{ 0xC5A5, 0x807D },
	{ 0xC5A6, 0x81DF },
	{ 0xC5A7, 0x8972 },
	{ 0xC5A8, 0x896F },
	{ 0xC5A9, 0x89FC },
	{ 0xC5AA, 0x8B80 },
	{ 0xC5AB, 0x8D16 },
	{ 0xC5AC, 0x8D17 },
	{ 0xC5AD, 0x8E91 },
	{ 0xC5AE, 0x8E93 },
	{ 0xC5AF, 0x8F61 },
	{ 0xC5B0, 0x9148 },
	{ 0xC5B1, 0x9444 },
	{ 0xC5B2, 0x9451 },
	{ 0xC5B3, 0x9452 },
	{ 0xC5B4, 0x973D },
	{ 0xC5B5, 0x973E },
	{ 0xC5B6, 0x97C3 },
	{ 0xC5B7, 0x97C1 },
	{ 0xC5B8, 0x986B },
	{ 0xC5B9, 0x9955 },
	{ 0xC5BA, 0x9A55 },
	{ 0xC5BB, 0x9A4D },
	{ 0xC5BC, 0x9AD2 },
	{ 0xC5BD, 0x9B1A },
	{ 0xC5BE, 0x9C49 },
	{ 0xC5BF, 0x9C31 },
	{ 0xC5C0, 0x9C3E },
	{ 0xC5C1, 0x9C3B },
	{ 0xC5C2, 0x9DD3 },
	{ 0xC5C3, 0x9DD7 },
	{ 0xC5C4, 0x9F34 },
	{ 0xC5C5, 0x9F6C },
	{ 0xC5C6, 0x9F6A },
	{ 0xC5C7, 0x9F94 },
	{ 0xC5C8, 0x56CC },
	{ 0xC5C9, 0x5DD6 },
	{ 0xC5CA, 0x6200 },
	{ 0xC5CB, 0x6523 },
	{ 0xC5CC, 0x652B },
	{ 0xC5CD, 0x652A },
	{ 0xC5CE, 0x66EC },
	{ 0xC5CF, 0x6B10 },
	{ 0xC5D0, 0x74DA },
	{ 0xC5D1, 0x7ACA },
	{ 0xC5D2, 0x7C64 },
	{ 0xC5D3, 0x7C63 },
	{ 0xC5D4, 0x7C65 },
	{ 0xC5D5, 0x7E93 },
	{ 0xC5D6, 0x7E96 },
	{ 0xC5D7, 0x7E94 },
	{ 0xC5D8, 0x81E2 },
	{ 0xC5D9, 0x8638 },
	{ 0xC5DA, 0x863F },
	{ 0xC5DB, 0x8831 },
	{ 0xC5DC, 0x8B8A },
	{ 0xC5DD, 0x9090 },
	{ 0xC5DE, 0x908F },
	{ 0xC5DF, 0x9463 },
	{ 0xC5E0, 0x9460 },
	{ 0xC5E1, 0x9464 },
	{ 0xC5E2, 0x9768 },
	{ 0xC5E3, 0x986F },
	{ 0xC5E4, 0x995C },
	{ 0xC5E5, 0x9A5A },
	{ 0xC5E6, 0x9A5B },
	{ 0xC5E7, 0x9A57 },
	{ 0xC5E8, 0x9AD3 },
	{ 0xC5E9, 0x9AD4 },
	{ 0xC5EA, 0x9AD1 },
	{ 0xC5EB, 0x9C54 },
	{ 0xC5EC, 0x9C57 },
	{ 0xC5ED, 0x9C56 },
	{ 0xC5EE, 0x9DE5 },
	{ 0xC5EF, 0x9E9F },
	{ 0xC5F0, 0x9EF4 },
	{ 0xC5F1, 0x56D1 },
	{ 0xC5F2, 0x58E9 },
	{ 0xC5F3, 0x652C },
	{ 0xC5F4, 0x705E },
	{ 0xC5F5, 0x7671 },
	{ 0xC5F6, 0x7672 },
	{ 0xC5F7, 0x77D7 },
	{ 0xC5F8, 0x7F50 },
	{ 0xC5F9, 0x7F88 },
	{ 0xC5FA, 0x8836 },
	{ 0xC5FB, 0x8839 },
	{ 0xC5FC, 0x8862 },
	{ 0xC5FD, 0x8B93 },
	{ 0xC5FE, 0x8B92 },
	{ 0xC640, 0x8B96 },
	{ 0xC641, 0x8277 },
	{ 0xC642, 0x8D1B },
	{ 0xC643, 0x91C0 },
	{ 0xC644, 0x946A },
	{ 0xC645, 0x9742 },
	{ 0xC646, 0x9748 },
	{ 0xC647, 0x9744 },
	{ 0xC648, 0x97C6 },
	{ 0xC649, 0x9870 },
	{ 0xC64A, 0x9A5F },
	{ 0xC64B, 0x9B22 },
	{ 0xC64C, 0x9B58 },
	{ 0xC64D, 0x9C5F },
	{ 0xC64E, 0x9DF9 },
	{ 0xC64F, 0x9DFA },
	{ 0xC650, 0x9E7C },
	{ 0xC651, 0x9E7D },
	{ 0xC652, 0x9F07 },
	{ 0xC653, 0x9F77 },
	{ 0xC654, 0x9F72 },
	{ 0xC655, 0x5EF3 },
	{ 0xC656, 0x6B16 },
	{ 0xC657, 0x7063 },
	{ 0xC658, 0x7C6C },
	{ 0xC659, 0x7C6E },
	{ 0xC65A, 0x883B },
	{ 0xC65B, 0x89C0 },
	{ 0xC65C, 0x8EA1 },
	{ 0xC65D, 0x91C1 },
	{ 0xC65E, 0x9472 },
	{ 0xC65F, 0x9470 },
	{ 0xC660, 0x9871 },
	{ 0xC661, 0x995E },
	{ 0xC662, 0x9AD6 },
	{ 0xC663, 0x9B23 },
	{ 0xC664, 0x9ECC },
	{ 0xC665, 0x7064 },
	{ 0xC666, 0x77DA },
	{ 0xC667, 0x8B9A },
	{ 0xC668, 0x9477 },
	{ 0xC669, 0x97C9 },
	{ 0xC66A, 0x9A62 },
	{ 0xC66B, 0x9A65 },
	{ 0xC66C, 0x7E9C },
	{ 0xC66D, 0x8B9C },
	{ 0xC66E, 0x8EAA },
	{ 0xC66F, 0x91C5 },
	{ 0xC670, 0x947D },
	{ 0xC671, 0x947E },
	{ 0xC672, 0x947C },
	{ 0xC673, 0x9C77 },
	{ 0xC674, 0x9C78 },
	{ 0xC675, 0x9EF7 },
	{ 0xC676, 0x8C54 },
	{ 0xC677, 0x947F },
	{ 0xC678, 0x9E1A },
	{ 0xC679, 0x7228 },
	{ 0xC67A, 0x9A6A },
	{ 0xC67B, 0x9B31 },
	{ 0xC67C, 0x9E1B },
	{ 0xC67D, 0x9E1E },
	{ 0xC67E, 0x7C72 },
	{ 0xC67F, 0xFFFD },
	{ 0xC680, 0x617B },
	{ 0xC681, 0x616F },
	{ 0xC682, 0x6181 },
	{ 0xC683, 0x613C },
	{ 0xC684, 0x6142 },
	{ 0xC685, 0x6138 },
	{ 0xC686, 0x6133 },
	{ 0xC687, 0x6160 },
	{ 0xC688, 0x6169 },
	{ 0xC689, 0x617D },
	{ 0xC68A, 0x6186 },
	{ 0xC68B, 0x622C },
	{ 0xC68C, 0x6228 },
	{ 0xC68D, 0x644C },
	{ 0xC68E, 0x6457 },
	{ 0xC68F, 0x647C },
	{ 0xC690, 0x6455 },
	{ 0xC691, 0x6462 },
	{ 0xC692, 0x6471 },
	{ 0xC693, 0x646A },
	{ 0xC694, 0x6456 },
	{ 0xC695, 0x643B },
	{ 0xC696, 0x6481 },
	{ 0xC697, 0x644F },
	{ 0xC698, 0x647E },
	{ 0xC699, 0x6464 },
	{ 0xC69A, 0x6571 },
	{ 0xC69B, 0x66A5 },
	{ 0xC69C, 0x669A },
	{ 0xC69D, 0x669C },
	{ 0xC69E, 0x66A6 },
	{ 0xC69F, 0x66A4 },
	{ 0xC6A0, 0x698F },
	{ 0xC6A1, 0x2460 },
	{ 0xC6A2, 0x2461 },
	{ 0xC6A3, 0x2462 },
	{ 0xC6A4, 0x2463 },
	{ 0xC6A5, 0x2464 },
	{ 0xC6A6, 0x2465 },
	{ 0xC6A7, 0x2466 },
	{ 0xC6A8, 0x2467 },
	{ 0xC6A9, 0x2468 },
	{ 0xC6AA, 0x2469 },
	{ 0xC6AB, 0x2474 },
	{ 0xC6AC, 0x2475 },
	{ 0xC6AD, 0x2476 },
	{ 0xC6AE, 0x2477 },
	{ 0xC6AF, 0x2478 },
	{ 0xC6B0, 0x2479 },
	{ 0xC6B1, 0x247A },
	{ 0xC6B2, 0x247B },
	{ 0xC6B3, 0x247C },
	{ 0xC6B4, 0x247D },
	{ 0xC6B5, 0x2170 },
	{ 0xC6B6, 0x2171 },
	{ 0xC6B7, 0x2172 },
	{ 0xC6B8, 0x2173 },
	{ 0xC6B9, 0x2174 },
	{ 0xC6BA, 0x2175 },
	{ 0xC6BB, 0x2176 },
	{ 0xC6BC, 0x2177 },
	{ 0xC6BD, 0x2178 },
	{ 0xC6BE, 0x2179 },
	{ 0xC6BF, 0x4E36 },
	{ 0xC6C0, 0x4E3F },
	{ 0xC6C1, 0x4E85 },
	{ 0xC6C2, 0x4EA0 },
	{ 0xC6C3, 0x5182 },
	{ 0xC6C4, 0x5196 },
	{ 0xC6C5, 0x51AB },
	{ 0xC6C6, 0x52F9 },
	{ 0xC6C7, 0x5338 },
	{ 0xC6C8, 0x5369 },
	{ 0xC6C9, 0x53B6 },
	{ 0xC6CA, 0x590A },
	{ 0xC6CB, 0x5B80 },
	{ 0xC6CC, 0x5DDB },
	{ 0xC6CD, 0x5E7A },
	{ 0xC6CE, 0x5E7F },
	{ 0xC6CF, 0x5EF4 },
	{ 0xC6D0, 0x5F50 },
	{ 0xC6D1, 0x5F61 },
	{ 0xC6D2, 0x6534 },
	{ 0xC6D3, 0x65E0 },
	{ 0xC6D4, 0x7592 },
	{ 0xC6D5, 0x7676 },
	{ 0xC6D6, 0x8FB5 },
	{ 0xC6D7, 0x96B6 },
	{ 0xC6D8, 0x5902 },
	{ 0xC6D9, 0xFF3E },
	{ 0xC6DA, 0x30FD },
	{ 0xC6DB, 0x30FE },
	{ 0xC6DC, 0x309D },
	{ 0xC6DD, 0x309E },
	{ 0xC6DE, 0xFF02 },
	{ 0xC6DF, 0x309B },
	{ 0xC6E0, 0x309C },
	{ 0xC6E1, 0x30FB },
	{ 0xC6E2, 0x3007 },
	{ 0xC6E3, 0x30FC },
	{ 0xC6E4, 0xFF3B },
	{ 0xC6E5, 0xFF3D },
	{ 0xC6E6, 0x273D },
	{ 0xC6E7, 0x3041 },
	{ 0xC6E8, 0x3042 },
	{ 0xC6E9, 0x3043 },
	{ 0xC6EA, 0x3044 },
	{ 0xC6EB, 0x3045 },
	{ 0xC6EC, 0x3046 },
	{ 0xC6ED, 0x3047 },
	{ 0xC6EE, 0x3048 },
	{ 0xC6EF, 0x3049 },
	{ 0xC6F0, 0x304A },
	{ 0xC6F1, 0x304B },
	{ 0xC6F2, 0x304C },
	{ 0xC6F3, 0x304D },
	{ 0xC6F4, 0x304E },
	{ 0xC6F5, 0x304F },
	{ 0xC6F6, 0x3050 },
	{ 0xC6F7, 0x3051 },
	{ 0xC6F8, 0x3052 },
	{ 0xC6F9, 0x3053 },
	{ 0xC6FA, 0x3054 },
	{ 0xC6FB, 0x3055 },
	{ 0xC6FC, 0x3056 },
	{ 0xC6FD, 0x3057 },
	{ 0xC6FE, 0x3058 },
	{ 0xC740, 0x3059 },
	{ 0xC741, 0x305A },
	{ 0xC742, 0x305B },
	{ 0xC743, 0x305C },
	{ 0xC744, 0x305D },
	{ 0xC745, 0x305E },
	{ 0xC746, 0x305F },
	{ 0xC747, 0x3060 },
	{ 0xC748, 0x3061 },
	{ 0xC749, 0x3062 },
	{ 0xC74A, 0x3063 },
	{ 0xC74B, 0x3064 },
	{ 0xC74C, 0x3065 },
	{ 0xC74D, 0x3066 },
	{ 0xC74E, 0x3067 },
	{ 0xC74F, 0x3068 },
	{ 0xC750, 0x3069 },
	{ 0xC751, 0x306A },
	{ 0xC752, 0x306B },
	{ 0xC753, 0x306C },
	{ 0xC754, 0x306D },
	{ 0xC755, 0x306E },
	{ 0xC756, 0x306F },
	{ 0xC757, 0x3070 },
	{ 0xC758, 0x3071 },
	{ 0xC759, 0x3072 },
	{ 0xC75A, 0x3073 },
	{ 0xC75B, 0x3074 },
	{ 0xC75C, 0x3075 },
	{ 0xC75D, 0x3076 },
	{ 0xC75E, 0x3077 },
	{ 0xC75F, 0x3078 },
	{ 0xC760, 0x3079 },
	{ 0xC761, 0x307A },
	{ 0xC762, 0x307B },
	{ 0xC763, 0x307C },
	{ 0xC764, 0x307D },
	{ 0xC765, 0x307E },
	{ 0xC766, 0x307F },
	{ 0xC767, 0x3080 },
	{ 0xC768, 0x3081 },
	{ 0xC769, 0x3082 },
	{ 0xC76A, 0x3083 },
	{ 0xC76B, 0x3084 },
	{ 0xC76C, 0x3085 },
	{ 0xC76D, 0x3086 },
	{ 0xC76E, 0x3087 },
	{ 0xC76F, 0x3088 },
	{ 0xC770, 0x3089 },
	{ 0xC771, 0x308A },
	{ 0xC772, 0x308B },
	{ 0xC773, 0x308C },
	{ 0xC774, 0x308D },
	{ 0xC775, 0x308E },
	{ 0xC776, 0x308F },
	{ 0xC777, 0x3090 },
	{ 0xC778, 0x3091 },
	{ 0xC779, 0x3092 },
	{ 0xC77A, 0x3093 },
	{ 0xC77B, 0x30A1 },
	{ 0xC77C, 0x30A2 },
	{ 0xC77D, 0x30A3 },
	{ 0xC77E, 0x30A4 },
	{ 0xC77F, 0xFFFD },
	{ 0xC780, 0x69C5 },
	{ 0xC781, 0x69C8 },
	{ 0xC782, 0x6992 },
	{ 0xC783, 0x69B2 },
	{ 0xC784, 0x69E3 },
	{ 0xC785, 0x69C0 },
	{ 0xC786, 0x69D6 },
	{ 0xC787, 0x69D1 },
	{ 0xC788, 0x699F },
	{ 0xC789, 0x69A2 },
	{ 0xC78A, 0x69D2 },
	{ 0xC78B, 0x69E1 },
	{ 0xC78C, 0x69D5 },
	{ 0xC78D, 0x699D },
	{ 0xC78E, 0x6998 },
	{ 0xC78F, 0x6B74 },
	{ 0xC790, 0x6BA1 },
	{ 0xC791, 0x6EF0 },
	{ 0xC792, 0x6EF3 },
	{ 0xC793, 0x6F1B },
	{ 0xC794, 0x6F0C },
	{ 0xC795, 0x6F1D },
	{ 0xC796, 0x6F34 },
	{ 0xC797, 0x6F28 },
	{ 0xC798, 0x6F17 },
	{ 0xC799, 0x6F44 },
	{ 0xC79A, 0x6F42 },
	{ 0xC79B, 0x6F04 },
	{ 0xC79C, 0x6F11 },
	{ 0xC79D, 0x6EFA },
	{ 0xC79E, 0x6F4A },
	{ 0xC79F, 0x7191 },
	{ 0xC7A0, 0x718E },
	{ 0xC7A1, 0x30A5 },
	{ 0xC7A2, 0x30A6 },
	{ 0xC7A3, 0x30A7 },
	{ 0xC7A4, 0x30A8 },
	{ 0xC7A5, 0x30A9 },
	{ 0xC7A6, 0x30AA },
	{ 0xC7A7, 0x30AB },
	{ 0xC7A8, 0x30AC },
	{ 0xC7A9, 0x30AD },
	{ 0xC7AA, 0x30AE },
	{ 0xC7AB, 0x30AF },
	{ 0xC7AC, 0x30B0 },
	{ 0xC7AD, 0x30B1 },
	{ 0xC7AE, 0x30B2 },
	{ 0xC7AF, 0x30B3 },
	{ 0xC7B0, 0x30B4 },
	{ 0xC7B1, 0x30B5 },
	{ 0xC7B2, 0x30B6 },
	{ 0xC7B3, 0x30B7 },
	{ 0xC7B4, 0x30B8 },
	{ 0xC7B5, 0x30B9 },
	{ 0xC7B6, 0x30BA },
	{ 0xC7B7, 0x30BB },
	{ 0xC7B8, 0x30BC },
	{ 0xC7B9, 0x30BD },
	{ 0xC7BA, 0x30BE },
	{ 0xC7BB, 0x30BF },
	{ 0xC7BC, 0x30C0 },
	{ 0xC7BD, 0x30C1 },
	{ 0xC7BE, 0x30C2 },
	{ 0xC7BF, 0x30C3 },
	{ 0xC7C0, 0x30C4 },
	{ 0xC7C1, 0x30C5 },
	{ 0xC7C2, 0x30C6 },
	{ 0xC7C3, 0x30C7 },
	{ 0xC7C4, 0x30C8 },
	{ 0xC7C5, 0x30C9 },
	{ 0xC7C6, 0x30CA },
	{ 0xC7C7, 0x30CB },
	{ 0xC7C8, 0x30CC },
	{ 0xC7C9, 0x30CD },
	{ 0xC7CA, 0x30CE },
	{ 0xC7CB, 0x30CF },
	{ 0xC7CC, 0x30D0 },
	{ 0xC7CD, 0x30D1 },
	{ 0xC7CE, 0x30D2 },
	{ 0xC7CF, 0x30D3 },
	{ 0xC7D0, 0x30D4 },
	{ 0xC7D1, 0x30D5 },
	{ 0xC7D2, 0x30D6 },
	{ 0xC7D3, 0x30D7 },
	{ 0xC7D4, 0x30D8 },
	{ 0xC7D5, 0x30D9 },
	{ 0xC7D6, 0x30DA },
	{ 0xC7D7, 0x30DB },
	{ 0xC7D8, 0x30DC },
	{ 0xC7D9, 0x30DD },
	{ 0xC7DA, 0x30DE },
	{ 0xC7DB, 0x30DF },
	{ 0xC7DC, 0x30E0 },
	{ 0xC7DD, 0x30E1 },
	{ 0xC7DE, 0x30E2 },
	{ 0xC7DF, 0x30E3 },
	{ 0xC7E0, 0x30E4 },
	{ 0xC7E1, 0x30E5 },
	{ 0xC7E2, 0x30E6 },
	{ 0xC7E3, 0x30E7 },
	{ 0xC7E4, 0x30E8 },
	{ 0xC7E5, 0x30E9 },
	{ 0xC7E6, 0x30EA },
	{ 0xC7E7, 0x30EB },
	{ 0xC7E8, 0x30EC },
	{ 0xC7E9, 0x30ED },
	{ 0xC7EA, 0x30EE },
	{ 0xC7EB, 0x30EF },
	{ 0xC7EC, 0x30F0 },
	{ 0xC7ED, 0x30F1 },
	{ 0xC7EE, 0x30F2 },
	{ 0xC7EF, 0x30F3 },
	{ 0xC7F0, 0x30F4 },
	{ 0xC7F1, 0x30F5 },
	{ 0xC7F2, 0x30F6 },
	{ 0xC7F3, 0x6BB9 },
	{ 0xC7F4, 0x6E0B },
	{ 0xC7F5, 0x7105 },
	{ 0xC7F6, 0x7314 },
	{ 0xC7F7, 0x7304 },
	{ 0xC7F8, 0x7305 },
	{ 0xC7F9, 0x7315 },
	{ 0xC7FA, 0x730D },
	{ 0xC7FB, 0x772E },
	{ 0xC7FC, 0x7741 },
	{ 0xC7FD, 0x77EA },
	{ 0xC7FE, 0x7844 },
	{ 0xC840, 0x7B29 },
	{ 0xC841, 0x7B27 },
	{ 0xC842, 0x7C9D },
	{ 0xC843, 0x7FC8 },
	{ 0xC844, 0x8126 },
	{ 0xC845, 0x811C },
	{ 0xC846, 0x8128 },
	{ 0xC847, 0x8370 },
	{ 0xC848, 0x8382 },
	{ 0xC849, 0x83AC },
	{ 0xC84A, 0x86AD },
	{ 0xC84B, 0x86CA },
	{ 0xC84C, 0x8851 },
	{ 0xC84D, 0x889D },
	{ 0xC84E, 0x8990 },
	{ 0xC84F, 0x89D8 },
	{ 0xC850, 0x89D7 },
	{ 0xC851, 0x8A2E },
	{ 0xC852, 0x8C59 },
	{ 0xC853, 0x8EDA },
	{ 0xC854, 0x9033 },
	{ 0xC855, 0x9018 },
	{ 0xC856, 0x91EF },
	{ 0xC857, 0x9AD9 },
	{ 0xC858, 0x4EB4 },
	{ 0xC859, 0x50A0 },
	{ 0xC85A, 0x5090 },
	{ 0xC85B, 0x5086 },
	{ 0xC85C, 0x5084 },
	{ 0xC85D, 0x508A },
	{ 0xC85E, 0x509F },
	{ 0xC85F, 0x50A1 },
	{ 0xC860, 0x5093 },
	{ 0xC861, 0x51D5 },
	{ 0xC862, 0x5590 },
	{ 0xC863, 0x5710 },
	{ 0xC864, 0x5817 },
	{ 0xC865, 0x5844 },
	{ 0xC866, 0x582B },
	{ 0xC867, 0x5845 },
	{ 0xC868, 0x5965 },
	{ 0xC869, 0x5BCF },
	{ 0xC86A, 0x5D56 },
	{ 0xC86B, 0x5D54 },
	{ 0xC86C, 0x5F3D },
	{ 0xC86D, 0x5FA4 },
	{ 0xC86E, 0x63EC },
	{ 0xC86F, 0x63FA },
	{ 0xC870, 0x63D4 },
	{ 0xC871, 0x6675 },
	{ 0xC872, 0x671C },
	{ 0xC873, 0x68D9 },
	{ 0xC874, 0x6BF1 },
	{ 0xC875, 0x6E37 },
	{ 0xC876, 0x6E7D },
	{ 0xC877, 0x6E86 },
	{ 0xC878, 0x74FA },
	{ 0xC879, 0x7572 },
	{ 0xC87A, 0x75DC },
	{ 0xC87B, 0x7867 },
	{ 0xC87C, 0x7977 },
	{ 0xC87D, 0x7A9B },
	{ 0xC87E, 0x7D2A },
	{ 0xC87F, 0xFFFD },
	{ 0xC880, 0x718B },
	{ 0xC881, 0x718D },
	{ 0xC882, 0x717F },
	{ 0xC883, 0x718C },
	{ 0xC884, 0x717E },
	{ 0xC885, 0x717C },
	{ 0xC886, 0x7183 },
	{ 0xC887, 0x7188 },
	{ 0xC888, 0x7294 },
	{ 0xC889, 0x7355 },
	{ 0xC88A, 0x7353 },
	{ 0xC88B, 0x734F },
	{ 0xC88C, 0x7354 },
	{ 0xC88D, 0x746C },
	{ 0xC88E, 0x7465 },
	{ 0xC88F, 0x7466 },
	{ 0xC890, 0x7461 },
	{ 0xC891, 0x746B },
	{ 0xC892, 0x7468 },
	{ 0xC893, 0x7476 },
	{ 0xC894, 0x7460 },
	{ 0xC895, 0x7474 },
	{ 0xC896, 0x7506 },
	{ 0xC897, 0x760E },
	{ 0xC898, 0x7607 },
	{ 0xC899, 0x76B9 },
	{ 0xC89A, 0x76B7 },
	{ 0xC89B, 0x76E2 },
	{ 0xC89C, 0x7774 },
	{ 0xC89D, 0x7777 },
	{ 0xC89E, 0x7776 },
	{ 0xC89F, 0x7775 },
	{ 0xC8A0, 0x7778 },
	{ 0xC8A1, 0x7D65 },
	{ 0xC8A2, 0x7F64 },
	{ 0xC8A3, 0x8020 },
	{ 0xC8A4, 0x8120 },
	{ 0xC8A5, 0x813C },
	{ 0xC8A6, 0x813F },
	{ 0xC8A7, 0x81F0 },
	{ 0xC8A8, 0x81F5 },
	{ 0xC8A9, 0x8415 },
	{ 0xC8AA, 0x83BE },
	{ 0xC8AB, 0x86E5 },
	{ 0xC8AC, 0x86D2 },
	{ 0xC8AD, 0x86E0 },
	{ 0xC8AE, 0x88B3 },
	{ 0xC8AF, 0x8A53 },
	{ 0xC8B0, 0x8A37 },
	{ 0xC8B1, 0x8A47 },
	{ 0xC8B2, 0x8A5C },
	{ 0xC8B3, 0x8EF0 },
	{ 0xC8B4, 0x921D },
	{ 0xC8B5, 0x976B },
	{ 0xC8B6, 0x50C0 },
	{ 0xC8B7, 0x52E5 },
	{ 0xC8B8, 0x53AF },
	{ 0xC8B9, 0x55D8 },
	{ 0xC8BA, 0x5711 },
	{ 0xC8BB, 0x5867 },
	{ 0xC8BC, 0x5843 },
	{ 0xC8BD, 0x5BDD },
	{ 0xC8BE, 0x5D70 },
	{ 0xC8BF, 0x5D6A },
	{ 0xC8C0, 0x5D74 },
	{ 0xC8C1, 0x5D5F },
	{ 0xC8C2, 0x5D61 },
	{ 0xC8C3, 0x5D73 },
	{ 0xC8C4, 0x5E50 },
	{ 0xC8C5, 0x5F3F },
	{ 0xC8C6, 0x5FB0 },
	{ 0xC8C7, 0x6135 },
	{ 0xC8C8, 0x612D },
	{ 0xC8C9, 0x6102 },
	{ 0xC8CA, 0x6226 },
	{ 0xC8CB, 0x656E },
	{ 0xC8CC, 0x65B1 },
	{ 0xC8CD, 0x65D4 },
	{ 0xC8CE, 0x6685 },
	{ 0xC8CF, 0x6972 },
	{ 0xC8D0, 0x693A },
	{ 0xC8D1, 0x6EAD },
	{ 0xC8D2, 0x6E95 },
	{ 0xC8D3, 0x7243 },
	{ 0xC8D4, 0x728F },
	{ 0xC8D5, 0x7575 },
	{ 0xC8D6, 0x75EC },
	{ 0xC8D7, 0x7757 },
	{ 0xC8D8, 0x797B },
	{ 0xC8D9, 0x7A21 },
	{ 0xC8DA, 0x7A16 },
	{ 0xC8DB, 0x7AE8 },
	{ 0xC8DC, 0x7B6A },
	{ 0xC8DD, 0x7B5F },
	{ 0xC8DE, 0x7D82 },
	{ 0xC8DF, 0x8055 },
	{ 0xC8E0, 0x8168 },
	{ 0xC8E1, 0x8246 },
	{ 0xC8E2, 0x8243 },
	{ 0xC8E3, 0x8481 },
	{ 0xC8E4, 0x847C },
	{ 0xC8E5, 0x846A },
	{ 0xC8E6, 0x9170 },
	{ 0xC8E7, 0x50D2 },
	{ 0xC8E8, 0x9B62 },
	{ 0xC8E9, 0x6F8A },
	{ 0xC8EA, 0x8772 },
	{ 0xC8EB, 0x9AF0 },
	{ 0xC8EC, 0x9EA8 },
	{ 0xC8ED, 0x5292 },
	{ 0xC8EE, 0x878C },
	{ 0xC8EF, 0x9ABA },
	{ 0xC8F0, 0x9B81 },
	{ 0xC8F1, 0x9384 },
	{ 0xC8F2, 0x9AFF },
	{ 0xC8F3, 0x9BB3 },
	{ 0xC8F4, 0x9BB0 },
	{ 0xC8F5, 0x9EC7 },
	{ 0xC8F6, 0x9721 },
	{ 0xC8F7, 0x7C36 },
	{ 0xC8F8, 0x8B5E },
	{ 0xC8F9, 0x9401 },
	{ 0xC8FA, 0x941D },
	{ 0xC8FB, 0x994A },
	{ 0xC8FC, 0x8B73 },
	{ 0xC8FD, 0x9DD4 },
	{ 0xC8FE, 0x77D6 },
	{ 0xC940, 0x4E42 },
	{ 0xC941, 0x4E5C },
	{ 0xC942, 0x51F5 },
	{ 0xC943, 0x531A },
	{ 0xC944, 0x5382 },
	{ 0xC945, 0x4E07 },
	{ 0xC946, 0x4E0C },
	{ 0xC947, 0x4E47 },
	{ 0xC948, 0x4E8D },
	{ 0xC949, 0x56D7 },
	{ 0xC94A, 0x5140 },
	{ 0xC94B, 0x5C6E },
	{ 0xC94C, 0x5F73 },
	{ 0xC94D, 0x4E0F },
	{ 0xC94E, 0x5187 },
	{ 0xC94F, 0x4E0E },
	{ 0xC950, 0x4E2E },
	{ 0xC951, 0x4E93 },
	{ 0xC952, 0x4EC2 },
	{ 0xC953, 0x4EC9 },
	{ 0xC954, 0x4EC8 },
	{ 0xC955, 0x5198 },
	{ 0xC956, 0x52FC },
	{ 0xC957, 0x536C },
	{ 0xC958, 0x53B9 },
	{ 0xC959, 0x5720 },
	{ 0xC95A, 0x5903 },
	{ 0xC95B, 0x592C },
	{ 0xC95C, 0x5C10 },
	{ 0xC95D, 0x5DFF },
	{ 0xC95E, 0x65E1 },
	{ 0xC95F, 0x6BB3 },
	{ 0xC960, 0x6BCC },
	{ 0xC961, 0x6C14 },
	{ 0xC962, 0x723F },
	{ 0xC963, 0x4E31 },
	{ 0xC964, 0x4E3C },
	{ 0xC965, 0x4EE8 },
	{ 0xC966, 0x4EDC },
	{ 0xC967, 0x4EE9 },
	{ 0xC968, 0x4EE1 },
	{ 0xC969, 0x4EDD },
	{ 0xC96A, 0x4EDA },
	{ 0xC96B, 0x520C },
	{ 0xC96C, 0x531C },
	{ 0xC96D, 0x534C },
	{ 0xC96E, 0x5722 },
	{ 0xC96F, 0x5723 },
	{ 0xC970, 0x5917 },
	{ 0xC971, 0x592F },
	{ 0xC972, 0x5B81 },
	{ 0xC973, 0x5B84 },
	{ 0xC974, 0x5C12 },
	{ 0xC975, 0x5C3B },
	{ 0xC976, 0x5C74 },
	{ 0xC977, 0x5C73 },
	{ 0xC978, 0x5E04 },
	{ 0xC979, 0x5E80 },
	{ 0xC97A, 0x5E82 },
	{ 0xC97B, 0x5FC9 },
	{ 0xC97C, 0x6209 },
	{ 0xC97D, 0x6250 },
	{ 0xC97E, 0x6C15 },
	{ 0xC97F, 0xFFFD },
	{ 0xC980, 0x7771 },
	{ 0xC981, 0x777A },
	{ 0xC982, 0x715B },
	{ 0xC983, 0x777B },
	{ 0xC984, 0x78A6 },
	{ 0xC985, 0x78AE },
	{ 0xC986, 0x78B8 },
	{ 0xC987, 0x78B1 },
	{ 0xC988, 0x78AF },
	{ 0xC989, 0x7989 },
	{ 0xC98A, 0x7987 },
	{ 0xC98B, 0x7A29 },
	{ 0xC98C, 0x7A2A },
	{ 0xC98D, 0x7A2D },
	{ 0xC98E, 0x7A2C },
	{ 0xC98F, 0x7A32 },
	{ 0xC990, 0x7AEC },
	{ 0xC991, 0x7AF0 },
	{ 0xC992, 0x7B81 },
	{ 0xC993, 0x7B9E },
	{ 0xC994, 0x7B83 },
	{ 0xC995, 0x7B92 },
	{ 0xC996, 0x7BA3 },
	{ 0xC997, 0x7B9F },
	{ 0xC998, 0x7B93 },
	{ 0xC999, 0x7B86 },
	{ 0xC99A, 0x7CB8 },
	{ 0xC99B, 0x7CB7 },
	{ 0xC99C, 0x7DC8 },
	{ 0xC99D, 0x7DB6 },
	{ 0xC99E, 0x7DD1 },
	{ 0xC99F, 0x7DA8 },
	{ 0xC9A0, 0x7DAB },
	{ 0xC9A1, 0x6C36 },
	{ 0xC9A2, 0x6C43 },
	{ 0xC9A3, 0x6C3F },
	{ 0xC9A4, 0x6C3B },
	{ 0xC9A5, 0x72AE },
	{ 0xC9A6, 0x72B0 },
	{ 0xC9A7, 0x738A },
	{ 0xC9A8, 0x79B8 },
	{ 0xC9A9, 0x808A },
	{ 0xC9AA, 0x961E },
	{ 0xC9AB, 0x4F0E },
	{ 0xC9AC, 0x4F18 },
	{ 0xC9AD, 0x4F2C },
	{ 0xC9AE, 0x4EF5 },
	{ 0xC9AF, 0x4F14 },
	{ 0xC9B0, 0x4EF1 },
	{ 0xC9B1, 0x4F00 },
	{ 0xC9B2, 0x4EF7 },
	{ 0xC9B3, 0x4F08 },
	{ 0xC9B4, 0x4F1D },
	{ 0xC9B5, 0x4F02 },
	{ 0xC9B6, 0x4F05 },
	{ 0xC9B7, 0x4F22 },
	{ 0xC9B8, 0x4F13 },
	{ 0xC9B9, 0x4F04 },
	{ 0xC9BA, 0x4EF4 },
	{ 0xC9BB, 0x4F12 },
	{ 0xC9BC, 0x51B1 },
	{ 0xC9BD, 0x5213 },
	{ 0xC9BE, 0x5209 },
	{ 0xC9BF, 0x5210 },
	{ 0xC9C0, 0x52A6 },
	{ 0xC9C1, 0x5322 },
	{ 0xC9C2, 0x531F },
	{ 0xC9C3, 0x534D },
	{ 0xC9C4, 0x538A },
	{ 0xC9C5, 0x5407 },
	{ 0xC9C6, 0x56E1 },
	{ 0xC9C7, 0x56DF },
	{ 0xC9C8, 0x572E },
	{ 0xC9C9, 0x572A },
	{ 0xC9CA, 0x5734 },
	{ 0xC9CB, 0x593C },
	{ 0xC9CC, 0x5980 },
	{ 0xC9CD, 0x597C },
	{ 0xC9CE, 0x5985 },
	{ 0xC9CF, 0x597B },
	{ 0xC9D0, 0x597E },
	{ 0xC9D1, 0x5977 },
	{ 0xC9D2, 0x597F },
	{ 0xC9D3, 0x5B56 },
	{ 0xC9D4, 0x5C15 },
	{ 0xC9D5, 0x5C25 },
	{ 0xC9D6, 0x5C7C },
	{ 0xC9D7, 0x5C7A },
	{ 0xC9D8, 0x5C7B },
	{ 0xC9D9, 0x5C7E },
	{ 0xC9DA, 0x5DDF },
	{ 0xC9DB, 0x5E75 },
	{ 0xC9DC, 0x5E84 },
	{ 0xC9DD, 0x5F02 },
	{ 0xC9DE, 0x5F1A },
	{ 0xC9DF, 0x5F74 },
	{ 0xC9E0, 0x5FD5 },
	{ 0xC9E1, 0x5FD4 },
	{ 0xC9E2, 0x5FCF },
	{ 0xC9E3, 0x625C },
	{ 0xC9E4, 0x625E },
	{ 0xC9E5, 0x6264 },
	{ 0xC9E6, 0x6261 },
	{ 0xC9E7, 0x6266 },
	{ 0xC9E8, 0x6262 },
	{ 0xC9E9, 0x6259 },
	{ 0xC9EA, 0x6260 },
	{ 0xC9EB, 0x625A },
	{ 0xC9EC, 0x6265 },
	{ 0xC9ED, 0x65EF },
	{ 0xC9EE, 0x65EE },
	{ 0xC9EF, 0x673E },
	{ 0xC9F0, 0x6739 },
	{ 0xC9F1, 0x6738 },
	{ 0xC9F2, 0x673B },
	{ 0xC9F3, 0x673A },
	{ 0xC9F4, 0x673F },
	{ 0xC9F5, 0x673C },
	{ 0xC9F6, 0x6733 },
	{ 0xC9F7, 0x6C18 },
	{ 0xC9F8, 0x6C46 },
	{ 0xC9F9, 0x6C52 },
	{ 0xC9FA, 0x6C5C },
	{ 0xC9FB, 0x6C4F },
	{ 0xC9FC, 0x6C4A },
	{ 0xC9FD, 0x6C54 },
	{ 0xC9FE, 0x6C4B },
	{ 0xCA40, 0x6C4C },
	{ 0xCA41, 0x7071 },
	{ 0xCA42, 0x725E },
	{ 0xCA43, 0x72B4 },
	{ 0xCA44, 0x72B5 },
	{ 0xCA45, 0x738E },
	{ 0xCA46, 0x752A },
	{ 0xCA47, 0x767F },
	{ 0xCA48, 0x7A75 },
	{ 0xCA49, 0x7F51 },
	{ 0xCA4A, 0x8278 },
	{ 0xCA4B, 0x827C },
	{ 0xCA4C, 0x8280 },
	{ 0xCA4D, 0x827D },
	{ 0xCA4E, 0x827F },
	{ 0xCA4F, 0x864D },
	{ 0xCA50, 0x897E },
	{ 0xCA51, 0x9099 },
	{ 0xCA52, 0x9097 },
	{ 0xCA53, 0x9098 },
	{ 0xCA54, 0x909B },
	{ 0xCA55, 0x9094 },
	{ 0xCA56, 0x9622 },
	{ 0xCA57, 0x9624 },
	{ 0xCA58, 0x9620 },
	{ 0xCA59, 0x9623 },
	{ 0xCA5A, 0x4F56 },
	{ 0xCA5B, 0x4F3B },
	{ 0xCA5C, 0x4F62 },
	{ 0xCA5D, 0x4F49 },
	{ 0xCA5E, 0x4F53 },
	{ 0xCA5F, 0x4F64 },
	{ 0xCA60, 0x4F3E },
	{ 0xCA61, 0x4F67 },
	{ 0xCA62, 0x4F52 },
	{ 0xCA63, 0x4F5F },
	{ 0xCA64, 0x4F41 },
	{ 0xCA65, 0x4F58 },
	{ 0xCA66, 0x4F2D },
	{ 0xCA67, 0x4F33 },
	{ 0xCA68, 0x4F3F },
	{ 0xCA69, 0x4F61 },
	{ 0xCA6A, 0x518F },
	{ 0xCA6B, 0x51B9 },
	{ 0xCA6C, 0x521C },
	{ 0xCA6D, 0x521E },
	{ 0xCA6E, 0x5221 },
	{ 0xCA6F, 0x52AD },
	{ 0xCA70, 0x52AE },
	{ 0xCA71, 0x5309 },
	{ 0xCA72, 0x5363 },
	{ 0xCA73, 0x5372 },
	{ 0xCA74, 0x538E },
	{ 0xCA75, 0x538F },
	{ 0xCA76, 0x5430 },
	{ 0xCA77, 0x5437 },
	{ 0xCA78, 0x542A },
	{ 0xCA79, 0x5454 },
	{ 0xCA7A, 0x5445 },
	{ 0xCA7B, 0x5419 },
	{ 0xCA7C, 0x541C },
	{ 0xCA7D, 0x5425 },
	{ 0xCA7E, 0x5418 },
	{ 0xCA7F, 0xFFFD },
	{ 0xCA80, 0x7DB3 },
	{ 0xCA81, 0x7DCD },
	{ 0xCA82, 0x7DCF },
	{ 0xCA83, 0x7DA4 },
	{ 0xCA84, 0x7F41 },
	{ 0xCA85, 0x7F6F },
	{ 0xCA86, 0x7F71 },
	{ 0xCA87, 0x8023 },
	{ 0xCA88, 0x805B },
	{ 0xCA89, 0x8061 },
	{ 0xCA8A, 0x805F },
	{ 0xCA8B, 0x8181 },
	{ 0xCA8C, 0x8184 },
	{ 0xCA8D, 0x8213 },
	{ 0xCA8E, 0x824A },
	{ 0xCA8F, 0x824C },
	{ 0xCA90, 0x84BD },
	{ 0xCA91, 0x8495 },
	{ 0xCA92, 0x8492 },
	{ 0xCA93, 0x84C3 },
	{ 0xCA94, 0x8496 },
	{ 0xCA95, 0x84A5 },
	{ 0xCA96, 0x84B5 },
	{ 0xCA97, 0x84B3 },
	{ 0xCA98, 0x84A3 },
	{ 0xCA99, 0x84E4 },
	{ 0xCA9A, 0x84D8 },
	{ 0xCA9B, 0x84D5 },
	{ 0xCA9C, 0x84B7 },
	{ 0xCA9D, 0x84AD },
	{ 0xCA9E, 0x84DA },
	{ 0xCA9F, 0x8493 },
	{ 0xCAA0, 0x8736 },
	{ 0xCAA1, 0x543D },
	{ 0xCAA2, 0x544F },
	{ 0xCAA3, 0x5441 },
	{ 0xCAA4, 0x5428 },
	{ 0xCAA5, 0x5424 },
	{ 0xCAA6, 0x5447 },
	{ 0xCAA7, 0x56EE },
	{ 0xCAA8, 0x56E7 },
	{ 0xCAA9, 0x56E5 },
	{ 0xCAAA, 0x5741 },
	{ 0xCAAB, 0x5745 },
	{ 0xCAAC, 0x574C },
	{ 0xCAAD, 0x5749 },
	{ 0xCAAE, 0x574B },
	{ 0xCAAF, 0x5752 },
	{ 0xCAB0, 0x5906 },
	{ 0xCAB1, 0x5940 },
	{ 0xCAB2, 0x59A6 },
	{ 0xCAB3, 0x5998 },
	{ 0xCAB4, 0x59A0 },
	{ 0xCAB5, 0x5997 },
	{ 0xCAB6, 0x598E },
	{ 0xCAB7, 0x59A2 },
	{ 0xCAB8, 0x5990 },
	{ 0xCAB9, 0x598F },
	{ 0xCABA, 0x59A7 },
	{ 0xCABB, 0x59A1 },
	{ 0xCABC, 0x5B8E },
	{ 0xCABD, 0x5B92 },
	{ 0xCABE, 0x5C28 },
	{ 0xCABF, 0x5C2A },
	{ 0xCAC0, 0x5C8D },
	{ 0xCAC1, 0x5C8F },
	{ 0xCAC2, 0x5C88 },
	{ 0xCAC3, 0x5C8B },
	{ 0xCAC4, 0x5C89 },
	{ 0xCAC5, 0x5C92 },
	{ 0xCAC6, 0x5C8A },
	{ 0xCAC7, 0x5C86 },
	{ 0xCAC8, 0x5C93 },
	{ 0xCAC9, 0x5C95 },
	{ 0xCACA, 0x5DE0 },
	{ 0xCACB, 0x5E0A },
	{ 0xCACC, 0x5E0E },
	{ 0xCACD, 0x5E8B },
	{ 0xCACE, 0x5E89 },
	{ 0xCACF, 0x5E8C },
	{ 0xCAD0, 0x5E88 },
	{ 0xCAD1, 0x5E8D },
	{ 0xCAD2, 0x5F05 },
	{ 0xCAD3, 0x5F1D },
	{ 0xCAD4, 0x5F78 },
	{ 0xCAD5, 0x5F76 },
	{ 0xCAD6, 0x5FD2 },
	{ 0xCAD7, 0x5FD1 },
	{ 0xCAD8, 0x5FD0 },
	{ 0xCAD9, 0x5FED },
	{ 0xCADA, 0x5FE8 },
	{ 0xCADB, 0x5FEE },
	{ 0xCADC, 0x5FF3 },
	{ 0xCADD, 0x5FE1 },
	{ 0xCADE, 0x5FE4 },
	{ 0xCADF, 0x5FE3 },
	{ 0xCAE0, 0x5FFA },
	{ 0xCAE1, 0x5FEF },
	{ 0xCAE2, 0x5FF7 },
	{ 0xCAE3, 0x5FFB },
	{ 0xCAE4, 0x6000 },
	{ 0xCAE5, 0x5FF4 },
	{ 0xCAE6, 0x623A },
	{ 0xCAE7, 0x6283 },
	{ 0xCAE8, 0x628C },
	{ 0xCAE9, 0x628E },
	{ 0xCAEA, 0x628F },
	{ 0xCAEB, 0x6294 },
	{ 0xCAEC, 0x6287 },
	{ 0xCAED, 0x6271 },
	{ 0xCAEE, 0x627B },
	{ 0xCAEF, 0x627A },
	{ 0xCAF0, 0x6270 },
	{ 0xCAF1, 0x6281 },
	{ 0xCAF2, 0x6288 },
	{ 0xCAF3, 0x6277 },
	{ 0xCAF4, 0x627D },
	{ 0xCAF5, 0x6272 },
	{ 0xCAF6, 0x6274 },
	{ 0xCAF7, 0x6537 },
	{ 0xCAF8, 0x65F0 },
	{ 0xCAF9, 0x65F4 },
	{ 0xCAFA, 0x65F3 },
	{ 0xCAFB, 0x65F2 },
	{ 0xCAFC, 0x65F5 },
	{ 0xCAFD, 0x6745 },
	{ 0xCAFE, 0x6747 },
	{ 0xCB40, 0x6759 },
	{ 0xCB41, 0x6755 },
	{ 0xCB42, 0x674C },
	{ 0xCB43, 0x6748 },
	{ 0xCB44, 0x675D },
	{ 0xCB45, 0x674D },
	{ 0xCB46, 0x675A },
	{ 0xCB47, 0x674B },
	{ 0xCB48, 0x6BD0 },
	{ 0xCB49, 0x6C19 },
	{ 0xCB4A, 0x6C1A },
	{ 0xCB4B, 0x6C78 },
	{ 0xCB4C, 0x6C67 },
	{ 0xCB4D, 0x6C6B },
	{ 0xCB4E, 0x6C84 },
	{ 0xCB4F, 0x6C8B },
	{ 0xCB50, 0x6C8F },
	{ 0xCB51, 0x6C71 },
	{ 0xCB52, 0x6C6F },
	{ 0xCB53, 0x6C69 },
	{ 0xCB54, 0x6C9A },
	{ 0xCB55, 0x6C6D },
	{ 0xCB56, 0x6C87 },
	{ 0xCB57, 0x6C95 },
	{ 0xCB58, 0x6C9C },
	{ 0xCB59, 0x6C66 },
	{ 0xCB5A, 0x6C73 },
	{ 0xCB5B, 0x6C65 },
	{ 0xCB5C, 0x6C7B },
	{ 0xCB5D, 0x6C8E },
	{ 0xCB5E, 0x7074 },
	{ 0xCB5F, 0x707A },
	{ 0xCB60, 0x7263 },
	{ 0xCB61, 0x72BF },
	{ 0xCB62, 0x72BD },
	{ 0xCB63, 0x72C3 },
	{ 0xCB64, 0x72C6 },
	{ 0xCB65, 0x72C1 },
	{ 0xCB66, 0x72BA },
	{ 0xCB67, 0x72C5 },
	{ 0xCB68, 0x7395 },
	{ 0xCB69, 0x7397 },
	{ 0xCB6A, 0x7393 },
	{ 0xCB6B, 0x7394 },
	{ 0xCB6C, 0x7392 },
	{ 0xCB6D, 0x753A },
	{ 0xCB6E, 0x7539 },
	{ 0xCB6F, 0x7594 },
	{ 0xCB70, 0x7595 },
	{ 0xCB71, 0x7681 },
	{ 0xCB72, 0x793D },
	{ 0xCB73, 0x8034 },
	{ 0xCB74, 0x8095 },
	{ 0xCB75, 0x8099 },
	{ 0xCB76, 0x8090 },
	{ 0xCB77, 0x8092 },
	{ 0xCB78, 0x809C },
	{ 0xCB79, 0x8290 },
	{ 0xCB7A, 0x828F },
	{ 0xCB7B, 0x8285 },
	{ 0xCB7C, 0x828E },
	{ 0xCB7D, 0x8291 },
	{ 0xCB7E, 0x8293 },
	{ 0xCB7F, 0xFFFD },
	{ 0xCB80, 0x873D },
	{ 0xCB81, 0x872B },
	{ 0xCB82, 0x8747 },
	{ 0xCB83, 0x8739 },
	{ 0xCB84, 0x8745 },
	{ 0xCB85, 0x871D },
	{ 0xCB86, 0x88FF },
	{ 0xCB87, 0x88EA },
	{ 0xCB88, 0x88F5 },
	{ 0xCB89, 0x8900 },
	{ 0xCB8A, 0x88ED },
	{ 0xCB8B, 0x8903 },
	{ 0xCB8C, 0x88E9 },
	{ 0xCB8D, 0x89EA },
	{ 0xCB8E, 0x8A9B },
	{ 0xCB8F, 0x8A8E },
	{ 0xCB90, 0x8AA2 },
	{ 0xCB91, 0x8A9C },
	{ 0xCB92, 0x8A94 },
	{ 0xCB93, 0x8A90 },
	{ 0xCB94, 0x8AA9 },
	{ 0xCB95, 0x8AAC },
	{ 0xCB96, 0x8A9F },
	{ 0xCB97, 0x8A9D },
	{ 0xCB98, 0x8C67 },
	{ 0xCB99, 0x8CD0 },
	{ 0xCB9A, 0x8CD6 },
	{ 0xCB9B, 0x8CD4 },
	{ 0xCB9C, 0x8D98 },
	{ 0xCB9D, 0x8D9A },
	{ 0xCB9E, 0x8D97 },
	{ 0xCB9F, 0x8E0B },
	{ 0xCBA0, 0x8E08 },
	{ 0xCBA1, 0x828A },
	{ 0xCBA2, 0x8283 },
	{ 0xCBA3, 0x8284 },
	{ 0xCBA4, 0x8C78 },
	{ 0xCBA5, 0x8FC9 },
	{ 0xCBA6, 0x8FBF },
	{ 0xCBA7, 0x909F },
	{ 0xCBA8, 0x90A1 },
	{ 0xCBA9, 0x90A5 },
	{ 0xCBAA, 0x909E },
	{ 0xCBAB, 0x90A7 },
	{ 0xCBAC, 0x90A0 },
	{ 0xCBAD, 0x9630 },
	{ 0xCBAE, 0x9628 },
	{ 0xCBAF, 0x962F },
	{ 0xCBB0, 0x962D },
	{ 0xCBB1, 0x4E33 },
	{ 0xCBB2, 0x4F98 },
	{ 0xCBB3, 0x4F7C },
	{ 0xCBB4, 0x4F85 },
	{ 0xCBB5, 0x4F7D },
	{ 0xCBB6, 0x4F80 },
	{ 0xCBB7, 0x4F87 },
	{ 0xCBB8, 0x4F76 },
	{ 0xCBB9, 0x4F74 },
	{ 0xCBBA, 0x4F89 },
	{ 0xCBBB, 0x4F84 },
	{ 0xCBBC, 0x4F77 },
	{ 0xCBBD, 0x4F4C },
	{ 0xCBBE, 0x4F97 },
	{ 0xCBBF, 0x4F6A },
	{ 0xCBC0, 0x4F9A },
	{ 0xCBC1, 0x4F79 },
	{ 0xCBC2, 0x4F81 },
	{ 0xCBC3, 0x4F78 },
	{ 0xCBC4, 0x4F90 },
	{ 0xCBC5, 0x4F9C },
	{ 0xCBC6, 0x4F94 },
	{ 0xCBC7, 0x4F9E },
	{ 0xCBC8, 0x4F92 },
	{ 0xCBC9, 0x4F82 },
	{ 0xCBCA, 0x4F95 },
	{ 0xCBCB, 0x4F6B },
	{ 0xCBCC, 0x4F6E },
	{ 0xCBCD, 0x519E },
	{ 0xCBCE, 0x51BC },
	{ 0xCBCF, 0x51BE },
	{ 0xCBD0, 0x5235 },
	{ 0xCBD1, 0x5232 },
	{ 0xCBD2, 0x5233 },
	{ 0xCBD3, 0x5246 },
	{ 0xCBD4, 0x5231 },
	{ 0xCBD5, 0x52BC },
	{ 0xCBD6, 0x530A },
	{ 0xCBD7, 0x530B },
	{ 0xCBD8, 0x533C },
	{ 0xCBD9, 0x5392 },
	{ 0xCBDA, 0x5394 },
	{ 0xCBDB, 0x5487 },
	{ 0xCBDC, 0x547F },
	{ 0xCBDD, 0x5481 },
	{ 0xCBDE, 0x5491 },
	{ 0xCBDF, 0x5482 },
	{ 0xCBE0, 0x5488 },
	{ 0xCBE1, 0x546B },
	{ 0xCBE2, 0x547A },
	{ 0xCBE3, 0x547E },
	{ 0xCBE4, 0x5465 },
	{ 0xCBE5, 0x546C },
	{ 0xCBE6, 0x5474 },
	{ 0xCBE7, 0x5466 },
	{ 0xCBE8, 0x548D },
	{ 0xCBE9, 0x546F },
	{ 0xCBEA, 0x5461 },
	{ 0xCBEB, 0x5460 },
	{ 0xCBEC, 0x5498 },
	{ 0xCBED, 0x5463 },
	{ 0xCBEE, 0x5467 },
	{ 0xCBEF, 0x5464 },
	{ 0xCBF0, 0x56F7 },
	{ 0xCBF1, 0x56F9 },
	{ 0xCBF2, 0x576F },
	{ 0xCBF3, 0x5772 },
	{ 0xCBF4, 0x576D },
	{ 0xCBF5, 0x576B },
	{ 0xCBF6, 0x5771 },
	{ 0xCBF7, 0x5770 },
	{ 0xCBF8, 0x5776 },
	{ 0xCBF9, 0x5780 },
	{ 0xCBFA, 0x5775 },
	{ 0xCBFB, 0x577B },
	{ 0xCBFC, 0x5773 },
	{ 0xCBFD, 0x5774 },
	{ 0xCBFE, 0x5762 },
	{ 0xCC40, 0x5768 },
	{ 0xCC41, 0x577D },
	{ 0xCC42, 0x590C },
	{ 0xCC43, 0x5945 },
	{ 0xCC44, 0x59B5 },
	{ 0xCC45, 0x59BA },
	{ 0xCC46, 0x59CF },
	{ 0xCC47, 0x59CE },
	{ 0xCC48, 0x59B2 },
	{ 0xCC49, 0x59CC },
	{ 0xCC4A, 0x59C1 },
	{ 0xCC4B, 0x59B6 },
	{ 0xCC4C, 0x59BC },
	{ 0xCC4D, 0x59C3 },
	{ 0xCC4E, 0x59D6 },
	{ 0xCC4F, 0x59B1 },
	{ 0xCC50, 0x59BD },
	{ 0xCC51, 0x59C0 },
	{ 0xCC52, 0x59C8 },
	{ 0xCC53, 0x59B4 },
	{ 0xCC54, 0x59C7 },
	{ 0xCC55, 0x5B62 },
	{ 0xCC56, 0x5B65 },
	{ 0xCC57, 0x5B93 },
	{ 0xCC58, 0x5B95 },
	{ 0xCC59, 0x5C44 },
	{ 0xCC5A, 0x5C47 },
	{ 0xCC5B, 0x5CAE },
	{ 0xCC5C, 0x5CA4 },
	{ 0xCC5D, 0x5CA0 },
	{ 0xCC5E, 0x5CB5 },
	{ 0xCC5F, 0x5CAF },
	{ 0xCC60, 0x5CA8 },
	{ 0xCC61, 0x5CAC },
	{ 0xCC62, 0x5C9F },
	{ 0xCC63, 0x5CA3 },
	{ 0xCC64, 0x5CAD },
	{ 0xCC65, 0x5CA2 },
	{ 0xCC66, 0x5CAA },
	{ 0xCC67, 0x5CA7 },
	{ 0xCC68, 0x5C9D },
	{ 0xCC69, 0x5CA5 },
	{ 0xCC6A, 0x5CB6 },
	{ 0xCC6B, 0x5CB0 },
	{ 0xCC6C, 0x5CA6 },
	{ 0xCC6D, 0x5E17 },
	{ 0xCC6E, 0x5E14 },
	{ 0xCC6F, 0x5E19 },
	{ 0xCC70, 0x5F28 },
	{ 0xCC71, 0x5F22 },
	{ 0xCC72, 0x5F23 },
	{ 0xCC73, 0x5F24 },
	{ 0xCC74, 0x5F54 },
	{ 0xCC75, 0x5F82 },
	{ 0xCC76, 0x5F7E },
	{ 0xCC77, 0x5F7D },
	{ 0xCC78, 0x5FDE },
	{ 0xCC79, 0x5FE5 },
	{ 0xCC7A, 0x602D },
	{ 0xCC7B, 0x6026 },
	{ 0xCC7C, 0x6019 },
	{ 0xCC7D, 0x6032 },
	{ 0xCC7E, 0x600B },
	{ 0xCC7F, 0xFFFD },
	{ 0xCC80, 0x8E01 },
	{ 0xCC81, 0x8EB4 },
	{ 0xCC82, 0x8EB3 },
	{ 0xCC83, 0x8FA1 },
	{ 0xCC84, 0x8FA2 },
	{ 0xCC85, 0x905A },
	{ 0xCC86, 0x9061 },
	{ 0xCC87, 0x905F },
	{ 0xCC88, 0x9125 },
	{ 0xCC89, 0x917B },
	{ 0xCC8A, 0x9176 },
	{ 0xCC8B, 0x917C },
	{ 0xCC8C, 0x9289 },
	{ 0xCC8D, 0x92F6 },
	{ 0xCC8E, 0x92B1 },
	{ 0xCC8F, 0x92AD },
	{ 0xCC90, 0x9292 },
	{ 0xCC91, 0x9281 },
	{ 0xCC92, 0x9284 },
	{ 0xCC93, 0x92AE },
	{ 0xCC94, 0x9290 },
	{ 0xCC95, 0x929E },
	{ 0xCC96, 0x95A2 },
	{ 0xCC97, 0x95A7 },
	{ 0xCC98, 0x96A0 },
	{ 0xCC99, 0x969D },
	{ 0xCC9A, 0x969F },
	{ 0xCC9B, 0x96D0 },
	{ 0xCC9C, 0x96D1 },
	{ 0xCC9D, 0x9759 },
	{ 0xCC9E, 0x9764 },
	{ 0xCC9F, 0x9819 },
	{ 0xCCA0, 0x9814 },
	{ 0xCCA1, 0x6034 },
	{ 0xCCA2, 0x600A },
	{ 0xCCA3, 0x6017 },
	{ 0xCCA4, 0x6033 },
	{ 0xCCA5, 0x601A },
	{ 0xCCA6, 0x601E },
	{ 0xCCA7, 0x602C },
	{ 0xCCA8, 0x6022 },
	{ 0xCCA9, 0x600D },
	{ 0xCCAA, 0x6010 },
	{ 0xCCAB, 0x602E },
	{ 0xCCAC, 0x6013 },
	{ 0xCCAD, 0x6011 },
	{ 0xCCAE, 0x600C },
	{ 0xCCAF, 0x6009 },
	{ 0xCCB0, 0x601C },
	{ 0xCCB1, 0x6214 },
	{ 0xCCB2, 0x623D },
	{ 0xCCB3, 0x62AD },
	{ 0xCCB4, 0x62B4 },
	{ 0xCCB5, 0x62D1 },
	{ 0xCCB6, 0x62BE },
	{ 0xCCB7, 0x62AA },
	{ 0xCCB8, 0x62B6 },
	{ 0xCCB9, 0x62CA },
	{ 0xCCBA, 0x62AE },
	{ 0xCCBB, 0x62B3 },
	{ 0xCCBC, 0x62AF },
	{ 0xCCBD, 0x62BB },
	{ 0xCCBE, 0x62A9 },
	{ 0xCCBF, 0x62B0 },
	{ 0xCCC0, 0x62B8 },
	{ 0xCCC1, 0x653D },
	{ 0xCCC2, 0x65A8 },
	{ 0xCCC3, 0x65BB },
	{ 0xCCC4, 0x6609 },
	{ 0xCCC5, 0x65FC },
	{ 0xCCC6, 0x6604 },
	{ 0xCCC7, 0x6612 },
	{ 0xCCC8, 0x6608 },
	{ 0xCCC9, 0x65FB },
	{ 0xCCCA, 0x6603 },
	{ 0xCCCB, 0x660B },
	{ 0xCCCC, 0x660D },
	{ 0xCCCD, 0x6605 },
	{ 0xCCCE, 0x65FD },
	{ 0xCCCF, 0x6611 },
	{ 0xCCD0, 0x6610 },
	{ 0xCCD1, 0x66F6 },
	{ 0xCCD2, 0x670A },
	{ 0xCCD3, 0x6785 },
	{ 0xCCD4, 0x676C },
	{ 0xCCD5, 0x678E },
	{ 0xCCD6, 0x6792 },
	{ 0xCCD7, 0x6776 },
	{ 0xCCD8, 0x677B },
	{ 0xCCD9, 0x6798 },
	{ 0xCCDA, 0x6786 },
	{ 0xCCDB, 0x6784 },
	{ 0xCCDC, 0x6774 },
	{ 0xCCDD, 0x678D },
	{ 0xCCDE, 0x678C },
	{ 0xCCDF, 0x677A },
	{ 0xCCE0, 0x679F },
	{ 0xCCE1, 0x6791 },
	{ 0xCCE2, 0x6799 },
	{ 0xCCE3, 0x6783 },
	{ 0xCCE4, 0x677D },
	{ 0xCCE5, 0x6781 },
	{ 0xCCE6, 0x6778 },
	{ 0xCCE7, 0x6779 },
	{ 0xCCE8, 0x6794 },
	{ 0xCCE9, 0x6B25 },
	{ 0xCCEA, 0x6B80 },
	{ 0xCCEB, 0x6B7E },
	{ 0xCCEC, 0x6BDE },
	{ 0xCCED, 0x6C1D },
	{ 0xCCEE, 0x6C93 },
	{ 0xCCEF, 0x6CEC },
	{ 0xCCF0, 0x6CEB },
	{ 0xCCF1, 0x6CEE },
	{ 0xCCF2, 0x6CD9 },
	{ 0xCCF3, 0x6CB6 },
	{ 0xCCF4, 0x6CD4 },
	{ 0xCCF5, 0x6CAD },
	{ 0xCCF6, 0x6CE7 },
	{ 0xCCF7, 0x6CB7 },
	{ 0xCCF8, 0x6CD0 },
	{ 0xCCF9, 0x6CC2 },
	{ 0xCCFA, 0x6CBA },
	{ 0xCCFB, 0x6CC3 },
	{ 0xCCFC, 0x6CC6 },
	{ 0xCCFD, 0x6CED },
	{ 0xCCFE, 0x6CF2 },
	{ 0xCD40, 0x6CD2 },
	{ 0xCD41, 0x6CDD },
	{ 0xCD42, 0x6CB4 },
	{ 0xCD43, 0x6C8A },
	{ 0xCD44, 0x6C9D },
	{ 0xCD45, 0x6C80 },
	{ 0xCD46, 0x6CDE },
	{ 0xCD47, 0x6CC0 },
	{ 0xCD48, 0x6D30 },
	{ 0xCD49, 0x6CCD },
	{ 0xCD4A, 0x6CC7 },
	{ 0xCD4B, 0x6CB0 },
	{ 0xCD4C, 0x6CF9 },
	{ 0xCD4D, 0x6CCF },
	{ 0xCD4E, 0x6CE9 },
	{ 0xCD4F, 0x6CD1 },
	{ 0xCD50, 0x7094 },
	{ 0xCD51, 0x7098 },
	{ 0xCD52, 0x7085 },
	{ 0xCD53, 0x7093 },
	{ 0xCD54, 0x7086 },
	{ 0xCD55, 0x7084 },
	{ 0xCD56, 0x7091 },
	{ 0xCD57, 0x7096 },
	{ 0xCD58, 0x7082 },
	{ 0xCD59, 0x709A },
	{ 0xCD5A, 0x7083 },
	{ 0xCD5B, 0x726A },
	{ 0xCD5C, 0x72D6 },
	{ 0xCD5D, 0x72CB },
	{ 0xCD5E, 0x72D8 },
	{ 0xCD5F, 0x72C9 },
	{ 0xCD60, 0x72DC },
	{ 0xCD61, 0x72D2 },
	{ 0xCD62, 0x72D4 },
	{ 0xCD63, 0x72DA },
	{ 0xCD64, 0x72CC },
	{ 0xCD65, 0x72D1 },
	{ 0xCD66, 0x73A4 },
	{ 0xCD67, 0x73A1 },
	{ 0xCD68, 0x73AD },
	{ 0xCD69, 0x73A6 },
	{ 0xCD6A, 0x73A2 },
	{ 0xCD6B, 0x73A0 },
	{ 0xCD6C, 0x73AC },
	{ 0xCD6D, 0x739D },
	{ 0xCD6E, 0x74DD },
	{ 0xCD6F, 0x74E8 },
	{ 0xCD70, 0x753F },
	{ 0xCD71, 0x7540 },
	{ 0xCD72, 0x753E },
	{ 0xCD73, 0x758C },
	{ 0xCD74, 0x7598 },
	{ 0xCD75, 0x76AF },
	{ 0xCD76, 0x76F3 },
	{ 0xCD77, 0x76F1 },
	{ 0xCD78, 0x76F0 },
	{ 0xCD79, 0x76F5 },
	{ 0xCD7A, 0x77F8 },
	{ 0xCD7B, 0x77FC },
	{ 0xCD7C, 0x77F9 },
	{ 0xCD7D, 0x77FB },
	{ 0xCD7E, 0x77FA },
	{ 0xCD7F, 0xFFFD },
	{ 0xCD80, 0x9815 },
	{ 0xCD81, 0x981A },
	{ 0xCD82, 0x9906 },
	{ 0xCD83, 0x98F8 },
	{ 0xCD84, 0x9901 },
	{ 0xCD85, 0x99BE },
	{ 0xCD86, 0x99BC },
	{ 0xCD87, 0x99B7 },
	{ 0xCD88, 0x99B6 },
	{ 0xCD89, 0x99C0 },
	{ 0xCD8A, 0x99B8 },
	{ 0xCD8B, 0x99C4 },
	{ 0xCD8C, 0x99BF },
	{ 0xCD8D, 0x9ADA },
	{ 0xCD8E, 0x9AE4 },
	{ 0xCD8F, 0x9AE9 },
	{ 0xCD90, 0x9AE8 },
	{ 0xCD91, 0x9AEA },
	{ 0xCD92, 0x9AE5 },
	{ 0xCD93, 0x9B26 },
	{ 0xCD94, 0x9B40 },
	{ 0xCD95, 0x9EBD },
	{ 0xCD96, 0x510E },
	{ 0xCD97, 0x50F7 },
	{ 0xCD98, 0x50FC },
	{ 0xCD99, 0x510D },
	{ 0xCD9A, 0x5101 },
	{ 0xCD9B, 0x51DA },
	{ 0xCD9C, 0x51D9 },
	{ 0xCD9D, 0x51DB },
	{ 0xCD9E, 0x5286 },
	{ 0xCD9F, 0x528E },
	{ 0xCDA0, 0x52EE },
	{ 0xCDA1, 0x77F7 },
	{ 0xCDA2, 0x7942 },
	{ 0xCDA3, 0x793F },
	{ 0xCDA4, 0x79C5 },
	{ 0xCDA5, 0x7A78 },
	{ 0xCDA6, 0x7A7B },
	{ 0xCDA7, 0x7AFB },
	{ 0xCDA8, 0x7C75 },
	{ 0xCDA9, 0x7CFD },
	{ 0xCDAA, 0x8035 },
	{ 0xCDAB, 0x808F },
	{ 0xCDAC, 0x80AE },
	{ 0xCDAD, 0x80A3 },
	{ 0xCDAE, 0x80B8 },
	{ 0xCDAF, 0x80B5 },
	{ 0xCDB0, 0x80AD },
	{ 0xCDB1, 0x8220 },
	{ 0xCDB2, 0x82A0 },
	{ 0xCDB3, 0x82C0 },
	{ 0xCDB4, 0x82AB },
	{ 0xCDB5, 0x829A },
	{ 0xCDB6, 0x8298 },
	{ 0xCDB7, 0x829B },
	{ 0xCDB8, 0x82B5 },
	{ 0xCDB9, 0x82A7 },
	{ 0xCDBA, 0x82AE },
	{ 0xCDBB, 0x82BC },
	{ 0xCDBC, 0x829E },
	{ 0xCDBD, 0x82BA },
	{ 0xCDBE, 0x82B4 },
	{ 0xCDBF, 0x82A8 },
	{ 0xCDC0, 0x82A1 },
	{ 0xCDC1, 0x82A9 },
	{ 0xCDC2, 0x82C2 },
	{ 0xCDC3, 0x82A4 },
	{ 0xCDC4, 0x82C3 },
	{ 0xCDC5, 0x82B6 },
	{ 0xCDC6, 0x82A2 },
	{ 0xCDC7, 0x8670 },
	{ 0xCDC8, 0x866F },
	{ 0xCDC9, 0x866D },
	{ 0xCDCA, 0x866E },
	{ 0xCDCB, 0x8C56 },
	{ 0xCDCC, 0x8FD2 },
	{ 0xCDCD, 0x8FCB },
	{ 0xCDCE, 0x8FD3 },
	{ 0xCDCF, 0x8FCD },
	{ 0xCDD0, 0x8FD6 },
	{ 0xCDD1, 0x8FD5 },
	{ 0xCDD2, 0x8FD7 },
	{ 0xCDD3, 0x90B2 },
	{ 0xCDD4, 0x90B4 },
	{ 0xCDD5, 0x90AF },
	{ 0xCDD6, 0x90B3 },
	{ 0xCDD7, 0x90B0 },
	{ 0xCDD8, 0x9639 },
	{ 0xCDD9, 0x963D },
	{ 0xCDDA, 0x963C },
	{ 0xCDDB, 0x963A },
	{ 0xCDDC, 0x9643 },
	{ 0xCDDD, 0x4FCD },
	{ 0xCDDE, 0x4FC5 },
	{ 0xCDDF, 0x4FD3 },
	{ 0xCDE0, 0x4FB2 },
	{ 0xCDE1, 0x4FC9 },
	{ 0xCDE2, 0x4FCB },
	{ 0xCDE3, 0x4FC1 },
	{ 0xCDE4, 0x4FD4 },
	{ 0xCDE5, 0x4FDC },
	{ 0xCDE6, 0x4FD9 },
	{ 0xCDE7, 0x4FBB },
	{ 0xCDE8, 0x4FB3 },
	{ 0xCDE9, 0x4FDB },
	{ 0xCDEA, 0x4FC7 },
	{ 0xCDEB, 0x4FD6 },
	{ 0xCDEC, 0x4FBA },
	{ 0xCDED, 0x4FC0 },
	{ 0xCDEE, 0x4FB9 },
	{ 0xCDEF, 0x4FEC },
	{ 0xCDF0, 0x5244 },
	{ 0xCDF1, 0x5249 },
	{ 0xCDF2, 0x52C0 },
	{ 0xCDF3, 0x52C2 },
	{ 0xCDF4, 0x533D },
	{ 0xCDF5, 0x537C },
	{ 0xCDF6, 0x5397 },
	{ 0xCDF7, 0x5396 },
	{ 0xCDF8, 0x5399 },
	{ 0xCDF9, 0x5398 },
	{ 0xCDFA, 0x54BA },
	{ 0xCDFB, 0x54A1 },
	{ 0xCDFC, 0x54AD },
	{ 0xCDFD, 0x54A5 },
	{ 0xCDFE, 0x54CF },
	{ 0xCE40, 0x54C3 },
	{ 0xCE41, 0x830D },
	{ 0xCE42, 0x54B7 },
	{ 0xCE43, 0x54AE },
	{ 0xCE44, 0x54D6 },
	{ 0xCE45, 0x54B6 },
	{ 0xCE46, 0x54C5 },
	{ 0xCE47, 0x54C6 },
	{ 0xCE48, 0x54A0 },
	{ 0xCE49, 0x5470 },
	{ 0xCE4A, 0x54BC },
	{ 0xCE4B, 0x54A2 },
	{ 0xCE4C, 0x54BE },
	{ 0xCE4D, 0x5472 },
	{ 0xCE4E, 0x54DE },
	{ 0xCE4F, 0x54B0 },
	{ 0xCE50, 0x57B5 },
	{ 0xCE51, 0x579E },
	{ 0xCE52, 0x579F },
	{ 0xCE53, 0x57A4 },
	{ 0xCE54, 0x578C },
	{ 0xCE55, 0x5797 },
	{ 0xCE56, 0x579D },
	{ 0xCE57, 0x579B },
	{ 0xCE58, 0x5794 },
	{ 0xCE59, 0x5798 },
	{ 0xCE5A, 0x578F },
	{ 0xCE5B, 0x5799 },
	{ 0xCE5C, 0x57A5 },
	{ 0xCE5D, 0x579A },
	{ 0xCE5E, 0x5795 },
	{ 0xCE5F, 0x58F4 },
	{ 0xCE60, 0x590D },
	{ 0xCE61, 0x5953 },
	{ 0xCE62, 0x59E1 },
	{ 0xCE63, 0x59DE },
	{ 0xCE64, 0x59EE },
	{ 0xCE65, 0x5A00 },
	{ 0xCE66, 0x59F1 },
	{ 0xCE67, 0x59DD },
	{ 0xCE68, 0x59FA },
	{ 0xCE69, 0x59FD },
	{ 0xCE6A, 0x59FC },
	{ 0xCE6B, 0x59F6 },
	{ 0xCE6C, 0x59E4 },
	{ 0xCE6D, 0x59F2 },
	{ 0xCE6E, 0x59F7 },
	{ 0xCE6F, 0x59DB },
	{ 0xCE70, 0x59E9 },
	{ 0xCE71, 0x59F3 },
	{ 0xCE72, 0x59F5 },
	{ 0xCE73, 0x59E0 },
	{ 0xCE74, 0x59FE },
	{ 0xCE75, 0x59F4 },
	{ 0xCE76, 0x59ED },
	{ 0xCE77, 0x5BA8 },
	{ 0xCE78, 0x5C4C },
	{ 0xCE79, 0x5CD0 },
	{ 0xCE7A, 0x5CD8 },
	{ 0xCE7B, 0x5CCC },
	{ 0xCE7C, 0x5CD7 },
	{ 0xCE7D, 0x5CCB },
	{ 0xCE7E, 0x5CDB },
	{ 0xCE7F, 0xFFFD },
	{ 0xCE80, 0x5333 },
	{ 0xCE81, 0x53B1 },
	{ 0xCE82, 0x5647 },
	{ 0xCE83, 0x562D },
	{ 0xCE84, 0x5654 },
	{ 0xCE85, 0x564B },
	{ 0xCE86, 0x5652 },
	{ 0xCE87, 0x5631 },
	{ 0xCE88, 0x5644 },
	{ 0xCE89, 0x5656 },
	{ 0xCE8A, 0x5650 },
	{ 0xCE8B, 0x562B },
	{ 0xCE8C, 0x564D },
	{ 0xCE8D, 0x5637 },
	{ 0xCE8E, 0x564F },
	{ 0xCE8F, 0x58A2 },
	{ 0xCE90, 0x58B7 },
	{ 0xCE91, 0x58B2 },
	{ 0xCE92, 0x58AA },
	{ 0xCE93, 0x58B5 },
	{ 0xCE94, 0x58B0 },
	{ 0xCE95, 0x58B4 },
	{ 0xCE96, 0x58A4 },
	{ 0xCE97, 0x58A7 },
	{ 0xCE98, 0x5926 },
	{ 0xCE99, 0x5AFE },
	{ 0xCE9A, 0x5B04 },
	{ 0xCE9B, 0x5AFC },
	{ 0xCE9C, 0x5B06 },
	{ 0xCE9D, 0x5B0A },
	{ 0xCE9E, 0x5B0D },
	{ 0xCE9F, 0x5B00 },
	{ 0xCEA0, 0x5B0E },
	{ 0xCEA1, 0x5CDE },
	{ 0xCEA2, 0x5CDA },
	{ 0xCEA3, 0x5CC9 },
	{ 0xCEA4, 0x5CC7 },
	{ 0xCEA5, 0x5CCA },
	{ 0xCEA6, 0x5CD6 },
	{ 0xCEA7, 0x5CD3 },
	{ 0xCEA8, 0x5CD4 },
	{ 0xCEA9, 0x5CCF },
	{ 0xCEAA, 0x5CC8 },
	{ 0xCEAB, 0x5CC6 },
	{ 0xCEAC, 0x5CCE },
	{ 0xCEAD, 0x5CDF },
	{ 0xCEAE, 0x5CF8 },
	{ 0xCEAF, 0x5DF9 },
	{ 0xCEB0, 0x5E21 },
	{ 0xCEB1, 0x5E22 },
	{ 0xCEB2, 0x5E23 },
	{ 0xCEB3, 0x5E20 },
	{ 0xCEB4, 0x5E24 },
	{ 0xCEB5, 0x5EB0 },
	{ 0xCEB6, 0x5EA4 },
	{ 0xCEB7, 0x5EA2 },
	{ 0xCEB8, 0x5E9B },
	{ 0xCEB9, 0x5EA3 },
	{ 0xCEBA, 0x5EA5 },
	{ 0xCEBB, 0x5F07 },
	{ 0xCEBC, 0x5F2E },
	{ 0xCEBD, 0x5F56 },
	{ 0xCEBE, 0x5F86 },
	{ 0xCEBF, 0x6037 },
	{ 0xCEC0, 0x6039 },
	{ 0xCEC1, 0x6054 },
	{ 0xCEC2, 0x6072 },
	{ 0xCEC3, 0x605E },
	{ 0xCEC4, 0x6045 },
	{ 0xCEC5, 0x6053 },
	{ 0xCEC6, 0x6047 },
	{ 0xCEC7, 0x6049 },
	{ 0xCEC8, 0x605B },
	{ 0xCEC9, 0x604C },
	{ 0xCECA, 0x6040 },
	{ 0xCECB, 0x6042 },
	{ 0xCECC, 0x605F },
	{ 0xCECD, 0x6024 },
	{ 0xCECE, 0x6044 },
	{ 0xCECF, 0x6058 },
	{ 0xCED0, 0x6066 },
	{ 0xCED1, 0x606E },
	{ 0xCED2, 0x6242 },
	{ 0xCED3, 0x6243 },
	{ 0xCED4, 0x62CF },
	{ 0xCED5, 0x630D },
	{ 0xCED6, 0x630B },
	{ 0xCED7, 0x62F5 },
	{ 0xCED8, 0x630E },
	{ 0xCED9, 0x6303 },
	{ 0xCEDA, 0x62EB },
	{ 0xCEDB, 0x62F9 },
	{ 0xCEDC, 0x630F },
	{ 0xCEDD, 0x630C },
	{ 0xCEDE, 0x62F8 },
	{ 0xCEDF, 0x62F6 },
	{ 0xCEE0, 0x6300 },
	{ 0xCEE1, 0x6313 },
	{ 0xCEE2, 0x6314 },
	{ 0xCEE3, 0x62FA },
	{ 0xCEE4, 0x6315 },
	{ 0xCEE5, 0x62FB },
	{ 0xCEE6, 0x62F0 },
	{ 0xCEE7, 0x6541 },
	{ 0xCEE8, 0x6543 },
	{ 0xCEE9, 0x65AA },
	{ 0xCEEA, 0x65BF },
	{ 0xCEEB, 0x6636 },
	{ 0xCEEC, 0x6621 },
	{ 0xCEED, 0x6632 },
	{ 0xCEEE, 0x6635 },
	{ 0xCEEF, 0x661C },
	{ 0xCEF0, 0x6626 },
	{ 0xCEF1, 0x6622 },
	{ 0xCEF2, 0x6633 },
	{ 0xCEF3, 0x662B },
	{ 0xCEF4, 0x663A },
	{ 0xCEF5, 0x661D },
	{ 0xCEF6, 0x6634 },
	{ 0xCEF7, 0x6639 },
	{ 0xCEF8, 0x662E },
	{ 0xCEF9, 0x670F },
	{ 0xCEFA, 0x6710 },
	{ 0xCEFB, 0x67C1 },
	{ 0xCEFC, 0x67F2 },
	{ 0xCEFD, 0x67C8 },
	{ 0xCEFE, 0x67BA },
	{ 0xCF40, 0x67DC },
	{ 0xCF41, 0x67BB },
	{ 0xCF42, 0x67F8 },
	{ 0xCF43, 0x67D8 },
	{ 0xCF44, 0x67C0 },
	{ 0xCF45, 0x67B7 },
	{ 0xCF46, 0x67C5 },
	{ 0xCF47, 0x67EB },
	{ 0xCF48, 0x67E4 },
	{ 0xCF49, 0x67DF },
	{ 0xCF4A, 0x67B5 },
	{ 0xCF4B, 0x67CD },
	{ 0xCF4C, 0x67B3 },
	{ 0xCF4D, 0x67F7 },
	{ 0xCF4E, 0x67F6 },
	{ 0xCF4F, 0x67EE },
	{ 0xCF50, 0x67E3 },
	{ 0xCF51, 0x67C2 },
	{ 0xCF52, 0x67B9 },
	{ 0xCF53, 0x67CE },
	{ 0xCF54, 0x67E7 },
	{ 0xCF55, 0x67F0 },
	{ 0xCF56, 0x67B2 },
	{ 0xCF57, 0x67FC },
	{ 0xCF58, 0x67C6 },
	{ 0xCF59, 0x67ED },
	{ 0xCF5A, 0x67CC },
	{ 0xCF5B, 0x67AE },
	{ 0xCF5C, 0x67E6 },
	{ 0xCF5D, 0x67DB },
	{ 0xCF5E, 0x67FA },
	{ 0xCF5F, 0x67C9 },
	{ 0xCF60, 0x67CA },
	{ 0xCF61, 0x67C3 },
	{ 0xCF62, 0x67EA },
	{ 0xCF63, 0x67CB },
	{ 0xCF64, 0x6B28 },
	{ 0xCF65, 0x6B82 },
	{ 0xCF66, 0x6B84 },
	{ 0xCF67, 0x6BB6 },
	{ 0xCF68, 0x6BD6 },
	{ 0xCF69, 0x6BD8 },
	{ 0xCF6A, 0x6BE0 },
	{ 0xCF6B, 0x6C20 },
	{ 0xCF6C, 0x6C21 },
	{ 0xCF6D, 0x6D28 },
	{ 0xCF6E, 0x6D34 },
	{ 0xCF6F, 0x6D2D },
	{ 0xCF70, 0x6D1F },
	{ 0xCF71, 0x6D3C },
	{ 0xCF72, 0x6D3F },
	{ 0xCF73, 0x6D12 },
	{ 0xCF74, 0x6D0A },
	{ 0xCF75, 0x6CDA },
	{ 0xCF76, 0x6D33 },
	{ 0xCF77, 0x6D04 },
	{ 0xCF78, 0x6D19 },
	{ 0xCF79, 0x6D3A },
	{ 0xCF7A, 0x6D1A },
	{ 0xCF7B, 0x6D11 },
	{ 0xCF7C, 0x6D00 },
	{ 0xCF7D, 0x6D1D },
	{ 0xCF7E, 0x6D42 },
	{ 0xCF7F, 0xFFFD },
	{ 0xCF80, 0x5D91 },
	{ 0xCF81, 0x5D8F },
	{ 0xCF82, 0x5D90 },
	{ 0xCF83, 0x5D98 },
	{ 0xCF84, 0x5DA4 },
	{ 0xCF85, 0x5D9B },
	{ 0xCF86, 0x5DA3 },
	{ 0xCF87, 0x5D96 },
	{ 0xCF88, 0x5DE4 },
	{ 0xCF89, 0x5E5A },
	{ 0xCF8A, 0x5E5E },
	{ 0xCF8B, 0x5FB8 },
	{ 0xCF8C, 0x6157 },
	{ 0xCF8D, 0x615C },
	{ 0xCF8E, 0x61A6 },
	{ 0xCF8F, 0x6195 },
	{ 0xCF90, 0x6188 },
	{ 0xCF91, 0x61A3 },
	{ 0xCF92, 0x618F },
	{ 0xCF93, 0x6164 },
	{ 0xCF94, 0x6159 },
	{ 0xCF95, 0x6178 },
	{ 0xCF96, 0x6185 },
	{ 0xCF97, 0x6187 },
	{ 0xCF98, 0x619E },
	{ 0xCF99, 0x6198 },
	{ 0xCF9A, 0x619C },
	{ 0xCF9B, 0x622F },
	{ 0xCF9C, 0x6480 },
	{ 0xCF9D, 0x649B },
	{ 0xCF9E, 0x648E },
	{ 0xCF9F, 0x648D },
	{ 0xCFA0, 0x6494 },
	{ 0xCFA1, 0x6D01 },
	{ 0xCFA2, 0x6D18 },
	{ 0xCFA3, 0x6D37 },
	{ 0xCFA4, 0x6D03 },
	{ 0xCFA5, 0x6D0F },
	{ 0xCFA6, 0x6D40 },
	{ 0xCFA7, 0x6D07 },
	{ 0xCFA8, 0x6D20 },
	{ 0xCFA9, 0x6D2C },
	{ 0xCFAA, 0x6D08 },
	{ 0xCFAB, 0x6D22 },
	{ 0xCFAC, 0x6D09 },
	{ 0xCFAD, 0x6D10 },
	{ 0xCFAE, 0x70B7 },
	{ 0xCFAF, 0x709F },
	{ 0xCFB0, 0x70BE },
	{ 0xCFB1, 0x70B1 },
	{ 0xCFB2, 0x70B0 },
	{ 0xCFB3, 0x70A1 },
	{ 0xCFB4, 0x70B4 },
	{ 0xCFB5, 0x70B5 },
	{ 0xCFB6, 0x70A9 },
	{ 0xCFB7, 0x7241 },
	{ 0xCFB8, 0x7249 },
	{ 0xCFB9, 0x724A },
	{ 0xCFBA, 0x726C },
	{ 0xCFBB, 0x7270 },
	{ 0xCFBC, 0x7273 },
	{ 0xCFBD, 0x726E },
	{ 0xCFBE, 0x72CA },
	{ 0xCFBF, 0x72E4 },
	{ 0xCFC0, 0x72E8 },
	{ 0xCFC1, 0x72EB },
	{ 0xCFC2, 0x72DF },
	{ 0xCFC3, 0x72EA },
	{ 0xCFC4, 0x72E6 },
	{ 0xCFC5, 0x72E3 },
	{ 0xCFC6, 0x7385 },
	{ 0xCFC7, 0x73CC },
	{ 0xCFC8, 0x73C2 },
	{ 0xCFC9, 0x73C8 },
	{ 0xCFCA, 0x73C5 },
	{ 0xCFCB, 0x73B9 },
	{ 0xCFCC, 0x73B6 },
	{ 0xCFCD, 0x73B5 },
	{ 0xCFCE, 0x73B4 },
	{ 0xCFCF, 0x73EB },
	{ 0xCFD0, 0x73BF },
	{ 0xCFD1, 0x73C7 },
	{ 0xCFD2, 0x73BE },
	{ 0xCFD3, 0x73C3 },
	{ 0xCFD4, 0x73C6 },
	{ 0xCFD5, 0x73B8 },
	{ 0xCFD6, 0x73CB },
	{ 0xCFD7, 0x74EC },
	{ 0xCFD8, 0x74EE },
	{ 0xCFD9, 0x752E },
	{ 0xCFDA, 0x7547 },
	{ 0xCFDB, 0x7548 },
	{ 0xCFDC, 0x75A7 },
	{ 0xCFDD, 0x75AA },
	{ 0xCFDE, 0x7679 },
	{ 0xCFDF, 0x76C4 },
	{ 0xCFE0, 0x7708 },
	{ 0xCFE1, 0x7703 },
	{ 0xCFE2, 0x7704 },
	{ 0xCFE3, 0x7705 },
	{ 0xCFE4, 0x770A },
	{ 0xCFE5, 0x76F7 },
	{ 0xCFE6, 0x76FB },
	{ 0xCFE7, 0x76FA },
	{ 0xCFE8, 0x77E7 },
	{ 0xCFE9, 0x77E8 },
	{ 0xCFEA, 0x7806 },
	{ 0xCFEB, 0x7811 },
	{ 0xCFEC, 0x7812 },
	{ 0xCFED, 0x7805 },
	{ 0xCFEE, 0x7810 },
	{ 0xCFEF, 0x780F },
	{ 0xCFF0, 0x780E },
	{ 0xCFF1, 0x7809 },
	{ 0xCFF2, 0x7803 },
	{ 0xCFF3, 0x7813 },
	{ 0xCFF4, 0x794A },
	{ 0xCFF5, 0x794C },
	{ 0xCFF6, 0x794B },
	{ 0xCFF7, 0x7945 },
	{ 0xCFF8, 0x7944 },
	{ 0xCFF9, 0x79D5 },
	{ 0xCFFA, 0x79CD },
	{ 0xCFFB, 0x79CF },
	{ 0xCFFC, 0x79D6 },
	{ 0xCFFD, 0x79CE },
	{ 0xCFFE, 0x7A80 },
	{ 0xD040, 0x7A7E },
	{ 0xD041, 0x7AD1 },
	{ 0xD042, 0x7B00 },
	{ 0xD043, 0x7B01 },
	{ 0xD044, 0x7C7A },
	{ 0xD045, 0x7C78 },
	{ 0xD046, 0x7C79 },
	{ 0xD047, 0x7C7F },
	{ 0xD048, 0x7C80 },
	{ 0xD049, 0x7C81 },
	{ 0xD04A, 0x7D03 },
	{ 0xD04B, 0x7D08 },
	{ 0xD04C, 0x7D01 },
	{ 0xD04D, 0x7F58 },
	{ 0xD04E, 0x7F91 },
	{ 0xD04F, 0x7F8D },
	{ 0xD050, 0x7FBE },
	{ 0xD051, 0x8007 },
	{ 0xD052, 0x800E },
	{ 0xD053, 0x800F },
	{ 0xD054, 0x8014 },
	{ 0xD055, 0x8037 },
	{ 0xD056, 0x80D8 },
	{ 0xD057, 0x80C7 },
	{ 0xD058, 0x80E0 },
	{ 0xD059, 0x80D1 },
	{ 0xD05A, 0x80C8 },
	{ 0xD05B, 0x80C2 },
	{ 0xD05C, 0x80D0 },
	{ 0xD05D, 0x80C5 },
	{ 0xD05E, 0x80E3 },
	{ 0xD05F, 0x80D9 },
	{ 0xD060, 0x80DC },
	{ 0xD061, 0x80CA },
	{ 0xD062, 0x80D5 },
	{ 0xD063, 0x80C9 },
	{ 0xD064, 0x80CF },
	{ 0xD065, 0x80D7 },
	{ 0xD066, 0x80E6 },
	{ 0xD067, 0x80CD },
	{ 0xD068, 0x81FF },
	{ 0xD069, 0x8221 },
	{ 0xD06A, 0x8294 },
	{ 0xD06B, 0x82D9 },
	{ 0xD06C, 0x82FE },
	{ 0xD06D, 0x82F9 },
	{ 0xD06E, 0x8307 },
	{ 0xD06F, 0x82E8 },
	{ 0xD070, 0x8300 },
	{ 0xD071, 0x82D5 },
	{ 0xD072, 0x833A },
	{ 0xD073, 0x82EB },
	{ 0xD074, 0x82D6 },
	{ 0xD075, 0x82F4 },
	{ 0xD076, 0x82EC },
	{ 0xD077, 0x82E1 },
	{ 0xD078, 0x82F2 },
	{ 0xD079, 0x82F5 },
	{ 0xD07A, 0x830C },
	{ 0xD07B, 0x82FB },
	{ 0xD07C, 0x82F6 },
	{ 0xD07D, 0x82F0 },
	{ 0xD07E, 0x82EA },
	{ 0xD07F, 0xFFFD },
	{ 0xD080, 0x64C6 },
	{ 0xD081, 0x64A8 },
	{ 0xD082, 0x6483 },
	{ 0xD083, 0x64B9 },
	{ 0xD084, 0x6486 },
	{ 0xD085, 0x64B4 },
	{ 0xD086, 0x64AF },
	{ 0xD087, 0x6491 },
	{ 0xD088, 0x64AA },
	{ 0xD089, 0x64A1 },
	{ 0xD08A, 0x64A7 },
	{ 0xD08B, 0x66B6 },
	{ 0xD08C, 0x66B3 },
	{ 0xD08D, 0x66BC },
	{ 0xD08E, 0x66AC },
	{ 0xD08F, 0x66AD },
	{ 0xD090, 0x6A0E },
	{ 0xD091, 0x6A1C },
	{ 0xD092, 0x6A1A },
	{ 0xD093, 0x6A0B },
	{ 0xD094, 0x69EF },
	{ 0xD095, 0x6A0C },
	{ 0xD096, 0x69F0 },
	{ 0xD097, 0x6A22 },
	{ 0xD098, 0x69D8 },
	{ 0xD099, 0x6A12 },
	{ 0xD09A, 0x69FA },
	{ 0xD09B, 0x6A2A },
	{ 0xD09C, 0x6A10 },
	{ 0xD09D, 0x6A29 },
	{ 0xD09E, 0x69F9 },
	{ 0xD09F, 0x69EA },
	{ 0xD0A0, 0x6A2C },
	{ 0xD0A1, 0x82E4 },
	{ 0xD0A2, 0x82E0 },
	{ 0xD0A3, 0x82FA },
	{ 0xD0A4, 0x82F3 },
	{ 0xD0A5, 0x82ED },
	{ 0xD0A6, 0x8677 },
	{ 0xD0A7, 0x8674 },
	{ 0xD0A8, 0x867C },
	{ 0xD0A9, 0x8673 },
	{ 0xD0AA, 0x8841 },
	{ 0xD0AB, 0x884E },
	{ 0xD0AC, 0x8867 },
	{ 0xD0AD, 0x886A },
	{ 0xD0AE, 0x8869 },
	{ 0xD0AF, 0x89D3 },
	{ 0xD0B0, 0x8A04 },
	{ 0xD0B1, 0x8A07 },
	{ 0xD0B2, 0x8D72 },
	{ 0xD0B3, 0x8FE3 },
	{ 0xD0B4, 0x8FE1 },
	{ 0xD0B5, 0x8FEE },
	{ 0xD0B6, 0x8FE0 },
	{ 0xD0B7, 0x90F1 },
	{ 0xD0B8, 0x90BD },
	{ 0xD0B9, 0x90BF },
	{ 0xD0BA, 0x90D5 },
	{ 0xD0BB, 0x90C5 },
	{ 0xD0BC, 0x90BE },
	{ 0xD0BD, 0x90C7 },
	{ 0xD0BE, 0x90CB },
	{ 0xD0BF, 0x90C8 },
	{ 0xD0C0, 0x91D4 },
	{ 0xD0C1, 0x91D3 },
	{ 0xD0C2, 0x9654 },
	{ 0xD0C3, 0x964F },
	{ 0xD0C4, 0x9651 },
	{ 0xD0C5, 0x9653 },
	{ 0xD0C6, 0x964A },
	{ 0xD0C7, 0x964E },
	{ 0xD0C8, 0x501E },
	{ 0xD0C9, 0x5005 },
	{ 0xD0CA, 0x5007 },
	{ 0xD0CB, 0x5013 },
	{ 0xD0CC, 0x5022 },
	{ 0xD0CD, 0x5030 },
	{ 0xD0CE, 0x501B },
	{ 0xD0CF, 0x4FF5 },
	{ 0xD0D0, 0x4FF4 },
	{ 0xD0D1, 0x5033 },
	{ 0xD0D2, 0x5037 },
	{ 0xD0D3, 0x502C },
	{ 0xD0D4, 0x4FF6 },
	{ 0xD0D5, 0x4FF7 },
	{ 0xD0D6, 0x5017 },
	{ 0xD0D7, 0x501C },
	{ 0xD0D8, 0x5020 },
	{ 0xD0D9, 0x5027 },
	{ 0xD0DA, 0x5035 },
	{ 0xD0DB, 0x502F },
	{ 0xD0DC, 0x5031 },
	{ 0xD0DD, 0x500E },
	{ 0xD0DE, 0x515A },
	{ 0xD0DF, 0x5194 },
	{ 0xD0E0, 0x5193 },
	{ 0xD0E1, 0x51CA },
	{ 0xD0E2, 0x51C4 },
	{ 0xD0E3, 0x51C5 },
	{ 0xD0E4, 0x51C8 },
	{ 0xD0E5, 0x51CE },
	{ 0xD0E6, 0x5261 },
	{ 0xD0E7, 0x525A },
	{ 0xD0E8, 0x5252 },
	{ 0xD0E9, 0x525E },
	{ 0xD0EA, 0x525F },
	{ 0xD0EB, 0x5255 },
	{ 0xD0EC, 0x5262 },
	{ 0xD0ED, 0x52CD },
	{ 0xD0EE, 0x530E },
	{ 0xD0EF, 0x539E },
	{ 0xD0F0, 0x5526 },
	{ 0xD0F1, 0x54E2 },
	{ 0xD0F2, 0x5517 },
	{ 0xD0F3, 0x5512 },
	{ 0xD0F4, 0x54E7 },
	{ 0xD0F5, 0x54F3 },
	{ 0xD0F6, 0x54E4 },
	{ 0xD0F7, 0x551A },
	{ 0xD0F8, 0x54FF },
	{ 0xD0F9, 0x5504 },
	{ 0xD0FA, 0x5508 },
	{ 0xD0FB, 0x54EB },
	{ 0xD0FC, 0x5511 },
	{ 0xD0FD, 0x5505 },
	{ 0xD0FE, 0x54F1 },
	{ 0xD140, 0x550A },
	{ 0xD141, 0x54FB },
	{ 0xD142, 0x54F7 },
	{ 0xD143, 0x54F8 },
	{ 0xD144, 0x54E0 },
	{ 0xD145, 0x550E },
	{ 0xD146, 0x5503 },
	{ 0xD147, 0x550B },
	{ 0xD148, 0x5701 },
	{ 0xD149, 0x5702 },
	{ 0xD14A, 0x57CC },
	{ 0xD14B, 0x5832 },
	{ 0xD14C, 0x57D5 },
	{ 0xD14D, 0x57D2 },
	{ 0xD14E, 0x57BA },
	{ 0xD14F, 0x57C6 },
	{ 0xD150, 0x57BD },
	{ 0xD151, 0x57BC },
	{ 0xD152, 0x57B8 },
	{ 0xD153, 0x57B6 },
	{ 0xD154, 0x57BF },
	{ 0xD155, 0x57C7 },
	{ 0xD156, 0x57D0 },
	{ 0xD157, 0x57B9 },
	{ 0xD158, 0x57C1 },
	{ 0xD159, 0x590E },
	{ 0xD15A, 0x594A },
	{ 0xD15B, 0x5A19 },
	{ 0xD15C, 0x5A16 },
	{ 0xD15D, 0x5A2D },
	{ 0xD15E, 0x5A2E },
	{ 0xD15F, 0x5A15 },
	{ 0xD160, 0x5A0F },
	{ 0xD161, 0x5A17 },
	{ 0xD162, 0x5A0A },
	{ 0xD163, 0x5A1E },
	{ 0xD164, 0x5A33 },
	{ 0xD165, 0x5B6C },
	{ 0xD166, 0x5BA7 },
	{ 0xD167, 0x5BAD },
	{ 0xD168, 0x5BAC },
	{ 0xD169, 0x5C03 },
	{ 0xD16A, 0x5C56 },
	{ 0xD16B, 0x5C54 },
	{ 0xD16C, 0x5CEC },
	{ 0xD16D, 0x5CFF },
	{ 0xD16E, 0x5CEE },
	{ 0xD16F, 0x5CF1 },
	{ 0xD170, 0x5CF7 },
	{ 0xD171, 0x5D00 },
	{ 0xD172, 0x5CF9 },
	{ 0xD173, 0x5E29 },
	{ 0xD174, 0x5E28 },
	{ 0xD175, 0x5EA8 },
	{ 0xD176, 0x5EAE },
	{ 0xD177, 0x5EAA },
	{ 0xD178, 0x5EAC },
	{ 0xD179, 0x5F33 },
	{ 0xD17A, 0x5F30 },
	{ 0xD17B, 0x5F67 },
	{ 0xD17C, 0x605D },
	{ 0xD17D, 0x605A },
	{ 0xD17E, 0x6067 },
	{ 0xD17F, 0xFFFD },
	{ 0xD180, 0x6A24 },
	{ 0xD181, 0x69E9 },
	{ 0xD182, 0x6B52 },
	{ 0xD183, 0x6B4F },
	{ 0xD184, 0x6B53 },
	{ 0xD185, 0x6F10 },
	{ 0xD186, 0x6F65 },
	{ 0xD187, 0x6F75 },
	{ 0xD188, 0x6FD0 },
	{ 0xD189, 0x6F5C },
	{ 0xD18A, 0x6F3D },
	{ 0xD18B, 0x6F71 },
	{ 0xD18C, 0x6F91 },
	{ 0xD18D, 0x6F0B },
	{ 0xD18E, 0x6F79 },
	{ 0xD18F, 0x6F81 },
	{ 0xD190, 0x6F8F },
	{ 0xD191, 0x6F59 },
	{ 0xD192, 0x6F74 },
	{ 0xD193, 0x71AE },
	{ 0xD194, 0x71A3 },
	{ 0xD195, 0x71AD },
	{ 0xD196, 0x71AB },
	{ 0xD197, 0x71A6 },
	{ 0xD198, 0x71A2 },
	{ 0xD199, 0x52F2 },
	{ 0xD19A, 0x7257 },
	{ 0xD19B, 0x7255 },
	{ 0xD19C, 0x7299 },
	{ 0xD19D, 0x734B },
	{ 0xD19E, 0x747A },
	{ 0xD19F, 0x748C },
	{ 0xD1A0, 0x7484 },
	{ 0xD1A1, 0x6041 },
	{ 0xD1A2, 0x60A2 },
	{ 0xD1A3, 0x6088 },
	{ 0xD1A4, 0x6080 },
	{ 0xD1A5, 0x6092 },
	{ 0xD1A6, 0x6081 },
	{ 0xD1A7, 0x609D },
	{ 0xD1A8, 0x6083 },
	{ 0xD1A9, 0x6095 },
	{ 0xD1AA, 0x609B },
	{ 0xD1AB, 0x6097 },
	{ 0xD1AC, 0x6087 },
	{ 0xD1AD, 0x609C },
	{ 0xD1AE, 0x608E },
	{ 0xD1AF, 0x6219 },
	{ 0xD1B0, 0x6246 },
	{ 0xD1B1, 0x62F2 },
	{ 0xD1B2, 0x6310 },
	{ 0xD1B3, 0x6356 },
	{ 0xD1B4, 0x632C },
	{ 0xD1B5, 0x6344 },
	{ 0xD1B6, 0x6345 },
	{ 0xD1B7, 0x6336 },
	{ 0xD1B8, 0x6343 },
	{ 0xD1B9, 0x63E4 },
	{ 0xD1BA, 0x6339 },
	{ 0xD1BB, 0x634B },
	{ 0xD1BC, 0x634A },
	{ 0xD1BD, 0x633C },
	{ 0xD1BE, 0x6329 },
	{ 0xD1BF, 0x6341 },
	{ 0xD1C0, 0x6334 },
	{ 0xD1C1, 0x6358 },
	{ 0xD1C2, 0x6354 },
	{ 0xD1C3, 0x6359 },
	{ 0xD1C4, 0x632D },
	{ 0xD1C5, 0x6347 },
	{ 0xD1C6, 0x6333 },
	{ 0xD1C7, 0x635A },
	{ 0xD1C8, 0x6351 },
	{ 0xD1C9, 0x6338 },
	{ 0xD1CA, 0x6357 },
	{ 0xD1CB, 0x6340 },
	{ 0xD1CC, 0x6348 },
	{ 0xD1CD, 0x654A },
	{ 0xD1CE, 0x6546 },
	{ 0xD1CF, 0x65C6 },
	{ 0xD1D0, 0x65C3 },
	{ 0xD1D1, 0x65C4 },
	{ 0xD1D2, 0x65C2 },
	{ 0xD1D3, 0x664A },
	{ 0xD1D4, 0x665F },
	{ 0xD1D5, 0x6647 },
	{ 0xD1D6, 0x6651 },
	{ 0xD1D7, 0x6712 },
	{ 0xD1D8, 0x6713 },
	{ 0xD1D9, 0x681F },
	{ 0xD1DA, 0x681A },
	{ 0xD1DB, 0x6849 },
	{ 0xD1DC, 0x6832 },
	{ 0xD1DD, 0x6833 },
	{ 0xD1DE, 0x683B },
	{ 0xD1DF, 0x684B },
	{ 0xD1E0, 0x684F },
	{ 0xD1E1, 0x6816 },
	{ 0xD1E2, 0x6831 },
	{ 0xD1E3, 0x681C },
	{ 0xD1E4, 0x6835 },
	{ 0xD1E5, 0x682B },
	{ 0xD1E6, 0x682D },
	{ 0xD1E7, 0x682F },
	{ 0xD1E8, 0x684E },
	{ 0xD1E9, 0x6844 },
	{ 0xD1EA, 0x6834 },
	{ 0xD1EB, 0x681D },
	{ 0xD1EC, 0x6812 },
	{ 0xD1ED, 0x6814 },
	{ 0xD1EE, 0x6826 },
	{ 0xD1EF, 0x6828 },
	{ 0xD1F0, 0x682E },
	{ 0xD1F1, 0x684D },
	{ 0xD1F2, 0x683A },
	{ 0xD1F3, 0x6825 },
	{ 0xD1F4, 0x6820 },
	{ 0xD1F5, 0x6B2C },
	{ 0xD1F6, 0x6B2F },
	{ 0xD1F7, 0x6B2D },
	{ 0xD1F8, 0x6B31 },
	{ 0xD1F9, 0x6B34 },
	{ 0xD1FA, 0x6B6D },
	{ 0xD1FB, 0x8082 },
	{ 0xD1FC, 0x6B88 },
	{ 0xD1FD, 0x6BE6 },
	{ 0xD1FE, 0x6BE4 },
	{ 0xD240, 0x6BE8 },
	{ 0xD241, 0x6BE3 },
	{ 0xD242, 0x6BE2 },
	{ 0xD243, 0x6BE7 },
	{ 0xD244, 0x6C25 },
	{ 0xD245, 0x6D7A },
	{ 0xD246, 0x6D63 },
	{ 0xD247, 0x6D64 },
	{ 0xD248, 0x6D76 },
	{ 0xD249, 0x6D0D },
	{ 0xD24A, 0x6D61 },
	{ 0xD24B, 0x6D92 },
	{ 0xD24C, 0x6D58 },
	{ 0xD24D, 0x6D62 },
	{ 0xD24E, 0x6D6D },
	{ 0xD24F, 0x6D6F },
	{ 0xD250, 0x6D91 },
	{ 0xD251, 0x6D8D },
	{ 0xD252, 0x6DEF },
	{ 0xD253, 0x6D7F },
	{ 0xD254, 0x6D86 },
	{ 0xD255, 0x6D5E },
	{ 0xD256, 0x6D67 },
	{ 0xD257, 0x6D60 },
	{ 0xD258, 0x6D97 },
	{ 0xD259, 0x6D70 },
	{ 0xD25A, 0x6D7C },
	{ 0xD25B, 0x6D5F },
	{ 0xD25C, 0x6D82 },
	{ 0xD25D, 0x6D98 },
	{ 0xD25E, 0x6D2F },
	{ 0xD25F, 0x6D68 },
	{ 0xD260, 0x6D8B },
	{ 0xD261, 0x6D7E },
	{ 0xD262, 0x6D80 },
	{ 0xD263, 0x6D84 },
	{ 0xD264, 0x6D16 },
	{ 0xD265, 0x6D83 },
	{ 0xD266, 0x6D7B },
	{ 0xD267, 0x6D7D },
	{ 0xD268, 0x6D75 },
	{ 0xD269, 0x6D90 },
	{ 0xD26A, 0x70DC },
	{ 0xD26B, 0x70D3 },
	{ 0xD26C, 0x70D1 },
	{ 0xD26D, 0x70DD },
	{ 0xD26E, 0x70CB },
	{ 0xD26F, 0x7F39 },
	{ 0xD270, 0x70E2 },
	{ 0xD271, 0x70D7 },
	{ 0xD272, 0x70D2 },
	{ 0xD273, 0x70DE },
	{ 0xD274, 0x70E0 },
	{ 0xD275, 0x70D4 },
	{ 0xD276, 0x70CD },
	{ 0xD277, 0x70C5 },
	{ 0xD278, 0x70C6 },
	{ 0xD279, 0x70C7 },
	{ 0xD27A, 0x70DA },
	{ 0xD27B, 0x70CE },
	{ 0xD27C, 0x70E1 },
	{ 0xD27D, 0x7242 },
	{ 0xD27E, 0x7278 },
	{ 0xD27F, 0xFFFD },
	{ 0xD280, 0x7482 },
	{ 0xD281, 0x7493 },
	{ 0xD282, 0x747B },
	{ 0xD283, 0x7509 },
	{ 0xD284, 0x778A },
	{ 0xD285, 0x7790 },
	{ 0xD286, 0x78C6 },
	{ 0xD287, 0x78D3 },
	{ 0xD288, 0x78C0 },
	{ 0xD289, 0x78D2 },
	{ 0xD28A, 0x78C7 },
	{ 0xD28B, 0x78C2 },
	{ 0xD28C, 0x799F },
	{ 0xD28D, 0x799D },
	{ 0xD28E, 0x799E },
	{ 0xD28F, 0x7A41 },
	{ 0xD290, 0x7A38 },
	{ 0xD291, 0x7A3A },
	{ 0xD292, 0x7A42 },
	{ 0xD293, 0x7A3E },
	{ 0xD294, 0x7AB0 },
	{ 0xD295, 0x7BAE },
	{ 0xD296, 0x7BB3 },
	{ 0xD297, 0x7BBF },
	{ 0xD298, 0x7BCD },
	{ 0xD299, 0x7BB2 },
	{ 0xD29A, 0x7CC4 },
	{ 0xD29B, 0x7CCD },
	{ 0xD29C, 0x7CC2 },
	{ 0xD29D, 0x7CC6 },
	{ 0xD29E, 0x7CC3 },
	{ 0xD29F, 0x7CC9 },
	{ 0xD2A0, 0x7CC7 },
	{ 0xD2A1, 0x7277 },
	{ 0xD2A2, 0x7276 },
	{ 0xD2A3, 0x7300 },
	{ 0xD2A4, 0x72FA },
	{ 0xD2A5, 0x72F4 },
	{ 0xD2A6, 0x72FE },
	{ 0xD2A7, 0x72F6 },
	{ 0xD2A8, 0x72F3 },
	{ 0xD2A9, 0x72FB },
	{ 0xD2AA, 0x7301 },
	{ 0xD2AB, 0x73D3 },
	{ 0xD2AC, 0x73D9 },
	{ 0xD2AD, 0x73E5 },
	{ 0xD2AE, 0x73D6 },
	{ 0xD2AF, 0x73BC },
	{ 0xD2B0, 0x73E7 },
	{ 0xD2B1, 0x73E3 },
	{ 0xD2B2, 0x73E9 },
	{ 0xD2B3, 0x73DC },
	{ 0xD2B4, 0x73D2 },
	{ 0xD2B5, 0x73DB },
	{ 0xD2B6, 0x73D4 },
	{ 0xD2B7, 0x73DD },
	{ 0xD2B8, 0x73DA },
	{ 0xD2B9, 0x73D7 },
	{ 0xD2BA, 0x73D8 },
	{ 0xD2BB, 0x73E8 },
	{ 0xD2BC, 0x74DE },
	{ 0xD2BD, 0x74DF },
	{ 0xD2BE, 0x74F4 },
	{ 0xD2BF, 0x74F5 },
	{ 0xD2C0, 0x7521 },
	{ 0xD2C1, 0x755B },
	{ 0xD2C2, 0x755F },
	{ 0xD2C3, 0x75B0 },
	{ 0xD2C4, 0x75C1 },
	{ 0xD2C5, 0x75BB },
	{ 0xD2C6, 0x75C4 },
	{ 0xD2C7, 0x75C0 },
	{ 0xD2C8, 0x75BF },
	{ 0xD2C9, 0x75B6 },
	{ 0xD2CA, 0x75BA },
	{ 0xD2CB, 0x768A },
	{ 0xD2CC, 0x76C9 },
	{ 0xD2CD, 0x771D },
	{ 0xD2CE, 0x771B },
	{ 0xD2CF, 0x7710 },
	{ 0xD2D0, 0x7713 },
	{ 0xD2D1, 0x7712 },
	{ 0xD2D2, 0x7723 },
	{ 0xD2D3, 0x7711 },
	{ 0xD2D4, 0x7715 },
	{ 0xD2D5, 0x7719 },
	{ 0xD2D6, 0x771A },
	{ 0xD2D7, 0x7722 },
	{ 0xD2D8, 0x7727 },
	{ 0xD2D9, 0x7823 },
	{ 0xD2DA, 0x782C },
	{ 0xD2DB, 0x7822 },
	{ 0xD2DC, 0x7835 },
	{ 0xD2DD, 0x782F },
	{ 0xD2DE, 0x7828 },
	{ 0xD2DF, 0x782E },
	{ 0xD2E0, 0x782B },
	{ 0xD2E1, 0x7821 },
	{ 0xD2E2, 0x7829 },
	{ 0xD2E3, 0x7833 },
	{ 0xD2E4, 0x782A },
	{ 0xD2E5, 0x7831 },
	{ 0xD2E6, 0x7954 },
	{ 0xD2E7, 0x795B },
	{ 0xD2E8, 0x794F },
	{ 0xD2E9, 0x795C },
	{ 0xD2EA, 0x7953 },
	{ 0xD2EB, 0x7952 },
	{ 0xD2EC, 0x7951 },
	{ 0xD2ED, 0x79EB },
	{ 0xD2EE, 0x79EC },
	{ 0xD2EF, 0x79E0 },
	{ 0xD2F0, 0x79EE },
	{ 0xD2F1, 0x79ED },
	{ 0xD2F2, 0x79EA },
	{ 0xD2F3, 0x79DC },
	{ 0xD2F4, 0x79DE },
	{ 0xD2F5, 0x79DD },
	{ 0xD2F6, 0x7A86 },
	{ 0xD2F7, 0x7A89 },
	{ 0xD2F8, 0x7A85 },
	{ 0xD2F9, 0x7A8B },
	{ 0xD2FA, 0x7A8C },
	{ 0xD2FB, 0x7A8A },
	{ 0xD2FC, 0x7A87 },
	{ 0xD2FD, 0x7AD8 },
	{ 0xD2FE, 0x7B10 },
	{ 0xD340, 0x7B04 },
	{ 0xD341, 0x7B13 },
	{ 0xD342, 0x7B05 },
	{ 0xD343, 0x7B0F },
	{ 0xD344, 0x7B08 },
	{ 0xD345, 0x7B0A },
	{ 0xD346, 0x7B0E },
	{ 0xD347, 0x7B09 },
	{ 0xD348, 0x7B12 },
	{ 0xD349, 0x7C84 },
	{ 0xD34A, 0x7C91 },
	{ 0xD34B, 0x7C8A },
	{ 0xD34C, 0x7C8C },
	{ 0xD34D, 0x7C88 },
	{ 0xD34E, 0x7C8D },
	{ 0xD34F, 0x7C85 },
	{ 0xD350, 0x7D1E },
	{ 0xD351, 0x7D1D },
	{ 0xD352, 0x7D11 },
	{ 0xD353, 0x7D0E },
	{ 0xD354, 0x7D18 },
	{ 0xD355, 0x7D16 },
	{ 0xD356, 0x7D13 },
	{ 0xD357, 0x7D1F },
	{ 0xD358, 0x7D12 },
	{ 0xD359, 0x7D0F },
	{ 0xD35A, 0x7D0C },
	{ 0xD35B, 0x7F5C },
	{ 0xD35C, 0x7F61 },
	{ 0xD35D, 0x7F5E },
	{ 0xD35E, 0x7F60 },
	{ 0xD35F, 0x7F5D },
	{ 0xD360, 0x7F5B },
	{ 0xD361, 0x7F96 },
	{ 0xD362, 0x7F92 },
	{ 0xD363, 0x7FC3 },
	{ 0xD364, 0x7FC2 },
	{ 0xD365, 0x7FC0 },
	{ 0xD366, 0x8016 },
	{ 0xD367, 0x803E },
	{ 0xD368, 0x8039 },
	{ 0xD369, 0x80FA },
	{ 0xD36A, 0x80F2 },
	{ 0xD36B, 0x80F9 },
	{ 0xD36C, 0x80F5 },
	{ 0xD36D, 0x8101 },
	{ 0xD36E, 0x80FB },
	{ 0xD36F, 0x8100 },
	{ 0xD370, 0x8201 },
	{ 0xD371, 0x822F },
	{ 0xD372, 0x8225 },
	{ 0xD373, 0x8333 },
	{ 0xD374, 0x832D },
	{ 0xD375, 0x8344 },
	{ 0xD376, 0x8319 },
	{ 0xD377, 0x8351 },
	{ 0xD378, 0x8325 },
	{ 0xD379, 0x8356 },
	{ 0xD37A, 0x833F },
	{ 0xD37B, 0x8341 },
	{ 0xD37C, 0x8326 },
	{ 0xD37D, 0x831C },
	{ 0xD37E, 0x8322 },
	{ 0xD37F, 0xFFFD },
	{ 0xD380, 0x7DF8 },
	{ 0xD381, 0x7DED },
	{ 0xD382, 0x7DE2 },
	{ 0xD383, 0x7DDC },
	{ 0xD384, 0x7E02 },
	{ 0xD385, 0x7E01 },
	{ 0xD386, 0x7DD6 },
	{ 0xD387, 0x7DE4 },
	{ 0xD388, 0x7DFE },
	{ 0xD389, 0x7E00 },
	{ 0xD38A, 0x7DFC },
	{ 0xD38B, 0x7DFD },
	{ 0xD38C, 0x7DF5 },
	{ 0xD38D, 0x7DFF },
	{ 0xD38E, 0x7DEB },
	{ 0xD38F, 0x7DE5 },
	{ 0xD390, 0x7F78 },
	{ 0xD391, 0x7FAE },
	{ 0xD392, 0x7FE7 },
	{ 0xD393, 0x8065 },
	{ 0xD394, 0x806A },
	{ 0xD395, 0x8066 },
	{ 0xD396, 0x8068 },
	{ 0xD397, 0x806B },
	{ 0xD398, 0x8194 },
	{ 0xD399, 0x81A1 },
	{ 0xD39A, 0x8192 },
	{ 0xD39B, 0x8196 },
	{ 0xD39C, 0x8193 },
	{ 0xD39D, 0x8501 },
	{ 0xD39E, 0x84F8 },
	{ 0xD39F, 0x84F5 },
	{ 0xD3A0, 0x8504 },
	{ 0xD3A1, 0x8342 },
	{ 0xD3A2, 0x834E },
	{ 0xD3A3, 0x831B },
	{ 0xD3A4, 0x832A },
	{ 0xD3A5, 0x8308 },
	{ 0xD3A6, 0x833C },
	{ 0xD3A7, 0x834D },
	{ 0xD3A8, 0x8316 },
	{ 0xD3A9, 0x8324 },
	{ 0xD3AA, 0x8320 },
	{ 0xD3AB, 0x8337 },
	{ 0xD3AC, 0x832F },
	{ 0xD3AD, 0x8329 },
	{ 0xD3AE, 0x8347 },
	{ 0xD3AF, 0x8345 },
	{ 0xD3B0, 0x834C },
	{ 0xD3B1, 0x8353 },
	{ 0xD3B2, 0x831E },
	{ 0xD3B3, 0x832C },
	{ 0xD3B4, 0x834B },
	{ 0xD3B5, 0x8327 },
	{ 0xD3B6, 0x8348 },
	{ 0xD3B7, 0x8653 },
	{ 0xD3B8, 0x8652 },
	{ 0xD3B9, 0x86A2 },
	{ 0xD3BA, 0x86A8 },
	{ 0xD3BB, 0x8696 },
	{ 0xD3BC, 0x868D },
	{ 0xD3BD, 0x8691 },
	{ 0xD3BE, 0x869E },
	{ 0xD3BF, 0x8687 },
	{ 0xD3C0, 0x8697 },
	{ 0xD3C1, 0x8686 },
	{ 0xD3C2, 0x868B },
	{ 0xD3C3, 0x869A },
	{ 0xD3C4, 0x8685 },
	{ 0xD3C5, 0x86A5 },
	{ 0xD3C6, 0x8699 },
	{ 0xD3C7, 0x86A1 },
	{ 0xD3C8, 0x86A7 },
	{ 0xD3C9, 0x8695 },
	{ 0xD3CA, 0x8698 },
	{ 0xD3CB, 0x868E },
	{ 0xD3CC, 0x869D },
	{ 0xD3CD, 0x8690 },
	{ 0xD3CE, 0x8694 },
	{ 0xD3CF, 0x8843 },
	{ 0xD3D0, 0x8844 },
	{ 0xD3D1, 0x886D },
	{ 0xD3D2, 0x8875 },
	{ 0xD3D3, 0x8876 },
	{ 0xD3D4, 0x8872 },
	{ 0xD3D5, 0x8880 },
	{ 0xD3D6, 0x8871 },
	{ 0xD3D7, 0x887F },
	{ 0xD3D8, 0x886F },
	{ 0xD3D9, 0x8883 },
	{ 0xD3DA, 0x887E },
	{ 0xD3DB, 0x8874 },
	{ 0xD3DC, 0x887C },
	{ 0xD3DD, 0x8A12 },
	{ 0xD3DE, 0x8C47 },
	{ 0xD3DF, 0x8C57 },
	{ 0xD3E0, 0x8C7B },
	{ 0xD3E1, 0x8CA4 },
	{ 0xD3E2, 0x8CA3 },
	{ 0xD3E3, 0x8D76 },
	{ 0xD3E4, 0x8D78 },
	{ 0xD3E5, 0x8DB5 },
	{ 0xD3E6, 0x8DB7 },
	{ 0xD3E7, 0x8DB6 },
	{ 0xD3E8, 0x8ED1 },
	{ 0xD3E9, 0x8ED3 },
	{ 0xD3EA, 0x8FFE },
	{ 0xD3EB, 0x8FF5 },
	{ 0xD3EC, 0x9002 },
	{ 0xD3ED, 0x8FFF },
	{ 0xD3EE, 0x8FFB },
	{ 0xD3EF, 0x9004 },
	{ 0xD3F0, 0x8FFC },
	{ 0xD3F1, 0x8FF6 },
	{ 0xD3F2, 0x90D6 },
	{ 0xD3F3, 0x90E0 },
	{ 0xD3F4, 0x90D9 },
	{ 0xD3F5, 0x90DA },
	{ 0xD3F6, 0x90E3 },
	{ 0xD3F7, 0x90DF },
	{ 0xD3F8, 0x90E5 },
	{ 0xD3F9, 0x90D8 },
	{ 0xD3FA, 0x90DB },
	{ 0xD3FB, 0x90D7 },
	{ 0xD3FC, 0x90DC },
	{ 0xD3FD, 0x90E4 },
	{ 0xD3FE, 0x9150 },
	{ 0xD440, 0x914E },
	{ 0xD441, 0x914F },
	{ 0xD442, 0x91D5 },
	{ 0xD443, 0x91E2 },
	{ 0xD444, 0x91DA },
	{ 0xD445, 0x965C },
	{ 0xD446, 0x965F },
	{ 0xD447, 0x96BC },
	{ 0xD448, 0x98E3 },
	{ 0xD449, 0x9ADF },
	{ 0xD44A, 0x9B2F },
	{ 0xD44B, 0x4E7F },
	{ 0xD44C, 0x5070 },
	{ 0xD44D, 0x506A },
	{ 0xD44E, 0x5061 },
	{ 0xD44F, 0x505E },
	{ 0xD450, 0x5060 },
	{ 0xD451, 0x5053 },
	{ 0xD452, 0x504B },
	{ 0xD453, 0x505D },
	{ 0xD454, 0x5072 },
	{ 0xD455, 0x5048 },
	{ 0xD456, 0x504D },
	{ 0xD457, 0x5041 },
	{ 0xD458, 0x505B },
	{ 0xD459, 0x504A },
	{ 0xD45A, 0x5062 },
	{ 0xD45B, 0x5015 },
	{ 0xD45C, 0x5045 },
	{ 0xD45D, 0x505F },
	{ 0xD45E, 0x5069 },
	{ 0xD45F, 0x506B },
	{ 0xD460, 0x5063 },
	{ 0xD461, 0x5064 },
	{ 0xD462, 0x5046 },
	{ 0xD463, 0x5040 },
	{ 0xD464, 0x506E },
	{ 0xD465, 0x5073 },
	{ 0xD466, 0x5057 },
	{ 0xD467, 0x5051 },
	{ 0xD468, 0x51D0 },
	{ 0xD469, 0x526B },
	{ 0xD46A, 0x526D },
	{ 0xD46B, 0x526C },
	{ 0xD46C, 0x526E },
	{ 0xD46D, 0x52D6 },
	{ 0xD46E, 0x52D3 },
	{ 0xD46F, 0x532D },
	{ 0xD470, 0x539C },
	{ 0xD471, 0x5575 },
	{ 0xD472, 0x5576 },
	{ 0xD473, 0x553C },
	{ 0xD474, 0x554D },
	{ 0xD475, 0x5550 },
	{ 0xD476, 0x5534 },
	{ 0xD477, 0x552A },
	{ 0xD478, 0x5551 },
	{ 0xD479, 0x5562 },
	{ 0xD47A, 0x5536 },
	{ 0xD47B, 0x5535 },
	{ 0xD47C, 0x5530 },
	{ 0xD47D, 0x5552 },
	{ 0xD47E, 0x5545 },
	{ 0xD47F, 0xFFFD },
	{ 0xD480, 0x851B },
	{ 0xD481, 0x8503 },
	{ 0xD482, 0x8533 },
	{ 0xD483, 0x8534 },
	{ 0xD484, 0x84ED },
	{ 0xD485, 0x8535 },
	{ 0xD486, 0x8505 },
	{ 0xD487, 0x877D },
	{ 0xD488, 0x8771 },
	{ 0xD489, 0x885C },
	{ 0xD48A, 0x88E6 },
	{ 0xD48B, 0x890F },
	{ 0xD48C, 0x891B },
	{ 0xD48D, 0x89A9 },
	{ 0xD48E, 0x89A5 },
	{ 0xD48F, 0x89EE },
	{ 0xD490, 0x8AB1 },
	{ 0xD491, 0x8ACC },
	{ 0xD492, 0x8ACE },
	{ 0xD493, 0x8AB7 },
	{ 0xD494, 0x8AB5 },
	{ 0xD495, 0x8AE9 },
	{ 0xD496, 0x8AB4 },
	{ 0xD497, 0x8AB3 },
	{ 0xD498, 0x8AC1 },
	{ 0xD499, 0x8AAF },
	{ 0xD49A, 0x8ACA },
	{ 0xD49B, 0x8AD0 },
	{ 0xD49C, 0x8C8E },
	{ 0xD49D, 0x8CE9 },
	{ 0xD49E, 0x8CDB },
	{ 0xD49F, 0x8CEB },
	{ 0xD4A0, 0x8DA4 },
	{ 0xD4A1, 0x550C },
	{ 0xD4A2, 0x5532 },
	{ 0xD4A3, 0x5565 },
	{ 0xD4A4, 0x554E },
	{ 0xD4A5, 0x5539 },
	{ 0xD4A6, 0x5548 },
	{ 0xD4A7, 0x552D },
	{ 0xD4A8, 0x553B },
	{ 0xD4A9, 0x5540 },
	{ 0xD4AA, 0x554B },
	{ 0xD4AB, 0x570A },
	{ 0xD4AC, 0x5707 },
	{ 0xD4AD, 0x57FB },
	{ 0xD4AE, 0x5814 },
	{ 0xD4AF, 0x57E2 },
	{ 0xD4B0, 0x57F6 },
	{ 0xD4B1, 0x57DC },
	{ 0xD4B2, 0x57F4 },
	{ 0xD4B3, 0x5800 },
	{ 0xD4B4, 0x57ED },
	{ 0xD4B5, 0x57FD },
	{ 0xD4B6, 0x5808 },
	{ 0xD4B7, 0x57F8 },
	{ 0xD4B8, 0x580B },
	{ 0xD4B9, 0x57F3 },
	{ 0xD4BA, 0x57CF },
	{ 0xD4BB, 0x5807 },
	{ 0xD4BC, 0x57EE },
	{ 0xD4BD, 0x57E3 },
	{ 0xD4BE, 0x57F2 },
	{ 0xD4BF, 0x57E5 },
	{ 0xD4C0, 0x57EC },
	{ 0xD4C1, 0x57E1 },
	{ 0xD4C2, 0x580E },
	{ 0xD4C3, 0x57FC },
	{ 0xD4C4, 0x5810 },
	{ 0xD4C5, 0x57E7 },
	{ 0xD4C6, 0x5801 },
	{ 0xD4C7, 0x580C },
	{ 0xD4C8, 0x57F1 },
	{ 0xD4C9, 0x57E9 },
	{ 0xD4CA, 0x57F0 },
	{ 0xD4CB, 0x580D },
	{ 0xD4CC, 0x5804 },
	{ 0xD4CD, 0x595C },
	{ 0xD4CE, 0x5A60 },
	{ 0xD4CF, 0x5A58 },
	{ 0xD4D0, 0x5A55 },
	{ 0xD4D1, 0x5A67 },
	{ 0xD4D2, 0x5A5E },
	{ 0xD4D3, 0x5A38 },
	{ 0xD4D4, 0x5A35 },
	{ 0xD4D5, 0x5A6D },
	{ 0xD4D6, 0x5A50 },
	{ 0xD4D7, 0x5A5F },
	{ 0xD4D8, 0x5A65 },
	{ 0xD4D9, 0x5A6C },
	{ 0xD4DA, 0x5A53 },
	{ 0xD4DB, 0x5A64 },
	{ 0xD4DC, 0x5A57 },
	{ 0xD4DD, 0x5A43 },
	{ 0xD4DE, 0x5A5D },
	{ 0xD4DF, 0x5A52 },
	{ 0xD4E0, 0x5A44 },
	{ 0xD4E1, 0x5A5B },
	{ 0xD4E2, 0x5A48 },
	{ 0xD4E3, 0x5A8E },
	{ 0xD4E4, 0x5A3E },
	{ 0xD4E5, 0x5A4D },
	{ 0xD4E6, 0x5A39 },
	{ 0xD4E7, 0x5A4C },
	{ 0xD4E8, 0x5A70 },
	{ 0xD4E9, 0x5A69 },
	{ 0xD4EA, 0x5A47 },
	{ 0xD4EB, 0x5A51 },
	{ 0xD4EC, 0x5A56 },
	{ 0xD4ED, 0x5A42 },
	{ 0xD4EE, 0x5A5C },
	{ 0xD4EF, 0x5B72 },
	{ 0xD4F0, 0x5B6E },
	{ 0xD4F1, 0x5BC1 },
	{ 0xD4F2, 0x5BC0 },
	{ 0xD4F3, 0x5C59 },
	{ 0xD4F4, 0x5D1E },
	{ 0xD4F5, 0x5D0B },
	{ 0xD4F6, 0x5D1D },
	{ 0xD4F7, 0x5D1A },
	{ 0xD4F8, 0x5D20 },
	{ 0xD4F9, 0x5D0C },
	{ 0xD4FA, 0x5D28 },
	{ 0xD4FB, 0x5D0D },
	{ 0xD4FC, 0x5D26 },
	{ 0xD4FD, 0x5D25 },
	{ 0xD4FE, 0x5D0F },
	{ 0xD540, 0x5D30 },
	{ 0xD541, 0x5D12 },
	{ 0xD542, 0x5D23 },
	{ 0xD543, 0x5D1F },
	{ 0xD544, 0x5D2E },
	{ 0xD545, 0x5E3E },
	{ 0xD546, 0x5E34 },
	{ 0xD547, 0x5EB1 },
	{ 0xD548, 0x5EB4 },
	{ 0xD549, 0x5EB9 },
	{ 0xD54A, 0x5EB2 },
	{ 0xD54B, 0x5EB3 },
	{ 0xD54C, 0x5F36 },
	{ 0xD54D, 0x5F38 },
	{ 0xD54E, 0x5F9B },
	{ 0xD54F, 0x5F96 },
	{ 0xD550, 0x5F9F },
	{ 0xD551, 0x608A },
	{ 0xD552, 0x6090 },
	{ 0xD553, 0x6086 },
	{ 0xD554, 0x60BE },
	{ 0xD555, 0x60B0 },
	{ 0xD556, 0x60BA },
	{ 0xD557, 0x60D3 },
	{ 0xD558, 0x60D4 },
	{ 0xD559, 0x60CF },
	{ 0xD55A, 0x60E4 },
	{ 0xD55B, 0x60D9 },
	{ 0xD55C, 0x60DD },
	{ 0xD55D, 0x60C8 },
	{ 0xD55E, 0x60B1 },
	{ 0xD55F, 0x60DB },
	{ 0xD560, 0x60B7 },
	{ 0xD561, 0x60CA },
	{ 0xD562, 0x60BF },
	{ 0xD563, 0x60C3 },
	{ 0xD564, 0x60CD },
	{ 0xD565, 0x60C0 },
	{ 0xD566, 0x6332 },
	{ 0xD567, 0x6365 },
	{ 0xD568, 0x638A },
	{ 0xD569, 0x6382 },
	{ 0xD56A, 0x637D },
	{ 0xD56B, 0x63BD },
	{ 0xD56C, 0x639E },
	{ 0xD56D, 0x63AD },
	{ 0xD56E, 0x639D },
	{ 0xD56F, 0x6397 },
	{ 0xD570, 0x63AB },
	{ 0xD571, 0x638E },
	{ 0xD572, 0x636F },
	{ 0xD573, 0x6387 },
	{ 0xD574, 0x6390 },
	{ 0xD575, 0x636E },
	{ 0xD576, 0x63AF },
	{ 0xD577, 0x6375 },
	{ 0xD578, 0x639C },
	{ 0xD579, 0x636D },
	{ 0xD57A, 0x63AE },
	{ 0xD57B, 0x637C },
	{ 0xD57C, 0x63A4 },
	{ 0xD57D, 0x633B },
	{ 0xD57E, 0x639F },
	{ 0xD57F, 0xFFFD },
	{ 0xD580, 0x8DA2 },
	{ 0xD581, 0x8D9D },
	{ 0xD582, 0x8E2A },
	{ 0xD583, 0x8E28 },
	{ 0xD584, 0x8EB8 },
	{ 0xD585, 0x8EB6 },
	{ 0xD586, 0x8EB9 },
	{ 0xD587, 0x8EB7 },
	{ 0xD588, 0x8F22 },
	{ 0xD589, 0x8F2B },
	{ 0xD58A, 0x8F27 },
	{ 0xD58B, 0x8F19 },
	{ 0xD58C, 0x8FA4 },
	{ 0xD58D, 0x8FB3 },
	{ 0xD58E, 0x9071 },
	{ 0xD58F, 0x906A },
	{ 0xD590, 0x9188 },
	{ 0xD591, 0x918C },
	{ 0xD592, 0x92BF },
	{ 0xD593, 0x92B8 },
	{ 0xD594, 0x92BE },
	{ 0xD595, 0x92DC },
	{ 0xD596, 0x92E5 },
	{ 0xD597, 0x92D4 },
	{ 0xD598, 0x92D6 },
	{ 0xD599, 0x92DA },
	{ 0xD59A, 0x92ED },
	{ 0xD59B, 0x92F3 },
	{ 0xD59C, 0x92DB },
	{ 0xD59D, 0x92E2 },
	{ 0xD59E, 0x92EB },
	{ 0xD59F, 0x95AF },
	{ 0xD5A0, 0x95B2 },
	{ 0xD5A1, 0x6378 },
	{ 0xD5A2, 0x6385 },
	{ 0xD5A3, 0x6381 },
	{ 0xD5A4, 0x6391 },
	{ 0xD5A5, 0x638D },
	{ 0xD5A6, 0x6370 },
	{ 0xD5A7, 0x6553 },
	{ 0xD5A8, 0x65CD },
	{ 0xD5A9, 0x6665 },
	{ 0xD5AA, 0x6661 },
	{ 0xD5AB, 0x665B },
	{ 0xD5AC, 0x6659 },
	{ 0xD5AD, 0x665C },
	{ 0xD5AE, 0x6662 },
	{ 0xD5AF, 0x6718 },
	{ 0xD5B0, 0x6879 },
	{ 0xD5B1, 0x6887 },
	{ 0xD5B2, 0x6890 },
	{ 0xD5B3, 0x689C },
	{ 0xD5B4, 0x686D },
	{ 0xD5B5, 0x686E },
	{ 0xD5B6, 0x68AE },
	{ 0xD5B7, 0x68AB },
	{ 0xD5B8, 0x6956 },
	{ 0xD5B9, 0x686F },
	{ 0xD5BA, 0x68A3 },
	{ 0xD5BB, 0x68AC },
	{ 0xD5BC, 0x68A9 },
	{ 0xD5BD, 0x6875 },
	{ 0xD5BE, 0x6874 },
	{ 0xD5BF, 0x68B2 },
	{ 0xD5C0, 0x688F },
	{ 0xD5C1, 0x6877 },
	{ 0xD5C2, 0x6892 },
	{ 0xD5C3, 0x687C },
	{ 0xD5C4, 0x686B },
	{ 0xD5C5, 0x6872 },
	{ 0xD5C6, 0x68AA },
	{ 0xD5C7, 0x6880 },
	{ 0xD5C8, 0x6871 },
	{ 0xD5C9, 0x687E },
	{ 0xD5CA, 0x689B },
	{ 0xD5CB, 0x6896 },
	{ 0xD5CC, 0x688B },
	{ 0xD5CD, 0x68A0 },
	{ 0xD5CE, 0x6889 },
	{ 0xD5CF, 0x68A4 },
	{ 0xD5D0, 0x6878 },
	{ 0xD5D1, 0x687B },
	{ 0xD5D2, 0x6891 },
	{ 0xD5D3, 0x688C },
	{ 0xD5D4, 0x688A },
	{ 0xD5D5, 0x687D },
	{ 0xD5D6, 0x6B36 },
	{ 0xD5D7, 0x6B33 },
	{ 0xD5D8, 0x6B37 },
	{ 0xD5D9, 0x6B38 },
	{ 0xD5DA, 0x6B91 },
	{ 0xD5DB, 0x6B8F },
	{ 0xD5DC, 0x6B8D },
	{ 0xD5DD, 0x6B8E },
	{ 0xD5DE, 0x6B8C },
	{ 0xD5DF, 0x6C2A },
	{ 0xD5E0, 0x6DC0 },
	{ 0xD5E1, 0x6DAB },
	{ 0xD5E2, 0x6DB4 },
	{ 0xD5E3, 0x6DB3 },
	{ 0xD5E4, 0x6E74 },
	{ 0xD5E5, 0x6DAC },
	{ 0xD5E6, 0x6DE9 },
	{ 0xD5E7, 0x6DE2 },
	{ 0xD5E8, 0x6DB7 },
	{ 0xD5E9, 0x6DF6 },
	{ 0xD5EA, 0x6DD4 },
	{ 0xD5EB, 0x6E00 },
	{ 0xD5EC, 0x6DC8 },
	{ 0xD5ED, 0x6DE0 },
	{ 0xD5EE, 0x6DDF },
	{ 0xD5EF, 0x6DD6 },
	{ 0xD5F0, 0x6DBE },
	{ 0xD5F1, 0x6DE5 },
	{ 0xD5F2, 0x6DDC },
	{ 0xD5F3, 0x6DDD },
	{ 0xD5F4, 0x6DDB },
	{ 0xD5F5, 0x6DF4 },
	{ 0xD5F6, 0x6DCA },
	{ 0xD5F7, 0x6DBD },
	{ 0xD5F8, 0x6DED },
	{ 0xD5F9, 0x6DF0 },
	{ 0xD5FA, 0x6DBA },
	{ 0xD5FB, 0x6DD5 },
	{ 0xD5FC, 0x6DC2 },
	{ 0xD5FD, 0x6DCF },
	{ 0xD5FE, 0x6DC9 },
	{ 0xD640, 0x6DD0 },
	{ 0xD641, 0x6DF2 },
	{ 0xD642, 0x6DD3 },
	{ 0xD643, 0x6DFD },
	{ 0xD644, 0x6DD7 },
	{ 0xD645, 0x6DCD },
	{ 0xD646, 0x6DE3 },
	{ 0xD647, 0x6DBB },
	{ 0xD648, 0x70FA },
	{ 0xD649, 0x710D },
	{ 0xD64A, 0x70F7 },
	{ 0xD64B, 0x7117 },
	{ 0xD64C, 0x70F4 },
	{ 0xD64D, 0x710C },
	{ 0xD64E, 0x70F0 },
	{ 0xD64F, 0x7104 },
	{ 0xD650, 0x70F3 },
	{ 0xD651, 0x7110 },
	{ 0xD652, 0x70FC },
	{ 0xD653, 0x70FF },
	{ 0xD654, 0x7106 },
	{ 0xD655, 0x7113 },
	{ 0xD656, 0x7100 },
	{ 0xD657, 0x70F8 },
	{ 0xD658, 0x70F6 },
	{ 0xD659, 0x710B },
	{ 0xD65A, 0x7102 },
	{ 0xD65B, 0x710E },
	{ 0xD65C, 0x727E },
	{ 0xD65D, 0x727B },
	{ 0xD65E, 0x727C },
	{ 0xD65F, 0x727F },
	{ 0xD660, 0x731D },
	{ 0xD661, 0x7317 },
	{ 0xD662, 0x7307 },
	{ 0xD663, 0x7311 },
	{ 0xD664, 0x7318 },
	{ 0xD665, 0x730A },
	{ 0xD666, 0x7308 },
	{ 0xD667, 0x72FF },
	{ 0xD668, 0x730F },
	{ 0xD669, 0x731E },
	{ 0xD66A, 0x7388 },
	{ 0xD66B, 0x73F6 },
	{ 0xD66C, 0x73F8 },
	{ 0xD66D, 0x73F5 },
	{ 0xD66E, 0x7404 },
	{ 0xD66F, 0x7401 },
	{ 0xD670, 0x73FD },
	{ 0xD671, 0x7407 },
	{ 0xD672, 0x7400 },
	{ 0xD673, 0x73FA },
	{ 0xD674, 0x73FC },
	{ 0xD675, 0x73FF },
	{ 0xD676, 0x740C },
	{ 0xD677, 0x740B },
	{ 0xD678, 0x73F4 },
	{ 0xD679, 0x7408 },
	{ 0xD67A, 0x7564 },
	{ 0xD67B, 0x7563 },
	{ 0xD67C, 0x75CE },
	{ 0xD67D, 0x75D2 },
	{ 0xD67E, 0x75CF },
	{ 0xD67F, 0xFFFD },
	{ 0xD680, 0x95B3 },
	{ 0xD681, 0x96A3 },
	{ 0xD682, 0x96A5 },
	{ 0xD683, 0x970A },
	{ 0xD684, 0x9787 },
	{ 0xD685, 0x9789 },
	{ 0xD686, 0x978C },
	{ 0xD687, 0x97EF },
	{ 0xD688, 0x982A },
	{ 0xD689, 0x9822 },
	{ 0xD68A, 0x981F },
	{ 0xD68B, 0x9919 },
	{ 0xD68C, 0x99CA },
	{ 0xD68D, 0x99DA },
	{ 0xD68E, 0x99DE },
	{ 0xD68F, 0x99C8 },
	{ 0xD690, 0x99E0 },
	{ 0xD691, 0x9AB6 },
	{ 0xD692, 0x9AB5 },
	{ 0xD693, 0x9AF4 },
	{ 0xD694, 0x9B6B },
	{ 0xD695, 0x9B69 },
	{ 0xD696, 0x9B72 },
	{ 0xD697, 0x9B63 },
	{ 0xD698, 0x9D0D },
	{ 0xD699, 0x9D01 },
	{ 0xD69A, 0x9D0C },
	{ 0xD69B, 0x9CF8 },
	{ 0xD69C, 0x9CFE },
	{ 0xD69D, 0x9D02 },
	{ 0xD69E, 0x9E84 },
	{ 0xD69F, 0x9EAB },
	{ 0xD6A0, 0x9EAA },
	{ 0xD6A1, 0x75CB },
	{ 0xD6A2, 0x75CC },
	{ 0xD6A3, 0x75D1 },
	{ 0xD6A4, 0x75D0 },
	{ 0xD6A5, 0x768F },
	{ 0xD6A6, 0x7689 },
	{ 0xD6A7, 0x76D3 },
	{ 0xD6A8, 0x7739 },
	{ 0xD6A9, 0x772F },
	{ 0xD6AA, 0x772D },
	{ 0xD6AB, 0x7731 },
	{ 0xD6AC, 0x7732 },
	{ 0xD6AD, 0x7734 },
	{ 0xD6AE, 0x7733 },
	{ 0xD6AF, 0x773D },
	{ 0xD6B0, 0x7725 },
	{ 0xD6B1, 0x773B },
	{ 0xD6B2, 0x7735 },
	{ 0xD6B3, 0x7848 },
	{ 0xD6B4, 0x7852 },
	{ 0xD6B5, 0x7849 },
	{ 0xD6B6, 0x784D },
	{ 0xD6B7, 0x784A },
	{ 0xD6B8, 0x784C },
	{ 0xD6B9, 0x7826 },
	{ 0xD6BA, 0x7845 },
	{ 0xD6BB, 0x7850 },
	{ 0xD6BC, 0x7964 },
	{ 0xD6BD, 0x7967 },
	{ 0xD6BE, 0x7969 },
	{ 0xD6BF, 0x796A },
	{ 0xD6C0, 0x7963 },
	{ 0xD6C1, 0x796B },
	{ 0xD6C2, 0x7961 },
	{ 0xD6C3, 0x79BB },
	{ 0xD6C4, 0x79FA },
	{ 0xD6C5, 0x79F8 },
	{ 0xD6C6, 0x79F6 },
	{ 0xD6C7, 0x79F7 },
	{ 0xD6C8, 0x7A8F },
	{ 0xD6C9, 0x7A94 },
	{ 0xD6CA, 0x7A90 },
	{ 0xD6CB, 0x7B35 },
	{ 0xD6CC, 0x7B47 },
	{ 0xD6CD, 0x7B34 },
	{ 0xD6CE, 0x7B25 },
	{ 0xD6CF, 0x7B30 },
	{ 0xD6D0, 0x7B22 },
	{ 0xD6D1, 0x7B24 },
	{ 0xD6D2, 0x7B33 },
	{ 0xD6D3, 0x7B18 },
	{ 0xD6D4, 0x7B2A },
	{ 0xD6D5, 0x7B1D },
	{ 0xD6D6, 0x7B31 },
	{ 0xD6D7, 0x7B2B },
	{ 0xD6D8, 0x7B2D },
	{ 0xD6D9, 0x7B2F },
	{ 0xD6DA, 0x7B32 },
	{ 0xD6DB, 0x7B38 },
	{ 0xD6DC, 0x7B1A },
	{ 0xD6DD, 0x7B23 },
	{ 0xD6DE, 0x7C94 },
	{ 0xD6DF, 0x7C98 },
	{ 0xD6E0, 0x7C96 },
	{ 0xD6E1, 0x7CA3 },
	{ 0xD6E2, 0x7D35 },
	{ 0xD6E3, 0x7D3D },
	{ 0xD6E4, 0x7D38 },
	{ 0xD6E5, 0x7D36 },
	{ 0xD6E6, 0x7D3A },
	{ 0xD6E7, 0x7D45 },
	{ 0xD6E8, 0x7D2C },
	{ 0xD6E9, 0x7D29 },
	{ 0xD6EA, 0x7D41 },
	{ 0xD6EB, 0x7D47 },
	{ 0xD6EC, 0x7D3E },
	{ 0xD6ED, 0x7D3F },
	{ 0xD6EE, 0x7D4A },
	{ 0xD6EF, 0x7D3B },
	{ 0xD6F0, 0x7D28 },
	{ 0xD6F1, 0x7F63 },
	{ 0xD6F2, 0x7F95 },
	{ 0xD6F3, 0x7F9C },
	{ 0xD6F4, 0x7F9D },
	{ 0xD6F5, 0x7F9B },
	{ 0xD6F6, 0x7FCA },
	{ 0xD6F7, 0x7FCB },
	{ 0xD6F8, 0x7FCD },
	{ 0xD6F9, 0x7FD0 },
	{ 0xD6FA, 0x7FD1 },
	{ 0xD6FB, 0x7FC7 },
	{ 0xD6FC, 0x7FCF },
	{ 0xD6FD, 0x7FC9 },
	{ 0xD6FE, 0x801F },
	{ 0xD740, 0x801E },
	{ 0xD741, 0x801B },
	{ 0xD742, 0x8047 },
	{ 0xD743, 0x8043 },
	{ 0xD744, 0x8048 },
	{ 0xD745, 0x8118 },
	{ 0xD746, 0x8125 },
	{ 0xD747, 0x8119 },
	{ 0xD748, 0x811B },
	{ 0xD749, 0x812D },
	{ 0xD74A, 0x811F },
	{ 0xD74B, 0x812C },
	{ 0xD74C, 0x811E },
	{ 0xD74D, 0x8121 },
	{ 0xD74E, 0x8115 },
	{ 0xD74F, 0x8127 },
	{ 0xD750, 0x811D },
	{ 0xD751, 0x8122 },
	{ 0xD752, 0x8211 },
	{ 0xD753, 0x8238 },
	{ 0xD754, 0x8233 },
	{ 0xD755, 0x823A },
	{ 0xD756, 0x8234 },
	{ 0xD757, 0x8232 },
	{ 0xD758, 0x8274 },
	{ 0xD759, 0x8390 },
	{ 0xD75A, 0x83A3 },
	{ 0xD75B, 0x83A8 },
	{ 0xD75C, 0x838D },
	{ 0xD75D, 0x837A },
	{ 0xD75E, 0x8373 },
	{ 0xD75F, 0x83A4 },
	{ 0xD760, 0x8374 },
	{ 0xD761, 0x838F },
	{ 0xD762, 0x8381 },
	{ 0xD763, 0x8395 },
	{ 0xD764, 0x8399 },
	{ 0xD765, 0x8375 },
	{ 0xD766, 0x8394 },
	{ 0xD767, 0x83A9 },
	{ 0xD768, 0x837D },
	{ 0xD769, 0x8383 },
	{ 0xD76A, 0x838C },
	{ 0xD76B, 0x839D },
	{ 0xD76C, 0x839B },
	{ 0xD76D, 0x83AA },
	{ 0xD76E, 0x838B },
	{ 0xD76F, 0x837E },
	{ 0xD770, 0x83A5 },
	{ 0xD771, 0x83AF },
	{ 0xD772, 0x8388 },
	{ 0xD773, 0x8397 },
	{ 0xD774, 0x83B0 },
	{ 0xD775, 0x837F },
	{ 0xD776, 0x83A6 },
	{ 0xD777, 0x8387 },
	{ 0xD778, 0x83AE },
	{ 0xD779, 0x8376 },
	{ 0xD77A, 0x839A },
	{ 0xD77B, 0x8659 },
	{ 0xD77C, 0x8656 },
	{ 0xD77D, 0x86BF },
	{ 0xD77E, 0x86B7 },
	{ 0xD77F, 0xFFFD },
	{ 0xD780, 0x511D },
	{ 0xD781, 0x5116 },
	{ 0xD782, 0x512B },
	{ 0xD783, 0x511E },
	{ 0xD784, 0x511B },
	{ 0xD785, 0x5290 },
	{ 0xD786, 0x5294 },
	{ 0xD787, 0x5314 },
	{ 0xD788, 0x5667 },
	{ 0xD789, 0x567B },
	{ 0xD78A, 0x565F },
	{ 0xD78B, 0x5661 },
	{ 0xD78C, 0x58C3 },
	{ 0xD78D, 0x58CA },
	{ 0xD78E, 0x58C0 },
	{ 0xD78F, 0x58C4 },
	{ 0xD790, 0x5901 },
	{ 0xD791, 0x5B1F },
	{ 0xD792, 0x5B18 },
	{ 0xD793, 0x5B11 },
	{ 0xD794, 0x5B15 },
	{ 0xD795, 0x5B12 },
	{ 0xD796, 0x5B1C },
	{ 0xD797, 0x5B22 },
	{ 0xD798, 0x5B79 },
	{ 0xD799, 0x5DA6 },
	{ 0xD79A, 0x5DB3 },
	{ 0xD79B, 0x5DAB },
	{ 0xD79C, 0x5EEA },
	{ 0xD79D, 0x5F5B },
	{ 0xD79E, 0x61B7 },
	{ 0xD79F, 0x61CE },
	{ 0xD7A0, 0x61B9 },
	{ 0xD7A1, 0x86C2 },
	{ 0xD7A2, 0x86C1 },
	{ 0xD7A3, 0x86C5 },
	{ 0xD7A4, 0x86BA },
	{ 0xD7A5, 0x86B0 },
	{ 0xD7A6, 0x86C8 },
	{ 0xD7A7, 0x86B9 },
	{ 0xD7A8, 0x86B3 },
	{ 0xD7A9, 0x86B8 },
	{ 0xD7AA, 0x86CC },
	{ 0xD7AB, 0x86B4 },
	{ 0xD7AC, 0x86BB },
	{ 0xD7AD, 0x86BC },
	{ 0xD7AE, 0x86C3 },
	{ 0xD7AF, 0x86BD },
	{ 0xD7B0, 0x86BE },
	{ 0xD7B1, 0x8852 },
	{ 0xD7B2, 0x8889 },
	{ 0xD7B3, 0x8895 },
	{ 0xD7B4, 0x88A8 },
	{ 0xD7B5, 0x88A2 },
	{ 0xD7B6, 0x88AA },
	{ 0xD7B7, 0x889A },
	{ 0xD7B8, 0x8891 },
	{ 0xD7B9, 0x88A1 },
	{ 0xD7BA, 0x889F },
	{ 0xD7BB, 0x8898 },
	{ 0xD7BC, 0x88A7 },
	{ 0xD7BD, 0x8899 },
	{ 0xD7BE, 0x889B },
	{ 0xD7BF, 0x8897 },
	{ 0xD7C0, 0x88A4 },
	{ 0xD7C1, 0x88AC },
	{ 0xD7C2, 0x888C },
	{ 0xD7C3, 0x8893 },
	{ 0xD7C4, 0x888E },
	{ 0xD7C5, 0x8982 },
	{ 0xD7C6, 0x89D6 },
	{ 0xD7C7, 0x89D9 },
	{ 0xD7C8, 0x89D5 },
	{ 0xD7C9, 0x8A30 },
	{ 0xD7CA, 0x8A27 },
	{ 0xD7CB, 0x8A2C },
	{ 0xD7CC, 0x8A1E },
	{ 0xD7CD, 0x8C39 },
	{ 0xD7CE, 0x8C3B },
	{ 0xD7CF, 0x8C5C },
	{ 0xD7D0, 0x8C5D },
	{ 0xD7D1, 0x8C7D },
	{ 0xD7D2, 0x8CA5 },
	{ 0xD7D3, 0x8D7D },
	{ 0xD7D4, 0x8D7B },
	{ 0xD7D5, 0x8D79 },
	{ 0xD7D6, 0x8DBC },
	{ 0xD7D7, 0x8DC2 },
	{ 0xD7D8, 0x8DB9 },
	{ 0xD7D9, 0x8DBF },
	{ 0xD7DA, 0x8DC1 },
	{ 0xD7DB, 0x8ED8 },
	{ 0xD7DC, 0x8EDE },
	{ 0xD7DD, 0x8EDD },
	{ 0xD7DE, 0x8EDC },
	{ 0xD7DF, 0x8ED7 },
	{ 0xD7E0, 0x8EE0 },
	{ 0xD7E1, 0x8EE1 },
	{ 0xD7E2, 0x9024 },
	{ 0xD7E3, 0x900B },
	{ 0xD7E4, 0x9011 },
	{ 0xD7E5, 0x901C },
	{ 0xD7E6, 0x900C },
	{ 0xD7E7, 0x9021 },
	{ 0xD7E8, 0x90EF },
	{ 0xD7E9, 0x90EA },
	{ 0xD7EA, 0x90F0 },
	{ 0xD7EB, 0x90F4 },
	{ 0xD7EC, 0x90F2 },
	{ 0xD7ED, 0x90F3 },
	{ 0xD7EE, 0x90D4 },
	{ 0xD7EF, 0x90EB },
	{ 0xD7F0, 0x90EC },
	{ 0xD7F1, 0x90E9 },
	{ 0xD7F2, 0x9156 },
	{ 0xD7F3, 0x9158 },
	{ 0xD7F4, 0x915A },
	{ 0xD7F5, 0x9153 },
	{ 0xD7F6, 0x9155 },
	{ 0xD7F7, 0x91EC },
	{ 0xD7F8, 0x91F4 },
	{ 0xD7F9, 0x91F1 },
	{ 0xD7FA, 0x91F3 },
	{ 0xD7FB, 0x91F8 },
	{ 0xD7FC, 0x91E4 },
	{ 0xD7FD, 0x91F9 },
	{ 0xD7FE, 0x91EA },
	{ 0xD840, 0x91EB },
	{ 0xD841, 0x91F7 },
	{ 0xD842, 0x91E8 },
	{ 0xD843, 0x91EE },
	{ 0xD844, 0x957A },
	{ 0xD845, 0x9586 },
	{ 0xD846, 0x9588 },
	{ 0xD847, 0x967C },
	{ 0xD848, 0x966D },
	{ 0xD849, 0x966B },
	{ 0xD84A, 0x9671 },
	{ 0xD84B, 0x966F },
	{ 0xD84C, 0x96BF },
	{ 0xD84D, 0x976A },
	{ 0xD84E, 0x9804 },
	{ 0xD84F, 0x98E5 },
	{ 0xD850, 0x9997 },
	{ 0xD851, 0x509B },
	{ 0xD852, 0x5095 },
	{ 0xD853, 0x5094 },
	{ 0xD854, 0x509E },
	{ 0xD855, 0x508B },
	{ 0xD856, 0x50A3 },
	{ 0xD857, 0x5083 },
	{ 0xD858, 0x508C },
	{ 0xD859, 0x508E },
	{ 0xD85A, 0x509D },
	{ 0xD85B, 0x5068 },
	{ 0xD85C, 0x509C },
	{ 0xD85D, 0x5092 },
	{ 0xD85E, 0x5082 },
	{ 0xD85F, 0x5087 },
	{ 0xD860, 0x515F },
	{ 0xD861, 0x51D4 },
	{ 0xD862, 0x5312 },
	{ 0xD863, 0x5311 },
	{ 0xD864, 0x53A4 },
	{ 0xD865, 0x53A7 },
	{ 0xD866, 0x5591 },
	{ 0xD867, 0x55A8 },
	{ 0xD868, 0x55A5 },
	{ 0xD869, 0x55AD },
	{ 0xD86A, 0x5577 },
	{ 0xD86B, 0x5645 },
	{ 0xD86C, 0x55A2 },
	{ 0xD86D, 0x5593 },
	{ 0xD86E, 0x5588 },
	{ 0xD86F, 0x558F },
	{ 0xD870, 0x55B5 },
	{ 0xD871, 0x5581 },
	{ 0xD872, 0x55A3 },
	{ 0xD873, 0x5592 },
	{ 0xD874, 0x55A4 },
	{ 0xD875, 0x557D },
	{ 0xD876, 0x558C },
	{ 0xD877, 0x55A6 },
	{ 0xD878, 0x557F },
	{ 0xD879, 0x5595 },
	{ 0xD87A, 0x55A1 },
	{ 0xD87B, 0x558E },
	{ 0xD87C, 0x570C },
	{ 0xD87D, 0x5829 },
	{ 0xD87E, 0x5837 },
	{ 0xD87F, 0xFFFD },
	{ 0xD880, 0x61BD },
	{ 0xD881, 0x61CF },
	{ 0xD882, 0x61C0 },
	{ 0xD883, 0x6199 },
	{ 0xD884, 0x6197 },
	{ 0xD885, 0x61BB },
	{ 0xD886, 0x61D0 },
	{ 0xD887, 0x61C4 },
	{ 0xD888, 0x6231 },
	{ 0xD889, 0x64D3 },
	{ 0xD88A, 0x64C0 },
	{ 0xD88B, 0x64DC },
	{ 0xD88C, 0x64D1 },
	{ 0xD88D, 0x64C8 },
	{ 0xD88E, 0x64D5 },
	{ 0xD88F, 0x66C3 },
	{ 0xD890, 0x66BF },
	{ 0xD891, 0x66C5 },
	{ 0xD892, 0x66CD },
	{ 0xD893, 0x66C1 },
	{ 0xD894, 0x6706 },
	{ 0xD895, 0x6724 },
	{ 0xD896, 0x6A63 },
	{ 0xD897, 0x6A42 },
	{ 0xD898, 0x6A52 },
	{ 0xD899, 0x6A43 },
	{ 0xD89A, 0x6A33 },
	{ 0xD89B, 0x6A6C },
	{ 0xD89C, 0x6A57 },
	{ 0xD89D, 0x6A4C },
	{ 0xD89E, 0x6A6E },
	{ 0xD89F, 0x6A37 },
	{ 0xD8A0, 0x6A71 },
	{ 0xD8A1, 0x5819 },
	{ 0xD8A2, 0x581E },
	{ 0xD8A3, 0x5827 },
	{ 0xD8A4, 0x5823 },
	{ 0xD8A5, 0x5828 },
	{ 0xD8A6, 0x57F5 },
	{ 0xD8A7, 0x5848 },
	{ 0xD8A8, 0x5825 },
	{ 0xD8A9, 0x581C },
	{ 0xD8AA, 0x581B },
	{ 0xD8AB, 0x5833 },
	{ 0xD8AC, 0x583F },
	{ 0xD8AD, 0x5836 },
	{ 0xD8AE, 0x582E },
	{ 0xD8AF, 0x5839 },
	{ 0xD8B0, 0x5838 },
	{ 0xD8B1, 0x582D },
	{ 0xD8B2, 0x582C },
	{ 0xD8B3, 0x583B },
	{ 0xD8B4, 0x5961 },
	{ 0xD8B5, 0x5AAF },
	{ 0xD8B6, 0x5A94 },
	{ 0xD8B7, 0x5A9F },
	{ 0xD8B8, 0x5A7A },
	{ 0xD8B9, 0x5AA2 },
	{ 0xD8BA, 0x5A9E },
	{ 0xD8BB, 0x5A78 },
	{ 0xD8BC, 0x5AA6 },
	{ 0xD8BD, 0x5A7C },
	{ 0xD8BE, 0x5AA5 },
	{ 0xD8BF, 0x5AAC },
	{ 0xD8C0, 0x5A95 },
	{ 0xD8C1, 0x5AAE },
	{ 0xD8C2, 0x5A37 },
	{ 0xD8C3, 0x5A84 },
	{ 0xD8C4, 0x5A8A },
	{ 0xD8C5, 0x5A97 },
	{ 0xD8C6, 0x5A83 },
	{ 0xD8C7, 0x5A8B },
	{ 0xD8C8, 0x5AA9 },
	{ 0xD8C9, 0x5A7B },
	{ 0xD8CA, 0x5A7D },
	{ 0xD8CB, 0x5A8C },
	{ 0xD8CC, 0x5A9C },
	{ 0xD8CD, 0x5A8F },
	{ 0xD8CE, 0x5A93 },
	{ 0xD8CF, 0x5A9D },
	{ 0xD8D0, 0x5BEA },
	{ 0xD8D1, 0x5BCD },
	{ 0xD8D2, 0x5BCB },
	{ 0xD8D3, 0x5BD4 },
	{ 0xD8D4, 0x5BD1 },
	{ 0xD8D5, 0x5BCA },
	{ 0xD8D6, 0x5BCE },
	{ 0xD8D7, 0x5C0C },
	{ 0xD8D8, 0x5C30 },
	{ 0xD8D9, 0x5D37 },
	{ 0xD8DA, 0x5D43 },
	{ 0xD8DB, 0x5D6B },
	{ 0xD8DC, 0x5D41 },
	{ 0xD8DD, 0x5D4B },
	{ 0xD8DE, 0x5D3F },
	{ 0xD8DF, 0x5D35 },
	{ 0xD8E0, 0x5D51 },
	{ 0xD8E1, 0x5D4E },
	{ 0xD8E2, 0x5D55 },
	{ 0xD8E3, 0x5D33 },
	{ 0xD8E4, 0x5D3A },
	{ 0xD8E5, 0x5D52 },
	{ 0xD8E6, 0x5D3D },
	{ 0xD8E7, 0x5D31 },
	{ 0xD8E8, 0x5D59 },
	{ 0xD8E9, 0x5D42 },
	{ 0xD8EA, 0x5D39 },
	{ 0xD8EB, 0x5D49 },
	{ 0xD8EC, 0x5D38 },
	{ 0xD8ED, 0x5D3C },
	{ 0xD8EE, 0x5D32 },
	{ 0xD8EF, 0x5D36 },
	{ 0xD8F0, 0x5D40 },
	{ 0xD8F1, 0x5D45 },
	{ 0xD8F2, 0x5E44 },
	{ 0xD8F3, 0x5E41 },
	{ 0xD8F4, 0x5F58 },
	{ 0xD8F5, 0x5FA6 },
	{ 0xD8F6, 0x5FA5 },
	{ 0xD8F7, 0x5FAB },
	{ 0xD8F8, 0x60C9 },
	{ 0xD8F9, 0x60B9 },
	{ 0xD8FA, 0x60CC },
	{ 0xD8FB, 0x60E2 },
	{ 0xD8FC, 0x60CE },
	{ 0xD8FD, 0x60C4 },
	{ 0xD8FE, 0x6114 },
	{ 0xD940, 0x60F2 },
	{ 0xD941, 0x610A },
	{ 0xD942, 0x6116 },
	{ 0xD943, 0x6105 },
	{ 0xD944, 0x60F5 },
	{ 0xD945, 0x6113 },
	{ 0xD946, 0x60F8 },
	{ 0xD947, 0x60FC },
	{ 0xD948, 0x60FE },
	{ 0xD949, 0x60C1 },
	{ 0xD94A, 0x6103 },
	{ 0xD94B, 0x6118 },
	{ 0xD94C, 0x611D },
	{ 0xD94D, 0x6110 },
	{ 0xD94E, 0x60FF },
	{ 0xD94F, 0x6104 },
	{ 0xD950, 0x610B },
	{ 0xD951, 0x624A },
	{ 0xD952, 0x6394 },
	{ 0xD953, 0x63B1 },
	{ 0xD954, 0x63B0 },
	{ 0xD955, 0x63CE },
	{ 0xD956, 0x63E5 },
	{ 0xD957, 0x63E8 },
	{ 0xD958, 0x63EF },
	{ 0xD959, 0x63C3 },
	{ 0xD95A, 0x649D },
	{ 0xD95B, 0x63F3 },
	{ 0xD95C, 0x63CA },
	{ 0xD95D, 0x63E0 },
	{ 0xD95E, 0x63F6 },
	{ 0xD95F, 0x63D5 },
	{ 0xD960, 0x63F2 },
	{ 0xD961, 0x63F5 },
	{ 0xD962, 0x6461 },
	{ 0xD963, 0x63DF },
	{ 0xD964, 0x63BE },
	{ 0xD965, 0x63DD },
	{ 0xD966, 0x63DC },
	{ 0xD967, 0x63C4 },
	{ 0xD968, 0x63D8 },
	{ 0xD969, 0x63D3 },
	{ 0xD96A, 0x63C2 },
	{ 0xD96B, 0x63C7 },
	{ 0xD96C, 0x63CC },
	{ 0xD96D, 0x63CB },
	{ 0xD96E, 0x63C8 },
	{ 0xD96F, 0x63F0 },
	{ 0xD970, 0x63D7 },
	{ 0xD971, 0x63D9 },
	{ 0xD972, 0x6532 },
	{ 0xD973, 0x6567 },
	{ 0xD974, 0x656A },
	{ 0xD975, 0x6564 },
	{ 0xD976, 0x655C },
	{ 0xD977, 0x6568 },
	{ 0xD978, 0x6565 },
	{ 0xD979, 0x658C },
	{ 0xD97A, 0x659D },
	{ 0xD97B, 0x659E },
	{ 0xD97C, 0x65AE },
	{ 0xD97D, 0x65D0 },
	{ 0xD97E, 0x65D2 },
	{ 0xD97F, 0xFFFD },
	{ 0xD980, 0x6A4A },
	{ 0xD981, 0x6A36 },
	{ 0xD982, 0x6A53 },
	{ 0xD983, 0x6A45 },
	{ 0xD984, 0x6A70 },
	{ 0xD985, 0x6A5C },
	{ 0xD986, 0x6B58 },
	{ 0xD987, 0x6B57 },
	{ 0xD988, 0x6FBB },
	{ 0xD989, 0x6FBE },
	{ 0xD98A, 0x6FB5 },
	{ 0xD98B, 0x6FD3 },
	{ 0xD98C, 0x6F9F },
	{ 0xD98D, 0x6FB7 },
	{ 0xD98E, 0x6FF5 },
	{ 0xD98F, 0x71B7 },
	{ 0xD990, 0x71BB },
	{ 0xD991, 0x71D1 },
	{ 0xD992, 0x71BA },
	{ 0xD993, 0x71B6 },
	{ 0xD994, 0x71CC },
	{ 0xD995, 0x71D3 },
	{ 0xD996, 0x749B },
	{ 0xD997, 0x7496 },
	{ 0xD998, 0x74A2 },
	{ 0xD999, 0x749D },
	{ 0xD99A, 0x750A },
	{ 0xD99B, 0x750E },
	{ 0xD99C, 0x7581 },
	{ 0xD99D, 0x762C },
	{ 0xD99E, 0x7637 },
	{ 0xD99F, 0x7636 },
	{ 0xD9A0, 0x763B },
	{ 0xD9A1, 0x667C },
	{ 0xD9A2, 0x666C },
	{ 0xD9A3, 0x667B },
	{ 0xD9A4, 0x6680 },
	{ 0xD9A5, 0x6671 },
	{ 0xD9A6, 0x6679 },
	{ 0xD9A7, 0x666A },
	{ 0xD9A8, 0x6672 },
	{ 0xD9A9, 0x6701 },
	{ 0xD9AA, 0x690C },
	{ 0xD9AB, 0x68D3 },
	{ 0xD9AC, 0x6904 },
	{ 0xD9AD, 0x68DC },
	{ 0xD9AE, 0x692A },
	{ 0xD9AF, 0x68EC },
	{ 0xD9B0, 0x68EA },
	{ 0xD9B1, 0x68F1 },
	{ 0xD9B2, 0x690F },
	{ 0xD9B3, 0x68D6 },
	{ 0xD9B4, 0x68F7 },
	{ 0xD9B5, 0x68EB },
	{ 0xD9B6, 0x68E4 },
	{ 0xD9B7, 0x68F6 },
	{ 0xD9B8, 0x6913 },
	{ 0xD9B9, 0x6910 },
	{ 0xD9BA, 0x68F3 },
	{ 0xD9BB, 0x68E1 },
	{ 0xD9BC, 0x6907 },
	{ 0xD9BD, 0x68CC },
	{ 0xD9BE, 0x6908 },
	{ 0xD9BF, 0x6970 },
	{ 0xD9C0, 0x68B4 },
	{ 0xD9C1, 0x6911 },
	{ 0xD9C2, 0x68EF },
	{ 0xD9C3, 0x68C6 },
	{ 0xD9C4, 0x6914 },
	{ 0xD9C5, 0x68F8 },
	{ 0xD9C6, 0x68D0 },
	{ 0xD9C7, 0x68FD },
	{ 0xD9C8, 0x68FC },
	{ 0xD9C9, 0x68E8 },
	{ 0xD9CA, 0x690B },
	{ 0xD9CB, 0x690A },
	{ 0xD9CC, 0x6917 },
	{ 0xD9CD, 0x68CE },
	{ 0xD9CE, 0x68C8 },
	{ 0xD9CF, 0x68DD },
	{ 0xD9D0, 0x68DE },
	{ 0xD9D1, 0x68E6 },
	{ 0xD9D2, 0x68F4 },
	{ 0xD9D3, 0x68D1 },
	{ 0xD9D4, 0x6906 },
	{ 0xD9D5, 0x68D4 },
	{ 0xD9D6, 0x68E9 },
	{ 0xD9D7, 0x6915 },
	{ 0xD9D8, 0x6925 },
	{ 0xD9D9, 0x68C7 },
	{ 0xD9DA, 0x6B39 },
	{ 0xD9DB, 0x6B3B },
	{ 0xD9DC, 0x6B3F },
	{ 0xD9DD, 0x6B3C },
	{ 0xD9DE, 0x6B94 },
	{ 0xD9DF, 0x6B97 },
	{ 0xD9E0, 0x6B99 },
	{ 0xD9E1, 0x6B95 },
	{ 0xD9E2, 0x6BBD },
	{ 0xD9E3, 0x6BF0 },
	{ 0xD9E4, 0x6BF2 },
	{ 0xD9E5, 0x6BF3 },
	{ 0xD9E6, 0x6C30 },
	{ 0xD9E7, 0x6DFC },
	{ 0xD9E8, 0x6E46 },
	{ 0xD9E9, 0x6E47 },
	{ 0xD9EA, 0x6E1F },
	{ 0xD9EB, 0x6E49 },
	{ 0xD9EC, 0x6E88 },
	{ 0xD9ED, 0x6E3C },
	{ 0xD9EE, 0x6E3D },
	{ 0xD9EF, 0x6E45 },
	{ 0xD9F0, 0x6E62 },
	{ 0xD9F1, 0x6E2B },
	{ 0xD9F2, 0x6E3F },
	{ 0xD9F3, 0x6E41 },
	{ 0xD9F4, 0x6E5D },
	{ 0xD9F5, 0x6E73 },
	{ 0xD9F6, 0x6E1C },
	{ 0xD9F7, 0x6E33 },
	{ 0xD9F8, 0x6E4B },
	{ 0xD9F9, 0x6E40 },
	{ 0xD9FA, 0x6E51 },
	{ 0xD9FB, 0x6E3B },
	{ 0xD9FC, 0x6E03 },
	{ 0xD9FD, 0x6E2E },
	{ 0xD9FE, 0x6E5E },
	{ 0xDA40, 0x6E68 },
	{ 0xDA41, 0x6E5C },
	{ 0xDA42, 0x6E61 },
	{ 0xDA43, 0x6E31 },
	{ 0xDA44, 0x6E28 },
	{ 0xDA45, 0x6E60 },
	{ 0xDA46, 0x6E71 },
	{ 0xDA47, 0x6E6B },
	{ 0xDA48, 0x6E39 },
	{ 0xDA49, 0x6E22 },
	{ 0xDA4A, 0x6E30 },
	{ 0xDA4B, 0x6E53 },
	{ 0xDA4C, 0x6E65 },
	{ 0xDA4D, 0x6E27 },
	{ 0xDA4E, 0x6E78 },
	{ 0xDA4F, 0x6E64 },
	{ 0xDA50, 0x6E77 },
	{ 0xDA51, 0x6E55 },
	{ 0xDA52, 0x6E79 },
	{ 0xDA53, 0x6E52 },
	{ 0xDA54, 0x6E66 },
	{ 0xDA55, 0x6E35 },
	{ 0xDA56, 0x6E36 },
	{ 0xDA57, 0x6E5A },
	{ 0xDA58, 0x7120 },
	{ 0xDA59, 0x711E },
	{ 0xDA5A, 0x712F },
	{ 0xDA5B, 0x70FB },
	{ 0xDA5C, 0x712E },
	{ 0xDA5D, 0x7131 },
	{ 0xDA5E, 0x7123 },
	{ 0xDA5F, 0x7125 },
	{ 0xDA60, 0x7122 },
	{ 0xDA61, 0x7132 },
	{ 0xDA62, 0x711F },
	{ 0xDA63, 0x7128 },
	{ 0xDA64, 0x713A },
	{ 0xDA65, 0x711B },
	{ 0xDA66, 0x724B },
	{ 0xDA67, 0x725A },
	{ 0xDA68, 0x7288 },
	{ 0xDA69, 0x7289 },
	{ 0xDA6A, 0x7286 },
	{ 0xDA6B, 0x7285 },
	{ 0xDA6C, 0x728B },
	{ 0xDA6D, 0x7312 },
	{ 0xDA6E, 0x730B },
	{ 0xDA6F, 0x7330 },
	{ 0xDA70, 0x7322 },
	{ 0xDA71, 0x7331 },
	{ 0xDA72, 0x7333 },
	{ 0xDA73, 0x7327 },
	{ 0xDA74, 0x7332 },
	{ 0xDA75, 0x732D },
	{ 0xDA76, 0x7326 },
	{ 0xDA77, 0x7323 },
	{ 0xDA78, 0x7335 },
	{ 0xDA79, 0x730C },
	{ 0xDA7A, 0x742E },
	{ 0xDA7B, 0x742C },
	{ 0xDA7C, 0x7430 },
	{ 0xDA7D, 0x742B },
	{ 0xDA7E, 0x7416 },
	{ 0xDA7F, 0xFFFD },
	{ 0xDA80, 0x76A1 },
	{ 0xDA81, 0x7798 },
	{ 0xDA82, 0x7796 },
	{ 0xDA83, 0x78D6 },
	{ 0xDA84, 0x78EB },
	{ 0xDA85, 0x78DC },
	{ 0xDA86, 0x79A5 },
	{ 0xDA87, 0x79A9 },
	{ 0xDA88, 0x9834 },
	{ 0xDA89, 0x7A53 },
	{ 0xDA8A, 0x7A45 },
	{ 0xDA8B, 0x7A4F },
	{ 0xDA8C, 0x7ABD },
	{ 0xDA8D, 0x7ABB },
	{ 0xDA8E, 0x7AF1 },
	{ 0xDA8F, 0x7BEC },
	{ 0xDA90, 0x7BED },
	{ 0xDA91, 0x7CD3 },
	{ 0xDA92, 0x7CE1 },
	{ 0xDA93, 0x7E19 },
	{ 0xDA94, 0x7E27 },
	{ 0xDA95, 0x7E26 },
	{ 0xDA96, 0x806E },
	{ 0xDA97, 0x81AF },
	{ 0xDA98, 0x81AD },
	{ 0xDA99, 0x81AA },
	{ 0xDA9A, 0x8218 },
	{ 0xDA9B, 0x856F },
	{ 0xDA9C, 0x854C },
	{ 0xDA9D, 0x8542 },
	{ 0xDA9E, 0x855C },
	{ 0xDA9F, 0x8570 },
	{ 0xDAA0, 0x855F },
	{ 0xDAA1, 0x741A },
	{ 0xDAA2, 0x7421 },
	{ 0xDAA3, 0x742D },
	{ 0xDAA4, 0x7431 },
	{ 0xDAA5, 0x7424 },
	{ 0xDAA6, 0x7423 },
	{ 0xDAA7, 0x741D },
	{ 0xDAA8, 0x7429 },
	{ 0xDAA9, 0x7420 },
	{ 0xDAAA, 0x7432 },
	{ 0xDAAB, 0x74FB },
	{ 0xDAAC, 0x752F },
	{ 0xDAAD, 0x756F },
	{ 0xDAAE, 0x756C },
	{ 0xDAAF, 0x75E7 },
	{ 0xDAB0, 0x75DA },
	{ 0xDAB1, 0x75E1 },
	{ 0xDAB2, 0x75E6 },
	{ 0xDAB3, 0x75DD },
	{ 0xDAB4, 0x75DF },
	{ 0xDAB5, 0x75E4 },
	{ 0xDAB6, 0x75D7 },
	{ 0xDAB7, 0x7695 },
	{ 0xDAB8, 0x7692 },
	{ 0xDAB9, 0x76DA },
	{ 0xDABA, 0x7746 },
	{ 0xDABB, 0x7747 },
	{ 0xDABC, 0x7744 },
	{ 0xDABD, 0x774D },
	{ 0xDABE, 0x7745 },
	{ 0xDABF, 0x774A },
	{ 0xDAC0, 0x774E },
	{ 0xDAC1, 0x774B },
	{ 0xDAC2, 0x774C },
	{ 0xDAC3, 0x77DE },
	{ 0xDAC4, 0x77EC },
	{ 0xDAC5, 0x7860 },
	{ 0xDAC6, 0x7864 },
	{ 0xDAC7, 0x7865 },
	{ 0xDAC8, 0x785C },
	{ 0xDAC9, 0x786D },
	{ 0xDACA, 0x7871 },
	{ 0xDACB, 0x786A },
	{ 0xDACC, 0x786E },
	{ 0xDACD, 0x7870 },
	{ 0xDACE, 0x7869 },
	{ 0xDACF, 0x7868 },
	{ 0xDAD0, 0x785E },
	{ 0xDAD1, 0x7862 },
	{ 0xDAD2, 0x7974 },
	{ 0xDAD3, 0x7973 },
	{ 0xDAD4, 0x7972 },
	{ 0xDAD5, 0x7970 },
	{ 0xDAD6, 0x7A02 },
	{ 0xDAD7, 0x7A0A },
	{ 0xDAD8, 0x7A03 },
	{ 0xDAD9, 0x7A0C },
	{ 0xDADA, 0x7A04 },
	{ 0xDADB, 0x7A99 },
	{ 0xDADC, 0x7AE6 },
	{ 0xDADD, 0x7AE4 },
	{ 0xDADE, 0x7B4A },
	{ 0xDADF, 0x7B3B },
	{ 0xDAE0, 0x7B44 },
	{ 0xDAE1, 0x7B48 },
	{ 0xDAE2, 0x7B4C },
	{ 0xDAE3, 0x7B4E },
	{ 0xDAE4, 0x7B40 },
	{ 0xDAE5, 0x7B58 },
	{ 0xDAE6, 0x7B45 },
	{ 0xDAE7, 0x7CA2 },
	{ 0xDAE8, 0x7C9E },
	{ 0xDAE9, 0x7CA8 },
	{ 0xDAEA, 0x7CA1 },
	{ 0xDAEB, 0x7D58 },
	{ 0xDAEC, 0x7D6F },
	{ 0xDAED, 0x7D63 },
	{ 0xDAEE, 0x7D53 },
	{ 0xDAEF, 0x7D56 },
	{ 0xDAF0, 0x7D67 },
	{ 0xDAF1, 0x7D6A },
	{ 0xDAF2, 0x7D4F },
	{ 0xDAF3, 0x7D6D },
	{ 0xDAF4, 0x7D5C },
	{ 0xDAF5, 0x7D6B },
	{ 0xDAF6, 0x7D52 },
	{ 0xDAF7, 0x7D54 },
	{ 0xDAF8, 0x7D69 },
	{ 0xDAF9, 0x7D51 },
	{ 0xDAFA, 0x7D5F },
	{ 0xDAFB, 0x7D4E },
	{ 0xDAFC, 0x7F3E },
	{ 0xDAFD, 0x7F3F },
	{ 0xDAFE, 0x7F65 },
	{ 0xDB40, 0x7F66 },
	{ 0xDB41, 0x7FA2 },
	{ 0xDB42, 0x7FA0 },
	{ 0xDB43, 0x7FA1 },
	{ 0xDB44, 0x7FD7 },
	{ 0xDB45, 0x8051 },
	{ 0xDB46, 0x804F },
	{ 0xDB47, 0x8050 },
	{ 0xDB48, 0x80FE },
	{ 0xDB49, 0x80D4 },
	{ 0xDB4A, 0x8143 },
	{ 0xDB4B, 0x814A },
	{ 0xDB4C, 0x8152 },
	{ 0xDB4D, 0x814F },
	{ 0xDB4E, 0x8147 },
	{ 0xDB4F, 0x813D },
	{ 0xDB50, 0x814D },
	{ 0xDB51, 0x813A },
	{ 0xDB52, 0x81E6 },
	{ 0xDB53, 0x81EE },
	{ 0xDB54, 0x81F7 },
	{ 0xDB55, 0x81F8 },
	{ 0xDB56, 0x81F9 },
	{ 0xDB57, 0x8204 },
	{ 0xDB58, 0x823C },
	{ 0xDB59, 0x823D },
	{ 0xDB5A, 0x823F },
	{ 0xDB5B, 0x8275 },
	{ 0xDB5C, 0x833B },
	{ 0xDB5D, 0x83CF },
	{ 0xDB5E, 0x83F9 },
	{ 0xDB5F, 0x8423 },
	{ 0xDB60, 0x83C0 },
	{ 0xDB61, 0x83E8 },
	{ 0xDB62, 0x8412 },
	{ 0xDB63, 0x83E7 },
	{ 0xDB64, 0x83E4 },
	{ 0xDB65, 0x83FC },
	{ 0xDB66, 0x83F6 },
	{ 0xDB67, 0x8410 },
	{ 0xDB68, 0x83C6 },
	{ 0xDB69, 0x83C8 },
	{ 0xDB6A, 0x83EB },
	{ 0xDB6B, 0x83E3 },
	{ 0xDB6C, 0x83BF },
	{ 0xDB6D, 0x8401 },
	{ 0xDB6E, 0x83DD },
	{ 0xDB6F, 0x83E5 },
	{ 0xDB70, 0x83D8 },
	{ 0xDB71, 0x83FF },
	{ 0xDB72, 0x83E1 },
	{ 0xDB73, 0x83CB },
	{ 0xDB74, 0x83CE },
	{ 0xDB75, 0x83D6 },
	{ 0xDB76, 0x83F5 },
	{ 0xDB77, 0x83C9 },
	{ 0xDB78, 0x8409 },
	{ 0xDB79, 0x840F },
	{ 0xDB7A, 0x83DE },
	{ 0xDB7B, 0x8411 },
	{ 0xDB7C, 0x8406 },
	{ 0xDB7D, 0x83C2 },
	{ 0xDB7E, 0x83F3 },
	{ 0xDB7F, 0xFFFD },
	{ 0xDB80, 0x855A },
	{ 0xDB81, 0x854B },
	{ 0xDB82, 0x853F },
	{ 0xDB83, 0x878A },
	{ 0xDB84, 0x878B },
	{ 0xDB85, 0x87A1 },
	{ 0xDB86, 0x878E },
	{ 0xDB87, 0x8799 },
	{ 0xDB88, 0x885E },
	{ 0xDB89, 0x885F },
	{ 0xDB8A, 0x8924 },
	{ 0xDB8B, 0x89A7 },
	{ 0xDB8C, 0x8AEA },
	{ 0xDB8D, 0x8AFD },
	{ 0xDB8E, 0x8AF9 },
	{ 0xDB8F, 0x8AE3 },
	{ 0xDB90, 0x8AE5 },
	{ 0xDB91, 0x8AEC },
	{ 0xDB92, 0x8CF2 },
	{ 0xDB93, 0x8CEF },
	{ 0xDB94, 0x8DA6 },
	{ 0xDB95, 0x8E3B },
	{ 0xDB96, 0x8E43 },
	{ 0xDB97, 0x8E32 },
	{ 0xDB98, 0x8F31 },
	{ 0xDB99, 0x8F30 },
	{ 0xDB9A, 0x8F2D },
	{ 0xDB9B, 0x8F3C },
	{ 0xDB9C, 0x8FA7 },
	{ 0xDB9D, 0x8FA5 },
	{ 0xDB9E, 0x9137 },
	{ 0xDB9F, 0x9195 },
	{ 0xDBA0, 0x918E },
	{ 0xDBA1, 0x83D5 },
	{ 0xDBA2, 0x83FA },
	{ 0xDBA3, 0x83C7 },
	{ 0xDBA4, 0x83D1 },
	{ 0xDBA5, 0x83EA },
	{ 0xDBA6, 0x8413 },
	{ 0xDBA7, 0x83C3 },
	{ 0xDBA8, 0x83EC },
	{ 0xDBA9, 0x83EE },
	{ 0xDBAA, 0x83C4 },
	{ 0xDBAB, 0x83FB },
	{ 0xDBAC, 0x83D7 },
	{ 0xDBAD, 0x83E2 },
	{ 0xDBAE, 0x841B },
	{ 0xDBAF, 0x83DB },
	{ 0xDBB0, 0x83FE },
	{ 0xDBB1, 0x86D8 },
	{ 0xDBB2, 0x86E2 },
	{ 0xDBB3, 0x86E6 },
	{ 0xDBB4, 0x86D3 },
	{ 0xDBB5, 0x86E3 },
	{ 0xDBB6, 0x86DA },
	{ 0xDBB7, 0x86EA },
	{ 0xDBB8, 0x86DD },
	{ 0xDBB9, 0x86EB },
	{ 0xDBBA, 0x86DC },
	{ 0xDBBB, 0x86EC },
	{ 0xDBBC, 0x86E9 },
	{ 0xDBBD, 0x86D7 },
	{ 0xDBBE, 0x86E8 },
	{ 0xDBBF, 0x86D1 },
	{ 0xDBC0, 0x8848 },
	{ 0xDBC1, 0x8856 },
	{ 0xDBC2, 0x8855 },
	{ 0xDBC3, 0x88BA },
	{ 0xDBC4, 0x88D7 },
	{ 0xDBC5, 0x88B9 },
	{ 0xDBC6, 0x88B8 },
	{ 0xDBC7, 0x88C0 },
	{ 0xDBC8, 0x88BE },
	{ 0xDBC9, 0x88B6 },
	{ 0xDBCA, 0x88BC },
	{ 0xDBCB, 0x88B7 },
	{ 0xDBCC, 0x88BD },
	{ 0xDBCD, 0x88B2 },
	{ 0xDBCE, 0x8901 },
	{ 0xDBCF, 0x88C9 },
	{ 0xDBD0, 0x8995 },
	{ 0xDBD1, 0x8998 },
	{ 0xDBD2, 0x8997 },
	{ 0xDBD3, 0x89DD },
	{ 0xDBD4, 0x89DA },
	{ 0xDBD5, 0x89DB },
	{ 0xDBD6, 0x8A4E },
	{ 0xDBD7, 0x8A4D },
	{ 0xDBD8, 0x8A39 },
	{ 0xDBD9, 0x8A59 },
	{ 0xDBDA, 0x8A40 },
	{ 0xDBDB, 0x8A57 },
	{ 0xDBDC, 0x8A58 },
	{ 0xDBDD, 0x8A44 },
	{ 0xDBDE, 0x8A45 },
	{ 0xDBDF, 0x8A52 },
	{ 0xDBE0, 0x8A48 },
	{ 0xDBE1, 0x8A51 },
	{ 0xDBE2, 0x8A4A },
	{ 0xDBE3, 0x8A4C },
	{ 0xDBE4, 0x8A4F },
	{ 0xDBE5, 0x8C5F },
	{ 0xDBE6, 0x8C81 },
	{ 0xDBE7, 0x8C80 },
	{ 0xDBE8, 0x8CBA },
	{ 0xDBE9, 0x8CBE },
	{ 0xDBEA, 0x8CB0 },
	{ 0xDBEB, 0x8CB9 },
	{ 0xDBEC, 0x8CB5 },
	{ 0xDBED, 0x8D84 },
	{ 0xDBEE, 0x8D80 },
	{ 0xDBEF, 0x8D89 },
	{ 0xDBF0, 0x8DD8 },
	{ 0xDBF1, 0x8DD3 },
	{ 0xDBF2, 0x8DCD },
	{ 0xDBF3, 0x8DC7 },
	{ 0xDBF4, 0x8DD6 },
	{ 0xDBF5, 0x8DDC },
	{ 0xDBF6, 0x8DCF },
	{ 0xDBF7, 0x8DD5 },
	{ 0xDBF8, 0x8DD9 },
	{ 0xDBF9, 0x8DC8 },
	{ 0xDBFA, 0x8DD7 },
	{ 0xDBFB, 0x8DC5 },
	{ 0xDBFC, 0x8EEF },
	{ 0xDBFD, 0x8EF7 },
	{ 0xDBFE, 0x8EFA },
	{ 0xDC40, 0x8EF9 },
	{ 0xDC41, 0x8EE6 },
	{ 0xDC42, 0x8EEE },
	{ 0xDC43, 0x8EE5 },
	{ 0xDC44, 0x8EF5 },
	{ 0xDC45, 0x8EE7 },
	{ 0xDC46, 0x8EE8 },
	{ 0xDC47, 0x8EF6 },
	{ 0xDC48, 0x8EEB },
	{ 0xDC49, 0x8EF1 },
	{ 0xDC4A, 0x8EEC },
	{ 0xDC4B, 0x8EF4 },
	{ 0xDC4C, 0x8EE9 },
	{ 0xDC4D, 0x902D },
	{ 0xDC4E, 0x9034 },
	{ 0xDC4F, 0x902F },
	{ 0xDC50, 0x9106 },
	{ 0xDC51, 0x912C },
	{ 0xDC52, 0x9104 },
	{ 0xDC53, 0x90FF },
	{ 0xDC54, 0x90FC },
	{ 0xDC55, 0x9108 },
	{ 0xDC56, 0x90F9 },
	{ 0xDC57, 0x90FB },
	{ 0xDC58, 0x9101 },
	{ 0xDC59, 0x9100 },
	{ 0xDC5A, 0x9107 },
	{ 0xDC5B, 0x9105 },
	{ 0xDC5C, 0x9103 },
	{ 0xDC5D, 0x9161 },
	{ 0xDC5E, 0x9164 },
	{ 0xDC5F, 0x915F },
	{ 0xDC60, 0x9162 },
	{ 0xDC61, 0x9160 },
	{ 0xDC62, 0x9201 },
	{ 0xDC63, 0x920A },
	{ 0xDC64, 0x9225 },
	{ 0xDC65, 0x9203 },
	{ 0xDC66, 0x921A },
	{ 0xDC67, 0x9226 },
	{ 0xDC68, 0x920F },
	{ 0xDC69, 0x920C },
	{ 0xDC6A, 0x9200 },
	{ 0xDC6B, 0x9212 },
	{ 0xDC6C, 0x91FF },
	{ 0xDC6D, 0x91FD },
	{ 0xDC6E, 0x9206 },
	{ 0xDC6F, 0x9204 },
	{ 0xDC70, 0x9227 },
	{ 0xDC71, 0x9202 },
	{ 0xDC72, 0x921C },
	{ 0xDC73, 0x9224 },
	{ 0xDC74, 0x9219 },
	{ 0xDC75, 0x9217 },
	{ 0xDC76, 0x9205 },
	{ 0xDC77, 0x9216 },
	{ 0xDC78, 0x957B },
	{ 0xDC79, 0x958D },
	{ 0xDC7A, 0x958C },
	{ 0xDC7B, 0x9590 },
	{ 0xDC7C, 0x9687 },
	{ 0xDC7D, 0x967E },
	{ 0xDC7E, 0x9688 },
	{ 0xDC7F, 0xFFFD },
	{ 0xDC80, 0x9196 },
	{ 0xDC81, 0x9345 },
	{ 0xDC82, 0x930A },
	{ 0xDC83, 0x92FD },
	{ 0xDC84, 0x9317 },
	{ 0xDC85, 0x931C },
	{ 0xDC86, 0x9307 },
	{ 0xDC87, 0x9331 },
	{ 0xDC88, 0x9332 },
	{ 0xDC89, 0x932C },
	{ 0xDC8A, 0x9330 },
	{ 0xDC8B, 0x9303 },
	{ 0xDC8C, 0x9305 },
	{ 0xDC8D, 0x95C2 },
	{ 0xDC8E, 0x95B8 },
	{ 0xDC8F, 0x95C1 },
	{ 0xDC90, 0x96AB },
	{ 0xDC91, 0x96B7 },
	{ 0xDC92, 0x9715 },
	{ 0xDC93, 0x9714 },
	{ 0xDC94, 0x970C },
	{ 0xDC95, 0x9717 },
	{ 0xDC96, 0x9793 },
	{ 0xDC97, 0x97D2 },
	{ 0xDC98, 0x9836 },
	{ 0xDC99, 0x9831 },
	{ 0xDC9A, 0x9833 },
	{ 0xDC9B, 0x983C },
	{ 0xDC9C, 0x982E },
	{ 0xDC9D, 0x983A },
	{ 0xDC9E, 0x983D },
	{ 0xDC9F, 0x98B5 },
	{ 0xDCA0, 0x9922 },
	{ 0xDCA1, 0x9689 },
	{ 0xDCA2, 0x9683 },
	{ 0xDCA3, 0x9680 },
	{ 0xDCA4, 0x96C2 },
	{ 0xDCA5, 0x96C8 },
	{ 0xDCA6, 0x96C3 },
	{ 0xDCA7, 0x96F1 },
	{ 0xDCA8, 0x96F0 },
	{ 0xDCA9, 0x976C },
	{ 0xDCAA, 0x9770 },
	{ 0xDCAB, 0x976E },
	{ 0xDCAC, 0x9807 },
	{ 0xDCAD, 0x98A9 },
	{ 0xDCAE, 0x98EB },
	{ 0xDCAF, 0x9CE6 },
	{ 0xDCB0, 0x9EF9 },
	{ 0xDCB1, 0x4E83 },
	{ 0xDCB2, 0x4E84 },
	{ 0xDCB3, 0x4EB6 },
	{ 0xDCB4, 0x50BD },
	{ 0xDCB5, 0x50BF },
	{ 0xDCB6, 0x50C6 },
	{ 0xDCB7, 0x50AE },
	{ 0xDCB8, 0x50C4 },
	{ 0xDCB9, 0x50CA },
	{ 0xDCBA, 0x50B4 },
	{ 0xDCBB, 0x50C8 },
	{ 0xDCBC, 0x50C2 },
	{ 0xDCBD, 0x50B0 },
	{ 0xDCBE, 0x50C1 },
	{ 0xDCBF, 0x50BA },
	{ 0xDCC0, 0x50B1 },
	{ 0xDCC1, 0x50CB },
	{ 0xDCC2, 0x50C9 },
	{ 0xDCC3, 0x50B6 },
	{ 0xDCC4, 0x50B8 },
	{ 0xDCC5, 0x51D7 },
	{ 0xDCC6, 0x527A },
	{ 0xDCC7, 0x5278 },
	{ 0xDCC8, 0x527B },
	{ 0xDCC9, 0x527C },
	{ 0xDCCA, 0x55C3 },
	{ 0xDCCB, 0x55DB },
	{ 0xDCCC, 0x55CC },
	{ 0xDCCD, 0x55D0 },
	{ 0xDCCE, 0x55CB },
	{ 0xDCCF, 0x55CA },
	{ 0xDCD0, 0x55DD },
	{ 0xDCD1, 0x55C0 },
	{ 0xDCD2, 0x55D4 },
	{ 0xDCD3, 0x55C4 },
	{ 0xDCD4, 0x55E9 },
	{ 0xDCD5, 0x55BF },
	{ 0xDCD6, 0x55D2 },
	{ 0xDCD7, 0x558D },
	{ 0xDCD8, 0x55CF },
	{ 0xDCD9, 0x55D5 },
	{ 0xDCDA, 0x55E2 },
	{ 0xDCDB, 0x55D6 },
	{ 0xDCDC, 0x55C8 },
	{ 0xDCDD, 0x55F2 },
	{ 0xDCDE, 0x55CD },
	{ 0xDCDF, 0x55D9 },
	{ 0xDCE0, 0x55C2 },
	{ 0xDCE1, 0x5714 },
	{ 0xDCE2, 0x5853 },
	{ 0xDCE3, 0x5868 },
	{ 0xDCE4, 0x5864 },
	{ 0xDCE5, 0x584F },
	{ 0xDCE6, 0x584D },
	{ 0xDCE7, 0x5849 },
	{ 0xDCE8, 0x586F },
	{ 0xDCE9, 0x5855 },
	{ 0xDCEA, 0x584E },
	{ 0xDCEB, 0x585D },
	{ 0xDCEC, 0x5859 },
	{ 0xDCED, 0x5865 },
	{ 0xDCEE, 0x585B },
	{ 0xDCEF, 0x583D },
	{ 0xDCF0, 0x5863 },
	{ 0xDCF1, 0x5871 },
	{ 0xDCF2, 0x58FC },
	{ 0xDCF3, 0x5AC7 },
	{ 0xDCF4, 0x5AC4 },
	{ 0xDCF5, 0x5ACB },
	{ 0xDCF6, 0x5ABA },
	{ 0xDCF7, 0x5AB8 },
	{ 0xDCF8, 0x5AB1 },
	{ 0xDCF9, 0x5AB5 },
	{ 0xDCFA, 0x5AB0 },
	{ 0xDCFB, 0x5ABF },
	{ 0xDCFC, 0x5AC8 },
	{ 0xDCFD, 0x5ABB },
	{ 0xDCFE, 0x5AC6 },
	{ 0xDD40, 0x5AB7 },
	{ 0xDD41, 0x5AC0 },
	{ 0xDD42, 0x5ACA },
	{ 0xDD43, 0x5AB4 },
	{ 0xDD44, 0x5AB6 },
	{ 0xDD45, 0x5ACD },
	{ 0xDD46, 0x5AB9 },
	{ 0xDD47, 0x5A90 },
	{ 0xDD48, 0x5BD6 },
	{ 0xDD49, 0x5BD8 },
	{ 0xDD4A, 0x5BD9 },
	{ 0xDD4B, 0x5C1F },
	{ 0xDD4C, 0x5C33 },
	{ 0xDD4D, 0x5D71 },
	{ 0xDD4E, 0x5D63 },
	{ 0xDD4F, 0x5D4A },
	{ 0xDD50, 0x5D65 },
	{ 0xDD51, 0x5D72 },
	{ 0xDD52, 0x5D6C },
	{ 0xDD53, 0x5D5E },
	{ 0xDD54, 0x5D68 },
	{ 0xDD55, 0x5D67 },
	{ 0xDD56, 0x5D62 },
	{ 0xDD57, 0x5DF0 },
	{ 0xDD58, 0x5E4F },
	{ 0xDD59, 0x5E4E },
	{ 0xDD5A, 0x5E4A },
	{ 0xDD5B, 0x5E4D },
	{ 0xDD5C, 0x5E4B },
	{ 0xDD5D, 0x5EC5 },
	{ 0xDD5E, 0x5ECC },
	{ 0xDD5F, 0x5EC6 },
	{ 0xDD60, 0x5ECB },
	{ 0xDD61, 0x5EC7 },
	{ 0xDD62, 0x5F40 },
	{ 0xDD63, 0x5FAF },
	{ 0xDD64, 0x5FAD },
	{ 0xDD65, 0x60F7 },
	{ 0xDD66, 0x6149 },
	{ 0xDD67, 0x614A },
	{ 0xDD68, 0x612B },
	{ 0xDD69, 0x6145 },
	{ 0xDD6A, 0x6136 },
	{ 0xDD6B, 0x6132 },
	{ 0xDD6C, 0x612E },
	{ 0xDD6D, 0x6146 },
	{ 0xDD6E, 0x612F },
	{ 0xDD6F, 0x614F },
	{ 0xDD70, 0x6129 },
	{ 0xDD71, 0x6140 },
	{ 0xDD72, 0x6220 },
	{ 0xDD73, 0x9168 },
	{ 0xDD74, 0x6223 },
	{ 0xDD75, 0x6225 },
	{ 0xDD76, 0x6224 },
	{ 0xDD77, 0x63C5 },
	{ 0xDD78, 0x63F1 },
	{ 0xDD79, 0x63EB },
	{ 0xDD7A, 0x6410 },
	{ 0xDD7B, 0x6412 },
	{ 0xDD7C, 0x6409 },
	{ 0xDD7D, 0x6420 },
	{ 0xDD7E, 0x6424 },
	{ 0xDD7F, 0xFFFD },
	{ 0xDD80, 0x9923 },
	{ 0xDD81, 0x9920 },
	{ 0xDD82, 0x991C },
	{ 0xDD83, 0x991D },
	{ 0xDD84, 0x99A0 },
	{ 0xDD85, 0x99EF },
	{ 0xDD86, 0x99E8 },
	{ 0xDD87, 0x99EB },
	{ 0xDD88, 0x99E1 },
	{ 0xDD89, 0x99E6 },
	{ 0xDD8A, 0x9AF8 },
	{ 0xDD8B, 0x9AF5 },
	{ 0xDD8C, 0x9B83 },
	{ 0xDD8D, 0x9B94 },
	{ 0xDD8E, 0x9B84 },
	{ 0xDD8F, 0x9B8B },
	{ 0xDD90, 0x9B8F },
	{ 0xDD91, 0x9B8C },
	{ 0xDD92, 0x9B89 },
	{ 0xDD93, 0x9B8E },
	{ 0xDD94, 0x9D24 },
	{ 0xDD95, 0x9D0F },
	{ 0xDD96, 0x9D13 },
	{ 0xDD97, 0x9D0A },
	{ 0xDD98, 0x9D2A },
	{ 0xDD99, 0x9D1A },
	{ 0xDD9A, 0x9D27 },
	{ 0xDD9B, 0x9D16 },
	{ 0xDD9C, 0x9D21 },
	{ 0xDD9D, 0x9E85 },
	{ 0xDD9E, 0x9EAC },
	{ 0xDD9F, 0x9EC6 },
	{ 0xDDA0, 0x9EC5 },
	{ 0xDDA1, 0x6433 },
	{ 0xDDA2, 0x6443 },
	{ 0xDDA3, 0x641F },
	{ 0xDDA4, 0x6415 },
	{ 0xDDA5, 0x6418 },
	{ 0xDDA6, 0x6439 },
	{ 0xDDA7, 0x6437 },
	{ 0xDDA8, 0x6422 },
	{ 0xDDA9, 0x6423 },
	{ 0xDDAA, 0x640C },
	{ 0xDDAB, 0x6426 },
	{ 0xDDAC, 0x6430 },
	{ 0xDDAD, 0x6428 },
	{ 0xDDAE, 0x6441 },
	{ 0xDDAF, 0x6435 },
	{ 0xDDB0, 0x642F },
	{ 0xDDB1, 0x640A },
	{ 0xDDB2, 0x641A },
	{ 0xDDB3, 0x6440 },
	{ 0xDDB4, 0x6425 },
	{ 0xDDB5, 0x6427 },
	{ 0xDDB6, 0x640B },
	{ 0xDDB7, 0x63E7 },
	{ 0xDDB8, 0x641B },
	{ 0xDDB9, 0x642E },
	{ 0xDDBA, 0x6421 },
	{ 0xDDBB, 0x640E },
	{ 0xDDBC, 0x656F },
	{ 0xDDBD, 0x6592 },
	{ 0xDDBE, 0x65D3 },
	{ 0xDDBF, 0x6686 },
	{ 0xDDC0, 0x668C },
	{ 0xDDC1, 0x6695 },
	{ 0xDDC2, 0x6690 },
	{ 0xDDC3, 0x668B },
	{ 0xDDC4, 0x668A },
	{ 0xDDC5, 0x6699 },
	{ 0xDDC6, 0x6694 },
	{ 0xDDC7, 0x6678 },
	{ 0xDDC8, 0x6720 },
	{ 0xDDC9, 0x6966 },
	{ 0xDDCA, 0x695F },
	{ 0xDDCB, 0x6938 },
	{ 0xDDCC, 0x694E },
	{ 0xDDCD, 0x6962 },
	{ 0xDDCE, 0x6971 },
	{ 0xDDCF, 0x693F },
	{ 0xDDD0, 0x6945 },
	{ 0xDDD1, 0x696A },
	{ 0xDDD2, 0x6939 },
	{ 0xDDD3, 0x6942 },
	{ 0xDDD4, 0x6957 },
	{ 0xDDD5, 0x6959 },
	{ 0xDDD6, 0x697A },
	{ 0xDDD7, 0x6948 },
	{ 0xDDD8, 0x6949 },
	{ 0xDDD9, 0x6935 },
	{ 0xDDDA, 0x696C },
	{ 0xDDDB, 0x6933 },
	{ 0xDDDC, 0x693D },
	{ 0xDDDD, 0x6965 },
	{ 0xDDDE, 0x68F0 },
	{ 0xDDDF, 0x6978 },
	{ 0xDDE0, 0x6934 },
	{ 0xDDE1, 0x6969 },
	{ 0xDDE2, 0x6940 },
	{ 0xDDE3, 0x696F },
	{ 0xDDE4, 0x6944 },
	{ 0xDDE5, 0x6976 },
	{ 0xDDE6, 0x6958 },
	{ 0xDDE7, 0x6941 },
	{ 0xDDE8, 0x6974 },
	{ 0xDDE9, 0x694C },
	{ 0xDDEA, 0x693B },
	{ 0xDDEB, 0x694B },
	{ 0xDDEC, 0x6937 },
	{ 0xDDED, 0x695C },
	{ 0xDDEE, 0x694F },
	{ 0xDDEF, 0x6951 },
	{ 0xDDF0, 0x6932 },
	{ 0xDDF1, 0x6952 },
	{ 0xDDF2, 0x692F },
	{ 0xDDF3, 0x697B },
	{ 0xDDF4, 0x693C },
	{ 0xDDF5, 0x6B46 },
	{ 0xDDF6, 0x6B45 },
	{ 0xDDF7, 0x6B43 },
	{ 0xDDF8, 0x6B42 },
	{ 0xDDF9, 0x6B48 },
	{ 0xDDFA, 0x6B41 },
	{ 0xDDFB, 0x6B9B },
	{ 0xDDFC, 0x55C0 },
	{ 0xDDFD, 0x6BFB },
	{ 0xDDFE, 0x6BFC },
	{ 0xDE40, 0x6BF9 },
	{ 0xDE41, 0x6BF7 },
	{ 0xDE42, 0x6BF8 },
	{ 0xDE43, 0x6E9B },
	{ 0xDE44, 0x6ED6 },
	{ 0xDE45, 0x6EC8 },
	{ 0xDE46, 0x6E8F },
	{ 0xDE47, 0x6EC0 },
	{ 0xDE48, 0x6E9F },
	{ 0xDE49, 0x6E93 },
	{ 0xDE4A, 0x6E94 },
	{ 0xDE4B, 0x6EA0 },
	{ 0xDE4C, 0x6EB1 },
	{ 0xDE4D, 0x6EB9 },
	{ 0xDE4E, 0x6EC6 },
	{ 0xDE4F, 0x6ED2 },
	{ 0xDE50, 0x6EBD },
	{ 0xDE51, 0x6EC1 },
	{ 0xDE52, 0x6E9E },
	{ 0xDE53, 0x6EC9 },
	{ 0xDE54, 0x6EB7 },
	{ 0xDE55, 0x6EB0 },
	{ 0xDE56, 0x6ECD },
	{ 0xDE57, 0x6EA6 },
	{ 0xDE58, 0x6ECF },
	{ 0xDE59, 0x6EB2 },
	{ 0xDE5A, 0x6EBE },
	{ 0xDE5B, 0x6EC3 },
	{ 0xDE5C, 0x6EDC },
	{ 0xDE5D, 0x6ED8 },
	{ 0xDE5E, 0x6E99 },
	{ 0xDE5F, 0x6E92 },
	{ 0xDE60, 0x6E8E },
	{ 0xDE61, 0x6E8D },
	{ 0xDE62, 0x6EA4 },
	{ 0xDE63, 0x6EA1 },
	{ 0xDE64, 0x6EBF },
	{ 0xDE65, 0x6EB3 },
	{ 0xDE66, 0x6ED0 },
	{ 0xDE67, 0x6ECA },
	{ 0xDE68, 0x6E97 },
	{ 0xDE69, 0x6EAE },
	{ 0xDE6A, 0x6EA3 },
	{ 0xDE6B, 0x7147 },
	{ 0xDE6C, 0x7154 },
	{ 0xDE6D, 0x7152 },
	{ 0xDE6E, 0x7163 },
	{ 0xDE6F, 0x7160 },
	{ 0xDE70, 0x7141 },
	{ 0xDE71, 0x715D },
	{ 0xDE72, 0x7162 },
	{ 0xDE73, 0x7172 },
	{ 0xDE74, 0x7178 },
	{ 0xDE75, 0x716A },
	{ 0xDE76, 0x7161 },
	{ 0xDE77, 0x7142 },
	{ 0xDE78, 0x7158 },
	{ 0xDE79, 0x7143 },
	{ 0xDE7A, 0x714B },
	{ 0xDE7B, 0x7170 },
	{ 0xDE7C, 0x715F },
	{ 0xDE7D, 0x7150 },
	{ 0xDE7E, 0x7153 },
	{ 0xDE7F, 0xFFFD },
	{ 0xDE80, 0x9ED7 },
	{ 0xDE81, 0x9F53 },
	{ 0xDE82, 0x5128 },
	{ 0xDE83, 0x5127 },
	{ 0xDE84, 0x51DF },
	{ 0xDE85, 0x5335 },
	{ 0xDE86, 0x53B3 },
	{ 0xDE87, 0x568A },
	{ 0xDE88, 0x567D },
	{ 0xDE89, 0x5689 },
	{ 0xDE8A, 0x58CD },
	{ 0xDE8B, 0x58D0 },
	{ 0xDE8C, 0x5B2B },
	{ 0xDE8D, 0x5B33 },
	{ 0xDE8E, 0x5B29 },
	{ 0xDE8F, 0x5B35 },
	{ 0xDE90, 0x5B31 },
	{ 0xDE91, 0x5B37 },
	{ 0xDE92, 0x5C36 },
	{ 0xDE93, 0x5DBE },
	{ 0xDE94, 0x5DB9 },
	{ 0xDE95, 0x5DBB },
	{ 0xDE96, 0x61E2 },
	{ 0xDE97, 0x61DB },
	{ 0xDE98, 0x61DD },
	{ 0xDE99, 0x61DC },
	{ 0xDE9A, 0x61DA },
	{ 0xDE9B, 0x61D9 },
	{ 0xDE9C, 0x64DF },
	{ 0xDE9D, 0x64E1 },
	{ 0xDE9E, 0x64EE },
	{ 0xDE9F, 0x65B5 },
	{ 0xDEA0, 0x66D4 },
	{ 0xDEA1, 0x7144 },
	{ 0xDEA2, 0x714D },
	{ 0xDEA3, 0x715A },
	{ 0xDEA4, 0x724F },
	{ 0xDEA5, 0x728D },
	{ 0xDEA6, 0x728C },
	{ 0xDEA7, 0x7291 },
	{ 0xDEA8, 0x7290 },
	{ 0xDEA9, 0x728E },
	{ 0xDEAA, 0x733C },
	{ 0xDEAB, 0x7342 },
	{ 0xDEAC, 0x733B },
	{ 0xDEAD, 0x733A },
	{ 0xDEAE, 0x7340 },
	{ 0xDEAF, 0x734A },
	{ 0xDEB0, 0x7349 },
	{ 0xDEB1, 0x7444 },
	{ 0xDEB2, 0x744A },
	{ 0xDEB3, 0x744B },
	{ 0xDEB4, 0x7452 },
	{ 0xDEB5, 0x7451 },
	{ 0xDEB6, 0x7457 },
	{ 0xDEB7, 0x7440 },
	{ 0xDEB8, 0x744F },
	{ 0xDEB9, 0x7450 },
	{ 0xDEBA, 0x744E },
	{ 0xDEBB, 0x7442 },
	{ 0xDEBC, 0x7446 },
	{ 0xDEBD, 0x744D },
	{ 0xDEBE, 0x7454 },
	{ 0xDEBF, 0x74E1 },
	{ 0xDEC0, 0x74FF },
	{ 0xDEC1, 0x74FE },
	{ 0xDEC2, 0x74FD },
	{ 0xDEC3, 0x751D },
	{ 0xDEC4, 0x7579 },
	{ 0xDEC5, 0x7577 },
	{ 0xDEC6, 0x6983 },
	{ 0xDEC7, 0x75EF },
	{ 0xDEC8, 0x760F },
	{ 0xDEC9, 0x7603 },
	{ 0xDECA, 0x75F7 },
	{ 0xDECB, 0x75FE },
	{ 0xDECC, 0x75FC },
	{ 0xDECD, 0x75F9 },
	{ 0xDECE, 0x75F8 },
	{ 0xDECF, 0x7610 },
	{ 0xDED0, 0x75FB },
	{ 0xDED1, 0x75F6 },
	{ 0xDED2, 0x75ED },
	{ 0xDED3, 0x75F5 },
	{ 0xDED4, 0x75FD },
	{ 0xDED5, 0x7699 },
	{ 0xDED6, 0x76B5 },
	{ 0xDED7, 0x76DD },
	{ 0xDED8, 0x7755 },
	{ 0xDED9, 0x775F },
	{ 0xDEDA, 0x7760 },
	{ 0xDEDB, 0x7752 },
	{ 0xDEDC, 0x7756 },
	{ 0xDEDD, 0x775A },
	{ 0xDEDE, 0x7769 },
	{ 0xDEDF, 0x7767 },
	{ 0xDEE0, 0x7754 },
	{ 0xDEE1, 0x7759 },
	{ 0xDEE2, 0x776D },
	{ 0xDEE3, 0x77E0 },
	{ 0xDEE4, 0x7887 },
	{ 0xDEE5, 0x789A },
	{ 0xDEE6, 0x7894 },
	{ 0xDEE7, 0x788F },
	{ 0xDEE8, 0x7884 },
	{ 0xDEE9, 0x7895 },
	{ 0xDEEA, 0x7885 },
	{ 0xDEEB, 0x7886 },
	{ 0xDEEC, 0x78A1 },
	{ 0xDEED, 0x7883 },
	{ 0xDEEE, 0x7879 },
	{ 0xDEEF, 0x7899 },
	{ 0xDEF0, 0x7880 },
	{ 0xDEF1, 0x7896 },
	{ 0xDEF2, 0x787B },
	{ 0xDEF3, 0x797C },
	{ 0xDEF4, 0x7982 },
	{ 0xDEF5, 0x797D },
	{ 0xDEF6, 0x7979 },
	{ 0xDEF7, 0x7A11 },
	{ 0xDEF8, 0x7A18 },
	{ 0xDEF9, 0x7A19 },
	{ 0xDEFA, 0x7A12 },
	{ 0xDEFB, 0x7A17 },
	{ 0xDEFC, 0x7A15 },
	{ 0xDEFD, 0x7A22 },
	{ 0xDEFE, 0x7A13 },
	{ 0xDF40, 0x7A1B },
	{ 0xDF41, 0x7A10 },
	{ 0xDF42, 0x7AA3 },
	{ 0xDF43, 0x7AA2 },
	{ 0xDF44, 0x7A9E },
	{ 0xDF45, 0x7AEB },
	{ 0xDF46, 0x7B66 },
	{ 0xDF47, 0x7B64 },
	{ 0xDF48, 0x7B6D },
	{ 0xDF49, 0x7B74 },
	{ 0xDF4A, 0x7B69 },
	{ 0xDF4B, 0x7B72 },
	{ 0xDF4C, 0x7B65 },
	{ 0xDF4D, 0x7B73 },
	{ 0xDF4E, 0x7B71 },
	{ 0xDF4F, 0x7B70 },
	{ 0xDF50, 0x7B61 },
	{ 0xDF51, 0x7B78 },
	{ 0xDF52, 0x7B76 },
	{ 0xDF53, 0x7B63 },
	{ 0xDF54, 0x7CB2 },
	{ 0xDF55, 0x7CB4 },
	{ 0xDF56, 0x7CAF },
	{ 0xDF57, 0x7D88 },
	{ 0xDF58, 0x7D86 },
	{ 0xDF59, 0x7D80 },
	{ 0xDF5A, 0x7D8D },
	{ 0xDF5B, 0x7D7F },
	{ 0xDF5C, 0x7D85 },
	{ 0xDF5D, 0x7D7A },
	{ 0xDF5E, 0x7D8E },
	{ 0xDF5F, 0x7D7B },
	{ 0xDF60, 0x7D83 },
	{ 0xDF61, 0x7D7C },
	{ 0xDF62, 0x7D8C },
	{ 0xDF63, 0x7D94 },
	{ 0xDF64, 0x7D84 },
	{ 0xDF65, 0x7D7D },
	{ 0xDF66, 0x7D92 },
	{ 0xDF67, 0x7F6D },
	{ 0xDF68, 0x7F6B },
	{ 0xDF69, 0x7F67 },
	{ 0xDF6A, 0x7F68 },
	{ 0xDF6B, 0x7F6C },
	{ 0xDF6C, 0x7FA6 },
	{ 0xDF6D, 0x7FA5 },
	{ 0xDF6E, 0x7FA7 },
	{ 0xDF6F, 0x7FDB },
	{ 0xDF70, 0x7FDC },
	{ 0xDF71, 0x8021 },
	{ 0xDF72, 0x8164 },
	{ 0xDF73, 0x8160 },
	{ 0xDF74, 0x8177 },
	{ 0xDF75, 0x815C },
	{ 0xDF76, 0x8169 },
	{ 0xDF77, 0x815B },
	{ 0xDF78, 0x8162 },
	{ 0xDF79, 0x8172 },
	{ 0xDF7A, 0x6721 },
	{ 0xDF7B, 0x815E },
	{ 0xDF7C, 0x8176 },
	{ 0xDF7D, 0x8167 },
	{ 0xDF7E, 0x816F },
	{ 0xDF7F, 0xFFFD },
	{ 0xDF80, 0x66D5 },
	{ 0xDF81, 0x66D0 },
	{ 0xDF82, 0x66D1 },
	{ 0xDF83, 0x66CE },
	{ 0xDF84, 0x66D7 },
	{ 0xDF85, 0x6A7D },
	{ 0xDF86, 0x6A8A },
	{ 0xDF87, 0x6AA7 },
	{ 0xDF88, 0x6A99 },
	{ 0xDF89, 0x6A82 },
	{ 0xDF8A, 0x6A88 },
	{ 0xDF8B, 0x6A86 },
	{ 0xDF8C, 0x6A98 },
	{ 0xDF8D, 0x6A9D },
	{ 0xDF8E, 0x6A8F },
	{ 0xDF8F, 0x6AAA },
	{ 0xDF90, 0x6B5D },
	{ 0xDF91, 0x6C0A },
	{ 0xDF92, 0x6FD7 },
	{ 0xDF93, 0x6FD6 },
	{ 0xDF94, 0x6FE5 },
	{ 0xDF95, 0x6FD9 },
	{ 0xDF96, 0x6FDA },
	{ 0xDF97, 0x6FEA },
	{ 0xDF98, 0x6FF6 },
	{ 0xDF99, 0x71E3 },
	{ 0xDF9A, 0x71E9 },
	{ 0xDF9B, 0x71EB },
	{ 0xDF9C, 0x71EF },
	{ 0xDF9D, 0x71F3 },
	{ 0xDF9E, 0x71EA },
	{ 0xDF9F, 0x7371 },
	{ 0xDFA0, 0x74AE },
	{ 0xDFA1, 0x8144 },
	{ 0xDFA2, 0x8161 },
	{ 0xDFA3, 0x821D },
	{ 0xDFA4, 0x8249 },
	{ 0xDFA5, 0x8244 },
	{ 0xDFA6, 0x8240 },
	{ 0xDFA7, 0x8242 },
	{ 0xDFA8, 0x8245 },
	{ 0xDFA9, 0x84F1 },
	{ 0xDFAA, 0x843F },
	{ 0xDFAB, 0x8456 },
	{ 0xDFAC, 0x8476 },
	{ 0xDFAD, 0x8479 },
	{ 0xDFAE, 0x848F },
	{ 0xDFAF, 0x848D },
	{ 0xDFB0, 0x8465 },
	{ 0xDFB1, 0x8451 },
	{ 0xDFB2, 0x8440 },
	{ 0xDFB3, 0x8486 },
	{ 0xDFB4, 0x8467 },
	{ 0xDFB5, 0x8430 },
	{ 0xDFB6, 0x844D },
	{ 0xDFB7, 0x847D },
	{ 0xDFB8, 0x845A },
	{ 0xDFB9, 0x8459 },
	{ 0xDFBA, 0x8474 },
	{ 0xDFBB, 0x8473 },
	{ 0xDFBC, 0x845D },
	{ 0xDFBD, 0x8507 },
	{ 0xDFBE, 0x845E },
	{ 0xDFBF, 0x8437 },
	{ 0xDFC0, 0x843A },
	{ 0xDFC1, 0x8434 },
	{ 0xDFC2, 0x847A },
	{ 0xDFC3, 0x8443 },
	{ 0xDFC4, 0x8478 },
	{ 0xDFC5, 0x8432 },
	{ 0xDFC6, 0x8445 },
	{ 0xDFC7, 0x8429 },
	{ 0xDFC8, 0x83D9 },
	{ 0xDFC9, 0x844B },
	{ 0xDFCA, 0x842F },
	{ 0xDFCB, 0x8442 },
	{ 0xDFCC, 0x842D },
	{ 0xDFCD, 0x845F },
	{ 0xDFCE, 0x8470 },
	{ 0xDFCF, 0x8439 },
	{ 0xDFD0, 0x844E },
	{ 0xDFD1, 0x844C },
	{ 0xDFD2, 0x8452 },
	{ 0xDFD3, 0x846F },
	{ 0xDFD4, 0x84C5 },
	{ 0xDFD5, 0x848E },
	{ 0xDFD6, 0x843B },
	{ 0xDFD7, 0x8447 },
	{ 0xDFD8, 0x8436 },
	{ 0xDFD9, 0x8433 },
	{ 0xDFDA, 0x8468 },
	{ 0xDFDB, 0x847E },
	{ 0xDFDC, 0x8444 },
	{ 0xDFDD, 0x842B },
	{ 0xDFDE, 0x8460 },
	{ 0xDFDF, 0x8454 },
	{ 0xDFE0, 0x846E },
	{ 0xDFE1, 0x8450 },
	{ 0xDFE2, 0x870B },
	{ 0xDFE3, 0x8704 },
	{ 0xDFE4, 0x86F7 },
	{ 0xDFE5, 0x870C },
	{ 0xDFE6, 0x86FA },
	{ 0xDFE7, 0x86D6 },
	{ 0xDFE8, 0x86F5 },
	{ 0xDFE9, 0x874D },
	{ 0xDFEA, 0x86F8 },
	{ 0xDFEB, 0x870E },
	{ 0xDFEC, 0x8709 },
	{ 0xDFED, 0x8701 },
	{ 0xDFEE, 0x86F6 },
	{ 0xDFEF, 0x870D },
	{ 0xDFF0, 0x8705 },
	{ 0xDFF1, 0x88D6 },
	{ 0xDFF2, 0x88CB },
	{ 0xDFF3, 0x88CD },
	{ 0xDFF4, 0x88CE },
	{ 0xDFF5, 0x88DE },
	{ 0xDFF6, 0x88DB },
	{ 0xDFF7, 0x88DA },
	{ 0xDFF8, 0x88CC },
	{ 0xDFF9, 0x88D0 },
	{ 0xDFFA, 0x8985 },
	{ 0xDFFB, 0x899B },
	{ 0xDFFC, 0x89DF },
	{ 0xDFFD, 0x89E5 },
	{ 0xDFFE, 0x89E4 },
	{ 0xE040, 0x89E1 },
	{ 0xE041, 0x89E0 },
	{ 0xE042, 0x89E2 },
	{ 0xE043, 0x89DC },
	{ 0xE044, 0x89E6 },
	{ 0xE045, 0x8A76 },
	{ 0xE046, 0x8A86 },
	{ 0xE047, 0x8A7F },
	{ 0xE048, 0x8A61 },
	{ 0xE049, 0x8A3F },
	{ 0xE04A, 0x8A77 },
	{ 0xE04B, 0x8A82 },
	{ 0xE04C, 0x8A84 },
	{ 0xE04D, 0x8A75 },
	{ 0xE04E, 0x8A83 },
	{ 0xE04F, 0x8A81 },
	{ 0xE050, 0x8A74 },
	{ 0xE051, 0x8A7A },
	{ 0xE052, 0x8C3C },
	{ 0xE053, 0x8C4B },
	{ 0xE054, 0x8C4A },
	{ 0xE055, 0x8C65 },
	{ 0xE056, 0x8C64 },
	{ 0xE057, 0x8C66 },
	{ 0xE058, 0x8C86 },
	{ 0xE059, 0x8C84 },
	{ 0xE05A, 0x8C85 },
	{ 0xE05B, 0x8CCC },
	{ 0xE05C, 0x8D68 },
	{ 0xE05D, 0x8D69 },
	{ 0xE05E, 0x8D91 },
	{ 0xE05F, 0x8D8C },
	{ 0xE060, 0x8D8E },
	{ 0xE061, 0x8D8F },
	{ 0xE062, 0x8D8D },
	{ 0xE063, 0x8D93 },
	{ 0xE064, 0x8D94 },
	{ 0xE065, 0x8D90 },
	{ 0xE066, 0x8D92 },
	{ 0xE067, 0x8DF0 },
	{ 0xE068, 0x8DE0 },
	{ 0xE069, 0x8DEC },
	{ 0xE06A, 0x8DF1 },
	{ 0xE06B, 0x8DEE },
	{ 0xE06C, 0x8DD0 },
	{ 0xE06D, 0x8DE9 },
	{ 0xE06E, 0x8DE3 },
	{ 0xE06F, 0x8DE2 },
	{ 0xE070, 0x8DE7 },
	{ 0xE071, 0x8DF2 },
	{ 0xE072, 0x8DEB },
	{ 0xE073, 0x8DF4 },
	{ 0xE074, 0x8F06 },
	{ 0xE075, 0x8EFF },
	{ 0xE076, 0x8F01 },
	{ 0xE077, 0x8F00 },
	{ 0xE078, 0x8F05 },
	{ 0xE079, 0x8F07 },
	{ 0xE07A, 0x8F08 },
	{ 0xE07B, 0x8F02 },
	{ 0xE07C, 0x8F0B },
	{ 0xE07D, 0x9052 },
	{ 0xE07E, 0x903F },
	{ 0xE07F, 0xFFFD },
	{ 0xE080, 0x74B3 },
	{ 0xE081, 0x74AC },
	{ 0xE082, 0x7583 },
	{ 0xE083, 0x7645 },
	{ 0xE084, 0x764E },
	{ 0xE085, 0x7644 },
	{ 0xE086, 0x76A3 },
	{ 0xE087, 0x76A5 },
	{ 0xE088, 0x77A6 },
	{ 0xE089, 0x77A4 },
	{ 0xE08A, 0x77A9 },
	{ 0xE08B, 0x77AF },
	{ 0xE08C, 0x78F0 },
	{ 0xE08D, 0x78F8 },
	{ 0xE08E, 0x78F1 },
	{ 0xE08F, 0x7A49 },
	{ 0xE090, 0x7AC2 },
	{ 0xE091, 0x7AF2 },
	{ 0xE092, 0x7AF3 },
	{ 0xE093, 0x7BFA },
	{ 0xE094, 0x7BF6 },
	{ 0xE095, 0x7BFC },
	{ 0xE096, 0x7C18 },
	{ 0xE097, 0x7C08 },
	{ 0xE098, 0x7C12 },
	{ 0xE099, 0x7CDB },
	{ 0xE09A, 0x7CDA },
	{ 0xE09B, 0x7E2C },
	{ 0xE09C, 0x7E4D },
	{ 0xE09D, 0x7F46 },
	{ 0xE09E, 0x7FF6 },
	{ 0xE09F, 0x802B },
	{ 0xE0A0, 0x8074 },
	{ 0xE0A1, 0x9044 },
	{ 0xE0A2, 0x9049 },
	{ 0xE0A3, 0x903D },
	{ 0xE0A4, 0x9110 },
	{ 0xE0A5, 0x910D },
	{ 0xE0A6, 0x910F },
	{ 0xE0A7, 0x9111 },
	{ 0xE0A8, 0x9116 },
	{ 0xE0A9, 0x9114 },
	{ 0xE0AA, 0x910B },
	{ 0xE0AB, 0x910E },
	{ 0xE0AC, 0x916E },
	{ 0xE0AD, 0x916F },
	{ 0xE0AE, 0x9248 },
	{ 0xE0AF, 0x9252 },
	{ 0xE0B0, 0x9230 },
	{ 0xE0B1, 0x923A },
	{ 0xE0B2, 0x9266 },
	{ 0xE0B3, 0x9233 },
	{ 0xE0B4, 0x9265 },
	{ 0xE0B5, 0x925E },
	{ 0xE0B6, 0x9283 },
	{ 0xE0B7, 0x922E },
	{ 0xE0B8, 0x924A },
	{ 0xE0B9, 0x9246 },
	{ 0xE0BA, 0x926D },
	{ 0xE0BB, 0x926C },
	{ 0xE0BC, 0x924F },
	{ 0xE0BD, 0x9260 },
	{ 0xE0BE, 0x9267 },
	{ 0xE0BF, 0x926F },
	{ 0xE0C0, 0x9236 },
	{ 0xE0C1, 0x9261 },
	{ 0xE0C2, 0x9270 },
	{ 0xE0C3, 0x9231 },
	{ 0xE0C4, 0x9254 },
	{ 0xE0C5, 0x9263 },
	{ 0xE0C6, 0x9250 },
	{ 0xE0C7, 0x9272 },
	{ 0xE0C8, 0x924E },
	{ 0xE0C9, 0x9253 },
	{ 0xE0CA, 0x924C },
	{ 0xE0CB, 0x9256 },
	{ 0xE0CC, 0x9232 },
	{ 0xE0CD, 0x959F },
	{ 0xE0CE, 0x959C },
	{ 0xE0CF, 0x959E },
	{ 0xE0D0, 0x959B },
	{ 0xE0D1, 0x9692 },
	{ 0xE0D2, 0x9693 },
	{ 0xE0D3, 0x9691 },
	{ 0xE0D4, 0x9697 },
	{ 0xE0D5, 0x96CE },
	{ 0xE0D6, 0x96FA },
	{ 0xE0D7, 0x96FD },
	{ 0xE0D8, 0x96F8 },
	{ 0xE0D9, 0x96F5 },
	{ 0xE0DA, 0x9773 },
	{ 0xE0DB, 0x9777 },
	{ 0xE0DC, 0x9778 },
	{ 0xE0DD, 0x9772 },
	{ 0xE0DE, 0x980F },
	{ 0xE0DF, 0x980D },
	{ 0xE0E0, 0x980E },
	{ 0xE0E1, 0x98AC },
	{ 0xE0E2, 0x98F6 },
	{ 0xE0E3, 0x98F9 },
	{ 0xE0E4, 0x99AF },
	{ 0xE0E5, 0x99B2 },
	{ 0xE0E6, 0x99B0 },
	{ 0xE0E7, 0x99B5 },
	{ 0xE0E8, 0x9AAD },
	{ 0xE0E9, 0x9AAB },
	{ 0xE0EA, 0x9B5B },
	{ 0xE0EB, 0x9CEA },
	{ 0xE0EC, 0x9CED },
	{ 0xE0ED, 0x9CE7 },
	{ 0xE0EE, 0x9E80 },
	{ 0xE0EF, 0x9EFD },
	{ 0xE0F0, 0x50E6 },
	{ 0xE0F1, 0x50D4 },
	{ 0xE0F2, 0x50D7 },
	{ 0xE0F3, 0x50E8 },
	{ 0xE0F4, 0x50F3 },
	{ 0xE0F5, 0x50DB },
	{ 0xE0F6, 0x50EA },
	{ 0xE0F7, 0x50DD },
	{ 0xE0F8, 0x50E4 },
	{ 0xE0F9, 0x50D3 },
	{ 0xE0FA, 0x50EC },
	{ 0xE0FB, 0x50F0 },
	{ 0xE0FC, 0x50EF },
	{ 0xE0FD, 0x50E3 },
	{ 0xE0FE, 0x50E0 },
	{ 0xE140, 0x51D8 },
	{ 0xE141, 0x5280 },
	{ 0xE142, 0x5281 },
	{ 0xE143, 0x52E9 },
	{ 0xE144, 0x52EB },
	{ 0xE145, 0x5330 },
	{ 0xE146, 0x53AC },
	{ 0xE147, 0x5627 },
	{ 0xE148, 0x5615 },
	{ 0xE149, 0x560C },
	{ 0xE14A, 0x5612 },
	{ 0xE14B, 0x55FC },
	{ 0xE14C, 0x560F },
	{ 0xE14D, 0x561C },
	{ 0xE14E, 0x5601 },
	{ 0xE14F, 0x5613 },
	{ 0xE150, 0x5602 },
	{ 0xE151, 0x55FA },
	{ 0xE152, 0x561D },
	{ 0xE153, 0x5604 },
	{ 0xE154, 0x55FF },
	{ 0xE155, 0x55F9 },
	{ 0xE156, 0x5889 },
	{ 0xE157, 0x587C },
	{ 0xE158, 0x5890 },
	{ 0xE159, 0x5898 },
	{ 0xE15A, 0x5886 },
	{ 0xE15B, 0x5881 },
	{ 0xE15C, 0x587F },
	{ 0xE15D, 0x5874 },
	{ 0xE15E, 0x588B },
	{ 0xE15F, 0x587A },
	{ 0xE160, 0x5887 },
	{ 0xE161, 0x5891 },
	{ 0xE162, 0x588E },
	{ 0xE163, 0x5876 },
	{ 0xE164, 0x5882 },
	{ 0xE165, 0x5888 },
	{ 0xE166, 0x587B },
	{ 0xE167, 0x5894 },
	{ 0xE168, 0x588F },
	{ 0xE169, 0x58FE },
	{ 0xE16A, 0x596B },
	{ 0xE16B, 0x5ADC },
	{ 0xE16C, 0x5AEE },
	{ 0xE16D, 0x5AE5 },
	{ 0xE16E, 0x5AD5 },
	{ 0xE16F, 0x5AEA },
	{ 0xE170, 0x5ADA },
	{ 0xE171, 0x5AED },
	{ 0xE172, 0x5AEB },
	{ 0xE173, 0x5AF3 },
	{ 0xE174, 0x5AE2 },
	{ 0xE175, 0x5AE0 },
	{ 0xE176, 0x5ADB },
	{ 0xE177, 0x5AEC },
	{ 0xE178, 0x5ADE },
	{ 0xE179, 0x5ADD },
	{ 0xE17A, 0x5AD9 },
	{ 0xE17B, 0x5AE8 },
	{ 0xE17C, 0x5ADF },
	{ 0xE17D, 0x5B77 },
	{ 0xE17E, 0x5BE0 },
	{ 0xE17F, 0xFFFD },
	{ 0xE180, 0x81B8 },
	{ 0xE181, 0x81C8 },
	{ 0xE182, 0x8592 },
	{ 0xE183, 0x8593 },
	{ 0xE184, 0x857F },
	{ 0xE185, 0x85AB },
	{ 0xE186, 0x8597 },
	{ 0xE187, 0x85AC },
	{ 0xE188, 0x87CE },
	{ 0xE189, 0x87CD },
	{ 0xE18A, 0x87C1 },
	{ 0xE18B, 0x87B1 },
	{ 0xE18C, 0x87C7 },
	{ 0xE18D, 0x8940 },
	{ 0xE18E, 0x893F },
	{ 0xE18F, 0x8939 },
	{ 0xE190, 0x8943 },
	{ 0xE191, 0x89AB },
	{ 0xE192, 0x8B1F },
	{ 0xE193, 0x8B09 },
	{ 0xE194, 0x8B0C },
	{ 0xE195, 0x8C40 },
	{ 0xE196, 0x8C96 },
	{ 0xE197, 0x8CF6 },
	{ 0xE198, 0x8CF7 },
	{ 0xE199, 0x8E46 },
	{ 0xE19A, 0x8E4F },
	{ 0xE19B, 0x8F3D },
	{ 0xE19C, 0x8F41 },
	{ 0xE19D, 0x9366 },
	{ 0xE19E, 0x9378 },
	{ 0xE19F, 0x935D },
	{ 0xE1A0, 0x9369 },
	{ 0xE1A1, 0x5BE3 },
	{ 0xE1A2, 0x5C63 },
	{ 0xE1A3, 0x5D82 },
	{ 0xE1A4, 0x5D80 },
	{ 0xE1A5, 0x5D7D },
	{ 0xE1A6, 0x5D86 },
	{ 0xE1A7, 0x5D7A },
	{ 0xE1A8, 0x5D81 },
	{ 0xE1A9, 0x5D77 },
	{ 0xE1AA, 0x5D8A },
	{ 0xE1AB, 0x5D89 },
	{ 0xE1AC, 0x5D88 },
	{ 0xE1AD, 0x5D7E },
	{ 0xE1AE, 0x5D7C },
	{ 0xE1AF, 0x5D8D },
	{ 0xE1B0, 0x5D79 },
	{ 0xE1B1, 0x5D7F },
	{ 0xE1B2, 0x5E58 },
	{ 0xE1B3, 0x5E59 },
	{ 0xE1B4, 0x5E53 },
	{ 0xE1B5, 0x5ED8 },
	{ 0xE1B6, 0x5ED1 },
	{ 0xE1B7, 0x5ED7 },
	{ 0xE1B8, 0x5ECE },
	{ 0xE1B9, 0x5EDC },
	{ 0xE1BA, 0x5ED5 },
	{ 0xE1BB, 0x5ED9 },
	{ 0xE1BC, 0x5ED2 },
	{ 0xE1BD, 0x5ED4 },
	{ 0xE1BE, 0x5F44 },
	{ 0xE1BF, 0x5F43 },
	{ 0xE1C0, 0x5F6F },
	{ 0xE1C1, 0x5FB6 },
	{ 0xE1C2, 0x612C },
	{ 0xE1C3, 0x6128 },
	{ 0xE1C4, 0x6141 },
	{ 0xE1C5, 0x615E },
	{ 0xE1C6, 0x6171 },
	{ 0xE1C7, 0x6173 },
	{ 0xE1C8, 0x6152 },
	{ 0xE1C9, 0x6153 },
	{ 0xE1CA, 0x6172 },
	{ 0xE1CB, 0x616C },
	{ 0xE1CC, 0x6180 },
	{ 0xE1CD, 0x6174 },
	{ 0xE1CE, 0x6154 },
	{ 0xE1CF, 0x617A },
	{ 0xE1D0, 0x615B },
	{ 0xE1D1, 0x6165 },
	{ 0xE1D2, 0x613B },
	{ 0xE1D3, 0x616A },
	{ 0xE1D4, 0x6161 },
	{ 0xE1D5, 0x6156 },
	{ 0xE1D6, 0x6229 },
	{ 0xE1D7, 0x6227 },
	{ 0xE1D8, 0x622B },
	{ 0xE1D9, 0x642B },
	{ 0xE1DA, 0x644D },
	{ 0xE1DB, 0x645B },
	{ 0xE1DC, 0x645D },
	{ 0xE1DD, 0x6474 },
	{ 0xE1DE, 0x6476 },
	{ 0xE1DF, 0x6472 },
	{ 0xE1E0, 0x6473 },
	{ 0xE1E1, 0x647D },
	{ 0xE1E2, 0x6475 },
	{ 0xE1E3, 0x6466 },
	{ 0xE1E4, 0x64A6 },
	{ 0xE1E5, 0x644E },
	{ 0xE1E6, 0x6482 },
	{ 0xE1E7, 0x645E },
	{ 0xE1E8, 0x645C },
	{ 0xE1E9, 0x644B },
	{ 0xE1EA, 0x6453 },
	{ 0xE1EB, 0x6460 },
	{ 0xE1EC, 0x6450 },
	{ 0xE1ED, 0x647F },
	{ 0xE1EE, 0x643F },
	{ 0xE1EF, 0x646C },
	{ 0xE1F0, 0x646B },
	{ 0xE1F1, 0x6459 },
	{ 0xE1F2, 0x6465 },
	{ 0xE1F3, 0x6477 },
	{ 0xE1F4, 0x6573 },
	{ 0xE1F5, 0x65A0 },
	{ 0xE1F6, 0x66A1 },
	{ 0xE1F7, 0x66A0 },
	{ 0xE1F8, 0x669F },
	{ 0xE1F9, 0x6705 },
	{ 0xE1FA, 0x6704 },
	{ 0xE1FB, 0x6722 },
	{ 0xE1FC, 0x69B1 },
	{ 0xE1FD, 0x69B6 },
	{ 0xE1FE, 0x69C9 },
	{ 0xE240, 0x69A0 },
	{ 0xE241, 0x69CE },
	{ 0xE242, 0x6996 },
	{ 0xE243, 0x69B0 },
	{ 0xE244, 0x69AC },
	{ 0xE245, 0x69BC },
	{ 0xE246, 0x6991 },
	{ 0xE247, 0x6999 },
	{ 0xE248, 0x698E },
	{ 0xE249, 0x69A7 },
	{ 0xE24A, 0x698D },
	{ 0xE24B, 0x69A9 },
	{ 0xE24C, 0x69BE },
	{ 0xE24D, 0x69AF },
	{ 0xE24E, 0x69BF },
	{ 0xE24F, 0x69C4 },
	{ 0xE250, 0x69BD },
	{ 0xE251, 0x69A4 },
	{ 0xE252, 0x69D4 },
	{ 0xE253, 0x69B9 },
	{ 0xE254, 0x69CA },
	{ 0xE255, 0x699A },
	{ 0xE256, 0x69CF },
	{ 0xE257, 0x69B3 },
	{ 0xE258, 0x6993 },
	{ 0xE259, 0x69AA },
	{ 0xE25A, 0x69A1 },
	{ 0xE25B, 0x699E },
	{ 0xE25C, 0x69D9 },
	{ 0xE25D, 0x6997 },
	{ 0xE25E, 0x6990 },
	{ 0xE25F, 0x69C2 },
	{ 0xE260, 0x69B5 },
	{ 0xE261, 0x69A5 },
	{ 0xE262, 0x69C6 },
	{ 0xE263, 0x6B4A },
	{ 0xE264, 0x6B4D },
	{ 0xE265, 0x6B4B },
	{ 0xE266, 0x6B9E },
	{ 0xE267, 0x6B9F },
	{ 0xE268, 0x6BA0 },
	{ 0xE269, 0x6BC3 },
	{ 0xE26A, 0x6BC4 },
	{ 0xE26B, 0x6BFE },
	{ 0xE26C, 0x6ECE },
	{ 0xE26D, 0x6EF5 },
	{ 0xE26E, 0x6EF1 },
	{ 0xE26F, 0x6F03 },
	{ 0xE270, 0x6F25 },
	{ 0xE271, 0x6EF8 },
	{ 0xE272, 0x6F37 },
	{ 0xE273, 0x6EFB },
	{ 0xE274, 0x6F2E },
	{ 0xE275, 0x6F09 },
	{ 0xE276, 0x6F4E },
	{ 0xE277, 0x6F19 },
	{ 0xE278, 0x6F1A },
	{ 0xE279, 0x6F27 },
	{ 0xE27A, 0x6F18 },
	{ 0xE27B, 0x6F3B },
	{ 0xE27C, 0x6F12 },
	{ 0xE27D, 0x6EED },
	{ 0xE27E, 0x6F0A },
	{ 0xE27F, 0xFFFD },
	{ 0xE280, 0x9374 },
	{ 0xE281, 0x937D },
	{ 0xE282, 0x936E },
	{ 0xE283, 0x9372 },
	{ 0xE284, 0x9373 },
	{ 0xE285, 0x9362 },
	{ 0xE286, 0x9348 },
	{ 0xE287, 0x9353 },
	{ 0xE288, 0x935F },
	{ 0xE289, 0x9368 },
	{ 0xE28A, 0x937F },
	{ 0xE28B, 0x936B },
	{ 0xE28C, 0x95C4 },
	{ 0xE28D, 0x96AF },
	{ 0xE28E, 0x96AD },
	{ 0xE28F, 0x96B2 },
	{ 0xE290, 0x971A },
	{ 0xE291, 0x971B },
	{ 0xE292, 0x979B },
	{ 0xE293, 0x979F },
	{ 0xE294, 0x9840 },
	{ 0xE295, 0x9847 },
	{ 0xE296, 0x98B7 },
	{ 0xE297, 0x99A2 },
	{ 0xE298, 0x9A00 },
	{ 0xE299, 0x99F3 },
	{ 0xE29A, 0x99F5 },
	{ 0xE29B, 0x9ABD },
	{ 0xE29C, 0x9B00 },
	{ 0xE29D, 0x9B02 },
	{ 0xE29E, 0x9B34 },
	{ 0xE29F, 0x9B49 },
	{ 0xE2A0, 0x9B9F },
	{ 0xE2A1, 0x6F36 },
	{ 0xE2A2, 0x6F73 },
	{ 0xE2A3, 0x6EF9 },
	{ 0xE2A4, 0x6EEE },
	{ 0xE2A5, 0x6F2D },
	{ 0xE2A6, 0x6F40 },
	{ 0xE2A7, 0x6F30 },
	{ 0xE2A8, 0x6F3C },
	{ 0xE2A9, 0x6F35 },
	{ 0xE2AA, 0x6EEB },
	{ 0xE2AB, 0x6F07 },
	{ 0xE2AC, 0x6F0E },
	{ 0xE2AD, 0x6F43 },
	{ 0xE2AE, 0x6F05 },
	{ 0xE2AF, 0x6EFD },
	{ 0xE2B0, 0x6EF6 },
	{ 0xE2B1, 0x6F39 },
	{ 0xE2B2, 0x6F1C },
	{ 0xE2B3, 0x6EFC },
	{ 0xE2B4, 0x6F3A },
	{ 0xE2B5, 0x6F1F },
	{ 0xE2B6, 0x6F0D },
	{ 0xE2B7, 0x6F1E },
	{ 0xE2B8, 0x6F08 },
	{ 0xE2B9, 0x6F21 },
	{ 0xE2BA, 0x7187 },
	{ 0xE2BB, 0x7190 },
	{ 0xE2BC, 0x7189 },
	{ 0xE2BD, 0x7180 },
	{ 0xE2BE, 0x7185 },
	{ 0xE2BF, 0x7182 },
	{ 0xE2C0, 0x718F },
	{ 0xE2C1, 0x717B },
	{ 0xE2C2, 0x7186 },
	{ 0xE2C3, 0x7181 },
	{ 0xE2C4, 0x7197 },
	{ 0xE2C5, 0x7244 },
	{ 0xE2C6, 0x7253 },
	{ 0xE2C7, 0x7297 },
	{ 0xE2C8, 0x7295 },
	{ 0xE2C9, 0x7293 },
	{ 0xE2CA, 0x7343 },
	{ 0xE2CB, 0x734D },
	{ 0xE2CC, 0x7351 },
	{ 0xE2CD, 0x734C },
	{ 0xE2CE, 0x7462 },
	{ 0xE2CF, 0x7473 },
	{ 0xE2D0, 0x7471 },
	{ 0xE2D1, 0x7475 },
	{ 0xE2D2, 0x7472 },
	{ 0xE2D3, 0x7467 },
	{ 0xE2D4, 0x746E },
	{ 0xE2D5, 0x7500 },
	{ 0xE2D6, 0x7502 },
	{ 0xE2D7, 0x7503 },
	{ 0xE2D8, 0x757D },
	{ 0xE2D9, 0x7590 },
	{ 0xE2DA, 0x7616 },
	{ 0xE2DB, 0x7608 },
	{ 0xE2DC, 0x760C },
	{ 0xE2DD, 0x7615 },
	{ 0xE2DE, 0x7611 },
	{ 0xE2DF, 0x760A },
	{ 0xE2E0, 0x7614 },
	{ 0xE2E1, 0x76B8 },
	{ 0xE2E2, 0x7781 },
	{ 0xE2E3, 0x777C },
	{ 0xE2E4, 0x7785 },
	{ 0xE2E5, 0x7782 },
	{ 0xE2E6, 0x776E },
	{ 0xE2E7, 0x7780 },
	{ 0xE2E8, 0x776F },
	{ 0xE2E9, 0x777E },
	{ 0xE2EA, 0x7783 },
	{ 0xE2EB, 0x78B2 },
	{ 0xE2EC, 0x78AA },
	{ 0xE2ED, 0x78B4 },
	{ 0xE2EE, 0x78AD },
	{ 0xE2EF, 0x78A8 },
	{ 0xE2F0, 0x787E },
	{ 0xE2F1, 0x78AB },
	{ 0xE2F2, 0x789E },
	{ 0xE2F3, 0x78A5 },
	{ 0xE2F4, 0x78A0 },
	{ 0xE2F5, 0x78AC },
	{ 0xE2F6, 0x78A2 },
	{ 0xE2F7, 0x78A4 },
	{ 0xE2F8, 0x7998 },
	{ 0xE2F9, 0x798A },
	{ 0xE2FA, 0x798B },
	{ 0xE2FB, 0x7996 },
	{ 0xE2FC, 0x7995 },
	{ 0xE2FD, 0x7994 },
	{ 0xE2FE, 0x7993 },
	{ 0xE340, 0x7997 },
	{ 0xE341, 0x7988 },
	{ 0xE342, 0x7992 },
	{ 0xE343, 0x7990 },
	{ 0xE344, 0x7A2B },
	{ 0xE345, 0x7A4A },
	{ 0xE346, 0x7A30 },
	{ 0xE347, 0x7A2F },
	{ 0xE348, 0x7A28 },
	{ 0xE349, 0x7A26 },
	{ 0xE34A, 0x7AA8 },
	{ 0xE34B, 0x7AAB },
	{ 0xE34C, 0x7AAC },
	{ 0xE34D, 0x7AEE },
	{ 0xE34E, 0x7B88 },
	{ 0xE34F, 0x7B9C },
	{ 0xE350, 0x7B8A },
	{ 0xE351, 0x7B91 },
	{ 0xE352, 0x7B90 },
	{ 0xE353, 0x7B96 },
	{ 0xE354, 0x7B8D },
	{ 0xE355, 0x7B8C },
	{ 0xE356, 0x7B9B },
	{ 0xE357, 0x7B8E },
	{ 0xE358, 0x7B85 },
	{ 0xE359, 0x7B98 },
	{ 0xE35A, 0x5284 },
	{ 0xE35B, 0x7B99 },
	{ 0xE35C, 0x7BA4 },
	{ 0xE35D, 0x7B82 },
	{ 0xE35E, 0x7CBB },
	{ 0xE35F, 0x7CBF },
	{ 0xE360, 0x7CBC },
	{ 0xE361, 0x7CBA },
	{ 0xE362, 0x7DA7 },
	{ 0xE363, 0x7DB7 },
	{ 0xE364, 0x7DC2 },
	{ 0xE365, 0x7DA3 },
	{ 0xE366, 0x7DAA },
	{ 0xE367, 0x7DC1 },
	{ 0xE368, 0x7DC0 },
	{ 0xE369, 0x7DC5 },
	{ 0xE36A, 0x7D9D },
	{ 0xE36B, 0x7DCE },
	{ 0xE36C, 0x7DC4 },
	{ 0xE36D, 0x7DC6 },
	{ 0xE36E, 0x7DCB },
	{ 0xE36F, 0x7DCC },
	{ 0xE370, 0x7DAF },
	{ 0xE371, 0x7DB9 },
	{ 0xE372, 0x7D96 },
	{ 0xE373, 0x7DBC },
	{ 0xE374, 0x7D9F },
	{ 0xE375, 0x7DA6 },
	{ 0xE376, 0x7DAE },
	{ 0xE377, 0x7DA9 },
	{ 0xE378, 0x7DA1 },
	{ 0xE379, 0x7DC9 },
	{ 0xE37A, 0x7F73 },
	{ 0xE37B, 0x7FE2 },
	{ 0xE37C, 0x7FE3 },
	{ 0xE37D, 0x7FE5 },
	{ 0xE37E, 0x7FDE },
	{ 0xE37F, 0xFFFD },
	{ 0xE380, 0x9BA3 },
	{ 0xE381, 0x9BCD },
	{ 0xE382, 0x9B99 },
	{ 0xE383, 0x9B9D },
	{ 0xE384, 0x9D39 },
	{ 0xE385, 0x9D44 },
	{ 0xE386, 0x9D35 },
	{ 0xE387, 0x9EAF },
	{ 0xE388, 0x512F },
	{ 0xE389, 0x9F8E },
	{ 0xE38A, 0x569F },
	{ 0xE38B, 0x569B },
	{ 0xE38C, 0x569E },
	{ 0xE38D, 0x5696 },
	{ 0xE38E, 0x5694 },
	{ 0xE38F, 0x56A0 },
	{ 0xE390, 0x5B3B },
	{ 0xE391, 0x5B3A },
	{ 0xE392, 0x5DC1 },
	{ 0xE393, 0x5F4D },
	{ 0xE394, 0x5F5D },
	{ 0xE395, 0x61F3 },
	{ 0xE396, 0x64F6 },
	{ 0xE397, 0x64E5 },
	{ 0xE398, 0x64EA },
	{ 0xE399, 0x64E7 },
	{ 0xE39A, 0x6505 },
	{ 0xE39B, 0x64F9 },
	{ 0xE39C, 0x6AAB },
	{ 0xE39D, 0x6AED },
	{ 0xE39E, 0x6AB2 },
	{ 0xE39F, 0x6AB0 },
	{ 0xE3A0, 0x6AB5 },
	{ 0xE3A1, 0x8024 },
	{ 0xE3A2, 0x805D },
	{ 0xE3A3, 0x805C },
	{ 0xE3A4, 0x8189 },
	{ 0xE3A5, 0x8186 },
	{ 0xE3A6, 0x8183 },
	{ 0xE3A7, 0x8187 },
	{ 0xE3A8, 0x818D },
	{ 0xE3A9, 0x818C },
	{ 0xE3AA, 0x818B },
	{ 0xE3AB, 0x8215 },
	{ 0xE3AC, 0x8497 },
	{ 0xE3AD, 0x84A4 },
	{ 0xE3AE, 0x84A1 },
	{ 0xE3AF, 0x849F },
	{ 0xE3B0, 0x84BA },
	{ 0xE3B1, 0x84CE },
	{ 0xE3B2, 0x84C2 },
	{ 0xE3B3, 0x84AC },
	{ 0xE3B4, 0x84AE },
	{ 0xE3B5, 0x84AB },
	{ 0xE3B6, 0x84B9 },
	{ 0xE3B7, 0x84B4 },
	{ 0xE3B8, 0x84C1 },
	{ 0xE3B9, 0x84CD },
	{ 0xE3BA, 0x84AA },
	{ 0xE3BB, 0x849A },
	{ 0xE3BC, 0x84B1 },
	{ 0xE3BD, 0x84D0 },
	{ 0xE3BE, 0x849D },
	{ 0xE3BF, 0x84A7 },
	{ 0xE3C0, 0x84BB },
	{ 0xE3C1, 0x84A2 },
	{ 0xE3C2, 0x8494 },
	{ 0xE3C3, 0x84C7 },
	{ 0xE3C4, 0x84CC },
	{ 0xE3C5, 0x849B },
	{ 0xE3C6, 0x84A9 },
	{ 0xE3C7, 0x84AF },
	{ 0xE3C8, 0x84A8 },
	{ 0xE3C9, 0x84D6 },
	{ 0xE3CA, 0x8498 },
	{ 0xE3CB, 0x84B6 },
	{ 0xE3CC, 0x84CF },
	{ 0xE3CD, 0x84A0 },
	{ 0xE3CE, 0x84D7 },
	{ 0xE3CF, 0x84D4 },
	{ 0xE3D0, 0x84D2 },
	{ 0xE3D1, 0x84DB },
	{ 0xE3D2, 0x84B0 },
	{ 0xE3D3, 0x8491 },
	{ 0xE3D4, 0x8661 },
	{ 0xE3D5, 0x8733 },
	{ 0xE3D6, 0x8723 },
	{ 0xE3D7, 0x8728 },
	{ 0xE3D8, 0x876B },
	{ 0xE3D9, 0x8740 },
	{ 0xE3DA, 0x872E },
	{ 0xE3DB, 0x871E },
	{ 0xE3DC, 0x8721 },
	{ 0xE3DD, 0x8719 },
	{ 0xE3DE, 0x871B },
	{ 0xE3DF, 0x8743 },
	{ 0xE3E0, 0x872C },
	{ 0xE3E1, 0x8741 },
	{ 0xE3E2, 0x873E },
	{ 0xE3E3, 0x8746 },
	{ 0xE3E4, 0x8720 },
	{ 0xE3E5, 0x8732 },
	{ 0xE3E6, 0x872A },
	{ 0xE3E7, 0x872D },
	{ 0xE3E8, 0x873C },
	{ 0xE3E9, 0x8712 },
	{ 0xE3EA, 0x873A },
	{ 0xE3EB, 0x8731 },
	{ 0xE3EC, 0x8735 },
	{ 0xE3ED, 0x8742 },
	{ 0xE3EE, 0x8726 },
	{ 0xE3EF, 0x8727 },
	{ 0xE3F0, 0x8738 },
	{ 0xE3F1, 0x8724 },
	{ 0xE3F2, 0x871A },
	{ 0xE3F3, 0x8730 },
	{ 0xE3F4, 0x8711 },
	{ 0xE3F5, 0x88F7 },
	{ 0xE3F6, 0x88E7 },
	{ 0xE3F7, 0x88F1 },
	{ 0xE3F8, 0x88F2 },
	{ 0xE3F9, 0x88FA },
	{ 0xE3FA, 0x88FE },
	{ 0xE3FB, 0x88EE },
	{ 0xE3FC, 0x88FC },
	{ 0xE3FD, 0x88F6 },
	{ 0xE3FE, 0x88FB },
	{ 0xE440, 0x88F0 },
	{ 0xE441, 0x88EC },
	{ 0xE442, 0x88EB },
	{ 0xE443, 0x899D },
	{ 0xE444, 0x89A1 },
	{ 0xE445, 0x899F },
	{ 0xE446, 0x899E },
	{ 0xE447, 0x89E9 },
	{ 0xE448, 0x89EB },
	{ 0xE449, 0x89E8 },
	{ 0xE44A, 0x8AAB },
	{ 0xE44B, 0x8A99 },
	{ 0xE44C, 0x8A8B },
	{ 0xE44D, 0x8A92 },
	{ 0xE44E, 0x8A8F },
	{ 0xE44F, 0x8A96 },
	{ 0xE450, 0x8C3D },
	{ 0xE451, 0x8C68 },
	{ 0xE452, 0x8C69 },
	{ 0xE453, 0x8CD5 },
	{ 0xE454, 0x8CCF },
	{ 0xE455, 0x8CD7 },
	{ 0xE456, 0x8D96 },
	{ 0xE457, 0x8E09 },
	{ 0xE458, 0x8E02 },
	{ 0xE459, 0x8DFF },
	{ 0xE45A, 0x8E0D },
	{ 0xE45B, 0x8DFD },
	{ 0xE45C, 0x8E0A },
	{ 0xE45D, 0x8E03 },
	{ 0xE45E, 0x8E07 },
	{ 0xE45F, 0x8E06 },
	{ 0xE460, 0x8E05 },
	{ 0xE461, 0x8DFE },
	{ 0xE462, 0x8E00 },
	{ 0xE463, 0x8E04 },
	{ 0xE464, 0x8F10 },
	{ 0xE465, 0x8F11 },
	{ 0xE466, 0x8F0E },
	{ 0xE467, 0x8F0D },
	{ 0xE468, 0x9123 },
	{ 0xE469, 0x911C },
	{ 0xE46A, 0x9120 },
	{ 0xE46B, 0x9122 },
	{ 0xE46C, 0x911F },
	{ 0xE46D, 0x911D },
	{ 0xE46E, 0x911A },
	{ 0xE46F, 0x9124 },
	{ 0xE470, 0x9121 },
	{ 0xE471, 0x911B },
	{ 0xE472, 0x917A },
	{ 0xE473, 0x9172 },
	{ 0xE474, 0x9179 },
	{ 0xE475, 0x9173 },
	{ 0xE476, 0x92A5 },
	{ 0xE477, 0x92A4 },
	{ 0xE478, 0x9276 },
	{ 0xE479, 0x929B },
	{ 0xE47A, 0x927A },
	{ 0xE47B, 0x92A0 },
	{ 0xE47C, 0x9294 },
	{ 0xE47D, 0x92AA },
	{ 0xE47E, 0x928D },
	{ 0xE47F, 0xFFFD },
	{ 0xE480, 0x6ABE },
	{ 0xE481, 0x6AC1 },
	{ 0xE482, 0x6AC8 },
	{ 0xE483, 0x6AC0 },
	{ 0xE484, 0x6ABC },
	{ 0xE485, 0x6AB1 },
	{ 0xE486, 0x6AC4 },
	{ 0xE487, 0x6ABF },
	{ 0xE488, 0x7008 },
	{ 0xE489, 0x7003 },
	{ 0xE48A, 0x6FFD },
	{ 0xE48B, 0x7010 },
	{ 0xE48C, 0x7002 },
	{ 0xE48D, 0x7013 },
	{ 0xE48E, 0x71FA },
	{ 0xE48F, 0x7200 },
	{ 0xE490, 0x74B9 },
	{ 0xE491, 0x74BC },
	{ 0xE492, 0x765B },
	{ 0xE493, 0x7651 },
	{ 0xE494, 0x764F },
	{ 0xE495, 0x76EB },
	{ 0xE496, 0x77B8 },
	{ 0xE497, 0x77B9 },
	{ 0xE498, 0x77C1 },
	{ 0xE499, 0x77C0 },
	{ 0xE49A, 0x77BE },
	{ 0xE49B, 0x790B },
	{ 0xE49C, 0x7907 },
	{ 0xE49D, 0x790A },
	{ 0xE49E, 0x7908 },
	{ 0xE49F, 0x790D },
	{ 0xE4A0, 0x7906 },
	{ 0xE4A1, 0x92A6 },
	{ 0xE4A2, 0x929A },
	{ 0xE4A3, 0x92AB },
	{ 0xE4A4, 0x9279 },
	{ 0xE4A5, 0x9297 },
	{ 0xE4A6, 0x927F },
	{ 0xE4A7, 0x92A3 },
	{ 0xE4A8, 0x92EE },
	{ 0xE4A9, 0x928E },
	{ 0xE4AA, 0x9282 },
	{ 0xE4AB, 0x9295 },
	{ 0xE4AC, 0x92A2 },
	{ 0xE4AD, 0x927D },
	{ 0xE4AE, 0x9288 },
	{ 0xE4AF, 0x92A1 },
	{ 0xE4B0, 0x928A },
	{ 0xE4B1, 0x9286 },
	{ 0xE4B2, 0x928C },
	{ 0xE4B3, 0x9299 },
	{ 0xE4B4, 0x92A7 },
	{ 0xE4B5, 0x927E },
	{ 0xE4B6, 0x9287 },
	{ 0xE4B7, 0x92A9 },
	{ 0xE4B8, 0x929D },
	{ 0xE4B9, 0x928B },
	{ 0xE4BA, 0x922D },
	{ 0xE4BB, 0x969E },
	{ 0xE4BC, 0x96A1 },
	{ 0xE4BD, 0x96FF },
	{ 0xE4BE, 0x9758 },
	{ 0xE4BF, 0x977D },
	{ 0xE4C0, 0x977A },
	{ 0xE4C1, 0x977E },
	{ 0xE4C2, 0x9783 },
	{ 0xE4C3, 0x9780 },
	{ 0xE4C4, 0x9782 },
	{ 0xE4C5, 0x977B },
	{ 0xE4C6, 0x9784 },
	{ 0xE4C7, 0x9781 },
	{ 0xE4C8, 0x977F },
	{ 0xE4C9, 0x97CE },
	{ 0xE4CA, 0x97CD },
	{ 0xE4CB, 0x9816 },
	{ 0xE4CC, 0x98AD },
	{ 0xE4CD, 0x98AE },
	{ 0xE4CE, 0x9902 },
	{ 0xE4CF, 0x9900 },
	{ 0xE4D0, 0x9907 },
	{ 0xE4D1, 0x999D },
	{ 0xE4D2, 0x999C },
	{ 0xE4D3, 0x99C3 },
	{ 0xE4D4, 0x99B9 },
	{ 0xE4D5, 0x99BB },
	{ 0xE4D6, 0x99BA },
	{ 0xE4D7, 0x99C2 },
	{ 0xE4D8, 0x99BD },
	{ 0xE4D9, 0x99C7 },
	{ 0xE4DA, 0x9AB1 },
	{ 0xE4DB, 0x9AE3 },
	{ 0xE4DC, 0x9AE7 },
	{ 0xE4DD, 0x9B3E },
	{ 0xE4DE, 0x9B3F },
	{ 0xE4DF, 0x9B60 },
	{ 0xE4E0, 0x9B61 },
	{ 0xE4E1, 0x9B5F },
	{ 0xE4E2, 0x9CF1 },
	{ 0xE4E3, 0x9CF2 },
	{ 0xE4E4, 0x9CF5 },
	{ 0xE4E5, 0x9EA7 },
	{ 0xE4E6, 0x50FF },
	{ 0xE4E7, 0x5103 },
	{ 0xE4E8, 0x5130 },
	{ 0xE4E9, 0x50F8 },
	{ 0xE4EA, 0x5106 },
	{ 0xE4EB, 0x5107 },
	{ 0xE4EC, 0x50F6 },
	{ 0xE4ED, 0x50FE },
	{ 0xE4EE, 0x510B },
	{ 0xE4EF, 0x510C },
	{ 0xE4F0, 0x50FD },
	{ 0xE4F1, 0x510A },
	{ 0xE4F2, 0x528B },
	{ 0xE4F3, 0x528C },
	{ 0xE4F4, 0x52F1 },
	{ 0xE4F5, 0x52EF },
	{ 0xE4F6, 0x5648 },
	{ 0xE4F7, 0x5642 },
	{ 0xE4F8, 0x564C },
	{ 0xE4F9, 0x5635 },
	{ 0xE4FA, 0x5641 },
	{ 0xE4FB, 0x564A },
	{ 0xE4FC, 0x5649 },
	{ 0xE4FD, 0x5646 },
	{ 0xE4FE, 0x5658 },
	{ 0xE540, 0x565A },
	{ 0xE541, 0x5640 },
	{ 0xE542, 0x5633 },
	{ 0xE543, 0x563D },
	{ 0xE544, 0x562C },
	{ 0xE545, 0x563E },
	{ 0xE546, 0x5638 },
	{ 0xE547, 0x562A },
	{ 0xE548, 0x563A },
	{ 0xE549, 0x571A },
	{ 0xE54A, 0x58AB },
	{ 0xE54B, 0x589D },
	{ 0xE54C, 0x58B1 },
	{ 0xE54D, 0x58A0 },
	{ 0xE54E, 0x58A3 },
	{ 0xE54F, 0x58AF },
	{ 0xE550, 0x58AC },
	{ 0xE551, 0x58A5 },
	{ 0xE552, 0x58A1 },
	{ 0xE553, 0x58FF },
	{ 0xE554, 0x5AFF },
	{ 0xE555, 0x5AF4 },
	{ 0xE556, 0x5AFD },
	{ 0xE557, 0x5AF7 },
	{ 0xE558, 0x5AF6 },
	{ 0xE559, 0x5B03 },
	{ 0xE55A, 0x5AF8 },
	{ 0xE55B, 0x5B02 },
	{ 0xE55C, 0x5AF9 },
	{ 0xE55D, 0x5B01 },
	{ 0xE55E, 0x5B07 },
	{ 0xE55F, 0x5B05 },
	{ 0xE560, 0x5B0F },
	{ 0xE561, 0x5C67 },
	{ 0xE562, 0x5D99 },
	{ 0xE563, 0x5D97 },
	{ 0xE564, 0x5D9F },
	{ 0xE565, 0x5D92 },
	{ 0xE566, 0x5DA2 },
	{ 0xE567, 0x5D93 },
	{ 0xE568, 0x5D95 },
	{ 0xE569, 0x5DA0 },
	{ 0xE56A, 0x5D9C },
	{ 0xE56B, 0x5DA1 },
	{ 0xE56C, 0x5D9A },
	{ 0xE56D, 0x5D9E },
	{ 0xE56E, 0x5E69 },
	{ 0xE56F, 0x5E5D },
	{ 0xE570, 0x5E60 },
	{ 0xE571, 0x5E5C },
	{ 0xE572, 0x7DF3 },
	{ 0xE573, 0x5EDB },
	{ 0xE574, 0x5EDE },
	{ 0xE575, 0x5EE1 },
	{ 0xE576, 0x5F49 },
	{ 0xE577, 0x5FB2 },
	{ 0xE578, 0x618B },
	{ 0xE579, 0x6183 },
	{ 0xE57A, 0x6179 },
	{ 0xE57B, 0x61B1 },
	{ 0xE57C, 0x61B0 },
	{ 0xE57D, 0x61A2 },
	{ 0xE57E, 0x6189 },
	{ 0xE57F, 0xFFFD },
	{ 0xE580, 0x7915 },
	{ 0xE581, 0x79AF },
	{ 0xE582, 0x7AF5 },
	{ 0xE583, 0x7C2E },
	{ 0xE584, 0x7C1B },
	{ 0xE585, 0x7C1A },
	{ 0xE586, 0x7C24 },
	{ 0xE587, 0x7CE6 },
	{ 0xE588, 0x7CE3 },
	{ 0xE589, 0x7E5D },
	{ 0xE58A, 0x7E4F },
	{ 0xE58B, 0x7E66 },
	{ 0xE58C, 0x7E5B },
	{ 0xE58D, 0x7F47 },
	{ 0xE58E, 0x7FB4 },
	{ 0xE58F, 0x7FFA },
	{ 0xE590, 0x802E },
	{ 0xE591, 0x81CE },
	{ 0xE592, 0x8219 },
	{ 0xE593, 0x85CC },
	{ 0xE594, 0x85B2 },
	{ 0xE595, 0x85BB },
	{ 0xE596, 0x85C1 },
	{ 0xE597, 0x87E9 },
	{ 0xE598, 0x87EE },
	{ 0xE599, 0x87F0 },
	{ 0xE59A, 0x87D6 },
	{ 0xE59B, 0x880E },
	{ 0xE59C, 0x87DA },
	{ 0xE59D, 0x8948 },
	{ 0xE59E, 0x894A },
	{ 0xE59F, 0x894E },
	{ 0xE5A0, 0x894D },
	{ 0xE5A1, 0x619B },
	{ 0xE5A2, 0x6193 },
	{ 0xE5A3, 0x61AF },
	{ 0xE5A4, 0x61AD },
	{ 0xE5A5, 0x619F },
	{ 0xE5A6, 0x6192 },
	{ 0xE5A7, 0x61AA },
	{ 0xE5A8, 0x61A1 },
	{ 0xE5A9, 0x618D },
	{ 0xE5AA, 0x6166 },
	{ 0xE5AB, 0x61B3 },
	{ 0xE5AC, 0x622D },
	{ 0xE5AD, 0x646E },
	{ 0xE5AE, 0x6470 },
	{ 0xE5AF, 0x6496 },
	{ 0xE5B0, 0x64A0 },
	{ 0xE5B1, 0x6485 },
	{ 0xE5B2, 0x6497 },
	{ 0xE5B3, 0x649C },
	{ 0xE5B4, 0x648F },
	{ 0xE5B5, 0x648B },
	{ 0xE5B6, 0x648A },
	{ 0xE5B7, 0x648C },
	{ 0xE5B8, 0x64A3 },
	{ 0xE5B9, 0x649F },
	{ 0xE5BA, 0x6468 },
	{ 0xE5BB, 0x64B1 },
	{ 0xE5BC, 0x6498 },
	{ 0xE5BD, 0x6576 },
	{ 0xE5BE, 0x657A },
	{ 0xE5BF, 0x6579 },
	{ 0xE5C0, 0x657B },
	{ 0xE5C1, 0x65B2 },
	{ 0xE5C2, 0x65B3 },
	{ 0xE5C3, 0x66B5 },
	{ 0xE5C4, 0x66B0 },
	{ 0xE5C5, 0x66A9 },
	{ 0xE5C6, 0x66B2 },
	{ 0xE5C7, 0x66B7 },
	{ 0xE5C8, 0x66AA },
	{ 0xE5C9, 0x66AF },
	{ 0xE5CA, 0x6A00 },
	{ 0xE5CB, 0x6A06 },
	{ 0xE5CC, 0x6A17 },
	{ 0xE5CD, 0x69E5 },
	{ 0xE5CE, 0x69F8 },
	{ 0xE5CF, 0x6A15 },
	{ 0xE5D0, 0x69F1 },
	{ 0xE5D1, 0x69E4 },
	{ 0xE5D2, 0x6A20 },
	{ 0xE5D3, 0x69FF },
	{ 0xE5D4, 0x69EC },
	{ 0xE5D5, 0x69E2 },
	{ 0xE5D6, 0x6A1B },
	{ 0xE5D7, 0x6A1D },
	{ 0xE5D8, 0x69FE },
	{ 0xE5D9, 0x6A27 },
	{ 0xE5DA, 0x69F2 },
	{ 0xE5DB, 0x69EE },
	{ 0xE5DC, 0x6A14 },
	{ 0xE5DD, 0x69F7 },
	{ 0xE5DE, 0x69E7 },
	{ 0xE5DF, 0x6A40 },
	{ 0xE5E0, 0x6A08 },
	{ 0xE5E1, 0x69E6 },
	{ 0xE5E2, 0x69FB },
	{ 0xE5E3, 0x6A0D },
	{ 0xE5E4, 0x69FC },
	{ 0xE5E5, 0x69EB },
	{ 0xE5E6, 0x6A09 },
	{ 0xE5E7, 0x6A04 },
	{ 0xE5E8, 0x6A18 },
	{ 0xE5E9, 0x6A25 },
	{ 0xE5EA, 0x6A0F },
	{ 0xE5EB, 0x69F6 },
	{ 0xE5EC, 0x6A26 },
	{ 0xE5ED, 0x6A07 },
	{ 0xE5EE, 0x69F4 },
	{ 0xE5EF, 0x6A16 },
	{ 0xE5F0, 0x6B51 },
	{ 0xE5F1, 0x6BA5 },
	{ 0xE5F2, 0x6BA3 },
	{ 0xE5F3, 0x6BA2 },
	{ 0xE5F4, 0x6BA6 },
	{ 0xE5F5, 0x6C01 },
	{ 0xE5F6, 0x6C00 },
	{ 0xE5F7, 0x6BFF },
	{ 0xE5F8, 0x6C02 },
	{ 0xE5F9, 0x6F41 },
	{ 0xE5FA, 0x6F26 },
	{ 0xE5FB, 0x6F7E },
	{ 0xE5FC, 0x6F87 },
	{ 0xE5FD, 0x6FC6 },
	{ 0xE5FE, 0x6F92 },
	{ 0xE640, 0x6F8D },
	{ 0xE641, 0x6F89 },
	{ 0xE642, 0x6F8C },
	{ 0xE643, 0x6F62 },
	{ 0xE644, 0x6F4F },
	{ 0xE645, 0x6F85 },
	{ 0xE646, 0x6F5A },
	{ 0xE647, 0x6F96 },
	{ 0xE648, 0x6F76 },
	{ 0xE649, 0x6F6C },
	{ 0xE64A, 0x6F82 },
	{ 0xE64B, 0x6F55 },
	{ 0xE64C, 0x6F72 },
	{ 0xE64D, 0x6F52 },
	{ 0xE64E, 0x6F50 },
	{ 0xE64F, 0x6F57 },
	{ 0xE650, 0x6F94 },
	{ 0xE651, 0x6F93 },
	{ 0xE652, 0x6F5D },
	{ 0xE653, 0x6F00 },
	{ 0xE654, 0x6F61 },
	{ 0xE655, 0x6F6B },
	{ 0xE656, 0x6F7D },
	{ 0xE657, 0x6F67 },
	{ 0xE658, 0x6F90 },
	{ 0xE659, 0x6F53 },
	{ 0xE65A, 0x6F8B },
	{ 0xE65B, 0x6F69 },
	{ 0xE65C, 0x6F7F },
	{ 0xE65D, 0x6F95 },
	{ 0xE65E, 0x6F63 },
	{ 0xE65F, 0x6F77 },
	{ 0xE660, 0x6F6A },
	{ 0xE661, 0x6F7B },
	{ 0xE662, 0x71B2 },
	{ 0xE663, 0x71AF },
	{ 0xE664, 0x719B },
	{ 0xE665, 0x71B0 },
	{ 0xE666, 0x71A0 },
	{ 0xE667, 0x719A },
	{ 0xE668, 0x71A9 },
	{ 0xE669, 0x71B5 },
	{ 0xE66A, 0x719D },
	{ 0xE66B, 0x71A5 },
	{ 0xE66C, 0x719E },
	{ 0xE66D, 0x71A4 },
	{ 0xE66E, 0x71A1 },
	{ 0xE66F, 0x71AA },
	{ 0xE670, 0x719C },
	{ 0xE671, 0x71A7 },
	{ 0xE672, 0x71B3 },
	{ 0xE673, 0x7298 },
	{ 0xE674, 0x729A },
	{ 0xE675, 0x7358 },
	{ 0xE676, 0x7352 },
	{ 0xE677, 0x735E },
	{ 0xE678, 0x735F },
	{ 0xE679, 0x7360 },
	{ 0xE67A, 0x735D },
	{ 0xE67B, 0x735B },
	{ 0xE67C, 0x7361 },
	{ 0xE67D, 0x735A },
	{ 0xE67E, 0x7359 },
	{ 0xE67F, 0xFFFD },
	{ 0xE680, 0x89B1 },
	{ 0xE681, 0x89B0 },
	{ 0xE682, 0x89B3 },
	{ 0xE683, 0x8B38 },
	{ 0xE684, 0x8B32 },
	{ 0xE685, 0x8B2D },
	{ 0xE686, 0x8B34 },
	{ 0xE687, 0x8B29 },
	{ 0xE688, 0x8C74 },
	{ 0xE689, 0x8D03 },
	{ 0xE68A, 0x8DA9 },
	{ 0xE68B, 0x8E58 },
	{ 0xE68C, 0x8EBF },
	{ 0xE68D, 0x8EC1 },
	{ 0xE68E, 0x8F4A },
	{ 0xE68F, 0x8FAC },
	{ 0xE690, 0x9089 },
	{ 0xE691, 0x913D },
	{ 0xE692, 0x913C },
	{ 0xE693, 0x91A9 },
	{ 0xE694, 0x93A0 },
	{ 0xE695, 0x9390 },
	{ 0xE696, 0x9393 },
	{ 0xE697, 0x938B },
	{ 0xE698, 0x93AD },
	{ 0xE699, 0x93BB },
	{ 0xE69A, 0x93B8 },
	{ 0xE69B, 0x939C },
	{ 0xE69C, 0x95D8 },
	{ 0xE69D, 0x95D7 },
	{ 0xE69E, 0x975D },
	{ 0xE69F, 0x97A9 },
	{ 0xE6A0, 0x97DA },
	{ 0xE6A1, 0x7362 },
	{ 0xE6A2, 0x7487 },
	{ 0xE6A3, 0x7489 },
	{ 0xE6A4, 0x748A },
	{ 0xE6A5, 0x7486 },
	{ 0xE6A6, 0x7481 },
	{ 0xE6A7, 0x747D },
	{ 0xE6A8, 0x7485 },
	{ 0xE6A9, 0x7488 },
	{ 0xE6AA, 0x747C },
	{ 0xE6AB, 0x7479 },
	{ 0xE6AC, 0x7508 },
	{ 0xE6AD, 0x7507 },
	{ 0xE6AE, 0x757E },
	{ 0xE6AF, 0x7625 },
	{ 0xE6B0, 0x761E },
	{ 0xE6B1, 0x7619 },
	{ 0xE6B2, 0x761D },
	{ 0xE6B3, 0x761C },
	{ 0xE6B4, 0x7623 },
	{ 0xE6B5, 0x761A },
	{ 0xE6B6, 0x7628 },
	{ 0xE6B7, 0x761B },
	{ 0xE6B8, 0x769C },
	{ 0xE6B9, 0x769D },
	{ 0xE6BA, 0x769E },
	{ 0xE6BB, 0x769B },
	{ 0xE6BC, 0x778D },
	{ 0xE6BD, 0x778F },
	{ 0xE6BE, 0x7789 },
	{ 0xE6BF, 0x7788 },
	{ 0xE6C0, 0x78CD },
	{ 0xE6C1, 0x78BB },
	{ 0xE6C2, 0x78CF },
	{ 0xE6C3, 0x78CC },
	{ 0xE6C4, 0x78D1 },
	{ 0xE6C5, 0x78CE },
	{ 0xE6C6, 0x78D4 },
	{ 0xE6C7, 0x78C8 },
	{ 0xE6C8, 0x78C3 },
	{ 0xE6C9, 0x78C4 },
	{ 0xE6CA, 0x78C9 },
	{ 0xE6CB, 0x799A },
	{ 0xE6CC, 0x79A1 },
	{ 0xE6CD, 0x79A0 },
	{ 0xE6CE, 0x799C },
	{ 0xE6CF, 0x79A2 },
	{ 0xE6D0, 0x799B },
	{ 0xE6D1, 0x6B76 },
	{ 0xE6D2, 0x7A39 },
	{ 0xE6D3, 0x7AB2 },
	{ 0xE6D4, 0x7AB4 },
	{ 0xE6D5, 0x7AB3 },
	{ 0xE6D6, 0x7BB7 },
	{ 0xE6D7, 0x7BCB },
	{ 0xE6D8, 0x7BBE },
	{ 0xE6D9, 0x7BAC },
	{ 0xE6DA, 0x7BCE },
	{ 0xE6DB, 0x7BAF },
	{ 0xE6DC, 0x7BB9 },
	{ 0xE6DD, 0x7BCA },
	{ 0xE6DE, 0x7BB5 },
	{ 0xE6DF, 0x7CC5 },
	{ 0xE6E0, 0x7CC8 },
	{ 0xE6E1, 0x7CCC },
	{ 0xE6E2, 0x7CCB },
	{ 0xE6E3, 0x7DF7 },
	{ 0xE6E4, 0x7DDB },
	{ 0xE6E5, 0x7DEA },
	{ 0xE6E6, 0x7DE7 },
	{ 0xE6E7, 0x7DD7 },
	{ 0xE6E8, 0x7DE1 },
	{ 0xE6E9, 0x7E03 },
	{ 0xE6EA, 0x7DFA },
	{ 0xE6EB, 0x7DE6 },
	{ 0xE6EC, 0x7DF6 },
	{ 0xE6ED, 0x7DF1 },
	{ 0xE6EE, 0x7DF0 },
	{ 0xE6EF, 0x7DEE },
	{ 0xE6F0, 0x7DDF },
	{ 0xE6F1, 0x7F76 },
	{ 0xE6F2, 0x7FAC },
	{ 0xE6F3, 0x7FB0 },
	{ 0xE6F4, 0x7FAD },
	{ 0xE6F5, 0x7FED },
	{ 0xE6F6, 0x7FEB },
	{ 0xE6F7, 0x7FEA },
	{ 0xE6F8, 0x7FEC },
	{ 0xE6F9, 0x7FE6 },
	{ 0xE6FA, 0x7FE8 },
	{ 0xE6FB, 0x8064 },
	{ 0xE6FC, 0x8067 },
	{ 0xE6FD, 0x81A3 },
	{ 0xE6FE, 0x819F },
	{ 0xE740, 0x819E },
	{ 0xE741, 0x8195 },
	{ 0xE742, 0x81A2 },
	{ 0xE743, 0x8199 },
	{ 0xE744, 0x8197 },
	{ 0xE745, 0x8216 },
	{ 0xE746, 0x824F },
	{ 0xE747, 0x8253 },
	{ 0xE748, 0x8252 },
	{ 0xE749, 0x8250 },
	{ 0xE74A, 0x824E },
	{ 0xE74B, 0x8251 },
	{ 0xE74C, 0x8524 },
	{ 0xE74D, 0x853B },
	{ 0xE74E, 0x850F },
	{ 0xE74F, 0x8500 },
	{ 0xE750, 0x8529 },
	{ 0xE751, 0x850E },
	{ 0xE752, 0x8509 },
	{ 0xE753, 0x850D },
	{ 0xE754, 0x851F },
	{ 0xE755, 0x850A },
	{ 0xE756, 0x8527 },
	{ 0xE757, 0x851C },
	{ 0xE758, 0x84FB },
	{ 0xE759, 0x852B },
	{ 0xE75A, 0x84FA },
	{ 0xE75B, 0x8508 },
	{ 0xE75C, 0x850C },
	{ 0xE75D, 0x84F4 },
	{ 0xE75E, 0x852A },
	{ 0xE75F, 0x84F2 },
	{ 0xE760, 0x8515 },
	{ 0xE761, 0x84F7 },
	{ 0xE762, 0x84EB },
	{ 0xE763, 0x84F3 },
	{ 0xE764, 0x84FC },
	{ 0xE765, 0x8512 },
	{ 0xE766, 0x84EA },
	{ 0xE767, 0x84E9 },
	{ 0xE768, 0x8516 },
	{ 0xE769, 0x84FE },
	{ 0xE76A, 0x8528 },
	{ 0xE76B, 0x851D },
	{ 0xE76C, 0x852E },
	{ 0xE76D, 0x8502 },
	{ 0xE76E, 0x84FD },
	{ 0xE76F, 0x851E },
	{ 0xE770, 0x84F6 },
	{ 0xE771, 0x8531 },
	{ 0xE772, 0x8526 },
	{ 0xE773, 0x84E7 },
	{ 0xE774, 0x84E8 },
	{ 0xE775, 0x84F0 },
	{ 0xE776, 0x84EF },
	{ 0xE777, 0x84F9 },
	{ 0xE778, 0x8518 },
	{ 0xE779, 0x8520 },
	{ 0xE77A, 0x8530 },
	{ 0xE77B, 0x850B },
	{ 0xE77C, 0x8519 },
	{ 0xE77D, 0x852F },
	{ 0xE77E, 0x8662 },
	{ 0xE77F, 0xFFFD },
	{ 0xE780, 0x9854 },
	{ 0xE781, 0x9855 },
	{ 0xE782, 0x984B },
	{ 0xE783, 0x983F },
	{ 0xE784, 0x98B9 },
	{ 0xE785, 0x9938 },
	{ 0xE786, 0x9936 },
	{ 0xE787, 0x9940 },
	{ 0xE788, 0x993B },
	{ 0xE789, 0x9939 },
	{ 0xE78A, 0x99A4 },
	{ 0xE78B, 0x9A08 },
	{ 0xE78C, 0x9A0C },
	{ 0xE78D, 0x9A10 },
	{ 0xE78E, 0x9B07 },
	{ 0xE78F, 0x9BD2 },
	{ 0xE790, 0x9BC2 },
	{ 0xE791, 0x9BBB },
	{ 0xE792, 0x9BCC },
	{ 0xE793, 0x9BCB },
	{ 0xE794, 0x9D4D },
	{ 0xE795, 0x9D63 },
	{ 0xE796, 0x9D4E },
	{ 0xE797, 0x9D50 },
	{ 0xE798, 0x9D55 },
	{ 0xE799, 0x9D5E },
	{ 0xE79A, 0x9E90 },
	{ 0xE79B, 0x9EB2 },
	{ 0xE79C, 0x9EB1 },
	{ 0xE79D, 0x9ECA },
	{ 0xE79E, 0x9F02 },
	{ 0xE79F, 0x9F27 },
	{ 0xE7A0, 0x9F26 },
	{ 0xE7A1, 0x8756 },
	{ 0xE7A2, 0x8763 },
	{ 0xE7A3, 0x8764 },
	{ 0xE7A4, 0x8777 },
	{ 0xE7A5, 0x87E1 },
	{ 0xE7A6, 0x8773 },
	{ 0xE7A7, 0x8758 },
	{ 0xE7A8, 0x8754 },
	{ 0xE7A9, 0x875B },
	{ 0xE7AA, 0x8752 },
	{ 0xE7AB, 0x8761 },
	{ 0xE7AC, 0x875A },
	{ 0xE7AD, 0x8751 },
	{ 0xE7AE, 0x875E },
	{ 0xE7AF, 0x876D },
	{ 0xE7B0, 0x876A },
	{ 0xE7B1, 0x8750 },
	{ 0xE7B2, 0x874E },
	{ 0xE7B3, 0x875F },
	{ 0xE7B4, 0x875D },
	{ 0xE7B5, 0x876F },
	{ 0xE7B6, 0x876C },
	{ 0xE7B7, 0x877A },
	{ 0xE7B8, 0x876E },
	{ 0xE7B9, 0x875C },
	{ 0xE7BA, 0x8765 },
	{ 0xE7BB, 0x874F },
	{ 0xE7BC, 0x877B },
	{ 0xE7BD, 0x8775 },
	{ 0xE7BE, 0x8762 },
	{ 0xE7BF, 0x8767 },
	{ 0xE7C0, 0x8769 },
	{ 0xE7C1, 0x885A },
	{ 0xE7C2, 0x8905 },
	{ 0xE7C3, 0x890C },
	{ 0xE7C4, 0x8914 },
	{ 0xE7C5, 0x890B },
	{ 0xE7C6, 0x8917 },
	{ 0xE7C7, 0x8918 },
	{ 0xE7C8, 0x8919 },
	{ 0xE7C9, 0x8906 },
	{ 0xE7CA, 0x8916 },
	{ 0xE7CB, 0x8911 },
	{ 0xE7CC, 0x890E },
	{ 0xE7CD, 0x8909 },
	{ 0xE7CE, 0x89A2 },
	{ 0xE7CF, 0x89A4 },
	{ 0xE7D0, 0x89A3 },
	{ 0xE7D1, 0x89ED },
	{ 0xE7D2, 0x89F0 },
	{ 0xE7D3, 0x89EC },
	{ 0xE7D4, 0x8ACF },
	{ 0xE7D5, 0x8AC6 },
	{ 0xE7D6, 0x8AB8 },
	{ 0xE7D7, 0x8AD3 },
	{ 0xE7D8, 0x8AD1 },
	{ 0xE7D9, 0x8AD4 },
	{ 0xE7DA, 0x8AD5 },
	{ 0xE7DB, 0x8ABB },
	{ 0xE7DC, 0x8AD7 },
	{ 0xE7DD, 0x8ABE },
	{ 0xE7DE, 0x8AC0 },
	{ 0xE7DF, 0x8AC5 },
	{ 0xE7E0, 0x8AD8 },
	{ 0xE7E1, 0x8AC3 },
	{ 0xE7E2, 0x8ABA },
	{ 0xE7E3, 0x8ABD },
	{ 0xE7E4, 0x8AD9 },
	{ 0xE7E5, 0x8C3E },
	{ 0xE7E6, 0x8C4D },
	{ 0xE7E7, 0x8C8F },
	{ 0xE7E8, 0x8CE5 },
	{ 0xE7E9, 0x8CDF },
	{ 0xE7EA, 0x8CD9 },
	{ 0xE7EB, 0x8CE8 },
	{ 0xE7EC, 0x8CDA },
	{ 0xE7ED, 0x8CDD },
	{ 0xE7EE, 0x8CE7 },
	{ 0xE7EF, 0x8DA0 },
	{ 0xE7F0, 0x8D9C },
	{ 0xE7F1, 0x8DA1 },
	{ 0xE7F2, 0x8D9B },
	{ 0xE7F3, 0x8E20 },
	{ 0xE7F4, 0x8E23 },
	{ 0xE7F5, 0x8E25 },
	{ 0xE7F6, 0x8E24 },
	{ 0xE7F7, 0x8E2E },
	{ 0xE7F8, 0x8E15 },
	{ 0xE7F9, 0x8E1B },
	{ 0xE7FA, 0x8E16 },
	{ 0xE7FB, 0x8E11 },
	{ 0xE7FC, 0x8E19 },
	{ 0xE7FD, 0x8E26 },
	{ 0xE7FE, 0x8E27 },
	{ 0xE840, 0x8E14 },
	{ 0xE841, 0x8E12 },
	{ 0xE842, 0x8E18 },
	{ 0xE843, 0x8E13 },
	{ 0xE844, 0x8E1C },
	{ 0xE845, 0x8E17 },
	{ 0xE846, 0x8E1A },
	{ 0xE847, 0x8F2C },
	{ 0xE848, 0x8F24 },
	{ 0xE849, 0x8F18 },
	{ 0xE84A, 0x8F1A },
	{ 0xE84B, 0x8F20 },
	{ 0xE84C, 0x8F23 },
	{ 0xE84D, 0x8F16 },
	{ 0xE84E, 0x8F17 },
	{ 0xE84F, 0x9073 },
	{ 0xE850, 0x9070 },
	{ 0xE851, 0x906F },
	{ 0xE852, 0x9067 },
	{ 0xE853, 0x906B },
	{ 0xE854, 0x912F },
	{ 0xE855, 0x912B },
	{ 0xE856, 0x9129 },
	{ 0xE857, 0x912A },
	{ 0xE858, 0x9132 },
	{ 0xE859, 0x9126 },
	{ 0xE85A, 0x912E },
	{ 0xE85B, 0x9185 },
	{ 0xE85C, 0x9186 },
	{ 0xE85D, 0x918A },
	{ 0xE85E, 0x9181 },
	{ 0xE85F, 0x9182 },
	{ 0xE860, 0x9184 },
	{ 0xE861, 0x9180 },
	{ 0xE862, 0x92D0 },
	{ 0xE863, 0x92C3 },
	{ 0xE864, 0x92C4 },
	{ 0xE865, 0x92C0 },
	{ 0xE866, 0x92D9 },
	{ 0xE867, 0x92B6 },
	{ 0xE868, 0x92CF },
	{ 0xE869, 0x92F1 },
	{ 0xE86A, 0x92DF },
	{ 0xE86B, 0x92D8 },
	{ 0xE86C, 0x92E9 },
	{ 0xE86D, 0x92D7 },
	{ 0xE86E, 0x92DD },
	{ 0xE86F, 0x92CC },
	{ 0xE870, 0x92EF },
	{ 0xE871, 0x92C2 },
	{ 0xE872, 0x92E8 },
	{ 0xE873, 0x92CA },
	{ 0xE874, 0x92C8 },
	{ 0xE875, 0x92CE },
	{ 0xE876, 0x92E6 },
	{ 0xE877, 0x92CD },
	{ 0xE878, 0x92D5 },
	{ 0xE879, 0x92C9 },
	{ 0xE87A, 0x92E0 },
	{ 0xE87B, 0x92DE },
	{ 0xE87C, 0x92E7 },
	{ 0xE87D, 0x92D1 },
	{ 0xE87E, 0x92D3 },
	{ 0xE87F, 0xFFFD },
	{ 0xE880, 0x56AF },
	{ 0xE881, 0x58E0 },
	{ 0xE882, 0x58DC },
	{ 0xE883, 0x5B39 },
	{ 0xE884, 0x5B7C },
	{ 0xE885, 0x5BF3 },
	{ 0xE886, 0x5C6B },
	{ 0xE887, 0x5DC4 },
	{ 0xE888, 0x650B },
	{ 0xE889, 0x6508 },
	{ 0xE88A, 0x650A },
	{ 0xE88B, 0x65DC },
	{ 0xE88C, 0x66E1 },
	{ 0xE88D, 0x66DF },
	{ 0xE88E, 0x6ACE },
	{ 0xE88F, 0x6AD4 },
	{ 0xE890, 0x6AE3 },
	{ 0xE891, 0x6AD7 },
	{ 0xE892, 0x6AE2 },
	{ 0xE893, 0x6AD8 },
	{ 0xE894, 0x6AD5 },
	{ 0xE895, 0x6AD2 },
	{ 0xE896, 0x701E },
	{ 0xE897, 0x702C },
	{ 0xE898, 0x7025 },
	{ 0xE899, 0x6FF3 },
	{ 0xE89A, 0x7204 },
	{ 0xE89B, 0x7208 },
	{ 0xE89C, 0x7215 },
	{ 0xE89D, 0x74C4 },
	{ 0xE89E, 0x74C9 },
	{ 0xE89F, 0x74C7 },
	{ 0xE8A0, 0x74C8 },
	{ 0xE8A1, 0x92B5 },
	{ 0xE8A2, 0x92E1 },
	{ 0xE8A3, 0x92C6 },
	{ 0xE8A4, 0x92B4 },
	{ 0xE8A5, 0x957C },
	{ 0xE8A6, 0x95AC },
	{ 0xE8A7, 0x95AB },
	{ 0xE8A8, 0x95AE },
	{ 0xE8A9, 0x95B0 },
	{ 0xE8AA, 0x96A4 },
	{ 0xE8AB, 0x96A2 },
	{ 0xE8AC, 0x96D3 },
	{ 0xE8AD, 0x9705 },
	{ 0xE8AE, 0x9708 },
	{ 0xE8AF, 0x9702 },
	{ 0xE8B0, 0x975A },
	{ 0xE8B1, 0x978A },
	{ 0xE8B2, 0x978E },
	{ 0xE8B3, 0x9788 },
	{ 0xE8B4, 0x97D0 },
	{ 0xE8B5, 0x97CF },
	{ 0xE8B6, 0x981E },
	{ 0xE8B7, 0x981D },
	{ 0xE8B8, 0x9826 },
	{ 0xE8B9, 0x9829 },
	{ 0xE8BA, 0x9828 },
	{ 0xE8BB, 0x9820 },
	{ 0xE8BC, 0x981B },
	{ 0xE8BD, 0x9827 },
	{ 0xE8BE, 0x98B2 },
	{ 0xE8BF, 0x9908 },
	{ 0xE8C0, 0x98FA },
	{ 0xE8C1, 0x9911 },
	{ 0xE8C2, 0x9914 },
	{ 0xE8C3, 0x9916 },
	{ 0xE8C4, 0x9917 },
	{ 0xE8C5, 0x9915 },
	{ 0xE8C6, 0x99DC },
	{ 0xE8C7, 0x99CD },
	{ 0xE8C8, 0x99CF },
	{ 0xE8C9, 0x99D3 },
	{ 0xE8CA, 0x99D4 },
	{ 0xE8CB, 0x99CE },
	{ 0xE8CC, 0x99C9 },
	{ 0xE8CD, 0x99D6 },
	{ 0xE8CE, 0x99D8 },
	{ 0xE8CF, 0x99CB },
	{ 0xE8D0, 0x99D7 },
	{ 0xE8D1, 0x99CC },
	{ 0xE8D2, 0x9AB3 },
	{ 0xE8D3, 0x9AEC },
	{ 0xE8D4, 0x9AEB },
	{ 0xE8D5, 0x9AF3 },
	{ 0xE8D6, 0x9AF2 },
	{ 0xE8D7, 0x9AF1 },
	{ 0xE8D8, 0x9B46 },
	{ 0xE8D9, 0x9B43 },
	{ 0xE8DA, 0x9B67 },
	{ 0xE8DB, 0x9B74 },
	{ 0xE8DC, 0x9B71 },
	{ 0xE8DD, 0x9B66 },
	{ 0xE8DE, 0x9B76 },
	{ 0xE8DF, 0x9B75 },
	{ 0xE8E0, 0x9B70 },
	{ 0xE8E1, 0x9B68 },
	{ 0xE8E2, 0x9B64 },
	{ 0xE8E3, 0x9B6C },
	{ 0xE8E4, 0x9CFC },
	{ 0xE8E5, 0x9CFA },
	{ 0xE8E6, 0x9CFD },
	{ 0xE8E7, 0x9CFF },
	{ 0xE8E8, 0x9CF7 },
	{ 0xE8E9, 0x9D07 },
	{ 0xE8EA, 0x9D00 },
	{ 0xE8EB, 0x9CF9 },
	{ 0xE8EC, 0x9CFB },
	{ 0xE8ED, 0x9D08 },
	{ 0xE8EE, 0x9D05 },
	{ 0xE8EF, 0x9D04 },
	{ 0xE8F0, 0x9E83 },
	{ 0xE8F1, 0x9ED3 },
	{ 0xE8F2, 0x9F0F },
	{ 0xE8F3, 0x9F10 },
	{ 0xE8F4, 0x511C },
	{ 0xE8F5, 0x5113 },
	{ 0xE8F6, 0x5117 },
	{ 0xE8F7, 0x511A },
	{ 0xE8F8, 0x5111 },
	{ 0xE8F9, 0x51DE },
	{ 0xE8FA, 0x5334 },
	{ 0xE8FB, 0x53E1 },
	{ 0xE8FC, 0x5670 },
	{ 0xE8FD, 0x5660 },
	{ 0xE8FE, 0x566E },
	{ 0xE940, 0x5673 },
	{ 0xE941, 0x5666 },
	{ 0xE942, 0x5663 },
	{ 0xE943, 0x566D },
	{ 0xE944, 0x5672 },
	{ 0xE945, 0x565E },
	{ 0xE946, 0x5677 },
	{ 0xE947, 0x571C },
	{ 0xE948, 0x571B },
	{ 0xE949, 0x58C8 },
	{ 0xE94A, 0x58BD },
	{ 0xE94B, 0x58C9 },
	{ 0xE94C, 0x58BF },
	{ 0xE94D, 0x58BA },
	{ 0xE94E, 0x58C2 },
	{ 0xE94F, 0x58BC },
	{ 0xE950, 0x58C6 },
	{ 0xE951, 0x5B17 },
	{ 0xE952, 0x5B19 },
	{ 0xE953, 0x5B1B },
	{ 0xE954, 0x5B21 },
	{ 0xE955, 0x5B14 },
	{ 0xE956, 0x5B13 },
	{ 0xE957, 0x5B10 },
	{ 0xE958, 0x5B16 },
	{ 0xE959, 0x5B28 },
	{ 0xE95A, 0x5B1A },
	{ 0xE95B, 0x5B20 },
	{ 0xE95C, 0x5B1E },
	{ 0xE95D, 0x5BEF },
	{ 0xE95E, 0x5DAC },
	{ 0xE95F, 0x5DB1 },
	{ 0xE960, 0x5DA9 },
	{ 0xE961, 0x5DA7 },
	{ 0xE962, 0x5DB5 },
	{ 0xE963, 0x5DB0 },
	{ 0xE964, 0x5DAE },
	{ 0xE965, 0x5DAA },
	{ 0xE966, 0x5DA8 },
	{ 0xE967, 0x5DB2 },
	{ 0xE968, 0x5DAD },
	{ 0xE969, 0x5DAF },
	{ 0xE96A, 0x5DB4 },
	{ 0xE96B, 0x5E67 },
	{ 0xE96C, 0x5E68 },
	{ 0xE96D, 0x5E66 },
	{ 0xE96E, 0x5E6F },
	{ 0xE96F, 0x5EE9 },
	{ 0xE970, 0x5EE7 },
	{ 0xE971, 0x5EE6 },
	{ 0xE972, 0x5EE8 },
	{ 0xE973, 0x5EE5 },
	{ 0xE974, 0x5F4B },
	{ 0xE975, 0x5FBC },
	{ 0xE976, 0x619D },
	{ 0xE977, 0x61A8 },
	{ 0xE978, 0x6196 },
	{ 0xE979, 0x61C5 },
	{ 0xE97A, 0x61B4 },
	{ 0xE97B, 0x61C6 },
	{ 0xE97C, 0x61C1 },
	{ 0xE97D, 0x61CC },
	{ 0xE97E, 0x61BA },
	{ 0xE97F, 0xFFFD },
	{ 0xE980, 0x76A9 },
	{ 0xE981, 0x77C6 },
	{ 0xE982, 0x77C5 },
	{ 0xE983, 0x7918 },
	{ 0xE984, 0x791A },
	{ 0xE985, 0x7920 },
	{ 0xE986, 0x7A66 },
	{ 0xE987, 0x7A64 },
	{ 0xE988, 0x7A6A },
	{ 0xE989, 0x7C35 },
	{ 0xE98A, 0x7C34 },
	{ 0xE98B, 0x7E6C },
	{ 0xE98C, 0x7E6E },
	{ 0xE98D, 0x7E71 },
	{ 0xE98E, 0x81D4 },
	{ 0xE98F, 0x81D6 },
	{ 0xE990, 0x821A },
	{ 0xE991, 0x8262 },
	{ 0xE992, 0x8265 },
	{ 0xE993, 0x8276 },
	{ 0xE994, 0x85DB },
	{ 0xE995, 0x85D6 },
	{ 0xE996, 0x85E7 },
	{ 0xE997, 0x85F4 },
	{ 0xE998, 0x87FD },
	{ 0xE999, 0x87D5 },
	{ 0xE99A, 0x8807 },
	{ 0xE99B, 0x880F },
	{ 0xE99C, 0x87F8 },
	{ 0xE99D, 0x8987 },
	{ 0xE99E, 0x89B5 },
	{ 0xE99F, 0x89F5 },
	{ 0xE9A0, 0x8B3F },
	{ 0xE9A1, 0x61BF },
	{ 0xE9A2, 0x61B8 },
	{ 0xE9A3, 0x618C },
	{ 0xE9A4, 0x64D7 },
	{ 0xE9A5, 0x64D6 },
	{ 0xE9A6, 0x64D0 },
	{ 0xE9A7, 0x64CF },
	{ 0xE9A8, 0x64C9 },
	{ 0xE9A9, 0x64BD },
	{ 0xE9AA, 0x6489 },
	{ 0xE9AB, 0x64C3 },
	{ 0xE9AC, 0x64DB },
	{ 0xE9AD, 0x64F3 },
	{ 0xE9AE, 0x64D9 },
	{ 0xE9AF, 0x6533 },
	{ 0xE9B0, 0x657F },
	{ 0xE9B1, 0x657C },
	{ 0xE9B2, 0x65A2 },
	{ 0xE9B3, 0x66C8 },
	{ 0xE9B4, 0x66BE },
	{ 0xE9B5, 0x66C0 },
	{ 0xE9B6, 0x66CA },
	{ 0xE9B7, 0x66CB },
	{ 0xE9B8, 0x66CF },
	{ 0xE9B9, 0x66BD },
	{ 0xE9BA, 0x66BB },
	{ 0xE9BB, 0x66BA },
	{ 0xE9BC, 0x66CC },
	{ 0xE9BD, 0x6723 },
	{ 0xE9BE, 0x6A34 },
	{ 0xE9BF, 0x6A66 },
	{ 0xE9C0, 0x6A49 },
	{ 0xE9C1, 0x6A67 },
	{ 0xE9C2, 0x6A32 },
	{ 0xE9C3, 0x6A68 },
	{ 0xE9C4, 0x6A3E },
	{ 0xE9C5, 0x6A5D },
	{ 0xE9C6, 0x6A6D },
	{ 0xE9C7, 0x6A76 },
	{ 0xE9C8, 0x6A5B },
	{ 0xE9C9, 0x6A51 },
	{ 0xE9CA, 0x6A28 },
	{ 0xE9CB, 0x6A5A },
	{ 0xE9CC, 0x6A3B },
	{ 0xE9CD, 0x6A3F },
	{ 0xE9CE, 0x6A41 },
	{ 0xE9CF, 0x6A6A },
	{ 0xE9D0, 0x6A64 },
	{ 0xE9D1, 0x6A50 },
	{ 0xE9D2, 0x6A4F },
	{ 0xE9D3, 0x6A54 },
	{ 0xE9D4, 0x6A6F },
	{ 0xE9D5, 0x6A69 },
	{ 0xE9D6, 0x6A60 },
	{ 0xE9D7, 0x6A3C },
	{ 0xE9D8, 0x6A5E },
	{ 0xE9D9, 0x6A56 },
	{ 0xE9DA, 0x6A55 },
	{ 0xE9DB, 0x6A4D },
	{ 0xE9DC, 0x6A4E },
	{ 0xE9DD, 0x6A46 },
	{ 0xE9DE, 0x6B55 },
	{ 0xE9DF, 0x6B54 },
	{ 0xE9E0, 0x6B56 },
	{ 0xE9E1, 0x6BA7 },
	{ 0xE9E2, 0x6BAA },
	{ 0xE9E3, 0x6BAB },
	{ 0xE9E4, 0x6BC8 },
	{ 0xE9E5, 0x6BC7 },
	{ 0xE9E6, 0x6C04 },
	{ 0xE9E7, 0x6C03 },
	{ 0xE9E8, 0x6C06 },
	{ 0xE9E9, 0x6FAD },
	{ 0xE9EA, 0x6FCB },
	{ 0xE9EB, 0x6FA3 },
	{ 0xE9EC, 0x6FC7 },
	{ 0xE9ED, 0x6FBC },
	{ 0xE9EE, 0x6FCE },
	{ 0xE9EF, 0x6FC8 },
	{ 0xE9F0, 0x6F5E },
	{ 0xE9F1, 0x6FC4 },
	{ 0xE9F2, 0x6FBD },
	{ 0xE9F3, 0x6F9E },
	{ 0xE9F4, 0x6FCA },
	{ 0xE9F5, 0x6FA8 },
	{ 0xE9F6, 0x7004 },
	{ 0xE9F7, 0x6FA5 },
	{ 0xE9F8, 0x6FAE },
	{ 0xE9F9, 0x6FBA },
	{ 0xE9FA, 0x6FAC },
	{ 0xE9FB, 0x6FAA },
	{ 0xE9FC, 0x6FCF },
	{ 0xE9FD, 0x6FBF },
	{ 0xE9FE, 0x6FB8 },
	{ 0xEA40, 0x6FA2 },
	{ 0xEA41, 0x6FC9 },
	{ 0xEA42, 0x6FAB },
	{ 0xEA43, 0x6FCD },
	{ 0xEA44, 0x6FAF },
	{ 0xEA45, 0x6FB2 },
	{ 0xEA46, 0x6FB0 },
	{ 0xEA47, 0x71C5 },
	{ 0xEA48, 0x71C2 },
	{ 0xEA49, 0x71BF },
	{ 0xEA4A, 0x71B8 },
	{ 0xEA4B, 0x71D6 },
	{ 0xEA4C, 0x71C0 },
	{ 0xEA4D, 0x71C1 },
	{ 0xEA4E, 0x71CB },
	{ 0xEA4F, 0x71D4 },
	{ 0xEA50, 0x71CA },
	{ 0xEA51, 0x71C7 },
	{ 0xEA52, 0x71CF },
	{ 0xEA53, 0x71BD },
	{ 0xEA54, 0x71D8 },
	{ 0xEA55, 0x71BC },
	{ 0xEA56, 0x71C6 },
	{ 0xEA57, 0x71DA },
	{ 0xEA58, 0x71DB },
	{ 0xEA59, 0x729D },
	{ 0xEA5A, 0x729E },
	{ 0xEA5B, 0x7369 },
	{ 0xEA5C, 0x7366 },
	{ 0xEA5D, 0x7367 },
	{ 0xEA5E, 0x736C },
	{ 0xEA5F, 0x7365 },
	{ 0xEA60, 0x736B },
	{ 0xEA61, 0x736A },
	{ 0xEA62, 0x747F },
	{ 0xEA63, 0x749A },
	{ 0xEA64, 0x74A0 },
	{ 0xEA65, 0x7494 },
	{ 0xEA66, 0x7492 },
	{ 0xEA67, 0x7495 },
	{ 0xEA68, 0x74A1 },
	{ 0xEA69, 0x750B },
	{ 0xEA6A, 0x7580 },
	{ 0xEA6B, 0x762F },
	{ 0xEA6C, 0x762D },
	{ 0xEA6D, 0x7631 },
	{ 0xEA6E, 0x763D },
	{ 0xEA6F, 0x7633 },
	{ 0xEA70, 0x763C },
	{ 0xEA71, 0x7635 },
	{ 0xEA72, 0x7632 },
	{ 0xEA73, 0x7630 },
	{ 0xEA74, 0x76BB },
	{ 0xEA75, 0x76E6 },
	{ 0xEA76, 0x779A },
	{ 0xEA77, 0x779D },
	{ 0xEA78, 0x77A1 },
	{ 0xEA79, 0x779C },
	{ 0xEA7A, 0x779B },
	{ 0xEA7B, 0x77A2 },
	{ 0xEA7C, 0x77A3 },
	{ 0xEA7D, 0x7795 },
	{ 0xEA7E, 0x7799 },
	{ 0xEA7F, 0xFFFD },
	{ 0xEA80, 0x8B43 },
	{ 0xEA81, 0x8B4C },
	{ 0xEA82, 0x8D0B },
	{ 0xEA83, 0x8E6B },
	{ 0xEA84, 0x8E68 },
	{ 0xEA85, 0x8E70 },
	{ 0xEA86, 0x8E75 },
	{ 0xEA87, 0x8E77 },
	{ 0xEA88, 0x8EC3 },
	{ 0xEA89, 0x93E9 },
	{ 0xEA8A, 0x93EA },
	{ 0xEA8B, 0x93CB },
	{ 0xEA8C, 0x93C5 },
	{ 0xEA8D, 0x93C6 },
	{ 0xEA8E, 0x93ED },
	{ 0xEA8F, 0x93D3 },
	{ 0xEA90, 0x93E5 },
	{ 0xEA91, 0x93DB },
	{ 0xEA92, 0x93EB },
	{ 0xEA93, 0x93E0 },
	{ 0xEA94, 0x93C1 },
	{ 0xEA95, 0x95DD },
	{ 0xEA96, 0x97B2 },
	{ 0xEA97, 0x97B4 },
	{ 0xEA98, 0x97B1 },
	{ 0xEA99, 0x97B5 },
	{ 0xEA9A, 0x97F2 },
	{ 0xEA9B, 0x9856 },
	{ 0xEA9C, 0x9944 },
	{ 0xEA9D, 0x9A26 },
	{ 0xEA9E, 0x9A1F },
	{ 0xEA9F, 0x9A18 },
	{ 0xEAA0, 0x9A21 },
	{ 0xEAA1, 0x7797 },
	{ 0xEAA2, 0x78DD },
	{ 0xEAA3, 0x78E9 },
	{ 0xEAA4, 0x78E5 },
	{ 0xEAA5, 0x78EA },
	{ 0xEAA6, 0x78DE },
	{ 0xEAA7, 0x78E3 },
	{ 0xEAA8, 0x78DB },
	{ 0xEAA9, 0x78E1 },
	{ 0xEAAA, 0x78E2 },
	{ 0xEAAB, 0x78ED },
	{ 0xEAAC, 0x78DF },
	{ 0xEAAD, 0x78E0 },
	{ 0xEAAE, 0x79A4 },
	{ 0xEAAF, 0x7A44 },
	{ 0xEAB0, 0x7A48 },
	{ 0xEAB1, 0x7A47 },
	{ 0xEAB2, 0x7AB6 },
	{ 0xEAB3, 0x7AB8 },
	{ 0xEAB4, 0x7AB5 },
	{ 0xEAB5, 0x7AB1 },
	{ 0xEAB6, 0x7AB7 },
	{ 0xEAB7, 0x7BDE },
	{ 0xEAB8, 0x7BE3 },
	{ 0xEAB9, 0x7BE7 },
	{ 0xEABA, 0x7BDD },
	{ 0xEABB, 0x7BD5 },
	{ 0xEABC, 0x7BE5 },
	{ 0xEABD, 0x7BDA },
	{ 0xEABE, 0x7BE8 },
	{ 0xEABF, 0x7BF9 },
	{ 0xEAC0, 0x7BD4 },
	{ 0xEAC1, 0x7BEA },
	{ 0xEAC2, 0x7BE2 },
	{ 0xEAC3, 0x7BDC },
	{ 0xEAC4, 0x7BEB },
	{ 0xEAC5, 0x7BD8 },
	{ 0xEAC6, 0x7BDF },
	{ 0xEAC7, 0x7CD2 },
	{ 0xEAC8, 0x7CD4 },
	{ 0xEAC9, 0x7CD7 },
	{ 0xEACA, 0x7CD0 },
	{ 0xEACB, 0x7CD1 },
	{ 0xEACC, 0x7E12 },
	{ 0xEACD, 0x7E21 },
	{ 0xEACE, 0x7E17 },
	{ 0xEACF, 0x7E0C },
	{ 0xEAD0, 0x7E1F },
	{ 0xEAD1, 0x7E20 },
	{ 0xEAD2, 0x7E13 },
	{ 0xEAD3, 0x7E0E },
	{ 0xEAD4, 0x7E1C },
	{ 0xEAD5, 0x7E15 },
	{ 0xEAD6, 0x7E1A },
	{ 0xEAD7, 0x7E22 },
	{ 0xEAD8, 0x7E0B },
	{ 0xEAD9, 0x7E0F },
	{ 0xEADA, 0x7E16 },
	{ 0xEADB, 0x7E0D },
	{ 0xEADC, 0x7E14 },
	{ 0xEADD, 0x7E25 },
	{ 0xEADE, 0x7E24 },
	{ 0xEADF, 0x7F43 },
	{ 0xEAE0, 0x7F7B },
	{ 0xEAE1, 0x7F7C },
	{ 0xEAE2, 0x7F7A },
	{ 0xEAE3, 0x7FB1 },
	{ 0xEAE4, 0x7FEF },
	{ 0xEAE5, 0x802A },
	{ 0xEAE6, 0x8029 },
	{ 0xEAE7, 0x806C },
	{ 0xEAE8, 0x81B1 },
	{ 0xEAE9, 0x81A6 },
	{ 0xEAEA, 0x81AE },
	{ 0xEAEB, 0x81B9 },
	{ 0xEAEC, 0x81B5 },
	{ 0xEAED, 0x81AB },
	{ 0xEAEE, 0x81B0 },
	{ 0xEAEF, 0x81AC },
	{ 0xEAF0, 0x81B4 },
	{ 0xEAF1, 0x81B2 },
	{ 0xEAF2, 0x81B7 },
	{ 0xEAF3, 0x81A7 },
	{ 0xEAF4, 0x81F2 },
	{ 0xEAF5, 0x8255 },
	{ 0xEAF6, 0x8256 },
	{ 0xEAF7, 0x8257 },
	{ 0xEAF8, 0x8556 },
	{ 0xEAF9, 0x8545 },
	{ 0xEAFA, 0x856B },
	{ 0xEAFB, 0x854D },
	{ 0xEAFC, 0x8553 },
	{ 0xEAFD, 0x8561 },
	{ 0xEAFE, 0x8558 },
	{ 0xEB40, 0x8540 },
	{ 0xEB41, 0x8546 },
	{ 0xEB42, 0x8564 },
	{ 0xEB43, 0x8541 },
	{ 0xEB44, 0x8562 },
	{ 0xEB45, 0x8544 },
	{ 0xEB46, 0x8551 },
	{ 0xEB47, 0x8547 },
	{ 0xEB48, 0x8563 },
	{ 0xEB49, 0x853E },
	{ 0xEB4A, 0x855B },
	{ 0xEB4B, 0x8571 },
	{ 0xEB4C, 0x854E },
	{ 0xEB4D, 0x856E },
	{ 0xEB4E, 0x8575 },
	{ 0xEB4F, 0x8555 },
	{ 0xEB50, 0x8567 },
	{ 0xEB51, 0x8560 },
	{ 0xEB52, 0x858C },
	{ 0xEB53, 0x8566 },
	{ 0xEB54, 0x855D },
	{ 0xEB55, 0x8554 },
	{ 0xEB56, 0x8565 },
	{ 0xEB57, 0x856C },
	{ 0xEB58, 0x8663 },
	{ 0xEB59, 0x8665 },
	{ 0xEB5A, 0x8664 },
	{ 0xEB5B, 0x879B },
	{ 0xEB5C, 0x878F },
	{ 0xEB5D, 0x8797 },
	{ 0xEB5E, 0x8793 },
	{ 0xEB5F, 0x8792 },
	{ 0xEB60, 0x8788 },
	{ 0xEB61, 0x8781 },
	{ 0xEB62, 0x8796 },
	{ 0xEB63, 0x8798 },
	{ 0xEB64, 0x8779 },
	{ 0xEB65, 0x8787 },
	{ 0xEB66, 0x87A3 },
	{ 0xEB67, 0x8785 },
	{ 0xEB68, 0x8790 },
	{ 0xEB69, 0x8791 },
	{ 0xEB6A, 0x879D },
	{ 0xEB6B, 0x8784 },
	{ 0xEB6C, 0x8794 },
	{ 0xEB6D, 0x879C },
	{ 0xEB6E, 0x879A },
	{ 0xEB6F, 0x8789 },
	{ 0xEB70, 0x891E },
	{ 0xEB71, 0x8926 },
	{ 0xEB72, 0x8930 },
	{ 0xEB73, 0x892D },
	{ 0xEB74, 0x892E },
	{ 0xEB75, 0x8927 },
	{ 0xEB76, 0x8931 },
	{ 0xEB77, 0x8922 },
	{ 0xEB78, 0x8929 },
	{ 0xEB79, 0x8923 },
	{ 0xEB7A, 0x892F },
	{ 0xEB7B, 0x892C },
	{ 0xEB7C, 0x891F },
	{ 0xEB7D, 0x89F1 },
	{ 0xEB7E, 0x8AE0 },
	{ 0xEB7F, 0xFFFD },
	{ 0xEB80, 0x9A17 },
	{ 0xEB81, 0x9B09 },
	{ 0xEB82, 0x9BC5 },
	{ 0xEB83, 0x9BDF },
	{ 0xEB84, 0x9BE3 },
	{ 0xEB85, 0x9BE9 },
	{ 0xEB86, 0x9BEE },
	{ 0xEB87, 0x9D66 },
	{ 0xEB88, 0x9D7A },
	{ 0xEB89, 0x9D6E },
	{ 0xEB8A, 0x9D91 },
	{ 0xEB8B, 0x9D83 },
	{ 0xEB8C, 0x9D76 },
	{ 0xEB8D, 0x9D7E },
	{ 0xEB8E, 0x9D6D },
	{ 0xEB8F, 0x9E95 },
	{ 0xEB90, 0x9EE3 },
	{ 0xEB91, 0x9F03 },
	{ 0xEB92, 0x9F04 },
	{ 0xEB93, 0x9F17 },
	{ 0xEB94, 0x5136 },
	{ 0xEB95, 0x5336 },
	{ 0xEB96, 0x5B42 },
	{ 0xEB97, 0x5B44 },
	{ 0xEB98, 0x5B46 },
	{ 0xEB99, 0x5B7E },
	{ 0xEB9A, 0x5DCA },
	{ 0xEB9B, 0x5DC8 },
	{ 0xEB9C, 0x5DCC },
	{ 0xEB9D, 0x5EF0 },
	{ 0xEB9E, 0x6585 },
	{ 0xEB9F, 0x66E5 },
	{ 0xEBA0, 0x66E7 },
	{ 0xEBA1, 0x8AE2 },
	{ 0xEBA2, 0x8AF2 },
	{ 0xEBA3, 0x8AF4 },
	{ 0xEBA4, 0x8AF5 },
	{ 0xEBA5, 0x8ADD },
	{ 0xEBA6, 0x8B14 },
	{ 0xEBA7, 0x8AE4 },
	{ 0xEBA8, 0x8ADF },
	{ 0xEBA9, 0x8AF0 },
	{ 0xEBAA, 0x8AC8 },
	{ 0xEBAB, 0x8ADE },
	{ 0xEBAC, 0x8AE1 },
	{ 0xEBAD, 0x8AE8 },
	{ 0xEBAE, 0x8AFF },
	{ 0xEBAF, 0x8AEF },
	{ 0xEBB0, 0x8AFB },
	{ 0xEBB1, 0x8C91 },
	{ 0xEBB2, 0x8C92 },
	{ 0xEBB3, 0x8C90 },
	{ 0xEBB4, 0x8CF5 },
	{ 0xEBB5, 0x8CEE },
	{ 0xEBB6, 0x8CF1 },
	{ 0xEBB7, 0x8CF0 },
	{ 0xEBB8, 0x8CF3 },
	{ 0xEBB9, 0x8D6C },
	{ 0xEBBA, 0x8D6E },
	{ 0xEBBB, 0x8DA5 },
	{ 0xEBBC, 0x8DA7 },
	{ 0xEBBD, 0x8E33 },
	{ 0xEBBE, 0x8E3E },
	{ 0xEBBF, 0x8E38 },
	{ 0xEBC0, 0x8E40 },
	{ 0xEBC1, 0x8E45 },
	{ 0xEBC2, 0x8E36 },
	{ 0xEBC3, 0x8E3C },
	{ 0xEBC4, 0x8E3D },
	{ 0xEBC5, 0x8E41 },
	{ 0xEBC6, 0x8E30 },
	{ 0xEBC7, 0x8E3F },
	{ 0xEBC8, 0x8EBD },
	{ 0xEBC9, 0x8F36 },
	{ 0xEBCA, 0x8F2E },
	{ 0xEBCB, 0x8F35 },
	{ 0xEBCC, 0x8F32 },
	{ 0xEBCD, 0x8F39 },
	{ 0xEBCE, 0x8F37 },
	{ 0xEBCF, 0x8F34 },
	{ 0xEBD0, 0x9076 },
	{ 0xEBD1, 0x9079 },
	{ 0xEBD2, 0x907B },
	{ 0xEBD3, 0x9086 },
	{ 0xEBD4, 0x90FA },
	{ 0xEBD5, 0x9133 },
	{ 0xEBD6, 0x9135 },
	{ 0xEBD7, 0x9136 },
	{ 0xEBD8, 0x9193 },
	{ 0xEBD9, 0x9190 },
	{ 0xEBDA, 0x9191 },
	{ 0xEBDB, 0x918D },
	{ 0xEBDC, 0x918F },
	{ 0xEBDD, 0x9327 },
	{ 0xEBDE, 0x931E },
	{ 0xEBDF, 0x9308 },
	{ 0xEBE0, 0x931F },
	{ 0xEBE1, 0x9306 },
	{ 0xEBE2, 0x930F },
	{ 0xEBE3, 0x937A },
	{ 0xEBE4, 0x9338 },
	{ 0xEBE5, 0x933C },
	{ 0xEBE6, 0x931B },
	{ 0xEBE7, 0x9323 },
	{ 0xEBE8, 0x9312 },
	{ 0xEBE9, 0x9301 },
	{ 0xEBEA, 0x9346 },
	{ 0xEBEB, 0x932D },
	{ 0xEBEC, 0x930E },
	{ 0xEBED, 0x930D },
	{ 0xEBEE, 0x92CB },
	{ 0xEBEF, 0x931D },
	{ 0xEBF0, 0x92FA },
	{ 0xEBF1, 0x9325 },
	{ 0xEBF2, 0x9313 },
	{ 0xEBF3, 0x92F9 },
	{ 0xEBF4, 0x92F7 },
	{ 0xEBF5, 0x9334 },
	{ 0xEBF6, 0x9302 },
	{ 0xEBF7, 0x9324 },
	{ 0xEBF8, 0x92FF },
	{ 0xEBF9, 0x9329 },
	{ 0xEBFA, 0x9339 },
	{ 0xEBFB, 0x9335 },
	{ 0xEBFC, 0x932A },
	{ 0xEBFD, 0x9314 },
	{ 0xEBFE, 0x930C },
	{ 0xEC40, 0x930B },
	{ 0xEC41, 0x92FE },
	{ 0xEC42, 0x9309 },
	{ 0xEC43, 0x9300 },
	{ 0xEC44, 0x92FB },
	{ 0xEC45, 0x9316 },
	{ 0xEC46, 0x95BC },
	{ 0xEC47, 0x95CD },
	{ 0xEC48, 0x95BE },
	{ 0xEC49, 0x95B9 },
	{ 0xEC4A, 0x95BA },
	{ 0xEC4B, 0x95B6 },
	{ 0xEC4C, 0x95BF },
	{ 0xEC4D, 0x95B5 },
	{ 0xEC4E, 0x95BD },
	{ 0xEC4F, 0x96A9 },
	{ 0xEC50, 0x96D4 },
	{ 0xEC51, 0x970B },
	{ 0xEC52, 0x9712 },
	{ 0xEC53, 0x9710 },
	{ 0xEC54, 0x9799 },
	{ 0xEC55, 0x9797 },
	{ 0xEC56, 0x9794 },
	{ 0xEC57, 0x97F0 },
	{ 0xEC58, 0x97F8 },
	{ 0xEC59, 0x9835 },
	{ 0xEC5A, 0x982F },
	{ 0xEC5B, 0x9832 },
	{ 0xEC5C, 0x9924 },
	{ 0xEC5D, 0x991F },
	{ 0xEC5E, 0x9927 },
	{ 0xEC5F, 0x9929 },
	{ 0xEC60, 0x999E },
	{ 0xEC61, 0x99EE },
	{ 0xEC62, 0x99EC },
	{ 0xEC63, 0x99E5 },
	{ 0xEC64, 0x99E4 },
	{ 0xEC65, 0x99F0 },
	{ 0xEC66, 0x99E3 },
	{ 0xEC67, 0x99EA },
	{ 0xEC68, 0x99E9 },
	{ 0xEC69, 0x99E7 },
	{ 0xEC6A, 0x9AB9 },
	{ 0xEC6B, 0x9ABF },
	{ 0xEC6C, 0x9AB4 },
	{ 0xEC6D, 0x9ABB },
	{ 0xEC6E, 0x9AF6 },
	{ 0xEC6F, 0x9AFA },
	{ 0xEC70, 0x9AF9 },
	{ 0xEC71, 0x9AF7 },
	{ 0xEC72, 0x9B33 },
	{ 0xEC73, 0x9B80 },
	{ 0xEC74, 0x9B85 },
	{ 0xEC75, 0x9B87 },
	{ 0xEC76, 0x9B7C },
	{ 0xEC77, 0x9B7E },
	{ 0xEC78, 0x9B7B },
	{ 0xEC79, 0x9B82 },
	{ 0xEC7A, 0x9B93 },
	{ 0xEC7B, 0x9B92 },
	{ 0xEC7C, 0x9B90 },
	{ 0xEC7D, 0x9B7A },
	{ 0xEC7E, 0x9B95 },
	{ 0xEC7F, 0xFFFD },
	{ 0xEC80, 0x6AF4 },
	{ 0xEC81, 0x6AE9 },
	{ 0xEC82, 0x703D },
	{ 0xEC83, 0x7036 },
	{ 0xEC84, 0x7216 },
	{ 0xEC85, 0x7212 },
	{ 0xEC86, 0x720F },
	{ 0xEC87, 0x7217 },
	{ 0xEC88, 0x7211 },
	{ 0xEC89, 0x720B },
	{ 0xEC8A, 0x74CD },
	{ 0xEC8B, 0x74D0 },
	{ 0xEC8C, 0x74CC },
	{ 0xEC8D, 0x74CE },
	{ 0xEC8E, 0x74D1 },
	{ 0xEC8F, 0x7589 },
	{ 0xEC90, 0x7A6F },
	{ 0xEC91, 0x7C4B },
	{ 0xEC92, 0x7C44 },
	{ 0xEC93, 0x7C55 },
	{ 0xEC94, 0x7E7F },
	{ 0xEC95, 0x8B71 },
	{ 0xEC96, 0x802F },
	{ 0xEC97, 0x807A },
	{ 0xEC98, 0x807B },
	{ 0xEC99, 0x807C },
	{ 0xEC9A, 0x85FC },
	{ 0xEC9B, 0x8610 },
	{ 0xEC9C, 0x8602 },
	{ 0xEC9D, 0x85EE },
	{ 0xEC9E, 0x8603 },
	{ 0xEC9F, 0x860D },
	{ 0xECA0, 0x8613 },
	{ 0xECA1, 0x9B7D },
	{ 0xECA2, 0x9B88 },
	{ 0xECA3, 0x9D25 },
	{ 0xECA4, 0x9D17 },
	{ 0xECA5, 0x9D20 },
	{ 0xECA6, 0x9D1E },
	{ 0xECA7, 0x9D14 },
	{ 0xECA8, 0x9D29 },
	{ 0xECA9, 0x9D1D },
	{ 0xECAA, 0x9D18 },
	{ 0xECAB, 0x9D22 },
	{ 0xECAC, 0x9D10 },
	{ 0xECAD, 0x9D19 },
	{ 0xECAE, 0x9D1F },
	{ 0xECAF, 0x9E88 },
	{ 0xECB0, 0x9E86 },
	{ 0xECB1, 0x9E87 },
	{ 0xECB2, 0x9EAE },
	{ 0xECB3, 0x9EAD },
	{ 0xECB4, 0x9ED5 },
	{ 0xECB5, 0x9ED6 },
	{ 0xECB6, 0x9EFA },
	{ 0xECB7, 0x9F12 },
	{ 0xECB8, 0x9F3D },
	{ 0xECB9, 0x5126 },
	{ 0xECBA, 0x5125 },
	{ 0xECBB, 0x5122 },
	{ 0xECBC, 0x5124 },
	{ 0xECBD, 0x5120 },
	{ 0xECBE, 0x5129 },
	{ 0xECBF, 0x52F4 },
	{ 0xECC0, 0x5693 },
	{ 0xECC1, 0x568C },
	{ 0xECC2, 0x568D },
	{ 0xECC3, 0x5686 },
	{ 0xECC4, 0x5684 },
	{ 0xECC5, 0x5683 },
	{ 0xECC6, 0x567E },
	{ 0xECC7, 0x5682 },
	{ 0xECC8, 0x567F },
	{ 0xECC9, 0x5681 },
	{ 0xECCA, 0x58D6 },
	{ 0xECCB, 0x58D4 },
	{ 0xECCC, 0x58CF },
	{ 0xECCD, 0x58D2 },
	{ 0xECCE, 0x5B2D },
	{ 0xECCF, 0x5B25 },
	{ 0xECD0, 0x5B32 },
	{ 0xECD1, 0x5B23 },
	{ 0xECD2, 0x5B2C },
	{ 0xECD3, 0x5B27 },
	{ 0xECD4, 0x5B26 },
	{ 0xECD5, 0x5B2F },
	{ 0xECD6, 0x5B2E },
	{ 0xECD7, 0x5B7B },
	{ 0xECD8, 0x5BF1 },
	{ 0xECD9, 0x5BF2 },
	{ 0xECDA, 0x5DB7 },
	{ 0xECDB, 0x5E6C },
	{ 0xECDC, 0x5E6A },
	{ 0xECDD, 0x5FBE },
	{ 0xECDE, 0x5FBB },
	{ 0xECDF, 0x61C3 },
	{ 0xECE0, 0x61B5 },
	{ 0xECE1, 0x61BC },
	{ 0xECE2, 0x61E7 },
	{ 0xECE3, 0x61E0 },
	{ 0xECE4, 0x61E5 },
	{ 0xECE5, 0x61E4 },
	{ 0xECE6, 0x61E8 },
	{ 0xECE7, 0x61DE },
	{ 0xECE8, 0x64EF },
	{ 0xECE9, 0x64E9 },
	{ 0xECEA, 0x64E3 },
	{ 0xECEB, 0x64EB },
	{ 0xECEC, 0x64E4 },
	{ 0xECED, 0x64E8 },
	{ 0xECEE, 0x6581 },
	{ 0xECEF, 0x6580 },
	{ 0xECF0, 0x65B6 },
	{ 0xECF1, 0x65DA },
	{ 0xECF2, 0x66D2 },
	{ 0xECF3, 0x6A8D },
	{ 0xECF4, 0x6A96 },
	{ 0xECF5, 0x6A81 },
	{ 0xECF6, 0x6AA5 },
	{ 0xECF7, 0x6A89 },
	{ 0xECF8, 0x6A9F },
	{ 0xECF9, 0x6A9B },
	{ 0xECFA, 0x6AA1 },
	{ 0xECFB, 0x6A9E },
	{ 0xECFC, 0x6A87 },
	{ 0xECFD, 0x6A93 },
	{ 0xECFE, 0x6A8E },
	{ 0xED40, 0x6A95 },
	{ 0xED41, 0x6A83 },
	{ 0xED42, 0x6AA8 },
	{ 0xED43, 0x6AA4 },
	{ 0xED44, 0x6A91 },
	{ 0xED45, 0x6A7F },
	{ 0xED46, 0x6AA6 },
	{ 0xED47, 0x6A9A },
	{ 0xED48, 0x6A85 },
	{ 0xED49, 0x6A8C },
	{ 0xED4A, 0x6A92 },
	{ 0xED4B, 0x6B5B },
	{ 0xED4C, 0x6BAD },
	{ 0xED4D, 0x6C09 },
	{ 0xED4E, 0x6FCC },
	{ 0xED4F, 0x6FA9 },
	{ 0xED50, 0x6FF4 },
	{ 0xED51, 0x6FD4 },
	{ 0xED52, 0x6FE3 },
	{ 0xED53, 0x6FDC },
	{ 0xED54, 0x6FED },
	{ 0xED55, 0x6FE7 },
	{ 0xED56, 0x6FE6 },
	{ 0xED57, 0x6FDE },
	{ 0xED58, 0x6FF2 },
	{ 0xED59, 0x6FDD },
	{ 0xED5A, 0x6FE2 },
	{ 0xED5B, 0x6FE8 },
	{ 0xED5C, 0x71E1 },
	{ 0xED5D, 0x71F1 },
	{ 0xED5E, 0x71E8 },
	{ 0xED5F, 0x71F2 },
	{ 0xED60, 0x71E4 },
	{ 0xED61, 0x71F0 },
	{ 0xED62, 0x71E2 },
	{ 0xED63, 0x7373 },
	{ 0xED64, 0x736E },
	{ 0xED65, 0x736F },
	{ 0xED66, 0x7497 },
	{ 0xED67, 0x74B2 },
	{ 0xED68, 0x74AB },
	{ 0xED69, 0x7490 },
	{ 0xED6A, 0x74AA },
	{ 0xED6B, 0x74AD },
	{ 0xED6C, 0x74B1 },
	{ 0xED6D, 0x74A5 },
	{ 0xED6E, 0x74AF },
	{ 0xED6F, 0x7510 },
	{ 0xED70, 0x7511 },
	{ 0xED71, 0x7512 },
	{ 0xED72, 0x750F },
	{ 0xED73, 0x7584 },
	{ 0xED74, 0x7643 },
	{ 0xED75, 0x7648 },
	{ 0xED76, 0x7649 },
	{ 0xED77, 0x7647 },
	{ 0xED78, 0x76A4 },
	{ 0xED79, 0x76E9 },
	{ 0xED7A, 0x77B5 },
	{ 0xED7B, 0x77AB },
	{ 0xED7C, 0x77B2 },
	{ 0xED7D, 0x77B7 },
	{ 0xED7E, 0x77B6 },
	{ 0xED7F, 0xFFFD },
	{ 0xED80, 0x8608 },
	{ 0xED81, 0x860F },
	{ 0xED82, 0x8818 },
	{ 0xED83, 0x8812 },
	{ 0xED84, 0x8967 },
	{ 0xED85, 0x8965 },
	{ 0xED86, 0x89BB },
	{ 0xED87, 0x8B69 },
	{ 0xED88, 0x8B62 },
	{ 0xED89, 0x8B6E },
	{ 0xED8A, 0x8B61 },
	{ 0xED8B, 0x8B64 },
	{ 0xED8C, 0x8B4D },
	{ 0xED8D, 0x8C51 },
	{ 0xED8E, 0x8E83 },
	{ 0xED8F, 0x8EC6 },
	{ 0xED90, 0x941F },
	{ 0xED91, 0x9404 },
	{ 0xED92, 0x9417 },
	{ 0xED93, 0x9408 },
	{ 0xED94, 0x9405 },
	{ 0xED95, 0x93F3 },
	{ 0xED96, 0x941E },
	{ 0xED97, 0x9402 },
	{ 0xED98, 0x941A },
	{ 0xED99, 0x941B },
	{ 0xED9A, 0x9427 },
	{ 0xED9B, 0x941C },
	{ 0xED9C, 0x96B5 },
	{ 0xED9D, 0x9733 },
	{ 0xED9E, 0x9734 },
	{ 0xED9F, 0x9731 },
	{ 0xEDA0, 0x97B8 },
	{ 0xEDA1, 0x77B4 },
	{ 0xEDA2, 0x77B1 },
	{ 0xEDA3, 0x77A8 },
	{ 0xEDA4, 0x77F0 },
	{ 0xEDA5, 0x78F3 },
	{ 0xEDA6, 0x78FD },
	{ 0xEDA7, 0x7902 },
	{ 0xEDA8, 0x78FB },
	{ 0xEDA9, 0x78FC },
	{ 0xEDAA, 0x78F2 },
	{ 0xEDAB, 0x7905 },
	{ 0xEDAC, 0x78F9 },
	{ 0xEDAD, 0x78FE },
	{ 0xEDAE, 0x7904 },
	{ 0xEDAF, 0x79AB },
	{ 0xEDB0, 0x79A8 },
	{ 0xEDB1, 0x7A5C },
	{ 0xEDB2, 0x7A5B },
	{ 0xEDB3, 0x7A56 },
	{ 0xEDB4, 0x7A58 },
	{ 0xEDB5, 0x7A54 },
	{ 0xEDB6, 0x7A5A },
	{ 0xEDB7, 0x7ABE },
	{ 0xEDB8, 0x7AC0 },
	{ 0xEDB9, 0x7AC1 },
	{ 0xEDBA, 0x7C05 },
	{ 0xEDBB, 0x7C0F },
	{ 0xEDBC, 0x7BF2 },
	{ 0xEDBD, 0x7C00 },
	{ 0xEDBE, 0x7BFF },
	{ 0xEDBF, 0x7BFB },
	{ 0xEDC0, 0x7C0E },
	{ 0xEDC1, 0x7BF4 },
	{ 0xEDC2, 0x7C0B },
	{ 0xEDC3, 0x7BF3 },
	{ 0xEDC4, 0x7C02 },
	{ 0xEDC5, 0x7C09 },
	{ 0xEDC6, 0x7C03 },
	{ 0xEDC7, 0x7C01 },
	{ 0xEDC8, 0x7BF8 },
	{ 0xEDC9, 0x7BFD },
	{ 0xEDCA, 0x7C06 },
	{ 0xEDCB, 0x7BF0 },
	{ 0xEDCC, 0x7BF1 },
	{ 0xEDCD, 0x7C10 },
	{ 0xEDCE, 0x7C0A },
	{ 0xEDCF, 0x7CE8 },
	{ 0xEDD0, 0x7E2D },
	{ 0xEDD1, 0x7E3C },
	{ 0xEDD2, 0x7E42 },
	{ 0xEDD3, 0x7E33 },
	{ 0xEDD4, 0x9848 },
	{ 0xEDD5, 0x7E38 },
	{ 0xEDD6, 0x7E2A },
	{ 0xEDD7, 0x7E49 },
	{ 0xEDD8, 0x7E40 },
	{ 0xEDD9, 0x7E47 },
	{ 0xEDDA, 0x7E29 },
	{ 0xEDDB, 0x7E4C },
	{ 0xEDDC, 0x7E30 },
	{ 0xEDDD, 0x7E3B },
	{ 0xEDDE, 0x7E36 },
	{ 0xEDDF, 0x7E44 },
	{ 0xEDE0, 0x7E3A },
	{ 0xEDE1, 0x7F45 },
	{ 0xEDE2, 0x7F7F },
	{ 0xEDE3, 0x7F7E },
	{ 0xEDE4, 0x7F7D },
	{ 0xEDE5, 0x7FF4 },
	{ 0xEDE6, 0x7FF2 },
	{ 0xEDE7, 0x802C },
	{ 0xEDE8, 0x81BB },
	{ 0xEDE9, 0x81C4 },
	{ 0xEDEA, 0x81CC },
	{ 0xEDEB, 0x81CA },
	{ 0xEDEC, 0x81C5 },
	{ 0xEDED, 0x81C7 },
	{ 0xEDEE, 0x81BC },
	{ 0xEDEF, 0x81E9 },
	{ 0xEDF0, 0x825B },
	{ 0xEDF1, 0x825A },
	{ 0xEDF2, 0x825C },
	{ 0xEDF3, 0x8583 },
	{ 0xEDF4, 0x8580 },
	{ 0xEDF5, 0x858F },
	{ 0xEDF6, 0x85A7 },
	{ 0xEDF7, 0x8595 },
	{ 0xEDF8, 0x85A0 },
	{ 0xEDF9, 0x858B },
	{ 0xEDFA, 0x85A3 },
	{ 0xEDFB, 0x857B },
	{ 0xEDFC, 0x85A4 },
	{ 0xEDFD, 0x859A },
	{ 0xEDFE, 0x859E },
	{ 0xEE40, 0x8577 },
	{ 0xEE41, 0x857C },
	{ 0xEE42, 0x8589 },
	{ 0xEE43, 0x85A1 },
	{ 0xEE44, 0x857A },
	{ 0xEE45, 0x8578 },
	{ 0xEE46, 0x8557 },
	{ 0xEE47, 0x858E },
	{ 0xEE48, 0x8596 },
	{ 0xEE49, 0x8586 },
	{ 0xEE4A, 0x858D },
	{ 0xEE4B, 0x8599 },
	{ 0xEE4C, 0x859D },
	{ 0xEE4D, 0x8581 },
	{ 0xEE4E, 0x85A2 },
	{ 0xEE4F, 0x8582 },
	{ 0xEE50, 0x8588 },
	{ 0xEE51, 0x8585 },
	{ 0xEE52, 0x8579 },
	{ 0xEE53, 0x8576 },
	{ 0xEE54, 0x8598 },
	{ 0xEE55, 0x8590 },
	{ 0xEE56, 0x859F },
	{ 0xEE57, 0x8668 },
	{ 0xEE58, 0x87BE },
	{ 0xEE59, 0x87AA },
	{ 0xEE5A, 0x87AD },
	{ 0xEE5B, 0x87C5 },
	{ 0xEE5C, 0x87B0 },
	{ 0xEE5D, 0x87AC },
	{ 0xEE5E, 0x87B9 },
	{ 0xEE5F, 0x87B5 },
	{ 0xEE60, 0x87BC },
	{ 0xEE61, 0x87AE },
	{ 0xEE62, 0x87C9 },
	{ 0xEE63, 0x87C3 },
	{ 0xEE64, 0x87C2 },
	{ 0xEE65, 0x87CC },
	{ 0xEE66, 0x87B7 },
	{ 0xEE67, 0x87AF },
	{ 0xEE68, 0x87C4 },
	{ 0xEE69, 0x87CA },
	{ 0xEE6A, 0x87B4 },
	{ 0xEE6B, 0x87B6 },
	{ 0xEE6C, 0x87BF },
	{ 0xEE6D, 0x87B8 },
	{ 0xEE6E, 0x87BD },
	{ 0xEE6F, 0x87DE },
	{ 0xEE70, 0x87B2 },
	{ 0xEE71, 0x8935 },
	{ 0xEE72, 0x8933 },
	{ 0xEE73, 0x893C },
	{ 0xEE74, 0x893E },
	{ 0xEE75, 0x8941 },
	{ 0xEE76, 0x8952 },
	{ 0xEE77, 0x8937 },
	{ 0xEE78, 0x8942 },
	{ 0xEE79, 0x89AD },
	{ 0xEE7A, 0x89AF },
	{ 0xEE7B, 0x89AE },
	{ 0xEE7C, 0x89F2 },
	{ 0xEE7D, 0x89F3 },
	{ 0xEE7E, 0x8B1E },
	{ 0xEE7F, 0xFFFD },
	{ 0xEE80, 0x97BA },
	{ 0xEE81, 0x97FC },
	{ 0xEE82, 0x98C3 },
	{ 0xEE83, 0x994D },
	{ 0xEE84, 0x9A2F },
	{ 0xEE85, 0x9AC9 },
	{ 0xEE86, 0x9AC8 },
	{ 0xEE87, 0x9AC4 },
	{ 0xEE88, 0x9B2A },
	{ 0xEE89, 0x9B38 },
	{ 0xEE8A, 0x9B50 },
	{ 0xEE8B, 0x9C0A },
	{ 0xEE8C, 0x9BFB },
	{ 0xEE8D, 0x9C04 },
	{ 0xEE8E, 0x9BFC },
	{ 0xEE8F, 0x9BFE },
	{ 0xEE90, 0x9C02 },
	{ 0xEE91, 0x9BF6 },
	{ 0xEE92, 0x9C1B },
	{ 0xEE93, 0x9BF9 },
	{ 0xEE94, 0x9C15 },
	{ 0xEE95, 0x9C10 },
	{ 0xEE96, 0x9BFF },
	{ 0xEE97, 0x9C00 },
	{ 0xEE98, 0x9C0C },
	{ 0xEE99, 0x9D95 },
	{ 0xEE9A, 0x9DA5 },
	{ 0xEE9B, 0x9E98 },
	{ 0xEE9C, 0x9EC1 },
	{ 0xEE9D, 0x9F5A },
	{ 0xEE9E, 0x5164 },
	{ 0xEE9F, 0x56BB },
	{ 0xEEA0, 0x58E6 },
	{ 0xEEA1, 0x8B18 },
	{ 0xEEA2, 0x8B16 },
	{ 0xEEA3, 0x8B11 },
	{ 0xEEA4, 0x8B05 },
	{ 0xEEA5, 0x8B0B },
	{ 0xEEA6, 0x8B22 },
	{ 0xEEA7, 0x8B0F },
	{ 0xEEA8, 0x8B12 },
	{ 0xEEA9, 0x8B15 },
	{ 0xEEAA, 0x8B07 },
	{ 0xEEAB, 0x8B0D },
	{ 0xEEAC, 0x8B08 },
	{ 0xEEAD, 0x8B06 },
	{ 0xEEAE, 0x8B1C },
	{ 0xEEAF, 0x8B13 },
	{ 0xEEB0, 0x8B1A },
	{ 0xEEB1, 0x8C4F },
	{ 0xEEB2, 0x8C70 },
	{ 0xEEB3, 0x8C72 },
	{ 0xEEB4, 0x8C71 },
	{ 0xEEB5, 0x8C6F },
	{ 0xEEB6, 0x8C95 },
	{ 0xEEB7, 0x8C94 },
	{ 0xEEB8, 0x8CF9 },
	{ 0xEEB9, 0x8D6F },
	{ 0xEEBA, 0x8E4E },
	{ 0xEEBB, 0x8E4D },
	{ 0xEEBC, 0x8E53 },
	{ 0xEEBD, 0x8E50 },
	{ 0xEEBE, 0x8E4C },
	{ 0xEEBF, 0x8E47 },
	{ 0xEEC0, 0x8F43 },
	{ 0xEEC1, 0x8F40 },
	{ 0xEEC2, 0x9085 },
	{ 0xEEC3, 0x907E },
	{ 0xEEC4, 0x9138 },
	{ 0xEEC5, 0x919A },
	{ 0xEEC6, 0x91A2 },
	{ 0xEEC7, 0x919B },
	{ 0xEEC8, 0x9199 },
	{ 0xEEC9, 0x919F },
	{ 0xEECA, 0x91A1 },
	{ 0xEECB, 0x919D },
	{ 0xEECC, 0x91A0 },
	{ 0xEECD, 0x93A1 },
	{ 0xEECE, 0x9383 },
	{ 0xEECF, 0x93AF },
	{ 0xEED0, 0x9364 },
	{ 0xEED1, 0x9356 },
	{ 0xEED2, 0x9347 },
	{ 0xEED3, 0x937C },
	{ 0xEED4, 0x9358 },
	{ 0xEED5, 0x935C },
	{ 0xEED6, 0x9376 },
	{ 0xEED7, 0x9349 },
	{ 0xEED8, 0x9350 },
	{ 0xEED9, 0x9351 },
	{ 0xEEDA, 0x9360 },
	{ 0xEEDB, 0x936D },
	{ 0xEEDC, 0x938F },
	{ 0xEEDD, 0x934C },
	{ 0xEEDE, 0x936A },
	{ 0xEEDF, 0x9379 },
	{ 0xEEE0, 0x9357 },
	{ 0xEEE1, 0x9355 },
	{ 0xEEE2, 0x9352 },
	{ 0xEEE3, 0x934F },
	{ 0xEEE4, 0x9371 },
	{ 0xEEE5, 0x9377 },
	{ 0xEEE6, 0x937B },
	{ 0xEEE7, 0x9361 },
	{ 0xEEE8, 0x935E },
	{ 0xEEE9, 0x9363 },
	{ 0xEEEA, 0x9367 },
	{ 0xEEEB, 0x9380 },
	{ 0xEEEC, 0x934E },
	{ 0xEEED, 0x9359 },
	{ 0xEEEE, 0x95C7 },
	{ 0xEEEF, 0x95C0 },
	{ 0xEEF0, 0x95C9 },
	{ 0xEEF1, 0x95C3 },
	{ 0xEEF2, 0x95C5 },
	{ 0xEEF3, 0x95B7 },
	{ 0xEEF4, 0x96AE },
	{ 0xEEF5, 0x96B0 },
	{ 0xEEF6, 0x96AC },
	{ 0xEEF7, 0x9720 },
	{ 0xEEF8, 0x971F },
	{ 0xEEF9, 0x9718 },
	{ 0xEEFA, 0x971D },
	{ 0xEEFB, 0x9719 },
	{ 0xEEFC, 0x979A },
	{ 0xEEFD, 0x97A1 },
	{ 0xEEFE, 0x979C },
	{ 0xEF40, 0x979E },
	{ 0xEF41, 0x979D },
	{ 0xEF42, 0x97D5 },
	{ 0xEF43, 0x97D4 },
	{ 0xEF44, 0x97F1 },
	{ 0xEF45, 0x9841 },
	{ 0xEF46, 0x9844 },
	{ 0xEF47, 0x984A },
	{ 0xEF48, 0x9849 },
	{ 0xEF49, 0x9845 },
	{ 0xEF4A, 0x9843 },
	{ 0xEF4B, 0x9925 },
	{ 0xEF4C, 0x992B },
	{ 0xEF4D, 0x992C },
	{ 0xEF4E, 0x992A },
	{ 0xEF4F, 0x9933 },
	{ 0xEF50, 0x9932 },
	{ 0xEF51, 0x992F },
	{ 0xEF52, 0x992D },
	{ 0xEF53, 0x9931 },
	{ 0xEF54, 0x9930 },
	{ 0xEF55, 0x9998 },
	{ 0xEF56, 0x99A3 },
	{ 0xEF57, 0x99A1 },
	{ 0xEF58, 0x9A02 },
	{ 0xEF59, 0x99FA },
	{ 0xEF5A, 0x99F4 },
	{ 0xEF5B, 0x99F7 },
	{ 0xEF5C, 0x99F9 },
	{ 0xEF5D, 0x99F8 },
	{ 0xEF5E, 0x99F6 },
	{ 0xEF5F, 0x99FB },
	{ 0xEF60, 0x99FD },
	{ 0xEF61, 0x99FE },
	{ 0xEF62, 0x99FC },
	{ 0xEF63, 0x9A03 },
	{ 0xEF64, 0x9ABE },
	{ 0xEF65, 0x9AFE },
	{ 0xEF66, 0x9AFD },
	{ 0xEF67, 0x9B01 },
	{ 0xEF68, 0x9AFC },
	{ 0xEF69, 0x9B48 },
	{ 0xEF6A, 0x9B9A },
	{ 0xEF6B, 0x9BA8 },
	{ 0xEF6C, 0x9B9E },
	{ 0xEF6D, 0x9B9B },
	{ 0xEF6E, 0x9BA6 },
	{ 0xEF6F, 0x9BA1 },
	{ 0xEF70, 0x9BA5 },
	{ 0xEF71, 0x9BA4 },
	{ 0xEF72, 0x9B86 },
	{ 0xEF73, 0x9BA2 },
	{ 0xEF74, 0x9BA0 },
	{ 0xEF75, 0x9BAF },
	{ 0xEF76, 0x9D33 },
	{ 0xEF77, 0x9D41 },
	{ 0xEF78, 0x9D67 },
	{ 0xEF79, 0x9D36 },
	{ 0xEF7A, 0x9D2E },
	{ 0xEF7B, 0x9D2F },
	{ 0xEF7C, 0x9D31 },
	{ 0xEF7D, 0x9D38 },
	{ 0xEF7E, 0x9D30 },
	{ 0xEF7F, 0xFFFD },
	{ 0xEF80, 0x5B49 },
	{ 0xEF81, 0x5BF7 },
	{ 0xEF82, 0x5DD0 },
	{ 0xEF83, 0x5FC2 },
	{ 0xEF84, 0x6511 },
	{ 0xEF85, 0x6AFF },
	{ 0xEF86, 0x6AFE },
	{ 0xEF87, 0x6AFD },
	{ 0xEF88, 0x6B01 },
	{ 0xEF89, 0x704B },
	{ 0xEF8A, 0x704D },
	{ 0xEF8B, 0x7047 },
	{ 0xEF8C, 0x74D3 },
	{ 0xEF8D, 0x7668 },
	{ 0xEF8E, 0x7667 },
	{ 0xEF8F, 0x77D1 },
	{ 0xEF90, 0x7930 },
	{ 0xEF91, 0x7932 },
	{ 0xEF92, 0x792E },
	{ 0xEF93, 0x9F9D },
	{ 0xEF94, 0x7AC9 },
	{ 0xEF95, 0x7AC8 },
	{ 0xEF96, 0x7C56 },
	{ 0xEF97, 0x7C51 },
	{ 0xEF98, 0x7E85 },
	{ 0xEF99, 0x7E89 },
	{ 0xEF9A, 0x7E8E },
	{ 0xEF9B, 0x7E84 },
	{ 0xEF9C, 0x826A },
	{ 0xEF9D, 0x862B },
	{ 0xEF9E, 0x862F },
	{ 0xEF9F, 0x8628 },
	{ 0xEFA0, 0x8616 },
	{ 0xEFA1, 0x9D45 },
	{ 0xEFA2, 0x9D42 },
	{ 0xEFA3, 0x9D43 },
	{ 0xEFA4, 0x9D3E },
	{ 0xEFA5, 0x9D37 },
	{ 0xEFA6, 0x9D40 },
	{ 0xEFA7, 0x9D3D },
	{ 0xEFA8, 0x7FF5 },
	{ 0xEFA9, 0x9D2D },
	{ 0xEFAA, 0x9E8A },
	{ 0xEFAB, 0x9E89 },
	{ 0xEFAC, 0x9E8D },
	{ 0xEFAD, 0x9EB0 },
	{ 0xEFAE, 0x9EC8 },
	{ 0xEFAF, 0x9EDA },
	{ 0xEFB0, 0x9EFB },
	{ 0xEFB1, 0x9EFF },
	{ 0xEFB2, 0x9F24 },
	{ 0xEFB3, 0x9F23 },
	{ 0xEFB4, 0x9F22 },
	{ 0xEFB5, 0x9F54 },
	{ 0xEFB6, 0x9FA0 },
	{ 0xEFB7, 0x5131 },
	{ 0xEFB8, 0x512D },
	{ 0xEFB9, 0x512E },
	{ 0xEFBA, 0x5698 },
	{ 0xEFBB, 0x569C },
	{ 0xEFBC, 0x5697 },
	{ 0xEFBD, 0x569A },
	{ 0xEFBE, 0x569D },
	{ 0xEFBF, 0x5699 },
	{ 0xEFC0, 0x5970 },
	{ 0xEFC1, 0x5B3C },
	{ 0xEFC2, 0x5C69 },
	{ 0xEFC3, 0x5C6A },
	{ 0xEFC4, 0x5DC0 },
	{ 0xEFC5, 0x5E6D },
	{ 0xEFC6, 0x5E6E },
	{ 0xEFC7, 0x61D8 },
	{ 0xEFC8, 0x61DF },
	{ 0xEFC9, 0x61ED },
	{ 0xEFCA, 0x61EE },
	{ 0xEFCB, 0x61F1 },
	{ 0xEFCC, 0x61EA },
	{ 0xEFCD, 0x61F0 },
	{ 0xEFCE, 0x61EB },
	{ 0xEFCF, 0x61D6 },
	{ 0xEFD0, 0x61E9 },
	{ 0xEFD1, 0x64FF },
	{ 0xEFD2, 0x6504 },
	{ 0xEFD3, 0x64FD },
	{ 0xEFD4, 0x64F8 },
	{ 0xEFD5, 0x6501 },
	{ 0xEFD6, 0x6503 },
	{ 0xEFD7, 0x64FC },
	{ 0xEFD8, 0x6594 },
	{ 0xEFD9, 0x65DB },
	{ 0xEFDA, 0x66DA },
	{ 0xEFDB, 0x66DB },
	{ 0xEFDC, 0x66D8 },
	{ 0xEFDD, 0x6AC5 },
	{ 0xEFDE, 0x6AB9 },
	{ 0xEFDF, 0x6ABD },
	{ 0xEFE0, 0x6AE1 },
	{ 0xEFE1, 0x6AC6 },
	{ 0xEFE2, 0x6ABA },
	{ 0xEFE3, 0x6AB6 },
	{ 0xEFE4, 0x6AB7 },
	{ 0xEFE5, 0x6AC7 },
	{ 0xEFE6, 0x6AB4 },
	{ 0xEFE7, 0x6AAD },
	{ 0xEFE8, 0x6B5E },
	{ 0xEFE9, 0x6BC9 },
	{ 0xEFEA, 0x6C0B },
	{ 0xEFEB, 0x7007 },
	{ 0xEFEC, 0x700C },
	{ 0xEFED, 0x700D },
	{ 0xEFEE, 0x7001 },
	{ 0xEFEF, 0x7005 },
	{ 0xEFF0, 0x7014 },
	{ 0xEFF1, 0x700E },
	{ 0xEFF2, 0x6FFF },
	{ 0xEFF3, 0x7000 },
	{ 0xEFF4, 0x6FFB },
	{ 0xEFF5, 0x7026 },
	{ 0xEFF6, 0x6FFC },
	{ 0xEFF7, 0x6FF7 },
	{ 0xEFF8, 0x700A },
	{ 0xEFF9, 0x7201 },
	{ 0xEFFA, 0x71FF },
	{ 0xEFFB, 0x71F9 },
	{ 0xEFFC, 0x7203 },
	{ 0xEFFD, 0x71FD },
	{ 0xEFFE, 0x7376 },
	{ 0xF040, 0x74B8 },
	{ 0xF041, 0x74C0 },
	{ 0xF042, 0x74B5 },
	{ 0xF043, 0x74C1 },
	{ 0xF044, 0x74BE },
	{ 0xF045, 0x74B6 },
	{ 0xF046, 0x74BB },
	{ 0xF047, 0x74C2 },
	{ 0xF048, 0x7514 },
	{ 0xF049, 0x7513 },
	{ 0xF04A, 0x765C },
	{ 0xF04B, 0x7664 },
	{ 0xF04C, 0x7659 },
	{ 0xF04D, 0x7650 },
	{ 0xF04E, 0x7653 },
	{ 0xF04F, 0x7657 },
	{ 0xF050, 0x765A },
	{ 0xF051, 0x76A6 },
	{ 0xF052, 0x76BD },
	{ 0xF053, 0x76EC },
	{ 0xF054, 0x77C2 },
	{ 0xF055, 0x77BA },
	{ 0xF056, 0x78FF },
	{ 0xF057, 0x790C },
	{ 0xF058, 0x7913 },
	{ 0xF059, 0x7914 },
	{ 0xF05A, 0x7909 },
	{ 0xF05B, 0x7910 },
	{ 0xF05C, 0x7912 },
	{ 0xF05D, 0x7911 },
	{ 0xF05E, 0x79AD },
	{ 0xF05F, 0x79AC },
	{ 0xF060, 0x7A5F },
	{ 0xF061, 0x7C1C },
	{ 0xF062, 0x7C29 },
	{ 0xF063, 0x7C19 },
	{ 0xF064, 0x7C20 },
	{ 0xF065, 0x7C1F },
	{ 0xF066, 0x7C2D },
	{ 0xF067, 0x7C1D },
	{ 0xF068, 0x7C26 },
	{ 0xF069, 0x7C28 },
	{ 0xF06A, 0x7C22 },
	{ 0xF06B, 0x7C25 },
	{ 0xF06C, 0x7C30 },
	{ 0xF06D, 0x7E5C },
	{ 0xF06E, 0x7E50 },
	{ 0xF06F, 0x7E56 },
	{ 0xF070, 0x7E63 },
	{ 0xF071, 0x7E58 },
	{ 0xF072, 0x7E62 },
	{ 0xF073, 0x7E5F },
	{ 0xF074, 0x7E51 },
	{ 0xF075, 0x7E60 },
	{ 0xF076, 0x7E57 },
	{ 0xF077, 0x7E53 },
	{ 0xF078, 0x7FB5 },
	{ 0xF079, 0x7FB3 },
	{ 0xF07A, 0x7FF7 },
	{ 0xF07B, 0x7FF8 },
	{ 0xF07C, 0x8075 },
	{ 0xF07D, 0x81D1 },
	{ 0xF07E, 0x81D2 },
	{ 0xF07F, 0xFFFD },
	{ 0xF080, 0x8615 },
	{ 0xF081, 0x861D },
	{ 0xF082, 0x881A },
	{ 0xF083, 0x89BC },
	{ 0xF084, 0x8B75 },
	{ 0xF085, 0x8B7C },
	{ 0xF086, 0x8D11 },
	{ 0xF087, 0x8D12 },
	{ 0xF088, 0x8F5C },
	{ 0xF089, 0x91BB },
	{ 0xF08A, 0x93F4 },
	{ 0xF08B, 0x942D },
	{ 0xF08C, 0x96E4 },
	{ 0xF08D, 0x9737 },
	{ 0xF08E, 0x9736 },
	{ 0xF08F, 0x9767 },
	{ 0xF090, 0x97BE },
	{ 0xF091, 0x97BD },
	{ 0xF092, 0x97E2 },
	{ 0xF093, 0x9868 },
	{ 0xF094, 0x9866 },
	{ 0xF095, 0x98C8 },
	{ 0xF096, 0x98CA },
	{ 0xF097, 0x98C7 },
	{ 0xF098, 0x98DC },
	{ 0xF099, 0x994F },
	{ 0xF09A, 0x99A9 },
	{ 0xF09B, 0x9A3C },
	{ 0xF09C, 0x9A3B },
	{ 0xF09D, 0x9ACE },
	{ 0xF09E, 0x9B14 },
	{ 0xF09F, 0x9B53 },
	{ 0xF0A0, 0x9C2E },
	{ 0xF0A1, 0x81D0 },
	{ 0xF0A2, 0x825F },
	{ 0xF0A3, 0x825E },
	{ 0xF0A4, 0x85B4 },
	{ 0xF0A5, 0x85C6 },
	{ 0xF0A6, 0x85C0 },
	{ 0xF0A7, 0x85C3 },
	{ 0xF0A8, 0x85C2 },
	{ 0xF0A9, 0x85B3 },
	{ 0xF0AA, 0x85B5 },
	{ 0xF0AB, 0x85BD },
	{ 0xF0AC, 0x85C7 },
	{ 0xF0AD, 0x85C4 },
	{ 0xF0AE, 0x85BF },
	{ 0xF0AF, 0x85CB },
	{ 0xF0B0, 0x85CE },
	{ 0xF0B1, 0x85C8 },
	{ 0xF0B2, 0x85C5 },
	{ 0xF0B3, 0x85B1 },
	{ 0xF0B4, 0x85B6 },
	{ 0xF0B5, 0x85D2 },
	{ 0xF0B6, 0x8624 },
	{ 0xF0B7, 0x85B8 },
	{ 0xF0B8, 0x85B7 },
	{ 0xF0B9, 0x85BE },
	{ 0xF0BA, 0x8669 },
	{ 0xF0BB, 0x87E7 },
	{ 0xF0BC, 0x87E6 },
	{ 0xF0BD, 0x87E2 },
	{ 0xF0BE, 0x87DB },
	{ 0xF0BF, 0x87EB },
	{ 0xF0C0, 0x87EA },
	{ 0xF0C1, 0x87E5 },
	{ 0xF0C2, 0x87DF },
	{ 0xF0C3, 0x87F3 },
	{ 0xF0C4, 0x87E4 },
	{ 0xF0C5, 0x87D4 },
	{ 0xF0C6, 0x87DC },
	{ 0xF0C7, 0x87D3 },
	{ 0xF0C8, 0x87ED },
	{ 0xF0C9, 0x87D8 },
	{ 0xF0CA, 0x87E3 },
	{ 0xF0CB, 0x87A4 },
	{ 0xF0CC, 0x87D7 },
	{ 0xF0CD, 0x87D9 },
	{ 0xF0CE, 0x8801 },
	{ 0xF0CF, 0x87F4 },
	{ 0xF0D0, 0x87E8 },
	{ 0xF0D1, 0x87DD },
	{ 0xF0D2, 0x8953 },
	{ 0xF0D3, 0x894B },
	{ 0xF0D4, 0x894F },
	{ 0xF0D5, 0x894C },
	{ 0xF0D6, 0x8946 },
	{ 0xF0D7, 0x8950 },
	{ 0xF0D8, 0x8951 },
	{ 0xF0D9, 0x8949 },
	{ 0xF0DA, 0x8B2A },
	{ 0xF0DB, 0x8B27 },
	{ 0xF0DC, 0x8B23 },
	{ 0xF0DD, 0x8B33 },
	{ 0xF0DE, 0x8B30 },
	{ 0xF0DF, 0x8B35 },
	{ 0xF0E0, 0x8B47 },
	{ 0xF0E1, 0x8B2F },
	{ 0xF0E2, 0x8B3C },
	{ 0xF0E3, 0x8B3E },
	{ 0xF0E4, 0x8B31 },
	{ 0xF0E5, 0x8B25 },
	{ 0xF0E6, 0x8B37 },
	{ 0xF0E7, 0x8B26 },
	{ 0xF0E8, 0x8B36 },
	{ 0xF0E9, 0x8B2E },
	{ 0xF0EA, 0x8B24 },
	{ 0xF0EB, 0x8B3B },
	{ 0xF0EC, 0x8B3D },
	{ 0xF0ED, 0x8B3A },
	{ 0xF0EE, 0x8C42 },
	{ 0xF0EF, 0x8C75 },
	{ 0xF0F0, 0x8C99 },
	{ 0xF0F1, 0x8C98 },
	{ 0xF0F2, 0x8C97 },
	{ 0xF0F3, 0x8CFE },
	{ 0xF0F4, 0x8D04 },
	{ 0xF0F5, 0x8D02 },
	{ 0xF0F6, 0x8D00 },
	{ 0xF0F7, 0x8E5C },
	{ 0xF0F8, 0x8E62 },
	{ 0xF0F9, 0x8E60 },
	{ 0xF0FA, 0x8E57 },
	{ 0xF0FB, 0x8E56 },
	{ 0xF0FC, 0x8E5E },
	{ 0xF0FD, 0x8E65 },
	{ 0xF0FE, 0x8E67 },
	{ 0xF140, 0x8E5B },
	{ 0xF141, 0x8E5A },
	{ 0xF142, 0x8E61 },
	{ 0xF143, 0x8E5D },
	{ 0xF144, 0x8E69 },
	{ 0xF145, 0x8E54 },
	{ 0xF146, 0x8F46 },
	{ 0xF147, 0x8F47 },
	{ 0xF148, 0x8F48 },
	{ 0xF149, 0x8F4B },
	{ 0xF14A, 0x9128 },
	{ 0xF14B, 0x913A },
	{ 0xF14C, 0x913B },
	{ 0xF14D, 0x913E },
	{ 0xF14E, 0x91A8 },
	{ 0xF14F, 0x91A5 },
	{ 0xF150, 0x91A7 },
	{ 0xF151, 0x91AF },
	{ 0xF152, 0x91AA },
	{ 0xF153, 0x93B5 },
	{ 0xF154, 0x938C },
	{ 0xF155, 0x9392 },
	{ 0xF156, 0x93B7 },
	{ 0xF157, 0x939B },
	{ 0xF158, 0x939D },
	{ 0xF159, 0x9389 },
	{ 0xF15A, 0x93A7 },
	{ 0xF15B, 0x938E },
	{ 0xF15C, 0x93AA },
	{ 0xF15D, 0x939E },
	{ 0xF15E, 0x93A6 },
	{ 0xF15F, 0x9395 },
	{ 0xF160, 0x9388 },
	{ 0xF161, 0x9399 },
	{ 0xF162, 0x939F },
	{ 0xF163, 0x938D },
	{ 0xF164, 0x93B1 },
	{ 0xF165, 0x9391 },
	{ 0xF166, 0x93B2 },
	{ 0xF167, 0x93A4 },
	{ 0xF168, 0x93A8 },
	{ 0xF169, 0x93B4 },
	{ 0xF16A, 0x93A3 },
	{ 0xF16B, 0x93A5 },
	{ 0xF16C, 0x95D2 },
	{ 0xF16D, 0x95D3 },
	{ 0xF16E, 0x95D1 },
	{ 0xF16F, 0x96B3 },
	{ 0xF170, 0x96D7 },
	{ 0xF171, 0x96DA },
	{ 0xF172, 0x5DC2 },
	{ 0xF173, 0x96DF },
	{ 0xF174, 0x96D8 },
	{ 0xF175, 0x96DD },
	{ 0xF176, 0x9723 },
	{ 0xF177, 0x9722 },
	{ 0xF178, 0x9725 },
	{ 0xF179, 0x97AC },
	{ 0xF17A, 0x97AE },
	{ 0xF17B, 0x97A8 },
	{ 0xF17C, 0x97AB },
	{ 0xF17D, 0x97A4 },
	{ 0xF17E, 0x97AA },
	{ 0xF17F, 0xFFFD },
	{ 0xF180, 0x9C1F },
	{ 0xF181, 0x9DB0 },
	{ 0xF182, 0x9DBD },
	{ 0xF183, 0x9DAE },
	{ 0xF184, 0x9DC4 },
	{ 0xF185, 0x9E7B },
	{ 0xF186, 0x9E9E },
	{ 0xF187, 0x9F05 },
	{ 0xF188, 0x9F69 },
	{ 0xF189, 0x9FA1 },
	{ 0xF18A, 0x56C7 },
	{ 0xF18B, 0x571D },
	{ 0xF18C, 0x5B4A },
	{ 0xF18D, 0x5DD3 },
	{ 0xF18E, 0x5F72 },
	{ 0xF18F, 0x6202 },
	{ 0xF190, 0x6235 },
	{ 0xF191, 0x6527 },
	{ 0xF192, 0x651E },
	{ 0xF193, 0x651F },
	{ 0xF194, 0x6B07 },
	{ 0xF195, 0x6B06 },
	{ 0xF196, 0x7054 },
	{ 0xF197, 0x721C },
	{ 0xF198, 0x7220 },
	{ 0xF199, 0x7AF8 },
	{ 0xF19A, 0x7C5D },
	{ 0xF19B, 0x7C58 },
	{ 0xF19C, 0x7E92 },
	{ 0xF19D, 0x7F4E },
	{ 0xF19E, 0x8827 },
	{ 0xF19F, 0x8B81 },
	{ 0xF1A0, 0x8B83 },
	{ 0xF1A1, 0x97A2 },
	{ 0xF1A2, 0x97A5 },
	{ 0xF1A3, 0x97D7 },
	{ 0xF1A4, 0x97D9 },
	{ 0xF1A5, 0x97D6 },
	{ 0xF1A6, 0x97D8 },
	{ 0xF1A7, 0x97FA },
	{ 0xF1A8, 0x9850 },
	{ 0xF1A9, 0x9851 },
	{ 0xF1AA, 0x9852 },
	{ 0xF1AB, 0x98B8 },
	{ 0xF1AC, 0x9941 },
	{ 0xF1AD, 0x993C },
	{ 0xF1AE, 0x993A },
	{ 0xF1AF, 0x9A0F },
	{ 0xF1B0, 0x9A0B },
	{ 0xF1B1, 0x9A09 },
	{ 0xF1B2, 0x9A0D },
	{ 0xF1B3, 0x9A04 },
	{ 0xF1B4, 0x9A11 },
	{ 0xF1B5, 0x9A0A },
	{ 0xF1B6, 0x9A05 },
	{ 0xF1B7, 0x9A07 },
	{ 0xF1B8, 0x9A06 },
	{ 0xF1B9, 0x9AC0 },
	{ 0xF1BA, 0x9ADC },
	{ 0xF1BB, 0x9B08 },
	{ 0xF1BC, 0x9B04 },
	{ 0xF1BD, 0x9B05 },
	{ 0xF1BE, 0x9B29 },
	{ 0xF1BF, 0x9B35 },
	{ 0xF1C0, 0x9B4A },
	{ 0xF1C1, 0x9B4C },
	{ 0xF1C2, 0x9B4B },
	{ 0xF1C3, 0x9BC7 },
	{ 0xF1C4, 0x9BC6 },
	{ 0xF1C5, 0x9BC3 },
	{ 0xF1C6, 0x9BBF },
	{ 0xF1C7, 0x9BC1 },
	{ 0xF1C8, 0x9BB5 },
	{ 0xF1C9, 0x9BB8 },
	{ 0xF1CA, 0x9BD3 },
	{ 0xF1CB, 0x9BB6 },
	{ 0xF1CC, 0x9BC4 },
	{ 0xF1CD, 0x9BB9 },
	{ 0xF1CE, 0x9BBD },
	{ 0xF1CF, 0x9D5C },
	{ 0xF1D0, 0x9D53 },
	{ 0xF1D1, 0x9D4F },
	{ 0xF1D2, 0x9D4A },
	{ 0xF1D3, 0x9D5B },
	{ 0xF1D4, 0x9D4B },
	{ 0xF1D5, 0x9D59 },
	{ 0xF1D6, 0x9D56 },
	{ 0xF1D7, 0x9D4C },
	{ 0xF1D8, 0x9D57 },
	{ 0xF1D9, 0x9D52 },
	{ 0xF1DA, 0x9D54 },
	{ 0xF1DB, 0x9D5F },
	{ 0xF1DC, 0x9D58 },
	{ 0xF1DD, 0x9D5A },
	{ 0xF1DE, 0x9E8E },
	{ 0xF1DF, 0x9E8C },
	{ 0xF1E0, 0x9EDF },
	{ 0xF1E1, 0x9F01 },
	{ 0xF1E2, 0x9F00 },
	{ 0xF1E3, 0x9F16 },
	{ 0xF1E4, 0x9F25 },
	{ 0xF1E5, 0x9F2B },
	{ 0xF1E6, 0x9F2A },
	{ 0xF1E7, 0x9F29 },
	{ 0xF1E8, 0x9F28 },
	{ 0xF1E9, 0x9F4C },
	{ 0xF1EA, 0x9F55 },
	{ 0xF1EB, 0x5134 },
	{ 0xF1EC, 0x5135 },
	{ 0xF1ED, 0x5296 },
	{ 0xF1EE, 0x52F7 },
	{ 0xF1EF, 0x53B4 },
	{ 0xF1F0, 0x56AB },
	{ 0xF1F1, 0x56AD },
	{ 0xF1F2, 0x56A6 },
	{ 0xF1F3, 0x56A7 },
	{ 0xF1F4, 0x56AA },
	{ 0xF1F5, 0x56AC },
	{ 0xF1F6, 0x58DA },
	{ 0xF1F7, 0x58DD },
	{ 0xF1F8, 0x58DB },
	{ 0xF1F9, 0x5912 },
	{ 0xF1FA, 0x5B3D },
	{ 0xF1FB, 0x5B3E },
	{ 0xF1FC, 0x5B3F },
	{ 0xF1FD, 0x5DC3 },
	{ 0xF1FE, 0x5E70 },
	{ 0xF240, 0x5FBF },
	{ 0xF241, 0x61FB },
	{ 0xF242, 0x6507 },
	{ 0xF243, 0x6510 },
	{ 0xF244, 0x650D },
	{ 0xF245, 0x6509 },
	{ 0xF246, 0x650C },
	{ 0xF247, 0x650E },
	{ 0xF248, 0x6584 },
	{ 0xF249, 0x65DE },
	{ 0xF24A, 0x65DD },
	{ 0xF24B, 0x66DE },
	{ 0xF24C, 0x6AE7 },
	{ 0xF24D, 0x6AE0 },
	{ 0xF24E, 0x6ACC },
	{ 0xF24F, 0x6AD1 },
	{ 0xF250, 0x6AD9 },
	{ 0xF251, 0x6ACB },
	{ 0xF252, 0x6ADF },
	{ 0xF253, 0x6ADC },
	{ 0xF254, 0x6AD0 },
	{ 0xF255, 0x6AEB },
	{ 0xF256, 0x6ACF },
	{ 0xF257, 0x6ACD },
	{ 0xF258, 0x6ADE },
	{ 0xF259, 0x6B60 },
	{ 0xF25A, 0x6BB0 },
	{ 0xF25B, 0x6C0C },
	{ 0xF25C, 0x7019 },
	{ 0xF25D, 0x7027 },
	{ 0xF25E, 0x7020 },
	{ 0xF25F, 0x7016 },
	{ 0xF260, 0x702B },
	{ 0xF261, 0x7021 },
	{ 0xF262, 0x7022 },
	{ 0xF263, 0x7023 },
	{ 0xF264, 0x7029 },
	{ 0xF265, 0x7017 },
	{ 0xF266, 0x7024 },
	{ 0xF267, 0x701C },
	{ 0xF268, 0x702A },
	{ 0xF269, 0x720C },
	{ 0xF26A, 0x720A },
	{ 0xF26B, 0x7207 },
	{ 0xF26C, 0x7202 },
	{ 0xF26D, 0x7205 },
	{ 0xF26E, 0x72A5 },
	{ 0xF26F, 0x72A6 },
	{ 0xF270, 0x72A4 },
	{ 0xF271, 0x72A3 },
	{ 0xF272, 0x72A1 },
	{ 0xF273, 0x74CB },
	{ 0xF274, 0x74C5 },
	{ 0xF275, 0x74B7 },
	{ 0xF276, 0x74C3 },
	{ 0xF277, 0x7516 },
	{ 0xF278, 0x7660 },
	{ 0xF279, 0x77C9 },
	{ 0xF27A, 0x77CA },
	{ 0xF27B, 0x77C4 },
	{ 0xF27C, 0x77F1 },
	{ 0xF27D, 0x791D },
	{ 0xF27E, 0x791B },
	{ 0xF27F, 0xFFFD },
	{ 0xF280, 0x8C44 },
	{ 0xF281, 0x9442 },
	{ 0xF282, 0x944D },
	{ 0xF283, 0x9454 },
	{ 0xF284, 0x944E },
	{ 0xF285, 0x9443 },
	{ 0xF286, 0x973C },
	{ 0xF287, 0x9740 },
	{ 0xF288, 0x97C0 },
	{ 0xF289, 0x995A },
	{ 0xF28A, 0x9A51 },
	{ 0xF28B, 0x9ADD },
	{ 0xF28C, 0x9C38 },
	{ 0xF28D, 0x9C45 },
	{ 0xF28E, 0x9C3A },
	{ 0xF28F, 0x9C35 },
	{ 0xF290, 0x9EF1 },
	{ 0xF291, 0x9F93 },
	{ 0xF292, 0x529A },
	{ 0xF293, 0x8641 },
	{ 0xF294, 0x5DD7 },
	{ 0xF295, 0x6528 },
	{ 0xF296, 0x7053 },
	{ 0xF297, 0x7059 },
	{ 0xF298, 0x7221 },
	{ 0xF299, 0x766F },
	{ 0xF29A, 0x7937 },
	{ 0xF29B, 0x79B5 },
	{ 0xF29C, 0x7C62 },
	{ 0xF29D, 0x7C5E },
	{ 0xF29E, 0x7CF5 },
	{ 0xF29F, 0x863D },
	{ 0xF2A0, 0x882D },
	{ 0xF2A1, 0x7921 },
	{ 0xF2A2, 0x791C },
	{ 0xF2A3, 0x7917 },
	{ 0xF2A4, 0x791E },
	{ 0xF2A5, 0x79B0 },
	{ 0xF2A6, 0x7A67 },
	{ 0xF2A7, 0x7A68 },
	{ 0xF2A8, 0x7C33 },
	{ 0xF2A9, 0x7C3C },
	{ 0xF2AA, 0x7C39 },
	{ 0xF2AB, 0x7C2C },
	{ 0xF2AC, 0x7C3B },
	{ 0xF2AD, 0x7CEC },
	{ 0xF2AE, 0x7CEA },
	{ 0xF2AF, 0x7E76 },
	{ 0xF2B0, 0x7E75 },
	{ 0xF2B1, 0x7E78 },
	{ 0xF2B2, 0x7E70 },
	{ 0xF2B3, 0x7E77 },
	{ 0xF2B4, 0x7E6F },
	{ 0xF2B5, 0x7E7A },
	{ 0xF2B6, 0x7E72 },
	{ 0xF2B7, 0x7E74 },
	{ 0xF2B8, 0x7E68 },
	{ 0xF2B9, 0x7F4B },
	{ 0xF2BA, 0x7F4A },
	{ 0xF2BB, 0x7F83 },
	{ 0xF2BC, 0x7F86 },
	{ 0xF2BD, 0x7FB7 },
	{ 0xF2BE, 0x7FFD },
	{ 0xF2BF, 0x7FFE },
	{ 0xF2C0, 0x8078 },
	{ 0xF2C1, 0x81D7 },
	{ 0xF2C2, 0x81D5 },
	{ 0xF2C3, 0x8264 },
	{ 0xF2C4, 0x8261 },
	{ 0xF2C5, 0x8263 },
	{ 0xF2C6, 0x85EB },
	{ 0xF2C7, 0x85F1 },
	{ 0xF2C8, 0x85ED },
	{ 0xF2C9, 0x85D9 },
	{ 0xF2CA, 0x85E1 },
	{ 0xF2CB, 0x85E8 },
	{ 0xF2CC, 0x85DA },
	{ 0xF2CD, 0x85D7 },
	{ 0xF2CE, 0x85EC },
	{ 0xF2CF, 0x85F2 },
	{ 0xF2D0, 0x85F8 },
	{ 0xF2D1, 0x85D8 },
	{ 0xF2D2, 0x85DF },
	{ 0xF2D3, 0x85E3 },
	{ 0xF2D4, 0x85DC },
	{ 0xF2D5, 0x85D1 },
	{ 0xF2D6, 0x85F0 },
	{ 0xF2D7, 0x85E6 },
	{ 0xF2D8, 0x85EF },
	{ 0xF2D9, 0x85DE },
	{ 0xF2DA, 0x85E2 },
	{ 0xF2DB, 0x8800 },
	{ 0xF2DC, 0x87FA },
	{ 0xF2DD, 0x8803 },
	{ 0xF2DE, 0x87F6 },
	{ 0xF2DF, 0x87F7 },
	{ 0xF2E0, 0x8809 },
	{ 0xF2E1, 0x880C },
	{ 0xF2E2, 0x880B },
	{ 0xF2E3, 0x8806 },
	{ 0xF2E4, 0x87FC },
	{ 0xF2E5, 0x8808 },
	{ 0xF2E6, 0x87FF },
	{ 0xF2E7, 0x880A },
	{ 0xF2E8, 0x8802 },
	{ 0xF2E9, 0x8962 },
	{ 0xF2EA, 0x895A },
	{ 0xF2EB, 0x895B },
	{ 0xF2EC, 0x8957 },
	{ 0xF2ED, 0x8961 },
	{ 0xF2EE, 0x895C },
	{ 0xF2EF, 0x8958 },
	{ 0xF2F0, 0x895D },
	{ 0xF2F1, 0x8959 },
	{ 0xF2F2, 0x8988 },
	{ 0xF2F3, 0x89B7 },
	{ 0xF2F4, 0x89B6 },
	{ 0xF2F5, 0x89F6 },
	{ 0xF2F6, 0x8B50 },
	{ 0xF2F7, 0x8B48 },
	{ 0xF2F8, 0x8B4A },
	{ 0xF2F9, 0x8B40 },
	{ 0xF2FA, 0x8B53 },
	{ 0xF2FB, 0x8B56 },
	{ 0xF2FC, 0x8B54 },
	{ 0xF2FD, 0x8B4B },
	{ 0xF2FE, 0x8B55 },
	{ 0xF340, 0x8B51 },
	{ 0xF341, 0x8B42 },
	{ 0xF342, 0x8B52 },
	{ 0xF343, 0x8B57 },
	{ 0xF344, 0x8C43 },
	{ 0xF345, 0x8C77 },
	{ 0xF346, 0x8C76 },
	{ 0xF347, 0x8C9A },
	{ 0xF348, 0x8D06 },
	{ 0xF349, 0x8D07 },
	{ 0xF34A, 0x8D09 },
	{ 0xF34B, 0x8DAC },
	{ 0xF34C, 0x8DAA },
	{ 0xF34D, 0x8DAD },
	{ 0xF34E, 0x8DAB },
	{ 0xF34F, 0x8E6D },
	{ 0xF350, 0x8E78 },
	{ 0xF351, 0x8E73 },
	{ 0xF352, 0x8E6A },
	{ 0xF353, 0x8E6F },
	{ 0xF354, 0x8E7B },
	{ 0xF355, 0x8EC2 },
	{ 0xF356, 0x8F52 },
	{ 0xF357, 0x8F51 },
	{ 0xF358, 0x8F4F },
	{ 0xF359, 0x8F50 },
	{ 0xF35A, 0x8F53 },
	{ 0xF35B, 0x8FB4 },
	{ 0xF35C, 0x9140 },
	{ 0xF35D, 0x913F },
	{ 0xF35E, 0x91B0 },
	{ 0xF35F, 0x91AD },
	{ 0xF360, 0x93DE },
	{ 0xF361, 0x93C7 },
	{ 0xF362, 0x93CF },
	{ 0xF363, 0x93C2 },
	{ 0xF364, 0x93DA },
	{ 0xF365, 0x93D0 },
	{ 0xF366, 0x93F9 },
	{ 0xF367, 0x93EC },
	{ 0xF368, 0x93CC },
	{ 0xF369, 0x93D9 },
	{ 0xF36A, 0x93A9 },
	{ 0xF36B, 0x93E6 },
	{ 0xF36C, 0x93CA },
	{ 0xF36D, 0x93D4 },
	{ 0xF36E, 0x93EE },
	{ 0xF36F, 0x93E3 },
	{ 0xF370, 0x93D5 },
	{ 0xF371, 0x93C4 },
	{ 0xF372, 0x93CE },
	{ 0xF373, 0x93C0 },
	{ 0xF374, 0x93D2 },
	{ 0xF375, 0x93E7 },
	{ 0xF376, 0x957D },
	{ 0xF377, 0x95DA },
	{ 0xF378, 0x95DB },
	{ 0xF379, 0x96E1 },
	{ 0xF37A, 0x9729 },
	{ 0xF37B, 0x972B },
	{ 0xF37C, 0x972C },
	{ 0xF37D, 0x9728 },
	{ 0xF37E, 0x9726 },
	{ 0xF37F, 0xFFFD },
	{ 0xF380, 0x8989 },
	{ 0xF381, 0x8B8D },
	{ 0xF382, 0x8B87 },
	{ 0xF383, 0x8B90 },
	{ 0xF384, 0x8D1A },
	{ 0xF385, 0x8E99 },
	{ 0xF386, 0x945F },
	{ 0xF387, 0x9456 },
	{ 0xF388, 0x9461 },
	{ 0xF389, 0x945B },
	{ 0xF38A, 0x945A },
	{ 0xF38B, 0x945C },
	{ 0xF38C, 0x9465 },
	{ 0xF38D, 0x9741 },
	{ 0xF38E, 0x986E },
	{ 0xF38F, 0x986C },
	{ 0xF390, 0x986D },
	{ 0xF391, 0x99AA },
	{ 0xF392, 0x9A5C },
	{ 0xF393, 0x9A58 },
	{ 0xF394, 0x9ADE },
	{ 0xF395, 0x9C4F },
	{ 0xF396, 0x9C51 },
	{ 0xF397, 0x9C53 },
	{ 0xF398, 0x9DFC },
	{ 0xF399, 0x9F39 },
	{ 0xF39A, 0x513E },
	{ 0xF39B, 0x56D2 },
	{ 0xF39C, 0x5B4F },
	{ 0xF39D, 0x6B14 },
	{ 0xF39E, 0x7A72 },
	{ 0xF39F, 0x7A73 },
	{ 0xF3A0, 0x8B91 },
	{ 0xF3A1, 0x97B3 },
	{ 0xF3A2, 0x97B7 },
	{ 0xF3A3, 0x97B6 },
	{ 0xF3A4, 0x97DD },
	{ 0xF3A5, 0x97DE },
	{ 0xF3A6, 0x97DF },
	{ 0xF3A7, 0x985C },
	{ 0xF3A8, 0x9859 },
	{ 0xF3A9, 0x985D },
	{ 0xF3AA, 0x9857 },
	{ 0xF3AB, 0x98BF },
	{ 0xF3AC, 0x98BD },
	{ 0xF3AD, 0x98BB },
	{ 0xF3AE, 0x98BE },
	{ 0xF3AF, 0x9948 },
	{ 0xF3B0, 0x9947 },
	{ 0xF3B1, 0x9943 },
	{ 0xF3B2, 0x99A6 },
	{ 0xF3B3, 0x99A7 },
	{ 0xF3B4, 0x9A1A },
	{ 0xF3B5, 0x9A15 },
	{ 0xF3B6, 0x9A25 },
	{ 0xF3B7, 0x9A1D },
	{ 0xF3B8, 0x9A24 },
	{ 0xF3B9, 0x9A1B },
	{ 0xF3BA, 0x9A22 },
	{ 0xF3BB, 0x9A20 },
	{ 0xF3BC, 0x9A27 },
	{ 0xF3BD, 0x9A23 },
	{ 0xF3BE, 0x9A1E },
	{ 0xF3BF, 0x9A1C },
	{ 0xF3C0, 0x9A14 },
	{ 0xF3C1, 0x9AC2 },
	{ 0xF3C2, 0x9B0B },
	{ 0xF3C3, 0x9B0A },
	{ 0xF3C4, 0x9B0E },
	{ 0xF3C5, 0x9B0C },
	{ 0xF3C6, 0x9B37 },
	{ 0xF3C7, 0x9BEA },
	{ 0xF3C8, 0x9BEB },
	{ 0xF3C9, 0x9BE0 },
	{ 0xF3CA, 0x9BDE },
	{ 0xF3CB, 0x9BE4 },
	{ 0xF3CC, 0x9BE6 },
	{ 0xF3CD, 0x9BE2 },
	{ 0xF3CE, 0x9BF0 },
	{ 0xF3CF, 0x9BD4 },
	{ 0xF3D0, 0x9BD7 },
	{ 0xF3D1, 0x9BEC },
	{ 0xF3D2, 0x9BDC },
	{ 0xF3D3, 0x9BD9 },
	{ 0xF3D4, 0x9BE5 },
	{ 0xF3D5, 0x9BD5 },
	{ 0xF3D6, 0x9BE1 },
	{ 0xF3D7, 0x9BDA },
	{ 0xF3D8, 0x9D77 },
	{ 0xF3D9, 0x9D81 },
	{ 0xF3DA, 0x9D8A },
	{ 0xF3DB, 0x9D84 },
	{ 0xF3DC, 0x9D88 },
	{ 0xF3DD, 0x9D71 },
	{ 0xF3DE, 0x9D80 },
	{ 0xF3DF, 0x9D78 },
	{ 0xF3E0, 0x9D86 },
	{ 0xF3E1, 0x9D8B },
	{ 0xF3E2, 0x9D8C },
	{ 0xF3E3, 0x9D7D },
	{ 0xF3E4, 0x9D6B },
	{ 0xF3E5, 0x9D74 },
	{ 0xF3E6, 0x9D75 },
	{ 0xF3E7, 0x9D70 },
	{ 0xF3E8, 0x9D69 },
	{ 0xF3E9, 0x9D85 },
	{ 0xF3EA, 0x9D73 },
	{ 0xF3EB, 0x9D7B },
	{ 0xF3EC, 0x9D82 },
	{ 0xF3ED, 0x9D6F },
	{ 0xF3EE, 0x9D79 },
	{ 0xF3EF, 0x9D7F },
	{ 0xF3F0, 0x9D87 },
	{ 0xF3F1, 0x9D68 },
	{ 0xF3F2, 0x9E94 },
	{ 0xF3F3, 0x9E91 },
	{ 0xF3F4, 0x9EC0 },
	{ 0xF3F5, 0x9EFC },
	{ 0xF3F6, 0x9F2D },
	{ 0xF3F7, 0x9F40 },
	{ 0xF3F8, 0x9F41 },
	{ 0xF3F9, 0x9F4D },
	{ 0xF3FA, 0x9F56 },
	{ 0xF3FB, 0x9F57 },
	{ 0xF3FC, 0x9F58 },
	{ 0xF3FD, 0x5337 },
	{ 0xF3FE, 0x56B2 },
	{ 0xF440, 0x56B5 },
	{ 0xF441, 0x56B3 },
	{ 0xF442, 0x58E3 },
	{ 0xF443, 0x5B45 },
	{ 0xF444, 0x5DC6 },
	{ 0xF445, 0x5DC7 },
	{ 0xF446, 0x5EEE },
	{ 0xF447, 0x5EEF },
	{ 0xF448, 0x5FC0 },
	{ 0xF449, 0x5FC1 },
	{ 0xF44A, 0x61F9 },
	{ 0xF44B, 0x6517 },
	{ 0xF44C, 0x6516 },
	{ 0xF44D, 0x6515 },
	{ 0xF44E, 0x6513 },
	{ 0xF44F, 0x65DF },
	{ 0xF450, 0x66E8 },
	{ 0xF451, 0x66E3 },
	{ 0xF452, 0x66E4 },
	{ 0xF453, 0x6AF3 },
	{ 0xF454, 0x6AF0 },
	{ 0xF455, 0x6AEA },
	{ 0xF456, 0x6AE8 },
	{ 0xF457, 0x6AF9 },
	{ 0xF458, 0x6AF1 },
	{ 0xF459, 0x6AEE },
	{ 0xF45A, 0x6AEF },
	{ 0xF45B, 0x703C },
	{ 0xF45C, 0x7035 },
	{ 0xF45D, 0x702F },
	{ 0xF45E, 0x7037 },
	{ 0xF45F, 0x7034 },
	{ 0xF460, 0x7031 },
	{ 0xF461, 0x7042 },
	{ 0xF462, 0x7038 },
	{ 0xF463, 0x703F },
	{ 0xF464, 0x703A },
	{ 0xF465, 0x7039 },
	{ 0xF466, 0x7040 },
	{ 0xF467, 0x703B },
	{ 0xF468, 0x7033 },
	{ 0xF469, 0x7041 },
	{ 0xF46A, 0x7213 },
	{ 0xF46B, 0x7214 },
	{ 0xF46C, 0x72A8 },
	{ 0xF46D, 0x737D },
	{ 0xF46E, 0x737C },
	{ 0xF46F, 0x74BA },
	{ 0xF470, 0x76AB },
	{ 0xF471, 0x76AA },
	{ 0xF472, 0x76BE },
	{ 0xF473, 0x76ED },
	{ 0xF474, 0x77CC },
	{ 0xF475, 0x77CE },
	{ 0xF476, 0x77CF },
	{ 0xF477, 0x77CD },
	{ 0xF478, 0x77F2 },
	{ 0xF479, 0x7925 },
	{ 0xF47A, 0x7923 },
	{ 0xF47B, 0x7927 },
	{ 0xF47C, 0x7928 },
	{ 0xF47D, 0x7924 },
	{ 0xF47E, 0x7929 },
	{ 0xF47F, 0xFFFD },
	{ 0xF480, 0x91BF },
	{ 0xF481, 0x946C },
	{ 0xF482, 0x96E6 },
	{ 0xF483, 0x9745 },
	{ 0xF484, 0x97C8 },
	{ 0xF485, 0x97E4 },
	{ 0xF486, 0x995D },
	{ 0xF487, 0x9B21 },
	{ 0xF488, 0x9B2C },
	{ 0xF489, 0x9B57 },
	{ 0xF48A, 0x9C5D },
	{ 0xF48B, 0x9C61 },
	{ 0xF48C, 0x9C65 },
	{ 0xF48D, 0x9E08 },
	{ 0xF48E, 0x9F45 },
	{ 0xF48F, 0x6205 },
	{ 0xF490, 0x66EF },
	{ 0xF491, 0x6B1B },
	{ 0xF492, 0x6B1D },
	{ 0xF493, 0x7225 },
	{ 0xF494, 0x7224 },
	{ 0xF495, 0x7C6D },
	{ 0xF496, 0x8642 },
	{ 0xF497, 0x8649 },
	{ 0xF498, 0x8978 },
	{ 0xF499, 0x898A },
	{ 0xF49A, 0x8B97 },
	{ 0xF49B, 0x8C9B },
	{ 0xF49C, 0x8D1C },
	{ 0xF49D, 0x8EA2 },
	{ 0xF49E, 0x9C6C },
	{ 0xF49F, 0x9C6F },
	{ 0xF4A0, 0x9E0E },
	{ 0xF4A1, 0x79B2 },
	{ 0xF4A2, 0x7A6E },
	{ 0xF4A3, 0x7A6C },
	{ 0xF4A4, 0x7A6D },
	{ 0xF4A5, 0x7AF7 },
	{ 0xF4A6, 0x7C49 },
	{ 0xF4A7, 0x7C48 },
	{ 0xF4A8, 0x7C4A },
	{ 0xF4A9, 0x7C47 },
	{ 0xF4AA, 0x7C45 },
	{ 0xF4AB, 0x7CEE },
	{ 0xF4AC, 0x7E7B },
	{ 0xF4AD, 0x7E7E },
	{ 0xF4AE, 0x7E81 },
	{ 0xF4AF, 0x7E80 },
	{ 0xF4B0, 0x7FBA },
	{ 0xF4B1, 0x7FFF },
	{ 0xF4B2, 0x8079 },
	{ 0xF4B3, 0x81DB },
	{ 0xF4B4, 0x81D9 },
	{ 0xF4B5, 0x820B },
	{ 0xF4B6, 0x8268 },
	{ 0xF4B7, 0x8269 },
	{ 0xF4B8, 0x8622 },
	{ 0xF4B9, 0x85FF },
	{ 0xF4BA, 0x8601 },
	{ 0xF4BB, 0x85FE },
	{ 0xF4BC, 0x861B },
	{ 0xF4BD, 0x8600 },
	{ 0xF4BE, 0x85F6 },
	{ 0xF4BF, 0x8604 },
	{ 0xF4C0, 0x8609 },
	{ 0xF4C1, 0x8605 },
	{ 0xF4C2, 0x860C },
	{ 0xF4C3, 0x85FD },
	{ 0xF4C4, 0x8819 },
	{ 0xF4C5, 0x8810 },
	{ 0xF4C6, 0x8811 },
	{ 0xF4C7, 0x8817 },
	{ 0xF4C8, 0x8813 },
	{ 0xF4C9, 0x8816 },
	{ 0xF4CA, 0x8963 },
	{ 0xF4CB, 0x8966 },
	{ 0xF4CC, 0x89B9 },
	{ 0xF4CD, 0x89F7 },
	{ 0xF4CE, 0x8B60 },
	{ 0xF4CF, 0x8B6A },
	{ 0xF4D0, 0x8B5D },
	{ 0xF4D1, 0x8B68 },
	{ 0xF4D2, 0x8B63 },
	{ 0xF4D3, 0x8B65 },
	{ 0xF4D4, 0x8B67 },
	{ 0xF4D5, 0x8B6D },
	{ 0xF4D6, 0x8DAE },
	{ 0xF4D7, 0x8E86 },
	{ 0xF4D8, 0x8E88 },
	{ 0xF4D9, 0x8E84 },
	{ 0xF4DA, 0x8F59 },
	{ 0xF4DB, 0x8F56 },
	{ 0xF4DC, 0x8F57 },
	{ 0xF4DD, 0x8F55 },
	{ 0xF4DE, 0x8F58 },
	{ 0xF4DF, 0x8F5A },
	{ 0xF4E0, 0x908D },
	{ 0xF4E1, 0x9143 },
	{ 0xF4E2, 0x9141 },
	{ 0xF4E3, 0x91B7 },
	{ 0xF4E4, 0x91B5 },
	{ 0xF4E5, 0x91B2 },
	{ 0xF4E6, 0x91B3 },
	{ 0xF4E7, 0x940B },
	{ 0xF4E8, 0x9413 },
	{ 0xF4E9, 0x93FB },
	{ 0xF4EA, 0x9420 },
	{ 0xF4EB, 0x940F },
	{ 0xF4EC, 0x9414 },
	{ 0xF4ED, 0x93FE },
	{ 0xF4EE, 0x9415 },
	{ 0xF4EF, 0x9410 },
	{ 0xF4F0, 0x9428 },
	{ 0xF4F1, 0x9419 },
	{ 0xF4F2, 0x940D },
	{ 0xF4F3, 0x93F5 },
	{ 0xF4F4, 0x9400 },
	{ 0xF4F5, 0x93F7 },
	{ 0xF4F6, 0x9407 },
	{ 0xF4F7, 0x940E },
	{ 0xF4F8, 0x9416 },
	{ 0xF4F9, 0x9412 },
	{ 0xF4FA, 0x93FA },
	{ 0xF4FB, 0x9409 },
	{ 0xF4FC, 0x93F8 },
	{ 0xF4FD, 0x940A },
	{ 0xF4FE, 0x93FF },
	{ 0xF540, 0x93FC },
	{ 0xF541, 0x940C },
	{ 0xF542, 0x93F6 },
	{ 0xF543, 0x9411 },
	{ 0xF544, 0x9406 },
	{ 0xF545, 0x95DE },
	{ 0xF546, 0x95E0 },
	{ 0xF547, 0x95DF },
	{ 0xF548, 0x972E },
	{ 0xF549, 0x972F },
	{ 0xF54A, 0x97B9 },
	{ 0xF54B, 0x97BB },
	{ 0xF54C, 0x97FD },
	{ 0xF54D, 0x97FE },
	{ 0xF54E, 0x9860 },
	{ 0xF54F, 0x9862 },
	{ 0xF550, 0x9863 },
	{ 0xF551, 0x985F },
	{ 0xF552, 0x98C1 },
	{ 0xF553, 0x98C2 },
	{ 0xF554, 0x9950 },
	{ 0xF555, 0x994E },
	{ 0xF556, 0x9959 },
	{ 0xF557, 0x994C },
	{ 0xF558, 0x994B },
	{ 0xF559, 0x9953 },
	{ 0xF55A, 0x9A32 },
	{ 0xF55B, 0x9A34 },
	{ 0xF55C, 0x9A31 },
	{ 0xF55D, 0x9A2C },
	{ 0xF55E, 0x9A2A },
	{ 0xF55F, 0x9A36 },
	{ 0xF560, 0x9A29 },
	{ 0xF561, 0x9A2E },
	{ 0xF562, 0x9A38 },
	{ 0xF563, 0x9A2D },
	{ 0xF564, 0x9AC7 },
	{ 0xF565, 0x9ACA },
	{ 0xF566, 0x9AC6 },
	{ 0xF567, 0x9B10 },
	{ 0xF568, 0x9B12 },
	{ 0xF569, 0x9B11 },
	{ 0xF56A, 0x9C0B },
	{ 0xF56B, 0x9C08 },
	{ 0xF56C, 0x9BF7 },
	{ 0xF56D, 0x9C05 },
	{ 0xF56E, 0x9C12 },
	{ 0xF56F, 0x9BF8 },
	{ 0xF570, 0x9C40 },
	{ 0xF571, 0x9C07 },
	{ 0xF572, 0x9C0E },
	{ 0xF573, 0x9C06 },
	{ 0xF574, 0x9C17 },
	{ 0xF575, 0x9C14 },
	{ 0xF576, 0x9C09 },
	{ 0xF577, 0x9D9F },
	{ 0xF578, 0x9D99 },
	{ 0xF579, 0x9DA4 },
	{ 0xF57A, 0x9D9D },
	{ 0xF57B, 0x9D92 },
	{ 0xF57C, 0x9D98 },
	{ 0xF57D, 0x9D90 },
	{ 0xF57E, 0x9D9B },
	{ 0xF57F, 0xFFFD },
	{ 0xF580, 0x9F08 },
	{ 0xF581, 0x9F1D },
	{ 0xF582, 0x9FA3 },
	{ 0xF583, 0x5F60 },
	{ 0xF584, 0x6B1C },
	{ 0xF585, 0x7CF3 },
	{ 0xF586, 0x8B9B },
	{ 0xF587, 0x8EA7 },
	{ 0xF588, 0x91C4 },
	{ 0xF589, 0x947A },
	{ 0xF58A, 0x9A61 },
	{ 0xF58B, 0x9A63 },
	{ 0xF58C, 0x9AD7 },
	{ 0xF58D, 0x9C76 },
	{ 0xF58E, 0x9FA5 },
	{ 0xF58F, 0x7067 },
	{ 0xF590, 0x72AB },
	{ 0xF591, 0x864A },
	{ 0xF592, 0x897D },
	{ 0xF593, 0x8B9D },
	{ 0xF594, 0x8C53 },
	{ 0xF595, 0x8F65 },
	{ 0xF596, 0x947B },
	{ 0xF597, 0x98CD },
	{ 0xF598, 0x98DD },
	{ 0xF599, 0x9B30 },
	{ 0xF59A, 0x9E16 },
	{ 0xF59B, 0x96E7 },
	{ 0xF59C, 0x9E18 },
	{ 0xF59D, 0x9EA2 },
	{ 0xF59E, 0x9F7C },
	{ 0xF59F, 0x7E9E },
	{ 0xF5A0, 0x9484 },
	{ 0xF5A1, 0x9DA0 },
	{ 0xF5A2, 0x9D94 },
	{ 0xF5A3, 0x9D9C },
	{ 0xF5A4, 0x9DAA },
	{ 0xF5A5, 0x9D97 },
	{ 0xF5A6, 0x9DA1 },
	{ 0xF5A7, 0x9D9A },
	{ 0xF5A8, 0x9DA2 },
	{ 0xF5A9, 0x9DA8 },
	{ 0xF5AA, 0x9D9E },
	{ 0xF5AB, 0x9DA3 },
	{ 0xF5AC, 0x9DBF },
	{ 0xF5AD, 0x9DA9 },
	{ 0xF5AE, 0x9D96 },
	{ 0xF5AF, 0x9DA6 },
	{ 0xF5B0, 0x9DA7 },
	{ 0xF5B1, 0x9E99 },
	{ 0xF5B2, 0x9E9B },
	{ 0xF5B3, 0x9E9A },
	{ 0xF5B4, 0x9EE5 },
	{ 0xF5B5, 0x9EE4 },
	{ 0xF5B6, 0x9EE7 },
	{ 0xF5B7, 0x9EE6 },
	{ 0xF5B8, 0x9F30 },
	{ 0xF5B9, 0x9F2E },
	{ 0xF5BA, 0x9F5B },
	{ 0xF5BB, 0x9F60 },
	{ 0xF5BC, 0x9F5E },
	{ 0xF5BD, 0x9F5D },
	{ 0xF5BE, 0x9F59 },
	{ 0xF5BF, 0x9F91 },
	{ 0xF5C0, 0x513A },
	{ 0xF5C1, 0x5139 },
	{ 0xF5C2, 0x5298 },
	{ 0xF5C3, 0x5297 },
	{ 0xF5C4, 0x56C3 },
	{ 0xF5C5, 0x56BD },
	{ 0xF5C6, 0x56BE },
	{ 0xF5C7, 0x5B48 },
	{ 0xF5C8, 0x5B47 },
	{ 0xF5C9, 0x5DCB },
	{ 0xF5CA, 0x5DCF },
	{ 0xF5CB, 0x5EF1 },
	{ 0xF5CC, 0x61FD },
	{ 0xF5CD, 0x651B },
	{ 0xF5CE, 0x6B02 },
	{ 0xF5CF, 0x6AFC },
	{ 0xF5D0, 0x6B03 },
	{ 0xF5D1, 0x6AF8 },
	{ 0xF5D2, 0x6B00 },
	{ 0xF5D3, 0x7043 },
	{ 0xF5D4, 0x7044 },
	{ 0xF5D5, 0x704A },
	{ 0xF5D6, 0x7048 },
	{ 0xF5D7, 0x7049 },
	{ 0xF5D8, 0x7045 },
	{ 0xF5D9, 0x7046 },
	{ 0xF5DA, 0x721D },
	{ 0xF5DB, 0x721A },
	{ 0xF5DC, 0x7219 },
	{ 0xF5DD, 0x737E },
	{ 0xF5DE, 0x7517 },
	{ 0xF5DF, 0x766A },
	{ 0xF5E0, 0x77D0 },
	{ 0xF5E1, 0x792D },
	{ 0xF5E2, 0x7931 },
	{ 0xF5E3, 0x792F },
	{ 0xF5E4, 0x7C54 },
	{ 0xF5E5, 0x7C53 },
	{ 0xF5E6, 0x7CF2 },
	{ 0xF5E7, 0x7E8A },
	{ 0xF5E8, 0x7E87 },
	{ 0xF5E9, 0x7E88 },
	{ 0xF5EA, 0x7E8B },
	{ 0xF5EB, 0x7E86 },
	{ 0xF5EC, 0x7E8D },
	{ 0xF5ED, 0x7F4D },
	{ 0xF5EE, 0x7FBB },
	{ 0xF5EF, 0x8030 },
	{ 0xF5F0, 0x81DD },
	{ 0xF5F1, 0x8618 },
	{ 0xF5F2, 0x862A },
	{ 0xF5F3, 0x8626 },
	{ 0xF5F4, 0x861F },
	{ 0xF5F5, 0x8623 },
	{ 0xF5F6, 0x861C },
	{ 0xF5F7, 0x8619 },
	{ 0xF5F8, 0x8627 },
	{ 0xF5F9, 0x862E },
	{ 0xF5FA, 0x8621 },
	{ 0xF5FB, 0x8620 },
	{ 0xF5FC, 0x8629 },
	{ 0xF5FD, 0x861E },
	{ 0xF5FE, 0x8625 },
	{ 0xF640, 0x8829 },
	{ 0xF641, 0x881D },
	{ 0xF642, 0x881B },
	{ 0xF643, 0x8820 },
	{ 0xF644, 0x8824 },
	{ 0xF645, 0x881C },
	{ 0xF646, 0x882B },
	{ 0xF647, 0x884A },
	{ 0xF648, 0x896D },
	{ 0xF649, 0x8969 },
	{ 0xF64A, 0x896E },
	{ 0xF64B, 0x896B },
	{ 0xF64C, 0x89FA },
	{ 0xF64D, 0x8B79 },
	{ 0xF64E, 0x8B78 },
	{ 0xF64F, 0x8B45 },
	{ 0xF650, 0x8B7A },
	{ 0xF651, 0x8B7B },
	{ 0xF652, 0x8D10 },
	{ 0xF653, 0x8D14 },
	{ 0xF654, 0x8DAF },
	{ 0xF655, 0x8E8E },
	{ 0xF656, 0x8E8C },
	{ 0xF657, 0x8F5E },
	{ 0xF658, 0x8F5B },
	{ 0xF659, 0x8F5D },
	{ 0xF65A, 0x9146 },
	{ 0xF65B, 0x9144 },
	{ 0xF65C, 0x9145 },
	{ 0xF65D, 0x91B9 },
	{ 0xF65E, 0x943F },
	{ 0xF65F, 0x943B },
	{ 0xF660, 0x9436 },
	{ 0xF661, 0x9429 },
	{ 0xF662, 0x943D },
	{ 0xF663, 0x943C },
	{ 0xF664, 0x9430 },
	{ 0xF665, 0x9439 },
	{ 0xF666, 0x942A },
	{ 0xF667, 0x9437 },
	{ 0xF668, 0x942C },
	{ 0xF669, 0x9440 },
	{ 0xF66A, 0x9431 },
	{ 0xF66B, 0x95E5 },
	{ 0xF66C, 0x95E4 },
	{ 0xF66D, 0x95E3 },
	{ 0xF66E, 0x9735 },
	{ 0xF66F, 0x973A },
	{ 0xF670, 0x97BF },
	{ 0xF671, 0x97E1 },
	{ 0xF672, 0x9864 },
	{ 0xF673, 0x98C9 },
	{ 0xF674, 0x98C6 },
	{ 0xF675, 0x98C0 },
	{ 0xF676, 0x9958 },
	{ 0xF677, 0x9956 },
	{ 0xF678, 0x9A39 },
	{ 0xF679, 0x9A3D },
	{ 0xF67A, 0x9A46 },
	{ 0xF67B, 0x9A44 },
	{ 0xF67C, 0x9A42 },
	{ 0xF67D, 0x9A41 },
	{ 0xF67E, 0x9A3A },
	{ 0xF67F, 0xFFFD },
	{ 0xF680, 0x9E1C },
	{ 0xF681, 0x7C71 },
	{ 0xF682, 0x97CA },
	{ 0xF683, 0x9EA3 },
	{ 0xF684, 0x9C7B },
	{ 0xF685, 0x9F97 },
	{ 0xF686, 0x9750 },
	{ 0xF687, 0x4E40 },
	{ 0xF688, 0x4E41 },
	{ 0xF689, 0x4E5A },
	{ 0xF68A, 0x4E02 },
	{ 0xF68B, 0x4E29 },
	{ 0xF68C, 0x5202 },
	{ 0xF68D, 0x5DDC },
	{ 0xF68E, 0x5342 },
	{ 0xF68F, 0x536A },
	{ 0xF690, 0x5B52 },
	{ 0xF691, 0x5FC4 },
	{ 0xF692, 0x624C },
	{ 0xF693, 0x72AD },
	{ 0xF694, 0x4E12 },
	{ 0xF695, 0x4E2F },
	{ 0xF696, 0x4E96 },
	{ 0xF697, 0x4ED0 },
	{ 0xF698, 0x5142 },
	{ 0xF699, 0x5183 },
	{ 0xF69A, 0x5383 },
	{ 0xF69B, 0x53B8 },
	{ 0xF69C, 0x5928 },
	{ 0xF69D, 0x5C23 },
	{ 0xF69E, 0x5E01 },
	{ 0xF69F, 0x5F00 },
	{ 0xF6A0, 0x706C },
	{ 0xF6A1, 0x9A3F },
	{ 0xF6A2, 0x9ACD },
	{ 0xF6A3, 0x9B15 },
	{ 0xF6A4, 0x9B17 },
	{ 0xF6A5, 0x9B18 },
	{ 0xF6A6, 0x9B16 },
	{ 0xF6A7, 0x9B3A },
	{ 0xF6A8, 0x9B52 },
	{ 0xF6A9, 0x9C2B },
	{ 0xF6AA, 0x9C1D },
	{ 0xF6AB, 0x9C1C },
	{ 0xF6AC, 0x9C2C },
	{ 0xF6AD, 0x9C23 },
	{ 0xF6AE, 0x9C28 },
	{ 0xF6AF, 0x9C29 },
	{ 0xF6B0, 0x9C24 },
	{ 0xF6B1, 0x9C21 },
	{ 0xF6B2, 0x9DB7 },
	{ 0xF6B3, 0x9DB6 },
	{ 0xF6B4, 0x9DBC },
	{ 0xF6B5, 0x9DC1 },
	{ 0xF6B6, 0x9DC7 },
	{ 0xF6B7, 0x9DCA },
	{ 0xF6B8, 0x9DCF },
	{ 0xF6B9, 0x9DBE },
	{ 0xF6BA, 0x9DC5 },
	{ 0xF6BB, 0x9DC3 },
	{ 0xF6BC, 0x9DBB },
	{ 0xF6BD, 0x9DB5 },
	{ 0xF6BE, 0x9DCE },
	{ 0xF6BF, 0x9DB9 },
	{ 0xF6C0, 0x9DBA },
	{ 0xF6C1, 0x9DAC },
	{ 0xF6C2, 0x9DC8 },
	{ 0xF6C3, 0x9DB1 },
	{ 0xF6C4, 0x9DAD },
	{ 0xF6C5, 0x9DCC },
	{ 0xF6C6, 0x9DB3 },
	{ 0xF6C7, 0x9DCD },
	{ 0xF6C8, 0x9DB2 },
	{ 0xF6C9, 0x9E7A },
	{ 0xF6CA, 0x9E9C },
	{ 0xF6CB, 0x9EEB },
	{ 0xF6CC, 0x9EEE },
	{ 0xF6CD, 0x9EED },
	{ 0xF6CE, 0x9F1B },
	{ 0xF6CF, 0x9F18 },
	{ 0xF6D0, 0x9F1A },
	{ 0xF6D1, 0x9F31 },
	{ 0xF6D2, 0x9F4E },
	{ 0xF6D3, 0x9F65 },
	{ 0xF6D4, 0x9F64 },
	{ 0xF6D5, 0x9F92 },
	{ 0xF6D6, 0x4EB9 },
	{ 0xF6D7, 0x56C6 },
	{ 0xF6D8, 0x56C5 },
	{ 0xF6D9, 0x56CB },
	{ 0xF6DA, 0x5971 },
	{ 0xF6DB, 0x5B4B },
	{ 0xF6DC, 0x5B4C },
	{ 0xF6DD, 0x5DD5 },
	{ 0xF6DE, 0x5DD1 },
	{ 0xF6DF, 0x5EF2 },
	{ 0xF6E0, 0x6521 },
	{ 0xF6E1, 0x6520 },
	{ 0xF6E2, 0x6526 },
	{ 0xF6E3, 0x6522 },
	{ 0xF6E4, 0x6B0B },
	{ 0xF6E5, 0x6B08 },
	{ 0xF6E6, 0x6B09 },
	{ 0xF6E7, 0x6C0D },
	{ 0xF6E8, 0x7055 },
	{ 0xF6E9, 0x7056 },
	{ 0xF6EA, 0x7057 },
	{ 0xF6EB, 0x7052 },
	{ 0xF6EC, 0x721E },
	{ 0xF6ED, 0x721F },
	{ 0xF6EE, 0x72A9 },
	{ 0xF6EF, 0x737F },
	{ 0xF6F0, 0x74D8 },
	{ 0xF6F1, 0x74D5 },
	{ 0xF6F2, 0x74D9 },
	{ 0xF6F3, 0x74D7 },
	{ 0xF6F4, 0x766D },
	{ 0xF6F5, 0x76AD },
	{ 0xF6F6, 0x7935 },
	{ 0xF6F7, 0x79B4 },
	{ 0xF6F8, 0x7A70 },
	{ 0xF6F9, 0x7A71 },
	{ 0xF6FA, 0x7C57 },
	{ 0xF6FB, 0x7C5C },
	{ 0xF6FC, 0x7C59 },
	{ 0xF6FD, 0x7C5B },
	{ 0xF6FE, 0x7C5A },
	{ 0xF740, 0x7CF4 },
	{ 0xF741, 0x7CF1 },
	{ 0xF742, 0x7E91 },
	{ 0xF743, 0x7F4F },
	{ 0xF744, 0x7F87 },
	{ 0xF745, 0x81DE },
	{ 0xF746, 0x826B },
	{ 0xF747, 0x8634 },
	{ 0xF748, 0x8635 },
	{ 0xF749, 0x8633 },
	{ 0xF74A, 0x862C },
	{ 0xF74B, 0x8632 },
	{ 0xF74C, 0x8636 },
	{ 0xF74D, 0x882C },
	{ 0xF74E, 0x8828 },
	{ 0xF74F, 0x8826 },
	{ 0xF750, 0x882A },
	{ 0xF751, 0x8825 },
	{ 0xF752, 0x8971 },
	{ 0xF753, 0x89BF },
	{ 0xF754, 0x89BE },
	{ 0xF755, 0x89FB },
	{ 0xF756, 0x8B7E },
	{ 0xF757, 0x8B84 },
	{ 0xF758, 0x8B82 },
	{ 0xF759, 0x8B86 },
	{ 0xF75A, 0x8B85 },
	{ 0xF75B, 0x8B7F },
	{ 0xF75C, 0x8D15 },
	{ 0xF75D, 0x8E95 },
	{ 0xF75E, 0x8E94 },
	{ 0xF75F, 0x8E9A },
	{ 0xF760, 0x8E92 },
	{ 0xF761, 0x8E90 },
	{ 0xF762, 0x8E96 },
	{ 0xF763, 0x8E97 },
	{ 0xF764, 0x8F60 },
	{ 0xF765, 0x8F62 },
	{ 0xF766, 0x9147 },
	{ 0xF767, 0x944C },
	{ 0xF768, 0x9450 },
	{ 0xF769, 0x944A },
	{ 0xF76A, 0x944B },
	{ 0xF76B, 0x944F },
	{ 0xF76C, 0x9447 },
	{ 0xF76D, 0x9445 },
	{ 0xF76E, 0x9448 },
	{ 0xF76F, 0x9449 },
	{ 0xF770, 0x9446 },
	{ 0xF771, 0x973F },
	{ 0xF772, 0x97E3 },
	{ 0xF773, 0x986A },
	{ 0xF774, 0x9869 },
	{ 0xF775, 0x98CB },
	{ 0xF776, 0x9954 },
	{ 0xF777, 0x995B },
	{ 0xF778, 0x9A4E },
	{ 0xF779, 0x9A53 },
	{ 0xF77A, 0x9A54 },
	{ 0xF77B, 0x9A4C },
	{ 0xF77C, 0x9A4F },
	{ 0xF77D, 0x9A48 },
	{ 0xF77E, 0x9A4A },
	{ 0xF77F, 0xFFFD },
	{ 0xF780, 0x722B },
	{ 0xF781, 0x5188 },
	{ 0xF782, 0x8279 },
	{ 0xF783, 0x8FB6 },
	{ 0xF784, 0x4E17 },
	{ 0xF785, 0x4EE2 },
	{ 0xF786, 0x4EDB },
	{ 0xF787, 0x51AD },
	{ 0xF788, 0x51F7 },
	{ 0xF789, 0x531B },
	{ 0xF78A, 0x5388 },
	{ 0xF78B, 0x5387 },
	{ 0xF78C, 0x53CF },
	{ 0xF78D, 0x53FD },
	{ 0xF78E, 0x53E7 },
	{ 0xF78F, 0x56DC },
	{ 0xF790, 0x56D9 },
	{ 0xF791, 0x5725 },
	{ 0xF792, 0x5727 },
	{ 0xF793, 0x5933 },
	{ 0xF794, 0x5C13 },
	{ 0xF795, 0x5C75 },
	{ 0xF796, 0x66F1 },
	{ 0xF797, 0x7F52 },
	{ 0xF798, 0x4E51 },
	{ 0xF799, 0x4E6A },
	{ 0xF79A, 0x4F0C },
	{ 0xF79B, 0x4EFE },
	{ 0xF79C, 0x4F1B },
	{ 0xF79D, 0x5173 },
	{ 0xF79E, 0x518E },
	{ 0xF79F, 0x52A5 },
	{ 0xF7A0, 0x52A7 },
	{ 0xF7A1, 0x9A49 },
	{ 0xF7A2, 0x9A52 },
	{ 0xF7A3, 0x9A50 },
	{ 0xF7A4, 0x9AD0 },
	{ 0xF7A5, 0x9B19 },
	{ 0xF7A6, 0x9B2B },
	{ 0xF7A7, 0x9B3B },
	{ 0xF7A8, 0x9B56 },
	{ 0xF7A9, 0x9B55 },
	{ 0xF7AA, 0x9C46 },
	{ 0xF7AB, 0x9C48 },
	{ 0xF7AC, 0x9C3F },
	{ 0xF7AD, 0x9C44 },
	{ 0xF7AE, 0x9C39 },
	{ 0xF7AF, 0x9C33 },
	{ 0xF7B0, 0x9C41 },
	{ 0xF7B1, 0x9C3C },
	{ 0xF7B2, 0x9C37 },
	{ 0xF7B3, 0x9C34 },
	{ 0xF7B4, 0x9C32 },
	{ 0xF7B5, 0x9C3D },
	{ 0xF7B6, 0x9C36 },
	{ 0xF7B7, 0x9DDB },
	{ 0xF7B8, 0x9DD2 },
	{ 0xF7B9, 0x9DDE },
	{ 0xF7BA, 0x9DDA },
	{ 0xF7BB, 0x9DCB },
	{ 0xF7BC, 0x9DD0 },
	{ 0xF7BD, 0x9DDC },
	{ 0xF7BE, 0x9DD1 },
	{ 0xF7BF, 0x9DDF },
	{ 0xF7C0, 0x9DE9 },
	{ 0xF7C1, 0x9DD9 },
	{ 0xF7C2, 0x9DD8 },
	{ 0xF7C3, 0x9DD6 },
	{ 0xF7C4, 0x9DF5 },
	{ 0xF7C5, 0x9DD5 },
	{ 0xF7C6, 0x9DDD },
	{ 0xF7C7, 0x9EB6 },
	{ 0xF7C8, 0x9EF0 },
	{ 0xF7C9, 0x9F35 },
	{ 0xF7CA, 0x9F33 },
	{ 0xF7CB, 0x9F32 },
	{ 0xF7CC, 0x9F42 },
	{ 0xF7CD, 0x9F6B },
	{ 0xF7CE, 0x9F95 },
	{ 0xF7CF, 0x9FA2 },
	{ 0xF7D0, 0x513D },
	{ 0xF7D1, 0x5299 },
	{ 0xF7D2, 0x58E8 },
	{ 0xF7D3, 0x58E7 },
	{ 0xF7D4, 0x5972 },
	{ 0xF7D5, 0x5B4D },
	{ 0xF7D6, 0x5DD8 },
	{ 0xF7D7, 0x882F },
	{ 0xF7D8, 0x5F4F },
	{ 0xF7D9, 0x6201 },
	{ 0xF7DA, 0x6203 },
	{ 0xF7DB, 0x6204 },
	{ 0xF7DC, 0x6529 },
	{ 0xF7DD, 0x6525 },
	{ 0xF7DE, 0x6596 },
	{ 0xF7DF, 0x66EB },
	{ 0xF7E0, 0x6B11 },
	{ 0xF7E1, 0x6B12 },
	{ 0xF7E2, 0x6B0F },
	{ 0xF7E3, 0x6BCA },
	{ 0xF7E4, 0x705B },
	{ 0xF7E5, 0x705A },
	{ 0xF7E6, 0x7222 },
	{ 0xF7E7, 0x7382 },
	{ 0xF7E8, 0x7381 },
	{ 0xF7E9, 0x7383 },
	{ 0xF7EA, 0x7670 },
	{ 0xF7EB, 0x77D4 },
	{ 0xF7EC, 0x7C67 },
	{ 0xF7ED, 0x7C66 },
	{ 0xF7EE, 0x7E95 },
	{ 0xF7EF, 0x826C },
	{ 0xF7F0, 0x863A },
	{ 0xF7F1, 0x8640 },
	{ 0xF7F2, 0x8639 },
	{ 0xF7F3, 0x863C },
	{ 0xF7F4, 0x8631 },
	{ 0xF7F5, 0x863B },
	{ 0xF7F6, 0x863E },
	{ 0xF7F7, 0x8830 },
	{ 0xF7F8, 0x8832 },
	{ 0xF7F9, 0x882E },
	{ 0xF7FA, 0x8833 },
	{ 0xF7FB, 0x8976 },
	{ 0xF7FC, 0x8974 },
	{ 0xF7FD, 0x8973 },
	{ 0xF7FE, 0x89FE },
	{ 0xF840, 0x8B8C },
	{ 0xF841, 0x8B8E },
	{ 0xF842, 0x8B8B },
	{ 0xF843, 0x8B88 },
	{ 0xF844, 0x8C45 },
	{ 0xF845, 0x8D19 },
	{ 0xF846, 0x8E98 },
	{ 0xF847, 0x8F64 },
	{ 0xF848, 0x8F63 },
	{ 0xF849, 0x91BC },
	{ 0xF84A, 0x9462 },
	{ 0xF84B, 0x9455 },
	{ 0xF84C, 0x945D },
	{ 0xF84D, 0x9457 },
	{ 0xF84E, 0x945E },
	{ 0xF84F, 0x97C4 },
	{ 0xF850, 0x97C5 },
	{ 0xF851, 0x9800 },
	{ 0xF852, 0x9A56 },
	{ 0xF853, 0x9A59 },
	{ 0xF854, 0x9B1E },
	{ 0xF855, 0x9B1F },
	{ 0xF856, 0x9B20 },
	{ 0xF857, 0x9C52 },
	{ 0xF858, 0x9C58 },
	{ 0xF859, 0x9C50 },
	{ 0xF85A, 0x9C4A },
	{ 0xF85B, 0x9C4D },
	{ 0xF85C, 0x9C4B },
	{ 0xF85D, 0x9C55 },
	{ 0xF85E, 0x9C59 },
	{ 0xF85F, 0x9C4C },
	{ 0xF860, 0x9C4E },
	{ 0xF861, 0x9DFB },
	{ 0xF862, 0x9DF7 },
	{ 0xF863, 0x9DEF },
	{ 0xF864, 0x9DE3 },
	{ 0xF865, 0x9DEB },
	{ 0xF866, 0x9DF8 },
	{ 0xF867, 0x9DE4 },
	{ 0xF868, 0x9DF6 },
	{ 0xF869, 0x9DE1 },
	{ 0xF86A, 0x9DEE },
	{ 0xF86B, 0x9DE6 },
	{ 0xF86C, 0x9DF2 },
	{ 0xF86D, 0x9DF0 },
	{ 0xF86E, 0x9DE2 },
	{ 0xF86F, 0x9DEC },
	{ 0xF870, 0x9DF4 },
	{ 0xF871, 0x9DF3 },
	{ 0xF872, 0x9DE8 },
	{ 0xF873, 0x9DED },
	{ 0xF874, 0x9EC2 },
	{ 0xF875, 0x9ED0 },
	{ 0xF876, 0x9EF2 },
	{ 0xF877, 0x9EF3 },
	{ 0xF878, 0x9F06 },
	{ 0xF879, 0x9F1C },
	{ 0xF87A, 0x9F38 },
	{ 0xF87B, 0x9F37 },
	{ 0xF87C, 0x9F36 },
	{ 0xF87D, 0x9F43 },
	{ 0xF87E, 0x9F4F },
	{ 0xF87F, 0xFFFD },
	{ 0xF880, 0x52A4 },
	{ 0xF881, 0x53BD },
	{ 0xF882, 0x5402 },
	{ 0xF883, 0x572B },
	{ 0xF884, 0x591B },
	{ 0xF885, 0x5935 },
	{ 0xF886, 0x5C17 },
	{ 0xF887, 0x5C70 },
	{ 0xF888, 0x5C7D },
	{ 0xF889, 0x5DE9 },
	{ 0xF88A, 0x5F19 },
	{ 0xF88B, 0x5F1C },
	{ 0xF88C, 0x5F75 },
	{ 0xF88D, 0x5FC8 },
	{ 0xF88E, 0x6C12 },
	{ 0xF88F, 0x72B3 },
	{ 0xF890, 0x7390 },
	{ 0xF891, 0x7536 },
	{ 0xF892, 0x8281 },
	{ 0xF893, 0x8FB8 },
	{ 0xF894, 0x4E23 },
	{ 0xF895, 0x4F2E },
	{ 0xF896, 0x514F },
	{ 0xF897, 0x51BA },
	{ 0xF898, 0x5222 },
	{ 0xF899, 0x52AF },
	{ 0xF89A, 0x52B0 },
	{ 0xF89B, 0x52B1 },
	{ 0xF89C, 0x5364 },
	{ 0xF89D, 0x53D3 },
	{ 0xF89E, 0x593F },
	{ 0xF89F, 0x598B },
	{ 0xF8A0, 0x5991 },
	{ 0xF8A1, 0x9F71 },
	{ 0xF8A2, 0x9F70 },
	{ 0xF8A3, 0x9F6E },
	{ 0xF8A4, 0x9F6F },
	{ 0xF8A5, 0x56D3 },
	{ 0xF8A6, 0x56CD },
	{ 0xF8A7, 0x5B4E },
	{ 0xF8A8, 0x5C6D },
	{ 0xF8A9, 0x652D },
	{ 0xF8AA, 0x66ED },
	{ 0xF8AB, 0x66EE },
	{ 0xF8AC, 0x6B13 },
	{ 0xF8AD, 0x705F },
	{ 0xF8AE, 0x7061 },
	{ 0xF8AF, 0x705D },
	{ 0xF8B0, 0x7060 },
	{ 0xF8B1, 0x7223 },
	{ 0xF8B2, 0x74DB },
	{ 0xF8B3, 0x74E5 },
	{ 0xF8B4, 0x77D5 },
	{ 0xF8B5, 0x7938 },
	{ 0xF8B6, 0x79B7 },
	{ 0xF8B7, 0x79B6 },
	{ 0xF8B8, 0x7C6A },
	{ 0xF8B9, 0x7E97 },
	{ 0xF8BA, 0x7F89 },
	{ 0xF8BB, 0x826D },
	{ 0xF8BC, 0x8643 },
	{ 0xF8BD, 0x8838 },
	{ 0xF8BE, 0x8837 },
	{ 0xF8BF, 0x8835 },
	{ 0xF8C0, 0x884B },
	{ 0xF8C1, 0x8B94 },
	{ 0xF8C2, 0x8B95 },
	{ 0xF8C3, 0x8E9E },
	{ 0xF8C4, 0x8E9F },
	{ 0xF8C5, 0x8EA0 },
	{ 0xF8C6, 0x8E9D },
	{ 0xF8C7, 0x91BE },
	{ 0xF8C8, 0x91BD },
	{ 0xF8C9, 0x91C2 },
	{ 0xF8CA, 0x946B },
	{ 0xF8CB, 0x9468 },
	{ 0xF8CC, 0x9469 },
	{ 0xF8CD, 0x96E5 },
	{ 0xF8CE, 0x9746 },
	{ 0xF8CF, 0x9743 },
	{ 0xF8D0, 0x9747 },
	{ 0xF8D1, 0x97C7 },
	{ 0xF8D2, 0x97E5 },
	{ 0xF8D3, 0x9A5E },
	{ 0xF8D4, 0x9AD5 },
	{ 0xF8D5, 0x9B59 },
	{ 0xF8D6, 0x9C63 },
	{ 0xF8D7, 0x9C67 },
	{ 0xF8D8, 0x9C66 },
	{ 0xF8D9, 0x9C62 },
	{ 0xF8DA, 0x9C5E },
	{ 0xF8DB, 0x9C60 },
	{ 0xF8DC, 0x9E02 },
	{ 0xF8DD, 0x9DFE },
	{ 0xF8DE, 0x9E07 },
	{ 0xF8DF, 0x9E03 },
	{ 0xF8E0, 0x9E06 },
	{ 0xF8E1, 0x9E05 },
	{ 0xF8E2, 0x9E00 },
	{ 0xF8E3, 0x9E01 },
	{ 0xF8E4, 0x9E09 },
	{ 0xF8E5, 0x9DFF },
	{ 0xF8E6, 0x9DFD },
	{ 0xF8E7, 0x9E04 },
	{ 0xF8E8, 0x9EA0 },
	{ 0xF8E9, 0x9F1E },
	{ 0xF8EA, 0x9F46 },
	{ 0xF8EB, 0x9F74 },
	{ 0xF8EC, 0x9F75 },
	{ 0xF8ED, 0x9F76 },
	{ 0xF8EE, 0x56D4 },
	{ 0xF8EF, 0x652E },
	{ 0xF8F0, 0x65B8 },
	{ 0xF8F1, 0x6B18 },
	{ 0xF8F2, 0x6B19 },
	{ 0xF8F3, 0x6B17 },
	{ 0xF8F4, 0x6B1A },
	{ 0xF8F5, 0x7062 },
	{ 0xF8F6, 0x7226 },
	{ 0xF8F7, 0x72AA },
	{ 0xF8F8, 0x77D8 },
	{ 0xF8F9, 0x77D9 },
	{ 0xF8FA, 0x7939 },
	{ 0xF8FB, 0x7C69 },
	{ 0xF8FC, 0x7C6B },
	{ 0xF8FD, 0x7CF6 },
	{ 0xF8FE, 0x7E9A },
	{ 0xF940, 0x7E98 },
	{ 0xF941, 0x7E9B },
	{ 0xF942, 0x7E99 },
	{ 0xF943, 0x81E0 },
	{ 0xF944, 0x81E1 },
	{ 0xF945, 0x8646 },
	{ 0xF946, 0x8647 },
	{ 0xF947, 0x8648 },
	{ 0xF948, 0x8979 },
	{ 0xF949, 0x897A },
	{ 0xF94A, 0x897C },
	{ 0xF94B, 0x897B },
	{ 0xF94C, 0x89FF },
	{ 0xF94D, 0x8B98 },
	{ 0xF94E, 0x8B99 },
	{ 0xF94F, 0x8EA5 },
	{ 0xF950, 0x8EA4 },
	{ 0xF951, 0x8EA3 },
	{ 0xF952, 0x946E },
	{ 0xF953, 0x946D },
	{ 0xF954, 0x946F },
	{ 0xF955, 0x9471 },
	{ 0xF956, 0x9473 },
	{ 0xF957, 0x9749 },
	{ 0xF958, 0x9872 },
	{ 0xF959, 0x995F },
	{ 0xF95A, 0x9C68 },
	{ 0xF95B, 0x9C6E },
	{ 0xF95C, 0x9C6D },
	{ 0xF95D, 0x9E0B },
	{ 0xF95E, 0x9E0D },
	{ 0xF95F, 0x9E10 },
	{ 0xF960, 0x9E0F },
	{ 0xF961, 0x9E12 },
	{ 0xF962, 0x9E11 },
	{ 0xF963, 0x9EA1 },
	{ 0xF964, 0x9EF5 },
	{ 0xF965, 0x9F09 },
	{ 0xF966, 0x9F47 },
	{ 0xF967, 0x9F78 },
	{ 0xF968, 0x9F7B },
	{ 0xF969, 0x9F7A },
	{ 0xF96A, 0x9F79 },
	{ 0xF96B, 0x571E },
	{ 0xF96C, 0x7066 },
	{ 0xF96D, 0x7C6F },
	{ 0xF96E, 0x883C },
	{ 0xF96F, 0x8DB2 },
	{ 0xF970, 0x8EA6 },
	{ 0xF971, 0x91C3 },
	{ 0xF972, 0x9474 },
	{ 0xF973, 0x9478 },
	{ 0xF974, 0x9476 },
	{ 0xF975, 0x9475 },
	{ 0xF976, 0x9A60 },
	{ 0xF977, 0x9C74 },
	{ 0xF978, 0x9C73 },
	{ 0xF979, 0x9C71 },
	{ 0xF97A, 0x9C75 },
	{ 0xF97B, 0x9E14 },
	{ 0xF97C, 0x9E13 },
	{ 0xF97D, 0x9EF6 },
	{ 0xF97E, 0x9F0A },
	{ 0xF97F, 0xFFFD },
	{ 0xF980, 0x5995 },
	{ 0xF981, 0x5B8A },
	{ 0xF982, 0x5C87 },
	{ 0xF983, 0x5E0D },
	{ 0xF984, 0x5E8E },
	{ 0xF985, 0x5F7A },
	{ 0xF986, 0x6290 },
	{ 0xF987, 0x629A },
	{ 0xF988, 0x653C },
	{ 0xF989, 0x653A },
	{ 0xF98A, 0x6598 },
	{ 0xF98B, 0x6765 },
	{ 0xF98C, 0x79C2 },
	{ 0xF98D, 0x809E },
	{ 0xF98E, 0x81EB },
	{ 0xF98F, 0x8289 },
	{ 0xF990, 0x8296 },
	{ 0xF991, 0x8287 },
	{ 0xF992, 0x8FC0 },
	{ 0xF993, 0x8FC3 },
	{ 0xF994, 0x9578 },
	{ 0xF995, 0x9625 },
	{ 0xF996, 0x4E75 },
	{ 0xF997, 0x4E74 },
	{ 0xF998, 0x4F99 },
	{ 0xF999, 0x4F71 },
	{ 0xF99A, 0x5153 },
	{ 0xF99B, 0x51BF },
	{ 0xF99C, 0x51C0 },
	{ 0xF99D, 0x51EE },
	{ 0xF99E, 0x523D },
	{ 0xF99F, 0x52BD },
	{ 0xF9A0, 0x530C },
	{ 0xF9A1, 0x9FA4 },
	{ 0xF9A2, 0x7068 },
	{ 0xF9A3, 0x7065 },
	{ 0xF9A4, 0x7CF7 },
	{ 0xF9A5, 0x866A },
	{ 0xF9A6, 0x883E },
	{ 0xF9A7, 0x883D },
	{ 0xF9A8, 0x883F },
	{ 0xF9A9, 0x8B9E },
	{ 0xF9AA, 0x8C9C },
	{ 0xF9AB, 0x8EA9 },
	{ 0xF9AC, 0x8EC9 },
	{ 0xF9AD, 0x974B },
	{ 0xF9AE, 0x9873 },
	{ 0xF9AF, 0x9874 },
	{ 0xF9B0, 0x98CC },
	{ 0xF9B1, 0x9961 },
	{ 0xF9B2, 0x99AB },
	{ 0xF9B3, 0x9A64 },
	{ 0xF9B4, 0x9A66 },
	{ 0xF9B5, 0x9A67 },
	{ 0xF9B6, 0x9B24 },
	{ 0xF9B7, 0x9E15 },
	{ 0xF9B8, 0x9E17 },
	{ 0xF9B9, 0x9F48 },
	{ 0xF9BA, 0x6207 },
	{ 0xF9BB, 0x6B1E },
	{ 0xF9BC, 0x7227 },
	{ 0xF9BD, 0x864C },
	{ 0xF9BE, 0x8EA8 },
	{ 0xF9BF, 0x9482 },
	{ 0xF9C0, 0x9480 },
	{ 0xF9C1, 0x9481 },
	{ 0xF9C2, 0x9A69 },
	{ 0xF9C3, 0x9A68 },
	{ 0xF9C4, 0x9B2E },
	{ 0xF9C5, 0x9E19 },
	{ 0xF9C6, 0x7229 },
	{ 0xF9C7, 0x864B },
	{ 0xF9C8, 0x8B9F },
	{ 0xF9C9, 0x9483 },
	{ 0xF9CA, 0x9C79 },
	{ 0xF9CB, 0x9EB7 },
	{ 0xF9CC, 0x7675 },
	{ 0xF9CD, 0x9A6B },
	{ 0xF9CE, 0x9C7A },
	{ 0xF9CF, 0x9E1D },
	{ 0xF9D0, 0x7069 },
	{ 0xF9D1, 0x706A },
	{ 0xF9D2, 0x9EA4 },
	{ 0xF9D3, 0x9F7E },
	{ 0xF9D4, 0x9F49 },
	{ 0xF9D5, 0x9F98 },
	{ 0xF9D6, 0x7881 },
	{ 0xF9D7, 0x92B9 },
	{ 0xF9D8, 0x88CF },
	{ 0xF9D9, 0x58BB },
	{ 0xF9DA, 0x6052 },
	{ 0xF9DB, 0x7CA7 },
	{ 0xF9DC, 0x5AFA },
	{ 0xF9DD, 0x2554 },
	{ 0xF9DE, 0x2566 },
	{ 0xF9DF, 0x2557 },
	{ 0xF9E0, 0x2560 },
	{ 0xF9E1, 0x256C },
	{ 0xF9E2, 0x2563 },
	{ 0xF9E3, 0x255A },
	{ 0xF9E4, 0x2569 },
	{ 0xF9E5, 0x255D },
	{ 0xF9E6, 0x2552 },
	{ 0xF9E7, 0x2564 },
	{ 0xF9E8, 0x2555 },
	{ 0xF9E9, 0x255E },
	{ 0xF9EA, 0x256A },
	{ 0xF9EB, 0x2561 },
	{ 0xF9EC, 0x2558 },
	{ 0xF9ED, 0x2567 },
	{ 0xF9EE, 0x255B },
	{ 0xF9EF, 0x2553 },
	{ 0xF9F0, 0x2565 },
	{ 0xF9F1, 0x2556 },
	{ 0xF9F2, 0x255F },
	{ 0xF9F3, 0x256B },
	{ 0xF9F4, 0x2562 },
	{ 0xF9F5, 0x2559 },
	{ 0xF9F6, 0x2568 },
	{ 0xF9F7, 0x255C },
	{ 0xF9F8, 0x2551 },
	{ 0xF9F9, 0x2550 },
	{ 0xF9FA, 0x2554 },
	{ 0xF9FB, 0x2557 },
	{ 0xF9FC, 0x255A },
	{ 0xF9FD, 0x255D },
	{ 0xF9FE, 0x2588 },
	{ 0xFA40, 0xFFFD },
	{ 0xFA41, 0xFFFD },
	{ 0xFA42, 0xFFFD },
	{ 0xFA43, 0xFFFD },
	{ 0xFA44, 0xFFFD },
	{ 0xFA45, 0xFFFD },
	{ 0xFA46, 0xFFFD },
	{ 0xFA47, 0xFFFD },
	{ 0xFA48, 0xFFFD },
	{ 0xFA49, 0xFFFD },
	{ 0xFA4A, 0xFFFD },
	{ 0xFA4B, 0xFFFD },
	{ 0xFA4C, 0xFFFD },
	{ 0xFA4D, 0xFFFD },
	{ 0xFA4E, 0xFFFD },
	{ 0xFA4F, 0xFFFD },
	{ 0xFA50, 0xFFFD },
	{ 0xFA51, 0xFFFD },
	{ 0xFA52, 0xFFFD },
	{ 0xFA53, 0xFFFD },
	{ 0xFA54, 0xFFFD },
	{ 0xFA55, 0xFFFD },
	{ 0xFA56, 0xFFFD },
	{ 0xFA57, 0xFFFD },
	{ 0xFA58, 0xFFFD },
	{ 0xFA59, 0xFFFD },
	{ 0xFA5A, 0xFFFD },
	{ 0xFA5B, 0xFFFD },
	{ 0xFA5C, 0xFFFD },
	{ 0xFA5D, 0xFFFD },
	{ 0xFA5E, 0xFFFD },
	{ 0xFA5F, 0xFFFD },
	{ 0xFA60, 0xFFFD },
	{ 0xFA61, 0xFFFD },
	{ 0xFA62, 0xFFFD },
	{ 0xFA63, 0xFFFD },
	{ 0xFA64, 0xFFFD },
	{ 0xFA65, 0xFFFD },
	{ 0xFA66, 0xFFFD },
	{ 0xFA67, 0xFFFD },
	{ 0xFA68, 0xFFFD },
	{ 0xFA69, 0xFFFD },
	{ 0xFA6A, 0xFFFD },
	{ 0xFA6B, 0xFFFD },
	{ 0xFA6C, 0xFFFD },
	{ 0xFA6D, 0xFFFD },
	{ 0xFA6E, 0xFFFD },
	{ 0xFA6F, 0xFFFD },
	{ 0xFA70, 0xFFFD },
	{ 0xFA71, 0xFFFD },
	{ 0xFA72, 0xFFFD },
	{ 0xFA73, 0xFFFD },
	{ 0xFA74, 0xFFFD },
	{ 0xFA75, 0xFFFD },
	{ 0xFA76, 0xFFFD },
	{ 0xFA77, 0xFFFD },
	{ 0xFA78, 0xFFFD },
	{ 0xFA79, 0xFFFD },
	{ 0xFA7A, 0xFFFD },
	{ 0xFA7B, 0xFFFD },
	{ 0xFA7C, 0xFFFD },
	{ 0xFA7D, 0xFFFD },
	{ 0xFA7E, 0xFFFD },
	{ 0xFA7F, 0xFFFD },
	{ 0xFA80, 0x7F37 },
	{ 0xFA81, 0x53C0 },
	{ 0xFA82, 0x546E },
	{ 0xFA83, 0x5483 },
	{ 0xFA84, 0x545E },
	{ 0xFA85, 0x545D },
	{ 0xFA86, 0x577E },
	{ 0xFA87, 0x5779 },
	{ 0xFA88, 0x577A },
	{ 0xFA89, 0x576C },
	{ 0xFA8A, 0x5787 },
	{ 0xFA8B, 0x591D },
	{ 0xFA8C, 0x5946 },
	{ 0xFA8D, 0x5943 },
	{ 0xFA8E, 0x5B61 },
	{ 0xFA8F, 0x5B66 },
	{ 0xFA90, 0x5B90 },
	{ 0xFA91, 0x5C29 },
	{ 0xFA92, 0x5CB2 },
	{ 0xFA93, 0x5CC0 },
	{ 0xFA94, 0x601F },
	{ 0xFA95, 0x5FE2 },
	{ 0xFA96, 0x6616 },
	{ 0xFA97, 0x65F9 },
	{ 0xFA98, 0x6788 },
	{ 0xFA99, 0x679B },
	{ 0xFA9A, 0x676E },
	{ 0xFA9B, 0x679E },
	{ 0xFA9C, 0x6B24 },
	{ 0xFA9D, 0x6B7D },
	{ 0xFA9E, 0x6CE6 },
	{ 0xFA9F, 0x6CCB },
	{ 0xFAA0, 0x6CB5 },
	{ 0xFAA1, 0xFFFD },
	{ 0xFAA2, 0xFFFD },
	{ 0xFAA3, 0xFFFD },
	{ 0xFAA4, 0xFFFD },
	{ 0xFAA5, 0xFFFD },
	{ 0xFAA6, 0xFFFD },
	{ 0xFAA7, 0xFFFD },
	{ 0xFAA8, 0xFFFD },
	{ 0xFAA9, 0xFFFD },
	{ 0xFAAA, 0xFFFD },
	{ 0xFAAB, 0xFFFD },
	{ 0xFAAC, 0xFFFD },
	{ 0xFAAD, 0xFFFD },
	{ 0xFAAE, 0xFFFD },
	{ 0xFAAF, 0xFFFD },
	{ 0xFAB0, 0xFFFD },
	{ 0xFAB1, 0xFFFD },
	{ 0xFAB2, 0xFFFD },
	{ 0xFAB3, 0xFFFD },
	{ 0xFAB4, 0xFFFD },
	{ 0xFAB5, 0xFFFD },
	{ 0xFAB6, 0xFFFD },
	{ 0xFAB7, 0xFFFD },
	{ 0xFAB8, 0xFFFD },
	{ 0xFAB9, 0xFFFD },
	{ 0xFABA, 0xFFFD },
	{ 0xFABB, 0xFFFD },
	{ 0xFABC, 0xFFFD },
	{ 0xFABD, 0xFFFD },
	{ 0xFABE, 0xFFFD },
	{ 0xFABF, 0xFFFD },
	{ 0xFAC0, 0xFFFD },
	{ 0xFAC1, 0xFFFD },
	{ 0xFAC2, 0xFFFD },
	{ 0xFAC3, 0xFFFD },
	{ 0xFAC4, 0xFFFD },
	{ 0xFAC5, 0xFFFD },
	{ 0xFAC6, 0xFFFD },
	{ 0xFAC7, 0xFFFD },
	{ 0xFAC8, 0xFFFD },
	{ 0xFAC9, 0xFFFD },
	{ 0xFACA, 0xFFFD },
	{ 0xFACB, 0xFFFD },
	{ 0xFACC, 0xFFFD },
	{ 0xFACD, 0xFFFD },
	{ 0xFACE, 0xFFFD },
	{ 0xFACF, 0xFFFD },
	{ 0xFAD0, 0xFFFD },
	{ 0xFAD1, 0xFFFD },
	{ 0xFAD2, 0xFFFD },
	{ 0xFAD3, 0xFFFD },
	{ 0xFAD4, 0xFFFD },
	{ 0xFAD5, 0xFFFD },
	{ 0xFAD6, 0xFFFD },
	{ 0xFAD7, 0xFFFD },
	{ 0xFAD8, 0xFFFD },
	{ 0xFAD9, 0xFFFD },
	{ 0xFADA, 0xFFFD },
	{ 0xFADB, 0xFFFD },
	{ 0xFADC, 0xFFFD },
	{ 0xFADD, 0xFFFD },
	{ 0xFADE, 0xFFFD },
	{ 0xFADF, 0xFFFD },
	{ 0xFAE0, 0xFFFD },
	{ 0xFAE1, 0xFFFD },
	{ 0xFAE2, 0xFFFD },
	{ 0xFAE3, 0xFFFD },
	{ 0xFAE4, 0xFFFD },
	{ 0xFAE5, 0xFFFD },
	{ 0xFAE6, 0xFFFD },
	{ 0xFAE7, 0xFFFD },
	{ 0xFAE8, 0xFFFD },
	{ 0xFAE9, 0xFFFD },
	{ 0xFAEA, 0xFFFD },
	{ 0xFAEB, 0xFFFD },
	{ 0xFAEC, 0xFFFD },
	{ 0xFAED, 0xFFFD },
	{ 0xFAEE, 0xFFFD },
	{ 0xFAEF, 0xFFFD },
	{ 0xFAF0, 0xFFFD },
	{ 0xFAF1, 0xFFFD },
	{ 0xFAF2, 0xFFFD },
	{ 0xFAF3, 0xFFFD },
	{ 0xFAF4, 0xFFFD },
	{ 0xFAF5, 0xFFFD },
	{ 0xFAF6, 0xFFFD },
	{ 0xFAF7, 0xFFFD },
	{ 0xFAF8, 0xFFFD },
	{ 0xFAF9, 0xFFFD },
	{ 0xFAFA, 0xFFFD },
	{ 0xFAFB, 0xFFFD },
	{ 0xFAFC, 0xFFFD },
	{ 0xFAFD, 0xFFFD },
	{ 0xFAFE, 0xFFFD },
	{ 0xFB40, 0xFFFD },
	{ 0xFB41, 0xFFFD },
	{ 0xFB42, 0xFFFD },
	{ 0xFB43, 0xFFFD },
	{ 0xFB44, 0xFFFD },
	{ 0xFB45, 0xFFFD },
	{ 0xFB46, 0xFFFD },
	{ 0xFB47, 0xFFFD },
	{ 0xFB48, 0xFFFD },
	{ 0xFB49, 0xFFFD },
	{ 0xFB4A, 0xFFFD },
	{ 0xFB4B, 0xFFFD },
	{ 0xFB4C, 0xFFFD },
	{ 0xFB4D, 0xFFFD },
	{ 0xFB4E, 0xFFFD },
	{ 0xFB4F, 0xFFFD },
	{ 0xFB50, 0xFFFD },
	{ 0xFB51, 0xFFFD },
	{ 0xFB52, 0xFFFD },
	{ 0xFB53, 0xFFFD },
	{ 0xFB54, 0xFFFD },
	{ 0xFB55, 0xFFFD },
	{ 0xFB56, 0xFFFD },
	{ 0xFB57, 0xFFFD },
	{ 0xFB58, 0xFFFD },
	{ 0xFB59, 0xFFFD },
	{ 0xFB5A, 0xFFFD },
	{ 0xFB5B, 0xFFFD },
	{ 0xFB5C, 0xFFFD },
	{ 0xFB5D, 0xFFFD },
	{ 0xFB5E, 0xFFFD },
	{ 0xFB5F, 0xFFFD },
	{ 0xFB60, 0xFFFD },
	{ 0xFB61, 0xFFFD },
	{ 0xFB62, 0xFFFD },
	{ 0xFB63, 0xFFFD },
	{ 0xFB64, 0xFFFD },
	{ 0xFB65, 0xFFFD },
	{ 0xFB66, 0xFFFD },
	{ 0xFB67, 0xFFFD },
	{ 0xFB68, 0xFFFD },
	{ 0xFB69, 0xFFFD },
	{ 0xFB6A, 0xFFFD },
	{ 0xFB6B, 0xFFFD },
	{ 0xFB6C, 0xFFFD },
	{ 0xFB6D, 0xFFFD },
	{ 0xFB6E, 0xFFFD },
	{ 0xFB6F, 0xFFFD },
	{ 0xFB70, 0xFFFD },
	{ 0xFB71, 0xFFFD },
	{ 0xFB72, 0xFFFD },
	{ 0xFB73, 0xFFFD },
	{ 0xFB74, 0xFFFD },
	{ 0xFB75, 0xFFFD },
	{ 0xFB76, 0xFFFD },
	{ 0xFB77, 0xFFFD },
	{ 0xFB78, 0xFFFD },
	{ 0xFB79, 0xFFFD },
	{ 0xFB7A, 0xFFFD },
	{ 0xFB7B, 0xFFFD },
	{ 0xFB7C, 0xFFFD },
	{ 0xFB7D, 0xFFFD },
	{ 0xFB7E, 0xFFFD },
	{ 0xFB7F, 0xFFFD },
	{ 0xFB80, 0x7097 },
	{ 0xFB81, 0x709B },
	{ 0xFB82, 0x726B },
	{ 0xFB83, 0x72D5 },
	{ 0xFB84, 0x7543 },
	{ 0xFB85, 0x759C },
	{ 0xFB86, 0x77E4 },
	{ 0xFB87, 0x7ACE },
	{ 0xFB88, 0x8013 },
	{ 0xFB89, 0x80B7 },
	{ 0xFB8A, 0x80B9 },
	{ 0xFB8B, 0x81E4 },
	{ 0xFB8C, 0x81FD },
	{ 0xFB8D, 0x820F },
	{ 0xFB8E, 0x82BF },
	{ 0xFB8F, 0x82CA },
	{ 0xFB90, 0x82C1 },
	{ 0xFB91, 0x8FD0 },
	{ 0xFB92, 0x90AE },
	{ 0xFB93, 0x9638 },
	{ 0xFB94, 0x4FBC },
	{ 0xFB95, 0x4FE9 },
	{ 0xFB96, 0x4FBD },
	{ 0xFB97, 0x4FE2 },
	{ 0xFB98, 0x5158 },
	{ 0xFB99, 0x52C6 },
	{ 0xFB9A, 0x52C8 },
	{ 0xFB9B, 0x5328 },
	{ 0xFB9C, 0x5329 },
	{ 0xFB9D, 0x57B4 },
	{ 0xFB9E, 0x57A9 },
	{ 0xFB9F, 0x5B68 },
	{ 0xFBA0, 0x5F2B },
	{ 0xFBA1, 0xFFFD },
	{ 0xFBA2, 0xFFFD },
	{ 0xFBA3, 0xFFFD },
	{ 0xFBA4, 0xFFFD },
	{ 0xFBA5, 0xFFFD },
	{ 0xFBA6, 0xFFFD },
	{ 0xFBA7, 0xFFFD },
	{ 0xFBA8, 0xFFFD },
	{ 0xFBA9, 0xFFFD },
	{ 0xFBAA, 0xFFFD },
	{ 0xFBAB, 0xFFFD },
	{ 0xFBAC, 0xFFFD },
	{ 0xFBAD, 0xFFFD },
	{ 0xFBAE, 0xFFFD },
	{ 0xFBAF, 0xFFFD },
	{ 0xFBB0, 0xFFFD },
	{ 0xFBB1, 0xFFFD },
	{ 0xFBB2, 0xFFFD },
	{ 0xFBB3, 0xFFFD },
	{ 0xFBB4, 0xFFFD },
	{ 0xFBB5, 0xFFFD },
	{ 0xFBB6, 0xFFFD },
	{ 0xFBB7, 0xFFFD },
	{ 0xFBB8, 0xFFFD },
	{ 0xFBB9, 0xFFFD },
	{ 0xFBBA, 0xFFFD },
	{ 0xFBBB, 0xFFFD },
	{ 0xFBBC, 0xFFFD },
	{ 0xFBBD, 0xFFFD },
	{ 0xFBBE, 0xFFFD },
	{ 0xFBBF, 0xFFFD },
	{ 0xFBC0, 0xFFFD },
	{ 0xFBC1, 0xFFFD },
	{ 0xFBC2, 0xFFFD },
	{ 0xFBC3, 0xFFFD },
	{ 0xFBC4, 0xFFFD },
	{ 0xFBC5, 0xFFFD },
	{ 0xFBC6, 0xFFFD },
	{ 0xFBC7, 0xFFFD },
	{ 0xFBC8, 0xFFFD },
	{ 0xFBC9, 0xFFFD },
	{ 0xFBCA, 0xFFFD },
	{ 0xFBCB, 0xFFFD },
	{ 0xFBCC, 0xFFFD },
	{ 0xFBCD, 0xFFFD },
	{ 0xFBCE, 0xFFFD },
	{ 0xFBCF, 0xFFFD },
	{ 0xFBD0, 0xFFFD },
	{ 0xFBD1, 0xFFFD },
	{ 0xFBD2, 0xFFFD },
	{ 0xFBD3, 0xFFFD },
	{ 0xFBD4, 0xFFFD },
	{ 0xFBD5, 0xFFFD },
	{ 0xFBD6, 0xFFFD },
	{ 0xFBD7, 0xFFFD },
	{ 0xFBD8, 0xFFFD },
	{ 0xFBD9, 0xFFFD },
	{ 0xFBDA, 0xFFFD },
	{ 0xFBDB, 0xFFFD },
	{ 0xFBDC, 0xFFFD },
	{ 0xFBDD, 0xFFFD },
	{ 0xFBDE, 0xFFFD },
	{ 0xFBDF, 0xFFFD },
	{ 0xFBE0, 0xFFFD },
	{ 0xFBE1, 0xFFFD },
	{ 0xFBE2, 0xFFFD },
	{ 0xFBE3, 0xFFFD },
	{ 0xFBE4, 0xFFFD },
	{ 0xFBE5, 0xFFFD },
	{ 0xFBE6, 0xFFFD },
	{ 0xFBE7, 0xFFFD },
	{ 0xFBE8, 0xFFFD },
	{ 0xFBE9, 0xFFFD },
	{ 0xFBEA, 0xFFFD },
	{ 0xFBEB, 0xFFFD },
	{ 0xFBEC, 0xFFFD },
	{ 0xFBED, 0xFFFD },
	{ 0xFBEE, 0xFFFD },
	{ 0xFBEF, 0xFFFD },
	{ 0xFBF0, 0xFFFD },
	{ 0xFBF1, 0xFFFD },
	{ 0xFBF2, 0xFFFD },
	{ 0xFBF3, 0xFFFD },
	{ 0xFBF4, 0xFFFD },
	{ 0xFBF5, 0xFFFD },
	{ 0xFBF6, 0xFFFD },
	{ 0xFBF7, 0xFFFD },
	{ 0xFBF8, 0xFFFD },
	{ 0xFBF9, 0xFFFD },
	{ 0xFBFA, 0xFFFD },
	{ 0xFBFB, 0xFFFD },
	{ 0xFBFC, 0xFFFD },
	{ 0xFBFD, 0xFFFD },
	{ 0xFBFE, 0xFFFD },
	{ 0xFC40, 0xFFFD },
	{ 0xFC41, 0xFFFD },
	{ 0xFC42, 0xFFFD },
	{ 0xFC43, 0xFFFD },
	{ 0xFC44, 0xFFFD },
	{ 0xFC45, 0xFFFD },
	{ 0xFC46, 0xFFFD },
	{ 0xFC47, 0xFFFD },
	{ 0xFC48, 0xFFFD },
	{ 0xFC49, 0xFFFD },
	{ 0xFC4A, 0xFFFD },
	{ 0xFC4B, 0xFFFD },
	{ 0xFC4C, 0xFFFD },
	{ 0xFC4D, 0xFFFD },
	{ 0xFC4E, 0xFFFD },
	{ 0xFC4F, 0xFFFD },
	{ 0xFC50, 0xFFFD },
	{ 0xFC51, 0xFFFD },
	{ 0xFC52, 0xFFFD },
	{ 0xFC53, 0xFFFD },
	{ 0xFC54, 0xFFFD },
	{ 0xFC55, 0xFFFD },
	{ 0xFC56, 0xFFFD },
	{ 0xFC57, 0xFFFD },
	{ 0xFC58, 0xFFFD },
	{ 0xFC59, 0xFFFD },
	{ 0xFC5A, 0xFFFD },
	{ 0xFC5B, 0xFFFD },
	{ 0xFC5C, 0xFFFD },
	{ 0xFC5D, 0xFFFD },
	{ 0xFC5E, 0xFFFD },
	{ 0xFC5F, 0xFFFD },
	{ 0xFC60, 0xFFFD },
	{ 0xFC61, 0xFFFD },
	{ 0xFC62, 0xFFFD },
	{ 0xFC63, 0xFFFD },
	{ 0xFC64, 0xFFFD },
	{ 0xFC65, 0xFFFD },
	{ 0xFC66, 0xFFFD },
	{ 0xFC67, 0xFFFD },
	{ 0xFC68, 0xFFFD },
	{ 0xFC69, 0xFFFD },
	{ 0xFC6A, 0xFFFD },
	{ 0xFC6B, 0xFFFD },
	{ 0xFC6C, 0xFFFD },
	{ 0xFC6D, 0xFFFD },
	{ 0xFC6E, 0xFFFD },
	{ 0xFC6F, 0xFFFD },
	{ 0xFC70, 0xFFFD },
	{ 0xFC71, 0xFFFD },
	{ 0xFC72, 0xFFFD },
	{ 0xFC73, 0xFFFD },
	{ 0xFC74, 0xFFFD },
	{ 0xFC75, 0xFFFD },
	{ 0xFC76, 0xFFFD },
	{ 0xFC77, 0xFFFD },
	{ 0xFC78, 0xFFFD },
	{ 0xFC79, 0xFFFD },
	{ 0xFC7A, 0xFFFD },
	{ 0xFC7B, 0xFFFD },
	{ 0xFC7C, 0xFFFD },
	{ 0xFC7D, 0xFFFD },
	{ 0xFC7E, 0xFFFD },
	{ 0xFC7F, 0xFFFD },
	{ 0xFC80, 0x5F8D },
	{ 0xFC81, 0x6018 },
	{ 0xFC82, 0x6057 },
	{ 0xFC83, 0x6048 },
	{ 0xFC84, 0x6038 },
	{ 0xFC85, 0x6071 },
	{ 0xFC86, 0x6312 },
	{ 0xFC87, 0x630A },
	{ 0xFC88, 0x6323 },
	{ 0xFC89, 0x662A },
	{ 0xFC8A, 0x67E0 },
	{ 0xFC8B, 0x67BE },
	{ 0xFC8C, 0x6B29 },
	{ 0xFC8D, 0x6D43 },
	{ 0xFC8E, 0x70A6 },
	{ 0xFC8F, 0x70C0 },
	{ 0xFC90, 0x722F },
	{ 0xFC91, 0x7271 },
	{ 0xFC92, 0x74EA },
	{ 0xFC93, 0x7520 },
	{ 0xFC94, 0x75A9 },
	{ 0xFC95, 0x7685 },
	{ 0xFC96, 0x7706 },
	{ 0xFC97, 0x76F6 },
	{ 0xFC98, 0x7700 },
	{ 0xFC99, 0x7702 },
	{ 0xFC9A, 0x8009 },
	{ 0xFC9B, 0x82DA },
	{ 0xFC9C, 0x830A },
	{ 0xFC9D, 0x9655 },
	{ 0xFC9E, 0x9652 },
	{ 0xFC9F, 0x4E35 },
	{ 0xFCA0, 0x5034 },
	{ 0xFCA1, 0xFFFD },
	{ 0xFCA2, 0xFFFD },
	{ 0xFCA3, 0xFFFD },
	{ 0xFCA4, 0xFFFD },
	{ 0xFCA5, 0xFFFD },
	{ 0xFCA6, 0xFFFD },
	{ 0xFCA7, 0xFFFD },
	{ 0xFCA8, 0xFFFD },
	{ 0xFCA9, 0xFFFD },
	{ 0xFCAA, 0xFFFD },
	{ 0xFCAB, 0xFFFD },
	{ 0xFCAC, 0xFFFD },
	{ 0xFCAD, 0xFFFD },
	{ 0xFCAE, 0xFFFD },
	{ 0xFCAF, 0xFFFD },
	{ 0xFCB0, 0xFFFD },
	{ 0xFCB1, 0xFFFD },
	{ 0xFCB2, 0xFFFD },
	{ 0xFCB3, 0xFFFD },
	{ 0xFCB4, 0xFFFD },
	{ 0xFCB5, 0xFFFD },
	{ 0xFCB6, 0xFFFD },
	{ 0xFCB7, 0xFFFD },
	{ 0xFCB8, 0xFFFD },
	{ 0xFCB9, 0xFFFD },
	{ 0xFCBA, 0xFFFD },
	{ 0xFCBB, 0xFFFD },
	{ 0xFCBC, 0xFFFD },
	{ 0xFCBD, 0xFFFD },
	{ 0xFCBE, 0xFFFD },
	{ 0xFCBF, 0xFFFD },
	{ 0xFCC0, 0xFFFD },
	{ 0xFCC1, 0xFFFD },
	{ 0xFCC2, 0xFFFD },
	{ 0xFCC3, 0xFFFD },
	{ 0xFCC4, 0xFFFD },
	{ 0xFCC5, 0xFFFD },
	{ 0xFCC6, 0xFFFD },
	{ 0xFCC7, 0xFFFD },
	{ 0xFCC8, 0xFFFD },
	{ 0xFCC9, 0xFFFD },
	{ 0xFCCA, 0xFFFD },
	{ 0xFCCB, 0xFFFD },
	{ 0xFCCC, 0xFFFD },
	{ 0xFCCD, 0xFFFD },
	{ 0xFCCE, 0xFFFD },
	{ 0xFCCF, 0xFFFD },
	{ 0xFCD0, 0xFFFD },
	{ 0xFCD1, 0xFFFD },
	{ 0xFCD2, 0xFFFD },
	{ 0xFCD3, 0xFFFD },
	{ 0xFCD4, 0xFFFD },
	{ 0xFCD5, 0xFFFD },
	{ 0xFCD6, 0xFFFD },
	{ 0xFCD7, 0xFFFD },
	{ 0xFCD8, 0xFFFD },
	{ 0xFCD9, 0xFFFD },
	{ 0xFCDA, 0xFFFD },
	{ 0xFCDB, 0xFFFD },
	{ 0xFCDC, 0xFFFD },
	{ 0xFCDD, 0xFFFD },
	{ 0xFCDE, 0xFFFD },
	{ 0xFCDF, 0xFFFD },
	{ 0xFCE0, 0xFFFD },
	{ 0xFCE1, 0xFFFD },
	{ 0xFCE2, 0xFFFD },
	{ 0xFCE3, 0xFFFD },
	{ 0xFCE4, 0xFFFD },
	{ 0xFCE5, 0xFFFD },
	{ 0xFCE6, 0xFFFD },
	{ 0xFCE7, 0xFFFD },
	{ 0xFCE8, 0xFFFD },
	{ 0xFCE9, 0xFFFD },
	{ 0xFCEA, 0xFFFD },
	{ 0xFCEB, 0xFFFD },
	{ 0xFCEC, 0xFFFD },
	{ 0xFCED, 0xFFFD },
	{ 0xFCEE, 0xFFFD },
	{ 0xFCEF, 0xFFFD },
	{ 0xFCF0, 0xFFFD },
	{ 0xFCF1, 0xFFFD },
	{ 0xFCF2, 0xFFFD },
	{ 0xFCF3, 0xFFFD },
	{ 0xFCF4, 0xFFFD },
	{ 0xFCF5, 0xFFFD },
	{ 0xFCF6, 0xFFFD },
	{ 0xFCF7, 0xFFFD },
	{ 0xFCF8, 0xFFFD },
	{ 0xFCF9, 0xFFFD },
	{ 0xFCFA, 0xFFFD },
	{ 0xFCFB, 0xFFFD },
	{ 0xFCFC, 0xFFFD },
	{ 0xFCFD, 0xFFFD },
	{ 0xFCFE, 0xFFFD },
	{ 0xFD40, 0xFFFD },
	{ 0xFD41, 0xFFFD },
	{ 0xFD42, 0xFFFD },
	{ 0xFD43, 0xFFFD },
	{ 0xFD44, 0xFFFD },
	{ 0xFD45, 0xFFFD },
	{ 0xFD46, 0xFFFD },
	{ 0xFD47, 0xFFFD },
	{ 0xFD48, 0xFFFD },
	{ 0xFD49, 0xFFFD },
	{ 0xFD4A, 0xFFFD },
	{ 0xFD4B, 0xFFFD },
	{ 0xFD4C, 0xFFFD },
	{ 0xFD4D, 0xFFFD },
	{ 0xFD4E, 0xFFFD },
	{ 0xFD4F, 0xFFFD },
	{ 0xFD50, 0xFFFD },
	{ 0xFD51, 0xFFFD },
	{ 0xFD52, 0xFFFD },
	{ 0xFD53, 0xFFFD },
	{ 0xFD54, 0xFFFD },
	{ 0xFD55, 0xFFFD },
	{ 0xFD56, 0xFFFD },
	{ 0xFD57, 0xFFFD },
	{ 0xFD58, 0xFFFD },
	{ 0xFD59, 0xFFFD },
	{ 0xFD5A, 0xFFFD },
	{ 0xFD5B, 0xFFFD },
	{ 0xFD5C, 0xFFFD },
	{ 0xFD5D, 0xFFFD },
	{ 0xFD5E, 0xFFFD },
	{ 0xFD5F, 0xFFFD },
	{ 0xFD60, 0xFFFD },
	{ 0xFD61, 0xFFFD },
	{ 0xFD62, 0xFFFD },
	{ 0xFD63, 0xFFFD },
	{ 0xFD64, 0xFFFD },
	{ 0xFD65, 0xFFFD },
	{ 0xFD66, 0xFFFD },
	{ 0xFD67, 0xFFFD },
	{ 0xFD68, 0xFFFD },
	{ 0xFD69, 0xFFFD },
	{ 0xFD6A, 0xFFFD },
	{ 0xFD6B, 0xFFFD },
	{ 0xFD6C, 0xFFFD },
	{ 0xFD6D, 0xFFFD },
	{ 0xFD6E, 0xFFFD },
	{ 0xFD6F, 0xFFFD },
	{ 0xFD70, 0xFFFD },
	{ 0xFD71, 0xFFFD },
	{ 0xFD72, 0xFFFD },
	{ 0xFD73, 0xFFFD },
	{ 0xFD74, 0xFFFD },
	{ 0xFD75, 0xFFFD },
	{ 0xFD76, 0xFFFD },
	{ 0xFD77, 0xFFFD },
	{ 0xFD78, 0xFFFD },
	{ 0xFD79, 0xFFFD },
	{ 0xFD7A, 0xFFFD },
	{ 0xFD7B, 0xFFFD },
	{ 0xFD7C, 0xFFFD },
	{ 0xFD7D, 0xFFFD },
	{ 0xFD7E, 0xFFFD },
	{ 0xFD7F, 0xFFFD },
	{ 0xFD80, 0x5001 },
	{ 0xFD81, 0x500A },
	{ 0xFD82, 0x5258 },
	{ 0xFD83, 0x532B },
	{ 0xFD84, 0x54EC },
	{ 0xFD85, 0x5515 },
	{ 0xFD86, 0x54FE },
	{ 0xFD87, 0x54E3 },
	{ 0xFD88, 0x5516 },
	{ 0xFD89, 0x57D3 },
	{ 0xFD8A, 0x5959 },
	{ 0xFD8B, 0x5A27 },
	{ 0xFD8C, 0x5A28 },
	{ 0xFD8D, 0x5A10 },
	{ 0xFD8E, 0x5A0E },
	{ 0xFD8F, 0x5BAF },
	{ 0xFD90, 0x5BBA },
	{ 0xFD91, 0x5BB1 },
	{ 0xFD92, 0x5CFC },
	{ 0xFD93, 0x5CF2 },
	{ 0xFD94, 0x5CFE },
	{ 0xFD95, 0x5DF8 },
	{ 0xFD96, 0x5F2C },
	{ 0xFD97, 0x6082 },
	{ 0xFD98, 0x6091 },
	{ 0xFD99, 0x608F },
	{ 0xFD9A, 0x6547 },
	{ 0xFD9B, 0x654C },
	{ 0xFD9C, 0x658A },
	{ 0xFD9D, 0x67E1 },
	{ 0xFD9E, 0x684A },
	{ 0xFD9F, 0x683F },
	{ 0xFDA0, 0x67BD },
	{ 0xFDA1, 0xFFFD },
	{ 0xFDA2, 0xFFFD },
	{ 0xFDA3, 0xFFFD },
	{ 0xFDA4, 0xFFFD },
	{ 0xFDA5, 0xFFFD },
	{ 0xFDA6, 0xFFFD },
	{ 0xFDA7, 0xFFFD },
	{ 0xFDA8, 0xFFFD },
	{ 0xFDA9, 0xFFFD },
	{ 0xFDAA, 0xFFFD },
	{ 0xFDAB, 0xFFFD },
	{ 0xFDAC, 0xFFFD },
	{ 0xFDAD, 0xFFFD },
	{ 0xFDAE, 0xFFFD },
	{ 0xFDAF, 0xFFFD },
	{ 0xFDB0, 0xFFFD },
	{ 0xFDB1, 0xFFFD },
	{ 0xFDB2, 0xFFFD },
	{ 0xFDB3, 0xFFFD },
	{ 0xFDB4, 0xFFFD },
	{ 0xFDB5, 0xFFFD },
	{ 0xFDB6, 0xFFFD },
	{ 0xFDB7, 0xFFFD },
	{ 0xFDB8, 0xFFFD },
	{ 0xFDB9, 0xFFFD },
	{ 0xFDBA, 0xFFFD },
	{ 0xFDBB, 0xFFFD },
	{ 0xFDBC, 0xFFFD },
	{ 0xFDBD, 0xFFFD },
	{ 0xFDBE, 0xFFFD },
	{ 0xFDBF, 0xFFFD },
	{ 0xFDC0, 0xFFFD },
	{ 0xFDC1, 0xFFFD },
	{ 0xFDC2, 0xFFFD },
	{ 0xFDC3, 0xFFFD },
	{ 0xFDC4, 0xFFFD },
	{ 0xFDC5, 0xFFFD },
	{ 0xFDC6, 0xFFFD },
	{ 0xFDC7, 0xFFFD },
	{ 0xFDC8, 0xFFFD },
	{ 0xFDC9, 0xFFFD },
	{ 0xFDCA, 0xFFFD },
	{ 0xFDCB, 0xFFFD },
	{ 0xFDCC, 0xFFFD },
	{ 0xFDCD, 0xFFFD },
	{ 0xFDCE, 0xFFFD },
	{ 0xFDCF, 0xFFFD },
	{ 0xFDD0, 0xFFFD },
	{ 0xFDD1, 0xFFFD },
	{ 0xFDD2, 0xFFFD },
	{ 0xFDD3, 0xFFFD },
	{ 0xFDD4, 0xFFFD },
	{ 0xFDD5, 0xFFFD },
	{ 0xFDD6, 0xFFFD },
	{ 0xFDD7, 0xFFFD },
	{ 0xFDD8, 0xFFFD },
	{ 0xFDD9, 0xFFFD },
	{ 0xFDDA, 0xFFFD },
	{ 0xFDDB, 0xFFFD },
	{ 0xFDDC, 0xFFFD },
	{ 0xFDDD, 0xFFFD },
	{ 0xFDDE, 0xFFFD },
	{ 0xFDDF, 0xFFFD },
	{ 0xFDE0, 0xFFFD },
	{ 0xFDE1, 0xFFFD },
	{ 0xFDE2, 0xFFFD },
	{ 0xFDE3, 0xFFFD },
	{ 0xFDE4, 0xFFFD },
	{ 0xFDE5, 0xFFFD },
	{ 0xFDE6, 0xFFFD },
	{ 0xFDE7, 0xFFFD },
	{ 0xFDE8, 0xFFFD },
	{ 0xFDE9, 0xFFFD },
	{ 0xFDEA, 0xFFFD },
	{ 0xFDEB, 0xFFFD },
	{ 0xFDEC, 0xFFFD },
	{ 0xFDED, 0xFFFD },
	{ 0xFDEE, 0xFFFD },
	{ 0xFDEF, 0xFFFD },
	{ 0xFDF0, 0xFFFD },
	{ 0xFDF1, 0xFFFD },
	{ 0xFDF2, 0xFFFD },
	{ 0xFDF3, 0xFFFD },
	{ 0xFDF4, 0xFFFD },
	{ 0xFDF5, 0xFFFD },
	{ 0xFDF6, 0xFFFD },
	{ 0xFDF7, 0xFFFD },
	{ 0xFDF8, 0xFFFD },
	{ 0xFDF9, 0xFFFD },
	{ 0xFDFA, 0xFFFD },
	{ 0xFDFB, 0xFFFD },
	{ 0xFDFC, 0xFFFD },
	{ 0xFDFD, 0xFFFD },
	{ 0xFDFE, 0xFFFD },
	{ 0xFE40, 0xFFFD },
	{ 0xFE41, 0xFFFD },
	{ 0xFE42, 0xFFFD },
	{ 0xFE43, 0xFFFD },
	{ 0xFE44, 0xFFFD },
	{ 0xFE45, 0xFFFD },
	{ 0xFE46, 0xFFFD },
	{ 0xFE47, 0xFFFD },
	{ 0xFE48, 0xFFFD },
	{ 0xFE49, 0xFFFD },
	{ 0xFE4A, 0xFFFD },
	{ 0xFE4B, 0xFFFD },
	{ 0xFE4C, 0xFFFD },
	{ 0xFE4D, 0xFFFD },
	{ 0xFE4E, 0xFFFD },
	{ 0xFE4F, 0xFFFD },
	{ 0xFE50, 0xFFFD },
	{ 0xFE51, 0xFFFD },
	{ 0xFE52, 0xFFFD },
	{ 0xFE53, 0xFFFD },
	{ 0xFE54, 0xFFFD },
	{ 0xFE55, 0xFFFD },
	{ 0xFE56, 0xFFFD },
	{ 0xFE57, 0xFFFD },
	{ 0xFE58, 0xFFFD },
	{ 0xFE59, 0xFFFD },
	{ 0xFE5A, 0xFFFD },
	{ 0xFE5B, 0xFFFD },
	{ 0xFE5C, 0xFFFD },
	{ 0xFE5D, 0xFFFD },
	{ 0xFE5E, 0xFFFD },
	{ 0xFE5F, 0xFFFD },
	{ 0xFE60, 0xFFFD },
	{ 0xFE61, 0xFFFD },
	{ 0xFE62, 0xFFFD },
	{ 0xFE63, 0xFFFD },
	{ 0xFE64, 0xFFFD },
	{ 0xFE65, 0xFFFD },
	{ 0xFE66, 0xFFFD },
	{ 0xFE67, 0xFFFD },
	{ 0xFE68, 0xFFFD },
	{ 0xFE69, 0xFFFD },
	{ 0xFE6A, 0xFFFD },
	{ 0xFE6B, 0xFFFD },
	{ 0xFE6C, 0xFFFD },
	{ 0xFE6D, 0xFFFD },
	{ 0xFE6E, 0xFFFD },
	{ 0xFE6F, 0xFFFD },
	{ 0xFE70, 0xFFFD },
	{ 0xFE71, 0xFFFD },
	{ 0xFE72, 0xFFFD },
	{ 0xFE73, 0xFFFD },
	{ 0xFE74, 0xFFFD },
	{ 0xFE75, 0xFFFD },
	{ 0xFE76, 0xFFFD },
	{ 0xFE77, 0xFFFD },
	{ 0xFE78, 0xFFFD },
	{ 0xFE79, 0xFFFD },
	{ 0xFE7A, 0xFFFD },
	{ 0xFE7B, 0xFFFD },
	{ 0xFE7C, 0xFFFD },
	{ 0xFE7D, 0xFFFD },
	{ 0xFE7E, 0xFFFD },
	{ 0xFE7F, 0xFFFD },
	{ 0xFE80, 0x70C9 },
	{ 0xFE81, 0x73BA },
	{ 0xFE82, 0x75C6 },
	{ 0xFE83, 0x75B7 },
	{ 0xFE84, 0x768C },
	{ 0xFE85, 0x768D },
	{ 0xFE86, 0x7717 },
	{ 0xFE87, 0x771C },
	{ 0xFE88, 0x7714 },
	{ 0xFE89, 0x7B0C },
	{ 0xFE8A, 0x7D23 },
	{ 0xFE8B, 0x7F98 },
	{ 0xFE8C, 0x7F90 },
	{ 0xFE8D, 0x803A },
	{ 0xFE8E, 0x8226 },
	{ 0xFE8F, 0x832E },
	{ 0xFE90, 0x8355 },
	{ 0xFE91, 0x831A },
	{ 0xFE92, 0x833D },
	{ 0xFE93, 0x8330 },
	{ 0xFE94, 0x8651 },
	{ 0xFE95, 0x8688 },
	{ 0xFE96, 0x898E },
	{ 0xFE97, 0x898D },
	{ 0xFE98, 0x8A09 },
	{ 0xFE99, 0x8A14 },
	{ 0xFE9A, 0x9007 },
	{ 0xFE9B, 0x9579 },
	{ 0xFE9C, 0x9584 },
	{ 0xFE9D, 0x9657 },
	{ 0xFE9E, 0x96BA },
	{ 0xFE9F, 0x5067 },
	{ 0xFEA0, 0x5318 },
	{ 0xFEA1, 0xFFFD },
	{ 0xFEA2, 0xFFFD },
	{ 0xFEA3, 0xFFFD },
	{ 0xFEA4, 0xFFFD },
	{ 0xFEA5, 0xFFFD },
	{ 0xFEA6, 0xFFFD },
	{ 0xFEA7, 0xFFFD },
	{ 0xFEA8, 0xFFFD },
	{ 0xFEA9, 0xFFFD },
	{ 0xFEAA, 0xFFFD },
	{ 0xFEAB, 0xFFFD },
	{ 0xFEAC, 0xFFFD },
	{ 0xFEAD, 0xFFFD },
	{ 0xFEAE, 0xFFFD },
	{ 0xFEAF, 0xFFFD },
	{ 0xFEB0, 0xFFFD },
	{ 0xFEB1, 0xFFFD },
	{ 0xFEB2, 0xFFFD },
	{ 0xFEB3, 0xFFFD },
	{ 0xFEB4, 0xFFFD },
	{ 0xFEB5, 0xFFFD },
	{ 0xFEB6, 0xFFFD },
	{ 0xFEB7, 0xFFFD },
	{ 0xFEB8, 0xFFFD },
	{ 0xFEB9, 0xFFFD },
	{ 0xFEBA, 0xFFFD },
	{ 0xFEBB, 0xFFFD },
	{ 0xFEBC, 0xFFFD },
	{ 0xFEBD, 0xFFFD },
	{ 0xFEBE, 0xFFFD },
	{ 0xFEBF, 0xFFFD },
	{ 0xFEC0, 0xFFFD },
	{ 0xFEC1, 0xFFFD },
	{ 0xFEC2, 0xFFFD },
	{ 0xFEC3, 0xFFFD },
	{ 0xFEC4, 0xFFFD },
	{ 0xFEC5, 0xFFFD },
	{ 0xFEC6, 0xFFFD },
	{ 0xFEC7, 0xFFFD },
	{ 0xFEC8, 0xFFFD },
	{ 0xFEC9, 0xFFFD },
	{ 0xFECA, 0xFFFD },
	{ 0xFECB, 0xFFFD },
	{ 0xFECC, 0xFFFD },
	{ 0xFECD, 0xFFFD },
	{ 0xFECE, 0xFFFD },
	{ 0xFECF, 0xFFFD },
	{ 0xFED0, 0xFFFD },
	{ 0xFED1, 0xFFFD },
	{ 0xFED2, 0xFFFD },
	{ 0xFED3, 0xFFFD },
	{ 0xFED4, 0xFFFD },
	{ 0xFED5, 0xFFFD },
	{ 0xFED6, 0xFFFD },
	{ 0xFED7, 0xFFFD },
	{ 0xFED8, 0xFFFD },
	{ 0xFED9, 0xFFFD },
	{ 0xFEDA, 0xFFFD },
	{ 0xFEDB, 0xFFFD },
	{ 0xFEDC, 0xFFFD },
	{ 0xFEDD, 0xFFFD },
	{ 0xFEDE, 0xFFFD },
	{ 0xFEDF, 0xFFFD },
	{ 0xFEE0, 0xFFFD },
	{ 0xFEE1, 0xFFFD },
	{ 0xFEE2, 0xFFFD },
	{ 0xFEE3, 0xFFFD },
	{ 0xFEE4, 0xFFFD },
	{ 0xFEE5, 0xFFFD },
	{ 0xFEE6, 0xFFFD },
	{ 0xFEE7, 0xFFFD },
	{ 0xFEE8, 0xFFFD },
	{ 0xFEE9, 0xFFFD },
	{ 0xFEEA, 0xFFFD },
	{ 0xFEEB, 0xFFFD },
	{ 0xFEEC, 0xFFFD },
	{ 0xFEED, 0xFFFD },
	{ 0xFEEE, 0xFFFD },
	{ 0xFEEF, 0xFFFD },
	{ 0xFEF0, 0xFFFD },
	{ 0xFEF1, 0xFFFD },
	{ 0xFEF2, 0xFFFD },
	{ 0xFEF3, 0xFFFD },
	{ 0xFEF4, 0xFFFD },
	{ 0xFEF5, 0xFFFD },
	{ 0xFEF6, 0xFFFD },
	{ 0xFEF7, 0xFFFD },
	{ 0xFEF8, 0xFFFD },
	{ 0xFEF9, 0xFFFD },
	{ 0xFEFA, 0xFFFD },
	{ 0xFEFB, 0xFFFD },
	{ 0xFEFC, 0xFFFD },
	{ 0xFEFD, 0xFFFD },
	{ 0xFEFE, 0xFFFD }
};
