/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 */


/* maxium mapping number from HKSCS to GB18030 */
#define MAX_HKSCS_NUM            18158   /* Maximum number of HKSCS */

#include "public_struc.h"

/* HKSCS to GB18030 mapping table */
table_t        hkscs_gbk2k_tab[MAX_HKSCS_NUM] = {
	{ 0x8840,  0x8338E338 },
	{ 0x8841,  0x8338E339 },
	{ 0x8842,  0x8338E430 },
	{ 0x8843,  0x8338E431 },
	{ 0x8844,  0x8338E432 },
	{ 0x8845,  0x8338E433 },
	{ 0x8846,  0x8338E434 },
	{ 0x8847,  0x8338E435 },
	{ 0x8848,  0x8338E436 },
	{ 0x8849,  0x8338E437 },
	{ 0x884A,  0x8338E438 },
	{ 0x884B,  0x8338E439 },
	{ 0x884C,  0x8338E530 },
	{ 0x884D,  0x8338E531 },
	{ 0x884E,  0x8338E532 },
	{ 0x884F,  0x8338E533 },
	{ 0x8850,  0x8338E534 },
	{ 0x8851,  0x8338E535 },
	{ 0x8852,  0x8338E536 },
	{ 0x8853,  0x8338E537 },
	{ 0x8854,  0x8338E538 },
	{ 0x8855,  0x8338E539 },
	{ 0x8856,  0x81308B38 },
	{ 0x8857,  0x81308639 },
	{ 0x8858,  0x81309F35 },
	{ 0x8859,  0x81308638 },
	{ 0x885A,  0x81308D35 },
	{ 0x885B,  0x81308737 },
	{ 0x885C,  0x81308E32 },
	{ 0x885D,  0x81308736 },
	{ 0x885E,  0x81309238 },
	{ 0x885F,  0x81308837 },
	{ 0x8860,  0x81309F37 },
	{ 0x8861,  0x81308836 },
	{ 0x8862,  0x8338E732 },
	{ 0x8863,  0x81368334 },
	{ 0x8864,  0x8338E734 },
	{ 0x8865,  0x81368336 },
	{ 0x8866,  0x81308738 },
	{ 0x8867,  0xA8A1 },
	{ 0x8868,  0xA8A2 },
	{ 0x8869,  0xA8A3 },
	{ 0x886A,  0xA8A4 },
	{ 0x886B,  0xA8BB },
	{ 0x886C,  0xA8A5 },
	{ 0x886D,  0xA8A6 },
	{ 0x886E,  0xA8A7 },
	{ 0x886F,  0xA8A8 },
	{ 0x8870,  0xA8A9 },
	{ 0x8871,  0xA8AA },
	{ 0x8872,  0xA8AB },
	{ 0x8873,  0xA8AC },
	{ 0x8874,  0xA8AD },
	{ 0x8875,  0xA8AE },
	{ 0x8876,  0xA8AF },
	{ 0x8877,  0xA8B0 },
	{ 0x8878,  0xA8B1 },
	{ 0x8879,  0xA8B2 },
	{ 0x887A,  0xA8B3 },
	{ 0x887B,  0xA8B4 },
	{ 0x887C,  0xA8B5 },
	{ 0x887D,  0xA8B6 },
	{ 0x887E,  0xA8B7 },
	{ 0x88A1,  0xA8B8 },
	{ 0x88A2,  0xA8B9 },
	{ 0x88A3,  0x8338EA33 },
	{ 0x88A4,  0x81368335 },
	{ 0x88A5,  0x8338EA35 },
	{ 0x88A6,  0x81368337 },
	{ 0x88A7,  0xA8BA },
	{ 0x88A8,  0xA8C0 },
	{ 0x88A9,  0x8338EA39 },
	{ 0x88AA,  0x8338EB30 },
	{ 0x8940,  0x8338F335 },
	{ 0x8941,  0x8338F336 },
	{ 0x8943,  0x9469 },
	{ 0x8946,  0xC0F6 },
	{ 0x8947,  0x9CF6 },
	{ 0x8948,  0xF94B },
	{ 0x8949,  0xE19A },
	{ 0x894C,  0x8338F437 },
	{ 0x894D,  0xB3C5 },
	{ 0x894E,  0xBBE1 },
	{ 0x894F,  0x81BE },
	{ 0x8950,  0xC7C8 },
	{ 0x8951,  0xD9F0 },
	{ 0x8952,  0xD0CB },
	{ 0x8953,  0xC5A9 },
	{ 0x8954,  0xB7EF },
	{ 0x8955,  0xCEF1 },
	{ 0x8956,  0xB6AF },
	{ 0x8957,  0xD2BD },
	{ 0x8958,  0xBBAA },
	{ 0x8959,  0xB7A2 },
	{ 0x895A,  0xB1E4 },
	{ 0x895B,  0xCDC5 },
	{ 0x895C,  0xC9F9 },
	{ 0x895D,  0xB4A6 },
	{ 0x895E,  0xB1B8 },
	{ 0x895F,  0x89FA },
	{ 0x8960,  0xCDB7 },
	{ 0x8961,  0xD1A7 },
	{ 0x8962,  0xCAB5 },
	{ 0x8963,  0x8C67 },
	{ 0x8964,  0xE1B0 },
	{ 0x8965,  0xC7EC },
	{ 0x8966,  0xD7DC },
	{ 0x8967,  0x94C5 },
	{ 0x8968,  0x96CD },
	{ 0x8969,  0x96D1 },
	{ 0x896A,  0xC7C5 },
	{ 0x896B,  0xBCC3 },
	{ 0x896C,  0xC1B6 },
	{ 0x896D,  0xB5E7 },
	{ 0x896E,  0xCFCB },
	{ 0x896F,  0xCEB3 },
	{ 0x8970,  0xB7C4 },
	{ 0x8971,  0xD6AF },
	{ 0x8972,  0xBEAD },
	{ 0x8973,  0xCDB3 },
	{ 0x8974,  0xC0C2 },
	{ 0x8975,  0xC08B },
	{ 0x8976,  0xD2D5 },
	{ 0x8977,  0xCBD5 },
	{ 0x8978,  0xD2A9 },
	{ 0x8979,  0xCAD3 },
	{ 0x897A,  0xC9E8 },
	{ 0x897B,  0xD1AF },
	{ 0x897C,  0xB3B5 },
	{ 0x897D,  0xD4FE },
	{ 0x897E,  0xC2D6 },
	{ 0x89A1,  0xAC52 },
	{ 0x89A2,  0xBC6B },
	{ 0x89A3,  0xBE72 },
	{ 0x89A4,  0x97EA },
	{ 0x89A5,  0xB85F },
	{ 0x89A6,  0x8467 },
	{ 0x89AB,  0xF5AB },
	{ 0x89AC,  0xB45E },
	{ 0x89AD,  0xCCAA },
	{ 0x89AE,  0xEBC2 },
	{ 0x89B0,  0xD99E },
	{ 0x89B1,  0xBDBA },
	{ 0x89B2,  0x8338FB35 },
	{ 0x89B5,  0xEBBF },
	{ 0x89B6,  0xFC56 },
	{ 0x89B7,  0x8234EF34 },
	{ 0x89B8,  0xFA66 },
	{ 0x89B9,  0xFB49 },
	{ 0x89BA,  0x8234E137 },
	{ 0x89BB,  0x8338FC34 },
	{ 0x89BC,  0x8338FC35 },
	{ 0x89BD,  0xFB47 },
	{ 0x89BE,  0x8338FC37 },
	{ 0x89BF,  0x82309D35 },
	{ 0x89C1,  0x9CCD },
	{ 0x89C2,  0xF4B8 },
	{ 0x89C3,  0xDFB0 },
	{ 0x89C5,  0x82349135 },
	{ 0x89C6,  0xC2ED },
	{ 0x89C7,  0xBFA5 },
	{ 0x89C8,  0xC1FA },
	{ 0x89C9,  0xB597 },
	{ 0x89CA,  0x8338FD39 },
	{ 0x89CB,  0x8338FE30 },
	{ 0x89CC,  0x8338FE31 },
	{ 0x89CD,  0x8338FE32 },
	{ 0x89CE,  0xC1BD },
	{ 0x89CF,  0x8178 },
	{ 0x89D0,  0x8177 },
	{ 0x89D1,  0x817D },
	{ 0x89D2,  0xD2DA },
	{ 0x89D3,  0xD8EF },
	{ 0x89D4,  0x81C6 },
	{ 0x89D5,  0x8139F634 },
	{ 0x89D6,  0x824F },
	{ 0x89D7,  0x8231F837 },
	{ 0x89D8,  0x8277 },
	{ 0x89D9,  0xC0FC },
	{ 0x89DA,  0x8139FB32 },
	{ 0x89DB,  0x8139FD34 },
	{ 0x89DC,  0x82308132 },
	{ 0x89DD,  0x83D2 },
	{ 0x89DE,  0x89E1 },
	{ 0x89DF,  0xC1DD },
	{ 0x89E0,  0xDBCA },
	{ 0x89E1,  0x8456 },
	{ 0x89E2,  0xD5F9 },
	{ 0x89E3,  0x8497 },
	{ 0x89E4,  0xD8E5 },
	{ 0x89E5,  0x854C },
	{ 0x89E6,  0x82309E31 },
	{ 0x89E7,  0xBEC7 },
	{ 0x89E8,  0x82309234 },
	{ 0x89E9,  0x8594 },
	{ 0x89EA,  0x82309236 },
	{ 0x89EB,  0xB2CE },
	{ 0x89EC,  0xDFC4 },
	{ 0x89ED,  0x82309532 },
	{ 0x89EE,  0x82309537 },
	{ 0x89EF,  0x8230B035 },
	{ 0x89F0,  0x85F7 },
	{ 0x89F1,  0xDFDB },
	{ 0x89F2,  0xDFD4 },
	{ 0x89F3,  0x8648 },
	{ 0x89F4,  0xDFD1 },
	{ 0x89F5,  0x865A },
	{ 0x89F6,  0x8675 },
	{ 0x89F7,  0xDFF0 },
	{ 0x89F8,  0x8680 },
	{ 0x89F9,  0x82309935 },
	{ 0x89FA,  0xDFFC },
	{ 0x89FB,  0x82309A37 },
	{ 0x89FC,  0x82309D33 },
	{ 0x89FD,  0x86E5 },
	{ 0x89FE,  0x82309D39 },
	{ 0x8A40,  0x83398532 },
	{ 0x8A41,  0x867D },
	{ 0x8A43,  0x83398535 },
	{ 0x8A44,  0x83398536 },
	{ 0x8A45,  0x83398537 },
	{ 0x8A46,  0x86B8 },
	{ 0x8A47,  0x83398539 },
	{ 0x8A48,  0x82318935 },
	{ 0x8A49,  0x83398631 },
	{ 0x8A4A,  0xDB83 },
	{ 0x8A4B,  0x83398633 },
	{ 0x8A4C,  0x83398634 },
	{ 0x8A4D,  0x8232AF30 },
	{ 0x8A4E,  0x83398636 },
	{ 0x8A4F,  0xB254 },
	{ 0x8A50,  0x83398638 },
	{ 0x8A51,  0x82319037 },
	{ 0x8A52,  0x8233EF39 },
	{ 0x8A53,  0x83398731 },
	{ 0x8A54,  0x83398732 },
	{ 0x8A55,  0x83398733 },
	{ 0x8A56,  0x9442 },
	{ 0x8A57,  0x83398735 },
	{ 0x8A58,  0x83398736 },
	{ 0x8A59,  0x83398737 },
	{ 0x8A5A,  0x83398738 },
	{ 0x8A5B,  0x93CB },
	{ 0x8A5C,  0xDC48 },
	{ 0x8A5D,  0x83398831 },
	{ 0x8A5E,  0x83398832 },
	{ 0x8A5F,  0x83398833 },
	{ 0x8A60,  0x83398834 },
	{ 0x8A61,  0x83398835 },
	{ 0x8A62,  0x83398836 },
	{ 0x8A64,  0x83398838 },
	{ 0x8A65,  0x83398839 },
	{ 0x8A66,  0x83398930 },
	{ 0x8A67,  0x8233F330 },
	{ 0x8A68,  0x83398932 },
	{ 0x8A69,  0x83398933 },
	{ 0x8A6A,  0xF362 },
	{ 0x8A6B,  0x82319538 },
	{ 0x8A6C,  0x83398936 },
	{ 0x8A6D,  0x8232A438 },
	{ 0x8A6E,  0x82308A39 },
	{ 0x8A6F,  0x83398939 },
	{ 0x8A70,  0x83398A30 },
	{ 0x8A71,  0x83398A31 },
	{ 0x8A72,  0x83398A32 },
	{ 0x8A73,  0xF96B },
	{ 0x8A74,  0xEE46 },
	{ 0x8A76,  0x82338A37 },
	{ 0x8A77,  0x83398A37 },
	{ 0x8A78,  0x93E6 },
	{ 0x8A79,  0x8656 },
	{ 0x8A7A,  0x83398B30 },
	{ 0x8A7B,  0x83398B31 },
	{ 0x8A7C,  0x83398B32 },
	{ 0x8A7D,  0x82318B30 },
	{ 0x8A7E,  0x83398B34 },
	{ 0x8AA1,  0x83398B35 },
	{ 0x8AA2,  0x83398B36 },
	{ 0x8AA3,  0x83398B37 },
	{ 0x8AA4,  0x944B },
	{ 0x8AA5,  0x83398B39 },
	{ 0x8AA6,  0x83398C30 },
	{ 0x8AA7,  0xDB9C },
	{ 0x8AA8,  0x83398C32 },
	{ 0x8AA9,  0x83398C33 },
	{ 0x8AAA,  0x83398C34 },
	{ 0x8AAC,  0x8233F533 },
	{ 0x8AAD,  0x83398C37 },
	{ 0x8AAE,  0x8232A631 },
	{ 0x8AAF,  0x896B },
	{ 0x8AB0,  0x83398D30 },
	{ 0x8AB2,  0x83398D32 },
	{ 0x8AB3,  0x83398D33 },
	{ 0x8AB4,  0x83398D34 },
	{ 0x8AB5,  0x83398D35 },
	{ 0x8AB6,  0x83398D36 },
	{ 0x8AB7,  0x86AF },
	{ 0x8AB8,  0x8232B933 },
	{ 0x8AB9,  0x82338736 },
	{ 0x8ABB,  0x8234BA33 },
	{ 0x8ABC,  0x83398E32 },
	{ 0x8ABD,  0x83398E33 },
	{ 0x8ABE,  0xEBFA },
	{ 0x8ABF,  0xEF8E },
	{ 0x8AC0,  0x83398E36 },
	{ 0x8AC1,  0x92D9 },
	{ 0x8AC2,  0x82318B33 },
	{ 0x8AC3,  0x83398E39 },
	{ 0x8AC4,  0xDA94 },
	{ 0x8AC5,  0x87AF },
	{ 0x8AC6,  0x93BE },
	{ 0x8AC7,  0x8231F832 },
	{ 0x8AC9,  0x83398F35 },
	{ 0x8ACA,  0x83398F36 },
	{ 0x8ACB,  0x83398F37 },
	{ 0x8ACC,  0x83398F38 },
	{ 0x8ACE,  0x83399030 },
	{ 0x8ACF,  0x83399031 },
	{ 0x8AD0,  0x8230FE38 },
	{ 0x8AD1,  0x82318C31 },
	{ 0x8AD2,  0x83399034 },
	{ 0x8AD3,  0x82309633 },
	{ 0x8AD4,  0x83399036 },
	{ 0x8AD5,  0x83399037 },
	{ 0x8AD6,  0x8774 },
	{ 0x8AD7,  0x83399039 },
	{ 0x8AD8,  0x83399130 },
	{ 0x8AD9,  0x83399131 },
	{ 0x8ADA,  0x82308335 },
	{ 0x8ADB,  0xD9DB },
	{ 0x8ADC,  0x83399134 },
	{ 0x8ADF,  0x83399137 },
	{ 0x8AE0,  0x83399138 },
	{ 0x8AE1,  0x83399139 },
	{ 0x8AE2,  0x83399230 },
	{ 0x8AE3,  0x83399231 },
	{ 0x8AE4,  0x83399232 },
	{ 0x8AE5,  0x83399233 },
	{ 0x8AE6,  0x83399234 },
	{ 0x8AE7,  0xC16A },
	{ 0x8AE8,  0x83399236 },
	{ 0x8AE9,  0x83399237 },
	{ 0x8AEA,  0x83399238 },
	{ 0x8AEB,  0x8230A333 },
	{ 0x8AEC,  0x83399330 },
	{ 0x8AED,  0x83399331 },
	{ 0x8AEE,  0x83399332 },
	{ 0x8AEF,  0x83399333 },
	{ 0x8AF0,  0x82329B38 },
	{ 0x8AF1,  0x83399335 },
	{ 0x8AF2,  0x83399336 },
	{ 0x8AF3,  0x83399337 },
	{ 0x8AF4,  0x83399338 },
	{ 0x8AF6,  0x83399430 },
	{ 0x8AF7,  0x83399431 },
	{ 0x8AF8,  0x83399432 },
	{ 0x8AF9,  0x83399433 },
	{ 0x8AFA,  0x83399434 },
	{ 0x8AFB,  0x8232A630 },
	{ 0x8AFC,  0x83399436 },
	{ 0x8AFD,  0x9389 },
	{ 0x8AFE,  0x83399438 },
	{ 0x8B40,  0x83399439 },
	{ 0x8B41,  0x83399530 },
	{ 0x8B42,  0x83399531 },
	{ 0x8B43,  0x83399532 },
	{ 0x8B44,  0x83399533 },
	{ 0x8B45,  0x83399534 },
	{ 0x8B46,  0x83399535 },
	{ 0x8B47,  0x82318D39 },
	{ 0x8B48,  0x83399537 },
	{ 0x8B49,  0x83399538 },
	{ 0x8B4A,  0x83399539 },
	{ 0x8B4B,  0x83399630 },
	{ 0x8B4C,  0x83399631 },
	{ 0x8B4D,  0x83399632 },
	{ 0x8B4E,  0x83399633 },
	{ 0x8B4F,  0x83399634 },
	{ 0x8B50,  0xE97E },
	{ 0x8B51,  0xDFDF },
	{ 0x8B52,  0xDCD0 },
	{ 0x8B53,  0xE0AD },
	{ 0x8B55,  0x83399730 },
	{ 0x8B56,  0xF68B },
	{ 0x8B57,  0xF7BE },
	{ 0x8B58,  0x83399733 },
	{ 0x8B59,  0x83399734 },
	{ 0x8B5A,  0x9F8A },
	{ 0x8B5B,  0xEBF1 },
	{ 0x8B5C,  0xE6C0 },
	{ 0x8B5D,  0xE6D9 },
	{ 0x8B5E,  0x83399739 },
	{ 0x8B5F,  0xC398 },
	{ 0x8B60,  0x8230CC33 },
	{ 0x8B61,  0xDFB2 },
	{ 0x8B62,  0x83399833 },
	{ 0x8B63,  0xE17A },
	{ 0x8B64,  0x83399835 },
	{ 0x8B65,  0x83399836 },
	{ 0x8B66,  0x83399837 },
	{ 0x8B67,  0x83399838 },
	{ 0x8B68,  0x8230A033 },
	{ 0x8B69,  0x83399930 },
	{ 0x8B6A,  0x8230A437 },
	{ 0x8B6B,  0x83399932 },
	{ 0x8B6C,  0xE0EB },
	{ 0x8B6D,  0x83399934 },
	{ 0x8B6E,  0x83399935 },
	{ 0x8B6F,  0x83399936 },
	{ 0x8B70,  0x83399937 },
	{ 0x8B71,  0x83399938 },
	{ 0x8B72,  0x83399939 },
	{ 0x8B73,  0x83399A30 },
	{ 0x8B74,  0x83399A31 },
	{ 0x8B75,  0x83399A32 },
	{ 0x8B76,  0x83399A33 },
	{ 0x8B77,  0x83399A34 },
	{ 0x8B78,  0x8AF4 },
	{ 0x8B79,  0x83399A36 },
	{ 0x8B7A,  0x83399A37 },
	{ 0x8B7B,  0x83399A38 },
	{ 0x8B7C,  0x83399A39 },
	{ 0x8B7D,  0x8891 },
	{ 0x8B7E,  0x83399B31 },
	{ 0x8BA1,  0x83399B32 },
	{ 0x8BA2,  0x83399B33 },
	{ 0x8BA3,  0x83399B34 },
	{ 0x8BA4,  0x83399B35 },
	{ 0x8BA5,  0x83399B36 },
	{ 0x8BA6,  0x8230BD35 },
	{ 0x8BA7,  0x83399B38 },
	{ 0x8BA8,  0x83399B39 },
	{ 0x8BA9,  0x83399C30 },
	{ 0x8BAA,  0x83399C31 },
	{ 0x8BAB,  0x83399C32 },
	{ 0x8BAC,  0x83399C33 },
	{ 0x8BAD,  0x83399C34 },
	{ 0x8BAE,  0x83399C35 },
	{ 0x8BAF,  0xC7BD },
	{ 0x8BB0,  0x848A },
	{ 0x8BB1,  0xFE5B },
	{ 0x8BB2,  0x83399C39 },
	{ 0x8BB3,  0xB991 },
	{ 0x8BB4,  0x8C4E },
	{ 0x8BB5,  0x8233F432 },
	{ 0x8BB6,  0x8234C633 },
	{ 0x8BB7,  0xFC98 },
	{ 0x8BB8,  0x8234A538 },
	{ 0x8BB9,  0xF684 },
	{ 0x8BBA,  0xF551 },
	{ 0x8BBB,  0x83399D38 },
	{ 0x8BBC,  0x83399D39 },
	{ 0x8BBD,  0x86F8 },
	{ 0x8BBE,  0x8230A234 },
	{ 0x8BBF,  0x879A },
	{ 0x8BC0,  0xD8AD },
	{ 0x8BC1,  0xE2BA },
	{ 0x8BC2,  0x83399E35 },
	{ 0x8BC3,  0x83399E36 },
	{ 0x8BC4,  0xEC69 },
	{ 0x8BC5,  0x83399E38 },
	{ 0x8BC6,  0x815E },
	{ 0x8BC7,  0xD8E9 },
	{ 0x8BC8,  0x82309035 },
	{ 0x8BC9,  0x8CB2 },
	{ 0x8BCA,  0x8F9F },
	{ 0x8BCB,  0xE2E0 },
	{ 0x8BCC,  0x8230EF38 },
	{ 0x8BCD,  0xDED0 },
	{ 0x8BCE,  0xEBB6 },
	{ 0x8BCF,  0x9A78 },
	{ 0x8BD0,  0xE3DF },
	{ 0x8BD1,  0x9AEC },
	{ 0x8BD2,  0xECE1 },
	{ 0x8BD3,  0xA08D },
	{ 0x8BD4,  0xE3DC },
	{ 0x8BD5,  0xE1EB },
	{ 0x8BD6,  0x8339A035 },
	{ 0x8BD7,  0xC09F },
	{ 0x8BD8,  0xECEA },
	{ 0x8BD9,  0xBC69 },
	{ 0x8BDA,  0xC0A0 },
	{ 0x8BDB,  0x8339A130 },
	{ 0x8BDC,  0x82308430 },
	{ 0x8BDE,  0x8339A133 },
	{ 0x8BDF,  0xC253 },
	{ 0x8BE0,  0xEDB1 },
	{ 0x8BE1,  0x8339A136 },
	{ 0x8BE2,  0x8339A137 },
	{ 0x8BE3,  0x856A },
	{ 0x8BE4,  0xF1C2 },
	{ 0x8BE5,  0xBCFB },
	{ 0x8BE6,  0x8339A231 },
	{ 0x8BE7,  0xDAA5 },
	{ 0x8BE8,  0xB1B4 },
	{ 0x8BE9,  0xEEC4 },
	{ 0x8BEA,  0xE94D },
	{ 0x8BEB,  0xB3A4 },
	{ 0x8BEC,  0xC3C5 },
	{ 0x8BED,  0x8339A238 },
	{ 0x8BEE,  0xCEA4 },
	{ 0x8BEF,  0xD2B3 },
	{ 0x8BF0,  0xB7E7 },
	{ 0x8BF1,  0xB7C9 },
	{ 0x8BF2,  0xE2BB },
	{ 0x8BF3,  0x8339A334 },
	{ 0x8BF4,  0xD3E3 },
	{ 0x8BF5,  0xC4F1 },
	{ 0x8BF6,  0xBBC6 },
	{ 0x8BF7,  0x9A6E },
	{ 0x8BF8,  0x81398937 },
	{ 0x8BF9,  0x8152 },
	{ 0x8BFA,  0x8339A431 },
	{ 0x8BFB,  0xDAE2 },
	{ 0x8BFC,  0xBBA7 },
	{ 0x8BFD,  0xB8D6 },
	{ 0x8D60,  0xE1CA },
	{ 0x8D61,  0x8DB4 },
	{ 0x8D62,  0x8DBF },
	{ 0x8D63,  0x8231F131 },
	{ 0x8D64,  0x8230D833 },
	{ 0x8D65,  0x8E43 },
	{ 0x8D66,  0x8E57 },
	{ 0x8D67,  0x8230DA30 },
	{ 0x8D68,  0x8230DC34 },
	{ 0x8D69,  0xC3DD },
	{ 0x8D6A,  0x8EF7 },
	{ 0x8D6B,  0xC3D6 },
	{ 0x8D6C,  0x8FB8 },
	{ 0x8D6D,  0x8230F132 },
	{ 0x8D6E,  0x8230F234 },
	{ 0x8D6F,  0x8230F636 },
	{ 0x8D70,  0x8230F830 },
	{ 0x8D71,  0x90B6 },
	{ 0x8D72,  0x90F6 },
	{ 0x8D73,  0xE1BF },
	{ 0x8D74,  0x8230FD39 },
	{ 0x8D75,  0xE3C0 },
	{ 0x8D76,  0x919D },
	{ 0x8D77,  0x91AE },
	{ 0x8D78,  0x82318436 },
	{ 0x8D79,  0xEAAF },
	{ 0x8D7A,  0x9266 },
	{ 0x8D7B,  0xD3B5 },
	{ 0x8D7C,  0x92A3 },
	{ 0x8D7D,  0x82318A37 },
	{ 0x8D7E,  0x87BD },
	{ 0x8DA1,  0x82318B38 },
	{ 0x8DA2,  0x9355 },
	{ 0x8DA3,  0x9366 },
	{ 0x8DA4,  0x936C },
	{ 0x8DA5,  0x93A3 },
	{ 0x8DA6,  0x82319330 },
	{ 0x8DA7,  0xDFA6 },
	{ 0x8DA8,  0x8D8E },
	{ 0x8DA9,  0x8752 },
	{ 0x8DAA,  0xB9EA },
	{ 0x8DAB,  0x82319A35 },
	{ 0x8DAC,  0x94C3 },
	{ 0x8DAD,  0x82319E33 },
	{ 0x8DAE,  0x954A },
	{ 0x8DAF,  0xCFFE },
	{ 0x8DB0,  0x8231A336 },
	{ 0x8DB1,  0x95A6 },
	{ 0x8DB2,  0x8231A834 },
	{ 0x8DB3,  0x964A },
	{ 0x8DB4,  0x8231AB36 },
	{ 0x8DB5,  0x969A },
	{ 0x8DB6,  0xE8D9 },
	{ 0x8DB7,  0x8231AD37 },
	{ 0x8DB8,  0xE8F0 },
	{ 0x8DB9,  0x9758 },
	{ 0x8DBA,  0x8231B033 },
	{ 0x8DBB,  0x8231B032 },
	{ 0x8DBC,  0x8231B132 },
	{ 0x8DBD,  0x97BC },
	{ 0x8DBE,  0x97E7 },
	{ 0x8DBF,  0xA0AB },
	{ 0x8DC0,  0x9842 },
	{ 0x8DC1,  0x9868 },
	{ 0x8DC2,  0x9858 },
	{ 0x8DC3,  0x8231B737 },
	{ 0x8DC4,  0x9892 },
	{ 0x8DC5,  0x8231BB30 },
	{ 0x8DC6,  0xE9CD },
	{ 0x8DC7,  0x9955 },
	{ 0x8DC8,  0xB3F7 },
	{ 0x8DC9,  0x9960 },
	{ 0x8DCA,  0x8231BC35 },
	{ 0x8DCB,  0x9972 },
	{ 0x8DCC,  0x8231BD31 },
	{ 0x8DCD,  0xE9DF },
	{ 0x8DCE,  0x998B },
	{ 0x8DCF,  0x99AA },
	{ 0x8DD0,  0x99CC },
	{ 0x8DD1,  0xE9E2 },
	{ 0x8DD2,  0xBBD9 },
	{ 0x8DD3,  0xEBA4 },
	{ 0x8DD4,  0x9B4E },
	{ 0x8DD5,  0xBBA6 },
	{ 0x8DD6,  0x8231D237 },
	{ 0x8DD7,  0x9B90 },
	{ 0x8DD8,  0x9B93 },
	{ 0x8DD9,  0x9BA8 },
	{ 0x8DDA,  0x9BD8 },
	{ 0x8DDB,  0x8231D632 },
	{ 0x8DDC,  0xB5D3 },
	{ 0x8DDD,  0x9BEE },
	{ 0x8DDE,  0x9C6D },
	{ 0x8DDF,  0x9C6E },
	{ 0x8DE0,  0xCEC2 },
	{ 0x8DE1,  0xE4D3 },
	{ 0x8DE2,  0x8339C131 },
	{ 0x8DE3,  0xE4E2 },
	{ 0x8DE4,  0xE4DE },
	{ 0x8DE5,  0xB9F6 },
	{ 0x8DE6,  0xB3DD },
	{ 0x8DE7,  0xB1F5 },
	{ 0x8DE8,  0xCCB2 },
	{ 0x8DE9,  0xE4ED },
	{ 0x8DEA,  0x9D72 },
	{ 0x8DEB,  0x8231DE39 },
	{ 0x8DEC,  0x8339C231 },
	{ 0x8DED,  0x9DAE },
	{ 0x8DEE,  0x9DDF },
	{ 0x8DEF,  0x8231E235 },
	{ 0x8DF0,  0x8231E336 },
	{ 0x8DF1,  0x9FE5 },
	{ 0x8DF2,  0xE1AE },
	{ 0x8DF3,  0x8231E537 },
	{ 0x8DF4,  0x9E81 },
	{ 0x8DF5,  0x8231E634 },
	{ 0x8DF6,  0x9EA1 },
	{ 0x8DF7,  0x9EA5 },
	{ 0x8DF8,  0xB5C6 },
	{ 0x8DF9,  0xB2D3 },
	{ 0x8DFA,  0xC2AF },
	{ 0x8DFB,  0x8339C336 },
	{ 0x8DFC,  0x82338833 },
	{ 0x8DFD,  0x8230A233 },
	{ 0x8DFE,  0x8339C339 },
	{ 0x8E40,  0xFAC2 },
	{ 0x8E41,  0x88A5 },
	{ 0x8E42,  0xFAC4 },
	{ 0x8E43,  0x9F88 },
	{ 0x8E44,  0xFAC6 },
	{ 0x8E45,  0x8230AB34 },
	{ 0x8E46,  0x986B },
	{ 0x8E47,  0xFAC9 },
	{ 0x8E48,  0x8C54 },
	{ 0x8E49,  0xB761 },
	{ 0x8E4A,  0xFACC },
	{ 0x8E4B,  0xFACD },
	{ 0x8E4C,  0xB77B },
	{ 0x8E4D,  0xB78D },
	{ 0x8E4E,  0xFAD0 },
	{ 0x8E4F,  0xB852 },
	{ 0x8E50,  0xB848 },
	{ 0x8E51,  0xB858 },
	{ 0x8E52,  0xB859 },
	{ 0x8E53,  0x9FFC },
	{ 0x8E54,  0xFAD6 },
	{ 0x8E55,  0x8232D433 },
	{ 0x8E56,  0xB86D },
	{ 0x8E57,  0xB870 },
	{ 0x8E58,  0xB877 },
	{ 0x8E59,  0x8232D830 },
	{ 0x8E5A,  0x8644 },
	{ 0x8E5B,  0xFADD },
	{ 0x8E5C,  0xCBF1 },
	{ 0x8E5D,  0xB956 },
	{ 0x8E5E,  0xB89F },
	{ 0x8E5F,  0xFAE1 },
	{ 0x8E60,  0xFAE2 },
	{ 0x8E61,  0xF3EE },
	{ 0x8E62,  0xB968 },
	{ 0x8E63,  0xDDAF },
	{ 0x8E64,  0xFAE6 },
	{ 0x8E65,  0xFAE7 },
	{ 0x8E66,  0xBA48 },
	{ 0x8E67,  0xC860 },
	{ 0x8E68,  0xB981 },
	{ 0x8E6A,  0xFAEC },
	{ 0x8E6B,  0x8231E932 },
	{ 0x8E6C,  0xFAEE },
	{ 0x8E6D,  0xC94E },
	{ 0x8E6E,  0xBA66 },
	{ 0x8E70,  0xBA97 },
	{ 0x8E71,  0xFAF3 },
	{ 0x8E72,  0xBB41 },
	{ 0x8E73,  0xBB7A },
	{ 0x8E74,  0xFAF6 },
	{ 0x8E75,  0xBB91 },
	{ 0x8E76,  0x9597 },
	{ 0x8E77,  0xFAF9 },
	{ 0x8E78,  0xBC46 },
	{ 0x8E79,  0xF4D7 },
	{ 0x8E7A,  0xBC59 },
	{ 0x8E7B,  0xD9E1 },
	{ 0x8E7C,  0xBC64 },
	{ 0x8E7D,  0xBC66 },
	{ 0x8EA1,  0xC049 },
	{ 0x8EA2,  0x8233AA39 },
	{ 0x8EA3,  0xFBA5 },
	{ 0x8EA4,  0xBD66 },
	{ 0x8EA5,  0xFBA7 },
	{ 0x8EA6,  0xAD4C },
	{ 0x8EA7,  0xBD91 },
	{ 0x8EA8,  0xBE51 },
	{ 0x8EA9,  0x9F80 },
	{ 0x8EAA,  0xBE58 },
	{ 0x8EAC,  0xFBAE },
	{ 0x8EAD,  0xFBAF },
	{ 0x8EAE,  0xBE8A },
	{ 0x8EAF,  0x8231D938 },
	{ 0x8EB0,  0xBE9B },
	{ 0x8EB1,  0xFBB3 },
	{ 0x8EB2,  0xBE8B },
	{ 0x8EB3,  0xFBB5 },
	{ 0x8EB5,  0xFBB7 },
	{ 0x8EB6,  0xFBB8 },
	{ 0x8EB7,  0xC050 },
	{ 0x8EB8,  0xC073 },
	{ 0x8EB9,  0x8232F736 },
	{ 0x8EBA,  0xE87B },
	{ 0x8EBB,  0xBF6C },
	{ 0x8EBC,  0xC092 },
	{ 0x8EBD,  0xC093 },
	{ 0x8EBE,  0xC096 },
	{ 0x8EBF,  0xB565 },
	{ 0x8EC0,  0xFBC2 },
	{ 0x8EC1,  0xF188 },
	{ 0x8EC2,  0xC16D },
	{ 0x8EC3,  0xFBC5 },
	{ 0x8EC4,  0xC174 },
	{ 0x8EC5,  0xFBC7 },
	{ 0x8EC6,  0xFBC8 },
	{ 0x8EC7,  0x8233B132 },
	{ 0x8EC8,  0xFBCA },
	{ 0x8EC9,  0x8233A833 },
	{ 0x8ECA,  0xFBCC },
	{ 0x8ECB,  0xC24F },
	{ 0x8ECC,  0xFBCE },
	{ 0x8ECE,  0xC255 },
	{ 0x8ECF,  0xC25E },
	{ 0x8ED1,  0xC268 },
	{ 0x8ED2,  0xFBD4 },
	{ 0x8ED3,  0xFBD5 },
	{ 0x8ED4,  0xB3DC },
	{ 0x8ED5,  0xC26E },
	{ 0x8ED6,  0xC287 },
	{ 0x8ED7,  0xFBD9 },
	{ 0x8ED8,  0x82349C38 },
	{ 0x8ED9,  0xFBDB },
	{ 0x8EDA,  0xFBDC },
	{ 0x8EDB,  0xFBDD },
	{ 0x8EDC,  0x9655 },
	{ 0x8EDD,  0xC353 },
	{ 0x8EDE,  0xFBE0 },
	{ 0x8EDF,  0xC37C },
	{ 0x8EE0,  0xBDC5 },
	{ 0x8EE1,  0x899B },
	{ 0x8EE2,  0xFBE4 },
	{ 0x8EE3,  0x9B54 },
	{ 0x8EE4,  0xFBE6 },
	{ 0x8EE5,  0xFBE7 },
	{ 0x8EE6,  0x9448 },
	{ 0x8EE7,  0xFBE9 },
	{ 0x8EE8,  0xC56F },
	{ 0x8EE9,  0xFBEB },
	{ 0x8EEA,  0x98F9 },
	{ 0x8EEB,  0xFBED },
	{ 0x8EEC,  0xFBEE },
	{ 0x8EED,  0x82339A37 },
	{ 0x8EEE,  0xC578 },
	{ 0x8EEF,  0xFBF1 },
	{ 0x8EF0,  0xFBF2 },
	{ 0x8EF1,  0xFBF3 },
	{ 0x8EF2,  0x826F },
	{ 0x8EF3,  0xFBF5 },
	{ 0x8EF4,  0xC987 },
	{ 0x8EF5,  0xC753 },
	{ 0x8EF6,  0xFBF8 },
	{ 0x8EF7,  0xFBF9 },
	{ 0x8EF8,  0xFBFA },
	{ 0x8EF9,  0xFBFB },
	{ 0x8EFA,  0xFBFC },
	{ 0x8EFB,  0xDCCE },
	{ 0x8EFC,  0x97C9 },
	{ 0x8EFD,  0xFCA1 },
	{ 0x8EFE,  0x8232D630 },
	{ 0x8F40,  0xCA74 },
	{ 0x8F41,  0xC66C },
	{ 0x8F42,  0xDCE1 },
	{ 0x8F43,  0xFCA6 },
	{ 0x8F44,  0xFCA7 },
	{ 0x8F45,  0x8230B639 },
	{ 0x8F46,  0xFCA9 },
	{ 0x8F47,  0xFCAA },
	{ 0x8F48,  0xC649 },
	{ 0x8F49,  0xC671 },
	{ 0x8F4A,  0xC68D },
	{ 0x8F4B,  0xFCAE },
	{ 0x8F4C,  0xFCAF },
	{ 0x8F4D,  0xFCB0 },
	{ 0x8F4E,  0xFCB1 },
	{ 0x8F4F,  0xFCB2 },
	{ 0x8F50,  0x8231EB30 },
	{ 0x8F51,  0xC68F },
	{ 0x8F52,  0xE0C0 },
	{ 0x8F53,  0xDDB0 },
	{ 0x8F54,  0x8233A931 },
	{ 0x8F55,  0xFCB8 },
	{ 0x8F56,  0xC77C },
	{ 0x8F58,  0xC791 },
	{ 0x8F59,  0x8139FB33 },
	{ 0x8F5A,  0xFCBD },
	{ 0x8F5B,  0x98FD },
	{ 0x8F5C,  0xCA82 },
	{ 0x8F5D,  0x8139FD37 },
	{ 0x8F5E,  0xFCC1 },
	{ 0x8F5F,  0xFCC2 },
	{ 0x8F60,  0xC88C },
	{ 0x8F61,  0xFCC4 },
	{ 0x8F62,  0xB4D0 },
	{ 0x8F63,  0x8231ED30 },
	{ 0x8F64,  0x8233A532 },
	{ 0x8F65,  0x9980 },
	{ 0x8F66,  0xC880 },
	{ 0x8F67,  0xFCCA },
	{ 0x8F68,  0xB57B },
	{ 0x8F6A,  0xFCCD },
	{ 0x8F6B,  0xFCCE },
	{ 0x8F6C,  0xFCCF },
	{ 0x8F6D,  0xC985 },
	{ 0x8F6F,  0xC76C },
	{ 0x8F70,  0x82339E35 },
	{ 0x8F71,  0xC94F },
	{ 0x8F72,  0xC988 },
	{ 0x8F73,  0xFCD6 },
	{ 0x8F74,  0x8232E031 },
	{ 0x8F75,  0xFCD8 },
	{ 0x8F76,  0x8233AE37 },
	{ 0x8F77,  0xCA68 },
	{ 0x8F78,  0x8BB0 },
	{ 0x8F79,  0xFCDC },
	{ 0x8F7A,  0x8233AB39 },
	{ 0x8F7B,  0xCA97 },
	{ 0x8F7C,  0x8233AA32 },
	{ 0x8F7D,  0x96A8 },
	{ 0x8F7E,  0xDEC1 },
	{ 0x8FA1,  0xFCE2 },
	{ 0x8FA2,  0xFCE3 },
	{ 0x8FA3,  0xDEBB },
	{ 0x8FA4,  0xFCE5 },
	{ 0x8FA5,  0xCC47 },
	{ 0x8FA6,  0xFCE7 },
	{ 0x8FA7,  0xFCE8 },
	{ 0x8FA8,  0xFCE9 },
	{ 0x8FA9,  0x8233B236 },
	{ 0x8FAA,  0xCC69 },
	{ 0x8FAB,  0x8230AA38 },
	{ 0x8FAC,  0xFCED },
	{ 0x8FAD,  0xBAC5 },
	{ 0x8FAE,  0xFCEF },
	{ 0x8FAF,  0xCFBA },
	{ 0x8FB0,  0xCE7B },
	{ 0x8FB1,  0xFCF2 },
	{ 0x8FB2,  0xF3B5 },
	{ 0x8FB3,  0xFCF4 },
	{ 0x8FB4,  0xCF47 },
	{ 0x8FB5,  0xCF65 },
	{ 0x8FB6,  0xCF92 },
	{ 0x8FB7,  0x877E },
	{ 0x8FB8,  0xF2B0 },
	{ 0x8FB9,  0x96F9 },
	{ 0x8FBA,  0x8233C331 },
	{ 0x8FBB,  0xD0C6 },
	{ 0x8FBC,  0xD05C },
	{ 0x8FBD,  0xFCFE },
	{ 0x8FBE,  0xFDA1 },
	{ 0x8FBF,  0xFDA2 },
	{ 0x8FC0,  0xD06F },
	{ 0x8FC1,  0xCDE0 },
	{ 0x8FC2,  0x8233CA36 },
	{ 0x8FC3,  0xD146 },
	{ 0x8FC4,  0xD147 },
	{ 0x8FC5,  0x9340 },
	{ 0x8FC6,  0xD7B0 },
	{ 0x8FC7,  0xB252 },
	{ 0x8FC8,  0xFDAB },
	{ 0x8FC9,  0xD286 },
	{ 0x8FCA,  0xD289 },
	{ 0x8FCD,  0xD345 },
	{ 0x8FCE,  0xD35A },
	{ 0x8FCF,  0xFDB2 },
	{ 0x8FD0,  0xD36E },
	{ 0x8FD1,  0xFDB4 },
	{ 0x8FD2,  0xFDB5 },
	{ 0x8FD3,  0xD558 },
	{ 0x8FD4,  0xB262 },
	{ 0x8FD5,  0xE258 },
	{ 0x8FD6,  0xD54D },
	{ 0x8FD7,  0xFDBA },
	{ 0x8FD8,  0xB876 },
	{ 0x8FD9,  0xFDBC },
	{ 0x8FDA,  0xFDBD },
	{ 0x8FDB,  0x8233DC39 },
	{ 0x8FDC,  0xFDBF },
	{ 0x8FDD,  0x9FB7 },
	{ 0x8FDE,  0xD667 },
	{ 0x8FDF,  0xD67A },
	{ 0x8FE0,  0xFDC3 },
	{ 0x8FE1,  0xFDC4 },
	{ 0x8FE2,  0xD69A },
	{ 0x8FE3,  0xD746 },
	{ 0x8FE4,  0xD747 },
	{ 0x8FE5,  0xD565 },
	{ 0x8FE6,  0xFDC9 },
	{ 0x8FE7,  0xD789 },
	{ 0x8FE8,  0xD794 },
	{ 0x8FE9,  0xD56B },
	{ 0x8FEA,  0xFDCD },
	{ 0x8FEB,  0x8233C337 },
	{ 0x8FEC,  0xD063 },
	{ 0x8FED,  0xD88E },
	{ 0x8FEE,  0xFDD1 },
	{ 0x8FEF,  0xFDD2 },
	{ 0x8FF0,  0xFDD3 },
	{ 0x8FF1,  0x8230C039 },
	{ 0x8FF2,  0xFDD5 },
	{ 0x8FF3,  0xD968 },
	{ 0x8FF4,  0xFDD7 },
	{ 0x8FF5,  0xFDD8 },
	{ 0x8FF6,  0xDA44 },
	{ 0x8FF7,  0xD996 },
	{ 0x8FF8,  0xFDDB },
	{ 0x8FF9,  0xD96D },
	{ 0x8FFA,  0x9EAD },
	{ 0x8FFB,  0xDA43 },
	{ 0x8FFC,  0xFDDF },
	{ 0x8FFD,  0x82328833 },
	{ 0x9040,  0xDA86 },
	{ 0x9041,  0xFDE3 },
	{ 0x9042,  0xFDE4 },
	{ 0x9043,  0xFDE5 },
	{ 0x9044,  0x8231B133 },
	{ 0x9045,  0xFDE7 },
	{ 0x9046,  0xFDE8 },
	{ 0x9047,  0xB874 },
	{ 0x9048,  0xDC6C },
	{ 0x9049,  0xDC73 },
	{ 0x904A,  0xDC80 },
	{ 0x904B,  0xE46A },
	{ 0x904C,  0xDD74 },
	{ 0x904D,  0xDD89 },
	{ 0x904E,  0xFDF0 },
	{ 0x904F,  0xFDF1 },
	{ 0x9050,  0xDE6A },
	{ 0x9051,  0xE49A },
	{ 0x9052,  0xFDF4 },
	{ 0x9053,  0xFDF5 },
	{ 0x9054,  0xDE73 },
	{ 0x9055,  0x82349430 },
	{ 0x9056,  0xFDF8 },
	{ 0x9057,  0xFDF9 },
	{ 0x9058,  0xFDFA },
	{ 0x9059,  0x8F66 },
	{ 0x905A,  0xFDFC },
	{ 0x905B,  0xBCA3 },
	{ 0x905C,  0xFDFE },
	{ 0x905D,  0xFEA1 },
	{ 0x905E,  0xFEA2 },
	{ 0x905F,  0xFEA3 },
	{ 0x9060,  0x8230FD30 },
	{ 0x9061,  0xFEA5 },
	{ 0x9062,  0xDF50 },
	{ 0x9063,  0xFEA7 },
	{ 0x9064,  0xFEA8 },
	{ 0x9065,  0xDF69 },
	{ 0x9066,  0xFEAA },
	{ 0x9067,  0xFEAB },
	{ 0x9068,  0xDF97 },
	{ 0x9069,  0xFEAD },
	{ 0x906A,  0xDBA7 },
	{ 0x906B,  0xFEAF },
	{ 0x906C,  0xD3CA },
	{ 0x906E,  0xE14F },
	{ 0x906F,  0x8231A334 },
	{ 0x9070,  0xE173 },
	{ 0x9071,  0xE188 },
	{ 0x9072,  0xBB96 },
	{ 0x9073,  0xFEB7 },
	{ 0x9074,  0xFEB8 },
	{ 0x9075,  0xE268 },
	{ 0x9076,  0xB9B5 },
	{ 0x9077,  0xE29C },
	{ 0x9078,  0xE35C },
	{ 0x9079,  0xFEBD },
	{ 0x907B,  0xFEBF },
	{ 0x907C,  0xFEC0 },
	{ 0x907D,  0xFEC1 },
	{ 0x907E,  0xFEC2 },
	{ 0x90A1,  0xFEC3 },
	{ 0x90A2,  0xE562 },
	{ 0x90A3,  0xE5A0 },
	{ 0x90A4,  0xFEC6 },
	{ 0x90A5,  0xFEC7 },
	{ 0x90A6,  0x9ECF },
	{ 0x90A7,  0x8B8F },
	{ 0x90A8,  0xFECA },
	{ 0x90A9,  0xFECB },
	{ 0x90AA,  0x82349938 },
	{ 0x90AB,  0xE29F },
	{ 0x90AC,  0xFECE },
	{ 0x90AD,  0xFECF },
	{ 0x90AE,  0xFED0 },
	{ 0x90AF,  0xE647 },
	{ 0x90B0,  0xE86B },
	{ 0x90B1,  0xDC78 },
	{ 0x90B2,  0xE959 },
	{ 0x90B3,  0xE97A },
	{ 0x90B4,  0xE798 },
	{ 0x90B5,  0xE974 },
	{ 0x90B6,  0x9E4E },
	{ 0x90B7,  0x8232EC32 },
	{ 0x90B8,  0xFEDA },
	{ 0x90B9,  0xFEDB },
	{ 0x90BA,  0xFEDC },
	{ 0x90BB,  0xFEDD },
	{ 0x90BC,  0x8234A530 },
	{ 0x90BD,  0x9ADE },
	{ 0x90BE,  0xEA94 },
	{ 0x90BF,  0xEB46 },
	{ 0x90C0,  0x8232CA39 },
	{ 0x90C1,  0xEB4F },
	{ 0x90C2,  0xFEE4 },
	{ 0x90C3,  0x91B6 },
	{ 0x90C4,  0xC1A5 },
	{ 0x90C5,  0xB48D },
	{ 0x90C6,  0xFEE8 },
	{ 0x90C7,  0xF6C1 },
	{ 0x90C8,  0xCBAB },
	{ 0x90C9,  0x82349F30 },
	{ 0x90CA,  0xFEEC },
	{ 0x90CB,  0xFEED },
	{ 0x90CC,  0xFEEE },
	{ 0x90CD,  0xFEEF },
	{ 0x90CE,  0xFEF0 },
	{ 0x90CF,  0xFEF1 },
	{ 0x90D0,  0xFEF2 },
	{ 0x90D1,  0xFEF3 },
	{ 0x90D2,  0xEC4D },
	{ 0x90D3,  0xCC81 },
	{ 0x90D4,  0xEC51 },
	{ 0x90D5,  0x8234A938 },
	{ 0x90D6,  0x8233AE31 },
	{ 0x90D7,  0x8233B533 },
	{ 0x90D8,  0xFEFA },
	{ 0x90D9,  0xC1E9 },
	{ 0x90DA,  0x8BF8 },
	{ 0x90DB,  0xEB9D },
	{ 0x90DD,  0xA140 },
	{ 0x90DE,  0xEC6C },
	{ 0x90DF,  0x8C42 },
	{ 0x90E0,  0xA143 },
	{ 0x90E1,  0xEC71 },
	{ 0x90E2,  0xE797 },
	{ 0x90E3,  0x8352 },
	{ 0x90E4,  0xA147 },
	{ 0x90E5,  0xA148 },
	{ 0x90E6,  0xEC92 },
	{ 0x90E7,  0xED41 },
	{ 0x90E8,  0xED4E },
	{ 0x90E9,  0xED59 },
	{ 0x90EA,  0xED5B },
	{ 0x90EB,  0xED6D },
	{ 0x90EC,  0xED7B },
	{ 0x90ED,  0xA150 },
	{ 0x90EE,  0xED83 },
	{ 0x90EF,  0xAC5B },
	{ 0x90F0,  0xA153 },
	{ 0x90F2,  0xD4CF },
	{ 0x90F3,  0xA156 },
	{ 0x90F4,  0xA157 },
	{ 0x90F5,  0x8234BD32 },
	{ 0x90F6,  0xEE65 },
	{ 0x90F7,  0xEE64 },
	{ 0x90F8,  0xEE7C },
	{ 0x90F9,  0xEE98 },
	{ 0x90FA,  0x8231A634 },
	{ 0x90FB,  0xA15E },
	{ 0x90FC,  0x8231E030 },
	{ 0x90FD,  0xA160 },
	{ 0x90FE,  0xA161 },
	{ 0x9140,  0xA162 },
	{ 0x9141,  0xEF6E },
	{ 0x9142,  0xEF5B },
	{ 0x9143,  0xEF6C },
	{ 0x9144,  0xEF6B },
	{ 0x9145,  0x8234C138 },
	{ 0x9146,  0xA168 },
	{ 0x9147,  0xA169 },
	{ 0x9148,  0x86D0 },
	{ 0x9149,  0xEF7B },
	{ 0x914A,  0xEF81 },
	{ 0x914B,  0xEF85 },
	{ 0x914C,  0xE64C },
	{ 0x914D,  0xF06E },
	{ 0x914E,  0xA170 },
	{ 0x914F,  0x8234CD33 },
	{ 0x9150,  0xA172 },
	{ 0x9151,  0xA173 },
	{ 0x9152,  0xF19C },
	{ 0x9153,  0xF252 },
	{ 0x9154,  0xF282 },
	{ 0x9155,  0xF256 },
	{ 0x9156,  0xF29F },
	{ 0x9157,  0xA179 },
	{ 0x9158,  0x8230B732 },
	{ 0x9159,  0xA17B },
	{ 0x915A,  0xA17C },
	{ 0x915B,  0xF382 },
	{ 0x915C,  0xF383 },
	{ 0x915D,  0xA180 },
	{ 0x915E,  0xF391 },
	{ 0x915F,  0x8234DC39 },
	{ 0x9160,  0xF44A },
	{ 0x9161,  0xF461 },
	{ 0x9162,  0xA185 },
	{ 0x9163,  0x8296 },
	{ 0x9164,  0xF466 },
	{ 0x9165,  0xA188 },
	{ 0x9166,  0x8230EA33 },
	{ 0x9167,  0xA18A },
	{ 0x9168,  0xF476 },
	{ 0x9169,  0xF470 },
	{ 0x916A,  0xA18D },
	{ 0x916B,  0x8AE8 },
	{ 0x916C,  0xA18F },
	{ 0x916D,  0xF552 },
	{ 0x916E,  0xA191 },
	{ 0x916F,  0xF666 },
	{ 0x9170,  0xF663 },
	{ 0x9171,  0xF670 },
	{ 0x9172,  0xA195 },
	{ 0x9173,  0xFA71 },
	{ 0x9174,  0xA197 },
	{ 0x9175,  0xA198 },
	{ 0x9176,  0xA199 },
	{ 0x9177,  0xA19A },
	{ 0x9178,  0xA19B },
	{ 0x9179,  0xA19C },
	{ 0x917A,  0xF97B },
	{ 0x917B,  0xF981 },
	{ 0x917C,  0xA19F },
	{ 0x917D,  0xFB4B },
	{ 0x917E,  0x975A },
	{ 0x91A1,  0xFA61 },
	{ 0x91A2,  0xA242 },
	{ 0x91A3,  0xA243 },
	{ 0x91A4,  0xA244 },
	{ 0x91A5,  0xA245 },
	{ 0x91A6,  0xA246 },
	{ 0x91A7,  0xF897 },
	{ 0x91A8,  0xA248 },
	{ 0x91A9,  0xA249 },
	{ 0x91AA,  0xFB8B },
	{ 0x91AB,  0xFB8E },
	{ 0x91AC,  0xFB96 },
	{ 0x91AD,  0xFB99 },
	{ 0x91AE,  0x8234F930 },
	{ 0x91AF,  0xFBA0 },
	{ 0x91B0,  0xFC44 },
	{ 0x91B1,  0xA251 },
	{ 0x91B2,  0xFC51 },
	{ 0x91B3,  0x8231AE35 },
	{ 0x91B4,  0x82318838 },
	{ 0x91B5,  0x8231DA38 },
	{ 0x91B6,  0xD9A3 },
	{ 0x91B7,  0x8230D032 },
	{ 0x91B8,  0xA258 },
	{ 0x91B9,  0xFC7B },
	{ 0x91BA,  0xFC82 },
	{ 0x91BB,  0x8234D039 },
	{ 0x91BC,  0xE796 },
	{ 0x91BD,  0xA25D },
	{ 0x91BE,  0xD8BB },
	{ 0x91C0,  0xF7FA },
	{ 0x91C1,  0x87AD },
	{ 0x91C2,  0x879B },
	{ 0x91C3,  0xFD4D },
	{ 0x91C4,  0xF15E },
	{ 0x91C5,  0xA265 },
	{ 0x91C6,  0xED87 },
	{ 0x91C7,  0xC942 },
	{ 0x91C8,  0xFD68 },
	{ 0x91C9,  0xFD6F },
	{ 0x91CA,  0xB86F },
	{ 0x91CB,  0xFD89 },
	{ 0x91CC,  0xA07A },
	{ 0x91CD,  0x8234D439 },
	{ 0x91CE,  0xA26E },
	{ 0x91CF,  0xA26F },
	{ 0x91D0,  0x9FB4 },
	{ 0x91D1,  0xA271 },
	{ 0x91D2,  0xA272 },
	{ 0x91D3,  0xA273 },
	{ 0x91D4,  0xAB63 },
	{ 0x91D5,  0xA275 },
	{ 0x91D6,  0xA276 },
	{ 0x91D7,  0xB64B },
	{ 0x91D8,  0xA278 },
	{ 0x91D9,  0xA279 },
	{ 0x91DA,  0xE59F },
	{ 0x91DB,  0xE764 },
	{ 0x91DC,  0xA27C },
	{ 0x91DD,  0xE483 },
	{ 0x91DE,  0xE655 },
	{ 0x91DF,  0xE69E },
	{ 0x91E0,  0xA281 },
	{ 0x91E1,  0xA282 },
	{ 0x91E2,  0xA07B },
	{ 0x91E3,  0x82328B30 },
	{ 0x91E4,  0xB24D },
	{ 0x91E5,  0xB75C },
	{ 0x91E6,  0x9EF6 },
	{ 0x91E7,  0xA288 },
	{ 0x91E8,  0xA289 },
	{ 0x91E9,  0x9FB8 },
	{ 0x91EA,  0xA28B },
	{ 0x91EB,  0x9EDC },
	{ 0x91EC,  0xA28D },
	{ 0x91ED,  0xA28E },
	{ 0x91EE,  0x82328734 },
	{ 0x91EF,  0xA290 },
	{ 0x91F0,  0xA291 },
	{ 0x91F1,  0xA292 },
	{ 0x91F2,  0x8230C036 },
	{ 0x91F3,  0xA294 },
	{ 0x91F4,  0xA295 },
	{ 0x91F5,  0x8230BA31 },
	{ 0x91F6,  0xA297 },
	{ 0x91F7,  0xA298 },
	{ 0x91F8,  0xA299 },
	{ 0x91F9,  0x8230C037 },
	{ 0x91FA,  0xA29B },
	{ 0x91FB,  0xCCB3 },
	{ 0x91FC,  0xA29D },
	{ 0x91FD,  0xA29E },
	{ 0x91FE,  0xA29F },
	{ 0x9240,  0xA2A0 },
	{ 0x9241,  0xA340 },
	{ 0x9242,  0xCA40 },
	{ 0x9243,  0xA342 },
	{ 0x9245,  0xC88A },
	{ 0x9246,  0xA345 },
	{ 0x9247,  0xA346 },
	{ 0x9248,  0xA347 },
	{ 0x9249,  0xA348 },
	{ 0x924A,  0xA349 },
	{ 0x924B,  0xA34A },
	{ 0x924C,  0x8233A638 },
	{ 0x924D,  0xA34C },
	{ 0x924E,  0xA34D },
	{ 0x924F,  0xA34E },
	{ 0x9250,  0x96C9 },
	{ 0x9251,  0x8230C233 },
	{ 0x9252,  0x8231C036 },
	{ 0x9253,  0x8231EF30 },
	{ 0x9254,  0xDCAB },
	{ 0x9255,  0xA354 },
	{ 0x9256,  0x96D4 },
	{ 0x9257,  0x8232AF33 },
	{ 0x9258,  0xA357 },
	{ 0x9259,  0xA358 },
	{ 0x925A,  0xA359 },
	{ 0x925B,  0xA35A },
	{ 0x925C,  0xA35B },
	{ 0x925D,  0x864F },
	{ 0x925E,  0x87AC },
	{ 0x925F,  0xA35E },
	{ 0x9260,  0x87A1 },
	{ 0x9261,  0xA360 },
	{ 0x9262,  0xA361 },
	{ 0x9263,  0xA362 },
	{ 0x9264,  0xE69A },
	{ 0x9265,  0xA364 },
	{ 0x9266,  0xE66F },
	{ 0x9267,  0x81A6 },
	{ 0x9268,  0x839F },
	{ 0x9269,  0x8230D933 },
	{ 0x926A,  0xA369 },
	{ 0x926B,  0x8191 },
	{ 0x926C,  0xA36B },
	{ 0x926D,  0xA36C },
	{ 0x926E,  0x81D4 },
	{ 0x926F,  0x81EF },
	{ 0x9270,  0xA36F },
	{ 0x9271,  0x8B45 },
	{ 0x9272,  0xA371 },
	{ 0x9273,  0xA372 },
	{ 0x9274,  0x82318135 },
	{ 0x9275,  0xA374 },
	{ 0x9276,  0xA375 },
	{ 0x9277,  0x8139F432 },
	{ 0x9278,  0x81BF },
	{ 0x9279,  0xA378 },
	{ 0x927A,  0xA379 },
	{ 0x927B,  0xA37A },
	{ 0x927C,  0xD597 },
	{ 0x927D,  0xA37C },
	{ 0x927E,  0xD8A8 },
	{ 0x92A1,  0x8350 },
	{ 0x92A2,  0x8383 },
	{ 0x92A3,  0x81FE },
	{ 0x92A4,  0x81AD },
	{ 0x92A5,  0xA383 },
	{ 0x92A6,  0xA384 },
	{ 0x92A7,  0x81CD },
	{ 0x92A8,  0xD9C0 },
	{ 0x92A9,  0xD9CC },
	{ 0x92AA,  0x82CF },
	{ 0x92AB,  0x8259 },
	{ 0x92AC,  0x8265 },
	{ 0x92AD,  0x82B0 },
	{ 0x92AE,  0x8374 },
	{ 0x92B3,  0x9CB2 },
	{ 0x92B4,  0xA392 },
	{ 0x92B5,  0xA393 },
	{ 0x92B6,  0xA394 },
	{ 0x92B7,  0x9BCD },
	{ 0x92B8,  0xA396 },
	{ 0x92B9,  0xA397 },
	{ 0x92BA,  0x83E5 },
	{ 0x92BB,  0x83F2 },
	{ 0x92BC,  0xA39A },
	{ 0x92BD,  0x8233A435 },
	{ 0x92BE,  0xA39C },
	{ 0x92BF,  0xA39D },
	{ 0x92C0,  0xA39E },
	{ 0x92C1,  0xDA5F },
	{ 0x92C2,  0xA3A0 },
	{ 0x92C3,  0xA440 },
	{ 0x92C4,  0x8480 },
	{ 0x92C5,  0x84B3 },
	{ 0x92C6,  0xA443 },
	{ 0x92C7,  0x84DC },
	{ 0x92C9,  0x8233CD36 },
	{ 0x92CA,  0x9FC4 },
	{ 0x92CB,  0xA448 },
	{ 0x92CC,  0xA449 },
	{ 0x92CD,  0xA44A },
	{ 0x92CE,  0xA44B },
	{ 0x92CF,  0x988E },
	{ 0x92D0,  0xA44D },
	{ 0x92D2,  0x82328937 },
	{ 0x92D3,  0xAD56 },
	{ 0x92D4,  0xAC55 },
	{ 0x92D5,  0xAC87 },
	{ 0x92D6,  0xAB5E },
	{ 0x92D7,  0x8234D031 },
	{ 0x92D8,  0xA455 },
	{ 0x92D9,  0xA456 },
	{ 0x92DA,  0x85A9 },
	{ 0x92DB,  0x82309735 },
	{ 0x92DC,  0xA073 },
	{ 0x92DD,  0xA45A },
	{ 0x92DE,  0x86D2 },
	{ 0x92DF,  0xA45C },
	{ 0x92E0,  0xCFEC },
	{ 0x92E1,  0xA45E },
	{ 0x92E2,  0x884A },
	{ 0x92E3,  0xE357 },
	{ 0x92E4,  0xEB86 },
	{ 0x92E5,  0xE59C },
	{ 0x92E6,  0xDBFE },
	{ 0x92E7,  0x8885 },
	{ 0x92E8,  0x887D },
	{ 0x92E9,  0x8230A938 },
	{ 0x92EA,  0x89B3 },
	{ 0x92EB,  0x8B6E },
	{ 0x92EC,  0xA469 },
	{ 0x92ED,  0xA46A },
	{ 0x92EE,  0xA46B },
	{ 0x92EF,  0xA46C },
	{ 0x92F0,  0x8AD5 },
	{ 0x92F1,  0x8A8A },
	{ 0x92F2,  0xE388 },
	{ 0x92F3,  0x8B55 },
	{ 0x92F4,  0x8B99 },
	{ 0x92F5,  0x8AC3 },
	{ 0x92F6,  0xA473 },
	{ 0x92F7,  0xA474 },
	{ 0x92F8,  0xA475 },
	{ 0x92F9,  0xA476 },
	{ 0x92FA,  0x8230BC31 },
	{ 0x92FB,  0x9B92 },
	{ 0x92FC,  0xAC74 },
	{ 0x92FD,  0x8ACD },
	{ 0x92FE,  0xA47B },
	{ 0x9340,  0x8B57 },
	{ 0x9341,  0xA47D },
	{ 0x9342,  0xA47E },
	{ 0x9343,  0xE751 },
	{ 0x9344,  0xAD4B },
	{ 0x9345,  0xA482 },
	{ 0x9346,  0x9F5C },
	{ 0x9347,  0x82349B31 },
	{ 0x9348,  0xE779 },
	{ 0x9349,  0xA486 },
	{ 0x934A,  0xE691 },
	{ 0x934B,  0x8230CD32 },
	{ 0x934C,  0x8CAE },
	{ 0x934D,  0x8CF6 },
	{ 0x934E,  0xE1A5 },
	{ 0x934F,  0x8EB1 },
	{ 0x9350,  0xA48D },
	{ 0x9351,  0xA48E },
	{ 0x9352,  0xA48F },
	{ 0x9353,  0x8F45 },
	{ 0x9354,  0x8C47 },
	{ 0x9355,  0xA492 },
	{ 0x9356,  0xA493 },
	{ 0x9357,  0x8230BD33 },
	{ 0x9358,  0xA495 },
	{ 0x9359,  0x8230B937 },
	{ 0x935A,  0xA497 },
	{ 0x935B,  0x8230B837 },
	{ 0x935C,  0xC392 },
	{ 0x935D,  0xA49A },
	{ 0x935E,  0xA49B },
	{ 0x935F,  0xA49C },
	{ 0x9360,  0xA49D },
	{ 0x9361,  0x8F6F },
	{ 0x9362,  0x8F71 },
	{ 0x9363,  0xA4A0 },
	{ 0x9364,  0xA540 },
	{ 0x9365,  0x8B47 },
	{ 0x9366,  0xA542 },
	{ 0x9367,  0x8BFB },
	{ 0x9368,  0xCC57 },
	{ 0x9369,  0xA545 },
	{ 0x936A,  0xD071 },
	{ 0x936B,  0x907D },
	{ 0x936C,  0xA548 },
	{ 0x936D,  0xA549 },
	{ 0x936E,  0x8FE9 },
	{ 0x936F,  0x82328539 },
	{ 0x9370,  0xA54C },
	{ 0x9371,  0xA54D },
	{ 0x9372,  0xA54E },
	{ 0x9373,  0xA54F },
	{ 0x9374,  0x91A3 },
	{ 0x9375,  0xA551 },
	{ 0x9376,  0xA552 },
	{ 0x9377,  0xA553 },
	{ 0x9378,  0x9183 },
	{ 0x9379,  0x9182 },
	{ 0x937A,  0x907B },
	{ 0x937B,  0xA557 },
	{ 0x937C,  0xA558 },
	{ 0x937D,  0xA559 },
	{ 0x937E,  0xA55A },
	{ 0x93A1,  0x93B6 },
	{ 0x93A2,  0xA55C },
	{ 0x93A3,  0xA55D },
	{ 0x93A4,  0x82318F36 },
	{ 0x93A5,  0xA55F },
	{ 0x93A6,  0xA560 },
	{ 0x93A7,  0xA561 },
	{ 0x93A8,  0xA562 },
	{ 0x93A9,  0x92B2 },
	{ 0x93AA,  0xA564 },
	{ 0x93AB,  0x93E7 },
	{ 0x93AC,  0x92AD },
	{ 0x93AD,  0x9349 },
	{ 0x93AE,  0xA568 },
	{ 0x93AF,  0xA569 },
	{ 0x93B0,  0xBBA4 },
	{ 0x93B1,  0xA56B },
	{ 0x93B2,  0x9390 },
	{ 0x93B3,  0xEBB8 },
	{ 0x93B4,  0x984C },
	{ 0x93B5,  0x8231BD33 },
	{ 0x93B6,  0xA570 },
	{ 0x93B7,  0xA571 },
	{ 0x93B8,  0xA572 },
	{ 0x93B9,  0xA573 },
	{ 0x93BA,  0x866E },
	{ 0x93BB,  0xA575 },
	{ 0x93BC,  0xA576 },
	{ 0x93BD,  0xA577 },
	{ 0x93BE,  0x95D9 },
	{ 0x93BF,  0xA579 },
	{ 0x93C0,  0xA57A },
	{ 0x93C1,  0x8231A138 },
	{ 0x93C2,  0x8232CE35 },
	{ 0x93C3,  0xA57D },
	{ 0x93C4,  0xA57E },
	{ 0x93C5,  0xA580 },
	{ 0x93C6,  0xA581 },
	{ 0x93C7,  0xA582 },
	{ 0x93C8,  0xA583 },
	{ 0x93C9,  0xB488 },
	{ 0x93CA,  0xA585 },
	{ 0x93CB,  0xA586 },
	{ 0x93CC,  0xA587 },
	{ 0x93CD,  0x8139F838 },
	{ 0x93CE,  0xA589 },
	{ 0x93CF,  0xA58A },
	{ 0x93D0,  0xA58B },
	{ 0x93D1,  0x95A3 },
	{ 0x93D2,  0xA58D },
	{ 0x93D3,  0x958C },
	{ 0x93D4,  0x8234D036 },
	{ 0x93D5,  0x9567 },
	{ 0x93D6,  0xA591 },
	{ 0x93D7,  0xA592 },
	{ 0x93D8,  0x9587 },
	{ 0x93D9,  0xA594 },
	{ 0x93DA,  0xA595 },
	{ 0x93DB,  0x955C },
	{ 0x93DC,  0xA597 },
	{ 0x93DD,  0x8230EB37 },
	{ 0x93DE,  0xA599 },
	{ 0x93DF,  0xA59A },
	{ 0x93E0,  0x8231B432 },
	{ 0x93E1,  0xA59C },
	{ 0x93E2,  0xA59D },
	{ 0x93E3,  0xAD88 },
	{ 0x93E4,  0x8231B339 },
	{ 0x93E5,  0x968F },
	{ 0x93E6,  0xA640 },
	{ 0x93E7,  0x977C },
	{ 0x93E8,  0x96DD },
	{ 0x93E9,  0x8231B835 },
	{ 0x93EA,  0x9994 },
	{ 0x93EB,  0x8230E037 },
	{ 0x93EC,  0xA646 },
	{ 0x93ED,  0xA647 },
	{ 0x93EE,  0x98DF },
	{ 0x93EF,  0x98F8 },
	{ 0x93F0,  0x999F },
	{ 0x93F1,  0x99DB },
	{ 0x93F2,  0xA64C },
	{ 0x93F3,  0x9470 },
	{ 0x93F4,  0x9767 },
	{ 0x93F5,  0x98F3 },
	{ 0x93F6,  0x8231BA34 },
	{ 0x93F7,  0x995A },
	{ 0x93F8,  0x9A5E },
	{ 0x93F9,  0xA653 },
	{ 0x93FA,  0xA654 },
	{ 0x93FB,  0xE673 },
	{ 0x93FC,  0xE489 },
	{ 0x93FD,  0xA657 },
	{ 0x93FE,  0xA658 },
	{ 0x9440,  0xE383 },
	{ 0x9441,  0xA65A },
	{ 0x9442,  0xA65B },
	{ 0x9443,  0xE877 },
	{ 0x9444,  0x9BEA },
	{ 0x9445,  0x9D56 },
	{ 0x9446,  0xA65F },
	{ 0x9448,  0xA661 },
	{ 0x9449,  0x8231E632 },
	{ 0x944A,  0x9C64 },
	{ 0x944B,  0xA664 },
	{ 0x944C,  0x8AE1 },
	{ 0x944D,  0xD4A8 },
	{ 0x944E,  0x8948 },
	{ 0x944F,  0x9BA7 },
	{ 0x9450,  0xB36F },
	{ 0x9451,  0x9F85 },
	{ 0x9452,  0xA66B },
	{ 0x9453,  0xA66C },
	{ 0x9454,  0x9F4B },
	{ 0x9455,  0xA0A3 },
	{ 0x9456,  0xA0C4 },
	{ 0x9457,  0xA0CC },
	{ 0x9458,  0xA671 },
	{ 0x9459,  0xA672 },
	{ 0x945A,  0xD7C8 },
	{ 0x945B,  0xA674 },
	{ 0x945C,  0xA675 },
	{ 0x945D,  0xACA0 },
	{ 0x945E,  0xA677 },
	{ 0x945F,  0xA678 },
	{ 0x9460,  0xA679 },
	{ 0x9461,  0xA67A },
	{ 0x9462,  0xA67B },
	{ 0x9463,  0x82328D37 },
	{ 0x9464,  0x82328532 },
	{ 0x9465,  0xA67E },
	{ 0x9466,  0xA680 },
	{ 0x9467,  0xA681 },
	{ 0x9468,  0x9097 },
	{ 0x9469,  0x82328B38 },
	{ 0x946A,  0xAD84 },
	{ 0x946B,  0xC7ED },
	{ 0x946C,  0xE65B },
	{ 0x946D,  0xAC6A },
	{ 0x946E,  0x82339E34 },
	{ 0x946F,  0xA689 },
	{ 0x9470,  0x8233B031 },
	{ 0x9471,  0xEEB6 },
	{ 0x9472,  0x82329730 },
	{ 0x9473,  0xA68D },
	{ 0x9474,  0xA68E },
	{ 0x9475,  0x82329539 },
	{ 0x9476,  0xAE7B },
	{ 0x9477,  0xB065 },
	{ 0x9478,  0xA692 },
	{ 0x9479,  0x8231A735 },
	{ 0x947A,  0xAC92 },
	{ 0x947B,  0xA695 },
	{ 0x947C,  0xA696 },
	{ 0x947D,  0xA697 },
	{ 0x947E,  0x8231A435 },
	{ 0x94A1,  0x8231EC34 },
	{ 0x94A2,  0xA69A },
	{ 0x94A3,  0x82328D30 },
	{ 0x94A4,  0xA69C },
	{ 0x94A5,  0xA69D },
	{ 0x94A6,  0xE254 },
	{ 0x94A7,  0x8855 },
	{ 0x94A8,  0xE577 },
	{ 0x94A9,  0xA740 },
	{ 0x94AA,  0xA741 },
	{ 0x94AB,  0x835F },
	{ 0x94AC,  0xA743 },
	{ 0x94AD,  0xA744 },
	{ 0x94AE,  0xB253 },
	{ 0x94AF,  0xA746 },
	{ 0x94B0,  0xB169 },
	{ 0x94B1,  0xB16A },
	{ 0x94B2,  0xB255 },
	{ 0x94B3,  0xA74A },
	{ 0x94B4,  0xA74B },
	{ 0x94B5,  0x82319439 },
	{ 0x94B6,  0xA74D },
	{ 0x94B7,  0xAC6B },
	{ 0x94B8,  0xAD58 },
	{ 0x94B9,  0x82328636 },
	{ 0x94BA,  0xA751 },
	{ 0x94BB,  0xA752 },
	{ 0x94BC,  0x8232BA36 },
	{ 0x94BD,  0xA754 },
	{ 0x94BE,  0xA755 },
	{ 0x94BF,  0xE49E },
	{ 0x94C0,  0xA757 },
	{ 0x94C1,  0xB35D },
	{ 0x94C2,  0xB0AD },
	{ 0x94C3,  0xB443 },
	{ 0x94C4,  0xB470 },
	{ 0x94C5,  0xB7A9 },
	{ 0x94C6,  0xB57C },
	{ 0x94C7,  0xA75E },
	{ 0x94C8,  0xA75F },
	{ 0x94C9,  0x8232C136 },
	{ 0x94CB,  0xC952 },
	{ 0x94CC,  0xB651 },
	{ 0x94CD,  0x98DB },
	{ 0x94CE,  0xA765 },
	{ 0x94CF,  0xB757 },
	{ 0x94D0,  0xB685 },
	{ 0x94D1,  0x8232CB31 },
	{ 0x94D2,  0xA769 },
	{ 0x94D3,  0x8232C532 },
	{ 0x94D4,  0xE290 },
	{ 0x94D5,  0xB682 },
	{ 0x94D6,  0xA76D },
	{ 0x94D7,  0xA76E },
	{ 0x94D8,  0xA76F },
	{ 0x94D9,  0xA770 },
	{ 0x94DA,  0xA771 },
	{ 0x94DB,  0x82309934 },
	{ 0x94DC,  0x86A8 },
	{ 0x94DD,  0x82309535 },
	{ 0x94DE,  0x8230B436 },
	{ 0x94DF,  0xA776 },
	{ 0x94E0,  0xA777 },
	{ 0x94E1,  0xB872 },
	{ 0x94E2,  0x8AF8 },
	{ 0x94E3,  0xA77A },
	{ 0x94E4,  0xA77B },
	{ 0x94E5,  0xA77C },
	{ 0x94E6,  0x8ABF },
	{ 0x94E7,  0xA77E },
	{ 0x94E8,  0xB48A },
	{ 0x94E9,  0x8AD3 },
	{ 0x94EA,  0xA782 },
	{ 0x94EB,  0xB887 },
	{ 0x94EC,  0x8232D930 },
	{ 0x94ED,  0xBB59 },
	{ 0x94EE,  0xBB69 },
	{ 0x94EF,  0x8232DB34 },
	{ 0x94F0,  0xA788 },
	{ 0x94F1,  0xA789 },
	{ 0x94F2,  0xA78A },
	{ 0x94F3,  0xF4D9 },
	{ 0x94F4,  0xA78C },
	{ 0x94F5,  0xA78D },
	{ 0x94F6,  0xBB85 },
	{ 0x94F7,  0xF4CC },
	{ 0x94F8,  0xC1B8 },
	{ 0x94F9,  0x9988 },
	{ 0x94FA,  0xBE82 },
	{ 0x94FB,  0xBF4C },
	{ 0x94FC,  0xBE78 },
	{ 0x94FD,  0xC09D },
	{ 0x94FE,  0xA796 },
	{ 0x9540,  0xA797 },
	{ 0x9541,  0xA798 },
	{ 0x9542,  0xBD9F },
	{ 0x9543,  0xA79A },
	{ 0x9544,  0x8232E433 },
	{ 0x9545,  0xA79C },
	{ 0x9546,  0xA79D },
	{ 0x9547,  0x96B6 },
	{ 0x9548,  0xA79F },
	{ 0x9549,  0xA7A0 },
	{ 0x954A,  0x88A9 },
	{ 0x954B,  0xA2AC },
	{ 0x954C,  0xA2AD },
	{ 0x954D,  0xA2AE },
	{ 0x954E,  0xC19D },
	{ 0x954F,  0xB89E },
	{ 0x9550,  0x8336C739 },
	{ 0x9551,  0xA2E4 },
	{ 0x9552,  0xA2EF },
	{ 0x9553,  0xB88E },
	{ 0x9554,  0xA2FD },
	{ 0x9555,  0xF18D },
	{ 0x9556,  0xCC84 },
	{ 0x9557,  0xF349 },
	{ 0x9558,  0x98CE },
	{ 0x9559,  0xA4F7 },
	{ 0x955A,  0x82318835 },
	{ 0x955B,  0xA4F9 },
	{ 0x955C,  0xA4FA },
	{ 0x955D,  0xF265 },
	{ 0x955E,  0xA4FC },
	{ 0x955F,  0xC943 },
	{ 0x9560,  0xA4FE },
	{ 0x9561,  0xA5F7 },
	{ 0x9562,  0x8233A538 },
	{ 0x9563,  0xC39A },
	{ 0x9564,  0x82338E37 },
	{ 0x9565,  0xB5A8 },
	{ 0x9566,  0xC2F6 },
	{ 0x9567,  0xC442 },
	{ 0x9568,  0xA5FE },
	{ 0x9569,  0xEF67 },
	{ 0x956A,  0xA6BA },
	{ 0x956B,  0xC59A },
	{ 0x956C,  0xC59D },
	{ 0x956D,  0xA6BD },
	{ 0x956E,  0xC888 },
	{ 0x956F,  0xA6BF },
	{ 0x9570,  0xCC54 },
	{ 0x9571,  0xA6D9 },
	{ 0x9572,  0x8B5C },
	{ 0x9573,  0x8232CC38 },
	{ 0x9574,  0xA6DC },
	{ 0x9575,  0x8BE6 },
	{ 0x9576,  0xA6DE },
	{ 0x9577,  0x8BA6 },
	{ 0x9578,  0xA6EC },
	{ 0x9579,  0xCD5F },
	{ 0x957A,  0xA6F3 },
	{ 0x957B,  0xA6F6 },
	{ 0x957C,  0xD049 },
	{ 0x957D,  0xA6F8 },
	{ 0x957E,  0x8ABC },
	{ 0x95A1,  0xD9F2 },
	{ 0x95A2,  0x81CF },
	{ 0x95A3,  0xD085 },
	{ 0x95A4,  0xD14F },
	{ 0x95A5,  0xD166 },
	{ 0x95A6,  0xD269 },
	{ 0x95A7,  0xD253 },
	{ 0x95A8,  0xA7C4 },
	{ 0x95A9,  0xD25A },
	{ 0x95AA,  0xA7C6 },
	{ 0x95AB,  0xA7C7 },
	{ 0x95AC,  0xA7C8 },
	{ 0x95AD,  0xA7C9 },
	{ 0x95AE,  0xA7CA },
	{ 0x95AF,  0xA7CB },
	{ 0x95B0,  0x82328438 },
	{ 0x95B1,  0xC95B },
	{ 0x95B2,  0x8233D939 },
	{ 0x95B3,  0x8233D631 },
	{ 0x95B4,  0x8230D534 },
	{ 0x95B5,  0xD45F },
	{ 0x95B6,  0xD39F },
	{ 0x95B7,  0xA7F4 },
	{ 0x95B8,  0x8F9C },
	{ 0x95B9,  0xE286 },
	{ 0x95BA,  0xA7F7 },
	{ 0x95BB,  0x94F0 },
	{ 0x95BC,  0x9F76 },
	{ 0x95BD,  0x9EEC },
	{ 0x95BE,  0xA7FB },
	{ 0x95BF,  0xF96A },
	{ 0x95C0,  0xD892 },
	{ 0x95C1,  0xD97B },
	{ 0x95C2,  0xA896 },
	{ 0x95C3,  0x8A76 },
	{ 0x95C4,  0xB285 },
	{ 0x95C5,  0x8AAE },
	{ 0x95C6,  0x8232FE32 },
	{ 0x95C7,  0x8230B838 },
	{ 0x95C8,  0xD7D9 },
	{ 0x95C9,  0xDC68 },
	{ 0x95CA,  0xA89E },
	{ 0x95CB,  0xDD8C },
	{ 0x95CC,  0xDE45 },
	{ 0x95CD,  0x8232F231 },
	{ 0x95CE,  0x9AFE },
	{ 0x95CF,  0x9DDC },
	{ 0x95D0,  0xA8C2 },
	{ 0x95D1,  0x82348537 },
	{ 0x95D2,  0x9DA8 },
	{ 0x95D3,  0x9CC1 },
	{ 0x95D4,  0xA8EB },
	{ 0x95D5,  0xF64D },
	{ 0x95D6,  0x8230B537 },
	{ 0x95D7,  0xA8EE },
	{ 0x95D8,  0xC1DA },
	{ 0x95DA,  0x86AB },
	{ 0x95DB,  0x82349034 },
	{ 0x95DC,  0xE17E },
	{ 0x95DD,  0xE775 },
	{ 0x95DE,  0xA8F5 },
	{ 0x95DF,  0x8232B034 },
	{ 0x95E0,  0xA8F7 },
	{ 0x95E1,  0xE799 },
	{ 0x95E2,  0xA8F9 },
	{ 0x95E3,  0xA8FA },
	{ 0x95E4,  0xDDF6 },
	{ 0x95E5,  0xD44D },
	{ 0x95E6,  0xE96D },
	{ 0x95E7,  0xE97B },
	{ 0x95E8,  0xE96B },
	{ 0x95E9,  0xE96A },
	{ 0x95EA,  0xA95D },
	{ 0x95EB,  0xAC76 },
	{ 0x95EC,  0x82328639 },
	{ 0x95ED,  0x8336C831 },
	{ 0x95EE,  0x8336C832 },
	{ 0x95EF,  0x8336C833 },
	{ 0x95F0,  0x82328A36 },
	{ 0x95F1,  0x8336C835 },
	{ 0x95F2,  0xCBE6 },
	{ 0x95F3,  0x8336C837 },
	{ 0x95F4,  0x8336C838 },
	{ 0x95F5,  0x8336C839 },
	{ 0x95F6,  0x82328739 },
	{ 0x95F7,  0x8336C931 },
	{ 0x95F8,  0x8336C932 },
	{ 0x95F9,  0x8336C933 },
	{ 0x95FA,  0xAC53 },
	{ 0x95FB,  0xAC95 },
	{ 0x95FC,  0x82328C37 },
	{ 0x95FD,  0xEC59 },
	{ 0x95FE,  0xA99B },
	{ 0x9640,  0x96F4 },
	{ 0x9641,  0x8234AB32 },
	{ 0x9642,  0xA99E },
	{ 0x9643,  0xA99F },
	{ 0x9645,  0xE59E },
	{ 0x9646,  0xA9A2 },
	{ 0x9647,  0xA9A3 },
	{ 0x9648,  0xA9F0 },
	{ 0x9649,  0xA9F1 },
	{ 0x964A,  0xE451 },
	{ 0x964B,  0x8BCE },
	{ 0x964C,  0xD762 },
	{ 0x964D,  0x82349538 },
	{ 0x964E,  0xAC41 },
	{ 0x964F,  0xA9F7 },
	{ 0x9650,  0xEC9E },
	{ 0x9651,  0xEC7E },
	{ 0x9652,  0xF06D },
	{ 0x9653,  0xA9FB },
	{ 0x9654,  0x8E5F },
	{ 0x9655,  0xA9FD },
	{ 0x9656,  0xA9FE },
	{ 0x9657,  0xEE50 },
	{ 0x9658,  0xD7FB },
	{ 0x9659,  0xE48D },
	{ 0x965A,  0xD7FD },
	{ 0x965B,  0xE1A0 },
	{ 0x965C,  0x8233A137 },
#ifdef  COLLISION_ALLOWED
	{ 0x965D,  0xFE51 },
	{ 0x965E,  0xFE52 },
	{ 0x965F,  0xFE53 },
#endif
	{ 0x9660,  0xEF78 },
	{ 0x9661,  0x8336C936 },
	{ 0x9662,  0x82328D31 },
	{ 0x9663,  0xE285 },
	{ 0x9664,  0x82349335 },
	{ 0x9665,  0xC856 },
	{ 0x9666,  0xF070 },
	{ 0x9667,  0xF083 },
	{ 0x9668,  0x8336CA32 },
	{ 0x9669,  0x8231F132 },
	{ 0x966A,  0xF143 },
	{ 0x966B,  0x8234CD30 },
	{ 0x966C,  0xF150 },
	{ 0x966D,  0xF342 },
	{ 0x966E,  0x8336CA37 },
	{ 0x966F,  0x8336CA38 },
	{ 0x9670,  0x996B },
	{ 0x9671,  0xF267 },
	{ 0x9672,  0x8BBC },
	{ 0x9673,  0xF275 },
	{ 0x9674,  0x8336CB31 },
	{ 0x9675,  0x8234D033 },
	{ 0x9676,  0x8336CB33 },
	{ 0x9677,  0xF162 },
	{ 0x9678,  0x8234D438 },
	{ 0x9679,  0x8234D130 },
	{ 0x967A,  0xE651 },
	{ 0x967B,  0x896A },
	{ 0x967C,  0x8336CB37 },
	{ 0x967D,  0x88E7 },
	{ 0x967E,  0x8336CB39 },
	{ 0x96A1,  0x8336CC30 },
	{ 0x96A2,  0xB371 },
	{ 0x96A3,  0x8336CC32 },
#ifdef  COLLISION_ALLOWED
	{ 0x96A4,  0xFE76 },
#endif
	{ 0x96A5,  0x978A },
	{ 0x96A6,  0x8231E434 },
	{ 0x96A7,  0xE868 },
	{ 0x96A8,  0x8230F432 },
	{ 0x96A9,  0x9145 },
	{ 0x96AA,  0x8336CC38 },
	{ 0x96AB,  0x8336CC39 },
	{ 0x96AC,  0x90CE },
	{ 0x96AD,  0xF753 },
	{ 0x96AE,  0xF757 },
	{ 0x96AF,  0xF780 },
	{ 0x96B0,  0xF69A },
	{ 0x96B1,  0xF674 },
	{ 0x96B2,  0xF543 },
	{ 0x96B3,  0xF594 },
	{ 0x96B4,  0x8336CD37 },
	{ 0x96B5,  0xF563 },
	{ 0x96B6,  0x8336CD39 },
	{ 0x96B7,  0x8336CE30 },
	{ 0x96B8,  0xF87E },
	{ 0x96B9,  0x8234EC33 },
	{ 0x96BA,  0x8336CE33 },
	{ 0x96BB,  0xFB55 },
	{ 0x96BC,  0x8234EC35 },
	{ 0x96BD,  0xF869 },
#ifdef  COLLISION_ALLOWED
	{ 0x96BE,  0xFE91 },
#endif
	{ 0x96BF,  0x8336CE36 },
	{ 0x96C0,  0x8336CE37 },
	{ 0x96C1,  0x8336CE38 },
	{ 0x96C2,  0xFA42 },
	{ 0x96C3,  0xDDEC },
	{ 0x96C4,  0x8336CF31 },
	{ 0x96C5,  0x8336CF32 },
	{ 0x96C6,  0x8336CF33 },
	{ 0x96C7,  0xCC42 },
	{ 0x96C8,  0x8233AD31 },
	{ 0x96C9,  0x8336CF36 },
	{ 0x96CA,  0x8336CF37 },
	{ 0x96CB,  0x8336CF38 },
	{ 0x96CC,  0xC85F },
	{ 0x96CD,  0xCB96 },
	{ 0x96CE,  0x8336D030 },
	{ 0x96CF,  0x8336D031 },
	{ 0x96D0,  0x8336D032 },
	{ 0x96D1,  0xB67B },
	{ 0x96D2,  0x8336D034 },
	{ 0x96D3,  0x8336D035 },
	{ 0x96D4,  0x82349433 },
	{ 0x96D5,  0x8336D037 },
	{ 0x96D6,  0x8231E137 },
	{ 0x96D7,  0xE74C },
	{ 0x96D8,  0xE455 },
	{ 0x96D9,  0xE57D },
	{ 0x96DA,  0x8336D132 },
	{ 0x96DB,  0xEDDB },
	{ 0x96DC,  0xE370 },
	{ 0x96DD,  0xE85D },
	{ 0x96DE,  0x8264 },
	{ 0x96DF,  0x8139F533 },
	{ 0x96E0,  0xDF6A },
	{ 0x96E1,  0x8336D139 },
	{ 0x96E2,  0xB36C },
	{ 0x96E3,  0xB37B },
	{ 0x96E4,  0xB45C },
	{ 0x96E5,  0xB376 },
	{ 0x96E6,  0x8336D234 },
	{ 0x96E7,  0x8336D235 },
	{ 0x96E8,  0x8336D236 },
	{ 0x96E9,  0x8230B330 },
	{ 0x96EA,  0x81E2 },
	{ 0x96EB,  0x9DF6 },
	{ 0x96EC,  0x9DF5 },
	{ 0x96EE,  0x9E73 },
	{ 0x96EF,  0x85BD },
	{ 0x96F0,  0x8336D334 },
	{ 0x96F1,  0x88A2 },
	{ 0x96F2,  0xBFC7 },
	{ 0x96F3,  0x8884 },
	{ 0x96F4,  0xF873 },
	{ 0x96F5,  0x88B6 },
	{ 0x96F6,  0x9F7E },
	{ 0x96F7,  0x82308232 },
	{ 0x96F8,  0x8336D432 },
	{ 0x96F9,  0xA052 },
	{ 0x96FA,  0x8336D434 },
	{ 0x96FB,  0x8336D435 },
	{ 0x96FD,  0x8336D437 },
	{ 0x96FE,  0x8336D438 },
	{ 0x9740,  0x90D1 },
	{ 0x9741,  0x8B98 },
	{ 0x9742,  0x8ABE },
	{ 0x9743,  0x8232EC35 },
	{ 0x9744,  0x8336D533 },
	{ 0x9745,  0x8230C136 },
	{ 0x9746,  0x8234CE32 },
	{ 0x9747,  0x8336D536 },
	{ 0x9748,  0xE68F },
	{ 0x9749,  0xE68C },
	{ 0x974A,  0x8336D539 },
	{ 0x974B,  0x8336D630 },
	{ 0x974C,  0xC89B },
	{ 0x974D,  0x8336D632 },
	{ 0x974E,  0x8336D633 },
	{ 0x974F,  0x8336D634 },
	{ 0x9750,  0x8336D635 },
	{ 0x9751,  0x8336D636 },
	{ 0x9752,  0x8A73 },
	{ 0x9753,  0x8336D638 },
	{ 0x9754,  0x8336D639 },
	{ 0x9755,  0xBE4E },
	{ 0x9756,  0x8336D731 },
	{ 0x9757,  0x8336D732 },
	{ 0x9758,  0x8336D733 },
	{ 0x9759,  0x8336D734 },
	{ 0x975A,  0x8336D735 },
	{ 0x975B,  0xE47B },
	{ 0x975C,  0xAB90 },
	{ 0x975D,  0x82328A38 },
	{ 0x975E,  0xAD6C },
	{ 0x975F,  0x8336D830 },
	{ 0x9760,  0x8336D831 },
	{ 0x9761,  0x82328A30 },
	{ 0x9762,  0x8336D833 },
	{ 0x9763,  0x99AE },
	{ 0x9764,  0xAB9C },
	{ 0x9765,  0xAC43 },
	{ 0x9766,  0x82328839 },
	{ 0x9767,  0x8336D838 },
	{ 0x9768,  0x8336D839 },
	{ 0x9769,  0x8336D930 },
	{ 0x976A,  0x8336D931 },
	{ 0x976B,  0x8336D932 },
	{ 0x976C,  0x8336D933 },
	{ 0x976D,  0x8336D934 },
	{ 0x976E,  0xAC79 },
	{ 0x976F,  0x8336D936 },
	{ 0x9770,  0x9EDE },
	{ 0x9771,  0x8336D938 },
	{ 0x9772,  0xE37D },
	{ 0x9773,  0xAB93 },
	{ 0x9774,  0xE595 },
	{ 0x9775,  0x8336DA32 },
	{ 0x9776,  0xE567 },
	{ 0x9777,  0x8336DA34 },
	{ 0x9778,  0x8336DA35 },
	{ 0x9779,  0xE65A },
	{ 0x977A,  0x8336DA37 },
	{ 0x977B,  0x8336DA38 },
	{ 0x977C,  0x82349531 },
	{ 0x977D,  0x8336DB30 },
	{ 0x977E,  0x9FAB },
	{ 0x97A1,  0x8336DB32 },
	{ 0x97A2,  0x8336DB33 },
	{ 0x97A3,  0x87B1 },
	{ 0x97A4,  0x8336DB35 },
	{ 0x97A5,  0x8336DB36 },
	{ 0x97A6,  0x8336DB37 },
	{ 0x97A7,  0x8666 },
	{ 0x97A8,  0xB666 },
	{ 0x97A9,  0x8336DC30 },
	{ 0x97AA,  0xBF43 },
	{ 0x97AB,  0x8336DC32 },
	{ 0x97AC,  0x8336DC33 },
	{ 0x97AD,  0x8336DC34 },
	{ 0x97AE,  0x8233AC36 },
	{ 0x97AF,  0xE772 },
	{ 0x97B0,  0x8230BE32 },
	{ 0x97B1,  0x8336DC38 },
	{ 0x97B2,  0x8336DC39 },
	{ 0x97B3,  0x8A83 },
	{ 0x97B4,  0x8336DD31 },
	{ 0x97B5,  0x8336DD32 },
	{ 0x97B6,  0x8336DD33 },
	{ 0x97B7,  0x8B74 },
	{ 0x97B8,  0x8230BA32 },
	{ 0x97B9,  0x8336DD36 },
	{ 0x97BA,  0x8230B532 },
	{ 0x97BB,  0xE359 },
	{ 0x97BC,  0x8B51 },
	{ 0x97BD,  0x8336DE30 },
	{ 0x97BE,  0x8336DE31 },
	{ 0x97BF,  0xE648 },
	{ 0x97C0,  0x8231D239 },
	{ 0x97C1,  0x8336DE34 },
	{ 0x97C2,  0x8234B733 },
	{ 0x97C3,  0x8230FE30 },
	{ 0x97C4,  0x836E },
	{ 0x97C5,  0x8231E234 },
	{ 0x97C6,  0x8231DF35 },
	{ 0x97C7,  0x8336DF30 },
	{ 0x97C8,  0x9FB2 },
	{ 0x97C9,  0x8232F238 },
	{ 0x97CA,  0x8336DF33 },
	{ 0x97CB,  0x9C6A },
	{ 0x97CC,  0x8336DF35 },
	{ 0x97CD,  0x8233A539 },
	{ 0x97CE,  0x9BBD },
	{ 0x97CF,  0x8336DF38 },
	{ 0x97D0,  0x9EB7 },
	{ 0x97D1,  0x9B6A },
	{ 0x97D2,  0x8231D338 },
	{ 0x97D3,  0x8336E032 },
	{ 0x97D4,  0x8336E033 },
	{ 0x97D5,  0x9C62 },
	{ 0x97D6,  0x9D57 },
	{ 0x97D7,  0x8231E330 },
	{ 0x97D8,  0x8336E037 },
	{ 0x97D9,  0xAE78 },
	{ 0x97DA,  0x8230B634 },
	{ 0x97DB,  0x82308437 },
	{ 0x97DC,  0x8233CE32 },
	{ 0x97DD,  0x82328933 },
	{ 0x97DE,  0x82348135 },
	{ 0x97DF,  0x8A93 },
	{ 0x97E0,  0xE368 },
	{ 0x97E1,  0x82349630 },
	{ 0x97E2,  0xDD9D },
	{ 0x97E3,  0x8336E138 },
	{ 0x97E4,  0x8336E139 },
	{ 0x97E5,  0x88DC },
	{ 0x97E6,  0x88AD },
	{ 0x97E7,  0x8230B930 },
	{ 0x97E8,  0x8336E233 },
	{ 0x97E9,  0x9F55 },
	{ 0x97EA,  0x8336E235 },
	{ 0x97EB,  0x8336E236 },
	{ 0x97EC,  0x8336E237 },
	{ 0x97ED,  0x8336E238 },
	{ 0x97EE,  0x8336E239 },
	{ 0x97EF,  0x9780 },
	{ 0x97F0,  0x9844 },
	{ 0x97F1,  0x8336E332 },
	{ 0x97F2,  0x8336E333 },
	{ 0x97F3,  0x8336E334 },
	{ 0x97F4,  0x8336E335 },
	{ 0x97F5,  0x8336E336 },
	{ 0x97F6,  0x8336E337 },
	{ 0x97F7,  0x8336E338 },
	{ 0x97F8,  0x8336E339 },
	{ 0x97F9,  0x98CC },
	{ 0x97FA,  0x8336E431 },
	{ 0x97FB,  0x8336E432 },
	{ 0x97FC,  0xC874 },
	{ 0x97FD,  0x8233A437 },
	{ 0x97FE,  0x8233A331 },
	{ 0x9840,  0x8336E436 },
	{ 0x9841,  0x8336E437 },
	{ 0x9842,  0x8336E438 },
	{ 0x9843,  0x8336E439 },
	{ 0x9844,  0x9D5E },
	{ 0x9845,  0x8336E531 },
	{ 0x9846,  0xC6A0 },
	{ 0x9847,  0x8336E533 },
	{ 0x9848,  0xC7A0 },
	{ 0x9849,  0x8336E535 },
	{ 0x984A,  0x8336E536 },
	{ 0x984B,  0x8336E537 },
	{ 0x984C,  0x8A6C },
	{ 0x984D,  0x8B58 },
	{ 0x984E,  0x8336E630 },
	{ 0x984F,  0x8B40 },
	{ 0x9850,  0x8B4D },
	{ 0x9851,  0x8336E633 },
	{ 0x9852,  0x8336E634 },
	{ 0x9853,  0x8230C137 },
	{ 0x9854,  0x8AAD },
	{ 0x9855,  0x8336E637 },
	{ 0x9856,  0x8230B735 },
	{ 0x9857,  0x9FC6 },
	{ 0x9858,  0xE663 },
	{ 0x9859,  0x95AC },
	{ 0x985A,  0x8336E732 },
	{ 0x985B,  0x8B4A },
	{ 0x985C,  0x8AD4 },
	{ 0x985D,  0x8336E735 },
	{ 0x985E,  0x98D9 },
	{ 0x985F,  0x8336E737 },
	{ 0x9860,  0x8336E738 },
	{ 0x9861,  0x8336E739 },
	{ 0x9862,  0x8336E830 },
	{ 0x9863,  0x9F6B },
	{ 0x9864,  0x8336E832 },
	{ 0x9865,  0x8336E833 },
	{ 0x9866,  0x8243 },
	{ 0x9867,  0x8336E835 },
	{ 0x9868,  0x8D4D },
	{ 0x9869,  0x8336E837 },
	{ 0x986A,  0x8336E838 },
	{ 0x986B,  0x8336E839 },
	{ 0x986C,  0x98C0 },
	{ 0x986D,  0x8336E931 },
	{ 0x986E,  0x8336E932 },
	{ 0x986F,  0x9EDF },
	{ 0x9870,  0x9F7D },
	{ 0x9871,  0x8336E935 },
	{ 0x9872,  0x8231E834 },
	{ 0x9873,  0x9B84 },
	{ 0x9874,  0x8336E938 },
	{ 0x9875,  0x8336E939 },
	{ 0x9876,  0xC047 },
	{ 0x9877,  0x8AAA },
	{ 0x9878,  0x8D9F },
	{ 0x9879,  0x8231F032 },
	{ 0x987A,  0x8FA4 },
	{ 0x987B,  0x8336EA35 },
	{ 0x987C,  0x8336EA36 },
	{ 0x987D,  0xBE4B },
	{ 0x987E,  0xDDD3 },
	{ 0x98A1,  0x85F0 },
	{ 0x98A2,  0x8336EB30 },
	{ 0x98A3,  0x8336EB31 },
	{ 0x98A4,  0x8336EB32 },
	{ 0x98A5,  0x887C },
	{ 0x98A6,  0x8336EB34 },
	{ 0x98A7,  0x8336EB35 },
	{ 0x98A8,  0x8232A430 },
	{ 0x98A9,  0x8336EB37 },
	{ 0x98AA,  0x8336EB38 },
	{ 0x98AB,  0x9E5B },
	{ 0x98AC,  0x8336EC30 },
	{ 0x98AD,  0x8DD2 },
	{ 0x98AE,  0xAB57 },
	{ 0x98AF,  0xBC4D },
	{ 0x98B0,  0x8336EC34 },
	{ 0x98B1,  0x8336EC35 },
	{ 0x98B2,  0x8256 },
	{ 0x98B3,  0xC241 },
	{ 0x98B4,  0xE1F3 },
	{ 0x98B5,  0xAA5D },
	{ 0x98B6,  0x8336ED30 },
	{ 0x98B7,  0xE2AD },
	{ 0x98B8,  0xE2AA },
	{ 0x98B9,  0x8336ED33 },
	{ 0x98BA,  0xAA77 },
	{ 0x98BB,  0xAA7E },
	{ 0x98BC,  0x82328434 },
	{ 0x98BD,  0x8336ED37 },
	{ 0x98BE,  0xDF70 },
	{ 0x98BF,  0xA05B },
	{ 0x98C0,  0x8336EE30 },
	{ 0x98C1,  0xAB8F },
	{ 0x98C2,  0xC55B },
	{ 0x98C3,  0x82328737 },
	{ 0x98C4,  0xB168 },
	{ 0x98C5,  0x82328834 },
	{ 0x98C6,  0x9B67 },
	{ 0x98C7,  0xB9FA },
	{ 0x98C8,  0xAC5A },
	{ 0x98C9,  0xAC5D },
	{ 0x98CA,  0xAC5E },
	{ 0x98CB,  0x82328A31 },
	{ 0x98CC,  0x82328B35 },
	{ 0x98CD,  0x82328B39 },
	{ 0x98CE,  0x82328C35 },
	{ 0x98CF,  0xAD8A },
	{ 0x98D0,  0x82328E35 },
	{ 0x98D1,  0x82329534 },
	{ 0x98D2,  0xAE6F },
	{ 0x98D3,  0xAE8D },
	{ 0x98D4,  0xEEB4 },
	{ 0x98D5,  0xAF44 },
	{ 0x98D6,  0x82329935 },
	{ 0x98D7,  0xD3B8 },
	{ 0x98D8,  0xAF66 },
	{ 0x98D9,  0x8232A033 },
	{ 0x98DA,  0xF1AD },
	{ 0x98DB,  0x8232A236 },
	{ 0x98DC,  0xB066 },
	{ 0x98DD,  0x8232A331 },
	{ 0x98DE,  0xB06B },
	{ 0x98DF,  0x8336F131 },
	{ 0x98E0,  0x9FC1 },
	{ 0x98E1,  0xE0D4 },
	{ 0x98E2,  0xD282 },
	{ 0x98E3,  0x8963 },
	{ 0x98E4,  0x8232A936 },
	{ 0x98E5,  0xEDFC },
	{ 0x98E6,  0x8232AC34 },
	{ 0x98E7,  0xCCF5 },
	{ 0x98E8,  0x8232AD36 },
	{ 0x98E9,  0x8230A031 },
	{ 0x98EA,  0xB267 },
	{ 0x98EB,  0x8232B132 },
	{ 0x98EC,  0x8232B137 },
	{ 0x98ED,  0xCAF4 },
	{ 0x98EE,  0xB281 },
	{ 0x98EF,  0xB28D },
	{ 0x98F0,  0x89D3 },
	{ 0x98F1,  0xEDBB },
	{ 0x98F2,  0xB5E3 },
	{ 0x98F3,  0xEDBF },
	{ 0x98F4,  0x8232B734 },
	{ 0x98F5,  0xEDC1 },
	{ 0x98F6,  0xEDD0 },
	{ 0x98F7,  0xB379 },
	{ 0x98F8,  0xB38A },
	{ 0x98F9,  0xC87D },
	{ 0x98FA,  0x8336F338 },
	{ 0x98FB,  0xB563 },
	{ 0x98FC,  0x96D0 },
	{ 0x98FD,  0xB562 },
	{ 0x98FE,  0x8232C035 },
	{ 0x9940,  0x8232C131 },
	{ 0x9941,  0xB59F },
	{ 0x9942,  0xB646 },
	{ 0x9943,  0xDE79 },
	{ 0x9944,  0xEFF9 },
	{ 0x9945,  0xDE7A },
	{ 0x9946,  0x8232CA34 },
	{ 0x9947,  0xD2A4 },
	{ 0x9948,  0x8232D139 },
	{ 0x9949,  0xB853 },
	{ 0x994A,  0xDCB3 },
	{ 0x994B,  0x8232D337 },
	{ 0x994C,  0xB864 },
	{ 0x994D,  0xB86E },
	{ 0x994E,  0x8232D438 },
	{ 0x994F,  0x8149 },
	{ 0x9950,  0xF3E1 },
	{ 0x9951,  0xB966 },
	{ 0x9952,  0xF3E0 },
	{ 0x9953,  0xBA78 },
	{ 0x9954,  0xBA81 },
	{ 0x9955,  0x8232E333 },
	{ 0x9956,  0x8232E539 },
	{ 0x9957,  0xC0E0 },
	{ 0x9958,  0xF4D0 },
	{ 0x9959,  0x8232E737 },
	{ 0x995A,  0xBB9E },
	{ 0x995B,  0x8232E835 },
	{ 0x995C,  0xBC5F },
	{ 0x995D,  0xCAE4 },
	{ 0x995E,  0xECC3 },
	{ 0x995F,  0x8336F734 },
	{ 0x9960,  0xBE74 },
	{ 0x9961,  0xBE79 },
	{ 0x9962,  0xBE75 },
	{ 0x9963,  0xBF42 },
	{ 0x9964,  0xC17D },
	{ 0x9965,  0xC181 },
	{ 0x9966,  0xEAF1 },
	{ 0x9967,  0x82338433 },
	{ 0x9968,  0xF1EB },
	{ 0x9969,  0xF1ED },
	{ 0x996A,  0xB947 },
	{ 0x996B,  0xC267 },
	{ 0x996C,  0xF1F2 },
	{ 0x996D,  0xC1AA },
	{ 0x996E,  0x8231EC33 },
	{ 0x996F,  0xDBF1 },
	{ 0x9970,  0x9ED9 },
	{ 0x9971,  0xEBC9 },
	{ 0x9972,  0xEBCC },
	{ 0x9973,  0x82338C36 },
	{ 0x9974,  0xC380 },
	{ 0x9975,  0xD6ED },
	{ 0x9976,  0xEBDB },
	{ 0x9977,  0xEBDF },
	{ 0x9978,  0xAE83 },
	{ 0x9979,  0xD9F5 },
	{ 0x997A,  0x82338E36 },
	{ 0x997B,  0x8231AA37 },
	{ 0x997C,  0xC44C },
	{ 0x997D,  0xEBEA },
	{ 0x997E,  0xEBEB },
	{ 0x99A1,  0x82339034 },
	{ 0x99A2,  0x88FB },
	{ 0x99A3,  0xEBEF },
	{ 0x99A4,  0xC466 },
	{ 0x99A5,  0x82339232 },
	{ 0x99A6,  0xC471 },
	{ 0x99A7,  0x82339330 },
	{ 0x99A8,  0xC47E },
	{ 0x99A9,  0xDBFB },
	{ 0x99AA,  0xECA1 },
	{ 0x99AB,  0xC54F },
	{ 0x99AC,  0xC58F },
	{ 0x99AD,  0x82339C38 },
	{ 0x99AE,  0xC2AB },
	{ 0x99AF,  0xC646 },
	{ 0x99B0,  0xDCC3 },
	{ 0x99B1,  0xDCDC },
	{ 0x99B2,  0xC684 },
	{ 0x99B3,  0x8233A031 },
	{ 0x99B4,  0xC74F },
	{ 0x99B5,  0xCFD5 },
	{ 0x99B6,  0x9859 },
	{ 0x99B7,  0xC84E },
	{ 0x99B8,  0x9F4F },
	{ 0x99B9,  0xC892 },
	{ 0x99BA,  0x90BC },
	{ 0x99BB,  0xDDDC },
	{ 0x99BC,  0x8233A834 },
	{ 0x99BD,  0xC96F },
	{ 0x99BE,  0xC986 },
	{ 0x99BF,  0xC998 },
	{ 0x99C0,  0xCA4C },
	{ 0x99C1,  0xDDFA },
	{ 0x99C2,  0xCA7B },
	{ 0x99C3,  0x8233AD39 },
	{ 0x99C4,  0xCA94 },
	{ 0x99C5,  0xCA95 },
	{ 0x99C6,  0xCB8A },
	{ 0x99C7,  0x8233B339 },
	{ 0x99C8,  0xCD43 },
	{ 0x99C9,  0xCD55 },
	{ 0x99CA,  0xCD67 },
	{ 0x99CB,  0xCD8C },
	{ 0x99CC,  0xBCCA },
	{ 0x99CD,  0xF2F4 },
	{ 0x99CE,  0x8233C232 },
	{ 0x99CF,  0x8233C339 },
	{ 0x99D0,  0xD141 },
	{ 0x99D1,  0xD176 },
	{ 0x99D2,  0xD193 },
	{ 0x99D3,  0xD24D },
	{ 0x99D4,  0xD290 },
	{ 0x99D5,  0x83378138 },
	{ 0x99D6,  0xD44B },
	{ 0x99D7,  0xD45A },
	{ 0x99D8,  0xD550 },
	{ 0x99D9,  0xD570 },
	{ 0x99DA,  0xD854 },
	{ 0x99DB,  0xD966 },
	{ 0x99DC,  0xD985 },
	{ 0x99DD,  0xDA4E },
	{ 0x99DE,  0x8233E938 },
	{ 0x99DF,  0x895A },
	{ 0x99E0,  0xD4BE },
	{ 0x99E1,  0x8233F233 },
	{ 0x99E2,  0x81A2 },
	{ 0x99E3,  0xF5DD },
	{ 0x99E4,  0x86E6 },
	{ 0x99E5,  0x8868 },
	{ 0x99E6,  0xDBA0 },
	{ 0x99E7,  0xE0CC },
	{ 0x99E8,  0xDC6E },
	{ 0x99E9,  0x8233F937 },
	{ 0x99EA,  0xEAA6 },
	{ 0x99EB,  0xDC9E },
	{ 0x99EC,  0xDCA0 },
	{ 0x99ED,  0xDD48 },
	{ 0x99EE,  0xDD4D },
	{ 0x99EF,  0xDE76 },
	{ 0x99F0,  0xC7A8 },
	{ 0x99F1,  0xDE81 },
	{ 0x99F2,  0xDE83 },
	{ 0x99F3,  0xDF4E },
	{ 0x99F4,  0xF16A },
	{ 0x99F5,  0x82348735 },
	{ 0x99F6,  0xEF7A },
	{ 0x99F7,  0xE26D },
	{ 0x99F8,  0x82349238 },
	{ 0x99F9,  0xE283 },
	{ 0x99FA,  0xE352 },
	{ 0x99FB,  0xE365 },
	{ 0x99FC,  0xE448 },
	{ 0x99FD,  0xF6C7 },
	{ 0x99FE,  0xE456 },
	{ 0x9A40,  0xE479 },
	{ 0x9A41,  0xE482 },
	{ 0x9A42,  0xE48A },
	{ 0x9A43,  0xE48B },
	{ 0x9A44,  0xE494 },
	{ 0x9A45,  0xE578 },
	{ 0x9A46,  0xE658 },
	{ 0x9A47,  0xE681 },
	{ 0x9A48,  0x82349637 },
	{ 0x9A49,  0x82349738 },
	{ 0x9A4A,  0xFC4F },
	{ 0x9A4B,  0xE789 },
	{ 0x9A4C,  0x84F5 },
	{ 0x9A4D,  0xE78F },
	{ 0x9A4E,  0xE79F },
	{ 0x9A4F,  0xF6CD },
	{ 0x9A50,  0x82349A33 },
	{ 0x9A51,  0xE864 },
	{ 0x9A52,  0xE889 },
	{ 0x9A53,  0xB6A7 },
	{ 0x9A54,  0xE976 },
	{ 0x9A55,  0x82349F36 },
	{ 0x9A56,  0xBCE4 },
	{ 0x9A57,  0xD1F4 },
	{ 0x9A58,  0x8234A536 },
	{ 0x9A59,  0x9698 },
	{ 0x9A5A,  0x8234AB39 },
	{ 0x9A5B,  0xEC58 },
	{ 0x9A5C,  0x8234AD36 },
	{ 0x9A5D,  0xF7B8 },
	{ 0x9A5E,  0xED5D },
	{ 0x9A5F,  0xE0E2 },
	{ 0x9A60,  0x8234BF31 },
	{ 0x9A61,  0xB2D2 },
	{ 0x9A62,  0xEF5D },
	{ 0x9A63,  0x8234C434 },
	{ 0x9A64,  0xEF8A },
	{ 0x9A65,  0xDCA8 },
	{ 0x9A66,  0xF045 },
	{ 0x9A67,  0xF04F },
	{ 0x9A68,  0x83EA },
	{ 0x9A69,  0xF052 },
	{ 0x9A6A,  0xF06C },
	{ 0x9A6B,  0xF077 },
	{ 0x9A6C,  0xF091 },
	{ 0x9A6D,  0xF096 },
	{ 0x9A6E,  0x8234CD31 },
	{ 0x9A6F,  0xF16B },
	{ 0x9A70,  0x8234D136 },
	{ 0x9A71,  0xF283 },
	{ 0x9A72,  0xF7DD },
	{ 0x9A73,  0xC7D4 },
	{ 0x9A74,  0xF48E },
	{ 0x9A75,  0xF545 },
	{ 0x9A76,  0xF641 },
	{ 0x9A77,  0xF655 },
	{ 0x9A78,  0xF658 },
	{ 0x9A79,  0x8234E634 },
	{ 0x9A7A,  0xF685 },
	{ 0x9A7B,  0x8230C833 },
	{ 0x9A7C,  0x83378C30 },
	{ 0x9A7D,  0xF946 },
	{ 0x9A7E,  0xF69F },
	{ 0x9AA1,  0xF6BC },
	{ 0x9AA2,  0x8772 },
	{ 0x9AA3,  0xF991 },
	{ 0x9AA4,  0xFA5A },
	{ 0x9AA5,  0xFA5D },
	{ 0x9AA6,  0xFA9A },
	{ 0x9AA7,  0xD2F8 },
	{ 0x9AA8,  0xE5C1 },
	{ 0x9AA9,  0xFB7B },
	{ 0x9AAA,  0xFC41 },
	{ 0x9AAB,  0xFC46 },
	{ 0x9AAC,  0xF7E1 },
	{ 0x9AAD,  0xFC55 },
	{ 0x9AAE,  0xCDAD },
	{ 0x9AAF,  0xF7F1 },
	{ 0x9AB0,  0xFC6E },
	{ 0x9AB1,  0xFC75 },
	{ 0x9AB2,  0xB85E },
	{ 0x9AB3,  0xF7FE },
	{ 0x9AB4,  0x83378E32 },
	{ 0x9AB5,  0x83378E33 },
	{ 0x9AB6,  0x83378E34 },
	{ 0x9AB7,  0x97C8 },
	{ 0x9AB8,  0xC1E5 },
	{ 0x9AB9,  0x8A81 },
	{ 0x9ABA,  0x83378E38 },
	{ 0x9ABB,  0x8942 },
	{ 0x9ABC,  0xCCFA },
	{ 0x9ABD,  0x8230CF37 },
	{ 0x9ABE,  0x83378F32 },
	{ 0x9ABF,  0x83378F33 },
	{ 0x9AC0,  0x83378F34 },
	{ 0x9AC1,  0x83378F35 },
	{ 0x9AC2,  0xBFE9 },
	{ 0x9AC3,  0xECCE },
	{ 0x9AC4,  0x83378F38 },
	{ 0x9AC5,  0x83378F39 },
	{ 0x9AC6,  0x83379030 },
	{ 0x9AC7,  0x85E2 },
	{ 0x9AC8,  0x83379032 },
	{ 0x9AC9,  0x83379033 },
	{ 0x9ACA,  0x85FB },
	{ 0x9ACB,  0x83379035 },
	{ 0x9ACC,  0x83379036 },
	{ 0x9ACD,  0x83379037 },
	{ 0x9ACE,  0x83379038 },
	{ 0x9ACF,  0x83379039 },
	{ 0x9AD0,  0xBEE5 },
	{ 0x9AD1,  0x83379131 },
	{ 0x9AD2,  0x878F },
	{ 0x9AD3,  0x83379133 },
	{ 0x9AD4,  0x83379134 },
	{ 0x9AD5,  0x83379135 },
	{ 0x9AD6,  0x83379136 },
	{ 0x9AD7,  0x83379137 },
	{ 0x9AD8,  0x83379138 },
	{ 0x9AD9,  0x97F8 },
	{ 0x9ADA,  0xF694 },
	{ 0x9ADB,  0xCF40 },
	{ 0x9ADC,  0x83379232 },
	{ 0x9ADD,  0x83379233 },
	{ 0x9ADE,  0x83379234 },
	{ 0x9ADF,  0x83379235 },
	{ 0x9AE0,  0x83379236 },
	{ 0x9AE1,  0x83379237 },
	{ 0x9AE2,  0x8CB0 },
	{ 0x9AE3,  0x83379239 },
	{ 0x9AE4,  0x8E8E },
	{ 0x9AE5,  0x83379331 },
	{ 0x9AE6,  0x83379332 },
	{ 0x9AE7,  0x83379333 },
	{ 0x9AE8,  0x964F },
	{ 0x9AE9,  0x83379335 },
	{ 0x9AEA,  0x83379336 },
	{ 0x9AEB,  0x83379337 },
	{ 0x9AEC,  0x8230AA37 },
	{ 0x9AED,  0x83379339 },
	{ 0x9AEE,  0x83379430 },
	{ 0x9AEF,  0x83379431 },
	{ 0x9AF0,  0x83379432 },
	{ 0x9AF1,  0xC2B1 },
	{ 0x9AF2,  0xC965 },
	{ 0x9AF3,  0x83379435 },
	{ 0x9AF4,  0x83379436 },
	{ 0x9AF5,  0x83379437 },
	{ 0x9AF6,  0xD779 },
	{ 0x9AF7,  0x83379439 },
	{ 0x9AF8,  0x83379530 },
	{ 0x9AF9,  0x83379531 },
	{ 0x9AFA,  0x83379532 },
	{ 0x9AFB,  0x8170 },
	{ 0x9AFC,  0xECC2 },
	{ 0x9AFD,  0x83379535 },
	{ 0x9AFE,  0x83379536 },
	{ 0x9B40,  0x83379537 },
	{ 0x9B41,  0x83379538 },
	{ 0x9B42,  0x83379539 },
	{ 0x9B43,  0x83379630 },
	{ 0x9B44,  0x83379631 },
	{ 0x9B45,  0x83379632 },
	{ 0x9B46,  0x9280 },
	{ 0x9B47,  0x83379634 },
	{ 0x9B48,  0x83379635 },
	{ 0x9B49,  0xECD6 },
	{ 0x9B4A,  0xE8EA },
	{ 0x9B4B,  0x83379638 },
	{ 0x9B4C,  0x98A2 },
	{ 0x9B4D,  0x8230B736 },
	{ 0x9B4E,  0x83379731 },
	{ 0x9B4F,  0x83379732 },
	{ 0x9B50,  0x83379733 },
	{ 0x9B51,  0x83379734 },
	{ 0x9B52,  0x83379735 },
	{ 0x9B53,  0x83379736 },
	{ 0x9B54,  0xC682 },
	{ 0x9B55,  0x83379738 },
	{ 0x9B56,  0x83379739 },
	{ 0x9B57,  0x83379830 },
	{ 0x9B58,  0xD343 },
	{ 0x9B59,  0x83379832 },
	{ 0x9B5A,  0xDE66 },
	{ 0x9B5B,  0x83379834 },
	{ 0x9B5C,  0xED53 },
	{ 0x9B5D,  0x83379836 },
	{ 0x9B5E,  0xEE78 },
	{ 0x9B5F,  0xF368 },
	{ 0x9B60,  0x83379839 },
	{ 0x9B62,  0x83379931 },
	{ 0x9B63,  0x83379932 },
	{ 0x9B64,  0x83379933 },
	{ 0x9B65,  0x83379934 },
	{ 0x9B66,  0x83379935 },
	{ 0x9B67,  0x83379936 },
	{ 0x9B68,  0x83379937 },
	{ 0x9B69,  0x83379938 },
	{ 0x9B6A,  0x83379939 },
	{ 0x9B6B,  0x83379A30 },
	{ 0x9B6C,  0x83379A31 },
	{ 0x9B6D,  0x83379A32 },
	{ 0x9B6E,  0x83379A33 },
	{ 0x9B6F,  0x83379A34 },
	{ 0x9B70,  0x8FD2 },
	{ 0x9B71,  0x9577 },
	{ 0x9B72,  0x95CA },
	{ 0x9B73,  0x83379A38 },
	{ 0x9B74,  0x83379A39 },
	{ 0x9B75,  0x83379B30 },
	{ 0x9B77,  0x83379B32 },
	{ 0x9B79,  0x83379B34 },
	{ 0x9B7A,  0x83379B35 },
	{ 0x9B7C,  0x83379B37 },
	{ 0x9B7D,  0x89A0 },
	{ 0x9B7E,  0x9645 },
	{ 0x9BA1,  0x97C6 },
	{ 0x9BA2,  0x83379C31 },
	{ 0x9BA3,  0x83379C32 },
	{ 0x9BA4,  0x83379C33 },
	{ 0x9BA5,  0x83379C34 },
	{ 0x9BA6,  0x83379C35 },
	{ 0x9BA7,  0x83379C36 },
	{ 0x9BA8,  0x83379C37 },
	{ 0x9BA9,  0x82348B30 },
	{ 0x9BAA,  0x8234BA37 },
	{ 0x9BAB,  0x83379D30 },
	{ 0x9BAC,  0x83379D31 },
	{ 0x9BAD,  0x83379D32 },
	{ 0x9BAE,  0x83379D33 },
	{ 0x9BAF,  0x83379D34 },
	{ 0x9BB0,  0x83379D35 },
	{ 0x9BB1,  0x83379D36 },
	{ 0x9BB2,  0x83379D37 },
	{ 0x9BB3,  0x83379D38 },
	{ 0x9BB4,  0x83F9 },
	{ 0x9BB5,  0x83379E30 },
	{ 0x9BB6,  0x8A7A },
	{ 0x9BB7,  0x83379E32 },
	{ 0x9BB8,  0x8231B739 },
	{ 0x9BB9,  0x83379E34 },
	{ 0x9BBA,  0x83379E35 },
	{ 0x9BBB,  0x83379E36 },
	{ 0x9BBC,  0x8882 },
	{ 0x9BBD,  0x83379E38 },
	{ 0x9BBE,  0x82318137 },
	{ 0x9BBF,  0x83379F30 },
	{ 0x9BC0,  0x83379F31 },
	{ 0x9BC1,  0x83379F32 },
	{ 0x9BC2,  0x8230C730 },
	{ 0x9BC3,  0x83379F34 },
	{ 0x9BC4,  0xD758 },
	{ 0x9BC5,  0x83379F36 },
	{ 0x9BC7,  0x83379F38 },
	{ 0x9BC8,  0x83379F39 },
	{ 0x9BC9,  0x8337A030 },
	{ 0x9BCA,  0xA06D },
	{ 0x9BCB,  0x8337A032 },
	{ 0x9BCC,  0x8337A033 },
	{ 0x9BCD,  0xB0C2 },
	{ 0x9BCE,  0x8337A035 },
	{ 0x9BCF,  0x8337A036 },
	{ 0x9BD0,  0x8337A037 },
	{ 0x9BD1,  0xDC96 },
	{ 0x9BD2,  0x8337A039 },
	{ 0x9BD3,  0x84A8 },
	{ 0x9BD4,  0x885D },
	{ 0x9BD5,  0x9FB0 },
	{ 0x9BD6,  0x8337A133 },
	{ 0x9BD7,  0x8337A134 },
	{ 0x9BD8,  0x8337A135 },
	{ 0x9BD9,  0x8337A136 },
	{ 0x9BDA,  0x86D6 },
	{ 0x9BDB,  0x8337A138 },
	{ 0x9BDC,  0x8337A139 },
	{ 0x9BDD,  0x8337A230 },
	{ 0x9BDF,  0xFE55 },
	{ 0x9BE0,  0x8337A233 },
	{ 0x9BE1,  0x8337A234 },
	{ 0x9BE2,  0x8337A235 },
	{ 0x9BE3,  0x8233DD34 },
	{ 0x9BE4,  0x8337A237 },
	{ 0x9BE5,  0x8337A238 },
	{ 0x9BE6,  0x8337A239 },
	{ 0x9BE7,  0x8337A330 },
	{ 0x9BE8,  0x8337A331 },
	{ 0x9BE9,  0x82BB },
	{ 0x9BEA,  0x82308938 },
	{ 0x9BEB,  0x8337A334 },
	{ 0x9BED,  0x8337A336 },
	{ 0x9BEE,  0xFE82 },
	{ 0x9BEF,  0x8337A338 },
	{ 0x9BF0,  0x8337A339 },
	{ 0x9BF1,  0x8337A430 },
	{ 0x9BF2,  0x8337A431 },
	{ 0x9BF3,  0x8337A432 },
	{ 0x9BF4,  0xDBD2 },
	{ 0x9BF5,  0x9F97 },
	{ 0x9BF7,  0x8337A436 },
	{ 0x9BF8,  0x8337A437 },
	{ 0x9BF9,  0xDF61 },
	{ 0x9BFA,  0x8337A439 },
	{ 0x9BFB,  0x8337A530 },
	{ 0x9BFC,  0xD75C },
	{ 0x9BFD,  0x8337A532 },
	{ 0x9BFE,  0x8337A533 },
	{ 0x9C40,  0xE1CE },
	{ 0x9C41,  0x8337A535 },
	{ 0x9C43,  0x8337A537 },
	{ 0x9C44,  0x8337A538 },
	{ 0x9C45,  0xD646 },
	{ 0x9C46,  0x8337A630 },
	{ 0x9C47,  0x8337A631 },
	{ 0x9C48,  0x8337A632 },
	{ 0x9C49,  0x8337A633 },
	{ 0x9C4A,  0x8234D531 },
	{ 0x9C4B,  0x8337A635 },
	{ 0x9C4C,  0x8337A636 },
	{ 0x9C4D,  0x8337A637 },
	{ 0x9C4E,  0xE875 },
	{ 0x9C4F,  0x8337A639 },
	{ 0x9C50,  0x917E },
	{ 0x9C51,  0x8AD1 },
	{ 0x9C52,  0x8337A732 },
	{ 0x9C54,  0x87C4 },
	{ 0x9C55,  0x8337A735 },
	{ 0x9C56,  0x8337A736 },
	{ 0x9C57,  0x8165 },
	{ 0x9C58,  0x8337A738 },
	{ 0x9C59,  0xEA7D },
	{ 0x9C5A,  0x9BE0 },
	{ 0x9C5B,  0x8337A831 },
	{ 0x9C5C,  0x8230A631 },
	{ 0x9C5D,  0xD27A },
	{ 0x9C5E,  0x8337A834 },
	{ 0x9C5F,  0x8337A835 },
	{ 0x9C60,  0x8337A836 },
	{ 0x9C61,  0x8337A837 },
	{ 0x9C63,  0x8337A839 },
	{ 0x9C64,  0xB94D },
	{ 0x9C65,  0x8337A931 },
	{ 0x9C66,  0x8337A932 },
	{ 0x9C67,  0x8337A933 },
	{ 0x9C69,  0x8337A935 },
	{ 0x9C6A,  0xB75E },
	{ 0x9C6C,  0x8337A938 },
	{ 0x9C6D,  0xF26C },
	{ 0x9C6E,  0x8337AA30 },
	{ 0x9C6F,  0x8230AD31 },
	{ 0x9C70,  0x8337AA32 },
	{ 0x9C71,  0x8337AA33 },
	{ 0x9C72,  0xB595 },
	{ 0x9C73,  0x8337AA35 },
	{ 0x9C74,  0x8337AA36 },
	{ 0x9C75,  0x8D9E },
	{ 0x9C76,  0x8337AA38 },
	{ 0x9C78,  0x8337AB30 },
	{ 0x9C79,  0x8233D632 },
	{ 0x9C7A,  0x8337AB32 },
	{ 0x9C7B,  0xBBAD },
	{ 0x9C7C,  0xB2B9 },
	{ 0x9C7D,  0x8337AB35 },
	{ 0x9C7E,  0x89A1 },
	{ 0x9CA1,  0x8230C030 },
	{ 0x9CA2,  0x8337AB38 },
	{ 0x9CA3,  0x8337AB39 },
	{ 0x9CA4,  0x8337AC30 },
	{ 0x9CA5,  0x8231C639 },
	{ 0x9CA6,  0x8337AC32 },
	{ 0x9CA7,  0x8337AC33 },
	{ 0x9CA8,  0xE37A },
	{ 0x9CA9,  0x8337AC35 },
	{ 0x9CAA,  0x8337AC36 },
	{ 0x9CAB,  0xE566 },
	{ 0x9CAC,  0x8337AC38 },
	{ 0x9CAD,  0x8337AC39 },
	{ 0x9CAE,  0x9AEB },
	{ 0x9CAF,  0xD6D3 },
	{ 0x9CB0,  0x8337AD32 },
	{ 0x9CB1,  0x8337AD33 },
	{ 0x9CB2,  0xD043 },
	{ 0x9CB3,  0xD170 },
	{ 0x9CB4,  0x8337AD36 },
	{ 0x9CB5,  0x8337AD37 },
	{ 0x9CB6,  0x8337AD38 },
	{ 0x9CB7,  0x9CDF },
	{ 0x9CB8,  0x8337AE30 },
	{ 0x9CB9,  0x8337AE31 },
	{ 0x9CBA,  0x82318236 },
	{ 0x9CBB,  0x8230B631 },
	{ 0x9CBE,  0x8233AE33 },
	{ 0x9CBF,  0x95C3 },
	{ 0x9CC0,  0x8337AE38 },
	{ 0x9CC1,  0x8337AE39 },
	{ 0x9CC2,  0xD24A },
	{ 0x9CC3,  0x8337AF31 },
	{ 0x9CC4,  0x8337AF32 },
	{ 0x9CC5,  0x87DE },
	{ 0x9CC6,  0x8232BC39 },
	{ 0x9CC7,  0x8337AF35 },
	{ 0x9CC8,  0x82318233 },
	{ 0x9CC9,  0x8337AF37 },
	{ 0x9CCA,  0x8337AF38 },
	{ 0x9CCB,  0x8337AF39 },
	{ 0x9CCC,  0x9FDD },
	{ 0x9CCD,  0xDCFD },
	{ 0x9CCE,  0x8337B032 },
	{ 0x9CCF,  0x8337B033 },
	{ 0x9CD1,  0x8234ED32 },
	{ 0x9CD2,  0x8337B036 },
	{ 0x9CD3,  0x8337B037 },
	{ 0x9CD4,  0x8337B038 },
	{ 0x9CD5,  0x8337B039 },
	{ 0x9CD6,  0x8337B130 },
	{ 0x9CD7,  0x8337B131 },
	{ 0x9CD8,  0x8337B132 },
	{ 0x9CD9,  0xB94E },
	{ 0x9CDA,  0xB592 },
	{ 0x9CDB,  0x8337B135 },
	{ 0x9CDC,  0x9DD8 },
	{ 0x9CDD,  0x8337B137 },
	{ 0x9CDE,  0x98B8 },
	{ 0x9CDF,  0x8337B139 },
	{ 0x9CE0,  0xCFE1 },
	{ 0x9CE1,  0x8337B231 },
	{ 0x9CE2,  0xE693 },
	{ 0x9CE3,  0x96F0 },
	{ 0x9CE4,  0xEC70 },
	{ 0x9CE5,  0x8337B235 },
	{ 0x9CE6,  0x8337B236 },
	{ 0x9CE7,  0x8337B237 },
	{ 0x9CE8,  0x8337B238 },
	{ 0x9CE9,  0x8337B239 },
	{ 0x9CEA,  0x8337B330 },
	{ 0x9CEB,  0x8DE5 },
	{ 0x9CEC,  0x8337B332 },
	{ 0x9CED,  0x8337B333 },
	{ 0x9CEE,  0x8843 },
	{ 0x9CEF,  0xEE54 },
	{ 0x9CF0,  0x8337B336 },
	{ 0x9CF1,  0x8E4A },
	{ 0x9CF2,  0x8337B338 },
	{ 0x9CF3,  0x94E4 },
	{ 0x9CF4,  0x9891 },
	{ 0x9CF5,  0x85AA },
	{ 0x9CF6,  0x8337B432 },
	{ 0x9CF7,  0x8337B433 },
	{ 0x9CF8,  0x8231C032 },
	{ 0x9CF9,  0x965C },
	{ 0x9CFA,  0x8337B436 },
	{ 0x9CFB,  0x8337B437 },
	{ 0x9CFC,  0x8337B438 },
	{ 0x9CFD,  0x8337B439 },
	{ 0x9CFE,  0x8337B530 },
	{ 0x9D40,  0x8337B531 },
	{ 0x9D41,  0x8337B532 },
	{ 0x9D42,  0x8337B533 },
	{ 0x9D43,  0x8337B534 },
	{ 0x9D44,  0x8337B535 },
	{ 0x9D45,  0x8337B536 },
	{ 0x9D46,  0x82309E34 },
	{ 0x9D47,  0x8337B538 },
	{ 0x9D48,  0x8337B539 },
	{ 0x9D49,  0x82348F32 },
	{ 0x9D4A,  0x9358 },
	{ 0x9D4B,  0x8337B632 },
	{ 0x9D4C,  0xB353 },
	{ 0x9D4D,  0xE34F },
	{ 0x9D4E,  0x8337B635 },
	{ 0x9D4F,  0x82338D31 },
	{ 0x9D50,  0x8337B637 },
	{ 0x9D51,  0x82338B32 },
	{ 0x9D52,  0x8337B639 },
	{ 0x9D53,  0x8337B730 },
	{ 0x9D54,  0x8337B731 },
	{ 0x9D55,  0x8AB6 },
	{ 0x9D56,  0x8337B733 },
	{ 0x9D58,  0x8337B735 },
	{ 0x9D59,  0x8337B736 },
	{ 0x9D5B,  0x8337B738 },
	{ 0x9D5C,  0x8337B739 },
	{ 0x9D5D,  0x8231F036 },
	{ 0x9D5E,  0x8337B831 },
	{ 0x9D5F,  0x8337B832 },
	{ 0x9D60,  0xD4CB },
	{ 0x9D61,  0xEAFA },
	{ 0x9D62,  0x879C },
	{ 0x9D63,  0x8337B836 },
	{ 0x9D64,  0x8337B837 },
	{ 0x9D65,  0x8337B838 },
	{ 0x9D66,  0x8337B839 },
	{ 0x9D67,  0x8337B930 },
	{ 0x9D68,  0x8337B931 },
	{ 0x9D69,  0x8337B932 },
	{ 0x9D6A,  0x8337B933 },
	{ 0x9D6B,  0x8337B934 },
	{ 0x9D6C,  0x8337B935 },
	{ 0x9D6D,  0x8337B936 },
	{ 0x9D6E,  0x8337B937 },
	{ 0x9D6F,  0x8337B938 },
	{ 0x9D70,  0xE6F9 },
	{ 0x9D71,  0x8337BA30 },
	{ 0x9D72,  0x8337BA31 },
	{ 0x9D73,  0x8234EB33 },
	{ 0x9D74,  0xD5F2 },
	{ 0x9D75,  0x8337BA34 },
	{ 0x9D76,  0x9FD4 },
	{ 0x9D77,  0x8337BA36 },
	{ 0x9D78,  0x82358433 },
	{ 0x9D79,  0xB5DD },
	{ 0x9D7A,  0x8337BA39 },
	{ 0x9D7B,  0x82358534 },
	{ 0x9D7C,  0x8337BB31 },
	{ 0x9D7D,  0xB4EF },
	{ 0x9D7E,  0x86D9 },
	{ 0x9DA1,  0xDE78 },
	{ 0x9DA2,  0x8337BB35 },
	{ 0x9DA3,  0xB1DF },
	{ 0x9DA4,  0x8337BB37 },
	{ 0x9DA5,  0x8233A839 },
	{ 0x9DA6,  0xC061 },
	{ 0x9DA7,  0x9D8F },
	{ 0x9DA8,  0x9987 },
	{ 0x9DA9,  0xD2C7 },
	{ 0x9DAA,  0x82308735 },
	{ 0x9DAB,  0x8337BC34 },
	{ 0x9DAC,  0x8337BC35 },
	{ 0x9DAD,  0x8230C330 },
	{ 0x9DAE,  0xDC49 },
	{ 0x9DAF,  0x8337BC38 },
	{ 0x9DB0,  0x8337BC39 },
	{ 0x9DB1,  0x8337BD30 },
	{ 0x9DB2,  0x8337BD31 },
	{ 0x9DB3,  0x8337BD32 },
	{ 0x9DB4,  0x8337BD33 },
	{ 0x9DB5,  0x8231EF34 },
	{ 0x9DB6,  0x8337BD35 },
	{ 0x9DB7,  0x8337BD36 },
	{ 0x9DB8,  0x8337BD37 },
	{ 0x9DB9,  0x8337BD38 },
	{ 0x9DBA,  0xD1C7 },
	{ 0x9DBB,  0x8337BE30 },
	{ 0x9DBC,  0x8337BE31 },
	{ 0x9DBD,  0x87C9 },
	{ 0x9DBE,  0x8337BE33 },
	{ 0x9DBF,  0xDB5F },
	{ 0x9DC0,  0x8C50 },
	{ 0x9DC1,  0x8337BE36 },
	{ 0x9DC2,  0x8337BE37 },
	{ 0x9DC3,  0xDEEE },
	{ 0x9DC5,  0x8337BF30 },
	{ 0x9DC6,  0x8337BF31 },
	{ 0x9DC7,  0x948A },
	{ 0x9DC8,  0xE0D8 },
	{ 0x9DC9,  0x8337BF34 },
	{ 0x9DCA,  0x85C0 },
	{ 0x9DCB,  0x8337BF36 },
	{ 0x9DCC,  0x8231EB37 },
	{ 0x9DCD,  0x8337BF38 },
	{ 0x9DCE,  0x8234E739 },
	{ 0x9DCF,  0x8753 },
	{ 0x9DD0,  0xE0CF },
	{ 0x9DD1,  0xC098 },
	{ 0x9DD2,  0x8337C033 },
	{ 0x9DD3,  0x8A63 },
	{ 0x9DD4,  0x8337C035 },
	{ 0x9DD5,  0xF2F1 },
	{ 0x9DD6,  0xB6AB },
	{ 0x9DD7,  0x8337C038 },
	{ 0x9DD8,  0x8337C039 },
	{ 0x9DD9,  0x8337C130 },
	{ 0x9DDA,  0xC382 },
	{ 0x9DDB,  0xF95B },
	{ 0x9DDC,  0xDA4A },
	{ 0x9DDD,  0xAF9C },
	{ 0x9DDE,  0xF749 },
	{ 0x9DDF,  0xB047 },
	{ 0x9DE0,  0xB27D },
	{ 0x9DE1,  0xE57A },
	{ 0x9DE2,  0xDFC5 },
	{ 0x9DE3,  0xEBE6 },
	{ 0x9DE4,  0xDCD5 },
	{ 0x9DE5,  0x8754 },
	{ 0x9DE6,  0xEBE5 },
	{ 0x9DE7,  0xDDC1 },
	{ 0x9DE8,  0xEBC4 },
	{ 0x9DE9,  0xE0BA },
	{ 0x9DEA,  0xECF2 },
	{ 0x9DEB,  0x8768 },
	{ 0x9DEC,  0xDFB9 },
	{ 0x9DED,  0x8337C330 },
	{ 0x9DEE,  0x82309E38 },
	{ 0x9DEF,  0x86FE },
	{ 0x9DF0,  0x86F2 },
	{ 0x9DF1,  0x95F5 },
	{ 0x9DF2,  0x8337C335 },
	{ 0x9DF3,  0x8230A831 },
	{ 0x9DF4,  0xAE68 },
	{ 0x9DF5,  0x86F1 },
	{ 0x9DF6,  0x86D5 },
	{ 0x9DF7,  0x85F8 },
	{ 0x9DF8,  0x86AC },
	{ 0x9DF9,  0x8337C432 },
	{ 0x9DFA,  0x8337C433 },
	{ 0x9DFB,  0x8F48 },
	{ 0x9DFC,  0x8337C435 },
	{ 0x9DFD,  0x8337C436 },
	{ 0x9DFE,  0x8337C437 },
	{ 0x9E40,  0x8337C438 },
	{ 0x9E41,  0xFC40 },
	{ 0x9E42,  0xBD63 },
	{ 0x9E43,  0x86EA },
	{ 0x9E44,  0x8337C532 },
	{ 0x9E45,  0x926A },
	{ 0x9E46,  0xEC7A },
	{ 0x9E47,  0xDFC7 },
	{ 0x9E48,  0xD95F },
	{ 0x9E49,  0xA05C },
	{ 0x9E4A,  0xC3B8 },
	{ 0x9E4B,  0x9367 },
	{ 0x9E4C,  0x92FA },
	{ 0x9E4D,  0x9368 },
	{ 0x9E4E,  0x86A7 },
	{ 0x9E4F,  0x8337C633 },
	{ 0x9E50,  0xF776 },
	{ 0x9E51,  0x8337C635 },
	{ 0x9E52,  0x83DD },
	{ 0x9E53,  0x82308730 },
	{ 0x9E54,  0x8337C638 },
	{ 0x9E55,  0x83E4 },
	{ 0x9E56,  0x85D4 },
	{ 0x9E57,  0x867A },
	{ 0x9E58,  0x8671 },
	{ 0x9E59,  0xB05A },
	{ 0x9E5A,  0xDB74 },
	{ 0x9E5B,  0x8337C735 },
	{ 0x9E5C,  0xF0E5 },
	{ 0x9E5D,  0xC359 },
	{ 0x9E5E,  0xCF88 },
	{ 0x9E5F,  0xCE88 },
	{ 0x9E60,  0xD153 },
	{ 0x9E61,  0xC48C },
	{ 0x9E62,  0xDDC6 },
	{ 0x9E63,  0x8337C833 },
	{ 0x9E64,  0x8233A630 },
	{ 0x9E65,  0xAA53 },
	{ 0x9E66,  0x8337C836 },
	{ 0x9E67,  0x8C62 },
	{ 0x9E68,  0xC687 },
	{ 0x9E69,  0x8337C839 },
	{ 0x9E6A,  0xE0E7 },
	{ 0x9E6B,  0x8337C931 },
	{ 0x9E6C,  0x8337C932 },
	{ 0x9E6D,  0x8337C933 },
	{ 0x9E6E,  0x8337C934 },
	{ 0x9E6F,  0x8337C935 },
	{ 0x9E70,  0x8337C936 },
	{ 0x9E71,  0xF5A3 },
	{ 0x9E72,  0x8337C938 },
	{ 0x9E73,  0xE262 },
	{ 0x9E74,  0x8337CA30 },
	{ 0x9E75,  0x8337CA31 },
	{ 0x9E76,  0x8337CA32 },
	{ 0x9E77,  0x8337CA33 },
	{ 0x9E78,  0xEAF3 },
	{ 0x9E79,  0x8337CA35 },
	{ 0x9E7A,  0x8233E236 },
	{ 0x9E7B,  0x8337CA37 },
	{ 0x9E7C,  0x8337CA38 },
	{ 0x9E7D,  0x8337CA39 },
	{ 0x9E7E,  0x8232BF36 },
	{ 0x9EA1,  0xF761 },
	{ 0x9EA2,  0x947C },
	{ 0x9EA3,  0x8337CB33 },
	{ 0x9EA4,  0x82348E35 },
	{ 0x9EA5,  0x8337CB35 },
	{ 0x9EA6,  0x8337CB36 },
	{ 0x9EA7,  0x8337CB37 },
	{ 0x9EA8,  0x8337CB38 },
	{ 0x9EAA,  0x8337CC30 },
	{ 0x9EAB,  0x8337CC31 },
	{ 0x9EAD,  0x8337CC33 },
	{ 0x9EAE,  0x8337CC34 },
	{ 0x9EAF,  0x9FD5 },
	{ 0x9EB0,  0xC06F },
	{ 0x9EB1,  0xF94D },
	{ 0x9EB2,  0xD2B5 },
	{ 0x9EB3,  0x8141 },
	{ 0x9EB4,  0x82309632 },
	{ 0x9EB5,  0x8BCA },
	{ 0x9EB6,  0xE3F5 },
	{ 0x9EB7,  0xCED4 },
	{ 0x9EB8,  0x8230B438 },
	{ 0x9EB9,  0x82318830 },
	{ 0x9EBA,  0x8575 },
	{ 0x9EBB,  0x8230B431 },
	{ 0x9EBC,  0x8337CD38 },
	{ 0x9EBD,  0xDCAE },
	{ 0x9EBE,  0x8337CE30 },
	{ 0x9EBF,  0xF4B0 },
	{ 0x9EC0,  0xDFBB },
	{ 0x9EC1,  0x8897 },
	{ 0x9EC2,  0x8337CE34 },
	{ 0x9EC3,  0x8337CE35 },
	{ 0x9EC5,  0x82319337 },
	{ 0x9EC6,  0x8337CE38 },
	{ 0x9EC7,  0xAB42 },
	{ 0x9EC8,  0x8337CF30 },
	{ 0x9EC9,  0x8234F534 },
	{ 0x9ECA,  0xF651 },
	{ 0x9ECB,  0x8337CF33 },
	{ 0x9ECC,  0x8337CF34 },
	{ 0x9ECD,  0x8234E436 },
	{ 0x9ECE,  0x8337CF36 },
	{ 0x9ECF,  0x8337CF37 },
	{ 0x9ED0,  0x8337CF38 },
	{ 0x9ED1,  0xDDD6 },
	{ 0x9ED2,  0x8337D030 },
	{ 0x9ED3,  0x8337D031 },
	{ 0x9ED4,  0x8337D032 },
	{ 0x9ED5,  0x8337D033 },
	{ 0x9ED6,  0x92AB },
	{ 0x9ED7,  0xBC92 },
	{ 0x9ED8,  0x8337D036 },
	{ 0x9ED9,  0x8337D037 },
	{ 0x9EDA,  0x82318F37 },
	{ 0x9EDB,  0xDE9B },
	{ 0x9EDC,  0x84CC },
	{ 0x9EDD,  0x8231FD31 },
	{ 0x9EDE,  0x8230AF38 },
	{ 0x9EDF,  0x8233BF33 },
	{ 0x9EE0,  0x8337D134 },
	{ 0x9EE1,  0xF1A5 },
	{ 0x9EE2,  0x8BAF },
	{ 0x9EE3,  0x8337D137 },
	{ 0x9EE4,  0xB398 },
	{ 0x9EE5,  0x8233EC38 },
	{ 0x9EE6,  0x8994 },
	{ 0x9EE7,  0x8232B937 },
	{ 0x9EE8,  0xE0E8 },
	{ 0x9EE9,  0xF54F },
	{ 0x9EEA,  0xE1D5 },
	{ 0x9EEB,  0xF1AF },
	{ 0x9EEC,  0x8337D236 },
	{ 0x9EED,  0xFB83 },
	{ 0x9EEE,  0x8234F134 },
	{ 0x9EF0,  0x8230D633 },
	{ 0x9EF1,  0x90DA },
	{ 0x9EF2,  0x8337D332 },
	{ 0x9EF3,  0x8337D333 },
	{ 0x9EF5,  0x877A },
	{ 0x9EF6,  0x8337D336 },
	{ 0x9EF7,  0xDBF0 },
	{ 0x9EF8,  0x8337D338 },
	{ 0x9EF9,  0x8337D339 },
	{ 0x9EFA,  0x846D },
	{ 0x9EFB,  0x8337D431 },
	{ 0x9EFC,  0x82309B35 },
	{ 0x9EFE,  0xF979 },
	{ 0x9F40,  0xBB52 },
	{ 0x9F41,  0xF46B },
	{ 0x9F42,  0x88B9 },
	{ 0x9F43,  0x8337D438 },
	{ 0x9F44,  0x8CC8 },
	{ 0x9F45,  0x93F9 },
	{ 0x9F46,  0x8337D531 },
	{ 0x9F47,  0x8337D532 },
	{ 0x9F48,  0x8337D533 },
	{ 0x9F49,  0xCD65 },
	{ 0x9F4A,  0x8337D535 },
	{ 0x9F4B,  0x8337D536 },
	{ 0x9F4C,  0x8337D537 },
	{ 0x9F4D,  0x8337D538 },
	{ 0x9F4F,  0x8454 },
	{ 0x9F50,  0x8337D631 },
	{ 0x9F51,  0x8DEE },
	{ 0x9F52,  0xEB8F },
	{ 0x9F53,  0x8337D634 },
	{ 0x9F54,  0xFB80 },
	{ 0x9F55,  0xDF5D },
	{ 0x9F56,  0xB89A },
	{ 0x9F57,  0xF39D },
	{ 0x9F58,  0x8D5A },
	{ 0x9F59,  0xB98B },
	{ 0x9F5A,  0x9250 },
	{ 0x9F5B,  0x92B0 },
	{ 0x9F5C,  0xF39A },
	{ 0x9F5D,  0xBA47 },
	{ 0x9F5E,  0xF45E },
	{ 0x9F5F,  0xBB75 },
	{ 0x9F61,  0xBAA0 },
	{ 0x9F62,  0xBB7D },
	{ 0x9F63,  0xF679 },
	{ 0x9F64,  0xF3FB },
	{ 0x9F65,  0xF441 },
	{ 0x9F67,  0xF680 },
	{ 0x9F68,  0x8337D835 },
	{ 0x9F69,  0xFD60 },
	{ 0x9F6A,  0x86AD },
	{ 0x9F6B,  0x8C77 },
	{ 0x9F6C,  0x8272 },
	{ 0x9F6D,  0xFB91 },
	{ 0x9F6E,  0x826A },
	{ 0x9F6F,  0x8485 },
	{ 0x9F70,  0x8231F231 },
	{ 0x9F71,  0x84D0 },
	{ 0x9F72,  0x8870 },
	{ 0x9F73,  0x82AE },
	{ 0x9F74,  0x8A89 },
	{ 0x9F75,  0x8E91 },
	{ 0x9F76,  0xED63 },
	{ 0x9F77,  0xFA48 },
	{ 0x9F78,  0xDE57 },
	{ 0x9F79,  0x85E1 },
	{ 0x9F7A,  0xF7B9 },
	{ 0x9F7B,  0xF075 },
	{ 0x9F7C,  0xED55 },
	{ 0x9F7D,  0x8550 },
	{ 0x9F7E,  0x90E9 },
	{ 0x9FA1,  0x97D7 },
	{ 0x9FA2,  0x85AD },
	{ 0x9FA3,  0xF66E },
	{ 0x9FA4,  0xF85F },
	{ 0x9FA5,  0x8234E134 },
	{ 0x9FA6,  0xEA75 },
	{ 0x9FA7,  0xE9AF },
	{ 0x9FA8,  0x82EF },
	{ 0x9FA9,  0xAE72 },
	{ 0x9FAA,  0x8337DB37 },
	{ 0x9FAB,  0xF181 },
	{ 0x9FAC,  0x8491 },
	{ 0x9FAE,  0xE149 },
	{ 0x9FAF,  0xEA9A },
	{ 0x9FB0,  0xE14B },
	{ 0x9FB2,  0xE143 },
	{ 0x9FB3,  0x8337DC36 },
	{ 0x9FB4,  0x92DD },
	{ 0x9FB5,  0x8337DC38 },
	{ 0x9FB6,  0x99A0 },
	{ 0x9FB7,  0x8746 },
	{ 0x9FB8,  0xE15F },
	{ 0x9FB9,  0xAE96 },
	{ 0x9FBA,  0x925D },
	{ 0x9FBB,  0x8337DD34 },
	{ 0x9FBC,  0xAA85 },
	{ 0x9FBD,  0xBB6C },
	{ 0x9FBE,  0x8337DD37 },
	{ 0x9FBF,  0x8337DD38 },
	{ 0x9FC1,  0x8337DE30 },
	{ 0x9FC2,  0xB8C7 },
	{ 0x9FC3,  0xF561 },
	{ 0x9FC4,  0xB8F6 },
	{ 0x9FC5,  0x8337DE34 },
	{ 0x9FC6,  0xC783 },
	{ 0x9FC7,  0xD05A },
	{ 0x9FC9,  0xBDEC },
	{ 0x9FCA,  0x9882 },
	{ 0x9FCC,  0x887A },
	{ 0x9FCD,  0x8461 },
	{ 0x9FCE,  0x8E81 },
	{ 0x9FCF,  0xB4D3 },
	{ 0x9FD0,  0x9AE7 },
	{ 0x9FD1,  0x8337DF36 },
	{ 0x9FD2,  0x81C7 },
	{ 0x9FD3,  0x85FA },
	{ 0x9FD4,  0xDFE1 },
	{ 0x9FD5,  0x84B1 },
	{ 0x9FD6,  0xDA66 },
	{ 0x9FD7,  0x8230A336 },
	{ 0x9FD9,  0x8230A235 },
	{ 0x9FDB,  0x9A59 },
	{ 0x9FDC,  0xE156 },
	{ 0x9FDD,  0xFD9B },
	{ 0x9FDE,  0xF55B },
	{ 0x9FDF,  0xEE5F },
	{ 0x9FE0,  0xEF58 },
	{ 0x9FE1,  0xF7BF },
	{ 0x9FE2,  0xFB9E },
	{ 0x9FE3,  0xFB82 },
	{ 0x9FE4,  0xECD5 },
	{ 0x9FE5,  0xB1CA },
	{ 0x9FE7,  0x9ACC },
	{ 0x9FE8,  0xCF98 },
	{ 0x9FE9,  0xC155 },
	{ 0x9FEB,  0x8751 },
	{ 0x9FEC,  0x8337E233 },
	{ 0x9FED,  0xDC42 },
	{ 0x9FEE,  0xFD59 },
	{ 0x9FF0,  0xDAA0 },
	{ 0x9FF1,  0xDB87 },
	{ 0x9FF2,  0xFB59 },
	{ 0x9FF3,  0xDB56 },
	{ 0x9FF4,  0x925B },
	{ 0x9FF5,  0x8337E332 },
	{ 0x9FF6,  0xDB72 },
	{ 0x9FF7,  0xDC41 },
	{ 0x9FF8,  0xB868 },
	{ 0x9FF9,  0x8337E336 },
	{ 0x9FFA,  0xB758 },
	{ 0x9FFB,  0xB474 },
	{ 0x9FFC,  0xC0E1 },
	{ 0x9FFD,  0xD488 },
	{ 0x9FFE,  0xAF7E },
	{ 0xA040,  0x8337E432 },
	{ 0xA041,  0xFC97 },
	{ 0xA042,  0x9B7A },
	{ 0xA043,  0xCF61 },
	{ 0xA044,  0xF0E7 },
	{ 0xA045,  0x8337E437 },
	{ 0xA046,  0xB37A },
	{ 0xA047,  0x8337E439 },
	{ 0xA048,  0xD99F },
	{ 0xA049,  0xAA43 },
	{ 0xA04A,  0xAAA0 },
	{ 0xA04B,  0xD688 },
	{ 0xA04C,  0xAA52 },
	{ 0xA04D,  0xAD9F },
	{ 0xA04E,  0xD97D },
	{ 0xA04F,  0x8337E537 },
	{ 0xA050,  0xCC6F },
	{ 0xA051,  0x8FD9 },
	{ 0xA052,  0xD098 },
	{ 0xA053,  0x8233A038 },
	{ 0xA055,  0x8337E633 },
	{ 0xA056,  0x8337E634 },
	{ 0xA058,  0xD49E },
	{ 0xA059,  0x8337E637 },
	{ 0xA05B,  0x90C7 },
	{ 0xA05C,  0xB05B },
	{ 0xA05D,  0xF37A },
	{ 0xA05E,  0xF941 },
	{ 0xA05F,  0xE642 },
	{ 0xA060,  0xF553 },
	{ 0xA061,  0xCF7B },
	{ 0xA064,  0xD98A },
	{ 0xA065,  0xE2AC },
	{ 0xA066,  0xEC40 },
	{ 0xA067,  0xF574 },
	{ 0xA068,  0x82309F36 },
	{ 0xA069,  0xA0E5 },
	{ 0xA06A,  0x8234DC32 },
	{ 0xA06B,  0xBB4D },
	{ 0xA06C,  0xF080 },
	{ 0xA06D,  0x8337E837 },
	{ 0xA06E,  0x914C },
	{ 0xA06F,  0x8234DB39 },
	{ 0xA070,  0xFB8F },
	{ 0xA071,  0x9169 },
	{ 0xA073,  0xB7D8 },
	{ 0xA074,  0x915E },
	{ 0xA075,  0x926D },
	{ 0xA076,  0x91F6 },
	{ 0xA078,  0x82319437 },
	{ 0xA079,  0x91BE },
	{ 0xA07A,  0x858F },
	{ 0xA07B,  0x8337EA31 },
	{ 0xA07C,  0x92CB },
	{ 0xA07D,  0x96CF },
	{ 0xA07E,  0x82309F32 },
	{ 0xA0A1,  0x8DC0 },
	{ 0xA0A2,  0x8337EA36 },
	{ 0xA0A3,  0xDE89 },
	{ 0xA0A4,  0x8337EA38 },
	{ 0xA0A6,  0x835A },
	{ 0xA0A7,  0x8337EB31 },
	{ 0xA0A8,  0xB49A },
	{ 0xA0A9,  0x8555 },
	{ 0xA0AA,  0xEA71 },
	{ 0xA0AB,  0x8337EB35 },
	{ 0xA0AC,  0x8232B037 },
	{ 0xA0AE,  0xB7AF },
	{ 0xA0B0,  0xBC42 },
	{ 0xA0B1,  0x8337EC31 },
	{ 0xA0B2,  0xBC50 },
	{ 0xA0B3,  0xB74D },
	{ 0xA0B4,  0xC28C },
	{ 0xA0B5,  0xC289 },
	{ 0xA0B6,  0xBD56 },
	{ 0xA0B7,  0xAE4D },
	{ 0xA0B8,  0xADA0 },
	{ 0xA0B9,  0xD293 },
	{ 0xA0BA,  0xC571 },
	{ 0xA0BB,  0x9644 },
	{ 0xA0BC,  0xC288 },
	{ 0xA0BD,  0x8337ED33 },
	{ 0xA0BE,  0xC281 },
	{ 0xA0BF,  0xAD9E },
	{ 0xA0C0,  0xC379 },
	{ 0xA0C1,  0xB17A },
	{ 0xA0C2,  0xD288 },
	{ 0xA0C3,  0x8337ED39 },
	{ 0xA0C4,  0xAE7A },
	{ 0xA0C5,  0x8337EE31 },
	{ 0xA0C6,  0xCF43 },
	{ 0xA0C7,  0xCF5C },
	{ 0xA0C8,  0xC497 },
	{ 0xA0C9,  0xCE8C },
	{ 0xA0CA,  0xD469 },
	{ 0xA0CB,  0xD8A0 },
	{ 0xA0CC,  0xD69E },
	{ 0xA0CD,  0xB17E },
	{ 0xA0CE,  0xAE42 },
	{ 0xA0CF,  0xC982 },
	{ 0xA0D0,  0x8230A839 },
	{ 0xA0D1,  0x9876 },
	{ 0xA0D2,  0xDA83 },
	{ 0xA0D4,  0xD347 },
	{ 0xA0D6,  0x9BF3 },
	{ 0xA0D7,  0xCF52 },
	{ 0xA0D8,  0x8337F030 },
	{ 0xA0D9,  0xAD97 },
	{ 0xA0DA,  0x8231ED38 },
	{ 0xA0DB,  0x9FB3 },
	{ 0xA0DC,  0x9095 },
	{ 0xA0DD,  0x9186 },
	{ 0xA0DE,  0x8231D333 },
	{ 0xA0E0,  0x907C },
	{ 0xA0E2,  0xEEBD },
	{ 0xA0E3,  0x8337F131 },
	{ 0xA0E5,  0xB3CD },
	{ 0xA0E6,  0x8234CE35 },
	{ 0xA0E7,  0xC9BE },
	{ 0xA0E8,  0x8337F136 },
	{ 0xA0E9,  0x8337F137 },
	{ 0xA0EA,  0x8337F138 },
	{ 0xA0EB,  0x8337F139 },
	{ 0xA0EC,  0x8337F230 },
	{ 0xA0ED,  0x8337F231 },
	{ 0xA0EE,  0x8337F232 },
	{ 0xA0EF,  0x8337F233 },
	{ 0xA0F0,  0x8337F234 },
	{ 0xA0F1,  0x8337F235 },
	{ 0xA0F2,  0xE1B9 },
	{ 0xA0F3,  0x8337F237 },
	{ 0xA0F4,  0x8337F238 },
	{ 0xA0F5,  0x8337F239 },
	{ 0xA0F6,  0x8337F330 },
	{ 0xA0F7,  0x8337F331 },
	{ 0xA0F8,  0x8337F332 },
	{ 0xA0F9,  0x8233B138 },
	{ 0xA0FA,  0x8BDA },
	{ 0xA0FB,  0x8337F335 },
	{ 0xA0FC,  0xC6EB },
	{ 0xA0FD,  0xC2F3 },
	{ 0xA0FE,  0x8337F338 },
	{ 0xA140,  0xA1A1 },
	{ 0xA141,  0xA3AC },
	{ 0xA142,  0xA1A2 },
	{ 0xA143,  0xA1A3 },
	{ 0xA144,  0xA3AE },
	{ 0xA145,  0x8136A631 },
	{ 0xA146,  0xA3BB },
	{ 0xA147,  0xA3BA },
	{ 0xA148,  0xA3BF },
	{ 0xA149,  0xA3A1 },
	{ 0xA14A,  0xA955 },
	{ 0xA14B,  0xA1AD },
	{ 0xA14C,  0xA845 },
	{ 0xA14D,  0xA96F },
	{ 0xA14E,  0x84319630 },
	{ 0xA14F,  0xA971 },
	{ 0xA150,  0xA1A4 },
	{ 0xA151,  0xA972 },
	{ 0xA152,  0xA973 },
	{ 0xA153,  0xA974 },
	{ 0xA154,  0xA975 },
	{ 0xA155,  0xA3FC },
	{ 0xA156,  0xA843 },
	{ 0xA157,  0xA6F2 },
	{ 0xA158,  0xA1AA },
	{ 0xA159,  0xA6F4 },
	{ 0xA15A,  0x8431A437 },
	{ 0xA15B,  0xA6F5 },
	{ 0xA15C,  0xA96E },
	{ 0xA15D,  0xA3A8 },
	{ 0xA15E,  0xA3A9 },
	{ 0xA15F,  0xA6E0 },
	{ 0xA160,  0xA6E1 },
	{ 0xA161,  0xA3FB },
	{ 0xA162,  0xA3FD },
	{ 0xA163,  0xA6F0 },
	{ 0xA164,  0xA6F1 },
	{ 0xA165,  0xA1B2 },
	{ 0xA166,  0xA1B3 },
	{ 0xA167,  0xA6E2 },
	{ 0xA168,  0xA6E3 },
	{ 0xA169,  0xA1BE },
	{ 0xA16A,  0xA1BF },
	{ 0xA16B,  0xA6EE },
	{ 0xA16C,  0xA6EF },
	{ 0xA16D,  0xA1B6 },
	{ 0xA16E,  0xA1B7 },
	{ 0xA16F,  0xA6E6 },
	{ 0xA170,  0xA6E7 },
	{ 0xA171,  0xA1B4 },
	{ 0xA172,  0xA1B5 },
	{ 0xA173,  0xA6E4 },
	{ 0xA174,  0xA6E5 },
	{ 0xA175,  0xA1B8 },
	{ 0xA176,  0xA1B9 },
	{ 0xA177,  0xA6E8 },
	{ 0xA178,  0xA6E9 },
	{ 0xA179,  0xA1BA },
	{ 0xA17A,  0xA1BB },
	{ 0xA17B,  0xA6EA },
	{ 0xA17C,  0xA6EB },
	{ 0xA17D,  0xA976 },
	{ 0xA17E,  0xA977 },
	{ 0xA1A1,  0xA978 },
	{ 0xA1A2,  0xA979 },
	{ 0xA1A3,  0xA97A },
	{ 0xA1A4,  0xA97B },
	{ 0xA1A5,  0xA1AE },
	{ 0xA1A6,  0xA1AF },
	{ 0xA1A7,  0xA1B0 },
	{ 0xA1A8,  0xA1B1 },
	{ 0xA1A9,  0xA894 },
	{ 0xA1AA,  0xA895 },
	{ 0xA1AB,  0xA846 },
	{ 0xA1AC,  0xA1E4 },
	{ 0xA1AD,  0xA3A3 },
	{ 0xA1AE,  0xA3A6 },
	{ 0xA1AF,  0xA3AA },
	{ 0xA1B0,  0xA1F9 },
	{ 0xA1B1,  0xA1EC },
	{ 0xA1B2,  0xA1A8 },
	{ 0xA1B3,  0xA1F0 },
	{ 0xA1B4,  0xA1F1 },
	{ 0xA1B5,  0xA1F7 },
	{ 0xA1B6,  0xA1F8 },
	{ 0xA1B7,  0xA1F2 },
	{ 0xA1B8,  0xA1EE },
	{ 0xA1B9,  0xA1EF },
	{ 0xA1BA,  0xA1F3 },
	{ 0xA1BB,  0xA1F4 },
	{ 0xA1BC,  0xA1F5 },
	{ 0xA1BD,  0xA1F6 },
	{ 0xA1BE,  0xA88C },
	{ 0xA1BF,  0xA88B },
	{ 0xA1C0,  0xA949 },
	{ 0xA1C1,  0xA847 },
	{ 0xA1C2,  0x8136A832 },
	{ 0xA1C3,  0x8431A437 },
	{ 0xA1C4,  0xA3DF },
	{ 0xA1C5,  0x8431A437 },
	{ 0xA1C6,  0xA968 },
	{ 0xA1C7,  0xA969 },
	{ 0xA1C8,  0xA96C },
	{ 0xA1C9,  0xA96D },
	{ 0xA1CA,  0xA96A },
	{ 0xA1CB,  0xA96B },
	{ 0xA1CC,  0xA97C },
	{ 0xA1CD,  0xA97D },
	{ 0xA1CE,  0xA97E },
	{ 0xA1CF,  0xA3AB },
	{ 0xA1D0,  0xA3AD },
	{ 0xA1D1,  0xA1C1 },
	{ 0xA1D2,  0xA1C2 },
	{ 0xA1D3,  0xA1C0 },
	{ 0xA1D4,  0xA1CC },
	{ 0xA1D5,  0xA3BC },
	{ 0xA1D6,  0xA3BE },
	{ 0xA1D7,  0xA3BD },
	{ 0xA1D8,  0xA851 },
	{ 0xA1D9,  0xA852 },
	{ 0xA1DA,  0xA1D9 },
	{ 0xA1DB,  0xA1DE },
	{ 0xA1DC,  0xA850 },
	{ 0xA1DD,  0xA1D4 },
	{ 0xA1DE,  0xA980 },
	{ 0xA1DF,  0xA981 },
	{ 0xA1E0,  0xA982 },
	{ 0xA1E1,  0xA983 },
	{ 0xA1E2,  0xA984 },
	{ 0xA1E3,  0x8136D535 },
	{ 0xA1E4,  0xA1C9 },
	{ 0xA1E5,  0xA1C8 },
	{ 0xA1E6,  0xA1CD },
	{ 0xA1E7,  0xA1CF },
	{ 0xA1E8,  0xA84E },
	{ 0xA1E9,  0xA853 },
	{ 0xA1EA,  0xA953 },
	{ 0xA1EB,  0xA952 },
	{ 0xA1EC,  0xA1D2 },
	{ 0xA1ED,  0xA1D3 },
	{ 0xA1EE,  0xA1DF },
	{ 0xA1EF,  0xA1E0 },
	{ 0xA1F0,  0xA1E2 },
	{ 0xA1F1,  0xA1E1 },
	{ 0xA1F2,  0x8137A838 },
	{ 0xA1F3,  0xA891 },
	{ 0xA1F4,  0xA1FC },
	{ 0xA1F5,  0xA1FD },
	{ 0xA1F6,  0xA1FB },
	{ 0xA1F7,  0xA1FA },
	{ 0xA1F8,  0xA849 },
	{ 0xA1F9,  0xA84A },
	{ 0xA1FA,  0xA84C },
	{ 0xA1FB,  0xA84B },
	{ 0xA1FC,  0xA1CE },
	{ 0xA1FD,  0xA84F },
	{ 0xA1FE,  0x8431A437 },
	{ 0xA240,  0x8431A437 },
	{ 0xA241,  0xA3AF },
	{ 0xA242,  0xA3DC },
	{ 0xA243,  0xA1E7 },
	{ 0xA244,  0x81308436 },
	{ 0xA245,  0xA893 },
	{ 0xA246,  0x81308434 },
	{ 0xA247,  0x81308435 },
	{ 0xA248,  0xA3A5 },
	{ 0xA249,  0xA3C0 },
	{ 0xA24A,  0xA1E6 },
	{ 0xA24B,  0xA848 },
	{ 0xA24C,  0xA986 },
	{ 0xA24D,  0xA987 },
	{ 0xA24E,  0xA988 },
	{ 0xA24F,  0xA954 },
	{ 0xA250,  0xA94C },
	{ 0xA251,  0xA94D },
	{ 0xA252,  0xA94E },
	{ 0xA253,  0xA951 },
	{ 0xA254,  0xA94F },
	{ 0xA255,  0xA94A },
	{ 0xA256,  0xA94B },
	{ 0xA257,  0xA950 },
	{ 0xA258,  0xA1E3 },
	{ 0xA259,  0x83BE },
	{ 0xA25A,  0x83BF },
	{ 0xA25B,  0x83C1 },
	{ 0xA25C,  0x83C0 },
	{ 0xA25D,  0x83C4 },
	{ 0xA25E,  0x83C5 },
	{ 0xA25F,  0x86ED },
	{ 0xA260,  0xAD99 },
	{ 0xA261,  0xBC48 },
	{ 0xA262,  0xA878 },
	{ 0xA263,  0xA879 },
	{ 0xA264,  0xA87A },
	{ 0xA265,  0xA87B },
	{ 0xA266,  0xA87C },
	{ 0xA267,  0xA87D },
	{ 0xA268,  0xA87E },
	{ 0xA269,  0xA880 },
	{ 0xA26A,  0xA887 },
	{ 0xA26B,  0xA886 },
	{ 0xA26C,  0xA885 },
	{ 0xA26D,  0xA884 },
	{ 0xA26E,  0xA883 },
	{ 0xA26F,  0xA882 },
	{ 0xA270,  0xA881 },
	{ 0xA271,  0xA9E0 },
	{ 0xA272,  0xA9D8 },
	{ 0xA273,  0xA9D0 },
	{ 0xA274,  0xA9C8 },
	{ 0xA275,  0xA9C0 },
	{ 0xA276,  0xA889 },
	{ 0xA277,  0xA9A4 },
	{ 0xA278,  0xA9A6 },
	{ 0xA279,  0xA88A },
	{ 0xA27A,  0xA9B0 },
	{ 0xA27B,  0xA9B4 },
	{ 0xA27C,  0xA9B8 },
	{ 0xA27D,  0xA9BC },
	{ 0xA27E,  0xA871 },
	{ 0xA2A1,  0xA872 },
	{ 0xA2A2,  0xA874 },
	{ 0xA2A3,  0xA873 },
	{ 0xA2A4,  0xA854 },
	{ 0xA2A5,  0xA862 },
	{ 0xA2A6,  0xA86E },
	{ 0xA2A7,  0xA865 },
	{ 0xA2A8,  0xA88D },
	{ 0xA2A9,  0xA88E },
	{ 0xA2AA,  0xA890 },
	{ 0xA2AB,  0xA88F },
	{ 0xA2AC,  0xA875 },
	{ 0xA2AD,  0xA876 },
	{ 0xA2AE,  0xA877 },
	{ 0xA2AF,  0xA3B0 },
	{ 0xA2B0,  0xA3B1 },
	{ 0xA2B1,  0xA3B2 },
	{ 0xA2B2,  0xA3B3 },
	{ 0xA2B3,  0xA3B4 },
	{ 0xA2B4,  0xA3B5 },
	{ 0xA2B5,  0xA3B6 },
	{ 0xA2B6,  0xA3B7 },
	{ 0xA2B7,  0xA3B8 },
	{ 0xA2B8,  0xA3B9 },
	{ 0xA2B9,  0xA2F1 },
	{ 0xA2BA,  0xA2F2 },
	{ 0xA2BB,  0xA2F3 },
	{ 0xA2BC,  0xA2F4 },
	{ 0xA2BD,  0xA2F5 },
	{ 0xA2BE,  0xA2F6 },
	{ 0xA2BF,  0xA2F7 },
	{ 0xA2C0,  0xA2F8 },
	{ 0xA2C1,  0xA2F9 },
	{ 0xA2C2,  0xA2FA },
	{ 0xA2C3,  0xA940 },
	{ 0xA2C4,  0xA941 },
	{ 0xA2C5,  0xA942 },
	{ 0xA2C6,  0xA943 },
	{ 0xA2C7,  0xA944 },
	{ 0xA2C8,  0xA945 },
	{ 0xA2C9,  0xA946 },
	{ 0xA2CA,  0xA947 },
	{ 0xA2CB,  0xA948 },
	{ 0xA2CC,  0x8431A437 },
	{ 0xA2CD,  0x8560 },
	{ 0xA2CE,  0x8431A437 },
	{ 0xA2CF,  0xA3C1 },
	{ 0xA2D0,  0xA3C2 },
	{ 0xA2D1,  0xA3C3 },
	{ 0xA2D2,  0xA3C4 },
	{ 0xA2D3,  0xA3C5 },
	{ 0xA2D4,  0xA3C6 },
	{ 0xA2D5,  0xA3C7 },
	{ 0xA2D6,  0xA3C8 },
	{ 0xA2D7,  0xA3C9 },
	{ 0xA2D8,  0xA3CA },
	{ 0xA2D9,  0xA3CB },
	{ 0xA2DA,  0xA3CC },
	{ 0xA2DB,  0xA3CD },
	{ 0xA2DC,  0xA3CE },
	{ 0xA2DD,  0xA3CF },
	{ 0xA2DE,  0xA3D0 },
	{ 0xA2DF,  0xA3D1 },
	{ 0xA2E0,  0xA3D2 },
	{ 0xA2E1,  0xA3D3 },
	{ 0xA2E2,  0xA3D4 },
	{ 0xA2E3,  0xA3D5 },
	{ 0xA2E4,  0xA3D6 },
	{ 0xA2E5,  0xA3D7 },
	{ 0xA2E6,  0xA3D8 },
	{ 0xA2E7,  0xA3D9 },
	{ 0xA2E8,  0xA3DA },
	{ 0xA2E9,  0xA3E1 },
	{ 0xA2EA,  0xA3E2 },
	{ 0xA2EB,  0xA3E3 },
	{ 0xA2EC,  0xA3E4 },
	{ 0xA2ED,  0xA3E5 },
	{ 0xA2EE,  0xA3E6 },
	{ 0xA2EF,  0xA3E7 },
	{ 0xA2F0,  0xA3E8 },
	{ 0xA2F1,  0xA3E9 },
	{ 0xA2F2,  0xA3EA },
	{ 0xA2F3,  0xA3EB },
	{ 0xA2F4,  0xA3EC },
	{ 0xA2F5,  0xA3ED },
	{ 0xA2F6,  0xA3EE },
	{ 0xA2F7,  0xA3EF },
	{ 0xA2F8,  0xA3F0 },
	{ 0xA2F9,  0xA3F1 },
	{ 0xA2FA,  0xA3F2 },
	{ 0xA2FB,  0xA3F3 },
	{ 0xA2FC,  0xA3F4 },
	{ 0xA2FD,  0xA3F5 },
	{ 0xA2FE,  0xA3F6 },
	{ 0xA340,  0xA3F7 },
	{ 0xA341,  0xA3F8 },
	{ 0xA342,  0xA3F9 },
	{ 0xA343,  0xA3FA },
	{ 0xA344,  0xA6A1 },
	{ 0xA345,  0xA6A2 },
	{ 0xA346,  0xA6A3 },
	{ 0xA347,  0xA6A4 },
	{ 0xA348,  0xA6A5 },
	{ 0xA349,  0xA6A6 },
	{ 0xA34A,  0xA6A7 },
	{ 0xA34B,  0xA6A8 },
	{ 0xA34C,  0xA6A9 },
	{ 0xA34D,  0xA6AA },
	{ 0xA34E,  0xA6AB },
	{ 0xA34F,  0xA6AC },
	{ 0xA350,  0xA6AD },
	{ 0xA351,  0xA6AE },
	{ 0xA352,  0xA6AF },
	{ 0xA353,  0xA6B0 },
	{ 0xA354,  0xA6B1 },
	{ 0xA355,  0xA6B2 },
	{ 0xA356,  0xA6B3 },
	{ 0xA357,  0xA6B4 },
	{ 0xA358,  0xA6B5 },
	{ 0xA359,  0xA6B6 },
	{ 0xA35A,  0xA6B7 },
	{ 0xA35B,  0xA6B8 },
	{ 0xA35C,  0xA6C1 },
	{ 0xA35D,  0xA6C2 },
	{ 0xA35E,  0xA6C3 },
	{ 0xA35F,  0xA6C4 },
	{ 0xA360,  0xA6C5 },
	{ 0xA361,  0xA6C6 },
	{ 0xA362,  0xA6C7 },
	{ 0xA363,  0xA6C8 },
	{ 0xA364,  0xA6C9 },
	{ 0xA365,  0xA6CA },
	{ 0xA366,  0xA6CB },
	{ 0xA367,  0xA6CC },
	{ 0xA368,  0xA6CD },
	{ 0xA369,  0xA6CE },
	{ 0xA36A,  0xA6CF },
	{ 0xA36B,  0xA6D0 },
	{ 0xA36C,  0xA6D1 },
	{ 0xA36D,  0xA6D2 },
	{ 0xA36E,  0xA6D3 },
	{ 0xA36F,  0xA6D4 },
	{ 0xA370,  0xA6D5 },
	{ 0xA371,  0xA6D6 },
	{ 0xA372,  0xA6D7 },
	{ 0xA373,  0xA6D8 },
	{ 0xA374,  0xA8C5 },
	{ 0xA375,  0xA8C6 },
	{ 0xA376,  0xA8C7 },
	{ 0xA377,  0xA8C8 },
	{ 0xA378,  0xA8C9 },
	{ 0xA379,  0xA8CA },
	{ 0xA37A,  0xA8CB },
	{ 0xA37B,  0xA8CC },
	{ 0xA37C,  0xA8CD },
	{ 0xA37D,  0xA8CE },
	{ 0xA37E,  0xA8CF },
	{ 0xA3A1,  0xA8D0 },
	{ 0xA3A2,  0xA8D1 },
	{ 0xA3A3,  0xA8D2 },
	{ 0xA3A4,  0xA8D3 },
	{ 0xA3A5,  0xA8D4 },
	{ 0xA3A6,  0xA8D5 },
	{ 0xA3A7,  0xA8D6 },
	{ 0xA3A8,  0xA8D7 },
	{ 0xA3A9,  0xA8D8 },
	{ 0xA3AA,  0xA8D9 },
	{ 0xA3AB,  0xA8DA },
	{ 0xA3AC,  0xA8DB },
	{ 0xA3AD,  0xA8DC },
	{ 0xA3AE,  0xA8DD },
	{ 0xA3AF,  0xA8DE },
	{ 0xA3B0,  0xA8DF },
	{ 0xA3B1,  0xA8E0 },
	{ 0xA3B2,  0xA8E1 },
	{ 0xA3B3,  0xA8E2 },
	{ 0xA3B4,  0xA8E3 },
	{ 0xA3B5,  0xA8E4 },
	{ 0xA3B6,  0xA8E5 },
	{ 0xA3B7,  0xA8E6 },
	{ 0xA3B8,  0xA8E7 },
	{ 0xA3B9,  0xA8E8 },
	{ 0xA3BA,  0xA8E9 },
	{ 0xA3BB,  0xA842 },
	{ 0xA3BC,  0xA1A5 },
	{ 0xA3BD,  0xA840 },
	{ 0xA3BE,  0xA1A6 },
	{ 0xA3BF,  0xA841 },
	{ 0xA440,  0xD2BB },
	{ 0xA441,  0xD2D2 },
	{ 0xA442,  0xB6A1 },
	{ 0xA443,  0xC6DF },
	{ 0xA444,  0xC4CB },
	{ 0xA445,  0xBEC5 },
	{ 0xA446,  0xC1CB },
	{ 0xA447,  0xB6FE },
	{ 0xA448,  0xC8CB },
	{ 0xA449,  0xB6F9 },
	{ 0xA44A,  0xC8EB },
	{ 0xA44B,  0xB0CB },
	{ 0xA44C,  0xBCB8 },
	{ 0xA44D,  0xB5B6 },
	{ 0xA44E,  0xB5F3 },
	{ 0xA44F,  0xC1A6 },
	{ 0xA450,  0xD8B0 },
	{ 0xA451,  0xCAAE },
	{ 0xA452,  0xB2B7 },
	{ 0xA453,  0xD3D6 },
	{ 0xA454,  0xC8FD },
	{ 0xA455,  0xCFC2 },
	{ 0xA456,  0xD5C9 },
	{ 0xA457,  0xC9CF },
	{ 0xA458,  0xD1BE },
	{ 0xA459,  0xCDE8 },
	{ 0xA45A,  0xB7B2 },
	{ 0xA45B,  0xBEC3 },
	{ 0xA45C,  0xC3B4 },
	{ 0xA45D,  0xD2B2 },
	{ 0xA45E,  0xC6F2 },
	{ 0xA45F,  0xD3DA },
	{ 0xA460,  0xCDF6 },
	{ 0xA461,  0xD8A3 },
	{ 0xA462,  0xC8D0 },
	{ 0xA463,  0xC9D7 },
	{ 0xA464,  0xC7A7 },
	{ 0xA465,  0xB2E6 },
	{ 0xA466,  0xBFDA },
	{ 0xA467,  0xCDC1 },
	{ 0xA468,  0xCABF },
	{ 0xA469,  0xCFA6 },
	{ 0xA46A,  0xB4F3 },
	{ 0xA46B,  0xC5AE },
	{ 0xA46C,  0xD7D3 },
	{ 0xA46D,  0xE6DD },
	{ 0xA46E,  0xE6DE },
	{ 0xA46F,  0xB4E7 },
	{ 0xA470,  0xD0A1 },
	{ 0xA471,  0xDECC },
	{ 0xA472,  0xCAAC },
	{ 0xA473,  0xC9BD },
	{ 0xA474,  0xB4A8 },
	{ 0xA475,  0xB9A4 },
	{ 0xA476,  0xBCBA },
	{ 0xA477,  0xD2D1 },
	{ 0xA478,  0xCBC8 },
	{ 0xA479,  0xBDED },
	{ 0xA47A,  0xB8C9 },
	{ 0xA47B,  0xDEC3 },
	{ 0xA47C,  0xDFAE },
	{ 0xA47D,  0xB9AD },
	{ 0xA47E,  0xB2C5 },
	{ 0xA4A1,  0xB3F3 },
	{ 0xA4A2,  0xD8A4 },
	{ 0xA4A3,  0xB2BB },
	{ 0xA4A4,  0xD6D0 },
	{ 0xA4A5,  0xB7E1 },
	{ 0xA4A6,  0xB5A4 },
	{ 0xA4A7,  0xD6AE },
	{ 0xA4A8,  0xD2FC },
	{ 0xA4A9,  0xD3E8 },
	{ 0xA4AA,  0xD4C6 },
	{ 0xA4AB,  0xBEAE },
	{ 0xA4AC,  0xBBA5 },
	{ 0xA4AD,  0xCEE5 },
	{ 0xA4AE,  0xBFBA },
	{ 0xA4AF,  0xC8CA },
	{ 0xA4B0,  0xCAB2 },
	{ 0xA4B1,  0xD8EA },
	{ 0xA4B2,  0xC6CD },
	{ 0xA4B3,  0xB3F0 },
	{ 0xA4B4,  0xC8D4 },
	{ 0xA4B5,  0xBDF1 },
	{ 0xA4B6,  0xBDE9 },
	{ 0xA4B7,  0xD8C6 },
	{ 0xA4B8,  0xD4AA },
	{ 0xA4B9,  0xD4CA },
	{ 0xA4BA,  0x83C8 },
	{ 0xA4BB,  0xC1F9 },
	{ 0xA4BC,  0xD9E2 },
	{ 0xA4BD,  0xB9AB },
	{ 0xA4BE,  0xC8DF },
	{ 0xA4BF,  0xD0D7 },
	{ 0xA4C0,  0xB7D6 },
	{ 0xA4C1,  0xC7D0 },
	{ 0xA4C2,  0xD8D7 },
	{ 0xA4C3,  0x84F2 },
	{ 0xA4C4,  0xB9B4 },
	{ 0xA4C5,  0xCEF0 },
	{ 0xA4C6,  0xBBAF },
	{ 0xA4C7,  0xC6A5 },
	{ 0xA4C8,  0xCEE7 },
	{ 0xA4C9,  0xC9FD },
	{ 0xA4CA,  0xD8A6 },
	{ 0xA4CB,  0xB1E5 },
	{ 0xA4CC,  0xB6F2 },
	{ 0xA4CD,  0xD3D1 },
	{ 0xA4CE,  0xBCB0 },
	{ 0xA4CF,  0xB7B4 },
	{ 0xA4D0,  0xC8C9 },
	{ 0xA4D1,  0xCCEC },
	{ 0xA4D2,  0xB7F2 },
	{ 0xA4D3,  0xCCAB },
	{ 0xA4D4,  0xD8B2 },
	{ 0xA4D5,  0xBFD7 },
	{ 0xA4D6,  0xC9D9 },
	{ 0xA4D7,  0xD3C8 },
	{ 0xA4D8,  0xB3DF },
	{ 0xA4D9,  0xCDCD },
	{ 0xA4DA,  0xB0CD },
	{ 0xA4DB,  0xBBC3 },
	{ 0xA4DC,  0xD8A5 },
	{ 0xA4DD,  0x8F74 },
	{ 0xA4DE,  0xD2FD },
	{ 0xA4DF,  0xD0C4 },
	{ 0xA4E0,  0xB8EA },
	{ 0xA4E1,  0x91F4 },
	{ 0xA4E2,  0xCAD6 },
	{ 0xA4E3,  0xD4FA },
	{ 0xA4E4,  0xD6A7 },
	{ 0xA4E5,  0xCEC4 },
	{ 0xA4E6,  0xB6B7 },
	{ 0xA4E7,  0xBDEF },
	{ 0xA4E8,  0xB7BD },
	{ 0xA4E9,  0xC8D5 },
	{ 0xA4EA,  0xD4BB },
	{ 0xA4EB,  0xD4C2 },
	{ 0xA4EC,  0xC4BE },
	{ 0xA4ED,  0xC7B7 },
	{ 0xA4EE,  0xD6B9 },
	{ 0xA4EF,  0xB4F5 },
	{ 0xA4F0,  0xCEE3 },
	{ 0xA4F1,  0xB1C8 },
	{ 0xA4F2,  0xC3AB },
	{ 0xA4F3,  0xCACF },
	{ 0xA4F4,  0xCBAE },
	{ 0xA4F5,  0xBBF0 },
	{ 0xA4F6,  0xD7A6 },
	{ 0xA4F7,  0xB8B8 },
	{ 0xA4F8,  0xD8B3 },
	{ 0xA4F9,  0xC6AC },
	{ 0xA4FA,  0xD1C0 },
	{ 0xA4FB,  0xC5A3 },
	{ 0xA4FC,  0xC8AE },
	{ 0xA4FD,  0xCDF5 },
	{ 0xA4FE,  0xB1FB },
	{ 0xA540,  0xCAC0 },
	{ 0xA541,  0xD8A7 },
	{ 0xA542,  0xC7D2 },
	{ 0xA543,  0xC7F0 },
	{ 0xA544,  0xD6F7 },
	{ 0xA545,  0xD5A7 },
	{ 0xA546,  0xB7A6 },
	{ 0xA547,  0xBAF5 },
	{ 0xA548,  0xD2D4 },
	{ 0xA549,  0xB8B6 },
	{ 0xA54A,  0xD7D0 },
	{ 0xA54B,  0xCACB },
	{ 0xA54C,  0xCBFB },
	{ 0xA54D,  0xD5CC },
	{ 0xA54E,  0xB4FA },
	{ 0xA54F,  0xC1EE },
	{ 0xA550,  0xCFC9 },
	{ 0xA551,  0xD8F0 },
	{ 0xA552,  0xB3E4 },
	{ 0xA553,  0xD0D6 },
	{ 0xA554,  0xC8BD },
	{ 0xA555,  0x83D4 },
	{ 0xA556,  0xB6AC },
	{ 0xA557,  0xB0BC },
	{ 0xA558,  0xB3F6 },
	{ 0xA559,  0xCDB9 },
	{ 0xA55A,  0xBFAF },
	{ 0xA55B,  0xBCD3 },
	{ 0xA55C,  0xB9A6 },
	{ 0xA55D,  0xB0FC },
	{ 0xA55E,  0xB4D2 },
	{ 0xA55F,  0xB1B1 },
	{ 0xA560,  0xD4D1 },
	{ 0xA561,  0xC7AA },
	{ 0xA562,  0xB0EB },
	{ 0xA563,  0xBBDC },
	{ 0xA564,  0xBFA8 },
	{ 0xA565,  0xD5BC },
	{ 0xA566,  0xC3AE },
	{ 0xA567,  0xD8B4 },
	{ 0xA568,  0xC8A5 },
	{ 0xA569,  0xBFC9 },
	{ 0xA56A,  0xB9C5 },
	{ 0xA56B,  0xD3D2 },
	{ 0xA56C,  0xD5D9 },
	{ 0xA56D,  0xB6A3 },
	{ 0xA56E,  0xDFB5 },
	{ 0xA56F,  0xDFB6 },
	{ 0xA570,  0xB5F0 },
	{ 0xA571,  0xCBBE },
	{ 0xA572,  0xD8CF },
	{ 0xA573,  0xBDD0 },
	{ 0xA574,  0xC1ED },
	{ 0xA575,  0xD6BB },
	{ 0xA576,  0xCAB7 },
	{ 0xA577,  0xDFB3 },
	{ 0xA578,  0xCCA8 },
	{ 0xA579,  0xBEE4 },
	{ 0xA57A,  0xB0C8 },
	{ 0xA57B,  0xDFB7 },
	{ 0xA57C,  0xCBC4 },
	{ 0xA57D,  0xC7F4 },
	{ 0xA57E,  0xCDE2 },
	{ 0xA5A1,  0xD1EB },
	{ 0xA5A2,  0xCAA7 },
	{ 0xA5A3,  0xC5AB },
	{ 0xA5A4,  0xC4CC },
	{ 0xA5A5,  0xD4D0 },
	{ 0xA5A6,  0xCBFC },
	{ 0xA5A7,  0xC4E1 },
	{ 0xA5A8,  0xBEDE },
	{ 0xA5A9,  0xC7C9 },
	{ 0xA5AA,  0xD7F3 },
	{ 0xA5AB,  0xCAD0 },
	{ 0xA5AC,  0xB2BC },
	{ 0xA5AD,  0xC6BD },
	{ 0xA5AE,  0xD3D7 },
	{ 0xA5AF,  0xDBCD },
	{ 0xA5B0,  0xBAEB },
	{ 0xA5B1,  0xB8A5 },
	{ 0xA5B2,  0xB1D8 },
	{ 0xA5B3,  0xCEEC },
	{ 0xA5B4,  0xB4F2 },
	{ 0xA5B5,  0xC8D3 },
	{ 0xA5B6,  0xB0C7 },
	{ 0xA5B7,  0xC6CB },
	{ 0xA5B8,  0xB3E2 },
	{ 0xA5B9,  0xB5A9 },
	{ 0xA5BA,  0x9658 },
	{ 0xA5BB,  0xB1BE },
	{ 0xA5BC,  0xCEB4 },
	{ 0xA5BD,  0xC4A9 },
	{ 0xA5BE,  0xD4FD },
	{ 0xA5BF,  0xD5FD },
	{ 0xA5C0,  0xC4B8 },
	{ 0xA5C1,  0xC3F1 },
	{ 0xA5C2,  0xD8B5 },
	{ 0xA5C3,  0xD3C0 },
	{ 0xA5C4,  0xD6AD },
	{ 0xA5C5,  0xCDA1 },
	{ 0xA5C6,  0x9AEF },
	{ 0xA5C7,  0xB7B8 },
	{ 0xA5C8,  0xD0FE },
	{ 0xA5C9,  0xD3F1 },
	{ 0xA5CA,  0xB9CF },
	{ 0xA5CB,  0xCDDF },
	{ 0xA5CC,  0xB8CA },
	{ 0xA5CD,  0xC9FA },
	{ 0xA5CE,  0xD3C3 },
	{ 0xA5CF,  0xCBA6 },
	{ 0xA5D0,  0xCCEF },
	{ 0xA5D1,  0xD3C9 },
	{ 0xA5D2,  0xBCD7 },
	{ 0xA5D3,  0xC9EA },
	{ 0xA5D4,  0xF1E2 },
	{ 0xA5D5,  0xB0D7 },
	{ 0xA5D6,  0xC6A4 },
	{ 0xA5D7,  0xC3F3 },
	{ 0xA5D8,  0xC4BF },
	{ 0xA5D9,  0xC3AC },
	{ 0xA5DA,  0xCAB8 },
	{ 0xA5DB,  0xCAAF },
	{ 0xA5DC,  0xCABE },
	{ 0xA5DD,  0xBACC },
	{ 0xA5DE,  0xD1A8 },
	{ 0xA5DF,  0xC1A2 },
	{ 0xA5E0,  0xD8A9 },
	{ 0xA5E1,  0x8147 },
	{ 0xA5E2,  0xC6B9 },
	{ 0xA5E3,  0xC5D2 },
	{ 0xA5E4,  0xD8C0 },
	{ 0xA5E5,  0x8183 },
	{ 0xA5E6,  0xBDBB },
	{ 0xA5E7,  0xD2E0 },
	{ 0xA5E8,  0xBAA5 },
	{ 0xA5E9,  0xB7C2 },
	{ 0xA5EA,  0xD8F8 },
	{ 0xA5EB,  0xBBEF },
	{ 0xA5EC,  0xD2C1 },
	{ 0xA5ED,  0x81B8 },
	{ 0xA5EE,  0xCEE9 },
	{ 0xA5EF,  0xB7A5 },
	{ 0xA5F0,  0xD0DD },
	{ 0xA5F1,  0xB7FC },
	{ 0xA5F2,  0xD6D9 },
	{ 0xA5F3,  0xBCFE },
	{ 0xA5F4,  0xC8CE },
	{ 0xA5F5,  0xD1F6 },
	{ 0xA5F6,  0xD8F2 },
	{ 0xA5F7,  0xB7DD },
	{ 0xA5F8,  0xC6F3 },
	{ 0xA5F9,  0x81B3 },
	{ 0xA5FA,  0xB9E2 },
	{ 0xA5FB,  0x83B4 },
	{ 0xA5FC,  0xD5D7 },
	{ 0xA5FD,  0xCFC8 },
	{ 0xA5FE,  0xC8AB },
	{ 0xA640,  0xB9B2 },
	{ 0xA641,  0xD4D9 },
	{ 0xA642,  0xB1F9 },
	{ 0xA643,  0xC1D0 },
	{ 0xA644,  0xD0CC },
	{ 0xA645,  0xBBAE },
	{ 0xA646,  0xD8D8 },
	{ 0xA647,  0xEBBE },
	{ 0xA648,  0xC1D3 },
	{ 0xA649,  0xD0D9 },
	{ 0xA64A,  0xBFEF },
	{ 0xA64B,  0xBDB3 },
	{ 0xA64C,  0xD3A1 },
	{ 0xA64D,  0xCEA3 },
	{ 0xA64E,  0xBCAA },
	{ 0xA64F,  0xC0F4 },
	{ 0xA650,  0xCDAC },
	{ 0xA651,  0xB5F5 },
	{ 0xA652,  0xCDC2 },
	{ 0xA653,  0xD3F5 },
	{ 0xA654,  0x85BC },
	{ 0xA655,  0xB8F7 },
	{ 0xA656,  0xCFF2 },
	{ 0xA657,  0xC3FB },
	{ 0xA658,  0xBACF },
	{ 0xA659,  0xB3D4 },
	{ 0xA65A,  0xBAF3 },
	{ 0xA65B,  0xDFBA },
	{ 0xA65C,  0xDFB8 },
	{ 0xA65D,  0xD2F2 },
	{ 0xA65E,  0xBBD8 },
	{ 0xA65F,  0xE0EE },
	{ 0xA660,  0xDBDA },
	{ 0xA661,  0xB5D8 },
	{ 0xA662,  0xD4DA },
	{ 0xA663,  0xB9E7 },
	{ 0xA664,  0xDBD8 },
	{ 0xA665,  0xDBDD },
	{ 0xA666,  0xDBD7 },
	{ 0xA667,  0xD9ED },
	{ 0xA668,  0xB6E0 },
	{ 0xA669,  0xD2C4 },
	{ 0xA66A,  0xBFE4 },
	{ 0xA66B,  0xCDFD },
	{ 0xA66C,  0xBCE9 },
	{ 0xA66D,  0xE5FA },
	{ 0xA66E,  0xBAC3 },
	{ 0xA66F,  0xCBFD },
	{ 0xA670,  0xC8E7 },
	{ 0xA671,  0xE5F9 },
	{ 0xA672,  0xD7D6 },
	{ 0xA673,  0xB4E6 },
	{ 0xA674,  0xD3EE },
	{ 0xA675,  0xCAD8 },
	{ 0xA676,  0xD5AC },
	{ 0xA677,  0xB0B2 },
	{ 0xA678,  0xCBC2 },
	{ 0xA679,  0xBCE2 },
	{ 0xA67A,  0xD2D9 },
	{ 0xA67B,  0xD6DD },
	{ 0xA67C,  0xB7AB },
	{ 0xA67D,  0xB2A2 },
	{ 0xA67E,  0xC4EA },
	{ 0xA6A1,  0xCABD },
	{ 0xA6A2,  0xB3DA },
	{ 0xA6A3,  0xC3A6 },
	{ 0xA6A4,  0xE2E2 },
	{ 0xA6A5,  0xC8D6 },
	{ 0xA6A6,  0xD0E7 },
	{ 0xA6A7,  0xCAF9 },
	{ 0xA6A8,  0xB3C9 },
	{ 0xA6A9,  0xBFDB },
	{ 0xA6AA,  0xBFB8 },
	{ 0xA6AB,  0xCDD0 },
	{ 0xA6AC,  0xCAD5 },
	{ 0xA6AD,  0xD4E7 },
	{ 0xA6AE,  0xD6BC },
	{ 0xA6AF,  0xD1AE },
	{ 0xA6B0,  0xD0F1 },
	{ 0xA6B1,  0xC7FA },
	{ 0xA6B2,  0xD2B7 },
	{ 0xA6B3,  0xD3D0 },
	{ 0xA6B4,  0xD0E0 },
	{ 0xA6B5,  0xC6D3 },
	{ 0xA6B6,  0xD6EC },
	{ 0xA6B7,  0xB6E4 },
	{ 0xA6B8,  0xB4CE },
	{ 0xA6B9,  0xB4CB },
	{ 0xA6BA,  0xCBC0 },
	{ 0xA6BB,  0xC4CA },
	{ 0xA6BC,  0xC8EA },
	{ 0xA6BD,  0xBAB9 },
	{ 0xA6BE,  0x9B40 },
	{ 0xA6BF,  0xBDAD },
	{ 0xA6C0,  0xB3D8 },
	{ 0xA6C1,  0xCFAB },
	{ 0xA6C2,  0xC9C7 },
	{ 0xA6C3,  0xCEDB },
	{ 0xA6C4,  0xD1B4 },
	{ 0xA6C5,  0x9AF7 },
	{ 0xA6C6,  0x9AF8 },
	{ 0xA6C7,  0xBBD2 },
	{ 0xA6C8,  0xC4B2 },
	{ 0xA6C9,  0xEAF2 },
	{ 0xA6CA,  0xB0D9 },
	{ 0xA6CB,  0xD6F1 },
	{ 0xA6CC,  0xC3D7 },
	{ 0xA6CD,  0xF4E9 },
	{ 0xA6CE,  0xF3BE },
	{ 0xA6CF,  0xD1F2 },
	{ 0xA6D0,  0xD3F0 },
	{ 0xA6D1,  0xC0CF },
	{ 0xA6D2,  0xBFBC },
	{ 0xA6D3,  0xB6F8 },
	{ 0xA6D4,  0xF1E7 },
	{ 0xA6D5,  0xB6FA },
	{ 0xA6D6,  0xEDB2 },
	{ 0xA6D7,  0xC8E2 },
	{ 0xA6D8,  0xC0DF },
	{ 0xA6D9,  0xBCA1 },
	{ 0xA6DA,  0xB3BC },
	{ 0xA6DB,  0xD7D4 },
	{ 0xA6DC,  0xD6C1 },
	{ 0xA6DD,  0xBECA },
	{ 0xA6DE,  0xC9E0 },
	{ 0xA6DF,  0xE2B6 },
	{ 0xA6E0,  0xD6DB },
	{ 0xA6E1,  0xF4DE },
	{ 0xA6E2,  0xC9AB },
	{ 0xA6E3,  0xB0AC },
	{ 0xA6E4,  0xB3E6 },
	{ 0xA6E5,  0xD1AA },
	{ 0xA6E6,  0xD0D0 },
	{ 0xA6E7,  0xD2C2 },
	{ 0xA6E8,  0xCEF7 },
	{ 0xA6E9,  0xDAE4 },
	{ 0xA6EA,  0xB4AE },
	{ 0xA6EB,  0xBAE0 },
	{ 0xA6EC,  0xCEBB },
	{ 0xA6ED,  0xD7A1 },
	{ 0xA6EE,  0x81D0 },
	{ 0xA6EF,  0xD9A2 },
	{ 0xA6F0,  0xD8FA },
	{ 0xA6F1,  0xB0E9 },
	{ 0xA6F2,  0xB7F0 },
	{ 0xA6F3,  0xBACE },
	{ 0xA6F4,  0xB9C0 },
	{ 0xA6F5,  0xD7F4 },
	{ 0xA6F6,  0xD3D3 },
	{ 0xA6F7,  0xD9A4 },
	{ 0xA6F8,  0xCBC5 },
	{ 0xA6F9,  0xC9EC },
	{ 0xA6FA,  0xB5E8 },
	{ 0xA6FB,  0x81D7 },
	{ 0xA6FC,  0xCBC6 },
	{ 0xA6FD,  0xB5AB },
	{ 0xA6FE,  0xD3B6 },
	{ 0xA740,  0xD7F7 },
	{ 0xA741,  0xC4E3 },
	{ 0xA742,  0xB2AE },
	{ 0xA743,  0xB5CD },
	{ 0xA744,  0xC1E6 },
	{ 0xA745,  0xD3E0 },
	{ 0xA746,  0xD8FE },
	{ 0xA747,  0x81D1 },
	{ 0xA748,  0xD8FD },
	{ 0xA749,  0x83B6 },
	{ 0xA74A,  0xBFCB },
	{ 0xA74B,  0xC3E2 },
	{ 0xA74C,  0xB1F8 },
	{ 0xA74D,  0xD2B1 },
	{ 0xA74E,  0xC0E4 },
	{ 0xA74F,  0x8465 },
	{ 0xA750,  0xC5D0 },
	{ 0xA751,  0xC0FB },
	{ 0xA752,  0x8468 },
	{ 0xA753,  0xC5D9 },
	{ 0xA754,  0xBDD9 },
	{ 0xA755,  0xD6FA },
	{ 0xA756,  0xC5AC },
	{ 0xA757,  0xDBBE },
	{ 0xA758,  0xCFBB },
	{ 0xA759,  0xBCB4 },
	{ 0xA75A,  0xC2D1 },
	{ 0xA75B,  0xC1DF },
	{ 0xA75C,  0xBFD4 },
	{ 0xA75D,  0xCDCC },
	{ 0xA75E,  0xCEE1 },
	{ 0xA75F,  0xB7F1 },
	{ 0xA760,  0x85D5 },
	{ 0xA761,  0xB0C9 },
	{ 0xA762,  0xB4F4 },
	{ 0xA763,  0xDFC0 },
	{ 0xA764,  0x85C7 },
	{ 0xA765,  0xB3CA },
	{ 0xA766,  0x85CE },
	{ 0xA767,  0xBEFD },
	{ 0xA768,  0xB7D4 },
	{ 0xA769,  0xB8E6 },
	{ 0xA76A,  0xB4B5 },
	{ 0xA76B,  0xCEC7 },
	{ 0xA76C,  0xCEFC },
	{ 0xA76D,  0xCBB1 },
	{ 0xA76E,  0xB3B3 },
	{ 0xA76F,  0x85C8 },
	{ 0xA770,  0xB7CD },
	{ 0xA771,  0xBAF0 },
	{ 0xA772,  0xD1BD },
	{ 0xA773,  0xD6A8 },
	{ 0xA774,  0xBAAC },
	{ 0xA775,  0xD2F7 },
	{ 0xA776,  0xCCFD },
	{ 0xA777,  0x87E8 },
	{ 0xA778,  0xC0A7 },
	{ 0xA779,  0xB6DA },
	{ 0xA77A,  0xE0F1 },
	{ 0xA77B,  0xB7BB },
	{ 0xA77C,  0xBFD3 },
	{ 0xA77D,  0xD6B7 },
	{ 0xA77E,  0xCCAE },
	{ 0xA7A1,  0xBEF9 },
	{ 0xA7A2,  0xBFB2 },
	{ 0xA7A3,  0xBBF8 },
	{ 0xA7A4,  0xD7F8 },
	{ 0xA7A5,  0xBBB5 },
	{ 0xA7A6,  0xDBDF },
	{ 0xA7A7,  0x89D1 },
	{ 0xA7A8,  0x8A41 },
	{ 0xA7A9,  0x8A79 },
	{ 0xA7AA,  0xB6CA },
	{ 0xA7AB,  0xB7C1 },
	{ 0xA7AC,  0xE6A4 },
	{ 0xA7AD,  0xE5FE },
	{ 0xA7AE,  0xC3EE },
	{ 0xA7AF,  0xD1FD },
	{ 0xA7B0,  0xE5FB },
	{ 0xA7B1,  0xE6A5 },
	{ 0xA7B2,  0xBCCB },
	{ 0xA7B3,  0xC8D1 },
	{ 0xA7B4,  0xCDD7 },
	{ 0xA7B5,  0xD0A2 },
	{ 0xA7B6,  0xD7CE },
	{ 0xA7B7,  0xE6DA },
	{ 0xA7B8,  0xD8C3 },
	{ 0xA7B9,  0xCDEA },
	{ 0xA7BA,  0xCBCE },
	{ 0xA7BB,  0xBAEA },
	{ 0xA7BC,  0xDECE },
	{ 0xA7BD,  0xBED6 },
	{ 0xA7BE,  0xC6A8 },
	{ 0xA7BF,  0xC4F2 },
	{ 0xA7C0,  0xCEB2 },
	{ 0xA7C1,  0xE1AA },
	{ 0xA7C2,  0xE1AF },
	{ 0xA7C3,  0xB2ED },
	{ 0xA7C4,  0xE1A7 },
	{ 0xA7C5,  0xCED7 },
	{ 0xA7C6,  0xCFA3 },
	{ 0xA7C7,  0xD0F2 },
	{ 0xA7C8,  0xB1D3 },
	{ 0xA7C9,  0xB4B2 },
	{ 0xA7CA,  0xCDA2 },
	{ 0xA7CB,  0xC5AA },
	{ 0xA7CC,  0xB5DC },
	{ 0xA7CD,  0xCDAE },
	{ 0xA7CE,  0xD0CE },
	{ 0xA7CF,  0xE1DD },
	{ 0xA7D0,  0xD2DB },
	{ 0xA7D1,  0xCDFC },
	{ 0xA7D2,  0xBCC9 },
	{ 0xA7D3,  0xD6BE },
	{ 0xA7D4,  0xC8CC },
	{ 0xA7D5,  0xB3C0 },
	{ 0xA7D6,  0xBFEC },
	{ 0xA7D7,  0xE2EE },
	{ 0xA7D8,  0xE2EC },
	{ 0xA7D9,  0xBDE4 },
	{ 0xA7DA,  0xCED2 },
	{ 0xA7DB,  0xB3AD },
	{ 0xA7DC,  0xBFB9 },
	{ 0xA7DD,  0xB6B6 },
	{ 0xA7DE,  0xBCBC },
	{ 0xA7DF,  0xB7F6 },
	{ 0xA7E0,  0xBEF1 },
	{ 0xA7E1,  0xC5A4 },
	{ 0xA7E2,  0xB0D1 },
	{ 0xA7E3,  0xB6F3 },
	{ 0xA7E4,  0xD5D2 },
	{ 0xA7E5,  0xC5FA },
	{ 0xA7E6,  0xB0E2 },
	{ 0xA7E7,  0xCAE3 },
	{ 0xA7E8,  0xB3B6 },
	{ 0xA7E9,  0xD5DB },
	{ 0xA7EA,  0xB0E7 },
	{ 0xA7EB,  0xCDB6 },
	{ 0xA7EC,  0xD7A5 },
	{ 0xA7ED,  0xD2D6 },
	{ 0xA7EE,  0x925E },
	{ 0xA7EF,  0xB8C4 },
	{ 0xA7F0,  0xB9A5 },
	{ 0xA7F1,  0xD8FC },
	{ 0xA7F2,  0xBAB5 },
	{ 0xA7F3,  0xB8FC },
	{ 0xA7F4,  0xCAF8 },
	{ 0xA7F5,  0xC0EE },
	{ 0xA7F6,  0xD0D3 },
	{ 0xA7F7,  0xB2C4 },
	{ 0xA7F8,  0xB4E5 },
	{ 0xA7F9,  0xB6C5 },
	{ 0xA7FA,  0xD5C8 },
	{ 0xA7FB,  0xE8BD },
	{ 0xA7FC,  0xC9BC },
	{ 0xA7FD,  0xB8CB },
	{ 0xA7FE,  0xB8DC },
	{ 0xA840,  0xE8BC },
	{ 0xA841,  0x966E },
	{ 0xA842,  0xB2BD },
	{ 0xA843,  0xC3BF },
	{ 0xA844,  0xC7F3 },
	{ 0xA845,  0xB9AF },
	{ 0xA846,  0xC9B3 },
	{ 0xA847,  0xC7DF },
	{ 0xA848,  0xC9F2 },
	{ 0xA849,  0xB3C1 },
	{ 0xA84A,  0xE3E4 },
	{ 0xA84B,  0xC5E6 },
	{ 0xA84C,  0xCDF4 },
	{ 0xA84D,  0x9B51 },
	{ 0xA84E,  0xE3E5 },
	{ 0xA84F,  0xCCAD },
	{ 0xA850,  0xE3E7 },
	{ 0xA851,  0xE3E8 },
	{ 0xA852,  0x9B5F },
	{ 0xA853,  0x9B5D },
	{ 0xA854,  0xC6FB },
	{ 0xA855,  0xCED6 },
	{ 0xA856,  0xBCB3 },
	{ 0xA857,  0xB7DA },
	{ 0xA858,  0xE3EA },
	{ 0xA859,  0xE3EC },
	{ 0xA85A,  0xE3EB },
	{ 0xA85B,  0x9B5A },
	{ 0xA85C,  0xE3E6 },
	{ 0xA85D,  0x9B61 },
	{ 0xA85E,  0xD2CA },
	{ 0xA85F,  0xD4EE },
	{ 0xA860,  0xD7C6 },
	{ 0xA861,  0x9EC4 },
	{ 0xA862,  0xBEC4 },
	{ 0xA863,  0xC0CE },
	{ 0xA864,  0xC4B5 },
	{ 0xA865,  0xA0AD },
	{ 0xA866,  0xB5D2 },
	{ 0xA867,  0xBFF1 },
	{ 0xA868,  0xBEC1 },
	{ 0xA869,  0xF0AE },
	{ 0xA86A,  0xB8A6 },
	{ 0xA86B,  0xC4D0 },
	{ 0xA86C,  0xB5E9 },
	{ 0xA86D,  0xD4ED },
	{ 0xA86E,  0xB6A2 },
	{ 0xA86F,  0xD2D3 },
	{ 0xA870,  0xCBBD },
	{ 0xA871,  0xD0E3 },
	{ 0xA872,  0xB664 },
	{ 0xA873,  0xBEBF },
	{ 0xA874,  0xCFB5 },
	{ 0xA875,  0xBAB1 },
	{ 0xA876,  0xD0A4 },
	{ 0xA877,  0xEBC1 },
	{ 0xA878,  0xB8CE },
	{ 0xA879,  0xD6E2 },
	{ 0xA87A,  0xB8D8 },
	{ 0xA87B,  0xB6C7 },
	{ 0xA87C,  0xD3FD },
	{ 0xA87D,  0xC1BC },
	{ 0xA87E,  0xC3A2 },
	{ 0xA8A1,  0xD3F3 },
	{ 0xA8A2,  0xC9D6 },
	{ 0xA8A3,  0xD28A },
	{ 0xA8A4,  0xBDC7 },
	{ 0xA8A5,  0xD1D4 },
	{ 0xA8A6,  0xB9C8 },
	{ 0xA8A7,  0xB6B9 },
	{ 0xA8A8,  0xF5B9 },
	{ 0xA8A9,  0xD890 },
	{ 0xA8AA,  0xB3E0 },
	{ 0xA8AB,  0xD7DF },
	{ 0xA8AC,  0xD7E3 },
	{ 0xA8AD,  0xC9ED },
	{ 0xA8AE,  0xDC87 },
	{ 0xA8AF,  0xD0C1 },
	{ 0xA8B0,  0xB3BD },
	{ 0xA8B1,  0xD3D8 },
	{ 0xA8B2,  0xDE7E },
	{ 0xA8B3,  0xD1B8 },
	{ 0xA8B4,  0xC6F9 },
	{ 0xA8B5,  0xD1B2 },
	{ 0xA8B6,  0xD2D8 },
	{ 0xA8B7,  0xD0CF },
	{ 0xA8B8,  0xD0B0 },
	{ 0xA8B9,  0xB0EE },
	{ 0xA8BA,  0xC4C7 },
	{ 0xA8BB,  0xD3CF },
	{ 0xA8BC,  0xE18A },
	{ 0xA8BD,  0xC0EF },
	{ 0xA8BE,  0xB7C0 },
	{ 0xA8BF,  0xC8EE },
	{ 0xA8C0,  0xDAE5 },
	{ 0xA8C1,  0xDAE6 },
	{ 0xA8C2,  0xEA6C },
	{ 0xA8C3,  0x814B },
	{ 0xA8C4,  0xB9D4 },
	{ 0xA8C5,  0xC8E9 },
	{ 0xA8C6,  0xCAC2 },
	{ 0xA8C7,  0xD0A9 },
	{ 0xA8C8,  0x8186 },
	{ 0xA8C9,  0xCFED },
	{ 0xA8CA,  0xBEA9 },
	{ 0xA8CB,  0xD1F0 },
	{ 0xA8CC,  0xD2C0 },
	{ 0xA8CD,  0xCACC },
	{ 0xA8CE,  0xBCD1 },
	{ 0xA8CF,  0xCAB9 },
	{ 0xA8D0,  0xC0D0 },
	{ 0xA8D1,  0xB9A9 },
	{ 0xA8D2,  0xC0FD },
	{ 0xA8D3,  0x81ED },
	{ 0xA8D4,  0xD9A9 },
	{ 0xA8D5,  0xB0DB },
	{ 0xA8D6,  0x81E3 },
	{ 0xA8D7,  0xB3DE },
	{ 0xA8D8,  0xC5E5 },
	{ 0xA8D9,  0xD9AC },
	{ 0xA8DA,  0x81F6 },
	{ 0xA8DB,  0xD9AB },
	{ 0xA8DC,  0xD9AA },
	{ 0xA8DD,  0xD9A7 },
	{ 0xA8DE,  0x81E7 },
	{ 0xA8DF,  0xCDC3 },
	{ 0xA8E0,  0x83BA },
	{ 0xA8E1,  0xD9EE },
	{ 0xA8E2,  0x83C9 },
	{ 0xA8E3,  0xBEDF },
	{ 0xA8E4,  0xC6E4 },
	{ 0xA8E5,  0xB5E4 },
	{ 0xA8E6,  0xD9FD },
	{ 0xA8E7,  0xBAAF },
	{ 0xA8E8,  0xBFCC },
	{ 0xA8E9,  0xC8AF },
	{ 0xA8EA,  0xCBA2 },
	{ 0xA8EB,  0xB4CC },
	{ 0xA8EC,  0xB5BD },
	{ 0xA8ED,  0xB9CE },
	{ 0xA8EE,  0xD6C6 },
	{ 0xA8EF,  0xB6E7 },
	{ 0xA8F0,  0xDBC0 },
	{ 0xA8F1,  0x84C1 },
	{ 0xA8F2,  0xD7E4 },
	{ 0xA8F3,  0x8566 },
	{ 0xA8F4,  0xD7BF },
	{ 0xA8F5,  0xB1B0 },
	{ 0xA8F6,  0xD8D4 },
	{ 0xA8F7,  0xBEED },
	{ 0xA8F8,  0xD0B6 },
	{ 0xA8F9,  0x8572 },
	{ 0xA8FA,  0xC8A1 },
	{ 0xA8FB,  0xCAE5 },
	{ 0xA8FC,  0xCADC },
	{ 0xA8FD,  0xCEB6 },
	{ 0xA8FE,  0xBAC7 },
	{ 0xA940,  0xBFA7 },
	{ 0xA941,  0xC5DE },
	{ 0xA942,  0xB9BE },
	{ 0xA943,  0xBED7 },
	{ 0xA944,  0xC9EB },
	{ 0xA945,  0xDFC8 },
	{ 0xA946,  0xDFCD },
	{ 0xA947,  0xD6E4 },
	{ 0xA948,  0xC5D8 },
	{ 0xA949,  0xBAF4 },
	{ 0xA94A,  0xB8C0 },
	{ 0xA94B,  0xDFC9 },
	{ 0xA94C,  0xDFCE },
	{ 0xA94D,  0xBACD },
	{ 0xA94E,  0xDFCB },
	{ 0xA94F,  0xC4D8 },
	{ 0xA950,  0xD6DC },
	{ 0xA951,  0xD5A6 },
	{ 0xA952,  0xC3FC },
	{ 0xA953,  0xBECC },
	{ 0xA954,  0xB9CC },
	{ 0xA955,  0xC0AC },
	{ 0xA956,  0xBFC0 },
	{ 0xA957,  0xC6BA },
	{ 0xA958,  0xDBE1 },
	{ 0xA959,  0xC6C2 },
	{ 0xA95A,  0xCCB9 },
	{ 0xA95B,  0xC0A4 },
	{ 0xA95C,  0xDBE5 },
	{ 0xA95D,  0xD2B9 },
	{ 0xA95E,  0xB7EE },
	{ 0xA95F,  0xC6E6 },
	{ 0xA960,  0xC4CE },
	{ 0xA961,  0xD1D9 },
	{ 0xA962,  0xB1BC },
	{ 0xA963,  0xE6AA },
	{ 0xA964,  0xC6DE },
	{ 0xA965,  0xCEAF },
	{ 0xA966,  0xC3C3 },
	{ 0xA967,  0xC4DD },
	{ 0xA968,  0xB9C3 },
	{ 0xA969,  0xC4B7 },
	{ 0xA96A,  0xBDE3 },
	{ 0xA96B,  0x8A99 },
	{ 0xA96C,  0xCABC },
	{ 0xA96D,  0xD0D5 },
	{ 0xA96E,  0xE6A2 },
	{ 0xA96F,  0xE6A8 },
	{ 0xA970,  0x8A85 },
	{ 0xA971,  0xE6A6 },
	{ 0xA972,  0x8A94 },
	{ 0xA973,  0xC3CF },
	{ 0xA974,  0xB9C2 },
	{ 0xA975,  0xBCBE },
	{ 0xA976,  0xD7DA },
	{ 0xA977,  0xB6A8 },
	{ 0xA978,  0xB9D9 },
	{ 0xA979,  0xD2CB },
	{ 0xA97A,  0xD6E6 },
	{ 0xA97B,  0xCDF0 },
	{ 0xA97C,  0xC9D0 },
	{ 0xA97D,  0xC7FC },
	{ 0xA97E,  0xBED3 },
	{ 0xA9A1,  0x8CC3 },
	{ 0xA9A2,  0xE1BA },
	{ 0xA9A3,  0x8CF9 },
	{ 0xA9A4,  0xB0B6 },
	{ 0xA9A5,  0xD1D2 },
	{ 0xA9A6,  0xE1B6 },
	{ 0xA9A7,  0xE1B7 },
	{ 0xA9A8,  0xD4C0 },
	{ 0xA9A9,  0xC1B1 },
	{ 0xA9AA,  0xD6E3 },
	{ 0xA9AB,  0xCCFB },
	{ 0xA9AC,  0xC5C1 },
	{ 0xA9AD,  0xB2AF },
	{ 0xA9AE,  0xE0FB },
	{ 0xA9AF,  0xD0D2 },
	{ 0xA9B0,  0xB8FD },
	{ 0xA9B1,  0xB5EA },
	{ 0xA9B2,  0xB8AE },
	{ 0xA9B3,  0xB5D7 },
	{ 0xA9B4,  0xE2D2 },
	{ 0xA9B5,  0xD1D3 },
	{ 0xA9B6,  0xCFD2 },
	{ 0xA9B7,  0xBBA1 },
	{ 0xA9B8,  0xE5F3 },
	{ 0xA9B9,  0xCDF9 },
	{ 0xA9BA,  0xD5F7 },
	{ 0xA9BB,  0x8FB7 },
	{ 0xA9BC,  0xB1CB },
	{ 0xA9BD,  0xE3C3 },
	{ 0xA9BE,  0xD6D2 },
	{ 0xA9BF,  0xBAF6 },
	{ 0xA9C0,  0xC4EE },
	{ 0xA9C1,  0xB7DE },
	{ 0xA9C2,  0xE2F3 },
	{ 0xA9C3,  0xD5FA },
	{ 0xA9C4,  0xC7D3 },
	{ 0xA9C5,  0xE2F0 },
	{ 0xA9C6,  0xB2C0 },
	{ 0xA9C7,  0xB9D6 },
	{ 0xA9C8,  0xC5C2 },
	{ 0xA9C9,  0xE2F9 },
	{ 0xA9CA,  0xD0D4 },
	{ 0xA9CB,  0xE2F5 },
	{ 0xA9CC,  0xE2F6 },
	{ 0xA9CD,  0xE2F2 },
	{ 0xA9CE,  0xBBF2 },
	{ 0xA9CF,  0xE3DE },
	{ 0xA9D0,  0xB7BF },
	{ 0xA9D1,  0xECE5 },
	{ 0xA9D2,  0xCBF9 },
	{ 0xA9D3,  0xB3D0 },
	{ 0xA9D4,  0xC0AD },
	{ 0xA9D5,  0xB0E8 },
	{ 0xA9D6,  0xD6F4 },
	{ 0xA9D7,  0xC3F2 },
	{ 0xA9D8,  0xB7F7 },
	{ 0xA9D9,  0xC4A8 },
	{ 0xA9DA,  0xBEDC },
	{ 0xA9DB,  0xD5D0 },
	{ 0xA9DC,  0xC5FB },
	{ 0xA9DD,  0xCDD8 },
	{ 0xA9DE,  0xB0CE },
	{ 0xA9DF,  0x9281 },
	{ 0xA9E0,  0xC4E9 },
	{ 0xA9E1,  0xC5EA },
	{ 0xA9E2,  0xB3E9 },
	{ 0xA9E3,  0xD1BA },
	{ 0xA9E4,  0xB9D5 },
	{ 0xA9E5,  0xD7BE },
	{ 0xA9E6,  0xC4B4 },
	{ 0xA9E7,  0xC5C4 },
	{ 0xA9E8,  0xB5D6 },
	{ 0xA9E9,  0xDED5 },
	{ 0xA9EA,  0xB1A7 },
	{ 0xA9EB,  0xBED0 },
	{ 0xA9EC,  0xCDCF },
	{ 0xA9ED,  0xDED6 },
	{ 0xA9EE,  0xB2F0 },
	{ 0xA9EF,  0xCCA7 },
	{ 0xA9F0,  0xC1E0 },
	{ 0xA9F1,  0xB7C5 },
	{ 0xA9F2,  0xB8AB },
	{ 0xA9F3,  0xECB6 },
	{ 0xA9F4,  0xCDFA },
	{ 0xA9F5,  0xCEF4 },
	{ 0xA9F6,  0xD2D7 },
	{ 0xA9F7,  0xB2FD },
	{ 0xA9F8,  0xC0A5 },
	{ 0xA9F9,  0xB0BA },
	{ 0xA9FA,  0xC3F7 },
	{ 0xA9FB,  0xEAC0 },
	{ 0xA9FC,  0xBBE8 },
	{ 0xA9FD,  0xEABF },
	{ 0xA9FE,  0xEABB },
	{ 0xAA40,  0x954E },
	{ 0xAA41,  0xB7FE },
	{ 0xAA42,  0xC5F3 },
	{ 0xAA43,  0xBABC },
	{ 0xAA44,  0xE8CA },
	{ 0xAA45,  0xD5ED },
	{ 0xAA46,  0x967C },
	{ 0xAA47,  0xB9FB },
	{ 0xAA48,  0xE8C3 },
	{ 0xAA49,  0xE8CB },
	{ 0xAA4A,  0xE8C1 },
	{ 0xAA4B,  0xD6A6 },
	{ 0xAA4C,  0xC1D6 },
	{ 0xAA4D,  0xB1AD },
	{ 0xAA4E,  0xBDDC },
	{ 0xAA4F,  0xB0E5 },
	{ 0xAA50,  0xCDF7 },
	{ 0xAA51,  0xCBC9 },
	{ 0xAA52,  0xCEF6 },
	{ 0xAA53,  0xE8C6 },
	{ 0xAA54,  0xC3B6 },
	{ 0xAA55,  0x9692 },
	{ 0xAA56,  0xE8CC },
	{ 0xAA57,  0xE8C2 },
	{ 0xAA58,  0xEABD },
	{ 0xAA59,  0xD0C0 },
	{ 0xAA5A,  0xCEE4 },
	{ 0xAA5B,  0xC6E7 },
	{ 0xAA5C,  0x9A7B },
	{ 0xAA5D,  0xC3A5 },
	{ 0xAA5E,  0xB7D5 },
	{ 0xAA5F,  0xC6FC },
	{ 0xAA60,  0xD7A2 },
	{ 0xAA61,  0xD3BE },
	{ 0xAA62,  0xE3FB },
	{ 0xAA63,  0xC3DA },
	{ 0xAA64,  0xC4E0 },
	{ 0xAA65,  0xBAD3 },
	{ 0xAA66,  0xB9C1 },
	{ 0xAA67,  0xD5B4 },
	{ 0xAA68,  0xD5D3 },
	{ 0xAA69,  0xB2A8 },
	{ 0xAA6A,  0xC4AD },
	{ 0xAA6B,  0xB7A8 },
	{ 0xAA6C,  0xE3FC },
	{ 0xAA6D,  0xB7D0 },
	{ 0xAA6E,  0xD0B9 },
	{ 0xAA6F,  0xD3CD },
	{ 0xAA70,  0x9B72 },
	{ 0xAA71,  0xBEDA },
	{ 0xAA72,  0xE3F4 },
	{ 0xAA73,  0xC7F6 },
	{ 0xAA74,  0xE3F3 },
	{ 0xAA75,  0xD1D8 },
	{ 0xAA76,  0xD6CE },
	{ 0xAA77,  0xC5DD },
	{ 0xAA78,  0xB7BA },
	{ 0xAA79,  0xB2B4 },
	{ 0xAA7A,  0x9B69 },
	{ 0xAA7B,  0xE3FD },
	{ 0xAA7C,  0x9B82 },
	{ 0xAA7D,  0xE3F7 },
	{ 0xAA7E,  0xE3F6 },
	{ 0xAAA1,  0xBFBB },
	{ 0xAAA2,  0xD1D7 },
	{ 0xAAA3,  0xB3B4 },
	{ 0xAAA4,  0xB4B6 },
	{ 0xAAA5,  0xD6CB },
	{ 0xAAA6,  0xC5C0 },
	{ 0xAAA7,  0xA08E },
	{ 0xAAA8,  0xB0D6 },
	{ 0xAAA9,  0xB0E6 },
	{ 0xAAAA,  0xC4C1 },
	{ 0xAAAB,  0xCEEF },
	{ 0xAAAC,  0xA0EE },
	{ 0xAAAD,  0xE1F2 },
	{ 0xAAAE,  0xBED1 },
	{ 0xAAAF,  0xB9B7 },
	{ 0xAAB0,  0xBAFC },
	{ 0xAAB1,  0xCDE6 },
	{ 0xAAB2,  0xAB6B },
	{ 0xAAB3,  0xE7E4 },
	{ 0xAAB4,  0xC3B5 },
	{ 0xAAB5,  0xAB68 },
	{ 0xAAB6,  0xAE6C },
	{ 0xAAB7,  0xF0DE },
	{ 0xAAB8,  0xB8ED },
	{ 0xAAB9,  0xBECE },
	{ 0xAABA,  0xB5C4 },
	{ 0xAABB,  0xD3DB },
	{ 0xAABC,  0xC3A4 },
	{ 0xAABD,  0xD6B1 },
	{ 0xAABE,  0xD6AA },
	{ 0xAABF,  0xCEF9 },
	{ 0xAAC0,  0xC9E7 },
	{ 0xAAC1,  0xECEB },
	{ 0xAAC2,  0xC6EE },
	{ 0xAAC3,  0xB1FC },
	{ 0xAAC4,  0xB669 },
	{ 0xAAC5,  0xBFD5 },
	{ 0xAAC6,  0xF1B7 },
	{ 0xAAC7,  0xF3C3 },
	{ 0xAAC8,  0xBC6D },
	{ 0xAAC9,  0xD8E8 },
	{ 0xAACA,  0xC7BC },
	{ 0xAACB,  0xC164 },
	{ 0xAACC,  0xD5DF },
	{ 0xAACD,  0xB7CE },
	{ 0xAACE,  0xB7CA },
	{ 0xAACF,  0xD6AB },
	{ 0xAAD0,  0xEBC5 },
	{ 0xAAD1,  0xB9C9 },
	{ 0xAAD2,  0xEBC6 },
	{ 0xAAD3,  0xBCE7 },
	{ 0xAAD4,  0xEBC8 },
	{ 0xAAD5,  0xB7BE },
	{ 0xAAD6,  0xBFCF },
	{ 0xAAD7,  0xC550 },
	{ 0xAAD8,  0xF4A7 },
	{ 0xAAD9,  0xC9E1 },
	{ 0xAADA,  0xB7BC },
	{ 0xAADB,  0xD6A5 },
	{ 0xAADC,  0xDCBD },
	{ 0xAADD,  0xB0C5 },
	{ 0xAADE,  0xD1BF },
	{ 0xAADF,  0xDCCF },
	{ 0xAAE0,  0xC7DB },
	{ 0xAAE1,  0xBBA8 },
	{ 0xAAE2,  0xB7D2 },
	{ 0xAAE3,  0xBDE6 },
	{ 0xAAE4,  0xD0BE },
	{ 0xAAE5,  0xDCBF },
	{ 0xAAE6,  0xC65D },
	{ 0xAAE7,  0xDCC1 },
	{ 0xAAE8,  0xDCC0 },
	{ 0xAAE9,  0xDCC6 },
	{ 0xAAEA,  0xBBA2 },
	{ 0xAAEB,  0xCAAD },
	{ 0xAAEC,  0xB3F5 },
	{ 0xAAED,  0xB1ED },
	{ 0xAAEE,  0xDC88 },
	{ 0xAAEF,  0xD3AD },
	{ 0xAAF0,  0xB7B5 },
	{ 0xAAF1,  0xBDFC },
	{ 0xAAF2,  0xC9DB },
	{ 0xAAF3,  0xDBA1 },
	{ 0xAAF4,  0xC7F1 },
	{ 0xAAF5,  0xDAFD },
	{ 0xAAF6,  0xB2C9 },
	{ 0xAAF7,  0xBDF0 },
	{ 0xAAF8,  0xE94C },
	{ 0xAAF9,  0xE954 },
	{ 0xAAFA,  0xB8B7 },
	{ 0xAAFB,  0xCDD3 },
	{ 0xAAFC,  0xB0A2 },
	{ 0xAAFD,  0xD7E8 },
	{ 0xAAFE,  0xB8BD },
	{ 0xAB40,  0xDAE9 },
	{ 0xAB41,  0xF6BF },
	{ 0xAB42,  0xD3EA },
	{ 0xAB43,  0xC7E0 },
	{ 0xAB44,  0xB7C7 },
	{ 0xAB45,  0xD8BD },
	{ 0xAB46,  0xCDA4 },
	{ 0xAB47,  0xC1C1 },
	{ 0xAB48,  0xD0C5 },
	{ 0xAB49,  0xC7D6 },
	{ 0xAB4A,  0xBAEE },
	{ 0xAB4B,  0xB1E3 },
	{ 0xAB4C,  0x8262 },
	{ 0xAB4D,  0xD9B8 },
	{ 0xAB4E,  0xC7CE },
	{ 0xAB4F,  0xB1A3 },
	{ 0xAB50,  0xB4D9 },
	{ 0xAB51,  0x8248 },
	{ 0xAB52,  0xB7FD },
	{ 0xAB53,  0xD9B9 },
	{ 0xAB54,  0xBFA1 },
	{ 0xAB55,  0xCBD7 },
	{ 0xAB56,  0xCEEA },
	{ 0xAB57,  0xC0FE },
	{ 0xAB58,  0xB6ED },
	{ 0xAB59,  0x8253 },
	{ 0xAB5A,  0xD9B5 },
	{ 0xAB5B,  0xD9DE },
	{ 0xAB5C,  0xD3E1 },
	{ 0xAB5D,  0x8249 },
	{ 0xAB5E,  0x83BC },
	{ 0xAB5F,  0xC3B0 },
	{ 0xAB60,  0x83D9 },
	{ 0xAB61,  0xB9DA },
	{ 0xAB62,  0x8478 },
	{ 0xAB63,  0xCCEA },
	{ 0xAB64,  0xCFF7 },
	{ 0xAB65,  0xC7B0 },
	{ 0xAB66,  0xD8DD },
	{ 0xAB67,  0x8477 },
	{ 0xAB68,  0x8474 },
	{ 0xAB69,  0xD3C2 },
	{ 0xAB6A,  0xC3E3 },
	{ 0xAB6B,  0xB2AA },
	{ 0xAB6C,  0x84C5 },
	{ 0xAB6D,  0xD9E9 },
	{ 0xAB6E,  0xC4CF },
	{ 0xAB6F,  0x8573 },
	{ 0xAB70,  0xBAF1 },
	{ 0xAB71,  0xC5D1 },
	{ 0xAB72,  0xD2A7 },
	{ 0xAB73,  0xB0A7 },
	{ 0xAB74,  0xD7C9 },
	{ 0xAB75,  0xB0A5 },
	{ 0xAB76,  0xD4D5 },
	{ 0xAB77,  0xCFCC },
	{ 0xAB78,  0xDFD7 },
	{ 0xAB79,  0xBFC8 },
	{ 0xAB7A,  0xCDDB },
	{ 0xAB7B,  0xDFD3 },
	{ 0xAB7C,  0xD1CA },
	{ 0xAB7D,  0xDFE4 },
	{ 0xAB7E,  0xC6B7 },
	{ 0xABA1,  0xBAE5 },
	{ 0xABA2,  0xB9FE },
	{ 0xABA3,  0xBFA9 },
	{ 0xABA4,  0xE5EB },
	{ 0xABA5,  0xD4DB },
	{ 0xABA6,  0xDFDD },
	{ 0xABA7,  0xDFE3 },
	{ 0xABA8,  0xDFD6 },
	{ 0xABA9,  0xDFDE },
	{ 0xABAA,  0xE0F3 },
	{ 0xABAB,  0xB4B9 },
	{ 0xABAC,  0xD0CD },
	{ 0xABAD,  0xDBF3 },
	{ 0xABAE,  0xD4AB },
	{ 0xABAF,  0xB9B8 },
	{ 0xABB0,  0xB3C7 },
	{ 0xABB1,  0xBFE5 },
	{ 0xABB2,  0xDBF2 },
	{ 0xABB3,  0xDEC8 },
	{ 0xABB4,  0xC6F5 },
	{ 0xABB5,  0xD7E0 },
	{ 0xABB6,  0xBFFC },
	{ 0xABB7,  0x8A4A },
	{ 0xABB8,  0xBDAA },
	{ 0xABB9,  0xE6B0 },
	{ 0xABBA,  0xD7CB },
	{ 0xABBB,  0xE6AF },
	{ 0xABBC,  0xD2CC },
	{ 0xABBD,  0xCDDE },
	{ 0xABBE,  0xC0D1 },
	{ 0xABBF,  0x8AA9 },
	{ 0xABC0,  0xD2A6 },
	{ 0xABC1,  0x8AA6 },
	{ 0xABC2,  0xCDFE },
	{ 0xABC3,  0xD2F6 },
	{ 0xABC4,  0xBAA2 },
	{ 0xABC5,  0xD0FB },
	{ 0xABC6,  0xBBC2 },
	{ 0xABC7,  0xCAD2 },
	{ 0xABC8,  0xBFCD },
	{ 0xABC9,  0xE5B6 },
	{ 0xABCA,  0xB7E2 },
	{ 0xABCB,  0xCABA },
	{ 0xABCC,  0xC6C1 },
	{ 0xABCD,  0x8CC6 },
	{ 0xABCE,  0xCEDD },
	{ 0xABCF,  0xD6C5 },
	{ 0xABD0,  0xE1BC },
	{ 0xABD1,  0xCFEF },
	{ 0xABD2,  0xB5DB },
	{ 0xABD3,  0x8E9B },
	{ 0xABD4,  0x8E95 },
	{ 0xABD5,  0xD3C4 },
	{ 0xABD6,  0xE2D4 },
	{ 0xABD7,  0xB6C8 },
	{ 0xABD8,  0xBDA8 },
	{ 0xABD9,  0xDEC4 },
	{ 0xABDA,  0xE5F4 },
	{ 0xABDB,  0x8FA9 },
	{ 0xABDC,  0xBADC },
	{ 0xABDD,  0xB4FD },
	{ 0xABDE,  0xBBB2 },
	{ 0xABDF,  0xC2C9 },
	{ 0xABE0,  0xE1DF },
	{ 0xABE1,  0xE1E1 },
	{ 0xABE2,  0xE1E0 },
	{ 0xABE3,  0xC5AD },
	{ 0xABE4,  0xCBBC },
	{ 0xABE5,  0xB5A1 },
	{ 0xABE6,  0xBCB1 },
	{ 0xABE7,  0xD4F5 },
	{ 0xABE8,  0xD4B9 },
	{ 0xABE9,  0xBBD0 },
	{ 0xABEA,  0xC7A1 },
	{ 0xABEB,  0xBADE },
	{ 0xABEC,  0xBBD6 },
	{ 0xABED,  0x9061 },
	{ 0xABEE,  0xCAD1 },
	{ 0xABEF,  0xCCF1 },
	{ 0xABF0,  0xB6B2 },
	{ 0xABF1,  0xE3A1 },
	{ 0xABF2,  0xD0F4 },
	{ 0xABF3,  0xB1E2 },
	{ 0xABF4,  0xB0DD },
	{ 0xABF5,  0xCDDA },
	{ 0xABF6,  0xB0B4 },
	{ 0xABF7,  0xC6B4 },
	{ 0xABF8,  0xCAC3 },
	{ 0xABF9,  0xB3D6 },
	{ 0xABFA,  0xDED7 },
	{ 0xABFB,  0xD7A7 },
	{ 0xABFC,  0xD6B8 },
	{ 0xABFD,  0xB9B0 },
	{ 0xABFE,  0xBFBD },
	{ 0xAC40,  0xD5FC },
	{ 0xAC41,  0xC0A8 },
	{ 0xAC42,  0xCAB0 },
	{ 0xAC43,  0xCBA9 },
	{ 0xAC44,  0xCCF4 },
	{ 0xAC45,  0xB9D2 },
	{ 0xAC46,  0xD5FE },
	{ 0xAC47,  0xB9CA },
	{ 0xAC48,  0xEDBD },
	{ 0xAC49,  0xCAA9 },
	{ 0xAC4A,  0xBCC8 },
	{ 0xAC4B,  0xB4BA },
	{ 0xAC4C,  0xD5D1 },
	{ 0xAC4D,  0xD3B3 },
	{ 0xAC4E,  0xC3C1 },
	{ 0xAC4F,  0xCAC7 },
	{ 0xAC50,  0xD0C7 },
	{ 0xAC51,  0xD7F2 },
	{ 0xAC52,  0xEAC5 },
	{ 0xAC53,  0x9560 },
	{ 0xAC54,  0xEAC2 },
	{ 0xAC55,  0xCAC1 },
	{ 0xAC56,  0xC8BE },
	{ 0xAC57,  0xD6F9 },
	{ 0xAC58,  0xC8E1 },
	{ 0xAC59,  0xC4B3 },
	{ 0xAC5A,  0xBCED },
	{ 0xAC5B,  0xBCDC },
	{ 0xAC5C,  0xBFDD },
	{ 0xAC5D,  0x96C5 },
	{ 0xAC5E,  0xE8D1 },
	{ 0xAC5F,  0xBFC2 },
	{ 0xAC60,  0xB1FA },
	{ 0xAC61,  0xB8CC },
	{ 0xAC62,  0x96A1 },
	{ 0xAC63,  0xE8D6 },
	{ 0xAC64,  0xB2E9 },
	{ 0xAC65,  0xE8DB },
	{ 0xAC66,  0xB0D8 },
	{ 0xAC67,  0xD7F5 },
	{ 0xAC68,  0xC1F8 },
	{ 0xAC69,  0xE8D2 },
	{ 0xAC6A,  0xE8D4 },
	{ 0xAC6B,  0xE8DC },
	{ 0xAC6C,  0xE8D8 },
	{ 0xAC6D,  0xC6E2 },
	{ 0xAC6E,  0xCDE1 },
	{ 0xAC6F,  0xD1EA },
	{ 0xAC70,  0xB4F9 },
	{ 0xAC71,  0xB6CE },
	{ 0xAC72,  0xB6BE },
	{ 0xAC73,  0xC5FE },
	{ 0xAC74,  0xB7FA },
	{ 0xAC75,  0xC8AA },
	{ 0xAC76,  0xD1F3 },
	{ 0xAC77,  0xD6DE },
	{ 0xAC78,  0xBAE9 },
	{ 0xAC79,  0xC1F7 },
	{ 0xAC7A,  0xBDF2 },
	{ 0xAC7B,  0xE4A3 },
	{ 0xAC7C,  0xB6FD },
	{ 0xAC7D,  0xB6B4 },
	{ 0xAC7E,  0xCFB4 },
	{ 0xACA1,  0xBBEE },
	{ 0xACA2,  0xC7A2 },
	{ 0xACA3,  0xC5C9 },
	{ 0xACA4,  0x9BB0 },
	{ 0xACA5,  0xC2E5 },
	{ 0xACA6,  0xB1C3 },
	{ 0xACA7,  0xE4A1 },
	{ 0xACA8,  0xE4A2 },
	{ 0xACA9,  0x9BB2 },
	{ 0xACAA,  0x9BAA },
	{ 0xACAB,  0xE4AC },
	{ 0xACAC,  0xE4AD },
	{ 0xACAD,  0xE4A9 },
	{ 0xACAE,  0xE4AA },
	{ 0xACAF,  0xECC5 },
	{ 0xACB0,  0x9EE9 },
	{ 0xACB1,  0xB1FE },
	{ 0xACB2,  0xBEE6 },
	{ 0xACB3,  0xBEBC },
	{ 0xACB4,  0xCCBF },
	{ 0xACB5,  0xD5A8 },
	{ 0xACB6,  0xC5DA },
	{ 0xACB7,  0x9EDD },
	{ 0xACB8,  0xEBBC },
	{ 0xACB9,  0xC9FC },
	{ 0xACBA,  0xEAF4 },
	{ 0xACBB,  0xA0B9 },
	{ 0xACBC,  0xE1F7 },
	{ 0xACBD,  0xBADD },
	{ 0xACBE,  0xBDC6 },
	{ 0xACBF,  0xE7E8 },
	{ 0xACC0,  0xC9BA },
	{ 0xACC1,  0xB2A3 },
	{ 0xACC2,  0xC1E1 },
	{ 0xACC3,  0xD5E4 },
	{ 0xACC4,  0xE7EA },
	{ 0xACC5,  0xE7E9 },
	{ 0xACC6,  0xC9F5 },
	{ 0xACC7,  0xB1C2 },
	{ 0xACC8,  0xCEB7 },
	{ 0xACC9,  0xBDE7 },
	{ 0xACCA,  0xEEB0 },
	{ 0xACCB,  0xEEB1 },
	{ 0xACCC,  0xD2DF },
	{ 0xACCD,  0xB0CC },
	{ 0xACCE,  0xBDEA },
	{ 0xACCF,  0xAF4D },
	{ 0xACD0,  0xF0E0 },
	{ 0xACD1,  0xB9EF },
	{ 0xACD2,  0xBDD4 },
	{ 0xACD3,  0xBBCA },
	{ 0xACD4,  0xF0A7 },
	{ 0xACD5,  0xD3AF },
	{ 0xACD6,  0xC5E8 },
	{ 0xACD7,  0xB0A0 },
	{ 0xACD8,  0xD6D1 },
	{ 0xACD9,  0xCAA1 },
	{ 0xACDA,  0xEDEF },
	{ 0xACDB,  0xCFE0 },
	{ 0xACDC,  0xC3BC },
	{ 0xACDD,  0xBFB4 },
	{ 0xACDE,  0xB6DC },
	{ 0xACDF,  0xC5CE },
	{ 0xACE0,  0xEDF0 },
	{ 0xACE1,  0xF1E6 },
	{ 0xACE2,  0xC9B0 },
	{ 0xACE3,  0xD1D0 },
	{ 0xACE4,  0xC6F6 },
	{ 0xACE5,  0xBFB3 },
	{ 0xACE6,  0xECEC },
	{ 0xACE7,  0xECED },
	{ 0xACE8,  0xC6ED },
	{ 0xACE9,  0xB56F },
	{ 0xACEA,  0xD3ED },
	{ 0xACEB,  0xD8AE },
	{ 0xACEC,  0xBFC6 },
	{ 0xACED,  0xC3EB },
	{ 0xACEE,  0xC7EF },
	{ 0xACEF,  0xB4A9 },
	{ 0xACF0,  0xCDBB },
	{ 0xACF1,  0xB8CD },
	{ 0xACF2,  0xF3C4 },
	{ 0xACF3,  0xD7D1 },
	{ 0xACF4,  0xBC71 },
	{ 0xACF5,  0xBC74 },
	{ 0xACF6,  0xBC6F },
	{ 0xACF7,  0xBC78 },
	{ 0xACF8,  0xBC76 },
	{ 0xACF9,  0xBC73 },
	{ 0xACFA,  0xBC75 },
	{ 0xACFB,  0xB8D7 },
	{ 0xACFC,  0xC3C0 },
	{ 0xACFD,  0xF4E0 },
	{ 0xACFE,  0xEBA3 },
	{ 0xAD40,  0xC4CD },
	{ 0xAD41,  0xCBA3 },
	{ 0xAD42,  0xC25A },
	{ 0xAD43,  0xD2AE },
	{ 0xAD44,  0xC5D6 },
	{ 0xAD45,  0xF1E3 },
	{ 0xAD46,  0xC5DF },
	{ 0xAD47,  0xCEB8 },
	{ 0xAD48,  0xEBD0 },
	{ 0xAD49,  0xB1B3 },
	{ 0xAD4A,  0xBAFA },
	{ 0xAD4B,  0xEBCE },
	{ 0xAD4C,  0xCCA5 },
	{ 0xAD4D,  0xB0FB },
	{ 0xAD4E,  0xD8B7 },
	{ 0xAD4F,  0xEBD5 },
	{ 0xAD50,  0xD6C2 },
	{ 0xAD51,  0xF4AE },
	{ 0xAD52,  0xC672 },
	{ 0xAD53,  0xB7B6 },
	{ 0xAD54,  0xC3A9 },
	{ 0xAD55,  0xDCC4 },
	{ 0xAD56,  0xBFC1 },
	{ 0xAD57,  0xBFE0 },
	{ 0xAD58,  0xC7D1 },
	{ 0xAD59,  0xC8F4 },
	{ 0xAD5A,  0xC3AF },
	{ 0xAD5B,  0xDCD4 },
	{ 0xAD5C,  0xDCDB },
	{ 0xAD5D,  0xC3E7 },
	{ 0xAD5E,  0xD3A2 },
	{ 0xAD5F,  0xD7C2 },
	{ 0xAD60,  0xDCD9 },
	{ 0xAD61,  0xCCA6 },
	{ 0xAD62,  0xD4B7 },
	{ 0xAD63,  0xB0FA },
	{ 0xAD64,  0xDCDF },
	{ 0xAD65,  0xB9B6 },
	{ 0xAD66,  0xB1BD },
	{ 0xAD67,  0xDCE2 },
	{ 0xAD68,  0xC5B0 },
	{ 0xAD69,  0xBAE7 },
	{ 0xAD6A,  0xF2B5 },
	{ 0xAD6B,  0xF2B3 },
	{ 0xAD6C,  0xD1DC },
	{ 0xAD6D,  0xC9C0 },
	{ 0xAD6E,  0xD2AA },
	{ 0xAD6F,  0xD362 },
	{ 0xAD70,  0xD38B },
	{ 0xAD71,  0xD386 },
	{ 0xAD72,  0xD387 },
	{ 0xAD73,  0xD891 },
	{ 0xAD74,  0xD893 },
	{ 0xAD75,  0xB8B0 },
	{ 0xAD76,  0xF4F1 },
	{ 0xAD77,  0xC5BF },
	{ 0xAD78,  0xDC8A },
	{ 0xAD79,  0xDC89 },
	{ 0xAD7A,  0xCAF6 },
	{ 0xAD7B,  0xE5C8 },
	{ 0xAD7C,  0xCCF6 },
	{ 0xAD7D,  0xB5CF },
	{ 0xAD7E,  0xE5C4 },
	{ 0xADA1,  0xB5FC },
	{ 0xADA2,  0xC6C8 },
	{ 0xADA3,  0xE5C6 },
	{ 0xADA4,  0xE5CA },
	{ 0xADA5,  0xBDBC },
	{ 0xADA6,  0xC0C9 },
	{ 0xADA7,  0xD3F4 },
	{ 0xADA8,  0xE041 },
	{ 0xADA9,  0xC7F5 },
	{ 0xADAA,  0xF4FA },
	{ 0xADAB,  0xD6D8 },
	{ 0xADAC,  0xE956 },
	{ 0xADAD,  0xCFDE },
	{ 0xADAE,  0xC2AA },
	{ 0xADAF,  0xC4B0 },
	{ 0xADB0,  0xBDB5 },
	{ 0xADB1,  0xC3E6 },
	{ 0xADB2,  0xB8EF },
	{ 0xADB3,  0xED66 },
	{ 0xADB4,  0xBEC2 },
	{ 0xADB5,  0xD2F4 },
	{ 0xADB6,  0xED93 },
	{ 0xADB7,  0xEF4C },
	{ 0xADB8,  0xEF77 },
	{ 0xADB9,  0xCAB3 },
	{ 0xADBA,  0xCAD7 },
	{ 0xADBB,  0xCFE3 },
	{ 0xADBC,  0xB3CB },
	{ 0xADBD,  0xD9F1 },
	{ 0xADBE,  0xD9C4 },
	{ 0xADBF,  0xB1B6 },
	{ 0xADC0,  0x828D },
	{ 0xADC1,  0xB8A9 },
	{ 0xADC2,  0xBEEB },
	{ 0xADC3,  0xD9C5 },
	{ 0xADC4,  0xD9BA },
	{ 0xADC5,  0xD9BB },
	{ 0xADC6,  0x8286 },
	{ 0xADC7,  0x827A },
	{ 0xADC8,  0xD6B5 },
	{ 0xADC9,  0xBDE8 },
	{ 0xADCA,  0xD2D0 },
	{ 0xADCB,  0xB5B9 },
	{ 0xADCC,  0x8283 },
	{ 0xADCD,  0xB0B3 },
	{ 0xADCE,  0x8274 },
	{ 0xADCF,  0xBEF3 },
	{ 0xADD0,  0xD9C6 },
	{ 0xADD1,  0xBEE3 },
	{ 0xADD2,  0xB3AB },
	{ 0xADD3,  0x8280 },
	{ 0xADD4,  0xBAF2 },
	{ 0xADD5,  0xCCC8 },
	{ 0xADD6,  0xD9BD },
	{ 0xADD7,  0xD0DE },
	{ 0xADD8,  0xD9C1 },
	{ 0xADD9,  0xC4DF },
	{ 0xADDA,  0xD9C2 },
	{ 0xADDB,  0x8290 },
	{ 0xADDC,  0x827D },
	{ 0xADDD,  0xBCE6 },
	{ 0xADDE,  0xD4A9 },
	{ 0xADDF,  0xDAA4 },
	{ 0xADE0,  0xDAA3 },
	{ 0xADE1,  0x83F6 },
	{ 0xADE2,  0xC1E8 },
	{ 0xADE3,  0xD7BC },
	{ 0xADE4,  0xB5F2 },
	{ 0xADE5,  0xC6CA },
	{ 0xADE6,  0xD8E0 },
	{ 0xADE7,  0xCCDE },
	{ 0xADE8,  0x8482 },
	{ 0xADE9,  0x8483 },
	{ 0xADEA,  0xB7CB },
	{ 0xADEB,  0xC7E4 },
	{ 0xADEC,  0xD4AD },
	{ 0xADED,  0xD8C8 },
	{ 0xADEE,  0xDBC5 },
	{ 0xADEF,  0xC9DA },
	{ 0xADF0,  0xCCC6 },
	{ 0xADF1,  0xD1E4 },
	{ 0xADF2,  0xE0A1 },
	{ 0xADF3,  0xBADF },
	{ 0xADF4,  0xB8E7 },
	{ 0xADF5,  0xD5DC },
	{ 0xADF6,  0xCBF4 },
	{ 0xADF7,  0xB2B8 },
	{ 0xADF8,  0xDFED },
	{ 0xADF9,  0xC1A8 },
	{ 0xADFA,  0xBFDE },
	{ 0xADFB,  0x8654 },
	{ 0xADFC,  0xB0A6 },
	{ 0xADFD,  0xCFF8 },
	{ 0xADFE,  0xC4C4 },
	{ 0xAE40,  0xC5B6 },
	{ 0xAE41,  0xDFF3 },
	{ 0xAE42,  0xB4BD },
	{ 0xAE43,  0xDFEC },
	{ 0xAE44,  0xDFF1 },
	{ 0xAE45,  0xC6D4 },
	{ 0xAE46,  0xE0F4 },
	{ 0xAE47,  0xB9A1 },
	{ 0xAE48,  0xC6D2 },
	{ 0xAE49,  0xC2F1 },
	{ 0xAE4A,  0xB0A3 },
	{ 0xAE4B,  0x88D6 },
	{ 0xAE4C,  0xCFC4 },
	{ 0xAE4D,  0xCCD7 },
	{ 0xAE4E,  0xDECA },
	{ 0xAE4F,  0xDEC9 },
	{ 0xAE50,  0xE6B6 },
	{ 0xAE51,  0xC4EF },
	{ 0xAE52,  0xC4C8 },
	{ 0xAE53,  0xBEEA },
	{ 0xAE54,  0x8ACA },
	{ 0xAE55,  0xE6B8 },
	{ 0xAE56,  0xBCA7 },
	{ 0xAE57,  0xC9EF },
	{ 0xAE58,  0xE6B7 },
	{ 0xAE59,  0xC3E4 },
	{ 0xAE5A,  0xB6F0 },
	{ 0xAE5B,  0xE6B2 },
	{ 0xAE5C,  0xE6B3 },
	{ 0xAE5D,  0x8C4F },
	{ 0xAE5E,  0x8CCC },
	{ 0xAE5F,  0xD4D7 },
	{ 0xAE60,  0xBAA6 },
	{ 0xAE61,  0xBCD2 },
	{ 0xAE62,  0xD1E7 },
	{ 0xAE63,  0x8C6D },
	{ 0xAE64,  0xCFFC },
	{ 0xAE65,  0xC8DD },
	{ 0xAE66,  0xE5B7 },
	{ 0xAE67,  0xC9E4 },
	{ 0xAE68,  0xD0BC },
	{ 0xAE69,  0xD5B9 },
	{ 0xAE6A,  0xE5EC },
	{ 0xAE6B,  0xC7CD },
	{ 0xAE6C,  0x8D7B },
	{ 0xAE6D,  0xBEFE },
	{ 0xAE6E,  0xD3F8 },
	{ 0xAE6F,  0xB6EB },
	{ 0xAE70,  0xB7E5 },
	{ 0xAE71,  0x8D75 },
	{ 0xAE72,  0x8D80 },
	{ 0xAE73,  0x8D73 },
	{ 0xAE74,  0xB2EE },
	{ 0xAE75,  0xCFAF },
	{ 0xAE76,  0x8E9F },
	{ 0xAE77,  0x8EEC },
	{ 0xAE78,  0xCDA5 },
	{ 0xAE79,  0xD7F9 },
	{ 0xAE7A,  0xC8F5 },
	{ 0xAE7B,  0xCDBD },
	{ 0xAE7C,  0x8FBD },
	{ 0xAE7D,  0xD0EC },
	{ 0xAE7E,  0xEDA6 },
	{ 0xAEA1,  0xEDA7 },
	{ 0xAEA2,  0x9075 },
	{ 0xAEA3,  0xBFD6 },
	{ 0xAEA4,  0xCBA1 },
	{ 0xAEA5,  0xB9A7 },
	{ 0xAEA6,  0xB6F7 },
	{ 0xAEA7,  0xCFA2 },
	{ 0xAEA8,  0xC7C4 },
	{ 0xAEA9,  0xCEF2 },
	{ 0xAEAA,  0xE3A4 },
	{ 0xAEAB,  0xBAB7 },
	{ 0xAEAC,  0xBBDA },
	{ 0xAEAD,  0xE3A9 },
	{ 0xAEAE,  0x9082 },
	{ 0xAEAF,  0xE3A3 },
	{ 0xAEB0,  0xC9C8 },
	{ 0xAEB1,  0xC8AD },
	{ 0xAEB2,  0xEAFC },
	{ 0xAEB3,  0xC4C3 },
	{ 0xAEB4,  0xC9D3 },
	{ 0xAEB5,  0x92B6 },
	{ 0xAEB6,  0xD5F1 },
	{ 0xAEB7,  0xB2B6 },
	{ 0xAEB8,  0xCEE6 },
	{ 0xAEB9,  0xC0A6 },
	{ 0xAEBA,  0xC4F3 },
	{ 0xAEBB,  0xD7BD },
	{ 0xAEBC,  0xCDA6 },
	{ 0xAEBD,  0xBEE8 },
	{ 0xAEBE,  0xCDEC },
	{ 0xAEBF,  0xC5B2 },
	{ 0xAEC0,  0xB4EC },
	{ 0xAEC1,  0xB0A4 },
	{ 0xAEC2,  0xBAB4 },
	{ 0xAEC3,  0xB0C6 },
	{ 0xAEC4,  0xD0A7 },
	{ 0xAEC5,  0xF4CD },
	{ 0xAEC6,  0xC1CF },
	{ 0xAEC7,  0xC5D4 },
	{ 0xAEC8,  0xC2C3 },
	{ 0xAEC9,  0x9572 },
	{ 0xAECA,  0x9578 },
	{ 0xAECB,  0xEACC },
	{ 0xAECC,  0xBBCE },
	{ 0xAECD,  0xC9B9 },
	{ 0xAECE,  0xC9CE },
	{ 0xAECF,  0x9574 },
	{ 0xAED0,  0xEACB },
	{ 0xAED1,  0x95F8 },
	{ 0xAED2,  0xCBB7 },
	{ 0xAED3,  0xEBDE },
	{ 0xAED4,  0xC0CA },
	{ 0xAED5,  0xD0A3 },
	{ 0xAED6,  0xBACB },
	{ 0xAED7,  0xB0B8 },
	{ 0xAED8,  0xBFF2 },
	{ 0xAED9,  0xBBB8 },
	{ 0xAEDA,  0xB8F9 },
	{ 0xAEDB,  0xB9F0 },
	{ 0xAEDC,  0xBDDB },
	{ 0xAEDD,  0xE8F2 },
	{ 0xAEDE,  0xCAE1 },
	{ 0xAEDF,  0xC0F5 },
	{ 0xAEE0,  0xD7C0 },
	{ 0xAEE1,  0xC9A3 },
	{ 0xAEE2,  0xD4D4 },
	{ 0xAEE3,  0xB2F1 },
	{ 0xAEE4,  0xCDA9 },
	{ 0xAEE5,  0xE8EE },
	{ 0xAEE6,  0xB8F1 },
	{ 0xAEE7,  0xCCD2 },
	{ 0xAEE8,  0xD6EA },
	{ 0xAEE9,  0xCEA6 },
	{ 0xAEEA,  0xCBA8 },
	{ 0xAEEB,  0x96D8 },
	{ 0xAEEC,  0xE8EC },
	{ 0xAEED,  0xCAE2 },
	{ 0xAEEE,  0xD1B3 },
	{ 0xAEEF,  0xD2F3 },
	{ 0xAEF0,  0x9AE2 },
	{ 0xAEF1,  0xD1F5 },
	{ 0xAEF2,  0xB0B1 },
	{ 0xAEF3,  0xBAA4 },
	{ 0xAEF4,  0xEBB3 },
	{ 0xAEF5,  0xCCA9 },
	{ 0xAEF6,  0xC0CB },
	{ 0xAEF7,  0xCCE9 },
	{ 0xAEF8,  0xCFFB },
	{ 0xAEF9,  0x9BDC },
	{ 0xAEFA,  0xC6D6 },
	{ 0xAEFB,  0xBDFE },
	{ 0xAEFC,  0xBAA3 },
	{ 0xAEFD,  0xD5E3 },
	{ 0xAEFE,  0xE4B8 },
	{ 0xAF40,  0x9BC9 },
	{ 0xAF41,  0xC9E6 },
	{ 0xAF42,  0xB8A1 },
	{ 0xAF43,  0xBFA3 },
	{ 0xAF44,  0xD4A1 },
	{ 0xAF45,  0xBAC6 },
	{ 0xAF46,  0xD3BF },
	{ 0xAF47,  0x9BDD },
	{ 0xAF48,  0x9BD1 },
	{ 0xAF49,  0xC4F9 },
	{ 0xAF4A,  0x9BC5 },
	{ 0xAF4B,  0xE4B9 },
	{ 0xAF4C,  0xECC8 },
	{ 0xAF4D,  0xBAE6 },
	{ 0xAF4E,  0xBFBE },
	{ 0xAF4F,  0xC0D3 },
	{ 0xAF50,  0xC1D2 },
	{ 0xAF51,  0x9EF5 },
	{ 0xAF52,  0xB5F9 },
	{ 0xAF53,  0xCCD8 },
	{ 0xAF54,  0xC0C7 },
	{ 0xAF55,  0xAA4D },
	{ 0xAF56,  0xAA4E },
	{ 0xAF57,  0xC0EA },
	{ 0xAF58,  0xE1FA },
	{ 0xAF59,  0xAB52 },
	{ 0xAF5A,  0xB0E0 },
	{ 0xAF5B,  0xC1F0 },
	{ 0xAF5C,  0xAB98 },
	{ 0xAF5D,  0xD6E9 },
	{ 0xAF5E,  0xAB95 },
	{ 0xAF5F,  0xE7F3 },
	{ 0xAF60,  0xC5CF },
	{ 0xAF61,  0xAE80 },
	{ 0xAF62,  0xD0F3 },
	{ 0xAF63,  0xDBCE },
	{ 0xAF64,  0xC1F4 },
	{ 0xAF65,  0xBCB2 },
	{ 0xAF66,  0xB2A1 },
	{ 0xAF67,  0xD6A2 },
	{ 0xAF68,  0xC6A3 },
	{ 0xAF69,  0xF0E1 },
	{ 0xAF6A,  0xBED2 },
	{ 0xAF6B,  0xCCDB },
	{ 0xAF6C,  0xD5EE },
	{ 0xAF6D,  0xF0E8 },
	{ 0xAF6E,  0xF0E3 },
	{ 0xAF6F,  0xB8DE },
	{ 0xAF70,  0xB092 },
	{ 0xAF71,  0xD2E6 },
	{ 0xAF72,  0xEEC1 },
	{ 0xAF73,  0xB0BB },
	{ 0xAF74,  0xD1A3 },
	{ 0xAF75,  0xD5E6 },
	{ 0xAF76,  0xC3DF },
	{ 0xAF77,  0xD5A3 },
	{ 0xAF78,  0xBED8 },
	{ 0xAF79,  0xC5E9 },
	{ 0xAF7A,  0xD5E8 },
	{ 0xAF7B,  0xD4D2 },
	{ 0xAF7C,  0xEDC0 },
	{ 0xAF7D,  0xC6C6 },
	{ 0xAF7E,  0xC9E9 },
	{ 0xAFA1,  0xEDC6 },
	{ 0xAFA2,  0xEDBE },
	{ 0xAFA3,  0xB35E },
	{ 0xAFA4,  0xEDC4 },
	{ 0xAFA5,  0xB368 },
	{ 0xAFA6,  0xB57A },
	{ 0xAFA7,  0xB576 },
	{ 0xAFA8,  0xECF4 },
	{ 0xAFA9,  0xCBEE },
	{ 0xAFAA,  0xD7E6 },
	{ 0xAFAB,  0xC9F1 },
	{ 0xAFAC,  0xD7A3 },
	{ 0xAFAD,  0xECF3 },
	{ 0xAFAE,  0xECF1 },
	{ 0xAFAF,  0xB3D3 },
	{ 0xAFB0,  0xEFF7 },
	{ 0xAFB1,  0xD1ED },
	{ 0xAFB2,  0xD7E2 },
	{ 0xAFB3,  0xC7D8 },
	{ 0xAFB4,  0xD6C8 },
	{ 0xAFB5,  0xC3D8 },
	{ 0xAFB6,  0xD5AD },
	{ 0xAFB7,  0xF1BA },
	{ 0xAFB8,  0xD5BE },
	{ 0xAFB9,  0xB0CA },
	{ 0xAFBA,  0xD0A6 },
	{ 0xAFBB,  0xB7DB },
	{ 0xAFBC,  0xBC8F },
	{ 0xAFBD,  0xBC86 },
	{ 0xAFBE,  0xBC79 },
	{ 0xAFBF,  0xCEC9 },
	{ 0xAFC0,  0xCBD8 },
	{ 0xAFC1,  0xCBF7 },
	{ 0xAFC2,  0xBC83 },
	{ 0xAFC3,  0xBC7E },
	{ 0xAFC4,  0xBC84 },
	{ 0xAFC5,  0xBC89 },
	{ 0xAFC6,  0xBC8B },
	{ 0xAFC7,  0xBC7B },
	{ 0xAFC8,  0xBC88 },
	{ 0xAFC9,  0xBC8A },
	{ 0xAFCA,  0xC8B1 },
	{ 0xAFCB,  0xEEB9 },
	{ 0xAFCC,  0xB8E1 },
	{ 0xAFCD,  0xB3E1 },
	{ 0xAFCE,  0xCECC },
	{ 0xAFCF,  0xEAC8 },
	{ 0xAFD0,  0xD4C5 },
	{ 0xAFD1,  0xB8FB },
	{ 0xAFD2,  0xB0D2 },
	{ 0xAFD3,  0xBAC4 },
	{ 0xAFD4,  0xB5A2 },
	{ 0xAFD5,  0xB9A2 },
	{ 0xAFD6,  0xEBD7 },
	{ 0xAFD7,  0xD6AC },
	{ 0xAFD8,  0xD2C8 },
	{ 0xAFD9,  0xC37B },
	{ 0xAFDA,  0xEBD9 },
	{ 0xAFDB,  0xEBD8 },
	{ 0xAFDC,  0xB4E0 },
	{ 0xAFDD,  0xD0D8 },
	{ 0xAFDE,  0xB8EC },
	{ 0xAFDF,  0xC37D },
	{ 0xAFE0,  0xC4DC },
	{ 0xAFE1,  0xBCB9 },
	{ 0xAFE2,  0xEBDD },
	{ 0xAFE3,  0xBFE8 },
	{ 0xAFE4,  0xB3F4 },
	{ 0xAFE5,  0xF4AB },
	{ 0xAFE6,  0xD2A8 },
	{ 0xAFE7,  0xF3C2 },
	{ 0xAFE8,  0xBABD },
	{ 0xAFE9,  0xF4B3 },
	{ 0xAFEA,  0xF4B2 },
	{ 0xAFEB,  0xB0E3 },
	{ 0xAFEC,  0xC663 },
	{ 0xAFED,  0xC3A3 },
	{ 0xAFEE,  0xBBC4 },
	{ 0xAFEF,  0xC0F3 },
	{ 0xAFF0,  0xC747 },
	{ 0xAFF1,  0xC8D7 },
	{ 0xAFF2,  0xBCF6 },
	{ 0xAFF3,  0xB2DD },
	{ 0xAFF4,  0xD2F0 },
	{ 0xAFF5,  0xDCEE },
	{ 0xAFF6,  0xDCF3 },
	{ 0xAFF7,  0xC69D },
	{ 0xAFF8,  0xC8E3 },
	{ 0xAFF9,  0xB2E8 },
	{ 0xAFFA,  0xDCF8 },
	{ 0xAFFB,  0xDCF7 },
	{ 0xAFFC,  0xDCEF },
	{ 0xAFFD,  0xB4C4 },
	{ 0xAFFE,  0xDCF5 },
	{ 0xB040,  0xF2AF },
	{ 0xB041,  0xCEC3 },
	{ 0xB042,  0xF2BD },
	{ 0xB043,  0xF2BE },
	{ 0xB044,  0xD4E9 },
	{ 0xB045,  0xF2BF },
	{ 0xB046,  0xB0F6 },
	{ 0xB047,  0xF2BC },
	{ 0xB048,  0xD1C1 },
	{ 0xB049,  0xCBA5 },
	{ 0xB04A,  0xD6D4 },
	{ 0xB04B,  0xD4AC },
	{ 0xB04C,  0xF1C7 },
	{ 0xB04D,  0xF1C5 },
	{ 0xB04E,  0xD07D },
	{ 0xB04F,  0xD39B },
	{ 0xB050,  0xD393 },
	{ 0xB051,  0xD391 },
	{ 0xB052,  0xD38F },
	{ 0xB053,  0xD398 },
	{ 0xB054,  0xD38D },
	{ 0xB055,  0xD39A },
	{ 0xB056,  0xD396 },
	{ 0xB057,  0xD399 },
	{ 0xB058,  0xD392 },
	{ 0xB059,  0xD394 },
	{ 0xB05A,  0xD84D },
	{ 0xB05B,  0xB2F2 },
	{ 0xB05C,  0xB1AA },
	{ 0xB05D,  0xD894 },
	{ 0xB05E,  0xD895 },
	{ 0xB05F,  0xC6F0 },
	{ 0xB060,  0xB9AA },
	{ 0xB061,  0xDC8E },
	{ 0xB062,  0xDC90 },
	{ 0xB063,  0xDC8B },
	{ 0xB064,  0xC8E8 },
	{ 0xB065,  0xCBCD },
	{ 0xB066,  0xC4E6 },
	{ 0xB067,  0xC3D4 },
	{ 0xB068,  0xCDCB },
	{ 0xB069,  0xDE95 },
	{ 0xB06A,  0xDE92 },
	{ 0xB06B,  0xCCD3 },
	{ 0xB06C,  0xD7B7 },
	{ 0xB06D,  0xE5CB },
	{ 0xB06E,  0xB1C5 },
	{ 0xB06F,  0xE7DF },
	{ 0xB070,  0xBFA4 },
	{ 0xB071,  0xBAC2 },
	{ 0xB072,  0xDBAB },
	{ 0xB073,  0xBEC6 },
	{ 0xB074,  0xC5E4 },
	{ 0xB075,  0xD7C3 },
	{ 0xB076,  0xE194 },
	{ 0xB077,  0xE198 },
	{ 0xB078,  0xE193 },
	{ 0xB079,  0xB8AA },
	{ 0xB07A,  0xE195 },
	{ 0xB07B,  0xE957 },
	{ 0xB07C,  0xD4BA },
	{ 0xB07D,  0xEA87 },
	{ 0xB07E,  0xB6B8 },
	{ 0xB0A1,  0xB1DD },
	{ 0xB0A2,  0xEA84 },
	{ 0xB0A3,  0xB3FD },
	{ 0xB0A4,  0xEA80 },
	{ 0xB0A5,  0xEA85 },
	{ 0xB0A6,  0xEB62 },
	{ 0xB0A7,  0xEF7C },
	{ 0xB0A8,  0xF152 },
	{ 0xB0A9,  0xB9C7 },
	{ 0xB0AA,  0xB8DF },
	{ 0xB0AB,  0xF459 },
	{ 0xB0AC,  0xD8AA },
	{ 0xB0AD,  0xB9ED },
	{ 0xB0AE,  0xC7AC },
	{ 0xB0AF,  0x82CC },
	{ 0xB0B0,  0x82CE },
	{ 0xB0B1,  0xCDA3 },
	{ 0xB0B2,  0xBCD9 },
	{ 0xB0B3,  0xD9C8 },
	{ 0xB0B4,  0xD9BC },
	{ 0xB0B5,  0xD7F6 },
	{ 0xB0B6,  0x82A5 },
	{ 0xB0B7,  0xBDA1 },
	{ 0xB0B8,  0xC5BC },
	{ 0xB0B9,  0xD9CB },
	{ 0xB0BA,  0xD9C9 },
	{ 0xB0BB,  0x82C9 },
	{ 0xB0BC,  0x82C8 },
	{ 0xB0BD,  0xCDB5 },
	{ 0xB0BE,  0xC6AB },
	{ 0xB0BF,  0xD9BF },
	{ 0xB0C0,  0x82C3 },
	{ 0xB0C1,  0x82C1 },
	{ 0xB0C2,  0xB6B5 },
	{ 0xB0C3,  0xC3E1 },
	{ 0xB0C4,  0xBBCB },
	{ 0xB0C5,  0xBCF4 },
	{ 0xB0C6,  0xB8B1 },
	{ 0xB0C7,  0xC0D5 },
	{ 0xB0C8,  0x84D5 },
	{ 0xB0C9,  0xBFB1 },
	{ 0xB0CA,  0x84D3 },
	{ 0xB0CB,  0xD9EB },
	{ 0xB0CC,  0xDECB },
	{ 0xB0CD,  0xB3D7 },
	{ 0xB0CE,  0xC4E4 },
	{ 0xB0CF,  0x855E },
	{ 0xB0D0,  0xD8D2 },
	{ 0xB0D1,  0x85A2 },
	{ 0xB0D2,  0xC2FC },
	{ 0xB0D3,  0xC9CC },
	{ 0xB0D4,  0xC5BE },
	{ 0xB0D5,  0xC0B2 },
	{ 0xB0D6,  0xD7C4 },
	{ 0xB0D7,  0x86A1 },
	{ 0xB0D8,  0xB7C8 },
	{ 0xB0D9,  0xBFD0 },
	{ 0xB0DA,  0xB0A1 },
	{ 0xB0DB,  0xB3AA },
	{ 0xB0DC,  0xE0A2 },
	{ 0xB0DD,  0x8696 },
	{ 0xB0DE,  0xDFFB },
	{ 0xB0DF,  0xCEA8 },
	{ 0xB0E0,  0xC6A1 },
	{ 0xB0E1,  0x8688 },
	{ 0xB0E2,  0xCADB },
	{ 0xB0E3,  0xE0A8 },
	{ 0xB0E4,  0xBBA3 },
	{ 0xB0E5,  0x86A5 },
	{ 0xB0E6,  0xE0A6 },
	{ 0xB0E7,  0xDFFA },
	{ 0xB0E8,  0x869B },
	{ 0xB0E9,  0xC8A6 },
	{ 0xB0EA,  0x87F8 },
	{ 0xB0EB,  0xE0F6 },
	{ 0xB0EC,  0xD3F2 },
	{ 0xB0ED,  0x88D4 },
	{ 0xB0EE,  0x88D7 },
	{ 0xB0EF,  0xB6D1 },
	{ 0xB0F0,  0xB2BA },
	{ 0xB0F1,  0xDBFD },
	{ 0xB0F2,  0xBBF9 },
	{ 0xB0F3,  0xCCC3 },
	{ 0xB0F4,  0xB6C2 },
	{ 0xB0F5,  0x88CC },
	{ 0xB0F6,  0xC5E0 },
	{ 0xB0F7,  0x89F2 },
	{ 0xB0F8,  0xC9DD },
	{ 0xB0F9,  0xC8A2 },
	{ 0xB0FA,  0x8AE4 },
	{ 0xB0FB,  0xCDF1 },
	{ 0xB0FC,  0x8B44 },
	{ 0xB0FD,  0xC0B7 },
	{ 0xB0FE,  0xE6B9 },
	{ 0xB140,  0xE6BD },
	{ 0xB141,  0xE6BE },
	{ 0xB142,  0xBBE9 },
	{ 0xB143,  0xC6C5 },
	{ 0xB144,  0xE6BB },
	{ 0xB145,  0xCAEB },
	{ 0xB146,  0xBFDC },
	{ 0xB147,  0xD2FA },
	{ 0xB148,  0xBCC4 },
	{ 0xB149,  0xBCC5 },
	{ 0xB14A,  0xCBDE },
	{ 0xB14B,  0xC3DC },
	{ 0xB14C,  0xCEBE },
	{ 0xB14D,  0x8CA3 },
	{ 0xB14E,  0x8CA2 },
	{ 0xB14F,  0xCDC0 },
	{ 0xB150,  0x8CCF },
	{ 0xB151,  0x8CD0 },
	{ 0xB152,  0xB3E7 },
	{ 0xB153,  0xE1C7 },
	{ 0xB154,  0xC6E9 },
	{ 0xB155,  0xE1C8 },
	{ 0xB156,  0xD1C2 },
	{ 0xB157,  0x8D98 },
	{ 0xB158,  0x8D8B },
	{ 0xB159,  0xB1C0 },
	{ 0xB15A,  0xB4DE },
	{ 0xB15B,  0x8D91 },
	{ 0xB15C,  0xE1C5 },
	{ 0xB15D,  0xE1C2 },
	{ 0xB15E,  0x8D8F },
	{ 0xB15F,  0xB3B2 },
	{ 0xB160,  0xB3A3 },
	{ 0xB161,  0x8EA7 },
	{ 0xB162,  0x8EA4 },
	{ 0xB163,  0xE1A1 },
	{ 0xB164,  0xBFB5 },
	{ 0xB165,  0xD3B9 },
	{ 0xB166,  0xCAFC },
	{ 0xB167,  0xE2D6 },
	{ 0xB168,  0xE2D7 },
	{ 0xB169,  0x8F88 },
	{ 0xB16A,  0x8F8A },
	{ 0xB16B,  0xE5E7 },
	{ 0xB16C,  0xB1F2 },
	{ 0xB16D,  0xB2CA },
	{ 0xB16E,  0x8FAC },
	{ 0xB16F,  0xB5C3 },
	{ 0xB170,  0xE1E3 },
	{ 0xB171,  0x8FC4 },
	{ 0xB172,  0xC5C7 },
	{ 0xB173,  0xD3F9 },
	{ 0xB174,  0x8FC6 },
	{ 0xB175,  0xE1E4 },
	{ 0xB176,  0xD3C1 },
	{ 0xB177,  0xBBBC },
	{ 0xB178,  0xCFA4 },
	{ 0xB179,  0xD3C6 },
	{ 0xB17A,  0xC4FA },
	{ 0xB17B,  0xCDEF },
	{ 0xB17C,  0xE3B2 },
	{ 0xB17D,  0xB5EB },
	{ 0xB17E,  0x90A2 },
	{ 0xB1A1,  0xC7E9 },
	{ 0xB1A2,  0xE3AC },
	{ 0xB1A3,  0x909D },
	{ 0xB1A4,  0xCFA7 },
	{ 0xB1A5,  0xB5BF },
	{ 0xB1A6,  0xE3AF },
	{ 0xB1A7,  0xCCE8 },
	{ 0xB1A8,  0xE3B0 },
	{ 0xB1A9,  0xCEA9 },
	{ 0xB1AA,  0xBCC2 },
	{ 0xB1AB,  0xE3B1 },
	{ 0xB1AC,  0x90AA },
	{ 0xB1AD,  0xC6DD },
	{ 0xB1AE,  0xEAA9 },
	{ 0xB1AF,  0xECE8 },
	{ 0xB1B0,  0xC2D3 },
	{ 0xB1B1,  0xBFD8 },
	{ 0xB1B2,  0x92D4 },
	{ 0xB1B3,  0xD2B4 },
	{ 0xB1B4,  0xCCBD },
	{ 0xB1B5,  0xBDD3 },
	{ 0xB1B6,  0xBDDD },
	{ 0xB1B7,  0xC5F5 },
	{ 0xB1B8,  0xBEF2 },
	{ 0xB1B9,  0xB4EB },
	{ 0xB1BA,  0xDEDF },
	{ 0xB1BB,  0xD1DA },
	{ 0xB1BC,  0xB5F4 },
	{ 0xB1BD,  0x92DF },
	{ 0xB1BE,  0x92EC },
	{ 0xB1BF,  0x92D0 },
	{ 0xB1C0,  0xCDC6 },
	{ 0xB1C1,  0x92E0 },
	{ 0xB1C2,  0xCADA },
	{ 0xB1C3,  0x92EA },
	{ 0xB1C4,  0x92F1 },
	{ 0xB1C5,  0xDEE4 },
	{ 0xB1C6,  0xC5C5 },
	{ 0xB1C7,  0xCCCD },
	{ 0xB1C8,  0xCFC6 },
	{ 0xB1C9,  0xC4ED },
	{ 0xB1CA,  0xDEE6 },
	{ 0xB1CB,  0x92CE },
	{ 0xB1CC,  0xDEE0 },
	{ 0xB1CD,  0xB1D6 },
	{ 0xB1CE,  0xB0BD },
	{ 0xB1CF,  0xBEC8 },
	{ 0xB1D0,  0xBDCC },
	{ 0xB1D1,  0x94A1 },
	{ 0xB1D2,  0x86A2 },
	{ 0xB1D3,  0xC3F4 },
	{ 0xB1D4,  0x94A2 },
	{ 0xB1D5,  0xEBB7 },
	{ 0xB1D6,  0x94A0 },
	{ 0xB1D7,  0xD0B1 },
	{ 0xB1D8,  0xF5FA },
	{ 0xB1D9,  0x94D8 },
	{ 0xB1DA,  0xD7E5 },
	{ 0xB1DB,  0xD0FD },
	{ 0xB1DC,  0xECBA },
	{ 0xB1DD,  0xECBB },
	{ 0xB1DE,  0x9583 },
	{ 0xB1DF,  0xCDED },
	{ 0xB1E0,  0xCEEE },
	{ 0xB1E1,  0xB3BF },
	{ 0xB1E2,  0xBBDE },
	{ 0xB1E3,  0x9584 },
	{ 0xB1E4,  0xB2DC },
	{ 0xB1E5,  0x84D4 },
	{ 0xB1E6,  0xCDFB },
	{ 0xB1E7,  0xC1BA },
	{ 0xB1E8,  0xCCDD },
	{ 0xB1E9,  0xC9D2 },
	{ 0xB1EA,  0xE8F7 },
	{ 0xB1EB,  0xE8F3 },
	{ 0xB1EC,  0x9755 },
	{ 0xB1ED,  0xCDB0 },
	{ 0xB1EE,  0x9779 },
	{ 0xB1EF,  0xCEE0 },
	{ 0xB1F0,  0xB9A3 },
	{ 0xB1F1,  0xD0B5 },
	{ 0xB1F2,  0xE8E8 },
	{ 0xB1F3,  0x9789 },
	{ 0xB1F4,  0xCBF3 },
	{ 0xB1F5,  0xB0F0 },
	{ 0xB1F6,  0xC3B7 },
	{ 0xB1F7,  0x9764 },
	{ 0xB1F8,  0x976C },
	{ 0xB1F9,  0xC0E6 },
	{ 0xB1FA,  0x976E },
	{ 0xB1FB,  0x9770 },
	{ 0xB1FC,  0x9757 },
	{ 0xB1FD,  0xD3FB },
	{ 0xB1FE,  0x9AA2 },
	{ 0xB240,  0xBAC1 },
	{ 0xB241,  0x9AC2 },
	{ 0xB242,  0x9AE4 },
	{ 0xB243,  0xCFD1 },
	{ 0xB244,  0x9BF6 },
	{ 0xB245,  0xB4BE },
	{ 0xB246,  0xE4C8 },
	{ 0xB247,  0xD2BA },
	{ 0xB248,  0xB5AD },
	{ 0xB249,  0xCCCA },
	{ 0xB24A,  0xD3D9 },
	{ 0xB24B,  0xCCED },
	{ 0xB24C,  0x9C5C },
	{ 0xB24D,  0xC7E5 },
	{ 0xB24E,  0xE4BF },
	{ 0xB24F,  0xC1DC },
	{ 0xB250,  0xD1C4 },
	{ 0xB251,  0xCAE7 },
	{ 0xB252,  0xE4CC },
	{ 0xB253,  0xE4C1 },
	{ 0xB254,  0xD1CD },
	{ 0xB255,  0xBAD4 },
	{ 0xB256,  0xBBEC },
	{ 0xB257,  0x9C59 },
	{ 0xB258,  0xE4C0 },
	{ 0xB259,  0x9C44 },
	{ 0xB25A,  0xE4BE },
	{ 0xB25B,  0xBAAD },
	{ 0xB25C,  0x9C49 },
	{ 0xB25D,  0xD2F9 },
	{ 0xB25E,  0xCCD4 },
	{ 0xB25F,  0x9C53 },
	{ 0xB260,  0xC9EE },
	{ 0xB261,  0xBBB4 },
	{ 0xB262,  0x9C51 },
	{ 0xB263,  0xCFFD },
	{ 0xB264,  0xD7CD },
	{ 0xB265,  0xB8A2 },
	{ 0xB266,  0xB4E3 },
	{ 0xB267,  0xE4C3 },
	{ 0xB268,  0xE4C6 },
	{ 0xB269,  0xC5EB },
	{ 0xB26A,  0xD1C9 },
	{ 0xB26B,  0xBAB8 },
	{ 0xB26C,  0xB7E9 },
	{ 0xB26D,  0xCFA9 },
	{ 0xB26E,  0xCBAC },
	{ 0xB26F,  0xA0BF },
	{ 0xB270,  0xC0E7 },
	{ 0xB271,  0xB2C2 },
	{ 0xB272,  0xC3CD },
	{ 0xB273,  0xB2FE },
	{ 0xB274,  0xE2A3 },
	{ 0xB275,  0xAA62 },
	{ 0xB276,  0xC2CA },
	{ 0xB277,  0xC0C5 },
	{ 0xB278,  0xE7F0 },
	{ 0xB279,  0xC7F2 },
	{ 0xB27A,  0xC0ED },
	{ 0xB27B,  0xAC46 },
	{ 0xB27C,  0xAC50 },
	{ 0xB27D,  0xF0AD },
	{ 0xB27E,  0xC6BF },
	{ 0xB2A1,  0xB4C9 },
	{ 0xB2A2,  0xCCF0 },
	{ 0xB2A3,  0xAE61 },
	{ 0xB2A4,  0xC2D4 },
	{ 0xB2A5,  0xC6E8 },
	{ 0xB2A6,  0xAE85 },
	{ 0xB2A7,  0xAE90 },
	{ 0xB2A8,  0xCAE8 },
	{ 0xB2A9,  0xD6CC },
	{ 0xB2AA,  0xBADB },
	{ 0xB2AB,  0xB4C3 },
	{ 0xB2AC,  0xC8AC },
	{ 0xB2AD,  0xF0EA },
	{ 0xB2AE,  0xF0A8 },
	{ 0xB2AF,  0xBFF8 },
	{ 0xB2B0,  0xBAD0 },
	{ 0xB2B1,  0xCAA2 },
	{ 0xB2B2,  0xBEEC },
	{ 0xB2B3,  0xB18A },
	{ 0xB2B4,  0xD1DB },
	{ 0xB2B5,  0xBFF4 },
	{ 0xB2B6,  0xEDF8 },
	{ 0xB2B7,  0xCCF7 },
	{ 0xB2B8,  0xC1F2 },
	{ 0xB2B9,  0xB370 },
	{ 0xB2BA,  0xEDCA },
	{ 0xB2BB,  0xCFE9 },
	{ 0xB2BC,  0xC6B1 },
	{ 0xB2BD,  0xBCC0 },
	{ 0xB2BE,  0xD2C6 },
	{ 0xB2BF,  0xD6CF },
	{ 0xB2C0,  0xF1BB },
	{ 0xB2C1,  0xF3D2 },
	{ 0xB2C2,  0xB1BF },
	{ 0xB2C3,  0xB5D1 },
	{ 0xB2C4,  0xB5DA },
	{ 0xB2C5,  0xB7FB },
	{ 0xB2C6,  0xF3CF },
	{ 0xB2C7,  0xF3D7 },
	{ 0xB2C8,  0xF3D0 },
	{ 0xB2C9,  0xC1A3 },
	{ 0xB2CA,  0xB4D6 },
	{ 0xB2CB,  0xC6C9 },
	{ 0xB2CC,  0xBD4F },
	{ 0xB2CD,  0xBD4C },
	{ 0xB2CE,  0xBD79 },
	{ 0xB2CF,  0xBC99 },
	{ 0xB2D0,  0xBD42 },
	{ 0xB2D1,  0xBD45 },
	{ 0xB2D2,  0xBD49 },
	{ 0xB2D3,  0xBC9A },
	{ 0xB2D4,  0xBC9D },
	{ 0xB2D5,  0xBD4D },
	{ 0xB2D6,  0xC0DB },
	{ 0xB2D7,  0xBD4B },
	{ 0xB2D8,  0xBC9C },
	{ 0xB2D9,  0xBC9B },
	{ 0xB2DA,  0xC08F },
	{ 0xB2DB,  0xD0DF },
	{ 0xB2DC,  0xC1E7 },
	{ 0xB2DD,  0xD2EE },
	{ 0xB2DE,  0xF4E1 },
	{ 0xB2DF,  0xC195 },
	{ 0xB2E0,  0xF1EA },
	{ 0xB2E1,  0xC1C4 },
	{ 0xB2E2,  0xF1F6 },
	{ 0xB2E3,  0xB8AC },
	{ 0xB2E4,  0xB2B1 },
	{ 0xB2E5,  0xC38B },
	{ 0xB2E6,  0xC393 },
	{ 0xB2E7,  0xC391 },
	{ 0xB2E8,  0xC396 },
	{ 0xB2E9,  0xC38C },
	{ 0xB2EA,  0xF4A9 },
	{ 0xB2EB,  0xB6E6 },
	{ 0xB2EC,  0xCFCF },
	{ 0xB2ED,  0xB2B0 },
	{ 0xB2EE,  0xB4AC },
	{ 0xB2EF,  0xC9AF },
	{ 0xB2F0,  0xDDB8 },
	{ 0xB2F1,  0xDDB7 },
	{ 0xB2F2,  0xDDA9 },
	{ 0xB2F3,  0xC776 },
	{ 0xB2F4,  0xC76F },
	{ 0xB2F5,  0xC3A7 },
	{ 0xB2F6,  0xC4AA },
	{ 0xB2F7,  0xDCEC },
	{ 0xB2F8,  0xC766 },
	{ 0xB2F9,  0xDDAE },
	{ 0xB2FA,  0xC0F2 },
	{ 0xB2FB,  0xDDAC },
	{ 0xB2FC,  0xBAC9 },
	{ 0xB2FD,  0xDDB6 },
	{ 0xB2FE,  0xDDB1 },
	{ 0xB340,  0xC6CE },
	{ 0xB341,  0xC77B },
	{ 0xB342,  0xCC8E },
	{ 0xB343,  0xB1EB },
	{ 0xB344,  0xC9DF },
	{ 0xB345,  0xD6FB },
	{ 0xB346,  0xF2C0 },
	{ 0xB347,  0xF2C1 },
	{ 0xB348,  0xF2C2 },
	{ 0xB349,  0xC7F9 },
	{ 0xB34A,  0xB5B0 },
	{ 0xB34B,  0xF2C6 },
	{ 0xB34C,  0xF2C7 },
	{ 0xB34D,  0xF2C8 },
	{ 0xB34E,  0xD067 },
	{ 0xB34F,  0xD096 },
	{ 0xB350,  0xF4C2 },
	{ 0xB351,  0xB1BB },
	{ 0xB352,  0xCCBB },
	{ 0xB353,  0xD0E4 },
	{ 0xB354,  0xC5DB },
	{ 0xB355,  0xB4FC },
	{ 0xB356,  0xD292 },
	{ 0xB357,  0xD28E },
	{ 0xB358,  0xD44C },
	{ 0xB359,  0xD3A0 },
	{ 0xB35A,  0xD445 },
	{ 0xB35B,  0xD447 },
	{ 0xB35C,  0xD453 },
	{ 0xB35D,  0xD44F },
	{ 0xB35E,  0xD441 },
	{ 0xB35F,  0xD39E },
	{ 0xB360,  0xD444 },
	{ 0xB361,  0xF4F9 },
	{ 0xB362,  0xEBE0 },
	{ 0xB363,  0xD89C },
	{ 0xB364,  0xD89F },
	{ 0xB365,  0xD89E },
	{ 0xB366,  0xD89B },
	{ 0xB367,  0xD89D },
	{ 0xB368,  0xD89A },
	{ 0xB369,  0xF4F6 },
	{ 0xB36A,  0xC9E2 },
	{ 0xB36B,  0xD6BA },
	{ 0xB36C,  0xF5C3 },
	{ 0xB36D,  0xDC97 },
	{ 0xB36E,  0xDC9B },
	{ 0xB36F,  0xDF40 },
	{ 0xB370,  0xE5D0 },
	{ 0xB371,  0xCDA8 },
	{ 0xB372,  0xB6BA },
	{ 0xB373,  0xDF42 },
	{ 0xB374,  0xCBD9 },
	{ 0xB375,  0xCAC5 },
	{ 0xB376,  0xD6F0 },
	{ 0xB377,  0xDE9F },
	{ 0xB378,  0xB3D1 },
	{ 0xB379,  0xD4EC },
	{ 0xB37A,  0xCDB8 },
	{ 0xB37B,  0xB7EA },
	{ 0xB37C,  0xE5D1 },
	{ 0xB37D,  0xB9E4 },
	{ 0xB37E,  0xCDBE },
	{ 0xB3A1,  0xB2BF },
	{ 0xB3A2,  0xB9F9 },
	{ 0xB3A3,  0xB6BC },
	{ 0xB3A4,  0xD0EF },
	{ 0xB3A5,  0xD2B0 },
	{ 0xB3A6,  0xE24F },
	{ 0xB3A7,  0xE240 },
	{ 0xB3A8,  0xE19E },
	{ 0xB3A9,  0xE241 },
	{ 0xB3AA,  0xE247 },
	{ 0xB3AB,  0xE243 },
	{ 0xB3AC,  0xE95D },
	{ 0xB3AD,  0xC5E3 },
	{ 0xB3AE,  0xC1EA },
	{ 0xB3AF,  0xEA90 },
	{ 0xB3B0,  0xEA91 },
	{ 0xB3B1,  0xEA8E },
	{ 0xB3B2,  0xDAF0 },
	{ 0xB3B3,  0xCCD5 },
	{ 0xB3B4,  0xCFDD },
	{ 0xB3B5,  0xDAEE },
	{ 0xB3B6,  0xC8B8 },
	{ 0xB3B7,  0xD1A9 },
	{ 0xB3B8,  0xF6A7 },
	{ 0xB3B9,  0xD5C2 },
	{ 0xB3BA,  0xBEB9 },
	{ 0xB3BB,  0xED94 },
	{ 0xB3BC,  0xED95 },
	{ 0xB3BD,  0xF47E },
	{ 0xB3BE,  0xF842 },
	{ 0xB3BF,  0xFB75 },
	{ 0xB3C0,  0xC2B9 },
	{ 0xB3C1,  0xFB9C },
	{ 0xB3C2,  0xC2E9 },
	{ 0xB3C3,  0x82ED },
	{ 0xB3C4,  0xB0F8 },
	{ 0xB3C5,  0xB8B5 },
	{ 0xB3C6,  0x82E4 },
	{ 0xB3C7,  0x82DC },
	{ 0xB3C8,  0xBFFE },
	{ 0xB3C9,  0x82E1 },
	{ 0xB3CA,  0x82E3 },
	{ 0xB3CB,  0x82E5 },
	{ 0xB3CC,  0xD7EE },
	{ 0xB3CD,  0x8450 },
	{ 0xB3CE,  0xB8EE },
	{ 0xB3CF,  0x8492 },
	{ 0xB3D0,  0x8493 },
	{ 0xB3D1,  0xCAA3 },
	{ 0xB3D2,  0x84DA },
	{ 0xB3D3,  0x84D9 },
	{ 0xB3D4,  0x84D7 },
	{ 0xB3D5,  0xB2A9 },
	{ 0xB3D6,  0xD8CA },
	{ 0xB3D7,  0xE0B4 },
	{ 0xB3D8,  0xBFA6 },
	{ 0xB3D9,  0xD0FA },
	{ 0xB3DA,  0xCCE4 },
	{ 0xB3DB,  0xBAB0 },
	{ 0xB3DC,  0xBAC8 },
	{ 0xB3DD,  0xB4AD },
	{ 0xB3DE,  0xCEB9 },
	{ 0xB3DF,  0xCFB2 },
	{ 0xB3E0,  0x86CA },
	{ 0xB3E1,  0xE0B8 },
	{ 0xB3E2,  0xC0AE },
	{ 0xB3E3,  0xE0A9 },
	{ 0xB3E4,  0xE0AB },
	{ 0xB3E5,  0xD4FB },
	{ 0xB3E6,  0x86CE },
	{ 0xB3E7,  0xE0B0 },
	{ 0xB3E8,  0xCDD9 },
	{ 0xB3E9,  0x86D1 },
	{ 0xB3EA,  0x86BE },
	{ 0xB3EB,  0xD3F7 },
	{ 0xB3EC,  0x86CC },
	{ 0xB3ED,  0xE0AC },
	{ 0xB3EE,  0xE0B1 },
	{ 0xB3EF,  0xBAED },
	{ 0xB3F0,  0x86CB },
	{ 0xB3F1,  0xE0B9 },
	{ 0xB3F2,  0x87FA },
	{ 0xB3F3,  0x88F2 },
	{ 0xB3F4,  0xBFB0 },
	{ 0xB3F5,  0x88F6 },
	{ 0xB3F6,  0xB5CC },
	{ 0xB3F7,  0xD1DF },
	{ 0xB3F8,  0x88F3 },
	{ 0xB3F9,  0xB1A4 },
	{ 0xB3FA,  0x88E5 },
	{ 0xB3FB,  0xDCA9 },
	{ 0xB3FC,  0xD2BC },
	{ 0xB3FD,  0x89D8 },
	{ 0xB3FE,  0xB5EC },
	{ 0xB440,  0xE6C3 },
	{ 0xB441,  0xC3C4 },
	{ 0xB442,  0xD0F6 },
	{ 0xB443,  0xC3BD },
	{ 0xB444,  0xE6C2 },
	{ 0xB445,  0x8B7A },
	{ 0xB446,  0xE6DC },
	{ 0xB447,  0xE5EE },
	{ 0xB448,  0xBAAE },
	{ 0xB449,  0xB8BB },
	{ 0xB44A,  0xD4A2 },
	{ 0xB44B,  0xC3C2 },
	{ 0xB44C,  0xD7F0 },
	{ 0xB44D,  0x8CA4 },
	{ 0xB44E,  0xBECD },
	{ 0xB44F,  0xC7B6 },
	{ 0xB450,  0x8DB9 },
	{ 0xB451,  0xE1CB },
	{ 0xB452,  0xEFFA },
	{ 0xB453,  0xD9E3 },
	{ 0xB454,  0xB7F9 },
	{ 0xB455,  0xC3B1 },
	{ 0xB456,  0x8EAC },
	{ 0xB457,  0x8EAE },
	{ 0xB458,  0x8ED7 },
	{ 0xB459,  0xC0C8 },
	{ 0xB45A,  0x8EFA },
	{ 0xB45B,  0x8EFB },
	{ 0xB45C,  0x8EFD },
	{ 0xB45D,  0xE5F6 },
	{ 0xB45E,  0xC5ED },
	{ 0xB45F,  0x8FCD },
	{ 0xB460,  0xD1AD },
	{ 0xB461,  0xE1E5 },
	{ 0xB462,  0xBBF3 },
	{ 0xB463,  0x90BA },
	{ 0xB464,  0xB1AF },
	{ 0xB465,  0x909E },
	{ 0xB466,  0xBBDD },
	{ 0xB467,  0x90DC },
	{ 0xB468,  0xE3B6 },
	{ 0xB469,  0xD0CA },
	{ 0xB46A,  0xE3B5 },
	{ 0xB46B,  0xB6E8 },
	{ 0xB46C,  0x90C5 },
	{ 0xB46D,  0xE3B7 },
	{ 0xB46E,  0xBFAE },
	{ 0xB46F,  0x90C0 },
	{ 0xB470,  0xE3B9 },
	{ 0xB471,  0xBBCC },
	{ 0xB472,  0xD3E4 },
	{ 0xB473,  0xE3B8 },
	{ 0xB474,  0x90D4 },
	{ 0xB475,  0xEAAA },
	{ 0xB476,  0xECE9 },
	{ 0xB477,  0xB3B8 },
	{ 0xB478,  0xD5C6 },
	{ 0xB479,  0xC3E8 },
	{ 0xB47A,  0x92FE },
	{ 0xB47B,  0xBFAB },
	{ 0xB47C,  0xC8E0 },
	{ 0xB47D,  0xDEF1 },
	{ 0xB47E,  0xD7E1 },
	{ 0xB4A1,  0xB2E5 },
	{ 0xB4A2,  0xB4A7 },
	{ 0xB4A3,  0xCCE1 },
	{ 0xB4A4,  0xCED5 },
	{ 0xB4A5,  0xD2BE },
	{ 0xB4A6,  0xBDD2 },
	{ 0xB4A7,  0x935D },
	{ 0xB4A8,  0xB4B7 },
	{ 0xB4A9,  0xD4AE },
	{ 0xB4AA,  0xBEBE },
	{ 0xB4AB,  0x9351 },
	{ 0xB4AC,  0xDEF0 },
	{ 0xB4AD,  0x9350 },
	{ 0xB4AE,  0x9364 },
	{ 0xB4AF,  0xB3A8 },
	{ 0xB4B0,  0xB6D8 },
	{ 0xB4B1,  0xB8D2 },
	{ 0xB4B2,  0xC9A2 },
	{ 0xB4B3,  0xB0DF },
	{ 0xB4B4,  0xECB3 },
	{ 0xB4B5,  0xCBB9 },
	{ 0xB4B6,  0xC6D5 },
	{ 0xB4B7,  0xCEFA },
	{ 0xB4B8,  0xC7E7 },
	{ 0xB4B9,  0xBEA7 },
	{ 0xB4BA,  0xBEB0 },
	{ 0xB4BB,  0xCAEE },
	{ 0xB4BC,  0xD6C7 },
	{ 0xB4BD,  0xC1C0 },
	{ 0xB4BE,  0xEAD0 },
	{ 0xB4BF,  0xD4F8 },
	{ 0xB4C0,  0xCCE6 },
	{ 0xB4C1,  0xC6DA },
	{ 0xB4C2,  0xB3AF },
	{ 0xB4C3,  0xB9D7 },
	{ 0xB4C4,  0xD7D8 },
	{ 0xB4C5,  0xCCC4 },
	{ 0xB4C6,  0xBCAC },
	{ 0xB4C7,  0x9797 },
	{ 0xB4C8,  0xD2CE },
	{ 0xB4C9,  0x979D },
	{ 0xB4CA,  0xBFC3 },
	{ 0xB4CB,  0xC9AD },
	{ 0xB4CC,  0x97A3 },
	{ 0xB4CD,  0xE8FE },
	{ 0xB4CE,  0xB0F4 },
	{ 0xB4CF,  0x97AB },
	{ 0xB4D0,  0xE9A6 },
	{ 0xB4D1,  0xC6E5 },
	{ 0xB4D2,  0xB9F7 },
	{ 0xB4D3,  0xD6B2 },
	{ 0xB4D4,  0xBDB7 },
	{ 0xB4D5,  0xD7B5 },
	{ 0xB4D6,  0xC3DE },
	{ 0xB4D7,  0xC5EF },
	{ 0xB4D8,  0xE8FA },
	{ 0xB4D9,  0x97B1 },
	{ 0xB4DA,  0xBFEE },
	{ 0xB4DB,  0xC6DB },
	{ 0xB4DC,  0x9A4A },
	{ 0xB4DD,  0x9A88 },
	{ 0xB4DE,  0xD6B3 },
	{ 0xB4DF,  0x9AA4 },
	{ 0xB4E0,  0xCCBA },
	{ 0xB4E1,  0xB5AA },
	{ 0xB4E2,  0xC2C8 },
	{ 0xB4E3,  0x9AE5 },
	{ 0xB4E4,  0xB8DB },
	{ 0xB4E5,  0xD3CE },
	{ 0xB4E6,  0xE4D5 },
	{ 0xB4E7,  0xB6C9 },
	{ 0xB4E8,  0xE4D6 },
	{ 0xB4E9,  0x9CA5 },
	{ 0xB4EA,  0x9C90 },
	{ 0xB4EB,  0xC7FE },
	{ 0xB4EC,  0xE4D7 },
	{ 0xB4ED,  0xD4FC },
	{ 0xB4EE,  0x9C70 },
	{ 0xB4EF,  0xD5BF },
	{ 0xB4F0,  0xCFE6 },
	{ 0xB4F1,  0xB2B3 },
	{ 0xB4F2,  0xBAFE },
	{ 0xB4F3,  0xE4CE },
	{ 0xB4F4,  0xCEBC },
	{ 0xB4F5,  0x9C75 },
	{ 0xB4F6,  0x9CAB },
	{ 0xB4F7,  0xBFCA },
	{ 0xB4F8,  0xCDC4 },
	{ 0xB4F9,  0xC3EC },
	{ 0xB4FA,  0x9C79 },
	{ 0xB4FB,  0xC5C8 },
	{ 0xB4FC,  0xD3E5 },
	{ 0xB4FD,  0x9C86 },
	{ 0xB4FE,  0xD7CC },
	{ 0xB540,  0xB8C8 },
	{ 0xB541,  0x9C6F },
	{ 0xB542,  0xE4CF },
	{ 0xB543,  0x9CA1 },
	{ 0xB544,  0xE4D8 },
	{ 0xB545,  0x9CAE },
	{ 0xB546,  0x9CA7 },
	{ 0xB547,  0xE4D2 },
	{ 0xB548,  0xB1BA },
	{ 0xB549,  0xB7D9 },
	{ 0xB54A,  0xBDB9 },
	{ 0xB54B,  0xD1E6 },
	{ 0xB54C,  0x9F6F },
	{ 0xB54D,  0xC8BB },
	{ 0xB54E,  0xD6F3 },
	{ 0xB54F,  0x9F6A },
	{ 0xB550,  0xC5C6 },
	{ 0xB551,  0xEAF7 },
	{ 0xB552,  0xCFAC },
	{ 0xB553,  0xAA71 },
	{ 0xB554,  0xE2AB },
	{ 0xB555,  0xBAEF },
	{ 0xB556,  0xD0C9 },
	{ 0xB557,  0xAC6D },
	{ 0xB558,  0xE7F7 },
	{ 0xB559,  0xC1D5 },
	{ 0xB55A,  0xD7C1 },
	{ 0xB55B,  0xE7FA },
	{ 0xB55C,  0xC5FD },
	{ 0xB55D,  0xC5C3 },
	{ 0xB55E,  0xC7D9 },
	{ 0xB55F,  0xAC67 },
	{ 0xB560,  0xE8A1 },
	{ 0xB561,  0xE7F9 },
	{ 0xB562,  0xE7FB },
	{ 0xB563,  0xC9FB },
	{ 0xB564,  0xAE64 },
	{ 0xB565,  0xAE8B },
	{ 0xB566,  0xB7AC },
	{ 0xB567,  0xC1A1 },
	{ 0xB568,  0xCDB4 },
	{ 0xB569,  0xF0EB },
	{ 0xB56A,  0xAF64 },
	{ 0xB56B,  0xB6BB },
	{ 0xB56C,  0xC6A6 },
	{ 0xB56D,  0xAF69 },
	{ 0xB56E,  0xB5C7 },
	{ 0xB56F,  0xB06C },
	{ 0xB570,  0xCDEE },
	{ 0xB571,  0xF0A9 },
	{ 0xB572,  0xF1E5 },
	{ 0xB573,  0xB149 },
	{ 0xB574,  0xB197 },
	{ 0xB575,  0xB6CC },
	{ 0xB576,  0xCFF5 },
	{ 0xB577,  0xD3B2 },
	{ 0xB578,  0xB38E },
	{ 0xB579,  0xC9D4 },
	{ 0xB57A,  0xB692 },
	{ 0xB57B,  0xB3CC },
	{ 0xB57C,  0xB690 },
	{ 0xB57D,  0xCFA1 },
	{ 0xB57E,  0xBEBD },
	{ 0xB5A1,  0xB4B0 },
	{ 0xB5A2,  0xBDD1 },
	{ 0xB5A3,  0xCDAF },
	{ 0xB5A4,  0xBFA2 },
	{ 0xB5A5,  0xB5C8 },
	{ 0xB5A6,  0xB2DF },
	{ 0xB5A7,  0xB950 },
	{ 0xB5A8,  0xBFF0 },
	{ 0xB5A9,  0xCDB2 },
	{ 0xB5AA,  0xB4F0 },
	{ 0xB5AB,  0xB953 },
	{ 0xB5AC,  0xBDEE },
	{ 0xB5AD,  0xB7A4 },
	{ 0xB5AE,  0xD6FE },
	{ 0xB5AF,  0xCBDA },
	{ 0xB5B0,  0xD6E0 },
	{ 0xB5B1,  0xBD67 },
	{ 0xB5B2,  0xBD59 },
	{ 0xB5B3,  0xBD71 },
	{ 0xB5B4,  0xBD5E },
	{ 0xB5B5,  0xD7CF },
	{ 0xB5B6,  0xD0F5 },
	{ 0xB5B7,  0xBD7A },
	{ 0xB5B8,  0xBD6A },
	{ 0xB5B9,  0xBD6F },
	{ 0xB5BA,  0xBD6B },
	{ 0xB5BB,  0xBD78 },
	{ 0xB5BC,  0xBD7B },
	{ 0xB5BD,  0xC9C6 },
	{ 0xB5BE,  0xCFE8 },
	{ 0xB5BF,  0xF4E2 },
	{ 0xB5C0,  0xF1F3 },
	{ 0xB5C1,  0xF1F8 },
	{ 0xB5C2,  0xC343 },
	{ 0xB5C3,  0xCDF3 },
	{ 0xB5C4,  0xC7BB },
	{ 0xB5C5,  0xD2B8 },
	{ 0xB5C6,  0xB8AD },
	{ 0xB5C7,  0xC449 },
	{ 0xB5C8,  0xC39B },
	{ 0xB5C9,  0xCCF3 },
	{ 0xB5CA,  0xC6A2 },
	{ 0xB5CB,  0xEBE7 },
	{ 0xB5CC,  0xEBE8 },
	{ 0xB5CD,  0xEBE9 },
	{ 0xB5CE,  0xCAE6 },
	{ 0xB5CF,  0xCBB4 },
	{ 0xB5D0,  0xC6D0 },
	{ 0xB5D1,  0xDDCD },
	{ 0xB5D2,  0xDDCE },
	{ 0xB5D3,  0xC6BC },
	{ 0xB5D4,  0xB2A4 },
	{ 0xB5D5,  0xDDD1 },
	{ 0xB5D6,  0xDDC2 },
	{ 0xB5D7,  0xDDBC },
	{ 0xB5D8,  0xC841 },
	{ 0xB5D9,  0xC1E2 },
	{ 0xB5DA,  0xC843 },
	{ 0xB5DB,  0xD6F8 },
	{ 0xB5DC,  0xC852 },
	{ 0xB5DD,  0xDDD4 },
	{ 0xB5DE,  0xC3C8 },
	{ 0xB5DF,  0xBEFA },
	{ 0xB5E0,  0xDDC4 },
	{ 0xB5E1,  0xB7C6 },
	{ 0xB5E2,  0xBED5 },
	{ 0xB5E3,  0xDDC7 },
	{ 0xB5E4,  0xCEAE },
	{ 0xB5E5,  0xCCD1 },
	{ 0xB5E6,  0xB2CB },
	{ 0xB5E7,  0xC84F },
	{ 0xB5E8,  0xDDCA },
	{ 0xB5E9,  0xDDCB },
	{ 0xB5EA,  0xCC93 },
	{ 0xB5EB,  0xF2D4 },
	{ 0xB5EC,  0xCDDC },
	{ 0xB5ED,  0xF2CE },
	{ 0xB5EE,  0xBBD7 },
	{ 0xB5EF,  0xD6EB },
	{ 0xB5F0,  0xB8F2 },
	{ 0xB5F1,  0xF2D0 },
	{ 0xB5F2,  0xF2D2 },
	{ 0xB5F3,  0xBDD6 },
	{ 0xB5F4,  0xB2C3 },
	{ 0xB5F5,  0xC1D1 },
	{ 0xB5F6,  0xB8A4 },
	{ 0xB5F7,  0xF1FB },
	{ 0xB5F8,  0xD295 },
	{ 0xB5F9,  0xD45D },
	{ 0xB5FA,  0xD481 },
	{ 0xB5FB,  0xD475 },
	{ 0xB5FC,  0xD47E },
	{ 0xB5FD,  0xD45E },
	{ 0xB5FE,  0xD462 },
	{ 0xB640,  0xD474 },
	{ 0xB641,  0xD47B },
	{ 0xB642,  0xD470 },
	{ 0xB643,  0xD467 },
	{ 0xB644,  0xD456 },
	{ 0xB645,  0xD45C },
	{ 0xB646,  0xD458 },
	{ 0xB647,  0xD476 },
	{ 0xB648,  0xCFF3 },
	{ 0xB649,  0xF5F5 },
	{ 0xB64A,  0xD941 },
	{ 0xB64B,  0xD94E },
	{ 0xB64C,  0xD945 },
	{ 0xB64D,  0xD94F },
	{ 0xB64E,  0xD953 },
	{ 0xB64F,  0xD94D },
	{ 0xB650,  0xD952 },
	{ 0xB651,  0xD946 },
	{ 0xB652,  0xD949 },
	{ 0xB653,  0xD948 },
	{ 0xB654,  0xD951 },
	{ 0xB655,  0xD94A },
	{ 0xB656,  0xD4BD },
	{ 0xB657,  0xB3AC },
	{ 0xB658,  0xB3C3 },
	{ 0xB659,  0xF5C9 },
	{ 0xB65A,  0xBEE0 },
	{ 0xB65B,  0xB0CF },
	{ 0xB65C,  0xF5C7 },
	{ 0xB65D,  0xC5DC },
	{ 0xB65E,  0xB5F8 },
	{ 0xB65F,  0xF5CB },
	{ 0xB660,  0xF5CC },
	{ 0xB661,  0xDD56 },
	{ 0xB662,  0xDD53 },
	{ 0xB663,  0xDD57 },
	{ 0xB664,  0xB9BC },
	{ 0xB665,  0xB4FE },
	{ 0xB666,  0xE5D3 },
	{ 0xB667,  0xDF4C },
	{ 0xB668,  0xD2DD },
	{ 0xB669,  0xDF4D },
	{ 0xB66A,  0xE5D4 },
	{ 0xB66B,  0xB6F5 },
	{ 0xB66C,  0xE05D },
	{ 0xB66D,  0xE06C },
	{ 0xB66E,  0xDBB1 },
	{ 0xB66F,  0xBAA8 },
	{ 0xB670,  0xCBD6 },
	{ 0xB671,  0xC1BF },
	{ 0xB672,  0xE26E },
	{ 0xB673,  0xE26F },
	{ 0xB674,  0xE27D },
	{ 0xB675,  0xE263 },
	{ 0xB676,  0xE278 },
	{ 0xB677,  0xE267 },
	{ 0xB678,  0xE26A },
	{ 0xB679,  0xE261 },
	{ 0xB67A,  0xE26B },
	{ 0xB67B,  0xE968 },
	{ 0xB67C,  0xE963 },
	{ 0xB67D,  0xE95F },
	{ 0xB67E,  0xE965 },
	{ 0xB6A1,  0xE967 },
	{ 0xB6A2,  0xE966 },
	{ 0xB6A3,  0xE962 },
	{ 0xB6A4,  0xEAA0 },
	{ 0xB6A5,  0xEB41 },
	{ 0xB6A6,  0xCBE5 },
	{ 0xB6A7,  0xEA96 },
	{ 0xB6A8,  0xD3E7 },
	{ 0xB6A9,  0xC2A1 },
	{ 0xB6AA,  0xDAF2 },
	{ 0xB6AB,  0xDAEF },
	{ 0xB6AC,  0xEA9D },
	{ 0xB6AD,  0xD1E3 },
	{ 0xB6AE,  0xD1C5 },
	{ 0xB6AF,  0xD0DB },
	{ 0xB6B0,  0xBCAF },
	{ 0xB6B1,  0xB9CD },
	{ 0xB6B2,  0xF6A9 },
	{ 0xB6B3,  0xEB85 },
	{ 0xB6B4,  0xED67 },
	{ 0xB6B5,  0xED97 },
	{ 0xB6B6,  0xED98 },
	{ 0xB6B7,  0xED9A },
	{ 0xB6B8,  0xE2B8 },
	{ 0xB6B9,  0xEF83 },
	{ 0xB6BA,  0xEF88 },
	{ 0xB6BB,  0xEF82 },
	{ 0xB6BC,  0xEF8B },
	{ 0xB6BD,  0xEF86 },
	{ 0xB6BE,  0xF154 },
	{ 0xB6BF,  0xF153 },
	{ 0xB6C0,  0xFC53 },
	{ 0xB6C1,  0xCAF2 },
	{ 0xB6C2,  0xBADA },
	{ 0xB6C3,  0x8179 },
	{ 0xB6C4,  0x82F2 },
	{ 0xB6C5,  0x82F9 },
	{ 0xB6C6,  0xB0C1 },
	{ 0xB6C7,  0x82F7 },
	{ 0xB6C8,  0x8348 },
	{ 0xB6C9,  0x8341 },
	{ 0xB6CA,  0xB4DF },
	{ 0xB6CB,  0x82FB },
	{ 0xB6CC,  0xC9B5 },
	{ 0xB6CD,  0x82F4 },
	{ 0xB6CE,  0x834A },
	{ 0xB6CF,  0xBDCB },
	{ 0xB6D0,  0x8495 },
	{ 0xB6D1,  0xD8E2 },
	{ 0xB6D2,  0xC4BC },
	{ 0xB6D3,  0x84E0 },
	{ 0xB6D4,  0xC7DA },
	{ 0xB6D5,  0x84DD },
	{ 0xB6D6,  0x84DE },
	{ 0xB6D7,  0x8552 },
	{ 0xB6D8,  0xE0B5 },
	{ 0xB6D9,  0xE0CB },
	{ 0xB6DA,  0xC9A4 },
	{ 0xB6DB,  0xE0C2 },
	{ 0xB6DC,  0x86E1 },
	{ 0xB6DD,  0xCAC8 },
	{ 0xB6DE,  0x86DD },
	{ 0xB6DF,  0xE0BE },
	{ 0xB6E0,  0xCBC3 },
	{ 0xB6E1,  0xE0CD },
	{ 0xB6E2,  0xE0C5 },
	{ 0xB6E3,  0x86E8 },
	{ 0xB6E4,  0xCECB },
	{ 0xB6E5,  0xD0E1 },
	{ 0xB6E6,  0x86DC },
	{ 0xB6E7,  0xE0C6 },
	{ 0xB6E8,  0xE0BC },
	{ 0xB6E9,  0x8840 },
	{ 0xB6EA,  0x8841 },
	{ 0xB6EB,  0xC8FB },
	{ 0xB6EC,  0xCBDC },
	{ 0xB6ED,  0xCCC1 },
	{ 0xB6EE,  0x8954 },
	{ 0xB6EF,  0x8956 },
	{ 0xB6F0,  0xCBFE },
	{ 0xB6F1,  0xCCEE },
	{ 0xB6F2,  0xCBFA },
	{ 0xB6F3,  0x8965 },
	{ 0xB6F4,  0x894B },
	{ 0xB6F5,  0x895D },
	{ 0xB6F6,  0x8950 },
	{ 0xB6F7,  0x894C },
	{ 0xB6F8,  0x8A57 },
	{ 0xB6F9,  0xBCDE },
	{ 0xB6FA,  0xBCB5 },
	{ 0xB6FB,  0xCFD3 },
	{ 0xB6FC,  0xE6C5 },
	{ 0xB6FD,  0x8B8C },
	{ 0xB6FE,  0x8B8B },
	{ 0xB740,  0xCFB1 },
	{ 0xB741,  0xC9A9 },
	{ 0xB742,  0xE6C7 },
	{ 0xB743,  0xE1D4 },
	{ 0xB744,  0xE1CF },
	{ 0xB745,  0xBBCF },
	{ 0xB746,  0x8ED6 },
	{ 0xB747,  0xC1AE },
	{ 0xB748,  0x8F42 },
	{ 0xB749,  0x8F73 },
	{ 0xB74A,  0x8FA1 },
	{ 0xB74B,  0x8FCF },
	{ 0xB74C,  0xCEA2 },
	{ 0xB74D,  0xD3DE },
	{ 0xB74E,  0xD2E2 },
	{ 0xB74F,  0xB4C8 },
	{ 0xB750,  0xB8D0 },
	{ 0xB751,  0xCFEB },
	{ 0xB752,  0x90DB },
	{ 0xB753,  0xC8C7 },
	{ 0xB754,  0xB3EE },
	{ 0xB755,  0xD3FA },
	{ 0xB756,  0xC9F7 },
	{ 0xB757,  0xBBC5 },
	{ 0xB758,  0x90FC },
	{ 0xB759,  0x9143 },
	{ 0xB75A,  0x90F7 },
	{ 0xB75B,  0x90ED },
	{ 0xB75C,  0xC0A2 },
	{ 0xB75D,  0xEDAA },
	{ 0xB75E,  0xEDA9 },
	{ 0xB75F,  0x90F0 },
	{ 0xB760,  0xEAAC },
	{ 0xB761,  0xEAAB },
	{ 0xB762,  0xB4EA },
	{ 0xB763,  0x9392 },
	{ 0xB764,  0xB8E3 },
	{ 0xB765,  0xCCC2 },
	{ 0xB766,  0xB4EE },
	{ 0xB767,  0xB2EB },
	{ 0xB768,  0xB0E1 },
	{ 0xB769,  0xB2AB },
	{ 0xB76A,  0xCBD1 },
	{ 0xB76B,  0xC9A6 },
	{ 0xB76C,  0x9370 },
	{ 0xB76D,  0x938C },
	{ 0xB76E,  0x9375 },
	{ 0xB76F,  0x9376 },
	{ 0xB770,  0x936B },
	{ 0xB771,  0xBEB4 },
	{ 0xB772,  0xD5E5 },
	{ 0xB773,  0xD0C2 },
	{ 0xB774,  0xB0B5 },
	{ 0xB775,  0x959F },
	{ 0xB776,  0xCFBE },
	{ 0xB777,  0x959E },
	{ 0xB778,  0xC5AF },
	{ 0xB779,  0xEAD1 },
	{ 0xB77A,  0x95AA },
	{ 0xB77B,  0x95A2 },
	{ 0xB77C,  0x95FE },
	{ 0xB77D,  0xC0C6 },
	{ 0xB77E,  0x9849 },
	{ 0xB7A1,  0xB3FE },
	{ 0xB7A2,  0xBFAC },
	{ 0xB7A3,  0xE9AA },
	{ 0xB7A4,  0xD0A8 },
	{ 0xB7A5,  0x984F },
	{ 0xB7A6,  0xD2AC },
	{ 0xB7A7,  0xB8C5 },
	{ 0xB7A8,  0x97EE },
	{ 0xB7A9,  0x9845 },
	{ 0xB7AA,  0xE9AE },
	{ 0xB7AB,  0xC0E3 },
	{ 0xB7AC,  0x97F7 },
	{ 0xB7AD,  0xE9BA },
	{ 0xB7AE,  0xD3DC },
	{ 0xB7AF,  0xE9AC },
	{ 0xB7B0,  0xE9B9 },
	{ 0xB7B1,  0x97FC },
	{ 0xB7B2,  0xD0AA },
	{ 0xB7B3,  0x9A71 },
	{ 0xB7B4,  0x9AA7 },
	{ 0xB7B5,  0xB5EE },
	{ 0xB7B6,  0xD8B9 },
	{ 0xB7B7,  0xEBA6 },
	{ 0xB7B8,  0xD2E7 },
	{ 0xB7B9,  0xCBDD },
	{ 0xB7BA,  0xD7D2 },
	{ 0xB7BB,  0xC8DC },
	{ 0xB7BC,  0xE4E8 },
	{ 0xB7BD,  0xD4B4 },
	{ 0xB7BE,  0x9CCF },
	{ 0xB7BF,  0xB5E1 },
	{ 0xB7C0,  0x9CE7 },
	{ 0xB7C1,  0xE4DF },
	{ 0xB7C2,  0xE4DB },
	{ 0xB7C3,  0x9CE1 },
	{ 0xB7C4,  0xC4E7 },
	{ 0xB7C5,  0x9CD8 },
	{ 0xB7C6,  0xBBAC },
	{ 0xB7C7,  0x9CCA },
	{ 0xB7C8,  0xC1EF },
	{ 0xB7C9,  0x9CE6 },
	{ 0xB7CA,  0xCCCF },
	{ 0xB7CB,  0xCFAA },
	{ 0xB7CC,  0xE4E0 },
	{ 0xB7CD,  0xE4E5 },
	{ 0xB7CE,  0xBCE5 },
	{ 0xB7CF,  0x9F9F },
	{ 0xB7D0,  0x9FA9 },
	{ 0xB7D1,  0xC3BA },
	{ 0xB7D2,  0x9F92 },
	{ 0xB7D3,  0xD5D5 },
	{ 0xB7D4,  0xECCF },
	{ 0xB7D5,  0x9FAC },
	{ 0xB7D6,  0xECE3 },
	{ 0xB7D7,  0xBBCD },
	{ 0xB7D8,  0x9FA8 },
	{ 0xB7D9,  0xC9B7 },
	{ 0xB7DA,  0x9F8F },
	{ 0xB7DB,  0xECD0 },
	{ 0xB7DC,  0x9F9C },
	{ 0xB7DD,  0xA094 },
	{ 0xB7DE,  0xEBBA },
	{ 0xB7DF,  0xE9E0 },
	{ 0xB7E0,  0xAA7B },
	{ 0xB7E1,  0xD4B3 },
	{ 0xB7E2,  0xBBAB },
	{ 0xB7E3,  0xAC98 },
	{ 0xB7E4,  0xBAF7 },
	{ 0xB7E5,  0xE8A6 },
	{ 0xB7E6,  0xC9AA },
	{ 0xB7E7,  0xC8F0 },
	{ 0xB7E8,  0xE8A3 },
	{ 0xB7E9,  0xAC71 },
	{ 0xB7EA,  0xE8A7 },
	{ 0xB7EB,  0xE7F8 },
	{ 0xB7EC,  0xE8A4 },
	{ 0xB7ED,  0xAE94 },
	{ 0xB7EE,  0xBBFB },
	{ 0xB7EF,  0xF0F6 },
	{ 0xB7F0,  0xCCB5 },
	{ 0xB7F1,  0xB4E1 },
	{ 0xB7F2,  0xAF71 },
	{ 0xB7F3,  0xF0F2 },
	{ 0xB7F4,  0xAF77 },
	{ 0xB7F5,  0xF0F4 },
	{ 0xB7F6,  0xB3D5 },
	{ 0xB7F7,  0xAF72 },
	{ 0xB7F8,  0xB14B },
	{ 0xB7F9,  0xC3CB },
	{ 0xB7FA,  0xBEA6 },
	{ 0xB7FB,  0xBDDE },
	{ 0xB7FC,  0xC4C0 },
	{ 0xB7FD,  0xB241 },
	{ 0xB7FE,  0xB6BD },
	{ 0xB840,  0xB6C3 },
	{ 0xB841,  0xB247 },
	{ 0xB842,  0xB2C7 },
	{ 0xB843,  0xB1A0 },
	{ 0xB844,  0xEEA2 },
	{ 0xB845,  0xEDFE },
	{ 0xB846,  0xEEA1 },
	{ 0xB847,  0xB0AB },
	{ 0xB848,  0xCBE9 },
	{ 0xB849,  0xC5F6 },
	{ 0xB84A,  0xCDEB },
	{ 0xB84B,  0xB5E2 },
	{ 0xB84C,  0xC2B5 },
	{ 0xB84D,  0xB5EF },
	{ 0xB84E,  0xC5F0 },
	{ 0xB84F,  0xB1AE },
	{ 0xB850,  0xEDD4 },
	{ 0xB851,  0xB39C },
	{ 0xB852,  0xECF7 },
	{ 0xB853,  0xB593 },
	{ 0xB854,  0xBDFB },
	{ 0xB855,  0xC866 },
	{ 0xB856,  0xC7DD },
	{ 0xB857,  0xB6A0 },
	{ 0xB858,  0xD6C9 },
	{ 0xB859,  0xB3ED },
	{ 0xB85A,  0xEFFE },
	{ 0xB85B,  0xB741 },
	{ 0xB85C,  0xEFFD },
	{ 0xB85D,  0xBFDF },
	{ 0xB85E,  0xF1BD },
	{ 0xB85F,  0xBFEA },
	{ 0xB860,  0xB99D },
	{ 0xB861,  0xF3DE },
	{ 0xB862,  0xF3DF },
	{ 0xB863,  0xB961 },
	{ 0xB864,  0xC1BB },
	{ 0xB865,  0xBEAC },
	{ 0xB866,  0xBB9B },
	{ 0xB867,  0xBD9B },
	{ 0xB868,  0xBD81 },
	{ 0xB869,  0xBD99 },
	{ 0xB86A,  0xBD89 },
	{ 0xB86B,  0xBD97 },
	{ 0xB86C,  0xBD64 },
	{ 0xB86D,  0xD6C3 },
	{ 0xB86E,  0xD5D6 },
	{ 0xB86F,  0xD7EF },
	{ 0xB870,  0xCAF0 },
	{ 0xB871,  0xC178 },
	{ 0xB872,  0xC177 },
	{ 0xB873,  0xC8BA },
	{ 0xB874,  0xC27D },
	{ 0xB875,  0xC6B8 },
	{ 0xB876,  0xCBC1 },
	{ 0xB877,  0xD2DE },
	{ 0xB878,  0xEBEC },
	{ 0xB879,  0xD1FC },
	{ 0xB87A,  0xC463 },
	{ 0xB87B,  0xD0C8 },
	{ 0xB87C,  0xC8F9 },
	{ 0xB87D,  0xC45F },
	{ 0xB87E,  0xC45B },
	{ 0xB8A1,  0xB8B9 },
	{ 0xB8A2,  0xCFD9 },
	{ 0xB8A3,  0xC458 },
	{ 0xB8A4,  0xBECB },
	{ 0xB8A5,  0xCDA7 },
	{ 0xB8A6,  0xB5D9 },
	{ 0xB8A7,  0xC89D },
	{ 0xB8A8,  0xC2E4 },
	{ 0xB8A9,  0xDDE6 },
	{ 0xB8AA,  0xBFFB },
	{ 0xB8AB,  0xC894 },
	{ 0xB8AC,  0xBAF9 },
	{ 0xB8AD,  0xC87E },
	{ 0xB8AE,  0xD4E1 },
	{ 0xB8AF,  0xB8F0 },
	{ 0xB8B0,  0xDDE0 },
	{ 0xB8B1,  0xC86E },
	{ 0xB8B2,  0xC6CF },
	{ 0xB8B3,  0xB6AD },
	{ 0xB8B4,  0xDDE2 },
	{ 0xB8B5,  0xDDE7 },
	{ 0xB8B6,  0xDDE1 },
	{ 0xB8B7,  0xD3DD },
	{ 0xB8B8,  0xCC94 },
	{ 0xB8B9,  0xCC96 },
	{ 0xB8BA,  0xD3BC },
	{ 0xB8BB,  0xF2D1 },
	{ 0xB8BC,  0xF2DA },
	{ 0xB8BD,  0xF2D8 },
	{ 0xB8BE,  0xCAF1 },
	{ 0xB8BF,  0xB6EA },
	{ 0xB8C0,  0xCD91 },
	{ 0xB8C1,  0xB7E4 },
	{ 0xB8C2,  0xF2D7 },
	{ 0xB8C3,  0xCD98 },
	{ 0xB8C4,  0xF2DB },
	{ 0xB8C5,  0xD1C3 },
	{ 0xB8C6,  0xF4C4 },
	{ 0xB8C7,  0xD2E1 },
	{ 0xB8C8,  0xC8B9 },
	{ 0xB8C9,  0xD161 },
	{ 0xB8CA,  0xF4C3 },
	{ 0xB8CB,  0xD162 },
	{ 0xB8CC,  0xD165 },
	{ 0xB8CD,  0xD155 },
	{ 0xB8CE,  0xD4A3 },
	{ 0xB8CF,  0xD9F6 },
	{ 0xB8D0,  0xD29B },
	{ 0xB8D1,  0xBDE2 },
	{ 0xB8D2,  0xD48C },
	{ 0xB8D3,  0xD493 },
	{ 0xB8D4,  0xD494 },
	{ 0xB8D5,  0xD487 },
	{ 0xB8D6,  0xD48A },
	{ 0xB8D7,  0xD491 },
	{ 0xB8D8,  0xD546 },
	{ 0xB8D9,  0xD49C },
	{ 0xB8DA,  0xD484 },
	{ 0xB8DB,  0xD55C },
	{ 0xB8DC,  0xD492 },
	{ 0xB8DD,  0xD544 },
	{ 0xB8DE,  0xD48E },
	{ 0xB8DF,  0xD483 },
	{ 0xB8E0,  0xD48F },
	{ 0xB8E1,  0xD48D },
	{ 0xB8E2,  0xD5B2 },
	{ 0xB8E3,  0xD49B },
	{ 0xB8E4,  0xF6A4 },
	{ 0xB8E5,  0xD489 },
	{ 0xB8E6,  0xBBBF },
	{ 0xB8E7,  0xF5F6 },
	{ 0xB8E8,  0xBAD1 },
	{ 0xB8E9,  0xD95C },
	{ 0xB8EA,  0xD959 },
	{ 0xB8EB,  0xD95A },
	{ 0xB8EC,  0xD956 },
	{ 0xB8ED,  0xD944 },
	{ 0xB8EE,  0xD955 },
	{ 0xB8EF,  0xD954 },
	{ 0xB8F0,  0xD957 },
	{ 0xB8F1,  0xDB45 },
	{ 0xB8F2,  0xB8FA },
	{ 0xB8F3,  0xBFE7 },
	{ 0xB8F4,  0xC2B7 },
	{ 0xB8F5,  0xCCF8 },
	{ 0xB8F6,  0xB6E5 },
	{ 0xB8F7,  0xB9F2 },
	{ 0xB8F8,  0xF5D3 },
	{ 0xB8F9,  0xDB48 },
	{ 0xB8FA,  0xB6E3 },
	{ 0xB8FB,  0xDD5E },
	{ 0xB8FC,  0xDD64 },
	{ 0xB8FD,  0xDD59 },
	{ 0xB8FE,  0xDD65 },
	{ 0xB940,  0xB1D9 },
	{ 0xB941,  0xDE72 },
	{ 0xB942,  0xDF5C },
	{ 0xB943,  0xDF5B },
	{ 0xB944,  0xB5C0 },
	{ 0xB945,  0xCBEC },
	{ 0xB946,  0xDF5F },
	{ 0xB947,  0xB1C6 },
	{ 0xB948,  0xDF60 },
	{ 0xB949,  0xE5DA },
	{ 0xB94A,  0xD3F6 },
	{ 0xB94B,  0xB6F4 },
	{ 0xB94C,  0xDF5E },
	{ 0xB94D,  0xB1E9 },
	{ 0xB94E,  0xE5D8 },
	{ 0xB94F,  0xD3E2 },
	{ 0xB950,  0xB6DD },
	{ 0xB951,  0xE075 },
	{ 0xB952,  0xE07A },
	{ 0xB953,  0xB3EA },
	{ 0xB954,  0xC0D2 },
	{ 0xB955,  0xF5A4 },
	{ 0xB956,  0xD3D4 },
	{ 0xB957,  0xE292 },
	{ 0xB958,  0xE351 },
	{ 0xB959,  0xE293 },
	{ 0xB95A,  0xE298 },
	{ 0xB95B,  0xE29B },
	{ 0xB95C,  0xE299 },
	{ 0xB95D,  0xE355 },
	{ 0xB95E,  0xE345 },
	{ 0xB95F,  0xE35E },
	{ 0xB960,  0xE34B },
	{ 0xB961,  0xE28F },
	{ 0xB962,  0xE343 },
	{ 0xB963,  0xE347 },
	{ 0xB964,  0xE2A0 },
	{ 0xB965,  0xE294 },
	{ 0xB966,  0xE29A },
	{ 0xB967,  0xE354 },
	{ 0xB968,  0xE96C },
	{ 0xB969,  0xB0AF },
	{ 0xB96A,  0xB8F4 },
	{ 0xB96B,  0xEB45 },
	{ 0xB96C,  0xD3BA },
	{ 0xB96D,  0xEB68 },
	{ 0xB96E,  0xEFF4 },
	{ 0xB96F,  0xEB67 },
	{ 0xB970,  0xC0D7 },
	{ 0xB971,  0xEB8A },
	{ 0xB972,  0xB1A2 },
	{ 0xB973,  0xC1E3 },
	{ 0xB974,  0xBEB8 },
	{ 0xB975,  0xD1A5 },
	{ 0xB976,  0xB0D0 },
	{ 0xB977,  0xEE41 },
	{ 0xB978,  0xEE42 },
	{ 0xB979,  0xEE44 },
	{ 0xB97A,  0xED9C },
	{ 0xB97B,  0xEE43 },
	{ 0xB97C,  0xED9E },
	{ 0xB97D,  0xEF95 },
	{ 0xB97E,  0xEF8D },
	{ 0xB9A1,  0xEF96 },
	{ 0xB9A2,  0xEF97 },
	{ 0xB9A3,  0xF159 },
	{ 0xB9A4,  0xF157 },
	{ 0xB9A5,  0xF15A },
	{ 0xB9A6,  0xF7D5 },
	{ 0xB9A7,  0xF846 },
	{ 0xB9A8,  0xF7E4 },
	{ 0xB9A9,  0xB6A6 },
	{ 0xB9AA,  0xB9C4 },
	{ 0xB9AB,  0xCAF3 },
	{ 0xB9AC,  0xC9AE },
	{ 0xB9AD,  0xD9D7 },
	{ 0xB9AE,  0x8365 },
	{ 0xB9AF,  0xD9D2 },
	{ 0xB9B0,  0xD9D4 },
	{ 0xB9B1,  0xC1C5 },
	{ 0xB9B2,  0x8357 },
	{ 0xB9B3,  0xCFF1 },
	{ 0xB9B4,  0x8353 },
	{ 0xB9B5,  0x836C },
	{ 0xB9B6,  0x8351 },
	{ 0xB9B7,  0x8367 },
	{ 0xB9B8,  0xBEA4 },
	{ 0xB9B9,  0xB5CA },
	{ 0xB9BA,  0x849D },
	{ 0xB9BB,  0xD8E3 },
	{ 0xB9BC,  0x8554 },
	{ 0xB9BD,  0x8592 },
	{ 0xB9BE,  0xE0D5 },
	{ 0xB9BF,  0xE0D6 },
	{ 0xB9C0,  0xC2EF },
	{ 0xB9C1,  0x874C },
	{ 0xB9C2,  0xCBD4 },
	{ 0xB9C3,  0x8749 },
	{ 0xB9C4,  0x8740 },
	{ 0xB9C5,  0xBCCE },
	{ 0xB9C6,  0x8744 },
	{ 0xB9C7,  0xB8C2 },
	{ 0xB9C8,  0xE0BB },
	{ 0xB9C9,  0x874B },
	{ 0xB9CA,  0xE0BD },
	{ 0xB9CB,  0xE0D0 },
	{ 0xB9CC,  0x8745 },
	{ 0xB9CD,  0x86F4 },
	{ 0xB9CE,  0x8846 },
	{ 0xB9CF,  0x8844 },
	{ 0xB9D0,  0x896D },
	{ 0xB9D1,  0xDBD3 },
	{ 0xB9D2,  0xBEB3 },
	{ 0xB9D3,  0xC4B9 },
	{ 0xB9D4,  0x897C },
	{ 0xB9D5,  0x8971 },
	{ 0xB9D6,  0xCAFB },
	{ 0xB9D7,  0x8975 },
	{ 0xB9D8,  0x89DB },
	{ 0xB9D9,  0xE2B7 },
	{ 0xB9DA,  0x89F4 },
	{ 0xB9DB,  0xE2B9 },
	{ 0xB9DC,  0x8A5A },
	{ 0xB9DD,  0x8A59 },
	{ 0xB9DE,  0xB5D5 },
	{ 0xB9DF,  0xE6CF },
	{ 0xB9E0,  0xC4DB },
	{ 0xB9E1,  0x8B9E },
	{ 0xB9E2,  0xE6CE },
	{ 0xB9E3,  0xE6D0 },
	{ 0xB9E4,  0xE6CC },
	{ 0xB9E5,  0xB7F5 },
	{ 0xB9E6,  0xC4AF },
	{ 0xB9E7,  0x8C8E },
	{ 0xB9E8,  0xB9D1 },
	{ 0xB9E9,  0xC1C8 },
	{ 0xB9EA,  0x8C8D },
	{ 0xB9EB,  0xD5AF },
	{ 0xB9EC,  0x8C8B },
	{ 0xB9ED,  0xE5BB },
	{ 0xB9EE,  0xB2EC },
	{ 0xB9EF,  0x8CA6 },
	{ 0xB9F0,  0x8CD2 },
	{ 0xB9F1,  0x8DE4 },
	{ 0xB9F2,  0x8DE7 },
	{ 0xB9F3,  0xE1A4 },
	{ 0xB9F4,  0x8EC5 },
	{ 0xB9F5,  0xC4BB },
	{ 0xB9F6,  0x8EBD },
	{ 0xB9F7,  0xE1A3 },
	{ 0xB9F8,  0xC0AA },
	{ 0xB9F9,  0xC1CE },
	{ 0xB9FA,  0xB1D7 },
	{ 0xB9FB,  0x8F95 },
	{ 0xB9FC,  0xD5C3 },
	{ 0xB9FD,  0x8FD8 },
	{ 0xB9FE,  0x9140 },
	{ 0xBA40,  0xD4B8 },
	{ 0xBA41,  0x9142 },
	{ 0xBA42,  0xBFB6 },
	{ 0xBA43,  0xC2FD },
	{ 0xBA44,  0x9154 },
	{ 0xBA45,  0x9151 },
	{ 0xBA46,  0x914D },
	{ 0xBA47,  0x914B },
	{ 0xBA48,  0xE3BC },
	{ 0xBA49,  0xBDD8 },
	{ 0xBA4A,  0xC6B2 },
	{ 0xBA4B,  0xD5AA },
	{ 0xBA4C,  0xCBA4 },
	{ 0xBA4D,  0xB3B7 },
	{ 0xBA4E,  0xC3FE },
	{ 0xBA4F,  0x93A7 },
	{ 0xBA50,  0xDFA1 },
	{ 0xBA51,  0x939D },
	{ 0xBA52,  0xB4DD },
	{ 0xBA53,  0xE5BA },
	{ 0xBA54,  0xDEFD },
	{ 0xBA55,  0x93BD },
	{ 0xBA56,  0xC7C3 },
	{ 0xBA57,  0xCED3 },
	{ 0xBA58,  0xC6EC },
	{ 0xBA59,  0xECBD },
	{ 0xBA5A,  0x95B3 },
	{ 0xBA5B,  0xF4DF },
	{ 0xBA5C,  0xEAD4 },
	{ 0xBA5D,  0xB0F1 },
	{ 0xBA5E,  0xD5A5 },
	{ 0xBA5F,  0xE9C5 },
	{ 0xBA60,  0xE9C2 },
	{ 0xBA61,  0x9873 },
	{ 0xBA62,  0x9890 },
	{ 0xBA63,  0x988B },
	{ 0xBA64,  0xE9BB },
	{ 0xBA65,  0xC8B6 },
	{ 0xBA66,  0xE9BD },
	{ 0xBA67,  0xE9BE },
	{ 0xBA68,  0xC1F1 },
	{ 0xBA69,  0xBBB1 },
	{ 0xBA6A,  0x988C },
	{ 0xBA6B,  0xE9BF },
	{ 0xBA6C,  0xE9B3 },
	{ 0xBA6D,  0x986F },
	{ 0xBA6E,  0x9884 },
	{ 0xBA6F,  0x986C },
	{ 0xBA70,  0xC7B8 },
	{ 0xBA71,  0xB8E8 },
	{ 0xBA72,  0x9AE8 },
	{ 0xBA73,  0xD5C4 },
	{ 0xBA74,  0xD1DD },
	{ 0xBA75,  0x9D4C },
	{ 0xBA76,  0xC0EC },
	{ 0xBA77,  0xB5CE },
	{ 0xBA78,  0xE4F6 },
	{ 0xBA79,  0xD1FA },
	{ 0xBA7A,  0xC4AE },
	{ 0xBA7B,  0x9D6E },
	{ 0xBA7C,  0xC2A9 },
	{ 0xBA7D,  0xC6AF },
	{ 0xBA7E,  0x9D68 },
	{ 0xBAA1,  0x9D4D },
	{ 0xBAA2,  0x9CFE },
	{ 0xBAA3,  0xC6E1 },
	{ 0xBAA4,  0xCAFE },
	{ 0xBAA5,  0x9D75 },
	{ 0xBAA6,  0x9D71 },
	{ 0xBAA7,  0x9D69 },
	{ 0xBAA8,  0xE4EE },
	{ 0xBAA9,  0xC2FE },
	{ 0xBAAA,  0xE4F0 },
	{ 0xBAAB,  0xB3BA },
	{ 0xBAAC,  0xE4F4 },
	{ 0xBAAD,  0x9CFB },
	{ 0xBAAE,  0x9D4F },
	{ 0xBAAF,  0x9D42 },
	{ 0xBAB0,  0x9CEC },
	{ 0xBAB1,  0x9D46 },
	{ 0xBAB2,  0xC8DB },
	{ 0xBAB3,  0xCEF5 },
	{ 0xBAB4,  0xC9BF },
	{ 0xBAB5,  0xD0DC },
	{ 0xBAB6,  0xCFA8 },
	{ 0xBAB7,  0x9FC9 },
	{ 0xBAB8,  0xA096 },
	{ 0xBAB9,  0xEAFB },
	{ 0xBABA,  0xA0CE },
	{ 0xBABB,  0xAA7A },
	{ 0xBABC,  0xE2AF },
	{ 0xBABD,  0xAC8E },
	{ 0xBABE,  0xAC8D },
	{ 0xBABF,  0xAC94 },
	{ 0xBAC0,  0xB9E5 },
	{ 0xBAC1,  0xE8A9 },
	{ 0xBAC2,  0xD5E7 },
	{ 0xBAC3,  0xD2C9 },
	{ 0xBAC4,  0xAF91 },
	{ 0xBAC5,  0xAF83 },
	{ 0xBAC6,  0xAF82 },
	{ 0xBAC7,  0xAF81 },
	{ 0xBAC8,  0xAF88 },
	{ 0xBAC9,  0xB14D },
	{ 0xBACA,  0xB14F },
	{ 0xBACB,  0xC3E9 },
	{ 0xBACC,  0xEEA5 },
	{ 0xBACD,  0xEEA3 },
	{ 0xBACE,  0xCBAF },
	{ 0xBACF,  0xB4C5 },
	{ 0xBAD0,  0xB5FA },
	{ 0xBAD1,  0xB1CC },
	{ 0xBAD2,  0xCCBC },
	{ 0xBAD3,  0xB454 },
	{ 0xBAD4,  0xEDD9 },
	{ 0xBAD5,  0xB59D },
	{ 0xBAD6,  0xB8A3 },
	{ 0xBAD7,  0xB59C },
	{ 0xBAD8,  0xB74E },
	{ 0xBAD9,  0xB751 },
	{ 0xBADA,  0xB844 },
	{ 0xBADB,  0xB843 },
	{ 0xBADC,  0xBDDF },
	{ 0xBADD,  0xB6CB },
	{ 0xBADE,  0xB9DC },
	{ 0xBADF,  0xBBFE },
	{ 0xBAE0,  0xB97B },
	{ 0xBAE1,  0xF3DB },
	{ 0xBAE2,  0xCBE3 },
	{ 0xBAE3,  0xF3E9 },
	{ 0xBAE4,  0xB2AD },
	{ 0xBAE5,  0xB97E },
	{ 0xBAE6,  0xF3E7 },
	{ 0xBAE7,  0xB977 },
	{ 0xBAE8,  0xB975 },
	{ 0xBAE9,  0xB4E2 },
	{ 0xBAEA,  0xF4D5 },
	{ 0xBAEB,  0xBEAB },
	{ 0xBAEC,  0xBE60 },
	{ 0xBAED,  0xBE55 },
	{ 0xBAEE,  0xBE43 },
	{ 0xBAEF,  0xBE62 },
	{ 0xBAF0,  0xBE63 },
	{ 0xBAF1,  0xBE47 },
	{ 0xBAF2,  0xBE6F },
	{ 0xBAF3,  0xBE59 },
	{ 0xBAF4,  0xBE57 },
	{ 0xBAF5,  0xBE56 },
	{ 0xBAF6,  0xBE5F },
	{ 0xBAF7,  0xBE49 },
	{ 0xBAF8,  0xBE64 },
	{ 0xBAF9,  0xBE5A },
	{ 0xBAFA,  0xBE5D },
	{ 0xBAFB,  0xBE53 },
	{ 0xBAFC,  0xBE77 },
	{ 0xBAFD,  0xBE6C },
	{ 0xBAFE,  0xBE52 },
	{ 0xBB40,  0xC150 },
	{ 0xBB41,  0xB4E4 },
	{ 0xBB42,  0xF4E4 },
	{ 0xBB43,  0xB5D4 },
	{ 0xBB44,  0xC284 },
	{ 0xBB45,  0xBEDB },
	{ 0xBB46,  0xD5D8 },
	{ 0xBB47,  0xB8AF },
	{ 0xBB48,  0xB0F2 },
	{ 0xBB49,  0xB8E0 },
	{ 0xBB4A,  0xEBF5 },
	{ 0xBB4B,  0xB2B2 },
	{ 0xBB4C,  0xCDC8 },
	{ 0xBB4D,  0xEBF6 },
	{ 0xBB4E,  0xEAB0 },
	{ 0xBB4F,  0xC55F },
	{ 0xBB50,  0xC563 },
	{ 0xBB51,  0xCCF2 },
	{ 0xBB52,  0xCEE8 },
	{ 0xBB53,  0xF4BB },
	{ 0xBB54,  0xC8D8 },
	{ 0xBB55,  0xDDEF },
	{ 0xBB56,  0xC974 },
	{ 0xBB57,  0xD0EE },
	{ 0xBB58,  0xC3C9 },
	{ 0xBB59,  0xC957 },
	{ 0xBB5A,  0xC6D1 },
	{ 0xBB5B,  0xCBE2 },
	{ 0xBB5C,  0xC977 },
	{ 0xBB5D,  0xD5F4 },
	{ 0xBB5E,  0xC970 },
	{ 0xBB5F,  0xDDED },
	{ 0xBB60,  0xC94C },
	{ 0xBB61,  0xC96E },
	{ 0xBB62,  0xCBF2 },
	{ 0xBB63,  0xDDEE },
	{ 0xBB64,  0xF2EA },
	{ 0xBB65,  0xC3DB },
	{ 0xBB66,  0xF2DF },
	{ 0xBB67,  0xF2EC },
	{ 0xBB68,  0xF2E1 },
	{ 0xBB69,  0xF2E6 },
	{ 0xBB6A,  0xD6A9 },
	{ 0xBB6B,  0xCE67 },
	{ 0xBB6C,  0xF2E9 },
	{ 0xBB6D,  0xF2E8 },
	{ 0xBB6E,  0xC9D1 },
	{ 0xBB6F,  0xB9D3 },
	{ 0xBB70,  0xC5E1 },
	{ 0xBB71,  0xB9FC },
	{ 0xBB72,  0xC2E3 },
	{ 0xBB73,  0xD175 },
	{ 0xBB74,  0xF1D4 },
	{ 0xBB75,  0xF1D2 },
	{ 0xBB76,  0xD16E },
	{ 0xBB77,  0xD562 },
	{ 0xBB78,  0xD549 },
	{ 0xBB79,  0xD55A },
	{ 0xBB7A,  0xD55F },
	{ 0xBB7B,  0xD54A },
	{ 0xBB7C,  0xD55D },
	{ 0xBB7D,  0xCAC4 },
	{ 0xBB7E,  0xD560 },
	{ 0xBBA1,  0xD566 },
	{ 0xBBA2,  0xD561 },
	{ 0xBBA3,  0xD564 },
	{ 0xBBA4,  0xD554 },
	{ 0xBBA5,  0xD54E },
	{ 0xBBA6,  0xD556 },
	{ 0xBBA7,  0xD563 },
	{ 0xBBA8,  0xBAC0 },
	{ 0xBBA9,  0xD882 },
	{ 0xBBAA,  0xC3B2 },
	{ 0xBBAB,  0xD965 },
	{ 0xBBAC,  0xD963 },
	{ 0xBBAD,  0xD964 },
	{ 0xBBAE,  0xBAD5 },
	{ 0xBBAF,  0xDA77 },
	{ 0xBBB0,  0xDA73 },
	{ 0xBBB1,  0xDB52 },
	{ 0xBBB2,  0xDD6F },
	{ 0xBBB3,  0xDD6D },
	{ 0xBBB4,  0xDD70 },
	{ 0xBBB5,  0xDD6E },
	{ 0xBBB6,  0xC0B1 },
	{ 0xBBB7,  0xDF68 },
	{ 0xBBB8,  0xE5DC },
	{ 0xBBB9,  0xDF64 },
	{ 0xBBBA,  0xC7B2 },
	{ 0xBBBB,  0xDF62 },
	{ 0xBBBC,  0xDF66 },
	{ 0xBBBD,  0xE5DD },
	{ 0xBBBE,  0xDF65 },
	{ 0xBBBF,  0xE5DE },
	{ 0xBBC0,  0xB1C9 },
	{ 0xBBC1,  0xE07B },
	{ 0xBBC2,  0xDBB4 },
	{ 0xBBC3,  0xBDCD },
	{ 0xBBC4,  0xCBE1 },
	{ 0xBBC5,  0xBFE1 },
	{ 0xBBC6,  0xF5A9 },
	{ 0xBBC7,  0xE371 },
	{ 0xBBC8,  0xE379 },
	{ 0xBBC9,  0xE37E },
	{ 0xBBCA,  0xE391 },
	{ 0xBBCB,  0xE38F },
	{ 0xBBCC,  0xE374 },
	{ 0xBBCD,  0xE38C },
	{ 0xBBCE,  0xE395 },
	{ 0xBBCF,  0xE440 },
	{ 0xBBD0,  0xE375 },
	{ 0xBBD1,  0xE38A },
	{ 0xBBD2,  0xE975 },
	{ 0xBBD3,  0xE97C },
	{ 0xBBD4,  0xE97D },
	{ 0xBBD5,  0xE977 },
	{ 0xBBD6,  0xE979 },
	{ 0xBBD7,  0xE978 },
	{ 0xBBD8,  0xCFB6 },
	{ 0xBBD9,  0xD5CF },
	{ 0xBBDA,  0xEB48 },
	{ 0xBBDB,  0xB4C6 },
	{ 0xBBDC,  0xF6C3 },
	{ 0xBBDD,  0xD0E8 },
	{ 0xBBDE,  0xF7B0 },
	{ 0xBBDF,  0xF7B1 },
	{ 0xBBE0,  0xC9D8 },
	{ 0xBBE1,  0xEE48 },
	{ 0xBBE2,  0xEE49 },
	{ 0xBBE3,  0xEF53 },
	{ 0xBBE4,  0xEF55 },
	{ 0xBBE5,  0xEF9C },
	{ 0xBBE6,  0xEF9E },
	{ 0xBBE7,  0xF044 },
	{ 0xBBE8,  0xF041 },
	{ 0xBBE9,  0xF167 },
	{ 0xBBEA,  0xF361 },
	{ 0xBBEB,  0xF7BB },
	{ 0xBBEC,  0xF7D6 },
	{ 0xBBED,  0xBFFD },
	{ 0xBBEE,  0xBBEA },
	{ 0xBBEF,  0xF851 },
	{ 0xBBF0,  0xF853 },
	{ 0xBBF1,  0xF850 },
	{ 0xBBF2,  0xFC4E },
	{ 0xBBF3,  0xB1C7 },
	{ 0xBBF4,  0xFD52 },
	{ 0xBBF5,  0x837C },
	{ 0xBBF6,  0x8378 },
	{ 0xBBF7,  0xC6A7 },
	{ 0xBBF8,  0xBDA9 },
	{ 0xBBF9,  0x8372 },
	{ 0xBBFA,  0x837A },
	{ 0xBBFB,  0x837E },
	{ 0xBBFC,  0x8380 },
	{ 0xBBFD,  0x837D },
	{ 0xBBFE,  0x8443 },
	{ 0xBC40,  0x84A1 },
	{ 0xBC41,  0xC5FC },
	{ 0xBC42,  0x84A2 },
	{ 0xBC43,  0x84A6 },
	{ 0xBC44,  0x84A3 },
	{ 0xBC45,  0xDBC4 },
	{ 0xBC46,  0x8596 },
	{ 0xBC47,  0x875A },
	{ 0xBC48,  0xCEFB },
	{ 0xBC49,  0xE0DA },
	{ 0xBC4A,  0xB3B0 },
	{ 0xBC4B,  0xBAD9 },
	{ 0xBC4C,  0xD7EC },
	{ 0xBC4D,  0x8757 },
	{ 0xBC4E,  0x8775 },
	{ 0xBC4F,  0xD2AD },
	{ 0xBC50,  0xE0DB },
	{ 0xBC51,  0x878A },
	{ 0xBC52,  0xCBBB },
	{ 0xBC53,  0x875B },
	{ 0xBC54,  0x875C },
	{ 0xBC55,  0xDCAF },
	{ 0xBC56,  0xD0E6 },
	{ 0xBC57,  0xD4F6 },
	{ 0xBC58,  0x899E },
	{ 0xBC59,  0x898B },
	{ 0xBC5A,  0x8999 },
	{ 0xBC5B,  0xB6D5 },
	{ 0xBC5C,  0x8993 },
	{ 0xBC5D,  0x8A5D },
	{ 0xBC5E,  0xE6D2 },
	{ 0xBC5F,  0x8BB9 },
	{ 0xBC60,  0x8BC8 },
	{ 0xBC61,  0x8BB3 },
	{ 0xBC62,  0x8BC9 },
	{ 0xBC63,  0x8BC6 },
	{ 0xBC64,  0xE5BC },
	{ 0xBC65,  0x8C92 },
	{ 0xBC66,  0x8C8F },
	{ 0xBC67,  0x8C91 },
	{ 0xBC68,  0x8CD3 },
	{ 0xBC69,  0xC2C4 },
	{ 0xBC6A,  0xE1D8 },
	{ 0xBC6B,  0x8DF4 },
	{ 0xBC6C,  0xB4B1 },
	{ 0xBC6D,  0x8EC3 },
	{ 0xBC6E,  0xE1A6 },
	{ 0xBC6F,  0x8F55 },
	{ 0xBC70,  0x8F4E },
	{ 0xBC71,  0x8F52 },
	{ 0xBC72,  0x8F50 },
	{ 0xBC73,  0x8F56 },
	{ 0xBC74,  0x8F53 },
	{ 0xBC75,  0x8F97 },
	{ 0xBC76,  0xD3B0 },
	{ 0xBC77,  0xB5C2 },
	{ 0xBC78,  0xE1E7 },
	{ 0xBC79,  0x9163 },
	{ 0xBC7A,  0xBBDB },
	{ 0xBC7B,  0x915D },
	{ 0xBC7C,  0xEDAB },
	{ 0xBC7D,  0xC4BD },
	{ 0xBC7E,  0x916E },
	{ 0xBCA1,  0x9168 },
	{ 0xBCA2,  0xCEBF },
	{ 0xBCA3,  0x915A },
	{ 0xBCA4,  0x916A },
	{ 0xBCA5,  0xE3BF },
	{ 0xBCA6,  0x917A },
	{ 0xBCA7,  0x9191 },
	{ 0xBCA8,  0xD4F7 },
	{ 0xBCA9,  0xE3BD },
	{ 0xBCAA,  0x9184 },
	{ 0xBCAB,  0x918D },
	{ 0xBCAC,  0xE3BE },
	{ 0xBCAD,  0x9193 },
	{ 0xBCAE,  0xC2BE },
	{ 0xBCAF,  0xC4A6 },
	{ 0xBCB0,  0x93B4 },
	{ 0xBCB1,  0xC4A1 },
	{ 0xBCB2,  0xD7B2 },
	{ 0xBCB3,  0x93E4 },
	{ 0xBCB4,  0x93C6 },
	{ 0xBCB5,  0x93CE },
	{ 0xBCB6,  0xD7AB },
	{ 0xBCB7,  0x93DC },
	{ 0xBCB8,  0x93CF },
	{ 0xBCB9,  0xCBBA },
	{ 0xBCBA,  0xC1C3 },
	{ 0xBCBB,  0xC8F6 },
	{ 0xBCBC,  0xB4E9 },
	{ 0xBCBD,  0xB2A5 },
	{ 0xBCBE,  0x93E1 },
	{ 0xBCBF,  0x93D3 },
	{ 0xBCC0,  0xC7CB },
	{ 0xBCC1,  0xDFA4 },
	{ 0xBCC2,  0x93DA },
	{ 0xBCC3,  0x93E5 },
	{ 0xBCC4,  0x94B3 },
	{ 0xBCC5,  0xB7F3 },
	{ 0xBCC6,  0x94B5 },
	{ 0xBCC7,  0xC4BA },
	{ 0xBCC8,  0x95BA },
	{ 0xBCC9,  0xB1A9 },
	{ 0xBCCA,  0x95BF },
	{ 0xBCCB,  0x98D3 },
	{ 0xBCCC,  0xD5C1 },
	{ 0xBCCD,  0x98A1 },
	{ 0xBCCE,  0x98B6 },
	{ 0xBCCF,  0x98D0 },
	{ 0xBCD0,  0x98CB },
	{ 0xBCD1,  0xB2DB },
	{ 0xBCD2,  0xC4A3 },
	{ 0xBCD3,  0x98C7 },
	{ 0xBCD4,  0xB7AE },
	{ 0xBCD5,  0x98AA },
	{ 0xBCD6,  0x98B7 },
	{ 0xBCD7,  0x98BA },
	{ 0xBCD8,  0xE9CA },
	{ 0xBCD9,  0x98C5 },
	{ 0xBCDA,  0x9A57 },
	{ 0xBCDB,  0x9A55 },
	{ 0xBCDC,  0x9A91 },
	{ 0xBCDD,  0xD2E3 },
	{ 0xBCDE,  0x9AAA },
	{ 0xBCDF,  0x9D7B },
	{ 0xBCE0,  0xE4FC },
	{ 0xBCE1,  0xB3CE },
	{ 0xBCE2,  0x9D8A },
	{ 0xBCE3,  0xC1CA },
	{ 0xBCE4,  0x9D8D },
	{ 0xBCE5,  0x9DB2 },
	{ 0xBCE6,  0xCCB6 },
	{ 0xBCE7,  0x9D93 },
	{ 0xBCE8,  0xE4FA },
	{ 0xBCE9,  0xB3B1 },
	{ 0xBCEA,  0xC5EC },
	{ 0xBCEB,  0xE4FD },
	{ 0xBCEC,  0x9DA2 },
	{ 0xBCED,  0x9D99 },
	{ 0xBCEE,  0x9DBE },
	{ 0xBCEF,  0xC5CB },
	{ 0xBCF0,  0xEBF8 },
	{ 0xBCF1,  0x9DA1 },
	{ 0xBCF2,  0x9D96 },
	{ 0xBCF3,  0x9D95 },
	{ 0xBCF4,  0xCAEC },
	{ 0xBCF5,  0xB0BE },
	{ 0xBCF6,  0x9FE1 },
	{ 0xBCF7,  0xECD9 },
	{ 0xBCF8,  0xEBBB },
	{ 0xBCF9,  0xA0D3 },
	{ 0xBCFA,  0xAA84 },
	{ 0xBCFB,  0xE2B1 },
	{ 0xBCFC,  0xAC93 },
	{ 0xBCFD,  0xE8B0 },
	{ 0xBCFE,  0xC1A7 },
	{ 0xBD40,  0xE8AA },
	{ 0xBD41,  0xE8AD },
	{ 0xBD42,  0xE7DC },
	{ 0xBD43,  0xF1A4 },
	{ 0xBD44,  0xB4F1 },
	{ 0xBD45,  0xCEC1 },
	{ 0xBD46,  0xC1F6 },
	{ 0xBD47,  0xCADD },
	{ 0xBD48,  0xAF8F },
	{ 0xBD49,  0xF1A3 },
	{ 0xBD4A,  0xB07D },
	{ 0xBD4B,  0xB099 },
	{ 0xBD4C,  0xB150 },
	{ 0xBD4D,  0xCFB9 },
	{ 0xBD4E,  0xB25B },
	{ 0xBD4F,  0xEEA7 },
	{ 0xBD50,  0xEEA8 },
	{ 0xBD51,  0xB25F },
	{ 0xBD52,  0xB4E8 },
	{ 0xBD53,  0xB0F5 },
	{ 0xBD54,  0xB45F },
	{ 0xBD55,  0xC0DA },
	{ 0xBD56,  0xC4EB },
	{ 0xBD57,  0xBFC4 },
	{ 0xBD58,  0xB461 },
	{ 0xBD59,  0xC5CD },
	{ 0xBD5A,  0xB8E5 },
	{ 0xBD5B,  0xBCDA },
	{ 0xBD5C,  0xB759 },
	{ 0xBD5D,  0xBBFC },
	{ 0xBD5E,  0xF0A2 },
	{ 0xBD5F,  0xB5BE },
	{ 0xBD60,  0xB847 },
	{ 0xBD61,  0xB846 },
	{ 0xBD62,  0xBCFD },
	{ 0xBD63,  0xCFE4 },
	{ 0xBD64,  0xB9A0 },
	{ 0xBD65,  0xF3F0 },
	{ 0xBD66,  0xD7AD },
	{ 0xBD67,  0xC6AA },
	{ 0xBD68,  0xF3F2 },
	{ 0xBD69,  0xB98A },
	{ 0xBD6A,  0xF3F3 },
	{ 0xBD6B,  0xBAFD },
	{ 0xBD6C,  0xBE86 },
	{ 0xBD6D,  0xBE9A },
	{ 0xBD6E,  0xBE95 },
	{ 0xBD6F,  0xBF40 },
	{ 0xBD70,  0xBE7D },
	{ 0xBD71,  0xBE92 },
	{ 0xBD72,  0xBE83 },
	{ 0xBD73,  0xBE8E },
	{ 0xBD74,  0xBE89 },
	{ 0xBD75,  0xBE80 },
	{ 0xBD76,  0xBE84 },
	{ 0xBD77,  0xBE8F },
	{ 0xBD78,  0xBE45 },
	{ 0xBD79,  0xBE7E },
	{ 0xBD7A,  0xBE98 },
	{ 0xBD7B,  0xBE9F },
	{ 0xBD7C,  0xC152 },
	{ 0xBD7D,  0xC154 },
	{ 0xBD7E,  0xF4C9 },
	{ 0xBDA1,  0xF4E6 },
	{ 0xBDA2,  0xF1EE },
	{ 0xBDA3,  0xCCC5 },
	{ 0xBDA4,  0xC4A4 },
	{ 0xBDA5,  0xCFA5 },
	{ 0xBDA6,  0xC47A },
	{ 0xBDA7,  0xC477 },
	{ 0xBDA8,  0xB1EC },
	{ 0xBDA9,  0xD5E1 },
	{ 0xBDAA,  0xB1CE },
	{ 0xBDAB,  0xCEB5 },
	{ 0xBDAC,  0xC98F },
	{ 0xBDAD,  0xCADF },
	{ 0xBDAE,  0xCA61 },
	{ 0xBDAF,  0xC2FB },
	{ 0xBDB0,  0xC3EF },
	{ 0xBDB1,  0xCA59 },
	{ 0xBDB2,  0xB2CC },
	{ 0xBDB3,  0xCA4E },
	{ 0xBDB4,  0xC5EE },
	{ 0xBDB5,  0xCA5B },
	{ 0xBDB6,  0xDEA3 },
	{ 0xBDB7,  0xCA43 },
	{ 0xBDB8,  0xF2EB },
	{ 0xBDB9,  0xBAFB },
	{ 0xBDBA,  0xB5FB },
	{ 0xBDBB,  0xF2F0 },
	{ 0xBDBC,  0xCE72 },
	{ 0xBDBD,  0xCE81 },
	{ 0xBDBE,  0xCE74 },
	{ 0xBDBF,  0xF2F9 },
	{ 0xBDC0,  0xBBC8 },
	{ 0xBDC1,  0xF2F2 },
	{ 0xBDC2,  0xF2F5 },
	{ 0xBDC3,  0xD06C },
	{ 0xBDC4,  0xD06E },
	{ 0xBDC5,  0xBAD6 },
	{ 0xBDC6,  0xD17D },
	{ 0xBDC7,  0xB0FD },
	{ 0xBDC8,  0xF1D9 },
	{ 0xBDC9,  0xD188 },
	{ 0xBDCA,  0xF1DB },
	{ 0xBDCB,  0xD578 },
	{ 0xBDCC,  0xD58F },
	{ 0xBDCD,  0xD584 },
	{ 0xBDCE,  0xD581 },
	{ 0xBDCF,  0xD551 },
	{ 0xBDD0,  0xD588 },
	{ 0xBDD1,  0xD654 },
	{ 0xBDD2,  0xD56E },
	{ 0xBDD3,  0xD586 },
	{ 0xBDD4,  0xD57E },
	{ 0xBDD5,  0xD57B },
	{ 0xBDD6,  0xD56C },
	{ 0xBDD7,  0xD593 },
	{ 0xBDD8,  0xD58A },
	{ 0xBDD9,  0xD572 },
	{ 0xBDDA,  0xD575 },
	{ 0xBDDB,  0xD598 },
	{ 0xBDDC,  0xCDE3 },
	{ 0xBDDD,  0xD851 },
	{ 0xBDDE,  0xD869 },
	{ 0xBDDF,  0xD972 },
	{ 0xBDE0,  0xD970 },
	{ 0xBDE1,  0xD978 },
	{ 0xBDE2,  0xD976 },
	{ 0xBDE3,  0xD97E },
	{ 0xBDE4,  0xD980 },
	{ 0xBDE5,  0xD974 },
	{ 0xBDE6,  0xD975 },
	{ 0xBDE7,  0xD96E },
	{ 0xBDE8,  0xD97C },
	{ 0xBDE9,  0xD973 },
	{ 0xBDEA,  0xF4F7 },
	{ 0xBDEB,  0xCCCB },
	{ 0xBDEC,  0xC8A4 },
	{ 0xBDED,  0xDB73 },
	{ 0xBDEE,  0xDB60 },
	{ 0xBDEF,  0xF5D7 },
	{ 0xBDF0,  0xCCDF },
	{ 0xBDF1,  0xCCA4 },
	{ 0xBDF2,  0xB2C8 },
	{ 0xBDF3,  0xF5D8 },
	{ 0xBDF4,  0xDB6D },
	{ 0xBDF5,  0xBEE1 },
	{ 0xBDF6,  0xCCC9 },
	{ 0xBDF7,  0xDD78 },
	{ 0xBDF8,  0xDD76 },
	{ 0xBDF9,  0xDD7A },
	{ 0xBDFA,  0xDD85 },
	{ 0xBDFB,  0xDD82 },
	{ 0xBDFC,  0xDD86 },
	{ 0xBDFD,  0xDD77 },
	{ 0xBDFE,  0xDD79 },
	{ 0xBE40,  0xDD81 },
	{ 0xBE41,  0xDF6D },
	{ 0xBE42,  0xD5DA },
	{ 0xBE43,  0xE5DB },
	{ 0xBE44,  0xD4E2 },
	{ 0xBE45,  0xDF77 },
	{ 0xBE46,  0xE08F },
	{ 0xBE47,  0xE08D },
	{ 0xBE48,  0xE087 },
	{ 0xBE49,  0xDBB6 },
	{ 0xBE4A,  0xB4BC },
	{ 0xBE4B,  0xD7ED },
	{ 0xBE4C,  0xB4D7 },
	{ 0xBE4D,  0xE15A },
	{ 0xBE4E,  0xE45C },
	{ 0xBE4F,  0xE452 },
	{ 0xBE50,  0xE44E },
	{ 0xBE51,  0xE481 },
	{ 0xBE52,  0xE444 },
	{ 0xBE53,  0xE47A },
	{ 0xBE54,  0xE458 },
	{ 0xBE55,  0xE44A },
	{ 0xBE56,  0xE453 },
	{ 0xBE57,  0xE468 },
	{ 0xBE58,  0xE45E },
	{ 0xBE59,  0xE487 },
	{ 0xBE5A,  0xE449 },
	{ 0xBE5B,  0xE982 },
	{ 0xBE5C,  0xE986 },
	{ 0xBE5D,  0xCFF6 },
	{ 0xBE5E,  0xF6AA },
	{ 0xBE5F,  0xD5F0 },
	{ 0xBE60,  0xC3B9 },
	{ 0xBE61,  0xBFBF },
	{ 0xBE62,  0xB0B0 },
	{ 0xBE63,  0xD0AC },
	{ 0xBE64,  0xEC96 },
	{ 0xBE65,  0xEE52 },
	{ 0xBE66,  0xEE5C },
	{ 0xBE67,  0xEE4D },
	{ 0xBE68,  0xEF57 },
	{ 0xBE69,  0xF042 },
	{ 0xBE6A,  0xF049 },
	{ 0xBE6B,  0xF048 },
	{ 0xBE6C,  0xF04E },
	{ 0xBE6D,  0xF184 },
	{ 0xBE6E,  0xF176 },
	{ 0xBE6F,  0xF186 },
	{ 0xBE70,  0xF182 },
	{ 0xBE71,  0xF177 },
	{ 0xBE72,  0xF17B },
	{ 0xBE73,  0xF178 },
	{ 0xBE74,  0xF180 },
	{ 0xBE75,  0xF7BC },
	{ 0xBE76,  0xF38C },
	{ 0xBE77,  0xF7D7 },
	{ 0xBE78,  0xF45B },
	{ 0xBE79,  0xF7C8 },
	{ 0xBE7A,  0xC6C7 },
	{ 0xBE7B,  0xF49C },
	{ 0xBE7C,  0xF494 },
	{ 0xBE7D,  0xF863 },
	{ 0xBE7E,  0xF866 },
	{ 0xBEA1,  0xF860 },
	{ 0xBEA2,  0xFB9F },
	{ 0xBEA3,  0xF7E2 },
	{ 0xBEA4,  0xC0E8 },
	{ 0xBEA5,  0xC4AB },
	{ 0xBEA6,  0xFD58 },
	{ 0xBEA7,  0xC8E5 },
	{ 0xBEA8,  0x838D },
	{ 0xBEA9,  0x8389 },
	{ 0xBEAA,  0x8386 },
	{ 0xBEAB,  0x838A },
	{ 0xBEAC,  0xBCBD },
	{ 0xBEAD,  0x83E7 },
	{ 0xBEAE,  0xC4FD },
	{ 0xBEAF,  0x84A9 },
	{ 0xBEB0,  0xD8E6 },
	{ 0xBEB1,  0x84EC },
	{ 0xBEB2,  0xE0DF },
	{ 0xBEB3,  0xE0E6 },
	{ 0xBEB4,  0x878E },
	{ 0xBEB5,  0xD8AC },
	{ 0xBEB6,  0xE0E4 },
	{ 0xBEB7,  0x878D },
	{ 0xBEB8,  0xD4EB },
	{ 0xBEB9,  0xC6F7 },
	{ 0xBEBA,  0x8781 },
	{ 0xBEBB,  0xE0E5 },
	{ 0xBEBC,  0x8786 },
	{ 0xBEBD,  0xCAC9 },
	{ 0xBEBE,  0xE0DE },
	{ 0xBEBF,  0xB8C1 },
	{ 0xBEC0,  0xB1DA },
	{ 0xBEC1,  0x89A8 },
	{ 0xBEC2,  0x89AF },
	{ 0xBEC3,  0xDBD5 },
	{ 0xBEC4,  0x8A5E },
	{ 0xBEC5,  0x8BD8 },
	{ 0xBEC6,  0xD9F8 },
	{ 0xBEC7,  0x8C57 },
	{ 0xBEC8,  0xE5BE },
	{ 0xBEC9,  0x8CA7 },
	{ 0xBECA,  0x8F99 },
	{ 0xBECB,  0x9197 },
	{ 0xBECC,  0x917B },
	{ 0xBECD,  0xEDAC },
	{ 0xBECE,  0x9176 },
	{ 0xBECF,  0x91AC },
	{ 0xBED0,  0x919B },
	{ 0xBED1,  0xBAB6 },
	{ 0xBED2,  0xB0C3 },
	{ 0xBED3,  0xD0B8 },
	{ 0xBED4,  0x91F0 },
	{ 0xBED5,  0xC9C3 },
	{ 0xBED6,  0x93ED },
	{ 0xBED7,  0x93F5 },
	{ 0xBED8,  0x93E9 },
	{ 0xBED9,  0xBAB3 },
	{ 0xBEDA,  0x93FE },
	{ 0xBEDB,  0x93EF },
	{ 0xBEDC,  0x93F1 },
	{ 0xBEDD,  0xC0DE },
	{ 0xBEDE,  0xB2D9 },
	{ 0xBEDF,  0x93EC },
	{ 0xBEE0,  0xC7DC },
	{ 0xBEE1,  0x93FA },
	{ 0xBEE2,  0x93EB },
	{ 0xBEE3,  0xD5FB },
	{ 0xBEE4,  0x95D1 },
	{ 0xBEE5,  0x95D4 },
	{ 0xBEE6,  0xE5DF },
	{ 0xBEE7,  0x95CF },
	{ 0xBEE8,  0x95D2 },
	{ 0xBEE9,  0x95C5 },
	{ 0xBEEA,  0xE9D7 },
	{ 0xBEEB,  0x98E3 },
	{ 0xBEEC,  0x98E5 },
	{ 0xBEED,  0xB3C8 },
	{ 0xBEEE,  0x994D },
	{ 0xBEEF,  0xE9D9 },
	{ 0xBEF0,  0x98E4 },
	{ 0xBEF1,  0xE9CF },
	{ 0xBEF2,  0x9945 },
	{ 0xBEF3,  0xCFF0 },
	{ 0xBEF4,  0x98F2 },
	{ 0xBEF5,  0xC7C1 },
	{ 0xBEF6,  0xE9D4 },
	{ 0xBEF7,  0x9943 },
	{ 0xBEF8,  0x98EF },
	{ 0xBEF9,  0xECA8 },
	{ 0xBEFA,  0x9A76 },
	{ 0xBEFB,  0xEBA9 },
	{ 0xBEFC,  0xE5A5 },
	{ 0xBEFD,  0x9DD5 },
	{ 0xBEFE,  0xD4E8 },
	{ 0xBF40,  0x9DE2 },
	{ 0xBF41,  0x9DC9 },
	{ 0xBF42,  0x9DE1 },
	{ 0xBF43,  0xE5A2 },
	{ 0xBF44,  0xB0C4 },
	{ 0xBF45,  0xBCA4 },
	{ 0xBF46,  0xE5A3 },
	{ 0xBF47,  0xE5A4 },
	{ 0xBF48,  0x9DCB },
	{ 0xBF49,  0x9DC6 },
	{ 0xBF4A,  0x9DD7 },
	{ 0xBF4B,  0x9FEB },
	{ 0xBF4C,  0x9FF5 },
	{ 0xBF4D,  0x9FFB },
	{ 0xBF4E,  0x9FFD },
	{ 0xBF4F,  0x9FF4 },
	{ 0xBF50,  0xD1E0 },
	{ 0xBF51,  0xECE4 },
	{ 0xBF52,  0xC1C7 },
	{ 0xBF53,  0xA043 },
	{ 0xBF54,  0xA046 },
	{ 0xBF55,  0xC8BC },
	{ 0xBF56,  0x9FF0 },
	{ 0xBF57,  0xAA9A },
	{ 0xBF58,  0xE8AB },
	{ 0xBF59,  0xAD5E },
	{ 0xBF5A,  0xAD55 },
	{ 0xBF5B,  0xAD5A },
	{ 0xBF5C,  0xE8B1 },
	{ 0xBF5D,  0xC6B0 },
	{ 0xBF5E,  0xAE54 },
	{ 0xBF5F,  0xDDF9 },
	{ 0xBF60,  0xD5CE },
	{ 0xBF61,  0xC8B3 },
	{ 0xBF62,  0xAF9B },
	{ 0xBF63,  0xB152 },
	{ 0xBF64,  0xEEC2 },
	{ 0xBF65,  0xEEAA },
	{ 0xBF66,  0xB26D },
	{ 0xBF67,  0xEEA9 },
	{ 0xBF68,  0xC6B3 },
	{ 0xBF69,  0xC4A5 },
	{ 0xBF6A,  0xB475 },
	{ 0xBF6B,  0xEDE0 },
	{ 0xBF6C,  0xB483 },
	{ 0xBF6D,  0xB652 },
	{ 0xBF6E,  0xB765 },
	{ 0xBF6F,  0xB766 },
	{ 0xBF70,  0xC4C2 },
	{ 0xBF71,  0xB764 },
	{ 0xBF72,  0xB763 },
	{ 0xBF73,  0xB851 },
	{ 0xBF74,  0xB8DD },
	{ 0xBF75,  0xBA77 },
	{ 0xBF76,  0xBA42 },
	{ 0xBF77,  0xBA56 },
	{ 0xBF78,  0xBA4F },
	{ 0xBF79,  0xB4DB },
	{ 0xBF7A,  0xBA59 },
	{ 0xBF7B,  0xF3F7 },
	{ 0xBF7C,  0xB8E2 },
	{ 0xBF7D,  0xCCC7 },
	{ 0xBF7E,  0xBF4F },
	{ 0xBFA1,  0xBF56 },
	{ 0xBFA2,  0xBF4D },
	{ 0xBFA3,  0xBF60 },
	{ 0xBFA4,  0xBF68 },
	{ 0xBFA5,  0xBF63 },
	{ 0xBFA6,  0xBF62 },
	{ 0xBFA7,  0xBF4E },
	{ 0xBFA8,  0xBF55 },
	{ 0xBFA9,  0xEEBE },
	{ 0xBFAA,  0xF4CB },
	{ 0xBFAB,  0xBAB2 },
	{ 0xBFAC,  0xB0BF },
	{ 0xBFAD,  0xF4E7 },
	{ 0xBFAE,  0xF1F1 },
	{ 0xBFAF,  0xC9C5 },
	{ 0xBFB0,  0xC481 },
	{ 0xBFB1,  0xC5F2 },
	{ 0xBFB2,  0xD5E9 },
	{ 0xBFB3,  0xC564 },
	{ 0xBFB4,  0xCBD2 },
	{ 0xBFB5,  0xC593 },
	{ 0xBFB6,  0xC8EF },
	{ 0xBFB7,  0xDEA5 },
	{ 0xBFB8,  0xDEA6 },
	{ 0xBFB9,  0xDEA7 },
	{ 0xBFBA,  0xCA8E },
	{ 0xBFBB,  0xDEAC },
	{ 0xBFBC,  0xBDB6 },
	{ 0xBFBD,  0xCA92 },
	{ 0xBFBE,  0xCA8F },
	{ 0xBFBF,  0xDEA9 },
	{ 0xBFC0,  0xF3A6 },
	{ 0xBFC1,  0xC3F8 },
	{ 0xBFC2,  0xCE9B },
	{ 0xBFC3,  0xCE9E },
	{ 0xBFC4,  0xC8DA },
	{ 0xBFC5,  0xBAE2 },
	{ 0xBFC6,  0xCDCA },
	{ 0xBFC7,  0xD19D },
	{ 0xBFC8,  0xC8EC },
	{ 0xBFC9,  0xF1DD },
	{ 0xBFCA,  0xF1D7 },
	{ 0xBFCB,  0xD348 },
	{ 0xBFCC,  0xD344 },
	{ 0xBFCD,  0xD642 },
	{ 0xBFCE,  0xD656 },
	{ 0xBFCF,  0xD647 },
	{ 0xBFD0,  0xD64D },
	{ 0xBFD1,  0xD65C },
	{ 0xBFD2,  0xD599 },
	{ 0xBFD3,  0xD643 },
	{ 0xBFD4,  0xD64A },
	{ 0xBFD5,  0xD65A },
	{ 0xBFD6,  0xD65D },
	{ 0xBFD7,  0xD65E },
	{ 0xBFD8,  0xD653 },
	{ 0xBFD9,  0xD649 },
	{ 0xBFDA,  0xD64F },
	{ 0xBFDB,  0xD652 },
	{ 0xBFDC,  0xD658 },
	{ 0xBFDD,  0xD4A5 },
	{ 0xBFDE,  0xD86A },
	{ 0xBFDF,  0xD888 },
	{ 0xBFE0,  0xD987 },
	{ 0xBFE1,  0xCCE3 },
	{ 0xBFE2,  0xF5E2 },
	{ 0xBFE3,  0xDB78 },
	{ 0xBFE4,  0xF5E5 },
	{ 0xBFE5,  0xF5DF },
	{ 0xBFE6,  0xF5E0 },
	{ 0xBFE7,  0xDD97 },
	{ 0xBFE8,  0xDD8B },
	{ 0xBFE9,  0xDD94 },
	{ 0xBFEA,  0xDD8F },
	{ 0xBFEB,  0xB1E6 },
	{ 0xBFEC,  0xDE6B },
	{ 0xBFED,  0xD7F1 },
	{ 0xBFEE,  0xE5E0 },
	{ 0xBFEF,  0xDF78 },
	{ 0xBFF0,  0xDF74 },
	{ 0xBFF1,  0xDF7C },
	{ 0xBFF2,  0xDF7A },
	{ 0xBFF3,  0xE092 },
	{ 0xBFF4,  0xD0D1 },
	{ 0xBFF5,  0xE556 },
	{ 0xBFF6,  0xE56C },
	{ 0xBFF7,  0xE48F },
	{ 0xBFF8,  0xE569 },
	{ 0xBFF9,  0xE565 },
	{ 0xBFFA,  0xE558 },
	{ 0xBFFB,  0xE493 },
	{ 0xBFFC,  0xE561 },
	{ 0xBFFD,  0xE49B },
	{ 0xBFFE,  0xE550 },
	{ 0xC040,  0xE546 },
	{ 0xC041,  0xE55C },
	{ 0xC042,  0xE557 },
	{ 0xC043,  0xE54B },
	{ 0xC044,  0xE564 },
	{ 0xC045,  0xE54F },
	{ 0xC046,  0xE990 },
	{ 0xC047,  0xCBED },
	{ 0xC048,  0xEB53 },
	{ 0xC049,  0xEB55 },
	{ 0xC04A,  0xB5F1 },
	{ 0xC04B,  0xF6AE },
	{ 0xC04C,  0xEB95 },
	{ 0xC04D,  0xC1D8 },
	{ 0xC04E,  0xBBF4 },
	{ 0xC04F,  0xC4DE },
	{ 0xC050,  0xF6AD },
	{ 0xC051,  0xB5E5 },
	{ 0xC052,  0xEC6F },
	{ 0xC053,  0xEC74 },
	{ 0xC054,  0xC7CA },
	{ 0xC055,  0xEE61 },
	{ 0xC056,  0xEE69 },
	{ 0xC057,  0xEE6C },
	{ 0xC058,  0xEE68 },
	{ 0xC059,  0xEE5E },
	{ 0xC05A,  0xEE6A },
	{ 0xC05B,  0xEE55 },
	{ 0xC05C,  0xB2CD },
	{ 0xC05D,  0xF05E },
	{ 0xC05E,  0xF054 },
	{ 0xC05F,  0xF051 },
	{ 0xC060,  0xF057 },
	{ 0xC061,  0xF050 },
	{ 0xC062,  0xF194 },
	{ 0xC063,  0xF189 },
	{ 0xC064,  0xF198 },
	{ 0xC065,  0xBAA1 },
	{ 0xC066,  0xF7C0 },
	{ 0xC067,  0xF7D9 },
	{ 0xC068,  0xF7DA },
	{ 0xC069,  0xF45C },
	{ 0xC06A,  0xF555 },
	{ 0xC06B,  0xF872 },
	{ 0xC06C,  0xF881 },
	{ 0xC06D,  0xF884 },
	{ 0xC06E,  0xF886 },
	{ 0xC06F,  0xF86F },
	{ 0xC070,  0xF878 },
	{ 0xC071,  0xC4AC },
	{ 0xC072,  0xC7AD },
	{ 0xC073,  0xFD88 },
	{ 0xC074,  0xFD94 },
	{ 0xC075,  0x839E },
	{ 0xC076,  0x8394 },
	{ 0xC077,  0xC0DC },
	{ 0xC078,  0x83A6 },
	{ 0xC079,  0x84EE },
	{ 0xC07A,  0xBABF },
	{ 0xC07B,  0x8793 },
	{ 0xC07C,  0x879F },
	{ 0xC07D,  0xE0E9 },
	{ 0xC07E,  0x8798 },
	{ 0xC0A1,  0xCCE7 },
	{ 0xC0A2,  0xBABE },
	{ 0xC0A3,  0x89BA },
	{ 0xC0A4,  0xDBD6 },
	{ 0xC0A5,  0x89B6 },
	{ 0xC0A6,  0x8BEB },
	{ 0xC0A7,  0x8BE5 },
	{ 0xC0A8,  0x8BDF },
	{ 0xC0A9,  0xC8E6 },
	{ 0xC0AA,  0x8CC0 },
	{ 0xC0AB,  0x8CD5 },
	{ 0xC0AC,  0x8E5A },
	{ 0xC0AD,  0x8E58 },
	{ 0xC0AE,  0x8E5B },
	{ 0xC0AF,  0x8E56 },
	{ 0xC0B0,  0x8ECD },
	{ 0xC0B1,  0x8F9B },
	{ 0xC0B2,  0xBBD5 },
	{ 0xC0B3,  0x91AA },
	{ 0xC0B4,  0xB6AE },
	{ 0xC0B5,  0x91A9 },
	{ 0xC0B6,  0xC5B3 },
	{ 0xC0B7,  0xEDAE },
	{ 0xC0B8,  0x91F2 },
	{ 0xC0B9,  0xB4F7 },
	{ 0xC0BA,  0xC7E6 },
	{ 0xC0BB,  0x93F4 },
	{ 0xC0BC,  0xEBA2 },
	{ 0xC0BD,  0x9444 },
	{ 0xC0BE,  0x9451 },
	{ 0xC0BF,  0xB2C1 },
	{ 0xC0C0,  0x944D },
	{ 0xC0C1,  0x9452 },
	{ 0xC0C2,  0xDFAA },
	{ 0xC0C3,  0x944E },
	{ 0xC0C4,  0x94BF },
	{ 0xC0C5,  0x94C0 },
	{ 0xC0C6,  0xCAEF },
	{ 0xC0C7,  0x95E1 },
	{ 0xC0C8,  0xCCB4 },
	{ 0xC0C9,  0x996E },
	{ 0xC0CA,  0xCFAD },
	{ 0xC0CB,  0x997A },
	{ 0xC0CC,  0x9975 },
	{ 0xC0CD,  0x99B1 },
	{ 0xC0CE,  0x997B },
	{ 0xC0CF,  0x995D },
	{ 0xC0D0,  0xE9DE },
	{ 0xC0D1,  0xE9DC },
	{ 0xC0D2,  0xE9D1 },
	{ 0xC0D3,  0x9A62 },
	{ 0xC0D4,  0x9A9A },
	{ 0xC0D5,  0x9AB4 },
	{ 0xC0D6,  0x9AD6 },
	{ 0xC0D7,  0x9DF4 },
	{ 0xC0D8,  0x9E49 },
	{ 0xC0D9,  0x9DFA },
	{ 0xC0DA,  0xE5A9 },
	{ 0xC0DB,  0x9DF7 },
	{ 0xC0DC,  0x9DFD },
	{ 0xC0DD,  0x9E45 },
	{ 0xC0DE,  0xE5AA },
	{ 0xC0DF,  0x9DAD },
	{ 0xC0E0,  0x9E46 },
	{ 0xC0E1,  0xE5A6 },
	{ 0xC0E2,  0x9E43 },
	{ 0xC0E3,  0x9DF1 },
	{ 0xC0E4,  0xE5A7 },
	{ 0xC0E5,  0x9E48 },
	{ 0xC0E6,  0xECDD },
	{ 0xC0E7,  0xA049 },
	{ 0xC0E8,  0xDBC6 },
	{ 0xC0E9,  0xA04E },
	{ 0xC0EA,  0xD4EF },
	{ 0xC0EB,  0xA054 },
	{ 0xC0EC,  0xA053 },
	{ 0xC0ED,  0xA05A },
	{ 0xC0EE,  0xECDB },
	{ 0xC0EF,  0xBEF4 },
	{ 0xC0F0,  0xA09D },
	{ 0xC0F1,  0xAA9F },
	{ 0xC0F2,  0xAB40 },
	{ 0xC0F3,  0xE8B3 },
	{ 0xC0F4,  0xAD68 },
	{ 0xC0F5,  0xAD61 },
	{ 0xC0F6,  0xE8B2 },
	{ 0xC0F7,  0xB041 },
	{ 0xC0F8,  0xAF9F },
	{ 0xC0F9,  0xB0A9 },
	{ 0xC0FA,  0xB155 },
	{ 0xC0FB,  0xCDAB },
	{ 0xC0FC,  0xB5C9 },
	{ 0xC0FD,  0xEEAB },
	{ 0xC0FE,  0xCBB2 },
	{ 0xC140,  0xC7C6 },
	{ 0xC141,  0xB274 },
	{ 0xC142,  0xB343 },
	{ 0xC143,  0xC1D7 },
	{ 0xC144,  0xBBC7 },
	{ 0xC145,  0xEDE3 },
	{ 0xC146,  0xB489 },
	{ 0xC147,  0xBDB8 },
	{ 0xC148,  0xECFB },
	{ 0xC149,  0xB655 },
	{ 0xC14A,  0xCBEB },
	{ 0xC14B,  0xC1FE },
	{ 0xC14C,  0xB4D8 },
	{ 0xC14D,  0xBA74 },
	{ 0xC14E,  0xF3FA },
	{ 0xC14F,  0xC5F1 },
	{ 0xC150,  0xF3F9 },
	{ 0xC151,  0xBA53 },
	{ 0xC152,  0xBFB7 },
	{ 0xC153,  0xC3D3 },
	{ 0xC154,  0xBC53 },
	{ 0xC155,  0xBC55 },
	{ 0xC156,  0xD4E3 },
	{ 0xC157,  0xB2DA },
	{ 0xC158,  0xBC52 },
	{ 0xC159,  0xBF73 },
	{ 0xC15A,  0xBF83 },
	{ 0xC15B,  0xBF8A },
	{ 0xC15C,  0xBF7C },
	{ 0xC15D,  0xBF77 },
	{ 0xC15E,  0xBF87 },
	{ 0xC15F,  0xBF70 },
	{ 0xC160,  0xBF82 },
	{ 0xC161,  0xBF76 },
	{ 0xC162,  0xBF89 },
	{ 0xC163,  0xB7B1 },
	{ 0xC164,  0xBF79 },
	{ 0xC165,  0xBF7E },
	{ 0xC166,  0xBF8B },
	{ 0xC167,  0xBF7A },
	{ 0xC168,  0xBF84 },
	{ 0xC169,  0xBF74 },
	{ 0xC16A,  0xF3C0 },
	{ 0xC16B,  0xF4E8 },
	{ 0xC16C,  0xD2ED },
	{ 0xC16D,  0xF1FA },
	{ 0xC16E,  0xC295 },
	{ 0xC16F,  0xC294 },
	{ 0xC170,  0xC293 },
	{ 0xC171,  0xC296 },
	{ 0xC172,  0xD2DC },
	{ 0xC173,  0xD3B7 },
	{ 0xC174,  0xE2DF },
	{ 0xC175,  0xB1DB },
	{ 0xC176,  0xCDCE },
	{ 0xC177,  0xC493 },
	{ 0xC178,  0xC491 },
	{ 0xC179,  0xC498 },
	{ 0xC17A,  0xC492 },
	{ 0xC17B,  0xC552 },
	{ 0xC17C,  0xC565 },
	{ 0xC17D,  0xC644 },
	{ 0xC17E,  0xD0BD },
	{ 0xC1A1,  0xB1A1 },
	{ 0xC1A2,  0xC0D9 },
	{ 0xC1A3,  0xDEB5 },
	{ 0xC1A4,  0xCB4B },
	{ 0xC1A5,  0xCB4E },
	{ 0xC1A6,  0xCAED },
	{ 0xC1A7,  0xD1A6 },
	{ 0xC1A8,  0xDEB1 },
	{ 0xC1A9,  0xDEB0 },
	{ 0xC1AA,  0xCB45 },
	{ 0xC1AB,  0xCC9D },
	{ 0xC1AC,  0xF3B0 },
	{ 0xC1AD,  0xF3AF },
	{ 0xC1AE,  0xF3AB },
	{ 0xC1AF,  0xF2FE },
	{ 0xC1B0,  0xF3A1 },
	{ 0xC1B1,  0xF3A7 },
	{ 0xC1B2,  0xCF4E },
	{ 0xC1B3,  0xC2DD },
	{ 0xC1B4,  0xCF58 },
	{ 0xC1B5,  0xF3AC },
	{ 0xC1B6,  0xD243 },
	{ 0xC1B7,  0xF1DE },
	{ 0xC1B8,  0xCFE5 },
	{ 0xC1B9,  0xD240 },
	{ 0xC1BA,  0xD245 },
	{ 0xC1BB,  0xD34A },
	{ 0xC1BC,  0xD669 },
	{ 0xC1BD,  0xD672 },
	{ 0xC1BE,  0xD674 },
	{ 0xC1BF,  0xD676 },
	{ 0xC1C0,  0xD665 },
	{ 0xC1C1,  0xD67B },
	{ 0xC1C2,  0xD678 },
	{ 0xC1C3,  0xD660 },
	{ 0xC1C4,  0xD66B },
	{ 0xC1C5,  0xBBED },
	{ 0xC1C6,  0xD847 },
	{ 0xC1C7,  0xE1D9 },
	{ 0xC1C8,  0xD98D },
	{ 0xC1C9,  0xD990 },
	{ 0xC1CA,  0xD98F },
	{ 0xC1CB,  0xD98B },
	{ 0xC1CC,  0xD98E },
	{ 0xC1CD,  0xDA85 },
	{ 0xC1CE,  0xF5E3 },
	{ 0xC1CF,  0xCCA3 },
	{ 0xC1D0,  0xB5B8 },
	{ 0xC1D1,  0xF5E8 },
	{ 0xC1D2,  0xDDA0 },
	{ 0xC1D3,  0xDD9A },
	{ 0xC1D4,  0xDD9E },
	{ 0xC1D5,  0xDE40 },
	{ 0xC1D6,  0xDD9B },
	{ 0xC1D7,  0xB1DC },
	{ 0xC1D8,  0xE5E1 },
	{ 0xC1D9,  0xDF80 },
	{ 0xC1DA,  0xDF7E },
	{ 0xC1DB,  0xE5E2 },
	{ 0xC1DC,  0xD1FB },
	{ 0xC1DD,  0xDBB8 },
	{ 0xC1DE,  0xF5B1 },
	{ 0xC1DF,  0xE16A },
	{ 0xC1E0,  0xE168 },
	{ 0xC1E1,  0xE583 },
	{ 0xC1E2,  0xE656 },
	{ 0xC1E3,  0xE55E },
	{ 0xC1E4,  0xE649 },
	{ 0xC1E5,  0xE580 },
	{ 0xC1E6,  0xE59B },
	{ 0xC1E7,  0xE581 },
	{ 0xC1E8,  0xE54E },
	{ 0xC1E9,  0xE652 },
	{ 0xC1EA,  0xE640 },
	{ 0xC1EB,  0xE591 },
	{ 0xC1EC,  0xE644 },
	{ 0xC1ED,  0xE590 },
	{ 0xC1EE,  0xE58A },
	{ 0xC1EF,  0xE99F },
	{ 0xC1F0,  0xE9A0 },
	{ 0xC1F1,  0xEA40 },
	{ 0xC1F2,  0xE99D },
	{ 0xC1F3,  0xE99B },
	{ 0xC1F4,  0xEB5B },
	{ 0xC1F5,  0xEB60 },
	{ 0xC1F6,  0xEB6D },
	{ 0xC1F7,  0xCBAA },
	{ 0xC1F8,  0xCFBC },
	{ 0xC1F9,  0xBECF },
	{ 0xC1FA,  0xED6E },
	{ 0xC1FB,  0xEE77 },
	{ 0xC1FC,  0xEF5A },
	{ 0xC1FD,  0xF06A },
	{ 0xC1FE,  0xF247 },
	{ 0xC240,  0xF245 },
	{ 0xC241,  0xF572 },
	{ 0xC242,  0xF56F },
	{ 0xC243,  0xF56E },
	{ 0xC244,  0xF571 },
	{ 0xC245,  0xF899 },
	{ 0xC246,  0xF89D },
	{ 0xC247,  0xF7E7 },
	{ 0xC248,  0xF0A4 },
	{ 0xC249,  0xFC63 },
	{ 0xC24A,  0xF7ED },
	{ 0xC24B,  0xF7EE },
	{ 0xC24C,  0xF7EC },
	{ 0xC24D,  0xF7FD },
	{ 0xC24E,  0xFD53 },
	{ 0xC24F,  0x85B2 },
	{ 0xC250,  0x87A3 },
	{ 0xC251,  0x87BB },
	{ 0xC252,  0x89BF },
	{ 0xC253,  0x89BE },
	{ 0xC254,  0x8BF0 },
	{ 0xC255,  0xD2CD },
	{ 0xC256,  0x91BF },
	{ 0xC257,  0xB4C1 },
	{ 0xC258,  0x9455 },
	{ 0xC259,  0x9453 },
	{ 0xC25A,  0x945F },
	{ 0xC25B,  0x9466 },
	{ 0xC25C,  0x945B },
	{ 0xC25D,  0x945C },
	{ 0xC25E,  0x9458 },
	{ 0xC25F,  0x94E0 },
	{ 0xC260,  0xEAD7 },
	{ 0xC261,  0xEBFC },
	{ 0xC262,  0x9989 },
	{ 0xC263,  0xC3CA },
	{ 0xC264,  0x9999 },
	{ 0xC265,  0x9991 },
	{ 0xC266,  0x998E },
	{ 0xC267,  0x9998 },
	{ 0xC268,  0x9984 },
	{ 0xC269,  0x9985 },
	{ 0xC26A,  0x9A65 },
	{ 0xC26B,  0x9A77 },
	{ 0xC26C,  0x9A9B },
	{ 0xC26D,  0x9E61 },
	{ 0xC26E,  0x9E63 },
	{ 0xC26F,  0x9E56 },
	{ 0xC270,  0x9E5E },
	{ 0xC271,  0x9E52 },
	{ 0xC272,  0xC6D9 },
	{ 0xC273,  0x9E67 },
	{ 0xC274,  0xA060 },
	{ 0xC275,  0xA061 },
	{ 0xC276,  0xA063 },
	{ 0xC277,  0xA05E },
	{ 0xC278,  0xAB45 },
	{ 0xC279,  0xAB43 },
	{ 0xC27A,  0xE8B5 },
	{ 0xC27B,  0xAD76 },
	{ 0xC27C,  0xAE59 },
	{ 0xC27D,  0xF1B1 },
	{ 0xC27E,  0xB04F },
	{ 0xC2A1,  0xB04B },
	{ 0xC2A2,  0xEEAD },
	{ 0xC2A3,  0xF6C4 },
	{ 0xC2A4,  0xD5B0 },
	{ 0xC2A5,  0xB280 },
	{ 0xC2A6,  0xB541 },
	{ 0xC2A7,  0xB659 },
	{ 0xC2A8,  0xB777 },
	{ 0xC2A9,  0xB778 },
	{ 0xC2AA,  0xB776 },
	{ 0xC2AB,  0xB85A },
	{ 0xC2AC,  0xB85B },
	{ 0xC2AD,  0xBA8D },
	{ 0xC2AE,  0xBBC9 },
	{ 0xC2AF,  0xF4A2 },
	{ 0xC2B0,  0xBA84 },
	{ 0xC2B1,  0xBA88 },
	{ 0xC2B2,  0xBA86 },
	{ 0xC2B3,  0xBC5A },
	{ 0xC2B4,  0xBF97 },
	{ 0xC2B5,  0xBF98 },
	{ 0xC2B6,  0xC040 },
	{ 0xC2B7,  0xBF9D },
	{ 0xC2B8,  0xC043 },
	{ 0xC2B9,  0xBF95 },
	{ 0xC2BA,  0xBF9C },
	{ 0xC2BB,  0xC097 },
	{ 0xC2BC,  0xC24E },
	{ 0xC2BD,  0xB7AD },
	{ 0xC2BE,  0xC29A },
	{ 0xC2BF,  0xC299 },
	{ 0xC2C0,  0xC49A },
	{ 0xC2C1,  0xC49C },
	{ 0xC2C2,  0xC566 },
	{ 0xC2C3,  0xB2D8 },
	{ 0xC2C4,  0xCB5F },
	{ 0xC2C5,  0xCB7B },
	{ 0xC2C6,  0xC3EA },
	{ 0xC2C7,  0xBDE5 },
	{ 0xC2C8,  0xDEB9 },
	{ 0xC2C9,  0xCB6A },
	{ 0xC2CA,  0xDEB7 },
	{ 0xC2CB,  0xCB5D },
	{ 0xC2CC,  0xCF75 },
	{ 0xC2CD,  0xCF73 },
	{ 0xC2CE,  0xCF78 },
	{ 0xC2CF,  0xF3B4 },
	{ 0xC2D0,  0xB8B2 },
	{ 0xC2D1,  0xD350 },
	{ 0xC2D2,  0xD378 },
	{ 0xC2D3,  0xD683 },
	{ 0xC2D4,  0xD694 },
	{ 0xC2D5,  0xD687 },
	{ 0xC2D6,  0xD686 },
	{ 0xC2D7,  0xD853 },
	{ 0xC2D8,  0xD998 },
	{ 0xC2D9,  0xF5BE },
	{ 0xC2DA,  0xDB98 },
	{ 0xC2DB,  0xB1C4 },
	{ 0xC2DC,  0xDB99 },
	{ 0xC2DD,  0xDB94 },
	{ 0xC2DE,  0xDB8B },
	{ 0xC2DF,  0xDC7C },
	{ 0xC2E0,  0xDE44 },
	{ 0xC2E1,  0xDE48 },
	{ 0xC2E2,  0xDF83 },
	{ 0xC2E3,  0xE5E4 },
	{ 0xC2E4,  0xE5E3 },
	{ 0xC2E5,  0xE174 },
	{ 0xC2E6,  0xE175 },
	{ 0xC2E7,  0xE18D },
	{ 0xC2E8,  0xE667 },
	{ 0xC2E9,  0xE65E },
	{ 0xC2EA,  0xE669 },
	{ 0xC2EB,  0xE675 },
	{ 0xC2EC,  0xE687 },
	{ 0xC2ED,  0xE682 },
	{ 0xC2EE,  0xE680 },
	{ 0xC2EF,  0xE684 },
	{ 0xC2F0,  0xE66B },
	{ 0xC2F1,  0xE66D },
	{ 0xC2F2,  0xE66A },
	{ 0xC2F3,  0xEA48 },
	{ 0xC2F4,  0xEA4A },
	{ 0xC2F5,  0xEA44 },
	{ 0xC2F6,  0xEA49 },
	{ 0xC2F7,  0xEB78 },
	{ 0xC2F8,  0xEB73 },
	{ 0xC2F9,  0xEB70 },
	{ 0xC2FA,  0xEB72 },
	{ 0xC2FB,  0xEB75 },
	{ 0xC2FC,  0xEC43 },
	{ 0xC2FD,  0xF7B7 },
	{ 0xC2FE,  0xED46 },
	{ 0xC340,  0xB1DE },
	{ 0xC341,  0xED8B },
	{ 0xC342,  0xEE7E },
	{ 0xC343,  0xEE81 },
	{ 0xC344,  0xEE7D },
	{ 0xC345,  0xEE80 },
	{ 0xC346,  0xEE85 },
	{ 0xC347,  0xEF5E },
	{ 0xC348,  0xF073 },
	{ 0xC349,  0xF074 },
	{ 0xC34A,  0xF072 },
	{ 0xC34B,  0xF7D1 },
	{ 0xC34C,  0xF0A5 },
	{ 0xC34D,  0xF254 },
	{ 0xC34E,  0xF7C1 },
	{ 0xC34F,  0xD7D7 },
	{ 0xC350,  0xF3A0 },
	{ 0xC351,  0xCEBA },
	{ 0xC352,  0xF475 },
	{ 0xC353,  0xF7CD },
	{ 0xC354,  0xF58F },
	{ 0xC355,  0xF58E },
	{ 0xC356,  0xF661 },
	{ 0xC357,  0xF58D },
	{ 0xC358,  0xF585 },
	{ 0xC359,  0xF94E },
	{ 0xC35A,  0xF95A },
	{ 0xC35B,  0xF95D },
	{ 0xC35C,  0xF7EF },
	{ 0xC35D,  0xFC8A },
	{ 0xC35E,  0xF7F8 },
	{ 0xC35F,  0x83A7 },
	{ 0xC360,  0x87B2 },
	{ 0xC361,  0x89C4 },
	{ 0xC362,  0x89C5 },
	{ 0xC363,  0x89C8 },
	{ 0xC364,  0x8C99 },
	{ 0xC365,  0xFD8B },
	{ 0xC366,  0x8F5D },
	{ 0xC367,  0x91CD },
	{ 0xC368,  0x91D1 },
	{ 0xC369,  0x91D0 },
	{ 0xC36A,  0xE3C2 },
	{ 0xC36B,  0xC5CA },
	{ 0xC36C,  0x946E },
	{ 0xC36D,  0x95E7 },
	{ 0xC36E,  0xC6D8 },
	{ 0xC36F,  0x99BB },
	{ 0xC370,  0x99B3 },
	{ 0xC371,  0x99B0 },
	{ 0xC372,  0x99A9 },
	{ 0xC373,  0xE5AD },
	{ 0xC374,  0x9E74 },
	{ 0xC375,  0x9E7C },
	{ 0xC376,  0xE5AB },
	{ 0xC377,  0x9E72 },
	{ 0xC378,  0x9E6C },
	{ 0xC379,  0x9E6F },
	{ 0xC37A,  0xB1AC },
	{ 0xC37B,  0xA071 },
	{ 0xC37C,  0xA0A9 },
	{ 0xC37D,  0xA0D9 },
	{ 0xC37E,  0xAB46 },
	{ 0xC3A1,  0xAB48 },
	{ 0xC3A2,  0xAD74 },
	{ 0xC3A3,  0xAD82 },
	{ 0xC3A4,  0xB0EA },
	{ 0xC3A5,  0xAEA0 },
	{ 0xC3A6,  0xBDAE },
	{ 0xC3A7,  0xB054 },
	{ 0xC3A8,  0xB056 },
	{ 0xC3A9,  0xB289 },
	{ 0xC3AA,  0xB54B },
	{ 0xC3AB,  0xB65C },
	{ 0xC3AC,  0xB782 },
	{ 0xC3AD,  0xB780 },
	{ 0xC3AE,  0xBA9F },
	{ 0xC3AF,  0xB2BE },
	{ 0xC3B0,  0xF4A4 },
	{ 0xC3B1,  0xBA9E },
	{ 0xC3B2,  0xBA99 },
	{ 0xC3B3,  0xF4A6 },
	{ 0xC3B4,  0xC04D },
	{ 0xC3B5,  0xC04F },
	{ 0xC3B6,  0xC05B },
	{ 0xC3B7,  0xC04B },
	{ 0xC3B8,  0xC04C },
	{ 0xC3B9,  0xC15F },
	{ 0xC3BA,  0xC055 },
	{ 0xC3BB,  0xC183 },
	{ 0xC3BC,  0xB8FE },
	{ 0xC3BD,  0xD9FA },
	{ 0xC3BE,  0xC544 },
	{ 0xC3BF,  0xB7AA },
	{ 0xC3C0,  0xCB87 },
	{ 0xC3C1,  0xCB92 },
	{ 0xC3C2,  0xC5BA },
	{ 0xC3C3,  0xCCD9 },
	{ 0xC3C4,  0xCB8E },
	{ 0xC3C5,  0xCB9F },
	{ 0xC3C6,  0xCF81 },
	{ 0xC3C7,  0xCF89 },
	{ 0xC3C8,  0xCF90 },
	{ 0xC3C9,  0xD0B7 },
	{ 0xC3CA,  0xF3B8 },
	{ 0xC3CB,  0xD264 },
	{ 0xC3CC,  0xBDF3 },
	{ 0xC3CD,  0xD25C },
	{ 0xC3CE,  0xF4C5 },
	{ 0xC3CF,  0xD69C },
	{ 0xC3D0,  0xD756 },
	{ 0xC3D1,  0xD752 },
	{ 0xC3D2,  0xD743 },
	{ 0xC3D3,  0xD754 },
	{ 0xC3D4,  0xD748 },
	{ 0xC3D5,  0xD749 },
	{ 0xC3D6,  0xD740 },
	{ 0xC3D7,  0xD753 },
	{ 0xC3D8,  0xD99B },
	{ 0xC3D9,  0xD99D },
	{ 0xC3DA,  0xF5EB },
	{ 0xC3DB,  0xB6D7 },
	{ 0xC3DC,  0xB3F9 },
	{ 0xC3DD,  0xF5EA },
	{ 0xC3DE,  0xB5C5 },
	{ 0xC3DF,  0xDC45 },
	{ 0xC3E0,  0xF5ED },
	{ 0xC3E1,  0xDE4F },
	{ 0xC3E2,  0xDE49 },
	{ 0xC3E3,  0xDE6F },
	{ 0xC3E4,  0xDF85 },
	{ 0xC3E5,  0xE5E5 },
	{ 0xC3E6,  0xE177 },
	{ 0xC3E7,  0xF5B4 },
	{ 0xC3E8,  0xE752 },
	{ 0xC3E9,  0xE743 },
	{ 0xC3EA,  0xE750 },
	{ 0xC3EB,  0xE697 },
	{ 0xC3EC,  0xE69C },
	{ 0xC3ED,  0xE74D },
	{ 0xC3EE,  0xE74E },
	{ 0xC3EF,  0xF7E9 },
	{ 0xC3F0,  0xE753 },
	{ 0xC3F1,  0xE6A0 },
	{ 0xC3F2,  0xE749 },
	{ 0xC3F3,  0xE755 },
	{ 0xC3F4,  0xE748 },
	{ 0xC3F5,  0xE759 },
	{ 0xC3F6,  0xEA50 },
	{ 0xC3F7,  0xEB5D },
	{ 0xC3F8,  0xEB79 },
	{ 0xC3F9,  0xF6AF },
	{ 0xC3FA,  0xEC46 },
	{ 0xC3FB,  0xC3D2 },
	{ 0xC3FC,  0xED77 },
	{ 0xC3FD,  0xED8D },
	{ 0xC3FE,  0xEE90 },
	{ 0xC440,  0xEE8A },
	{ 0xC441,  0xEE8D },
	{ 0xC442,  0xEF60 },
	{ 0xC443,  0xF07A },
	{ 0xC444,  0xF07E },
	{ 0xC445,  0xF25C },
	{ 0xC446,  0xF25F },
	{ 0xC447,  0xF445 },
	{ 0xC448,  0xF64C },
	{ 0xC449,  0xF64B },
	{ 0xC44A,  0xF59B },
	{ 0xC44B,  0xF5A0 },
	{ 0xC44C,  0xF987 },
	{ 0xC44D,  0xF95E },
	{ 0xC44E,  0xF96F },
	{ 0xC44F,  0xF967 },
	{ 0xC450,  0xF969 },
	{ 0xC451,  0xF7E8 },
	{ 0xC452,  0xFB90 },
	{ 0xC453,  0xC2B4 },
	{ 0xC454,  0xF4F0 },
	{ 0xC455,  0x84F1 },
	{ 0xC456,  0x87B5 },
	{ 0xC457,  0xC8C2 },
	{ 0xC458,  0x87C2 },
	{ 0xC459,  0x87C0 },
	{ 0xC45A,  0xBDC0 },
	{ 0xC45B,  0xC8C0 },
	{ 0xC45C,  0xE6D7 },
	{ 0xC45D,  0x8BFA },
	{ 0xC45E,  0xC4F5 },
	{ 0xC45F,  0x8C9A },
	{ 0xC460,  0x8E66 },
	{ 0xC461,  0x91D2 },
	{ 0xC462,  0x91D4 },
	{ 0xC463,  0xC8C1 },
	{ 0xC464,  0x9472 },
	{ 0xC465,  0x9476 },
	{ 0xC466,  0xEAD8 },
	{ 0xC467,  0x9656 },
	{ 0xC468,  0x99C2 },
	{ 0xC469,  0x9E91 },
	{ 0xC46A,  0x9E85 },
	{ 0xC46B,  0x9E87 },
	{ 0xC46C,  0xA074 },
	{ 0xC46D,  0xAB49 },
	{ 0xC46E,  0xAD87 },
	{ 0xC46F,  0xB057 },
	{ 0xC470,  0xB059 },
	{ 0xC471,  0xB556 },
	{ 0xC472,  0xB55A },
	{ 0xC473,  0xB55C },
	{ 0xC474,  0xB55B },
	{ 0xC475,  0xB85D },
	{ 0xC476,  0xB882 },
	{ 0xC477,  0xBB49 },
	{ 0xC478,  0xBB40 },
	{ 0xC479,  0xBCAE },
	{ 0xC47A,  0xC5B4 },
	{ 0xC47B,  0xBC61 },
	{ 0xC47C,  0xDE70 },
	{ 0xC47D,  0xC05F },
	{ 0xC47E,  0xC05E },
	{ 0xC4A1,  0xD7EB },
	{ 0xC4A2,  0xC09B },
	{ 0xC4A3,  0xD2AB },
	{ 0xC4A4,  0xC546 },
	{ 0xC4A5,  0xC59E },
	{ 0xC4A6,  0xD4E5 },
	{ 0xC4A7,  0xCC40 },
	{ 0xC4A8,  0xC4A2 },
	{ 0xC4A9,  0xCC41 },
	{ 0xC4AA,  0xCC4A },
	{ 0xC4AB,  0xCC4F },
	{ 0xC4AC,  0xCC4B },
	{ 0xC4AD,  0xCC4E },
	{ 0xC4AE,  0xCF96 },
	{ 0xC4AF,  0xC8E4 },
	{ 0xC4B0,  0xD268 },
	{ 0xC4B1,  0xD358 },
	{ 0xC4B2,  0xD37C },
	{ 0xC4B3,  0xD768 },
	{ 0xC4B4,  0xC6A9 },
	{ 0xC4B5,  0xBEAF },
	{ 0xC4B6,  0xD767 },
	{ 0xC4B7,  0xD759 },
	{ 0xC4B8,  0xD764 },
	{ 0xC4B9,  0xDA41 },
	{ 0xC4BA,  0xD9A0 },
	{ 0xC4BB,  0xDC4F },
	{ 0xC4BC,  0xD4EA },
	{ 0xC4BD,  0xF5EE },
	{ 0xC4BE,  0xDC4A },
	{ 0xC4BF,  0xF5B7 },
	{ 0xC4C0,  0xE18C },
	{ 0xC4C1,  0xE78A },
	{ 0xC4C2,  0xE774 },
	{ 0xC4C3,  0xE76E },
	{ 0xC4C4,  0xEA55 },
	{ 0xC4C5,  0xF6B1 },
	{ 0xC4C6,  0xEF68 },
	{ 0xC4C7,  0xF088 },
	{ 0xC4C8,  0xF087 },
	{ 0xC4C9,  0xDCB0 },
	{ 0xC4CA,  0xF271 },
	{ 0xC4CB,  0xF276 },
	{ 0xC4CC,  0xF27D },
	{ 0xC4CD,  0xF27B },
	{ 0xC4CE,  0xF677 },
	{ 0xC4CF,  0xF671 },
	{ 0xC4D0,  0xFB79 },
	{ 0xC4D1,  0xFC49 },
	{ 0xC4D2,  0xFC68 },
	{ 0xC4D3,  0xF7F9 },
	{ 0xC4D4,  0xFD65 },
	{ 0xC4D5,  0xFD69 },
	{ 0xC4D6,  0xFD67 },
	{ 0xC4D7,  0x83AB },
	{ 0xC4D8,  0x83AC },
	{ 0xC4D9,  0x87CB },
	{ 0xC4DA,  0x87CA },
	{ 0xC4DB,  0x87CC },
	{ 0xC4DC,  0xD9E7 },
	{ 0xC4DD,  0x8CD9 },
	{ 0xC4DE,  0xCEA1 },
	{ 0xC4DF,  0x91D6 },
	{ 0xC4E0,  0x91D8 },
	{ 0xC4E1,  0x947A },
	{ 0xC4E2,  0x9479 },
	{ 0xC4E3,  0x94CC },
	{ 0xC4E4,  0xEAD9 },
	{ 0xC4E5,  0x99D1 },
	{ 0xC4E6,  0x99DA },
	{ 0xC4E7,  0x99D0 },
	{ 0xC4E8,  0x9A9E },
	{ 0xC4E9,  0xB9E0 },
	{ 0xC4EA,  0xA080 },
	{ 0xC4EB,  0xA0DE },
	{ 0xC4EC,  0xAD8D },
	{ 0xC4ED,  0xAD8B },
	{ 0xC4EE,  0xB05D },
	{ 0xC4EF,  0xB294 },
	{ 0xC4F0,  0xBB4C },
	{ 0xC4F1,  0xC070 },
	{ 0xC4F2,  0xC06D },
	{ 0xC4F3,  0xE5F1 },
	{ 0xC4F4,  0xCC59 },
	{ 0xC4F5,  0xCC6D },
	{ 0xC4F6,  0xCC5C },
	{ 0xC4F7,  0xCFA0 },
	{ 0xC4F8,  0xB4C0 },
	{ 0xC4F9,  0xF3BB },
	{ 0xC4FA,  0xCF9E },
	{ 0xC4FB,  0xD26D },
	{ 0xC4FC,  0xD26F },
	{ 0xC4FD,  0xD35B },
	{ 0xC4FE,  0xD76C },
	{ 0xC540,  0xD76F },
	{ 0xC541,  0xD775 },
	{ 0xC542,  0xDA45 },
	{ 0xC543,  0xDC50 },
	{ 0xC544,  0xDC53 },
	{ 0xC545,  0xDC51 },
	{ 0xC546,  0xDE5A },
	{ 0xC547,  0xDE71 },
	{ 0xC548,  0xF5B8 },
	{ 0xC549,  0xE7A0 },
	{ 0xC54A,  0xE844 },
	{ 0xC54B,  0xE846 },
	{ 0xC54C,  0xE84B },
	{ 0xC54D,  0xE849 },
	{ 0xC54E,  0xE843 },
	{ 0xC54F,  0xE79D },
	{ 0xC550,  0xEA56 },
	{ 0xC551,  0xB0D4 },
	{ 0xC552,  0xC5F9 },
	{ 0xC553,  0xC2B6 },
	{ 0xC554,  0xED91 },
	{ 0xC555,  0xEE99 },
	{ 0xC556,  0xEE97 },
	{ 0xC557,  0xF08B },
	{ 0xC558,  0xF28C },
	{ 0xC559,  0xF28A },
	{ 0xC55A,  0xF287 },
	{ 0xC55B,  0xF285 },
	{ 0xC55C,  0xF374 },
	{ 0xC55D,  0xC4A7 },
	{ 0xC55E,  0xF7CE },
	{ 0xC55F,  0xF692 },
	{ 0xC560,  0xF68A },
	{ 0xC561,  0xFA4C },
	{ 0xC562,  0xFA51 },
	{ 0xC563,  0xFA5F },
	{ 0xC564,  0xFA55 },
	{ 0xC565,  0xF7EA },
	{ 0xC566,  0xF7F6 },
	{ 0xC567,  0xDCB1 },
	{ 0xC568,  0xFD62 },
	{ 0xC569,  0xFD6C },
	{ 0xC56A,  0xFD6D },
	{ 0xC56B,  0x83B0 },
	{ 0xC56C,  0x83AF },
	{ 0xC56D,  0x87D2 },
	{ 0xC56E,  0xC4D2 },
	{ 0xC56F,  0x87D3 },
	{ 0xC570,  0x8C5C },
	{ 0xC571,  0x8E70 },
	{ 0xC572,  0x8E6E },
	{ 0xC573,  0x8F9D },
	{ 0xC574,  0xDCB2 },
	{ 0xC575,  0x9482 },
	{ 0xC576,  0x99E0 },
	{ 0xC577,  0x9A67 },
	{ 0xC578,  0x9EA2 },
	{ 0xC579,  0x9EA9 },
	{ 0xC57A,  0xAB4D },
	{ 0xC57B,  0xC8BF },
	{ 0xC57C,  0xAF42 },
	{ 0xC57D,  0xB061 },
	{ 0xC57E,  0xB05F },
	{ 0xC5A1,  0xECFC },
	{ 0xC5A2,  0xBB5C },
	{ 0xC5A3,  0xBB5B },
	{ 0xC5A4,  0xC340 },
	{ 0xC5A5,  0xC2A0 },
	{ 0xC5A6,  0xC54B },
	{ 0xC5A7,  0xD275 },
	{ 0xC5A8,  0xD272 },
	{ 0xC5A9,  0xD381 },
	{ 0xC5AA,  0xD778 },
	{ 0xC5AB,  0xDA48 },
	{ 0xC5AC,  0xDA49 },
	{ 0xC5AD,  0xDC55 },
	{ 0xC5AE,  0xDC57 },
	{ 0xC5AF,  0xDE5C },
	{ 0xC5B0,  0xE142 },
	{ 0xC5B1,  0xE854 },
	{ 0xC5B2,  0xE861 },
	{ 0xC5B3,  0xE862 },
	{ 0xC5B4,  0xEC56 },
	{ 0xC5B5,  0xF6B2 },
	{ 0xC5B6,  0xED5E },
	{ 0xC5B7,  0xED5C },
	{ 0xC5B8,  0xEE9D },
	{ 0xC5B9,  0xF7D2 },
	{ 0xC5BA,  0xF29C },
	{ 0xC5BB,  0xF294 },
	{ 0xC5BC,  0xF376 },
	{ 0xC5BD,  0xF450 },
	{ 0xC5BE,  0xF74D },
	{ 0xC5BF,  0xF696 },
	{ 0xC5C0,  0xF742 },
	{ 0xC5C1,  0xF6A0 },
	{ 0xC5C2,  0xFA70 },
	{ 0xC5C3,  0xFA74 },
	{ 0xC5C4,  0xFD42 },
	{ 0xC5C5,  0xFD72 },
	{ 0xC5C6,  0xFD70 },
	{ 0xC5C7,  0xFD8F },
	{ 0xC5C8,  0x87D5 },
	{ 0xC5C9,  0x8E72 },
	{ 0xC5CA,  0x91D9 },
	{ 0xC5CB,  0x9481 },
	{ 0xC5CC,  0xBEF0 },
	{ 0xC5CD,  0x9487 },
	{ 0xC5CE,  0x95F1 },
	{ 0xC5CF,  0x99E6 },
	{ 0xC5D0,  0xAD91 },
	{ 0xC5D1,  0xB860 },
	{ 0xC5D2,  0xBB60 },
	{ 0xC5D3,  0xBB5F },
	{ 0xC5D4,  0xBB61 },
	{ 0xC5D5,  0xC074 },
	{ 0xC5D6,  0xC077 },
	{ 0xC5D7,  0xC075 },
	{ 0xC5D8,  0xC54E },
	{ 0xC5D9,  0xD5BA },
	{ 0xC5DA,  0xCC7D },
	{ 0xC5DB,  0xD04D },
	{ 0xC5DC,  0xD783 },
	{ 0xC5DD,  0xDF8A },
	{ 0xC5DE,  0xDF89 },
	{ 0xC5DF,  0xE873 },
	{ 0xC5E0,  0xE870 },
	{ 0xC5E1,  0xE874 },
	{ 0xC5E2,  0xEC76 },
	{ 0xC5E3,  0xEF40 },
	{ 0xC5E4,  0xF090 },
	{ 0xC5E5,  0xF340 },
	{ 0xC5E6,  0xF341 },
	{ 0xC5E7,  0xF29E },
	{ 0xC5E8,  0xCBE8 },
	{ 0xC5E9,  0xF377 },
	{ 0xC5EA,  0xF7C7 },
	{ 0xC5EB,  0xF758 },
	{ 0xC5EC,  0xF75B },
	{ 0xC5ED,  0xF75A },
	{ 0xC5EE,  0xFA83 },
	{ 0xC5EF,  0xF7EB },
	{ 0xC5F0,  0xFC71 },
	{ 0xC5F1,  0x87DA },
	{ 0xC5F2,  0x89CE },
	{ 0xC5F3,  0x9488 },
	{ 0xC5F4,  0xE5B1 },
	{ 0xC5F5,  0xB063 },
	{ 0xC5F6,  0xB064 },
	{ 0xC5F7,  0xB4A3 },
	{ 0xC5F8,  0xB9DE },
	{ 0xC5F9,  0xC162 },
	{ 0xC5FA,  0xD051 },
	{ 0xC5FB,  0xF3BC },
	{ 0xC5FC,  0xE1E9 },
	{ 0xC5FD,  0xD78C },
	{ 0xC5FE,  0xD78B },
	{ 0xC640,  0xD78F },
	{ 0xC641,  0xC647 },
	{ 0xC642,  0xDA4D },
	{ 0xC643,  0xE184 },
	{ 0xC644,  0xE87A },
	{ 0xC645,  0xEC5A },
	{ 0xC646,  0xEC60 },
	{ 0xC647,  0xEC5C },
	{ 0xC648,  0xED61 },
	{ 0xC649,  0xEF41 },
	{ 0xC64A,  0xF345 },
	{ 0xC64B,  0xF457 },
	{ 0xC64C,  0xF47C },
	{ 0xC64D,  0xF763 },
	{ 0xC64E,  0xFA97 },
	{ 0xC64F,  0xFA98 },
	{ 0xC650,  0xFB7C },
	{ 0xC651,  0xFB7D },
	{ 0xC652,  0xFC81 },
	{ 0xC653,  0xFD7D },
	{ 0xC654,  0xFD78 },
	{ 0xC655,  0x8F64 },
	{ 0xC656,  0x99EC },
	{ 0xC657,  0x9EB3 },
	{ 0xC658,  0xBB68 },
	{ 0xC659,  0xBB6A },
	{ 0xC65A,  0xD055 },
	{ 0xC65B,  0xD35E },
	{ 0xC65C,  0xDC62 },
	{ 0xC65D,  0xE185 },
	{ 0xC65E,  0xE882 },
	{ 0xC65F,  0xE880 },
	{ 0xC660,  0xEF42 },
	{ 0xC661,  0xF092 },
	{ 0xC662,  0xF379 },
	{ 0xC663,  0xF7E0 },
	{ 0xC664,  0xFC5A },
	{ 0xC665,  0x9EB4 },
	{ 0xC666,  0xB29A },
	{ 0xC667,  0xD793 },
	{ 0xC668,  0xE887 },
	{ 0xC669,  0xED64 },
	{ 0xC66A,  0xF348 },
	{ 0xC66B,  0xF34B },
	{ 0xC66C,  0xC07C },
	{ 0xC66D,  0xD795 },
	{ 0xC66E,  0xDC6B },
	{ 0xC66F,  0xE189 },
	{ 0xC670,  0xE88D },
	{ 0xC671,  0xE88E },
	{ 0xC672,  0xE88C },
	{ 0xC673,  0xF77B },
	{ 0xC674,  0xF77C },
	{ 0xC675,  0xFC74 },
	{ 0xC676,  0xD857 },
	{ 0xC677,  0xE88F },
	{ 0xC678,  0xFB57 },
	{ 0xC679,  0xECE0 },
	{ 0xC67A,  0xF350 },
	{ 0xC67B,  0xF464 },
	{ 0xC67C,  0xFB58 },
	{ 0xC67D,  0xFB5B },
	{ 0xC67E,  0xBB6E },
	{ 0xC6A1,  0xA2D9 },
	{ 0xC6A2,  0xA2DA },
	{ 0xC6A3,  0xA2DB },
	{ 0xC6A4,  0xA2DC },
	{ 0xC6A5,  0xA2DD },
	{ 0xC6A6,  0xA2DE },
	{ 0xC6A7,  0xA2DF },
	{ 0xC6A8,  0xA2E0 },
	{ 0xC6A9,  0xA2E1 },
	{ 0xC6AA,  0xA2E2 },
	{ 0xC6AB,  0xA2C5 },
	{ 0xC6AC,  0xA2C6 },
	{ 0xC6AD,  0xA2C7 },
	{ 0xC6AE,  0xA2C8 },
	{ 0xC6AF,  0xA2C9 },
	{ 0xC6B0,  0xA2CA },
	{ 0xC6B1,  0xA2CB },
	{ 0xC6B2,  0xA2CC },
	{ 0xC6B3,  0xA2CD },
	{ 0xC6B4,  0xA2CE },
	{ 0xC6B5,  0xA2A1 },
	{ 0xC6B6,  0xA2A2 },
	{ 0xC6B7,  0xA2A3 },
	{ 0xC6B8,  0xA2A4 },
	{ 0xC6B9,  0xA2A5 },
	{ 0xC6BA,  0xA2A6 },
	{ 0xC6BB,  0xA2A7 },
	{ 0xC6BC,  0xA2A8 },
	{ 0xC6BD,  0xA2A9 },
	{ 0xC6BE,  0xA2AA },
	{ 0xC6BF,  0xD8BC },
	{ 0xC6C0,  0xD8AF },
	{ 0xC6C1,  0x817C },
	{ 0xC6C2,  0xD9EF },
	{ 0xC6C3,  0xD8E7 },
	{ 0xC6C4,  0xDAA2 },
	{ 0xC6C5,  0xD9FB },
	{ 0xC6C6,  0xD9E8 },
	{ 0xC6C7,  0x855B },
	{ 0xC6C8,  0xDAE0 },
	{ 0xC6C9,  0xDBCC },
	{ 0xC6CA,  0x89E5 },
	{ 0xC6CB,  0xE5B2 },
	{ 0xC6CC,  0xE7DD },
	{ 0xC6CD,  0x81399033 },
	{ 0xC6CE,  0xB9E3 },
	{ 0xC6D0,  0xE5E6 },
	{ 0xC6D1,  0xE1EA },
	{ 0xC6D2,  0xEAB7 },
	{ 0xC6D4,  0xF0DA },
	{ 0xC6D6,  0xDE75 },
	{ 0xC6D8,  0xA1A7 },
	{ 0xC6D9,  0x8130B733 },
	{ 0xC6DA,  0xA963 },
	{ 0xC6DB,  0xA964 },
	{ 0xC6DC,  0xA966 },
	{ 0xC6DD,  0xA967 },
	{ 0xC6E0,  0xA1A9 },
	{ 0xC6E1,  0xA965 },
	{ 0xC6E2,  0xA996 },
	{ 0xC6E3,  0xA960 },
	{ 0xC6E4,  0xA3DB },
	{ 0xC6E5,  0xA3DD },
	{ 0xC6E6,  0x8137C139 },
	{ 0xC6E7,  0xA4A1 },
	{ 0xC6E8,  0xA4A2 },
	{ 0xC6E9,  0xA4A3 },
	{ 0xC6EA,  0xA4A4 },
	{ 0xC6EB,  0xA4A5 },
	{ 0xC6EC,  0xA4A6 },
	{ 0xC6ED,  0xA4A7 },
	{ 0xC6EE,  0xA4A8 },
	{ 0xC6EF,  0xA4A9 },
	{ 0xC6F0,  0xA4AA },
	{ 0xC6F1,  0xA4AB },
	{ 0xC6F2,  0xA4AC },
	{ 0xC6F3,  0xA4AD },
	{ 0xC6F4,  0xA4AE },
	{ 0xC6F5,  0xA4AF },
	{ 0xC6F6,  0xA4B0 },
	{ 0xC6F7,  0xA4B1 },
	{ 0xC6F8,  0xA4B2 },
	{ 0xC6F9,  0xA4B3 },
	{ 0xC6FA,  0xA4B4 },
	{ 0xC6FB,  0xA4B5 },
	{ 0xC6FC,  0xA4B6 },
	{ 0xC6FD,  0xA4B7 },
	{ 0xC6FE,  0xA4B8 },
	{ 0xC740,  0xA4B9 },
	{ 0xC741,  0xA4BA },
	{ 0xC742,  0xA4BB },
	{ 0xC743,  0xA4BC },
	{ 0xC744,  0xA4BD },
	{ 0xC745,  0xA4BE },
	{ 0xC746,  0xA4BF },
	{ 0xC747,  0xA4C0 },
	{ 0xC748,  0xA4C1 },
	{ 0xC749,  0xA4C2 },
	{ 0xC74A,  0xA4C3 },
	{ 0xC74B,  0xA4C4 },
	{ 0xC74C,  0xA4C5 },
	{ 0xC74D,  0xA4C6 },
	{ 0xC74E,  0xA4C7 },
	{ 0xC74F,  0xA4C8 },
	{ 0xC750,  0xA4C9 },
	{ 0xC751,  0xA4CA },
	{ 0xC752,  0xA4CB },
	{ 0xC753,  0xA4CC },
	{ 0xC754,  0xA4CD },
	{ 0xC755,  0xA4CE },
	{ 0xC756,  0xA4CF },
	{ 0xC757,  0xA4D0 },
	{ 0xC758,  0xA4D1 },
	{ 0xC759,  0xA4D2 },
	{ 0xC75A,  0xA4D3 },
	{ 0xC75B,  0xA4D4 },
	{ 0xC75C,  0xA4D5 },
	{ 0xC75D,  0xA4D6 },
	{ 0xC75E,  0xA4D7 },
	{ 0xC75F,  0xA4D8 },
	{ 0xC760,  0xA4D9 },
	{ 0xC761,  0xA4DA },
	{ 0xC762,  0xA4DB },
	{ 0xC763,  0xA4DC },
	{ 0xC764,  0xA4DD },
	{ 0xC765,  0xA4DE },
	{ 0xC766,  0xA4DF },
	{ 0xC767,  0xA4E0 },
	{ 0xC768,  0xA4E1 },
	{ 0xC769,  0xA4E2 },
	{ 0xC76A,  0xA4E3 },
	{ 0xC76B,  0xA4E4 },
	{ 0xC76C,  0xA4E5 },
	{ 0xC76D,  0xA4E6 },
	{ 0xC76E,  0xA4E7 },
	{ 0xC76F,  0xA4E8 },
	{ 0xC770,  0xA4E9 },
	{ 0xC771,  0xA4EA },
	{ 0xC772,  0xA4EB },
	{ 0xC773,  0xA4EC },
	{ 0xC774,  0xA4ED },
	{ 0xC775,  0xA4EE },
	{ 0xC776,  0xA4EF },
	{ 0xC777,  0xA4F0 },
	{ 0xC778,  0xA4F1 },
	{ 0xC779,  0xA4F2 },
	{ 0xC77A,  0xA4F3 },
	{ 0xC77B,  0xA5A1 },
	{ 0xC77C,  0xA5A2 },
	{ 0xC77D,  0xA5A3 },
	{ 0xC77E,  0xA5A4 },
	{ 0xC7A1,  0xA5A5 },
	{ 0xC7A2,  0xA5A6 },
	{ 0xC7A3,  0xA5A7 },
	{ 0xC7A4,  0xA5A8 },
	{ 0xC7A5,  0xA5A9 },
	{ 0xC7A6,  0xA5AA },
	{ 0xC7A7,  0xA5AB },
	{ 0xC7A8,  0xA5AC },
	{ 0xC7A9,  0xA5AD },
	{ 0xC7AA,  0xA5AE },
	{ 0xC7AB,  0xA5AF },
	{ 0xC7AC,  0xA5B0 },
	{ 0xC7AD,  0xA5B1 },
	{ 0xC7AE,  0xA5B2 },
	{ 0xC7AF,  0xA5B3 },
	{ 0xC7B0,  0xA5B4 },
	{ 0xC7B1,  0xA5B5 },
	{ 0xC7B2,  0xA5B6 },
	{ 0xC7B3,  0xA5B7 },
	{ 0xC7B4,  0xA5B8 },
	{ 0xC7B5,  0xA5B9 },
	{ 0xC7B6,  0xA5BA },
	{ 0xC7B7,  0xA5BB },
	{ 0xC7B8,  0xA5BC },
	{ 0xC7B9,  0xA5BD },
	{ 0xC7BA,  0xA5BE },
	{ 0xC7BB,  0xA5BF },
	{ 0xC7BC,  0xA5C0 },
	{ 0xC7BD,  0xA5C1 },
	{ 0xC7BE,  0xA5C2 },
	{ 0xC7BF,  0xA5C3 },
	{ 0xC7C0,  0xA5C4 },
	{ 0xC7C1,  0xA5C5 },
	{ 0xC7C2,  0xA5C6 },
	{ 0xC7C3,  0xA5C7 },
	{ 0xC7C4,  0xA5C8 },
	{ 0xC7C5,  0xA5C9 },
	{ 0xC7C6,  0xA5CA },
	{ 0xC7C7,  0xA5CB },
	{ 0xC7C8,  0xA5CC },
	{ 0xC7C9,  0xA5CD },
	{ 0xC7CA,  0xA5CE },
	{ 0xC7CB,  0xA5CF },
	{ 0xC7CC,  0xA5D0 },
	{ 0xC7CD,  0xA5D1 },
	{ 0xC7CE,  0xA5D2 },
	{ 0xC7CF,  0xA5D3 },
	{ 0xC7D0,  0xA5D4 },
	{ 0xC7D1,  0xA5D5 },
	{ 0xC7D2,  0xA5D6 },
	{ 0xC7D3,  0xA5D7 },
	{ 0xC7D4,  0xA5D8 },
	{ 0xC7D5,  0xA5D9 },
	{ 0xC7D6,  0xA5DA },
	{ 0xC7D7,  0xA5DB },
	{ 0xC7D8,  0xA5DC },
	{ 0xC7D9,  0xA5DD },
	{ 0xC7DA,  0xA5DE },
	{ 0xC7DB,  0xA5DF },
	{ 0xC7DC,  0xA5E0 },
	{ 0xC7DD,  0xA5E1 },
	{ 0xC7DE,  0xA5E2 },
	{ 0xC7DF,  0xA5E3 },
	{ 0xC7E0,  0xA5E4 },
	{ 0xC7E1,  0xA5E5 },
	{ 0xC7E2,  0xA5E6 },
	{ 0xC7E3,  0xA5E7 },
	{ 0xC7E4,  0xA5E8 },
	{ 0xC7E5,  0xA5E9 },
	{ 0xC7E6,  0xA5EA },
	{ 0xC7E7,  0xA5EB },
	{ 0xC7E8,  0xA5EC },
	{ 0xC7E9,  0xA5ED },
	{ 0xC7EA,  0xA5EE },
	{ 0xC7EB,  0xA5EF },
	{ 0xC7EC,  0xA5F0 },
	{ 0xC7ED,  0xA5F1 },
	{ 0xC7EE,  0xA5F2 },
	{ 0xC7EF,  0xA5F3 },
	{ 0xC7F0,  0xA5F4 },
	{ 0xC7F1,  0xA5F5 },
	{ 0xC7F2,  0xA5F6 },
	{ 0xC7F3,  0xA7A1 },
	{ 0xC7F4,  0xA7A2 },
	{ 0xC7F5,  0xA7A3 },
	{ 0xC7F6,  0xA7A4 },
	{ 0xC7F7,  0xA7A5 },
	{ 0xC7F8,  0xA7A6 },
	{ 0xC7F9,  0xA7A7 },
	{ 0xC7FA,  0xA7A8 },
	{ 0xC7FB,  0xA7A9 },
	{ 0xC7FC,  0xA7AA },
	{ 0xC7FD,  0xA7AB },
	{ 0xC7FE,  0xA7AC },
	{ 0xC840,  0xA7AD },
	{ 0xC841,  0xA7AE },
	{ 0xC842,  0xA7AF },
	{ 0xC843,  0xA7B0 },
	{ 0xC844,  0xA7B1 },
	{ 0xC845,  0xA7B2 },
	{ 0xC846,  0xA7B3 },
	{ 0xC847,  0xA7B4 },
	{ 0xC848,  0xA7B5 },
	{ 0xC849,  0xA7B6 },
	{ 0xC84A,  0xA7B7 },
	{ 0xC84B,  0xA7B8 },
	{ 0xC84C,  0xA7B9 },
	{ 0xC84D,  0xA7BA },
	{ 0xC84E,  0xA7BB },
	{ 0xC84F,  0xA7BC },
	{ 0xC850,  0xA7BD },
	{ 0xC851,  0xA7BE },
	{ 0xC852,  0xA7BF },
	{ 0xC853,  0xA7C0 },
	{ 0xC854,  0xA7C1 },
	{ 0xC855,  0xA7D1 },
	{ 0xC856,  0xA7D2 },
	{ 0xC857,  0xA7D3 },
	{ 0xC858,  0xA7D4 },
	{ 0xC859,  0xA7D5 },
	{ 0xC85A,  0xA7D6 },
	{ 0xC85B,  0xA7D7 },
	{ 0xC85C,  0xA7D8 },
	{ 0xC85D,  0xA7D9 },
	{ 0xC85E,  0xA7DA },
	{ 0xC85F,  0xA7DB },
	{ 0xC860,  0xA7DC },
	{ 0xC861,  0xA7DD },
	{ 0xC862,  0xA7DE },
	{ 0xC863,  0xA7DF },
	{ 0xC864,  0xA7E0 },
	{ 0xC865,  0xA7E1 },
	{ 0xC866,  0xA7E2 },
	{ 0xC867,  0xA7E3 },
	{ 0xC868,  0xA7E4 },
	{ 0xC869,  0xA7E5 },
	{ 0xC86A,  0xA7E6 },
	{ 0xC86B,  0xA7E7 },
	{ 0xC86C,  0xA7E8 },
	{ 0xC86D,  0xA7E9 },
	{ 0xC86E,  0xA7EA },
	{ 0xC86F,  0xA7EB },
	{ 0xC870,  0xA7EC },
	{ 0xC871,  0xA7ED },
	{ 0xC872,  0xA7EE },
	{ 0xC873,  0xA7EF },
	{ 0xC874,  0xA7F0 },
	{ 0xC875,  0xA7F1 },
	{ 0xC876,  0x8136CF31 },
	{ 0xC877,  0x8136CA34 },
	{ 0xC878,  0x8136CA35 },
	{ 0xC879,  0x8339E238 },
	{ 0xC87A,  0x8339E239 },
	{ 0xC87B,  0x815D },
	{ 0xC87C,  0x8339E331 },
	{ 0xC87D,  0xD8D6 },
	{ 0xC87E,  0x8339E333 },
	{ 0xC8A1,  0x8339E334 },
	{ 0xC8A2,  0xB8D4 },
	{ 0xC8A3,  0x8339E336 },
	{ 0xC8A4,  0x8339E337 },
	{ 0xC8CD,  0xA956 },
	{ 0xC8CE,  0xA957 },
	{ 0xC8CF,  0xA3A7 },
	{ 0xC8D0,  0xA3A2 },
	{ 0xC8D1,  0xA95A },
	{ 0xC8D2,  0xA1ED },
	{ 0xC8D3,  0xA959 },
	{ 0xC8D4,  0xA961 },
	{ 0xC8D5,  0xA962 },
	{ 0xC8D6,  0x8138FD38 },
	{ 0xC8D7,  0xFE54 },
	{ 0xC8D8,  0x8138FE32 },
	{ 0xC8D9,  0x8138FE33 },
	{ 0xC8DA,  0xFE57 },
	{ 0xC8DB,  0x8138FE35 },
	{ 0xC8DC,  0xFE5D },
	{ 0xC8DD,  0x8138FE36 },
	{ 0xC8DE,  0x81398134 },
	{ 0xC8DF,  0x81398230 },
	{ 0xC8E0,  0x81398231 },
	{ 0xC8E1,  0x81398239 },
	{ 0xC8E2,  0xFE6B },
	{ 0xC8E3,  0xFE6E },
	{ 0xC8E4,  0x81398334 },
	{ 0xC8E5,  0xFE71 },
	{ 0xC8E6,  0xFE74 },
	{ 0xC8E7,  0x81398435 },
	{ 0xC8E8,  0x81398437 },
	{ 0xC8E9,  0x81398535 },
	{ 0xC8EA,  0xFE84 },
	{ 0xC8EB,  0x81398630 },
	{ 0xC8EC,  0x81398631 },
	{ 0xC8ED,  0x81398633 },
	{ 0xC8EE,  0x81398730 },
	{ 0xC8EF,  0x81398731 },
	{ 0xC8F0,  0x81398738 },
	{ 0xC8F1,  0x81398833 },
	{ 0xC8F5,  0x8130B036 },
	{ 0xC8F6,  0x8130AB37 },
	{ 0xC8F7,  0x8130AC37 },
	{ 0xC8F8,  0x8130AC30 },
	{ 0xC8F9,  0x8130AF32 },
	{ 0xC8FA,  0x81309334 },
	{ 0xC8FB,  0x81308B33 },
	{ 0xC8FC,  0x81309237 },
	{ 0xC8FD,  0x8130B133 },
	{ 0xC8FE,  0x8130AE31 },
	{ 0xC940,  0x8156 },
	{ 0xC941,  0xD8BF },
	{ 0xC942,  0xDBC9 },
	{ 0xC943,  0xD8CE },
	{ 0xC944,  0xB3A7 },
	{ 0xC945,  0xCDF2 },
	{ 0xC946,  0xD8A2 },
	{ 0xC947,  0xD8B1 },
	{ 0xC948,  0xD8A1 },
	{ 0xC949,  0xE0ED },
	{ 0xC94A,  0xFE40 },
	{ 0xC94B,  0xE5F8 },
	{ 0xC94C,  0xE1DC },
	{ 0xC94D,  0x8144 },
	{ 0xC94E,  0x83D3 },
	{ 0xC94F,  0xD3EB },
	{ 0xC950,  0x814D },
	{ 0xC951,  0xD8C1 },
	{ 0xC952,  0xD8EC },
	{ 0xC953,  0xD8EB },
	{ 0xC954,  0x8194 },
	{ 0xC955,  0x83DC },
	{ 0xC956,  0x84F3 },
	{ 0xC957,  0x856E },
	{ 0xC958,  0x859C },
	{ 0xC959,  0x884C },
	{ 0xC95A,  0x89E0 },
	{ 0xC95B,  0x89F8 },
	{ 0xC95C,  0x8CA8 },
	{ 0xC95D,  0x8E88 },
	{ 0xC95E,  0x94FA },
	{ 0xC95F,  0xECAF },
	{ 0xC960,  0x9AAF },
	{ 0xC961,  0xC6F8 },
	{ 0xC962,  0xE3DD },
	{ 0xC963,  0x814F },
	{ 0xC964,  0x8153 },
	{ 0xC965,  0xD8ED },
	{ 0xC966,  0x819B },
	{ 0xC967,  0x81A0 },
	{ 0xC968,  0xD8EE },
	{ 0xC969,  0xD9DA },
	{ 0xC96A,  0x8199 },
	{ 0xC96B,  0x8459 },
	{ 0xC96C,  0x8546 },
	{ 0xC96D,  0x8563 },
	{ 0xC96E,  0x884E },
	{ 0xC96F,  0xCAA5 },
	{ 0xC970,  0x89ED },
	{ 0xC971,  0xBABB },
	{ 0xC972,  0xC4FE },
	{ 0xC973,  0xE5B3 },
	{ 0xC974,  0x8CA9 },
	{ 0xC975,  0xE5EA },
	{ 0xC976,  0x8CDE },
	{ 0xC977,  0x8CDD },
	{ 0xC978,  0x8E8A },
	{ 0xC979,  0xE2CF },
	{ 0xC97A,  0x8ED9 },
	{ 0xC97B,  0xE2E1 },
	{ 0xC97C,  0x91E0 },
	{ 0xC97D,  0x9241 },
	{ 0xC97E,  0xEBAD },
	{ 0xC9A1,  0x9AE9 },
	{ 0xC9A2,  0x9AF1 },
	{ 0xC9A3,  0x9AF0 },
	{ 0xC9A4,  0x9AED },
	{ 0xC9A5,  0xA0E3 },
	{ 0xC9A6,  0xE1EC },
	{ 0xC9A7,  0xAB54 },
	{ 0xC9A8,  0xB662 },
	{ 0xC9A9,  0xC345 },
	{ 0xC9AA,  0xEA62 },
	{ 0xC9AB,  0xBCBF },
	{ 0xC9AC,  0xD3C5 },
	{ 0xC9AD,  0x81C0 },
	{ 0xC9AE,  0xD8F5 },
	{ 0xC9AF,  0x81B7 },
	{ 0xC9B0,  0x81A4 },
	{ 0xC9B1,  0x81AB },
	{ 0xC9B2,  0xBCDB },
	{ 0xC9B3,  0x81B2 },
	{ 0xC9B4,  0x81BB },
	{ 0xC9B5,  0x81AC },
	{ 0xC9B6,  0x81AF },
	{ 0xC9B7,  0xD8F3 },
	{ 0xC9B8,  0x81B6 },
	{ 0xC9B9,  0x81AE },
	{ 0xC9BA,  0x81A5 },
	{ 0xC9BB,  0x81B5 },
	{ 0xC9BC,  0xD9FC },
	{ 0xC9BD,  0x845C },
	{ 0xC9BE,  0x8457 },
	{ 0xC9BF,  0x845B },
	{ 0xC9C0,  0x84B5 },
	{ 0xC9C1,  0x8549 },
	{ 0xC9C2,  0x8548 },
	{ 0xC9C3,  0x8564 },
	{ 0xC9C4,  0x857C },
	{ 0xC9C5,  0x85BB },
	{ 0xC9C6,  0xE0EF },
	{ 0xC9C7,  0xD8B6 },
	{ 0xC9C8,  0xDBDC },
	{ 0xC9C9,  0xDBD9 },
	{ 0xC9CA,  0x8856 },
	{ 0xC9CB,  0xDEC5 },
	{ 0xC9CC,  0x8A6A },
	{ 0xC9CD,  0x8A67 },
	{ 0xC9CE,  0x8A6B },
	{ 0xC9CF,  0x8A66 },
	{ 0xC9D0,  0x8A68 },
	{ 0xC9D1,  0x8A64 },
	{ 0xC9D2,  0x8A69 },
	{ 0xC9D3,  0x8C49 },
	{ 0xC9D4,  0xE6D8 },
	{ 0xC9D5,  0xDECD },
	{ 0xC9D6,  0x8CE4 },
	{ 0xC9D7,  0xE1A8 },
	{ 0xC9D8,  0x8CE3 },
	{ 0xC9D9,  0x8CE6 },
	{ 0xC9DA,  0x8E78 },
	{ 0xC9DB,  0x8ED4 },
	{ 0xC9DC,  0xD7AF },
	{ 0xC9DD,  0xD2EC },
	{ 0xC9DE,  0x8F77 },
	{ 0xC9DF,  0x8FB0 },
	{ 0xC9E0,  0x8FE7 },
	{ 0xC9E1,  0x8FE6 },
	{ 0xC9E2,  0xE2E3 },
	{ 0xC9E3,  0x9247 },
	{ 0xC9E4,  0x9249 },
	{ 0xC9E5,  0x924E },
	{ 0xC9E6,  0x924C },
	{ 0xC9E7,  0xC7A4 },
	{ 0xC9E8,  0x924D },
	{ 0xC9E9,  0x9245 },
	{ 0xC9EA,  0x924B },
	{ 0xC9EB,  0x9246 },
	{ 0xC9EC,  0x924F },
	{ 0xC9ED,  0xEAB9 },
	{ 0xC9EE,  0xEAB8 },
	{ 0xC9EF,  0x9662 },
	{ 0xC9F0,  0x965F },
	{ 0xC9F1,  0x965E },
	{ 0xC9F2,  0x9660 },
	{ 0xC9F3,  0xBBFA },
	{ 0xC9F4,  0x9663 },
	{ 0xC9F5,  0x9661 },
	{ 0xC9F6,  0x965B },
	{ 0xC9F7,  0xEBAE },
	{ 0xC9F8,  0xD9E0 },
	{ 0xC9F9,  0x9AFB },
	{ 0xC9FA,  0xE3E1 },
	{ 0xC9FB,  0x9AF9 },
	{ 0xC9FC,  0xE3E2 },
	{ 0xC9FD,  0xE3E0 },
	{ 0xC9FE,  0x9AF5 },
	{ 0xCA40,  0x9AF6 },
	{ 0xCA41,  0x9EBC },
	{ 0xCA42,  0xA0AC },
	{ 0xCA43,  0xE1ED },
	{ 0xCA44,  0xA0E7 },
	{ 0xCA45,  0xE7E0 },
	{ 0xCA46,  0xAE66 },
	{ 0xCA47,  0xB06D },
	{ 0xCA48,  0xB78A },
	{ 0xCA49,  0xCDF8 },
	{ 0xCA4A,  0xC648 },
	{ 0xCA4B,  0xC64A },
	{ 0xCA4C,  0xC64B },
	{ 0xCA4D,  0xDCB4 },
	{ 0xCA4E,  0xDCB5 },
	{ 0xCA4F,  0xF2AE },
	{ 0xCA50,  0xD281 },
	{ 0xCA51,  0xDAF8 },
	{ 0xCA52,  0xDAF5 },
	{ 0xCA53,  0xDF8E },
	{ 0xCA54,  0xDAF6 },
	{ 0xCA55,  0xDF8C },
	{ 0xCA56,  0xDAE3 },
	{ 0xCA57,  0xEA65 },
	{ 0xCA58,  0xEA63 },
	{ 0xCA59,  0xEA64 },
	{ 0xCA5A,  0x81D8 },
	{ 0xCA5B,  0x81C8 },
	{ 0xCA5C,  0x81DA },
	{ 0xCA5D,  0x81D2 },
	{ 0xCA5E,  0xCCE5 },
	{ 0xCA5F,  0xD8F4 },
	{ 0xCA60,  0x81C9 },
	{ 0xCA61,  0xD8FB },
	{ 0xCA62,  0x81D6 },
	{ 0xCA63,  0xD9A1 },
	{ 0xCA64,  0x81CC },
	{ 0xCA65,  0xD9DC },
	{ 0xCA66,  0x81C1 },
	{ 0xCA67,  0x81C4 },
	{ 0xCA68,  0x81CA },
	{ 0xCA69,  0x81D9 },
	{ 0xCA6A,  0x83D7 },
	{ 0xCA6B,  0x83EC },
	{ 0xCA6C,  0x845F },
	{ 0xCA6D,  0x8460 },
	{ 0xCA6E,  0x8462 },
	{ 0xCA6F,  0xDBBF },
	{ 0xCA70,  0x84B7 },
	{ 0xCA71,  0x84FA },
	{ 0xCA72,  0xD8D5 },
	{ 0xCA73,  0x8570 },
	{ 0xCA74,  0x857D },
	{ 0xCA75,  0x857E },
	{ 0xCA76,  0x85C6 },
	{ 0xCA77,  0x85C9 },
	{ 0xCA78,  0x85C5 },
	{ 0xCA79,  0xDFBE },
	{ 0xCA7A,  0x85D0 },
	{ 0xCA7B,  0x85BF },
	{ 0xCA7C,  0x85C1 },
	{ 0xCA7D,  0x85C4 },
	{ 0xCA7E,  0x85BE },
	{ 0xCAA1,  0x85CB },
	{ 0xCAA2,  0x85D6 },
	{ 0xCAA3,  0x85CD },
	{ 0xCAA4,  0xB6D6 },
	{ 0xCAA5,  0x85C3 },
	{ 0xCAA6,  0x85D1 },
	{ 0xCAA7,  0x87EA },
	{ 0xCAA8,  0x87E5 },
	{ 0xCAA9,  0x87E3 },
	{ 0xCAAA,  0x885E },
	{ 0xCAAB,  0x8861 },
	{ 0xCAAC,  0xDBD0 },
	{ 0xCAAD,  0x8864 },
	{ 0xCAAE,  0x8865 },
	{ 0xCAAF,  0x8866 },
	{ 0xCAB0,  0x89E2 },
	{ 0xCAB1,  0x8A43 },
	{ 0xCAB2,  0x8A7E },
	{ 0xCAB3,  0x8A75 },
	{ 0xCAB4,  0x8A7B },
	{ 0xCAB5,  0xE6A1 },
	{ 0xCAB6,  0x8A6F },
	{ 0xCAB7,  0x8A7D },
	{ 0xCAB8,  0x8A71 },
	{ 0xCAB9,  0x8A70 },
	{ 0xCABA,  0x8A80 },
	{ 0xCABB,  0x8A7C },
	{ 0xCABC,  0x8C61 },
	{ 0xCABD,  0x8C64 },
	{ 0xCABE,  0x8CB4 },
	{ 0xCABF,  0x8CB6 },
	{ 0xCAC0,  0xE1A9 },
	{ 0xCAC1,  0x8CF1 },
	{ 0xCAC2,  0xE1AC },
	{ 0xCAC3,  0x8CEF },
	{ 0xCAC4,  0x8CED },
	{ 0xCAC5,  0x8CF2 },
	{ 0xCAC6,  0x8CEE },
	{ 0xCAC7,  0x8CEB },
	{ 0xCAC8,  0x8CF3 },
	{ 0xCAC9,  0x8CF4 },
	{ 0xCACA,  0x8E79 },
	{ 0xCACB,  0x8E8D },
	{ 0xCACC,  0x8E90 },
	{ 0xCACD,  0xE2D1 },
	{ 0xCACE,  0x8EDD },
	{ 0xCACF,  0x8EDE },
	{ 0xCAD0,  0x8EDC },
	{ 0xCAD1,  0x8EDF },
	{ 0xCAD2,  0x8F6B },
	{ 0xCAD3,  0x8F79 },
	{ 0xCAD4,  0x8FB3 },
	{ 0xCAD5,  0x8FB2 },
	{ 0xCAD6,  0xDFAF },
	{ 0xCAD7,  0xECFD },
	{ 0xCAD8,  0xECFE },
	{ 0xCAD9,  0xE2ED },
	{ 0xCADA,  0x8FF1 },
	{ 0xCADB,  0xE2E5 },
	{ 0xCADC,  0x8FF7 },
	{ 0xCADD,  0xE2E7 },
	{ 0xCADE,  0xE2E8 },
	{ 0xCADF,  0x8FEE },
	{ 0xCAE0,  0x8FFC },
	{ 0xCAE1,  0x8FF4 },
	{ 0xCAE2,  0x8FFA },
	{ 0xCAE3,  0xD0C3 },
	{ 0xCAE4,  0xBBB3 },
	{ 0xCAE5,  0x8FF8 },
	{ 0xCAE6,  0x91F7 },
	{ 0xCAE7,  0x925C },
	{ 0xCAE8,  0x9262 },
	{ 0xCAE9,  0x9264 },
	{ 0xCAEA,  0x9265 },
	{ 0xCAEB,  0x9267 },
	{ 0xCAEC,  0x925F },
	{ 0xCAED,  0x9251 },
	{ 0xCAEE,  0x9258 },
	{ 0xCAEF,  0x9257 },
	{ 0xCAF0,  0xC8C5 },
	{ 0xCAF1,  0x925A },
	{ 0xCAF2,  0x9260 },
	{ 0xCAF3,  0x9255 },
	{ 0xCAF4,  0x9259 },
	{ 0xCAF5,  0x9252 },
	{ 0xCAF6,  0x9253 },
	{ 0xCAF7,  0x948E },
	{ 0xCAF8,  0xEABA },
	{ 0xCAF9,  0x9542 },
	{ 0xCAFA,  0x9541 },
	{ 0xCAFB,  0x9540 },
	{ 0xCAFC,  0x9543 },
	{ 0xCAFD,  0x9666 },
	{ 0xCAFE,  0x9667 },
	{ 0xCB40,  0x9670 },
	{ 0xCB41,  0x966D },
	{ 0xCB42,  0xE8BB },
	{ 0xCB43,  0xE8BE },
	{ 0xCB44,  0x9673 },
	{ 0xCB45,  0x966A },
	{ 0xCB46,  0x9671 },
	{ 0xCB47,  0x9669 },
	{ 0xCB48,  0x9AB1 },
	{ 0xCB49,  0xEBAF },
	{ 0xCB4A,  0xEBB0 },
	{ 0xCB4B,  0x9B50 },
	{ 0xCB4C,  0x9B46 },
	{ 0xCB4D,  0x9B47 },
	{ 0xCB4E,  0x9B56 },
	{ 0xCB4F,  0x9B59 },
	{ 0xCB50,  0xC6E3 },
	{ 0xCB51,  0x9B4C },
	{ 0xCB52,  0x9B4B },
	{ 0xCB53,  0xE3E9 },
	{ 0xCB54,  0x9B62 },
	{ 0xCB55,  0x9B49 },
	{ 0xCB56,  0x9B57 },
	{ 0xCB57,  0x9B5E },
	{ 0xCB58,  0x9B63 },
	{ 0xCB59,  0x9B45 },
	{ 0xCB5A,  0x9B4D },
	{ 0xCB5B,  0x9B44 },
	{ 0xCB5C,  0x9B52 },
	{ 0xCB5D,  0x9B5B },
	{ 0xCB5E,  0x9EBF },
	{ 0xCB5F,  0x9EC2 },
	{ 0xCB60,  0xA0AE },
	{ 0xCB61,  0xA0ED },
	{ 0xCB62,  0xA0EB },
	{ 0xCB63,  0xE1F0 },
	{ 0xCB64,  0xA0F0 },
	{ 0xCB65,  0xE1F1 },
	{ 0xCB66,  0xA0E8 },
	{ 0xCB67,  0xA0EF },
	{ 0xCB68,  0xAB5C },
	{ 0xCB69,  0xAB5D },
	{ 0xCB6A,  0xAB5A },
	{ 0xCB6B,  0xAB5B },
	{ 0xCB6C,  0xAB59 },
	{ 0xCB6D,  0xEEAE },
	{ 0xCB6E,  0xAE6A },
	{ 0xCB6F,  0xF0DB },
	{ 0xCB70,  0xAF48 },
	{ 0xCB71,  0xB06F },
	{ 0xCB72,  0xB569 },
	{ 0xCB73,  0xC26B },
	{ 0xCB74,  0xC34D },
	{ 0xCB75,  0xC34F },
	{ 0xCB76,  0xC349 },
	{ 0xCB77,  0xC34B },
	{ 0xCB78,  0xEBC0 },
	{ 0xCB79,  0xC653 },
	{ 0xCB7A,  0xDCB6 },
	{ 0xCB7B,  0xC64E },
	{ 0xCB7C,  0xDCBA },
	{ 0xCB7D,  0xDCBB },
	{ 0xCB7E,  0xC654 },
	{ 0xCBA1,  0xDCB7 },
	{ 0xCBA2,  0xC64D },
	{ 0xCBA3,  0xDCB9 },
	{ 0xCBA4,  0xF5F4 },
	{ 0xCBA5,  0xDE80 },
	{ 0xCBA6,  0xDE7B },
	{ 0xCBA7,  0xDF92 },
	{ 0xCBA8,  0xDAFA },
	{ 0xCBA9,  0xDF95 },
	{ 0xCBAA,  0xDF91 },
	{ 0xCBAB,  0xDF96 },
	{ 0xCBAC,  0xDF93 },
	{ 0xCBAD,  0xEA6F },
	{ 0xCBAE,  0xEA69 },
	{ 0xCBAF,  0xEA6E },
	{ 0xCBB0,  0xEA6D },
	{ 0xCBB1,  0x8150 },
	{ 0xCBB2,  0x81F7 },
	{ 0xCBB3,  0xD9AE },
	{ 0xCBB4,  0x81EC },
	{ 0xCBB5,  0x81E8 },
	{ 0xCBB6,  0x81E9 },
	{ 0xCBB7,  0x81EE },
	{ 0xCBB8,  0xD9A5 },
	{ 0xCBB9,  0xD9A6 },
	{ 0xCBBA,  0xD9A8 },
	{ 0xCBBB,  0xD6B6 },
	{ 0xCBBC,  0x81E4 },
	{ 0xCBBD,  0x81D5 },
	{ 0xCBBE,  0xB6B1 },
	{ 0xCBBF,  0x81DD },
	{ 0xCBC0,  0x81F9 },
	{ 0xCBC1,  0x81E6 },
	{ 0xCBC2,  0x81EA },
	{ 0xCBC3,  0x81E5 },
	{ 0xCBC4,  0x81F2 },
	{ 0xCBC5,  0x81FA },
	{ 0xCBC6,  0xD9B0 },
	{ 0xCBC7,  0x81FB },
	{ 0xCBC8,  0x81F3 },
	{ 0xCBC9,  0x81EB },
	{ 0xCBCA,  0x81F5 },
	{ 0xCBCB,  0x81DE },
	{ 0xCBCC,  0x81E0 },
	{ 0xCBCD,  0x83DF },
	{ 0xCBCE,  0xD9FE },
	{ 0xCBCF,  0x83EE },
	{ 0xCBD0,  0x846E },
	{ 0xCBD1,  0x846C },
	{ 0xCBD2,  0xD8DA },
	{ 0xCBD3,  0x8473 },
	{ 0xCBD4,  0x846B },
	{ 0xCBD5,  0x84C2 },
	{ 0xCBD6,  0x84FB },
	{ 0xCBD7,  0x84FC },
	{ 0xCBD8,  0x855C },
	{ 0xCBD9,  0x8582 },
	{ 0xCBDA,  0x8584 },
	{ 0xCBDB,  0x85F1 },
	{ 0xCBDC,  0x85ED },
	{ 0xCBDD,  0x85EE },
	{ 0xCBDE,  0x85F6 },
	{ 0xCBDF,  0xDFC6 },
	{ 0xCBE0,  0x85F2 },
	{ 0xCBE1,  0x85E3 },
	{ 0xCBE2,  0x85EB },
	{ 0xCBE3,  0x85EC },
	{ 0xCBE4,  0x85DF },
	{ 0xCBE5,  0x85E4 },
	{ 0xCBE6,  0x85E9 },
	{ 0xCBE7,  0xDFCF },
	{ 0xCBE8,  0x85F5 },
	{ 0xCBE9,  0x85E7 },
	{ 0xCBEA,  0x85DD },
	{ 0xCBEB,  0x85DC },
	{ 0xCBEC,  0x85F9 },
	{ 0xCBED,  0x85DE },
	{ 0xCBEE,  0x85E0 },
	{ 0xCBEF,  0xDFCA },
	{ 0xCBF0,  0x87EF },
	{ 0xCBF1,  0xE0F2 },
	{ 0xCBF2,  0xC5F7 },
	{ 0xCBF3,  0x8875 },
	{ 0xCBF4,  0xDBE8 },
	{ 0xCBF5,  0xDBE3 },
	{ 0xCBF6,  0x8874 },
	{ 0xCBF7,  0x8873 },
	{ 0xCBF8,  0xDBE9 },
	{ 0xCBF9,  0x887E },
	{ 0xCBFA,  0x8877 },
	{ 0xCBFB,  0xDBE6 },
	{ 0xCBFC,  0xDBEA },
	{ 0xCBFD,  0x8876 },
	{ 0xCBFE,  0x886D },
	{ 0xCC40,  0xDBE7 },
	{ 0xCC41,  0x887B },
	{ 0xCC42,  0x89E7 },
	{ 0xCC43,  0x8A45 },
	{ 0xCC44,  0x8A87 },
	{ 0xCC45,  0x8A8B },
	{ 0xCC46,  0x8A9B },
	{ 0xCC47,  0x8A9A },
	{ 0xCC48,  0xE6A7 },
	{ 0xCC49,  0x8A98 },
	{ 0xCC4A,  0x8A90 },
	{ 0xCC4B,  0x8A88 },
	{ 0xCC4C,  0x8A8C },
	{ 0xCC4D,  0x8A92 },
	{ 0xCC4E,  0x8A9D },
	{ 0xCC4F,  0x8A84 },
	{ 0xCC50,  0x8A8D },
	{ 0xCC51,  0x8A8F },
	{ 0xCC52,  0x8A96 },
	{ 0xCC53,  0x8A86 },
	{ 0xCC54,  0x8A95 },
	{ 0xCC55,  0xE6DF },
	{ 0xCC56,  0xE6DB },
	{ 0xCC57,  0xE5B5 },
	{ 0xCC58,  0xE5B4 },
	{ 0xCC59,  0x8CC2 },
	{ 0xCC5A,  0x8CC4 },
	{ 0xCC5B,  0x8D41 },
	{ 0xCC5C,  0x8CFA },
	{ 0xCC5D,  0x8CF8 },
	{ 0xCC5E,  0xE1B2 },
	{ 0xCC5F,  0x8D42 },
	{ 0xCC60,  0x8CFE },
	{ 0xCC61,  0xE1B5 },
	{ 0xCC62,  0x8CF7 },
	{ 0xCC63,  0xE1B8 },
	{ 0xCC64,  0xC1EB },
	{ 0xCC65,  0xE1B3 },
	{ 0xCC66,  0x8D40 },
	{ 0xCC67,  0x8CFD },
	{ 0xCC68,  0x8CF5 },
	{ 0xCC69,  0x8CFB },
	{ 0xCC6A,  0x8D46 },
	{ 0xCC6B,  0x8D43 },
	{ 0xCC6C,  0x8CFC },
	{ 0xCC6D,  0x8E93 },
	{ 0xCC6E,  0xE0FA },
	{ 0xCC6F,  0xE0F9 },
	{ 0xCC70,  0x8F80 },
	{ 0xCC71,  0x8F7C },
	{ 0xCC72,  0x8F7D },
	{ 0xCC73,  0x8F7E },
	{ 0xCC74,  0x8FA0 },
	{ 0xCC75,  0xE1DE },
	{ 0xCC76,  0x8FB6 },
	{ 0xCC77,  0x8FB5 },
	{ 0xCC78,  0x8FEB },
	{ 0xCC79,  0x8FEF },
	{ 0xCC7A,  0x9050 },
	{ 0xCC7B,  0xE2F1 },
	{ 0xCC7C,  0xE2EF },
	{ 0xCC7D,  0x9054 },
	{ 0xCC7E,  0x9042 },
	{ 0xCCA1,  0x9056 },
	{ 0xCCA2,  0xE2F7 },
	{ 0xCCA3,  0x9047 },
	{ 0xCCA4,  0x9055 },
	{ 0xCCA5,  0x9049 },
	{ 0xCCA6,  0x904A },
	{ 0xCCA7,  0x904F },
	{ 0xCCA8,  0x904C },
	{ 0xCCA9,  0xE2F4 },
	{ 0xCCAA,  0x9044 },
	{ 0xCCAB,  0x9051 },
	{ 0xCCAC,  0x9046 },
	{ 0xCCAD,  0x9045 },
	{ 0xCCAE,  0x9043 },
	{ 0xCCAF,  0x9041 },
	{ 0xCCB0,  0xC1AF },
	{ 0xCCB1,  0x91E2 },
	{ 0xCCB2,  0xECE6 },
	{ 0xCCB3,  0x9271 },
	{ 0xCCB4,  0x9277 },
	{ 0xCCB5,  0x9283 },
	{ 0xCCB6,  0x927C },
	{ 0xCCB7,  0x9270 },
	{ 0xCCB8,  0x9278 },
	{ 0xCCB9,  0xDED4 },
	{ 0xCCBA,  0x9272 },
	{ 0xCCBB,  0x9276 },
	{ 0xCCBC,  0x9273 },
	{ 0xCCBD,  0xDED3 },
	{ 0xCCBE,  0x926F },
	{ 0xCCBF,  0x9274 },
	{ 0xCCC0,  0x927A },
	{ 0xCCC1,  0x9491 },
	{ 0xCCC2,  0x94D6 },
	{ 0xCCC3,  0x94E3 },
	{ 0xCCC4,  0x9550 },
	{ 0xCCC5,  0x9547 },
	{ 0xCCC6,  0x954C },
	{ 0xCCC7,  0x9555 },
	{ 0xCCC8,  0x954F },
	{ 0xCCC9,  0x9546 },
	{ 0xCCCA,  0xEABE },
	{ 0xCCCB,  0x9551 },
	{ 0xCCCC,  0x9552 },
	{ 0xCCCD,  0x954D },
	{ 0xCCCE,  0x9548 },
	{ 0xCCCF,  0x9554 },
	{ 0xCCD0,  0x9553 },
	{ 0xCCD1,  0x95F7 },
	{ 0xCCD2,  0xEBC3 },
	{ 0xCCD3,  0x9688 },
	{ 0xCCD4,  0x967A },
	{ 0xCCD5,  0x968E },
	{ 0xCCD6,  0x9691 },
	{ 0xCCD7,  0x967E },
	{ 0xCCD8,  0x9683 },
	{ 0xCCD9,  0xE8C4 },
	{ 0xCCDA,  0x9689 },
	{ 0xCCDB,  0xB9B9 },
	{ 0xCCDC,  0x967D },
	{ 0xCCDD,  0x968D },
	{ 0xCCDE,  0x968C },
	{ 0xCCDF,  0x9682 },
	{ 0xCCE0,  0x9697 },
	{ 0xCCE1,  0x9690 },
	{ 0xCCE2,  0x9695 },
	{ 0xCCE3,  0x9687 },
	{ 0xCCE4,  0x9684 },
	{ 0xCCE5,  0xBCAB },
	{ 0xCCE6,  0x9680 },
	{ 0xCCE7,  0x9681 },
	{ 0xCCE8,  0x9693 },
	{ 0xCCE9,  0x99F6 },
	{ 0xCCEA,  0x9A7C },
	{ 0xCCEB,  0x9A7A },
	{ 0xCCEC,  0x9AB7 },
	{ 0xCCED,  0x9ADF },
	{ 0xCCEE,  0xEDB3 },
	{ 0xCCEF,  0x9B89 },
	{ 0xCCF0,  0xE3F9 },
	{ 0xCCF1,  0xE3FA },
	{ 0xCCF2,  0x9B80 },
	{ 0xCCF3,  0x9B6E },
	{ 0xCCF4,  0xE3EF },
	{ 0xCCF5,  0xE3F0 },
	{ 0xCCF6,  0x9B87 },
	{ 0xCCF7,  0x9B6F },
	{ 0xCCF8,  0xE3EE },
	{ 0xCCF9,  0x9B73 },
	{ 0xCCFA,  0x9B70 },
	{ 0xCCFB,  0x9B74 },
	{ 0xCCFC,  0x9B75 },
	{ 0xCCFD,  0x9B8A },
	{ 0xCCFE,  0x9B8B },
	{ 0xCD40,  0x9B7D },
	{ 0xCD41,  0x9B83 },
	{ 0xCD42,  0x9B6C },
	{ 0xCD43,  0x9B58 },
	{ 0xCD44,  0x9B64 },
	{ 0xCD45,  0x9B55 },
	{ 0xCD46,  0xC5A2 },
	{ 0xCD47,  0x9B71 },
	{ 0xCD48,  0x9BAE },
	{ 0xCD49,  0x9B79 },
	{ 0xCD4A,  0x9B76 },
	{ 0xCD4B,  0x9B6B },
	{ 0xCD4C,  0x9B8D },
	{ 0xCD4D,  0x9B7B },
	{ 0xCD4E,  0x9B88 },
	{ 0xCD4F,  0x9B7C },
	{ 0xCD50,  0xC8B2 },
	{ 0xCD51,  0x9ED4 },
	{ 0xCD52,  0xEAC1 },
	{ 0xCD53,  0x9ED2 },
	{ 0xCD54,  0x9EC9 },
	{ 0xCD55,  0x9EC8 },
	{ 0xCD56,  0x9ED1 },
	{ 0xCD57,  0xECC0 },
	{ 0xCD58,  0x9EC6 },
	{ 0xCD59,  0x9ED5 },
	{ 0xCD5A,  0x9EC7 },
	{ 0xCD5B,  0xA0B2 },
	{ 0xCD5C,  0xA0FB },
	{ 0xCD5D,  0xA0F4 },
	{ 0xCD5E,  0xA0FC },
	{ 0xCD5F,  0xA0F2 },
	{ 0xCD60,  0xAA40 },
	{ 0xCD61,  0xE1F4 },
	{ 0xCD62,  0xA0F9 },
	{ 0xCD63,  0xA0FD },
	{ 0xCD64,  0xA0F5 },
	{ 0xCD65,  0xA0F7 },
	{ 0xCD66,  0xAB67 },
	{ 0xCD67,  0xAB65 },
	{ 0xCD68,  0xAB6E },
	{ 0xCD69,  0xAB69 },
	{ 0xCD6A,  0xE7E3 },
	{ 0xCD6B,  0xAB64 },
	{ 0xCD6C,  0xAB6D },
	{ 0xCD6D,  0xAB62 },
	{ 0xCD6E,  0xAD93 },
	{ 0xCD6F,  0xAD98 },
	{ 0xCD70,  0xAE6D },
	{ 0xCD71,  0xEEAF },
	{ 0xCD72,  0xE7DE },
	{ 0xCD73,  0xAF43 },
	{ 0xCD74,  0xAF49 },
	{ 0xCD75,  0xB091 },
	{ 0xCD76,  0xB15A },
	{ 0xCD77,  0xEDEC },
	{ 0xCD78,  0xB159 },
	{ 0xCD79,  0xB15B },
	{ 0xCD7A,  0xEDB7 },
	{ 0xCD7B,  0xB34D },
	{ 0xCD7C,  0xB34A },
	{ 0xCD7D,  0xB34C },
	{ 0xCD7E,  0xB34B },
	{ 0xCDA1,  0xB349 },
	{ 0xCDA2,  0xB56B },
	{ 0xCDA3,  0xB56A },
	{ 0xCDA4,  0xB667 },
	{ 0xCDA5,  0xF1B6 },
	{ 0xCDA6,  0xB78B },
	{ 0xCDA7,  0xB885 },
	{ 0xCDA8,  0xBB6F },
	{ 0xCDA9,  0xBC6C },
	{ 0xCDAA,  0xF1F4 },
	{ 0xCDAB,  0xC348 },
	{ 0xCDAC,  0xB0B9 },
	{ 0xCDAD,  0xC351 },
	{ 0xCDAE,  0xC35A },
	{ 0xCDAF,  0xC358 },
	{ 0xCDB0,  0xEBC7 },
	{ 0xCDB1,  0xC573 },
	{ 0xCDB2,  0xC65B },
	{ 0xCDB3,  0xC666 },
	{ 0xCDB4,  0xDCBE },
	{ 0xCDB5,  0xC658 },
	{ 0xCDB6,  0xDCC5 },
	{ 0xCDB7,  0xC659 },
	{ 0xCDB8,  0xC660 },
	{ 0xCDB9,  0xC65E },
	{ 0xCDBA,  0xDCC7 },
	{ 0xCDBB,  0xC664 },
	{ 0xCDBC,  0xC65A },
	{ 0xCDBD,  0xC662 },
	{ 0xCDBE,  0xDCCC },
	{ 0xCDBF,  0xDCB8 },
	{ 0xCDC0,  0xDCCD },
	{ 0xCDC1,  0xDCCB },
	{ 0xCDC2,  0xC667 },
	{ 0xCDC3,  0xDCD2 },
	{ 0xCDC4,  0xC668 },
	{ 0xCDC5,  0xC661 },
	{ 0xCDC6,  0xC65C },
	{ 0xCDC7,  0xCD42 },
	{ 0xCDC8,  0xCD41 },
	{ 0xCDC9,  0xCD40 },
	{ 0xCDCA,  0xF2B1 },
	{ 0xCDCB,  0xD858 },
	{ 0xCDCC,  0xDE86 },
	{ 0xCDCD,  0xDE82 },
	{ 0xCDCE,  0xE5C2 },
	{ 0xCDCF,  0xDE84 },
	{ 0xCDD0,  0xDE87 },
	{ 0xCDD1,  0xE5C3 },
	{ 0xCDD2,  0xDE88 },
	{ 0xCDD3,  0xDF9B },
	{ 0xCDD4,  0xDAFB },
	{ 0xCDD5,  0xBAAA },
	{ 0xCDD6,  0xDAFC },
	{ 0xCDD7,  0xDBA2 },
	{ 0xCDD8,  0xEA72 },
	{ 0xCDD9,  0xDAE7 },
	{ 0xCDDA,  0xDAE8 },
	{ 0xCDDB,  0xEA73 },
	{ 0xCDDC,  0xEA76 },
	{ 0xCDDD,  0x825A },
	{ 0xCDDE,  0xD9B4 },
	{ 0xCDDF,  0x825C },
	{ 0xCDE0,  0x8245 },
	{ 0xCDE1,  0x8257 },
	{ 0xCDE2,  0x8258 },
	{ 0xCDE3,  0x8252 },
	{ 0xCDE4,  0x825D },
	{ 0xCDE5,  0xD9B7 },
	{ 0xCDE6,  0x8260 },
	{ 0xCDE7,  0x824D },
	{ 0xCDE8,  0x8246 },
	{ 0xCDE9,  0x8261 },
	{ 0xCDEA,  0x8255 },
	{ 0xCDEB,  0x825F },
	{ 0xCDEC,  0x824C },
	{ 0xCDED,  0x8251 },
	{ 0xCDEE,  0x824B },
	{ 0xCDEF,  0x8268 },
	{ 0xCDF0,  0x8471 },
	{ 0xCDF1,  0x8476 },
	{ 0xCDF2,  0x84C4 },
	{ 0xCDF3,  0x84C6 },
	{ 0xCDF4,  0x855D },
	{ 0xCDF5,  0x8574 },
	{ 0xCDF6,  0x8586 },
	{ 0xCDF7,  0x8585 },
	{ 0xCDF8,  0x8587 },
	{ 0xCDF9,  0xC0E5 },
	{ 0xCDFA,  0x8649 },
	{ 0xCDFB,  0x85FE },
	{ 0xCDFC,  0xDFD2 },
	{ 0xCDFD,  0x8641 },
	{ 0xCDFE,  0xDFE7 },
	{ 0xCE40,  0x864C },
	{ 0xCE41,  0xC688 },
	{ 0xCE42,  0x8647 },
	{ 0xCE43,  0x8642 },
	{ 0xCE44,  0x8650 },
	{ 0xCE45,  0x8646 },
	{ 0xCE46,  0x864D },
	{ 0xCE47,  0xB6DF },
	{ 0xCE48,  0x85FD },
	{ 0xCE49,  0x85E8 },
	{ 0xCE4A,  0x864A },
	{ 0xCE4B,  0x8640 },
	{ 0xCE4C,  0x864B },
	{ 0xCE4D,  0xDFDA },
	{ 0xCE4E,  0xDFE8 },
	{ 0xCE4F,  0x8643 },
	{ 0xCE50,  0x889D },
	{ 0xCE51,  0x8893 },
	{ 0xCE52,  0x8894 },
	{ 0xCE53,  0xDBEC },
	{ 0xCE54,  0xDBED },
	{ 0xCE55,  0x888D },
	{ 0xCE56,  0x8892 },
	{ 0xCE57,  0xB6E2 },
	{ 0xCE58,  0x888A },
	{ 0xCE59,  0x888E },
	{ 0xCE5A,  0x8887 },
	{ 0xCE5B,  0x888F },
	{ 0xCE5C,  0x8895 },
	{ 0xCE5D,  0x8890 },
	{ 0xCE5E,  0x888B },
	{ 0xCE5F,  0x89D4 },
	{ 0xCE60,  0xB8B4 },
	{ 0xCE61,  0x8A4C },
	{ 0xCE62,  0x8AA3 },
	{ 0xCE63,  0x8AA0 },
	{ 0xCE64,  0x8AAC },
	{ 0xCE65,  0x8ABB },
	{ 0xCE66,  0x8AAF },
	{ 0xCE67,  0xE6AD },
	{ 0xCE68,  0x8AB7 },
	{ 0xCE69,  0x8AB9 },
	{ 0xCE6A,  0x8AB8 },
	{ 0xCE6B,  0x8AB4 },
	{ 0xCE6C,  0x8AA5 },
	{ 0xCE6D,  0x8AB0 },
	{ 0xCE6E,  0x8AB5 },
	{ 0xCE6F,  0x8A9F },
	{ 0xCE70,  0x8AA8 },
	{ 0xCE71,  0x8AB1 },
	{ 0xCE72,  0x8AB3 },
	{ 0xCE73,  0x8AA2 },
	{ 0xCE74,  0x8ABA },
	{ 0xCE75,  0x8AB2 },
	{ 0xCE76,  0x8AAB },
	{ 0xCE77,  0x8C69 },
	{ 0xCE78,  0x8CC5 },
	{ 0xCE79,  0x8D59 },
	{ 0xCE7A,  0x8D60 },
	{ 0xCE7B,  0x8D55 },
	{ 0xCE7C,  0x8D5F },
	{ 0xCE7D,  0xE1BE },
	{ 0xCE7E,  0x8D62 },
	{ 0xCEA1,  0x8D65 },
	{ 0xCEA2,  0x8D61 },
	{ 0xCEA3,  0x8D53 },
	{ 0xCEA4,  0x8D51 },
	{ 0xCEA5,  0x8D54 },
	{ 0xCEA6,  0x8D5E },
	{ 0xCEA7,  0x8D5B },
	{ 0xCEA8,  0x8D5C },
	{ 0xCEA9,  0x8D58 },
	{ 0xCEAA,  0x8D52 },
	{ 0xCEAB,  0x8D50 },
	{ 0xCEAC,  0x8D57 },
	{ 0xCEAD,  0x8D66 },
	{ 0xCEAE,  0x8D77 },
	{ 0xCEAF,  0x8E84 },
	{ 0xCEB0,  0x8E97 },
	{ 0xCEB1,  0x8E98 },
	{ 0xCEB2,  0x8E99 },
	{ 0xCEB3,  0x8E96 },
	{ 0xCEB4,  0x8E9A },
	{ 0xCEB5,  0x8EF0 },
	{ 0xCEB6,  0x8EE8 },
	{ 0xCEB7,  0x8EE6 },
	{ 0xCEB8,  0x8EE3 },
	{ 0xCEB9,  0x8EE7 },
	{ 0xCEBA,  0xE2D3 },
	{ 0xCEBB,  0x8F6D },
	{ 0xCEBC,  0x8F83 },
	{ 0xCEBD,  0xE5E8 },
	{ 0xCEBE,  0x8FB9 },
	{ 0xCEBF,  0x9058 },
	{ 0xCEC0,  0x905A },
	{ 0xCEC1,  0x906B },
	{ 0xCEC2,  0x9079 },
	{ 0xCEC3,  0x9071 },
	{ 0xCEC4,  0x9060 },
	{ 0xCEC5,  0x906A },
	{ 0xCEC6,  0x9062 },
	{ 0xCEC7,  0x9064 },
	{ 0xCEC8,  0x906F },
	{ 0xCEC9,  0x9066 },
	{ 0xCECA,  0x905E },
	{ 0xCECB,  0xE2FE },
	{ 0xCECC,  0x9072 },
	{ 0xCECD,  0x904E },
	{ 0xCECE,  0x905F },
	{ 0xCECF,  0x906E },
	{ 0xCED0,  0x9076 },
	{ 0xCED1,  0x9077 },
	{ 0xCED2,  0x91FA },
	{ 0xCED3,  0xECE7 },
	{ 0xCED4,  0x9282 },
	{ 0xCED5,  0x929B },
	{ 0xCED6,  0x9299 },
	{ 0xCED7,  0x928E },
	{ 0xCED8,  0xBFE6 },
	{ 0xCED9,  0x9294 },
	{ 0xCEDA,  0x928B },
	{ 0xCEDB,  0x9290 },
	{ 0xCEDC,  0x929C },
	{ 0xCEDD,  0x929A },
	{ 0xCEDE,  0x928F },
	{ 0xCEDF,  0xDED9 },
	{ 0xCEE0,  0x9293 },
	{ 0xCEE1,  0x929F },
	{ 0xCEE2,  0x92A0 },
	{ 0xCEE3,  0x9291 },
	{ 0xCEE4,  0x92A1 },
	{ 0xCEE5,  0x9292 },
	{ 0xCEE6,  0x928C },
	{ 0xCEE7,  0x9493 },
	{ 0xCEE8,  0x9495 },
	{ 0xCEE9,  0x94D7 },
	{ 0xCEEA,  0x94E5 },
	{ 0xCEEB,  0xEAC6 },
	{ 0xCEEC,  0x955D },
	{ 0xCEED,  0x9568 },
	{ 0xCEEE,  0xEAC7 },
	{ 0xCEEF,  0x955B },
	{ 0xCEF0,  0x9561 },
	{ 0xCEF1,  0x955E },
	{ 0xCEF2,  0x9569 },
	{ 0xCEF3,  0x9564 },
	{ 0xCEF4,  0x956D },
	{ 0xCEF5,  0xEAC3 },
	{ 0xCEF6,  0xEAC4 },
	{ 0xCEF7,  0x956C },
	{ 0xCEF8,  0x9566 },
	{ 0xCEF9,  0x9646 },
	{ 0xCEFA,  0xEBD4 },
	{ 0xCEFB,  0xE8DE },
	{ 0xCEFC,  0x96C4 },
	{ 0xCEFD,  0x96AE },
	{ 0xCEFE,  0x96A3 },
	{ 0xCF40,  0xB9F1 },
	{ 0xCF41,  0x96A4 },
	{ 0xCF42,  0x96C8 },
	{ 0xCF43,  0xE8CF },
	{ 0xCF44,  0x96A9 },
	{ 0xCF45,  0xBCCF },
	{ 0xCF46,  0x96AB },
	{ 0xCF47,  0x96C1 },
	{ 0xCF48,  0x96BC },
	{ 0xCF49,  0x96B9 },
	{ 0xCF4A,  0xE8D5 },
	{ 0xCF4B,  0x96B3 },
	{ 0xCF4C,  0xE8D7 },
	{ 0xCF4D,  0x96C7 },
	{ 0xCF4E,  0x96C6 },
	{ 0xCF4F,  0x96C3 },
	{ 0xCF50,  0x96BB },
	{ 0xCF51,  0x96AA },
	{ 0xCF52,  0x96A2 },
	{ 0xCF53,  0x96B4 },
	{ 0xCF54,  0x96BE },
	{ 0xCF55,  0xE8CD },
	{ 0xCF56,  0x96A0 },
	{ 0xCF57,  0x96CC },
	{ 0xCF58,  0x96AC },
	{ 0xCF59,  0x96C2 },
	{ 0xCF5A,  0x96B2 },
	{ 0xCF5B,  0x969E },
	{ 0xCF5C,  0x96BD },
	{ 0xCF5D,  0x96B8 },
	{ 0xCF5E,  0x96CA },
	{ 0xCF5F,  0x96AF },
	{ 0xCF60,  0x96B0 },
	{ 0xCF61,  0xE8DA },
	{ 0xCF62,  0x96C0 },
	{ 0xCF63,  0x96B1 },
	{ 0xCF64,  0x99F8 },
	{ 0xCF65,  0xE9E3 },
	{ 0xCF66,  0xE9E5 },
	{ 0xCF67,  0x9A9F },
	{ 0xCF68,  0xB1D1 },
	{ 0xCF69,  0x9AB3 },
	{ 0xCF6A,  0x9AB9 },
	{ 0xCF6B,  0x9AE1 },
	{ 0xCF6C,  0xEBB1 },
	{ 0xCF6D,  0x9BA9 },
	{ 0xCF6E,  0x9BAF },
	{ 0xCF6F,  0x9BAC },
	{ 0xCF70,  0x9BA2 },
	{ 0xCF71,  0xCDDD },
	{ 0xCF72,  0x9BB4 },
	{ 0xCF73,  0xC8F7 },
	{ 0xCF74,  0x9B96 },
	{ 0xCF75,  0x9B81 },
	{ 0xCF76,  0xE4B2 },
	{ 0xCF77,  0xE4A7 },
	{ 0xCF78,  0xE4A8 },
	{ 0xCF79,  0x9BB3 },
	{ 0xCF7A,  0xE4AE },
	{ 0xCF7B,  0x9B9A },
	{ 0xCF7C,  0x9B8F },
	{ 0xCF7D,  0x9BA1 },
	{ 0xCF7E,  0x9BB6 },
	{ 0xCFA1,  0xBDE0 },
	{ 0xCFA2,  0x9B9F },
	{ 0xCFA3,  0x9BB1 },
	{ 0xCFA4,  0x9B91 },
	{ 0xCFA5,  0x9B98 },
	{ 0xCFA6,  0x9BB5 },
	{ 0xCFA7,  0xE4A6 },
	{ 0xCFA8,  0x9BA3 },
	{ 0xCFA9,  0x9BAB },
	{ 0xCFAA,  0x9B94 },
	{ 0xCFAB,  0x9BA5 },
	{ 0xCFAC,  0x9B95 },
	{ 0xCFAD,  0x9B99 },
	{ 0xCFAE,  0xECC4 },
	{ 0xCFAF,  0x9ED8 },
	{ 0xCFB0,  0x9EEA },
	{ 0xCFB1,  0xECC6 },
	{ 0xCFB2,  0x9EE4 },
	{ 0xCFB3,  0x9EDA },
	{ 0xCFB4,  0x9EE6 },
	{ 0xCFB5,  0x9EE7 },
	{ 0xCFB6,  0x9EE2 },
	{ 0xCFB7,  0xA098 },
	{ 0xCFB8,  0xA09E },
	{ 0xCFB9,  0xA09F },
	{ 0xCFBA,  0xA0B4 },
	{ 0xCFBB,  0xA0B6 },
	{ 0xCFBC,  0xA0B8 },
	{ 0xCFBD,  0xEAF0 },
	{ 0xCFBE,  0xA0F3 },
	{ 0xCFBF,  0xAA45 },
	{ 0xCFC0,  0xE1F5 },
	{ 0xCFC1,  0xAA4A },
	{ 0xCFC2,  0xAA42 },
	{ 0xCFC3,  0xAA49 },
	{ 0xCFC4,  0xAA47 },
	{ 0xCFC5,  0xAA44 },
	{ 0xCFC6,  0xAB51 },
	{ 0xCFC7,  0xAB81 },
	{ 0xCFC8,  0xE7E6 },
	{ 0xCFC9,  0xE7EC },
	{ 0xCFCA,  0xAB7C },
	{ 0xCFCB,  0xAB74 },
	{ 0xCFCC,  0xAB72 },
	{ 0xCFCD,  0xAB71 },
	{ 0xCFCE,  0xAB70 },
	{ 0xCFCF,  0xAB96 },
	{ 0xCFD0,  0xAB78 },
	{ 0xCFD1,  0xAB7E },
	{ 0xCFD2,  0xAB77 },
	{ 0xCFD3,  0xAB7A },
	{ 0xCFD4,  0xAB7D },
	{ 0xCFD5,  0xAB73 },
	{ 0xCFD6,  0xAB80 },
	{ 0xCFD7,  0xAD9C },
	{ 0xCFD8,  0xCECD },
	{ 0xCFD9,  0xAE67 },
	{ 0xCFDA,  0xAE73 },
	{ 0xCFDB,  0xEEB2 },
	{ 0xCFDC,  0xAF4F },
	{ 0xCFDD,  0xAF52 },
	{ 0xCFDE,  0xB06A },
	{ 0xCFDF,  0xB140 },
	{ 0xCFE0,  0xEDF1 },
	{ 0xCFE1,  0xB164 },
	{ 0xCFE2,  0xEDED },
	{ 0xCFE3,  0xB165 },
	{ 0xCFE4,  0xB167 },
	{ 0xCFE5,  0xB15D },
	{ 0xCFE6,  0xB15F },
	{ 0xCFE7,  0xB15E },
	{ 0xCFE8,  0xEFF2 },
	{ 0xCFE9,  0xB341 },
	{ 0xCFEA,  0xB351 },
	{ 0xCFEB,  0xEDBC },
	{ 0xCFEC,  0xC5F8 },
	{ 0xCFED,  0xB350 },
	{ 0xCFEE,  0xB358 },
	{ 0xCFEF,  0xB357 },
	{ 0xCFF0,  0xB356 },
	{ 0xCFF1,  0xEDB9 },
	{ 0xCFF2,  0xB34E },
	{ 0xCFF3,  0xB359 },
	{ 0xCFF4,  0xB570 },
	{ 0xCFF5,  0xB572 },
	{ 0xCFF6,  0xB571 },
	{ 0xCFF7,  0xB56E },
	{ 0xCFF8,  0xB56D },
	{ 0xCFF9,  0xEFF5 },
	{ 0xCFFA,  0xD6D6 },
	{ 0xCFFB,  0xB66D },
	{ 0xCFFC,  0xB671 },
	{ 0xCFFD,  0xB66C },
	{ 0xCFFE,  0xF1B8 },
	{ 0xD040,  0xB78E },
	{ 0xD041,  0xB866 },
	{ 0xD042,  0xB888 },
	{ 0xD043,  0xB889 },
	{ 0xD044,  0xBB74 },
	{ 0xD045,  0xBB72 },
	{ 0xD046,  0xBB73 },
	{ 0xD047,  0xBB76 },
	{ 0xD048,  0xBB77 },
	{ 0xD049,  0xBB78 },
	{ 0xD04A,  0xBC72 },
	{ 0xD04B,  0xBC77 },
	{ 0xD04C,  0xBC70 },
	{ 0xD04D,  0xEEB7 },
	{ 0xD04E,  0xC168 },
	{ 0xD04F,  0xC165 },
	{ 0xD050,  0xC187 },
	{ 0xD051,  0xC254 },
	{ 0xD052,  0xC258 },
	{ 0xD053,  0xC259 },
	{ 0xD054,  0xF1E8 },
	{ 0xD055,  0xDEC7 },
	{ 0xD056,  0xC36A },
	{ 0xD057,  0xC35E },
	{ 0xD058,  0xC36C },
	{ 0xD059,  0xC365 },
	{ 0xD05A,  0xC35F },
	{ 0xD05B,  0xEBCF },
	{ 0xD05C,  0xC364 },
	{ 0xD05D,  0xC35D },
	{ 0xD05E,  0xC36E },
	{ 0xD05F,  0xEBD1 },
	{ 0xD060,  0xCAA4 },
	{ 0xD061,  0xC361 },
	{ 0xD062,  0xC369 },
	{ 0xD063,  0xC360 },
	{ 0xD064,  0xC363 },
	{ 0xD065,  0xEBD3 },
	{ 0xD066,  0xC36F },
	{ 0xD067,  0xEBD2 },
	{ 0xD068,  0xC561 },
	{ 0xD069,  0xF4AD },
	{ 0xD06A,  0xC655 },
	{ 0xD06B,  0xC66E },
	{ 0xD06C,  0xC683 },
	{ 0xD06D,  0xC6BB },
	{ 0xD06E,  0xDCD8 },
	{ 0xD06F,  0xC673 },
	{ 0xD070,  0xC685 },
	{ 0xD071,  0xDCE6 },
	{ 0xD072,  0xDCFB },
	{ 0xD073,  0xC9BB },
	{ 0xD074,  0xC66D },
	{ 0xD075,  0xDCDA },
	{ 0xD076,  0xC676 },
	{ 0xD077,  0xDCD3 },
	{ 0xD078,  0xC67A },
	{ 0xD079,  0xC67C },
	{ 0xD07A,  0xDCDD },
	{ 0xD07B,  0xDCDE },
	{ 0xD07C,  0xC67D },
	{ 0xD07D,  0xC679 },
	{ 0xD07E,  0xC675 },
	{ 0xD0A1,  0xDCD6 },
	{ 0xD0A2,  0xDCE5 },
	{ 0xD0A3,  0xC680 },
	{ 0xD0A4,  0xC67B },
	{ 0xD0A5,  0xC677 },
	{ 0xD0A6,  0xCD48 },
	{ 0xD0A7,  0xCD45 },
	{ 0xD0A8,  0xF2B4 },
	{ 0xD0A9,  0xCD44 },
	{ 0xD0AA,  0xD059 },
	{ 0xD0AB,  0xD062 },
	{ 0xD0AC,  0xD073 },
	{ 0xD0AD,  0xD074 },
	{ 0xD0AE,  0xF1C3 },
	{ 0xD0AF,  0xD361 },
	{ 0xD0B0,  0xD388 },
	{ 0xD0B1,  0xD9EA },
	{ 0xD0B2,  0xDA5C },
	{ 0xD0B3,  0xDE8C },
	{ 0xD0B4,  0xDE8B },
	{ 0xD0B5,  0xE5C5 },
	{ 0xD0B6,  0xDE8A },
	{ 0xD0B7,  0xE05A },
	{ 0xD0B8,  0xDF9E },
	{ 0xD0B9,  0xDF9F },
	{ 0xD0BA,  0xE04A },
	{ 0xD0BB,  0xDBA4 },
	{ 0xD0BC,  0xDBA5 },
	{ 0xD0BD,  0xDBA8 },
	{ 0xD0BE,  0xE045 },
	{ 0xD0BF,  0xE043 },
	{ 0xD0C0,  0xE190 },
	{ 0xD0C1,  0xE18F },
	{ 0xD0C2,  0xDAEB },
	{ 0xD0C3,  0xEA79 },
	{ 0xD0C4,  0xEA7A },
	{ 0xD0C5,  0xEA7C },
	{ 0xD0C6,  0xEA77 },
	{ 0xD0C7,  0xEA78 },
	{ 0xD0C8,  0x828A },
	{ 0xD0C9,  0x8279 },
	{ 0xD0CA,  0x827B },
	{ 0xD0CB,  0x8284 },
	{ 0xD0CC,  0x828C },
	{ 0xD0CD,  0x8292 },
	{ 0xD0CE,  0x8288 },
	{ 0xD0CF,  0x826C },
	{ 0xD0D0,  0x826B },
	{ 0xD0D1,  0x8295 },
	{ 0xD0D2,  0x8299 },
	{ 0xD0D3,  0xD9BE },
	{ 0xD0D4,  0x826D },
	{ 0xD0D5,  0x826E },
	{ 0xD0D6,  0x8287 },
	{ 0xD0D7,  0xD9C3 },
	{ 0xD0D8,  0x828B },
	{ 0xD0D9,  0x828F },
	{ 0xD0DA,  0x8297 },
	{ 0xD0DB,  0x8291 },
	{ 0xD0DC,  0x8293 },
	{ 0xD0DD,  0x8281 },
	{ 0xD0DE,  0xB5B3 },
	{ 0xD0DF,  0x83DB },
	{ 0xD0E0,  0x83DA },
	{ 0xD0E1,  0x83F5 },
	{ 0xD0E2,  0xC6E0 },
	{ 0xD0E3,  0x83F3 },
	{ 0xD0E4,  0x83F4 },
	{ 0xD0E5,  0x83F7 },
	{ 0xD0E6,  0xD8DF },
	{ 0xD0E7,  0x8481 },
	{ 0xD0E8,  0x847A },
	{ 0xD0E9,  0xD8DE },
	{ 0xD0EA,  0x8484 },
	{ 0xD0EB,  0x847C },
	{ 0xD0EC,  0x8486 },
	{ 0xD0ED,  0x84CD },
	{ 0xD0EE,  0x84FE },
	{ 0xD0EF,  0x858A },
	{ 0xD0F0,  0x867E },
	{ 0xD0F1,  0x8655 },
	{ 0xD0F2,  0x8674 },
	{ 0xD0F3,  0x8670 },
	{ 0xD0F4,  0xDFEA },
	{ 0xD0F5,  0xDFEE },
	{ 0xD0F6,  0x8657 },
	{ 0xD0F7,  0x8677 },
	{ 0xD0F8,  0xDBC1 },
	{ 0xD0F9,  0x8668 },
	{ 0xD0FA,  0x866A },
	{ 0xD0FB,  0x8658 },
	{ 0xD0FC,  0xDFF2 },
	{ 0xD0FD,  0x8669 },
	{ 0xD0FE,  0x865C },
	{ 0xD140,  0x866B },
	{ 0xD141,  0x8663 },
	{ 0xD142,  0x8660 },
	{ 0xD143,  0x8661 },
	{ 0xD144,  0x8653 },
	{ 0xD145,  0x866F },
	{ 0xD146,  0x8667 },
	{ 0xD147,  0x866C },
	{ 0xD148,  0x87F4 },
	{ 0xD149,  0x87F5 },
	{ 0xD14A,  0x88B0 },
	{ 0xD14B,  0x88F4 },
	{ 0xD14C,  0xDBF4 },
	{ 0xD14D,  0xDBF8 },
	{ 0xD14E,  0x88A1 },
	{ 0xD14F,  0x88AB },
	{ 0xD150,  0x88A4 },
	{ 0xD151,  0x88A3 },
	{ 0xD152,  0xDBF9 },
	{ 0xD153,  0x889E },
	{ 0xD154,  0x88A6 },
	{ 0xD155,  0x88AC },
	{ 0xD156,  0x88B2 },
	{ 0xD157,  0x88A0 },
	{ 0xD158,  0x88A8 },
	{ 0xD159,  0x89E8 },
	{ 0xD15A,  0x8A47 },
	{ 0xD15B,  0x8AC8 },
	{ 0xD15C,  0x8AC6 },
	{ 0xD15D,  0x8AD6 },
	{ 0xD15E,  0x8AD7 },
	{ 0xD15F,  0x8AC5 },
	{ 0xD160,  0x8AC1 },
	{ 0xD161,  0x8AC7 },
	{ 0xD162,  0x8ABD },
	{ 0xD163,  0x8ACC },
	{ 0xD164,  0x8ADA },
	{ 0xD165,  0xD8AB },
	{ 0xD166,  0x8C68 },
	{ 0xD167,  0x8C6C },
	{ 0xD168,  0x8C6B },
	{ 0xD169,  0x8CA0 },
	{ 0xD16A,  0x8CCA },
	{ 0xD16B,  0x8CC9 },
	{ 0xD16C,  0x8D6D },
	{ 0xD16D,  0x8D7D },
	{ 0xD16E,  0x8D6E },
	{ 0xD16F,  0x8D70 },
	{ 0xD170,  0x8D76 },
	{ 0xD171,  0x8D7E },
	{ 0xD172,  0x8D78 },
	{ 0xD173,  0x8E9D },
	{ 0xD174,  0x8E9C },
	{ 0xD175,  0x8EE9 },
	{ 0xD176,  0x8EEE },
	{ 0xD177,  0x8EEB },
	{ 0xD178,  0x8EED },
	{ 0xD179,  0x8F86 },
	{ 0xD17A,  0x8F84 },
	{ 0xD17B,  0x8FAA },
	{ 0xD17C,  0xEDA2 },
	{ 0xD17D,  0xEDA3 },
	{ 0xD17E,  0xEDA4 },
	{ 0xD1A1,  0xEDA5 },
	{ 0xD1A2,  0x9094 },
	{ 0xD1A3,  0x9085 },
	{ 0xD1A4,  0x907E },
	{ 0xD1A5,  0xE3A8 },
	{ 0xD1A6,  0x9080 },
	{ 0xD1A7,  0xE3A6 },
	{ 0xD1A8,  0xE3A7 },
	{ 0xD1A9,  0x908D },
	{ 0xD1AA,  0xE3AA },
	{ 0xD1AB,  0x908E },
	{ 0xD1AC,  0x9084 },
	{ 0xD1AD,  0x9091 },
	{ 0xD1AE,  0x9088 },
	{ 0xD1AF,  0x91E3 },
	{ 0xD1B0,  0x91FD },
	{ 0xD1B1,  0x928D },
	{ 0xD1B2,  0x929D },
	{ 0xD1B3,  0x92C2 },
	{ 0xD1B4,  0x92A9 },
	{ 0xD1B5,  0x92BA },
	{ 0xD1B6,  0xCDB1 },
	{ 0xD1B7,  0x92B1 },
	{ 0xD1B8,  0xDEDC },
	{ 0xD1B9,  0x9356 },
	{ 0xD1BA,  0xDEDA },
	{ 0xD1BB,  0xDEDB },
	{ 0xD1BC,  0x92BD },
	{ 0xD1BD,  0x92B5 },
	{ 0xD1BE,  0x92A8 },
	{ 0xD1BF,  0x92B9 },
	{ 0xD1C0,  0x92AF },
	{ 0xD1C1,  0x92C4 },
	{ 0xD1C2,  0x92C1 },
	{ 0xD1C3,  0x92C5 },
	{ 0xD1C4,  0x92AA },
	{ 0xD1C5,  0x92BB },
	{ 0xD1C6,  0x92AE },
	{ 0xD1C7,  0x92C6 },
	{ 0xD1C8,  0x92BE },
	{ 0xD1C9,  0x92B3 },
	{ 0xD1CA,  0x92C3 },
	{ 0xD1CB,  0x92B8 },
	{ 0xD1CC,  0x92BC },
	{ 0xD1CD,  0x9499 },
	{ 0xD1CE,  0x9497 },
	{ 0xD1CF,  0xECB7 },
	{ 0xD1D0,  0xECB9 },
	{ 0xD1D1,  0xECB8 },
	{ 0xD1D2,  0x94E7 },
	{ 0xD1D3,  0x9579 },
	{ 0xD1D4,  0xEAC9 },
	{ 0xD1D5,  0x9576 },
	{ 0xD1D6,  0x957D },
	{ 0xD1D7,  0x9648 },
	{ 0xD1D8,  0x9649 },
	{ 0xD1D9,  0x96DE },
	{ 0xD1DA,  0x96DA },
	{ 0xD1DB,  0xE8F1 },
	{ 0xD1DC,  0xE8E0 },
	{ 0xD1DD,  0xE8E1 },
	{ 0xD1DE,  0x96F2 },
	{ 0xD1DF,  0x96F5 },
	{ 0xD1E0,  0x96F7 },
	{ 0xD1E1,  0xC6DC },
	{ 0xD1E2,  0x96ED },
	{ 0xD1E3,  0x96DC },
	{ 0xD1E4,  0x96EF },
	{ 0xD1E5,  0x96E7 },
	{ 0xD1E6,  0x96E9 },
	{ 0xD1E7,  0x96EB },
	{ 0xD1E8,  0xE8E4 },
	{ 0xD1E9,  0xE8E6 },
	{ 0xD1EA,  0x96EE },
	{ 0xD1EB,  0xE8E9 },
	{ 0xD1EC,  0x96D5 },
	{ 0xD1ED,  0x96D6 },
	{ 0xD1EE,  0x96E4 },
	{ 0xD1EF,  0x96E6 },
	{ 0xD1F0,  0x96EA },
	{ 0xD1F1,  0x96F6 },
	{ 0xD1F2,  0x96F1 },
	{ 0xD1F3,  0x96E3 },
	{ 0xD1F4,  0x96DF },
	{ 0xD1F5,  0x99FC },
	{ 0xD1F6,  0x9A40 },
	{ 0xD1F7,  0x99FD },
	{ 0xD1F8,  0x9A42 },
	{ 0xD1F9,  0x9A44 },
	{ 0xD1FA,  0x9A6C },
	{ 0xD1FB,  0xC342 },
	{ 0xD1FC,  0x9A7E },
	{ 0xD1FD,  0x9ABE },
	{ 0xD1FE,  0x9ABC },
	{ 0xD240,  0x9AC0 },
	{ 0xD241,  0x9ABB },
	{ 0xD242,  0x9ABA },
	{ 0xD243,  0x9ABF },
	{ 0xD244,  0x9AE3 },
	{ 0xD245,  0x9BD2 },
	{ 0xD246,  0xE4BD },
	{ 0xD247,  0x9BC4 },
	{ 0xD248,  0x9BD0 },
	{ 0xD249,  0x9B97 },
	{ 0xD24A,  0x9BC2 },
	{ 0xD24B,  0x9BE2 },
	{ 0xD24C,  0x9BBE },
	{ 0xD24D,  0x9BC3 },
	{ 0xD24E,  0x9BCA },
	{ 0xD24F,  0xE4B4 },
	{ 0xD250,  0xE4B3 },
	{ 0xD251,  0x9BDF },
	{ 0xD252,  0x9C55 },
	{ 0xD253,  0x9BD6 },
	{ 0xD254,  0x9BDB },
	{ 0xD255,  0xE4B7 },
	{ 0xD256,  0x9BC6 },
	{ 0xD257,  0xE4BB },
	{ 0xD258,  0x9BE4 },
	{ 0xD259,  0x9BCB },
	{ 0xD25A,  0xE4BC },
	{ 0xD25B,  0x9BC1 },
	{ 0xD25C,  0xCDBF },
	{ 0xD25D,  0x9BE5 },
	{ 0xD25E,  0x9BAD },
	{ 0xD25F,  0x9BC7 },
	{ 0xD260,  0x9BDE },
	{ 0xD261,  0x9BD5 },
	{ 0xD262,  0x9BD7 },
	{ 0xD263,  0x9BDA },
	{ 0xD264,  0x9B9E },
	{ 0xD265,  0x9BD9 },
	{ 0xD266,  0x9BD3 },
	{ 0xD267,  0x9BD4 },
	{ 0xD268,  0x9BCF },
	{ 0xD269,  0x9BE1 },
	{ 0xD26A,  0x9F40 },
	{ 0xD26B,  0x9EF9 },
	{ 0xD26C,  0x9EF7 },
	{ 0xD26D,  0x9F41 },
	{ 0xD26E,  0x9EF1 },
	{ 0xD26F,  0xC08C },
	{ 0xD270,  0x9F45 },
	{ 0xD271,  0x9EFD },
	{ 0xD272,  0x9EF8 },
	{ 0xD273,  0x9F42 },
	{ 0xD274,  0x9F43 },
	{ 0xD275,  0x9EFA },
	{ 0xD276,  0x9EF3 },
	{ 0xD277,  0x9EED },
	{ 0xD278,  0x9EEE },
	{ 0xD279,  0x9EEF },
	{ 0xD27A,  0x9EFE },
	{ 0xD27B,  0x9EF4 },
	{ 0xD27C,  0x9F44 },
	{ 0xD27D,  0xA099 },
	{ 0xD27E,  0xA0BC },
	{ 0xD2A1,  0xA0BB },
	{ 0xD2A2,  0xA0BA },
	{ 0xD2A3,  0xAA51 },
	{ 0xD2A4,  0xE1FE },
	{ 0xD2A5,  0xE1F9 },
	{ 0xD2A6,  0xAA4F },
	{ 0xD2A7,  0xAA4C },
	{ 0xD2A8,  0xE1FC },
	{ 0xD2A9,  0xE2A1 },
	{ 0xD2AA,  0xE1FB },
	{ 0xD2AB,  0xAB84 },
	{ 0xD2AC,  0xE7EE },
	{ 0xD2AD,  0xE7ED },
	{ 0xD2AE,  0xAB87 },
	{ 0xD2AF,  0xAB75 },
	{ 0xD2B0,  0xE7F2 },
	{ 0xD2B1,  0xAB91 },
	{ 0xD2B2,  0xE7F1 },
	{ 0xD2B3,  0xAB8C },
	{ 0xD2B4,  0xAB83 },
	{ 0xD2B5,  0xAB8B },
	{ 0xD2B6,  0xAB85 },
	{ 0xD2B7,  0xAB8D },
	{ 0xD2B8,  0xAB8A },
	{ 0xD2B9,  0xAB88 },
	{ 0xD2BA,  0xAB89 },
	{ 0xD2BB,  0xAB94 },
	{ 0xD2BC,  0xF0AC },
	{ 0xD2BD,  0xAD94 },
	{ 0xD2BE,  0xEAB2 },
	{ 0xD2BF,  0xAE41 },
	{ 0xD2C0,  0xAE60 },
	{ 0xD2C1,  0xEEB3 },
	{ 0xD2C2,  0xAE82 },
	{ 0xD2C3,  0xF0E6 },
	{ 0xD2C4,  0xAF5A },
	{ 0xD2C5,  0xAF57 },
	{ 0xD2C6,  0xF0E4 },
	{ 0xD2C7,  0xAF59 },
	{ 0xD2C8,  0xAF58 },
	{ 0xD2C9,  0xAF54 },
	{ 0xD2CA,  0xAF56 },
	{ 0xD2CB,  0xB073 },
	{ 0xD2CC,  0xB142 },
	{ 0xD2CD,  0xB176 },
	{ 0xD2CE,  0xB174 },
	{ 0xD2CF,  0xB16B },
	{ 0xD2D0,  0xB16E },
	{ 0xD2D1,  0xB16D },
	{ 0xD2D2,  0xB179 },
	{ 0xD2D3,  0xB16C },
	{ 0xD2D4,  0xB170 },
	{ 0xD2D5,  0xEDF4 },
	{ 0xD2D6,  0xEDF2 },
	{ 0xD2D7,  0xEDF3 },
	{ 0xD2D8,  0xB17C },
	{ 0xD2D9,  0xEDC8 },
	{ 0xD2DA,  0xEDC7 },
	{ 0xD2DB,  0xB360 },
	{ 0xD2DC,  0xB36A },
	{ 0xD2DD,  0xB366 },
	{ 0xD2DE,  0xB362 },
	{ 0xD2DF,  0xB365 },
	{ 0xD2E0,  0xB364 },
	{ 0xD2E1,  0xB35F },
	{ 0xD2E2,  0xEDC9 },
	{ 0xD2E3,  0xB369 },
	{ 0xD2E4,  0xB363 },
	{ 0xD2E5,  0xB367 },
	{ 0xD2E6,  0xB579 },
	{ 0xD2E7,  0xECEE },
	{ 0xD2E8,  0xB575 },
	{ 0xD2E9,  0xECEF },
	{ 0xD2EA,  0xECF0 },
	{ 0xD2EB,  0xB578 },
	{ 0xD2EC,  0xB577 },
	{ 0xD2ED,  0xEFF8 },
	{ 0xD2EE,  0xB680 },
	{ 0xD2EF,  0xB679 },
	{ 0xD2F0,  0xB681 },
	{ 0xD2F1,  0xEFF6 },
	{ 0xD2F2,  0xB67E },
	{ 0xD2F3,  0xB676 },
	{ 0xD2F4,  0xB678 },
	{ 0xD2F5,  0xB677 },
	{ 0xD2F6,  0xF1B9 },
	{ 0xD2F7,  0xB792 },
	{ 0xD2F8,  0xB790 },
	{ 0xD2F9,  0xB794 },
	{ 0xD2FA,  0xB795 },
	{ 0xD2FB,  0xB793 },
	{ 0xD2FC,  0xB791 },
	{ 0xD2FD,  0xB86C },
	{ 0xD2FE,  0xB891 },
	{ 0xD340,  0xF3C7 },
	{ 0xD341,  0xB893 },
	{ 0xD342,  0xB88B },
	{ 0xD343,  0xF3CB },
	{ 0xD344,  0xF3C5 },
	{ 0xD345,  0xF3C9 },
	{ 0xD346,  0xB890 },
	{ 0xD347,  0xB88D },
	{ 0xD348,  0xB892 },
	{ 0xD349,  0xBB7B },
	{ 0xD34A,  0xF4CE },
	{ 0xD34B,  0xBB81 },
	{ 0xD34C,  0xBB83 },
	{ 0xD34D,  0xBB80 },
	{ 0xD34E,  0xBB84 },
	{ 0xD34F,  0xBB7C },
	{ 0xD350,  0xBC8D },
	{ 0xD351,  0xBC8C },
	{ 0xD352,  0xBC80 },
	{ 0xD353,  0xBC7C },
	{ 0xD354,  0xBC87 },
	{ 0xD355,  0xBC85 },
	{ 0xD356,  0xBC82 },
	{ 0xD357,  0xBC8E },
	{ 0xD358,  0xBC81 },
	{ 0xD359,  0xBC7D },
	{ 0xD35A,  0xBC7A },
	{ 0xD35B,  0xC143 },
	{ 0xD35C,  0xEEB8 },
	{ 0xD35D,  0xC145 },
	{ 0xD35E,  0xC146 },
	{ 0xD35F,  0xC144 },
	{ 0xD360,  0xC142 },
	{ 0xD361,  0xC16C },
	{ 0xD362,  0xC169 },
	{ 0xD363,  0xC18A },
	{ 0xD364,  0xC189 },
	{ 0xD365,  0xC188 },
	{ 0xD366,  0xF1E9 },
	{ 0xD367,  0xC26F },
	{ 0xD368,  0xC26C },
	{ 0xD369,  0xB0B7 },
	{ 0xD36A,  0xEBDC },
	{ 0xD36B,  0xC373 },
	{ 0xD36C,  0xC371 },
	{ 0xD36D,  0xC378 },
	{ 0xD36E,  0xC374 },
	{ 0xD36F,  0xC377 },
	{ 0xD370,  0xF4A8 },
	{ 0xD371,  0xF4B1 },
	{ 0xD372,  0xC575 },
	{ 0xD373,  0xDCFC },
	{ 0xD374,  0xDCFA },
	{ 0xD375,  0xC744 },
	{ 0xD376,  0xC68E },
	{ 0xD377,  0xDCE8 },
	{ 0xD378,  0xC697 },
	{ 0xD379,  0xC74E },
	{ 0xD37A,  0xC741 },
	{ 0xD37B,  0xC742 },
	{ 0xD37C,  0xC698 },
	{ 0xD37D,  0xDCE7 },
	{ 0xD37E,  0xC694 },
	{ 0xD3A1,  0xC743 },
	{ 0xD3A2,  0xC74B },
	{ 0xD3A3,  0xDDA2 },
	{ 0xD3A4,  0xC69A },
	{ 0xD3A5,  0xDCEB },
	{ 0xD3A6,  0xDCED },
	{ 0xD3A7,  0xC74A },
	{ 0xD3A8,  0xC68C },
	{ 0xD3A9,  0xC696 },
	{ 0xD3AA,  0xC692 },
	{ 0xD3AB,  0xC69E },
	{ 0xD3AC,  0xDCF2 },
	{ 0xD3AD,  0xC699 },
	{ 0xD3AE,  0xDCF4 },
	{ 0xD3AF,  0xC745 },
	{ 0xD3B0,  0xC749 },
	{ 0xD3B1,  0xC74C },
	{ 0xD3B2,  0xC690 },
	{ 0xD3B3,  0xB2E7 },
	{ 0xD3B4,  0xC748 },
	{ 0xD3B5,  0xBCEB },
	{ 0xD3B6,  0xC746 },
	{ 0xD3B7,  0xCC8D },
	{ 0xD3B8,  0xCC8C },
	{ 0xD3B9,  0xCD61 },
	{ 0xD3BA,  0xF2B6 },
	{ 0xD3BB,  0xCD57 },
	{ 0xD3BC,  0xF2B7 },
	{ 0xD3BD,  0xCD54 },
	{ 0xD3BE,  0xCD5D },
	{ 0xD3BF,  0xCD4E },
	{ 0xD3C0,  0xCD58 },
	{ 0xD3C1,  0xCD4D },
	{ 0xD3C2,  0xF2B8 },
	{ 0xD3C3,  0xCD5B },
	{ 0xD3C4,  0xCD4C },
	{ 0xD3C5,  0xCD62 },
	{ 0xD3C6,  0xCD5A },
	{ 0xD3C7,  0xCD60 },
	{ 0xD3C8,  0xF2BB },
	{ 0xD3C9,  0xB2CF },
	{ 0xD3CA,  0xCD59 },
	{ 0xD3CB,  0xCD51 },
	{ 0xD3CC,  0xF2BA },
	{ 0xD3CD,  0xCD53 },
	{ 0xD3CE,  0xCD56 },
	{ 0xD3CF,  0xD05B },
	{ 0xD3D0,  0xF4AC },
	{ 0xD3D1,  0xD075 },
	{ 0xD3D2,  0xD07A },
	{ 0xD3D3,  0xD07B },
	{ 0xD3D4,  0xF1C4 },
	{ 0xD3D5,  0xD082 },
	{ 0xD3D6,  0xD077 },
	{ 0xD3D7,  0xF1C6 },
	{ 0xD3D8,  0xD076 },
	{ 0xD3D9,  0xD083 },
	{ 0xD3DA,  0xF4C0 },
	{ 0xD3DB,  0xD079 },
	{ 0xD3DC,  0xD081 },
	{ 0xD3DD,  0xD395 },
	{ 0xD3DE,  0xF4F8 },
	{ 0xD3DF,  0xD859 },
	{ 0xD3E0,  0xD874 },
	{ 0xD3E1,  0xD897 },
	{ 0xD3E2,  0xD896 },
	{ 0xD3E3,  0xB8CF },
	{ 0xD3E4,  0xDA5D },
	{ 0xD3E5,  0xF5C0 },
	{ 0xD3E6,  0xDA90 },
	{ 0xD3E7,  0xDA8F },
	{ 0xD3E8,  0xDC8D },
	{ 0xD3E9,  0xDC8F },
	{ 0xD3EA,  0xDE98 },
	{ 0xD3EB,  0xDE93 },
	{ 0xD3EC,  0xCACA },
	{ 0xD3ED,  0xDE99 },
	{ 0xD3EE,  0xDE96 },
	{ 0xD3EF,  0xE5CC },
	{ 0xD3F0,  0xDE97 },
	{ 0xD3F1,  0xDE94 },
	{ 0xD3F2,  0xE04B },
	{ 0xD3F3,  0xE051 },
	{ 0xD3F4,  0xE04D },
	{ 0xD3F5,  0xE04E },
	{ 0xD3F6,  0xE052 },
	{ 0xD3F7,  0xE050 },
	{ 0xD3F8,  0xE054 },
	{ 0xD3F9,  0xE04C },
	{ 0xD3FA,  0xDBAE },
	{ 0xD3FB,  0xDBAD },
	{ 0xD3FC,  0xDBAC },
	{ 0xD3FD,  0xE053 },
	{ 0xD3FE,  0xF4FB },
	{ 0xD440,  0xF4FC },
	{ 0xD441,  0xF4FD },
	{ 0xD442,  0xE191 },
	{ 0xD443,  0xE19D },
	{ 0xD444,  0xE196 },
	{ 0xD445,  0xEA83 },
	{ 0xD446,  0xDAEC },
	{ 0xD447,  0xF6C0 },
	{ 0xD448,  0xEF7D },
	{ 0xD449,  0xF7D4 },
	{ 0xD44A,  0xDBCB },
	{ 0xD44B,  0x8176 },
	{ 0xD44C,  0x82C4 },
	{ 0xD44D,  0x82BF },
	{ 0xD44E,  0x82B7 },
	{ 0xD44F,  0x82B4 },
	{ 0xD450,  0x82B6 },
	{ 0xD451,  0x82AC },
	{ 0xD452,  0x82A7 },
	{ 0xD453,  0x82B3 },
	{ 0xD454,  0x82C6 },
	{ 0xD455,  0xD9CA },
	{ 0xD456,  0x82A8 },
	{ 0xD457,  0x82A0 },
	{ 0xD458,  0x82B2 },
	{ 0xD459,  0x82A6 },
	{ 0xD45A,  0x82B8 },
	{ 0xD45B,  0x8285 },
	{ 0xD45C,  0x82A3 },
	{ 0xD45D,  0x82B5 },
	{ 0xD45E,  0x82BE },
	{ 0xD45F,  0x82C0 },
	{ 0xD460,  0x82B9 },
	{ 0xD461,  0x82BA },
	{ 0xD462,  0x82A4 },
	{ 0xD463,  0x829F },
	{ 0xD464,  0x82C2 },
	{ 0xD465,  0x82C7 },
	{ 0xD466,  0x82AF },
	{ 0xD467,  0x82AA },
	{ 0xD468,  0x83F8 },
	{ 0xD469,  0x848B },
	{ 0xD46A,  0x848D },
	{ 0xD46B,  0x848C },
	{ 0xD46C,  0x848E },
	{ 0xD46D,  0xDBC3 },
	{ 0xD46E,  0x84D1 },
	{ 0xD46F,  0x8551 },
	{ 0xD470,  0x8589 },
	{ 0xD471,  0xE0A3 },
	{ 0xD472,  0xE0A4 },
	{ 0xD473,  0xDFFE },
	{ 0xD474,  0x8694 },
	{ 0xD475,  0xDFFD },
	{ 0xD476,  0x8685 },
	{ 0xD477,  0xDFF4 },
	{ 0xD478,  0x8697 },
	{ 0xD479,  0x86A4 },
	{ 0xD47A,  0x8687 },
	{ 0xD47B,  0x8686 },
	{ 0xD47C,  0xE0A7 },
	{ 0xD47D,  0x8698 },
	{ 0xD47E,  0x868F },
	{ 0xD4A1,  0x866D },
	{ 0xD4A2,  0x8684 },
	{ 0xD4A3,  0xC9B6 },
	{ 0xD4A4,  0x8695 },
	{ 0xD4A5,  0x8689 },
	{ 0xD4A6,  0x8691 },
	{ 0xD4A7,  0x8683 },
	{ 0xD4A8,  0x868B },
	{ 0xD4A9,  0x868D },
	{ 0xD4AA,  0x8692 },
	{ 0xD4AB,  0xE0F5 },
	{ 0xD4AC,  0x87F7 },
	{ 0xD4AD,  0x88CD },
	{ 0xD4AE,  0x88DE },
	{ 0xD4AF,  0x88BB },
	{ 0xD4B0,  0x88CB },
	{ 0xD4B1,  0x88B8 },
	{ 0xD4B2,  0xDBFA },
	{ 0xD4B3,  0xDCA5 },
	{ 0xD4B4,  0xDCA4 },
	{ 0xD4B5,  0xDCA3 },
	{ 0xD4B6,  0x88D5 },
	{ 0xD4B7,  0xDBFC },
	{ 0xD4B8,  0xDCA1 },
	{ 0xD4B9,  0x88C9 },
	{ 0xD4BA,  0xDBEF },
	{ 0xD4BB,  0xDDC0 },
	{ 0xD4BC,  0x88C5 },
	{ 0xD4BD,  0x88BC },
	{ 0xD4BE,  0x88C8 },
	{ 0xD4BF,  0x88BD },
	{ 0xD4C0,  0x88C4 },
	{ 0xD4C1,  0x88BA },
	{ 0xD4C2,  0x88D9 },
	{ 0xD4C3,  0x88CE },
	{ 0xD4C4,  0x88DB },
	{ 0xD4C5,  0x88BF },
	{ 0xD4C6,  0x88D1 },
	{ 0xD4C7,  0x88D8 },
	{ 0xD4C8,  0x88C7 },
	{ 0xD4C9,  0x88C1 },
	{ 0xD4CA,  0x88C6 },
	{ 0xD4CB,  0xDCA2 },
	{ 0xD4CC,  0x88D3 },
	{ 0xD4CD,  0x8A4F },
	{ 0xD4CE,  0x8AFE },
	{ 0xD4CF,  0x8AF7 },
	{ 0xD4D0,  0xE6BC },
	{ 0xD4D1,  0xE6BA },
	{ 0xD4D2,  0x8AFC },
	{ 0xD4D3,  0x8ADD },
	{ 0xD4D4,  0x8ADB },
	{ 0xD4D5,  0x8B49 },
	{ 0xD4D6,  0x8AF0 },
	{ 0xD4D7,  0x8AFD },
	{ 0xD4D8,  0x8B43 },
	{ 0xD4D9,  0x8B48 },
	{ 0xD4DA,  0x8AF3 },
	{ 0xD4DB,  0x8B42 },
	{ 0xD4DC,  0x8AF6 },
	{ 0xD4DD,  0x8AE6 },
	{ 0xD4DE,  0x8AFB },
	{ 0xD4DF,  0x8AF2 },
	{ 0xD4E0,  0x8AE7 },
	{ 0xD4E1,  0x8AF9 },
	{ 0xD4E2,  0x8AEA },
	{ 0xD4E3,  0x8B64 },
	{ 0xD4E4,  0x8AE2 },
	{ 0xD4E5,  0x8AED },
	{ 0xD4E6,  0x8ADE },
	{ 0xD4E7,  0x8AEC },
	{ 0xD4E8,  0x8B4C },
	{ 0xD4E9,  0x8B46 },
	{ 0xD4EA,  0x8AE9 },
	{ 0xD4EB,  0x8AF1 },
	{ 0xD4EC,  0x8AF5 },
	{ 0xD4ED,  0x8AE5 },
	{ 0xD4EE,  0x8AFA },
	{ 0xD4EF,  0x8C53 },
	{ 0xD4F0,  0x8C51 },
	{ 0xD4F1,  0x8C76 },
	{ 0xD4F2,  0x8C75 },
	{ 0xD4F3,  0xE5ED },
	{ 0xD4F4,  0xE1C6 },
	{ 0xD4F5,  0x8D86 },
	{ 0xD4F6,  0x8D94 },
	{ 0xD4F7,  0x8D92 },
	{ 0xD4F8,  0x8D96 },
	{ 0xD4F9,  0x8D87 },
	{ 0xD4FA,  0x8D9B },
	{ 0xD4FB,  0x8D88 },
	{ 0xD4FC,  0xE1C3 },
	{ 0xD4FD,  0x8D9A },
	{ 0xD4FE,  0x8D89 },
	{ 0xD540,  0x8DA0 },
	{ 0xD541,  0x8D8C },
	{ 0xD542,  0x8D99 },
	{ 0xD543,  0x8D95 },
	{ 0xD544,  0xE1C4 },
	{ 0xD545,  0x8EAA },
	{ 0xD546,  0x8EA5 },
	{ 0xD547,  0x8EF1 },
	{ 0xD548,  0x8EF3 },
	{ 0xD549,  0xE2D5 },
	{ 0xD54A,  0x8EF2 },
	{ 0xD54B,  0xE2D8 },
	{ 0xD54C,  0x8F89 },
	{ 0xD54D,  0x8F8B },
	{ 0xD54E,  0x8FC2 },
	{ 0xD54F,  0x8FC0 },
	{ 0xD550,  0x8FC5 },
	{ 0xD551,  0x9086 },
	{ 0xD552,  0x908A },
	{ 0xD553,  0x9083 },
	{ 0xD554,  0x90A3 },
	{ 0xD555,  0x909B },
	{ 0xD556,  0x90A1 },
	{ 0xD557,  0x90B3 },
	{ 0xD558,  0x90B4 },
	{ 0xD559,  0x90B0 },
	{ 0xD55A,  0x90BD },
	{ 0xD55B,  0x90B7 },
	{ 0xD55C,  0xE3AE },
	{ 0xD55D,  0x90AB },
	{ 0xD55E,  0xE3AD },
	{ 0xD55F,  0x90B8 },
	{ 0xD560,  0x909F },
	{ 0xD561,  0xBEAA },
	{ 0xD562,  0x90A4 },
	{ 0xD563,  0x90A8 },
	{ 0xD564,  0x90AE },
	{ 0xD565,  0x90A5 },
	{ 0xD566,  0xEAFD },
	{ 0xD567,  0x92CC },
	{ 0xD568,  0xDEE5 },
	{ 0xD569,  0xB5E0 },
	{ 0xD56A,  0x92DB },
	{ 0xD56B,  0x92FC },
	{ 0xD56C,  0x92EF },
	{ 0xD56D,  0xDEDD },
	{ 0xD56E,  0x92EE },
	{ 0xD56F,  0x92E9 },
	{ 0xD570,  0x92F4 },
	{ 0xD571,  0xDEE1 },
	{ 0xD572,  0x92D2 },
	{ 0xD573,  0xB6DE },
	{ 0xD574,  0xC6FE },
	{ 0xD575,  0xBEDD },
	{ 0xD576,  0x92F5 },
	{ 0xD577,  0x92D7 },
	{ 0xD578,  0x92ED },
	{ 0xD579,  0xDEE3 },
	{ 0xD57A,  0xDEE7 },
	{ 0xD57B,  0x92DA },
	{ 0xD57C,  0x92F2 },
	{ 0xD57D,  0x92B4 },
	{ 0xD57E,  0x92F0 },
	{ 0xD5A1,  0x92D8 },
	{ 0xD5A2,  0x92E1 },
	{ 0xD5A3,  0x92DE },
	{ 0xD5A4,  0x92E5 },
	{ 0xD5A5,  0x92E4 },
	{ 0xD5A6,  0x92D3 },
	{ 0xD5A7,  0x949F },
	{ 0xD5A8,  0x94EC },
	{ 0xD5A9,  0x9588 },
	{ 0xD5AA,  0xEACE },
	{ 0xD5AB,  0x9581 },
	{ 0xD5AC,  0x9580 },
	{ 0xD5AD,  0x9582 },
	{ 0xD5AE,  0x9586 },
	{ 0xD5AF,  0x964B },
	{ 0xD5B0,  0x974F },
	{ 0xD5B1,  0x9759 },
	{ 0xD5B2,  0x9761 },
	{ 0xD5B3,  0x976B },
	{ 0xD5B4,  0x9746 },
	{ 0xD5B5,  0x9747 },
	{ 0xD5B6,  0x9778 },
	{ 0xD5B7,  0x9776 },
	{ 0xD5B8,  0x97F9 },
	{ 0xD5B9,  0x9748 },
	{ 0xD5BA,  0x9771 },
	{ 0xD5BB,  0x9777 },
	{ 0xD5BC,  0x9774 },
	{ 0xD5BD,  0x974D },
	{ 0xD5BE,  0xE8F5 },
	{ 0xD5BF,  0x977A },
	{ 0xD5C0,  0xE8F4 },
	{ 0xD5C1,  0xE8F6 },
	{ 0xD5C2,  0x9763 },
	{ 0xD5C3,  0x9752 },
	{ 0xD5C4,  0xE8F8 },
	{ 0xD5C5,  0x974B },
	{ 0xD5C6,  0x9775 },
	{ 0xD5C7,  0x9756 },
	{ 0xD5C8,  0x974A },
	{ 0xD5C9,  0x9754 },
	{ 0xD5CA,  0x976A },
	{ 0xD5CB,  0x9766 },
	{ 0xD5CC,  0x975D },
	{ 0xD5CD,  0x976F },
	{ 0xD5CE,  0x975B },
	{ 0xD5CF,  0x9772 },
	{ 0xD5D0,  0x974E },
	{ 0xD5D1,  0x9751 },
	{ 0xD5D2,  0x9762 },
	{ 0xD5D3,  0x975E },
	{ 0xD5D4,  0x975C },
	{ 0xD5D5,  0x9753 },
	{ 0xD5D6,  0x9A46 },
	{ 0xD5D7,  0x9A43 },
	{ 0xD5D8,  0xECA4 },
	{ 0xD5D9,  0x9A47 },
	{ 0xD5DA,  0x9A84 },
	{ 0xD5DB,  0x9A82 },
	{ 0xD5DC,  0xE9E8 },
	{ 0xD5DD,  0x9A81 },
	{ 0xD5DE,  0x9A80 },
	{ 0xD5DF,  0xEBB4 },
	{ 0xD5E0,  0xB5ED },
	{ 0xD5E1,  0xE4CA },
	{ 0xD5E2,  0x9BF0 },
	{ 0xD5E3,  0x9BEF },
	{ 0xD5E4,  0x9CB0 },
	{ 0xD5E5,  0x9BEB },
	{ 0xD5E6,  0x9C52 },
	{ 0xD5E7,  0x9C4D },
	{ 0xD5E8,  0x9BF2 },
	{ 0xD5E9,  0x9C5A },
	{ 0xD5EA,  0x9C46 },
	{ 0xD5EB,  0x9C60 },
	{ 0xD5EC,  0x9BFC },
	{ 0xD5ED,  0xE4C4 },
	{ 0xD5EE,  0x9C4C },
	{ 0xD5EF,  0xC4D7 },
	{ 0xD5F0,  0x9BF8 },
	{ 0xD5F1,  0x9C4F },
	{ 0xD5F2,  0x9C4B },
	{ 0xD5F3,  0xE4C7 },
	{ 0xD5F4,  0x9C4A },
	{ 0xD5F5,  0x9C58 },
	{ 0xD5F6,  0x9BFE },
	{ 0xD5F7,  0x9BF7 },
	{ 0xD5F8,  0x9C54 },
	{ 0xD5F9,  0x9C56 },
	{ 0xD5FA,  0x9BF4 },
	{ 0xD5FB,  0x9C47 },
	{ 0xD5FC,  0x9BFA },
	{ 0xD5FD,  0x9C42 },
	{ 0xD5FE,  0x9BFD },
	{ 0xD640,  0x9C43 },
	{ 0xD641,  0x9C57 },
	{ 0xD642,  0x9C45 },
	{ 0xD643,  0x9C5D },
	{ 0xD644,  0x9C48 },
	{ 0xD645,  0x9C40 },
	{ 0xD646,  0x9C4E },
	{ 0xD647,  0x9BF5 },
	{ 0xD648,  0x9F52 },
	{ 0xD649,  0x9F62 },
	{ 0xD64A,  0xCDE9 },
	{ 0xD64B,  0x9F68 },
	{ 0xD64C,  0x9F4E },
	{ 0xD64D,  0x9F61 },
	{ 0xD64E,  0x9F4A },
	{ 0xD64F,  0x9F5B },
	{ 0xD650,  0x9F4D },
	{ 0xD651,  0xECC9 },
	{ 0xD652,  0x9F54 },
	{ 0xD653,  0x9F56 },
	{ 0xD654,  0x9F5D },
	{ 0xD655,  0xECCA },
	{ 0xD656,  0x9F57 },
	{ 0xD657,  0x9F51 },
	{ 0xD658,  0x9F50 },
	{ 0xD659,  0x9F60 },
	{ 0xD65A,  0x9F59 },
	{ 0xD65B,  0x9F63 },
	{ 0xD65C,  0xEAF5 },
	{ 0xD65D,  0xA0BD },
	{ 0xD65E,  0xA0BE },
	{ 0xD65F,  0xEAF6 },
	{ 0xD660,  0xE2A7 },
	{ 0xD661,  0xE2A2 },
	{ 0xD662,  0xAA56 },
	{ 0xD663,  0xAA5E },
	{ 0xD664,  0xAA61 },
	{ 0xD665,  0xE2A5 },
	{ 0xD666,  0xAA57 },
	{ 0xD667,  0xAA50 },
	{ 0xD668,  0xAA5C },
	{ 0xD669,  0xE2A6 },
	{ 0xD66A,  0xAB53 },
	{ 0xD66B,  0xAB9F },
	{ 0xD66C,  0xAC40 },
	{ 0xD66D,  0xAB9E },
	{ 0xD66E,  0xAC4B },
	{ 0xD66F,  0xAC49 },
	{ 0xD670,  0xAC45 },
	{ 0xD671,  0xAC4C },
	{ 0xD672,  0xAC48 },
	{ 0xD673,  0xAC42 },
	{ 0xD674,  0xAC44 },
	{ 0xD675,  0xAC47 },
	{ 0xD676,  0xAC4F },
	{ 0xD677,  0xAC4E },
	{ 0xD678,  0xAB9D },
	{ 0xD679,  0xAC4D },
	{ 0xD67A,  0xAE87 },
	{ 0xD67B,  0xAE86 },
	{ 0xD67C,  0xAF5E },
	{ 0xD67D,  0xD1F7 },
	{ 0xD67E,  0xAF5F },
	{ 0xD6A1,  0xAF5C },
	{ 0xD6A2,  0xAF5D },
	{ 0xD6A3,  0xAF61 },
	{ 0xD6A4,  0xAF60 },
	{ 0xD6A5,  0xB076 },
	{ 0xD6A6,  0xB072 },
	{ 0xD6A7,  0xB145 },
	{ 0xD6A8,  0xB187 },
	{ 0xD6A9,  0xC3D0 },
	{ 0xD6AA,  0xEDF5 },
	{ 0xD6AB,  0xB183 },
	{ 0xD6AC,  0xB184 },
	{ 0xD6AD,  0xB186 },
	{ 0xD6AE,  0xB185 },
	{ 0xD6AF,  0xB189 },
	{ 0xD6B0,  0xB17B },
	{ 0xD6B1,  0xB188 },
	{ 0xD6B2,  0xEDF7 },
	{ 0xD6B3,  0xB373 },
	{ 0xD6B4,  0xCEF8 },
	{ 0xD6B5,  0xB374 },
	{ 0xD6B6,  0xB377 },
	{ 0xD6B7,  0xB375 },
	{ 0xD6B8,  0xEDD1 },
	{ 0xD6B9,  0xEDCE },
	{ 0xD6BA,  0xB9E8 },
	{ 0xD6BB,  0xEDCF },
	{ 0xD6BC,  0xB580 },
	{ 0xD6BD,  0xECF6 },
	{ 0xD6BE,  0xB582 },
	{ 0xD6BF,  0xB583 },
	{ 0xD6C0,  0xB57E },
	{ 0xD6C1,  0xB584 },
	{ 0xD6C2,  0xB57D },
	{ 0xD6C3,  0xC0EB },
	{ 0xD6C4,  0xB68A },
	{ 0xD6C5,  0xBDD5 },
	{ 0xD6C6,  0xB687 },
	{ 0xD6C7,  0xB688 },
	{ 0xD6C8,  0xB797 },
	{ 0xD6C9,  0xB79A },
	{ 0xD6CA,  0xB798 },
	{ 0xD6CB,  0xB944 },
	{ 0xD6CC,  0xF3CC },
	{ 0xD6CD,  0xB943 },
	{ 0xD6CE,  0xF3D3 },
	{ 0xD6CF,  0xB941 },
	{ 0xD6D0,  0xB89C },
	{ 0xD6D1,  0xF3D4 },
	{ 0xD6D2,  0xF3D5 },
	{ 0xD6D3,  0xB896 },
	{ 0xD6D4,  0xF3CE },
	{ 0xD6D5,  0xB899 },
	{ 0xD6D6,  0xF3D1 },
	{ 0xD6D7,  0xF3CA },
	{ 0xD6D8,  0xB8A0 },
	{ 0xD6D9,  0xB940 },
	{ 0xD6DA,  0xB942 },
	{ 0xD6DB,  0xF3CD },
	{ 0xD6DC,  0xB897 },
	{ 0xD6DD,  0xB89D },
	{ 0xD6DE,  0xBB89 },
	{ 0xD6DF,  0xD5B3 },
	{ 0xD6E0,  0xBB8A },
	{ 0xD6E1,  0xBB90 },
	{ 0xD6E2,  0xBC9F },
	{ 0xD6E3,  0xBD46 },
	{ 0xD6E4,  0xBD41 },
	{ 0xD6E5,  0xBCA0 },
	{ 0xD6E6,  0xBD43 },
	{ 0xD6E7,  0xBD4E },
	{ 0xD6E8,  0xBC97 },
	{ 0xD6E9,  0xBC95 },
	{ 0xD6EA,  0xBD4A },
	{ 0xD6EB,  0xBD50 },
	{ 0xD6EC,  0xBD47 },
	{ 0xD6ED,  0xBD48 },
	{ 0xD6EE,  0xBD53 },
	{ 0xD6EF,  0xBD44 },
	{ 0xD6F0,  0xBC94 },
	{ 0xD6F1,  0xC147 },
	{ 0xD6F2,  0xC16B },
	{ 0xD6F3,  0xC171 },
	{ 0xD6F4,  0xF4C6 },
	{ 0xD6F5,  0xC170 },
	{ 0xD6F6,  0xF1B4 },
	{ 0xD6F7,  0xC190 },
	{ 0xD6F8,  0xC191 },
	{ 0xD6F9,  0xC193 },
	{ 0xD6FA,  0xC194 },
	{ 0xD6FB,  0xC18D },
	{ 0xD6FC,  0xC192 },
	{ 0xD6FD,  0xC18F },
	{ 0xD6FE,  0xC260 },
	{ 0xD740,  0xC25F },
	{ 0xD741,  0xC25D },
	{ 0xD742,  0xC274 },
	{ 0xD743,  0xF1F5 },
	{ 0xD744,  0xC275 },
	{ 0xD745,  0xEBE4 },
	{ 0xD746,  0xC38D },
	{ 0xD747,  0xC383 },
	{ 0xD748,  0xC384 },
	{ 0xD749,  0xC394 },
	{ 0xD74A,  0xC387 },
	{ 0xD74B,  0xEBE3 },
	{ 0xD74C,  0xEBE2 },
	{ 0xD74D,  0xC389 },
	{ 0xD74E,  0xC381 },
	{ 0xD74F,  0xC38F },
	{ 0xD750,  0xC386 },
	{ 0xD751,  0xC38A },
	{ 0xD752,  0xC56A },
	{ 0xD753,  0xF4B4 },
	{ 0xD754,  0xF4B6 },
	{ 0xD755,  0xC57B },
	{ 0xD756,  0xF4B7 },
	{ 0xD757,  0xC57A },
	{ 0xD758,  0xE5F5 },
	{ 0xD759,  0xC76B },
	{ 0xD75A,  0xC777 },
	{ 0xD75B,  0xDDB9 },
	{ 0xD75C,  0xC769 },
	{ 0xD75D,  0xC75C },
	{ 0xD75E,  0xC757 },
	{ 0xD75F,  0xC778 },
	{ 0xD760,  0xC758 },
	{ 0xD761,  0xC76A },
	{ 0xD762,  0xC760 },
	{ 0xD763,  0xC76E },
	{ 0xD764,  0xC771 },
	{ 0xD765,  0xC759 },
	{ 0xD766,  0xC76D },
	{ 0xD767,  0xDDB3 },
	{ 0xD768,  0xDDB4 },
	{ 0xD769,  0xC762 },
	{ 0xD76A,  0xC768 },
	{ 0xD76B,  0xC773 },
	{ 0xD76C,  0xDCF0 },
	{ 0xD76D,  0xDDAD },
	{ 0xD76E,  0xC767 },
	{ 0xD76F,  0xC75D },
	{ 0xD770,  0xC779 },
	{ 0xD771,  0xC780 },
	{ 0xD772,  0xC765 },
	{ 0xD773,  0xC770 },
	{ 0xD774,  0xDDA8 },
	{ 0xD775,  0xC75E },
	{ 0xD776,  0xC77A },
	{ 0xD777,  0xC764 },
	{ 0xD778,  0xC77E },
	{ 0xD779,  0xC75A },
	{ 0xD77A,  0xC772 },
	{ 0xD77B,  0xCC92 },
	{ 0xD77C,  0xCC8F },
	{ 0xD77D,  0xCD70 },
	{ 0xD77E,  0xCD69 },
	{ 0xD7A1,  0xCD72 },
	{ 0xD7A2,  0xCD71 },
	{ 0xD7A3,  0xCD74 },
	{ 0xD7A4,  0xF2C5 },
	{ 0xD7A5,  0xF2C4 },
	{ 0xD7A6,  0xCD75 },
	{ 0xD7A7,  0xCD6B },
	{ 0xD7A8,  0xCD68 },
	{ 0xD7A9,  0xCD6A },
	{ 0xD7AA,  0xCD76 },
	{ 0xD7AB,  0xF2CA },
	{ 0xD7AC,  0xCD6C },
	{ 0xD7AD,  0xCD6D },
	{ 0xD7AE,  0xCD73 },
	{ 0xD7AF,  0xCD6E },
	{ 0xD7B0,  0xCD6F },
	{ 0xD7B1,  0xD066 },
	{ 0xD7B2,  0xD086 },
	{ 0xD7B3,  0xD08F },
	{ 0xD7B4,  0xD09E },
	{ 0xD7B5,  0xF1C8 },
	{ 0xD7B6,  0xD0A0 },
	{ 0xD7B7,  0xD093 },
	{ 0xD7B8,  0xD08C },
	{ 0xD7B9,  0xD099 },
	{ 0xD7BA,  0xD097 },
	{ 0xD7BB,  0xD091 },
	{ 0xD7BC,  0xD09D },
	{ 0xD7BD,  0xD092 },
	{ 0xD7BE,  0xD094 },
	{ 0xD7BF,  0xD090 },
	{ 0xD7C0,  0xD9F3 },
	{ 0xD7C1,  0xD140 },
	{ 0xD7C2,  0xD088 },
	{ 0xD7C3,  0xD08D },
	{ 0xD7C4,  0xD089 },
	{ 0xD7C5,  0xD283 },
	{ 0xD7C6,  0xF5FB },
	{ 0xD7C7,  0xD366 },
	{ 0xD7C8,  0xD363 },
	{ 0xD7C9,  0xD452 },
	{ 0xD7CA,  0xD449 },
	{ 0xD7CB,  0xD44E },
	{ 0xD7CC,  0xD440 },
	{ 0xD7CD,  0xD841 },
	{ 0xD7CE,  0xD843 },
	{ 0xD7CF,  0xD85D },
	{ 0xD7D0,  0xD85E },
	{ 0xD7D1,  0xD876 },
	{ 0xD7D2,  0xD898 },
	{ 0xD7D3,  0xDA62 },
	{ 0xD7D4,  0xDA60 },
	{ 0xD7D5,  0xDA5E },
	{ 0xD7D6,  0xF5C2 },
	{ 0xD7D7,  0xDA96 },
	{ 0xD7D8,  0xDA91 },
	{ 0xD7D9,  0xF5C1 },
	{ 0xD7DA,  0xDA95 },
	{ 0xD7DB,  0xDC94 },
	{ 0xD7DC,  0xDC9A },
	{ 0xD7DD,  0xDC99 },
	{ 0xD7DE,  0xDC98 },
	{ 0xD7DF,  0xDC93 },
	{ 0xD7E0,  0xDC9C },
	{ 0xD7E1,  0xDC9D },
	{ 0xD7E2,  0xDF43 },
	{ 0xD7E3,  0xE5CD },
	{ 0xD7E4,  0xE5CF },
	{ 0xD7E5,  0xDF41 },
	{ 0xD7E6,  0xDE9C },
	{ 0xD7E7,  0xE5D2 },
	{ 0xD7E8,  0xDBB0 },
	{ 0xD7E9,  0xE056 },
	{ 0xD7EA,  0xE059 },
	{ 0xD7EB,  0xB3BB },
	{ 0xD7EC,  0xE05B },
	{ 0xD7ED,  0xE05C },
	{ 0xD7EE,  0xE049 },
	{ 0xD7EF,  0xDBAF },
	{ 0xD7F0,  0xE057 },
	{ 0xD7F1,  0xE055 },
	{ 0xD7F2,  0xE147 },
	{ 0xD7F3,  0xE148 },
	{ 0xD7F4,  0xB7D3 },
	{ 0xD7F5,  0xE144 },
	{ 0xD7F6,  0xE146 },
	{ 0xD7F7,  0xE246 },
	{ 0xD7F8,  0xE24E },
	{ 0xD7F9,  0xE24B },
	{ 0xD7FA,  0xE24D },
	{ 0xD7FB,  0xE252 },
	{ 0xD7FC,  0xE19F },
	{ 0xD7FD,  0xE253 },
	{ 0xD7FE,  0xE244 },
	{ 0xD840,  0xE245 },
	{ 0xD841,  0xE251 },
	{ 0xD842,  0xE242 },
	{ 0xD843,  0xE248 },
	{ 0xD844,  0xE94F },
	{ 0xD845,  0xE95A },
	{ 0xD846,  0xE95C },
	{ 0xD847,  0xEA95 },
	{ 0xD848,  0xEA8B },
	{ 0xD849,  0xEA8A },
	{ 0xD84A,  0xEA8F },
	{ 0xD84B,  0xEA8D },
	{ 0xD84C,  0xEB63 },
	{ 0xD84D,  0xEC77 },
	{ 0xD84E,  0xED96 },
	{ 0xD84F,  0xEF80 },
	{ 0xD850,  0xD8B8 },
	{ 0xD851,  0x82E6 },
	{ 0xD852,  0x82E0 },
	{ 0xD853,  0x82DF },
	{ 0xD854,  0x82E9 },
	{ 0xD855,  0x82D7 },
	{ 0xD856,  0xB4F6 },
	{ 0xD857,  0x82D1 },
	{ 0xD858,  0x82D8 },
	{ 0xD859,  0x82D9 },
	{ 0xD85A,  0x82E8 },
	{ 0xD85B,  0x82BD },
	{ 0xD85C,  0x82E7 },
	{ 0xD85D,  0x82DD },
	{ 0xD85E,  0x82D0 },
	{ 0xD85F,  0x82D4 },
	{ 0xD860,  0x83C2 },
	{ 0xD861,  0x83FB },
	{ 0xD862,  0x8541 },
	{ 0xD863,  0x8540 },
	{ 0xD864,  0x858D },
	{ 0xD865,  0x858E },
	{ 0xD866,  0xE0B3 },
	{ 0xD867,  0x86C8 },
	{ 0xD868,  0x86C6 },
	{ 0xD869,  0x86CD },
	{ 0xD86A,  0xE0A5 },
	{ 0xD86B,  0x876A },
	{ 0xD86C,  0x86C3 },
	{ 0xD86D,  0x86BA },
	{ 0xD86E,  0xE0AE },
	{ 0xD86F,  0xDFF6 },
	{ 0xD870,  0xDFF7 },
	{ 0xD871,  0xE0AF },
	{ 0xD872,  0x86C4 },
	{ 0xD873,  0x86B9 },
	{ 0xD874,  0x86C5 },
	{ 0xD875,  0x86B1 },
	{ 0xD876,  0x86B5 },
	{ 0xD877,  0x86C7 },
	{ 0xD878,  0x86B2 },
	{ 0xD879,  0x86BB },
	{ 0xD87A,  0x86C2 },
	{ 0xD87B,  0x86B7 },
	{ 0xD87C,  0x87F9 },
	{ 0xD87D,  0x88ED },
	{ 0xD87E,  0x88F8 },
	{ 0xD8A1,  0xDCA7 },
	{ 0xD8A2,  0xDCA6 },
	{ 0xD8A3,  0x88EB },
	{ 0xD8A4,  0x88E8 },
	{ 0xD8A5,  0x88EC },
	{ 0xD8A6,  0x88CA },
	{ 0xD8A7,  0x8949 },
	{ 0xD8A8,  0x88E9 },
	{ 0xD8A9,  0x88E4 },
	{ 0xD8AA,  0x88E3 },
	{ 0xD8AB,  0x88F5 },
	{ 0xD8AC,  0x8941 },
	{ 0xD8AD,  0x88F7 },
	{ 0xD8AE,  0x88F1 },
	{ 0xD8AF,  0x88FA },
	{ 0xD8B0,  0x88F9 },
	{ 0xD8B1,  0x88F0 },
	{ 0xD8B2,  0x88EF },
	{ 0xD8B3,  0x88FC },
	{ 0xD8B4,  0x8A53 },
	{ 0xD8B5,  0x8B82 },
	{ 0xD8B6,  0x8B69 },
	{ 0xD8B7,  0x8B72 },
	{ 0xD8B8,  0xE6C4 },
	{ 0xD8B9,  0x8B75 },
	{ 0xD8BA,  0x8B71 },
	{ 0xD8BB,  0x8B50 },
	{ 0xD8BC,  0x8B79 },
	{ 0xD8BD,  0x8B53 },
	{ 0xD8BE,  0x8B78 },
	{ 0xD8BF,  0x8B7E },
	{ 0xD8C0,  0x8B6A },
	{ 0xD8C1,  0x8B81 },
	{ 0xD8C2,  0x8ADC },
	{ 0xD8C3,  0x8B5A },
	{ 0xD8C4,  0x8B60 },
	{ 0xD8C5,  0x8B6C },
	{ 0xD8C6,  0x8B59 },
	{ 0xD8C7,  0x8B61 },
	{ 0xD8C8,  0x8B7C },
	{ 0xD8C9,  0x8B52 },
	{ 0xD8CA,  0x8B54 },
	{ 0xD8CB,  0x8B62 },
	{ 0xD8CC,  0x8B6F },
	{ 0xD8CD,  0x8B65 },
	{ 0xD8CE,  0x8B68 },
	{ 0xD8CF,  0x8B70 },
	{ 0xD8D0,  0x8C90 },
	{ 0xD8D1,  0x8C7C },
	{ 0xD8D2,  0x8C7B },
	{ 0xD8D3,  0x8C81 },
	{ 0xD8D4,  0x8C80 },
	{ 0xD8D5,  0x8C7A },
	{ 0xD8D6,  0x8C7D },
	{ 0xD8D7,  0x8CA5 },
	{ 0xD8D8,  0x8CBB },
	{ 0xD8D9,  0x8DA6 },
	{ 0xD8DA,  0x8DB0 },
	{ 0xD8DB,  0xE1D1 },
	{ 0xD8DC,  0x8DAE },
	{ 0xD8DD,  0xE1D2 },
	{ 0xD8DE,  0x8DAC },
	{ 0xD8DF,  0x8DA4 },
	{ 0xD8E0,  0x8DBA },
	{ 0xD8E1,  0x8DB7 },
	{ 0xD8E2,  0x8DBE },
	{ 0xD8E3,  0x8DA3 },
	{ 0xD8E4,  0x8DA9 },
	{ 0xD8E5,  0x8DBB },
	{ 0xD8E6,  0xE1CC },
	{ 0xD8E7,  0x8DA1 },
	{ 0xD8E8,  0x8DC1 },
	{ 0xD8E9,  0x8DAF },
	{ 0xD8EA,  0x8DA8 },
	{ 0xD8EB,  0x8DB5 },
	{ 0xD8EC,  0x8DA7 },
	{ 0xD8ED,  0x8DAB },
	{ 0xD8EE,  0x8DA2 },
	{ 0xD8EF,  0x8DA5 },
	{ 0xD8F0,  0x8DAD },
	{ 0xD8F1,  0x8DB2 },
	{ 0xD8F2,  0xE1A2 },
	{ 0xD8F3,  0x8EAD },
	{ 0xD8F4,  0xE5E9 },
	{ 0xD8F5,  0x8FCB },
	{ 0xD8F6,  0x8FCA },
	{ 0xD8F7,  0x8FCE },
	{ 0xD8F8,  0x90AC },
	{ 0xD8F9,  0x90A0 },
	{ 0xD8FA,  0x90AD },
	{ 0xD8FB,  0x90BB },
	{ 0xD8FC,  0x90AF },
	{ 0xD8FD,  0x90A9 },
	{ 0xD8FE,  0x90D6 },
	{ 0xD940,  0x90C1 },
	{ 0xD941,  0x90CF },
	{ 0xD942,  0x90D7 },
	{ 0xD943,  0x90CD },
	{ 0xD944,  0x90C2 },
	{ 0xD945,  0x90D5 },
	{ 0xD946,  0x90C4 },
	{ 0xD947,  0x90C6 },
	{ 0xD948,  0x90C8 },
	{ 0xD949,  0x90A6 },
	{ 0xD94A,  0x90CB },
	{ 0xD94B,  0x90D9 },
	{ 0xD94C,  0x90DD },
	{ 0xD94D,  0x90D2 },
	{ 0xD94E,  0x90C9 },
	{ 0xD94F,  0x90CC },
	{ 0xD950,  0x90D0 },
	{ 0xD951,  0x91FE },
	{ 0xD952,  0x92E7 },
	{ 0xD953,  0x92F6 },
	{ 0xD954,  0xEAFE },
	{ 0xD955,  0xDEEF },
	{ 0xD956,  0x9357 },
	{ 0xD957,  0x935A },
	{ 0xD958,  0x935E },
	{ 0xD959,  0x9342 },
	{ 0xD95A,  0x93D6 },
	{ 0xD95B,  0x9361 },
	{ 0xD95C,  0x9346 },
	{ 0xD95D,  0xDEEB },
	{ 0xD95E,  0xDEDE },
	{ 0xD95F,  0x934C },
	{ 0xD960,  0xDEE9 },
	{ 0xD961,  0x9362 },
	{ 0xD962,  0x93A9 },
	{ 0xD963,  0x9354 },
	{ 0xD964,  0xDEF2 },
	{ 0xD965,  0x9353 },
	{ 0xD966,  0x9352 },
	{ 0xD967,  0xDEED },
	{ 0xD968,  0x934E },
	{ 0xD969,  0x934A },
	{ 0xD96A,  0x9341 },
	{ 0xD96B,  0x9344 },
	{ 0xD96C,  0x9348 },
	{ 0xD96D,  0x9347 },
	{ 0xD96E,  0x9345 },
	{ 0xD96F,  0x935F },
	{ 0xD970,  0x934D },
	{ 0xD971,  0x934F },
	{ 0xD972,  0x948C },
	{ 0xD973,  0x94AA },
	{ 0xD974,  0x94AD },
	{ 0xD975,  0x94A8 },
	{ 0xD976,  0x94A4 },
	{ 0xD977,  0x94AB },
	{ 0xD978,  0x94A9 },
	{ 0xD979,  0xB1F3 },
	{ 0xD97A,  0x94D0 },
	{ 0xD97B,  0x94D1 },
	{ 0xD97C,  0x94D9 },
	{ 0xD97D,  0x94ED },
	{ 0xD97E,  0xECBC },
	{ 0xD9A1,  0x9596 },
	{ 0xD9A2,  0x958D },
	{ 0xD9A3,  0x9595 },
	{ 0xD9A4,  0x9599 },
	{ 0xD9A5,  0x958F },
	{ 0xD9A6,  0x9594 },
	{ 0xD9A7,  0x958B },
	{ 0xD9A8,  0x9590 },
	{ 0xD9A9,  0x95FC },
	{ 0xD9AA,  0x97BE },
	{ 0xD9AB,  0x9794 },
	{ 0xD9AC,  0x97B8 },
	{ 0xD9AD,  0x979A },
	{ 0xD9AE,  0x97D5 },
	{ 0xD9AF,  0x97A8 },
	{ 0xD9B0,  0x97A6 },
	{ 0xD9B1,  0xC0E2 },
	{ 0xD9B2,  0x97BF },
	{ 0xD9B3,  0x9796 },
	{ 0xD9B4,  0x97AF },
	{ 0xD9B5,  0x97A7 },
	{ 0xD9B6,  0x97A0 },
	{ 0xD9B7,  0x97AE },
	{ 0xD9B8,  0x97C1 },
	{ 0xD9B9,  0xE9A7 },
	{ 0xD9BA,  0x97AC },
	{ 0xD9BB,  0x979E },
	{ 0xD9BC,  0x97BA },
	{ 0xD9BD,  0x978F },
	{ 0xD9BE,  0x97BB },
	{ 0xD9BF,  0x984B },
	{ 0xD9C0,  0x977B },
	{ 0xD9C1,  0x97C0 },
	{ 0xD9C2,  0x97AA },
	{ 0xD9C3,  0x978B },
	{ 0xD9C4,  0x97C2 },
	{ 0xD9C5,  0x97B0 },
	{ 0xD9C6,  0x9792 },
	{ 0xD9C7,  0x97B2 },
	{ 0xD9C8,  0xE8FB },
	{ 0xD9C9,  0x97A4 },
	{ 0xD9CA,  0xE9A3 },
	{ 0xD9CB,  0x97BD },
	{ 0xD9CC,  0x97C5 },
	{ 0xD9CD,  0x9790 },
	{ 0xD9CE,  0x978D },
	{ 0xD9CF,  0x979B },
	{ 0xD9D0,  0x979C },
	{ 0xD9D1,  0x97A2 },
	{ 0xD9D2,  0x97AD },
	{ 0xD9D3,  0x9793 },
	{ 0xD9D4,  0x97B9 },
	{ 0xD9D5,  0x9795 },
	{ 0xD9D6,  0x97A5 },
	{ 0xD9D7,  0x97C3 },
	{ 0xD9D8,  0x97D0 },
	{ 0xD9D9,  0x978C },
	{ 0xD9DA,  0xECA5 },
	{ 0xD9DB,  0x9A48 },
	{ 0xD9DC,  0x9A4B },
	{ 0xD9DD,  0x9A49 },
	{ 0xD9DE,  0x9A85 },
	{ 0xD9DF,  0x9A87 },
	{ 0xD9E0,  0x9A89 },
	{ 0xD9E1,  0x9A86 },
	{ 0xD9E2,  0x9AA5 },
	{ 0xD9E3,  0x9AC5 },
	{ 0xD9E4,  0x9AC7 },
	{ 0xD9E5,  0xEBA5 },
	{ 0xD9E6,  0xC7E8 },
	{ 0xD9E7,  0xEDB5 },
	{ 0xD9E8,  0x9C8C },
	{ 0xD9E9,  0x9C8D },
	{ 0xD9EA,  0x9C73 },
	{ 0xD9EB,  0x9C8F },
	{ 0xD9EC,  0x9CBF },
	{ 0xD9ED,  0x9C84 },
	{ 0xD9EE,  0x9C85 },
	{ 0xD9EF,  0x9C8B },
	{ 0xD9F0,  0x9CA0 },
	{ 0xD9F1,  0xE4CD },
	{ 0xD9F2,  0x9C87 },
	{ 0xD9F3,  0x9C89 },
	{ 0xD9F4,  0x9C9C },
	{ 0xD9F5,  0x9CAF },
	{ 0xD9F6,  0x9C71 },
	{ 0xD9F7,  0x9C7D },
	{ 0xD9F8,  0x9C91 },
	{ 0xD9F9,  0x9C88 },
	{ 0xD9FA,  0x9C95 },
	{ 0xD9FB,  0x9C83 },
	{ 0xD9FC,  0x9C63 },
	{ 0xD9FD,  0x9C7A },
	{ 0xD9FE,  0x9C9D },
	{ 0xDA40,  0x9CA6 },
	{ 0xDA41,  0x9C9B },
	{ 0xDA42,  0x9C9F },
	{ 0xDA43,  0x9C7C },
	{ 0xDA44,  0x9C77 },
	{ 0xDA45,  0x9C9E },
	{ 0xDA46,  0x9CAD },
	{ 0xDA47,  0xE4D0 },
	{ 0xDA48,  0x9C82 },
	{ 0xDA49,  0x9C74 },
	{ 0xDA4A,  0x9C7B },
	{ 0xDA4B,  0xE4D4 },
	{ 0xDA4C,  0x9CA3 },
	{ 0xDA4D,  0x9C76 },
	{ 0xDA4E,  0x9CB4 },
	{ 0xDA4F,  0x9CA2 },
	{ 0xDA50,  0x9CB3 },
	{ 0xDA51,  0x9C97 },
	{ 0xDA52,  0x9CB5 },
	{ 0xDA53,  0x9C96 },
	{ 0xDA54,  0x9CA4 },
	{ 0xDA55,  0x9C7E },
	{ 0xDA56,  0x9C80 },
	{ 0xDA57,  0x9C9A },
	{ 0xDA58,  0x9F6E },
	{ 0xDA59,  0x9F6C },
	{ 0xDA5A,  0xECCC },
	{ 0xDA5B,  0x9F53 },
	{ 0xDA5C,  0x9F7B },
	{ 0xDA5D,  0xECCD },
	{ 0xDA5E,  0x9F71 },
	{ 0xDA5F,  0x9F73 },
	{ 0xDA60,  0x9F70 },
	{ 0xDA61,  0x9F7C },
	{ 0xDA62,  0x9F6D },
	{ 0xDA63,  0x9F75 },
	{ 0xDA64,  0x9F84 },
	{ 0xDA65,  0x9F69 },
	{ 0xDA66,  0xA0A0 },
	{ 0xDA67,  0xA0AA },
	{ 0xDA68,  0xA0C5 },
	{ 0xDA69,  0xA0C6 },
	{ 0xDA6A,  0xA0C3 },
	{ 0xDA6B,  0xA0C2 },
	{ 0xDA6C,  0xEAF8 },
	{ 0xDA6D,  0xAA5F },
	{ 0xDA6E,  0xAA59 },
	{ 0xDA6F,  0xAA6D },
	{ 0xDA70,  0xE2A9 },
	{ 0xDA71,  0xE2AE },
	{ 0xDA72,  0xAA6F },
	{ 0xDA73,  0xAA69 },
	{ 0xDA74,  0xAA6E },
	{ 0xDA75,  0xAA6B },
	{ 0xDA76,  0xAA68 },
	{ 0xDA77,  0xAA66 },
	{ 0xDA78,  0xAA70 },
	{ 0xDA79,  0xAA5A },
	{ 0xDA7A,  0xE7FD },
	{ 0xDA7B,  0xE7FE },
	{ 0xDA7C,  0xE7FC },
	{ 0xDA7D,  0xAC65 },
	{ 0xDA7E,  0xAC57 },
	{ 0xDAA1,  0xE8A2 },
	{ 0xDAA2,  0xAC60 },
	{ 0xDAA3,  0xAC66 },
	{ 0xDAA4,  0xAC68 },
	{ 0xDAA5,  0xAC62 },
	{ 0xDAA6,  0xAC61 },
	{ 0xDAA7,  0xAC5C },
	{ 0xDAA8,  0xAC64 },
	{ 0xDAA9,  0xAC5F },
	{ 0xDAAA,  0xAC69 },
	{ 0xDAAB,  0xAE45 },
	{ 0xDAAC,  0xE5B8 },
	{ 0xDAAD,  0xAE8F },
	{ 0xDAAE,  0xAE8C },
	{ 0xDAAF,  0xF0F0 },
	{ 0xDAB0,  0xAF65 },
	{ 0xDAB1,  0xAF6A },
	{ 0xDAB2,  0xF0ED },
	{ 0xDAB3,  0xAF67 },
	{ 0xDAB4,  0xAF68 },
	{ 0xDAB5,  0xF0EE },
	{ 0xDAB6,  0xAF63 },
	{ 0xDAB7,  0xB07A },
	{ 0xDAB8,  0xB078 },
	{ 0xDAB9,  0xB148 },
	{ 0xDABA,  0xB18F },
	{ 0xDABB,  0xEDFB },
	{ 0xDABC,  0xB18D },
	{ 0xDABD,  0xB195 },
	{ 0xDABE,  0xB18E },
	{ 0xDABF,  0xB192 },
	{ 0xDAC0,  0xB196 },
	{ 0xDAC1,  0xB193 },
	{ 0xDAC2,  0xB194 },
	{ 0xDAC3,  0xB29C },
	{ 0xDAC4,  0xEFF3 },
	{ 0xDAC5,  0xB384 },
	{ 0xDAC6,  0xB388 },
	{ 0xDAC7,  0xB389 },
	{ 0xDAC8,  0xB381 },
	{ 0xDAC9,  0xEDCB },
	{ 0xDACA,  0xB390 },
	{ 0xDACB,  0xEDD2 },
	{ 0xDACC,  0xC8B7 },
	{ 0xDACD,  0xB38F },
	{ 0xDACE,  0xB38D },
	{ 0xDACF,  0xB38C },
	{ 0xDAD0,  0xB382 },
	{ 0xDAD1,  0xB386 },
	{ 0xDAD2,  0xB58B },
	{ 0xDAD3,  0xB58A },
	{ 0xDAD4,  0xB589 },
	{ 0xDAD5,  0xB587 },
	{ 0xDAD6,  0xEFFC },
	{ 0xDAD7,  0xB694 },
	{ 0xDAD8,  0xEFFB },
	{ 0xDAD9,  0xB695 },
	{ 0xDADA,  0xB68F },
	{ 0xDADB,  0xB79B },
	{ 0xDADC,  0xF1B5 },
	{ 0xDADD,  0xB873 },
	{ 0xDADE,  0xB952 },
	{ 0xDADF,  0xB948 },
	{ 0xDAE0,  0xB94F },
	{ 0xDAE1,  0xB951 },
	{ 0xDAE2,  0xF3DC },
	{ 0xDAE3,  0xB954 },
	{ 0xDAE4,  0xB94B },
	{ 0xDAE5,  0xF3D8 },
	{ 0xDAE6,  0xF3DA },
	{ 0xDAE7,  0xF4D2 },
	{ 0xDAE8,  0xF4D1 },
	{ 0xDAE9,  0xBB93 },
	{ 0xDAEA,  0xBB8F },
	{ 0xDAEB,  0xBD61 },
	{ 0xDAEC,  0xBD77 },
	{ 0xDAED,  0xBD6C },
	{ 0xDAEE,  0xBD5C },
	{ 0xDAEF,  0xBD5F },
	{ 0xDAF0,  0xBD70 },
	{ 0xDAF1,  0xBD73 },
	{ 0xDAF2,  0xBD58 },
	{ 0xDAF3,  0xBD76 },
	{ 0xDAF4,  0xBD65 },
	{ 0xDAF5,  0xBD74 },
	{ 0xDAF6,  0xBD5B },
	{ 0xDAF7,  0xBD5D },
	{ 0xDAF8,  0xBD72 },
	{ 0xDAF9,  0xBD5A },
	{ 0xDAFA,  0xBD68 },
	{ 0xDAFB,  0xBD57 },
	{ 0xDAFC,  0xC090 },
	{ 0xDAFD,  0xC091 },
	{ 0xDAFE,  0xC149 },
	{ 0xDB40,  0xC14A },
	{ 0xDB41,  0xC173 },
	{ 0xDB42,  0xC172 },
	{ 0xDB43,  0xCFDB },
	{ 0xDB44,  0xC198 },
	{ 0xDB45,  0xC27A },
	{ 0xDB46,  0xC278 },
	{ 0xDB47,  0xC279 },
	{ 0xDB48,  0xC375 },
	{ 0xDB49,  0xC368 },
	{ 0xDB4A,  0xC443 },
	{ 0xDB4B,  0xC0B0 },
	{ 0xDB4C,  0xC44B },
	{ 0xDB4D,  0xC44A },
	{ 0xDB4E,  0xC446 },
	{ 0xDB4F,  0xC39F },
	{ 0xDB50,  0xC448 },
	{ 0xDB51,  0xC39C },
	{ 0xDB52,  0xC551 },
	{ 0xDB53,  0xC555 },
	{ 0xDB54,  0xC55C },
	{ 0xDB55,  0xC55D },
	{ 0xDB56,  0xC55E },
	{ 0xDB57,  0xF4AA },
	{ 0xDB58,  0xC57C },
	{ 0xDB59,  0xC57D },
	{ 0xDB5A,  0xC57E },
	{ 0xDB5B,  0xC645 },
	{ 0xDB5C,  0xC69F },
	{ 0xDB5D,  0xBACA },
	{ 0xDB5E,  0xDDCF },
	{ 0xDB5F,  0xC862 },
	{ 0xDB60,  0xDDD2 },
	{ 0xDB61,  0xC79D },
	{ 0xDB62,  0xC854 },
	{ 0xDB63,  0xC79C },
	{ 0xDB64,  0xC79A },
	{ 0xDB65,  0xC849 },
	{ 0xDB66,  0xC845 },
	{ 0xDB67,  0xC853 },
	{ 0xDB68,  0xC788 },
	{ 0xDB69,  0xC789 },
	{ 0xDB6A,  0xC79E },
	{ 0xDB6B,  0xC799 },
	{ 0xDB6C,  0xC784 },
	{ 0xDB6D,  0xDDBD },
	{ 0xDB6E,  0xDDC3 },
	{ 0xDB6F,  0xDDBE },
	{ 0xDB70,  0xDDBF },
	{ 0xDB71,  0xC84B },
	{ 0xDB72,  0xDDD5 },
	{ 0xDB73,  0xC78B },
	{ 0xDB74,  0xC78D },
	{ 0xDB75,  0xDDC5 },
	{ 0xDB76,  0xC844 },
	{ 0xDB77,  0xC78A },
	{ 0xDB78,  0xC851 },
	{ 0xDB79,  0xDDCC },
	{ 0xDB7A,  0xC797 },
	{ 0xDB7B,  0xDDC8 },
	{ 0xDB7C,  0xDDC9 },
	{ 0xDB7D,  0xC785 },
	{ 0xDB7E,  0xC842 },
	{ 0xDBA1,  0xC792 },
	{ 0xDBA2,  0xC847 },
	{ 0xDBA3,  0xB9BD },
	{ 0xDBA4,  0xC78F },
	{ 0xDBA5,  0xDDD0 },
	{ 0xDBA6,  0xC855 },
	{ 0xDBA7,  0xC786 },
	{ 0xDBA8,  0xC79F },
	{ 0xDBA9,  0xC840 },
	{ 0xDBAA,  0xC787 },
	{ 0xDBAB,  0xC848 },
	{ 0xDBAC,  0xC793 },
	{ 0xDBAD,  0xC798 },
	{ 0xDBAE,  0xC85C },
	{ 0xDBAF,  0xC796 },
	{ 0xDBB0,  0xC84A },
	{ 0xDBB1,  0xF2D5 },
	{ 0xDBB2,  0xCD83 },
	{ 0xDBB3,  0xCD86 },
	{ 0xDBB4,  0xCD79 },
	{ 0xDBB5,  0xCD84 },
	{ 0xDBB6,  0xCD7D },
	{ 0xDBB7,  0xCD89 },
	{ 0xDBB8,  0xCD80 },
	{ 0xDBB9,  0xCD8A },
	{ 0xDBBA,  0xCD7E },
	{ 0xDBBB,  0xCD8B },
	{ 0xDBBC,  0xF2CB },
	{ 0xDBBD,  0xCD7C },
	{ 0xDBBE,  0xCD88 },
	{ 0xDBBF,  0xF2D6 },
	{ 0xDBC0,  0xD05E },
	{ 0xDBC1,  0xD069 },
	{ 0xDBC2,  0xD068 },
	{ 0xDBC3,  0xD14B },
	{ 0xDBC4,  0xD15E },
	{ 0xDBC5,  0xD14A },
	{ 0xDBC6,  0xD149 },
	{ 0xDBC7,  0xD150 },
	{ 0xDBC8,  0xD14E },
	{ 0xDBC9,  0xD148 },
	{ 0xDBCA,  0xF1CB },
	{ 0xDBCB,  0xF1CA },
	{ 0xDBCC,  0xD14D },
	{ 0xDBCD,  0xD144 },
	{ 0xDBCE,  0xD178 },
	{ 0xDBCF,  0xF1CC },
	{ 0xDBD0,  0xD294 },
	{ 0xDBD1,  0xD297 },
	{ 0xDBD2,  0xD296 },
	{ 0xDBD3,  0xD368 },
	{ 0xDBD4,  0xF5FD },
	{ 0xDBD5,  0xD367 },
	{ 0xDBD6,  0xD46E },
	{ 0xDBD7,  0xD46D },
	{ 0xDBD8,  0xD45B },
	{ 0xDBD9,  0xD479 },
	{ 0xDBDA,  0xD461 },
	{ 0xDBDB,  0xD477 },
	{ 0xDBDC,  0xD478 },
	{ 0xDBDD,  0xD465 },
	{ 0xDBDE,  0xD466 },
	{ 0xDBDF,  0xD472 },
	{ 0xDBE0,  0xEEBA },
	{ 0xDBE1,  0xD471 },
	{ 0xDBE2,  0xD46A },
	{ 0xDBE3,  0xD46C },
	{ 0xDBE4,  0xD46F },
	{ 0xDBE5,  0xD860 },
	{ 0xDBE6,  0xD87A },
	{ 0xDBE7,  0xD879 },
	{ 0xDBE8,  0xD94C },
	{ 0xDBE9,  0xD950 },
	{ 0xDBEA,  0xD942 },
	{ 0xDBEB,  0xD94B },
	{ 0xDBEC,  0xD947 },
	{ 0xDBED,  0xF4F2 },
	{ 0xDBEE,  0xDA65 },
	{ 0xDBEF,  0xDA6B },
	{ 0xDBF0,  0xDB41 },
	{ 0xDBF1,  0xDA9F },
	{ 0xDBF2,  0xDA9C },
	{ 0xDBF3,  0xDA98 },
	{ 0xDBF4,  0xF5C5 },
	{ 0xDBF5,  0xDB43 },
	{ 0xDBF6,  0xF5CA },
	{ 0xDBF7,  0xDB40 },
	{ 0xDBF8,  0xDB42 },
	{ 0xDBF9,  0xDA99 },
	{ 0xDBFA,  0xF5C6 },
	{ 0xDBFB,  0xDA97 },
	{ 0xDBFC,  0xDD4A },
	{ 0xDBFD,  0xDD52 },
	{ 0xDBFE,  0xDD55 },
	{ 0xDC40,  0xDD54 },
	{ 0xDC41,  0xDD41 },
	{ 0xDC42,  0xDD49 },
	{ 0xDC43,  0xDD40 },
	{ 0xDC44,  0xDD50 },
	{ 0xDC45,  0xDD42 },
	{ 0xDC46,  0xDD43 },
	{ 0xDC47,  0xDD51 },
	{ 0xDC48,  0xDD46 },
	{ 0xDC49,  0xDD4C },
	{ 0xDC4A,  0xDD47 },
	{ 0xDC4B,  0xDD4F },
	{ 0xDC4C,  0xDD44 },
	{ 0xDC4D,  0xE5D5 },
	{ 0xDC4E,  0xDF4F },
	{ 0xDC4F,  0xE5D6 },
	{ 0xDC50,  0xE069 },
	{ 0xDC51,  0xE08C },
	{ 0xDC52,  0xDBB2 },
	{ 0xDC53,  0xE064 },
	{ 0xDC54,  0xE063 },
	{ 0xDC55,  0xE06B },
	{ 0xDC56,  0xE060 },
	{ 0xDC57,  0xE062 },
	{ 0xDC58,  0xE066 },
	{ 0xDC59,  0xE065 },
	{ 0xDC5A,  0xE06A },
	{ 0xDC5B,  0xE068 },
	{ 0xDC5C,  0xE067 },
	{ 0xDC5D,  0xF5A2 },
	{ 0xDC5E,  0xF4FE },
	{ 0xDC5F,  0xE14C },
	{ 0xDC60,  0xF5A1 },
	{ 0xDC61,  0xE14D },
	{ 0xDC62,  0xE25B },
	{ 0xDC63,  0xE264 },
	{ 0xDC64,  0xE280 },
	{ 0xDC65,  0xE25D },
	{ 0xDC66,  0xE274 },
	{ 0xDC67,  0xE281 },
	{ 0xDC68,  0xE269 },
	{ 0xDC69,  0xE266 },
	{ 0xDC6A,  0xE25A },
	{ 0xDC6B,  0xE26C },
	{ 0xDC6C,  0xE259 },
	{ 0xDC6D,  0xE257 },
	{ 0xDC6E,  0xE260 },
	{ 0xDC6F,  0xE25E },
	{ 0xDC70,  0xE282 },
	{ 0xDC71,  0xE25C },
	{ 0xDC72,  0xE276 },
	{ 0xDC73,  0xE27E },
	{ 0xDC74,  0xE273 },
	{ 0xDC75,  0xE271 },
	{ 0xDC76,  0xE25F },
	{ 0xDC77,  0xE270 },
	{ 0xDC78,  0xE950 },
	{ 0xDC79,  0xE961 },
	{ 0xDC7A,  0xE960 },
	{ 0xDC7B,  0xE964 },
	{ 0xDC7C,  0xEA9E },
	{ 0xDC7D,  0xEA97 },
	{ 0xDC7E,  0xDAF1 },
	{ 0xDCA1,  0xEA9F },
	{ 0xDCA2,  0xEA9C },
	{ 0xDCA3,  0xEA99 },
	{ 0xDCA4,  0xEB64 },
	{ 0xDCA5,  0xEB66 },
	{ 0xDCA6,  0xEB65 },
	{ 0xDCA7,  0xEB84 },
	{ 0xDCA8,  0xEB83 },
	{ 0xDCA9,  0xEC79 },
	{ 0xDCAA,  0xEC7D },
	{ 0xDCAB,  0xEC7B },
	{ 0xDCAC,  0xED99 },
	{ 0xDCAD,  0xEF4D },
	{ 0xDCAE,  0xEF84 },
	{ 0xDCAF,  0xF843 },
	{ 0xDCB0,  0xEDE9 },
	{ 0xDCB1,  0x817A },
	{ 0xDCB2,  0x817B },
	{ 0xDCB3,  0x818D },
	{ 0xDCB4,  0x8340 },
	{ 0xDCB5,  0x8342 },
	{ 0xDCB6,  0x8349 },
	{ 0xDCB7,  0x82F3 },
	{ 0xDCB8,  0x8347 },
	{ 0xDCB9,  0x834D },
	{ 0xDCBA,  0x82F8 },
	{ 0xDCBB,  0x834B },
	{ 0xDCBC,  0x8345 },
	{ 0xDCBD,  0x82F5 },
	{ 0xDCBE,  0x8344 },
	{ 0xDCBF,  0xD9D1 },
	{ 0xDCC0,  0x82F6 },
	{ 0xDCC1,  0x834E },
	{ 0xDCC2,  0x834C },
	{ 0xDCC3,  0x82FA },
	{ 0xDCC4,  0x82FC },
	{ 0xDCC5,  0x83FE },
	{ 0xDCC6,  0x8498 },
	{ 0xDCC7,  0x8496 },
	{ 0xDCC8,  0x8499 },
	{ 0xDCC9,  0x849A },
	{ 0xDCCA,  0x86DB },
	{ 0xDCCB,  0x86E9 },
	{ 0xDCCC,  0xE0C9 },
	{ 0xDCCD,  0x86E3 },
	{ 0xDCCE,  0x86E0 },
	{ 0xDCCF,  0x86DF },
	{ 0xDCD0,  0xE0C3 },
	{ 0xDCD1,  0x86D8 },
	{ 0xDCD2,  0xE0C1 },
	{ 0xDCD3,  0xE0C4 },
	{ 0xDCD4,  0x86EE },
	{ 0xDCD5,  0x86D7 },
	{ 0xDCD6,  0xE0AA },
	{ 0xDCD7,  0x86B6 },
	{ 0xDCD8,  0x86E2 },
	{ 0xDCD9,  0x86E4 },
	{ 0xDCDA,  0x86EC },
	{ 0xDCDB,  0xE0B2 },
	{ 0xDCDC,  0x86DE },
	{ 0xDCDD,  0xE0C7 },
	{ 0xDCDE,  0xE0CA },
	{ 0xDCDF,  0x86E7 },
	{ 0xDCE0,  0x86DA },
	{ 0xDCE1,  0x8842 },
	{ 0xDCE2,  0x8951 },
	{ 0xDCE3,  0x8962 },
	{ 0xDCE4,  0x895F },
	{ 0xDCE5,  0x894E },
	{ 0xDCE6,  0xEBF3 },
	{ 0xDCE7,  0x894A },
	{ 0xDCE8,  0x8967 },
	{ 0xDCE9,  0x8952 },
	{ 0xDCEA,  0x894D },
	{ 0xDCEB,  0x8959 },
	{ 0xDCEC,  0x8955 },
	{ 0xDCED,  0xDCAA },
	{ 0xDCEE,  0x8957 },
	{ 0xDCEF,  0x88FE },
	{ 0xDCF0,  0x895E },
	{ 0xDCF1,  0x8969 },
	{ 0xDCF2,  0x89DA },
	{ 0xDCF3,  0x8B93 },
	{ 0xDCF4,  0x8B90 },
	{ 0xDCF5,  0x8B96 },
	{ 0xDCF6,  0x8B89 },
	{ 0xDCF7,  0xE6CA },
	{ 0xDCF8,  0x8B84 },
	{ 0xDCF9,  0xEBF4 },
	{ 0xDCFA,  0x8B83 },
	{ 0xDCFB,  0x8B8D },
	{ 0xDCFC,  0x8B94 },
	{ 0xDCFD,  0x8B8A },
	{ 0xDCFE,  0x8B92 },
	{ 0xDD40,  0x8B87 },
	{ 0xDD41,  0x8B8E },
	{ 0xDD42,  0x8B95 },
	{ 0xDD43,  0x8B85 },
	{ 0xDD44,  0x8B86 },
	{ 0xDD45,  0x8B97 },
	{ 0xDD46,  0x8B88 },
	{ 0xDD47,  0x8B66 },
	{ 0xDD48,  0x8C83 },
	{ 0xDD49,  0x8C85 },
	{ 0xDD4A,  0x8C86 },
	{ 0xDD4B,  0x8CAF },
	{ 0xDD4C,  0x8CBD },
	{ 0xDD4D,  0x8DD3 },
	{ 0xDD4E,  0x8DC9 },
	{ 0xDD4F,  0xE1D3 },
	{ 0xDD50,  0x8DCB },
	{ 0xDD51,  0x8DD4 },
	{ 0xDD52,  0xE1CD },
	{ 0xDD53,  0x8DC4 },
	{ 0xDD54,  0x8DCE },
	{ 0xDD55,  0x8DCD },
	{ 0xDD56,  0x8DC8 },
	{ 0xDD57,  0x8E80 },
	{ 0xDD58,  0x8EB7 },
	{ 0xDD59,  0x8EB6 },
	{ 0xDD5A,  0x8EB3 },
	{ 0xDD5B,  0x8EB5 },
	{ 0xDD5C,  0x8EB4 },
	{ 0xDD5D,  0x8EFE },
	{ 0xDD5E,  0x8F44 },
	{ 0xDD5F,  0x8F40 },
	{ 0xDD60,  0x8F43 },
	{ 0xDD61,  0x8F41 },
	{ 0xDD62,  0xECB0 },
	{ 0xDD63,  0x8FD0 },
	{ 0xDD64,  0xE1E6 },
	{ 0xDD65,  0x90C3 },
	{ 0xDD66,  0x9141 },
	{ 0xDD67,  0xE3BB },
	{ 0xDD68,  0xE3BA },
	{ 0xDD69,  0x90FD },
	{ 0xDD6A,  0x90EF },
	{ 0xDD6B,  0x90EB },
	{ 0xDD6C,  0x90E7 },
	{ 0xDD6D,  0x90FE },
	{ 0xDD6E,  0x90E8 },
	{ 0xDD6F,  0x9144 },
	{ 0xDD70,  0x90E3 },
	{ 0xDD71,  0x90F8 },
	{ 0xDD72,  0x91E7 },
	{ 0xDD73,  0xE150 },
	{ 0xDD74,  0x91E8 },
	{ 0xDD75,  0xEAAD },
	{ 0xDD76,  0xEAAE },
	{ 0xDD77,  0x9343 },
	{ 0xDD78,  0x9360 },
	{ 0xDD79,  0x935B },
	{ 0xDD7A,  0xB4A4 },
	{ 0xDD7B,  0x9373 },
	{ 0xDD7C,  0x936E },
	{ 0xDD7D,  0xDEF7 },
	{ 0xDD7E,  0x937E },
	{ 0xDDA1,  0x938A },
	{ 0xDDA2,  0x9395 },
	{ 0xDDA3,  0x937B },
	{ 0xDDA4,  0x9374 },
	{ 0xDDA5,  0x9377 },
	{ 0xDDA6,  0x938F },
	{ 0xDDA7,  0x938D },
	{ 0xDDA8,  0x937C },
	{ 0xDDA9,  0x937D },
	{ 0xDDAA,  0xDEF8 },
	{ 0xDDAB,  0xDEF9 },
	{ 0xDDAC,  0x9387 },
	{ 0xDDAD,  0x9382 },
	{ 0xDDAE,  0xDEF4 },
	{ 0xDDAF,  0x938B },
	{ 0xDDB0,  0x9386 },
	{ 0xDDB1,  0x936F },
	{ 0xDDB2,  0x9379 },
	{ 0xDDB3,  0x9393 },
	{ 0xDDB4,  0x9380 },
	{ 0xDDB5,  0x9381 },
	{ 0xDDB6,  0xDEF5 },
	{ 0xDDB7,  0x9359 },
	{ 0xDDB8,  0xDEF6 },
	{ 0xDDB9,  0x9385 },
	{ 0xDDBA,  0xDEFA },
	{ 0xDDBB,  0x9371 },
	{ 0xDDBC,  0x94B0 },
	{ 0xDDBD,  0x94CA },
	{ 0xDDBE,  0x94EF },
	{ 0xDDBF,  0x959D },
	{ 0xDDC0,  0xEAD2 },
	{ 0xDDC1,  0x95A9 },
	{ 0xDDC2,  0x95A5 },
	{ 0xDDC3,  0x95A1 },
	{ 0xDDC4,  0x95A0 },
	{ 0xDDC5,  0x95AB },
	{ 0xDDC6,  0x95A8 },
	{ 0xDDC7,  0x9593 },
	{ 0xDDC8,  0x9650 },
	{ 0xDDC9,  0xE9B8 },
	{ 0xDDCA,  0x97FE },
	{ 0xDDCB,  0x97E0 },
	{ 0xDDCC,  0x97F2 },
	{ 0xDDCD,  0x9841 },
	{ 0xDDCE,  0xE9A8 },
	{ 0xDDCF,  0xB4BB },
	{ 0xDDD0,  0x97E9 },
	{ 0xDDD1,  0x9847 },
	{ 0xDDD2,  0xE9A9 },
	{ 0xDDD3,  0xE9AB },
	{ 0xDDD4,  0xE9A5 },
	{ 0xDDD5,  0x97FB },
	{ 0xDDD6,  0x9851 },
	{ 0xDDD7,  0x97EC },
	{ 0xDDD8,  0x97ED },
	{ 0xDDD9,  0x97DD },
	{ 0xDDDA,  0x9848 },
	{ 0xDDDB,  0x97DC },
	{ 0xDDDC,  0xB4AA },
	{ 0xDDDD,  0x9843 },
	{ 0xDDDE,  0xE9A2 },
	{ 0xDDDF,  0xE9B1 },
	{ 0xDDE0,  0xE9B2 },
	{ 0xDDE1,  0x9846 },
	{ 0xDDE2,  0x97E5 },
	{ 0xDDE3,  0x984A },
	{ 0xDDE4,  0x97E8 },
	{ 0xDDE5,  0x9850 },
	{ 0xDDE6,  0x97FA },
	{ 0xDDE7,  0x97E6 },
	{ 0xDDE8,  0x984E },
	{ 0xDDE9,  0x97F0 },
	{ 0xDDEA,  0x97E2 },
	{ 0xDDEB,  0x97EF },
	{ 0xDDEC,  0x97DF },
	{ 0xDDED,  0x97FD },
	{ 0xDDEE,  0x97F3 },
	{ 0xDDEF,  0x97F5 },
	{ 0xDDF0,  0x97DB },
	{ 0xDDF1,  0x97F6 },
	{ 0xDDF2,  0x97D9 },
	{ 0xDDF3,  0x9852 },
	{ 0xDDF4,  0x97E3 },
	{ 0xDDF5,  0xECA7 },
	{ 0xDDF6,  0x9A50 },
	{ 0xDDF7,  0xECA6 },
	{ 0xDDF8,  0x9A4E },
	{ 0xDDF9,  0x9A51 },
	{ 0xDDFA,  0x9A4D },
	{ 0xDDFB,  0xE9EA },
	{ 0xDDFC,  0xFE41 },
	{ 0xDDFD,  0x9ACD },
	{ 0xDDFE,  0x9ACE },
	{ 0xDE40,  0xEBA8 },
	{ 0xDE41,  0x9ACA },
	{ 0xDE42,  0x9ACB },
	{ 0xDE43,  0x9CCE },
	{ 0xDE44,  0x9CF1 },
	{ 0xDE45,  0x9CE9 },
	{ 0xDE46,  0xE4E7 },
	{ 0xDE47,  0x9CE4 },
	{ 0xDE48,  0xE4E9 },
	{ 0xDE49,  0x9CC7 },
	{ 0xDE4A,  0x9CC8 },
	{ 0xDE4B,  0x9CD1 },
	{ 0xDE4C,  0xE4DA },
	{ 0xDE4D,  0x9CE0 },
	{ 0xDE4E,  0x9CE8 },
	{ 0xDE4F,  0x9CF0 },
	{ 0xDE50,  0xE4E1 },
	{ 0xDE51,  0xB3FC },
	{ 0xDE52,  0x9CD0 },
	{ 0xDE53,  0x9CEA },
	{ 0xDE54,  0xE4E3 },
	{ 0xDE55,  0x9CDC },
	{ 0xDE56,  0x9CED },
	{ 0xDE57,  0x9CD5 },
	{ 0xDE58,  0xE4E6 },
	{ 0xDE59,  0xE4D1 },
	{ 0xDE5A,  0x9CE2 },
	{ 0xDE5B,  0x9CE5 },
	{ 0xDE5C,  0x9CF5 },
	{ 0xDE5D,  0x9CF2 },
	{ 0xDE5E,  0x9CCC },
	{ 0xDE5F,  0x9CC6 },
	{ 0xDE60,  0x9CC4 },
	{ 0xDE61,  0x9CC3 },
	{ 0xDE62,  0x9CD4 },
	{ 0xDE63,  0x9CD2 },
	{ 0xDE64,  0x9CE3 },
	{ 0xDE65,  0x9CDD },
	{ 0xDE66,  0x9CEF },
	{ 0xDE67,  0x9CEB },
	{ 0xDE68,  0x9CCB },
	{ 0xDE69,  0x9CDB },
	{ 0xDE6A,  0x9CD3 },
	{ 0xDE6B,  0x9F90 },
	{ 0xDE6C,  0x9F9A },
	{ 0xDE6D,  0x9F98 },
	{ 0xDE6E,  0x9FA7 },
	{ 0xDE6F,  0x9FA4 },
	{ 0xDE70,  0x9F8B },
	{ 0xDE71,  0x9FA2 },
	{ 0xDE72,  0x9FA6 },
	{ 0xDE73,  0xECD2 },
	{ 0xDE74,  0xECD4 },
	{ 0xDE75,  0x9FAA },
	{ 0xDE76,  0x9FA5 },
	{ 0xDE77,  0x9F8C },
	{ 0xDE78,  0x9F9E },
	{ 0xDE79,  0x9F8D },
	{ 0xDE7A,  0x9F93 },
	{ 0xDE7B,  0x9FAF },
	{ 0xDE7C,  0x9FA3 },
	{ 0xDE7D,  0x9F96 },
	{ 0xDE7E,  0x9F99 },
	{ 0xDEA1,  0x9F8E },
	{ 0xDEA2,  0x9F94 },
	{ 0xDEA3,  0x9FA0 },
	{ 0xDEA4,  0xA0A2 },
	{ 0xDEA5,  0xEAF9 },
	{ 0xDEA6,  0xA0C7 },
	{ 0xDEA7,  0xA0CA },
	{ 0xDEA8,  0xA0C9 },
	{ 0xDEA9,  0xA0C8 },
	{ 0xDEAA,  0xAA74 },
	{ 0xDEAB,  0xAA78 },
	{ 0xDEAC,  0xAA73 },
	{ 0xDEAD,  0xAA72 },
	{ 0xDEAE,  0xAA76 },
	{ 0xDEAF,  0xAA81 },
	{ 0xDEB0,  0xAA80 },
	{ 0xDEB1,  0xAC75 },
	{ 0xDEB2,  0xAC7B },
	{ 0xDEB3,  0xAC7C },
	{ 0xDEB4,  0xAC84 },
	{ 0xDEB5,  0xAC83 },
	{ 0xDEB6,  0xE8A5 },
	{ 0xDEB7,  0xAC72 },
	{ 0xDEB8,  0xAC81 },
	{ 0xDEB9,  0xAC82 },
	{ 0xDEBA,  0xAC80 },
	{ 0xDEBB,  0xAC73 },
	{ 0xDEBC,  0xAC77 },
	{ 0xDEBD,  0xAC7E },
	{ 0xDEBE,  0xAC86 },
	{ 0xDEBF,  0xAD95 },
	{ 0xDEC0,  0xEAB3 },
	{ 0xDEC1,  0xAE48 },
	{ 0xDEC2,  0xAE47 },
	{ 0xDEC3,  0xAE5D },
	{ 0xDEC4,  0xEEB5 },
	{ 0xDEC5,  0xAE95 },
	{ 0xDEC6,  0x9857 },
	{ 0xDEC7,  0xAF70 },
	{ 0xDEC8,  0xAF85 },
	{ 0xDEC9,  0xF0F1 },
	{ 0xDECA,  0xAF75 },
	{ 0xDECB,  0xAF7A },
	{ 0xDECC,  0xF0F3 },
	{ 0xDECD,  0xB1D4 },
	{ 0xDECE,  0xAF76 },
	{ 0xDECF,  0xF0F5 },
	{ 0xDED0,  0xAF78 },
	{ 0xDED1,  0xAF74 },
	{ 0xDED2,  0xAF6E },
	{ 0xDED3,  0xAF73 },
	{ 0xDED4,  0xAF79 },
	{ 0xDED5,  0xF0AA },
	{ 0xDED6,  0xB094 },
	{ 0xDED7,  0xB14A },
	{ 0xDED8,  0xB19B },
	{ 0xDED9,  0xB242 },
	{ 0xDEDA,  0xB243 },
	{ 0xDEDB,  0xB198 },
	{ 0xDEDC,  0xB19C },
	{ 0xDEDD,  0xEDFD },
	{ 0xDEDE,  0xB246 },
	{ 0xDEDF,  0xB245 },
	{ 0xDEE0,  0xB19A },
	{ 0xDEE1,  0xB19F },
	{ 0xDEE2,  0xB248 },
	{ 0xDEE3,  0xB29E },
	{ 0xDEE4,  0xEDD6 },
	{ 0xDEE5,  0xEDD5 },
	{ 0xDEE6,  0xB449 },
	{ 0xDEE7,  0xB446 },
	{ 0xDEE8,  0xB440 },
	{ 0xDEE9,  0xB44A },
	{ 0xDEEA,  0xB441 },
	{ 0xDEEB,  0xB442 },
	{ 0xDEEC,  0xEDD8 },
	{ 0xDEED,  0xB3A0 },
	{ 0xDEEE,  0xB397 },
	{ 0xDEEF,  0xB44C },
	{ 0xDEF0,  0xB39D },
	{ 0xDEF1,  0xB44B },
	{ 0xDEF2,  0xB399 },
	{ 0xDEF3,  0xB590 },
	{ 0xDEF4,  0xB594 },
	{ 0xDEF5,  0xB591 },
	{ 0xDEF6,  0xB58E },
	{ 0xDEF7,  0xB698 },
	{ 0xDEF8,  0xB69D },
	{ 0xDEF9,  0xB69E },
	{ 0xDEFA,  0xB699 },
	{ 0xDEFB,  0xB0DE },
	{ 0xDEFC,  0xB69B },
	{ 0xDEFD,  0xB743 },
	{ 0xDEFE,  0xB69A },
	{ 0xDF40,  0xB69F },
	{ 0xDF41,  0xB697 },
	{ 0xDF42,  0xB840 },
	{ 0xDF43,  0xB7A0 },
	{ 0xDF44,  0xB79E },
	{ 0xDF45,  0xB878 },
	{ 0xDF46,  0xB960 },
	{ 0xDF47,  0xB95E },
	{ 0xDF48,  0xB967 },
	{ 0xDF49,  0xB96B },
	{ 0xDF4A,  0xB963 },
	{ 0xDF4B,  0xF3E2 },
	{ 0xDF4C,  0xB95F },
	{ 0xDF4D,  0xB96A },
	{ 0xDF4E,  0xF3E3 },
	{ 0xDF4F,  0xB969 },
	{ 0xDF50,  0xB95C },
	{ 0xDF51,  0xB96D },
	{ 0xDF52,  0xB96C },
	{ 0xDF53,  0xB95D },
	{ 0xDF54,  0xF4D3 },
	{ 0xDF55,  0xBB9A },
	{ 0xDF56,  0xBB98 },
	{ 0xDF57,  0xBD90 },
	{ 0xDF58,  0xBD8E },
	{ 0xDF59,  0xBD88 },
	{ 0xDF5A,  0xBD95 },
	{ 0xDF5B,  0xBD87 },
	{ 0xDF5C,  0xBD8D },
	{ 0xDF5D,  0xBD82 },
	{ 0xDF5E,  0xBD96 },
	{ 0xDF5F,  0xBD83 },
	{ 0xDF60,  0xBD8B },
	{ 0xDF61,  0xBD84 },
	{ 0xDF62,  0xBD94 },
	{ 0xDF63,  0xBD9C },
	{ 0xDF64,  0xBD8C },
	{ 0xDF65,  0xBD85 },
	{ 0xDF66,  0xBD9A },
	{ 0xDF67,  0xC14E },
	{ 0xDF68,  0xC14C },
	{ 0xDF69,  0xC14B },
	{ 0xDF6A,  0xEEBB },
	{ 0xDF6B,  0xC14D },
	{ 0xDF6C,  0xC176 },
	{ 0xDF6D,  0xC175 },
	{ 0xDF6E,  0xF4C8 },
	{ 0xDF6F,  0xC19B },
	{ 0xDF70,  0xC19C },
	{ 0xDF71,  0xC261 },
	{ 0xDF72,  0xC457 },
	{ 0xDF73,  0xEBED },
	{ 0xDF74,  0xC462 },
	{ 0xDF75,  0xC450 },
	{ 0xDF76,  0xEBEE },
	{ 0xDF77,  0xC44F },
	{ 0xDF78,  0xC455 },
	{ 0xDF79,  0xC45E },
	{ 0xDF7A,  0x9651 },
	{ 0xDF7B,  0xC452 },
	{ 0xDF7C,  0xC461 },
	{ 0xDF7D,  0xEBF2 },
	{ 0xDF7E,  0xC45D },
	{ 0xDFA1,  0xC444 },
	{ 0xDFA2,  0xC454 },
	{ 0xDFA3,  0xC572 },
	{ 0xDFA4,  0xF4BA },
	{ 0xDFA5,  0xF4B9 },
	{ 0xDFA6,  0xC580 },
	{ 0xDFA7,  0xC582 },
	{ 0xDFA8,  0xC584 },
	{ 0xDFA9,  0xC991 },
	{ 0xDFAA,  0xC875 },
	{ 0xDFAB,  0xC88B },
	{ 0xDFAC,  0xDDE3 },
	{ 0xDFAD,  0xC89E },
	{ 0xDFAE,  0xC94B },
	{ 0xDFAF,  0xC94A },
	{ 0xDFB0,  0xC893 },
	{ 0xDFB1,  0xDDD7 },
	{ 0xDFB2,  0xC876 },
	{ 0xDFB3,  0xC948 },
	{ 0xDFB4,  0xC895 },
	{ 0xDFB5,  0xC86A },
	{ 0xDFB6,  0xC883 },
	{ 0xDFB7,  0xC940 },
	{ 0xDFB8,  0xDDD8 },
	{ 0xDFB9,  0xDDD9 },
	{ 0xDFBA,  0xC89C },
	{ 0xDFBB,  0xDDDA },
	{ 0xDFBC,  0xC88D },
	{ 0xDFBD,  0xCA44 },
	{ 0xDFBE,  0xC88E },
	{ 0xDFBF,  0xC870 },
	{ 0xDFC0,  0xC872 },
	{ 0xDFC1,  0xC86D },
	{ 0xDFC2,  0xDDDD },
	{ 0xDFC3,  0xC879 },
	{ 0xDFC4,  0xDDDF },
	{ 0xDFC5,  0xC86B },
	{ 0xDFC6,  0xC87B },
	{ 0xDFC7,  0xC863 },
	{ 0xDFC8,  0xC794 },
	{ 0xDFC9,  0xC881 },
	{ 0xDFCA,  0xC869 },
	{ 0xDFCB,  0xC878 },
	{ 0xDFCC,  0xC867 },
	{ 0xDFCD,  0xC88F },
	{ 0xDFCE,  0xC89A },
	{ 0xDFCF,  0xC871 },
	{ 0xDFD0,  0xC884 },
	{ 0xDFD1,  0xC882 },
	{ 0xDFD2,  0xC887 },
	{ 0xDFD3,  0xC899 },
	{ 0xDFD4,  0xC973 },
	{ 0xDFD5,  0xDDE5 },
	{ 0xDFD6,  0xC873 },
	{ 0xDFD7,  0xC87C },
	{ 0xDFD8,  0xC86F },
	{ 0xDFD9,  0xC86C },
	{ 0xDFDA,  0xC896 },
	{ 0xDFDB,  0xC941 },
	{ 0xDFDC,  0xC87A },
	{ 0xDFDD,  0xC865 },
	{ 0xDFDE,  0xC890 },
	{ 0xDFDF,  0xC889 },
	{ 0xDFE0,  0xC898 },
	{ 0xDFE1,  0xC886 },
	{ 0xDFE2,  0xCD99 },
	{ 0xDFE3,  0xCD96 },
	{ 0xDFE4,  0xCD8F },
	{ 0xDFE5,  0xCD9A },
	{ 0xDFE6,  0xCD90 },
	{ 0xDFE7,  0xCD7B },
	{ 0xDFE8,  0xCD8D },
	{ 0xDFE9,  0xCE61 },
	{ 0xDFEA,  0xF2D9 },
	{ 0xDFEB,  0xCD9B },
	{ 0xDFEC,  0xF2DD },
	{ 0xDFED,  0xCD95 },
	{ 0xDFEE,  0xCD8E },
	{ 0xDFEF,  0xF2DC },
	{ 0xDFF0,  0xCD97 },
	{ 0xDFF1,  0xD15D },
	{ 0xDFF2,  0xD156 },
	{ 0xDFF3,  0xD158 },
	{ 0xDFF4,  0xF1CE },
	{ 0xDFF5,  0xD163 },
	{ 0xDFF6,  0xD160 },
	{ 0xDFF7,  0xD15F },
	{ 0xDFF8,  0xD157 },
	{ 0xDFF9,  0xD15A },
	{ 0xDFFA,  0xD285 },
	{ 0xDFFB,  0xD29A },
	{ 0xDFFC,  0xD369 },
	{ 0xDFFD,  0xF6A1 },
	{ 0xDFFE,  0xD36D },
	{ 0xE040,  0xD36B },
	{ 0xE041,  0xD36A },
	{ 0xE042,  0xD36C },
	{ 0xE043,  0xF5FE },
	{ 0xE044,  0xB4A5 },
	{ 0xE045,  0xD497 },
	{ 0xE046,  0xD545 },
	{ 0xE047,  0xD49F },
	{ 0xE048,  0xD482 },
	{ 0xE049,  0xD460 },
	{ 0xE04A,  0xD498 },
	{ 0xE04B,  0xD541 },
	{ 0xE04C,  0xD543 },
	{ 0xE04D,  0xD496 },
	{ 0xE04E,  0xD542 },
	{ 0xE04F,  0xD540 },
	{ 0xE050,  0xD495 },
	{ 0xE051,  0xD49A },
	{ 0xE052,  0xD844 },
	{ 0xE053,  0xD84F },
	{ 0xE054,  0xD84E },
	{ 0xE055,  0xD864 },
	{ 0xE056,  0xD863 },
	{ 0xE057,  0xD865 },
	{ 0xE058,  0xD87D },
	{ 0xE059,  0xD87C },
	{ 0xE05A,  0xF5F7 },
	{ 0xE05B,  0xD95E },
	{ 0xE05C,  0xDA55 },
	{ 0xE05D,  0xDA56 },
	{ 0xE05E,  0xF4F4 },
	{ 0xE05F,  0xDA6C },
	{ 0xE060,  0xDA6E },
	{ 0xE061,  0xDA6F },
	{ 0xE062,  0xDA6D },
	{ 0xE063,  0xDA72 },
	{ 0xE064,  0xF4F3 },
	{ 0xE065,  0xDA70 },
	{ 0xE066,  0xDA71 },
	{ 0xE067,  0xDB4D },
	{ 0xE068,  0xDB44 },
	{ 0xE069,  0xF5CD },
	{ 0xE06A,  0xDB4E },
	{ 0xE06B,  0xDB4C },
	{ 0xE06C,  0xDA9D },
	{ 0xE06D,  0xDB4A },
	{ 0xE06E,  0xF5D0 },
	{ 0xE06F,  0xDB46 },
	{ 0xE070,  0xDB49 },
	{ 0xE071,  0xDB4F },
	{ 0xE072,  0xF5BC },
	{ 0xE073,  0xDB50 },
	{ 0xE074,  0xDD61 },
	{ 0xE075,  0xDD5A },
	{ 0xE076,  0xDD5C },
	{ 0xE077,  0xDD5B },
	{ 0xE078,  0xDD60 },
	{ 0xE079,  0xDD62 },
	{ 0xE07A,  0xDD63 },
	{ 0xE07B,  0xDD5D },
	{ 0xE07C,  0xDD66 },
	{ 0xE07D,  0xE5D9 },
	{ 0xE07E,  0xDF54 },
	{ 0xE0A1,  0xE5D7 },
	{ 0xE0A2,  0xDF5A },
	{ 0xE0A3,  0xDF53 },
	{ 0xE0A4,  0xE073 },
	{ 0xE0A5,  0xE070 },
	{ 0xE0A6,  0xE072 },
	{ 0xE0A7,  0xE074 },
	{ 0xE0A8,  0xE079 },
	{ 0xE0A9,  0xE077 },
	{ 0xE0AA,  0xE06E },
	{ 0xE0AB,  0xE071 },
	{ 0xE0AC,  0xCDAA },
	{ 0xE0AD,  0xF5A5 },
	{ 0xE0AE,  0xE342 },
	{ 0xE0AF,  0xE34C },
	{ 0xE0B0,  0xE28B },
	{ 0xE0B1,  0xE295 },
	{ 0xE0B2,  0xE360 },
	{ 0xE0B3,  0xE28E },
	{ 0xE0B4,  0xE35F },
	{ 0xE0B5,  0xE358 },
	{ 0xE0B6,  0xE37C },
	{ 0xE0B7,  0xE289 },
	{ 0xE0B8,  0xE344 },
	{ 0xE0B9,  0xE340 },
	{ 0xE0BA,  0xE367 },
	{ 0xE0BB,  0xE366 },
	{ 0xE0BC,  0xE349 },
	{ 0xE0BD,  0xE35A },
	{ 0xE0BE,  0xE361 },
	{ 0xE0BF,  0xE369 },
	{ 0xE0C0,  0xE291 },
	{ 0xE0C1,  0xE35B },
	{ 0xE0C2,  0xE36A },
	{ 0xE0C3,  0xE28C },
	{ 0xE0C4,  0xE34E },
	{ 0xE0C5,  0xE35D },
	{ 0xE0C6,  0xE34A },
	{ 0xE0C7,  0xE36C },
	{ 0xE0C8,  0xE348 },
	{ 0xE0C9,  0xE34D },
	{ 0xE0CA,  0xE346 },
	{ 0xE0CB,  0xE350 },
	{ 0xE0CC,  0xE28D },
	{ 0xE0CD,  0xE973 },
	{ 0xE0CE,  0xE970 },
	{ 0xE0CF,  0xE972 },
	{ 0xE0D0,  0xE96F },
	{ 0xE0D1,  0xEB43 },
	{ 0xE0D2,  0xEB44 },
	{ 0xE0D3,  0xEB42 },
	{ 0xE0D4,  0xDAF3 },
	{ 0xE0D5,  0xF6C2 },
	{ 0xE0D6,  0xEB89 },
	{ 0xE0D7,  0xEB8C },
	{ 0xE0D8,  0xEB88 },
	{ 0xE0D9,  0xEB87 },
	{ 0xE0DA,  0xBDF9 },
	{ 0xE0DB,  0xEC82 },
	{ 0xE0DC,  0xEC83 },
	{ 0xE0DD,  0xEC80 },
	{ 0xE0DE,  0xEE40 },
	{ 0xE0DF,  0xED9F },
	{ 0xE0E0,  0xEDA0 },
	{ 0xE0E1,  0xEF50 },
	{ 0xE0E2,  0xEF8F },
	{ 0xE0E3,  0xEF92 },
	{ 0xE0E4,  0xF155 },
	{ 0xE0E5,  0xF158 },
	{ 0xE0E6,  0xF156 },
	{ 0xE0E7,  0xF15B },
	{ 0xE0E8,  0xF35F },
	{ 0xE0E9,  0xF35D },
	{ 0xE0EA,  0xF480 },
	{ 0xE0EB,  0xF847 },
	{ 0xE0EC,  0xF84A },
	{ 0xE0ED,  0xF844 },
	{ 0xE0EE,  0xFB7E },
	{ 0xE0EF,  0xFC77 },
	{ 0xE0F0,  0xD9D6 },
	{ 0xE0F1,  0x8356 },
	{ 0xE0F2,  0x8358 },
	{ 0xE0F3,  0x8366 },
	{ 0xE0F4,  0xCBDB },
	{ 0xE0F5,  0x835B },
	{ 0xE0F6,  0x8368 },
	{ 0xE0F7,  0x835D },
	{ 0xE0F8,  0x8364 },
	{ 0xE0F9,  0x8355 },
	{ 0xE0FA,  0xD9D5 },
	{ 0xE0FB,  0x836B },
	{ 0xE0FC,  0x836A },
	{ 0xE0FD,  0x8363 },
	{ 0xE0FE,  0x8360 },
	{ 0xE140,  0x8440 },
	{ 0xE141,  0x849C },
	{ 0xE142,  0xD8E4 },
	{ 0xE143,  0x84E3 },
	{ 0xE144,  0x84E5 },
	{ 0xE145,  0x8553 },
	{ 0xE146,  0x8591 },
	{ 0xE147,  0xE0D7 },
	{ 0xE148,  0x874A },
	{ 0xE149,  0xE0D1 },
	{ 0xE14A,  0x8747 },
	{ 0xE14B,  0x86F9 },
	{ 0xE14C,  0xD8C5 },
	{ 0xE14D,  0x874F },
	{ 0xE14E,  0xE0D2 },
	{ 0xE14F,  0x8748 },
	{ 0xE150,  0x86FB },
	{ 0xE151,  0x86F7 },
	{ 0xE152,  0x8750 },
	{ 0xE153,  0x86FD },
	{ 0xE154,  0x86FA },
	{ 0xE155,  0x86F6 },
	{ 0xE156,  0xDCAD },
	{ 0xE157,  0x8974 },
	{ 0xE158,  0x8983 },
	{ 0xE159,  0x8989 },
	{ 0xE15A,  0x8979 },
	{ 0xE15B,  0xDCAC },
	{ 0xE15C,  0x8976 },
	{ 0xE15D,  0x896C },
	{ 0xE15E,  0x897D },
	{ 0xE15F,  0x8972 },
	{ 0xE160,  0x897A },
	{ 0xE161,  0x8984 },
	{ 0xE162,  0x8981 },
	{ 0xE163,  0x896E },
	{ 0xE164,  0x8977 },
	{ 0xE165,  0x897B },
	{ 0xE166,  0x8973 },
	{ 0xE167,  0x8985 },
	{ 0xE168,  0x8982 },
	{ 0xE169,  0x89DC },
	{ 0xE16A,  0x8A5B },
	{ 0xE16B,  0xE6D1 },
	{ 0xE16C,  0x8BAD },
	{ 0xE16D,  0x8BA7 },
	{ 0xE16E,  0x8B9D },
	{ 0xE16F,  0x8BAA },
	{ 0xE170,  0x8BA0 },
	{ 0xE171,  0x8BAC },
	{ 0xE172,  0xE6C6 },
	{ 0xE173,  0x8BB1 },
	{ 0xE174,  0x8BA5 },
	{ 0xE175,  0xE6CB },
	{ 0xE176,  0x8BA1 },
	{ 0xE177,  0x8BAB },
	{ 0xE178,  0x8BA3 },
	{ 0xE179,  0x8BA2 },
	{ 0xE17A,  0x8B9F },
	{ 0xE17B,  0x8BA9 },
	{ 0xE17C,  0x8BA4 },
	{ 0xE17D,  0x8C56 },
	{ 0xE17E,  0x8C8A },
	{ 0xE1A1,  0x8C8C },
	{ 0xE1A2,  0xE5EF },
	{ 0xE1A3,  0xE1D6 },
	{ 0xE1A4,  0x8DE1 },
	{ 0xE1A5,  0x8DDE },
	{ 0xE1A6,  0x8DE6 },
	{ 0xE1A7,  0x8DDB },
	{ 0xE1A8,  0x8DE2 },
	{ 0xE1A9,  0x8DD8 },
	{ 0xE1AA,  0x8DEA },
	{ 0xE1AB,  0x8DE9 },
	{ 0xE1AC,  0x8DE8 },
	{ 0xE1AD,  0x8DDF },
	{ 0xE1AE,  0x8DDD },
	{ 0xE1AF,  0x8DED },
	{ 0xE1B0,  0x8DDA },
	{ 0xE1B1,  0x8DE0 },
	{ 0xE1B2,  0x8EBE },
	{ 0xE1B3,  0x8EBF },
	{ 0xE1B4,  0x8EBB },
	{ 0xE1B5,  0x8F4C },
	{ 0xE1B6,  0xE2DB },
	{ 0xE1B7,  0x8F4B },
	{ 0xE1B8,  0x8F46 },
	{ 0xE1B9,  0x8F4F },
	{ 0xE1BA,  0x8F4A },
	{ 0xE1BB,  0x8F4D },
	{ 0xE1BC,  0xE2DA },
	{ 0xE1BD,  0x8F49 },
	{ 0xE1BE,  0x8F93 },
	{ 0xE1BF,  0x8F92 },
	{ 0xE1C0,  0x8FAE },
	{ 0xE1C1,  0x8FD6 },
	{ 0xE1C2,  0x90E5 },
	{ 0xE1C3,  0x90E2 },
	{ 0xE1C4,  0x90F9 },
	{ 0xE1C5,  0x9150 },
	{ 0xE1C6,  0x915F },
	{ 0xE1C7,  0x9161 },
	{ 0xE1C8,  0x9146 },
	{ 0xE1C9,  0x9147 },
	{ 0xE1CA,  0x9160 },
	{ 0xE1CB,  0x915B },
	{ 0xE1CC,  0x916C },
	{ 0xE1CD,  0x9162 },
	{ 0xE1CE,  0x9148 },
	{ 0xE1CF,  0x9166 },
	{ 0xE1D0,  0x914E },
	{ 0xE1D1,  0x9156 },
	{ 0xE1D2,  0x90F4 },
	{ 0xE1D3,  0x9159 },
	{ 0xE1D4,  0x9153 },
	{ 0xE1D5,  0x9149 },
	{ 0xE1D6,  0x91EC },
	{ 0xE1D7,  0x91EA },
	{ 0xE1D8,  0x91ED },
	{ 0xE1D9,  0x9384 },
	{ 0xE1DA,  0x9399 },
	{ 0xE1DB,  0x93A4 },
	{ 0xE1DC,  0x93A6 },
	{ 0xE1DD,  0x93B9 },
	{ 0xE1DE,  0x93BB },
	{ 0xE1DF,  0x93B7 },
	{ 0xE1E0,  0x93B8 },
	{ 0xE1E1,  0x93BF },
	{ 0xE1E2,  0x93BA },
	{ 0xE1E3,  0x93AE },
	{ 0xE1E4,  0x93DD },
	{ 0xE1E5,  0x939A },
	{ 0xE1E6,  0xC1CC },
	{ 0xE1E7,  0xDEFB },
	{ 0xE1E8,  0x93A5 },
	{ 0xE1E9,  0x9397 },
	{ 0xE1EA,  0x939E },
	{ 0xE1EB,  0x93A8 },
	{ 0xE1EC,  0x939C },
	{ 0xE1ED,  0x93C1 },
	{ 0xE1EE,  0xEBA1 },
	{ 0xE1EF,  0x93B2 },
	{ 0xE1F0,  0x93B1 },
	{ 0xE1F1,  0x93A2 },
	{ 0xE1F2,  0x93AD },
	{ 0xE1F3,  0x93BC },
	{ 0xE1F4,  0x94B2 },
	{ 0xE1F5,  0x94D2 },
	{ 0xE1F6,  0x95B2 },
	{ 0xE1F7,  0x95B1 },
	{ 0xE1F8,  0x95B0 },
	{ 0xE1F9,  0x9641 },
	{ 0xE1FA,  0x9640 },
	{ 0xE1FB,  0x9652 },
	{ 0xE1FC,  0xE9C1 },
	{ 0xE1FD,  0x9879 },
	{ 0xE1FE,  0x988A },
	{ 0xE240,  0x9869 },
	{ 0xE241,  0xE9B6 },
	{ 0xE242,  0x9862 },
	{ 0xE243,  0x9875 },
	{ 0xE244,  0x9872 },
	{ 0xE245,  0x987D },
	{ 0xE246,  0x985F },
	{ 0xE247,  0x9864 },
	{ 0xE248,  0x985C },
	{ 0xE249,  0xE9BC },
	{ 0xE24A,  0xE9C7 },
	{ 0xE24B,  0x9870 },
	{ 0xE24C,  0x9880 },
	{ 0xE24D,  0x9874 },
	{ 0xE24E,  0x9881 },
	{ 0xE24F,  0x9885 },
	{ 0xE250,  0x987E },
	{ 0xE251,  0x986D },
	{ 0xE252,  0xE9C0 },
	{ 0xE253,  0x987B },
	{ 0xE254,  0xE9C3 },
	{ 0xE255,  0x9865 },
	{ 0xE256,  0x988D },
	{ 0xE257,  0x9877 },
	{ 0xE258,  0x9861 },
	{ 0xE259,  0x9871 },
	{ 0xE25A,  0x986A },
	{ 0xE25B,  0x9867 },
	{ 0xE25C,  0x9895 },
	{ 0xE25D,  0x9863 },
	{ 0xE25E,  0x985E },
	{ 0xE25F,  0x9883 },
	{ 0xE260,  0x9878 },
	{ 0xE261,  0x986E },
	{ 0xE262,  0x9887 },
	{ 0xE263,  0x9A52 },
	{ 0xE264,  0x9A54 },
	{ 0xE265,  0x9A53 },
	{ 0xE266,  0x9A8C },
	{ 0xE267,  0x9A8D },
	{ 0xE268,  0x9A8E },
	{ 0xE269,  0x9AA8 },
	{ 0xE26A,  0x9AA9 },
	{ 0xE26B,  0x9ACF },
	{ 0xE26C,  0x9CEE },
	{ 0xE26D,  0x9D44 },
	{ 0xE26E,  0x9D41 },
	{ 0xE26F,  0x9D50 },
	{ 0xE270,  0x9D6A },
	{ 0xE271,  0x9D47 },
	{ 0xE272,  0x9D74 },
	{ 0xE273,  0x9D49 },
	{ 0xE274,  0x9D6F },
	{ 0xE275,  0xE4F5 },
	{ 0xE276,  0x9D87 },
	{ 0xE277,  0x9D60 },
	{ 0xE278,  0x9D61 },
	{ 0xE279,  0x9D6C },
	{ 0xE27A,  0x9D5F },
	{ 0xE27B,  0x9D78 },
	{ 0xE27C,  0x9D5C },
	{ 0xE27D,  0x9CFC },
	{ 0xE27E,  0x9D55 },
	{ 0xE2A1,  0xE4F1 },
	{ 0xE2A2,  0x9DA4 },
	{ 0xE2A3,  0xE4EF },
	{ 0xE2A4,  0x9CFD },
	{ 0xE2A5,  0xE4DD },
	{ 0xE2A6,  0x9D7C },
	{ 0xE2A7,  0x9D70 },
	{ 0xE2A8,  0x9D79 },
	{ 0xE2A9,  0x9D73 },
	{ 0xE2AA,  0x9CFA },
	{ 0xE2AB,  0x9D53 },
	{ 0xE2AC,  0x9D59 },
	{ 0xE2AD,  0x9D80 },
	{ 0xE2AE,  0x9D52 },
	{ 0xE2AF,  0x9D4B },
	{ 0xE2B0,  0x9D45 },
	{ 0xE2B1,  0x9D76 },
	{ 0xE2B2,  0x9D63 },
	{ 0xE2B3,  0x9D4A },
	{ 0xE2B4,  0x9D77 },
	{ 0xE2B5,  0x9D66 },
	{ 0xE2B6,  0x9D58 },
	{ 0xE2B7,  0x9D65 },
	{ 0xE2B8,  0x9D54 },
	{ 0xE2B9,  0x9D67 },
	{ 0xE2BA,  0x9FC0 },
	{ 0xE2BB,  0x9FC7 },
	{ 0xE2BC,  0x9FC2 },
	{ 0xE2BD,  0x9FBA },
	{ 0xE2BE,  0x9FBE },
	{ 0xE2BF,  0x9FBC },
	{ 0xE2C0,  0xD1AC },
	{ 0xE2C1,  0x9FB6 },
	{ 0xE2C2,  0x9FBF },
	{ 0xE2C3,  0x9FBB },
	{ 0xE2C4,  0x9FCD },
	{ 0xE2C5,  0xA09B },
	{ 0xE2C6,  0xA0A5 },
	{ 0xE2C7,  0xA0CF },
	{ 0xE2C8,  0xA0CD },
	{ 0xE2C9,  0xA0CB },
	{ 0xE2CA,  0xAA79 },
	{ 0xE2CB,  0xE2B0 },
	{ 0xE2CC,  0xAA86 },
	{ 0xE2CD,  0xAA83 },
	{ 0xE2CE,  0xAC8C },
	{ 0xE2CF,  0xAC9B },
	{ 0xE2D0,  0xAC99 },
	{ 0xE2D1,  0xAC9D },
	{ 0xE2D2,  0xAC9A },
	{ 0xE2D3,  0xAC91 },
	{ 0xE2D4,  0xAC97 },
	{ 0xE2D5,  0xAE49 },
	{ 0xE2D6,  0xAE4B },
	{ 0xE2D7,  0xAE4C },
	{ 0xE2D8,  0xAE99 },
	{ 0xE2D9,  0xAF46 },
	{ 0xE2DA,  0xAF8A },
	{ 0xE2DB,  0xAF80 },
	{ 0xE2DC,  0xF0F8 },
	{ 0xE2DD,  0xF0FD },
	{ 0xE2DE,  0xAF86 },
	{ 0xE2DF,  0xF0FA },
	{ 0xE2E0,  0xAF89 },
	{ 0xE2E1,  0xB097 },
	{ 0xE2E2,  0xB257 },
	{ 0xE2E3,  0xB256 },
	{ 0xE2E4,  0xB3F2 },
	{ 0xE2E5,  0xB258 },
	{ 0xE2E6,  0xB249 },
	{ 0xE2E7,  0xEEA6 },
	{ 0xE2E8,  0xB24A },
	{ 0xE2E9,  0xD8BA },
	{ 0xE2EA,  0xB259 },
	{ 0xE2EB,  0xEDDA },
	{ 0xE2EC,  0xB455 },
	{ 0xE2ED,  0xB2EA },
	{ 0xE2EE,  0xB458 },
	{ 0xE2EF,  0xB453 },
	{ 0xE2F0,  0xB39B },
	{ 0xE2F1,  0xB456 },
	{ 0xE2F2,  0xB44E },
	{ 0xE2F3,  0xEDDC },
	{ 0xE2F4,  0xB44F },
	{ 0xE2F5,  0xB457 },
	{ 0xE2F6,  0xB450 },
	{ 0xE2F7,  0xB451 },
	{ 0xE2F8,  0xB645 },
	{ 0xE2F9,  0xECF9 },
	{ 0xE2FA,  0xB59A },
	{ 0xE2FB,  0xB643 },
	{ 0xE2FC,  0xB642 },
	{ 0xE2FD,  0xB641 },
	{ 0xE2FE,  0xB640 },
	{ 0xE340,  0xB644 },
	{ 0xE341,  0xB598 },
	{ 0xE342,  0xB5A0 },
	{ 0xE343,  0xB59E },
	{ 0xE344,  0xB74B },
	{ 0xE345,  0xB762 },
	{ 0xE346,  0xB750 },
	{ 0xE347,  0xB74F },
	{ 0xE348,  0xB748 },
	{ 0xE349,  0xB746 },
	{ 0xE34A,  0xF1BF },
	{ 0xE34B,  0xB845 },
	{ 0xE34C,  0xF1BE },
	{ 0xE34D,  0xB87A },
	{ 0xE34E,  0xB978 },
	{ 0xE34F,  0xF3ED },
	{ 0xE350,  0xB97A },
	{ 0xE351,  0xB980 },
	{ 0xE352,  0xF3E4 },
	{ 0xE353,  0xB983 },
	{ 0xE354,  0xB9BF },
	{ 0xE355,  0xB97C },
	{ 0xE356,  0xB987 },
	{ 0xE357,  0xB97D },
	{ 0xE358,  0xF3EB },
	{ 0xE359,  0xB984 },
	{ 0xE35A,  0x849E },
	{ 0xE35B,  0xB985 },
	{ 0xE35C,  0xB98C },
	{ 0xE35D,  0xB973 },
	{ 0xE35E,  0xBBA0 },
	{ 0xE35F,  0xBC40 },
	{ 0xE360,  0xF4D4 },
	{ 0xE361,  0xBB9F },
	{ 0xE362,  0xBE4D },
	{ 0xE363,  0xBE5C },
	{ 0xE364,  0xBE67 },
	{ 0xE365,  0xBE4A },
	{ 0xE366,  0xBE50 },
	{ 0xE367,  0xBE66 },
	{ 0xE368,  0xBE65 },
	{ 0xE369,  0xBE6A },
	{ 0xE36A,  0xBE44 },
	{ 0xE36B,  0xBE73 },
	{ 0xE36C,  0xBE69 },
	{ 0xE36D,  0xBE6B },
	{ 0xE36E,  0xBE70 },
	{ 0xE36F,  0xBE71 },
	{ 0xE370,  0xBE54 },
	{ 0xE371,  0xBE5E },
	{ 0xE372,  0xBD9E },
	{ 0xE373,  0xBE61 },
	{ 0xE374,  0xBE46 },
	{ 0xE375,  0xF4EB },
	{ 0xE376,  0xF4EC },
	{ 0xE377,  0xBE4F },
	{ 0xE378,  0xBE48 },
	{ 0xE379,  0xBE6E },
	{ 0xE37A,  0xC151 },
	{ 0xE37B,  0xC19F },
	{ 0xE37C,  0xC1A0 },
	{ 0xE37D,  0xF4E3 },
	{ 0xE37E,  0xC19E },
	{ 0xE3A1,  0xC263 },
	{ 0xE3A2,  0xC283 },
	{ 0xE3A3,  0xC282 },
	{ 0xE3A4,  0xC46A },
	{ 0xE3A5,  0xC468 },
	{ 0xE3A6,  0xC465 },
	{ 0xE3A7,  0xC469 },
	{ 0xE3A8,  0xC46D },
	{ 0xE3A9,  0xC46C },
	{ 0xE3AA,  0xC46B },
	{ 0xE3AB,  0xC56C },
	{ 0xE3AC,  0xDDF5 },
	{ 0xE3AD,  0xC95C },
	{ 0xE3AE,  0xDDF2 },
	{ 0xE3AF,  0xC958 },
	{ 0xE3B0,  0xDDF0 },
	{ 0xE3B1,  0xC979 },
	{ 0xE3B2,  0xC971 },
	{ 0xE3B3,  0xC964 },
	{ 0xE3B4,  0xC966 },
	{ 0xE3B5,  0xC963 },
	{ 0xE3B6,  0xDDF3 },
	{ 0xE3B7,  0xDDF4 },
	{ 0xE3B8,  0xDDE8 },
	{ 0xE3B9,  0xDDE9 },
	{ 0xE3BA,  0xC962 },
	{ 0xE3BB,  0xC954 },
	{ 0xE3BC,  0xC968 },
	{ 0xE3BD,  0xDDEA },
	{ 0xE3BE,  0xC956 },
	{ 0xE3BF,  0xC95F },
	{ 0xE3C0,  0xC96D },
	{ 0xE3C1,  0xC95A },
	{ 0xE3C2,  0xC950 },
	{ 0xE3C3,  0xC975 },
	{ 0xE3C4,  0xC978 },
	{ 0xE3C5,  0xC955 },
	{ 0xE3C6,  0xC961 },
	{ 0xE3C7,  0xD8E1 },
	{ 0xE3C8,  0xC960 },
	{ 0xE3C9,  0xB1CD },
	{ 0xE3CA,  0xC953 },
	{ 0xE3CB,  0xC96B },
	{ 0xE3CC,  0xC97A },
	{ 0xE3CD,  0xC959 },
	{ 0xE3CE,  0xC97E },
	{ 0xE3CF,  0xC97C },
	{ 0xE3D0,  0xC97B },
	{ 0xE3D1,  0xC983 },
	{ 0xE3D2,  0xC967 },
	{ 0xE3D3,  0xC94D },
	{ 0xE3D4,  0xCC98 },
	{ 0xE3D5,  0xCE50 },
	{ 0xE3D6,  0xF2DE },
	{ 0xE3D7,  0xCE48 },
	{ 0xE3D8,  0xCE77 },
	{ 0xE3D9,  0xCE58 },
	{ 0xE3DA,  0xF2E2 },
	{ 0xE3DB,  0xF2E0 },
	{ 0xE3DC,  0xC0AF },
	{ 0xE3DD,  0xCE40 },
	{ 0xE3DE,  0xCE41 },
	{ 0xE3DF,  0xCE5B },
	{ 0xE3E0,  0xCE4B },
	{ 0xE3E1,  0xCE59 },
	{ 0xE3E2,  0xF2E4 },
	{ 0xE3E3,  0xCE5E },
	{ 0xE3E4,  0xCE44 },
	{ 0xE3E5,  0xCE4F },
	{ 0xE3E6,  0xCE49 },
	{ 0xE3E7,  0xCE4C },
	{ 0xE3E8,  0xCE56 },
	{ 0xE3E9,  0xD1D1 },
	{ 0xE3EA,  0xCE55 },
	{ 0xE3EB,  0xF2E7 },
	{ 0xE3EC,  0xCE51 },
	{ 0xE3ED,  0xCE5A },
	{ 0xE3EE,  0xCE46 },
	{ 0xE3EF,  0xCE47 },
	{ 0xE3F0,  0xCE53 },
	{ 0xE3F1,  0xCE45 },
	{ 0xE3F2,  0xF2E3 },
	{ 0xE3F3,  0xCE4E },
	{ 0xE3F4,  0xCD9E },
	{ 0xE3F5,  0xD172 },
	{ 0xE3F6,  0xD167 },
	{ 0xE3F7,  0xF1D1 },
	{ 0xE3F8,  0xD16F },
	{ 0xE3F9,  0xD173 },
	{ 0xE3FA,  0xF1D5 },
	{ 0xE3FB,  0xD16D },
	{ 0xE3FC,  0xF1D3 },
	{ 0xE3FD,  0xD171 },
	{ 0xE3FE,  0xD174 },
	{ 0xE440,  0xF1D6 },
	{ 0xE441,  0xD16B },
	{ 0xE442,  0xD16A },
	{ 0xE443,  0xD29C },
	{ 0xE444,  0xD2A0 },
	{ 0xE445,  0xD29E },
	{ 0xE446,  0xD29D },
	{ 0xE447,  0xD370 },
	{ 0xE448,  0xF6A2 },
	{ 0xE449,  0xD36F },
	{ 0xE44A,  0xD567 },
	{ 0xE44B,  0xD555 },
	{ 0xE44C,  0xD548 },
	{ 0xE44D,  0xD54F },
	{ 0xE44E,  0xD54C },
	{ 0xE44F,  0xD552 },
	{ 0xE450,  0xD845 },
	{ 0xE451,  0xD867 },
	{ 0xE452,  0xD868 },
	{ 0xE453,  0xD967 },
	{ 0xE454,  0xD961 },
	{ 0xE455,  0xD969 },
	{ 0xE456,  0xDA74 },
	{ 0xE457,  0xF5D4 },
	{ 0xE458,  0xDB57 },
	{ 0xE459,  0xDB54 },
	{ 0xE45A,  0xDB5E },
	{ 0xE45B,  0xF5D5 },
	{ 0xE45C,  0xD3BB },
	{ 0xE45D,  0xDB58 },
	{ 0xE45E,  0xDB5B },
	{ 0xE45F,  0xDB5A },
	{ 0xE460,  0xF5BD },
	{ 0xE461,  0xDB53 },
	{ 0xE462,  0xDB55 },
	{ 0xE463,  0xDB59 },
	{ 0xE464,  0xDD6B },
	{ 0xE465,  0xDD6C },
	{ 0xE466,  0xDD69 },
	{ 0xE467,  0xDD68 },
	{ 0xE468,  0xDBB5 },
	{ 0xE469,  0xE07E },
	{ 0xE46A,  0xE082 },
	{ 0xE46B,  0xDBB3 },
	{ 0xE46C,  0xE081 },
	{ 0xE46D,  0xE080 },
	{ 0xE46E,  0xE07C },
	{ 0xE46F,  0xE084 },
	{ 0xE470,  0xE083 },
	{ 0xE471,  0xE07D },
	{ 0xE472,  0xE154 },
	{ 0xE473,  0xF5A8 },
	{ 0xE474,  0xF5AA },
	{ 0xE475,  0xE153 },
	{ 0xE476,  0xE39E },
	{ 0xE477,  0xE39D },
	{ 0xE478,  0xE36F },
	{ 0xE479,  0xE394 },
	{ 0xE47A,  0xE373 },
	{ 0xE47B,  0xE399 },
	{ 0xE47C,  0xE38D },
	{ 0xE47D,  0xE442 },
	{ 0xE47E,  0xE387 },
	{ 0xE4A1,  0xE39F },
	{ 0xE4A2,  0xE393 },
	{ 0xE4A3,  0xE443 },
	{ 0xE4A4,  0xE372 },
	{ 0xE4A5,  0xE390 },
	{ 0xE4A6,  0xE378 },
	{ 0xE4A7,  0xE39C },
	{ 0xE4A8,  0xE485 },
	{ 0xE4A9,  0xF6C6 },
	{ 0xE4AA,  0xE37B },
	{ 0xE4AB,  0xE38E },
	{ 0xE4AC,  0xE39B },
	{ 0xE4AD,  0xE376 },
	{ 0xE4AE,  0xE382 },
	{ 0xE4AF,  0xE39A },
	{ 0xE4B0,  0xE384 },
	{ 0xE4B1,  0xE380 },
	{ 0xE4B2,  0xE386 },
	{ 0xE4B3,  0xE392 },
	{ 0xE4B4,  0xE3A0 },
	{ 0xE4B5,  0xE377 },
	{ 0xE4B6,  0xE381 },
	{ 0xE4B7,  0xE441 },
	{ 0xE4B8,  0xE396 },
	{ 0xE4B9,  0xE385 },
	{ 0xE4BA,  0xE288 },
	{ 0xE4BB,  0xEB4A },
	{ 0xE4BC,  0xEB4D },
	{ 0xE4BD,  0xEB8D },
	{ 0xE4BE,  0xEC6D },
	{ 0xE4BF,  0xEC87 },
	{ 0xE4C0,  0xEC85 },
	{ 0xE4C1,  0xEC88 },
	{ 0xE4C2,  0xEC8D },
	{ 0xE4C3,  0xEC8A },
	{ 0xE4C4,  0xEC8C },
	{ 0xE4C5,  0xEC86 },
	{ 0xE4C6,  0xEC8E },
	{ 0xE4C7,  0xEC8B },
	{ 0xE4C8,  0xEC89 },
	{ 0xE4C9,  0xED69 },
	{ 0xE4CA,  0xED68 },
	{ 0xE4CB,  0xEE47 },
	{ 0xE4CC,  0xEF51 },
	{ 0xE4CD,  0xEF52 },
	{ 0xE4CE,  0xEF9B },
	{ 0xE4CF,  0xEF99 },
	{ 0xE4D0,  0xEFA0 },
	{ 0xE4D1,  0xF145 },
	{ 0xE4D2,  0xF144 },
	{ 0xE4D3,  0xF169 },
	{ 0xE4D4,  0xF15F },
	{ 0xE4D5,  0xF161 },
	{ 0xE4D6,  0xF160 },
	{ 0xE4D7,  0xF168 },
	{ 0xE4D8,  0xF163 },
	{ 0xE4D9,  0xF16D },
	{ 0xE4DA,  0xF7BA },
	{ 0xE4DB,  0xF384 },
	{ 0xE4DC,  0xF387 },
	{ 0xE4DD,  0xF46E },
	{ 0xE4DE,  0xF46F },
	{ 0xE4DF,  0xF485 },
	{ 0xE4E0,  0xF486 },
	{ 0xE4E1,  0xF484 },
	{ 0xE4E2,  0xF84E },
	{ 0xE4E3,  0xF84F },
	{ 0xE4E4,  0xF852 },
	{ 0xE4E5,  0xFB9D },
	{ 0xE4E6,  0x8377 },
	{ 0xE4E7,  0x837B },
	{ 0xE4E8,  0x83A4 },
	{ 0xE4E9,  0x8371 },
	{ 0xE4EA,  0xD9D3 },
	{ 0xE4EB,  0xD9D8 },
	{ 0xE4EC,  0x836F },
	{ 0xE4ED,  0x8376 },
	{ 0xE4EE,  0xD9D9 },
	{ 0xE4EF,  0x8382 },
	{ 0xE4F0,  0x8375 },
	{ 0xE4F1,  0x8381 },
	{ 0xE4F2,  0x84A4 },
	{ 0xE4F3,  0x84A5 },
	{ 0xE4F4,  0x84EA },
	{ 0xE4F5,  0x84E9 },
	{ 0xE4F6,  0x876D },
	{ 0xE4F7,  0x8767 },
	{ 0xE4F8,  0xE0E1 },
	{ 0xE4F9,  0x875E },
	{ 0xE4FA,  0x8766 },
	{ 0xE4FB,  0x876F },
	{ 0xE4FC,  0x876E },
	{ 0xE4FD,  0x876B },
	{ 0xE4FE,  0xE0D9 },
	{ 0xE540,  0x8778 },
	{ 0xE541,  0x8765 },
	{ 0xE542,  0x875D },
	{ 0xE543,  0x8763 },
	{ 0xE544,  0xE0DC },
	{ 0xE545,  0x8764 },
	{ 0xE546,  0x8760 },
	{ 0xE547,  0x8758 },
	{ 0xE548,  0x8761 },
	{ 0xE549,  0x8848 },
	{ 0xE54A,  0x8996 },
	{ 0xE54B,  0x898C },
	{ 0xE54C,  0x899C },
	{ 0xE54D,  0x898D },
	{ 0xE54E,  0x8990 },
	{ 0xE54F,  0x899A },
	{ 0xE550,  0x8997 },
	{ 0xE551,  0x8992 },
	{ 0xE552,  0x898E },
	{ 0xE553,  0x89DD },
	{ 0xE554,  0x8BBD },
	{ 0xE555,  0x8BB2 },
	{ 0xE556,  0x8BBB },
	{ 0xE557,  0x8BB5 },
	{ 0xE558,  0x8BB4 },
	{ 0xE559,  0x8BC1 },
	{ 0xE55A,  0x8BB6 },
	{ 0xE55B,  0x8BC0 },
	{ 0xE55C,  0x8BB7 },
	{ 0xE55D,  0x8BBF },
	{ 0xE55E,  0x8BC5 },
	{ 0xE55F,  0x8BC3 },
	{ 0xE560,  0x8BCC },
	{ 0xE561,  0x8CD4 },
	{ 0xE562,  0xE1D7 },
	{ 0xE563,  0x8DF7 },
	{ 0xE564,  0x8DFD },
	{ 0xE565,  0x8DF2 },
	{ 0xE566,  0x8E41 },
	{ 0xE567,  0x8DF3 },
	{ 0xE568,  0x8DF5 },
	{ 0xE569,  0x8DFE },
	{ 0xE56A,  0x8DFB },
	{ 0xE56B,  0x8E40 },
	{ 0xE56C,  0x8DF9 },
	{ 0xE56D,  0x8DFC },
	{ 0xE56E,  0x8ECB },
	{ 0xE56F,  0x8EC2 },
	{ 0xE570,  0x8EC4 },
	{ 0xE571,  0x8EC1 },
	{ 0xE572,  0xBE99 },
	{ 0xE573,  0xE2DC },
	{ 0xE574,  0x8F51 },
	{ 0xE575,  0x8F54 },
	{ 0xE576,  0x8F98 },
	{ 0xE577,  0x8FD3 },
	{ 0xE578,  0xB1EF },
	{ 0xE579,  0x916F },
	{ 0xE57A,  0x9165 },
	{ 0xE57B,  0x9196 },
	{ 0xE57C,  0x9195 },
	{ 0xE57D,  0x918B },
	{ 0xE57E,  0x9175 },
	{ 0xE5A1,  0x9185 },
	{ 0xE5A2,  0x917D },
	{ 0xE5A3,  0x9194 },
	{ 0xE5A4,  0x9192 },
	{ 0xE5A5,  0x9188 },
	{ 0xE5A6,  0x917C },
	{ 0xE5A7,  0x9190 },
	{ 0xE5A8,  0x918A },
	{ 0xE5A9,  0x9178 },
	{ 0xE5AA,  0x9157 },
	{ 0xE5AB,  0x9198 },
	{ 0xE5AC,  0x91EE },
	{ 0xE5AD,  0x93B3 },
	{ 0xE5AE,  0x93B5 },
	{ 0xE5AF,  0xDEFE },
	{ 0xE5B0,  0x93D8 },
	{ 0xE5B1,  0xBEEF },
	{ 0xE5B2,  0x93D1 },
	{ 0xE5B3,  0x93D5 },
	{ 0xE5B4,  0x93CD },
	{ 0xE5B5,  0x93C9 },
	{ 0xE5B6,  0x93C8 },
	{ 0xE5B7,  0x93CA },
	{ 0xE5B8,  0x93DB },
	{ 0xE5B9,  0x93D7 },
	{ 0xE5BA,  0x93AF },
	{ 0xE5BB,  0x93E3 },
	{ 0xE5BC,  0x93D2 },
	{ 0xE5BD,  0x94B4 },
	{ 0xE5BE,  0x94B7 },
	{ 0xE5BF,  0x94B6 },
	{ 0xE5C0,  0x94B8 },
	{ 0xE5C1,  0x94DB },
	{ 0xE5C2,  0x94DC },
	{ 0xE5C3,  0x95C2 },
	{ 0xE5C4,  0x95BE },
	{ 0xE5C5,  0x95B8 },
	{ 0xE5C6,  0x95C0 },
	{ 0xE5C7,  0x95C4 },
	{ 0xE5C8,  0x95B9 },
	{ 0xE5C9,  0x95BD },
	{ 0xE5CA,  0x98B5 },
	{ 0xE5CB,  0x98BB },
	{ 0xE5CC,  0xE9CB },
	{ 0xE5CD,  0x989E },
	{ 0xE5CE,  0x98AF },
	{ 0xE5CF,  0x98C9 },
	{ 0xE5D0,  0x98A9 },
	{ 0xE5D1,  0x989D },
	{ 0xE5D2,  0x98D1 },
	{ 0xE5D3,  0xE9C8 },
	{ 0xE5D4,  0x98A5 },
	{ 0xE5D5,  0x989B },
	{ 0xE5D6,  0x98CD },
	{ 0xE5D7,  0x98CF },
	{ 0xE5D8,  0x98B4 },
	{ 0xE5D9,  0x98D7 },
	{ 0xE5DA,  0xE9CE },
	{ 0xE5DB,  0x98A6 },
	{ 0xE5DC,  0x98C8 },
	{ 0xE5DD,  0x98AE },
	{ 0xE5DE,  0x98A0 },
	{ 0xE5DF,  0x98E9 },
	{ 0xE5E0,  0x98BD },
	{ 0xE5E1,  0x989F },
	{ 0xE5E2,  0x98B2 },
	{ 0xE5E3,  0x98C1 },
	{ 0xE5E4,  0x98B3 },
	{ 0xE5E5,  0x98A4 },
	{ 0xE5E6,  0x98BE },
	{ 0xE5E7,  0x98B9 },
	{ 0xE5E8,  0xE9CC },
	{ 0xE5E9,  0x98D5 },
	{ 0xE5EA,  0x98C3 },
	{ 0xE5EB,  0x98AD },
	{ 0xE5EC,  0x98D6 },
	{ 0xE5ED,  0x98BC },
	{ 0xE5EE,  0x98AB },
	{ 0xE5EF,  0x98CA },
	{ 0xE5F0,  0x9A58 },
	{ 0xE5F1,  0x9A92 },
	{ 0xE5F2,  0x9A90 },
	{ 0xE5F3,  0x9A8F },
	{ 0xE5F4,  0x9A93 },
	{ 0xE5F5,  0x9AD2 },
	{ 0xE5F6,  0x9AD1 },
	{ 0xE5F7,  0x9AD0 },
	{ 0xE5F8,  0x9AD3 },
	{ 0xE5F9,  0x9D7D },
	{ 0xE5FA,  0x9D6B },
	{ 0xE5FB,  0x9DAB },
	{ 0xE5FC,  0x9DB3 },
	{ 0xE5FD,  0x9DE5 },
	{ 0xE5FE,  0x9DB9 },
	{ 0xE640,  0xE4F8 },
	{ 0xE641,  0xE4F7 },
	{ 0xE642,  0xE4F9 },
	{ 0xE643,  0xE4EA },
	{ 0xE644,  0x9D88 },
	{ 0xE645,  0x9DB1 },
	{ 0xE646,  0x9D92 },
	{ 0xE647,  0x9DBD },
	{ 0xE648,  0x9DA6 },
	{ 0xE649,  0x9DA0 },
	{ 0xE64A,  0x9DAF },
	{ 0xE64B,  0x9D8E },
	{ 0xE64C,  0xE4FB },
	{ 0xE64D,  0x9D8B },
	{ 0xE64E,  0x9D89 },
	{ 0xE64F,  0x9D90 },
	{ 0xE650,  0x9DBB },
	{ 0xE651,  0x9DBA },
	{ 0xE652,  0x9D94 },
	{ 0xE653,  0x9D4E },
	{ 0xE654,  0x9D97 },
	{ 0xE655,  0x9D9F },
	{ 0xE656,  0x9DAA },
	{ 0xE657,  0x9D9B },
	{ 0xE658,  0x9DB7 },
	{ 0xE659,  0x9D8C },
	{ 0xE65A,  0x9DB5 },
	{ 0xE65B,  0x9D9D },
	{ 0xE65C,  0x9DAC },
	{ 0xE65D,  0x9DBC },
	{ 0xE65E,  0x9D98 },
	{ 0xE65F,  0x9DA7 },
	{ 0xE660,  0x9D9E },
	{ 0xE661,  0x9DA9 },
	{ 0xE662,  0x9FE2 },
	{ 0xE663,  0x9FDF },
	{ 0xE664,  0x9FCF },
	{ 0xE665,  0x9FE0 },
	{ 0xE666,  0xECDA },
	{ 0xE667,  0x9FCE },
	{ 0xE668,  0x9FDA },
	{ 0xE669,  0xECD8 },
	{ 0xE66A,  0x9FD1 },
	{ 0xE66B,  0x9FD7 },
	{ 0xE66C,  0x9FD2 },
	{ 0xE66D,  0x9FD6 },
	{ 0xE66E,  0x9FD3 },
	{ 0xE66F,  0x9FDB },
	{ 0xE670,  0x9FD0 },
	{ 0xE671,  0x9FD9 },
	{ 0xE672,  0xECD7 },
	{ 0xE673,  0xA0D0 },
	{ 0xE674,  0xA0D2 },
	{ 0xE675,  0xAA8B },
	{ 0xE676,  0xE9E1 },
	{ 0xE677,  0xAA91 },
	{ 0xE678,  0xAA92 },
	{ 0xE679,  0xE2B2 },
	{ 0xE67A,  0xAA90 },
	{ 0xE67B,  0xAA8E },
	{ 0xE67C,  0xAA93 },
	{ 0xE67D,  0xAA8D },
	{ 0xE67E,  0xAA8C },
	{ 0xE6A1,  0xAA94 },
	{ 0xE6A2,  0xE8AF },
	{ 0xE6A3,  0xAD49 },
	{ 0xE6A4,  0xAD4A },
	{ 0xE6A5,  0xAD47 },
	{ 0xE6A6,  0xE8AE },
	{ 0xE6A7,  0xAD42 },
	{ 0xE6A8,  0xAD46 },
	{ 0xE6A9,  0xAD48 },
	{ 0xE6AA,  0xAD41 },
	{ 0xE6AB,  0xAC9F },
	{ 0xE6AC,  0xAE50 },
	{ 0xE6AD,  0xAE4F },
	{ 0xE6AE,  0xAE9A },
	{ 0xE6AF,  0xF0FB },
	{ 0xE6B0,  0xAF8E },
	{ 0xE6B1,  0xF0FE },
	{ 0xE6B2,  0xAF8D },
	{ 0xE6B3,  0xAF8C },
	{ 0xE6B4,  0xAF90 },
	{ 0xE6B5,  0xAF8B },
	{ 0xE6B6,  0xAF92 },
	{ 0xE6B7,  0xF1A1 },
	{ 0xE6B8,  0xB080 },
	{ 0xE6B9,  0xB081 },
	{ 0xE6BA,  0xB082 },
	{ 0xE6BB,  0xB07E },
	{ 0xE6BC,  0xEEA4 },
	{ 0xE6BD,  0xB260 },
	{ 0xE6BE,  0xB25D },
	{ 0xE6BF,  0xB25C },
	{ 0xE6C0,  0xB46C },
	{ 0xE6C1,  0xB460 },
	{ 0xE6C2,  0xB46E },
	{ 0xE6C3,  0xB46B },
	{ 0xE6C4,  0xB46F },
	{ 0xE6C5,  0xB46D },
	{ 0xE6C6,  0xEDDD },
	{ 0xE6C7,  0xB46A },
	{ 0xE6C8,  0xB466 },
	{ 0xE6C9,  0xB467 },
	{ 0xE6CA,  0xEDDF },
	{ 0xE6CB,  0xECFA },
	{ 0xE6CC,  0xB64D },
	{ 0xE6CD,  0xB64C },
	{ 0xE6CE,  0xB648 },
	{ 0xE6CF,  0xB64E },
	{ 0xE6D0,  0xB647 },
	{ 0xE6D1,  0x9A75 },
	{ 0xE6D2,  0xF0A1 },
	{ 0xE6D3,  0xB84A },
	{ 0xE6D4,  0xB84B },
	{ 0xE6D5,  0xF1C1 },
	{ 0xE6D6,  0xB995 },
	{ 0xE6D7,  0xBA44 },
	{ 0xE6D8,  0xB99B },
	{ 0xE6D9,  0xF3E8 },
	{ 0xE6DA,  0xBA46 },
	{ 0xE6DB,  0xB98F },
	{ 0xE6DC,  0xB996 },
	{ 0xE6DD,  0xBA43 },
	{ 0xE6DE,  0xB993 },
	{ 0xE6DF,  0xF4DB },
	{ 0xE6E0,  0xF4DA },
	{ 0xE6E1,  0xF4D8 },
	{ 0xE6E2,  0xBC47 },
	{ 0xE6E3,  0xBE9D },
	{ 0xE6E4,  0xBE81 },
	{ 0xE6E5,  0xBE90 },
	{ 0xE6E6,  0xBE8D },
	{ 0xE6E7,  0xBE7C },
	{ 0xE6E8,  0xBE87 },
	{ 0xE6E9,  0xBF48 },
	{ 0xE6EA,  0xBEA0 },
	{ 0xE6EB,  0xBE8C },
	{ 0xE6EC,  0xBE9C },
	{ 0xE6ED,  0xBE97 },
	{ 0xE6EE,  0xBE96 },
	{ 0xE6EF,  0xBE94 },
	{ 0xE6F0,  0xBE85 },
	{ 0xE6F1,  0xC153 },
	{ 0xE6F2,  0xC17B },
	{ 0xE6F3,  0xF4CA },
	{ 0xE6F4,  0xC17C },
	{ 0xE6F5,  0xC246 },
	{ 0xE6F6,  0xC244 },
	{ 0xE6F7,  0xC243 },
	{ 0xE6F8,  0xC245 },
	{ 0xE6F9,  0xF4E5 },
	{ 0xE6FA,  0xC242 },
	{ 0xE6FB,  0xC28A },
	{ 0xE6FC,  0xC28D },
	{ 0xE6FD,  0xEBF9 },
	{ 0xE6FE,  0xC479 },
	{ 0xE740,  0xC478 },
	{ 0xE741,  0xC473 },
	{ 0xE742,  0xC47C },
	{ 0xE743,  0xC476 },
	{ 0xE744,  0xC475 },
	{ 0xE745,  0xC56D },
	{ 0xE746,  0xF4BC },
	{ 0xE747,  0xC58E },
	{ 0xE748,  0xC58D },
	{ 0xE749,  0xC58B },
	{ 0xE74A,  0xC58A },
	{ 0xE74B,  0xC58C },
	{ 0xE74C,  0xCA5A },
	{ 0xE74D,  0xDEA2 },
	{ 0xE74E,  0xCA4B },
	{ 0xE74F,  0xC99E },
	{ 0xE750,  0xCA5F },
	{ 0xE751,  0xCA4A },
	{ 0xE752,  0xCA46 },
	{ 0xE753,  0xCA49 },
	{ 0xE754,  0xDDFD },
	{ 0xE755,  0xCA47 },
	{ 0xE756,  0xCA5D },
	{ 0xE757,  0xCA54 },
	{ 0xE758,  0xC99B },
	{ 0xE759,  0xC4E8 },
	{ 0xE75A,  0xC99A },
	{ 0xE75B,  0xCA45 },
	{ 0xE75C,  0xDDF8 },
	{ 0xE75D,  0xC994 },
	{ 0xE75E,  0xCA60 },
	{ 0xE75F,  0xC992 },
	{ 0xE760,  0xCA4F },
	{ 0xE761,  0xC997 },
	{ 0xE762,  0xC98D },
	{ 0xE763,  0xC993 },
	{ 0xE764,  0xDEA4 },
	{ 0xE765,  0xCA4D },
	{ 0xE766,  0xC98C },
	{ 0xE767,  0xC98B },
	{ 0xE768,  0xCA50 },
	{ 0xE769,  0xC99D },
	{ 0xE76A,  0xCA5E },
	{ 0xE76B,  0xCA55 },
	{ 0xE76C,  0xCA62 },
	{ 0xE76D,  0xC9A0 },
	{ 0xE76E,  0xC99C },
	{ 0xE76F,  0xCA56 },
	{ 0xE770,  0xC996 },
	{ 0xE771,  0xCA65 },
	{ 0xE772,  0xCA5C },
	{ 0xE773,  0xC989 },
	{ 0xE774,  0xC98A },
	{ 0xE775,  0xDDFB },
	{ 0xE776,  0xC990 },
	{ 0xE777,  0xC999 },
	{ 0xE778,  0xCA51 },
	{ 0xE779,  0xCA57 },
	{ 0xE77A,  0xCA64 },
	{ 0xE77B,  0xCA48 },
	{ 0xE77C,  0xCA52 },
	{ 0xE77D,  0xCA63 },
	{ 0xE77E,  0xEBBD },
	{ 0xE7A1,  0xCE68 },
	{ 0xE7A2,  0xF2F6 },
	{ 0xE7A3,  0xF2F8 },
	{ 0xE7A4,  0xCE80 },
	{ 0xE7A5,  0xCF6A },
	{ 0xE7A6,  0xCE7D },
	{ 0xE7A7,  0xCE69 },
	{ 0xE7A8,  0xCE66 },
	{ 0xE7A9,  0xCE6B },
	{ 0xE7AA,  0xCE65 },
	{ 0xE7AB,  0xCE70 },
	{ 0xE7AC,  0xCE6A },
	{ 0xE7AD,  0xCE64 },
	{ 0xE7AE,  0xCE6E },
	{ 0xE7AF,  0xCE79 },
	{ 0xE7B0,  0xCE76 },
	{ 0xE7B1,  0xCE63 },
	{ 0xE7B2,  0xD0AB },
	{ 0xE7B3,  0xCE6F },
	{ 0xE7B4,  0xCE6D },
	{ 0xE7B5,  0xCE7A },
	{ 0xE7B6,  0xCE78 },
	{ 0xE7B7,  0xCE83 },
	{ 0xE7B8,  0xF2F3 },
	{ 0xE7B9,  0xCE6C },
	{ 0xE7BA,  0xF2FA },
	{ 0xE7BB,  0xCE62 },
	{ 0xE7BC,  0xF2EF },
	{ 0xE7BD,  0xCE7E },
	{ 0xE7BE,  0xCE71 },
	{ 0xE7BF,  0xCE73 },
	{ 0xE7C0,  0xCE75 },
	{ 0xE7C1,  0xD06B },
	{ 0xE7C2,  0xD17B },
	{ 0xE7C3,  0xD182 },
	{ 0xE7C4,  0xD187 },
	{ 0xE7C5,  0xD181 },
	{ 0xE7C6,  0xD18A },
	{ 0xE7C7,  0xD18B },
	{ 0xE7C8,  0xF1D8 },
	{ 0xE7C9,  0xD17C },
	{ 0xE7CA,  0xD189 },
	{ 0xE7CB,  0xD186 },
	{ 0xE7CC,  0xD184 },
	{ 0xE7CD,  0xD180 },
	{ 0xE7CE,  0xD340 },
	{ 0xE7CF,  0xD342 },
	{ 0xE7D0,  0xD341 },
	{ 0xE7D1,  0xD373 },
	{ 0xE7D2,  0xD375 },
	{ 0xE7D3,  0xD372 },
	{ 0xE7D4,  0xD58C },
	{ 0xE7D5,  0xD583 },
	{ 0xE7D6,  0xD574 },
	{ 0xE7D7,  0xD590 },
	{ 0xE7D8,  0xD58E },
	{ 0xE7D9,  0xD591 },
	{ 0xE7DA,  0xD592 },
	{ 0xE7DB,  0xD577 },
	{ 0xE7DC,  0xD594 },
	{ 0xE7DD,  0xD57A },
	{ 0xE7DE,  0xD57C },
	{ 0xE7DF,  0xD582 },
	{ 0xE7E0,  0xD595 },
	{ 0xE7E1,  0xD580 },
	{ 0xE7E2,  0xD576 },
	{ 0xE7E3,  0xD579 },
	{ 0xE7E4,  0xD596 },
	{ 0xE7E5,  0xD846 },
	{ 0xE7E6,  0xD850 },
	{ 0xE7E7,  0xD884 },
	{ 0xE7E8,  0xD977 },
	{ 0xE7E9,  0xD971 },
	{ 0xE7EA,  0xD96B },
	{ 0xE7EB,  0xD97A },
	{ 0xE7EC,  0xD96C },
	{ 0xE7ED,  0xD96F },
	{ 0xE7EE,  0xD979 },
	{ 0xE7EF,  0xDA7D },
	{ 0xE7F0,  0xDA7A },
	{ 0xE7F1,  0xDA7E },
	{ 0xE7F2,  0xDA79 },
	{ 0xE7F3,  0xDB6C },
	{ 0xE7F4,  0xF5DB },
	{ 0xE7F5,  0xDB6F },
	{ 0xE7F6,  0xDB6E },
	{ 0xE7F7,  0xF5DA },
	{ 0xE7F8,  0xDB64 },
	{ 0xE7F9,  0xDB6A },
	{ 0xE7FA,  0xDB65 },
	{ 0xE7FB,  0xDB61 },
	{ 0xE7FC,  0xDB68 },
	{ 0xE7FD,  0xDB70 },
	{ 0xE7FE,  0xDB71 },
	{ 0xE840,  0xF5D6 },
	{ 0xE841,  0xDB62 },
	{ 0xE842,  0xDB67 },
	{ 0xE843,  0xDB63 },
	{ 0xE844,  0xDB6B },
	{ 0xE845,  0xDB66 },
	{ 0xE846,  0xDB69 },
	{ 0xE847,  0xDD88 },
	{ 0xE848,  0xDD80 },
	{ 0xE849,  0xDD73 },
	{ 0xE84A,  0xDD75 },
	{ 0xE84B,  0xDD7B },
	{ 0xE84C,  0xDD7E },
	{ 0xE84D,  0xDD71 },
	{ 0xE84E,  0xDD72 },
	{ 0xE84F,  0xDF75 },
	{ 0xE850,  0xDF72 },
	{ 0xE851,  0xDF71 },
	{ 0xE852,  0xDF6C },
	{ 0xE853,  0xDF6F },
	{ 0xE854,  0xDBB7 },
	{ 0xE855,  0xE08B },
	{ 0xE856,  0xE089 },
	{ 0xE857,  0xE08A },
	{ 0xE858,  0xE090 },
	{ 0xE859,  0xE086 },
	{ 0xE85A,  0xE08E },
	{ 0xE85B,  0xF5AC },
	{ 0xE85C,  0xE15C },
	{ 0xE85D,  0xE15E },
	{ 0xE85E,  0xE158 },
	{ 0xE85F,  0xE159 },
	{ 0xE860,  0xE15B },
	{ 0xE861,  0xE157 },
	{ 0xE862,  0xE466 },
	{ 0xE863,  0xE45A },
	{ 0xE864,  0xE45B },
	{ 0xE865,  0xE457 },
	{ 0xE866,  0xE46F },
	{ 0xE867,  0xE44D },
	{ 0xE868,  0xE465 },
	{ 0xE869,  0xE488 },
	{ 0xE86A,  0xE475 },
	{ 0xE86B,  0xE46E },
	{ 0xE86C,  0xE480 },
	{ 0xE86D,  0xE46D },
	{ 0xE86E,  0xE473 },
	{ 0xE86F,  0xE462 },
	{ 0xE870,  0xE486 },
	{ 0xE871,  0xE459 },
	{ 0xE872,  0xE47E },
	{ 0xE873,  0xE460 },
	{ 0xE874,  0xF6C8 },
	{ 0xE875,  0xE464 },
	{ 0xE876,  0xE47C },
	{ 0xE877,  0xE463 },
	{ 0xE878,  0xE46B },
	{ 0xE879,  0xE45F },
	{ 0xE87A,  0xE476 },
	{ 0xE87B,  0xE474 },
	{ 0xE87C,  0xE47D },
	{ 0xE87D,  0xE467 },
	{ 0xE87E,  0xE469 },
	{ 0xE8A1,  0xE44C },
	{ 0xE8A2,  0xE477 },
	{ 0xE8A3,  0xE45D },
	{ 0xE8A4,  0xE44B },
	{ 0xE8A5,  0xE951 },
	{ 0xE8A6,  0xE981 },
	{ 0xE8A7,  0xE980 },
	{ 0xE8A8,  0xE983 },
	{ 0xE8A9,  0xE985 },
	{ 0xE8AA,  0xEB50 },
	{ 0xE8AB,  0xEB4E },
	{ 0xE8AC,  0xEB6B },
	{ 0xE8AD,  0xEB90 },
	{ 0xE8AE,  0xF6AC },
	{ 0xE8AF,  0xEB8E },
	{ 0xE8B0,  0xEC6E },
	{ 0xE8B1,  0xEC93 },
	{ 0xE8B2,  0xEC95 },
	{ 0xE8B3,  0xEC91 },
	{ 0xE8B4,  0xED6B },
	{ 0xE8B5,  0xED6A },
	{ 0xE8B6,  0xEE4F },
	{ 0xE8B7,  0xEE4E },
	{ 0xE8B8,  0xEE57 },
	{ 0xE8B9,  0xEE5A },
	{ 0xE8BA,  0xEE59 },
	{ 0xE8BB,  0xEE51 },
	{ 0xE8BC,  0xEE4C },
	{ 0xE8BD,  0xEE58 },
	{ 0xE8BE,  0xEF56 },
	{ 0xE8BF,  0xF040 },
	{ 0xE8C0,  0xEF93 },
	{ 0xE8C1,  0xF047 },
	{ 0xE8C2,  0xF04A },
	{ 0xE8C3,  0xF04C },
	{ 0xE8C4,  0xF04D },
	{ 0xE8C5,  0xF04B },
	{ 0xE8C6,  0xF183 },
	{ 0xE8C7,  0xF173 },
	{ 0xE8C8,  0xF175 },
	{ 0xE8C9,  0xF179 },
	{ 0xE8CA,  0xF17A },
	{ 0xE8CB,  0xF174 },
	{ 0xE8CC,  0xF16F },
	{ 0xE8CD,  0xF17C },
	{ 0xE8CE,  0xF17E },
	{ 0xE8CF,  0xF171 },
	{ 0xE8D0,  0xF17D },
	{ 0xE8D1,  0xF172 },
	{ 0xE8D2,  0xF363 },
	{ 0xE8D3,  0xF38B },
	{ 0xE8D4,  0xF7D8 },
	{ 0xE8D5,  0xF390 },
	{ 0xE8D6,  0xF38F },
	{ 0xE8D7,  0xF38E },
	{ 0xE8D8,  0xF471 },
	{ 0xE8D9,  0xF7C9 },
	{ 0xE8DA,  0xF48C },
	{ 0xE8DB,  0xF499 },
	{ 0xE8DC,  0xF496 },
	{ 0xE8DD,  0xF48B },
	{ 0xE8DE,  0xF49B },
	{ 0xE8DF,  0xF49A },
	{ 0xE8E0,  0xF495 },
	{ 0xE8E1,  0xF48D },
	{ 0xE8E2,  0xF489 },
	{ 0xE8E3,  0xF491 },
	{ 0xE8E4,  0xF859 },
	{ 0xE8E5,  0xF857 },
	{ 0xE8E6,  0xF85A },
	{ 0xE8E7,  0xF85C },
	{ 0xE8E8,  0xF854 },
	{ 0xE8E9,  0xF864 },
	{ 0xE8EA,  0xF85D },
	{ 0xE8EB,  0xF856 },
	{ 0xE8EC,  0xF858 },
	{ 0xE8ED,  0xF865 },
	{ 0xE8EE,  0xF862 },
	{ 0xE8EF,  0xF861 },
	{ 0xE8F0,  0xFB81 },
	{ 0xE8F1,  0xFC5D },
	{ 0xE8F2,  0xFC86 },
	{ 0xE8F3,  0xD8BE },
	{ 0xE8F4,  0x8391 },
	{ 0xE8F5,  0x8388 },
	{ 0xE8F6,  0x838C },
	{ 0xE8F7,  0x838F },
	{ 0xE8F8,  0x8387 },
	{ 0xE8F9,  0x8444 },
	{ 0xE8FA,  0x8557 },
	{ 0xE8FB,  0x85B1 },
	{ 0xE8FC,  0x8787 },
	{ 0xE8FD,  0x877D },
	{ 0xE8FE,  0x8785 },
	{ 0xE940,  0x8789 },
	{ 0xE941,  0x8782 },
	{ 0xE942,  0x8780 },
	{ 0xE943,  0x8784 },
	{ 0xE944,  0x8788 },
	{ 0xE945,  0x877B },
	{ 0xE946,  0x878C },
	{ 0xE947,  0xE0F7 },
	{ 0xE948,  0x8849 },
	{ 0xE949,  0x89B0 },
	{ 0xE94A,  0x89A7 },
	{ 0xE94B,  0x89B1 },
	{ 0xE94C,  0x89A9 },
	{ 0xE94D,  0x89A5 },
	{ 0xE94E,  0x89AB },
	{ 0xE94F,  0xDBD4 },
	{ 0xE950,  0x89AE },
	{ 0xE951,  0xE6D3 },
	{ 0xE952,  0x8BD4 },
	{ 0xE953,  0x8BD6 },
	{ 0xE954,  0x8BDC },
	{ 0xE955,  0x8BD1 },
	{ 0xE956,  0x8BD0 },
	{ 0xE957,  0x8BCD },
	{ 0xE958,  0xE6D4 },
	{ 0xE959,  0x8BE3 },
	{ 0xE95A,  0x8BD5 },
	{ 0xE95B,  0x8BDB },
	{ 0xE95C,  0x8BD9 },
	{ 0xE95D,  0x8C94 },
	{ 0xE95E,  0x8E4B },
	{ 0xE95F,  0x8E50 },
	{ 0xE960,  0x8E48 },
	{ 0xE961,  0x8E46 },
	{ 0xE962,  0x8E54 },
	{ 0xE963,  0x8E4F },
	{ 0xE964,  0x8E4D },
	{ 0xE965,  0x8E49 },
	{ 0xE966,  0x8E47 },
	{ 0xE967,  0x8E51 },
	{ 0xE968,  0x8E4C },
	{ 0xE969,  0x8E4E },
	{ 0xE96A,  0x8E53 },
	{ 0xE96B,  0x8EC9 },
	{ 0xE96C,  0x8ECA },
	{ 0xE96D,  0x8EC8 },
	{ 0xE96E,  0x8ED1 },
	{ 0xE96F,  0x8F5B },
	{ 0xE970,  0x8F5A },
	{ 0xE971,  0x8F59 },
	{ 0xE972,  0xE2DD },
	{ 0xE973,  0x8F58 },
	{ 0xE974,  0x8F9A },
	{ 0xE975,  0xE1E8 },
	{ 0xE976,  0xEDAD },
	{ 0xE977,  0xBAA9 },
	{ 0xE978,  0x9180 },
	{ 0xE979,  0x91A7 },
	{ 0xE97A,  0x9199 },
	{ 0xE97B,  0x91A8 },
	{ 0xE97C,  0x91A4 },
	{ 0xE97D,  0x91AB },
	{ 0xE97E,  0x919E },
	{ 0xE9A1,  0x91A2 },
	{ 0xE9A2,  0x919C },
	{ 0xE9A3,  0x9177 },
	{ 0xE9A4,  0xDFA8 },
	{ 0xE9A5,  0x93FC },
	{ 0xE9A6,  0xDFA7 },
	{ 0xE9A7,  0x93F7 },
	{ 0xE9A8,  0x93F3 },
	{ 0xE9A9,  0x93EA },
	{ 0xE9AA,  0x93C7 },
	{ 0xE9AB,  0x93EE },
	{ 0xE9AC,  0x9440 },
	{ 0xE9AD,  0x9454 },
	{ 0xE9AE,  0x93FD },
	{ 0xE9AF,  0x948D },
	{ 0xE9B0,  0x94BC },
	{ 0xE9B1,  0x94B9 },
	{ 0xE9B2,  0x94D3 },
	{ 0xE9B3,  0x95D3 },
	{ 0xE9B4,  0xEAD5 },
	{ 0xE9B5,  0x95CB },
	{ 0xE9B6,  0x95D5 },
	{ 0xE9B7,  0x95D6 },
	{ 0xE9B8,  0x95DA },
	{ 0xE9B9,  0x95C9 },
	{ 0xE9BA,  0x95C7 },
	{ 0xE9BB,  0x95C6 },
	{ 0xE9BC,  0x95D7 },
	{ 0xE9BD,  0x9653 },
	{ 0xE9BE,  0x98E0 },
	{ 0xE9BF,  0x9948 },
	{ 0xE9C0,  0x98F0 },
	{ 0xE9C1,  0x9949 },
	{ 0xE9C2,  0x98DE },
	{ 0xE9C3,  0x994A },
	{ 0xE9C4,  0xE9D0 },
	{ 0xE9C5,  0x9941 },
	{ 0xE9C6,  0x994F },
	{ 0xE9C7,  0x9957 },
	{ 0xE9C8,  0xE9D3 },
	{ 0xE9C9,  0x98F7 },
	{ 0xE9CA,  0xE9D8 },
	{ 0xE9CB,  0x98FE },
	{ 0xE9CC,  0x98E6 },
	{ 0xE9CD,  0x98E8 },
	{ 0xE9CE,  0x98EA },
	{ 0xE9CF,  0x994C },
	{ 0xE9D0,  0x9947 },
	{ 0xE9D1,  0xE9D2 },
	{ 0xE9D2,  0x98F6 },
	{ 0xE9D3,  0x98FA },
	{ 0xE9D4,  0x9951 },
	{ 0xE9D5,  0x994B },
	{ 0xE9D6,  0x9944 },
	{ 0xE9D7,  0x98E7 },
	{ 0xE9D8,  0x9942 },
	{ 0xE9D9,  0x98FC },
	{ 0xE9DA,  0x98FB },
	{ 0xE9DB,  0x98F4 },
	{ 0xE9DC,  0x98F5 },
	{ 0xE9DD,  0x98EE },
	{ 0xE9DE,  0x9A5C },
	{ 0xE9DF,  0x9A5B },
	{ 0xE9E0,  0x9A5D },
	{ 0xE9E1,  0x9A94 },
	{ 0xE9E2,  0xE9EC },
	{ 0xE9E3,  0x9A97 },
	{ 0xE9E4,  0x9AAC },
	{ 0xE9E5,  0x9AAB },
	{ 0xE9E6,  0x9AD5 },
	{ 0xE9E7,  0x9AD4 },
	{ 0xE9E8,  0xEBAB },
	{ 0xE9E9,  0x9DD1 },
	{ 0xE9EA,  0x9DE9 },
	{ 0xE9EB,  0x9DC8 },
	{ 0xE9EC,  0x9DE6 },
	{ 0xE9ED,  0x9DDD },
	{ 0xE9EE,  0x9DEC },
	{ 0xE9EF,  0x9DE7 },
	{ 0xE9F0,  0xC2BA },
	{ 0xE9F1,  0x9DE3 },
	{ 0xE9F2,  0x9DDE },
	{ 0xE9F3,  0x9DC4 },
	{ 0xE9F4,  0x9DE8 },
	{ 0xE9F5,  0x9DCC },
	{ 0xE9F6,  0x9E5C },
	{ 0xE9F7,  0x9DCA },
	{ 0xE9F8,  0x9DD2 },
	{ 0xE9F9,  0x9DDB },
	{ 0xE9FA,  0x9DD0 },
	{ 0xE9FB,  0x9DCE },
	{ 0xE9FC,  0x9DED },
	{ 0xE9FD,  0x9DE0 },
	{ 0xE9FE,  0x9DDA },
	{ 0xEA40,  0x9DC7 },
	{ 0xEA41,  0xE5A1 },
	{ 0xEA42,  0x9DCF },
	{ 0xEA43,  0x9DEB },
	{ 0xEA44,  0x9DD3 },
	{ 0xEA45,  0x9DD6 },
	{ 0xEA46,  0x9DD4 },
	{ 0xEA47,  0x9FF1 },
	{ 0xEA48,  0x9FEF },
	{ 0xEA49,  0x9FEC },
	{ 0xEA4A,  0x9FE6 },
	{ 0xEA4B,  0xA040 },
	{ 0xEA4C,  0x9FED },
	{ 0xEA4D,  0x9FEE },
	{ 0xEA4E,  0x9FF7 },
	{ 0xEA4F,  0xECDC },
	{ 0xEA50,  0x9FF6 },
	{ 0xEA51,  0x9FF3 },
	{ 0xEA52,  0x9FFA },
	{ 0xEA53,  0x9FEA },
	{ 0xEA54,  0xA042 },
	{ 0xEA55,  0x9FE9 },
	{ 0xEA56,  0x9FF2 },
	{ 0xEA57,  0xA044 },
	{ 0xEA58,  0xA045 },
	{ 0xEA59,  0xA0D5 },
	{ 0xEA5A,  0xA0D6 },
	{ 0xEA5B,  0xAA9B },
	{ 0xEA5C,  0xAA98 },
	{ 0xEA5D,  0xAA99 },
	{ 0xEA5E,  0xE2B3 },
	{ 0xEA5F,  0xAA97 },
	{ 0xEA60,  0xAA9D },
	{ 0xEA61,  0xAA9C },
	{ 0xEA62,  0xAD43 },
	{ 0xEA63,  0xAD57 },
	{ 0xEA64,  0xAD5B },
	{ 0xEA65,  0xAD51 },
	{ 0xEA66,  0xAD4F },
	{ 0xEA67,  0xAD52 },
	{ 0xEA68,  0xAD5C },
	{ 0xEA69,  0xAE53 },
	{ 0xEA6A,  0xAE9B },
	{ 0xEA6B,  0xAF95 },
	{ 0xEA6C,  0xF1A6 },
	{ 0xEA6D,  0xAF96 },
	{ 0xEA6E,  0xAF9D },
	{ 0xEA6F,  0xF1AC },
	{ 0xEA70,  0xF1A2 },
	{ 0xEA71,  0xF1A9 },
	{ 0xEA72,  0xAF97 },
	{ 0xEA73,  0xF1A7 },
	{ 0xEA74,  0xB09A },
	{ 0xEA75,  0xB151 },
	{ 0xEA76,  0xB269 },
	{ 0xEA77,  0xB26C },
	{ 0xEA78,  0xB26E },
	{ 0xEA79,  0xB26B },
	{ 0xEA7A,  0xB26A },
	{ 0xEA7B,  0xDEAB },
	{ 0xEA7C,  0xB26F },
	{ 0xEA7D,  0xB264 },
	{ 0xEA7E,  0xB268 },
	{ 0xEAA1,  0xB266 },
	{ 0xEAA2,  0xB478 },
	{ 0xEAA3,  0xB484 },
	{ 0xEAA4,  0xB481 },
	{ 0xEAA5,  0xB485 },
	{ 0xEAA6,  0xB479 },
	{ 0xEAA7,  0xB47E },
	{ 0xEAA8,  0xB476 },
	{ 0xEAA9,  0xB47C },
	{ 0xEAAA,  0xB47D },
	{ 0xEAAB,  0xB487 },
	{ 0xEAAC,  0xB47A },
	{ 0xEAAD,  0xB47B },
	{ 0xEAAE,  0xB650 },
	{ 0xEAAF,  0xB75D },
	{ 0xEAB0,  0xB760 },
	{ 0xEAB1,  0xB75F },
	{ 0xEAB2,  0xB84D },
	{ 0xEAB3,  0xB84F },
	{ 0xEAB4,  0xB84C },
	{ 0xEAB5,  0xB849 },
	{ 0xEAB6,  0xB84E },
	{ 0xEAB7,  0xBA51 },
	{ 0xEAB8,  0xBA55 },
	{ 0xEAB9,  0xBA57 },
	{ 0xEABA,  0xF3F4 },
	{ 0xEABB,  0xBA4B },
	{ 0xEABC,  0xF3F6 },
	{ 0xEABD,  0xF3F5 },
	{ 0xEABE,  0xBA58 },
	{ 0xEABF,  0xBA65 },
	{ 0xEAC0,  0xBA4A },
	{ 0xEAC1,  0xF3F8 },
	{ 0xEAC2,  0xBA54 },
	{ 0xEAC3,  0xBA50 },
	{ 0xEAC4,  0xBA5A },
	{ 0xEAC5,  0xBA4E },
	{ 0xEAC6,  0xBA52 },
	{ 0xEAC7,  0xBC4C },
	{ 0xEAC8,  0xBC4E },
	{ 0xEAC9,  0xF4DC },
	{ 0xEACA,  0xBC4A },
	{ 0xEACB,  0xBC4B },
	{ 0xEACC,  0xBF57 },
	{ 0xEACD,  0xBF66 },
	{ 0xEACE,  0xBF5C },
	{ 0xEACF,  0xBF51 },
	{ 0xEAD0,  0xBF64 },
	{ 0xEAD1,  0xBF65 },
	{ 0xEAD2,  0xBF58 },
	{ 0xEAD3,  0xBF53 },
	{ 0xEAD4,  0xBF61 },
	{ 0xEAD5,  0xBF5A },
	{ 0xEAD6,  0xBF5F },
	{ 0xEAD7,  0xBF67 },
	{ 0xEAD8,  0xBF50 },
	{ 0xEAD9,  0xBF54 },
	{ 0xEADA,  0xBF5B },
	{ 0xEADB,  0xBF52 },
	{ 0xEADC,  0xBF59 },
	{ 0xEADD,  0xBF6A },
	{ 0xEADE,  0xBF69 },
	{ 0xEADF,  0xC094 },
	{ 0xEAE0,  0xC157 },
	{ 0xEAE1,  0xC158 },
	{ 0xEAE2,  0xC156 },
	{ 0xEAE3,  0xC17E },
	{ 0xEAE4,  0xC247 },
	{ 0xEAE5,  0xC5D5 },
	{ 0xEAE6,  0xF1F0 },
	{ 0xEAE7,  0xC290 },
	{ 0xEAE8,  0xC488 },
	{ 0xEAE9,  0xECA2 },
	{ 0xEAEA,  0xC485 },
	{ 0xEAEB,  0xC48F },
	{ 0xEAEC,  0xC48B },
	{ 0xEAED,  0xC482 },
	{ 0xEAEE,  0xC487 },
	{ 0xEAEF,  0xC483 },
	{ 0xEAF0,  0xC48A },
	{ 0xEAF1,  0xC489 },
	{ 0xEAF2,  0xC48D },
	{ 0xEAF3,  0xC480 },
	{ 0xEAF4,  0xC559 },
	{ 0xEAF5,  0xC590 },
	{ 0xEAF6,  0xC591 },
	{ 0xEAF7,  0xC592 },
	{ 0xEAF8,  0xDEA1 },
	{ 0xEAF9,  0xCA71 },
	{ 0xEAFA,  0xCA90 },
	{ 0xEAFB,  0xCA76 },
	{ 0xEAFC,  0xCA7C },
	{ 0xEAFD,  0xCA88 },
	{ 0xEAFE,  0xCA81 },
	{ 0xEB40,  0xCA6D },
	{ 0xEB41,  0xCA72 },
	{ 0xEB42,  0xDEA8 },
	{ 0xEB43,  0xCA6E },
	{ 0xEB44,  0xCA89 },
	{ 0xEB45,  0xCA70 },
	{ 0xEB46,  0xCA7A },
	{ 0xEB47,  0xCA73 },
	{ 0xEB48,  0xCA8A },
	{ 0xEB49,  0xCA6B },
	{ 0xEB4A,  0xCA83 },
	{ 0xEB4B,  0xCA96 },
	{ 0xEB4C,  0xCA77 },
	{ 0xEB4D,  0xCA93 },
	{ 0xEB4E,  0xCA98 },
	{ 0xEB4F,  0xCA7E },
	{ 0xEB50,  0xCA8D },
	{ 0xEB51,  0xCA87 },
	{ 0xEB52,  0xCB47 },
	{ 0xEB53,  0xCA8C },
	{ 0xEB54,  0xCA85 },
	{ 0xEB55,  0xCA7D },
	{ 0xEB56,  0xCA8B },
	{ 0xEB57,  0xCA91 },
	{ 0xEB58,  0xCC99 },
	{ 0xEB59,  0xCC9B },
	{ 0xEB5A,  0xCC9A },
	{ 0xEB5B,  0xCE98 },
	{ 0xEB5C,  0xCE8E },
	{ 0xEB5D,  0xF3A5 },
	{ 0xEB5E,  0xF2FB },
	{ 0xEB5F,  0xCE91 },
	{ 0xEB60,  0xF3A2 },
	{ 0xEB61,  0xCE86 },
	{ 0xEB62,  0xCE94 },
	{ 0xEB63,  0xCE95 },
	{ 0xEB64,  0xCE82 },
	{ 0xEB65,  0xCE89 },
	{ 0xEB66,  0xCE9F },
	{ 0xEB67,  0xF3A3 },
	{ 0xEB68,  0xCE8F },
	{ 0xEB69,  0xCE90 },
	{ 0xEB6A,  0xCE9A },
	{ 0xEB6B,  0xCE87 },
	{ 0xEB6C,  0xCE92 },
	{ 0xEB6D,  0xCE99 },
	{ 0xEB6E,  0xCE97 },
	{ 0xEB6F,  0xCE8A },
	{ 0xEB70,  0xD18E },
	{ 0xEB71,  0xD194 },
	{ 0xEB72,  0xE5BD },
	{ 0xEB73,  0xD199 },
	{ 0xEB74,  0xD19A },
	{ 0xEB75,  0xD195 },
	{ 0xEB76,  0xD19C },
	{ 0xEB77,  0xD191 },
	{ 0xEB78,  0xD197 },
	{ 0xEB79,  0xD192 },
	{ 0xEB7A,  0xD19B },
	{ 0xEB7B,  0xD198 },
	{ 0xEB7C,  0xD18F },
	{ 0xEB7D,  0xD376 },
	{ 0xEB7E,  0xD59D },
	{ 0xEBA1,  0xD59F },
	{ 0xEBA2,  0xD64E },
	{ 0xEBA3,  0xD650 },
	{ 0xEBA4,  0xD651 },
	{ 0xEBA5,  0xD59A },
	{ 0xEBA6,  0xD66F },
	{ 0xEBA7,  0xD640 },
	{ 0xEBA8,  0xD59C },
	{ 0xEBA9,  0xD64C },
	{ 0xEBAA,  0xD585 },
	{ 0xEBAB,  0xD59B },
	{ 0xEBAC,  0xD59E },
	{ 0xEBAD,  0xD644 },
	{ 0xEBAE,  0xD65B },
	{ 0xEBAF,  0xD64B },
	{ 0xEBB0,  0xD657 },
	{ 0xEBB1,  0xD886 },
	{ 0xEBB2,  0xD887 },
	{ 0xEBB3,  0xD885 },
	{ 0xEBB4,  0xD988 },
	{ 0xEBB5,  0xD981 },
	{ 0xEBB6,  0xD984 },
	{ 0xEBB7,  0xD983 },
	{ 0xEBB8,  0xD986 },
	{ 0xEBB9,  0xDA58 },
	{ 0xEBBA,  0xDA59 },
	{ 0xEBBB,  0xDA82 },
	{ 0xEBBC,  0xDA84 },
	{ 0xEBBD,  0xDB77 },
	{ 0xEBBE,  0xDB7E },
	{ 0xEBBF,  0xDB7B },
	{ 0xEBC0,  0xF5DE },
	{ 0xEBC1,  0xDB82 },
	{ 0xEBC2,  0xDB79 },
	{ 0xEBC3,  0xDB7D },
	{ 0xEBC4,  0xF5E1 },
	{ 0xEBC5,  0xF5E4 },
	{ 0xEBC6,  0xDB75 },
	{ 0xEBC7,  0xDB80 },
	{ 0xEBC8,  0xDC79 },
	{ 0xEBC9,  0xDD92 },
	{ 0xEBCA,  0xDD8A },
	{ 0xEBCB,  0xDD91 },
	{ 0xEBCC,  0xDD8E },
	{ 0xEBCD,  0xDD95 },
	{ 0xEBCE,  0xDD93 },
	{ 0xEBCF,  0xDD90 },
	{ 0xEBD0,  0xDF76 },
	{ 0xEBD1,  0xDF79 },
	{ 0xEBD2,  0xDF7B },
	{ 0xEBD3,  0xDF82 },
	{ 0xEBD4,  0xE061 },
	{ 0xEBD5,  0xE091 },
	{ 0xEBD6,  0xE093 },
	{ 0xEBD7,  0xE094 },
	{ 0xEBD8,  0xE161 },
	{ 0xEBD9,  0xF5AD },
	{ 0xEBDA,  0xF5AF },
	{ 0xEBDB,  0xF5AE },
	{ 0xEBDC,  0xE160 },
	{ 0xEBDD,  0xE55D },
	{ 0xEBDE,  0xE554 },
	{ 0xEBDF,  0xE49F },
	{ 0xEBE0,  0xE555 },
	{ 0xEBE1,  0xE49D },
	{ 0xEBE2,  0xE545 },
	{ 0xEBE3,  0xE64E },
	{ 0xEBE4,  0xE56E },
	{ 0xEBE5,  0xE572 },
	{ 0xEBE6,  0xE551 },
	{ 0xEBE7,  0xE559 },
	{ 0xEBE8,  0xE548 },
	{ 0xEBE9,  0xE498 },
	{ 0xEBEA,  0xE57B },
	{ 0xEBEB,  0xE563 },
	{ 0xEBEC,  0xE544 },
	{ 0xEBED,  0xE543 },
	{ 0xEBEE,  0xE461 },
	{ 0xEBEF,  0xE553 },
	{ 0xEBF0,  0xE491 },
	{ 0xEBF1,  0xE55B },
	{ 0xEBF2,  0xE549 },
	{ 0xEBF3,  0xE490 },
	{ 0xEBF4,  0xE48E },
	{ 0xEBF5,  0xE56A },
	{ 0xEBF6,  0xE499 },
	{ 0xEBF7,  0xE55A },
	{ 0xEBF8,  0xE496 },
	{ 0xEBF9,  0xE55F },
	{ 0xEBFA,  0xE56F },
	{ 0xEBFB,  0xE56B },
	{ 0xEBFC,  0xE560 },
	{ 0xEBFD,  0xE54A },
	{ 0xEBFE,  0xE542 },
	{ 0xEC40,  0xE541 },
	{ 0xEC41,  0xE495 },
	{ 0xEC42,  0xE4A0 },
	{ 0xEC43,  0xE497 },
	{ 0xEC44,  0xE492 },
	{ 0xEC45,  0xE54C },
	{ 0xEC46,  0xE991 },
	{ 0xEC47,  0xEA41 },
	{ 0xEC48,  0xE993 },
	{ 0xEC49,  0xE98E },
	{ 0xEC4A,  0xE98F },
	{ 0xEC4B,  0xE98B },
	{ 0xEC4C,  0xE994 },
	{ 0xEC4D,  0xE98A },
	{ 0xEC4E,  0xE992 },
	{ 0xEC4F,  0xEB54 },
	{ 0xEC50,  0xEB6C },
	{ 0xEC51,  0xEB92 },
	{ 0xEC52,  0xEB96 },
	{ 0xEC53,  0xEB94 },
	{ 0xEC54,  0xEC9C },
	{ 0xEC55,  0xEC9B },
	{ 0xEC56,  0xF7B4 },
	{ 0xEC57,  0xED85 },
	{ 0xEC58,  0xED8A },
	{ 0xEC59,  0xEE66 },
	{ 0xEC5A,  0xEE60 },
	{ 0xEC5B,  0xEE63 },
	{ 0xEC5C,  0xF05A },
	{ 0xEC5D,  0xF055 },
	{ 0xEC5E,  0xF05D },
	{ 0xEC5F,  0xF05F },
	{ 0xEC60,  0xF146 },
	{ 0xEC61,  0xF195 },
	{ 0xEC62,  0xF193 },
	{ 0xEC63,  0xF18C },
	{ 0xEC64,  0xF18B },
	{ 0xEC65,  0xF197 },
	{ 0xEC66,  0xF18A },
	{ 0xEC67,  0xF191 },
	{ 0xEC68,  0xF190 },
	{ 0xEC69,  0xF18E },
	{ 0xEC6A,  0xF366 },
	{ 0xEC6B,  0xF36A },
	{ 0xEC6C,  0xF364 },
	{ 0xEC6D,  0xF367 },
	{ 0xEC6E,  0xF393 },
	{ 0xEC6F,  0xF396 },
	{ 0xEC70,  0xF7DB },
	{ 0xEC71,  0xF394 },
	{ 0xEC72,  0xF465 },
	{ 0xEC73,  0xF544 },
	{ 0xEC74,  0xF549 },
	{ 0xEC75,  0xF54B },
	{ 0xEC76,  0xF540 },
	{ 0xEC77,  0xF542 },
	{ 0xEC78,  0xF4A0 },
	{ 0xEC79,  0xF546 },
	{ 0xEC7A,  0xF557 },
	{ 0xEC7B,  0xF556 },
	{ 0xEC7C,  0xF554 },
	{ 0xEC7D,  0xF49F },
	{ 0xEC7E,  0xF559 },
	{ 0xECA1,  0xF541 },
	{ 0xECA2,  0xF54C },
	{ 0xECA3,  0xF883 },
	{ 0xECA4,  0xF874 },
	{ 0xECA5,  0xF87D },
	{ 0xECA6,  0xF87B },
	{ 0xECA7,  0xF871 },
	{ 0xECA8,  0xF887 },
	{ 0xECA9,  0xF87A },
	{ 0xECAA,  0xF875 },
	{ 0xECAB,  0xF880 },
	{ 0xECAC,  0xF86D },
	{ 0xECAD,  0xF876 },
	{ 0xECAE,  0xF87C },
	{ 0xECAF,  0xF7E6 },
	{ 0xECB0,  0xFB84 },
	{ 0xECB1,  0xF7E5 },
	{ 0xECB2,  0xFC43 },
	{ 0xECB3,  0xFC42 },
	{ 0xECB4,  0xFC5E },
	{ 0xECB5,  0xFC5F },
	{ 0xECB6,  0xFC76 },
	{ 0xECB7,  0xFC88 },
	{ 0xECB8,  0xF7FC },
	{ 0xECB9,  0x839A },
	{ 0xECBA,  0x8399 },
	{ 0xECBB,  0x8396 },
	{ 0xECBC,  0x8398 },
	{ 0xECBD,  0x8395 },
	{ 0xECBE,  0x839D },
	{ 0xECBF,  0x84ED },
	{ 0xECC0,  0xE0EA },
	{ 0xECC1,  0x879D },
	{ 0xECC2,  0x879E },
	{ 0xECC3,  0xE0E3 },
	{ 0xECC4,  0x8797 },
	{ 0xECC5,  0x8796 },
	{ 0xECC6,  0x8791 },
	{ 0xECC7,  0x8795 },
	{ 0xECC8,  0x8792 },
	{ 0xECC9,  0x8794 },
	{ 0xECCA,  0x89BC },
	{ 0xECCB,  0x89BB },
	{ 0xECCC,  0x89B7 },
	{ 0xECCD,  0x89B9 },
	{ 0xECCE,  0x8BE8 },
	{ 0xECCF,  0x8BE0 },
	{ 0xECD0,  0xE6D5 },
	{ 0xECD1,  0x8BDE },
	{ 0xECD2,  0x8BE7 },
	{ 0xECD3,  0x8BE2 },
	{ 0xECD4,  0x8BE1 },
	{ 0xECD5,  0x8BEA },
	{ 0xECD6,  0x8BE9 },
	{ 0xECD7,  0x8C59 },
	{ 0xECD8,  0x8C95 },
	{ 0xECD9,  0x8C96 },
	{ 0xECDA,  0xE1DA },
	{ 0xECDB,  0x8ECE },
	{ 0xECDC,  0x8ECC },
	{ 0xECDD,  0x8FDB },
	{ 0xECDE,  0x8FDA },
	{ 0xECDF,  0x91A5 },
	{ 0xECE0,  0x919A },
	{ 0xECE1,  0x91A0 },
	{ 0xECE2,  0x91C2 },
	{ 0xECE3,  0x91BC },
	{ 0xECE4,  0x91C1 },
	{ 0xECE5,  0x91C0 },
	{ 0xECE6,  0x91C3 },
	{ 0xECE7,  0x91BA },
	{ 0xECE8,  0x9450 },
	{ 0xECE9,  0x944A },
	{ 0xECEA,  0x9446 },
	{ 0xECEB,  0x944C },
	{ 0xECEC,  0xDFA9 },
	{ 0xECED,  0x9449 },
	{ 0xECEE,  0x94BE },
	{ 0xECEF,  0x94BD },
	{ 0xECF0,  0x94DF },
	{ 0xECF1,  0x94F4 },
	{ 0xECF2,  0x95DD },
	{ 0xECF3,  0x996A },
	{ 0xECF4,  0x9970 },
	{ 0xECF5,  0x995F },
	{ 0xECF6,  0x997D },
	{ 0xECF7,  0x9966 },
	{ 0xECF8,  0x9978 },
	{ 0xECF9,  0x9974 },
	{ 0xECFA,  0x9979 },
	{ 0xECFB,  0x9977 },
	{ 0xECFC,  0x9964 },
	{ 0xECFD,  0x996D },
	{ 0xECFE,  0xE9D5 },
	{ 0xED40,  0x996F },
	{ 0xED41,  0x9961 },
	{ 0xED42,  0x9981 },
	{ 0xED43,  0x997C },
	{ 0xED44,  0xE9DB },
	{ 0xED45,  0x995E },
	{ 0xED46,  0x997E },
	{ 0xED47,  0x9973 },
	{ 0xED48,  0x9962 },
	{ 0xED49,  0x9969 },
	{ 0xED4A,  0x996C },
	{ 0xED4B,  0x9A61 },
	{ 0xED4C,  0x9A99 },
	{ 0xED4D,  0x9AD7 },
	{ 0xED4E,  0x9DEA },
	{ 0xED4F,  0x9DCD },
	{ 0xED50,  0x9E4C },
	{ 0xED51,  0x9DF0 },
	{ 0xED52,  0x9DFC },
	{ 0xED53,  0x9DF8 },
	{ 0xED54,  0x9E47 },
	{ 0xED55,  0x9E41 },
	{ 0xED56,  0x9E40 },
	{ 0xED57,  0xE5A8 },
	{ 0xED58,  0x9E4A },
	{ 0xED59,  0x9DF9 },
	{ 0xED5A,  0x9DFB },
	{ 0xED5B,  0x9E42 },
	{ 0xED5C,  0xA04A },
	{ 0xED5D,  0xA057 },
	{ 0xED5E,  0xA04F },
	{ 0xED5F,  0xA058 },
	{ 0xED60,  0xA04D },
	{ 0xED61,  0xA056 },
	{ 0xED62,  0xA04B },
	{ 0xED63,  0xAB41 },
	{ 0xED64,  0xAA9E },
	{ 0xED65,  0xE2B4 },
	{ 0xED66,  0xAD54 },
	{ 0xED67,  0xAD6A },
	{ 0xED68,  0xAD63 },
	{ 0xED69,  0xE8B4 },
	{ 0xED6A,  0xAD62 },
	{ 0xED6B,  0xAD65 },
	{ 0xED6C,  0xAD69 },
	{ 0xED6D,  0xAD60 },
	{ 0xED6E,  0xAD67 },
	{ 0xED6F,  0xAE56 },
	{ 0xED70,  0xEAB5 },
	{ 0xED71,  0xAE57 },
	{ 0xED72,  0xEAB4 },
	{ 0xED73,  0xAE9E },
	{ 0xED74,  0xF1AA },
	{ 0xED75,  0xB043 },
	{ 0xED76,  0xB044 },
	{ 0xED77,  0xB042 },
	{ 0xED78,  0xF0AB },
	{ 0xED79,  0xB154 },
	{ 0xED7A,  0xEEAC },
	{ 0xED7B,  0xB273 },
	{ 0xED7C,  0xB278 },
	{ 0xED7D,  0xB27B },
	{ 0xED7E,  0xB27A },
	{ 0xEDA1,  0xB279 },
	{ 0xEDA2,  0xB277 },
	{ 0xEDA3,  0xB272 },
	{ 0xEDA4,  0xB344 },
	{ 0xEDA5,  0xB48C },
	{ 0xEDA6,  0xB493 },
	{ 0xEDA7,  0xB497 },
	{ 0xEDA8,  0xB491 },
	{ 0xEDA9,  0xB492 },
	{ 0xEDAA,  0xEDE1 },
	{ 0xEDAB,  0xEDE2 },
	{ 0xEDAC,  0xB490 },
	{ 0xEDAD,  0xB494 },
	{ 0xEDAE,  0xB499 },
	{ 0xEDAF,  0xB656 },
	{ 0xEDB0,  0xB653 },
	{ 0xEDB1,  0xB772 },
	{ 0xEDB2,  0xB771 },
	{ 0xEDB3,  0xB76D },
	{ 0xEDB4,  0xB76E },
	{ 0xEDB5,  0xB76B },
	{ 0xEDB6,  0xB770 },
	{ 0xEDB7,  0xB855 },
	{ 0xEDB8,  0xB856 },
	{ 0xEDB9,  0xB857 },
	{ 0xEDBA,  0xBA6F },
	{ 0xEDBB,  0xF3FC },
	{ 0xEDBC,  0xBA5F },
	{ 0xEDBD,  0xBA6A },
	{ 0xEDBE,  0xBA69 },
	{ 0xEDBF,  0xBA67 },
	{ 0xEDC0,  0xBA75 },
	{ 0xEDC1,  0xBA61 },
	{ 0xEDC2,  0xF3FE },
	{ 0xEDC3,  0xBA60 },
	{ 0xEDC4,  0xBA6C },
	{ 0xEDC5,  0xBA72 },
	{ 0xEDC6,  0xBA6D },
	{ 0xEDC7,  0xBA6B },
	{ 0xEDC8,  0xBA64 },
	{ 0xEDC9,  0xBA68 },
	{ 0xEDCA,  0xBA70 },
	{ 0xEDCB,  0xBA5E },
	{ 0xEDCC,  0xC0E9 },
	{ 0xEDCD,  0xBA76 },
	{ 0xEDCE,  0xBA73 },
	{ 0xEDCF,  0xF4DD },
	{ 0xEDD0,  0xBF72 },
	{ 0xEDD1,  0xBF81 },
	{ 0xEDD2,  0xBF86 },
	{ 0xEDD3,  0xBF78 },
	{ 0xEDD4,  0xEE79 },
	{ 0xEDD5,  0xBF7D },
	{ 0xEDD6,  0xBF6F },
	{ 0xEDD7,  0xBF8C },
	{ 0xEDD8,  0xBF85 },
	{ 0xEDD9,  0xF4ED },
	{ 0xEDDA,  0xBF6E },
	{ 0xEDDB,  0xBF8F },
	{ 0xEDDC,  0xBF75 },
	{ 0xEDDD,  0xF7E3 },
	{ 0xEDDE,  0xBF7B },
	{ 0xEDDF,  0xBF88 },
	{ 0xEDE0,  0xBF80 },
	{ 0xEDE1,  0xF3C1 },
	{ 0xEDE2,  0xC15A },
	{ 0xEDE3,  0xEEC0 },
	{ 0xEDE4,  0xC159 },
	{ 0xEDE5,  0xC249 },
	{ 0xEDE6,  0xC248 },
	{ 0xEDE7,  0xC265 },
	{ 0xEDE8,  0xEBFE },
	{ 0xEDE9,  0xC494 },
	{ 0xEDEA,  0xEBFB },
	{ 0xEDEB,  0xEBFD },
	{ 0xEDEC,  0xC495 },
	{ 0xEDED,  0xC496 },
	{ 0xEDEE,  0xC490 },
	{ 0xEDEF,  0xC553 },
	{ 0xEDF0,  0xC594 },
	{ 0xEDF1,  0xF4BD },
	{ 0xEDF2,  0xC595 },
	{ 0xEDF3,  0xCB41 },
	{ 0xEDF4,  0xCA9F },
	{ 0xEDF5,  0xDEB2 },
	{ 0xEDF6,  0xCB5E },
	{ 0xEDF7,  0xCB4F },
	{ 0xEDF8,  0xCB58 },
	{ 0xEDF9,  0xCB46 },
	{ 0xEDFA,  0xCB5B },
	{ 0xEDFB,  0xDEAE },
	{ 0xEDFC,  0xDEAF },
	{ 0xEDFD,  0xCB54 },
	{ 0xEDFE,  0xCB56 },
	{ 0xEE40,  0xCA9A },
	{ 0xEE41,  0xCA9C },
	{ 0xEE42,  0xCB44 },
	{ 0xEE43,  0xCB59 },
	{ 0xEE44,  0xDEAA },
	{ 0xEE45,  0xCA9B },
	{ 0xEE46,  0xCA80 },
	{ 0xEE47,  0xCB49 },
	{ 0xEE48,  0xCB50 },
	{ 0xEE49,  0xCB42 },
	{ 0xEE4A,  0xCB48 },
	{ 0xEE4B,  0xCB53 },
	{ 0xEE4C,  0xCB55 },
	{ 0xEE4D,  0xCAA0 },
	{ 0xEE4E,  0xCB5A },
	{ 0xEE4F,  0xCB40 },
	{ 0xEE50,  0xCB43 },
	{ 0xEE51,  0xDEB6 },
	{ 0xEE52,  0xDEB3 },
	{ 0xEE53,  0xCA99 },
	{ 0xEE54,  0xCB52 },
	{ 0xEE55,  0xCB4A },
	{ 0xEE56,  0xCB57 },
	{ 0xEE57,  0xCC9E },
	{ 0xEE58,  0xCF50 },
	{ 0xEE59,  0xCF44 },
	{ 0xEE5A,  0xF3A4 },
	{ 0xEE5B,  0xCF56 },
	{ 0xEE5C,  0xCF46 },
	{ 0xEE5D,  0xF3A9 },
	{ 0xEE5E,  0xCF4D },
	{ 0xEE5F,  0xF3AA },
	{ 0xEE60,  0xCF4F },
	{ 0xEE61,  0xCF45 },
	{ 0xEE62,  0xCF59 },
	{ 0xEE63,  0xCF54 },
	{ 0xEE64,  0xCF53 },
	{ 0xEE65,  0xCF5A },
	{ 0xEE66,  0xCF4B },
	{ 0xEE67,  0xF2FC },
	{ 0xEE68,  0xCF55 },
	{ 0xEE69,  0xF3B1 },
	{ 0xEE6A,  0xCF49 },
	{ 0xEE6B,  0xCF4A },
	{ 0xEE6C,  0xCF51 },
	{ 0xEE6D,  0xCF4C },
	{ 0xEE6E,  0xF3AE },
	{ 0xEE6F,  0xCF68 },
	{ 0xEE70,  0xCF48 },
	{ 0xEE71,  0xD19F },
	{ 0xEE72,  0xD19E },
	{ 0xEE73,  0xD244 },
	{ 0xEE74,  0xD246 },
	{ 0xEE75,  0xF1DF },
	{ 0xEE76,  0xD258 },
	{ 0xEE77,  0xD1A0 },
	{ 0xEE78,  0xD249 },
	{ 0xEE79,  0xD34B },
	{ 0xEE7A,  0xD34D },
	{ 0xEE7B,  0xD34C },
	{ 0xEE7C,  0xD377 },
	{ 0xEE7D,  0xECB2 },
	{ 0xEE7E,  0xD679 },
	{ 0xEEA1,  0xD673 },
	{ 0xEEA2,  0xD671 },
	{ 0xEEA3,  0xD66C },
	{ 0xEEA4,  0xD661 },
	{ 0xEEA5,  0xD666 },
	{ 0xEEA6,  0xD67D },
	{ 0xEEA7,  0xD66A },
	{ 0xEEA8,  0xD66D },
	{ 0xEEA9,  0xD670 },
	{ 0xEEAA,  0xE5C0 },
	{ 0xEEAB,  0xD668 },
	{ 0xEEAC,  0xD663 },
	{ 0xEEAD,  0xD662 },
	{ 0xEEAE,  0xD677 },
	{ 0xEEAF,  0xD66E },
	{ 0xEEB0,  0xD675 },
	{ 0xEEB1,  0xD852 },
	{ 0xEEB2,  0xD86D },
	{ 0xEEB3,  0xD86F },
	{ 0xEEB4,  0xD86E },
	{ 0xEEB5,  0xD86C },
	{ 0xEEB6,  0xD889 },
	{ 0xEEB7,  0xF5F9 },
	{ 0xEEB8,  0xD98C },
	{ 0xEEB9,  0xDA5A },
	{ 0xEEBA,  0xDB86 },
	{ 0xEEBB,  0xDB85 },
	{ 0xEEBC,  0xDB89 },
	{ 0xEEBD,  0xDB88 },
	{ 0xEEBE,  0xDB84 },
	{ 0xEEBF,  0xE5BF },
	{ 0xEEC0,  0xDD9F },
	{ 0xEEC1,  0xDD9C },
	{ 0xEEC2,  0xDF81 },
	{ 0xEEC3,  0xDF7D },
	{ 0xEEC4,  0xE096 },
	{ 0xEEC5,  0xC3D1 },
	{ 0xEEC6,  0xF5B0 },
	{ 0xEEC7,  0xC8A9 },
	{ 0xEEC8,  0xE167 },
	{ 0xEEC9,  0xE16B },
	{ 0xEECA,  0xE16D },
	{ 0xEECB,  0xE169 },
	{ 0xEECC,  0xE16C },
	{ 0xEECD,  0xE674 },
	{ 0xEECE,  0xE657 },
	{ 0xEECF,  0xE683 },
	{ 0xEED0,  0xE59A },
	{ 0xEED1,  0xE58C },
	{ 0xEED2,  0xE57C },
	{ 0xEED3,  0xE650 },
	{ 0xEED4,  0xE58E },
	{ 0xEED5,  0xE592 },
	{ 0xEED6,  0xE64A },
	{ 0xEED7,  0xE57E },
	{ 0xEED8,  0xE586 },
	{ 0xEED9,  0xE587 },
	{ 0xEEDA,  0xE596 },
	{ 0xEEDB,  0xE641 },
	{ 0xEEDC,  0xF6CC },
	{ 0xEEDD,  0xE582 },
	{ 0xEEDE,  0xF6CA },
	{ 0xEEDF,  0xE64D },
	{ 0xEEE0,  0xE58D },
	{ 0xEEE1,  0xE58B },
	{ 0xEEE2,  0xE588 },
	{ 0xEEE3,  0xE585 },
	{ 0xEEE4,  0xE645 },
	{ 0xEEE5,  0xE64B },
	{ 0xEEE6,  0xE64F },
	{ 0xEEE7,  0xE597 },
	{ 0xEEE8,  0xE594 },
	{ 0xEEE9,  0xE599 },
	{ 0xEEEA,  0xE59D },
	{ 0xEEEB,  0xE654 },
	{ 0xEEEC,  0xE584 },
	{ 0xEEED,  0xE58F },
	{ 0xEEEE,  0xE99C },
	{ 0xEEEF,  0xE995 },
	{ 0xEEF0,  0xE99E },
	{ 0xEEF1,  0xE998 },
	{ 0xEEF2,  0xE99A },
	{ 0xEEF3,  0xE98C },
	{ 0xEEF4,  0xEB59 },
	{ 0xEEF5,  0xDAF4 },
	{ 0xEEF6,  0xEB57 },
	{ 0xEEF7,  0xEBA0 },
	{ 0xEEF8,  0xEB9F },
	{ 0xEEF9,  0xEB9A },
	{ 0xEEFA,  0xEB9E },
	{ 0xEEFB,  0xEB9B },
	{ 0xEEFC,  0xEC9D },
	{ 0xEEFD,  0xED42 },
	{ 0xEEFE,  0xEC9F },
	{ 0xEF40,  0xED40 },
	{ 0xEF41,  0xECA0 },
	{ 0xEF42,  0xED70 },
	{ 0xEF43,  0xED6F },
	{ 0xEF44,  0xED86 },
	{ 0xEF45,  0xEE72 },
	{ 0xEF46,  0xEE75 },
	{ 0xEF47,  0xEE7B },
	{ 0xEF48,  0xEE7A },
	{ 0xEF49,  0xEE76 },
	{ 0xEF4A,  0xEE74 },
	{ 0xEF4B,  0xF05B },
	{ 0xEF4C,  0xF061 },
	{ 0xEF4D,  0xF062 },
	{ 0xEF4E,  0xF060 },
	{ 0xEF4F,  0xF068 },
	{ 0xEF50,  0xF067 },
	{ 0xEF51,  0xF064 },
	{ 0xEF52,  0xF063 },
	{ 0xEF53,  0xF066 },
	{ 0xEF54,  0xF065 },
	{ 0xEF55,  0xD9E5 },
	{ 0xEF56,  0xF14B },
	{ 0xEF57,  0xF149 },
	{ 0xEF58,  0xF248 },
	{ 0xEF59,  0xF240 },
	{ 0xEF5A,  0xF19B },
	{ 0xEF5B,  0xF19E },
	{ 0xEF5C,  0xF1A0 },
	{ 0xEF5D,  0xF19F },
	{ 0xEF5E,  0xF19D },
	{ 0xEF5F,  0xF241 },
	{ 0xEF60,  0xF243 },
	{ 0xEF61,  0xF244 },
	{ 0xEF62,  0xF242 },
	{ 0xEF63,  0xF249 },
	{ 0xEF64,  0xF369 },
	{ 0xEF65,  0xF399 },
	{ 0xEF66,  0xF398 },
	{ 0xEF67,  0xF39C },
	{ 0xEF68,  0xF397 },
	{ 0xEF69,  0xF7CC },
	{ 0xEF6A,  0xF55E },
	{ 0xEF6B,  0xF56C },
	{ 0xEF6C,  0xF562 },
	{ 0xEF6D,  0xF55F },
	{ 0xEF6E,  0xF56A },
	{ 0xEF6F,  0xF565 },
	{ 0xEF70,  0xF569 },
	{ 0xEF71,  0xF568 },
	{ 0xEF72,  0xF54A },
	{ 0xEF73,  0xF566 },
	{ 0xEF74,  0xF564 },
	{ 0xEF75,  0xF573 },
	{ 0xEF76,  0xF891 },
	{ 0xEF77,  0xF89F },
	{ 0xEF78,  0xF964 },
	{ 0xEF79,  0xF894 },
	{ 0xEF7A,  0xF88C },
	{ 0xEF7B,  0xF88D },
	{ 0xEF7C,  0xF88F },
	{ 0xEF7D,  0xF896 },
	{ 0xEF7E,  0xF88E },
	{ 0xEFA1,  0xF942 },
	{ 0xEFA2,  0xF8A0 },
	{ 0xEFA3,  0xF940 },
	{ 0xEFA4,  0xF89C },
	{ 0xEFA5,  0xF895 },
	{ 0xEFA6,  0xF89E },
	{ 0xEFA7,  0xF89B },
	{ 0xEFA8,  0xC24A },
	{ 0xEFA9,  0xF88B },
	{ 0xEFAA,  0xFB86 },
	{ 0xEFAB,  0xFB85 },
	{ 0xEFAC,  0xFB88 },
	{ 0xEFAD,  0xFC45 },
	{ 0xEFAE,  0xFC57 },
	{ 0xEFAF,  0xFC62 },
	{ 0xEFB0,  0xEDEA },
	{ 0xEFB1,  0xFC78 },
	{ 0xEFB2,  0xFC95 },
	{ 0xEFB3,  0xFC94 },
	{ 0xEFB4,  0xF7F7 },
	{ 0xEFB5,  0xFD5A },
	{ 0xEFB6,  0xD9DF },
	{ 0xEFB7,  0x83A5 },
	{ 0xEFB8,  0x83A1 },
	{ 0xEFB9,  0x83A2 },
	{ 0xEFBA,  0x87A6 },
	{ 0xEFBB,  0x87AA },
	{ 0xEFBC,  0x87A5 },
	{ 0xEFBD,  0x87A8 },
	{ 0xEFBE,  0x87AB },
	{ 0xEFBF,  0x87A7 },
	{ 0xEFC0,  0x8A60 },
	{ 0xEFC1,  0x8BF4 },
	{ 0xEFC2,  0x8CD6 },
	{ 0xEFC3,  0x8CD7 },
	{ 0xEFC4,  0x8E5E },
	{ 0xEFC5,  0x8ECF },
	{ 0xEFC6,  0x8ED0 },
	{ 0xEFC7,  0x91B4 },
	{ 0xEFC8,  0x91BB },
	{ 0xEFC9,  0x91C8 },
	{ 0xEFCA,  0x91C9 },
	{ 0xEFCB,  0x91CC },
	{ 0xEFCC,  0x91C5 },
	{ 0xEFCD,  0x91CB },
	{ 0xEFCE,  0x91C6 },
	{ 0xEFCF,  0x91B2 },
	{ 0xEFD0,  0x91C4 },
	{ 0xEFD1,  0x9460 },
	{ 0xEFD2,  0x9464 },
	{ 0xEFD3,  0x945E },
	{ 0xEFD4,  0x9459 },
	{ 0xEFD5,  0x9461 },
	{ 0xEFD6,  0x9463 },
	{ 0xEFD7,  0x945D },
	{ 0xEFD8,  0x94CB },
	{ 0xEFD9,  0x94F5 },
	{ 0xEFDA,  0x95E4 },
	{ 0xEFDB,  0xEAD6 },
	{ 0xEFDC,  0x95E3 },
	{ 0xEFDD,  0x999B },
	{ 0xEFDE,  0x998F },
	{ 0xEFDF,  0x9993 },
	{ 0xEFE0,  0x99B7 },
	{ 0xEFE1,  0x999C },
	{ 0xEFE2,  0x9990 },
	{ 0xEFE3,  0x998C },
	{ 0xEFE4,  0x998D },
	{ 0xEFE5,  0x999D },
	{ 0xEFE6,  0x998A },
	{ 0xEFE7,  0x9983 },
	{ 0xEFE8,  0x9A64 },
	{ 0xEFE9,  0x9AAD },
	{ 0xEFEA,  0x9AD9 },
	{ 0xEFEB,  0x9E5F },
	{ 0xEFEC,  0x9E64 },
	{ 0xEFED,  0x9E65 },
	{ 0xEFEE,  0x9E59 },
	{ 0xEFEF,  0x9E5D },
	{ 0xEFF0,  0x9E6B },
	{ 0xEFF1,  0x9E66 },
	{ 0xEFF2,  0x9E57 },
	{ 0xEFF3,  0x9E58 },
	{ 0xEFF4,  0x9E53 },
	{ 0xEFF5,  0x9E7A },
	{ 0xEFF6,  0x9E54 },
	{ 0xEFF7,  0x9E4F },
	{ 0xEFF8,  0x9E62 },
	{ 0xEFF9,  0xA066 },
	{ 0xEFFA,  0xA064 },
	{ 0xEFFB,  0xECDE },
	{ 0xEFFC,  0xA068 },
	{ 0xEFFD,  0xA062 },
	{ 0xEFFE,  0xAB44 },
	{ 0xF040,  0xAD70 },
	{ 0xF041,  0xAD77 },
	{ 0xF042,  0xAD6D },
	{ 0xF043,  0xAD78 },
	{ 0xF044,  0xAD75 },
	{ 0xF045,  0xAD6E },
	{ 0xF046,  0xAD72 },
	{ 0xF047,  0xAD79 },
	{ 0xF048,  0xAE58 },
	{ 0xF049,  0xEAB6 },
	{ 0xF04A,  0xF1B0 },
	{ 0xF04B,  0xB058 },
	{ 0xF04C,  0xB050 },
	{ 0xF04D,  0xB049 },
	{ 0xF04E,  0xB04C },
	{ 0xF04F,  0xB04E },
	{ 0xF050,  0xB051 },
	{ 0xF051,  0xB089 },
	{ 0xF052,  0xB09C },
	{ 0xF053,  0xB157 },
	{ 0xF054,  0xB284 },
	{ 0xF055,  0xB27E },
	{ 0xF056,  0xB495 },
	{ 0xF057,  0xB4A0 },
	{ 0xF058,  0xEDE4 },
	{ 0xF059,  0xB546 },
	{ 0xF05A,  0xB49D },
	{ 0xF05B,  0xB543 },
	{ 0xF05C,  0xB545 },
	{ 0xF05D,  0xB544 },
	{ 0xF05E,  0xB658 },
	{ 0xF05F,  0xB657 },
	{ 0xF060,  0xB775 },
	{ 0xF061,  0xBA82 },
	{ 0xF062,  0xBA8C },
	{ 0xF063,  0xBA7E },
	{ 0xF064,  0xBA85 },
	{ 0xF065,  0xF4A1 },
	{ 0xF066,  0xBA8F },
	{ 0xF067,  0xBA83 },
	{ 0xF068,  0xF4A3 },
	{ 0xF069,  0xBA8B },
	{ 0xF06A,  0xBA87 },
	{ 0xF06B,  0xBA8A },
	{ 0xF06C,  0xBA92 },
	{ 0xF06D,  0xBF9F },
	{ 0xF06E,  0xBF93 },
	{ 0xF06F,  0xBF99 },
	{ 0xF070,  0xC045 },
	{ 0xF071,  0xBF9B },
	{ 0xF072,  0xC044 },
	{ 0xF073,  0xC041 },
	{ 0xF074,  0xBF94 },
	{ 0xF075,  0xC042 },
	{ 0xF076,  0xBF9A },
	{ 0xF077,  0xBF96 },
	{ 0xF078,  0xC182 },
	{ 0xF079,  0xC180 },
	{ 0xF07A,  0xC24C },
	{ 0xF07B,  0xC24D },
	{ 0xF07C,  0xC298 },
	{ 0xF07D,  0xC49E },
	{ 0xF07E,  0xC49F },
	{ 0xF0A1,  0xC49D },
	{ 0xF0A2,  0xF4BE },
	{ 0xF0A3,  0xC597 },
	{ 0xF0A4,  0xCB66 },
	{ 0xF0A5,  0xCB75 },
	{ 0xF0A6,  0xCB70 },
	{ 0xF0A7,  0xCB72 },
	{ 0xF0A8,  0xCB71 },
	{ 0xF0A9,  0xCB65 },
	{ 0xF0AA,  0xCB67 },
	{ 0xF0AB,  0xCB6D },
	{ 0xF0AC,  0xCB76 },
	{ 0xF0AD,  0xCB73 },
	{ 0xF0AE,  0xCB6F },
	{ 0xF0AF,  0xCB79 },
	{ 0xF0B0,  0xCB7C },
	{ 0xF0B1,  0xCB77 },
	{ 0xF0B2,  0xCB74 },
	{ 0xF0B3,  0xCB63 },
	{ 0xF0B4,  0xCB68 },
	{ 0xF0B5,  0xCB7E },
	{ 0xF0B6,  0xCC66 },
	{ 0xF0B7,  0xCB69 },
	{ 0xF0B8,  0xDEB8 },
	{ 0xF0B9,  0xCB6E },
	{ 0xF0BA,  0xCC9F },
	{ 0xF0BB,  0xCF6F },
	{ 0xF0BC,  0xCF6E },
	{ 0xF0BD,  0xCF6B },
	{ 0xF0BE,  0xF3B2 },
	{ 0xF0BF,  0xCF72 },
	{ 0xF0C0,  0xF3B3 },
	{ 0xF0C1,  0xF3A8 },
	{ 0xF0C2,  0xCF69 },
	{ 0xF0C3,  0xCF79 },
	{ 0xF0C4,  0xCF6D },
	{ 0xF0C5,  0xCF5F },
	{ 0xF0C6,  0xCF66 },
	{ 0xF0C7,  0xF3AD },
	{ 0xF0C8,  0xCF74 },
	{ 0xF0C9,  0xCF63 },
	{ 0xF0CA,  0xCF6C },
	{ 0xF0CB,  0xCEA0 },
	{ 0xF0CC,  0xCF62 },
	{ 0xF0CD,  0xCF64 },
	{ 0xF0CE,  0xCF86 },
	{ 0xF0CF,  0xCF7A },
	{ 0xF0D0,  0xCF70 },
	{ 0xF0D1,  0xCF67 },
	{ 0xF0D2,  0xD259 },
	{ 0xF0D3,  0xD251 },
	{ 0xF0D4,  0xD255 },
	{ 0xF0D5,  0xD252 },
	{ 0xF0D6,  0xD24C },
	{ 0xF0D7,  0xD256 },
	{ 0xF0D8,  0xD257 },
	{ 0xF0D9,  0xD24F },
	{ 0xF0DA,  0xD685 },
	{ 0xF0DB,  0xD682 },
	{ 0xF0DC,  0xD67E },
	{ 0xF0DD,  0xD68E },
	{ 0xF0DE,  0xD68B },
	{ 0xF0DF,  0xD690 },
	{ 0xF0E0,  0xD741 },
	{ 0xF0E1,  0xD68A },
	{ 0xF0E2,  0xD697 },
	{ 0xF0E3,  0xD699 },
	{ 0xF0E4,  0xD68C },
	{ 0xF0E5,  0xD681 },
	{ 0xF0E6,  0xD692 },
	{ 0xF0E7,  0xF6A5 },
	{ 0xF0E8,  0xD691 },
	{ 0xF0E9,  0xD689 },
	{ 0xF0EA,  0xD680 },
	{ 0xF0EB,  0xD696 },
	{ 0xF0EC,  0xD698 },
	{ 0xF0ED,  0xD695 },
	{ 0xF0EE,  0xD849 },
	{ 0xF0EF,  0xD871 },
	{ 0xF0F0,  0xD88C },
	{ 0xF0F1,  0xF5F8 },
	{ 0xF0F2,  0xD88B },
	{ 0xF0F3,  0xD991 },
	{ 0xF0F4,  0xD997 },
	{ 0xF0F5,  0xD995 },
	{ 0xF0F6,  0xD993 },
	{ 0xF0F7,  0xDB91 },
	{ 0xF0F8,  0xDB97 },
	{ 0xF0F9,  0xDB95 },
	{ 0xF0FA,  0xDB8D },
	{ 0xF0FB,  0xDB8C },
	{ 0xF0FC,  0xDB93 },
	{ 0xF0FD,  0xDB9A },
	{ 0xF0FE,  0xDB9B },
	{ 0xF140,  0xDB90 },
	{ 0xF141,  0xDB8F },
	{ 0xF142,  0xDB96 },
	{ 0xF143,  0xDB92 },
	{ 0xF144,  0xF5BF },
	{ 0xF145,  0xDB8A },
	{ 0xF146,  0xDE41 },
	{ 0xF147,  0xDE42 },
	{ 0xF148,  0xDE43 },
	{ 0xF149,  0xDE46 },
	{ 0xF14A,  0xE088 },
	{ 0xF14B,  0xE097 },
	{ 0xF14C,  0xE098 },
	{ 0xF14D,  0xE09B },
	{ 0xF14E,  0xE172 },
	{ 0xF14F,  0xE16F },
	{ 0xF150,  0xE171 },
	{ 0xF151,  0xF5B5 },
	{ 0xF152,  0xF5B2 },
	{ 0xF153,  0xE689 },
	{ 0xF154,  0xE660 },
	{ 0xF155,  0xE665 },
	{ 0xF156,  0xE68B },
	{ 0xF157,  0xE66E },
	{ 0xF158,  0xE670 },
	{ 0xF159,  0xE65D },
	{ 0xF15A,  0xE67A },
	{ 0xF15B,  0xE662 },
	{ 0xF15C,  0xE67D },
	{ 0xF15D,  0xE671 },
	{ 0xF15E,  0xE679 },
	{ 0xF15F,  0xE668 },
	{ 0xF160,  0xE65C },
	{ 0xF161,  0xE66C },
	{ 0xF162,  0xE672 },
	{ 0xF163,  0xE661 },
	{ 0xF164,  0xE685 },
	{ 0xF165,  0xE664 },
	{ 0xF166,  0xE686 },
	{ 0xF167,  0xE677 },
	{ 0xF168,  0xE67B },
	{ 0xF169,  0xE688 },
	{ 0xF16A,  0xE676 },
	{ 0xF16B,  0xE678 },
	{ 0xF16C,  0xEA46 },
	{ 0xF16D,  0xEA47 },
	{ 0xF16E,  0xEA45 },
	{ 0xF16F,  0xE3C4 },
	{ 0xF170,  0xEB6E },
	{ 0xF171,  0xEB71 },
	{ 0xF172,  0x8E60 },
	{ 0xF173,  0xEB76 },
	{ 0xF174,  0xEB6F },
	{ 0xF175,  0xEB74 },
	{ 0xF176,  0xEC42 },
	{ 0xF177,  0xEC41 },
	{ 0xF178,  0xEC44 },
	{ 0xF179,  0xED4B },
	{ 0xF17A,  0xED4C },
	{ 0xF17B,  0xED48 },
	{ 0xF17C,  0xF7B6 },
	{ 0xF17D,  0xED44 },
	{ 0xF17E,  0xED4A },
	{ 0xF1A1,  0xED43 },
	{ 0xF1A2,  0xED45 },
	{ 0xF1A3,  0xED72 },
	{ 0xF1A4,  0xED74 },
	{ 0xF1A5,  0xED71 },
	{ 0xF1A6,  0xED73 },
	{ 0xF1A7,  0xED8C },
	{ 0xF1A8,  0xEE82 },
	{ 0xF1A9,  0xEE83 },
	{ 0xF1AA,  0xEE84 },
	{ 0xF1AB,  0xEF5C },
	{ 0xF1AC,  0xF076 },
	{ 0xF1AD,  0xF071 },
	{ 0xF1AE,  0xF06F },
	{ 0xF1AF,  0xF255 },
	{ 0xF1B0,  0xF251 },
	{ 0xF1B1,  0xF24F },
	{ 0xF1B2,  0xF253 },
	{ 0xF1B3,  0xF24A },
	{ 0xF1B4,  0xF257 },
	{ 0xF1B5,  0xF250 },
	{ 0xF1B6,  0xF24B },
	{ 0xF1B7,  0xF24D },
	{ 0xF1B8,  0xF24C },
	{ 0xF1B9,  0xF7C2 },
	{ 0xF1BA,  0xF37E },
	{ 0xF1BB,  0xF7DC },
	{ 0xF1BC,  0xF39E },
	{ 0xF1BD,  0xF39F },
	{ 0xF1BE,  0xF45D },
	{ 0xF1BF,  0xF467 },
	{ 0xF1C0,  0xF472 },
	{ 0xF1C1,  0xF474 },
	{ 0xF1C2,  0xF473 },
	{ 0xF1C3,  0xF58C },
	{ 0xF1C4,  0xF58B },
	{ 0xF1C5,  0xF588 },
	{ 0xF1C6,  0xF584 },
	{ 0xF1C7,  0xF586 },
	{ 0xF1C8,  0xF579 },
	{ 0xF1C9,  0xF57C },
	{ 0xF1CA,  0xF598 },
	{ 0xF1CB,  0xF57A },
	{ 0xF1CC,  0xF589 },
	{ 0xF1CD,  0xF57D },
	{ 0xF1CE,  0xF582 },
	{ 0xF1CF,  0xF959 },
	{ 0xF1D0,  0xF950 },
	{ 0xF1D1,  0xF94C },
	{ 0xF1D2,  0xF947 },
	{ 0xF1D3,  0xF958 },
	{ 0xF1D4,  0xF948 },
	{ 0xF1D5,  0xF956 },
	{ 0xF1D6,  0xF953 },
	{ 0xF1D7,  0xF949 },
	{ 0xF1D8,  0xF954 },
	{ 0xF1D9,  0xF94F },
	{ 0xF1DA,  0xF951 },
	{ 0xF1DB,  0xF95C },
	{ 0xF1DC,  0xF955 },
	{ 0xF1DD,  0xF957 },
	{ 0xF1DE,  0xFB89 },
	{ 0xF1DF,  0xFB87 },
	{ 0xF1E0,  0xF7F0 },
	{ 0xF1E1,  0xFC7A },
	{ 0xF1E2,  0xFC79 },
	{ 0xF1E3,  0xFC8B },
	{ 0xF1E4,  0xFC96 },
	{ 0xF1E5,  0xFC9C },
	{ 0xF1E6,  0xFC9B },
	{ 0xF1E7,  0xFC9A },
	{ 0xF1E8,  0xFC99 },
	{ 0xF1E9,  0xFD54 },
	{ 0xF1EA,  0xFD5B },
	{ 0xF1EB,  0x83A8 },
	{ 0xF1EC,  0x83A9 },
	{ 0xF1ED,  0x84AD },
	{ 0xF1EE,  0x84F0 },
	{ 0xF1EF,  0x8598 },
	{ 0xF1F0,  0x87B8 },
	{ 0xF1F1,  0x87BA },
	{ 0xF1F2,  0x87B3 },
	{ 0xF1F3,  0x87B4 },
	{ 0xF1F4,  0x87B7 },
	{ 0xF1F5,  0x87B9 },
	{ 0xF1F6,  0x89C0 },
	{ 0xF1F7,  0x89C3 },
	{ 0xF1F8,  0x89C1 },
	{ 0xF1F9,  0x89EB },
	{ 0xF1FA,  0x8BF5 },
	{ 0xF1FB,  0x8BF6 },
	{ 0xF1FC,  0x8BF7 },
	{ 0xF1FD,  0x8E61 },
	{ 0xF1FE,  0x8ED2 },
	{ 0xF240,  0x8FDC },
	{ 0xF241,  0x91D5 },
	{ 0xF242,  0x9467 },
	{ 0xF243,  0x946F },
	{ 0xF244,  0x946C },
	{ 0xF245,  0xDFAB },
	{ 0xF246,  0x946B },
	{ 0xF247,  0x946D },
	{ 0xF248,  0x94C1 },
	{ 0xF249,  0x94F8 },
	{ 0xF24A,  0x94F7 },
	{ 0xF24B,  0x95E5 },
	{ 0xF24C,  0x99BD },
	{ 0xF24D,  0x99B6 },
	{ 0xF24E,  0x99A2 },
	{ 0xF24F,  0x99A7 },
	{ 0xF250,  0x99AF },
	{ 0xF251,  0x99A1 },
	{ 0xF252,  0x99B5 },
	{ 0xF253,  0x99B2 },
	{ 0xF254,  0x99A6 },
	{ 0xF255,  0x99C1 },
	{ 0xF256,  0x99A5 },
	{ 0xF257,  0x99A3 },
	{ 0xF258,  0x99B4 },
	{ 0xF259,  0x9A66 },
	{ 0xF25A,  0x9A9C },
	{ 0xF25B,  0x9ADA },
	{ 0xF25C,  0x9E70 },
	{ 0xF25D,  0x9E7B },
	{ 0xF25E,  0x9E75 },
	{ 0xF25F,  0x9E6D },
	{ 0xF260,  0x9E80 },
	{ 0xF261,  0x9E76 },
	{ 0xF262,  0x9E77 },
	{ 0xF263,  0xE5AC },
	{ 0xF264,  0x9E7D },
	{ 0xF265,  0x9E6E },
	{ 0xF266,  0x9E78 },
	{ 0xF267,  0x9E71 },
	{ 0xF268,  0x9E7E },
	{ 0xF269,  0xA070 },
	{ 0xF26A,  0xA06E },
	{ 0xF26B,  0xA06B },
	{ 0xF26C,  0xA067 },
	{ 0xF26D,  0xA06A },
	{ 0xF26E,  0xA0DC },
	{ 0xF26F,  0xA0DD },
	{ 0xF270,  0xA0DB },
	{ 0xF271,  0xA0DA },
	{ 0xF272,  0xA0D8 },
	{ 0xF273,  0xAD83 },
	{ 0xF274,  0xAD7C },
	{ 0xF275,  0xAD6F },
	{ 0xF276,  0xAD7A },
	{ 0xF277,  0xAE5A },
	{ 0xF278,  0xB055 },
	{ 0xF279,  0xB28B },
	{ 0xF27A,  0xB28C },
	{ 0xF27B,  0xB286 },
	{ 0xF27C,  0xB345 },
	{ 0xF27D,  0xB54F },
	{ 0xF27E,  0xB54D },
	{ 0xF2A1,  0xB552 },
	{ 0xF2A2,  0xB54E },
	{ 0xF2A3,  0xB549 },
	{ 0xF2A4,  0xEDE6 },
	{ 0xF2A5,  0xB65B },
	{ 0xF2A6,  0xB77D },
	{ 0xF2A7,  0xB77E },
	{ 0xF2A8,  0xBA95 },
	{ 0xF2A9,  0xBA9D },
	{ 0xF2AA,  0xBA9A },
	{ 0xF2AB,  0xBA8E },
	{ 0xF2AC,  0xBA9C },
	{ 0xF2AD,  0xBC5E },
	{ 0xF2AE,  0xBC5C },
	{ 0xF2AF,  0xC058 },
	{ 0xF2B0,  0xC057 },
	{ 0xF2B1,  0xC05A },
	{ 0xF2B2,  0xC052 },
	{ 0xF2B3,  0xC059 },
	{ 0xF2B4,  0xC051 },
	{ 0xF2B5,  0xC05C },
	{ 0xF2B6,  0xC054 },
	{ 0xF2B7,  0xC056 },
	{ 0xF2B8,  0xC04A },
	{ 0xF2B9,  0xC09A },
	{ 0xF2BA,  0xC099 },
	{ 0xF2BB,  0xC15D },
	{ 0xF2BC,  0xC160 },
	{ 0xF2BD,  0xC184 },
	{ 0xF2BE,  0xC250 },
	{ 0xF2BF,  0xC251 },
	{ 0xF2C0,  0xC29B },
	{ 0xF2C1,  0xC543 },
	{ 0xF2C2,  0xC541 },
	{ 0xF2C3,  0xC59C },
	{ 0xF2C4,  0xC599 },
	{ 0xF2C5,  0xC59B },
	{ 0xF2C6,  0xCB93 },
	{ 0xF2C7,  0xCB99 },
	{ 0xF2C8,  0xCB95 },
	{ 0xF2C9,  0xCB84 },
	{ 0xF2CA,  0xCB8B },
	{ 0xF2CB,  0xCB91 },
	{ 0xF2CC,  0xCB85 },
	{ 0xF2CD,  0xCB82 },
	{ 0xF2CE,  0xCB94 },
	{ 0xF2CF,  0xCB9A },
	{ 0xF2D0,  0xCBA0 },
	{ 0xF2D1,  0xCB83 },
	{ 0xF2D2,  0xCB89 },
	{ 0xF2D3,  0xCB8D },
	{ 0xF2D4,  0xDEBC },
	{ 0xF2D5,  0xCB7D },
	{ 0xF2D6,  0xCB98 },
	{ 0xF2D7,  0xCB8F },
	{ 0xF2D8,  0xCB97 },
	{ 0xF2D9,  0xCB88 },
	{ 0xF2DA,  0xCB8C },
	{ 0xF2DB,  0xCF85 },
	{ 0xF2DC,  0xCF80 },
	{ 0xF2DD,  0xD9F9 },
	{ 0xF2DE,  0xCF7C },
	{ 0xF2DF,  0xCF7D },
	{ 0xF2E0,  0xCF8D },
	{ 0xF2E1,  0xCF8F },
	{ 0xF2E2,  0xCF8E },
	{ 0xF2E3,  0xCF8A },
	{ 0xF2E4,  0xCF82 },
	{ 0xF2E5,  0xCF8C },
	{ 0xF2E6,  0xCF84 },
	{ 0xF2E7,  0xF3B9 },
	{ 0xF2E8,  0xCF87 },
	{ 0xF2E9,  0xD266 },
	{ 0xF2EA,  0xD260 },
	{ 0xF2EB,  0xD261 },
	{ 0xF2EC,  0xD25D },
	{ 0xF2ED,  0xD265 },
	{ 0xF2EE,  0xD262 },
	{ 0xF2EF,  0xD25E },
	{ 0xF2F0,  0xD263 },
	{ 0xF2F1,  0xD25F },
	{ 0xF2F2,  0xD287 },
	{ 0xF2F3,  0xD355 },
	{ 0xF2F4,  0xD354 },
	{ 0xF2F5,  0xD37A },
	{ 0xF2F6,  0xD74A },
	{ 0xF2F7,  0xD742 },
	{ 0xF2F8,  0xD744 },
	{ 0xF2F9,  0xD69B },
	{ 0xF2FA,  0xD74D },
	{ 0xF2FB,  0xD750 },
	{ 0xF2FC,  0xD74E },
	{ 0xF2FD,  0xD745 },
	{ 0xF2FE,  0xD74F },
	{ 0xF340,  0xD74B },
	{ 0xF341,  0xD69D },
	{ 0xF342,  0xD74C },
	{ 0xF343,  0xD751 },
	{ 0xF344,  0xD84A },
	{ 0xF345,  0xD873 },
	{ 0xF346,  0xD872 },
	{ 0xF347,  0xD88D },
	{ 0xF348,  0xD999 },
	{ 0xF349,  0xD99A },
	{ 0xF34A,  0xD99C },
	{ 0xF34B,  0xDA89 },
	{ 0xF34C,  0xDA87 },
	{ 0xF34D,  0xDA8A },
	{ 0xF34E,  0xDA88 },
	{ 0xF34F,  0xB2E4 },
	{ 0xF350,  0xDC43 },
	{ 0xF351,  0xDC40 },
	{ 0xF352,  0xDB9D },
	{ 0xF353,  0xF5EC },
	{ 0xF354,  0xDC46 },
	{ 0xF355,  0xDC7E },
	{ 0xF356,  0xDE4D },
	{ 0xF357,  0xDE4C },
	{ 0xF358,  0xDE4A },
	{ 0xF359,  0xDE4B },
	{ 0xF35A,  0xDE4E },
	{ 0xF35B,  0xDE74 },
	{ 0xF35C,  0xE09D },
	{ 0xF35D,  0xE09C },
	{ 0xF35E,  0xE176 },
	{ 0xF35F,  0xF5B3 },
	{ 0xF360,  0xE74F },
	{ 0xF361,  0xE69B },
	{ 0xF362,  0xE741 },
	{ 0xF363,  0xE696 },
	{ 0xF364,  0xE74B },
	{ 0xF365,  0xE742 },
	{ 0xF366,  0xE76A },
	{ 0xF367,  0xE75D },
	{ 0xF368,  0xE69F },
	{ 0xF369,  0xE74A },
	{ 0xF36A,  0xE67C },
	{ 0xF36B,  0xE757 },
	{ 0xF36C,  0xF6CB },
	{ 0xF36D,  0xE746 },
	{ 0xF36E,  0xE75F },
	{ 0xF36F,  0xE754 },
	{ 0xF370,  0xE747 },
	{ 0xF371,  0xE698 },
	{ 0xF372,  0xE740 },
	{ 0xF373,  0xE694 },
	{ 0xF374,  0xE744 },
	{ 0xF375,  0xE758 },
	{ 0xF376,  0xE952 },
	{ 0xF377,  0xEA4E },
	{ 0xF378,  0xEA4F },
	{ 0xF379,  0xEB77 },
	{ 0xF37A,  0xEC48 },
	{ 0xF37B,  0xEC49 },
	{ 0xF37C,  0xEC4A },
	{ 0xF37D,  0xEC47 },
	{ 0xF37E,  0xEC45 },
	{ 0xF3A1,  0xED4F },
	{ 0xF3A2,  0xED52 },
	{ 0xF3A3,  0xED51 },
	{ 0xF3A4,  0xED78 },
	{ 0xF3A5,  0xED79 },
	{ 0xF3A6,  0xED7A },
	{ 0xF3A7,  0xEE8E },
	{ 0xF3A8,  0xEE8B },
	{ 0xF3A9,  0xEE8F },
	{ 0xF3AA,  0xEE89 },
	{ 0xF3AB,  0xEF63 },
	{ 0xF3AC,  0xEF61 },
	{ 0xF3AD,  0xEF5F },
	{ 0xF3AE,  0xEF62 },
	{ 0xF3AF,  0xF07D },
	{ 0xF3B0,  0xF07C },
	{ 0xF3B1,  0xF078 },
	{ 0xF3B2,  0xF14D },
	{ 0xF3B3,  0xF14E },
	{ 0xF3B4,  0xF260 },
	{ 0xF3B5,  0xF25B },
	{ 0xF3B6,  0xF26B },
	{ 0xF3B7,  0xF263 },
	{ 0xF3B8,  0xF26A },
	{ 0xF3B9,  0xF261 },
	{ 0xF3BA,  0xF268 },
	{ 0xF3BB,  0xF266 },
	{ 0xF3BC,  0xF26D },
	{ 0xF3BD,  0xF269 },
	{ 0xF3BE,  0xF264 },
	{ 0xF3BF,  0xF262 },
	{ 0xF3C0,  0xF25A },
	{ 0xF3C1,  0xF7C4 },
	{ 0xF3C2,  0xF443 },
	{ 0xF3C3,  0xF442 },
	{ 0xF3C4,  0xF446 },
	{ 0xF3C5,  0xF444 },
	{ 0xF3C6,  0xF469 },
	{ 0xF3C7,  0xF64E },
	{ 0xF3C8,  0xF64F },
	{ 0xF3C9,  0xF644 },
	{ 0xF3CA,  0xF642 },
	{ 0xF3CB,  0xF648 },
	{ 0xF3CC,  0xF64A },
	{ 0xF3CD,  0xF646 },
	{ 0xF3CE,  0xF654 },
	{ 0xF3CF,  0xF599 },
	{ 0xF3D0,  0xF59C },
	{ 0xF3D1,  0xF650 },
	{ 0xF3D2,  0xF640 },
	{ 0xF3D3,  0xF59E },
	{ 0xF3D4,  0xF649 },
	{ 0xF3D5,  0xF59A },
	{ 0xF3D6,  0xF645 },
	{ 0xF3D7,  0xF59F },
	{ 0xF3D8,  0xF974 },
	{ 0xF3D9,  0xF97E },
	{ 0xF3DA,  0xF988 },
	{ 0xF3DB,  0xF982 },
	{ 0xF3DC,  0xF986 },
	{ 0xF3DD,  0xF96E },
	{ 0xF3DE,  0xF97D },
	{ 0xF3DF,  0xF975 },
	{ 0xF3E0,  0xF984 },
	{ 0xF3E1,  0xF989 },
	{ 0xF3E2,  0xF98A },
	{ 0xF3E3,  0xF97A },
	{ 0xF3E4,  0xF968 },
	{ 0xF3E5,  0xF971 },
	{ 0xF3E6,  0xF972 },
	{ 0xF3E7,  0xF96D },
	{ 0xF3E8,  0xF966 },
	{ 0xF3E9,  0xF983 },
	{ 0xF3EA,  0xF970 },
	{ 0xF3EB,  0xF978 },
	{ 0xF3EC,  0xF980 },
	{ 0xF3ED,  0xF96C },
	{ 0xF3EE,  0xF976 },
	{ 0xF3EF,  0xF97C },
	{ 0xF3F0,  0xF985 },
	{ 0xF3F1,  0xF965 },
	{ 0xF3F2,  0xFB8D },
	{ 0xF3F3,  0xFB8C },
	{ 0xF3F4,  0xFC50 },
	{ 0xF3F5,  0xEDEB },
	{ 0xF3F6,  0xFC9D },
	{ 0xF3F7,  0xFD49 },
	{ 0xF3F8,  0xFD4A },
	{ 0xF3F9,  0xFD55 },
	{ 0xF3FA,  0xFD5C },
	{ 0xF3FB,  0xFD5D },
	{ 0xF3FC,  0xFD5E },
	{ 0xF3FD,  0x855A },
	{ 0xF3FE,  0x87BE },
	{ 0xF440,  0x87C1 },
	{ 0xF441,  0x87BF },
	{ 0xF442,  0x89C9 },
	{ 0xF443,  0x8BFC },
	{ 0xF444,  0x8E63 },
	{ 0xF445,  0x8E64 },
	{ 0xF446,  0x8F5F },
	{ 0xF447,  0x8F60 },
	{ 0xF448,  0x8FDD },
	{ 0xF449,  0x8FDE },
	{ 0xF44A,  0x91D3 },
	{ 0xF44B,  0x9475 },
	{ 0xF44C,  0x9474 },
	{ 0xF44D,  0x9473 },
	{ 0xF44E,  0x9471 },
	{ 0xF44F,  0x94F9 },
	{ 0xF450,  0x95EE },
	{ 0xF451,  0x95EA },
	{ 0xF452,  0x95EB },
	{ 0xF453,  0x99C9 },
	{ 0xF454,  0x99C6 },
	{ 0xF455,  0x99C0 },
	{ 0xF456,  0x99BE },
	{ 0xF457,  0x99CF },
	{ 0xF458,  0x99C7 },
	{ 0xF459,  0x99C4 },
	{ 0xF45A,  0x99C5 },
	{ 0xF45B,  0x9E8F },
	{ 0xF45C,  0xE5AF },
	{ 0xF45D,  0x9E84 },
	{ 0xF45E,  0x9E8B },
	{ 0xF45F,  0x9E89 },
	{ 0xF460,  0x9E86 },
	{ 0xF461,  0x9E95 },
	{ 0xF462,  0x9E8C },
	{ 0xF463,  0x9E92 },
	{ 0xF464,  0x9E8D },
	{ 0xF465,  0xE5AE },
	{ 0xF466,  0x9E93 },
	{ 0xF467,  0x9E8E },
	{ 0xF468,  0x9E88 },
	{ 0xF469,  0x9E94 },
	{ 0xF46A,  0xA077 },
	{ 0xF46B,  0xA078 },
	{ 0xF46C,  0xA0DF },
	{ 0xF46D,  0xAB4B },
	{ 0xF46E,  0xAB4A },
	{ 0xF46F,  0xE8B7 },
	{ 0xF470,  0xB08E },
	{ 0xF471,  0xB08D },
	{ 0xF472,  0xB09D },
	{ 0xF473,  0xB158 },
	{ 0xF474,  0xB28E },
	{ 0xF475,  0xB28F },
	{ 0xF476,  0xB290 },
	{ 0xF477,  0xDBC7 },
	{ 0xF478,  0xB346 },
	{ 0xF479,  0xB555 },
	{ 0xF47A,  0xB554 },
	{ 0xF47B,  0xB557 },
	{ 0xF47C,  0xB558 },
	{ 0xF47D,  0xEDE5 },
	{ 0xF47E,  0xB559 },
	{ 0xF4A1,  0xB65D },
	{ 0xF4A2,  0xB785 },
	{ 0xF4A3,  0xB783 },
	{ 0xF4A4,  0xB784 },
	{ 0xF4A5,  0xB883 },
	{ 0xF4A6,  0xBB46 },
	{ 0xF4A7,  0xBB45 },
	{ 0xF4A8,  0xBB47 },
	{ 0xF4A9,  0xBB44 },
	{ 0xF4AA,  0xBB42 },
	{ 0xF4AB,  0xBC60 },
	{ 0xF4AC,  0xC05D },
	{ 0xF4AD,  0xC060 },
	{ 0xF4AE,  0xC063 },
	{ 0xF4AF,  0xC062 },
	{ 0xF4B0,  0xC185 },
	{ 0xF4B1,  0xC252 },
	{ 0xF4B2,  0xC29C },
	{ 0xF4B3,  0xC547 },
	{ 0xF4B4,  0xC545 },
	{ 0xF4B5,  0xC567 },
	{ 0xF4B6,  0xF4BF },
	{ 0xF4B7,  0xC5A0 },
	{ 0xF4B8,  0xCC64 },
	{ 0xF4B9,  0xDEBD },
	{ 0xF4BA,  0xCC46 },
	{ 0xF4BB,  0xCC44 },
	{ 0xF4BC,  0xCC5D },
	{ 0xF4BD,  0xCC45 },
	{ 0xF4BE,  0xCB9E },
	{ 0xF4BF,  0xCC49 },
	{ 0xF4C0,  0xCC4D },
	{ 0xF4C1,  0xDEBF },
	{ 0xF4C2,  0xCC50 },
	{ 0xF4C3,  0xCC43 },
	{ 0xF4C4,  0xCF99 },
	{ 0xF4C5,  0xCF93 },
	{ 0xF4C6,  0xCF94 },
	{ 0xF4C7,  0xCF97 },
	{ 0xF4C8,  0xF3B7 },
	{ 0xF4C9,  0xF3B6 },
	{ 0xF4CA,  0xD267 },
	{ 0xF4CB,  0xF1E0 },
	{ 0xF4CC,  0xD357 },
	{ 0xF4CD,  0xD37B },
	{ 0xF4CE,  0xD75A },
	{ 0xF4CF,  0xD763 },
	{ 0xF4D0,  0xD757 },
	{ 0xF4D1,  0xD761 },
	{ 0xF4D2,  0xD75D },
	{ 0xF4D3,  0xD75F },
	{ 0xF4D4,  0xD760 },
	{ 0xF4D5,  0xD765 },
	{ 0xF4D6,  0xDA8B },
	{ 0xF4D7,  0xDC4D },
	{ 0xF4D8,  0xDC4E },
	{ 0xF4D9,  0xDC4C },
	{ 0xF4DA,  0xDE54 },
	{ 0xF4DB,  0xDE51 },
	{ 0xF4DC,  0xDE52 },
	{ 0xF4DD,  0xDE50 },
	{ 0xF4DE,  0xDE53 },
	{ 0xF4DF,  0xDE55 },
	{ 0xF4E0,  0xDF87 },
	{ 0xF4E1,  0xDBB9 },
	{ 0xF4E2,  0xE09E },
	{ 0xF4E3,  0xE17B },
	{ 0xF4E4,  0xF5B6 },
	{ 0xF4E5,  0xE178 },
	{ 0xF4E6,  0xE179 },
	{ 0xF4E7,  0xE77C },
	{ 0xF4E8,  0xE785 },
	{ 0xF4E9,  0xE76C },
	{ 0xF4EA,  0xE792 },
	{ 0xF4EB,  0xE781 },
	{ 0xF4EC,  0xE786 },
	{ 0xF4ED,  0xE76F },
	{ 0xF4EE,  0xE787 },
	{ 0xF4EF,  0xE782 },
	{ 0xF4F0,  0xE79A },
	{ 0xF4F1,  0xE78B },
	{ 0xF4F2,  0xE77E },
	{ 0xF4F3,  0xE766 },
	{ 0xF4F4,  0xE771 },
	{ 0xF4F5,  0xE768 },
	{ 0xF4F6,  0xE778 },
	{ 0xF4F7,  0xE780 },
	{ 0xF4F8,  0xE788 },
	{ 0xF4F9,  0xE784 },
	{ 0xF4FA,  0xE76B },
	{ 0xF4FB,  0xE77A },
	{ 0xF4FC,  0xE769 },
	{ 0xF4FD,  0xE77B },
	{ 0xF4FE,  0xE770 },
	{ 0xF540,  0xE76D },
	{ 0xF541,  0xE77D },
	{ 0xF542,  0xE767 },
	{ 0xF543,  0xE783 },
	{ 0xF544,  0xE777 },
	{ 0xF545,  0xEA52 },
	{ 0xF546,  0xEA54 },
	{ 0xF547,  0xEA53 },
	{ 0xF548,  0xEC4B },
	{ 0xF549,  0xEC4C },
	{ 0xF54A,  0xED54 },
	{ 0xF54B,  0xED56 },
	{ 0xF54C,  0xED8F },
	{ 0xF54D,  0xED90 },
	{ 0xF54E,  0xEE92 },
	{ 0xF54F,  0xEE94 },
	{ 0xF550,  0xEE95 },
	{ 0xF551,  0xEE91 },
	{ 0xF552,  0xEF65 },
	{ 0xF553,  0xEF66 },
	{ 0xF554,  0xF086 },
	{ 0xF555,  0xF084 },
	{ 0xF556,  0xF08D },
	{ 0xF557,  0xF082 },
	{ 0xF558,  0xF081 },
	{ 0xF559,  0xF089 },
	{ 0xF55A,  0xF278 },
	{ 0xF55B,  0xF27A },
	{ 0xF55C,  0xF277 },
	{ 0xF55D,  0xF272 },
	{ 0xF55E,  0xF270 },
	{ 0xF55F,  0xF27C },
	{ 0xF560,  0xF26F },
	{ 0xF561,  0xF274 },
	{ 0xF562,  0xF27E },
	{ 0xF563,  0xF273 },
	{ 0xF564,  0xF36E },
	{ 0xF565,  0xF371 },
	{ 0xF566,  0xF36D },
	{ 0xF567,  0xF447 },
	{ 0xF568,  0xF449 },
	{ 0xF569,  0xF448 },
	{ 0xF56A,  0xF66F },
	{ 0xF56B,  0xF66C },
	{ 0xF56C,  0xF65B },
	{ 0xF56D,  0xF669 },
	{ 0xF56E,  0xF676 },
	{ 0xF56F,  0xF65C },
	{ 0xF570,  0xF744 },
	{ 0xF571,  0xF66B },
	{ 0xF572,  0xF672 },
	{ 0xF573,  0xF66A },
	{ 0xF574,  0xF67B },
	{ 0xF575,  0xF678 },
	{ 0xF576,  0xF66D },
	{ 0xF577,  0xF99D },
	{ 0xF578,  0xF997 },
	{ 0xF579,  0xFA41 },
	{ 0xF57A,  0xF99B },
	{ 0xF57B,  0xF990 },
	{ 0xF57C,  0xF996 },
	{ 0xF57D,  0xF98E },
	{ 0xF57E,  0xF999 },
	{ 0xF5A1,  0xF99E },
	{ 0xF5A2,  0xF992 },
	{ 0xF5A3,  0xF99A },
	{ 0xF5A4,  0xFA47 },
	{ 0xF5A5,  0xF995 },
	{ 0xF5A6,  0xF99F },
	{ 0xF5A7,  0xF998 },
	{ 0xF5A8,  0xF9A0 },
	{ 0xF5A9,  0xFA45 },
	{ 0xF5AA,  0xF99C },
	{ 0xF5AB,  0xFA40 },
	{ 0xF5AC,  0xFA5C },
	{ 0xF5AD,  0xFA46 },
	{ 0xF5AE,  0xF994 },
	{ 0xF5AF,  0xFA43 },
	{ 0xF5B0,  0xFA44 },
	{ 0xF5B1,  0xFB92 },
	{ 0xF5B2,  0xFB94 },
	{ 0xF5B3,  0xFB93 },
	{ 0xF5B4,  0xF7F4 },
	{ 0xF5B5,  0xFC66 },
	{ 0xF5B6,  0xF7F3 },
	{ 0xF5B7,  0xFC67 },
	{ 0xF5B8,  0xFC9F },
	{ 0xF5B9,  0xFC9E },
	{ 0xF5BA,  0xFD61 },
	{ 0xF5BB,  0xFD66 },
	{ 0xF5BC,  0xFD64 },
	{ 0xF5BD,  0xFD63 },
	{ 0xF5BE,  0xFD5F },
	{ 0xF5BF,  0xFD8C },
	{ 0xF5C0,  0x83AE },
	{ 0xF5C1,  0x83AD },
	{ 0xF5C2,  0x84AF },
	{ 0xF5C3,  0x84AE },
	{ 0xF5C4,  0x87CD },
	{ 0xF5C5,  0x87C7 },
	{ 0xF5C6,  0x87C8 },
	{ 0xF5C7,  0x8C40 },
	{ 0xF5C8,  0x8BFE },
	{ 0xF5C9,  0x8E68 },
	{ 0xF5CA,  0x8E6B },
	{ 0xF5CB,  0x8F62 },
	{ 0xF5CC,  0x91D7 },
	{ 0xF5CD,  0x9478 },
	{ 0xF5CE,  0x99D8 },
	{ 0xF5CF,  0x99D2 },
	{ 0xF5D0,  0x99D9 },
	{ 0xF5D1,  0x99CE },
	{ 0xF5D2,  0x99D6 },
	{ 0xF5D3,  0x9E96 },
	{ 0xF5D4,  0x9E97 },
	{ 0xF5D5,  0x9E9D },
	{ 0xF5D6,  0x9E9B },
	{ 0xF5D7,  0x9E9C },
	{ 0xF5D8,  0x9E98 },
	{ 0xF5D9,  0x9E99 },
	{ 0xF5DA,  0xECDF },
	{ 0xF5DB,  0xA07E },
	{ 0xF5DC,  0xA07D },
	{ 0xF5DD,  0xE2B5 },
	{ 0xF5DE,  0xAE5B },
	{ 0xF5DF,  0xB05E },
	{ 0xF5E0,  0xB291 },
	{ 0xF5E1,  0xB55D },
	{ 0xF5E2,  0xB561 },
	{ 0xF5E3,  0xB55F },
	{ 0xF5E4,  0xBB50 },
	{ 0xF5E5,  0xBB4F },
	{ 0xF5E6,  0xBC63 },
	{ 0xF5E7,  0xC06B },
	{ 0xF5E8,  0xC068 },
	{ 0xF5E9,  0xC069 },
	{ 0xF5EA,  0xC06C },
	{ 0xF5EB,  0xC067 },
	{ 0xF5EC,  0xC06E },
	{ 0xF5ED,  0xC09C },
	{ 0xF5EE,  0xC186 },
	{ 0xF5EF,  0xC269 },
	{ 0xF5F0,  0xC549 },
	{ 0xF5F1,  0xCC5A },
	{ 0xF5F2,  0xCC6A },
	{ 0xF5F3,  0xCC68 },
	{ 0xF5F4,  0xCC61 },
	{ 0xF5F5,  0xCC65 },
	{ 0xF5F6,  0xCC5E },
	{ 0xF5F7,  0xCC5B },
	{ 0xF5F8,  0xDEBE },
	{ 0xF5F9,  0xCC6E },
	{ 0xF5FA,  0xCC63 },
	{ 0xF5FB,  0xCC62 },
	{ 0xF5FC,  0xDEC0 },
	{ 0xF5FD,  0xCC60 },
	{ 0xF5FE,  0xCC67 },
	{ 0xF640,  0xD045 },
	{ 0xF641,  0xCF9C },
	{ 0xF642,  0xF3BA },
	{ 0xF643,  0xCF9F },
	{ 0xF644,  0xD040 },
	{ 0xF645,  0xCF9B },
	{ 0xF646,  0xD047 },
	{ 0xF647,  0xD060 },
	{ 0xF648,  0xD270 },
	{ 0xF649,  0xD26C },
	{ 0xF64A,  0xD271 },
	{ 0xF64B,  0xD26E },
	{ 0xF64C,  0xD37E },
	{ 0xF64D,  0xD771 },
	{ 0xF64E,  0xD770 },
	{ 0xF64F,  0xD6A0 },
	{ 0xF650,  0xD772 },
	{ 0xF651,  0xD773 },
	{ 0xF652,  0xDA42 },
	{ 0xF653,  0xDA46 },
	{ 0xF654,  0xDA8C },
	{ 0xF655,  0xDC54 },
	{ 0xF656,  0xDC52 },
	{ 0xF657,  0xDE59 },
	{ 0xF658,  0xDE56 },
	{ 0xF659,  0xDE58 },
	{ 0xF65A,  0xDBBA },
	{ 0xF65B,  0xE0A0 },
	{ 0xF65C,  0xE140 },
	{ 0xF65D,  0xE17D },
	{ 0xF65E,  0xE84F },
	{ 0xF65F,  0xE84C },
	{ 0xF660,  0xE847 },
	{ 0xF661,  0xE79B },
	{ 0xF662,  0xE84E },
	{ 0xF663,  0xE84D },
	{ 0xF664,  0xE841 },
	{ 0xF665,  0xE84A },
	{ 0xF666,  0xE79C },
	{ 0xF667,  0xE848 },
	{ 0xF668,  0xE79E },
	{ 0xF669,  0xE850 },
	{ 0xF66A,  0xE842 },
	{ 0xF66B,  0xEA59 },
	{ 0xF66C,  0xEA58 },
	{ 0xF66D,  0xEA57 },
	{ 0xF66E,  0xEC50 },
	{ 0xF66F,  0xEC53 },
	{ 0xF670,  0xED5A },
	{ 0xF671,  0xED7C },
	{ 0xF672,  0xEE96 },
	{ 0xF673,  0xEF6D },
	{ 0xF674,  0xEF6A },
	{ 0xF675,  0xEF64 },
	{ 0xF676,  0xF08C },
	{ 0xF677,  0xF08A },
	{ 0xF678,  0xF280 },
	{ 0xF679,  0xF284 },
	{ 0xF67A,  0xF28D },
	{ 0xF67B,  0xF28B },
	{ 0xF67C,  0xF289 },
	{ 0xF67D,  0xF288 },
	{ 0xF67E,  0xF281 },
	{ 0xF6A1,  0xF286 },
	{ 0xF6A2,  0xF372 },
	{ 0xF6A3,  0xF44B },
	{ 0xF6A4,  0xF44D },
	{ 0xF6A5,  0xF44E },
	{ 0xF6A6,  0xF44C },
	{ 0xF6A7,  0xF46C },
	{ 0xF6A8,  0xF477 },
	{ 0xF6A9,  0xF690 },
	{ 0xF6AA,  0xF682 },
	{ 0xF6AB,  0xF681 },
	{ 0xF6AC,  0xF691 },
	{ 0xF6AD,  0xF688 },
	{ 0xF6AE,  0xF68D },
	{ 0xF6AF,  0xF68E },
	{ 0xF6B0,  0xF689 },
	{ 0xF6B1,  0xF686 },
	{ 0xF6B2,  0xFA54 },
	{ 0xF6B3,  0xFA53 },
	{ 0xF6B4,  0xFA59 },
	{ 0xF6B5,  0xFA5E },
	{ 0xF6B6,  0xFA64 },
	{ 0xF6B7,  0xFA67 },
	{ 0xF6B8,  0xFA6C },
	{ 0xF6B9,  0xFA5B },
	{ 0xF6BA,  0xFA62 },
	{ 0xF6BB,  0xFA60 },
	{ 0xF6BC,  0xFA58 },
	{ 0xF6BD,  0xFA52 },
	{ 0xF6BE,  0xFA6B },
	{ 0xF6BF,  0xFA56 },
	{ 0xF6C0,  0xFA57 },
	{ 0xF6C1,  0xFA49 },
	{ 0xF6C2,  0xFA65 },
	{ 0xF6C3,  0xFA4E },
	{ 0xF6C4,  0xFA4A },
	{ 0xF6C5,  0xFA69 },
	{ 0xF6C6,  0xFA50 },
	{ 0xF6C7,  0xFA6A },
	{ 0xF6C8,  0xFA4F },
	{ 0xF6C9,  0xFB7A },
	{ 0xF6CA,  0xFB95 },
	{ 0xF6CB,  0xFC69 },
	{ 0xF6CC,  0xFC6C },
	{ 0xF6CD,  0xFC6B },
	{ 0xF6CE,  0xFC8E },
	{ 0xF6CF,  0xFC8C },
	{ 0xF6D0,  0xFC8D },
	{ 0xF6D1,  0xFCA0 },
	{ 0xF6D2,  0xFD56 },
	{ 0xF6D3,  0xFD6B },
	{ 0xF6D4,  0xFD6A },
	{ 0xF6D5,  0xFD8D },
	{ 0xF6D6,  0x8190 },
	{ 0xF6D7,  0x87D0 },
	{ 0xF6D8,  0x87CF },
	{ 0xF6D9,  0x87D4 },
	{ 0xF6DA,  0x8A61 },
	{ 0xF6DB,  0x8C43 },
	{ 0xF6DC,  0x8C44 },
	{ 0xF6DD,  0x8E71 },
	{ 0xF6DE,  0x8E6D },
	{ 0xF6DF,  0x8F63 },
	{ 0xF6E0,  0x947E },
	{ 0xF6E1,  0x947D },
	{ 0xF6E2,  0x9483 },
	{ 0xF6E3,  0x9480 },
	{ 0xF6E4,  0x99E1 },
	{ 0xF6E5,  0x99DE },
	{ 0xF6E6,  0x99DF },
	{ 0xF6E7,  0xEBAC },
	{ 0xF6E8,  0x9EA6 },
	{ 0xF6E9,  0x9EA7 },
	{ 0xF6EA,  0x9EA8 },
	{ 0xF6EB,  0x9EA3 },
	{ 0xF6EC,  0xA082 },
	{ 0xF6ED,  0xA083 },
	{ 0xF6EE,  0xA0E0 },
	{ 0xF6EF,  0xAB4C },
	{ 0xF6F0,  0xAD8F },
	{ 0xF6F1,  0xAD8C },
	{ 0xF6F2,  0xAD90 },
	{ 0xF6F3,  0xAD8E },
	{ 0xF6F4,  0xB060 },
	{ 0xF6F5,  0xB090 },
	{ 0xF6F6,  0xB564 },
	{ 0xF6F7,  0xB65E },
	{ 0xF6F8,  0xF0A6 },
	{ 0xF6F9,  0xB787 },
	{ 0xF6FA,  0xBB53 },
	{ 0xF6FB,  0xBB58 },
	{ 0xF6FC,  0xBB55 },
	{ 0xF6FD,  0xBB57 },
	{ 0xF6FE,  0xBB56 },
	{ 0xF740,  0xBC65 },
	{ 0xF741,  0xBC62 },
	{ 0xF742,  0xC072 },
	{ 0xF743,  0xC09E },
	{ 0xF744,  0xC161 },
	{ 0xF745,  0xC54A },
	{ 0xF746,  0xC641 },
	{ 0xF747,  0xCC74 },
	{ 0xF748,  0xCC75 },
	{ 0xF749,  0xCC73 },
	{ 0xF74A,  0xCC6C },
	{ 0xF74B,  0xCC72 },
	{ 0xF74C,  0xCC76 },
	{ 0xF74D,  0xD048 },
	{ 0xF74E,  0xD044 },
	{ 0xF74F,  0xD042 },
	{ 0xF750,  0xD046 },
	{ 0xF751,  0xD041 },
	{ 0xF752,  0xD274 },
	{ 0xF753,  0xD35D },
	{ 0xF754,  0xD35C },
	{ 0xF755,  0xD380 },
	{ 0xF756,  0xD776 },
	{ 0xF757,  0xD77C },
	{ 0xF758,  0xD77A },
	{ 0xF759,  0xD77E },
	{ 0xF75A,  0xD77D },
	{ 0xF75B,  0xD777 },
	{ 0xF75C,  0xDA47 },
	{ 0xF75D,  0xDC58 },
	{ 0xF75E,  0xF5F0 },
	{ 0xF75F,  0xDC5D },
	{ 0xF760,  0xDC56 },
	{ 0xF761,  0xF5F1 },
	{ 0xF762,  0xDC59 },
	{ 0xF763,  0xDC5A },
	{ 0xF764,  0xDE5B },
	{ 0xF765,  0xDE5D },
	{ 0xF766,  0xE141 },
	{ 0xF767,  0xE85C },
	{ 0xF768,  0xE860 },
	{ 0xF769,  0xE85A },
	{ 0xF76A,  0xE85B },
	{ 0xF76B,  0xE85F },
	{ 0xF76C,  0xE857 },
	{ 0xF76D,  0xE855 },
	{ 0xF76E,  0xE858 },
	{ 0xF76F,  0xE859 },
	{ 0xF770,  0xE856 },
	{ 0xF771,  0xEC57 },
	{ 0xF772,  0xED7E },
	{ 0xF773,  0xEE9C },
	{ 0xF774,  0xEE9B },
	{ 0xF775,  0xEF6F },
	{ 0xF776,  0xF7D3 },
	{ 0xF777,  0xF08F },
	{ 0xF778,  0xF295 },
	{ 0xF779,  0xF29A },
	{ 0xF77A,  0xF29B },
	{ 0xF77B,  0xF293 },
	{ 0xF77C,  0xF296 },
	{ 0xF77D,  0xF28F },
	{ 0xF77E,  0xF291 },
	{ 0xF7A1,  0xF290 },
	{ 0xF7A2,  0xF299 },
	{ 0xF7A3,  0xF297 },
	{ 0xF7A4,  0xF375 },
	{ 0xF7A5,  0xF44F },
	{ 0xF7A6,  0xF45F },
	{ 0xF7A7,  0xE5F7 },
	{ 0xF7A8,  0xF47A },
	{ 0xF7A9,  0xF479 },
	{ 0xF7AA,  0xF74A },
	{ 0xF7AB,  0xF74C },
	{ 0xF7AC,  0xF743 },
	{ 0xF7AD,  0xF748 },
	{ 0xF7AE,  0xF69E },
	{ 0xF7AF,  0xF698 },
	{ 0xF7B0,  0xF745 },
	{ 0xF7B1,  0xF740 },
	{ 0xF7B2,  0xF69C },
	{ 0xF7B3,  0xF699 },
	{ 0xF7B4,  0xF697 },
	{ 0xF7B5,  0xF741 },
	{ 0xF7B6,  0xF69B },
	{ 0xF7B7,  0xFA78 },
	{ 0xF7B8,  0xFA6F },
	{ 0xF7B9,  0xFA7B },
	{ 0xF7BA,  0xFA77 },
	{ 0xF7BB,  0xFA68 },
	{ 0xF7BC,  0xFA6D },
	{ 0xF7BD,  0xFA79 },
	{ 0xF7BE,  0xFA6E },
	{ 0xF7BF,  0xFA7C },
	{ 0xF7C0,  0xFA87 },
	{ 0xF7C1,  0xFA76 },
	{ 0xF7C2,  0xFA75 },
	{ 0xF7C3,  0xFA73 },
	{ 0xF7C4,  0xFA93 },
	{ 0xF7C5,  0xFA72 },
	{ 0xF7C6,  0xFA7A },
	{ 0xF7C7,  0xFC4A },
	{ 0xF7C8,  0xFC6D },
	{ 0xF7C9,  0xFD43 },
	{ 0xF7CA,  0xFD41 },
	{ 0xF7CB,  0xFD40 },
	{ 0xF7CC,  0xFD4B },
	{ 0xF7CD,  0xFD71 },
	{ 0xF7CE,  0xFD90 },
	{ 0xF7CF,  0xFD98 },
	{ 0xF7D0,  0x83B1 },
	{ 0xF7D1,  0x84B0 },
	{ 0xF7D2,  0x89CD },
	{ 0xF7D3,  0x89CC },
	{ 0xF7D4,  0x8A62 },
	{ 0xF7D5,  0x8C45 },
	{ 0xF7D6,  0x8E74 },
	{ 0xF7D7,  0xD04B },
	{ 0xF7D8,  0x8F9E },
	{ 0xF7D9,  0x91DA },
	{ 0xF7DA,  0x91DC },
	{ 0xF7DB,  0x91DD },
	{ 0xF7DC,  0x9486 },
	{ 0xF7DD,  0xDFAC },
	{ 0xF7DE,  0x94CD },
	{ 0xF7DF,  0x95F0 },
	{ 0xF7E0,  0x99E7 },
	{ 0xF7E1,  0x99E8 },
	{ 0xF7E2,  0x99E5 },
	{ 0xF7E3,  0x9AAE },
	{ 0xF7E4,  0x9EAC },
	{ 0xF7E5,  0x9EAB },
	{ 0xF7E6,  0xA086 },
	{ 0xF7E7,  0xAB4F },
	{ 0xF7E8,  0xAB4E },
	{ 0xF7E9,  0xAB50 },
	{ 0xF7EA,  0xB062 },
	{ 0xF7EB,  0xB295 },
	{ 0xF7EC,  0xBB63 },
	{ 0xF7ED,  0xBB62 },
	{ 0xF7EE,  0xC076 },
	{ 0xF7EF,  0xC642 },
	{ 0xF7F0,  0xCC79 },
	{ 0xF7F1,  0xCC7E },
	{ 0xF7F2,  0xCC78 },
	{ 0xF7F3,  0xDEC2 },
	{ 0xF7F4,  0xCC71 },
	{ 0xF7F5,  0xCC7A },
	{ 0xF7F6,  0xCC7C },
	{ 0xF7F7,  0xD04C },
	{ 0xF7F8,  0xEEC3 },
	{ 0xF7F9,  0xD04A },
	{ 0xF7FA,  0xD04E },
	{ 0xF7FB,  0xD279 },
	{ 0xF7FC,  0xD277 },
	{ 0xF7FD,  0xD276 },
	{ 0xF7FE,  0xD383 },
	{ 0xF840,  0xD785 },
	{ 0xF841,  0xD787 },
	{ 0xF842,  0xD784 },
	{ 0xF843,  0xD781 },
	{ 0xF844,  0xD84C },
	{ 0xF845,  0xDA4B },
	{ 0xF846,  0xDC5B },
	{ 0xF847,  0xDE5F },
	{ 0xF848,  0xDE5E },
	{ 0xF849,  0xE180 },
	{ 0xF84A,  0xE872 },
	{ 0xF84B,  0xE865 },
	{ 0xF84C,  0xE86D },
	{ 0xF84D,  0xE867 },
	{ 0xF84E,  0xE86E },
	{ 0xF84F,  0xED5F },
	{ 0xF850,  0xED60 },
	{ 0xF851,  0xED92 },
	{ 0xF852,  0xF29D },
	{ 0xF853,  0xF2A0 },
	{ 0xF854,  0xF454 },
	{ 0xF855,  0xF7DF },
	{ 0xF856,  0xF455 },
	{ 0xF857,  0xF756 },
	{ 0xF858,  0xF75C },
	{ 0xF859,  0xF754 },
	{ 0xF85A,  0xF74E },
	{ 0xF85B,  0xF751 },
	{ 0xF85C,  0xF74F },
	{ 0xF85D,  0xF759 },
	{ 0xF85E,  0xF75D },
	{ 0xF85F,  0xF750 },
	{ 0xF860,  0xF752 },
	{ 0xF861,  0xFA99 },
	{ 0xF862,  0xFA95 },
	{ 0xF863,  0xFA8D },
	{ 0xF864,  0xFA81 },
	{ 0xF865,  0xFA89 },
	{ 0xF866,  0xFA96 },
	{ 0xF867,  0xFA82 },
	{ 0xF868,  0xFA94 },
	{ 0xF869,  0xFA7E },
	{ 0xF86A,  0xFA8C },
	{ 0xF86B,  0xFA84 },
	{ 0xF86C,  0xFA90 },
	{ 0xF86D,  0xFA8E },
	{ 0xF86E,  0xFA80 },
	{ 0xF86F,  0xFA8A },
	{ 0xF870,  0xFA92 },
	{ 0xF871,  0xFA91 },
	{ 0xF872,  0xFA86 },
	{ 0xF873,  0xFA8B },
	{ 0xF874,  0xFC52 },
	{ 0xF875,  0xFC5B },
	{ 0xF876,  0xFC6F },
	{ 0xF877,  0xFC70 },
	{ 0xF878,  0xFC80 },
	{ 0xF879,  0xFC8F },
	{ 0xF87A,  0xFD45 },
	{ 0xF87B,  0xF7FB },
	{ 0xF87C,  0xFD44 },
	{ 0xF87D,  0xFD4C },
	{ 0xF87E,  0xFD57 },
	{ 0xF8A1,  0xFD77 },
	{ 0xF8A2,  0xFD76 },
	{ 0xF8A3,  0xFD74 },
	{ 0xF8A4,  0xFD75 },
	{ 0xF8A5,  0x87DC },
	{ 0xF8A6,  0x87D6 },
	{ 0xF8A7,  0x8C46 },
	{ 0xF8A8,  0x8CDA },
	{ 0xF8A9,  0x9489 },
	{ 0xF8AA,  0x95F2 },
	{ 0xF8AB,  0x95F3 },
	{ 0xF8AC,  0x99E9 },
	{ 0xF8AD,  0x9EAF },
	{ 0xF8AE,  0x9EB1 },
	{ 0xF8AF,  0x9EAE },
	{ 0xF8B0,  0x9EB0 },
	{ 0xF8B1,  0xA087 },
	{ 0xF8B2,  0xAD92 },
	{ 0xF8B3,  0xAD96 },
	{ 0xF8B4,  0xB296 },
	{ 0xF8B5,  0xB567 },
	{ 0xF8B6,  0xB661 },
	{ 0xF8B7,  0xB660 },
	{ 0xF8B8,  0xBB66 },
	{ 0xF8B9,  0xC078 },
	{ 0xF8BA,  0xC163 },
	{ 0xF8BB,  0xC643 },
	{ 0xF8BC,  0xCC82 },
	{ 0xF8BD,  0xD053 },
	{ 0xF8BE,  0xD052 },
	{ 0xF8BF,  0xD050 },
	{ 0xF8C0,  0xD061 },
	{ 0xF8C1,  0xD78D },
	{ 0xF8C2,  0xD78E },
	{ 0xF8C3,  0xF5F3 },
	{ 0xF8C4,  0xDC60 },
	{ 0xF8C5,  0xDC61 },
	{ 0xF8C6,  0xDC5F },
	{ 0xF8C7,  0xE182 },
	{ 0xF8C8,  0xE181 },
	{ 0xF8C9,  0xE186 },
	{ 0xF8CA,  0xF6CE },
	{ 0xF8CB,  0xE878 },
	{ 0xF8CC,  0xE879 },
	{ 0xF8CD,  0xEB7B },
	{ 0xF8CE,  0xEC5E },
	{ 0xF8CF,  0xEC5B },
	{ 0xF8D0,  0xEC5F },
	{ 0xF8D1,  0xED62 },
	{ 0xF8D2,  0xED81 },
	{ 0xF8D3,  0xF344 },
	{ 0xF8D4,  0xF378 },
	{ 0xF8D5,  0xF47D },
	{ 0xF8D6,  0xF767 },
	{ 0xF8D7,  0xF76B },
	{ 0xF8D8,  0xF76A },
	{ 0xF8D9,  0xF766 },
	{ 0xF8DA,  0xF762 },
	{ 0xF8DB,  0xF764 },
	{ 0xF8DC,  0xFAA0 },
	{ 0xF8DD,  0xFA9C },
	{ 0xF8DE,  0xFB44 },
	{ 0xF8DF,  0xFB40 },
	{ 0xF8E0,  0xFB43 },
	{ 0xF8E1,  0xFB42 },
	{ 0xF8E2,  0xFA9E },
	{ 0xF8E3,  0xFA9F },
	{ 0xF8E4,  0xFB46 },
	{ 0xF8E5,  0xFA9D },
	{ 0xF8E6,  0xFA9B },
	{ 0xF8E7,  0xFB41 },
	{ 0xF8E8,  0xFB97 },
	{ 0xF8E9,  0xFC91 },
	{ 0xF8EA,  0xFD4E },
	{ 0xF8EB,  0xFD7A },
	{ 0xF8EC,  0xFD7B },
	{ 0xF8ED,  0xFD7C },
	{ 0xF8EE,  0xE0EC },
	{ 0xF8EF,  0xDFAD },
	{ 0xF8F0,  0x94E1 },
	{ 0xF8F1,  0x99EE },
	{ 0xF8F2,  0x99EF },
	{ 0xF8F3,  0x99ED },
	{ 0xF8F4,  0x99F0 },
	{ 0xF8F5,  0x9EB2 },
	{ 0xF8F6,  0xA08A },
	{ 0xF8F7,  0xA0E1 },
	{ 0xF8F8,  0xB298 },
	{ 0xF8F9,  0xB299 },
	{ 0xF8FA,  0xB568 },
	{ 0xF8FB,  0xBB65 },
	{ 0xF8FC,  0xBB67 },
	{ 0xF8FD,  0xBC67 },
	{ 0xF8FE,  0xC07B },
	{ 0xF940,  0xC079 },
	{ 0xF941,  0xF4EE },
	{ 0xF942,  0xC07A },
	{ 0xF943,  0xC54C },
	{ 0xF944,  0xC54D },
	{ 0xF945,  0xCC85 },
	{ 0xF946,  0xCC86 },
	{ 0xF947,  0xCC87 },
	{ 0xF948,  0xD27C },
	{ 0xF949,  0xD27D },
	{ 0xF94A,  0xD27E },
	{ 0xF94B,  0xF1E1 },
	{ 0xF94C,  0xD384 },
	{ 0xF94D,  0xD791 },
	{ 0xF94E,  0xD792 },
	{ 0xF94F,  0xDC66 },
	{ 0xF950,  0xDC65 },
	{ 0xF951,  0xDC64 },
	{ 0xF952,  0xE87D },
	{ 0xF953,  0xE87C },
	{ 0xF954,  0xE87E },
	{ 0xF955,  0xE881 },
	{ 0xF956,  0xE883 },
	{ 0xF957,  0xEC61 },
	{ 0xF958,  0xEF43 },
	{ 0xF959,  0xF093 },
	{ 0xF95A,  0xF76C },
	{ 0xF95B,  0xF772 },
	{ 0xF95C,  0xF771 },
	{ 0xF95D,  0xFB48 },
	{ 0xF95E,  0xFB4A },
	{ 0xF95F,  0xFB4D },
	{ 0xF960,  0xFB4C },
	{ 0xF961,  0xFB4F },
	{ 0xF962,  0xFB4E },
	{ 0xF963,  0xFB98 },
	{ 0xF964,  0xFC72 },
	{ 0xF965,  0xFC83 },
	{ 0xF966,  0xFD4F },
	{ 0xF967,  0xFD7E },
	{ 0xF968,  0xFD82 },
	{ 0xF969,  0xFD81 },
	{ 0xF96A,  0xFD80 },
	{ 0xF96B,  0x884B },
	{ 0xF96C,  0x9EB6 },
	{ 0xF96D,  0xBB6B },
	{ 0xF96E,  0xF3BD },
	{ 0xF96F,  0xDA8E },
	{ 0xF970,  0xDC67 },
	{ 0xF971,  0xE187 },
	{ 0xF972,  0xE884 },
	{ 0xF973,  0xE888 },
	{ 0xF974,  0xE886 },
	{ 0xF975,  0xE885 },
	{ 0xF976,  0xF346 },
	{ 0xF977,  0xF778 },
	{ 0xF978,  0xF777 },
	{ 0xF979,  0xF775 },
	{ 0xF97A,  0xF779 },
	{ 0xF97B,  0xFB51 },
	{ 0xF97C,  0xFB50 },
	{ 0xF97D,  0xFC73 },
	{ 0xF97E,  0xFC84 },
	{ 0xF9A1,  0xFD9A },
	{ 0xF9A2,  0x9EB8 },
	{ 0xF9A3,  0x9EB5 },
	{ 0xF9A4,  0xBC68 },
	{ 0xF9A5,  0xCCA0 },
	{ 0xF9A6,  0xD057 },
	{ 0xF9A7,  0xD056 },
	{ 0xF9A8,  0xD058 },
	{ 0xF9A9,  0xD797 },
	{ 0xF9AA,  0xD88F },
	{ 0xF9AB,  0xDC6A },
	{ 0xF9AC,  0xDC86 },
	{ 0xF9AD,  0xEC63 },
	{ 0xF9AE,  0xEF44 },
	{ 0xF9AF,  0xEF45 },
	{ 0xF9B0,  0xEF70 },
	{ 0xF9B1,  0xF095 },
	{ 0xF9B2,  0xF151 },
	{ 0xF9B3,  0xF34A },
	{ 0xF9B4,  0xF34C },
	{ 0xF9B5,  0xF34D },
	{ 0xF9B6,  0xF458 },
	{ 0xF9B7,  0xFB52 },
	{ 0xF9B8,  0xFB54 },
	{ 0xF9B9,  0xFD50 },
	{ 0xF9BA,  0x91DF },
	{ 0xF9BB,  0x99F4 },
	{ 0xF9BC,  0xA08B },
	{ 0xF9BD,  0xCC8B },
	{ 0xF9BE,  0xDC69 },
	{ 0xF9BF,  0xE892 },
	{ 0xF9C0,  0xE890 },
	{ 0xF9C1,  0xE891 },
	{ 0xF9C2,  0xF34F },
	{ 0xF9C3,  0xF34E },
	{ 0xF9C4,  0xF462 },
	{ 0xF9C5,  0xFB56 },
	{ 0xF9C6,  0xA08C },
	{ 0xF9C7,  0xCC8A },
	{ 0xF9C8,  0xD798 },
	{ 0xF9C9,  0xE893 },
	{ 0xF9CA,  0xF77D },
	{ 0xF9CB,  0xFC4B },
	{ 0xF9CC,  0xB067 },
	{ 0xF9CD,  0xF351 },
	{ 0xF9CE,  0xF77E },
	{ 0xF9CF,  0xFB5A },
	{ 0xF9D0,  0x9EB9 },
	{ 0xF9D1,  0x9EBA },
	{ 0xF9D2,  0xFB9B },
	{ 0xF9D3,  0xFD85 },
	{ 0xF9D4,  0xFD51 },
	{ 0xF9D5,  0xFD93 },
	{ 0xF9D6,  0xB39E },
	{ 0xF9D7,  0xE450 },
	{ 0xF9D8,  0xD159 },
	{ 0xF9D9,  0x89A6 },
	{ 0xF9DA,  0xBAE3 },
	{ 0xF9DB,  0xBB92 },
	{ 0xF9DC,  0x8BB8 },
	{ 0xF9DD,  0xA858 },
	{ 0xF9DE,  0xA86A },
	{ 0xF9DF,  0xA85B },
	{ 0xF9E0,  0xA864 },
	{ 0xF9E1,  0xA870 },
	{ 0xF9E2,  0xA867 },
	{ 0xF9E3,  0xA85E },
	{ 0xF9E4,  0xA86D },
	{ 0xF9E5,  0xA861 },
	{ 0xF9E6,  0xA856 },
	{ 0xF9E7,  0xA868 },
	{ 0xF9E8,  0xA859 },
	{ 0xF9E9,  0xA862 },
	{ 0xF9EA,  0xA86E },
	{ 0xF9EB,  0xA865 },
	{ 0xF9EC,  0xA85C },
	{ 0xF9ED,  0xA86B },
	{ 0xF9EE,  0xA85F },
	{ 0xF9EF,  0xA857 },
	{ 0xF9F0,  0xA869 },
	{ 0xF9F1,  0xA85A },
	{ 0xF9F2,  0xA863 },
	{ 0xF9F3,  0xA86F },
	{ 0xF9F4,  0xA866 },
	{ 0xF9F5,  0xA85D },
	{ 0xF9F6,  0xA86C },
	{ 0xF9F7,  0xA860 },
	{ 0xF9F8,  0xA855 },
	{ 0xF9F9,  0xA854 },
	{ 0xF9FA,  0xA871 },
	{ 0xF9FB,  0xA872 },
	{ 0xF9FC,  0xA874 },
	{ 0xF9FD,  0xA873 },
	{ 0xF9FE,  0x8431A331 },
	{ 0xFA40,  0xAAA1 },
	{ 0xFA41,  0xE471 },
	{ 0xFA42,  0xAAA3 },
	{ 0xFA43,  0xAAA4 },
	{ 0xFA44,  0xCA75 },
	{ 0xFA45,  0x8232EB38 },
	{ 0xFA46,  0xAB99 },
	{ 0xFA47,  0xBFF6 },
	{ 0xFA48,  0x8230AA39 },
	{ 0xFA49,  0xAAAA },
	{ 0xFA4A,  0xAAAB },
	{ 0xFA4B,  0xE579 },
	{ 0xFA4C,  0xAAAD },
	{ 0xFA4D,  0xC678 },
	{ 0xFA4E,  0xAAAF },
	{ 0xFA4F,  0xEDC5 },
	{ 0xFA50,  0x9665 },
	{ 0xFA51,  0xC4E2 },
	{ 0xFA52,  0xAAB3 },
	{ 0xFA53,  0xAAB4 },
	{ 0xFA54,  0xAAB5 },
	{ 0xFA55,  0xAAB6 },
	{ 0xFA56,  0xAAB7 },
	{ 0xFA57,  0x8241 },
	{ 0xFA58,  0xAAB9 },
	{ 0xFA59,  0x827C },
	{ 0xFA5A,  0xAABB },
	{ 0xFA5B,  0xAABC },
	{ 0xFA5C,  0xAABD },
	{ 0xFA5D,  0xAABE },
	{ 0xFA5E,  0xAABF },
	{ 0xFA60,  0xAAC1 },
	{ 0xFA61,  0x8FC9 },
	{ 0xFA62,  0xAAC3 },
	{ 0xFA63,  0xAAC4 },
	{ 0xFA64,  0x9CF4 },
	{ 0xFA65,  0xAAC6 },
	{ 0xFA67,  0x8379 },
	{ 0xFA68,  0x8139FA39 },
	{ 0xFA69,  0x8384 },
	{ 0xFA6A,  0xEE9E },
	{ 0xFA6B,  0x8230C339 },
	{ 0xFA6C,  0xC858 },
	{ 0xFA6D,  0xAACE },
	{ 0xFA6E,  0xAACF },
	{ 0xFA6F,  0x83C3 },
	{ 0xFA70,  0xAAD1 },
	{ 0xFA71,  0x83CA },
	{ 0xFA72,  0xAAD3 },
	{ 0xFA73,  0xAAD4 },
	{ 0xFA74,  0xAAD5 },
	{ 0xFA75,  0xAAD6 },
	{ 0xFA76,  0xAAD7 },
	{ 0xFA77,  0xAAD8 },
	{ 0xFA78,  0xAAD9 },
	{ 0xFA79,  0x8C5D },
	{ 0xFA7A,  0xF2ED },
	{ 0xFA7B,  0xAADC },
	{ 0xFA7C,  0xAADD },
	{ 0xFA7D,  0xB3E5 },
	{ 0xFA7E,  0x83EB },
	{ 0xFAA1,  0xF892 },
	{ 0xFAA2,  0xC1B9 },
	{ 0xFAA3,  0xBCF5 },
	{ 0xFAA4,  0xB4D5 },
	{ 0xFAA5,  0x8231D434 },
	{ 0xFAA6,  0x83FA },
	{ 0xFAA7,  0xAAE6 },
	{ 0xFAA8,  0xBEF6 },
	{ 0xFAA9,  0x8446 },
	{ 0xFAAA,  0x855F },
	{ 0xFAAB,  0xC6BE },
	{ 0xFAAC,  0xC78C },
	{ 0xFAAD,  0x97E4 },
	{ 0xFAAE,  0xAAED },
	{ 0xFAAF,  0xB3B9 },
	{ 0xFAB0,  0x8458 },
	{ 0xFAB1,  0x8466 },
	{ 0xFAB2,  0x846F },
	{ 0xFAB3,  0x84BB },
	{ 0xFAB4,  0x847D },
	{ 0xFAB5,  0x84AB },
	{ 0xFAB6,  0x84BF },
	{ 0xFAB7,  0x84C8 },
	{ 0xFAB8,  0xBA7B },
	{ 0xFAB9,  0xCA6F },
	{ 0xFABA,  0x84DB },
	{ 0xFABB,  0xCC51 },
	{ 0xFABC,  0xAAFB },
	{ 0xFABE,  0xAAFD },
	{ 0xFABF,  0xDFF8 },
	{ 0xFAC0,  0x9CF3 },
	{ 0xFAC1,  0xABA2 },
	{ 0xFAC2,  0xABA3 },
	{ 0xFAC3,  0xABA4 },
	{ 0xFAC4,  0x8556 },
	{ 0xFAC6,  0xABA7 },
	{ 0xFAC7,  0x9B78 },
	{ 0xFAC8,  0xABA9 },
	{ 0xFAC9,  0x96DB },
	{ 0xFACA,  0xAB86 },
	{ 0xFACB,  0x9065 },
	{ 0xFACC,  0x82328435 },
	{ 0xFACD,  0x8230EB32 },
	{ 0xFACE,  0xABAF },
	{ 0xFACF,  0xA047 },
	{ 0xFAD0,  0x82339E37 },
	{ 0xFAD1,  0x856F },
	{ 0xFAD2,  0xC8B4 },
	{ 0xFAD3,  0xABB4 },
	{ 0xFAD4,  0x8576 },
	{ 0xFAD6,  0xABB7 },
	{ 0xFAD7,  0xABB8 },
	{ 0xFAD8,  0xB340 },
	{ 0xFAD9,  0x8583 },
	{ 0xFADA,  0xABBB },
	{ 0xFADB,  0x858B },
	{ 0xFADC,  0x8590 },
	{ 0xFADD,  0xD8CB },
	{ 0xFADE,  0xAB6A },
	{ 0xFADF,  0xABC0 },
	{ 0xFAE0,  0x82329630 },
	{ 0xFAE1,  0xAB61 },
	{ 0xFAE2,  0xC8FE },
	{ 0xFAE3,  0x85A4 },
	{ 0xFAE4,  0xBABA },
	{ 0xFAE5,  0xD2E5 },
	{ 0xFAE6,  0x88CF },
	{ 0xFAE7,  0xD0F0 },
	{ 0xFAE8,  0x82319C35 },
	{ 0xFAE9,  0xABCA },
	{ 0xFAEA,  0xB5FE },
	{ 0xFAEB,  0xABCC },
	{ 0xFAEC,  0xABCD },
	{ 0xFAED,  0xD2B6 },
	{ 0xFAEE,  0xABCF },
	{ 0xFAEF,  0xCFC5 },
	{ 0xFAF0,  0x9EC1 },
	{ 0xFAF1,  0x8682 },
	{ 0xFAF2,  0xEACF },
	{ 0xFAF3,  0x9BBF },
	{ 0xFAF4,  0x85E5 },
	{ 0xFAF5,  0xABD6 },
	{ 0xFAF6,  0xABD7 },
	{ 0xFAF7,  0x86A0 },
	{ 0xFAF8,  0xD3BD },
	{ 0xFAF9,  0xDFE5 },
	{ 0xFAFA,  0x8233EB32 },
	{ 0xFAFB,  0xABDC },
	{ 0xFAFC,  0xABDD },
	{ 0xFAFD,  0x8231E939 },
	{ 0xFAFE,  0xABDF },
	{ 0xFB40,  0xABE0 },
	{ 0xFB41,  0xABE1 },
	{ 0xFB42,  0x8690 },
	{ 0xFB43,  0x8234F236 },
	{ 0xFB44,  0xC6F4 },
	{ 0xFB45,  0xAC58 },
	{ 0xFB46,  0x86B4 },
	{ 0xFB47,  0x86C9 },
	{ 0xFB49,  0xABE9 },
	{ 0xFB4A,  0xABEA },
	{ 0xFB4B,  0x8233B032 },
	{ 0xFB4C,  0xABEC },
	{ 0xFB4D,  0x95C1 },
	{ 0xFB4E,  0xABEE },
	{ 0xFB4F,  0x875F },
	{ 0xFB50,  0x95D8 },
	{ 0xFB51,  0xABF1 },
	{ 0xFB52,  0x95B5 },
	{ 0xFB53,  0x95BC },
	{ 0xFB54,  0xE0DD },
	{ 0xFB55,  0x8771 },
	{ 0xFB56,  0xB48B },
	{ 0xFB57,  0xB4D1 },
	{ 0xFB58,  0xEC90 },
	{ 0xFB59,  0x85B6 },
	{ 0xFB5A,  0x87F3 },
	{ 0xFB5B,  0x87EB },
	{ 0xFB5C,  0xD4B0 },
	{ 0xFB5D,  0xABFD },
	{ 0xFB5E,  0x8230A731 },
	{ 0xFB5F,  0xACA1 },
	{ 0xFB60,  0x8862 },
	{ 0xFB61,  0xACA3 },
	{ 0xFB62,  0x9B4A },
	{ 0xFB63,  0x9ECC },
	{ 0xFB64,  0xDBE0 },
	{ 0xFB65,  0x8230B533 },
	{ 0xFB66,  0xACA8 },
	{ 0xFB67,  0x88BE },
	{ 0xFB68,  0xACAA },
	{ 0xFB69,  0x88D2 },
	{ 0xFB6A,  0xACAC },
	{ 0xFB6B,  0xACAD },
	{ 0xFB6C,  0x88EA },
	{ 0xFB6D,  0xACAF },
	{ 0xFB6E,  0x8958 },
	{ 0xFB6F,  0x8995 },
	{ 0xFB70,  0x82309430 },
	{ 0xFB71,  0x89C6 },
	{ 0xFB72,  0x89C2 },
	{ 0xFB73,  0xACB5 },
	{ 0xFB74,  0x89D9 },
	{ 0xFB75,  0xCAD9 },
	{ 0xFB76,  0x885F },
	{ 0xFB77,  0xACB9 },
	{ 0xFB78,  0xACBA },
	{ 0xFB79,  0xE745 },
	{ 0xFB7A,  0x82309A33 },
	{ 0xFB7B,  0xB9BB },
	{ 0xFB7C,  0xC3CE },
	{ 0xFB7D,  0x8230B731 },
	{ 0xFB7E,  0x9C99 },
	{ 0xFBA1,  0xACC1 },
	{ 0xFBA2,  0x8ACF },
	{ 0xFBA3,  0x8699 },
	{ 0xFBA4,  0xACC4 },
	{ 0xFBA5,  0xCA42 },
	{ 0xFBA6,  0x8A97 },
	{ 0xFBA7,  0xACC7 },
	{ 0xFBA8,  0xACC8 },
	{ 0xFBA9,  0xACC9 },
	{ 0xFBAA,  0xACCA },
	{ 0xFBAB,  0x8A9E },
	{ 0xFBAC,  0xACCC },
	{ 0xFBAD,  0xACCD },
	{ 0xFBAE,  0xACCE },
	{ 0xFBAF,  0x9BCC },
	{ 0xFBB0,  0xACD0 },
	{ 0xFBB1,  0xACD1 },
	{ 0xFBB2,  0xE6B1 },
	{ 0xFBB3,  0xACD3 },
	{ 0xFBB4,  0x8B7D },
	{ 0xFBB5,  0x8B41 },
	{ 0xFBB6,  0x8230BA36 },
	{ 0xFBB7,  0xACD7 },
	{ 0xFBB9,  0x8230BE30 },
	{ 0xFBBA,  0x8B6B },
	{ 0xFBBB,  0xAC8F },
	{ 0xFBBC,  0x8B9C },
	{ 0xFBBD,  0xACDD },
	{ 0xFBBE,  0xACDE },
	{ 0xFBBF,  0x8231E532 },
	{ 0xFBC0,  0xACE0 },
	{ 0xFBC1,  0x8230C232 },
	{ 0xFBC2,  0xACE2 },
	{ 0xFBC3,  0x8EDA },
	{ 0xFBC4,  0xDBC2 },
	{ 0xFBC5,  0x8C55 },
	{ 0xFBC6,  0x94C4 },
	{ 0xFBC7,  0x8C5A },
	{ 0xFBC8,  0xACE8 },
	{ 0xFBC9,  0x8232A731 },
	{ 0xFBCA,  0x8233FD35 },
	{ 0xFBCB,  0xACEB },
	{ 0xFBCC,  0x8C82 },
	{ 0xFBCD,  0x9152 },
	{ 0xFBCE,  0xACEE },
	{ 0xFBCF,  0xACEF },
	{ 0xFBD0,  0xACF0 },
	{ 0xFBD1,  0x8C97 },
	{ 0xFBD2,  0xB1A6 },
	{ 0xFBD3,  0x8234F631 },
	{ 0xFBD4,  0x8CA1 },
	{ 0xFBD5,  0xACF5 },
	{ 0xFBD6,  0x8CAA },
	{ 0xFBD7,  0xAB82 },
	{ 0xFBD8,  0xB6FB },
	{ 0xFBD9,  0xACF9 },
	{ 0xFBDA,  0xACFA },
	{ 0xFBDB,  0xCCEB },
	{ 0xFBDC,  0x82348C33 },
	{ 0xFBDD,  0x8CEA },
	{ 0xFBDE,  0x8D6B },
	{ 0xFBDF,  0x8D6F },
	{ 0xFBE0,  0x8DEB },
	{ 0xFBE1,  0xADA3 },
	{ 0xFBE2,  0xADA4 },
	{ 0xFBE3,  0x8D8A },
	{ 0xFBE4,  0x8D90 },
	{ 0xFBE5,  0x8DB3 },
	{ 0xFBE6,  0xADA8 },
	{ 0xFBE7,  0x8D48 },
	{ 0xFBE8,  0x8E73 },
	{ 0xFBE9,  0xC681 },
	{ 0xFBEA,  0x8230DB33 },
	{ 0xFBEB,  0xADAD },
	{ 0xFBEC,  0xADAE },
	{ 0xFBED,  0xADAF },
	{ 0xFBEE,  0xC650 },
	{ 0xFBEF,  0x8230DC32 },
	{ 0xFBF0,  0x8231B833 },
	{ 0xFBF1,  0xB0EF },
	{ 0xFBF2,  0x9967 },
	{ 0xFBF4,  0xE7DB },
	{ 0xFBF5,  0xADB7 },
	{ 0xFBF6,  0xADB8 },
	{ 0xFBF7,  0xCFC3 },
	{ 0xFBF8,  0x818E },
	{ 0xFBFA,  0xB3F8 },
	{ 0xFBFB,  0xADBD },
	{ 0xFBFC,  0x8E8C },
	{ 0xFBFD,  0xDBC8 },
	{ 0xFBFE,  0xADC0 },
	{ 0xFC40,  0x8F67 },
	{ 0xFC41,  0x8F68 },
	{ 0xFC42,  0x8230E638 },
	{ 0xFC43,  0x8F69 },
	{ 0xFC44,  0xE8EF },
	{ 0xFC45,  0xE78D },
	{ 0xFC46,  0x8F70 },
	{ 0xFC47,  0xADC8 },
	{ 0xFC48,  0xADC9 },
	{ 0xFC49,  0x8231A136 },
	{ 0xFC4A,  0x82348736 },
	{ 0xFC4B,  0xADCC },
	{ 0xFC4C,  0xC7BF },
	{ 0xFC4D,  0xADCE },
	{ 0xFC4E,  0xADCF },
	{ 0xFC50,  0xADD1 },
	{ 0xFC51,  0x8FA8 },
	{ 0xFC52,  0xED58 },
	{ 0xFC53,  0xADD4 },
	{ 0xFC54,  0x8FAF },
	{ 0xFC55,  0xE575 },
	{ 0xFC56,  0xADD7 },
	{ 0xFC57,  0x8FCC },
	{ 0xFC58,  0x8E55 },
	{ 0xFC59,  0x8231E134 },
	{ 0xFC5A,  0xADDB },
	{ 0xFC5B,  0xADDC },
	{ 0xFC5C,  0xADDD },
	{ 0xFC5D,  0xADDE },
	{ 0xFC5E,  0xE192 },
	{ 0xFC5F,  0xADE0 },
	{ 0xFC60,  0xADE1 },
	{ 0xFC61,  0x9053 },
	{ 0xFC62,  0x959C },
	{ 0xFC63,  0xADE4 },
	{ 0xFC64,  0x8230FA32 },
	{ 0xFC65,  0x8231EB38 },
	{ 0xFC66,  0x8230A933 },
	{ 0xFC67,  0x8888 },
	{ 0xFC68,  0xADE9 },
	{ 0xFC69,  0xB588 },
	{ 0xFC6A,  0x8231F739 },
	{ 0xFC6B,  0x9092 },
	{ 0xFC6D,  0x909C },
	{ 0xFC6E,  0xADEF },
	{ 0xFC6F,  0xADF0 },
	{ 0xFC70,  0xADF1 },
	{ 0xFC71,  0xAD5F },
	{ 0xFC72,  0x8361 },
	{ 0xFC73,  0x8B73 },
	{ 0xFC74,  0x9155 },
	{ 0xFC75,  0xD3A9 },
	{ 0xFC76,  0x90FA },
	{ 0xFC77,  0xADF8 },
	{ 0xFC78,  0xADF9 },
	{ 0xFC79,  0x916D },
	{ 0xFC7A,  0x8452 },
	{ 0xFC7B,  0xADFC },
	{ 0xFC7C,  0x9173 },
	{ 0xFC7D,  0xCFDC },
	{ 0xFC7E,  0xAEA1 },
	{ 0xFCA1,  0xAEA2 },
	{ 0xFCA2,  0x91B0 },
	{ 0xFCA3,  0xAEA4 },
	{ 0xFCA4,  0xAEA5 },
	{ 0xFCA5,  0x91AF },
	{ 0xFCA6,  0x8230F533 },
	{ 0xFCA7,  0xAEA8 },
	{ 0xFCA8,  0xAEA9 },
	{ 0xFCA9,  0x904D },
	{ 0xFCAA,  0x914F },
	{ 0xFCAB,  0x947B },
	{ 0xFCAC,  0x92E3 },
	{ 0xFCAD,  0xAEAE },
	{ 0xFCAE,  0xB5A3 },
	{ 0xFCAF,  0xAEB0 },
	{ 0xFCB0,  0x9284 },
	{ 0xFCB1,  0xAEB2 },
	{ 0xFCB2,  0x92D1 },
	{ 0xFCB3,  0xAEB4 },
	{ 0xFCB4,  0x82318D38 },
	{ 0xFCB5,  0x938E },
	{ 0xFCB6,  0xDEEA },
	{ 0xFCB7,  0xAEB8 },
	{ 0xFCB8,  0xAEB9 },
	{ 0xFCBA,  0x9DB4 },
	{ 0xFCBB,  0xAEBC },
	{ 0xFCBC,  0xEE45 },
	{ 0xFCBD,  0xAEBE },
	{ 0xFCBE,  0xAEBF },
	{ 0xFCBF,  0x9445 },
	{ 0xFCC0,  0x9447 },
	{ 0xFCC1,  0xE88B },
	{ 0xFCC2,  0x82319537 },
	{ 0xFCC3,  0xD0AF },
	{ 0xFCC4,  0x82319432 },
	{ 0xFCC5,  0x949B },
	{ 0xFCC6,  0x9D5D },
	{ 0xFCC7,  0xAEC8 },
	{ 0xFCC8,  0xAEC9 },
	{ 0xFCC9,  0x94C2 },
	{ 0xFCCA,  0x94AE },
	{ 0xFCCB,  0x94A5 },
	{ 0xFCCC,  0xAECD },
	{ 0xFCCD,  0x94DE },
	{ 0xFCCE,  0xAECF },
	{ 0xFCCF,  0x8234C734 },
	{ 0xFCD0,  0x94EE },
	{ 0xFCD1,  0x8232BC32 },
	{ 0xFCD2,  0xAED3 },
	{ 0xFCD3,  0xCEDE },
	{ 0xFCD4,  0x94FB },
	{ 0xFCD5,  0x8FEC },
	{ 0xFCD6,  0xAED7 },
	{ 0xFCD7,  0x9558 },
	{ 0xFCD8,  0xAED9 },
	{ 0xFCD9,  0xAEDA },
	{ 0xFCDA,  0x9573 },
	{ 0xFCDB,  0xAEDC },
	{ 0xFCDC,  0xAEDD },
	{ 0xFCDD,  0xBDFA },
	{ 0xFCDE,  0xAEDF },
	{ 0xFCDF,  0x9589 },
	{ 0xFCE0,  0xAEE1 },
	{ 0xFCE1,  0x9591 },
	{ 0xFCE3,  0xAEE4 },
	{ 0xFCE4,  0xAEE5 },
	{ 0xFCE5,  0xAEE6 },
	{ 0xFCE6,  0xAEE7 },
	{ 0xFCE7,  0xAEE8 },
	{ 0xFCE8,  0xB287 },
	{ 0xFCE9,  0xAEEA },
	{ 0xFCEA,  0xF14C },
	{ 0xFCEB,  0x95FD },
	{ 0xFCEC,  0xAEED },
	{ 0xFCED,  0xAEEE },
	{ 0xFCEE,  0x8231A933 },
	{ 0xFCEF,  0x98B1 },
	{ 0xFCF0,  0xAEF1 },
	{ 0xFCF2,  0x9678 },
	{ 0xFCF3,  0x9674 },
	{ 0xFCF4,  0xAEF5 },
	{ 0xFCF5,  0xAEF6 },
	{ 0xFCF6,  0x96B7 },
	{ 0xFCF7,  0x8233A537 },
	{ 0xFCF8,  0x96E0 },
	{ 0xFCF9,  0x9C94 },
	{ 0xFCFA,  0xE297 },
	{ 0xFCFB,  0x96CE },
	{ 0xFCFC,  0xAEFD },
	{ 0xFCFD,  0xAEFE },
	{ 0xFCFE,  0x9741 },
	{ 0xFD40,  0xAFA2 },
	{ 0xFD41,  0x989A },
	{ 0xFD42,  0x98BF },
	{ 0xFD43,  0xAFA5 },
	{ 0xFD44,  0x984D },
	{ 0xFD45,  0x9788 },
	{ 0xFD46,  0xAFA8 },
	{ 0xFD47,  0xE9A4 },
	{ 0xFD48,  0x97B5 },
	{ 0xFD49,  0x8231DC39 },
	{ 0xFD4A,  0x82318B36 },
	{ 0xFD4B,  0xAFAD },
	{ 0xFD4C,  0x8231B137 },
	{ 0xFD4D,  0x969D },
	{ 0xFD4E,  0x9840 },
	{ 0xFD4F,  0xAFB1 },
	{ 0xFD50,  0x8232F239 },
	{ 0xFD51,  0x97DE },
	{ 0xFD52,  0xE9B0 },
	{ 0xFD53,  0x8231B530 },
	{ 0xFD54,  0xAFB6 },
	{ 0xFD55,  0xC8D9 },
	{ 0xFD56,  0x82DB },
	{ 0xFD57,  0x98B0 },
	{ 0xFD58,  0xAFBA },
	{ 0xFD59,  0xAFBB },
	{ 0xFD5A,  0x98ED },
	{ 0xFD5B,  0xAFBD },
	{ 0xFD5C,  0x9976 },
	{ 0xFD5D,  0x8231BD32 },
	{ 0xFD5E,  0x969F },
	{ 0xFD5F,  0x999E },
	{ 0xFD60,  0xAFC2 },
	{ 0xFD61,  0x8231BF38 },
	{ 0xFD62,  0x99F3 },
	{ 0xFD63,  0xAFC5 },
	{ 0xFD64,  0x90B9 },
	{ 0xFD65,  0x9A45 },
	{ 0xFD66,  0x9A73 },
	{ 0xFD67,  0xAFC9 },
	{ 0xFD68,  0x9CDE },
	{ 0xFD69,  0xAFCB },
	{ 0xFD6A,  0xAFCC },
	{ 0xFD6B,  0xAFCD },
	{ 0xFD6C,  0x8230C336 },
	{ 0xFD6D,  0xDFC1 },
	{ 0xFD6E,  0xAFD0 },
	{ 0xFD6F,  0xD5B1 },
	{ 0xFD70,  0xAFD2 },
	{ 0xFD71,  0x9AB5 },
	{ 0xFD72,  0x9AEA },
	{ 0xFD73,  0xAFD5 },
	{ 0xFD74,  0xAFD6 },
	{ 0xFD75,  0xAFD7 },
	{ 0xFD76,  0x9B41 },
	{ 0xFD77,  0xC576 },
	{ 0xFD78,  0xD0DA },
	{ 0xFD79,  0xAFDB },
	{ 0xFD7A,  0x8233A232 },
	{ 0xFD7B,  0xAFDD },
	{ 0xFD7C,  0xAFDE },
	{ 0xFD7D,  0xAFDF },
	{ 0xFD7E,  0xAFE0 },
	{ 0xFDA1,  0xAFE1 },
	{ 0xFDA2,  0x8230BA35 },
	{ 0xFDA3,  0x8231D538 },
	{ 0xFDA4,  0xAFE4 },
	{ 0xFDA5,  0xF547 },
	{ 0xFDA6,  0xAFE6 },
	{ 0xFDA7,  0xAFE7 },
	{ 0xFDA8,  0xC166 },
	{ 0xFDA9,  0xD1F9 },
	{ 0xFDAA,  0xAFEA },
	{ 0xFDAB,  0xAFEB },
	{ 0xFDAC,  0xAFEC },
	{ 0xFDAD,  0x9BE3 },
	{ 0xFDAE,  0xE4BA },
	{ 0xFDAF,  0x9CB8 },
	{ 0xFDB0,  0x9D51 },
	{ 0xFDB1,  0xAFF1 },
	{ 0xFDB2,  0xAFF2 },
	{ 0xFDB3,  0xAFF3 },
	{ 0xFDB4,  0xCA67 },
	{ 0xFDB5,  0xAFF5 },
	{ 0xFDB6,  0xDAA1 },
	{ 0xFDB9,  0xC868 },
	{ 0xFDBA,  0xAFFA },
	{ 0xFDBC,  0xAFFC },
	{ 0xFDBD,  0xAC85 },
	{ 0xFDBE,  0xAFFE },
	{ 0xFDBF,  0xB66B },
	{ 0xFDC0,  0x9C93 },
	{ 0xFDC1,  0x8B67 },
	{ 0xFDC2,  0xF8A4 },
	{ 0xFDC3,  0x9E50 },
	{ 0xFDC4,  0x8230BE35 },
	{ 0xFDC5,  0x9DC3 },
	{ 0xFDC6,  0xF8A8 },
	{ 0xFDC7,  0x9D48 },
	{ 0xFDC8,  0xF8AA },
	{ 0xFDC9,  0xF8AB },
	{ 0xFDCA,  0x8233B035 },
	{ 0xFDCB,  0xE761 },
	{ 0xFDCC,  0x9D81 },
	{ 0xFDCD,  0xC7B1 },
	{ 0xFDCE,  0x8231DF37 },
	{ 0xFDCF,  0xE4F3 },
	{ 0xFDD0,  0xF8B2 },
	{ 0xFDD1,  0x8231DD38 },
	{ 0xFDD2,  0x9DC5 },
	{ 0xFDD3,  0xF8B5 },
	{ 0xFDD4,  0x9DEF },
	{ 0xFDD5,  0xF8B7 },
	{ 0xFDD6,  0xF8B8 },
	{ 0xFDD7,  0xF8B9 },
	{ 0xFDD8,  0xF8BA },
	{ 0xFDD9,  0xF8BB },
	{ 0xFDDA,  0xF8BC },
	{ 0xFDDB,  0x8445 },
	{ 0xFDDC,  0xF8BE },
	{ 0xFDDD,  0xF8BF },
	{ 0xFDDE,  0xF8C0 },
	{ 0xFDDF,  0xF8C1 },
	{ 0xFDE0,  0x9E9E },
	{ 0xFDE1,  0xD4D6 },
	{ 0xFDE2,  0x9EE0 },
	{ 0xFDE3,  0x9EC5 },
	{ 0xFDE4,  0x9EF2 },
	{ 0xFDE5,  0x9EFB },
	{ 0xFDE6,  0x9EFC },
	{ 0xFDE7,  0xD1CC },
	{ 0xFDE8,  0x8232C036 },
	{ 0xFDE9,  0x8231EF31 },
	{ 0xFDEA,  0x9FE3 },
	{ 0xFDEB,  0x9FCC },
	{ 0xFDEC,  0xF8CE },
	{ 0xFDED,  0x9F78 },
	{ 0xFDEE,  0xECD1 },
	{ 0xFDEF,  0x8B5E },
	{ 0xFDF0,  0xECD3 },
	{ 0xFDF2,  0xE1B1 },
	{ 0xFDF3,  0xF8D5 },
	{ 0xFDF4,  0x9F95 },
	{ 0xFDF5,  0xE598 },
	{ 0xFDF6,  0xF8D8 },
	{ 0xFDF7,  0x9F79 },
	{ 0xFDF8,  0xF8DA },
	{ 0xFDF9,  0xF8DB },
	{ 0xFDFA,  0xF8DC },
	{ 0xFDFB,  0x9FE7 },
	{ 0xFDFC,  0xF8DE },
	{ 0xFDFD,  0xB3E3 },
	{ 0xFDFE,  0xA072 },
	{ 0xFE40,  0xE852 },
	{ 0xFE41,  0xA079 },
	{ 0xFE42,  0x89EA },
	{ 0xFE43,  0xE853 },
	{ 0xFE44,  0xA088 },
	{ 0xFE45,  0xE576 },
	{ 0xFE46,  0xF8E7 },
	{ 0xFE47,  0xA08F },
	{ 0xFE48,  0xA097 },
	{ 0xFE49,  0xF8EA },
	{ 0xFE4A,  0x9784 },
	{ 0xFE4B,  0xA0A7 },
	{ 0xFE4C,  0xA0A8 },
	{ 0xFE4D,  0x8231FA30 },
	{ 0xFE4E,  0xF8EF },
	{ 0xFE4F,  0x96D3 },
	{ 0xFE50,  0x9D7A },
	{ 0xFE51,  0xA0C0 },
	{ 0xFE53,  0xC3A8 },
	{ 0xFE54,  0xF8F5 },
	{ 0xFE55,  0xF8F6 },
	{ 0xFE56,  0x82348D39 },
	{ 0xFE57,  0xF8F8 },
	{ 0xFE58,  0xAA6A },
	{ 0xFE59,  0xCFD7 },
	{ 0xFE5A,  0xE7E5 },
	{ 0xFE5B,  0xAB6C },
	{ 0xFE5C,  0xF8FD },
	{ 0xFE5D,  0xF8FE },
	{ 0xFE5E,  0xE7EB },
	{ 0xFE5F,  0xAC7A },
	{ 0xFE60,  0xF9A3 },
	{ 0xFE61,  0xF9A4 },
	{ 0xFE62,  0xF9A5 },
	{ 0xFE63,  0x955F },
	{ 0xFE64,  0x8230B733 },
	{ 0xFE65,  0xF9A8 },
	{ 0xFE66,  0xF9A9 },
	{ 0xFE67,  0xF9AA },
	{ 0xFE68,  0xABA0 },
	{ 0xFE69,  0xAC56 },
	{ 0xFE6A,  0x97B7 },
	{ 0xFE6B,  0xF9AE },
	{ 0xFE6C,  0xAC6C },
	{ 0xFE6D,  0xF9B0 },
	{ 0xFE6E,  0x82328930 },
	{ 0xFE70,  0xF9B3 },
	{ 0xFE71,  0xAC8A },
	{ 0xFE72,  0xF9B5 },
	{ 0xFE73,  0xAC78 },
	{ 0xFE74,  0xAB92 },
	{ 0xFE75,  0xD1FE },
	{ 0xFE76,  0xD3A8 },
	{ 0xFE77,  0xAC96 },
	{ 0xFE78,  0x8230C230 },
	{ 0xFE79,  0xAC9C },
	{ 0xFE7A,  0xE762 },
	{ 0xFE7B,  0x98DA },
	{ 0xFE7C,  0xAD44 },
	{ 0xFE7D,  0x82349830 },
	{ 0xFE7E,  0xF9C1 },
	{ 0xFEA1,  0xF9C2 },
	{ 0xFEA2,  0xF9C3 },
	{ 0xFEA3,  0xF9C4 },
	{ 0xFEA4,  0x8BFD },
	{ 0xFEA5,  0xF9C6 },
	{ 0xFEA6,  0xF9C7 },
	{ 0xFEA7,  0xAD80 },
	{ 0xFEA8,  0xF9C9 },
	{ 0xFEA9,  0xAE55 },
	{ 0xFEAB,  0xAE5E },
	{ 0xFEAC,  0xF9CD },
	{ 0xFEAD,  0xF9CE },
	{ 0xFEAE,  0x8C84 },
	{ 0xFEAF,  0xF9D0 },
	{ 0xFEB0,  0xE659 },
	{ 0xFEB1,  0xAE76 },
	{ 0xFEB2,  0xAE75 },
	{ 0xFEB3,  0xAE88 },
	{ 0xFEB4,  0xAE8E },
	{ 0xFEB5,  0xF9D6 },
	{ 0xFEB6,  0x82328D35 },
	{ 0xFEB7,  0xF9D8 },
	{ 0xFEB8,  0xAF45 },
	{ 0xFEB9,  0xAC89 },
	{ 0xFEBA,  0xAF4C },
	{ 0xFEBB,  0xF0E2 },
	{ 0xFEBC,  0xAF7B },
	{ 0xFEBD,  0xAF93 },
	{ 0xFEBE,  0xB04A },
	{ 0xFEBF,  0xB048 },
	{ 0xFEC0,  0xF1B3 },
	{ 0xFEC1,  0xB068 },
	{ 0xFEC2,  0xF9E3 },
	{ 0xFEC3,  0xB077 },
	{ 0xFEC4,  0xC556 },
	{ 0xFEC5,  0x8230D630 },
	{ 0xFEC6,  0xF9E7 },
	{ 0xFEC7,  0xF9E8 },
	{ 0xFEC8,  0xB085 },
	{ 0xFEC9,  0xB088 },
	{ 0xFECA,  0xB096 },
	{ 0xFECB,  0xB144 },
	{ 0xFECC,  0xF9ED },
	{ 0xFECD,  0xC891 },
	{ 0xFECE,  0xF9EF },
	{ 0xFECF,  0xF9F0 },
	{ 0xFED0,  0xF9F1 },
	{ 0xFED1,  0xB177 },
	{ 0xFED2,  0xEDF6 },
	{ 0xFED3,  0xD7C5 },
	{ 0xFED4,  0x93E2 },
	{ 0xFED5,  0xF9F6 },
	{ 0xFED6,  0xB19E },
	{ 0xFED7,  0xF9F8 },
	{ 0xFED8,  0xB276 },
	{ 0xFED9,  0xF9FA },
	{ 0xFEDA,  0xF9FB },
	{ 0xFEDB,  0xF9FC },
	{ 0xFEDC,  0xB347 },
	{ 0xFEDE,  0xFAA1 },
	{ 0xFEDF,  0xFAA2 },
	{ 0xFEE0,  0x978E },
	{ 0xFEE1,  0xB45A },
	{ 0xFEE2,  0xB469 },
	{ 0xFEE3,  0xB471 },
	{ 0xFEE4,  0xEB51 },
	{ 0xFEE5,  0xB55E },
	{ 0xFEE6,  0xFAA9 },
	{ 0xFEE7,  0xB473 },
	{ 0xFEE8,  0xEDE7 },
	{ 0xFEE9,  0xBCEE },
	{ 0xFEEA,  0xFAAD },
	{ 0xFEEB,  0xDE77 },
	{ 0xFEEC,  0xB0C0 },
	{ 0xFEED,  0xFAB0 },
	{ 0xFEEE,  0xFAB1 },
	{ 0xFEEF,  0xFAB2 },
	{ 0xFEF0,  0xB596 },
	{ 0xFEF1,  0xD177 },
	{ 0xFEF2,  0x97B6 },
	{ 0xFEF3,  0xD9F7 },
	{ 0xFEF4,  0xFAB7 },
	{ 0xFEF5,  0xB649 },
	{ 0xFEF6,  0xFAB9 },
	{ 0xFEF7,  0xC0F1 },
	{ 0xFEF8,  0xB654 },
	{ 0xFEF9,  0x9C78 },
	{ 0xFEFA,  0xFABD },
	{ 0xFEFB,  0x82328433 },
	{ 0xFEFC,  0xB8D1 },
	{ 0xFEFD,  0xFAC0 },
	{ 0xFEFE,  0xB670 }
};
