/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright(c) 2001 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _HKSCS_BIG5P_H_

#define _HKSCS_BIG5P_H_

#define HKSCSMAX 15840

#include <public_struc.h>

table_t hkscs_big5p_tab[HKSCSMAX] = {
	{ 0x8943,  0xE88A },
	{ 0x8946,  0x8C9F },
	{ 0x8947,  0xBE88 },
	{ 0x8948,  0xE796 },
	{ 0x8949,  0xA586 },
	{ 0x894D,  0xD087 },
	{ 0x894E,  0x8491 },
	{ 0x894F,  0x848E },
	{ 0x8950,  0x914B },
	{ 0x8951,  0x8D8B },
	{ 0x8952,  0x915F },
	{ 0x8953,  0x9165 },
	{ 0x8954,  0x819C },
	{ 0x8955,  0x917B },
	{ 0x8956,  0x849E },
	{ 0x8957,  0x879F },
	{ 0x8958,  0x8E6B },
	{ 0x8959,  0x91B1 },
	{ 0x895A,  0x91B2 },
	{ 0x895B,  0x91ED },
	{ 0x895C,  0x8988 },
	{ 0x895D,  0x8386 },
	{ 0x895E,  0x924D },
	{ 0x895F,  0x8388 },
	{ 0x8960,  0x838A },
	{ 0x8961,  0xFA8F },
	{ 0x8962,  0x8F82 },
	{ 0x8963,  0x8F84 },
	{ 0x8964,  0x927B },
	{ 0x8965,  0x92BA },
	{ 0x8966,  0x92CD },
	{ 0x8967,  0x9093 },
	{ 0x8968,  0x97A0 },
	{ 0x8969,  0x83F9 },
	{ 0x896A,  0x93A6 },
	{ 0x896B,  0x93E4 },
	{ 0x896C,  0x9457 },
	{ 0x896D,  0x94AD },
	{ 0x896E,  0x956A },
	{ 0x896F,  0x9572 },
	{ 0x8970,  0x95A2 },
	{ 0x8971,  0x95AF },
	{ 0x8972,  0x95B7 },
	{ 0x8973,  0x95C7 },
	{ 0x8974,  0x95EE },
	{ 0x8975,  0xFA80 },
	{ 0x8976,  0xA045 },
	{ 0x8977,  0x96C9 },
	{ 0x8978,  0x96E3 },
	{ 0x8979,  0x976E },
	{ 0x897A,  0x97C0 },
	{ 0x897B,  0x97E4 },
	{ 0x897C,  0x98FB },
	{ 0x897D,  0x98FC },
	{ 0x897E,  0x9944 },
	{ 0x89A1,  0x9FAC },
	{ 0x89A2,  0x929A },
	{ 0x89A3,  0xCA81 },
	{ 0x89A4,  0xBD87 },
	{ 0x89A5,  0xEF94 },
	{ 0x89A6,  0x8797 },
	{ 0x89AB,  0xD591 },
	{ 0x89AC,  0xC986 },
	{ 0x89AD,  0x99AA },
	{ 0x89AE,  0x9674 },
	{ 0x89B0,  0xEA82 },
	{ 0x89B1,  0xA3A0 },
	{ 0x89B5,  0x8C8B },
	{ 0x89B6,  0xC8F5 },
	{ 0x89B8,  0x836C },
	{ 0x89B9,  0x83AE },
	{ 0x89BD,  0x83AA },
	{ 0x89C1,  0xBE83 },
	{ 0x89C2,  0x96BD },
	{ 0x89C3,  0x94AB },
	{ 0x89C6,  0x9C7E },
	{ 0x89C7,  0x9CC3 },
	{ 0x89C8,  0x8E67 },
	{ 0x89C9,  0xC98A },
	{ 0x89CE,  0x8781 },
	{ 0x89CF,  0xAF93 },
	{ 0x89D0,  0xAF92 },
	{ 0x89D1,  0x8184 },
	{ 0x89D2,  0x90F5 },
	{ 0x89D3,  0x90F9 },
	{ 0x89D4,  0x8787 },
	{ 0x89D6,  0xFB96 },
	{ 0x89D8,  0x9C88 },
	{ 0x89D9,  0xAF96 },
	{ 0x89DD,  0x819B },
	{ 0x89DE,  0x8590 },
	{ 0x89DF,  0xCD9D },
	{ 0x89E0,  0x916D },
	{ 0x89E1,  0x819D },
	{ 0x89E2,  0x8484 },
	{ 0x89E3,  0xBB80 },
	{ 0x89E4,  0xD785 },
	{ 0x89E5,  0x9495 },
	{ 0x89E7,  0xBB87 },
	{ 0x89E9,  0xC498 },
	{ 0x89EB,  0x8D9B },
	{ 0x89EC,  0x8884 },
	{ 0x89F0,  0x8D9F },
	{ 0x89F1,  0x94A0 },
	{ 0x89F2,  0x949E },
	{ 0x89F3,  0x949C },
	{ 0x89F4,  0x949D },
	{ 0x89F5,  0x9D8A },
	{ 0x89F6,  0x9D8F },
	{ 0x89F7,  0x91CE },
	{ 0x89F8,  0x90D2 },
	{ 0x89FA,  0xA68E },
	{ 0x89FD,  0xBB8A },
	{ 0x8A41,  0x91D0 },
	{ 0x8A46,  0xC862 },
	{ 0x8A4A,  0xE199 },
	{ 0x8A4F,  0xC981 },
	{ 0x8A56,  0x935B },
	{ 0x8A5B,  0xCF9F },
	{ 0x8A5C,  0x98F5 },
	{ 0x8A6A,  0x81F3 },
	{ 0x8A73,  0xEB89 },
	{ 0x8A74,  0xCD80 },
	{ 0x8A78,  0xD085 },
	{ 0x8A79,  0xFD87 },
	{ 0x8AA4,  0xE398 },
	{ 0x8AA7,  0xEA84 },
	{ 0x8AAF,  0xC588 },
	{ 0x8AB7,  0x91D9 },
	{ 0x8ABE,  0xDA99 },
	{ 0x8ABF,  0xC39E },
	{ 0x8AC1,  0xA896 },
	{ 0x8AC4,  0xAE98 },
	{ 0x8AC5,  0x91E9 },
	{ 0x8AC6,  0xC68F },
	{ 0x8AD6,  0xCE86 },
	{ 0x8ADB,  0x9F70 },
	{ 0x8AE7,  0xA397 },
	{ 0x8AFD,  0xBC94 },
	{ 0x8B50,  0xA0BF },
	{ 0x8B51,  0x9587 },
	{ 0x8B52,  0x9385 },
	{ 0x8B53,  0x91DB },
	{ 0x8B56,  0x8369 },
	{ 0x8B57,  0xD691 },
	{ 0x8B5A,  0x9466 },
	{ 0x8B5B,  0xC185 },
	{ 0x8B5C,  0x96A1 },
	{ 0x8B5D,  0x926D },
	{ 0x8B5F,  0xAD81 },
	{ 0x8B61,  0x829D },
	{ 0x8B63,  0x8350 },
	{ 0x8B6C,  0xE880 },
	{ 0x8B78,  0xA790 },
	{ 0x8B7D,  0x9592 },
	{ 0x8BAF,  0x9247 },
	{ 0x8BB0,  0xA5A0 },
	{ 0x8BB3,  0xD299 },
	{ 0x8BB4,  0xFB9F },
	{ 0x8BB7,  0xE79F },
	{ 0x8BB9,  0xF180 },
	{ 0x8BBA,  0x83E3 },
	{ 0x8BBD,  0xC499 },
	{ 0x8BBF,  0xDE89 },
	{ 0x8BC0,  0x8180 },
	{ 0x8BC1,  0xC6D8 },
	{ 0x8BC4,  0x9397 },
	{ 0x8BC6,  0x9E62 },
	{ 0x8BC7,  0x90F4 },
	{ 0x8BC9,  0xF69D },
	{ 0x8BCA,  0x8190 },
	{ 0x8BCB,  0xF691 },
	{ 0x8BCD,  0xF692 },
	{ 0x8BCE,  0x828D },
	{ 0x8BCF,  0x8399 },
	{ 0x8BD0,  0x9F6E },
	{ 0x8BD1,  0x9F6F },
	{ 0x8BD2,  0xF6A0 },
	{ 0x8BD3,  0xF780 },
	{ 0x8BD4,  0x90E3 },
	{ 0x8BD5,  0xF693 },
	{ 0x8BD7,  0xF797 },
	{ 0x8BD8,  0x9FCF },
	{ 0x8BD9,  0x9560 },
	{ 0x8BDA,  0x9FF6 },
	{ 0x8BDF,  0x90D0 },
	{ 0x8BE0,  0x9671 },
	{ 0x8BE3,  0x8283 },
	{ 0x8BE4,  0xA062 },
	{ 0x8BE5,  0x9769 },
	{ 0x8BE7,  0x97A2 },
	{ 0x8BE8,  0x987B },
	{ 0x8BE9,  0x99B9 },
	{ 0x8BEA,  0xF994 },
	{ 0x8BEB,  0x9B4F },
	{ 0x8BEC,  0x9B50 },
	{ 0x8BEE,  0x9BBD },
	{ 0x8BEF,  0x9BC4 },
	{ 0x8BF0,  0x9BF7 },
	{ 0x8BF1,  0x9C45 },
	{ 0x8BF2,  0x9C4B },
	{ 0x8BF4,  0x9CE0 },
	{ 0x8BF5,  0x9DAC },
	{ 0x8BF6,  0xAF90 },
	{ 0x8BF7,  0xB480 },
	{ 0x8BF9,  0x9E5E },
	{ 0x8BFB,  0x8191 },
	{ 0x8BFC,  0x828B },
	{ 0x8BFD,  0x99D6 },
	{ 0x8D60,  0xB197 },
	{ 0x8D61,  0xB198 },
	{ 0x8D62,  0xC86A },
	{ 0x8D65,  0xCF84 },
	{ 0x8D66,  0xDE94 },
	{ 0x8D69,  0xAF9A },
	{ 0x8D6A,  0xB284 },
	{ 0x8D6B,  0x8F9B },
	{ 0x8D6C,  0x8F9E },
	{ 0x8D71,  0xA88C },
	{ 0x8D72,  0xBC92 },
	{ 0x8D73,  0x9691 },
	{ 0x8D75,  0xD79E },
	{ 0x8D76,  0xD7A0 },
	{ 0x8D77,  0xD881 },
	{ 0x8D79,  0xC68B },
	{ 0x8D7A,  0xF986 },
	{ 0x8D7B,  0x9EEC },
	{ 0x8D7C,  0x9EED },
	{ 0x8D7E,  0x8348 },
	{ 0x8DA2,  0xB29B },
	{ 0x8DA3,  0x9349 },
	{ 0x8DA4,  0xBC9F },
	{ 0x8DA5,  0x8161 },
	{ 0x8DA7,  0xD88A },
	{ 0x8DA8,  0xA79D },
	{ 0x8DA9,  0x91E2 },
	{ 0x8DAA,  0x9E5C },
	{ 0x8DAC,  0x935F },
	{ 0x8DAE,  0x9096 },
	{ 0x8DAF,  0x9367 },
	{ 0x8DB1,  0xBD85 },
	{ 0x8DB3,  0xA98F },
	{ 0x8DB5,  0x8FBF },
	{ 0x8DB6,  0x9885 },
	{ 0x8DB8,  0xFD9E },
	{ 0x8DB9,  0xA99B },
	{ 0x8DBD,  0xB395 },
	{ 0x8DBE,  0xBD8B },
	{ 0x8DBF,  0x9FA4 },
	{ 0x8DC0,  0xBD94 },
	{ 0x8DC1,  0xC788 },
	{ 0x8DC2,  0xBD8E },
	{ 0x8DC4,  0xC786 },
	{ 0x8DC6,  0x81C3 },
	{ 0x8DC7,  0x9F60 },
	{ 0x8DC8,  0xD8A0 },
	{ 0x8DC9,  0xDF89 },
	{ 0x8DCB,  0xDF88 },
	{ 0x8DCD,  0xE39C },
	{ 0x8DCE,  0xE3A0 },
	{ 0x8DCF,  0xE88F },
	{ 0x8DD0,  0x834A },
	{ 0x8DD1,  0x9188 },
	{ 0x8DD2,  0xBD9C },
	{ 0x8DD3,  0xA182 },
	{ 0x8DD4,  0x8B8E },
	{ 0x8DD5,  0x8B93 },
	{ 0x8DD7,  0x9894 },
	{ 0x8DD8,  0x988F },
	{ 0x8DD9,  0x9896 },
	{ 0x8DDA,  0xA18F },
	{ 0x8DDC,  0x93F2 },
	{ 0x8DDD,  0xAA92 },
	{ 0x8DDE,  0x8EC7 },
	{ 0x8DDF,  0xB488 },
	{ 0x8DE0,  0xB496 },
	{ 0x8DE1,  0xC877 },
	{ 0x8DE3,  0xBE82 },
	{ 0x8DE4,  0x9445 },
	{ 0x8DE5,  0xBE89 },
	{ 0x8DE6,  0x9E4C },
	{ 0x8DE7,  0xBE87 },
	{ 0x8DE8,  0xBE8E },
	{ 0x8DE9,  0x816D },
	{ 0x8DEA,  0xC796 },
	{ 0x8DED,  0xD18F },
	{ 0x8DEE,  0xD989 },
	{ 0x8DF1,  0xD98F },
	{ 0x8DF2,  0x927A },
	{ 0x8DF4,  0xE897 },
	{ 0x8DF6,  0x9F7A },
	{ 0x8DF7,  0xF196 },
	{ 0x8DF8,  0x8693 },
	{ 0x8DF9,  0x8E7D },
	{ 0x8DFA,  0x919A },
	{ 0x8E41,  0x9D97 },
	{ 0x8E43,  0x9F7D },
	{ 0x8E46,  0xC789 },
	{ 0x8E48,  0xBB9E },
	{ 0x8E49,  0xE08F },
	{ 0x8E4C,  0x82E8 },
	{ 0x8E4D,  0x9A8A },
	{ 0x8E4F,  0xDA8D },
	{ 0x8E50,  0xD294 },
	{ 0x8E51,  0xE090 },
	{ 0x8E52,  0x9FD7 },
	{ 0x8E53,  0xD991 },
	{ 0x8E56,  0xA388 },
	{ 0x8E57,  0xA389 },
	{ 0x8E58,  0xC089 },
	{ 0x8E5A,  0x9582 },
	{ 0x8E5C,  0xA38D },
	{ 0x8E5D,  0xB699 },
	{ 0x8E5E,  0xC840 },
	{ 0x8E61,  0x817D },
	{ 0x8E62,  0xC08E },
	{ 0x8E63,  0xAD8F },
	{ 0x8E66,  0x9057 },
	{ 0x8E67,  0x906D },
	{ 0x8E68,  0xC995 },
	{ 0x8E6D,  0xCA92 },
	{ 0x8E6E,  0xE093 },
	{ 0x8E70,  0xE989 },
	{ 0x8E72,  0xEC92 },
	{ 0x8E73,  0xA392 },
	{ 0x8E75,  0xB780 },
	{ 0x8E76,  0xB387 },
	{ 0x8E78,  0xD29F },
	{ 0x8E79,  0xD2A0 },
	{ 0x8E7A,  0xE587 },
	{ 0x8E7B,  0x9298 },
	{ 0x8E7C,  0xF585 },
	{ 0x8E7D,  0xF29E },
	{ 0x8EA1,  0x9FF3 },
	{ 0x8EA4,  0xB78A },
	{ 0x8EA6,  0x9040 },
	{ 0x8EA7,  0xC09A },
	{ 0x8EA8,  0xC9A0 },
	{ 0x8EA9,  0xB49B },
	{ 0x8EAA,  0xCA80 },
	{ 0x8EAE,  0xD387 },
	{ 0x8EB0,  0xD38C },
	{ 0x8EB2,  0xD38F },
	{ 0x8EB7,  0xE98C },
	{ 0x8EB8,  0xF19C },
	{ 0x8EBA,  0xF481 },
	{ 0x8EBB,  0xDA94 },
	{ 0x8EBC,  0x9063 },
	{ 0x8EBD,  0xCA84 },
	{ 0x8EBE,  0xE58D },
	{ 0x8EBF,  0x8F5D },
	{ 0x8EC1,  0xDD88 },
	{ 0x8EC2,  0xA399 },
	{ 0x8EC4,  0xC09C },
	{ 0x8ECB,  0xE58F },
	{ 0x8ECE,  0xAC97 },
	{ 0x8ECF,  0xAC99 },
	{ 0x8ED1,  0xEC96 },
	{ 0x8ED4,  0xA39F },
	{ 0x8ED5,  0xA39E },
	{ 0x8ED6,  0xCA89 },
	{ 0x8EDC,  0x9068 },
	{ 0x8EDD,  0x9380 },
	{ 0x8EDF,  0xA484 },
	{ 0x8EE0,  0xAD80 },
	{ 0x8EE1,  0xCE94 },
	{ 0x8EE3,  0x8B88 },
	{ 0x8EE6,  0xE399 },
	{ 0x8EE8,  0xDA9A },
	{ 0x8EEA,  0xD982 },
	{ 0x8EEE,  0xA488 },
	{ 0x8EF2,  0x9C83 },
	{ 0x8EF4,  0x906F },
	{ 0x8EF5,  0x906B },
	{ 0x8EFB,  0x9388 },
	{ 0x8EFC,  0x8ED8 },
	{ 0x8F40,  0xDB81 },
	{ 0x8F41,  0x9B86 },
	{ 0x8F42,  0xFE91 },
	{ 0x8F48,  0x869D },
	{ 0x8F49,  0x9B88 },
	{ 0x8F4A,  0xA48C },
	{ 0x8F51,  0xAD83 },
	{ 0x8F52,  0x91DF },
	{ 0x8F53,  0xAD8E },
	{ 0x8F56,  0xC849 },
	{ 0x8F58,  0xB885 },
	{ 0x8F5B,  0xD89C },
	{ 0x8F5C,  0xDB80 },
	{ 0x8F60,  0xC19B },
	{ 0x8F62,  0xC198 },
	{ 0x8F65,  0xDF87 },
	{ 0x8F66,  0xC199 },
	{ 0x8F68,  0xA29E },
	{ 0x8F6D,  0x9070 },
	{ 0x8F6F,  0xAD8A },
	{ 0x8F71,  0xCA9F },
	{ 0x8F72,  0xCA99 },
	{ 0x8F77,  0xD483 },
	{ 0x8F78,  0x9264 },
	{ 0x8F7B,  0x9072 },
	{ 0x8F7D,  0x979E },
	{ 0x8F7E,  0xEFA0 },
	{ 0x8FA3,  0xE596 },
	{ 0x8FA5,  0xEC9C },
	{ 0x8FAA,  0xEF9F },
	{ 0x8FAD,  0x8382 },
	{ 0x8FAF,  0x8EBA },
	{ 0x8FB0,  0xD488 },
	{ 0x8FB2,  0xE598 },
	{ 0x8FB4,  0xE18B },
	{ 0x8FB5,  0xE59C },
	{ 0x8FB6,  0xE99B },
	{ 0x8FB7,  0xD78B },
	{ 0x8FB8,  0x8C92 },
	{ 0x8FB9,  0xA091 },
	{ 0x8FBB,  0xAD96 },
	{ 0x8FBC,  0xB891 },
	{ 0x8FC0,  0xDB88 },
	{ 0x8FC1,  0xAD97 },
	{ 0x8FC3,  0xB894 },
	{ 0x8FC4,  0xB895 },
	{ 0x8FC5,  0xB2A0 },
	{ 0x8FC6,  0xA067 },
	{ 0x8FC7,  0xC89D },
	{ 0x8FC9,  0xE99D },
	{ 0x8FCA,  0xF499 },
	{ 0x8FCD,  0xDB8B },
	{ 0x8FCE,  0xF083 },
	{ 0x8FD0,  0xC282 },
	{ 0x8FD3,  0xCB91 },
	{ 0x8FD4,  0x94D6 },
	{ 0x8FD5,  0xB9A0 },
	{ 0x8FD6,  0xCB93 },
	{ 0x8FD8,  0xC088 },
	{ 0x8FDD,  0xC885 },
	{ 0x8FDE,  0xE194 },
	{ 0x8FDF,  0xE192 },
	{ 0x8FE2,  0xE9A0 },
	{ 0x8FE3,  0xEA81 },
	{ 0x8FE4,  0xED8C },
	{ 0x8FE5,  0xCB94 },
	{ 0x8FE7,  0xF383 },
	{ 0x8FE8,  0xF586 },
	{ 0x8FE9,  0xD499 },
	{ 0x8FEC,  0xA496 },
	{ 0x8FED,  0xF49B },
	{ 0x8FF3,  0xCB9A },
	{ 0x8FF6,  0xF087 },
	{ 0x8FF7,  0xE689 },
	{ 0x8FF9,  0xD49E },
	{ 0x8FFA,  0x8FE2 },
	{ 0x8FFB,  0xF086 },
	{ 0x9040,  0xE68A },
	{ 0x9047,  0xB697 },
	{ 0x9048,  0xAE9A },
	{ 0x9049,  0xD585 },
	{ 0x904A,  0xEA88 },
	{ 0x904B,  0xD597 },
	{ 0x904C,  0xD58B },
	{ 0x904D,  0xDB9A },
	{ 0x9050,  0xDB9D },
	{ 0x9051,  0xDC8B },
	{ 0x9054,  0xD58D },
	{ 0x9059,  0x8F97 },
	{ 0x905B,  0xA580 },
	{ 0x9062,  0xB99D },
	{ 0x9065,  0xCC86 },
	{ 0x9068,  0x8C98 },
	{ 0x906A,  0x9BA0 },
	{ 0x906C,  0xFB92 },
	{ 0x906E,  0xC2A0 },
	{ 0x9070,  0xE693 },
	{ 0x9071,  0xF588 },
	{ 0x9072,  0x8EDF },
	{ 0x9075,  0xBA86 },
	{ 0x9076,  0x8B8D },
	{ 0x9077,  0xC38F },
	{ 0x9078,  0xC389 },
	{ 0x90A2,  0xDC89 },
	{ 0x90A3,  0xE28B },
	{ 0x90A6,  0x9198 },
	{ 0x90A7,  0xBB9C },
	{ 0x90AB,  0xC38E },
	{ 0x90AF,  0xE284 },
	{ 0x90B0,  0xF389 },
	{ 0x90B1,  0x90A9 },
	{ 0x90B2,  0xA58A },
	{ 0x90B3,  0x81B3 },
	{ 0x90B4,  0x99B8 },
	{ 0x90B5,  0x8EEB },
	{ 0x90B6,  0xDF98 },
	{ 0x90BD,  0x918B },
	{ 0x90BE,  0xBA8A },
	{ 0x90BF,  0xC393 },
	{ 0x90C1,  0xD681 },
	{ 0x90C3,  0xDE9A },
	{ 0x90C4,  0xC6D7 },
	{ 0x90C5,  0x9FCC },
	{ 0x90C7,  0xA58E },
	{ 0x90C8,  0x8286 },
	{ 0x90D2,  0xED9F },
	{ 0x90D3,  0xF496 },
	{ 0x90D4,  0xF08E },
	{ 0x90D9,  0x8B98 },
	{ 0x90DA,  0x8349 },
	{ 0x90DB,  0xE291 },
	{ 0x90DE,  0x81B5 },
	{ 0x90DF,  0xF18C },
	{ 0x90E1,  0xBA91 },
	{ 0x90E2,  0x8F58 },
	{ 0x90E3,  0xC48A },
	{ 0x90E6,  0xD685 },
	{ 0x90E7,  0xE293 },
	{ 0x90E8,  0xEA98 },
	{ 0x90E9,  0xF090 },
	{ 0x90EA,  0xF288 },
	{ 0x90EB,  0xDC97 },
	{ 0x90EC,  0x8352 },
	{ 0x90EE,  0xC398 },
	{ 0x90EF,  0xB598 },
	{ 0x90F2,  0xC399 },
	{ 0x90F6,  0xDA88 },
	{ 0x90F7,  0xDC9A },
	{ 0x90F8,  0xE782 },
	{ 0x90F9,  0xF094 },
	{ 0x9141,  0xF096 },
	{ 0x9142,  0xE296 },
	{ 0x9143,  0xF095 },
	{ 0x9144,  0xF097 },
	{ 0x9148,  0x8ED3 },
	{ 0x9149,  0xAF8E },
	{ 0x914A,  0xAF8F },
	{ 0x914B,  0xC39F },
	{ 0x914C,  0xE19E },
	{ 0x914D,  0xE789 },
	{ 0x9152,  0xE29A },
	{ 0x9153,  0xE78C },
	{ 0x9154,  0xF09C },
	{ 0x9155,  0xE78D },
	{ 0x9156,  0xF393 },
	{ 0x915B,  0xBA96 },
	{ 0x915C,  0xC481 },
	{ 0x915E,  0xD693 },
	{ 0x9160,  0xF09E },
	{ 0x9161,  0x83AD },
	{ 0x9163,  0xFCA0 },
	{ 0x9164,  0xE29E },
	{ 0x9168,  0xEE8A },
	{ 0x9169,  0xCD94 },
	{ 0x916B,  0xA785 },
	{ 0x916D,  0xDD93 },
	{ 0x916F,  0xEE90 },
	{ 0x9170,  0xEE96 },
	{ 0x9171,  0xEE98 },
	{ 0x9173,  0xC8FD },
	{ 0x917A,  0xEB8D },
	{ 0x917B,  0xEB8B },
	{ 0x917D,  0xF4A0 },
	{ 0x917E,  0xA3FD },
	{ 0x91A1,  0xF184 },
	{ 0x91A7,  0xE384 },
	{ 0x91AA,  0xE79A },
	{ 0x91AB,  0xEB8F },
	{ 0x91AC,  0xF186 },
	{ 0x91AD,  0xF59D },
	{ 0x91AF,  0xD6A0 },
	{ 0x91B0,  0xE387 },
	{ 0x91B2,  0xEE9C },
	{ 0x91B6,  0x8788 },
	{ 0x91B9,  0xE79E },
	{ 0x91BA,  0xF580 },
	{ 0x91BC,  0x90BE },
	{ 0x91BE,  0xEB93 },
	{ 0x91C0,  0xF399 },
	{ 0x91C1,  0xE38A },
	{ 0x91C2,  0xDE87 },
	{ 0x91C3,  0xF48E },
	{ 0x91C4,  0xCD8A },
	{ 0x91C6,  0xEA9A },
	{ 0x91C7,  0xC189 },
	{ 0x91C8,  0xA0FC },
	{ 0x91C9,  0xF188 },
	{ 0x91CA,  0xA38B },
	{ 0x91CB,  0xE389 },
	{ 0x91CC,  0xEC84 },
	{ 0x91D0,  0x8FED },
	{ 0x91D4,  0x9287 },
	{ 0x91D7,  0xD28C },
	{ 0x91DA,  0xE1A0 },
	{ 0x91DB,  0xED95 },
	{ 0x91DD,  0x81EB },
	{ 0x91DE,  0x82B1 },
	{ 0x91DF,  0xEA8B },
	{ 0x91E2,  0xEC87 },
	{ 0x91E4,  0x8178 },
	{ 0x91E5,  0x9FD4 },
	{ 0x91E6,  0xA197 },
	{ 0x91E9,  0xC884 },
	{ 0x91EB,  0x989A },
	{ 0x91FB,  0x8E77 },
	{ 0x9242,  0xD481 },
	{ 0x9245,  0xC19A },
	{ 0x9250,  0x9182 },
	{ 0x9254,  0xBB8D },
	{ 0x9256,  0x8FC1 },
	{ 0x925D,  0x8F6B },
	{ 0x925E,  0xE38C },
	{ 0x9260,  0x8F72 },
	{ 0x9264,  0xEA8D },
	{ 0x9266,  0xE69B },
	{ 0x9267,  0x8488 },
	{ 0x9268,  0xD782 },
	{ 0x926B,  0x8189 },
	{ 0x926E,  0x878B },
	{ 0x926F,  0x8D81 },
	{ 0x9271,  0xA787 },
	{ 0x9278,  0x8E6A },
	{ 0x927C,  0xA072 },
	{ 0x927E,  0x8485 },
	{ 0x92A1,  0xBA9E },
	{ 0x92A2,  0xCD99 },
	{ 0x92A3,  0x8D85 },
	{ 0x92A4,  0x848A },
	{ 0x92A7,  0x8789 },
	{ 0x92A8,  0x9C8F },
	{ 0x92A9,  0xA59B },
	{ 0x92AA,  0xAF98 },
	{ 0x92AB,  0x9486 },
	{ 0x92AC,  0x9487 },
	{ 0x92AD,  0xA599 },
	{ 0x92AE,  0xCD98 },
	{ 0x92B3,  0xB497 },
	{ 0x92B7,  0xA191 },
	{ 0x92BA,  0xA59D },
	{ 0x92BB,  0x948E },
	{ 0x92C1,  0xAE96 },
	{ 0x92C4,  0x9C9D },
	{ 0x92C5,  0xF880 },
	{ 0x92C7,  0xBB81 },
	{ 0x92CA,  0xC883 },
	{ 0x92CF,  0xC787 },
	{ 0x92D3,  0x824B },
	{ 0x92D4,  0xB595 },
	{ 0x92D5,  0xBF84 },
	{ 0x92D6,  0x8C80 },
	{ 0x92DA,  0x8380 },
	{ 0x92DC,  0xEC86 },
	{ 0x92DE,  0xB085 },
	{ 0x92E0,  0x9586 },
	{ 0x92E2,  0xF18B },
	{ 0x92E3,  0xC380 },
	{ 0x92E4,  0xC394 },
	{ 0x92E5,  0xE19D },
	{ 0x92E6,  0xA692 },
	{ 0x92E7,  0x958C },
	{ 0x92E8,  0x8E93 },
	{ 0x92EA,  0x9249 },
	{ 0x92EB,  0xB182 },
	{ 0x92F0,  0xA78E },
	{ 0x92F1,  0x8E9D },
	{ 0x92F2,  0xC386 },
	{ 0x92F3,  0xB191 },
	{ 0x92F4,  0xB188 },
	{ 0x92F5,  0x9E89 },
	{ 0x92FB,  0x988D },
	{ 0x92FC,  0xBF87 },
	{ 0x92FD,  0x9DA0 },
	{ 0x9340,  0xB184 },
	{ 0x9343,  0xEA93 },
	{ 0x9344,  0xD19F },
	{ 0x9346,  0xC7F5 },
	{ 0x9348,  0xED93 },
	{ 0x934A,  0x90B8 },
	{ 0x934C,  0xB193 },
	{ 0x934D,  0x8F8D },
	{ 0x934E,  0xCF8A },
	{ 0x934F,  0xB282 },
	{ 0x9353,  0x8FAD },
	{ 0x9354,  0xF39C },
	{ 0x935C,  0xAC9E },
	{ 0x9361,  0x828A },
	{ 0x9362,  0x859D },
	{ 0x9365,  0xA784 },
	{ 0x9367,  0xEB97 },
	{ 0x9368,  0x9744 },
	{ 0x936A,  0x825E },
	{ 0x936B,  0x9F85 },
	{ 0x936E,  0x85A0 },
	{ 0x9374,  0xD882 },
	{ 0x9378,  0xD883 },
	{ 0x9379,  0xCF99 },
	{ 0x937A,  0x9F89 },
	{ 0x93A1,  0xC692 },
	{ 0x93A9,  0x9F9B },
	{ 0x93AB,  0x8FB9 },
	{ 0x93AC,  0x9F99 },
	{ 0x93AD,  0xB382 },
	{ 0x93B0,  0x8E7A },
	{ 0x93B2,  0xC695 },
	{ 0x93B3,  0xBCA0 },
	{ 0x93B4,  0xC8CF },
	{ 0x93BA,  0x9D87 },
	{ 0x93BE,  0xDF83 },
	{ 0x93C9,  0x904D },
	{ 0x93D1,  0xBD86 },
	{ 0x93D3,  0xB388 },
	{ 0x93D5,  0x9793 },
	{ 0x93D8,  0xA98B },
	{ 0x93DB,  0x9795 },
	{ 0x93E3,  0xEC8B },
	{ 0x93E5,  0x9181 },
	{ 0x93E7,  0xA991 },
	{ 0x93E8,  0xA094 },
	{ 0x93EA,  0xE480 },
	{ 0x93EE,  0xD89A },
	{ 0x93EF,  0xD898 },
	{ 0x93F0,  0x9F63 },
	{ 0x93F1,  0x9F66 },
	{ 0x93F3,  0xEF84 },
	{ 0x93F4,  0xA992 },
	{ 0x93F5,  0xD89D },
	{ 0x93F7,  0x8FC9 },
	{ 0x93F8,  0xD987 },
	{ 0x93FB,  0xE694 },
	{ 0x93FC,  0x8EFC },
	{ 0x9440,  0xCC8C },
	{ 0x9443,  0x90BF },
	{ 0x9444,  0x8FD4 },
	{ 0x9445,  0xD18D },
	{ 0x944A,  0xAA89 },
	{ 0x944C,  0xA788 },
	{ 0x944D,  0xAA8E },
	{ 0x944E,  0x8F7B },
	{ 0x944F,  0x9898 },
	{ 0x9450,  0xAB9A },
	{ 0x9451,  0x8FEB },
	{ 0x9454,  0xAA9E },
	{ 0x9455,  0xBE9B },
	{ 0x9456,  0xB588 },
	{ 0x9457,  0xC888 },
	{ 0x945A,  0x9B8B },
	{ 0x945D,  0xD19E },
	{ 0x9468,  0x9F91 },
	{ 0x946A,  0xEC8C },
	{ 0x946B,  0xB596 },
	{ 0x946C,  0x8F4C },
	{ 0x946D,  0x94A7 },
	{ 0x9471,  0xE082 },
	{ 0x9476,  0xA289 },
	{ 0x9477,  0x9042 },
	{ 0x947A,  0xC892 },
	{ 0x94A6,  0x99B2 },
	{ 0x94A7,  0x858E },
	{ 0x94A8,  0x90B4 },
	{ 0x94AB,  0x8159 },
	{ 0x94AE,  0xC8A0 },
	{ 0x94B0,  0xA297 },
	{ 0x94B1,  0xA294 },
	{ 0x94B2,  0xC983 },
	{ 0x94B7,  0xB593 },
	{ 0x94B8,  0xD996 },
	{ 0x94BF,  0xDC86 },
	{ 0x94C1,  0x90D1 },
	{ 0x94C2,  0xBF9F },
	{ 0x94C3,  0xBFA0 },
	{ 0x94C4,  0xD289 },
	{ 0x94C5,  0x9990 },
	{ 0x94C6,  0xA29F },
	{ 0x94CB,  0xCA94 },
	{ 0x94CC,  0xDA86 },
	{ 0x94CD,  0x8FC7 },
	{ 0x94CF,  0xD291 },
	{ 0x94D0,  0x9FD1 },
	{ 0x94D4,  0xC382 },
	{ 0x94D5,  0xAB9F },
	{ 0x94DC,  0x8F6E },
	{ 0x94E1,  0xB698 },
	{ 0x94E2,  0xA78F },
	{ 0x94E6,  0x959E },
	{ 0x94E8,  0xE08C },
	{ 0x94E9,  0x9E80 },
	{ 0x94EB,  0x9A92 },
	{ 0x94ED,  0xF19A },
	{ 0x94EE,  0xF495 },
	{ 0x94F3,  0xD29B },
	{ 0x94F6,  0xA38F },
	{ 0x94F7,  0x9A95 },
	{ 0x94F8,  0xC090 },
	{ 0x94F9,  0xE39E },
	{ 0x94FA,  0xD383 },
	{ 0x94FB,  0x9060 },
	{ 0x94FC,  0x9061 },
	{ 0x94FD,  0xF19D },
	{ 0x9542,  0xC099 },
	{ 0x9547,  0x979A },
	{ 0x954A,  0x9D9B },
	{ 0x954E,  0xC09D },
	{ 0x954F,  0xC841 },
	{ 0x9553,  0xFE89 },
	{ 0x9555,  0xDD89 },
	{ 0x9556,  0x9076 },
	{ 0x9557,  0xF58B },
	{ 0x9558,  0xD091 },
	{ 0x955D,  0xEA9E },
	{ 0x955F,  0xC195 },
	{ 0x9563,  0x96AC },
	{ 0x9565,  0x9A9E },
	{ 0x9566,  0x9A9B },
	{ 0x9567,  0xB795 },
	{ 0x9569,  0xEE82 },
	{ 0x956B,  0xE991 },
	{ 0x956C,  0xE992 },
	{ 0x956E,  0xC191 },
	{ 0x9570,  0xEC9B },
	{ 0x9572,  0xB18C },
	{ 0x9575,  0xDE8C },
	{ 0x9577,  0xC593 },
	{ 0x9579,  0xA495 },
	{ 0x957C,  0xF2A0 },
	{ 0x957E,  0x9680 },
	{ 0x95A1,  0xA499 },
	{ 0x95A2,  0x8784 },
	{ 0x95A3,  0x907E },
	{ 0x95A4,  0xB893 },
	{ 0x95A5,  0xD48A },
	{ 0x95A6,  0xED85 },
	{ 0x95A7,  0xE5A0 },
	{ 0x95A9,  0x90A1 },
	{ 0x95B1,  0xCA98 },
	{ 0x95B5,  0xB89F },
	{ 0x95B6,  0xAE86 },
	{ 0x95B8,  0xE393 },
	{ 0x95B9,  0x90AE },
	{ 0x95BB,  0xC8CD },
	{ 0x95BC,  0x8EDD },
	{ 0x95BD,  0xA194 },
	{ 0x95BF,  0xEB8E },
	{ 0x95C0,  0x9B95 },
	{ 0x95C1,  0xD49D },
	{ 0x95C3,  0x8993 },
	{ 0x95C4,  0x82E6 },
	{ 0x95C5,  0x959C },
	{ 0x95C8,  0xD582 },
	{ 0x95C9,  0xF587 },
	{ 0x95CB,  0xDB99 },
	{ 0x95CC,  0xE68E },
	{ 0x95CE,  0x868D },
	{ 0x95CF,  0xD988 },
	{ 0x95D2,  0xD18E },
	{ 0x95D3,  0x8FD8 },
	{ 0x95D5,  0xEB85 },
	{ 0x95D8,  0x997E },
	{ 0x95DA,  0x8F6D },
	{ 0x95DC,  0xF089 },
	{ 0x95DD,  0xED91 },
	{ 0x95E1,  0xED9A },
	{ 0x95E4,  0x96FA },
	{ 0x95E5,  0xAE87 },
	{ 0x95E6,  0xC391 },
	{ 0x95E7,  0xCC97 },
	{ 0x95E8,  0x90C1 },
	{ 0x95E9,  0x8EE1 },
	{ 0x95EB,  0xBF8B },
	{ 0x95F2,  0xC392 },
	{ 0x95FA,  0x8FFC },
	{ 0x95FB,  0xC891 },
	{ 0x95FD,  0xF38D },
	{ 0x9640,  0xA092 },
	{ 0x9645,  0xE289 },
	{ 0x964A,  0x81EC },
	{ 0x964B,  0xD793 },
	{ 0x964C,  0xED87 },
	{ 0x964E,  0xA282 },
	{ 0x9650,  0xE292 },
	{ 0x9651,  0xA0C7 },
	{ 0x9652,  0xE785 },
	{ 0x9654,  0xE392 },
	{ 0x9657,  0xD68A },
	{ 0x9659,  0xCC8D },
	{ 0x965B,  0xAF88 },
	{ 0x9660,  0xF098 },
	{ 0x9663,  0x99B3 },
	{ 0x9665,  0xB884 },
	{ 0x9666,  0xE788 },
	{ 0x9667,  0xEE83 },
	{ 0x966A,  0x83D8 },
	{ 0x966C,  0xF391 },
	{ 0x966D,  0xF392 },
	{ 0x9670,  0xDF8E },
	{ 0x9671,  0xEAA0 },
	{ 0x9672,  0xCE99 },
	{ 0x9673,  0xEE84 },
	{ 0x9677,  0xCD86 },
	{ 0x967A,  0xE281 },
	{ 0x967B,  0xC58D },
	{ 0x967D,  0xB098 },
	{ 0x96A2,  0xC7FE },
	{ 0x96A5,  0xB39D },
	{ 0x96A7,  0x837D },
	{ 0x96A9,  0x8FB3 },
	{ 0x96AC,  0xB28C },
	{ 0x96AD,  0xF395 },
	{ 0x96AE,  0xF397 },
	{ 0x96AF,  0xF684 },
	{ 0x96B0,  0xF28F },
	{ 0x96B1,  0xEE95 },
	{ 0x96B2,  0x826E },
	{ 0x96B3,  0x8F52 },
	{ 0x96B5,  0xE2A0 },
	{ 0x96B8,  0xDD9C },
	{ 0x96BB,  0xF59C },
	{ 0x96BD,  0xD69A },
	{ 0x96C2,  0xEE9A },
	{ 0x96C3,  0xCA90 },
	{ 0x96C7,  0xEC9A },
	{ 0x96CC,  0xA04B },
	{ 0x96CD,  0xEC9D },
	{ 0x96D1,  0xA386 },
	{ 0x96D7,  0xEA91 },
	{ 0x96D8,  0xD594 },
	{ 0x96D9,  0xE286 },
	{ 0x96DB,  0x8EF0 },
	{ 0x96DC,  0x8EF6 },
	{ 0x96DD,  0xF282 },
	{ 0x96DE,  0x8EAF },
	{ 0x96E0,  0x8EF5 },
	{ 0x96E2,  0x9047 },
	{ 0x96E3,  0x9049 },
	{ 0x96E4,  0x9FCB },
	{ 0x96E5,  0xAB97 },
	{ 0x96EA,  0x8D89 },
	{ 0x96EB,  0xDF96 },
	{ 0x96EC,  0xDF95 },
	{ 0x96EE,  0xE896 },
	{ 0x96EF,  0x9EA7 },
	{ 0x96F1,  0x9D98 },
	{ 0x96F2,  0x8E94 },
	{ 0x96F3,  0x8F77 },
	{ 0x96F4,  0xDD9B },
	{ 0x96F5,  0x8EBE },
	{ 0x96F6,  0xB4A0 },
	{ 0x96F9,  0xDF9B },
	{ 0x9740,  0xB28E },
	{ 0x9741,  0xBB9A },
	{ 0x9742,  0x9E82 },
	{ 0x9748,  0xE699 },
	{ 0x9749,  0xE69A },
	{ 0x974C,  0xC18D },
	{ 0x9752,  0x898D },
	{ 0x9755,  0xC99F },
	{ 0x975B,  0xD596 },
	{ 0x975C,  0xA1A0 },
	{ 0x975E,  0x9041 },
	{ 0x9763,  0xE893 },
	{ 0x9764,  0xAB86 },
	{ 0x9765,  0xAB87 },
	{ 0x976E,  0xBF80 },
	{ 0x9770,  0x9899 },
	{ 0x9772,  0xCC92 },
	{ 0x9773,  0xA284 },
	{ 0x9774,  0xE288 },
	{ 0x9776,  0xDC87 },
	{ 0x9779,  0x90B5 },
	{ 0x977E,  0xBE93 },
	{ 0x97A3,  0x91EB },
	{ 0x97A7,  0x9D8D },
	{ 0x97A8,  0x9291 },
	{ 0x97AA,  0xD388 },
	{ 0x97AF,  0xC8F9 },
	{ 0x97B3,  0x8E9A },
	{ 0x97B7,  0xB0A0 },
	{ 0x97BB,  0xC38A },
	{ 0x97BC,  0xB18B },
	{ 0x97BF,  0xE280 },
	{ 0x97C4,  0xC490 },
	{ 0x97C8,  0x8FEE },
	{ 0x97CB,  0x8FD5 },
	{ 0x97CE,  0xA186 },
	{ 0x97D0,  0xF58F },
	{ 0x97D1,  0x9892 },
	{ 0x97D5,  0xAA93 },
	{ 0x97D6,  0xC794 },
	{ 0x97D9,  0x8EB5 },
	{ 0x97DF,  0x8E98 },
	{ 0x97E0,  0xC38C },
	{ 0x97E2,  0xE19C },
	{ 0x97E5,  0x8F79 },
	{ 0x97E6,  0x9D9A },
	{ 0x97E9,  0xAB81 },
	{ 0x97EF,  0xA9A0 },
	{ 0x97F0,  0xBD92 },
	{ 0x97F9,  0xD092 },
	{ 0x97FC,  0xC196 },
	{ 0x9844,  0xC798 },
	{ 0x9846,  0xFE92 },
	{ 0x9848,  0xB79D },
	{ 0x984C,  0x8992 },
	{ 0x984D,  0xB09E },
	{ 0x984F,  0xA780 },
	{ 0x9850,  0xA789 },
	{ 0x9854,  0x959B },
	{ 0x9857,  0xC7A0 },
	{ 0x9858,  0xE695 },
	{ 0x9859,  0xC69C },
	{ 0x985B,  0xA782 },
	{ 0x985C,  0xA69F },
	{ 0x985E,  0x8EF9 },
	{ 0x9863,  0xB49E },
	{ 0x9866,  0x9482 },
	{ 0x9868,  0x92A1 },
	{ 0x986C,  0xD095 },
	{ 0x986F,  0xFC8E },
	{ 0x9870,  0xB581 },
	{ 0x9873,  0x918E },
	{ 0x9876,  0x82CB },
	{ 0x9877,  0x959A },
	{ 0x9878,  0xA7A0 },
	{ 0x987A,  0x8F40 },
	{ 0x987D,  0xCA83 },
	{ 0x987E,  0x96F0 },
	{ 0x98A1,  0x8D9D },
	{ 0x98A5,  0xFA86 },
	{ 0x98AB,  0xE489 },
	{ 0x98AD,  0xC8BE },
	{ 0x98AE,  0x8699 },
	{ 0x98AF,  0xDA91 },
	{ 0x98B2,  0x9484 },
	{ 0x98B3,  0xD392 },
	{ 0x98B4,  0x9281 },
	{ 0x98B5,  0xAB83 },
	{ 0x98B7,  0xB58B },
	{ 0x98B8,  0x9FA8 },
	{ 0x98BA,  0xBE9D },
	{ 0x98BB,  0x8FFA },
	{ 0x98BE,  0x81E9 },
	{ 0x98BF,  0x8F4A },
	{ 0x98C1,  0xA286 },
	{ 0x98C2,  0xB79B },
	{ 0x98C4,  0x9FC2 },
	{ 0x98C6,  0x8B90 },
	{ 0x98C7,  0x8E88 },
	{ 0x98C8,  0xB592 },
	{ 0x98C9,  0xBF85 },
	{ 0x98CA,  0xB594 },
	{ 0x98CF,  0xEF8C },
	{ 0x98D2,  0x928B },
	{ 0x98D3,  0xB59F },
	{ 0x98D4,  0xC879 },
	{ 0x98D5,  0x94AF },
	{ 0x98D7,  0x94B8 },
	{ 0x98D8,  0xC87A },
	{ 0x98DA,  0x9FC0 },
	{ 0x98DC,  0x8E64 },
	{ 0x98DE,  0x9FC1 },
	{ 0x98E0,  0xC887 },
	{ 0x98E1,  0x91E3 },
	{ 0x98E2,  0x9768 },
	{ 0x98E3,  0xBB92 },
	{ 0x98E5,  0xB687 },
	{ 0x98E7,  0x8B87 },
	{ 0x98EA,  0xDA81 },
	{ 0x98ED,  0xB195 },
	{ 0x98EE,  0xE49A },
	{ 0x98EF,  0x94D7 },
	{ 0x98F0,  0x8987 },
	{ 0x98F1,  0x8EB7 },
	{ 0x98F2,  0x9982 },
	{ 0x98F3,  0x94DF },
	{ 0x98F5,  0x94E0 },
	{ 0x98F6,  0xAB96 },
	{ 0x98F7,  0xAB98 },
	{ 0x98F8,  0xB68D },
	{ 0x98F9,  0xC18A },
	{ 0x98FB,  0x94F1 },
	{ 0x98FC,  0x9F44 },
	{ 0x98FD,  0xEF91 },
	{ 0x9941,  0x83D5 },
	{ 0x9942,  0x9051 },
	{ 0x9943,  0x8E74 },
	{ 0x9944,  0x94F8 },
	{ 0x9945,  0x8E75 },
	{ 0x9947,  0xAC84 },
	{ 0x9949,  0x8253 },
	{ 0x994A,  0xF782 },
	{ 0x994C,  0x9296 },
	{ 0x994D,  0xA38A },
	{ 0x994F,  0x8480 },
	{ 0x9950,  0xC08A },
	{ 0x9951,  0xB69C },
	{ 0x9952,  0x8EE9 },
	{ 0x9953,  0xE098 },
	{ 0x9954,  0xE584 },
	{ 0x9957,  0x9A96 },
	{ 0x9958,  0xAC8F },
	{ 0x995A,  0xC99A },
	{ 0x995C,  0x905E },
	{ 0x995D,  0x9969 },
	{ 0x995E,  0xFC8F },
	{ 0x9960,  0xCA82 },
	{ 0x9961,  0x9563 },
	{ 0x9962,  0x905F },
	{ 0x9963,  0xD38B },
	{ 0x9964,  0xD391 },
	{ 0x9965,  0xE58E },
	{ 0x9966,  0x83D9 },
	{ 0x9968,  0xC8A3 },
	{ 0x9969,  0x81A6 },
	{ 0x996A,  0x8ECD },
	{ 0x996B,  0xE590 },
	{ 0x996C,  0x8370 },
	{ 0x996D,  0x966F },
	{ 0x996F,  0xFB9D },
	{ 0x9970,  0x989D },
	{ 0x9971,  0xFB89 },
	{ 0x9972,  0x967C },
	{ 0x9974,  0x96A2 },
	{ 0x9975,  0xB58C },
	{ 0x9976,  0x96A4 },
	{ 0x9977,  0x96A8 },
	{ 0x9978,  0x9FB7 },
	{ 0x9979,  0xB798 },
	{ 0x997C,  0x96AE },
	{ 0x997D,  0x96AF },
	{ 0x997E,  0x96B0 },
	{ 0x99A2,  0xB097 },
	{ 0x99A3,  0x96B2 },
	{ 0x99A4,  0xCA8C },
	{ 0x99A6,  0xD39C },
	{ 0x99A8,  0x96B5 },
	{ 0x99A9,  0xA691 },
	{ 0x99AA,  0x82AB },
	{ 0x99AB,  0xFB8B },
	{ 0x99AC,  0x96BE },
	{ 0x99AE,  0x938A },
	{ 0x99AF,  0xE993 },
	{ 0x99B0,  0xFB8F },
	{ 0x99B1,  0x9B80 },
	{ 0x99B2,  0x83FA },
	{ 0x99B4,  0xA48A },
	{ 0x99B5,  0x9BB0 },
	{ 0x99B6,  0x8EE4 },
	{ 0x99B7,  0xB886 },
	{ 0x99B8,  0xAA9D },
	{ 0x99B9,  0xC18E },
	{ 0x99BA,  0xB292 },
	{ 0x99BB,  0x8140 },
	{ 0x99BD,  0x81AA },
	{ 0x99BE,  0x9071 },
	{ 0x99BF,  0xD39E },
	{ 0x99C0,  0x81E0 },
	{ 0x99C1,  0x81DE },
	{ 0x99C2,  0x8259 },
	{ 0x99C4,  0xDA9B },
	{ 0x99C5,  0xDA9F },
	{ 0x99C6,  0x82ED },
	{ 0x99C8,  0x9077 },
	{ 0x99C9,  0xA493 },
	{ 0x99CA,  0xAD94 },
	{ 0x99CB,  0xA05B },
	{ 0x99CC,  0x9BA9 },
	{ 0x99CD,  0xDB84 },
	{ 0x99D0,  0xA063 },
	{ 0x99D1,  0xCB86 },
	{ 0x99D2,  0xDB8A },
	{ 0x99D3,  0x9766 },
	{ 0x99D4,  0xAE81 },
	{ 0x99D6,  0xAE89 },
	{ 0x99D7,  0xB89A },
	{ 0x99D8,  0xCB92 },
	{ 0x99D9,  0xD496 },
	{ 0x99DA,  0xED8D },
	{ 0x99DB,  0xCB9B },
	{ 0x99DC,  0xDB92 },
	{ 0x99DD,  0xF49C },
	{ 0x99DF,  0xBB96 },
	{ 0x99E0,  0x8E44 },
	{ 0x99E2,  0x848C },
	{ 0x99E3,  0x8262 },
	{ 0x99E4,  0xC8B9 },
	{ 0x99E5,  0x8984 },
	{ 0x99E6,  0x82F3 },
	{ 0x99E7,  0x91E1 },
	{ 0x99E8,  0xB98F },
	{ 0x99EA,  0x98FA },
	{ 0x99EB,  0xA0A2 },
	{ 0x99EC,  0xB991 },
	{ 0x99ED,  0x83D0 },
	{ 0x99EE,  0xB990 },
	{ 0x99EF,  0x8E69 },
	{ 0x99F0,  0x8C95 },
	{ 0x99F1,  0x938E },
	{ 0x99F2,  0x938C },
	{ 0x99F3,  0xC854 },
	{ 0x99F4,  0xCD8B },
	{ 0x99F6,  0x9C46 },
	{ 0x99F7,  0xBA87 },
	{ 0x99F9,  0xA0B5 },
	{ 0x99FA,  0x8149 },
	{ 0x99FB,  0xC38B },
	{ 0x99FC,  0xCC8E },
	{ 0x99FD,  0xCC93 },
	{ 0x99FE,  0xD592 },
	{ 0x9A40,  0x81ED },
	{ 0x9A41,  0xD59E },
	{ 0x9A42,  0xD59B },
	{ 0x9A43,  0x90B1 },
	{ 0x9A44,  0xDC83 },
	{ 0x9A45,  0x8266 },
	{ 0x9A46,  0xC8F1 },
	{ 0x9A47,  0xE698 },
	{ 0x9A4A,  0x8F54 },
	{ 0x9A4B,  0xED92 },
	{ 0x9A4C,  0x8E65 },
	{ 0x9A4D,  0xC8FA },
	{ 0x9A4E,  0xF08B },
	{ 0x9A4F,  0x8365 },
	{ 0x9A51,  0xF283 },
	{ 0x9A52,  0x83B1 },
	{ 0x9A53,  0x9AC4 },
	{ 0x9A54,  0xCC96 },
	{ 0x9A56,  0x9B5C },
	{ 0x9A57,  0x8C9C },
	{ 0x9A59,  0x9F41 },
	{ 0x9A5B,  0xF287 },
	{ 0x9A5D,  0xEA96 },
	{ 0x9A5E,  0x8373 },
	{ 0x9A5F,  0xCE84 },
	{ 0x9A61,  0xA892 },
	{ 0x9A62,  0xE784 },
	{ 0x9A64,  0xC3A0 },
	{ 0x9A65,  0xC865 },
	{ 0x9A66,  0x90CF },
	{ 0x9A67,  0xD68B },
	{ 0x9A68,  0x8496 },
	{ 0x9A69,  0xDD82 },
	{ 0x9A6A,  0x82B4 },
	{ 0x9A6B,  0x90C7 },
	{ 0x9A6C,  0xF486 },
	{ 0x9A6D,  0x9C4A },
	{ 0x9A6F,  0xA0CF },
	{ 0x9A71,  0xF09B },
	{ 0x9A72,  0x82FD },
	{ 0x9A73,  0x9A8B },
	{ 0x9A74,  0xD695 },
	{ 0x9A75,  0xC8F0 },
	{ 0x9A76,  0x8341 },
	{ 0x9A77,  0xA0DE },
	{ 0x9A78,  0x82FE },
	{ 0x9A7A,  0x83EF },
	{ 0x9A7D,  0x90CA },
	{ 0x9A7E,  0xF28E },
	{ 0x9AA1,  0x8E81 },
	{ 0x9AA2,  0xCE8A },
	{ 0x9AA3,  0x835B },
	{ 0x9AA4,  0xF182 },
	{ 0x9AA5,  0x836B },
	{ 0x9AA6,  0xF398 },
	{ 0x9AA7,  0x9A6B },
	{ 0x9AA8,  0xF783 },
	{ 0x9AA9,  0xF185 },
	{ 0x9AAA,  0xDD9E },
	{ 0x9AAB,  0xE79C },
	{ 0x9AAC,  0xCD95 },
	{ 0x9AAD,  0xDD9F },
	{ 0x9AAE,  0x9A51 },
	{ 0x9AAF,  0x8346 },
	{ 0x9AB0,  0xF290 },
	{ 0x9AB1,  0x83B6 },
	{ 0x9AB2,  0xEF95 },
	{ 0x9AB3,  0x83A3 },
	{ 0x9AB7,  0x9F52 },
	{ 0x9AB8,  0x99F7 },
	{ 0x9AB9,  0x8E9E },
	{ 0x9ABB,  0x8ED4 },
	{ 0x9ABC,  0x99F5 },
	{ 0x9AC2,  0x8980 },
	{ 0x9AC3,  0x9FA1 },
	{ 0x9AC7,  0x8E86 },
	{ 0x9ACA,  0x9583 },
	{ 0x9AD0,  0xA891 },
	{ 0x9AD2,  0x8EFE },
	{ 0x9AD9,  0xBD8D },
	{ 0x9ADA,  0x8F5A },
	{ 0x9ADB,  0x907A },
	{ 0x9AE2,  0xBC83 },
	{ 0x9AE4,  0x89A0 },
	{ 0x9AE8,  0xB38E },
	{ 0x9AF1,  0xF89C },
	{ 0x9AF2,  0xCA9D },
	{ 0x9AF6,  0xF19F },
	{ 0x9AFB,  0x90ED },
	{ 0x9AFC,  0x989C },
	{ 0x9B46,  0x8EA6 },
	{ 0x9B49,  0x8EEE },
	{ 0x9B4A,  0xA09A },
	{ 0x9B4C,  0xD181 },
	{ 0x9B54,  0x9B8A },
	{ 0x9B58,  0xD48E },
	{ 0x9B5A,  0xC295 },
	{ 0x9B5C,  0xEDA0 },
	{ 0x9B5E,  0xE295 },
	{ 0x9B5F,  0xE29B },
	{ 0x9B70,  0x8160 },
	{ 0x9B71,  0xA087 },
	{ 0x9B72,  0xD890 },
	{ 0x9B7D,  0xCE93 },
	{ 0x9B7E,  0x9798 },
	{ 0x9BA1,  0xB399 },
	{ 0x9BB4,  0xAF9C },
	{ 0x9BB6,  0x8990 },
	{ 0x9BBC,  0x8EA5 },
	{ 0x9BC4,  0xC8F8 },
	{ 0x9BCA,  0x82E3 },
	{ 0x9BCD,  0xC868 },
	{ 0x9BD1,  0xC853 },
	{ 0x9BD3,  0x917A },
	{ 0x9BD4,  0x889A },
	{ 0x9BD5,  0x8FF0 },
	{ 0x9BDA,  0x91DC },
	{ 0x9BE9,  0xA592 },
	{ 0x9BF4,  0x958E },
	{ 0x9BF5,  0xBE98 },
	{ 0x9BF9,  0xA0AB },
	{ 0x9BFC,  0xED88 },
	{ 0x9C40,  0xB19A },
	{ 0x9C45,  0xDB8C },
	{ 0x9C4E,  0xF38C },
	{ 0x9C50,  0xCF8F },
	{ 0x9C51,  0xFD8B },
	{ 0x9C54,  0x90D8 },
	{ 0x9C57,  0xF799 },
	{ 0x9C59,  0xA58D },
	{ 0x9C5A,  0xA189 },
	{ 0x9C5D,  0xA06D },
	{ 0x9C64,  0xB69D },
	{ 0x9C6A,  0xDA8A },
	{ 0x9C6D,  0xEA9D },
	{ 0x9C72,  0xC082 },
	{ 0x9C75,  0xA79A },
	{ 0x9C7B,  0x928D },
	{ 0x9C7C,  0x9758 },
	{ 0x9C7E,  0x9248 },
	{ 0x9CA8,  0xCC91 },
	{ 0x9CAB,  0xDC8A },
	{ 0x9CAE,  0x839A },
	{ 0x9CAF,  0x99D3 },
	{ 0x9CB2,  0xF19E },
	{ 0x9CB3,  0xCB88 },
	{ 0x9CB7,  0xBDA0 },
	{ 0x9CBF,  0xD08B },
	{ 0x9CC2,  0xE190 },
	{ 0x9CC5,  0x91EC },
	{ 0x9CCC,  0xD195 },
	{ 0x9CCD,  0x96DA },
	{ 0x9CD9,  0xB69A },
	{ 0x9CDA,  0xC081 },
	{ 0x9CDC,  0xD98A },
	{ 0x9CDE,  0x81C2 },
	{ 0x9CE0,  0x91AC },
	{ 0x9CE2,  0x8F51 },
	{ 0x9CE3,  0xA08E },
	{ 0x9CE4,  0xE69E },
	{ 0x9CEB,  0x815D },
	{ 0x9CEE,  0xBB8C },
	{ 0x9CEF,  0x81F1 },
	{ 0x9CF1,  0xD79B },
	{ 0x9CF3,  0x978D },
	{ 0x9CF4,  0xC78C },
	{ 0x9CF5,  0x8583 },
	{ 0x9CF9,  0x868A },
	{ 0x9D4A,  0xB29D },
	{ 0x9D4C,  0x9A84 },
	{ 0x9D4D,  0xC381 },
	{ 0x9D55,  0x9681 },
	{ 0x9D60,  0xFB91 },
	{ 0x9D61,  0xC8D4 },
	{ 0x9D62,  0x8276 },
	{ 0x9D70,  0x9565 },
	{ 0x9D74,  0x9ADE },
	{ 0x9D76,  0xD198 },
	{ 0x9D79,  0xAE9E },
	{ 0x9D7D,  0x8C93 },
	{ 0x9D7E,  0xBB8B },
	{ 0x9DA1,  0xA0A6 },
	{ 0x9DA3,  0x869F },
	{ 0x9DA6,  0xEC94 },
	{ 0x9DA7,  0x81C5 },
	{ 0x9DA8,  0xE485 },
	{ 0x9DA9,  0x90F8 },
	{ 0x9DAE,  0x98F7 },
	{ 0x9DBA,  0x90EE },
	{ 0x9DBD,  0x835D },
	{ 0x9DBF,  0x98F0 },
	{ 0x9DC0,  0x9266 },
	{ 0x9DC3,  0xB29C },
	{ 0x9DC7,  0x83F7 },
	{ 0x9DC8,  0xCE83 },
	{ 0x9DCA,  0x8885 },
	{ 0x9DCF,  0x8F70 },
	{ 0x9DD0,  0xC49F },
	{ 0x9DD1,  0x9660 },
	{ 0x9DD3,  0x838B },
	{ 0x9DD5,  0x83DA },
	{ 0x9DD6,  0x90DF },
	{ 0x9DDA,  0xAD82 },
	{ 0x9DDB,  0xE799 },
	{ 0x9DDC,  0x90A7 },
	{ 0x9DDD,  0xD9A0 },
	{ 0x9DDE,  0xF28D },
	{ 0x9DDF,  0xE084 },
	{ 0x9DE0,  0xE497 },
	{ 0x9DE1,  0xDC81 },
	{ 0x9DE2,  0x8886 },
	{ 0x9DE3,  0xB794 },
	{ 0x9DE4,  0x9AA0 },
	{ 0x9DE5,  0x91E5 },
	{ 0x9DE6,  0x96AA },
	{ 0x9DE7,  0xB79F },
	{ 0x9DE8,  0x9675 },
	{ 0x9DE9,  0xBB89 },
	{ 0x9DEA,  0xA2A0 },
	{ 0x9DEB,  0x81BB },
	{ 0x9DEC,  0x8584 },
	{ 0x9DEF,  0xC582 },
	{ 0x9DF0,  0x8EE2 },
	{ 0x9DF1,  0xF796 },
	{ 0x9DF4,  0x94AC },
	{ 0x9DF5,  0x90D5 },
	{ 0x9DF6,  0x90D4 },
	{ 0x9DF7,  0x91BD },
	{ 0x9DF8,  0x90D3 },
	{ 0x9DFB,  0xC59D },
	{ 0x9E41,  0xD69F },
	{ 0x9E42,  0xB789 },
	{ 0x9E43,  0xB083 },
	{ 0x9E45,  0x8A9E },
	{ 0x9E46,  0xBA93 },
	{ 0x9E47,  0x8E85 },
	{ 0x9E48,  0xC28F },
	{ 0x9E49,  0x9FA2 },
	{ 0x9E4A,  0xCC8A },
	{ 0x9E4B,  0x934A },
	{ 0x9E4C,  0x9347 },
	{ 0x9E4D,  0xB29F },
	{ 0x9E4E,  0x9EAD },
	{ 0x9E50,  0x83F6 },
	{ 0x9E52,  0x9163 },
	{ 0x9E55,  0x9166 },
	{ 0x9E56,  0x8880 },
	{ 0x9E57,  0x91CC },
	{ 0x9E58,  0x9D89 },
	{ 0x9E59,  0x94C8 },
	{ 0x9E5A,  0x98F2 },
	{ 0x9E5C,  0xA28F },
	{ 0x9E5D,  0x92A0 },
	{ 0x9E5E,  0x83E9 },
	{ 0x9E5F,  0x825C },
	{ 0x9E60,  0x975F },
	{ 0x9E61,  0x96B6 },
	{ 0x9E62,  0x96EC },
	{ 0x9E65,  0xC7F7 },
	{ 0x9E67,  0xFA90 },
	{ 0x9E68,  0x9B89 },
	{ 0x9E6A,  0xD789 },
	{ 0x9E71,  0xC8E6 },
	{ 0x9E73,  0xBA85 },
	{ 0x9E78,  0x91A0 },
	{ 0x9EA1,  0xF48A },
	{ 0x9EA2,  0xF193 },
	{ 0x9EAF,  0xD194 },
	{ 0x9EB0,  0xEF9A },
	{ 0x9EB1,  0xE797 },
	{ 0x9EB2,  0x90DD },
	{ 0x9EB3,  0x8182 },
	{ 0x9EB5,  0xCE9E },
	{ 0x9EB6,  0x9192 },
	{ 0x9EB7,  0x9383 },
	{ 0x9EBA,  0x9497 },
	{ 0x9EBD,  0x815C },
	{ 0x9EBF,  0xA486 },
	{ 0x9EC0,  0x8887 },
	{ 0x9EC1,  0x8EB1 },
	{ 0x9EC7,  0x827D },
	{ 0x9ECA,  0x8342 },
	{ 0x9ED1,  0xC190 },
	{ 0x9ED6,  0x9F93 },
	{ 0x9ED7,  0xA395 },
	{ 0x9EDB,  0xA582 },
	{ 0x9EDC,  0x9D86 },
	{ 0x9EE1,  0x827E },
	{ 0x9EE2,  0xC596 },
	{ 0x9EE4,  0xBF9B },
	{ 0x9EE6,  0xCE97 },
	{ 0x9EE8,  0x91E8 },
	{ 0x9EE9,  0xDD8F },
	{ 0x9EEA,  0xC8C0 },
	{ 0x9EEB,  0x82C4 },
	{ 0x9EED,  0xDD9D },
	{ 0x9EF1,  0xBC90 },
	{ 0x9EF5,  0x91E7 },
	{ 0x9EF7,  0x9594 },
	{ 0x9EFA,  0x8D91 },
	{ 0x9EFE,  0x83EB },
	{ 0x9F40,  0xEF96 },
	{ 0x9F41,  0x8367 },
	{ 0x9F42,  0xA694 },
	{ 0x9F44,  0x9E91 },
	{ 0x9F45,  0xD889 },
	{ 0x9F49,  0xC84A },
	{ 0x9F4F,  0x8D8E },
	{ 0x9F51,  0x8FA8 },
	{ 0x9F52,  0x83DC },
	{ 0x9F54,  0xC488 },
	{ 0x9F55,  0xC29B },
	{ 0x9F56,  0xAC8B },
	{ 0x9F57,  0xE29D },
	{ 0x9F58,  0x968A },
	{ 0x9F59,  0xC996 },
	{ 0x9F5A,  0x8E6E },
	{ 0x9F5B,  0x9F9C },
	{ 0x9F5C,  0xC8F2 },
	{ 0x9F5D,  0x9FDF },
	{ 0x9F5E,  0xEE88 },
	{ 0x9F5F,  0x8EB9 },
	{ 0x9F61,  0x905A },
	{ 0x9F62,  0xA390 },
	{ 0x9F63,  0xEE94 },
	{ 0x9F64,  0xE095 },
	{ 0x9F65,  0xEB81 },
	{ 0x9F67,  0xEE92 },
	{ 0x9F69,  0xEE9D },
	{ 0x9F6A,  0x8F6C },
	{ 0x9F6B,  0xA794 },
	{ 0x9F6C,  0x9C93 },
	{ 0x9F6D,  0xEE9B },
	{ 0x9F6E,  0x9C8B },
	{ 0x9F6F,  0x9C9B },
	{ 0x9F71,  0x9D85 },
	{ 0x9F72,  0x8E90 },
	{ 0x9F73,  0x9C94 },
	{ 0x9F74,  0x8E9F },
	{ 0x9F75,  0x8F92 },
	{ 0x9F76,  0xF484 },
	{ 0x9F77,  0xA0F5 },
	{ 0x9F78,  0xF088 },
	{ 0x9F79,  0x8E83 },
	{ 0x9F7A,  0xEA97 },
	{ 0x9F7B,  0xE787 },
	{ 0x9F7C,  0xEE80 },
	{ 0x9F7D,  0xA3E1 },
	{ 0x9F7E,  0xBC8C },
	{ 0x9FA1,  0x8FC5 },
	{ 0x9FA2,  0x949A },
	{ 0x9FA3,  0xEE8B },
	{ 0x9FA4,  0xD69D },
	{ 0x9FA6,  0x9395 },
	{ 0x9FA7,  0x8EE6 },
	{ 0x9FA8,  0x8F64 },
	{ 0x9FA9,  0x9997 },
	{ 0x9FAB,  0xD68D },
	{ 0x9FAC,  0xAF9E },
	{ 0x9FAE,  0xAF84 },
	{ 0x9FAF,  0xBA8C },
	{ 0x9FB0,  0x90AD },
	{ 0x9FB2,  0xA584 },
	{ 0x9FB4,  0xA89C },
	{ 0x9FB6,  0x8FCA },
	{ 0x9FB7,  0xC580 },
	{ 0x9FB8,  0xDBA0 },
	{ 0x9FB9,  0xBF8F },
	{ 0x9FBA,  0x8A9D },
	{ 0x9FBC,  0xC88B },
	{ 0x9FBD,  0x83B0 },
	{ 0x9FC2,  0xAB91 },
	{ 0x9FC3,  0xE383 },
	{ 0x9FC4,  0x8183 },
	{ 0x9FC6,  0xC8AA },
	{ 0x9FC7,  0x9B90 },
	{ 0x9FC9,  0x8F89 },
	{ 0x9FCA,  0xC785 },
	{ 0x9FCC,  0xFA88 },
	{ 0x9FCD,  0x8799 },
	{ 0x9FCE,  0x899E },
	{ 0x9FCF,  0x8198 },
	{ 0x9FD0,  0xBD9E },
	{ 0x9FD2,  0x8786 },
	{ 0x9FD3,  0x8EA4 },
	{ 0x9FD4,  0x9580 },
	{ 0x9FD5,  0xF292 },
	{ 0x9FD6,  0xB98A },
	{ 0x9FDB,  0xD182 },
	{ 0x9FDC,  0xCC8B },
	{ 0x9FDD,  0xF58E },
	{ 0x9FDE,  0xA0D8 },
	{ 0x9FDF,  0xDC9C },
	{ 0x9FE0,  0xA0CC },
	{ 0x9FE1,  0xC8EF },
	{ 0x9FE2,  0xC8EC },
	{ 0x9FE3,  0xD69E },
	{ 0x9FE4,  0x8170 },
	{ 0x9FE5,  0xA38E },
	{ 0x9FE7,  0xBD9D },
	{ 0x9FE8,  0xED82 },
	{ 0x9FE9,  0xD390 },
	{ 0x9FEB,  0x8F71 },
	{ 0x9FED,  0xEA87 },
	{ 0x9FEE,  0xDE81 },
	{ 0x9FF0,  0xB98D },
	{ 0x9FF1,  0xE19A },
	{ 0x9FF2,  0xF680 },
	{ 0x9FF3,  0xCC80 },
	{ 0x9FF4,  0x8A94 },
	{ 0x9FF6,  0xD583 },
	{ 0x9FF7,  0xEA86 },
	{ 0x9FF8,  0x9A8F },
	{ 0x9FFA,  0xD293 },
	{ 0x9FFB,  0x904C },
	{ 0x9FFC,  0x918F },
	{ 0x9FFD,  0xC28C },
	{ 0x9FFE,  0xC898 },
	{ 0xA041,  0xE7A0 },
	{ 0xA042,  0x9193 },
	{ 0xA043,  0xE59A },
	{ 0xA044,  0xA28D },
	{ 0xA046,  0x9048 },
	{ 0xA048,  0x90A6 },
	{ 0xA049,  0x998A },
	{ 0xA04A,  0xDF9F },
	{ 0xA04B,  0xE685 },
	{ 0xA04C,  0xA19F },
	{ 0xA04D,  0x9FB1 },
	{ 0xA04E,  0xD49F },
	{ 0xA050,  0xEF9E },
	{ 0xA051,  0x8FB1 },
	{ 0xA052,  0xAD9F },
	{ 0xA058,  0xC28B },
	{ 0xA05B,  0xB296 },
	{ 0xA05C,  0xEF8E },
	{ 0xA05D,  0xF58C },
	{ 0xA05E,  0xE385 },
	{ 0xA05F,  0xE282 },
	{ 0xA060,  0xDD90 },
	{ 0xA061,  0x907B },
	{ 0xA064,  0xE198 },
	{ 0xA065,  0xB58D },
	{ 0xA066,  0xC8F6 },
	{ 0xA067,  0xC8F4 },
	{ 0xA069,  0x8698 },
	{ 0xA06B,  0xEF97 },
	{ 0xA06C,  0xC8FB },
	{ 0xA06E,  0xCF94 },
	{ 0xA070,  0x8344 },
	{ 0xA071,  0xC689 },
	{ 0xA073,  0x889E },
	{ 0xA074,  0xC681 },
	{ 0xA075,  0x908C },
	{ 0xA076,  0x8395 },
	{ 0xA079,  0xDE96 },
	{ 0xA07A,  0xBB86 },
	{ 0xA07C,  0x8FB6 },
	{ 0xA07D,  0x9F43 },
	{ 0xA0A1,  0xB19C },
	{ 0xA0A3,  0xA0A7 },
	{ 0xA0A6,  0xC48B },
	{ 0xA0A8,  0xE4A0 },
	{ 0xA0A9,  0xC496 },
	{ 0xA0AA,  0xFB93 },
	{ 0xA0AE,  0x8EAA },
	{ 0xA0B0,  0xD29C },
	{ 0xA0B2,  0xE09A },
	{ 0xA0B3,  0xC98D },
	{ 0xA0B4,  0xD395 },
	{ 0xA0B5,  0x9065 },
	{ 0xA0B6,  0xB78C },
	{ 0xA0B7,  0x9FB4 },
	{ 0xA0B8,  0x9FB2 },
	{ 0xA0B9,  0xAE82 },
	{ 0xA0BA,  0xE990 },
	{ 0xA0BB,  0x909B },
	{ 0xA0BC,  0x9FF8 },
	{ 0xA0BE,  0xCA88 },
	{ 0xA0BF,  0x9FB0 },
	{ 0xA0C0,  0xA483 },
	{ 0xA0C1,  0xA298 },
	{ 0xA0C2,  0xF380 },
	{ 0xA0C4,  0x8EB6 },
	{ 0xA0C6,  0x9079 },
	{ 0xA0C7,  0xE188 },
	{ 0xA0C8,  0xE181 },
	{ 0xA0C9,  0xC8EE },
	{ 0xA0CA,  0xB89C },
	{ 0xA0CB,  0xAE91 },
	{ 0xA0CC,  0xEA80 },
	{ 0xA0CD,  0xA296 },
	{ 0xA0CE,  0x8EC9 },
	{ 0xA0CF,  0xCA9E },
	{ 0xA0D1,  0xC783 },
	{ 0xA0D2,  0xDB94 },
	{ 0xA0D4,  0xD48D },
	{ 0xA0D6,  0xAA8A },
	{ 0xA0D7,  0xE18A },
	{ 0xA0D9,  0x9FAF },
	{ 0xA0DB,  0x8FEF },
	{ 0xA0DC,  0xA88F },
	{ 0xA0DD,  0xCF9A },
	{ 0xA0E0,  0x9EE6 },
	{ 0xA0E2,  0xCA86 },
	{ 0xA0E5,  0xB294 },
	{ 0xA0E7,  0x879B },
	{ 0xA0F2,  0x8F8B },
	{ 0xA0FA,  0xD791 },
	{ 0xA0FC,  0x8685 },
	{ 0xA0FD,  0x898A },
	{ 0xA140,  0xA140 },
	{ 0xA141,  0xA141 },
	{ 0xA142,  0xA142 },
	{ 0xA143,  0xA143 },
	{ 0xA144,  0xA144 },
	{ 0xA146,  0xA146 },
	{ 0xA147,  0xA147 },
	{ 0xA148,  0xA148 },
	{ 0xA149,  0xA149 },
	{ 0xA14A,  0xA14A },
	{ 0xA14B,  0xA14B },
	{ 0xA14C,  0xA14C },
	{ 0xA14D,  0xA14D },
	{ 0xA14F,  0xA14F },
	{ 0xA14F,  0xC6E1 },
	{ 0xA150,  0xA145 },
	{ 0xA150,  0xA150 },
	{ 0xA151,  0xA151 },
	{ 0xA152,  0xA152 },
	{ 0xA153,  0xA153 },
	{ 0xA154,  0xA154 },
	{ 0xA155,  0xA155 },
	{ 0xA156,  0xA156 },
	{ 0xA157,  0xA157 },
	{ 0xA158,  0xA158 },
	{ 0xA159,  0xA159 },
	{ 0xA15B,  0xA15B },
	{ 0xA15C,  0xA15A },
	{ 0xA15C,  0xA15C },
	{ 0xA15D,  0xA15D },
	{ 0xA15E,  0xA15E },
	{ 0xA15F,  0xA15F },
	{ 0xA160,  0xA160 },
	{ 0xA161,  0xA161 },
	{ 0xA162,  0xA162 },
	{ 0xA163,  0xA163 },
	{ 0xA164,  0xA164 },
	{ 0xA165,  0xA165 },
	{ 0xA166,  0xA166 },
	{ 0xA167,  0xA167 },
	{ 0xA168,  0xA168 },
	{ 0xA169,  0xA169 },
	{ 0xA16A,  0xA16A },
	{ 0xA16B,  0xA16B },
	{ 0xA16C,  0xA16C },
	{ 0xA16D,  0xA16D },
	{ 0xA16E,  0xA16E },
	{ 0xA16F,  0xA16F },
	{ 0xA170,  0xA170 },
	{ 0xA171,  0xA171 },
	{ 0xA172,  0xA172 },
	{ 0xA173,  0xA173 },
	{ 0xA174,  0xA174 },
	{ 0xA175,  0xA175 },
	{ 0xA176,  0xA176 },
	{ 0xA177,  0xA177 },
	{ 0xA178,  0xA178 },
	{ 0xA179,  0xA179 },
	{ 0xA17A,  0xA17A },
	{ 0xA17B,  0xA17B },
	{ 0xA17C,  0xA17C },
	{ 0xA17D,  0xA17D },
	{ 0xA17E,  0xA17E },
	{ 0xA1A1,  0xA1A1 },
	{ 0xA1A2,  0xA1A2 },
	{ 0xA1A3,  0xA1A3 },
	{ 0xA1A4,  0xA1A4 },
	{ 0xA1A5,  0xA1A5 },
	{ 0xA1A6,  0xA1A6 },
	{ 0xA1A7,  0xA1A7 },
	{ 0xA1A8,  0xA1A8 },
	{ 0xA1A9,  0xA1A9 },
	{ 0xA1AA,  0xA1AA },
	{ 0xA1AB,  0xA1AB },
	{ 0xA1AC,  0xA1AC },
	{ 0xA1AD,  0xA1AD },
	{ 0xA1AE,  0xA1AE },
	{ 0xA1AF,  0xA1AF },
	{ 0xA1AF,  0xC6E6 },
	{ 0xA1B0,  0xA1B0 },
	{ 0xA1B1,  0xA1B1 },
	{ 0xA1B2,  0xA1B2 },
	{ 0xA1B3,  0xA1B3 },
	{ 0xA1B4,  0xA1B4 },
	{ 0xA1B5,  0xA1B5 },
	{ 0xA1B6,  0xA1B6 },
	{ 0xA1B7,  0xA1B7 },
	{ 0xA1B8,  0xA1B8 },
	{ 0xA1B9,  0xA1B9 },
	{ 0xA1BA,  0xA1BA },
	{ 0xA1BB,  0xA1BB },
	{ 0xA1BC,  0xA1BC },
	{ 0xA1BD,  0xA1BD },
	{ 0xA1BE,  0xA1BE },
	{ 0xA1BF,  0xA1BF },
	{ 0xA1C0,  0xA1C0 },
	{ 0xA1C1,  0xA1C1 },
	{ 0xA1C4,  0xA1C4 },
	{ 0xA1C4,  0xA1C5 },
	{ 0xA1C6,  0xA1C6 },
	{ 0xA1C7,  0xA1C7 },
	{ 0xA1C8,  0xA1C8 },
	{ 0xA1C9,  0xA1C9 },
	{ 0xA1CA,  0xA1CA },
	{ 0xA1CB,  0xA1CB },
	{ 0xA1CC,  0xA1CC },
	{ 0xA1CD,  0xA1CD },
	{ 0xA1CE,  0xA1CE },
	{ 0xA1CF,  0xA1CF },
	{ 0xA1D0,  0xA1D0 },
	{ 0xA1D1,  0xA1D1 },
	{ 0xA1D2,  0xA1D2 },
	{ 0xA1D3,  0xA1D3 },
	{ 0xA1D4,  0xA1D4 },
	{ 0xA1D5,  0xA1D5 },
	{ 0xA1D6,  0xA1D6 },
	{ 0xA1D7,  0xA1D7 },
	{ 0xA1D8,  0xA1D8 },
	{ 0xA1D9,  0xA1D9 },
	{ 0xA1DA,  0xA1DA },
	{ 0xA1DB,  0xA1DB },
	{ 0xA1DC,  0xA1DC },
	{ 0xA1DD,  0xA1DD },
	{ 0xA1DE,  0xA1DE },
	{ 0xA1DF,  0xA1DF },
	{ 0xA1E0,  0xA1E0 },
	{ 0xA1E1,  0xA1E1 },
	{ 0xA1E2,  0xA1E2 },
	{ 0xA1E4,  0xA1E4 },
	{ 0xA1E5,  0xA1E5 },
	{ 0xA1E6,  0xA1E6 },
	{ 0xA1E7,  0xA1E7 },
	{ 0xA1E8,  0xA1E8 },
	{ 0xA1E9,  0xA1E9 },
	{ 0xA1EA,  0xA1EA },
	{ 0xA1EB,  0xA1EB },
	{ 0xA1EC,  0xA1EC },
	{ 0xA1ED,  0xA1ED },
	{ 0xA1EE,  0xA1EE },
	{ 0xA1EF,  0xA1EF },
	{ 0xA1F0,  0xA1F0 },
	{ 0xA1F1,  0xA1F1 },
	{ 0xA1F4,  0xA1F4 },
	{ 0xA1F5,  0xA1F5 },
	{ 0xA1F6,  0xA1F6 },
	{ 0xA1F7,  0xA1F7 },
	{ 0xA1F8,  0xA1F8 },
	{ 0xA1F9,  0xA1F9 },
	{ 0xA1FA,  0xA1FA },
	{ 0xA1FB,  0xA1FB },
	{ 0xA1FC,  0xA1FC },
	{ 0xA1FD,  0xA1FD },
	{ 0xA241,  0xA1FE },
	{ 0xA242,  0xA240 },
	{ 0xA243,  0xA243 },
	{ 0xA245,  0xA245 },
	{ 0xA248,  0xA248 },
	{ 0xA249,  0xA249 },
	{ 0xA24A,  0xA24A },
	{ 0xA24B,  0xA24B },
	{ 0xA24C,  0xA24C },
	{ 0xA24D,  0xA24D },
	{ 0xA24E,  0xA24E },
	{ 0xA24F,  0xA24F },
	{ 0xA250,  0xA250 },
	{ 0xA251,  0xA251 },
	{ 0xA252,  0xA252 },
	{ 0xA253,  0xA253 },
	{ 0xA254,  0xA254 },
	{ 0xA255,  0xA255 },
	{ 0xA256,  0xA256 },
	{ 0xA257,  0xA257 },
	{ 0xA258,  0xA258 },
	{ 0xA259,  0xA259 },
	{ 0xA25A,  0xA25A },
	{ 0xA25B,  0xA25B },
	{ 0xA25C,  0xA25C },
	{ 0xA25D,  0xA25D },
	{ 0xA25E,  0xA25E },
	{ 0xA25F,  0xA25F },
	{ 0xA260,  0xA260 },
	{ 0xA261,  0xA261 },
	{ 0xA262,  0xA262 },
	{ 0xA263,  0xA263 },
	{ 0xA264,  0xA264 },
	{ 0xA265,  0xA265 },
	{ 0xA266,  0xA266 },
	{ 0xA267,  0xA267 },
	{ 0xA268,  0xA268 },
	{ 0xA269,  0xA269 },
	{ 0xA269,  0xF9FE },
	{ 0xA26A,  0xA26A },
	{ 0xA26B,  0xA26B },
	{ 0xA26C,  0xA26C },
	{ 0xA26D,  0xA26D },
	{ 0xA26E,  0xA26E },
	{ 0xA26F,  0xA26F },
	{ 0xA270,  0xA270 },
	{ 0xA271,  0xA271 },
	{ 0xA272,  0xA272 },
	{ 0xA273,  0xA273 },
	{ 0xA274,  0xA274 },
	{ 0xA275,  0xA275 },
	{ 0xA276,  0xA276 },
	{ 0xA277,  0xA277 },
	{ 0xA278,  0xA278 },
	{ 0xA279,  0xA279 },
	{ 0xA27A,  0xA27A },
	{ 0xA27B,  0xA27B },
	{ 0xA27C,  0xA27C },
	{ 0xA27D,  0xA27D },
	{ 0xA2A8,  0xA2A8 },
	{ 0xA2A9,  0xA2A9 },
	{ 0xA2AA,  0xA2AA },
	{ 0xA2AB,  0xA2AB },
	{ 0xA2AC,  0xA2AC },
	{ 0xA2AD,  0xA2AD },
	{ 0xA2AE,  0xA2AE },
	{ 0xA2AF,  0xA2AF },
	{ 0xA2B0,  0xA2B0 },
	{ 0xA2B1,  0xA2B1 },
	{ 0xA2B2,  0xA2B2 },
	{ 0xA2B3,  0xA2B3 },
	{ 0xA2B4,  0xA2B4 },
	{ 0xA2B5,  0xA2B5 },
	{ 0xA2B6,  0xA2B6 },
	{ 0xA2B7,  0xA2B7 },
	{ 0xA2B8,  0xA2B8 },
	{ 0xA2B9,  0xA2B9 },
	{ 0xA2BA,  0xA2BA },
	{ 0xA2BB,  0xA2BB },
	{ 0xA2BC,  0xA2BC },
	{ 0xA2BD,  0xA2BD },
	{ 0xA2BE,  0xA2BE },
	{ 0xA2BF,  0xA2BF },
	{ 0xA2C0,  0xA2C0 },
	{ 0xA2C1,  0xA2C1 },
	{ 0xA2C2,  0xA2C2 },
	{ 0xA2C3,  0xA2C3 },
	{ 0xA2C4,  0xA2C4 },
	{ 0xA2C5,  0xA2C5 },
	{ 0xA2C6,  0xA2C6 },
	{ 0xA2C7,  0xA2C7 },
	{ 0xA2C8,  0xA2C8 },
	{ 0xA2C9,  0xA2C9 },
	{ 0xA2CA,  0xA2CA },
	{ 0xA2CB,  0xA2CB },
	{ 0xA2CD,  0x818F },
	{ 0xA2CD,  0xA2CD },
	{ 0xA2CF,  0xA2CF },
	{ 0xA2D0,  0xA2D0 },
	{ 0xA2D1,  0xA2D1 },
	{ 0xA2D2,  0xA2D2 },
	{ 0xA2D3,  0xA2D3 },
	{ 0xA2D4,  0xA2D4 },
	{ 0xA2D5,  0xA2D5 },
	{ 0xA2D6,  0xA2D6 },
	{ 0xA2D7,  0xA2D7 },
	{ 0xA2D8,  0xA2D8 },
	{ 0xA2D9,  0xA2D9 },
	{ 0xA2DA,  0xA2DA },
	{ 0xA2DB,  0xA2DB },
	{ 0xA2DC,  0xA2DC },
	{ 0xA2DD,  0xA2DD },
	{ 0xA2DE,  0xA2DE },
	{ 0xA2DF,  0xA2DF },
	{ 0xA2E0,  0xA2E0 },
	{ 0xA2E1,  0xA2E1 },
	{ 0xA2E2,  0xA2E2 },
	{ 0xA2E3,  0xA2E3 },
	{ 0xA2E4,  0xA2E4 },
	{ 0xA2E5,  0xA2E5 },
	{ 0xA2E6,  0xA2E6 },
	{ 0xA2E7,  0xA2E7 },
	{ 0xA2E8,  0xA2E8 },
	{ 0xA2E9,  0xA2E9 },
	{ 0xA2EA,  0xA2EA },
	{ 0xA2EB,  0xA2EB },
	{ 0xA2EC,  0xA2EC },
	{ 0xA2ED,  0xA2ED },
	{ 0xA2EE,  0xA2EE },
	{ 0xA2EF,  0xA2EF },
	{ 0xA2F0,  0xA2F0 },
	{ 0xA2F1,  0xA2F1 },
	{ 0xA2F2,  0xA2F2 },
	{ 0xA2F3,  0xA2F3 },
	{ 0xA2F4,  0xA2F4 },
	{ 0xA2F5,  0xA2F5 },
	{ 0xA2F6,  0xA2F6 },
	{ 0xA2F7,  0xA2F7 },
	{ 0xA2F8,  0xA2F8 },
	{ 0xA2F9,  0xA2F9 },
	{ 0xA2FA,  0xA2FA },
	{ 0xA2FB,  0xA2FB },
	{ 0xA2FC,  0xA2FC },
	{ 0xA2FD,  0xA2FD },
	{ 0xA2FE,  0xA2FE },
	{ 0xA340,  0xA340 },
	{ 0xA341,  0xA341 },
	{ 0xA342,  0xA342 },
	{ 0xA343,  0xA343 },
	{ 0xA344,  0xA344 },
	{ 0xA345,  0xA345 },
	{ 0xA346,  0xA346 },
	{ 0xA347,  0xA347 },
	{ 0xA348,  0xA348 },
	{ 0xA349,  0xA349 },
	{ 0xA34A,  0xA34A },
	{ 0xA34B,  0xA34B },
	{ 0xA34C,  0xA34C },
	{ 0xA34D,  0xA34D },
	{ 0xA34E,  0xA34E },
	{ 0xA34F,  0xA34F },
	{ 0xA350,  0xA350 },
	{ 0xA351,  0xA351 },
	{ 0xA352,  0xA352 },
	{ 0xA353,  0xA353 },
	{ 0xA354,  0xA354 },
	{ 0xA355,  0xA355 },
	{ 0xA356,  0xA356 },
	{ 0xA357,  0xA357 },
	{ 0xA358,  0xA358 },
	{ 0xA359,  0xA359 },
	{ 0xA35A,  0xA35A },
	{ 0xA35B,  0xA35B },
	{ 0xA35C,  0xA35C },
	{ 0xA35D,  0xA35D },
	{ 0xA35E,  0xA35E },
	{ 0xA35F,  0xA35F },
	{ 0xA360,  0xA360 },
	{ 0xA361,  0xA361 },
	{ 0xA362,  0xA362 },
	{ 0xA363,  0xA363 },
	{ 0xA364,  0xA364 },
	{ 0xA365,  0xA365 },
	{ 0xA366,  0xA366 },
	{ 0xA367,  0xA367 },
	{ 0xA368,  0xA368 },
	{ 0xA369,  0xA369 },
	{ 0xA36A,  0xA36A },
	{ 0xA36B,  0xA36B },
	{ 0xA36C,  0xA36C },
	{ 0xA36D,  0xA36D },
	{ 0xA36E,  0xA36E },
	{ 0xA36F,  0xA36F },
	{ 0xA370,  0xA370 },
	{ 0xA371,  0xA371 },
	{ 0xA372,  0xA372 },
	{ 0xA373,  0xA373 },
	{ 0xA374,  0xA374 },
	{ 0xA375,  0xA375 },
	{ 0xA376,  0xA376 },
	{ 0xA377,  0xA377 },
	{ 0xA378,  0xA378 },
	{ 0xA379,  0xA379 },
	{ 0xA37A,  0xA37A },
	{ 0xA37B,  0xA37B },
	{ 0xA37C,  0xA37C },
	{ 0xA37D,  0xA37D },
	{ 0xA37E,  0xA37E },
	{ 0xA3A1,  0xA3A1 },
	{ 0xA3A2,  0xA3A2 },
	{ 0xA3A3,  0xA3A3 },
	{ 0xA3A4,  0xA3A4 },
	{ 0xA3A5,  0xA3A5 },
	{ 0xA3A6,  0xA3A6 },
	{ 0xA3A7,  0xA3A7 },
	{ 0xA3A8,  0xA3A8 },
	{ 0xA3A9,  0xA3A9 },
	{ 0xA3AA,  0xA3AA },
	{ 0xA3AB,  0xA3AB },
	{ 0xA3AC,  0xA3AC },
	{ 0xA3AD,  0xA3AD },
	{ 0xA3AE,  0xA3AE },
	{ 0xA3AF,  0xA3AF },
	{ 0xA3B0,  0xA3B0 },
	{ 0xA3B1,  0xA3B1 },
	{ 0xA3B2,  0xA3B2 },
	{ 0xA3B3,  0xA3B3 },
	{ 0xA3B4,  0xA3B4 },
	{ 0xA3B5,  0xA3B5 },
	{ 0xA3B6,  0xA3B6 },
	{ 0xA3B7,  0xA3B7 },
	{ 0xA3B8,  0xA3B8 },
	{ 0xA3B9,  0xA3B9 },
	{ 0xA3BA,  0xA3BA },
	{ 0xA3BB,  0xA3BB },
	{ 0xA3BC,  0xA3BC },
	{ 0xA3BD,  0xA3BD },
	{ 0xA3BE,  0xA3BE },
	{ 0xA3BF,  0xA3BF },
	{ 0xA440,  0xA440 },
	{ 0xA441,  0xA441 },
	{ 0xA442,  0xA442 },
	{ 0xA443,  0xA443 },
	{ 0xA444,  0xA444 },
	{ 0xA445,  0xA445 },
	{ 0xA446,  0xA446 },
	{ 0xA447,  0xA447 },
	{ 0xA448,  0xA448 },
	{ 0xA449,  0xA449 },
	{ 0xA44A,  0xA44A },
	{ 0xA44B,  0xA44B },
	{ 0xA44C,  0xA44C },
	{ 0xA44D,  0xA44D },
	{ 0xA44E,  0xA44E },
	{ 0xA44F,  0xA44F },
	{ 0xA450,  0xA450 },
	{ 0xA451,  0xA2CC },
	{ 0xA451,  0xA451 },
	{ 0xA452,  0xA452 },
	{ 0xA453,  0xA453 },
	{ 0xA454,  0xA454 },
	{ 0xA455,  0xA455 },
	{ 0xA456,  0xA456 },
	{ 0xA457,  0xA457 },
	{ 0xA458,  0xA458 },
	{ 0xA459,  0xA459 },
	{ 0xA45A,  0xA45A },
	{ 0xA45B,  0xA45B },
	{ 0xA45C,  0xA45C },
	{ 0xA45D,  0xA45D },
	{ 0xA45E,  0xA45E },
	{ 0xA45F,  0xA45F },
	{ 0xA460,  0xA460 },
	{ 0xA461,  0xA461 },
	{ 0xA461,  0xC94A },
	{ 0xA462,  0xA462 },
	{ 0xA463,  0xA463 },
	{ 0xA464,  0xA464 },
	{ 0xA465,  0xA465 },
	{ 0xA466,  0xA466 },
	{ 0xA467,  0xA467 },
	{ 0xA468,  0xA468 },
	{ 0xA469,  0xA469 },
	{ 0xA46A,  0xA46A },
	{ 0xA46B,  0xA46B },
	{ 0xA46C,  0xA46C },
	{ 0xA46D,  0xA46D },
	{ 0xA46E,  0xA46E },
	{ 0xA46F,  0xA46F },
	{ 0xA470,  0xA470 },
	{ 0xA471,  0xA471 },
	{ 0xA472,  0xA472 },
	{ 0xA473,  0xA473 },
	{ 0xA474,  0xA474 },
	{ 0xA475,  0xA475 },
	{ 0xA476,  0xA476 },
	{ 0xA477,  0xA477 },
	{ 0xA478,  0xA478 },
	{ 0xA479,  0xA479 },
	{ 0xA47A,  0xA47A },
	{ 0xA47B,  0xA47B },
	{ 0xA47C,  0xA47C },
	{ 0xA47D,  0xA47D },
	{ 0xA47E,  0xA47E },
	{ 0xA4A1,  0xA4A1 },
	{ 0xA4A2,  0xA4A2 },
	{ 0xA4A3,  0xA4A3 },
	{ 0xA4A4,  0xA4A4 },
	{ 0xA4A5,  0xA4A5 },
	{ 0xA4A6,  0xA4A6 },
	{ 0xA4A7,  0xA4A7 },
	{ 0xA4A8,  0xA4A8 },
	{ 0xA4A9,  0xA4A9 },
	{ 0xA4AA,  0xA4AA },
	{ 0xA4AB,  0xA4AB },
	{ 0xA4AC,  0xA4AC },
	{ 0xA4AD,  0xA4AD },
	{ 0xA4AE,  0xA4AE },
	{ 0xA4AF,  0xA4AF },
	{ 0xA4B0,  0xA4B0 },
	{ 0xA4B1,  0xA4B1 },
	{ 0xA4B2,  0xA4B2 },
	{ 0xA4B3,  0xA4B3 },
	{ 0xA4B4,  0xA4B4 },
	{ 0xA4B5,  0xA4B5 },
	{ 0xA4B6,  0xA4B6 },
	{ 0xA4B7,  0xA4B7 },
	{ 0xA4B8,  0xA4B8 },
	{ 0xA4B9,  0xA4B9 },
	{ 0xA4BA,  0xA4BA },
	{ 0xA4BB,  0xA4BB },
	{ 0xA4BC,  0xA4BC },
	{ 0xA4BD,  0xA4BD },
	{ 0xA4BE,  0xA4BE },
	{ 0xA4BF,  0xA4BF },
	{ 0xA4C0,  0xA4C0 },
	{ 0xA4C1,  0xA4C1 },
	{ 0xA4C2,  0xA4C2 },
	{ 0xA4C3,  0xA4C3 },
	{ 0xA4C4,  0xA4C4 },
	{ 0xA4C5,  0xA4C5 },
	{ 0xA4C6,  0xA4C6 },
	{ 0xA4C7,  0xA4C7 },
	{ 0xA4C8,  0xA4C8 },
	{ 0xA4C9,  0xA4C9 },
	{ 0xA4CA,  0xA2CE },
	{ 0xA4CA,  0xA4CA },
	{ 0xA4CB,  0xA4CB },
	{ 0xA4CC,  0xA4CC },
	{ 0xA4CD,  0xA4CD },
	{ 0xA4CE,  0xA4CE },
	{ 0xA4CF,  0xA4CF },
	{ 0xA4D0,  0xA4D0 },
	{ 0xA4D1,  0xA4D1 },
	{ 0xA4D2,  0xA4D2 },
	{ 0xA4D3,  0xA4D3 },
	{ 0xA4D4,  0xA4D4 },
	{ 0xA4D5,  0xA4D5 },
	{ 0xA4D6,  0xA4D6 },
	{ 0xA4D7,  0xA4D7 },
	{ 0xA4D8,  0xA4D8 },
	{ 0xA4D9,  0xA4D9 },
	{ 0xA4DA,  0xA4DA },
	{ 0xA4DB,  0xA4DB },
	{ 0xA4DC,  0xA4DC },
	{ 0xA4DD,  0xA4DD },
	{ 0xA4DE,  0xA4DE },
	{ 0xA4DF,  0xA4DF },
	{ 0xA4E0,  0xA4E0 },
	{ 0xA4E1,  0xA4E1 },
	{ 0xA4E2,  0xA4E2 },
	{ 0xA4E3,  0xA4E3 },
	{ 0xA4E4,  0xA4E4 },
	{ 0xA4E5,  0xA4E5 },
	{ 0xA4E6,  0xA4E6 },
	{ 0xA4E7,  0xA4E7 },
	{ 0xA4E8,  0xA4E8 },
	{ 0xA4E9,  0xA4E9 },
	{ 0xA4EA,  0xA4EA },
	{ 0xA4EB,  0xA4EB },
	{ 0xA4EC,  0xA4EC },
	{ 0xA4ED,  0xA4ED },
	{ 0xA4EE,  0xA4EE },
	{ 0xA4EF,  0xA4EF },
	{ 0xA4F0,  0xA4F0 },
	{ 0xA4F1,  0xA4F1 },
	{ 0xA4F2,  0xA4F2 },
	{ 0xA4F3,  0xA4F3 },
	{ 0xA4F4,  0xA4F4 },
	{ 0xA4F5,  0xA4F5 },
	{ 0xA4F6,  0xA4F6 },
	{ 0xA4F7,  0xA4F7 },
	{ 0xA4F8,  0xA4F8 },
	{ 0xA4F9,  0xA4F9 },
	{ 0xA4FA,  0xA4FA },
	{ 0xA4FB,  0xA4FB },
	{ 0xA4FC,  0xA4FC },
	{ 0xA4FD,  0xA4FD },
	{ 0xA4FE,  0xA4FE },
	{ 0xA540,  0xA540 },
	{ 0xA541,  0xA541 },
	{ 0xA542,  0xA542 },
	{ 0xA543,  0xA543 },
	{ 0xA544,  0xA544 },
	{ 0xA545,  0xA545 },
	{ 0xA546,  0xA546 },
	{ 0xA547,  0xA547 },
	{ 0xA548,  0xA548 },
	{ 0xA549,  0xA549 },
	{ 0xA54A,  0xA54A },
	{ 0xA54B,  0xA54B },
	{ 0xA54C,  0xA54C },
	{ 0xA54D,  0xA54D },
	{ 0xA54E,  0xA54E },
	{ 0xA54F,  0xA54F },
	{ 0xA550,  0xA550 },
	{ 0xA551,  0xA551 },
	{ 0xA552,  0xA552 },
	{ 0xA553,  0xA553 },
	{ 0xA554,  0xA554 },
	{ 0xA555,  0xA555 },
	{ 0xA556,  0xA556 },
	{ 0xA557,  0xA557 },
	{ 0xA558,  0xA558 },
	{ 0xA559,  0xA559 },
	{ 0xA55A,  0xA55A },
	{ 0xA55B,  0xA55B },
	{ 0xA55C,  0xA55C },
	{ 0xA55D,  0xA55D },
	{ 0xA55E,  0xA55E },
	{ 0xA55F,  0xA55F },
	{ 0xA560,  0xA560 },
	{ 0xA561,  0xA561 },
	{ 0xA562,  0xA562 },
	{ 0xA563,  0xA563 },
	{ 0xA564,  0xA564 },
	{ 0xA565,  0xA565 },
	{ 0xA566,  0xA566 },
	{ 0xA567,  0xA567 },
	{ 0xA568,  0xA568 },
	{ 0xA569,  0xA569 },
	{ 0xA56A,  0xA56A },
	{ 0xA56B,  0xA56B },
	{ 0xA56C,  0xA56C },
	{ 0xA56D,  0xA56D },
	{ 0xA56E,  0xA56E },
	{ 0xA56F,  0xA56F },
	{ 0xA570,  0xA570 },
	{ 0xA571,  0xA571 },
	{ 0xA572,  0xA572 },
	{ 0xA573,  0xA573 },
	{ 0xA574,  0xA574 },
	{ 0xA575,  0xA575 },
	{ 0xA576,  0xA576 },
	{ 0xA577,  0xA577 },
	{ 0xA578,  0xA578 },
	{ 0xA579,  0xA579 },
	{ 0xA57A,  0xA57A },
	{ 0xA57B,  0xA57B },
	{ 0xA57C,  0xA57C },
	{ 0xA57D,  0xA57D },
	{ 0xA57E,  0xA57E },
	{ 0xA5A1,  0xA5A1 },
	{ 0xA5A2,  0xA5A2 },
	{ 0xA5A3,  0xA5A3 },
	{ 0xA5A4,  0xA5A4 },
	{ 0xA5A5,  0xA5A5 },
	{ 0xA5A6,  0xA5A6 },
	{ 0xA5A7,  0xA5A7 },
	{ 0xA5A8,  0xA5A8 },
	{ 0xA5A9,  0xA5A9 },
	{ 0xA5AA,  0xA5AA },
	{ 0xA5AB,  0xA5AB },
	{ 0xA5AC,  0xA5AC },
	{ 0xA5AD,  0xA5AD },
	{ 0xA5AE,  0xA5AE },
	{ 0xA5AF,  0xA5AF },
	{ 0xA5B0,  0xA5B0 },
	{ 0xA5B1,  0xA5B1 },
	{ 0xA5B2,  0xA5B2 },
	{ 0xA5B3,  0xA5B3 },
	{ 0xA5B4,  0xA5B4 },
	{ 0xA5B5,  0xA5B5 },
	{ 0xA5B6,  0xA5B6 },
	{ 0xA5B7,  0xA5B7 },
	{ 0xA5B8,  0xA5B8 },
	{ 0xA5B9,  0xA5B9 },
	{ 0xA5BA,  0xA5BA },
	{ 0xA5BB,  0xA5BB },
	{ 0xA5BC,  0xA5BC },
	{ 0xA5BD,  0xA5BD },
	{ 0xA5BE,  0xA5BE },
	{ 0xA5BF,  0xA5BF },
	{ 0xA5C0,  0xA5C0 },
	{ 0xA5C1,  0xA5C1 },
	{ 0xA5C2,  0xA5C2 },
	{ 0xA5C3,  0xA5C3 },
	{ 0xA5C4,  0xA5C4 },
	{ 0xA5C5,  0xA5C5 },
	{ 0xA5C6,  0xA5C6 },
	{ 0xA5C7,  0xA5C7 },
	{ 0xA5C8,  0xA5C8 },
	{ 0xA5C9,  0xA5C9 },
	{ 0xA5CA,  0xA5CA },
	{ 0xA5CB,  0xA5CB },
	{ 0xA5CC,  0xA5CC },
	{ 0xA5CD,  0xA5CD },
	{ 0xA5CE,  0xA5CE },
	{ 0xA5CF,  0xA5CF },
	{ 0xA5D0,  0xA5D0 },
	{ 0xA5D1,  0xA5D1 },
	{ 0xA5D2,  0xA5D2 },
	{ 0xA5D3,  0xA5D3 },
	{ 0xA5D4,  0xA5D4 },
	{ 0xA5D5,  0xA5D5 },
	{ 0xA5D6,  0xA5D6 },
	{ 0xA5D7,  0xA5D7 },
	{ 0xA5D8,  0xA5D8 },
	{ 0xA5D9,  0xA5D9 },
	{ 0xA5DA,  0xA5DA },
	{ 0xA5DB,  0xA5DB },
	{ 0xA5DC,  0xA5DC },
	{ 0xA5DD,  0xA5DD },
	{ 0xA5DE,  0xA5DE },
	{ 0xA5DF,  0xA5DF },
	{ 0xA5E0,  0xA5E0 },
	{ 0xA5E1,  0xA5E1 },
	{ 0xA5E2,  0xA5E2 },
	{ 0xA5E3,  0xA5E3 },
	{ 0xA5E4,  0xA5E4 },
	{ 0xA5E5,  0xA5E5 },
	{ 0xA5E6,  0xA5E6 },
	{ 0xA5E7,  0xA5E7 },
	{ 0xA5E8,  0xA5E8 },
	{ 0xA5E9,  0xA5E9 },
	{ 0xA5EA,  0xA5EA },
	{ 0xA5EB,  0xA5EB },
	{ 0xA5EC,  0xA5EC },
	{ 0xA5ED,  0xA5ED },
	{ 0xA5EE,  0xA5EE },
	{ 0xA5EF,  0xA5EF },
	{ 0xA5F0,  0xA5F0 },
	{ 0xA5F1,  0xA5F1 },
	{ 0xA5F2,  0xA5F2 },
	{ 0xA5F3,  0xA5F3 },
	{ 0xA5F4,  0xA5F4 },
	{ 0xA5F5,  0xA5F5 },
	{ 0xA5F6,  0xA5F6 },
	{ 0xA5F7,  0xA5F7 },
	{ 0xA5F8,  0xA5F8 },
	{ 0xA5F9,  0xA5F9 },
	{ 0xA5FA,  0xA5FA },
	{ 0xA5FB,  0xA5FB },
	{ 0xA5FC,  0xA5FC },
	{ 0xA5FD,  0xA5FD },
	{ 0xA5FE,  0xA5FE },
	{ 0xA640,  0xA640 },
	{ 0xA641,  0xA641 },
	{ 0xA642,  0xA642 },
	{ 0xA643,  0xA643 },
	{ 0xA644,  0xA644 },
	{ 0xA645,  0xA645 },
	{ 0xA646,  0xA646 },
	{ 0xA647,  0xA647 },
	{ 0xA648,  0xA648 },
	{ 0xA649,  0xA649 },
	{ 0xA64A,  0xA64A },
	{ 0xA64B,  0xA64B },
	{ 0xA64C,  0xA64C },
	{ 0xA64D,  0xA64D },
	{ 0xA64E,  0xA64E },
	{ 0xA64F,  0xA64F },
	{ 0xA650,  0xA650 },
	{ 0xA651,  0xA651 },
	{ 0xA652,  0xA652 },
	{ 0xA653,  0xA653 },
	{ 0xA654,  0xA654 },
	{ 0xA655,  0xA655 },
	{ 0xA656,  0xA656 },
	{ 0xA657,  0xA657 },
	{ 0xA658,  0xA658 },
	{ 0xA659,  0xA659 },
	{ 0xA65A,  0xA65A },
	{ 0xA65B,  0xA65B },
	{ 0xA65C,  0xA65C },
	{ 0xA65D,  0xA65D },
	{ 0xA65E,  0xA65E },
	{ 0xA65F,  0xA65F },
	{ 0xA660,  0xA660 },
	{ 0xA661,  0xA661 },
	{ 0xA662,  0xA662 },
	{ 0xA663,  0xA663 },
	{ 0xA664,  0xA664 },
	{ 0xA665,  0xA665 },
	{ 0xA666,  0xA666 },
	{ 0xA667,  0xA667 },
	{ 0xA668,  0xA668 },
	{ 0xA669,  0xA669 },
	{ 0xA66A,  0xA66A },
	{ 0xA66B,  0xA66B },
	{ 0xA66C,  0xA66C },
	{ 0xA66D,  0xA66D },
	{ 0xA66E,  0xA66E },
	{ 0xA66F,  0xA66F },
	{ 0xA670,  0xA670 },
	{ 0xA671,  0xA671 },
	{ 0xA672,  0xA672 },
	{ 0xA673,  0xA673 },
	{ 0xA674,  0xA674 },
	{ 0xA675,  0xA675 },
	{ 0xA676,  0xA676 },
	{ 0xA677,  0xA677 },
	{ 0xA678,  0xA678 },
	{ 0xA679,  0xA679 },
	{ 0xA67A,  0xA67A },
	{ 0xA67B,  0xA67B },
	{ 0xA67C,  0xA67C },
	{ 0xA67D,  0xA67D },
	{ 0xA67E,  0xA67E },
	{ 0xA6A1,  0xA6A1 },
	{ 0xA6A2,  0xA6A2 },
	{ 0xA6A3,  0xA6A3 },
	{ 0xA6A4,  0xA6A4 },
	{ 0xA6A5,  0xA6A5 },
	{ 0xA6A6,  0xA6A6 },
	{ 0xA6A7,  0xA6A7 },
	{ 0xA6A8,  0xA6A8 },
	{ 0xA6A9,  0xA6A9 },
	{ 0xA6AA,  0xA6AA },
	{ 0xA6AB,  0xA6AB },
	{ 0xA6AC,  0xA6AC },
	{ 0xA6AD,  0xA6AD },
	{ 0xA6AE,  0xA6AE },
	{ 0xA6AF,  0xA6AF },
	{ 0xA6B0,  0xA6B0 },
	{ 0xA6B1,  0xA6B1 },
	{ 0xA6B2,  0xA6B2 },
	{ 0xA6B3,  0xA6B3 },
	{ 0xA6B4,  0xA6B4 },
	{ 0xA6B5,  0xA6B5 },
	{ 0xA6B6,  0xA6B6 },
	{ 0xA6B7,  0xA6B7 },
	{ 0xA6B8,  0xA6B8 },
	{ 0xA6B9,  0xA6B9 },
	{ 0xA6BA,  0xA6BA },
	{ 0xA6BB,  0xA6BB },
	{ 0xA6BC,  0xA6BC },
	{ 0xA6BD,  0xA6BD },
	{ 0xA6BE,  0xA6BE },
	{ 0xA6BF,  0xA6BF },
	{ 0xA6C0,  0xA6C0 },
	{ 0xA6C1,  0xA6C1 },
	{ 0xA6C2,  0xA6C2 },
	{ 0xA6C3,  0xA6C3 },
	{ 0xA6C4,  0xA6C4 },
	{ 0xA6C5,  0xA6C5 },
	{ 0xA6C6,  0xA6C6 },
	{ 0xA6C7,  0xA6C7 },
	{ 0xA6C8,  0xA6C8 },
	{ 0xA6C9,  0xA6C9 },
	{ 0xA6CA,  0xA6CA },
	{ 0xA6CB,  0xA6CB },
	{ 0xA6CC,  0xA6CC },
	{ 0xA6CD,  0xA6CD },
	{ 0xA6CE,  0xA6CE },
	{ 0xA6CF,  0xA6CF },
	{ 0xA6D0,  0xA6D0 },
	{ 0xA6D1,  0xA6D1 },
	{ 0xA6D2,  0xA6D2 },
	{ 0xA6D3,  0xA6D3 },
	{ 0xA6D4,  0xA6D4 },
	{ 0xA6D5,  0xA6D5 },
	{ 0xA6D6,  0xA6D6 },
	{ 0xA6D7,  0xA6D7 },
	{ 0xA6D8,  0xA6D8 },
	{ 0xA6D9,  0xA6D9 },
	{ 0xA6DA,  0xA6DA },
	{ 0xA6DB,  0xA6DB },
	{ 0xA6DC,  0xA6DC },
	{ 0xA6DD,  0xA6DD },
	{ 0xA6DE,  0xA6DE },
	{ 0xA6DF,  0xA6DF },
	{ 0xA6E0,  0xA6E0 },
	{ 0xA6E1,  0xA6E1 },
	{ 0xA6E2,  0xA6E2 },
	{ 0xA6E3,  0xA6E3 },
	{ 0xA6E4,  0xA6E4 },
	{ 0xA6E5,  0xA6E5 },
	{ 0xA6E6,  0xA6E6 },
	{ 0xA6E7,  0xA6E7 },
	{ 0xA6E8,  0xA6E8 },
	{ 0xA6E9,  0xA6E9 },
	{ 0xA6EA,  0xA6EA },
	{ 0xA6EB,  0xA6EB },
	{ 0xA6EC,  0xA6EC },
	{ 0xA6ED,  0xA6ED },
	{ 0xA6EE,  0xA6EE },
	{ 0xA6EF,  0xA6EF },
	{ 0xA6F0,  0xA6F0 },
	{ 0xA6F1,  0xA6F1 },
	{ 0xA6F2,  0xA6F2 },
	{ 0xA6F3,  0xA6F3 },
	{ 0xA6F4,  0xA6F4 },
	{ 0xA6F5,  0xA6F5 },
	{ 0xA6F6,  0xA6F6 },
	{ 0xA6F7,  0xA6F7 },
	{ 0xA6F8,  0xA6F8 },
	{ 0xA6F9,  0xA6F9 },
	{ 0xA6FA,  0xA6FA },
	{ 0xA6FB,  0xA6FB },
	{ 0xA6FC,  0xA6FC },
	{ 0xA6FD,  0xA6FD },
	{ 0xA6FE,  0xA6FE },
	{ 0xA740,  0xA740 },
	{ 0xA741,  0xA741 },
	{ 0xA742,  0xA742 },
	{ 0xA743,  0xA743 },
	{ 0xA744,  0xA744 },
	{ 0xA745,  0xA745 },
	{ 0xA746,  0xA746 },
	{ 0xA747,  0xA747 },
	{ 0xA748,  0xA748 },
	{ 0xA749,  0xA749 },
	{ 0xA74A,  0xA74A },
	{ 0xA74B,  0xA74B },
	{ 0xA74C,  0xA74C },
	{ 0xA74D,  0xA74D },
	{ 0xA74E,  0xA74E },
	{ 0xA74F,  0xA74F },
	{ 0xA750,  0xA750 },
	{ 0xA751,  0xA751 },
	{ 0xA752,  0xA752 },
	{ 0xA753,  0xA753 },
	{ 0xA754,  0xA754 },
	{ 0xA755,  0xA755 },
	{ 0xA756,  0xA756 },
	{ 0xA757,  0xA757 },
	{ 0xA758,  0xA758 },
	{ 0xA759,  0xA759 },
	{ 0xA75A,  0xA75A },
	{ 0xA75B,  0xA75B },
	{ 0xA75C,  0xA75C },
	{ 0xA75D,  0xA75D },
	{ 0xA75E,  0xA75E },
	{ 0xA75F,  0xA75F },
	{ 0xA760,  0xA760 },
	{ 0xA761,  0xA761 },
	{ 0xA762,  0xA762 },
	{ 0xA763,  0xA763 },
	{ 0xA764,  0xA764 },
	{ 0xA765,  0xA765 },
	{ 0xA766,  0xA766 },
	{ 0xA767,  0xA767 },
	{ 0xA768,  0xA768 },
	{ 0xA769,  0xA769 },
	{ 0xA76A,  0xA76A },
	{ 0xA76B,  0xA76B },
	{ 0xA76C,  0xA76C },
	{ 0xA76D,  0xA76D },
	{ 0xA76E,  0xA76E },
	{ 0xA76F,  0xA76F },
	{ 0xA770,  0xA770 },
	{ 0xA771,  0xA771 },
	{ 0xA772,  0xA772 },
	{ 0xA773,  0xA773 },
	{ 0xA774,  0xA774 },
	{ 0xA775,  0xA775 },
	{ 0xA776,  0xA776 },
	{ 0xA777,  0xA777 },
	{ 0xA778,  0xA778 },
	{ 0xA779,  0xA779 },
	{ 0xA77A,  0xA77A },
	{ 0xA77B,  0xA77B },
	{ 0xA77C,  0xA77C },
	{ 0xA77D,  0xA77D },
	{ 0xA77E,  0xA77E },
	{ 0xA7A1,  0xA7A1 },
	{ 0xA7A2,  0xA7A2 },
	{ 0xA7A3,  0xA7A3 },
	{ 0xA7A4,  0xA7A4 },
	{ 0xA7A5,  0xA7A5 },
	{ 0xA7A6,  0xA7A6 },
	{ 0xA7A7,  0xA7A7 },
	{ 0xA7A8,  0xA7A8 },
	{ 0xA7A9,  0xA7A9 },
	{ 0xA7AA,  0xA7AA },
	{ 0xA7AB,  0xA7AB },
	{ 0xA7AC,  0xA7AC },
	{ 0xA7AD,  0xA7AD },
	{ 0xA7AE,  0xA7AE },
	{ 0xA7AF,  0xA7AF },
	{ 0xA7B0,  0xA7B0 },
	{ 0xA7B1,  0xA7B1 },
	{ 0xA7B2,  0xA7B2 },
	{ 0xA7B3,  0xA7B3 },
	{ 0xA7B4,  0xA7B4 },
	{ 0xA7B5,  0xA7B5 },
	{ 0xA7B6,  0xA7B6 },
	{ 0xA7B7,  0xA7B7 },
	{ 0xA7B8,  0xA7B8 },
	{ 0xA7B9,  0xA7B9 },
	{ 0xA7BA,  0xA7BA },
	{ 0xA7BB,  0xA7BB },
	{ 0xA7BC,  0xA7BC },
	{ 0xA7BD,  0xA7BD },
	{ 0xA7BE,  0xA7BE },
	{ 0xA7BF,  0xA7BF },
	{ 0xA7C0,  0xA7C0 },
	{ 0xA7C1,  0xA7C1 },
	{ 0xA7C2,  0xA7C2 },
	{ 0xA7C3,  0xA7C3 },
	{ 0xA7C4,  0xA7C4 },
	{ 0xA7C5,  0xA7C5 },
	{ 0xA7C6,  0xA7C6 },
	{ 0xA7C7,  0xA7C7 },
	{ 0xA7C8,  0xA7C8 },
	{ 0xA7C9,  0xA7C9 },
	{ 0xA7CA,  0xA7CA },
	{ 0xA7CB,  0xA7CB },
	{ 0xA7CC,  0xA7CC },
	{ 0xA7CD,  0xA7CD },
	{ 0xA7CE,  0xA7CE },
	{ 0xA7CF,  0xA7CF },
	{ 0xA7D0,  0xA7D0 },
	{ 0xA7D1,  0xA7D1 },
	{ 0xA7D2,  0xA7D2 },
	{ 0xA7D3,  0xA7D3 },
	{ 0xA7D4,  0xA7D4 },
	{ 0xA7D5,  0xA7D5 },
	{ 0xA7D6,  0xA7D6 },
	{ 0xA7D7,  0xA7D7 },
	{ 0xA7D8,  0xA7D8 },
	{ 0xA7D9,  0xA7D9 },
	{ 0xA7DA,  0xA7DA },
	{ 0xA7DB,  0xA7DB },
	{ 0xA7DC,  0xA7DC },
	{ 0xA7DD,  0xA7DD },
	{ 0xA7DE,  0xA7DE },
	{ 0xA7DF,  0xA7DF },
	{ 0xA7E0,  0xA7E0 },
	{ 0xA7E1,  0xA7E1 },
	{ 0xA7E2,  0xA7E2 },
	{ 0xA7E3,  0xA7E3 },
	{ 0xA7E4,  0xA7E4 },
	{ 0xA7E5,  0xA7E5 },
	{ 0xA7E6,  0xA7E6 },
	{ 0xA7E7,  0xA7E7 },
	{ 0xA7E8,  0xA7E8 },
	{ 0xA7E9,  0xA7E9 },
	{ 0xA7EA,  0xA7EA },
	{ 0xA7EB,  0xA7EB },
	{ 0xA7EC,  0xA7EC },
	{ 0xA7ED,  0xA7ED },
	{ 0xA7EE,  0xA7EE },
	{ 0xA7EF,  0xA7EF },
	{ 0xA7F0,  0xA7F0 },
	{ 0xA7F1,  0xA7F1 },
	{ 0xA7F2,  0xA7F2 },
	{ 0xA7F3,  0xA7F3 },
	{ 0xA7F4,  0xA7F4 },
	{ 0xA7F5,  0xA7F5 },
	{ 0xA7F6,  0xA7F6 },
	{ 0xA7F7,  0xA7F7 },
	{ 0xA7F8,  0xA7F8 },
	{ 0xA7F9,  0xA7F9 },
	{ 0xA7FA,  0xA7FA },
	{ 0xA7FB,  0xA7FB },
	{ 0xA7FC,  0xA7FC },
	{ 0xA7FD,  0xA7FD },
	{ 0xA7FE,  0xA7FE },
	{ 0xA840,  0xA840 },
	{ 0xA841,  0xA841 },
	{ 0xA842,  0xA842 },
	{ 0xA843,  0xA843 },
	{ 0xA844,  0xA844 },
	{ 0xA845,  0xA845 },
	{ 0xA846,  0xA846 },
	{ 0xA847,  0xA847 },
	{ 0xA848,  0xA848 },
	{ 0xA849,  0xA849 },
	{ 0xA84A,  0xA84A },
	{ 0xA84B,  0xA84B },
	{ 0xA84C,  0xA84C },
	{ 0xA84D,  0xA84D },
	{ 0xA84E,  0xA84E },
	{ 0xA84F,  0xA84F },
	{ 0xA850,  0xA850 },
	{ 0xA851,  0xA851 },
	{ 0xA852,  0xA852 },
	{ 0xA853,  0xA853 },
	{ 0xA854,  0xA854 },
	{ 0xA855,  0xA855 },
	{ 0xA856,  0xA856 },
	{ 0xA857,  0xA857 },
	{ 0xA858,  0xA858 },
	{ 0xA859,  0xA859 },
	{ 0xA85A,  0xA85A },
	{ 0xA85B,  0xA85B },
	{ 0xA85C,  0xA85C },
	{ 0xA85D,  0xA85D },
	{ 0xA85E,  0xA85E },
	{ 0xA85F,  0xA85F },
	{ 0xA860,  0xA860 },
	{ 0xA861,  0xA861 },
	{ 0xA862,  0xA862 },
	{ 0xA863,  0xA863 },
	{ 0xA864,  0xA864 },
	{ 0xA865,  0xA865 },
	{ 0xA866,  0xA866 },
	{ 0xA867,  0xA867 },
	{ 0xA868,  0xA868 },
	{ 0xA869,  0xA869 },
	{ 0xA86A,  0xA86A },
	{ 0xA86B,  0xA86B },
	{ 0xA86C,  0xA86C },
	{ 0xA86D,  0xA86D },
	{ 0xA86E,  0xA86E },
	{ 0xA86F,  0xA86F },
	{ 0xA870,  0xA870 },
	{ 0xA871,  0xA871 },
	{ 0xA872,  0xA872 },
	{ 0xA873,  0xA873 },
	{ 0xA874,  0xA874 },
	{ 0xA875,  0xA875 },
	{ 0xA876,  0xA876 },
	{ 0xA877,  0xA877 },
	{ 0xA878,  0xA878 },
	{ 0xA879,  0xA879 },
	{ 0xA87A,  0xA87A },
	{ 0xA87B,  0xA87B },
	{ 0xA87C,  0xA87C },
	{ 0xA87D,  0xA87D },
	{ 0xA87E,  0xA87E },
	{ 0xA8A1,  0xA8A1 },
	{ 0xA8A2,  0xA8A2 },
	{ 0xA8A3,  0xA8A3 },
	{ 0xA8A4,  0xA8A4 },
	{ 0xA8A5,  0xA8A5 },
	{ 0xA8A6,  0xA8A6 },
	{ 0xA8A7,  0xA8A7 },
	{ 0xA8A8,  0xA8A8 },
	{ 0xA8A9,  0xA8A9 },
	{ 0xA8AA,  0xA8AA },
	{ 0xA8AB,  0xA8AB },
	{ 0xA8AC,  0xA8AC },
	{ 0xA8AD,  0xA8AD },
	{ 0xA8AE,  0xA8AE },
	{ 0xA8AF,  0xA8AF },
	{ 0xA8B0,  0xA8B0 },
	{ 0xA8B1,  0xA8B1 },
	{ 0xA8B2,  0xA8B2 },
	{ 0xA8B3,  0xA8B3 },
	{ 0xA8B4,  0xA8B4 },
	{ 0xA8B5,  0xA8B5 },
	{ 0xA8B6,  0xA8B6 },
	{ 0xA8B7,  0xA8B7 },
	{ 0xA8B8,  0xA8B8 },
	{ 0xA8B9,  0xA8B9 },
	{ 0xA8BA,  0xA8BA },
	{ 0xA8BB,  0xA8BB },
	{ 0xA8BC,  0xA8BC },
	{ 0xA8BD,  0xA8BD },
	{ 0xA8BE,  0xA8BE },
	{ 0xA8BF,  0xA8BF },
	{ 0xA8C0,  0xA8C0 },
	{ 0xA8C1,  0xA8C1 },
	{ 0xA8C2,  0xA8C2 },
	{ 0xA8C3,  0xA8C3 },
	{ 0xA8C4,  0xA8C4 },
	{ 0xA8C5,  0xA8C5 },
	{ 0xA8C6,  0xA8C6 },
	{ 0xA8C7,  0xA8C7 },
	{ 0xA8C8,  0xA8C8 },
	{ 0xA8C9,  0xA8C9 },
	{ 0xA8CA,  0xA8CA },
	{ 0xA8CB,  0xA8CB },
	{ 0xA8CC,  0xA8CC },
	{ 0xA8CD,  0xA8CD },
	{ 0xA8CE,  0xA8CE },
	{ 0xA8CF,  0xA8CF },
	{ 0xA8D0,  0xA8D0 },
	{ 0xA8D1,  0xA8D1 },
	{ 0xA8D2,  0xA8D2 },
	{ 0xA8D3,  0xA8D3 },
	{ 0xA8D4,  0xA8D4 },
	{ 0xA8D5,  0xA8D5 },
	{ 0xA8D6,  0xA8D6 },
	{ 0xA8D7,  0xA8D7 },
	{ 0xA8D8,  0xA8D8 },
	{ 0xA8D9,  0xA8D9 },
	{ 0xA8DA,  0xA8DA },
	{ 0xA8DB,  0xA8DB },
	{ 0xA8DC,  0xA8DC },
	{ 0xA8DD,  0xA8DD },
	{ 0xA8DE,  0xA8DE },
	{ 0xA8DF,  0xA8DF },
	{ 0xA8E0,  0xA8E0 },
	{ 0xA8E1,  0xA8E1 },
	{ 0xA8E2,  0xA8E2 },
	{ 0xA8E3,  0xA8E3 },
	{ 0xA8E4,  0xA8E4 },
	{ 0xA8E5,  0xA8E5 },
	{ 0xA8E6,  0xA8E6 },
	{ 0xA8E7,  0xA8E7 },
	{ 0xA8E8,  0xA8E8 },
	{ 0xA8E9,  0xA8E9 },
	{ 0xA8EA,  0xA8EA },
	{ 0xA8EB,  0xA8EB },
	{ 0xA8EC,  0xA8EC },
	{ 0xA8ED,  0xA8ED },
	{ 0xA8EE,  0xA8EE },
	{ 0xA8EF,  0xA8EF },
	{ 0xA8F0,  0xA8F0 },
	{ 0xA8F1,  0xA8F1 },
	{ 0xA8F2,  0xA8F2 },
	{ 0xA8F3,  0xA8F3 },
	{ 0xA8F4,  0xA8F4 },
	{ 0xA8F5,  0xA8F5 },
	{ 0xA8F6,  0xA8F6 },
	{ 0xA8F7,  0xA8F7 },
	{ 0xA8F8,  0xA8F8 },
	{ 0xA8F9,  0xA8F9 },
	{ 0xA8FA,  0xA8FA },
	{ 0xA8FB,  0xA8FB },
	{ 0xA8FC,  0xA8FC },
	{ 0xA8FD,  0xA8FD },
	{ 0xA8FE,  0xA8FE },
	{ 0xA940,  0xA940 },
	{ 0xA941,  0xA941 },
	{ 0xA942,  0xA942 },
	{ 0xA943,  0xA943 },
	{ 0xA944,  0xA944 },
	{ 0xA945,  0xA945 },
	{ 0xA946,  0xA946 },
	{ 0xA947,  0xA947 },
	{ 0xA948,  0xA948 },
	{ 0xA949,  0xA949 },
	{ 0xA94A,  0xA94A },
	{ 0xA94B,  0xA94B },
	{ 0xA94C,  0xA94C },
	{ 0xA94D,  0xA94D },
	{ 0xA94E,  0xA94E },
	{ 0xA94F,  0xA94F },
	{ 0xA950,  0xA950 },
	{ 0xA951,  0xA951 },
	{ 0xA952,  0xA952 },
	{ 0xA953,  0xA953 },
	{ 0xA954,  0xA954 },
	{ 0xA955,  0xA955 },
	{ 0xA956,  0xA956 },
	{ 0xA957,  0xA957 },
	{ 0xA958,  0xA958 },
	{ 0xA959,  0xA959 },
	{ 0xA95A,  0xA95A },
	{ 0xA95B,  0xA95B },
	{ 0xA95C,  0xA95C },
	{ 0xA95D,  0xA95D },
	{ 0xA95E,  0xA95E },
	{ 0xA95F,  0xA95F },
	{ 0xA960,  0xA960 },
	{ 0xA961,  0xA961 },
	{ 0xA962,  0xA962 },
	{ 0xA963,  0xA963 },
	{ 0xA964,  0xA964 },
	{ 0xA965,  0xA965 },
	{ 0xA966,  0xA966 },
	{ 0xA967,  0xA967 },
	{ 0xA968,  0xA968 },
	{ 0xA969,  0xA969 },
	{ 0xA96A,  0xA96A },
	{ 0xA96B,  0xA96B },
	{ 0xA96C,  0xA96C },
	{ 0xA96D,  0xA96D },
	{ 0xA96E,  0xA96E },
	{ 0xA96F,  0xA96F },
	{ 0xA970,  0xA970 },
	{ 0xA971,  0xA971 },
	{ 0xA972,  0xA972 },
	{ 0xA973,  0xA973 },
	{ 0xA974,  0xA974 },
	{ 0xA975,  0xA975 },
	{ 0xA976,  0xA976 },
	{ 0xA977,  0xA977 },
	{ 0xA978,  0xA978 },
	{ 0xA979,  0xA979 },
	{ 0xA97A,  0xA97A },
	{ 0xA97B,  0xA97B },
	{ 0xA97C,  0xA97C },
	{ 0xA97D,  0xA97D },
	{ 0xA97E,  0xA97E },
	{ 0xA9A1,  0xA9A1 },
	{ 0xA9A2,  0xA9A2 },
	{ 0xA9A3,  0xA9A3 },
	{ 0xA9A4,  0xA9A4 },
	{ 0xA9A5,  0xA9A5 },
	{ 0xA9A6,  0xA9A6 },
	{ 0xA9A7,  0xA9A7 },
	{ 0xA9A8,  0xA9A8 },
	{ 0xA9A9,  0xA9A9 },
	{ 0xA9AA,  0xA9AA },
	{ 0xA9AB,  0xA9AB },
	{ 0xA9AC,  0xA9AC },
	{ 0xA9AD,  0xA9AD },
	{ 0xA9AE,  0xA9AE },
	{ 0xA9AF,  0xA9AF },
	{ 0xA9B0,  0xA9B0 },
	{ 0xA9B1,  0xA9B1 },
	{ 0xA9B2,  0xA9B2 },
	{ 0xA9B3,  0xA9B3 },
	{ 0xA9B4,  0xA9B4 },
	{ 0xA9B5,  0xA9B5 },
	{ 0xA9B6,  0xA9B6 },
	{ 0xA9B7,  0xA9B7 },
	{ 0xA9B8,  0xA9B8 },
	{ 0xA9B9,  0xA9B9 },
	{ 0xA9BA,  0xA9BA },
	{ 0xA9BB,  0xA9BB },
	{ 0xA9BC,  0xA9BC },
	{ 0xA9BD,  0xA9BD },
	{ 0xA9BE,  0xA9BE },
	{ 0xA9BF,  0xA9BF },
	{ 0xA9C0,  0xA9C0 },
	{ 0xA9C1,  0xA9C1 },
	{ 0xA9C2,  0xA9C2 },
	{ 0xA9C3,  0xA9C3 },
	{ 0xA9C4,  0xA9C4 },
	{ 0xA9C5,  0xA9C5 },
	{ 0xA9C6,  0xA9C6 },
	{ 0xA9C7,  0xA9C7 },
	{ 0xA9C8,  0xA9C8 },
	{ 0xA9C9,  0xA9C9 },
	{ 0xA9CA,  0xA9CA },
	{ 0xA9CB,  0xA9CB },
	{ 0xA9CC,  0xA9CC },
	{ 0xA9CD,  0xA9CD },
	{ 0xA9CE,  0xA9CE },
	{ 0xA9CF,  0xA9CF },
	{ 0xA9D0,  0xA9D0 },
	{ 0xA9D1,  0xA9D1 },
	{ 0xA9D2,  0xA9D2 },
	{ 0xA9D3,  0xA9D3 },
	{ 0xA9D4,  0xA9D4 },
	{ 0xA9D5,  0xA9D5 },
	{ 0xA9D6,  0xA9D6 },
	{ 0xA9D7,  0xA9D7 },
	{ 0xA9D8,  0xA9D8 },
	{ 0xA9D9,  0xA9D9 },
	{ 0xA9DA,  0xA9DA },
	{ 0xA9DB,  0xA9DB },
	{ 0xA9DC,  0xA9DC },
	{ 0xA9DD,  0xA9DD },
	{ 0xA9DE,  0xA9DE },
	{ 0xA9DF,  0xA9DF },
	{ 0xA9E0,  0xA9E0 },
	{ 0xA9E1,  0xA9E1 },
	{ 0xA9E2,  0xA9E2 },
	{ 0xA9E3,  0xA9E3 },
	{ 0xA9E4,  0xA9E4 },
	{ 0xA9E5,  0xA9E5 },
	{ 0xA9E6,  0xA9E6 },
	{ 0xA9E7,  0xA9E7 },
	{ 0xA9E8,  0xA9E8 },
	{ 0xA9E9,  0xA9E9 },
	{ 0xA9EA,  0xA9EA },
	{ 0xA9EB,  0xA9EB },
	{ 0xA9EC,  0xA9EC },
	{ 0xA9ED,  0xA9ED },
	{ 0xA9EE,  0xA9EE },
	{ 0xA9EF,  0xA9EF },
	{ 0xA9F0,  0xA9F0 },
	{ 0xA9F1,  0xA9F1 },
	{ 0xA9F2,  0xA9F2 },
	{ 0xA9F3,  0xA9F3 },
	{ 0xA9F4,  0xA9F4 },
	{ 0xA9F5,  0xA9F5 },
	{ 0xA9F6,  0xA9F6 },
	{ 0xA9F7,  0xA9F7 },
	{ 0xA9F8,  0xA9F8 },
	{ 0xA9F9,  0xA9F9 },
	{ 0xA9FA,  0xA9FA },
	{ 0xA9FB,  0xA9FB },
	{ 0xA9FC,  0xA9FC },
	{ 0xA9FD,  0xA9FD },
	{ 0xA9FE,  0xA9FE },
	{ 0xAA40,  0xAA40 },
	{ 0xAA41,  0xAA41 },
	{ 0xAA42,  0xAA42 },
	{ 0xAA43,  0xAA43 },
	{ 0xAA44,  0xAA44 },
	{ 0xAA45,  0xAA45 },
	{ 0xAA46,  0xAA46 },
	{ 0xAA47,  0xAA47 },
	{ 0xAA48,  0xAA48 },
	{ 0xAA49,  0xAA49 },
	{ 0xAA4A,  0xAA4A },
	{ 0xAA4B,  0xAA4B },
	{ 0xAA4C,  0xAA4C },
	{ 0xAA4D,  0xAA4D },
	{ 0xAA4E,  0xAA4E },
	{ 0xAA4F,  0xAA4F },
	{ 0xAA50,  0xAA50 },
	{ 0xAA51,  0xAA51 },
	{ 0xAA52,  0xAA52 },
	{ 0xAA53,  0xAA53 },
	{ 0xAA54,  0xAA54 },
	{ 0xAA55,  0xAA55 },
	{ 0xAA56,  0xAA56 },
	{ 0xAA57,  0xAA57 },
	{ 0xAA58,  0xAA58 },
	{ 0xAA59,  0xAA59 },
	{ 0xAA5A,  0xAA5A },
	{ 0xAA5B,  0xAA5B },
	{ 0xAA5C,  0xAA5C },
	{ 0xAA5D,  0xAA5D },
	{ 0xAA5E,  0xAA5E },
	{ 0xAA5F,  0xAA5F },
	{ 0xAA60,  0xAA60 },
	{ 0xAA61,  0xAA61 },
	{ 0xAA62,  0xAA62 },
	{ 0xAA63,  0xAA63 },
	{ 0xAA64,  0xAA64 },
	{ 0xAA65,  0xAA65 },
	{ 0xAA66,  0xAA66 },
	{ 0xAA67,  0xAA67 },
	{ 0xAA68,  0xAA68 },
	{ 0xAA69,  0xAA69 },
	{ 0xAA6A,  0xAA6A },
	{ 0xAA6B,  0xAA6B },
	{ 0xAA6C,  0xAA6C },
	{ 0xAA6D,  0xAA6D },
	{ 0xAA6E,  0xAA6E },
	{ 0xAA6F,  0xAA6F },
	{ 0xAA70,  0xAA70 },
	{ 0xAA71,  0xAA71 },
	{ 0xAA72,  0xAA72 },
	{ 0xAA73,  0xAA73 },
	{ 0xAA74,  0xAA74 },
	{ 0xAA75,  0xAA75 },
	{ 0xAA76,  0xAA76 },
	{ 0xAA77,  0xAA77 },
	{ 0xAA78,  0xAA78 },
	{ 0xAA79,  0xAA79 },
	{ 0xAA7A,  0xAA7A },
	{ 0xAA7B,  0xAA7B },
	{ 0xAA7C,  0xAA7C },
	{ 0xAA7D,  0xAA7D },
	{ 0xAA7E,  0xAA7E },
	{ 0xAAA1,  0xAAA1 },
	{ 0xAAA2,  0xAAA2 },
	{ 0xAAA3,  0xAAA3 },
	{ 0xAAA4,  0xAAA4 },
	{ 0xAAA5,  0xAAA5 },
	{ 0xAAA6,  0xAAA6 },
	{ 0xAAA7,  0xAAA7 },
	{ 0xAAA8,  0xAAA8 },
	{ 0xAAA9,  0xAAA9 },
	{ 0xAAAA,  0xAAAA },
	{ 0xAAAB,  0xAAAB },
	{ 0xAAAC,  0xAAAC },
	{ 0xAAAD,  0xAAAD },
	{ 0xAAAE,  0xAAAE },
	{ 0xAAAF,  0xAAAF },
	{ 0xAAB0,  0xAAB0 },
	{ 0xAAB1,  0xAAB1 },
	{ 0xAAB2,  0xAAB2 },
	{ 0xAAB3,  0xAAB3 },
	{ 0xAAB4,  0xAAB4 },
	{ 0xAAB5,  0xAAB5 },
	{ 0xAAB6,  0xAAB6 },
	{ 0xAAB7,  0xAAB7 },
	{ 0xAAB8,  0xAAB8 },
	{ 0xAAB9,  0xAAB9 },
	{ 0xAABA,  0xAABA },
	{ 0xAABB,  0xAABB },
	{ 0xAABC,  0xAABC },
	{ 0xAABD,  0xAABD },
	{ 0xAABE,  0xAABE },
	{ 0xAABF,  0xAABF },
	{ 0xAAC0,  0xAAC0 },
	{ 0xAAC1,  0xAAC1 },
	{ 0xAAC2,  0xAAC2 },
	{ 0xAAC3,  0xAAC3 },
	{ 0xAAC4,  0xAAC4 },
	{ 0xAAC5,  0xAAC5 },
	{ 0xAAC6,  0xAAC6 },
	{ 0xAAC7,  0xAAC7 },
	{ 0xAAC8,  0xAAC8 },
	{ 0xAAC9,  0xAAC9 },
	{ 0xAACA,  0xAACA },
	{ 0xAACB,  0xAACB },
	{ 0xAACC,  0xAACC },
	{ 0xAACD,  0xAACD },
	{ 0xAACE,  0xAACE },
	{ 0xAACF,  0xAACF },
	{ 0xAAD0,  0xAAD0 },
	{ 0xAAD1,  0xAAD1 },
	{ 0xAAD2,  0xAAD2 },
	{ 0xAAD3,  0xAAD3 },
	{ 0xAAD4,  0xAAD4 },
	{ 0xAAD5,  0xAAD5 },
	{ 0xAAD6,  0xAAD6 },
	{ 0xAAD7,  0xAAD7 },
	{ 0xAAD8,  0xAAD8 },
	{ 0xAAD9,  0xAAD9 },
	{ 0xAADA,  0xAADA },
	{ 0xAADB,  0xAADB },
	{ 0xAADC,  0xAADC },
	{ 0xAADD,  0xAADD },
	{ 0xAADE,  0xAADE },
	{ 0xAADF,  0xAADF },
	{ 0xAAE0,  0xAAE0 },
	{ 0xAAE1,  0xAAE1 },
	{ 0xAAE2,  0xAAE2 },
	{ 0xAAE3,  0xAAE3 },
	{ 0xAAE4,  0xAAE4 },
	{ 0xAAE5,  0xAAE5 },
	{ 0xAAE6,  0xAAE6 },
	{ 0xAAE7,  0xAAE7 },
	{ 0xAAE8,  0xAAE8 },
	{ 0xAAE9,  0xAAE9 },
	{ 0xAAEA,  0xAAEA },
	{ 0xAAEB,  0xAAEB },
	{ 0xAAEC,  0xAAEC },
	{ 0xAAED,  0xAAED },
	{ 0xAAEE,  0xAAEE },
	{ 0xAAEF,  0xAAEF },
	{ 0xAAF0,  0xAAF0 },
	{ 0xAAF1,  0xAAF1 },
	{ 0xAAF2,  0xAAF2 },
	{ 0xAAF3,  0xAAF3 },
	{ 0xAAF4,  0xAAF4 },
	{ 0xAAF5,  0xAAF5 },
	{ 0xAAF6,  0xAAF6 },
	{ 0xAAF7,  0xAAF7 },
	{ 0xAAF8,  0xAAF8 },
	{ 0xAAF9,  0xAAF9 },
	{ 0xAAFA,  0xAAFA },
	{ 0xAAFB,  0xAAFB },
	{ 0xAAFC,  0xAAFC },
	{ 0xAAFD,  0xAAFD },
	{ 0xAAFE,  0xAAFE },
	{ 0xAB40,  0xAB40 },
	{ 0xAB41,  0xAB41 },
	{ 0xAB42,  0xAB42 },
	{ 0xAB43,  0xAB43 },
	{ 0xAB44,  0xAB44 },
	{ 0xAB45,  0xAB45 },
	{ 0xAB46,  0xAB46 },
	{ 0xAB47,  0xAB47 },
	{ 0xAB48,  0xAB48 },
	{ 0xAB49,  0xAB49 },
	{ 0xAB4A,  0xAB4A },
	{ 0xAB4B,  0xAB4B },
	{ 0xAB4C,  0xAB4C },
	{ 0xAB4D,  0xAB4D },
	{ 0xAB4E,  0xAB4E },
	{ 0xAB4F,  0xAB4F },
	{ 0xAB50,  0xAB50 },
	{ 0xAB51,  0xAB51 },
	{ 0xAB52,  0xAB52 },
	{ 0xAB53,  0xAB53 },
	{ 0xAB54,  0xAB54 },
	{ 0xAB55,  0xAB55 },
	{ 0xAB56,  0xAB56 },
	{ 0xAB57,  0xAB57 },
	{ 0xAB58,  0xAB58 },
	{ 0xAB59,  0xAB59 },
	{ 0xAB5A,  0xAB5A },
	{ 0xAB5B,  0xAB5B },
	{ 0xAB5C,  0xAB5C },
	{ 0xAB5D,  0xAB5D },
	{ 0xAB5E,  0xAB5E },
	{ 0xAB5F,  0xAB5F },
	{ 0xAB60,  0xAB60 },
	{ 0xAB61,  0xAB61 },
	{ 0xAB62,  0xAB62 },
	{ 0xAB63,  0xAB63 },
	{ 0xAB64,  0xAB64 },
	{ 0xAB65,  0xAB65 },
	{ 0xAB66,  0xAB66 },
	{ 0xAB67,  0xAB67 },
	{ 0xAB68,  0xAB68 },
	{ 0xAB69,  0xAB69 },
	{ 0xAB6A,  0xAB6A },
	{ 0xAB6B,  0xAB6B },
	{ 0xAB6C,  0xAB6C },
	{ 0xAB6D,  0xAB6D },
	{ 0xAB6E,  0xAB6E },
	{ 0xAB6F,  0xAB6F },
	{ 0xAB70,  0xAB70 },
	{ 0xAB71,  0xAB71 },
	{ 0xAB72,  0xAB72 },
	{ 0xAB73,  0xAB73 },
	{ 0xAB74,  0xAB74 },
	{ 0xAB75,  0xAB75 },
	{ 0xAB76,  0xAB76 },
	{ 0xAB77,  0xAB77 },
	{ 0xAB78,  0xAB78 },
	{ 0xAB79,  0xAB79 },
	{ 0xAB7A,  0xAB7A },
	{ 0xAB7B,  0xAB7B },
	{ 0xAB7C,  0xAB7C },
	{ 0xAB7D,  0xAB7D },
	{ 0xAB7E,  0xAB7E },
	{ 0xABA1,  0xABA1 },
	{ 0xABA2,  0xABA2 },
	{ 0xABA3,  0xABA3 },
	{ 0xABA4,  0xABA4 },
	{ 0xABA5,  0xABA5 },
	{ 0xABA6,  0xABA6 },
	{ 0xABA7,  0xABA7 },
	{ 0xABA8,  0xABA8 },
	{ 0xABA9,  0xABA9 },
	{ 0xABAA,  0xABAA },
	{ 0xABAB,  0xABAB },
	{ 0xABAC,  0xABAC },
	{ 0xABAD,  0xABAD },
	{ 0xABAE,  0xABAE },
	{ 0xABAF,  0xABAF },
	{ 0xABB0,  0xABB0 },
	{ 0xABB1,  0xABB1 },
	{ 0xABB2,  0xABB2 },
	{ 0xABB3,  0xABB3 },
	{ 0xABB4,  0xABB4 },
	{ 0xABB5,  0xABB5 },
	{ 0xABB6,  0xABB6 },
	{ 0xABB7,  0xABB7 },
	{ 0xABB8,  0xABB8 },
	{ 0xABB9,  0xABB9 },
	{ 0xABBA,  0xABBA },
	{ 0xABBB,  0xABBB },
	{ 0xABBC,  0xABBC },
	{ 0xABBD,  0xABBD },
	{ 0xABBE,  0xABBE },
	{ 0xABBF,  0xABBF },
	{ 0xABC0,  0xABC0 },
	{ 0xABC1,  0xABC1 },
	{ 0xABC2,  0xABC2 },
	{ 0xABC3,  0xABC3 },
	{ 0xABC4,  0xABC4 },
	{ 0xABC5,  0xABC5 },
	{ 0xABC6,  0xABC6 },
	{ 0xABC7,  0xABC7 },
	{ 0xABC8,  0xABC8 },
	{ 0xABC9,  0xABC9 },
	{ 0xABCA,  0xABCA },
	{ 0xABCB,  0xABCB },
	{ 0xABCC,  0xABCC },
	{ 0xABCD,  0xABCD },
	{ 0xABCE,  0xABCE },
	{ 0xABCF,  0xABCF },
	{ 0xABD0,  0xABD0 },
	{ 0xABD1,  0xABD1 },
	{ 0xABD2,  0xABD2 },
	{ 0xABD3,  0xABD3 },
	{ 0xABD4,  0xABD4 },
	{ 0xABD5,  0xABD5 },
	{ 0xABD6,  0xABD6 },
	{ 0xABD7,  0xABD7 },
	{ 0xABD8,  0xABD8 },
	{ 0xABD9,  0xABD9 },
	{ 0xABDA,  0xABDA },
	{ 0xABDB,  0xABDB },
	{ 0xABDC,  0xABDC },
	{ 0xABDD,  0xABDD },
	{ 0xABDE,  0xABDE },
	{ 0xABDF,  0xABDF },
	{ 0xABE0,  0xABE0 },
	{ 0xABE1,  0xABE1 },
	{ 0xABE2,  0xABE2 },
	{ 0xABE3,  0xABE3 },
	{ 0xABE4,  0xABE4 },
	{ 0xABE5,  0xABE5 },
	{ 0xABE6,  0xABE6 },
	{ 0xABE7,  0xABE7 },
	{ 0xABE8,  0xABE8 },
	{ 0xABE9,  0xABE9 },
	{ 0xABEA,  0xABEA },
	{ 0xABEB,  0xABEB },
	{ 0xABEC,  0xABEC },
	{ 0xABED,  0xABED },
	{ 0xABEE,  0xABEE },
	{ 0xABEF,  0xABEF },
	{ 0xABF0,  0xABF0 },
	{ 0xABF1,  0xABF1 },
	{ 0xABF2,  0xABF2 },
	{ 0xABF3,  0xABF3 },
	{ 0xABF4,  0xABF4 },
	{ 0xABF5,  0xABF5 },
	{ 0xABF6,  0xABF6 },
	{ 0xABF7,  0xABF7 },
	{ 0xABF8,  0xABF8 },
	{ 0xABF9,  0xABF9 },
	{ 0xABFA,  0xABFA },
	{ 0xABFB,  0xABFB },
	{ 0xABFC,  0xABFC },
	{ 0xABFD,  0xABFD },
	{ 0xABFE,  0xABFE },
	{ 0xAC40,  0xAC40 },
	{ 0xAC41,  0xAC41 },
	{ 0xAC42,  0xAC42 },
	{ 0xAC43,  0xAC43 },
	{ 0xAC44,  0xAC44 },
	{ 0xAC45,  0xAC45 },
	{ 0xAC46,  0xAC46 },
	{ 0xAC47,  0xAC47 },
	{ 0xAC48,  0xAC48 },
	{ 0xAC49,  0xAC49 },
	{ 0xAC4A,  0xAC4A },
	{ 0xAC4B,  0xAC4B },
	{ 0xAC4C,  0xAC4C },
	{ 0xAC4D,  0xAC4D },
	{ 0xAC4E,  0xAC4E },
	{ 0xAC4F,  0xAC4F },
	{ 0xAC50,  0xAC50 },
	{ 0xAC51,  0xAC51 },
	{ 0xAC52,  0xAC52 },
	{ 0xAC53,  0xAC53 },
	{ 0xAC54,  0xAC54 },
	{ 0xAC55,  0xAC55 },
	{ 0xAC56,  0xAC56 },
	{ 0xAC57,  0xAC57 },
	{ 0xAC58,  0xAC58 },
	{ 0xAC59,  0xAC59 },
	{ 0xAC5A,  0xAC5A },
	{ 0xAC5B,  0xAC5B },
	{ 0xAC5C,  0xAC5C },
	{ 0xAC5D,  0xAC5D },
	{ 0xAC5E,  0xAC5E },
	{ 0xAC5F,  0xAC5F },
	{ 0xAC60,  0xAC60 },
	{ 0xAC61,  0xAC61 },
	{ 0xAC62,  0xAC62 },
	{ 0xAC63,  0xAC63 },
	{ 0xAC64,  0xAC64 },
	{ 0xAC65,  0xAC65 },
	{ 0xAC66,  0xAC66 },
	{ 0xAC67,  0xAC67 },
	{ 0xAC68,  0xAC68 },
	{ 0xAC69,  0xAC69 },
	{ 0xAC6A,  0xAC6A },
	{ 0xAC6B,  0xAC6B },
	{ 0xAC6C,  0xAC6C },
	{ 0xAC6D,  0xAC6D },
	{ 0xAC6E,  0xAC6E },
	{ 0xAC6F,  0xAC6F },
	{ 0xAC70,  0xAC70 },
	{ 0xAC71,  0xAC71 },
	{ 0xAC72,  0xAC72 },
	{ 0xAC73,  0xAC73 },
	{ 0xAC74,  0xAC74 },
	{ 0xAC75,  0xAC75 },
	{ 0xAC76,  0xAC76 },
	{ 0xAC77,  0xAC77 },
	{ 0xAC78,  0xAC78 },
	{ 0xAC79,  0xAC79 },
	{ 0xAC7A,  0xAC7A },
	{ 0xAC7B,  0xAC7B },
	{ 0xAC7C,  0xAC7C },
	{ 0xAC7D,  0xAC7D },
	{ 0xAC7E,  0xAC7E },
	{ 0xACA1,  0xACA1 },
	{ 0xACA2,  0xACA2 },
	{ 0xACA3,  0xACA3 },
	{ 0xACA4,  0xACA4 },
	{ 0xACA5,  0xACA5 },
	{ 0xACA6,  0xACA6 },
	{ 0xACA7,  0xACA7 },
	{ 0xACA8,  0xACA8 },
	{ 0xACA9,  0xACA9 },
	{ 0xACAA,  0xACAA },
	{ 0xACAB,  0xACAB },
	{ 0xACAC,  0xACAC },
	{ 0xACAD,  0xACAD },
	{ 0xACAE,  0xACAE },
	{ 0xACAF,  0xACAF },
	{ 0xACB0,  0xACB0 },
	{ 0xACB1,  0xACB1 },
	{ 0xACB2,  0xACB2 },
	{ 0xACB3,  0xACB3 },
	{ 0xACB4,  0xACB4 },
	{ 0xACB5,  0xACB5 },
	{ 0xACB6,  0xACB6 },
	{ 0xACB7,  0xACB7 },
	{ 0xACB8,  0xACB8 },
	{ 0xACB9,  0xACB9 },
	{ 0xACBA,  0xACBA },
	{ 0xACBB,  0xACBB },
	{ 0xACBC,  0xACBC },
	{ 0xACBD,  0xACBD },
	{ 0xACBE,  0xACBE },
	{ 0xACBF,  0xACBF },
	{ 0xACC0,  0xACC0 },
	{ 0xACC1,  0xACC1 },
	{ 0xACC2,  0xACC2 },
	{ 0xACC3,  0xACC3 },
	{ 0xACC4,  0xACC4 },
	{ 0xACC5,  0xACC5 },
	{ 0xACC6,  0xACC6 },
	{ 0xACC7,  0xACC7 },
	{ 0xACC8,  0xACC8 },
	{ 0xACC9,  0xACC9 },
	{ 0xACCA,  0xACCA },
	{ 0xACCB,  0xACCB },
	{ 0xACCC,  0xACCC },
	{ 0xACCD,  0xACCD },
	{ 0xACCE,  0xACCE },
	{ 0xACCF,  0xACCF },
	{ 0xACD0,  0xACD0 },
	{ 0xACD1,  0xACD1 },
	{ 0xACD2,  0xACD2 },
	{ 0xACD3,  0xACD3 },
	{ 0xACD4,  0xACD4 },
	{ 0xACD5,  0xACD5 },
	{ 0xACD6,  0xACD6 },
	{ 0xACD7,  0xACD7 },
	{ 0xACD8,  0xACD8 },
	{ 0xACD9,  0xACD9 },
	{ 0xACDA,  0xACDA },
	{ 0xACDB,  0xACDB },
	{ 0xACDC,  0xACDC },
	{ 0xACDD,  0xACDD },
	{ 0xACDE,  0xACDE },
	{ 0xACDF,  0xACDF },
	{ 0xACE0,  0xACE0 },
	{ 0xACE1,  0xACE1 },
	{ 0xACE2,  0xACE2 },
	{ 0xACE3,  0xACE3 },
	{ 0xACE4,  0xACE4 },
	{ 0xACE5,  0xACE5 },
	{ 0xACE6,  0xACE6 },
	{ 0xACE7,  0xACE7 },
	{ 0xACE8,  0xACE8 },
	{ 0xACE9,  0xACE9 },
	{ 0xACEA,  0xACEA },
	{ 0xACEB,  0xACEB },
	{ 0xACEC,  0xACEC },
	{ 0xACED,  0xACED },
	{ 0xACEE,  0xACEE },
	{ 0xACEF,  0xACEF },
	{ 0xACF0,  0xACF0 },
	{ 0xACF1,  0xACF1 },
	{ 0xACF2,  0xACF2 },
	{ 0xACF3,  0xACF3 },
	{ 0xACF4,  0xACF4 },
	{ 0xACF5,  0xACF5 },
	{ 0xACF6,  0xACF6 },
	{ 0xACF7,  0xACF7 },
	{ 0xACF8,  0xACF8 },
	{ 0xACF9,  0xACF9 },
	{ 0xACFA,  0xACFA },
	{ 0xACFB,  0xACFB },
	{ 0xACFC,  0xACFC },
	{ 0xACFD,  0xACFD },
	{ 0xACFE,  0xACFE },
	{ 0xAD40,  0xAD40 },
	{ 0xAD41,  0xAD41 },
	{ 0xAD42,  0xAD42 },
	{ 0xAD43,  0xAD43 },
	{ 0xAD44,  0xAD44 },
	{ 0xAD45,  0xAD45 },
	{ 0xAD46,  0xAD46 },
	{ 0xAD47,  0xAD47 },
	{ 0xAD48,  0xAD48 },
	{ 0xAD49,  0xAD49 },
	{ 0xAD4A,  0xAD4A },
	{ 0xAD4B,  0xAD4B },
	{ 0xAD4C,  0xAD4C },
	{ 0xAD4D,  0xAD4D },
	{ 0xAD4E,  0xAD4E },
	{ 0xAD4F,  0xAD4F },
	{ 0xAD50,  0xAD50 },
	{ 0xAD51,  0xAD51 },
	{ 0xAD52,  0xAD52 },
	{ 0xAD53,  0xAD53 },
	{ 0xAD54,  0xAD54 },
	{ 0xAD55,  0xAD55 },
	{ 0xAD56,  0xAD56 },
	{ 0xAD57,  0xAD57 },
	{ 0xAD58,  0xAD58 },
	{ 0xAD59,  0xAD59 },
	{ 0xAD5A,  0xAD5A },
	{ 0xAD5B,  0xAD5B },
	{ 0xAD5C,  0xAD5C },
	{ 0xAD5D,  0xAD5D },
	{ 0xAD5E,  0xAD5E },
	{ 0xAD5F,  0xAD5F },
	{ 0xAD60,  0xAD60 },
	{ 0xAD61,  0xAD61 },
	{ 0xAD62,  0xAD62 },
	{ 0xAD63,  0xAD63 },
	{ 0xAD64,  0xAD64 },
	{ 0xAD65,  0xAD65 },
	{ 0xAD66,  0xAD66 },
	{ 0xAD67,  0xAD67 },
	{ 0xAD68,  0xAD68 },
	{ 0xAD69,  0xAD69 },
	{ 0xAD6A,  0xAD6A },
	{ 0xAD6B,  0xAD6B },
	{ 0xAD6C,  0xAD6C },
	{ 0xAD6D,  0xAD6D },
	{ 0xAD6E,  0xAD6E },
	{ 0xAD6F,  0xAD6F },
	{ 0xAD70,  0xAD70 },
	{ 0xAD71,  0xAD71 },
	{ 0xAD72,  0xAD72 },
	{ 0xAD73,  0xAD73 },
	{ 0xAD74,  0xAD74 },
	{ 0xAD75,  0xAD75 },
	{ 0xAD76,  0xAD76 },
	{ 0xAD77,  0xAD77 },
	{ 0xAD78,  0xAD78 },
	{ 0xAD79,  0xAD79 },
	{ 0xAD7A,  0xAD7A },
	{ 0xAD7B,  0xAD7B },
	{ 0xAD7C,  0xAD7C },
	{ 0xAD7D,  0xAD7D },
	{ 0xAD7E,  0xAD7E },
	{ 0xADA1,  0xADA1 },
	{ 0xADA2,  0xADA2 },
	{ 0xADA3,  0xADA3 },
	{ 0xADA4,  0xADA4 },
	{ 0xADA5,  0xADA5 },
	{ 0xADA6,  0xADA6 },
	{ 0xADA7,  0xADA7 },
	{ 0xADA8,  0xADA8 },
	{ 0xADA9,  0xADA9 },
	{ 0xADAA,  0xADAA },
	{ 0xADAB,  0xADAB },
	{ 0xADAC,  0xADAC },
	{ 0xADAD,  0xADAD },
	{ 0xADAE,  0xADAE },
	{ 0xADAF,  0xADAF },
	{ 0xADB0,  0xADB0 },
	{ 0xADB1,  0xADB1 },
	{ 0xADB2,  0xADB2 },
	{ 0xADB3,  0xADB3 },
	{ 0xADB4,  0xADB4 },
	{ 0xADB5,  0xADB5 },
	{ 0xADB6,  0xADB6 },
	{ 0xADB7,  0xADB7 },
	{ 0xADB8,  0xADB8 },
	{ 0xADB9,  0xADB9 },
	{ 0xADBA,  0xADBA },
	{ 0xADBB,  0xADBB },
	{ 0xADBC,  0xADBC },
	{ 0xADBD,  0xADBD },
	{ 0xADBE,  0xADBE },
	{ 0xADBF,  0xADBF },
	{ 0xADC0,  0xADC0 },
	{ 0xADC1,  0xADC1 },
	{ 0xADC2,  0xADC2 },
	{ 0xADC3,  0xADC3 },
	{ 0xADC4,  0xADC4 },
	{ 0xADC5,  0xADC5 },
	{ 0xADC6,  0xADC6 },
	{ 0xADC7,  0xADC7 },
	{ 0xADC8,  0xADC8 },
	{ 0xADC9,  0xADC9 },
	{ 0xADCA,  0xADCA },
	{ 0xADCB,  0xADCB },
	{ 0xADCC,  0xADCC },
	{ 0xADCD,  0xADCD },
	{ 0xADCE,  0xADCE },
	{ 0xADCF,  0xADCF },
	{ 0xADD0,  0xADD0 },
	{ 0xADD1,  0xADD1 },
	{ 0xADD2,  0xADD2 },
	{ 0xADD3,  0xADD3 },
	{ 0xADD4,  0xADD4 },
	{ 0xADD5,  0xADD5 },
	{ 0xADD6,  0xADD6 },
	{ 0xADD7,  0xADD7 },
	{ 0xADD8,  0xADD8 },
	{ 0xADD9,  0xADD9 },
	{ 0xADDA,  0xADDA },
	{ 0xADDB,  0xADDB },
	{ 0xADDC,  0xADDC },
	{ 0xADDD,  0xADDD },
	{ 0xADDE,  0xADDE },
	{ 0xADDF,  0xADDF },
	{ 0xADE0,  0xADE0 },
	{ 0xADE1,  0xADE1 },
	{ 0xADE2,  0xADE2 },
	{ 0xADE3,  0xADE3 },
	{ 0xADE4,  0xADE4 },
	{ 0xADE5,  0xADE5 },
	{ 0xADE6,  0xADE6 },
	{ 0xADE7,  0xADE7 },
	{ 0xADE8,  0xADE8 },
	{ 0xADE9,  0xADE9 },
	{ 0xADEA,  0xADEA },
	{ 0xADEB,  0xADEB },
	{ 0xADEC,  0xADEC },
	{ 0xADED,  0xADED },
	{ 0xADEE,  0xADEE },
	{ 0xADEF,  0xADEF },
	{ 0xADF0,  0xADF0 },
	{ 0xADF1,  0xADF1 },
	{ 0xADF2,  0xADF2 },
	{ 0xADF3,  0xADF3 },
	{ 0xADF4,  0xADF4 },
	{ 0xADF5,  0xADF5 },
	{ 0xADF6,  0xADF6 },
	{ 0xADF7,  0xADF7 },
	{ 0xADF8,  0xADF8 },
	{ 0xADF9,  0xADF9 },
	{ 0xADFA,  0xADFA },
	{ 0xADFB,  0xADFB },
	{ 0xADFC,  0xADFC },
	{ 0xADFD,  0xADFD },
	{ 0xADFE,  0xADFE },
	{ 0xAE40,  0xAE40 },
	{ 0xAE41,  0xAE41 },
	{ 0xAE42,  0xAE42 },
	{ 0xAE43,  0xAE43 },
	{ 0xAE44,  0xAE44 },
	{ 0xAE45,  0xAE45 },
	{ 0xAE46,  0xAE46 },
	{ 0xAE47,  0xAE47 },
	{ 0xAE48,  0xAE48 },
	{ 0xAE49,  0xAE49 },
	{ 0xAE4A,  0xAE4A },
	{ 0xAE4B,  0xAE4B },
	{ 0xAE4C,  0xAE4C },
	{ 0xAE4D,  0xAE4D },
	{ 0xAE4E,  0xAE4E },
	{ 0xAE4F,  0xAE4F },
	{ 0xAE50,  0xAE50 },
	{ 0xAE51,  0xAE51 },
	{ 0xAE52,  0xAE52 },
	{ 0xAE53,  0xAE53 },
	{ 0xAE54,  0xAE54 },
	{ 0xAE55,  0xAE55 },
	{ 0xAE56,  0xAE56 },
	{ 0xAE57,  0xAE57 },
	{ 0xAE58,  0xAE58 },
	{ 0xAE59,  0xAE59 },
	{ 0xAE5A,  0xAE5A },
	{ 0xAE5B,  0xAE5B },
	{ 0xAE5C,  0xAE5C },
	{ 0xAE5D,  0xAE5D },
	{ 0xAE5E,  0xAE5E },
	{ 0xAE5F,  0xAE5F },
	{ 0xAE60,  0xAE60 },
	{ 0xAE61,  0xAE61 },
	{ 0xAE62,  0xAE62 },
	{ 0xAE63,  0xAE63 },
	{ 0xAE64,  0xAE64 },
	{ 0xAE65,  0xAE65 },
	{ 0xAE66,  0xAE66 },
	{ 0xAE67,  0xAE67 },
	{ 0xAE68,  0xAE68 },
	{ 0xAE69,  0xAE69 },
	{ 0xAE6A,  0xAE6A },
	{ 0xAE6B,  0xAE6B },
	{ 0xAE6C,  0xAE6C },
	{ 0xAE6D,  0xAE6D },
	{ 0xAE6E,  0xAE6E },
	{ 0xAE6F,  0xAE6F },
	{ 0xAE70,  0xAE70 },
	{ 0xAE71,  0xAE71 },
	{ 0xAE72,  0xAE72 },
	{ 0xAE73,  0xAE73 },
	{ 0xAE74,  0xAE74 },
	{ 0xAE75,  0xAE75 },
	{ 0xAE76,  0xAE76 },
	{ 0xAE77,  0xAE77 },
	{ 0xAE78,  0xAE78 },
	{ 0xAE79,  0xAE79 },
	{ 0xAE7A,  0xAE7A },
	{ 0xAE7B,  0xAE7B },
	{ 0xAE7C,  0xAE7C },
	{ 0xAE7D,  0xAE7D },
	{ 0xAE7E,  0xAE7E },
	{ 0xAEA1,  0xAEA1 },
	{ 0xAEA2,  0xAEA2 },
	{ 0xAEA3,  0xAEA3 },
	{ 0xAEA4,  0xAEA4 },
	{ 0xAEA5,  0xAEA5 },
	{ 0xAEA6,  0xAEA6 },
	{ 0xAEA7,  0xAEA7 },
	{ 0xAEA8,  0xAEA8 },
	{ 0xAEA9,  0xAEA9 },
	{ 0xAEAA,  0xAEAA },
	{ 0xAEAB,  0xAEAB },
	{ 0xAEAC,  0xAEAC },
	{ 0xAEAD,  0xAEAD },
	{ 0xAEAE,  0xAEAE },
	{ 0xAEAF,  0xAEAF },
	{ 0xAEB0,  0xAEB0 },
	{ 0xAEB1,  0xAEB1 },
	{ 0xAEB2,  0xAEB2 },
	{ 0xAEB3,  0xAEB3 },
	{ 0xAEB4,  0xAEB4 },
	{ 0xAEB5,  0xAEB5 },
	{ 0xAEB6,  0xAEB6 },
	{ 0xAEB7,  0xAEB7 },
	{ 0xAEB8,  0xAEB8 },
	{ 0xAEB9,  0xAEB9 },
	{ 0xAEBA,  0xAEBA },
	{ 0xAEBB,  0xAEBB },
	{ 0xAEBC,  0xAEBC },
	{ 0xAEBD,  0xAEBD },
	{ 0xAEBE,  0xAEBE },
	{ 0xAEBF,  0xAEBF },
	{ 0xAEC0,  0xAEC0 },
	{ 0xAEC1,  0xAEC1 },
	{ 0xAEC2,  0xAEC2 },
	{ 0xAEC3,  0xAEC3 },
	{ 0xAEC4,  0xAEC4 },
	{ 0xAEC5,  0xAEC5 },
	{ 0xAEC6,  0xAEC6 },
	{ 0xAEC7,  0xAEC7 },
	{ 0xAEC8,  0xAEC8 },
	{ 0xAEC9,  0xAEC9 },
	{ 0xAECA,  0xAECA },
	{ 0xAECB,  0xAECB },
	{ 0xAECC,  0xAECC },
	{ 0xAECD,  0xAECD },
	{ 0xAECE,  0xAECE },
	{ 0xAECF,  0xAECF },
	{ 0xAED0,  0xAED0 },
	{ 0xAED1,  0xAED1 },
	{ 0xAED2,  0xAED2 },
	{ 0xAED3,  0xAED3 },
	{ 0xAED4,  0xAED4 },
	{ 0xAED5,  0xAED5 },
	{ 0xAED6,  0xAED6 },
	{ 0xAED7,  0xAED7 },
	{ 0xAED8,  0xAED8 },
	{ 0xAED9,  0xAED9 },
	{ 0xAEDA,  0xAEDA },
	{ 0xAEDB,  0xAEDB },
	{ 0xAEDC,  0xAEDC },
	{ 0xAEDD,  0xAEDD },
	{ 0xAEDE,  0xAEDE },
	{ 0xAEDF,  0xAEDF },
	{ 0xAEE0,  0xAEE0 },
	{ 0xAEE1,  0xAEE1 },
	{ 0xAEE2,  0xAEE2 },
	{ 0xAEE3,  0xAEE3 },
	{ 0xAEE4,  0xAEE4 },
	{ 0xAEE5,  0xAEE5 },
	{ 0xAEE6,  0xAEE6 },
	{ 0xAEE7,  0xAEE7 },
	{ 0xAEE8,  0xAEE8 },
	{ 0xAEE9,  0xAEE9 },
	{ 0xAEEA,  0xAEEA },
	{ 0xAEEB,  0xAEEB },
	{ 0xAEEC,  0xAEEC },
	{ 0xAEED,  0xAEED },
	{ 0xAEEE,  0xAEEE },
	{ 0xAEEF,  0xAEEF },
	{ 0xAEF0,  0xAEF0 },
	{ 0xAEF1,  0xAEF1 },
	{ 0xAEF2,  0xAEF2 },
	{ 0xAEF3,  0xAEF3 },
	{ 0xAEF4,  0xAEF4 },
	{ 0xAEF5,  0xAEF5 },
	{ 0xAEF6,  0xAEF6 },
	{ 0xAEF7,  0xAEF7 },
	{ 0xAEF8,  0xAEF8 },
	{ 0xAEF9,  0xAEF9 },
	{ 0xAEFA,  0xAEFA },
	{ 0xAEFB,  0xAEFB },
	{ 0xAEFC,  0xAEFC },
	{ 0xAEFD,  0xAEFD },
	{ 0xAEFE,  0xAEFE },
	{ 0xAF40,  0xAF40 },
	{ 0xAF41,  0xAF41 },
	{ 0xAF42,  0xAF42 },
	{ 0xAF43,  0xAF43 },
	{ 0xAF44,  0xAF44 },
	{ 0xAF45,  0xAF45 },
	{ 0xAF46,  0xAF46 },
	{ 0xAF47,  0xAF47 },
	{ 0xAF48,  0xAF48 },
	{ 0xAF49,  0xAF49 },
	{ 0xAF4A,  0xAF4A },
	{ 0xAF4B,  0xAF4B },
	{ 0xAF4C,  0xAF4C },
	{ 0xAF4D,  0xAF4D },
	{ 0xAF4E,  0xAF4E },
	{ 0xAF4F,  0xAF4F },
	{ 0xAF50,  0xAF50 },
	{ 0xAF51,  0xAF51 },
	{ 0xAF52,  0xAF52 },
	{ 0xAF53,  0xAF53 },
	{ 0xAF54,  0xAF54 },
	{ 0xAF55,  0xAF55 },
	{ 0xAF56,  0xAF56 },
	{ 0xAF57,  0xAF57 },
	{ 0xAF58,  0xAF58 },
	{ 0xAF59,  0xAF59 },
	{ 0xAF5A,  0xAF5A },
	{ 0xAF5B,  0xAF5B },
	{ 0xAF5C,  0xAF5C },
	{ 0xAF5D,  0xAF5D },
	{ 0xAF5E,  0xAF5E },
	{ 0xAF5F,  0xAF5F },
	{ 0xAF60,  0xAF60 },
	{ 0xAF61,  0xAF61 },
	{ 0xAF62,  0xAF62 },
	{ 0xAF63,  0xAF63 },
	{ 0xAF64,  0xAF64 },
	{ 0xAF65,  0xAF65 },
	{ 0xAF66,  0xAF66 },
	{ 0xAF67,  0xAF67 },
	{ 0xAF68,  0xAF68 },
	{ 0xAF69,  0xAF69 },
	{ 0xAF6A,  0xAF6A },
	{ 0xAF6B,  0xAF6B },
	{ 0xAF6C,  0xAF6C },
	{ 0xAF6D,  0xAF6D },
	{ 0xAF6E,  0xAF6E },
	{ 0xAF6F,  0xAF6F },
	{ 0xAF70,  0xAF70 },
	{ 0xAF71,  0xAF71 },
	{ 0xAF72,  0xAF72 },
	{ 0xAF73,  0xAF73 },
	{ 0xAF74,  0xAF74 },
	{ 0xAF75,  0xAF75 },
	{ 0xAF76,  0xAF76 },
	{ 0xAF77,  0xAF77 },
	{ 0xAF78,  0xAF78 },
	{ 0xAF79,  0xAF79 },
	{ 0xAF7A,  0xAF7A },
	{ 0xAF7B,  0xAF7B },
	{ 0xAF7C,  0xAF7C },
	{ 0xAF7D,  0xAF7D },
	{ 0xAF7E,  0xAF7E },
	{ 0xAFA1,  0xAFA1 },
	{ 0xAFA2,  0xAFA2 },
	{ 0xAFA3,  0xAFA3 },
	{ 0xAFA4,  0xAFA4 },
	{ 0xAFA5,  0xAFA5 },
	{ 0xAFA6,  0xAFA6 },
	{ 0xAFA7,  0xAFA7 },
	{ 0xAFA8,  0xAFA8 },
	{ 0xAFA9,  0xAFA9 },
	{ 0xAFAA,  0xAFAA },
	{ 0xAFAB,  0xAFAB },
	{ 0xAFAC,  0xAFAC },
	{ 0xAFAD,  0xAFAD },
	{ 0xAFAE,  0xAFAE },
	{ 0xAFAF,  0xAFAF },
	{ 0xAFB0,  0xAFB0 },
	{ 0xAFB1,  0xAFB1 },
	{ 0xAFB2,  0xAFB2 },
	{ 0xAFB3,  0xAFB3 },
	{ 0xAFB4,  0xAFB4 },
	{ 0xAFB5,  0xAFB5 },
	{ 0xAFB6,  0xAFB6 },
	{ 0xAFB7,  0xAFB7 },
	{ 0xAFB8,  0xAFB8 },
	{ 0xAFB9,  0xAFB9 },
	{ 0xAFBA,  0xAFBA },
	{ 0xAFBB,  0xAFBB },
	{ 0xAFBC,  0xAFBC },
	{ 0xAFBD,  0xAFBD },
	{ 0xAFBE,  0xAFBE },
	{ 0xAFBF,  0xAFBF },
	{ 0xAFC0,  0xAFC0 },
	{ 0xAFC1,  0xAFC1 },
	{ 0xAFC2,  0xAFC2 },
	{ 0xAFC3,  0xAFC3 },
	{ 0xAFC4,  0xAFC4 },
	{ 0xAFC5,  0xAFC5 },
	{ 0xAFC6,  0xAFC6 },
	{ 0xAFC7,  0xAFC7 },
	{ 0xAFC8,  0xAFC8 },
	{ 0xAFC9,  0xAFC9 },
	{ 0xAFCA,  0xAFCA },
	{ 0xAFCB,  0xAFCB },
	{ 0xAFCC,  0xAFCC },
	{ 0xAFCD,  0xAFCD },
	{ 0xAFCE,  0xAFCE },
	{ 0xAFCF,  0xAFCF },
	{ 0xAFD0,  0xAFD0 },
	{ 0xAFD1,  0xAFD1 },
	{ 0xAFD2,  0xAFD2 },
	{ 0xAFD3,  0xAFD3 },
	{ 0xAFD4,  0xAFD4 },
	{ 0xAFD5,  0xAFD5 },
	{ 0xAFD6,  0xAFD6 },
	{ 0xAFD7,  0xAFD7 },
	{ 0xAFD8,  0xAFD8 },
	{ 0xAFD9,  0xAFD9 },
	{ 0xAFDA,  0xAFDA },
	{ 0xAFDB,  0xAFDB },
	{ 0xAFDC,  0xAFDC },
	{ 0xAFDD,  0xAFDD },
	{ 0xAFDE,  0xAFDE },
	{ 0xAFDF,  0xAFDF },
	{ 0xAFE0,  0xAFE0 },
	{ 0xAFE1,  0xAFE1 },
	{ 0xAFE2,  0xAFE2 },
	{ 0xAFE3,  0xAFE3 },
	{ 0xAFE4,  0xAFE4 },
	{ 0xAFE5,  0xAFE5 },
	{ 0xAFE6,  0xAFE6 },
	{ 0xAFE7,  0xAFE7 },
	{ 0xAFE8,  0xAFE8 },
	{ 0xAFE9,  0xAFE9 },
	{ 0xAFEA,  0xAFEA },
	{ 0xAFEB,  0xAFEB },
	{ 0xAFEC,  0xAFEC },
	{ 0xAFED,  0xAFED },
	{ 0xAFEE,  0xAFEE },
	{ 0xAFEF,  0xAFEF },
	{ 0xAFF0,  0xAFF0 },
	{ 0xAFF1,  0xAFF1 },
	{ 0xAFF2,  0xAFF2 },
	{ 0xAFF3,  0xAFF3 },
	{ 0xAFF4,  0xAFF4 },
	{ 0xAFF5,  0xAFF5 },
	{ 0xAFF6,  0xAFF6 },
	{ 0xAFF7,  0xAFF7 },
	{ 0xAFF8,  0xAFF8 },
	{ 0xAFF9,  0xAFF9 },
	{ 0xAFFA,  0xAFFA },
	{ 0xAFFB,  0xAFFB },
	{ 0xAFFC,  0xAFFC },
	{ 0xAFFD,  0xAFFD },
	{ 0xAFFE,  0xAFFE },
	{ 0xB040,  0xB040 },
	{ 0xB041,  0xB041 },
	{ 0xB042,  0xB042 },
	{ 0xB043,  0xB043 },
	{ 0xB044,  0xB044 },
	{ 0xB045,  0xB045 },
	{ 0xB046,  0xB046 },
	{ 0xB047,  0xB047 },
	{ 0xB048,  0xB048 },
	{ 0xB049,  0xB049 },
	{ 0xB04A,  0xB04A },
	{ 0xB04B,  0xB04B },
	{ 0xB04C,  0xB04C },
	{ 0xB04D,  0xB04D },
	{ 0xB04E,  0xB04E },
	{ 0xB04F,  0xB04F },
	{ 0xB050,  0xB050 },
	{ 0xB051,  0xB051 },
	{ 0xB052,  0xB052 },
	{ 0xB053,  0xB053 },
	{ 0xB054,  0xB054 },
	{ 0xB055,  0xB055 },
	{ 0xB056,  0xB056 },
	{ 0xB057,  0xB057 },
	{ 0xB058,  0xB058 },
	{ 0xB059,  0xB059 },
	{ 0xB05A,  0xB05A },
	{ 0xB05B,  0xB05B },
	{ 0xB05C,  0xB05C },
	{ 0xB05D,  0xB05D },
	{ 0xB05E,  0xB05E },
	{ 0xB05F,  0xB05F },
	{ 0xB060,  0xB060 },
	{ 0xB061,  0xB061 },
	{ 0xB062,  0xB062 },
	{ 0xB063,  0xB063 },
	{ 0xB064,  0xB064 },
	{ 0xB065,  0xB065 },
	{ 0xB066,  0xB066 },
	{ 0xB067,  0xB067 },
	{ 0xB068,  0xB068 },
	{ 0xB069,  0xB069 },
	{ 0xB06A,  0xB06A },
	{ 0xB06B,  0xB06B },
	{ 0xB06C,  0xB06C },
	{ 0xB06D,  0xB06D },
	{ 0xB06E,  0xB06E },
	{ 0xB06F,  0xB06F },
	{ 0xB070,  0xB070 },
	{ 0xB071,  0xB071 },
	{ 0xB072,  0xB072 },
	{ 0xB073,  0xB073 },
	{ 0xB074,  0xB074 },
	{ 0xB075,  0xB075 },
	{ 0xB076,  0xB076 },
	{ 0xB077,  0xB077 },
	{ 0xB078,  0xB078 },
	{ 0xB079,  0xB079 },
	{ 0xB07A,  0xB07A },
	{ 0xB07B,  0xB07B },
	{ 0xB07C,  0xB07C },
	{ 0xB07D,  0xB07D },
	{ 0xB07E,  0xB07E },
	{ 0xB0A1,  0xB0A1 },
	{ 0xB0A2,  0xB0A2 },
	{ 0xB0A3,  0xB0A3 },
	{ 0xB0A4,  0xB0A4 },
	{ 0xB0A5,  0xB0A5 },
	{ 0xB0A6,  0xB0A6 },
	{ 0xB0A7,  0xB0A7 },
	{ 0xB0A8,  0xB0A8 },
	{ 0xB0A9,  0xB0A9 },
	{ 0xB0AA,  0xB0AA },
	{ 0xB0AB,  0xB0AB },
	{ 0xB0AC,  0xB0AC },
	{ 0xB0AD,  0xB0AD },
	{ 0xB0AE,  0xB0AE },
	{ 0xB0AF,  0xB0AF },
	{ 0xB0B0,  0xB0B0 },
	{ 0xB0B1,  0xB0B1 },
	{ 0xB0B2,  0xB0B2 },
	{ 0xB0B3,  0xB0B3 },
	{ 0xB0B4,  0xB0B4 },
	{ 0xB0B5,  0xB0B5 },
	{ 0xB0B6,  0xB0B6 },
	{ 0xB0B7,  0xB0B7 },
	{ 0xB0B8,  0xB0B8 },
	{ 0xB0B9,  0xB0B9 },
	{ 0xB0BA,  0xB0BA },
	{ 0xB0BB,  0xB0BB },
	{ 0xB0BC,  0xB0BC },
	{ 0xB0BD,  0xB0BD },
	{ 0xB0BE,  0xB0BE },
	{ 0xB0BF,  0xB0BF },
	{ 0xB0C0,  0xB0C0 },
	{ 0xB0C1,  0xB0C1 },
	{ 0xB0C2,  0xB0C2 },
	{ 0xB0C3,  0xB0C3 },
	{ 0xB0C4,  0xB0C4 },
	{ 0xB0C5,  0xB0C5 },
	{ 0xB0C6,  0xB0C6 },
	{ 0xB0C7,  0xB0C7 },
	{ 0xB0C8,  0xB0C8 },
	{ 0xB0C9,  0xB0C9 },
	{ 0xB0CA,  0xB0CA },
	{ 0xB0CB,  0xB0CB },
	{ 0xB0CC,  0xB0CC },
	{ 0xB0CD,  0xB0CD },
	{ 0xB0CE,  0xB0CE },
	{ 0xB0CF,  0xB0CF },
	{ 0xB0D0,  0xB0D0 },
	{ 0xB0D1,  0xB0D1 },
	{ 0xB0D2,  0xB0D2 },
	{ 0xB0D3,  0xB0D3 },
	{ 0xB0D4,  0xB0D4 },
	{ 0xB0D5,  0xB0D5 },
	{ 0xB0D6,  0xB0D6 },
	{ 0xB0D7,  0xB0D7 },
	{ 0xB0D8,  0xB0D8 },
	{ 0xB0D9,  0xB0D9 },
	{ 0xB0DA,  0xB0DA },
	{ 0xB0DB,  0xB0DB },
	{ 0xB0DC,  0xB0DC },
	{ 0xB0DD,  0xB0DD },
	{ 0xB0DE,  0xB0DE },
	{ 0xB0DF,  0xB0DF },
	{ 0xB0E0,  0xB0E0 },
	{ 0xB0E1,  0xB0E1 },
	{ 0xB0E2,  0xB0E2 },
	{ 0xB0E3,  0xB0E3 },
	{ 0xB0E4,  0xB0E4 },
	{ 0xB0E5,  0xB0E5 },
	{ 0xB0E6,  0xB0E6 },
	{ 0xB0E7,  0xB0E7 },
	{ 0xB0E8,  0xB0E8 },
	{ 0xB0E9,  0xB0E9 },
	{ 0xB0EA,  0xB0EA },
	{ 0xB0EB,  0xB0EB },
	{ 0xB0EC,  0xB0EC },
	{ 0xB0ED,  0xB0ED },
	{ 0xB0EE,  0xB0EE },
	{ 0xB0EF,  0xB0EF },
	{ 0xB0F0,  0xB0F0 },
	{ 0xB0F1,  0xB0F1 },
	{ 0xB0F2,  0xB0F2 },
	{ 0xB0F3,  0xB0F3 },
	{ 0xB0F4,  0xB0F4 },
	{ 0xB0F5,  0xB0F5 },
	{ 0xB0F6,  0xB0F6 },
	{ 0xB0F7,  0xB0F7 },
	{ 0xB0F8,  0xB0F8 },
	{ 0xB0F9,  0xB0F9 },
	{ 0xB0FA,  0xB0FA },
	{ 0xB0FB,  0xB0FB },
	{ 0xB0FC,  0xB0FC },
	{ 0xB0FD,  0xB0FD },
	{ 0xB0FE,  0xB0FE },
	{ 0xB140,  0xB140 },
	{ 0xB141,  0xB141 },
	{ 0xB142,  0xB142 },
	{ 0xB143,  0xB143 },
	{ 0xB144,  0xB144 },
	{ 0xB145,  0xB145 },
	{ 0xB146,  0xB146 },
	{ 0xB147,  0xB147 },
	{ 0xB148,  0xB148 },
	{ 0xB149,  0xB149 },
	{ 0xB14A,  0xB14A },
	{ 0xB14B,  0xB14B },
	{ 0xB14C,  0xB14C },
	{ 0xB14D,  0xB14D },
	{ 0xB14E,  0xB14E },
	{ 0xB14F,  0xB14F },
	{ 0xB150,  0xB150 },
	{ 0xB151,  0xB151 },
	{ 0xB152,  0xB152 },
	{ 0xB153,  0xB153 },
	{ 0xB154,  0xB154 },
	{ 0xB155,  0xB155 },
	{ 0xB156,  0xB156 },
	{ 0xB157,  0xB157 },
	{ 0xB158,  0xB158 },
	{ 0xB159,  0xB159 },
	{ 0xB15A,  0xB15A },
	{ 0xB15B,  0xB15B },
	{ 0xB15C,  0xB15C },
	{ 0xB15D,  0xB15D },
	{ 0xB15E,  0xB15E },
	{ 0xB15F,  0xB15F },
	{ 0xB160,  0xB160 },
	{ 0xB161,  0xB161 },
	{ 0xB162,  0xB162 },
	{ 0xB163,  0xB163 },
	{ 0xB164,  0xB164 },
	{ 0xB165,  0xB165 },
	{ 0xB166,  0xB166 },
	{ 0xB167,  0xB167 },
	{ 0xB168,  0xB168 },
	{ 0xB169,  0xB169 },
	{ 0xB16A,  0xB16A },
	{ 0xB16B,  0xB16B },
	{ 0xB16C,  0xB16C },
	{ 0xB16D,  0xB16D },
	{ 0xB16E,  0xB16E },
	{ 0xB16F,  0xB16F },
	{ 0xB170,  0xB170 },
	{ 0xB171,  0xB171 },
	{ 0xB172,  0xB172 },
	{ 0xB173,  0xB173 },
	{ 0xB174,  0xB174 },
	{ 0xB175,  0xB175 },
	{ 0xB176,  0xB176 },
	{ 0xB177,  0xB177 },
	{ 0xB178,  0xB178 },
	{ 0xB179,  0xB179 },
	{ 0xB17A,  0xB17A },
	{ 0xB17B,  0xB17B },
	{ 0xB17C,  0xB17C },
	{ 0xB17D,  0xB17D },
	{ 0xB17E,  0xB17E },
	{ 0xB1A1,  0xB1A1 },
	{ 0xB1A2,  0xB1A2 },
	{ 0xB1A3,  0xB1A3 },
	{ 0xB1A4,  0xB1A4 },
	{ 0xB1A5,  0xB1A5 },
	{ 0xB1A6,  0xB1A6 },
	{ 0xB1A7,  0xB1A7 },
	{ 0xB1A8,  0xB1A8 },
	{ 0xB1A9,  0xB1A9 },
	{ 0xB1AA,  0xB1AA },
	{ 0xB1AB,  0xB1AB },
	{ 0xB1AC,  0xB1AC },
	{ 0xB1AD,  0xB1AD },
	{ 0xB1AE,  0xB1AE },
	{ 0xB1AF,  0xB1AF },
	{ 0xB1B0,  0xB1B0 },
	{ 0xB1B1,  0xB1B1 },
	{ 0xB1B2,  0xB1B2 },
	{ 0xB1B3,  0xB1B3 },
	{ 0xB1B4,  0xB1B4 },
	{ 0xB1B5,  0xB1B5 },
	{ 0xB1B6,  0xB1B6 },
	{ 0xB1B7,  0xB1B7 },
	{ 0xB1B8,  0xB1B8 },
	{ 0xB1B9,  0xB1B9 },
	{ 0xB1BA,  0xB1BA },
	{ 0xB1BB,  0xB1BB },
	{ 0xB1BC,  0xB1BC },
	{ 0xB1BD,  0xB1BD },
	{ 0xB1BE,  0xB1BE },
	{ 0xB1BF,  0xB1BF },
	{ 0xB1C0,  0xB1C0 },
	{ 0xB1C1,  0xB1C1 },
	{ 0xB1C2,  0xB1C2 },
	{ 0xB1C3,  0xB1C3 },
	{ 0xB1C4,  0xB1C4 },
	{ 0xB1C5,  0xB1C5 },
	{ 0xB1C6,  0xB1C6 },
	{ 0xB1C7,  0xB1C7 },
	{ 0xB1C8,  0xB1C8 },
	{ 0xB1C9,  0xB1C9 },
	{ 0xB1CA,  0xB1CA },
	{ 0xB1CB,  0xB1CB },
	{ 0xB1CC,  0xB1CC },
	{ 0xB1CD,  0xB1CD },
	{ 0xB1CE,  0xB1CE },
	{ 0xB1CF,  0xB1CF },
	{ 0xB1D0,  0xB1D0 },
	{ 0xB1D1,  0xB1D1 },
	{ 0xB1D2,  0xB1D2 },
	{ 0xB1D3,  0xB1D3 },
	{ 0xB1D4,  0xB1D4 },
	{ 0xB1D5,  0xB1D5 },
	{ 0xB1D6,  0xB1D6 },
	{ 0xB1D7,  0xB1D7 },
	{ 0xB1D8,  0xB1D8 },
	{ 0xB1D9,  0xB1D9 },
	{ 0xB1DA,  0xB1DA },
	{ 0xB1DB,  0xB1DB },
	{ 0xB1DC,  0xB1DC },
	{ 0xB1DD,  0xB1DD },
	{ 0xB1DE,  0xB1DE },
	{ 0xB1DF,  0xB1DF },
	{ 0xB1E0,  0xB1E0 },
	{ 0xB1E1,  0xB1E1 },
	{ 0xB1E2,  0xB1E2 },
	{ 0xB1E3,  0xB1E3 },
	{ 0xB1E4,  0xB1E4 },
	{ 0xB1E5,  0xB1E5 },
	{ 0xB1E6,  0xB1E6 },
	{ 0xB1E7,  0xB1E7 },
	{ 0xB1E8,  0xB1E8 },
	{ 0xB1E9,  0xB1E9 },
	{ 0xB1EA,  0xB1EA },
	{ 0xB1EB,  0xB1EB },
	{ 0xB1EC,  0xB1EC },
	{ 0xB1ED,  0xB1ED },
	{ 0xB1EE,  0xB1EE },
	{ 0xB1EF,  0xB1EF },
	{ 0xB1F0,  0xB1F0 },
	{ 0xB1F1,  0xB1F1 },
	{ 0xB1F2,  0xB1F2 },
	{ 0xB1F3,  0xB1F3 },
	{ 0xB1F4,  0xB1F4 },
	{ 0xB1F5,  0xB1F5 },
	{ 0xB1F6,  0xB1F6 },
	{ 0xB1F7,  0xB1F7 },
	{ 0xB1F8,  0xB1F8 },
	{ 0xB1F9,  0xB1F9 },
	{ 0xB1FA,  0xB1FA },
	{ 0xB1FB,  0xB1FB },
	{ 0xB1FC,  0xB1FC },
	{ 0xB1FD,  0xB1FD },
	{ 0xB1FE,  0xB1FE },
	{ 0xB240,  0xB240 },
	{ 0xB241,  0xB241 },
	{ 0xB242,  0xB242 },
	{ 0xB243,  0xB243 },
	{ 0xB244,  0xB244 },
	{ 0xB245,  0xB245 },
	{ 0xB246,  0xB246 },
	{ 0xB247,  0xB247 },
	{ 0xB248,  0xB248 },
	{ 0xB249,  0xB249 },
	{ 0xB24A,  0xB24A },
	{ 0xB24B,  0xB24B },
	{ 0xB24C,  0xB24C },
	{ 0xB24D,  0xB24D },
	{ 0xB24E,  0xB24E },
	{ 0xB24F,  0xB24F },
	{ 0xB250,  0xB250 },
	{ 0xB251,  0xB251 },
	{ 0xB252,  0xB252 },
	{ 0xB253,  0xB253 },
	{ 0xB254,  0xB254 },
	{ 0xB255,  0xB255 },
	{ 0xB256,  0xB256 },
	{ 0xB257,  0xB257 },
	{ 0xB258,  0xB258 },
	{ 0xB259,  0xB259 },
	{ 0xB25A,  0xB25A },
	{ 0xB25B,  0xB25B },
	{ 0xB25C,  0xB25C },
	{ 0xB25D,  0xB25D },
	{ 0xB25E,  0xB25E },
	{ 0xB25F,  0xB25F },
	{ 0xB260,  0xB260 },
	{ 0xB261,  0xB261 },
	{ 0xB262,  0xB262 },
	{ 0xB263,  0xB263 },
	{ 0xB264,  0xB264 },
	{ 0xB265,  0xB265 },
	{ 0xB266,  0xB266 },
	{ 0xB267,  0xB267 },
	{ 0xB268,  0xB268 },
	{ 0xB269,  0xB269 },
	{ 0xB26A,  0xB26A },
	{ 0xB26B,  0xB26B },
	{ 0xB26C,  0xB26C },
	{ 0xB26D,  0xB26D },
	{ 0xB26E,  0xB26E },
	{ 0xB26F,  0xB26F },
	{ 0xB270,  0xB270 },
	{ 0xB271,  0xB271 },
	{ 0xB272,  0xB272 },
	{ 0xB273,  0xB273 },
	{ 0xB274,  0xB274 },
	{ 0xB275,  0xB275 },
	{ 0xB276,  0xB276 },
	{ 0xB277,  0xB277 },
	{ 0xB278,  0xB278 },
	{ 0xB279,  0xB279 },
	{ 0xB27A,  0xB27A },
	{ 0xB27B,  0xB27B },
	{ 0xB27C,  0xB27C },
	{ 0xB27D,  0xB27D },
	{ 0xB27E,  0xB27E },
	{ 0xB2A1,  0xB2A1 },
	{ 0xB2A2,  0xB2A2 },
	{ 0xB2A3,  0xB2A3 },
	{ 0xB2A4,  0xB2A4 },
	{ 0xB2A5,  0xB2A5 },
	{ 0xB2A6,  0xB2A6 },
	{ 0xB2A7,  0xB2A7 },
	{ 0xB2A8,  0xB2A8 },
	{ 0xB2A9,  0xB2A9 },
	{ 0xB2AA,  0xB2AA },
	{ 0xB2AB,  0xB2AB },
	{ 0xB2AC,  0xB2AC },
	{ 0xB2AD,  0xB2AD },
	{ 0xB2AE,  0xB2AE },
	{ 0xB2AF,  0xB2AF },
	{ 0xB2B0,  0xB2B0 },
	{ 0xB2B1,  0xB2B1 },
	{ 0xB2B2,  0xB2B2 },
	{ 0xB2B3,  0xB2B3 },
	{ 0xB2B4,  0xB2B4 },
	{ 0xB2B5,  0xB2B5 },
	{ 0xB2B6,  0xB2B6 },
	{ 0xB2B7,  0xB2B7 },
	{ 0xB2B8,  0xB2B8 },
	{ 0xB2B9,  0xB2B9 },
	{ 0xB2BA,  0xB2BA },
	{ 0xB2BB,  0xB2BB },
	{ 0xB2BC,  0xB2BC },
	{ 0xB2BD,  0xB2BD },
	{ 0xB2BE,  0xB2BE },
	{ 0xB2BF,  0xB2BF },
	{ 0xB2C0,  0xB2C0 },
	{ 0xB2C1,  0xB2C1 },
	{ 0xB2C2,  0xB2C2 },
	{ 0xB2C3,  0xB2C3 },
	{ 0xB2C4,  0xB2C4 },
	{ 0xB2C5,  0xB2C5 },
	{ 0xB2C6,  0xB2C6 },
	{ 0xB2C7,  0xB2C7 },
	{ 0xB2C8,  0xB2C8 },
	{ 0xB2C9,  0xB2C9 },
	{ 0xB2CA,  0xB2CA },
	{ 0xB2CB,  0xB2CB },
	{ 0xB2CC,  0xB2CC },
	{ 0xB2CD,  0xB2CD },
	{ 0xB2CE,  0xB2CE },
	{ 0xB2CF,  0xB2CF },
	{ 0xB2D0,  0xB2D0 },
	{ 0xB2D1,  0xB2D1 },
	{ 0xB2D2,  0xB2D2 },
	{ 0xB2D3,  0xB2D3 },
	{ 0xB2D4,  0xB2D4 },
	{ 0xB2D5,  0xB2D5 },
	{ 0xB2D6,  0xB2D6 },
	{ 0xB2D7,  0xB2D7 },
	{ 0xB2D8,  0xB2D8 },
	{ 0xB2D9,  0xB2D9 },
	{ 0xB2DA,  0xB2DA },
	{ 0xB2DB,  0xB2DB },
	{ 0xB2DC,  0xB2DC },
	{ 0xB2DD,  0xB2DD },
	{ 0xB2DE,  0xB2DE },
	{ 0xB2DF,  0xB2DF },
	{ 0xB2E0,  0xB2E0 },
	{ 0xB2E1,  0xB2E1 },
	{ 0xB2E2,  0xB2E2 },
	{ 0xB2E3,  0xB2E3 },
	{ 0xB2E4,  0xB2E4 },
	{ 0xB2E5,  0xB2E5 },
	{ 0xB2E6,  0xB2E6 },
	{ 0xB2E7,  0xB2E7 },
	{ 0xB2E8,  0xB2E8 },
	{ 0xB2E9,  0xB2E9 },
	{ 0xB2EA,  0xB2EA },
	{ 0xB2EB,  0xB2EB },
	{ 0xB2EC,  0xB2EC },
	{ 0xB2ED,  0xB2ED },
	{ 0xB2EE,  0xB2EE },
	{ 0xB2EF,  0xB2EF },
	{ 0xB2F0,  0xB2F0 },
	{ 0xB2F1,  0xB2F1 },
	{ 0xB2F2,  0xB2F2 },
	{ 0xB2F3,  0xB2F3 },
	{ 0xB2F4,  0xB2F4 },
	{ 0xB2F5,  0xB2F5 },
	{ 0xB2F6,  0xB2F6 },
	{ 0xB2F7,  0xB2F7 },
	{ 0xB2F8,  0xB2F8 },
	{ 0xB2F9,  0xB2F9 },
	{ 0xB2FA,  0xB2FA },
	{ 0xB2FB,  0xB2FB },
	{ 0xB2FC,  0xB2FC },
	{ 0xB2FD,  0xB2FD },
	{ 0xB2FE,  0xB2FE },
	{ 0xB340,  0xB340 },
	{ 0xB341,  0xB341 },
	{ 0xB342,  0xB342 },
	{ 0xB343,  0xB343 },
	{ 0xB344,  0xB344 },
	{ 0xB345,  0xB345 },
	{ 0xB346,  0xB346 },
	{ 0xB347,  0xB347 },
	{ 0xB348,  0xB348 },
	{ 0xB349,  0xB349 },
	{ 0xB34A,  0xB34A },
	{ 0xB34B,  0xB34B },
	{ 0xB34C,  0xB34C },
	{ 0xB34D,  0xB34D },
	{ 0xB34E,  0xB34E },
	{ 0xB34F,  0xB34F },
	{ 0xB350,  0xB350 },
	{ 0xB351,  0xB351 },
	{ 0xB352,  0xB352 },
	{ 0xB353,  0xB353 },
	{ 0xB354,  0xB354 },
	{ 0xB355,  0xB355 },
	{ 0xB356,  0xB356 },
	{ 0xB357,  0xB357 },
	{ 0xB358,  0xB358 },
	{ 0xB359,  0xB359 },
	{ 0xB35A,  0xB35A },
	{ 0xB35B,  0xB35B },
	{ 0xB35C,  0xB35C },
	{ 0xB35D,  0xB35D },
	{ 0xB35E,  0xB35E },
	{ 0xB35F,  0xB35F },
	{ 0xB360,  0xB360 },
	{ 0xB361,  0xB361 },
	{ 0xB362,  0xB362 },
	{ 0xB363,  0xB363 },
	{ 0xB364,  0xB364 },
	{ 0xB365,  0xB365 },
	{ 0xB366,  0xB366 },
	{ 0xB367,  0xB367 },
	{ 0xB368,  0xB368 },
	{ 0xB369,  0xB369 },
	{ 0xB36A,  0xB36A },
	{ 0xB36B,  0xB36B },
	{ 0xB36C,  0xB36C },
	{ 0xB36D,  0xB36D },
	{ 0xB36E,  0xB36E },
	{ 0xB36F,  0xB36F },
	{ 0xB370,  0xB370 },
	{ 0xB371,  0xB371 },
	{ 0xB372,  0xB372 },
	{ 0xB373,  0xB373 },
	{ 0xB374,  0xB374 },
	{ 0xB375,  0xB375 },
	{ 0xB376,  0xB376 },
	{ 0xB377,  0xB377 },
	{ 0xB378,  0xB378 },
	{ 0xB379,  0xB379 },
	{ 0xB37A,  0xB37A },
	{ 0xB37B,  0xB37B },
	{ 0xB37C,  0xB37C },
	{ 0xB37D,  0xB37D },
	{ 0xB37E,  0xB37E },
	{ 0xB3A1,  0xB3A1 },
	{ 0xB3A2,  0xB3A2 },
	{ 0xB3A3,  0xB3A3 },
	{ 0xB3A4,  0xB3A4 },
	{ 0xB3A5,  0xB3A5 },
	{ 0xB3A6,  0xB3A6 },
	{ 0xB3A7,  0xB3A7 },
	{ 0xB3A8,  0xB3A8 },
	{ 0xB3A9,  0xB3A9 },
	{ 0xB3AA,  0xB3AA },
	{ 0xB3AB,  0xB3AB },
	{ 0xB3AC,  0xB3AC },
	{ 0xB3AD,  0xB3AD },
	{ 0xB3AE,  0xB3AE },
	{ 0xB3AF,  0xB3AF },
	{ 0xB3B0,  0xB3B0 },
	{ 0xB3B1,  0xB3B1 },
	{ 0xB3B2,  0xB3B2 },
	{ 0xB3B3,  0xB3B3 },
	{ 0xB3B4,  0xB3B4 },
	{ 0xB3B5,  0xB3B5 },
	{ 0xB3B6,  0xB3B6 },
	{ 0xB3B7,  0xB3B7 },
	{ 0xB3B8,  0xB3B8 },
	{ 0xB3B9,  0xB3B9 },
	{ 0xB3BA,  0xB3BA },
	{ 0xB3BB,  0xB3BB },
	{ 0xB3BC,  0xB3BC },
	{ 0xB3BD,  0xB3BD },
	{ 0xB3BE,  0xB3BE },
	{ 0xB3BF,  0xB3BF },
	{ 0xB3C0,  0xB3C0 },
	{ 0xB3C1,  0xB3C1 },
	{ 0xB3C2,  0xB3C2 },
	{ 0xB3C3,  0xB3C3 },
	{ 0xB3C4,  0xB3C4 },
	{ 0xB3C5,  0xB3C5 },
	{ 0xB3C6,  0xB3C6 },
	{ 0xB3C7,  0xB3C7 },
	{ 0xB3C8,  0xB3C8 },
	{ 0xB3C9,  0xB3C9 },
	{ 0xB3CA,  0xB3CA },
	{ 0xB3CB,  0xB3CB },
	{ 0xB3CC,  0xB3CC },
	{ 0xB3CD,  0xB3CD },
	{ 0xB3CE,  0xB3CE },
	{ 0xB3CF,  0xB3CF },
	{ 0xB3D0,  0xB3D0 },
	{ 0xB3D1,  0xB3D1 },
	{ 0xB3D2,  0xB3D2 },
	{ 0xB3D3,  0xB3D3 },
	{ 0xB3D4,  0xB3D4 },
	{ 0xB3D5,  0xB3D5 },
	{ 0xB3D6,  0xB3D6 },
	{ 0xB3D7,  0xB3D7 },
	{ 0xB3D8,  0xB3D8 },
	{ 0xB3D9,  0xB3D9 },
	{ 0xB3DA,  0xB3DA },
	{ 0xB3DB,  0xB3DB },
	{ 0xB3DC,  0xB3DC },
	{ 0xB3DD,  0xB3DD },
	{ 0xB3DE,  0xB3DE },
	{ 0xB3DF,  0xB3DF },
	{ 0xB3E0,  0xB3E0 },
	{ 0xB3E1,  0xB3E1 },
	{ 0xB3E2,  0xB3E2 },
	{ 0xB3E3,  0xB3E3 },
	{ 0xB3E4,  0xB3E4 },
	{ 0xB3E5,  0xB3E5 },
	{ 0xB3E6,  0xB3E6 },
	{ 0xB3E7,  0xB3E7 },
	{ 0xB3E8,  0xB3E8 },
	{ 0xB3E9,  0xB3E9 },
	{ 0xB3EA,  0xB3EA },
	{ 0xB3EB,  0xB3EB },
	{ 0xB3EC,  0xB3EC },
	{ 0xB3ED,  0xB3ED },
	{ 0xB3EE,  0xB3EE },
	{ 0xB3EF,  0xB3EF },
	{ 0xB3F0,  0xB3F0 },
	{ 0xB3F1,  0xB3F1 },
	{ 0xB3F2,  0xB3F2 },
	{ 0xB3F3,  0xB3F3 },
	{ 0xB3F4,  0xB3F4 },
	{ 0xB3F5,  0xB3F5 },
	{ 0xB3F6,  0xB3F6 },
	{ 0xB3F7,  0xB3F7 },
	{ 0xB3F8,  0xB3F8 },
	{ 0xB3F9,  0xB3F9 },
	{ 0xB3FA,  0xB3FA },
	{ 0xB3FB,  0xB3FB },
	{ 0xB3FC,  0xB3FC },
	{ 0xB3FD,  0xB3FD },
	{ 0xB3FE,  0xB3FE },
	{ 0xB440,  0xB440 },
	{ 0xB441,  0xB441 },
	{ 0xB442,  0xB442 },
	{ 0xB443,  0xB443 },
	{ 0xB444,  0xB444 },
	{ 0xB445,  0xB445 },
	{ 0xB446,  0xB446 },
	{ 0xB447,  0xB447 },
	{ 0xB448,  0xB448 },
	{ 0xB449,  0xB449 },
	{ 0xB44A,  0xB44A },
	{ 0xB44B,  0xB44B },
	{ 0xB44C,  0xB44C },
	{ 0xB44D,  0xB44D },
	{ 0xB44E,  0xB44E },
	{ 0xB44F,  0xB44F },
	{ 0xB450,  0xB450 },
	{ 0xB451,  0xB451 },
	{ 0xB452,  0xB452 },
	{ 0xB453,  0xB453 },
	{ 0xB454,  0xB454 },
	{ 0xB455,  0xB455 },
	{ 0xB456,  0xB456 },
	{ 0xB457,  0xB457 },
	{ 0xB458,  0xB458 },
	{ 0xB459,  0xB459 },
	{ 0xB45A,  0xB45A },
	{ 0xB45B,  0xB45B },
	{ 0xB45C,  0xB45C },
	{ 0xB45D,  0xB45D },
	{ 0xB45E,  0xB45E },
	{ 0xB45F,  0xB45F },
	{ 0xB460,  0xB460 },
	{ 0xB461,  0xB461 },
	{ 0xB462,  0xB462 },
	{ 0xB463,  0xB463 },
	{ 0xB464,  0xB464 },
	{ 0xB465,  0xB465 },
	{ 0xB466,  0xB466 },
	{ 0xB467,  0xB467 },
	{ 0xB468,  0xB468 },
	{ 0xB469,  0xB469 },
	{ 0xB46A,  0xB46A },
	{ 0xB46B,  0xB46B },
	{ 0xB46C,  0xB46C },
	{ 0xB46D,  0xB46D },
	{ 0xB46E,  0xB46E },
	{ 0xB46F,  0xB46F },
	{ 0xB470,  0xB470 },
	{ 0xB471,  0xB471 },
	{ 0xB472,  0xB472 },
	{ 0xB473,  0xB473 },
	{ 0xB474,  0xB474 },
	{ 0xB475,  0xB475 },
	{ 0xB476,  0xB476 },
	{ 0xB477,  0xB477 },
	{ 0xB478,  0xB478 },
	{ 0xB479,  0xB479 },
	{ 0xB47A,  0xB47A },
	{ 0xB47B,  0xB47B },
	{ 0xB47C,  0xB47C },
	{ 0xB47D,  0xB47D },
	{ 0xB47E,  0xB47E },
	{ 0xB4A1,  0xB4A1 },
	{ 0xB4A2,  0xB4A2 },
	{ 0xB4A3,  0xB4A3 },
	{ 0xB4A4,  0xB4A4 },
	{ 0xB4A5,  0xB4A5 },
	{ 0xB4A6,  0xB4A6 },
	{ 0xB4A7,  0xB4A7 },
	{ 0xB4A8,  0xB4A8 },
	{ 0xB4A9,  0xB4A9 },
	{ 0xB4AA,  0xB4AA },
	{ 0xB4AB,  0xB4AB },
	{ 0xB4AC,  0xB4AC },
	{ 0xB4AD,  0xB4AD },
	{ 0xB4AE,  0xB4AE },
	{ 0xB4AF,  0xB4AF },
	{ 0xB4B0,  0xB4B0 },
	{ 0xB4B1,  0xB4B1 },
	{ 0xB4B2,  0xB4B2 },
	{ 0xB4B3,  0xB4B3 },
	{ 0xB4B4,  0xB4B4 },
	{ 0xB4B5,  0xB4B5 },
	{ 0xB4B6,  0xB4B6 },
	{ 0xB4B7,  0xB4B7 },
	{ 0xB4B8,  0xB4B8 },
	{ 0xB4B9,  0xB4B9 },
	{ 0xB4BA,  0xB4BA },
	{ 0xB4BB,  0xB4BB },
	{ 0xB4BC,  0xB4BC },
	{ 0xB4BD,  0xB4BD },
	{ 0xB4BE,  0xB4BE },
	{ 0xB4BF,  0xB4BF },
	{ 0xB4C0,  0xB4C0 },
	{ 0xB4C1,  0xB4C1 },
	{ 0xB4C2,  0xB4C2 },
	{ 0xB4C3,  0xB4C3 },
	{ 0xB4C4,  0xB4C4 },
	{ 0xB4C5,  0xB4C5 },
	{ 0xB4C6,  0xB4C6 },
	{ 0xB4C7,  0xB4C7 },
	{ 0xB4C8,  0xB4C8 },
	{ 0xB4C9,  0xB4C9 },
	{ 0xB4CA,  0xB4CA },
	{ 0xB4CB,  0xB4CB },
	{ 0xB4CC,  0xB4CC },
	{ 0xB4CD,  0xB4CD },
	{ 0xB4CE,  0xB4CE },
	{ 0xB4CF,  0xB4CF },
	{ 0xB4D0,  0xB4D0 },
	{ 0xB4D1,  0xB4D1 },
	{ 0xB4D2,  0xB4D2 },
	{ 0xB4D3,  0xB4D3 },
	{ 0xB4D4,  0xB4D4 },
	{ 0xB4D5,  0xB4D5 },
	{ 0xB4D6,  0xB4D6 },
	{ 0xB4D7,  0xB4D7 },
	{ 0xB4D8,  0xB4D8 },
	{ 0xB4D9,  0xB4D9 },
	{ 0xB4DA,  0xB4DA },
	{ 0xB4DB,  0xB4DB },
	{ 0xB4DC,  0xB4DC },
	{ 0xB4DD,  0xB4DD },
	{ 0xB4DE,  0xB4DE },
	{ 0xB4DF,  0xB4DF },
	{ 0xB4E0,  0xB4E0 },
	{ 0xB4E1,  0xB4E1 },
	{ 0xB4E2,  0xB4E2 },
	{ 0xB4E3,  0xB4E3 },
	{ 0xB4E4,  0xB4E4 },
	{ 0xB4E5,  0xB4E5 },
	{ 0xB4E6,  0xB4E6 },
	{ 0xB4E7,  0xB4E7 },
	{ 0xB4E8,  0xB4E8 },
	{ 0xB4E9,  0xB4E9 },
	{ 0xB4EA,  0xB4EA },
	{ 0xB4EB,  0xB4EB },
	{ 0xB4EC,  0xB4EC },
	{ 0xB4ED,  0xB4ED },
	{ 0xB4EE,  0xB4EE },
	{ 0xB4EF,  0xB4EF },
	{ 0xB4F0,  0xB4F0 },
	{ 0xB4F1,  0xB4F1 },
	{ 0xB4F2,  0xB4F2 },
	{ 0xB4F3,  0xB4F3 },
	{ 0xB4F4,  0xB4F4 },
	{ 0xB4F5,  0xB4F5 },
	{ 0xB4F6,  0xB4F6 },
	{ 0xB4F7,  0xB4F7 },
	{ 0xB4F8,  0xB4F8 },
	{ 0xB4F9,  0xB4F9 },
	{ 0xB4FA,  0xB4FA },
	{ 0xB4FB,  0xB4FB },
	{ 0xB4FC,  0xB4FC },
	{ 0xB4FD,  0xB4FD },
	{ 0xB4FE,  0xB4FE },
	{ 0xB540,  0xB540 },
	{ 0xB541,  0xB541 },
	{ 0xB542,  0xB542 },
	{ 0xB543,  0xB543 },
	{ 0xB544,  0xB544 },
	{ 0xB545,  0xB545 },
	{ 0xB546,  0xB546 },
	{ 0xB547,  0xB547 },
	{ 0xB548,  0xB548 },
	{ 0xB549,  0xB549 },
	{ 0xB54A,  0xB54A },
	{ 0xB54B,  0xB54B },
	{ 0xB54C,  0xB54C },
	{ 0xB54D,  0xB54D },
	{ 0xB54E,  0xB54E },
	{ 0xB54F,  0xB54F },
	{ 0xB550,  0xB550 },
	{ 0xB551,  0xB551 },
	{ 0xB552,  0xB552 },
	{ 0xB553,  0xB553 },
	{ 0xB554,  0xB554 },
	{ 0xB555,  0xB555 },
	{ 0xB556,  0xB556 },
	{ 0xB557,  0xB557 },
	{ 0xB558,  0xB558 },
	{ 0xB559,  0xB559 },
	{ 0xB55A,  0xB55A },
	{ 0xB55B,  0xB55B },
	{ 0xB55C,  0xB55C },
	{ 0xB55D,  0xB55D },
	{ 0xB55E,  0xB55E },
	{ 0xB55F,  0xB55F },
	{ 0xB560,  0xB560 },
	{ 0xB561,  0xB561 },
	{ 0xB562,  0xB562 },
	{ 0xB563,  0xB563 },
	{ 0xB564,  0xB564 },
	{ 0xB565,  0xB565 },
	{ 0xB566,  0xB566 },
	{ 0xB567,  0xB567 },
	{ 0xB568,  0xB568 },
	{ 0xB569,  0xB569 },
	{ 0xB56A,  0xB56A },
	{ 0xB56B,  0xB56B },
	{ 0xB56C,  0xB56C },
	{ 0xB56D,  0xB56D },
	{ 0xB56E,  0xB56E },
	{ 0xB56F,  0xB56F },
	{ 0xB570,  0xB570 },
	{ 0xB571,  0xB571 },
	{ 0xB572,  0xB572 },
	{ 0xB573,  0xB573 },
	{ 0xB574,  0xB574 },
	{ 0xB575,  0xB575 },
	{ 0xB576,  0xB576 },
	{ 0xB577,  0xB577 },
	{ 0xB578,  0xB578 },
	{ 0xB579,  0xB579 },
	{ 0xB57A,  0xB57A },
	{ 0xB57B,  0xB57B },
	{ 0xB57C,  0xB57C },
	{ 0xB57D,  0xB57D },
	{ 0xB57E,  0xB57E },
	{ 0xB5A1,  0xB5A1 },
	{ 0xB5A2,  0xB5A2 },
	{ 0xB5A3,  0xB5A3 },
	{ 0xB5A4,  0xB5A4 },
	{ 0xB5A5,  0xB5A5 },
	{ 0xB5A6,  0xB5A6 },
	{ 0xB5A7,  0xB5A7 },
	{ 0xB5A8,  0xB5A8 },
	{ 0xB5A9,  0xB5A9 },
	{ 0xB5AA,  0xB5AA },
	{ 0xB5AB,  0xB5AB },
	{ 0xB5AC,  0xB5AC },
	{ 0xB5AD,  0xB5AD },
	{ 0xB5AE,  0xB5AE },
	{ 0xB5AF,  0xB5AF },
	{ 0xB5B0,  0xB5B0 },
	{ 0xB5B1,  0xB5B1 },
	{ 0xB5B2,  0xB5B2 },
	{ 0xB5B3,  0xB5B3 },
	{ 0xB5B4,  0xB5B4 },
	{ 0xB5B5,  0xB5B5 },
	{ 0xB5B6,  0xB5B6 },
	{ 0xB5B7,  0xB5B7 },
	{ 0xB5B8,  0xB5B8 },
	{ 0xB5B9,  0xB5B9 },
	{ 0xB5BA,  0xB5BA },
	{ 0xB5BB,  0xB5BB },
	{ 0xB5BC,  0xB5BC },
	{ 0xB5BD,  0xB5BD },
	{ 0xB5BE,  0xB5BE },
	{ 0xB5BF,  0xB5BF },
	{ 0xB5C0,  0xB5C0 },
	{ 0xB5C1,  0xB5C1 },
	{ 0xB5C2,  0xB5C2 },
	{ 0xB5C3,  0xB5C3 },
	{ 0xB5C4,  0xB5C4 },
	{ 0xB5C5,  0xB5C5 },
	{ 0xB5C6,  0xB5C6 },
	{ 0xB5C7,  0xB5C7 },
	{ 0xB5C8,  0xB5C8 },
	{ 0xB5C9,  0xB5C9 },
	{ 0xB5CA,  0xB5CA },
	{ 0xB5CB,  0xB5CB },
	{ 0xB5CC,  0xB5CC },
	{ 0xB5CD,  0xB5CD },
	{ 0xB5CE,  0xB5CE },
	{ 0xB5CF,  0xB5CF },
	{ 0xB5D0,  0xB5D0 },
	{ 0xB5D1,  0xB5D1 },
	{ 0xB5D2,  0xB5D2 },
	{ 0xB5D3,  0xB5D3 },
	{ 0xB5D4,  0xB5D4 },
	{ 0xB5D5,  0xB5D5 },
	{ 0xB5D6,  0xB5D6 },
	{ 0xB5D7,  0xB5D7 },
	{ 0xB5D8,  0xB5D8 },
	{ 0xB5D9,  0xB5D9 },
	{ 0xB5DA,  0xB5DA },
	{ 0xB5DB,  0xB5DB },
	{ 0xB5DC,  0xB5DC },
	{ 0xB5DD,  0xB5DD },
	{ 0xB5DE,  0xB5DE },
	{ 0xB5DF,  0xB5DF },
	{ 0xB5E0,  0xB5E0 },
	{ 0xB5E1,  0xB5E1 },
	{ 0xB5E2,  0xB5E2 },
	{ 0xB5E3,  0xB5E3 },
	{ 0xB5E4,  0xB5E4 },
	{ 0xB5E5,  0xB5E5 },
	{ 0xB5E6,  0xB5E6 },
	{ 0xB5E7,  0xB5E7 },
	{ 0xB5E8,  0xB5E8 },
	{ 0xB5E9,  0xB5E9 },
	{ 0xB5EA,  0xB5EA },
	{ 0xB5EB,  0xB5EB },
	{ 0xB5EC,  0xB5EC },
	{ 0xB5ED,  0xB5ED },
	{ 0xB5EE,  0xB5EE },
	{ 0xB5EF,  0xB5EF },
	{ 0xB5F0,  0xB5F0 },
	{ 0xB5F1,  0xB5F1 },
	{ 0xB5F2,  0xB5F2 },
	{ 0xB5F3,  0xB5F3 },
	{ 0xB5F4,  0xB5F4 },
	{ 0xB5F5,  0xB5F5 },
	{ 0xB5F6,  0xB5F6 },
	{ 0xB5F7,  0xB5F7 },
	{ 0xB5F8,  0xB5F8 },
	{ 0xB5F9,  0xB5F9 },
	{ 0xB5FA,  0xB5FA },
	{ 0xB5FB,  0xB5FB },
	{ 0xB5FC,  0xB5FC },
	{ 0xB5FD,  0xB5FD },
	{ 0xB5FE,  0xB5FE },
	{ 0xB640,  0xB640 },
	{ 0xB641,  0xB641 },
	{ 0xB642,  0xB642 },
	{ 0xB643,  0xB643 },
	{ 0xB644,  0xB644 },
	{ 0xB645,  0xB645 },
	{ 0xB646,  0xB646 },
	{ 0xB647,  0xB647 },
	{ 0xB648,  0xB648 },
	{ 0xB649,  0xB649 },
	{ 0xB64A,  0xB64A },
	{ 0xB64B,  0xB64B },
	{ 0xB64C,  0xB64C },
	{ 0xB64D,  0xB64D },
	{ 0xB64E,  0xB64E },
	{ 0xB64F,  0xB64F },
	{ 0xB650,  0xB650 },
	{ 0xB651,  0xB651 },
	{ 0xB652,  0xB652 },
	{ 0xB653,  0xB653 },
	{ 0xB654,  0xB654 },
	{ 0xB655,  0xB655 },
	{ 0xB656,  0xB656 },
	{ 0xB657,  0xB657 },
	{ 0xB658,  0xB658 },
	{ 0xB659,  0xB659 },
	{ 0xB65A,  0xB65A },
	{ 0xB65B,  0xB65B },
	{ 0xB65C,  0xB65C },
	{ 0xB65D,  0xB65D },
	{ 0xB65E,  0xB65E },
	{ 0xB65F,  0xB65F },
	{ 0xB660,  0xB660 },
	{ 0xB661,  0xB661 },
	{ 0xB662,  0xB662 },
	{ 0xB663,  0xB663 },
	{ 0xB664,  0xB664 },
	{ 0xB665,  0xB665 },
	{ 0xB666,  0xB666 },
	{ 0xB667,  0xB667 },
	{ 0xB668,  0xB668 },
	{ 0xB669,  0xB669 },
	{ 0xB66A,  0xB66A },
	{ 0xB66B,  0xB66B },
	{ 0xB66C,  0xB66C },
	{ 0xB66D,  0xB66D },
	{ 0xB66E,  0xB66E },
	{ 0xB66F,  0xB66F },
	{ 0xB670,  0xB670 },
	{ 0xB671,  0xB671 },
	{ 0xB672,  0xB672 },
	{ 0xB673,  0xB673 },
	{ 0xB674,  0xB674 },
	{ 0xB675,  0xB675 },
	{ 0xB676,  0xB676 },
	{ 0xB677,  0xB677 },
	{ 0xB678,  0xB678 },
	{ 0xB679,  0xB679 },
	{ 0xB67A,  0xB67A },
	{ 0xB67B,  0xB67B },
	{ 0xB67C,  0xB67C },
	{ 0xB67D,  0xB67D },
	{ 0xB67E,  0xB67E },
	{ 0xB6A1,  0xB6A1 },
	{ 0xB6A2,  0xB6A2 },
	{ 0xB6A3,  0xB6A3 },
	{ 0xB6A4,  0xB6A4 },
	{ 0xB6A5,  0xB6A5 },
	{ 0xB6A6,  0xB6A6 },
	{ 0xB6A7,  0xB6A7 },
	{ 0xB6A8,  0xB6A8 },
	{ 0xB6A9,  0xB6A9 },
	{ 0xB6AA,  0xB6AA },
	{ 0xB6AB,  0xB6AB },
	{ 0xB6AC,  0xB6AC },
	{ 0xB6AD,  0xB6AD },
	{ 0xB6AE,  0xB6AE },
	{ 0xB6AF,  0xB6AF },
	{ 0xB6B0,  0xB6B0 },
	{ 0xB6B1,  0xB6B1 },
	{ 0xB6B2,  0xB6B2 },
	{ 0xB6B3,  0xB6B3 },
	{ 0xB6B4,  0xB6B4 },
	{ 0xB6B5,  0xB6B5 },
	{ 0xB6B6,  0xB6B6 },
	{ 0xB6B7,  0xB6B7 },
	{ 0xB6B8,  0xB6B8 },
	{ 0xB6B9,  0xB6B9 },
	{ 0xB6BA,  0xB6BA },
	{ 0xB6BB,  0xB6BB },
	{ 0xB6BC,  0xB6BC },
	{ 0xB6BD,  0xB6BD },
	{ 0xB6BE,  0xB6BE },
	{ 0xB6BF,  0xB6BF },
	{ 0xB6C0,  0xB6C0 },
	{ 0xB6C1,  0xB6C1 },
	{ 0xB6C2,  0xB6C2 },
	{ 0xB6C3,  0xB6C3 },
	{ 0xB6C4,  0xB6C4 },
	{ 0xB6C5,  0xB6C5 },
	{ 0xB6C6,  0xB6C6 },
	{ 0xB6C7,  0xB6C7 },
	{ 0xB6C8,  0xB6C8 },
	{ 0xB6C9,  0xB6C9 },
	{ 0xB6CA,  0xB6CA },
	{ 0xB6CB,  0xB6CB },
	{ 0xB6CC,  0xB6CC },
	{ 0xB6CD,  0xB6CD },
	{ 0xB6CE,  0xB6CE },
	{ 0xB6CF,  0xB6CF },
	{ 0xB6D0,  0xB6D0 },
	{ 0xB6D1,  0xB6D1 },
	{ 0xB6D2,  0xB6D2 },
	{ 0xB6D3,  0xB6D3 },
	{ 0xB6D4,  0xB6D4 },
	{ 0xB6D5,  0xB6D5 },
	{ 0xB6D6,  0xB6D6 },
	{ 0xB6D7,  0xB6D7 },
	{ 0xB6D8,  0xB6D8 },
	{ 0xB6D9,  0xB6D9 },
	{ 0xB6DA,  0xB6DA },
	{ 0xB6DB,  0xB6DB },
	{ 0xB6DC,  0xB6DC },
	{ 0xB6DD,  0xB6DD },
	{ 0xB6DE,  0xB6DE },
	{ 0xB6DF,  0xB6DF },
	{ 0xB6E0,  0xB6E0 },
	{ 0xB6E1,  0xB6E1 },
	{ 0xB6E2,  0xB6E2 },
	{ 0xB6E3,  0xB6E3 },
	{ 0xB6E4,  0xB6E4 },
	{ 0xB6E5,  0xB6E5 },
	{ 0xB6E6,  0xB6E6 },
	{ 0xB6E7,  0xB6E7 },
	{ 0xB6E8,  0xB6E8 },
	{ 0xB6E9,  0xB6E9 },
	{ 0xB6EA,  0xB6EA },
	{ 0xB6EB,  0xB6EB },
	{ 0xB6EC,  0xB6EC },
	{ 0xB6ED,  0xB6ED },
	{ 0xB6EE,  0xB6EE },
	{ 0xB6EF,  0xB6EF },
	{ 0xB6F0,  0xB6F0 },
	{ 0xB6F1,  0xB6F1 },
	{ 0xB6F2,  0xB6F2 },
	{ 0xB6F3,  0xB6F3 },
	{ 0xB6F4,  0xB6F4 },
	{ 0xB6F5,  0xB6F5 },
	{ 0xB6F6,  0xB6F6 },
	{ 0xB6F7,  0xB6F7 },
	{ 0xB6F8,  0xB6F8 },
	{ 0xB6F9,  0xB6F9 },
	{ 0xB6FA,  0xB6FA },
	{ 0xB6FB,  0xB6FB },
	{ 0xB6FC,  0xB6FC },
	{ 0xB6FD,  0xB6FD },
	{ 0xB6FE,  0xB6FE },
	{ 0xB740,  0xB740 },
	{ 0xB741,  0xB741 },
	{ 0xB742,  0xB742 },
	{ 0xB743,  0xB743 },
	{ 0xB744,  0xB744 },
	{ 0xB745,  0xB745 },
	{ 0xB746,  0xB746 },
	{ 0xB747,  0xB747 },
	{ 0xB748,  0xB748 },
	{ 0xB749,  0xB749 },
	{ 0xB74A,  0xB74A },
	{ 0xB74B,  0xB74B },
	{ 0xB74C,  0xB74C },
	{ 0xB74D,  0xB74D },
	{ 0xB74E,  0xB74E },
	{ 0xB74F,  0xB74F },
	{ 0xB750,  0xB750 },
	{ 0xB751,  0xB751 },
	{ 0xB752,  0xB752 },
	{ 0xB753,  0xB753 },
	{ 0xB754,  0xB754 },
	{ 0xB755,  0xB755 },
	{ 0xB756,  0xB756 },
	{ 0xB757,  0xB757 },
	{ 0xB758,  0xB758 },
	{ 0xB759,  0xB759 },
	{ 0xB75A,  0xB75A },
	{ 0xB75B,  0xB75B },
	{ 0xB75C,  0xB75C },
	{ 0xB75D,  0xB75D },
	{ 0xB75E,  0xB75E },
	{ 0xB75F,  0xB75F },
	{ 0xB760,  0xB760 },
	{ 0xB761,  0xB761 },
	{ 0xB762,  0xB762 },
	{ 0xB763,  0xB763 },
	{ 0xB764,  0xB764 },
	{ 0xB765,  0xB765 },
	{ 0xB766,  0xB766 },
	{ 0xB767,  0xB767 },
	{ 0xB768,  0xB768 },
	{ 0xB769,  0xB769 },
	{ 0xB76A,  0xB76A },
	{ 0xB76B,  0xB76B },
	{ 0xB76C,  0xB76C },
	{ 0xB76D,  0xB76D },
	{ 0xB76E,  0xB76E },
	{ 0xB76F,  0xB76F },
	{ 0xB770,  0xB770 },
	{ 0xB771,  0xB771 },
	{ 0xB772,  0xB772 },
	{ 0xB773,  0xB773 },
	{ 0xB774,  0xB774 },
	{ 0xB775,  0xB775 },
	{ 0xB776,  0xB776 },
	{ 0xB777,  0xB777 },
	{ 0xB778,  0xB778 },
	{ 0xB779,  0xB779 },
	{ 0xB77A,  0xB77A },
	{ 0xB77B,  0xB77B },
	{ 0xB77C,  0xB77C },
	{ 0xB77D,  0xB77D },
	{ 0xB77E,  0xB77E },
	{ 0xB7A1,  0xB7A1 },
	{ 0xB7A2,  0xB7A2 },
	{ 0xB7A3,  0xB7A3 },
	{ 0xB7A4,  0xB7A4 },
	{ 0xB7A5,  0xB7A5 },
	{ 0xB7A6,  0xB7A6 },
	{ 0xB7A7,  0xB7A7 },
	{ 0xB7A8,  0xB7A8 },
	{ 0xB7A9,  0xB7A9 },
	{ 0xB7AA,  0xB7AA },
	{ 0xB7AB,  0xB7AB },
	{ 0xB7AC,  0xB7AC },
	{ 0xB7AD,  0xB7AD },
	{ 0xB7AE,  0xB7AE },
	{ 0xB7AF,  0xB7AF },
	{ 0xB7B0,  0xB7B0 },
	{ 0xB7B1,  0xB7B1 },
	{ 0xB7B2,  0xB7B2 },
	{ 0xB7B3,  0xB7B3 },
	{ 0xB7B4,  0xB7B4 },
	{ 0xB7B5,  0xB7B5 },
	{ 0xB7B6,  0xB7B6 },
	{ 0xB7B7,  0xB7B7 },
	{ 0xB7B8,  0xB7B8 },
	{ 0xB7B9,  0xB7B9 },
	{ 0xB7BA,  0xB7BA },
	{ 0xB7BB,  0xB7BB },
	{ 0xB7BC,  0xB7BC },
	{ 0xB7BD,  0xB7BD },
	{ 0xB7BE,  0xB7BE },
	{ 0xB7BF,  0xB7BF },
	{ 0xB7C0,  0xB7C0 },
	{ 0xB7C1,  0xB7C1 },
	{ 0xB7C2,  0xB7C2 },
	{ 0xB7C3,  0xB7C3 },
	{ 0xB7C4,  0xB7C4 },
	{ 0xB7C5,  0xB7C5 },
	{ 0xB7C6,  0xB7C6 },
	{ 0xB7C7,  0xB7C7 },
	{ 0xB7C8,  0xB7C8 },
	{ 0xB7C9,  0xB7C9 },
	{ 0xB7CA,  0xB7CA },
	{ 0xB7CB,  0xB7CB },
	{ 0xB7CC,  0xB7CC },
	{ 0xB7CD,  0xB7CD },
	{ 0xB7CE,  0xB7CE },
	{ 0xB7CF,  0xB7CF },
	{ 0xB7D0,  0xB7D0 },
	{ 0xB7D1,  0xB7D1 },
	{ 0xB7D2,  0xB7D2 },
	{ 0xB7D3,  0xB7D3 },
	{ 0xB7D4,  0xB7D4 },
	{ 0xB7D5,  0xB7D5 },
	{ 0xB7D6,  0xB7D6 },
	{ 0xB7D7,  0xB7D7 },
	{ 0xB7D8,  0xB7D8 },
	{ 0xB7D9,  0xB7D9 },
	{ 0xB7DA,  0xB7DA },
	{ 0xB7DB,  0xB7DB },
	{ 0xB7DC,  0xB7DC },
	{ 0xB7DD,  0xB7DD },
	{ 0xB7DE,  0xB7DE },
	{ 0xB7DF,  0xB7DF },
	{ 0xB7E0,  0xB7E0 },
	{ 0xB7E1,  0xB7E1 },
	{ 0xB7E2,  0xB7E2 },
	{ 0xB7E3,  0xB7E3 },
	{ 0xB7E4,  0xB7E4 },
	{ 0xB7E5,  0xB7E5 },
	{ 0xB7E6,  0xB7E6 },
	{ 0xB7E7,  0xB7E7 },
	{ 0xB7E8,  0xB7E8 },
	{ 0xB7E9,  0xB7E9 },
	{ 0xB7EA,  0xB7EA },
	{ 0xB7EB,  0xB7EB },
	{ 0xB7EC,  0xB7EC },
	{ 0xB7ED,  0xB7ED },
	{ 0xB7EE,  0xB7EE },
	{ 0xB7EF,  0xB7EF },
	{ 0xB7F0,  0xB7F0 },
	{ 0xB7F1,  0xB7F1 },
	{ 0xB7F2,  0xB7F2 },
	{ 0xB7F3,  0xB7F3 },
	{ 0xB7F4,  0xB7F4 },
	{ 0xB7F5,  0xB7F5 },
	{ 0xB7F6,  0xB7F6 },
	{ 0xB7F7,  0xB7F7 },
	{ 0xB7F8,  0xB7F8 },
	{ 0xB7F9,  0xB7F9 },
	{ 0xB7FA,  0xB7FA },
	{ 0xB7FB,  0xB7FB },
	{ 0xB7FC,  0xB7FC },
	{ 0xB7FD,  0xB7FD },
	{ 0xB7FE,  0xB7FE },
	{ 0xB840,  0xB840 },
	{ 0xB841,  0xB841 },
	{ 0xB842,  0xB842 },
	{ 0xB843,  0xB843 },
	{ 0xB844,  0xB844 },
	{ 0xB845,  0xB845 },
	{ 0xB846,  0xB846 },
	{ 0xB847,  0xB847 },
	{ 0xB848,  0xB848 },
	{ 0xB849,  0xB849 },
	{ 0xB84A,  0xB84A },
	{ 0xB84B,  0xB84B },
	{ 0xB84C,  0xB84C },
	{ 0xB84D,  0xB84D },
	{ 0xB84E,  0xB84E },
	{ 0xB84F,  0xB84F },
	{ 0xB850,  0xB850 },
	{ 0xB851,  0xB851 },
	{ 0xB852,  0xB852 },
	{ 0xB853,  0xB853 },
	{ 0xB854,  0xB854 },
	{ 0xB855,  0xB855 },
	{ 0xB856,  0xB856 },
	{ 0xB857,  0xB857 },
	{ 0xB858,  0xB858 },
	{ 0xB859,  0xB859 },
	{ 0xB85A,  0xB85A },
	{ 0xB85B,  0xB85B },
	{ 0xB85C,  0xB85C },
	{ 0xB85D,  0xB85D },
	{ 0xB85E,  0xB85E },
	{ 0xB85F,  0xB85F },
	{ 0xB860,  0xB860 },
	{ 0xB861,  0xB861 },
	{ 0xB862,  0xB862 },
	{ 0xB863,  0xB863 },
	{ 0xB864,  0xB864 },
	{ 0xB865,  0xB865 },
	{ 0xB866,  0xB866 },
	{ 0xB867,  0xB867 },
	{ 0xB868,  0xB868 },
	{ 0xB869,  0xB869 },
	{ 0xB86A,  0xB86A },
	{ 0xB86B,  0xB86B },
	{ 0xB86C,  0xB86C },
	{ 0xB86D,  0xB86D },
	{ 0xB86E,  0xB86E },
	{ 0xB86F,  0xB86F },
	{ 0xB870,  0xB870 },
	{ 0xB871,  0xB871 },
	{ 0xB872,  0xB872 },
	{ 0xB873,  0xB873 },
	{ 0xB874,  0xB874 },
	{ 0xB875,  0xB875 },
	{ 0xB876,  0xB876 },
	{ 0xB877,  0xB877 },
	{ 0xB878,  0xB878 },
	{ 0xB879,  0xB879 },
	{ 0xB87A,  0xB87A },
	{ 0xB87B,  0xB87B },
	{ 0xB87C,  0xB87C },
	{ 0xB87D,  0xB87D },
	{ 0xB87E,  0xB87E },
	{ 0xB8A1,  0xB8A1 },
	{ 0xB8A2,  0xB8A2 },
	{ 0xB8A3,  0xB8A3 },
	{ 0xB8A4,  0xB8A4 },
	{ 0xB8A5,  0xB8A5 },
	{ 0xB8A6,  0xB8A6 },
	{ 0xB8A7,  0xB8A7 },
	{ 0xB8A8,  0xB8A8 },
	{ 0xB8A9,  0xB8A9 },
	{ 0xB8AA,  0xB8AA },
	{ 0xB8AB,  0xB8AB },
	{ 0xB8AC,  0xB8AC },
	{ 0xB8AD,  0xB8AD },
	{ 0xB8AE,  0xB8AE },
	{ 0xB8AF,  0xB8AF },
	{ 0xB8B0,  0xB8B0 },
	{ 0xB8B1,  0xB8B1 },
	{ 0xB8B2,  0xB8B2 },
	{ 0xB8B3,  0xB8B3 },
	{ 0xB8B4,  0xB8B4 },
	{ 0xB8B5,  0xB8B5 },
	{ 0xB8B6,  0xB8B6 },
	{ 0xB8B7,  0xB8B7 },
	{ 0xB8B8,  0xB8B8 },
	{ 0xB8B9,  0xB8B9 },
	{ 0xB8BA,  0xB8BA },
	{ 0xB8BB,  0xB8BB },
	{ 0xB8BC,  0xB8BC },
	{ 0xB8BD,  0xB8BD },
	{ 0xB8BE,  0xB8BE },
	{ 0xB8BF,  0xB8BF },
	{ 0xB8C0,  0xB8C0 },
	{ 0xB8C1,  0xB8C1 },
	{ 0xB8C2,  0xB8C2 },
	{ 0xB8C3,  0xB8C3 },
	{ 0xB8C4,  0xB8C4 },
	{ 0xB8C5,  0xB8C5 },
	{ 0xB8C6,  0xB8C6 },
	{ 0xB8C7,  0xB8C7 },
	{ 0xB8C8,  0xB8C8 },
	{ 0xB8C9,  0xB8C9 },
	{ 0xB8CA,  0xB8CA },
	{ 0xB8CB,  0xB8CB },
	{ 0xB8CC,  0xB8CC },
	{ 0xB8CD,  0xB8CD },
	{ 0xB8CE,  0xB8CE },
	{ 0xB8CF,  0xB8CF },
	{ 0xB8D0,  0xB8D0 },
	{ 0xB8D1,  0xB8D1 },
	{ 0xB8D2,  0xB8D2 },
	{ 0xB8D3,  0xB8D3 },
	{ 0xB8D4,  0xB8D4 },
	{ 0xB8D5,  0xB8D5 },
	{ 0xB8D6,  0xB8D6 },
	{ 0xB8D7,  0xB8D7 },
	{ 0xB8D8,  0xB8D8 },
	{ 0xB8D9,  0xB8D9 },
	{ 0xB8DA,  0xB8DA },
	{ 0xB8DB,  0xB8DB },
	{ 0xB8DC,  0xB8DC },
	{ 0xB8DD,  0xB8DD },
	{ 0xB8DE,  0xB8DE },
	{ 0xB8DF,  0xB8DF },
	{ 0xB8E0,  0xB8E0 },
	{ 0xB8E1,  0xB8E1 },
	{ 0xB8E2,  0xB8E2 },
	{ 0xB8E3,  0xB8E3 },
	{ 0xB8E4,  0xB8E4 },
	{ 0xB8E5,  0xB8E5 },
	{ 0xB8E6,  0xB8E6 },
	{ 0xB8E7,  0xB8E7 },
	{ 0xB8E8,  0xB8E8 },
	{ 0xB8E9,  0xB8E9 },
	{ 0xB8EA,  0xB8EA },
	{ 0xB8EB,  0xB8EB },
	{ 0xB8EC,  0xB8EC },
	{ 0xB8ED,  0xB8ED },
	{ 0xB8EE,  0xB8EE },
	{ 0xB8EF,  0xB8EF },
	{ 0xB8F0,  0xB8F0 },
	{ 0xB8F1,  0xB8F1 },
	{ 0xB8F2,  0xB8F2 },
	{ 0xB8F3,  0xB8F3 },
	{ 0xB8F4,  0xB8F4 },
	{ 0xB8F5,  0xB8F5 },
	{ 0xB8F6,  0xB8F6 },
	{ 0xB8F7,  0xB8F7 },
	{ 0xB8F8,  0xB8F8 },
	{ 0xB8F9,  0xB8F9 },
	{ 0xB8FA,  0xB8FA },
	{ 0xB8FB,  0xB8FB },
	{ 0xB8FC,  0xB8FC },
	{ 0xB8FD,  0xB8FD },
	{ 0xB8FE,  0xB8FE },
	{ 0xB940,  0xB940 },
	{ 0xB941,  0xB941 },
	{ 0xB942,  0xB942 },
	{ 0xB943,  0xB943 },
	{ 0xB944,  0xB944 },
	{ 0xB945,  0xB945 },
	{ 0xB946,  0xB946 },
	{ 0xB947,  0xB947 },
	{ 0xB948,  0xB948 },
	{ 0xB949,  0xB949 },
	{ 0xB94A,  0xB94A },
	{ 0xB94B,  0xB94B },
	{ 0xB94C,  0xB94C },
	{ 0xB94D,  0xB94D },
	{ 0xB94E,  0xB94E },
	{ 0xB94F,  0xB94F },
	{ 0xB950,  0xB950 },
	{ 0xB951,  0xB951 },
	{ 0xB952,  0xB952 },
	{ 0xB953,  0xB953 },
	{ 0xB954,  0xB954 },
	{ 0xB955,  0xB955 },
	{ 0xB956,  0xB956 },
	{ 0xB957,  0xB957 },
	{ 0xB958,  0xB958 },
	{ 0xB959,  0xB959 },
	{ 0xB95A,  0xB95A },
	{ 0xB95B,  0xB95B },
	{ 0xB95C,  0xB95C },
	{ 0xB95D,  0xB95D },
	{ 0xB95E,  0xB95E },
	{ 0xB95F,  0xB95F },
	{ 0xB960,  0xB960 },
	{ 0xB961,  0xB961 },
	{ 0xB962,  0xB962 },
	{ 0xB963,  0xB963 },
	{ 0xB964,  0xB964 },
	{ 0xB965,  0xB965 },
	{ 0xB966,  0xB966 },
	{ 0xB967,  0xB967 },
	{ 0xB968,  0xB968 },
	{ 0xB969,  0xB969 },
	{ 0xB96A,  0xB96A },
	{ 0xB96B,  0xB96B },
	{ 0xB96C,  0xB96C },
	{ 0xB96D,  0xB96D },
	{ 0xB96E,  0xB96E },
	{ 0xB96F,  0xB96F },
	{ 0xB970,  0xB970 },
	{ 0xB971,  0xB971 },
	{ 0xB972,  0xB972 },
	{ 0xB973,  0xB973 },
	{ 0xB974,  0xB974 },
	{ 0xB975,  0xB975 },
	{ 0xB976,  0xB976 },
	{ 0xB977,  0xB977 },
	{ 0xB978,  0xB978 },
	{ 0xB979,  0xB979 },
	{ 0xB97A,  0xB97A },
	{ 0xB97B,  0xB97B },
	{ 0xB97C,  0xB97C },
	{ 0xB97D,  0xB97D },
	{ 0xB97E,  0xB97E },
	{ 0xB9A1,  0xB9A1 },
	{ 0xB9A2,  0xB9A2 },
	{ 0xB9A3,  0xB9A3 },
	{ 0xB9A4,  0xB9A4 },
	{ 0xB9A5,  0xB9A5 },
	{ 0xB9A6,  0xB9A6 },
	{ 0xB9A7,  0xB9A7 },
	{ 0xB9A8,  0xB9A8 },
	{ 0xB9A9,  0xB9A9 },
	{ 0xB9AA,  0xB9AA },
	{ 0xB9AB,  0xB9AB },
	{ 0xB9AC,  0xB9AC },
	{ 0xB9AD,  0xB9AD },
	{ 0xB9AE,  0xB9AE },
	{ 0xB9AF,  0xB9AF },
	{ 0xB9B0,  0xB9B0 },
	{ 0xB9B1,  0xB9B1 },
	{ 0xB9B2,  0xB9B2 },
	{ 0xB9B3,  0xB9B3 },
	{ 0xB9B4,  0xB9B4 },
	{ 0xB9B5,  0xB9B5 },
	{ 0xB9B6,  0xB9B6 },
	{ 0xB9B7,  0xB9B7 },
	{ 0xB9B8,  0xB9B8 },
	{ 0xB9B9,  0xB9B9 },
	{ 0xB9BA,  0xB9BA },
	{ 0xB9BB,  0xB9BB },
	{ 0xB9BC,  0xB9BC },
	{ 0xB9BD,  0xB9BD },
	{ 0xB9BE,  0xB9BE },
	{ 0xB9BF,  0xB9BF },
	{ 0xB9C0,  0xB9C0 },
	{ 0xB9C1,  0xB9C1 },
	{ 0xB9C2,  0xB9C2 },
	{ 0xB9C3,  0xB9C3 },
	{ 0xB9C4,  0xB9C4 },
	{ 0xB9C5,  0xB9C5 },
	{ 0xB9C6,  0xB9C6 },
	{ 0xB9C7,  0xB9C7 },
	{ 0xB9C8,  0xB9C8 },
	{ 0xB9C9,  0xB9C9 },
	{ 0xB9CA,  0xB9CA },
	{ 0xB9CB,  0xB9CB },
	{ 0xB9CC,  0xB9CC },
	{ 0xB9CD,  0xB9CD },
	{ 0xB9CE,  0xB9CE },
	{ 0xB9CF,  0xB9CF },
	{ 0xB9D0,  0xB9D0 },
	{ 0xB9D1,  0xB9D1 },
	{ 0xB9D2,  0xB9D2 },
	{ 0xB9D3,  0xB9D3 },
	{ 0xB9D4,  0xB9D4 },
	{ 0xB9D5,  0xB9D5 },
	{ 0xB9D6,  0xB9D6 },
	{ 0xB9D7,  0xB9D7 },
	{ 0xB9D8,  0xB9D8 },
	{ 0xB9D9,  0xB9D9 },
	{ 0xB9DA,  0xB9DA },
	{ 0xB9DB,  0xB9DB },
	{ 0xB9DC,  0xB9DC },
	{ 0xB9DD,  0xB9DD },
	{ 0xB9DE,  0xB9DE },
	{ 0xB9DF,  0xB9DF },
	{ 0xB9E0,  0xB9E0 },
	{ 0xB9E1,  0xB9E1 },
	{ 0xB9E2,  0xB9E2 },
	{ 0xB9E3,  0xB9E3 },
	{ 0xB9E4,  0xB9E4 },
	{ 0xB9E5,  0xB9E5 },
	{ 0xB9E6,  0xB9E6 },
	{ 0xB9E7,  0xB9E7 },
	{ 0xB9E8,  0xB9E8 },
	{ 0xB9E9,  0xB9E9 },
	{ 0xB9EA,  0xB9EA },
	{ 0xB9EB,  0xB9EB },
	{ 0xB9EC,  0xB9EC },
	{ 0xB9ED,  0xB9ED },
	{ 0xB9EE,  0xB9EE },
	{ 0xB9EF,  0xB9EF },
	{ 0xB9F0,  0xB9F0 },
	{ 0xB9F1,  0xB9F1 },
	{ 0xB9F2,  0xB9F2 },
	{ 0xB9F3,  0xB9F3 },
	{ 0xB9F4,  0xB9F4 },
	{ 0xB9F5,  0xB9F5 },
	{ 0xB9F6,  0xB9F6 },
	{ 0xB9F7,  0xB9F7 },
	{ 0xB9F8,  0xB9F8 },
	{ 0xB9F9,  0xB9F9 },
	{ 0xB9FA,  0xB9FA },
	{ 0xB9FB,  0xB9FB },
	{ 0xB9FC,  0xB9FC },
	{ 0xB9FD,  0xB9FD },
	{ 0xB9FE,  0xB9FE },
	{ 0xBA40,  0xBA40 },
	{ 0xBA41,  0xBA41 },
	{ 0xBA42,  0xBA42 },
	{ 0xBA43,  0xBA43 },
	{ 0xBA44,  0xBA44 },
	{ 0xBA45,  0xBA45 },
	{ 0xBA46,  0xBA46 },
	{ 0xBA47,  0xBA47 },
	{ 0xBA48,  0xBA48 },
	{ 0xBA49,  0xBA49 },
	{ 0xBA4A,  0xBA4A },
	{ 0xBA4B,  0xBA4B },
	{ 0xBA4C,  0xBA4C },
	{ 0xBA4D,  0xBA4D },
	{ 0xBA4E,  0xBA4E },
	{ 0xBA4F,  0xBA4F },
	{ 0xBA50,  0xBA50 },
	{ 0xBA51,  0xBA51 },
	{ 0xBA52,  0xBA52 },
	{ 0xBA53,  0xBA53 },
	{ 0xBA54,  0xBA54 },
	{ 0xBA55,  0xBA55 },
	{ 0xBA56,  0xBA56 },
	{ 0xBA57,  0xBA57 },
	{ 0xBA58,  0xBA58 },
	{ 0xBA59,  0xBA59 },
	{ 0xBA5A,  0xBA5A },
	{ 0xBA5B,  0xBA5B },
	{ 0xBA5C,  0xBA5C },
	{ 0xBA5D,  0xBA5D },
	{ 0xBA5E,  0xBA5E },
	{ 0xBA5F,  0xBA5F },
	{ 0xBA60,  0xBA60 },
	{ 0xBA61,  0xBA61 },
	{ 0xBA62,  0xBA62 },
	{ 0xBA63,  0xBA63 },
	{ 0xBA64,  0xBA64 },
	{ 0xBA65,  0xBA65 },
	{ 0xBA66,  0xBA66 },
	{ 0xBA67,  0xBA67 },
	{ 0xBA68,  0xBA68 },
	{ 0xBA69,  0xBA69 },
	{ 0xBA6A,  0xBA6A },
	{ 0xBA6B,  0xBA6B },
	{ 0xBA6C,  0xBA6C },
	{ 0xBA6D,  0xBA6D },
	{ 0xBA6E,  0xBA6E },
	{ 0xBA6F,  0xBA6F },
	{ 0xBA70,  0xBA70 },
	{ 0xBA71,  0xBA71 },
	{ 0xBA72,  0xBA72 },
	{ 0xBA73,  0xBA73 },
	{ 0xBA74,  0xBA74 },
	{ 0xBA75,  0xBA75 },
	{ 0xBA76,  0xBA76 },
	{ 0xBA77,  0xBA77 },
	{ 0xBA78,  0xBA78 },
	{ 0xBA79,  0xBA79 },
	{ 0xBA7A,  0xBA7A },
	{ 0xBA7B,  0xBA7B },
	{ 0xBA7C,  0xBA7C },
	{ 0xBA7D,  0xBA7D },
	{ 0xBA7E,  0xBA7E },
	{ 0xBAA1,  0xBAA1 },
	{ 0xBAA2,  0xBAA2 },
	{ 0xBAA3,  0xBAA3 },
	{ 0xBAA4,  0xBAA4 },
	{ 0xBAA5,  0xBAA5 },
	{ 0xBAA6,  0xBAA6 },
	{ 0xBAA7,  0xBAA7 },
	{ 0xBAA8,  0xBAA8 },
	{ 0xBAA9,  0xBAA9 },
	{ 0xBAAA,  0xBAAA },
	{ 0xBAAB,  0xBAAB },
	{ 0xBAAC,  0xBAAC },
	{ 0xBAAD,  0xBAAD },
	{ 0xBAAE,  0xBAAE },
	{ 0xBAAF,  0xBAAF },
	{ 0xBAB0,  0xBAB0 },
	{ 0xBAB1,  0xBAB1 },
	{ 0xBAB2,  0xBAB2 },
	{ 0xBAB3,  0xBAB3 },
	{ 0xBAB4,  0xBAB4 },
	{ 0xBAB5,  0xBAB5 },
	{ 0xBAB6,  0xBAB6 },
	{ 0xBAB7,  0xBAB7 },
	{ 0xBAB8,  0xBAB8 },
	{ 0xBAB9,  0xBAB9 },
	{ 0xBABA,  0xBABA },
	{ 0xBABB,  0xBABB },
	{ 0xBABC,  0xBABC },
	{ 0xBABD,  0xBABD },
	{ 0xBABE,  0xBABE },
	{ 0xBABF,  0xBABF },
	{ 0xBAC0,  0xBAC0 },
	{ 0xBAC1,  0xBAC1 },
	{ 0xBAC2,  0xBAC2 },
	{ 0xBAC3,  0xBAC3 },
	{ 0xBAC4,  0xBAC4 },
	{ 0xBAC5,  0xBAC5 },
	{ 0xBAC6,  0xBAC6 },
	{ 0xBAC7,  0xBAC7 },
	{ 0xBAC8,  0xBAC8 },
	{ 0xBAC9,  0xBAC9 },
	{ 0xBACA,  0xBACA },
	{ 0xBACB,  0xBACB },
	{ 0xBACC,  0xBACC },
	{ 0xBACD,  0xBACD },
	{ 0xBACE,  0xBACE },
	{ 0xBACF,  0xBACF },
	{ 0xBAD0,  0xBAD0 },
	{ 0xBAD1,  0xBAD1 },
	{ 0xBAD2,  0xBAD2 },
	{ 0xBAD3,  0xBAD3 },
	{ 0xBAD4,  0xBAD4 },
	{ 0xBAD5,  0xBAD5 },
	{ 0xBAD6,  0xBAD6 },
	{ 0xBAD7,  0xBAD7 },
	{ 0xBAD8,  0xBAD8 },
	{ 0xBAD9,  0xBAD9 },
	{ 0xBADA,  0xBADA },
	{ 0xBADB,  0xBADB },
	{ 0xBADC,  0xBADC },
	{ 0xBADD,  0xBADD },
	{ 0xBADE,  0xBADE },
	{ 0xBADF,  0xBADF },
	{ 0xBAE0,  0xBAE0 },
	{ 0xBAE1,  0xBAE1 },
	{ 0xBAE2,  0xBAE2 },
	{ 0xBAE3,  0xBAE3 },
	{ 0xBAE4,  0xBAE4 },
	{ 0xBAE5,  0xBAE5 },
	{ 0xBAE6,  0xBAE6 },
	{ 0xBAE7,  0xBAE7 },
	{ 0xBAE8,  0xBAE8 },
	{ 0xBAE9,  0xBAE9 },
	{ 0xBAEA,  0xBAEA },
	{ 0xBAEB,  0xBAEB },
	{ 0xBAEC,  0xBAEC },
	{ 0xBAED,  0xBAED },
	{ 0xBAEE,  0xBAEE },
	{ 0xBAEF,  0xBAEF },
	{ 0xBAF0,  0xBAF0 },
	{ 0xBAF1,  0xBAF1 },
	{ 0xBAF2,  0xBAF2 },
	{ 0xBAF3,  0xBAF3 },
	{ 0xBAF4,  0xBAF4 },
	{ 0xBAF5,  0xBAF5 },
	{ 0xBAF6,  0xBAF6 },
	{ 0xBAF7,  0xBAF7 },
	{ 0xBAF8,  0xBAF8 },
	{ 0xBAF9,  0xBAF9 },
	{ 0xBAFA,  0xBAFA },
	{ 0xBAFB,  0xBAFB },
	{ 0xBAFC,  0xBAFC },
	{ 0xBAFD,  0xBAFD },
	{ 0xBAFE,  0xBAFE },
	{ 0xBB40,  0xBB40 },
	{ 0xBB41,  0xBB41 },
	{ 0xBB42,  0xBB42 },
	{ 0xBB43,  0xBB43 },
	{ 0xBB44,  0xBB44 },
	{ 0xBB45,  0xBB45 },
	{ 0xBB46,  0xBB46 },
	{ 0xBB47,  0xBB47 },
	{ 0xBB48,  0xBB48 },
	{ 0xBB49,  0xBB49 },
	{ 0xBB4A,  0xBB4A },
	{ 0xBB4B,  0xBB4B },
	{ 0xBB4C,  0xBB4C },
	{ 0xBB4D,  0xBB4D },
	{ 0xBB4E,  0xBB4E },
	{ 0xBB4F,  0xBB4F },
	{ 0xBB50,  0xBB50 },
	{ 0xBB51,  0xBB51 },
	{ 0xBB52,  0xBB52 },
	{ 0xBB53,  0xBB53 },
	{ 0xBB54,  0xBB54 },
	{ 0xBB55,  0xBB55 },
	{ 0xBB56,  0xBB56 },
	{ 0xBB57,  0xBB57 },
	{ 0xBB58,  0xBB58 },
	{ 0xBB59,  0xBB59 },
	{ 0xBB5A,  0xBB5A },
	{ 0xBB5B,  0xBB5B },
	{ 0xBB5C,  0xBB5C },
	{ 0xBB5D,  0xBB5D },
	{ 0xBB5E,  0xBB5E },
	{ 0xBB5F,  0xBB5F },
	{ 0xBB60,  0xBB60 },
	{ 0xBB61,  0xBB61 },
	{ 0xBB62,  0xBB62 },
	{ 0xBB63,  0xBB63 },
	{ 0xBB64,  0xBB64 },
	{ 0xBB65,  0xBB65 },
	{ 0xBB66,  0xBB66 },
	{ 0xBB67,  0xBB67 },
	{ 0xBB68,  0xBB68 },
	{ 0xBB69,  0xBB69 },
	{ 0xBB6A,  0xBB6A },
	{ 0xBB6B,  0xBB6B },
	{ 0xBB6C,  0xBB6C },
	{ 0xBB6D,  0xBB6D },
	{ 0xBB6E,  0xBB6E },
	{ 0xBB6F,  0xBB6F },
	{ 0xBB70,  0xBB70 },
	{ 0xBB71,  0xBB71 },
	{ 0xBB72,  0xBB72 },
	{ 0xBB73,  0xBB73 },
	{ 0xBB74,  0xBB74 },
	{ 0xBB75,  0xBB75 },
	{ 0xBB76,  0xBB76 },
	{ 0xBB77,  0xBB77 },
	{ 0xBB78,  0xBB78 },
	{ 0xBB79,  0xBB79 },
	{ 0xBB7A,  0xBB7A },
	{ 0xBB7B,  0xBB7B },
	{ 0xBB7C,  0xBB7C },
	{ 0xBB7D,  0xBB7D },
	{ 0xBB7E,  0xBB7E },
	{ 0xBBA1,  0xBBA1 },
	{ 0xBBA2,  0xBBA2 },
	{ 0xBBA3,  0xBBA3 },
	{ 0xBBA4,  0xBBA4 },
	{ 0xBBA5,  0xBBA5 },
	{ 0xBBA6,  0xBBA6 },
	{ 0xBBA7,  0xBBA7 },
	{ 0xBBA8,  0xBBA8 },
	{ 0xBBA9,  0xBBA9 },
	{ 0xBBAA,  0xBBAA },
	{ 0xBBAB,  0xBBAB },
	{ 0xBBAC,  0xBBAC },
	{ 0xBBAD,  0xBBAD },
	{ 0xBBAE,  0xBBAE },
	{ 0xBBAF,  0xBBAF },
	{ 0xBBB0,  0xBBB0 },
	{ 0xBBB1,  0xBBB1 },
	{ 0xBBB2,  0xBBB2 },
	{ 0xBBB3,  0xBBB3 },
	{ 0xBBB4,  0xBBB4 },
	{ 0xBBB5,  0xBBB5 },
	{ 0xBBB6,  0xBBB6 },
	{ 0xBBB7,  0xBBB7 },
	{ 0xBBB8,  0xBBB8 },
	{ 0xBBB9,  0xBBB9 },
	{ 0xBBBA,  0xBBBA },
	{ 0xBBBB,  0xBBBB },
	{ 0xBBBC,  0xBBBC },
	{ 0xBBBD,  0xBBBD },
	{ 0xBBBE,  0xBBBE },
	{ 0xBBBF,  0xBBBF },
	{ 0xBBC0,  0xBBC0 },
	{ 0xBBC1,  0xBBC1 },
	{ 0xBBC2,  0xBBC2 },
	{ 0xBBC3,  0xBBC3 },
	{ 0xBBC4,  0xBBC4 },
	{ 0xBBC5,  0xBBC5 },
	{ 0xBBC6,  0xBBC6 },
	{ 0xBBC7,  0xBBC7 },
	{ 0xBBC8,  0xBBC8 },
	{ 0xBBC9,  0xBBC9 },
	{ 0xBBCA,  0xBBCA },
	{ 0xBBCB,  0xBBCB },
	{ 0xBBCC,  0xBBCC },
	{ 0xBBCD,  0xBBCD },
	{ 0xBBCE,  0xBBCE },
	{ 0xBBCF,  0xBBCF },
	{ 0xBBD0,  0xBBD0 },
	{ 0xBBD1,  0xBBD1 },
	{ 0xBBD2,  0xBBD2 },
	{ 0xBBD3,  0xBBD3 },
	{ 0xBBD4,  0xBBD4 },
	{ 0xBBD5,  0xBBD5 },
	{ 0xBBD6,  0xBBD6 },
	{ 0xBBD7,  0xBBD7 },
	{ 0xBBD8,  0xBBD8 },
	{ 0xBBD9,  0xBBD9 },
	{ 0xBBDA,  0xBBDA },
	{ 0xBBDB,  0xBBDB },
	{ 0xBBDC,  0xBBDC },
	{ 0xBBDD,  0xBBDD },
	{ 0xBBDE,  0xBBDE },
	{ 0xBBDF,  0xBBDF },
	{ 0xBBE0,  0xBBE0 },
	{ 0xBBE1,  0xBBE1 },
	{ 0xBBE2,  0xBBE2 },
	{ 0xBBE3,  0xBBE3 },
	{ 0xBBE4,  0xBBE4 },
	{ 0xBBE5,  0xBBE5 },
	{ 0xBBE6,  0xBBE6 },
	{ 0xBBE7,  0xBBE7 },
	{ 0xBBE8,  0xBBE8 },
	{ 0xBBE9,  0xBBE9 },
	{ 0xBBEA,  0xBBEA },
	{ 0xBBEB,  0xBBEB },
	{ 0xBBEC,  0xBBEC },
	{ 0xBBED,  0xBBED },
	{ 0xBBEE,  0xBBEE },
	{ 0xBBEF,  0xBBEF },
	{ 0xBBF0,  0xBBF0 },
	{ 0xBBF1,  0xBBF1 },
	{ 0xBBF2,  0xBBF2 },
	{ 0xBBF3,  0xBBF3 },
	{ 0xBBF4,  0xBBF4 },
	{ 0xBBF5,  0xBBF5 },
	{ 0xBBF6,  0xBBF6 },
	{ 0xBBF7,  0xBBF7 },
	{ 0xBBF8,  0xBBF8 },
	{ 0xBBF9,  0xBBF9 },
	{ 0xBBFA,  0xBBFA },
	{ 0xBBFB,  0xBBFB },
	{ 0xBBFC,  0xBBFC },
	{ 0xBBFD,  0xBBFD },
	{ 0xBBFE,  0xBBFE },
	{ 0xBC40,  0xBC40 },
	{ 0xBC41,  0xBC41 },
	{ 0xBC42,  0xBC42 },
	{ 0xBC43,  0xBC43 },
	{ 0xBC44,  0xBC44 },
	{ 0xBC45,  0xBC45 },
	{ 0xBC46,  0xBC46 },
	{ 0xBC47,  0xBC47 },
	{ 0xBC48,  0xBC48 },
	{ 0xBC49,  0xBC49 },
	{ 0xBC4A,  0xBC4A },
	{ 0xBC4B,  0xBC4B },
	{ 0xBC4C,  0xBC4C },
	{ 0xBC4D,  0xBC4D },
	{ 0xBC4E,  0xBC4E },
	{ 0xBC4F,  0xBC4F },
	{ 0xBC50,  0xBC50 },
	{ 0xBC51,  0xBC51 },
	{ 0xBC52,  0xBC52 },
	{ 0xBC53,  0xBC53 },
	{ 0xBC54,  0xBC54 },
	{ 0xBC55,  0xBC55 },
	{ 0xBC56,  0xBC56 },
	{ 0xBC57,  0xBC57 },
	{ 0xBC58,  0xBC58 },
	{ 0xBC59,  0xBC59 },
	{ 0xBC5A,  0xBC5A },
	{ 0xBC5B,  0xBC5B },
	{ 0xBC5C,  0xBC5C },
	{ 0xBC5D,  0xBC5D },
	{ 0xBC5E,  0xBC5E },
	{ 0xBC5F,  0xBC5F },
	{ 0xBC60,  0xBC60 },
	{ 0xBC61,  0xBC61 },
	{ 0xBC62,  0xBC62 },
	{ 0xBC63,  0xBC63 },
	{ 0xBC64,  0xBC64 },
	{ 0xBC65,  0xBC65 },
	{ 0xBC66,  0xBC66 },
	{ 0xBC67,  0xBC67 },
	{ 0xBC68,  0xBC68 },
	{ 0xBC69,  0xBC69 },
	{ 0xBC6A,  0xBC6A },
	{ 0xBC6B,  0xBC6B },
	{ 0xBC6C,  0xBC6C },
	{ 0xBC6D,  0xBC6D },
	{ 0xBC6E,  0xBC6E },
	{ 0xBC6F,  0xBC6F },
	{ 0xBC70,  0xBC70 },
	{ 0xBC71,  0xBC71 },
	{ 0xBC72,  0xBC72 },
	{ 0xBC73,  0xBC73 },
	{ 0xBC74,  0xBC74 },
	{ 0xBC75,  0xBC75 },
	{ 0xBC76,  0xBC76 },
	{ 0xBC77,  0xBC77 },
	{ 0xBC78,  0xBC78 },
	{ 0xBC79,  0xBC79 },
	{ 0xBC7A,  0xBC7A },
	{ 0xBC7B,  0xBC7B },
	{ 0xBC7C,  0xBC7C },
	{ 0xBC7D,  0xBC7D },
	{ 0xBC7E,  0xBC7E },
	{ 0xBCA1,  0xBCA1 },
	{ 0xBCA2,  0xBCA2 },
	{ 0xBCA3,  0xBCA3 },
	{ 0xBCA4,  0xBCA4 },
	{ 0xBCA5,  0xBCA5 },
	{ 0xBCA6,  0xBCA6 },
	{ 0xBCA7,  0xBCA7 },
	{ 0xBCA8,  0xBCA8 },
	{ 0xBCA9,  0xBCA9 },
	{ 0xBCAA,  0xBCAA },
	{ 0xBCAB,  0xBCAB },
	{ 0xBCAC,  0xBCAC },
	{ 0xBCAD,  0xBCAD },
	{ 0xBCAE,  0xBCAE },
	{ 0xBCAF,  0xBCAF },
	{ 0xBCB0,  0xBCB0 },
	{ 0xBCB1,  0xBCB1 },
	{ 0xBCB2,  0xBCB2 },
	{ 0xBCB3,  0xBCB3 },
	{ 0xBCB4,  0xBCB4 },
	{ 0xBCB5,  0xBCB5 },
	{ 0xBCB6,  0xBCB6 },
	{ 0xBCB7,  0xBCB7 },
	{ 0xBCB8,  0xBCB8 },
	{ 0xBCB9,  0xBCB9 },
	{ 0xBCBA,  0xBCBA },
	{ 0xBCBB,  0xBCBB },
	{ 0xBCBC,  0xBCBC },
	{ 0xBCBD,  0xBCBD },
	{ 0xBCBE,  0xBCBE },
	{ 0xBCBF,  0xBCBF },
	{ 0xBCC0,  0xBCC0 },
	{ 0xBCC1,  0xBCC1 },
	{ 0xBCC2,  0xBCC2 },
	{ 0xBCC3,  0xBCC3 },
	{ 0xBCC4,  0xBCC4 },
	{ 0xBCC5,  0xBCC5 },
	{ 0xBCC6,  0xBCC6 },
	{ 0xBCC7,  0xBCC7 },
	{ 0xBCC8,  0xBCC8 },
	{ 0xBCC9,  0xBCC9 },
	{ 0xBCCA,  0xBCCA },
	{ 0xBCCB,  0xBCCB },
	{ 0xBCCC,  0xBCCC },
	{ 0xBCCD,  0xBCCD },
	{ 0xBCCE,  0xBCCE },
	{ 0xBCCF,  0xBCCF },
	{ 0xBCD0,  0xBCD0 },
	{ 0xBCD1,  0xBCD1 },
	{ 0xBCD2,  0xBCD2 },
	{ 0xBCD3,  0xBCD3 },
	{ 0xBCD4,  0xBCD4 },
	{ 0xBCD5,  0xBCD5 },
	{ 0xBCD6,  0xBCD6 },
	{ 0xBCD7,  0xBCD7 },
	{ 0xBCD8,  0xBCD8 },
	{ 0xBCD9,  0xBCD9 },
	{ 0xBCDA,  0xBCDA },
	{ 0xBCDB,  0xBCDB },
	{ 0xBCDC,  0xBCDC },
	{ 0xBCDD,  0xBCDD },
	{ 0xBCDE,  0xBCDE },
	{ 0xBCDF,  0xBCDF },
	{ 0xBCE0,  0xBCE0 },
	{ 0xBCE1,  0xBCE1 },
	{ 0xBCE2,  0xBCE2 },
	{ 0xBCE3,  0xBCE3 },
	{ 0xBCE4,  0xBCE4 },
	{ 0xBCE5,  0xBCE5 },
	{ 0xBCE6,  0xBCE6 },
	{ 0xBCE7,  0xBCE7 },
	{ 0xBCE8,  0xBCE8 },
	{ 0xBCE9,  0xBCE9 },
	{ 0xBCEA,  0xBCEA },
	{ 0xBCEB,  0xBCEB },
	{ 0xBCEC,  0xBCEC },
	{ 0xBCED,  0xBCED },
	{ 0xBCEE,  0xBCEE },
	{ 0xBCEF,  0xBCEF },
	{ 0xBCF0,  0xBCF0 },
	{ 0xBCF1,  0xBCF1 },
	{ 0xBCF2,  0xBCF2 },
	{ 0xBCF3,  0xBCF3 },
	{ 0xBCF4,  0xBCF4 },
	{ 0xBCF5,  0xBCF5 },
	{ 0xBCF6,  0xBCF6 },
	{ 0xBCF7,  0xBCF7 },
	{ 0xBCF8,  0xBCF8 },
	{ 0xBCF9,  0xBCF9 },
	{ 0xBCFA,  0xBCFA },
	{ 0xBCFB,  0xBCFB },
	{ 0xBCFC,  0xBCFC },
	{ 0xBCFD,  0xBCFD },
	{ 0xBCFE,  0xBCFE },
	{ 0xBD40,  0xBD40 },
	{ 0xBD41,  0xBD41 },
	{ 0xBD42,  0xBD42 },
	{ 0xBD43,  0xBD43 },
	{ 0xBD44,  0xBD44 },
	{ 0xBD45,  0xBD45 },
	{ 0xBD46,  0xBD46 },
	{ 0xBD47,  0xBD47 },
	{ 0xBD48,  0xBD48 },
	{ 0xBD49,  0xBD49 },
	{ 0xBD4A,  0xBD4A },
	{ 0xBD4B,  0xBD4B },
	{ 0xBD4C,  0xBD4C },
	{ 0xBD4D,  0xBD4D },
	{ 0xBD4E,  0xBD4E },
	{ 0xBD4F,  0xBD4F },
	{ 0xBD50,  0xBD50 },
	{ 0xBD51,  0xBD51 },
	{ 0xBD52,  0xBD52 },
	{ 0xBD53,  0xBD53 },
	{ 0xBD54,  0xBD54 },
	{ 0xBD55,  0xBD55 },
	{ 0xBD56,  0xBD56 },
	{ 0xBD57,  0xBD57 },
	{ 0xBD58,  0xBD58 },
	{ 0xBD59,  0xBD59 },
	{ 0xBD5A,  0xBD5A },
	{ 0xBD5B,  0xBD5B },
	{ 0xBD5C,  0xBD5C },
	{ 0xBD5D,  0xBD5D },
	{ 0xBD5E,  0xBD5E },
	{ 0xBD5F,  0xBD5F },
	{ 0xBD60,  0xBD60 },
	{ 0xBD61,  0xBD61 },
	{ 0xBD62,  0xBD62 },
	{ 0xBD63,  0xBD63 },
	{ 0xBD64,  0xBD64 },
	{ 0xBD65,  0xBD65 },
	{ 0xBD66,  0xBD66 },
	{ 0xBD67,  0xBD67 },
	{ 0xBD68,  0xBD68 },
	{ 0xBD69,  0xBD69 },
	{ 0xBD6A,  0xBD6A },
	{ 0xBD6B,  0xBD6B },
	{ 0xBD6C,  0xBD6C },
	{ 0xBD6D,  0xBD6D },
	{ 0xBD6E,  0xBD6E },
	{ 0xBD6F,  0xBD6F },
	{ 0xBD70,  0xBD70 },
	{ 0xBD71,  0xBD71 },
	{ 0xBD72,  0xBD72 },
	{ 0xBD73,  0xBD73 },
	{ 0xBD74,  0xBD74 },
	{ 0xBD75,  0xBD75 },
	{ 0xBD76,  0xBD76 },
	{ 0xBD77,  0xBD77 },
	{ 0xBD78,  0xBD78 },
	{ 0xBD79,  0xBD79 },
	{ 0xBD7A,  0xBD7A },
	{ 0xBD7B,  0xBD7B },
	{ 0xBD7C,  0xBD7C },
	{ 0xBD7D,  0xBD7D },
	{ 0xBD7E,  0xBD7E },
	{ 0xBDA1,  0xBDA1 },
	{ 0xBDA2,  0xBDA2 },
	{ 0xBDA3,  0xBDA3 },
	{ 0xBDA4,  0xBDA4 },
	{ 0xBDA5,  0xBDA5 },
	{ 0xBDA6,  0xBDA6 },
	{ 0xBDA7,  0xBDA7 },
	{ 0xBDA8,  0xBDA8 },
	{ 0xBDA9,  0xBDA9 },
	{ 0xBDAA,  0xBDAA },
	{ 0xBDAB,  0xBDAB },
	{ 0xBDAC,  0xBDAC },
	{ 0xBDAD,  0xBDAD },
	{ 0xBDAE,  0xBDAE },
	{ 0xBDAF,  0xBDAF },
	{ 0xBDB0,  0xBDB0 },
	{ 0xBDB1,  0xBDB1 },
	{ 0xBDB2,  0xBDB2 },
	{ 0xBDB3,  0xBDB3 },
	{ 0xBDB4,  0xBDB4 },
	{ 0xBDB5,  0xBDB5 },
	{ 0xBDB6,  0xBDB6 },
	{ 0xBDB7,  0xBDB7 },
	{ 0xBDB8,  0xBDB8 },
	{ 0xBDB9,  0xBDB9 },
	{ 0xBDBA,  0xBDBA },
	{ 0xBDBB,  0xBDBB },
	{ 0xBDBC,  0xBDBC },
	{ 0xBDBD,  0xBDBD },
	{ 0xBDBE,  0xBDBE },
	{ 0xBDBF,  0xBDBF },
	{ 0xBDC0,  0xBDC0 },
	{ 0xBDC1,  0xBDC1 },
	{ 0xBDC2,  0xBDC2 },
	{ 0xBDC3,  0xBDC3 },
	{ 0xBDC4,  0xBDC4 },
	{ 0xBDC5,  0xBDC5 },
	{ 0xBDC6,  0xBDC6 },
	{ 0xBDC7,  0xBDC7 },
	{ 0xBDC8,  0xBDC8 },
	{ 0xBDC9,  0xBDC9 },
	{ 0xBDCA,  0xBDCA },
	{ 0xBDCB,  0xBDCB },
	{ 0xBDCC,  0xBDCC },
	{ 0xBDCD,  0xBDCD },
	{ 0xBDCE,  0xBDCE },
	{ 0xBDCF,  0xBDCF },
	{ 0xBDD0,  0xBDD0 },
	{ 0xBDD1,  0xBDD1 },
	{ 0xBDD2,  0xBDD2 },
	{ 0xBDD3,  0xBDD3 },
	{ 0xBDD4,  0xBDD4 },
	{ 0xBDD5,  0xBDD5 },
	{ 0xBDD6,  0xBDD6 },
	{ 0xBDD7,  0xBDD7 },
	{ 0xBDD8,  0xBDD8 },
	{ 0xBDD9,  0xBDD9 },
	{ 0xBDDA,  0xBDDA },
	{ 0xBDDB,  0xBDDB },
	{ 0xBDDC,  0xBDDC },
	{ 0xBDDD,  0xBDDD },
	{ 0xBDDE,  0xBDDE },
	{ 0xBDDF,  0xBDDF },
	{ 0xBDE0,  0xBDE0 },
	{ 0xBDE1,  0xBDE1 },
	{ 0xBDE2,  0xBDE2 },
	{ 0xBDE3,  0xBDE3 },
	{ 0xBDE4,  0xBDE4 },
	{ 0xBDE5,  0xBDE5 },
	{ 0xBDE6,  0xBDE6 },
	{ 0xBDE7,  0xBDE7 },
	{ 0xBDE8,  0xBDE8 },
	{ 0xBDE9,  0xBDE9 },
	{ 0xBDEA,  0xBDEA },
	{ 0xBDEB,  0xBDEB },
	{ 0xBDEC,  0xBDEC },
	{ 0xBDED,  0xBDED },
	{ 0xBDEE,  0xBDEE },
	{ 0xBDEF,  0xBDEF },
	{ 0xBDF0,  0xBDF0 },
	{ 0xBDF1,  0xBDF1 },
	{ 0xBDF2,  0xBDF2 },
	{ 0xBDF3,  0xBDF3 },
	{ 0xBDF4,  0xBDF4 },
	{ 0xBDF5,  0xBDF5 },
	{ 0xBDF6,  0xBDF6 },
	{ 0xBDF7,  0xBDF7 },
	{ 0xBDF8,  0xBDF8 },
	{ 0xBDF9,  0xBDF9 },
	{ 0xBDFA,  0xBDFA },
	{ 0xBDFB,  0xBDFB },
	{ 0xBDFC,  0xBDFC },
	{ 0xBDFD,  0xBDFD },
	{ 0xBDFE,  0xBDFE },
	{ 0xBE40,  0xBE40 },
	{ 0xBE41,  0xBE41 },
	{ 0xBE42,  0xBE42 },
	{ 0xBE43,  0xBE43 },
	{ 0xBE44,  0xBE44 },
	{ 0xBE45,  0xBE45 },
	{ 0xBE46,  0xBE46 },
	{ 0xBE47,  0xBE47 },
	{ 0xBE48,  0xBE48 },
	{ 0xBE49,  0xBE49 },
	{ 0xBE4A,  0xBE4A },
	{ 0xBE4B,  0xBE4B },
	{ 0xBE4C,  0xBE4C },
	{ 0xBE4D,  0xBE4D },
	{ 0xBE4E,  0xBE4E },
	{ 0xBE4F,  0xBE4F },
	{ 0xBE50,  0xBE50 },
	{ 0xBE51,  0xBE51 },
	{ 0xBE52,  0xBE52 },
	{ 0xBE53,  0xBE53 },
	{ 0xBE54,  0xBE54 },
	{ 0xBE55,  0xBE55 },
	{ 0xBE56,  0xBE56 },
	{ 0xBE57,  0xBE57 },
	{ 0xBE58,  0xBE58 },
	{ 0xBE59,  0xBE59 },
	{ 0xBE5A,  0xBE5A },
	{ 0xBE5B,  0xBE5B },
	{ 0xBE5C,  0xBE5C },
	{ 0xBE5D,  0xBE5D },
	{ 0xBE5E,  0xBE5E },
	{ 0xBE5F,  0xBE5F },
	{ 0xBE60,  0xBE60 },
	{ 0xBE61,  0xBE61 },
	{ 0xBE62,  0xBE62 },
	{ 0xBE63,  0xBE63 },
	{ 0xBE64,  0xBE64 },
	{ 0xBE65,  0xBE65 },
	{ 0xBE66,  0xBE66 },
	{ 0xBE67,  0xBE67 },
	{ 0xBE68,  0xBE68 },
	{ 0xBE69,  0xBE69 },
	{ 0xBE6A,  0xBE6A },
	{ 0xBE6B,  0xBE6B },
	{ 0xBE6C,  0xBE6C },
	{ 0xBE6D,  0xBE6D },
	{ 0xBE6E,  0xBE6E },
	{ 0xBE6F,  0xBE6F },
	{ 0xBE70,  0xBE70 },
	{ 0xBE71,  0xBE71 },
	{ 0xBE72,  0xBE72 },
	{ 0xBE73,  0xBE73 },
	{ 0xBE74,  0xBE74 },
	{ 0xBE75,  0xBE75 },
	{ 0xBE76,  0xBE76 },
	{ 0xBE77,  0xBE77 },
	{ 0xBE78,  0xBE78 },
	{ 0xBE79,  0xBE79 },
	{ 0xBE7A,  0xBE7A },
	{ 0xBE7B,  0xBE7B },
	{ 0xBE7C,  0xBE7C },
	{ 0xBE7D,  0xBE7D },
	{ 0xBE7E,  0xBE7E },
	{ 0xBEA1,  0xBEA1 },
	{ 0xBEA2,  0xBEA2 },
	{ 0xBEA3,  0xBEA3 },
	{ 0xBEA4,  0xBEA4 },
	{ 0xBEA5,  0xBEA5 },
	{ 0xBEA6,  0xBEA6 },
	{ 0xBEA7,  0xBEA7 },
	{ 0xBEA8,  0xBEA8 },
	{ 0xBEA9,  0xBEA9 },
	{ 0xBEAA,  0xBEAA },
	{ 0xBEAB,  0xBEAB },
	{ 0xBEAC,  0xBEAC },
	{ 0xBEAD,  0xBEAD },
	{ 0xBEAE,  0xBEAE },
	{ 0xBEAF,  0xBEAF },
	{ 0xBEB0,  0xBEB0 },
	{ 0xBEB1,  0xBEB1 },
	{ 0xBEB2,  0xBEB2 },
	{ 0xBEB3,  0xBEB3 },
	{ 0xBEB4,  0xBEB4 },
	{ 0xBEB5,  0xBEB5 },
	{ 0xBEB6,  0xBEB6 },
	{ 0xBEB7,  0xBEB7 },
	{ 0xBEB8,  0xBEB8 },
	{ 0xBEB9,  0xBEB9 },
	{ 0xBEBA,  0xBEBA },
	{ 0xBEBB,  0xBEBB },
	{ 0xBEBC,  0xBEBC },
	{ 0xBEBD,  0xBEBD },
	{ 0xBEBE,  0xBEBE },
	{ 0xBEBF,  0xBEBF },
	{ 0xBEC0,  0xBEC0 },
	{ 0xBEC1,  0xBEC1 },
	{ 0xBEC2,  0xBEC2 },
	{ 0xBEC3,  0xBEC3 },
	{ 0xBEC4,  0xBEC4 },
	{ 0xBEC5,  0xBEC5 },
	{ 0xBEC6,  0xBEC6 },
	{ 0xBEC7,  0xBEC7 },
	{ 0xBEC8,  0xBEC8 },
	{ 0xBEC9,  0xBEC9 },
	{ 0xBECA,  0xBECA },
	{ 0xBECB,  0xBECB },
	{ 0xBECC,  0xBECC },
	{ 0xBECD,  0xBECD },
	{ 0xBECE,  0xBECE },
	{ 0xBECF,  0xBECF },
	{ 0xBED0,  0xBED0 },
	{ 0xBED1,  0xBED1 },
	{ 0xBED2,  0xBED2 },
	{ 0xBED3,  0xBED3 },
	{ 0xBED4,  0xBED4 },
	{ 0xBED5,  0xBED5 },
	{ 0xBED6,  0xBED6 },
	{ 0xBED7,  0xBED7 },
	{ 0xBED8,  0xBED8 },
	{ 0xBED9,  0xBED9 },
	{ 0xBEDA,  0xBEDA },
	{ 0xBEDB,  0xBEDB },
	{ 0xBEDC,  0xBEDC },
	{ 0xBEDD,  0xBEDD },
	{ 0xBEDE,  0xBEDE },
	{ 0xBEDF,  0xBEDF },
	{ 0xBEE0,  0xBEE0 },
	{ 0xBEE1,  0xBEE1 },
	{ 0xBEE2,  0xBEE2 },
	{ 0xBEE3,  0xBEE3 },
	{ 0xBEE4,  0xBEE4 },
	{ 0xBEE5,  0xBEE5 },
	{ 0xBEE6,  0xBEE6 },
	{ 0xBEE7,  0xBEE7 },
	{ 0xBEE8,  0xBEE8 },
	{ 0xBEE9,  0xBEE9 },
	{ 0xBEEA,  0xBEEA },
	{ 0xBEEB,  0xBEEB },
	{ 0xBEEC,  0xBEEC },
	{ 0xBEED,  0xBEED },
	{ 0xBEEE,  0xBEEE },
	{ 0xBEEF,  0xBEEF },
	{ 0xBEF0,  0xBEF0 },
	{ 0xBEF1,  0xBEF1 },
	{ 0xBEF2,  0xBEF2 },
	{ 0xBEF3,  0xBEF3 },
	{ 0xBEF4,  0xBEF4 },
	{ 0xBEF5,  0xBEF5 },
	{ 0xBEF6,  0xBEF6 },
	{ 0xBEF7,  0xBEF7 },
	{ 0xBEF8,  0xBEF8 },
	{ 0xBEF9,  0xBEF9 },
	{ 0xBEFA,  0xBEFA },
	{ 0xBEFB,  0xBEFB },
	{ 0xBEFC,  0xBEFC },
	{ 0xBEFD,  0xBEFD },
	{ 0xBEFE,  0xBEFE },
	{ 0xBF40,  0xBF40 },
	{ 0xBF41,  0xBF41 },
	{ 0xBF42,  0xBF42 },
	{ 0xBF43,  0xBF43 },
	{ 0xBF44,  0xBF44 },
	{ 0xBF45,  0xBF45 },
	{ 0xBF46,  0xBF46 },
	{ 0xBF47,  0xBF47 },
	{ 0xBF48,  0xBF48 },
	{ 0xBF49,  0xBF49 },
	{ 0xBF4A,  0xBF4A },
	{ 0xBF4B,  0xBF4B },
	{ 0xBF4C,  0xBF4C },
	{ 0xBF4D,  0xBF4D },
	{ 0xBF4E,  0xBF4E },
	{ 0xBF4F,  0xBF4F },
	{ 0xBF50,  0xBF50 },
	{ 0xBF51,  0xBF51 },
	{ 0xBF52,  0xBF52 },
	{ 0xBF53,  0xBF53 },
	{ 0xBF54,  0xBF54 },
	{ 0xBF55,  0xBF55 },
	{ 0xBF56,  0xBF56 },
	{ 0xBF57,  0xBF57 },
	{ 0xBF58,  0xBF58 },
	{ 0xBF59,  0xBF59 },
	{ 0xBF5A,  0xBF5A },
	{ 0xBF5B,  0xBF5B },
	{ 0xBF5C,  0xBF5C },
	{ 0xBF5D,  0xBF5D },
	{ 0xBF5E,  0xBF5E },
	{ 0xBF5F,  0xBF5F },
	{ 0xBF60,  0xBF60 },
	{ 0xBF61,  0xBF61 },
	{ 0xBF62,  0xBF62 },
	{ 0xBF63,  0xBF63 },
	{ 0xBF64,  0xBF64 },
	{ 0xBF65,  0xBF65 },
	{ 0xBF66,  0xBF66 },
	{ 0xBF67,  0xBF67 },
	{ 0xBF68,  0xBF68 },
	{ 0xBF69,  0xBF69 },
	{ 0xBF6A,  0xBF6A },
	{ 0xBF6B,  0xBF6B },
	{ 0xBF6C,  0xBF6C },
	{ 0xBF6D,  0xBF6D },
	{ 0xBF6E,  0xBF6E },
	{ 0xBF6F,  0xBF6F },
	{ 0xBF70,  0xBF70 },
	{ 0xBF71,  0xBF71 },
	{ 0xBF72,  0xBF72 },
	{ 0xBF73,  0xBF73 },
	{ 0xBF74,  0xBF74 },
	{ 0xBF75,  0xBF75 },
	{ 0xBF76,  0xBF76 },
	{ 0xBF77,  0xBF77 },
	{ 0xBF78,  0xBF78 },
	{ 0xBF79,  0xBF79 },
	{ 0xBF7A,  0xBF7A },
	{ 0xBF7B,  0xBF7B },
	{ 0xBF7C,  0xBF7C },
	{ 0xBF7D,  0xBF7D },
	{ 0xBF7E,  0xBF7E },
	{ 0xBFA1,  0xBFA1 },
	{ 0xBFA2,  0xBFA2 },
	{ 0xBFA3,  0xBFA3 },
	{ 0xBFA4,  0xBFA4 },
	{ 0xBFA5,  0xBFA5 },
	{ 0xBFA6,  0xBFA6 },
	{ 0xBFA7,  0xBFA7 },
	{ 0xBFA8,  0xBFA8 },
	{ 0xBFA9,  0xBFA9 },
	{ 0xBFAA,  0xBFAA },
	{ 0xBFAB,  0xBFAB },
	{ 0xBFAC,  0xBFAC },
	{ 0xBFAD,  0xBFAD },
	{ 0xBFAE,  0xBFAE },
	{ 0xBFAF,  0xBFAF },
	{ 0xBFB0,  0xBFB0 },
	{ 0xBFB1,  0xBFB1 },
	{ 0xBFB2,  0xBFB2 },
	{ 0xBFB3,  0xBFB3 },
	{ 0xBFB4,  0xBFB4 },
	{ 0xBFB5,  0xBFB5 },
	{ 0xBFB6,  0xBFB6 },
	{ 0xBFB7,  0xBFB7 },
	{ 0xBFB8,  0xBFB8 },
	{ 0xBFB9,  0xBFB9 },
	{ 0xBFBA,  0xBFBA },
	{ 0xBFBB,  0xBFBB },
	{ 0xBFBC,  0xBFBC },
	{ 0xBFBD,  0xBFBD },
	{ 0xBFBE,  0xBFBE },
	{ 0xBFBF,  0xBFBF },
	{ 0xBFC0,  0xBFC0 },
	{ 0xBFC1,  0xBFC1 },
	{ 0xBFC2,  0xBFC2 },
	{ 0xBFC3,  0xBFC3 },
	{ 0xBFC4,  0xBFC4 },
	{ 0xBFC5,  0xBFC5 },
	{ 0xBFC6,  0xBFC6 },
	{ 0xBFC7,  0xBFC7 },
	{ 0xBFC8,  0xBFC8 },
	{ 0xBFC9,  0xBFC9 },
	{ 0xBFCA,  0xBFCA },
	{ 0xBFCB,  0xBFCB },
	{ 0xBFCC,  0xBFCC },
	{ 0xBFCD,  0xBFCD },
	{ 0xBFCE,  0xBFCE },
	{ 0xBFCF,  0xBFCF },
	{ 0xBFD0,  0xBFD0 },
	{ 0xBFD1,  0xBFD1 },
	{ 0xBFD2,  0xBFD2 },
	{ 0xBFD3,  0xBFD3 },
	{ 0xBFD4,  0xBFD4 },
	{ 0xBFD5,  0xBFD5 },
	{ 0xBFD6,  0xBFD6 },
	{ 0xBFD7,  0xBFD7 },
	{ 0xBFD8,  0xBFD8 },
	{ 0xBFD9,  0xBFD9 },
	{ 0xBFDA,  0xBFDA },
	{ 0xBFDB,  0xBFDB },
	{ 0xBFDC,  0xBFDC },
	{ 0xBFDD,  0xBFDD },
	{ 0xBFDE,  0xBFDE },
	{ 0xBFDF,  0xBFDF },
	{ 0xBFE0,  0xBFE0 },
	{ 0xBFE1,  0xBFE1 },
	{ 0xBFE2,  0xBFE2 },
	{ 0xBFE3,  0xBFE3 },
	{ 0xBFE4,  0xBFE4 },
	{ 0xBFE5,  0xBFE5 },
	{ 0xBFE6,  0xBFE6 },
	{ 0xBFE7,  0xBFE7 },
	{ 0xBFE8,  0xBFE8 },
	{ 0xBFE9,  0xBFE9 },
	{ 0xBFEA,  0xBFEA },
	{ 0xBFEB,  0xBFEB },
	{ 0xBFEC,  0xBFEC },
	{ 0xBFED,  0xBFED },
	{ 0xBFEE,  0xBFEE },
	{ 0xBFEF,  0xBFEF },
	{ 0xBFF0,  0xBFF0 },
	{ 0xBFF1,  0xBFF1 },
	{ 0xBFF2,  0xBFF2 },
	{ 0xBFF3,  0xBFF3 },
	{ 0xBFF4,  0xBFF4 },
	{ 0xBFF5,  0xBFF5 },
	{ 0xBFF6,  0xBFF6 },
	{ 0xBFF7,  0xBFF7 },
	{ 0xBFF8,  0xBFF8 },
	{ 0xBFF9,  0xBFF9 },
	{ 0xBFFA,  0xBFFA },
	{ 0xBFFB,  0xBFFB },
	{ 0xBFFC,  0xBFFC },
	{ 0xBFFD,  0xBFFD },
	{ 0xBFFE,  0xBFFE },
	{ 0xC040,  0xC040 },
	{ 0xC041,  0xC041 },
	{ 0xC042,  0xC042 },
	{ 0xC043,  0xC043 },
	{ 0xC044,  0xC044 },
	{ 0xC045,  0xC045 },
	{ 0xC046,  0xC046 },
	{ 0xC047,  0xC047 },
	{ 0xC048,  0xC048 },
	{ 0xC049,  0xC049 },
	{ 0xC04A,  0xC04A },
	{ 0xC04B,  0xC04B },
	{ 0xC04C,  0xC04C },
	{ 0xC04D,  0xC04D },
	{ 0xC04E,  0xC04E },
	{ 0xC04F,  0xC04F },
	{ 0xC050,  0xC050 },
	{ 0xC051,  0xC051 },
	{ 0xC052,  0xC052 },
	{ 0xC053,  0xC053 },
	{ 0xC054,  0xC054 },
	{ 0xC055,  0xC055 },
	{ 0xC056,  0xC056 },
	{ 0xC057,  0xC057 },
	{ 0xC058,  0xC058 },
	{ 0xC059,  0xC059 },
	{ 0xC05A,  0xC05A },
	{ 0xC05B,  0xC05B },
	{ 0xC05C,  0xC05C },
	{ 0xC05D,  0xC05D },
	{ 0xC05E,  0xC05E },
	{ 0xC05F,  0xC05F },
	{ 0xC060,  0xC060 },
	{ 0xC061,  0xC061 },
	{ 0xC062,  0xC062 },
	{ 0xC063,  0xC063 },
	{ 0xC064,  0xC064 },
	{ 0xC065,  0xC065 },
	{ 0xC066,  0xC066 },
	{ 0xC067,  0xC067 },
	{ 0xC068,  0xC068 },
	{ 0xC069,  0xC069 },
	{ 0xC06A,  0xC06A },
	{ 0xC06B,  0xC06B },
	{ 0xC06C,  0xC06C },
	{ 0xC06D,  0xC06D },
	{ 0xC06E,  0xC06E },
	{ 0xC06F,  0xC06F },
	{ 0xC070,  0xC070 },
	{ 0xC071,  0xC071 },
	{ 0xC072,  0xC072 },
	{ 0xC073,  0xC073 },
	{ 0xC074,  0xC074 },
	{ 0xC075,  0xC075 },
	{ 0xC076,  0xC076 },
	{ 0xC077,  0xC077 },
	{ 0xC078,  0xC078 },
	{ 0xC079,  0xC079 },
	{ 0xC07A,  0xC07A },
	{ 0xC07B,  0xC07B },
	{ 0xC07C,  0xC07C },
	{ 0xC07D,  0xC07D },
	{ 0xC07E,  0xC07E },
	{ 0xC0A1,  0xC0A1 },
	{ 0xC0A2,  0xC0A2 },
	{ 0xC0A3,  0xC0A3 },
	{ 0xC0A4,  0xC0A4 },
	{ 0xC0A5,  0xC0A5 },
	{ 0xC0A6,  0xC0A6 },
	{ 0xC0A7,  0xC0A7 },
	{ 0xC0A8,  0xC0A8 },
	{ 0xC0A9,  0xC0A9 },
	{ 0xC0AA,  0xC0AA },
	{ 0xC0AB,  0xC0AB },
	{ 0xC0AC,  0xC0AC },
	{ 0xC0AD,  0xC0AD },
	{ 0xC0AE,  0xC0AE },
	{ 0xC0AF,  0xC0AF },
	{ 0xC0B0,  0xC0B0 },
	{ 0xC0B1,  0xC0B1 },
	{ 0xC0B2,  0xC0B2 },
	{ 0xC0B3,  0xC0B3 },
	{ 0xC0B4,  0xC0B4 },
	{ 0xC0B5,  0xC0B5 },
	{ 0xC0B6,  0xC0B6 },
	{ 0xC0B7,  0xC0B7 },
	{ 0xC0B8,  0xC0B8 },
	{ 0xC0B9,  0xC0B9 },
	{ 0xC0BA,  0xC0BA },
	{ 0xC0BB,  0xC0BB },
	{ 0xC0BC,  0xC0BC },
	{ 0xC0BD,  0xC0BD },
	{ 0xC0BE,  0xC0BE },
	{ 0xC0BF,  0xC0BF },
	{ 0xC0C0,  0xC0C0 },
	{ 0xC0C1,  0xC0C1 },
	{ 0xC0C2,  0xC0C2 },
	{ 0xC0C3,  0xC0C3 },
	{ 0xC0C4,  0xC0C4 },
	{ 0xC0C5,  0xC0C5 },
	{ 0xC0C6,  0xC0C6 },
	{ 0xC0C7,  0xC0C7 },
	{ 0xC0C8,  0xC0C8 },
	{ 0xC0C9,  0xC0C9 },
	{ 0xC0CA,  0xC0CA },
	{ 0xC0CB,  0xC0CB },
	{ 0xC0CC,  0xC0CC },
	{ 0xC0CD,  0xC0CD },
	{ 0xC0CE,  0xC0CE },
	{ 0xC0CF,  0xC0CF },
	{ 0xC0D0,  0xC0D0 },
	{ 0xC0D1,  0xC0D1 },
	{ 0xC0D2,  0xC0D2 },
	{ 0xC0D3,  0xC0D3 },
	{ 0xC0D4,  0xC0D4 },
	{ 0xC0D5,  0xC0D5 },
	{ 0xC0D6,  0xC0D6 },
	{ 0xC0D7,  0xC0D7 },
	{ 0xC0D8,  0xC0D8 },
	{ 0xC0D9,  0xC0D9 },
	{ 0xC0DA,  0xC0DA },
	{ 0xC0DB,  0xC0DB },
	{ 0xC0DC,  0xC0DC },
	{ 0xC0DD,  0xC0DD },
	{ 0xC0DE,  0xC0DE },
	{ 0xC0DF,  0xC0DF },
	{ 0xC0E0,  0xC0E0 },
	{ 0xC0E1,  0xC0E1 },
	{ 0xC0E2,  0xC0E2 },
	{ 0xC0E3,  0xC0E3 },
	{ 0xC0E4,  0xC0E4 },
	{ 0xC0E5,  0xC0E5 },
	{ 0xC0E6,  0xC0E6 },
	{ 0xC0E7,  0xC0E7 },
	{ 0xC0E8,  0xC0E8 },
	{ 0xC0E9,  0xC0E9 },
	{ 0xC0EA,  0xC0EA },
	{ 0xC0EB,  0xC0EB },
	{ 0xC0EC,  0xC0EC },
	{ 0xC0ED,  0xC0ED },
	{ 0xC0EE,  0xC0EE },
	{ 0xC0EF,  0xC0EF },
	{ 0xC0F0,  0xC0F0 },
	{ 0xC0F1,  0xC0F1 },
	{ 0xC0F2,  0xC0F2 },
	{ 0xC0F3,  0xC0F3 },
	{ 0xC0F4,  0xC0F4 },
	{ 0xC0F5,  0xC0F5 },
	{ 0xC0F6,  0xC0F6 },
	{ 0xC0F7,  0xC0F7 },
	{ 0xC0F8,  0xC0F8 },
	{ 0xC0F9,  0xC0F9 },
	{ 0xC0FA,  0xC0FA },
	{ 0xC0FB,  0xC0FB },
	{ 0xC0FC,  0xC0FC },
	{ 0xC0FD,  0xC0FD },
	{ 0xC0FE,  0xC0FE },
	{ 0xC140,  0xC140 },
	{ 0xC141,  0xC141 },
	{ 0xC142,  0xC142 },
	{ 0xC143,  0xC143 },
	{ 0xC144,  0xC144 },
	{ 0xC145,  0xC145 },
	{ 0xC146,  0xC146 },
	{ 0xC147,  0xC147 },
	{ 0xC148,  0xC148 },
	{ 0xC149,  0xC149 },
	{ 0xC14A,  0xC14A },
	{ 0xC14B,  0xC14B },
	{ 0xC14C,  0xC14C },
	{ 0xC14D,  0xC14D },
	{ 0xC14E,  0xC14E },
	{ 0xC14F,  0xC14F },
	{ 0xC150,  0xC150 },
	{ 0xC151,  0xC151 },
	{ 0xC152,  0xC152 },
	{ 0xC153,  0xC153 },
	{ 0xC154,  0xC154 },
	{ 0xC155,  0xC155 },
	{ 0xC156,  0xC156 },
	{ 0xC157,  0xC157 },
	{ 0xC158,  0xC158 },
	{ 0xC159,  0xC159 },
	{ 0xC15A,  0xC15A },
	{ 0xC15B,  0xC15B },
	{ 0xC15C,  0xC15C },
	{ 0xC15D,  0xC15D },
	{ 0xC15E,  0xC15E },
	{ 0xC15F,  0xC15F },
	{ 0xC160,  0xC160 },
	{ 0xC161,  0xC161 },
	{ 0xC162,  0xC162 },
	{ 0xC163,  0xC163 },
	{ 0xC164,  0xC164 },
	{ 0xC165,  0xC165 },
	{ 0xC166,  0xC166 },
	{ 0xC167,  0xC167 },
	{ 0xC168,  0xC168 },
	{ 0xC169,  0xC169 },
	{ 0xC16A,  0xC16A },
	{ 0xC16B,  0xC16B },
	{ 0xC16C,  0xC16C },
	{ 0xC16D,  0xC16D },
	{ 0xC16E,  0xC16E },
	{ 0xC16F,  0xC16F },
	{ 0xC170,  0xC170 },
	{ 0xC171,  0xC171 },
	{ 0xC172,  0xC172 },
	{ 0xC173,  0xC173 },
	{ 0xC174,  0xC174 },
	{ 0xC175,  0xC175 },
	{ 0xC176,  0xC176 },
	{ 0xC177,  0xC177 },
	{ 0xC178,  0xC178 },
	{ 0xC179,  0xC179 },
	{ 0xC17A,  0xC17A },
	{ 0xC17B,  0xC17B },
	{ 0xC17C,  0xC17C },
	{ 0xC17D,  0xC17D },
	{ 0xC17E,  0xC17E },
	{ 0xC1A1,  0xC1A1 },
	{ 0xC1A2,  0xC1A2 },
	{ 0xC1A3,  0xC1A3 },
	{ 0xC1A4,  0xC1A4 },
	{ 0xC1A5,  0xC1A5 },
	{ 0xC1A6,  0xC1A6 },
	{ 0xC1A7,  0xC1A7 },
	{ 0xC1A8,  0xC1A8 },
	{ 0xC1A9,  0xC1A9 },
	{ 0xC1AA,  0xC1AA },
	{ 0xC1AB,  0xC1AB },
	{ 0xC1AC,  0xC1AC },
	{ 0xC1AD,  0xC1AD },
	{ 0xC1AE,  0xC1AE },
	{ 0xC1AF,  0xC1AF },
	{ 0xC1B0,  0xC1B0 },
	{ 0xC1B1,  0xC1B1 },
	{ 0xC1B2,  0xC1B2 },
	{ 0xC1B3,  0xC1B3 },
	{ 0xC1B4,  0xC1B4 },
	{ 0xC1B5,  0xC1B5 },
	{ 0xC1B6,  0xC1B6 },
	{ 0xC1B7,  0xC1B7 },
	{ 0xC1B8,  0xC1B8 },
	{ 0xC1B9,  0xC1B9 },
	{ 0xC1BA,  0xC1BA },
	{ 0xC1BB,  0xC1BB },
	{ 0xC1BC,  0xC1BC },
	{ 0xC1BD,  0xC1BD },
	{ 0xC1BE,  0xC1BE },
	{ 0xC1BF,  0xC1BF },
	{ 0xC1C0,  0xC1C0 },
	{ 0xC1C1,  0xC1C1 },
	{ 0xC1C2,  0xC1C2 },
	{ 0xC1C3,  0xC1C3 },
	{ 0xC1C4,  0xC1C4 },
	{ 0xC1C5,  0xC1C5 },
	{ 0xC1C6,  0xC1C6 },
	{ 0xC1C7,  0xC1C7 },
	{ 0xC1C8,  0xC1C8 },
	{ 0xC1C9,  0xC1C9 },
	{ 0xC1CA,  0xC1CA },
	{ 0xC1CB,  0xC1CB },
	{ 0xC1CC,  0xC1CC },
	{ 0xC1CD,  0xC1CD },
	{ 0xC1CE,  0xC1CE },
	{ 0xC1CF,  0xC1CF },
	{ 0xC1D0,  0xC1D0 },
	{ 0xC1D1,  0xC1D1 },
	{ 0xC1D2,  0xC1D2 },
	{ 0xC1D3,  0xC1D3 },
	{ 0xC1D4,  0xC1D4 },
	{ 0xC1D5,  0xC1D5 },
	{ 0xC1D6,  0xC1D6 },
	{ 0xC1D7,  0xC1D7 },
	{ 0xC1D8,  0xC1D8 },
	{ 0xC1D9,  0xC1D9 },
	{ 0xC1DA,  0xC1DA },
	{ 0xC1DB,  0xC1DB },
	{ 0xC1DC,  0xC1DC },
	{ 0xC1DD,  0xC1DD },
	{ 0xC1DE,  0xC1DE },
	{ 0xC1DF,  0xC1DF },
	{ 0xC1E0,  0xC1E0 },
	{ 0xC1E1,  0xC1E1 },
	{ 0xC1E2,  0xC1E2 },
	{ 0xC1E3,  0xC1E3 },
	{ 0xC1E4,  0xC1E4 },
	{ 0xC1E5,  0xC1E5 },
	{ 0xC1E6,  0xC1E6 },
	{ 0xC1E7,  0xC1E7 },
	{ 0xC1E8,  0xC1E8 },
	{ 0xC1E9,  0xC1E9 },
	{ 0xC1EA,  0xC1EA },
	{ 0xC1EB,  0xC1EB },
	{ 0xC1EC,  0xC1EC },
	{ 0xC1ED,  0xC1ED },
	{ 0xC1EE,  0xC1EE },
	{ 0xC1EF,  0xC1EF },
	{ 0xC1F0,  0xC1F0 },
	{ 0xC1F1,  0xC1F1 },
	{ 0xC1F2,  0xC1F2 },
	{ 0xC1F3,  0xC1F3 },
	{ 0xC1F4,  0xC1F4 },
	{ 0xC1F5,  0xC1F5 },
	{ 0xC1F6,  0xC1F6 },
	{ 0xC1F7,  0xC1F7 },
	{ 0xC1F8,  0xC1F8 },
	{ 0xC1F9,  0xC1F9 },
	{ 0xC1FA,  0xC1FA },
	{ 0xC1FB,  0xC1FB },
	{ 0xC1FC,  0xC1FC },
	{ 0xC1FD,  0xC1FD },
	{ 0xC1FE,  0xC1FE },
	{ 0xC240,  0xC240 },
	{ 0xC241,  0xC241 },
	{ 0xC242,  0xC242 },
	{ 0xC243,  0xC243 },
	{ 0xC244,  0xC244 },
	{ 0xC245,  0xC245 },
	{ 0xC246,  0xC246 },
	{ 0xC247,  0xC247 },
	{ 0xC248,  0xC248 },
	{ 0xC249,  0xC249 },
	{ 0xC24A,  0xC24A },
	{ 0xC24B,  0xC24B },
	{ 0xC24C,  0xC24C },
	{ 0xC24D,  0xC24D },
	{ 0xC24E,  0xC24E },
	{ 0xC24F,  0xC24F },
	{ 0xC250,  0xC250 },
	{ 0xC251,  0xC251 },
	{ 0xC252,  0xC252 },
	{ 0xC253,  0xC253 },
	{ 0xC254,  0xC254 },
	{ 0xC255,  0xE394 },
	{ 0xC256,  0xC256 },
	{ 0xC257,  0xC257 },
	{ 0xC258,  0xC258 },
	{ 0xC259,  0xC259 },
	{ 0xC25A,  0xC25A },
	{ 0xC25B,  0xC25B },
	{ 0xC25C,  0xC25C },
	{ 0xC25D,  0xC25D },
	{ 0xC25E,  0xC25E },
	{ 0xC25F,  0xC25F },
	{ 0xC260,  0xC260 },
	{ 0xC261,  0xC261 },
	{ 0xC262,  0xC262 },
	{ 0xC263,  0xC263 },
	{ 0xC264,  0xC264 },
	{ 0xC265,  0xC265 },
	{ 0xC266,  0xC266 },
	{ 0xC267,  0xC267 },
	{ 0xC268,  0xC268 },
	{ 0xC269,  0xC269 },
	{ 0xC26A,  0xC26A },
	{ 0xC26B,  0xC26B },
	{ 0xC26C,  0xC26C },
	{ 0xC26D,  0xC26D },
	{ 0xC26E,  0xC26E },
	{ 0xC26F,  0xC26F },
	{ 0xC270,  0xC270 },
	{ 0xC271,  0xC271 },
	{ 0xC272,  0xC272 },
	{ 0xC273,  0xC273 },
	{ 0xC274,  0xC274 },
	{ 0xC275,  0xC275 },
	{ 0xC276,  0xC276 },
	{ 0xC277,  0xC277 },
	{ 0xC278,  0xC278 },
	{ 0xC279,  0xC279 },
	{ 0xC27A,  0xC27A },
	{ 0xC27B,  0xC27B },
	{ 0xC27C,  0xC27C },
	{ 0xC27D,  0xC27D },
	{ 0xC27E,  0xC27E },
	{ 0xC2A1,  0xC2A1 },
	{ 0xC2A2,  0xC2A2 },
	{ 0xC2A3,  0xC2A3 },
	{ 0xC2A4,  0xC2A4 },
	{ 0xC2A5,  0xC2A5 },
	{ 0xC2A6,  0xC2A6 },
	{ 0xC2A7,  0xC2A7 },
	{ 0xC2A8,  0xC2A8 },
	{ 0xC2A9,  0xC2A9 },
	{ 0xC2AA,  0xC2AA },
	{ 0xC2AB,  0xC2AB },
	{ 0xC2AC,  0xC2AC },
	{ 0xC2AD,  0xC2AD },
	{ 0xC2AE,  0xC2AE },
	{ 0xC2AF,  0xC2AF },
	{ 0xC2B0,  0xC2B0 },
	{ 0xC2B1,  0xC2B1 },
	{ 0xC2B2,  0xC2B2 },
	{ 0xC2B3,  0xC2B3 },
	{ 0xC2B4,  0xC2B4 },
	{ 0xC2B5,  0xC2B5 },
	{ 0xC2B6,  0xC2B6 },
	{ 0xC2B7,  0xC2B7 },
	{ 0xC2B8,  0xC2B8 },
	{ 0xC2B9,  0xC2B9 },
	{ 0xC2BA,  0xC2BA },
	{ 0xC2BB,  0xC2BB },
	{ 0xC2BC,  0xC2BC },
	{ 0xC2BD,  0xC2BD },
	{ 0xC2BE,  0xC2BE },
	{ 0xC2BF,  0xC2BF },
	{ 0xC2C0,  0xC2C0 },
	{ 0xC2C1,  0xC2C1 },
	{ 0xC2C2,  0xC2C2 },
	{ 0xC2C3,  0xC2C3 },
	{ 0xC2C4,  0xC2C4 },
	{ 0xC2C5,  0xC2C5 },
	{ 0xC2C6,  0xC2C6 },
	{ 0xC2C7,  0xC2C7 },
	{ 0xC2C8,  0xC2C8 },
	{ 0xC2C9,  0xC2C9 },
	{ 0xC2CA,  0xC2CA },
	{ 0xC2CB,  0xC2CB },
	{ 0xC2CC,  0xC2CC },
	{ 0xC2CD,  0xC2CD },
	{ 0xC2CE,  0xC2CE },
	{ 0xC2CF,  0xC2CF },
	{ 0xC2D0,  0xC2D0 },
	{ 0xC2D1,  0xC2D1 },
	{ 0xC2D2,  0xC2D2 },
	{ 0xC2D3,  0xC2D3 },
	{ 0xC2D4,  0xC2D4 },
	{ 0xC2D5,  0xC2D5 },
	{ 0xC2D6,  0xC2D6 },
	{ 0xC2D7,  0xC2D7 },
	{ 0xC2D8,  0xC2D8 },
	{ 0xC2D9,  0xC2D9 },
	{ 0xC2DA,  0xC2DA },
	{ 0xC2DB,  0xC2DB },
	{ 0xC2DC,  0xC2DC },
	{ 0xC2DD,  0xC2DD },
	{ 0xC2DE,  0xC2DE },
	{ 0xC2DF,  0xC2DF },
	{ 0xC2E0,  0xC2E0 },
	{ 0xC2E1,  0xC2E1 },
	{ 0xC2E2,  0xC2E2 },
	{ 0xC2E3,  0xC2E3 },
	{ 0xC2E4,  0xC2E4 },
	{ 0xC2E5,  0xC2E5 },
	{ 0xC2E6,  0xC2E6 },
	{ 0xC2E7,  0xC2E7 },
	{ 0xC2E8,  0xC2E8 },
	{ 0xC2E9,  0xC2E9 },
	{ 0xC2EA,  0xC2EA },
	{ 0xC2EB,  0xC2EB },
	{ 0xC2EC,  0xC2EC },
	{ 0xC2ED,  0xC2ED },
	{ 0xC2EE,  0xC2EE },
	{ 0xC2EF,  0xC2EF },
	{ 0xC2F0,  0xC2F0 },
	{ 0xC2F1,  0xC2F1 },
	{ 0xC2F2,  0xC2F2 },
	{ 0xC2F3,  0xC2F3 },
	{ 0xC2F4,  0xC2F4 },
	{ 0xC2F5,  0xC2F5 },
	{ 0xC2F6,  0xC2F6 },
	{ 0xC2F7,  0xC2F7 },
	{ 0xC2F8,  0xC2F8 },
	{ 0xC2F9,  0xC2F9 },
	{ 0xC2FA,  0xC2FA },
	{ 0xC2FB,  0xC2FB },
	{ 0xC2FC,  0xC2FC },
	{ 0xC2FD,  0xC2FD },
	{ 0xC2FE,  0xC2FE },
	{ 0xC340,  0xC340 },
	{ 0xC341,  0xC341 },
	{ 0xC342,  0xC342 },
	{ 0xC343,  0xC343 },
	{ 0xC344,  0xC344 },
	{ 0xC345,  0xC345 },
	{ 0xC346,  0xC346 },
	{ 0xC347,  0xC347 },
	{ 0xC348,  0xC348 },
	{ 0xC349,  0xC349 },
	{ 0xC34A,  0xC34A },
	{ 0xC34B,  0xC34B },
	{ 0xC34C,  0xC34C },
	{ 0xC34D,  0xC34D },
	{ 0xC34E,  0xC34E },
	{ 0xC34F,  0xC34F },
	{ 0xC350,  0xC350 },
	{ 0xC351,  0xC351 },
	{ 0xC352,  0xC352 },
	{ 0xC353,  0xC353 },
	{ 0xC354,  0xC354 },
	{ 0xC355,  0xC355 },
	{ 0xC356,  0xC356 },
	{ 0xC357,  0xC357 },
	{ 0xC358,  0xC358 },
	{ 0xC359,  0xC359 },
	{ 0xC35A,  0xC35A },
	{ 0xC35B,  0xC35B },
	{ 0xC35C,  0xC35C },
	{ 0xC35D,  0xC35D },
	{ 0xC35E,  0xC35E },
	{ 0xC35F,  0xC35F },
	{ 0xC360,  0xC360 },
	{ 0xC361,  0xC361 },
	{ 0xC362,  0xC362 },
	{ 0xC363,  0xC363 },
	{ 0xC364,  0xC364 },
	{ 0xC365,  0xC365 },
	{ 0xC366,  0xC366 },
	{ 0xC367,  0xC367 },
	{ 0xC368,  0xC368 },
	{ 0xC369,  0xC369 },
	{ 0xC36A,  0xC36A },
	{ 0xC36B,  0xC36B },
	{ 0xC36C,  0xC36C },
	{ 0xC36D,  0xC36D },
	{ 0xC36E,  0xC36E },
	{ 0xC36F,  0xC36F },
	{ 0xC370,  0xC370 },
	{ 0xC371,  0xC371 },
	{ 0xC372,  0xC372 },
	{ 0xC373,  0xC373 },
	{ 0xC374,  0xC374 },
	{ 0xC375,  0xC375 },
	{ 0xC376,  0xC376 },
	{ 0xC377,  0xC377 },
	{ 0xC378,  0xC378 },
	{ 0xC379,  0xC379 },
	{ 0xC37A,  0xC37A },
	{ 0xC37B,  0xC37B },
	{ 0xC37C,  0xC37C },
	{ 0xC37D,  0xC37D },
	{ 0xC37E,  0xC37E },
	{ 0xC3A1,  0xC3A1 },
	{ 0xC3A2,  0xC3A2 },
	{ 0xC3A3,  0xC3A3 },
	{ 0xC3A4,  0xC3A4 },
	{ 0xC3A5,  0xC3A5 },
	{ 0xC3A6,  0xC3A6 },
	{ 0xC3A7,  0xC3A7 },
	{ 0xC3A8,  0xC3A8 },
	{ 0xC3A9,  0xC3A9 },
	{ 0xC3AA,  0xC3AA },
	{ 0xC3AB,  0xC3AB },
	{ 0xC3AC,  0xC3AC },
	{ 0xC3AD,  0xC3AD },
	{ 0xC3AE,  0xC3AE },
	{ 0xC3AF,  0xC3AF },
	{ 0xC3B0,  0xC3B0 },
	{ 0xC3B1,  0xC3B1 },
	{ 0xC3B2,  0xC3B2 },
	{ 0xC3B3,  0xC3B3 },
	{ 0xC3B4,  0xC3B4 },
	{ 0xC3B5,  0xC3B5 },
	{ 0xC3B6,  0xC3B6 },
	{ 0xC3B7,  0xC3B7 },
	{ 0xC3B8,  0xC3B8 },
	{ 0xC3B9,  0xC3B9 },
	{ 0xC3BA,  0xC3BA },
	{ 0xC3BB,  0xC3BB },
	{ 0xC3BC,  0xC3BC },
	{ 0xC3BD,  0xC3BD },
	{ 0xC3BE,  0xC3BE },
	{ 0xC3BF,  0xC3BF },
	{ 0xC3C0,  0xC3C0 },
	{ 0xC3C1,  0xC3C1 },
	{ 0xC3C2,  0xC3C2 },
	{ 0xC3C3,  0xC3C3 },
	{ 0xC3C4,  0xC3C4 },
	{ 0xC3C5,  0xC3C5 },
	{ 0xC3C6,  0xC3C6 },
	{ 0xC3C7,  0xC3C7 },
	{ 0xC3C8,  0xC3C8 },
	{ 0xC3C9,  0xC3C9 },
	{ 0xC3CA,  0xC3CA },
	{ 0xC3CB,  0xC3CB },
	{ 0xC3CC,  0xC3CC },
	{ 0xC3CD,  0xC3CD },
	{ 0xC3CE,  0xC3CE },
	{ 0xC3CF,  0xC3CF },
	{ 0xC3D0,  0xC3D0 },
	{ 0xC3D1,  0xC3D1 },
	{ 0xC3D2,  0xC3D2 },
	{ 0xC3D3,  0xC3D3 },
	{ 0xC3D4,  0xC3D4 },
	{ 0xC3D5,  0xC3D5 },
	{ 0xC3D6,  0xC3D6 },
	{ 0xC3D7,  0xC3D7 },
	{ 0xC3D8,  0xC3D8 },
	{ 0xC3D9,  0xC3D9 },
	{ 0xC3DA,  0xC3DA },
	{ 0xC3DB,  0xC3DB },
	{ 0xC3DC,  0xC3DC },
	{ 0xC3DD,  0xC3DD },
	{ 0xC3DE,  0xC3DE },
	{ 0xC3DF,  0xC3DF },
	{ 0xC3E0,  0xC3E0 },
	{ 0xC3E1,  0xC3E1 },
	{ 0xC3E2,  0xC3E2 },
	{ 0xC3E3,  0xC3E3 },
	{ 0xC3E4,  0xC3E4 },
	{ 0xC3E5,  0xC3E5 },
	{ 0xC3E6,  0xC3E6 },
	{ 0xC3E7,  0xC3E7 },
	{ 0xC3E8,  0xC3E8 },
	{ 0xC3E9,  0xC3E9 },
	{ 0xC3EA,  0xC3EA },
	{ 0xC3EB,  0xC3EB },
	{ 0xC3EC,  0xC3EC },
	{ 0xC3ED,  0xC3ED },
	{ 0xC3EE,  0xC3EE },
	{ 0xC3EF,  0xC3EF },
	{ 0xC3F0,  0xC3F0 },
	{ 0xC3F1,  0xC3F1 },
	{ 0xC3F2,  0xC3F2 },
	{ 0xC3F3,  0xC3F3 },
	{ 0xC3F4,  0xC3F4 },
	{ 0xC3F5,  0xC3F5 },
	{ 0xC3F6,  0xC3F6 },
	{ 0xC3F7,  0xC3F7 },
	{ 0xC3F8,  0xC3F8 },
	{ 0xC3F9,  0xC3F9 },
	{ 0xC3FA,  0xC3FA },
	{ 0xC3FB,  0xC3FB },
	{ 0xC3FC,  0xC3FC },
	{ 0xC3FD,  0xC3FD },
	{ 0xC3FE,  0xC3FE },
	{ 0xC440,  0xC440 },
	{ 0xC441,  0xC441 },
	{ 0xC442,  0xC442 },
	{ 0xC443,  0xC443 },
	{ 0xC444,  0xC444 },
	{ 0xC445,  0xC445 },
	{ 0xC446,  0xC446 },
	{ 0xC447,  0xC447 },
	{ 0xC448,  0xC448 },
	{ 0xC449,  0xC449 },
	{ 0xC44A,  0xC44A },
	{ 0xC44B,  0xC44B },
	{ 0xC44C,  0xC44C },
	{ 0xC44D,  0xC44D },
	{ 0xC44E,  0xC44E },
	{ 0xC44F,  0xC44F },
	{ 0xC450,  0xC450 },
	{ 0xC451,  0xC451 },
	{ 0xC452,  0xC452 },
	{ 0xC453,  0xC453 },
	{ 0xC454,  0xC454 },
	{ 0xC455,  0xC455 },
	{ 0xC456,  0xC456 },
	{ 0xC457,  0xC457 },
	{ 0xC458,  0xC458 },
	{ 0xC459,  0xC459 },
	{ 0xC45A,  0xC45A },
	{ 0xC45B,  0xC45B },
	{ 0xC45C,  0xC45C },
	{ 0xC45D,  0xC45D },
	{ 0xC45E,  0xC45E },
	{ 0xC45F,  0xC45F },
	{ 0xC460,  0xC460 },
	{ 0xC461,  0xC461 },
	{ 0xC462,  0xC462 },
	{ 0xC463,  0xC463 },
	{ 0xC464,  0xC464 },
	{ 0xC465,  0xC465 },
	{ 0xC466,  0xC466 },
	{ 0xC467,  0xC467 },
	{ 0xC468,  0xC468 },
	{ 0xC469,  0xC469 },
	{ 0xC46A,  0xC46A },
	{ 0xC46B,  0xC46B },
	{ 0xC46C,  0xC46C },
	{ 0xC46D,  0xC46D },
	{ 0xC46E,  0xC46E },
	{ 0xC46F,  0xC46F },
	{ 0xC470,  0xC470 },
	{ 0xC471,  0xC471 },
	{ 0xC472,  0xC472 },
	{ 0xC473,  0xC473 },
	{ 0xC474,  0xC474 },
	{ 0xC475,  0xC475 },
	{ 0xC476,  0xC476 },
	{ 0xC477,  0xC477 },
	{ 0xC478,  0xC478 },
	{ 0xC479,  0xC479 },
	{ 0xC47A,  0xC47A },
	{ 0xC47B,  0xC47B },
	{ 0xC47C,  0xC47C },
	{ 0xC47D,  0xC47D },
	{ 0xC47E,  0xC47E },
	{ 0xC4A1,  0xC4A1 },
	{ 0xC4A2,  0xC4A2 },
	{ 0xC4A3,  0xC4A3 },
	{ 0xC4A4,  0xC4A4 },
	{ 0xC4A5,  0xC4A5 },
	{ 0xC4A6,  0xC4A6 },
	{ 0xC4A7,  0xC4A7 },
	{ 0xC4A8,  0xC4A8 },
	{ 0xC4A9,  0xC4A9 },
	{ 0xC4AA,  0xC4AA },
	{ 0xC4AB,  0xC4AB },
	{ 0xC4AC,  0xC4AC },
	{ 0xC4AD,  0xC4AD },
	{ 0xC4AE,  0xC4AE },
	{ 0xC4AF,  0xC4AF },
	{ 0xC4B0,  0xC4B0 },
	{ 0xC4B1,  0xC4B1 },
	{ 0xC4B2,  0xC4B2 },
	{ 0xC4B3,  0xC4B3 },
	{ 0xC4B4,  0xC4B4 },
	{ 0xC4B5,  0xC4B5 },
	{ 0xC4B6,  0xC4B6 },
	{ 0xC4B7,  0xC4B7 },
	{ 0xC4B8,  0xC4B8 },
	{ 0xC4B9,  0xC4B9 },
	{ 0xC4BA,  0xC4BA },
	{ 0xC4BB,  0xC4BB },
	{ 0xC4BC,  0xC4BC },
	{ 0xC4BD,  0xC4BD },
	{ 0xC4BE,  0xC4BE },
	{ 0xC4BF,  0xC4BF },
	{ 0xC4C0,  0xC4C0 },
	{ 0xC4C1,  0xC4C1 },
	{ 0xC4C2,  0xC4C2 },
	{ 0xC4C3,  0xC4C3 },
	{ 0xC4C4,  0xC4C4 },
	{ 0xC4C5,  0xC4C5 },
	{ 0xC4C6,  0xC4C6 },
	{ 0xC4C7,  0xC4C7 },
	{ 0xC4C8,  0xC4C8 },
	{ 0xC4C9,  0xC4C9 },
	{ 0xC4CA,  0xC4CA },
	{ 0xC4CB,  0xC4CB },
	{ 0xC4CC,  0xC4CC },
	{ 0xC4CD,  0xC4CD },
	{ 0xC4CE,  0xC4CE },
	{ 0xC4CF,  0xC4CF },
	{ 0xC4D0,  0xC4D0 },
	{ 0xC4D1,  0xC4D1 },
	{ 0xC4D2,  0xC4D2 },
	{ 0xC4D3,  0xC4D3 },
	{ 0xC4D4,  0xC4D4 },
	{ 0xC4D5,  0xC4D5 },
	{ 0xC4D6,  0xC4D6 },
	{ 0xC4D7,  0xC4D7 },
	{ 0xC4D8,  0xC4D8 },
	{ 0xC4D9,  0xC4D9 },
	{ 0xC4DA,  0xC4DA },
	{ 0xC4DB,  0xC4DB },
	{ 0xC4DC,  0xC4DC },
	{ 0xC4DD,  0xC4DD },
	{ 0xC4DE,  0xC4DE },
	{ 0xC4DF,  0xC4DF },
	{ 0xC4E0,  0xC4E0 },
	{ 0xC4E1,  0xC4E1 },
	{ 0xC4E2,  0xC4E2 },
	{ 0xC4E3,  0xC4E3 },
	{ 0xC4E4,  0xC4E4 },
	{ 0xC4E5,  0xC4E5 },
	{ 0xC4E6,  0xC4E6 },
	{ 0xC4E7,  0xC4E7 },
	{ 0xC4E8,  0xC4E8 },
	{ 0xC4E9,  0xC4E9 },
	{ 0xC4EA,  0xC4EA },
	{ 0xC4EB,  0xC4EB },
	{ 0xC4EC,  0xC4EC },
	{ 0xC4ED,  0xC4ED },
	{ 0xC4EE,  0xC4EE },
	{ 0xC4EF,  0xC4EF },
	{ 0xC4F0,  0xC4F0 },
	{ 0xC4F1,  0xC4F1 },
	{ 0xC4F2,  0xC4F2 },
	{ 0xC4F3,  0xC4F3 },
	{ 0xC4F4,  0xC4F4 },
	{ 0xC4F5,  0xC4F5 },
	{ 0xC4F6,  0xC4F6 },
	{ 0xC4F7,  0xC4F7 },
	{ 0xC4F8,  0xC4F8 },
	{ 0xC4F9,  0xC4F9 },
	{ 0xC4FA,  0xC4FA },
	{ 0xC4FB,  0xC4FB },
	{ 0xC4FC,  0xC4FC },
	{ 0xC4FD,  0xC4FD },
	{ 0xC4FE,  0xC4FE },
	{ 0xC540,  0xC540 },
	{ 0xC541,  0xC541 },
	{ 0xC542,  0xC542 },
	{ 0xC543,  0xC543 },
	{ 0xC544,  0xC544 },
	{ 0xC545,  0xC545 },
	{ 0xC546,  0xC546 },
	{ 0xC547,  0xC547 },
	{ 0xC548,  0xC548 },
	{ 0xC549,  0xC549 },
	{ 0xC54A,  0xC54A },
	{ 0xC54B,  0xC54B },
	{ 0xC54C,  0xC54C },
	{ 0xC54D,  0xC54D },
	{ 0xC54E,  0xC54E },
	{ 0xC54F,  0xC54F },
	{ 0xC550,  0xC550 },
	{ 0xC551,  0xC551 },
	{ 0xC552,  0xC552 },
	{ 0xC553,  0xC553 },
	{ 0xC554,  0xC554 },
	{ 0xC555,  0xC555 },
	{ 0xC556,  0xC556 },
	{ 0xC557,  0xC557 },
	{ 0xC558,  0xC558 },
	{ 0xC559,  0xC559 },
	{ 0xC55A,  0xC55A },
	{ 0xC55B,  0xC55B },
	{ 0xC55C,  0xC55C },
	{ 0xC55D,  0xC55D },
	{ 0xC55E,  0xC55E },
	{ 0xC55F,  0xC55F },
	{ 0xC560,  0xC560 },
	{ 0xC561,  0xC561 },
	{ 0xC562,  0xC562 },
	{ 0xC563,  0xC563 },
	{ 0xC564,  0xC564 },
	{ 0xC565,  0xC565 },
	{ 0xC566,  0xC566 },
	{ 0xC567,  0xC567 },
	{ 0xC568,  0xC568 },
	{ 0xC569,  0xC569 },
	{ 0xC56A,  0xC56A },
	{ 0xC56B,  0xC56B },
	{ 0xC56C,  0xC56C },
	{ 0xC56D,  0xC56D },
	{ 0xC56E,  0xC56E },
	{ 0xC56F,  0xC56F },
	{ 0xC570,  0xC570 },
	{ 0xC571,  0xC571 },
	{ 0xC572,  0xC572 },
	{ 0xC573,  0xC573 },
	{ 0xC574,  0xC574 },
	{ 0xC575,  0xC575 },
	{ 0xC576,  0xC576 },
	{ 0xC577,  0xC577 },
	{ 0xC578,  0xC578 },
	{ 0xC579,  0xC579 },
	{ 0xC57A,  0xC57A },
	{ 0xC57B,  0xC57B },
	{ 0xC57C,  0xC57C },
	{ 0xC57D,  0xC57D },
	{ 0xC57E,  0xC57E },
	{ 0xC5A1,  0xC5A1 },
	{ 0xC5A2,  0xC5A2 },
	{ 0xC5A3,  0xC5A3 },
	{ 0xC5A4,  0xC5A4 },
	{ 0xC5A5,  0xC5A5 },
	{ 0xC5A6,  0xC5A6 },
	{ 0xC5A7,  0xC5A7 },
	{ 0xC5A8,  0xC5A8 },
	{ 0xC5A9,  0xC5A9 },
	{ 0xC5AA,  0xC5AA },
	{ 0xC5AB,  0xC5AB },
	{ 0xC5AC,  0xC5AC },
	{ 0xC5AD,  0xC5AD },
	{ 0xC5AE,  0xC5AE },
	{ 0xC5AF,  0xC5AF },
	{ 0xC5B0,  0xC5B0 },
	{ 0xC5B1,  0xC5B1 },
	{ 0xC5B2,  0xC5B2 },
	{ 0xC5B3,  0xC5B3 },
	{ 0xC5B4,  0xC5B4 },
	{ 0xC5B5,  0xC5B5 },
	{ 0xC5B6,  0xC5B6 },
	{ 0xC5B7,  0xC5B7 },
	{ 0xC5B8,  0xC5B8 },
	{ 0xC5B9,  0xC5B9 },
	{ 0xC5BA,  0xC5BA },
	{ 0xC5BB,  0xC5BB },
	{ 0xC5BC,  0xC5BC },
	{ 0xC5BD,  0xC5BD },
	{ 0xC5BE,  0xC5BE },
	{ 0xC5BF,  0xC5BF },
	{ 0xC5C0,  0xC5C0 },
	{ 0xC5C1,  0xC5C1 },
	{ 0xC5C2,  0xC5C2 },
	{ 0xC5C3,  0xC5C3 },
	{ 0xC5C4,  0xC5C4 },
	{ 0xC5C5,  0xC5C5 },
	{ 0xC5C6,  0xC5C6 },
	{ 0xC5C7,  0xC5C7 },
	{ 0xC5C8,  0xC5C8 },
	{ 0xC5C9,  0xC5C9 },
	{ 0xC5CA,  0xC5CA },
	{ 0xC5CB,  0xC5CB },
	{ 0xC5CC,  0xC5CC },
	{ 0xC5CD,  0xC5CD },
	{ 0xC5CE,  0xC5CE },
	{ 0xC5CF,  0xC5CF },
	{ 0xC5D0,  0xC5D0 },
	{ 0xC5D1,  0xC5D1 },
	{ 0xC5D2,  0xC5D2 },
	{ 0xC5D3,  0xC5D3 },
	{ 0xC5D4,  0xC5D4 },
	{ 0xC5D5,  0xC5D5 },
	{ 0xC5D6,  0xC5D6 },
	{ 0xC5D7,  0xC5D7 },
	{ 0xC5D8,  0xC5D8 },
	{ 0xC5D9,  0xC5D9 },
	{ 0xC5DA,  0xC5DA },
	{ 0xC5DB,  0xC5DB },
	{ 0xC5DC,  0xC5DC },
	{ 0xC5DD,  0xC5DD },
	{ 0xC5DE,  0xC5DE },
	{ 0xC5DF,  0xC5DF },
	{ 0xC5E0,  0xC5E0 },
	{ 0xC5E1,  0xC5E1 },
	{ 0xC5E2,  0xC5E2 },
	{ 0xC5E3,  0xC5E3 },
	{ 0xC5E4,  0xC5E4 },
	{ 0xC5E5,  0xC5E5 },
	{ 0xC5E6,  0xC5E6 },
	{ 0xC5E7,  0xC5E7 },
	{ 0xC5E8,  0xC5E8 },
	{ 0xC5E9,  0xC5E9 },
	{ 0xC5EA,  0xC5EA },
	{ 0xC5EB,  0xC5EB },
	{ 0xC5EC,  0xC5EC },
	{ 0xC5ED,  0xC5ED },
	{ 0xC5EE,  0xC5EE },
	{ 0xC5EF,  0xC5EF },
	{ 0xC5F0,  0xC5F0 },
	{ 0xC5F1,  0xC5F1 },
	{ 0xC5F2,  0xC5F2 },
	{ 0xC5F3,  0xC5F3 },
	{ 0xC5F4,  0xC5F4 },
	{ 0xC5F5,  0xC5F5 },
	{ 0xC5F6,  0xC5F6 },
	{ 0xC5F7,  0xC5F7 },
	{ 0xC5F8,  0xC5F8 },
	{ 0xC5F9,  0xC5F9 },
	{ 0xC5FA,  0xC5FA },
	{ 0xC5FB,  0xC5FB },
	{ 0xC5FC,  0xC5FC },
	{ 0xC5FD,  0xC5FD },
	{ 0xC5FE,  0xC5FE },
	{ 0xC640,  0xC640 },
	{ 0xC641,  0xC641 },
	{ 0xC642,  0xC642 },
	{ 0xC643,  0xC643 },
	{ 0xC644,  0xC644 },
	{ 0xC645,  0xC645 },
	{ 0xC646,  0xC646 },
	{ 0xC647,  0xC647 },
	{ 0xC648,  0xC648 },
	{ 0xC649,  0xC649 },
	{ 0xC64A,  0xC64A },
	{ 0xC64B,  0xC64B },
	{ 0xC64C,  0xC64C },
	{ 0xC64D,  0xC64D },
	{ 0xC64E,  0xC64E },
	{ 0xC64F,  0xC64F },
	{ 0xC650,  0xC650 },
	{ 0xC651,  0xC651 },
	{ 0xC652,  0xC652 },
	{ 0xC653,  0xC653 },
	{ 0xC654,  0xC654 },
	{ 0xC655,  0xC655 },
	{ 0xC656,  0xC656 },
	{ 0xC657,  0xC657 },
	{ 0xC658,  0xC658 },
	{ 0xC659,  0xC659 },
	{ 0xC65A,  0xC65A },
	{ 0xC65B,  0xC65B },
	{ 0xC65C,  0xC65C },
	{ 0xC65D,  0xC65D },
	{ 0xC65E,  0xC65E },
	{ 0xC65F,  0xC65F },
	{ 0xC660,  0xC660 },
	{ 0xC661,  0xC661 },
	{ 0xC662,  0xC662 },
	{ 0xC663,  0xC663 },
	{ 0xC664,  0xC664 },
	{ 0xC665,  0xC665 },
	{ 0xC666,  0xC666 },
	{ 0xC667,  0xC667 },
	{ 0xC668,  0xC668 },
	{ 0xC669,  0xC669 },
	{ 0xC66A,  0xC66A },
	{ 0xC66B,  0xC66B },
	{ 0xC66C,  0xC66C },
	{ 0xC66D,  0xC66D },
	{ 0xC66E,  0xC66E },
	{ 0xC66F,  0xC66F },
	{ 0xC670,  0xC670 },
	{ 0xC671,  0xC671 },
	{ 0xC672,  0xC672 },
	{ 0xC673,  0xC673 },
	{ 0xC674,  0xC674 },
	{ 0xC675,  0xC675 },
	{ 0xC676,  0xC676 },
	{ 0xC677,  0xC677 },
	{ 0xC678,  0xC678 },
	{ 0xC679,  0xC679 },
	{ 0xC67A,  0xC67A },
	{ 0xC67B,  0xC67B },
	{ 0xC67C,  0xC67C },
	{ 0xC67D,  0xC67D },
	{ 0xC67E,  0xC67E },
	{ 0xC6A1,  0xC6A1 },
	{ 0xC6A2,  0xC6A2 },
	{ 0xC6A3,  0xC6A3 },
	{ 0xC6A4,  0xC6A4 },
	{ 0xC6A5,  0xC6A5 },
	{ 0xC6A6,  0xC6A6 },
	{ 0xC6A7,  0xC6A7 },
	{ 0xC6A8,  0xC6A8 },
	{ 0xC6A9,  0xC6A9 },
	{ 0xC6AA,  0xC6AA },
	{ 0xC6AB,  0xC6AB },
	{ 0xC6AC,  0xC6AC },
	{ 0xC6AD,  0xC6AD },
	{ 0xC6AE,  0xC6AE },
	{ 0xC6AF,  0xC6AF },
	{ 0xC6B0,  0xC6B0 },
	{ 0xC6B1,  0xC6B1 },
	{ 0xC6B2,  0xC6B2 },
	{ 0xC6B3,  0xC6B3 },
	{ 0xC6B4,  0xC6B4 },
	{ 0xC6B5,  0xC6B5 },
	{ 0xC6B6,  0xC6B6 },
	{ 0xC6B7,  0xC6B7 },
	{ 0xC6B8,  0xC6B8 },
	{ 0xC6B9,  0xC6B9 },
	{ 0xC6BA,  0xC6BA },
	{ 0xC6BB,  0xC6BB },
	{ 0xC6BC,  0xC6BC },
	{ 0xC6BD,  0xC6BD },
	{ 0xC6BE,  0xC6BE },
	{ 0xC6BF,  0xC6BF },
	{ 0xC6C0,  0xC6C0 },
	{ 0xC6C1,  0xC6C1 },
	{ 0xC6C2,  0xC6C2 },
	{ 0xC6C3,  0xC6C3 },
	{ 0xC6C4,  0xC6C4 },
	{ 0xC6C5,  0xC6C5 },
	{ 0xC6C6,  0xC6C6 },
	{ 0xC6C7,  0xC6C7 },
	{ 0xC6C8,  0xC6C8 },
	{ 0xC6C9,  0xC6C9 },
	{ 0xC6CA,  0xC6CA },
	{ 0xC6CB,  0xC6CB },
	{ 0xC6CC,  0xC6CC },
	{ 0xC6CE,  0xC6CE },
	{ 0xC6D0,  0xC6D0 },
	{ 0xC6D1,  0xC6D1 },
	{ 0xC6D2,  0xC6D2 },
	{ 0xC6D4,  0xC6D4 },
	{ 0xC6D6,  0xC6D6 },
	{ 0xC6DA,  0xC6DA },
	{ 0xC6DB,  0xC6DB },
	{ 0xC6DC,  0xC6DC },
	{ 0xC6DD,  0xC6DD },
	{ 0xC6E2,  0xC6E2 },
	{ 0xC6E3,  0xC6E3 },
	{ 0xC6E4,  0xC6E4 },
	{ 0xC6E5,  0xC6E5 },
	{ 0xC6E7,  0xC6E7 },
	{ 0xC6E8,  0xC6E8 },
	{ 0xC6E9,  0xC6E9 },
	{ 0xC6EA,  0xC6EA },
	{ 0xC6EB,  0xC6EB },
	{ 0xC6EC,  0xC6EC },
	{ 0xC6ED,  0xC6ED },
	{ 0xC6EE,  0xC6EE },
	{ 0xC6EF,  0xC6EF },
	{ 0xC6F0,  0xC6F0 },
	{ 0xC6F1,  0xC6F1 },
	{ 0xC6F2,  0xC6F2 },
	{ 0xC6F3,  0xC6F3 },
	{ 0xC6F4,  0xC6F4 },
	{ 0xC6F5,  0xC6F5 },
	{ 0xC6F6,  0xC6F6 },
	{ 0xC6F7,  0xC6F7 },
	{ 0xC6F8,  0xC6F8 },
	{ 0xC6F9,  0xC6F9 },
	{ 0xC6FA,  0xC6FA },
	{ 0xC6FB,  0xC6FB },
	{ 0xC6FC,  0xC6FC },
	{ 0xC6FD,  0xC6FD },
	{ 0xC6FE,  0xC6FE },
	{ 0xC740,  0xC740 },
	{ 0xC741,  0xC741 },
	{ 0xC742,  0xC742 },
	{ 0xC743,  0xC743 },
	{ 0xC744,  0xC744 },
	{ 0xC745,  0xC745 },
	{ 0xC746,  0xC746 },
	{ 0xC747,  0xC747 },
	{ 0xC748,  0xC748 },
	{ 0xC749,  0xC749 },
	{ 0xC74A,  0xC74A },
	{ 0xC74B,  0xC74B },
	{ 0xC74C,  0xC74C },
	{ 0xC74D,  0xC74D },
	{ 0xC74E,  0xC74E },
	{ 0xC74F,  0xC74F },
	{ 0xC750,  0xC750 },
	{ 0xC751,  0xC751 },
	{ 0xC752,  0xC752 },
	{ 0xC753,  0xC753 },
	{ 0xC754,  0xC754 },
	{ 0xC755,  0xC755 },
	{ 0xC756,  0xC756 },
	{ 0xC757,  0xC757 },
	{ 0xC758,  0xC758 },
	{ 0xC759,  0xC759 },
	{ 0xC75A,  0xC75A },
	{ 0xC75B,  0xC75B },
	{ 0xC75C,  0xC75C },
	{ 0xC75D,  0xC75D },
	{ 0xC75E,  0xC75E },
	{ 0xC75F,  0xC75F },
	{ 0xC760,  0xC760 },
	{ 0xC761,  0xC761 },
	{ 0xC762,  0xC762 },
	{ 0xC763,  0xC763 },
	{ 0xC764,  0xC764 },
	{ 0xC765,  0xC765 },
	{ 0xC766,  0xC766 },
	{ 0xC767,  0xC767 },
	{ 0xC768,  0xC768 },
	{ 0xC769,  0xC769 },
	{ 0xC76A,  0xC76A },
	{ 0xC76B,  0xC76B },
	{ 0xC76C,  0xC76C },
	{ 0xC76D,  0xC76D },
	{ 0xC76E,  0xC76E },
	{ 0xC76F,  0xC76F },
	{ 0xC770,  0xC770 },
	{ 0xC771,  0xC771 },
	{ 0xC772,  0xC772 },
	{ 0xC773,  0xC773 },
	{ 0xC774,  0xC774 },
	{ 0xC775,  0xC775 },
	{ 0xC776,  0xC776 },
	{ 0xC777,  0xC777 },
	{ 0xC778,  0xC778 },
	{ 0xC779,  0xC779 },
	{ 0xC77A,  0xC77A },
	{ 0xC77B,  0xC77B },
	{ 0xC77C,  0xC77C },
	{ 0xC77D,  0xC77D },
	{ 0xC77E,  0xC77E },
	{ 0xC7A1,  0xC7A1 },
	{ 0xC7A2,  0xC7A2 },
	{ 0xC7A3,  0xC7A3 },
	{ 0xC7A4,  0xC7A4 },
	{ 0xC7A5,  0xC7A5 },
	{ 0xC7A6,  0xC7A6 },
	{ 0xC7A7,  0xC7A7 },
	{ 0xC7A8,  0xC7A8 },
	{ 0xC7A9,  0xC7A9 },
	{ 0xC7AA,  0xC7AA },
	{ 0xC7AB,  0xC7AB },
	{ 0xC7AC,  0xC7AC },
	{ 0xC7AD,  0xC7AD },
	{ 0xC7AE,  0xC7AE },
	{ 0xC7AF,  0xC7AF },
	{ 0xC7B0,  0xC7B0 },
	{ 0xC7B1,  0xC7B1 },
	{ 0xC7B2,  0xC7B2 },
	{ 0xC7B3,  0xC7B3 },
	{ 0xC7B4,  0xC7B4 },
	{ 0xC7B5,  0xC7B5 },
	{ 0xC7B6,  0xC7B6 },
	{ 0xC7B7,  0xC7B7 },
	{ 0xC7B8,  0xC7B8 },
	{ 0xC7B9,  0xC7B9 },
	{ 0xC7BA,  0xC7BA },
	{ 0xC7BB,  0xC7BB },
	{ 0xC7BC,  0xC7BC },
	{ 0xC7BD,  0xC7BD },
	{ 0xC7BE,  0xC7BE },
	{ 0xC7BF,  0xC7BF },
	{ 0xC7C0,  0xC7C0 },
	{ 0xC7C1,  0xC7C1 },
	{ 0xC7C2,  0xC7C2 },
	{ 0xC7C3,  0xC7C3 },
	{ 0xC7C4,  0xC7C4 },
	{ 0xC7C5,  0xC7C5 },
	{ 0xC7C6,  0xC7C6 },
	{ 0xC7C7,  0xC7C7 },
	{ 0xC7C8,  0xC7C8 },
	{ 0xC7C9,  0xC7C9 },
	{ 0xC7CA,  0xC7CA },
	{ 0xC7CB,  0xC7CB },
	{ 0xC7CC,  0xC7CC },
	{ 0xC7CD,  0xC7CD },
	{ 0xC7CE,  0xC7CE },
	{ 0xC7CF,  0xC7CF },
	{ 0xC7D0,  0xC7D0 },
	{ 0xC7D1,  0xC7D1 },
	{ 0xC7D2,  0xC7D2 },
	{ 0xC7D3,  0xC7D3 },
	{ 0xC7D4,  0xC7D4 },
	{ 0xC7D5,  0xC7D5 },
	{ 0xC7D6,  0xC7D6 },
	{ 0xC7D7,  0xC7D7 },
	{ 0xC7D8,  0xC7D8 },
	{ 0xC7D9,  0xC7D9 },
	{ 0xC7DA,  0xC7DA },
	{ 0xC7DB,  0xC7DB },
	{ 0xC7DC,  0xC7DC },
	{ 0xC7DD,  0xC7DD },
	{ 0xC7DE,  0xC7DE },
	{ 0xC7DF,  0xC7DF },
	{ 0xC7E0,  0xC7E0 },
	{ 0xC7E1,  0xC7E1 },
	{ 0xC7E2,  0xC7E2 },
	{ 0xC7E3,  0xC7E3 },
	{ 0xC7E4,  0xC7E4 },
	{ 0xC7E5,  0xC7E5 },
	{ 0xC7E6,  0xC7E6 },
	{ 0xC7E7,  0xC7E7 },
	{ 0xC7E8,  0xC7E8 },
	{ 0xC7E9,  0xC7E9 },
	{ 0xC7EA,  0xC7EA },
	{ 0xC7EB,  0xC7EB },
	{ 0xC7EC,  0xC7EC },
	{ 0xC7ED,  0xC7ED },
	{ 0xC7EE,  0xC7EE },
	{ 0xC7EF,  0xC7EF },
	{ 0xC7F0,  0xC7F0 },
	{ 0xC7F1,  0xC7F1 },
	{ 0xC7F2,  0xC7F2 },
	{ 0xC87B,  0xF689 },
	{ 0xC87D,  0xF68C },
	{ 0xC8A2,  0xF781 },
	{ 0xC8D0,  0xC6DE },
	{ 0xC8D4,  0xC6DF },
	{ 0xC8D5,  0xC6E0 },
	{ 0xC940,  0xC940 },
	{ 0xC941,  0xC941 },
	{ 0xC942,  0xC942 },
	{ 0xC943,  0xC943 },
	{ 0xC944,  0xC944 },
	{ 0xC945,  0xC945 },
	{ 0xC946,  0xC946 },
	{ 0xC947,  0xC947 },
	{ 0xC948,  0xC948 },
	{ 0xC949,  0xC949 },
	{ 0xC94B,  0xC94B },
	{ 0xC94C,  0xC94C },
	{ 0xC94D,  0xC94D },
	{ 0xC94E,  0xC94E },
	{ 0xC94F,  0xC94F },
	{ 0xC950,  0xC950 },
	{ 0xC951,  0xC951 },
	{ 0xC952,  0xC952 },
	{ 0xC953,  0xC953 },
	{ 0xC954,  0xC954 },
	{ 0xC955,  0xC955 },
	{ 0xC956,  0xC956 },
	{ 0xC957,  0xC957 },
	{ 0xC958,  0xC958 },
	{ 0xC959,  0xC959 },
	{ 0xC95A,  0xC95A },
	{ 0xC95B,  0xC95B },
	{ 0xC95C,  0xC95C },
	{ 0xC95D,  0xC95D },
	{ 0xC95E,  0xC95E },
	{ 0xC95F,  0xC95F },
	{ 0xC960,  0xC960 },
	{ 0xC961,  0xC961 },
	{ 0xC962,  0xC962 },
	{ 0xC963,  0xC963 },
	{ 0xC964,  0xC964 },
	{ 0xC965,  0xC965 },
	{ 0xC966,  0xC966 },
	{ 0xC967,  0xC967 },
	{ 0xC968,  0xC968 },
	{ 0xC969,  0xC969 },
	{ 0xC96A,  0xC96A },
	{ 0xC96B,  0xC96B },
	{ 0xC96C,  0xC96C },
	{ 0xC96D,  0xC96D },
	{ 0xC96E,  0xC96E },
	{ 0xC96F,  0xC96F },
	{ 0xC970,  0xC970 },
	{ 0xC971,  0xC971 },
	{ 0xC972,  0xC972 },
	{ 0xC973,  0xC973 },
	{ 0xC974,  0xC974 },
	{ 0xC975,  0xC975 },
	{ 0xC976,  0xC976 },
	{ 0xC977,  0xC977 },
	{ 0xC978,  0xC978 },
	{ 0xC979,  0xC979 },
	{ 0xC97A,  0xC97A },
	{ 0xC97B,  0xC97B },
	{ 0xC97C,  0xC97C },
	{ 0xC97D,  0xC97D },
	{ 0xC97E,  0xC97E },
	{ 0xC9A1,  0xC9A1 },
	{ 0xC9A2,  0xC9A2 },
	{ 0xC9A3,  0xC9A3 },
	{ 0xC9A4,  0xC9A4 },
	{ 0xC9A5,  0xC9A5 },
	{ 0xC9A6,  0xC9A6 },
	{ 0xC9A7,  0xC9A7 },
	{ 0xC9A8,  0xC9A8 },
	{ 0xC9A9,  0xC9A9 },
	{ 0xC9AA,  0xC9AA },
	{ 0xC9AB,  0xC9AB },
	{ 0xC9AC,  0xC9AC },
	{ 0xC9AD,  0xC9AD },
	{ 0xC9AE,  0xC9AE },
	{ 0xC9AF,  0xC9AF },
	{ 0xC9B0,  0xC9B0 },
	{ 0xC9B1,  0xC9B1 },
	{ 0xC9B2,  0xC9B2 },
	{ 0xC9B3,  0xC9B3 },
	{ 0xC9B4,  0xC9B4 },
	{ 0xC9B5,  0xC9B5 },
	{ 0xC9B6,  0xC9B6 },
	{ 0xC9B7,  0xC9B7 },
	{ 0xC9B8,  0xC9B8 },
	{ 0xC9B9,  0xC9B9 },
	{ 0xC9BA,  0xC9BA },
	{ 0xC9BB,  0xC9BB },
	{ 0xC9BC,  0xC9BC },
	{ 0xC9BD,  0xC9BD },
	{ 0xC9BE,  0xC9BE },
	{ 0xC9BF,  0xC9BF },
	{ 0xC9C0,  0xC9C0 },
	{ 0xC9C1,  0xC9C1 },
	{ 0xC9C2,  0xC9C2 },
	{ 0xC9C3,  0xC9C3 },
	{ 0xC9C4,  0xC9C4 },
	{ 0xC9C5,  0xC9C5 },
	{ 0xC9C6,  0xC9C6 },
	{ 0xC9C7,  0xC9C7 },
	{ 0xC9C8,  0xC9C8 },
	{ 0xC9C9,  0xC9C9 },
	{ 0xC9CA,  0xC9CA },
	{ 0xC9CB,  0xC9CB },
	{ 0xC9CC,  0xC9CC },
	{ 0xC9CD,  0xC9CD },
	{ 0xC9CE,  0xC9CE },
	{ 0xC9CF,  0xC9CF },
	{ 0xC9D0,  0xC9D0 },
	{ 0xC9D1,  0xC9D1 },
	{ 0xC9D2,  0xC9D2 },
	{ 0xC9D3,  0xC9D3 },
	{ 0xC9D4,  0xC9D4 },
	{ 0xC9D5,  0xC9D5 },
	{ 0xC9D6,  0xC9D6 },
	{ 0xC9D7,  0xC9D7 },
	{ 0xC9D8,  0xC9D8 },
	{ 0xC9D9,  0xC9D9 },
	{ 0xC9DA,  0xC9DA },
	{ 0xC9DB,  0xC9DB },
	{ 0xC9DC,  0xC9DC },
	{ 0xC9DD,  0xC9DD },
	{ 0xC9DE,  0xC9DE },
	{ 0xC9DF,  0xC9DF },
	{ 0xC9E0,  0xC9E0 },
	{ 0xC9E1,  0xC9E1 },
	{ 0xC9E2,  0xC9E2 },
	{ 0xC9E3,  0xC9E3 },
	{ 0xC9E4,  0xC9E4 },
	{ 0xC9E5,  0xC9E5 },
	{ 0xC9E6,  0xC9E6 },
	{ 0xC9E7,  0xC9E7 },
	{ 0xC9E8,  0xC9E8 },
	{ 0xC9E9,  0xC9E9 },
	{ 0xC9EA,  0xC9EA },
	{ 0xC9EB,  0xC9EB },
	{ 0xC9EC,  0xC9EC },
	{ 0xC9ED,  0xC9ED },
	{ 0xC9EE,  0xC9EE },
	{ 0xC9EF,  0xC9EF },
	{ 0xC9F0,  0xC9F0 },
	{ 0xC9F1,  0xC9F1 },
	{ 0xC9F2,  0xC9F2 },
	{ 0xC9F3,  0xC9F3 },
	{ 0xC9F4,  0xC9F4 },
	{ 0xC9F5,  0xC9F5 },
	{ 0xC9F6,  0xC9F6 },
	{ 0xC9F7,  0xC9F7 },
	{ 0xC9F8,  0xC9F8 },
	{ 0xC9F9,  0xC9F9 },
	{ 0xC9FA,  0xC9FA },
	{ 0xC9FB,  0xC9FB },
	{ 0xC9FC,  0xC9FC },
	{ 0xC9FD,  0xC9FD },
	{ 0xC9FE,  0xC9FE },
	{ 0xCA40,  0xCA40 },
	{ 0xCA41,  0xCA41 },
	{ 0xCA42,  0xCA42 },
	{ 0xCA43,  0xCA43 },
	{ 0xCA44,  0xCA44 },
	{ 0xCA45,  0xCA45 },
	{ 0xCA46,  0xCA46 },
	{ 0xCA47,  0xCA47 },
	{ 0xCA48,  0xCA48 },
	{ 0xCA49,  0xCA49 },
	{ 0xCA4A,  0xCA4A },
	{ 0xCA4B,  0xCA4B },
	{ 0xCA4C,  0xCA4C },
	{ 0xCA4D,  0xCA4D },
	{ 0xCA4E,  0xCA4E },
	{ 0xCA4F,  0xCA4F },
	{ 0xCA50,  0xCA50 },
	{ 0xCA51,  0xCA51 },
	{ 0xCA52,  0xCA52 },
	{ 0xCA53,  0xCA53 },
	{ 0xCA54,  0xCA54 },
	{ 0xCA55,  0xCA55 },
	{ 0xCA56,  0xCA56 },
	{ 0xCA57,  0xCA57 },
	{ 0xCA58,  0xCA58 },
	{ 0xCA59,  0xCA59 },
	{ 0xCA5A,  0xCA5A },
	{ 0xCA5B,  0xCA5B },
	{ 0xCA5C,  0xCA5C },
	{ 0xCA5D,  0xCA5D },
	{ 0xCA5E,  0xCA5E },
	{ 0xCA5F,  0xCA5F },
	{ 0xCA60,  0xCA60 },
	{ 0xCA61,  0xCA61 },
	{ 0xCA62,  0xCA62 },
	{ 0xCA63,  0xCA63 },
	{ 0xCA64,  0xCA64 },
	{ 0xCA65,  0xCA65 },
	{ 0xCA66,  0xCA66 },
	{ 0xCA67,  0xCA67 },
	{ 0xCA68,  0xCA68 },
	{ 0xCA69,  0xCA69 },
	{ 0xCA6A,  0xCA6A },
	{ 0xCA6B,  0xCA6B },
	{ 0xCA6C,  0xCA6C },
	{ 0xCA6D,  0xCA6D },
	{ 0xCA6E,  0xCA6E },
	{ 0xCA6F,  0xCA6F },
	{ 0xCA70,  0xCA70 },
	{ 0xCA71,  0xCA71 },
	{ 0xCA72,  0xCA72 },
	{ 0xCA73,  0xCA73 },
	{ 0xCA74,  0xCA74 },
	{ 0xCA75,  0xCA75 },
	{ 0xCA76,  0xCA76 },
	{ 0xCA77,  0xCA77 },
	{ 0xCA78,  0xCA78 },
	{ 0xCA79,  0xCA79 },
	{ 0xCA7A,  0xCA7A },
	{ 0xCA7B,  0xCA7B },
	{ 0xCA7C,  0xCA7C },
	{ 0xCA7D,  0xCA7D },
	{ 0xCA7E,  0xCA7E },
	{ 0xCAA1,  0xCAA1 },
	{ 0xCAA2,  0xCAA2 },
	{ 0xCAA3,  0xCAA3 },
	{ 0xCAA4,  0xCAA4 },
	{ 0xCAA5,  0xCAA5 },
	{ 0xCAA6,  0xCAA6 },
	{ 0xCAA7,  0xCAA7 },
	{ 0xCAA8,  0xCAA8 },
	{ 0xCAA9,  0xCAA9 },
	{ 0xCAAA,  0xCAAA },
	{ 0xCAAB,  0xCAAB },
	{ 0xCAAC,  0xCAAC },
	{ 0xCAAD,  0xCAAD },
	{ 0xCAAE,  0xCAAE },
	{ 0xCAAF,  0xCAAF },
	{ 0xCAB0,  0xCAB0 },
	{ 0xCAB1,  0xCAB1 },
	{ 0xCAB2,  0xCAB2 },
	{ 0xCAB3,  0xCAB3 },
	{ 0xCAB4,  0xCAB4 },
	{ 0xCAB5,  0xCAB5 },
	{ 0xCAB6,  0xCAB6 },
	{ 0xCAB7,  0xCAB7 },
	{ 0xCAB8,  0xCAB8 },
	{ 0xCAB9,  0xCAB9 },
	{ 0xCABA,  0xCABA },
	{ 0xCABB,  0xCABB },
	{ 0xCABC,  0xCABC },
	{ 0xCABD,  0xCABD },
	{ 0xCABE,  0xCABE },
	{ 0xCABF,  0xCABF },
	{ 0xCAC0,  0xCAC0 },
	{ 0xCAC1,  0xCAC1 },
	{ 0xCAC2,  0xCAC2 },
	{ 0xCAC3,  0xCAC3 },
	{ 0xCAC4,  0xCAC4 },
	{ 0xCAC5,  0xCAC5 },
	{ 0xCAC6,  0xCAC6 },
	{ 0xCAC7,  0xCAC7 },
	{ 0xCAC8,  0xCAC8 },
	{ 0xCAC9,  0xCAC9 },
	{ 0xCACA,  0xCACA },
	{ 0xCACB,  0xCACB },
	{ 0xCACC,  0xCACC },
	{ 0xCACD,  0xCACD },
	{ 0xCACE,  0xCACE },
	{ 0xCACF,  0xCACF },
	{ 0xCAD0,  0xCAD0 },
	{ 0xCAD1,  0xCAD1 },
	{ 0xCAD2,  0xCAD2 },
	{ 0xCAD3,  0xCAD3 },
	{ 0xCAD4,  0xCAD4 },
	{ 0xCAD5,  0xCAD5 },
	{ 0xCAD6,  0xCAD6 },
	{ 0xCAD7,  0xCAD7 },
	{ 0xCAD8,  0xCAD8 },
	{ 0xCAD9,  0xCAD9 },
	{ 0xCADA,  0xCADA },
	{ 0xCADB,  0xCADB },
	{ 0xCADC,  0xCADC },
	{ 0xCADD,  0xCADD },
	{ 0xCADE,  0xCADE },
	{ 0xCADF,  0xCADF },
	{ 0xCAE0,  0xCAE0 },
	{ 0xCAE1,  0xCAE1 },
	{ 0xCAE2,  0xCAE2 },
	{ 0xCAE3,  0xCAE3 },
	{ 0xCAE4,  0xCAE4 },
	{ 0xCAE5,  0xCAE5 },
	{ 0xCAE6,  0xCAE6 },
	{ 0xCAE7,  0xCAE7 },
	{ 0xCAE8,  0xCAE8 },
	{ 0xCAE9,  0xCAE9 },
	{ 0xCAEA,  0xCAEA },
	{ 0xCAEB,  0xCAEB },
	{ 0xCAEC,  0xCAEC },
	{ 0xCAED,  0xCAED },
	{ 0xCAEE,  0xCAEE },
	{ 0xCAEF,  0xCAEF },
	{ 0xCAF0,  0xCAF0 },
	{ 0xCAF1,  0xCAF1 },
	{ 0xCAF2,  0xCAF2 },
	{ 0xCAF3,  0xCAF3 },
	{ 0xCAF4,  0xCAF4 },
	{ 0xCAF5,  0xCAF5 },
	{ 0xCAF6,  0xCAF6 },
	{ 0xCAF7,  0xCAF7 },
	{ 0xCAF8,  0xCAF8 },
	{ 0xCAF9,  0xCAF9 },
	{ 0xCAFA,  0xCAFA },
	{ 0xCAFB,  0xCAFB },
	{ 0xCAFC,  0xCAFC },
	{ 0xCAFD,  0xCAFD },
	{ 0xCAFE,  0xCAFE },
	{ 0xCB40,  0xCB40 },
	{ 0xCB41,  0xCB41 },
	{ 0xCB42,  0xCB42 },
	{ 0xCB43,  0xCB43 },
	{ 0xCB44,  0xCB44 },
	{ 0xCB45,  0xCB45 },
	{ 0xCB46,  0xCB46 },
	{ 0xCB47,  0xCB47 },
	{ 0xCB48,  0xCB48 },
	{ 0xCB49,  0xCB49 },
	{ 0xCB4A,  0xCB4A },
	{ 0xCB4B,  0xCB4B },
	{ 0xCB4C,  0xCB4C },
	{ 0xCB4D,  0xCB4D },
	{ 0xCB4E,  0xCB4E },
	{ 0xCB4F,  0xCB4F },
	{ 0xCB50,  0xCB50 },
	{ 0xCB51,  0xCB51 },
	{ 0xCB52,  0xCB52 },
	{ 0xCB53,  0xCB53 },
	{ 0xCB54,  0xCB54 },
	{ 0xCB55,  0xCB55 },
	{ 0xCB56,  0xCB56 },
	{ 0xCB57,  0xCB57 },
	{ 0xCB58,  0xCB58 },
	{ 0xCB59,  0xCB59 },
	{ 0xCB5A,  0xCB5A },
	{ 0xCB5B,  0xCB5B },
	{ 0xCB5C,  0xCB5C },
	{ 0xCB5D,  0xCB5D },
	{ 0xCB5E,  0xCB5E },
	{ 0xCB5F,  0xCB5F },
	{ 0xCB60,  0xCB60 },
	{ 0xCB61,  0xCB61 },
	{ 0xCB62,  0xCB62 },
	{ 0xCB63,  0xCB63 },
	{ 0xCB64,  0xCB64 },
	{ 0xCB65,  0xCB65 },
	{ 0xCB66,  0xCB66 },
	{ 0xCB67,  0xCB67 },
	{ 0xCB68,  0xCB68 },
	{ 0xCB69,  0xCB69 },
	{ 0xCB6A,  0xCB6A },
	{ 0xCB6B,  0xCB6B },
	{ 0xCB6C,  0xCB6C },
	{ 0xCB6D,  0xCB6D },
	{ 0xCB6E,  0xCB6E },
	{ 0xCB6F,  0xCB6F },
	{ 0xCB70,  0xCB70 },
	{ 0xCB71,  0xCB71 },
	{ 0xCB72,  0xCB72 },
	{ 0xCB73,  0xCB73 },
	{ 0xCB74,  0xCB74 },
	{ 0xCB75,  0xCB75 },
	{ 0xCB76,  0xCB76 },
	{ 0xCB77,  0xCB77 },
	{ 0xCB78,  0xCB78 },
	{ 0xCB79,  0xCB79 },
	{ 0xCB7A,  0xCB7A },
	{ 0xCB7B,  0xCB7B },
	{ 0xCB7C,  0xCB7C },
	{ 0xCB7D,  0xCB7D },
	{ 0xCB7E,  0xCB7E },
	{ 0xCBA1,  0xCBA1 },
	{ 0xCBA2,  0xCBA2 },
	{ 0xCBA3,  0xCBA3 },
	{ 0xCBA4,  0xCBA4 },
	{ 0xCBA5,  0xCBA5 },
	{ 0xCBA6,  0xCBA6 },
	{ 0xCBA7,  0xCBA7 },
	{ 0xCBA8,  0xCBA8 },
	{ 0xCBA9,  0xCBA9 },
	{ 0xCBAA,  0xCBAA },
	{ 0xCBAB,  0xCBAB },
	{ 0xCBAC,  0xCBAC },
	{ 0xCBAD,  0xCBAD },
	{ 0xCBAE,  0xCBAE },
	{ 0xCBAF,  0xCBAF },
	{ 0xCBB0,  0xCBB0 },
	{ 0xCBB1,  0xCBB1 },
	{ 0xCBB2,  0xCBB2 },
	{ 0xCBB3,  0xCBB3 },
	{ 0xCBB4,  0xCBB4 },
	{ 0xCBB5,  0xCBB5 },
	{ 0xCBB6,  0xCBB6 },
	{ 0xCBB7,  0xCBB7 },
	{ 0xCBB8,  0xCBB8 },
	{ 0xCBB9,  0xCBB9 },
	{ 0xCBBA,  0xCBBA },
	{ 0xCBBB,  0xCBBB },
	{ 0xCBBC,  0xCBBC },
	{ 0xCBBD,  0xCBBD },
	{ 0xCBBE,  0xCBBE },
	{ 0xCBBF,  0xCBBF },
	{ 0xCBC0,  0xCBC0 },
	{ 0xCBC1,  0xCBC1 },
	{ 0xCBC2,  0xCBC2 },
	{ 0xCBC3,  0xCBC3 },
	{ 0xCBC4,  0xCBC4 },
	{ 0xCBC5,  0xCBC5 },
	{ 0xCBC6,  0xCBC6 },
	{ 0xCBC7,  0xCBC7 },
	{ 0xCBC8,  0xCBC8 },
	{ 0xCBC9,  0xCBC9 },
	{ 0xCBCA,  0xCBCA },
	{ 0xCBCB,  0xCBCB },
	{ 0xCBCC,  0xCBCC },
	{ 0xCBCD,  0xCBCD },
	{ 0xCBCE,  0xCBCE },
	{ 0xCBCF,  0xCBCF },
	{ 0xCBD0,  0xCBD0 },
	{ 0xCBD1,  0xCBD1 },
	{ 0xCBD2,  0xCBD2 },
	{ 0xCBD3,  0xCBD3 },
	{ 0xCBD4,  0xCBD4 },
	{ 0xCBD5,  0xCBD5 },
	{ 0xCBD6,  0xCBD6 },
	{ 0xCBD7,  0xCBD7 },
	{ 0xCBD8,  0xCBD8 },
	{ 0xCBD9,  0xCBD9 },
	{ 0xCBDA,  0xCBDA },
	{ 0xCBDB,  0xCBDB },
	{ 0xCBDC,  0xCBDC },
	{ 0xCBDD,  0xCBDD },
	{ 0xCBDE,  0xCBDE },
	{ 0xCBDF,  0xCBDF },
	{ 0xCBE0,  0xCBE0 },
	{ 0xCBE1,  0xCBE1 },
	{ 0xCBE2,  0xCBE2 },
	{ 0xCBE3,  0xCBE3 },
	{ 0xCBE4,  0xCBE4 },
	{ 0xCBE5,  0xCBE5 },
	{ 0xCBE6,  0xCBE6 },
	{ 0xCBE7,  0xCBE7 },
	{ 0xCBE8,  0xCBE8 },
	{ 0xCBE9,  0xCBE9 },
	{ 0xCBEA,  0xCBEA },
	{ 0xCBEB,  0xCBEB },
	{ 0xCBEC,  0xCBEC },
	{ 0xCBED,  0xCBED },
	{ 0xCBEE,  0xCBEE },
	{ 0xCBEF,  0xCBEF },
	{ 0xCBF0,  0xCBF0 },
	{ 0xCBF1,  0xCBF1 },
	{ 0xCBF2,  0xCBF2 },
	{ 0xCBF3,  0xCBF3 },
	{ 0xCBF4,  0xCBF4 },
	{ 0xCBF5,  0xCBF5 },
	{ 0xCBF6,  0xCBF6 },
	{ 0xCBF7,  0xCBF7 },
	{ 0xCBF8,  0xCBF8 },
	{ 0xCBF9,  0xCBF9 },
	{ 0xCBFA,  0xCBFA },
	{ 0xCBFB,  0xCBFB },
	{ 0xCBFC,  0xCBFC },
	{ 0xCBFD,  0xCBFD },
	{ 0xCBFE,  0xCBFE },
	{ 0xCC40,  0xCC40 },
	{ 0xCC41,  0xCC41 },
	{ 0xCC42,  0xCC42 },
	{ 0xCC43,  0xCC43 },
	{ 0xCC44,  0xCC44 },
	{ 0xCC45,  0xCC45 },
	{ 0xCC46,  0xCC46 },
	{ 0xCC47,  0xCC47 },
	{ 0xCC48,  0xCC48 },
	{ 0xCC49,  0xCC49 },
	{ 0xCC4A,  0xCC4A },
	{ 0xCC4B,  0xCC4B },
	{ 0xCC4C,  0xCC4C },
	{ 0xCC4D,  0xCC4D },
	{ 0xCC4E,  0xCC4E },
	{ 0xCC4F,  0xCC4F },
	{ 0xCC50,  0xCC50 },
	{ 0xCC51,  0xCC51 },
	{ 0xCC52,  0xCC52 },
	{ 0xCC53,  0xCC53 },
	{ 0xCC54,  0xCC54 },
	{ 0xCC55,  0xCC55 },
	{ 0xCC56,  0xCC56 },
	{ 0xCC57,  0xCC57 },
	{ 0xCC58,  0xCC58 },
	{ 0xCC59,  0xCC59 },
	{ 0xCC5A,  0xCC5A },
	{ 0xCC5B,  0xCC5B },
	{ 0xCC5C,  0xCC5C },
	{ 0xCC5D,  0xCC5D },
	{ 0xCC5E,  0xCC5E },
	{ 0xCC5F,  0xCC5F },
	{ 0xCC60,  0xCC60 },
	{ 0xCC61,  0xCC61 },
	{ 0xCC62,  0xCC62 },
	{ 0xCC63,  0xCC63 },
	{ 0xCC64,  0xCC64 },
	{ 0xCC65,  0xCC65 },
	{ 0xCC66,  0xCC66 },
	{ 0xCC67,  0xCC67 },
	{ 0xCC68,  0xCC68 },
	{ 0xCC69,  0xCC69 },
	{ 0xCC6A,  0xCC6A },
	{ 0xCC6B,  0xCC6B },
	{ 0xCC6C,  0xCC6C },
	{ 0xCC6D,  0xCC6D },
	{ 0xCC6E,  0xCC6E },
	{ 0xCC6F,  0xCC6F },
	{ 0xCC70,  0xCC70 },
	{ 0xCC71,  0xCC71 },
	{ 0xCC72,  0xCC72 },
	{ 0xCC73,  0xCC73 },
	{ 0xCC74,  0xCC74 },
	{ 0xCC75,  0xCC75 },
	{ 0xCC76,  0xCC76 },
	{ 0xCC77,  0xCC77 },
	{ 0xCC78,  0xCC78 },
	{ 0xCC79,  0xCC79 },
	{ 0xCC7A,  0xCC7A },
	{ 0xCC7B,  0xCC7B },
	{ 0xCC7C,  0xCC7C },
	{ 0xCC7D,  0xCC7D },
	{ 0xCC7E,  0xCC7E },
	{ 0xCCA1,  0xCCA1 },
	{ 0xCCA2,  0xCCA2 },
	{ 0xCCA3,  0xCCA3 },
	{ 0xCCA4,  0xCCA4 },
	{ 0xCCA5,  0xCCA5 },
	{ 0xCCA6,  0xCCA6 },
	{ 0xCCA7,  0xCCA7 },
	{ 0xCCA8,  0xCCA8 },
	{ 0xCCA9,  0xCCA9 },
	{ 0xCCAA,  0xCCAA },
	{ 0xCCAB,  0xCCAB },
	{ 0xCCAC,  0xCCAC },
	{ 0xCCAD,  0xCCAD },
	{ 0xCCAE,  0xCCAE },
	{ 0xCCAF,  0xCCAF },
	{ 0xCCB0,  0xCCB0 },
	{ 0xCCB1,  0xCCB1 },
	{ 0xCCB2,  0xCCB2 },
	{ 0xCCB3,  0xCCB3 },
	{ 0xCCB4,  0xCCB4 },
	{ 0xCCB5,  0xCCB5 },
	{ 0xCCB6,  0xCCB6 },
	{ 0xCCB7,  0xCCB7 },
	{ 0xCCB8,  0xCCB8 },
	{ 0xCCB9,  0xCCB9 },
	{ 0xCCBA,  0xCCBA },
	{ 0xCCBB,  0xCCBB },
	{ 0xCCBC,  0xCCBC },
	{ 0xCCBD,  0xCCBD },
	{ 0xCCBE,  0xCCBE },
	{ 0xCCBF,  0xCCBF },
	{ 0xCCC0,  0xCCC0 },
	{ 0xCCC1,  0xCCC1 },
	{ 0xCCC2,  0xCCC2 },
	{ 0xCCC3,  0xCCC3 },
	{ 0xCCC4,  0xCCC4 },
	{ 0xCCC5,  0xCCC5 },
	{ 0xCCC6,  0xCCC6 },
	{ 0xCCC7,  0xCCC7 },
	{ 0xCCC8,  0xCCC8 },
	{ 0xCCC9,  0xCCC9 },
	{ 0xCCCA,  0xCCCA },
	{ 0xCCCB,  0xCCCB },
	{ 0xCCCC,  0xCCCC },
	{ 0xCCCD,  0xCCCD },
	{ 0xCCCE,  0xCCCE },
	{ 0xCCCF,  0xCCCF },
	{ 0xCCD0,  0xCCD0 },
	{ 0xCCD1,  0xCCD1 },
	{ 0xCCD2,  0xCCD2 },
	{ 0xCCD3,  0xCCD3 },
	{ 0xCCD4,  0xCCD4 },
	{ 0xCCD5,  0xCCD5 },
	{ 0xCCD6,  0xCCD6 },
	{ 0xCCD7,  0xCCD7 },
	{ 0xCCD8,  0xCCD8 },
	{ 0xCCD9,  0xCCD9 },
	{ 0xCCDA,  0xCCDA },
	{ 0xCCDB,  0xCCDB },
	{ 0xCCDC,  0xCCDC },
	{ 0xCCDD,  0xCCDD },
	{ 0xCCDE,  0xCCDE },
	{ 0xCCDF,  0xCCDF },
	{ 0xCCE0,  0xCCE0 },
	{ 0xCCE1,  0xCCE1 },
	{ 0xCCE2,  0xCCE2 },
	{ 0xCCE3,  0xCCE3 },
	{ 0xCCE4,  0xCCE4 },
	{ 0xCCE5,  0xCCE5 },
	{ 0xCCE6,  0xCCE6 },
	{ 0xCCE7,  0xCCE7 },
	{ 0xCCE8,  0xCCE8 },
	{ 0xCCE9,  0xCCE9 },
	{ 0xCCEA,  0xCCEA },
	{ 0xCCEB,  0xCCEB },
	{ 0xCCEC,  0xCCEC },
	{ 0xCCED,  0xCCED },
	{ 0xCCEE,  0xCCEE },
	{ 0xCCEF,  0xCCEF },
	{ 0xCCF0,  0xCCF0 },
	{ 0xCCF1,  0xCCF1 },
	{ 0xCCF2,  0xCCF2 },
	{ 0xCCF3,  0xCCF3 },
	{ 0xCCF4,  0xCCF4 },
	{ 0xCCF5,  0xCCF5 },
	{ 0xCCF6,  0xCCF6 },
	{ 0xCCF7,  0xCCF7 },
	{ 0xCCF8,  0xCCF8 },
	{ 0xCCF9,  0xCCF9 },
	{ 0xCCFA,  0xCCFA },
	{ 0xCCFB,  0xCCFB },
	{ 0xCCFC,  0xCCFC },
	{ 0xCCFD,  0xCCFD },
	{ 0xCCFE,  0xCCFE },
	{ 0xCD40,  0xCD40 },
	{ 0xCD41,  0xCD41 },
	{ 0xCD42,  0xCD42 },
	{ 0xCD43,  0xCD43 },
	{ 0xCD44,  0xCD44 },
	{ 0xCD45,  0xCD45 },
	{ 0xCD46,  0xCD46 },
	{ 0xCD47,  0xCD47 },
	{ 0xCD48,  0xCD48 },
	{ 0xCD49,  0xCD49 },
	{ 0xCD4A,  0xCD4A },
	{ 0xCD4B,  0xCD4B },
	{ 0xCD4C,  0xCD4C },
	{ 0xCD4D,  0xCD4D },
	{ 0xCD4E,  0xCD4E },
	{ 0xCD4F,  0xCD4F },
	{ 0xCD50,  0xCD50 },
	{ 0xCD51,  0xCD51 },
	{ 0xCD52,  0xCD52 },
	{ 0xCD53,  0xCD53 },
	{ 0xCD54,  0xCD54 },
	{ 0xCD55,  0xCD55 },
	{ 0xCD56,  0xCD56 },
	{ 0xCD57,  0xCD57 },
	{ 0xCD58,  0xCD58 },
	{ 0xCD59,  0xCD59 },
	{ 0xCD5A,  0xCD5A },
	{ 0xCD5B,  0xCD5B },
	{ 0xCD5C,  0xCD5C },
	{ 0xCD5D,  0xCD5D },
	{ 0xCD5E,  0xCD5E },
	{ 0xCD5F,  0xCD5F },
	{ 0xCD60,  0xCD60 },
	{ 0xCD61,  0xCD61 },
	{ 0xCD62,  0xCD62 },
	{ 0xCD63,  0xCD63 },
	{ 0xCD64,  0xCD64 },
	{ 0xCD65,  0xCD65 },
	{ 0xCD66,  0xCD66 },
	{ 0xCD67,  0xCD67 },
	{ 0xCD68,  0xCD68 },
	{ 0xCD69,  0xCD69 },
	{ 0xCD6A,  0xCD6A },
	{ 0xCD6B,  0xCD6B },
	{ 0xCD6C,  0xCD6C },
	{ 0xCD6D,  0xCD6D },
	{ 0xCD6E,  0xCD6E },
	{ 0xCD6F,  0xCD6F },
	{ 0xCD70,  0xCD70 },
	{ 0xCD71,  0xCD71 },
	{ 0xCD72,  0xCD72 },
	{ 0xCD73,  0xCD73 },
	{ 0xCD74,  0xCD74 },
	{ 0xCD75,  0xCD75 },
	{ 0xCD76,  0xCD76 },
	{ 0xCD77,  0xCD77 },
	{ 0xCD78,  0xCD78 },
	{ 0xCD79,  0xCD79 },
	{ 0xCD7A,  0xCD7A },
	{ 0xCD7B,  0xCD7B },
	{ 0xCD7C,  0xCD7C },
	{ 0xCD7D,  0xCD7D },
	{ 0xCD7E,  0xCD7E },
	{ 0xCDA1,  0xCDA1 },
	{ 0xCDA2,  0xCDA2 },
	{ 0xCDA3,  0xCDA3 },
	{ 0xCDA4,  0xCDA4 },
	{ 0xCDA5,  0xCDA5 },
	{ 0xCDA6,  0xCDA6 },
	{ 0xCDA7,  0xCDA7 },
	{ 0xCDA8,  0xCDA8 },
	{ 0xCDA9,  0xCDA9 },
	{ 0xCDAA,  0xCDAA },
	{ 0xCDAB,  0xCDAB },
	{ 0xCDAC,  0xCDAC },
	{ 0xCDAD,  0xCDAD },
	{ 0xCDAE,  0xCDAE },
	{ 0xCDAF,  0xCDAF },
	{ 0xCDB0,  0xCDB0 },
	{ 0xCDB1,  0xCDB1 },
	{ 0xCDB2,  0xCDB2 },
	{ 0xCDB3,  0xCDB3 },
	{ 0xCDB4,  0xCDB4 },
	{ 0xCDB5,  0xCDB5 },
	{ 0xCDB6,  0xCDB6 },
	{ 0xCDB7,  0xCDB7 },
	{ 0xCDB8,  0xCDB8 },
	{ 0xCDB9,  0xCDB9 },
	{ 0xCDBA,  0xCDBA },
	{ 0xCDBB,  0xCDBB },
	{ 0xCDBC,  0xCDBC },
	{ 0xCDBD,  0xCDBD },
	{ 0xCDBE,  0xCDBE },
	{ 0xCDBF,  0xCDBF },
	{ 0xCDC0,  0xCDC0 },
	{ 0xCDC1,  0xCDC1 },
	{ 0xCDC2,  0xCDC2 },
	{ 0xCDC3,  0xCDC3 },
	{ 0xCDC4,  0xCDC4 },
	{ 0xCDC5,  0xCDC5 },
	{ 0xCDC6,  0xCDC6 },
	{ 0xCDC7,  0xCDC7 },
	{ 0xCDC8,  0xCDC8 },
	{ 0xCDC9,  0xCDC9 },
	{ 0xCDCA,  0xCDCA },
	{ 0xCDCB,  0xCDCB },
	{ 0xCDCC,  0xCDCC },
	{ 0xCDCD,  0xCDCD },
	{ 0xCDCE,  0xCDCE },
	{ 0xCDCF,  0xCDCF },
	{ 0xCDD0,  0xCDD0 },
	{ 0xCDD1,  0xCDD1 },
	{ 0xCDD2,  0xCDD2 },
	{ 0xCDD3,  0xCDD3 },
	{ 0xCDD4,  0xCDD4 },
	{ 0xCDD5,  0xCDD5 },
	{ 0xCDD6,  0xCDD6 },
	{ 0xCDD7,  0xCDD7 },
	{ 0xCDD8,  0xCDD8 },
	{ 0xCDD9,  0xCDD9 },
	{ 0xCDDA,  0xCDDA },
	{ 0xCDDB,  0xCDDB },
	{ 0xCDDC,  0xCDDC },
	{ 0xCDDD,  0xCDDD },
	{ 0xCDDE,  0xCDDE },
	{ 0xCDDF,  0xCDDF },
	{ 0xCDE0,  0xCDE0 },
	{ 0xCDE1,  0xCDE1 },
	{ 0xCDE2,  0xCDE2 },
	{ 0xCDE3,  0xCDE3 },
	{ 0xCDE4,  0xCDE4 },
	{ 0xCDE5,  0xCDE5 },
	{ 0xCDE6,  0xCDE6 },
	{ 0xCDE7,  0xCDE7 },
	{ 0xCDE8,  0xCDE8 },
	{ 0xCDE9,  0xCDE9 },
	{ 0xCDEA,  0xCDEA },
	{ 0xCDEB,  0xCDEB },
	{ 0xCDEC,  0xCDEC },
	{ 0xCDED,  0xCDED },
	{ 0xCDEE,  0xCDEE },
	{ 0xCDEF,  0xCDEF },
	{ 0xCDF0,  0xCDF0 },
	{ 0xCDF1,  0xCDF1 },
	{ 0xCDF2,  0xCDF2 },
	{ 0xCDF3,  0xCDF3 },
	{ 0xCDF4,  0xCDF4 },
	{ 0xCDF5,  0xCDF5 },
	{ 0xCDF6,  0xCDF6 },
	{ 0xCDF7,  0xCDF7 },
	{ 0xCDF8,  0xCDF8 },
	{ 0xCDF9,  0xCDF9 },
	{ 0xCDFA,  0xCDFA },
	{ 0xCDFB,  0xCDFB },
	{ 0xCDFC,  0xCDFC },
	{ 0xCDFD,  0xCDFD },
	{ 0xCDFE,  0xCDFE },
	{ 0xCE40,  0xCE40 },
	{ 0xCE41,  0xCE41 },
	{ 0xCE42,  0xCE42 },
	{ 0xCE43,  0xCE43 },
	{ 0xCE44,  0xCE44 },
	{ 0xCE45,  0xCE45 },
	{ 0xCE46,  0xCE46 },
	{ 0xCE47,  0xCE47 },
	{ 0xCE48,  0xCE48 },
	{ 0xCE49,  0xCE49 },
	{ 0xCE4A,  0xCE4A },
	{ 0xCE4B,  0xCE4B },
	{ 0xCE4C,  0xCE4C },
	{ 0xCE4D,  0xCE4D },
	{ 0xCE4E,  0xCE4E },
	{ 0xCE4F,  0xCE4F },
	{ 0xCE50,  0xCE50 },
	{ 0xCE51,  0xCE51 },
	{ 0xCE52,  0xCE52 },
	{ 0xCE53,  0xCE53 },
	{ 0xCE54,  0xCE54 },
	{ 0xCE55,  0xCE55 },
	{ 0xCE56,  0xCE56 },
	{ 0xCE57,  0xCE57 },
	{ 0xCE58,  0xCE58 },
	{ 0xCE59,  0xCE59 },
	{ 0xCE5A,  0xCE5A },
	{ 0xCE5B,  0xCE5B },
	{ 0xCE5C,  0xCE5C },
	{ 0xCE5D,  0xCE5D },
	{ 0xCE5E,  0xCE5E },
	{ 0xCE5F,  0xCE5F },
	{ 0xCE60,  0xCE60 },
	{ 0xCE61,  0xCE61 },
	{ 0xCE62,  0xCE62 },
	{ 0xCE63,  0xCE63 },
	{ 0xCE64,  0xCE64 },
	{ 0xCE65,  0xCE65 },
	{ 0xCE66,  0xCE66 },
	{ 0xCE67,  0xCE67 },
	{ 0xCE68,  0xCE68 },
	{ 0xCE69,  0xCE69 },
	{ 0xCE6A,  0xCE6A },
	{ 0xCE6B,  0xCE6B },
	{ 0xCE6C,  0xCE6C },
	{ 0xCE6D,  0xCE6D },
	{ 0xCE6E,  0xCE6E },
	{ 0xCE6F,  0xCE6F },
	{ 0xCE70,  0xCE70 },
	{ 0xCE71,  0xCE71 },
	{ 0xCE72,  0xCE72 },
	{ 0xCE73,  0xCE73 },
	{ 0xCE74,  0xCE74 },
	{ 0xCE75,  0xCE75 },
	{ 0xCE76,  0xCE76 },
	{ 0xCE77,  0xCE77 },
	{ 0xCE78,  0xCE78 },
	{ 0xCE79,  0xCE79 },
	{ 0xCE7A,  0xCE7A },
	{ 0xCE7B,  0xCE7B },
	{ 0xCE7C,  0xCE7C },
	{ 0xCE7D,  0xCE7D },
	{ 0xCE7E,  0xCE7E },
	{ 0xCEA1,  0xCEA1 },
	{ 0xCEA2,  0xCEA2 },
	{ 0xCEA3,  0xCEA3 },
	{ 0xCEA4,  0xCEA4 },
	{ 0xCEA5,  0xCEA5 },
	{ 0xCEA6,  0xCEA6 },
	{ 0xCEA7,  0xCEA7 },
	{ 0xCEA8,  0xCEA8 },
	{ 0xCEA9,  0xCEA9 },
	{ 0xCEAA,  0xCEAA },
	{ 0xCEAB,  0xCEAB },
	{ 0xCEAC,  0xCEAC },
	{ 0xCEAD,  0xCEAD },
	{ 0xCEAE,  0xCEAE },
	{ 0xCEAF,  0xCEAF },
	{ 0xCEB0,  0xCEB0 },
	{ 0xCEB1,  0xCEB1 },
	{ 0xCEB2,  0xCEB2 },
	{ 0xCEB3,  0xCEB3 },
	{ 0xCEB4,  0xCEB4 },
	{ 0xCEB5,  0xCEB5 },
	{ 0xCEB6,  0xCEB6 },
	{ 0xCEB7,  0xCEB7 },
	{ 0xCEB8,  0xCEB8 },
	{ 0xCEB9,  0xCEB9 },
	{ 0xCEBA,  0xCEBA },
	{ 0xCEBB,  0xCEBB },
	{ 0xCEBC,  0xCEBC },
	{ 0xCEBD,  0xCEBD },
	{ 0xCEBE,  0xCEBE },
	{ 0xCEBF,  0xCEBF },
	{ 0xCEC0,  0xCEC0 },
	{ 0xCEC1,  0xCEC1 },
	{ 0xCEC2,  0xCEC2 },
	{ 0xCEC3,  0xCEC3 },
	{ 0xCEC4,  0xCEC4 },
	{ 0xCEC5,  0xCEC5 },
	{ 0xCEC6,  0xCEC6 },
	{ 0xCEC7,  0xCEC7 },
	{ 0xCEC8,  0xCEC8 },
	{ 0xCEC9,  0xCEC9 },
	{ 0xCECA,  0xCECA },
	{ 0xCECB,  0xCECB },
	{ 0xCECC,  0xCECC },
	{ 0xCECD,  0xCECD },
	{ 0xCECE,  0xCECE },
	{ 0xCECF,  0xCECF },
	{ 0xCED0,  0xCED0 },
	{ 0xCED1,  0xCED1 },
	{ 0xCED2,  0xCED2 },
	{ 0xCED3,  0xCED3 },
	{ 0xCED4,  0xCED4 },
	{ 0xCED5,  0xCED5 },
	{ 0xCED6,  0xCED6 },
	{ 0xCED7,  0xCED7 },
	{ 0xCED8,  0xCED8 },
	{ 0xCED9,  0xCED9 },
	{ 0xCEDA,  0xCEDA },
	{ 0xCEDB,  0xCEDB },
	{ 0xCEDC,  0xCEDC },
	{ 0xCEDD,  0xCEDD },
	{ 0xCEDE,  0xCEDE },
	{ 0xCEDF,  0xCEDF },
	{ 0xCEE0,  0xCEE0 },
	{ 0xCEE1,  0xCEE1 },
	{ 0xCEE2,  0xCEE2 },
	{ 0xCEE3,  0xCEE3 },
	{ 0xCEE4,  0xCEE4 },
	{ 0xCEE5,  0xCEE5 },
	{ 0xCEE6,  0xCEE6 },
	{ 0xCEE7,  0xCEE7 },
	{ 0xCEE8,  0xCEE8 },
	{ 0xCEE9,  0xCEE9 },
	{ 0xCEEA,  0xCEEA },
	{ 0xCEEB,  0xCEEB },
	{ 0xCEEC,  0xCEEC },
	{ 0xCEED,  0xCEED },
	{ 0xCEEE,  0xCEEE },
	{ 0xCEEF,  0xCEEF },
	{ 0xCEF0,  0xCEF0 },
	{ 0xCEF1,  0xCEF1 },
	{ 0xCEF2,  0xCEF2 },
	{ 0xCEF3,  0xCEF3 },
	{ 0xCEF4,  0xCEF4 },
	{ 0xCEF5,  0xCEF5 },
	{ 0xCEF6,  0xCEF6 },
	{ 0xCEF7,  0xCEF7 },
	{ 0xCEF8,  0xCEF8 },
	{ 0xCEF9,  0xCEF9 },
	{ 0xCEFA,  0xCEFA },
	{ 0xCEFB,  0xCEFB },
	{ 0xCEFC,  0xCEFC },
	{ 0xCEFD,  0xCEFD },
	{ 0xCEFE,  0xCEFE },
	{ 0xCF40,  0xCF40 },
	{ 0xCF41,  0xCF41 },
	{ 0xCF42,  0xCF42 },
	{ 0xCF43,  0xCF43 },
	{ 0xCF44,  0xCF44 },
	{ 0xCF45,  0xCF45 },
	{ 0xCF46,  0xCF46 },
	{ 0xCF47,  0xCF47 },
	{ 0xCF48,  0xCF48 },
	{ 0xCF49,  0xCF49 },
	{ 0xCF4A,  0xCF4A },
	{ 0xCF4B,  0xCF4B },
	{ 0xCF4C,  0xCF4C },
	{ 0xCF4D,  0xCF4D },
	{ 0xCF4E,  0xCF4E },
	{ 0xCF4F,  0xCF4F },
	{ 0xCF50,  0xCF50 },
	{ 0xCF51,  0xCF51 },
	{ 0xCF52,  0xCF52 },
	{ 0xCF53,  0xCF53 },
	{ 0xCF54,  0xCF54 },
	{ 0xCF55,  0xCF55 },
	{ 0xCF56,  0xCF56 },
	{ 0xCF57,  0xCF57 },
	{ 0xCF58,  0xCF58 },
	{ 0xCF59,  0xCF59 },
	{ 0xCF5A,  0xCF5A },
	{ 0xCF5B,  0xCF5B },
	{ 0xCF5C,  0xCF5C },
	{ 0xCF5D,  0xCF5D },
	{ 0xCF5E,  0xCF5E },
	{ 0xCF5F,  0xCF5F },
	{ 0xCF60,  0xCF60 },
	{ 0xCF61,  0xCF61 },
	{ 0xCF62,  0xCF62 },
	{ 0xCF63,  0xCF63 },
	{ 0xCF64,  0xCF64 },
	{ 0xCF65,  0xCF65 },
	{ 0xCF66,  0xCF66 },
	{ 0xCF67,  0xCF67 },
	{ 0xCF68,  0xCF68 },
	{ 0xCF69,  0xCF69 },
	{ 0xCF6A,  0xCF6A },
	{ 0xCF6B,  0xCF6B },
	{ 0xCF6C,  0xCF6C },
	{ 0xCF6D,  0xCF6D },
	{ 0xCF6E,  0xCF6E },
	{ 0xCF6F,  0xCF6F },
	{ 0xCF70,  0xCF70 },
	{ 0xCF71,  0xCF71 },
	{ 0xCF72,  0xCF72 },
	{ 0xCF73,  0xCF73 },
	{ 0xCF74,  0xCF74 },
	{ 0xCF75,  0xCF75 },
	{ 0xCF76,  0xCF76 },
	{ 0xCF77,  0xCF77 },
	{ 0xCF78,  0xCF78 },
	{ 0xCF79,  0xCF79 },
	{ 0xCF7A,  0xCF7A },
	{ 0xCF7B,  0xCF7B },
	{ 0xCF7C,  0xCF7C },
	{ 0xCF7D,  0xCF7D },
	{ 0xCF7E,  0xCF7E },
	{ 0xCFA1,  0xCFA1 },
	{ 0xCFA2,  0xCFA2 },
	{ 0xCFA3,  0xCFA3 },
	{ 0xCFA4,  0xCFA4 },
	{ 0xCFA5,  0xCFA5 },
	{ 0xCFA6,  0xCFA6 },
	{ 0xCFA7,  0xCFA7 },
	{ 0xCFA8,  0xCFA8 },
	{ 0xCFA9,  0xCFA9 },
	{ 0xCFAA,  0xCFAA },
	{ 0xCFAB,  0xCFAB },
	{ 0xCFAC,  0xCFAC },
	{ 0xCFAD,  0xCFAD },
	{ 0xCFAE,  0xCFAE },
	{ 0xCFAF,  0xCFAF },
	{ 0xCFB0,  0xCFB0 },
	{ 0xCFB1,  0xCFB1 },
	{ 0xCFB2,  0xCFB2 },
	{ 0xCFB3,  0xCFB3 },
	{ 0xCFB4,  0xCFB4 },
	{ 0xCFB5,  0xCFB5 },
	{ 0xCFB6,  0xCFB6 },
	{ 0xCFB7,  0xCFB7 },
	{ 0xCFB8,  0xCFB8 },
	{ 0xCFB9,  0xCFB9 },
	{ 0xCFBA,  0xCFBA },
	{ 0xCFBB,  0xCFBB },
	{ 0xCFBC,  0xCFBC },
	{ 0xCFBD,  0xCFBD },
	{ 0xCFBE,  0xCFBE },
	{ 0xCFBF,  0xCFBF },
	{ 0xCFC0,  0xCFC0 },
	{ 0xCFC1,  0xCFC1 },
	{ 0xCFC2,  0xCFC2 },
	{ 0xCFC3,  0xCFC3 },
	{ 0xCFC4,  0xCFC4 },
	{ 0xCFC5,  0xCFC5 },
	{ 0xCFC6,  0xCFC6 },
	{ 0xCFC7,  0xCFC7 },
	{ 0xCFC8,  0xCFC8 },
	{ 0xCFC9,  0xCFC9 },
	{ 0xCFCA,  0xCFCA },
	{ 0xCFCB,  0xCFCB },
	{ 0xCFCC,  0xCFCC },
	{ 0xCFCD,  0xCFCD },
	{ 0xCFCE,  0xCFCE },
	{ 0xCFCF,  0xCFCF },
	{ 0xCFD0,  0xCFD0 },
	{ 0xCFD1,  0xCFD1 },
	{ 0xCFD2,  0xCFD2 },
	{ 0xCFD3,  0xCFD3 },
	{ 0xCFD4,  0xCFD4 },
	{ 0xCFD5,  0xCFD5 },
	{ 0xCFD6,  0xCFD6 },
	{ 0xCFD7,  0xCFD7 },
	{ 0xCFD8,  0xCFD8 },
	{ 0xCFD9,  0xCFD9 },
	{ 0xCFDA,  0xCFDA },
	{ 0xCFDB,  0xCFDB },
	{ 0xCFDC,  0xCFDC },
	{ 0xCFDD,  0xCFDD },
	{ 0xCFDE,  0xCFDE },
	{ 0xCFDF,  0xCFDF },
	{ 0xCFE0,  0xCFE0 },
	{ 0xCFE1,  0xCFE1 },
	{ 0xCFE2,  0xCFE2 },
	{ 0xCFE3,  0xCFE3 },
	{ 0xCFE4,  0xCFE4 },
	{ 0xCFE5,  0xCFE5 },
	{ 0xCFE6,  0xCFE6 },
	{ 0xCFE7,  0xCFE7 },
	{ 0xCFE8,  0xCFE8 },
	{ 0xCFE9,  0xCFE9 },
	{ 0xCFEA,  0xCFEA },
	{ 0xCFEB,  0xCFEB },
	{ 0xCFEC,  0xCFEC },
	{ 0xCFED,  0xCFED },
	{ 0xCFEE,  0xCFEE },
	{ 0xCFEF,  0xCFEF },
	{ 0xCFF0,  0xCFF0 },
	{ 0xCFF1,  0xCFF1 },
	{ 0xCFF2,  0xCFF2 },
	{ 0xCFF3,  0xCFF3 },
	{ 0xCFF4,  0xCFF4 },
	{ 0xCFF5,  0xCFF5 },
	{ 0xCFF6,  0xCFF6 },
	{ 0xCFF7,  0xCFF7 },
	{ 0xCFF8,  0xCFF8 },
	{ 0xCFF9,  0xCFF9 },
	{ 0xCFFA,  0xCFFA },
	{ 0xCFFB,  0xCFFB },
	{ 0xCFFC,  0xCFFC },
	{ 0xCFFD,  0xCFFD },
	{ 0xCFFE,  0xCFFE },
	{ 0xD040,  0xD040 },
	{ 0xD041,  0xD041 },
	{ 0xD042,  0xD042 },
	{ 0xD043,  0xD043 },
	{ 0xD044,  0xD044 },
	{ 0xD045,  0xD045 },
	{ 0xD046,  0xD046 },
	{ 0xD047,  0xD047 },
	{ 0xD048,  0xD048 },
	{ 0xD049,  0xD049 },
	{ 0xD04A,  0xD04A },
	{ 0xD04B,  0xD04B },
	{ 0xD04C,  0xD04C },
	{ 0xD04D,  0xD04D },
	{ 0xD04E,  0xD04E },
	{ 0xD04F,  0xD04F },
	{ 0xD050,  0xD050 },
	{ 0xD051,  0xD051 },
	{ 0xD052,  0xD052 },
	{ 0xD053,  0xD053 },
	{ 0xD054,  0xD054 },
	{ 0xD055,  0xD055 },
	{ 0xD056,  0xD056 },
	{ 0xD057,  0xD057 },
	{ 0xD058,  0xD058 },
	{ 0xD059,  0xD059 },
	{ 0xD05A,  0xD05A },
	{ 0xD05B,  0xD05B },
	{ 0xD05C,  0xD05C },
	{ 0xD05D,  0xD05D },
	{ 0xD05E,  0xD05E },
	{ 0xD05F,  0xD05F },
	{ 0xD060,  0xD060 },
	{ 0xD061,  0xD061 },
	{ 0xD062,  0xD062 },
	{ 0xD063,  0xD063 },
	{ 0xD064,  0xD064 },
	{ 0xD065,  0xD065 },
	{ 0xD066,  0xD066 },
	{ 0xD067,  0xD067 },
	{ 0xD068,  0xD068 },
	{ 0xD069,  0xD069 },
	{ 0xD06A,  0xD06A },
	{ 0xD06B,  0xD06B },
	{ 0xD06C,  0xD06C },
	{ 0xD06D,  0xD06D },
	{ 0xD06E,  0xD06E },
	{ 0xD06F,  0xD06F },
	{ 0xD070,  0xD070 },
	{ 0xD071,  0xD071 },
	{ 0xD072,  0xD072 },
	{ 0xD073,  0xD073 },
	{ 0xD074,  0xD074 },
	{ 0xD075,  0xD075 },
	{ 0xD076,  0xD076 },
	{ 0xD077,  0xD077 },
	{ 0xD078,  0xD078 },
	{ 0xD079,  0xD079 },
	{ 0xD07A,  0xD07A },
	{ 0xD07B,  0xD07B },
	{ 0xD07C,  0xD07C },
	{ 0xD07D,  0xD07D },
	{ 0xD07E,  0xD07E },
	{ 0xD0A1,  0xD0A1 },
	{ 0xD0A2,  0xD0A2 },
	{ 0xD0A3,  0xD0A3 },
	{ 0xD0A4,  0xD0A4 },
	{ 0xD0A5,  0xD0A5 },
	{ 0xD0A6,  0xD0A6 },
	{ 0xD0A7,  0xD0A7 },
	{ 0xD0A8,  0xD0A8 },
	{ 0xD0A9,  0xD0A9 },
	{ 0xD0AA,  0xD0AA },
	{ 0xD0AB,  0xD0AB },
	{ 0xD0AC,  0xD0AC },
	{ 0xD0AD,  0xD0AD },
	{ 0xD0AE,  0xD0AE },
	{ 0xD0AF,  0xD0AF },
	{ 0xD0B0,  0xD0B0 },
	{ 0xD0B1,  0xD0B1 },
	{ 0xD0B2,  0xD0B2 },
	{ 0xD0B3,  0xD0B3 },
	{ 0xD0B4,  0xD0B4 },
	{ 0xD0B5,  0xD0B5 },
	{ 0xD0B6,  0xD0B6 },
	{ 0xD0B7,  0xD0B7 },
	{ 0xD0B8,  0xD0B8 },
	{ 0xD0B9,  0xD0B9 },
	{ 0xD0BA,  0xD0BA },
	{ 0xD0BB,  0xD0BB },
	{ 0xD0BC,  0xD0BC },
	{ 0xD0BD,  0xD0BD },
	{ 0xD0BE,  0xD0BE },
	{ 0xD0BF,  0xD0BF },
	{ 0xD0C0,  0xD0C0 },
	{ 0xD0C1,  0xD0C1 },
	{ 0xD0C2,  0xD0C2 },
	{ 0xD0C3,  0xD0C3 },
	{ 0xD0C4,  0xD0C4 },
	{ 0xD0C5,  0xD0C5 },
	{ 0xD0C6,  0xD0C6 },
	{ 0xD0C7,  0xD0C7 },
	{ 0xD0C8,  0xD0C8 },
	{ 0xD0C9,  0xD0C9 },
	{ 0xD0CA,  0xD0CA },
	{ 0xD0CB,  0xD0CB },
	{ 0xD0CC,  0xD0CC },
	{ 0xD0CD,  0xD0CD },
	{ 0xD0CE,  0xD0CE },
	{ 0xD0CF,  0xD0CF },
	{ 0xD0D0,  0xD0D0 },
	{ 0xD0D1,  0xD0D1 },
	{ 0xD0D2,  0xD0D2 },
	{ 0xD0D3,  0xD0D3 },
	{ 0xD0D4,  0xD0D4 },
	{ 0xD0D5,  0xD0D5 },
	{ 0xD0D6,  0xD0D6 },
	{ 0xD0D7,  0xD0D7 },
	{ 0xD0D8,  0xD0D8 },
	{ 0xD0D9,  0xD0D9 },
	{ 0xD0DA,  0xD0DA },
	{ 0xD0DB,  0xD0DB },
	{ 0xD0DC,  0xD0DC },
	{ 0xD0DD,  0xD0DD },
	{ 0xD0DE,  0xD0DE },
	{ 0xD0DF,  0xD0DF },
	{ 0xD0E0,  0xD0E0 },
	{ 0xD0E1,  0xD0E1 },
	{ 0xD0E2,  0xD0E2 },
	{ 0xD0E3,  0xD0E3 },
	{ 0xD0E4,  0xD0E4 },
	{ 0xD0E5,  0xD0E5 },
	{ 0xD0E6,  0xD0E6 },
	{ 0xD0E7,  0xD0E7 },
	{ 0xD0E8,  0xD0E8 },
	{ 0xD0E9,  0xD0E9 },
	{ 0xD0EA,  0xD0EA },
	{ 0xD0EB,  0xD0EB },
	{ 0xD0EC,  0xD0EC },
	{ 0xD0ED,  0xD0ED },
	{ 0xD0EE,  0xD0EE },
	{ 0xD0EF,  0xD0EF },
	{ 0xD0F0,  0xD0F0 },
	{ 0xD0F1,  0xD0F1 },
	{ 0xD0F2,  0xD0F2 },
	{ 0xD0F3,  0xD0F3 },
	{ 0xD0F4,  0xD0F4 },
	{ 0xD0F5,  0xD0F5 },
	{ 0xD0F6,  0xD0F6 },
	{ 0xD0F7,  0xD0F7 },
	{ 0xD0F8,  0xD0F8 },
	{ 0xD0F9,  0xD0F9 },
	{ 0xD0FA,  0xD0FA },
	{ 0xD0FB,  0xD0FB },
	{ 0xD0FC,  0xD0FC },
	{ 0xD0FD,  0xD0FD },
	{ 0xD0FE,  0xD0FE },
	{ 0xD140,  0xD140 },
	{ 0xD141,  0xD141 },
	{ 0xD142,  0xD142 },
	{ 0xD143,  0xD143 },
	{ 0xD144,  0xD144 },
	{ 0xD145,  0xD145 },
	{ 0xD146,  0xD146 },
	{ 0xD147,  0xD147 },
	{ 0xD148,  0xD148 },
	{ 0xD149,  0xD149 },
	{ 0xD14A,  0xD14A },
	{ 0xD14B,  0xD14B },
	{ 0xD14C,  0xD14C },
	{ 0xD14D,  0xD14D },
	{ 0xD14E,  0xD14E },
	{ 0xD14F,  0xD14F },
	{ 0xD150,  0xD150 },
	{ 0xD151,  0xD151 },
	{ 0xD152,  0xD152 },
	{ 0xD153,  0xD153 },
	{ 0xD154,  0xD154 },
	{ 0xD155,  0xD155 },
	{ 0xD156,  0xD156 },
	{ 0xD157,  0xD157 },
	{ 0xD158,  0xD158 },
	{ 0xD159,  0xD159 },
	{ 0xD15A,  0xD15A },
	{ 0xD15B,  0xD15B },
	{ 0xD15C,  0xD15C },
	{ 0xD15D,  0xD15D },
	{ 0xD15E,  0xD15E },
	{ 0xD15F,  0xD15F },
	{ 0xD160,  0xD160 },
	{ 0xD161,  0xD161 },
	{ 0xD162,  0xD162 },
	{ 0xD163,  0xD163 },
	{ 0xD164,  0xD164 },
	{ 0xD165,  0xD165 },
	{ 0xD166,  0xD166 },
	{ 0xD167,  0xD167 },
	{ 0xD168,  0xD168 },
	{ 0xD169,  0xD169 },
	{ 0xD16A,  0xD16A },
	{ 0xD16B,  0xD16B },
	{ 0xD16C,  0xD16C },
	{ 0xD16D,  0xD16D },
	{ 0xD16E,  0xD16E },
	{ 0xD16F,  0xD16F },
	{ 0xD170,  0xD170 },
	{ 0xD171,  0xD171 },
	{ 0xD172,  0xD172 },
	{ 0xD173,  0xD173 },
	{ 0xD174,  0xD174 },
	{ 0xD175,  0xD175 },
	{ 0xD176,  0xD176 },
	{ 0xD177,  0xD177 },
	{ 0xD178,  0xD178 },
	{ 0xD179,  0xD179 },
	{ 0xD17A,  0xD17A },
	{ 0xD17B,  0xD17B },
	{ 0xD17C,  0xD17C },
	{ 0xD17D,  0xD17D },
	{ 0xD17E,  0xD17E },
	{ 0xD1A1,  0xD1A1 },
	{ 0xD1A2,  0xD1A2 },
	{ 0xD1A3,  0xD1A3 },
	{ 0xD1A4,  0xD1A4 },
	{ 0xD1A5,  0xD1A5 },
	{ 0xD1A6,  0xD1A6 },
	{ 0xD1A7,  0xD1A7 },
	{ 0xD1A8,  0xD1A8 },
	{ 0xD1A9,  0xD1A9 },
	{ 0xD1AA,  0xD1AA },
	{ 0xD1AB,  0xD1AB },
	{ 0xD1AC,  0xD1AC },
	{ 0xD1AD,  0xD1AD },
	{ 0xD1AE,  0xD1AE },
	{ 0xD1AF,  0xD1AF },
	{ 0xD1B0,  0xD1B0 },
	{ 0xD1B1,  0xD1B1 },
	{ 0xD1B2,  0xD1B2 },
	{ 0xD1B3,  0xD1B3 },
	{ 0xD1B4,  0xD1B4 },
	{ 0xD1B5,  0xD1B5 },
	{ 0xD1B6,  0xD1B6 },
	{ 0xD1B7,  0xD1B7 },
	{ 0xD1B8,  0xD1B8 },
	{ 0xD1B9,  0xD1B9 },
	{ 0xD1BA,  0xD1BA },
	{ 0xD1BB,  0xD1BB },
	{ 0xD1BC,  0xD1BC },
	{ 0xD1BD,  0xD1BD },
	{ 0xD1BE,  0xD1BE },
	{ 0xD1BF,  0xD1BF },
	{ 0xD1C0,  0xD1C0 },
	{ 0xD1C1,  0xD1C1 },
	{ 0xD1C2,  0xD1C2 },
	{ 0xD1C3,  0xD1C3 },
	{ 0xD1C4,  0xD1C4 },
	{ 0xD1C5,  0xD1C5 },
	{ 0xD1C6,  0xD1C6 },
	{ 0xD1C7,  0xD1C7 },
	{ 0xD1C8,  0xD1C8 },
	{ 0xD1C9,  0xD1C9 },
	{ 0xD1CA,  0xD1CA },
	{ 0xD1CB,  0xD1CB },
	{ 0xD1CC,  0xD1CC },
	{ 0xD1CD,  0xD1CD },
	{ 0xD1CE,  0xD1CE },
	{ 0xD1CF,  0xD1CF },
	{ 0xD1D0,  0xD1D0 },
	{ 0xD1D1,  0xD1D1 },
	{ 0xD1D2,  0xD1D2 },
	{ 0xD1D3,  0xD1D3 },
	{ 0xD1D4,  0xD1D4 },
	{ 0xD1D5,  0xD1D5 },
	{ 0xD1D6,  0xD1D6 },
	{ 0xD1D7,  0xD1D7 },
	{ 0xD1D8,  0xD1D8 },
	{ 0xD1D9,  0xD1D9 },
	{ 0xD1DA,  0xD1DA },
	{ 0xD1DB,  0xD1DB },
	{ 0xD1DC,  0xD1DC },
	{ 0xD1DD,  0xD1DD },
	{ 0xD1DE,  0xD1DE },
	{ 0xD1DF,  0xD1DF },
	{ 0xD1E0,  0xD1E0 },
	{ 0xD1E1,  0xD1E1 },
	{ 0xD1E2,  0xD1E2 },
	{ 0xD1E3,  0xD1E3 },
	{ 0xD1E4,  0xD1E4 },
	{ 0xD1E5,  0xD1E5 },
	{ 0xD1E6,  0xD1E6 },
	{ 0xD1E7,  0xD1E7 },
	{ 0xD1E8,  0xD1E8 },
	{ 0xD1E9,  0xD1E9 },
	{ 0xD1EA,  0xD1EA },
	{ 0xD1EB,  0xD1EB },
	{ 0xD1EC,  0xD1EC },
	{ 0xD1ED,  0xD1ED },
	{ 0xD1EE,  0xD1EE },
	{ 0xD1EF,  0xD1EF },
	{ 0xD1F0,  0xD1F0 },
	{ 0xD1F1,  0xD1F1 },
	{ 0xD1F2,  0xD1F2 },
	{ 0xD1F3,  0xD1F3 },
	{ 0xD1F4,  0xD1F4 },
	{ 0xD1F5,  0xD1F5 },
	{ 0xD1F6,  0xD1F6 },
	{ 0xD1F7,  0xD1F7 },
	{ 0xD1F8,  0xD1F8 },
	{ 0xD1F9,  0xD1F9 },
	{ 0xD1FA,  0xD1FA },
	{ 0xD1FB,  0xD1FB },
	{ 0xD1FC,  0xD1FC },
	{ 0xD1FD,  0xD1FD },
	{ 0xD1FE,  0xD1FE },
	{ 0xD240,  0xD240 },
	{ 0xD241,  0xD241 },
	{ 0xD242,  0xD242 },
	{ 0xD243,  0xD243 },
	{ 0xD244,  0xD244 },
	{ 0xD245,  0xD245 },
	{ 0xD246,  0xD246 },
	{ 0xD247,  0xD247 },
	{ 0xD248,  0xD248 },
	{ 0xD249,  0xD249 },
	{ 0xD24A,  0xD24A },
	{ 0xD24B,  0xD24B },
	{ 0xD24C,  0xD24C },
	{ 0xD24D,  0xD24D },
	{ 0xD24E,  0xD24E },
	{ 0xD24F,  0xD24F },
	{ 0xD250,  0xD250 },
	{ 0xD251,  0xD251 },
	{ 0xD252,  0xD252 },
	{ 0xD253,  0xD253 },
	{ 0xD254,  0xD254 },
	{ 0xD255,  0xD255 },
	{ 0xD256,  0xD256 },
	{ 0xD257,  0xD257 },
	{ 0xD258,  0xD258 },
	{ 0xD259,  0xD259 },
	{ 0xD25A,  0xD25A },
	{ 0xD25B,  0xD25B },
	{ 0xD25C,  0xD25C },
	{ 0xD25D,  0xD25D },
	{ 0xD25E,  0xD25E },
	{ 0xD25F,  0xD25F },
	{ 0xD260,  0xD260 },
	{ 0xD261,  0xD261 },
	{ 0xD262,  0xD262 },
	{ 0xD263,  0xD263 },
	{ 0xD264,  0xD264 },
	{ 0xD265,  0xD265 },
	{ 0xD266,  0xD266 },
	{ 0xD267,  0xD267 },
	{ 0xD268,  0xD268 },
	{ 0xD269,  0xD269 },
	{ 0xD26A,  0xD26A },
	{ 0xD26B,  0xD26B },
	{ 0xD26C,  0xD26C },
	{ 0xD26D,  0xD26D },
	{ 0xD26E,  0xD26E },
	{ 0xD26F,  0xD26F },
	{ 0xD270,  0xD270 },
	{ 0xD271,  0xD271 },
	{ 0xD272,  0xD272 },
	{ 0xD273,  0xD273 },
	{ 0xD274,  0xD274 },
	{ 0xD275,  0xD275 },
	{ 0xD276,  0xD276 },
	{ 0xD277,  0xD277 },
	{ 0xD278,  0xD278 },
	{ 0xD279,  0xD279 },
	{ 0xD27A,  0xD27A },
	{ 0xD27B,  0xD27B },
	{ 0xD27C,  0xD27C },
	{ 0xD27D,  0xD27D },
	{ 0xD27E,  0xD27E },
	{ 0xD2A1,  0xD2A1 },
	{ 0xD2A2,  0xD2A2 },
	{ 0xD2A3,  0xD2A3 },
	{ 0xD2A4,  0xD2A4 },
	{ 0xD2A5,  0xD2A5 },
	{ 0xD2A6,  0xD2A6 },
	{ 0xD2A7,  0xD2A7 },
	{ 0xD2A8,  0xD2A8 },
	{ 0xD2A9,  0xD2A9 },
	{ 0xD2AA,  0xD2AA },
	{ 0xD2AB,  0xD2AB },
	{ 0xD2AC,  0xD2AC },
	{ 0xD2AD,  0xD2AD },
	{ 0xD2AE,  0xD2AE },
	{ 0xD2AF,  0xD2AF },
	{ 0xD2B0,  0xD2B0 },
	{ 0xD2B1,  0xD2B1 },
	{ 0xD2B2,  0xD2B2 },
	{ 0xD2B3,  0xD2B3 },
	{ 0xD2B4,  0xD2B4 },
	{ 0xD2B5,  0xD2B5 },
	{ 0xD2B6,  0xD2B6 },
	{ 0xD2B7,  0xD2B7 },
	{ 0xD2B8,  0xD2B8 },
	{ 0xD2B9,  0xD2B9 },
	{ 0xD2BA,  0xD2BA },
	{ 0xD2BB,  0xD2BB },
	{ 0xD2BC,  0xD2BC },
	{ 0xD2BD,  0xD2BD },
	{ 0xD2BE,  0xD2BE },
	{ 0xD2BF,  0xD2BF },
	{ 0xD2C0,  0xD2C0 },
	{ 0xD2C1,  0xD2C1 },
	{ 0xD2C2,  0xD2C2 },
	{ 0xD2C3,  0xD2C3 },
	{ 0xD2C4,  0xD2C4 },
	{ 0xD2C5,  0xD2C5 },
	{ 0xD2C6,  0xD2C6 },
	{ 0xD2C7,  0xD2C7 },
	{ 0xD2C8,  0xD2C8 },
	{ 0xD2C9,  0xD2C9 },
	{ 0xD2CA,  0xD2CA },
	{ 0xD2CB,  0xD2CB },
	{ 0xD2CC,  0xD2CC },
	{ 0xD2CD,  0xD2CD },
	{ 0xD2CE,  0xD2CE },
	{ 0xD2CF,  0xD2CF },
	{ 0xD2D0,  0xD2D0 },
	{ 0xD2D1,  0xD2D1 },
	{ 0xD2D2,  0xD2D2 },
	{ 0xD2D3,  0xD2D3 },
	{ 0xD2D4,  0xD2D4 },
	{ 0xD2D5,  0xD2D5 },
	{ 0xD2D6,  0xD2D6 },
	{ 0xD2D7,  0xD2D7 },
	{ 0xD2D8,  0xD2D8 },
	{ 0xD2D9,  0xD2D9 },
	{ 0xD2DA,  0xD2DA },
	{ 0xD2DB,  0xD2DB },
	{ 0xD2DC,  0xD2DC },
	{ 0xD2DD,  0xD2DD },
	{ 0xD2DE,  0xD2DE },
	{ 0xD2DF,  0xD2DF },
	{ 0xD2E0,  0xD2E0 },
	{ 0xD2E1,  0xD2E1 },
	{ 0xD2E2,  0xD2E2 },
	{ 0xD2E3,  0xD2E3 },
	{ 0xD2E4,  0xD2E4 },
	{ 0xD2E5,  0xD2E5 },
	{ 0xD2E6,  0xD2E6 },
	{ 0xD2E7,  0xD2E7 },
	{ 0xD2E8,  0xD2E8 },
	{ 0xD2E9,  0xD2E9 },
	{ 0xD2EA,  0xD2EA },
	{ 0xD2EB,  0xD2EB },
	{ 0xD2EC,  0xD2EC },
	{ 0xD2ED,  0xD2ED },
	{ 0xD2EE,  0xD2EE },
	{ 0xD2EF,  0xD2EF },
	{ 0xD2F0,  0xD2F0 },
	{ 0xD2F1,  0xD2F1 },
	{ 0xD2F2,  0xD2F2 },
	{ 0xD2F3,  0xD2F3 },
	{ 0xD2F4,  0xD2F4 },
	{ 0xD2F5,  0xD2F5 },
	{ 0xD2F6,  0xD2F6 },
	{ 0xD2F7,  0xD2F7 },
	{ 0xD2F8,  0xD2F8 },
	{ 0xD2F9,  0xD2F9 },
	{ 0xD2FA,  0xD2FA },
	{ 0xD2FB,  0xD2FB },
	{ 0xD2FC,  0xD2FC },
	{ 0xD2FD,  0xD2FD },
	{ 0xD2FE,  0xD2FE },
	{ 0xD340,  0xD340 },
	{ 0xD341,  0xD341 },
	{ 0xD342,  0xD342 },
	{ 0xD343,  0xD343 },
	{ 0xD344,  0xD344 },
	{ 0xD345,  0xD345 },
	{ 0xD346,  0xD346 },
	{ 0xD347,  0xD347 },
	{ 0xD348,  0xD348 },
	{ 0xD349,  0xD349 },
	{ 0xD34A,  0xD34A },
	{ 0xD34B,  0xD34B },
	{ 0xD34C,  0xD34C },
	{ 0xD34D,  0xD34D },
	{ 0xD34E,  0xD34E },
	{ 0xD34F,  0xD34F },
	{ 0xD350,  0xD350 },
	{ 0xD351,  0xD351 },
	{ 0xD352,  0xD352 },
	{ 0xD353,  0xD353 },
	{ 0xD354,  0xD354 },
	{ 0xD355,  0xD355 },
	{ 0xD356,  0xD356 },
	{ 0xD357,  0xD357 },
	{ 0xD358,  0xD358 },
	{ 0xD359,  0xD359 },
	{ 0xD35A,  0xD35A },
	{ 0xD35B,  0xD35B },
	{ 0xD35C,  0xD35C },
	{ 0xD35D,  0xD35D },
	{ 0xD35E,  0xD35E },
	{ 0xD35F,  0xD35F },
	{ 0xD360,  0xD360 },
	{ 0xD361,  0xD361 },
	{ 0xD362,  0xD362 },
	{ 0xD363,  0xD363 },
	{ 0xD364,  0xD364 },
	{ 0xD365,  0xD365 },
	{ 0xD366,  0xD366 },
	{ 0xD367,  0xD367 },
	{ 0xD368,  0xD368 },
	{ 0xD369,  0xD369 },
	{ 0xD36A,  0xD36A },
	{ 0xD36B,  0xD36B },
	{ 0xD36C,  0xD36C },
	{ 0xD36D,  0xD36D },
	{ 0xD36E,  0xD36E },
	{ 0xD36F,  0xD36F },
	{ 0xD370,  0xD370 },
	{ 0xD371,  0xD371 },
	{ 0xD372,  0xD372 },
	{ 0xD373,  0xD373 },
	{ 0xD374,  0xD374 },
	{ 0xD375,  0xD375 },
	{ 0xD376,  0xD376 },
	{ 0xD377,  0xD377 },
	{ 0xD378,  0xD378 },
	{ 0xD379,  0xD379 },
	{ 0xD37A,  0xD37A },
	{ 0xD37B,  0xD37B },
	{ 0xD37C,  0xD37C },
	{ 0xD37D,  0xD37D },
	{ 0xD37E,  0xD37E },
	{ 0xD3A1,  0xD3A1 },
	{ 0xD3A2,  0xD3A2 },
	{ 0xD3A3,  0xD3A3 },
	{ 0xD3A4,  0xD3A4 },
	{ 0xD3A5,  0xD3A5 },
	{ 0xD3A6,  0xD3A6 },
	{ 0xD3A7,  0xD3A7 },
	{ 0xD3A8,  0xD3A8 },
	{ 0xD3A9,  0xD3A9 },
	{ 0xD3AA,  0xD3AA },
	{ 0xD3AB,  0xD3AB },
	{ 0xD3AC,  0xD3AC },
	{ 0xD3AD,  0xD3AD },
	{ 0xD3AE,  0xD3AE },
	{ 0xD3AF,  0xD3AF },
	{ 0xD3B0,  0xD3B0 },
	{ 0xD3B1,  0xD3B1 },
	{ 0xD3B2,  0xD3B2 },
	{ 0xD3B3,  0xD3B3 },
	{ 0xD3B4,  0xD3B4 },
	{ 0xD3B5,  0xD3B5 },
	{ 0xD3B6,  0xD3B6 },
	{ 0xD3B7,  0xD3B7 },
	{ 0xD3B8,  0xD3B8 },
	{ 0xD3B9,  0xD3B9 },
	{ 0xD3BA,  0xD3BA },
	{ 0xD3BB,  0xD3BB },
	{ 0xD3BC,  0xD3BC },
	{ 0xD3BD,  0xD3BD },
	{ 0xD3BE,  0xD3BE },
	{ 0xD3BF,  0xD3BF },
	{ 0xD3C0,  0xD3C0 },
	{ 0xD3C1,  0xD3C1 },
	{ 0xD3C2,  0xD3C2 },
	{ 0xD3C3,  0xD3C3 },
	{ 0xD3C4,  0xD3C4 },
	{ 0xD3C5,  0xD3C5 },
	{ 0xD3C6,  0xD3C6 },
	{ 0xD3C7,  0xD3C7 },
	{ 0xD3C8,  0xD3C8 },
	{ 0xD3C9,  0xD3C9 },
	{ 0xD3CA,  0xD3CA },
	{ 0xD3CB,  0xD3CB },
	{ 0xD3CC,  0xD3CC },
	{ 0xD3CD,  0xD3CD },
	{ 0xD3CE,  0xD3CE },
	{ 0xD3CF,  0xD3CF },
	{ 0xD3D0,  0xD3D0 },
	{ 0xD3D1,  0xD3D1 },
	{ 0xD3D2,  0xD3D2 },
	{ 0xD3D3,  0xD3D3 },
	{ 0xD3D4,  0xD3D4 },
	{ 0xD3D5,  0xD3D5 },
	{ 0xD3D6,  0xD3D6 },
	{ 0xD3D7,  0xD3D7 },
	{ 0xD3D8,  0xD3D8 },
	{ 0xD3D9,  0xD3D9 },
	{ 0xD3DA,  0xD3DA },
	{ 0xD3DB,  0xD3DB },
	{ 0xD3DC,  0xD3DC },
	{ 0xD3DD,  0xD3DD },
	{ 0xD3DE,  0xD3DE },
	{ 0xD3DF,  0xD3DF },
	{ 0xD3E0,  0xD3E0 },
	{ 0xD3E1,  0xD3E1 },
	{ 0xD3E2,  0xD3E2 },
	{ 0xD3E3,  0xD3E3 },
	{ 0xD3E4,  0xD3E4 },
	{ 0xD3E5,  0xD3E5 },
	{ 0xD3E6,  0xD3E6 },
	{ 0xD3E7,  0xD3E7 },
	{ 0xD3E8,  0xD3E8 },
	{ 0xD3E9,  0xD3E9 },
	{ 0xD3EA,  0xD3EA },
	{ 0xD3EB,  0xD3EB },
	{ 0xD3EC,  0xD3EC },
	{ 0xD3ED,  0xD3ED },
	{ 0xD3EE,  0xD3EE },
	{ 0xD3EF,  0xD3EF },
	{ 0xD3F0,  0xD3F0 },
	{ 0xD3F1,  0xD3F1 },
	{ 0xD3F2,  0xD3F2 },
	{ 0xD3F3,  0xD3F3 },
	{ 0xD3F4,  0xD3F4 },
	{ 0xD3F5,  0xD3F5 },
	{ 0xD3F6,  0xD3F6 },
	{ 0xD3F7,  0xD3F7 },
	{ 0xD3F8,  0xD3F8 },
	{ 0xD3F9,  0xD3F9 },
	{ 0xD3FA,  0xD3FA },
	{ 0xD3FB,  0xD3FB },
	{ 0xD3FC,  0xD3FC },
	{ 0xD3FD,  0xD3FD },
	{ 0xD3FE,  0xD3FE },
	{ 0xD440,  0xD440 },
	{ 0xD441,  0xD441 },
	{ 0xD442,  0xD442 },
	{ 0xD443,  0xD443 },
	{ 0xD444,  0xD444 },
	{ 0xD445,  0xD445 },
	{ 0xD446,  0xD446 },
	{ 0xD447,  0xD447 },
	{ 0xD448,  0xD448 },
	{ 0xD449,  0xD449 },
	{ 0xD44A,  0xD44A },
	{ 0xD44B,  0xD44B },
	{ 0xD44C,  0xD44C },
	{ 0xD44D,  0xD44D },
	{ 0xD44E,  0xD44E },
	{ 0xD44F,  0xD44F },
	{ 0xD450,  0xD450 },
	{ 0xD451,  0xD451 },
	{ 0xD452,  0xD452 },
	{ 0xD453,  0xD453 },
	{ 0xD454,  0xD454 },
	{ 0xD455,  0xD455 },
	{ 0xD456,  0xD456 },
	{ 0xD457,  0xD457 },
	{ 0xD458,  0xD458 },
	{ 0xD459,  0xD459 },
	{ 0xD45A,  0xD45A },
	{ 0xD45B,  0xD45B },
	{ 0xD45C,  0xD45C },
	{ 0xD45D,  0xD45D },
	{ 0xD45E,  0xD45E },
	{ 0xD45F,  0xD45F },
	{ 0xD460,  0xD460 },
	{ 0xD461,  0xD461 },
	{ 0xD462,  0xD462 },
	{ 0xD463,  0xD463 },
	{ 0xD464,  0xD464 },
	{ 0xD465,  0xD465 },
	{ 0xD466,  0xD466 },
	{ 0xD467,  0xD467 },
	{ 0xD468,  0xD468 },
	{ 0xD469,  0xD469 },
	{ 0xD46A,  0xD46A },
	{ 0xD46B,  0xD46B },
	{ 0xD46C,  0xD46C },
	{ 0xD46D,  0xD46D },
	{ 0xD46E,  0xD46E },
	{ 0xD46F,  0xD46F },
	{ 0xD470,  0xD470 },
	{ 0xD471,  0xD471 },
	{ 0xD472,  0xD472 },
	{ 0xD473,  0xD473 },
	{ 0xD474,  0xD474 },
	{ 0xD475,  0xD475 },
	{ 0xD476,  0xD476 },
	{ 0xD477,  0xD477 },
	{ 0xD478,  0xD478 },
	{ 0xD479,  0xD479 },
	{ 0xD47A,  0xD47A },
	{ 0xD47B,  0xD47B },
	{ 0xD47C,  0xD47C },
	{ 0xD47D,  0xD47D },
	{ 0xD47E,  0xD47E },
	{ 0xD4A1,  0xD4A1 },
	{ 0xD4A2,  0xD4A2 },
	{ 0xD4A3,  0xD4A3 },
	{ 0xD4A4,  0xD4A4 },
	{ 0xD4A5,  0xD4A5 },
	{ 0xD4A6,  0xD4A6 },
	{ 0xD4A7,  0xD4A7 },
	{ 0xD4A8,  0xD4A8 },
	{ 0xD4A9,  0xD4A9 },
	{ 0xD4AA,  0xD4AA },
	{ 0xD4AB,  0xD4AB },
	{ 0xD4AC,  0xD4AC },
	{ 0xD4AD,  0xD4AD },
	{ 0xD4AE,  0xD4AE },
	{ 0xD4AF,  0xD4AF },
	{ 0xD4B0,  0xD4B0 },
	{ 0xD4B1,  0xD4B1 },
	{ 0xD4B2,  0xD4B2 },
	{ 0xD4B3,  0xD4B3 },
	{ 0xD4B4,  0xD4B4 },
	{ 0xD4B5,  0xD4B5 },
	{ 0xD4B6,  0xD4B6 },
	{ 0xD4B7,  0xD4B7 },
	{ 0xD4B8,  0xD4B8 },
	{ 0xD4B9,  0xD4B9 },
	{ 0xD4BA,  0xD4BA },
	{ 0xD4BB,  0xD4BB },
	{ 0xD4BC,  0xD4BC },
	{ 0xD4BD,  0xD4BD },
	{ 0xD4BE,  0xD4BE },
	{ 0xD4BF,  0xD4BF },
	{ 0xD4C0,  0xD4C0 },
	{ 0xD4C1,  0xD4C1 },
	{ 0xD4C2,  0xD4C2 },
	{ 0xD4C3,  0xD4C3 },
	{ 0xD4C4,  0xD4C4 },
	{ 0xD4C5,  0xD4C5 },
	{ 0xD4C6,  0xD4C6 },
	{ 0xD4C7,  0xD4C7 },
	{ 0xD4C8,  0xD4C8 },
	{ 0xD4C9,  0xD4C9 },
	{ 0xD4CA,  0xD4CA },
	{ 0xD4CB,  0xD4CB },
	{ 0xD4CC,  0xD4CC },
	{ 0xD4CD,  0xD4CD },
	{ 0xD4CE,  0xD4CE },
	{ 0xD4CF,  0xD4CF },
	{ 0xD4D0,  0xD4D0 },
	{ 0xD4D1,  0xD4D1 },
	{ 0xD4D2,  0xD4D2 },
	{ 0xD4D3,  0xD4D3 },
	{ 0xD4D4,  0xD4D4 },
	{ 0xD4D5,  0xD4D5 },
	{ 0xD4D6,  0xD4D6 },
	{ 0xD4D7,  0xD4D7 },
	{ 0xD4D8,  0xD4D8 },
	{ 0xD4D9,  0xD4D9 },
	{ 0xD4DA,  0xD4DA },
	{ 0xD4DB,  0xD4DB },
	{ 0xD4DC,  0xD4DC },
	{ 0xD4DD,  0xD4DD },
	{ 0xD4DE,  0xD4DE },
	{ 0xD4DF,  0xD4DF },
	{ 0xD4E0,  0xD4E0 },
	{ 0xD4E1,  0xD4E1 },
	{ 0xD4E2,  0xD4E2 },
	{ 0xD4E3,  0xD4E3 },
	{ 0xD4E4,  0xD4E4 },
	{ 0xD4E5,  0xD4E5 },
	{ 0xD4E6,  0xD4E6 },
	{ 0xD4E7,  0xD4E7 },
	{ 0xD4E8,  0xD4E8 },
	{ 0xD4E9,  0xD4E9 },
	{ 0xD4EA,  0xD4EA },
	{ 0xD4EB,  0xD4EB },
	{ 0xD4EC,  0xD4EC },
	{ 0xD4ED,  0xD4ED },
	{ 0xD4EE,  0xD4EE },
	{ 0xD4EF,  0xD4EF },
	{ 0xD4F0,  0xD4F0 },
	{ 0xD4F1,  0xD4F1 },
	{ 0xD4F2,  0xD4F2 },
	{ 0xD4F3,  0xD4F3 },
	{ 0xD4F4,  0xD4F4 },
	{ 0xD4F5,  0xD4F5 },
	{ 0xD4F6,  0xD4F6 },
	{ 0xD4F7,  0xD4F7 },
	{ 0xD4F8,  0xD4F8 },
	{ 0xD4F9,  0xD4F9 },
	{ 0xD4FA,  0xD4FA },
	{ 0xD4FB,  0xD4FB },
	{ 0xD4FC,  0xD4FC },
	{ 0xD4FD,  0xD4FD },
	{ 0xD4FE,  0xD4FE },
	{ 0xD540,  0xD540 },
	{ 0xD541,  0xD541 },
	{ 0xD542,  0xD542 },
	{ 0xD543,  0xD543 },
	{ 0xD544,  0xD544 },
	{ 0xD545,  0xD545 },
	{ 0xD546,  0xD546 },
	{ 0xD547,  0xD547 },
	{ 0xD548,  0xD548 },
	{ 0xD549,  0xD549 },
	{ 0xD54A,  0xD54A },
	{ 0xD54B,  0xD54B },
	{ 0xD54C,  0xD54C },
	{ 0xD54D,  0xD54D },
	{ 0xD54E,  0xD54E },
	{ 0xD54F,  0xD54F },
	{ 0xD550,  0xD550 },
	{ 0xD551,  0xD551 },
	{ 0xD552,  0xD552 },
	{ 0xD553,  0xD553 },
	{ 0xD554,  0xD554 },
	{ 0xD555,  0xD555 },
	{ 0xD556,  0xD556 },
	{ 0xD557,  0xD557 },
	{ 0xD558,  0xD558 },
	{ 0xD559,  0xD559 },
	{ 0xD55A,  0xD55A },
	{ 0xD55B,  0xD55B },
	{ 0xD55C,  0xD55C },
	{ 0xD55D,  0xD55D },
	{ 0xD55E,  0xD55E },
	{ 0xD55F,  0xD55F },
	{ 0xD560,  0xD560 },
	{ 0xD561,  0xD561 },
	{ 0xD562,  0xD562 },
	{ 0xD563,  0xD563 },
	{ 0xD564,  0xD564 },
	{ 0xD565,  0xD565 },
	{ 0xD566,  0xD566 },
	{ 0xD567,  0xD567 },
	{ 0xD568,  0xD568 },
	{ 0xD569,  0xD569 },
	{ 0xD56A,  0xD56A },
	{ 0xD56B,  0xD56B },
	{ 0xD56C,  0xD56C },
	{ 0xD56D,  0xD56D },
	{ 0xD56E,  0xD56E },
	{ 0xD56F,  0xD56F },
	{ 0xD570,  0xD570 },
	{ 0xD571,  0xD571 },
	{ 0xD572,  0xD572 },
	{ 0xD573,  0xD573 },
	{ 0xD574,  0xD574 },
	{ 0xD575,  0xD575 },
	{ 0xD576,  0xD576 },
	{ 0xD577,  0xD577 },
	{ 0xD578,  0xD578 },
	{ 0xD579,  0xD579 },
	{ 0xD57A,  0xD57A },
	{ 0xD57B,  0xD57B },
	{ 0xD57C,  0xD57C },
	{ 0xD57D,  0xD57D },
	{ 0xD57E,  0xD57E },
	{ 0xD5A1,  0xD5A1 },
	{ 0xD5A2,  0xD5A2 },
	{ 0xD5A3,  0xD5A3 },
	{ 0xD5A4,  0xD5A4 },
	{ 0xD5A5,  0xD5A5 },
	{ 0xD5A6,  0xD5A6 },
	{ 0xD5A7,  0xD5A7 },
	{ 0xD5A8,  0xD5A8 },
	{ 0xD5A9,  0xD5A9 },
	{ 0xD5AA,  0xD5AA },
	{ 0xD5AB,  0xD5AB },
	{ 0xD5AC,  0xD5AC },
	{ 0xD5AD,  0xD5AD },
	{ 0xD5AE,  0xD5AE },
	{ 0xD5AF,  0xD5AF },
	{ 0xD5B0,  0xD5B0 },
	{ 0xD5B1,  0xD5B1 },
	{ 0xD5B2,  0xD5B2 },
	{ 0xD5B3,  0xD5B3 },
	{ 0xD5B4,  0xD5B4 },
	{ 0xD5B5,  0xD5B5 },
	{ 0xD5B6,  0xD5B6 },
	{ 0xD5B7,  0xD5B7 },
	{ 0xD5B8,  0xD5B8 },
	{ 0xD5B9,  0xD5B9 },
	{ 0xD5BA,  0xD5BA },
	{ 0xD5BB,  0xD5BB },
	{ 0xD5BC,  0xD5BC },
	{ 0xD5BD,  0xD5BD },
	{ 0xD5BE,  0xD5BE },
	{ 0xD5BF,  0xD5BF },
	{ 0xD5C0,  0xD5C0 },
	{ 0xD5C1,  0xD5C1 },
	{ 0xD5C2,  0xD5C2 },
	{ 0xD5C3,  0xD5C3 },
	{ 0xD5C4,  0xD5C4 },
	{ 0xD5C5,  0xD5C5 },
	{ 0xD5C6,  0xD5C6 },
	{ 0xD5C7,  0xD5C7 },
	{ 0xD5C8,  0xD5C8 },
	{ 0xD5C9,  0xD5C9 },
	{ 0xD5CA,  0xD5CA },
	{ 0xD5CB,  0xD5CB },
	{ 0xD5CC,  0xD5CC },
	{ 0xD5CD,  0xD5CD },
	{ 0xD5CE,  0xD5CE },
	{ 0xD5CF,  0xD5CF },
	{ 0xD5D0,  0xD5D0 },
	{ 0xD5D1,  0xD5D1 },
	{ 0xD5D2,  0xD5D2 },
	{ 0xD5D3,  0xD5D3 },
	{ 0xD5D4,  0xD5D4 },
	{ 0xD5D5,  0xD5D5 },
	{ 0xD5D6,  0xD5D6 },
	{ 0xD5D7,  0xD5D7 },
	{ 0xD5D8,  0xD5D8 },
	{ 0xD5D9,  0xD5D9 },
	{ 0xD5DA,  0xD5DA },
	{ 0xD5DB,  0xD5DB },
	{ 0xD5DC,  0xD5DC },
	{ 0xD5DD,  0xD5DD },
	{ 0xD5DE,  0xD5DE },
	{ 0xD5DF,  0xD5DF },
	{ 0xD5E0,  0xD5E0 },
	{ 0xD5E1,  0xD5E1 },
	{ 0xD5E2,  0xD5E2 },
	{ 0xD5E3,  0xD5E3 },
	{ 0xD5E4,  0xD5E4 },
	{ 0xD5E5,  0xD5E5 },
	{ 0xD5E6,  0xD5E6 },
	{ 0xD5E7,  0xD5E7 },
	{ 0xD5E8,  0xD5E8 },
	{ 0xD5E9,  0xD5E9 },
	{ 0xD5EA,  0xD5EA },
	{ 0xD5EB,  0xD5EB },
	{ 0xD5EC,  0xD5EC },
	{ 0xD5ED,  0xD5ED },
	{ 0xD5EE,  0xD5EE },
	{ 0xD5EF,  0xD5EF },
	{ 0xD5F0,  0xD5F0 },
	{ 0xD5F1,  0xD5F1 },
	{ 0xD5F2,  0xD5F2 },
	{ 0xD5F3,  0xD5F3 },
	{ 0xD5F4,  0xD5F4 },
	{ 0xD5F5,  0xD5F5 },
	{ 0xD5F6,  0xD5F6 },
	{ 0xD5F7,  0xD5F7 },
	{ 0xD5F8,  0xD5F8 },
	{ 0xD5F9,  0xD5F9 },
	{ 0xD5FA,  0xD5FA },
	{ 0xD5FB,  0xD5FB },
	{ 0xD5FC,  0xD5FC },
	{ 0xD5FD,  0xD5FD },
	{ 0xD5FE,  0xD5FE },
	{ 0xD640,  0xD640 },
	{ 0xD641,  0xD641 },
	{ 0xD642,  0xD642 },
	{ 0xD643,  0xD643 },
	{ 0xD644,  0xD644 },
	{ 0xD645,  0xD645 },
	{ 0xD646,  0xD646 },
	{ 0xD647,  0xD647 },
	{ 0xD648,  0xD648 },
	{ 0xD649,  0xD649 },
	{ 0xD64A,  0xD64A },
	{ 0xD64B,  0xD64B },
	{ 0xD64C,  0xD64C },
	{ 0xD64D,  0xD64D },
	{ 0xD64E,  0xD64E },
	{ 0xD64F,  0xD64F },
	{ 0xD650,  0xD650 },
	{ 0xD651,  0xD651 },
	{ 0xD652,  0xD652 },
	{ 0xD653,  0xD653 },
	{ 0xD654,  0xD654 },
	{ 0xD655,  0xD655 },
	{ 0xD656,  0xD656 },
	{ 0xD657,  0xD657 },
	{ 0xD658,  0xD658 },
	{ 0xD659,  0xD659 },
	{ 0xD65A,  0xD65A },
	{ 0xD65B,  0xD65B },
	{ 0xD65C,  0xD65C },
	{ 0xD65D,  0xD65D },
	{ 0xD65E,  0xD65E },
	{ 0xD65F,  0xD65F },
	{ 0xD660,  0xD660 },
	{ 0xD661,  0xD661 },
	{ 0xD662,  0xD662 },
	{ 0xD663,  0xD663 },
	{ 0xD664,  0xD664 },
	{ 0xD665,  0xD665 },
	{ 0xD666,  0xD666 },
	{ 0xD667,  0xD667 },
	{ 0xD668,  0xD668 },
	{ 0xD669,  0xD669 },
	{ 0xD66A,  0xD66A },
	{ 0xD66B,  0xD66B },
	{ 0xD66C,  0xD66C },
	{ 0xD66D,  0xD66D },
	{ 0xD66E,  0xD66E },
	{ 0xD66F,  0xD66F },
	{ 0xD670,  0xD670 },
	{ 0xD671,  0xD671 },
	{ 0xD672,  0xD672 },
	{ 0xD673,  0xD673 },
	{ 0xD674,  0xD674 },
	{ 0xD675,  0xD675 },
	{ 0xD676,  0xD676 },
	{ 0xD677,  0xD677 },
	{ 0xD678,  0xD678 },
	{ 0xD679,  0xD679 },
	{ 0xD67A,  0xD67A },
	{ 0xD67B,  0xD67B },
	{ 0xD67C,  0xD67C },
	{ 0xD67D,  0xD67D },
	{ 0xD67E,  0xD67E },
	{ 0xD6A1,  0xD6A1 },
	{ 0xD6A2,  0xD6A2 },
	{ 0xD6A3,  0xD6A3 },
	{ 0xD6A4,  0xD6A4 },
	{ 0xD6A5,  0xD6A5 },
	{ 0xD6A6,  0xD6A6 },
	{ 0xD6A7,  0xD6A7 },
	{ 0xD6A8,  0xD6A8 },
	{ 0xD6A9,  0xD6A9 },
	{ 0xD6AA,  0xD6AA },
	{ 0xD6AB,  0xD6AB },
	{ 0xD6AC,  0xD6AC },
	{ 0xD6AD,  0xD6AD },
	{ 0xD6AE,  0xD6AE },
	{ 0xD6AF,  0xD6AF },
	{ 0xD6B0,  0xD6B0 },
	{ 0xD6B1,  0xD6B1 },
	{ 0xD6B2,  0xD6B2 },
	{ 0xD6B3,  0xD6B3 },
	{ 0xD6B4,  0xD6B4 },
	{ 0xD6B5,  0xD6B5 },
	{ 0xD6B6,  0xD6B6 },
	{ 0xD6B7,  0xD6B7 },
	{ 0xD6B8,  0xD6B8 },
	{ 0xD6B9,  0xD6B9 },
	{ 0xD6BA,  0xD6BA },
	{ 0xD6BB,  0xD6BB },
	{ 0xD6BC,  0xD6BC },
	{ 0xD6BD,  0xD6BD },
	{ 0xD6BE,  0xD6BE },
	{ 0xD6BF,  0xD6BF },
	{ 0xD6C0,  0xD6C0 },
	{ 0xD6C1,  0xD6C1 },
	{ 0xD6C2,  0xD6C2 },
	{ 0xD6C3,  0xD6C3 },
	{ 0xD6C4,  0xD6C4 },
	{ 0xD6C5,  0xD6C5 },
	{ 0xD6C6,  0xD6C6 },
	{ 0xD6C7,  0xD6C7 },
	{ 0xD6C8,  0xD6C8 },
	{ 0xD6C9,  0xD6C9 },
	{ 0xD6CA,  0xD6CA },
	{ 0xD6CB,  0xD6CB },
	{ 0xD6CC,  0xD6CC },
	{ 0xD6CD,  0xD6CD },
	{ 0xD6CE,  0xD6CE },
	{ 0xD6CF,  0xD6CF },
	{ 0xD6D0,  0xD6D0 },
	{ 0xD6D1,  0xD6D1 },
	{ 0xD6D2,  0xD6D2 },
	{ 0xD6D3,  0xD6D3 },
	{ 0xD6D4,  0xD6D4 },
	{ 0xD6D5,  0xD6D5 },
	{ 0xD6D6,  0xD6D6 },
	{ 0xD6D7,  0xD6D7 },
	{ 0xD6D8,  0xD6D8 },
	{ 0xD6D9,  0xD6D9 },
	{ 0xD6DA,  0xD6DA },
	{ 0xD6DB,  0xD6DB },
	{ 0xD6DC,  0xD6DC },
	{ 0xD6DD,  0xD6DD },
	{ 0xD6DE,  0xD6DE },
	{ 0xD6DF,  0xD6DF },
	{ 0xD6E0,  0xD6E0 },
	{ 0xD6E1,  0xD6E1 },
	{ 0xD6E2,  0xD6E2 },
	{ 0xD6E3,  0xD6E3 },
	{ 0xD6E4,  0xD6E4 },
	{ 0xD6E5,  0xD6E5 },
	{ 0xD6E6,  0xD6E6 },
	{ 0xD6E7,  0xD6E7 },
	{ 0xD6E8,  0xD6E8 },
	{ 0xD6E9,  0xD6E9 },
	{ 0xD6EA,  0xD6EA },
	{ 0xD6EB,  0xD6EB },
	{ 0xD6EC,  0xD6EC },
	{ 0xD6ED,  0xD6ED },
	{ 0xD6EE,  0xD6EE },
	{ 0xD6EF,  0xD6EF },
	{ 0xD6F0,  0xD6F0 },
	{ 0xD6F1,  0xD6F1 },
	{ 0xD6F2,  0xD6F2 },
	{ 0xD6F3,  0xD6F3 },
	{ 0xD6F4,  0xD6F4 },
	{ 0xD6F5,  0xD6F5 },
	{ 0xD6F6,  0xD6F6 },
	{ 0xD6F7,  0xD6F7 },
	{ 0xD6F8,  0xD6F8 },
	{ 0xD6F9,  0xD6F9 },
	{ 0xD6FA,  0xD6FA },
	{ 0xD6FB,  0xD6FB },
	{ 0xD6FC,  0xD6FC },
	{ 0xD6FD,  0xD6FD },
	{ 0xD6FE,  0xD6FE },
	{ 0xD740,  0xD740 },
	{ 0xD741,  0xD741 },
	{ 0xD742,  0xD742 },
	{ 0xD743,  0xD743 },
	{ 0xD744,  0xD744 },
	{ 0xD745,  0xD745 },
	{ 0xD746,  0xD746 },
	{ 0xD747,  0xD747 },
	{ 0xD748,  0xD748 },
	{ 0xD749,  0xD749 },
	{ 0xD74A,  0xD74A },
	{ 0xD74B,  0xD74B },
	{ 0xD74C,  0xD74C },
	{ 0xD74D,  0xD74D },
	{ 0xD74E,  0xD74E },
	{ 0xD74F,  0xD74F },
	{ 0xD750,  0xD750 },
	{ 0xD751,  0xD751 },
	{ 0xD752,  0xD752 },
	{ 0xD753,  0xD753 },
	{ 0xD754,  0xD754 },
	{ 0xD755,  0xD755 },
	{ 0xD756,  0xD756 },
	{ 0xD757,  0xD757 },
	{ 0xD758,  0xD758 },
	{ 0xD759,  0xD759 },
	{ 0xD75A,  0xD75A },
	{ 0xD75B,  0xD75B },
	{ 0xD75C,  0xD75C },
	{ 0xD75D,  0xD75D },
	{ 0xD75E,  0xD75E },
	{ 0xD75F,  0xD75F },
	{ 0xD760,  0xD760 },
	{ 0xD761,  0xD761 },
	{ 0xD762,  0xD762 },
	{ 0xD763,  0xD763 },
	{ 0xD764,  0xD764 },
	{ 0xD765,  0xD765 },
	{ 0xD766,  0xD766 },
	{ 0xD767,  0xD767 },
	{ 0xD768,  0xD768 },
	{ 0xD769,  0xD769 },
	{ 0xD76A,  0xD76A },
	{ 0xD76B,  0xD76B },
	{ 0xD76C,  0xD76C },
	{ 0xD76D,  0xD76D },
	{ 0xD76E,  0xD76E },
	{ 0xD76F,  0xD76F },
	{ 0xD770,  0xD770 },
	{ 0xD771,  0xD771 },
	{ 0xD772,  0xD772 },
	{ 0xD773,  0xD773 },
	{ 0xD774,  0xD774 },
	{ 0xD775,  0xD775 },
	{ 0xD776,  0xD776 },
	{ 0xD777,  0xD777 },
	{ 0xD778,  0xD778 },
	{ 0xD779,  0xD779 },
	{ 0xD77A,  0xD77A },
	{ 0xD77B,  0xD77B },
	{ 0xD77C,  0xD77C },
	{ 0xD77D,  0xD77D },
	{ 0xD77E,  0xD77E },
	{ 0xD7A1,  0xD7A1 },
	{ 0xD7A2,  0xD7A2 },
	{ 0xD7A3,  0xD7A3 },
	{ 0xD7A4,  0xD7A4 },
	{ 0xD7A5,  0xD7A5 },
	{ 0xD7A6,  0xD7A6 },
	{ 0xD7A7,  0xD7A7 },
	{ 0xD7A8,  0xD7A8 },
	{ 0xD7A9,  0xD7A9 },
	{ 0xD7AA,  0xD7AA },
	{ 0xD7AB,  0xD7AB },
	{ 0xD7AC,  0xD7AC },
	{ 0xD7AD,  0xD7AD },
	{ 0xD7AE,  0xD7AE },
	{ 0xD7AF,  0xD7AF },
	{ 0xD7B0,  0xD7B0 },
	{ 0xD7B1,  0xD7B1 },
	{ 0xD7B2,  0xD7B2 },
	{ 0xD7B3,  0xD7B3 },
	{ 0xD7B4,  0xD7B4 },
	{ 0xD7B5,  0xD7B5 },
	{ 0xD7B6,  0xD7B6 },
	{ 0xD7B7,  0xD7B7 },
	{ 0xD7B8,  0xD7B8 },
	{ 0xD7B9,  0xD7B9 },
	{ 0xD7BA,  0xD7BA },
	{ 0xD7BB,  0xD7BB },
	{ 0xD7BC,  0xD7BC },
	{ 0xD7BD,  0xD7BD },
	{ 0xD7BE,  0xD7BE },
	{ 0xD7BF,  0xD7BF },
	{ 0xD7C0,  0xD7C0 },
	{ 0xD7C1,  0xD7C1 },
	{ 0xD7C2,  0xD7C2 },
	{ 0xD7C3,  0xD7C3 },
	{ 0xD7C4,  0xD7C4 },
	{ 0xD7C5,  0xD7C5 },
	{ 0xD7C6,  0xD7C6 },
	{ 0xD7C7,  0xD7C7 },
	{ 0xD7C8,  0xD7C8 },
	{ 0xD7C9,  0xD7C9 },
	{ 0xD7CA,  0xD7CA },
	{ 0xD7CB,  0xD7CB },
	{ 0xD7CC,  0xD7CC },
	{ 0xD7CD,  0xD7CD },
	{ 0xD7CE,  0xD7CE },
	{ 0xD7CF,  0xD7CF },
	{ 0xD7D0,  0xD7D0 },
	{ 0xD7D1,  0xD7D1 },
	{ 0xD7D2,  0xD7D2 },
	{ 0xD7D3,  0xD7D3 },
	{ 0xD7D4,  0xD7D4 },
	{ 0xD7D5,  0xD7D5 },
	{ 0xD7D6,  0xD7D6 },
	{ 0xD7D7,  0xD7D7 },
	{ 0xD7D8,  0xD7D8 },
	{ 0xD7D9,  0xD7D9 },
	{ 0xD7DA,  0xD7DA },
	{ 0xD7DB,  0xD7DB },
	{ 0xD7DC,  0xD7DC },
	{ 0xD7DD,  0xD7DD },
	{ 0xD7DE,  0xD7DE },
	{ 0xD7DF,  0xD7DF },
	{ 0xD7E0,  0xD7E0 },
	{ 0xD7E1,  0xD7E1 },
	{ 0xD7E2,  0xD7E2 },
	{ 0xD7E3,  0xD7E3 },
	{ 0xD7E4,  0xD7E4 },
	{ 0xD7E5,  0xD7E5 },
	{ 0xD7E6,  0xD7E6 },
	{ 0xD7E7,  0xD7E7 },
	{ 0xD7E8,  0xD7E8 },
	{ 0xD7E9,  0xD7E9 },
	{ 0xD7EA,  0xD7EA },
	{ 0xD7EB,  0xD7EB },
	{ 0xD7EC,  0xD7EC },
	{ 0xD7ED,  0xD7ED },
	{ 0xD7EE,  0xD7EE },
	{ 0xD7EF,  0xD7EF },
	{ 0xD7F0,  0xD7F0 },
	{ 0xD7F1,  0xD7F1 },
	{ 0xD7F2,  0xD7F2 },
	{ 0xD7F3,  0xD7F3 },
	{ 0xD7F4,  0xD7F4 },
	{ 0xD7F5,  0xD7F5 },
	{ 0xD7F6,  0xD7F6 },
	{ 0xD7F7,  0xD7F7 },
	{ 0xD7F8,  0xD7F8 },
	{ 0xD7F9,  0xD7F9 },
	{ 0xD7FA,  0xD7FA },
	{ 0xD7FB,  0xD7FB },
	{ 0xD7FC,  0xD7FC },
	{ 0xD7FD,  0xD7FD },
	{ 0xD7FE,  0xD7FE },
	{ 0xD840,  0xD840 },
	{ 0xD841,  0xD841 },
	{ 0xD842,  0xD842 },
	{ 0xD843,  0xD843 },
	{ 0xD844,  0xD844 },
	{ 0xD845,  0xD845 },
	{ 0xD846,  0xD846 },
	{ 0xD847,  0xD847 },
	{ 0xD848,  0xD848 },
	{ 0xD849,  0xD849 },
	{ 0xD84A,  0xD84A },
	{ 0xD84B,  0xD84B },
	{ 0xD84C,  0xD84C },
	{ 0xD84D,  0xD84D },
	{ 0xD84E,  0xD84E },
	{ 0xD84F,  0xD84F },
	{ 0xD850,  0xD850 },
	{ 0xD851,  0xD851 },
	{ 0xD852,  0xD852 },
	{ 0xD853,  0xD853 },
	{ 0xD854,  0xD854 },
	{ 0xD855,  0xD855 },
	{ 0xD856,  0xD856 },
	{ 0xD857,  0xD857 },
	{ 0xD858,  0xD858 },
	{ 0xD859,  0xD859 },
	{ 0xD85A,  0xD85A },
	{ 0xD85B,  0xD85B },
	{ 0xD85C,  0xD85C },
	{ 0xD85D,  0xD85D },
	{ 0xD85E,  0xD85E },
	{ 0xD85F,  0xD85F },
	{ 0xD860,  0xD860 },
	{ 0xD861,  0xD861 },
	{ 0xD862,  0xD862 },
	{ 0xD863,  0xD863 },
	{ 0xD864,  0xD864 },
	{ 0xD865,  0xD865 },
	{ 0xD866,  0xD866 },
	{ 0xD867,  0xD867 },
	{ 0xD868,  0xD868 },
	{ 0xD869,  0xD869 },
	{ 0xD86A,  0xD86A },
	{ 0xD86B,  0xD86B },
	{ 0xD86C,  0xD86C },
	{ 0xD86D,  0xD86D },
	{ 0xD86E,  0xD86E },
	{ 0xD86F,  0xD86F },
	{ 0xD870,  0xD870 },
	{ 0xD871,  0xD871 },
	{ 0xD872,  0xD872 },
	{ 0xD873,  0xD873 },
	{ 0xD874,  0xD874 },
	{ 0xD875,  0xD875 },
	{ 0xD876,  0xD876 },
	{ 0xD877,  0xD877 },
	{ 0xD878,  0xD878 },
	{ 0xD879,  0xD879 },
	{ 0xD87A,  0xD87A },
	{ 0xD87B,  0xD87B },
	{ 0xD87C,  0xD87C },
	{ 0xD87D,  0xD87D },
	{ 0xD87E,  0xD87E },
	{ 0xD8A1,  0xD8A1 },
	{ 0xD8A2,  0xD8A2 },
	{ 0xD8A3,  0xD8A3 },
	{ 0xD8A4,  0xD8A4 },
	{ 0xD8A5,  0xD8A5 },
	{ 0xD8A6,  0xD8A6 },
	{ 0xD8A7,  0xD8A7 },
	{ 0xD8A8,  0xD8A8 },
	{ 0xD8A9,  0xD8A9 },
	{ 0xD8AA,  0xD8AA },
	{ 0xD8AB,  0xD8AB },
	{ 0xD8AC,  0xD8AC },
	{ 0xD8AD,  0xD8AD },
	{ 0xD8AE,  0xD8AE },
	{ 0xD8AF,  0xD8AF },
	{ 0xD8B0,  0xD8B0 },
	{ 0xD8B1,  0xD8B1 },
	{ 0xD8B2,  0xD8B2 },
	{ 0xD8B3,  0xD8B3 },
	{ 0xD8B4,  0xD8B4 },
	{ 0xD8B5,  0xD8B5 },
	{ 0xD8B6,  0xD8B6 },
	{ 0xD8B7,  0xD8B7 },
	{ 0xD8B8,  0xD8B8 },
	{ 0xD8B9,  0xD8B9 },
	{ 0xD8BA,  0xD8BA },
	{ 0xD8BB,  0xD8BB },
	{ 0xD8BC,  0xD8BC },
	{ 0xD8BD,  0xD8BD },
	{ 0xD8BE,  0xD8BE },
	{ 0xD8BF,  0xD8BF },
	{ 0xD8C0,  0xD8C0 },
	{ 0xD8C1,  0xD8C1 },
	{ 0xD8C2,  0xD8C2 },
	{ 0xD8C3,  0xD8C3 },
	{ 0xD8C4,  0xD8C4 },
	{ 0xD8C5,  0xD8C5 },
	{ 0xD8C6,  0xD8C6 },
	{ 0xD8C7,  0xD8C7 },
	{ 0xD8C8,  0xD8C8 },
	{ 0xD8C9,  0xD8C9 },
	{ 0xD8CA,  0xD8CA },
	{ 0xD8CB,  0xD8CB },
	{ 0xD8CC,  0xD8CC },
	{ 0xD8CD,  0xD8CD },
	{ 0xD8CE,  0xD8CE },
	{ 0xD8CF,  0xD8CF },
	{ 0xD8D0,  0xD8D0 },
	{ 0xD8D1,  0xD8D1 },
	{ 0xD8D2,  0xD8D2 },
	{ 0xD8D3,  0xD8D3 },
	{ 0xD8D4,  0xD8D4 },
	{ 0xD8D5,  0xD8D5 },
	{ 0xD8D6,  0xD8D6 },
	{ 0xD8D7,  0xD8D7 },
	{ 0xD8D8,  0xD8D8 },
	{ 0xD8D9,  0xD8D9 },
	{ 0xD8DA,  0xD8DA },
	{ 0xD8DB,  0xD8DB },
	{ 0xD8DC,  0xD8DC },
	{ 0xD8DD,  0xD8DD },
	{ 0xD8DE,  0xD8DE },
	{ 0xD8DF,  0xD8DF },
	{ 0xD8E0,  0xD8E0 },
	{ 0xD8E1,  0xD8E1 },
	{ 0xD8E2,  0xD8E2 },
	{ 0xD8E3,  0xD8E3 },
	{ 0xD8E4,  0xD8E4 },
	{ 0xD8E5,  0xD8E5 },
	{ 0xD8E6,  0xD8E6 },
	{ 0xD8E7,  0xD8E7 },
	{ 0xD8E8,  0xD8E8 },
	{ 0xD8E9,  0xD8E9 },
	{ 0xD8EA,  0xD8EA },
	{ 0xD8EB,  0xD8EB },
	{ 0xD8EC,  0xD8EC },
	{ 0xD8ED,  0xD8ED },
	{ 0xD8EE,  0xD8EE },
	{ 0xD8EF,  0xD8EF },
	{ 0xD8F0,  0xD8F0 },
	{ 0xD8F1,  0xD8F1 },
	{ 0xD8F2,  0xD8F2 },
	{ 0xD8F3,  0xD8F3 },
	{ 0xD8F4,  0xD8F4 },
	{ 0xD8F5,  0xD8F5 },
	{ 0xD8F6,  0xD8F6 },
	{ 0xD8F7,  0xD8F7 },
	{ 0xD8F8,  0xD8F8 },
	{ 0xD8F9,  0xD8F9 },
	{ 0xD8FA,  0xD8FA },
	{ 0xD8FB,  0xD8FB },
	{ 0xD8FC,  0xD8FC },
	{ 0xD8FD,  0xD8FD },
	{ 0xD8FE,  0xD8FE },
	{ 0xD940,  0xD940 },
	{ 0xD941,  0xD941 },
	{ 0xD942,  0xD942 },
	{ 0xD943,  0xD943 },
	{ 0xD944,  0xD944 },
	{ 0xD945,  0xD945 },
	{ 0xD946,  0xD946 },
	{ 0xD947,  0xD947 },
	{ 0xD948,  0xD948 },
	{ 0xD949,  0xD949 },
	{ 0xD94A,  0xD94A },
	{ 0xD94B,  0xD94B },
	{ 0xD94C,  0xD94C },
	{ 0xD94D,  0xD94D },
	{ 0xD94E,  0xD94E },
	{ 0xD94F,  0xD94F },
	{ 0xD950,  0xD950 },
	{ 0xD951,  0xD951 },
	{ 0xD952,  0xD952 },
	{ 0xD953,  0xD953 },
	{ 0xD954,  0xD954 },
	{ 0xD955,  0xD955 },
	{ 0xD956,  0xD956 },
	{ 0xD957,  0xD957 },
	{ 0xD958,  0xD958 },
	{ 0xD959,  0xD959 },
	{ 0xD95A,  0xD95A },
	{ 0xD95B,  0xD95B },
	{ 0xD95C,  0xD95C },
	{ 0xD95D,  0xD95D },
	{ 0xD95E,  0xD95E },
	{ 0xD95F,  0xD95F },
	{ 0xD960,  0xD960 },
	{ 0xD961,  0xD961 },
	{ 0xD962,  0xD962 },
	{ 0xD963,  0xD963 },
	{ 0xD964,  0xD964 },
	{ 0xD965,  0xD965 },
	{ 0xD966,  0xD966 },
	{ 0xD967,  0xD967 },
	{ 0xD968,  0xD968 },
	{ 0xD969,  0xD969 },
	{ 0xD96A,  0xD96A },
	{ 0xD96B,  0xD96B },
	{ 0xD96C,  0xD96C },
	{ 0xD96D,  0xD96D },
	{ 0xD96E,  0xD96E },
	{ 0xD96F,  0xD96F },
	{ 0xD970,  0xD970 },
	{ 0xD971,  0xD971 },
	{ 0xD972,  0xD972 },
	{ 0xD973,  0xD973 },
	{ 0xD974,  0xD974 },
	{ 0xD975,  0xD975 },
	{ 0xD976,  0xD976 },
	{ 0xD977,  0xD977 },
	{ 0xD978,  0xD978 },
	{ 0xD979,  0xD979 },
	{ 0xD97A,  0xD97A },
	{ 0xD97B,  0xD97B },
	{ 0xD97C,  0xD97C },
	{ 0xD97D,  0xD97D },
	{ 0xD97E,  0xD97E },
	{ 0xD9A1,  0xD9A1 },
	{ 0xD9A2,  0xD9A2 },
	{ 0xD9A3,  0xD9A3 },
	{ 0xD9A4,  0xD9A4 },
	{ 0xD9A5,  0xD9A5 },
	{ 0xD9A6,  0xD9A6 },
	{ 0xD9A7,  0xD9A7 },
	{ 0xD9A8,  0xD9A8 },
	{ 0xD9A9,  0xD9A9 },
	{ 0xD9AA,  0xD9AA },
	{ 0xD9AB,  0xD9AB },
	{ 0xD9AC,  0xD9AC },
	{ 0xD9AD,  0xD9AD },
	{ 0xD9AE,  0xD9AE },
	{ 0xD9AF,  0xD9AF },
	{ 0xD9B0,  0xD9B0 },
	{ 0xD9B1,  0xD9B1 },
	{ 0xD9B2,  0xD9B2 },
	{ 0xD9B3,  0xD9B3 },
	{ 0xD9B4,  0xD9B4 },
	{ 0xD9B5,  0xD9B5 },
	{ 0xD9B6,  0xD9B6 },
	{ 0xD9B7,  0xD9B7 },
	{ 0xD9B8,  0xD9B8 },
	{ 0xD9B9,  0xD9B9 },
	{ 0xD9BA,  0xD9BA },
	{ 0xD9BB,  0xD9BB },
	{ 0xD9BC,  0xD9BC },
	{ 0xD9BD,  0xD9BD },
	{ 0xD9BE,  0xD9BE },
	{ 0xD9BF,  0xD9BF },
	{ 0xD9C0,  0xD9C0 },
	{ 0xD9C1,  0xD9C1 },
	{ 0xD9C2,  0xD9C2 },
	{ 0xD9C3,  0xD9C3 },
	{ 0xD9C4,  0xD9C4 },
	{ 0xD9C5,  0xD9C5 },
	{ 0xD9C6,  0xD9C6 },
	{ 0xD9C7,  0xD9C7 },
	{ 0xD9C8,  0xD9C8 },
	{ 0xD9C9,  0xD9C9 },
	{ 0xD9CA,  0xD9CA },
	{ 0xD9CB,  0xD9CB },
	{ 0xD9CC,  0xD9CC },
	{ 0xD9CD,  0xD9CD },
	{ 0xD9CE,  0xD9CE },
	{ 0xD9CF,  0xD9CF },
	{ 0xD9D0,  0xD9D0 },
	{ 0xD9D1,  0xD9D1 },
	{ 0xD9D2,  0xD9D2 },
	{ 0xD9D3,  0xD9D3 },
	{ 0xD9D4,  0xD9D4 },
	{ 0xD9D5,  0xD9D5 },
	{ 0xD9D6,  0xD9D6 },
	{ 0xD9D7,  0xD9D7 },
	{ 0xD9D8,  0xD9D8 },
	{ 0xD9D9,  0xD9D9 },
	{ 0xD9DA,  0xD9DA },
	{ 0xD9DB,  0xD9DB },
	{ 0xD9DC,  0xD9DC },
	{ 0xD9DD,  0xD9DD },
	{ 0xD9DE,  0xD9DE },
	{ 0xD9DF,  0xD9DF },
	{ 0xD9E0,  0xD9E0 },
	{ 0xD9E1,  0xD9E1 },
	{ 0xD9E2,  0xD9E2 },
	{ 0xD9E3,  0xD9E3 },
	{ 0xD9E4,  0xD9E4 },
	{ 0xD9E5,  0xD9E5 },
	{ 0xD9E6,  0xD9E6 },
	{ 0xD9E7,  0xD9E7 },
	{ 0xD9E8,  0xD9E8 },
	{ 0xD9E9,  0xD9E9 },
	{ 0xD9EA,  0xD9EA },
	{ 0xD9EB,  0xD9EB },
	{ 0xD9EC,  0xD9EC },
	{ 0xD9ED,  0xD9ED },
	{ 0xD9EE,  0xD9EE },
	{ 0xD9EF,  0xD9EF },
	{ 0xD9F0,  0xD9F0 },
	{ 0xD9F1,  0xD9F1 },
	{ 0xD9F2,  0xD9F2 },
	{ 0xD9F3,  0xD9F3 },
	{ 0xD9F4,  0xD9F4 },
	{ 0xD9F5,  0xD9F5 },
	{ 0xD9F6,  0xD9F6 },
	{ 0xD9F7,  0xD9F7 },
	{ 0xD9F8,  0xD9F8 },
	{ 0xD9F9,  0xD9F9 },
	{ 0xD9FA,  0xD9FA },
	{ 0xD9FB,  0xD9FB },
	{ 0xD9FC,  0xD9FC },
	{ 0xD9FD,  0xD9FD },
	{ 0xD9FE,  0xD9FE },
	{ 0xDA40,  0xDA40 },
	{ 0xDA41,  0xDA41 },
	{ 0xDA42,  0xDA42 },
	{ 0xDA43,  0xDA43 },
	{ 0xDA44,  0xDA44 },
	{ 0xDA45,  0xDA45 },
	{ 0xDA46,  0xDA46 },
	{ 0xDA47,  0xDA47 },
	{ 0xDA48,  0xDA48 },
	{ 0xDA49,  0xDA49 },
	{ 0xDA4A,  0xDA4A },
	{ 0xDA4B,  0xDA4B },
	{ 0xDA4C,  0xDA4C },
	{ 0xDA4D,  0xDA4D },
	{ 0xDA4E,  0xDA4E },
	{ 0xDA4F,  0xDA4F },
	{ 0xDA50,  0xDA50 },
	{ 0xDA51,  0xDA51 },
	{ 0xDA52,  0xDA52 },
	{ 0xDA53,  0xDA53 },
	{ 0xDA54,  0xDA54 },
	{ 0xDA55,  0xDA55 },
	{ 0xDA56,  0xDA56 },
	{ 0xDA57,  0xDA57 },
	{ 0xDA58,  0xDA58 },
	{ 0xDA59,  0xDA59 },
	{ 0xDA5A,  0xDA5A },
	{ 0xDA5B,  0xDA5B },
	{ 0xDA5C,  0xDA5C },
	{ 0xDA5D,  0xDA5D },
	{ 0xDA5E,  0xDA5E },
	{ 0xDA5F,  0xDA5F },
	{ 0xDA60,  0xDA60 },
	{ 0xDA61,  0xDA61 },
	{ 0xDA62,  0xDA62 },
	{ 0xDA63,  0xDA63 },
	{ 0xDA64,  0xDA64 },
	{ 0xDA65,  0xDA65 },
	{ 0xDA66,  0xDA66 },
	{ 0xDA67,  0xDA67 },
	{ 0xDA68,  0xDA68 },
	{ 0xDA69,  0xDA69 },
	{ 0xDA6A,  0xDA6A },
	{ 0xDA6B,  0xDA6B },
	{ 0xDA6C,  0xDA6C },
	{ 0xDA6D,  0xDA6D },
	{ 0xDA6E,  0xDA6E },
	{ 0xDA6F,  0xDA6F },
	{ 0xDA70,  0xDA70 },
	{ 0xDA71,  0xDA71 },
	{ 0xDA72,  0xDA72 },
	{ 0xDA73,  0xDA73 },
	{ 0xDA74,  0xDA74 },
	{ 0xDA75,  0xDA75 },
	{ 0xDA76,  0xDA76 },
	{ 0xDA77,  0xDA77 },
	{ 0xDA78,  0xDA78 },
	{ 0xDA79,  0xDA79 },
	{ 0xDA7A,  0xDA7A },
	{ 0xDA7B,  0xDA7B },
	{ 0xDA7C,  0xDA7C },
	{ 0xDA7D,  0xDA7D },
	{ 0xDA7E,  0xDA7E },
	{ 0xDAA1,  0xDAA1 },
	{ 0xDAA2,  0xDAA2 },
	{ 0xDAA3,  0xDAA3 },
	{ 0xDAA4,  0xDAA4 },
	{ 0xDAA5,  0xDAA5 },
	{ 0xDAA6,  0xDAA6 },
	{ 0xDAA7,  0xDAA7 },
	{ 0xDAA8,  0xDAA8 },
	{ 0xDAA9,  0xDAA9 },
	{ 0xDAAA,  0xDAAA },
	{ 0xDAAB,  0xDAAB },
	{ 0xDAAC,  0xDAAC },
	{ 0xDAAD,  0xDAAD },
	{ 0xDAAE,  0xDAAE },
	{ 0xDAAF,  0xDAAF },
	{ 0xDAB0,  0xDAB0 },
	{ 0xDAB1,  0xDAB1 },
	{ 0xDAB2,  0xDAB2 },
	{ 0xDAB3,  0xDAB3 },
	{ 0xDAB4,  0xDAB4 },
	{ 0xDAB5,  0xDAB5 },
	{ 0xDAB6,  0xDAB6 },
	{ 0xDAB7,  0xDAB7 },
	{ 0xDAB8,  0xDAB8 },
	{ 0xDAB9,  0xDAB9 },
	{ 0xDABA,  0xDABA },
	{ 0xDABB,  0xDABB },
	{ 0xDABC,  0xDABC },
	{ 0xDABD,  0xDABD },
	{ 0xDABE,  0xDABE },
	{ 0xDABF,  0xDABF },
	{ 0xDAC0,  0xDAC0 },
	{ 0xDAC1,  0xDAC1 },
	{ 0xDAC2,  0xDAC2 },
	{ 0xDAC3,  0xDAC3 },
	{ 0xDAC4,  0xDAC4 },
	{ 0xDAC5,  0xDAC5 },
	{ 0xDAC6,  0xDAC6 },
	{ 0xDAC7,  0xDAC7 },
	{ 0xDAC8,  0xDAC8 },
	{ 0xDAC9,  0xDAC9 },
	{ 0xDACA,  0xDACA },
	{ 0xDACB,  0xDACB },
	{ 0xDACC,  0xDACC },
	{ 0xDACD,  0xDACD },
	{ 0xDACE,  0xDACE },
	{ 0xDACF,  0xDACF },
	{ 0xDAD0,  0xDAD0 },
	{ 0xDAD1,  0xDAD1 },
	{ 0xDAD2,  0xDAD2 },
	{ 0xDAD3,  0xDAD3 },
	{ 0xDAD4,  0xDAD4 },
	{ 0xDAD5,  0xDAD5 },
	{ 0xDAD6,  0xDAD6 },
	{ 0xDAD7,  0xDAD7 },
	{ 0xDAD8,  0xDAD8 },
	{ 0xDAD9,  0xDAD9 },
	{ 0xDADA,  0xDADA },
	{ 0xDADB,  0xDADB },
	{ 0xDADC,  0xDADC },
	{ 0xDADD,  0xDADD },
	{ 0xDADE,  0xDADE },
	{ 0xDADF,  0xDADF },
	{ 0xDAE0,  0xDAE0 },
	{ 0xDAE1,  0xDAE1 },
	{ 0xDAE2,  0xDAE2 },
	{ 0xDAE3,  0xDAE3 },
	{ 0xDAE4,  0xDAE4 },
	{ 0xDAE5,  0xDAE5 },
	{ 0xDAE6,  0xDAE6 },
	{ 0xDAE7,  0xDAE7 },
	{ 0xDAE8,  0xDAE8 },
	{ 0xDAE9,  0xDAE9 },
	{ 0xDAEA,  0xDAEA },
	{ 0xDAEB,  0xDAEB },
	{ 0xDAEC,  0xDAEC },
	{ 0xDAED,  0xDAED },
	{ 0xDAEE,  0xDAEE },
	{ 0xDAEF,  0xDAEF },
	{ 0xDAF0,  0xDAF0 },
	{ 0xDAF1,  0xDAF1 },
	{ 0xDAF2,  0xDAF2 },
	{ 0xDAF3,  0xDAF3 },
	{ 0xDAF4,  0xDAF4 },
	{ 0xDAF5,  0xDAF5 },
	{ 0xDAF6,  0xDAF6 },
	{ 0xDAF7,  0xDAF7 },
	{ 0xDAF8,  0xDAF8 },
	{ 0xDAF9,  0xDAF9 },
	{ 0xDAFA,  0xDAFA },
	{ 0xDAFB,  0xDAFB },
	{ 0xDAFC,  0xDAFC },
	{ 0xDAFD,  0xDAFD },
	{ 0xDAFE,  0xDAFE },
	{ 0xDB40,  0xDB40 },
	{ 0xDB41,  0xDB41 },
	{ 0xDB42,  0xDB42 },
	{ 0xDB43,  0xDB43 },
	{ 0xDB44,  0xDB44 },
	{ 0xDB45,  0xDB45 },
	{ 0xDB46,  0xDB46 },
	{ 0xDB47,  0xDB47 },
	{ 0xDB48,  0xDB48 },
	{ 0xDB49,  0xDB49 },
	{ 0xDB4A,  0xDB4A },
	{ 0xDB4B,  0xDB4B },
	{ 0xDB4C,  0xDB4C },
	{ 0xDB4D,  0xDB4D },
	{ 0xDB4E,  0xDB4E },
	{ 0xDB4F,  0xDB4F },
	{ 0xDB50,  0xDB50 },
	{ 0xDB51,  0xDB51 },
	{ 0xDB52,  0xDB52 },
	{ 0xDB53,  0xDB53 },
	{ 0xDB54,  0xDB54 },
	{ 0xDB55,  0xDB55 },
	{ 0xDB56,  0xDB56 },
	{ 0xDB57,  0xDB57 },
	{ 0xDB58,  0xDB58 },
	{ 0xDB59,  0xDB59 },
	{ 0xDB5A,  0xDB5A },
	{ 0xDB5B,  0xDB5B },
	{ 0xDB5C,  0xDB5C },
	{ 0xDB5D,  0xDB5D },
	{ 0xDB5E,  0xDB5E },
	{ 0xDB5F,  0xDB5F },
	{ 0xDB60,  0xDB60 },
	{ 0xDB61,  0xDB61 },
	{ 0xDB62,  0xDB62 },
	{ 0xDB63,  0xDB63 },
	{ 0xDB64,  0xDB64 },
	{ 0xDB65,  0xDB65 },
	{ 0xDB66,  0xDB66 },
	{ 0xDB67,  0xDB67 },
	{ 0xDB68,  0xDB68 },
	{ 0xDB69,  0xDB69 },
	{ 0xDB6A,  0xDB6A },
	{ 0xDB6B,  0xDB6B },
	{ 0xDB6C,  0xDB6C },
	{ 0xDB6D,  0xDB6D },
	{ 0xDB6E,  0xDB6E },
	{ 0xDB6F,  0xDB6F },
	{ 0xDB70,  0xDB70 },
	{ 0xDB71,  0xDB71 },
	{ 0xDB72,  0xDB72 },
	{ 0xDB73,  0xDB73 },
	{ 0xDB74,  0xDB74 },
	{ 0xDB75,  0xDB75 },
	{ 0xDB76,  0xDB76 },
	{ 0xDB77,  0xDB77 },
	{ 0xDB78,  0xDB78 },
	{ 0xDB79,  0xDB79 },
	{ 0xDB7A,  0xDB7A },
	{ 0xDB7B,  0xDB7B },
	{ 0xDB7C,  0xDB7C },
	{ 0xDB7D,  0xDB7D },
	{ 0xDB7E,  0xDB7E },
	{ 0xDBA1,  0xDBA1 },
	{ 0xDBA2,  0xDBA2 },
	{ 0xDBA3,  0xDBA3 },
	{ 0xDBA4,  0xDBA4 },
	{ 0xDBA5,  0xDBA5 },
	{ 0xDBA6,  0xDBA6 },
	{ 0xDBA7,  0xDBA7 },
	{ 0xDBA8,  0xDBA8 },
	{ 0xDBA9,  0xDBA9 },
	{ 0xDBAA,  0xDBAA },
	{ 0xDBAB,  0xDBAB },
	{ 0xDBAC,  0xDBAC },
	{ 0xDBAD,  0xDBAD },
	{ 0xDBAE,  0xDBAE },
	{ 0xDBAF,  0xDBAF },
	{ 0xDBB0,  0xDBB0 },
	{ 0xDBB1,  0xDBB1 },
	{ 0xDBB2,  0xDBB2 },
	{ 0xDBB3,  0xDBB3 },
	{ 0xDBB4,  0xDBB4 },
	{ 0xDBB5,  0xDBB5 },
	{ 0xDBB6,  0xDBB6 },
	{ 0xDBB7,  0xDBB7 },
	{ 0xDBB8,  0xDBB8 },
	{ 0xDBB9,  0xDBB9 },
	{ 0xDBBA,  0xDBBA },
	{ 0xDBBB,  0xDBBB },
	{ 0xDBBC,  0xDBBC },
	{ 0xDBBD,  0xDBBD },
	{ 0xDBBE,  0xDBBE },
	{ 0xDBBF,  0xDBBF },
	{ 0xDBC0,  0xDBC0 },
	{ 0xDBC1,  0xDBC1 },
	{ 0xDBC2,  0xDBC2 },
	{ 0xDBC3,  0xDBC3 },
	{ 0xDBC4,  0xDBC4 },
	{ 0xDBC5,  0xDBC5 },
	{ 0xDBC6,  0xDBC6 },
	{ 0xDBC7,  0xDBC7 },
	{ 0xDBC8,  0xDBC8 },
	{ 0xDBC9,  0xDBC9 },
	{ 0xDBCA,  0xDBCA },
	{ 0xDBCB,  0xDBCB },
	{ 0xDBCC,  0xDBCC },
	{ 0xDBCD,  0xDBCD },
	{ 0xDBCE,  0xDBCE },
	{ 0xDBCF,  0xDBCF },
	{ 0xDBD0,  0xDBD0 },
	{ 0xDBD1,  0xDBD1 },
	{ 0xDBD2,  0xDBD2 },
	{ 0xDBD3,  0xDBD3 },
	{ 0xDBD4,  0xDBD4 },
	{ 0xDBD5,  0xDBD5 },
	{ 0xDBD6,  0xDBD6 },
	{ 0xDBD7,  0xDBD7 },
	{ 0xDBD8,  0xDBD8 },
	{ 0xDBD9,  0xDBD9 },
	{ 0xDBDA,  0xDBDA },
	{ 0xDBDB,  0xDBDB },
	{ 0xDBDC,  0xDBDC },
	{ 0xDBDD,  0xDBDD },
	{ 0xDBDE,  0xDBDE },
	{ 0xDBDF,  0xDBDF },
	{ 0xDBE0,  0xDBE0 },
	{ 0xDBE1,  0xDBE1 },
	{ 0xDBE2,  0xDBE2 },
	{ 0xDBE3,  0xDBE3 },
	{ 0xDBE4,  0xDBE4 },
	{ 0xDBE5,  0xDBE5 },
	{ 0xDBE6,  0xDBE6 },
	{ 0xDBE7,  0xDBE7 },
	{ 0xDBE8,  0xDBE8 },
	{ 0xDBE9,  0xDBE9 },
	{ 0xDBEA,  0xDBEA },
	{ 0xDBEB,  0xDBEB },
	{ 0xDBEC,  0xDBEC },
	{ 0xDBED,  0xDBED },
	{ 0xDBEE,  0xDBEE },
	{ 0xDBEF,  0xDBEF },
	{ 0xDBF0,  0xDBF0 },
	{ 0xDBF1,  0xDBF1 },
	{ 0xDBF2,  0xDBF2 },
	{ 0xDBF3,  0xDBF3 },
	{ 0xDBF4,  0xDBF4 },
	{ 0xDBF5,  0xDBF5 },
	{ 0xDBF6,  0xDBF6 },
	{ 0xDBF7,  0xDBF7 },
	{ 0xDBF8,  0xDBF8 },
	{ 0xDBF9,  0xDBF9 },
	{ 0xDBFA,  0xDBFA },
	{ 0xDBFB,  0xDBFB },
	{ 0xDBFC,  0xDBFC },
	{ 0xDBFD,  0xDBFD },
	{ 0xDBFE,  0xDBFE },
	{ 0xDC40,  0xDC40 },
	{ 0xDC41,  0xDC41 },
	{ 0xDC42,  0xDC42 },
	{ 0xDC43,  0xDC43 },
	{ 0xDC44,  0xDC44 },
	{ 0xDC45,  0xDC45 },
	{ 0xDC46,  0xDC46 },
	{ 0xDC47,  0xDC47 },
	{ 0xDC48,  0xDC48 },
	{ 0xDC49,  0xDC49 },
	{ 0xDC4A,  0xDC4A },
	{ 0xDC4B,  0xDC4B },
	{ 0xDC4C,  0xDC4C },
	{ 0xDC4D,  0xDC4D },
	{ 0xDC4E,  0xDC4E },
	{ 0xDC4F,  0xDC4F },
	{ 0xDC50,  0xDC50 },
	{ 0xDC51,  0xDC51 },
	{ 0xDC52,  0xDC52 },
	{ 0xDC53,  0xDC53 },
	{ 0xDC54,  0xDC54 },
	{ 0xDC55,  0xDC55 },
	{ 0xDC56,  0xDC56 },
	{ 0xDC57,  0xDC57 },
	{ 0xDC58,  0xDC58 },
	{ 0xDC59,  0xDC59 },
	{ 0xDC5A,  0xDC5A },
	{ 0xDC5B,  0xDC5B },
	{ 0xDC5C,  0xDC5C },
	{ 0xDC5D,  0xDC5D },
	{ 0xDC5E,  0xDC5E },
	{ 0xDC5F,  0xDC5F },
	{ 0xDC60,  0xDC60 },
	{ 0xDC61,  0xDC61 },
	{ 0xDC62,  0xDC62 },
	{ 0xDC63,  0xDC63 },
	{ 0xDC64,  0xDC64 },
	{ 0xDC65,  0xDC65 },
	{ 0xDC66,  0xDC66 },
	{ 0xDC67,  0xDC67 },
	{ 0xDC68,  0xDC68 },
	{ 0xDC69,  0xDC69 },
	{ 0xDC6A,  0xDC6A },
	{ 0xDC6B,  0xDC6B },
	{ 0xDC6C,  0xDC6C },
	{ 0xDC6D,  0xDC6D },
	{ 0xDC6E,  0xDC6E },
	{ 0xDC6F,  0xDC6F },
	{ 0xDC70,  0xDC70 },
	{ 0xDC71,  0xDC71 },
	{ 0xDC72,  0xDC72 },
	{ 0xDC73,  0xDC73 },
	{ 0xDC74,  0xDC74 },
	{ 0xDC75,  0xDC75 },
	{ 0xDC76,  0xDC76 },
	{ 0xDC77,  0xDC77 },
	{ 0xDC78,  0xDC78 },
	{ 0xDC79,  0xDC79 },
	{ 0xDC7A,  0xDC7A },
	{ 0xDC7B,  0xDC7B },
	{ 0xDC7C,  0xDC7C },
	{ 0xDC7D,  0xDC7D },
	{ 0xDC7E,  0xDC7E },
	{ 0xDCA1,  0xDCA1 },
	{ 0xDCA2,  0xDCA2 },
	{ 0xDCA3,  0xDCA3 },
	{ 0xDCA4,  0xDCA4 },
	{ 0xDCA5,  0xDCA5 },
	{ 0xDCA6,  0xDCA6 },
	{ 0xDCA7,  0xDCA7 },
	{ 0xDCA8,  0xDCA8 },
	{ 0xDCA9,  0xDCA9 },
	{ 0xDCAA,  0xDCAA },
	{ 0xDCAB,  0xDCAB },
	{ 0xDCAC,  0xDCAC },
	{ 0xDCAD,  0xDCAD },
	{ 0xDCAE,  0xDCAE },
	{ 0xDCAF,  0xDCAF },
	{ 0xDCB0,  0xDCB0 },
	{ 0xDCB1,  0xDCB1 },
	{ 0xDCB2,  0xDCB2 },
	{ 0xDCB3,  0xDCB3 },
	{ 0xDCB4,  0xDCB4 },
	{ 0xDCB5,  0xDCB5 },
	{ 0xDCB6,  0xDCB6 },
	{ 0xDCB7,  0xDCB7 },
	{ 0xDCB8,  0xDCB8 },
	{ 0xDCB9,  0xDCB9 },
	{ 0xDCBA,  0xDCBA },
	{ 0xDCBB,  0xDCBB },
	{ 0xDCBC,  0xDCBC },
	{ 0xDCBD,  0xDCBD },
	{ 0xDCBE,  0xDCBE },
	{ 0xDCBF,  0xDCBF },
	{ 0xDCC0,  0xDCC0 },
	{ 0xDCC1,  0xDCC1 },
	{ 0xDCC2,  0xDCC2 },
	{ 0xDCC3,  0xDCC3 },
	{ 0xDCC4,  0xDCC4 },
	{ 0xDCC5,  0xDCC5 },
	{ 0xDCC6,  0xDCC6 },
	{ 0xDCC7,  0xDCC7 },
	{ 0xDCC8,  0xDCC8 },
	{ 0xDCC9,  0xDCC9 },
	{ 0xDCCA,  0xDCCA },
	{ 0xDCCB,  0xDCCB },
	{ 0xDCCC,  0xDCCC },
	{ 0xDCCD,  0xDCCD },
	{ 0xDCCE,  0xDCCE },
	{ 0xDCCF,  0xDCCF },
	{ 0xDCD0,  0xDCD0 },
	{ 0xDCD1,  0xDCD1 },
	{ 0xDCD1,  0xDDFC },
	{ 0xDCD2,  0xDCD2 },
	{ 0xDCD3,  0xDCD3 },
	{ 0xDCD4,  0xDCD4 },
	{ 0xDCD5,  0xDCD5 },
	{ 0xDCD6,  0xDCD6 },
	{ 0xDCD7,  0xDCD7 },
	{ 0xDCD8,  0xDCD8 },
	{ 0xDCD9,  0xDCD9 },
	{ 0xDCDA,  0xDCDA },
	{ 0xDCDB,  0xDCDB },
	{ 0xDCDC,  0xDCDC },
	{ 0xDCDD,  0xDCDD },
	{ 0xDCDE,  0xDCDE },
	{ 0xDCDF,  0xDCDF },
	{ 0xDCE0,  0xDCE0 },
	{ 0xDCE1,  0xDCE1 },
	{ 0xDCE2,  0xDCE2 },
	{ 0xDCE3,  0xDCE3 },
	{ 0xDCE4,  0xDCE4 },
	{ 0xDCE5,  0xDCE5 },
	{ 0xDCE6,  0xDCE6 },
	{ 0xDCE7,  0xDCE7 },
	{ 0xDCE8,  0xDCE8 },
	{ 0xDCE9,  0xDCE9 },
	{ 0xDCEA,  0xDCEA },
	{ 0xDCEB,  0xDCEB },
	{ 0xDCEC,  0xDCEC },
	{ 0xDCED,  0xDCED },
	{ 0xDCEE,  0xDCEE },
	{ 0xDCEF,  0xDCEF },
	{ 0xDCF0,  0xDCF0 },
	{ 0xDCF1,  0xDCF1 },
	{ 0xDCF2,  0xDCF2 },
	{ 0xDCF3,  0xDCF3 },
	{ 0xDCF4,  0xDCF4 },
	{ 0xDCF5,  0xDCF5 },
	{ 0xDCF6,  0xDCF6 },
	{ 0xDCF7,  0xDCF7 },
	{ 0xDCF8,  0xDCF8 },
	{ 0xDCF9,  0xDCF9 },
	{ 0xDCFA,  0xDCFA },
	{ 0xDCFB,  0xDCFB },
	{ 0xDCFC,  0xDCFC },
	{ 0xDCFD,  0xDCFD },
	{ 0xDCFE,  0xDCFE },
	{ 0xDD40,  0xDD40 },
	{ 0xDD41,  0xDD41 },
	{ 0xDD42,  0xDD42 },
	{ 0xDD43,  0xDD43 },
	{ 0xDD44,  0xDD44 },
	{ 0xDD45,  0xDD45 },
	{ 0xDD46,  0xDD46 },
	{ 0xDD47,  0xDD47 },
	{ 0xDD48,  0xDD48 },
	{ 0xDD49,  0xDD49 },
	{ 0xDD4A,  0xDD4A },
	{ 0xDD4B,  0xDD4B },
	{ 0xDD4C,  0xDD4C },
	{ 0xDD4D,  0xDD4D },
	{ 0xDD4E,  0xDD4E },
	{ 0xDD4F,  0xDD4F },
	{ 0xDD50,  0xDD50 },
	{ 0xDD51,  0xDD51 },
	{ 0xDD52,  0xDD52 },
	{ 0xDD53,  0xDD53 },
	{ 0xDD54,  0xDD54 },
	{ 0xDD55,  0xDD55 },
	{ 0xDD56,  0xDD56 },
	{ 0xDD57,  0xDD57 },
	{ 0xDD58,  0xDD58 },
	{ 0xDD59,  0xDD59 },
	{ 0xDD5A,  0xDD5A },
	{ 0xDD5B,  0xDD5B },
	{ 0xDD5C,  0xDD5C },
	{ 0xDD5D,  0xDD5D },
	{ 0xDD5E,  0xDD5E },
	{ 0xDD5F,  0xDD5F },
	{ 0xDD60,  0xDD60 },
	{ 0xDD61,  0xDD61 },
	{ 0xDD62,  0xDD62 },
	{ 0xDD63,  0xDD63 },
	{ 0xDD64,  0xDD64 },
	{ 0xDD65,  0xDD65 },
	{ 0xDD66,  0xDD66 },
	{ 0xDD67,  0xDD67 },
	{ 0xDD68,  0xDD68 },
	{ 0xDD69,  0xDD69 },
	{ 0xDD6A,  0xDD6A },
	{ 0xDD6B,  0xDD6B },
	{ 0xDD6C,  0xDD6C },
	{ 0xDD6D,  0xDD6D },
	{ 0xDD6E,  0xDD6E },
	{ 0xDD6F,  0xDD6F },
	{ 0xDD70,  0xDD70 },
	{ 0xDD71,  0xDD71 },
	{ 0xDD72,  0xDD72 },
	{ 0xDD73,  0xDD73 },
	{ 0xDD74,  0xDD74 },
	{ 0xDD75,  0xDD75 },
	{ 0xDD76,  0xDD76 },
	{ 0xDD77,  0xDD77 },
	{ 0xDD78,  0xDD78 },
	{ 0xDD79,  0xDD79 },
	{ 0xDD7A,  0xDD7A },
	{ 0xDD7B,  0xDD7B },
	{ 0xDD7C,  0xDD7C },
	{ 0xDD7D,  0xDD7D },
	{ 0xDD7E,  0xDD7E },
	{ 0xDDA1,  0xDDA1 },
	{ 0xDDA2,  0xDDA2 },
	{ 0xDDA3,  0xDDA3 },
	{ 0xDDA4,  0xDDA4 },
	{ 0xDDA5,  0xDDA5 },
	{ 0xDDA6,  0xDDA6 },
	{ 0xDDA7,  0xDDA7 },
	{ 0xDDA8,  0xDDA8 },
	{ 0xDDA9,  0xDDA9 },
	{ 0xDDAA,  0xDDAA },
	{ 0xDDAB,  0xDDAB },
	{ 0xDDAC,  0xDDAC },
	{ 0xDDAD,  0xDDAD },
	{ 0xDDAE,  0xDDAE },
	{ 0xDDAF,  0xDDAF },
	{ 0xDDB0,  0xDDB0 },
	{ 0xDDB1,  0xDDB1 },
	{ 0xDDB2,  0xDDB2 },
	{ 0xDDB3,  0xDDB3 },
	{ 0xDDB4,  0xDDB4 },
	{ 0xDDB5,  0xDDB5 },
	{ 0xDDB6,  0xDDB6 },
	{ 0xDDB7,  0xDDB7 },
	{ 0xDDB8,  0xDDB8 },
	{ 0xDDB9,  0xDDB9 },
	{ 0xDDBA,  0xDDBA },
	{ 0xDDBB,  0xDDBB },
	{ 0xDDBC,  0xDDBC },
	{ 0xDDBD,  0xDDBD },
	{ 0xDDBE,  0xDDBE },
	{ 0xDDBF,  0xDDBF },
	{ 0xDDC0,  0xDDC0 },
	{ 0xDDC1,  0xDDC1 },
	{ 0xDDC2,  0xDDC2 },
	{ 0xDDC3,  0xDDC3 },
	{ 0xDDC4,  0xDDC4 },
	{ 0xDDC5,  0xDDC5 },
	{ 0xDDC6,  0xDDC6 },
	{ 0xDDC7,  0xDDC7 },
	{ 0xDDC8,  0xDDC8 },
	{ 0xDDC9,  0xDDC9 },
	{ 0xDDCA,  0xDDCA },
	{ 0xDDCB,  0xDDCB },
	{ 0xDDCC,  0xDDCC },
	{ 0xDDCD,  0xDDCD },
	{ 0xDDCE,  0xDDCE },
	{ 0xDDCF,  0xDDCF },
	{ 0xDDD0,  0xDDD0 },
	{ 0xDDD1,  0xDDD1 },
	{ 0xDDD2,  0xDDD2 },
	{ 0xDDD3,  0xDDD3 },
	{ 0xDDD4,  0xDDD4 },
	{ 0xDDD5,  0xDDD5 },
	{ 0xDDD6,  0xDDD6 },
	{ 0xDDD7,  0xDDD7 },
	{ 0xDDD8,  0xDDD8 },
	{ 0xDDD9,  0xDDD9 },
	{ 0xDDDA,  0xDDDA },
	{ 0xDDDB,  0xDDDB },
	{ 0xDDDC,  0xDDDC },
	{ 0xDDDD,  0xDDDD },
	{ 0xDDDE,  0xDDDE },
	{ 0xDDDF,  0xDDDF },
	{ 0xDDE0,  0xDDE0 },
	{ 0xDDE1,  0xDDE1 },
	{ 0xDDE2,  0xDDE2 },
	{ 0xDDE3,  0xDDE3 },
	{ 0xDDE4,  0xDDE4 },
	{ 0xDDE5,  0xDDE5 },
	{ 0xDDE6,  0xDDE6 },
	{ 0xDDE7,  0xDDE7 },
	{ 0xDDE8,  0xDDE8 },
	{ 0xDDE9,  0xDDE9 },
	{ 0xDDEA,  0xDDEA },
	{ 0xDDEB,  0xDDEB },
	{ 0xDDEC,  0xDDEC },
	{ 0xDDED,  0xDDED },
	{ 0xDDEE,  0xDDEE },
	{ 0xDDEF,  0xDDEF },
	{ 0xDDF0,  0xDDF0 },
	{ 0xDDF1,  0xDDF1 },
	{ 0xDDF2,  0xDDF2 },
	{ 0xDDF3,  0xDDF3 },
	{ 0xDDF4,  0xDDF4 },
	{ 0xDDF5,  0xDDF5 },
	{ 0xDDF6,  0xDDF6 },
	{ 0xDDF7,  0xDDF7 },
	{ 0xDDF8,  0xDDF8 },
	{ 0xDDF9,  0xDDF9 },
	{ 0xDDFA,  0xDDFA },
	{ 0xDDFB,  0xDDFB },
	{ 0xDDFD,  0xDDFD },
	{ 0xDDFE,  0xDDFE },
	{ 0xDE40,  0xDE40 },
	{ 0xDE41,  0xDE41 },
	{ 0xDE42,  0xDE42 },
	{ 0xDE43,  0xDE43 },
	{ 0xDE44,  0xDE44 },
	{ 0xDE45,  0xDE45 },
	{ 0xDE46,  0xDE46 },
	{ 0xDE47,  0xDE47 },
	{ 0xDE48,  0xDE48 },
	{ 0xDE49,  0xDE49 },
	{ 0xDE4A,  0xDE4A },
	{ 0xDE4B,  0xDE4B },
	{ 0xDE4C,  0xDE4C },
	{ 0xDE4D,  0xDE4D },
	{ 0xDE4E,  0xDE4E },
	{ 0xDE4F,  0xDE4F },
	{ 0xDE50,  0xDE50 },
	{ 0xDE51,  0xDE51 },
	{ 0xDE52,  0xDE52 },
	{ 0xDE53,  0xDE53 },
	{ 0xDE54,  0xDE54 },
	{ 0xDE55,  0xDE55 },
	{ 0xDE56,  0xDE56 },
	{ 0xDE57,  0xDE57 },
	{ 0xDE58,  0xDE58 },
	{ 0xDE59,  0xDE59 },
	{ 0xDE5A,  0xDE5A },
	{ 0xDE5B,  0xDE5B },
	{ 0xDE5C,  0xDE5C },
	{ 0xDE5D,  0xDE5D },
	{ 0xDE5E,  0xDE5E },
	{ 0xDE5F,  0xDE5F },
	{ 0xDE60,  0xDE60 },
	{ 0xDE61,  0xDE61 },
	{ 0xDE62,  0xDE62 },
	{ 0xDE63,  0xDE63 },
	{ 0xDE64,  0xDE64 },
	{ 0xDE65,  0xDE65 },
	{ 0xDE66,  0xDE66 },
	{ 0xDE67,  0xDE67 },
	{ 0xDE68,  0xDE68 },
	{ 0xDE69,  0xDE69 },
	{ 0xDE6A,  0xDE6A },
	{ 0xDE6B,  0xDE6B },
	{ 0xDE6C,  0xDE6C },
	{ 0xDE6D,  0xDE6D },
	{ 0xDE6E,  0xDE6E },
	{ 0xDE6F,  0xDE6F },
	{ 0xDE70,  0xDE70 },
	{ 0xDE71,  0xDE71 },
	{ 0xDE72,  0xDE72 },
	{ 0xDE73,  0xDE73 },
	{ 0xDE74,  0xDE74 },
	{ 0xDE75,  0xDE75 },
	{ 0xDE76,  0xDE76 },
	{ 0xDE77,  0xDE77 },
	{ 0xDE78,  0xDE78 },
	{ 0xDE79,  0xDE79 },
	{ 0xDE7A,  0xDE7A },
	{ 0xDE7B,  0xDE7B },
	{ 0xDE7C,  0xDE7C },
	{ 0xDE7D,  0xDE7D },
	{ 0xDE7E,  0xDE7E },
	{ 0xDEA1,  0xDEA1 },
	{ 0xDEA2,  0xDEA2 },
	{ 0xDEA3,  0xDEA3 },
	{ 0xDEA4,  0xDEA4 },
	{ 0xDEA5,  0xDEA5 },
	{ 0xDEA6,  0xDEA6 },
	{ 0xDEA7,  0xDEA7 },
	{ 0xDEA8,  0xDEA8 },
	{ 0xDEA9,  0xDEA9 },
	{ 0xDEAA,  0xDEAA },
	{ 0xDEAB,  0xDEAB },
	{ 0xDEAC,  0xDEAC },
	{ 0xDEAD,  0xDEAD },
	{ 0xDEAE,  0xDEAE },
	{ 0xDEAF,  0xDEAF },
	{ 0xDEB0,  0xDEB0 },
	{ 0xDEB1,  0xDEB1 },
	{ 0xDEB2,  0xDEB2 },
	{ 0xDEB3,  0xDEB3 },
	{ 0xDEB4,  0xDEB4 },
	{ 0xDEB5,  0xDEB5 },
	{ 0xDEB6,  0xDEB6 },
	{ 0xDEB7,  0xDEB7 },
	{ 0xDEB8,  0xDEB8 },
	{ 0xDEB9,  0xDEB9 },
	{ 0xDEBA,  0xDEBA },
	{ 0xDEBB,  0xDEBB },
	{ 0xDEBC,  0xDEBC },
	{ 0xDEBD,  0xDEBD },
	{ 0xDEBE,  0xDEBE },
	{ 0xDEBF,  0xDEBF },
	{ 0xDEC0,  0xDEC0 },
	{ 0xDEC1,  0xDEC1 },
	{ 0xDEC2,  0xDEC2 },
	{ 0xDEC3,  0xDEC3 },
	{ 0xDEC4,  0xDEC4 },
	{ 0xDEC5,  0xDEC5 },
	{ 0xDEC6,  0xDEC6 },
	{ 0xDEC7,  0xDEC7 },
	{ 0xDEC8,  0xDEC8 },
	{ 0xDEC9,  0xDEC9 },
	{ 0xDECA,  0xDECA },
	{ 0xDECB,  0xDECB },
	{ 0xDECC,  0xDECC },
	{ 0xDECD,  0xDECD },
	{ 0xDECE,  0xDECE },
	{ 0xDECF,  0xDECF },
	{ 0xDED0,  0xDED0 },
	{ 0xDED1,  0xDED1 },
	{ 0xDED2,  0xDED2 },
	{ 0xDED3,  0xDED3 },
	{ 0xDED4,  0xDED4 },
	{ 0xDED5,  0xDED5 },
	{ 0xDED6,  0xDED6 },
	{ 0xDED7,  0xDED7 },
	{ 0xDED8,  0xDED8 },
	{ 0xDED9,  0xDED9 },
	{ 0xDEDA,  0xDEDA },
	{ 0xDEDB,  0xDEDB },
	{ 0xDEDC,  0xDEDC },
	{ 0xDEDD,  0xDEDD },
	{ 0xDEDE,  0xDEDE },
	{ 0xDEDF,  0xDEDF },
	{ 0xDEE0,  0xDEE0 },
	{ 0xDEE1,  0xDEE1 },
	{ 0xDEE2,  0xDEE2 },
	{ 0xDEE3,  0xDEE3 },
	{ 0xDEE4,  0xDEE4 },
	{ 0xDEE5,  0xDEE5 },
	{ 0xDEE6,  0xDEE6 },
	{ 0xDEE7,  0xDEE7 },
	{ 0xDEE8,  0xDEE8 },
	{ 0xDEE9,  0xDEE9 },
	{ 0xDEEA,  0xDEEA },
	{ 0xDEEB,  0xDEEB },
	{ 0xDEEC,  0xDEEC },
	{ 0xDEED,  0xDEED },
	{ 0xDEEE,  0xDEEE },
	{ 0xDEEF,  0xDEEF },
	{ 0xDEF0,  0xDEF0 },
	{ 0xDEF1,  0xDEF1 },
	{ 0xDEF2,  0xDEF2 },
	{ 0xDEF3,  0xDEF3 },
	{ 0xDEF4,  0xDEF4 },
	{ 0xDEF5,  0xDEF5 },
	{ 0xDEF6,  0xDEF6 },
	{ 0xDEF7,  0xDEF7 },
	{ 0xDEF8,  0xDEF8 },
	{ 0xDEF9,  0xDEF9 },
	{ 0xDEFA,  0xDEFA },
	{ 0xDEFB,  0xDEFB },
	{ 0xDEFC,  0xDEFC },
	{ 0xDEFD,  0xDEFD },
	{ 0xDEFE,  0xDEFE },
	{ 0xDF40,  0xDF40 },
	{ 0xDF41,  0xDF41 },
	{ 0xDF42,  0xDF42 },
	{ 0xDF43,  0xDF43 },
	{ 0xDF44,  0xDF44 },
	{ 0xDF45,  0xDF45 },
	{ 0xDF46,  0xDF46 },
	{ 0xDF47,  0xDF47 },
	{ 0xDF48,  0xDF48 },
	{ 0xDF49,  0xDF49 },
	{ 0xDF4A,  0xDF4A },
	{ 0xDF4B,  0xDF4B },
	{ 0xDF4C,  0xDF4C },
	{ 0xDF4D,  0xDF4D },
	{ 0xDF4E,  0xDF4E },
	{ 0xDF4F,  0xDF4F },
	{ 0xDF50,  0xDF50 },
	{ 0xDF51,  0xDF51 },
	{ 0xDF52,  0xDF52 },
	{ 0xDF53,  0xDF53 },
	{ 0xDF54,  0xDF54 },
	{ 0xDF55,  0xDF55 },
	{ 0xDF56,  0xDF56 },
	{ 0xDF57,  0xDF57 },
	{ 0xDF58,  0xDF58 },
	{ 0xDF59,  0xDF59 },
	{ 0xDF5A,  0xDF5A },
	{ 0xDF5B,  0xDF5B },
	{ 0xDF5C,  0xDF5C },
	{ 0xDF5D,  0xDF5D },
	{ 0xDF5E,  0xDF5E },
	{ 0xDF5F,  0xDF5F },
	{ 0xDF60,  0xDF60 },
	{ 0xDF61,  0xDF61 },
	{ 0xDF62,  0xDF62 },
	{ 0xDF63,  0xDF63 },
	{ 0xDF64,  0xDF64 },
	{ 0xDF65,  0xDF65 },
	{ 0xDF66,  0xDF66 },
	{ 0xDF67,  0xDF67 },
	{ 0xDF68,  0xDF68 },
	{ 0xDF69,  0xDF69 },
	{ 0xDF6A,  0xDF6A },
	{ 0xDF6B,  0xDF6B },
	{ 0xDF6C,  0xDF6C },
	{ 0xDF6D,  0xDF6D },
	{ 0xDF6E,  0xDF6E },
	{ 0xDF6F,  0xDF6F },
	{ 0xDF70,  0xDF70 },
	{ 0xDF71,  0xDF71 },
	{ 0xDF72,  0xDF72 },
	{ 0xDF73,  0xDF73 },
	{ 0xDF74,  0xDF74 },
	{ 0xDF75,  0xDF75 },
	{ 0xDF76,  0xDF76 },
	{ 0xDF77,  0xDF77 },
	{ 0xDF78,  0xDF78 },
	{ 0xDF79,  0xDF79 },
	{ 0xDF7A,  0xDF7A },
	{ 0xDF7B,  0xDF7B },
	{ 0xDF7C,  0xDF7C },
	{ 0xDF7D,  0xDF7D },
	{ 0xDF7E,  0xDF7E },
	{ 0xDFA1,  0xDFA1 },
	{ 0xDFA2,  0xDFA2 },
	{ 0xDFA3,  0xDFA3 },
	{ 0xDFA4,  0xDFA4 },
	{ 0xDFA5,  0xDFA5 },
	{ 0xDFA6,  0xDFA6 },
	{ 0xDFA7,  0xDFA7 },
	{ 0xDFA8,  0xDFA8 },
	{ 0xDFA9,  0xDFA9 },
	{ 0xDFAA,  0xDFAA },
	{ 0xDFAB,  0xDFAB },
	{ 0xDFAC,  0xDFAC },
	{ 0xDFAD,  0xDFAD },
	{ 0xDFAE,  0xDFAE },
	{ 0xDFAF,  0xDFAF },
	{ 0xDFB0,  0xDFB0 },
	{ 0xDFB1,  0xDFB1 },
	{ 0xDFB2,  0xDFB2 },
	{ 0xDFB3,  0xDFB3 },
	{ 0xDFB4,  0xDFB4 },
	{ 0xDFB5,  0xDFB5 },
	{ 0xDFB6,  0xDFB6 },
	{ 0xDFB7,  0xDFB7 },
	{ 0xDFB8,  0xDFB8 },
	{ 0xDFB9,  0xDFB9 },
	{ 0xDFBA,  0xDFBA },
	{ 0xDFBB,  0xDFBB },
	{ 0xDFBC,  0xDFBC },
	{ 0xDFBD,  0xDFBD },
	{ 0xDFBE,  0xDFBE },
	{ 0xDFBF,  0xDFBF },
	{ 0xDFC0,  0xDFC0 },
	{ 0xDFC1,  0xDFC1 },
	{ 0xDFC2,  0xDFC2 },
	{ 0xDFC3,  0xDFC3 },
	{ 0xDFC4,  0xDFC4 },
	{ 0xDFC5,  0xDFC5 },
	{ 0xDFC6,  0xDFC6 },
	{ 0xDFC7,  0xDFC7 },
	{ 0xDFC8,  0xDFC8 },
	{ 0xDFC9,  0xDFC9 },
	{ 0xDFCA,  0xDFCA },
	{ 0xDFCB,  0xDFCB },
	{ 0xDFCC,  0xDFCC },
	{ 0xDFCD,  0xDFCD },
	{ 0xDFCE,  0xDFCE },
	{ 0xDFCF,  0xDFCF },
	{ 0xDFD0,  0xDFD0 },
	{ 0xDFD1,  0xDFD1 },
	{ 0xDFD2,  0xDFD2 },
	{ 0xDFD3,  0xDFD3 },
	{ 0xDFD4,  0xDFD4 },
	{ 0xDFD5,  0xDFD5 },
	{ 0xDFD6,  0xDFD6 },
	{ 0xDFD7,  0xDFD7 },
	{ 0xDFD8,  0xDFD8 },
	{ 0xDFD9,  0xDFD9 },
	{ 0xDFDA,  0xDFDA },
	{ 0xDFDB,  0xDFDB },
	{ 0xDFDC,  0xDFDC },
	{ 0xDFDD,  0xDFDD },
	{ 0xDFDE,  0xDFDE },
	{ 0xDFDF,  0xDFDF },
	{ 0xDFE0,  0xDFE0 },
	{ 0xDFE1,  0xDFE1 },
	{ 0xDFE2,  0xDFE2 },
	{ 0xDFE3,  0xDFE3 },
	{ 0xDFE4,  0xDFE4 },
	{ 0xDFE5,  0xDFE5 },
	{ 0xDFE6,  0xDFE6 },
	{ 0xDFE7,  0xDFE7 },
	{ 0xDFE8,  0xDFE8 },
	{ 0xDFE9,  0xDFE9 },
	{ 0xDFEA,  0xDFEA },
	{ 0xDFEB,  0xDFEB },
	{ 0xDFEC,  0xDFEC },
	{ 0xDFED,  0xDFED },
	{ 0xDFEE,  0xDFEE },
	{ 0xDFEF,  0xDFEF },
	{ 0xDFF0,  0xDFF0 },
	{ 0xDFF1,  0xDFF1 },
	{ 0xDFF2,  0xDFF2 },
	{ 0xDFF3,  0xDFF3 },
	{ 0xDFF4,  0xDFF4 },
	{ 0xDFF5,  0xDFF5 },
	{ 0xDFF6,  0xDFF6 },
	{ 0xDFF7,  0xDFF7 },
	{ 0xDFF8,  0xDFF8 },
	{ 0xDFF9,  0xDFF9 },
	{ 0xDFFA,  0xDFFA },
	{ 0xDFFB,  0xDFFB },
	{ 0xDFFC,  0xDFFC },
	{ 0xDFFD,  0xDFFD },
	{ 0xDFFE,  0xDFFE },
	{ 0xE040,  0xE040 },
	{ 0xE041,  0xE041 },
	{ 0xE042,  0xE042 },
	{ 0xE043,  0xE043 },
	{ 0xE044,  0xE044 },
	{ 0xE045,  0xE045 },
	{ 0xE046,  0xE046 },
	{ 0xE047,  0xE047 },
	{ 0xE048,  0xE048 },
	{ 0xE049,  0xE049 },
	{ 0xE04A,  0xE04A },
	{ 0xE04B,  0xE04B },
	{ 0xE04C,  0xE04C },
	{ 0xE04D,  0xE04D },
	{ 0xE04E,  0xE04E },
	{ 0xE04F,  0xE04F },
	{ 0xE050,  0xE050 },
	{ 0xE051,  0xE051 },
	{ 0xE052,  0xE052 },
	{ 0xE053,  0xE053 },
	{ 0xE054,  0xE054 },
	{ 0xE055,  0xE055 },
	{ 0xE056,  0xE056 },
	{ 0xE057,  0xE057 },
	{ 0xE058,  0xE058 },
	{ 0xE059,  0xE059 },
	{ 0xE05A,  0xE05A },
	{ 0xE05B,  0xE05B },
	{ 0xE05C,  0xE05C },
	{ 0xE05D,  0xE05D },
	{ 0xE05E,  0xE05E },
	{ 0xE05F,  0xE05F },
	{ 0xE060,  0xE060 },
	{ 0xE061,  0xE061 },
	{ 0xE062,  0xE062 },
	{ 0xE063,  0xE063 },
	{ 0xE064,  0xE064 },
	{ 0xE065,  0xE065 },
	{ 0xE066,  0xE066 },
	{ 0xE067,  0xE067 },
	{ 0xE068,  0xE068 },
	{ 0xE069,  0xE069 },
	{ 0xE06A,  0xE06A },
	{ 0xE06B,  0xE06B },
	{ 0xE06C,  0xE06C },
	{ 0xE06D,  0xE06D },
	{ 0xE06E,  0xE06E },
	{ 0xE06F,  0xE06F },
	{ 0xE070,  0xE070 },
	{ 0xE071,  0xE071 },
	{ 0xE072,  0xE072 },
	{ 0xE073,  0xE073 },
	{ 0xE074,  0xE074 },
	{ 0xE075,  0xE075 },
	{ 0xE076,  0xE076 },
	{ 0xE077,  0xE077 },
	{ 0xE078,  0xE078 },
	{ 0xE079,  0xE079 },
	{ 0xE07A,  0xE07A },
	{ 0xE07B,  0xE07B },
	{ 0xE07C,  0xE07C },
	{ 0xE07D,  0xE07D },
	{ 0xE07E,  0xE07E },
	{ 0xE0A1,  0xE0A1 },
	{ 0xE0A2,  0xE0A2 },
	{ 0xE0A3,  0xE0A3 },
	{ 0xE0A4,  0xE0A4 },
	{ 0xE0A5,  0xE0A5 },
	{ 0xE0A6,  0xE0A6 },
	{ 0xE0A7,  0xE0A7 },
	{ 0xE0A8,  0xE0A8 },
	{ 0xE0A9,  0xE0A9 },
	{ 0xE0AA,  0xE0AA },
	{ 0xE0AB,  0xE0AB },
	{ 0xE0AC,  0xE0AC },
	{ 0xE0AD,  0xE0AD },
	{ 0xE0AE,  0xE0AE },
	{ 0xE0AF,  0xE0AF },
	{ 0xE0B0,  0xE0B0 },
	{ 0xE0B1,  0xE0B1 },
	{ 0xE0B2,  0xE0B2 },
	{ 0xE0B3,  0xE0B3 },
	{ 0xE0B4,  0xE0B4 },
	{ 0xE0B5,  0xE0B5 },
	{ 0xE0B6,  0xE0B6 },
	{ 0xE0B7,  0xE0B7 },
	{ 0xE0B8,  0xE0B8 },
	{ 0xE0B9,  0xE0B9 },
	{ 0xE0BA,  0xE0BA },
	{ 0xE0BB,  0xE0BB },
	{ 0xE0BC,  0xE0BC },
	{ 0xE0BD,  0xE0BD },
	{ 0xE0BE,  0xE0BE },
	{ 0xE0BF,  0xE0BF },
	{ 0xE0C0,  0xE0C0 },
	{ 0xE0C1,  0xE0C1 },
	{ 0xE0C2,  0xE0C2 },
	{ 0xE0C3,  0xE0C3 },
	{ 0xE0C4,  0xE0C4 },
	{ 0xE0C5,  0xE0C5 },
	{ 0xE0C6,  0xE0C6 },
	{ 0xE0C7,  0xE0C7 },
	{ 0xE0C8,  0xE0C8 },
	{ 0xE0C9,  0xE0C9 },
	{ 0xE0CA,  0xE0CA },
	{ 0xE0CB,  0xE0CB },
	{ 0xE0CC,  0xE0CC },
	{ 0xE0CD,  0xE0CD },
	{ 0xE0CE,  0xE0CE },
	{ 0xE0CF,  0xE0CF },
	{ 0xE0D0,  0xE0D0 },
	{ 0xE0D1,  0xE0D1 },
	{ 0xE0D2,  0xE0D2 },
	{ 0xE0D3,  0xE0D3 },
	{ 0xE0D4,  0xE0D4 },
	{ 0xE0D5,  0xE0D5 },
	{ 0xE0D6,  0xE0D6 },
	{ 0xE0D7,  0xE0D7 },
	{ 0xE0D8,  0xE0D8 },
	{ 0xE0D9,  0xE0D9 },
	{ 0xE0DA,  0xE0DA },
	{ 0xE0DB,  0xE0DB },
	{ 0xE0DC,  0xE0DC },
	{ 0xE0DD,  0xE0DD },
	{ 0xE0DE,  0xE0DE },
	{ 0xE0DF,  0xE0DF },
	{ 0xE0E0,  0xE0E0 },
	{ 0xE0E1,  0xE0E1 },
	{ 0xE0E2,  0xE0E2 },
	{ 0xE0E3,  0xE0E3 },
	{ 0xE0E4,  0xE0E4 },
	{ 0xE0E5,  0xE0E5 },
	{ 0xE0E6,  0xE0E6 },
	{ 0xE0E7,  0xE0E7 },
	{ 0xE0E8,  0xE0E8 },
	{ 0xE0E9,  0xE0E9 },
	{ 0xE0EA,  0xE0EA },
	{ 0xE0EB,  0xE0EB },
	{ 0xE0EC,  0xE0EC },
	{ 0xE0ED,  0xE0ED },
	{ 0xE0EE,  0xE0EE },
	{ 0xE0EF,  0xE0EF },
	{ 0xE0F0,  0xE0F0 },
	{ 0xE0F1,  0xE0F1 },
	{ 0xE0F2,  0xE0F2 },
	{ 0xE0F3,  0xE0F3 },
	{ 0xE0F4,  0xE0F4 },
	{ 0xE0F5,  0xE0F5 },
	{ 0xE0F6,  0xE0F6 },
	{ 0xE0F7,  0xE0F7 },
	{ 0xE0F8,  0xE0F8 },
	{ 0xE0F9,  0xE0F9 },
	{ 0xE0FA,  0xE0FA },
	{ 0xE0FB,  0xE0FB },
	{ 0xE0FC,  0xE0FC },
	{ 0xE0FD,  0xE0FD },
	{ 0xE0FE,  0xE0FE },
	{ 0xE140,  0xE140 },
	{ 0xE141,  0xE141 },
	{ 0xE142,  0xE142 },
	{ 0xE143,  0xE143 },
	{ 0xE144,  0xE144 },
	{ 0xE145,  0xE145 },
	{ 0xE146,  0xE146 },
	{ 0xE147,  0xE147 },
	{ 0xE148,  0xE148 },
	{ 0xE149,  0xE149 },
	{ 0xE14A,  0xE14A },
	{ 0xE14B,  0xE14B },
	{ 0xE14C,  0xE14C },
	{ 0xE14D,  0xE14D },
	{ 0xE14E,  0xE14E },
	{ 0xE14F,  0xE14F },
	{ 0xE150,  0xE150 },
	{ 0xE151,  0xE151 },
	{ 0xE152,  0xE152 },
	{ 0xE153,  0xE153 },
	{ 0xE154,  0xE154 },
	{ 0xE155,  0xE155 },
	{ 0xE156,  0xE156 },
	{ 0xE157,  0xE157 },
	{ 0xE158,  0xE158 },
	{ 0xE159,  0xE159 },
	{ 0xE15A,  0xE15A },
	{ 0xE15B,  0xE15B },
	{ 0xE15C,  0xE15C },
	{ 0xE15D,  0xE15D },
	{ 0xE15E,  0xE15E },
	{ 0xE15F,  0xE15F },
	{ 0xE160,  0xE160 },
	{ 0xE161,  0xE161 },
	{ 0xE162,  0xE162 },
	{ 0xE163,  0xE163 },
	{ 0xE164,  0xE164 },
	{ 0xE165,  0xE165 },
	{ 0xE166,  0xE166 },
	{ 0xE167,  0xE167 },
	{ 0xE168,  0xE168 },
	{ 0xE169,  0xE169 },
	{ 0xE16A,  0xE16A },
	{ 0xE16B,  0xE16B },
	{ 0xE16C,  0xE16C },
	{ 0xE16D,  0xE16D },
	{ 0xE16E,  0xE16E },
	{ 0xE16F,  0xE16F },
	{ 0xE170,  0xE170 },
	{ 0xE171,  0xE171 },
	{ 0xE172,  0xE172 },
	{ 0xE173,  0xE173 },
	{ 0xE174,  0xE174 },
	{ 0xE175,  0xE175 },
	{ 0xE176,  0xE176 },
	{ 0xE177,  0xE177 },
	{ 0xE178,  0xE178 },
	{ 0xE179,  0xE179 },
	{ 0xE17A,  0xE17A },
	{ 0xE17B,  0xE17B },
	{ 0xE17C,  0xE17C },
	{ 0xE17D,  0xE17D },
	{ 0xE17E,  0xE17E },
	{ 0xE1A1,  0xE1A1 },
	{ 0xE1A2,  0xE1A2 },
	{ 0xE1A3,  0xE1A3 },
	{ 0xE1A4,  0xE1A4 },
	{ 0xE1A5,  0xE1A5 },
	{ 0xE1A6,  0xE1A6 },
	{ 0xE1A7,  0xE1A7 },
	{ 0xE1A8,  0xE1A8 },
	{ 0xE1A9,  0xE1A9 },
	{ 0xE1AA,  0xE1AA },
	{ 0xE1AB,  0xE1AB },
	{ 0xE1AC,  0xE1AC },
	{ 0xE1AD,  0xE1AD },
	{ 0xE1AE,  0xE1AE },
	{ 0xE1AF,  0xE1AF },
	{ 0xE1B0,  0xE1B0 },
	{ 0xE1B1,  0xE1B1 },
	{ 0xE1B2,  0xE1B2 },
	{ 0xE1B3,  0xE1B3 },
	{ 0xE1B4,  0xE1B4 },
	{ 0xE1B5,  0xE1B5 },
	{ 0xE1B6,  0xE1B6 },
	{ 0xE1B7,  0xE1B7 },
	{ 0xE1B8,  0xE1B8 },
	{ 0xE1B9,  0xE1B9 },
	{ 0xE1BA,  0xE1BA },
	{ 0xE1BB,  0xE1BB },
	{ 0xE1BC,  0xE1BC },
	{ 0xE1BD,  0xE1BD },
	{ 0xE1BE,  0xE1BE },
	{ 0xE1BF,  0xE1BF },
	{ 0xE1C0,  0xE1C0 },
	{ 0xE1C1,  0xE1C1 },
	{ 0xE1C2,  0xE1C2 },
	{ 0xE1C3,  0xE1C3 },
	{ 0xE1C4,  0xE1C4 },
	{ 0xE1C5,  0xE1C5 },
	{ 0xE1C6,  0xE1C6 },
	{ 0xE1C7,  0xE1C7 },
	{ 0xE1C8,  0xE1C8 },
	{ 0xE1C9,  0xE1C9 },
	{ 0xE1CA,  0xE1CA },
	{ 0xE1CB,  0xE1CB },
	{ 0xE1CC,  0xE1CC },
	{ 0xE1CD,  0xE1CD },
	{ 0xE1CE,  0xE1CE },
	{ 0xE1CF,  0xE1CF },
	{ 0xE1D0,  0xE1D0 },
	{ 0xE1D1,  0xE1D1 },
	{ 0xE1D2,  0xE1D2 },
	{ 0xE1D3,  0xE1D3 },
	{ 0xE1D4,  0xE1D4 },
	{ 0xE1D5,  0xE1D5 },
	{ 0xE1D6,  0xE1D6 },
	{ 0xE1D7,  0xE1D7 },
	{ 0xE1D8,  0xE1D8 },
	{ 0xE1D9,  0xE1D9 },
	{ 0xE1DA,  0xE1DA },
	{ 0xE1DB,  0xE1DB },
	{ 0xE1DC,  0xE1DC },
	{ 0xE1DD,  0xE1DD },
	{ 0xE1DE,  0xE1DE },
	{ 0xE1DF,  0xE1DF },
	{ 0xE1E0,  0xE1E0 },
	{ 0xE1E1,  0xE1E1 },
	{ 0xE1E2,  0xE1E2 },
	{ 0xE1E3,  0xE1E3 },
	{ 0xE1E4,  0xE1E4 },
	{ 0xE1E5,  0xE1E5 },
	{ 0xE1E6,  0xE1E6 },
	{ 0xE1E7,  0xE1E7 },
	{ 0xE1E8,  0xE1E8 },
	{ 0xE1E9,  0xE1E9 },
	{ 0xE1EA,  0xE1EA },
	{ 0xE1EB,  0xE1EB },
	{ 0xE1EC,  0xE1EC },
	{ 0xE1ED,  0xE1ED },
	{ 0xE1EE,  0xE1EE },
	{ 0xE1EF,  0xE1EF },
	{ 0xE1F0,  0xE1F0 },
	{ 0xE1F1,  0xE1F1 },
	{ 0xE1F2,  0xE1F2 },
	{ 0xE1F3,  0xE1F3 },
	{ 0xE1F4,  0xE1F4 },
	{ 0xE1F5,  0xE1F5 },
	{ 0xE1F6,  0xE1F6 },
	{ 0xE1F7,  0xE1F7 },
	{ 0xE1F8,  0xE1F8 },
	{ 0xE1F9,  0xE1F9 },
	{ 0xE1FA,  0xE1FA },
	{ 0xE1FB,  0xE1FB },
	{ 0xE1FC,  0xE1FC },
	{ 0xE1FD,  0xE1FD },
	{ 0xE1FE,  0xE1FE },
	{ 0xE240,  0xE240 },
	{ 0xE241,  0xE241 },
	{ 0xE242,  0xE242 },
	{ 0xE243,  0xE243 },
	{ 0xE244,  0xE244 },
	{ 0xE245,  0xE245 },
	{ 0xE246,  0xE246 },
	{ 0xE247,  0xE247 },
	{ 0xE248,  0xE248 },
	{ 0xE249,  0xE249 },
	{ 0xE24A,  0xE24A },
	{ 0xE24B,  0xE24B },
	{ 0xE24C,  0xE24C },
	{ 0xE24D,  0xE24D },
	{ 0xE24E,  0xE24E },
	{ 0xE24F,  0xE24F },
	{ 0xE250,  0xE250 },
	{ 0xE251,  0xE251 },
	{ 0xE252,  0xE252 },
	{ 0xE253,  0xE253 },
	{ 0xE254,  0xE254 },
	{ 0xE255,  0xE255 },
	{ 0xE256,  0xE256 },
	{ 0xE257,  0xE257 },
	{ 0xE258,  0xE258 },
	{ 0xE259,  0xE259 },
	{ 0xE25A,  0xE25A },
	{ 0xE25B,  0xE25B },
	{ 0xE25C,  0xE25C },
	{ 0xE25D,  0xE25D },
	{ 0xE25E,  0xE25E },
	{ 0xE25F,  0xE25F },
	{ 0xE260,  0xE260 },
	{ 0xE261,  0xE261 },
	{ 0xE262,  0xE262 },
	{ 0xE263,  0xE263 },
	{ 0xE264,  0xE264 },
	{ 0xE265,  0xE265 },
	{ 0xE266,  0xE266 },
	{ 0xE267,  0xE267 },
	{ 0xE268,  0xE268 },
	{ 0xE269,  0xE269 },
	{ 0xE26A,  0xE26A },
	{ 0xE26B,  0xE26B },
	{ 0xE26C,  0xE26C },
	{ 0xE26D,  0xE26D },
	{ 0xE26E,  0xE26E },
	{ 0xE26F,  0xE26F },
	{ 0xE270,  0xE270 },
	{ 0xE271,  0xE271 },
	{ 0xE272,  0xE272 },
	{ 0xE273,  0xE273 },
	{ 0xE274,  0xE274 },
	{ 0xE275,  0xE275 },
	{ 0xE276,  0xE276 },
	{ 0xE277,  0xE277 },
	{ 0xE278,  0xE278 },
	{ 0xE279,  0xE279 },
	{ 0xE27A,  0xE27A },
	{ 0xE27B,  0xE27B },
	{ 0xE27C,  0xE27C },
	{ 0xE27D,  0xE27D },
	{ 0xE27E,  0xE27E },
	{ 0xE2A1,  0xE2A1 },
	{ 0xE2A2,  0xE2A2 },
	{ 0xE2A3,  0xE2A3 },
	{ 0xE2A4,  0xE2A4 },
	{ 0xE2A5,  0xE2A5 },
	{ 0xE2A6,  0xE2A6 },
	{ 0xE2A7,  0xE2A7 },
	{ 0xE2A8,  0xE2A8 },
	{ 0xE2A9,  0xE2A9 },
	{ 0xE2AA,  0xE2AA },
	{ 0xE2AB,  0xE2AB },
	{ 0xE2AC,  0xE2AC },
	{ 0xE2AD,  0xE2AD },
	{ 0xE2AE,  0xE2AE },
	{ 0xE2AF,  0xE2AF },
	{ 0xE2B0,  0xE2B0 },
	{ 0xE2B1,  0xE2B1 },
	{ 0xE2B2,  0xE2B2 },
	{ 0xE2B3,  0xE2B3 },
	{ 0xE2B4,  0xE2B4 },
	{ 0xE2B5,  0xE2B5 },
	{ 0xE2B6,  0xE2B6 },
	{ 0xE2B7,  0xE2B7 },
	{ 0xE2B8,  0xE2B8 },
	{ 0xE2B9,  0xE2B9 },
	{ 0xE2BA,  0xE2BA },
	{ 0xE2BB,  0xE2BB },
	{ 0xE2BC,  0xE2BC },
	{ 0xE2BD,  0xE2BD },
	{ 0xE2BE,  0xE2BE },
	{ 0xE2BF,  0xE2BF },
	{ 0xE2C0,  0xE2C0 },
	{ 0xE2C1,  0xE2C1 },
	{ 0xE2C2,  0xE2C2 },
	{ 0xE2C3,  0xE2C3 },
	{ 0xE2C4,  0xE2C4 },
	{ 0xE2C5,  0xE2C5 },
	{ 0xE2C6,  0xE2C6 },
	{ 0xE2C7,  0xE2C7 },
	{ 0xE2C8,  0xE2C8 },
	{ 0xE2C9,  0xE2C9 },
	{ 0xE2CA,  0xE2CA },
	{ 0xE2CB,  0xE2CB },
	{ 0xE2CC,  0xE2CC },
	{ 0xE2CD,  0xE2CD },
	{ 0xE2CE,  0xE2CE },
	{ 0xE2CF,  0xE2CF },
	{ 0xE2D0,  0xE2D0 },
	{ 0xE2D1,  0xE2D1 },
	{ 0xE2D2,  0xE2D2 },
	{ 0xE2D3,  0xE2D3 },
	{ 0xE2D4,  0xE2D4 },
	{ 0xE2D5,  0xE2D5 },
	{ 0xE2D6,  0xE2D6 },
	{ 0xE2D7,  0xE2D7 },
	{ 0xE2D8,  0xE2D8 },
	{ 0xE2D9,  0xE2D9 },
	{ 0xE2DA,  0xE2DA },
	{ 0xE2DB,  0xE2DB },
	{ 0xE2DC,  0xE2DC },
	{ 0xE2DD,  0xE2DD },
	{ 0xE2DE,  0xE2DE },
	{ 0xE2DF,  0xE2DF },
	{ 0xE2E0,  0xE2E0 },
	{ 0xE2E1,  0xE2E1 },
	{ 0xE2E2,  0xE2E2 },
	{ 0xE2E3,  0xE2E3 },
	{ 0xE2E4,  0xE2E4 },
	{ 0xE2E5,  0xE2E5 },
	{ 0xE2E6,  0xE2E6 },
	{ 0xE2E7,  0xE2E7 },
	{ 0xE2E8,  0xE2E8 },
	{ 0xE2E9,  0xE2E9 },
	{ 0xE2EA,  0xE2EA },
	{ 0xE2EB,  0xE2EB },
	{ 0xE2EC,  0xE2EC },
	{ 0xE2ED,  0xE2ED },
	{ 0xE2EE,  0xE2EE },
	{ 0xE2EF,  0xE2EF },
	{ 0xE2F0,  0xE2F0 },
	{ 0xE2F1,  0xE2F1 },
	{ 0xE2F2,  0xE2F2 },
	{ 0xE2F3,  0xE2F3 },
	{ 0xE2F4,  0xE2F4 },
	{ 0xE2F5,  0xE2F5 },
	{ 0xE2F6,  0xE2F6 },
	{ 0xE2F7,  0xE2F7 },
	{ 0xE2F8,  0xE2F8 },
	{ 0xE2F9,  0xE2F9 },
	{ 0xE2FA,  0xE2FA },
	{ 0xE2FB,  0xE2FB },
	{ 0xE2FC,  0xE2FC },
	{ 0xE2FD,  0xE2FD },
	{ 0xE2FE,  0xE2FE },
	{ 0xE340,  0xE340 },
	{ 0xE341,  0xE341 },
	{ 0xE342,  0xE342 },
	{ 0xE343,  0xE343 },
	{ 0xE344,  0xE344 },
	{ 0xE345,  0xE345 },
	{ 0xE346,  0xE346 },
	{ 0xE347,  0xE347 },
	{ 0xE348,  0xE348 },
	{ 0xE349,  0xE349 },
	{ 0xE34A,  0xE34A },
	{ 0xE34B,  0xE34B },
	{ 0xE34C,  0xE34C },
	{ 0xE34D,  0xE34D },
	{ 0xE34E,  0xE34E },
	{ 0xE34F,  0xE34F },
	{ 0xE350,  0xE350 },
	{ 0xE351,  0xE351 },
	{ 0xE352,  0xE352 },
	{ 0xE353,  0xE353 },
	{ 0xE354,  0xE354 },
	{ 0xE355,  0xE355 },
	{ 0xE356,  0xE356 },
	{ 0xE357,  0xE357 },
	{ 0xE358,  0xE358 },
	{ 0xE359,  0xE359 },
	{ 0xE35A,  0xE35A },
	{ 0xE35B,  0xE35B },
	{ 0xE35C,  0xE35C },
	{ 0xE35D,  0xE35D },
	{ 0xE35E,  0xE35E },
	{ 0xE35F,  0xE35F },
	{ 0xE360,  0xE360 },
	{ 0xE361,  0xE361 },
	{ 0xE362,  0xE362 },
	{ 0xE363,  0xE363 },
	{ 0xE364,  0xE364 },
	{ 0xE365,  0xE365 },
	{ 0xE366,  0xE366 },
	{ 0xE367,  0xE367 },
	{ 0xE368,  0xE368 },
	{ 0xE369,  0xE369 },
	{ 0xE36A,  0xE36A },
	{ 0xE36B,  0xE36B },
	{ 0xE36C,  0xE36C },
	{ 0xE36D,  0xE36D },
	{ 0xE36E,  0xE36E },
	{ 0xE36F,  0xE36F },
	{ 0xE370,  0xE370 },
	{ 0xE371,  0xE371 },
	{ 0xE372,  0xE372 },
	{ 0xE373,  0xE373 },
	{ 0xE374,  0xE374 },
	{ 0xE375,  0xE375 },
	{ 0xE376,  0xE376 },
	{ 0xE377,  0xE377 },
	{ 0xE378,  0xE378 },
	{ 0xE379,  0xE379 },
	{ 0xE37A,  0xE37A },
	{ 0xE37B,  0xE37B },
	{ 0xE37C,  0xE37C },
	{ 0xE37D,  0xE37D },
	{ 0xE37E,  0xE37E },
	{ 0xE3A1,  0xE3A1 },
	{ 0xE3A2,  0xE3A2 },
	{ 0xE3A3,  0xE3A3 },
	{ 0xE3A4,  0xE3A4 },
	{ 0xE3A5,  0xE3A5 },
	{ 0xE3A6,  0xE3A6 },
	{ 0xE3A7,  0xE3A7 },
	{ 0xE3A8,  0xE3A8 },
	{ 0xE3A9,  0xE3A9 },
	{ 0xE3AA,  0xE3AA },
	{ 0xE3AB,  0xE3AB },
	{ 0xE3AC,  0xE3AC },
	{ 0xE3AD,  0xE3AD },
	{ 0xE3AE,  0xE3AE },
	{ 0xE3AF,  0xE3AF },
	{ 0xE3B0,  0xE3B0 },
	{ 0xE3B1,  0xE3B1 },
	{ 0xE3B2,  0xE3B2 },
	{ 0xE3B3,  0xE3B3 },
	{ 0xE3B4,  0xE3B4 },
	{ 0xE3B5,  0xE3B5 },
	{ 0xE3B6,  0xE3B6 },
	{ 0xE3B7,  0xE3B7 },
	{ 0xE3B8,  0xE3B8 },
	{ 0xE3B9,  0xE3B9 },
	{ 0xE3BA,  0xE3BA },
	{ 0xE3BB,  0xE3BB },
	{ 0xE3BC,  0xE3BC },
	{ 0xE3BD,  0xE3BD },
	{ 0xE3BE,  0xE3BE },
	{ 0xE3BF,  0xE3BF },
	{ 0xE3C0,  0xE3C0 },
	{ 0xE3C1,  0xE3C1 },
	{ 0xE3C2,  0xE3C2 },
	{ 0xE3C3,  0xE3C3 },
	{ 0xE3C4,  0xE3C4 },
	{ 0xE3C5,  0xE3C5 },
	{ 0xE3C6,  0xE3C6 },
	{ 0xE3C7,  0xE3C7 },
	{ 0xE3C8,  0xE3C8 },
	{ 0xE3C9,  0xE3C9 },
	{ 0xE3CA,  0xE3CA },
	{ 0xE3CB,  0xE3CB },
	{ 0xE3CC,  0xE3CC },
	{ 0xE3CD,  0xE3CD },
	{ 0xE3CE,  0xE3CE },
	{ 0xE3CF,  0xE3CF },
	{ 0xE3D0,  0xE3D0 },
	{ 0xE3D1,  0xE3D1 },
	{ 0xE3D2,  0xE3D2 },
	{ 0xE3D3,  0xE3D3 },
	{ 0xE3D4,  0xE3D4 },
	{ 0xE3D5,  0xE3D5 },
	{ 0xE3D6,  0xE3D6 },
	{ 0xE3D7,  0xE3D7 },
	{ 0xE3D8,  0xE3D8 },
	{ 0xE3D9,  0xE3D9 },
	{ 0xE3DA,  0xE3DA },
	{ 0xE3DB,  0xE3DB },
	{ 0xE3DC,  0xE3DC },
	{ 0xE3DD,  0xE3DD },
	{ 0xE3DE,  0xE3DE },
	{ 0xE3DF,  0xE3DF },
	{ 0xE3E0,  0xE3E0 },
	{ 0xE3E1,  0xE3E1 },
	{ 0xE3E2,  0xE3E2 },
	{ 0xE3E3,  0xE3E3 },
	{ 0xE3E4,  0xE3E4 },
	{ 0xE3E5,  0xE3E5 },
	{ 0xE3E6,  0xE3E6 },
	{ 0xE3E7,  0xE3E7 },
	{ 0xE3E8,  0xE3E8 },
	{ 0xE3E9,  0xE3E9 },
	{ 0xE3EA,  0xE3EA },
	{ 0xE3EB,  0xE3EB },
	{ 0xE3EC,  0xE3EC },
	{ 0xE3ED,  0xE3ED },
	{ 0xE3EE,  0xE3EE },
	{ 0xE3EF,  0xE3EF },
	{ 0xE3F0,  0xE3F0 },
	{ 0xE3F1,  0xE3F1 },
	{ 0xE3F2,  0xE3F2 },
	{ 0xE3F3,  0xE3F3 },
	{ 0xE3F4,  0xE3F4 },
	{ 0xE3F5,  0xE3F5 },
	{ 0xE3F6,  0xE3F6 },
	{ 0xE3F7,  0xE3F7 },
	{ 0xE3F8,  0xE3F8 },
	{ 0xE3F9,  0xE3F9 },
	{ 0xE3FA,  0xE3FA },
	{ 0xE3FB,  0xE3FB },
	{ 0xE3FC,  0xE3FC },
	{ 0xE3FD,  0xE3FD },
	{ 0xE3FE,  0xE3FE },
	{ 0xE440,  0xE440 },
	{ 0xE441,  0xE441 },
	{ 0xE442,  0xE442 },
	{ 0xE443,  0xE443 },
	{ 0xE444,  0xE444 },
	{ 0xE445,  0xE445 },
	{ 0xE446,  0xE446 },
	{ 0xE447,  0xE447 },
	{ 0xE448,  0xE448 },
	{ 0xE449,  0xE449 },
	{ 0xE44A,  0xE44A },
	{ 0xE44B,  0xE44B },
	{ 0xE44C,  0xE44C },
	{ 0xE44D,  0xE44D },
	{ 0xE44E,  0xE44E },
	{ 0xE44F,  0xE44F },
	{ 0xE450,  0xE450 },
	{ 0xE451,  0xE451 },
	{ 0xE452,  0xE452 },
	{ 0xE453,  0xE453 },
	{ 0xE454,  0xE454 },
	{ 0xE455,  0xE455 },
	{ 0xE456,  0xE456 },
	{ 0xE457,  0xE457 },
	{ 0xE458,  0xE458 },
	{ 0xE459,  0xE459 },
	{ 0xE45A,  0xE45A },
	{ 0xE45B,  0xE45B },
	{ 0xE45C,  0xE45C },
	{ 0xE45D,  0xE45D },
	{ 0xE45E,  0xE45E },
	{ 0xE45F,  0xE45F },
	{ 0xE460,  0xE460 },
	{ 0xE461,  0xE461 },
	{ 0xE462,  0xE462 },
	{ 0xE463,  0xE463 },
	{ 0xE464,  0xE464 },
	{ 0xE465,  0xE465 },
	{ 0xE466,  0xE466 },
	{ 0xE467,  0xE467 },
	{ 0xE468,  0xE468 },
	{ 0xE469,  0xE469 },
	{ 0xE46A,  0xE46A },
	{ 0xE46B,  0xE46B },
	{ 0xE46C,  0xE46C },
	{ 0xE46D,  0xE46D },
	{ 0xE46E,  0xE46E },
	{ 0xE46F,  0xE46F },
	{ 0xE470,  0xE470 },
	{ 0xE471,  0xE471 },
	{ 0xE472,  0xE472 },
	{ 0xE473,  0xE473 },
	{ 0xE474,  0xE474 },
	{ 0xE475,  0xE475 },
	{ 0xE476,  0xE476 },
	{ 0xE477,  0xE477 },
	{ 0xE478,  0xE478 },
	{ 0xE479,  0xE479 },
	{ 0xE47A,  0xE47A },
	{ 0xE47B,  0xE47B },
	{ 0xE47C,  0xE47C },
	{ 0xE47D,  0xE47D },
	{ 0xE47E,  0xE47E },
	{ 0xE4A1,  0xE4A1 },
	{ 0xE4A2,  0xE4A2 },
	{ 0xE4A3,  0xE4A3 },
	{ 0xE4A4,  0xE4A4 },
	{ 0xE4A5,  0xE4A5 },
	{ 0xE4A6,  0xE4A6 },
	{ 0xE4A7,  0xE4A7 },
	{ 0xE4A8,  0xE4A8 },
	{ 0xE4A9,  0xE4A9 },
	{ 0xE4AA,  0xE4AA },
	{ 0xE4AB,  0xE4AB },
	{ 0xE4AC,  0xE4AC },
	{ 0xE4AD,  0xE4AD },
	{ 0xE4AE,  0xE4AE },
	{ 0xE4AF,  0xE4AF },
	{ 0xE4B0,  0xE4B0 },
	{ 0xE4B1,  0xE4B1 },
	{ 0xE4B2,  0xE4B2 },
	{ 0xE4B3,  0xE4B3 },
	{ 0xE4B4,  0xE4B4 },
	{ 0xE4B5,  0xE4B5 },
	{ 0xE4B6,  0xE4B6 },
	{ 0xE4B7,  0xE4B7 },
	{ 0xE4B8,  0xE4B8 },
	{ 0xE4B9,  0xE4B9 },
	{ 0xE4BA,  0xE4BA },
	{ 0xE4BB,  0xE4BB },
	{ 0xE4BC,  0xE4BC },
	{ 0xE4BD,  0xE4BD },
	{ 0xE4BE,  0xE4BE },
	{ 0xE4BF,  0xE4BF },
	{ 0xE4C0,  0xE4C0 },
	{ 0xE4C1,  0xE4C1 },
	{ 0xE4C2,  0xE4C2 },
	{ 0xE4C3,  0xE4C3 },
	{ 0xE4C4,  0xE4C4 },
	{ 0xE4C5,  0xE4C5 },
	{ 0xE4C6,  0xE4C6 },
	{ 0xE4C7,  0xE4C7 },
	{ 0xE4C8,  0xE4C8 },
	{ 0xE4C9,  0xE4C9 },
	{ 0xE4CA,  0xE4CA },
	{ 0xE4CB,  0xE4CB },
	{ 0xE4CC,  0xE4CC },
	{ 0xE4CD,  0xE4CD },
	{ 0xE4CE,  0xE4CE },
	{ 0xE4CF,  0xE4CF },
	{ 0xE4D0,  0xE4D0 },
	{ 0xE4D1,  0xE4D1 },
	{ 0xE4D2,  0xE4D2 },
	{ 0xE4D3,  0xE4D3 },
	{ 0xE4D4,  0xE4D4 },
	{ 0xE4D5,  0xE4D5 },
	{ 0xE4D6,  0xE4D6 },
	{ 0xE4D7,  0xE4D7 },
	{ 0xE4D8,  0xE4D8 },
	{ 0xE4D9,  0xE4D9 },
	{ 0xE4DA,  0xE4DA },
	{ 0xE4DB,  0xE4DB },
	{ 0xE4DC,  0xE4DC },
	{ 0xE4DD,  0xE4DD },
	{ 0xE4DE,  0xE4DE },
	{ 0xE4DF,  0xE4DF },
	{ 0xE4E0,  0xE4E0 },
	{ 0xE4E1,  0xE4E1 },
	{ 0xE4E2,  0xE4E2 },
	{ 0xE4E3,  0xE4E3 },
	{ 0xE4E4,  0xE4E4 },
	{ 0xE4E5,  0xE4E5 },
	{ 0xE4E6,  0xE4E6 },
	{ 0xE4E7,  0xE4E7 },
	{ 0xE4E8,  0xE4E8 },
	{ 0xE4E9,  0xE4E9 },
	{ 0xE4EA,  0xE4EA },
	{ 0xE4EB,  0xE4EB },
	{ 0xE4EC,  0xE4EC },
	{ 0xE4ED,  0xE4ED },
	{ 0xE4EE,  0xE4EE },
	{ 0xE4EF,  0xE4EF },
	{ 0xE4F0,  0xE4F0 },
	{ 0xE4F1,  0xE4F1 },
	{ 0xE4F2,  0xE4F2 },
	{ 0xE4F3,  0xE4F3 },
	{ 0xE4F4,  0xE4F4 },
	{ 0xE4F5,  0xE4F5 },
	{ 0xE4F6,  0xE4F6 },
	{ 0xE4F7,  0xE4F7 },
	{ 0xE4F8,  0xE4F8 },
	{ 0xE4F9,  0xE4F9 },
	{ 0xE4FA,  0xE4FA },
	{ 0xE4FB,  0xE4FB },
	{ 0xE4FC,  0xE4FC },
	{ 0xE4FD,  0xE4FD },
	{ 0xE4FE,  0xE4FE },
	{ 0xE540,  0xE540 },
	{ 0xE541,  0xE541 },
	{ 0xE542,  0xE542 },
	{ 0xE543,  0xE543 },
	{ 0xE544,  0xE544 },
	{ 0xE545,  0xE545 },
	{ 0xE546,  0xE546 },
	{ 0xE547,  0xE547 },
	{ 0xE548,  0xE548 },
	{ 0xE549,  0xE549 },
	{ 0xE54A,  0xE54A },
	{ 0xE54B,  0xE54B },
	{ 0xE54C,  0xE54C },
	{ 0xE54D,  0xE54D },
	{ 0xE54E,  0xE54E },
	{ 0xE54F,  0xE54F },
	{ 0xE550,  0xE550 },
	{ 0xE551,  0xE551 },
	{ 0xE552,  0xE552 },
	{ 0xE553,  0xE553 },
	{ 0xE554,  0xE554 },
	{ 0xE555,  0xE555 },
	{ 0xE556,  0xE556 },
	{ 0xE557,  0xE557 },
	{ 0xE558,  0xE558 },
	{ 0xE559,  0xE559 },
	{ 0xE55A,  0xE55A },
	{ 0xE55B,  0xE55B },
	{ 0xE55C,  0xE55C },
	{ 0xE55D,  0xE55D },
	{ 0xE55E,  0xE55E },
	{ 0xE55F,  0xE55F },
	{ 0xE560,  0xE560 },
	{ 0xE561,  0xE561 },
	{ 0xE562,  0xE562 },
	{ 0xE563,  0xE563 },
	{ 0xE564,  0xE564 },
	{ 0xE565,  0xE565 },
	{ 0xE566,  0xE566 },
	{ 0xE567,  0xE567 },
	{ 0xE568,  0xE568 },
	{ 0xE569,  0xE569 },
	{ 0xE56A,  0xE56A },
	{ 0xE56B,  0xE56B },
	{ 0xE56C,  0xE56C },
	{ 0xE56D,  0xE56D },
	{ 0xE56E,  0xE56E },
	{ 0xE56F,  0xE56F },
	{ 0xE570,  0xE570 },
	{ 0xE571,  0xE571 },
	{ 0xE572,  0xE572 },
	{ 0xE573,  0xE573 },
	{ 0xE574,  0xE574 },
	{ 0xE575,  0xE575 },
	{ 0xE576,  0xE576 },
	{ 0xE577,  0xE577 },
	{ 0xE578,  0xE578 },
	{ 0xE579,  0xE579 },
	{ 0xE57A,  0xE57A },
	{ 0xE57B,  0xE57B },
	{ 0xE57C,  0xE57C },
	{ 0xE57D,  0xE57D },
	{ 0xE57E,  0xE57E },
	{ 0xE5A1,  0xE5A1 },
	{ 0xE5A2,  0xE5A2 },
	{ 0xE5A3,  0xE5A3 },
	{ 0xE5A4,  0xE5A4 },
	{ 0xE5A5,  0xE5A5 },
	{ 0xE5A6,  0xE5A6 },
	{ 0xE5A7,  0xE5A7 },
	{ 0xE5A8,  0xE5A8 },
	{ 0xE5A9,  0xE5A9 },
	{ 0xE5AA,  0xE5AA },
	{ 0xE5AB,  0xE5AB },
	{ 0xE5AC,  0xE5AC },
	{ 0xE5AD,  0xE5AD },
	{ 0xE5AE,  0xE5AE },
	{ 0xE5AF,  0xE5AF },
	{ 0xE5B0,  0xE5B0 },
	{ 0xE5B1,  0xE5B1 },
	{ 0xE5B2,  0xE5B2 },
	{ 0xE5B3,  0xE5B3 },
	{ 0xE5B4,  0xE5B4 },
	{ 0xE5B5,  0xE5B5 },
	{ 0xE5B6,  0xE5B6 },
	{ 0xE5B7,  0xE5B7 },
	{ 0xE5B8,  0xE5B8 },
	{ 0xE5B9,  0xE5B9 },
	{ 0xE5BA,  0xE5BA },
	{ 0xE5BB,  0xE5BB },
	{ 0xE5BC,  0xE5BC },
	{ 0xE5BD,  0xE5BD },
	{ 0xE5BE,  0xE5BE },
	{ 0xE5BF,  0xE5BF },
	{ 0xE5C0,  0xE5C0 },
	{ 0xE5C1,  0xE5C1 },
	{ 0xE5C2,  0xE5C2 },
	{ 0xE5C3,  0xE5C3 },
	{ 0xE5C4,  0xE5C4 },
	{ 0xE5C5,  0xE5C5 },
	{ 0xE5C6,  0xE5C6 },
	{ 0xE5C7,  0xE5C7 },
	{ 0xE5C8,  0xE5C8 },
	{ 0xE5C9,  0xE5C9 },
	{ 0xE5CA,  0xE5CA },
	{ 0xE5CB,  0xE5CB },
	{ 0xE5CC,  0xE5CC },
	{ 0xE5CD,  0xE5CD },
	{ 0xE5CE,  0xE5CE },
	{ 0xE5CF,  0xE5CF },
	{ 0xE5D0,  0xE5D0 },
	{ 0xE5D1,  0xE5D1 },
	{ 0xE5D2,  0xE5D2 },
	{ 0xE5D3,  0xE5D3 },
	{ 0xE5D4,  0xE5D4 },
	{ 0xE5D5,  0xE5D5 },
	{ 0xE5D6,  0xE5D6 },
	{ 0xE5D7,  0xE5D7 },
	{ 0xE5D8,  0xE5D8 },
	{ 0xE5D9,  0xE5D9 },
	{ 0xE5DA,  0xE5DA },
	{ 0xE5DB,  0xE5DB },
	{ 0xE5DC,  0xE5DC },
	{ 0xE5DD,  0xE5DD },
	{ 0xE5DE,  0xE5DE },
	{ 0xE5DF,  0xE5DF },
	{ 0xE5E0,  0xE5E0 },
	{ 0xE5E1,  0xE5E1 },
	{ 0xE5E2,  0xE5E2 },
	{ 0xE5E3,  0xE5E3 },
	{ 0xE5E4,  0xE5E4 },
	{ 0xE5E5,  0xE5E5 },
	{ 0xE5E6,  0xE5E6 },
	{ 0xE5E7,  0xE5E7 },
	{ 0xE5E8,  0xE5E8 },
	{ 0xE5E9,  0xE5E9 },
	{ 0xE5EA,  0xE5EA },
	{ 0xE5EB,  0xE5EB },
	{ 0xE5EC,  0xE5EC },
	{ 0xE5ED,  0xE5ED },
	{ 0xE5EE,  0xE5EE },
	{ 0xE5EF,  0xE5EF },
	{ 0xE5F0,  0xE5F0 },
	{ 0xE5F1,  0xE5F1 },
	{ 0xE5F2,  0xE5F2 },
	{ 0xE5F3,  0xE5F3 },
	{ 0xE5F4,  0xE5F4 },
	{ 0xE5F5,  0xE5F5 },
	{ 0xE5F6,  0xE5F6 },
	{ 0xE5F7,  0xE5F7 },
	{ 0xE5F8,  0xE5F8 },
	{ 0xE5F9,  0xE5F9 },
	{ 0xE5FA,  0xE5FA },
	{ 0xE5FB,  0xE5FB },
	{ 0xE5FC,  0xE5FC },
	{ 0xE5FD,  0xE5FD },
	{ 0xE5FE,  0xE5FE },
	{ 0xE640,  0xE640 },
	{ 0xE641,  0xE641 },
	{ 0xE642,  0xE642 },
	{ 0xE643,  0xE643 },
	{ 0xE644,  0xE644 },
	{ 0xE645,  0xE645 },
	{ 0xE646,  0xE646 },
	{ 0xE647,  0xE647 },
	{ 0xE648,  0xE648 },
	{ 0xE649,  0xE649 },
	{ 0xE64A,  0xE64A },
	{ 0xE64B,  0xE64B },
	{ 0xE64C,  0xE64C },
	{ 0xE64D,  0xE64D },
	{ 0xE64E,  0xE64E },
	{ 0xE64F,  0xE64F },
	{ 0xE650,  0xE650 },
	{ 0xE651,  0xE651 },
	{ 0xE652,  0xE652 },
	{ 0xE653,  0xE653 },
	{ 0xE654,  0xE654 },
	{ 0xE655,  0xE655 },
	{ 0xE656,  0xE656 },
	{ 0xE657,  0xE657 },
	{ 0xE658,  0xE658 },
	{ 0xE659,  0xE659 },
	{ 0xE65A,  0xE65A },
	{ 0xE65B,  0xE65B },
	{ 0xE65C,  0xE65C },
	{ 0xE65D,  0xE65D },
	{ 0xE65E,  0xE65E },
	{ 0xE65F,  0xE65F },
	{ 0xE660,  0xE660 },
	{ 0xE661,  0xE661 },
	{ 0xE662,  0xE662 },
	{ 0xE663,  0xE663 },
	{ 0xE664,  0xE664 },
	{ 0xE665,  0xE665 },
	{ 0xE666,  0xE666 },
	{ 0xE667,  0xE667 },
	{ 0xE668,  0xE668 },
	{ 0xE669,  0xE669 },
	{ 0xE66A,  0xE66A },
	{ 0xE66B,  0xE66B },
	{ 0xE66C,  0xE66C },
	{ 0xE66D,  0xE66D },
	{ 0xE66E,  0xE66E },
	{ 0xE66F,  0xE66F },
	{ 0xE670,  0xE670 },
	{ 0xE671,  0xE671 },
	{ 0xE672,  0xE672 },
	{ 0xE673,  0xE673 },
	{ 0xE674,  0xE674 },
	{ 0xE675,  0xE675 },
	{ 0xE676,  0xE676 },
	{ 0xE677,  0xE677 },
	{ 0xE678,  0xE678 },
	{ 0xE679,  0xE679 },
	{ 0xE67A,  0xE67A },
	{ 0xE67B,  0xE67B },
	{ 0xE67C,  0xE67C },
	{ 0xE67D,  0xE67D },
	{ 0xE67E,  0xE67E },
	{ 0xE6A1,  0xE6A1 },
	{ 0xE6A2,  0xE6A2 },
	{ 0xE6A3,  0xE6A3 },
	{ 0xE6A4,  0xE6A4 },
	{ 0xE6A5,  0xE6A5 },
	{ 0xE6A6,  0xE6A6 },
	{ 0xE6A7,  0xE6A7 },
	{ 0xE6A8,  0xE6A8 },
	{ 0xE6A9,  0xE6A9 },
	{ 0xE6AA,  0xE6AA },
	{ 0xE6AB,  0xE6AB },
	{ 0xE6AC,  0xE6AC },
	{ 0xE6AD,  0xE6AD },
	{ 0xE6AE,  0xE6AE },
	{ 0xE6AF,  0xE6AF },
	{ 0xE6B0,  0xE6B0 },
	{ 0xE6B1,  0xE6B1 },
	{ 0xE6B2,  0xE6B2 },
	{ 0xE6B3,  0xE6B3 },
	{ 0xE6B4,  0xE6B4 },
	{ 0xE6B5,  0xE6B5 },
	{ 0xE6B6,  0xE6B6 },
	{ 0xE6B7,  0xE6B7 },
	{ 0xE6B8,  0xE6B8 },
	{ 0xE6B9,  0xE6B9 },
	{ 0xE6BA,  0xE6BA },
	{ 0xE6BB,  0xE6BB },
	{ 0xE6BC,  0xE6BC },
	{ 0xE6BD,  0xE6BD },
	{ 0xE6BE,  0xE6BE },
	{ 0xE6BF,  0xE6BF },
	{ 0xE6C0,  0xE6C0 },
	{ 0xE6C1,  0xE6C1 },
	{ 0xE6C2,  0xE6C2 },
	{ 0xE6C3,  0xE6C3 },
	{ 0xE6C4,  0xE6C4 },
	{ 0xE6C5,  0xE6C5 },
	{ 0xE6C6,  0xE6C6 },
	{ 0xE6C7,  0xE6C7 },
	{ 0xE6C8,  0xE6C8 },
	{ 0xE6C9,  0xE6C9 },
	{ 0xE6CA,  0xE6CA },
	{ 0xE6CB,  0xE6CB },
	{ 0xE6CC,  0xE6CC },
	{ 0xE6CD,  0xE6CD },
	{ 0xE6CE,  0xE6CE },
	{ 0xE6CF,  0xE6CF },
	{ 0xE6D0,  0xE6D0 },
	{ 0xE6D1,  0xE6D1 },
	{ 0xE6D2,  0xE6D2 },
	{ 0xE6D3,  0xE6D3 },
	{ 0xE6D4,  0xE6D4 },
	{ 0xE6D5,  0xE6D5 },
	{ 0xE6D6,  0xE6D6 },
	{ 0xE6D7,  0xE6D7 },
	{ 0xE6D8,  0xE6D8 },
	{ 0xE6D9,  0xE6D9 },
	{ 0xE6DA,  0xE6DA },
	{ 0xE6DB,  0xE6DB },
	{ 0xE6DC,  0xE6DC },
	{ 0xE6DD,  0xE6DD },
	{ 0xE6DE,  0xE6DE },
	{ 0xE6DF,  0xE6DF },
	{ 0xE6E0,  0xE6E0 },
	{ 0xE6E1,  0xE6E1 },
	{ 0xE6E2,  0xE6E2 },
	{ 0xE6E3,  0xE6E3 },
	{ 0xE6E4,  0xE6E4 },
	{ 0xE6E5,  0xE6E5 },
	{ 0xE6E6,  0xE6E6 },
	{ 0xE6E7,  0xE6E7 },
	{ 0xE6E8,  0xE6E8 },
	{ 0xE6E9,  0xE6E9 },
	{ 0xE6EA,  0xE6EA },
	{ 0xE6EB,  0xE6EB },
	{ 0xE6EC,  0xE6EC },
	{ 0xE6ED,  0xE6ED },
	{ 0xE6EE,  0xE6EE },
	{ 0xE6EF,  0xE6EF },
	{ 0xE6F0,  0xE6F0 },
	{ 0xE6F1,  0xE6F1 },
	{ 0xE6F2,  0xE6F2 },
	{ 0xE6F3,  0xE6F3 },
	{ 0xE6F4,  0xE6F4 },
	{ 0xE6F5,  0xE6F5 },
	{ 0xE6F6,  0xE6F6 },
	{ 0xE6F7,  0xE6F7 },
	{ 0xE6F8,  0xE6F8 },
	{ 0xE6F9,  0xE6F9 },
	{ 0xE6FA,  0xE6FA },
	{ 0xE6FB,  0xE6FB },
	{ 0xE6FC,  0xE6FC },
	{ 0xE6FD,  0xE6FD },
	{ 0xE6FE,  0xE6FE },
	{ 0xE740,  0xE740 },
	{ 0xE741,  0xE741 },
	{ 0xE742,  0xE742 },
	{ 0xE743,  0xE743 },
	{ 0xE744,  0xE744 },
	{ 0xE745,  0xE745 },
	{ 0xE746,  0xE746 },
	{ 0xE747,  0xE747 },
	{ 0xE748,  0xE748 },
	{ 0xE749,  0xE749 },
	{ 0xE74A,  0xE74A },
	{ 0xE74B,  0xE74B },
	{ 0xE74C,  0xE74C },
	{ 0xE74D,  0xE74D },
	{ 0xE74E,  0xE74E },
	{ 0xE74F,  0xE74F },
	{ 0xE750,  0xE750 },
	{ 0xE751,  0xE751 },
	{ 0xE752,  0xE752 },
	{ 0xE753,  0xE753 },
	{ 0xE754,  0xE754 },
	{ 0xE755,  0xE755 },
	{ 0xE756,  0xE756 },
	{ 0xE757,  0xE757 },
	{ 0xE758,  0xE758 },
	{ 0xE759,  0xE759 },
	{ 0xE75A,  0xE75A },
	{ 0xE75B,  0xE75B },
	{ 0xE75C,  0xE75C },
	{ 0xE75D,  0xE75D },
	{ 0xE75E,  0xE75E },
	{ 0xE75F,  0xE75F },
	{ 0xE760,  0xE760 },
	{ 0xE761,  0xE761 },
	{ 0xE762,  0xE762 },
	{ 0xE763,  0xE763 },
	{ 0xE764,  0xE764 },
	{ 0xE765,  0xE765 },
	{ 0xE766,  0xE766 },
	{ 0xE767,  0xE767 },
	{ 0xE768,  0xE768 },
	{ 0xE769,  0xE769 },
	{ 0xE76A,  0xE76A },
	{ 0xE76B,  0xE76B },
	{ 0xE76C,  0xE76C },
	{ 0xE76D,  0xE76D },
	{ 0xE76E,  0xE76E },
	{ 0xE76F,  0xE76F },
	{ 0xE770,  0xE770 },
	{ 0xE771,  0xE771 },
	{ 0xE772,  0xE772 },
	{ 0xE773,  0xE773 },
	{ 0xE774,  0xE774 },
	{ 0xE775,  0xE775 },
	{ 0xE776,  0xE776 },
	{ 0xE777,  0xE777 },
	{ 0xE778,  0xE778 },
	{ 0xE779,  0xE779 },
	{ 0xE77A,  0xE77A },
	{ 0xE77B,  0xE77B },
	{ 0xE77C,  0xE77C },
	{ 0xE77D,  0xE77D },
	{ 0xE77E,  0xE77E },
	{ 0xE7A1,  0xE7A1 },
	{ 0xE7A2,  0xE7A2 },
	{ 0xE7A3,  0xE7A3 },
	{ 0xE7A4,  0xE7A4 },
	{ 0xE7A5,  0xE7A5 },
	{ 0xE7A6,  0xE7A6 },
	{ 0xE7A7,  0xE7A7 },
	{ 0xE7A8,  0xE7A8 },
	{ 0xE7A9,  0xE7A9 },
	{ 0xE7AA,  0xE7AA },
	{ 0xE7AB,  0xE7AB },
	{ 0xE7AC,  0xE7AC },
	{ 0xE7AD,  0xE7AD },
	{ 0xE7AE,  0xE7AE },
	{ 0xE7AF,  0xE7AF },
	{ 0xE7B0,  0xE7B0 },
	{ 0xE7B1,  0xE7B1 },
	{ 0xE7B2,  0xE7B2 },
	{ 0xE7B3,  0xE7B3 },
	{ 0xE7B4,  0xE7B4 },
	{ 0xE7B5,  0xE7B5 },
	{ 0xE7B6,  0xE7B6 },
	{ 0xE7B7,  0xE7B7 },
	{ 0xE7B8,  0xE7B8 },
	{ 0xE7B9,  0xE7B9 },
	{ 0xE7BA,  0xE7BA },
	{ 0xE7BB,  0xE7BB },
	{ 0xE7BC,  0xE7BC },
	{ 0xE7BD,  0xE7BD },
	{ 0xE7BE,  0xE7BE },
	{ 0xE7BF,  0xE7BF },
	{ 0xE7C0,  0xE7C0 },
	{ 0xE7C1,  0xE7C1 },
	{ 0xE7C2,  0xE7C2 },
	{ 0xE7C3,  0xE7C3 },
	{ 0xE7C4,  0xE7C4 },
	{ 0xE7C5,  0xE7C5 },
	{ 0xE7C6,  0xE7C6 },
	{ 0xE7C7,  0xE7C7 },
	{ 0xE7C8,  0xE7C8 },
	{ 0xE7C9,  0xE7C9 },
	{ 0xE7CA,  0xE7CA },
	{ 0xE7CB,  0xE7CB },
	{ 0xE7CC,  0xE7CC },
	{ 0xE7CD,  0xE7CD },
	{ 0xE7CE,  0xE7CE },
	{ 0xE7CF,  0xE7CF },
	{ 0xE7D0,  0xE7D0 },
	{ 0xE7D1,  0xE7D1 },
	{ 0xE7D2,  0xE7D2 },
	{ 0xE7D3,  0xE7D3 },
	{ 0xE7D4,  0xE7D4 },
	{ 0xE7D5,  0xE7D5 },
	{ 0xE7D6,  0xE7D6 },
	{ 0xE7D7,  0xE7D7 },
	{ 0xE7D8,  0xE7D8 },
	{ 0xE7D9,  0xE7D9 },
	{ 0xE7DA,  0xE7DA },
	{ 0xE7DB,  0xE7DB },
	{ 0xE7DC,  0xE7DC },
	{ 0xE7DD,  0xE7DD },
	{ 0xE7DE,  0xE7DE },
	{ 0xE7DF,  0xE7DF },
	{ 0xE7E0,  0xE7E0 },
	{ 0xE7E1,  0xE7E1 },
	{ 0xE7E2,  0xE7E2 },
	{ 0xE7E3,  0xE7E3 },
	{ 0xE7E4,  0xE7E4 },
	{ 0xE7E5,  0xE7E5 },
	{ 0xE7E6,  0xE7E6 },
	{ 0xE7E7,  0xE7E7 },
	{ 0xE7E8,  0xE7E8 },
	{ 0xE7E9,  0xE7E9 },
	{ 0xE7EA,  0xE7EA },
	{ 0xE7EB,  0xE7EB },
	{ 0xE7EC,  0xE7EC },
	{ 0xE7ED,  0xE7ED },
	{ 0xE7EE,  0xE7EE },
	{ 0xE7EF,  0xE7EF },
	{ 0xE7F0,  0xE7F0 },
	{ 0xE7F1,  0xE7F1 },
	{ 0xE7F2,  0xE7F2 },
	{ 0xE7F3,  0xE7F3 },
	{ 0xE7F4,  0xE7F4 },
	{ 0xE7F5,  0xE7F5 },
	{ 0xE7F6,  0xE7F6 },
	{ 0xE7F7,  0xE7F7 },
	{ 0xE7F8,  0xE7F8 },
	{ 0xE7F9,  0xE7F9 },
	{ 0xE7FA,  0xE7FA },
	{ 0xE7FB,  0xE7FB },
	{ 0xE7FC,  0xE7FC },
	{ 0xE7FD,  0xE7FD },
	{ 0xE7FE,  0xE7FE },
	{ 0xE840,  0xE840 },
	{ 0xE841,  0xE841 },
	{ 0xE842,  0xE842 },
	{ 0xE843,  0xE843 },
	{ 0xE844,  0xE844 },
	{ 0xE845,  0xE845 },
	{ 0xE846,  0xE846 },
	{ 0xE847,  0xE847 },
	{ 0xE848,  0xE848 },
	{ 0xE849,  0xE849 },
	{ 0xE84A,  0xE84A },
	{ 0xE84B,  0xE84B },
	{ 0xE84C,  0xE84C },
	{ 0xE84D,  0xE84D },
	{ 0xE84E,  0xE84E },
	{ 0xE84F,  0xE84F },
	{ 0xE850,  0xE850 },
	{ 0xE851,  0xE851 },
	{ 0xE852,  0xE852 },
	{ 0xE853,  0xE853 },
	{ 0xE854,  0xE854 },
	{ 0xE855,  0xE855 },
	{ 0xE856,  0xE856 },
	{ 0xE857,  0xE857 },
	{ 0xE858,  0xE858 },
	{ 0xE859,  0xE859 },
	{ 0xE85A,  0xE85A },
	{ 0xE85B,  0xE85B },
	{ 0xE85C,  0xE85C },
	{ 0xE85D,  0xE85D },
	{ 0xE85E,  0xE85E },
	{ 0xE85F,  0xE85F },
	{ 0xE860,  0xE860 },
	{ 0xE861,  0xE861 },
	{ 0xE862,  0xE862 },
	{ 0xE863,  0xE863 },
	{ 0xE864,  0xE864 },
	{ 0xE865,  0xE865 },
	{ 0xE866,  0xE866 },
	{ 0xE867,  0xE867 },
	{ 0xE868,  0xE868 },
	{ 0xE869,  0xE869 },
	{ 0xE86A,  0xE86A },
	{ 0xE86B,  0xE86B },
	{ 0xE86C,  0xE86C },
	{ 0xE86D,  0xE86D },
	{ 0xE86E,  0xE86E },
	{ 0xE86F,  0xE86F },
	{ 0xE870,  0xE870 },
	{ 0xE871,  0xE871 },
	{ 0xE872,  0xE872 },
	{ 0xE873,  0xE873 },
	{ 0xE874,  0xE874 },
	{ 0xE875,  0xE875 },
	{ 0xE876,  0xE876 },
	{ 0xE877,  0xE877 },
	{ 0xE878,  0xE878 },
	{ 0xE879,  0xE879 },
	{ 0xE87A,  0xE87A },
	{ 0xE87B,  0xE87B },
	{ 0xE87C,  0xE87C },
	{ 0xE87D,  0xE87D },
	{ 0xE87E,  0xE87E },
	{ 0xE8A1,  0xE8A1 },
	{ 0xE8A2,  0xE8A2 },
	{ 0xE8A3,  0xE8A3 },
	{ 0xE8A4,  0xE8A4 },
	{ 0xE8A5,  0xE8A5 },
	{ 0xE8A6,  0xE8A6 },
	{ 0xE8A7,  0xE8A7 },
	{ 0xE8A8,  0xE8A8 },
	{ 0xE8A9,  0xE8A9 },
	{ 0xE8AA,  0xE8AA },
	{ 0xE8AB,  0xE8AB },
	{ 0xE8AC,  0xE8AC },
	{ 0xE8AD,  0xE8AD },
	{ 0xE8AE,  0xE8AE },
	{ 0xE8AF,  0xE8AF },
	{ 0xE8B0,  0xE8B0 },
	{ 0xE8B1,  0xE8B1 },
	{ 0xE8B2,  0xE8B2 },
	{ 0xE8B3,  0xE8B3 },
	{ 0xE8B4,  0xE8B4 },
	{ 0xE8B5,  0xE8B5 },
	{ 0xE8B6,  0xE8B6 },
	{ 0xE8B7,  0xE8B7 },
	{ 0xE8B8,  0xE8B8 },
	{ 0xE8B9,  0xE8B9 },
	{ 0xE8BA,  0xE8BA },
	{ 0xE8BB,  0xE8BB },
	{ 0xE8BC,  0xE8BC },
	{ 0xE8BD,  0xE8BD },
	{ 0xE8BE,  0xE8BE },
	{ 0xE8BF,  0xE8BF },
	{ 0xE8C0,  0xE8C0 },
	{ 0xE8C1,  0xE8C1 },
	{ 0xE8C2,  0xE8C2 },
	{ 0xE8C3,  0xE8C3 },
	{ 0xE8C4,  0xE8C4 },
	{ 0xE8C5,  0xE8C5 },
	{ 0xE8C6,  0xE8C6 },
	{ 0xE8C7,  0xE8C7 },
	{ 0xE8C8,  0xE8C8 },
	{ 0xE8C9,  0xE8C9 },
	{ 0xE8CA,  0xE8CA },
	{ 0xE8CB,  0xE8CB },
	{ 0xE8CC,  0xE8CC },
	{ 0xE8CD,  0xE8CD },
	{ 0xE8CE,  0xE8CE },
	{ 0xE8CF,  0xE8CF },
	{ 0xE8D0,  0xE8D0 },
	{ 0xE8D1,  0xE8D1 },
	{ 0xE8D2,  0xE8D2 },
	{ 0xE8D3,  0xE8D3 },
	{ 0xE8D4,  0xE8D4 },
	{ 0xE8D5,  0xE8D5 },
	{ 0xE8D6,  0xE8D6 },
	{ 0xE8D7,  0xE8D7 },
	{ 0xE8D8,  0xE8D8 },
	{ 0xE8D9,  0xE8D9 },
	{ 0xE8DA,  0xE8DA },
	{ 0xE8DB,  0xE8DB },
	{ 0xE8DC,  0xE8DC },
	{ 0xE8DD,  0xE8DD },
	{ 0xE8DE,  0xE8DE },
	{ 0xE8DF,  0xE8DF },
	{ 0xE8E0,  0xE8E0 },
	{ 0xE8E1,  0xE8E1 },
	{ 0xE8E2,  0xE8E2 },
	{ 0xE8E3,  0xE8E3 },
	{ 0xE8E4,  0xE8E4 },
	{ 0xE8E5,  0xE8E5 },
	{ 0xE8E6,  0xE8E6 },
	{ 0xE8E7,  0xE8E7 },
	{ 0xE8E8,  0xE8E8 },
	{ 0xE8E9,  0xE8E9 },
	{ 0xE8EA,  0xE8EA },
	{ 0xE8EB,  0xE8EB },
	{ 0xE8EC,  0xE8EC },
	{ 0xE8ED,  0xE8ED },
	{ 0xE8EE,  0xE8EE },
	{ 0xE8EF,  0xE8EF },
	{ 0xE8F0,  0xE8F0 },
	{ 0xE8F1,  0xE8F1 },
	{ 0xE8F2,  0xE8F2 },
	{ 0xE8F3,  0xE8F3 },
	{ 0xE8F4,  0xE8F4 },
	{ 0xE8F5,  0xE8F5 },
	{ 0xE8F6,  0xE8F6 },
	{ 0xE8F7,  0xE8F7 },
	{ 0xE8F8,  0xE8F8 },
	{ 0xE8F9,  0xE8F9 },
	{ 0xE8FA,  0xE8FA },
	{ 0xE8FB,  0xE8FB },
	{ 0xE8FC,  0xE8FC },
	{ 0xE8FD,  0xE8FD },
	{ 0xE8FE,  0xE8FE },
	{ 0xE940,  0xE940 },
	{ 0xE941,  0xE941 },
	{ 0xE942,  0xE942 },
	{ 0xE943,  0xE943 },
	{ 0xE944,  0xE944 },
	{ 0xE945,  0xE945 },
	{ 0xE946,  0xE946 },
	{ 0xE947,  0xE947 },
	{ 0xE948,  0xE948 },
	{ 0xE949,  0xE949 },
	{ 0xE94A,  0xE94A },
	{ 0xE94B,  0xE94B },
	{ 0xE94C,  0xE94C },
	{ 0xE94D,  0xE94D },
	{ 0xE94E,  0xE94E },
	{ 0xE94F,  0xE94F },
	{ 0xE950,  0xE950 },
	{ 0xE951,  0xE951 },
	{ 0xE952,  0xE952 },
	{ 0xE953,  0xE953 },
	{ 0xE954,  0xE954 },
	{ 0xE955,  0xE955 },
	{ 0xE956,  0xE956 },
	{ 0xE957,  0xE957 },
	{ 0xE958,  0xE958 },
	{ 0xE959,  0xE959 },
	{ 0xE95A,  0xE95A },
	{ 0xE95B,  0xE95B },
	{ 0xE95C,  0xE95C },
	{ 0xE95D,  0xE95D },
	{ 0xE95E,  0xE95E },
	{ 0xE95F,  0xE95F },
	{ 0xE960,  0xE960 },
	{ 0xE961,  0xE961 },
	{ 0xE962,  0xE962 },
	{ 0xE963,  0xE963 },
	{ 0xE964,  0xE964 },
	{ 0xE965,  0xE965 },
	{ 0xE966,  0xE966 },
	{ 0xE967,  0xE967 },
	{ 0xE968,  0xE968 },
	{ 0xE969,  0xE969 },
	{ 0xE96A,  0xE96A },
	{ 0xE96B,  0xE96B },
	{ 0xE96C,  0xE96C },
	{ 0xE96D,  0xE96D },
	{ 0xE96E,  0xE96E },
	{ 0xE96F,  0xE96F },
	{ 0xE970,  0xE970 },
	{ 0xE971,  0xE971 },
	{ 0xE972,  0xE972 },
	{ 0xE973,  0xE973 },
	{ 0xE974,  0xE974 },
	{ 0xE975,  0xE975 },
	{ 0xE976,  0xE976 },
	{ 0xE977,  0xE977 },
	{ 0xE978,  0xE978 },
	{ 0xE979,  0xE979 },
	{ 0xE97A,  0xE97A },
	{ 0xE97B,  0xE97B },
	{ 0xE97C,  0xE97C },
	{ 0xE97D,  0xE97D },
	{ 0xE97E,  0xE97E },
	{ 0xE9A1,  0xE9A1 },
	{ 0xE9A2,  0xE9A2 },
	{ 0xE9A3,  0xE9A3 },
	{ 0xE9A4,  0xE9A4 },
	{ 0xE9A5,  0xE9A5 },
	{ 0xE9A6,  0xE9A6 },
	{ 0xE9A7,  0xE9A7 },
	{ 0xE9A8,  0xE9A8 },
	{ 0xE9A9,  0xE9A9 },
	{ 0xE9AA,  0xE9AA },
	{ 0xE9AB,  0xE9AB },
	{ 0xE9AC,  0xE9AC },
	{ 0xE9AD,  0xE9AD },
	{ 0xE9AE,  0xE9AE },
	{ 0xE9AF,  0xE9AF },
	{ 0xE9B0,  0xE9B0 },
	{ 0xE9B1,  0xE9B1 },
	{ 0xE9B2,  0xE9B2 },
	{ 0xE9B3,  0xE9B3 },
	{ 0xE9B4,  0xE9B4 },
	{ 0xE9B5,  0xE9B5 },
	{ 0xE9B6,  0xE9B6 },
	{ 0xE9B7,  0xE9B7 },
	{ 0xE9B8,  0xE9B8 },
	{ 0xE9B9,  0xE9B9 },
	{ 0xE9BA,  0xE9BA },
	{ 0xE9BB,  0xE9BB },
	{ 0xE9BC,  0xE9BC },
	{ 0xE9BD,  0xE9BD },
	{ 0xE9BE,  0xE9BE },
	{ 0xE9BF,  0xE9BF },
	{ 0xE9C0,  0xE9C0 },
	{ 0xE9C1,  0xE9C1 },
	{ 0xE9C2,  0xE9C2 },
	{ 0xE9C3,  0xE9C3 },
	{ 0xE9C4,  0xE9C4 },
	{ 0xE9C5,  0xE9C5 },
	{ 0xE9C6,  0xE9C6 },
	{ 0xE9C7,  0xE9C7 },
	{ 0xE9C8,  0xE9C8 },
	{ 0xE9C9,  0xE9C9 },
	{ 0xE9CA,  0xE9CA },
	{ 0xE9CB,  0xE9CB },
	{ 0xE9CC,  0xE9CC },
	{ 0xE9CD,  0xE9CD },
	{ 0xE9CE,  0xE9CE },
	{ 0xE9CF,  0xE9CF },
	{ 0xE9D0,  0xE9D0 },
	{ 0xE9D1,  0xE9D1 },
	{ 0xE9D2,  0xE9D2 },
	{ 0xE9D3,  0xE9D3 },
	{ 0xE9D4,  0xE9D4 },
	{ 0xE9D5,  0xE9D5 },
	{ 0xE9D6,  0xE9D6 },
	{ 0xE9D7,  0xE9D7 },
	{ 0xE9D8,  0xE9D8 },
	{ 0xE9D9,  0xE9D9 },
	{ 0xE9DA,  0xE9DA },
	{ 0xE9DB,  0xE9DB },
	{ 0xE9DC,  0xE9DC },
	{ 0xE9DD,  0xE9DD },
	{ 0xE9DE,  0xE9DE },
	{ 0xE9DF,  0xE9DF },
	{ 0xE9E0,  0xE9E0 },
	{ 0xE9E1,  0xE9E1 },
	{ 0xE9E2,  0xE9E2 },
	{ 0xE9E3,  0xE9E3 },
	{ 0xE9E4,  0xE9E4 },
	{ 0xE9E5,  0xE9E5 },
	{ 0xE9E6,  0xE9E6 },
	{ 0xE9E7,  0xE9E7 },
	{ 0xE9E8,  0xE9E8 },
	{ 0xE9E9,  0xE9E9 },
	{ 0xE9EA,  0xE9EA },
	{ 0xE9EB,  0xE9EB },
	{ 0xE9EC,  0xE9EC },
	{ 0xE9ED,  0xE9ED },
	{ 0xE9EE,  0xE9EE },
	{ 0xE9EF,  0xE9EF },
	{ 0xE9F0,  0xE9F0 },
	{ 0xE9F1,  0xE9F1 },
	{ 0xE9F2,  0xE9F2 },
	{ 0xE9F3,  0xE9F3 },
	{ 0xE9F4,  0xE9F4 },
	{ 0xE9F5,  0xE9F5 },
	{ 0xE9F6,  0xE9F6 },
	{ 0xE9F7,  0xE9F7 },
	{ 0xE9F8,  0xE9F8 },
	{ 0xE9F9,  0xE9F9 },
	{ 0xE9FA,  0xE9FA },
	{ 0xE9FB,  0xE9FB },
	{ 0xE9FC,  0xE9FC },
	{ 0xE9FD,  0xE9FD },
	{ 0xE9FE,  0xE9FE },
	{ 0xEA40,  0xEA40 },
	{ 0xEA41,  0xEA41 },
	{ 0xEA42,  0xEA42 },
	{ 0xEA43,  0xEA43 },
	{ 0xEA44,  0xEA44 },
	{ 0xEA45,  0xEA45 },
	{ 0xEA46,  0xEA46 },
	{ 0xEA47,  0xEA47 },
	{ 0xEA48,  0xEA48 },
	{ 0xEA49,  0xEA49 },
	{ 0xEA4A,  0xEA4A },
	{ 0xEA4B,  0xEA4B },
	{ 0xEA4C,  0xEA4C },
	{ 0xEA4D,  0xEA4D },
	{ 0xEA4E,  0xEA4E },
	{ 0xEA4F,  0xEA4F },
	{ 0xEA50,  0xEA50 },
	{ 0xEA51,  0xEA51 },
	{ 0xEA52,  0xEA52 },
	{ 0xEA53,  0xEA53 },
	{ 0xEA54,  0xEA54 },
	{ 0xEA55,  0xEA55 },
	{ 0xEA56,  0xEA56 },
	{ 0xEA57,  0xEA57 },
	{ 0xEA58,  0xEA58 },
	{ 0xEA59,  0xEA59 },
	{ 0xEA5A,  0xEA5A },
	{ 0xEA5B,  0xEA5B },
	{ 0xEA5C,  0xEA5C },
	{ 0xEA5D,  0xEA5D },
	{ 0xEA5E,  0xEA5E },
	{ 0xEA5F,  0xEA5F },
	{ 0xEA60,  0xEA60 },
	{ 0xEA61,  0xEA61 },
	{ 0xEA62,  0xEA62 },
	{ 0xEA63,  0xEA63 },
	{ 0xEA64,  0xEA64 },
	{ 0xEA65,  0xEA65 },
	{ 0xEA66,  0xEA66 },
	{ 0xEA67,  0xEA67 },
	{ 0xEA68,  0xEA68 },
	{ 0xEA69,  0xEA69 },
	{ 0xEA6A,  0xEA6A },
	{ 0xEA6B,  0xEA6B },
	{ 0xEA6C,  0xEA6C },
	{ 0xEA6D,  0xEA6D },
	{ 0xEA6E,  0xEA6E },
	{ 0xEA6F,  0xEA6F },
	{ 0xEA70,  0xEA70 },
	{ 0xEA71,  0xEA71 },
	{ 0xEA72,  0xEA72 },
	{ 0xEA73,  0xEA73 },
	{ 0xEA74,  0xEA74 },
	{ 0xEA75,  0xEA75 },
	{ 0xEA76,  0xEA76 },
	{ 0xEA77,  0xEA77 },
	{ 0xEA78,  0xEA78 },
	{ 0xEA79,  0xEA79 },
	{ 0xEA7A,  0xEA7A },
	{ 0xEA7B,  0xEA7B },
	{ 0xEA7C,  0xEA7C },
	{ 0xEA7D,  0xEA7D },
	{ 0xEA7E,  0xEA7E },
	{ 0xEAA1,  0xEAA1 },
	{ 0xEAA2,  0xEAA2 },
	{ 0xEAA3,  0xEAA3 },
	{ 0xEAA4,  0xEAA4 },
	{ 0xEAA5,  0xEAA5 },
	{ 0xEAA6,  0xEAA6 },
	{ 0xEAA7,  0xEAA7 },
	{ 0xEAA8,  0xEAA8 },
	{ 0xEAA9,  0xEAA9 },
	{ 0xEAAA,  0xEAAA },
	{ 0xEAAB,  0xEAAB },
	{ 0xEAAC,  0xEAAC },
	{ 0xEAAD,  0xEAAD },
	{ 0xEAAE,  0xEAAE },
	{ 0xEAAF,  0xEAAF },
	{ 0xEAB0,  0xEAB0 },
	{ 0xEAB1,  0xEAB1 },
	{ 0xEAB2,  0xEAB2 },
	{ 0xEAB3,  0xEAB3 },
	{ 0xEAB4,  0xEAB4 },
	{ 0xEAB5,  0xEAB5 },
	{ 0xEAB6,  0xEAB6 },
	{ 0xEAB7,  0xEAB7 },
	{ 0xEAB8,  0xEAB8 },
	{ 0xEAB9,  0xEAB9 },
	{ 0xEABA,  0xEABA },
	{ 0xEABB,  0xEABB },
	{ 0xEABC,  0xEABC },
	{ 0xEABD,  0xEABD },
	{ 0xEABE,  0xEABE },
	{ 0xEABF,  0xEABF },
	{ 0xEAC0,  0xEAC0 },
	{ 0xEAC1,  0xEAC1 },
	{ 0xEAC2,  0xEAC2 },
	{ 0xEAC3,  0xEAC3 },
	{ 0xEAC4,  0xEAC4 },
	{ 0xEAC5,  0xEAC5 },
	{ 0xEAC6,  0xEAC6 },
	{ 0xEAC7,  0xEAC7 },
	{ 0xEAC8,  0xEAC8 },
	{ 0xEAC9,  0xEAC9 },
	{ 0xEACA,  0xEACA },
	{ 0xEACB,  0xEACB },
	{ 0xEACC,  0xEACC },
	{ 0xEACD,  0xEACD },
	{ 0xEACE,  0xEACE },
	{ 0xEACF,  0xEACF },
	{ 0xEAD0,  0xEAD0 },
	{ 0xEAD1,  0xEAD1 },
	{ 0xEAD2,  0xEAD2 },
	{ 0xEAD3,  0xEAD3 },
	{ 0xEAD4,  0xEAD4 },
	{ 0xEAD5,  0xEAD5 },
	{ 0xEAD6,  0xEAD6 },
	{ 0xEAD7,  0xEAD7 },
	{ 0xEAD8,  0xEAD8 },
	{ 0xEAD9,  0xEAD9 },
	{ 0xEADA,  0xEADA },
	{ 0xEADB,  0xEADB },
	{ 0xEADC,  0xEADC },
	{ 0xEADD,  0xEADD },
	{ 0xEADE,  0xEADE },
	{ 0xEADF,  0xEADF },
	{ 0xEAE0,  0xEAE0 },
	{ 0xEAE1,  0xEAE1 },
	{ 0xEAE2,  0xEAE2 },
	{ 0xEAE3,  0xEAE3 },
	{ 0xEAE4,  0xEAE4 },
	{ 0xEAE5,  0xEAE5 },
	{ 0xEAE6,  0xEAE6 },
	{ 0xEAE7,  0xEAE7 },
	{ 0xEAE8,  0xEAE8 },
	{ 0xEAE9,  0xEAE9 },
	{ 0xEAEA,  0xEAEA },
	{ 0xEAEB,  0xEAEB },
	{ 0xEAEC,  0xEAEC },
	{ 0xEAED,  0xEAED },
	{ 0xEAEE,  0xEAEE },
	{ 0xEAEF,  0xEAEF },
	{ 0xEAF0,  0xEAF0 },
	{ 0xEAF1,  0xEAF1 },
	{ 0xEAF2,  0xEAF2 },
	{ 0xEAF3,  0xEAF3 },
	{ 0xEAF4,  0xEAF4 },
	{ 0xEAF5,  0xEAF5 },
	{ 0xEAF6,  0xEAF6 },
	{ 0xEAF7,  0xEAF7 },
	{ 0xEAF8,  0xEAF8 },
	{ 0xEAF9,  0xEAF9 },
	{ 0xEAFA,  0xEAFA },
	{ 0xEAFB,  0xEAFB },
	{ 0xEAFC,  0xEAFC },
	{ 0xEAFD,  0xEAFD },
	{ 0xEAFE,  0xEAFE },
	{ 0xEB40,  0xEB40 },
	{ 0xEB41,  0xEB41 },
	{ 0xEB42,  0xEB42 },
	{ 0xEB43,  0xEB43 },
	{ 0xEB44,  0xEB44 },
	{ 0xEB45,  0xEB45 },
	{ 0xEB46,  0xEB46 },
	{ 0xEB47,  0xEB47 },
	{ 0xEB48,  0xEB48 },
	{ 0xEB49,  0xEB49 },
	{ 0xEB4A,  0xEB4A },
	{ 0xEB4B,  0xEB4B },
	{ 0xEB4C,  0xEB4C },
	{ 0xEB4D,  0xEB4D },
	{ 0xEB4E,  0xEB4E },
	{ 0xEB4F,  0xEB4F },
	{ 0xEB50,  0xEB50 },
	{ 0xEB51,  0xEB51 },
	{ 0xEB52,  0xEB52 },
	{ 0xEB53,  0xEB53 },
	{ 0xEB54,  0xEB54 },
	{ 0xEB55,  0xEB55 },
	{ 0xEB56,  0xEB56 },
	{ 0xEB57,  0xEB57 },
	{ 0xEB58,  0xEB58 },
	{ 0xEB59,  0xEB59 },
	{ 0xEB5A,  0xEB5A },
	{ 0xEB5B,  0xEB5B },
	{ 0xEB5C,  0xEB5C },
	{ 0xEB5D,  0xEB5D },
	{ 0xEB5E,  0xEB5E },
	{ 0xEB5F,  0xEB5F },
	{ 0xEB60,  0xEB60 },
	{ 0xEB61,  0xEB61 },
	{ 0xEB62,  0xEB62 },
	{ 0xEB63,  0xEB63 },
	{ 0xEB64,  0xEB64 },
	{ 0xEB65,  0xEB65 },
	{ 0xEB66,  0xEB66 },
	{ 0xEB67,  0xEB67 },
	{ 0xEB68,  0xEB68 },
	{ 0xEB69,  0xEB69 },
	{ 0xEB6A,  0xEB6A },
	{ 0xEB6B,  0xEB6B },
	{ 0xEB6C,  0xEB6C },
	{ 0xEB6D,  0xEB6D },
	{ 0xEB6E,  0xEB6E },
	{ 0xEB6F,  0xEB6F },
	{ 0xEB70,  0xEB70 },
	{ 0xEB71,  0xEB71 },
	{ 0xEB72,  0xEB72 },
	{ 0xEB73,  0xEB73 },
	{ 0xEB74,  0xEB74 },
	{ 0xEB75,  0xEB75 },
	{ 0xEB76,  0xEB76 },
	{ 0xEB77,  0xEB77 },
	{ 0xEB78,  0xEB78 },
	{ 0xEB79,  0xEB79 },
	{ 0xEB7A,  0xEB7A },
	{ 0xEB7B,  0xEB7B },
	{ 0xEB7C,  0xEB7C },
	{ 0xEB7D,  0xEB7D },
	{ 0xEB7E,  0xEB7E },
	{ 0xEBA1,  0xEBA1 },
	{ 0xEBA2,  0xEBA2 },
	{ 0xEBA3,  0xEBA3 },
	{ 0xEBA4,  0xEBA4 },
	{ 0xEBA5,  0xEBA5 },
	{ 0xEBA6,  0xEBA6 },
	{ 0xEBA7,  0xEBA7 },
	{ 0xEBA8,  0xEBA8 },
	{ 0xEBA9,  0xEBA9 },
	{ 0xEBAA,  0xEBAA },
	{ 0xEBAB,  0xEBAB },
	{ 0xEBAC,  0xEBAC },
	{ 0xEBAD,  0xEBAD },
	{ 0xEBAE,  0xEBAE },
	{ 0xEBAF,  0xEBAF },
	{ 0xEBB0,  0xEBB0 },
	{ 0xEBB1,  0xEBB1 },
	{ 0xEBB2,  0xEBB2 },
	{ 0xEBB3,  0xEBB3 },
	{ 0xEBB4,  0xEBB4 },
	{ 0xEBB5,  0xEBB5 },
	{ 0xEBB6,  0xEBB6 },
	{ 0xEBB7,  0xEBB7 },
	{ 0xEBB8,  0xEBB8 },
	{ 0xEBB9,  0xEBB9 },
	{ 0xEBBA,  0xEBBA },
	{ 0xEBBB,  0xEBBB },
	{ 0xEBBC,  0xEBBC },
	{ 0xEBBD,  0xEBBD },
	{ 0xEBBE,  0xEBBE },
	{ 0xEBBF,  0xEBBF },
	{ 0xEBC0,  0xEBC0 },
	{ 0xEBC1,  0xEBC1 },
	{ 0xEBC2,  0xEBC2 },
	{ 0xEBC3,  0xEBC3 },
	{ 0xEBC4,  0xEBC4 },
	{ 0xEBC5,  0xEBC5 },
	{ 0xEBC6,  0xEBC6 },
	{ 0xEBC7,  0xEBC7 },
	{ 0xEBC8,  0xEBC8 },
	{ 0xEBC9,  0xEBC9 },
	{ 0xEBCA,  0xEBCA },
	{ 0xEBCB,  0xEBCB },
	{ 0xEBCC,  0xEBCC },
	{ 0xEBCD,  0xEBCD },
	{ 0xEBCE,  0xEBCE },
	{ 0xEBCF,  0xEBCF },
	{ 0xEBD0,  0xEBD0 },
	{ 0xEBD1,  0xEBD1 },
	{ 0xEBD2,  0xEBD2 },
	{ 0xEBD3,  0xEBD3 },
	{ 0xEBD4,  0xEBD4 },
	{ 0xEBD5,  0xEBD5 },
	{ 0xEBD6,  0xEBD6 },
	{ 0xEBD7,  0xEBD7 },
	{ 0xEBD8,  0xEBD8 },
	{ 0xEBD9,  0xEBD9 },
	{ 0xEBDA,  0xEBDA },
	{ 0xEBDB,  0xEBDB },
	{ 0xEBDC,  0xEBDC },
	{ 0xEBDD,  0xEBDD },
	{ 0xEBDE,  0xEBDE },
	{ 0xEBDF,  0xEBDF },
	{ 0xEBE0,  0xEBE0 },
	{ 0xEBE1,  0xEBE1 },
	{ 0xEBE2,  0xEBE2 },
	{ 0xEBE3,  0xEBE3 },
	{ 0xEBE4,  0xEBE4 },
	{ 0xEBE5,  0xEBE5 },
	{ 0xEBE6,  0xEBE6 },
	{ 0xEBE7,  0xEBE7 },
	{ 0xEBE8,  0xEBE8 },
	{ 0xEBE9,  0xEBE9 },
	{ 0xEBEA,  0xEBEA },
	{ 0xEBEB,  0xEBEB },
	{ 0xEBEC,  0xEBEC },
	{ 0xEBED,  0xEBED },
	{ 0xEBEE,  0xEBEE },
	{ 0xEBEF,  0xEBEF },
	{ 0xEBF0,  0xEBF0 },
	{ 0xEBF1,  0xEBF1 },
	{ 0xEBF2,  0xEBF2 },
	{ 0xEBF3,  0xEBF3 },
	{ 0xEBF4,  0xEBF4 },
	{ 0xEBF5,  0xEBF5 },
	{ 0xEBF6,  0xEBF6 },
	{ 0xEBF7,  0xEBF7 },
	{ 0xEBF8,  0xEBF8 },
	{ 0xEBF9,  0xEBF9 },
	{ 0xEBFA,  0xEBFA },
	{ 0xEBFB,  0xEBFB },
	{ 0xEBFC,  0xEBFC },
	{ 0xEBFD,  0xEBFD },
	{ 0xEBFE,  0xEBFE },
	{ 0xEC40,  0xEC40 },
	{ 0xEC41,  0xEC41 },
	{ 0xEC42,  0xEC42 },
	{ 0xEC43,  0xEC43 },
	{ 0xEC44,  0xEC44 },
	{ 0xEC45,  0xEC45 },
	{ 0xEC46,  0xEC46 },
	{ 0xEC47,  0xEC47 },
	{ 0xEC48,  0xEC48 },
	{ 0xEC49,  0xEC49 },
	{ 0xEC4A,  0xEC4A },
	{ 0xEC4B,  0xEC4B },
	{ 0xEC4C,  0xEC4C },
	{ 0xEC4D,  0xEC4D },
	{ 0xEC4E,  0xEC4E },
	{ 0xEC4F,  0xEC4F },
	{ 0xEC50,  0xEC50 },
	{ 0xEC51,  0xEC51 },
	{ 0xEC52,  0xEC52 },
	{ 0xEC53,  0xEC53 },
	{ 0xEC54,  0xEC54 },
	{ 0xEC55,  0xEC55 },
	{ 0xEC56,  0xEC56 },
	{ 0xEC57,  0xEC57 },
	{ 0xEC58,  0xEC58 },
	{ 0xEC59,  0xEC59 },
	{ 0xEC5A,  0xEC5A },
	{ 0xEC5B,  0xEC5B },
	{ 0xEC5C,  0xEC5C },
	{ 0xEC5D,  0xEC5D },
	{ 0xEC5E,  0xEC5E },
	{ 0xEC5F,  0xEC5F },
	{ 0xEC60,  0xEC60 },
	{ 0xEC61,  0xEC61 },
	{ 0xEC62,  0xEC62 },
	{ 0xEC63,  0xEC63 },
	{ 0xEC64,  0xEC64 },
	{ 0xEC65,  0xEC65 },
	{ 0xEC66,  0xEC66 },
	{ 0xEC67,  0xEC67 },
	{ 0xEC68,  0xEC68 },
	{ 0xEC69,  0xEC69 },
	{ 0xEC6A,  0xEC6A },
	{ 0xEC6B,  0xEC6B },
	{ 0xEC6C,  0xEC6C },
	{ 0xEC6D,  0xEC6D },
	{ 0xEC6E,  0xEC6E },
	{ 0xEC6F,  0xEC6F },
	{ 0xEC70,  0xEC70 },
	{ 0xEC71,  0xEC71 },
	{ 0xEC72,  0xEC72 },
	{ 0xEC73,  0xEC73 },
	{ 0xEC74,  0xEC74 },
	{ 0xEC75,  0xEC75 },
	{ 0xEC76,  0xEC76 },
	{ 0xEC77,  0xEC77 },
	{ 0xEC78,  0xEC78 },
	{ 0xEC79,  0xEC79 },
	{ 0xEC7A,  0xEC7A },
	{ 0xEC7B,  0xEC7B },
	{ 0xEC7C,  0xEC7C },
	{ 0xEC7D,  0xEC7D },
	{ 0xEC7E,  0xEC7E },
	{ 0xECA1,  0xECA1 },
	{ 0xECA2,  0xECA2 },
	{ 0xECA3,  0xECA3 },
	{ 0xECA4,  0xECA4 },
	{ 0xECA5,  0xECA5 },
	{ 0xECA6,  0xECA6 },
	{ 0xECA7,  0xECA7 },
	{ 0xECA8,  0xECA8 },
	{ 0xECA9,  0xECA9 },
	{ 0xECAA,  0xECAA },
	{ 0xECAB,  0xECAB },
	{ 0xECAC,  0xECAC },
	{ 0xECAD,  0xECAD },
	{ 0xECAE,  0xECAE },
	{ 0xECAF,  0xECAF },
	{ 0xECB0,  0xECB0 },
	{ 0xECB1,  0xECB1 },
	{ 0xECB2,  0xECB2 },
	{ 0xECB3,  0xECB3 },
	{ 0xECB4,  0xECB4 },
	{ 0xECB5,  0xECB5 },
	{ 0xECB6,  0xECB6 },
	{ 0xECB7,  0xECB7 },
	{ 0xECB8,  0xECB8 },
	{ 0xECB9,  0xECB9 },
	{ 0xECBA,  0xECBA },
	{ 0xECBB,  0xECBB },
	{ 0xECBC,  0xECBC },
	{ 0xECBD,  0xECBD },
	{ 0xECBE,  0xECBE },
	{ 0xECBF,  0xECBF },
	{ 0xECC0,  0xECC0 },
	{ 0xECC1,  0xECC1 },
	{ 0xECC2,  0xECC2 },
	{ 0xECC3,  0xECC3 },
	{ 0xECC4,  0xECC4 },
	{ 0xECC5,  0xECC5 },
	{ 0xECC6,  0xECC6 },
	{ 0xECC7,  0xECC7 },
	{ 0xECC8,  0xECC8 },
	{ 0xECC9,  0xECC9 },
	{ 0xECCA,  0xECCA },
	{ 0xECCB,  0xECCB },
	{ 0xECCC,  0xECCC },
	{ 0xECCD,  0xECCD },
	{ 0xECCE,  0xECCE },
	{ 0xECCF,  0xECCF },
	{ 0xECD0,  0xECD0 },
	{ 0xECD1,  0xECD1 },
	{ 0xECD2,  0xECD2 },
	{ 0xECD3,  0xECD3 },
	{ 0xECD4,  0xECD4 },
	{ 0xECD5,  0xECD5 },
	{ 0xECD6,  0xECD6 },
	{ 0xECD7,  0xECD7 },
	{ 0xECD8,  0xECD8 },
	{ 0xECD9,  0xECD9 },
	{ 0xECDA,  0xECDA },
	{ 0xECDB,  0xECDB },
	{ 0xECDC,  0xECDC },
	{ 0xECDD,  0xECDD },
	{ 0xECDE,  0xECDE },
	{ 0xECDF,  0xECDF },
	{ 0xECE0,  0xECE0 },
	{ 0xECE1,  0xECE1 },
	{ 0xECE2,  0xECE2 },
	{ 0xECE3,  0xECE3 },
	{ 0xECE4,  0xECE4 },
	{ 0xECE5,  0xECE5 },
	{ 0xECE6,  0xECE6 },
	{ 0xECE7,  0xECE7 },
	{ 0xECE8,  0xECE8 },
	{ 0xECE9,  0xECE9 },
	{ 0xECEA,  0xECEA },
	{ 0xECEB,  0xECEB },
	{ 0xECEC,  0xECEC },
	{ 0xECED,  0xECED },
	{ 0xECEE,  0xECEE },
	{ 0xECEF,  0xECEF },
	{ 0xECF0,  0xECF0 },
	{ 0xECF1,  0xECF1 },
	{ 0xECF2,  0xECF2 },
	{ 0xECF3,  0xECF3 },
	{ 0xECF4,  0xECF4 },
	{ 0xECF5,  0xECF5 },
	{ 0xECF6,  0xECF6 },
	{ 0xECF7,  0xECF7 },
	{ 0xECF8,  0xECF8 },
	{ 0xECF9,  0xECF9 },
	{ 0xECFA,  0xECFA },
	{ 0xECFB,  0xECFB },
	{ 0xECFC,  0xECFC },
	{ 0xECFD,  0xECFD },
	{ 0xECFE,  0xECFE },
	{ 0xED40,  0xED40 },
	{ 0xED41,  0xED41 },
	{ 0xED42,  0xED42 },
	{ 0xED43,  0xED43 },
	{ 0xED44,  0xED44 },
	{ 0xED45,  0xED45 },
	{ 0xED46,  0xED46 },
	{ 0xED47,  0xED47 },
	{ 0xED48,  0xED48 },
	{ 0xED49,  0xED49 },
	{ 0xED4A,  0xED4A },
	{ 0xED4B,  0xED4B },
	{ 0xED4C,  0xED4C },
	{ 0xED4D,  0xED4D },
	{ 0xED4E,  0xED4E },
	{ 0xED4F,  0xED4F },
	{ 0xED50,  0xED50 },
	{ 0xED51,  0xED51 },
	{ 0xED52,  0xED52 },
	{ 0xED53,  0xED53 },
	{ 0xED54,  0xED54 },
	{ 0xED55,  0xED55 },
	{ 0xED56,  0xED56 },
	{ 0xED57,  0xED57 },
	{ 0xED58,  0xED58 },
	{ 0xED59,  0xED59 },
	{ 0xED5A,  0xED5A },
	{ 0xED5B,  0xED5B },
	{ 0xED5C,  0xED5C },
	{ 0xED5D,  0xED5D },
	{ 0xED5E,  0xED5E },
	{ 0xED5F,  0xED5F },
	{ 0xED60,  0xED60 },
	{ 0xED61,  0xED61 },
	{ 0xED62,  0xED62 },
	{ 0xED63,  0xED63 },
	{ 0xED64,  0xED64 },
	{ 0xED65,  0xED65 },
	{ 0xED66,  0xED66 },
	{ 0xED67,  0xED67 },
	{ 0xED68,  0xED68 },
	{ 0xED69,  0xED69 },
	{ 0xED6A,  0xED6A },
	{ 0xED6B,  0xED6B },
	{ 0xED6C,  0xED6C },
	{ 0xED6D,  0xED6D },
	{ 0xED6E,  0xED6E },
	{ 0xED6F,  0xED6F },
	{ 0xED70,  0xED70 },
	{ 0xED71,  0xED71 },
	{ 0xED72,  0xED72 },
	{ 0xED73,  0xED73 },
	{ 0xED74,  0xED74 },
	{ 0xED75,  0xED75 },
	{ 0xED76,  0xED76 },
	{ 0xED77,  0xED77 },
	{ 0xED78,  0xED78 },
	{ 0xED79,  0xED79 },
	{ 0xED7A,  0xED7A },
	{ 0xED7B,  0xED7B },
	{ 0xED7C,  0xED7C },
	{ 0xED7D,  0xED7D },
	{ 0xED7E,  0xED7E },
	{ 0xEDA1,  0xEDA1 },
	{ 0xEDA2,  0xEDA2 },
	{ 0xEDA3,  0xEDA3 },
	{ 0xEDA4,  0xEDA4 },
	{ 0xEDA5,  0xEDA5 },
	{ 0xEDA6,  0xEDA6 },
	{ 0xEDA7,  0xEDA7 },
	{ 0xEDA8,  0xEDA8 },
	{ 0xEDA9,  0xEDA9 },
	{ 0xEDAA,  0xEDAA },
	{ 0xEDAB,  0xEDAB },
	{ 0xEDAC,  0xEDAC },
	{ 0xEDAD,  0xEDAD },
	{ 0xEDAE,  0xEDAE },
	{ 0xEDAF,  0xEDAF },
	{ 0xEDB0,  0xEDB0 },
	{ 0xEDB1,  0xEDB1 },
	{ 0xEDB2,  0xEDB2 },
	{ 0xEDB3,  0xEDB3 },
	{ 0xEDB4,  0xEDB4 },
	{ 0xEDB5,  0xEDB5 },
	{ 0xEDB6,  0xEDB6 },
	{ 0xEDB7,  0xEDB7 },
	{ 0xEDB8,  0xEDB8 },
	{ 0xEDB9,  0xEDB9 },
	{ 0xEDBA,  0xEDBA },
	{ 0xEDBB,  0xEDBB },
	{ 0xEDBC,  0xEDBC },
	{ 0xEDBD,  0xEDBD },
	{ 0xEDBE,  0xEDBE },
	{ 0xEDBF,  0xEDBF },
	{ 0xEDC0,  0xEDC0 },
	{ 0xEDC1,  0xEDC1 },
	{ 0xEDC2,  0xEDC2 },
	{ 0xEDC3,  0xEDC3 },
	{ 0xEDC4,  0xEDC4 },
	{ 0xEDC5,  0xEDC5 },
	{ 0xEDC6,  0xEDC6 },
	{ 0xEDC7,  0xEDC7 },
	{ 0xEDC8,  0xEDC8 },
	{ 0xEDC9,  0xEDC9 },
	{ 0xEDCA,  0xEDCA },
	{ 0xEDCB,  0xEDCB },
	{ 0xEDCC,  0xEDCC },
	{ 0xEDCD,  0xEDCD },
	{ 0xEDCE,  0xEDCE },
	{ 0xEDCF,  0xEDCF },
	{ 0xEDD0,  0xEDD0 },
	{ 0xEDD1,  0xEDD1 },
	{ 0xEDD2,  0xEDD2 },
	{ 0xEDD3,  0xEDD3 },
	{ 0xEDD4,  0xEDD4 },
	{ 0xEDD5,  0xEDD5 },
	{ 0xEDD6,  0xEDD6 },
	{ 0xEDD7,  0xEDD7 },
	{ 0xEDD8,  0xEDD8 },
	{ 0xEDD9,  0xEDD9 },
	{ 0xEDDA,  0xEDDA },
	{ 0xEDDB,  0xEDDB },
	{ 0xEDDC,  0xEDDC },
	{ 0xEDDD,  0xEDDD },
	{ 0xEDDE,  0xEDDE },
	{ 0xEDDF,  0xEDDF },
	{ 0xEDE0,  0xEDE0 },
	{ 0xEDE1,  0xEDE1 },
	{ 0xEDE2,  0xEDE2 },
	{ 0xEDE3,  0xEDE3 },
	{ 0xEDE4,  0xEDE4 },
	{ 0xEDE5,  0xEDE5 },
	{ 0xEDE6,  0xEDE6 },
	{ 0xEDE7,  0xEDE7 },
	{ 0xEDE8,  0xEDE8 },
	{ 0xEDE9,  0xEDE9 },
	{ 0xEDEA,  0xEDEA },
	{ 0xEDEB,  0xEDEB },
	{ 0xEDEC,  0xEDEC },
	{ 0xEDED,  0xEDED },
	{ 0xEDEE,  0xEDEE },
	{ 0xEDEF,  0xEDEF },
	{ 0xEDF0,  0xEDF0 },
	{ 0xEDF1,  0xEDF1 },
	{ 0xEDF2,  0xEDF2 },
	{ 0xEDF3,  0xEDF3 },
	{ 0xEDF4,  0xEDF4 },
	{ 0xEDF5,  0xEDF5 },
	{ 0xEDF6,  0xEDF6 },
	{ 0xEDF7,  0xEDF7 },
	{ 0xEDF8,  0xEDF8 },
	{ 0xEDF9,  0xEDF9 },
	{ 0xEDFA,  0xEDFA },
	{ 0xEDFB,  0xEDFB },
	{ 0xEDFC,  0xEDFC },
	{ 0xEDFD,  0xEDFD },
	{ 0xEDFE,  0xEDFE },
	{ 0xEE40,  0xEE40 },
	{ 0xEE41,  0xEE41 },
	{ 0xEE42,  0xEE42 },
	{ 0xEE43,  0xEE43 },
	{ 0xEE44,  0xEE44 },
	{ 0xEE45,  0xEE45 },
	{ 0xEE46,  0xEE46 },
	{ 0xEE47,  0xEE47 },
	{ 0xEE48,  0xEE48 },
	{ 0xEE49,  0xEE49 },
	{ 0xEE4A,  0xEE4A },
	{ 0xEE4B,  0xEE4B },
	{ 0xEE4C,  0xEE4C },
	{ 0xEE4D,  0xEE4D },
	{ 0xEE4E,  0xEE4E },
	{ 0xEE4F,  0xEE4F },
	{ 0xEE50,  0xEE50 },
	{ 0xEE51,  0xEE51 },
	{ 0xEE52,  0xEE52 },
	{ 0xEE53,  0xEE53 },
	{ 0xEE54,  0xEE54 },
	{ 0xEE55,  0xEE55 },
	{ 0xEE56,  0xEE56 },
	{ 0xEE57,  0xEE57 },
	{ 0xEE58,  0xEE58 },
	{ 0xEE59,  0xEE59 },
	{ 0xEE5A,  0xEE5A },
	{ 0xEE5B,  0xEE5B },
	{ 0xEE5C,  0xEE5C },
	{ 0xEE5D,  0xEE5D },
	{ 0xEE5E,  0xEE5E },
	{ 0xEE5F,  0xEE5F },
	{ 0xEE60,  0xEE60 },
	{ 0xEE61,  0xEE61 },
	{ 0xEE62,  0xEE62 },
	{ 0xEE63,  0xEE63 },
	{ 0xEE64,  0xEE64 },
	{ 0xEE65,  0xEE65 },
	{ 0xEE66,  0xEE66 },
	{ 0xEE67,  0xEE67 },
	{ 0xEE68,  0xEE68 },
	{ 0xEE69,  0xEE69 },
	{ 0xEE6A,  0xEE6A },
	{ 0xEE6B,  0xEE6B },
	{ 0xEE6C,  0xEE6C },
	{ 0xEE6D,  0xEE6D },
	{ 0xEE6E,  0xEE6E },
	{ 0xEE6F,  0xEE6F },
	{ 0xEE70,  0xEE70 },
	{ 0xEE71,  0xEE71 },
	{ 0xEE72,  0xEE72 },
	{ 0xEE73,  0xEE73 },
	{ 0xEE74,  0xEE74 },
	{ 0xEE75,  0xEE75 },
	{ 0xEE76,  0xEE76 },
	{ 0xEE77,  0xEE77 },
	{ 0xEE78,  0xEE78 },
	{ 0xEE79,  0xEE79 },
	{ 0xEE7A,  0xEE7A },
	{ 0xEE7B,  0xEE7B },
	{ 0xEE7C,  0xEE7C },
	{ 0xEE7D,  0xEE7D },
	{ 0xEE7E,  0xEE7E },
	{ 0xEEA1,  0xEEA1 },
	{ 0xEEA2,  0xEEA2 },
	{ 0xEEA3,  0xEEA3 },
	{ 0xEEA4,  0xEEA4 },
	{ 0xEEA5,  0xEEA5 },
	{ 0xEEA6,  0xEEA6 },
	{ 0xEEA7,  0xEEA7 },
	{ 0xEEA8,  0xEEA8 },
	{ 0xEEA9,  0xEEA9 },
	{ 0xEEAA,  0xEEAA },
	{ 0xEEAB,  0xEEAB },
	{ 0xEEAC,  0xEEAC },
	{ 0xEEAD,  0xEEAD },
	{ 0xEEAE,  0xEEAE },
	{ 0xEEAF,  0xEEAF },
	{ 0xEEB0,  0xEEB0 },
	{ 0xEEB1,  0xEEB1 },
	{ 0xEEB2,  0xEEB2 },
	{ 0xEEB3,  0xEEB3 },
	{ 0xEEB4,  0xEEB4 },
	{ 0xEEB5,  0xEEB5 },
	{ 0xEEB6,  0xEEB6 },
	{ 0xEEB7,  0xEEB7 },
	{ 0xEEB8,  0xEEB8 },
	{ 0xEEB9,  0xEEB9 },
	{ 0xEEBA,  0xEEBA },
	{ 0xEEBB,  0xEEBB },
	{ 0xEEBC,  0xEEBC },
	{ 0xEEBD,  0xEEBD },
	{ 0xEEBE,  0xEEBE },
	{ 0xEEBF,  0xEEBF },
	{ 0xEEC0,  0xEEC0 },
	{ 0xEEC1,  0xEEC1 },
	{ 0xEEC2,  0xEEC2 },
	{ 0xEEC3,  0xEEC3 },
	{ 0xEEC4,  0xEEC4 },
	{ 0xEEC5,  0xEEC5 },
	{ 0xEEC6,  0xEEC6 },
	{ 0xEEC7,  0xEEC7 },
	{ 0xEEC8,  0xEEC8 },
	{ 0xEEC9,  0xEEC9 },
	{ 0xEECA,  0xEECA },
	{ 0xEECB,  0xEECB },
	{ 0xEECC,  0xEECC },
	{ 0xEECD,  0xEECD },
	{ 0xEECE,  0xEECE },
	{ 0xEECF,  0xEECF },
	{ 0xEED0,  0xEED0 },
	{ 0xEED1,  0xEED1 },
	{ 0xEED2,  0xEED2 },
	{ 0xEED3,  0xEED3 },
	{ 0xEED4,  0xEED4 },
	{ 0xEED5,  0xEED5 },
	{ 0xEED6,  0xEED6 },
	{ 0xEED7,  0xEED7 },
	{ 0xEED8,  0xEED8 },
	{ 0xEED9,  0xEED9 },
	{ 0xEEDA,  0xEEDA },
	{ 0xEEDB,  0xEEDB },
	{ 0xEEDC,  0xEEDC },
	{ 0xEEDD,  0xEEDD },
	{ 0xEEDE,  0xEEDE },
	{ 0xEEDF,  0xEEDF },
	{ 0xEEE0,  0xEEE0 },
	{ 0xEEE1,  0xEEE1 },
	{ 0xEEE2,  0xEEE2 },
	{ 0xEEE3,  0xEEE3 },
	{ 0xEEE4,  0xEEE4 },
	{ 0xEEE5,  0xEEE5 },
	{ 0xEEE6,  0xEEE6 },
	{ 0xEEE7,  0xEEE7 },
	{ 0xEEE8,  0xEEE8 },
	{ 0xEEE9,  0xEEE9 },
	{ 0xEEEA,  0xEEEA },
	{ 0xEEEB,  0xEEEB },
	{ 0xEEEC,  0xEEEC },
	{ 0xEEED,  0xEEED },
	{ 0xEEEE,  0xEEEE },
	{ 0xEEEF,  0xEEEF },
	{ 0xEEF0,  0xEEF0 },
	{ 0xEEF1,  0xEEF1 },
	{ 0xEEF2,  0xEEF2 },
	{ 0xEEF3,  0xEEF3 },
	{ 0xEEF4,  0xEEF4 },
	{ 0xEEF5,  0xEEF5 },
	{ 0xEEF6,  0xEEF6 },
	{ 0xEEF7,  0xEEF7 },
	{ 0xEEF8,  0xEEF8 },
	{ 0xEEF9,  0xEEF9 },
	{ 0xEEFA,  0xEEFA },
	{ 0xEEFB,  0xEEFB },
	{ 0xEEFC,  0xEEFC },
	{ 0xEEFD,  0xEEFD },
	{ 0xEEFE,  0xEEFE },
	{ 0xEF40,  0xEF40 },
	{ 0xEF41,  0xEF41 },
	{ 0xEF42,  0xEF42 },
	{ 0xEF43,  0xEF43 },
	{ 0xEF44,  0xEF44 },
	{ 0xEF45,  0xEF45 },
	{ 0xEF46,  0xEF46 },
	{ 0xEF47,  0xEF47 },
	{ 0xEF48,  0xEF48 },
	{ 0xEF49,  0xEF49 },
	{ 0xEF4A,  0xEF4A },
	{ 0xEF4B,  0xEF4B },
	{ 0xEF4C,  0xEF4C },
	{ 0xEF4D,  0xEF4D },
	{ 0xEF4E,  0xEF4E },
	{ 0xEF4F,  0xEF4F },
	{ 0xEF50,  0xEF50 },
	{ 0xEF51,  0xEF51 },
	{ 0xEF52,  0xEF52 },
	{ 0xEF53,  0xEF53 },
	{ 0xEF54,  0xEF54 },
	{ 0xEF55,  0xEF55 },
	{ 0xEF56,  0xEF56 },
	{ 0xEF57,  0xEF57 },
	{ 0xEF58,  0xEF58 },
	{ 0xEF59,  0xEF59 },
	{ 0xEF5A,  0xEF5A },
	{ 0xEF5B,  0xEF5B },
	{ 0xEF5C,  0xEF5C },
	{ 0xEF5D,  0xEF5D },
	{ 0xEF5E,  0xEF5E },
	{ 0xEF5F,  0xEF5F },
	{ 0xEF60,  0xEF60 },
	{ 0xEF61,  0xEF61 },
	{ 0xEF62,  0xEF62 },
	{ 0xEF63,  0xEF63 },
	{ 0xEF64,  0xEF64 },
	{ 0xEF65,  0xEF65 },
	{ 0xEF66,  0xEF66 },
	{ 0xEF67,  0xEF67 },
	{ 0xEF68,  0xEF68 },
	{ 0xEF69,  0xEF69 },
	{ 0xEF6A,  0xEF6A },
	{ 0xEF6B,  0xEF6B },
	{ 0xEF6C,  0xEF6C },
	{ 0xEF6D,  0xEF6D },
	{ 0xEF6E,  0xEF6E },
	{ 0xEF6F,  0xEF6F },
	{ 0xEF70,  0xEF70 },
	{ 0xEF71,  0xEF71 },
	{ 0xEF72,  0xEF72 },
	{ 0xEF73,  0xEF73 },
	{ 0xEF74,  0xEF74 },
	{ 0xEF75,  0xEF75 },
	{ 0xEF76,  0xEF76 },
	{ 0xEF77,  0xEF77 },
	{ 0xEF78,  0xEF78 },
	{ 0xEF79,  0xEF79 },
	{ 0xEF7A,  0xEF7A },
	{ 0xEF7B,  0xEF7B },
	{ 0xEF7C,  0xEF7C },
	{ 0xEF7D,  0xEF7D },
	{ 0xEF7E,  0xEF7E },
	{ 0xEFA1,  0xEFA1 },
	{ 0xEFA2,  0xEFA2 },
	{ 0xEFA3,  0xEFA3 },
	{ 0xEFA4,  0xEFA4 },
	{ 0xEFA5,  0xEFA5 },
	{ 0xEFA6,  0xEFA6 },
	{ 0xEFA7,  0xEFA7 },
	{ 0xEFA8,  0xEFA8 },
	{ 0xEFA9,  0xEFA9 },
	{ 0xEFAA,  0xEFAA },
	{ 0xEFAB,  0xEFAB },
	{ 0xEFAC,  0xEFAC },
	{ 0xEFAD,  0xEFAD },
	{ 0xEFAE,  0xEFAE },
	{ 0xEFAF,  0xEFAF },
	{ 0xEFB0,  0xEFB0 },
	{ 0xEFB1,  0xEFB1 },
	{ 0xEFB2,  0xEFB2 },
	{ 0xEFB3,  0xEFB3 },
	{ 0xEFB4,  0xEFB4 },
	{ 0xEFB5,  0xEFB5 },
	{ 0xEFB6,  0xEFB6 },
	{ 0xEFB7,  0xEFB7 },
	{ 0xEFB8,  0xEFB8 },
	{ 0xEFB9,  0xEFB9 },
	{ 0xEFBA,  0xEFBA },
	{ 0xEFBB,  0xEFBB },
	{ 0xEFBC,  0xEFBC },
	{ 0xEFBD,  0xEFBD },
	{ 0xEFBE,  0xEFBE },
	{ 0xEFBF,  0xEFBF },
	{ 0xEFC0,  0xEFC0 },
	{ 0xEFC1,  0xEFC1 },
	{ 0xEFC2,  0xEFC2 },
	{ 0xEFC3,  0xEFC3 },
	{ 0xEFC4,  0xEFC4 },
	{ 0xEFC5,  0xEFC5 },
	{ 0xEFC6,  0xEFC6 },
	{ 0xEFC7,  0xEFC7 },
	{ 0xEFC8,  0xEFC8 },
	{ 0xEFC9,  0xEFC9 },
	{ 0xEFCA,  0xEFCA },
	{ 0xEFCB,  0xEFCB },
	{ 0xEFCC,  0xEFCC },
	{ 0xEFCD,  0xEFCD },
	{ 0xEFCE,  0xEFCE },
	{ 0xEFCF,  0xEFCF },
	{ 0xEFD0,  0xEFD0 },
	{ 0xEFD1,  0xEFD1 },
	{ 0xEFD2,  0xEFD2 },
	{ 0xEFD3,  0xEFD3 },
	{ 0xEFD4,  0xEFD4 },
	{ 0xEFD5,  0xEFD5 },
	{ 0xEFD6,  0xEFD6 },
	{ 0xEFD7,  0xEFD7 },
	{ 0xEFD8,  0xEFD8 },
	{ 0xEFD9,  0xEFD9 },
	{ 0xEFDA,  0xEFDA },
	{ 0xEFDB,  0xEFDB },
	{ 0xEFDC,  0xEFDC },
	{ 0xEFDD,  0xEFDD },
	{ 0xEFDE,  0xEFDE },
	{ 0xEFDF,  0xEFDF },
	{ 0xEFE0,  0xEFE0 },
	{ 0xEFE1,  0xEFE1 },
	{ 0xEFE2,  0xEFE2 },
	{ 0xEFE3,  0xEFE3 },
	{ 0xEFE4,  0xEFE4 },
	{ 0xEFE5,  0xEFE5 },
	{ 0xEFE6,  0xEFE6 },
	{ 0xEFE7,  0xEFE7 },
	{ 0xEFE8,  0xEFE8 },
	{ 0xEFE9,  0xEFE9 },
	{ 0xEFEA,  0xEFEA },
	{ 0xEFEB,  0xEFEB },
	{ 0xEFEC,  0xEFEC },
	{ 0xEFED,  0xEFED },
	{ 0xEFEE,  0xEFEE },
	{ 0xEFEF,  0xEFEF },
	{ 0xEFF0,  0xEFF0 },
	{ 0xEFF1,  0xEFF1 },
	{ 0xEFF2,  0xEFF2 },
	{ 0xEFF3,  0xEFF3 },
	{ 0xEFF4,  0xEFF4 },
	{ 0xEFF5,  0xEFF5 },
	{ 0xEFF6,  0xEFF6 },
	{ 0xEFF7,  0xEFF7 },
	{ 0xEFF8,  0xEFF8 },
	{ 0xEFF9,  0xEFF9 },
	{ 0xEFFA,  0xEFFA },
	{ 0xEFFB,  0xEFFB },
	{ 0xEFFC,  0xEFFC },
	{ 0xEFFD,  0xEFFD },
	{ 0xEFFE,  0xEFFE },
	{ 0xF040,  0xF040 },
	{ 0xF041,  0xF041 },
	{ 0xF042,  0xF042 },
	{ 0xF043,  0xF043 },
	{ 0xF044,  0xF044 },
	{ 0xF045,  0xF045 },
	{ 0xF046,  0xF046 },
	{ 0xF047,  0xF047 },
	{ 0xF048,  0xF048 },
	{ 0xF049,  0xF049 },
	{ 0xF04A,  0xF04A },
	{ 0xF04B,  0xF04B },
	{ 0xF04C,  0xF04C },
	{ 0xF04D,  0xF04D },
	{ 0xF04E,  0xF04E },
	{ 0xF04F,  0xF04F },
	{ 0xF050,  0xF050 },
	{ 0xF051,  0xF051 },
	{ 0xF052,  0xF052 },
	{ 0xF053,  0xF053 },
	{ 0xF054,  0xF054 },
	{ 0xF055,  0xF055 },
	{ 0xF056,  0xF056 },
	{ 0xF057,  0xF057 },
	{ 0xF058,  0xF058 },
	{ 0xF059,  0xF059 },
	{ 0xF05A,  0xF05A },
	{ 0xF05B,  0xF05B },
	{ 0xF05C,  0xF05C },
	{ 0xF05D,  0xF05D },
	{ 0xF05E,  0xF05E },
	{ 0xF05F,  0xF05F },
	{ 0xF060,  0xF060 },
	{ 0xF061,  0xF061 },
	{ 0xF062,  0xF062 },
	{ 0xF063,  0xF063 },
	{ 0xF064,  0xF064 },
	{ 0xF065,  0xF065 },
	{ 0xF066,  0xF066 },
	{ 0xF067,  0xF067 },
	{ 0xF068,  0xF068 },
	{ 0xF069,  0xF069 },
	{ 0xF06A,  0xF06A },
	{ 0xF06B,  0xF06B },
	{ 0xF06C,  0xF06C },
	{ 0xF06D,  0xF06D },
	{ 0xF06E,  0xF06E },
	{ 0xF06F,  0xF06F },
	{ 0xF070,  0xF070 },
	{ 0xF071,  0xF071 },
	{ 0xF072,  0xF072 },
	{ 0xF073,  0xF073 },
	{ 0xF074,  0xF074 },
	{ 0xF075,  0xF075 },
	{ 0xF076,  0xF076 },
	{ 0xF077,  0xF077 },
	{ 0xF078,  0xF078 },
	{ 0xF079,  0xF079 },
	{ 0xF07A,  0xF07A },
	{ 0xF07B,  0xF07B },
	{ 0xF07C,  0xF07C },
	{ 0xF07D,  0xF07D },
	{ 0xF07E,  0xF07E },
	{ 0xF0A1,  0xF0A1 },
	{ 0xF0A2,  0xF0A2 },
	{ 0xF0A3,  0xF0A3 },
	{ 0xF0A4,  0xF0A4 },
	{ 0xF0A5,  0xF0A5 },
	{ 0xF0A6,  0xF0A6 },
	{ 0xF0A7,  0xF0A7 },
	{ 0xF0A8,  0xF0A8 },
	{ 0xF0A9,  0xF0A9 },
	{ 0xF0AA,  0xF0AA },
	{ 0xF0AB,  0xF0AB },
	{ 0xF0AC,  0xF0AC },
	{ 0xF0AD,  0xF0AD },
	{ 0xF0AE,  0xF0AE },
	{ 0xF0AF,  0xF0AF },
	{ 0xF0B0,  0xF0B0 },
	{ 0xF0B1,  0xF0B1 },
	{ 0xF0B2,  0xF0B2 },
	{ 0xF0B3,  0xF0B3 },
	{ 0xF0B4,  0xF0B4 },
	{ 0xF0B5,  0xF0B5 },
	{ 0xF0B6,  0xF0B6 },
	{ 0xF0B7,  0xF0B7 },
	{ 0xF0B8,  0xF0B8 },
	{ 0xF0B9,  0xF0B9 },
	{ 0xF0BA,  0xF0BA },
	{ 0xF0BB,  0xF0BB },
	{ 0xF0BC,  0xF0BC },
	{ 0xF0BD,  0xF0BD },
	{ 0xF0BE,  0xF0BE },
	{ 0xF0BF,  0xF0BF },
	{ 0xF0C0,  0xF0C0 },
	{ 0xF0C1,  0xF0C1 },
	{ 0xF0C2,  0xF0C2 },
	{ 0xF0C3,  0xF0C3 },
	{ 0xF0C4,  0xF0C4 },
	{ 0xF0C5,  0xF0C5 },
	{ 0xF0C6,  0xF0C6 },
	{ 0xF0C7,  0xF0C7 },
	{ 0xF0C8,  0xF0C8 },
	{ 0xF0C9,  0xF0C9 },
	{ 0xF0CA,  0xF0CA },
	{ 0xF0CB,  0xF0CB },
	{ 0xF0CC,  0xF0CC },
	{ 0xF0CD,  0xF0CD },
	{ 0xF0CE,  0xF0CE },
	{ 0xF0CF,  0xF0CF },
	{ 0xF0D0,  0xF0D0 },
	{ 0xF0D1,  0xF0D1 },
	{ 0xF0D2,  0xF0D2 },
	{ 0xF0D3,  0xF0D3 },
	{ 0xF0D4,  0xF0D4 },
	{ 0xF0D5,  0xF0D5 },
	{ 0xF0D6,  0xF0D6 },
	{ 0xF0D7,  0xF0D7 },
	{ 0xF0D8,  0xF0D8 },
	{ 0xF0D9,  0xF0D9 },
	{ 0xF0DA,  0xF0DA },
	{ 0xF0DB,  0xF0DB },
	{ 0xF0DC,  0xF0DC },
	{ 0xF0DD,  0xF0DD },
	{ 0xF0DE,  0xF0DE },
	{ 0xF0DF,  0xF0DF },
	{ 0xF0E0,  0xF0E0 },
	{ 0xF0E1,  0xF0E1 },
	{ 0xF0E2,  0xF0E2 },
	{ 0xF0E3,  0xF0E3 },
	{ 0xF0E4,  0xF0E4 },
	{ 0xF0E5,  0xF0E5 },
	{ 0xF0E6,  0xF0E6 },
	{ 0xF0E7,  0xF0E7 },
	{ 0xF0E8,  0xF0E8 },
	{ 0xF0E9,  0xF0E9 },
	{ 0xF0EA,  0xF0EA },
	{ 0xF0EB,  0xF0EB },
	{ 0xF0EC,  0xF0EC },
	{ 0xF0ED,  0xF0ED },
	{ 0xF0EE,  0xF0EE },
	{ 0xF0EF,  0xF0EF },
	{ 0xF0F0,  0xF0F0 },
	{ 0xF0F1,  0xF0F1 },
	{ 0xF0F2,  0xF0F2 },
	{ 0xF0F3,  0xF0F3 },
	{ 0xF0F4,  0xF0F4 },
	{ 0xF0F5,  0xF0F5 },
	{ 0xF0F6,  0xF0F6 },
	{ 0xF0F7,  0xF0F7 },
	{ 0xF0F8,  0xF0F8 },
	{ 0xF0F9,  0xF0F9 },
	{ 0xF0FA,  0xF0FA },
	{ 0xF0FB,  0xF0FB },
	{ 0xF0FC,  0xF0FC },
	{ 0xF0FD,  0xF0FD },
	{ 0xF0FE,  0xF0FE },
	{ 0xF140,  0xF140 },
	{ 0xF141,  0xF141 },
	{ 0xF142,  0xF142 },
	{ 0xF143,  0xF143 },
	{ 0xF144,  0xF144 },
	{ 0xF145,  0xF145 },
	{ 0xF146,  0xF146 },
	{ 0xF147,  0xF147 },
	{ 0xF148,  0xF148 },
	{ 0xF149,  0xF149 },
	{ 0xF14A,  0xF14A },
	{ 0xF14B,  0xF14B },
	{ 0xF14C,  0xF14C },
	{ 0xF14D,  0xF14D },
	{ 0xF14E,  0xF14E },
	{ 0xF14F,  0xF14F },
	{ 0xF150,  0xF150 },
	{ 0xF151,  0xF151 },
	{ 0xF152,  0xF152 },
	{ 0xF153,  0xF153 },
	{ 0xF154,  0xF154 },
	{ 0xF155,  0xF155 },
	{ 0xF156,  0xF156 },
	{ 0xF157,  0xF157 },
	{ 0xF158,  0xF158 },
	{ 0xF159,  0xF159 },
	{ 0xF15A,  0xF15A },
	{ 0xF15B,  0xF15B },
	{ 0xF15C,  0xF15C },
	{ 0xF15D,  0xF15D },
	{ 0xF15E,  0xF15E },
	{ 0xF15F,  0xF15F },
	{ 0xF160,  0xF160 },
	{ 0xF161,  0xF161 },
	{ 0xF162,  0xF162 },
	{ 0xF163,  0xF163 },
	{ 0xF164,  0xF164 },
	{ 0xF165,  0xF165 },
	{ 0xF166,  0xF166 },
	{ 0xF167,  0xF167 },
	{ 0xF168,  0xF168 },
	{ 0xF169,  0xF169 },
	{ 0xF16A,  0xF16A },
	{ 0xF16B,  0xF16B },
	{ 0xF16C,  0xF16C },
	{ 0xF16D,  0xF16D },
	{ 0xF16E,  0xF16E },
	{ 0xF16F,  0xF16F },
	{ 0xF170,  0xF170 },
	{ 0xF171,  0xF171 },
	{ 0xF172,  0xF172 },
	{ 0xF173,  0xF173 },
	{ 0xF174,  0xF174 },
	{ 0xF175,  0xF175 },
	{ 0xF176,  0xF176 },
	{ 0xF177,  0xF177 },
	{ 0xF178,  0xF178 },
	{ 0xF179,  0xF179 },
	{ 0xF17A,  0xF17A },
	{ 0xF17B,  0xF17B },
	{ 0xF17C,  0xF17C },
	{ 0xF17D,  0xF17D },
	{ 0xF17E,  0xF17E },
	{ 0xF1A1,  0xF1A1 },
	{ 0xF1A2,  0xF1A2 },
	{ 0xF1A3,  0xF1A3 },
	{ 0xF1A4,  0xF1A4 },
	{ 0xF1A5,  0xF1A5 },
	{ 0xF1A6,  0xF1A6 },
	{ 0xF1A7,  0xF1A7 },
	{ 0xF1A8,  0xF1A8 },
	{ 0xF1A9,  0xF1A9 },
	{ 0xF1AA,  0xF1AA },
	{ 0xF1AB,  0xF1AB },
	{ 0xF1AC,  0xF1AC },
	{ 0xF1AD,  0xF1AD },
	{ 0xF1AE,  0xF1AE },
	{ 0xF1AF,  0xF1AF },
	{ 0xF1B0,  0xF1B0 },
	{ 0xF1B1,  0xF1B1 },
	{ 0xF1B2,  0xF1B2 },
	{ 0xF1B3,  0xF1B3 },
	{ 0xF1B4,  0xF1B4 },
	{ 0xF1B5,  0xF1B5 },
	{ 0xF1B6,  0xF1B6 },
	{ 0xF1B7,  0xF1B7 },
	{ 0xF1B8,  0xF1B8 },
	{ 0xF1B9,  0xF1B9 },
	{ 0xF1BA,  0xF1BA },
	{ 0xF1BB,  0xF1BB },
	{ 0xF1BC,  0xF1BC },
	{ 0xF1BD,  0xF1BD },
	{ 0xF1BE,  0xF1BE },
	{ 0xF1BF,  0xF1BF },
	{ 0xF1C0,  0xF1C0 },
	{ 0xF1C1,  0xF1C1 },
	{ 0xF1C2,  0xF1C2 },
	{ 0xF1C3,  0xF1C3 },
	{ 0xF1C4,  0xF1C4 },
	{ 0xF1C5,  0xF1C5 },
	{ 0xF1C6,  0xF1C6 },
	{ 0xF1C7,  0xF1C7 },
	{ 0xF1C8,  0xF1C8 },
	{ 0xF1C9,  0xF1C9 },
	{ 0xF1CA,  0xF1CA },
	{ 0xF1CB,  0xF1CB },
	{ 0xF1CC,  0xF1CC },
	{ 0xF1CD,  0xF1CD },
	{ 0xF1CE,  0xF1CE },
	{ 0xF1CF,  0xF1CF },
	{ 0xF1D0,  0xF1D0 },
	{ 0xF1D1,  0xF1D1 },
	{ 0xF1D2,  0xF1D2 },
	{ 0xF1D3,  0xF1D3 },
	{ 0xF1D4,  0xF1D4 },
	{ 0xF1D5,  0xF1D5 },
	{ 0xF1D6,  0xF1D6 },
	{ 0xF1D7,  0xF1D7 },
	{ 0xF1D8,  0xF1D8 },
	{ 0xF1D9,  0xF1D9 },
	{ 0xF1DA,  0xF1DA },
	{ 0xF1DB,  0xF1DB },
	{ 0xF1DC,  0xF1DC },
	{ 0xF1DD,  0xF1DD },
	{ 0xF1DE,  0xF1DE },
	{ 0xF1DF,  0xF1DF },
	{ 0xF1E0,  0xF1E0 },
	{ 0xF1E1,  0xF1E1 },
	{ 0xF1E2,  0xF1E2 },
	{ 0xF1E3,  0xF1E3 },
	{ 0xF1E4,  0xF1E4 },
	{ 0xF1E5,  0xF1E5 },
	{ 0xF1E6,  0xF1E6 },
	{ 0xF1E7,  0xF1E7 },
	{ 0xF1E8,  0xF1E8 },
	{ 0xF1E9,  0xF1E9 },
	{ 0xF1EA,  0xF1EA },
	{ 0xF1EB,  0xF1EB },
	{ 0xF1EC,  0xF1EC },
	{ 0xF1ED,  0xF1ED },
	{ 0xF1EE,  0xF1EE },
	{ 0xF1EF,  0xF1EF },
	{ 0xF1F0,  0xF1F0 },
	{ 0xF1F1,  0xF1F1 },
	{ 0xF1F2,  0xF1F2 },
	{ 0xF1F3,  0xF1F3 },
	{ 0xF1F4,  0xF1F4 },
	{ 0xF1F5,  0xF1F5 },
	{ 0xF1F6,  0xF1F6 },
	{ 0xF1F7,  0xF1F7 },
	{ 0xF1F8,  0xF1F8 },
	{ 0xF1F9,  0xF1F9 },
	{ 0xF1FA,  0xF1FA },
	{ 0xF1FB,  0xF1FB },
	{ 0xF1FC,  0xF1FC },
	{ 0xF1FD,  0xF1FD },
	{ 0xF1FE,  0xF1FE },
	{ 0xF240,  0xF240 },
	{ 0xF241,  0xF241 },
	{ 0xF242,  0xF242 },
	{ 0xF243,  0xF243 },
	{ 0xF244,  0xF244 },
	{ 0xF245,  0xF245 },
	{ 0xF246,  0xF246 },
	{ 0xF247,  0xF247 },
	{ 0xF248,  0xF248 },
	{ 0xF249,  0xF249 },
	{ 0xF24A,  0xF24A },
	{ 0xF24B,  0xF24B },
	{ 0xF24C,  0xF24C },
	{ 0xF24D,  0xF24D },
	{ 0xF24E,  0xF24E },
	{ 0xF24F,  0xF24F },
	{ 0xF250,  0xF250 },
	{ 0xF251,  0xF251 },
	{ 0xF252,  0xF252 },
	{ 0xF253,  0xF253 },
	{ 0xF254,  0xF254 },
	{ 0xF255,  0xF255 },
	{ 0xF256,  0xF256 },
	{ 0xF257,  0xF257 },
	{ 0xF258,  0xF258 },
	{ 0xF259,  0xF259 },
	{ 0xF25A,  0xF25A },
	{ 0xF25B,  0xF25B },
	{ 0xF25C,  0xF25C },
	{ 0xF25D,  0xF25D },
	{ 0xF25E,  0xF25E },
	{ 0xF25F,  0xF25F },
	{ 0xF260,  0xF260 },
	{ 0xF261,  0xF261 },
	{ 0xF262,  0xF262 },
	{ 0xF263,  0xF263 },
	{ 0xF264,  0xF264 },
	{ 0xF265,  0xF265 },
	{ 0xF266,  0xF266 },
	{ 0xF267,  0xF267 },
	{ 0xF268,  0xF268 },
	{ 0xF269,  0xF269 },
	{ 0xF26A,  0xF26A },
	{ 0xF26B,  0xF26B },
	{ 0xF26C,  0xF26C },
	{ 0xF26D,  0xF26D },
	{ 0xF26E,  0xF26E },
	{ 0xF26F,  0xF26F },
	{ 0xF270,  0xF270 },
	{ 0xF271,  0xF271 },
	{ 0xF272,  0xF272 },
	{ 0xF273,  0xF273 },
	{ 0xF274,  0xF274 },
	{ 0xF275,  0xF275 },
	{ 0xF276,  0xF276 },
	{ 0xF277,  0xF277 },
	{ 0xF278,  0xF278 },
	{ 0xF279,  0xF279 },
	{ 0xF27A,  0xF27A },
	{ 0xF27B,  0xF27B },
	{ 0xF27C,  0xF27C },
	{ 0xF27D,  0xF27D },
	{ 0xF27E,  0xF27E },
	{ 0xF2A1,  0xF2A1 },
	{ 0xF2A2,  0xF2A2 },
	{ 0xF2A3,  0xF2A3 },
	{ 0xF2A4,  0xF2A4 },
	{ 0xF2A5,  0xF2A5 },
	{ 0xF2A6,  0xF2A6 },
	{ 0xF2A7,  0xF2A7 },
	{ 0xF2A8,  0xF2A8 },
	{ 0xF2A9,  0xF2A9 },
	{ 0xF2AA,  0xF2AA },
	{ 0xF2AB,  0xF2AB },
	{ 0xF2AC,  0xF2AC },
	{ 0xF2AD,  0xF2AD },
	{ 0xF2AE,  0xF2AE },
	{ 0xF2AF,  0xF2AF },
	{ 0xF2B0,  0xF2B0 },
	{ 0xF2B1,  0xF2B1 },
	{ 0xF2B2,  0xF2B2 },
	{ 0xF2B3,  0xF2B3 },
	{ 0xF2B4,  0xF2B4 },
	{ 0xF2B5,  0xF2B5 },
	{ 0xF2B6,  0xF2B6 },
	{ 0xF2B7,  0xF2B7 },
	{ 0xF2B8,  0xF2B8 },
	{ 0xF2B9,  0xF2B9 },
	{ 0xF2BA,  0xF2BA },
	{ 0xF2BB,  0xF2BB },
	{ 0xF2BC,  0xF2BC },
	{ 0xF2BD,  0xF2BD },
	{ 0xF2BE,  0xF2BE },
	{ 0xF2BF,  0xF2BF },
	{ 0xF2C0,  0xF2C0 },
	{ 0xF2C1,  0xF2C1 },
	{ 0xF2C2,  0xF2C2 },
	{ 0xF2C3,  0xF2C3 },
	{ 0xF2C4,  0xF2C4 },
	{ 0xF2C5,  0xF2C5 },
	{ 0xF2C6,  0xF2C6 },
	{ 0xF2C7,  0xF2C7 },
	{ 0xF2C8,  0xF2C8 },
	{ 0xF2C9,  0xF2C9 },
	{ 0xF2CA,  0xF2CA },
	{ 0xF2CB,  0xF2CB },
	{ 0xF2CC,  0xF2CC },
	{ 0xF2CD,  0xF2CD },
	{ 0xF2CE,  0xF2CE },
	{ 0xF2CF,  0xF2CF },
	{ 0xF2D0,  0xF2D0 },
	{ 0xF2D1,  0xF2D1 },
	{ 0xF2D2,  0xF2D2 },
	{ 0xF2D3,  0xF2D3 },
	{ 0xF2D4,  0xF2D4 },
	{ 0xF2D5,  0xF2D5 },
	{ 0xF2D6,  0xF2D6 },
	{ 0xF2D7,  0xF2D7 },
	{ 0xF2D8,  0xF2D8 },
	{ 0xF2D9,  0xF2D9 },
	{ 0xF2DA,  0xF2DA },
	{ 0xF2DB,  0xF2DB },
	{ 0xF2DC,  0xF2DC },
	{ 0xF2DD,  0xF2DD },
	{ 0xF2DE,  0xF2DE },
	{ 0xF2DF,  0xF2DF },
	{ 0xF2E0,  0xF2E0 },
	{ 0xF2E1,  0xF2E1 },
	{ 0xF2E2,  0xF2E2 },
	{ 0xF2E3,  0xF2E3 },
	{ 0xF2E4,  0xF2E4 },
	{ 0xF2E5,  0xF2E5 },
	{ 0xF2E6,  0xF2E6 },
	{ 0xF2E7,  0xF2E7 },
	{ 0xF2E8,  0xF2E8 },
	{ 0xF2E9,  0xF2E9 },
	{ 0xF2EA,  0xF2EA },
	{ 0xF2EB,  0xF2EB },
	{ 0xF2EC,  0xF2EC },
	{ 0xF2ED,  0xF2ED },
	{ 0xF2EE,  0xF2EE },
	{ 0xF2EF,  0xF2EF },
	{ 0xF2F0,  0xF2F0 },
	{ 0xF2F1,  0xF2F1 },
	{ 0xF2F2,  0xF2F2 },
	{ 0xF2F3,  0xF2F3 },
	{ 0xF2F4,  0xF2F4 },
	{ 0xF2F5,  0xF2F5 },
	{ 0xF2F6,  0xF2F6 },
	{ 0xF2F7,  0xF2F7 },
	{ 0xF2F8,  0xF2F8 },
	{ 0xF2F9,  0xF2F9 },
	{ 0xF2FA,  0xF2FA },
	{ 0xF2FB,  0xF2FB },
	{ 0xF2FC,  0xF2FC },
	{ 0xF2FD,  0xF2FD },
	{ 0xF2FE,  0xF2FE },
	{ 0xF340,  0xF340 },
	{ 0xF341,  0xF341 },
	{ 0xF342,  0xF342 },
	{ 0xF343,  0xF343 },
	{ 0xF344,  0xF344 },
	{ 0xF345,  0xF345 },
	{ 0xF346,  0xF346 },
	{ 0xF347,  0xF347 },
	{ 0xF348,  0xF348 },
	{ 0xF349,  0xF349 },
	{ 0xF34A,  0xF34A },
	{ 0xF34B,  0xF34B },
	{ 0xF34C,  0xF34C },
	{ 0xF34D,  0xF34D },
	{ 0xF34E,  0xF34E },
	{ 0xF34F,  0xF34F },
	{ 0xF350,  0xF350 },
	{ 0xF351,  0xF351 },
	{ 0xF352,  0xF352 },
	{ 0xF353,  0xF353 },
	{ 0xF354,  0xF354 },
	{ 0xF355,  0xF355 },
	{ 0xF356,  0xF356 },
	{ 0xF357,  0xF357 },
	{ 0xF358,  0xF358 },
	{ 0xF359,  0xF359 },
	{ 0xF35A,  0xF35A },
	{ 0xF35B,  0xF35B },
	{ 0xF35C,  0xF35C },
	{ 0xF35D,  0xF35D },
	{ 0xF35E,  0xF35E },
	{ 0xF35F,  0xF35F },
	{ 0xF360,  0xF360 },
	{ 0xF361,  0xF361 },
	{ 0xF362,  0xF362 },
	{ 0xF363,  0xF363 },
	{ 0xF364,  0xF364 },
	{ 0xF365,  0xF365 },
	{ 0xF366,  0xF366 },
	{ 0xF367,  0xF367 },
	{ 0xF368,  0xF368 },
	{ 0xF369,  0xF369 },
	{ 0xF36A,  0xF36A },
	{ 0xF36B,  0xF36B },
	{ 0xF36C,  0xF36C },
	{ 0xF36D,  0xF36D },
	{ 0xF36E,  0xF36E },
	{ 0xF36F,  0xF36F },
	{ 0xF370,  0xF370 },
	{ 0xF371,  0xF371 },
	{ 0xF372,  0xF372 },
	{ 0xF373,  0xF373 },
	{ 0xF374,  0xF374 },
	{ 0xF375,  0xF375 },
	{ 0xF376,  0xF376 },
	{ 0xF377,  0xF377 },
	{ 0xF378,  0xF378 },
	{ 0xF379,  0xF379 },
	{ 0xF37A,  0xF37A },
	{ 0xF37B,  0xF37B },
	{ 0xF37C,  0xF37C },
	{ 0xF37D,  0xF37D },
	{ 0xF37E,  0xF37E },
	{ 0xF3A1,  0xF3A1 },
	{ 0xF3A2,  0xF3A2 },
	{ 0xF3A3,  0xF3A3 },
	{ 0xF3A4,  0xF3A4 },
	{ 0xF3A5,  0xF3A5 },
	{ 0xF3A6,  0xF3A6 },
	{ 0xF3A7,  0xF3A7 },
	{ 0xF3A8,  0xF3A8 },
	{ 0xF3A9,  0xF3A9 },
	{ 0xF3AA,  0xF3AA },
	{ 0xF3AB,  0xF3AB },
	{ 0xF3AC,  0xF3AC },
	{ 0xF3AD,  0xF3AD },
	{ 0xF3AE,  0xF3AE },
	{ 0xF3AF,  0xF3AF },
	{ 0xF3B0,  0xF3B0 },
	{ 0xF3B1,  0xF3B1 },
	{ 0xF3B2,  0xF3B2 },
	{ 0xF3B3,  0xF3B3 },
	{ 0xF3B4,  0xF3B4 },
	{ 0xF3B5,  0xF3B5 },
	{ 0xF3B6,  0xF3B6 },
	{ 0xF3B7,  0xF3B7 },
	{ 0xF3B8,  0xF3B8 },
	{ 0xF3B9,  0xF3B9 },
	{ 0xF3BA,  0xF3BA },
	{ 0xF3BB,  0xF3BB },
	{ 0xF3BC,  0xF3BC },
	{ 0xF3BD,  0xF3BD },
	{ 0xF3BE,  0xF3BE },
	{ 0xF3BF,  0xF3BF },
	{ 0xF3C0,  0xF3C0 },
	{ 0xF3C1,  0xF3C1 },
	{ 0xF3C2,  0xF3C2 },
	{ 0xF3C3,  0xF3C3 },
	{ 0xF3C4,  0xF3C4 },
	{ 0xF3C5,  0xF3C5 },
	{ 0xF3C6,  0xF3C6 },
	{ 0xF3C7,  0xF3C7 },
	{ 0xF3C8,  0xF3C8 },
	{ 0xF3C9,  0xF3C9 },
	{ 0xF3CA,  0xF3CA },
	{ 0xF3CB,  0xF3CB },
	{ 0xF3CC,  0xF3CC },
	{ 0xF3CD,  0xF3CD },
	{ 0xF3CE,  0xF3CE },
	{ 0xF3CF,  0xF3CF },
	{ 0xF3D0,  0xF3D0 },
	{ 0xF3D1,  0xF3D1 },
	{ 0xF3D2,  0xF3D2 },
	{ 0xF3D3,  0xF3D3 },
	{ 0xF3D4,  0xF3D4 },
	{ 0xF3D5,  0xF3D5 },
	{ 0xF3D6,  0xF3D6 },
	{ 0xF3D7,  0xF3D7 },
	{ 0xF3D8,  0xF3D8 },
	{ 0xF3D9,  0xF3D9 },
	{ 0xF3DA,  0xF3DA },
	{ 0xF3DB,  0xF3DB },
	{ 0xF3DC,  0xF3DC },
	{ 0xF3DD,  0xF3DD },
	{ 0xF3DE,  0xF3DE },
	{ 0xF3DF,  0xF3DF },
	{ 0xF3E0,  0xF3E0 },
	{ 0xF3E1,  0xF3E1 },
	{ 0xF3E2,  0xF3E2 },
	{ 0xF3E3,  0xF3E3 },
	{ 0xF3E4,  0xF3E4 },
	{ 0xF3E5,  0xF3E5 },
	{ 0xF3E6,  0xF3E6 },
	{ 0xF3E7,  0xF3E7 },
	{ 0xF3E8,  0xF3E8 },
	{ 0xF3E9,  0xF3E9 },
	{ 0xF3EA,  0xF3EA },
	{ 0xF3EB,  0xF3EB },
	{ 0xF3EC,  0xF3EC },
	{ 0xF3ED,  0xF3ED },
	{ 0xF3EE,  0xF3EE },
	{ 0xF3EF,  0xF3EF },
	{ 0xF3F0,  0xF3F0 },
	{ 0xF3F1,  0xF3F1 },
	{ 0xF3F2,  0xF3F2 },
	{ 0xF3F3,  0xF3F3 },
	{ 0xF3F4,  0xF3F4 },
	{ 0xF3F5,  0xF3F5 },
	{ 0xF3F6,  0xF3F6 },
	{ 0xF3F7,  0xF3F7 },
	{ 0xF3F8,  0xF3F8 },
	{ 0xF3F9,  0xF3F9 },
	{ 0xF3FA,  0xF3FA },
	{ 0xF3FB,  0xF3FB },
	{ 0xF3FC,  0xF3FC },
	{ 0xF3FD,  0xF3FD },
	{ 0xF3FE,  0xF3FE },
	{ 0xF440,  0xF440 },
	{ 0xF441,  0xF441 },
	{ 0xF442,  0xF442 },
	{ 0xF443,  0xF443 },
	{ 0xF444,  0xF444 },
	{ 0xF445,  0xF445 },
	{ 0xF446,  0xF446 },
	{ 0xF447,  0xF447 },
	{ 0xF448,  0xF448 },
	{ 0xF449,  0xF449 },
	{ 0xF44A,  0xF44A },
	{ 0xF44B,  0xF44B },
	{ 0xF44C,  0xF44C },
	{ 0xF44D,  0xF44D },
	{ 0xF44E,  0xF44E },
	{ 0xF44F,  0xF44F },
	{ 0xF450,  0xF450 },
	{ 0xF451,  0xF451 },
	{ 0xF452,  0xF452 },
	{ 0xF453,  0xF453 },
	{ 0xF454,  0xF454 },
	{ 0xF455,  0xF455 },
	{ 0xF456,  0xF456 },
	{ 0xF457,  0xF457 },
	{ 0xF458,  0xF458 },
	{ 0xF459,  0xF459 },
	{ 0xF45A,  0xF45A },
	{ 0xF45B,  0xF45B },
	{ 0xF45C,  0xF45C },
	{ 0xF45D,  0xF45D },
	{ 0xF45E,  0xF45E },
	{ 0xF45F,  0xF45F },
	{ 0xF460,  0xF460 },
	{ 0xF461,  0xF461 },
	{ 0xF462,  0xF462 },
	{ 0xF463,  0xF463 },
	{ 0xF464,  0xF464 },
	{ 0xF465,  0xF465 },
	{ 0xF466,  0xF466 },
	{ 0xF467,  0xF467 },
	{ 0xF468,  0xF468 },
	{ 0xF469,  0xF469 },
	{ 0xF46A,  0xF46A },
	{ 0xF46B,  0xF46B },
	{ 0xF46C,  0xF46C },
	{ 0xF46D,  0xF46D },
	{ 0xF46E,  0xF46E },
	{ 0xF46F,  0xF46F },
	{ 0xF470,  0xF470 },
	{ 0xF471,  0xF471 },
	{ 0xF472,  0xF472 },
	{ 0xF473,  0xF473 },
	{ 0xF474,  0xF474 },
	{ 0xF475,  0xF475 },
	{ 0xF476,  0xF476 },
	{ 0xF477,  0xF477 },
	{ 0xF478,  0xF478 },
	{ 0xF479,  0xF479 },
	{ 0xF47A,  0xF47A },
	{ 0xF47B,  0xF47B },
	{ 0xF47C,  0xF47C },
	{ 0xF47D,  0xF47D },
	{ 0xF47E,  0xF47E },
	{ 0xF4A1,  0xF4A1 },
	{ 0xF4A2,  0xF4A2 },
	{ 0xF4A3,  0xF4A3 },
	{ 0xF4A4,  0xF4A4 },
	{ 0xF4A5,  0xF4A5 },
	{ 0xF4A6,  0xF4A6 },
	{ 0xF4A7,  0xF4A7 },
	{ 0xF4A8,  0xF4A8 },
	{ 0xF4A9,  0xF4A9 },
	{ 0xF4AA,  0xF4AA },
	{ 0xF4AB,  0xF4AB },
	{ 0xF4AC,  0xF4AC },
	{ 0xF4AD,  0xF4AD },
	{ 0xF4AE,  0xF4AE },
	{ 0xF4AF,  0xF4AF },
	{ 0xF4B0,  0xF4B0 },
	{ 0xF4B1,  0xF4B1 },
	{ 0xF4B2,  0xF4B2 },
	{ 0xF4B3,  0xF4B3 },
	{ 0xF4B4,  0xF4B4 },
	{ 0xF4B5,  0xF4B5 },
	{ 0xF4B6,  0xF4B6 },
	{ 0xF4B7,  0xF4B7 },
	{ 0xF4B8,  0xF4B8 },
	{ 0xF4B9,  0xF4B9 },
	{ 0xF4BA,  0xF4BA },
	{ 0xF4BB,  0xF4BB },
	{ 0xF4BC,  0xF4BC },
	{ 0xF4BD,  0xF4BD },
	{ 0xF4BE,  0xF4BE },
	{ 0xF4BF,  0xF4BF },
	{ 0xF4C0,  0xF4C0 },
	{ 0xF4C1,  0xF4C1 },
	{ 0xF4C2,  0xF4C2 },
	{ 0xF4C3,  0xF4C3 },
	{ 0xF4C4,  0xF4C4 },
	{ 0xF4C5,  0xF4C5 },
	{ 0xF4C6,  0xF4C6 },
	{ 0xF4C7,  0xF4C7 },
	{ 0xF4C8,  0xF4C8 },
	{ 0xF4C9,  0xF4C9 },
	{ 0xF4CA,  0xF4CA },
	{ 0xF4CB,  0xF4CB },
	{ 0xF4CC,  0xF4CC },
	{ 0xF4CD,  0xF4CD },
	{ 0xF4CE,  0xF4CE },
	{ 0xF4CF,  0xF4CF },
	{ 0xF4D0,  0xF4D0 },
	{ 0xF4D1,  0xF4D1 },
	{ 0xF4D2,  0xF4D2 },
	{ 0xF4D3,  0xF4D3 },
	{ 0xF4D4,  0xF4D4 },
	{ 0xF4D5,  0xF4D5 },
	{ 0xF4D6,  0xF4D6 },
	{ 0xF4D7,  0xF4D7 },
	{ 0xF4D8,  0xF4D8 },
	{ 0xF4D9,  0xF4D9 },
	{ 0xF4DA,  0xF4DA },
	{ 0xF4DB,  0xF4DB },
	{ 0xF4DC,  0xF4DC },
	{ 0xF4DD,  0xF4DD },
	{ 0xF4DE,  0xF4DE },
	{ 0xF4DF,  0xF4DF },
	{ 0xF4E0,  0xF4E0 },
	{ 0xF4E1,  0xF4E1 },
	{ 0xF4E2,  0xF4E2 },
	{ 0xF4E3,  0xF4E3 },
	{ 0xF4E4,  0xF4E4 },
	{ 0xF4E5,  0xF4E5 },
	{ 0xF4E6,  0xF4E6 },
	{ 0xF4E7,  0xF4E7 },
	{ 0xF4E8,  0xF4E8 },
	{ 0xF4E9,  0xF4E9 },
	{ 0xF4EA,  0xF4EA },
	{ 0xF4EB,  0xF4EB },
	{ 0xF4EC,  0xF4EC },
	{ 0xF4ED,  0xF4ED },
	{ 0xF4EE,  0xF4EE },
	{ 0xF4EF,  0xF4EF },
	{ 0xF4F0,  0xF4F0 },
	{ 0xF4F1,  0xF4F1 },
	{ 0xF4F2,  0xF4F2 },
	{ 0xF4F3,  0xF4F3 },
	{ 0xF4F4,  0xF4F4 },
	{ 0xF4F5,  0xF4F5 },
	{ 0xF4F6,  0xF4F6 },
	{ 0xF4F7,  0xF4F7 },
	{ 0xF4F8,  0xF4F8 },
	{ 0xF4F9,  0xF4F9 },
	{ 0xF4FA,  0xF4FA },
	{ 0xF4FB,  0xF4FB },
	{ 0xF4FC,  0xF4FC },
	{ 0xF4FD,  0xF4FD },
	{ 0xF4FE,  0xF4FE },
	{ 0xF540,  0xF540 },
	{ 0xF541,  0xF541 },
	{ 0xF542,  0xF542 },
	{ 0xF543,  0xF543 },
	{ 0xF544,  0xF544 },
	{ 0xF545,  0xF545 },
	{ 0xF546,  0xF546 },
	{ 0xF547,  0xF547 },
	{ 0xF548,  0xF548 },
	{ 0xF549,  0xF549 },
	{ 0xF54A,  0xF54A },
	{ 0xF54B,  0xF54B },
	{ 0xF54C,  0xF54C },
	{ 0xF54D,  0xF54D },
	{ 0xF54E,  0xF54E },
	{ 0xF54F,  0xF54F },
	{ 0xF550,  0xF550 },
	{ 0xF551,  0xF551 },
	{ 0xF552,  0xF552 },
	{ 0xF553,  0xF553 },
	{ 0xF554,  0xF554 },
	{ 0xF555,  0xF555 },
	{ 0xF556,  0xF556 },
	{ 0xF557,  0xF557 },
	{ 0xF558,  0xF558 },
	{ 0xF559,  0xF559 },
	{ 0xF55A,  0xF55A },
	{ 0xF55B,  0xF55B },
	{ 0xF55C,  0xF55C },
	{ 0xF55D,  0xF55D },
	{ 0xF55E,  0xF55E },
	{ 0xF55F,  0xF55F },
	{ 0xF560,  0xF560 },
	{ 0xF561,  0xF561 },
	{ 0xF562,  0xF562 },
	{ 0xF563,  0xF563 },
	{ 0xF564,  0xF564 },
	{ 0xF565,  0xF565 },
	{ 0xF566,  0xF566 },
	{ 0xF567,  0xF567 },
	{ 0xF568,  0xF568 },
	{ 0xF569,  0xF569 },
	{ 0xF56A,  0xF56A },
	{ 0xF56B,  0xF56B },
	{ 0xF56C,  0xF56C },
	{ 0xF56D,  0xF56D },
	{ 0xF56E,  0xF56E },
	{ 0xF56F,  0xF56F },
	{ 0xF570,  0xF570 },
	{ 0xF571,  0xF571 },
	{ 0xF572,  0xF572 },
	{ 0xF573,  0xF573 },
	{ 0xF574,  0xF574 },
	{ 0xF575,  0xF575 },
	{ 0xF576,  0xF576 },
	{ 0xF577,  0xF577 },
	{ 0xF578,  0xF578 },
	{ 0xF579,  0xF579 },
	{ 0xF57A,  0xF57A },
	{ 0xF57B,  0xF57B },
	{ 0xF57C,  0xF57C },
	{ 0xF57D,  0xF57D },
	{ 0xF57E,  0xF57E },
	{ 0xF5A1,  0xF5A1 },
	{ 0xF5A2,  0xF5A2 },
	{ 0xF5A3,  0xF5A3 },
	{ 0xF5A4,  0xF5A4 },
	{ 0xF5A5,  0xF5A5 },
	{ 0xF5A6,  0xF5A6 },
	{ 0xF5A7,  0xF5A7 },
	{ 0xF5A8,  0xF5A8 },
	{ 0xF5A9,  0xF5A9 },
	{ 0xF5AA,  0xF5AA },
	{ 0xF5AB,  0xF5AB },
	{ 0xF5AC,  0xF5AC },
	{ 0xF5AD,  0xF5AD },
	{ 0xF5AE,  0xF5AE },
	{ 0xF5AF,  0xF5AF },
	{ 0xF5B0,  0xF5B0 },
	{ 0xF5B1,  0xF5B1 },
	{ 0xF5B2,  0xF5B2 },
	{ 0xF5B3,  0xF5B3 },
	{ 0xF5B4,  0xF5B4 },
	{ 0xF5B5,  0xF5B5 },
	{ 0xF5B6,  0xF5B6 },
	{ 0xF5B7,  0xF5B7 },
	{ 0xF5B8,  0xF5B8 },
	{ 0xF5B9,  0xF5B9 },
	{ 0xF5BA,  0xF5BA },
	{ 0xF5BB,  0xF5BB },
	{ 0xF5BC,  0xF5BC },
	{ 0xF5BD,  0xF5BD },
	{ 0xF5BE,  0xF5BE },
	{ 0xF5BF,  0xF5BF },
	{ 0xF5C0,  0xF5C0 },
	{ 0xF5C1,  0xF5C1 },
	{ 0xF5C2,  0xF5C2 },
	{ 0xF5C3,  0xF5C3 },
	{ 0xF5C4,  0xF5C4 },
	{ 0xF5C5,  0xF5C5 },
	{ 0xF5C6,  0xF5C6 },
	{ 0xF5C7,  0xF5C7 },
	{ 0xF5C8,  0xF5C8 },
	{ 0xF5C9,  0xF5C9 },
	{ 0xF5CA,  0xF5CA },
	{ 0xF5CB,  0xF5CB },
	{ 0xF5CC,  0xF5CC },
	{ 0xF5CD,  0xF5CD },
	{ 0xF5CE,  0xF5CE },
	{ 0xF5CF,  0xF5CF },
	{ 0xF5D0,  0xF5D0 },
	{ 0xF5D1,  0xF5D1 },
	{ 0xF5D2,  0xF5D2 },
	{ 0xF5D3,  0xF5D3 },
	{ 0xF5D4,  0xF5D4 },
	{ 0xF5D5,  0xF5D5 },
	{ 0xF5D6,  0xF5D6 },
	{ 0xF5D7,  0xF5D7 },
	{ 0xF5D8,  0xF5D8 },
	{ 0xF5D9,  0xF5D9 },
	{ 0xF5DA,  0xF5DA },
	{ 0xF5DB,  0xF5DB },
	{ 0xF5DC,  0xF5DC },
	{ 0xF5DD,  0xF5DD },
	{ 0xF5DE,  0xF5DE },
	{ 0xF5DF,  0xF5DF },
	{ 0xF5E0,  0xF5E0 },
	{ 0xF5E1,  0xF5E1 },
	{ 0xF5E2,  0xF5E2 },
	{ 0xF5E3,  0xF5E3 },
	{ 0xF5E4,  0xF5E4 },
	{ 0xF5E5,  0xF5E5 },
	{ 0xF5E6,  0xF5E6 },
	{ 0xF5E7,  0xF5E7 },
	{ 0xF5E8,  0xF5E8 },
	{ 0xF5E9,  0xF5E9 },
	{ 0xF5EA,  0xF5EA },
	{ 0xF5EB,  0xF5EB },
	{ 0xF5EC,  0xF5EC },
	{ 0xF5ED,  0xF5ED },
	{ 0xF5EE,  0xF5EE },
	{ 0xF5EF,  0xF5EF },
	{ 0xF5F0,  0xF5F0 },
	{ 0xF5F1,  0xF5F1 },
	{ 0xF5F2,  0xF5F2 },
	{ 0xF5F3,  0xF5F3 },
	{ 0xF5F4,  0xF5F4 },
	{ 0xF5F5,  0xF5F5 },
	{ 0xF5F6,  0xF5F6 },
	{ 0xF5F7,  0xF5F7 },
	{ 0xF5F8,  0xF5F8 },
	{ 0xF5F9,  0xF5F9 },
	{ 0xF5FA,  0xF5FA },
	{ 0xF5FB,  0xF5FB },
	{ 0xF5FC,  0xF5FC },
	{ 0xF5FD,  0xF5FD },
	{ 0xF5FE,  0xF5FE },
	{ 0xF640,  0xF640 },
	{ 0xF641,  0xF641 },
	{ 0xF642,  0xF642 },
	{ 0xF643,  0xF643 },
	{ 0xF644,  0xF644 },
	{ 0xF645,  0xF645 },
	{ 0xF646,  0xF646 },
	{ 0xF647,  0xF647 },
	{ 0xF648,  0xF648 },
	{ 0xF649,  0xF649 },
	{ 0xF64A,  0xF64A },
	{ 0xF64B,  0xF64B },
	{ 0xF64C,  0xF64C },
	{ 0xF64D,  0xF64D },
	{ 0xF64E,  0xF64E },
	{ 0xF64F,  0xF64F },
	{ 0xF650,  0xF650 },
	{ 0xF651,  0xF651 },
	{ 0xF652,  0xF652 },
	{ 0xF653,  0xF653 },
	{ 0xF654,  0xF654 },
	{ 0xF655,  0xF655 },
	{ 0xF656,  0xF656 },
	{ 0xF657,  0xF657 },
	{ 0xF658,  0xF658 },
	{ 0xF659,  0xF659 },
	{ 0xF65A,  0xF65A },
	{ 0xF65B,  0xF65B },
	{ 0xF65C,  0xF65C },
	{ 0xF65D,  0xF65D },
	{ 0xF65E,  0xF65E },
	{ 0xF65F,  0xF65F },
	{ 0xF660,  0xF660 },
	{ 0xF661,  0xF661 },
	{ 0xF662,  0xF662 },
	{ 0xF663,  0xF663 },
	{ 0xF664,  0xF664 },
	{ 0xF665,  0xF665 },
	{ 0xF666,  0xF666 },
	{ 0xF667,  0xF667 },
	{ 0xF668,  0xF668 },
	{ 0xF669,  0xF669 },
	{ 0xF66A,  0xF66A },
	{ 0xF66B,  0xF66B },
	{ 0xF66C,  0xF66C },
	{ 0xF66D,  0xF66D },
	{ 0xF66E,  0xF66E },
	{ 0xF66F,  0xF66F },
	{ 0xF670,  0xF670 },
	{ 0xF671,  0xF671 },
	{ 0xF672,  0xF672 },
	{ 0xF673,  0xF673 },
	{ 0xF674,  0xF674 },
	{ 0xF675,  0xF675 },
	{ 0xF676,  0xF676 },
	{ 0xF677,  0xF677 },
	{ 0xF678,  0xF678 },
	{ 0xF679,  0xF679 },
	{ 0xF67A,  0xF67A },
	{ 0xF67B,  0xF67B },
	{ 0xF67C,  0xF67C },
	{ 0xF67D,  0xF67D },
	{ 0xF67E,  0xF67E },
	{ 0xF6A1,  0xF6A1 },
	{ 0xF6A2,  0xF6A2 },
	{ 0xF6A3,  0xF6A3 },
	{ 0xF6A4,  0xF6A4 },
	{ 0xF6A5,  0xF6A5 },
	{ 0xF6A6,  0xF6A6 },
	{ 0xF6A7,  0xF6A7 },
	{ 0xF6A8,  0xF6A8 },
	{ 0xF6A9,  0xF6A9 },
	{ 0xF6AA,  0xF6AA },
	{ 0xF6AB,  0xF6AB },
	{ 0xF6AC,  0xF6AC },
	{ 0xF6AD,  0xF6AD },
	{ 0xF6AE,  0xF6AE },
	{ 0xF6AF,  0xF6AF },
	{ 0xF6B0,  0xF6B0 },
	{ 0xF6B1,  0xF6B1 },
	{ 0xF6B2,  0xF6B2 },
	{ 0xF6B3,  0xF6B3 },
	{ 0xF6B4,  0xF6B4 },
	{ 0xF6B5,  0xF6B5 },
	{ 0xF6B6,  0xF6B6 },
	{ 0xF6B7,  0xF6B7 },
	{ 0xF6B8,  0xF6B8 },
	{ 0xF6B9,  0xF6B9 },
	{ 0xF6BA,  0xF6BA },
	{ 0xF6BB,  0xF6BB },
	{ 0xF6BC,  0xF6BC },
	{ 0xF6BD,  0xF6BD },
	{ 0xF6BE,  0xF6BE },
	{ 0xF6BF,  0xF6BF },
	{ 0xF6C0,  0xF6C0 },
	{ 0xF6C1,  0xF6C1 },
	{ 0xF6C2,  0xF6C2 },
	{ 0xF6C3,  0xF6C3 },
	{ 0xF6C4,  0xF6C4 },
	{ 0xF6C5,  0xF6C5 },
	{ 0xF6C6,  0xF6C6 },
	{ 0xF6C7,  0xF6C7 },
	{ 0xF6C8,  0xF6C8 },
	{ 0xF6C9,  0xF6C9 },
	{ 0xF6CA,  0xF6CA },
	{ 0xF6CB,  0xF6CB },
	{ 0xF6CC,  0xF6CC },
	{ 0xF6CD,  0xF6CD },
	{ 0xF6CE,  0xF6CE },
	{ 0xF6CF,  0xF6CF },
	{ 0xF6D0,  0xF6D0 },
	{ 0xF6D1,  0xF6D1 },
	{ 0xF6D2,  0xF6D2 },
	{ 0xF6D3,  0xF6D3 },
	{ 0xF6D4,  0xF6D4 },
	{ 0xF6D5,  0xF6D5 },
	{ 0xF6D6,  0xF6D6 },
	{ 0xF6D7,  0xF6D7 },
	{ 0xF6D8,  0xF6D8 },
	{ 0xF6D9,  0xF6D9 },
	{ 0xF6DA,  0xF6DA },
	{ 0xF6DB,  0xF6DB },
	{ 0xF6DC,  0xF6DC },
	{ 0xF6DD,  0xF6DD },
	{ 0xF6DE,  0xF6DE },
	{ 0xF6DF,  0xF6DF },
	{ 0xF6E0,  0xF6E0 },
	{ 0xF6E1,  0xF6E1 },
	{ 0xF6E2,  0xF6E2 },
	{ 0xF6E3,  0xF6E3 },
	{ 0xF6E4,  0xF6E4 },
	{ 0xF6E5,  0xF6E5 },
	{ 0xF6E6,  0xF6E6 },
	{ 0xF6E7,  0xF6E7 },
	{ 0xF6E8,  0xF6E8 },
	{ 0xF6E9,  0xF6E9 },
	{ 0xF6EA,  0xF6EA },
	{ 0xF6EB,  0xF6EB },
	{ 0xF6EC,  0xF6EC },
	{ 0xF6ED,  0xF6ED },
	{ 0xF6EE,  0xF6EE },
	{ 0xF6EF,  0xF6EF },
	{ 0xF6F0,  0xF6F0 },
	{ 0xF6F1,  0xF6F1 },
	{ 0xF6F2,  0xF6F2 },
	{ 0xF6F3,  0xF6F3 },
	{ 0xF6F4,  0xF6F4 },
	{ 0xF6F5,  0xF6F5 },
	{ 0xF6F6,  0xF6F6 },
	{ 0xF6F7,  0xF6F7 },
	{ 0xF6F8,  0xF6F8 },
	{ 0xF6F9,  0xF6F9 },
	{ 0xF6FA,  0xF6FA },
	{ 0xF6FB,  0xF6FB },
	{ 0xF6FC,  0xF6FC },
	{ 0xF6FD,  0xF6FD },
	{ 0xF6FE,  0xF6FE },
	{ 0xF740,  0xF740 },
	{ 0xF741,  0xF741 },
	{ 0xF742,  0xF742 },
	{ 0xF743,  0xF743 },
	{ 0xF744,  0xF744 },
	{ 0xF745,  0xF745 },
	{ 0xF746,  0xF746 },
	{ 0xF747,  0xF747 },
	{ 0xF748,  0xF748 },
	{ 0xF749,  0xF749 },
	{ 0xF74A,  0xF74A },
	{ 0xF74B,  0xF74B },
	{ 0xF74C,  0xF74C },
	{ 0xF74D,  0xF74D },
	{ 0xF74E,  0xF74E },
	{ 0xF74F,  0xF74F },
	{ 0xF750,  0xF750 },
	{ 0xF751,  0xF751 },
	{ 0xF752,  0xF752 },
	{ 0xF753,  0xF753 },
	{ 0xF754,  0xF754 },
	{ 0xF755,  0xF755 },
	{ 0xF756,  0xF756 },
	{ 0xF757,  0xF757 },
	{ 0xF758,  0xF758 },
	{ 0xF759,  0xF759 },
	{ 0xF75A,  0xF75A },
	{ 0xF75B,  0xF75B },
	{ 0xF75C,  0xF75C },
	{ 0xF75D,  0xF75D },
	{ 0xF75E,  0xF75E },
	{ 0xF75F,  0xF75F },
	{ 0xF760,  0xF760 },
	{ 0xF761,  0xF761 },
	{ 0xF762,  0xF762 },
	{ 0xF763,  0xF763 },
	{ 0xF764,  0xF764 },
	{ 0xF765,  0xF765 },
	{ 0xF766,  0xF766 },
	{ 0xF767,  0xF767 },
	{ 0xF768,  0xF768 },
	{ 0xF769,  0xF769 },
	{ 0xF76A,  0xF76A },
	{ 0xF76B,  0xF76B },
	{ 0xF76C,  0xF76C },
	{ 0xF76D,  0xF76D },
	{ 0xF76E,  0xF76E },
	{ 0xF76F,  0xF76F },
	{ 0xF770,  0xF770 },
	{ 0xF771,  0xF771 },
	{ 0xF772,  0xF772 },
	{ 0xF773,  0xF773 },
	{ 0xF774,  0xF774 },
	{ 0xF775,  0xF775 },
	{ 0xF776,  0xF776 },
	{ 0xF777,  0xF777 },
	{ 0xF778,  0xF778 },
	{ 0xF779,  0xF779 },
	{ 0xF77A,  0xF77A },
	{ 0xF77B,  0xF77B },
	{ 0xF77C,  0xF77C },
	{ 0xF77D,  0xF77D },
	{ 0xF77E,  0xF77E },
	{ 0xF7A1,  0xF7A1 },
	{ 0xF7A2,  0xF7A2 },
	{ 0xF7A3,  0xF7A3 },
	{ 0xF7A4,  0xF7A4 },
	{ 0xF7A5,  0xF7A5 },
	{ 0xF7A6,  0xF7A6 },
	{ 0xF7A7,  0xF7A7 },
	{ 0xF7A8,  0xF7A8 },
	{ 0xF7A9,  0xF7A9 },
	{ 0xF7AA,  0xF7AA },
	{ 0xF7AB,  0xF7AB },
	{ 0xF7AC,  0xF7AC },
	{ 0xF7AD,  0xF7AD },
	{ 0xF7AE,  0xF7AE },
	{ 0xF7AF,  0xF7AF },
	{ 0xF7B0,  0xF7B0 },
	{ 0xF7B1,  0xF7B1 },
	{ 0xF7B2,  0xF7B2 },
	{ 0xF7B3,  0xF7B3 },
	{ 0xF7B4,  0xF7B4 },
	{ 0xF7B5,  0xF7B5 },
	{ 0xF7B6,  0xF7B6 },
	{ 0xF7B7,  0xF7B7 },
	{ 0xF7B8,  0xF7B8 },
	{ 0xF7B9,  0xF7B9 },
	{ 0xF7BA,  0xF7BA },
	{ 0xF7BB,  0xF7BB },
	{ 0xF7BC,  0xF7BC },
	{ 0xF7BD,  0xF7BD },
	{ 0xF7BE,  0xF7BE },
	{ 0xF7BF,  0xF7BF },
	{ 0xF7C0,  0xF7C0 },
	{ 0xF7C1,  0xF7C1 },
	{ 0xF7C2,  0xF7C2 },
	{ 0xF7C3,  0xF7C3 },
	{ 0xF7C4,  0xF7C4 },
	{ 0xF7C5,  0xF7C5 },
	{ 0xF7C6,  0xF7C6 },
	{ 0xF7C7,  0xF7C7 },
	{ 0xF7C8,  0xF7C8 },
	{ 0xF7C9,  0xF7C9 },
	{ 0xF7CA,  0xF7CA },
	{ 0xF7CB,  0xF7CB },
	{ 0xF7CC,  0xF7CC },
	{ 0xF7CD,  0xF7CD },
	{ 0xF7CE,  0xF7CE },
	{ 0xF7CF,  0xF7CF },
	{ 0xF7D0,  0xF7D0 },
	{ 0xF7D1,  0xF7D1 },
	{ 0xF7D2,  0xF7D2 },
	{ 0xF7D3,  0xF7D3 },
	{ 0xF7D4,  0xF7D4 },
	{ 0xF7D5,  0xF7D5 },
	{ 0xF7D6,  0xF7D6 },
	{ 0xF7D7,  0xF7D7 },
	{ 0xF7D8,  0xF7D8 },
	{ 0xF7D9,  0xF7D9 },
	{ 0xF7DA,  0xF7DA },
	{ 0xF7DB,  0xF7DB },
	{ 0xF7DC,  0xF7DC },
	{ 0xF7DD,  0xF7DD },
	{ 0xF7DE,  0xF7DE },
	{ 0xF7DF,  0xF7DF },
	{ 0xF7E0,  0xF7E0 },
	{ 0xF7E1,  0xF7E1 },
	{ 0xF7E2,  0xF7E2 },
	{ 0xF7E3,  0xF7E3 },
	{ 0xF7E4,  0xF7E4 },
	{ 0xF7E5,  0xF7E5 },
	{ 0xF7E6,  0xF7E6 },
	{ 0xF7E7,  0xF7E7 },
	{ 0xF7E8,  0xF7E8 },
	{ 0xF7E9,  0xF7E9 },
	{ 0xF7EA,  0xF7EA },
	{ 0xF7EB,  0xF7EB },
	{ 0xF7EC,  0xF7EC },
	{ 0xF7ED,  0xF7ED },
	{ 0xF7EE,  0xF7EE },
	{ 0xF7EF,  0xF7EF },
	{ 0xF7F0,  0xF7F0 },
	{ 0xF7F1,  0xF7F1 },
	{ 0xF7F2,  0xF7F2 },
	{ 0xF7F3,  0xF7F3 },
	{ 0xF7F4,  0xF7F4 },
	{ 0xF7F5,  0xF7F5 },
	{ 0xF7F6,  0xF7F6 },
	{ 0xF7F7,  0xF7F7 },
	{ 0xF7F8,  0xF7F8 },
	{ 0xF7F9,  0xF7F9 },
	{ 0xF7FA,  0xF7FA },
	{ 0xF7FB,  0xF7FB },
	{ 0xF7FC,  0xF7FC },
	{ 0xF7FD,  0xF7FD },
	{ 0xF7FE,  0xF7FE },
	{ 0xF840,  0xF840 },
	{ 0xF841,  0xF841 },
	{ 0xF842,  0xF842 },
	{ 0xF843,  0xF843 },
	{ 0xF844,  0xF844 },
	{ 0xF845,  0xF845 },
	{ 0xF846,  0xF846 },
	{ 0xF847,  0xF847 },
	{ 0xF848,  0xF848 },
	{ 0xF849,  0xF849 },
	{ 0xF84A,  0xF84A },
	{ 0xF84B,  0xF84B },
	{ 0xF84C,  0xF84C },
	{ 0xF84D,  0xF84D },
	{ 0xF84E,  0xF84E },
	{ 0xF84F,  0xF84F },
	{ 0xF850,  0xF850 },
	{ 0xF851,  0xF851 },
	{ 0xF852,  0xF852 },
	{ 0xF853,  0xF853 },
	{ 0xF854,  0xF854 },
	{ 0xF855,  0xF855 },
	{ 0xF856,  0xF856 },
	{ 0xF857,  0xF857 },
	{ 0xF858,  0xF858 },
	{ 0xF859,  0xF859 },
	{ 0xF85A,  0xF85A },
	{ 0xF85B,  0xF85B },
	{ 0xF85C,  0xF85C },
	{ 0xF85D,  0xF85D },
	{ 0xF85E,  0xF85E },
	{ 0xF85F,  0xF85F },
	{ 0xF860,  0xF860 },
	{ 0xF861,  0xF861 },
	{ 0xF862,  0xF862 },
	{ 0xF863,  0xF863 },
	{ 0xF864,  0xF864 },
	{ 0xF865,  0xF865 },
	{ 0xF866,  0xF866 },
	{ 0xF867,  0xF867 },
	{ 0xF868,  0xF868 },
	{ 0xF869,  0xF869 },
	{ 0xF86A,  0xF86A },
	{ 0xF86B,  0xF86B },
	{ 0xF86C,  0xF86C },
	{ 0xF86D,  0xF86D },
	{ 0xF86E,  0xF86E },
	{ 0xF86F,  0xF86F },
	{ 0xF870,  0xF870 },
	{ 0xF871,  0xF871 },
	{ 0xF872,  0xF872 },
	{ 0xF873,  0xF873 },
	{ 0xF874,  0xF874 },
	{ 0xF875,  0xF875 },
	{ 0xF876,  0xF876 },
	{ 0xF877,  0xF877 },
	{ 0xF878,  0xF878 },
	{ 0xF879,  0xF879 },
	{ 0xF87A,  0xF87A },
	{ 0xF87B,  0xF87B },
	{ 0xF87C,  0xF87C },
	{ 0xF87D,  0xF87D },
	{ 0xF87E,  0xF87E },
	{ 0xF8A1,  0xF8A1 },
	{ 0xF8A2,  0xF8A2 },
	{ 0xF8A3,  0xF8A3 },
	{ 0xF8A4,  0xF8A4 },
	{ 0xF8A5,  0xF8A5 },
	{ 0xF8A6,  0xF8A6 },
	{ 0xF8A7,  0xF8A7 },
	{ 0xF8A8,  0xF8A8 },
	{ 0xF8A9,  0xF8A9 },
	{ 0xF8AA,  0xF8AA },
	{ 0xF8AB,  0xF8AB },
	{ 0xF8AC,  0xF8AC },
	{ 0xF8AD,  0xF8AD },
	{ 0xF8AE,  0xF8AE },
	{ 0xF8AF,  0xF8AF },
	{ 0xF8B0,  0xF8B0 },
	{ 0xF8B1,  0xF8B1 },
	{ 0xF8B2,  0xF8B2 },
	{ 0xF8B3,  0xF8B3 },
	{ 0xF8B4,  0xF8B4 },
	{ 0xF8B5,  0xF8B5 },
	{ 0xF8B6,  0xF8B6 },
	{ 0xF8B7,  0xF8B7 },
	{ 0xF8B8,  0xF8B8 },
	{ 0xF8B9,  0xF8B9 },
	{ 0xF8BA,  0xF8BA },
	{ 0xF8BB,  0xF8BB },
	{ 0xF8BC,  0xF8BC },
	{ 0xF8BD,  0xF8BD },
	{ 0xF8BE,  0xF8BE },
	{ 0xF8BF,  0xF8BF },
	{ 0xF8C0,  0xF8C0 },
	{ 0xF8C1,  0xF8C1 },
	{ 0xF8C2,  0xF8C2 },
	{ 0xF8C3,  0xF8C3 },
	{ 0xF8C4,  0xF8C4 },
	{ 0xF8C5,  0xF8C5 },
	{ 0xF8C6,  0xF8C6 },
	{ 0xF8C7,  0xF8C7 },
	{ 0xF8C8,  0xF8C8 },
	{ 0xF8C9,  0xF8C9 },
	{ 0xF8CA,  0xF8CA },
	{ 0xF8CB,  0xF8CB },
	{ 0xF8CC,  0xF8CC },
	{ 0xF8CD,  0xF8CD },
	{ 0xF8CE,  0xF8CE },
	{ 0xF8CF,  0xF8CF },
	{ 0xF8D0,  0xF8D0 },
	{ 0xF8D1,  0xF8D1 },
	{ 0xF8D2,  0xF8D2 },
	{ 0xF8D3,  0xF8D3 },
	{ 0xF8D4,  0xF8D4 },
	{ 0xF8D5,  0xF8D5 },
	{ 0xF8D6,  0xF8D6 },
	{ 0xF8D7,  0xF8D7 },
	{ 0xF8D8,  0xF8D8 },
	{ 0xF8D9,  0xF8D9 },
	{ 0xF8DA,  0xF8DA },
	{ 0xF8DB,  0xF8DB },
	{ 0xF8DC,  0xF8DC },
	{ 0xF8DD,  0xF8DD },
	{ 0xF8DE,  0xF8DE },
	{ 0xF8DF,  0xF8DF },
	{ 0xF8E0,  0xF8E0 },
	{ 0xF8E1,  0xF8E1 },
	{ 0xF8E2,  0xF8E2 },
	{ 0xF8E3,  0xF8E3 },
	{ 0xF8E4,  0xF8E4 },
	{ 0xF8E5,  0xF8E5 },
	{ 0xF8E6,  0xF8E6 },
	{ 0xF8E7,  0xF8E7 },
	{ 0xF8E8,  0xF8E8 },
	{ 0xF8E9,  0xF8E9 },
	{ 0xF8EA,  0xF8EA },
	{ 0xF8EB,  0xF8EB },
	{ 0xF8EC,  0xF8EC },
	{ 0xF8ED,  0xF8ED },
	{ 0xF8EE,  0xF8EE },
	{ 0xF8EF,  0xF8EF },
	{ 0xF8F0,  0xF8F0 },
	{ 0xF8F1,  0xF8F1 },
	{ 0xF8F2,  0xF8F2 },
	{ 0xF8F3,  0xF8F3 },
	{ 0xF8F4,  0xF8F4 },
	{ 0xF8F5,  0xF8F5 },
	{ 0xF8F6,  0xF8F6 },
	{ 0xF8F7,  0xF8F7 },
	{ 0xF8F8,  0xF8F8 },
	{ 0xF8F9,  0xF8F9 },
	{ 0xF8FA,  0xF8FA },
	{ 0xF8FB,  0xF8FB },
	{ 0xF8FC,  0xF8FC },
	{ 0xF8FD,  0xF8FD },
	{ 0xF8FE,  0xF8FE },
	{ 0xF940,  0xF940 },
	{ 0xF941,  0xF941 },
	{ 0xF942,  0xF942 },
	{ 0xF943,  0xF943 },
	{ 0xF944,  0xF944 },
	{ 0xF945,  0xF945 },
	{ 0xF946,  0xF946 },
	{ 0xF947,  0xF947 },
	{ 0xF948,  0xF948 },
	{ 0xF949,  0xF949 },
	{ 0xF94A,  0xF94A },
	{ 0xF94B,  0xF94B },
	{ 0xF94C,  0xF94C },
	{ 0xF94D,  0xF94D },
	{ 0xF94E,  0xF94E },
	{ 0xF94F,  0xF94F },
	{ 0xF950,  0xF950 },
	{ 0xF951,  0xF951 },
	{ 0xF952,  0xF952 },
	{ 0xF953,  0xF953 },
	{ 0xF954,  0xF954 },
	{ 0xF955,  0xF955 },
	{ 0xF956,  0xF956 },
	{ 0xF957,  0xF957 },
	{ 0xF958,  0xF958 },
	{ 0xF959,  0xF959 },
	{ 0xF95A,  0xF95A },
	{ 0xF95B,  0xF95B },
	{ 0xF95C,  0xF95C },
	{ 0xF95D,  0xF95D },
	{ 0xF95E,  0xF95E },
	{ 0xF95F,  0xF95F },
	{ 0xF960,  0xF960 },
	{ 0xF961,  0xF961 },
	{ 0xF962,  0xF962 },
	{ 0xF963,  0xF963 },
	{ 0xF964,  0xF964 },
	{ 0xF965,  0xF965 },
	{ 0xF966,  0xF966 },
	{ 0xF967,  0xF967 },
	{ 0xF968,  0xF968 },
	{ 0xF969,  0xF969 },
	{ 0xF96A,  0xF96A },
	{ 0xF96B,  0xF96B },
	{ 0xF96C,  0xF96C },
	{ 0xF96D,  0xF96D },
	{ 0xF96E,  0xF96E },
	{ 0xF96F,  0xF96F },
	{ 0xF970,  0xF970 },
	{ 0xF971,  0xF971 },
	{ 0xF972,  0xF972 },
	{ 0xF973,  0xF973 },
	{ 0xF974,  0xF974 },
	{ 0xF975,  0xF975 },
	{ 0xF976,  0xF976 },
	{ 0xF977,  0xF977 },
	{ 0xF978,  0xF978 },
	{ 0xF979,  0xF979 },
	{ 0xF97A,  0xF97A },
	{ 0xF97B,  0xF97B },
	{ 0xF97C,  0xF97C },
	{ 0xF97D,  0xF97D },
	{ 0xF97E,  0xF97E },
	{ 0xF9A1,  0xF9A1 },
	{ 0xF9A2,  0xF9A2 },
	{ 0xF9A3,  0xF9A3 },
	{ 0xF9A4,  0xF9A4 },
	{ 0xF9A5,  0xF9A5 },
	{ 0xF9A6,  0xF9A6 },
	{ 0xF9A7,  0xF9A7 },
	{ 0xF9A8,  0xF9A8 },
	{ 0xF9A9,  0xF9A9 },
	{ 0xF9AA,  0xF9AA },
	{ 0xF9AB,  0xF9AB },
	{ 0xF9AC,  0xF9AC },
	{ 0xF9AD,  0xF9AD },
	{ 0xF9AE,  0xF9AE },
	{ 0xF9AF,  0xF9AF },
	{ 0xF9B0,  0xF9B0 },
	{ 0xF9B1,  0xF9B1 },
	{ 0xF9B2,  0xF9B2 },
	{ 0xF9B3,  0xF9B3 },
	{ 0xF9B4,  0xF9B4 },
	{ 0xF9B5,  0xF9B5 },
	{ 0xF9B6,  0xF9B6 },
	{ 0xF9B7,  0xF9B7 },
	{ 0xF9B8,  0xF9B8 },
	{ 0xF9B9,  0xF9B9 },
	{ 0xF9BA,  0xF9BA },
	{ 0xF9BB,  0xF9BB },
	{ 0xF9BC,  0xF9BC },
	{ 0xF9BD,  0xF9BD },
	{ 0xF9BE,  0xF9BE },
	{ 0xF9BF,  0xF9BF },
	{ 0xF9C0,  0xF9C0 },
	{ 0xF9C1,  0xF9C1 },
	{ 0xF9C2,  0xF9C2 },
	{ 0xF9C3,  0xF9C3 },
	{ 0xF9C4,  0xF9C4 },
	{ 0xF9C5,  0xF9C5 },
	{ 0xF9C6,  0xF9C6 },
	{ 0xF9C7,  0xF9C7 },
	{ 0xF9C8,  0xF9C8 },
	{ 0xF9C9,  0xF9C9 },
	{ 0xF9CA,  0xF9CA },
	{ 0xF9CB,  0xF9CB },
	{ 0xF9CC,  0xF9CC },
	{ 0xF9CD,  0xF9CD },
	{ 0xF9CE,  0xF9CE },
	{ 0xF9CF,  0xF9CF },
	{ 0xF9D0,  0xF9D0 },
	{ 0xF9D1,  0xF9D1 },
	{ 0xF9D2,  0xF9D2 },
	{ 0xF9D3,  0xF9D3 },
	{ 0xF9D4,  0xF9D4 },
	{ 0xF9D5,  0xF9D5 },
	{ 0xF9D6,  0xF9D6 },
	{ 0xF9D7,  0xF9D7 },
	{ 0xF9D8,  0xF9D8 },
	{ 0xF9D9,  0xF9D9 },
	{ 0xF9DA,  0xF9DA },
	{ 0xF9DB,  0xF9DB },
	{ 0xF9DC,  0xF9DC },
	{ 0xF9DD,  0xF9DD },
	{ 0xF9DD,  0xF9FA },
	{ 0xF9DE,  0xF9DE },
	{ 0xF9DF,  0xF9DF },
	{ 0xF9DF,  0xF9FB },
	{ 0xF9E0,  0xF9E0 },
	{ 0xF9E1,  0xF9E1 },
	{ 0xF9E2,  0xF9E2 },
	{ 0xF9E3,  0xF9E3 },
	{ 0xF9E3,  0xF9FC },
	{ 0xF9E4,  0xF9E4 },
	{ 0xF9E5,  0xF9E5 },
	{ 0xF9E5,  0xF9FD },
	{ 0xF9E6,  0xF9E6 },
	{ 0xF9E7,  0xF9E7 },
	{ 0xF9E8,  0xF9E8 },
	{ 0xF9E9,  0xF9E9 },
	{ 0xF9EA,  0xF9EA },
	{ 0xF9EB,  0xF9EB },
	{ 0xF9EC,  0xF9EC },
	{ 0xF9ED,  0xF9ED },
	{ 0xF9EE,  0xF9EE },
	{ 0xF9EF,  0xF9EF },
	{ 0xF9F0,  0xF9F0 },
	{ 0xF9F1,  0xF9F1 },
	{ 0xF9F2,  0xF9F2 },
	{ 0xF9F3,  0xF9F3 },
	{ 0xF9F4,  0xF9F4 },
	{ 0xF9F5,  0xF9F5 },
	{ 0xF9F6,  0xF9F6 },
	{ 0xF9F7,  0xF9F7 },
	{ 0xF9F8,  0xF9F8 },
	{ 0xF9F9,  0xF9F9 },
	{ 0xF9FA,  0xA27E },
	{ 0xF9FB,  0xA2A1 },
	{ 0xF9FC,  0xA2A2 },
	{ 0xF9FD,  0xA2A3 },
	{ 0xFA41,  0xD59C },
	{ 0xFA44,  0xDA9C },
	{ 0xFA46,  0x8FFB },
	{ 0xFA47,  0x8793 },
	{ 0xFA4B,  0xA0B9 },
	{ 0xFA4D,  0x9B85 },
	{ 0xFA4F,  0x9FC5 },
	{ 0xFA50,  0x8B85 },
	{ 0xFA51,  0x9090 },
	{ 0xFA57,  0x8EA2 },
	{ 0xFA59,  0x9C8D },
	{ 0xFA61,  0xC86D },
	{ 0xFA64,  0xBE8F },
	{ 0xFA67,  0xCD9A },
	{ 0xFA69,  0xCD96 },
	{ 0xFA6A,  0xF38F },
	{ 0xFA6C,  0xB889 },
	{ 0xFA6F,  0xAF99 },
	{ 0xFA71,  0x948A },
	{ 0xFA79,  0x838C },
	{ 0xFA7A,  0xD487 },
	{ 0xFA7D,  0x8498 },
	{ 0xFA7E,  0x8794 },
	{ 0xFAA1,  0x82BD },
	{ 0xFAA2,  0x9C9A },
	{ 0xFAA3,  0xA59F },
	{ 0xFAA4,  0xA59E },
	{ 0xFAA6,  0xAF9B },
	{ 0xFAA8,  0x8497 },
	{ 0xFAA9,  0x8186 },
	{ 0xFAAA,  0xF68E },
	{ 0xFAAB,  0x8D8D },
	{ 0xFAAC,  0xB88A },
	{ 0xFAAD,  0xBD89 },
	{ 0xFAAF,  0x92C5 },
	{ 0xFAB0,  0x8298 },
	{ 0xFAB1,  0x8798 },
	{ 0xFAB2,  0x8D90 },
	{ 0xFAB3,  0x8D94 },
	{ 0xFAB4,  0x9CA0 },
	{ 0xFAB5,  0xD786 },
	{ 0xFAB6,  0x8D93 },
	{ 0xFAB7,  0x9492 },
	{ 0xFAB8,  0x82A9 },
	{ 0xFAB9,  0xDA9D },
	{ 0xFABA,  0xBB82 },
	{ 0xFABB,  0xEC9F },
	{ 0xFABF,  0xA687 },
	{ 0xFAC0,  0xBE8C },
	{ 0xFAC4,  0xCE80 },
	{ 0xFAC7,  0xFA9F },
	{ 0xFAC9,  0xA08D },
	{ 0xFACA,  0xA281 },
	{ 0xFACB,  0x9780 },
	{ 0xFACF,  0x8FF4 },
	{ 0xFAD1,  0x829E },
	{ 0xFAD2,  0x87A0 },
	{ 0xFAD4,  0xA3E4 },
	{ 0xFAD8,  0x999F },
	{ 0xFAD9,  0x8D99 },
	{ 0xFADB,  0xA682 },
	{ 0xFADC,  0xBB85 },
	{ 0xFADD,  0xC497 },
	{ 0xFADE,  0x9285 },
	{ 0xFAE1,  0x928A },
	{ 0xFAE2,  0x8D9A },
	{ 0xFAE3,  0xB081 },
	{ 0xFAE4,  0x8E68 },
	{ 0xFAE5,  0x8185 },
	{ 0xFAE6,  0xA693 },
	{ 0xFAE7,  0x949B },
	{ 0xFAEA,  0xBB88 },
	{ 0xFAED,  0x8381 },
	{ 0xFAEF,  0x8588 },
	{ 0xFAF0,  0x8B95 },
	{ 0xFAF1,  0xA68F },
	{ 0xFAF2,  0xA98A },
	{ 0xFAF3,  0xA18A },
	{ 0xFAF4,  0x8E84 },
	{ 0xFAF7,  0xA688 },
	{ 0xFAF8,  0x8E82 },
	{ 0xFAF9,  0x9581 },
	{ 0xFB42,  0xA3E8 },
	{ 0xFB44,  0x8890 },
	{ 0xFB45,  0xB591 },
	{ 0xFB46,  0xB08A },
	{ 0xFB47,  0xB08E },
	{ 0xFB4D,  0xD08C },
	{ 0xFB4F,  0xCE8D },
	{ 0xFB50,  0xD892 },
	{ 0xFB52,  0xC69F },
	{ 0xFB53,  0xD08F },
	{ 0xFB54,  0xCE8C },
	{ 0xFB55,  0xCE8E },
	{ 0xFB56,  0xE08E },
	{ 0xFB57,  0x898B },
	{ 0xFB58,  0xD684 },
	{ 0xFB59,  0x91B3 },
	{ 0xFB5A,  0x9588 },
	{ 0xFB5B,  0x8894 },
	{ 0xFB5C,  0x8895 },
	{ 0xFB60,  0x8981 },
	{ 0xFB62,  0x8B8B },
	{ 0xFB63,  0x9195 },
	{ 0xFB64,  0x8983 },
	{ 0xFB67,  0xA695 },
	{ 0xFB69,  0xA698 },
	{ 0xFB6C,  0xB096 },
	{ 0xFB6E,  0xBB8E },
	{ 0xFB6F,  0xCE92 },
	{ 0xFB71,  0xE881 },
	{ 0xFB72,  0xE882 },
	{ 0xFB74,  0xB099 },
	{ 0xFB75,  0x8997 },
	{ 0xFB76,  0x889F },
	{ 0xFB79,  0xEA8F },
	{ 0xFB7B,  0xA69B },
	{ 0xFB7C,  0xA69A },
	{ 0xFB7E,  0xB492 },
	{ 0xFBA2,  0x9E84 },
	{ 0xFBA3,  0xA68B },
	{ 0xFBA5,  0xD486 },
	{ 0xFBA6,  0x8E9C },
	{ 0xFBAB,  0x9683 },
	{ 0xFBAF,  0xA190 },
	{ 0xFBB2,  0x95A0 },
	{ 0xFBB4,  0xB18D },
	{ 0xFBB5,  0xA792 },
	{ 0xFBBA,  0xB185 },
	{ 0xFBBB,  0xC88E },
	{ 0xFBBC,  0x8FA2 },
	{ 0xFBC3,  0x8390 },
	{ 0xFBC4,  0x9D84 },
	{ 0xFBC5,  0xBB9F },
	{ 0xFBC6,  0x8994 },
	{ 0xFBC7,  0xE884 },
	{ 0xFBCC,  0xB192 },
	{ 0xFBCD,  0xC687 },
	{ 0xFBD1,  0xE885 },
	{ 0xFBD2,  0x8F85 },
	{ 0xFBD4,  0x9E8E },
	{ 0xFBD6,  0xF794 },
	{ 0xFBD7,  0x9991 },
	{ 0xFBD8,  0x838E },
	{ 0xFBDB,  0x8F88 },
	{ 0xFBDD,  0x899D },
	{ 0xFBDE,  0x9E96 },
	{ 0xFBDF,  0x9E97 },
	{ 0xFBE0,  0xC599 },
	{ 0xFBE3,  0xA79E },
	{ 0xFBE4,  0xA880 },
	{ 0xFBE5,  0xB1A0 },
	{ 0xFBE7,  0x8F8F },
	{ 0xFBE8,  0xF294 },
	{ 0xFBE9,  0x9B83 },
	{ 0xFBEE,  0xF991 },
	{ 0xFBF1,  0x9E9A },
	{ 0xFBF2,  0xDF86 },
	{ 0xFBF4,  0xC6CD },
	{ 0xFBF7,  0xB080 },
	{ 0xFBF8,  0xBA97 },
	{ 0xFBFA,  0xAFA0 },
	{ 0xFBFC,  0x899F },
	{ 0xFBFD,  0xC6CF },
	{ 0xFC40,  0x8F98 },
	{ 0xFC41,  0x9697 },
	{ 0xFC43,  0x9696 },
	{ 0xFC44,  0xA093 },
	{ 0xFC45,  0xED99 },
	{ 0xFC46,  0x8391 },
	{ 0xFC4C,  0xB289 },
	{ 0xFC51,  0x8A84 },
	{ 0xFC52,  0xF091 },
	{ 0xFC54,  0xF18E },
	{ 0xFC55,  0x8F47 },
	{ 0xFC57,  0xB28A },
	{ 0xFC58,  0x8FAA },
	{ 0xFC5E,  0xA588 },
	{ 0xFC61,  0x969E },
	{ 0xFC62,  0xC8CE },
	{ 0xFC67,  0x958F },
	{ 0xFC69,  0xB68F },
	{ 0xFC6B,  0x9F90 },
	{ 0xFC6D,  0xB28F },
	{ 0xFC71,  0x8FFE },
	{ 0xFC72,  0xC48E },
	{ 0xFC73,  0xB18A },
	{ 0xFC74,  0xCF93 },
	{ 0xFC75,  0x96EE },
	{ 0xFC76,  0xC684 },
	{ 0xFC79,  0xC682 },
	{ 0xFC7A,  0xC493 },
	{ 0xFC7C,  0xCF97 },
	{ 0xFC7D,  0x9269 },
	{ 0xFCA2,  0x90CE },
	{ 0xFCA5,  0xD886 },
	{ 0xFCA9,  0x969D },
	{ 0xFCAA,  0xCF8D },
	{ 0xFCAB,  0xF192 },
	{ 0xFCAC,  0xA895 },
	{ 0xFCAE,  0x908E },
	{ 0xFCB0,  0x9089 },
	{ 0xFCB2,  0xA89B },
	{ 0xFCB5,  0xBC95 },
	{ 0xFCB6,  0xB29E },
	{ 0xFCBA,  0xC8E9 },
	{ 0xFCBC,  0xCCA0 },
	{ 0xFCBF,  0xDE9D },
	{ 0xFCC0,  0xE397 },
	{ 0xFCC1,  0xF596 },
	{ 0xFCC3,  0xBC9E },
	{ 0xFCC5,  0xA982 },
	{ 0xFCC6,  0x816C },
	{ 0xFCC9,  0xEB9E },
	{ 0xFCCA,  0xBD81 },
	{ 0xFCCB,  0xB383 },
	{ 0xFCCD,  0xDE9F },
	{ 0xFCD0,  0xB386 },
	{ 0xFCD3,  0xC6D3 },
	{ 0xFCD4,  0xA989 },
	{ 0xFCD5,  0x8A8B },
	{ 0xFCD7,  0x9098 },
	{ 0xFCDA,  0xA089 },
	{ 0xFCDD,  0xA086 },
	{ 0xFCDF,  0xA98C },
	{ 0xFCE1,  0xB38A },
	{ 0xFCE8,  0xE982 },
	{ 0xFCEA,  0xE78A },
	{ 0xFCEB,  0x8FBE },
	{ 0xFCEF,  0xD09A },
	{ 0xFCF2,  0x936E },
	{ 0xFCF3,  0x8E79 },
	{ 0xFCF6,  0x9886 },
	{ 0xFCF8,  0xA096 },
	{ 0xFCF9,  0xB495 },
	{ 0xFCFA,  0xC385 },
	{ 0xFCFB,  0x9883 },
	{ 0xFCFE,  0x9F48 },
	{ 0xFD41,  0xC78B },
	{ 0xFD42,  0xD093 },
	{ 0xFD44,  0xBD8C },
	{ 0xFD45,  0xB3A0 },
	{ 0xFD47,  0xB398 },
	{ 0xFD48,  0xB397 },
	{ 0xFD4D,  0x8FC0 },
	{ 0xFD4E,  0xBD95 },
	{ 0xFD51,  0xBD93 },
	{ 0xFD52,  0xC78E },
	{ 0xFD55,  0x9880 },
	{ 0xFD56,  0xC85A },
	{ 0xFD57,  0xD09E },
	{ 0xFD5A,  0xD983 },
	{ 0xFD5C,  0xDF8D },
	{ 0xFD5E,  0x9882 },
	{ 0xFD5F,  0xE482 },
	{ 0xFD62,  0xF492 },
	{ 0xFD64,  0xA893 },
	{ 0xFD65,  0xAA81 },
	{ 0xFD66,  0xC78F },
	{ 0xFD68,  0xBE85 },
	{ 0xFD6D,  0x8888 },
	{ 0xFD6F,  0x9889 },
	{ 0xFD71,  0x8FCF },
	{ 0xFD72,  0x839B },
	{ 0xFD76,  0x8691 },
	{ 0xFD77,  0xFE8E },
	{ 0xFD78,  0x8B91 },
	{ 0xFDA5,  0xDD8C },
	{ 0xFDA8,  0x9A97 },
	{ 0xFDA9,  0xA08B },
	{ 0xFDAD,  0xA193 },
	{ 0xFDAE,  0xA192 },
	{ 0xFDAF,  0x8FD9 },
	{ 0xFDB0,  0xC79B },
	{ 0xFDB4,  0xD482 },
	{ 0xFDB6,  0x9C99 },
	{ 0xFDB9,  0xC18F },
	{ 0xFDBD,  0xBF81 },
	{ 0xFDBF,  0x8FE3 },
	{ 0xFDC0,  0xB48A },
	{ 0xFDC1,  0xB187 },
	{ 0xFDC3,  0x8FDF },
	{ 0xFDC5,  0x8FDD },
	{ 0xFDC7,  0xC79D },
	{ 0xFDCB,  0x99B7 },
	{ 0xFDCC,  0xC799 },
	{ 0xFDCD,  0xD189 },
	{ 0xFDCF,  0xD192 },
	{ 0xFDD2,  0xD98C },
	{ 0xFDD4,  0xD98B },
	{ 0xFDDB,  0xDE84 },
	{ 0xFDE0,  0xEF89 },
	{ 0xFDE1,  0x8B97 },
	{ 0xFDE2,  0x9981 },
	{ 0xFDE3,  0x919C },
	{ 0xFDE4,  0xA196 },
	{ 0xFDE5,  0xA19C },
	{ 0xFDE6,  0xA19A },
	{ 0xFDE7,  0xA199 },
	{ 0xFDEA,  0x8FF3 },
	{ 0xFDEB,  0x8FF1 },
	{ 0xFDED,  0xB580 },
	{ 0xFDEE,  0xBE97 },
	{ 0xFDEF,  0xB09F },
	{ 0xFDF0,  0xBE92 },
	{ 0xFDF2,  0x899C },
	{ 0xFDF4,  0xBE94 },
	{ 0xFDF5,  0xE285 },
	{ 0xFDF7,  0xB49C },
	{ 0xFDFB,  0xD992 },
	{ 0xFDFD,  0x9458 },
	{ 0xFDFE,  0x8FF6 },
	{ 0xFE40,  0xF281 },
	{ 0xFE41,  0xE89C },
	{ 0xFE42,  0x8FF7 },
	{ 0xFE43,  0xF285 },
	{ 0xFE44,  0xF494 },
	{ 0xFE45,  0x99B6 },
	{ 0xFE47,  0x9983 },
	{ 0xFE48,  0x919E },
	{ 0xFE4A,  0x8EC6 },
	{ 0xFE4B,  0xD19B },
	{ 0xFE4C,  0xD19A },
	{ 0xFE4F,  0x9F45 },
	{ 0xFE50,  0xD18A },
	{ 0xFE51,  0xB587 },
	{ 0xFE53,  0xB58E },
	{ 0xFE58,  0xB590 },
	{ 0xFE59,  0xBE9E },
	{ 0xFE5A,  0x998D },
	{ 0xFE5B,  0x9289 },
	{ 0xFE5E,  0x998E },
	{ 0xFE5F,  0xBF89 },
	{ 0xFE63,  0x9790 },
	{ 0xFE68,  0xB597 },
	{ 0xFE69,  0xB599 },
	{ 0xFE6A,  0xB390 },
	{ 0xFE6C,  0xB59B },
	{ 0xFE71,  0xC894 },
	{ 0xFE73,  0xBF86 },
	{ 0xFE74,  0xA285 },
	{ 0xFE75,  0xC893 },
	{ 0xFE76,  0x8ECF },
	{ 0xFE77,  0xC88D },
	{ 0xFE79,  0xC895 },
	{ 0xFE7A,  0x90B9 },
	{ 0xFE7B,  0xD0A0 },
	{ 0xFE7C,  0xD280 },
	{ 0xFEA4,  0xEB98 },
	{ 0xFEA7,  0xE8A0 },
	{ 0xFEA9,  0xD99B },
	{ 0xFEAB,  0xBF8E },
	{ 0xFEAE,  0xBC80 },
	{ 0xFEB0,  0x8F4D },
	{ 0xFEB1,  0x9999 },
	{ 0xFEB2,  0x9998 },
	{ 0xFEB3,  0xAB8C },
	{ 0xFEB4,  0xB59E },
	{ 0xFEB8,  0xB680 },
	{ 0xFEB9,  0xBF83 },
	{ 0xFEBA,  0x9290 },
	{ 0xFEBB,  0xA28E },
	{ 0xFEBC,  0xBF91 },
	{ 0xFEBD,  0xD99D },
	{ 0xFEBE,  0xE493 },
	{ 0xFEBF,  0xE494 },
	{ 0xFEC0,  0xF299 },
	{ 0xFEC1,  0xC6D5 },
	{ 0xFEC3,  0xAB8E },
	{ 0xFEC4,  0xB79A },
	{ 0xFEC8,  0xDA80 },
	{ 0xFEC9,  0xE087 },
	{ 0xFECA,  0xC89A },
	{ 0xFECB,  0xA291 },
	{ 0xFECD,  0xC194 },
	{ 0xFED1,  0xAB95 },
	{ 0xFED2,  0xAB93 },
	{ 0xFED3,  0xAB94 },
	{ 0xFED4,  0xD086 },
	{ 0xFED6,  0xBF97 },
	{ 0xFED8,  0xE08B },
	{ 0xFEDC,  0x8C86 },
	{ 0xFEE0,  0xB396 },
	{ 0xFEE1,  0xC988 },
	{ 0xFEE2,  0xD28A },
	{ 0xFEE3,  0xD287 },
	{ 0xFEE4,  0xD682 },
	{ 0xFEE5,  0xEF92 },
	{ 0xFEE7,  0x94EE },
	{ 0xFEE8,  0x9FCE },
	{ 0xFEE9,  0xC987 },
	{ 0xFEEB,  0xF893 },
	{ 0xFEEC,  0xA49B },
	{ 0xFEF0,  0x9050 },
	{ 0xFEF1,  0xCB89 },
	{ 0xFEF2,  0xB394 },
	{ 0xFEF3,  0xC083 },
	{ 0xFEF5,  0xD28D },
	{ 0xFEF7,  0x869A },
	{ 0xFEF8,  0xDA87 },
	{ 0xFEF9,  0xB498 },
	{ 0xFEFC,  0x9293 },
	{ 0xFEFE,  0x9A86 }
};

#endif
