/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 *	Copyright(c) 1997 Sun Microsystems, Inc.
 *	All rights reserved.
 */

#ifndef _BIG5_GB2312_H_

#define _BIG5_GB2312_H_

#include "public_struc.h"

#define BIG5MAX	6880

table_t big5_gb_tab[BIG5MAX] = {
	0xa140, 0xa1a1,
	0xa141, 0xa3ac,
	0xa142, 0xa1a2,
	0xa143, 0xa1a3,
	0xa144, 0xa3ae,
	0xa146, 0xa3bb,
	0xa147, 0xa3ba,
	0xa148, 0xa3bf,
	0xa149, 0xa3a1,
	0xa14a, 0xa1c3,
	0xa14b, 0xa1ad,
	0xa14c, 0xa1a7,
	0xa14f, 0xa1a4,
	0xa152, 0xa3ba,
	0xa153, 0xa3bf,
	0xa155, 0xa3fc,
	0xa15a, 0xa3df,
	0xa15d, 0xa3a8,
	0xa15e, 0xa3a9,
	0xa161, 0xa3fb,
	0xa162, 0xa3fd,
	0xa165, 0xa1b2,
	0xa166, 0xa1b3,
	0xa169, 0xa1be,
	0xa16a, 0xa1bf,
	0xa16d, 0xa1b6,
	0xa16e, 0xa1b7,
	0xa171, 0xa1b4,
	0xa172, 0xa1b5,
	0xa173, 0xa3de,
	0xa175, 0xa1b8,
	0xa176, 0xa1b9,
	0xa179, 0xa1ba,
	0xa17a, 0xa1bb,
	0xa1a3, 0xa3db,
	0xa1a4, 0xa3dd,
	0xa1a5, 0xa1ae,
	0xa1a6, 0xa1af,
	0xa1a7, 0xa1b0,
	0xa1a8, 0xa1b1,
	0xa1a9, 0xa3a2,
	0xa1aa, 0xa1e5,
	0xa1ab, 0xa3e0,
	0xa1ac, 0xa1e4,
	0xa1ac, 0xa3a7,
	0xa1ad, 0xa3a3,
	0xa1ae, 0xa3a6,
	0xa1af, 0xa3aa,
	0xa1b0, 0xa1f9,
	0xa1b1, 0xa1ec,
	0xa1b2, 0xa1a8,
	0xa1b3, 0xa1f0,
	0xa1b4, 0xa1f1,
	0xa1b5, 0xa1f7,
	0xa1b6, 0xa1f8,
	0xa1b7, 0xa1f2,
	0xa1b8, 0xa1ee,
	0xa1b9, 0xa1ef,
	0xa1ba, 0xa1f3,
	0xa1bb, 0xa1f4,
	0xa1bc, 0xa1f5,
	0xa1bd, 0xa1f6,
	0xa1c2, 0xa1a5,
	0xa1c2, 0xa3fe,
	0xa1cf, 0xa3ab,
	0xa1d0, 0xa3ad,
	0xa1d1, 0xa1c1,
	0xa1d2, 0xa1c2,
	0xa1d3, 0xa1c0,
	0xa1d4, 0xa1cc,
	0xa1d5, 0xa3bc,
	0xa1d6, 0xa3be,
	0xa1d7, 0xa3bd,
	0xa1d8, 0xa1dc,
	0xa1d9, 0xa1dd,
	0xa1da, 0xa1d9,
	0xa1db, 0xa1de,
	0xa1dc, 0xa1d6,
	0xa1dd, 0xa1d4,
	0xa1e3, 0xa1ab,
	0xa1e4, 0xa1c9,
	0xa1e5, 0xa1c8,
	0xa1e7, 0xa1cf,
	0xa1ec, 0xa1d2,
	0xa1ed, 0xa1d3,
	0xa1ee, 0xa1df,
	0xa1ef, 0xa1e0,
	0xa1f0, 0xa1e2,
	0xa1f1, 0xa1e1,
	0xa1f3, 0xa1d1,
	0xa1f4, 0xa1fc,
	0xa1f5, 0xa1fd,
	0xa1f6, 0xa1fb,
	0xa1f7, 0xa1fa,
	0xa1fc, 0xa1ac,
	0xa1fe, 0xa3af,
	0xa240, 0xa3dc,
	0xa241, 0xa3af,
	0xa243, 0xa1e7,
	0xa243, 0xa3a4,
	0xa246, 0xa1e9,
	0xa247, 0xa1ea,
	0xa248, 0xa3a5,
	0xa249, 0xa3c0,
	0xa24a, 0xa1e6,
	0xa258, 0xa1e3,
	0xa271, 0xa9e0,
	0xa272, 0xa9d8,
	0xa273, 0xa9d0,
	0xa274, 0xa9c8,
	0xa275, 0xa9c0,
	0xa277, 0xa1aa,
	0xa277, 0xa9a4,
	0xa278, 0xa9a6,
	0xa27a, 0xa9b0,
	0xa27b, 0xa9b4,
	0xa27c, 0xa9b8,
	0xa27d, 0xa9bc,
	0xa2a4, 0xa1fe,
	0xa2af, 0xa3b0,
	0xa2b0, 0xa3b1,
	0xa2b1, 0xa3b2,
	0xa2b2, 0xa3b3,
	0xa2b3, 0xa3b4,
	0xa2b4, 0xa3b5,
	0xa2b5, 0xa3b6,
	0xa2b6, 0xa3b7,
	0xa2b7, 0xa3b8,
	0xa2b8, 0xa3b9,
	0xa2b9, 0xa2f1,
	0xa2ba, 0xa2f2,
	0xa2bb, 0xa2f3,
	0xa2bc, 0xa2f4,
	0xa2bd, 0xa2f5,
	0xa2be, 0xa2f6,
	0xa2bf, 0xa2f7,
	0xa2c0, 0xa2f8,
	0xa2c1, 0xa2f9,
	0xa2c2, 0xa2fa,
	0xa2cf, 0xa3c1,
	0xa2d0, 0xa3c2,
	0xa2d1, 0xa3c3,
	0xa2d2, 0xa3c4,
	0xa2d3, 0xa3c5,
	0xa2d4, 0xa3c6,
	0xa2d5, 0xa3c7,
	0xa2d6, 0xa3c8,
	0xa2d7, 0xa3c9,
	0xa2d8, 0xa3ca,
	0xa2d9, 0xa3cb,
	0xa2da, 0xa3cc,
	0xa2db, 0xa3cd,
	0xa2dc, 0xa3ce,
	0xa2dd, 0xa3cf,
	0xa2de, 0xa3d0,
	0xa2df, 0xa3d1,
	0xa2e0, 0xa3d2,
	0xa2e1, 0xa3d3,
	0xa2e2, 0xa3d4,
	0xa2e3, 0xa3d5,
	0xa2e4, 0xa3d6,
	0xa2e5, 0xa3d7,
	0xa2e6, 0xa3d8,
	0xa2e7, 0xa3d9,
	0xa2e8, 0xa3da,
	0xa2e9, 0xa3e1,
	0xa2ea, 0xa3e2,
	0xa2eb, 0xa3e3,
	0xa2ec, 0xa3e4,
	0xa2ed, 0xa3e5,
	0xa2ee, 0xa3e6,
	0xa2ef, 0xa3e7,
	0xa2f0, 0xa3e8,
	0xa2f1, 0xa3e9,
	0xa2f2, 0xa3ea,
	0xa2f3, 0xa3eb,
	0xa2f4, 0xa3ec,
	0xa2f5, 0xa3ed,
	0xa2f6, 0xa3ee,
	0xa2f7, 0xa3ef,
	0xa2f8, 0xa3f0,
	0xa2f9, 0xa3f1,
	0xa2fa, 0xa3f2,
	0xa2fb, 0xa3f3,
	0xa2fc, 0xa3f4,
	0xa2fd, 0xa3f5,
	0xa2fe, 0xa3f6,
	0xa340, 0xa3f7,
	0xa341, 0xa3f8,
	0xa342, 0xa3f9,
	0xa343, 0xa3fa,
	0xa344, 0xa6a1,
	0xa345, 0xa6a2,
	0xa346, 0xa6a3,
	0xa347, 0xa6a4,
	0xa348, 0xa6a5,
	0xa349, 0xa6a6,
	0xa34a, 0xa6a7,
	0xa34b, 0xa6a8,
	0xa34c, 0xa6a9,
	0xa34d, 0xa6aa,
	0xa34e, 0xa1c4,
	0xa34e, 0xa6ab,
	0xa34f, 0xa6ac,
	0xa350, 0xa6ad,
	0xa351, 0xa6ae,
	0xa352, 0xa6af,
	0xa353, 0xa1c7,
	0xa353, 0xa6b0,
	0xa354, 0xa6b1,
	0xa355, 0xa1c6,
	0xa355, 0xa6b2,
	0xa356, 0xa6b3,
	0xa357, 0xa6b4,
	0xa358, 0xa6b5,
	0xa359, 0xa6b6,
	0xa35a, 0xa6b7,
	0xa35b, 0xa6b8,
	0xa35c, 0xa6c1,
	0xa35d, 0xa6c2,
	0xa35e, 0xa6c3,
	0xa35f, 0xa6c4,
	0xa360, 0xa6c5,
	0xa361, 0xa6c6,
	0xa362, 0xa6c7,
	0xa363, 0xa6c8,
	0xa364, 0xa6c9,
	0xa365, 0xa6ca,
	0xa366, 0xa6cb,
	0xa367, 0xa6cc,
	0xa368, 0xa6cd,
	0xa369, 0xa6ce,
	0xa36a, 0xa6cf,
	0xa36b, 0xa6d0,
	0xa36c, 0xa6d1,
	0xa36d, 0xa6d2,
	0xa36e, 0xa6d3,
	0xa36f, 0xa6d4,
	0xa370, 0xa6d5,
	0xa371, 0xa6d6,
	0xa372, 0xa6d7,
	0xa373, 0xa6d8,
	0xa374, 0xa8c5,
	0xa375, 0xa8c6,
	0xa376, 0xa8c7,
	0xa377, 0xa8c8,
	0xa378, 0xa8c9,
	0xa379, 0xa8ca,
	0xa37a, 0xa8cb,
	0xa37b, 0xa8cc,
	0xa37c, 0xa8cd,
	0xa37d, 0xa8ce,
	0xa37e, 0xa8cf,
	0xa3a1, 0xa8d0,
	0xa3a2, 0xa8d1,
	0xa3a3, 0xa8d2,
	0xa3a4, 0xa8d3,
	0xa3a5, 0xa8d4,
	0xa3a6, 0xa8d5,
	0xa3a7, 0xa8d6,
	0xa3a8, 0xa8d7,
	0xa3a9, 0xa8d8,
	0xa3aa, 0xa8d9,
	0xa3ab, 0xa8da,
	0xa3ac, 0xa8db,
	0xa3ad, 0xa8dc,
	0xa3ae, 0xa8dd,
	0xa3af, 0xa8de,
	0xa3b0, 0xa8df,
	0xa3b1, 0xa8e0,
	0xa3b2, 0xa8e1,
	0xa3b3, 0xa8e2,
	0xa3b4, 0xa8e3,
	0xa3b5, 0xa8e4,
	0xa3b6, 0xa8e5,
	0xa3b7, 0xa8e6,
	0xa3b8, 0xa8e7,
	0xa3b9, 0xa8e8,
	0xa3ba, 0xa8e9,
	0xa440, 0xd2bb,
	0xa441, 0xd2d2,
	0xa442, 0xb6a1,
	0xa443, 0xc6df,
	0xa444, 0xc4cb,
	0xa445, 0xbec5,
	0xa446, 0xc1cb,
	0xa447, 0xb6fe,
	0xa448, 0xc8cb,
	0xa449, 0xb6f9,
	0xa44a, 0xc8eb,
	0xa44b, 0xb0cb,
	0xa44c, 0xbcb8,
	0xa44d, 0xb5b6,
	0xa44e, 0xb5f3,
	0xa44f, 0xc1a6,
	0xa450, 0xd8b0,
	0xa451, 0xcaae,
	0xa452, 0xb2b7,
	0xa453, 0xd3d6,
	0xa454, 0xc8fd,
	0xa454, 0xc8fe,
	0xa455, 0xcfc2,
	0xa456, 0xd5c9,
	0xa457, 0xc9cf,
	0xa458, 0xd1be,
	0xa459, 0xcde8,
	0xa45a, 0xb7b2,
	0xa45b, 0xbec3,
	0xa45c, 0xc3b4,
	0xa45d, 0xd2b2,
	0xa45e, 0xc6f2,
	0xa45f, 0xd3da,
	0xa460, 0xcdf6,
	0xa461, 0xd8a3,
	0xa462, 0xc8d0,
	0xa463, 0xc9d7,
	0xa464, 0xc7a7,
	0xa465, 0xb2e6,
	0xa466, 0xbfda,
	0xa467, 0xcdc1,
	0xa468, 0xcabf,
	0xa469, 0xcfa6,
	0xa46a, 0xb4f3,
	0xa46b, 0xc5ae,
	0xa46c, 0xd7d3,
	0xa46d, 0xe6dd,
	0xa46e, 0xe6de,
	0xa46f, 0xb4e7,
	0xa470, 0xd0a1,
	0xa471, 0xdecc,
	0xa472, 0xcaac,
	0xa473, 0xc9bd,
	0xa474, 0xb4a8,
	0xa475, 0xb9a4,
	0xa476, 0xbcba,
	0xa477, 0xd2d1,
	0xa478, 0xcbc8,
	0xa479, 0xbded,
	0xa47a, 0xb8c9,
	0xa47b, 0xdec3,
	0xa47c, 0xdfae,
	0xa47d, 0xb9ad,
	0xa47e, 0xb2c5,
	0xa4a1, 0xb3f3,
	0xa4a2, 0xd8a4,
	0xa4a3, 0xb2bb,
	0xa4a4, 0xd6d0,
	0xa4a5, 0xb7e1,
	0xa4a6, 0xb5a4,
	0xa4a7, 0xd6ae,
	0xa4a8, 0xd2fc,
	0xa4a9, 0xd3e8,
	0xa4aa, 0xd4c6,
	0xa4ab, 0xbeae,
	0xa4ac, 0xbba5,
	0xa4ad, 0xcee5,
	0xa4ae, 0xbfba,
	0xa4af, 0xc8ca,
	0xa4b0, 0xcab2,
	0xa4b1, 0xd8ea,
	0xa4b2, 0xc6cd,
	0xa4b3, 0xb3f0,
	0xa4b4, 0xc8d4,
	0xa4b5, 0xbdf1,
	0xa4b6, 0xbde9,
	0xa4b7, 0xd8c6,
	0xa4b8, 0xd4aa,
	0xa4b9, 0xd4ca,
	0xa4ba, 0xc4da,
	0xa4bb, 0xc1f9,
	0xa4bc, 0xd9e2,
	0xa4bd, 0xb9ab,
	0xa4bf, 0xd0d7,
	0xa4be, 0xc8df,
	0xa4c0, 0xb7d6,
	0xa4c1, 0xc7d0,
	0xa4c2, 0xd8d7,
	0xa4c3, 0xd4c8,
	0xa4c4, 0xb9b4,
	0xa4c5, 0xcef0,
	0xa4c6, 0xbbaf,
	0xa4c7, 0xc6a5,
	0xa4c8, 0xcee7,
	0xa4c9, 0xc9fd,
	0xa4ca, 0xd8a6,
	0xa4cb, 0xb1e5,
	0xa4cc, 0xb6f2,
	0xa4cd, 0xd3d1,
	0xa4ce, 0xbcb0,
	0xa4cf, 0xb7b4,
	0xa4d0, 0xc8c9,
	0xa4d1, 0xccec,
	0xa4d2, 0xb7f2,
	0xa4d3, 0xccab,
	0xa4d4, 0xd8b2,
	0xa4d5, 0xbfd7,
	0xa4d6, 0xc9d9,
	0xa4d7, 0xd3c8,
	0xa4d8, 0xb3df,
	0xa4d9, 0xcdcd,
	0xa4da, 0xb0cd,
	0xa4db, 0xbbc3,
	0xa4dc, 0xd8a5,
	0xa4de, 0xd2fd,
	0xa4df, 0xd0c4,
	0xa4e0, 0xb8ea,
	0xa4e1, 0xbba7,
	0xa4e2, 0xcad6,
	0xa4e3, 0xd4fa,
	0xa4e4, 0xd6a7,
	0xa4e5, 0xcec4,
	0xa4e6, 0xb6b7,
	0xa4e7, 0xbdef,
	0xa4e8, 0xb7bd,
	0xa4e9, 0xc8d5,
	0xa4ea, 0xd4bb,
	0xa4eb, 0xd4c2,
	0xa4ec, 0xc4be,
	0xa4ed, 0xc7b7,
	0xa4ee, 0xd6b9,
	0xa4ef, 0xb4f5,
	0xa4f0, 0xcee3,
	0xa4f1, 0xb1c8,
	0xa4f2, 0xc3ab,
	0xa4f3, 0xcacf,
	0xa4f4, 0xcbae,
	0xa4f5, 0xbbf0,
	0xa4f6, 0xd7a6,
	0xa4f7, 0xb8b8,
	0xa4f8, 0xd8b3,
	0xa4f9, 0xc6ac,
	0xa4fa, 0xd1c0,
	0xa4fb, 0xc5a3,
	0xa4fc, 0xc8ae,
	0xa4fd, 0xcdf5,
	0xa4fe, 0xb1fb,
	0xa540, 0xcac0,
	0xa541, 0xd8a7,
	0xa542, 0xc7d2,
	0xa543, 0xc7f0,
	0xa544, 0xd6f7,
	0xa545, 0xd5a7,
	0xa546, 0xb7a6,
	0xa547, 0xbaf5,
	0xa548, 0xd2d4,
	0xa549, 0xb8b6,
	0xa54a, 0xd7d0,
	0xa54b, 0xcacb,
	0xa54c, 0xcbfb,
	0xa54d, 0xd5cc,
	0xa54e, 0xb4fa,
	0xa54f, 0xc1ee,
	0xa550, 0xcfc9,
	0xa551, 0xd8f0,
	0xa552, 0xb3e4,
	0xa553, 0xd0d6,
	0xa554, 0xc8bd,
	0xa555, 0xb2e1,
	0xa556, 0xb6ac,
	0xa557, 0xb0bc,
	0xa558, 0xb3f6,
	0xa559, 0xcdb9,
	0xa55a, 0xbfaf,
	0xa55b, 0xbcd3,
	0xa55c, 0xb9a6,
	0xa55d, 0xb0fc,
	0xa55e, 0xb4d2,
	0xa55f, 0xb1b1,
	0xa560, 0xd4d1,
	0xa561, 0xc7aa,
	0xa562, 0xb0eb,
	0xa563, 0xbbdc,
	0xa564, 0xbfa8,
	0xa565, 0xd5bc,
	0xa566, 0xc3ae,
	0xa567, 0xd8b4,
	0xa568, 0xc8a5,
	0xa569, 0xbfc9,
	0xa56a, 0xb9c5,
	0xa56b, 0xd3d2,
	0xa56c, 0xd5d9,
	0xa56d, 0xb6a3,
	0xa56e, 0xdfb5,
	0xa56f, 0xdfb6,
	0xa570, 0xb5f0,
	0xa571, 0xcbbe,
	0xa572, 0xd8cf,
	0xa573, 0xbdd0,
	0xa574, 0xc1ed,
	0xa575, 0xd6bb,
	0xa576, 0xcab7,
	0xa577, 0xdfb3,
	0xa578, 0xcca8,
	0xa579, 0xbee4,
	0xa57a, 0xb0c8,
	0xa57b, 0xdfb7,
	0xa57c, 0xcbc4,
	0xa57d, 0xc7f4,
	0xa57e, 0xcde2,
	0xa5a1, 0xd1eb,
	0xa5a2, 0xcaa7,
	0xa5a3, 0xc5ab,
	0xa5a4, 0xc4cc,
	0xa5a5, 0xd4d0,
	0xa5a6, 0xcbfc,
	0xa5a7, 0xc4e1,
	0xa5a8, 0xbede,
	0xa5a9, 0xc7c9,
	0xa5aa, 0xd7f3,
	0xa5ab, 0xcad0,
	0xa5ac, 0xb2bc,
	0xa5ad, 0xc6bd,
	0xa5ae, 0xd3d7,
	0xa5af, 0xdbcd,
	0xa5b0, 0xbaeb,
	0xa5b1, 0xb8a5,
	0xa5b2, 0xb1d8,
	0xa5b3, 0xceec,
	0xa5b4, 0xb4f2,
	0xa5b5, 0xc8d3,
	0xa5b6, 0xb0c7,
	0xa5b7, 0xc6cb,
	0xa5b8, 0xb3e2,
	0xa5b9, 0xb5a9,
	0xa5ba, 0xcaf5,
	0xa5bb, 0xb1be,
	0xa5bc, 0xceb4,
	0xa5bd, 0xc4a9,
	0xa5be, 0xd4fd,
	0xa5bf, 0xd5fd,
	0xa5c0, 0xc4b8,
	0xa5c1, 0xc3f1,
	0xa5c2, 0xd8b5,
	0xa5c3, 0xd3c0,
	0xa5c4, 0xd6ad,
	0xa5c5, 0xcda1,
	0xa5c7, 0xb7b8,
	0xa5c8, 0xd0fe,
	0xa5c9, 0xd3f1,
	0xa5ca, 0xb9cf,
	0xa5cb, 0xcddf,
	0xa5cc, 0xb8ca,
	0xa5cd, 0xc9fa,
	0xa5ce, 0xd3c3,
	0xa5cf, 0xcba6,
	0xa5d0, 0xccef,
	0xa5d1, 0xd3c9,
	0xa5d2, 0xbcd7,
	0xa5d3, 0xc9ea,
	0xa5d4, 0xf1e2,
	0xa5d5, 0xb0d7,
	0xa5d6, 0xc6a4,
	0xa5d7, 0xc3f3,
	0xa5d8, 0xc4bf,
	0xa5d9, 0xc3ac,
	0xa5da, 0xcab8,
	0xa5db, 0xcaaf,
	0xa5dc, 0xcabe,
	0xa5dd, 0xbacc,
	0xa5de, 0xd1a8,
	0xa5df, 0xc1a2,
	0xa5e0, 0xd8a9,
	0xa5e1, 0xb6aa,
	0xa5e2, 0xc6b9,
	0xa5e3, 0xc5d2,
	0xa5e4, 0xd8c0,
	0xa5e5, 0xd8a8,
	0xa5e6, 0xbdbb,
	0xa5e7, 0xd2e0,
	0xa5e8, 0xbaa5,
	0xa5e9, 0xb7c2,
	0xa5ea, 0xd8f8,
	0xa5eb, 0xbbef,
	0xa5ec, 0xd2c1,
	0xa5ee, 0xcee9,
	0xa5ef, 0xb7a5,
	0xa5f0, 0xd0dd,
	0xa5f1, 0xb7fc,
	0xa5f2, 0xd6d9,
	0xa5f3, 0xbcfe,
	0xa5f4, 0xc8ce,
	0xa5f5, 0xd1f6,
	0xa5f6, 0xd8f2,
	0xa5f7, 0xb7dd,
	0xa5f8, 0xc6f3,
	0xa5fa, 0xb9e2,
	0xa5fb, 0xd0d7,
	0xa5fc, 0xd5d7,
	0xa5fd, 0xcfc8,
	0xa5fe, 0xc8ab,
	0xa640, 0xb9b2,
	0xa641, 0xd4d9,
	0xa642, 0xb1f9,
	0xa643, 0xc1d0,
	0xa644, 0xd0cc,
	0xa645, 0xbbae,
	0xa646, 0xd8d8,
	0xa647, 0xebbe,
	0xa648, 0xc1d3,
	0xa649, 0xd0d9,
	0xa64a, 0xbfef,
	0xa64b, 0xbdb3,
	0xa64c, 0xd3a1,
	0xa64d, 0xcea3,
	0xa64e, 0xbcaa,
	0xa64f, 0xc0f4,
	0xa650, 0xcdac,
	0xa651, 0xb5f5,
	0xa652, 0xcdc2,
	0xa653, 0xd3f5,
	0xa654, 0xb4e7,
	0xa655, 0xb8f7,
	0xa656, 0xcff2,
	0xa657, 0xc3fb,
	0xa658, 0xbacf,
	0xa659, 0xb3d4,
	0xa65a, 0xbaf3,
	0xa65b, 0xdfba,
	0xa65c, 0xdfb8,
	0xa65d, 0xd2f2,
	0xa65e, 0xbbd8,
	0xa65f, 0xe0ee,
	0xa660, 0xdbda,
	0xa661, 0xb5d8,
	0xa662, 0xd4da,
	0xa663, 0xb9e7,
	0xa664, 0xdbd8,
	0xa665, 0xdbdd,
	0xa666, 0xdbd7,
	0xa667, 0xd9ed,
	0xa668, 0xb6e0,
	0xa669, 0xd2c4,
	0xa66a, 0xbfe4,
	0xa66b, 0xcdfd,
	0xa66c, 0xbce9,
	0xa66d, 0xe5fa,
	0xa66e, 0xbac3,
	0xa66f, 0xcbfd,
	0xa670, 0xc8e7,
	0xa671, 0xe5f9,
	0xa672, 0xd7d6,
	0xa673, 0xb4e6,
	0xa674, 0xd3ee,
	0xa675, 0xcad8,
	0xa676, 0xd5ac,
	0xa677, 0xb0b2,
	0xa678, 0xcbc2,
	0xa679, 0xbce2,
	0xa67a, 0xd2d9,
	0xa67b, 0xd6dd,
	0xa67c, 0xb7ab,
	0xa67d, 0xb2a2,
	0xa67e, 0xc4ea,
	0xa6a1, 0xcabd,
	0xa6a2, 0xb3da,
	0xa6a3, 0xc3a6,
	0xa6a4, 0xe2e2,
	0xa6a5, 0xc8d6,
	0xa6a6, 0xd0e7,
	0xa6a7, 0xcaf9,
	0xa6a8, 0xb3c9,
	0xa6a9, 0xbfdb,
	0xa6aa, 0xbfb8,
	0xa6ab, 0xcdd0,
	0xa6ac, 0xcad5,
	0xa6ad, 0xd4e7,
	0xa6ae, 0xd6bc,
	0xa6af, 0xd1ae,
	0xa6b0, 0xd0f1,
	0xa6b1, 0xc7fa,
	0xa6b2, 0xd2b7,
	0xa6b3, 0xd3d0,
	0xa6b4, 0xd0e0,
	0xa6b5, 0xc6d3,
	0xa6b6, 0xd6ec,
	0xa6b7, 0xb6e4,
	0xa6b8, 0xb4ce,
	0xa6b9, 0xb4cb,
	0xa6ba, 0xcbc0,
	0xa6bb, 0xc4ca,
	0xa6bc, 0xc8ea,
	0xa6bd, 0xbab9,
	0xa6bf, 0xbdad,
	0xa6c0, 0xb3d8,
	0xa6c1, 0xcfab,
	0xa6c2, 0xc9c7,
	0xa6c3, 0xcedb,
	0xa6c4, 0xd1b4,
	0xa6c7, 0xbbd2,
	0xa6c8, 0xc4b2,
	0xa6c9, 0xeaf2,
	0xa6ca, 0xb0d9,
	0xa6cb, 0xd6f1,
	0xa6cc, 0xc3d7,
	0xa6cd, 0xf4e9,
	0xa6ce, 0xf3be,
	0xa6cf, 0xd1f2,
	0xa6d0, 0xd3f0,
	0xa6d1, 0xc0cf,
	0xa6d2, 0xbfbc,
	0xa6d3, 0xb6f8,
	0xa6d4, 0xf1e7,
	0xa6d5, 0xb6fa,
	0xa6d6, 0xedb2,
	0xa6d7, 0xc8e2,
	0xa6d8, 0xc0df,
	0xa6d9, 0xbca1,
	0xa6da, 0xb3bc,
	0xa6db, 0xd7d4,
	0xa6dc, 0xd6c1,
	0xa6dd, 0xbeca,
	0xa6de, 0xc9e0,
	0xa6df, 0xe2b6,
	0xa6e0, 0xd6db,
	0xa6e1, 0xf4de,
	0xa6e2, 0xc9ab,
	0xa6e3, 0xb0ac,
	0xa6e4, 0xb3e6,
	0xa6e5, 0xd1aa,
	0xa6e6, 0xd0d0,
	0xa6e7, 0xd2c2,
	0xa6e8, 0xcef7,
	0xa6e9, 0xdae4,
	0xa6ea, 0xb4ae,
	0xa6eb, 0xbae0,
	0xa6ec, 0xcebb,
	0xa6ed, 0xd7a1,
	0xa6ee, 0xd8f9,
	0xa6ef, 0xd9a2,
	0xa6f0, 0xd8fa,
	0xa6f1, 0xb0e9,
	0xa6f2, 0xb7f0,
	0xa6f3, 0xbace,
	0xa6f4, 0xb9c0,
	0xa6f5, 0xd7f4,
	0xa6f6, 0xd3d3,
	0xa6f7, 0xd9a4,
	0xa6f8, 0xcbc5,
	0xa6f9, 0xc9ec,
	0xa6fa, 0xb5e8,
	0xa6fb, 0xd5bc,
	0xa6fc, 0xcbc6,
	0xa6fd, 0xb5ab,
	0xa6fe, 0xd3b6,
	0xa740, 0xd7f7,
	0xa741, 0xc4e3,
	0xa742, 0xb2ae,
	0xa743, 0xb5cd,
	0xa744, 0xc1e6,
	0xa745, 0xd3e0,
	0xa746, 0xd8fe,
	0xa747, 0xb2bc,
	0xa748, 0xd8fd,
	0xa749, 0xb6d2,
	0xa74a, 0xbfcb,
	0xa74b, 0xc3e2,
	0xa74c, 0xb1f8,
	0xa74d, 0xd2b1,
	0xa74e, 0xc0e4,
	0xa74f, 0xb1f0,
	0xa750, 0xc5d0,
	0xa751, 0xc0fb,
	0xa752, 0xc9be,
	0xa753, 0xc5d9,
	0xa754, 0xbdd9,
	0xa755, 0xd6fa,
	0xa756, 0xc5ac,
	0xa757, 0xdbbe,
	0xa758, 0xcfbb,
	0xa759, 0xbcb4,
	0xa75a, 0xc2d1,
	0xa75b, 0xc1df,
	0xa75c, 0xbfd4,
	0xa75d, 0xcdcc,
	0xa75e, 0xcee1,
	0xa75f, 0xb7f1,
	0xa761, 0xb0c9,
	0xa762, 0xb4f4,
	0xa763, 0xdfc0,
	0xa764, 0xcee2,
	0xa765, 0xb3ca,
	0xa766, 0xc2c0,
	0xa767, 0xbefd,
	0xa768, 0xb7d4,
	0xa769, 0xb8e6,
	0xa76a, 0xb4b5,
	0xa76b, 0xcec7,
	0xa76c, 0xcefc,
	0xa76d, 0xcbb1,
	0xa76e, 0xb3b3,
	0xa76f, 0xc4c5,
	0xa770, 0xb7cd,
	0xa771, 0xbaf0,
	0xa772, 0xd1bd,
	0xa773, 0xd6a8,
	0xa774, 0xbaac,
	0xa775, 0xd2f7,
	0xa776, 0xccfd,
	0xa777, 0xb4d1,
	0xa778, 0xc0a7,
	0xa779, 0xb6da,
	0xa77a, 0xe0f1,
	0xa77b, 0xb7bb,
	0xa77c, 0xbfd3,
	0xa77d, 0xd6b7,
	0xa77e, 0xccae,
	0xa7a1, 0xbef9,
	0xa7a2, 0xbfb2,
	0xa7a3, 0xbbf8,
	0xa7a4, 0xd7f8,
	0xa7a5, 0xbbb5,
	0xa7a6, 0xdbdf,
	0xa7a7, 0xd7b3,
	0xa7a8, 0xbcd0,
	0xa7a9, 0xd7b1,
	0xa7aa, 0xb6ca,
	0xa7ab, 0xb7c1,
	0xa7ac, 0xe6a4,
	0xa7ad, 0xe5fe,
	0xa7ae, 0xc3ee,
	0xa7af, 0xd1fd,
	0xa7b0, 0xe5fb,
	0xa7b1, 0xe6a5,
	0xa7b2, 0xbccb,
	0xa7b3, 0xc8d1,
	0xa7b4, 0xcdd7,
	0xa7b5, 0xd0a2,
	0xa7b6, 0xd7ce,
	0xa7b7, 0xe6da,
	0xa7b8, 0xd8c3,
	0xa7b9, 0xcdea,
	0xa7ba, 0xcbce,
	0xa7bb, 0xbaea,
	0xa7bc, 0xdece,
	0xa7bd, 0xbed6,
	0xa7be, 0xc6a8,
	0xa7bf, 0xc4f2,
	0xa7c0, 0xceb2,
	0xa7c1, 0xe1aa,
	0xa7c2, 0xe1af,
	0xa7c3, 0xb2ed,
	0xa7c4, 0xe1a7,
	0xa7c5, 0xced7,
	0xa7c6, 0xcfa3,
	0xa7c7, 0xd0f2,
	0xa7c8, 0xb1d3,
	0xa7c9, 0xb4b2,
	0xa7ca, 0xcda2,
	0xa7cb, 0xc5aa,
	0xa7cc, 0xb5dc,
	0xa7cd, 0xcdae,
	0xa7ce, 0xd0ce,
	0xa7cf, 0xe1dd,
	0xa7d0, 0xd2db,
	0xa7d1, 0xcdfc,
	0xa7d2, 0xbcc9,
	0xa7d3, 0xd6be,
	0xa7d4, 0xc8cc,
	0xa7d5, 0xb3c0,
	0xa7d6, 0xbfec,
	0xa7d7, 0xe2ee,
	0xa7d8, 0xe2ec,
	0xa7d9, 0xbde4,
	0xa7da, 0xced2,
	0xa7db, 0xb3ad,
	0xa7dc, 0xbfb9,
	0xa7dd, 0xb6b6,
	0xa7de, 0xbcbc,
	0xa7df, 0xb7f6,
	0xa7e0, 0xbef1,
	0xa7e1, 0xc5a4,
	0xa7e2, 0xb0d1,
	0xa7e3, 0xb6f3,
	0xa7e4, 0xd5d2,
	0xa7e5, 0xc5fa,
	0xa7e6, 0xb0e2,
	0xa7e7, 0xcae3,
	0xa7e8, 0xb3b6,
	0xa7e9, 0xd5db,
	0xa7ea, 0xb0e7,
	0xa7eb, 0xcdb6,
	0xa7ec, 0xd7a5,
	0xa7ed, 0xd2d6,
	0xa7ef, 0xb8c4,
	0xa7f0, 0xb9a5,
	0xa7f1, 0xd8fc,
	0xa7f2, 0xbab5,
	0xa7f3, 0xb8fc,
	0xa7f4, 0xcaf8,
	0xa7f5, 0xc0ee,
	0xa7f6, 0xd0d3,
	0xa7f7, 0xb2c4,
	0xa7f8, 0xb4e5,
	0xa7f9, 0xb6c5,
	0xa7fa, 0xd5c8,
	0xa7fb, 0xe8bd,
	0xa7fc, 0xc9bc,
	0xa7fd, 0xb8cb,
	0xa7fe, 0xb8dc,
	0xa840, 0xe8bc,
	0xa842, 0xb2bd,
	0xa843, 0xc3bf,
	0xa844, 0xc7f3,
	0xa845, 0xb9af,
	0xa846, 0xc9b3,
	0xa847, 0xc7df,
	0xa848, 0xc9f2,
	0xa849, 0xb3c1,
	0xa84a, 0xe3e4,
	0xa84b, 0xc5e6,
	0xa84c, 0xcdf4,
	0xa84d, 0xbef6,
	0xa84e, 0xe3e5,
	0xa84f, 0xccad,
	0xa850, 0xe3e7,
	0xa851, 0xe3e8,
	0xa852, 0xb3e5,
	0xa853, 0xc3bb,
	0xa854, 0xc6fb,
	0xa855, 0xced6,
	0xa856, 0xbcb3,
	0xa857, 0xb7da,
	0xa858, 0xe3ea,
	0xa859, 0xe3ec,
	0xa85a, 0xe3eb,
	0xa85c, 0xe3e6,
	0xa85e, 0xd2ca,
	0xa85f, 0xd4ee,
	0xa860, 0xd7c6,
	0xa861, 0xd4d6,
	0xa862, 0xbec4,
	0xa863, 0xc0ce,
	0xa864, 0xc4b5,
	0xa866, 0xb5d2,
	0xa867, 0xbff1,
	0xa868, 0xbec1,
	0xa869, 0xf0ae,
	0xa86a, 0xb8a6,
	0xa86b, 0xc4d0,
	0xa86c, 0xb5e9,
	0xa86d, 0xd4ed,
	0xa86e, 0xb6a2,
	0xa86f, 0xd2d3,
	0xa870, 0xcbbd,
	0xa871, 0xd0e3,
	0xa872, 0xcdba,
	0xa873, 0xbebf,
	0xa874, 0xcfb5,
	0xa875, 0xbab1,
	0xa876, 0xd0a4,
	0xa877, 0xebc1,
	0xa878, 0xb8ce,
	0xa879, 0xd6e2,
	0xa87a, 0xb8d8,
	0xa87b, 0xb6c7,
	0xa87c, 0xd3fd,
	0xa87d, 0xc1bc,
	0xa87e, 0xc3a2,
	0xa8a1, 0xd3f3,
	0xa8a2, 0xc9d6,
	0xa8a3, 0xbcfb,
	0xa8a4, 0xbdc7,
	0xa8a5, 0xd1d4,
	0xa8a6, 0xb9c8,
	0xa8a7, 0xb6b9,
	0xa8a8, 0xf5b9,
	0xa8a9, 0xb1b4,
	0xa8aa, 0xb3e0,
	0xa8ab, 0xd7df,
	0xa8ac, 0xd7e3,
	0xa8ad, 0xc9ed,
	0xa8ae, 0xb3b5,
	0xa8af, 0xd0c1,
	0xa8b0, 0xb3bd,
	0xa8b1, 0xd3d8,
	0xa8b3, 0xd1b8,
	0xa8b4, 0xc6f9,
	0xa8b5, 0xd1b2,
	0xa8b6, 0xd2d8,
	0xa8b7, 0xd0cf,
	0xa8b8, 0xd0b0,
	0xa8b9, 0xb0ee,
	0xa8ba, 0xc4c7,
	0xa8bb, 0xd3cf,
	0xa8bd, 0xc0ef,
	0xa8be, 0xb7c0,
	0xa8bf, 0xc8ee,
	0xa8c0, 0xdae5,
	0xa8c1, 0xdae6,
	0xa8c3, 0xb2a2,
	0xa8c4, 0xb9d4,
	0xa8c5, 0xc8e9,
	0xa8c6, 0xcac2,
	0xa8c7, 0xd0a9,
	0xa8c8, 0xd1c7,
	0xa8c9, 0xcfed,
	0xa8ca, 0xbea9,
	0xa8cb, 0xd1f0,
	0xa8cc, 0xd2c0,
	0xa8cd, 0xcacc,
	0xa8ce, 0xbcd1,
	0xa8cf, 0xcab9,
	0xa8d0, 0xc0d0,
	0xa8d1, 0xb9a9,
	0xa8d2, 0xc0fd,
	0xa8d3, 0xc0b4,
	0xa8d4, 0xd9a9,
	0xa8d5, 0xb0db,
	0xa8d6, 0xb2a2,
	0xa8d7, 0xb3de,
	0xa8d8, 0xc5e5,
	0xa8d9, 0xd9ac,
	0xa8da, 0xc2d8,
	0xa8db, 0xd9ab,
	0xa8dc, 0xd9aa,
	0xa8dd, 0xd9a7,
	0xa8df, 0xcdc3,
	0xa8e0, 0xb6f9,
	0xa8e1, 0xd9ee,
	0xa8e2, 0xc1bd,
	0xa8e3, 0xbedf,
	0xa8e4, 0xc6e4,
	0xa8e5, 0xb5e4,
	0xa8e6, 0xd9fd,
	0xa8e7, 0xbaaf,
	0xa8e8, 0xbfcc,
	0xa8e9, 0xc8af,
	0xa8ea, 0xcba2,
	0xa8eb, 0xb4cc,
	0xa8ec, 0xb5bd,
	0xa8ed, 0xb9ce,
	0xa8ee, 0xd6c6,
	0xa8ef, 0xb6e7,
	0xa8f0, 0xdbc0,
	0xa8f2, 0xd7e4,
	0xa8f3, 0xd0ad,
	0xa8f4, 0xd7bf,
	0xa8f5, 0xb1b0,
	0xa8f6, 0xd8d4,
	0xa8f7, 0xbeed,
	0xa8f8, 0xd0b6,
	0xa8fa, 0xc8a1,
	0xa8fb, 0xcae5,
	0xa8fc, 0xcadc,
	0xa8fd, 0xceb6,
	0xa8fe, 0xbac7,
	0xa940, 0xbfa7,
	0xa941, 0xc5de,
	0xa942, 0xb9be,
	0xa943, 0xbed7,
	0xa944, 0xc9eb,
	0xa945, 0xdfc8,
	0xa946, 0xdfcd,
	0xa947, 0xd6e4,
	0xa948, 0xc5d8,
	0xa949, 0xbaf4,
	0xa94a, 0xb8c0,
	0xa94b, 0xdfc9,
	0xa94c, 0xdfce,
	0xa94d, 0xbacd,
	0xa94e, 0xdfcb,
	0xa94f, 0xc4d8,
	0xa950, 0xd6dc,
	0xa951, 0xd5a6,
	0xa952, 0xc3fc,
	0xa953, 0xbecc,
	0xa954, 0xb9cc,
	0xa955, 0xc0ac,
	0xa956, 0xbfc0,
	0xa957, 0xc6ba,
	0xa958, 0xdbe1,
	0xa959, 0xc6c2,
	0xa95a, 0xccb9,
	0xa95b, 0xc0a4,
	0xa95c, 0xdbe5,
	0xa95d, 0xd2b9,
	0xa95e, 0xb7ee,
	0xa95f, 0xc6e6,
	0xa960, 0xc4ce,
	0xa961, 0xd1d9,
	0xa962, 0xb1bc,
	0xa963, 0xe6aa,
	0xa964, 0xc6de,
	0xa965, 0xceaf,
	0xa966, 0xc3c3,
	0xa967, 0xc4dd,
	0xa968, 0xb9c3,
	0xa969, 0xc4b7,
	0xa96a, 0xbde3,
	0xa96b, 0xe6a9,
	0xa96c, 0xcabc,
	0xa96d, 0xd0d5,
	0xa96e, 0xe6a2,
	0xa96f, 0xe6a8,
	0xa971, 0xe6a6,
	0xa973, 0xc3cf,
	0xa974, 0xb9c2,
	0xa975, 0xbcbe,
	0xa976, 0xd7da,
	0xa977, 0xb6a8,
	0xa978, 0xb9d9,
	0xa979, 0xd2cb,
	0xa97a, 0xd6e6,
	0xa97b, 0xcdf0,
	0xa97c, 0xc9d0,
	0xa97d, 0xc7fc,
	0xa97e, 0xbed3,
	0xa9a1, 0xbdec,
	0xa9a2, 0xe1ba,
	0xa9a3, 0xb8d4,
	0xa9a4, 0xb0b6,
	0xa9a5, 0xd1d2,
	0xa9a6, 0xe1b6,
	0xa9a7, 0xe1b7,
	0xa9a8, 0xd4c0,
	0xa9a9, 0xc1b1,
	0xa9aa, 0xd6e3,
	0xa9ab, 0xccfb,
	0xa9ac, 0xc5c1,
	0xa9ad, 0xb2af,
	0xa9ae, 0xe0fb,
	0xa9af, 0xd0d2,
	0xa9b0, 0xb8fd,
	0xa9b1, 0xb5ea,
	0xa9b2, 0xb8ae,
	0xa9b3, 0xb5d7,
	0xa9b4, 0xe2d2,
	0xa9b5, 0xd1d3,
	0xa9b6, 0xcfd2,
	0xa9b7, 0xbba1,
	0xa9b8, 0xe5f3,
	0xa9b9, 0xcdf9,
	0xa9ba, 0xd5f7,
	0xa9bc, 0xb1cb,
	0xa9bd, 0xe3c3,
	0xa9be, 0xd6d2,
	0xa9bf, 0xbaf6,
	0xa9c0, 0xc4ee,
	0xa9c1, 0xb7de,
	0xa9c2, 0xe2f3,
	0xa9c3, 0xd5fa,
	0xa9c4, 0xc7d3,
	0xa9c5, 0xe2f0,
	0xa9c6, 0xb2c0,
	0xa9c7, 0xb9d6,
	0xa9c8, 0xc5c2,
	0xa9c9, 0xe2f9,
	0xa9ca, 0xd0d4,
	0xa9cb, 0xe2f5,
	0xa9cc, 0xe2f6,
	0xa9cd, 0xe2f2,
	0xa9ce, 0xbbf2,
	0xa9cf, 0xe3de,
	0xa9d0, 0xb7bf,
	0xa9d1, 0xece5,
	0xa9d2, 0xcbf9,
	0xa9d3, 0xb3d0,
	0xa9d4, 0xc0ad,
	0xa9d5, 0xb0e8,
	0xa9d6, 0xd6f4,
	0xa9d7, 0xc3f2,
	0xa9d8, 0xb7f7,
	0xa9d9, 0xc4a8,
	0xa9da, 0xbedc,
	0xa9db, 0xd5d0,
	0xa9dc, 0xc5fb,
	0xa9dd, 0xcdd8,
	0xa9de, 0xb0ce,
	0xa9df, 0xc5d7,
	0xa9e0, 0xc4e9,
	0xa9e1, 0xc5ea,
	0xa9e2, 0xb3e9,
	0xa9e3, 0xd1ba,
	0xa9e4, 0xb9d5,
	0xa9e5, 0xd7be,
	0xa9e6, 0xc4b4,
	0xa9e7, 0xc5c4,
	0xa9e8, 0xb5d6,
	0xa9e9, 0xded5,
	0xa9ea, 0xb1a7,
	0xa9eb, 0xbed0,
	0xa9ec, 0xcdcf,
	0xa9ed, 0xded6,
	0xa9ee, 0xb2f0,
	0xa9ef, 0xcca7,
	0xa9f0, 0xc1e0,
	0xa9f1, 0xb7c5,
	0xa9f2, 0xb8ab,
	0xa9f3, 0xd3da,
	0xa9f4, 0xcdfa,
	0xa9f5, 0xcef4,
	0xa9f6, 0xd2d7,
	0xa9f7, 0xb2fd,
	0xa9f8, 0xc0a5,
	0xa9f9, 0xb0ba,
	0xa9fa, 0xc3f7,
	0xa9fb, 0xeac0,
	0xa9fc, 0xbbe8,
	0xa9fd, 0xeabf,
	0xa9fe, 0xeabb,
	0xaa40, 0xc9fd,
	0xaa41, 0xb7fe,
	0xaa42, 0xc5f3,
	0xaa43, 0xbabc,
	0xaa44, 0xe8ca,
	0xaa45, 0xd5ed,
	0xaa46, 0xb6ab,
	0xaa47, 0xb9fb,
	0xaa48, 0xe8c3,
	0xaa49, 0xe8cb,
	0xaa4a, 0xe8c1,
	0xaa4b, 0xd6a6,
	0xaa4c, 0xc1d6,
	0xaa4d, 0xb1ad,
	0xaa4e, 0xbddc,
	0xaa4f, 0xb0e5,
	0xaa50, 0xcdf7,
	0xaa51, 0xcbc9,
	0xaa52, 0xcef6,
	0xaa53, 0xe8c6,
	0xaa54, 0xc3b6,
	0xaa56, 0xe8cc,
	0xaa57, 0xe8c2,
	0xaa58, 0xeabd,
	0xaa59, 0xd0c0,
	0xaa5a, 0xcee4,
	0xaa5b, 0xc6e7,
	0xaa5c, 0xe9e2,
	0xaa5d, 0xc3a5,
	0xaa5e, 0xb7d5,
	0xaa5f, 0xc6fc,
	0xaa60, 0xd7a2,
	0xaa61, 0xd3be,
	0xaa62, 0xe3fb,
	0xaa63, 0xc3da,
	0xaa64, 0xc4e0,
	0xaa65, 0xbad3,
	0xaa66, 0xb9c1,
	0xaa67, 0xd5b4,
	0xaa68, 0xd5d3,
	0xaa69, 0xb2a8,
	0xaa6a, 0xc4ad,
	0xaa6b, 0xb7a8,
	0xaa6c, 0xe3fc,
	0xaa6d, 0xb7d0,
	0xaa6e, 0xd0b9,
	0xaa6f, 0xd3cd,
	0xaa70, 0xbff6,
	0xaa71, 0xbeda,
	0xaa72, 0xe3f4,
	0xaa73, 0xc7f6,
	0xaa74, 0xe3f3,
	0xaa75, 0xd1d8,
	0xaa76, 0xd6ce,
	0xaa77, 0xc5dd,
	0xaa78, 0xb7ba,
	0xaa79, 0xb2b4,
	0xaa7b, 0xe3fd,
	0xaa7d, 0xe3f7,
	0xaa7e, 0xe3f6,
	0xaaa1, 0xbfbb,
	0xaaa2, 0xd1d7,
	0xaaa3, 0xb3b4,
	0xaaa4, 0xb4b6,
	0xaaa5, 0xd6cb,
	0xaaa6, 0xc5c0,
	0xaaa7, 0xd5f9,
	0xaaa8, 0xb0d6,
	0xaaa9, 0xb0e6,
	0xaaaa, 0xc4c1,
	0xaaab, 0xceef,
	0xaaac, 0xd7b4,
	0xaaad, 0xe1f2,
	0xaaae, 0xbed1,
	0xaaaf, 0xb9b7,
	0xaab0, 0xbafc,
	0xaab1, 0xcde6,
	0xaab2, 0xe7e5,
	0xaab3, 0xe7e4,
	0xaab4, 0xc3b5,
	0xaab7, 0xf0de,
	0xaab8, 0xb8ed,
	0xaab9, 0xbece,
	0xaaba, 0xb5c4,
	0xaabb, 0xd3db,
	0xaabc, 0xc3a4,
	0xaabd, 0xd6b1,
	0xaabe, 0xd6aa,
	0xaabf, 0xcef9,
	0xaac0, 0xc9e7,
	0xaac1, 0xeceb,
	0xaac2, 0xc6ee,
	0xaac3, 0xb1fc,
	0xaac4, 0xf4cc,
	0xaac5, 0xbfd5,
	0xaac6, 0xf1b7,
	0xaac7, 0xf3c3,
	0xaac8, 0xbec0,
	0xaac9, 0xd8e8,
	0xaaca, 0xc7bc,
	0xaacb, 0xd8c2,
	0xaacc, 0xd5df,
	0xaacd, 0xb7ce,
	0xaace, 0xb7ca,
	0xaacf, 0xd6ab,
	0xaad0, 0xebc5,
	0xaad1, 0xb9c9,
	0xaad2, 0xebc6,
	0xaad3, 0xbce7,
	0xaad4, 0xebc8,
	0xaad5, 0xb7be,
	0xaad6, 0xbfcf,
	0xaad7, 0xced4,
	0xaad8, 0xf4a7,
	0xaad9, 0xc9e1,
	0xaada, 0xb7bc,
	0xaadb, 0xd6a5,
	0xaadc, 0xdcbd,
	0xaadd, 0xb0c5,
	0xaade, 0xd1bf,
	0xaadf, 0xdccf,
	0xaae0, 0xc7db,
	0xaae1, 0xbba8,
	0xaae2, 0xb7d2,
	0xaae3, 0xbde6,
	0xaae4, 0xd0be,
	0xaae5, 0xdcbf,
	0xaae7, 0xdcc1,
	0xaae8, 0xdcc0,
	0xaae9, 0xdcc6,
	0xaaea, 0xbba2,
	0xaaeb, 0xcaad,
	0xaaec, 0xb3f5,
	0xaaed, 0xb1ed,
	0xaaee, 0xd4fe,
	0xaaef, 0xd3ad,
	0xaaf0, 0xb7b5,
	0xaaf1, 0xbdfc,
	0xaaf2, 0xc9db,
	0xaaf3, 0xdba1,
	0xaaf4, 0xc7f1,
	0xaaf5, 0xdafd,
	0xaaf6, 0xb2c9,
	0xaaf7, 0xbdf0,
	0xaaf8, 0xb3a4,
	0xaaf9, 0xc3c5,
	0xaafa, 0xb8b7,
	0xaafb, 0xcdd3,
	0xaafc, 0xb0a2,
	0xaafd, 0xd7e8,
	0xaafe, 0xb8bd,
	0xab40, 0xdae9,
	0xab41, 0xf6bf,
	0xab42, 0xd3ea,
	0xab43, 0xc7e0,
	0xab44, 0xb7c7,
	0xab45, 0xd8bd,
	0xab46, 0xcda4,
	0xab47, 0xc1c1,
	0xab48, 0xd0c5,
	0xab49, 0xc7d6,
	0xab4a, 0xbaee,
	0xab4b, 0xb1e3,
	0xab4c, 0xcfc0,
	0xab4d, 0xd9b8,
	0xab4e, 0xc7ce,
	0xab4f, 0xb1a3,
	0xab50, 0xb4d9,
	0xab51, 0xc2c2,
	0xab52, 0xb7fd,
	0xab53, 0xd9b9,
	0xab54, 0xbfa1,
	0xab55, 0xcbd7,
	0xab56, 0xceea,
	0xab57, 0xc0fe,
	0xab58, 0xb6ed,
	0xab59, 0xcfb5,
	0xab5a, 0xd9b5,
	0xab5b, 0xd9de,
	0xab5c, 0xd3e1,
	0xab5e, 0xd9f0,
	0xab5f, 0xc3b0,
	0xab60, 0xebd0,
	0xab61, 0xb9da,
	0xab62, 0xc9b2,
	0xab63, 0xccea,
	0xab64, 0xcff7,
	0xab65, 0xc7b0,
	0xab66, 0xd8dd,
	0xab68, 0xd4f2,
	0xab69, 0xd3c2,
	0xab6a, 0xc3e3,
	0xab6b, 0xb2aa,
	0xab6c, 0xbea2,
	0xab6d, 0xd9e9,
	0xab6e, 0xc4cf,
	0xab6f, 0xc8b4,
	0xab70, 0xbaf1,
	0xab71, 0xc5d1,
	0xab72, 0xd2a7,
	0xab73, 0xb0a7,
	0xab74, 0xd7c9,
	0xab75, 0xb0a5,
	0xab76, 0xd4d5,
	0xab77, 0xcfcc,
	0xab78, 0xdfd7,
	0xab79, 0xbfc8,
	0xab7a, 0xcddb,
	0xab7b, 0xdfd3,
	0xab7c, 0xd1ca,
	0xab7d, 0xdfe4,
	0xab7e, 0xc6b7,
	0xaba1, 0xbae5,
	0xaba2, 0xb9fe,
	0xaba3, 0xbfa9,
	0xaba4, 0xe5eb,
	0xaba5, 0xd4db,
	0xaba6, 0xdfdd,
	0xaba7, 0xdfe3,
	0xaba8, 0xdfd6,
	0xaba9, 0xdfde,
	0xabaa, 0xe0f3,
	0xabab, 0xb4b9,
	0xabac, 0xd0cd,
	0xabad, 0xdbf3,
	0xabae, 0xd4ab,
	0xabaf, 0xb9b8,
	0xabb0, 0xb3c7,
	0xabb1, 0xbfe5,
	0xabb2, 0xdbf2,
	0xabb3, 0xdec8,
	0xabb4, 0xc6f5,
	0xabb5, 0xd7e0,
	0xabb6, 0xbffc,
	0xabb7, 0xdbbc,
	0xabb8, 0xbdaa,
	0xabb9, 0xe6b0,
	0xabba, 0xd7cb,
	0xabbb, 0xe6af,
	0xabbc, 0xd2cc,
	0xabbd, 0xcdde,
	0xabbe, 0xc0d1,
	0xabc0, 0xd2a6,
	0xabc2, 0xcdfe,
	0xabc3, 0xd2f6,
	0xabc4, 0xbaa2,
	0xabc5, 0xd0fb,
	0xabc6, 0xbbc2,
	0xabc7, 0xcad2,
	0xabc8, 0xbfcd,
	0xabc9, 0xe5b6,
	0xabca, 0xb7e2,
	0xabcb, 0xcaba,
	0xabcc, 0xc6c1,
	0xabcd, 0xcaac,
	0xabce, 0xcedd,
	0xabcf, 0xd6c5,
	0xabd0, 0xe1bc,
	0xabd1, 0xcfef,
	0xabd2, 0xb5db,
	0xabd3, 0xcba7,
	0xabd5, 0xd3c4,
	0xabd6, 0xe2d4,
	0xabd7, 0xb6c8,
	0xabd8, 0xbda8,
	0xabd9, 0xdec4,
	0xabda, 0xe5f4,
	0xabdb, 0xd1e5,
	0xabdc, 0xbadc,
	0xabdd, 0xb4fd,
	0xabde, 0xbbb2,
	0xabdf, 0xc2c9,
	0xabe0, 0xe1df,
	0xabe1, 0xbaf3,
	0xabe1, 0xe1e1,
	0xabe2, 0xe1e0,
	0xabe3, 0xc5ad,
	0xabe4, 0xcbbc,
	0xabe5, 0xb5a1,
	0xabe6, 0xbcb1,
	0xabe7, 0xd4f5,
	0xabe8, 0xd4b9,
	0xabe9, 0xbbd0,
	0xabea, 0xc7a1,
	0xabeb, 0xbade,
	0xabec, 0xbbd6,
	0xabed, 0xbae3,
	0xabee, 0xcad1,
	0xabef, 0xccf1,
	0xabf0, 0xb6b2,
	0xabf1, 0xe3a1,
	0xabf2, 0xd0f4,
	0xabf3, 0xb1e2,
	0xabf4, 0xb0dd,
	0xabf5, 0xcdda,
	0xabf6, 0xb0b4,
	0xabf7, 0xc6b4,
	0xabf8, 0xcac3,
	0xabf9, 0xb3d6,
	0xabfa, 0xded7,
	0xabfb, 0xd7a7,
	0xabfc, 0xd6b8,
	0xabfd, 0xb9b0,
	0xabfe, 0xbfbd,
	0xac40, 0xd5fc,
	0xac41, 0xc0a8,
	0xac42, 0xcab0,
	0xac43, 0xcba9,
	0xac44, 0xccf4,
	0xac45, 0xb9d2,
	0xac46, 0xd5fe,
	0xac47, 0xb9ca,
	0xac48, 0xedbd,
	0xac49, 0xcaa9,
	0xac4a, 0xbcc8,
	0xac4b, 0xb4ba,
	0xac4c, 0xd5d1,
	0xac4d, 0xd3b3,
	0xac4e, 0xc3c1,
	0xac4f, 0xcac7,
	0xac50, 0xd0c7,
	0xac51, 0xd7f2,
	0xac52, 0xeac5,
	0xac54, 0xeac2,
	0xac55, 0xcac1,
	0xac56, 0xc8be,
	0xac57, 0xd6f9,
	0xac58, 0xc8e1,
	0xac59, 0xc4b3,
	0xac5a, 0xbced,
	0xac5b, 0xbcdc,
	0xac5c, 0xbfdd,
	0xac5d, 0xd5a4,
	0xac5e, 0xe8d1,
	0xac5f, 0xbfc2,
	0xac60, 0xb1fa,
	0xac61, 0xb8cc,
	0xac63, 0xe8d6,
	0xac64, 0xb2e9,
	0xac65, 0xe8db,
	0xac66, 0xb0d8,
	0xac67, 0xd7f5,
	0xac68, 0xc1f8,
	0xac69, 0xe8d2,
	0xac6a, 0xe8d4,
	0xac6b, 0xe8dc,
	0xac6c, 0xe8d8,
	0xac6d, 0xc6e2,
	0xac6e, 0xcde1,
	0xac6f, 0xd1ea,
	0xac70, 0xb4f9,
	0xac71, 0xb6ce,
	0xac72, 0xb6be,
	0xac73, 0xc5fe,
	0xac74, 0xb7fa,
	0xac75, 0xc8aa,
	0xac76, 0xd1f3,
	0xac77, 0xd6de,
	0xac78, 0xbae9,
	0xac79, 0xc1f7,
	0xac7a, 0xbdf2,
	0xac7b, 0xe4a3,
	0xac7c, 0xb6fd,
	0xac7d, 0xb6b4,
	0xac7e, 0xcfb4,
	0xaca1, 0xbbee,
	0xaca2, 0xc7a2,
	0xaca3, 0xc5c9,
	0xaca4, 0xd0da,
	0xaca5, 0xc2e5,
	0xaca6, 0xb1c3,
	0xaca7, 0xe4a1,
	0xaca8, 0xe4a2,
	0xacab, 0xe4ac,
	0xacac, 0xe4ad,
	0xacad, 0xe4a9,
	0xacae, 0xe4aa,
	0xacaf, 0xecc5,
	0xacb0, 0xceaa,
	0xacb1, 0xb1fe,
	0xacb2, 0xbee6,
	0xacb3, 0xbebc,
	0xacb4, 0xccbf,
	0xacb5, 0xd5a8,
	0xacb6, 0xc5da,
	0xacb8, 0xebbc,
	0xacb9, 0xc9fc,
	0xacba, 0xeaf4,
	0xacbc, 0xe1f7,
	0xacbd, 0xbadd,
	0xacbe, 0xbdc6,
	0xacbf, 0xe7e8,
	0xacc0, 0xc9ba,
	0xacc1, 0xb2a3,
	0xacc2, 0xc1e1,
	0xacc3, 0xd5e4,
	0xacc4, 0xe7ea,
	0xacc5, 0xe7e9,
	0xacc6, 0xc9f5,
	0xacc7, 0xb1c2,
	0xacc8, 0xceb7,
	0xacc9, 0xbde7,
	0xacca, 0xeeb0,
	0xaccb, 0xeeb1,
	0xaccc, 0xd2df,
	0xaccd, 0xb0cc,
	0xacce, 0xbdea,
	0xacd0, 0xf0e0,
	0xacd1, 0xb9ef,
	0xacd2, 0xbdd4,
	0xacd3, 0xbbca,
	0xacd4, 0xf0a7,
	0xacd5, 0xd3af,
	0xacd6, 0xc5e8,
	0xacd8, 0xd6d1,
	0xacd9, 0xcaa1,
	0xacda, 0xedef,
	0xacdb, 0xcfe0,
	0xacdc, 0xc3bc,
	0xacdd, 0xbfb4,
	0xacde, 0xb6dc,
	0xacdf, 0xc5ce,
	0xace0, 0xedf0,
	0xace1, 0xf1e6,
	0xace2, 0xc9b0,
	0xace3, 0xd1d0,
	0xace4, 0xc6f6,
	0xace5, 0xbfb3,
	0xace6, 0xecec,
	0xace7, 0xeced,
	0xace8, 0xc6ed,
	0xacea, 0xd3ed,
	0xaceb, 0xd8ae,
	0xacec, 0xbfc6,
	0xaced, 0xc3eb,
	0xacee, 0xc7ef,
	0xacef, 0xb4a9,
	0xacf0, 0xcdbb,
	0xacf1, 0xb8cd,
	0xacf2, 0xf3c4,
	0xacf3, 0xd7d1,
	0xacf4, 0xe6fb,
	0xacf5, 0xbaec,
	0xacf6, 0xbccd,
	0xacf7, 0xc8d2,
	0xacf8, 0xe6fc,
	0xacf9, 0xd4bc,
	0xacfa, 0xe6fa,
	0xacfb, 0xb8d7,
	0xacfc, 0xc3c0,
	0xacfd, 0xf4e0,
	0xacfe, 0xeba3,
	0xad40, 0xc4cd,
	0xad41, 0xcba3,
	0xad43, 0xd2ae,
	0xad44, 0xc5d6,
	0xad45, 0xf1e3,
	0xad46, 0xc5df,
	0xad47, 0xceb8,
	0xad48, 0xebd0,
	0xad49, 0xb1b3,
	0xad4a, 0xbafa,
	0xad4b, 0xebce,
	0xad4c, 0xcca5,
	0xad4d, 0xb0fb,
	0xad4e, 0xd8b7,
	0xad4f, 0xebd5,
	0xad50, 0xd6c2,
	0xad51, 0xf4ae,
	0xad52, 0xdcd1,
	0xad53, 0xb7b6,
	0xad54, 0xc3a9,
	0xad55, 0xdcc4,
	0xad56, 0xbfc1,
	0xad57, 0xbfe0,
	0xad58, 0xc7d1,
	0xad59, 0xc8f4,
	0xad5a, 0xc3af,
	0xad5b, 0xdcd4,
	0xad5c, 0xdcdb,
	0xad5d, 0xc3e7,
	0xad5e, 0xd3a2,
	0xad5f, 0xd7c2,
	0xad60, 0xdcd9,
	0xad61, 0xcca6,
	0xad62, 0xd4b7,
	0xad63, 0xb0fa,
	0xad64, 0xdcdf,
	0xad65, 0xb9b6,
	0xad66, 0xb1bd,
	0xad67, 0xdce2,
	0xad68, 0xc5b0,
	0xad69, 0xbae7,
	0xad6a, 0xf2b5,
	0xad6b, 0xf2b3,
	0xad6c, 0xd1dc,
	0xad6d, 0xc9c0,
	0xad6e, 0xd2aa,
	0xad70, 0xbcc6,
	0xad71, 0xb6a9,
	0xad72, 0xb8bc,
	0xad73, 0xd5ea,
	0xad74, 0xb8ba,
	0xad75, 0xb8b0,
	0xad76, 0xf4f1,
	0xad77, 0xc5bf,
	0xad78, 0xbefc,
	0xad79, 0xb9ec,
	0xad7a, 0xcaf6,
	0xad7b, 0xe5c8,
	0xad7c, 0xccf6,
	0xad7d, 0xb5cf,
	0xad7e, 0xe5c4,
	0xada1, 0xb5fc,
	0xada2, 0xc6c8,
	0xada3, 0xe5c6,
	0xada4, 0xe5ca,
	0xada5, 0xbdbc,
	0xada6, 0xc0c9,
	0xada7, 0xd3f4,
	0xada9, 0xc7f5,
	0xadaa, 0xf4fa,
	0xadab, 0xd6d8,
	0xadac, 0xe3c5,
	0xadad, 0xcfde,
	0xadae, 0xc2aa,
	0xadaf, 0xc4b0,
	0xadb0, 0xbdb5,
	0xadb1, 0xc3e6,
	0xadb2, 0xb8ef,
	0xadb3, 0xcea4,
	0xadb4, 0xbec2,
	0xadb5, 0xd2f4,
	0xadb6, 0xd2b3,
	0xadb7, 0xb7e7,
	0xadb8, 0xb7c9,
	0xadb9, 0xcab3,
	0xadba, 0xcad7,
	0xadbb, 0xcfe3,
	0xadbc, 0xb3cb,
	0xadbd, 0xd9f1,
	0xadbe, 0xd9c4,
	0xadbf, 0xb1b6,
	0xadc1, 0xb8a9,
	0xadc2, 0xbeeb,
	0xadc3, 0xd9c5,
	0xadc4, 0xd9ba,
	0xadc5, 0xd9bb,
	0xadc7, 0xc1a9,
	0xadc8, 0xd6b5,
	0xadc9, 0xbde8,
	0xadca, 0xd2d0,
	0xadcb, 0xb5b9,
	0xadcc, 0xc3c7,
	0xadcd, 0xb0b3,
	0xadce, 0xd8f6,
	0xadcf, 0xbef3,
	0xadd0, 0xd9c6,
	0xadd1, 0xbee3,
	0xadd2, 0xb3ab,
	0xadd3, 0xb8f6,
	0xadd4, 0xbaf2,
	0xadd5, 0xccc8,
	0xadd6, 0xd9bd,
	0xadd7, 0xd0de,
	0xadd8, 0xd9c1,
	0xadd9, 0xc4df,
	0xadda, 0xd9c2,
	0xaddb, 0xc2d7,
	0xaddc, 0xb2d6,
	0xaddd, 0xbce6,
	0xadde, 0xd4a9,
	0xaddf, 0xdaa4,
	0xade0, 0xdaa3,
	0xade1, 0xb6b3,
	0xade2, 0xc1e8,
	0xade3, 0xd7bc,
	0xade4, 0xb5f2,
	0xade5, 0xc6ca,
	0xade6, 0xd8e0,
	0xade7, 0xccde,
	0xade8, 0xb8d5,
	0xade9, 0xb0fe,
	0xadea, 0xb7cb,
	0xadeb, 0xc7e4,
	0xadec, 0xd4ad,
	0xaded, 0xd8c8,
	0xadee, 0xdbc5,
	0xadef, 0xc9da,
	0xadf0, 0xccc6,
	0xadf1, 0xd1e4,
	0xadf2, 0xe0a1,
	0xadf3, 0xbadf,
	0xadf4, 0xb8e7,
	0xadf5, 0xd5dc,
	0xadf6, 0xcbf4,
	0xadf7, 0xb2b8,
	0xadf8, 0xdfed,
	0xadf9, 0xc1a8,
	0xadfa, 0xbfde,
	0xadfb, 0xd4b1,
	0xadfc, 0xb0a6,
	0xadfd, 0xcff8,
	0xadfe, 0xc4c4,
	0xae40, 0xc5b6,
	0xae41, 0xdff3,
	0xae42, 0xb4bd,
	0xae43, 0xdfec,
	0xae44, 0xdff1,
	0xae45, 0xc6d4,
	0xae46, 0xe0f4,
	0xae47, 0xb9a1,
	0xae48, 0xc6d2,
	0xae49, 0xc2f1,
	0xae4a, 0xb0a3,
	0xae4c, 0xcfc4,
	0xae4d, 0xccd7,
	0xae4e, 0xdeca,
	0xae4f, 0xdec9,
	0xae50, 0xe6b6,
	0xae51, 0xc4ef,
	0xae52, 0xc4c8,
	0xae53, 0xbeea,
	0xae54, 0xd3e9,
	0xae55, 0xe6b8,
	0xae56, 0xbca7,
	0xae57, 0xc9ef,
	0xae58, 0xe6b7,
	0xae59, 0xc3e4,
	0xae5a, 0xb6f0,
	0xae5b, 0xe6b2,
	0xae5c, 0xe6b3,
	0xae5d, 0xcbef,
	0xae5f, 0xd4d7,
	0xae60, 0xbaa6,
	0xae61, 0xbcd2,
	0xae62, 0xd1e7,
	0xae63, 0xb9ac,
	0xae64, 0xcffc,
	0xae65, 0xc8dd,
	0xae66, 0xe5b7,
	0xae67, 0xc9e4,
	0xae68, 0xd0bc,
	0xae69, 0xd5b9,
	0xae6a, 0xe5ec,
	0xae6b, 0xc7cd,
	0xae6c, 0xcfbf,
	0xae6d, 0xbefe,
	0xae6e, 0xd3f8,
	0xae6f, 0xb6eb,
	0xae70, 0xb7e5,
	0xae71, 0xb5ba,
	0xae73, 0xe1ad,
	0xae74, 0xb2ee,
	0xae75, 0xcfaf,
	0xae76, 0xcaa6,
	0xae77, 0xbfe2,
	0xae78, 0xcda5,
	0xae79, 0xd7f9,
	0xae7a, 0xc8f5,
	0xae7b, 0xcdbd,
	0xae7c, 0xbeb6,
	0xae7d, 0xd0ec,
	0xae7e, 0xeda6,
	0xaea1, 0xeda7,
	0xaea2, 0xb3dc,
	0xaea3, 0xbfd6,
	0xaea4, 0xcba1,
	0xaea5, 0xb9a7,
	0xaea6, 0xb6f7,
	0xaea7, 0xcfa2,
	0xaea8, 0xc7c4,
	0xaea9, 0xcef2,
	0xaeaa, 0xe3a4,
	0xaeab, 0xbab7,
	0xaeac, 0xbbda,
	0xaead, 0xe3a9,
	0xaeae, 0xd4c3,
	0xaeaf, 0xe3a3,
	0xaeb0, 0xc9c8,
	0xaeb1, 0xc8ad,
	0xaeb2, 0xeafc,
	0xaeb3, 0xc4c3,
	0xaeb4, 0xc9d3,
	0xaeb5, 0xd0ae,
	0xaeb6, 0xd5f1,
	0xaeb7, 0xb2b6,
	0xaeb8, 0xcee6,
	0xaeb9, 0xc0a6,
	0xaeba, 0xc4f3,
	0xaebb, 0xd7bd,
	0xaebc, 0xcda6,
	0xaebd, 0xbee8,
	0xaebe, 0xcdec,
	0xaebf, 0xc5b2,
	0xaec0, 0xb4ec,
	0xaec1, 0xb0a4,
	0xaec2, 0xbab4,
	0xaec3, 0xb0c6,
	0xaec4, 0xd0a7,
	0xaec5, 0xf4cd,
	0xaec6, 0xc1cf,
	0xaec7, 0xc5d4,
	0xaec8, 0xc2c3,
	0xaec9, 0xcab1,
	0xaeca, 0xbdfa,
	0xaecb, 0xeacc,
	0xaecc, 0xbbce,
	0xaecd, 0xc9b9,
	0xaece, 0xc9ce,
	0xaed0, 0xeacb,
	0xaed1, 0xcae9,
	0xaed2, 0xcbb7,
	0xaed3, 0xebde,
	0xaed4, 0xc0ca,
	0xaed5, 0xd0a3,
	0xaed6, 0xbacb,
	0xaed7, 0xb0b8,
	0xaed8, 0xbff2,
	0xaed9, 0xbbb8,
	0xaeda, 0xb8f9,
	0xaedb, 0xb9f0,
	0xaedc, 0xbddb,
	0xaedd, 0xe8f2,
	0xaede, 0xcae1,
	0xaedf, 0xc0f5,
	0xaee0, 0xd7c0,
	0xaee1, 0xc9a3,
	0xaee2, 0xd4d4,
	0xaee3, 0xb2f1,
	0xaee4, 0xcda9,
	0xaee5, 0xe8ee,
	0xaee6, 0xb8f1,
	0xaee7, 0xccd2,
	0xaee8, 0xd6ea,
	0xaee9, 0xcea6,
	0xaeea, 0xcba8,
	0xaeec, 0xe8ec,
	0xaeed, 0xcae2,
	0xaeee, 0xd1b3,
	0xaeef, 0xd2f3,
	0xaef0, 0xc6f8,
	0xaef1, 0xd1f5,
	0xaef2, 0xb0b1,
	0xaef3, 0xbaa4,
	0xaef4, 0xebb3,
	0xaef5, 0xcca9,
	0xaef6, 0xc0cb,
	0xaef7, 0xcce9,
	0xaef8, 0xcffb,
	0xaef9, 0xe3fe,
	0xaefa, 0xc6d6,
	0xaefb, 0xbdfe,
	0xaefc, 0xbaa3,
	0xaefd, 0xd5e3,
	0xaefe, 0xe4b8,
	0xaf41, 0xc9e6,
	0xaf42, 0xb8a1,
	0xaf43, 0xbfa3,
	0xaf44, 0xd4a1,
	0xaf45, 0xbac6,
	0xaf46, 0xd3bf,
	0xaf48, 0xe4a4,
	0xaf49, 0xc4f9,
	0xaf4b, 0xe4b9,
	0xaf4c, 0xecc8,
	0xaf4d, 0xbae6,
	0xaf4e, 0xbfbe,
	0xaf4f, 0xc0d3,
	0xaf50, 0xc1d2,
	0xaf51, 0xceda,
	0xaf52, 0xb5f9,
	0xaf53, 0xccd8,
	0xaf54, 0xc0c7,
	0xaf55, 0xcfc1,
	0xaf56, 0xb1b7,
	0xaf57, 0xc0ea,
	0xaf58, 0xe1fa,
	0xaf5a, 0xb0e0,
	0xaf5b, 0xc1f0,
	0xaf5d, 0xd6e9,
	0xaf5f, 0xe7f3,
	0xaf60, 0xc5cf,
	0xaf61, 0xc4b6,
	0xaf62, 0xd0f3,
	0xaf63, 0xdbce,
	0xaf64, 0xc1f4,
	0xaf65, 0xbcb2,
	0xaf66, 0xb2a1,
	0xaf67, 0xd6a2,
	0xaf68, 0xc6a3,
	0xaf69, 0xf0e1,
	0xaf6a, 0xbed2,
	0xaf6b, 0xccdb,
	0xaf6c, 0xd5ee,
	0xaf6d, 0xf0e8,
	0xaf6e, 0xf0e3,
	0xaf6f, 0xb8de,
	0xaf70, 0xf0e5,
	0xaf71, 0xd2e6,
	0xaf72, 0xeec1,
	0xaf73, 0xb0bb,
	0xaf74, 0xd1a3,
	0xaf75, 0xd5e6,
	0xaf76, 0xc3df,
	0xaf77, 0xd5a3,
	0xaf78, 0xbed8,
	0xaf79, 0xc5e9,
	0xaf7a, 0xd5e8,
	0xaf7b, 0xd4d2,
	0xaf7c, 0xedc0,
	0xaf7d, 0xc6c6,
	0xaf7e, 0xc9e9,
	0xafa1, 0xedc6,
	0xafa2, 0xedbe,
	0xafa4, 0xedc4,
	0xafa6, 0xc3d8,
	0xafa8, 0xecf4,
	0xafa9, 0xcbee,
	0xafaa, 0xd7e6,
	0xafab, 0xc9f1,
	0xafac, 0xd7a3,
	0xafad, 0xecf3,
	0xafae, 0xecf1,
	0xafaf, 0xb3d3,
	0xafb0, 0xeff7,
	0xafb1, 0xd1ed,
	0xafb2, 0xd7e2,
	0xafb3, 0xc7d8,
	0xafb4, 0xd6c8,
	0xafb5, 0xc3d8,
	0xafb6, 0xd5ad,
	0xafb7, 0xf1ba,
	0xafb8, 0xd5be,
	0xafb9, 0xb0ca,
	0xafba, 0xd0a6,
	0xafbb, 0xb7db,
	0xafbc, 0xb7c4,
	0xafbd, 0xc9b4,
	0xafbe, 0xcec6,
	0xafbf, 0xcec9,
	0xafc0, 0xcbd8,
	0xafc1, 0xcbf7,
	0xafc2, 0xb4bf,
	0xafc3, 0xc5a6,
	0xafc4, 0xe7a2,
	0xafc5, 0xbcb6,
	0xafc6, 0xe7a1,
	0xafc7, 0xc4c9,
	0xafc8, 0xd6bd,
	0xafc9, 0xb7d7,
	0xafca, 0xc8b1,
	0xafcb, 0xeeb9,
	0xafcc, 0xb8e1,
	0xafcd, 0xb3e1,
	0xafce, 0xcecc,
	0xafcf, 0xeac8,
	0xafd0, 0xd4c5,
	0xafd1, 0xb8fb,
	0xafd2, 0xb0d2,
	0xafd3, 0xbac4,
	0xafd4, 0xb5a2,
	0xafd5, 0xb9a2,
	0xafd6, 0xebd7,
	0xafd7, 0xd6ac,
	0xafd8, 0xd2c8,
	0xafd9, 0xd0b2,
	0xafda, 0xebd9,
	0xafdb, 0xebd8,
	0xafdc, 0xb4e0,
	0xafdd, 0xd0d8,
	0xafde, 0xb8ec,
	0xafdf, 0xc2f6,
	0xafe0, 0xc4dc,
	0xafe1, 0xbcb9,
	0xafe2, 0xebdd,
	0xafe3, 0xbfe8,
	0xafe4, 0xb3f4,
	0xafe5, 0xf4ab,
	0xafe6, 0xd2a8,
	0xafe7, 0xf3c2,
	0xafe8, 0xbabd,
	0xafe9, 0xf4b3,
	0xafea, 0xf4b2,
	0xafeb, 0xb0e3,
	0xafec, 0xdbbb,
	0xafed, 0xc3a3,
	0xafee, 0xbbc4,
	0xafef, 0xc0f3,
	0xaff0, 0xbea3,
	0xaff1, 0xc8d7,
	0xaff2, 0xbcf6,
	0xaff3, 0xb2dd,
	0xaff4, 0xd2f0,
	0xaff5, 0xdcee,
	0xaff6, 0xdcf3,
	0xaff7, 0xd7c8,
	0xaff8, 0xc8e3,
	0xaff9, 0xb2e8,
	0xaffa, 0xdcf8,
	0xaffb, 0xdcf7,
	0xaffc, 0xdcef,
	0xaffd, 0xb4c4,
	0xaffe, 0xdcf5,
	0xb040, 0xf2af,
	0xb041, 0xcec3,
	0xb042, 0xf2bd,
	0xb043, 0xf2be,
	0xb044, 0xd4e9,
	0xb045, 0xf2bf,
	0xb046, 0xb0f6,
	0xb047, 0xf2bc,
	0xb048, 0xd1c1,
	0xb049, 0xcba5,
	0xb04a, 0xd6d4,
	0xb04b, 0xd4ac,
	0xb04c, 0xf1c7,
	0xb04d, 0xf1c5,
	0xb04f, 0xbcc7,
	0xb050, 0xdaa6,
	0xb051, 0xccd6,
	0xb052, 0xdaa7,
	0xb053, 0xdaa8,
	0xb054, 0xd1b6,
	0xb056, 0xd1b5,
	0xb057, 0xc6fd,
	0xb05a, 0xc6f1,
	0xb05b, 0xb2f2,
	0xb05c, 0xb1aa,
	0xb05d, 0xb2c6,
	0xb05e, 0xb9b1,
	0xb05f, 0xc6f0,
	0xb060, 0xb9aa,
	0xb061, 0xd0f9,
	0xb062, 0xe9ed,
	0xb064, 0xc8e8,
	0xb065, 0xcbcd,
	0xb066, 0xc4e6,
	0xb067, 0xc3d4,
	0xb068, 0xcdcb,
	0xb06a, 0xbbd8,
	0xb06b, 0xccd3,
	0xb06c, 0xd7b7,
	0xb06d, 0xe5cb,
	0xb06e, 0xb1c5,
	0xb06f, 0xe7df,
	0xb070, 0xbfa4,
	0xb071, 0xbac2,
	0xb072, 0xdbab,
	0xb073, 0xbec6,
	0xb074, 0xc5e4,
	0xb075, 0xd7c3,
	0xb076, 0xb6a4,
	0xb077, 0xd5eb,
	0xb078, 0xeec8,
	0xb079, 0xb8aa,
	0xb07a, 0xeec7,
	0xb07b, 0xc9c1,
	0xb07c, 0xd4ba,
	0xb07d, 0xd5f3,
	0xb07e, 0xb6b8,
	0xb0a1, 0xb1dd,
	0xb0a2, 0xc9c2,
	0xb0a3, 0xb3fd,
	0xb0a4, 0xdaea,
	0xb0a7, 0xbca2,
	0xb0a8, 0xc2ed,
	0xb0a9, 0xb9c7,
	0xb0aa, 0xb8df,
	0xb0ab, 0xb6b7,
	0xb0ac, 0xd8aa,
	0xb0ad, 0xb9ed,
	0xb0ae, 0xc7ac,
	0xb0b0, 0xceb1,
	0xb0b1, 0xcda3,
	0xb0b2, 0xbcd9,
	0xb0b3, 0xd9c8,
	0xb0b4, 0xd9bc,
	0xb0b5, 0xd7f6,
	0xb0b6, 0xceb0,
	0xb0b7, 0xbda1,
	0xb0b8, 0xc5bc,
	0xb0b9, 0xd9cb,
	0xb0ba, 0xd9c9,
	0xb0bb, 0xd5ec,
	0xb0bc, 0xb2e0,
	0xb0bd, 0xcdb5,
	0xb0be, 0xc6ab,
	0xb0bf, 0xd9bf,
	0xb0c2, 0xb6b5,
	0xb0c3, 0xc3e1,
	0xb0c4, 0xbbcb,
	0xb0c5, 0xbcf4,
	0xb0c6, 0xb8b1,
	0xb0c7, 0xc0d5,
	0xb0c8, 0xcef1,
	0xb0c9, 0xbfb1,
	0xb0ca, 0xb6af,
	0xb0cb, 0xd9eb,
	0xb0cc, 0xdecb,
	0xb0cd, 0xb3d7,
	0xb0ce, 0xc4e4,
	0xb0cf, 0xc7f8,
	0xb0d0, 0xd8d2,
	0xb0d1, 0xb2ce,
	0xb0d2, 0xc2fc,
	0xb0d3, 0xc9cc,
	0xb0d4, 0xc5be,
	0xb0d5, 0xc0b2,
	0xb0d6, 0xd7c4,
	0xb0d7, 0xd1c6,
	0xb0d8, 0xb7c8,
	0xb0d9, 0xbfd0,
	0xb0da, 0xb0a1,
	0xb0db, 0xb3aa,
	0xb0dc, 0xe0a2,
	0xb0dd, 0xceca,
	0xb0de, 0xdffb,
	0xb0df, 0xcea8,
	0xb0e0, 0xc6a1,
	0xb0e2, 0xcadb,
	0xb0e3, 0xe0a8,
	0xb0e4, 0xbba3,
	0xb0e6, 0xe0a6,
	0xb0e7, 0xdffa,
	0xb0e9, 0xc8a6,
	0xb0ea, 0xb9fa,
	0xb0eb, 0xe0f6,
	0xb0ec, 0xd3f2,
	0xb0ed, 0xbce1,
	0xb0ee, 0xdbd1,
	0xb0ef, 0xb6d1,
	0xb0f0, 0xb2ba,
	0xb0f1, 0xdbfd,
	0xb0f2, 0xbbf9,
	0xb0f3, 0xccc3,
	0xb0f4, 0xb6c2,
	0xb0f5, 0xd6b4,
	0xb0f6, 0xc5e0,
	0xb0f7, 0xb9bb,
	0xb0f8, 0xc9dd,
	0xb0f9, 0xc8a2,
	0xb0fa, 0xc2a6,
	0xb0fb, 0xcdf1,
	0xb0fc, 0xb8be,
	0xb0fd, 0xc0b7,
	0xb0fe, 0xe6b9,
	0xb140, 0xe6bd,
	0xb141, 0xe6be,
	0xb142, 0xbbe9,
	0xb143, 0xc6c5,
	0xb144, 0xe6bb,
	0xb145, 0xcaeb,
	0xb146, 0xbfdc,
	0xb147, 0xd2fa,
	0xb148, 0xbcc4,
	0xb149, 0xbcc5,
	0xb14a, 0xcbde,
	0xb14b, 0xc3dc,
	0xb14c, 0xcebe,
	0xb14d, 0xd7a8,
	0xb14e, 0xbdab,
	0xb14f, 0xcdc0,
	0xb150, 0xcceb,
	0xb152, 0xb3e7,
	0xb153, 0xe1c7,
	0xb154, 0xc6e9,
	0xb155, 0xe1c8,
	0xb156, 0xd1c2,
	0xb157, 0xe1bf,
	0xb159, 0xb1c0,
	0xb15a, 0xb4de,
	0xb15c, 0xe1c5,
	0xb15d, 0xe1c2,
	0xb15e, 0xb8da,
	0xb15f, 0xb3b2,
	0xb160, 0xb3a3,
	0xb161, 0xb4f8,
	0xb162, 0xd5ca,
	0xb163, 0xe1a1,
	0xb164, 0xbfb5,
	0xb165, 0xd3b9,
	0xb166, 0xcafc,
	0xb167, 0xe2d6,
	0xb168, 0xe2d7,
	0xb169, 0xd5c5,
	0xb16a, 0xc7bf,
	0xb16b, 0xe5e7,
	0xb16c, 0xb1f2,
	0xb16d, 0xb2ca,
	0xb16f, 0xb5c3,
	0xb170, 0xe1e3,
	0xb171, 0xb4d3,
	0xb172, 0xc5c7,
	0xb173, 0xd3f9,
	0xb174, 0xe1e2,
	0xb175, 0xe1e4,
	0xb176, 0xd3c1,
	0xb177, 0xbbbc,
	0xb178, 0xcfa4,
	0xb179, 0xd3c6,
	0xb17a, 0xc4fa,
	0xb17b, 0xcdef,
	0xb17c, 0xe3b2,
	0xb17d, 0xb5eb,
	0xb1a1, 0xc7e9,
	0xb1a2, 0xe3ac,
	0xb1a3, 0xe2ea,
	0xb1a4, 0xcfa7,
	0xb1a5, 0xb5bf,
	0xb1a6, 0xe3af,
	0xb1a7, 0xcce8,
	0xb1a8, 0xe3b0,
	0xb1a9, 0xcea9,
	0xb1aa, 0xbcc2,
	0xb1ab, 0xe3b1,
	0xb1ad, 0xc6dd,
	0xb1ae, 0xeaa9,
	0xb1af, 0xece8,
	0xb1b0, 0xc2d3,
	0xb1b1, 0xbfd8,
	0xb1b2, 0xbeed,
	0xb1b3, 0xd2b4,
	0xb1b4, 0xccbd,
	0xb1b5, 0xbdd3,
	0xb1b6, 0xbddd,
	0xb1b7, 0xc5f5,
	0xb1b8, 0xbef2,
	0xb1b9, 0xb4eb,
	0xb1ba, 0xdedf,
	0xb1bb, 0xd1da,
	0xb1bc, 0xb5f4,
	0xb1bd, 0xc9a8,
	0xb1be, 0xb9d2,
	0xb1bf, 0xded1,
	0xb1c0, 0xcdc6,
	0xb1c1, 0xc2d5,
	0xb1c2, 0xcada,
	0xb1c3, 0xd5f5,
	0xb1c4, 0xb2c9,
	0xb1c5, 0xdee4,
	0xb1c6, 0xc5c5,
	0xb1c7, 0xcccd,
	0xb1c8, 0xcfc6,
	0xb1c9, 0xc4ed,
	0xb1ca, 0xdee6,
	0xb1cb, 0xc9e1,
	0xb1cc, 0xdee0,
	0xb1cd, 0xb1d6,
	0xb1ce, 0xb0bd,
	0xb1cf, 0xbec8,
	0xb1d0, 0xbdcc,
	0xb1d1, 0xb0dc,
	0xb1d2, 0xc6f4,
	0xb1d3, 0xc3f4,
	0xb1d4, 0xd0f0,
	0xb1d5, 0xebb7,
	0xb1d7, 0xd0b1,
	0xb1d8, 0xf5fa,
	0xb1d9, 0xd5b6,
	0xb1da, 0xd7e5,
	0xb1db, 0xd0fd,
	0xb1dc, 0xecba,
	0xb1dd, 0xecbb,
	0xb1de, 0xd6e7,
	0xb1df, 0xcded,
	0xb1e0, 0xceee,
	0xb1e1, 0xb3bf,
	0xb1e2, 0xbbde,
	0xb1e4, 0xb2dc,
	0xb1e6, 0xcdfb,
	0xb1e7, 0xc1ba,
	0xb1e8, 0xccdd,
	0xb1e9, 0xc9d2,
	0xb1ea, 0xe8f7,
	0xb1eb, 0xe8f3,
	0xb1ec, 0xb8cb,
	0xb1ed, 0xcdb0,
	0xb1ef, 0xcee0,
	0xb1f0, 0xb9a3,
	0xb1f1, 0xd0b5,
	0xb1f2, 0xe8e8,
	0xb1f3, 0xc6fa,
	0xb1f4, 0xcbf3,
	0xb1f5, 0xb0f0,
	0xb1f6, 0xc3b7,
	0xb1f7, 0xe8d9,
	0xb1f8, 0xccf5,
	0xb1f9, 0xc0e6,
	0xb1fa, 0xe8c9,
	0xb1fd, 0xd3fb,
	0xb1fe, 0xc9b1,
	0xb240, 0xbac1,
	0xb242, 0xc7e2,
	0xb243, 0xcfd1,
	0xb244, 0xc1b9,
	0xb245, 0xb4be,
	0xb246, 0xe4c8,
	0xb247, 0xd2ba,
	0xb248, 0xb5ad,
	0xb249, 0xccca,
	0xb24a, 0xd3d9,
	0xb24b, 0xcced,
	0xb24c, 0xc7b3,
	0xb24d, 0xc7e5,
	0xb24e, 0xe4bf,
	0xb24f, 0xc1dc,
	0xb250, 0xd1c4,
	0xb251, 0xcae7,
	0xb252, 0xe4cc,
	0xb253, 0xe4c1,
	0xb254, 0xd1cd,
	0xb255, 0xbad4,
	0xb256, 0xbbec,
	0xb257, 0xd4a8,
	0xb258, 0xe4c0,
	0xb259, 0xc6e0,
	0xb25a, 0xe4be,
	0xb25b, 0xbaad,
	0xb25c, 0xc0e1,
	0xb25d, 0xd2f9,
	0xb25e, 0xccd4,
	0xb25f, 0xc2d9,
	0xb260, 0xc9ee,
	0xb261, 0xbbb4,
	0xb262, 0xbebb,
	0xb263, 0xcffd,
	0xb264, 0xd7cd,
	0xb265, 0xb8a2,
	0xb266, 0xb4e3,
	0xb267, 0xe4c3,
	0xb268, 0xe4c6,
	0xb269, 0xc5eb,
	0xb26a, 0xd1c9,
	0xb26b, 0xbab8,
	0xb26c, 0xb7e9,
	0xb26d, 0xcfa9,
	0xb26e, 0xcbac,
	0xb26f, 0xc7a3,
	0xb270, 0xc0e7,
	0xb271, 0xb2c2,
	0xb272, 0xc3cd,
	0xb273, 0xb2fe,
	0xb274, 0xe2a3,
	0xb275, 0xd5f8,
	0xb276, 0xc2ca,
	0xb277, 0xc0c5,
	0xb278, 0xe7f0,
	0xb279, 0xc7f2,
	0xb27a, 0xc0ed,
	0xb27b, 0xcfd6,
	0xb27d, 0xf0ad,
	0xb27e, 0xc6bf,
	0xb2a1, 0xb4c9,
	0xb2a2, 0xccf0,
	0xb2a3, 0xb2fa,
	0xb2a4, 0xc2d4,
	0xb2a5, 0xc6e8,
	0xb2a6, 0xb1cf,
	0xb2a7, 0xd2ec,
	0xb2a8, 0xcae8,
	0xb2a9, 0xd6cc,
	0xb2aa, 0xbadb,
	0xb2ab, 0xb4c3,
	0xb2ac, 0xc8ac,
	0xb2ad, 0xf0ea,
	0xb2ae, 0xf0a8,
	0xb2af, 0xbff8,
	0xb2b0, 0xbad0,
	0xb2b1, 0xcaa2,
	0xb2b2, 0xbeec,
	0xb2b3, 0xd6da,
	0xb2b4, 0xd1db,
	0xb2b5, 0xbff4,
	0xb2b6, 0xedf8,
	0xb2b7, 0xccf7,
	0xb2b8, 0xc1f2,
	0xb2ba, 0xedca,
	0xb2bb, 0xcfe9,
	0xb2bc, 0xc6b1,
	0xb2bd, 0xbcc0,
	0xb2be, 0xd2c6,
	0xb2bf, 0xd6cf,
	0xb2c0, 0xf1bb,
	0xb2c1, 0xf3d2,
	0xb2c2, 0xb1bf,
	0xb2c3, 0xb5d1,
	0xb2c4, 0xb5da,
	0xb2c5, 0xb7fb,
	0xb2c6, 0xf3cf,
	0xb2c7, 0xf3d7,
	0xb2c8, 0xf3d0,
	0xb2c9, 0xc1a3,
	0xb2ca, 0xb4d6,
	0xb2cb, 0xc6c9,
	0xb2cc, 0xb0ed,
	0xb2ce, 0xcdb3,
	0xb2cf, 0xd4fa,
	0xb2d0, 0xc9dc,
	0xb2d1, 0xe7a8,
	0xb2d2, 0xe7a9,
	0xb2d3, 0xcfb8,
	0xb2d4, 0xc9f0,
	0xb2d5, 0xd7e9,
	0xb2d6, 0xc0db,
	0xb2d7, 0xd6d5,
	0xb2d8, 0xe7a5,
	0xb2d9, 0xe7a6,
	0xb2db, 0xd0df,
	0xb2dc, 0xc1e7,
	0xb2dd, 0xd2ee,
	0xb2de, 0xf4e1,
	0xb2df, 0xcfb0,
	0xb2e0, 0xf1ea,
	0xb2e1, 0xc1c4,
	0xb2e2, 0xf1f6,
	0xb2e3, 0xb8ac,
	0xb2e4, 0xb2b1,
	0xb2e6, 0xcdd1,
	0xb2ea, 0xf4a9,
	0xb2eb, 0xb6e6,
	0xb2ec, 0xcfcf,
	0xb2ed, 0xb2b0,
	0xb2ee, 0xb4ac,
	0xb2ef, 0xc9af,
	0xb2f0, 0xddb8,
	0xb2f1, 0xddb7,
	0xb2f2, 0xdda9,
	0xb2f3, 0xbcd4,
	0xb2f4, 0xbea5,
	0xb2f5, 0xc3a7,
	0xb2f6, 0xc4aa,
	0xb2f7, 0xdcec,
	0xb2f8, 0xd7af,
	0xb2f9, 0xddae,
	0xb2fa, 0xc0f2,
	0xb2fb, 0xddac,
	0xb2fc, 0xbac9,
	0xb2fd, 0xddb6,
	0xb2fe, 0xddb1,
	0xb340, 0xc6ce,
	0xb341, 0xdcc8,
	0xb342, 0xb4a6,
	0xb343, 0xb1eb,
	0xb344, 0xc9df,
	0xb345, 0xd6fb,
	0xb346, 0xf2c0,
	0xb347, 0xf2c1,
	0xb348, 0xf2c2,
	0xb349, 0xc7f9,
	0xb34a, 0xb5b0,
	0xb34b, 0xf2c6,
	0xb34c, 0xf2c7,
	0xb34d, 0xf2c8,
	0xb34e, 0xcaf5,
	0xb34f, 0xd9f2,
	0xb350, 0xf4c2,
	0xb351, 0xb1bb,
	0xb352, 0xccbb,
	0xb353, 0xd0e4,
	0xb354, 0xc5db,
	0xb355, 0xb4fc,
	0xb356, 0xc3d9,
	0xb357, 0xb9e6,
	0xb358, 0xb7c3,
	0xb359, 0xd1c8,
	0xb35a, 0xbef7,
	0xb35b, 0xdaab,
	0xb35c, 0xd0ed,
	0xb35d, 0xc9e8,
	0xb35e, 0xcbcf,
	0xb35f, 0xb6ef,
	0xb361, 0xf4f9,
	0xb362, 0xebe0,
	0xb363, 0xb7b7,
	0xb364, 0xd4f0,
	0xb365, 0xb9e1,
	0xb366, 0xbbf5,
	0xb367, 0xccb0,
	0xb368, 0xc6b6,
	0xb369, 0xf4f6,
	0xb36a, 0xc9e2,
	0xb36b, 0xd6ba,
	0xb36c, 0xf5c3,
	0xb36d, 0xe9ee,
	0xb36e, 0xc8ed,
	0xb36f, 0xd5e2,
	0xb370, 0xe5d0,
	0xb371, 0xcda8,
	0xb372, 0xb6ba,
	0xb373, 0xc1ac,
	0xb374, 0xcbd9,
	0xb375, 0xcac5,
	0xb376, 0xd6f0,
	0xb377, 0xe5c9,
	0xb378, 0xb3d1,
	0xb379, 0xd4ec,
	0xb37a, 0xcdb8,
	0xb37b, 0xb7ea,
	0xb37c, 0xe5d1,
	0xb37d, 0xb9e4,
	0xb37e, 0xcdbe,
	0xb3a1, 0xb2bf,
	0xb3a2, 0xb9f9,
	0xb3a3, 0xb6bc,
	0xb3a4, 0xd0ef,
	0xb3a5, 0xd2b0,
	0xb3a6, 0xeece,
	0xb3a8, 0xb5f6,
	0xb3a9, 0xeecb,
	0xb3ab, 0xb7b0,
	0xb3ac, 0xb1d5,
	0xb3ad, 0xc5e3,
	0xb3ae, 0xc1ea,
	0xb3af, 0xb3c2,
	0xb3b0, 0xc2bd,
	0xb3b1, 0xd2f5,
	0xb3b2, 0xdaf0,
	0xb3b3, 0xccd5,
	0xb3b4, 0xcfdd,
	0xb3b5, 0xdaee,
	0xb3b6, 0xc8b8,
	0xb3b7, 0xd1a9,
	0xb3b8, 0xf6a7,
	0xb3b9, 0xd5c2,
	0xb3ba, 0xbeb9,
	0xb3bb, 0xb6a5,
	0xb3bc, 0xc7ea,
	0xb3bd, 0xd3e3,
	0xb3be, 0xc4f1,
	0xb3bf, 0xc2b1,
	0xb3c0, 0xc2b9,
	0xb3c1, 0xc2f3,
	0xb3c2, 0xc2e9,
	0xb3c4, 0xb0f8,
	0xb3c5, 0xb8b5,
	0xb3c6, 0xb1b8,
	0xb3c7, 0xbddc,
	0xb3c8, 0xbffe,
	0xb3c9, 0xd8f7,
	0xb3ca, 0xc9a1,
	0xb3cc, 0xd7ee,
	0xb3cd, 0xbfad,
	0xb3ce, 0xb8ee,
	0xb3cf, 0xd8dc,
	0xb3d0, 0xb4b4,
	0xb3d1, 0xcaa3,
	0xb3d2, 0xc0cd,
	0xb3d3, 0xcaa4,
	0xb3d4, 0xd1ab,
	0xb3d5, 0xb2a9,
	0xb3d6, 0xd8ca,
	0xb3d7, 0xe0b4,
	0xb3d8, 0xbfa6,
	0xb3d9, 0xd0fa,
	0xb3da, 0xcce4,
	0xb3db, 0xbab0,
	0xb3dc, 0xbac8,
	0xb3dd, 0xb4ad,
	0xb3de, 0xceb9,
	0xb3df, 0xcfb2,
	0xb3e0, 0xc9a5,
	0xb3e1, 0xe0b8,
	0xb3e2, 0xc0ae,
	0xb3e3, 0xe0a9,
	0xb3e4, 0xe0ab,
	0xb3e5, 0xd4fb,
	0xb3e6, 0xb5a5,
	0xb3e7, 0xe0b0,
	0xb3e8, 0xcdd9,
	0xb3e9, 0xd3b4,
	0xb3ea, 0xbbbd,
	0xb3eb, 0xd3f7,
	0xb3ec, 0xc7c7,
	0xb3ed, 0xe0ac,
	0xb3ee, 0xe0b1,
	0xb3ef, 0xbaed,
	0xb3f1, 0xe0b9,
	0xb3f2, 0xcea7,
	0xb3f3, 0xd2a2,
	0xb3f4, 0xbfb0,
	0xb3f5, 0xb3a1,
	0xb3f6, 0xb5cc,
	0xb3f7, 0xd1df,
	0xb3f8, 0xb1a8,
	0xb3f9, 0xb1a4,
	0xb3fa, 0xdbf6,
	0xb3fb, 0xdca9,
	0xb3fc, 0xd2bc,
	0xb3fd, 0xbaf8,
	0xb3fe, 0xb5ec,
	0xb440, 0xe6c3,
	0xb441, 0xc3c4,
	0xb442, 0xd0f6,
	0xb443, 0xc3bd,
	0xb444, 0xe6c2,
	0xb445, 0xe6b4,
	0xb446, 0xe6dc,
	0xb447, 0xe5ee,
	0xb448, 0xbaae,
	0xb449, 0xb8bb,
	0xb44a, 0xd4a2,
	0xb44b, 0xc3c2,
	0xb44c, 0xd7f0,
	0xb44d, 0xd1b0,
	0xb44e, 0xbecd,
	0xb44f, 0xc7b6,
	0xb450, 0xe1b0,
	0xb451, 0xe1cb,
	0xb452, 0xeffa,
	0xb453, 0xd9e3,
	0xb454, 0xb7f9,
	0xb455, 0xc3b1,
	0xb456, 0xd6a1,
	0xb457, 0xe0f8,
	0xb458, 0xbcb8,
	0xb459, 0xc0c8,
	0xb45a, 0xb2de,
	0xb45b, 0xcfe1,
	0xb45c, 0xbec7,
	0xb45d, 0xe5f6,
	0xb45e, 0xc5ed,
	0xb45f, 0xb8b4,
	0xb460, 0xd1ad,
	0xb461, 0xe1e5,
	0xb462, 0xbbf3,
	0xb463, 0xb6f1,
	0xb464, 0xb1af,
	0xb465, 0xc3c6,
	0xb466, 0xbbdd,
	0xb467, 0xe3ab,
	0xb468, 0xe3b6,
	0xb469, 0xd0ca,
	0xb46a, 0xe3b5,
	0xb46b, 0xb6e8,
	0xb46c, 0xe2fc,
	0xb46d, 0xe3b7,
	0xb46e, 0xbfae,
	0xb46f, 0xc4d5,
	0xb470, 0xe3b9,
	0xb471, 0xbbcc,
	0xb472, 0xd3e4,
	0xb473, 0xe3b8,
	0xb475, 0xeaaa,
	0xb476, 0xece9,
	0xb477, 0xb3b8,
	0xb478, 0xd5c6,
	0xb479, 0xc3e8,
	0xb47a, 0xbcf0,
	0xb47b, 0xbfab,
	0xb47c, 0xc8e0,
	0xb47d, 0xdef1,
	0xb47e, 0xd7e1,
	0xb4a1, 0xb2e5,
	0xb4a2, 0xb4a7,
	0xb4a3, 0xcce1,
	0xb4a4, 0xced5,
	0xb4a5, 0xd2be,
	0xb4a6, 0xbdd2,
	0xb4a7, 0xbbd3,
	0xb4a8, 0xb4b7,
	0xb4a9, 0xd4ae,
	0xb4aa, 0xbebe,
	0xb4ab, 0xbbbb,
	0xb4ac, 0xdef0,
	0xb4ad, 0xd1ef,
	0xb4af, 0xb3a8,
	0xb4b0, 0xb6d8,
	0xb4b1, 0xb8d2,
	0xb4b2, 0xc9a2,
	0xb4b3, 0xb0df,
	0xb4b4, 0xecb3,
	0xb4b5, 0xcbb9,
	0xb4b6, 0xc6d5,
	0xb4b7, 0xcefa,
	0xb4b8, 0xc7e7,
	0xb4b9, 0xbea7,
	0xb4ba, 0xbeb0,
	0xb4bb, 0xcaee,
	0xb4bc, 0xd6c7,
	0xb4bd, 0xc1c0,
	0xb4be, 0xead0,
	0xb4bf, 0xd4f8,
	0xb4c0, 0xcce6,
	0xb4c1, 0xc6da,
	0xb4c2, 0xb3af,
	0xb4c3, 0xb9d7,
	0xb4c4, 0xd7d8,
	0xb4c5, 0xccc4,
	0xb4c6, 0xbcac,
	0xb4c7, 0xd4e6,
	0xb4c8, 0xd2ce,
	0xb4c9, 0xb6b0,
	0xb4ca, 0xbfc3,
	0xb4cb, 0xc9ad,
	0xb4cc, 0xd5bb,
	0xb4cd, 0xe8fe,
	0xb4ce, 0xb0f4,
	0xb4cf, 0xc6dc,
	0xb4d0, 0xe9a6,
	0xb4d1, 0xc6e5,
	0xb4d2, 0xb9f7,
	0xb4d3, 0xd6b2,
	0xb4d4, 0xbdb7,
	0xb4d5, 0xd7b5,
	0xb4d6, 0xc3de,
	0xb4d7, 0xc5ef,
	0xb4d8, 0xe8fa,
	0xb4da, 0xbfee,
	0xb4db, 0xc6db,
	0xb4dc, 0xc7d5,
	0xb4dd, 0xb2d0,
	0xb4de, 0xd6b3,
	0xb4df, 0xbfc7,
	0xb4e0, 0xccba,
	0xb4e1, 0xb5aa,
	0xb4e2, 0xc2c8,
	0xb4e3, 0xebb2,
	0xb4e4, 0xb8db,
	0xb4e5, 0xd3ce,
	0xb4e6, 0xe4d5,
	0xb4e7, 0xb6c9,
	0xb4e8, 0xe4d6,
	0xb4e9, 0xd3bf,
	0xb4ea, 0xb4d5,
	0xb4eb, 0xc7fe,
	0xb4ec, 0xe4d7,
	0xb4ed, 0xd4fc,
	0xb4ee, 0xbcf5,
	0xb4ef, 0xd5bf,
	0xb4f0, 0xcfe6,
	0xb4f1, 0xb2b3,
	0xb4f2, 0xbafe,
	0xb4f3, 0xe4ce,
	0xb4f4, 0xcebc,
	0xb4f5, 0xced0,
	0xb4f6, 0xccc0,
	0xb4f7, 0xbfca,
	0xb4f8, 0xcdc4,
	0xb4f9, 0xc3ec,
	0xb4fa, 0xb2e2,
	0xb4fb, 0xc5c8,
	0xb4fc, 0xd3e5,
	0xb4fd, 0xbbeb,
	0xb4fe, 0xd7cc,
	0xb540, 0xb8c8,
	0xb541, 0xbbc1,
	0xb542, 0xe4cf,
	0xb544, 0xe4d8,
	0xb547, 0xe4d2,
	0xb548, 0xb1ba,
	0xb549, 0xb7d9,
	0xb54a, 0xbdb9,
	0xb54c, 0xcede,
	0xb54d, 0xc8bb,
	0xb54e, 0xd6f3,
	0xb550, 0xc5c6,
	0xb551, 0xeaf7,
	0xb552, 0xcfac,
	0xb553, 0xd3cc,
	0xb554, 0xe2ab,
	0xb555, 0xbaef,
	0xb556, 0xd0c9,
	0xb557, 0xb7a9,
	0xb558, 0xe7f7,
	0xb559, 0xc1d5,
	0xb55a, 0xd7c1,
	0xb55b, 0xe7fa,
	0xb55c, 0xc5fd,
	0xb55d, 0xc5c3,
	0xb55e, 0xc7d9,
	0xb560, 0xe8a1,
	0xb561, 0xe7f9,
	0xb562, 0xe7fb,
	0xb563, 0xc9fb,
	0xb565, 0xbbad,
	0xb566, 0xb7ac,
	0xb567, 0xc1a1,
	0xb568, 0xcdb4,
	0xb569, 0xf0eb,
	0xb56a, 0xbeb7,
	0xb56b, 0xb6bb,
	0xb56c, 0xc6a6,
	0xb56e, 0xb5c7,
	0xb56f, 0xb7a2,
	0xb570, 0xcdee,
	0xb571, 0xf0a9,
	0xb572, 0xf1e5,
	0xb573, 0xb5c1,
	0xb575, 0xb6cc,
	0xb576, 0xcff5,
	0xb577, 0xd3b2,
	0xb578, 0xd1e2,
	0xb579, 0xc9d4,
	0xb57a, 0xb8d1,
	0xb57b, 0xb3cc,
	0xb57c, 0xcbb0,
	0xb57d, 0xcfa1,
	0xb57e, 0xbebd,
	0xb5a1, 0xb4b0,
	0xb5a2, 0xbdd1,
	0xb5a3, 0xcdaf,
	0xb5a4, 0xbfa2,
	0xb5a5, 0xb5c8,
	0xb5a6, 0xb2df,
	0xb5a7, 0xb1ca,
	0xb5a8, 0xbff0,
	0xb5a9, 0xcdb2,
	0xb5aa, 0xb4f0,
	0xb5ab, 0xcbf1,
	0xb5ac, 0xbdee,
	0xb5ad, 0xb7a4,
	0xb5af, 0xcbda,
	0xb5b0, 0xd6e0,
	0xb5b1, 0xbdca,
	0xb5b2, 0xbde1,
	0xb5b3, 0xc8de,
	0xb5b4, 0xbef8,
	0xb5b5, 0xd7cf,
	0xb5b6, 0xd0f5,
	0xb5b7, 0xcbbf,
	0xb5b8, 0xc2e7,
	0xb5b9, 0xb8f8,
	0xb5ba, 0xd1a4,
	0xb5bc, 0xe7ad,
	0xb5bd, 0xc9c6,
	0xb5be, 0xcfe8,
	0xb5bf, 0xf4e2,
	0xb5c0, 0xf1f3,
	0xb5c1, 0xf1f8,
	0xb5c2, 0xcbe0,
	0xb5c3, 0xcdf3,
	0xb5c4, 0xc7bb,
	0xb5c5, 0xd2b8,
	0xb5c6, 0xb8ad,
	0xb5c7, 0xc9f6,
	0xb5c8, 0xd5cd,
	0xb5c9, 0xccf3,
	0xb5ca, 0xc6a2,
	0xb5cb, 0xebe7,
	0xb5cc, 0xebe8,
	0xb5cd, 0xebe9,
	0xb5ce, 0xcae6,
	0xb5cf, 0xcbb4,
	0xb5d0, 0xc6d0,
	0xb5d1, 0xddcd,
	0xb5d2, 0xddce,
	0xb5d3, 0xc6bc,
	0xb5d4, 0xb2a4,
	0xb5d5, 0xddd1,
	0xb5d6, 0xddc2,
	0xb5d7, 0xddbc,
	0xb5d8, 0xbbaa,
	0xb5d9, 0xc1e2,
	0xb5db, 0xd6f8,
	0xb5db, 0xd7c5,
	0xb5dc, 0xc0b3,
	0xb5dd, 0xddd4,
	0xb5de, 0xc3c8,
	0xb5df, 0xbefa,
	0xb5e0, 0xddc4,
	0xb5e1, 0xb7c6,
	0xb5e2, 0xbed5,
	0xb5e3, 0xddc7,
	0xb5e4, 0xceae,
	0xb5e5, 0xccd1,
	0xb5e6, 0xb2cb,
	0xb5e7, 0xdcc9,
	0xb5e8, 0xddca,
	0xb5e9, 0xddcb,
	0xb5ea, 0xd0e9,
	0xb5eb, 0xf2d4,
	0xb5ec, 0xcddc,
	0xb5ed, 0xf2ce,
	0xb5ee, 0xbbd7,
	0xb5ef, 0xd6eb,
	0xb5f0, 0xb8f2,
	0xb5f1, 0xf2d0,
	0xb5f2, 0xf2d2,
	0xb5f3, 0xbdd6,
	0xb5f4, 0xb2c3,
	0xb5f5, 0xc1d1,
	0xb5f6, 0xb8a4,
	0xb5f7, 0xf1fb,
	0xb5f8, 0xcad3,
	0xb5f9, 0xd7a2,
	0xb5fa, 0xd3bd,
	0xb5fb, 0xc6c0,
	0xb5fc, 0xb4ca,
	0xb5fd, 0xd6a4,
	0xb5fe, 0xdaac,
	0xb640, 0xdaaf,
	0xb641, 0xd7e7,
	0xb642, 0xd5a9,
	0xb643, 0xdaae,
	0xb644, 0xcbdf,
	0xb645, 0xd5ef,
	0xb646, 0xdaad,
	0xb648, 0xcff3,
	0xb649, 0xf5f5,
	0xb64a, 0xd6fc,
	0xb64b, 0xccf9,
	0xb64c, 0xb7a1,
	0xb64d, 0xeadd,
	0xb64e, 0xeada,
	0xb64f, 0xb7d1,
	0xb650, 0xbad8,
	0xb651, 0xb9f3,
	0xb652, 0xc2f2,
	0xb653, 0xb1e1,
	0xb654, 0xc3b3,
	0xb655, 0xb4fb,
	0xb656, 0xd4bd,
	0xb657, 0xb3ac,
	0xb658, 0xb3c3,
	0xb659, 0xf5c9,
	0xb65a, 0xbee0,
	0xb65b, 0xb0cf,
	0xb65c, 0xf5c7,
	0xb65d, 0xc5dc,
	0xb65e, 0xb5f8,
	0xb65f, 0xf5cb,
	0xb660, 0xf5cc,
	0xb661, 0xe9f0,
	0xb662, 0xd6e1,
	0xb663, 0xe9f3,
	0xb664, 0xb9bc,
	0xb665, 0xb4fe,
	0xb666, 0xe5d3,
	0xb667, 0xd6dc,
	0xb668, 0xd2dd,
	0xb669, 0xbdf8,
	0xb66a, 0xe5d4,
	0xb66b, 0xb6f5,
	0xb66c, 0xd3ca,
	0xb66d, 0xcfe7,
	0xb66e, 0xdbb1,
	0xb66f, 0xbaa8,
	0xb670, 0xcbd6,
	0xb671, 0xc1bf,
	0xb672, 0xb3ae,
	0xb673, 0xc5a5,
	0xb674, 0xb8c6,
	0xb675, 0xc4c6,
	0xb676, 0xbefb,
	0xb677, 0xb6db,
	0xb678, 0xeed4,
	0xb67a, 0xeed3,
	0xb67b, 0xe3c9,
	0xb67c, 0xc8f2,
	0xb67d, 0xbfaa,
	0xb67e, 0xcfd0,
	0xb6a1, 0xbce4,
	0xb6a3, 0xe3c8,
	0xb6a4, 0xb6d3,
	0xb6a5, 0xbdd7,
	0xb6a6, 0xcbe5,
	0xb6a7, 0xd1f4,
	0xb6a8, 0xd3e7,
	0xb6a9, 0xc2a1,
	0xb6aa, 0xdaf2,
	0xb6ab, 0xdaef,
	0xb6ad, 0xd1e3,
	0xb6ae, 0xd1c5,
	0xb6af, 0xd0db,
	0xb6b0, 0xbcaf,
	0xb6b1, 0xb9cd,
	0xb6b2, 0xf6a9,
	0xb6b3, 0xd4c6,
	0xb6b4, 0xc8cd,
	0xb6b5, 0xcfee,
	0xb6b6, 0xcbb3,
	0xb6b7, 0xd0eb,
	0xb6b8, 0xe2b8,
	0xb6b9, 0xe2bf,
	0xb6ba, 0xb7b9,
	0xb6bb, 0xe2bd,
	0xb6bc, 0xd2fb,
	0xb6bd, 0xe2c1,
	0xb6be, 0xb7eb,
	0xb6bf, 0xd4a6,
	0xb6c0, 0xbbc6,
	0xb6c1, 0xcaf2,
	0xb6c2, 0xbada,
	0xb6c3, 0xc2d2,
	0xb6c4, 0xd3b6,
	0xb6c5, 0xd5ae,
	0xb6c6, 0xb0c1,
	0xb6c7, 0xb4ab,
	0xb6c8, 0xbdf6,
	0xb6c9, 0xc7e3,
	0xb6ca, 0xb4df,
	0xb6cb, 0xc9cb,
	0xb6cc, 0xc9b5,
	0xb6cd, 0xd9cc,
	0xb6cf, 0xbdcb,
	0xb6d1, 0xd8e2,
	0xb6d2, 0xc4bc,
	0xb6d4, 0xc7da,
	0xb6d5, 0xcac6,
	0xb6d7, 0xbbe3,
	0xb6d8, 0xe0b5,
	0xb6d9, 0xe0cb,
	0xb6da, 0xc9a4,
	0xb6db, 0xe0c2,
	0xb6dc, 0xc2f0,
	0xb6dd, 0xcac8,
	0xb6de, 0xd8c4,
	0xb6df, 0xe0be,
	0xb6e0, 0xcbc3,
	0xb6e1, 0xe0cd,
	0xb6e2, 0xe0c5,
	0xb6e3, 0xced8,
	0xb6e4, 0xcecb,
	0xb6e5, 0xd0e1,
	0xb6e6, 0xc7ba,
	0xb6e7, 0xe0c6,
	0xb6e8, 0xe0bc,
	0xb6e9, 0xd4b0,
	0xb6ea, 0xd4b2,
	0xb6eb, 0xc8fb,
	0xb6ec, 0xcbdc,
	0xb6ed, 0xccc1,
	0xb6ee, 0xcdbf,
	0xb6ef, 0xdaa3,
	0xb6f0, 0xcbfe,
	0xb6f1, 0xccee,
	0xb6f2, 0xcbfa,
	0xb6f4, 0xbfe9,
	0xb6f5, 0xceeb,
	0xb6f6, 0xdbf5,
	0xb6f7, 0xdce3,
	0xb6f8, 0xb0c2,
	0xb6f9, 0xbcde,
	0xb6fa, 0xbcb5,
	0xb6fb, 0xcfd3,
	0xb6fc, 0xe6c5,
	0xb6fd, 0xc2e8,
	0xb6fe, 0xe6c1,
	0xb740, 0xcfb1,
	0xb741, 0xc9a9,
	0xb742, 0xe6c7,
	0xb743, 0xe1d4,
	0xb744, 0xe1cf,
	0xb745, 0xbbcf,
	0xb746, 0xb8c9,
	0xb747, 0xc1ae,
	0xb748, 0xcfc3,
	0xb749, 0xdfb1,
	0xb74a, 0xbbe3,
	0xb74c, 0xcea2,
	0xb74d, 0xd3de,
	0xb74e, 0xd2e2,
	0xb74f, 0xb4c8,
	0xb750, 0xb8d0,
	0xb751, 0xcfeb,
	0xb752, 0xb0ae,
	0xb753, 0xc8c7,
	0xb754, 0xb3ee,
	0xb755, 0xd3fa,
	0xb756, 0xc9f7,
	0xb757, 0xbbc5,
	0xb759, 0xe3b3,
	0xb75a, 0xe2e9,
	0xb75b, 0xe2eb,
	0xb75c, 0xc0a2,
	0xb75d, 0xedaa,
	0xb75e, 0xeda9,
	0xb75f, 0xe2fd,
	0xb760, 0xeaac,
	0xb761, 0xeaab,
	0xb762, 0xb4ea,
	0xb764, 0xb8e3,
	0xb765, 0xccc2,
	0xb766, 0xb4ee,
	0xb767, 0xb2eb,
	0xb768, 0xb0e1,
	0xb769, 0xb2ab,
	0xb76a, 0xcbd1,
	0xb76b, 0xc9a6,
	0xb76c, 0xcbf0,
	0xb76d, 0xc7c0,
	0xb76e, 0xd2a1,
	0xb76f, 0xb5b7,
	0xb771, 0xbeb4,
	0xb772, 0xd5e5,
	0xb773, 0xd0c2,
	0xb774, 0xb0b5,
	0xb775, 0xeacd,
	0xb776, 0xcfbe,
	0xb777, 0xd4ce,
	0xb778, 0xc5af,
	0xb779, 0xead1,
	0xb77c, 0xbbe1,
	0xb77d, 0xc0c6,
	0xb77e, 0xd2b5,
	0xb7a1, 0xb3fe,
	0xb7a2, 0xbfac,
	0xb7a3, 0xe9aa,
	0xb7a4, 0xd0a8,
	0xb7a5, 0xbcab,
	0xb7a6, 0xd2ac,
	0xb7a7, 0xb8c5,
	0xb7a8, 0xd1ee,
	0xb7a9, 0xe8e5,
	0xb7aa, 0xe9ae,
	0xb7ab, 0xc0e3,
	0xb7ac, 0xb7e3,
	0xb7ad, 0xe9ba,
	0xb7ae, 0xd3dc,
	0xb7af, 0xe9ac,
	0xb7b0, 0xe9b9,
	0xb7b2, 0xd0aa,
	0xb7b3, 0xcbea,
	0xb7b4, 0xbbd9,
	0xb7b5, 0xb5ee,
	0xb7b6, 0xd8b9,
	0xb7b7, 0xeba6,
	0xb7b8, 0xd2e7,
	0xb7b9, 0xcbdd,
	0xb7ba, 0xd7d2,
	0xb7bb, 0xc8dc,
	0xb7bc, 0xe4e8,
	0xb7bd, 0xd4b4,
	0xb7be, 0xb9b5,
	0xb7bf, 0xb5e1,
	0xb7c0, 0xc3f0,
	0xb7c1, 0xe4df,
	0xb7c2, 0xe4db,
	0xb7c4, 0xc4e7,
	0xb7c5, 0xcec2,
	0xb7c6, 0xbbac,
	0xb7c7, 0xd7bc,
	0xb7c8, 0xc1ef,
	0xb7c9, 0xb2d7,
	0xb7ca, 0xcccf,
	0xb7cb, 0xcfaa,
	0xb7cc, 0xe4e0,
	0xb7cd, 0xe4e5,
	0xb7ce, 0xbce5,
	0xb7cf, 0xd1cc,
	0xb7d0, 0xb7b3,
	0xb7d1, 0xc3ba,
	0xb7d2, 0xc1b6,
	0xb7d3, 0xd5d5,
	0xb7d4, 0xeccf,
	0xb7d5, 0xecbe,
	0xb7d6, 0xece3,
	0xb7d7, 0xbbcd,
	0xb7d8, 0xbbc0,
	0xb7d9, 0xc9b7,
	0xb7db, 0xecd0,
	0xb7dd, 0xd2af,
	0xb7de, 0xebba,
	0xb7df, 0xe9e0,
	0xb7e0, 0xcaa8,
	0xb7e1, 0xd4b3,
	0xb7e2, 0xbbab,
	0xb7e4, 0xbaf7,
	0xb7e5, 0xe8a6,
	0xb7e6, 0xc9aa,
	0xb7e7, 0xc8f0,
	0xb7e8, 0xe8a3,
	0xb7e9, 0xe7f5,
	0xb7ea, 0xe8a7,
	0xb7eb, 0xe7f8,
	0xb7ec, 0xe8a4,
	0xb7ed, 0xb5b1,
	0xb7ee, 0xbbfb,
	0xb7ef, 0xf0f6,
	0xb7f0, 0xccb5,
	0xb7f1, 0xb4e1,
	0xb7f3, 0xf0f2,
	0xb7f4, 0xb1d4,
	0xb7f5, 0xf0f4,
	0xb7f6, 0xb3d5,
	0xb7f8, 0xd5b5,
	0xb7f9, 0xc3cb,
	0xb7fa, 0xbea6,
	0xb7fb, 0xbdde,
	0xb7fc, 0xc4c0,
	0xb7fd, 0xedf9,
	0xb7fe, 0xb6bd,
	0xb840, 0xb6c3,
	0xb841, 0xd8ba,
	0xb842, 0xb2c7,
	0xb843, 0xd5f6,
	0xb844, 0xeea2,
	0xb845, 0xedfe,
	0xb846, 0xeea1,
	0xb847, 0xb0ab,
	0xb848, 0xcbe9,
	0xb849, 0xc5f6,
	0xb84a, 0xcdeb,
	0xb84b, 0xb5e2,
	0xb84c, 0xc2b5,
	0xb84d, 0xb5ef,
	0xb84e, 0xc5f0,
	0xb84f, 0xb1ae,
	0xb850, 0xedd4,
	0xb852, 0xecf7,
	0xb853, 0xc2bb,
	0xb854, 0xbdfb,
	0xb855, 0xcdf2,
	0xb856, 0xc7dd,
	0xb858, 0xd6c9,
	0xb859, 0xb3ed,
	0xb85a, 0xeffe,
	0xb85b, 0xd9f7,
	0xb85c, 0xeffd,
	0xb85d, 0xbfdf,
	0xb85e, 0xf1bd,
	0xb85f, 0xbfea,
	0xb860, 0xbdda,
	0xb861, 0xf3de,
	0xb862, 0xf3df,
	0xb863, 0xf3c8,
	0xb864, 0xc1bb,
	0xb865, 0xbeac,
	0xb866, 0xd4c1,
	0xb867, 0xbead,
	0xb868, 0xbeee,
	0xb86a, 0xb0f3,
	0xb86b, 0xcbe7,
	0xb86c, 0xccd0,
	0xb86d, 0xd6c3,
	0xb86e, 0xd5d6,
	0xb86f, 0xd7ef,
	0xb870, 0xcaf0,
	0xb871, 0xd2e5,
	0xb872, 0xcfdb,
	0xb873, 0xc8ba,
	0xb874, 0xcaa5,
	0xb875, 0xc6b8,
	0xb876, 0xcbc1,
	0xb877, 0xd2de,
	0xb878, 0xebec,
	0xb879, 0xd1fc,
	0xb87a, 0xb3a6,
	0xb87b, 0xd0c8,
	0xb87c, 0xc8f9,
	0xb87d, 0xbdc5,
	0xb87e, 0xd6d7,
	0xb8a1, 0xb8b9,
	0xb8a2, 0xcfd9,
	0xb8a3, 0xc4d4,
	0xb8a4, 0xbecb,
	0xb8a5, 0xcda7,
	0xb8a6, 0xb5d9,
	0xb8a7, 0xbbe7,
	0xb8a8, 0xc2e4,
	0xb8a9, 0xdde6,
	0xb8aa, 0xbffb,
	0xb8ab, 0xcead,
	0xb8ac, 0xbaf9,
	0xb8ad, 0xd2b6,
	0xb8ae, 0xd4e1,
	0xb8af, 0xb8f0,
	0xb8b0, 0xdde0,
	0xb8b1, 0xddab,
	0xb8b2, 0xc6cf,
	0xb8b3, 0xb6ad,
	0xb8b4, 0xdde2,
	0xb8b5, 0xdde7,
	0xb8b6, 0xdde1,
	0xb8b7, 0xd3dd,
	0xb8b8, 0xc2b2,
	0xb8b9, 0xbac5,
	0xb8ba, 0xd3bc,
	0xb8bb, 0xf2d1,
	0xb8bc, 0xf2da,
	0xb8bd, 0xf2d8,
	0xb8be, 0xcaf1,
	0xb8bf, 0xb6ea,
	0xb8c0, 0xcdc9,
	0xb8c1, 0xb7e4,
	0xb8c2, 0xf2d7,
	0xb8c3, 0xf2b9,
	0xb8c4, 0xf2db,
	0xb8c5, 0xd1c3,
	0xb8c6, 0xf4c4,
	0xb8c7, 0xd2e1,
	0xb8c8, 0xc8b9,
	0xb8c9, 0xb2b9,
	0xb8ca, 0xf4c3,
	0xb8cb, 0xd7b0,
	0xb8cc, 0xc0ef,
	0xb8cd, 0xf4c1,
	0xb8ce, 0xd4a3,
	0xb8cf, 0xd9f6,
	0xb8d1, 0xbde2,
	0xb8d2, 0xb2ef,
	0xb8d3, 0xb8c3,
	0xb8d4, 0xcfea,
	0xb8d5, 0xcad4,
	0xb8d6, 0xcaab,
	0xb8d7, 0xdab5,
	0xb8d9, 0xdab6,
	0xb8da, 0xd2e8,
	0xb8db, 0xb3cf,
	0xb8dc, 0xbbb0,
	0xb8dd, 0xd6ef,
	0xb8de, 0xb9ee,
	0xb8df, 0xd1af,
	0xb8e0, 0xdab9,
	0xb8e1, 0xdab8,
	0xb8e2, 0xd5b2,
	0xb8e4, 0xf6a4,
	0xb8e6, 0xbbbf,
	0xb8e7, 0xf5f6,
	0xb8e8, 0xbad1,
	0xb8e9, 0xd4f4,
	0xb8ea, 0xd7ca,
	0xb8eb, 0xbcd6,
	0xb8ec, 0xbbdf,
	0xb8ed, 0xeadf,
	0xb8ee, 0xc1de,
	0xb8ef, 0xc2b8,
	0xb8f0, 0xeae0,
	0xb8f1, 0xbca3,
	0xb8f2, 0xb8fa,
	0xb8f3, 0xbfe7,
	0xb8f4, 0xc2b7,
	0xb8f5, 0xccf8,
	0xb8f6, 0xb6e5,
	0xb8f7, 0xb9f2,
	0xb8f8, 0xf5d3,
	0xb8fa, 0xb6e3,
	0xb8fb, 0xbdcf,
	0xb8fc, 0xd4d8,
	0xb8fd, 0xe9f8,
	0xb8fe, 0xe9f9,
	0xb940, 0xb1d9,
	0xb941, 0xc5a9,
	0xb942, 0xd4cb,
	0xb943, 0xd3ce,
	0xb944, 0xb5c0,
	0xb945, 0xcbec,
	0xb946, 0xb4ef,
	0xb947, 0xb1c6,
	0xb948, 0xcea5,
	0xb949, 0xe5da,
	0xb94a, 0xd3f6,
	0xb94b, 0xb6f4,
	0xb94c, 0xb9fd,
	0xb94d, 0xb1e9,
	0xb94e, 0xe5d8,
	0xb94f, 0xd3e2,
	0xb950, 0xb6dd,
	0xb951, 0xd7de,
	0xb953, 0xb3ea,
	0xb954, 0xc0d2,
	0xb955, 0xf5a4,
	0xb956, 0xd3d4,
	0xb957, 0xeedc,
	0xb958, 0xc7af,
	0xb959, 0xeee0,
	0xb95a, 0xeedf,
	0xb95b, 0xbcd8,
	0xb95c, 0xd3cb,
	0xb95d, 0xc7a6,
	0xb95f, 0xb9b3,
	0xb960, 0xb2ac,
	0xb961, 0xc1e5,
	0xb962, 0xeee7,
	0xb963, 0xeee9,
	0xb964, 0xeed2,
	0xb965, 0xeeeb,
	0xb966, 0xeee4,
	0xb967, 0xc3ad,
	0xb968, 0xd5a2,
	0xb969, 0xb0af,
	0xb96a, 0xb8f4,
	0xb96b, 0xd4c9,
	0xb96c, 0xd3ba,
	0xb96d, 0xf6c1,
	0xb96e, 0xeff4,
	0xb970, 0xc0d7,
	0xb971, 0xb5e7,
	0xb972, 0xb1a2,
	0xb973, 0xc1e3,
	0xb974, 0xbeb8,
	0xb975, 0xd1a5,
	0xb976, 0xb0d0,
	0xb977, 0xd4a4,
	0xb978, 0xcde7,
	0xb979, 0xb6d9,
	0xb97a, 0xe7ef,
	0xb97b, 0xb0e4,
	0xb97c, 0xcbcc,
	0xb97d, 0xcbc7,
	0xb97e, 0xe2c2,
	0xb9a1, 0xb1a5,
	0xb9a2, 0xcace,
	0xb9a3, 0xb3db,
	0xb9a4, 0xcdd4,
	0xb9a5, 0xd1b1,
	0xb9a6, 0xf7d5,
	0xb9a7, 0xf0af,
	0xb9a8, 0xf7e4,
	0xb9a9, 0xb6a6,
	0xb9aa, 0xb9c4,
	0xb9ab, 0xcaf3,
	0xb9ac, 0xc9ae,
	0xb9ad, 0xd9d7,
	0xb9ae, 0xbdc4,
	0xb9af, 0xd9d2,
	0xb9b0, 0xd9d4,
	0xb9b1, 0xc1c5,
	0xb9b2, 0xc6cd,
	0xb9b3, 0xcff1,
	0xb9b4, 0xc7c8,
	0xb9b8, 0xbea4,
	0xb9b9, 0xb5ca,
	0xb9ba, 0xbbae,
	0xb9bb, 0xd8e3,
	0xb9bc, 0xd8d1,
	0xb9bd, 0xd1e1,
	0xb9be, 0xe0d5,
	0xb9bf, 0xe0d6,
	0xb9c0, 0xc2ef,
	0xb9c1, 0xb3a2,
	0xb9c2, 0xcbd4,
	0xb9c3, 0xc5bb,
	0xb9c4, 0xccbe,
	0xb9c5, 0xbcce,
	0xb9c6, 0xe0b6,
	0xb9c7, 0xb8c2,
	0xb9c8, 0xe0bb,
	0xb9c9, 0xdff5,
	0xb9ca, 0xe0bd,
	0xb9cb, 0xe0d0,
	0xb9cd, 0xdfd9,
	0xb9ce, 0xcdc5,
	0xb9cf, 0xcdbc,
	0xb9d0, 0xb3be,
	0xb9d1, 0xdbd3,
	0xb9d2, 0xbeb3,
	0xb9d3, 0xc4b9,
	0xb9d4, 0xb5e6,
	0xb9d5, 0xc7b5,
	0xb9d6, 0xcafb,
	0xb9d8, 0xcad9,
	0xb9d9, 0xe2b7,
	0xb9da, 0xc3ce,
	0xb9db, 0xe2b9,
	0xb9dc, 0xb6e1,
	0xb9dd, 0xdec6,
	0xb9de, 0xb5d5,
	0xb9df, 0xe6cf,
	0xb9e0, 0xc4db,
	0xb9e1, 0xe5fd,
	0xb9e2, 0xe6ce,
	0xb9e3, 0xe6d0,
	0xb9e4, 0xe6cc,
	0xb9e5, 0xb7f5,
	0xb9e6, 0xc4af,
	0xb9e7, 0xc4fe,
	0xb9e8, 0xb9d1,
	0xb9e9, 0xc1c8,
	0xb9ea, 0xcab5,
	0xb9eb, 0xd5af,
	0xb9ec, 0xc7de,
	0xb9ed, 0xe5bb,
	0xb9ee, 0xb2ec,
	0xb9ef, 0xb6d4,
	0xb9f0, 0xc2c5,
	0xb9f1, 0xd5b8,
	0xb9f2, 0xe1ab,
	0xb9f3, 0xe1a4,
	0xb9f4, 0xb1d2,
	0xb9f5, 0xc4bb,
	0xb9f6, 0xe0fe,
	0xb9f7, 0xe1a3,
	0xb9f8, 0xc0aa,
	0xb9f9, 0xc1ce,
	0xb9fa, 0xb1d7,
	0xb9fc, 0xd5c3,
	0xb9fd, 0xb3b9,
	0xba41, 0xccac,
	0xba42, 0xbfb6,
	0xba43, 0xc2fd,
	0xba44, 0xb9df,
	0xba45, 0xe2fa,
	0xba46, 0xb2d1,
	0xba47, 0xb2d2,
	0xba48, 0xe3bc,
	0xba49, 0xbdd8,
	0xba4a, 0xc6b2,
	0xba4b, 0xd5aa,
	0xba4c, 0xcba4,
	0xba4d, 0xb3b7,
	0xba4e, 0xc3fe,
	0xba4f, 0xc2a7,
	0xba50, 0xdfa1,
	0xba51, 0xdee2,
	0xba52, 0xb4dd,
	0xba53, 0xe5ba,
	0xba54, 0xdefd,
	0xba55, 0xb2f4,
	0xba56, 0xc7c3,
	0xba57, 0xced3,
	0xba58, 0xc6ec,
	0xba59, 0xecbd,
	0xba5a, 0xb3a9,
	0xba5b, 0xf4df,
	0xba5c, 0xead4,
	0xba5d, 0xb0f1,
	0xba5e, 0xd5a5,
	0xba5f, 0xe9c5,
	0xba60, 0xe9c2,
	0xba61, 0xc8d9,
	0xba62, 0xb8dc,
	0xba63, 0xb9b9,
	0xba64, 0xe9bb,
	0xba65, 0xc8b6,
	0xba66, 0xe9bd,
	0xba67, 0xe9be,
	0xba68, 0xc1f1,
	0xba69, 0xbbb1,
	0xba6a, 0xc7b9,
	0xba6b, 0xe9bf,
	0xba6c, 0xe9b3,
	0xba70, 0xc7b8,
	0xba71, 0xb8e8,
	0xba72, 0xebb5,
	0xba73, 0xd5c4,
	0xba74, 0xd1dd,
	0xba75, 0xb9f6,
	0xba76, 0xc0ec,
	0xba77, 0xb5ce,
	0xba78, 0xe4f6,
	0xba79, 0xd1fa,
	0xba7a, 0xc4ae,
	0xba7b, 0xd7d5,
	0xba7c, 0xc2a9,
	0xba7d, 0xc6af,
	0xba7e, 0xbaba,
	0xbaa1, 0xc2fa,
	0xbaa2, 0xd6cd,
	0xbaa3, 0xc6e1,
	0xbaa4, 0xcafe,
	0xbaa5, 0xbda5,
	0xbaa6, 0xd5c7,
	0xbaa7, 0xc1b0,
	0xbaa8, 0xe4ee,
	0xbaa9, 0xc2fe,
	0xbaaa, 0xe4f0,
	0xbaab, 0xb3ba,
	0xbaac, 0xe4f4,
	0xbaad, 0xbba6,
	0xbaae, 0xd3e6,
	0xbaaf, 0xc9f8,
	0xbab0, 0xb5d3,
	0xbab2, 0xc8db,
	0xbab3, 0xcef5,
	0xbab4, 0xc9bf,
	0xbab5, 0xd0dc,
	0xbab6, 0xcfa8,
	0xbab7, 0xd3ab,
	0xbab8, 0xb6fb,
	0xbab9, 0xeafb,
	0xbaba, 0xdcfd,
	0xbabb, 0xd3fc,
	0xbabc, 0xe2af,
	0xbabd, 0xd1fe,
	0xbabe, 0xcbf6,
	0xbabf, 0xc2ea,
	0xbac0, 0xb9e5,
	0xbac1, 0xe8a9,
	0xbac2, 0xd5e7,
	0xbac3, 0xd2c9,
	0xbac4, 0xc5b1,
	0xbac5, 0xd1f1,
	0xbac6, 0xb7e8,
	0xbac8, 0xbbbe,
	0xbac9, 0xbea1,
	0xbaca, 0xbce0,
	0xbacb, 0xc3e9,
	0xbacc, 0xeea5,
	0xbacd, 0xeea3,
	0xbace, 0xcbaf,
	0xbacf, 0xb4c5,
	0xbad0, 0xb5fa,
	0xbad1, 0xb1cc,
	0xbad2, 0xccbc,
	0xbad3, 0xcbb6,
	0xbad4, 0xedd9,
	0xbad5, 0xecf5,
	0xbad6, 0xb8a3,
	0xbad7, 0xbbf6,
	0xbad8, 0xd6d6,
	0xbad9, 0xb3c6,
	0xbada, 0xcddd,
	0xbadb, 0xced1,
	0xbadc, 0xbddf,
	0xbadd, 0xb6cb,
	0xbade, 0xb9dc,
	0xbadf, 0xbbfe,
	0xbae0, 0xbce3,
	0xbae1, 0xf3db,
	0xbae2, 0xcbe3,
	0xbae3, 0xf3e9,
	0xbae4, 0xb2ad,
	0xbae5, 0xf3dd,
	0xbae6, 0xf3e7,
	0xbae9, 0xb4e2,
	0xbaea, 0xf4d5,
	0xbaeb, 0xbeab,
	0xbaec, 0xd5c0,
	0xbaed, 0xe7ba,
	0xbaee, 0xd7db,
	0xbaef, 0xb4c2,
	0xbaf0, 0xe7b1,
	0xbaf1, 0xc2cc,
	0xbaf2, 0xbdf4,
	0xbaf3, 0xd7ba,
	0xbaf4, 0xcdf8,
	0xbaf5, 0xb8d9,
	0xbaf6, 0xe7b2,
	0xbaf7, 0xb3f1,
	0xbaf8, 0xc3e0,
	0xbafa, 0xc2da,
	0xbafb, 0xceac,
	0xbafc, 0xd0f7,
	0xbafd, 0xe7bb,
	0xbafe, 0xe7b7,
	0xbb40, 0xb7a3,
	0xbb41, 0xb4e4,
	0xbb42, 0xf4e4,
	0xbb43, 0xb5d4,
	0xbb44, 0xcec5,
	0xbb45, 0xbedb,
	0xbb46, 0xd5d8,
	0xbb47, 0xb8af,
	0xbb48, 0xb0f2,
	0xbb49, 0xb8e0,
	0xbb4a, 0xebf5,
	0xbb4b, 0xb2b2,
	0xbb4c, 0xcdc8,
	0xbb4d, 0xebf6,
	0xbb4e, 0xeab0,
	0xbb4f, 0xcca8,
	0xbb50, 0xd3eb,
	0xbb51, 0xccf2,
	0xbb52, 0xcee8,
	0xbb53, 0xf4bb,
	0xbb54, 0xc8d8,
	0xbb55, 0xddef,
	0xbb57, 0xd0ee,
	0xbb58, 0xc3c9,
	0xbb59, 0xddb0,
	0xbb5a, 0xc6d1,
	0xbb5b, 0xcbe2,
	0xbb5c, 0xb8c7,
	0xbb5d, 0xd5f4,
	0xbb5e, 0xdda5,
	0xbb5f, 0xdded,
	0xbb60, 0xcad5,
	0xbb61, 0xb2d4,
	0xbb62, 0xcbf2,
	0xbb63, 0xddee,
	0xbb64, 0xf2ea,
	0xbb65, 0xc3db,
	0xbb66, 0xf2df,
	0xbb67, 0xf2ec,
	0xbb68, 0xf2e1,
	0xbb69, 0xf2e6,
	0xbb6a, 0xd6a9,
	0xbb6b, 0xcab4,
	0xbb6c, 0xf2e9,
	0xbb6d, 0xf2e8,
	0xbb6e, 0xc9d1,
	0xbb6f, 0xb9d3,
	0xbb70, 0xc5e1,
	0xbb71, 0xb9fc,
	0xbb72, 0xc2e3,
	0xbb73, 0xd6c6,
	0xbb74, 0xf1d4,
	0xbb75, 0xf1d2,
	0xbb77, 0xcbd0,
	0xbb78, 0xd6be,
	0xbb79, 0xd3ef,
	0xbb7a, 0xcedc,
	0xbb7b, 0xc8cf,
	0xbb7c, 0xbdeb,
	0xbb7d, 0xcac4,
	0xbb7e, 0xcef3,
	0xbba1, 0xcbb5,
	0xbba2, 0xdabe,
	0xbba3, 0xbbe5,
	0xbba4, 0xd3d5,
	0xbba5, 0xdabf,
	0xbba6, 0xdabd,
	0xbba8, 0xbac0,
	0xbba9, 0xc0ea,
	0xbbaa, 0xc3b2,
	0xbbab, 0xb1f6,
	0xbbac, 0xeae2,
	0xbbad, 0xc9de,
	0xbbae, 0xbad5,
	0xbbaf, 0xd5d4,
	0xbbb0, 0xb8cf,
	0xbbb2, 0xb8a8,
	0xbbb3, 0xe9fc,
	0xbbb4, 0xc7e1,
	0xbbb6, 0xc0b1,
	0xbbb7, 0xd4b6,
	0xbbb8, 0xe5dc,
	0xbbb9, 0xd1b7,
	0xbbba, 0xc7b2,
	0xbbbb, 0xd2a3,
	0xbbbc, 0xb5dd,
	0xbbbd, 0xe5dd,
	0xbbbf, 0xe5de,
	0xbbc0, 0xb1c9,
	0xbbc2, 0xdbb4,
	0xbbc3, 0xbdcd,
	0xbbc4, 0xcbe1,
	0xbbc5, 0xbfe1,
	0xbbc6, 0xf5a9,
	0xbbc7, 0xbdc2,
	0xbbc8, 0xd2f8,
	0xbbc9, 0xcdad,
	0xbbca, 0xc3fa,
	0xbbcb, 0xeef9,
	0xbbcc, 0xb8f5,
	0xbbcd, 0xeefd,
	0xbbce, 0xcfce,
	0xbbcf, 0xefa7,
	0xbbd1, 0xcfb3,
	0xbbd2, 0xbad2,
	0xbbd3, 0xb9eb,
	0xbbd4, 0xc3f6,
	0xbbd5, 0xb8f3,
	0xbbd6, 0xb7a7,
	0xbbd8, 0xcfb6,
	0xbbd9, 0xd5cf,
	0xbbda, 0xbcca,
	0xbbdb, 0xb4c6,
	0xbbdc, 0xf6c3,
	0xbbdd, 0xd0e8,
	0xbbde, 0xf7b0,
	0xbbdf, 0xf7b1,
	0xbbe0, 0xc9d8,
	0xbbe1, 0xc6c4,
	0xbbe2, 0xc1ec,
	0xbbe3, 0xecaa,
	0xbbe5, 0xbdc8,
	0xbbe6, 0xb1fd,
	0xbbe7, 0xb6fc,
	0xbbe8, 0xe2c3,
	0xbbe9, 0xb2b5,
	0xbbea, 0xb0b9,
	0xbbeb, 0xf7bb,
	0xbbec, 0xf7d6,
	0xbbed, 0xbffd,
	0xbbee, 0xbbea,
	0xbbef, 0xc3f9,
	0xbbf0, 0xf0b0,
	0xbbf1, 0xb7ef,
	0xbbf2, 0xc3b4,
	0xbbf2, 0xf7e1,
	0xbbf3, 0xb1c7,
	0xbbf4, 0xc6eb,
	0xbbf5, 0xd2da,
	0xbbf6, 0xd2c7,
	0xbbf7, 0xc6a7,
	0xbbf8, 0xbda9,
	0xbbf9, 0xbcdb,
	0xbbfa, 0xd9af,
	0xbbfb, 0xbfeb,
	0xbbfc, 0xbcf3,
	0xbbfe, 0xc1dd,
	0xbc40, 0xbee7,
	0xbc41, 0xc5fc,
	0xbc42, 0xc1f5,
	0xbc43, 0xbda3,
	0xbc44, 0xb9f4,
	0xbc45, 0xdbc4,
	0xbc46, 0xc0f7,
	0xbc47, 0xdfeb,
	0xbc48, 0xcefb,
	0xbc49, 0xe0da,
	0xbc4a, 0xb3b0,
	0xbc4b, 0xbad9,
	0xbc4c, 0xd7ec,
	0xbc4d, 0xbba9,
	0xbc4e, 0xd0ea,
	0xbc4f, 0xd2ad,
	0xbc50, 0xe0db,
	0xbc51, 0xc5e7,
	0xbc52, 0xcbbb,
	0xbc53, 0xd0a5,
	0xbc54, 0xdfb4,
	0xbc55, 0xdcaf,
	0xbc56, 0xd0e6,
	0xbc57, 0xd4f6,
	0xbc58, 0xb7d8,
	0xbc59, 0xd7b9,
	0xbc5a, 0xb6e9,
	0xbc5b, 0xb6d5,
	0xbc5e, 0xe6d2,
	0xbc5f, 0xe6b5,
	0xbc60, 0xe6bf,
	0xbc61, 0xe5fc,
	0xbc62, 0xbdbf,
	0xbc63, 0xe6ac,
	0xbc64, 0xe5bc,
	0xbc65, 0xbfed,
	0xbc66, 0xc9f3,
	0xbc67, 0xd0b4,
	0xbc68, 0xb2e3,
	0xbc69, 0xc2c4,
	0xbc6a, 0xe1d8,
	0xbc6c, 0xb4b1,
	0xbc6d, 0xd6c4,
	0xbc6e, 0xe1a6,
	0xbc6f, 0xb7cf,
	0xbc70, 0xb3f8,
	0xbc71, 0xc3ed,
	0xbc72, 0xd8cb,
	0xbc73, 0xb9e3,
	0xbc74, 0xb3a7,
	0xbc75, 0xb5af,
	0xbc76, 0xd3b0,
	0xbc77, 0xb5c2,
	0xbc78, 0xe1e7,
	0xbc79, 0xc7ec,
	0xbc7a, 0xbbdb,
	0xbc7b, 0xc2c7,
	0xbc7c, 0xedab,
	0xbc7d, 0xc4bd,
	0xbc7e, 0xd3c7,
	0xbca2, 0xcebf,
	0xbca3, 0xcbcb,
	0xbca5, 0xe3bf,
	0xbca6, 0xc1af,
	0xbca7, 0xc3f5,
	0xbca8, 0xd4f7,
	0xbca9, 0xe3bd,
	0xbcaa, 0xb5ac,
	0xbcab, 0xb7df,
	0xbcac, 0xe3be,
	0xbcad, 0xe2e4,
	0xbcae, 0xc2be,
	0xbcaf, 0xc4a6,
	0xbcb0, 0xd6bf,
	0xbcb1, 0xc4a1,
	0xbcb2, 0xd7b2,
	0xbcb3, 0xc6cb,
	0xbcb4, 0xc0cc,
	0xbcb5, 0xb3c5,
	0xbcb6, 0xd7ab,
	0xbcb7, 0xb2a6,
	0xbcb8, 0xc4d3,
	0xbcb9, 0xcbba,
	0xbcba, 0xc1c3,
	0xbcbb, 0xc8f6,
	0xbcbc, 0xb4e9,
	0xbcbd, 0xb2a5,
	0xbcbe, 0xb8a7,
	0xbcc0, 0xc7cb,
	0xbcc1, 0xdfa4,
	0xbcc3, 0xdeec,
	0xbcc4, 0xb5d0,
	0xbcc5, 0xb7f3,
	0xbcc6, 0xcafd,
	0xbcc7, 0xc4ba,
	0xbcc8, 0xd4dd,
	0xbcc9, 0xb1a9,
	0xbcca, 0xeac7,
	0xbccb, 0xd1f9,
	0xbccc, 0xd5c1,
	0xbccd, 0xe9a4,
	0xbcce, 0xd7ae,
	0xbccf, 0xcae0,
	0xbcd0, 0xb1ea,
	0xbcd1, 0xb2db,
	0xbcd2, 0xc4a3,
	0xbcd3, 0xc2a5,
	0xbcd4, 0xb7ae,
	0xbcd5, 0xbdb0,
	0xbcd6, 0xc0d6,
	0xbcd7, 0xe8c8,
	0xbcd8, 0xe9ca,
	0xbcd9, 0xc1ba,
	0xbcda, 0xc5b7,
	0xbcdc, 0xe9e4,
	0xbcdd, 0xd2e3,
	0xbcde, 0xc5b9,
	0xbcdf, 0xbdac,
	0xbce0, 0xe4fc,
	0xbce1, 0xb3ce,
	0xbce2, 0xc6c3,
	0xbce3, 0xc1ca,
	0xbce4, 0xbde0,
	0xbce5, 0xbdbd,
	0xbce6, 0xccb6,
	0xbce7, 0xc7b1,
	0xbce8, 0xe4fa,
	0xbce9, 0xb3b1,
	0xbcea, 0xc5ec,
	0xbceb, 0xe4fd,
	0xbcec, 0xc0a3,
	0xbced, 0xc8f3,
	0xbcee, 0xbda7,
	0xbcef, 0xc5cb,
	0xbcf0, 0xebf8,
	0xbcf1, 0xe4b1,
	0xbcf3, 0xf4aa,
	0xbcf4, 0xcaec,
	0xbcf5, 0xb0be,
	0xbcf6, 0xc8c8,
	0xbcf7, 0xecd9,
	0xbcf8, 0xebbb,
	0xbcfa, 0xbdb1,
	0xbcfb, 0xe2b1,
	0xbcfc, 0xd3a8,
	0xbcfd, 0xe8b0,
	0xbcfe, 0xc1a7,
	0xbd40, 0xe8aa,
	0xbd41, 0xe8ad,
	0xbd42, 0xe7dc,
	0xbd43, 0xf1a4,
	0xbd44, 0xb4f1,
	0xbd45, 0xcec1,
	0xbd46, 0xc1f6,
	0xbd47, 0xcadd,
	0xbd48, 0xb4af,
	0xbd49, 0xf1a3,
	0xbd4a, 0xb0a8,
	0xbd4b, 0xd6e5,
	0xbd4c, 0xc5cc,
	0xbd4d, 0xcfb9,
	0xbd4e, 0xc3d0,
	0xbd4f, 0xeea7,
	0xbd50, 0xeea8,
	0xbd52, 0xb4e8,
	0xbd53, 0xb0f5,
	0xbd54, 0xc8b7,
	0xbd55, 0xc0da,
	0xbd56, 0xc4eb,
	0xbd57, 0xbfc4,
	0xbd58, 0xc2eb,
	0xbd59, 0xc5cd,
	0xbd5a, 0xb8e5,
	0xbd5b, 0xbcda,
	0xbd5d, 0xbbfc,
	0xbd5e, 0xf0a2,
	0xbd5f, 0xb5be,
	0xbd60, 0xd2a4,
	0xbd61, 0xc7ee,
	0xbd62, 0xbcfd,
	0xbd63, 0xcfe4,
	0xbd64, 0xb7b6,
	0xbd65, 0xf3f0,
	0xbd66, 0xd7ad,
	0xbd67, 0xc6aa,
	0xbd68, 0xf3f2,
	0xbd6a, 0xf3f3,
	0xbd6b, 0xbafd,
	0xbd6c, 0xb5de,
	0xbd6d, 0xc1b7,
	0xbd6e, 0xceb3,
	0xbd70, 0xbcea,
	0xbd71, 0xc3e5,
	0xbd72, 0xbca9,
	0xbd73, 0xb1e0,
	0xbd74, 0xd4b5,
	0xbd75, 0xcfdf,
	0xbd76, 0xb6d0,
	0xbd77, 0xbbba,
	0xbd78, 0xe7b6,
	0xbd79, 0xe7bc,
	0xbd7a, 0xe7bf,
	0xbd7b, 0xe7be,
	0xbd7c, 0xc2ee,
	0xbd7d, 0xb0d5,
	0xbd7e, 0xf4c9,
	0xbda1, 0xf4e6,
	0xbda2, 0xf1ee,
	0xbda3, 0xccc5,
	0xbda4, 0xc4a4,
	0xbda5, 0xcfa5,
	0xbda6, 0xbdba,
	0xbda7, 0xb7f4,
	0xbda8, 0xb1ec,
	0xbda9, 0xd5e1,
	0xbdaa, 0xb1ce,
	0xbdab, 0xceb5,
	0xbdac, 0xc1ab,
	0xbdad, 0xcadf,
	0xbdae, 0xd2f1,
	0xbdaf, 0xc2fb,
	0xbdb0, 0xc3ef,
	0xbdb1, 0xbdaf,
	0xbdb2, 0xb2cc,
	0xbdb4, 0xc5ee,
	0xbdb5, 0xb4d0,
	0xbdb6, 0xdea3,
	0xbdb8, 0xf2eb,
	0xbdb9, 0xbafb,
	0xbdba, 0xb5fb,
	0xbdbb, 0xf2f0,
	0xbdbc, 0xcfba,
	0xbdbd, 0xcecf,
	0xbdbe, 0xcaad,
	0xbdbf, 0xf2f9,
	0xbdc0, 0xbbc8,
	0xbdc1, 0xf2f2,
	0xbdc2, 0xf2f5,
	0xbdc3, 0xcec0,
	0xbdc4, 0xb3e5,
	0xbdc5, 0xbad6,
	0xbdc6, 0xb8b4,
	0xbdc7, 0xb0fd,
	0xbdc8, 0xf1d9,
	0xbdca, 0xf1db,
	0xbdcb, 0xd2ea,
	0xbdcc, 0xc1c2,
	0xbdcd, 0xccb8,
	0xbdce, 0xd7bb,
	0xbdcf, 0xb5ae,
	0xbdd0, 0xc7eb,
	0xbdd1, 0xd6ee,
	0xbdd2, 0xbfce,
	0xbdd3, 0xdac3,
	0xbdd4, 0xdac6,
	0xbdd5, 0xb5f7,
	0xbdd6, 0xcbad,
	0xbdd7, 0xc2db,
	0xbdd8, 0xdaba,
	0xbdd9, 0xdac7,
	0xbdda, 0xb7cc,
	0xbddb, 0xdac4,
	0xbddc, 0xcde3,
	0xbddd, 0xcafa,
	0xbdde, 0xd6ed,
	0xbddf, 0xc5e2,
	0xbde0, 0xc9cd,
	0xbde1, 0xb8b3,
	0xbde2, 0xbcfa,
	0xbde3, 0xd5cb,
	0xbde4, 0xb6c4,
	0xbde5, 0xcfcd,
	0xbde6, 0xc2f4,
	0xbde7, 0xb4cd,
	0xbde8, 0xd6ca,
	0xbde9, 0xe2d9,
	0xbdea, 0xf4f7,
	0xbdeb, 0xcccb,
	0xbdec, 0xc8a4,
	0xbdee, 0xbcf9,
	0xbdef, 0xf5d7,
	0xbdf0, 0xccdf,
	0xbdf1, 0xcca4,
	0xbdf2, 0xb2c8,
	0xbdf3, 0xf5d8,
	0xbdf5, 0xbee1,
	0xbdf6, 0xccc9,
	0xbdf7, 0xbbd4,
	0xbdf8, 0xc1be,
	0xbdf9, 0xeaa1,
	0xbdfa, 0xb1b2,
	0xbdfb, 0xe9fd,
	0xbdfc, 0xc2d6,
	0xbdfd, 0xeaa2,
	0xbdfe, 0xe9fe,
	0xbe40, 0xb9f5,
	0xbe41, 0xcaca,
	0xbe42, 0xd5da,
	0xbe43, 0xe5db,
	0xbe44, 0xd4e2,
	0xbe45, 0xc7a8,
	0xbe46, 0xc1da,
	0xbe47, 0xd6a3,
	0xbe48, 0xb5cb,
	0xbe49, 0xdbb6,
	0xbe4a, 0xb4bc,
	0xbe4b, 0xd7ed,
	0xbe4c, 0xb4d7,
	0xbe4e, 0xd0bf,
	0xbe4f, 0xcce0,
	0xbe50, 0xcffa,
	0xbe52, 0xeeed,
	0xbe53, 0xb3fa,
	0xbe54, 0xc2c1,
	0xbe55, 0xc8f1,
	0xbe56, 0xefb1,
	0xbe57, 0xb7e6,
	0xbe58, 0xb1b5,
	0xbe59, 0xefae,
	0xbe5b, 0xe3cc,
	0xbe5c, 0xd4c4,
	0xbe5d, 0xcff6,
	0xbe5e, 0xf6aa,
	0xbe5f, 0xd5f0,
	0xbe60, 0xc3b9,
	0xbe61, 0xbfbf,
	0xbe62, 0xb0b0,
	0xbe63, 0xd0ac,
	0xbe64, 0xb9ae,
	0xbe65, 0xf2a1,
	0xbe67, 0xf2a2,
	0xbe69, 0xd1f8,
	0xbe6a, 0xb6f6,
	0xbe6b, 0xc4d9,
	0xbe6c, 0xe2c5,
	0xbe6d, 0xcdd5,
	0xbe6e, 0xd7a4,
	0xbe6f, 0xe6e1,
	0xbe70, 0xcabb,
	0xbe71, 0xe6e5,
	0xbe72, 0xbcdd,
	0xbe73, 0xbed4,
	0xbe74, 0xe6e2,
	0xbe75, 0xf7bc,
	0xbe77, 0xf7d7,
	0xbe78, 0xc4d6,
	0xbe79, 0xf7c8,
	0xbe7a, 0xc6c7,
	0xbe7b, 0xf6cf,
	0xbe7c, 0xc2b3,
	0xbe7d, 0xf0b2,
	0xbe7e, 0xd1bb,
	0xbea2, 0xf4ef,
	0xbea3, 0xf7e2,
	0xbea4, 0xc0e8,
	0xbea5, 0xc4ab,
	0xbea6, 0xb3dd,
	0xbea7, 0xc8e5,
	0xbea8, 0xbdf6,
	0xbea9, 0xd9b1,
	0xbeaa, 0xd9cf,
	0xbeab, 0xd9ad,
	0xbeac, 0xbcbd,
	0xbead, 0xc3dd,
	0xbeae, 0xc4fd,
	0xbeaf, 0xbcc1,
	0xbeb0, 0xd8e6,
	0xbeb2, 0xe0df,
	0xbeb3, 0xe0e6,
	0xbeb5, 0xd8ac,
	0xbeb6, 0xe0e4,
	0xbeb7, 0xb6d6,
	0xbeb8, 0xd4eb,
	0xbeb9, 0xc6f7,
	0xbeba, 0xdfe6,
	0xbebb, 0xe0e5,
	0xbebc, 0xe0c8,
	0xbebd, 0xcac9,
	0xbebe, 0xe0de,
	0xbebf, 0xb8c1,
	0xbec0, 0xb1da,
	0xbec1, 0xbfd1,
	0xbec2, 0xccb3,
	0xbec3, 0xdbd5,
	0xbec4, 0xb7dc,
	0xbec6, 0xd9f8,
	0xbec7, 0xd1a7,
	0xbec8, 0xe5be,
	0xbec9, 0xb5bc,
	0xbecb, 0xcfdc,
	0xbecc, 0xc6be,
	0xbecd, 0xedac,
	0xbece, 0xb1b9,
	0xbecf, 0xe3c1,
	0xbed0, 0xd2e4,
	0xbed1, 0xbab6,
	0xbed2, 0xb0c3,
	0xbed3, 0xd0b8,
	0xbed4, 0xd5bd,
	0xbed5, 0xc9c3,
	0xbed6, 0xd3b5,
	0xbed7, 0xb5b2,
	0xbed8, 0xcca2,
	0xbed9, 0xbab3,
	0xbeda, 0xbedd,
	0xbedb, 0xc2b0,
	0xbedc, 0xd4f1,
	0xbedd, 0xc0de,
	0xbede, 0xb2d9,
	0xbedf, 0xbcf1,
	0xbee0, 0xc7dc,
	0xbee1, 0xb5a3,
	0xbee2, 0xcece,
	0xbee3, 0xd5fb,
	0xbee4, 0xc0fa,
	0xbee5, 0xcffe,
	0xbee6, 0xe5df,
	0xbee7, 0xeaca,
	0xbee8, 0xeabc,
	0xbeea, 0xe9d7,
	0xbeec, 0xe8eb,
	0xbeed, 0xb3c8,
	0xbeee, 0xbae1,
	0xbeef, 0xe9d9,
	0xbef0, 0xcaf7,
	0xbef1, 0xe9cf,
	0xbef2, 0xcdd6,
	0xbef3, 0xcff0,
	0xbef4, 0xc7c5,
	0xbef5, 0xc7c1,
	0xbef6, 0xe9d4,
	0xbef7, 0xbbfa,
	0xbef8, 0xe8e3,
	0xbef9, 0xeca8,
	0xbefa, 0xc0fa,
	0xbefb, 0xeba9,
	0xbefc, 0xe5a5,
	0xbefd, 0xb5ed,
	0xbefe, 0xd4e8,
	0xbf40, 0xc5a8,
	0xbf41, 0xd4f3,
	0xbf42, 0xd7c7,
	0xbf43, 0xe5a2,
	0xbf44, 0xb0c4,
	0xbf45, 0xbca4,
	0xbf46, 0xe5a3,
	0xbf47, 0xe5a4,
	0xbf49, 0xe4c5,
	0xbf4b, 0xb3e3,
	0xbf4c, 0xecc0,
	0xbf4e, 0xc9d5,
	0xbf4f, 0xb5c6,
	0xbf50, 0xd1e0,
	0xbf51, 0xece4,
	0xbf52, 0xc1c7,
	0xbf53, 0xcccc,
	0xbf54, 0xeccb,
	0xbf55, 0xc8bc,
	0xbf56, 0xd1e6,
	0xbf57, 0xb6c0,
	0xbf58, 0xe8ab,
	0xbf59, 0xe7e1,
	0xbf5c, 0xe8b1,
	0xbf5d, 0xc6b0,
	0xbf5e, 0xeab1,
	0xbf5f, 0xddf9,
	0xbf60, 0xd5ce,
	0xbf61, 0xc8b3,
	0xbf63, 0xc2ac,
	0xbf64, 0xeec2,
	0xbf65, 0xeeaa,
	0xbf66, 0xc2f7,
	0xbf67, 0xeea9,
	0xbf68, 0xc6b3,
	0xbf69, 0xc4a5,
	0xbf6a, 0xd7a9,
	0xbf6b, 0xede0,
	0xbf6c, 0xedd3,
	0xbf6e, 0xbbfd,
	0xbf6f, 0xd3b1,
	0xbf6f, 0xf2a3,
	0xbf70, 0xc4c2,
	0xbf71, 0xf6d5,
	0xbf73, 0xbffa,
	0xbf74, 0xb8dd,
	0xbf76, 0xd6fe,
	0xbf77, 0xf3c6,
	0xbf79, 0xb4db,
	0xbf7a, 0xc9b8,
	0xbf7b, 0xf3f7,
	0xbf7c, 0xb8e2,
	0xbf7d, 0xccc7,
	0xbf7e, 0xe7cb,
	0xbfa1, 0xe7cc,
	0xbfa2, 0xddd3,
	0xbfa3, 0xb8bf,
	0xbfa4, 0xcfd8,
	0xbfa5, 0xe7c9,
	0xbfa6, 0xe7c7,
	0xbfa7, 0xe7c6,
	0xbfa8, 0xe7a7,
	0xbfa9, 0xeebe,
	0xbfaa, 0xf4cb,
	0xbfab, 0xbab2,
	0xbfac, 0xb0bf,
	0xbfad, 0xf4e7,
	0xbfae, 0xf1f1,
	0xbfaf, 0xc9c5,
	0xbfb0, 0xc4e5,
	0xbfb1, 0xc5f2,
	0xbfb2, 0xd5e9,
	0xbfb3, 0xd0cb,
	0xbfb4, 0xcbd2,
	0xbfb5, 0xb2d5,
	0xbfb6, 0xc8ef,
	0xbfb7, 0xdea5,
	0xbfb8, 0xdea6,
	0xbfb9, 0xdea7,
	0xbfbb, 0xdeac,
	0xbfbc, 0xbdb6,
	0xbfbd, 0xcff4,
	0xbfbe, 0xcedf,
	0xbfbf, 0xdea9,
	0xbfc0, 0xf3a6,
	0xbfc1, 0xc3f8,
	0xbfc2, 0xc2ec,
	0xbfc3, 0xd3a9,
	0xbfc4, 0xc8da,
	0xbfc5, 0xbae2,
	0xbfc6, 0xcdca,
	0xbfc7, 0xbfe3,
	0xbfc8, 0xc8ec,
	0xbfc9, 0xf1dd,
	0xbfca, 0xf1d7,
	0xbfcb, 0xc7d7,
	0xbfcc, 0xeaec,
	0xbfcd, 0xdad0,
	0xbfce, 0xd1e8,
	0xbfcf, 0xdac9,
	0xbfd0, 0xbbe4,
	0xbfd1, 0xc4b1,
	0xbfd2, 0xb5fd,
	0xbfd3, 0xd0b3,
	0xbfd4, 0xdad1,
	0xbfd5, 0xc5b5,
	0xbfd6, 0xdacb,
	0xbfd7, 0xcebd,
	0xbfd8, 0xb7ed,
	0xbfd9, 0xdacd,
	0xbfda, 0xdacf,
	0xbfdb, 0xdac8,
	0xbfdc, 0xdace,
	0xbfdd, 0xd4a5,
	0xbfdf, 0xc3a8,
	0xbfe0, 0xc0b5,
	0xbfe1, 0xcce3,
	0xbfe2, 0xf5e2,
	0xbfe3, 0xd3bb,
	0xbfe4, 0xf5e5,
	0xbfe6, 0xf5e0,
	0xbfe7, 0xb7f8,
	0xbfe8, 0xbcad,
	0xbfe9, 0xcae4,
	0xbfea, 0xeaa3,
	0xbfeb, 0xb1e6,
	0xbfec, 0xb0ec,
	0xbfed, 0xd7f1,
	0xbfee, 0xe5e0,
	0xbfef, 0xd1a1,
	0xbff0, 0xb3d9,
	0xbff1, 0xc1c9,
	0xbff2, 0xd2c5,
	0xbff3, 0xdafe,
	0xbff4, 0xd0d1,
	0xbff5, 0xb6a7,
	0xbff7, 0xbee2,
	0xbff8, 0xc3cc,
	0xbff9, 0xb4ed,
	0xbffa, 0xc7ae,
	0xbffb, 0xb8d6,
	0xbffc, 0xcefd,
	0xbffd, 0xc2bc,
	0xbffe, 0xefa3,
	0xc040, 0xd7b6,
	0xc041, 0xbdf5,
	0xc043, 0xefbf,
	0xc044, 0xefc0,
	0xc045, 0xefc5,
	0xc046, 0xd1d6,
	0xc047, 0xcbed,
	0xc048, 0xcbe6,
	0xc049, 0xcfd5,
	0xc04a, 0xb5f1,
	0xc04b, 0xf6ae,
	0xc04d, 0xc1d8,
	0xc04e, 0xbbf4,
	0xc04f, 0xc4de,
	0xc050, 0xf6ad,
	0xc051, 0xb5e5,
	0xc052, 0xbeb2,
	0xc054, 0xc7ca,
	0xc055, 0xbcd5,
	0xc056, 0xbeb1,
	0xc057, 0xc6b5,
	0xc058, 0xf2a5,
	0xc059, 0xcdb7,
	0xc05a, 0xcdc7,
	0xc05b, 0xd2c3,
	0xc05c, 0xb2cd,
	0xc05d, 0xb9dd,
	0xc05e, 0xbda4,
	0xc05f, 0xe2c6,
	0xc060, 0xcfda,
	0xc062, 0xbaa7,
	0xc063, 0xe6e9,
	0xc064, 0xc2e6,
	0xc065, 0xbaa1,
	0xc066, 0xf7c0,
	0xc067, 0xf7d9,
	0xc068, 0xf7da,
	0xc06a, 0xb1ab,
	0xc06b, 0xcdd2,
	0xc06c, 0xf0b3,
	0xc06d, 0xd1ec,
	0xc06e, 0xd1bc,
	0xc070, 0xd4a7,
	0xc071, 0xc4ac,
	0xc072, 0xc7ad,
	0xc073, 0xc1fa,
	0xc074, 0xb9ea,
	0xc075, 0xd3c5,
	0xc076, 0xb3a5,
	0xc077, 0xc0dc,
	0xc078, 0xb4a2,
	0xc079, 0xc0f8,
	0xc07a, 0xbabf,
	0xc07b, 0xdfcc,
	0xc07d, 0xe0e9,
	0xc07e, 0xcfc5,
	0xc0a1, 0xcce7,
	0xc0a2, 0xbabe,
	0xc0a3, 0xd1b9,
	0xc0a4, 0xdbd6,
	0xc0a6, 0xd3a4,
	0xc0a7, 0xe6c9,
	0xc0a8, 0xe6d6,
	0xc0a9, 0xc8e6,
	0xc0aa, 0xdecf,
	0xc0ab, 0xe5f0,
	0xc0ac, 0xd3ec,
	0xc0ad, 0xc1eb,
	0xc0af, 0xe1c9,
	0xc0b0, 0xb0ef,
	0xc0b1, 0xc3d6,
	0xc0b2, 0xbbd5,
	0xc0b3, 0xd3a6,
	0xc0b4, 0xb6ae,
	0xc0b5, 0xbfd2,
	0xc0b6, 0xc5b3,
	0xc0b7, 0xedae,
	0xc0b8, 0xcfb7,
	0xc0b9, 0xb4f7,
	0xc0ba, 0xc7e6,
	0xc0bb, 0xbbf7,
	0xc0bc, 0xeba2,
	0xc0bd, 0xbcb7,
	0xc0be, 0xc5a1,
	0xc0bf, 0xb2c1,
	0xc0c0, 0xc4e2,
	0xc0c1, 0xb8e9,
	0xc0c2, 0xdfaa,
	0xc0c4, 0xc1b2,
	0xc0c5, 0xb1d0,
	0xc0c6, 0xcaef,
	0xc0c7, 0xead3,
	0xc0c8, 0xccb4,
	0xc0c9, 0xb5b5,
	0xc0ca, 0xcfad,
	0xc0cb, 0xbcec,
	0xc0cc, 0xe8ed,
	0xc0cd, 0xe8ce,
	0xc0ce, 0xe9c9,
	0xc0d0, 0xe9de,
	0xc0d1, 0xe9dc,
	0xc0d2, 0xe9d1,
	0xc0d4, 0xe9e7,
	0xc0d6, 0xd5b1,
	0xc0d7, 0xc5a2,
	0xc0d8, 0xb1f5,
	0xc0d9, 0xbcc3,
	0xc0da, 0xe5a9,
	0xc0dc, 0xccce,
	0xc0dd, 0xc0c4,
	0xc0de, 0xe5aa,
	0xc0df, 0xc9ac,
	0xc0e0, 0xbfa3,
	0xc0e1, 0xe5a6,
	0xc0e3, 0xcaaa,
	0xc0e4, 0xe5a7,
	0xc0e5, 0xceab,
	0xc0e6, 0xecdd,
	0xc0e7, 0xd3aa,
	0xc0e8, 0xdbc6,
	0xc0e9, 0xb2d3,
	0xc0ea, 0xd4ef,
	0xc0eb, 0xd6f2,
	0xc0ed, 0xbbe2,
	0xc0ee, 0xecdb,
	0xc0ef, 0xbef4,
	0xc0f0, 0xc7bd,
	0xc0f1, 0xc4fc,
	0xc0f2, 0xbbf1,
	0xc0f3, 0xe8b3,
	0xc0f4, 0xbbb7,
	0xc0f5, 0xe8a8,
	0xc0f6, 0xe8b2,
	0xc0f7, 0xf0ec,
	0xc0f8, 0xc1c6,
	0xc0f9, 0xb0a9,
	0xc0fa, 0xb5b4,
	0xc0fb, 0xcdab,
	0xc0fc, 0xb5c9,
	0xc0fd, 0xeeab,
	0xc0fe, 0xcbb2,
	0xc140, 0xc7c6,
	0xc142, 0xbdc3,
	0xc143, 0xc1d7,
	0xc144, 0xbbc7,
	0xc145, 0xede3,
	0xc146, 0xedb6,
	0xc147, 0xbdb8,
	0xc148, 0xecfb,
	0xc149, 0xecf8,
	0xc14a, 0xcbeb,
	0xc14b, 0xc1fe,
	0xc14c, 0xb4d8,
	0xc14d, 0xc2a8,
	0xc14e, 0xf3fa,
	0xc14f, 0xc5f1,
	0xc150, 0xf3f9,
	0xc152, 0xbfb7,
	0xc153, 0xc3d3,
	0xc154, 0xb7e0,
	0xc156, 0xd4e3,
	0xc157, 0xb2da,
	0xc158, 0xf4d6,
	0xc159, 0xcbf5,
	0xc15a, 0xbca8,
	0xc15b, 0xe7d1,
	0xc15c, 0xc2c6,
	0xc15d, 0xe7d0,
	0xc15e, 0xb1c1,
	0xc15f, 0xb7ec,
	0xc160, 0xd7dc,
	0xc161, 0xd7dd,
	0xc162, 0xe7d2,
	0xc163, 0xb7b1,
	0xc165, 0xe7ce,
	0xc167, 0xe7cf,
	0xc16a, 0xf3c0,
	0xc16b, 0xf4e8,
	0xc16c, 0xd2ed,
	0xc16d, 0xf1fa,
	0xc16e, 0xc9f9,
	0xc16f, 0xb4cf,
	0xc170, 0xc1aa,
	0xc171, 0xcbca,
	0xc172, 0xd2dc,
	0xc173, 0xd3b7,
	0xc174, 0xe2df,
	0xc175, 0xb1db,
	0xc176, 0xcdce,
	0xc177, 0xc5a7,
	0xc178, 0xb5a8,
	0xc179, 0xc1b3,
	0xc17a, 0xebda,
	0xc17b, 0xc1d9,
	0xc17c, 0xbed9,
	0xc17d, 0xbce8,
	0xc17e, 0xd0bd,
	0xc1a1, 0xb1a1,
	0xc1a2, 0xc0d9,
	0xc1a3, 0xdeb5,
	0xc1a5, 0xc7be,
	0xc1a6, 0xcaed,
	0xc1a7, 0xd1a6,
	0xc1a8, 0xdeb1,
	0xc1a9, 0xdeb0,
	0xc1aa, 0xbcbb,
	0xc1ab, 0xbff7,
	0xc1ac, 0xf3b0,
	0xc1ad, 0xf3af,
	0xc1ae, 0xf3ab,
	0xc1af, 0xf2fe,
	0xc1b0, 0xf3a1,
	0xc1b1, 0xf3a7,
	0xc1b2, 0xf2f7,
	0xc1b3, 0xc2dd,
	0xc1b4, 0xf2e5,
	0xc1b5, 0xf3ac,
	0xc1b6, 0xd9f4,
	0xc1b7, 0xf1de,
	0xc1b8, 0xcfe5,
	0xc1b9, 0xf1da,
	0xc1bb, 0xeae9,
	0xc1bc, 0xc3d5,
	0xc1bd, 0xb0f9,
	0xc1be, 0xc7ab,
	0xc1bf, 0xbdb2,
	0xc1c0, 0xbbd1,
	0xc1c1, 0xd2a5,
	0xc1c2, 0xd0bb,
	0xc1c3, 0xccdc,
	0xc1c4, 0xdad7,
	0xc1c5, 0xbbed,
	0xc1c7, 0xe1d9,
	0xc1c8, 0xd7ac,
	0xc1c9, 0xc8fc,
	0xc1ca, 0xb9ba,
	0xc1cc, 0xeae7,
	0xc1cd, 0xc7f7,
	0xc1ce, 0xf5e3,
	0xc1cf, 0xcca3,
	0xc1d0, 0xb5b8,
	0xc1d1, 0xf5e8,
	0xc1d2, 0xcfbd,
	0xc1d3, 0xd5b7,
	0xc1d4, 0xecb1,
	0xc1d5, 0xd4af,
	0xc1d6, 0xd3df,
	0xc1d7, 0xb1dc,
	0xc1d8, 0xe5e1,
	0xc1d9, 0xbbb9,
	0xc1da, 0xc2f5,
	0xc1db, 0xe5e2,
	0xc1dc, 0xd1fb,
	0xc1dd, 0xdbb8,
	0xc1de, 0xf5b1,
	0xc1df, 0xd4cd,
	0xc1e0, 0xb3f3,
	0xc1e1, 0xb6c6,
	0xc1e2, 0xc3be,
	0xc1e3, 0xc3aa,
	0xc1e4, 0xbcfc,
	0xc1e6, 0xefc6,
	0xc1e7, 0xb9f8,
	0xc1e8, 0xb4b8,
	0xc1e9, 0xeff1,
	0xc1ea, 0xc7c2,
	0xc1eb, 0xb6cd,
	0xc1ec, 0xefcc,
	0xc1ee, 0xefc9,
	0xc1ef, 0xc0ab,
	0xc1f0, 0xe3d7,
	0xc1f1, 0xc0bb,
	0xc1f2, 0xe3c7,
	0xc1f4, 0xd2fe,
	0xc1f5, 0xc1a5,
	0xc1f6, 0xcbe4,
	0xc1f7, 0xcbaa,
	0xc1f8, 0xcfbc,
	0xc1f9, 0xbecf,
	0xc1fa, 0xbaab,
	0xc1fb, 0xbfc5,
	0xc1fc, 0xecab,
	0xc1fe, 0xb3d2,
	0xc240, 0xbfa5,
	0xc241, 0xcfca,
	0xc242, 0xf6de,
	0xc243, 0xf6db,
	0xc244, 0xf6d9,
	0xc245, 0xbae8,
	0xc246, 0xb8eb,
	0xc247, 0xf7e7,
	0xc248, 0xf0a4,
	0xc249, 0xb5e3,
	0xc24a, 0xf7ed,
	0xc24b, 0xf7ee,
	0xc24c, 0xf7ec,
	0xc24d, 0xf7fd,
	0xc24e, 0xd5ab,
	0xc24f, 0xb4d4,
	0xc250, 0xe0e0,
	0xc252, 0xdbdb,
	0xc253, 0xc0dd,
	0xc254, 0xc9f4,
	0xc255, 0xd2cd,
	0xc256, 0xedaf,
	0xc257, 0xb4c1,
	0xc258, 0xc0a9,
	0xc259, 0xd6c0,
	0xc25a, 0xc8c5,
	0xc25b, 0xc4ec,
	0xc25c, 0xb0da,
	0xc25d, 0xcbd3,
	0xc25e, 0xdfa2,
	0xc25f, 0xb6cf,
	0xc260, 0xead7,
	0xc261, 0xebfc,
	0xc262, 0xe9c4,
	0xc263, 0xc3ca,
	0xc264, 0xb9f1,
	0xc265, 0xbcf7,
	0xc266, 0xc4fb,
	0xc26a, 0xeca3,
	0xc26b, 0xb9e9,
	0xc26c, 0xe9eb,
	0xc26d, 0xd0ba,
	0xc26e, 0xe4c9,
	0xc26f, 0xc2cb,
	0xc270, 0xe4c2,
	0xc271, 0xbda6,
	0xc272, 0xc6d9,
	0xc273, 0xe4af,
	0xc275, 0xbdfd,
	0xc276, 0xece2,
	0xc278, 0xe1ee,
	0xc279, 0xc1d4,
	0xc27a, 0xe8b5,
	0xc27c, 0xcecd,
	0xc27d, 0xf1b1,
	0xc27e, 0xf0dd,
	0xc2a1, 0xd3fa,
	0xc2a2, 0xeead,
	0xc2a3, 0xf6c4,
	0xc2a4, 0xd5b0,
	0xc2a5, 0xedfa,
	0xc2a6, 0xb4a1,
	0xc2a7, 0xc0f1,
	0xc2a8, 0xf0a3,
	0xc2a9, 0xbbe0,
	0xc2ab, 0xb4dc,
	0xc2ac, 0xc7cf,
	0xc2ad, 0xf3ef,
	0xc2ae, 0xbbc9,
	0xc2af, 0xf4a2,
	0xc2b0, 0xf3ec,
	0xc2b1, 0xf3f1,
	0xc2b2, 0xbcf2,
	0xc2b3, 0xc1b8,
	0xc2b4, 0xd6af,
	0xc2b5, 0xc9c9,
	0xc2b6, 0xc8c6,
	0xc2b7, 0xe7d4,
	0xc2b8, 0xd0e5,
	0xc2b9, 0xe7d5,
	0xc2bc, 0xc7cc,
	0xc2bd, 0xb7ad,
	0xc2be, 0xd6b0,
	0xc2bf, 0xc4f4,
	0xc2c0, 0xc6ea,
	0xc2c1, 0xebf7,
	0xc2c2, 0xbec9,
	0xc2c3, 0xb2d8,
	0xc2c4, 0xc8f8,
	0xc2c5, 0xc0b6,
	0xc2c6, 0xc3ea,
	0xc2c7, 0xbde5,
	0xc2c8, 0xdeb9,
	0xc2c9, 0xdcf9,
	0xc2ca, 0xdeb7,
	0xc2cb, 0xbcf6,
	0xc2cc, 0xf2cd,
	0xc2cd, 0xb2f5,
	0xc2cf, 0xf3b4,
	0xc2d0, 0xb8b2,
	0xc2d1, 0xeaee,
	0xc2d2, 0xf5fc,
	0xc2d3, 0xdad3,
	0xc2d4, 0xbdf7,
	0xc2d5, 0xc3fd,
	0xc2d6, 0xdad8,
	0xc2d7, 0xb7e1,
	0xc2d8, 0xd7b8,
	0xc2d9, 0xf5be,
	0xc2da, 0xf5e7,
	0xc2db, 0xb1c4,
	0xc2dc, 0xd7d9,
	0xc2de, 0xf5cf,
	0xc2df, 0xc7fb,
	0xc2e0, 0xd7aa,
	0xc2e1, 0xd5de,
	0xc2e2, 0xe5c7,
	0xc2e3, 0xe5e4,
	0xc2e4, 0xe5e3,
	0xc2e5, 0xd2bd,
	0xc2e6, 0xbdb4,
	0xc2e9, 0xb0f7,
	0xc2ea, 0xcbf8,
	0xc2eb, 0xced9,
	0xc2ec, 0xc4f8,
	0xc2ed, 0xd5f2,
	0xc2ee, 0xb8e4,
	0xc2ef, 0xefd7,
	0xc2f0, 0xefd3,
	0xc2f3, 0xe3d8,
	0xc2f4, 0xb4b3,
	0xc2f5, 0xe3d9,
	0xc2f6, 0xe3da,
	0xc2f7, 0xc0eb,
	0xc2f8, 0xd4d3,
	0xc2f9, 0xcbab,
	0xc2fa, 0xb3fb,
	0xc2fb, 0xbca6,
	0xc2fd, 0xf7b7,
	0xc340, 0xb1de,
	0xc342, 0xb6ee,
	0xc343, 0xd1d5,
	0xc344, 0xcce2,
	0xc345, 0xf2a6,
	0xc346, 0xf2a7,
	0xc348, 0xc1f3,
	0xc349, 0xe2c8,
	0xc34b, 0xf7d1,
	0xc34c, 0xf0a5,
	0xc34d, 0xc6ef,
	0xc34e, 0xf7c1,
	0xc34f, 0xd7d7,
	0xc350, 0xcbc9,
	0xc351, 0xceba,
	0xc352, 0xf7cb,
	0xc353, 0xf7cd,
	0xc354, 0xf6e8,
	0xc355, 0xc0f0,
	0xc356, 0xf6ea,
	0xc358, 0xf6e7,
	0xc359, 0xbee9,
	0xc35a, 0xb6ec,
	0xc35b, 0xf0c0,
	0xc35c, 0xf7ef,
	0xc35e, 0xf7f8,
	0xc360, 0xd1ca,
	0xc361, 0xbbb5,
	0xc362, 0xc2a2,
	0xc363, 0xdbde,
	0xc364, 0xb3e8,
	0xc365, 0xc5d3,
	0xc366, 0xc2ae,
	0xc367, 0xb3cd,
	0xc368, 0xbbb3,
	0xc369, 0xc0c1,
	0xc36a, 0xe3c2,
	0xc36b, 0xc5ca,
	0xc36c, 0xc2a3,
	0xc36d, 0xbff5,
	0xc36e, 0xc6d8,
	0xc36f, 0xb3f7,
	0xc370, 0xe8fc,
	0xc371, 0xe9b5,
	0xc372, 0xe9d6,
	0xc373, 0xe5ad,
	0xc374, 0xe4ec,
	0xc375, 0xe4fe,
	0xc376, 0xe5ab,
	0xc377, 0xc1a4,
	0xc378, 0xb1f4,
	0xc379, 0xe3f2,
	0xc37a, 0xb1ac,
	0xc37b, 0xcbb8,
	0xc37c, 0xebb9,
	0xc37d, 0xb6bf,
	0xc37e, 0xcade,
	0xc3a1, 0xcca1,
	0xc3a2, 0xe7f4,
	0xc3a3, 0xc7ed,
	0xc3a4, 0xb0ea,
	0xc3a5, 0xb3eb,
	0xc3a6, 0xbdae,
	0xc3a7, 0xb1f1,
	0xc3aa, 0xb0ad,
	0xc3ab, 0xb5bb,
	0xc3ad, 0xcec8,
	0xc3af, 0xb2be,
	0xc3b0, 0xf4a4,
	0xc3b1, 0xc7a9,
	0xc3b3, 0xf4a6,
	0xc3b4, 0xcfb5,
	0xc3b5, 0xbceb,
	0xc3b6, 0xd2ef,
	0xc3b7, 0xc9fe,
	0xc3b8, 0xbbe6,
	0xc3b9, 0xc2de,
	0xc3ba, 0xbdc9,
	0xc3bc, 0xb8fe,
	0xc3bd, 0xd9fa,
	0xc3be, 0xc0b0,
	0xc3bf, 0xb7aa,
	0xc3c0, 0xd2d5,
	0xc3c1, 0xdeb4,
	0xc3c2, 0xc5ba,
	0xc3c4, 0xd2a9,
	0xc3c6, 0xd2cf,
	0xc3c7, 0xd3ac,
	0xc3c8, 0xd0ab,
	0xc3c9, 0xd0b7,
	0xc3ca, 0xf3b8,
	0xc3cb, 0xf1c9,
	0xc3cc, 0xbdf3,
	0xc3cd, 0xb0c0,
	0xc3ce, 0xf4c5,
	0xc3d0, 0xc6d7,
	0xc3d1, 0xcab6,
	0xc3d2, 0xd6a4,
	0xc3d3, 0xccb7,
	0xc3d4, 0xdadc,
	0xc3d5, 0xbca5,
	0xc3d7, 0xdadb,
	0xc3d8, 0xd4f9,
	0xc3d9, 0xd4de,
	0xc3da, 0xf5eb,
	0xc3db, 0xb6d7,
	0xc3dc, 0xb3f9,
	0xc3dd, 0xf5ea,
	0xc3de, 0xb5c5,
	0xc3df, 0xf5ce,
	0xc3e0, 0xf5ed,
	0xc3e1, 0xeaa5,
	0xc3e2, 0xbdce,
	0xc3e3, 0xb4c7,
	0xc3e4, 0xb1df,
	0xc3e5, 0xe5e5,
	0xc3e7, 0xf5b4,
	0xc3e8, 0xbeb5,
	0xc3e9, 0xefe1,
	0xc3ea, 0xb2f9,
	0xc3eb, 0xefdf,
	0xc3ec, 0xc1b4,
	0xc3ed, 0xefdb,
	0xc3ee, 0xefdc,
	0xc3ef, 0xf7e9,
	0xc3f0, 0xefda,
	0xc3f1, 0xefdd,
	0xc3f2, 0xefcf,
	0xc3f3, 0xefce,
	0xc3f4, 0xefac,
	0xc3f5, 0xf6c9,
	0xc3f6, 0xb9d8,
	0xc3f7, 0xc2a4,
	0xc3f8, 0xc4d1,
	0xc3f9, 0xf6af,
	0xc3fa, 0xceed,
	0xc3fb, 0xc3d2,
	0xc3fc, 0xe8ba,
	0xc3fd, 0xd4cf,
	0xc3fe, 0xc0e0,
	0xc440, 0xd4b8,
	0xc441, 0xb5df,
	0xc442, 0xecac,
	0xc443, 0xc2f8,
	0xc444, 0xe2cb,
	0xc445, 0xe6f0,
	0xc446, 0xc6ad,
	0xc448, 0xbea8,
	0xc449, 0xf6f0,
	0xc44a, 0xf6eb,
	0xc44b, 0xf6f4,
	0xc44c, 0xf0c8,
	0xc44d, 0xf0c4,
	0xc44e, 0xc8b5,
	0xc44f, 0xf0c6,
	0xc450, 0xc5f4,
	0xc451, 0xf7e8,
	0xc452, 0xc0f6,
	0xc453, 0xc2b4,
	0xc454, 0xf4f0,
	0xc455, 0xc8b0,
	0xc456, 0xc1fc,
	0xc457, 0xc8c2,
	0xc458, 0xe0d3,
	0xc459, 0xd1cf,
	0xc45a, 0xbdc0,
	0xc45b, 0xc8c0,
	0xc45c, 0xe6d7,
	0xc45e, 0xc4f5,
	0xc45f, 0xb1a6,
	0xc461, 0xd0fc,
	0xc462, 0xe2e3,
	0xc463, 0xc8c1,
	0xc464, 0xc0b9,
	0xc465, 0xb2f3,
	0xc466, 0xead8,
	0xc467, 0xebca,
	0xc468, 0xe9b4,
	0xc469, 0xc0bd,
	0xc46b, 0xe4f2,
	0xc46c, 0xc2af,
	0xc46d, 0xcfd7,
	0xc46e, 0xe7e7,
	0xc471, 0xbff3,
	0xc472, 0xedc2,
	0xc473, 0xb7af,
	0xc474, 0xc0f9,
	0xc475, 0xf1bc,
	0xc476, 0xbeba,
	0xc477, 0xb3ef,
	0xc478, 0xc0ba,
	0xc479, 0xbcae,
	0xc47a, 0xc5b4,
	0xc47c, 0xb1e8,
	0xc47d, 0xe7cd,
	0xc47e, 0xbccc,
	0xc4a1, 0xd7eb,
	0xc4a2, 0xf3bf,
	0xc4a3, 0xd2ab,
	0xc4a4, 0xebcd,
	0xc4a5, 0xbda2,
	0xc4a6, 0xd4e5,
	0xc4a7, 0xb0aa,
	0xc4a8, 0xc4a2,
	0xc4a9, 0xddfe,
	0xc4aa, 0xc2ab,
	0xc4ab, 0xc6bb,
	0xc4ac, 0xcbd5,
	0xc4ad, 0xd4cc,
	0xc4ae, 0xf2ba,
	0xc4af, 0xc8e4,
	0xc4b0, 0xf1dc,
	0xc4b1, 0xbef5,
	0xc4b2, 0xb4a5,
	0xc4b3, 0xd2e9,
	0xc4b4, 0xc6a9,
	0xc4b5, 0xbeaf,
	0xc4b6, 0xd2eb,
	0xc4b8, 0xdade,
	0xc4b9, 0xd3ae,
	0xc4ba, 0xc9c4,
	0xc4bb, 0xf5bb,
	0xc4bc, 0xd4ea,
	0xc4bd, 0xf5ee,
	0xc4bf, 0xf5b7,
	0xc4c0, 0xcacd,
	0xc4c1, 0xd6d3,
	0xc4c2, 0xeef3,
	0xc4c3, 0xd0e2,
	0xc4c4, 0xb2fb,
	0xc4c5, 0xf6b1,
	0xc4c6, 0xc6ae,
	0xc4c7, 0xc8c4,
	0xc4c9, 0xdcb0,
	0xc4ca, 0xe5b9,
	0xc4cb, 0xccda,
	0xc4cc, 0xc9a7,
	0xc4ce, 0xc8fa,
	0xc4cf, 0xf6fa,
	0xc4d2, 0xb5b3,
	0xc4d3, 0xf7f9,
	0xc4d4, 0xf6b4,
	0xc4d6, 0xc1e4,
	0xc4d7, 0xd9b3,
	0xc4d9, 0xe0bf,
	0xc4da, 0xdff9,
	0xc4db, 0xcff9,
	0xc4dc, 0xd9e7,
	0xc4dd, 0xcaf4,
	0xc4de, 0xcea1,
	0xc4df, 0xbee5,
	0xc4e0, 0xc9e5,
	0xc4e1, 0xc9e3,
	0xc4e2, 0xd0af,
	0xc4e3, 0xecb5,
	0xc4e4, 0xead9,
	0xc4e5, 0xd3a3,
	0xc4e6, 0xc0b8,
	0xc4e7, 0xe8f9,
	0xc4e8, 0xbcdf,
	0xc4e9, 0xb9e0,
	0xc4ea, 0xc0c3,
	0xc4eb, 0xcefe,
	0xc4ed, 0xe8ac,
	0xc4ee, 0xf1ae,
	0xc4f0, 0xccd9,
	0xc4f1, 0xb2f8,
	0xc4f2, 0xd0f8,
	0xc4f3, 0xe5f1,
	0xc4f4, 0xdec1,
	0xc4f5, 0xc0bc,
	0xc4f6, 0xdeba,
	0xc4f7, 0xf2c3,
	0xc4f8, 0xb4c0,
	0xc4f9, 0xf3bb,
	0xc4fa, 0xc0af,
	0xc4fb, 0xcde0,
	0xc4fd, 0xc0c0,
	0xc4fe, 0xc7b4,
	0xc540, 0xbba4,
	0xc541, 0xd3fe,
	0xc542, 0xd4df,
	0xc543, 0xb3ec,
	0xc544, 0xd4be,
	0xc545, 0xf5d2,
	0xc546, 0xbae4,
	0xc547, 0xb1e7,
	0xc548, 0xf5b8,
	0xc549, 0xc1ad,
	0xc54a, 0xc0d8,
	0xc54b, 0xccfa,
	0xc54c, 0xeef5,
	0xc54d, 0xeeec,
	0xc54e, 0xefed,
	0xc54f, 0xefd4,
	0xc551, 0xb0d4,
	0xc552, 0xc5f9,
	0xc553, 0xc2b6,
	0xc554, 0xcfec,
	0xc555, 0xb9cb,
	0xc556, 0xf2ab,
	0xc557, 0xf7cf,
	0xc558, 0xc7fd,
	0xc559, 0xe6f4,
	0xc55a, 0xddeb,
	0xc55b, 0xc2e2,
	0xc55c, 0xf7c3,
	0xc55d, 0xc4a7,
	0xc55e, 0xf7ce,
	0xc55f, 0xf7a2,
	0xc560, 0xf7a4,
	0xc561, 0xddba,
	0xc562, 0xbad7,
	0xc563, 0xf0ce,
	0xc565, 0xf7ea,
	0xc566, 0xf7f6,
	0xc567, 0xdcb1,
	0xc568, 0xf6b7,
	0xc569, 0xf6b8,
	0xc56b, 0xd9b2,
	0xc56c, 0xd9ce,
	0xc56d, 0xdfbd,
	0xc56e, 0xc4d2,
	0xc570, 0xc2cf,
	0xc571, 0xe1db,
	0xc572, 0xc2cd,
	0xc573, 0xcde4,
	0xc574, 0xdcb2,
	0xc575, 0xccaf,
	0xc576, 0xc8a8,
	0xc577, 0xbbb6,
	0xc579, 0xccb2,
	0xc57a, 0xe2a4,
	0xc57b, 0xc8bf,
	0xc57c, 0xb5fe,
	0xc57d, 0xf1ab,
	0xc57e, 0xd1a2,
	0xc5a1, 0xecfc,
	0xc5a2, 0xc1fd,
	0xc5a3, 0xf4a5,
	0xc5a4, 0xc1fb,
	0xc5a5, 0xccfd,
	0xc5a6, 0xd4e0,
	0xc5a7, 0xcfae,
	0xc5a8, 0xb3c4,
	0xc5aa, 0xb6c1,
	0xc5ab, 0xcaea,
	0xc5ac, 0xd8cd,
	0xc5ad, 0xf5dc,
	0xc5ae, 0xf5d9,
	0xc5af, 0xe0ce,
	0xc5b0, 0xdbaa,
	0xc5b1, 0xd6fd,
	0xc5b3, 0xbcf8,
	0xc5b4, 0xf6ab,
	0xc5b5, 0xf6b2,
	0xc5b6, 0xf7b2,
	0xc5b7, 0xe7d6,
	0xc5b8, 0xb2fc,
	0xc5b9, 0xf7d2,
	0xc5ba, 0xbdbe,
	0xc5bb, 0xe6e7,
	0xc5be, 0xb1ee,
	0xc5bf, 0xf6e3,
	0xc5c0, 0xf7a7,
	0xc5c1, 0xf7a9,
	0xc5c2, 0xf0d1,
	0xc5c3, 0xc5b8,
	0xc5c4, 0xf7fa,
	0xc5c5, 0xf6b9,
	0xc5c6, 0xf6ba,
	0xc5c7, 0xb9a8,
	0xc5c9, 0xd1d2,
	0xc5ca, 0xc1b5,
	0xc5cb, 0xc2ce,
	0xc5cc, 0xbef0,
	0xc5cd, 0xbdc1,
	0xc5ce, 0xc9b9,
	0xc5d0, 0xe8b6,
	0xc5d1, 0xc7d4,
	0xc5d2, 0xc7a9,
	0xc5d5, 0xd3a7,
	0xc5d6, 0xcfcb,
	0xc5d9, 0xd5ba,
	0xc5da, 0xc2dc,
	0xc5db, 0xb9c6,
	0xc5dc, 0xb1e4,
	0xc5dd, 0xe5ce,
	0xc5de, 0xc2df,
	0xc5df, 0xeff0,
	0xc5e0, 0xeee5,
	0xc5e2, 0xd8cc,
	0xc5e3, 0xcfd4,
	0xc5e4, 0xf7d0,
	0xc5e5, 0xbeaa,
	0xc5e6, 0xe6e4,
	0xc5e7, 0xd1e9,
	0xc5e8, 0xcbe8,
	0xc5e9, 0xcce5,
	0xc5ea, 0xf7c7,
	0xc5eb, 0xf7ad,
	0xc5ec, 0xc1db,
	0xc5ed, 0xf7ac,
	0xc5ee, 0xf0b8,
	0xc5ef, 0xf7eb,
	0xc5f1, 0xd6f6,
	0xc5f2, 0xb0d3,
	0xc5f3, 0xc0bf,
	0xc5f4, 0xe5b1,
	0xc5f5, 0xccb1,
	0xc5f6, 0xf1b2,
	0xc5f7, 0xb4a3,
	0xc5f8, 0xb9de,
	0xc5f9, 0xeebf,
	0xc5fa, 0xb2cf,
	0xc5fb, 0xf3bc,
	0xc5fc, 0xe1e9,
	0xc5fd, 0xc8c3,
	0xc5fe, 0xb2f7,
	0xc640, 0xdadf,
	0xc641, 0xd1de,
	0xc642, 0xb8d3,
	0xc643, 0xc4f0,
	0xc645, 0xf6a8,
	0xc646, 0xc1e9,
	0xc647, 0xf6b0,
	0xc649, 0xf2ad,
	0xc64a, 0xd6e8,
	0xc64b, 0xf7de,
	0xc64c, 0xf7ca,
	0xc64d, 0xf6d7,
	0xc64e, 0xd3a5,
	0xc64f, 0xf0d8,
	0xc650, 0xbcee,
	0xc650, 0xbcef,
	0xc651, 0xd1ce,
	0xc653, 0xf6bb,
	0xc654, 0xc8a3,
	0xc655, 0xccfc,
	0xc656, 0xe9ad,
	0xc657, 0xcde5,
	0xc658, 0xc0e9,
	0xc659, 0xc2e1,
	0xc65a, 0xc2f9,
	0xc65b, 0xb9db,
	0xc65c, 0xf5e6,
	0xc65e, 0xcfe2,
	0xc65f, 0xd4bf,
	0xc660, 0xc2ad,
	0xc661, 0xb2f6,
	0xc662, 0xf7c5,
	0xc663, 0xf7e0,
	0xc664, 0xd9e4,
	0xc665, 0xc2d0,
	0xc666, 0xd6f5,
	0xc667, 0xd4de,
	0xc668, 0xc4f7,
	0xc669, 0xf7b5,
	0xc66a, 0xc2bf,
	0xc66b, 0xe6f7,
	0xc66c, 0xc0c2,
	0xc66d, 0xdad4,
	0xc66e, 0xf5ef,
	0xc66f, 0xf5a6,
	0xc670, 0xd7ea,
	0xc671, 0xf6c7,
	0xc672, 0xc2e0,
	0xc673, 0xf6f9,
	0xc674, 0xf6d4,
	0xc675, 0xf7f2,
	0xc677, 0xd4e4,
	0xc678, 0xf0d0,
	0xc679, 0xece0,
	0xc67a, 0xe6ea,
	0xc67b, 0xd3f4,
	0xc67c, 0xf0d9,
	0xc67d, 0xf0bd,
	0xc941, 0xd8bf,
	0xc943, 0xd8ce,
	0xc946, 0xd8a2,
	0xc947, 0xd8b1,
	0xc948, 0xd8a1,
	0xc949, 0xe0ed,
	0xc94c, 0xe1dc,
	0xc951, 0xd8c1,
	0xc952, 0xd8ec,
	0xc953, 0xd8eb,
	0xc965, 0xd8ed,
	0xc968, 0xd8ee,
	0xc969, 0xd9da,
	0xc971, 0xbabb,
	0xc973, 0xe5b3,
	0xc975, 0xe5ea,
	0xc979, 0xe2cf,
	0xc97b, 0xe2e1,
	0xc97e, 0xebad,
	0xc9a6, 0xe1ec,
	0xc9ab, 0xbcbf,
	0xc9ae, 0xd8f5,
	0xc9b7, 0xd8f3,
	0xc9bc, 0xd9fc,
	0xc9c6, 0xe0ef,
	0xc9c7, 0xd8b6,
	0xc9c8, 0xdbdc,
	0xc9c9, 0xdbd9,
	0xc9cb, 0xdec5,
	0xc9d4, 0xe6d8,
	0xc9d5, 0xdecd,
	0xc9d7, 0xe1a8,
	0xc9dc, 0xd7af,
	0xc9dd, 0xd2ec,
	0xc9e2, 0xe2e3,
	0xc9e7, 0xc7a4,
	0xc9ed, 0xeab9,
	0xc9ee, 0xeab8,
	0xc9f3, 0xbbfa,
	0xc9f7, 0xebae,
	0xc9f8, 0xd9db,
	0xc9f8, 0xd9e0,
	0xc9fa, 0xe3e1,
	0xc9fc, 0xe3e2,
	0xc9fd, 0xe3e0,
	0xca43, 0xe1ed,
	0xca45, 0xe7e0,
	0xca49, 0xcdf8,
	0xca4d, 0xdcb4,
	0xca4e, 0xdcb5,
	0xca4f, 0xf2ae,
	0xca51, 0xdaf8,
	0xca52, 0xdaf5,
	0xca54, 0xdaf6,
	0xca56, 0xdae3,
	0xca5e, 0xcce5,
	0xca5f, 0xd8f4,
	0xca61, 0xd8fb,
	0xca63, 0xd9a1,
	0xca65, 0xd9dc,
	0xca6f, 0xdbbf,
	0xca72, 0xd8d5,
	0xca79, 0xdfbe,
	0xcaa4, 0xb6d6,
	0xcaac, 0xdbd0,
	0xcab5, 0xe6a1,
	0xcac0, 0xe1a9,
	0xcac2, 0xe1ac,
	0xcacd, 0xe2d1,
	0xcad6, 0xdfaf,
	0xcad7, 0xecfd,
	0xcad8, 0xecfe,
	0xcad9, 0xe2ed,
	0xcadb, 0xe2e5,
	0xcadd, 0xe2e7,
	0xcade, 0xe2e8,
	0xcae3, 0xd0c3,
	0xcae4, 0xbbb3,
	0xcaf0, 0xc8c5,
	0xcaf8, 0xeaba,
	0xcb42, 0xe8bb,
	0xcb43, 0xe8be,
	0xcb49, 0xebaf,
	0xcb4a, 0xebb0,
	0xcb50, 0xc6e3,
	0xcb53, 0xe3e9,
	0xcb63, 0xe1f0,
	0xcb65, 0xe1f1,
	0xcb6d, 0xeeae,
	0xcb6f, 0xf0db,
	0xcb78, 0xebc0,
	0xcb7a, 0xdcb6,
	0xcb7c, 0xdcba,
	0xcb7d, 0xdcbb,
	0xcba1, 0xdcb7,
	0xcba3, 0xdcb9,
	0xcba4, 0xf5f4,
	0xcba8, 0xdafa,
	0xcbb3, 0xd9ae,
	0xcbb8, 0xd9a5,
	0xcbb9, 0xd9a6,
	0xcbba, 0xd9a8,
	0xcbbb, 0xd6b6,
	0xcbbe, 0xb6b1,
	0xcbc6, 0xd9b0,
	0xcbce, 0xd9fe,
	0xcbd2, 0xd8da,
	0xcbdf, 0xdfc6,
	0xcbe7, 0xdfcf,
	0xcbef, 0xdfca,
	0xcbf1, 0xe0f2,
	0xcbf2, 0xc5f7,
	0xcbf4, 0xdbe8,
	0xcbf5, 0xdbe3,
	0xcbf8, 0xdbe9,
	0xcbfb, 0xdbe6,
	0xcbfc, 0xdbea,
	0xcc40, 0xdbe7,
	0xcc48, 0xe6a7,
	0xcc55, 0xe6df,
	0xcc56, 0xe6db,
	0xcc57, 0xe5b5,
	0xcc58, 0xe5b4,
	0xcc5e, 0xe1b2,
	0xcc61, 0xe1b5,
	0xcc63, 0xe1b8,
	0xcc64, 0xc1eb,
	0xcc65, 0xe1b3,
	0xcc6e, 0xe0fa,
	0xcc6f, 0xe0f9,
	0xcc75, 0xe1de,
	0xcc7b, 0xe2f1,
	0xcc7c, 0xe2ef,
	0xcca2, 0xe2f7,
	0xcca9, 0xe2f4,
	0xccb0, 0xc1af,
	0xccb1, 0xeaa7,
	0xccb2, 0xece6,
	0xccb9, 0xded4,
	0xccbd, 0xded3,
	0xccca, 0xeabe,
	0xccd2, 0xebc3,
	0xccd9, 0xe8c4,
	0xccdb, 0xb9b9,
	0xccee, 0xedb3,
	0xccf0, 0xe3f9,
	0xccf1, 0xe3fa,
	0xccf4, 0xe3ef,
	0xccf5, 0xe3f0,
	0xccf8, 0xe3ee,
	0xcd46, 0xc5a2,
	0xcd50, 0xc8b2,
	0xcd52, 0xeac1,
	0xcd57, 0xecc0,
	0xcd61, 0xe1f4,
	0xcd6a, 0xe7e3,
	0xcd71, 0xeeaf,
	0xcd72, 0xe7de,
	0xcd77, 0xedec,
	0xcd7a, 0xedb7,
	0xcda5, 0xf1b6,
	0xcdaa, 0xf1f4,
	0xcdac, 0xb0b9,
	0xcdb0, 0xebc7,
	0xcdb4, 0xdcbe,
	0xcdb6, 0xdcc5,
	0xcdba, 0xdcc7,
	0xcdbe, 0xdccc,
	0xcdbf, 0xdcb8,
	0xcdc0, 0xdccd,
	0xcdc1, 0xdccb,
	0xcdc3, 0xdcd2,
	0xcdc8, 0xf2b0,
	0xcdca, 0xf2b1,
	0xcdce, 0xe5c2,
	0xcdd1, 0xe5c3,
	0xcdd4, 0xdafb,
	0xcdd5, 0xbaaa,
	0xcdd6, 0xdafc,
	0xcdd7, 0xdba2,
	0xcdd9, 0xdae7,
	0xcdda, 0xdae8,
	0xcdde, 0xd9b4,
	0xcde3, 0xd9b6,
	0xcde5, 0xd9b7,
	0xcdf0, 0xd8d9,
	0xcdf8, 0xd8c7,
	0xcdf9, 0xc0e5,
	0xcdfc, 0xdfd2,
	0xcdfe, 0xdfe7,
	0xce47, 0xb6df,
	0xce4d, 0xdfda,
	0xce4e, 0xdfe8,
	0xce53, 0xdbec,
	0xce54, 0xdbed,
	0xce57, 0xb6e2,
	0xce60, 0xb8b4,
	0xce67, 0xe6ad,
	0xce7d, 0xe1be,
	0xceaf, 0xdae1,
	0xceba, 0xe2d3,
	0xcebd, 0xe5e8,
	0xcecb, 0xe2fe,
	0xced3, 0xece7,
	0xced8, 0xbfe6,
	0xcedf, 0xded9,
	0xceeb, 0xeac6,
	0xceee, 0xeac7,
	0xcef5, 0xeac3,
	0xcef6, 0xeac4,
	0xcefa, 0xebd4,
	0xcefb, 0xe8de,
	0xcf40, 0xb9f1,
	0xcf43, 0xe8cf,
	0xcf45, 0xbccf,
	0xcf4a, 0xe8d5,
	0xcf4c, 0xe8d7,
	0xcf55, 0xe8cd,
	0xcf61, 0xe8da,
	0xcf65, 0xe9e3,
	0xcf66, 0xe9e5,
	0xcf68, 0xb1d1,
	0xcf6c, 0xebb1,
	0xcf71, 0xcddd,
	0xcf73, 0xc8f7,
	0xcf76, 0xe4b2,
	0xcf77, 0xe4a7,
	0xcf78, 0xe4a8,
	0xcf7a, 0xe4ae,
	0xcfa1, 0xbde0,
	0xcfa7, 0xe4a6,
	0xcfae, 0xecc4,
	0xcfb1, 0xecc6,
	0xcfbd, 0xeaf0,
	0xcfc0, 0xe1f5,
	0xcfc8, 0xe7e6,
	0xcfc9, 0xe7ec,
	0xcfd8, 0xcecd,
	0xcfdb, 0xeeb2,
	0xcfe0, 0xedf1,
	0xcfe2, 0xeded,
	0xcfe8, 0xeff2,
	0xcfeb, 0xedbc,
	0xcfec, 0xc5f8,
	0xcff1, 0xedb9,
	0xcff9, 0xeff5,
	0xcffa, 0xd6d6,
	0xcffe, 0xf1b8,
	0xd04b, 0xe6fd,
	0xd04d, 0xeeb7,
	0xd054, 0xf1e8,
	0xd055, 0xdec7,
	0xd057, 0xdbcf,
	0xd05b, 0xebcf,
	0xd05f, 0xebd1,
	0xd060, 0xcaa4,
	0xd065, 0xebd3,
	0xd067, 0xebd2,
	0xd069, 0xf4ad,
	0xd06d, 0xc6bb,
	0xd06e, 0xdcd8,
	0xd071, 0xdce6,
	0xd072, 0xdcfb,
	0xd073, 0xc9bb,
	0xd075, 0xdcda,
	0xd077, 0xdcd3,
	0xd07a, 0xdcdd,
	0xd07b, 0xdcde,
	0xd0a1, 0xdcd6,
	0xd0a2, 0xdce5,
	0xd0a8, 0xf2b4,
	0xd0ae, 0xf1c3,
	0xd0b1, 0xd9ea,
	0xd0b5, 0xe5c5,
	0xd0bb, 0xdba4,
	0xd0bc, 0xdba5,
	0xd0bd, 0xdba8,
	0xd0c0, 0xeec6,
	0xd0c1, 0xeec5,
	0xd0c2, 0xdaeb,
	0xd0d3, 0xd9be,
	0xd0d7, 0xd9c3,
	0xd0de, 0xb5b3,
	0xd0e2, 0xc6e0,
	0xd0e6, 0xd8df,
	0xd0e9, 0xd8de,
	0xd0f4, 0xdfea,
	0xd0f5, 0xdfee,
	0xd0f8, 0xdbc1,
	0xd0f9, 0xdfc2,
	0xd0fc, 0xdff2,
	0xd14c, 0xdbf4,
	0xd14d, 0xdbf8,
	0xd152, 0xdbf9,
	0xd165, 0xd8ab,
	0xd179, 0xe5f2,
	0xd17c, 0xeda2,
	0xd17d, 0xeda3,
	0xd17e, 0xeda4,
	0xd1a1, 0xeda5,
	0xd1a5, 0xe3a8,
	0xd1a7, 0xe3a6,
	0xd1a8, 0xe3a7,
	0xd1aa, 0xe3aa,
	0xd1b6, 0xcdb1,
	0xd1b8, 0xdedc,
	0xd1ba, 0xdeda,
	0xd1bb, 0xdedb,
	0xd1cf, 0xecb7,
	0xd1d0, 0xecb9,
	0xd1d1, 0xecb8,
	0xd1d4, 0xeac9,
	0xd1db, 0xe8f1,
	0xd1dc, 0xe8e0,
	0xd1dd, 0xe8e1,
	0xd1e1, 0xc6dc,
	0xd1e8, 0xe8e4,
	0xd1e9, 0xe8e6,
	0xd1eb, 0xe8e9,
	0xd246, 0xe4bd,
	0xd24f, 0xe4b4,
	0xd250, 0xe4b3,
	0xd255, 0xe4b7,
	0xd257, 0xe4bb,
	0xd25a, 0xe4bc,
	0xd25c, 0xcdbf,
	0xd2a4, 0xe1fe,
	0xd2a5, 0xe1f9,
	0xd2a8, 0xe1fc,
	0xd2a9, 0xe2a1,
	0xd2aa, 0xe1fb,
	0xd2ac, 0xe7ee,
	0xd2ad, 0xe7ed,
	0xd2b0, 0xe7f2,
	0xd2b2, 0xe7f1,
	0xd2bc, 0xf0ac,
	0xd2be, 0xeab2,
	0xd2c1, 0xeeb3,
	0xd2c3, 0xf0e6,
	0xd2c6, 0xf0e4,
	0xd2d5, 0xedf4,
	0xd2d6, 0xedf2,
	0xd2d7, 0xedf3,
	0xd2d9, 0xedc8,
	0xd2da, 0xedc7,
	0xd2dc, 0xb2a7,
	0xd2e2, 0xedc9,
	0xd2e7, 0xecee,
	0xd2e9, 0xecef,
	0xd2ea, 0xecf0,
	0xd2ed, 0xeff8,
	0xd2f1, 0xeff6,
	0xd2f6, 0xf1b9,
	0xd340, 0xf3c7,
	0xd343, 0xf3cb,
	0xd344, 0xf3c5,
	0xd345, 0xf3c9,
	0xd34a, 0xf4ce,
	0xd356, 0xe7a3,
	0xd35c, 0xeeb8,
	0xd35f, 0xd6c3,
	0xd366, 0xf1e9,
	0xd369, 0xb0b7,
	0xd36a, 0xebdc,
	0xd370, 0xf4a8,
	0xd371, 0xf4b1,
	0xd373, 0xdcfc,
	0xd374, 0xdcfa,
	0xd377, 0xdce8,
	0xd37d, 0xdce7,
	0xd3a3, 0xdda2,
	0xd3a5, 0xdceb,
	0xd3a6, 0xdced,
	0xd3ac, 0xdcf2,
	0xd3ae, 0xdcf4,
	0xd3b3, 0xb2e7,
	0xd3b5, 0xbceb,
	0xd3ba, 0xf2b6,
	0xd3bc, 0xf2b7,
	0xd3c2, 0xf2b8,
	0xd3c8, 0xf2bb,
	0xd3c9, 0xb2cf,
	0xd3cc, 0xf2ba,
	0xd3d0, 0xf4ac,
	0xd3d4, 0xf1c4,
	0xd3d7, 0xf1c6,
	0xd3da, 0xf4c0,
	0xd3de, 0xf4f8,
	0xd3e3, 0xb8cf,
	0xd3e5, 0xf5c0,
	0xd3ec, 0xcaca,
	0xd3ef, 0xe5cc,
	0xd3f7, 0xdba3,
	0xd3fa, 0xdbae,
	0xd3fb, 0xdbad,
	0xd3fc, 0xdbac,
	0xd3fe, 0xf4fb,
	0xd440, 0xf4fc,
	0xd441, 0xf4fd,
	0xd442, 0xeec9,
	0xd446, 0xdaec,
	0xd447, 0xf6c0,
	0xd449, 0xf7d4,
	0xd44a, 0xdbcb,
	0xd455, 0xd9ca,
	0xd46c, 0xb9d0,
	0xd46d, 0xdbc3,
	0xd46f, 0xd8d0,
	0xd471, 0xe0a3,
	0xd472, 0xe0a4,
	0xd475, 0xdffd,
	0xd477, 0xdff4,
	0xd47c, 0xe0a7,
	0xd4a3, 0xc9b6,
	0xd4ab, 0xe0f5,
	0xd4ac, 0xe0f0,
	0xd4b2, 0xdbfa,
	0xd4b3, 0xdca5,
	0xd4b4, 0xdca4,
	0xd4b5, 0xdca3,
	0xd4b7, 0xdbfc,
	0xd4b8, 0xdca1,
	0xd4ba, 0xdbef,
	0xd4bb, 0xddc0,
	0xd4c1, 0xdbeb,
	0xd4cb, 0xdca2,
	0xd4d0, 0xe6bc,
	0xd4d1, 0xe6ba,
	0xd4d5, 0xe6ab,
	0xd4f3, 0xe5ed,
	0xd4f4, 0xe1c6,
	0xd4fb, 0xe1c1,
	0xd4fc, 0xe1c3,
	0xd544, 0xe1c4,
	0xd549, 0xe2d5,
	0xd54b, 0xe2d8,
	0xd55c, 0xe3ae,
	0xd55e, 0xe3ad,
	0xd561, 0xbeaa,
	0xd566, 0xeafd,
	0xd568, 0xdee5,
	0xd569, 0xb5e0,
	0xd56d, 0xdedd,
	0xd571, 0xdee1,
	0xd573, 0xb6de,
	0xd574, 0xc6fe,
	0xd575, 0xbedd,
	0xd579, 0xdee3,
	0xd57a, 0xdee7,
	0xd5aa, 0xeace,
	0xd5be, 0xe8f5,
	0xd5c0, 0xe8f4,
	0xd5c1, 0xe8f6,
	0xd5c4, 0xe8f8,
	0xd5d8, 0xeca4,
	0xd5dc, 0xe9e8,
	0xd5df, 0xebb4,
	0xd5e1, 0xe4ca,
	0xd5e9, 0xe4b5,
	0xd5ed, 0xe4c4,
	0xd5ef, 0xc4d7,
	0xd5f1, 0xe4cb,
	0xd5f3, 0xe4c7,
	0xd64a, 0xcde9,
	0xd64c, 0xccfe,
	0xd651, 0xecc9,
	0xd655, 0xecca,
	0xd65c, 0xeaf5,
	0xd65f, 0xeaf6,
	0xd660, 0xe2a7,
	0xd661, 0xe2a2,
	0xd665, 0xe2a5,
	0xd669, 0xe2a6,
	0xd67d, 0xd1f7,
	0xd6aa, 0xedf5,
	0xd6a9, 0xc3d0,
	0xd6b0, 0xedf6,
	0xd6b2, 0xedf7,
	0xd6b4, 0xcef8,
	0xd6b8, 0xedd1,
	0xd6b9, 0xedce,
	0xd6ba, 0xb9e8,
	0xd6bb, 0xedcf,
	0xd6bd, 0xecf6,
	0xd6c3, 0xc0eb,
	0xd6c5, 0xbdd5,
	0xd6cc, 0xf3cc,
	0xd6ce, 0xf3d3,
	0xd6d1, 0xf3d4,
	0xd6d2, 0xf3d5,
	0xd6d4, 0xf3ce,
	0xd6d6, 0xf3d1,
	0xd6d7, 0xf3ca,
	0xd6db, 0xf3cd,
	0xd6df, 0xd5b3,
	0xd6e6, 0xe7a4,
	0xd6f4, 0xf4c6,
	0xd6f6, 0xf1b4,
	0xd743, 0xf1f5,
	0xd745, 0xebe4,
	0xd748, 0xebd6,
	0xd74b, 0xebe3,
	0xd74c, 0xebe2,
	0xd753, 0xf4b4,
	0xd754, 0xf4b6,
	0xd756, 0xf4b7,
	0xd758, 0xe5f5,
	0xd75b, 0xddb9,
	0xd767, 0xddb3,
	0xd768, 0xddb4,
	0xd76c, 0xdcf0,
	0xd76d, 0xddad,
	0xd774, 0xdda8,
	0xd7a4, 0xf2c5,
	0xd7a5, 0xf2c4,
	0xd7ab, 0xf2ca,
	0xd7b5, 0xf1c8,
	0xd7b6, 0xecee,
	0xd7c0, 0xd9f3,
	0xd7c6, 0xf5fb,
	0xd7d6, 0xf5c2,
	0xd7d9, 0xf5c1,
	0xd7e3, 0xe5cd,
	0xd7e4, 0xe5cf,
	0xd7e7, 0xe5d2,
	0xd7e8, 0xdbb0,
	0xd7eb, 0xb3bb,
	0xd7ef, 0xdbaf,
	0xd7f4, 0xb7d3,
	0xd7fc, 0xeecc,
	0xd7fd, 0xeecf,
	0xd841, 0xeeca,
	0xd845, 0xe3c6,
	0xd850, 0xd8b8,
	0xd856, 0xb4f6,
	0xd866, 0xe0b3,
	0xd86a, 0xe0a5,
	0xd86e, 0xe0ae,
	0xd86f, 0xdff6,
	0xd870, 0xdff7,
	0xd871, 0xe0af,
	0xd8a1, 0xdca7,
	0xd8a2, 0xdca6,
	0xd8b5, 0xe6a3,
	0xd8b8, 0xe6c4,
	0xd8db, 0xe1d1,
	0xd8dd, 0xe1d2,
	0xd8e3, 0xe1ce,
	0xd8e6, 0xe1cc,
	0xd8f2, 0xe1a2,
	0xd8f4, 0xe5e9,
	0xd940, 0xe3a2,
	0xd954, 0xeafe,
	0xd955, 0xdeef,
	0xd95d, 0xdeeb,
	0xd95e, 0xdede,
	0xd960, 0xdee9,
	0xd964, 0xdef2,
	0xd967, 0xdeed,
	0xd979, 0xb1f3,
	0xd97e, 0xecbc,
	0xd9b1, 0xc0e2,
	0xd9b2, 0xe8e2,
	0xd9b3, 0xe8c7,
	0xd9b9, 0xe9a7,
	0xd9c8, 0xe8fb,
	0xd9ca, 0xe9a3,
	0xd9da, 0xeca5,
	0xd9e5, 0xeba5,
	0xd9e6, 0xc7e8,
	0xd9e7, 0xedb5,
	0xd9ec, 0xe3ed,
	0xd9f1, 0xe4cd,
	0xd9fe, 0xe4a5,
	0xda47, 0xe4d0,
	0xda4b, 0xe4d4,
	0xda5a, 0xeccc,
	0xda5d, 0xeccd,
	0xda6c, 0xeaf8,
	0xda70, 0xe2a9,
	0xda71, 0xe2ae,
	0xda7a, 0xe7fd,
	0xda7b, 0xe7fe,
	0xda7c, 0xe7fc,
	0xdaa1, 0xe8a2,
	0xdaac, 0xe5b8,
	0xdaae, 0xeeb4,
	0xdaaf, 0xf0f0,
	0xdab2, 0xf0ed,
	0xdab5, 0xf0ee,
	0xdabb, 0xedfb,
	0xdac4, 0xeff3,
	0xdac6, 0xedcc,
	0xdac9, 0xedcb,
	0xdacb, 0xedd2,
	0xdacc, 0xc8b7,
	0xdacf, 0xedba,
	0xdad6, 0xeffc,
	0xdad8, 0xeffb,
	0xdadc, 0xf1b5,
	0xdae2, 0xf3dc,
	0xdae5, 0xf3d8,
	0xdae6, 0xf3da,
	0xdae7, 0xf4d2,
	0xdae8, 0xf4d1,
	0xdafb, 0xe7ac,
	0xdb43, 0xcfdb,
	0xdb4b, 0xc0b0,
	0xdb57, 0xf4aa,
	0xdb5d, 0xbaca,
	0xdb5e, 0xddcf,
	0xdb60, 0xddd2,
	0xdb6d, 0xddbd,
	0xdb6e, 0xddc3,
	0xdb6f, 0xddbe,
	0xdb70, 0xddbf,
	0xdb72, 0xddd5,
	0xdb75, 0xddc5,
	0xdb79, 0xddcc,
	0xdb7b, 0xddc8,
	0xdb7c, 0xddc9,
	0xdba3, 0xb9bd,
	0xdba5, 0xddd0,
	0xdbb1, 0xf2d5,
	0xdbbc, 0xf2cb,
	0xdbbf, 0xf2d6,
	0xdbca, 0xf1cb,
	0xdbcb, 0xf1ca,
	0xdbcf, 0xf1cc,
	0xdbd1, 0xeae8,
	0xdbd4, 0xf5fd,
	0xdbd6, 0xdaaa,
	0xdbdf, 0xdab1,
	0xdbe0, 0xeeba,
	0xdbe8, 0xeadc,
	0xdbea, 0xeadb,
	0xdbed, 0xf4f2,
	0xdbf4, 0xf5c5,
	0xdbf6, 0xf5ca,
	0xdbfa, 0xf5c6,
	0xdbfe, 0xe9f7,
	0xdc40, 0xe9f2,
	0xdc48, 0xe9f4,
	0xdc4d, 0xe5d5,
	0xdc4f, 0xe5d6,
	0xdc50, 0xdba9,
	0xdc52, 0xdbb2,
	0xdc5d, 0xf5a2,
	0xdc5e, 0xf4fe,
	0xdc60, 0xf5a1,
	0xdc62, 0xeed5,
	0xdc64, 0xeed8,
	0xdc67, 0xeed1,
	0xdc6a, 0xeed9,
	0xdc6f, 0xeed7,
	0xdc70, 0xeed6,
	0xdc7a, 0xe3ca,
	0xdc7e, 0xdaf1,
	0xdca1, 0xdaed,
	0xdcac, 0xf1fc,
	0xdcae, 0xe2c0,
	0xdcb0, 0xede9,
	0xdcba, 0xd8f1,
	0xdcbc, 0xd9cd,
	0xdcbf, 0xd9d1,
	0xdcc2, 0xd9dd,
	0xdccc, 0xe0c9,
	0xdcd0, 0xe0c3,
	0xdcd2, 0xe0c1,
	0xdcd3, 0xe0c4,
	0xdcd4, 0xdfef,
	0xdcd6, 0xe0aa,
	0xdcdb, 0xe0b2,
	0xdcdd, 0xe0c7,
	0xdcde, 0xe0ca,
	0xdce4, 0xdbf7,
	0xdce5, 0xdbee,
	0xdce6, 0xebf3,
	0xdced, 0xdcaa,
	0xdcf7, 0xe6ca,
	0xdcf9, 0xebf4,
	0xdd4f, 0xe1d3,
	0xdd52, 0xe1cd,
	0xdd62, 0xecb0,
	0xdd64, 0xe1e6,
	0xdd67, 0xe3bb,
	0xdd68, 0xe3ba,
	0xdd75, 0xeaad,
	0xdd76, 0xeaae,
	0xdd7a, 0xb4a4,
	0xdd7d, 0xdef7,
	0xddab, 0xdef9,
	0xddae, 0xdef4,
	0xddb6, 0xdef5,
	0xddb8, 0xdef6,
	0xddba, 0xdefa,
	0xddc0, 0xead2,
	0xddc9, 0xe9b8,
	0xddce, 0xe9a8,
	0xddcf, 0xb4bb,
	0xddd2, 0xe9a9,
	0xddd3, 0xe9ab,
	0xddd4, 0xe9a5,
	0xdddc, 0xb4aa,
	0xddde, 0xe9a2,
	0xdddf, 0xe9b1,
	0xdde0, 0xe9b2,
	0xddf5, 0xeca7,
	0xddf7, 0xeca6,
	0xddfb, 0xe9ea,
	0xde40, 0xeba8,
	0xde46, 0xe4e7,
	0xde48, 0xe4e9,
	0xde4c, 0xe4da,
	0xde50, 0xe4e1,
	0xde51, 0xb3fc,
	0xde54, 0xe4e3,
	0xde58, 0xe4e6,
	0xde59, 0xe4d1,
	0xde6d, 0xecbf,
	0xde72, 0xdce4,
	0xde73, 0xecd2,
	0xde74, 0xecd4,
	0xdea5, 0xeaf9,
	0xdeac, 0xe1f8,
	0xdeb3, 0xe7e2,
	0xdeb6, 0xe8a5,
	0xdec0, 0xeab3,
	0xdec4, 0xeeb5,
	0xdec9, 0xf0f1,
	0xdecb, 0xf0e2,
	0xdecc, 0xf0f3,
	0xdecf, 0xf0f5,
	0xded5, 0xf0aa,
	0xdedd, 0xedfd,
	0xdee4, 0xedd6,
	0xdee5, 0xedd5,
	0xdeec, 0xedd8,
	0xdefb, 0xb0de,
	0xdf4b, 0xf3e2,
	0xdf4e, 0xf3e3,
	0xdf54, 0xf4d3,
	0xdf57, 0xe7b0,
	0xdf58, 0xe7ae,
	0xdf60, 0xe7af,
	0xdf6a, 0xeebb,
	0xdf6d, 0xf4c7,
	0xdf6e, 0xf4c8,
	0xdf73, 0xebed,
	0xdf76, 0xebee,
	0xdfa2, 0xebe1,
	0xdfa4, 0xf4ba,
	0xdfa5, 0xf4b9,
	0xdfac, 0xdde3,
	0xdfb1, 0xddd7,
	0xdfb8, 0xddd8,
	0xdfb9, 0xddd9,
	0xdfbb, 0xddda,
	0xdfc2, 0xdddd,
	0xdfc4, 0xdddf,
	0xdfd2, 0xdda6,
	0xdfd5, 0xdde5,
	0xdfe6, 0xf2cc,
	0xdfea, 0xf2d9,
	0xdfec, 0xf2dd,
	0xdfef, 0xf2dc,
	0xdff4, 0xf1ce,
	0xdffd, 0xf6a1,
	0xe043, 0xf5fe,
	0xe046, 0xdab2,
	0xe047, 0xdab4,
	0xe048, 0xdabc,
	0xe04c, 0xdab3,
	0xe04d, 0xdab7,
	0xe05a, 0xf5f7,
	0xe05e, 0xf4f4,
	0xe064, 0xf4f3,
	0xe069, 0xf5cd,
	0xe06e, 0xf5d0,
	0xe072, 0xf5bc,
	0xe078, 0xe9fb,
	0xe079, 0xe9fa,
	0xe07d, 0xe5d9,
	0xe0a1, 0xe5d7,
	0xe0a8, 0xd4c7,
	0xe0a9, 0xdaf9,
	0xe0ac, 0xcdaa,
	0xe0ad, 0xf5a5,
	0xe0ae, 0xeee8,
	0xe0b0, 0xeee6,
	0xe0b1, 0xeeda,
	0xe0b2, 0xeedb,
	0xe0b3, 0xeedd,
	0xe0b5, 0xeee1,
	0xe0b6, 0xefa5,
	0xe0b7, 0xeeea,
	0xe0ba, 0xeee3,
	0xe0bb, 0xeee2,
	0xe0d4, 0xdaf3,
	0xe0d5, 0xf6c2,
	0xe0da, 0xbdf9,
	0xe0de, 0xf1fe,
	0xe0e0, 0xf1fd,
	0xe0ed, 0xd9ec,
	0xe0ef, 0xf6bc,
	0xe0f0, 0xd9d6,
	0xe0f3, 0xd9c7,
	0xe0f4, 0xc0fc,
	0xe0f4, 0xcbdb,
	0xe0fa, 0xd9d5,
	0xe142, 0xd8e4,
	0xe147, 0xe0d7,
	0xe149, 0xe0d1,
	0xe14c, 0xd8c5,
	0xe14d, 0xdfe9,
	0xe14e, 0xe0d2,
	0xe156, 0xdcad,
	0xe15b, 0xdcac,
	0xe161, 0xc9ca,
	0xe16b, 0xe6d1,
	0xe172, 0xe6c6,
	0xe175, 0xe6cb,
	0xe1a2, 0xe5ef,
	0xe1a3, 0xe1d6,
	0xe1a8, 0xe1d0,
	0xe1b2, 0xe0fd,
	0xe1b6, 0xe2db,
	0xe1bc, 0xe2da,
	0xe1c3, 0xeda8,
	0xe1c7, 0xe3a5,
	0xe1d3, 0xe2e6,
	0xe1d6, 0xeaaf,
	0xe1d7, 0xeaa8,
	0xe1de, 0xded2,
	0xe1e0, 0xbfd9,
	0xe1e6, 0xc1cc,
	0xe1e7, 0xdefb,
	0xe1e8, 0xdee8,
	0xe1ee, 0xeba1,
	0xe1fc, 0xe9c1,
	0xe241, 0xe9b6,
	0xe249, 0xe9bc,
	0xe24a, 0xe9c7,
	0xe24e, 0xe8e7,
	0xe252, 0xe9c0,
	0xe254, 0xe9c3,
	0xe259, 0xe8bf,
	0xe25e, 0xdef8,
	0xe266, 0xe9e6,
	0xe26c, 0xdcfe,
	0xe271, 0xe4b0,
	0xe275, 0xe4f5,
	0xe278, 0xc5bd,
	0xe2a1, 0xe4f1,
	0xe2a3, 0xe4ef,
	0xe2a5, 0xe4dd,
	0xe2a9, 0xe4d3,
	0xe2c0, 0xd1ac,
	0xe2cb, 0xe2b0,
	0xe2dc, 0xf0f8,
	0xe2dd, 0xf0fd,
	0xe2df, 0xf0fa,
	0xe2e1, 0xf1e4,
	0xe2e4, 0xb3f2,
	0xe2e7, 0xeea6,
	0xe2eb, 0xedda,
	0xe2ed, 0xb2ea,
	0xe2ee, 0xedb8,
	0xe2f3, 0xeddc,
	0xe2f9, 0xecf9,
	0xe34a, 0xf1bf,
	0xe34c, 0xf1be,
	0xe34f, 0xf3ed,
	0xe352, 0xf3e4,
	0xe354, 0xb9bf,
	0xe358, 0xf3eb,
	0xe360, 0xf4d4,
	0xe365, 0xe7b9,
	0xe36c, 0xe7b5,
	0xe36e, 0xe7b3,
	0xe371, 0xe7b8,
	0xe375, 0xf4eb,
	0xe376, 0xf4ec,
	0xe37d, 0xf4e3,
	0xe3a6, 0xebf0,
	0xe3ac, 0xddf5,
	0xe3ae, 0xddf2,
	0xe3b0, 0xddf0,
	0xe3b6, 0xddf3,
	0xe3b7, 0xddf4,
	0xe3b8, 0xdde8,
	0xe3b9, 0xdde9,
	0xe3bd, 0xddea,
	0xe3c2, 0xddaa,
	0xe3c7, 0xd8e1,
	0xe3c9, 0xb1cd,
	0xe3d6, 0xf2de,
	0xe3da, 0xf2e2,
	0xe3db, 0xf2e0,
	0xe3e2, 0xf2e4,
	0xe3e9, 0xd1d1,
	0xe3eb, 0xf2e7,
	0xe3f2, 0xf2e3,
	0xe3f7, 0xf1d1,
	0xe3fa, 0xf1d5,
	0xe3fc, 0xf1d3,
	0xe440, 0xf1d6,
	0xe444, 0xeaea,
	0xe448, 0xf6a2,
	0xe44d, 0xdac0,
	0xe453, 0xeae4,
	0xe457, 0xf5d4,
	0xe45b, 0xf5d5,
	0xe460, 0xf5bd,
	0xe468, 0xdbb5,
	0xe46b, 0xdbb3,
	0xe473, 0xf5a8,
	0xe474, 0xf5aa,
	0xe476, 0xd2bf,
	0xe47a, 0xeeef,
	0xe47b, 0xeeee,
	0xe47d, 0xeef0,
	0xe4a1, 0xeef7,
	0xe4a2, 0xefa2,
	0xe4a3, 0xefa4,
	0xe4a6, 0xeefe,
	0xe4a7, 0xefa8,
	0xe4a8, 0xeef1,
	0xe4a9, 0xf6c6,
	0xe4b7, 0xeefb,
	0xe4cd, 0xeca9,
	0xe4da, 0xf7ba,
	0xe4ea, 0xd9d3,
	0xe4eb, 0xd9d8,
	0xe4ee, 0xd9d9,
	0xe4f3, 0xd8db,
	0xe4f4, 0xdbbd,
	0xe4f8, 0xe0e1,
	0xe4f9, 0xdfd8,
	0xe4fe, 0xe0d9,
	0xe544, 0xe0dc,
	0xe546, 0xdfbc,
	0xe562, 0xe1d7,
	0xe563, 0xe1c0,
	0xe569, 0xe1bd,
	0xe573, 0xe2dc,
	0xe575, 0xe2d0,
	0xe578, 0xb1ef,
	0xe5a6, 0xe3b4,
	0xe5af, 0xdefe,
	0xe5b1, 0xbeef,
	0xe5b8, 0xb5a7,
	0xe5b9, 0xded8,
	0xe5cc, 0xe9cb,
	0xe5d3, 0xe9c8,
	0xe5da, 0xe9ce,
	0xe5de, 0xe8fd,
	0xe5e8, 0xe9cc,
	0xe5f7, 0xeba7,
	0xe5fc, 0xc0d4,
	0xe640, 0xe4f8,
	0xe641, 0xe4f7,
	0xe642, 0xe4f9,
	0xe643, 0xe4ea,
	0xe64c, 0xe4fb,
	0xe65c, 0xe4b6,
	0xe65f, 0xe4e4,
	0xe666, 0xecda,
	0xe669, 0xecd8,
	0xe672, 0xecd7,
	0xe676, 0xe9e1,
	0xe679, 0xe2b2,
	0xe6a2, 0xe8af,
	0xe6a3, 0xe7f6,
	0xe6a6, 0xe8ae,
	0xe6af, 0xf0fb,
	0xe6b0, 0xf0f9,
	0xe6b1, 0xf0fe,
	0xe6b7, 0xf1a1,
	0xe6bc, 0xeea4,
	0xe6c6, 0xeddd,
	0xe6ca, 0xeddf,
	0xe6cb, 0xecfa,
	0xe6d2, 0xf0a1,
	0xe6d5, 0xf1c1,
	0xe6d7, 0xf3e6,
	0xe6d9, 0xf3e8,
	0xe6df, 0xf4db,
	0xe6e0, 0xf4da,
	0xe6e1, 0xf4d8,
	0xe6e7, 0xe7bd,
	0xe6e8, 0xe7c5,
	0xe6eb, 0xe7c1,
	0xe6ec, 0xe7c2,
	0xe6ed, 0xe7c3,
	0xe6f3, 0xf4ca,
	0xe6f9, 0xf4e5,
	0xe6fd, 0xebf9,
	0xe745, 0xc6cc,
	0xe746, 0xf4bc,
	0xe74d, 0xdea2,
	0xe754, 0xddfd,
	0xe759, 0xc4e8,
	0xe75c, 0xddf8,
	0xe764, 0xdea4,
	0xe76e, 0xdcea,
	0xe76f, 0xdde4,
	0xe772, 0xdce0,
	0xe775, 0xddfb,
	0xe776, 0xdcca,
	0xe77e, 0xebbd,
	0xe7a2, 0xf2f6,
	0xe7a3, 0xf2f8,
	0xe7b2, 0xd0ab,
	0xe7b8, 0xf2f3,
	0xe7ba, 0xf2fa,
	0xe7bc, 0xf2ef,
	0xe7c8, 0xf1d8,
	0xe7d4, 0xdac1,
	0xe7d8, 0xdac2,
	0xe7dc, 0xdac5,
	0xe7ec, 0xeae3,
	0xe7ee, 0xeae6,
	0xe7f4, 0xf5db,
	0xe7f7, 0xf5da,
	0xe840, 0xf5d6,
	0xe854, 0xdbb7,
	0xe858, 0xb5a6,
	0xe85b, 0xf5ac,
	0xe863, 0xefb6,
	0xe868, 0xeef2,
	0xe869, 0xefab,
	0xe86a, 0xefb7,
	0xe86e, 0xefb2,
	0xe86f, 0xeefa,
	0xe870, 0xefaf,
	0xe872, 0xefb0,
	0xe874, 0xf6c8,
	0xe876, 0xefb8,
	0xe8a6, 0xe3cf,
	0xe8a7, 0xe3cd,
	0xe8ae, 0xf6ac,
	0xe8b0, 0xf6a6,
	0xe8b8, 0xf2a4,
	0xe8c1, 0xe2c4,
	0xe8ca, 0xe6e0,
	0xe8ce, 0xe6e6,
	0xe8d4, 0xf7d8,
	0xe8d9, 0xf7c9,
	0xe8db, 0xf6d0,
	0xe8e9, 0xf0b1,
	0xe8f3, 0xd8be,
	0xe8fd, 0xdfd5,
	0xe941, 0xdfdc,
	0xe944, 0xdfe0,
	0xe947, 0xe0f7,
	0xe94f, 0xdbd4,
	0xe951, 0xe6d3,
	0xe952, 0xe6cd,
	0xe954, 0xe6c8,
	0xe958, 0xe6d4,
	0xe961, 0xe1bb,
	0xe96f, 0xe2de,
	0xe972, 0xe2dd,
	0xe975, 0xe1e8,
	0xe976, 0xedad,
	0xe977, 0xbaa9,
	0xe97d, 0xe2f8,
	0xe9a4, 0xdfa8,
	0xe9a6, 0xdfa7,
	0xe9b4, 0xead5,
	0xe9c4, 0xe9d0,
	0xe9c8, 0xe9d3,
	0xe9ca, 0xe9d8,
	0xe9d1, 0xe9d2,
	0xe9e2, 0xe9ec,
	0xe9e3, 0xe9e9,
	0xe9e8, 0xebab,
	0xe9f0, 0xc2ba,
	0xe9f8, 0xe4ab,
	0xea41, 0xe5a1,
	0xea4d, 0xecc7,
	0xea4f, 0xecdc,
	0xea5e, 0xe2b3,
	0xea60, 0xe1fd,
	0xea61, 0xe1f6,
	0xea6c, 0xf1a6,
	0xea6f, 0xf1ac,
	0xea70, 0xf1a2,
	0xea71, 0xf1a9,
	0xea73, 0xf1a7,
	0xea7b, 0xdeab,
	0xeaa7, 0xedd7,
	0xeab2, 0xf1c0,
	0xeaba, 0xf3f4,
	0xeabc, 0xf3f6,
	0xeabd, 0xf3f5,
	0xeac1, 0xf3f8,
	0xeac9, 0xf4dc,
	0xead0, 0xe7c8,
	0xead8, 0xe7c4,
	0xeae5, 0xc5d5,
	0xeae6, 0xf1f0,
	0xeae9, 0xeca2,
	0xeaf8, 0xdea1,
	0xeafe, 0xdce9,
	0xeb41, 0xdddb,
	0xeb42, 0xdea8,
	0xeb44, 0xddde,
	0xeb4c, 0xdcf1,
	0xeb4f, 0xddb5,
	0xeb52, 0xdcbc,
	0xeb5d, 0xf3a5,
	0xeb5e, 0xf2fb,
	0xeb60, 0xf3a2,
	0xeb67, 0xf3a3,
	0xeb6b, 0xf2cf,
	0xeb72, 0xe5bd,
	0xeba1, 0xdabb,
	0xeba6, 0xdaca,
	0xeba7, 0xdacc,
	0xebab, 0xdad2,
	0xebc0, 0xf5de,
	0xebc4, 0xf5e1,
	0xebc5, 0xf5e4,
	0xebd7, 0xdba6,
	0xebd9, 0xf5ad,
	0xebda, 0xf5af,
	0xebdb, 0xf5ae,
	0xebdf, 0xefc3,
	0xebe0, 0xefc4,
	0xebe1, 0xefba,
	0xebe3, 0xd5e0,
	0xebe4, 0xefaa,
	0xebe6, 0xefbc,
	0xebe8, 0xefb9,
	0xebe9, 0xefbe,
	0xebea, 0xeecd,
	0xec46, 0xe3d5,
	0xec48, 0xe3d0,
	0xec49, 0xd1cb,
	0xec4b, 0xe3d1,
	0xec4c, 0xe3d3,
	0xec4e, 0xe3d4,
	0xec56, 0xf7b4,
	0xec70, 0xf7db,
	0xec7b, 0xf6d6,
	0xec7c, 0xf6d8,
	0xeca9, 0xf0b6,
	0xecae, 0xf0b7,
	0xecaf, 0xf7e6,
	0xecb1, 0xf7e5,
	0xecb8, 0xf7fc,
	0xecc0, 0xe0ea,
	0xecc1, 0xdfe2,
	0xecc3, 0xe0e3,
	0xecd0, 0xe6d5,
	0xecda, 0xe1da,
	0xecdb, 0xe0fc,
	0xece6, 0xe2fb,
	0xece8, 0xb1f7,
	0xecec, 0xdfa9,
	0xecf5, 0xe9dd,
	0xecf7, 0xe8df,
	0xecfe, 0xe9d5,
	0xed44, 0xe9db,
	0xed4f, 0xedb4,
	0xed57, 0xe5a8,
	0xed65, 0xe2b4,
	0xed69, 0xe8b4,
	0xed70, 0xeab5,
	0xed72, 0xeab4,
	0xed74, 0xf1aa,
	0xed76, 0xf0f7,
	0xed77, 0xf0ef,
	0xed78, 0xf0ab,
	0xed7a, 0xeeac,
	0xeda6, 0xedcd,
	0xedaa, 0xede1,
	0xedab, 0xede2,
	0xedbb, 0xf3fc,
	0xedbd, 0xf3e5,
	0xedc2, 0xf3fe,
	0xedc3, 0xf3d9,
	0xedcc, 0xc0e9,
	0xedcf, 0xf4dd,
	0xedd0, 0xe7ca,
	0xedd9, 0xf4ed,
	0xeddd, 0xf7e3,
	0xedde, 0xf4ea,
	0xede1, 0xf3c1,
	0xede3, 0xeec0,
	0xede7, 0xf1ef,
	0xede8, 0xebfe,
	0xedea, 0xebfb,
	0xedeb, 0xebfd,
	0xedf1, 0xf4bd,
	0xedf5, 0xdeb2,
	0xedfb, 0xdeae,
	0xedfc, 0xdeaf,
	0xee40, 0xddf7,
	0xee44, 0xdeaa,
	0xee50, 0xdcf6,
	0xee51, 0xdeb6,
	0xee52, 0xdeb3,
	0xee5a, 0xf3a4,
	0xee5d, 0xf3a9,
	0xee5f, 0xf3aa,
	0xee67, 0xf2fc,
	0xee68, 0xd5dd,
	0xee69, 0xf3b1,
	0xee6e, 0xf3ae,
	0xee72, 0xf1cd,
	0xee75, 0xf1df,
	0xee7a, 0xeaed,
	0xee7d, 0xecb2,
	0xeea2, 0xdad5,
	0xeea4, 0xd6df,
	0xeeaa, 0xe5c0,
	0xeeb0, 0xdad6,
	0xeeb7, 0xf5f9,
	0xeebe, 0xf5c4,
	0xeebf, 0xe5bf,
	0xeec5, 0xc3d1,
	0xeec6, 0xf5b0,
	0xeec7, 0xc8a9,
	0xeed0, 0xefca,
	0xeed2, 0xefc7,
	0xeed4, 0xd5a1,
	0xeed6, 0xefc8,
	0xeedc, 0xf6cc,
	0xeede, 0xf6ca,
	0xeef1, 0xe3d6,
	0xeef5, 0xdaf4,
	0xef4f, 0xe2bc,
	0xef55, 0xd9e5,
	0xef69, 0xf7cc,
	0xef6a, 0xf6da,
	0xef6c, 0xf6dc,
	0xef7b, 0xf0b9,
	0xef7e, 0xf0bb,
	0xefa2, 0xf0bc,
	0xefb0, 0xedea,
	0xefb1, 0xf6bd,
	0xefb4, 0xf7f7,
	0xefb5, 0xf6b3,
	0xefb6, 0xd9df,
	0xefbf, 0xc4f6,
	0xefc8, 0xeda1,
	0xefd2, 0xdef3,
	0xefd7, 0xdfa3,
	0xefdb, 0xead6,
	0xefe4, 0xecf2,
	0xefef, 0xe4de,
	0xeff5, 0xe4f3,
	0xeff6, 0xe3f8,
	0xeffb, 0xecde,
	0xf049, 0xeab6,
	0xf04a, 0xf1b0,
	0xf04b, 0xf0dc,
	0xf058, 0xede4,
	0xf065, 0xf4a1,
	0xf068, 0xf4a3,
	0xf072, 0xe7c0,
	0xf07c, 0xf1f9,
	0xf0a2, 0xf4be,
	0xf0b0, 0xdda3,
	0xf0b8, 0xdeb8,
	0xf0be, 0xf3b2,
	0xf0c0, 0xf3b3,
	0xf0c1, 0xf3a8,
	0xf0c7, 0xf3ad,
	0xf0ca, 0xf2b1,
	0xf0d9, 0xf1d0,
	0xf0dd, 0xdaa9,
	0xf0e3, 0xc3a1,
	0xf0e7, 0xf6a5,
	0xf0f1, 0xf5f8,
	0xf0f3, 0xd8d3,
	0xf0f4, 0xeade,
	0xf144, 0xf5bf,
	0xf146, 0xeaa4,
	0xf14b, 0xdaf7,
	0xf151, 0xf5b5,
	0xf152, 0xf5b2,
	0xf153, 0xefd8,
	0xf15a, 0xeef8,
	0xf15c, 0xefcb,
	0xf15e, 0xefd6,
	0xf16f, 0xe3c4,
	0xf17c, 0xf7b6,
	0xf1a4, 0xe8b8,
	0xf1ad, 0xe2be,
	0xf1af, 0xe6eb,
	0xf1b2, 0xe6ec,
	0xf1b6, 0xe6ed,
	0xf1b9, 0xf7c2,
	0xf1bb, 0xf7dc,
	0xf1c3, 0xf6e9,
	0xf1c7, 0xf6e1,
	0xf1cf, 0xf0c3,
	0xf1d0, 0xf0be,
	0xf1d9, 0xf0c1,
	0xf1e0, 0xf7f0,
	0xf1ef, 0xd8c9,
	0xf1f2, 0xdfbf,
	0xf1f6, 0xdbe4,
	0xf245, 0xdfab,
	0xf24c, 0xe9c6,
	0xf252, 0xe8dd,
	0xf255, 0xe9cd,
	0xf258, 0xe9da,
	0xf25b, 0xebaa,
	0xf25d, 0xe3f1,
	0xf25e, 0xe4eb,
	0xf263, 0xe5ac,
	0xf2a1, 0xede7,
	0xf2a4, 0xede6,
	0xf2b2, 0xe7d8,
	0xf2b4, 0xe7d9,
	0xf2bc, 0xeebc,
	0xf2c3, 0xf4af,
	0xf2d4, 0xdebc,
	0xf2dd, 0xd9f9,
	0xf2de, 0xf2c9,
	0xf2e3, 0xf2b2,
	0xf2e7, 0xf3b9,
	0xf2f0, 0xf1cf,
	0xf2f3, 0xeaef,
	0xf2f5, 0xf6a3,
	0xf2fb, 0xdada,
	0xf34f, 0xb2e4,
	0xf353, 0xf5ec,
	0xf35f, 0xf5b3,
	0xf360, 0xefde,
	0xf361, 0xefe0,
	0xf365, 0xdaa5,
	0xf366, 0xefea,
	0xf368, 0xefd2,
	0xf36a, 0xefa1,
	0xf36c, 0xf6cb,
	0xf3a5, 0xe8b9,
	0xf3a8, 0xf2aa,
	0xf3af, 0xe2ca,
	0xf3b1, 0xe2c9,
	0xf3c1, 0xf7c4,
	0xf3c7, 0xf6ec,
	0xf3c8, 0xf6ed,
	0xf3cb, 0xf6ef,
	0xf3cd, 0xf6f2,
	0xf3ce, 0xf6f3,
	0xf3cf, 0xf6f6,
	0xf3d0, 0xf6df,
	0xf3d6, 0xf6ee,
	0xf3ed, 0xf0c7,
	0xf3f0, 0xf0b4,
	0xf3f5, 0xedeb,
	0xf441, 0xe0b7,
	0xf44c, 0xdefc,
	0xf453, 0xe8d0,
	0xf455, 0xe8c0,
	0xf456, 0xe8d3,
	0xf45c, 0xe5af,
	0xf465, 0xe5ae,
	0xf46e, 0xe2a8,
	0xf46f, 0xe8b7,
	0xf477, 0xdbc7,
	0xf47d, 0xede5,
	0xf4ad, 0xe7d7,
	0xf4b2, 0xf1f7,
	0xf4b5, 0xd0c6,
	0xf4b6, 0xf4bf,
	0xf4b8, 0xdcd7,
	0xf4b9, 0xdebd,
	0xf4be, 0xdcc2,
	0xf4bf, 0xdead,
	0xf4c1, 0xdebf,
	0xf4c5, 0xf2d3,
	0xf4c6, 0xf2ee,
	0xf4c8, 0xf3b7,
	0xf4c9, 0xf3b6,
	0xf4cb, 0xf1e0,
	0xf4e1, 0xdbb9,
	0xf4e4, 0xf5b6,
	0xf4e7, 0xefa6,
	0xf4e8, 0xefe6,
	0xf4ea, 0xefe8,
	0xf4ec, 0xefe2,
	0xf4ef, 0xc1cd,
	0xf4f1, 0xefeb,
	0xf4f3, 0xeefc,
	0xf4f5, 0xefe4,
	0xf4f9, 0xefa9,
	0xf545, 0xe3db,
	0xf54f, 0xf2a9,
	0xf557, 0xe2cd,
	0xf558, 0xc0a1,
	0xf55f, 0xe6e3,
	0xf561, 0xe6f2,
	0xf562, 0xe6f3,
	0xf563, 0xe6ef,
	0xf56b, 0xf6f8,
	0xf56e, 0xf6fb,
	0xf576, 0xf6fc,
	0xf57c, 0xf0c9,
	0xf5a7, 0xf0ca,
	0xf5ad, 0xf0cd,
	0xf5b4, 0xf7f4,
	0xf5b6, 0xf7f3,
	0xf5bb, 0xf6b6,
	0xf5be, 0xf6b5,
	0xf5c0, 0xd9d0,
	0xf5c9, 0xbff9,
	0xf5cd, 0xdfa5,
	0xf5d1, 0xe9b7,
	0xf5d3, 0xe3e3,
	0xf5d4, 0xe4dc,
	0xf5da, 0xecdf,
	0xf5dd, 0xe2b5,
	0xf5e2, 0xedc3,
	0xf5e7, 0xe6fe,
	0xf5e9, 0xe7d3,
	0xf5f8, 0xdebe,
	0xf5fc, 0xdec0,
	0xf5fd, 0xddfc,
	0xf642, 0xf3ba,
	0xf652, 0xeae1,
	0xf65a, 0xdbba,
	0xf65e, 0xefee,
	0xf66b, 0xe3cb,
	0xf674, 0xecad,
	0xf67b, 0xe6f5,
	0xf67c, 0xe6ee,
	0xf67d, 0xe6f1,
	0xf6ad, 0xf6e5,
	0xf6ae, 0xf7a3,
	0xf6af, 0xf7a5,
	0xf6b4, 0xf0cf,
	0xf6bc, 0xf7bd,
	0xf6c9, 0xf5ba,
	0xf6d8, 0xd9e6,
	0xf6dc, 0xe6ae,
	0xf6e3, 0xd4dc,
	0xf6e7, 0xebac,
	0xf6f4, 0xf1a8,
	0xf6f8, 0xf0a6,
	0xf6fb, 0xf3ea,
	0xf740, 0xd9e1,
	0xf746, 0xf4b5,
	0xf753, 0xeaeb,
	0xf756, 0xdad9,
	0xf75d, 0xf5e9,
	0xf75e, 0xf5f0,
	0xf75f, 0xf5d1,
	0xf760, 0xf5c8,
	0xf761, 0xf5f1,
	0xf765, 0xe9f6,
	0xf767, 0xefd9,
	0xf769, 0xefec,
	0xf776, 0xf7d3,
	0xf77c, 0xe6f6,
	0xf77e, 0xe6e8,
	0xf7a7, 0xe5f7,
	0xf7ab, 0xf7a8,
	0xf7ae, 0xf6e4,
	0xf7af, 0xf7a6,
	0xf7b2, 0xf6e6,
	0xf7b4, 0xf7a1,
	0xf7ba, 0xf0d2,
	0xf7c1, 0xf0ba,
	0xf7ce, 0xede8,
	0xf7dd, 0xdfac,
	0xf7e1, 0xe8ef,
	0xf7e2, 0xe9a1,
	0xf7ea, 0xd3b8,
	0xf7f0, 0xddf1,
	0xf7f3, 0xdec2,
	0xf7f8, 0xeec3,
	0xf841, 0xf6c5,
	0xf847, 0xe9f1,
	0xf855, 0xf7df,
	0xf857, 0xf7ae,
	0xf858, 0xf6e0,
	0xf85b, 0xf6d1,
	0xf863, 0xf0d3,
	0xf866, 0xf0d6,
	0xf86b, 0xf0d4,
	0xf86c, 0xf0d5,
	0xf870, 0xf0c2,
	0xf876, 0xf7f5,
	0xf87b, 0xf7fb,
	0xf87e, 0xecb4,
	0xf8af, 0xe5b0,
	0xf8b8, 0xf3fd,
	0xf8be, 0xf3bd,
	0xf8c2, 0xc0be,
	0xf8c3, 0xf5f3,
	0xf8ca, 0xf6ce,
	0xf8d4, 0xf7c6,
	0xf8d7, 0xf7af,
	0xf8ee, 0xe0ec,
	0xf8ef, 0xdfad,
	0xf8fb, 0xf3d6,
	0xf940, 0xe7da,
	0xf941, 0xf4ee,
	0xf943, 0xd9f5,
	0xf94b, 0xf1e1,
	0xf94f, 0xb4da,
	0xf953, 0xefe7,
	0xf95c, 0xf6dd,
	0xf965, 0xf6be,
	0xf96f, 0xf4f5,
	0xf970, 0xf5f2,
	0xf971, 0xf5a7,
	0xf9a9, 0xdadd,
	0xf9ae, 0xf2a8,
	0xf9af, 0xc8a7,
	0xf9b3, 0xe6f8,
	0xf9b7, 0xf0b5,
	0xf9ba, 0xedb0,
	0xf9c4, 0xe3ce,
	0xf9ce, 0xf6e2,
	0xf9cf, 0xf0bf,
	0xf9d0, 0xe4d9
};

#endif
