/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1995 by Sun Microsystems, Inc.
 * All rights reserved.
 */


#ifndef _BIG5_CNS_H_
#define _BIG5_CNS_H_

#include "public_struc.h"

/* maxium mapping number from Big-5 to CNS11643 */
#define MAX_BIG5_NUM		13531

/*
 * BIG-5 to CNS 11643 mapping table
 */
table_t	big5_cns_tab[MAX_BIG5_NUM] = {
	{ 0xa140, 0x212121 },
	{ 0xa141, 0x212122 },
	{ 0xa142, 0x212123 },
	{ 0xa143, 0x212124 },
	{ 0xa144, 0x212125 },
	{ 0xa145, 0x212126 },
	{ 0xa146, 0x212127 },
	{ 0xa147, 0x212128 },
	{ 0xa148, 0x212129 },
	{ 0xa149, 0x21212a },
	{ 0xa14a, 0x21212b },
	{ 0xa14b, 0x21212c },
	{ 0xa14c, 0x21212d },
	{ 0xa14d, 0x21212e },
	{ 0xa14e, 0x21212f },
	{ 0xa14f, 0x212130 },
	{ 0xa150, 0x212131 },
	{ 0xa151, 0x212132 },
	{ 0xa152, 0x212133 },
	{ 0xa153, 0x212134 },
	{ 0xa154, 0x212135 },
	{ 0xa155, 0x212136 },
	{ 0xa156, 0x212137 },
	{ 0xa157, 0x212138 },
	{ 0xa158, 0x212139 },
	{ 0xa159, 0x21213a },
	{ 0xa15a, 0x21213b },
	{ 0xa15b, 0x21213c },
	{ 0xa15c, 0x21213d },
	{ 0xa15d, 0x21213e },
	{ 0xa15e, 0x21213f },
	{ 0xa15f, 0x212140 },
	{ 0xa160, 0x212141 },
	{ 0xa161, 0x212142 },
	{ 0xa162, 0x212143 },
	{ 0xa163, 0x212144 },
	{ 0xa164, 0x212145 },
	{ 0xa165, 0x212146 },
	{ 0xa166, 0x212147 },
	{ 0xa167, 0x212148 },
	{ 0xa168, 0x212149 },
	{ 0xa169, 0x21214a },
	{ 0xa16a, 0x21214b },
	{ 0xa16b, 0x21214c },
	{ 0xa16c, 0x21214d },
	{ 0xa16d, 0x21214e },
	{ 0xa16e, 0x21214f },
	{ 0xa16f, 0x212150 },
	{ 0xa170, 0x212151 },
	{ 0xa171, 0x212152 },
	{ 0xa172, 0x212153 },
	{ 0xa173, 0x212154 },
	{ 0xa174, 0x212155 },
	{ 0xa175, 0x212156 },
	{ 0xa176, 0x212157 },
	{ 0xa177, 0x212158 },
	{ 0xa178, 0x212159 },
	{ 0xa179, 0x21215a },
	{ 0xa17a, 0x21215b },
	{ 0xa17b, 0x21215c },
	{ 0xa17c, 0x21215d },
	{ 0xa17d, 0x21215e },
	{ 0xa17e, 0x21215f },
	{ 0xa1a1, 0x212160 },
	{ 0xa1a2, 0x212161 },
	{ 0xa1a3, 0x212162 },
	{ 0xa1a4, 0x212163 },
	{ 0xa1a5, 0x212164 },
	{ 0xa1a6, 0x212165 },
	{ 0xa1a7, 0x212166 },
	{ 0xa1a8, 0x212167 },
	{ 0xa1a9, 0x212168 },
	{ 0xa1aa, 0x212169 },
	{ 0xa1ab, 0x21216a },
	{ 0xa1ac, 0x21216b },
	{ 0xa1ad, 0x21216c },
	{ 0xa1ae, 0x21216d },
	{ 0xa1af, 0x21216e },
	{ 0xa1b0, 0x21216f },
	{ 0xa1b1, 0x212170 },
	{ 0xa1b2, 0x212171 },
	{ 0xa1b3, 0x212172 },
	{ 0xa1b4, 0x212173 },
	{ 0xa1b5, 0x212174 },
	{ 0xa1b6, 0x212175 },
	{ 0xa1b7, 0x212176 },
	{ 0xa1b8, 0x212177 },
	{ 0xa1b9, 0x212178 },
	{ 0xa1ba, 0x212179 },
	{ 0xa1bb, 0x21217a },
	{ 0xa1bc, 0x21217b },
	{ 0xa1bd, 0x21217c },
	{ 0xa1be, 0x21217d },
	{ 0xa1bf, 0x21217e },
	{ 0xa1c0, 0x212221 },
	{ 0xa1c1, 0x212222 },
	{ 0xa1c2, 0x212223 },
	{ 0xa1c3, 0x212224 },
	{ 0xa1c4, 0x212225 },
	{ 0xa1c5, 0x212226 },
	{ 0xa1c6, 0x212227 },
	{ 0xa1c7, 0x212228 },
	{ 0xa1c8, 0x212229 },
	{ 0xa1c9, 0x21222a },
	{ 0xa1ca, 0x21222b },
	{ 0xa1cb, 0x21222c },
	{ 0xa1cc, 0x21222d },
	{ 0xa1cd, 0x21222e },
	{ 0xa1ce, 0x21222f },
	{ 0xa1cf, 0x212230 },
	{ 0xa1d0, 0x212231 },
	{ 0xa1d1, 0x212232 },
	{ 0xa1d2, 0x212233 },
	{ 0xa1d3, 0x212234 },
	{ 0xa1d4, 0x212235 },
	{ 0xa1d5, 0x212236 },
	{ 0xa1d6, 0x212237 },
	{ 0xa1d7, 0x212238 },
	{ 0xa1d8, 0x212239 },
	{ 0xa1d9, 0x21223a },
	{ 0xa1da, 0x21223b },
	{ 0xa1db, 0x21223c },
	{ 0xa1dc, 0x21223d },
	{ 0xa1dd, 0x21223e },
	{ 0xa1de, 0x21223f },
	{ 0xa1df, 0x212240 },
	{ 0xa1e0, 0x212241 },
	{ 0xa1e1, 0x212242 },
	{ 0xa1e2, 0x212243 },
	{ 0xa1e3, 0x212244 },
	{ 0xa1e4, 0x212245 },
	{ 0xa1e5, 0x212246 },
	{ 0xa1e6, 0x212247 },
	{ 0xa1e7, 0x212248 },
	{ 0xa1e8, 0x212249 },
	{ 0xa1e9, 0x21224a },
	{ 0xa1ea, 0x21224b },
	{ 0xa1eb, 0x21224c },
	{ 0xa1ec, 0x21224d },
	{ 0xa1ed, 0x21224e },
	{ 0xa1ee, 0x21224f },
	{ 0xa1ef, 0x212250 },
	{ 0xa1f0, 0x212251 },
	{ 0xa1f1, 0x212252 },
	{ 0xa1f2, 0x212253 },
	{ 0xa1f3, 0x212254 },
	{ 0xa1f4, 0x212255 },
	{ 0xa1f5, 0x212256 },
	{ 0xa1f6, 0x212257 },
	{ 0xa1f7, 0x212258 },
	{ 0xa1f8, 0x212259 },
	{ 0xa1f9, 0x21225a },
	{ 0xa1fa, 0x21225b },
	{ 0xa1fb, 0x21225c },
	{ 0xa1fc, 0x21225d },
	{ 0xa1fd, 0x21225e },
	{ 0xa1fe, 0x21225f },
	{ 0xa240, 0x212260 },
	{ 0xa241, 0x212261 },
	{ 0xa242, 0x212262 },
	{ 0xa243, 0x212263 },
	{ 0xa244, 0x212264 },
	{ 0xa245, 0x212265 },
	{ 0xa246, 0x212266 },
	{ 0xa247, 0x212267 },
	{ 0xa248, 0x212268 },
	{ 0xa249, 0x212269 },
	{ 0xa24a, 0x21226a },
	{ 0xa24b, 0x21226b },
	{ 0xa24c, 0x21226c },
	{ 0xa24d, 0x21226d },
	{ 0xa24e, 0x21226e },
	{ 0xa24f, 0x21226f },
	{ 0xa250, 0x212270 },
	{ 0xa251, 0x212271 },
	{ 0xa252, 0x212272 },
	{ 0xa253, 0x212273 },
	{ 0xa254, 0x212274 },
	{ 0xa255, 0x212275 },
	{ 0xa256, 0x212276 },
	{ 0xa257, 0x212277 },
	{ 0xa258, 0x212278 },
	{ 0xa259, 0x212279 },
	{ 0xa25a, 0x21227a },
	{ 0xa25b, 0x21227b },
	{ 0xa25c, 0x21227c },
	{ 0xa25d, 0x21227d },
	{ 0xa25e, 0x21227e },
	{ 0xa25f, 0x212321 },
	{ 0xa260, 0x212322 },
	{ 0xa261, 0x212323 },
	{ 0xa262, 0x212324 },
	{ 0xa263, 0x212325 },
	{ 0xa264, 0x212326 },
	{ 0xa265, 0x212327 },
	{ 0xa266, 0x212328 },
	{ 0xa267, 0x212329 },
	{ 0xa268, 0x21232a },
	{ 0xa269, 0x21232b },
	{ 0xa26a, 0x21232c },
	{ 0xa26b, 0x21232d },
	{ 0xa26c, 0x21232e },
	{ 0xa26d, 0x21232f },
	{ 0xa26e, 0x212330 },
	{ 0xa26f, 0x212331 },
	{ 0xa270, 0x212332 },
	{ 0xa271, 0x212333 },
	{ 0xa272, 0x212334 },
	{ 0xa273, 0x212335 },
	{ 0xa274, 0x212336 },
	{ 0xa275, 0x212337 },
	{ 0xa276, 0x212338 },
	{ 0xa277, 0x212339 },
	{ 0xa278, 0x21233a },
	{ 0xa279, 0x21233b },
	{ 0xa27a, 0x21233c },
	{ 0xa27b, 0x21233d },
	{ 0xa27c, 0x21233e },
	{ 0xa27d, 0x21233f },
	{ 0xa27e, 0x212340 },
	{ 0xa2a1, 0x212341 },
	{ 0xa2a2, 0x212342 },
	{ 0xa2a3, 0x212343 },
	{ 0xa2a4, 0x212344 },
	{ 0xa2a5, 0x212345 },
	{ 0xa2a6, 0x212346 },
	{ 0xa2a7, 0x212347 },
	{ 0xa2a8, 0x212348 },
	{ 0xa2a9, 0x212349 },
	{ 0xa2aa, 0x21234a },
	{ 0xa2ab, 0x21234b },
	{ 0xa2ac, 0x21234c },
	{ 0xa2ad, 0x21234d },
	{ 0xa2ae, 0x21234e },
	{ 0xa2af, 0x212421 },
	{ 0xa2b0, 0x212422 },
	{ 0xa2b1, 0x212423 },
	{ 0xa2b2, 0x212424 },
	{ 0xa2b3, 0x212425 },
	{ 0xa2b4, 0x212426 },
	{ 0xa2b5, 0x212427 },
	{ 0xa2b6, 0x212428 },
	{ 0xa2b7, 0x212429 },
	{ 0xa2b8, 0x21242a },
	{ 0xa2b9, 0x21242b },
	{ 0xa2ba, 0x21242c },
	{ 0xa2bb, 0x21242d },
	{ 0xa2bc, 0x21242e },
	{ 0xa2bd, 0x21242f },
	{ 0xa2be, 0x212430 },
	{ 0xa2bf, 0x212431 },
	{ 0xa2c0, 0x212432 },
	{ 0xa2c1, 0x212433 },
	{ 0xa2c2, 0x212434 },
	{ 0xa2c3, 0x212435 },
	{ 0xa2c4, 0x212436 },
	{ 0xa2c5, 0x212437 },
	{ 0xa2c6, 0x212438 },
	{ 0xa2c7, 0x212439 },
	{ 0xa2c8, 0x21243a },
	{ 0xa2c9, 0x21243b },
	{ 0xa2ca, 0x21243c },
	{ 0xa2cb, 0x21243d },
	{ 0xa2cc, 0x21243e },
	{ 0xa2cd, 0x21243f },
	{ 0xa2ce, 0x212440 },
	{ 0xa2cf, 0x212441 },
	{ 0xa2d0, 0x212442 },
	{ 0xa2d1, 0x212443 },
	{ 0xa2d2, 0x212444 },
	{ 0xa2d3, 0x212445 },
	{ 0xa2d4, 0x212446 },
	{ 0xa2d5, 0x212447 },
	{ 0xa2d6, 0x212448 },
	{ 0xa2d7, 0x212449 },
	{ 0xa2d8, 0x21244a },
	{ 0xa2d9, 0x21244b },
	{ 0xa2da, 0x21244c },
	{ 0xa2db, 0x21244d },
	{ 0xa2dc, 0x21244e },
	{ 0xa2dd, 0x21244f },
	{ 0xa2de, 0x212450 },
	{ 0xa2df, 0x212451 },
	{ 0xa2e0, 0x212452 },
	{ 0xa2e1, 0x212453 },
	{ 0xa2e2, 0x212454 },
	{ 0xa2e3, 0x212455 },
	{ 0xa2e4, 0x212456 },
	{ 0xa2e5, 0x212457 },
	{ 0xa2e6, 0x212458 },
	{ 0xa2e7, 0x212459 },
	{ 0xa2e8, 0x21245a },
	{ 0xa2e9, 0x21245b },
	{ 0xa2ea, 0x21245c },
	{ 0xa2eb, 0x21245d },
	{ 0xa2ec, 0x21245e },
	{ 0xa2ed, 0x21245f },
	{ 0xa2ee, 0x212460 },
	{ 0xa2ef, 0x212461 },
	{ 0xa2f0, 0x212462 },
	{ 0xa2f1, 0x212463 },
	{ 0xa2f2, 0x212464 },
	{ 0xa2f3, 0x212465 },
	{ 0xa2f4, 0x212466 },
	{ 0xa2f5, 0x212467 },
	{ 0xa2f6, 0x212468 },
	{ 0xa2f7, 0x212469 },
	{ 0xa2f8, 0x21246a },
	{ 0xa2f9, 0x21246b },
	{ 0xa2fa, 0x21246c },
	{ 0xa2fb, 0x21246d },
	{ 0xa2fc, 0x21246e },
	{ 0xa2fd, 0x21246f },
	{ 0xa2fe, 0x212470 },
	{ 0xa340, 0x212471 },
	{ 0xa341, 0x212472 },
	{ 0xa342, 0x212473 },
	{ 0xa343, 0x212474 },
	{ 0xa344, 0x212475 },
	{ 0xa345, 0x212476 },
	{ 0xa346, 0x212477 },
	{ 0xa347, 0x212478 },
	{ 0xa348, 0x212479 },
	{ 0xa349, 0x21247a },
	{ 0xa34a, 0x21247b },
	{ 0xa34b, 0x21247c },
	{ 0xa34c, 0x21247d },
	{ 0xa34d, 0x21247e },
	{ 0xa34e, 0x212521 },
	{ 0xa34f, 0x212522 },
	{ 0xa350, 0x212523 },
	{ 0xa351, 0x212524 },
	{ 0xa352, 0x212525 },
	{ 0xa353, 0x212526 },
	{ 0xa354, 0x212527 },
	{ 0xa355, 0x212528 },
	{ 0xa356, 0x212529 },
	{ 0xa357, 0x21252a },
	{ 0xa358, 0x21252b },
	{ 0xa359, 0x21252c },
	{ 0xa35a, 0x21252d },
	{ 0xa35b, 0x21252e },
	{ 0xa35c, 0x21252f },
	{ 0xa35d, 0x212530 },
	{ 0xa35e, 0x212531 },
	{ 0xa35f, 0x212532 },
	{ 0xa360, 0x212533 },
	{ 0xa361, 0x212534 },
	{ 0xa362, 0x212535 },
	{ 0xa363, 0x212536 },
	{ 0xa364, 0x212537 },
	{ 0xa365, 0x212538 },
	{ 0xa366, 0x212539 },
	{ 0xa367, 0x21253a },
	{ 0xa368, 0x21253b },
	{ 0xa369, 0x21253c },
	{ 0xa36a, 0x21253d },
	{ 0xa36b, 0x21253e },
	{ 0xa36c, 0x21253f },
	{ 0xa36d, 0x212540 },
	{ 0xa36e, 0x212541 },
	{ 0xa36f, 0x212542 },
	{ 0xa370, 0x212543 },
	{ 0xa371, 0x212544 },
	{ 0xa372, 0x212545 },
	{ 0xa373, 0x212546 },
	{ 0xa374, 0x212547 },
	{ 0xa375, 0x212548 },
	{ 0xa376, 0x212549 },
	{ 0xa377, 0x21254a },
	{ 0xa378, 0x21254b },
	{ 0xa379, 0x21254c },
	{ 0xa37a, 0x21254d },
	{ 0xa37b, 0x21254e },
	{ 0xa37c, 0x21254f },
	{ 0xa37d, 0x212550 },
	{ 0xa37e, 0x212551 },
	{ 0xa3a1, 0x212552 },
	{ 0xa3a2, 0x212553 },
	{ 0xa3a3, 0x212554 },
	{ 0xa3a4, 0x212555 },
	{ 0xa3a5, 0x212556 },
	{ 0xa3a6, 0x212557 },
	{ 0xa3a7, 0x212558 },
	{ 0xa3a8, 0x212559 },
	{ 0xa3a9, 0x21255a },
	{ 0xa3aa, 0x21255b },
	{ 0xa3ab, 0x21255c },
	{ 0xa3ac, 0x21255d },
	{ 0xa3ad, 0x21255e },
	{ 0xa3ae, 0x21255f },
	{ 0xa3af, 0x212560 },
	{ 0xa3b0, 0x212561 },
	{ 0xa3b1, 0x212562 },
	{ 0xa3b2, 0x212563 },
	{ 0xa3b3, 0x212564 },
	{ 0xa3b4, 0x212565 },
	{ 0xa3b5, 0x212566 },
	{ 0xa3b6, 0x212567 },
	{ 0xa3b7, 0x212568 },
	{ 0xa3b8, 0x212569 },
	{ 0xa3b9, 0x21256a },
	{ 0xa3ba, 0x21256b },
	{ 0xa3bb, 0x21256c },
	{ 0xa3bc, 0x21256d },
	{ 0xa3bd, 0x21256e },
	{ 0xa3be, 0x21256f },
	{ 0xa3bf, 0x212570 },
	{ 0xa3c0, 0x214221 },
	{ 0xa3c1, 0x214222 },
	{ 0xa3c2, 0x214223 },
	{ 0xa3c3, 0x214224 },
	{ 0xa3c4, 0x214225 },
	{ 0xa3c5, 0x214226 },
	{ 0xa3c6, 0x214227 },
	{ 0xa3c7, 0x214228 },
	{ 0xa3c8, 0x214229 },
	{ 0xa3c9, 0x21422a },
	{ 0xa3ca, 0x21422b },
	{ 0xa3cb, 0x21422c },
	{ 0xa3cc, 0x21422d },
	{ 0xa3cd, 0x21422e },
	{ 0xa3ce, 0x21422f },
	{ 0xa3cf, 0x214230 },
	{ 0xa3d0, 0x214231 },
	{ 0xa3d1, 0x214232 },
	{ 0xa3d2, 0x214233 },
	{ 0xa3d3, 0x214234 },
	{ 0xa3d4, 0x214235 },
	{ 0xa3d5, 0x214236 },
	{ 0xa3d6, 0x214237 },
	{ 0xa3d7, 0x214238 },
	{ 0xa3d8, 0x214239 },
	{ 0xa3d9, 0x21423a },
	{ 0xa3da, 0x21423b },
	{ 0xa3db, 0x21423c },
	{ 0xa3dc, 0x21423d },
	{ 0xa3dd, 0x21423e },
	{ 0xa3de, 0x21423f },
	{ 0xa3df, 0x214240 },
	{ 0xa3e0, 0x214241 },
	{ 0xa3e1, 0x212621 },
	{ 0xa3e2, 0x212622 },
	{ 0xa3e3, 0x212623 },
	{ 0xa3e4, 0x212624 },
	{ 0xa3e5, 0x212625 },
	{ 0xa3e6, 0x212626 },
	{ 0xa3e7, 0x212627 },
	{ 0xa3e8, 0x212628 },
	{ 0xa3e9, 0x212629 },
	{ 0xa3ea, 0x21262a },
	{ 0xa3eb, 0x21262b },
	{ 0xa3ec, 0x21262c },
	{ 0xa3ed, 0x21262d },
	{ 0xa3ee, 0x21262e },
	{ 0xa3ef, 0x21262f },
	{ 0xa3f0, 0x212630 },
	{ 0xa3f1, 0x212631 },
	{ 0xa3f2, 0x212632 },
	{ 0xa3f3, 0x212633 },
	{ 0xa3f4, 0x212634 },
	{ 0xa3f5, 0x212635 },
	{ 0xa3f6, 0x212636 },
	{ 0xa3f7, 0x212637 },
	{ 0xa3f8, 0x212638 },
	{ 0xa3f9, 0x212639 },
	{ 0xa3fa, 0x21263a },
	{ 0xa3fb, 0x21263b },
	{ 0xa3fc, 0x21263c },
	{ 0xa3fd, 0x21263d },
	{ 0xa3fe, 0x21263e },
	{ 0xa440, 0x214421 },
	{ 0xa441, 0x214422 },
	{ 0xa442, 0x214423 },
	{ 0xa443, 0x214424 },
	{ 0xa444, 0x214425 },
	{ 0xa445, 0x214426 },
	{ 0xa446, 0x214427 },
	{ 0xa447, 0x214428 },
	{ 0xa448, 0x214429 },
	{ 0xa449, 0x21442a },
	{ 0xa44a, 0x21442b },
	{ 0xa44b, 0x21442c },
	{ 0xa44c, 0x21442d },
	{ 0xa44d, 0x21442e },
	{ 0xa44e, 0x21442f },
	{ 0xa44f, 0x214430 },
	{ 0xa450, 0x214431 },
	{ 0xa451, 0x214432 },
	{ 0xa452, 0x214433 },
	{ 0xa453, 0x214434 },
	{ 0xa454, 0x214435 },
	{ 0xa455, 0x214436 },
	{ 0xa456, 0x214437 },
	{ 0xa457, 0x214438 },
	{ 0xa458, 0x214439 },
	{ 0xa459, 0x21443a },
	{ 0xa45a, 0x21443b },
	{ 0xa45b, 0x21443c },
	{ 0xa45c, 0x21443d },
	{ 0xa45d, 0x21443e },
	{ 0xa45e, 0x21443f },
	{ 0xa45f, 0x214440 },
	{ 0xa460, 0x214441 },
	{ 0xa461, 0x214442 },
	{ 0xa462, 0x214443 },
	{ 0xa463, 0x214444 },
	{ 0xa464, 0x214445 },
	{ 0xa465, 0x214446 },
	{ 0xa466, 0x214447 },
	{ 0xa467, 0x214448 },
	{ 0xa468, 0x214449 },
	{ 0xa469, 0x21444a },
	{ 0xa46a, 0x21444b },
	{ 0xa46b, 0x21444c },
	{ 0xa46c, 0x21444d },
	{ 0xa46d, 0x21444e },
	{ 0xa46e, 0x21444f },
	{ 0xa46f, 0x214450 },
	{ 0xa470, 0x214451 },
	{ 0xa471, 0x214452 },
	{ 0xa472, 0x214453 },
	{ 0xa473, 0x214454 },
	{ 0xa474, 0x214455 },
	{ 0xa475, 0x214456 },
	{ 0xa476, 0x214457 },
	{ 0xa477, 0x214458 },
	{ 0xa478, 0x214459 },
	{ 0xa479, 0x21445a },
	{ 0xa47a, 0x21445b },
	{ 0xa47b, 0x21445c },
	{ 0xa47c, 0x21445d },
	{ 0xa47d, 0x21445e },
	{ 0xa47e, 0x21445f },
	{ 0xa4a1, 0x214460 },
	{ 0xa4a2, 0x214461 },
	{ 0xa4a3, 0x214462 },
	{ 0xa4a4, 0x214463 },
	{ 0xa4a5, 0x214464 },
	{ 0xa4a6, 0x214465 },
	{ 0xa4a7, 0x214466 },
	{ 0xa4a8, 0x214467 },
	{ 0xa4a9, 0x214468 },
	{ 0xa4aa, 0x214469 },
	{ 0xa4ab, 0x21446a },
	{ 0xa4ac, 0x21446b },
	{ 0xa4ad, 0x21446c },
	{ 0xa4ae, 0x21446d },
	{ 0xa4af, 0x21446e },
	{ 0xa4b0, 0x21446f },
	{ 0xa4b1, 0x214470 },
	{ 0xa4b2, 0x214471 },
	{ 0xa4b3, 0x214472 },
	{ 0xa4b4, 0x214473 },
	{ 0xa4b5, 0x214474 },
	{ 0xa4b6, 0x214475 },
	{ 0xa4b7, 0x214476 },
	{ 0xa4b8, 0x214477 },
	{ 0xa4b9, 0x214478 },
	{ 0xa4ba, 0x214479 },
	{ 0xa4bb, 0x21447a },
	{ 0xa4bc, 0x21447b },
	{ 0xa4bd, 0x21447c },
	{ 0xa4be, 0x21447d },
	{ 0xa4bf, 0x21447e },
	{ 0xa4c0, 0x214521 },
	{ 0xa4c1, 0x214522 },
	{ 0xa4c2, 0x214523 },
	{ 0xa4c3, 0x214524 },
	{ 0xa4c4, 0x214525 },
	{ 0xa4c5, 0x214526 },
	{ 0xa4c6, 0x214527 },
	{ 0xa4c7, 0x214528 },
	{ 0xa4c8, 0x214529 },
	{ 0xa4c9, 0x21452a },
	{ 0xa4ca, 0x21452b },
	{ 0xa4cb, 0x21452c },
	{ 0xa4cc, 0x21452d },
	{ 0xa4cd, 0x21452e },
	{ 0xa4ce, 0x21452f },
	{ 0xa4cf, 0x214530 },
	{ 0xa4d0, 0x214531 },
	{ 0xa4d1, 0x214532 },
	{ 0xa4d2, 0x214533 },
	{ 0xa4d3, 0x214534 },
	{ 0xa4d4, 0x214535 },
	{ 0xa4d5, 0x214536 },
	{ 0xa4d6, 0x214537 },
	{ 0xa4d7, 0x214538 },
	{ 0xa4d8, 0x214539 },
	{ 0xa4d9, 0x21453a },
	{ 0xa4da, 0x21453b },
	{ 0xa4db, 0x21453c },
	{ 0xa4dc, 0x21453d },
	{ 0xa4dd, 0x21453e },
	{ 0xa4de, 0x21453f },
	{ 0xa4df, 0x214540 },
	{ 0xa4e0, 0x214541 },
	{ 0xa4e1, 0x214542 },
	{ 0xa4e2, 0x214543 },
	{ 0xa4e3, 0x214544 },
	{ 0xa4e4, 0x214545 },
	{ 0xa4e5, 0x214546 },
	{ 0xa4e6, 0x214547 },
	{ 0xa4e7, 0x214548 },
	{ 0xa4e8, 0x214549 },
	{ 0xa4e9, 0x21454a },
	{ 0xa4ea, 0x21454b },
	{ 0xa4eb, 0x21454c },
	{ 0xa4ec, 0x21454d },
	{ 0xa4ed, 0x21454e },
	{ 0xa4ee, 0x21454f },
	{ 0xa4ef, 0x214550 },
	{ 0xa4f0, 0x214551 },
	{ 0xa4f1, 0x214552 },
	{ 0xa4f2, 0x214553 },
	{ 0xa4f3, 0x214554 },
	{ 0xa4f4, 0x214555 },
	{ 0xa4f5, 0x214556 },
	{ 0xa4f6, 0x214557 },
	{ 0xa4f7, 0x214558 },
	{ 0xa4f8, 0x214559 },
	{ 0xa4f9, 0x21455a },
	{ 0xa4fa, 0x21455b },
	{ 0xa4fb, 0x21455c },
	{ 0xa4fc, 0x21455d },
	{ 0xa4fd, 0x21455e },
	{ 0xa4fe, 0x21455f },
	{ 0xa540, 0x214560 },
	{ 0xa541, 0x214561 },
	{ 0xa542, 0x214562 },
	{ 0xa543, 0x214563 },
	{ 0xa544, 0x214564 },
	{ 0xa545, 0x214565 },
	{ 0xa546, 0x214566 },
	{ 0xa547, 0x214567 },
	{ 0xa548, 0x214568 },
	{ 0xa549, 0x214569 },
	{ 0xa54a, 0x21456a },
	{ 0xa54b, 0x21456b },
	{ 0xa54c, 0x21456c },
	{ 0xa54d, 0x21456d },
	{ 0xa54e, 0x21456e },
	{ 0xa54f, 0x21456f },
	{ 0xa550, 0x214570 },
	{ 0xa551, 0x214571 },
	{ 0xa552, 0x214572 },
	{ 0xa553, 0x214573 },
	{ 0xa554, 0x214574 },
	{ 0xa555, 0x214575 },
	{ 0xa556, 0x214576 },
	{ 0xa557, 0x214577 },
	{ 0xa558, 0x214578 },
	{ 0xa559, 0x214579 },
	{ 0xa55a, 0x21457a },
	{ 0xa55b, 0x21457b },
	{ 0xa55c, 0x21457c },
	{ 0xa55d, 0x21457d },
	{ 0xa55e, 0x21457e },
	{ 0xa55f, 0x214621 },
	{ 0xa560, 0x214622 },
	{ 0xa561, 0x214623 },
	{ 0xa562, 0x214624 },
	{ 0xa563, 0x214625 },
	{ 0xa564, 0x214626 },
	{ 0xa565, 0x214627 },
	{ 0xa566, 0x214628 },
	{ 0xa567, 0x214629 },
	{ 0xa568, 0x21462a },
	{ 0xa569, 0x21462b },
	{ 0xa56a, 0x21462c },
	{ 0xa56b, 0x21462d },
	{ 0xa56c, 0x21462e },
	{ 0xa56d, 0x21462f },
	{ 0xa56e, 0x214630 },
	{ 0xa56f, 0x214631 },
	{ 0xa570, 0x214632 },
	{ 0xa571, 0x214633 },
	{ 0xa572, 0x214634 },
	{ 0xa573, 0x214635 },
	{ 0xa574, 0x214636 },
	{ 0xa575, 0x214637 },
	{ 0xa576, 0x214638 },
	{ 0xa577, 0x214639 },
	{ 0xa578, 0x21463a },
	{ 0xa579, 0x21463b },
	{ 0xa57a, 0x21463c },
	{ 0xa57b, 0x21463d },
	{ 0xa57c, 0x21463e },
	{ 0xa57d, 0x21463f },
	{ 0xa57e, 0x214640 },
	{ 0xa5a1, 0x214641 },
	{ 0xa5a2, 0x214642 },
	{ 0xa5a3, 0x214643 },
	{ 0xa5a4, 0x214644 },
	{ 0xa5a5, 0x214645 },
	{ 0xa5a6, 0x214646 },
	{ 0xa5a7, 0x214647 },
	{ 0xa5a8, 0x214648 },
	{ 0xa5a9, 0x214649 },
	{ 0xa5aa, 0x21464a },
	{ 0xa5ab, 0x21464b },
	{ 0xa5ac, 0x21464c },
	{ 0xa5ad, 0x21464d },
	{ 0xa5ae, 0x21464e },
	{ 0xa5af, 0x21464f },
	{ 0xa5b0, 0x214650 },
	{ 0xa5b1, 0x214651 },
	{ 0xa5b2, 0x214652 },
	{ 0xa5b3, 0x214653 },
	{ 0xa5b4, 0x214654 },
	{ 0xa5b5, 0x214655 },
	{ 0xa5b6, 0x214656 },
	{ 0xa5b7, 0x214657 },
	{ 0xa5b8, 0x214658 },
	{ 0xa5b9, 0x214659 },
	{ 0xa5ba, 0x21465a },
	{ 0xa5bb, 0x21465b },
	{ 0xa5bc, 0x21465c },
	{ 0xa5bd, 0x21465d },
	{ 0xa5be, 0x21465e },
	{ 0xa5bf, 0x21465f },
	{ 0xa5c0, 0x214660 },
	{ 0xa5c1, 0x214661 },
	{ 0xa5c2, 0x214662 },
	{ 0xa5c3, 0x214663 },
	{ 0xa5c4, 0x214664 },
	{ 0xa5c5, 0x214665 },
	{ 0xa5c6, 0x214666 },
	{ 0xa5c7, 0x214667 },
	{ 0xa5c8, 0x214668 },
	{ 0xa5c9, 0x214669 },
	{ 0xa5ca, 0x21466a },
	{ 0xa5cb, 0x21466b },
	{ 0xa5cc, 0x21466c },
	{ 0xa5cd, 0x21466d },
	{ 0xa5ce, 0x21466e },
	{ 0xa5cf, 0x21466f },
	{ 0xa5d0, 0x214670 },
	{ 0xa5d1, 0x214671 },
	{ 0xa5d2, 0x214672 },
	{ 0xa5d3, 0x214673 },
	{ 0xa5d4, 0x214674 },
	{ 0xa5d5, 0x214675 },
	{ 0xa5d6, 0x214676 },
	{ 0xa5d7, 0x214677 },
	{ 0xa5d8, 0x214678 },
	{ 0xa5d9, 0x214679 },
	{ 0xa5da, 0x21467a },
	{ 0xa5db, 0x21467b },
	{ 0xa5dc, 0x21467c },
	{ 0xa5dd, 0x21467d },
	{ 0xa5de, 0x21467e },
	{ 0xa5df, 0x214721 },
	{ 0xa5e0, 0x214722 },
	{ 0xa5e1, 0x214723 },
	{ 0xa5e2, 0x214724 },
	{ 0xa5e3, 0x214725 },
	{ 0xa5e4, 0x214726 },
	{ 0xa5e5, 0x214727 },
	{ 0xa5e6, 0x214728 },
	{ 0xa5e7, 0x214729 },
	{ 0xa5e8, 0x21472a },
	{ 0xa5e9, 0x21472b },
	{ 0xa5ea, 0x21472c },
	{ 0xa5eb, 0x21472d },
	{ 0xa5ec, 0x21472e },
	{ 0xa5ed, 0x21472f },
	{ 0xa5ee, 0x214730 },
	{ 0xa5ef, 0x214731 },
	{ 0xa5f0, 0x214732 },
	{ 0xa5f1, 0x214733 },
	{ 0xa5f2, 0x214734 },
	{ 0xa5f3, 0x214735 },
	{ 0xa5f4, 0x214736 },
	{ 0xa5f5, 0x214737 },
	{ 0xa5f6, 0x214738 },
	{ 0xa5f7, 0x214739 },
	{ 0xa5f8, 0x21473a },
	{ 0xa5f9, 0x21473b },
	{ 0xa5fa, 0x21473c },
	{ 0xa5fb, 0x21473d },
	{ 0xa5fc, 0x21473e },
	{ 0xa5fd, 0x21473f },
	{ 0xa5fe, 0x214740 },
	{ 0xa640, 0x214741 },
	{ 0xa641, 0x214742 },
	{ 0xa642, 0x214743 },
	{ 0xa643, 0x214744 },
	{ 0xa644, 0x214745 },
	{ 0xa645, 0x214746 },
	{ 0xa646, 0x214747 },
	{ 0xa647, 0x214748 },
	{ 0xa648, 0x214749 },
	{ 0xa649, 0x21474a },
	{ 0xa64a, 0x21474b },
	{ 0xa64b, 0x21474c },
	{ 0xa64c, 0x21474d },
	{ 0xa64d, 0x21474e },
	{ 0xa64e, 0x21474f },
	{ 0xa64f, 0x214750 },
	{ 0xa650, 0x214751 },
	{ 0xa651, 0x214752 },
	{ 0xa652, 0x214753 },
	{ 0xa653, 0x214754 },
	{ 0xa654, 0x214755 },
	{ 0xa655, 0x214756 },
	{ 0xa656, 0x214757 },
	{ 0xa657, 0x214758 },
	{ 0xa658, 0x214759 },
	{ 0xa659, 0x21475a },
	{ 0xa65a, 0x21475b },
	{ 0xa65b, 0x21475c },
	{ 0xa65c, 0x21475d },
	{ 0xa65d, 0x21475e },
	{ 0xa65e, 0x21475f },
	{ 0xa65f, 0x214760 },
	{ 0xa660, 0x214761 },
	{ 0xa661, 0x214762 },
	{ 0xa662, 0x214763 },
	{ 0xa663, 0x214764 },
	{ 0xa664, 0x214765 },
	{ 0xa665, 0x214766 },
	{ 0xa666, 0x214767 },
	{ 0xa667, 0x214768 },
	{ 0xa668, 0x214769 },
	{ 0xa669, 0x21476a },
	{ 0xa66a, 0x21476b },
	{ 0xa66b, 0x21476c },
	{ 0xa66c, 0x21476d },
	{ 0xa66d, 0x21476e },
	{ 0xa66e, 0x21476f },
	{ 0xa66f, 0x214770 },
	{ 0xa670, 0x214771 },
	{ 0xa671, 0x214772 },
	{ 0xa672, 0x214773 },
	{ 0xa673, 0x214774 },
	{ 0xa674, 0x214775 },
	{ 0xa675, 0x214776 },
	{ 0xa676, 0x214777 },
	{ 0xa677, 0x214778 },
	{ 0xa678, 0x214779 },
	{ 0xa679, 0x21477a },
	{ 0xa67a, 0x21477b },
	{ 0xa67b, 0x21477c },
	{ 0xa67c, 0x21477d },
	{ 0xa67d, 0x21477e },
	{ 0xa67e, 0x214821 },
	{ 0xa6a1, 0x214822 },
	{ 0xa6a2, 0x214823 },
	{ 0xa6a3, 0x214824 },
	{ 0xa6a4, 0x214825 },
	{ 0xa6a5, 0x214826 },
	{ 0xa6a6, 0x214827 },
	{ 0xa6a7, 0x214828 },
	{ 0xa6a8, 0x214829 },
	{ 0xa6a9, 0x21482a },
	{ 0xa6aa, 0x21482b },
	{ 0xa6ab, 0x21482c },
	{ 0xa6ac, 0x21482d },
	{ 0xa6ad, 0x21482e },
	{ 0xa6ae, 0x21482f },
	{ 0xa6af, 0x214830 },
	{ 0xa6b0, 0x214831 },
	{ 0xa6b1, 0x214832 },
	{ 0xa6b2, 0x214833 },
	{ 0xa6b3, 0x214834 },
	{ 0xa6b4, 0x214835 },
	{ 0xa6b5, 0x214836 },
	{ 0xa6b6, 0x214837 },
	{ 0xa6b7, 0x214838 },
	{ 0xa6b8, 0x214839 },
	{ 0xa6b9, 0x21483a },
	{ 0xa6ba, 0x21483b },
	{ 0xa6bb, 0x21483c },
	{ 0xa6bc, 0x21483d },
	{ 0xa6bd, 0x21483e },
	{ 0xa6be, 0x21483f },
	{ 0xa6bf, 0x214840 },
	{ 0xa6c0, 0x214841 },
	{ 0xa6c1, 0x214842 },
	{ 0xa6c2, 0x214843 },
	{ 0xa6c3, 0x214844 },
	{ 0xa6c4, 0x214845 },
	{ 0xa6c5, 0x214846 },
	{ 0xa6c6, 0x214847 },
	{ 0xa6c7, 0x214848 },
	{ 0xa6c8, 0x214849 },
	{ 0xa6c9, 0x21484a },
	{ 0xa6ca, 0x21484b },
	{ 0xa6cb, 0x21484c },
	{ 0xa6cc, 0x21484d },
	{ 0xa6cd, 0x21484e },
	{ 0xa6ce, 0x21484f },
	{ 0xa6cf, 0x214850 },
	{ 0xa6d0, 0x214851 },
	{ 0xa6d1, 0x214852 },
	{ 0xa6d2, 0x214853 },
	{ 0xa6d3, 0x214854 },
	{ 0xa6d4, 0x214855 },
	{ 0xa6d5, 0x214856 },
	{ 0xa6d6, 0x214857 },
	{ 0xa6d7, 0x214858 },
	{ 0xa6d8, 0x214859 },
	{ 0xa6d9, 0x21485a },
	{ 0xa6da, 0x21485b },
	{ 0xa6db, 0x21485c },
	{ 0xa6dc, 0x21485d },
	{ 0xa6dd, 0x21485e },
	{ 0xa6de, 0x21485f },
	{ 0xa6df, 0x214860 },
	{ 0xa6e0, 0x214861 },
	{ 0xa6e1, 0x214862 },
	{ 0xa6e2, 0x214863 },
	{ 0xa6e3, 0x214864 },
	{ 0xa6e4, 0x214865 },
	{ 0xa6e5, 0x214866 },
	{ 0xa6e6, 0x214867 },
	{ 0xa6e7, 0x214868 },
	{ 0xa6e8, 0x214869 },
	{ 0xa6e9, 0x21486a },
	{ 0xa6ea, 0x21486b },
	{ 0xa6eb, 0x21486c },
	{ 0xa6ec, 0x21486d },
	{ 0xa6ed, 0x21486e },
	{ 0xa6ee, 0x21486f },
	{ 0xa6ef, 0x214870 },
	{ 0xa6f0, 0x214871 },
	{ 0xa6f1, 0x214872 },
	{ 0xa6f2, 0x214873 },
	{ 0xa6f3, 0x214874 },
	{ 0xa6f4, 0x214875 },
	{ 0xa6f5, 0x214876 },
	{ 0xa6f6, 0x214877 },
	{ 0xa6f7, 0x214878 },
	{ 0xa6f8, 0x214879 },
	{ 0xa6f9, 0x21487a },
	{ 0xa6fa, 0x21487b },
	{ 0xa6fb, 0x21487c },
	{ 0xa6fc, 0x21487d },
	{ 0xa6fd, 0x21487e },
	{ 0xa6fe, 0x214921 },
	{ 0xa740, 0x214922 },
	{ 0xa741, 0x214923 },
	{ 0xa742, 0x214924 },
	{ 0xa743, 0x214925 },
	{ 0xa744, 0x214926 },
	{ 0xa745, 0x214927 },
	{ 0xa746, 0x214928 },
	{ 0xa747, 0x214929 },
	{ 0xa748, 0x21492a },
	{ 0xa749, 0x21492b },
	{ 0xa74a, 0x21492c },
	{ 0xa74b, 0x21492d },
	{ 0xa74c, 0x21492e },
	{ 0xa74d, 0x21492f },
	{ 0xa74e, 0x214930 },
	{ 0xa74f, 0x214931 },
	{ 0xa750, 0x214932 },
	{ 0xa751, 0x214933 },
	{ 0xa752, 0x214934 },
	{ 0xa753, 0x214935 },
	{ 0xa754, 0x214936 },
	{ 0xa755, 0x214937 },
	{ 0xa756, 0x214938 },
	{ 0xa757, 0x214939 },
	{ 0xa758, 0x21493a },
	{ 0xa759, 0x21493b },
	{ 0xa75a, 0x21493c },
	{ 0xa75b, 0x21493d },
	{ 0xa75c, 0x21493e },
	{ 0xa75d, 0x21493f },
	{ 0xa75e, 0x214940 },
	{ 0xa75f, 0x214941 },
	{ 0xa760, 0x214942 },
	{ 0xa761, 0x214943 },
	{ 0xa762, 0x214944 },
	{ 0xa763, 0x214945 },
	{ 0xa764, 0x214946 },
	{ 0xa765, 0x214947 },
	{ 0xa766, 0x214948 },
	{ 0xa767, 0x214949 },
	{ 0xa768, 0x21494a },
	{ 0xa769, 0x21494b },
	{ 0xa76a, 0x21494c },
	{ 0xa76b, 0x21494d },
	{ 0xa76c, 0x21494e },
	{ 0xa76d, 0x21494f },
	{ 0xa76e, 0x214950 },
	{ 0xa76f, 0x214951 },
	{ 0xa770, 0x214952 },
	{ 0xa771, 0x214953 },
	{ 0xa772, 0x214954 },
	{ 0xa773, 0x214955 },
	{ 0xa774, 0x214956 },
	{ 0xa775, 0x214957 },
	{ 0xa776, 0x214958 },
	{ 0xa777, 0x214959 },
	{ 0xa778, 0x21495a },
	{ 0xa779, 0x21495b },
	{ 0xa77a, 0x21495c },
	{ 0xa77b, 0x21495d },
	{ 0xa77c, 0x21495e },
	{ 0xa77d, 0x21495f },
	{ 0xa77e, 0x214960 },
	{ 0xa7a1, 0x214961 },
	{ 0xa7a2, 0x214962 },
	{ 0xa7a3, 0x214963 },
	{ 0xa7a4, 0x214964 },
	{ 0xa7a5, 0x214965 },
	{ 0xa7a6, 0x214966 },
	{ 0xa7a7, 0x214967 },
	{ 0xa7a8, 0x214968 },
	{ 0xa7a9, 0x214969 },
	{ 0xa7aa, 0x21496a },
	{ 0xa7ab, 0x21496b },
	{ 0xa7ac, 0x21496c },
	{ 0xa7ad, 0x21496d },
	{ 0xa7ae, 0x21496e },
	{ 0xa7af, 0x21496f },
	{ 0xa7b0, 0x214970 },
	{ 0xa7b1, 0x214971 },
	{ 0xa7b2, 0x214972 },
	{ 0xa7b3, 0x214973 },
	{ 0xa7b4, 0x214974 },
	{ 0xa7b5, 0x214975 },
	{ 0xa7b6, 0x214976 },
	{ 0xa7b7, 0x214977 },
	{ 0xa7b8, 0x214978 },
	{ 0xa7b9, 0x214979 },
	{ 0xa7ba, 0x21497a },
	{ 0xa7bb, 0x21497b },
	{ 0xa7bc, 0x21497c },
	{ 0xa7bd, 0x21497d },
	{ 0xa7be, 0x21497e },
	{ 0xa7bf, 0x214a21 },
	{ 0xa7c0, 0x214a22 },
	{ 0xa7c1, 0x214a23 },
	{ 0xa7c2, 0x214a24 },
	{ 0xa7c3, 0x214a25 },
	{ 0xa7c4, 0x214a26 },
	{ 0xa7c5, 0x214a27 },
	{ 0xa7c6, 0x214a28 },
	{ 0xa7c7, 0x214a29 },
	{ 0xa7c8, 0x214a2a },
	{ 0xa7c9, 0x214a2b },
	{ 0xa7ca, 0x214a2c },
	{ 0xa7cb, 0x214a2d },
	{ 0xa7cc, 0x214a2e },
	{ 0xa7cd, 0x214a2f },
	{ 0xa7ce, 0x214a30 },
	{ 0xa7cf, 0x214a31 },
	{ 0xa7d0, 0x214a32 },
	{ 0xa7d1, 0x214a33 },
	{ 0xa7d2, 0x214a34 },
	{ 0xa7d3, 0x214a35 },
	{ 0xa7d4, 0x214a36 },
	{ 0xa7d5, 0x214a37 },
	{ 0xa7d6, 0x214a38 },
	{ 0xa7d7, 0x214a39 },
	{ 0xa7d8, 0x214a3a },
	{ 0xa7d9, 0x214a3b },
	{ 0xa7da, 0x214a3c },
	{ 0xa7db, 0x214a3d },
	{ 0xa7dc, 0x214a3e },
	{ 0xa7dd, 0x214a3f },
	{ 0xa7de, 0x214a40 },
	{ 0xa7df, 0x214a41 },
	{ 0xa7e0, 0x214a42 },
	{ 0xa7e1, 0x214a43 },
	{ 0xa7e2, 0x214a44 },
	{ 0xa7e3, 0x214a45 },
	{ 0xa7e4, 0x214a46 },
	{ 0xa7e5, 0x214a47 },
	{ 0xa7e6, 0x214a48 },
	{ 0xa7e7, 0x214a49 },
	{ 0xa7e8, 0x214a4a },
	{ 0xa7e9, 0x214a4b },
	{ 0xa7ea, 0x214a4c },
	{ 0xa7eb, 0x214a4d },
	{ 0xa7ec, 0x214a4e },
	{ 0xa7ed, 0x214a4f },
	{ 0xa7ee, 0x214a50 },
	{ 0xa7ef, 0x214a51 },
	{ 0xa7f0, 0x214a52 },
	{ 0xa7f1, 0x214a53 },
	{ 0xa7f2, 0x214a54 },
	{ 0xa7f3, 0x214a55 },
	{ 0xa7f4, 0x214a56 },
	{ 0xa7f5, 0x214a57 },
	{ 0xa7f6, 0x214a58 },
	{ 0xa7f7, 0x214a59 },
	{ 0xa7f8, 0x214a5a },
	{ 0xa7f9, 0x214a5b },
	{ 0xa7fa, 0x214a5c },
	{ 0xa7fb, 0x214a5d },
	{ 0xa7fc, 0x214a5e },
	{ 0xa7fd, 0x214a5f },
	{ 0xa7fe, 0x214a60 },
	{ 0xa840, 0x214a61 },
	{ 0xa841, 0x214a62 },
	{ 0xa842, 0x214a63 },
	{ 0xa843, 0x214a64 },
	{ 0xa844, 0x214a65 },
	{ 0xa845, 0x214a66 },
	{ 0xa846, 0x214a67 },
	{ 0xa847, 0x214a68 },
	{ 0xa848, 0x214a69 },
	{ 0xa849, 0x214a6a },
	{ 0xa84a, 0x214a6b },
	{ 0xa84b, 0x214a6c },
	{ 0xa84c, 0x214a6d },
	{ 0xa84d, 0x214a6e },
	{ 0xa84e, 0x214a6f },
	{ 0xa84f, 0x214a70 },
	{ 0xa850, 0x214a71 },
	{ 0xa851, 0x214a72 },
	{ 0xa852, 0x214a73 },
	{ 0xa853, 0x214a74 },
	{ 0xa854, 0x214a75 },
	{ 0xa855, 0x214a76 },
	{ 0xa856, 0x214a77 },
	{ 0xa857, 0x214a78 },
	{ 0xa858, 0x214a79 },
	{ 0xa859, 0x214a7a },
	{ 0xa85a, 0x214a7b },
	{ 0xa85b, 0x214a7c },
	{ 0xa85c, 0x214a7d },
	{ 0xa85d, 0x214a7e },
	{ 0xa85e, 0x214b21 },
	{ 0xa85f, 0x214b22 },
	{ 0xa860, 0x214b23 },
	{ 0xa861, 0x214b24 },
	{ 0xa862, 0x214b25 },
	{ 0xa863, 0x214b26 },
	{ 0xa864, 0x214b27 },
	{ 0xa865, 0x214b28 },
	{ 0xa866, 0x214b29 },
	{ 0xa867, 0x214b2a },
	{ 0xa868, 0x214b2b },
	{ 0xa869, 0x214b2c },
	{ 0xa86a, 0x214b2d },
	{ 0xa86b, 0x214b2e },
	{ 0xa86c, 0x214b2f },
	{ 0xa86d, 0x214b30 },
	{ 0xa86e, 0x214b31 },
	{ 0xa86f, 0x214b32 },
	{ 0xa870, 0x214b33 },
	{ 0xa871, 0x214b34 },
	{ 0xa872, 0x214b35 },
	{ 0xa873, 0x214b36 },
	{ 0xa874, 0x214b37 },
	{ 0xa875, 0x214b38 },
	{ 0xa876, 0x214b39 },
	{ 0xa877, 0x214b3a },
	{ 0xa878, 0x214b3b },
	{ 0xa879, 0x214b3c },
	{ 0xa87a, 0x214b3d },
	{ 0xa87b, 0x214b3e },
	{ 0xa87c, 0x214b3f },
	{ 0xa87d, 0x214b40 },
	{ 0xa87e, 0x214b41 },
	{ 0xa8a1, 0x214b42 },
	{ 0xa8a2, 0x214b43 },
	{ 0xa8a3, 0x214b44 },
	{ 0xa8a4, 0x214b45 },
	{ 0xa8a5, 0x214b46 },
	{ 0xa8a6, 0x214b47 },
	{ 0xa8a7, 0x214b48 },
	{ 0xa8a8, 0x214b49 },
	{ 0xa8a9, 0x214b4a },
	{ 0xa8aa, 0x214b4b },
	{ 0xa8ab, 0x214b4c },
	{ 0xa8ac, 0x214b4d },
	{ 0xa8ad, 0x214b4e },
	{ 0xa8ae, 0x214b4f },
	{ 0xa8af, 0x214b50 },
	{ 0xa8b0, 0x214b51 },
	{ 0xa8b1, 0x214b52 },
	{ 0xa8b2, 0x214b53 },
	{ 0xa8b3, 0x214b54 },
	{ 0xa8b4, 0x214b55 },
	{ 0xa8b5, 0x214b56 },
	{ 0xa8b6, 0x214b57 },
	{ 0xa8b7, 0x214b58 },
	{ 0xa8b8, 0x214b59 },
	{ 0xa8b9, 0x214b5a },
	{ 0xa8ba, 0x214b5b },
	{ 0xa8bb, 0x214b5c },
	{ 0xa8bc, 0x214b5d },
	{ 0xa8bd, 0x214b5e },
	{ 0xa8be, 0x214b5f },
	{ 0xa8bf, 0x214b60 },
	{ 0xa8c0, 0x214b61 },
	{ 0xa8c1, 0x214b62 },
	{ 0xa8c2, 0x214b63 },
	{ 0xa8c3, 0x214b64 },
	{ 0xa8c4, 0x214b65 },
	{ 0xa8c5, 0x214b66 },
	{ 0xa8c6, 0x214b67 },
	{ 0xa8c7, 0x214b68 },
	{ 0xa8c8, 0x214b69 },
	{ 0xa8c9, 0x214b6a },
	{ 0xa8ca, 0x214b6b },
	{ 0xa8cb, 0x214b6c },
	{ 0xa8cc, 0x214b6d },
	{ 0xa8cd, 0x214b6e },
	{ 0xa8ce, 0x214b6f },
	{ 0xa8cf, 0x214b70 },
	{ 0xa8d0, 0x214b71 },
	{ 0xa8d1, 0x214b72 },
	{ 0xa8d2, 0x214b73 },
	{ 0xa8d3, 0x214b74 },
	{ 0xa8d4, 0x214b75 },
	{ 0xa8d5, 0x214b76 },
	{ 0xa8d6, 0x214b77 },
	{ 0xa8d7, 0x214b78 },
	{ 0xa8d8, 0x214b79 },
	{ 0xa8d9, 0x214b7a },
	{ 0xa8da, 0x214b7b },
	{ 0xa8db, 0x214b7c },
	{ 0xa8dc, 0x214b7d },
	{ 0xa8dd, 0x214b7e },
	{ 0xa8de, 0x214c21 },
	{ 0xa8df, 0x214c22 },
	{ 0xa8e0, 0x214c23 },
	{ 0xa8e1, 0x214c24 },
	{ 0xa8e2, 0x214c25 },
	{ 0xa8e3, 0x214c26 },
	{ 0xa8e4, 0x214c27 },
	{ 0xa8e5, 0x214c28 },
	{ 0xa8e6, 0x214c29 },
	{ 0xa8e7, 0x214c2a },
	{ 0xa8e8, 0x214c2b },
	{ 0xa8e9, 0x214c2c },
	{ 0xa8ea, 0x214c2d },
	{ 0xa8eb, 0x214c2e },
	{ 0xa8ec, 0x214c2f },
	{ 0xa8ed, 0x214c30 },
	{ 0xa8ee, 0x214c31 },
	{ 0xa8ef, 0x214c32 },
	{ 0xa8f0, 0x214c33 },
	{ 0xa8f1, 0x214c34 },
	{ 0xa8f2, 0x214c35 },
	{ 0xa8f3, 0x214c36 },
	{ 0xa8f4, 0x214c37 },
	{ 0xa8f5, 0x214c38 },
	{ 0xa8f6, 0x214c39 },
	{ 0xa8f7, 0x214c3a },
	{ 0xa8f8, 0x214c3b },
	{ 0xa8f9, 0x214c3c },
	{ 0xa8fa, 0x214c3d },
	{ 0xa8fb, 0x214c3e },
	{ 0xa8fc, 0x214c3f },
	{ 0xa8fd, 0x214c40 },
	{ 0xa8fe, 0x214c41 },
	{ 0xa940, 0x214c42 },
	{ 0xa941, 0x214c43 },
	{ 0xa942, 0x214c44 },
	{ 0xa943, 0x214c45 },
	{ 0xa944, 0x214c46 },
	{ 0xa945, 0x214c47 },
	{ 0xa946, 0x214c48 },
	{ 0xa947, 0x214c49 },
	{ 0xa948, 0x214c4a },
	{ 0xa949, 0x214c4b },
	{ 0xa94a, 0x214c4c },
	{ 0xa94b, 0x214c4d },
	{ 0xa94c, 0x214c4e },
	{ 0xa94d, 0x214c4f },
	{ 0xa94e, 0x214c50 },
	{ 0xa94f, 0x214c51 },
	{ 0xa950, 0x214c52 },
	{ 0xa951, 0x214c53 },
	{ 0xa952, 0x214c54 },
	{ 0xa953, 0x214c55 },
	{ 0xa954, 0x214c56 },
	{ 0xa955, 0x214c57 },
	{ 0xa956, 0x214c58 },
	{ 0xa957, 0x214c59 },
	{ 0xa958, 0x214c5a },
	{ 0xa959, 0x214c5b },
	{ 0xa95a, 0x214c5c },
	{ 0xa95b, 0x214c5d },
	{ 0xa95c, 0x214c5e },
	{ 0xa95d, 0x214c5f },
	{ 0xa95e, 0x214c60 },
	{ 0xa95f, 0x214c61 },
	{ 0xa960, 0x214c62 },
	{ 0xa961, 0x214c63 },
	{ 0xa962, 0x214c64 },
	{ 0xa963, 0x214c65 },
	{ 0xa964, 0x214c66 },
	{ 0xa965, 0x214c67 },
	{ 0xa966, 0x214c68 },
	{ 0xa967, 0x214c69 },
	{ 0xa968, 0x214c6a },
	{ 0xa969, 0x214c6b },
	{ 0xa96a, 0x214c6c },
	{ 0xa96b, 0x214c6d },
	{ 0xa96c, 0x214c6e },
	{ 0xa96d, 0x214c6f },
	{ 0xa96e, 0x214c70 },
	{ 0xa96f, 0x214c71 },
	{ 0xa970, 0x214c72 },
	{ 0xa971, 0x214c73 },
	{ 0xa972, 0x214c74 },
	{ 0xa973, 0x214c75 },
	{ 0xa974, 0x214c76 },
	{ 0xa975, 0x214c77 },
	{ 0xa976, 0x214c78 },
	{ 0xa977, 0x214c79 },
	{ 0xa978, 0x214c7a },
	{ 0xa979, 0x214c7b },
	{ 0xa97a, 0x214c7c },
	{ 0xa97b, 0x214c7d },
	{ 0xa97c, 0x214c7e },
	{ 0xa97d, 0x214d21 },
	{ 0xa97e, 0x214d22 },
	{ 0xa9a1, 0x214d23 },
	{ 0xa9a2, 0x214d24 },
	{ 0xa9a3, 0x214d25 },
	{ 0xa9a4, 0x214d26 },
	{ 0xa9a5, 0x214d27 },
	{ 0xa9a6, 0x214d28 },
	{ 0xa9a7, 0x214d29 },
	{ 0xa9a8, 0x214d2a },
	{ 0xa9a9, 0x214d2b },
	{ 0xa9aa, 0x214d2c },
	{ 0xa9ab, 0x214d2d },
	{ 0xa9ac, 0x214d2e },
	{ 0xa9ad, 0x214d2f },
	{ 0xa9ae, 0x214d30 },
	{ 0xa9af, 0x214d31 },
	{ 0xa9b0, 0x214d32 },
	{ 0xa9b1, 0x214d33 },
	{ 0xa9b2, 0x214d34 },
	{ 0xa9b3, 0x214d35 },
	{ 0xa9b4, 0x214d36 },
	{ 0xa9b5, 0x214d37 },
	{ 0xa9b6, 0x214d38 },
	{ 0xa9b7, 0x214d39 },
	{ 0xa9b8, 0x214d3a },
	{ 0xa9b9, 0x214d3b },
	{ 0xa9ba, 0x214d3c },
	{ 0xa9bb, 0x214d3d },
	{ 0xa9bc, 0x214d3e },
	{ 0xa9bd, 0x214d3f },
	{ 0xa9be, 0x214d40 },
	{ 0xa9bf, 0x214d41 },
	{ 0xa9c0, 0x214d42 },
	{ 0xa9c1, 0x214d43 },
	{ 0xa9c2, 0x214d44 },
	{ 0xa9c3, 0x214d45 },
	{ 0xa9c4, 0x214d46 },
	{ 0xa9c5, 0x214d47 },
	{ 0xa9c6, 0x214d48 },
	{ 0xa9c7, 0x214d49 },
	{ 0xa9c8, 0x214d4a },
	{ 0xa9c9, 0x214d4b },
	{ 0xa9ca, 0x214d4c },
	{ 0xa9cb, 0x214d4d },
	{ 0xa9cc, 0x214d4e },
	{ 0xa9cd, 0x214d4f },
	{ 0xa9ce, 0x214d50 },
	{ 0xa9cf, 0x214d51 },
	{ 0xa9d0, 0x214d52 },
	{ 0xa9d1, 0x214d53 },
	{ 0xa9d2, 0x214d54 },
	{ 0xa9d3, 0x214d55 },
	{ 0xa9d4, 0x214d56 },
	{ 0xa9d5, 0x214d57 },
	{ 0xa9d6, 0x214d58 },
	{ 0xa9d7, 0x214d59 },
	{ 0xa9d8, 0x214d5a },
	{ 0xa9d9, 0x214d5b },
	{ 0xa9da, 0x214d5c },
	{ 0xa9db, 0x214d5d },
	{ 0xa9dc, 0x214d5e },
	{ 0xa9dd, 0x214d5f },
	{ 0xa9de, 0x214d60 },
	{ 0xa9df, 0x214d61 },
	{ 0xa9e0, 0x214d62 },
	{ 0xa9e1, 0x214d63 },
	{ 0xa9e2, 0x214d64 },
	{ 0xa9e3, 0x214d65 },
	{ 0xa9e4, 0x214d66 },
	{ 0xa9e5, 0x214d67 },
	{ 0xa9e6, 0x214d68 },
	{ 0xa9e7, 0x214d69 },
	{ 0xa9e8, 0x214d6a },
	{ 0xa9e9, 0x214d6b },
	{ 0xa9ea, 0x214d6c },
	{ 0xa9eb, 0x214d6d },
	{ 0xa9ec, 0x214d6e },
	{ 0xa9ed, 0x214d6f },
	{ 0xa9ee, 0x214d70 },
	{ 0xa9ef, 0x214d71 },
	{ 0xa9f0, 0x214d72 },
	{ 0xa9f1, 0x214d73 },
	{ 0xa9f2, 0x214d74 },
	{ 0xa9f3, 0x214d75 },
	{ 0xa9f4, 0x214d76 },
	{ 0xa9f5, 0x214d77 },
	{ 0xa9f6, 0x214d78 },
	{ 0xa9f7, 0x214d79 },
	{ 0xa9f8, 0x214d7a },
	{ 0xa9f9, 0x214d7b },
	{ 0xa9fa, 0x214d7c },
	{ 0xa9fb, 0x214d7d },
	{ 0xa9fc, 0x214d7e },
	{ 0xa9fd, 0x214e21 },
	{ 0xa9fe, 0x214e22 },
	{ 0xaa40, 0x214e23 },
	{ 0xaa41, 0x214e24 },
	{ 0xaa42, 0x214e25 },
	{ 0xaa43, 0x214e26 },
	{ 0xaa44, 0x214e27 },
	{ 0xaa45, 0x214e28 },
	{ 0xaa46, 0x214e29 },
	{ 0xaa47, 0x214e2a },
	{ 0xaa48, 0x214e2b },
	{ 0xaa49, 0x214e2c },
	{ 0xaa4a, 0x214e2d },
	{ 0xaa4b, 0x214e2e },
	{ 0xaa4c, 0x214e2f },
	{ 0xaa4d, 0x214e30 },
	{ 0xaa4e, 0x214e31 },
	{ 0xaa4f, 0x214e32 },
	{ 0xaa50, 0x214e33 },
	{ 0xaa51, 0x214e34 },
	{ 0xaa52, 0x214e35 },
	{ 0xaa53, 0x214e36 },
	{ 0xaa54, 0x214e37 },
	{ 0xaa55, 0x214e38 },
	{ 0xaa56, 0x214e39 },
	{ 0xaa57, 0x214e3a },
	{ 0xaa58, 0x214e3b },
	{ 0xaa59, 0x214e3c },
	{ 0xaa5a, 0x214e3d },
	{ 0xaa5b, 0x214e3e },
	{ 0xaa5c, 0x214e3f },
	{ 0xaa5d, 0x214e40 },
	{ 0xaa5e, 0x214e41 },
	{ 0xaa5f, 0x214e42 },
	{ 0xaa60, 0x214e43 },
	{ 0xaa61, 0x214e44 },
	{ 0xaa62, 0x214e45 },
	{ 0xaa63, 0x214e46 },
	{ 0xaa64, 0x214e47 },
	{ 0xaa65, 0x214e48 },
	{ 0xaa66, 0x214e49 },
	{ 0xaa67, 0x214e4a },
	{ 0xaa68, 0x214e4b },
	{ 0xaa69, 0x214e4c },
	{ 0xaa6a, 0x214e4d },
	{ 0xaa6b, 0x214e4e },
	{ 0xaa6c, 0x214e4f },
	{ 0xaa6d, 0x214e50 },
	{ 0xaa6e, 0x214e51 },
	{ 0xaa6f, 0x214e52 },
	{ 0xaa70, 0x214e53 },
	{ 0xaa71, 0x214e54 },
	{ 0xaa72, 0x214e55 },
	{ 0xaa73, 0x214e56 },
	{ 0xaa74, 0x214e57 },
	{ 0xaa75, 0x214e58 },
	{ 0xaa76, 0x214e59 },
	{ 0xaa77, 0x214e5a },
	{ 0xaa78, 0x214e5b },
	{ 0xaa79, 0x214e5c },
	{ 0xaa7a, 0x214e5d },
	{ 0xaa7b, 0x214e5e },
	{ 0xaa7c, 0x214e5f },
	{ 0xaa7d, 0x214e60 },
	{ 0xaa7e, 0x214e61 },
	{ 0xaaa1, 0x214e62 },
	{ 0xaaa2, 0x214e63 },
	{ 0xaaa3, 0x214e64 },
	{ 0xaaa4, 0x214e65 },
	{ 0xaaa5, 0x214e66 },
	{ 0xaaa6, 0x214e67 },
	{ 0xaaa7, 0x214e68 },
	{ 0xaaa8, 0x214e69 },
	{ 0xaaa9, 0x214e6a },
	{ 0xaaaa, 0x214e6b },
	{ 0xaaab, 0x214e6c },
	{ 0xaaac, 0x214e6d },
	{ 0xaaad, 0x214e6e },
	{ 0xaaae, 0x214e6f },
	{ 0xaaaf, 0x214e70 },
	{ 0xaab0, 0x214e71 },
	{ 0xaab1, 0x214e72 },
	{ 0xaab2, 0x214e73 },
	{ 0xaab3, 0x214e74 },
	{ 0xaab4, 0x214e75 },
	{ 0xaab5, 0x214e76 },
	{ 0xaab6, 0x214e77 },
	{ 0xaab7, 0x214e78 },
	{ 0xaab8, 0x214e79 },
	{ 0xaab9, 0x214e7a },
	{ 0xaaba, 0x214e7b },
	{ 0xaabb, 0x214e7c },
	{ 0xaabc, 0x214e7d },
	{ 0xaabd, 0x214e7e },
	{ 0xaabe, 0x214f21 },
	{ 0xaabf, 0x214f22 },
	{ 0xaac0, 0x214f23 },
	{ 0xaac1, 0x214f24 },
	{ 0xaac2, 0x214f25 },
	{ 0xaac3, 0x214f26 },
	{ 0xaac4, 0x214f27 },
	{ 0xaac5, 0x214f28 },
	{ 0xaac6, 0x214f29 },
	{ 0xaac7, 0x214f2a },
	{ 0xaac8, 0x214f2b },
	{ 0xaac9, 0x214f2c },
	{ 0xaaca, 0x214f2d },
	{ 0xaacb, 0x214f2e },
	{ 0xaacc, 0x214f2f },
	{ 0xaacd, 0x214f30 },
	{ 0xaace, 0x214f31 },
	{ 0xaacf, 0x214f32 },
	{ 0xaad0, 0x214f33 },
	{ 0xaad1, 0x214f34 },
	{ 0xaad2, 0x214f35 },
	{ 0xaad3, 0x214f36 },
	{ 0xaad4, 0x214f37 },
	{ 0xaad5, 0x214f38 },
	{ 0xaad6, 0x214f39 },
	{ 0xaad7, 0x214f3a },
	{ 0xaad8, 0x214f3b },
	{ 0xaad9, 0x214f3c },
	{ 0xaada, 0x214f3d },
	{ 0xaadb, 0x214f3e },
	{ 0xaadc, 0x214f3f },
	{ 0xaadd, 0x214f40 },
	{ 0xaade, 0x214f41 },
	{ 0xaadf, 0x214f42 },
	{ 0xaae0, 0x214f43 },
	{ 0xaae1, 0x214f44 },
	{ 0xaae2, 0x214f45 },
	{ 0xaae3, 0x214f46 },
	{ 0xaae4, 0x214f47 },
	{ 0xaae5, 0x214f48 },
	{ 0xaae6, 0x214f49 },
	{ 0xaae7, 0x214f4a },
	{ 0xaae8, 0x214f4b },
	{ 0xaae9, 0x214f4c },
	{ 0xaaea, 0x214f4d },
	{ 0xaaeb, 0x214f4e },
	{ 0xaaec, 0x214f4f },
	{ 0xaaed, 0x214f50 },
	{ 0xaaee, 0x214f51 },
	{ 0xaaef, 0x214f52 },
	{ 0xaaf0, 0x214f53 },
	{ 0xaaf1, 0x214f54 },
	{ 0xaaf2, 0x214f55 },
	{ 0xaaf3, 0x214f56 },
	{ 0xaaf4, 0x214f57 },
	{ 0xaaf5, 0x214f58 },
	{ 0xaaf6, 0x214f59 },
	{ 0xaaf7, 0x214f5a },
	{ 0xaaf8, 0x214f5b },
	{ 0xaaf9, 0x214f5c },
	{ 0xaafa, 0x214f5d },
	{ 0xaafb, 0x214f5e },
	{ 0xaafc, 0x214f5f },
	{ 0xaafd, 0x214f60 },
	{ 0xaafe, 0x214f61 },
	{ 0xab40, 0x214f62 },
	{ 0xab41, 0x214f63 },
	{ 0xab42, 0x214f64 },
	{ 0xab43, 0x214f65 },
	{ 0xab44, 0x214f66 },
	{ 0xab45, 0x214f67 },
	{ 0xab46, 0x214f68 },
	{ 0xab47, 0x214f69 },
	{ 0xab48, 0x214f6a },
	{ 0xab49, 0x214f6b },
	{ 0xab4a, 0x214f6c },
	{ 0xab4b, 0x214f6d },
	{ 0xab4c, 0x214f6e },
	{ 0xab4d, 0x214f6f },
	{ 0xab4e, 0x214f70 },
	{ 0xab4f, 0x214f71 },
	{ 0xab50, 0x214f72 },
	{ 0xab51, 0x214f73 },
	{ 0xab52, 0x214f74 },
	{ 0xab53, 0x214f75 },
	{ 0xab54, 0x214f76 },
	{ 0xab55, 0x214f77 },
	{ 0xab56, 0x214f78 },
	{ 0xab57, 0x214f79 },
	{ 0xab58, 0x214f7a },
	{ 0xab59, 0x214f7b },
	{ 0xab5a, 0x214f7c },
	{ 0xab5b, 0x214f7d },
	{ 0xab5c, 0x214f7e },
	{ 0xab5d, 0x215021 },
	{ 0xab5e, 0x215022 },
	{ 0xab5f, 0x215023 },
	{ 0xab60, 0x215024 },
	{ 0xab61, 0x215025 },
	{ 0xab62, 0x215026 },
	{ 0xab63, 0x215027 },
	{ 0xab64, 0x215028 },
	{ 0xab65, 0x215029 },
	{ 0xab66, 0x21502a },
	{ 0xab67, 0x21502b },
	{ 0xab68, 0x21502c },
	{ 0xab69, 0x21502d },
	{ 0xab6a, 0x21502e },
	{ 0xab6b, 0x21502f },
	{ 0xab6c, 0x215030 },
	{ 0xab6d, 0x215031 },
	{ 0xab6e, 0x215032 },
	{ 0xab6f, 0x215033 },
	{ 0xab70, 0x215034 },
	{ 0xab71, 0x215035 },
	{ 0xab72, 0x215036 },
	{ 0xab73, 0x215037 },
	{ 0xab74, 0x215038 },
	{ 0xab75, 0x215039 },
	{ 0xab76, 0x21503a },
	{ 0xab77, 0x21503b },
	{ 0xab78, 0x21503c },
	{ 0xab79, 0x21503d },
	{ 0xab7a, 0x21503e },
	{ 0xab7b, 0x21503f },
	{ 0xab7c, 0x215040 },
	{ 0xab7d, 0x215041 },
	{ 0xab7e, 0x215042 },
	{ 0xaba1, 0x215043 },
	{ 0xaba2, 0x215044 },
	{ 0xaba3, 0x215045 },
	{ 0xaba4, 0x215046 },
	{ 0xaba5, 0x215047 },
	{ 0xaba6, 0x215048 },
	{ 0xaba7, 0x215049 },
	{ 0xaba8, 0x21504a },
	{ 0xaba9, 0x21504b },
	{ 0xabaa, 0x21504c },
	{ 0xabab, 0x21504d },
	{ 0xabac, 0x21504e },
	{ 0xabad, 0x21504f },
	{ 0xabae, 0x215050 },
	{ 0xabaf, 0x215051 },
	{ 0xabb0, 0x215052 },
	{ 0xabb1, 0x215053 },
	{ 0xabb2, 0x215054 },
	{ 0xabb3, 0x215055 },
	{ 0xabb4, 0x215056 },
	{ 0xabb5, 0x215057 },
	{ 0xabb6, 0x215058 },
	{ 0xabb7, 0x215059 },
	{ 0xabb8, 0x21505a },
	{ 0xabb9, 0x21505b },
	{ 0xabba, 0x21505c },
	{ 0xabbb, 0x21505d },
	{ 0xabbc, 0x21505e },
	{ 0xabbd, 0x21505f },
	{ 0xabbe, 0x215060 },
	{ 0xabbf, 0x215061 },
	{ 0xabc0, 0x215062 },
	{ 0xabc1, 0x215063 },
	{ 0xabc2, 0x215064 },
	{ 0xabc3, 0x215065 },
	{ 0xabc4, 0x215066 },
	{ 0xabc5, 0x215067 },
	{ 0xabc6, 0x215068 },
	{ 0xabc7, 0x215069 },
	{ 0xabc8, 0x21506a },
	{ 0xabc9, 0x21506b },
	{ 0xabca, 0x21506c },
	{ 0xabcb, 0x21506d },
	{ 0xabcc, 0x21506e },
	{ 0xabcd, 0x21506f },
	{ 0xabce, 0x215070 },
	{ 0xabcf, 0x215071 },
	{ 0xabd0, 0x215072 },
	{ 0xabd1, 0x215073 },
	{ 0xabd2, 0x215074 },
	{ 0xabd3, 0x215075 },
	{ 0xabd4, 0x215076 },
	{ 0xabd5, 0x215077 },
	{ 0xabd6, 0x215078 },
	{ 0xabd7, 0x215079 },
	{ 0xabd8, 0x21507a },
	{ 0xabd9, 0x21507b },
	{ 0xabda, 0x21507c },
	{ 0xabdb, 0x21507d },
	{ 0xabdc, 0x21507e },
	{ 0xabdd, 0x215121 },
	{ 0xabde, 0x215122 },
	{ 0xabdf, 0x215123 },
	{ 0xabe0, 0x215124 },
	{ 0xabe1, 0x215125 },
	{ 0xabe2, 0x215126 },
	{ 0xabe3, 0x215127 },
	{ 0xabe4, 0x215128 },
	{ 0xabe5, 0x215129 },
	{ 0xabe6, 0x21512a },
	{ 0xabe7, 0x21512b },
	{ 0xabe8, 0x21512c },
	{ 0xabe9, 0x21512d },
	{ 0xabea, 0x21512e },
	{ 0xabeb, 0x21512f },
	{ 0xabec, 0x215130 },
	{ 0xabed, 0x215131 },
	{ 0xabee, 0x215132 },
	{ 0xabef, 0x215133 },
	{ 0xabf0, 0x215134 },
	{ 0xabf1, 0x215135 },
	{ 0xabf2, 0x215136 },
	{ 0xabf3, 0x215137 },
	{ 0xabf4, 0x215138 },
	{ 0xabf5, 0x215139 },
	{ 0xabf6, 0x21513a },
	{ 0xabf7, 0x21513b },
	{ 0xabf8, 0x21513c },
	{ 0xabf9, 0x21513d },
	{ 0xabfa, 0x21513e },
	{ 0xabfb, 0x21513f },
	{ 0xabfc, 0x215140 },
	{ 0xabfd, 0x215141 },
	{ 0xabfe, 0x215142 },
	{ 0xac40, 0x215143 },
	{ 0xac41, 0x215144 },
	{ 0xac42, 0x215145 },
	{ 0xac43, 0x215146 },
	{ 0xac44, 0x215147 },
	{ 0xac45, 0x215148 },
	{ 0xac46, 0x215149 },
	{ 0xac47, 0x21514a },
	{ 0xac48, 0x21514b },
	{ 0xac49, 0x21514c },
	{ 0xac4a, 0x21514d },
	{ 0xac4b, 0x21514e },
	{ 0xac4c, 0x21514f },
	{ 0xac4d, 0x215150 },
	{ 0xac4e, 0x215151 },
	{ 0xac4f, 0x215152 },
	{ 0xac50, 0x215153 },
	{ 0xac51, 0x215154 },
	{ 0xac52, 0x215155 },
	{ 0xac53, 0x215156 },
	{ 0xac54, 0x215157 },
	{ 0xac55, 0x215158 },
	{ 0xac56, 0x215159 },
	{ 0xac57, 0x21515a },
	{ 0xac58, 0x21515b },
	{ 0xac59, 0x21515c },
	{ 0xac5a, 0x21515d },
	{ 0xac5b, 0x21515e },
	{ 0xac5c, 0x21515f },
	{ 0xac5d, 0x215160 },
	{ 0xac5e, 0x215161 },
	{ 0xac5f, 0x215162 },
	{ 0xac60, 0x215163 },
	{ 0xac61, 0x215164 },
	{ 0xac62, 0x215165 },
	{ 0xac63, 0x215166 },
	{ 0xac64, 0x215167 },
	{ 0xac65, 0x215168 },
	{ 0xac66, 0x215169 },
	{ 0xac67, 0x21516a },
	{ 0xac68, 0x21516b },
	{ 0xac69, 0x21516c },
	{ 0xac6a, 0x21516d },
	{ 0xac6b, 0x21516e },
	{ 0xac6c, 0x21516f },
	{ 0xac6d, 0x215170 },
	{ 0xac6e, 0x215171 },
	{ 0xac6f, 0x215172 },
	{ 0xac70, 0x215173 },
	{ 0xac71, 0x215174 },
	{ 0xac72, 0x215175 },
	{ 0xac73, 0x215176 },
	{ 0xac74, 0x215177 },
	{ 0xac75, 0x215178 },
	{ 0xac76, 0x215179 },
	{ 0xac77, 0x21517a },
	{ 0xac78, 0x21517b },
	{ 0xac79, 0x21517c },
	{ 0xac7a, 0x21517d },
	{ 0xac7b, 0x21517e },
	{ 0xac7c, 0x215221 },
	{ 0xac7d, 0x215222 },
	{ 0xac7e, 0x215223 },
	{ 0xaca1, 0x215224 },
	{ 0xaca2, 0x215225 },
	{ 0xaca3, 0x215226 },
	{ 0xaca4, 0x215227 },
	{ 0xaca5, 0x215228 },
	{ 0xaca6, 0x215229 },
	{ 0xaca7, 0x21522a },
	{ 0xaca8, 0x21522b },
	{ 0xaca9, 0x21522c },
	{ 0xacaa, 0x21522d },
	{ 0xacab, 0x21522e },
	{ 0xacac, 0x21522f },
	{ 0xacad, 0x215230 },
	{ 0xacae, 0x215231 },
	{ 0xacaf, 0x215232 },
	{ 0xacb0, 0x215233 },
	{ 0xacb1, 0x215234 },
	{ 0xacb2, 0x215235 },
	{ 0xacb3, 0x215236 },
	{ 0xacb4, 0x215237 },
	{ 0xacb5, 0x215238 },
	{ 0xacb6, 0x215239 },
	{ 0xacb7, 0x21523a },
	{ 0xacb8, 0x21523b },
	{ 0xacb9, 0x21523c },
	{ 0xacba, 0x21523d },
	{ 0xacbb, 0x21523e },
	{ 0xacbc, 0x21523f },
	{ 0xacbd, 0x215240 },
	{ 0xacbe, 0x215241 },
	{ 0xacbf, 0x215242 },
	{ 0xacc0, 0x215243 },
	{ 0xacc1, 0x215244 },
	{ 0xacc2, 0x215245 },
	{ 0xacc3, 0x215246 },
	{ 0xacc4, 0x215247 },
	{ 0xacc5, 0x215248 },
	{ 0xacc6, 0x215249 },
	{ 0xacc7, 0x21524a },
	{ 0xacc8, 0x21524b },
	{ 0xacc9, 0x21524c },
	{ 0xacca, 0x21524d },
	{ 0xaccb, 0x21524e },
	{ 0xaccc, 0x21524f },
	{ 0xaccd, 0x215250 },
	{ 0xacce, 0x215251 },
	{ 0xaccf, 0x215252 },
	{ 0xacd0, 0x215253 },
	{ 0xacd1, 0x215254 },
	{ 0xacd2, 0x215255 },
	{ 0xacd3, 0x215256 },
	{ 0xacd4, 0x215257 },
	{ 0xacd5, 0x215258 },
	{ 0xacd6, 0x215259 },
	{ 0xacd7, 0x21525a },
	{ 0xacd8, 0x21525b },
	{ 0xacd9, 0x21525c },
	{ 0xacda, 0x21525d },
	{ 0xacdb, 0x21525e },
	{ 0xacdc, 0x21525f },
	{ 0xacdd, 0x215260 },
	{ 0xacde, 0x215261 },
	{ 0xacdf, 0x215262 },
	{ 0xace0, 0x215263 },
	{ 0xace1, 0x215264 },
	{ 0xace2, 0x215265 },
	{ 0xace3, 0x215266 },
	{ 0xace4, 0x215267 },
	{ 0xace5, 0x215268 },
	{ 0xace6, 0x215269 },
	{ 0xace7, 0x21526a },
	{ 0xace8, 0x21526b },
	{ 0xace9, 0x21526c },
	{ 0xacea, 0x21526d },
	{ 0xaceb, 0x21526e },
	{ 0xacec, 0x21526f },
	{ 0xaced, 0x215270 },
	{ 0xacee, 0x215271 },
	{ 0xacef, 0x215272 },
	{ 0xacf0, 0x215273 },
	{ 0xacf1, 0x215274 },
	{ 0xacf2, 0x215275 },
	{ 0xacf3, 0x215276 },
	{ 0xacf4, 0x215277 },
	{ 0xacf5, 0x215278 },
	{ 0xacf6, 0x215279 },
	{ 0xacf7, 0x21527a },
	{ 0xacf8, 0x21527b },
	{ 0xacf9, 0x21527c },
	{ 0xacfa, 0x21527d },
	{ 0xacfb, 0x21527e },
	{ 0xacfc, 0x215321 },
	{ 0xacfd, 0x215322 },
	{ 0xacfe, 0x215753 },
	{ 0xad40, 0x215323 },
	{ 0xad41, 0x215324 },
	{ 0xad42, 0x215325 },
	{ 0xad43, 0x215326 },
	{ 0xad44, 0x215327 },
	{ 0xad45, 0x215328 },
	{ 0xad46, 0x215329 },
	{ 0xad47, 0x21532a },
	{ 0xad48, 0x21532b },
	{ 0xad49, 0x21532c },
	{ 0xad4a, 0x21532d },
	{ 0xad4b, 0x21532e },
	{ 0xad4c, 0x21532f },
	{ 0xad4d, 0x215330 },
	{ 0xad4e, 0x215331 },
	{ 0xad4f, 0x215332 },
	{ 0xad50, 0x215333 },
	{ 0xad51, 0x215334 },
	{ 0xad52, 0x215335 },
	{ 0xad53, 0x215336 },
	{ 0xad54, 0x215337 },
	{ 0xad55, 0x215338 },
	{ 0xad56, 0x215339 },
	{ 0xad57, 0x21533a },
	{ 0xad58, 0x21533b },
	{ 0xad59, 0x21533c },
	{ 0xad5a, 0x21533d },
	{ 0xad5b, 0x21533e },
	{ 0xad5c, 0x21533f },
	{ 0xad5d, 0x215340 },
	{ 0xad5e, 0x215341 },
	{ 0xad5f, 0x215342 },
	{ 0xad60, 0x215343 },
	{ 0xad61, 0x215344 },
	{ 0xad62, 0x215345 },
	{ 0xad63, 0x215346 },
	{ 0xad64, 0x215347 },
	{ 0xad65, 0x215348 },
	{ 0xad66, 0x215349 },
	{ 0xad67, 0x21534a },
	{ 0xad68, 0x21534b },
	{ 0xad69, 0x21534c },
	{ 0xad6a, 0x21534d },
	{ 0xad6b, 0x21534e },
	{ 0xad6c, 0x21534f },
	{ 0xad6d, 0x215350 },
	{ 0xad6e, 0x215351 },
	{ 0xad6f, 0x215352 },
	{ 0xad70, 0x215353 },
	{ 0xad71, 0x215354 },
	{ 0xad72, 0x215355 },
	{ 0xad73, 0x215356 },
	{ 0xad74, 0x215357 },
	{ 0xad75, 0x215358 },
	{ 0xad76, 0x215359 },
	{ 0xad77, 0x21535a },
	{ 0xad78, 0x21535b },
	{ 0xad79, 0x21535c },
	{ 0xad7a, 0x21535d },
	{ 0xad7b, 0x21535e },
	{ 0xad7c, 0x21535f },
	{ 0xad7d, 0x215360 },
	{ 0xad7e, 0x215361 },
	{ 0xada1, 0x215362 },
	{ 0xada2, 0x215363 },
	{ 0xada3, 0x215364 },
	{ 0xada4, 0x215365 },
	{ 0xada5, 0x215366 },
	{ 0xada6, 0x215367 },
	{ 0xada7, 0x215368 },
	{ 0xada8, 0x215369 },
	{ 0xada9, 0x21536a },
	{ 0xadaa, 0x21536b },
	{ 0xadab, 0x21536c },
	{ 0xadac, 0x21536d },
	{ 0xadad, 0x21536e },
	{ 0xadae, 0x21536f },
	{ 0xadaf, 0x215370 },
	{ 0xadb0, 0x215371 },
	{ 0xadb1, 0x215372 },
	{ 0xadb2, 0x215373 },
	{ 0xadb3, 0x215374 },
	{ 0xadb4, 0x215375 },
	{ 0xadb5, 0x215376 },
	{ 0xadb6, 0x215377 },
	{ 0xadb7, 0x215378 },
	{ 0xadb8, 0x215379 },
	{ 0xadb9, 0x21537a },
	{ 0xadba, 0x21537b },
	{ 0xadbb, 0x21537c },
	{ 0xadbc, 0x21537d },
	{ 0xadbd, 0x21537e },
	{ 0xadbe, 0x215421 },
	{ 0xadbf, 0x215422 },
	{ 0xadc0, 0x215423 },
	{ 0xadc1, 0x215424 },
	{ 0xadc2, 0x215425 },
	{ 0xadc3, 0x215426 },
	{ 0xadc4, 0x215427 },
	{ 0xadc5, 0x215428 },
	{ 0xadc6, 0x215429 },
	{ 0xadc7, 0x21542a },
	{ 0xadc8, 0x21542b },
	{ 0xadc9, 0x21542c },
	{ 0xadca, 0x21542d },
	{ 0xadcb, 0x21542e },
	{ 0xadcc, 0x21542f },
	{ 0xadcd, 0x215430 },
	{ 0xadce, 0x215431 },
	{ 0xadcf, 0x215432 },
	{ 0xadd0, 0x215433 },
	{ 0xadd1, 0x215434 },
	{ 0xadd2, 0x215435 },
	{ 0xadd3, 0x215436 },
	{ 0xadd4, 0x215437 },
	{ 0xadd5, 0x215438 },
	{ 0xadd6, 0x215439 },
	{ 0xadd7, 0x21543a },
	{ 0xadd8, 0x21543b },
	{ 0xadd9, 0x21543c },
	{ 0xadda, 0x21543d },
	{ 0xaddb, 0x21543e },
	{ 0xaddc, 0x21543f },
	{ 0xaddd, 0x215440 },
	{ 0xadde, 0x215441 },
	{ 0xaddf, 0x215442 },
	{ 0xade0, 0x215443 },
	{ 0xade1, 0x215444 },
	{ 0xade2, 0x215445 },
	{ 0xade3, 0x215446 },
	{ 0xade4, 0x215447 },
	{ 0xade5, 0x215448 },
	{ 0xade6, 0x215449 },
	{ 0xade7, 0x21544a },
	{ 0xade8, 0x21544b },
	{ 0xade9, 0x21544c },
	{ 0xadea, 0x21544d },
	{ 0xadeb, 0x21544e },
	{ 0xadec, 0x21544f },
	{ 0xaded, 0x215450 },
	{ 0xadee, 0x215451 },
	{ 0xadef, 0x215452 },
	{ 0xadf0, 0x215453 },
	{ 0xadf1, 0x215454 },
	{ 0xadf2, 0x215455 },
	{ 0xadf3, 0x215456 },
	{ 0xadf4, 0x215457 },
	{ 0xadf5, 0x215458 },
	{ 0xadf6, 0x215459 },
	{ 0xadf7, 0x21545a },
	{ 0xadf8, 0x21545b },
	{ 0xadf9, 0x21545c },
	{ 0xadfa, 0x21545d },
	{ 0xadfb, 0x21545e },
	{ 0xadfc, 0x21545f },
	{ 0xadfd, 0x215460 },
	{ 0xadfe, 0x215461 },
	{ 0xae40, 0x215462 },
	{ 0xae41, 0x215463 },
	{ 0xae42, 0x215464 },
	{ 0xae43, 0x215465 },
	{ 0xae44, 0x215466 },
	{ 0xae45, 0x215467 },
	{ 0xae46, 0x215468 },
	{ 0xae47, 0x215469 },
	{ 0xae48, 0x21546a },
	{ 0xae49, 0x21546b },
	{ 0xae4a, 0x21546c },
	{ 0xae4b, 0x21546d },
	{ 0xae4c, 0x21546e },
	{ 0xae4d, 0x21546f },
	{ 0xae4e, 0x215470 },
	{ 0xae4f, 0x215471 },
	{ 0xae50, 0x215472 },
	{ 0xae51, 0x215473 },
	{ 0xae52, 0x215474 },
	{ 0xae53, 0x215475 },
	{ 0xae54, 0x215476 },
	{ 0xae55, 0x215477 },
	{ 0xae56, 0x215478 },
	{ 0xae57, 0x215479 },
	{ 0xae58, 0x21547a },
	{ 0xae59, 0x21547b },
	{ 0xae5a, 0x21547c },
	{ 0xae5b, 0x21547d },
	{ 0xae5c, 0x21547e },
	{ 0xae5d, 0x215521 },
	{ 0xae5e, 0x215522 },
	{ 0xae5f, 0x215523 },
	{ 0xae60, 0x215524 },
	{ 0xae61, 0x215525 },
	{ 0xae62, 0x215526 },
	{ 0xae63, 0x215527 },
	{ 0xae64, 0x215528 },
	{ 0xae65, 0x215529 },
	{ 0xae66, 0x21552a },
	{ 0xae67, 0x21552b },
	{ 0xae68, 0x21552c },
	{ 0xae69, 0x21552d },
	{ 0xae6a, 0x21552e },
	{ 0xae6b, 0x21552f },
	{ 0xae6c, 0x215530 },
	{ 0xae6d, 0x215531 },
	{ 0xae6e, 0x215532 },
	{ 0xae6f, 0x215533 },
	{ 0xae70, 0x215534 },
	{ 0xae71, 0x215535 },
	{ 0xae72, 0x215536 },
	{ 0xae73, 0x215537 },
	{ 0xae74, 0x215538 },
	{ 0xae75, 0x215539 },
	{ 0xae76, 0x21553a },
	{ 0xae77, 0x21553b },
	{ 0xae78, 0x21553c },
	{ 0xae79, 0x21553d },
	{ 0xae7a, 0x21553e },
	{ 0xae7b, 0x21553f },
	{ 0xae7c, 0x215540 },
	{ 0xae7d, 0x215541 },
	{ 0xae7e, 0x215542 },
	{ 0xaea1, 0x215543 },
	{ 0xaea2, 0x215544 },
	{ 0xaea3, 0x215545 },
	{ 0xaea4, 0x215546 },
	{ 0xaea5, 0x215547 },
	{ 0xaea6, 0x215548 },
	{ 0xaea7, 0x215549 },
	{ 0xaea8, 0x21554a },
	{ 0xaea9, 0x21554b },
	{ 0xaeaa, 0x21554c },
	{ 0xaeab, 0x21554d },
	{ 0xaeac, 0x21554e },
	{ 0xaead, 0x21554f },
	{ 0xaeae, 0x215550 },
	{ 0xaeaf, 0x215551 },
	{ 0xaeb0, 0x215552 },
	{ 0xaeb1, 0x215553 },
	{ 0xaeb2, 0x215554 },
	{ 0xaeb3, 0x215555 },
	{ 0xaeb4, 0x215556 },
	{ 0xaeb5, 0x215557 },
	{ 0xaeb6, 0x215558 },
	{ 0xaeb7, 0x215559 },
	{ 0xaeb8, 0x21555a },
	{ 0xaeb9, 0x21555b },
	{ 0xaeba, 0x21555c },
	{ 0xaebb, 0x21555d },
	{ 0xaebc, 0x21555e },
	{ 0xaebd, 0x21555f },
	{ 0xaebe, 0x215560 },
	{ 0xaebf, 0x215561 },
	{ 0xaec0, 0x215562 },
	{ 0xaec1, 0x215563 },
	{ 0xaec2, 0x215564 },
	{ 0xaec3, 0x215565 },
	{ 0xaec4, 0x215566 },
	{ 0xaec5, 0x215567 },
	{ 0xaec6, 0x215568 },
	{ 0xaec7, 0x215569 },
	{ 0xaec8, 0x21556a },
	{ 0xaec9, 0x21556b },
	{ 0xaeca, 0x21556c },
	{ 0xaecb, 0x21556d },
	{ 0xaecc, 0x21556e },
	{ 0xaecd, 0x21556f },
	{ 0xaece, 0x215570 },
	{ 0xaecf, 0x215571 },
	{ 0xaed0, 0x215572 },
	{ 0xaed1, 0x215573 },
	{ 0xaed2, 0x215574 },
	{ 0xaed3, 0x215575 },
	{ 0xaed4, 0x215576 },
	{ 0xaed5, 0x215577 },
	{ 0xaed6, 0x215578 },
	{ 0xaed7, 0x215579 },
	{ 0xaed8, 0x21557a },
	{ 0xaed9, 0x21557b },
	{ 0xaeda, 0x21557c },
	{ 0xaedb, 0x21557d },
	{ 0xaedc, 0x21557e },
	{ 0xaedd, 0x215621 },
	{ 0xaede, 0x215622 },
	{ 0xaedf, 0x215623 },
	{ 0xaee0, 0x215624 },
	{ 0xaee1, 0x215625 },
	{ 0xaee2, 0x215626 },
	{ 0xaee3, 0x215627 },
	{ 0xaee4, 0x215628 },
	{ 0xaee5, 0x215629 },
	{ 0xaee6, 0x21562a },
	{ 0xaee7, 0x21562b },
	{ 0xaee8, 0x21562c },
	{ 0xaee9, 0x21562d },
	{ 0xaeea, 0x21562e },
	{ 0xaeeb, 0x21562f },
	{ 0xaeec, 0x215630 },
	{ 0xaeed, 0x215631 },
	{ 0xaeee, 0x215632 },
	{ 0xaeef, 0x215633 },
	{ 0xaef0, 0x215634 },
	{ 0xaef1, 0x215635 },
	{ 0xaef2, 0x215636 },
	{ 0xaef3, 0x215637 },
	{ 0xaef4, 0x215638 },
	{ 0xaef5, 0x215639 },
	{ 0xaef6, 0x21563a },
	{ 0xaef7, 0x21563b },
	{ 0xaef8, 0x21563c },
	{ 0xaef9, 0x21563d },
	{ 0xaefa, 0x21563e },
	{ 0xaefb, 0x21563f },
	{ 0xaefc, 0x215640 },
	{ 0xaefd, 0x215641 },
	{ 0xaefe, 0x215642 },
	{ 0xaf40, 0x215643 },
	{ 0xaf41, 0x215644 },
	{ 0xaf42, 0x215645 },
	{ 0xaf43, 0x215646 },
	{ 0xaf44, 0x215647 },
	{ 0xaf45, 0x215648 },
	{ 0xaf46, 0x215649 },
	{ 0xaf47, 0x21564a },
	{ 0xaf48, 0x21564b },
	{ 0xaf49, 0x21564c },
	{ 0xaf4a, 0x21564d },
	{ 0xaf4b, 0x21564e },
	{ 0xaf4c, 0x21564f },
	{ 0xaf4d, 0x215650 },
	{ 0xaf4e, 0x215651 },
	{ 0xaf4f, 0x215652 },
	{ 0xaf50, 0x215653 },
	{ 0xaf51, 0x215654 },
	{ 0xaf52, 0x215655 },
	{ 0xaf53, 0x215656 },
	{ 0xaf54, 0x215657 },
	{ 0xaf55, 0x215658 },
	{ 0xaf56, 0x215659 },
	{ 0xaf57, 0x21565a },
	{ 0xaf58, 0x21565b },
	{ 0xaf59, 0x21565c },
	{ 0xaf5a, 0x21565d },
	{ 0xaf5b, 0x21565e },
	{ 0xaf5c, 0x21565f },
	{ 0xaf5d, 0x215660 },
	{ 0xaf5e, 0x215661 },
	{ 0xaf5f, 0x215662 },
	{ 0xaf60, 0x215663 },
	{ 0xaf61, 0x215664 },
	{ 0xaf62, 0x215665 },
	{ 0xaf63, 0x215666 },
	{ 0xaf64, 0x215667 },
	{ 0xaf65, 0x215668 },
	{ 0xaf66, 0x215669 },
	{ 0xaf67, 0x21566a },
	{ 0xaf68, 0x21566b },
	{ 0xaf69, 0x21566c },
	{ 0xaf6a, 0x21566d },
	{ 0xaf6b, 0x21566e },
	{ 0xaf6c, 0x21566f },
	{ 0xaf6d, 0x215670 },
	{ 0xaf6e, 0x215671 },
	{ 0xaf6f, 0x215672 },
	{ 0xaf70, 0x215673 },
	{ 0xaf71, 0x215674 },
	{ 0xaf72, 0x215675 },
	{ 0xaf73, 0x215676 },
	{ 0xaf74, 0x215677 },
	{ 0xaf75, 0x215678 },
	{ 0xaf76, 0x215679 },
	{ 0xaf77, 0x21567a },
	{ 0xaf78, 0x21567b },
	{ 0xaf79, 0x21567c },
	{ 0xaf7a, 0x21567d },
	{ 0xaf7b, 0x21567e },
	{ 0xaf7c, 0x215721 },
	{ 0xaf7d, 0x215722 },
	{ 0xaf7e, 0x215723 },
	{ 0xafa1, 0x215724 },
	{ 0xafa2, 0x215725 },
	{ 0xafa3, 0x215726 },
	{ 0xafa4, 0x215727 },
	{ 0xafa5, 0x215728 },
	{ 0xafa6, 0x215729 },
	{ 0xafa7, 0x21572a },
	{ 0xafa8, 0x21572b },
	{ 0xafa9, 0x21572c },
	{ 0xafaa, 0x21572d },
	{ 0xafab, 0x21572e },
	{ 0xafac, 0x21572f },
	{ 0xafad, 0x215730 },
	{ 0xafae, 0x215731 },
	{ 0xafaf, 0x215732 },
	{ 0xafb0, 0x215733 },
	{ 0xafb1, 0x215734 },
	{ 0xafb2, 0x215735 },
	{ 0xafb3, 0x215736 },
	{ 0xafb4, 0x215737 },
	{ 0xafb5, 0x215738 },
	{ 0xafb6, 0x215739 },
	{ 0xafb7, 0x21573a },
	{ 0xafb8, 0x21573b },
	{ 0xafb9, 0x21573c },
	{ 0xafba, 0x21573d },
	{ 0xafbb, 0x21573e },
	{ 0xafbc, 0x21573f },
	{ 0xafbd, 0x215740 },
	{ 0xafbe, 0x215741 },
	{ 0xafbf, 0x215742 },
	{ 0xafc0, 0x215743 },
	{ 0xafc1, 0x215744 },
	{ 0xafc2, 0x215745 },
	{ 0xafc3, 0x215746 },
	{ 0xafc4, 0x215747 },
	{ 0xafc5, 0x215748 },
	{ 0xafc6, 0x215749 },
	{ 0xafc7, 0x21574a },
	{ 0xafc8, 0x21574b },
	{ 0xafc9, 0x21574c },
	{ 0xafca, 0x21574d },
	{ 0xafcb, 0x21574e },
	{ 0xafcc, 0x21574f },
	{ 0xafcd, 0x215750 },
	{ 0xafce, 0x215751 },
	{ 0xafcf, 0x215752 },
	{ 0xafd0, 0x215754 },
	{ 0xafd1, 0x215755 },
	{ 0xafd2, 0x215756 },
	{ 0xafd3, 0x215757 },
	{ 0xafd4, 0x215758 },
	{ 0xafd5, 0x215759 },
	{ 0xafd6, 0x21575a },
	{ 0xafd7, 0x21575b },
	{ 0xafd8, 0x21575c },
	{ 0xafd9, 0x21575d },
	{ 0xafda, 0x21575e },
	{ 0xafdb, 0x21575f },
	{ 0xafdc, 0x215760 },
	{ 0xafdd, 0x215761 },
	{ 0xafde, 0x215762 },
	{ 0xafdf, 0x215763 },
	{ 0xafe0, 0x215764 },
	{ 0xafe1, 0x215765 },
	{ 0xafe2, 0x215766 },
	{ 0xafe3, 0x215767 },
	{ 0xafe4, 0x215768 },
	{ 0xafe5, 0x215769 },
	{ 0xafe6, 0x21576a },
	{ 0xafe7, 0x21576b },
	{ 0xafe8, 0x21576c },
	{ 0xafe9, 0x21576d },
	{ 0xafea, 0x21576e },
	{ 0xafeb, 0x21576f },
	{ 0xafec, 0x215770 },
	{ 0xafed, 0x215771 },
	{ 0xafee, 0x215772 },
	{ 0xafef, 0x215773 },
	{ 0xaff0, 0x215774 },
	{ 0xaff1, 0x215775 },
	{ 0xaff2, 0x215776 },
	{ 0xaff3, 0x215777 },
	{ 0xaff4, 0x215778 },
	{ 0xaff5, 0x215779 },
	{ 0xaff6, 0x21577a },
	{ 0xaff7, 0x21577b },
	{ 0xaff8, 0x21577c },
	{ 0xaff9, 0x21577d },
	{ 0xaffa, 0x21577e },
	{ 0xaffb, 0x215821 },
	{ 0xaffc, 0x215822 },
	{ 0xaffd, 0x215823 },
	{ 0xaffe, 0x215824 },
	{ 0xb040, 0x215825 },
	{ 0xb041, 0x215826 },
	{ 0xb042, 0x215827 },
	{ 0xb043, 0x215828 },
	{ 0xb044, 0x215829 },
	{ 0xb045, 0x21582a },
	{ 0xb046, 0x21582b },
	{ 0xb047, 0x21582c },
	{ 0xb048, 0x21582d },
	{ 0xb049, 0x21582e },
	{ 0xb04a, 0x21582f },
	{ 0xb04b, 0x215830 },
	{ 0xb04c, 0x215831 },
	{ 0xb04d, 0x215832 },
	{ 0xb04e, 0x215833 },
	{ 0xb04f, 0x215834 },
	{ 0xb050, 0x215835 },
	{ 0xb051, 0x215836 },
	{ 0xb052, 0x215837 },
	{ 0xb053, 0x215838 },
	{ 0xb054, 0x215839 },
	{ 0xb055, 0x21583a },
	{ 0xb056, 0x21583b },
	{ 0xb057, 0x21583c },
	{ 0xb058, 0x21583d },
	{ 0xb059, 0x21583e },
	{ 0xb05a, 0x21583f },
	{ 0xb05b, 0x215840 },
	{ 0xb05c, 0x215841 },
	{ 0xb05d, 0x215842 },
	{ 0xb05e, 0x215843 },
	{ 0xb05f, 0x215844 },
	{ 0xb060, 0x215845 },
	{ 0xb061, 0x215846 },
	{ 0xb062, 0x215847 },
	{ 0xb063, 0x215848 },
	{ 0xb064, 0x215849 },
	{ 0xb065, 0x21584a },
	{ 0xb066, 0x21584b },
	{ 0xb067, 0x21584c },
	{ 0xb068, 0x21584d },
	{ 0xb069, 0x21584e },
	{ 0xb06a, 0x21584f },
	{ 0xb06b, 0x215850 },
	{ 0xb06c, 0x215851 },
	{ 0xb06d, 0x215852 },
	{ 0xb06e, 0x215853 },
	{ 0xb06f, 0x215854 },
	{ 0xb070, 0x215855 },
	{ 0xb071, 0x215856 },
	{ 0xb072, 0x215857 },
	{ 0xb073, 0x215858 },
	{ 0xb074, 0x215859 },
	{ 0xb075, 0x21585a },
	{ 0xb076, 0x21585b },
	{ 0xb077, 0x21585c },
	{ 0xb078, 0x21585d },
	{ 0xb079, 0x21585e },
	{ 0xb07a, 0x21585f },
	{ 0xb07b, 0x215860 },
	{ 0xb07c, 0x215861 },
	{ 0xb07d, 0x215862 },
	{ 0xb07e, 0x215863 },
	{ 0xb0a1, 0x215864 },
	{ 0xb0a2, 0x215865 },
	{ 0xb0a3, 0x215866 },
	{ 0xb0a4, 0x215867 },
	{ 0xb0a5, 0x215868 },
	{ 0xb0a6, 0x215869 },
	{ 0xb0a7, 0x21586a },
	{ 0xb0a8, 0x21586b },
	{ 0xb0a9, 0x21586c },
	{ 0xb0aa, 0x21586d },
	{ 0xb0ab, 0x21586e },
	{ 0xb0ac, 0x21586f },
	{ 0xb0ad, 0x215870 },
	{ 0xb0ae, 0x215871 },
	{ 0xb0af, 0x215872 },
	{ 0xb0b0, 0x215873 },
	{ 0xb0b1, 0x215874 },
	{ 0xb0b2, 0x215875 },
	{ 0xb0b3, 0x215876 },
	{ 0xb0b4, 0x215877 },
	{ 0xb0b5, 0x215878 },
	{ 0xb0b6, 0x215879 },
	{ 0xb0b7, 0x21587a },
	{ 0xb0b8, 0x21587b },
	{ 0xb0b9, 0x21587c },
	{ 0xb0ba, 0x21587d },
	{ 0xb0bb, 0x21587e },
	{ 0xb0bc, 0x215921 },
	{ 0xb0bd, 0x215922 },
	{ 0xb0be, 0x215923 },
	{ 0xb0bf, 0x215924 },
	{ 0xb0c0, 0x215925 },
	{ 0xb0c1, 0x215926 },
	{ 0xb0c2, 0x215927 },
	{ 0xb0c3, 0x215928 },
	{ 0xb0c4, 0x215929 },
	{ 0xb0c5, 0x21592a },
	{ 0xb0c6, 0x21592b },
	{ 0xb0c7, 0x21592c },
	{ 0xb0c8, 0x21592d },
	{ 0xb0c9, 0x21592e },
	{ 0xb0ca, 0x21592f },
	{ 0xb0cb, 0x215930 },
	{ 0xb0cc, 0x215931 },
	{ 0xb0cd, 0x215932 },
	{ 0xb0ce, 0x215933 },
	{ 0xb0cf, 0x215934 },
	{ 0xb0d0, 0x215935 },
	{ 0xb0d1, 0x215936 },
	{ 0xb0d2, 0x215937 },
	{ 0xb0d3, 0x215938 },
	{ 0xb0d4, 0x215939 },
	{ 0xb0d5, 0x21593a },
	{ 0xb0d6, 0x21593b },
	{ 0xb0d7, 0x21593c },
	{ 0xb0d8, 0x21593d },
	{ 0xb0d9, 0x21593e },
	{ 0xb0da, 0x21593f },
	{ 0xb0db, 0x215940 },
	{ 0xb0dc, 0x215941 },
	{ 0xb0dd, 0x215942 },
	{ 0xb0de, 0x215943 },
	{ 0xb0df, 0x215944 },
	{ 0xb0e0, 0x215945 },
	{ 0xb0e1, 0x215946 },
	{ 0xb0e2, 0x215947 },
	{ 0xb0e3, 0x215948 },
	{ 0xb0e4, 0x215949 },
	{ 0xb0e5, 0x21594a },
	{ 0xb0e6, 0x21594b },
	{ 0xb0e7, 0x21594c },
	{ 0xb0e8, 0x21594d },
	{ 0xb0e9, 0x21594e },
	{ 0xb0ea, 0x21594f },
	{ 0xb0eb, 0x215950 },
	{ 0xb0ec, 0x215951 },
	{ 0xb0ed, 0x215952 },
	{ 0xb0ee, 0x215953 },
	{ 0xb0ef, 0x215954 },
	{ 0xb0f0, 0x215955 },
	{ 0xb0f1, 0x215956 },
	{ 0xb0f2, 0x215957 },
	{ 0xb0f3, 0x215958 },
	{ 0xb0f4, 0x215959 },
	{ 0xb0f5, 0x21595a },
	{ 0xb0f6, 0x21595b },
	{ 0xb0f7, 0x21595c },
	{ 0xb0f8, 0x21595d },
	{ 0xb0f9, 0x21595e },
	{ 0xb0fa, 0x21595f },
	{ 0xb0fb, 0x215960 },
	{ 0xb0fc, 0x215961 },
	{ 0xb0fd, 0x215962 },
	{ 0xb0fe, 0x215963 },
	{ 0xb140, 0x215964 },
	{ 0xb141, 0x215965 },
	{ 0xb142, 0x215966 },
	{ 0xb143, 0x215967 },
	{ 0xb144, 0x215968 },
	{ 0xb145, 0x215969 },
	{ 0xb146, 0x21596a },
	{ 0xb147, 0x21596b },
	{ 0xb148, 0x21596c },
	{ 0xb149, 0x21596d },
	{ 0xb14a, 0x21596e },
	{ 0xb14b, 0x21596f },
	{ 0xb14c, 0x215970 },
	{ 0xb14d, 0x215971 },
	{ 0xb14e, 0x215972 },
	{ 0xb14f, 0x215973 },
	{ 0xb150, 0x215974 },
	{ 0xb151, 0x215975 },
	{ 0xb152, 0x215976 },
	{ 0xb153, 0x215977 },
	{ 0xb154, 0x215978 },
	{ 0xb155, 0x215979 },
	{ 0xb156, 0x21597a },
	{ 0xb157, 0x21597b },
	{ 0xb158, 0x21597c },
	{ 0xb159, 0x21597d },
	{ 0xb15a, 0x21597e },
	{ 0xb15b, 0x215a21 },
	{ 0xb15c, 0x215a22 },
	{ 0xb15d, 0x215a23 },
	{ 0xb15e, 0x215a24 },
	{ 0xb15f, 0x215a25 },
	{ 0xb160, 0x215a26 },
	{ 0xb161, 0x215a27 },
	{ 0xb162, 0x215a28 },
	{ 0xb163, 0x215a29 },
	{ 0xb164, 0x215a2a },
	{ 0xb165, 0x215a2b },
	{ 0xb166, 0x215a2c },
	{ 0xb167, 0x215a2d },
	{ 0xb168, 0x215a2e },
	{ 0xb169, 0x215a2f },
	{ 0xb16a, 0x215a30 },
	{ 0xb16b, 0x215a31 },
	{ 0xb16c, 0x215a32 },
	{ 0xb16d, 0x215a33 },
	{ 0xb16e, 0x215a34 },
	{ 0xb16f, 0x215a35 },
	{ 0xb170, 0x215a36 },
	{ 0xb171, 0x215a37 },
	{ 0xb172, 0x215a38 },
	{ 0xb173, 0x215a39 },
	{ 0xb174, 0x215a3a },
	{ 0xb175, 0x215a3b },
	{ 0xb176, 0x215a3c },
	{ 0xb177, 0x215a3d },
	{ 0xb178, 0x215a3e },
	{ 0xb179, 0x215a3f },
	{ 0xb17a, 0x215a40 },
	{ 0xb17b, 0x215a41 },
	{ 0xb17c, 0x215a42 },
	{ 0xb17d, 0x215a43 },
	{ 0xb17e, 0x215a44 },
	{ 0xb1a1, 0x215a45 },
	{ 0xb1a2, 0x215a46 },
	{ 0xb1a3, 0x215a47 },
	{ 0xb1a4, 0x215a48 },
	{ 0xb1a5, 0x215a49 },
	{ 0xb1a6, 0x215a4a },
	{ 0xb1a7, 0x215a4b },
	{ 0xb1a8, 0x215a4c },
	{ 0xb1a9, 0x215a4d },
	{ 0xb1aa, 0x215a4e },
	{ 0xb1ab, 0x215a4f },
	{ 0xb1ac, 0x215a50 },
	{ 0xb1ad, 0x215a51 },
	{ 0xb1ae, 0x215a52 },
	{ 0xb1af, 0x215a53 },
	{ 0xb1b0, 0x215a54 },
	{ 0xb1b1, 0x215a55 },
	{ 0xb1b2, 0x215a56 },
	{ 0xb1b3, 0x215a57 },
	{ 0xb1b4, 0x215a58 },
	{ 0xb1b5, 0x215a59 },
	{ 0xb1b6, 0x215a5a },
	{ 0xb1b7, 0x215a5b },
	{ 0xb1b8, 0x215a5c },
	{ 0xb1b9, 0x215a5d },
	{ 0xb1ba, 0x215a5e },
	{ 0xb1bb, 0x215a5f },
	{ 0xb1bc, 0x215a60 },
	{ 0xb1bd, 0x215a61 },
	{ 0xb1be, 0x215a62 },
	{ 0xb1bf, 0x215a63 },
	{ 0xb1c0, 0x215a64 },
	{ 0xb1c1, 0x215a65 },
	{ 0xb1c2, 0x215a66 },
	{ 0xb1c3, 0x215a67 },
	{ 0xb1c4, 0x215a68 },
	{ 0xb1c5, 0x215a69 },
	{ 0xb1c6, 0x215a6a },
	{ 0xb1c7, 0x215a6b },
	{ 0xb1c8, 0x215a6c },
	{ 0xb1c9, 0x215a6d },
	{ 0xb1ca, 0x215a6e },
	{ 0xb1cb, 0x215a6f },
	{ 0xb1cc, 0x215a70 },
	{ 0xb1cd, 0x215a71 },
	{ 0xb1ce, 0x215a72 },
	{ 0xb1cf, 0x215a73 },
	{ 0xb1d0, 0x215a74 },
	{ 0xb1d1, 0x215a75 },
	{ 0xb1d2, 0x215a76 },
	{ 0xb1d3, 0x215a77 },
	{ 0xb1d4, 0x215a78 },
	{ 0xb1d5, 0x215a79 },
	{ 0xb1d6, 0x215a7a },
	{ 0xb1d7, 0x215a7b },
	{ 0xb1d8, 0x215a7c },
	{ 0xb1d9, 0x215a7d },
	{ 0xb1da, 0x215a7e },
	{ 0xb1db, 0x215b21 },
	{ 0xb1dc, 0x215b22 },
	{ 0xb1dd, 0x215b23 },
	{ 0xb1de, 0x215b24 },
	{ 0xb1df, 0x215b25 },
	{ 0xb1e0, 0x215b26 },
	{ 0xb1e1, 0x215b27 },
	{ 0xb1e2, 0x215b28 },
	{ 0xb1e3, 0x215b29 },
	{ 0xb1e4, 0x215b2a },
	{ 0xb1e5, 0x215b2b },
	{ 0xb1e6, 0x215b2c },
	{ 0xb1e7, 0x215b2d },
	{ 0xb1e8, 0x215b2e },
	{ 0xb1e9, 0x215b2f },
	{ 0xb1ea, 0x215b30 },
	{ 0xb1eb, 0x215b31 },
	{ 0xb1ec, 0x215b32 },
	{ 0xb1ed, 0x215b33 },
	{ 0xb1ee, 0x215b34 },
	{ 0xb1ef, 0x215b35 },
	{ 0xb1f0, 0x215b36 },
	{ 0xb1f1, 0x215b37 },
	{ 0xb1f2, 0x215b38 },
	{ 0xb1f3, 0x215b39 },
	{ 0xb1f4, 0x215b3a },
	{ 0xb1f5, 0x215b3b },
	{ 0xb1f6, 0x215b3c },
	{ 0xb1f7, 0x215b3d },
	{ 0xb1f8, 0x215b3e },
	{ 0xb1f9, 0x215b3f },
	{ 0xb1fa, 0x215b40 },
	{ 0xb1fb, 0x215b41 },
	{ 0xb1fc, 0x215b42 },
	{ 0xb1fd, 0x215b43 },
	{ 0xb1fe, 0x215b44 },
	{ 0xb240, 0x215b45 },
	{ 0xb241, 0x215b46 },
	{ 0xb242, 0x215b47 },
	{ 0xb243, 0x215b48 },
	{ 0xb244, 0x215b49 },
	{ 0xb245, 0x215b4a },
	{ 0xb246, 0x215b4b },
	{ 0xb247, 0x215b4c },
	{ 0xb248, 0x215b4d },
	{ 0xb249, 0x215b4e },
	{ 0xb24a, 0x215b4f },
	{ 0xb24b, 0x215b50 },
	{ 0xb24c, 0x215b51 },
	{ 0xb24d, 0x215b52 },
	{ 0xb24e, 0x215b53 },
	{ 0xb24f, 0x215b54 },
	{ 0xb250, 0x215b55 },
	{ 0xb251, 0x215b56 },
	{ 0xb252, 0x215b57 },
	{ 0xb253, 0x215b58 },
	{ 0xb254, 0x215b59 },
	{ 0xb255, 0x215b5a },
	{ 0xb256, 0x215b5b },
	{ 0xb257, 0x215b5c },
	{ 0xb258, 0x215b5d },
	{ 0xb259, 0x215b5e },
	{ 0xb25a, 0x215b5f },
	{ 0xb25b, 0x215b60 },
	{ 0xb25c, 0x215b61 },
	{ 0xb25d, 0x215b62 },
	{ 0xb25e, 0x215b63 },
	{ 0xb25f, 0x215b64 },
	{ 0xb260, 0x215b65 },
	{ 0xb261, 0x215b66 },
	{ 0xb262, 0x215b67 },
	{ 0xb263, 0x215b68 },
	{ 0xb264, 0x215b69 },
	{ 0xb265, 0x215b6a },
	{ 0xb266, 0x215b6b },
	{ 0xb267, 0x215b6c },
	{ 0xb268, 0x215b6d },
	{ 0xb269, 0x215b6e },
	{ 0xb26a, 0x215b6f },
	{ 0xb26b, 0x215b70 },
	{ 0xb26c, 0x215b71 },
	{ 0xb26d, 0x215b72 },
	{ 0xb26e, 0x215b73 },
	{ 0xb26f, 0x215b74 },
	{ 0xb270, 0x215b75 },
	{ 0xb271, 0x215b76 },
	{ 0xb272, 0x215b77 },
	{ 0xb273, 0x215b78 },
	{ 0xb274, 0x215b79 },
	{ 0xb275, 0x215b7a },
	{ 0xb276, 0x215b7b },
	{ 0xb277, 0x215b7c },
	{ 0xb278, 0x215b7d },
	{ 0xb279, 0x215b7e },
	{ 0xb27a, 0x215c21 },
	{ 0xb27b, 0x215c22 },
	{ 0xb27c, 0x215c23 },
	{ 0xb27d, 0x215c24 },
	{ 0xb27e, 0x215c25 },
	{ 0xb2a1, 0x215c26 },
	{ 0xb2a2, 0x215c27 },
	{ 0xb2a3, 0x215c28 },
	{ 0xb2a4, 0x215c29 },
	{ 0xb2a5, 0x215c2a },
	{ 0xb2a6, 0x215c2b },
	{ 0xb2a7, 0x215c2c },
	{ 0xb2a8, 0x215c2d },
	{ 0xb2a9, 0x215c2e },
	{ 0xb2aa, 0x215c2f },
	{ 0xb2ab, 0x215c30 },
	{ 0xb2ac, 0x215c31 },
	{ 0xb2ad, 0x215c32 },
	{ 0xb2ae, 0x215c33 },
	{ 0xb2af, 0x215c34 },
	{ 0xb2b0, 0x215c35 },
	{ 0xb2b1, 0x215c36 },
	{ 0xb2b2, 0x215c37 },
	{ 0xb2b3, 0x215c38 },
	{ 0xb2b4, 0x215c39 },
	{ 0xb2b5, 0x215c3a },
	{ 0xb2b6, 0x215c3b },
	{ 0xb2b7, 0x215c3c },
	{ 0xb2b8, 0x215c3d },
	{ 0xb2b9, 0x215c3e },
	{ 0xb2ba, 0x215c3f },
	{ 0xb2bb, 0x215c40 },
	{ 0xb2bc, 0x215c41 },
	{ 0xb2bd, 0x215c42 },
	{ 0xb2be, 0x215c43 },
	{ 0xb2bf, 0x215c44 },
	{ 0xb2c0, 0x215c45 },
	{ 0xb2c1, 0x215c46 },
	{ 0xb2c2, 0x215c47 },
	{ 0xb2c3, 0x215c48 },
	{ 0xb2c4, 0x215c49 },
	{ 0xb2c5, 0x215c4a },
	{ 0xb2c6, 0x215c4b },
	{ 0xb2c7, 0x215c4c },
	{ 0xb2c8, 0x215c4d },
	{ 0xb2c9, 0x215c4e },
	{ 0xb2ca, 0x215c4f },
	{ 0xb2cb, 0x215c50 },
	{ 0xb2cc, 0x215c51 },
	{ 0xb2cd, 0x215c52 },
	{ 0xb2ce, 0x215c53 },
	{ 0xb2cf, 0x215c54 },
	{ 0xb2d0, 0x215c55 },
	{ 0xb2d1, 0x215c56 },
	{ 0xb2d2, 0x215c57 },
	{ 0xb2d3, 0x215c58 },
	{ 0xb2d4, 0x215c59 },
	{ 0xb2d5, 0x215c5a },
	{ 0xb2d6, 0x215c5b },
	{ 0xb2d7, 0x215c5c },
	{ 0xb2d8, 0x215c5d },
	{ 0xb2d9, 0x215c5e },
	{ 0xb2da, 0x215c5f },
	{ 0xb2db, 0x215c60 },
	{ 0xb2dc, 0x215c61 },
	{ 0xb2dd, 0x215c62 },
	{ 0xb2de, 0x215c63 },
	{ 0xb2df, 0x215c64 },
	{ 0xb2e0, 0x215c65 },
	{ 0xb2e1, 0x215c66 },
	{ 0xb2e2, 0x215c67 },
	{ 0xb2e3, 0x215c68 },
	{ 0xb2e4, 0x215c69 },
	{ 0xb2e5, 0x215c6a },
	{ 0xb2e6, 0x215c6b },
	{ 0xb2e7, 0x215c6c },
	{ 0xb2e8, 0x215c6d },
	{ 0xb2e9, 0x215c6e },
	{ 0xb2ea, 0x215c6f },
	{ 0xb2eb, 0x215c70 },
	{ 0xb2ec, 0x215c71 },
	{ 0xb2ed, 0x215c72 },
	{ 0xb2ee, 0x215c73 },
	{ 0xb2ef, 0x215c74 },
	{ 0xb2f0, 0x215c75 },
	{ 0xb2f1, 0x215c76 },
	{ 0xb2f2, 0x215c77 },
	{ 0xb2f3, 0x215c78 },
	{ 0xb2f4, 0x215c79 },
	{ 0xb2f5, 0x215c7a },
	{ 0xb2f6, 0x215c7b },
	{ 0xb2f7, 0x215c7c },
	{ 0xb2f8, 0x215c7d },
	{ 0xb2f9, 0x215c7e },
	{ 0xb2fa, 0x215d21 },
	{ 0xb2fb, 0x215d22 },
	{ 0xb2fc, 0x215d23 },
	{ 0xb2fd, 0x215d24 },
	{ 0xb2fe, 0x215d25 },
	{ 0xb340, 0x215d26 },
	{ 0xb341, 0x215d27 },
	{ 0xb342, 0x215d28 },
	{ 0xb343, 0x215d29 },
	{ 0xb344, 0x215d2a },
	{ 0xb345, 0x215d2b },
	{ 0xb346, 0x215d2c },
	{ 0xb347, 0x215d2d },
	{ 0xb348, 0x215d2e },
	{ 0xb349, 0x215d2f },
	{ 0xb34a, 0x215d30 },
	{ 0xb34b, 0x215d31 },
	{ 0xb34c, 0x215d32 },
	{ 0xb34d, 0x215d33 },
	{ 0xb34e, 0x215d34 },
	{ 0xb34f, 0x215d35 },
	{ 0xb350, 0x215d36 },
	{ 0xb351, 0x215d37 },
	{ 0xb352, 0x215d38 },
	{ 0xb353, 0x215d39 },
	{ 0xb354, 0x215d3a },
	{ 0xb355, 0x215d3b },
	{ 0xb356, 0x215d3c },
	{ 0xb357, 0x215d3d },
	{ 0xb358, 0x215d3e },
	{ 0xb359, 0x215d3f },
	{ 0xb35a, 0x215d40 },
	{ 0xb35b, 0x215d41 },
	{ 0xb35c, 0x215d42 },
	{ 0xb35d, 0x215d43 },
	{ 0xb35e, 0x215d44 },
	{ 0xb35f, 0x215d45 },
	{ 0xb360, 0x215d46 },
	{ 0xb361, 0x215d47 },
	{ 0xb362, 0x215d48 },
	{ 0xb363, 0x215d49 },
	{ 0xb364, 0x215d4a },
	{ 0xb365, 0x215d4b },
	{ 0xb366, 0x215d4c },
	{ 0xb367, 0x215d4d },
	{ 0xb368, 0x215d4e },
	{ 0xb369, 0x215d4f },
	{ 0xb36a, 0x215d50 },
	{ 0xb36b, 0x215d51 },
	{ 0xb36c, 0x215d52 },
	{ 0xb36d, 0x215d53 },
	{ 0xb36e, 0x215d54 },
	{ 0xb36f, 0x215d55 },
	{ 0xb370, 0x215d56 },
	{ 0xb371, 0x215d57 },
	{ 0xb372, 0x215d58 },
	{ 0xb373, 0x215d59 },
	{ 0xb374, 0x215d5a },
	{ 0xb375, 0x215d5b },
	{ 0xb376, 0x215d5c },
	{ 0xb377, 0x215d5d },
	{ 0xb378, 0x215d5e },
	{ 0xb379, 0x215d5f },
	{ 0xb37a, 0x215d60 },
	{ 0xb37b, 0x215d61 },
	{ 0xb37c, 0x215d62 },
	{ 0xb37d, 0x215d63 },
	{ 0xb37e, 0x215d64 },
	{ 0xb3a1, 0x215d65 },
	{ 0xb3a2, 0x215d66 },
	{ 0xb3a3, 0x215d67 },
	{ 0xb3a4, 0x215d68 },
	{ 0xb3a5, 0x215d69 },
	{ 0xb3a6, 0x215d6a },
	{ 0xb3a7, 0x215d6b },
	{ 0xb3a8, 0x215d6c },
	{ 0xb3a9, 0x215d6d },
	{ 0xb3aa, 0x215d6e },
	{ 0xb3ab, 0x215d6f },
	{ 0xb3ac, 0x215d70 },
	{ 0xb3ad, 0x215d71 },
	{ 0xb3ae, 0x215d72 },
	{ 0xb3af, 0x215d73 },
	{ 0xb3b0, 0x215d74 },
	{ 0xb3b1, 0x215d75 },
	{ 0xb3b2, 0x215d76 },
	{ 0xb3b3, 0x215d77 },
	{ 0xb3b4, 0x215d78 },
	{ 0xb3b5, 0x215d79 },
	{ 0xb3b6, 0x215d7a },
	{ 0xb3b7, 0x215d7b },
	{ 0xb3b8, 0x215d7c },
	{ 0xb3b9, 0x215d7d },
	{ 0xb3ba, 0x215d7e },
	{ 0xb3bb, 0x215e21 },
	{ 0xb3bc, 0x215e22 },
	{ 0xb3bd, 0x215e23 },
	{ 0xb3be, 0x215e24 },
	{ 0xb3bf, 0x215e25 },
	{ 0xb3c0, 0x215e26 },
	{ 0xb3c1, 0x215e27 },
	{ 0xb3c2, 0x215e28 },
	{ 0xb3c3, 0x215e29 },
	{ 0xb3c4, 0x215e2a },
	{ 0xb3c5, 0x215e2b },
	{ 0xb3c6, 0x215e2c },
	{ 0xb3c7, 0x215e2d },
	{ 0xb3c8, 0x215e2e },
	{ 0xb3c9, 0x215e2f },
	{ 0xb3ca, 0x215e30 },
	{ 0xb3cb, 0x215e31 },
	{ 0xb3cc, 0x215e32 },
	{ 0xb3cd, 0x215e33 },
	{ 0xb3ce, 0x215e34 },
	{ 0xb3cf, 0x215e35 },
	{ 0xb3d0, 0x215e36 },
	{ 0xb3d1, 0x215e37 },
	{ 0xb3d2, 0x215e38 },
	{ 0xb3d3, 0x215e39 },
	{ 0xb3d4, 0x215e3a },
	{ 0xb3d5, 0x215e3b },
	{ 0xb3d6, 0x215e3c },
	{ 0xb3d7, 0x215e3d },
	{ 0xb3d8, 0x215e3e },
	{ 0xb3d9, 0x215e3f },
	{ 0xb3da, 0x215e40 },
	{ 0xb3db, 0x215e41 },
	{ 0xb3dc, 0x215e42 },
	{ 0xb3dd, 0x215e43 },
	{ 0xb3de, 0x215e44 },
	{ 0xb3df, 0x215e45 },
	{ 0xb3e0, 0x215e46 },
	{ 0xb3e1, 0x215e47 },
	{ 0xb3e2, 0x215e48 },
	{ 0xb3e3, 0x215e49 },
	{ 0xb3e4, 0x215e4a },
	{ 0xb3e5, 0x215e4b },
	{ 0xb3e6, 0x215e4c },
	{ 0xb3e7, 0x215e4d },
	{ 0xb3e8, 0x215e4e },
	{ 0xb3e9, 0x215e4f },
	{ 0xb3ea, 0x215e50 },
	{ 0xb3eb, 0x215e51 },
	{ 0xb3ec, 0x215e52 },
	{ 0xb3ed, 0x215e53 },
	{ 0xb3ee, 0x215e54 },
	{ 0xb3ef, 0x215e55 },
	{ 0xb3f0, 0x215e56 },
	{ 0xb3f1, 0x215e57 },
	{ 0xb3f2, 0x215e58 },
	{ 0xb3f3, 0x215e59 },
	{ 0xb3f4, 0x215e5a },
	{ 0xb3f5, 0x215e5b },
	{ 0xb3f6, 0x215e5c },
	{ 0xb3f7, 0x215e5d },
	{ 0xb3f8, 0x215e5e },
	{ 0xb3f9, 0x215e5f },
	{ 0xb3fa, 0x215e60 },
	{ 0xb3fb, 0x215e61 },
	{ 0xb3fc, 0x215e62 },
	{ 0xb3fd, 0x215e63 },
	{ 0xb3fe, 0x215e64 },
	{ 0xb440, 0x215e65 },
	{ 0xb441, 0x215e66 },
	{ 0xb442, 0x215e67 },
	{ 0xb443, 0x215e68 },
	{ 0xb444, 0x215e69 },
	{ 0xb445, 0x215e6a },
	{ 0xb446, 0x215e6b },
	{ 0xb447, 0x215e6c },
	{ 0xb448, 0x215e6d },
	{ 0xb449, 0x215e6e },
	{ 0xb44a, 0x215e6f },
	{ 0xb44b, 0x215e70 },
	{ 0xb44c, 0x215e71 },
	{ 0xb44d, 0x215e72 },
	{ 0xb44e, 0x215e73 },
	{ 0xb44f, 0x215e74 },
	{ 0xb450, 0x215e75 },
	{ 0xb451, 0x215e76 },
	{ 0xb452, 0x215e77 },
	{ 0xb453, 0x215e78 },
	{ 0xb454, 0x215e79 },
	{ 0xb455, 0x215e7a },
	{ 0xb456, 0x215e7b },
	{ 0xb457, 0x215e7c },
	{ 0xb458, 0x215e7d },
	{ 0xb459, 0x215e7e },
	{ 0xb45a, 0x215f21 },
	{ 0xb45b, 0x215f22 },
	{ 0xb45c, 0x215f23 },
	{ 0xb45d, 0x215f24 },
	{ 0xb45e, 0x215f25 },
	{ 0xb45f, 0x215f26 },
	{ 0xb460, 0x215f27 },
	{ 0xb461, 0x215f28 },
	{ 0xb462, 0x215f29 },
	{ 0xb463, 0x215f2a },
	{ 0xb464, 0x215f2b },
	{ 0xb465, 0x215f2c },
	{ 0xb466, 0x215f2d },
	{ 0xb467, 0x215f2e },
	{ 0xb468, 0x215f2f },
	{ 0xb469, 0x215f30 },
	{ 0xb46a, 0x215f31 },
	{ 0xb46b, 0x215f32 },
	{ 0xb46c, 0x215f33 },
	{ 0xb46d, 0x215f34 },
	{ 0xb46e, 0x215f35 },
	{ 0xb46f, 0x215f36 },
	{ 0xb470, 0x215f37 },
	{ 0xb471, 0x215f38 },
	{ 0xb472, 0x215f39 },
	{ 0xb473, 0x215f3a },
	{ 0xb474, 0x215f3b },
	{ 0xb475, 0x215f3c },
	{ 0xb476, 0x215f3d },
	{ 0xb477, 0x215f3e },
	{ 0xb478, 0x215f3f },
	{ 0xb479, 0x215f40 },
	{ 0xb47a, 0x215f41 },
	{ 0xb47b, 0x215f42 },
	{ 0xb47c, 0x215f43 },
	{ 0xb47d, 0x215f44 },
	{ 0xb47e, 0x215f45 },
	{ 0xb4a1, 0x215f46 },
	{ 0xb4a2, 0x215f47 },
	{ 0xb4a3, 0x215f48 },
	{ 0xb4a4, 0x215f49 },
	{ 0xb4a5, 0x215f4a },
	{ 0xb4a6, 0x215f4b },
	{ 0xb4a7, 0x215f4c },
	{ 0xb4a8, 0x215f4d },
	{ 0xb4a9, 0x215f4e },
	{ 0xb4aa, 0x215f4f },
	{ 0xb4ab, 0x215f50 },
	{ 0xb4ac, 0x215f51 },
	{ 0xb4ad, 0x215f52 },
	{ 0xb4ae, 0x215f53 },
	{ 0xb4af, 0x215f54 },
	{ 0xb4b0, 0x215f55 },
	{ 0xb4b1, 0x215f56 },
	{ 0xb4b2, 0x215f57 },
	{ 0xb4b3, 0x215f58 },
	{ 0xb4b4, 0x215f59 },
	{ 0xb4b5, 0x215f5a },
	{ 0xb4b6, 0x215f5b },
	{ 0xb4b7, 0x215f5c },
	{ 0xb4b8, 0x215f5d },
	{ 0xb4b9, 0x215f5e },
	{ 0xb4ba, 0x215f5f },
	{ 0xb4bb, 0x215f60 },
	{ 0xb4bc, 0x215f61 },
	{ 0xb4bd, 0x215f62 },
	{ 0xb4be, 0x215f63 },
	{ 0xb4bf, 0x215f64 },
	{ 0xb4c0, 0x215f65 },
	{ 0xb4c1, 0x215f66 },
	{ 0xb4c2, 0x215f67 },
	{ 0xb4c3, 0x215f68 },
	{ 0xb4c4, 0x215f69 },
	{ 0xb4c5, 0x215f6a },
	{ 0xb4c6, 0x215f6b },
	{ 0xb4c7, 0x215f6c },
	{ 0xb4c8, 0x215f6d },
	{ 0xb4c9, 0x215f6e },
	{ 0xb4ca, 0x215f6f },
	{ 0xb4cb, 0x215f70 },
	{ 0xb4cc, 0x215f71 },
	{ 0xb4cd, 0x215f72 },
	{ 0xb4ce, 0x215f73 },
	{ 0xb4cf, 0x215f74 },
	{ 0xb4d0, 0x215f75 },
	{ 0xb4d1, 0x215f76 },
	{ 0xb4d2, 0x215f77 },
	{ 0xb4d3, 0x215f78 },
	{ 0xb4d4, 0x215f79 },
	{ 0xb4d5, 0x215f7a },
	{ 0xb4d6, 0x215f7b },
	{ 0xb4d7, 0x215f7c },
	{ 0xb4d8, 0x215f7d },
	{ 0xb4d9, 0x215f7e },
	{ 0xb4da, 0x216021 },
	{ 0xb4db, 0x216022 },
	{ 0xb4dc, 0x216023 },
	{ 0xb4dd, 0x216024 },
	{ 0xb4de, 0x216025 },
	{ 0xb4df, 0x216026 },
	{ 0xb4e0, 0x216027 },
	{ 0xb4e1, 0x216028 },
	{ 0xb4e2, 0x216029 },
	{ 0xb4e3, 0x21602a },
	{ 0xb4e4, 0x21602b },
	{ 0xb4e5, 0x21602c },
	{ 0xb4e6, 0x21602d },
	{ 0xb4e7, 0x21602e },
	{ 0xb4e8, 0x21602f },
	{ 0xb4e9, 0x216030 },
	{ 0xb4ea, 0x216031 },
	{ 0xb4eb, 0x216032 },
	{ 0xb4ec, 0x216033 },
	{ 0xb4ed, 0x216034 },
	{ 0xb4ee, 0x216035 },
	{ 0xb4ef, 0x216036 },
	{ 0xb4f0, 0x216037 },
	{ 0xb4f1, 0x216038 },
	{ 0xb4f2, 0x216039 },
	{ 0xb4f3, 0x21603a },
	{ 0xb4f4, 0x21603b },
	{ 0xb4f5, 0x21603c },
	{ 0xb4f6, 0x21603d },
	{ 0xb4f7, 0x21603e },
	{ 0xb4f8, 0x21603f },
	{ 0xb4f9, 0x216040 },
	{ 0xb4fa, 0x216041 },
	{ 0xb4fb, 0x216042 },
	{ 0xb4fc, 0x216043 },
	{ 0xb4fd, 0x216044 },
	{ 0xb4fe, 0x216045 },
	{ 0xb540, 0x216046 },
	{ 0xb541, 0x216047 },
	{ 0xb542, 0x216048 },
	{ 0xb543, 0x216049 },
	{ 0xb544, 0x21604a },
	{ 0xb545, 0x21604b },
	{ 0xb546, 0x21604c },
	{ 0xb547, 0x21604d },
	{ 0xb548, 0x21604e },
	{ 0xb549, 0x21604f },
	{ 0xb54a, 0x216050 },
	{ 0xb54b, 0x216051 },
	{ 0xb54c, 0x216052 },
	{ 0xb54d, 0x216053 },
	{ 0xb54e, 0x216054 },
	{ 0xb54f, 0x216055 },
	{ 0xb550, 0x216056 },
	{ 0xb551, 0x216057 },
	{ 0xb552, 0x216058 },
	{ 0xb553, 0x216059 },
	{ 0xb554, 0x21605a },
	{ 0xb555, 0x21605b },
	{ 0xb556, 0x21605c },
	{ 0xb557, 0x21605d },
	{ 0xb558, 0x21605e },
	{ 0xb559, 0x21605f },
	{ 0xb55a, 0x216060 },
	{ 0xb55b, 0x216061 },
	{ 0xb55c, 0x216062 },
	{ 0xb55d, 0x216063 },
	{ 0xb55e, 0x216064 },
	{ 0xb55f, 0x216065 },
	{ 0xb560, 0x216066 },
	{ 0xb561, 0x216067 },
	{ 0xb562, 0x216068 },
	{ 0xb563, 0x216069 },
	{ 0xb564, 0x21606a },
	{ 0xb565, 0x21606b },
	{ 0xb566, 0x21606c },
	{ 0xb567, 0x21606d },
	{ 0xb568, 0x21606e },
	{ 0xb569, 0x21606f },
	{ 0xb56a, 0x216070 },
	{ 0xb56b, 0x216071 },
	{ 0xb56c, 0x216072 },
	{ 0xb56d, 0x216073 },
	{ 0xb56e, 0x216074 },
	{ 0xb56f, 0x216075 },
	{ 0xb570, 0x216076 },
	{ 0xb571, 0x216077 },
	{ 0xb572, 0x216078 },
	{ 0xb573, 0x216079 },
	{ 0xb574, 0x21607a },
	{ 0xb575, 0x21607b },
	{ 0xb576, 0x21607c },
	{ 0xb577, 0x21607d },
	{ 0xb578, 0x21607e },
	{ 0xb579, 0x216121 },
	{ 0xb57a, 0x216122 },
	{ 0xb57b, 0x216123 },
	{ 0xb57c, 0x216124 },
	{ 0xb57d, 0x216125 },
	{ 0xb57e, 0x216126 },
	{ 0xb5a1, 0x216127 },
	{ 0xb5a2, 0x216128 },
	{ 0xb5a3, 0x216129 },
	{ 0xb5a4, 0x21612a },
	{ 0xb5a5, 0x21612b },
	{ 0xb5a6, 0x21612c },
	{ 0xb5a7, 0x21612d },
	{ 0xb5a8, 0x21612e },
	{ 0xb5a9, 0x21612f },
	{ 0xb5aa, 0x216130 },
	{ 0xb5ab, 0x216131 },
	{ 0xb5ac, 0x216132 },
	{ 0xb5ad, 0x216133 },
	{ 0xb5ae, 0x216134 },
	{ 0xb5af, 0x216135 },
	{ 0xb5b0, 0x216136 },
	{ 0xb5b1, 0x216137 },
	{ 0xb5b2, 0x216138 },
	{ 0xb5b3, 0x216139 },
	{ 0xb5b4, 0x21613a },
	{ 0xb5b5, 0x21613b },
	{ 0xb5b6, 0x21613c },
	{ 0xb5b7, 0x21613d },
	{ 0xb5b8, 0x21613e },
	{ 0xb5b9, 0x21613f },
	{ 0xb5ba, 0x216140 },
	{ 0xb5bb, 0x216141 },
	{ 0xb5bc, 0x216142 },
	{ 0xb5bd, 0x216143 },
	{ 0xb5be, 0x216144 },
	{ 0xb5bf, 0x216145 },
	{ 0xb5c0, 0x216146 },
	{ 0xb5c1, 0x216147 },
	{ 0xb5c2, 0x216148 },
	{ 0xb5c3, 0x216149 },
	{ 0xb5c4, 0x21614a },
	{ 0xb5c5, 0x21614b },
	{ 0xb5c6, 0x21614c },
	{ 0xb5c7, 0x21614d },
	{ 0xb5c8, 0x21614e },
	{ 0xb5c9, 0x21614f },
	{ 0xb5ca, 0x216150 },
	{ 0xb5cb, 0x216151 },
	{ 0xb5cc, 0x216152 },
	{ 0xb5cd, 0x216153 },
	{ 0xb5ce, 0x216154 },
	{ 0xb5cf, 0x216155 },
	{ 0xb5d0, 0x216156 },
	{ 0xb5d1, 0x216157 },
	{ 0xb5d2, 0x216158 },
	{ 0xb5d3, 0x216159 },
	{ 0xb5d4, 0x21615a },
	{ 0xb5d5, 0x21615b },
	{ 0xb5d6, 0x21615c },
	{ 0xb5d7, 0x21615d },
	{ 0xb5d8, 0x21615e },
	{ 0xb5d9, 0x21615f },
	{ 0xb5da, 0x216160 },
	{ 0xb5db, 0x216161 },
	{ 0xb5dc, 0x216162 },
	{ 0xb5dd, 0x216163 },
	{ 0xb5de, 0x216164 },
	{ 0xb5df, 0x216165 },
	{ 0xb5e0, 0x216166 },
	{ 0xb5e1, 0x216167 },
	{ 0xb5e2, 0x216168 },
	{ 0xb5e3, 0x216169 },
	{ 0xb5e4, 0x21616a },
	{ 0xb5e5, 0x21616b },
	{ 0xb5e6, 0x21616c },
	{ 0xb5e7, 0x21616d },
	{ 0xb5e8, 0x21616e },
	{ 0xb5e9, 0x21616f },
	{ 0xb5ea, 0x216170 },
	{ 0xb5eb, 0x216171 },
	{ 0xb5ec, 0x216172 },
	{ 0xb5ed, 0x216173 },
	{ 0xb5ee, 0x216174 },
	{ 0xb5ef, 0x216175 },
	{ 0xb5f0, 0x216176 },
	{ 0xb5f1, 0x216177 },
	{ 0xb5f2, 0x216178 },
	{ 0xb5f3, 0x216179 },
	{ 0xb5f4, 0x21617a },
	{ 0xb5f5, 0x21617b },
	{ 0xb5f6, 0x21617c },
	{ 0xb5f7, 0x21617d },
	{ 0xb5f8, 0x21617e },
	{ 0xb5f9, 0x216221 },
	{ 0xb5fa, 0x216222 },
	{ 0xb5fb, 0x216223 },
	{ 0xb5fc, 0x216224 },
	{ 0xb5fd, 0x216225 },
	{ 0xb5fe, 0x216226 },
	{ 0xb640, 0x216227 },
	{ 0xb641, 0x216228 },
	{ 0xb642, 0x216229 },
	{ 0xb643, 0x21622a },
	{ 0xb644, 0x21622b },
	{ 0xb645, 0x21622c },
	{ 0xb646, 0x21622d },
	{ 0xb647, 0x21622e },
	{ 0xb648, 0x21622f },
	{ 0xb649, 0x216230 },
	{ 0xb64a, 0x216231 },
	{ 0xb64b, 0x216232 },
	{ 0xb64c, 0x216233 },
	{ 0xb64d, 0x216234 },
	{ 0xb64e, 0x216235 },
	{ 0xb64f, 0x216236 },
	{ 0xb650, 0x216237 },
	{ 0xb651, 0x216238 },
	{ 0xb652, 0x216239 },
	{ 0xb653, 0x21623a },
	{ 0xb654, 0x21623b },
	{ 0xb655, 0x21623c },
	{ 0xb656, 0x21623d },
	{ 0xb657, 0x21623e },
	{ 0xb658, 0x21623f },
	{ 0xb659, 0x216240 },
	{ 0xb65a, 0x216241 },
	{ 0xb65b, 0x216242 },
	{ 0xb65c, 0x216243 },
	{ 0xb65d, 0x216244 },
	{ 0xb65e, 0x216245 },
	{ 0xb65f, 0x216246 },
	{ 0xb660, 0x216247 },
	{ 0xb661, 0x216248 },
	{ 0xb662, 0x216249 },
	{ 0xb663, 0x21624a },
	{ 0xb664, 0x21624b },
	{ 0xb665, 0x21624c },
	{ 0xb666, 0x21624d },
	{ 0xb667, 0x21624e },
	{ 0xb668, 0x21624f },
	{ 0xb669, 0x216250 },
	{ 0xb66a, 0x216251 },
	{ 0xb66b, 0x216252 },
	{ 0xb66c, 0x216253 },
	{ 0xb66d, 0x216254 },
	{ 0xb66e, 0x216255 },
	{ 0xb66f, 0x216256 },
	{ 0xb670, 0x216257 },
	{ 0xb671, 0x216258 },
	{ 0xb672, 0x216259 },
	{ 0xb673, 0x21625a },
	{ 0xb674, 0x21625b },
	{ 0xb675, 0x21625c },
	{ 0xb676, 0x21625d },
	{ 0xb677, 0x21625e },
	{ 0xb678, 0x21625f },
	{ 0xb679, 0x216260 },
	{ 0xb67a, 0x216261 },
	{ 0xb67b, 0x216262 },
	{ 0xb67c, 0x216263 },
	{ 0xb67d, 0x216264 },
	{ 0xb67e, 0x216265 },
	{ 0xb6a1, 0x216266 },
	{ 0xb6a2, 0x216267 },
	{ 0xb6a3, 0x216268 },
	{ 0xb6a4, 0x216269 },
	{ 0xb6a5, 0x21626a },
	{ 0xb6a6, 0x21626b },
	{ 0xb6a7, 0x21626c },
	{ 0xb6a8, 0x21626d },
	{ 0xb6a9, 0x21626e },
	{ 0xb6aa, 0x21626f },
	{ 0xb6ab, 0x216270 },
	{ 0xb6ac, 0x216271 },
	{ 0xb6ad, 0x216272 },
	{ 0xb6ae, 0x216273 },
	{ 0xb6af, 0x216274 },
	{ 0xb6b0, 0x216275 },
	{ 0xb6b1, 0x216276 },
	{ 0xb6b2, 0x216277 },
	{ 0xb6b3, 0x216278 },
	{ 0xb6b4, 0x216279 },
	{ 0xb6b5, 0x21627a },
	{ 0xb6b6, 0x21627b },
	{ 0xb6b7, 0x21627c },
	{ 0xb6b8, 0x21627d },
	{ 0xb6b9, 0x21627e },
	{ 0xb6ba, 0x216321 },
	{ 0xb6bb, 0x216322 },
	{ 0xb6bc, 0x216323 },
	{ 0xb6bd, 0x216324 },
	{ 0xb6be, 0x216325 },
	{ 0xb6bf, 0x216326 },
	{ 0xb6c0, 0x216327 },
	{ 0xb6c1, 0x216328 },
	{ 0xb6c2, 0x216329 },
	{ 0xb6c3, 0x21632a },
	{ 0xb6c4, 0x21632b },
	{ 0xb6c5, 0x21632c },
	{ 0xb6c6, 0x21632d },
	{ 0xb6c7, 0x21632e },
	{ 0xb6c8, 0x21632f },
	{ 0xb6c9, 0x216330 },
	{ 0xb6ca, 0x216331 },
	{ 0xb6cb, 0x216332 },
	{ 0xb6cc, 0x216333 },
	{ 0xb6cd, 0x216334 },
	{ 0xb6ce, 0x216335 },
	{ 0xb6cf, 0x216336 },
	{ 0xb6d0, 0x216337 },
	{ 0xb6d1, 0x216338 },
	{ 0xb6d2, 0x216339 },
	{ 0xb6d3, 0x21633a },
	{ 0xb6d4, 0x21633b },
	{ 0xb6d5, 0x21633c },
	{ 0xb6d6, 0x21633d },
	{ 0xb6d7, 0x21633e },
	{ 0xb6d8, 0x21633f },
	{ 0xb6d9, 0x216340 },
	{ 0xb6da, 0x216341 },
	{ 0xb6db, 0x216342 },
	{ 0xb6dc, 0x216343 },
	{ 0xb6dd, 0x216344 },
	{ 0xb6de, 0x216345 },
	{ 0xb6df, 0x216346 },
	{ 0xb6e0, 0x216347 },
	{ 0xb6e1, 0x216348 },
	{ 0xb6e2, 0x216349 },
	{ 0xb6e3, 0x21634a },
	{ 0xb6e4, 0x21634b },
	{ 0xb6e5, 0x21634c },
	{ 0xb6e6, 0x21634d },
	{ 0xb6e7, 0x21634e },
	{ 0xb6e8, 0x21634f },
	{ 0xb6e9, 0x216350 },
	{ 0xb6ea, 0x216351 },
	{ 0xb6eb, 0x216352 },
	{ 0xb6ec, 0x216353 },
	{ 0xb6ed, 0x216354 },
	{ 0xb6ee, 0x216355 },
	{ 0xb6ef, 0x216356 },
	{ 0xb6f0, 0x216357 },
	{ 0xb6f1, 0x216358 },
	{ 0xb6f2, 0x216359 },
	{ 0xb6f3, 0x21635a },
	{ 0xb6f4, 0x21635b },
	{ 0xb6f5, 0x21635c },
	{ 0xb6f6, 0x21635d },
	{ 0xb6f7, 0x21635e },
	{ 0xb6f8, 0x21635f },
	{ 0xb6f9, 0x216360 },
	{ 0xb6fa, 0x216361 },
	{ 0xb6fb, 0x216362 },
	{ 0xb6fc, 0x216363 },
	{ 0xb6fd, 0x216364 },
	{ 0xb6fe, 0x216365 },
	{ 0xb740, 0x216366 },
	{ 0xb741, 0x216367 },
	{ 0xb742, 0x216368 },
	{ 0xb743, 0x216369 },
	{ 0xb744, 0x21636a },
	{ 0xb745, 0x21636b },
	{ 0xb746, 0x21636c },
	{ 0xb747, 0x21636d },
	{ 0xb748, 0x21636e },
	{ 0xb749, 0x21636f },
	{ 0xb74a, 0x216370 },
	{ 0xb74b, 0x216371 },
	{ 0xb74c, 0x216372 },
	{ 0xb74d, 0x216373 },
	{ 0xb74e, 0x216374 },
	{ 0xb74f, 0x216375 },
	{ 0xb750, 0x216376 },
	{ 0xb751, 0x216377 },
	{ 0xb752, 0x216378 },
	{ 0xb753, 0x216379 },
	{ 0xb754, 0x21637a },
	{ 0xb755, 0x21637b },
	{ 0xb756, 0x21637c },
	{ 0xb757, 0x21637d },
	{ 0xb758, 0x21637e },
	{ 0xb759, 0x216421 },
	{ 0xb75a, 0x216422 },
	{ 0xb75b, 0x216423 },
	{ 0xb75c, 0x216424 },
	{ 0xb75d, 0x216425 },
	{ 0xb75e, 0x216426 },
	{ 0xb75f, 0x216427 },
	{ 0xb760, 0x216428 },
	{ 0xb761, 0x216429 },
	{ 0xb762, 0x21642a },
	{ 0xb763, 0x21642b },
	{ 0xb764, 0x21642c },
	{ 0xb765, 0x21642d },
	{ 0xb766, 0x21642e },
	{ 0xb767, 0x21642f },
	{ 0xb768, 0x216430 },
	{ 0xb769, 0x216431 },
	{ 0xb76a, 0x216432 },
	{ 0xb76b, 0x216433 },
	{ 0xb76c, 0x216434 },
	{ 0xb76d, 0x216435 },
	{ 0xb76e, 0x216436 },
	{ 0xb76f, 0x216437 },
	{ 0xb770, 0x216438 },
	{ 0xb771, 0x216439 },
	{ 0xb772, 0x21643a },
	{ 0xb773, 0x21643b },
	{ 0xb774, 0x21643c },
	{ 0xb775, 0x21643d },
	{ 0xb776, 0x21643e },
	{ 0xb777, 0x21643f },
	{ 0xb778, 0x216440 },
	{ 0xb779, 0x216441 },
	{ 0xb77a, 0x216442 },
	{ 0xb77b, 0x216443 },
	{ 0xb77c, 0x216444 },
	{ 0xb77d, 0x216445 },
	{ 0xb77e, 0x216446 },
	{ 0xb7a1, 0x216447 },
	{ 0xb7a2, 0x216448 },
	{ 0xb7a3, 0x216449 },
	{ 0xb7a4, 0x21644a },
	{ 0xb7a5, 0x21644b },
	{ 0xb7a6, 0x21644c },
	{ 0xb7a7, 0x21644d },
	{ 0xb7a8, 0x21644e },
	{ 0xb7a9, 0x21644f },
	{ 0xb7aa, 0x216450 },
	{ 0xb7ab, 0x216451 },
	{ 0xb7ac, 0x216452 },
	{ 0xb7ad, 0x216453 },
	{ 0xb7ae, 0x216454 },
	{ 0xb7af, 0x216455 },
	{ 0xb7b0, 0x216456 },
	{ 0xb7b1, 0x216457 },
	{ 0xb7b2, 0x216458 },
	{ 0xb7b3, 0x216459 },
	{ 0xb7b4, 0x21645a },
	{ 0xb7b5, 0x21645b },
	{ 0xb7b6, 0x21645c },
	{ 0xb7b7, 0x21645d },
	{ 0xb7b8, 0x21645e },
	{ 0xb7b9, 0x21645f },
	{ 0xb7ba, 0x216460 },
	{ 0xb7bb, 0x216461 },
	{ 0xb7bc, 0x216462 },
	{ 0xb7bd, 0x216463 },
	{ 0xb7be, 0x216464 },
	{ 0xb7bf, 0x216465 },
	{ 0xb7c0, 0x216466 },
	{ 0xb7c1, 0x216467 },
	{ 0xb7c2, 0x216468 },
	{ 0xb7c3, 0x216469 },
	{ 0xb7c4, 0x21646a },
	{ 0xb7c5, 0x21646b },
	{ 0xb7c6, 0x21646c },
	{ 0xb7c7, 0x21646d },
	{ 0xb7c8, 0x21646e },
	{ 0xb7c9, 0x21646f },
	{ 0xb7ca, 0x216470 },
	{ 0xb7cb, 0x216471 },
	{ 0xb7cc, 0x216472 },
	{ 0xb7cd, 0x216473 },
	{ 0xb7ce, 0x216474 },
	{ 0xb7cf, 0x216475 },
	{ 0xb7d0, 0x216476 },
	{ 0xb7d1, 0x216477 },
	{ 0xb7d2, 0x216478 },
	{ 0xb7d3, 0x216479 },
	{ 0xb7d4, 0x21647a },
	{ 0xb7d5, 0x21647b },
	{ 0xb7d6, 0x21647c },
	{ 0xb7d7, 0x21647d },
	{ 0xb7d8, 0x21647e },
	{ 0xb7d9, 0x216521 },
	{ 0xb7da, 0x216522 },
	{ 0xb7db, 0x216523 },
	{ 0xb7dc, 0x216524 },
	{ 0xb7dd, 0x216525 },
	{ 0xb7de, 0x216526 },
	{ 0xb7df, 0x216527 },
	{ 0xb7e0, 0x216528 },
	{ 0xb7e1, 0x216529 },
	{ 0xb7e2, 0x21652a },
	{ 0xb7e3, 0x21652b },
	{ 0xb7e4, 0x21652c },
	{ 0xb7e5, 0x21652d },
	{ 0xb7e6, 0x21652e },
	{ 0xb7e7, 0x21652f },
	{ 0xb7e8, 0x216530 },
	{ 0xb7e9, 0x216531 },
	{ 0xb7ea, 0x216532 },
	{ 0xb7eb, 0x216533 },
	{ 0xb7ec, 0x216534 },
	{ 0xb7ed, 0x216535 },
	{ 0xb7ee, 0x216536 },
	{ 0xb7ef, 0x216537 },
	{ 0xb7f0, 0x216538 },
	{ 0xb7f1, 0x216539 },
	{ 0xb7f2, 0x21653a },
	{ 0xb7f3, 0x21653b },
	{ 0xb7f4, 0x21653c },
	{ 0xb7f5, 0x21653d },
	{ 0xb7f6, 0x21653e },
	{ 0xb7f7, 0x21653f },
	{ 0xb7f8, 0x216540 },
	{ 0xb7f9, 0x216541 },
	{ 0xb7fa, 0x216542 },
	{ 0xb7fb, 0x216543 },
	{ 0xb7fc, 0x216544 },
	{ 0xb7fd, 0x216545 },
	{ 0xb7fe, 0x216546 },
	{ 0xb840, 0x216547 },
	{ 0xb841, 0x216548 },
	{ 0xb842, 0x216549 },
	{ 0xb843, 0x21654a },
	{ 0xb844, 0x21654b },
	{ 0xb845, 0x21654c },
	{ 0xb846, 0x21654d },
	{ 0xb847, 0x21654e },
	{ 0xb848, 0x21654f },
	{ 0xb849, 0x216550 },
	{ 0xb84a, 0x216551 },
	{ 0xb84b, 0x216552 },
	{ 0xb84c, 0x216553 },
	{ 0xb84d, 0x216554 },
	{ 0xb84e, 0x216555 },
	{ 0xb84f, 0x216556 },
	{ 0xb850, 0x216557 },
	{ 0xb851, 0x216558 },
	{ 0xb852, 0x216559 },
	{ 0xb853, 0x21655a },
	{ 0xb854, 0x21655b },
	{ 0xb855, 0x21655c },
	{ 0xb856, 0x21655d },
	{ 0xb857, 0x21655e },
	{ 0xb858, 0x21655f },
	{ 0xb859, 0x216560 },
	{ 0xb85a, 0x216561 },
	{ 0xb85b, 0x216562 },
	{ 0xb85c, 0x216563 },
	{ 0xb85d, 0x216564 },
	{ 0xb85e, 0x216565 },
	{ 0xb85f, 0x216566 },
	{ 0xb860, 0x216567 },
	{ 0xb861, 0x216568 },
	{ 0xb862, 0x216569 },
	{ 0xb863, 0x21656a },
	{ 0xb864, 0x21656b },
	{ 0xb865, 0x21656c },
	{ 0xb866, 0x21656d },
	{ 0xb867, 0x21656e },
	{ 0xb868, 0x21656f },
	{ 0xb869, 0x216570 },
	{ 0xb86a, 0x216571 },
	{ 0xb86b, 0x216572 },
	{ 0xb86c, 0x216573 },
	{ 0xb86d, 0x216574 },
	{ 0xb86e, 0x216575 },
	{ 0xb86f, 0x216576 },
	{ 0xb870, 0x216577 },
	{ 0xb871, 0x216578 },
	{ 0xb872, 0x216579 },
	{ 0xb873, 0x21657a },
	{ 0xb874, 0x21657b },
	{ 0xb875, 0x21657c },
	{ 0xb876, 0x21657d },
	{ 0xb877, 0x21657e },
	{ 0xb878, 0x216621 },
	{ 0xb879, 0x216622 },
	{ 0xb87a, 0x216623 },
	{ 0xb87b, 0x216624 },
	{ 0xb87c, 0x216625 },
	{ 0xb87d, 0x216626 },
	{ 0xb87e, 0x216627 },
	{ 0xb8a1, 0x216628 },
	{ 0xb8a2, 0x216629 },
	{ 0xb8a3, 0x21662a },
	{ 0xb8a4, 0x21662b },
	{ 0xb8a5, 0x21662c },
	{ 0xb8a6, 0x21662d },
	{ 0xb8a7, 0x21662e },
	{ 0xb8a8, 0x21662f },
	{ 0xb8a9, 0x216630 },
	{ 0xb8aa, 0x216631 },
	{ 0xb8ab, 0x216632 },
	{ 0xb8ac, 0x216633 },
	{ 0xb8ad, 0x216634 },
	{ 0xb8ae, 0x216635 },
	{ 0xb8af, 0x216636 },
	{ 0xb8b0, 0x216637 },
	{ 0xb8b1, 0x216638 },
	{ 0xb8b2, 0x216639 },
	{ 0xb8b3, 0x21663a },
	{ 0xb8b4, 0x21663b },
	{ 0xb8b5, 0x21663c },
	{ 0xb8b6, 0x21663d },
	{ 0xb8b7, 0x21663e },
	{ 0xb8b8, 0x21663f },
	{ 0xb8b9, 0x216640 },
	{ 0xb8ba, 0x216641 },
	{ 0xb8bb, 0x216642 },
	{ 0xb8bc, 0x216643 },
	{ 0xb8bd, 0x216644 },
	{ 0xb8be, 0x216645 },
	{ 0xb8bf, 0x216646 },
	{ 0xb8c0, 0x216647 },
	{ 0xb8c1, 0x216648 },
	{ 0xb8c2, 0x216649 },
	{ 0xb8c3, 0x21664a },
	{ 0xb8c4, 0x21664b },
	{ 0xb8c5, 0x21664c },
	{ 0xb8c6, 0x21664d },
	{ 0xb8c7, 0x21664e },
	{ 0xb8c8, 0x21664f },
	{ 0xb8c9, 0x216650 },
	{ 0xb8ca, 0x216651 },
	{ 0xb8cb, 0x216652 },
	{ 0xb8cc, 0x216653 },
	{ 0xb8cd, 0x216654 },
	{ 0xb8ce, 0x216655 },
	{ 0xb8cf, 0x216656 },
	{ 0xb8d0, 0x216657 },
	{ 0xb8d1, 0x216658 },
	{ 0xb8d2, 0x216659 },
	{ 0xb8d3, 0x21665a },
	{ 0xb8d4, 0x21665b },
	{ 0xb8d5, 0x21665c },
	{ 0xb8d6, 0x21665d },
	{ 0xb8d7, 0x21665e },
	{ 0xb8d8, 0x21665f },
	{ 0xb8d9, 0x216660 },
	{ 0xb8da, 0x216661 },
	{ 0xb8db, 0x216662 },
	{ 0xb8dc, 0x216663 },
	{ 0xb8dd, 0x216664 },
	{ 0xb8de, 0x216665 },
	{ 0xb8df, 0x216666 },
	{ 0xb8e0, 0x216667 },
	{ 0xb8e1, 0x216668 },
	{ 0xb8e2, 0x216669 },
	{ 0xb8e3, 0x21666a },
	{ 0xb8e4, 0x21666b },
	{ 0xb8e5, 0x21666c },
	{ 0xb8e6, 0x21666d },
	{ 0xb8e7, 0x21666e },
	{ 0xb8e8, 0x21666f },
	{ 0xb8e9, 0x216670 },
	{ 0xb8ea, 0x216671 },
	{ 0xb8eb, 0x216672 },
	{ 0xb8ec, 0x216673 },
	{ 0xb8ed, 0x216674 },
	{ 0xb8ee, 0x216675 },
	{ 0xb8ef, 0x216676 },
	{ 0xb8f0, 0x216677 },
	{ 0xb8f1, 0x216678 },
	{ 0xb8f2, 0x216679 },
	{ 0xb8f3, 0x21667a },
	{ 0xb8f4, 0x21667b },
	{ 0xb8f5, 0x21667c },
	{ 0xb8f6, 0x21667d },
	{ 0xb8f7, 0x21667e },
	{ 0xb8f8, 0x216721 },
	{ 0xb8f9, 0x216722 },
	{ 0xb8fa, 0x216723 },
	{ 0xb8fb, 0x216724 },
	{ 0xb8fc, 0x216725 },
	{ 0xb8fd, 0x216726 },
	{ 0xb8fe, 0x216727 },
	{ 0xb940, 0x216728 },
	{ 0xb941, 0x216729 },
	{ 0xb942, 0x21672a },
	{ 0xb943, 0x21672b },
	{ 0xb944, 0x21672c },
	{ 0xb945, 0x21672d },
	{ 0xb946, 0x21672e },
	{ 0xb947, 0x21672f },
	{ 0xb948, 0x216730 },
	{ 0xb949, 0x216731 },
	{ 0xb94a, 0x216732 },
	{ 0xb94b, 0x216733 },
	{ 0xb94c, 0x216734 },
	{ 0xb94d, 0x216735 },
	{ 0xb94e, 0x216736 },
	{ 0xb94f, 0x216737 },
	{ 0xb950, 0x216738 },
	{ 0xb951, 0x216739 },
	{ 0xb952, 0x21673a },
	{ 0xb953, 0x21673b },
	{ 0xb954, 0x21673c },
	{ 0xb955, 0x21673d },
	{ 0xb956, 0x21673e },
	{ 0xb957, 0x21673f },
	{ 0xb958, 0x216740 },
	{ 0xb959, 0x216741 },
	{ 0xb95a, 0x216742 },
	{ 0xb95b, 0x216743 },
	{ 0xb95c, 0x216744 },
	{ 0xb95d, 0x216745 },
	{ 0xb95e, 0x216746 },
	{ 0xb95f, 0x216747 },
	{ 0xb960, 0x216748 },
	{ 0xb961, 0x216749 },
	{ 0xb962, 0x21674a },
	{ 0xb963, 0x21674b },
	{ 0xb964, 0x21674c },
	{ 0xb965, 0x21674d },
	{ 0xb966, 0x21674e },
	{ 0xb967, 0x21674f },
	{ 0xb968, 0x216750 },
	{ 0xb969, 0x216751 },
	{ 0xb96a, 0x216752 },
	{ 0xb96b, 0x216753 },
	{ 0xb96c, 0x216754 },
	{ 0xb96d, 0x216755 },
	{ 0xb96e, 0x216756 },
	{ 0xb96f, 0x216757 },
	{ 0xb970, 0x216758 },
	{ 0xb971, 0x216759 },
	{ 0xb972, 0x21675a },
	{ 0xb973, 0x21675b },
	{ 0xb974, 0x21675c },
	{ 0xb975, 0x21675d },
	{ 0xb976, 0x21675e },
	{ 0xb977, 0x21675f },
	{ 0xb978, 0x216760 },
	{ 0xb979, 0x216761 },
	{ 0xb97a, 0x216762 },
	{ 0xb97b, 0x216763 },
	{ 0xb97c, 0x216764 },
	{ 0xb97d, 0x216765 },
	{ 0xb97e, 0x216766 },
	{ 0xb9a1, 0x216767 },
	{ 0xb9a2, 0x216768 },
	{ 0xb9a3, 0x216769 },
	{ 0xb9a4, 0x21676a },
	{ 0xb9a5, 0x21676b },
	{ 0xb9a6, 0x21676c },
	{ 0xb9a7, 0x21676d },
	{ 0xb9a8, 0x21676e },
	{ 0xb9a9, 0x21676f },
	{ 0xb9aa, 0x216770 },
	{ 0xb9ab, 0x216771 },
	{ 0xb9ac, 0x216772 },
	{ 0xb9ad, 0x216773 },
	{ 0xb9ae, 0x216774 },
	{ 0xb9af, 0x216775 },
	{ 0xb9b0, 0x216776 },
	{ 0xb9b1, 0x216777 },
	{ 0xb9b2, 0x216778 },
	{ 0xb9b3, 0x216779 },
	{ 0xb9b4, 0x21677a },
	{ 0xb9b5, 0x21677b },
	{ 0xb9b6, 0x21677c },
	{ 0xb9b7, 0x21677d },
	{ 0xb9b8, 0x21677e },
	{ 0xb9b9, 0x216821 },
	{ 0xb9ba, 0x216822 },
	{ 0xb9bb, 0x216823 },
	{ 0xb9bc, 0x216824 },
	{ 0xb9bd, 0x216825 },
	{ 0xb9be, 0x216826 },
	{ 0xb9bf, 0x216827 },
	{ 0xb9c0, 0x216828 },
	{ 0xb9c1, 0x216829 },
	{ 0xb9c2, 0x21682a },
	{ 0xb9c3, 0x21682b },
	{ 0xb9c4, 0x21682c },
	{ 0xb9c5, 0x21682d },
	{ 0xb9c6, 0x21682e },
	{ 0xb9c7, 0x21682f },
	{ 0xb9c8, 0x216830 },
	{ 0xb9c9, 0x216831 },
	{ 0xb9ca, 0x216832 },
	{ 0xb9cb, 0x216833 },
	{ 0xb9cc, 0x216834 },
	{ 0xb9cd, 0x216835 },
	{ 0xb9ce, 0x216836 },
	{ 0xb9cf, 0x216837 },
	{ 0xb9d0, 0x216838 },
	{ 0xb9d1, 0x216839 },
	{ 0xb9d2, 0x21683a },
	{ 0xb9d3, 0x21683b },
	{ 0xb9d4, 0x21683c },
	{ 0xb9d5, 0x21683d },
	{ 0xb9d6, 0x21683e },
	{ 0xb9d7, 0x21683f },
	{ 0xb9d8, 0x216840 },
	{ 0xb9d9, 0x216841 },
	{ 0xb9da, 0x216842 },
	{ 0xb9db, 0x216843 },
	{ 0xb9dc, 0x216844 },
	{ 0xb9dd, 0x216845 },
	{ 0xb9de, 0x216846 },
	{ 0xb9df, 0x216847 },
	{ 0xb9e0, 0x216848 },
	{ 0xb9e1, 0x216849 },
	{ 0xb9e2, 0x21684a },
	{ 0xb9e3, 0x21684b },
	{ 0xb9e4, 0x21684c },
	{ 0xb9e5, 0x21684d },
	{ 0xb9e6, 0x21684e },
	{ 0xb9e7, 0x21684f },
	{ 0xb9e8, 0x216850 },
	{ 0xb9e9, 0x216851 },
	{ 0xb9ea, 0x216852 },
	{ 0xb9eb, 0x216853 },
	{ 0xb9ec, 0x216854 },
	{ 0xb9ed, 0x216855 },
	{ 0xb9ee, 0x216856 },
	{ 0xb9ef, 0x216857 },
	{ 0xb9f0, 0x216858 },
	{ 0xb9f1, 0x216859 },
	{ 0xb9f2, 0x21685a },
	{ 0xb9f3, 0x21685b },
	{ 0xb9f4, 0x21685c },
	{ 0xb9f5, 0x21685d },
	{ 0xb9f6, 0x21685e },
	{ 0xb9f7, 0x21685f },
	{ 0xb9f8, 0x216860 },
	{ 0xb9f9, 0x216861 },
	{ 0xb9fa, 0x216862 },
	{ 0xb9fb, 0x216863 },
	{ 0xb9fc, 0x216864 },
	{ 0xb9fd, 0x216865 },
	{ 0xb9fe, 0x216866 },
	{ 0xba40, 0x216867 },
	{ 0xba41, 0x216868 },
	{ 0xba42, 0x216869 },
	{ 0xba43, 0x21686a },
	{ 0xba44, 0x21686b },
	{ 0xba45, 0x21686c },
	{ 0xba46, 0x21686d },
	{ 0xba47, 0x21686e },
	{ 0xba48, 0x21686f },
	{ 0xba49, 0x216870 },
	{ 0xba4a, 0x216871 },
	{ 0xba4b, 0x216872 },
	{ 0xba4c, 0x216873 },
	{ 0xba4d, 0x216874 },
	{ 0xba4e, 0x216875 },
	{ 0xba4f, 0x216876 },
	{ 0xba50, 0x216877 },
	{ 0xba51, 0x216878 },
	{ 0xba52, 0x216879 },
	{ 0xba53, 0x21687a },
	{ 0xba54, 0x21687b },
	{ 0xba55, 0x21687c },
	{ 0xba56, 0x21687d },
	{ 0xba57, 0x21687e },
	{ 0xba58, 0x216921 },
	{ 0xba59, 0x216922 },
	{ 0xba5a, 0x216923 },
	{ 0xba5b, 0x216924 },
	{ 0xba5c, 0x216925 },
	{ 0xba5d, 0x216926 },
	{ 0xba5e, 0x216927 },
	{ 0xba5f, 0x216928 },
	{ 0xba60, 0x216929 },
	{ 0xba61, 0x21692a },
	{ 0xba62, 0x21692b },
	{ 0xba63, 0x21692c },
	{ 0xba64, 0x21692d },
	{ 0xba65, 0x21692e },
	{ 0xba66, 0x21692f },
	{ 0xba67, 0x216930 },
	{ 0xba68, 0x216931 },
	{ 0xba69, 0x216932 },
	{ 0xba6a, 0x216933 },
	{ 0xba6b, 0x216934 },
	{ 0xba6c, 0x216935 },
	{ 0xba6d, 0x216936 },
	{ 0xba6e, 0x216937 },
	{ 0xba6f, 0x216938 },
	{ 0xba70, 0x216939 },
	{ 0xba71, 0x21693a },
	{ 0xba72, 0x21693b },
	{ 0xba73, 0x21693c },
	{ 0xba74, 0x21693d },
	{ 0xba75, 0x21693e },
	{ 0xba76, 0x21693f },
	{ 0xba77, 0x216940 },
	{ 0xba78, 0x216941 },
	{ 0xba79, 0x216942 },
	{ 0xba7a, 0x216943 },
	{ 0xba7b, 0x216944 },
	{ 0xba7c, 0x216945 },
	{ 0xba7d, 0x216946 },
	{ 0xba7e, 0x216947 },
	{ 0xbaa1, 0x216948 },
	{ 0xbaa2, 0x216949 },
	{ 0xbaa3, 0x21694a },
	{ 0xbaa4, 0x21694b },
	{ 0xbaa5, 0x21694c },
	{ 0xbaa6, 0x21694d },
	{ 0xbaa7, 0x21694e },
	{ 0xbaa8, 0x21694f },
	{ 0xbaa9, 0x216950 },
	{ 0xbaaa, 0x216951 },
	{ 0xbaab, 0x216952 },
	{ 0xbaac, 0x216953 },
	{ 0xbaad, 0x216954 },
	{ 0xbaae, 0x216955 },
	{ 0xbaaf, 0x216956 },
	{ 0xbab0, 0x216957 },
	{ 0xbab1, 0x216958 },
	{ 0xbab2, 0x216959 },
	{ 0xbab3, 0x21695a },
	{ 0xbab4, 0x21695b },
	{ 0xbab5, 0x21695c },
	{ 0xbab6, 0x21695d },
	{ 0xbab7, 0x21695e },
	{ 0xbab8, 0x21695f },
	{ 0xbab9, 0x216960 },
	{ 0xbaba, 0x216961 },
	{ 0xbabb, 0x216962 },
	{ 0xbabc, 0x216963 },
	{ 0xbabd, 0x216964 },
	{ 0xbabe, 0x216965 },
	{ 0xbabf, 0x216966 },
	{ 0xbac0, 0x216967 },
	{ 0xbac1, 0x216968 },
	{ 0xbac2, 0x216969 },
	{ 0xbac3, 0x21696a },
	{ 0xbac4, 0x21696b },
	{ 0xbac5, 0x21696c },
	{ 0xbac6, 0x21696d },
	{ 0xbac7, 0x21696e },
	{ 0xbac8, 0x21696f },
	{ 0xbac9, 0x216970 },
	{ 0xbaca, 0x216971 },
	{ 0xbacb, 0x216972 },
	{ 0xbacc, 0x216973 },
	{ 0xbacd, 0x216974 },
	{ 0xbace, 0x216975 },
	{ 0xbacf, 0x216976 },
	{ 0xbad0, 0x216977 },
	{ 0xbad1, 0x216978 },
	{ 0xbad2, 0x216979 },
	{ 0xbad3, 0x21697a },
	{ 0xbad4, 0x21697b },
	{ 0xbad5, 0x21697c },
	{ 0xbad6, 0x21697d },
	{ 0xbad7, 0x21697e },
	{ 0xbad8, 0x216a21 },
	{ 0xbad9, 0x216a22 },
	{ 0xbada, 0x216a23 },
	{ 0xbadb, 0x216a24 },
	{ 0xbadc, 0x216a25 },
	{ 0xbadd, 0x216a26 },
	{ 0xbade, 0x216a27 },
	{ 0xbadf, 0x216a28 },
	{ 0xbae0, 0x216a29 },
	{ 0xbae1, 0x216a2a },
	{ 0xbae2, 0x216a2b },
	{ 0xbae3, 0x216a2c },
	{ 0xbae4, 0x216a2d },
	{ 0xbae5, 0x216a2e },
	{ 0xbae6, 0x216a2f },
	{ 0xbae7, 0x216a30 },
	{ 0xbae8, 0x216a31 },
	{ 0xbae9, 0x216a32 },
	{ 0xbaea, 0x216a33 },
	{ 0xbaeb, 0x216a34 },
	{ 0xbaec, 0x216a35 },
	{ 0xbaed, 0x216a36 },
	{ 0xbaee, 0x216a37 },
	{ 0xbaef, 0x216a38 },
	{ 0xbaf0, 0x216a39 },
	{ 0xbaf1, 0x216a3a },
	{ 0xbaf2, 0x216a3b },
	{ 0xbaf3, 0x216a3c },
	{ 0xbaf4, 0x216a3d },
	{ 0xbaf5, 0x216a3e },
	{ 0xbaf6, 0x216a3f },
	{ 0xbaf7, 0x216a40 },
	{ 0xbaf8, 0x216a41 },
	{ 0xbaf9, 0x216a42 },
	{ 0xbafa, 0x216a43 },
	{ 0xbafb, 0x216a44 },
	{ 0xbafc, 0x216a45 },
	{ 0xbafd, 0x216a46 },
	{ 0xbafe, 0x216a47 },
	{ 0xbb40, 0x216a48 },
	{ 0xbb41, 0x216a49 },
	{ 0xbb42, 0x216a4a },
	{ 0xbb43, 0x216a4b },
	{ 0xbb44, 0x216a4c },
	{ 0xbb45, 0x216a4d },
	{ 0xbb46, 0x216a4e },
	{ 0xbb47, 0x216a4f },
	{ 0xbb48, 0x216a50 },
	{ 0xbb49, 0x216a51 },
	{ 0xbb4a, 0x216a52 },
	{ 0xbb4b, 0x216a53 },
	{ 0xbb4c, 0x216a54 },
	{ 0xbb4d, 0x216a55 },
	{ 0xbb4e, 0x216a56 },
	{ 0xbb4f, 0x216a57 },
	{ 0xbb50, 0x216a58 },
	{ 0xbb51, 0x216a59 },
	{ 0xbb52, 0x216a5a },
	{ 0xbb53, 0x216a5b },
	{ 0xbb54, 0x216a5c },
	{ 0xbb55, 0x216a5d },
	{ 0xbb56, 0x216a5e },
	{ 0xbb57, 0x216a5f },
	{ 0xbb58, 0x216a60 },
	{ 0xbb59, 0x216a61 },
	{ 0xbb5a, 0x216a62 },
	{ 0xbb5b, 0x216a63 },
	{ 0xbb5c, 0x216a64 },
	{ 0xbb5d, 0x216a65 },
	{ 0xbb5e, 0x216a66 },
	{ 0xbb5f, 0x216a67 },
	{ 0xbb60, 0x216a68 },
	{ 0xbb61, 0x216a69 },
	{ 0xbb62, 0x216a6a },
	{ 0xbb63, 0x216a6b },
	{ 0xbb64, 0x216a6c },
	{ 0xbb65, 0x216a6d },
	{ 0xbb66, 0x216a6e },
	{ 0xbb67, 0x216a6f },
	{ 0xbb68, 0x216a70 },
	{ 0xbb69, 0x216a71 },
	{ 0xbb6a, 0x216a72 },
	{ 0xbb6b, 0x216a73 },
	{ 0xbb6c, 0x216a74 },
	{ 0xbb6d, 0x216a75 },
	{ 0xbb6e, 0x216a76 },
	{ 0xbb6f, 0x216a77 },
	{ 0xbb70, 0x216a78 },
	{ 0xbb71, 0x216a79 },
	{ 0xbb72, 0x216a7a },
	{ 0xbb73, 0x216a7b },
	{ 0xbb74, 0x216a7c },
	{ 0xbb75, 0x216a7d },
	{ 0xbb76, 0x216a7e },
	{ 0xbb77, 0x216b21 },
	{ 0xbb78, 0x216b22 },
	{ 0xbb79, 0x216b23 },
	{ 0xbb7a, 0x216b24 },
	{ 0xbb7b, 0x216b25 },
	{ 0xbb7c, 0x216b26 },
	{ 0xbb7d, 0x216b27 },
	{ 0xbb7e, 0x216b28 },
	{ 0xbba1, 0x216b29 },
	{ 0xbba2, 0x216b2a },
	{ 0xbba3, 0x216b2b },
	{ 0xbba4, 0x216b2c },
	{ 0xbba5, 0x216b2d },
	{ 0xbba6, 0x216b2e },
	{ 0xbba7, 0x216b2f },
	{ 0xbba8, 0x216b30 },
	{ 0xbba9, 0x216b31 },
	{ 0xbbaa, 0x216b32 },
	{ 0xbbab, 0x216b33 },
	{ 0xbbac, 0x216b34 },
	{ 0xbbad, 0x216b35 },
	{ 0xbbae, 0x216b36 },
	{ 0xbbaf, 0x216b37 },
	{ 0xbbb0, 0x216b38 },
	{ 0xbbb1, 0x216b39 },
	{ 0xbbb2, 0x216b3a },
	{ 0xbbb3, 0x216b3b },
	{ 0xbbb4, 0x216b3c },
	{ 0xbbb5, 0x216b3d },
	{ 0xbbb6, 0x216b3e },
	{ 0xbbb7, 0x216b3f },
	{ 0xbbb8, 0x216b40 },
	{ 0xbbb9, 0x216b41 },
	{ 0xbbba, 0x216b42 },
	{ 0xbbbb, 0x216b43 },
	{ 0xbbbc, 0x216b44 },
	{ 0xbbbd, 0x216b45 },
	{ 0xbbbe, 0x216b46 },
	{ 0xbbbf, 0x216b47 },
	{ 0xbbc0, 0x216b48 },
	{ 0xbbc1, 0x216b49 },
	{ 0xbbc2, 0x216b4a },
	{ 0xbbc3, 0x216b4b },
	{ 0xbbc4, 0x216b4c },
	{ 0xbbc5, 0x216b4d },
	{ 0xbbc6, 0x216b4e },
	{ 0xbbc7, 0x216b4f },
	{ 0xbbc8, 0x216b51 },
	{ 0xbbc9, 0x216b52 },
	{ 0xbbca, 0x216b53 },
	{ 0xbbcb, 0x216b54 },
	{ 0xbbcc, 0x216b55 },
	{ 0xbbcd, 0x216b56 },
	{ 0xbbce, 0x216b57 },
	{ 0xbbcf, 0x216b58 },
	{ 0xbbd0, 0x216b59 },
	{ 0xbbd1, 0x216b5a },
	{ 0xbbd2, 0x216b5b },
	{ 0xbbd3, 0x216b5c },
	{ 0xbbd4, 0x216b5d },
	{ 0xbbd5, 0x216b5e },
	{ 0xbbd6, 0x216b5f },
	{ 0xbbd7, 0x216b60 },
	{ 0xbbd8, 0x216b61 },
	{ 0xbbd9, 0x216b62 },
	{ 0xbbda, 0x216b63 },
	{ 0xbbdb, 0x216b64 },
	{ 0xbbdc, 0x216b65 },
	{ 0xbbdd, 0x216b66 },
	{ 0xbbde, 0x216b67 },
	{ 0xbbdf, 0x216b68 },
	{ 0xbbe0, 0x216b69 },
	{ 0xbbe1, 0x216b6a },
	{ 0xbbe2, 0x216b6b },
	{ 0xbbe3, 0x216b6c },
	{ 0xbbe4, 0x216b6d },
	{ 0xbbe5, 0x216b6e },
	{ 0xbbe6, 0x216b6f },
	{ 0xbbe7, 0x216b70 },
	{ 0xbbe8, 0x216b71 },
	{ 0xbbe9, 0x216b72 },
	{ 0xbbea, 0x216b73 },
	{ 0xbbeb, 0x216b74 },
	{ 0xbbec, 0x216b75 },
	{ 0xbbed, 0x216b76 },
	{ 0xbbee, 0x216b77 },
	{ 0xbbef, 0x216b78 },
	{ 0xbbf0, 0x216b79 },
	{ 0xbbf1, 0x216b7a },
	{ 0xbbf2, 0x216b7b },
	{ 0xbbf3, 0x216b7c },
	{ 0xbbf4, 0x216b7d },
	{ 0xbbf5, 0x216b7e },
	{ 0xbbf6, 0x216c21 },
	{ 0xbbf7, 0x216c22 },
	{ 0xbbf8, 0x216c23 },
	{ 0xbbf9, 0x216c24 },
	{ 0xbbfa, 0x216c25 },
	{ 0xbbfb, 0x216c26 },
	{ 0xbbfc, 0x216c27 },
	{ 0xbbfd, 0x216c28 },
	{ 0xbbfe, 0x216c29 },
	{ 0xbc40, 0x216c2a },
	{ 0xbc41, 0x216c2b },
	{ 0xbc42, 0x216c2c },
	{ 0xbc43, 0x216c2d },
	{ 0xbc44, 0x216c2e },
	{ 0xbc45, 0x216c2f },
	{ 0xbc46, 0x216c30 },
	{ 0xbc47, 0x216c31 },
	{ 0xbc48, 0x216c32 },
	{ 0xbc49, 0x216c33 },
	{ 0xbc4a, 0x216c34 },
	{ 0xbc4b, 0x216c35 },
	{ 0xbc4c, 0x216c36 },
	{ 0xbc4d, 0x216c37 },
	{ 0xbc4e, 0x216c38 },
	{ 0xbc4f, 0x216c39 },
	{ 0xbc50, 0x216c3a },
	{ 0xbc51, 0x216c3b },
	{ 0xbc52, 0x216c3c },
	{ 0xbc53, 0x216c3d },
	{ 0xbc54, 0x216c3e },
	{ 0xbc55, 0x216c3f },
	{ 0xbc56, 0x216c40 },
	{ 0xbc57, 0x216c41 },
	{ 0xbc58, 0x216c42 },
	{ 0xbc59, 0x216c43 },
	{ 0xbc5a, 0x216c44 },
	{ 0xbc5b, 0x216c45 },
	{ 0xbc5c, 0x216c46 },
	{ 0xbc5d, 0x216c47 },
	{ 0xbc5e, 0x216c48 },
	{ 0xbc5f, 0x216c49 },
	{ 0xbc60, 0x216c4a },
	{ 0xbc61, 0x216c4b },
	{ 0xbc62, 0x216c4c },
	{ 0xbc63, 0x216c4d },
	{ 0xbc64, 0x216c4e },
	{ 0xbc65, 0x216c4f },
	{ 0xbc66, 0x216c50 },
	{ 0xbc67, 0x216c51 },
	{ 0xbc68, 0x216c52 },
	{ 0xbc69, 0x216c53 },
	{ 0xbc6a, 0x216c54 },
	{ 0xbc6b, 0x216c55 },
	{ 0xbc6c, 0x216c56 },
	{ 0xbc6d, 0x216c57 },
	{ 0xbc6e, 0x216c58 },
	{ 0xbc6f, 0x216c59 },
	{ 0xbc70, 0x216c5a },
	{ 0xbc71, 0x216c5b },
	{ 0xbc72, 0x216c5c },
	{ 0xbc73, 0x216c5d },
	{ 0xbc74, 0x216c5e },
	{ 0xbc75, 0x216c5f },
	{ 0xbc76, 0x216c60 },
	{ 0xbc77, 0x216c61 },
	{ 0xbc78, 0x216c62 },
	{ 0xbc79, 0x216c63 },
	{ 0xbc7a, 0x216c64 },
	{ 0xbc7b, 0x216c65 },
	{ 0xbc7c, 0x216c66 },
	{ 0xbc7d, 0x216c67 },
	{ 0xbc7e, 0x216c68 },
	{ 0xbca1, 0x216c69 },
	{ 0xbca2, 0x216c6a },
	{ 0xbca3, 0x216c6b },
	{ 0xbca4, 0x216c6c },
	{ 0xbca5, 0x216c6d },
	{ 0xbca6, 0x216c6e },
	{ 0xbca7, 0x216c6f },
	{ 0xbca8, 0x216c70 },
	{ 0xbca9, 0x216c71 },
	{ 0xbcaa, 0x216c72 },
	{ 0xbcab, 0x216c73 },
	{ 0xbcac, 0x216c74 },
	{ 0xbcad, 0x216c75 },
	{ 0xbcae, 0x216c76 },
	{ 0xbcaf, 0x216c77 },
	{ 0xbcb0, 0x216c78 },
	{ 0xbcb1, 0x216c79 },
	{ 0xbcb2, 0x216c7a },
	{ 0xbcb3, 0x216c7b },
	{ 0xbcb4, 0x216c7c },
	{ 0xbcb5, 0x216c7d },
	{ 0xbcb6, 0x216c7e },
	{ 0xbcb7, 0x216d21 },
	{ 0xbcb8, 0x216d22 },
	{ 0xbcb9, 0x216d23 },
	{ 0xbcba, 0x216d24 },
	{ 0xbcbb, 0x216d25 },
	{ 0xbcbc, 0x216d26 },
	{ 0xbcbd, 0x216d27 },
	{ 0xbcbe, 0x216d28 },
	{ 0xbcbf, 0x216d29 },
	{ 0xbcc0, 0x216d2a },
	{ 0xbcc1, 0x216d2b },
	{ 0xbcc2, 0x216d2c },
	{ 0xbcc3, 0x216d2d },
	{ 0xbcc4, 0x216d2e },
	{ 0xbcc5, 0x216d2f },
	{ 0xbcc6, 0x216d30 },
	{ 0xbcc7, 0x216d31 },
	{ 0xbcc8, 0x216d32 },
	{ 0xbcc9, 0x216d33 },
	{ 0xbcca, 0x216d34 },
	{ 0xbccb, 0x216d35 },
	{ 0xbccc, 0x216d36 },
	{ 0xbccd, 0x216d37 },
	{ 0xbcce, 0x216d38 },
	{ 0xbccf, 0x216d39 },
	{ 0xbcd0, 0x216d3a },
	{ 0xbcd1, 0x216d3b },
	{ 0xbcd2, 0x216d3c },
	{ 0xbcd3, 0x216d3d },
	{ 0xbcd4, 0x216d3e },
	{ 0xbcd5, 0x216d3f },
	{ 0xbcd6, 0x216d40 },
	{ 0xbcd7, 0x216d41 },
	{ 0xbcd8, 0x216d42 },
	{ 0xbcd9, 0x216d43 },
	{ 0xbcda, 0x216d44 },
	{ 0xbcdb, 0x216d45 },
	{ 0xbcdc, 0x216d46 },
	{ 0xbcdd, 0x216d47 },
	{ 0xbcde, 0x216d48 },
	{ 0xbcdf, 0x216d49 },
	{ 0xbce0, 0x216d4a },
	{ 0xbce1, 0x216d4b },
	{ 0xbce2, 0x216d4c },
	{ 0xbce3, 0x216d4d },
	{ 0xbce4, 0x216d4e },
	{ 0xbce5, 0x216d4f },
	{ 0xbce6, 0x216d50 },
	{ 0xbce7, 0x216d51 },
	{ 0xbce8, 0x216d52 },
	{ 0xbce9, 0x216d53 },
	{ 0xbcea, 0x216d54 },
	{ 0xbceb, 0x216d55 },
	{ 0xbcec, 0x216d56 },
	{ 0xbced, 0x216d57 },
	{ 0xbcee, 0x216d58 },
	{ 0xbcef, 0x216d59 },
	{ 0xbcf0, 0x216d5a },
	{ 0xbcf1, 0x216d5b },
	{ 0xbcf2, 0x216d5c },
	{ 0xbcf3, 0x216d5d },
	{ 0xbcf4, 0x216d5e },
	{ 0xbcf5, 0x216d5f },
	{ 0xbcf6, 0x216d60 },
	{ 0xbcf7, 0x216d61 },
	{ 0xbcf8, 0x216d62 },
	{ 0xbcf9, 0x216d63 },
	{ 0xbcfa, 0x216d64 },
	{ 0xbcfb, 0x216d65 },
	{ 0xbcfc, 0x216d66 },
	{ 0xbcfd, 0x216d67 },
	{ 0xbcfe, 0x216d68 },
	{ 0xbd40, 0x216d69 },
	{ 0xbd41, 0x216d6a },
	{ 0xbd42, 0x216d6b },
	{ 0xbd43, 0x216d6c },
	{ 0xbd44, 0x216d6d },
	{ 0xbd45, 0x216d6e },
	{ 0xbd46, 0x216d6f },
	{ 0xbd47, 0x216d70 },
	{ 0xbd48, 0x216d71 },
	{ 0xbd49, 0x216d72 },
	{ 0xbd4a, 0x216d73 },
	{ 0xbd4b, 0x216d74 },
	{ 0xbd4c, 0x216d75 },
	{ 0xbd4d, 0x216d76 },
	{ 0xbd4e, 0x216d77 },
	{ 0xbd4f, 0x216d78 },
	{ 0xbd50, 0x216d79 },
	{ 0xbd51, 0x216d7a },
	{ 0xbd52, 0x216d7b },
	{ 0xbd53, 0x216d7c },
	{ 0xbd54, 0x216d7d },
	{ 0xbd55, 0x216d7e },
	{ 0xbd56, 0x216e21 },
	{ 0xbd57, 0x216e22 },
	{ 0xbd58, 0x216e23 },
	{ 0xbd59, 0x216e24 },
	{ 0xbd5a, 0x216e25 },
	{ 0xbd5b, 0x216e26 },
	{ 0xbd5c, 0x216e27 },
	{ 0xbd5d, 0x216e28 },
	{ 0xbd5e, 0x216e29 },
	{ 0xbd5f, 0x216e2a },
	{ 0xbd60, 0x216e2b },
	{ 0xbd61, 0x216e2c },
	{ 0xbd62, 0x216e2d },
	{ 0xbd63, 0x216e2e },
	{ 0xbd64, 0x216e2f },
	{ 0xbd65, 0x216e30 },
	{ 0xbd66, 0x216e31 },
	{ 0xbd67, 0x216e32 },
	{ 0xbd68, 0x216e33 },
	{ 0xbd69, 0x216e34 },
	{ 0xbd6a, 0x216e35 },
	{ 0xbd6b, 0x216e36 },
	{ 0xbd6c, 0x216e37 },
	{ 0xbd6d, 0x216e38 },
	{ 0xbd6e, 0x216e39 },
	{ 0xbd6f, 0x216e3a },
	{ 0xbd70, 0x216e3b },
	{ 0xbd71, 0x216e3c },
	{ 0xbd72, 0x216e3d },
	{ 0xbd73, 0x216e3e },
	{ 0xbd74, 0x216e3f },
	{ 0xbd75, 0x216e40 },
	{ 0xbd76, 0x216e41 },
	{ 0xbd77, 0x216e42 },
	{ 0xbd78, 0x216e43 },
	{ 0xbd79, 0x216e44 },
	{ 0xbd7a, 0x216e45 },
	{ 0xbd7b, 0x216e46 },
	{ 0xbd7c, 0x216e47 },
	{ 0xbd7d, 0x216e48 },
	{ 0xbd7e, 0x216e49 },
	{ 0xbda1, 0x216e4a },
	{ 0xbda2, 0x216e4b },
	{ 0xbda3, 0x216e4c },
	{ 0xbda4, 0x216e4d },
	{ 0xbda5, 0x216e4e },
	{ 0xbda6, 0x216e4f },
	{ 0xbda7, 0x216e50 },
	{ 0xbda8, 0x216e51 },
	{ 0xbda9, 0x216e52 },
	{ 0xbdaa, 0x216e53 },
	{ 0xbdab, 0x216e54 },
	{ 0xbdac, 0x216e55 },
	{ 0xbdad, 0x216e56 },
	{ 0xbdae, 0x216e57 },
	{ 0xbdaf, 0x216e58 },
	{ 0xbdb0, 0x216e59 },
	{ 0xbdb1, 0x216e5a },
	{ 0xbdb2, 0x216e5b },
	{ 0xbdb3, 0x216e5c },
	{ 0xbdb4, 0x216e5d },
	{ 0xbdb5, 0x216e5e },
	{ 0xbdb6, 0x216e5f },
	{ 0xbdb7, 0x216e60 },
	{ 0xbdb8, 0x216e61 },
	{ 0xbdb9, 0x216e62 },
	{ 0xbdba, 0x216e63 },
	{ 0xbdbb, 0x216e64 },
	{ 0xbdbc, 0x216e65 },
	{ 0xbdbd, 0x216e66 },
	{ 0xbdbe, 0x216e67 },
	{ 0xbdbf, 0x216e68 },
	{ 0xbdc0, 0x216e69 },
	{ 0xbdc1, 0x216e6a },
	{ 0xbdc2, 0x216e6b },
	{ 0xbdc3, 0x216e6c },
	{ 0xbdc4, 0x216e6d },
	{ 0xbdc5, 0x216e6e },
	{ 0xbdc6, 0x216e6f },
	{ 0xbdc7, 0x216e70 },
	{ 0xbdc8, 0x216e71 },
	{ 0xbdc9, 0x216e72 },
	{ 0xbdca, 0x216e73 },
	{ 0xbdcb, 0x216e74 },
	{ 0xbdcc, 0x216e75 },
	{ 0xbdcd, 0x216e76 },
	{ 0xbdce, 0x216e77 },
	{ 0xbdcf, 0x216e78 },
	{ 0xbdd0, 0x216e79 },
	{ 0xbdd1, 0x216e7a },
	{ 0xbdd2, 0x216e7b },
	{ 0xbdd3, 0x216e7c },
	{ 0xbdd4, 0x216e7d },
	{ 0xbdd5, 0x216e7e },
	{ 0xbdd6, 0x216f21 },
	{ 0xbdd7, 0x216f22 },
	{ 0xbdd8, 0x216f23 },
	{ 0xbdd9, 0x216f24 },
	{ 0xbdda, 0x216f25 },
	{ 0xbddb, 0x216f26 },
	{ 0xbddc, 0x216f27 },
	{ 0xbddd, 0x216f28 },
	{ 0xbdde, 0x216f29 },
	{ 0xbddf, 0x216f2a },
	{ 0xbde0, 0x216f2b },
	{ 0xbde1, 0x216f2c },
	{ 0xbde2, 0x216f2d },
	{ 0xbde3, 0x216f2e },
	{ 0xbde4, 0x216f2f },
	{ 0xbde5, 0x216f30 },
	{ 0xbde6, 0x216f31 },
	{ 0xbde7, 0x216f32 },
	{ 0xbde8, 0x216f33 },
	{ 0xbde9, 0x216f34 },
	{ 0xbdea, 0x216f35 },
	{ 0xbdeb, 0x216f36 },
	{ 0xbdec, 0x216f37 },
	{ 0xbded, 0x216f38 },
	{ 0xbdee, 0x216f39 },
	{ 0xbdef, 0x216f3a },
	{ 0xbdf0, 0x216f3b },
	{ 0xbdf1, 0x216f3c },
	{ 0xbdf2, 0x216f3d },
	{ 0xbdf3, 0x216f3e },
	{ 0xbdf4, 0x216f3f },
	{ 0xbdf5, 0x216f40 },
	{ 0xbdf6, 0x216f41 },
	{ 0xbdf7, 0x216f42 },
	{ 0xbdf8, 0x216f43 },
	{ 0xbdf9, 0x216f44 },
	{ 0xbdfa, 0x216f45 },
	{ 0xbdfb, 0x216f46 },
	{ 0xbdfc, 0x216f47 },
	{ 0xbdfd, 0x216f48 },
	{ 0xbdfe, 0x216f49 },
	{ 0xbe40, 0x216f4a },
	{ 0xbe41, 0x216f4b },
	{ 0xbe42, 0x216f4c },
	{ 0xbe43, 0x216f4d },
	{ 0xbe44, 0x216f4e },
	{ 0xbe45, 0x216f4f },
	{ 0xbe46, 0x216f50 },
	{ 0xbe47, 0x216f51 },
	{ 0xbe48, 0x216f52 },
	{ 0xbe49, 0x216f53 },
	{ 0xbe4a, 0x216f54 },
	{ 0xbe4b, 0x216f55 },
	{ 0xbe4c, 0x216f56 },
	{ 0xbe4d, 0x216f57 },
	{ 0xbe4e, 0x216f58 },
	{ 0xbe4f, 0x216f59 },
	{ 0xbe50, 0x216f5a },
	{ 0xbe51, 0x216f5b },
	{ 0xbe52, 0x216b50 },
	{ 0xbe53, 0x216f5c },
	{ 0xbe54, 0x216f5d },
	{ 0xbe55, 0x216f5e },
	{ 0xbe56, 0x216f5f },
	{ 0xbe57, 0x216f60 },
	{ 0xbe58, 0x216f61 },
	{ 0xbe59, 0x216f62 },
	{ 0xbe5a, 0x216f63 },
	{ 0xbe5b, 0x216f64 },
	{ 0xbe5c, 0x216f65 },
	{ 0xbe5d, 0x216f66 },
	{ 0xbe5e, 0x216f67 },
	{ 0xbe5f, 0x216f68 },
	{ 0xbe60, 0x216f69 },
	{ 0xbe61, 0x216f6a },
	{ 0xbe62, 0x216f6b },
	{ 0xbe63, 0x216f6c },
	{ 0xbe64, 0x216f6d },
	{ 0xbe65, 0x216f6e },
	{ 0xbe66, 0x216f6f },
	{ 0xbe67, 0x216f70 },
	{ 0xbe68, 0x216f71 },
	{ 0xbe69, 0x216f72 },
	{ 0xbe6a, 0x216f73 },
	{ 0xbe6b, 0x216f74 },
	{ 0xbe6c, 0x216f75 },
	{ 0xbe6d, 0x216f76 },
	{ 0xbe6e, 0x216f77 },
	{ 0xbe6f, 0x216f78 },
	{ 0xbe70, 0x216f79 },
	{ 0xbe71, 0x216f7a },
	{ 0xbe72, 0x216f7b },
	{ 0xbe73, 0x216f7c },
	{ 0xbe74, 0x216f7d },
	{ 0xbe75, 0x216f7e },
	{ 0xbe76, 0x217021 },
	{ 0xbe77, 0x217022 },
	{ 0xbe78, 0x217023 },
	{ 0xbe79, 0x217024 },
	{ 0xbe7a, 0x217025 },
	{ 0xbe7b, 0x217026 },
	{ 0xbe7c, 0x217027 },
	{ 0xbe7d, 0x217028 },
	{ 0xbe7e, 0x217029 },
	{ 0xbea1, 0x21702a },
	{ 0xbea2, 0x21702b },
	{ 0xbea3, 0x21702c },
	{ 0xbea4, 0x21702d },
	{ 0xbea5, 0x21702e },
	{ 0xbea6, 0x21702f },
	{ 0xbea7, 0x217030 },
	{ 0xbea8, 0x217031 },
	{ 0xbea9, 0x217032 },
	{ 0xbeaa, 0x217033 },
	{ 0xbeab, 0x217034 },
	{ 0xbeac, 0x217035 },
	{ 0xbead, 0x217036 },
	{ 0xbeae, 0x217037 },
	{ 0xbeaf, 0x217038 },
	{ 0xbeb0, 0x217039 },
	{ 0xbeb1, 0x21703a },
	{ 0xbeb2, 0x21703b },
	{ 0xbeb3, 0x21703c },
	{ 0xbeb4, 0x21703d },
	{ 0xbeb5, 0x21703e },
	{ 0xbeb6, 0x21703f },
	{ 0xbeb7, 0x217040 },
	{ 0xbeb8, 0x217041 },
	{ 0xbeb9, 0x217042 },
	{ 0xbeba, 0x217043 },
	{ 0xbebb, 0x217044 },
	{ 0xbebc, 0x217045 },
	{ 0xbebd, 0x217046 },
	{ 0xbebe, 0x217047 },
	{ 0xbebf, 0x217048 },
	{ 0xbec0, 0x217049 },
	{ 0xbec1, 0x21704a },
	{ 0xbec2, 0x21704b },
	{ 0xbec3, 0x21704c },
	{ 0xbec4, 0x21704d },
	{ 0xbec5, 0x21704e },
	{ 0xbec6, 0x21704f },
	{ 0xbec7, 0x217050 },
	{ 0xbec8, 0x217051 },
	{ 0xbec9, 0x217052 },
	{ 0xbeca, 0x217053 },
	{ 0xbecb, 0x217054 },
	{ 0xbecc, 0x217055 },
	{ 0xbecd, 0x217056 },
	{ 0xbece, 0x217057 },
	{ 0xbecf, 0x217058 },
	{ 0xbed0, 0x217059 },
	{ 0xbed1, 0x21705a },
	{ 0xbed2, 0x21705b },
	{ 0xbed3, 0x21705c },
	{ 0xbed4, 0x21705d },
	{ 0xbed5, 0x21705e },
	{ 0xbed6, 0x21705f },
	{ 0xbed7, 0x217060 },
	{ 0xbed8, 0x217061 },
	{ 0xbed9, 0x217062 },
	{ 0xbeda, 0x217063 },
	{ 0xbedb, 0x217064 },
	{ 0xbedc, 0x217065 },
	{ 0xbedd, 0x217066 },
	{ 0xbede, 0x217067 },
	{ 0xbedf, 0x217068 },
	{ 0xbee0, 0x217069 },
	{ 0xbee1, 0x21706a },
	{ 0xbee2, 0x21706b },
	{ 0xbee3, 0x21706c },
	{ 0xbee4, 0x21706d },
	{ 0xbee5, 0x21706e },
	{ 0xbee6, 0x21706f },
	{ 0xbee7, 0x217070 },
	{ 0xbee8, 0x217071 },
	{ 0xbee9, 0x217072 },
	{ 0xbeea, 0x217073 },
	{ 0xbeeb, 0x217074 },
	{ 0xbeec, 0x217075 },
	{ 0xbeed, 0x217076 },
	{ 0xbeee, 0x217077 },
	{ 0xbeef, 0x217078 },
	{ 0xbef0, 0x217079 },
	{ 0xbef1, 0x21707a },
	{ 0xbef2, 0x21707b },
	{ 0xbef3, 0x21707c },
	{ 0xbef4, 0x21707d },
	{ 0xbef5, 0x21707e },
	{ 0xbef6, 0x217121 },
	{ 0xbef7, 0x217122 },
	{ 0xbef8, 0x217123 },
	{ 0xbef9, 0x217124 },
	{ 0xbefa, 0x217125 },
	{ 0xbefb, 0x217126 },
	{ 0xbefc, 0x217127 },
	{ 0xbefd, 0x217128 },
	{ 0xbefe, 0x217129 },
	{ 0xbf40, 0x21712a },
	{ 0xbf41, 0x21712b },
	{ 0xbf42, 0x21712c },
	{ 0xbf43, 0x21712d },
	{ 0xbf44, 0x21712e },
	{ 0xbf45, 0x21712f },
	{ 0xbf46, 0x217130 },
	{ 0xbf47, 0x217131 },
	{ 0xbf48, 0x217132 },
	{ 0xbf49, 0x217133 },
	{ 0xbf4a, 0x217134 },
	{ 0xbf4b, 0x217135 },
	{ 0xbf4c, 0x217136 },
	{ 0xbf4d, 0x217137 },
	{ 0xbf4e, 0x217138 },
	{ 0xbf4f, 0x217139 },
	{ 0xbf50, 0x21713a },
	{ 0xbf51, 0x21713b },
	{ 0xbf52, 0x21713c },
	{ 0xbf53, 0x21713d },
	{ 0xbf54, 0x21713e },
	{ 0xbf55, 0x21713f },
	{ 0xbf56, 0x217140 },
	{ 0xbf57, 0x217141 },
	{ 0xbf58, 0x217142 },
	{ 0xbf59, 0x217143 },
	{ 0xbf5a, 0x217144 },
	{ 0xbf5b, 0x217145 },
	{ 0xbf5c, 0x217146 },
	{ 0xbf5d, 0x217147 },
	{ 0xbf5e, 0x217148 },
	{ 0xbf5f, 0x217149 },
	{ 0xbf60, 0x21714a },
	{ 0xbf61, 0x21714b },
	{ 0xbf62, 0x21714c },
	{ 0xbf63, 0x21714d },
	{ 0xbf64, 0x21714e },
	{ 0xbf65, 0x21714f },
	{ 0xbf66, 0x217150 },
	{ 0xbf67, 0x217151 },
	{ 0xbf68, 0x217152 },
	{ 0xbf69, 0x217153 },
	{ 0xbf6a, 0x217154 },
	{ 0xbf6b, 0x217155 },
	{ 0xbf6c, 0x217156 },
	{ 0xbf6d, 0x217157 },
	{ 0xbf6e, 0x217158 },
	{ 0xbf6f, 0x217159 },
	{ 0xbf70, 0x21715a },
	{ 0xbf71, 0x21715b },
	{ 0xbf72, 0x21715c },
	{ 0xbf73, 0x21715d },
	{ 0xbf74, 0x21715e },
	{ 0xbf75, 0x21715f },
	{ 0xbf76, 0x217160 },
	{ 0xbf77, 0x217161 },
	{ 0xbf78, 0x217162 },
	{ 0xbf79, 0x217163 },
	{ 0xbf7a, 0x217164 },
	{ 0xbf7b, 0x217165 },
	{ 0xbf7c, 0x217166 },
	{ 0xbf7d, 0x217167 },
	{ 0xbf7e, 0x217168 },
	{ 0xbfa1, 0x217169 },
	{ 0xbfa2, 0x21716a },
	{ 0xbfa3, 0x21716b },
	{ 0xbfa4, 0x21716c },
	{ 0xbfa5, 0x21716d },
	{ 0xbfa6, 0x21716e },
	{ 0xbfa7, 0x21716f },
	{ 0xbfa8, 0x217170 },
	{ 0xbfa9, 0x217171 },
	{ 0xbfaa, 0x217172 },
	{ 0xbfab, 0x217173 },
	{ 0xbfac, 0x217174 },
	{ 0xbfad, 0x217175 },
	{ 0xbfae, 0x217176 },
	{ 0xbfaf, 0x217177 },
	{ 0xbfb0, 0x217178 },
	{ 0xbfb1, 0x217179 },
	{ 0xbfb2, 0x21717a },
	{ 0xbfb3, 0x21717b },
	{ 0xbfb4, 0x21717c },
	{ 0xbfb5, 0x21717d },
	{ 0xbfb6, 0x21717e },
	{ 0xbfb7, 0x217221 },
	{ 0xbfb8, 0x217222 },
	{ 0xbfb9, 0x217223 },
	{ 0xbfba, 0x217224 },
	{ 0xbfbb, 0x217225 },
	{ 0xbfbc, 0x217226 },
	{ 0xbfbd, 0x217227 },
	{ 0xbfbe, 0x217228 },
	{ 0xbfbf, 0x217229 },
	{ 0xbfc0, 0x21722a },
	{ 0xbfc1, 0x21722b },
	{ 0xbfc2, 0x21722c },
	{ 0xbfc3, 0x21722d },
	{ 0xbfc4, 0x21722e },
	{ 0xbfc5, 0x21722f },
	{ 0xbfc6, 0x217230 },
	{ 0xbfc7, 0x217231 },
	{ 0xbfc8, 0x217232 },
	{ 0xbfc9, 0x217233 },
	{ 0xbfca, 0x217234 },
	{ 0xbfcb, 0x217235 },
	{ 0xbfcc, 0x217236 },
	{ 0xbfcd, 0x217237 },
	{ 0xbfce, 0x217238 },
	{ 0xbfcf, 0x217239 },
	{ 0xbfd0, 0x21723a },
	{ 0xbfd1, 0x21723b },
	{ 0xbfd2, 0x21723c },
	{ 0xbfd3, 0x21723d },
	{ 0xbfd4, 0x21723e },
	{ 0xbfd5, 0x21723f },
	{ 0xbfd6, 0x217240 },
	{ 0xbfd7, 0x217241 },
	{ 0xbfd8, 0x217242 },
	{ 0xbfd9, 0x217243 },
	{ 0xbfda, 0x217244 },
	{ 0xbfdb, 0x217245 },
	{ 0xbfdc, 0x217246 },
	{ 0xbfdd, 0x217247 },
	{ 0xbfde, 0x217248 },
	{ 0xbfdf, 0x217249 },
	{ 0xbfe0, 0x21724a },
	{ 0xbfe1, 0x21724b },
	{ 0xbfe2, 0x21724c },
	{ 0xbfe3, 0x21724d },
	{ 0xbfe4, 0x21724e },
	{ 0xbfe5, 0x21724f },
	{ 0xbfe6, 0x217250 },
	{ 0xbfe7, 0x217251 },
	{ 0xbfe8, 0x217252 },
	{ 0xbfe9, 0x217253 },
	{ 0xbfea, 0x217254 },
	{ 0xbfeb, 0x217255 },
	{ 0xbfec, 0x217256 },
	{ 0xbfed, 0x217257 },
	{ 0xbfee, 0x217258 },
	{ 0xbfef, 0x217259 },
	{ 0xbff0, 0x21725a },
	{ 0xbff1, 0x21725b },
	{ 0xbff2, 0x21725c },
	{ 0xbff3, 0x21725d },
	{ 0xbff4, 0x21725e },
	{ 0xbff5, 0x21725f },
	{ 0xbff6, 0x217260 },
	{ 0xbff7, 0x217261 },
	{ 0xbff8, 0x217262 },
	{ 0xbff9, 0x217263 },
	{ 0xbffa, 0x217264 },
	{ 0xbffb, 0x217265 },
	{ 0xbffc, 0x217266 },
	{ 0xbffd, 0x217267 },
	{ 0xbffe, 0x217268 },
	{ 0xc040, 0x217269 },
	{ 0xc041, 0x21726a },
	{ 0xc042, 0x21726b },
	{ 0xc043, 0x21726c },
	{ 0xc044, 0x21726d },
	{ 0xc045, 0x21726e },
	{ 0xc046, 0x21726f },
	{ 0xc047, 0x217270 },
	{ 0xc048, 0x217271 },
	{ 0xc049, 0x217272 },
	{ 0xc04a, 0x217273 },
	{ 0xc04b, 0x217274 },
	{ 0xc04c, 0x217275 },
	{ 0xc04d, 0x217276 },
	{ 0xc04e, 0x217277 },
	{ 0xc04f, 0x217278 },
	{ 0xc050, 0x217279 },
	{ 0xc051, 0x21727a },
	{ 0xc052, 0x21727b },
	{ 0xc053, 0x21727c },
	{ 0xc054, 0x21727d },
	{ 0xc055, 0x21727e },
	{ 0xc056, 0x217321 },
	{ 0xc057, 0x217322 },
	{ 0xc058, 0x217323 },
	{ 0xc059, 0x217324 },
	{ 0xc05a, 0x217325 },
	{ 0xc05b, 0x217326 },
	{ 0xc05c, 0x217327 },
	{ 0xc05d, 0x217328 },
	{ 0xc05e, 0x217329 },
	{ 0xc05f, 0x21732a },
	{ 0xc060, 0x21732b },
	{ 0xc061, 0x21732c },
	{ 0xc062, 0x21732d },
	{ 0xc063, 0x21732e },
	{ 0xc064, 0x21732f },
	{ 0xc065, 0x217330 },
	{ 0xc066, 0x217331 },
	{ 0xc067, 0x217332 },
	{ 0xc068, 0x217333 },
	{ 0xc069, 0x217334 },
	{ 0xc06a, 0x217335 },
	{ 0xc06b, 0x217336 },
	{ 0xc06c, 0x217337 },
	{ 0xc06d, 0x217338 },
	{ 0xc06e, 0x217339 },
	{ 0xc06f, 0x21733a },
	{ 0xc070, 0x21733b },
	{ 0xc071, 0x21733c },
	{ 0xc072, 0x21733d },
	{ 0xc073, 0x21733e },
	{ 0xc074, 0x21733f },
	{ 0xc075, 0x217340 },
	{ 0xc076, 0x217341 },
	{ 0xc077, 0x217342 },
	{ 0xc078, 0x217343 },
	{ 0xc079, 0x217344 },
	{ 0xc07a, 0x217345 },
	{ 0xc07b, 0x217346 },
	{ 0xc07c, 0x217347 },
	{ 0xc07d, 0x217348 },
	{ 0xc07e, 0x217349 },
	{ 0xc0a1, 0x21734a },
	{ 0xc0a2, 0x21734b },
	{ 0xc0a3, 0x21734c },
	{ 0xc0a4, 0x21734d },
	{ 0xc0a5, 0x21734e },
	{ 0xc0a6, 0x21734f },
	{ 0xc0a7, 0x217350 },
	{ 0xc0a8, 0x217351 },
	{ 0xc0a9, 0x217352 },
	{ 0xc0aa, 0x217353 },
	{ 0xc0ab, 0x217354 },
	{ 0xc0ac, 0x217355 },
	{ 0xc0ad, 0x217356 },
	{ 0xc0ae, 0x217357 },
	{ 0xc0af, 0x217358 },
	{ 0xc0b0, 0x217359 },
	{ 0xc0b1, 0x21735a },
	{ 0xc0b2, 0x21735b },
	{ 0xc0b3, 0x21735c },
	{ 0xc0b4, 0x21735d },
	{ 0xc0b5, 0x21735e },
	{ 0xc0b6, 0x21735f },
	{ 0xc0b7, 0x217360 },
	{ 0xc0b8, 0x217361 },
	{ 0xc0b9, 0x217362 },
	{ 0xc0ba, 0x217363 },
	{ 0xc0bb, 0x217364 },
	{ 0xc0bc, 0x217365 },
	{ 0xc0bd, 0x217366 },
	{ 0xc0be, 0x217367 },
	{ 0xc0bf, 0x217368 },
	{ 0xc0c0, 0x217369 },
	{ 0xc0c1, 0x21736a },
	{ 0xc0c2, 0x21736b },
	{ 0xc0c3, 0x21736c },
	{ 0xc0c4, 0x21736d },
	{ 0xc0c5, 0x21736e },
	{ 0xc0c6, 0x21736f },
	{ 0xc0c7, 0x217370 },
	{ 0xc0c8, 0x217371 },
	{ 0xc0c9, 0x217372 },
	{ 0xc0ca, 0x217373 },
	{ 0xc0cb, 0x217374 },
	{ 0xc0cc, 0x217375 },
	{ 0xc0cd, 0x217376 },
	{ 0xc0ce, 0x217377 },
	{ 0xc0cf, 0x217378 },
	{ 0xc0d0, 0x217379 },
	{ 0xc0d1, 0x21737a },
	{ 0xc0d2, 0x21737b },
	{ 0xc0d3, 0x21737c },
	{ 0xc0d4, 0x21737d },
	{ 0xc0d5, 0x21737e },
	{ 0xc0d6, 0x217421 },
	{ 0xc0d7, 0x217422 },
	{ 0xc0d8, 0x217423 },
	{ 0xc0d9, 0x217424 },
	{ 0xc0da, 0x217425 },
	{ 0xc0db, 0x217426 },
	{ 0xc0dc, 0x217427 },
	{ 0xc0dd, 0x217428 },
	{ 0xc0de, 0x217429 },
	{ 0xc0df, 0x21742a },
	{ 0xc0e0, 0x21742b },
	{ 0xc0e1, 0x21742c },
	{ 0xc0e2, 0x21742d },
	{ 0xc0e3, 0x21742e },
	{ 0xc0e4, 0x21742f },
	{ 0xc0e5, 0x217430 },
	{ 0xc0e6, 0x217431 },
	{ 0xc0e7, 0x217432 },
	{ 0xc0e8, 0x217433 },
	{ 0xc0e9, 0x217434 },
	{ 0xc0ea, 0x217435 },
	{ 0xc0eb, 0x217436 },
	{ 0xc0ec, 0x217437 },
	{ 0xc0ed, 0x217438 },
	{ 0xc0ee, 0x217439 },
	{ 0xc0ef, 0x21743a },
	{ 0xc0f0, 0x21743b },
	{ 0xc0f1, 0x21743c },
	{ 0xc0f2, 0x21743d },
	{ 0xc0f3, 0x21743e },
	{ 0xc0f4, 0x21743f },
	{ 0xc0f5, 0x217440 },
	{ 0xc0f6, 0x217441 },
	{ 0xc0f7, 0x217442 },
	{ 0xc0f8, 0x217443 },
	{ 0xc0f9, 0x217444 },
	{ 0xc0fa, 0x217445 },
	{ 0xc0fb, 0x217446 },
	{ 0xc0fc, 0x217447 },
	{ 0xc0fd, 0x217448 },
	{ 0xc0fe, 0x217449 },
	{ 0xc140, 0x21744a },
	{ 0xc141, 0x21744b },
	{ 0xc142, 0x21744c },
	{ 0xc143, 0x21744d },
	{ 0xc144, 0x21744e },
	{ 0xc145, 0x21744f },
	{ 0xc146, 0x217450 },
	{ 0xc147, 0x217451 },
	{ 0xc148, 0x217452 },
	{ 0xc149, 0x217453 },
	{ 0xc14a, 0x217454 },
	{ 0xc14b, 0x217455 },
	{ 0xc14c, 0x217456 },
	{ 0xc14d, 0x217457 },
	{ 0xc14e, 0x217458 },
	{ 0xc14f, 0x217459 },
	{ 0xc150, 0x21745a },
	{ 0xc151, 0x21745b },
	{ 0xc152, 0x21745c },
	{ 0xc153, 0x21745d },
	{ 0xc154, 0x21745e },
	{ 0xc155, 0x21745f },
	{ 0xc156, 0x217460 },
	{ 0xc157, 0x217461 },
	{ 0xc158, 0x217462 },
	{ 0xc159, 0x217463 },
	{ 0xc15a, 0x217464 },
	{ 0xc15b, 0x217465 },
	{ 0xc15c, 0x217466 },
	{ 0xc15d, 0x217467 },
	{ 0xc15e, 0x217468 },
	{ 0xc15f, 0x217469 },
	{ 0xc160, 0x21746a },
	{ 0xc161, 0x21746b },
	{ 0xc162, 0x21746c },
	{ 0xc163, 0x21746d },
	{ 0xc164, 0x21746e },
	{ 0xc165, 0x21746f },
	{ 0xc166, 0x217470 },
	{ 0xc167, 0x217471 },
	{ 0xc168, 0x217472 },
	{ 0xc169, 0x217473 },
	{ 0xc16a, 0x217474 },
	{ 0xc16b, 0x217475 },
	{ 0xc16c, 0x217476 },
	{ 0xc16d, 0x217477 },
	{ 0xc16e, 0x217478 },
	{ 0xc16f, 0x217479 },
	{ 0xc170, 0x21747a },
	{ 0xc171, 0x21747b },
	{ 0xc172, 0x21747c },
	{ 0xc173, 0x21747d },
	{ 0xc174, 0x21747e },
	{ 0xc175, 0x217521 },
	{ 0xc176, 0x217522 },
	{ 0xc177, 0x217523 },
	{ 0xc178, 0x217524 },
	{ 0xc179, 0x217525 },
	{ 0xc17a, 0x217526 },
	{ 0xc17b, 0x217527 },
	{ 0xc17c, 0x217528 },
	{ 0xc17d, 0x217529 },
	{ 0xc17e, 0x21752a },
	{ 0xc1a1, 0x21752b },
	{ 0xc1a2, 0x21752c },
	{ 0xc1a3, 0x21752d },
	{ 0xc1a4, 0x21752e },
	{ 0xc1a5, 0x21752f },
	{ 0xc1a6, 0x217530 },
	{ 0xc1a7, 0x217531 },
	{ 0xc1a8, 0x217532 },
	{ 0xc1a9, 0x217533 },
	{ 0xc1aa, 0x217534 },
	{ 0xc1ab, 0x217536 },
	{ 0xc1ac, 0x217537 },
	{ 0xc1ad, 0x217538 },
	{ 0xc1ae, 0x217539 },
	{ 0xc1af, 0x21753a },
	{ 0xc1b0, 0x21753b },
	{ 0xc1b1, 0x21753c },
	{ 0xc1b2, 0x21753d },
	{ 0xc1b3, 0x21753e },
	{ 0xc1b4, 0x21753f },
	{ 0xc1b5, 0x217540 },
	{ 0xc1b6, 0x217541 },
	{ 0xc1b7, 0x217542 },
	{ 0xc1b8, 0x217543 },
	{ 0xc1b9, 0x217544 },
	{ 0xc1ba, 0x217545 },
	{ 0xc1bb, 0x217546 },
	{ 0xc1bc, 0x217547 },
	{ 0xc1bd, 0x217548 },
	{ 0xc1be, 0x217549 },
	{ 0xc1bf, 0x21754a },
	{ 0xc1c0, 0x21754b },
	{ 0xc1c1, 0x21754c },
	{ 0xc1c2, 0x21754d },
	{ 0xc1c3, 0x21754e },
	{ 0xc1c4, 0x21754f },
	{ 0xc1c5, 0x217550 },
	{ 0xc1c6, 0x217551 },
	{ 0xc1c7, 0x217552 },
	{ 0xc1c8, 0x217553 },
	{ 0xc1c9, 0x217554 },
	{ 0xc1ca, 0x217555 },
	{ 0xc1cb, 0x217556 },
	{ 0xc1cc, 0x217557 },
	{ 0xc1cd, 0x217558 },
	{ 0xc1ce, 0x217559 },
	{ 0xc1cf, 0x21755a },
	{ 0xc1d0, 0x21755b },
	{ 0xc1d1, 0x21755c },
	{ 0xc1d2, 0x21755d },
	{ 0xc1d3, 0x21755e },
	{ 0xc1d4, 0x21755f },
	{ 0xc1d5, 0x217560 },
	{ 0xc1d6, 0x217561 },
	{ 0xc1d7, 0x217562 },
	{ 0xc1d8, 0x217563 },
	{ 0xc1d9, 0x217564 },
	{ 0xc1da, 0x217565 },
	{ 0xc1db, 0x217566 },
	{ 0xc1dc, 0x217567 },
	{ 0xc1dd, 0x217568 },
	{ 0xc1de, 0x217569 },
	{ 0xc1df, 0x21756a },
	{ 0xc1e0, 0x21756b },
	{ 0xc1e1, 0x21756c },
	{ 0xc1e2, 0x21756d },
	{ 0xc1e3, 0x21756e },
	{ 0xc1e4, 0x21756f },
	{ 0xc1e5, 0x217570 },
	{ 0xc1e6, 0x217571 },
	{ 0xc1e7, 0x217572 },
	{ 0xc1e8, 0x217573 },
	{ 0xc1e9, 0x217574 },
	{ 0xc1ea, 0x217575 },
	{ 0xc1eb, 0x217576 },
	{ 0xc1ec, 0x217577 },
	{ 0xc1ed, 0x217578 },
	{ 0xc1ee, 0x217579 },
	{ 0xc1ef, 0x21757a },
	{ 0xc1f0, 0x21757b },
	{ 0xc1f1, 0x21757c },
	{ 0xc1f2, 0x21757d },
	{ 0xc1f3, 0x21757e },
	{ 0xc1f4, 0x217621 },
	{ 0xc1f5, 0x217622 },
	{ 0xc1f6, 0x217623 },
	{ 0xc1f7, 0x217624 },
	{ 0xc1f8, 0x217625 },
	{ 0xc1f9, 0x217626 },
	{ 0xc1fa, 0x217627 },
	{ 0xc1fb, 0x217628 },
	{ 0xc1fc, 0x217629 },
	{ 0xc1fd, 0x21762a },
	{ 0xc1fe, 0x21762b },
	{ 0xc240, 0x21762c },
	{ 0xc241, 0x21762d },
	{ 0xc242, 0x21762e },
	{ 0xc243, 0x21762f },
	{ 0xc244, 0x217630 },
	{ 0xc245, 0x217631 },
	{ 0xc246, 0x217632 },
	{ 0xc247, 0x217633 },
	{ 0xc248, 0x217634 },
	{ 0xc249, 0x217635 },
	{ 0xc24a, 0x217636 },
	{ 0xc24b, 0x217637 },
	{ 0xc24c, 0x217638 },
	{ 0xc24d, 0x217639 },
	{ 0xc24e, 0x21763a },
	{ 0xc24f, 0x21763b },
	{ 0xc250, 0x21763c },
	{ 0xc251, 0x21763d },
	{ 0xc252, 0x21763e },
	{ 0xc253, 0x21763f },
	{ 0xc254, 0x217640 },
	{ 0xc255, 0x235764 },
	{ 0xc256, 0x217642 },
	{ 0xc257, 0x217643 },
	{ 0xc258, 0x217644 },
	{ 0xc259, 0x217645 },
	{ 0xc25a, 0x217646 },
	{ 0xc25b, 0x217647 },
	{ 0xc25c, 0x217648 },
	{ 0xc25d, 0x217649 },
	{ 0xc25e, 0x21764a },
	{ 0xc25f, 0x21764b },
	{ 0xc260, 0x21764c },
	{ 0xc261, 0x21764d },
	{ 0xc262, 0x21764e },
	{ 0xc263, 0x21764f },
	{ 0xc264, 0x217650 },
	{ 0xc265, 0x217651 },
	{ 0xc266, 0x217652 },
	{ 0xc267, 0x217653 },
	{ 0xc268, 0x217654 },
	{ 0xc269, 0x217655 },
	{ 0xc26a, 0x217656 },
	{ 0xc26b, 0x217657 },
	{ 0xc26c, 0x217658 },
	{ 0xc26d, 0x217659 },
	{ 0xc26e, 0x21765a },
	{ 0xc26f, 0x21765b },
	{ 0xc270, 0x21765c },
	{ 0xc271, 0x21765d },
	{ 0xc272, 0x21765e },
	{ 0xc273, 0x21765f },
	{ 0xc274, 0x217660 },
	{ 0xc275, 0x217661 },
	{ 0xc276, 0x217662 },
	{ 0xc277, 0x217663 },
	{ 0xc278, 0x217664 },
	{ 0xc279, 0x217665 },
	{ 0xc27a, 0x217666 },
	{ 0xc27b, 0x217667 },
	{ 0xc27c, 0x217668 },
	{ 0xc27d, 0x217669 },
	{ 0xc27e, 0x21766a },
	{ 0xc2a1, 0x21766b },
	{ 0xc2a2, 0x21766c },
	{ 0xc2a3, 0x21766d },
	{ 0xc2a4, 0x21766e },
	{ 0xc2a5, 0x21766f },
	{ 0xc2a6, 0x217670 },
	{ 0xc2a7, 0x217671 },
	{ 0xc2a8, 0x217672 },
	{ 0xc2a9, 0x217673 },
	{ 0xc2aa, 0x217674 },
	{ 0xc2ab, 0x217675 },
	{ 0xc2ac, 0x217676 },
	{ 0xc2ad, 0x217677 },
	{ 0xc2ae, 0x217678 },
	{ 0xc2af, 0x217679 },
	{ 0xc2b0, 0x21767a },
	{ 0xc2b1, 0x21767b },
	{ 0xc2b2, 0x21767c },
	{ 0xc2b3, 0x21767d },
	{ 0xc2b4, 0x21767e },
	{ 0xc2b5, 0x217721 },
	{ 0xc2b6, 0x217722 },
	{ 0xc2b7, 0x217723 },
	{ 0xc2b8, 0x217724 },
	{ 0xc2b9, 0x217725 },
	{ 0xc2ba, 0x217726 },
	{ 0xc2bb, 0x217727 },
	{ 0xc2bc, 0x217728 },
	{ 0xc2bd, 0x217729 },
	{ 0xc2be, 0x21772a },
	{ 0xc2bf, 0x21772b },
	{ 0xc2c0, 0x21772c },
	{ 0xc2c1, 0x21772d },
	{ 0xc2c2, 0x21772e },
	{ 0xc2c3, 0x21772f },
	{ 0xc2c4, 0x217730 },
	{ 0xc2c5, 0x217731 },
	{ 0xc2c6, 0x217732 },
	{ 0xc2c7, 0x217733 },
	{ 0xc2c8, 0x217734 },
	{ 0xc2c9, 0x217735 },
	{ 0xc2ca, 0x217736 },
	{ 0xc2cb, 0x217535 },
	{ 0xc2cc, 0x217737 },
	{ 0xc2cd, 0x217738 },
	{ 0xc2ce, 0x217739 },
	{ 0xc2cf, 0x21773a },
	{ 0xc2d0, 0x21773b },
	{ 0xc2d1, 0x21773c },
	{ 0xc2d2, 0x21773d },
	{ 0xc2d3, 0x21773e },
	{ 0xc2d4, 0x21773f },
	{ 0xc2d5, 0x217740 },
	{ 0xc2d6, 0x217741 },
	{ 0xc2d7, 0x217742 },
	{ 0xc2d8, 0x217743 },
	{ 0xc2d9, 0x217744 },
	{ 0xc2da, 0x217745 },
	{ 0xc2db, 0x217746 },
	{ 0xc2dc, 0x217747 },
	{ 0xc2dd, 0x217748 },
	{ 0xc2de, 0x217749 },
	{ 0xc2df, 0x21774a },
	{ 0xc2e0, 0x21774b },
	{ 0xc2e1, 0x21774c },
	{ 0xc2e2, 0x21774d },
	{ 0xc2e3, 0x21774e },
	{ 0xc2e4, 0x21774f },
	{ 0xc2e5, 0x217750 },
	{ 0xc2e6, 0x217751 },
	{ 0xc2e7, 0x217752 },
	{ 0xc2e8, 0x217753 },
	{ 0xc2e9, 0x217754 },
	{ 0xc2ea, 0x217755 },
	{ 0xc2eb, 0x217756 },
	{ 0xc2ec, 0x217757 },
	{ 0xc2ed, 0x217758 },
	{ 0xc2ee, 0x217759 },
	{ 0xc2ef, 0x21775a },
	{ 0xc2f0, 0x21775b },
	{ 0xc2f1, 0x21775c },
	{ 0xc2f2, 0x21775d },
	{ 0xc2f3, 0x21775e },
	{ 0xc2f4, 0x21775f },
	{ 0xc2f5, 0x217760 },
	{ 0xc2f6, 0x217761 },
	{ 0xc2f7, 0x217762 },
	{ 0xc2f8, 0x217763 },
	{ 0xc2f9, 0x217764 },
	{ 0xc2fa, 0x217765 },
	{ 0xc2fb, 0x217766 },
	{ 0xc2fc, 0x217767 },
	{ 0xc2fd, 0x217768 },
	{ 0xc2fe, 0x217769 },
	{ 0xc340, 0x21776a },
	{ 0xc341, 0x21776b },
	{ 0xc342, 0x21776c },
	{ 0xc343, 0x21776d },
	{ 0xc344, 0x21776e },
	{ 0xc345, 0x21776f },
	{ 0xc346, 0x217770 },
	{ 0xc347, 0x217771 },
	{ 0xc348, 0x217772 },
	{ 0xc349, 0x217773 },
	{ 0xc34a, 0x217774 },
	{ 0xc34b, 0x217775 },
	{ 0xc34c, 0x217776 },
	{ 0xc34d, 0x217777 },
	{ 0xc34e, 0x217778 },
	{ 0xc34f, 0x217779 },
	{ 0xc350, 0x21777a },
	{ 0xc351, 0x21777b },
	{ 0xc352, 0x21777c },
	{ 0xc353, 0x21777d },
	{ 0xc354, 0x21777e },
	{ 0xc355, 0x217821 },
	{ 0xc356, 0x217822 },
	{ 0xc357, 0x217823 },
	{ 0xc358, 0x217824 },
	{ 0xc359, 0x217825 },
	{ 0xc35a, 0x217826 },
	{ 0xc35b, 0x217827 },
	{ 0xc35c, 0x217828 },
	{ 0xc35d, 0x217829 },
	{ 0xc35e, 0x21782a },
	{ 0xc35f, 0x21782b },
	{ 0xc360, 0x21782c },
	{ 0xc361, 0x21782e },
	{ 0xc362, 0x21782f },
	{ 0xc363, 0x217830 },
	{ 0xc364, 0x217831 },
	{ 0xc365, 0x217832 },
	{ 0xc366, 0x217833 },
	{ 0xc367, 0x217834 },
	{ 0xc368, 0x217835 },
	{ 0xc369, 0x217836 },
	{ 0xc36a, 0x217837 },
	{ 0xc36b, 0x217838 },
	{ 0xc36c, 0x217839 },
	{ 0xc36d, 0x21783a },
	{ 0xc36e, 0x21783b },
	{ 0xc36f, 0x21783c },
	{ 0xc370, 0x21783d },
	{ 0xc371, 0x21783e },
	{ 0xc372, 0x21783f },
	{ 0xc373, 0x217840 },
	{ 0xc374, 0x217841 },
	{ 0xc375, 0x217842 },
	{ 0xc376, 0x217843 },
	{ 0xc377, 0x217844 },
	{ 0xc378, 0x217845 },
	{ 0xc379, 0x217846 },
	{ 0xc37a, 0x217847 },
	{ 0xc37b, 0x217848 },
	{ 0xc37c, 0x217849 },
	{ 0xc37d, 0x21784a },
	{ 0xc37e, 0x21784b },
	{ 0xc3a1, 0x21784c },
	{ 0xc3a2, 0x21784d },
	{ 0xc3a3, 0x21784e },
	{ 0xc3a4, 0x21784f },
	{ 0xc3a5, 0x217850 },
	{ 0xc3a6, 0x217851 },
	{ 0xc3a7, 0x217852 },
	{ 0xc3a8, 0x217853 },
	{ 0xc3a9, 0x217854 },
	{ 0xc3aa, 0x217855 },
	{ 0xc3ab, 0x217856 },
	{ 0xc3ac, 0x217857 },
	{ 0xc3ad, 0x217858 },
	{ 0xc3ae, 0x217859 },
	{ 0xc3af, 0x21785a },
	{ 0xc3b0, 0x21785b },
	{ 0xc3b1, 0x21785c },
	{ 0xc3b2, 0x21785d },
	{ 0xc3b3, 0x21785e },
	{ 0xc3b4, 0x21785f },
	{ 0xc3b5, 0x217860 },
	{ 0xc3b6, 0x217861 },
	{ 0xc3b7, 0x217862 },
	{ 0xc3b8, 0x217863 },
	{ 0xc3b9, 0x217865 },
	{ 0xc3ba, 0x217864 },
	{ 0xc3bb, 0x217866 },
	{ 0xc3bc, 0x217867 },
	{ 0xc3bd, 0x217868 },
	{ 0xc3be, 0x217869 },
	{ 0xc3bf, 0x21786a },
	{ 0xc3c0, 0x21786b },
	{ 0xc3c1, 0x21786c },
	{ 0xc3c2, 0x21786d },
	{ 0xc3c3, 0x21786e },
	{ 0xc3c4, 0x21786f },
	{ 0xc3c5, 0x217870 },
	{ 0xc3c6, 0x217871 },
	{ 0xc3c7, 0x217872 },
	{ 0xc3c8, 0x217873 },
	{ 0xc3c9, 0x217874 },
	{ 0xc3ca, 0x217875 },
	{ 0xc3cb, 0x217876 },
	{ 0xc3cc, 0x217877 },
	{ 0xc3cd, 0x217878 },
	{ 0xc3ce, 0x217879 },
	{ 0xc3cf, 0x21787a },
	{ 0xc3d0, 0x21787b },
	{ 0xc3d1, 0x21787c },
	{ 0xc3d2, 0x21787d },
	{ 0xc3d3, 0x21787e },
	{ 0xc3d4, 0x217921 },
	{ 0xc3d5, 0x217922 },
	{ 0xc3d6, 0x217923 },
	{ 0xc3d7, 0x217924 },
	{ 0xc3d8, 0x217925 },
	{ 0xc3d9, 0x217926 },
	{ 0xc3da, 0x217927 },
	{ 0xc3db, 0x217928 },
	{ 0xc3dc, 0x217929 },
	{ 0xc3dd, 0x21792a },
	{ 0xc3de, 0x21792b },
	{ 0xc3df, 0x21792c },
	{ 0xc3e0, 0x21792d },
	{ 0xc3e1, 0x21792e },
	{ 0xc3e2, 0x21792f },
	{ 0xc3e3, 0x217930 },
	{ 0xc3e4, 0x217931 },
	{ 0xc3e5, 0x217932 },
	{ 0xc3e6, 0x217933 },
	{ 0xc3e7, 0x217934 },
	{ 0xc3e8, 0x217935 },
	{ 0xc3e9, 0x217936 },
	{ 0xc3ea, 0x217937 },
	{ 0xc3eb, 0x217938 },
	{ 0xc3ec, 0x217939 },
	{ 0xc3ed, 0x21793a },
	{ 0xc3ee, 0x21793b },
	{ 0xc3ef, 0x21793c },
	{ 0xc3f0, 0x21793d },
	{ 0xc3f1, 0x21793e },
	{ 0xc3f2, 0x21793f },
	{ 0xc3f3, 0x217940 },
	{ 0xc3f4, 0x217941 },
	{ 0xc3f5, 0x217942 },
	{ 0xc3f6, 0x217943 },
	{ 0xc3f7, 0x217944 },
	{ 0xc3f8, 0x217945 },
	{ 0xc3f9, 0x217946 },
	{ 0xc3fa, 0x217947 },
	{ 0xc3fb, 0x217948 },
	{ 0xc3fc, 0x217949 },
	{ 0xc3fd, 0x21794a },
	{ 0xc3fe, 0x21794b },
	{ 0xc440, 0x21794c },
	{ 0xc441, 0x21794d },
	{ 0xc442, 0x21794e },
	{ 0xc443, 0x21794f },
	{ 0xc444, 0x217950 },
	{ 0xc445, 0x217951 },
	{ 0xc446, 0x217952 },
	{ 0xc447, 0x217953 },
	{ 0xc448, 0x217954 },
	{ 0xc449, 0x217955 },
	{ 0xc44a, 0x217956 },
	{ 0xc44b, 0x217957 },
	{ 0xc44c, 0x217958 },
	{ 0xc44d, 0x217959 },
	{ 0xc44e, 0x21795a },
	{ 0xc44f, 0x21795b },
	{ 0xc450, 0x21795c },
	{ 0xc451, 0x21795d },
	{ 0xc452, 0x21795e },
	{ 0xc453, 0x21795f },
	{ 0xc454, 0x217960 },
	{ 0xc455, 0x217961 },
	{ 0xc456, 0x21782d },
	{ 0xc457, 0x217962 },
	{ 0xc458, 0x217963 },
	{ 0xc459, 0x217964 },
	{ 0xc45a, 0x217965 },
	{ 0xc45b, 0x217966 },
	{ 0xc45c, 0x217967 },
	{ 0xc45d, 0x217968 },
	{ 0xc45e, 0x217969 },
	{ 0xc45f, 0x21796a },
	{ 0xc460, 0x21796b },
	{ 0xc461, 0x21796c },
	{ 0xc462, 0x21796d },
	{ 0xc463, 0x21796e },
	{ 0xc464, 0x21796f },
	{ 0xc465, 0x217970 },
	{ 0xc466, 0x217971 },
	{ 0xc467, 0x217972 },
	{ 0xc468, 0x217973 },
	{ 0xc469, 0x217974 },
	{ 0xc46a, 0x217975 },
	{ 0xc46b, 0x217976 },
	{ 0xc46c, 0x217977 },
	{ 0xc46d, 0x217978 },
	{ 0xc46e, 0x217979 },
	{ 0xc46f, 0x21797a },
	{ 0xc470, 0x21797b },
	{ 0xc471, 0x21797c },
	{ 0xc472, 0x21797d },
	{ 0xc473, 0x21797e },
	{ 0xc474, 0x217a21 },
	{ 0xc475, 0x217a22 },
	{ 0xc476, 0x217a23 },
	{ 0xc477, 0x217a24 },
	{ 0xc478, 0x217a25 },
	{ 0xc479, 0x217a26 },
	{ 0xc47a, 0x217a27 },
	{ 0xc47b, 0x217a28 },
	{ 0xc47c, 0x217a29 },
	{ 0xc47d, 0x217a2a },
	{ 0xc47e, 0x217a2b },
	{ 0xc4a1, 0x217a2c },
	{ 0xc4a2, 0x217a2d },
	{ 0xc4a3, 0x217a2e },
	{ 0xc4a4, 0x217a2f },
	{ 0xc4a5, 0x217a30 },
	{ 0xc4a6, 0x217a31 },
	{ 0xc4a7, 0x217a32 },
	{ 0xc4a8, 0x217a33 },
	{ 0xc4a9, 0x217a34 },
	{ 0xc4aa, 0x217a35 },
	{ 0xc4ab, 0x217a36 },
	{ 0xc4ac, 0x217a37 },
	{ 0xc4ad, 0x217a38 },
	{ 0xc4ae, 0x217a39 },
	{ 0xc4af, 0x217a3a },
	{ 0xc4b0, 0x217a3b },
	{ 0xc4b1, 0x217a3c },
	{ 0xc4b2, 0x217a3d },
	{ 0xc4b3, 0x217a3e },
	{ 0xc4b4, 0x217a3f },
	{ 0xc4b5, 0x217a40 },
	{ 0xc4b6, 0x217a41 },
	{ 0xc4b7, 0x217a42 },
	{ 0xc4b8, 0x217a43 },
	{ 0xc4b9, 0x217a44 },
	{ 0xc4ba, 0x217a45 },
	{ 0xc4bb, 0x217a46 },
	{ 0xc4bc, 0x217a47 },
	{ 0xc4bd, 0x217a48 },
	{ 0xc4be, 0x217a49 },
	{ 0xc4bf, 0x217a4a },
	{ 0xc4c0, 0x217a4b },
	{ 0xc4c1, 0x217a4c },
	{ 0xc4c2, 0x217a4d },
	{ 0xc4c3, 0x217a4e },
	{ 0xc4c4, 0x217a4f },
	{ 0xc4c5, 0x217a50 },
	{ 0xc4c6, 0x217a51 },
	{ 0xc4c7, 0x217a52 },
	{ 0xc4c8, 0x217a53 },
	{ 0xc4c9, 0x217a54 },
	{ 0xc4ca, 0x217a55 },
	{ 0xc4cb, 0x217a56 },
	{ 0xc4cc, 0x217a57 },
	{ 0xc4cd, 0x217a58 },
	{ 0xc4ce, 0x217a59 },
	{ 0xc4cf, 0x217a5a },
	{ 0xc4d0, 0x217a5b },
	{ 0xc4d1, 0x217a5c },
	{ 0xc4d2, 0x217a5d },
	{ 0xc4d3, 0x217a5e },
	{ 0xc4d4, 0x217a5f },
	{ 0xc4d5, 0x217a60 },
	{ 0xc4d6, 0x217a61 },
	{ 0xc4d7, 0x217a62 },
	{ 0xc4d8, 0x217a63 },
	{ 0xc4d9, 0x217a64 },
	{ 0xc4da, 0x217a65 },
	{ 0xc4db, 0x217a66 },
	{ 0xc4dc, 0x217a67 },
	{ 0xc4dd, 0x217a68 },
	{ 0xc4de, 0x217a69 },
	{ 0xc4df, 0x217a6a },
	{ 0xc4e0, 0x217a6b },
	{ 0xc4e1, 0x217a6c },
	{ 0xc4e2, 0x217a6d },
	{ 0xc4e3, 0x217a6e },
	{ 0xc4e4, 0x217a6f },
	{ 0xc4e5, 0x217a70 },
	{ 0xc4e6, 0x217a71 },
	{ 0xc4e7, 0x217a72 },
	{ 0xc4e8, 0x217a73 },
	{ 0xc4e9, 0x217a74 },
	{ 0xc4ea, 0x217a75 },
	{ 0xc4eb, 0x217a76 },
	{ 0xc4ec, 0x217a77 },
	{ 0xc4ed, 0x217a78 },
	{ 0xc4ee, 0x217a79 },
	{ 0xc4ef, 0x217a7a },
	{ 0xc4f0, 0x217a7b },
	{ 0xc4f1, 0x217a7c },
	{ 0xc4f2, 0x217a7d },
	{ 0xc4f3, 0x217a7e },
	{ 0xc4f4, 0x217b21 },
	{ 0xc4f5, 0x217b22 },
	{ 0xc4f6, 0x217b23 },
	{ 0xc4f7, 0x217b24 },
	{ 0xc4f8, 0x217b25 },
	{ 0xc4f9, 0x217b26 },
	{ 0xc4fa, 0x217b27 },
	{ 0xc4fb, 0x217b28 },
	{ 0xc4fc, 0x217b29 },
	{ 0xc4fd, 0x217b2a },
	{ 0xc4fe, 0x217b2b },
	{ 0xc540, 0x217b2c },
	{ 0xc541, 0x217b2d },
	{ 0xc542, 0x217b2e },
	{ 0xc543, 0x217b2f },
	{ 0xc544, 0x217b30 },
	{ 0xc545, 0x217b31 },
	{ 0xc546, 0x217b32 },
	{ 0xc547, 0x217b33 },
	{ 0xc548, 0x217b34 },
	{ 0xc549, 0x217b35 },
	{ 0xc54a, 0x217b36 },
	{ 0xc54b, 0x217b37 },
	{ 0xc54c, 0x217b38 },
	{ 0xc54d, 0x217b39 },
	{ 0xc54e, 0x217b3a },
	{ 0xc54f, 0x217b3b },
	{ 0xc550, 0x217b3c },
	{ 0xc551, 0x217b3d },
	{ 0xc552, 0x217b3e },
	{ 0xc553, 0x217b3f },
	{ 0xc554, 0x217b40 },
	{ 0xc555, 0x217b41 },
	{ 0xc556, 0x217b42 },
	{ 0xc557, 0x217b43 },
	{ 0xc558, 0x217b44 },
	{ 0xc559, 0x217b45 },
	{ 0xc55a, 0x217b46 },
	{ 0xc55b, 0x217b47 },
	{ 0xc55c, 0x217b48 },
	{ 0xc55d, 0x217b49 },
	{ 0xc55e, 0x217b4a },
	{ 0xc55f, 0x217b4b },
	{ 0xc560, 0x217b4c },
	{ 0xc561, 0x217b4d },
	{ 0xc562, 0x217b4e },
	{ 0xc563, 0x217b4f },
	{ 0xc564, 0x217b50 },
	{ 0xc565, 0x217b51 },
	{ 0xc566, 0x217b52 },
	{ 0xc567, 0x217b53 },
	{ 0xc568, 0x217b54 },
	{ 0xc569, 0x217b55 },
	{ 0xc56a, 0x217b56 },
	{ 0xc56b, 0x217b57 },
	{ 0xc56c, 0x217b58 },
	{ 0xc56d, 0x217b59 },
	{ 0xc56e, 0x217b5a },
	{ 0xc56f, 0x217b5b },
	{ 0xc570, 0x217b5c },
	{ 0xc571, 0x217b5d },
	{ 0xc572, 0x217b5e },
	{ 0xc573, 0x217b5f },
	{ 0xc574, 0x217b60 },
	{ 0xc575, 0x217b61 },
	{ 0xc576, 0x217b62 },
	{ 0xc577, 0x217b63 },
	{ 0xc578, 0x217b64 },
	{ 0xc579, 0x217b65 },
	{ 0xc57a, 0x217b66 },
	{ 0xc57b, 0x217b67 },
	{ 0xc57c, 0x217b68 },
	{ 0xc57d, 0x217b69 },
	{ 0xc57e, 0x217b6a },
	{ 0xc5a1, 0x217b6b },
	{ 0xc5a2, 0x217b6c },
	{ 0xc5a3, 0x217b6d },
	{ 0xc5a4, 0x217b6e },
	{ 0xc5a5, 0x217b6f },
	{ 0xc5a6, 0x217b70 },
	{ 0xc5a7, 0x217b71 },
	{ 0xc5a8, 0x217b72 },
	{ 0xc5a9, 0x217b73 },
	{ 0xc5aa, 0x217b74 },
	{ 0xc5ab, 0x217b75 },
	{ 0xc5ac, 0x217b76 },
	{ 0xc5ad, 0x217b77 },
	{ 0xc5ae, 0x217b78 },
	{ 0xc5af, 0x217b79 },
	{ 0xc5b0, 0x217b7a },
	{ 0xc5b1, 0x217b7b },
	{ 0xc5b2, 0x217b7c },
	{ 0xc5b3, 0x217b7d },
	{ 0xc5b4, 0x217b7e },
	{ 0xc5b5, 0x217c21 },
	{ 0xc5b6, 0x217c22 },
	{ 0xc5b7, 0x217c23 },
	{ 0xc5b8, 0x217c24 },
	{ 0xc5b9, 0x217c25 },
	{ 0xc5ba, 0x217c26 },
	{ 0xc5bb, 0x217c27 },
	{ 0xc5bc, 0x217c28 },
	{ 0xc5bd, 0x217c29 },
	{ 0xc5be, 0x217c2a },
	{ 0xc5bf, 0x217c2b },
	{ 0xc5c0, 0x217c2c },
	{ 0xc5c1, 0x217c2d },
	{ 0xc5c2, 0x217c2e },
	{ 0xc5c3, 0x217c2f },
	{ 0xc5c4, 0x217c30 },
	{ 0xc5c5, 0x217c31 },
	{ 0xc5c6, 0x217c32 },
	{ 0xc5c7, 0x217c33 },
	{ 0xc5c8, 0x217c34 },
	{ 0xc5c9, 0x217c35 },
	{ 0xc5ca, 0x217c36 },
	{ 0xc5cb, 0x217c37 },
	{ 0xc5cc, 0x217c38 },
	{ 0xc5cd, 0x217c39 },
	{ 0xc5ce, 0x217c3a },
	{ 0xc5cf, 0x217c3b },
	{ 0xc5d0, 0x217c3c },
	{ 0xc5d1, 0x217c3d },
	{ 0xc5d2, 0x217c3e },
	{ 0xc5d3, 0x217c3f },
	{ 0xc5d4, 0x217c40 },
	{ 0xc5d5, 0x217c41 },
	{ 0xc5d6, 0x217c42 },
	{ 0xc5d7, 0x217c43 },
	{ 0xc5d8, 0x217c44 },
	{ 0xc5d9, 0x217c45 },
	{ 0xc5da, 0x217c46 },
	{ 0xc5db, 0x217c47 },
	{ 0xc5dc, 0x217c48 },
	{ 0xc5dd, 0x217c49 },
	{ 0xc5de, 0x217c4a },
	{ 0xc5df, 0x217c4b },
	{ 0xc5e0, 0x217c4c },
	{ 0xc5e1, 0x217c4d },
	{ 0xc5e2, 0x217c4e },
	{ 0xc5e3, 0x217c4f },
	{ 0xc5e4, 0x217c50 },
	{ 0xc5e5, 0x217c51 },
	{ 0xc5e6, 0x217c52 },
	{ 0xc5e7, 0x217c53 },
	{ 0xc5e8, 0x217c54 },
	{ 0xc5e9, 0x217c55 },
	{ 0xc5ea, 0x217c56 },
	{ 0xc5eb, 0x217c57 },
	{ 0xc5ec, 0x217c58 },
	{ 0xc5ed, 0x217c59 },
	{ 0xc5ee, 0x217c5a },
	{ 0xc5ef, 0x217c5b },
	{ 0xc5f0, 0x217c5c },
	{ 0xc5f1, 0x217c5d },
	{ 0xc5f2, 0x217c5e },
	{ 0xc5f3, 0x217c5f },
	{ 0xc5f4, 0x217c60 },
	{ 0xc5f5, 0x217c61 },
	{ 0xc5f6, 0x217c62 },
	{ 0xc5f7, 0x217c63 },
	{ 0xc5f8, 0x217c64 },
	{ 0xc5f9, 0x217c65 },
	{ 0xc5fa, 0x217c66 },
	{ 0xc5fb, 0x217c67 },
	{ 0xc5fc, 0x217c68 },
	{ 0xc5fd, 0x217c69 },
	{ 0xc5fe, 0x217c6a },
	{ 0xc640, 0x217c6b },
	{ 0xc641, 0x217c6c },
	{ 0xc642, 0x217c6d },
	{ 0xc643, 0x217c6e },
	{ 0xc644, 0x217c6f },
	{ 0xc645, 0x217c70 },
	{ 0xc646, 0x217c71 },
	{ 0xc647, 0x217c72 },
	{ 0xc648, 0x217c73 },
	{ 0xc649, 0x217c74 },
	{ 0xc64a, 0x217c75 },
	{ 0xc64b, 0x217c76 },
	{ 0xc64c, 0x217c77 },
	{ 0xc64d, 0x217c78 },
	{ 0xc64e, 0x217c79 },
	{ 0xc64f, 0x217c7a },
	{ 0xc650, 0x217c7b },
	{ 0xc651, 0x217c7c },
	{ 0xc652, 0x217c7d },
	{ 0xc653, 0x217c7e },
	{ 0xc654, 0x217d21 },
	{ 0xc655, 0x217d22 },
	{ 0xc656, 0x217d23 },
	{ 0xc657, 0x217d24 },
	{ 0xc658, 0x217d25 },
	{ 0xc659, 0x217d26 },
	{ 0xc65a, 0x217d27 },
	{ 0xc65b, 0x217d28 },
	{ 0xc65c, 0x217d29 },
	{ 0xc65d, 0x217d2a },
	{ 0xc65e, 0x217d2b },
	{ 0xc65f, 0x217d2c },
	{ 0xc660, 0x217d2d },
	{ 0xc661, 0x217d2e },
	{ 0xc662, 0x217d2f },
	{ 0xc663, 0x217d30 },
	{ 0xc664, 0x217d31 },
	{ 0xc665, 0x217d32 },
	{ 0xc666, 0x217d33 },
	{ 0xc667, 0x217d34 },
	{ 0xc668, 0x217d35 },
	{ 0xc669, 0x217d36 },
	{ 0xc66a, 0x217d37 },
	{ 0xc66b, 0x217d38 },
	{ 0xc66c, 0x217d39 },
	{ 0xc66d, 0x217d3a },
	{ 0xc66e, 0x217d3b },
	{ 0xc66f, 0x217d3c },
	{ 0xc670, 0x217d3d },
	{ 0xc671, 0x217d3e },
	{ 0xc672, 0x217d3f },
	{ 0xc673, 0x217d40 },
	{ 0xc674, 0x217d41 },
	{ 0xc675, 0x217d42 },
	{ 0xc676, 0x217d43 },
	{ 0xc677, 0x217d44 },
	{ 0xc678, 0x217d45 },
	{ 0xc679, 0x217d46 },
	{ 0xc67a, 0x217d47 },
	{ 0xc67b, 0x217d48 },
	{ 0xc67c, 0x217d49 },
	{ 0xc67d, 0x217d4a },
	{ 0xc67e, 0x217d4b },
	{ 0xc940, 0x222121 },
	{ 0xc941, 0x222122 },
	{ 0xc942, 0x222123 },
	{ 0xc943, 0x222124 },
	{ 0xc944, 0x222125 },
	{ 0xc945, 0x222126 },
	{ 0xc946, 0x222127 },
	{ 0xc947, 0x222128 },
	{ 0xc948, 0x222129 },
	{ 0xc949, 0x22212a },
	{ 0xc94a, 0x214442 },
	{ 0xc94b, 0x22212b },
	{ 0xc94c, 0x22212c },
	{ 0xc94d, 0x22212d },
	{ 0xc94e, 0x22212e },
	{ 0xc94f, 0x22212f },
	{ 0xc950, 0x222130 },
	{ 0xc951, 0x222131 },
	{ 0xc952, 0x222132 },
	{ 0xc953, 0x222133 },
	{ 0xc954, 0x222134 },
	{ 0xc955, 0x222135 },
	{ 0xc956, 0x222136 },
	{ 0xc957, 0x222137 },
	{ 0xc958, 0x222138 },
	{ 0xc959, 0x222139 },
	{ 0xc95a, 0x22213a },
	{ 0xc95b, 0x22213b },
	{ 0xc95c, 0x22213c },
	{ 0xc95d, 0x22213d },
	{ 0xc95e, 0x22213e },
	{ 0xc95f, 0x22213f },
	{ 0xc960, 0x222140 },
	{ 0xc961, 0x222141 },
	{ 0xc962, 0x222142 },
	{ 0xc963, 0x222143 },
	{ 0xc964, 0x222144 },
	{ 0xc965, 0x222145 },
	{ 0xc966, 0x222146 },
	{ 0xc967, 0x222147 },
	{ 0xc968, 0x222148 },
	{ 0xc969, 0x222149 },
	{ 0xc96a, 0x22214a },
	{ 0xc96b, 0x22214b },
	{ 0xc96c, 0x22214d },
	{ 0xc96d, 0x22214e },
	{ 0xc96e, 0x22214f },
	{ 0xc96f, 0x222150 },
	{ 0xc970, 0x222151 },
	{ 0xc971, 0x222152 },
	{ 0xc972, 0x222153 },
	{ 0xc973, 0x222154 },
	{ 0xc974, 0x222155 },
	{ 0xc975, 0x222156 },
	{ 0xc976, 0x222157 },
	{ 0xc977, 0x222158 },
	{ 0xc978, 0x222159 },
	{ 0xc979, 0x22215a },
	{ 0xc97a, 0x22215b },
	{ 0xc97b, 0x22215c },
	{ 0xc97c, 0x22215d },
	{ 0xc97d, 0x22215e },
	{ 0xc97e, 0x22215f },
	{ 0xc9a1, 0x222160 },
	{ 0xc9a2, 0x222161 },
	{ 0xc9a3, 0x222162 },
	{ 0xc9a4, 0x222163 },
	{ 0xc9a5, 0x222164 },
	{ 0xc9a6, 0x222165 },
	{ 0xc9a7, 0x222166 },
	{ 0xc9a8, 0x222167 },
	{ 0xc9a9, 0x222168 },
	{ 0xc9aa, 0x222169 },
	{ 0xc9ab, 0x22216a },
	{ 0xc9ac, 0x22216b },
	{ 0xc9ad, 0x22216c },
	{ 0xc9ae, 0x22216d },
	{ 0xc9af, 0x22216e },
	{ 0xc9b0, 0x22216f },
	{ 0xc9b1, 0x222170 },
	{ 0xc9b2, 0x222171 },
	{ 0xc9b3, 0x222172 },
	{ 0xc9b4, 0x222173 },
	{ 0xc9b5, 0x222174 },
	{ 0xc9b6, 0x222175 },
	{ 0xc9b7, 0x222176 },
	{ 0xc9b8, 0x222177 },
	{ 0xc9b9, 0x222178 },
	{ 0xc9ba, 0x222179 },
	{ 0xc9bb, 0x22217a },
	{ 0xc9bc, 0x22217b },
	{ 0xc9bd, 0x22217c },
	{ 0xc9be, 0x22214c },
	{ 0xc9bf, 0x22217d },
	{ 0xc9c0, 0x22217e },
	{ 0xc9c1, 0x222221 },
	{ 0xc9c2, 0x222222 },
	{ 0xc9c3, 0x222223 },
	{ 0xc9c4, 0x222224 },
	{ 0xc9c5, 0x222225 },
	{ 0xc9c6, 0x222226 },
	{ 0xc9c7, 0x222227 },
	{ 0xc9c8, 0x222228 },
	{ 0xc9c9, 0x222229 },
	{ 0xc9ca, 0x22222a },
	{ 0xc9cb, 0x22222b },
	{ 0xc9cc, 0x22222c },
	{ 0xc9cd, 0x22222d },
	{ 0xc9ce, 0x22222e },
	{ 0xc9cf, 0x22222f },
	{ 0xc9d0, 0x222230 },
	{ 0xc9d1, 0x222231 },
	{ 0xc9d2, 0x222232 },
	{ 0xc9d3, 0x222233 },
	{ 0xc9d4, 0x222234 },
	{ 0xc9d5, 0x222235 },
	{ 0xc9d6, 0x222236 },
	{ 0xc9d7, 0x222237 },
	{ 0xc9d8, 0x222238 },
	{ 0xc9d9, 0x222239 },
	{ 0xc9da, 0x22223a },
	{ 0xc9db, 0x22223b },
	{ 0xc9dc, 0x22223c },
	{ 0xc9dd, 0x22223d },
	{ 0xc9de, 0x22223e },
	{ 0xc9df, 0x22223f },
	{ 0xc9e0, 0x222240 },
	{ 0xc9e1, 0x222241 },
	{ 0xc9e2, 0x222242 },
	{ 0xc9e3, 0x222243 },
	{ 0xc9e4, 0x222244 },
	{ 0xc9e5, 0x222245 },
	{ 0xc9e6, 0x222246 },
	{ 0xc9e7, 0x222247 },
	{ 0xc9e8, 0x222248 },
	{ 0xc9e9, 0x222249 },
	{ 0xc9ea, 0x22224a },
	{ 0xc9eb, 0x22224b },
	{ 0xc9ec, 0x22224c },
	{ 0xc9ed, 0x22224e },
	{ 0xc9ee, 0x22224f },
	{ 0xc9ef, 0x222250 },
	{ 0xc9f0, 0x222251 },
	{ 0xc9f1, 0x222252 },
	{ 0xc9f2, 0x222253 },
	{ 0xc9f3, 0x222254 },
	{ 0xc9f4, 0x222255 },
	{ 0xc9f5, 0x222256 },
	{ 0xc9f6, 0x222257 },
	{ 0xc9f7, 0x222258 },
	{ 0xc9f8, 0x222259 },
	{ 0xc9f9, 0x22225a },
	{ 0xc9fa, 0x22225b },
	{ 0xc9fb, 0x22225c },
	{ 0xc9fc, 0x22225d },
	{ 0xc9fd, 0x22225e },
	{ 0xc9fe, 0x22225f },
	{ 0xca40, 0x222260 },
	{ 0xca41, 0x222261 },
	{ 0xca42, 0x222262 },
	{ 0xca43, 0x222263 },
	{ 0xca44, 0x222264 },
	{ 0xca45, 0x222265 },
	{ 0xca46, 0x222266 },
	{ 0xca47, 0x222267 },
	{ 0xca48, 0x222268 },
	{ 0xca49, 0x222269 },
	{ 0xca4a, 0x22226a },
	{ 0xca4b, 0x22226b },
	{ 0xca4c, 0x22226c },
	{ 0xca4d, 0x22226d },
	{ 0xca4e, 0x22226e },
	{ 0xca4f, 0x22226f },
	{ 0xca50, 0x222270 },
	{ 0xca51, 0x222271 },
	{ 0xca52, 0x222272 },
	{ 0xca53, 0x222273 },
	{ 0xca54, 0x222274 },
	{ 0xca55, 0x222275 },
	{ 0xca56, 0x222276 },
	{ 0xca57, 0x222277 },
	{ 0xca58, 0x222278 },
	{ 0xca59, 0x222279 },
	{ 0xca5a, 0x22227a },
	{ 0xca5b, 0x22227b },
	{ 0xca5c, 0x22227c },
	{ 0xca5d, 0x22227d },
	{ 0xca5e, 0x22227e },
	{ 0xca5f, 0x222321 },
	{ 0xca60, 0x222322 },
	{ 0xca61, 0x222323 },
	{ 0xca62, 0x222324 },
	{ 0xca63, 0x222325 },
	{ 0xca64, 0x222326 },
	{ 0xca65, 0x222327 },
	{ 0xca66, 0x222328 },
	{ 0xca67, 0x222329 },
	{ 0xca68, 0x22232a },
	{ 0xca69, 0x22232b },
	{ 0xca6a, 0x22232c },
	{ 0xca6b, 0x22232d },
	{ 0xca6c, 0x22232e },
	{ 0xca6d, 0x22232f },
	{ 0xca6e, 0x222330 },
	{ 0xca6f, 0x222331 },
	{ 0xca70, 0x222332 },
	{ 0xca71, 0x222333 },
	{ 0xca72, 0x222334 },
	{ 0xca73, 0x222335 },
	{ 0xca74, 0x222336 },
	{ 0xca75, 0x222337 },
	{ 0xca76, 0x222338 },
	{ 0xca77, 0x222339 },
	{ 0xca78, 0x22233a },
	{ 0xca79, 0x22233b },
	{ 0xca7a, 0x22233c },
	{ 0xca7b, 0x22233d },
	{ 0xca7c, 0x22233e },
	{ 0xca7d, 0x22233f },
	{ 0xca7e, 0x222340 },
	{ 0xcaa1, 0x222341 },
	{ 0xcaa2, 0x222342 },
	{ 0xcaa3, 0x222343 },
	{ 0xcaa4, 0x222344 },
	{ 0xcaa5, 0x222345 },
	{ 0xcaa6, 0x222346 },
	{ 0xcaa7, 0x222347 },
	{ 0xcaa8, 0x222348 },
	{ 0xcaa9, 0x222349 },
	{ 0xcaaa, 0x22234a },
	{ 0xcaab, 0x22234b },
	{ 0xcaac, 0x22234c },
	{ 0xcaad, 0x22234d },
	{ 0xcaae, 0x22234e },
	{ 0xcaaf, 0x22234f },
	{ 0xcab0, 0x222350 },
	{ 0xcab1, 0x222351 },
	{ 0xcab2, 0x222352 },
	{ 0xcab3, 0x222353 },
	{ 0xcab4, 0x222354 },
	{ 0xcab5, 0x222355 },
	{ 0xcab6, 0x222356 },
	{ 0xcab7, 0x222357 },
	{ 0xcab8, 0x222358 },
	{ 0xcab9, 0x222359 },
	{ 0xcaba, 0x22235a },
	{ 0xcabb, 0x22235b },
	{ 0xcabc, 0x22235c },
	{ 0xcabd, 0x22235d },
	{ 0xcabe, 0x22235e },
	{ 0xcabf, 0x22235f },
	{ 0xcac0, 0x222360 },
	{ 0xcac1, 0x222361 },
	{ 0xcac2, 0x222362 },
	{ 0xcac3, 0x222363 },
	{ 0xcac4, 0x222364 },
	{ 0xcac5, 0x222365 },
	{ 0xcac6, 0x222366 },
	{ 0xcac7, 0x222367 },
	{ 0xcac8, 0x222368 },
	{ 0xcac9, 0x222369 },
	{ 0xcaca, 0x22236a },
	{ 0xcacb, 0x22236b },
	{ 0xcacc, 0x22236c },
	{ 0xcacd, 0x22236d },
	{ 0xcace, 0x22236e },
	{ 0xcacf, 0x22236f },
	{ 0xcad0, 0x222370 },
	{ 0xcad1, 0x222371 },
	{ 0xcad2, 0x222372 },
	{ 0xcad3, 0x222373 },
	{ 0xcad4, 0x222374 },
	{ 0xcad5, 0x222375 },
	{ 0xcad6, 0x222376 },
	{ 0xcad7, 0x222377 },
	{ 0xcad8, 0x222378 },
	{ 0xcad9, 0x222379 },
	{ 0xcada, 0x22237a },
	{ 0xcadb, 0x22237b },
	{ 0xcadc, 0x22237c },
	{ 0xcadd, 0x22237d },
	{ 0xcade, 0x22237e },
	{ 0xcadf, 0x222421 },
	{ 0xcae0, 0x222422 },
	{ 0xcae1, 0x222423 },
	{ 0xcae2, 0x222424 },
	{ 0xcae3, 0x222425 },
	{ 0xcae4, 0x222426 },
	{ 0xcae5, 0x222427 },
	{ 0xcae6, 0x222428 },
	{ 0xcae7, 0x222429 },
	{ 0xcae8, 0x22242a },
	{ 0xcae9, 0x22242b },
	{ 0xcaea, 0x22242c },
	{ 0xcaeb, 0x22242d },
	{ 0xcaec, 0x22242e },
	{ 0xcaed, 0x22242f },
	{ 0xcaee, 0x222430 },
	{ 0xcaef, 0x222431 },
	{ 0xcaf0, 0x222432 },
	{ 0xcaf1, 0x222433 },
	{ 0xcaf2, 0x222434 },
	{ 0xcaf3, 0x222435 },
	{ 0xcaf4, 0x222436 },
	{ 0xcaf5, 0x222437 },
	{ 0xcaf6, 0x222438 },
	{ 0xcaf7, 0x22224d },
	{ 0xcaf8, 0x222439 },
	{ 0xcaf9, 0x22243a },
	{ 0xcafa, 0x22243b },
	{ 0xcafb, 0x22243c },
	{ 0xcafc, 0x22243d },
	{ 0xcafd, 0x22243e },
	{ 0xcafe, 0x22243f },
	{ 0xcb40, 0x222440 },
	{ 0xcb41, 0x222441 },
	{ 0xcb42, 0x222442 },
	{ 0xcb43, 0x222443 },
	{ 0xcb44, 0x222444 },
	{ 0xcb45, 0x222445 },
	{ 0xcb46, 0x222446 },
	{ 0xcb47, 0x222447 },
	{ 0xcb48, 0x222448 },
	{ 0xcb49, 0x222449 },
	{ 0xcb4a, 0x22244a },
	{ 0xcb4b, 0x22244b },
	{ 0xcb4c, 0x22244c },
	{ 0xcb4d, 0x22244d },
	{ 0xcb4e, 0x22244e },
	{ 0xcb4f, 0x22244f },
	{ 0xcb50, 0x222450 },
	{ 0xcb51, 0x222451 },
	{ 0xcb52, 0x222452 },
	{ 0xcb53, 0x222453 },
	{ 0xcb54, 0x222454 },
	{ 0xcb55, 0x222455 },
	{ 0xcb56, 0x222456 },
	{ 0xcb57, 0x222457 },
	{ 0xcb58, 0x222458 },
	{ 0xcb59, 0x222459 },
	{ 0xcb5a, 0x22245a },
	{ 0xcb5b, 0x22245b },
	{ 0xcb5c, 0x22245c },
	{ 0xcb5d, 0x22245d },
	{ 0xcb5e, 0x22245e },
	{ 0xcb5f, 0x22245f },
	{ 0xcb60, 0x222460 },
	{ 0xcb61, 0x222461 },
	{ 0xcb62, 0x222462 },
	{ 0xcb63, 0x222463 },
	{ 0xcb64, 0x222464 },
	{ 0xcb65, 0x222465 },
	{ 0xcb66, 0x222466 },
	{ 0xcb67, 0x222467 },
	{ 0xcb68, 0x222468 },
	{ 0xcb69, 0x222469 },
	{ 0xcb6a, 0x22246a },
	{ 0xcb6b, 0x22246b },
	{ 0xcb6c, 0x22246c },
	{ 0xcb6d, 0x22246d },
	{ 0xcb6e, 0x22246e },
	{ 0xcb6f, 0x22246f },
	{ 0xcb70, 0x222470 },
	{ 0xcb71, 0x222471 },
	{ 0xcb72, 0x222472 },
	{ 0xcb73, 0x222473 },
	{ 0xcb74, 0x222474 },
	{ 0xcb75, 0x222475 },
	{ 0xcb76, 0x222476 },
	{ 0xcb77, 0x222477 },
	{ 0xcb78, 0x222478 },
	{ 0xcb79, 0x222479 },
	{ 0xcb7a, 0x22247a },
	{ 0xcb7b, 0x22247b },
	{ 0xcb7c, 0x22247c },
	{ 0xcb7d, 0x22247d },
	{ 0xcb7e, 0x22247e },
	{ 0xcba1, 0x222521 },
	{ 0xcba2, 0x222522 },
	{ 0xcba3, 0x222523 },
	{ 0xcba4, 0x222524 },
	{ 0xcba5, 0x222525 },
	{ 0xcba6, 0x222526 },
	{ 0xcba7, 0x222527 },
	{ 0xcba8, 0x222528 },
	{ 0xcba9, 0x222529 },
	{ 0xcbaa, 0x22252a },
	{ 0xcbab, 0x22252b },
	{ 0xcbac, 0x22252c },
	{ 0xcbad, 0x22252d },
	{ 0xcbae, 0x22252e },
	{ 0xcbaf, 0x22252f },
	{ 0xcbb0, 0x222530 },
	{ 0xcbb1, 0x222531 },
	{ 0xcbb2, 0x222532 },
	{ 0xcbb3, 0x222533 },
	{ 0xcbb4, 0x222534 },
	{ 0xcbb5, 0x222535 },
	{ 0xcbb6, 0x222536 },
	{ 0xcbb7, 0x222537 },
	{ 0xcbb8, 0x222538 },
	{ 0xcbb9, 0x222539 },
	{ 0xcbba, 0x22253a },
	{ 0xcbbb, 0x22253b },
	{ 0xcbbc, 0x22253c },
	{ 0xcbbd, 0x22253d },
	{ 0xcbbe, 0x22253e },
	{ 0xcbbf, 0x22253f },
	{ 0xcbc0, 0x222540 },
	{ 0xcbc1, 0x222541 },
	{ 0xcbc2, 0x222542 },
	{ 0xcbc3, 0x222543 },
	{ 0xcbc4, 0x222544 },
	{ 0xcbc5, 0x222545 },
	{ 0xcbc6, 0x222546 },
	{ 0xcbc7, 0x222547 },
	{ 0xcbc8, 0x222548 },
	{ 0xcbc9, 0x222549 },
	{ 0xcbca, 0x22254a },
	{ 0xcbcb, 0x22254b },
	{ 0xcbcc, 0x22254c },
	{ 0xcbcd, 0x22254d },
	{ 0xcbce, 0x22254e },
	{ 0xcbcf, 0x22254f },
	{ 0xcbd0, 0x222550 },
	{ 0xcbd1, 0x222551 },
	{ 0xcbd2, 0x222552 },
	{ 0xcbd3, 0x222553 },
	{ 0xcbd4, 0x222554 },
	{ 0xcbd5, 0x222555 },
	{ 0xcbd6, 0x222556 },
	{ 0xcbd7, 0x222557 },
	{ 0xcbd8, 0x222558 },
	{ 0xcbd9, 0x222559 },
	{ 0xcbda, 0x22255a },
	{ 0xcbdb, 0x22255b },
	{ 0xcbdc, 0x22255c },
	{ 0xcbdd, 0x22255d },
	{ 0xcbde, 0x22255e },
	{ 0xcbdf, 0x22255f },
	{ 0xcbe0, 0x222560 },
	{ 0xcbe1, 0x222561 },
	{ 0xcbe2, 0x222562 },
	{ 0xcbe3, 0x222563 },
	{ 0xcbe4, 0x222564 },
	{ 0xcbe5, 0x222565 },
	{ 0xcbe6, 0x222566 },
	{ 0xcbe7, 0x222567 },
	{ 0xcbe8, 0x222568 },
	{ 0xcbe9, 0x222569 },
	{ 0xcbea, 0x22256a },
	{ 0xcbeb, 0x22256b },
	{ 0xcbec, 0x22256c },
	{ 0xcbed, 0x22256d },
	{ 0xcbee, 0x22256e },
	{ 0xcbef, 0x22256f },
	{ 0xcbf0, 0x222570 },
	{ 0xcbf1, 0x222571 },
	{ 0xcbf2, 0x222572 },
	{ 0xcbf3, 0x222573 },
	{ 0xcbf4, 0x222574 },
	{ 0xcbf5, 0x222575 },
	{ 0xcbf6, 0x222576 },
	{ 0xcbf7, 0x222577 },
	{ 0xcbf8, 0x222578 },
	{ 0xcbf9, 0x222579 },
	{ 0xcbfa, 0x22257a },
	{ 0xcbfb, 0x22257b },
	{ 0xcbfc, 0x22257c },
	{ 0xcbfd, 0x22257d },
	{ 0xcbfe, 0x22257e },
	{ 0xcc40, 0x222621 },
	{ 0xcc41, 0x222622 },
	{ 0xcc42, 0x222623 },
	{ 0xcc43, 0x222624 },
	{ 0xcc44, 0x222625 },
	{ 0xcc45, 0x222626 },
	{ 0xcc46, 0x222627 },
	{ 0xcc47, 0x222628 },
	{ 0xcc48, 0x222629 },
	{ 0xcc49, 0x22262a },
	{ 0xcc4a, 0x22262b },
	{ 0xcc4b, 0x22262c },
	{ 0xcc4c, 0x22262d },
	{ 0xcc4d, 0x22262e },
	{ 0xcc4e, 0x22262f },
	{ 0xcc4f, 0x222630 },
	{ 0xcc50, 0x222631 },
	{ 0xcc51, 0x222632 },
	{ 0xcc52, 0x222633 },
	{ 0xcc53, 0x222634 },
	{ 0xcc54, 0x222635 },
	{ 0xcc55, 0x222636 },
	{ 0xcc56, 0x222637 },
	{ 0xcc57, 0x222638 },
	{ 0xcc58, 0x222639 },
	{ 0xcc59, 0x22263a },
	{ 0xcc5a, 0x22263b },
	{ 0xcc5b, 0x22263c },
	{ 0xcc5c, 0x22263d },
	{ 0xcc5d, 0x22263e },
	{ 0xcc5e, 0x22263f },
	{ 0xcc5f, 0x222640 },
	{ 0xcc60, 0x222641 },
	{ 0xcc61, 0x222642 },
	{ 0xcc62, 0x222643 },
	{ 0xcc63, 0x222644 },
	{ 0xcc64, 0x222645 },
	{ 0xcc65, 0x222646 },
	{ 0xcc66, 0x222647 },
	{ 0xcc67, 0x222648 },
	{ 0xcc68, 0x222649 },
	{ 0xcc69, 0x22264a },
	{ 0xcc6a, 0x22264b },
	{ 0xcc6b, 0x22264c },
	{ 0xcc6c, 0x22264d },
	{ 0xcc6d, 0x22264e },
	{ 0xcc6e, 0x22264f },
	{ 0xcc6f, 0x222650 },
	{ 0xcc70, 0x222651 },
	{ 0xcc71, 0x222652 },
	{ 0xcc72, 0x222653 },
	{ 0xcc73, 0x222654 },
	{ 0xcc74, 0x222655 },
	{ 0xcc75, 0x222656 },
	{ 0xcc76, 0x222657 },
	{ 0xcc77, 0x222658 },
	{ 0xcc78, 0x222659 },
	{ 0xcc79, 0x22265a },
	{ 0xcc7a, 0x22265b },
	{ 0xcc7b, 0x22265c },
	{ 0xcc7c, 0x22265d },
	{ 0xcc7d, 0x22265e },
	{ 0xcc7e, 0x22265f },
	{ 0xcca1, 0x222660 },
	{ 0xcca2, 0x222661 },
	{ 0xcca3, 0x222662 },
	{ 0xcca4, 0x222663 },
	{ 0xcca5, 0x222664 },
	{ 0xcca6, 0x222665 },
	{ 0xcca7, 0x222666 },
	{ 0xcca8, 0x222667 },
	{ 0xcca9, 0x222668 },
	{ 0xccaa, 0x222669 },
	{ 0xccab, 0x22266a },
	{ 0xccac, 0x22266b },
	{ 0xccad, 0x22266c },
	{ 0xccae, 0x22266d },
	{ 0xccaf, 0x22266e },
	{ 0xccb0, 0x22266f },
	{ 0xccb1, 0x222670 },
	{ 0xccb2, 0x222671 },
	{ 0xccb3, 0x222672 },
	{ 0xccb4, 0x222673 },
	{ 0xccb5, 0x222674 },
	{ 0xccb6, 0x222675 },
	{ 0xccb7, 0x222676 },
	{ 0xccb8, 0x222677 },
	{ 0xccb9, 0x222678 },
	{ 0xccba, 0x222679 },
	{ 0xccbb, 0x22267a },
	{ 0xccbc, 0x22267b },
	{ 0xccbd, 0x22267c },
	{ 0xccbe, 0x22267d },
	{ 0xccbf, 0x22267e },
	{ 0xccc0, 0x222721 },
	{ 0xccc1, 0x222722 },
	{ 0xccc2, 0x222723 },
	{ 0xccc3, 0x222724 },
	{ 0xccc4, 0x222725 },
	{ 0xccc5, 0x222726 },
	{ 0xccc6, 0x222727 },
	{ 0xccc7, 0x222728 },
	{ 0xccc8, 0x222729 },
	{ 0xccc9, 0x22272a },
	{ 0xccca, 0x22272b },
	{ 0xcccb, 0x22272c },
	{ 0xcccc, 0x22272d },
	{ 0xcccd, 0x22272e },
	{ 0xccce, 0x22272f },
	{ 0xcccf, 0x222730 },
	{ 0xccd0, 0x222731 },
	{ 0xccd1, 0x222732 },
	{ 0xccd2, 0x222733 },
	{ 0xccd3, 0x222734 },
	{ 0xccd4, 0x222735 },
	{ 0xccd5, 0x222736 },
	{ 0xccd6, 0x222737 },
	{ 0xccd7, 0x222738 },
	{ 0xccd8, 0x222739 },
	{ 0xccd9, 0x22273a },
	{ 0xccda, 0x22273b },
	{ 0xccdb, 0x22273c },
	{ 0xccdc, 0x22273d },
	{ 0xccdd, 0x22273e },
	{ 0xccde, 0x22273f },
	{ 0xccdf, 0x222740 },
	{ 0xcce0, 0x222741 },
	{ 0xcce1, 0x222742 },
	{ 0xcce2, 0x222743 },
	{ 0xcce3, 0x222744 },
	{ 0xcce4, 0x222745 },
	{ 0xcce5, 0x222746 },
	{ 0xcce6, 0x222747 },
	{ 0xcce7, 0x222748 },
	{ 0xcce8, 0x222749 },
	{ 0xcce9, 0x22274a },
	{ 0xccea, 0x22274b },
	{ 0xcceb, 0x22274c },
	{ 0xccec, 0x22274d },
	{ 0xcced, 0x22274e },
	{ 0xccee, 0x22274f },
	{ 0xccef, 0x222750 },
	{ 0xccf0, 0x222751 },
	{ 0xccf1, 0x222752 },
	{ 0xccf2, 0x222753 },
	{ 0xccf3, 0x222754 },
	{ 0xccf4, 0x222755 },
	{ 0xccf5, 0x222756 },
	{ 0xccf6, 0x222757 },
	{ 0xccf7, 0x222758 },
	{ 0xccf8, 0x222759 },
	{ 0xccf9, 0x22275a },
	{ 0xccfa, 0x22275b },
	{ 0xccfb, 0x22275c },
	{ 0xccfc, 0x22275d },
	{ 0xccfd, 0x22275e },
	{ 0xccfe, 0x22275f },
	{ 0xcd40, 0x222760 },
	{ 0xcd41, 0x222761 },
	{ 0xcd42, 0x222762 },
	{ 0xcd43, 0x222763 },
	{ 0xcd44, 0x222764 },
	{ 0xcd45, 0x222765 },
	{ 0xcd46, 0x222766 },
	{ 0xcd47, 0x222767 },
	{ 0xcd48, 0x222768 },
	{ 0xcd49, 0x222769 },
	{ 0xcd4a, 0x22276a },
	{ 0xcd4b, 0x22276b },
	{ 0xcd4c, 0x22276c },
	{ 0xcd4d, 0x22276d },
	{ 0xcd4e, 0x22276e },
	{ 0xcd4f, 0x22276f },
	{ 0xcd50, 0x222770 },
	{ 0xcd51, 0x222771 },
	{ 0xcd52, 0x222772 },
	{ 0xcd53, 0x222773 },
	{ 0xcd54, 0x222774 },
	{ 0xcd55, 0x222775 },
	{ 0xcd56, 0x222776 },
	{ 0xcd57, 0x222777 },
	{ 0xcd58, 0x222778 },
	{ 0xcd59, 0x222779 },
	{ 0xcd5a, 0x22277a },
	{ 0xcd5b, 0x22277b },
	{ 0xcd5c, 0x22277c },
	{ 0xcd5d, 0x22277d },
	{ 0xcd5e, 0x22277e },
	{ 0xcd5f, 0x222821 },
	{ 0xcd60, 0x222822 },
	{ 0xcd61, 0x222823 },
	{ 0xcd62, 0x222824 },
	{ 0xcd63, 0x222825 },
	{ 0xcd64, 0x222826 },
	{ 0xcd65, 0x222827 },
	{ 0xcd66, 0x222828 },
	{ 0xcd67, 0x222829 },
	{ 0xcd68, 0x22282a },
	{ 0xcd69, 0x22282b },
	{ 0xcd6a, 0x22282c },
	{ 0xcd6b, 0x22282d },
	{ 0xcd6c, 0x22282e },
	{ 0xcd6d, 0x22282f },
	{ 0xcd6e, 0x222830 },
	{ 0xcd6f, 0x222831 },
	{ 0xcd70, 0x222832 },
	{ 0xcd71, 0x222833 },
	{ 0xcd72, 0x222834 },
	{ 0xcd73, 0x222835 },
	{ 0xcd74, 0x222836 },
	{ 0xcd75, 0x222837 },
	{ 0xcd76, 0x222838 },
	{ 0xcd77, 0x222839 },
	{ 0xcd78, 0x22283a },
	{ 0xcd79, 0x22283b },
	{ 0xcd7a, 0x22283c },
	{ 0xcd7b, 0x22283d },
	{ 0xcd7c, 0x22283e },
	{ 0xcd7d, 0x22283f },
	{ 0xcd7e, 0x222840 },
	{ 0xcda1, 0x222841 },
	{ 0xcda2, 0x222842 },
	{ 0xcda3, 0x222843 },
	{ 0xcda4, 0x222844 },
	{ 0xcda5, 0x222845 },
	{ 0xcda6, 0x222846 },
	{ 0xcda7, 0x222847 },
	{ 0xcda8, 0x222848 },
	{ 0xcda9, 0x222849 },
	{ 0xcdaa, 0x22284a },
	{ 0xcdab, 0x22284b },
	{ 0xcdac, 0x22284c },
	{ 0xcdad, 0x22284d },
	{ 0xcdae, 0x22284e },
	{ 0xcdaf, 0x22284f },
	{ 0xcdb0, 0x222850 },
	{ 0xcdb1, 0x222851 },
	{ 0xcdb2, 0x222852 },
	{ 0xcdb3, 0x222853 },
	{ 0xcdb4, 0x222854 },
	{ 0xcdb5, 0x222855 },
	{ 0xcdb6, 0x222856 },
	{ 0xcdb7, 0x222857 },
	{ 0xcdb8, 0x222858 },
	{ 0xcdb9, 0x222859 },
	{ 0xcdba, 0x22285a },
	{ 0xcdbb, 0x22285b },
	{ 0xcdbc, 0x22285c },
	{ 0xcdbd, 0x22285d },
	{ 0xcdbe, 0x22285e },
	{ 0xcdbf, 0x22285f },
	{ 0xcdc0, 0x222860 },
	{ 0xcdc1, 0x222861 },
	{ 0xcdc2, 0x222862 },
	{ 0xcdc3, 0x222863 },
	{ 0xcdc4, 0x222864 },
	{ 0xcdc5, 0x222865 },
	{ 0xcdc6, 0x222866 },
	{ 0xcdc7, 0x222867 },
	{ 0xcdc8, 0x222868 },
	{ 0xcdc9, 0x222869 },
	{ 0xcdca, 0x22286a },
	{ 0xcdcb, 0x22286b },
	{ 0xcdcc, 0x22286c },
	{ 0xcdcd, 0x22286d },
	{ 0xcdce, 0x22286e },
	{ 0xcdcf, 0x22286f },
	{ 0xcdd0, 0x222870 },
	{ 0xcdd1, 0x222871 },
	{ 0xcdd2, 0x222872 },
	{ 0xcdd3, 0x222873 },
	{ 0xcdd4, 0x222874 },
	{ 0xcdd5, 0x222875 },
	{ 0xcdd6, 0x222876 },
	{ 0xcdd7, 0x222877 },
	{ 0xcdd8, 0x222878 },
	{ 0xcdd9, 0x222879 },
	{ 0xcdda, 0x22287a },
	{ 0xcddb, 0x22287b },
	{ 0xcddc, 0x22287c },
	{ 0xcddd, 0x22287d },
	{ 0xcdde, 0x22287e },
	{ 0xcddf, 0x222921 },
	{ 0xcde0, 0x222922 },
	{ 0xcde1, 0x222923 },
	{ 0xcde2, 0x222924 },
	{ 0xcde3, 0x222925 },
	{ 0xcde4, 0x222926 },
	{ 0xcde5, 0x222927 },
	{ 0xcde6, 0x222928 },
	{ 0xcde7, 0x222929 },
	{ 0xcde8, 0x22292a },
	{ 0xcde9, 0x22292b },
	{ 0xcdea, 0x22292c },
	{ 0xcdeb, 0x22292d },
	{ 0xcdec, 0x22292e },
	{ 0xcded, 0x22292f },
	{ 0xcdee, 0x222930 },
	{ 0xcdef, 0x222931 },
	{ 0xcdf0, 0x222932 },
	{ 0xcdf1, 0x222933 },
	{ 0xcdf2, 0x222934 },
	{ 0xcdf3, 0x222935 },
	{ 0xcdf4, 0x222936 },
	{ 0xcdf5, 0x222937 },
	{ 0xcdf6, 0x222938 },
	{ 0xcdf7, 0x222939 },
	{ 0xcdf8, 0x22293a },
	{ 0xcdf9, 0x22293b },
	{ 0xcdfa, 0x22293c },
	{ 0xcdfb, 0x22293d },
	{ 0xcdfc, 0x22293e },
	{ 0xcdfd, 0x22293f },
	{ 0xcdfe, 0x222940 },
	{ 0xce40, 0x222941 },
	{ 0xce41, 0x222942 },
	{ 0xce42, 0x222943 },
	{ 0xce43, 0x222944 },
	{ 0xce44, 0x222945 },
	{ 0xce45, 0x222946 },
	{ 0xce46, 0x222947 },
	{ 0xce47, 0x222948 },
	{ 0xce48, 0x222949 },
	{ 0xce49, 0x22294a },
	{ 0xce4a, 0x22294b },
	{ 0xce4b, 0x22294c },
	{ 0xce4c, 0x22294d },
	{ 0xce4d, 0x22294e },
	{ 0xce4e, 0x22294f },
	{ 0xce4f, 0x222950 },
	{ 0xce50, 0x222951 },
	{ 0xce51, 0x222952 },
	{ 0xce52, 0x222953 },
	{ 0xce53, 0x222954 },
	{ 0xce54, 0x222955 },
	{ 0xce55, 0x222956 },
	{ 0xce56, 0x222957 },
	{ 0xce57, 0x222958 },
	{ 0xce58, 0x222959 },
	{ 0xce59, 0x22295a },
	{ 0xce5a, 0x22295b },
	{ 0xce5b, 0x22295c },
	{ 0xce5c, 0x22295d },
	{ 0xce5d, 0x22295e },
	{ 0xce5e, 0x22295f },
	{ 0xce5f, 0x222960 },
	{ 0xce60, 0x222961 },
	{ 0xce61, 0x222962 },
	{ 0xce62, 0x222963 },
	{ 0xce63, 0x222964 },
	{ 0xce64, 0x222965 },
	{ 0xce65, 0x222966 },
	{ 0xce66, 0x222967 },
	{ 0xce67, 0x222968 },
	{ 0xce68, 0x222969 },
	{ 0xce69, 0x22296a },
	{ 0xce6a, 0x22296b },
	{ 0xce6b, 0x22296c },
	{ 0xce6c, 0x22296d },
	{ 0xce6d, 0x22296e },
	{ 0xce6e, 0x22296f },
	{ 0xce6f, 0x222970 },
	{ 0xce70, 0x222971 },
	{ 0xce71, 0x222972 },
	{ 0xce72, 0x222973 },
	{ 0xce73, 0x222974 },
	{ 0xce74, 0x222975 },
	{ 0xce75, 0x222976 },
	{ 0xce76, 0x222977 },
	{ 0xce77, 0x222978 },
	{ 0xce78, 0x222979 },
	{ 0xce79, 0x22297a },
	{ 0xce7a, 0x22297b },
	{ 0xce7b, 0x22297c },
	{ 0xce7c, 0x22297d },
	{ 0xce7d, 0x22297e },
	{ 0xce7e, 0x222a21 },
	{ 0xcea1, 0x222a22 },
	{ 0xcea2, 0x222a23 },
	{ 0xcea3, 0x222a24 },
	{ 0xcea4, 0x222a25 },
	{ 0xcea5, 0x222a26 },
	{ 0xcea6, 0x222a27 },
	{ 0xcea7, 0x222a28 },
	{ 0xcea8, 0x222a29 },
	{ 0xcea9, 0x222a2a },
	{ 0xceaa, 0x222a2b },
	{ 0xceab, 0x222a2c },
	{ 0xceac, 0x222a2d },
	{ 0xcead, 0x222a2e },
	{ 0xceae, 0x222a2f },
	{ 0xceaf, 0x222a30 },
	{ 0xceb0, 0x222a31 },
	{ 0xceb1, 0x222a32 },
	{ 0xceb2, 0x222a33 },
	{ 0xceb3, 0x222a34 },
	{ 0xceb4, 0x222a35 },
	{ 0xceb5, 0x222a36 },
	{ 0xceb6, 0x222a37 },
	{ 0xceb7, 0x222a38 },
	{ 0xceb8, 0x222a39 },
	{ 0xceb9, 0x222a3a },
	{ 0xceba, 0x222a3b },
	{ 0xcebb, 0x222a3c },
	{ 0xcebc, 0x222a3d },
	{ 0xcebd, 0x222a3e },
	{ 0xcebe, 0x222a3f },
	{ 0xcebf, 0x222a40 },
	{ 0xcec0, 0x222a41 },
	{ 0xcec1, 0x222a42 },
	{ 0xcec2, 0x222a43 },
	{ 0xcec3, 0x222a44 },
	{ 0xcec4, 0x222a45 },
	{ 0xcec5, 0x222a46 },
	{ 0xcec6, 0x222a47 },
	{ 0xcec7, 0x222a48 },
	{ 0xcec8, 0x222a49 },
	{ 0xcec9, 0x222a4a },
	{ 0xceca, 0x222a4b },
	{ 0xcecb, 0x222a4c },
	{ 0xcecc, 0x222a4d },
	{ 0xcecd, 0x222a4e },
	{ 0xcece, 0x222a4f },
	{ 0xcecf, 0x222a50 },
	{ 0xced0, 0x222a51 },
	{ 0xced1, 0x222a52 },
	{ 0xced2, 0x222a53 },
	{ 0xced3, 0x222a54 },
	{ 0xced4, 0x222a55 },
	{ 0xced5, 0x222a56 },
	{ 0xced6, 0x222a57 },
	{ 0xced7, 0x222a58 },
	{ 0xced8, 0x222a59 },
	{ 0xced9, 0x222a5a },
	{ 0xceda, 0x222a5b },
	{ 0xcedb, 0x222a5c },
	{ 0xcedc, 0x222a5d },
	{ 0xcedd, 0x222a5e },
	{ 0xcede, 0x222a5f },
	{ 0xcedf, 0x222a60 },
	{ 0xcee0, 0x222a61 },
	{ 0xcee1, 0x222a62 },
	{ 0xcee2, 0x222a63 },
	{ 0xcee3, 0x222a64 },
	{ 0xcee4, 0x222a65 },
	{ 0xcee5, 0x222a66 },
	{ 0xcee6, 0x222a67 },
	{ 0xcee7, 0x222a68 },
	{ 0xcee8, 0x222a69 },
	{ 0xcee9, 0x222a6a },
	{ 0xceea, 0x222a6b },
	{ 0xceeb, 0x222a6c },
	{ 0xceec, 0x222a6d },
	{ 0xceed, 0x222a6e },
	{ 0xceee, 0x222a6f },
	{ 0xceef, 0x222a70 },
	{ 0xcef0, 0x222a71 },
	{ 0xcef1, 0x222a72 },
	{ 0xcef2, 0x222a73 },
	{ 0xcef3, 0x222a74 },
	{ 0xcef4, 0x222a75 },
	{ 0xcef5, 0x222a76 },
	{ 0xcef6, 0x222a77 },
	{ 0xcef7, 0x222a78 },
	{ 0xcef8, 0x222a79 },
	{ 0xcef9, 0x222a7a },
	{ 0xcefa, 0x222a7b },
	{ 0xcefb, 0x222a7c },
	{ 0xcefc, 0x222a7d },
	{ 0xcefd, 0x222a7e },
	{ 0xcefe, 0x222b21 },
	{ 0xcf40, 0x222b22 },
	{ 0xcf41, 0x222b23 },
	{ 0xcf42, 0x222b24 },
	{ 0xcf43, 0x222b25 },
	{ 0xcf44, 0x222b26 },
	{ 0xcf45, 0x222b27 },
	{ 0xcf46, 0x222b28 },
	{ 0xcf47, 0x222b29 },
	{ 0xcf48, 0x222b2a },
	{ 0xcf49, 0x222b2b },
	{ 0xcf4a, 0x222b2c },
	{ 0xcf4b, 0x222b2d },
	{ 0xcf4c, 0x222b2e },
	{ 0xcf4d, 0x222b2f },
	{ 0xcf4e, 0x222b30 },
	{ 0xcf4f, 0x222b31 },
	{ 0xcf50, 0x222b32 },
	{ 0xcf51, 0x222b33 },
	{ 0xcf52, 0x222b34 },
	{ 0xcf53, 0x222b35 },
	{ 0xcf54, 0x222b36 },
	{ 0xcf55, 0x222b37 },
	{ 0xcf56, 0x222b38 },
	{ 0xcf57, 0x222b39 },
	{ 0xcf58, 0x222b3a },
	{ 0xcf59, 0x222b3b },
	{ 0xcf5a, 0x222b3c },
	{ 0xcf5b, 0x222b3d },
	{ 0xcf5c, 0x222b3e },
	{ 0xcf5d, 0x222b3f },
	{ 0xcf5e, 0x222b40 },
	{ 0xcf5f, 0x222b41 },
	{ 0xcf60, 0x222b42 },
	{ 0xcf61, 0x222b43 },
	{ 0xcf62, 0x222b44 },
	{ 0xcf63, 0x222b45 },
	{ 0xcf64, 0x222b46 },
	{ 0xcf65, 0x222b47 },
	{ 0xcf66, 0x222b48 },
	{ 0xcf67, 0x222b49 },
	{ 0xcf68, 0x222b4a },
	{ 0xcf69, 0x222b4b },
	{ 0xcf6a, 0x222b4c },
	{ 0xcf6b, 0x222b4d },
	{ 0xcf6c, 0x222b4e },
	{ 0xcf6d, 0x222b4f },
	{ 0xcf6e, 0x222b50 },
	{ 0xcf6f, 0x222b51 },
	{ 0xcf70, 0x222b52 },
	{ 0xcf71, 0x222b53 },
	{ 0xcf72, 0x222b54 },
	{ 0xcf73, 0x222b55 },
	{ 0xcf74, 0x222b56 },
	{ 0xcf75, 0x222b57 },
	{ 0xcf76, 0x222b58 },
	{ 0xcf77, 0x222b59 },
	{ 0xcf78, 0x222b5a },
	{ 0xcf79, 0x222b5b },
	{ 0xcf7a, 0x222b5c },
	{ 0xcf7b, 0x222b5d },
	{ 0xcf7c, 0x222b5e },
	{ 0xcf7d, 0x222b5f },
	{ 0xcf7e, 0x222b60 },
	{ 0xcfa1, 0x222b61 },
	{ 0xcfa2, 0x222b62 },
	{ 0xcfa3, 0x222b63 },
	{ 0xcfa4, 0x222b64 },
	{ 0xcfa5, 0x222b65 },
	{ 0xcfa6, 0x222b66 },
	{ 0xcfa7, 0x222b67 },
	{ 0xcfa8, 0x222b68 },
	{ 0xcfa9, 0x222b69 },
	{ 0xcfaa, 0x222b6a },
	{ 0xcfab, 0x222b6b },
	{ 0xcfac, 0x222b6c },
	{ 0xcfad, 0x222b6d },
	{ 0xcfae, 0x222b6e },
	{ 0xcfaf, 0x222b6f },
	{ 0xcfb0, 0x222b70 },
	{ 0xcfb1, 0x222b71 },
	{ 0xcfb2, 0x222b72 },
	{ 0xcfb3, 0x222b73 },
	{ 0xcfb4, 0x222b74 },
	{ 0xcfb5, 0x222b75 },
	{ 0xcfb6, 0x222b76 },
	{ 0xcfb7, 0x222b77 },
	{ 0xcfb8, 0x222b78 },
	{ 0xcfb9, 0x222b79 },
	{ 0xcfba, 0x222b7a },
	{ 0xcfbb, 0x222b7b },
	{ 0xcfbc, 0x222b7c },
	{ 0xcfbd, 0x222b7d },
	{ 0xcfbe, 0x222b7e },
	{ 0xcfbf, 0x222c21 },
	{ 0xcfc0, 0x222c22 },
	{ 0xcfc1, 0x222c23 },
	{ 0xcfc2, 0x222c24 },
	{ 0xcfc3, 0x222c25 },
	{ 0xcfc4, 0x222c26 },
	{ 0xcfc5, 0x222c27 },
	{ 0xcfc6, 0x222c28 },
	{ 0xcfc7, 0x222c29 },
	{ 0xcfc8, 0x222c2a },
	{ 0xcfc9, 0x222c2b },
	{ 0xcfca, 0x222c2c },
	{ 0xcfcb, 0x222c2d },
	{ 0xcfcc, 0x222c2e },
	{ 0xcfcd, 0x222c2f },
	{ 0xcfce, 0x222c30 },
	{ 0xcfcf, 0x222c31 },
	{ 0xcfd0, 0x222c32 },
	{ 0xcfd1, 0x222c33 },
	{ 0xcfd2, 0x222c34 },
	{ 0xcfd3, 0x222c35 },
	{ 0xcfd4, 0x222c36 },
	{ 0xcfd5, 0x222c37 },
	{ 0xcfd6, 0x222c38 },
	{ 0xcfd7, 0x222c39 },
	{ 0xcfd8, 0x222c3a },
	{ 0xcfd9, 0x222c3b },
	{ 0xcfda, 0x222c3c },
	{ 0xcfdb, 0x222c3d },
	{ 0xcfdc, 0x222c3e },
	{ 0xcfdd, 0x222c3f },
	{ 0xcfde, 0x222c40 },
	{ 0xcfdf, 0x222c41 },
	{ 0xcfe0, 0x222c42 },
	{ 0xcfe1, 0x222c43 },
	{ 0xcfe2, 0x222c44 },
	{ 0xcfe3, 0x222c45 },
	{ 0xcfe4, 0x222c46 },
	{ 0xcfe5, 0x222c47 },
	{ 0xcfe6, 0x222c48 },
	{ 0xcfe7, 0x222c49 },
	{ 0xcfe8, 0x222c4a },
	{ 0xcfe9, 0x222c4b },
	{ 0xcfea, 0x222c4c },
	{ 0xcfeb, 0x222c4d },
	{ 0xcfec, 0x222c4e },
	{ 0xcfed, 0x222c4f },
	{ 0xcfee, 0x222c50 },
	{ 0xcfef, 0x222c51 },
	{ 0xcff0, 0x222c52 },
	{ 0xcff1, 0x222c53 },
	{ 0xcff2, 0x222c54 },
	{ 0xcff3, 0x222c55 },
	{ 0xcff4, 0x222c56 },
	{ 0xcff5, 0x222c57 },
	{ 0xcff6, 0x222c58 },
	{ 0xcff7, 0x222c59 },
	{ 0xcff8, 0x222c5a },
	{ 0xcff9, 0x222c5b },
	{ 0xcffa, 0x222c5c },
	{ 0xcffb, 0x222c5d },
	{ 0xcffc, 0x222c5e },
	{ 0xcffd, 0x222c5f },
	{ 0xcffe, 0x222c60 },
	{ 0xd040, 0x222c61 },
	{ 0xd041, 0x222c62 },
	{ 0xd042, 0x222c63 },
	{ 0xd043, 0x222c64 },
	{ 0xd044, 0x222c65 },
	{ 0xd045, 0x222c66 },
	{ 0xd046, 0x222c67 },
	{ 0xd047, 0x222c68 },
	{ 0xd048, 0x222c69 },
	{ 0xd049, 0x222c6a },
	{ 0xd04a, 0x222c6b },
	{ 0xd04b, 0x222c6c },
	{ 0xd04c, 0x222c6d },
	{ 0xd04d, 0x222c6e },
	{ 0xd04e, 0x222c6f },
	{ 0xd04f, 0x222c70 },
	{ 0xd050, 0x222c71 },
	{ 0xd051, 0x222c72 },
	{ 0xd052, 0x222c73 },
	{ 0xd053, 0x222c74 },
	{ 0xd054, 0x222c75 },
	{ 0xd055, 0x222c76 },
	{ 0xd056, 0x222c77 },
	{ 0xd057, 0x222c78 },
	{ 0xd058, 0x222c79 },
	{ 0xd059, 0x222c7a },
	{ 0xd05a, 0x222c7b },
	{ 0xd05b, 0x222c7c },
	{ 0xd05c, 0x222c7d },
	{ 0xd05d, 0x222c7e },
	{ 0xd05e, 0x222d21 },
	{ 0xd05f, 0x222d22 },
	{ 0xd060, 0x222d23 },
	{ 0xd061, 0x222d24 },
	{ 0xd062, 0x222d25 },
	{ 0xd063, 0x222d26 },
	{ 0xd064, 0x222d27 },
	{ 0xd065, 0x222d28 },
	{ 0xd066, 0x222d29 },
	{ 0xd067, 0x222d2a },
	{ 0xd068, 0x222d2b },
	{ 0xd069, 0x222d2c },
	{ 0xd06a, 0x222d2d },
	{ 0xd06b, 0x222d2e },
	{ 0xd06c, 0x222d2f },
	{ 0xd06d, 0x222d30 },
	{ 0xd06e, 0x222d31 },
	{ 0xd06f, 0x222d32 },
	{ 0xd070, 0x222d33 },
	{ 0xd071, 0x222d34 },
	{ 0xd072, 0x222d35 },
	{ 0xd073, 0x222d36 },
	{ 0xd074, 0x222d37 },
	{ 0xd075, 0x222d38 },
	{ 0xd076, 0x222d39 },
	{ 0xd077, 0x222d3a },
	{ 0xd078, 0x222d3b },
	{ 0xd079, 0x222d3c },
	{ 0xd07a, 0x222d3d },
	{ 0xd07b, 0x222d3e },
	{ 0xd07c, 0x222d3f },
	{ 0xd07d, 0x222d40 },
	{ 0xd07e, 0x222d41 },
	{ 0xd0a1, 0x222d42 },
	{ 0xd0a2, 0x222d43 },
	{ 0xd0a3, 0x222d44 },
	{ 0xd0a4, 0x222d45 },
	{ 0xd0a5, 0x222d46 },
	{ 0xd0a6, 0x222d47 },
	{ 0xd0a7, 0x222d48 },
	{ 0xd0a8, 0x222d49 },
	{ 0xd0a9, 0x222d4a },
	{ 0xd0aa, 0x222d4b },
	{ 0xd0ab, 0x222d4c },
	{ 0xd0ac, 0x222d4d },
	{ 0xd0ad, 0x222d4e },
	{ 0xd0ae, 0x222d4f },
	{ 0xd0af, 0x222d50 },
	{ 0xd0b0, 0x222d51 },
	{ 0xd0b1, 0x222d52 },
	{ 0xd0b2, 0x222d53 },
	{ 0xd0b3, 0x222d54 },
	{ 0xd0b4, 0x222d55 },
	{ 0xd0b5, 0x222d56 },
	{ 0xd0b6, 0x222d57 },
	{ 0xd0b7, 0x222d58 },
	{ 0xd0b8, 0x222d59 },
	{ 0xd0b9, 0x222d5a },
	{ 0xd0ba, 0x222d5b },
	{ 0xd0bb, 0x222d5c },
	{ 0xd0bc, 0x222d5d },
	{ 0xd0bd, 0x222d5e },
	{ 0xd0be, 0x222d5f },
	{ 0xd0bf, 0x222d60 },
	{ 0xd0c0, 0x222d61 },
	{ 0xd0c1, 0x222d62 },
	{ 0xd0c2, 0x222d63 },
	{ 0xd0c3, 0x222d64 },
	{ 0xd0c4, 0x222d65 },
	{ 0xd0c5, 0x222d66 },
	{ 0xd0c6, 0x222d67 },
	{ 0xd0c7, 0x222d68 },
	{ 0xd0c8, 0x222d69 },
	{ 0xd0c9, 0x222d6a },
	{ 0xd0ca, 0x222d6b },
	{ 0xd0cb, 0x222d6c },
	{ 0xd0cc, 0x222d6d },
	{ 0xd0cd, 0x222d6e },
	{ 0xd0ce, 0x222d6f },
	{ 0xd0cf, 0x222d70 },
	{ 0xd0d0, 0x222d71 },
	{ 0xd0d1, 0x222d72 },
	{ 0xd0d2, 0x222d73 },
	{ 0xd0d3, 0x222d74 },
	{ 0xd0d4, 0x222d75 },
	{ 0xd0d5, 0x222d76 },
	{ 0xd0d6, 0x222d77 },
	{ 0xd0d7, 0x222d78 },
	{ 0xd0d8, 0x222d79 },
	{ 0xd0d9, 0x222d7a },
	{ 0xd0da, 0x222d7b },
	{ 0xd0db, 0x222d7c },
	{ 0xd0dc, 0x222d7d },
	{ 0xd0dd, 0x222d7e },
	{ 0xd0de, 0x222e21 },
	{ 0xd0df, 0x222e22 },
	{ 0xd0e0, 0x222e23 },
	{ 0xd0e1, 0x222e24 },
	{ 0xd0e2, 0x222e25 },
	{ 0xd0e3, 0x222e26 },
	{ 0xd0e4, 0x222e27 },
	{ 0xd0e5, 0x222e28 },
	{ 0xd0e6, 0x222e29 },
	{ 0xd0e7, 0x222e2a },
	{ 0xd0e8, 0x222e2b },
	{ 0xd0e9, 0x222e2c },
	{ 0xd0ea, 0x222e2d },
	{ 0xd0eb, 0x222e2e },
	{ 0xd0ec, 0x222e2f },
	{ 0xd0ed, 0x222e30 },
	{ 0xd0ee, 0x222e31 },
	{ 0xd0ef, 0x222e32 },
	{ 0xd0f0, 0x222e33 },
	{ 0xd0f1, 0x222e34 },
	{ 0xd0f2, 0x222e35 },
	{ 0xd0f3, 0x222e36 },
	{ 0xd0f4, 0x222e37 },
	{ 0xd0f5, 0x222e38 },
	{ 0xd0f6, 0x222e39 },
	{ 0xd0f7, 0x222e3a },
	{ 0xd0f8, 0x222e3b },
	{ 0xd0f9, 0x222e3c },
	{ 0xd0fa, 0x222e3d },
	{ 0xd0fb, 0x222e3e },
	{ 0xd0fc, 0x222e3f },
	{ 0xd0fd, 0x222e40 },
	{ 0xd0fe, 0x222e41 },
	{ 0xd140, 0x222e42 },
	{ 0xd141, 0x222e43 },
	{ 0xd142, 0x222e44 },
	{ 0xd143, 0x222e45 },
	{ 0xd144, 0x222e46 },
	{ 0xd145, 0x222e47 },
	{ 0xd146, 0x222e48 },
	{ 0xd147, 0x222e49 },
	{ 0xd148, 0x222e4a },
	{ 0xd149, 0x222e4b },
	{ 0xd14a, 0x222e4c },
	{ 0xd14b, 0x222e4d },
	{ 0xd14c, 0x222e4e },
	{ 0xd14d, 0x222e4f },
	{ 0xd14e, 0x222e50 },
	{ 0xd14f, 0x222e51 },
	{ 0xd150, 0x222e52 },
	{ 0xd151, 0x222e53 },
	{ 0xd152, 0x222e54 },
	{ 0xd153, 0x222e55 },
	{ 0xd154, 0x222e56 },
	{ 0xd155, 0x222e57 },
	{ 0xd156, 0x222e58 },
	{ 0xd157, 0x222e59 },
	{ 0xd158, 0x222e5a },
	{ 0xd159, 0x222e5b },
	{ 0xd15a, 0x222e5c },
	{ 0xd15b, 0x222e5d },
	{ 0xd15c, 0x222e5e },
	{ 0xd15d, 0x222e5f },
	{ 0xd15e, 0x222e60 },
	{ 0xd15f, 0x222e61 },
	{ 0xd160, 0x222e62 },
	{ 0xd161, 0x222e63 },
	{ 0xd162, 0x222e64 },
	{ 0xd163, 0x222e65 },
	{ 0xd164, 0x222e66 },
	{ 0xd165, 0x222e67 },
	{ 0xd166, 0x222e68 },
	{ 0xd167, 0x222e69 },
	{ 0xd168, 0x222e6a },
	{ 0xd169, 0x222e6b },
	{ 0xd16a, 0x222e6c },
	{ 0xd16b, 0x222e6d },
	{ 0xd16c, 0x222e6e },
	{ 0xd16d, 0x222e6f },
	{ 0xd16e, 0x222e70 },
	{ 0xd16f, 0x222e71 },
	{ 0xd170, 0x222e72 },
	{ 0xd171, 0x222e73 },
	{ 0xd172, 0x222e74 },
	{ 0xd173, 0x222e75 },
	{ 0xd174, 0x222e76 },
	{ 0xd175, 0x222e77 },
	{ 0xd176, 0x222e78 },
	{ 0xd177, 0x222e79 },
	{ 0xd178, 0x222e7a },
	{ 0xd179, 0x222e7b },
	{ 0xd17a, 0x222e7c },
	{ 0xd17b, 0x222e7d },
	{ 0xd17c, 0x222e7e },
	{ 0xd17d, 0x222f21 },
	{ 0xd17e, 0x222f22 },
	{ 0xd1a1, 0x222f23 },
	{ 0xd1a2, 0x222f24 },
	{ 0xd1a3, 0x222f25 },
	{ 0xd1a4, 0x222f26 },
	{ 0xd1a5, 0x222f27 },
	{ 0xd1a6, 0x222f28 },
	{ 0xd1a7, 0x222f29 },
	{ 0xd1a8, 0x222f2a },
	{ 0xd1a9, 0x222f2b },
	{ 0xd1aa, 0x222f2c },
	{ 0xd1ab, 0x222f2d },
	{ 0xd1ac, 0x222f2e },
	{ 0xd1ad, 0x222f2f },
	{ 0xd1ae, 0x222f30 },
	{ 0xd1af, 0x222f31 },
	{ 0xd1b0, 0x222f32 },
	{ 0xd1b1, 0x222f33 },
	{ 0xd1b2, 0x222f34 },
	{ 0xd1b3, 0x222f35 },
	{ 0xd1b4, 0x222f36 },
	{ 0xd1b5, 0x222f37 },
	{ 0xd1b6, 0x222f38 },
	{ 0xd1b7, 0x222f39 },
	{ 0xd1b8, 0x222f3a },
	{ 0xd1b9, 0x222f3b },
	{ 0xd1ba, 0x222f3c },
	{ 0xd1bb, 0x222f3d },
	{ 0xd1bc, 0x222f3e },
	{ 0xd1bd, 0x222f3f },
	{ 0xd1be, 0x222f40 },
	{ 0xd1bf, 0x222f41 },
	{ 0xd1c0, 0x222f42 },
	{ 0xd1c1, 0x222f43 },
	{ 0xd1c2, 0x222f44 },
	{ 0xd1c3, 0x222f45 },
	{ 0xd1c4, 0x222f46 },
	{ 0xd1c5, 0x222f47 },
	{ 0xd1c6, 0x222f48 },
	{ 0xd1c7, 0x222f49 },
	{ 0xd1c8, 0x222f4a },
	{ 0xd1c9, 0x222f4b },
	{ 0xd1ca, 0x222f4c },
	{ 0xd1cb, 0x222f4d },
	{ 0xd1cc, 0x222f4e },
	{ 0xd1cd, 0x222f4f },
	{ 0xd1ce, 0x222f50 },
	{ 0xd1cf, 0x222f51 },
	{ 0xd1d0, 0x222f52 },
	{ 0xd1d1, 0x222f53 },
	{ 0xd1d2, 0x222f54 },
	{ 0xd1d3, 0x222f55 },
	{ 0xd1d4, 0x222f56 },
	{ 0xd1d5, 0x222f57 },
	{ 0xd1d6, 0x222f58 },
	{ 0xd1d7, 0x222f59 },
	{ 0xd1d8, 0x222f5a },
	{ 0xd1d9, 0x222f5b },
	{ 0xd1da, 0x222f5c },
	{ 0xd1db, 0x222f5d },
	{ 0xd1dc, 0x222f5e },
	{ 0xd1dd, 0x222f5f },
	{ 0xd1de, 0x222f60 },
	{ 0xd1df, 0x222f61 },
	{ 0xd1e0, 0x222f62 },
	{ 0xd1e1, 0x222f63 },
	{ 0xd1e2, 0x222f64 },
	{ 0xd1e3, 0x222f65 },
	{ 0xd1e4, 0x222f66 },
	{ 0xd1e5, 0x222f67 },
	{ 0xd1e6, 0x222f68 },
	{ 0xd1e7, 0x222f69 },
	{ 0xd1e8, 0x222f6a },
	{ 0xd1e9, 0x222f6b },
	{ 0xd1ea, 0x222f6c },
	{ 0xd1eb, 0x222f6d },
	{ 0xd1ec, 0x222f6e },
	{ 0xd1ed, 0x222f6f },
	{ 0xd1ee, 0x222f70 },
	{ 0xd1ef, 0x222f71 },
	{ 0xd1f0, 0x222f72 },
	{ 0xd1f1, 0x222f73 },
	{ 0xd1f2, 0x222f74 },
	{ 0xd1f3, 0x222f75 },
	{ 0xd1f4, 0x222f76 },
	{ 0xd1f5, 0x222f77 },
	{ 0xd1f6, 0x222f78 },
	{ 0xd1f7, 0x222f79 },
	{ 0xd1f8, 0x222f7a },
	{ 0xd1f9, 0x222f7b },
	{ 0xd1fa, 0x222f7c },
	{ 0xd1fb, 0x222f7d },
	{ 0xd1fc, 0x222f7e },
	{ 0xd1fd, 0x223021 },
	{ 0xd1fe, 0x223022 },
	{ 0xd240, 0x223023 },
	{ 0xd241, 0x223024 },
	{ 0xd242, 0x223025 },
	{ 0xd243, 0x223026 },
	{ 0xd244, 0x223027 },
	{ 0xd245, 0x223028 },
	{ 0xd246, 0x223029 },
	{ 0xd247, 0x22302a },
	{ 0xd248, 0x22302b },
	{ 0xd249, 0x22302c },
	{ 0xd24a, 0x22302d },
	{ 0xd24b, 0x22302e },
	{ 0xd24c, 0x22302f },
	{ 0xd24d, 0x223030 },
	{ 0xd24e, 0x223031 },
	{ 0xd24f, 0x223032 },
	{ 0xd250, 0x223033 },
	{ 0xd251, 0x223034 },
	{ 0xd252, 0x223035 },
	{ 0xd253, 0x223036 },
	{ 0xd254, 0x223037 },
	{ 0xd255, 0x223038 },
	{ 0xd256, 0x223039 },
	{ 0xd257, 0x22303a },
	{ 0xd258, 0x22303b },
	{ 0xd259, 0x22303c },
	{ 0xd25a, 0x22303d },
	{ 0xd25b, 0x22303e },
	{ 0xd25c, 0x22303f },
	{ 0xd25d, 0x223040 },
	{ 0xd25e, 0x223041 },
	{ 0xd25f, 0x223042 },
	{ 0xd260, 0x223043 },
	{ 0xd261, 0x223044 },
	{ 0xd262, 0x223045 },
	{ 0xd263, 0x223046 },
	{ 0xd264, 0x223047 },
	{ 0xd265, 0x223048 },
	{ 0xd266, 0x223049 },
	{ 0xd267, 0x22304a },
	{ 0xd268, 0x22304b },
	{ 0xd269, 0x22304c },
	{ 0xd26a, 0x22304d },
	{ 0xd26b, 0x22304e },
	{ 0xd26c, 0x22304f },
	{ 0xd26d, 0x223050 },
	{ 0xd26e, 0x223051 },
	{ 0xd26f, 0x223052 },
	{ 0xd270, 0x223053 },
	{ 0xd271, 0x223054 },
	{ 0xd272, 0x223055 },
	{ 0xd273, 0x223056 },
	{ 0xd274, 0x223057 },
	{ 0xd275, 0x223058 },
	{ 0xd276, 0x223059 },
	{ 0xd277, 0x22305a },
	{ 0xd278, 0x22305b },
	{ 0xd279, 0x22305c },
	{ 0xd27a, 0x22305d },
	{ 0xd27b, 0x22305e },
	{ 0xd27c, 0x22305f },
	{ 0xd27d, 0x223060 },
	{ 0xd27e, 0x223061 },
	{ 0xd2a1, 0x223062 },
	{ 0xd2a2, 0x223063 },
	{ 0xd2a3, 0x223064 },
	{ 0xd2a4, 0x223065 },
	{ 0xd2a5, 0x223066 },
	{ 0xd2a6, 0x223067 },
	{ 0xd2a7, 0x223068 },
	{ 0xd2a8, 0x223069 },
	{ 0xd2a9, 0x22306a },
	{ 0xd2aa, 0x22306b },
	{ 0xd2ab, 0x22306c },
	{ 0xd2ac, 0x22306d },
	{ 0xd2ad, 0x22306e },
	{ 0xd2ae, 0x22306f },
	{ 0xd2af, 0x223070 },
	{ 0xd2b0, 0x223071 },
	{ 0xd2b1, 0x223072 },
	{ 0xd2b2, 0x223073 },
	{ 0xd2b3, 0x223074 },
	{ 0xd2b4, 0x223075 },
	{ 0xd2b5, 0x223076 },
	{ 0xd2b6, 0x223077 },
	{ 0xd2b7, 0x223078 },
	{ 0xd2b8, 0x223079 },
	{ 0xd2b9, 0x22307a },
	{ 0xd2ba, 0x22307b },
	{ 0xd2bb, 0x22307c },
	{ 0xd2bc, 0x22307d },
	{ 0xd2bd, 0x22307e },
	{ 0xd2be, 0x223121 },
	{ 0xd2bf, 0x223122 },
	{ 0xd2c0, 0x223123 },
	{ 0xd2c1, 0x223124 },
	{ 0xd2c2, 0x223125 },
	{ 0xd2c3, 0x223126 },
	{ 0xd2c4, 0x223127 },
	{ 0xd2c5, 0x223128 },
	{ 0xd2c6, 0x223129 },
	{ 0xd2c7, 0x22312a },
	{ 0xd2c8, 0x22312b },
	{ 0xd2c9, 0x22312c },
	{ 0xd2ca, 0x22312d },
	{ 0xd2cb, 0x22312e },
	{ 0xd2cc, 0x22312f },
	{ 0xd2cd, 0x223130 },
	{ 0xd2ce, 0x223131 },
	{ 0xd2cf, 0x223132 },
	{ 0xd2d0, 0x223133 },
	{ 0xd2d1, 0x223134 },
	{ 0xd2d2, 0x223135 },
	{ 0xd2d3, 0x223136 },
	{ 0xd2d4, 0x223137 },
	{ 0xd2d5, 0x223138 },
	{ 0xd2d6, 0x223139 },
	{ 0xd2d7, 0x22313a },
	{ 0xd2d8, 0x22313b },
	{ 0xd2d9, 0x22313c },
	{ 0xd2da, 0x22313d },
	{ 0xd2db, 0x22313e },
	{ 0xd2dc, 0x22313f },
	{ 0xd2dd, 0x223140 },
	{ 0xd2de, 0x223141 },
	{ 0xd2df, 0x223142 },
	{ 0xd2e0, 0x223143 },
	{ 0xd2e1, 0x223144 },
	{ 0xd2e2, 0x223145 },
	{ 0xd2e3, 0x223146 },
	{ 0xd2e4, 0x223147 },
	{ 0xd2e5, 0x223148 },
	{ 0xd2e6, 0x223149 },
	{ 0xd2e7, 0x22314a },
	{ 0xd2e8, 0x22314b },
	{ 0xd2e9, 0x22314c },
	{ 0xd2ea, 0x22314d },
	{ 0xd2eb, 0x22314e },
	{ 0xd2ec, 0x22314f },
	{ 0xd2ed, 0x223150 },
	{ 0xd2ee, 0x223151 },
	{ 0xd2ef, 0x223152 },
	{ 0xd2f0, 0x223153 },
	{ 0xd2f1, 0x223154 },
	{ 0xd2f2, 0x223155 },
	{ 0xd2f3, 0x223156 },
	{ 0xd2f4, 0x223157 },
	{ 0xd2f5, 0x223158 },
	{ 0xd2f6, 0x223159 },
	{ 0xd2f7, 0x22315a },
	{ 0xd2f8, 0x22315b },
	{ 0xd2f9, 0x22315c },
	{ 0xd2fa, 0x22315d },
	{ 0xd2fb, 0x22315e },
	{ 0xd2fc, 0x22315f },
	{ 0xd2fd, 0x223160 },
	{ 0xd2fe, 0x223161 },
	{ 0xd340, 0x223162 },
	{ 0xd341, 0x223163 },
	{ 0xd342, 0x223164 },
	{ 0xd343, 0x223165 },
	{ 0xd344, 0x223166 },
	{ 0xd345, 0x223167 },
	{ 0xd346, 0x223168 },
	{ 0xd347, 0x223169 },
	{ 0xd348, 0x22316a },
	{ 0xd349, 0x22316b },
	{ 0xd34a, 0x22316c },
	{ 0xd34b, 0x22316d },
	{ 0xd34c, 0x22316e },
	{ 0xd34d, 0x22316f },
	{ 0xd34e, 0x223170 },
	{ 0xd34f, 0x223171 },
	{ 0xd350, 0x223172 },
	{ 0xd351, 0x223173 },
	{ 0xd352, 0x223174 },
	{ 0xd353, 0x223175 },
	{ 0xd354, 0x223176 },
	{ 0xd355, 0x223177 },
	{ 0xd356, 0x223178 },
	{ 0xd357, 0x223179 },
	{ 0xd358, 0x22317a },
	{ 0xd359, 0x22317b },
	{ 0xd35a, 0x22317c },
	{ 0xd35b, 0x22317d },
	{ 0xd35c, 0x22317e },
	{ 0xd35d, 0x223221 },
	{ 0xd35e, 0x223222 },
	{ 0xd35f, 0x223223 },
	{ 0xd360, 0x223224 },
	{ 0xd361, 0x223225 },
	{ 0xd362, 0x223226 },
	{ 0xd363, 0x223227 },
	{ 0xd364, 0x223228 },
	{ 0xd365, 0x223229 },
	{ 0xd366, 0x22322a },
	{ 0xd367, 0x22322b },
	{ 0xd368, 0x22322c },
	{ 0xd369, 0x22322d },
	{ 0xd36a, 0x22322e },
	{ 0xd36b, 0x22322f },
	{ 0xd36c, 0x223230 },
	{ 0xd36d, 0x223231 },
	{ 0xd36e, 0x223232 },
	{ 0xd36f, 0x223233 },
	{ 0xd370, 0x223234 },
	{ 0xd371, 0x223235 },
	{ 0xd372, 0x223236 },
	{ 0xd373, 0x223237 },
	{ 0xd374, 0x223238 },
	{ 0xd375, 0x223239 },
	{ 0xd376, 0x22323a },
	{ 0xd377, 0x22323b },
	{ 0xd378, 0x22323c },
	{ 0xd379, 0x22323d },
	{ 0xd37a, 0x22323e },
	{ 0xd37b, 0x22323f },
	{ 0xd37c, 0x223240 },
	{ 0xd37d, 0x223241 },
	{ 0xd37e, 0x223242 },
	{ 0xd3a1, 0x223243 },
	{ 0xd3a2, 0x223244 },
	{ 0xd3a3, 0x223245 },
	{ 0xd3a4, 0x223246 },
	{ 0xd3a5, 0x223247 },
	{ 0xd3a6, 0x223248 },
	{ 0xd3a7, 0x223249 },
	{ 0xd3a8, 0x22324a },
	{ 0xd3a9, 0x22324b },
	{ 0xd3aa, 0x22324c },
	{ 0xd3ab, 0x22324d },
	{ 0xd3ac, 0x22324e },
	{ 0xd3ad, 0x22324f },
	{ 0xd3ae, 0x223250 },
	{ 0xd3af, 0x223251 },
	{ 0xd3b0, 0x223252 },
	{ 0xd3b1, 0x223253 },
	{ 0xd3b2, 0x223254 },
	{ 0xd3b3, 0x223255 },
	{ 0xd3b4, 0x223256 },
	{ 0xd3b5, 0x223257 },
	{ 0xd3b6, 0x223258 },
	{ 0xd3b7, 0x223259 },
	{ 0xd3b8, 0x22325a },
	{ 0xd3b9, 0x22325b },
	{ 0xd3ba, 0x22325c },
	{ 0xd3bb, 0x22325d },
	{ 0xd3bc, 0x22325e },
	{ 0xd3bd, 0x22325f },
	{ 0xd3be, 0x223260 },
	{ 0xd3bf, 0x223261 },
	{ 0xd3c0, 0x223262 },
	{ 0xd3c1, 0x223263 },
	{ 0xd3c2, 0x223264 },
	{ 0xd3c3, 0x223265 },
	{ 0xd3c4, 0x223266 },
	{ 0xd3c5, 0x223267 },
	{ 0xd3c6, 0x223268 },
	{ 0xd3c7, 0x223269 },
	{ 0xd3c8, 0x22326a },
	{ 0xd3c9, 0x22326b },
	{ 0xd3ca, 0x22326c },
	{ 0xd3cb, 0x22326d },
	{ 0xd3cc, 0x22326e },
	{ 0xd3cd, 0x22326f },
	{ 0xd3ce, 0x223270 },
	{ 0xd3cf, 0x223271 },
	{ 0xd3d0, 0x223272 },
	{ 0xd3d1, 0x223273 },
	{ 0xd3d2, 0x223274 },
	{ 0xd3d3, 0x223275 },
	{ 0xd3d4, 0x223276 },
	{ 0xd3d5, 0x223277 },
	{ 0xd3d6, 0x223278 },
	{ 0xd3d7, 0x223279 },
	{ 0xd3d8, 0x22327a },
	{ 0xd3d9, 0x22327b },
	{ 0xd3da, 0x22327c },
	{ 0xd3db, 0x22327d },
	{ 0xd3dc, 0x22327e },
	{ 0xd3dd, 0x223321 },
	{ 0xd3de, 0x223322 },
	{ 0xd3df, 0x223323 },
	{ 0xd3e0, 0x223324 },
	{ 0xd3e1, 0x223325 },
	{ 0xd3e2, 0x223326 },
	{ 0xd3e3, 0x223327 },
	{ 0xd3e4, 0x223328 },
	{ 0xd3e5, 0x223329 },
	{ 0xd3e6, 0x22332a },
	{ 0xd3e7, 0x22332b },
	{ 0xd3e8, 0x22332c },
	{ 0xd3e9, 0x22332d },
	{ 0xd3ea, 0x22332e },
	{ 0xd3eb, 0x22332f },
	{ 0xd3ec, 0x223330 },
	{ 0xd3ed, 0x223331 },
	{ 0xd3ee, 0x223332 },
	{ 0xd3ef, 0x223333 },
	{ 0xd3f0, 0x223334 },
	{ 0xd3f1, 0x223335 },
	{ 0xd3f2, 0x223336 },
	{ 0xd3f3, 0x223337 },
	{ 0xd3f4, 0x223338 },
	{ 0xd3f5, 0x223339 },
	{ 0xd3f6, 0x22333a },
	{ 0xd3f7, 0x22333b },
	{ 0xd3f8, 0x22333c },
	{ 0xd3f9, 0x22333d },
	{ 0xd3fa, 0x22333e },
	{ 0xd3fb, 0x22333f },
	{ 0xd3fc, 0x223340 },
	{ 0xd3fd, 0x223341 },
	{ 0xd3fe, 0x223342 },
	{ 0xd440, 0x223343 },
	{ 0xd441, 0x223344 },
	{ 0xd442, 0x223345 },
	{ 0xd443, 0x223346 },
	{ 0xd444, 0x223347 },
	{ 0xd445, 0x223348 },
	{ 0xd446, 0x223349 },
	{ 0xd447, 0x22334a },
	{ 0xd448, 0x22334b },
	{ 0xd449, 0x22334c },
	{ 0xd44a, 0x22334d },
	{ 0xd44b, 0x22334e },
	{ 0xd44c, 0x22334f },
	{ 0xd44d, 0x223350 },
	{ 0xd44e, 0x223351 },
	{ 0xd44f, 0x223352 },
	{ 0xd450, 0x223353 },
	{ 0xd451, 0x223354 },
	{ 0xd452, 0x223355 },
	{ 0xd453, 0x223356 },
	{ 0xd454, 0x223357 },
	{ 0xd455, 0x223358 },
	{ 0xd456, 0x223359 },
	{ 0xd457, 0x22335a },
	{ 0xd458, 0x22335b },
	{ 0xd459, 0x22335c },
	{ 0xd45a, 0x22335d },
	{ 0xd45b, 0x22335e },
	{ 0xd45c, 0x22335f },
	{ 0xd45d, 0x223360 },
	{ 0xd45e, 0x223361 },
	{ 0xd45f, 0x223362 },
	{ 0xd460, 0x223363 },
	{ 0xd461, 0x223364 },
	{ 0xd462, 0x223365 },
	{ 0xd463, 0x223366 },
	{ 0xd464, 0x223367 },
	{ 0xd465, 0x223368 },
	{ 0xd466, 0x223369 },
	{ 0xd467, 0x22336a },
	{ 0xd468, 0x22336b },
	{ 0xd469, 0x22336c },
	{ 0xd46a, 0x22336d },
	{ 0xd46b, 0x22336e },
	{ 0xd46c, 0x22336f },
	{ 0xd46d, 0x223370 },
	{ 0xd46e, 0x223371 },
	{ 0xd46f, 0x223372 },
	{ 0xd470, 0x223373 },
	{ 0xd471, 0x223374 },
	{ 0xd472, 0x223375 },
	{ 0xd473, 0x223376 },
	{ 0xd474, 0x223377 },
	{ 0xd475, 0x223378 },
	{ 0xd476, 0x223379 },
	{ 0xd477, 0x22337a },
	{ 0xd478, 0x22337b },
	{ 0xd479, 0x22337c },
	{ 0xd47a, 0x22337d },
	{ 0xd47b, 0x22337e },
	{ 0xd47c, 0x223421 },
	{ 0xd47d, 0x223422 },
	{ 0xd47e, 0x223423 },
	{ 0xd4a1, 0x223424 },
	{ 0xd4a2, 0x223425 },
	{ 0xd4a3, 0x223426 },
	{ 0xd4a4, 0x223427 },
	{ 0xd4a5, 0x223428 },
	{ 0xd4a6, 0x223429 },
	{ 0xd4a7, 0x22342a },
	{ 0xd4a8, 0x22342b },
	{ 0xd4a9, 0x22342c },
	{ 0xd4aa, 0x22342d },
	{ 0xd4ab, 0x22342e },
	{ 0xd4ac, 0x22342f },
	{ 0xd4ad, 0x223430 },
	{ 0xd4ae, 0x223431 },
	{ 0xd4af, 0x223432 },
	{ 0xd4b0, 0x223433 },
	{ 0xd4b1, 0x223434 },
	{ 0xd4b2, 0x223435 },
	{ 0xd4b3, 0x223436 },
	{ 0xd4b4, 0x223437 },
	{ 0xd4b5, 0x223438 },
	{ 0xd4b6, 0x223439 },
	{ 0xd4b7, 0x22343a },
	{ 0xd4b8, 0x22343b },
	{ 0xd4b9, 0x22343c },
	{ 0xd4ba, 0x22343d },
	{ 0xd4bb, 0x22343e },
	{ 0xd4bc, 0x22343f },
	{ 0xd4bd, 0x223440 },
	{ 0xd4be, 0x223441 },
	{ 0xd4bf, 0x223442 },
	{ 0xd4c0, 0x223443 },
	{ 0xd4c1, 0x223444 },
	{ 0xd4c2, 0x223445 },
	{ 0xd4c3, 0x223446 },
	{ 0xd4c4, 0x223447 },
	{ 0xd4c5, 0x223448 },
	{ 0xd4c6, 0x223449 },
	{ 0xd4c7, 0x22344a },
	{ 0xd4c8, 0x22344b },
	{ 0xd4c9, 0x22344c },
	{ 0xd4ca, 0x22344d },
	{ 0xd4cb, 0x22344e },
	{ 0xd4cc, 0x22344f },
	{ 0xd4cd, 0x223450 },
	{ 0xd4ce, 0x223451 },
	{ 0xd4cf, 0x223452 },
	{ 0xd4d0, 0x223453 },
	{ 0xd4d1, 0x223454 },
	{ 0xd4d2, 0x223455 },
	{ 0xd4d3, 0x223456 },
	{ 0xd4d4, 0x223457 },
	{ 0xd4d5, 0x223458 },
	{ 0xd4d6, 0x223459 },
	{ 0xd4d7, 0x22345a },
	{ 0xd4d8, 0x22345b },
	{ 0xd4d9, 0x22345c },
	{ 0xd4da, 0x22345d },
	{ 0xd4db, 0x22345e },
	{ 0xd4dc, 0x22345f },
	{ 0xd4dd, 0x223460 },
	{ 0xd4de, 0x223461 },
	{ 0xd4df, 0x223462 },
	{ 0xd4e0, 0x223463 },
	{ 0xd4e1, 0x223464 },
	{ 0xd4e2, 0x223465 },
	{ 0xd4e3, 0x223466 },
	{ 0xd4e4, 0x223467 },
	{ 0xd4e5, 0x223468 },
	{ 0xd4e6, 0x223469 },
	{ 0xd4e7, 0x22346a },
	{ 0xd4e8, 0x22346b },
	{ 0xd4e9, 0x22346c },
	{ 0xd4ea, 0x22346d },
	{ 0xd4eb, 0x22346e },
	{ 0xd4ec, 0x22346f },
	{ 0xd4ed, 0x223470 },
	{ 0xd4ee, 0x223471 },
	{ 0xd4ef, 0x223472 },
	{ 0xd4f0, 0x223473 },
	{ 0xd4f1, 0x223474 },
	{ 0xd4f2, 0x223475 },
	{ 0xd4f3, 0x223476 },
	{ 0xd4f4, 0x223477 },
	{ 0xd4f5, 0x223478 },
	{ 0xd4f6, 0x223479 },
	{ 0xd4f7, 0x22347a },
	{ 0xd4f8, 0x22347b },
	{ 0xd4f9, 0x22347c },
	{ 0xd4fa, 0x22347d },
	{ 0xd4fb, 0x22347e },
	{ 0xd4fc, 0x223521 },
	{ 0xd4fd, 0x223522 },
	{ 0xd4fe, 0x223523 },
	{ 0xd540, 0x223524 },
	{ 0xd541, 0x223525 },
	{ 0xd542, 0x223526 },
	{ 0xd543, 0x223527 },
	{ 0xd544, 0x223528 },
	{ 0xd545, 0x223529 },
	{ 0xd546, 0x22352a },
	{ 0xd547, 0x22352b },
	{ 0xd548, 0x22352c },
	{ 0xd549, 0x22352d },
	{ 0xd54a, 0x22352e },
	{ 0xd54b, 0x22352f },
	{ 0xd54c, 0x223530 },
	{ 0xd54d, 0x223531 },
	{ 0xd54e, 0x223532 },
	{ 0xd54f, 0x223533 },
	{ 0xd550, 0x223534 },
	{ 0xd551, 0x223535 },
	{ 0xd552, 0x223536 },
	{ 0xd553, 0x223537 },
	{ 0xd554, 0x223538 },
	{ 0xd555, 0x223539 },
	{ 0xd556, 0x22353a },
	{ 0xd557, 0x22353b },
	{ 0xd558, 0x22353c },
	{ 0xd559, 0x22353d },
	{ 0xd55a, 0x22353e },
	{ 0xd55b, 0x22353f },
	{ 0xd55c, 0x223540 },
	{ 0xd55d, 0x223541 },
	{ 0xd55e, 0x223542 },
	{ 0xd55f, 0x223543 },
	{ 0xd560, 0x223544 },
	{ 0xd561, 0x223545 },
	{ 0xd562, 0x223546 },
	{ 0xd563, 0x223547 },
	{ 0xd564, 0x223548 },
	{ 0xd565, 0x223549 },
	{ 0xd566, 0x22354a },
	{ 0xd567, 0x22354b },
	{ 0xd568, 0x22354c },
	{ 0xd569, 0x22354d },
	{ 0xd56a, 0x22354e },
	{ 0xd56b, 0x22354f },
	{ 0xd56c, 0x223550 },
	{ 0xd56d, 0x223551 },
	{ 0xd56e, 0x223552 },
	{ 0xd56f, 0x223553 },
	{ 0xd570, 0x223554 },
	{ 0xd571, 0x223555 },
	{ 0xd572, 0x223556 },
	{ 0xd573, 0x223557 },
	{ 0xd574, 0x223558 },
	{ 0xd575, 0x223559 },
	{ 0xd576, 0x22355a },
	{ 0xd577, 0x22355b },
	{ 0xd578, 0x22355c },
	{ 0xd579, 0x22355d },
	{ 0xd57a, 0x22355e },
	{ 0xd57b, 0x22355f },
	{ 0xd57c, 0x223560 },
	{ 0xd57d, 0x223561 },
	{ 0xd57e, 0x223562 },
	{ 0xd5a1, 0x223563 },
	{ 0xd5a2, 0x223564 },
	{ 0xd5a3, 0x223565 },
	{ 0xd5a4, 0x223566 },
	{ 0xd5a5, 0x223567 },
	{ 0xd5a6, 0x223568 },
	{ 0xd5a7, 0x223569 },
	{ 0xd5a8, 0x22356a },
	{ 0xd5a9, 0x22356b },
	{ 0xd5aa, 0x22356c },
	{ 0xd5ab, 0x22356d },
	{ 0xd5ac, 0x22356e },
	{ 0xd5ad, 0x22356f },
	{ 0xd5ae, 0x223570 },
	{ 0xd5af, 0x223571 },
	{ 0xd5b0, 0x223572 },
	{ 0xd5b1, 0x223573 },
	{ 0xd5b2, 0x223574 },
	{ 0xd5b3, 0x223575 },
	{ 0xd5b4, 0x223576 },
	{ 0xd5b5, 0x223577 },
	{ 0xd5b6, 0x223578 },
	{ 0xd5b7, 0x223579 },
	{ 0xd5b8, 0x22357a },
	{ 0xd5b9, 0x22357b },
	{ 0xd5ba, 0x22357c },
	{ 0xd5bb, 0x22357d },
	{ 0xd5bc, 0x22357e },
	{ 0xd5bd, 0x223621 },
	{ 0xd5be, 0x223622 },
	{ 0xd5bf, 0x223623 },
	{ 0xd5c0, 0x223624 },
	{ 0xd5c1, 0x223625 },
	{ 0xd5c2, 0x223626 },
	{ 0xd5c3, 0x223627 },
	{ 0xd5c4, 0x223628 },
	{ 0xd5c5, 0x223629 },
	{ 0xd5c6, 0x22362a },
	{ 0xd5c7, 0x22362b },
	{ 0xd5c8, 0x22362c },
	{ 0xd5c9, 0x22362d },
	{ 0xd5ca, 0x22362e },
	{ 0xd5cb, 0x22362f },
	{ 0xd5cc, 0x223630 },
	{ 0xd5cd, 0x223631 },
	{ 0xd5ce, 0x223632 },
	{ 0xd5cf, 0x223633 },
	{ 0xd5d0, 0x223634 },
	{ 0xd5d1, 0x223635 },
	{ 0xd5d2, 0x223636 },
	{ 0xd5d3, 0x223637 },
	{ 0xd5d4, 0x223638 },
	{ 0xd5d5, 0x223639 },
	{ 0xd5d6, 0x22363a },
	{ 0xd5d7, 0x22363b },
	{ 0xd5d8, 0x22363c },
	{ 0xd5d9, 0x22363d },
	{ 0xd5da, 0x22363e },
	{ 0xd5db, 0x22363f },
	{ 0xd5dc, 0x223640 },
	{ 0xd5dd, 0x223641 },
	{ 0xd5de, 0x223642 },
	{ 0xd5df, 0x223643 },
	{ 0xd5e0, 0x223644 },
	{ 0xd5e1, 0x223645 },
	{ 0xd5e2, 0x223646 },
	{ 0xd5e3, 0x223647 },
	{ 0xd5e4, 0x223648 },
	{ 0xd5e5, 0x223649 },
	{ 0xd5e6, 0x22364a },
	{ 0xd5e7, 0x22364b },
	{ 0xd5e8, 0x22364c },
	{ 0xd5e9, 0x22364d },
	{ 0xd5ea, 0x22364e },
	{ 0xd5eb, 0x22364f },
	{ 0xd5ec, 0x223650 },
	{ 0xd5ed, 0x223651 },
	{ 0xd5ee, 0x223652 },
	{ 0xd5ef, 0x223653 },
	{ 0xd5f0, 0x223654 },
	{ 0xd5f1, 0x223655 },
	{ 0xd5f2, 0x223656 },
	{ 0xd5f3, 0x223657 },
	{ 0xd5f4, 0x223658 },
	{ 0xd5f5, 0x223659 },
	{ 0xd5f6, 0x22365a },
	{ 0xd5f7, 0x22365b },
	{ 0xd5f8, 0x22365c },
	{ 0xd5f9, 0x22365d },
	{ 0xd5fa, 0x22365e },
	{ 0xd5fb, 0x22365f },
	{ 0xd5fc, 0x223660 },
	{ 0xd5fd, 0x223661 },
	{ 0xd5fe, 0x223662 },
	{ 0xd640, 0x223663 },
	{ 0xd641, 0x223664 },
	{ 0xd642, 0x223665 },
	{ 0xd643, 0x223666 },
	{ 0xd644, 0x223667 },
	{ 0xd645, 0x223668 },
	{ 0xd646, 0x223669 },
	{ 0xd647, 0x22366a },
	{ 0xd648, 0x22366b },
	{ 0xd649, 0x22366c },
	{ 0xd64a, 0x22366d },
	{ 0xd64b, 0x22366e },
	{ 0xd64c, 0x22366f },
	{ 0xd64d, 0x223670 },
	{ 0xd64e, 0x223671 },
	{ 0xd64f, 0x223672 },
	{ 0xd650, 0x223673 },
	{ 0xd651, 0x223674 },
	{ 0xd652, 0x223675 },
	{ 0xd653, 0x223676 },
	{ 0xd654, 0x223677 },
	{ 0xd655, 0x223678 },
	{ 0xd656, 0x223679 },
	{ 0xd657, 0x22367a },
	{ 0xd658, 0x22367b },
	{ 0xd659, 0x22367c },
	{ 0xd65a, 0x22367d },
	{ 0xd65b, 0x22367e },
	{ 0xd65c, 0x223721 },
	{ 0xd65d, 0x223722 },
	{ 0xd65e, 0x223723 },
	{ 0xd65f, 0x223724 },
	{ 0xd660, 0x223725 },
	{ 0xd661, 0x223726 },
	{ 0xd662, 0x223727 },
	{ 0xd663, 0x223728 },
	{ 0xd664, 0x223729 },
	{ 0xd665, 0x22372a },
	{ 0xd666, 0x22372b },
	{ 0xd667, 0x22372c },
	{ 0xd668, 0x22372d },
	{ 0xd669, 0x22372e },
	{ 0xd66a, 0x22372f },
	{ 0xd66b, 0x223730 },
	{ 0xd66c, 0x223731 },
	{ 0xd66d, 0x223732 },
	{ 0xd66e, 0x223733 },
	{ 0xd66f, 0x223734 },
	{ 0xd670, 0x223735 },
	{ 0xd671, 0x223736 },
	{ 0xd672, 0x223737 },
	{ 0xd673, 0x223738 },
	{ 0xd674, 0x223739 },
	{ 0xd675, 0x22373a },
	{ 0xd676, 0x22373b },
	{ 0xd677, 0x22373c },
	{ 0xd678, 0x22373d },
	{ 0xd679, 0x22373e },
	{ 0xd67a, 0x22373f },
	{ 0xd67b, 0x223740 },
	{ 0xd67c, 0x223741 },
	{ 0xd67d, 0x223742 },
	{ 0xd67e, 0x223743 },
	{ 0xd6a1, 0x223744 },
	{ 0xd6a2, 0x223745 },
	{ 0xd6a3, 0x223746 },
	{ 0xd6a4, 0x223747 },
	{ 0xd6a5, 0x223748 },
	{ 0xd6a6, 0x223749 },
	{ 0xd6a7, 0x22374a },
	{ 0xd6a8, 0x22374b },
	{ 0xd6a9, 0x22374c },
	{ 0xd6aa, 0x22374d },
	{ 0xd6ab, 0x22374e },
	{ 0xd6ac, 0x22374f },
	{ 0xd6ad, 0x223750 },
	{ 0xd6ae, 0x223751 },
	{ 0xd6af, 0x223752 },
	{ 0xd6b0, 0x223753 },
	{ 0xd6b1, 0x223754 },
	{ 0xd6b2, 0x223755 },
	{ 0xd6b3, 0x223756 },
	{ 0xd6b4, 0x223757 },
	{ 0xd6b5, 0x223758 },
	{ 0xd6b6, 0x223759 },
	{ 0xd6b7, 0x22375a },
	{ 0xd6b8, 0x22375b },
	{ 0xd6b9, 0x22375c },
	{ 0xd6ba, 0x22375d },
	{ 0xd6bb, 0x22375e },
	{ 0xd6bc, 0x22375f },
	{ 0xd6bd, 0x223760 },
	{ 0xd6be, 0x223761 },
	{ 0xd6bf, 0x223762 },
	{ 0xd6c0, 0x223763 },
	{ 0xd6c1, 0x223764 },
	{ 0xd6c2, 0x223765 },
	{ 0xd6c3, 0x223766 },
	{ 0xd6c4, 0x223767 },
	{ 0xd6c5, 0x223768 },
	{ 0xd6c6, 0x223769 },
	{ 0xd6c7, 0x22376a },
	{ 0xd6c8, 0x22376b },
	{ 0xd6c9, 0x22376c },
	{ 0xd6ca, 0x22376d },
	{ 0xd6cb, 0x22376e },
	{ 0xd6cc, 0x223e63 },
	{ 0xd6cd, 0x223770 },
	{ 0xd6ce, 0x223771 },
	{ 0xd6cf, 0x223772 },
	{ 0xd6d0, 0x223773 },
	{ 0xd6d1, 0x223774 },
	{ 0xd6d2, 0x223775 },
	{ 0xd6d3, 0x223776 },
	{ 0xd6d4, 0x223777 },
	{ 0xd6d5, 0x223778 },
	{ 0xd6d6, 0x223779 },
	{ 0xd6d7, 0x22377a },
	{ 0xd6d8, 0x22377b },
	{ 0xd6d9, 0x22377c },
	{ 0xd6da, 0x22377d },
	{ 0xd6db, 0x22377e },
	{ 0xd6dc, 0x223821 },
	{ 0xd6dd, 0x223822 },
	{ 0xd6de, 0x223823 },
	{ 0xd6df, 0x223824 },
	{ 0xd6e0, 0x223825 },
	{ 0xd6e1, 0x223826 },
	{ 0xd6e2, 0x223827 },
	{ 0xd6e3, 0x223828 },
	{ 0xd6e4, 0x223829 },
	{ 0xd6e5, 0x22382a },
	{ 0xd6e6, 0x22382b },
	{ 0xd6e7, 0x22382c },
	{ 0xd6e8, 0x22382d },
	{ 0xd6e9, 0x22382e },
	{ 0xd6ea, 0x22382f },
	{ 0xd6eb, 0x223830 },
	{ 0xd6ec, 0x223831 },
	{ 0xd6ed, 0x223832 },
	{ 0xd6ee, 0x223833 },
	{ 0xd6ef, 0x223834 },
	{ 0xd6f0, 0x223835 },
	{ 0xd6f1, 0x223836 },
	{ 0xd6f2, 0x223837 },
	{ 0xd6f3, 0x223838 },
	{ 0xd6f4, 0x223839 },
	{ 0xd6f5, 0x22383a },
	{ 0xd6f6, 0x22383b },
	{ 0xd6f7, 0x22383c },
	{ 0xd6f8, 0x22383d },
	{ 0xd6f9, 0x22383e },
	{ 0xd6fa, 0x22383f },
	{ 0xd6fb, 0x223840 },
	{ 0xd6fc, 0x223841 },
	{ 0xd6fd, 0x223842 },
	{ 0xd6fe, 0x223843 },
	{ 0xd740, 0x223844 },
	{ 0xd741, 0x223845 },
	{ 0xd742, 0x223846 },
	{ 0xd743, 0x223847 },
	{ 0xd744, 0x223848 },
	{ 0xd745, 0x223849 },
	{ 0xd746, 0x22384a },
	{ 0xd747, 0x22384b },
	{ 0xd748, 0x22384c },
	{ 0xd749, 0x22384d },
	{ 0xd74a, 0x22384e },
	{ 0xd74b, 0x22384f },
	{ 0xd74c, 0x223850 },
	{ 0xd74d, 0x223851 },
	{ 0xd74e, 0x223852 },
	{ 0xd74f, 0x223853 },
	{ 0xd750, 0x223854 },
	{ 0xd751, 0x223855 },
	{ 0xd752, 0x223856 },
	{ 0xd753, 0x223857 },
	{ 0xd754, 0x223858 },
	{ 0xd755, 0x223859 },
	{ 0xd756, 0x22385a },
	{ 0xd757, 0x22385b },
	{ 0xd758, 0x22385c },
	{ 0xd759, 0x22385d },
	{ 0xd75a, 0x22385e },
	{ 0xd75b, 0x22385f },
	{ 0xd75c, 0x223860 },
	{ 0xd75d, 0x223861 },
	{ 0xd75e, 0x223862 },
	{ 0xd75f, 0x223863 },
	{ 0xd760, 0x223864 },
	{ 0xd761, 0x223865 },
	{ 0xd762, 0x223866 },
	{ 0xd763, 0x223867 },
	{ 0xd764, 0x223868 },
	{ 0xd765, 0x223869 },
	{ 0xd766, 0x22386a },
	{ 0xd767, 0x22386b },
	{ 0xd768, 0x22386c },
	{ 0xd769, 0x22386d },
	{ 0xd76a, 0x22386e },
	{ 0xd76b, 0x22386f },
	{ 0xd76c, 0x223870 },
	{ 0xd76d, 0x223871 },
	{ 0xd76e, 0x223872 },
	{ 0xd76f, 0x223873 },
	{ 0xd770, 0x223874 },
	{ 0xd771, 0x223875 },
	{ 0xd772, 0x223876 },
	{ 0xd773, 0x223877 },
	{ 0xd774, 0x223878 },
	{ 0xd775, 0x223879 },
	{ 0xd776, 0x22387a },
	{ 0xd777, 0x22387b },
	{ 0xd778, 0x22387c },
	{ 0xd779, 0x22387d },
	{ 0xd77a, 0x223f6a },
	{ 0xd77b, 0x22387e },
	{ 0xd77c, 0x223921 },
	{ 0xd77d, 0x223922 },
	{ 0xd77e, 0x223923 },
	{ 0xd7a1, 0x223924 },
	{ 0xd7a2, 0x223925 },
	{ 0xd7a3, 0x223926 },
	{ 0xd7a4, 0x223927 },
	{ 0xd7a5, 0x223928 },
	{ 0xd7a6, 0x223929 },
	{ 0xd7a7, 0x22392a },
	{ 0xd7a8, 0x22392b },
	{ 0xd7a9, 0x22392c },
	{ 0xd7aa, 0x22392d },
	{ 0xd7ab, 0x22392e },
	{ 0xd7ac, 0x22392f },
	{ 0xd7ad, 0x223930 },
	{ 0xd7ae, 0x223931 },
	{ 0xd7af, 0x223932 },
	{ 0xd7b0, 0x223933 },
	{ 0xd7b1, 0x223934 },
	{ 0xd7b2, 0x223935 },
	{ 0xd7b3, 0x223936 },
	{ 0xd7b4, 0x223937 },
	{ 0xd7b5, 0x223938 },
	{ 0xd7b6, 0x223939 },
	{ 0xd7b7, 0x22393a },
	{ 0xd7b8, 0x22393b },
	{ 0xd7b9, 0x22393c },
	{ 0xd7ba, 0x22393d },
	{ 0xd7bb, 0x22393e },
	{ 0xd7bc, 0x22393f },
	{ 0xd7bd, 0x223940 },
	{ 0xd7be, 0x223941 },
	{ 0xd7bf, 0x223942 },
	{ 0xd7c0, 0x223943 },
	{ 0xd7c1, 0x223944 },
	{ 0xd7c2, 0x223945 },
	{ 0xd7c3, 0x223946 },
	{ 0xd7c4, 0x223947 },
	{ 0xd7c5, 0x223948 },
	{ 0xd7c6, 0x223949 },
	{ 0xd7c7, 0x22394a },
	{ 0xd7c8, 0x22394b },
	{ 0xd7c9, 0x22394c },
	{ 0xd7ca, 0x22394d },
	{ 0xd7cb, 0x22394e },
	{ 0xd7cc, 0x22394f },
	{ 0xd7cd, 0x223950 },
	{ 0xd7ce, 0x223951 },
	{ 0xd7cf, 0x223952 },
	{ 0xd7d0, 0x223953 },
	{ 0xd7d1, 0x223954 },
	{ 0xd7d2, 0x223955 },
	{ 0xd7d3, 0x223956 },
	{ 0xd7d4, 0x223957 },
	{ 0xd7d5, 0x223958 },
	{ 0xd7d6, 0x223959 },
	{ 0xd7d7, 0x22395a },
	{ 0xd7d8, 0x22395b },
	{ 0xd7d9, 0x22395c },
	{ 0xd7da, 0x22395d },
	{ 0xd7db, 0x22395e },
	{ 0xd7dc, 0x22395f },
	{ 0xd7dd, 0x223960 },
	{ 0xd7de, 0x223961 },
	{ 0xd7df, 0x223962 },
	{ 0xd7e0, 0x223963 },
	{ 0xd7e1, 0x223964 },
	{ 0xd7e2, 0x223965 },
	{ 0xd7e3, 0x223966 },
	{ 0xd7e4, 0x223967 },
	{ 0xd7e5, 0x223968 },
	{ 0xd7e6, 0x223969 },
	{ 0xd7e7, 0x22396a },
	{ 0xd7e8, 0x22396b },
	{ 0xd7e9, 0x22396c },
	{ 0xd7ea, 0x22396d },
	{ 0xd7eb, 0x22396e },
	{ 0xd7ec, 0x22396f },
	{ 0xd7ed, 0x223970 },
	{ 0xd7ee, 0x223971 },
	{ 0xd7ef, 0x223972 },
	{ 0xd7f0, 0x223973 },
	{ 0xd7f1, 0x223974 },
	{ 0xd7f2, 0x223975 },
	{ 0xd7f3, 0x223976 },
	{ 0xd7f4, 0x223977 },
	{ 0xd7f5, 0x223978 },
	{ 0xd7f6, 0x223979 },
	{ 0xd7f7, 0x22397a },
	{ 0xd7f8, 0x22397b },
	{ 0xd7f9, 0x22397c },
	{ 0xd7fa, 0x22397d },
	{ 0xd7fb, 0x22397e },
	{ 0xd7fc, 0x223a21 },
	{ 0xd7fd, 0x223a22 },
	{ 0xd7fe, 0x223a23 },
	{ 0xd840, 0x223a24 },
	{ 0xd841, 0x223a25 },
	{ 0xd842, 0x223a26 },
	{ 0xd843, 0x223a27 },
	{ 0xd844, 0x223a28 },
	{ 0xd845, 0x223a29 },
	{ 0xd846, 0x223a2a },
	{ 0xd847, 0x223a2b },
	{ 0xd848, 0x223a2c },
	{ 0xd849, 0x223a2d },
	{ 0xd84a, 0x223a2e },
	{ 0xd84b, 0x223a2f },
	{ 0xd84c, 0x223a30 },
	{ 0xd84d, 0x223a31 },
	{ 0xd84e, 0x223a32 },
	{ 0xd84f, 0x223a33 },
	{ 0xd850, 0x223a34 },
	{ 0xd851, 0x223a35 },
	{ 0xd852, 0x223a36 },
	{ 0xd853, 0x223a37 },
	{ 0xd854, 0x223a38 },
	{ 0xd855, 0x223a39 },
	{ 0xd856, 0x223a3a },
	{ 0xd857, 0x223a3b },
	{ 0xd858, 0x223a3c },
	{ 0xd859, 0x223a3d },
	{ 0xd85a, 0x223a3e },
	{ 0xd85b, 0x223a3f },
	{ 0xd85c, 0x223a40 },
	{ 0xd85d, 0x223a41 },
	{ 0xd85e, 0x223a42 },
	{ 0xd85f, 0x223a43 },
	{ 0xd860, 0x223a44 },
	{ 0xd861, 0x223a45 },
	{ 0xd862, 0x223a46 },
	{ 0xd863, 0x223a47 },
	{ 0xd864, 0x223a48 },
	{ 0xd865, 0x223a49 },
	{ 0xd866, 0x223a4a },
	{ 0xd867, 0x223a4b },
	{ 0xd868, 0x223a4c },
	{ 0xd869, 0x223a4d },
	{ 0xd86a, 0x223a4e },
	{ 0xd86b, 0x223a4f },
	{ 0xd86c, 0x223a50 },
	{ 0xd86d, 0x223a51 },
	{ 0xd86e, 0x223a52 },
	{ 0xd86f, 0x223a53 },
	{ 0xd870, 0x223a54 },
	{ 0xd871, 0x223a55 },
	{ 0xd872, 0x223a56 },
	{ 0xd873, 0x223a57 },
	{ 0xd874, 0x223a58 },
	{ 0xd875, 0x223a59 },
	{ 0xd876, 0x223a5a },
	{ 0xd877, 0x223a5b },
	{ 0xd878, 0x223a5c },
	{ 0xd879, 0x223a5d },
	{ 0xd87a, 0x223a5e },
	{ 0xd87b, 0x223a5f },
	{ 0xd87c, 0x223a60 },
	{ 0xd87d, 0x223a61 },
	{ 0xd87e, 0x223a62 },
	{ 0xd8a1, 0x223a63 },
	{ 0xd8a2, 0x223a64 },
	{ 0xd8a3, 0x223a65 },
	{ 0xd8a4, 0x223a66 },
	{ 0xd8a5, 0x223a67 },
	{ 0xd8a6, 0x223a68 },
	{ 0xd8a7, 0x223a69 },
	{ 0xd8a8, 0x223a6a },
	{ 0xd8a9, 0x223a6b },
	{ 0xd8aa, 0x223a6c },
	{ 0xd8ab, 0x223a6d },
	{ 0xd8ac, 0x223a6e },
	{ 0xd8ad, 0x223a6f },
	{ 0xd8ae, 0x223a70 },
	{ 0xd8af, 0x223a71 },
	{ 0xd8b0, 0x223a72 },
	{ 0xd8b1, 0x223a73 },
	{ 0xd8b2, 0x223a74 },
	{ 0xd8b3, 0x223a75 },
	{ 0xd8b4, 0x223a76 },
	{ 0xd8b5, 0x223a77 },
	{ 0xd8b6, 0x223a78 },
	{ 0xd8b7, 0x223a79 },
	{ 0xd8b8, 0x223a7a },
	{ 0xd8b9, 0x223a7b },
	{ 0xd8ba, 0x223a7c },
	{ 0xd8bb, 0x223a7d },
	{ 0xd8bc, 0x223a7e },
	{ 0xd8bd, 0x223b21 },
	{ 0xd8be, 0x223b22 },
	{ 0xd8bf, 0x223b23 },
	{ 0xd8c0, 0x223b24 },
	{ 0xd8c1, 0x223b25 },
	{ 0xd8c2, 0x223b26 },
	{ 0xd8c3, 0x223b27 },
	{ 0xd8c4, 0x223b28 },
	{ 0xd8c5, 0x223b29 },
	{ 0xd8c6, 0x223b2a },
	{ 0xd8c7, 0x223b2b },
	{ 0xd8c8, 0x223b2c },
	{ 0xd8c9, 0x223b2d },
	{ 0xd8ca, 0x223b2e },
	{ 0xd8cb, 0x223b2f },
	{ 0xd8cc, 0x223b30 },
	{ 0xd8cd, 0x223b31 },
	{ 0xd8ce, 0x223b32 },
	{ 0xd8cf, 0x223b33 },
	{ 0xd8d0, 0x223b34 },
	{ 0xd8d1, 0x223b35 },
	{ 0xd8d2, 0x223b36 },
	{ 0xd8d3, 0x223b37 },
	{ 0xd8d4, 0x223b38 },
	{ 0xd8d5, 0x223b39 },
	{ 0xd8d6, 0x223b3a },
	{ 0xd8d7, 0x223b3b },
	{ 0xd8d8, 0x223b3c },
	{ 0xd8d9, 0x223b3d },
	{ 0xd8da, 0x223b3e },
	{ 0xd8db, 0x223b3f },
	{ 0xd8dc, 0x223b40 },
	{ 0xd8dd, 0x223b41 },
	{ 0xd8de, 0x223b42 },
	{ 0xd8df, 0x223b43 },
	{ 0xd8e0, 0x223b44 },
	{ 0xd8e1, 0x223b45 },
	{ 0xd8e2, 0x223b46 },
	{ 0xd8e3, 0x223b47 },
	{ 0xd8e4, 0x223b48 },
	{ 0xd8e5, 0x223b49 },
	{ 0xd8e6, 0x223b4a },
	{ 0xd8e7, 0x223b4b },
	{ 0xd8e8, 0x223b4c },
	{ 0xd8e9, 0x223b4d },
	{ 0xd8ea, 0x223b4e },
	{ 0xd8eb, 0x223b4f },
	{ 0xd8ec, 0x223b50 },
	{ 0xd8ed, 0x223b51 },
	{ 0xd8ee, 0x223b52 },
	{ 0xd8ef, 0x223b53 },
	{ 0xd8f0, 0x223b54 },
	{ 0xd8f1, 0x223b55 },
	{ 0xd8f2, 0x223b56 },
	{ 0xd8f3, 0x223b57 },
	{ 0xd8f4, 0x223b58 },
	{ 0xd8f5, 0x223b59 },
	{ 0xd8f6, 0x223b5a },
	{ 0xd8f7, 0x223b5b },
	{ 0xd8f8, 0x223b5c },
	{ 0xd8f9, 0x223b5d },
	{ 0xd8fa, 0x223b5e },
	{ 0xd8fb, 0x223b5f },
	{ 0xd8fc, 0x223b60 },
	{ 0xd8fd, 0x223b61 },
	{ 0xd8fe, 0x223b62 },
	{ 0xd940, 0x223b63 },
	{ 0xd941, 0x223b64 },
	{ 0xd942, 0x223b65 },
	{ 0xd943, 0x223b66 },
	{ 0xd944, 0x223b67 },
	{ 0xd945, 0x223b68 },
	{ 0xd946, 0x223b69 },
	{ 0xd947, 0x223b6a },
	{ 0xd948, 0x223b6b },
	{ 0xd949, 0x223b6c },
	{ 0xd94a, 0x223b6d },
	{ 0xd94b, 0x223b6e },
	{ 0xd94c, 0x223b6f },
	{ 0xd94d, 0x223b70 },
	{ 0xd94e, 0x223b71 },
	{ 0xd94f, 0x223b72 },
	{ 0xd950, 0x223b73 },
	{ 0xd951, 0x223b74 },
	{ 0xd952, 0x223b75 },
	{ 0xd953, 0x223b76 },
	{ 0xd954, 0x223b77 },
	{ 0xd955, 0x223b78 },
	{ 0xd956, 0x223b79 },
	{ 0xd957, 0x223b7a },
	{ 0xd958, 0x223b7b },
	{ 0xd959, 0x223b7c },
	{ 0xd95a, 0x223b7d },
	{ 0xd95b, 0x223b7e },
	{ 0xd95c, 0x223c21 },
	{ 0xd95d, 0x223c22 },
	{ 0xd95e, 0x223c23 },
	{ 0xd95f, 0x223c24 },
	{ 0xd960, 0x223c25 },
	{ 0xd961, 0x223c26 },
	{ 0xd962, 0x223c27 },
	{ 0xd963, 0x223c28 },
	{ 0xd964, 0x223c29 },
	{ 0xd965, 0x223c2a },
	{ 0xd966, 0x223c2b },
	{ 0xd967, 0x223c2c },
	{ 0xd968, 0x223c2d },
	{ 0xd969, 0x223c2e },
	{ 0xd96a, 0x223c2f },
	{ 0xd96b, 0x223c30 },
	{ 0xd96c, 0x223c31 },
	{ 0xd96d, 0x223c32 },
	{ 0xd96e, 0x223c33 },
	{ 0xd96f, 0x223c34 },
	{ 0xd970, 0x223c35 },
	{ 0xd971, 0x223c36 },
	{ 0xd972, 0x223c37 },
	{ 0xd973, 0x223c38 },
	{ 0xd974, 0x223c39 },
	{ 0xd975, 0x223c3a },
	{ 0xd976, 0x223c3b },
	{ 0xd977, 0x223c3c },
	{ 0xd978, 0x223c3d },
	{ 0xd979, 0x223c3e },
	{ 0xd97a, 0x223c3f },
	{ 0xd97b, 0x223c40 },
	{ 0xd97c, 0x223c41 },
	{ 0xd97d, 0x223c42 },
	{ 0xd97e, 0x223c43 },
	{ 0xd9a1, 0x223c44 },
	{ 0xd9a2, 0x223c45 },
	{ 0xd9a3, 0x223c46 },
	{ 0xd9a4, 0x223c47 },
	{ 0xd9a5, 0x223c48 },
	{ 0xd9a6, 0x223c49 },
	{ 0xd9a7, 0x223c4a },
	{ 0xd9a8, 0x223c4b },
	{ 0xd9a9, 0x223c4c },
	{ 0xd9aa, 0x223c4d },
	{ 0xd9ab, 0x223c4e },
	{ 0xd9ac, 0x223c4f },
	{ 0xd9ad, 0x223c50 },
	{ 0xd9ae, 0x223c51 },
	{ 0xd9af, 0x223c52 },
	{ 0xd9b0, 0x223c53 },
	{ 0xd9b1, 0x223c54 },
	{ 0xd9b2, 0x223c55 },
	{ 0xd9b3, 0x223c56 },
	{ 0xd9b4, 0x223c57 },
	{ 0xd9b5, 0x223c58 },
	{ 0xd9b6, 0x223c59 },
	{ 0xd9b7, 0x223c5a },
	{ 0xd9b8, 0x223c5b },
	{ 0xd9b9, 0x223c5c },
	{ 0xd9ba, 0x223c5d },
	{ 0xd9bb, 0x223c5e },
	{ 0xd9bc, 0x223c5f },
	{ 0xd9bd, 0x223c60 },
	{ 0xd9be, 0x223c61 },
	{ 0xd9bf, 0x223c62 },
	{ 0xd9c0, 0x223c63 },
	{ 0xd9c1, 0x223c64 },
	{ 0xd9c2, 0x223c65 },
	{ 0xd9c3, 0x223c66 },
	{ 0xd9c4, 0x223c67 },
	{ 0xd9c5, 0x223c68 },
	{ 0xd9c6, 0x223c69 },
	{ 0xd9c7, 0x223c6a },
	{ 0xd9c8, 0x223c6b },
	{ 0xd9c9, 0x223c6c },
	{ 0xd9ca, 0x223c6d },
	{ 0xd9cb, 0x223c6e },
	{ 0xd9cc, 0x223c6f },
	{ 0xd9cd, 0x223c70 },
	{ 0xd9ce, 0x223c71 },
	{ 0xd9cf, 0x223c72 },
	{ 0xd9d0, 0x223c73 },
	{ 0xd9d1, 0x223c74 },
	{ 0xd9d2, 0x223c75 },
	{ 0xd9d3, 0x223c76 },
	{ 0xd9d4, 0x223c77 },
	{ 0xd9d5, 0x223c78 },
	{ 0xd9d6, 0x223c79 },
	{ 0xd9d7, 0x223c7a },
	{ 0xd9d8, 0x223c7b },
	{ 0xd9d9, 0x223c7c },
	{ 0xd9da, 0x223c7d },
	{ 0xd9db, 0x223c7e },
	{ 0xd9dc, 0x223d21 },
	{ 0xd9dd, 0x223d22 },
	{ 0xd9de, 0x223d23 },
	{ 0xd9df, 0x223d24 },
	{ 0xd9e0, 0x223d25 },
	{ 0xd9e1, 0x223d26 },
	{ 0xd9e2, 0x223d27 },
	{ 0xd9e3, 0x223d28 },
	{ 0xd9e4, 0x223d29 },
	{ 0xd9e5, 0x223d2a },
	{ 0xd9e6, 0x223d2b },
	{ 0xd9e7, 0x223d2c },
	{ 0xd9e8, 0x223d2d },
	{ 0xd9e9, 0x223d2e },
	{ 0xd9ea, 0x223d2f },
	{ 0xd9eb, 0x223d30 },
	{ 0xd9ec, 0x223d31 },
	{ 0xd9ed, 0x223d32 },
	{ 0xd9ee, 0x223d33 },
	{ 0xd9ef, 0x223d34 },
	{ 0xd9f0, 0x223d35 },
	{ 0xd9f1, 0x223d36 },
	{ 0xd9f2, 0x223d37 },
	{ 0xd9f3, 0x223d38 },
	{ 0xd9f4, 0x223d39 },
	{ 0xd9f5, 0x223d3a },
	{ 0xd9f6, 0x223d3b },
	{ 0xd9f7, 0x223d3c },
	{ 0xd9f8, 0x223d3d },
	{ 0xd9f9, 0x223d3e },
	{ 0xd9fa, 0x223d3f },
	{ 0xd9fb, 0x223d40 },
	{ 0xd9fc, 0x223d41 },
	{ 0xd9fd, 0x223d42 },
	{ 0xd9fe, 0x223d43 },
	{ 0xda40, 0x223d44 },
	{ 0xda41, 0x223d45 },
	{ 0xda42, 0x223d46 },
	{ 0xda43, 0x223d47 },
	{ 0xda44, 0x223d48 },
	{ 0xda45, 0x223d49 },
	{ 0xda46, 0x223d4a },
	{ 0xda47, 0x223d4b },
	{ 0xda48, 0x223d4c },
	{ 0xda49, 0x223d4d },
	{ 0xda4a, 0x223d4e },
	{ 0xda4b, 0x223d4f },
	{ 0xda4c, 0x223d50 },
	{ 0xda4d, 0x223d51 },
	{ 0xda4e, 0x223d52 },
	{ 0xda4f, 0x223d53 },
	{ 0xda50, 0x223d54 },
	{ 0xda51, 0x223d55 },
	{ 0xda52, 0x223d56 },
	{ 0xda53, 0x223d57 },
	{ 0xda54, 0x223d58 },
	{ 0xda55, 0x223d59 },
	{ 0xda56, 0x223d5a },
	{ 0xda57, 0x223d5b },
	{ 0xda58, 0x223d5c },
	{ 0xda59, 0x223d5d },
	{ 0xda5a, 0x223d5e },
	{ 0xda5b, 0x223d5f },
	{ 0xda5c, 0x223d60 },
	{ 0xda5d, 0x223d61 },
	{ 0xda5e, 0x223d62 },
	{ 0xda5f, 0x223d63 },
	{ 0xda60, 0x223d64 },
	{ 0xda61, 0x223d65 },
	{ 0xda62, 0x223d66 },
	{ 0xda63, 0x223d67 },
	{ 0xda64, 0x223d68 },
	{ 0xda65, 0x223d69 },
	{ 0xda66, 0x223d6a },
	{ 0xda67, 0x223d6b },
	{ 0xda68, 0x223d6c },
	{ 0xda69, 0x223d6d },
	{ 0xda6a, 0x223d6e },
	{ 0xda6b, 0x223d6f },
	{ 0xda6c, 0x223d70 },
	{ 0xda6d, 0x223d71 },
	{ 0xda6e, 0x223d72 },
	{ 0xda6f, 0x223d73 },
	{ 0xda70, 0x223d74 },
	{ 0xda71, 0x223d75 },
	{ 0xda72, 0x223d76 },
	{ 0xda73, 0x223d77 },
	{ 0xda74, 0x223d78 },
	{ 0xda75, 0x223d79 },
	{ 0xda76, 0x223d7a },
	{ 0xda77, 0x223d7b },
	{ 0xda78, 0x223d7c },
	{ 0xda79, 0x223d7d },
	{ 0xda7a, 0x223d7e },
	{ 0xda7b, 0x223e21 },
	{ 0xda7c, 0x223e22 },
	{ 0xda7d, 0x223e23 },
	{ 0xda7e, 0x223e24 },
	{ 0xdaa1, 0x223e25 },
	{ 0xdaa2, 0x223e26 },
	{ 0xdaa3, 0x223e27 },
	{ 0xdaa4, 0x223e28 },
	{ 0xdaa5, 0x223e29 },
	{ 0xdaa6, 0x223e2a },
	{ 0xdaa7, 0x223e2b },
	{ 0xdaa8, 0x223e2c },
	{ 0xdaa9, 0x223e2d },
	{ 0xdaaa, 0x223e2e },
	{ 0xdaab, 0x223e2f },
	{ 0xdaac, 0x223e30 },
	{ 0xdaad, 0x223e31 },
	{ 0xdaae, 0x223e32 },
	{ 0xdaaf, 0x223e33 },
	{ 0xdab0, 0x223e34 },
	{ 0xdab1, 0x223e35 },
	{ 0xdab2, 0x223e36 },
	{ 0xdab3, 0x223e37 },
	{ 0xdab4, 0x223e38 },
	{ 0xdab5, 0x223e39 },
	{ 0xdab6, 0x223e3a },
	{ 0xdab7, 0x223e3b },
	{ 0xdab8, 0x223e3c },
	{ 0xdab9, 0x223e3d },
	{ 0xdaba, 0x223e3e },
	{ 0xdabb, 0x223e3f },
	{ 0xdabc, 0x223e40 },
	{ 0xdabd, 0x223e41 },
	{ 0xdabe, 0x223e42 },
	{ 0xdabf, 0x223e43 },
	{ 0xdac0, 0x223e44 },
	{ 0xdac1, 0x223e45 },
	{ 0xdac2, 0x223e46 },
	{ 0xdac3, 0x223e47 },
	{ 0xdac4, 0x223e48 },
	{ 0xdac5, 0x223e49 },
	{ 0xdac6, 0x223e4a },
	{ 0xdac7, 0x223e4b },
	{ 0xdac8, 0x223e4c },
	{ 0xdac9, 0x223e4d },
	{ 0xdaca, 0x223e4e },
	{ 0xdacb, 0x223e4f },
	{ 0xdacc, 0x223e50 },
	{ 0xdacd, 0x223e51 },
	{ 0xdace, 0x223e52 },
	{ 0xdacf, 0x223e53 },
	{ 0xdad0, 0x223e54 },
	{ 0xdad1, 0x223e55 },
	{ 0xdad2, 0x223e56 },
	{ 0xdad3, 0x223e57 },
	{ 0xdad4, 0x223e58 },
	{ 0xdad5, 0x223e59 },
	{ 0xdad6, 0x223e5a },
	{ 0xdad7, 0x223e5b },
	{ 0xdad8, 0x223e5c },
	{ 0xdad9, 0x223e5d },
	{ 0xdada, 0x223e5e },
	{ 0xdadb, 0x223e5f },
	{ 0xdadc, 0x223e60 },
	{ 0xdadd, 0x223e61 },
	{ 0xdade, 0x223e62 },
	{ 0xdadf, 0x22376f },
	{ 0xdae0, 0x223e64 },
	{ 0xdae1, 0x223e65 },
	{ 0xdae2, 0x223e66 },
	{ 0xdae3, 0x223e67 },
	{ 0xdae4, 0x223e68 },
	{ 0xdae5, 0x223e69 },
	{ 0xdae6, 0x223e6a },
	{ 0xdae7, 0x223e6b },
	{ 0xdae8, 0x223e6c },
	{ 0xdae9, 0x223e6d },
	{ 0xdaea, 0x223e6e },
	{ 0xdaeb, 0x223e6f },
	{ 0xdaec, 0x223e70 },
	{ 0xdaed, 0x223e71 },
	{ 0xdaee, 0x223e72 },
	{ 0xdaef, 0x223e73 },
	{ 0xdaf0, 0x223e74 },
	{ 0xdaf1, 0x223e75 },
	{ 0xdaf2, 0x223e76 },
	{ 0xdaf3, 0x223e77 },
	{ 0xdaf4, 0x223e78 },
	{ 0xdaf5, 0x223e79 },
	{ 0xdaf6, 0x223e7a },
	{ 0xdaf7, 0x223e7b },
	{ 0xdaf8, 0x223e7c },
	{ 0xdaf9, 0x223e7d },
	{ 0xdafa, 0x223e7e },
	{ 0xdafb, 0x223f21 },
	{ 0xdafc, 0x223f22 },
	{ 0xdafd, 0x223f23 },
	{ 0xdafe, 0x223f24 },
	{ 0xdb40, 0x223f25 },
	{ 0xdb41, 0x223f26 },
	{ 0xdb42, 0x223f27 },
	{ 0xdb43, 0x223f28 },
	{ 0xdb44, 0x223f29 },
	{ 0xdb45, 0x223f2a },
	{ 0xdb46, 0x223f2b },
	{ 0xdb47, 0x223f2c },
	{ 0xdb48, 0x223f2d },
	{ 0xdb49, 0x223f2e },
	{ 0xdb4a, 0x223f2f },
	{ 0xdb4b, 0x223f30 },
	{ 0xdb4c, 0x223f31 },
	{ 0xdb4d, 0x223f32 },
	{ 0xdb4e, 0x223f33 },
	{ 0xdb4f, 0x223f34 },
	{ 0xdb50, 0x223f35 },
	{ 0xdb51, 0x223f36 },
	{ 0xdb52, 0x223f37 },
	{ 0xdb53, 0x223f38 },
	{ 0xdb54, 0x223f39 },
	{ 0xdb55, 0x223f3a },
	{ 0xdb56, 0x223f3b },
	{ 0xdb57, 0x223f3c },
	{ 0xdb58, 0x223f3d },
	{ 0xdb59, 0x223f3e },
	{ 0xdb5a, 0x223f3f },
	{ 0xdb5b, 0x223f40 },
	{ 0xdb5c, 0x223f41 },
	{ 0xdb5d, 0x223f42 },
	{ 0xdb5e, 0x223f43 },
	{ 0xdb5f, 0x223f44 },
	{ 0xdb60, 0x223f45 },
	{ 0xdb61, 0x223f46 },
	{ 0xdb62, 0x223f47 },
	{ 0xdb63, 0x223f48 },
	{ 0xdb64, 0x223f49 },
	{ 0xdb65, 0x223f4a },
	{ 0xdb66, 0x223f4b },
	{ 0xdb67, 0x223f4c },
	{ 0xdb68, 0x223f4d },
	{ 0xdb69, 0x223f4e },
	{ 0xdb6a, 0x223f4f },
	{ 0xdb6b, 0x223f50 },
	{ 0xdb6c, 0x223f51 },
	{ 0xdb6d, 0x223f52 },
	{ 0xdb6e, 0x223f53 },
	{ 0xdb6f, 0x223f54 },
	{ 0xdb70, 0x223f55 },
	{ 0xdb71, 0x223f56 },
	{ 0xdb72, 0x223f57 },
	{ 0xdb73, 0x223f58 },
	{ 0xdb74, 0x223f59 },
	{ 0xdb75, 0x223f5a },
	{ 0xdb76, 0x223f5b },
	{ 0xdb77, 0x223f5c },
	{ 0xdb78, 0x223f5d },
	{ 0xdb79, 0x223f5e },
	{ 0xdb7a, 0x223f5f },
	{ 0xdb7b, 0x223f60 },
	{ 0xdb7c, 0x223f61 },
	{ 0xdb7d, 0x223f62 },
	{ 0xdb7e, 0x223f63 },
	{ 0xdba1, 0x223f64 },
	{ 0xdba2, 0x223f65 },
	{ 0xdba3, 0x223f66 },
	{ 0xdba4, 0x223f67 },
	{ 0xdba5, 0x223f68 },
	{ 0xdba6, 0x223f69 },
	{ 0xdba7, 0x223f6b },
	{ 0xdba8, 0x223f6c },
	{ 0xdba9, 0x223f6d },
	{ 0xdbaa, 0x223f6e },
	{ 0xdbab, 0x223f6f },
	{ 0xdbac, 0x223f70 },
	{ 0xdbad, 0x223f71 },
	{ 0xdbae, 0x223f72 },
	{ 0xdbaf, 0x223f73 },
	{ 0xdbb0, 0x223f74 },
	{ 0xdbb1, 0x223f75 },
	{ 0xdbb2, 0x223f76 },
	{ 0xdbb3, 0x223f77 },
	{ 0xdbb4, 0x223f78 },
	{ 0xdbb5, 0x223f79 },
	{ 0xdbb6, 0x223f7a },
	{ 0xdbb7, 0x223f7b },
	{ 0xdbb8, 0x223f7c },
	{ 0xdbb9, 0x223f7d },
	{ 0xdbba, 0x223f7e },
	{ 0xdbbb, 0x224021 },
	{ 0xdbbc, 0x224022 },
	{ 0xdbbd, 0x224023 },
	{ 0xdbbe, 0x224024 },
	{ 0xdbbf, 0x224025 },
	{ 0xdbc0, 0x224026 },
	{ 0xdbc1, 0x224027 },
	{ 0xdbc2, 0x224028 },
	{ 0xdbc3, 0x224029 },
	{ 0xdbc4, 0x22402a },
	{ 0xdbc5, 0x22402b },
	{ 0xdbc6, 0x22402c },
	{ 0xdbc7, 0x22402d },
	{ 0xdbc8, 0x22402e },
	{ 0xdbc9, 0x22402f },
	{ 0xdbca, 0x224030 },
	{ 0xdbcb, 0x224031 },
	{ 0xdbcc, 0x224032 },
	{ 0xdbcd, 0x224033 },
	{ 0xdbce, 0x224034 },
	{ 0xdbcf, 0x224035 },
	{ 0xdbd0, 0x224036 },
	{ 0xdbd1, 0x224037 },
	{ 0xdbd2, 0x224038 },
	{ 0xdbd3, 0x224039 },
	{ 0xdbd4, 0x22403a },
	{ 0xdbd5, 0x22403b },
	{ 0xdbd6, 0x22403c },
	{ 0xdbd7, 0x22403d },
	{ 0xdbd8, 0x22403e },
	{ 0xdbd9, 0x22403f },
	{ 0xdbda, 0x224040 },
	{ 0xdbdb, 0x224041 },
	{ 0xdbdc, 0x224042 },
	{ 0xdbdd, 0x224043 },
	{ 0xdbde, 0x224044 },
	{ 0xdbdf, 0x224045 },
	{ 0xdbe0, 0x224046 },
	{ 0xdbe1, 0x224047 },
	{ 0xdbe2, 0x224048 },
	{ 0xdbe3, 0x224049 },
	{ 0xdbe4, 0x22404a },
	{ 0xdbe5, 0x22404b },
	{ 0xdbe6, 0x22404c },
	{ 0xdbe7, 0x22404d },
	{ 0xdbe8, 0x22404e },
	{ 0xdbe9, 0x22404f },
	{ 0xdbea, 0x224050 },
	{ 0xdbeb, 0x224051 },
	{ 0xdbec, 0x224052 },
	{ 0xdbed, 0x224053 },
	{ 0xdbee, 0x224054 },
	{ 0xdbef, 0x224055 },
	{ 0xdbf0, 0x224056 },
	{ 0xdbf1, 0x224057 },
	{ 0xdbf2, 0x224058 },
	{ 0xdbf3, 0x224059 },
	{ 0xdbf4, 0x22405a },
	{ 0xdbf5, 0x22405b },
	{ 0xdbf6, 0x22405c },
	{ 0xdbf7, 0x22405d },
	{ 0xdbf8, 0x22405e },
	{ 0xdbf9, 0x22405f },
	{ 0xdbfa, 0x224060 },
	{ 0xdbfb, 0x224061 },
	{ 0xdbfc, 0x224062 },
	{ 0xdbfd, 0x224063 },
	{ 0xdbfe, 0x224064 },
	{ 0xdc40, 0x224065 },
	{ 0xdc41, 0x224066 },
	{ 0xdc42, 0x224067 },
	{ 0xdc43, 0x224068 },
	{ 0xdc44, 0x224069 },
	{ 0xdc45, 0x22406a },
	{ 0xdc46, 0x22406b },
	{ 0xdc47, 0x22406c },
	{ 0xdc48, 0x22406d },
	{ 0xdc49, 0x22406e },
	{ 0xdc4a, 0x22406f },
	{ 0xdc4b, 0x224070 },
	{ 0xdc4c, 0x224071 },
	{ 0xdc4d, 0x224072 },
	{ 0xdc4e, 0x224073 },
	{ 0xdc4f, 0x224074 },
	{ 0xdc50, 0x224075 },
	{ 0xdc51, 0x224076 },
	{ 0xdc52, 0x224077 },
	{ 0xdc53, 0x224078 },
	{ 0xdc54, 0x224079 },
	{ 0xdc55, 0x22407a },
	{ 0xdc56, 0x22407b },
	{ 0xdc57, 0x22407c },
	{ 0xdc58, 0x22407d },
	{ 0xdc59, 0x22407e },
	{ 0xdc5a, 0x224121 },
	{ 0xdc5b, 0x224122 },
	{ 0xdc5c, 0x224123 },
	{ 0xdc5d, 0x224124 },
	{ 0xdc5e, 0x224125 },
	{ 0xdc5f, 0x224126 },
	{ 0xdc60, 0x224127 },
	{ 0xdc61, 0x224128 },
	{ 0xdc62, 0x224129 },
	{ 0xdc63, 0x22412a },
	{ 0xdc64, 0x22412b },
	{ 0xdc65, 0x22412c },
	{ 0xdc66, 0x22412d },
	{ 0xdc67, 0x22412e },
	{ 0xdc68, 0x22412f },
	{ 0xdc69, 0x224130 },
	{ 0xdc6a, 0x224131 },
	{ 0xdc6b, 0x224132 },
	{ 0xdc6c, 0x224133 },
	{ 0xdc6d, 0x224134 },
	{ 0xdc6e, 0x224135 },
	{ 0xdc6f, 0x224136 },
	{ 0xdc70, 0x224137 },
	{ 0xdc71, 0x224138 },
	{ 0xdc72, 0x224139 },
	{ 0xdc73, 0x22413a },
	{ 0xdc74, 0x22413b },
	{ 0xdc75, 0x22413c },
	{ 0xdc76, 0x22413d },
	{ 0xdc77, 0x22413e },
	{ 0xdc78, 0x22413f },
	{ 0xdc79, 0x224140 },
	{ 0xdc7a, 0x224141 },
	{ 0xdc7b, 0x224142 },
	{ 0xdc7c, 0x224143 },
	{ 0xdc7d, 0x224144 },
	{ 0xdc7e, 0x224145 },
	{ 0xdca1, 0x224146 },
	{ 0xdca2, 0x224147 },
	{ 0xdca3, 0x224148 },
	{ 0xdca4, 0x224149 },
	{ 0xdca5, 0x22414a },
	{ 0xdca6, 0x22414b },
	{ 0xdca7, 0x22414c },
	{ 0xdca8, 0x22414d },
	{ 0xdca9, 0x22414e },
	{ 0xdcaa, 0x22414f },
	{ 0xdcab, 0x224150 },
	{ 0xdcac, 0x224151 },
	{ 0xdcad, 0x224152 },
	{ 0xdcae, 0x224153 },
	{ 0xdcaf, 0x224154 },
	{ 0xdcb0, 0x224155 },
	{ 0xdcb1, 0x224156 },
	{ 0xdcb2, 0x224157 },
	{ 0xdcb3, 0x224158 },
	{ 0xdcb4, 0x224159 },
	{ 0xdcb5, 0x22415a },
	{ 0xdcb6, 0x22415b },
	{ 0xdcb7, 0x22415c },
	{ 0xdcb8, 0x22415d },
	{ 0xdcb9, 0x22415e },
	{ 0xdcba, 0x22415f },
	{ 0xdcbb, 0x224160 },
	{ 0xdcbc, 0x224161 },
	{ 0xdcbd, 0x224162 },
	{ 0xdcbe, 0x224163 },
	{ 0xdcbf, 0x224164 },
	{ 0xdcc0, 0x224165 },
	{ 0xdcc1, 0x224166 },
	{ 0xdcc2, 0x224167 },
	{ 0xdcc3, 0x224168 },
	{ 0xdcc4, 0x224169 },
	{ 0xdcc5, 0x22416a },
	{ 0xdcc6, 0x22416b },
	{ 0xdcc7, 0x22416c },
	{ 0xdcc8, 0x22416d },
	{ 0xdcc9, 0x22416e },
	{ 0xdcca, 0x22416f },
	{ 0xdccb, 0x224170 },
	{ 0xdccc, 0x224171 },
	{ 0xdccd, 0x224172 },
	{ 0xdcce, 0x224173 },
	{ 0xdccf, 0x224174 },
	{ 0xdcd0, 0x224175 },
	{ 0xdcd1, 0x224176 },
	{ 0xdcd2, 0x224177 },
	{ 0xdcd3, 0x224178 },
	{ 0xdcd4, 0x224179 },
	{ 0xdcd5, 0x22417a },
	{ 0xdcd6, 0x22417b },
	{ 0xdcd7, 0x22417c },
	{ 0xdcd8, 0x22417d },
	{ 0xdcd9, 0x22417e },
	{ 0xdcda, 0x224221 },
	{ 0xdcdb, 0x224222 },
	{ 0xdcdc, 0x224223 },
	{ 0xdcdd, 0x224224 },
	{ 0xdcde, 0x224225 },
	{ 0xdcdf, 0x224226 },
	{ 0xdce0, 0x224227 },
	{ 0xdce1, 0x224228 },
	{ 0xdce2, 0x224229 },
	{ 0xdce3, 0x22422a },
	{ 0xdce4, 0x22422b },
	{ 0xdce5, 0x22422c },
	{ 0xdce6, 0x22422d },
	{ 0xdce7, 0x22422e },
	{ 0xdce8, 0x22422f },
	{ 0xdce9, 0x224230 },
	{ 0xdcea, 0x224231 },
	{ 0xdceb, 0x224232 },
	{ 0xdcec, 0x224233 },
	{ 0xdced, 0x224234 },
	{ 0xdcee, 0x224235 },
	{ 0xdcef, 0x224236 },
	{ 0xdcf0, 0x224237 },
	{ 0xdcf1, 0x224238 },
	{ 0xdcf2, 0x224239 },
	{ 0xdcf3, 0x22423a },
	{ 0xdcf4, 0x22423b },
	{ 0xdcf5, 0x22423c },
	{ 0xdcf6, 0x22423d },
	{ 0xdcf7, 0x22423e },
	{ 0xdcf8, 0x22423f },
	{ 0xdcf9, 0x224240 },
	{ 0xdcfa, 0x224241 },
	{ 0xdcfb, 0x224242 },
	{ 0xdcfc, 0x224243 },
	{ 0xdcfd, 0x224244 },
	{ 0xdcfe, 0x224245 },
	{ 0xdd40, 0x224246 },
	{ 0xdd41, 0x224247 },
	{ 0xdd42, 0x224248 },
	{ 0xdd43, 0x224249 },
	{ 0xdd44, 0x22424a },
	{ 0xdd45, 0x22424b },
	{ 0xdd46, 0x22424c },
	{ 0xdd47, 0x22424d },
	{ 0xdd48, 0x22424e },
	{ 0xdd49, 0x22424f },
	{ 0xdd4a, 0x224250 },
	{ 0xdd4b, 0x224251 },
	{ 0xdd4c, 0x224252 },
	{ 0xdd4d, 0x224253 },
	{ 0xdd4e, 0x224254 },
	{ 0xdd4f, 0x224255 },
	{ 0xdd50, 0x224256 },
	{ 0xdd51, 0x224257 },
	{ 0xdd52, 0x224258 },
	{ 0xdd53, 0x224259 },
	{ 0xdd54, 0x22425a },
	{ 0xdd55, 0x22425b },
	{ 0xdd56, 0x22425c },
	{ 0xdd57, 0x22425d },
	{ 0xdd58, 0x22425e },
	{ 0xdd59, 0x22425f },
	{ 0xdd5a, 0x224260 },
	{ 0xdd5b, 0x224261 },
	{ 0xdd5c, 0x224262 },
	{ 0xdd5d, 0x224263 },
	{ 0xdd5e, 0x224264 },
	{ 0xdd5f, 0x224265 },
	{ 0xdd60, 0x224266 },
	{ 0xdd61, 0x224267 },
	{ 0xdd62, 0x224268 },
	{ 0xdd63, 0x224269 },
	{ 0xdd64, 0x22426a },
	{ 0xdd65, 0x22426b },
	{ 0xdd66, 0x22426c },
	{ 0xdd67, 0x22426d },
	{ 0xdd68, 0x22426e },
	{ 0xdd69, 0x22426f },
	{ 0xdd6a, 0x224270 },
	{ 0xdd6b, 0x224271 },
	{ 0xdd6c, 0x224272 },
	{ 0xdd6d, 0x224273 },
	{ 0xdd6e, 0x224274 },
	{ 0xdd6f, 0x224275 },
	{ 0xdd70, 0x224276 },
	{ 0xdd71, 0x224277 },
	{ 0xdd72, 0x224278 },
	{ 0xdd73, 0x224279 },
	{ 0xdd74, 0x22427a },
	{ 0xdd75, 0x22427b },
	{ 0xdd76, 0x22427c },
	{ 0xdd77, 0x22427d },
	{ 0xdd78, 0x22427e },
	{ 0xdd79, 0x224321 },
	{ 0xdd7a, 0x224322 },
	{ 0xdd7b, 0x224323 },
	{ 0xdd7c, 0x224324 },
	{ 0xdd7d, 0x224325 },
	{ 0xdd7e, 0x224326 },
	{ 0xdda1, 0x224327 },
	{ 0xdda2, 0x224328 },
	{ 0xdda3, 0x224329 },
	{ 0xdda4, 0x22432a },
	{ 0xdda5, 0x22432b },
	{ 0xdda6, 0x22432c },
	{ 0xdda7, 0x22432d },
	{ 0xdda8, 0x22432e },
	{ 0xdda9, 0x22432f },
	{ 0xddaa, 0x224330 },
	{ 0xddab, 0x224331 },
	{ 0xddac, 0x224332 },
	{ 0xddad, 0x224333 },
	{ 0xddae, 0x224334 },
	{ 0xddaf, 0x224335 },
	{ 0xddb0, 0x224336 },
	{ 0xddb1, 0x224337 },
	{ 0xddb2, 0x224338 },
	{ 0xddb3, 0x224339 },
	{ 0xddb4, 0x22433a },
	{ 0xddb5, 0x22433b },
	{ 0xddb6, 0x22433c },
	{ 0xddb7, 0x22433d },
	{ 0xddb8, 0x22433e },
	{ 0xddb9, 0x22433f },
	{ 0xddba, 0x224340 },
	{ 0xddbb, 0x224341 },
	{ 0xddbc, 0x224342 },
	{ 0xddbd, 0x224343 },
	{ 0xddbe, 0x224344 },
	{ 0xddbf, 0x224345 },
	{ 0xddc0, 0x224346 },
	{ 0xddc1, 0x224347 },
	{ 0xddc2, 0x224348 },
	{ 0xddc3, 0x224349 },
	{ 0xddc4, 0x22434a },
	{ 0xddc5, 0x22434b },
	{ 0xddc6, 0x22434c },
	{ 0xddc7, 0x22434d },
	{ 0xddc8, 0x22434e },
	{ 0xddc9, 0x22434f },
	{ 0xddca, 0x224350 },
	{ 0xddcb, 0x224351 },
	{ 0xddcc, 0x224352 },
	{ 0xddcd, 0x224353 },
	{ 0xddce, 0x224354 },
	{ 0xddcf, 0x224355 },
	{ 0xddd0, 0x224356 },
	{ 0xddd1, 0x224357 },
	{ 0xddd2, 0x224358 },
	{ 0xddd3, 0x224359 },
	{ 0xddd4, 0x22435a },
	{ 0xddd5, 0x22435b },
	{ 0xddd6, 0x22435c },
	{ 0xddd7, 0x22435d },
	{ 0xddd8, 0x22435e },
	{ 0xddd9, 0x22435f },
	{ 0xddda, 0x224360 },
	{ 0xdddb, 0x224361 },
	{ 0xdddc, 0x224362 },
	{ 0xdddd, 0x224363 },
	{ 0xddde, 0x224364 },
	{ 0xdddf, 0x224365 },
	{ 0xdde0, 0x224366 },
	{ 0xdde1, 0x224367 },
	{ 0xdde2, 0x224368 },
	{ 0xdde3, 0x224369 },
	{ 0xdde4, 0x22436a },
	{ 0xdde5, 0x22436b },
	{ 0xdde6, 0x22436c },
	{ 0xdde7, 0x22436d },
	{ 0xdde8, 0x22436e },
	{ 0xdde9, 0x22436f },
	{ 0xddea, 0x224370 },
	{ 0xddeb, 0x224371 },
	{ 0xddec, 0x224372 },
	{ 0xdded, 0x224373 },
	{ 0xddee, 0x224374 },
	{ 0xddef, 0x224375 },
	{ 0xddf0, 0x224376 },
	{ 0xddf1, 0x224377 },
	{ 0xddf2, 0x224378 },
	{ 0xddf3, 0x224379 },
	{ 0xddf4, 0x22437a },
	{ 0xddf5, 0x22437b },
	{ 0xddf6, 0x22437c },
	{ 0xddf7, 0x22437d },
	{ 0xddf8, 0x22437e },
	{ 0xddf9, 0x224421 },
	{ 0xddfa, 0x224422 },
	{ 0xddfb, 0x224423 },
	{ 0xddfc, 0x224176 },
	{ 0xddfd, 0x224424 },
	{ 0xddfe, 0x224425 },
	{ 0xde40, 0x224426 },
	{ 0xde41, 0x224427 },
	{ 0xde42, 0x224428 },
	{ 0xde43, 0x224429 },
	{ 0xde44, 0x22442a },
	{ 0xde45, 0x22442b },
	{ 0xde46, 0x22442c },
	{ 0xde47, 0x22442d },
	{ 0xde48, 0x22442e },
	{ 0xde49, 0x22442f },
	{ 0xde4a, 0x224430 },
	{ 0xde4b, 0x224431 },
	{ 0xde4c, 0x224432 },
	{ 0xde4d, 0x224433 },
	{ 0xde4e, 0x224434 },
	{ 0xde4f, 0x224435 },
	{ 0xde50, 0x224436 },
	{ 0xde51, 0x224437 },
	{ 0xde52, 0x224438 },
	{ 0xde53, 0x224439 },
	{ 0xde54, 0x22443a },
	{ 0xde55, 0x22443b },
	{ 0xde56, 0x22443c },
	{ 0xde57, 0x22443d },
	{ 0xde58, 0x22443e },
	{ 0xde59, 0x22443f },
	{ 0xde5a, 0x224440 },
	{ 0xde5b, 0x224441 },
	{ 0xde5c, 0x224442 },
	{ 0xde5d, 0x224443 },
	{ 0xde5e, 0x224444 },
	{ 0xde5f, 0x224445 },
	{ 0xde60, 0x224446 },
	{ 0xde61, 0x224447 },
	{ 0xde62, 0x224448 },
	{ 0xde63, 0x224449 },
	{ 0xde64, 0x22444a },
	{ 0xde65, 0x22444b },
	{ 0xde66, 0x22444c },
	{ 0xde67, 0x22444d },
	{ 0xde68, 0x22444e },
	{ 0xde69, 0x22444f },
	{ 0xde6a, 0x224450 },
	{ 0xde6b, 0x224451 },
	{ 0xde6c, 0x224452 },
	{ 0xde6d, 0x224453 },
	{ 0xde6e, 0x224454 },
	{ 0xde6f, 0x224455 },
	{ 0xde70, 0x224456 },
	{ 0xde71, 0x224457 },
	{ 0xde72, 0x224458 },
	{ 0xde73, 0x224459 },
	{ 0xde74, 0x22445a },
	{ 0xde75, 0x22445b },
	{ 0xde76, 0x22445c },
	{ 0xde77, 0x22445d },
	{ 0xde78, 0x22445e },
	{ 0xde79, 0x22445f },
	{ 0xde7a, 0x224460 },
	{ 0xde7b, 0x224461 },
	{ 0xde7c, 0x224462 },
	{ 0xde7d, 0x224463 },
	{ 0xde7e, 0x224464 },
	{ 0xdea1, 0x224465 },
	{ 0xdea2, 0x224466 },
	{ 0xdea3, 0x224467 },
	{ 0xdea4, 0x224468 },
	{ 0xdea5, 0x224469 },
	{ 0xdea6, 0x22446a },
	{ 0xdea7, 0x22446b },
	{ 0xdea8, 0x22446c },
	{ 0xdea9, 0x22446d },
	{ 0xdeaa, 0x22446e },
	{ 0xdeab, 0x22446f },
	{ 0xdeac, 0x224470 },
	{ 0xdead, 0x224471 },
	{ 0xdeae, 0x224472 },
	{ 0xdeaf, 0x224473 },
	{ 0xdeb0, 0x224474 },
	{ 0xdeb1, 0x224475 },
	{ 0xdeb2, 0x224476 },
	{ 0xdeb3, 0x224477 },
	{ 0xdeb4, 0x224478 },
	{ 0xdeb5, 0x224479 },
	{ 0xdeb6, 0x22447a },
	{ 0xdeb7, 0x22447b },
	{ 0xdeb8, 0x22447c },
	{ 0xdeb9, 0x22447d },
	{ 0xdeba, 0x22447e },
	{ 0xdebb, 0x224521 },
	{ 0xdebc, 0x224522 },
	{ 0xdebd, 0x224523 },
	{ 0xdebe, 0x224524 },
	{ 0xdebf, 0x224525 },
	{ 0xdec0, 0x224526 },
	{ 0xdec1, 0x224527 },
	{ 0xdec2, 0x224528 },
	{ 0xdec3, 0x224529 },
	{ 0xdec4, 0x22452a },
	{ 0xdec5, 0x22452b },
	{ 0xdec6, 0x22452c },
	{ 0xdec7, 0x22452d },
	{ 0xdec8, 0x22452e },
	{ 0xdec9, 0x22452f },
	{ 0xdeca, 0x224530 },
	{ 0xdecb, 0x224531 },
	{ 0xdecc, 0x224532 },
	{ 0xdecd, 0x224533 },
	{ 0xdece, 0x224534 },
	{ 0xdecf, 0x224535 },
	{ 0xded0, 0x224536 },
	{ 0xded1, 0x224537 },
	{ 0xded2, 0x224538 },
	{ 0xded3, 0x224539 },
	{ 0xded4, 0x22453a },
	{ 0xded5, 0x22453b },
	{ 0xded6, 0x22453c },
	{ 0xded7, 0x22453d },
	{ 0xded8, 0x22453e },
	{ 0xded9, 0x22453f },
	{ 0xdeda, 0x224540 },
	{ 0xdedb, 0x224541 },
	{ 0xdedc, 0x224542 },
	{ 0xdedd, 0x224543 },
	{ 0xdede, 0x224544 },
	{ 0xdedf, 0x224545 },
	{ 0xdee0, 0x224546 },
	{ 0xdee1, 0x224547 },
	{ 0xdee2, 0x224548 },
	{ 0xdee3, 0x224549 },
	{ 0xdee4, 0x22454a },
	{ 0xdee5, 0x22454b },
	{ 0xdee6, 0x22454c },
	{ 0xdee7, 0x22454d },
	{ 0xdee8, 0x22454e },
	{ 0xdee9, 0x22454f },
	{ 0xdeea, 0x224550 },
	{ 0xdeeb, 0x224551 },
	{ 0xdeec, 0x224552 },
	{ 0xdeed, 0x224553 },
	{ 0xdeee, 0x224554 },
	{ 0xdeef, 0x224555 },
	{ 0xdef0, 0x224556 },
	{ 0xdef1, 0x224557 },
	{ 0xdef2, 0x224558 },
	{ 0xdef3, 0x224559 },
	{ 0xdef4, 0x22455a },
	{ 0xdef5, 0x22455b },
	{ 0xdef6, 0x22455c },
	{ 0xdef7, 0x22455d },
	{ 0xdef8, 0x22455e },
	{ 0xdef9, 0x22455f },
	{ 0xdefa, 0x224560 },
	{ 0xdefb, 0x224561 },
	{ 0xdefc, 0x224562 },
	{ 0xdefd, 0x224563 },
	{ 0xdefe, 0x224564 },
	{ 0xdf40, 0x224565 },
	{ 0xdf41, 0x224566 },
	{ 0xdf42, 0x224567 },
	{ 0xdf43, 0x224568 },
	{ 0xdf44, 0x224569 },
	{ 0xdf45, 0x22456a },
	{ 0xdf46, 0x22456b },
	{ 0xdf47, 0x22456c },
	{ 0xdf48, 0x22456d },
	{ 0xdf49, 0x22456e },
	{ 0xdf4a, 0x22456f },
	{ 0xdf4b, 0x224570 },
	{ 0xdf4c, 0x224571 },
	{ 0xdf4d, 0x224572 },
	{ 0xdf4e, 0x224573 },
	{ 0xdf4f, 0x224574 },
	{ 0xdf50, 0x224575 },
	{ 0xdf51, 0x224576 },
	{ 0xdf52, 0x224577 },
	{ 0xdf53, 0x224578 },
	{ 0xdf54, 0x224579 },
	{ 0xdf55, 0x22457a },
	{ 0xdf56, 0x22457b },
	{ 0xdf57, 0x22457c },
	{ 0xdf58, 0x22457d },
	{ 0xdf59, 0x22457e },
	{ 0xdf5a, 0x224621 },
	{ 0xdf5b, 0x224622 },
	{ 0xdf5c, 0x224623 },
	{ 0xdf5d, 0x224624 },
	{ 0xdf5e, 0x224625 },
	{ 0xdf5f, 0x224626 },
	{ 0xdf60, 0x224627 },
	{ 0xdf61, 0x224628 },
	{ 0xdf62, 0x224629 },
	{ 0xdf63, 0x22462a },
	{ 0xdf64, 0x22462b },
	{ 0xdf65, 0x22462c },
	{ 0xdf66, 0x22462d },
	{ 0xdf67, 0x22462e },
	{ 0xdf68, 0x22462f },
	{ 0xdf69, 0x224630 },
	{ 0xdf6a, 0x224631 },
	{ 0xdf6b, 0x224632 },
	{ 0xdf6c, 0x224633 },
	{ 0xdf6d, 0x224634 },
	{ 0xdf6e, 0x224635 },
	{ 0xdf6f, 0x224636 },
	{ 0xdf70, 0x224637 },
	{ 0xdf71, 0x224638 },
	{ 0xdf72, 0x224639 },
	{ 0xdf73, 0x22463a },
	{ 0xdf74, 0x22463b },
	{ 0xdf75, 0x22463c },
	{ 0xdf76, 0x22463d },
	{ 0xdf77, 0x22463e },
	{ 0xdf78, 0x22463f },
	{ 0xdf79, 0x224640 },
	{ 0xdf7a, 0x224641 },
	{ 0xdf7b, 0x224642 },
	{ 0xdf7c, 0x224643 },
	{ 0xdf7d, 0x224644 },
	{ 0xdf7e, 0x224645 },
	{ 0xdfa1, 0x224646 },
	{ 0xdfa2, 0x224647 },
	{ 0xdfa3, 0x224648 },
	{ 0xdfa4, 0x224649 },
	{ 0xdfa5, 0x22464a },
	{ 0xdfa6, 0x22464b },
	{ 0xdfa7, 0x22464c },
	{ 0xdfa8, 0x22464d },
	{ 0xdfa9, 0x22464e },
	{ 0xdfaa, 0x22464f },
	{ 0xdfab, 0x224650 },
	{ 0xdfac, 0x224651 },
	{ 0xdfad, 0x224652 },
	{ 0xdfae, 0x224653 },
	{ 0xdfaf, 0x224654 },
	{ 0xdfb0, 0x224655 },
	{ 0xdfb1, 0x224656 },
	{ 0xdfb2, 0x224657 },
	{ 0xdfb3, 0x224658 },
	{ 0xdfb4, 0x224659 },
	{ 0xdfb5, 0x22465a },
	{ 0xdfb6, 0x22465b },
	{ 0xdfb7, 0x22465c },
	{ 0xdfb8, 0x22465d },
	{ 0xdfb9, 0x22465e },
	{ 0xdfba, 0x22465f },
	{ 0xdfbb, 0x224660 },
	{ 0xdfbc, 0x224661 },
	{ 0xdfbd, 0x224662 },
	{ 0xdfbe, 0x224663 },
	{ 0xdfbf, 0x224664 },
	{ 0xdfc0, 0x224665 },
	{ 0xdfc1, 0x224666 },
	{ 0xdfc2, 0x224667 },
	{ 0xdfc3, 0x224668 },
	{ 0xdfc4, 0x224669 },
	{ 0xdfc5, 0x22466a },
	{ 0xdfc6, 0x22466b },
	{ 0xdfc7, 0x22466c },
	{ 0xdfc8, 0x22466d },
	{ 0xdfc9, 0x22466e },
	{ 0xdfca, 0x22466f },
	{ 0xdfcb, 0x224670 },
	{ 0xdfcc, 0x224671 },
	{ 0xdfcd, 0x224672 },
	{ 0xdfce, 0x224673 },
	{ 0xdfcf, 0x224674 },
	{ 0xdfd0, 0x224675 },
	{ 0xdfd1, 0x224676 },
	{ 0xdfd2, 0x224677 },
	{ 0xdfd3, 0x224678 },
	{ 0xdfd4, 0x224679 },
	{ 0xdfd5, 0x22467a },
	{ 0xdfd6, 0x22467b },
	{ 0xdfd7, 0x22467c },
	{ 0xdfd8, 0x22467d },
	{ 0xdfd9, 0x22467e },
	{ 0xdfda, 0x224721 },
	{ 0xdfdb, 0x224722 },
	{ 0xdfdc, 0x224723 },
	{ 0xdfdd, 0x224724 },
	{ 0xdfde, 0x224725 },
	{ 0xdfdf, 0x224726 },
	{ 0xdfe0, 0x224727 },
	{ 0xdfe1, 0x224728 },
	{ 0xdfe2, 0x224729 },
	{ 0xdfe3, 0x22472a },
	{ 0xdfe4, 0x22472b },
	{ 0xdfe5, 0x22472c },
	{ 0xdfe6, 0x22472d },
	{ 0xdfe7, 0x22472e },
	{ 0xdfe8, 0x22472f },
	{ 0xdfe9, 0x224730 },
	{ 0xdfea, 0x224731 },
	{ 0xdfeb, 0x224732 },
	{ 0xdfec, 0x224733 },
	{ 0xdfed, 0x224734 },
	{ 0xdfee, 0x224735 },
	{ 0xdfef, 0x224736 },
	{ 0xdff0, 0x224737 },
	{ 0xdff1, 0x224738 },
	{ 0xdff2, 0x224739 },
	{ 0xdff3, 0x22473a },
	{ 0xdff4, 0x22473b },
	{ 0xdff5, 0x22473c },
	{ 0xdff6, 0x22473d },
	{ 0xdff7, 0x22473e },
	{ 0xdff8, 0x22473f },
	{ 0xdff9, 0x224740 },
	{ 0xdffa, 0x224741 },
	{ 0xdffb, 0x224742 },
	{ 0xdffc, 0x224743 },
	{ 0xdffd, 0x224744 },
	{ 0xdffe, 0x224745 },
	{ 0xe040, 0x224746 },
	{ 0xe041, 0x224747 },
	{ 0xe042, 0x224748 },
	{ 0xe043, 0x224749 },
	{ 0xe044, 0x22474a },
	{ 0xe045, 0x22474b },
	{ 0xe046, 0x22474c },
	{ 0xe047, 0x22474d },
	{ 0xe048, 0x22474e },
	{ 0xe049, 0x22474f },
	{ 0xe04a, 0x224750 },
	{ 0xe04b, 0x224751 },
	{ 0xe04c, 0x224752 },
	{ 0xe04d, 0x224753 },
	{ 0xe04e, 0x224754 },
	{ 0xe04f, 0x224755 },
	{ 0xe050, 0x224756 },
	{ 0xe051, 0x224757 },
	{ 0xe052, 0x224758 },
	{ 0xe053, 0x224759 },
	{ 0xe054, 0x22475a },
	{ 0xe055, 0x22475b },
	{ 0xe056, 0x22475c },
	{ 0xe057, 0x22475d },
	{ 0xe058, 0x22475e },
	{ 0xe059, 0x22475f },
	{ 0xe05a, 0x224760 },
	{ 0xe05b, 0x224761 },
	{ 0xe05c, 0x224762 },
	{ 0xe05d, 0x224763 },
	{ 0xe05e, 0x224764 },
	{ 0xe05f, 0x224765 },
	{ 0xe060, 0x224766 },
	{ 0xe061, 0x224767 },
	{ 0xe062, 0x224768 },
	{ 0xe063, 0x224769 },
	{ 0xe064, 0x22476a },
	{ 0xe065, 0x22476b },
	{ 0xe066, 0x22476c },
	{ 0xe067, 0x22476d },
	{ 0xe068, 0x22476e },
	{ 0xe069, 0x22476f },
	{ 0xe06a, 0x224770 },
	{ 0xe06b, 0x224771 },
	{ 0xe06c, 0x224772 },
	{ 0xe06d, 0x224773 },
	{ 0xe06e, 0x224774 },
	{ 0xe06f, 0x224775 },
	{ 0xe070, 0x224776 },
	{ 0xe071, 0x224777 },
	{ 0xe072, 0x224778 },
	{ 0xe073, 0x224779 },
	{ 0xe074, 0x22477a },
	{ 0xe075, 0x22477b },
	{ 0xe076, 0x22477c },
	{ 0xe077, 0x22477d },
	{ 0xe078, 0x22477e },
	{ 0xe079, 0x224821 },
	{ 0xe07a, 0x224822 },
	{ 0xe07b, 0x224823 },
	{ 0xe07c, 0x224824 },
	{ 0xe07d, 0x224825 },
	{ 0xe07e, 0x224826 },
	{ 0xe0a1, 0x224827 },
	{ 0xe0a2, 0x224828 },
	{ 0xe0a3, 0x224829 },
	{ 0xe0a4, 0x22482a },
	{ 0xe0a5, 0x22482b },
	{ 0xe0a6, 0x22482c },
	{ 0xe0a7, 0x22482d },
	{ 0xe0a8, 0x22482e },
	{ 0xe0a9, 0x22482f },
	{ 0xe0aa, 0x224830 },
	{ 0xe0ab, 0x224831 },
	{ 0xe0ac, 0x224832 },
	{ 0xe0ad, 0x224833 },
	{ 0xe0ae, 0x224834 },
	{ 0xe0af, 0x224835 },
	{ 0xe0b0, 0x224836 },
	{ 0xe0b1, 0x224837 },
	{ 0xe0b2, 0x224838 },
	{ 0xe0b3, 0x224839 },
	{ 0xe0b4, 0x22483a },
	{ 0xe0b5, 0x22483b },
	{ 0xe0b6, 0x22483c },
	{ 0xe0b7, 0x22483d },
	{ 0xe0b8, 0x22483e },
	{ 0xe0b9, 0x22483f },
	{ 0xe0ba, 0x224840 },
	{ 0xe0bb, 0x224841 },
	{ 0xe0bc, 0x224842 },
	{ 0xe0bd, 0x224843 },
	{ 0xe0be, 0x224844 },
	{ 0xe0bf, 0x224845 },
	{ 0xe0c0, 0x224846 },
	{ 0xe0c1, 0x224847 },
	{ 0xe0c2, 0x224848 },
	{ 0xe0c3, 0x224849 },
	{ 0xe0c4, 0x22484a },
	{ 0xe0c5, 0x22484b },
	{ 0xe0c6, 0x22484c },
	{ 0xe0c7, 0x22484d },
	{ 0xe0c8, 0x22484e },
	{ 0xe0c9, 0x22484f },
	{ 0xe0ca, 0x224850 },
	{ 0xe0cb, 0x224851 },
	{ 0xe0cc, 0x224852 },
	{ 0xe0cd, 0x224853 },
	{ 0xe0ce, 0x224854 },
	{ 0xe0cf, 0x224855 },
	{ 0xe0d0, 0x224856 },
	{ 0xe0d1, 0x224857 },
	{ 0xe0d2, 0x224858 },
	{ 0xe0d3, 0x224859 },
	{ 0xe0d4, 0x22485a },
	{ 0xe0d5, 0x22485b },
	{ 0xe0d6, 0x22485c },
	{ 0xe0d7, 0x22485d },
	{ 0xe0d8, 0x22485e },
	{ 0xe0d9, 0x22485f },
	{ 0xe0da, 0x224860 },
	{ 0xe0db, 0x224861 },
	{ 0xe0dc, 0x224862 },
	{ 0xe0dd, 0x224863 },
	{ 0xe0de, 0x224864 },
	{ 0xe0df, 0x224865 },
	{ 0xe0e0, 0x224866 },
	{ 0xe0e1, 0x224867 },
	{ 0xe0e2, 0x224868 },
	{ 0xe0e3, 0x224869 },
	{ 0xe0e4, 0x22486a },
	{ 0xe0e5, 0x22486b },
	{ 0xe0e6, 0x22486c },
	{ 0xe0e7, 0x22486d },
	{ 0xe0e8, 0x22486e },
	{ 0xe0e9, 0x22486f },
	{ 0xe0ea, 0x224870 },
	{ 0xe0eb, 0x224871 },
	{ 0xe0ec, 0x224872 },
	{ 0xe0ed, 0x224873 },
	{ 0xe0ee, 0x224874 },
	{ 0xe0ef, 0x224875 },
	{ 0xe0f0, 0x224876 },
	{ 0xe0f1, 0x224877 },
	{ 0xe0f2, 0x224878 },
	{ 0xe0f3, 0x224879 },
	{ 0xe0f4, 0x22487a },
	{ 0xe0f5, 0x22487b },
	{ 0xe0f6, 0x22487c },
	{ 0xe0f7, 0x22487d },
	{ 0xe0f8, 0x22487e },
	{ 0xe0f9, 0x224921 },
	{ 0xe0fa, 0x224922 },
	{ 0xe0fb, 0x224923 },
	{ 0xe0fc, 0x224924 },
	{ 0xe0fd, 0x224925 },
	{ 0xe0fe, 0x224926 },
	{ 0xe140, 0x224927 },
	{ 0xe141, 0x224928 },
	{ 0xe142, 0x224929 },
	{ 0xe143, 0x22492a },
	{ 0xe144, 0x22492b },
	{ 0xe145, 0x22492c },
	{ 0xe146, 0x22492d },
	{ 0xe147, 0x22492e },
	{ 0xe148, 0x22492f },
	{ 0xe149, 0x224930 },
	{ 0xe14a, 0x224931 },
	{ 0xe14b, 0x224932 },
	{ 0xe14c, 0x224933 },
	{ 0xe14d, 0x224934 },
	{ 0xe14e, 0x224935 },
	{ 0xe14f, 0x224936 },
	{ 0xe150, 0x224937 },
	{ 0xe151, 0x224938 },
	{ 0xe152, 0x224939 },
	{ 0xe153, 0x22493a },
	{ 0xe154, 0x22493b },
	{ 0xe155, 0x22493c },
	{ 0xe156, 0x22493d },
	{ 0xe157, 0x22493e },
	{ 0xe158, 0x22493f },
	{ 0xe159, 0x224940 },
	{ 0xe15a, 0x224941 },
	{ 0xe15b, 0x224942 },
	{ 0xe15c, 0x224943 },
	{ 0xe15d, 0x224944 },
	{ 0xe15e, 0x224945 },
	{ 0xe15f, 0x224946 },
	{ 0xe160, 0x224947 },
	{ 0xe161, 0x224948 },
	{ 0xe162, 0x224949 },
	{ 0xe163, 0x22494a },
	{ 0xe164, 0x22494b },
	{ 0xe165, 0x22494c },
	{ 0xe166, 0x22494d },
	{ 0xe167, 0x22494e },
	{ 0xe168, 0x22494f },
	{ 0xe169, 0x224950 },
	{ 0xe16a, 0x224951 },
	{ 0xe16b, 0x224952 },
	{ 0xe16c, 0x224953 },
	{ 0xe16d, 0x224954 },
	{ 0xe16e, 0x224955 },
	{ 0xe16f, 0x224956 },
	{ 0xe170, 0x224957 },
	{ 0xe171, 0x224958 },
	{ 0xe172, 0x224959 },
	{ 0xe173, 0x22495a },
	{ 0xe174, 0x22495b },
	{ 0xe175, 0x22495c },
	{ 0xe176, 0x22495d },
	{ 0xe177, 0x22495e },
	{ 0xe178, 0x22495f },
	{ 0xe179, 0x224960 },
	{ 0xe17a, 0x224961 },
	{ 0xe17b, 0x224962 },
	{ 0xe17c, 0x224963 },
	{ 0xe17d, 0x224964 },
	{ 0xe17e, 0x224965 },
	{ 0xe1a1, 0x224966 },
	{ 0xe1a2, 0x224967 },
	{ 0xe1a3, 0x224968 },
	{ 0xe1a4, 0x224969 },
	{ 0xe1a5, 0x22496a },
	{ 0xe1a6, 0x22496b },
	{ 0xe1a7, 0x22496c },
	{ 0xe1a8, 0x22496d },
	{ 0xe1a9, 0x22496e },
	{ 0xe1aa, 0x22496f },
	{ 0xe1ab, 0x224970 },
	{ 0xe1ac, 0x224971 },
	{ 0xe1ad, 0x224972 },
	{ 0xe1ae, 0x224973 },
	{ 0xe1af, 0x224974 },
	{ 0xe1b0, 0x224975 },
	{ 0xe1b1, 0x224976 },
	{ 0xe1b2, 0x224977 },
	{ 0xe1b3, 0x224978 },
	{ 0xe1b4, 0x224979 },
	{ 0xe1b5, 0x22497a },
	{ 0xe1b6, 0x22497b },
	{ 0xe1b7, 0x22497c },
	{ 0xe1b8, 0x22497d },
	{ 0xe1b9, 0x22497e },
	{ 0xe1ba, 0x224a21 },
	{ 0xe1bb, 0x224a22 },
	{ 0xe1bc, 0x224a23 },
	{ 0xe1bd, 0x224a24 },
	{ 0xe1be, 0x224a25 },
	{ 0xe1bf, 0x224a26 },
	{ 0xe1c0, 0x224a27 },
	{ 0xe1c1, 0x224a28 },
	{ 0xe1c2, 0x224a29 },
	{ 0xe1c3, 0x224a2a },
	{ 0xe1c4, 0x224a2b },
	{ 0xe1c5, 0x224a2c },
	{ 0xe1c6, 0x224a2d },
	{ 0xe1c7, 0x224a2e },
	{ 0xe1c8, 0x224a2f },
	{ 0xe1c9, 0x224a30 },
	{ 0xe1ca, 0x224a31 },
	{ 0xe1cb, 0x224a32 },
	{ 0xe1cc, 0x224a33 },
	{ 0xe1cd, 0x224a34 },
	{ 0xe1ce, 0x224a35 },
	{ 0xe1cf, 0x224a36 },
	{ 0xe1d0, 0x224a37 },
	{ 0xe1d1, 0x224a38 },
	{ 0xe1d2, 0x224a39 },
	{ 0xe1d3, 0x224a3a },
	{ 0xe1d4, 0x224a3b },
	{ 0xe1d5, 0x224a3c },
	{ 0xe1d6, 0x224a3d },
	{ 0xe1d7, 0x224a3e },
	{ 0xe1d8, 0x224a3f },
	{ 0xe1d9, 0x224a40 },
	{ 0xe1da, 0x224a41 },
	{ 0xe1db, 0x224a42 },
	{ 0xe1dc, 0x224a43 },
	{ 0xe1dd, 0x224a44 },
	{ 0xe1de, 0x224a45 },
	{ 0xe1df, 0x224a46 },
	{ 0xe1e0, 0x224a47 },
	{ 0xe1e1, 0x224a48 },
	{ 0xe1e2, 0x224a49 },
	{ 0xe1e3, 0x224a4a },
	{ 0xe1e4, 0x224a4b },
	{ 0xe1e5, 0x224a4c },
	{ 0xe1e6, 0x224a4d },
	{ 0xe1e7, 0x224a4e },
	{ 0xe1e8, 0x224a4f },
	{ 0xe1e9, 0x224a50 },
	{ 0xe1ea, 0x224a51 },
	{ 0xe1eb, 0x224a52 },
	{ 0xe1ec, 0x224a53 },
	{ 0xe1ed, 0x224a54 },
	{ 0xe1ee, 0x224a55 },
	{ 0xe1ef, 0x224a56 },
	{ 0xe1f0, 0x224a57 },
	{ 0xe1f1, 0x224a58 },
	{ 0xe1f2, 0x224a59 },
	{ 0xe1f3, 0x224a5a },
	{ 0xe1f4, 0x224a5b },
	{ 0xe1f5, 0x224a5c },
	{ 0xe1f6, 0x224a5d },
	{ 0xe1f7, 0x224a5e },
	{ 0xe1f8, 0x224a5f },
	{ 0xe1f9, 0x224a60 },
	{ 0xe1fa, 0x224a61 },
	{ 0xe1fb, 0x224a62 },
	{ 0xe1fc, 0x224a63 },
	{ 0xe1fd, 0x224a64 },
	{ 0xe1fe, 0x224a65 },
	{ 0xe240, 0x224a66 },
	{ 0xe241, 0x224a67 },
	{ 0xe242, 0x224a68 },
	{ 0xe243, 0x224a69 },
	{ 0xe244, 0x224a6a },
	{ 0xe245, 0x224a6b },
	{ 0xe246, 0x224a6c },
	{ 0xe247, 0x224a6d },
	{ 0xe248, 0x224a6e },
	{ 0xe249, 0x224a6f },
	{ 0xe24a, 0x224a70 },
	{ 0xe24b, 0x224a71 },
	{ 0xe24c, 0x224a72 },
	{ 0xe24d, 0x224a73 },
	{ 0xe24e, 0x224a74 },
	{ 0xe24f, 0x224a75 },
	{ 0xe250, 0x224a76 },
	{ 0xe251, 0x224a77 },
	{ 0xe252, 0x224a78 },
	{ 0xe253, 0x224a79 },
	{ 0xe254, 0x224a7a },
	{ 0xe255, 0x224a7b },
	{ 0xe256, 0x224a7c },
	{ 0xe257, 0x224a7d },
	{ 0xe258, 0x224a7e },
	{ 0xe259, 0x224b21 },
	{ 0xe25a, 0x224b22 },
	{ 0xe25b, 0x224b23 },
	{ 0xe25c, 0x224b24 },
	{ 0xe25d, 0x224b25 },
	{ 0xe25e, 0x224b26 },
	{ 0xe25f, 0x224b27 },
	{ 0xe260, 0x224b28 },
	{ 0xe261, 0x224b29 },
	{ 0xe262, 0x224b2a },
	{ 0xe263, 0x224b2b },
	{ 0xe264, 0x224b2c },
	{ 0xe265, 0x224b2d },
	{ 0xe266, 0x224b2e },
	{ 0xe267, 0x224b2f },
	{ 0xe268, 0x224b30 },
	{ 0xe269, 0x224b31 },
	{ 0xe26a, 0x224b32 },
	{ 0xe26b, 0x224b33 },
	{ 0xe26c, 0x224b34 },
	{ 0xe26d, 0x224b35 },
	{ 0xe26e, 0x224b36 },
	{ 0xe26f, 0x224b37 },
	{ 0xe270, 0x224b38 },
	{ 0xe271, 0x224b39 },
	{ 0xe272, 0x224b3a },
	{ 0xe273, 0x224b3b },
	{ 0xe274, 0x224b3c },
	{ 0xe275, 0x224b3d },
	{ 0xe276, 0x224b3e },
	{ 0xe277, 0x224b3f },
	{ 0xe278, 0x224b40 },
	{ 0xe279, 0x224b41 },
	{ 0xe27a, 0x224b42 },
	{ 0xe27b, 0x224b43 },
	{ 0xe27c, 0x224b44 },
	{ 0xe27d, 0x224b45 },
	{ 0xe27e, 0x224b46 },
	{ 0xe2a1, 0x224b47 },
	{ 0xe2a2, 0x224b48 },
	{ 0xe2a3, 0x224b49 },
	{ 0xe2a4, 0x224b4a },
	{ 0xe2a5, 0x224b4b },
	{ 0xe2a6, 0x224b4c },
	{ 0xe2a7, 0x224b4d },
	{ 0xe2a8, 0x224b4e },
	{ 0xe2a9, 0x224b4f },
	{ 0xe2aa, 0x224b50 },
	{ 0xe2ab, 0x224b51 },
	{ 0xe2ac, 0x224b52 },
	{ 0xe2ad, 0x224b53 },
	{ 0xe2ae, 0x224b54 },
	{ 0xe2af, 0x224b55 },
	{ 0xe2b0, 0x224b56 },
	{ 0xe2b1, 0x224b57 },
	{ 0xe2b2, 0x224b58 },
	{ 0xe2b3, 0x224b59 },
	{ 0xe2b4, 0x224b5a },
	{ 0xe2b5, 0x224b5b },
	{ 0xe2b6, 0x224b5c },
	{ 0xe2b7, 0x224b5d },
	{ 0xe2b8, 0x224b5e },
	{ 0xe2b9, 0x224b5f },
	{ 0xe2ba, 0x224b60 },
	{ 0xe2bb, 0x224b61 },
	{ 0xe2bc, 0x224b62 },
	{ 0xe2bd, 0x224b63 },
	{ 0xe2be, 0x224b64 },
	{ 0xe2bf, 0x224b65 },
	{ 0xe2c0, 0x224b66 },
	{ 0xe2c1, 0x224b67 },
	{ 0xe2c2, 0x224b68 },
	{ 0xe2c3, 0x224b69 },
	{ 0xe2c4, 0x224b6a },
	{ 0xe2c5, 0x224b6b },
	{ 0xe2c6, 0x224b6c },
	{ 0xe2c7, 0x224b6d },
	{ 0xe2c8, 0x224b6e },
	{ 0xe2c9, 0x224b6f },
	{ 0xe2ca, 0x224b70 },
	{ 0xe2cb, 0x224b71 },
	{ 0xe2cc, 0x224b72 },
	{ 0xe2cd, 0x224b73 },
	{ 0xe2ce, 0x224b74 },
	{ 0xe2cf, 0x224b75 },
	{ 0xe2d0, 0x224b76 },
	{ 0xe2d1, 0x224b77 },
	{ 0xe2d2, 0x224b78 },
	{ 0xe2d3, 0x224b79 },
	{ 0xe2d4, 0x224b7a },
	{ 0xe2d5, 0x224b7b },
	{ 0xe2d6, 0x224b7c },
	{ 0xe2d7, 0x224b7d },
	{ 0xe2d8, 0x224b7e },
	{ 0xe2d9, 0x224c21 },
	{ 0xe2da, 0x224c22 },
	{ 0xe2db, 0x224c23 },
	{ 0xe2dc, 0x224c24 },
	{ 0xe2dd, 0x224c25 },
	{ 0xe2de, 0x224c26 },
	{ 0xe2df, 0x224c27 },
	{ 0xe2e0, 0x224c28 },
	{ 0xe2e1, 0x224c29 },
	{ 0xe2e2, 0x224c2a },
	{ 0xe2e3, 0x224c2b },
	{ 0xe2e4, 0x224c2c },
	{ 0xe2e5, 0x224c2d },
	{ 0xe2e6, 0x224c2e },
	{ 0xe2e7, 0x224c2f },
	{ 0xe2e8, 0x224c30 },
	{ 0xe2e9, 0x224c31 },
	{ 0xe2ea, 0x224c32 },
	{ 0xe2eb, 0x224c33 },
	{ 0xe2ec, 0x224c34 },
	{ 0xe2ed, 0x224c35 },
	{ 0xe2ee, 0x224c36 },
	{ 0xe2ef, 0x224c37 },
	{ 0xe2f0, 0x224c38 },
	{ 0xe2f1, 0x224c39 },
	{ 0xe2f2, 0x224c3a },
	{ 0xe2f3, 0x224c3b },
	{ 0xe2f4, 0x224c3c },
	{ 0xe2f5, 0x224c3d },
	{ 0xe2f6, 0x224c3e },
	{ 0xe2f7, 0x224c3f },
	{ 0xe2f8, 0x224c40 },
	{ 0xe2f9, 0x224c41 },
	{ 0xe2fa, 0x224c42 },
	{ 0xe2fb, 0x224c43 },
	{ 0xe2fc, 0x224c44 },
	{ 0xe2fd, 0x224c45 },
	{ 0xe2fe, 0x224c46 },
	{ 0xe340, 0x224c47 },
	{ 0xe341, 0x224c48 },
	{ 0xe342, 0x224c49 },
	{ 0xe343, 0x224c4a },
	{ 0xe344, 0x224c4b },
	{ 0xe345, 0x224c4c },
	{ 0xe346, 0x224c4d },
	{ 0xe347, 0x224c4e },
	{ 0xe348, 0x224c4f },
	{ 0xe349, 0x224c50 },
	{ 0xe34a, 0x224c51 },
	{ 0xe34b, 0x224c52 },
	{ 0xe34c, 0x224c53 },
	{ 0xe34d, 0x224c54 },
	{ 0xe34e, 0x224c55 },
	{ 0xe34f, 0x224c56 },
	{ 0xe350, 0x224c57 },
	{ 0xe351, 0x224c58 },
	{ 0xe352, 0x224c59 },
	{ 0xe353, 0x224c5a },
	{ 0xe354, 0x224c5b },
	{ 0xe355, 0x224c5c },
	{ 0xe356, 0x224c5d },
	{ 0xe357, 0x224c5e },
	{ 0xe358, 0x224c5f },
	{ 0xe359, 0x224c60 },
	{ 0xe35a, 0x224c61 },
	{ 0xe35b, 0x224c62 },
	{ 0xe35c, 0x224c63 },
	{ 0xe35d, 0x224c64 },
	{ 0xe35e, 0x224c65 },
	{ 0xe35f, 0x224c66 },
	{ 0xe360, 0x224c67 },
	{ 0xe361, 0x224c68 },
	{ 0xe362, 0x224c69 },
	{ 0xe363, 0x224c6a },
	{ 0xe364, 0x224c6b },
	{ 0xe365, 0x224c6c },
	{ 0xe366, 0x224c6d },
	{ 0xe367, 0x224c6e },
	{ 0xe368, 0x224c6f },
	{ 0xe369, 0x224c70 },
	{ 0xe36a, 0x224c71 },
	{ 0xe36b, 0x224c72 },
	{ 0xe36c, 0x224c73 },
	{ 0xe36d, 0x224c74 },
	{ 0xe36e, 0x224c75 },
	{ 0xe36f, 0x224c76 },
	{ 0xe370, 0x224c77 },
	{ 0xe371, 0x224c78 },
	{ 0xe372, 0x224c79 },
	{ 0xe373, 0x224c7a },
	{ 0xe374, 0x224c7b },
	{ 0xe375, 0x224c7c },
	{ 0xe376, 0x224c7d },
	{ 0xe377, 0x224c7e },
	{ 0xe378, 0x224d21 },
	{ 0xe379, 0x224d22 },
	{ 0xe37a, 0x224d23 },
	{ 0xe37b, 0x224d24 },
	{ 0xe37c, 0x224d25 },
	{ 0xe37d, 0x224d26 },
	{ 0xe37e, 0x224d27 },
	{ 0xe3a1, 0x224d28 },
	{ 0xe3a2, 0x224d29 },
	{ 0xe3a3, 0x224d2a },
	{ 0xe3a4, 0x224d2b },
	{ 0xe3a5, 0x224d2c },
	{ 0xe3a6, 0x224d2d },
	{ 0xe3a7, 0x224d2e },
	{ 0xe3a8, 0x224d2f },
	{ 0xe3a9, 0x224d30 },
	{ 0xe3aa, 0x224d31 },
	{ 0xe3ab, 0x224d32 },
	{ 0xe3ac, 0x224d33 },
	{ 0xe3ad, 0x224d34 },
	{ 0xe3ae, 0x224d35 },
	{ 0xe3af, 0x224d36 },
	{ 0xe3b0, 0x224d37 },
	{ 0xe3b1, 0x224d38 },
	{ 0xe3b2, 0x224d39 },
	{ 0xe3b3, 0x224d3a },
	{ 0xe3b4, 0x224d3b },
	{ 0xe3b5, 0x224d3c },
	{ 0xe3b6, 0x224d3d },
	{ 0xe3b7, 0x224d3e },
	{ 0xe3b8, 0x224d3f },
	{ 0xe3b9, 0x224d40 },
	{ 0xe3ba, 0x224d41 },
	{ 0xe3bb, 0x224d42 },
	{ 0xe3bc, 0x224d43 },
	{ 0xe3bd, 0x224d44 },
	{ 0xe3be, 0x224d45 },
	{ 0xe3bf, 0x224d46 },
	{ 0xe3c0, 0x224d47 },
	{ 0xe3c1, 0x224d48 },
	{ 0xe3c2, 0x224d49 },
	{ 0xe3c3, 0x224d4a },
	{ 0xe3c4, 0x224d4b },
	{ 0xe3c5, 0x224d4c },
	{ 0xe3c6, 0x224d4d },
	{ 0xe3c7, 0x224d4e },
	{ 0xe3c8, 0x224d4f },
	{ 0xe3c9, 0x224d50 },
	{ 0xe3ca, 0x224d51 },
	{ 0xe3cb, 0x224d52 },
	{ 0xe3cc, 0x224d53 },
	{ 0xe3cd, 0x224d54 },
	{ 0xe3ce, 0x224d55 },
	{ 0xe3cf, 0x224d56 },
	{ 0xe3d0, 0x224d57 },
	{ 0xe3d1, 0x224d58 },
	{ 0xe3d2, 0x224d59 },
	{ 0xe3d3, 0x224d5a },
	{ 0xe3d4, 0x224d5b },
	{ 0xe3d5, 0x224d5c },
	{ 0xe3d6, 0x224d5d },
	{ 0xe3d7, 0x224d5e },
	{ 0xe3d8, 0x224d5f },
	{ 0xe3d9, 0x224d60 },
	{ 0xe3da, 0x224d61 },
	{ 0xe3db, 0x224d62 },
	{ 0xe3dc, 0x224d63 },
	{ 0xe3dd, 0x224d64 },
	{ 0xe3de, 0x224d65 },
	{ 0xe3df, 0x224d66 },
	{ 0xe3e0, 0x224d67 },
	{ 0xe3e1, 0x224d68 },
	{ 0xe3e2, 0x224d69 },
	{ 0xe3e3, 0x224d6a },
	{ 0xe3e4, 0x224d6b },
	{ 0xe3e5, 0x224d6c },
	{ 0xe3e6, 0x224d6d },
	{ 0xe3e7, 0x224d6e },
	{ 0xe3e8, 0x224d6f },
	{ 0xe3e9, 0x224d70 },
	{ 0xe3ea, 0x224d71 },
	{ 0xe3eb, 0x224d72 },
	{ 0xe3ec, 0x224d73 },
	{ 0xe3ed, 0x224d74 },
	{ 0xe3ee, 0x224d75 },
	{ 0xe3ef, 0x224d76 },
	{ 0xe3f0, 0x224d77 },
	{ 0xe3f1, 0x224d78 },
	{ 0xe3f2, 0x224d79 },
	{ 0xe3f3, 0x224d7a },
	{ 0xe3f4, 0x224d7b },
	{ 0xe3f5, 0x224d7c },
	{ 0xe3f6, 0x224d7d },
	{ 0xe3f7, 0x224d7e },
	{ 0xe3f8, 0x224e21 },
	{ 0xe3f9, 0x224e22 },
	{ 0xe3fa, 0x224e23 },
	{ 0xe3fb, 0x224e24 },
	{ 0xe3fc, 0x224e25 },
	{ 0xe3fd, 0x224e26 },
	{ 0xe3fe, 0x224e27 },
	{ 0xe440, 0x224e28 },
	{ 0xe441, 0x224e29 },
	{ 0xe442, 0x224e2a },
	{ 0xe443, 0x224e2b },
	{ 0xe444, 0x224e2c },
	{ 0xe445, 0x224e2d },
	{ 0xe446, 0x224e2e },
	{ 0xe447, 0x224e2f },
	{ 0xe448, 0x224e30 },
	{ 0xe449, 0x224e31 },
	{ 0xe44a, 0x224e32 },
	{ 0xe44b, 0x224e33 },
	{ 0xe44c, 0x224e34 },
	{ 0xe44d, 0x224e35 },
	{ 0xe44e, 0x224e36 },
	{ 0xe44f, 0x224e37 },
	{ 0xe450, 0x224e38 },
	{ 0xe451, 0x224e39 },
	{ 0xe452, 0x224e3a },
	{ 0xe453, 0x224e3b },
	{ 0xe454, 0x224e3c },
	{ 0xe455, 0x224e3d },
	{ 0xe456, 0x224e3e },
	{ 0xe457, 0x224e3f },
	{ 0xe458, 0x224e40 },
	{ 0xe459, 0x224e41 },
	{ 0xe45a, 0x224e42 },
	{ 0xe45b, 0x224e43 },
	{ 0xe45c, 0x224e44 },
	{ 0xe45d, 0x224e45 },
	{ 0xe45e, 0x224e46 },
	{ 0xe45f, 0x224e47 },
	{ 0xe460, 0x224e48 },
	{ 0xe461, 0x224e49 },
	{ 0xe462, 0x224e4a },
	{ 0xe463, 0x224e4b },
	{ 0xe464, 0x224e4c },
	{ 0xe465, 0x224e4d },
	{ 0xe466, 0x224e4e },
	{ 0xe467, 0x224e4f },
	{ 0xe468, 0x224e50 },
	{ 0xe469, 0x224e51 },
	{ 0xe46a, 0x224e52 },
	{ 0xe46b, 0x224e53 },
	{ 0xe46c, 0x224e54 },
	{ 0xe46d, 0x224e55 },
	{ 0xe46e, 0x224e56 },
	{ 0xe46f, 0x224e57 },
	{ 0xe470, 0x224e58 },
	{ 0xe471, 0x224e59 },
	{ 0xe472, 0x224e5a },
	{ 0xe473, 0x224e5b },
	{ 0xe474, 0x224e5c },
	{ 0xe475, 0x224e5d },
	{ 0xe476, 0x224e5e },
	{ 0xe477, 0x224e5f },
	{ 0xe478, 0x224e60 },
	{ 0xe479, 0x224e61 },
	{ 0xe47a, 0x224e62 },
	{ 0xe47b, 0x224e63 },
	{ 0xe47c, 0x224e64 },
	{ 0xe47d, 0x224e65 },
	{ 0xe47e, 0x224e66 },
	{ 0xe4a1, 0x224e67 },
	{ 0xe4a2, 0x224e68 },
	{ 0xe4a3, 0x224e69 },
	{ 0xe4a4, 0x224e6a },
	{ 0xe4a5, 0x224e6b },
	{ 0xe4a6, 0x224e6c },
	{ 0xe4a7, 0x224e6d },
	{ 0xe4a8, 0x224e6e },
	{ 0xe4a9, 0x224e6f },
	{ 0xe4aa, 0x224e70 },
	{ 0xe4ab, 0x224e71 },
	{ 0xe4ac, 0x224e72 },
	{ 0xe4ad, 0x224e73 },
	{ 0xe4ae, 0x224e74 },
	{ 0xe4af, 0x224e75 },
	{ 0xe4b0, 0x224e76 },
	{ 0xe4b1, 0x224e77 },
	{ 0xe4b2, 0x224e78 },
	{ 0xe4b3, 0x224e79 },
	{ 0xe4b4, 0x224e7a },
	{ 0xe4b5, 0x224e7b },
	{ 0xe4b6, 0x224e7c },
	{ 0xe4b7, 0x224e7d },
	{ 0xe4b8, 0x224e7e },
	{ 0xe4b9, 0x224f21 },
	{ 0xe4ba, 0x224f22 },
	{ 0xe4bb, 0x224f23 },
	{ 0xe4bc, 0x224f24 },
	{ 0xe4bd, 0x224f25 },
	{ 0xe4be, 0x224f26 },
	{ 0xe4bf, 0x224f27 },
	{ 0xe4c0, 0x224f28 },
	{ 0xe4c1, 0x224f29 },
	{ 0xe4c2, 0x224f2a },
	{ 0xe4c3, 0x224f2b },
	{ 0xe4c4, 0x224f2c },
	{ 0xe4c5, 0x224f2d },
	{ 0xe4c6, 0x224f2e },
	{ 0xe4c7, 0x224f2f },
	{ 0xe4c8, 0x224f30 },
	{ 0xe4c9, 0x224f31 },
	{ 0xe4ca, 0x224f32 },
	{ 0xe4cb, 0x224f33 },
	{ 0xe4cc, 0x224f34 },
	{ 0xe4cd, 0x224f35 },
	{ 0xe4ce, 0x224f36 },
	{ 0xe4cf, 0x224f37 },
	{ 0xe4d0, 0x224f38 },
	{ 0xe4d1, 0x224f39 },
	{ 0xe4d2, 0x224f3a },
	{ 0xe4d3, 0x224f3b },
	{ 0xe4d4, 0x224f3c },
	{ 0xe4d5, 0x224f3d },
	{ 0xe4d6, 0x224f3e },
	{ 0xe4d7, 0x224f3f },
	{ 0xe4d8, 0x224f40 },
	{ 0xe4d9, 0x224f41 },
	{ 0xe4da, 0x224f42 },
	{ 0xe4db, 0x224f43 },
	{ 0xe4dc, 0x224f44 },
	{ 0xe4dd, 0x224f45 },
	{ 0xe4de, 0x224f46 },
	{ 0xe4df, 0x224f47 },
	{ 0xe4e0, 0x224f48 },
	{ 0xe4e1, 0x224f49 },
	{ 0xe4e2, 0x224f4a },
	{ 0xe4e3, 0x224f4b },
	{ 0xe4e4, 0x224f4c },
	{ 0xe4e5, 0x224f4d },
	{ 0xe4e6, 0x224f4e },
	{ 0xe4e7, 0x224f4f },
	{ 0xe4e8, 0x224f50 },
	{ 0xe4e9, 0x224f51 },
	{ 0xe4ea, 0x224f52 },
	{ 0xe4eb, 0x224f53 },
	{ 0xe4ec, 0x224f54 },
	{ 0xe4ed, 0x224f55 },
	{ 0xe4ee, 0x224f56 },
	{ 0xe4ef, 0x224f57 },
	{ 0xe4f0, 0x224f58 },
	{ 0xe4f1, 0x224f59 },
	{ 0xe4f2, 0x224f5a },
	{ 0xe4f3, 0x224f5b },
	{ 0xe4f4, 0x224f5c },
	{ 0xe4f5, 0x224f5d },
	{ 0xe4f6, 0x224f5e },
	{ 0xe4f7, 0x224f5f },
	{ 0xe4f8, 0x224f60 },
	{ 0xe4f9, 0x224f61 },
	{ 0xe4fa, 0x224f62 },
	{ 0xe4fb, 0x224f63 },
	{ 0xe4fc, 0x224f64 },
	{ 0xe4fd, 0x224f65 },
	{ 0xe4fe, 0x224f66 },
	{ 0xe540, 0x224f67 },
	{ 0xe541, 0x224f68 },
	{ 0xe542, 0x224f69 },
	{ 0xe543, 0x224f6a },
	{ 0xe544, 0x224f6b },
	{ 0xe545, 0x224f6c },
	{ 0xe546, 0x224f6d },
	{ 0xe547, 0x224f6e },
	{ 0xe548, 0x224f6f },
	{ 0xe549, 0x224f70 },
	{ 0xe54a, 0x224f71 },
	{ 0xe54b, 0x224f72 },
	{ 0xe54c, 0x224f73 },
	{ 0xe54d, 0x224f74 },
	{ 0xe54e, 0x224f75 },
	{ 0xe54f, 0x224f76 },
	{ 0xe550, 0x224f77 },
	{ 0xe551, 0x224f78 },
	{ 0xe552, 0x224f79 },
	{ 0xe553, 0x224f7a },
	{ 0xe554, 0x224f7b },
	{ 0xe555, 0x224f7c },
	{ 0xe556, 0x224f7d },
	{ 0xe557, 0x224f7e },
	{ 0xe558, 0x225021 },
	{ 0xe559, 0x225022 },
	{ 0xe55a, 0x225023 },
	{ 0xe55b, 0x225024 },
	{ 0xe55c, 0x225025 },
	{ 0xe55d, 0x225026 },
	{ 0xe55e, 0x225027 },
	{ 0xe55f, 0x225028 },
	{ 0xe560, 0x225029 },
	{ 0xe561, 0x22502a },
	{ 0xe562, 0x22502b },
	{ 0xe563, 0x22502c },
	{ 0xe564, 0x22502d },
	{ 0xe565, 0x22502e },
	{ 0xe566, 0x22502f },
	{ 0xe567, 0x225030 },
	{ 0xe568, 0x225031 },
	{ 0xe569, 0x225032 },
	{ 0xe56a, 0x225033 },
	{ 0xe56b, 0x225034 },
	{ 0xe56c, 0x225035 },
	{ 0xe56d, 0x225036 },
	{ 0xe56e, 0x225037 },
	{ 0xe56f, 0x225038 },
	{ 0xe570, 0x225039 },
	{ 0xe571, 0x22503a },
	{ 0xe572, 0x22503b },
	{ 0xe573, 0x22503c },
	{ 0xe574, 0x22503d },
	{ 0xe575, 0x22503e },
	{ 0xe576, 0x22503f },
	{ 0xe577, 0x225040 },
	{ 0xe578, 0x225041 },
	{ 0xe579, 0x225042 },
	{ 0xe57a, 0x225043 },
	{ 0xe57b, 0x225044 },
	{ 0xe57c, 0x225045 },
	{ 0xe57d, 0x225046 },
	{ 0xe57e, 0x225047 },
	{ 0xe5a1, 0x225048 },
	{ 0xe5a2, 0x225049 },
	{ 0xe5a3, 0x22504a },
	{ 0xe5a4, 0x22504b },
	{ 0xe5a5, 0x22504c },
	{ 0xe5a6, 0x22504d },
	{ 0xe5a7, 0x22504e },
	{ 0xe5a8, 0x22504f },
	{ 0xe5a9, 0x225050 },
	{ 0xe5aa, 0x225051 },
	{ 0xe5ab, 0x225052 },
	{ 0xe5ac, 0x225053 },
	{ 0xe5ad, 0x225054 },
	{ 0xe5ae, 0x225055 },
	{ 0xe5af, 0x225056 },
	{ 0xe5b0, 0x225057 },
	{ 0xe5b1, 0x225058 },
	{ 0xe5b2, 0x225059 },
	{ 0xe5b3, 0x22505a },
	{ 0xe5b4, 0x22505b },
	{ 0xe5b5, 0x22505c },
	{ 0xe5b6, 0x22505d },
	{ 0xe5b7, 0x22505e },
	{ 0xe5b8, 0x22505f },
	{ 0xe5b9, 0x225060 },
	{ 0xe5ba, 0x225061 },
	{ 0xe5bb, 0x225062 },
	{ 0xe5bc, 0x225063 },
	{ 0xe5bd, 0x225064 },
	{ 0xe5be, 0x225065 },
	{ 0xe5bf, 0x225066 },
	{ 0xe5c0, 0x225067 },
	{ 0xe5c1, 0x225068 },
	{ 0xe5c2, 0x225069 },
	{ 0xe5c3, 0x22506a },
	{ 0xe5c4, 0x22506b },
	{ 0xe5c5, 0x22506c },
	{ 0xe5c6, 0x22506d },
	{ 0xe5c7, 0x22506e },
	{ 0xe5c8, 0x22506f },
	{ 0xe5c9, 0x225070 },
	{ 0xe5ca, 0x225071 },
	{ 0xe5cb, 0x225072 },
	{ 0xe5cc, 0x225073 },
	{ 0xe5cd, 0x225074 },
	{ 0xe5ce, 0x225075 },
	{ 0xe5cf, 0x225076 },
	{ 0xe5d0, 0x225077 },
	{ 0xe5d1, 0x225078 },
	{ 0xe5d2, 0x225079 },
	{ 0xe5d3, 0x22507a },
	{ 0xe5d4, 0x22507b },
	{ 0xe5d5, 0x22507c },
	{ 0xe5d6, 0x22507d },
	{ 0xe5d7, 0x22507e },
	{ 0xe5d8, 0x225121 },
	{ 0xe5d9, 0x225122 },
	{ 0xe5da, 0x225123 },
	{ 0xe5db, 0x225124 },
	{ 0xe5dc, 0x225125 },
	{ 0xe5dd, 0x225126 },
	{ 0xe5de, 0x225127 },
	{ 0xe5df, 0x225128 },
	{ 0xe5e0, 0x225129 },
	{ 0xe5e1, 0x22512a },
	{ 0xe5e2, 0x22512b },
	{ 0xe5e3, 0x22512c },
	{ 0xe5e4, 0x22512d },
	{ 0xe5e5, 0x22512e },
	{ 0xe5e6, 0x22512f },
	{ 0xe5e7, 0x225130 },
	{ 0xe5e8, 0x225131 },
	{ 0xe5e9, 0x225132 },
	{ 0xe5ea, 0x225133 },
	{ 0xe5eb, 0x225134 },
	{ 0xe5ec, 0x225135 },
	{ 0xe5ed, 0x225136 },
	{ 0xe5ee, 0x225137 },
	{ 0xe5ef, 0x225138 },
	{ 0xe5f0, 0x225139 },
	{ 0xe5f1, 0x22513a },
	{ 0xe5f2, 0x22513b },
	{ 0xe5f3, 0x22513c },
	{ 0xe5f4, 0x22513d },
	{ 0xe5f5, 0x22513e },
	{ 0xe5f6, 0x22513f },
	{ 0xe5f7, 0x225140 },
	{ 0xe5f8, 0x225141 },
	{ 0xe5f9, 0x225142 },
	{ 0xe5fa, 0x225143 },
	{ 0xe5fb, 0x225144 },
	{ 0xe5fc, 0x225145 },
	{ 0xe5fd, 0x225146 },
	{ 0xe5fe, 0x225147 },
	{ 0xe640, 0x225148 },
	{ 0xe641, 0x225149 },
	{ 0xe642, 0x22514a },
	{ 0xe643, 0x22514b },
	{ 0xe644, 0x22514c },
	{ 0xe645, 0x22514d },
	{ 0xe646, 0x22514e },
	{ 0xe647, 0x22514f },
	{ 0xe648, 0x225150 },
	{ 0xe649, 0x225151 },
	{ 0xe64a, 0x225152 },
	{ 0xe64b, 0x225153 },
	{ 0xe64c, 0x225154 },
	{ 0xe64d, 0x225155 },
	{ 0xe64e, 0x225156 },
	{ 0xe64f, 0x225157 },
	{ 0xe650, 0x225158 },
	{ 0xe651, 0x225159 },
	{ 0xe652, 0x22515a },
	{ 0xe653, 0x22515b },
	{ 0xe654, 0x22515c },
	{ 0xe655, 0x22515d },
	{ 0xe656, 0x22515e },
	{ 0xe657, 0x22515f },
	{ 0xe658, 0x225160 },
	{ 0xe659, 0x225161 },
	{ 0xe65a, 0x225162 },
	{ 0xe65b, 0x225163 },
	{ 0xe65c, 0x225164 },
	{ 0xe65d, 0x225165 },
	{ 0xe65e, 0x225166 },
	{ 0xe65f, 0x225167 },
	{ 0xe660, 0x225168 },
	{ 0xe661, 0x225169 },
	{ 0xe662, 0x22516a },
	{ 0xe663, 0x22516b },
	{ 0xe664, 0x22516c },
	{ 0xe665, 0x22516d },
	{ 0xe666, 0x22516e },
	{ 0xe667, 0x22516f },
	{ 0xe668, 0x225170 },
	{ 0xe669, 0x225171 },
	{ 0xe66a, 0x225172 },
	{ 0xe66b, 0x225173 },
	{ 0xe66c, 0x225174 },
	{ 0xe66d, 0x225175 },
	{ 0xe66e, 0x225176 },
	{ 0xe66f, 0x225177 },
	{ 0xe670, 0x225178 },
	{ 0xe671, 0x225179 },
	{ 0xe672, 0x22517a },
	{ 0xe673, 0x22517b },
	{ 0xe674, 0x22517c },
	{ 0xe675, 0x22517d },
	{ 0xe676, 0x22517e },
	{ 0xe677, 0x225221 },
	{ 0xe678, 0x225222 },
	{ 0xe679, 0x225223 },
	{ 0xe67a, 0x225224 },
	{ 0xe67b, 0x225225 },
	{ 0xe67c, 0x225226 },
	{ 0xe67d, 0x225227 },
	{ 0xe67e, 0x225228 },
	{ 0xe6a1, 0x225229 },
	{ 0xe6a2, 0x22522a },
	{ 0xe6a3, 0x22522b },
	{ 0xe6a4, 0x22522c },
	{ 0xe6a5, 0x22522d },
	{ 0xe6a6, 0x22522e },
	{ 0xe6a7, 0x22522f },
	{ 0xe6a8, 0x225230 },
	{ 0xe6a9, 0x225231 },
	{ 0xe6aa, 0x225232 },
	{ 0xe6ab, 0x225233 },
	{ 0xe6ac, 0x225234 },
	{ 0xe6ad, 0x225235 },
	{ 0xe6ae, 0x225236 },
	{ 0xe6af, 0x225237 },
	{ 0xe6b0, 0x225238 },
	{ 0xe6b1, 0x225239 },
	{ 0xe6b2, 0x22523a },
	{ 0xe6b3, 0x22523b },
	{ 0xe6b4, 0x22523c },
	{ 0xe6b5, 0x22523d },
	{ 0xe6b6, 0x22523e },
	{ 0xe6b7, 0x22523f },
	{ 0xe6b8, 0x225240 },
	{ 0xe6b9, 0x225241 },
	{ 0xe6ba, 0x225242 },
	{ 0xe6bb, 0x225243 },
	{ 0xe6bc, 0x225244 },
	{ 0xe6bd, 0x225245 },
	{ 0xe6be, 0x225246 },
	{ 0xe6bf, 0x225247 },
	{ 0xe6c0, 0x225248 },
	{ 0xe6c1, 0x225249 },
	{ 0xe6c2, 0x22524a },
	{ 0xe6c3, 0x22524b },
	{ 0xe6c4, 0x22524c },
	{ 0xe6c5, 0x22524d },
	{ 0xe6c6, 0x22524e },
	{ 0xe6c7, 0x22524f },
	{ 0xe6c8, 0x225250 },
	{ 0xe6c9, 0x225251 },
	{ 0xe6ca, 0x225252 },
	{ 0xe6cb, 0x225253 },
	{ 0xe6cc, 0x225254 },
	{ 0xe6cd, 0x225255 },
	{ 0xe6ce, 0x225256 },
	{ 0xe6cf, 0x225257 },
	{ 0xe6d0, 0x225258 },
	{ 0xe6d1, 0x225259 },
	{ 0xe6d2, 0x22525a },
	{ 0xe6d3, 0x22525b },
	{ 0xe6d4, 0x22525c },
	{ 0xe6d5, 0x22525d },
	{ 0xe6d6, 0x22525e },
	{ 0xe6d7, 0x22525f },
	{ 0xe6d8, 0x225260 },
	{ 0xe6d9, 0x225261 },
	{ 0xe6da, 0x225262 },
	{ 0xe6db, 0x225263 },
	{ 0xe6dc, 0x225264 },
	{ 0xe6dd, 0x225265 },
	{ 0xe6de, 0x225266 },
	{ 0xe6df, 0x225267 },
	{ 0xe6e0, 0x225268 },
	{ 0xe6e1, 0x225269 },
	{ 0xe6e2, 0x22526a },
	{ 0xe6e3, 0x22526b },
	{ 0xe6e4, 0x22526c },
	{ 0xe6e5, 0x22526d },
	{ 0xe6e6, 0x22526e },
	{ 0xe6e7, 0x22526f },
	{ 0xe6e8, 0x225270 },
	{ 0xe6e9, 0x225271 },
	{ 0xe6ea, 0x225272 },
	{ 0xe6eb, 0x225273 },
	{ 0xe6ec, 0x225274 },
	{ 0xe6ed, 0x225275 },
	{ 0xe6ee, 0x225276 },
	{ 0xe6ef, 0x225277 },
	{ 0xe6f0, 0x225278 },
	{ 0xe6f1, 0x225279 },
	{ 0xe6f2, 0x22527a },
	{ 0xe6f3, 0x22527b },
	{ 0xe6f4, 0x22527c },
	{ 0xe6f5, 0x22527d },
	{ 0xe6f6, 0x22527e },
	{ 0xe6f7, 0x225321 },
	{ 0xe6f8, 0x225322 },
	{ 0xe6f9, 0x225323 },
	{ 0xe6fa, 0x225324 },
	{ 0xe6fb, 0x225325 },
	{ 0xe6fc, 0x225326 },
	{ 0xe6fd, 0x225327 },
	{ 0xe6fe, 0x225328 },
	{ 0xe740, 0x225329 },
	{ 0xe741, 0x22532a },
	{ 0xe742, 0x22532b },
	{ 0xe743, 0x22532c },
	{ 0xe744, 0x22532d },
	{ 0xe745, 0x22532e },
	{ 0xe746, 0x22532f },
	{ 0xe747, 0x225330 },
	{ 0xe748, 0x225331 },
	{ 0xe749, 0x225332 },
	{ 0xe74a, 0x225333 },
	{ 0xe74b, 0x225334 },
	{ 0xe74c, 0x225335 },
	{ 0xe74d, 0x225336 },
	{ 0xe74e, 0x225337 },
	{ 0xe74f, 0x225338 },
	{ 0xe750, 0x225339 },
	{ 0xe751, 0x22533a },
	{ 0xe752, 0x22533b },
	{ 0xe753, 0x22533c },
	{ 0xe754, 0x22533d },
	{ 0xe755, 0x22533e },
	{ 0xe756, 0x22533f },
	{ 0xe757, 0x225340 },
	{ 0xe758, 0x225341 },
	{ 0xe759, 0x225342 },
	{ 0xe75a, 0x225343 },
	{ 0xe75b, 0x225344 },
	{ 0xe75c, 0x225345 },
	{ 0xe75d, 0x225346 },
	{ 0xe75e, 0x225347 },
	{ 0xe75f, 0x225348 },
	{ 0xe760, 0x225349 },
	{ 0xe761, 0x22534a },
	{ 0xe762, 0x22534b },
	{ 0xe763, 0x22534c },
	{ 0xe764, 0x22534d },
	{ 0xe765, 0x22534e },
	{ 0xe766, 0x22534f },
	{ 0xe767, 0x225350 },
	{ 0xe768, 0x225351 },
	{ 0xe769, 0x225352 },
	{ 0xe76a, 0x225353 },
	{ 0xe76b, 0x225354 },
	{ 0xe76c, 0x225355 },
	{ 0xe76d, 0x225356 },
	{ 0xe76e, 0x225357 },
	{ 0xe76f, 0x225358 },
	{ 0xe770, 0x225359 },
	{ 0xe771, 0x22535a },
	{ 0xe772, 0x22535b },
	{ 0xe773, 0x22535c },
	{ 0xe774, 0x22535d },
	{ 0xe775, 0x22535e },
	{ 0xe776, 0x22535f },
	{ 0xe777, 0x225360 },
	{ 0xe778, 0x225361 },
	{ 0xe779, 0x225362 },
	{ 0xe77a, 0x225363 },
	{ 0xe77b, 0x225364 },
	{ 0xe77c, 0x225365 },
	{ 0xe77d, 0x225366 },
	{ 0xe77e, 0x225367 },
	{ 0xe7a1, 0x225368 },
	{ 0xe7a2, 0x225369 },
	{ 0xe7a3, 0x22536a },
	{ 0xe7a4, 0x22536b },
	{ 0xe7a5, 0x22536c },
	{ 0xe7a6, 0x22536d },
	{ 0xe7a7, 0x22536e },
	{ 0xe7a8, 0x22536f },
	{ 0xe7a9, 0x225370 },
	{ 0xe7aa, 0x225371 },
	{ 0xe7ab, 0x225372 },
	{ 0xe7ac, 0x225373 },
	{ 0xe7ad, 0x225374 },
	{ 0xe7ae, 0x225375 },
	{ 0xe7af, 0x225376 },
	{ 0xe7b0, 0x225377 },
	{ 0xe7b1, 0x225378 },
	{ 0xe7b2, 0x225379 },
	{ 0xe7b3, 0x22537a },
	{ 0xe7b4, 0x22537b },
	{ 0xe7b5, 0x22537c },
	{ 0xe7b6, 0x22537d },
	{ 0xe7b7, 0x22537e },
	{ 0xe7b8, 0x225421 },
	{ 0xe7b9, 0x225422 },
	{ 0xe7ba, 0x225423 },
	{ 0xe7bb, 0x225424 },
	{ 0xe7bc, 0x225425 },
	{ 0xe7bd, 0x225426 },
	{ 0xe7be, 0x225427 },
	{ 0xe7bf, 0x225428 },
	{ 0xe7c0, 0x225429 },
	{ 0xe7c1, 0x22542a },
	{ 0xe7c2, 0x22542b },
	{ 0xe7c3, 0x22542c },
	{ 0xe7c4, 0x22542d },
	{ 0xe7c5, 0x22542e },
	{ 0xe7c6, 0x22542f },
	{ 0xe7c7, 0x225430 },
	{ 0xe7c8, 0x225431 },
	{ 0xe7c9, 0x225432 },
	{ 0xe7ca, 0x225433 },
	{ 0xe7cb, 0x225434 },
	{ 0xe7cc, 0x225435 },
	{ 0xe7cd, 0x225436 },
	{ 0xe7ce, 0x225437 },
	{ 0xe7cf, 0x225438 },
	{ 0xe7d0, 0x225439 },
	{ 0xe7d1, 0x22543a },
	{ 0xe7d2, 0x22543b },
	{ 0xe7d3, 0x22543c },
	{ 0xe7d4, 0x22543d },
	{ 0xe7d5, 0x22543e },
	{ 0xe7d6, 0x22543f },
	{ 0xe7d7, 0x225440 },
	{ 0xe7d8, 0x225441 },
	{ 0xe7d9, 0x225442 },
	{ 0xe7da, 0x225443 },
	{ 0xe7db, 0x225444 },
	{ 0xe7dc, 0x225445 },
	{ 0xe7dd, 0x225446 },
	{ 0xe7de, 0x225447 },
	{ 0xe7df, 0x225448 },
	{ 0xe7e0, 0x225449 },
	{ 0xe7e1, 0x22544a },
	{ 0xe7e2, 0x22544b },
	{ 0xe7e3, 0x22544c },
	{ 0xe7e4, 0x22544d },
	{ 0xe7e5, 0x22544e },
	{ 0xe7e6, 0x22544f },
	{ 0xe7e7, 0x225450 },
	{ 0xe7e8, 0x225451 },
	{ 0xe7e9, 0x225452 },
	{ 0xe7ea, 0x225453 },
	{ 0xe7eb, 0x225454 },
	{ 0xe7ec, 0x225455 },
	{ 0xe7ed, 0x225456 },
	{ 0xe7ee, 0x225457 },
	{ 0xe7ef, 0x225458 },
	{ 0xe7f0, 0x225459 },
	{ 0xe7f1, 0x22545a },
	{ 0xe7f2, 0x22545b },
	{ 0xe7f3, 0x22545c },
	{ 0xe7f4, 0x22545d },
	{ 0xe7f5, 0x22545e },
	{ 0xe7f6, 0x22545f },
	{ 0xe7f7, 0x225460 },
	{ 0xe7f8, 0x225461 },
	{ 0xe7f9, 0x225462 },
	{ 0xe7fa, 0x225463 },
	{ 0xe7fb, 0x225464 },
	{ 0xe7fc, 0x225465 },
	{ 0xe7fd, 0x225466 },
	{ 0xe7fe, 0x225467 },
	{ 0xe840, 0x225468 },
	{ 0xe841, 0x225469 },
	{ 0xe842, 0x22546a },
	{ 0xe843, 0x22546b },
	{ 0xe844, 0x22546c },
	{ 0xe845, 0x22546d },
	{ 0xe846, 0x22546e },
	{ 0xe847, 0x22546f },
	{ 0xe848, 0x225470 },
	{ 0xe849, 0x225471 },
	{ 0xe84a, 0x225472 },
	{ 0xe84b, 0x225473 },
	{ 0xe84c, 0x225474 },
	{ 0xe84d, 0x225475 },
	{ 0xe84e, 0x225476 },
	{ 0xe84f, 0x225477 },
	{ 0xe850, 0x225478 },
	{ 0xe851, 0x225479 },
	{ 0xe852, 0x22547a },
	{ 0xe853, 0x22547b },
	{ 0xe854, 0x22547c },
	{ 0xe855, 0x22547d },
	{ 0xe856, 0x22547e },
	{ 0xe857, 0x225521 },
	{ 0xe858, 0x225522 },
	{ 0xe859, 0x225523 },
	{ 0xe85a, 0x225524 },
	{ 0xe85b, 0x225525 },
	{ 0xe85c, 0x225526 },
	{ 0xe85d, 0x225527 },
	{ 0xe85e, 0x225528 },
	{ 0xe85f, 0x225529 },
	{ 0xe860, 0x22552a },
	{ 0xe861, 0x22552b },
	{ 0xe862, 0x22552c },
	{ 0xe863, 0x22552d },
	{ 0xe864, 0x22552e },
	{ 0xe865, 0x22552f },
	{ 0xe866, 0x225530 },
	{ 0xe867, 0x225531 },
	{ 0xe868, 0x225532 },
	{ 0xe869, 0x225533 },
	{ 0xe86a, 0x225534 },
	{ 0xe86b, 0x225535 },
	{ 0xe86c, 0x225536 },
	{ 0xe86d, 0x225537 },
	{ 0xe86e, 0x225538 },
	{ 0xe86f, 0x225539 },
	{ 0xe870, 0x22553a },
	{ 0xe871, 0x22553b },
	{ 0xe872, 0x22553c },
	{ 0xe873, 0x22553d },
	{ 0xe874, 0x22553e },
	{ 0xe875, 0x22553f },
	{ 0xe876, 0x225540 },
	{ 0xe877, 0x225541 },
	{ 0xe878, 0x225542 },
	{ 0xe879, 0x225543 },
	{ 0xe87a, 0x225544 },
	{ 0xe87b, 0x225545 },
	{ 0xe87c, 0x225546 },
	{ 0xe87d, 0x225547 },
	{ 0xe87e, 0x225548 },
	{ 0xe8a1, 0x225549 },
	{ 0xe8a2, 0x22554a },
	{ 0xe8a3, 0x22554c },
	{ 0xe8a4, 0x22554d },
	{ 0xe8a5, 0x22554e },
	{ 0xe8a6, 0x22554f },
	{ 0xe8a7, 0x225550 },
	{ 0xe8a8, 0x225551 },
	{ 0xe8a9, 0x225552 },
	{ 0xe8aa, 0x225553 },
	{ 0xe8ab, 0x225554 },
	{ 0xe8ac, 0x225555 },
	{ 0xe8ad, 0x225556 },
	{ 0xe8ae, 0x225557 },
	{ 0xe8af, 0x225558 },
	{ 0xe8b0, 0x225559 },
	{ 0xe8b1, 0x22555a },
	{ 0xe8b2, 0x22555b },
	{ 0xe8b3, 0x22555c },
	{ 0xe8b4, 0x22555d },
	{ 0xe8b5, 0x22555e },
	{ 0xe8b6, 0x22555f },
	{ 0xe8b7, 0x225560 },
	{ 0xe8b8, 0x225561 },
	{ 0xe8b9, 0x225562 },
	{ 0xe8ba, 0x225563 },
	{ 0xe8bb, 0x225564 },
	{ 0xe8bc, 0x225565 },
	{ 0xe8bd, 0x225566 },
	{ 0xe8be, 0x225567 },
	{ 0xe8bf, 0x225568 },
	{ 0xe8c0, 0x225569 },
	{ 0xe8c1, 0x22556a },
	{ 0xe8c2, 0x22556b },
	{ 0xe8c3, 0x22556c },
	{ 0xe8c4, 0x22556d },
	{ 0xe8c5, 0x22556e },
	{ 0xe8c6, 0x22556f },
	{ 0xe8c7, 0x225570 },
	{ 0xe8c8, 0x225571 },
	{ 0xe8c9, 0x225572 },
	{ 0xe8ca, 0x225573 },
	{ 0xe8cb, 0x225574 },
	{ 0xe8cc, 0x225575 },
	{ 0xe8cd, 0x225576 },
	{ 0xe8ce, 0x225577 },
	{ 0xe8cf, 0x225578 },
	{ 0xe8d0, 0x225579 },
	{ 0xe8d1, 0x22557a },
	{ 0xe8d2, 0x22557b },
	{ 0xe8d3, 0x22557c },
	{ 0xe8d4, 0x22557d },
	{ 0xe8d5, 0x22557e },
	{ 0xe8d6, 0x225621 },
	{ 0xe8d7, 0x225622 },
	{ 0xe8d8, 0x225623 },
	{ 0xe8d9, 0x225624 },
	{ 0xe8da, 0x225625 },
	{ 0xe8db, 0x225626 },
	{ 0xe8dc, 0x225627 },
	{ 0xe8dd, 0x225628 },
	{ 0xe8de, 0x225629 },
	{ 0xe8df, 0x22562a },
	{ 0xe8e0, 0x22562b },
	{ 0xe8e1, 0x22562c },
	{ 0xe8e2, 0x22562d },
	{ 0xe8e3, 0x22562e },
	{ 0xe8e4, 0x22562f },
	{ 0xe8e5, 0x225630 },
	{ 0xe8e6, 0x225631 },
	{ 0xe8e7, 0x225632 },
	{ 0xe8e8, 0x225633 },
	{ 0xe8e9, 0x225634 },
	{ 0xe8ea, 0x225635 },
	{ 0xe8eb, 0x225636 },
	{ 0xe8ec, 0x225637 },
	{ 0xe8ed, 0x225638 },
	{ 0xe8ee, 0x225639 },
	{ 0xe8ef, 0x22563a },
	{ 0xe8f0, 0x22563b },
	{ 0xe8f1, 0x22563c },
	{ 0xe8f2, 0x22563d },
	{ 0xe8f3, 0x22563e },
	{ 0xe8f4, 0x22563f },
	{ 0xe8f5, 0x225640 },
	{ 0xe8f6, 0x225641 },
	{ 0xe8f7, 0x225642 },
	{ 0xe8f8, 0x225643 },
	{ 0xe8f9, 0x225644 },
	{ 0xe8fa, 0x225645 },
	{ 0xe8fb, 0x225646 },
	{ 0xe8fc, 0x225647 },
	{ 0xe8fd, 0x225648 },
	{ 0xe8fe, 0x225649 },
	{ 0xe940, 0x22564a },
	{ 0xe941, 0x22564b },
	{ 0xe942, 0x22564c },
	{ 0xe943, 0x22564d },
	{ 0xe944, 0x22564e },
	{ 0xe945, 0x22564f },
	{ 0xe946, 0x225650 },
	{ 0xe947, 0x225651 },
	{ 0xe948, 0x225652 },
	{ 0xe949, 0x225653 },
	{ 0xe94a, 0x225654 },
	{ 0xe94b, 0x225655 },
	{ 0xe94c, 0x225656 },
	{ 0xe94d, 0x225657 },
	{ 0xe94e, 0x225658 },
	{ 0xe94f, 0x225659 },
	{ 0xe950, 0x22565a },
	{ 0xe951, 0x22565b },
	{ 0xe952, 0x22565c },
	{ 0xe953, 0x22565d },
	{ 0xe954, 0x22565e },
	{ 0xe955, 0x22565f },
	{ 0xe956, 0x225660 },
	{ 0xe957, 0x225661 },
	{ 0xe958, 0x225662 },
	{ 0xe959, 0x225663 },
	{ 0xe95a, 0x225664 },
	{ 0xe95b, 0x225665 },
	{ 0xe95c, 0x225666 },
	{ 0xe95d, 0x225667 },
	{ 0xe95e, 0x225668 },
	{ 0xe95f, 0x225669 },
	{ 0xe960, 0x22566a },
	{ 0xe961, 0x22566b },
	{ 0xe962, 0x22566c },
	{ 0xe963, 0x22566d },
	{ 0xe964, 0x22566e },
	{ 0xe965, 0x22566f },
	{ 0xe966, 0x225670 },
	{ 0xe967, 0x225671 },
	{ 0xe968, 0x225672 },
	{ 0xe969, 0x225673 },
	{ 0xe96a, 0x225674 },
	{ 0xe96b, 0x225675 },
	{ 0xe96c, 0x225676 },
	{ 0xe96d, 0x225677 },
	{ 0xe96e, 0x225678 },
	{ 0xe96f, 0x225679 },
	{ 0xe970, 0x22567a },
	{ 0xe971, 0x22567b },
	{ 0xe972, 0x22567c },
	{ 0xe973, 0x22567d },
	{ 0xe974, 0x22567e },
	{ 0xe975, 0x225721 },
	{ 0xe976, 0x225723 },
	{ 0xe977, 0x225724 },
	{ 0xe978, 0x225725 },
	{ 0xe979, 0x225726 },
	{ 0xe97a, 0x225727 },
	{ 0xe97b, 0x225728 },
	{ 0xe97c, 0x225729 },
	{ 0xe97d, 0x22572a },
	{ 0xe97e, 0x22572b },
	{ 0xe9a1, 0x22572c },
	{ 0xe9a2, 0x22572d },
	{ 0xe9a3, 0x22572e },
	{ 0xe9a4, 0x22572f },
	{ 0xe9a5, 0x225730 },
	{ 0xe9a6, 0x225731 },
	{ 0xe9a7, 0x225732 },
	{ 0xe9a8, 0x225733 },
	{ 0xe9a9, 0x225734 },
	{ 0xe9aa, 0x225735 },
	{ 0xe9ab, 0x225736 },
	{ 0xe9ac, 0x225737 },
	{ 0xe9ad, 0x225738 },
	{ 0xe9ae, 0x225739 },
	{ 0xe9af, 0x22573a },
	{ 0xe9b0, 0x22573b },
	{ 0xe9b1, 0x22573c },
	{ 0xe9b2, 0x22573d },
	{ 0xe9b3, 0x22573e },
	{ 0xe9b4, 0x22573f },
	{ 0xe9b5, 0x225740 },
	{ 0xe9b6, 0x225741 },
	{ 0xe9b7, 0x225742 },
	{ 0xe9b8, 0x225743 },
	{ 0xe9b9, 0x225744 },
	{ 0xe9ba, 0x225745 },
	{ 0xe9bb, 0x225746 },
	{ 0xe9bc, 0x225747 },
	{ 0xe9bd, 0x225748 },
	{ 0xe9be, 0x225749 },
	{ 0xe9bf, 0x22574a },
	{ 0xe9c0, 0x22574b },
	{ 0xe9c1, 0x22574c },
	{ 0xe9c2, 0x22574d },
	{ 0xe9c3, 0x22574e },
	{ 0xe9c4, 0x22574f },
	{ 0xe9c5, 0x225750 },
	{ 0xe9c6, 0x225751 },
	{ 0xe9c7, 0x225752 },
	{ 0xe9c8, 0x225753 },
	{ 0xe9c9, 0x225754 },
	{ 0xe9ca, 0x225755 },
	{ 0xe9cb, 0x225756 },
	{ 0xe9cc, 0x225757 },
	{ 0xe9cd, 0x225758 },
	{ 0xe9ce, 0x225759 },
	{ 0xe9cf, 0x22575a },
	{ 0xe9d0, 0x22575b },
	{ 0xe9d1, 0x22575c },
	{ 0xe9d2, 0x22575d },
	{ 0xe9d3, 0x22575e },
	{ 0xe9d4, 0x22575f },
	{ 0xe9d5, 0x225760 },
	{ 0xe9d6, 0x225761 },
	{ 0xe9d7, 0x225762 },
	{ 0xe9d8, 0x225763 },
	{ 0xe9d9, 0x225764 },
	{ 0xe9da, 0x225765 },
	{ 0xe9db, 0x225766 },
	{ 0xe9dc, 0x225767 },
	{ 0xe9dd, 0x225768 },
	{ 0xe9de, 0x225769 },
	{ 0xe9df, 0x22576a },
	{ 0xe9e0, 0x22576b },
	{ 0xe9e1, 0x22576c },
	{ 0xe9e2, 0x22576d },
	{ 0xe9e3, 0x22576e },
	{ 0xe9e4, 0x22576f },
	{ 0xe9e5, 0x225770 },
	{ 0xe9e6, 0x225771 },
	{ 0xe9e7, 0x225772 },
	{ 0xe9e8, 0x225773 },
	{ 0xe9e9, 0x225774 },
	{ 0xe9ea, 0x225775 },
	{ 0xe9eb, 0x225776 },
	{ 0xe9ec, 0x225777 },
	{ 0xe9ed, 0x225778 },
	{ 0xe9ee, 0x225779 },
	{ 0xe9ef, 0x22577a },
	{ 0xe9f0, 0x22577b },
	{ 0xe9f1, 0x22577c },
	{ 0xe9f2, 0x22577d },
	{ 0xe9f3, 0x22577e },
	{ 0xe9f4, 0x225821 },
	{ 0xe9f5, 0x225822 },
	{ 0xe9f6, 0x225823 },
	{ 0xe9f7, 0x225824 },
	{ 0xe9f8, 0x225825 },
	{ 0xe9f9, 0x225826 },
	{ 0xe9fa, 0x225827 },
	{ 0xe9fb, 0x225828 },
	{ 0xe9fc, 0x225829 },
	{ 0xe9fd, 0x22582a },
	{ 0xe9fe, 0x22582b },
	{ 0xea40, 0x22582c },
	{ 0xea41, 0x22582d },
	{ 0xea42, 0x22582e },
	{ 0xea43, 0x22582f },
	{ 0xea44, 0x225830 },
	{ 0xea45, 0x225831 },
	{ 0xea46, 0x225832 },
	{ 0xea47, 0x225833 },
	{ 0xea48, 0x225834 },
	{ 0xea49, 0x225835 },
	{ 0xea4a, 0x225836 },
	{ 0xea4b, 0x225837 },
	{ 0xea4c, 0x225838 },
	{ 0xea4d, 0x225839 },
	{ 0xea4e, 0x22583a },
	{ 0xea4f, 0x22583b },
	{ 0xea50, 0x22583c },
	{ 0xea51, 0x22583d },
	{ 0xea52, 0x22583e },
	{ 0xea53, 0x22583f },
	{ 0xea54, 0x225840 },
	{ 0xea55, 0x225841 },
	{ 0xea56, 0x225842 },
	{ 0xea57, 0x225843 },
	{ 0xea58, 0x225844 },
	{ 0xea59, 0x225845 },
	{ 0xea5a, 0x225846 },
	{ 0xea5b, 0x225847 },
	{ 0xea5c, 0x225848 },
	{ 0xea5d, 0x225849 },
	{ 0xea5e, 0x22584a },
	{ 0xea5f, 0x22584b },
	{ 0xea60, 0x22584c },
	{ 0xea61, 0x22584d },
	{ 0xea62, 0x22584e },
	{ 0xea63, 0x22584f },
	{ 0xea64, 0x225850 },
	{ 0xea65, 0x225851 },
	{ 0xea66, 0x225852 },
	{ 0xea67, 0x225853 },
	{ 0xea68, 0x225854 },
	{ 0xea69, 0x225855 },
	{ 0xea6a, 0x225856 },
	{ 0xea6b, 0x225857 },
	{ 0xea6c, 0x225858 },
	{ 0xea6d, 0x225859 },
	{ 0xea6e, 0x22585a },
	{ 0xea6f, 0x22585b },
	{ 0xea70, 0x22585c },
	{ 0xea71, 0x22585d },
	{ 0xea72, 0x22585e },
	{ 0xea73, 0x22585f },
	{ 0xea74, 0x225860 },
	{ 0xea75, 0x225861 },
	{ 0xea76, 0x225862 },
	{ 0xea77, 0x225863 },
	{ 0xea78, 0x225864 },
	{ 0xea79, 0x225865 },
	{ 0xea7a, 0x225866 },
	{ 0xea7b, 0x225867 },
	{ 0xea7c, 0x225868 },
	{ 0xea7d, 0x225869 },
	{ 0xea7e, 0x22586a },
	{ 0xeaa1, 0x22586b },
	{ 0xeaa2, 0x22586c },
	{ 0xeaa3, 0x22586d },
	{ 0xeaa4, 0x22586e },
	{ 0xeaa5, 0x22586f },
	{ 0xeaa6, 0x225870 },
	{ 0xeaa7, 0x225871 },
	{ 0xeaa8, 0x225872 },
	{ 0xeaa9, 0x225873 },
	{ 0xeaaa, 0x225874 },
	{ 0xeaab, 0x225875 },
	{ 0xeaac, 0x225876 },
	{ 0xeaad, 0x225877 },
	{ 0xeaae, 0x225878 },
	{ 0xeaaf, 0x225879 },
	{ 0xeab0, 0x22587a },
	{ 0xeab1, 0x22587b },
	{ 0xeab2, 0x22587c },
	{ 0xeab3, 0x22587d },
	{ 0xeab4, 0x22587e },
	{ 0xeab5, 0x225921 },
	{ 0xeab6, 0x225922 },
	{ 0xeab7, 0x225923 },
	{ 0xeab8, 0x225924 },
	{ 0xeab9, 0x225925 },
	{ 0xeaba, 0x225926 },
	{ 0xeabb, 0x225927 },
	{ 0xeabc, 0x225928 },
	{ 0xeabd, 0x225929 },
	{ 0xeabe, 0x22592a },
	{ 0xeabf, 0x22592b },
	{ 0xeac0, 0x22592c },
	{ 0xeac1, 0x22592d },
	{ 0xeac2, 0x22592e },
	{ 0xeac3, 0x22592f },
	{ 0xeac4, 0x225930 },
	{ 0xeac5, 0x225931 },
	{ 0xeac6, 0x225932 },
	{ 0xeac7, 0x225933 },
	{ 0xeac8, 0x225934 },
	{ 0xeac9, 0x225935 },
	{ 0xeaca, 0x225936 },
	{ 0xeacb, 0x225937 },
	{ 0xeacc, 0x225938 },
	{ 0xeacd, 0x225939 },
	{ 0xeace, 0x22593a },
	{ 0xeacf, 0x22593b },
	{ 0xead0, 0x22593c },
	{ 0xead1, 0x22593d },
	{ 0xead2, 0x22593e },
	{ 0xead3, 0x22593f },
	{ 0xead4, 0x225940 },
	{ 0xead5, 0x225941 },
	{ 0xead6, 0x225942 },
	{ 0xead7, 0x225943 },
	{ 0xead8, 0x225944 },
	{ 0xead9, 0x225945 },
	{ 0xeada, 0x225946 },
	{ 0xeadb, 0x225947 },
	{ 0xeadc, 0x225948 },
	{ 0xeadd, 0x225949 },
	{ 0xeade, 0x22594a },
	{ 0xeadf, 0x22594b },
	{ 0xeae0, 0x22594c },
	{ 0xeae1, 0x22594d },
	{ 0xeae2, 0x22594e },
	{ 0xeae3, 0x22594f },
	{ 0xeae4, 0x225950 },
	{ 0xeae5, 0x225951 },
	{ 0xeae6, 0x225952 },
	{ 0xeae7, 0x225953 },
	{ 0xeae8, 0x225954 },
	{ 0xeae9, 0x225955 },
	{ 0xeaea, 0x225956 },
	{ 0xeaeb, 0x225957 },
	{ 0xeaec, 0x225958 },
	{ 0xeaed, 0x225959 },
	{ 0xeaee, 0x22595a },
	{ 0xeaef, 0x22595b },
	{ 0xeaf0, 0x22595c },
	{ 0xeaf1, 0x22595d },
	{ 0xeaf2, 0x22595e },
	{ 0xeaf3, 0x22595f },
	{ 0xeaf4, 0x225960 },
	{ 0xeaf5, 0x225961 },
	{ 0xeaf6, 0x225962 },
	{ 0xeaf7, 0x225963 },
	{ 0xeaf8, 0x225964 },
	{ 0xeaf9, 0x225965 },
	{ 0xeafa, 0x225966 },
	{ 0xeafb, 0x225967 },
	{ 0xeafc, 0x225968 },
	{ 0xeafd, 0x225969 },
	{ 0xeafe, 0x22596a },
	{ 0xeb40, 0x22596b },
	{ 0xeb41, 0x22596c },
	{ 0xeb42, 0x22596d },
	{ 0xeb43, 0x22596e },
	{ 0xeb44, 0x22596f },
	{ 0xeb45, 0x225970 },
	{ 0xeb46, 0x225971 },
	{ 0xeb47, 0x225972 },
	{ 0xeb48, 0x225973 },
	{ 0xeb49, 0x225974 },
	{ 0xeb4a, 0x225975 },
	{ 0xeb4b, 0x225976 },
	{ 0xeb4c, 0x225977 },
	{ 0xeb4d, 0x225978 },
	{ 0xeb4e, 0x225979 },
	{ 0xeb4f, 0x22597a },
	{ 0xeb50, 0x22597b },
	{ 0xeb51, 0x22597c },
	{ 0xeb52, 0x22597d },
	{ 0xeb53, 0x22597e },
	{ 0xeb54, 0x225a21 },
	{ 0xeb55, 0x225a22 },
	{ 0xeb56, 0x225a23 },
	{ 0xeb57, 0x225a24 },
	{ 0xeb58, 0x225a25 },
	{ 0xeb59, 0x225a26 },
	{ 0xeb5a, 0x225a27 },
	{ 0xeb5b, 0x225a29 },
	{ 0xeb5c, 0x225a2a },
	{ 0xeb5d, 0x225a2b },
	{ 0xeb5e, 0x225a2c },
	{ 0xeb5f, 0x225a2d },
	{ 0xeb60, 0x225a2e },
	{ 0xeb61, 0x225a2f },
	{ 0xeb62, 0x225a30 },
	{ 0xeb63, 0x225a31 },
	{ 0xeb64, 0x225a32 },
	{ 0xeb65, 0x225a33 },
	{ 0xeb66, 0x225a34 },
	{ 0xeb67, 0x225a35 },
	{ 0xeb68, 0x225a36 },
	{ 0xeb69, 0x225a37 },
	{ 0xeb6a, 0x225a38 },
	{ 0xeb6b, 0x225a39 },
	{ 0xeb6c, 0x225a3a },
	{ 0xeb6d, 0x225a3b },
	{ 0xeb6e, 0x225a3c },
	{ 0xeb6f, 0x225a3d },
	{ 0xeb70, 0x225a3e },
	{ 0xeb71, 0x225a3f },
	{ 0xeb72, 0x225a40 },
	{ 0xeb73, 0x225a41 },
	{ 0xeb74, 0x225a42 },
	{ 0xeb75, 0x225a43 },
	{ 0xeb76, 0x225a44 },
	{ 0xeb77, 0x225a45 },
	{ 0xeb78, 0x225a46 },
	{ 0xeb79, 0x225a47 },
	{ 0xeb7a, 0x225a48 },
	{ 0xeb7b, 0x225a49 },
	{ 0xeb7c, 0x225a4a },
	{ 0xeb7d, 0x225a4b },
	{ 0xeb7e, 0x225a4c },
	{ 0xeba1, 0x225a4d },
	{ 0xeba2, 0x225a4e },
	{ 0xeba3, 0x225a4f },
	{ 0xeba4, 0x225a50 },
	{ 0xeba5, 0x225a51 },
	{ 0xeba6, 0x225a52 },
	{ 0xeba7, 0x225a53 },
	{ 0xeba8, 0x225a54 },
	{ 0xeba9, 0x225a55 },
	{ 0xebaa, 0x225a56 },
	{ 0xebab, 0x225a57 },
	{ 0xebac, 0x225a58 },
	{ 0xebad, 0x225a59 },
	{ 0xebae, 0x225a5a },
	{ 0xebaf, 0x225a5b },
	{ 0xebb0, 0x225a5c },
	{ 0xebb1, 0x225a5d },
	{ 0xebb2, 0x225a5e },
	{ 0xebb3, 0x225a5f },
	{ 0xebb4, 0x225a60 },
	{ 0xebb5, 0x225a61 },
	{ 0xebb6, 0x225a62 },
	{ 0xebb7, 0x225a63 },
	{ 0xebb8, 0x225a64 },
	{ 0xebb9, 0x225a65 },
	{ 0xebba, 0x225a66 },
	{ 0xebbb, 0x225a67 },
	{ 0xebbc, 0x225a68 },
	{ 0xebbd, 0x225a69 },
	{ 0xebbe, 0x225a6a },
	{ 0xebbf, 0x225a6b },
	{ 0xebc0, 0x225a6c },
	{ 0xebc1, 0x225a6d },
	{ 0xebc2, 0x225a6e },
	{ 0xebc3, 0x225a6f },
	{ 0xebc4, 0x225a70 },
	{ 0xebc5, 0x225a71 },
	{ 0xebc6, 0x225a72 },
	{ 0xebc7, 0x225a73 },
	{ 0xebc8, 0x225a74 },
	{ 0xebc9, 0x225a75 },
	{ 0xebca, 0x225a76 },
	{ 0xebcb, 0x225a77 },
	{ 0xebcc, 0x225a78 },
	{ 0xebcd, 0x225a79 },
	{ 0xebce, 0x225a7a },
	{ 0xebcf, 0x225a7b },
	{ 0xebd0, 0x225a7c },
	{ 0xebd1, 0x225a7d },
	{ 0xebd2, 0x225a7e },
	{ 0xebd3, 0x225b21 },
	{ 0xebd4, 0x225b22 },
	{ 0xebd5, 0x225b23 },
	{ 0xebd6, 0x225b24 },
	{ 0xebd7, 0x225b25 },
	{ 0xebd8, 0x225b26 },
	{ 0xebd9, 0x225b27 },
	{ 0xebda, 0x225b28 },
	{ 0xebdb, 0x225b29 },
	{ 0xebdc, 0x225b2a },
	{ 0xebdd, 0x225b2b },
	{ 0xebde, 0x225b2c },
	{ 0xebdf, 0x225b2d },
	{ 0xebe0, 0x225b2e },
	{ 0xebe1, 0x225b2f },
	{ 0xebe2, 0x225b30 },
	{ 0xebe3, 0x225b31 },
	{ 0xebe4, 0x225b32 },
	{ 0xebe5, 0x225b33 },
	{ 0xebe6, 0x225b34 },
	{ 0xebe7, 0x225b35 },
	{ 0xebe8, 0x225b36 },
	{ 0xebe9, 0x225b37 },
	{ 0xebea, 0x225b38 },
	{ 0xebeb, 0x225b39 },
	{ 0xebec, 0x225b3a },
	{ 0xebed, 0x225b3b },
	{ 0xebee, 0x225b3c },
	{ 0xebef, 0x225b3d },
	{ 0xebf0, 0x225b3e },
	{ 0xebf1, 0x22554b },
	{ 0xebf2, 0x225b3f },
	{ 0xebf3, 0x225b40 },
	{ 0xebf4, 0x225b41 },
	{ 0xebf5, 0x225b42 },
	{ 0xebf6, 0x225b43 },
	{ 0xebf7, 0x225b44 },
	{ 0xebf8, 0x225b45 },
	{ 0xebf9, 0x225b46 },
	{ 0xebfa, 0x225b47 },
	{ 0xebfb, 0x225b48 },
	{ 0xebfc, 0x225b49 },
	{ 0xebfd, 0x225b4a },
	{ 0xebfe, 0x225b4b },
	{ 0xec40, 0x225b4c },
	{ 0xec41, 0x225b4d },
	{ 0xec42, 0x225b4e },
	{ 0xec43, 0x225b4f },
	{ 0xec44, 0x225b50 },
	{ 0xec45, 0x225b51 },
	{ 0xec46, 0x225b52 },
	{ 0xec47, 0x225b53 },
	{ 0xec48, 0x225b54 },
	{ 0xec49, 0x225b55 },
	{ 0xec4a, 0x225b56 },
	{ 0xec4b, 0x225b57 },
	{ 0xec4c, 0x225b58 },
	{ 0xec4d, 0x225b59 },
	{ 0xec4e, 0x225b5a },
	{ 0xec4f, 0x225b5b },
	{ 0xec50, 0x225b5c },
	{ 0xec51, 0x225b5d },
	{ 0xec52, 0x225b5e },
	{ 0xec53, 0x225b5f },
	{ 0xec54, 0x225b60 },
	{ 0xec55, 0x225b61 },
	{ 0xec56, 0x225b62 },
	{ 0xec57, 0x225b63 },
	{ 0xec58, 0x225b64 },
	{ 0xec59, 0x225b65 },
	{ 0xec5a, 0x225b66 },
	{ 0xec5b, 0x225b67 },
	{ 0xec5c, 0x225b68 },
	{ 0xec5d, 0x225b69 },
	{ 0xec5e, 0x225b6a },
	{ 0xec5f, 0x225b6b },
	{ 0xec60, 0x225b6c },
	{ 0xec61, 0x225b6d },
	{ 0xec62, 0x225b6e },
	{ 0xec63, 0x225b6f },
	{ 0xec64, 0x225b70 },
	{ 0xec65, 0x225b71 },
	{ 0xec66, 0x225b72 },
	{ 0xec67, 0x225b73 },
	{ 0xec68, 0x225b74 },
	{ 0xec69, 0x225b75 },
	{ 0xec6a, 0x225b76 },
	{ 0xec6b, 0x225b77 },
	{ 0xec6c, 0x225b78 },
	{ 0xec6d, 0x225b79 },
	{ 0xec6e, 0x225b7a },
	{ 0xec6f, 0x225b7b },
	{ 0xec70, 0x225b7c },
	{ 0xec71, 0x225b7d },
	{ 0xec72, 0x225b7e },
	{ 0xec73, 0x225c21 },
	{ 0xec74, 0x225c22 },
	{ 0xec75, 0x225c23 },
	{ 0xec76, 0x225c24 },
	{ 0xec77, 0x225c25 },
	{ 0xec78, 0x225c26 },
	{ 0xec79, 0x225c27 },
	{ 0xec7a, 0x225c28 },
	{ 0xec7b, 0x225c29 },
	{ 0xec7c, 0x225c2a },
	{ 0xec7d, 0x225c2b },
	{ 0xec7e, 0x225c2c },
	{ 0xeca1, 0x225c2d },
	{ 0xeca2, 0x225c2e },
	{ 0xeca3, 0x225c2f },
	{ 0xeca4, 0x225c30 },
	{ 0xeca5, 0x225c31 },
	{ 0xeca6, 0x225c32 },
	{ 0xeca7, 0x225c33 },
	{ 0xeca8, 0x225c34 },
	{ 0xeca9, 0x225c35 },
	{ 0xecaa, 0x225c36 },
	{ 0xecab, 0x225c37 },
	{ 0xecac, 0x225c38 },
	{ 0xecad, 0x225c39 },
	{ 0xecae, 0x225c3a },
	{ 0xecaf, 0x225c3b },
	{ 0xecb0, 0x225c3c },
	{ 0xecb1, 0x225c3d },
	{ 0xecb2, 0x225c3e },
	{ 0xecb3, 0x225c3f },
	{ 0xecb4, 0x225c40 },
	{ 0xecb5, 0x225c41 },
	{ 0xecb6, 0x225c42 },
	{ 0xecb7, 0x225c43 },
	{ 0xecb8, 0x225c44 },
	{ 0xecb9, 0x225c45 },
	{ 0xecba, 0x225c46 },
	{ 0xecbb, 0x225c47 },
	{ 0xecbc, 0x225c48 },
	{ 0xecbd, 0x225c49 },
	{ 0xecbe, 0x225c4a },
	{ 0xecbf, 0x225c4b },
	{ 0xecc0, 0x225c4c },
	{ 0xecc1, 0x225c4d },
	{ 0xecc2, 0x225c4e },
	{ 0xecc3, 0x225c4f },
	{ 0xecc4, 0x225c50 },
	{ 0xecc5, 0x225c51 },
	{ 0xecc6, 0x225c52 },
	{ 0xecc7, 0x225c53 },
	{ 0xecc8, 0x225c54 },
	{ 0xecc9, 0x225c55 },
	{ 0xecca, 0x225c56 },
	{ 0xeccb, 0x225c57 },
	{ 0xeccc, 0x225c58 },
	{ 0xeccd, 0x225c59 },
	{ 0xecce, 0x225c5a },
	{ 0xeccf, 0x225c5b },
	{ 0xecd0, 0x225c5c },
	{ 0xecd1, 0x225c5d },
	{ 0xecd2, 0x225c5e },
	{ 0xecd3, 0x225c5f },
	{ 0xecd4, 0x225c60 },
	{ 0xecd5, 0x225c61 },
	{ 0xecd6, 0x225c62 },
	{ 0xecd7, 0x225c63 },
	{ 0xecd8, 0x225c64 },
	{ 0xecd9, 0x225c65 },
	{ 0xecda, 0x225c66 },
	{ 0xecdb, 0x225c67 },
	{ 0xecdc, 0x225c68 },
	{ 0xecdd, 0x225c69 },
	{ 0xecde, 0x225722 },
	{ 0xecdf, 0x225c6a },
	{ 0xece0, 0x225c6b },
	{ 0xece1, 0x225c6c },
	{ 0xece2, 0x225c6d },
	{ 0xece3, 0x225c6e },
	{ 0xece4, 0x225c6f },
	{ 0xece5, 0x225c70 },
	{ 0xece6, 0x225c71 },
	{ 0xece7, 0x225c72 },
	{ 0xece8, 0x225c73 },
	{ 0xece9, 0x225c74 },
	{ 0xecea, 0x225c75 },
	{ 0xeceb, 0x225c76 },
	{ 0xecec, 0x225c77 },
	{ 0xeced, 0x225c78 },
	{ 0xecee, 0x225c79 },
	{ 0xecef, 0x225c7a },
	{ 0xecf0, 0x225c7b },
	{ 0xecf1, 0x225c7c },
	{ 0xecf2, 0x225c7d },
	{ 0xecf3, 0x225c7e },
	{ 0xecf4, 0x225d21 },
	{ 0xecf5, 0x225d22 },
	{ 0xecf6, 0x225d23 },
	{ 0xecf7, 0x225d24 },
	{ 0xecf8, 0x225d25 },
	{ 0xecf9, 0x225d26 },
	{ 0xecfa, 0x225d27 },
	{ 0xecfb, 0x225d28 },
	{ 0xecfc, 0x225d29 },
	{ 0xecfd, 0x225d2a },
	{ 0xecfe, 0x225d2b },
	{ 0xed40, 0x225d2c },
	{ 0xed41, 0x225d2d },
	{ 0xed42, 0x225d2e },
	{ 0xed43, 0x225d2f },
	{ 0xed44, 0x225d30 },
	{ 0xed45, 0x225d31 },
	{ 0xed46, 0x225d32 },
	{ 0xed47, 0x225d33 },
	{ 0xed48, 0x225d34 },
	{ 0xed49, 0x225d35 },
	{ 0xed4a, 0x225d36 },
	{ 0xed4b, 0x225d37 },
	{ 0xed4c, 0x225d38 },
	{ 0xed4d, 0x225d39 },
	{ 0xed4e, 0x225d3a },
	{ 0xed4f, 0x225d3b },
	{ 0xed50, 0x225d3c },
	{ 0xed51, 0x225d3d },
	{ 0xed52, 0x225d3e },
	{ 0xed53, 0x225d3f },
	{ 0xed54, 0x225d40 },
	{ 0xed55, 0x225d41 },
	{ 0xed56, 0x225d42 },
	{ 0xed57, 0x225d43 },
	{ 0xed58, 0x225d44 },
	{ 0xed59, 0x225d45 },
	{ 0xed5a, 0x225d46 },
	{ 0xed5b, 0x225d47 },
	{ 0xed5c, 0x225d48 },
	{ 0xed5d, 0x225d49 },
	{ 0xed5e, 0x225d4a },
	{ 0xed5f, 0x225d4b },
	{ 0xed60, 0x225d4c },
	{ 0xed61, 0x225d4d },
	{ 0xed62, 0x225d4e },
	{ 0xed63, 0x225d4f },
	{ 0xed64, 0x225d50 },
	{ 0xed65, 0x225d51 },
	{ 0xed66, 0x225d52 },
	{ 0xed67, 0x225d53 },
	{ 0xed68, 0x225d54 },
	{ 0xed69, 0x225d55 },
	{ 0xed6a, 0x225d56 },
	{ 0xed6b, 0x225d57 },
	{ 0xed6c, 0x225d58 },
	{ 0xed6d, 0x225d59 },
	{ 0xed6e, 0x225d5a },
	{ 0xed6f, 0x225d5b },
	{ 0xed70, 0x225d5c },
	{ 0xed71, 0x225d5d },
	{ 0xed72, 0x225d5e },
	{ 0xed73, 0x225d5f },
	{ 0xed74, 0x225d60 },
	{ 0xed75, 0x225d61 },
	{ 0xed76, 0x225d62 },
	{ 0xed77, 0x225d63 },
	{ 0xed78, 0x225d64 },
	{ 0xed79, 0x225d65 },
	{ 0xed7a, 0x225d66 },
	{ 0xed7b, 0x225d67 },
	{ 0xed7c, 0x225d68 },
	{ 0xed7d, 0x225d69 },
	{ 0xed7e, 0x225d6a },
	{ 0xeda1, 0x225d6b },
	{ 0xeda2, 0x225d6c },
	{ 0xeda3, 0x225d6d },
	{ 0xeda4, 0x225d6e },
	{ 0xeda5, 0x225d6f },
	{ 0xeda6, 0x225d70 },
	{ 0xeda7, 0x225d71 },
	{ 0xeda8, 0x225d72 },
	{ 0xeda9, 0x225d73 },
	{ 0xedaa, 0x225d75 },
	{ 0xedab, 0x225d76 },
	{ 0xedac, 0x225d77 },
	{ 0xedad, 0x225d78 },
	{ 0xedae, 0x225d79 },
	{ 0xedaf, 0x225d7a },
	{ 0xedb0, 0x225d7b },
	{ 0xedb1, 0x225d7c },
	{ 0xedb2, 0x225d7d },
	{ 0xedb3, 0x225d7e },
	{ 0xedb4, 0x225e21 },
	{ 0xedb5, 0x225e22 },
	{ 0xedb6, 0x225e23 },
	{ 0xedb7, 0x225e24 },
	{ 0xedb8, 0x225e25 },
	{ 0xedb9, 0x225e26 },
	{ 0xedba, 0x225e27 },
	{ 0xedbb, 0x225e28 },
	{ 0xedbc, 0x225e29 },
	{ 0xedbd, 0x225e2a },
	{ 0xedbe, 0x225e2b },
	{ 0xedbf, 0x225e2c },
	{ 0xedc0, 0x225e2d },
	{ 0xedc1, 0x225e2e },
	{ 0xedc2, 0x225e2f },
	{ 0xedc3, 0x225e30 },
	{ 0xedc4, 0x225e31 },
	{ 0xedc5, 0x225e32 },
	{ 0xedc6, 0x225e33 },
	{ 0xedc7, 0x225e34 },
	{ 0xedc8, 0x225e35 },
	{ 0xedc9, 0x225e36 },
	{ 0xedca, 0x225e37 },
	{ 0xedcb, 0x225e38 },
	{ 0xedcc, 0x225e39 },
	{ 0xedcd, 0x225e3a },
	{ 0xedce, 0x225e3b },
	{ 0xedcf, 0x225e3c },
	{ 0xedd0, 0x225e3d },
	{ 0xedd1, 0x225e3e },
	{ 0xedd2, 0x225e3f },
	{ 0xedd3, 0x225e40 },
	{ 0xedd4, 0x225e41 },
	{ 0xedd5, 0x225e42 },
	{ 0xedd6, 0x225e43 },
	{ 0xedd7, 0x225e44 },
	{ 0xedd8, 0x225e45 },
	{ 0xedd9, 0x225e46 },
	{ 0xedda, 0x225e47 },
	{ 0xeddb, 0x225e48 },
	{ 0xeddc, 0x225e49 },
	{ 0xeddd, 0x225e4a },
	{ 0xedde, 0x225e4b },
	{ 0xeddf, 0x225e4c },
	{ 0xede0, 0x225e4d },
	{ 0xede1, 0x225e4e },
	{ 0xede2, 0x225e4f },
	{ 0xede3, 0x225e50 },
	{ 0xede4, 0x225e51 },
	{ 0xede5, 0x225e52 },
	{ 0xede6, 0x225e53 },
	{ 0xede7, 0x225e54 },
	{ 0xede8, 0x225e55 },
	{ 0xede9, 0x225e56 },
	{ 0xedea, 0x225e57 },
	{ 0xedeb, 0x225e58 },
	{ 0xedec, 0x225e59 },
	{ 0xeded, 0x225e5a },
	{ 0xedee, 0x225e5b },
	{ 0xedef, 0x225e5c },
	{ 0xedf0, 0x225e5d },
	{ 0xedf1, 0x225e5e },
	{ 0xedf2, 0x225e5f },
	{ 0xedf3, 0x225e60 },
	{ 0xedf4, 0x225e61 },
	{ 0xedf5, 0x225e62 },
	{ 0xedf6, 0x225e63 },
	{ 0xedf7, 0x225e64 },
	{ 0xedf8, 0x225e65 },
	{ 0xedf9, 0x225e66 },
	{ 0xedfa, 0x225e67 },
	{ 0xedfb, 0x225e68 },
	{ 0xedfc, 0x225e69 },
	{ 0xedfd, 0x225e6a },
	{ 0xedfe, 0x225e6b },
	{ 0xee40, 0x225e6c },
	{ 0xee41, 0x225e6d },
	{ 0xee42, 0x225e6e },
	{ 0xee43, 0x225e6f },
	{ 0xee44, 0x225e70 },
	{ 0xee45, 0x225e71 },
	{ 0xee46, 0x225e72 },
	{ 0xee47, 0x225e73 },
	{ 0xee48, 0x225e74 },
	{ 0xee49, 0x225e75 },
	{ 0xee4a, 0x225e76 },
	{ 0xee4b, 0x225e77 },
	{ 0xee4c, 0x225e78 },
	{ 0xee4d, 0x225e79 },
	{ 0xee4e, 0x225e7a },
	{ 0xee4f, 0x225e7b },
	{ 0xee50, 0x225e7c },
	{ 0xee51, 0x225e7d },
	{ 0xee52, 0x225e7e },
	{ 0xee53, 0x225f21 },
	{ 0xee54, 0x225f22 },
	{ 0xee55, 0x225f23 },
	{ 0xee56, 0x225f24 },
	{ 0xee57, 0x225f25 },
	{ 0xee58, 0x225f26 },
	{ 0xee59, 0x225f27 },
	{ 0xee5a, 0x225f28 },
	{ 0xee5b, 0x225f29 },
	{ 0xee5c, 0x225f2a },
	{ 0xee5d, 0x225f2b },
	{ 0xee5e, 0x225f2c },
	{ 0xee5f, 0x225f2d },
	{ 0xee60, 0x225f2e },
	{ 0xee61, 0x225f2f },
	{ 0xee62, 0x225f30 },
	{ 0xee63, 0x225f31 },
	{ 0xee64, 0x225f32 },
	{ 0xee65, 0x225f33 },
	{ 0xee66, 0x225f34 },
	{ 0xee67, 0x225f35 },
	{ 0xee68, 0x225f36 },
	{ 0xee69, 0x225f37 },
	{ 0xee6a, 0x225f38 },
	{ 0xee6b, 0x225f39 },
	{ 0xee6c, 0x225f3a },
	{ 0xee6d, 0x225f3b },
	{ 0xee6e, 0x225f3c },
	{ 0xee6f, 0x225f3d },
	{ 0xee70, 0x225f3e },
	{ 0xee71, 0x225f3f },
	{ 0xee72, 0x225f40 },
	{ 0xee73, 0x225f41 },
	{ 0xee74, 0x225f42 },
	{ 0xee75, 0x225f43 },
	{ 0xee76, 0x225f44 },
	{ 0xee77, 0x225f45 },
	{ 0xee78, 0x225f46 },
	{ 0xee79, 0x225f47 },
	{ 0xee7a, 0x225f48 },
	{ 0xee7b, 0x225f49 },
	{ 0xee7c, 0x225f4a },
	{ 0xee7d, 0x225f4b },
	{ 0xee7e, 0x225f4c },
	{ 0xeea1, 0x225f4d },
	{ 0xeea2, 0x225f4e },
	{ 0xeea3, 0x225f4f },
	{ 0xeea4, 0x225f50 },
	{ 0xeea5, 0x225f51 },
	{ 0xeea6, 0x225f52 },
	{ 0xeea7, 0x225f53 },
	{ 0xeea8, 0x225f54 },
	{ 0xeea9, 0x225f55 },
	{ 0xeeaa, 0x225f56 },
	{ 0xeeab, 0x225f57 },
	{ 0xeeac, 0x225f58 },
	{ 0xeead, 0x225f59 },
	{ 0xeeae, 0x225f5a },
	{ 0xeeaf, 0x225f5b },
	{ 0xeeb0, 0x225f5c },
	{ 0xeeb1, 0x225f5d },
	{ 0xeeb2, 0x225f5e },
	{ 0xeeb3, 0x225f5f },
	{ 0xeeb4, 0x225f60 },
	{ 0xeeb5, 0x225f61 },
	{ 0xeeb6, 0x225f62 },
	{ 0xeeb7, 0x225f63 },
	{ 0xeeb8, 0x225f64 },
	{ 0xeeb9, 0x225f65 },
	{ 0xeeba, 0x225f66 },
	{ 0xeebb, 0x225f67 },
	{ 0xeebc, 0x225f68 },
	{ 0xeebd, 0x225f69 },
	{ 0xeebe, 0x225f6a },
	{ 0xeebf, 0x225f6b },
	{ 0xeec0, 0x225f6c },
	{ 0xeec1, 0x225f6d },
	{ 0xeec2, 0x225f6e },
	{ 0xeec3, 0x225f6f },
	{ 0xeec4, 0x225f70 },
	{ 0xeec5, 0x225f71 },
	{ 0xeec6, 0x225f72 },
	{ 0xeec7, 0x225f73 },
	{ 0xeec8, 0x225f74 },
	{ 0xeec9, 0x225f75 },
	{ 0xeeca, 0x225f76 },
	{ 0xeecb, 0x225f77 },
	{ 0xeecc, 0x225f78 },
	{ 0xeecd, 0x225f79 },
	{ 0xeece, 0x225f7a },
	{ 0xeecf, 0x225f7b },
	{ 0xeed0, 0x225f7c },
	{ 0xeed1, 0x225f7d },
	{ 0xeed2, 0x225f7e },
	{ 0xeed3, 0x226021 },
	{ 0xeed4, 0x226022 },
	{ 0xeed5, 0x226023 },
	{ 0xeed6, 0x226024 },
	{ 0xeed7, 0x226025 },
	{ 0xeed8, 0x226026 },
	{ 0xeed9, 0x226027 },
	{ 0xeeda, 0x226028 },
	{ 0xeedb, 0x226029 },
	{ 0xeedc, 0x22602a },
	{ 0xeedd, 0x22602b },
	{ 0xeede, 0x22602c },
	{ 0xeedf, 0x22602d },
	{ 0xeee0, 0x22602e },
	{ 0xeee1, 0x22602f },
	{ 0xeee2, 0x226030 },
	{ 0xeee3, 0x226031 },
	{ 0xeee4, 0x226032 },
	{ 0xeee5, 0x226033 },
	{ 0xeee6, 0x226034 },
	{ 0xeee7, 0x226035 },
	{ 0xeee8, 0x226036 },
	{ 0xeee9, 0x226037 },
	{ 0xeeea, 0x226038 },
	{ 0xeeeb, 0x22642f },
	{ 0xeeec, 0x226039 },
	{ 0xeeed, 0x22603a },
	{ 0xeeee, 0x22603b },
	{ 0xeeef, 0x22603c },
	{ 0xeef0, 0x22603d },
	{ 0xeef1, 0x22603e },
	{ 0xeef2, 0x22603f },
	{ 0xeef3, 0x226040 },
	{ 0xeef4, 0x226041 },
	{ 0xeef5, 0x226042 },
	{ 0xeef6, 0x226043 },
	{ 0xeef7, 0x226044 },
	{ 0xeef8, 0x226045 },
	{ 0xeef9, 0x226046 },
	{ 0xeefa, 0x226047 },
	{ 0xeefb, 0x226048 },
	{ 0xeefc, 0x226049 },
	{ 0xeefd, 0x22604a },
	{ 0xeefe, 0x22604b },
	{ 0xef40, 0x22604c },
	{ 0xef41, 0x22604d },
	{ 0xef42, 0x22604e },
	{ 0xef43, 0x22604f },
	{ 0xef44, 0x226050 },
	{ 0xef45, 0x226051 },
	{ 0xef46, 0x226052 },
	{ 0xef47, 0x226053 },
	{ 0xef48, 0x226054 },
	{ 0xef49, 0x226055 },
	{ 0xef4a, 0x226056 },
	{ 0xef4b, 0x226057 },
	{ 0xef4c, 0x226058 },
	{ 0xef4d, 0x226059 },
	{ 0xef4e, 0x22605a },
	{ 0xef4f, 0x22605b },
	{ 0xef50, 0x22605c },
	{ 0xef51, 0x22605d },
	{ 0xef52, 0x22605e },
	{ 0xef53, 0x22605f },
	{ 0xef54, 0x226060 },
	{ 0xef55, 0x226061 },
	{ 0xef56, 0x226062 },
	{ 0xef57, 0x226063 },
	{ 0xef58, 0x226064 },
	{ 0xef59, 0x226065 },
	{ 0xef5a, 0x226066 },
	{ 0xef5b, 0x226067 },
	{ 0xef5c, 0x226068 },
	{ 0xef5d, 0x226069 },
	{ 0xef5e, 0x22606a },
	{ 0xef5f, 0x22606b },
	{ 0xef60, 0x22606c },
	{ 0xef61, 0x22606d },
	{ 0xef62, 0x22606e },
	{ 0xef63, 0x22606f },
	{ 0xef64, 0x226070 },
	{ 0xef65, 0x226071 },
	{ 0xef66, 0x226072 },
	{ 0xef67, 0x226073 },
	{ 0xef68, 0x226074 },
	{ 0xef69, 0x226075 },
	{ 0xef6a, 0x226076 },
	{ 0xef6b, 0x226077 },
	{ 0xef6c, 0x226078 },
	{ 0xef6d, 0x226079 },
	{ 0xef6e, 0x22607a },
	{ 0xef6f, 0x22607b },
	{ 0xef70, 0x22607c },
	{ 0xef71, 0x22607d },
	{ 0xef72, 0x22607e },
	{ 0xef73, 0x226121 },
	{ 0xef74, 0x226122 },
	{ 0xef75, 0x226123 },
	{ 0xef76, 0x226124 },
	{ 0xef77, 0x226125 },
	{ 0xef78, 0x226126 },
	{ 0xef79, 0x226127 },
	{ 0xef7a, 0x226128 },
	{ 0xef7b, 0x226129 },
	{ 0xef7c, 0x22612a },
	{ 0xef7d, 0x22612b },
	{ 0xef7e, 0x22612c },
	{ 0xefa1, 0x22612d },
	{ 0xefa2, 0x22612e },
	{ 0xefa3, 0x22612f },
	{ 0xefa4, 0x226130 },
	{ 0xefa5, 0x226131 },
	{ 0xefa6, 0x226132 },
	{ 0xefa7, 0x226133 },
	{ 0xefa8, 0x226134 },
	{ 0xefa9, 0x226135 },
	{ 0xefaa, 0x226136 },
	{ 0xefab, 0x226137 },
	{ 0xefac, 0x226138 },
	{ 0xefad, 0x226139 },
	{ 0xefae, 0x22613a },
	{ 0xefaf, 0x22613b },
	{ 0xefb0, 0x22613c },
	{ 0xefb1, 0x22613d },
	{ 0xefb2, 0x22613e },
	{ 0xefb3, 0x22613f },
	{ 0xefb4, 0x226140 },
	{ 0xefb5, 0x226141 },
	{ 0xefb6, 0x226142 },
	{ 0xefb7, 0x226143 },
	{ 0xefb8, 0x226144 },
	{ 0xefb9, 0x226145 },
	{ 0xefba, 0x226146 },
	{ 0xefbb, 0x226147 },
	{ 0xefbc, 0x226148 },
	{ 0xefbd, 0x226149 },
	{ 0xefbe, 0x22614a },
	{ 0xefbf, 0x22614b },
	{ 0xefc0, 0x22614c },
	{ 0xefc1, 0x22614d },
	{ 0xefc2, 0x22614e },
	{ 0xefc3, 0x22614f },
	{ 0xefc4, 0x226150 },
	{ 0xefc5, 0x226151 },
	{ 0xefc6, 0x226152 },
	{ 0xefc7, 0x226153 },
	{ 0xefc8, 0x226154 },
	{ 0xefc9, 0x226155 },
	{ 0xefca, 0x226156 },
	{ 0xefcb, 0x226157 },
	{ 0xefcc, 0x226158 },
	{ 0xefcd, 0x226159 },
	{ 0xefce, 0x22615a },
	{ 0xefcf, 0x22615b },
	{ 0xefd0, 0x22615c },
	{ 0xefd1, 0x22615d },
	{ 0xefd2, 0x22615e },
	{ 0xefd3, 0x22615f },
	{ 0xefd4, 0x226160 },
	{ 0xefd5, 0x226161 },
	{ 0xefd6, 0x226162 },
	{ 0xefd7, 0x226163 },
	{ 0xefd8, 0x226164 },
	{ 0xefd9, 0x226165 },
	{ 0xefda, 0x226166 },
	{ 0xefdb, 0x226167 },
	{ 0xefdc, 0x226168 },
	{ 0xefdd, 0x226169 },
	{ 0xefde, 0x22616a },
	{ 0xefdf, 0x22616b },
	{ 0xefe0, 0x22616c },
	{ 0xefe1, 0x22616d },
	{ 0xefe2, 0x22616e },
	{ 0xefe3, 0x22616f },
	{ 0xefe4, 0x226170 },
	{ 0xefe5, 0x226171 },
	{ 0xefe6, 0x226172 },
	{ 0xefe7, 0x226173 },
	{ 0xefe8, 0x226174 },
	{ 0xefe9, 0x226175 },
	{ 0xefea, 0x226176 },
	{ 0xefeb, 0x226177 },
	{ 0xefec, 0x226178 },
	{ 0xefed, 0x226179 },
	{ 0xefee, 0x22617a },
	{ 0xefef, 0x22617b },
	{ 0xeff0, 0x22617c },
	{ 0xeff1, 0x22617d },
	{ 0xeff2, 0x22617e },
	{ 0xeff3, 0x226221 },
	{ 0xeff4, 0x226222 },
	{ 0xeff5, 0x226223 },
	{ 0xeff6, 0x226224 },
	{ 0xeff7, 0x226225 },
	{ 0xeff8, 0x226226 },
	{ 0xeff9, 0x226227 },
	{ 0xeffa, 0x226228 },
	{ 0xeffb, 0x226229 },
	{ 0xeffc, 0x22622a },
	{ 0xeffd, 0x22622b },
	{ 0xeffe, 0x22622c },
	{ 0xf040, 0x22622d },
	{ 0xf041, 0x22622e },
	{ 0xf042, 0x22622f },
	{ 0xf043, 0x226230 },
	{ 0xf044, 0x226231 },
	{ 0xf045, 0x226232 },
	{ 0xf046, 0x226233 },
	{ 0xf047, 0x226234 },
	{ 0xf048, 0x226235 },
	{ 0xf049, 0x226236 },
	{ 0xf04a, 0x226237 },
	{ 0xf04b, 0x226238 },
	{ 0xf04c, 0x226239 },
	{ 0xf04d, 0x22623a },
	{ 0xf04e, 0x22623b },
	{ 0xf04f, 0x22623c },
	{ 0xf050, 0x22623d },
	{ 0xf051, 0x22623e },
	{ 0xf052, 0x22623f },
	{ 0xf053, 0x226240 },
	{ 0xf054, 0x226241 },
	{ 0xf055, 0x226242 },
	{ 0xf056, 0x225d74 },
	{ 0xf057, 0x226243 },
	{ 0xf058, 0x226244 },
	{ 0xf059, 0x226245 },
	{ 0xf05a, 0x226246 },
	{ 0xf05b, 0x226247 },
	{ 0xf05c, 0x226248 },
	{ 0xf05d, 0x226249 },
	{ 0xf05e, 0x22624a },
	{ 0xf05f, 0x22624b },
	{ 0xf060, 0x22624c },
	{ 0xf061, 0x22624d },
	{ 0xf062, 0x22624e },
	{ 0xf063, 0x22624f },
	{ 0xf064, 0x226250 },
	{ 0xf065, 0x226251 },
	{ 0xf066, 0x226252 },
	{ 0xf067, 0x226253 },
	{ 0xf068, 0x226254 },
	{ 0xf069, 0x226255 },
	{ 0xf06a, 0x226256 },
	{ 0xf06b, 0x226257 },
	{ 0xf06c, 0x226258 },
	{ 0xf06d, 0x226259 },
	{ 0xf06e, 0x22625a },
	{ 0xf06f, 0x22625b },
	{ 0xf070, 0x22625c },
	{ 0xf071, 0x22625d },
	{ 0xf072, 0x22625e },
	{ 0xf073, 0x22625f },
	{ 0xf074, 0x226260 },
	{ 0xf075, 0x226261 },
	{ 0xf076, 0x226262 },
	{ 0xf077, 0x226263 },
	{ 0xf078, 0x226264 },
	{ 0xf079, 0x226265 },
	{ 0xf07a, 0x226266 },
	{ 0xf07b, 0x226267 },
	{ 0xf07c, 0x226268 },
	{ 0xf07d, 0x226269 },
	{ 0xf07e, 0x22626a },
	{ 0xf0a1, 0x22626b },
	{ 0xf0a2, 0x22626c },
	{ 0xf0a3, 0x22626d },
	{ 0xf0a4, 0x22626e },
	{ 0xf0a5, 0x22626f },
	{ 0xf0a6, 0x226270 },
	{ 0xf0a7, 0x226271 },
	{ 0xf0a8, 0x226272 },
	{ 0xf0a9, 0x226273 },
	{ 0xf0aa, 0x226274 },
	{ 0xf0ab, 0x226275 },
	{ 0xf0ac, 0x226276 },
	{ 0xf0ad, 0x226277 },
	{ 0xf0ae, 0x226278 },
	{ 0xf0af, 0x226279 },
	{ 0xf0b0, 0x22627a },
	{ 0xf0b1, 0x22627b },
	{ 0xf0b2, 0x22627c },
	{ 0xf0b3, 0x22627d },
	{ 0xf0b4, 0x22627e },
	{ 0xf0b5, 0x226321 },
	{ 0xf0b6, 0x226322 },
	{ 0xf0b7, 0x226323 },
	{ 0xf0b8, 0x226324 },
	{ 0xf0b9, 0x226325 },
	{ 0xf0ba, 0x226326 },
	{ 0xf0bb, 0x226327 },
	{ 0xf0bc, 0x226328 },
	{ 0xf0bd, 0x226329 },
	{ 0xf0be, 0x22632a },
	{ 0xf0bf, 0x22632b },
	{ 0xf0c0, 0x22632c },
	{ 0xf0c1, 0x22632d },
	{ 0xf0c2, 0x22632e },
	{ 0xf0c3, 0x22632f },
	{ 0xf0c4, 0x226330 },
	{ 0xf0c5, 0x226331 },
	{ 0xf0c6, 0x226332 },
	{ 0xf0c7, 0x226333 },
	{ 0xf0c8, 0x226334 },
	{ 0xf0c9, 0x226335 },
	{ 0xf0ca, 0x226336 },
	{ 0xf0cb, 0x225a28 },
	{ 0xf0cc, 0x226337 },
	{ 0xf0cd, 0x226338 },
	{ 0xf0ce, 0x226339 },
	{ 0xf0cf, 0x22633a },
	{ 0xf0d0, 0x22633b },
	{ 0xf0d1, 0x22633c },
	{ 0xf0d2, 0x22633d },
	{ 0xf0d3, 0x22633e },
	{ 0xf0d4, 0x22633f },
	{ 0xf0d5, 0x226340 },
	{ 0xf0d6, 0x226341 },
	{ 0xf0d7, 0x226342 },
	{ 0xf0d8, 0x226343 },
	{ 0xf0d9, 0x226344 },
	{ 0xf0da, 0x226345 },
	{ 0xf0db, 0x226346 },
	{ 0xf0dc, 0x226347 },
	{ 0xf0dd, 0x226348 },
	{ 0xf0de, 0x226349 },
	{ 0xf0df, 0x22634a },
	{ 0xf0e0, 0x22634b },
	{ 0xf0e1, 0x22634c },
	{ 0xf0e2, 0x22634d },
	{ 0xf0e3, 0x22634e },
	{ 0xf0e4, 0x22634f },
	{ 0xf0e5, 0x226350 },
	{ 0xf0e6, 0x226351 },
	{ 0xf0e7, 0x226352 },
	{ 0xf0e8, 0x226353 },
	{ 0xf0e9, 0x226354 },
	{ 0xf0ea, 0x226355 },
	{ 0xf0eb, 0x226356 },
	{ 0xf0ec, 0x226357 },
	{ 0xf0ed, 0x226358 },
	{ 0xf0ee, 0x226359 },
	{ 0xf0ef, 0x22635a },
	{ 0xf0f0, 0x22635b },
	{ 0xf0f1, 0x22635c },
	{ 0xf0f2, 0x22635d },
	{ 0xf0f3, 0x22635e },
	{ 0xf0f4, 0x22635f },
	{ 0xf0f5, 0x226360 },
	{ 0xf0f6, 0x226361 },
	{ 0xf0f7, 0x226362 },
	{ 0xf0f8, 0x226363 },
	{ 0xf0f9, 0x226364 },
	{ 0xf0fa, 0x226365 },
	{ 0xf0fb, 0x226366 },
	{ 0xf0fc, 0x226367 },
	{ 0xf0fd, 0x226368 },
	{ 0xf0fe, 0x226369 },
	{ 0xf140, 0x22636a },
	{ 0xf141, 0x22636b },
	{ 0xf142, 0x22636c },
	{ 0xf143, 0x22636d },
	{ 0xf144, 0x22636e },
	{ 0xf145, 0x22636f },
	{ 0xf146, 0x226370 },
	{ 0xf147, 0x226371 },
	{ 0xf148, 0x226372 },
	{ 0xf149, 0x226373 },
	{ 0xf14a, 0x226374 },
	{ 0xf14b, 0x226375 },
	{ 0xf14c, 0x226376 },
	{ 0xf14d, 0x226377 },
	{ 0xf14e, 0x226378 },
	{ 0xf14f, 0x226379 },
	{ 0xf150, 0x22637a },
	{ 0xf151, 0x22637b },
	{ 0xf152, 0x22637c },
	{ 0xf153, 0x22637d },
	{ 0xf154, 0x22637e },
	{ 0xf155, 0x226421 },
	{ 0xf156, 0x226422 },
	{ 0xf157, 0x226423 },
	{ 0xf158, 0x226424 },
	{ 0xf159, 0x226425 },
	{ 0xf15a, 0x226426 },
	{ 0xf15b, 0x226427 },
	{ 0xf15c, 0x226428 },
	{ 0xf15d, 0x226429 },
	{ 0xf15e, 0x22642a },
	{ 0xf15f, 0x22642b },
	{ 0xf160, 0x22642c },
	{ 0xf161, 0x22642d },
	{ 0xf162, 0x22642e },
	{ 0xf163, 0x226430 },
	{ 0xf164, 0x226431 },
	{ 0xf165, 0x226432 },
	{ 0xf166, 0x226433 },
	{ 0xf167, 0x226434 },
	{ 0xf168, 0x226435 },
	{ 0xf169, 0x226436 },
	{ 0xf16a, 0x226437 },
	{ 0xf16b, 0x226761 },
	{ 0xf16c, 0x226438 },
	{ 0xf16d, 0x226439 },
	{ 0xf16e, 0x22643a },
	{ 0xf16f, 0x22643b },
	{ 0xf170, 0x22643c },
	{ 0xf171, 0x22643d },
	{ 0xf172, 0x22643e },
	{ 0xf173, 0x22643f },
	{ 0xf174, 0x226440 },
	{ 0xf175, 0x226441 },
	{ 0xf176, 0x226442 },
	{ 0xf177, 0x226443 },
	{ 0xf178, 0x226444 },
	{ 0xf179, 0x226445 },
	{ 0xf17a, 0x226446 },
	{ 0xf17b, 0x226447 },
	{ 0xf17c, 0x226448 },
	{ 0xf17d, 0x226449 },
	{ 0xf17e, 0x22644a },
	{ 0xf1a1, 0x22644b },
	{ 0xf1a2, 0x22644c },
	{ 0xf1a3, 0x22644d },
	{ 0xf1a4, 0x22644e },
	{ 0xf1a5, 0x22644f },
	{ 0xf1a6, 0x226450 },
	{ 0xf1a7, 0x226451 },
	{ 0xf1a8, 0x226452 },
	{ 0xf1a9, 0x226453 },
	{ 0xf1aa, 0x226454 },
	{ 0xf1ab, 0x226455 },
	{ 0xf1ac, 0x226456 },
	{ 0xf1ad, 0x226457 },
	{ 0xf1ae, 0x226458 },
	{ 0xf1af, 0x226459 },
	{ 0xf1b0, 0x22645a },
	{ 0xf1b1, 0x22645b },
	{ 0xf1b2, 0x22645c },
	{ 0xf1b3, 0x22645d },
	{ 0xf1b4, 0x22645e },
	{ 0xf1b5, 0x22645f },
	{ 0xf1b6, 0x226460 },
	{ 0xf1b7, 0x226461 },
	{ 0xf1b8, 0x226462 },
	{ 0xf1b9, 0x226463 },
	{ 0xf1ba, 0x226464 },
	{ 0xf1bb, 0x226465 },
	{ 0xf1bc, 0x226466 },
	{ 0xf1bd, 0x226467 },
	{ 0xf1be, 0x226468 },
	{ 0xf1bf, 0x226469 },
	{ 0xf1c0, 0x22646a },
	{ 0xf1c1, 0x22646b },
	{ 0xf1c2, 0x22646c },
	{ 0xf1c3, 0x22646d },
	{ 0xf1c4, 0x22646e },
	{ 0xf1c5, 0x22646f },
	{ 0xf1c6, 0x226470 },
	{ 0xf1c7, 0x226471 },
	{ 0xf1c8, 0x226472 },
	{ 0xf1c9, 0x226473 },
	{ 0xf1ca, 0x226474 },
	{ 0xf1cb, 0x226475 },
	{ 0xf1cc, 0x226476 },
	{ 0xf1cd, 0x226477 },
	{ 0xf1ce, 0x226478 },
	{ 0xf1cf, 0x226479 },
	{ 0xf1d0, 0x22647a },
	{ 0xf1d1, 0x22647b },
	{ 0xf1d2, 0x22647c },
	{ 0xf1d3, 0x22647d },
	{ 0xf1d4, 0x22647e },
	{ 0xf1d5, 0x226521 },
	{ 0xf1d6, 0x226522 },
	{ 0xf1d7, 0x226523 },
	{ 0xf1d8, 0x226524 },
	{ 0xf1d9, 0x226525 },
	{ 0xf1da, 0x226526 },
	{ 0xf1db, 0x226527 },
	{ 0xf1dc, 0x226528 },
	{ 0xf1dd, 0x226529 },
	{ 0xf1de, 0x22652a },
	{ 0xf1df, 0x22652b },
	{ 0xf1e0, 0x22652c },
	{ 0xf1e1, 0x22652d },
	{ 0xf1e2, 0x22652e },
	{ 0xf1e3, 0x22652f },
	{ 0xf1e4, 0x226530 },
	{ 0xf1e5, 0x226531 },
	{ 0xf1e6, 0x226532 },
	{ 0xf1e7, 0x226533 },
	{ 0xf1e8, 0x226534 },
	{ 0xf1e9, 0x226535 },
	{ 0xf1ea, 0x226536 },
	{ 0xf1eb, 0x226537 },
	{ 0xf1ec, 0x226538 },
	{ 0xf1ed, 0x226539 },
	{ 0xf1ee, 0x22653a },
	{ 0xf1ef, 0x22653b },
	{ 0xf1f0, 0x22653c },
	{ 0xf1f1, 0x22653d },
	{ 0xf1f2, 0x22653e },
	{ 0xf1f3, 0x22653f },
	{ 0xf1f4, 0x226540 },
	{ 0xf1f5, 0x226541 },
	{ 0xf1f6, 0x226542 },
	{ 0xf1f7, 0x226543 },
	{ 0xf1f8, 0x226544 },
	{ 0xf1f9, 0x226545 },
	{ 0xf1fa, 0x226546 },
	{ 0xf1fb, 0x226547 },
	{ 0xf1fc, 0x226548 },
	{ 0xf1fd, 0x226549 },
	{ 0xf1fe, 0x22654a },
	{ 0xf240, 0x22654b },
	{ 0xf241, 0x22654c },
	{ 0xf242, 0x22654d },
	{ 0xf243, 0x22654e },
	{ 0xf244, 0x22654f },
	{ 0xf245, 0x226550 },
	{ 0xf246, 0x226551 },
	{ 0xf247, 0x226552 },
	{ 0xf248, 0x226553 },
	{ 0xf249, 0x226554 },
	{ 0xf24a, 0x226555 },
	{ 0xf24b, 0x226556 },
	{ 0xf24c, 0x226557 },
	{ 0xf24d, 0x226558 },
	{ 0xf24e, 0x226559 },
	{ 0xf24f, 0x22655a },
	{ 0xf250, 0x22655b },
	{ 0xf251, 0x22655c },
	{ 0xf252, 0x22655d },
	{ 0xf253, 0x22655e },
	{ 0xf254, 0x22655f },
	{ 0xf255, 0x226560 },
	{ 0xf256, 0x226561 },
	{ 0xf257, 0x226562 },
	{ 0xf258, 0x226563 },
	{ 0xf259, 0x226564 },
	{ 0xf25a, 0x226565 },
	{ 0xf25b, 0x226566 },
	{ 0xf25c, 0x226567 },
	{ 0xf25d, 0x226568 },
	{ 0xf25e, 0x226569 },
	{ 0xf25f, 0x22656a },
	{ 0xf260, 0x22656b },
	{ 0xf261, 0x22656c },
	{ 0xf262, 0x22656d },
	{ 0xf263, 0x22656e },
	{ 0xf264, 0x22656f },
	{ 0xf265, 0x226570 },
	{ 0xf266, 0x226571 },
	{ 0xf267, 0x226572 },
	{ 0xf268, 0x226934 },
	{ 0xf269, 0x226573 },
	{ 0xf26a, 0x226574 },
	{ 0xf26b, 0x226575 },
	{ 0xf26c, 0x226576 },
	{ 0xf26d, 0x226577 },
	{ 0xf26e, 0x226578 },
	{ 0xf26f, 0x226579 },
	{ 0xf270, 0x22657a },
	{ 0xf271, 0x22657b },
	{ 0xf272, 0x22657c },
	{ 0xf273, 0x22657d },
	{ 0xf274, 0x22657e },
	{ 0xf275, 0x226621 },
	{ 0xf276, 0x226622 },
	{ 0xf277, 0x226623 },
	{ 0xf278, 0x226624 },
	{ 0xf279, 0x226625 },
	{ 0xf27a, 0x226626 },
	{ 0xf27b, 0x226627 },
	{ 0xf27c, 0x226628 },
	{ 0xf27d, 0x226629 },
	{ 0xf27e, 0x22662a },
	{ 0xf2a1, 0x22662b },
	{ 0xf2a2, 0x22662c },
	{ 0xf2a3, 0x22662d },
	{ 0xf2a4, 0x22662e },
	{ 0xf2a5, 0x22662f },
	{ 0xf2a6, 0x226630 },
	{ 0xf2a7, 0x226631 },
	{ 0xf2a8, 0x226632 },
	{ 0xf2a9, 0x226633 },
	{ 0xf2aa, 0x226634 },
	{ 0xf2ab, 0x226635 },
	{ 0xf2ac, 0x226636 },
	{ 0xf2ad, 0x226637 },
	{ 0xf2ae, 0x226638 },
	{ 0xf2af, 0x226639 },
	{ 0xf2b0, 0x22663a },
	{ 0xf2b1, 0x22663b },
	{ 0xf2b2, 0x22663c },
	{ 0xf2b3, 0x22663d },
	{ 0xf2b4, 0x22663e },
	{ 0xf2b5, 0x22663f },
	{ 0xf2b6, 0x226640 },
	{ 0xf2b7, 0x226641 },
	{ 0xf2b8, 0x226642 },
	{ 0xf2b9, 0x226643 },
	{ 0xf2ba, 0x226644 },
	{ 0xf2bb, 0x226645 },
	{ 0xf2bc, 0x226646 },
	{ 0xf2bd, 0x226647 },
	{ 0xf2be, 0x226648 },
	{ 0xf2bf, 0x226649 },
	{ 0xf2c0, 0x22664a },
	{ 0xf2c1, 0x22664b },
	{ 0xf2c2, 0x22664c },
	{ 0xf2c3, 0x22664e },
	{ 0xf2c4, 0x22664f },
	{ 0xf2c5, 0x226650 },
	{ 0xf2c6, 0x226651 },
	{ 0xf2c7, 0x226652 },
	{ 0xf2c8, 0x226653 },
	{ 0xf2c9, 0x226654 },
	{ 0xf2ca, 0x226655 },
	{ 0xf2cb, 0x226656 },
	{ 0xf2cc, 0x226657 },
	{ 0xf2cd, 0x226658 },
	{ 0xf2ce, 0x226659 },
	{ 0xf2cf, 0x22665a },
	{ 0xf2d0, 0x22665b },
	{ 0xf2d1, 0x22665c },
	{ 0xf2d2, 0x22665d },
	{ 0xf2d3, 0x22665e },
	{ 0xf2d4, 0x22665f },
	{ 0xf2d5, 0x226660 },
	{ 0xf2d6, 0x226661 },
	{ 0xf2d7, 0x226662 },
	{ 0xf2d8, 0x226663 },
	{ 0xf2d9, 0x226664 },
	{ 0xf2da, 0x226665 },
	{ 0xf2db, 0x226666 },
	{ 0xf2dc, 0x226667 },
	{ 0xf2dd, 0x226668 },
	{ 0xf2de, 0x226669 },
	{ 0xf2df, 0x22666a },
	{ 0xf2e0, 0x22666b },
	{ 0xf2e1, 0x22666c },
	{ 0xf2e2, 0x22666d },
	{ 0xf2e3, 0x22666e },
	{ 0xf2e4, 0x22666f },
	{ 0xf2e5, 0x226670 },
	{ 0xf2e6, 0x226671 },
	{ 0xf2e7, 0x226672 },
	{ 0xf2e8, 0x226673 },
	{ 0xf2e9, 0x226674 },
	{ 0xf2ea, 0x226675 },
	{ 0xf2eb, 0x226676 },
	{ 0xf2ec, 0x226677 },
	{ 0xf2ed, 0x226678 },
	{ 0xf2ee, 0x226679 },
	{ 0xf2ef, 0x22667a },
	{ 0xf2f0, 0x22667b },
	{ 0xf2f1, 0x22667c },
	{ 0xf2f2, 0x22667d },
	{ 0xf2f3, 0x22667e },
	{ 0xf2f4, 0x226721 },
	{ 0xf2f5, 0x226722 },
	{ 0xf2f6, 0x226723 },
	{ 0xf2f7, 0x226724 },
	{ 0xf2f8, 0x226725 },
	{ 0xf2f9, 0x226726 },
	{ 0xf2fa, 0x226727 },
	{ 0xf2fb, 0x226728 },
	{ 0xf2fc, 0x226729 },
	{ 0xf2fd, 0x22672a },
	{ 0xf2fe, 0x22672b },
	{ 0xf340, 0x22672c },
	{ 0xf341, 0x22672d },
	{ 0xf342, 0x22672e },
	{ 0xf343, 0x22672f },
	{ 0xf344, 0x226730 },
	{ 0xf345, 0x226731 },
	{ 0xf346, 0x226732 },
	{ 0xf347, 0x226733 },
	{ 0xf348, 0x226734 },
	{ 0xf349, 0x226735 },
	{ 0xf34a, 0x226736 },
	{ 0xf34b, 0x226737 },
	{ 0xf34c, 0x226738 },
	{ 0xf34d, 0x226739 },
	{ 0xf34e, 0x22673a },
	{ 0xf34f, 0x22673b },
	{ 0xf350, 0x22673c },
	{ 0xf351, 0x22673d },
	{ 0xf352, 0x22673e },
	{ 0xf353, 0x22673f },
	{ 0xf354, 0x226740 },
	{ 0xf355, 0x226741 },
	{ 0xf356, 0x226742 },
	{ 0xf357, 0x226743 },
	{ 0xf358, 0x226744 },
	{ 0xf359, 0x226745 },
	{ 0xf35a, 0x226746 },
	{ 0xf35b, 0x226747 },
	{ 0xf35c, 0x226748 },
	{ 0xf35d, 0x226749 },
	{ 0xf35e, 0x22674a },
	{ 0xf35f, 0x22674b },
	{ 0xf360, 0x22674c },
	{ 0xf361, 0x22674d },
	{ 0xf362, 0x22674e },
	{ 0xf363, 0x22674f },
	{ 0xf364, 0x226750 },
	{ 0xf365, 0x226751 },
	{ 0xf366, 0x226752 },
	{ 0xf367, 0x226753 },
	{ 0xf368, 0x226754 },
	{ 0xf369, 0x226755 },
	{ 0xf36a, 0x226756 },
	{ 0xf36b, 0x226757 },
	{ 0xf36c, 0x226758 },
	{ 0xf36d, 0x226759 },
	{ 0xf36e, 0x22675a },
	{ 0xf36f, 0x22675b },
	{ 0xf370, 0x22675c },
	{ 0xf371, 0x22675d },
	{ 0xf372, 0x22675e },
	{ 0xf373, 0x22675f },
	{ 0xf374, 0x226760 },
	{ 0xf375, 0x226762 },
	{ 0xf376, 0x226763 },
	{ 0xf377, 0x226764 },
	{ 0xf378, 0x226765 },
	{ 0xf379, 0x226766 },
	{ 0xf37a, 0x226767 },
	{ 0xf37b, 0x226768 },
	{ 0xf37c, 0x226769 },
	{ 0xf37d, 0x22676a },
	{ 0xf37e, 0x22676b },
	{ 0xf3a1, 0x22676c },
	{ 0xf3a2, 0x22676d },
	{ 0xf3a3, 0x22676e },
	{ 0xf3a4, 0x22676f },
	{ 0xf3a5, 0x226770 },
	{ 0xf3a6, 0x226771 },
	{ 0xf3a7, 0x226772 },
	{ 0xf3a8, 0x226773 },
	{ 0xf3a9, 0x226774 },
	{ 0xf3aa, 0x226775 },
	{ 0xf3ab, 0x226776 },
	{ 0xf3ac, 0x226777 },
	{ 0xf3ad, 0x226778 },
	{ 0xf3ae, 0x226779 },
	{ 0xf3af, 0x22677a },
	{ 0xf3b0, 0x22677b },
	{ 0xf3b1, 0x22677c },
	{ 0xf3b2, 0x22677d },
	{ 0xf3b3, 0x22677e },
	{ 0xf3b4, 0x226821 },
	{ 0xf3b5, 0x226822 },
	{ 0xf3b6, 0x226823 },
	{ 0xf3b7, 0x226824 },
	{ 0xf3b8, 0x226825 },
	{ 0xf3b9, 0x226826 },
	{ 0xf3ba, 0x226827 },
	{ 0xf3bb, 0x226828 },
	{ 0xf3bc, 0x226829 },
	{ 0xf3bd, 0x22682a },
	{ 0xf3be, 0x22682b },
	{ 0xf3bf, 0x22682c },
	{ 0xf3c0, 0x22682d },
	{ 0xf3c1, 0x22682e },
	{ 0xf3c2, 0x22682f },
	{ 0xf3c3, 0x226830 },
	{ 0xf3c4, 0x226831 },
	{ 0xf3c5, 0x226832 },
	{ 0xf3c6, 0x226833 },
	{ 0xf3c7, 0x226834 },
	{ 0xf3c8, 0x226835 },
	{ 0xf3c9, 0x226836 },
	{ 0xf3ca, 0x226837 },
	{ 0xf3cb, 0x226838 },
	{ 0xf3cc, 0x226839 },
	{ 0xf3cd, 0x22683a },
	{ 0xf3ce, 0x22683b },
	{ 0xf3cf, 0x22683c },
	{ 0xf3d0, 0x22683d },
	{ 0xf3d1, 0x22683e },
	{ 0xf3d2, 0x22683f },
	{ 0xf3d3, 0x226840 },
	{ 0xf3d4, 0x226841 },
	{ 0xf3d5, 0x226842 },
	{ 0xf3d6, 0x226843 },
	{ 0xf3d7, 0x226844 },
	{ 0xf3d8, 0x226845 },
	{ 0xf3d9, 0x226846 },
	{ 0xf3da, 0x226847 },
	{ 0xf3db, 0x226848 },
	{ 0xf3dc, 0x226849 },
	{ 0xf3dd, 0x22684a },
	{ 0xf3de, 0x22684b },
	{ 0xf3df, 0x22684c },
	{ 0xf3e0, 0x22684d },
	{ 0xf3e1, 0x22684e },
	{ 0xf3e2, 0x22684f },
	{ 0xf3e3, 0x226850 },
	{ 0xf3e4, 0x226851 },
	{ 0xf3e5, 0x226852 },
	{ 0xf3e6, 0x226853 },
	{ 0xf3e7, 0x226854 },
	{ 0xf3e8, 0x226855 },
	{ 0xf3e9, 0x226856 },
	{ 0xf3ea, 0x226857 },
	{ 0xf3eb, 0x226858 },
	{ 0xf3ec, 0x226859 },
	{ 0xf3ed, 0x22685a },
	{ 0xf3ee, 0x22685b },
	{ 0xf3ef, 0x22685c },
	{ 0xf3f0, 0x22685d },
	{ 0xf3f1, 0x22685e },
	{ 0xf3f2, 0x22685f },
	{ 0xf3f3, 0x226860 },
	{ 0xf3f4, 0x226861 },
	{ 0xf3f5, 0x226862 },
	{ 0xf3f6, 0x226863 },
	{ 0xf3f7, 0x226864 },
	{ 0xf3f8, 0x226865 },
	{ 0xf3f9, 0x226866 },
	{ 0xf3fa, 0x226867 },
	{ 0xf3fb, 0x226868 },
	{ 0xf3fc, 0x226869 },
	{ 0xf3fd, 0x22686a },
	{ 0xf3fe, 0x22686b },
	{ 0xf440, 0x22686c },
	{ 0xf441, 0x22686d },
	{ 0xf442, 0x22686e },
	{ 0xf443, 0x22686f },
	{ 0xf444, 0x226870 },
	{ 0xf445, 0x226871 },
	{ 0xf446, 0x226872 },
	{ 0xf447, 0x226873 },
	{ 0xf448, 0x226874 },
	{ 0xf449, 0x226875 },
	{ 0xf44a, 0x226876 },
	{ 0xf44b, 0x226877 },
	{ 0xf44c, 0x226878 },
	{ 0xf44d, 0x226879 },
	{ 0xf44e, 0x22687a },
	{ 0xf44f, 0x22687b },
	{ 0xf450, 0x22687c },
	{ 0xf451, 0x22687d },
	{ 0xf452, 0x22687e },
	{ 0xf453, 0x226921 },
	{ 0xf454, 0x226922 },
	{ 0xf455, 0x226923 },
	{ 0xf456, 0x226924 },
	{ 0xf457, 0x226925 },
	{ 0xf458, 0x226926 },
	{ 0xf459, 0x226927 },
	{ 0xf45a, 0x226928 },
	{ 0xf45b, 0x226929 },
	{ 0xf45c, 0x22692a },
	{ 0xf45d, 0x22692b },
	{ 0xf45e, 0x22692c },
	{ 0xf45f, 0x22692d },
	{ 0xf460, 0x22692e },
	{ 0xf461, 0x22692f },
	{ 0xf462, 0x226930 },
	{ 0xf463, 0x226931 },
	{ 0xf464, 0x226932 },
	{ 0xf465, 0x226933 },
	{ 0xf466, 0x226935 },
	{ 0xf467, 0x226936 },
	{ 0xf468, 0x226937 },
	{ 0xf469, 0x226938 },
	{ 0xf46a, 0x226939 },
	{ 0xf46b, 0x22693a },
	{ 0xf46c, 0x22693b },
	{ 0xf46d, 0x22693c },
	{ 0xf46e, 0x22693d },
	{ 0xf46f, 0x22693e },
	{ 0xf470, 0x22693f },
	{ 0xf471, 0x226940 },
	{ 0xf472, 0x226941 },
	{ 0xf473, 0x226942 },
	{ 0xf474, 0x226943 },
	{ 0xf475, 0x226944 },
	{ 0xf476, 0x226945 },
	{ 0xf477, 0x226946 },
	{ 0xf478, 0x226947 },
	{ 0xf479, 0x226948 },
	{ 0xf47a, 0x226949 },
	{ 0xf47b, 0x22694a },
	{ 0xf47c, 0x22694b },
	{ 0xf47d, 0x22694c },
	{ 0xf47e, 0x22694d },
	{ 0xf4a1, 0x22694e },
	{ 0xf4a2, 0x22694f },
	{ 0xf4a3, 0x226950 },
	{ 0xf4a4, 0x226951 },
	{ 0xf4a5, 0x226952 },
	{ 0xf4a6, 0x226953 },
	{ 0xf4a7, 0x226954 },
	{ 0xf4a8, 0x226955 },
	{ 0xf4a9, 0x226956 },
	{ 0xf4aa, 0x226957 },
	{ 0xf4ab, 0x226958 },
	{ 0xf4ac, 0x226959 },
	{ 0xf4ad, 0x22695a },
	{ 0xf4ae, 0x22695b },
	{ 0xf4af, 0x22695c },
	{ 0xf4b0, 0x22695d },
	{ 0xf4b1, 0x22695e },
	{ 0xf4b2, 0x22695f },
	{ 0xf4b3, 0x226960 },
	{ 0xf4b4, 0x226961 },
	{ 0xf4b5, 0x22664d },
	{ 0xf4b6, 0x226962 },
	{ 0xf4b7, 0x226963 },
	{ 0xf4b8, 0x226964 },
	{ 0xf4b9, 0x226965 },
	{ 0xf4ba, 0x226966 },
	{ 0xf4bb, 0x226967 },
	{ 0xf4bc, 0x226968 },
	{ 0xf4bd, 0x226969 },
	{ 0xf4be, 0x22696a },
	{ 0xf4bf, 0x22696b },
	{ 0xf4c0, 0x22696c },
	{ 0xf4c1, 0x22696d },
	{ 0xf4c2, 0x22696e },
	{ 0xf4c3, 0x22696f },
	{ 0xf4c4, 0x226970 },
	{ 0xf4c5, 0x226971 },
	{ 0xf4c6, 0x226972 },
	{ 0xf4c7, 0x226973 },
	{ 0xf4c8, 0x226974 },
	{ 0xf4c9, 0x226975 },
	{ 0xf4ca, 0x226976 },
	{ 0xf4cb, 0x226977 },
	{ 0xf4cc, 0x226978 },
	{ 0xf4cd, 0x226979 },
	{ 0xf4ce, 0x22697a },
	{ 0xf4cf, 0x22697b },
	{ 0xf4d0, 0x22697c },
	{ 0xf4d1, 0x22697d },
	{ 0xf4d2, 0x22697e },
	{ 0xf4d3, 0x226a21 },
	{ 0xf4d4, 0x226a22 },
	{ 0xf4d5, 0x226a23 },
	{ 0xf4d6, 0x226a24 },
	{ 0xf4d7, 0x226a25 },
	{ 0xf4d8, 0x226a26 },
	{ 0xf4d9, 0x226a27 },
	{ 0xf4da, 0x226a28 },
	{ 0xf4db, 0x226a29 },
	{ 0xf4dc, 0x226a2a },
	{ 0xf4dd, 0x226a2b },
	{ 0xf4de, 0x226a2c },
	{ 0xf4df, 0x226a2d },
	{ 0xf4e0, 0x226a2e },
	{ 0xf4e1, 0x226a2f },
	{ 0xf4e2, 0x226a30 },
	{ 0xf4e3, 0x226a31 },
	{ 0xf4e4, 0x226a32 },
	{ 0xf4e5, 0x226a33 },
	{ 0xf4e6, 0x226a34 },
	{ 0xf4e7, 0x226a35 },
	{ 0xf4e8, 0x226a36 },
	{ 0xf4e9, 0x226a37 },
	{ 0xf4ea, 0x226a38 },
	{ 0xf4eb, 0x226a39 },
	{ 0xf4ec, 0x226a3a },
	{ 0xf4ed, 0x226a3b },
	{ 0xf4ee, 0x226a3c },
	{ 0xf4ef, 0x226a3d },
	{ 0xf4f0, 0x226a3e },
	{ 0xf4f1, 0x226a3f },
	{ 0xf4f2, 0x226a40 },
	{ 0xf4f3, 0x226a41 },
	{ 0xf4f4, 0x226a42 },
	{ 0xf4f5, 0x226a43 },
	{ 0xf4f6, 0x226a44 },
	{ 0xf4f7, 0x226a45 },
	{ 0xf4f8, 0x226a46 },
	{ 0xf4f9, 0x226a47 },
	{ 0xf4fa, 0x226a48 },
	{ 0xf4fb, 0x226a49 },
	{ 0xf4fc, 0x226a4a },
	{ 0xf4fd, 0x226a4c },
	{ 0xf4fe, 0x226a4d },
	{ 0xf540, 0x226a4e },
	{ 0xf541, 0x226a4f },
	{ 0xf542, 0x226a50 },
	{ 0xf543, 0x226a51 },
	{ 0xf544, 0x226a52 },
	{ 0xf545, 0x226a53 },
	{ 0xf546, 0x226a54 },
	{ 0xf547, 0x226a55 },
	{ 0xf548, 0x226a56 },
	{ 0xf549, 0x226a57 },
	{ 0xf54a, 0x226a58 },
	{ 0xf54b, 0x226a59 },
	{ 0xf54c, 0x226a5a },
	{ 0xf54d, 0x226a5b },
	{ 0xf54e, 0x226a5c },
	{ 0xf54f, 0x226a5d },
	{ 0xf550, 0x226a5e },
	{ 0xf551, 0x226a5f },
	{ 0xf552, 0x226a60 },
	{ 0xf553, 0x226a61 },
	{ 0xf554, 0x226a62 },
	{ 0xf555, 0x226a63 },
	{ 0xf556, 0x226a64 },
	{ 0xf557, 0x226a65 },
	{ 0xf558, 0x226a66 },
	{ 0xf559, 0x226a67 },
	{ 0xf55a, 0x226a68 },
	{ 0xf55b, 0x226a69 },
	{ 0xf55c, 0x226a6a },
	{ 0xf55d, 0x226a6b },
	{ 0xf55e, 0x226a6c },
	{ 0xf55f, 0x226a6d },
	{ 0xf560, 0x226a6e },
	{ 0xf561, 0x226a6f },
	{ 0xf562, 0x226a70 },
	{ 0xf563, 0x226a71 },
	{ 0xf564, 0x226a72 },
	{ 0xf565, 0x226a73 },
	{ 0xf566, 0x226a74 },
	{ 0xf567, 0x226a75 },
	{ 0xf568, 0x226a76 },
	{ 0xf569, 0x226a77 },
	{ 0xf56a, 0x226a78 },
	{ 0xf56b, 0x226a79 },
	{ 0xf56c, 0x226a7a },
	{ 0xf56d, 0x226a7b },
	{ 0xf56e, 0x226a7c },
	{ 0xf56f, 0x226a7d },
	{ 0xf570, 0x226a7e },
	{ 0xf571, 0x226b21 },
	{ 0xf572, 0x226b22 },
	{ 0xf573, 0x226b23 },
	{ 0xf574, 0x226b24 },
	{ 0xf575, 0x226b25 },
	{ 0xf576, 0x226b26 },
	{ 0xf577, 0x226b27 },
	{ 0xf578, 0x226b28 },
	{ 0xf579, 0x226b29 },
	{ 0xf57a, 0x226b2a },
	{ 0xf57b, 0x226b2b },
	{ 0xf57c, 0x226b2c },
	{ 0xf57d, 0x226b2d },
	{ 0xf57e, 0x226b2e },
	{ 0xf5a1, 0x226b2f },
	{ 0xf5a2, 0x226b30 },
	{ 0xf5a3, 0x226b31 },
	{ 0xf5a4, 0x226b32 },
	{ 0xf5a5, 0x226b33 },
	{ 0xf5a6, 0x226b34 },
	{ 0xf5a7, 0x226b35 },
	{ 0xf5a8, 0x226b36 },
	{ 0xf5a9, 0x226b37 },
	{ 0xf5aa, 0x226b38 },
	{ 0xf5ab, 0x226b39 },
	{ 0xf5ac, 0x226b3a },
	{ 0xf5ad, 0x226b3b },
	{ 0xf5ae, 0x226b3c },
	{ 0xf5af, 0x226b3d },
	{ 0xf5b0, 0x226b3e },
	{ 0xf5b1, 0x226b3f },
	{ 0xf5b2, 0x226b40 },
	{ 0xf5b3, 0x226b41 },
	{ 0xf5b4, 0x226b42 },
	{ 0xf5b5, 0x226b43 },
	{ 0xf5b6, 0x226b44 },
	{ 0xf5b7, 0x226b45 },
	{ 0xf5b8, 0x226b46 },
	{ 0xf5b9, 0x226b47 },
	{ 0xf5ba, 0x226b48 },
	{ 0xf5bb, 0x226b49 },
	{ 0xf5bc, 0x226b4a },
	{ 0xf5bd, 0x226b4b },
	{ 0xf5be, 0x226b4c },
	{ 0xf5bf, 0x226b4d },
	{ 0xf5c0, 0x226b4e },
	{ 0xf5c1, 0x226b4f },
	{ 0xf5c2, 0x226b50 },
	{ 0xf5c3, 0x226b51 },
	{ 0xf5c4, 0x226b52 },
	{ 0xf5c5, 0x226b53 },
	{ 0xf5c6, 0x226b54 },
	{ 0xf5c7, 0x226b55 },
	{ 0xf5c8, 0x226b56 },
	{ 0xf5c9, 0x226b57 },
	{ 0xf5ca, 0x226b58 },
	{ 0xf5cb, 0x226b59 },
	{ 0xf5cc, 0x226b5a },
	{ 0xf5cd, 0x226b5b },
	{ 0xf5ce, 0x226b5c },
	{ 0xf5cf, 0x226b5d },
	{ 0xf5d0, 0x226b5e },
	{ 0xf5d1, 0x226b5f },
	{ 0xf5d2, 0x226b60 },
	{ 0xf5d3, 0x226b61 },
	{ 0xf5d4, 0x226b62 },
	{ 0xf5d5, 0x226b63 },
	{ 0xf5d6, 0x226b64 },
	{ 0xf5d7, 0x226b65 },
	{ 0xf5d8, 0x226b66 },
	{ 0xf5d9, 0x226b67 },
	{ 0xf5da, 0x226b68 },
	{ 0xf5db, 0x226b69 },
	{ 0xf5dc, 0x226b6a },
	{ 0xf5dd, 0x226b6b },
	{ 0xf5de, 0x226b6c },
	{ 0xf5df, 0x226b6d },
	{ 0xf5e0, 0x226b6e },
	{ 0xf5e1, 0x226b6f },
	{ 0xf5e2, 0x226b70 },
	{ 0xf5e3, 0x226b71 },
	{ 0xf5e4, 0x226b72 },
	{ 0xf5e5, 0x226b73 },
	{ 0xf5e6, 0x226b74 },
	{ 0xf5e7, 0x226b75 },
	{ 0xf5e8, 0x226b76 },
	{ 0xf5e9, 0x226b77 },
	{ 0xf5ea, 0x226b78 },
	{ 0xf5eb, 0x226b79 },
	{ 0xf5ec, 0x226b7a },
	{ 0xf5ed, 0x226b7b },
	{ 0xf5ee, 0x226b7c },
	{ 0xf5ef, 0x226b7d },
	{ 0xf5f0, 0x226b7e },
	{ 0xf5f1, 0x226c21 },
	{ 0xf5f2, 0x226c22 },
	{ 0xf5f3, 0x226c23 },
	{ 0xf5f4, 0x226c24 },
	{ 0xf5f5, 0x226c25 },
	{ 0xf5f6, 0x226c26 },
	{ 0xf5f7, 0x226c27 },
	{ 0xf5f8, 0x226c28 },
	{ 0xf5f9, 0x226c29 },
	{ 0xf5fa, 0x226c2a },
	{ 0xf5fb, 0x226c2b },
	{ 0xf5fc, 0x226c2c },
	{ 0xf5fd, 0x226c2d },
	{ 0xf5fe, 0x226c2e },
	{ 0xf640, 0x226c2f },
	{ 0xf641, 0x226c30 },
	{ 0xf642, 0x226c31 },
	{ 0xf643, 0x226c32 },
	{ 0xf644, 0x226c33 },
	{ 0xf645, 0x226c34 },
	{ 0xf646, 0x226c35 },
	{ 0xf647, 0x226c36 },
	{ 0xf648, 0x226c37 },
	{ 0xf649, 0x226c38 },
	{ 0xf64a, 0x226c39 },
	{ 0xf64b, 0x226c3a },
	{ 0xf64c, 0x226c3b },
	{ 0xf64d, 0x226c3c },
	{ 0xf64e, 0x226c3d },
	{ 0xf64f, 0x226c3e },
	{ 0xf650, 0x226c3f },
	{ 0xf651, 0x226c40 },
	{ 0xf652, 0x226c41 },
	{ 0xf653, 0x226c42 },
	{ 0xf654, 0x226c43 },
	{ 0xf655, 0x226c44 },
	{ 0xf656, 0x226c45 },
	{ 0xf657, 0x226c46 },
	{ 0xf658, 0x226c47 },
	{ 0xf659, 0x226c48 },
	{ 0xf65a, 0x226c49 },
	{ 0xf65b, 0x226c4a },
	{ 0xf65c, 0x226c4b },
	{ 0xf65d, 0x226c4c },
	{ 0xf65e, 0x226c4d },
	{ 0xf65f, 0x226c4e },
	{ 0xf660, 0x226c4f },
	{ 0xf661, 0x226c50 },
	{ 0xf662, 0x226c51 },
	{ 0xf663, 0x226a4b },
	{ 0xf664, 0x226c52 },
	{ 0xf665, 0x226c53 },
	{ 0xf666, 0x226c54 },
	{ 0xf667, 0x226c55 },
	{ 0xf668, 0x226c56 },
	{ 0xf669, 0x226c57 },
	{ 0xf66a, 0x226c58 },
	{ 0xf66b, 0x226c59 },
	{ 0xf66c, 0x226c5a },
	{ 0xf66d, 0x226c5b },
	{ 0xf66e, 0x226c5c },
	{ 0xf66f, 0x226c5d },
	{ 0xf670, 0x226c5e },
	{ 0xf671, 0x226c5f },
	{ 0xf672, 0x226c60 },
	{ 0xf673, 0x226c61 },
	{ 0xf674, 0x226c62 },
	{ 0xf675, 0x226c63 },
	{ 0xf676, 0x226c64 },
	{ 0xf677, 0x226c65 },
	{ 0xf678, 0x226c66 },
	{ 0xf679, 0x226c67 },
	{ 0xf67a, 0x226c68 },
	{ 0xf67b, 0x226c69 },
	{ 0xf67c, 0x226c6a },
	{ 0xf67d, 0x226c6b },
	{ 0xf67e, 0x226c6c },
	{ 0xf6a1, 0x226c6d },
	{ 0xf6a2, 0x226c6e },
	{ 0xf6a3, 0x226c6f },
	{ 0xf6a4, 0x226c70 },
	{ 0xf6a5, 0x226c71 },
	{ 0xf6a6, 0x226c72 },
	{ 0xf6a7, 0x226c73 },
	{ 0xf6a8, 0x226c74 },
	{ 0xf6a9, 0x226c75 },
	{ 0xf6aa, 0x226c76 },
	{ 0xf6ab, 0x226c77 },
	{ 0xf6ac, 0x226c78 },
	{ 0xf6ad, 0x226c79 },
	{ 0xf6ae, 0x226c7a },
	{ 0xf6af, 0x226c7b },
	{ 0xf6b0, 0x226c7c },
	{ 0xf6b1, 0x226c7d },
	{ 0xf6b2, 0x226c7e },
	{ 0xf6b3, 0x226d21 },
	{ 0xf6b4, 0x226d22 },
	{ 0xf6b5, 0x226d23 },
	{ 0xf6b6, 0x226d24 },
	{ 0xf6b7, 0x226d25 },
	{ 0xf6b8, 0x226d26 },
	{ 0xf6b9, 0x226d27 },
	{ 0xf6ba, 0x226d28 },
	{ 0xf6bb, 0x226d29 },
	{ 0xf6bc, 0x226d2a },
	{ 0xf6bd, 0x226d2b },
	{ 0xf6be, 0x226d2c },
	{ 0xf6bf, 0x226d2d },
	{ 0xf6c0, 0x226d2e },
	{ 0xf6c1, 0x226d2f },
	{ 0xf6c2, 0x226d30 },
	{ 0xf6c3, 0x226d31 },
	{ 0xf6c4, 0x226d32 },
	{ 0xf6c5, 0x226d33 },
	{ 0xf6c6, 0x226d34 },
	{ 0xf6c7, 0x226d35 },
	{ 0xf6c8, 0x226d36 },
	{ 0xf6c9, 0x226d37 },
	{ 0xf6ca, 0x226d38 },
	{ 0xf6cb, 0x226d39 },
	{ 0xf6cc, 0x226d3a },
	{ 0xf6cd, 0x226d3b },
	{ 0xf6ce, 0x226d3c },
	{ 0xf6cf, 0x226d3d },
	{ 0xf6d0, 0x226d3e },
	{ 0xf6d1, 0x226d3f },
	{ 0xf6d2, 0x226d40 },
	{ 0xf6d3, 0x226d41 },
	{ 0xf6d4, 0x226d42 },
	{ 0xf6d5, 0x226d43 },
	{ 0xf6d6, 0x226d44 },
	{ 0xf6d7, 0x226d45 },
	{ 0xf6d8, 0x226d46 },
	{ 0xf6d9, 0x226d47 },
	{ 0xf6da, 0x226d48 },
	{ 0xf6db, 0x226d49 },
	{ 0xf6dc, 0x226d4a },
	{ 0xf6dd, 0x226d4b },
	{ 0xf6de, 0x226d4c },
	{ 0xf6df, 0x226d4d },
	{ 0xf6e0, 0x226d4e },
	{ 0xf6e1, 0x226d4f },
	{ 0xf6e2, 0x226d50 },
	{ 0xf6e3, 0x226d51 },
	{ 0xf6e4, 0x226d52 },
	{ 0xf6e5, 0x226d53 },
	{ 0xf6e6, 0x226d54 },
	{ 0xf6e7, 0x226d55 },
	{ 0xf6e8, 0x226d56 },
	{ 0xf6e9, 0x226d57 },
	{ 0xf6ea, 0x226d58 },
	{ 0xf6eb, 0x226d59 },
	{ 0xf6ec, 0x226d5a },
	{ 0xf6ed, 0x226d5b },
	{ 0xf6ee, 0x226d5c },
	{ 0xf6ef, 0x226d5d },
	{ 0xf6f0, 0x226d5e },
	{ 0xf6f1, 0x226d5f },
	{ 0xf6f2, 0x226d60 },
	{ 0xf6f3, 0x226d61 },
	{ 0xf6f4, 0x226d62 },
	{ 0xf6f5, 0x226d63 },
	{ 0xf6f6, 0x226d64 },
	{ 0xf6f7, 0x226d65 },
	{ 0xf6f8, 0x226d66 },
	{ 0xf6f9, 0x226d67 },
	{ 0xf6fa, 0x226d68 },
	{ 0xf6fb, 0x226d69 },
	{ 0xf6fc, 0x226d6a },
	{ 0xf6fd, 0x226d6b },
	{ 0xf6fe, 0x226d6c },
	{ 0xf740, 0x226d6d },
	{ 0xf741, 0x226d6e },
	{ 0xf742, 0x226d6f },
	{ 0xf743, 0x226d70 },
	{ 0xf744, 0x226d71 },
	{ 0xf745, 0x226d72 },
	{ 0xf746, 0x226d73 },
	{ 0xf747, 0x226d74 },
	{ 0xf748, 0x226d75 },
	{ 0xf749, 0x226d76 },
	{ 0xf74a, 0x226d77 },
	{ 0xf74b, 0x226d78 },
	{ 0xf74c, 0x226d79 },
	{ 0xf74d, 0x226d7a },
	{ 0xf74e, 0x226d7b },
	{ 0xf74f, 0x226d7c },
	{ 0xf750, 0x226d7d },
	{ 0xf751, 0x226d7e },
	{ 0xf752, 0x226e21 },
	{ 0xf753, 0x226e22 },
	{ 0xf754, 0x226e23 },
	{ 0xf755, 0x226e24 },
	{ 0xf756, 0x226e25 },
	{ 0xf757, 0x226e26 },
	{ 0xf758, 0x226e27 },
	{ 0xf759, 0x226e28 },
	{ 0xf75a, 0x226e29 },
	{ 0xf75b, 0x226e2a },
	{ 0xf75c, 0x226e2b },
	{ 0xf75d, 0x226e2c },
	{ 0xf75e, 0x226e2d },
	{ 0xf75f, 0x226e2e },
	{ 0xf760, 0x226e2f },
	{ 0xf761, 0x226e30 },
	{ 0xf762, 0x226e31 },
	{ 0xf763, 0x226e32 },
	{ 0xf764, 0x226e33 },
	{ 0xf765, 0x226e34 },
	{ 0xf766, 0x226e35 },
	{ 0xf767, 0x226e36 },
	{ 0xf768, 0x226e37 },
	{ 0xf769, 0x226e38 },
	{ 0xf76a, 0x226e39 },
	{ 0xf76b, 0x226e3a },
	{ 0xf76c, 0x226e3b },
	{ 0xf76d, 0x226e3c },
	{ 0xf76e, 0x226e3d },
	{ 0xf76f, 0x226e3e },
	{ 0xf770, 0x226e3f },
	{ 0xf771, 0x226e40 },
	{ 0xf772, 0x226e41 },
	{ 0xf773, 0x226e42 },
	{ 0xf774, 0x226e43 },
	{ 0xf775, 0x226e44 },
	{ 0xf776, 0x226e45 },
	{ 0xf777, 0x226e46 },
	{ 0xf778, 0x226e47 },
	{ 0xf779, 0x226e48 },
	{ 0xf77a, 0x226e49 },
	{ 0xf77b, 0x226e4a },
	{ 0xf77c, 0x226e4b },
	{ 0xf77d, 0x226e4c },
	{ 0xf77e, 0x226e4d },
	{ 0xf7a1, 0x226e4e },
	{ 0xf7a2, 0x226e4f },
	{ 0xf7a3, 0x226e50 },
	{ 0xf7a4, 0x226e51 },
	{ 0xf7a5, 0x226e52 },
	{ 0xf7a6, 0x226e53 },
	{ 0xf7a7, 0x226e54 },
	{ 0xf7a8, 0x226e55 },
	{ 0xf7a9, 0x226e56 },
	{ 0xf7aa, 0x226e57 },
	{ 0xf7ab, 0x226e58 },
	{ 0xf7ac, 0x226e59 },
	{ 0xf7ad, 0x226e5a },
	{ 0xf7ae, 0x226e5b },
	{ 0xf7af, 0x226e5c },
	{ 0xf7b0, 0x226e5d },
	{ 0xf7b1, 0x226e5e },
	{ 0xf7b2, 0x226e5f },
	{ 0xf7b3, 0x226e60 },
	{ 0xf7b4, 0x226e61 },
	{ 0xf7b5, 0x226e62 },
	{ 0xf7b6, 0x226e63 },
	{ 0xf7b7, 0x226e64 },
	{ 0xf7b8, 0x226e65 },
	{ 0xf7b9, 0x226e66 },
	{ 0xf7ba, 0x226e67 },
	{ 0xf7bb, 0x226e68 },
	{ 0xf7bc, 0x226e69 },
	{ 0xf7bd, 0x226e6a },
	{ 0xf7be, 0x226e6b },
	{ 0xf7bf, 0x226e6c },
	{ 0xf7c0, 0x226e6d },
	{ 0xf7c1, 0x226e6e },
	{ 0xf7c2, 0x226e6f },
	{ 0xf7c3, 0x226e70 },
	{ 0xf7c4, 0x226e71 },
	{ 0xf7c5, 0x226e72 },
	{ 0xf7c6, 0x226e73 },
	{ 0xf7c7, 0x226e74 },
	{ 0xf7c8, 0x226e75 },
	{ 0xf7c9, 0x226e76 },
	{ 0xf7ca, 0x226e77 },
	{ 0xf7cb, 0x226e78 },
	{ 0xf7cc, 0x226e79 },
	{ 0xf7cd, 0x226e7a },
	{ 0xf7ce, 0x226e7b },
	{ 0xf7cf, 0x226e7c },
	{ 0xf7d0, 0x226e7d },
	{ 0xf7d1, 0x226e7e },
	{ 0xf7d2, 0x226f21 },
	{ 0xf7d3, 0x226f22 },
	{ 0xf7d4, 0x226f23 },
	{ 0xf7d5, 0x226f24 },
	{ 0xf7d6, 0x226f25 },
	{ 0xf7d7, 0x226f26 },
	{ 0xf7d8, 0x226f27 },
	{ 0xf7d9, 0x226f28 },
	{ 0xf7da, 0x226f29 },
	{ 0xf7db, 0x226f2a },
	{ 0xf7dc, 0x226f2b },
	{ 0xf7dd, 0x226f2c },
	{ 0xf7de, 0x226f2d },
	{ 0xf7df, 0x226f2e },
	{ 0xf7e0, 0x226f2f },
	{ 0xf7e1, 0x226f30 },
	{ 0xf7e2, 0x226f31 },
	{ 0xf7e3, 0x226f32 },
	{ 0xf7e4, 0x226f33 },
	{ 0xf7e5, 0x226f34 },
	{ 0xf7e6, 0x226f35 },
	{ 0xf7e7, 0x226f36 },
	{ 0xf7e8, 0x226f37 },
	{ 0xf7e9, 0x226f38 },
	{ 0xf7ea, 0x226f39 },
	{ 0xf7eb, 0x226f3a },
	{ 0xf7ec, 0x226f3b },
	{ 0xf7ed, 0x226f3c },
	{ 0xf7ee, 0x226f3d },
	{ 0xf7ef, 0x226f3e },
	{ 0xf7f0, 0x226f3f },
	{ 0xf7f1, 0x226f40 },
	{ 0xf7f2, 0x226f41 },
	{ 0xf7f3, 0x226f42 },
	{ 0xf7f4, 0x226f43 },
	{ 0xf7f5, 0x226f44 },
	{ 0xf7f6, 0x226f45 },
	{ 0xf7f7, 0x226f46 },
	{ 0xf7f8, 0x226f47 },
	{ 0xf7f9, 0x226f48 },
	{ 0xf7fa, 0x226f49 },
	{ 0xf7fb, 0x226f4a },
	{ 0xf7fc, 0x226f4b },
	{ 0xf7fd, 0x226f4c },
	{ 0xf7fe, 0x226f4d },
	{ 0xf840, 0x226f4e },
	{ 0xf841, 0x226f4f },
	{ 0xf842, 0x226f50 },
	{ 0xf843, 0x226f51 },
	{ 0xf844, 0x226f52 },
	{ 0xf845, 0x226f53 },
	{ 0xf846, 0x226f54 },
	{ 0xf847, 0x226f55 },
	{ 0xf848, 0x226f56 },
	{ 0xf849, 0x226f57 },
	{ 0xf84a, 0x226f58 },
	{ 0xf84b, 0x226f59 },
	{ 0xf84c, 0x226f5a },
	{ 0xf84d, 0x226f5b },
	{ 0xf84e, 0x226f5c },
	{ 0xf84f, 0x226f5d },
	{ 0xf850, 0x226f5e },
	{ 0xf851, 0x226f5f },
	{ 0xf852, 0x226f60 },
	{ 0xf853, 0x226f61 },
	{ 0xf854, 0x226f62 },
	{ 0xf855, 0x226f63 },
	{ 0xf856, 0x226f64 },
	{ 0xf857, 0x226f65 },
	{ 0xf858, 0x226f66 },
	{ 0xf859, 0x226f67 },
	{ 0xf85a, 0x226f68 },
	{ 0xf85b, 0x226f69 },
	{ 0xf85c, 0x226f6a },
	{ 0xf85d, 0x226f6b },
	{ 0xf85e, 0x226f6c },
	{ 0xf85f, 0x226f6d },
	{ 0xf860, 0x226f6e },
	{ 0xf861, 0x226f6f },
	{ 0xf862, 0x226f70 },
	{ 0xf863, 0x226f71 },
	{ 0xf864, 0x226f72 },
	{ 0xf865, 0x226f73 },
	{ 0xf866, 0x226f74 },
	{ 0xf867, 0x226f75 },
	{ 0xf868, 0x226f76 },
	{ 0xf869, 0x226f77 },
	{ 0xf86a, 0x226f78 },
	{ 0xf86b, 0x226f79 },
	{ 0xf86c, 0x226f7a },
	{ 0xf86d, 0x226f7b },
	{ 0xf86e, 0x226f7c },
	{ 0xf86f, 0x226f7d },
	{ 0xf870, 0x226f7e },
	{ 0xf871, 0x227021 },
	{ 0xf872, 0x227022 },
	{ 0xf873, 0x227023 },
	{ 0xf874, 0x227024 },
	{ 0xf875, 0x227025 },
	{ 0xf876, 0x227026 },
	{ 0xf877, 0x227027 },
	{ 0xf878, 0x227028 },
	{ 0xf879, 0x227029 },
	{ 0xf87a, 0x22702a },
	{ 0xf87b, 0x22702b },
	{ 0xf87c, 0x22702c },
	{ 0xf87d, 0x22702d },
	{ 0xf87e, 0x22702e },
	{ 0xf8a1, 0x22702f },
	{ 0xf8a2, 0x227030 },
	{ 0xf8a3, 0x227031 },
	{ 0xf8a4, 0x227032 },
	{ 0xf8a5, 0x227033 },
	{ 0xf8a6, 0x227034 },
	{ 0xf8a7, 0x227035 },
	{ 0xf8a8, 0x227036 },
	{ 0xf8a9, 0x227037 },
	{ 0xf8aa, 0x227038 },
	{ 0xf8ab, 0x227039 },
	{ 0xf8ac, 0x22703a },
	{ 0xf8ad, 0x22703b },
	{ 0xf8ae, 0x22703c },
	{ 0xf8af, 0x22703d },
	{ 0xf8b0, 0x22703e },
	{ 0xf8b1, 0x22703f },
	{ 0xf8b2, 0x227040 },
	{ 0xf8b3, 0x227041 },
	{ 0xf8b4, 0x227042 },
	{ 0xf8b5, 0x227043 },
	{ 0xf8b6, 0x227044 },
	{ 0xf8b7, 0x227045 },
	{ 0xf8b8, 0x227046 },
	{ 0xf8b9, 0x227047 },
	{ 0xf8ba, 0x227048 },
	{ 0xf8bb, 0x227049 },
	{ 0xf8bc, 0x22704a },
	{ 0xf8bd, 0x22704b },
	{ 0xf8be, 0x22704c },
	{ 0xf8bf, 0x22704d },
	{ 0xf8c0, 0x22704e },
	{ 0xf8c1, 0x22704f },
	{ 0xf8c2, 0x227050 },
	{ 0xf8c3, 0x227051 },
	{ 0xf8c4, 0x227052 },
	{ 0xf8c5, 0x227053 },
	{ 0xf8c6, 0x227054 },
	{ 0xf8c7, 0x227055 },
	{ 0xf8c8, 0x227056 },
	{ 0xf8c9, 0x227057 },
	{ 0xf8ca, 0x227058 },
	{ 0xf8cb, 0x227059 },
	{ 0xf8cc, 0x22705a },
	{ 0xf8cd, 0x22705b },
	{ 0xf8ce, 0x22705c },
	{ 0xf8cf, 0x22705d },
	{ 0xf8d0, 0x22705e },
	{ 0xf8d1, 0x22705f },
	{ 0xf8d2, 0x227060 },
	{ 0xf8d3, 0x227061 },
	{ 0xf8d4, 0x227062 },
	{ 0xf8d5, 0x227063 },
	{ 0xf8d6, 0x227064 },
	{ 0xf8d7, 0x227065 },
	{ 0xf8d8, 0x227066 },
	{ 0xf8d9, 0x227067 },
	{ 0xf8da, 0x227068 },
	{ 0xf8db, 0x227069 },
	{ 0xf8dc, 0x22706a },
	{ 0xf8dd, 0x22706b },
	{ 0xf8de, 0x22706c },
	{ 0xf8df, 0x22706d },
	{ 0xf8e0, 0x22706e },
	{ 0xf8e1, 0x22706f },
	{ 0xf8e2, 0x227070 },
	{ 0xf8e3, 0x227071 },
	{ 0xf8e4, 0x227072 },
	{ 0xf8e5, 0x227073 },
	{ 0xf8e6, 0x227074 },
	{ 0xf8e7, 0x227075 },
	{ 0xf8e8, 0x227076 },
	{ 0xf8e9, 0x227077 },
	{ 0xf8ea, 0x227078 },
	{ 0xf8eb, 0x227079 },
	{ 0xf8ec, 0x22707a },
	{ 0xf8ed, 0x22707b },
	{ 0xf8ee, 0x22707c },
	{ 0xf8ef, 0x22707d },
	{ 0xf8f0, 0x22707e },
	{ 0xf8f1, 0x227121 },
	{ 0xf8f2, 0x227122 },
	{ 0xf8f3, 0x227123 },
	{ 0xf8f4, 0x227124 },
	{ 0xf8f5, 0x227125 },
	{ 0xf8f6, 0x227126 },
	{ 0xf8f7, 0x227127 },
	{ 0xf8f8, 0x227128 },
	{ 0xf8f9, 0x227129 },
	{ 0xf8fa, 0x22712a },
	{ 0xf8fb, 0x22712b },
	{ 0xf8fc, 0x22712c },
	{ 0xf8fd, 0x22712d },
	{ 0xf8fe, 0x22712e },
	{ 0xf940, 0x22712f },
	{ 0xf941, 0x227130 },
	{ 0xf942, 0x227131 },
	{ 0xf943, 0x227132 },
	{ 0xf944, 0x227133 },
	{ 0xf945, 0x227134 },
	{ 0xf946, 0x227135 },
	{ 0xf947, 0x227136 },
	{ 0xf948, 0x227137 },
	{ 0xf949, 0x227138 },
	{ 0xf94a, 0x227139 },
	{ 0xf94b, 0x22713a },
	{ 0xf94c, 0x22713b },
	{ 0xf94d, 0x22713c },
	{ 0xf94e, 0x22713d },
	{ 0xf94f, 0x22713e },
	{ 0xf950, 0x22713f },
	{ 0xf951, 0x227140 },
	{ 0xf952, 0x227141 },
	{ 0xf953, 0x227142 },
	{ 0xf954, 0x227143 },
	{ 0xf955, 0x227144 },
	{ 0xf956, 0x227145 },
	{ 0xf957, 0x227146 },
	{ 0xf958, 0x227147 },
	{ 0xf959, 0x227148 },
	{ 0xf95a, 0x227149 },
	{ 0xf95b, 0x22714a },
	{ 0xf95c, 0x22714b },
	{ 0xf95d, 0x22714c },
	{ 0xf95e, 0x22714d },
	{ 0xf95f, 0x22714e },
	{ 0xf960, 0x22714f },
	{ 0xf961, 0x227150 },
	{ 0xf962, 0x227151 },
	{ 0xf963, 0x227152 },
	{ 0xf964, 0x227153 },
	{ 0xf965, 0x227154 },
	{ 0xf966, 0x227155 },
	{ 0xf967, 0x227156 },
	{ 0xf968, 0x227157 },
	{ 0xf969, 0x227158 },
	{ 0xf96a, 0x227159 },
	{ 0xf96b, 0x22715a },
	{ 0xf96c, 0x22715b },
	{ 0xf96d, 0x22715c },
	{ 0xf96e, 0x22715d },
	{ 0xf96f, 0x22715e },
	{ 0xf970, 0x22715f },
	{ 0xf971, 0x227160 },
	{ 0xf972, 0x227161 },
	{ 0xf973, 0x227162 },
	{ 0xf974, 0x227163 },
	{ 0xf975, 0x227164 },
	{ 0xf976, 0x227165 },
	{ 0xf977, 0x227167 },
	{ 0xf978, 0x227168 },
	{ 0xf979, 0x227169 },
	{ 0xf97a, 0x22716a },
	{ 0xf97b, 0x22716b },
	{ 0xf97c, 0x22716c },
	{ 0xf97d, 0x22716d },
	{ 0xf97e, 0x22716e },
	{ 0xf9a1, 0x22716f },
	{ 0xf9a2, 0x227170 },
	{ 0xf9a3, 0x227171 },
	{ 0xf9a4, 0x227172 },
	{ 0xf9a5, 0x227173 },
	{ 0xf9a6, 0x227174 },
	{ 0xf9a7, 0x227175 },
	{ 0xf9a8, 0x227176 },
	{ 0xf9a9, 0x227177 },
	{ 0xf9aa, 0x227178 },
	{ 0xf9ab, 0x227179 },
	{ 0xf9ac, 0x22717a },
	{ 0xf9ad, 0x22717b },
	{ 0xf9ae, 0x22717c },
	{ 0xf9af, 0x22717d },
	{ 0xf9b0, 0x22717e },
	{ 0xf9b1, 0x227221 },
	{ 0xf9b2, 0x227222 },
	{ 0xf9b3, 0x227223 },
	{ 0xf9b4, 0x227224 },
	{ 0xf9b5, 0x227225 },
	{ 0xf9b6, 0x227226 },
	{ 0xf9b7, 0x227227 },
	{ 0xf9b8, 0x227228 },
	{ 0xf9b9, 0x227229 },
	{ 0xf9ba, 0x22722a },
	{ 0xf9bb, 0x22722b },
	{ 0xf9bc, 0x22722c },
	{ 0xf9bd, 0x22722d },
	{ 0xf9be, 0x22722e },
	{ 0xf9bf, 0x22722f },
	{ 0xf9c0, 0x227230 },
	{ 0xf9c1, 0x227231 },
	{ 0xf9c2, 0x227232 },
	{ 0xf9c3, 0x227233 },
	{ 0xf9c4, 0x227166 },
	{ 0xf9c5, 0x227234 },
	{ 0xf9c6, 0x227240 },
	{ 0xf9c7, 0x227235 },
	{ 0xf9c8, 0x227236 },
	{ 0xf9c9, 0x227237 },
	{ 0xf9ca, 0x227238 },
	{ 0xf9cb, 0x227239 },
	{ 0xf9cc, 0x22723a },
	{ 0xf9cd, 0x22723b },
	{ 0xf9ce, 0x22723c },
	{ 0xf9cf, 0x22723d },
	{ 0xf9d0, 0x22723e },
	{ 0xf9d1, 0x22723f },
	{ 0xf9d2, 0x227241 },
	{ 0xf9d3, 0x227242 },
	{ 0xf9d4, 0x227243 },
	{ 0xf9d5, 0x227244 },
	{ 0xf9d6, 0x234337 },
	{ 0xf9d7, 0x234f50 },
	{ 0xf9d8, 0x23444e },
	{ 0xf9d9, 0x23504a },
	{ 0xf9da, 0x232c5d },
	{ 0xf9db, 0x233d7e },
	{ 0xf9dc, 0x234b5c }
};
#endif
