/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright(c) 2001 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _ISCII_ORI_H_
#define _ISCII_ORI_H_

#include "iscii-common.h"

Entry Oriya_isc[] ={
    {0xA1, 0x0B01, 3},
    {0xA4, 0x0B05, 6},
    {0xAC, 0x0B0F, 2},
    {0xB0, 0x0B13, 2},
    {0xB3, 0x0B15, 20},
    {0xC8, 0x0B2A, 6},
    {0xCE, 0x0B5F, 2},
    {0xD1, 0x0B32, 2},
    {0xD5, 0x0B36, 4},
    {ISC_INV, UNI_INV, 1},
    {0xDA, 0x0B3E, 6},
    {0xE1, 0x0B47, 2},
    {0xE5, 0x0B4B, 2},
    {0xE8, 0x0B4D, 1},
    {0xE9, 0x0B3C, 1},
    {0xF1, 0x0B66, 10}
};

Entry Oriya_uni[] = {
    {0xA1, 0x0B01, 3},
    {0xA4, 0x0B05, 6},
    {0xAC, 0x0B0F, 2},
    {0xB0, 0x0B13, 2},
    {0xB3, 0x0B15, 20},
    {0xC8, 0x0B2A, 6},
    {0xD1, 0x0B32, 2},
    {0xD5, 0x0B36, 4},
    {0xE9, 0x0B3C, 1},
    {0xDA, 0x0B3E, 6},
    {0xE1, 0x0B47, 2},
    {0xE5, 0x0B4B, 2},
    {0xE8, 0x0B4D, 1},
    {0xBF, 0x0B5C, NUKTA},
    {0xC0, 0x0B5D, NUKTA},
    {0xCE, 0x0B5F, 2},
    {0xF1, 0x0B66, 10},
    {0xE8, UNI_ZWNJ,HALANT},
    {0xE9, UNI_ZWJ, HALANT},
    {ISC_INV, UNI_INV, 1}
};

int  Oriya_nukta_type[] = {
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* A0 - A7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* A8 - AF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* B0 - B7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0B5C, /* B8 - BF */
        0x0B5D, 0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C0 - C7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C8 - CF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D0 - D7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D8 - DF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E8 - EF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* F0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0     /* F8 - FF */
};
#endif
