/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright(c) 2001 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _ISCII_GMK_H_
#define _ISCII_GMK_H_

#include "iscii-common.h"

Entry Gurmukhi_isc[] ={
    {0xA2, 0x0A02, 1},
    {0xA4, 0x0A05, 6},
    {0xAC, 0x0A0F, 2},
    {0xB0, 0x0A13, 2},
    {0xB3, 0x0A15, 20},
    {0xC8, 0x0A2A, 6},
    {0xCF, 0x0A30, 1},
    {0xD1, 0x0A32, 1},
    {0xD4, 0x0A35, 2},
    {0xD7, 0x0A38, 2},
    {ISC_INV, UNI_INV, 1},
    {0xDA, 0x0A3E, 5},
    {0xE1, 0x0A47, 2},
    {0xE5, 0x0A4B, 2},
    {0xE8, 0x0A71, 1},
    {0xE9, 0x0A3C, 1},
    {0xF1, 0x0A66, 10}
};

Entry Gurmukhi_uni[] = {
    {0xA2, 0x0A02, 1},
    {0xA4, 0x0A05, 6},
    {0xAC, 0x0A0F, 2},
    {0xB0, 0x0A13, 2},
    {0xB3, 0x0A15, 20},
    {0xC8, 0x0A2A, 6},
    {0xCF, 0x0A30, 1},
    {0xD1, 0x0A32, 1},
    {0xD1, 0x0A33, NUKTA},
    {0xD4, 0x0A35, 2},
    {0xD7, 0x0A38, 2},
    {0xE9, 0x0A3C, 1},
    {0xDA, 0x0A3E, 5},
    {0xE1, 0x0A47, 2},
    {0xE5, 0x0A4B, 2},
    {0xB4, 0x0A59, NUKTA},
    {0xB5, 0x0A5A, NUKTA},
    {0xC9, 0x0A5E, NUKTA},
    {0xF1, 0x0A66, 10},
    {0xE8, 0x0A71, 1},
    {0xE8, UNI_ZWNJ,HALANT},
    {0xE9, UNI_ZWJ, HALANT},
    {ISC_INV, UNI_INV, 1}
};

int  Gurmukhi_nukta_type[] = {
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* A0 - A7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* A8 - AF */
        0x0,    0x0,    0x0,    0x0,    0x0A59, 0x0A5A, 0x0,    0x0,    /* B0 - B7 */
        0x0,    0x0,    0x0A5B, 0x0,    0x0,    0x0,    0x0,    0x0,    /* B8 - BF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C0 - C7 */
        0x0,    0x0A5E, 0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C8 - CF */
        0x0,    0x0A33, 0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D0 - D7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D8 - DF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E8 - EF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* F0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0     /* F8 - FF */
};
#endif
