/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright(c) 2001 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _ISCII_DEV_H_
#define _ISCII_DEV_H_

#include "iscii-common.h"

Entry Devanagari_isc[] ={
    {0xA1, 0x0901, 3},
    {0xA4, 0x0905, 7},
    {0xAB, 0x090E, 3},
    {0xAE, 0x090D, 1},
    {0xAF, 0x0912, 3},
    {0xB2, 0x0911, 1},
    {0xB3, 0x0915, 27},
    {0xCE, 0x095F, 1},
    {0xCF, 0x0930, 10},
    {ISC_INV, UNI_INV, 1},
    {0xDA, 0x093E, 6},
    {0xE0, 0x0946, 3},
    {0xE3, 0x0945, 1},
    {0xE4, 0x094A, 3},
    {0xE7, 0x0949, 1},
    {0xE8, 0x094D, 1},
    {0xE9, 0x093C, 1},
    {0xEA, 0x0964, 1},
    {0xF1, 0x0966, 10}
};

Entry Devanagari_uni[] = {
    {0xA1, 0x0901, 3},
    {0xA4, 0x0905, 7},
    {0xA6, 0x090C, NUKTA},
    {0xAE, 0x090D, 1},
    {0xAB, 0x090E, 3},
    {0xB2, 0x0911, 1},
    {0xAF, 0x0912, 3},
    {0xB3, 0x0915, 27},
    {0xCF, 0x0930, 10},
    {0xE9, 0x093C, 1},
    {0xEA, 0x093D, NUKTA},
    {0xDA, 0x093E, 6},
    {0xDF, 0x0944, NUKTA},
    {0xE3, 0x0945, 1},
    {0xE0, 0x0946, 3},
    {0xE7, 0x0949, 1},
    {0xE4, 0x094A, 3},
    {0xE8, 0x094D, 1},
    {0xA1, 0x0950, NUKTA},
    {0xB8, 0x0952, EXT},
    {0xB3, 0x0958, NUKTA},
    {0xB4, 0x0959, NUKTA},
    {0xB5, 0x095A, NUKTA},
    {0xBA, 0x095B, NUKTA},
    {0xBF, 0x095C, NUKTA},
    {0xC0, 0x095D, NUKTA},
    {0xC9, 0x095E, NUKTA},
    {0xCE, 0x095F, 1},
    {0xAA, 0x0960, NUKTA},
    {0xA7, 0x0961, NUKTA},
    {0xDB, 0x0962, NUKTA},
    {0xDC, 0x0963, NUKTA},
    {0xEA, 0x0964, 1},
    {0xEA, 0x0965, DOUBLE_DANDA},
    {0xF1, 0x0966, 10},
    {0xBF, 0x0970, EXT},
    {0xE8, UNI_ZWNJ,HALANT},
    {0xE9, UNI_ZWJ, HALANT},
    {ISC_INV, UNI_INV, 1}
};

int  Devanagari_nukta_type[] = {
        0x0,    0x0950, 0x0,    0x0,    0x0,    0x0,    0x090C, 0x0961, /* A0 - A7 */
        0x0,    0x0,    0x0960, 0x0,    0x0,    0x0,    0x0,    0x0,    /* A8 - AF */
        0x0,    0x0,    0x0,    0x0958, 0x0959, 0x095A, 0x0,    0x0,    /* B0 - B7 */
        0x0,    0x0,    0x095B, 0x0,    0x0,    0x0,    0x0,    0x095C, /* B8 - BF */
        0x095D, 0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C0 - C7 */
        0x0,    0x095E, 0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C8 - CF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D0 - D7 */
        0x0,    0x0,    0x0,    0x0962, 0x0963, 0x0,    0x0,    0x0944, /* D8 - DF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E0 - E7 */
        0x0,    0x0,    0x093D, 0x0,    0x0,    0x0,    0x0,    0x0,    /* E8 - EF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* F0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0     /* F8 - FF */
};

int  Devanagari_EXT_type[] = {
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* A0 - A7 */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* A8 - AF */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* B0 - B7 */
        0x0952, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0970, /* B8 - BF */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* C0 - C7 */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* C8 - CF */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* D0 - D7 */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* D8 - DF */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* E0 - E7 */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* E8 - EF */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,    /* F0 - E7 */
        0x0,    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0     /* F8 - FF */
};
#endif
