/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright(c) 2001 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _ISCII_BNG_H_
#define _ISCII_BNG_H_

#include "iscii-common.h"

Entry Bengali_isc[] ={
    {0xA1, 0x0981, 3},
    {0xA4, 0x0985, 7},
    {0xAC, 0x098F, 2},
    {0xB0, 0x0993, 2},
    {0xB3, 0x0995, 20},
    {0xC8, 0x09AA, 8},
    {0xD1, 0x09B2, 1},
    {0xD5, 0x09B6, 4},
    {ISC_INV, UNI_INV, 1},
    {0xDA, 0x09BE, 6},
    {0xE1, 0x09C7, 2},
    {0xE5, 0x09CB, 2},
    {0xE8, 0x09CD, 1},
    {0xE9, 0x09BC, 1},
    {0xEA, 0x09F7, 1},
    {0xF1, 0x09E6, 10},
};

Entry Bengali_uni[] ={
    {0xA1, 0x0981, 3},
    {0xA4, 0x0985, 7},
    {0xAC, 0x098F, 2},
    {0xB0, 0x0993, 2},
    {0xB3, 0x0995, 20},
    {0xC8, 0x09AA, 8},
    {0xD1, 0x09B2, 1},
    {0xD5, 0x09B6, 4},
    {0xE9, 0x09BC, 1},
    {0xDA, 0x09BE, 6},
    {0xE1, 0x09C7, 2},
    {0xE5, 0x09CB, 2},
    {0xE8, 0x09CD, 1},
    {0xBF, 0x09DC, NUKTA},
    {0xC0, 0x09DD, NUKTA},
    {0xF1, 0x09E6, 10},
    {0xEA, 0x09F7, 1},
    {0xE8, UNI_ZWNJ,HALANT},
    {0xE9, UNI_ZWJ, HALANT},
    {ISC_INV, UNI_INV, 1}
};

int Bengali_nukta_type[] = {
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* A0 - A7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* A8 - AF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* B0 - B7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x09DC, /* B8 - BF */
        0x09DD, 0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C0 - C7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* C8 - CF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D0 - D7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* D8 - DF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* E8 - EF */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    /* F0 - E7 */
        0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0,    0x0     /* F8 - FF */
};

#endif
