#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
#
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
#
# Copyright 2013 Nexenta Systems, Inc.  All rights reserved.
#
# Copyright 2019 Joyent, Inc.
#

COBJS =		brand_util.o
ASOBJS =	crt.o handler.o runexe.o
OFFSETS_SRC =	../common/offsets.in
OFFSETS_H =	assym.h
OBJECTS =	$(COBJS) $(ASOBJS)
CLOBBERFILES +=	$(OFFSETS_H)

include $(SRC)/lib/Makefile.lib

SRCDIR =	../common
CSRCS =		$(COBJS:%o=../common/%c)
ASSRCS =	$(ASOBJS:%o=$(ISASRCDIR)/%s)
SRCS =		$(CSRCS) $(ASSRCS)

CPPFLAGS +=	-D_REENTRANT -U_ASM -I. -I../sys
CFLAGS +=	$(CCVERBOSE)
ASFLAGS +=	$(ASFLAGS_$(CURTYPE)) -D_ASM -I. -I../sys
ASFLAGS64 +=	$(ASFLAGS_$(CURTYPE)) -D_ASM -I. -I../sys

#
# Disable stack protection as this code might be running in an s10 context.
#
STACKPROTECT = none

# intentional code after abort()
SMOFF += unreachable

.KEEP_STATE:

#
# build the offset header before trying to compile any files.  (it's included
# by brand_misc.h, so it's needed for all objects, not just assembly ones.)
#
# Note we have to build assym.h via its dependency on pics/% so that the
# target dependent assignment of CTF_FLAGS will be there, otherwise make
# will see two different commands to build it (endless rebuilds).
#
all: pics .WAIT $$(PICS)

$(OBJECTS:%=pics/%): $(OFFSETS_H)

$(OFFSETS_H): $(OFFSETS_SRC)
	$(OFFSETS_CREATE) < $(OFFSETS_SRC) >$@

pics/%.o: $(ISASRCDIR)/%.S
	$(COMPILE.s) -o $@ $<
	$(POST_PROCESS_S_O)

include $(SRC)/lib/Makefile.targ
