/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright 2013 Nexenta Systems, Inc.  All rights reserved.
 */

/*
 * Table mapping NT status codes to Win32 errors.  See:
 *  http://support.microsoft.com/kb/113996
 *
 * The table below was generated from the above KB data
 * using a simple awk program.
 */

#include <sys/errno.h>
#include <smb/ntstatus.h>
#include <smb/nterror.h>

#include "smb_status2winerr.h"


const struct status2winerr
smb_status2winerr_map[] = {

	/* As this was generated, don't really want cstyle noise. */
	/* BEGIN CSTYLED */

	/*
	 * WINDOWS NT STATUS CODE			WIN32 ERROR CODE
	 */
	NT_STATUS_ACCESS_DENIED,			ERROR_ACCESS_DENIED,
	NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT,	ERROR_ACCESS_DISABLED_BY_POLICY,
	NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER,	ERROR_ACCESS_DISABLED_BY_POLICY,
	NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH,	ERROR_ACCESS_DISABLED_BY_POLICY,
	NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER,	ERROR_ACCESS_DISABLED_BY_POLICY,
	NT_STATUS_ACCESS_VIOLATION,			ERROR_NOACCESS,
	NT_STATUS_ACCOUNT_DISABLED,			ERROR_ACCOUNT_DISABLED,
	NT_STATUS_ACCOUNT_EXPIRED,			ERROR_ACCOUNT_EXPIRED,
	NT_STATUS_ACCOUNT_LOCKED_OUT,			ERROR_ACCOUNT_LOCKED_OUT,
	NT_STATUS_ACCOUNT_RESTRICTION,			ERROR_ACCOUNT_RESTRICTION,
	NT_STATUS_ADAPTER_HARDWARE_ERROR,		ERROR_ADAP_HDW_ERR,
	NT_STATUS_ADDRESS_ALREADY_ASSOCIATED,		ERROR_ADDRESS_ALREADY_ASSOCIATED,
	NT_STATUS_ADDRESS_ALREADY_EXISTS,		ERROR_DUP_NAME,
	NT_STATUS_ADDRESS_CLOSED,			ERROR_NETNAME_DELETED,
	NT_STATUS_ADDRESS_NOT_ASSOCIATED,		ERROR_ADDRESS_NOT_ASSOCIATED,
	NT_STATUS_AGENTS_EXHAUSTED,			ERROR_NO_MORE_ITEMS,
	NT_STATUS_ALIAS_EXISTS,				ERROR_ALIAS_EXISTS,
	NT_STATUS_ALLOTTED_SPACE_EXCEEDED,		ERROR_ALLOTTED_SPACE_EXCEEDED,
	NT_STATUS_ALREADY_COMMITTED,			ERROR_ACCESS_DENIED,
	NT_STATUS_ALREADY_DISCONNECTED,			ERROR_ACTIVE_CONNECTIONS,
	/* NT_STATUS_AUDITING_DISABLED,			ERROR_AUDITING_DISABLED, */
	/* NT_STATUS_BAD_BINDINGS,			SEC_E_BAD_BINDINGS, */
	NT_STATUS_BAD_DESCRIPTOR_FORMAT,		ERROR_BAD_DESCRIPTOR_FORMAT,
	NT_STATUS_BAD_DEVICE_TYPE,			ERROR_BAD_DEV_TYPE,
	NT_STATUS_BAD_IMPERSONATION_LEVEL,		ERROR_BAD_IMPERSONATION_LEVEL,
	NT_STATUS_BAD_INHERITANCE_ACL,			ERROR_BAD_INHERITANCE_ACL,
	NT_STATUS_BAD_INITIAL_PC,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_BAD_INITIAL_STACK,			ERROR_STACK_OVERFLOW,
	NT_STATUS_BAD_LOGON_SESSION_STATE,		ERROR_BAD_LOGON_SESSION_STATE,
	NT_STATUS_BAD_MASTER_BOOT_RECORD,		ERROR_INVALID_PARAMETER,
	NT_STATUS_BAD_NETWORK_NAME,			ERROR_BAD_NET_NAME,
	NT_STATUS_BAD_NETWORK_PATH,			ERROR_BAD_NETPATH,
	NT_STATUS_BAD_REMOTE_ADAPTER,			ERROR_BAD_REM_ADAP,
	NT_STATUS_BAD_TOKEN_TYPE,			ERROR_BAD_TOKEN_TYPE,
	NT_STATUS_BAD_VALIDATION_CLASS,			ERROR_BAD_VALIDATION_CLASS,
	NT_STATUS_BAD_WORKING_SET_LIMIT,		ERROR_INVALID_PARAMETER,
	NT_STATUS_BEGINNING_OF_MEDIA,			ERROR_BEGINNING_OF_MEDIA,
	NT_STATUS_BUFFER_OVERFLOW,			ERROR_MORE_DATA,
	NT_STATUS_BUFFER_TOO_SMALL,			ERROR_INSUFFICIENT_BUFFER,
	NT_STATUS_BUS_RESET,				ERROR_BUS_RESET,
	NT_STATUS_CANCELLED,				ERROR_OPERATION_ABORTED,
	NT_STATUS_CANNOT_DELETE,			ERROR_ACCESS_DENIED,
	NT_STATUS_CANNOT_IMPERSONATE,			ERROR_CANNOT_IMPERSONATE,
	NT_STATUS_CANNOT_MAKE,				ERROR_CANNOT_MAKE,
	NT_STATUS_CANT_ACCESS_DOMAIN_INFO,		ERROR_CANT_ACCESS_DOMAIN_INFO,
	NT_STATUS_CANT_DISABLE_MANDATORY,		ERROR_CANT_DISABLE_MANDATORY,
	NT_STATUS_CANT_OPEN_ANONYMOUS,			ERROR_CANT_OPEN_ANONYMOUS,
	NT_STATUS_CHILD_MUST_BE_VOLATILE,		ERROR_CHILD_MUST_BE_VOLATILE,
	/* NT_STATUS_CLEANER_CARTRIDGE_INSTALLED,	ERROR_CLEANER_CARTRIDGE_INSTALLED, */
	/* NT_STATUS_CLUSTER_... */
	NT_STATUS_COMMITMENT_LIMIT,			ERROR_COMMITMENT_LIMIT,
	NT_STATUS_CONFLICTING_ADDRESSES,		ERROR_INVALID_ADDRESS,
	NT_STATUS_CONNECTION_ABORTED,			ERROR_CONNECTION_ABORTED,
	NT_STATUS_CONNECTION_ACTIVE,			ERROR_CONNECTION_ACTIVE,
	NT_STATUS_CONNECTION_COUNT_LIMIT,		ERROR_CONNECTION_COUNT_LIMIT,
	NT_STATUS_CONNECTION_DISCONNECTED,		ERROR_NETNAME_DELETED,
	NT_STATUS_CONNECTION_INVALID,			ERROR_CONNECTION_INVALID,
	NT_STATUS_CONNECTION_IN_USE,			ERROR_DEVICE_IN_USE,
	NT_STATUS_CONNECTION_REFUSED,			ERROR_CONNECTION_REFUSED,
	NT_STATUS_CONNECTION_RESET,			ERROR_NETNAME_DELETED,
	/* NT_STATUS_COPY_PROTECTION_FAILURE,		STG_E_STATUS_COPY_PROTECTION_FAILURE, */
	NT_STATUS_CRC_ERROR,				ERROR_CRC,
	/* NT_STATUS_CRYPTO_SYSTEM_INVALID,		SEC_E_CRYPTO_SYSTEM_INVALID, */
	/* NT_STATUS_CSS_... */
	NT_STATUS_CTL_FILE_NOT_SUPPORTED,		ERROR_NOT_SUPPORTED,
	/* NT_STATUS_CTX_BAD_VIDEO_MODE,		ERROR_CTX_BAD_VIDEO_MODE, */
	/* NT_STATUS_CTX_... */
	NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED,		ERROR_CURRENT_DOMAIN_NOT_ALLOWED,
	NT_STATUS_DATATYPE_MISALIGNMENT,		ERROR_NOACCESS,
	NT_STATUS_DATATYPE_MISALIGNMENT_ERROR,		ERROR_NOACCESS,
	NT_STATUS_DATA_ERROR,				ERROR_CRC,
	NT_STATUS_DATA_LATE_ERROR,			ERROR_IO_DEVICE,
	NT_STATUS_DATA_OVERRUN,				ERROR_IO_DEVICE,
	NT_STATUS_DECRYPTION_FAILED,			ERROR_ACCESS_DENIED,
	NT_STATUS_DELETE_PENDING,			ERROR_ACCESS_DENIED,
	NT_STATUS_DESTINATION_ELEMENT_FULL,		ERROR_DESTINATION_ELEMENT_FULL,
	NT_STATUS_DEVICE_BUSY,				ERROR_BUSY,
	NT_STATUS_DEVICE_CONFIGURATION_ERROR,		ERROR_INVALID_PARAMETER,
	NT_STATUS_DEVICE_DATA_ERROR,			ERROR_CRC,
	NT_STATUS_DEVICE_DOES_NOT_EXIST,		ERROR_DEV_NOT_EXIST,
	NT_STATUS_DEVICE_DOOR_OPEN,			ERROR_DEVICE_DOOR_OPEN,
	NT_STATUS_DEVICE_NOT_CONNECTED,			ERROR_DEVICE_NOT_CONNECTED,
	NT_STATUS_DEVICE_NOT_PARTITIONED,		ERROR_DEVICE_NOT_PARTITIONED,
	NT_STATUS_DEVICE_NOT_READY,			ERROR_NOT_READY,
	NT_STATUS_DEVICE_OFF_LINE,			ERROR_NOT_READY,
	NT_STATUS_DEVICE_PAPER_EMPTY,			ERROR_OUT_OF_PAPER,
	NT_STATUS_DEVICE_POWERED_OFF,			ERROR_NOT_READY,
	NT_STATUS_DEVICE_POWER_FAILURE,			ERROR_NOT_READY,
	NT_STATUS_DEVICE_PROTOCOL_ERROR,		ERROR_IO_DEVICE,
	NT_STATUS_DEVICE_REMOVED,			ERROR_DEVICE_REMOVED,
	NT_STATUS_DEVICE_REQUIRES_CLEANING,		ERROR_DEVICE_REQUIRES_CLEANING,
	NT_STATUS_DFS_EXIT_PATH_FOUND,			ERROR_PATH_NOT_FOUND,
	NT_STATUS_DFS_UNAVAILABLE,			ERROR_CONNECTION_UNAVAIL,
	NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT,		ERROR_BAD_PATHNAME,
	NT_STATUS_DIRECTORY_NOT_EMPTY,			ERROR_DIR_NOT_EMPTY,
	NT_STATUS_DIRECTORY_SERVICE_REQUIRED,		ERROR_DS_DS_REQUIRED,
	/* NT_STATUS_DISCONNECTED,			ERROR_DEV_NOT_EXIST, */
	NT_STATUS_DISK_CORRUPT_ERROR,			ERROR_DISK_CORRUPT,
	NT_STATUS_DISK_FULL,				ERROR_DISK_FULL,
	NT_STATUS_DISK_OPERATION_FAILED,		ERROR_DISK_OPERATION_FAILED,
	NT_STATUS_DISK_RECALIBRATE_FAILED,		ERROR_DISK_RECALIBRATE_FAILED,
	NT_STATUS_DISK_RESET_FAILED,			ERROR_DISK_RESET_FAILED,
	NT_STATUS_DLL_INIT_FAILED,			ERROR_DLL_INIT_FAILED,
	NT_STATUS_DLL_NOT_FOUND,			ERROR_MOD_NOT_FOUND,
	NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND,		ERROR_DOMAIN_CONTROLLER_NOT_FOUND,
	NT_STATUS_DOMAIN_EXISTS,			ERROR_DOMAIN_EXISTS,
	NT_STATUS_DOMAIN_LIMIT_EXCEEDED,		ERROR_DOMAIN_LIMIT_EXCEEDED,
	NT_STATUS_DOMAIN_TRUST_INCONSISTENT,		ERROR_DOMAIN_TRUST_INCONSISTENT,
	NT_STATUS_DOWNGRADE_DETECTED,			ERROR_DOWNGRADE_DETECTED,
	NT_STATUS_DRIVER_BLOCKED,			ERROR_DRIVER_BLOCKED,
	NT_STATUS_DRIVER_BLOCKED_CRITICAL,		ERROR_DRIVER_BLOCKED,
	NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND,		ERROR_PROC_NOT_FOUND,
	NT_STATUS_DRIVER_INTERNAL_ERROR,		ERROR_IO_DEVICE,
	NT_STATUS_DRIVER_ORDINAL_NOT_FOUND,		ERROR_INVALID_ORDINAL,
	NT_STATUS_DRIVER_UNABLE_TO_LOAD,		ERROR_BAD_DRIVER,
	NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED,		ERROR_DS_ADMIN_LIMIT_EXCEEDED,
	NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER,	ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER,
	NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS,		ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS,
	NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED,		ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED,
	NT_STATUS_DS_BUSY,				ERROR_DS_BUSY,
	NT_STATUS_DS_CANT_MOD_OBJ_CLASS,		ERROR_DS_CANT_MOD_OBJ_CLASS,
	NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID,		ERROR_DS_CANT_MOD_PRIMARYGROUPID,
	NT_STATUS_DS_CANT_ON_NON_LEAF,			ERROR_DS_CANT_ON_NON_LEAF,
	NT_STATUS_DS_CANT_ON_RDN,			ERROR_DS_CANT_ON_RDN,
	NT_STATUS_DS_CANT_START,			ERROR_DS_CANT_START,
	NT_STATUS_DS_CROSS_DOM_MOVE_FAILED,		ERROR_DS_CROSS_DOM_MOVE_ERROR,
	NT_STATUS_DS_GC_NOT_AVAILABLE,			ERROR_DS_GC_NOT_AVAILABLE,
	NT_STATUS_DS_GC_REQUIRED,			ERROR_DS_GC_REQUIRED,
	NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER, ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER,
	NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER,	ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER,
	NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER,	ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER,
	NT_STATUS_DS_HAVE_PRIMARY_MEMBERS,		ERROR_DS_HAVE_PRIMARY_MEMBERS,
	NT_STATUS_DS_INCORRECT_ROLE_OWNER,		ERROR_DS_INCORRECT_ROLE_OWNER,
	NT_STATUS_DS_INIT_FAILURE,			ERROR_DS_INIT_FAILURE,
	NT_STATUS_DS_INIT_FAILURE_CONSOLE,		ERROR_DS_INIT_FAILURE_CONSOLE,
	NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX,		ERROR_DS_INVALID_ATTRIBUTE_SYNTAX,
	NT_STATUS_DS_INVALID_GROUP_TYPE,		ERROR_DS_INVALID_GROUP_TYPE,
	NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER,
	NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY,	ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY,
	NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED,	ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED,
	NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY,	ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY,
	NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE,		ERROR_DS_NO_ATTRIBUTE_OR_VALUE,
	NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS,	ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS,
	NT_STATUS_DS_NO_MORE_RIDS,			ERROR_DS_NO_MORE_RIDS,
	NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN, ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN,
	NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN,	ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN,
	NT_STATUS_DS_NO_RIDS_ALLOCATED,			ERROR_DS_NO_RIDS_ALLOCATED,
	NT_STATUS_DS_OBJ_CLASS_VIOLATION,		ERROR_DS_OBJ_CLASS_VIOLATION,
	NT_STATUS_DS_RIDMGR_INIT_ERROR,			ERROR_DS_RIDMGR_INIT_ERROR,
	NT_STATUS_DS_SAM_INIT_FAILURE,			ERROR_DS_SAM_INIT_FAILURE,
	NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE,		ERROR_DS_SAM_INIT_FAILURE_CONSOLE,
	NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION,		ERROR_DS_SENSITIVE_GROUP_VIOLATION,
	NT_STATUS_DS_SHUTTING_DOWN,			ERROR_DS_SHUTTING_DOWN,
	NT_STATUS_DS_UNAVAILABLE,			ERROR_DS_UNAVAILABLE,
	NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER,	ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER,
	NT_STATUS_DUPLICATE_NAME,			ERROR_DUP_NAME,
	/* NT_STATUS_DUPLICATE_OBJECTID,		STATUS_DUPLICATE_OBJECTID, */
	NT_STATUS_EAS_NOT_SUPPORTED,			ERROR_EAS_NOT_SUPPORTED,
	NT_STATUS_EA_CORRUPT_ERROR,			ERROR_FILE_CORRUPT,
	NT_STATUS_EA_LIST_INCONSISTENT,			ERROR_EA_LIST_INCONSISTENT,
	NT_STATUS_EA_TOO_LARGE,				ERROR_EA_LIST_INCONSISTENT,
	NT_STATUS_EFS_ALG_BLOB_TOO_BIG,			ERROR_EFS_ALG_BLOB_TOO_BIG,
	NT_STATUS_ENCRYPTION_FAILED,			ERROR_ACCESS_DENIED,
	/* NT_STATUS_ENDPOINT_CLOSED,			ERROR_DEV_NOT_EXIST, */
	NT_STATUS_END_OF_FILE,				ERROR_HANDLE_EOF,
	NT_STATUS_END_OF_MEDIA,				ERROR_END_OF_MEDIA,
	NT_STATUS_ENTRYPOINT_NOT_FOUND,			ERROR_PROC_NOT_FOUND,
	NT_STATUS_EOM_OVERFLOW,				ERROR_EOM_OVERFLOW,
	NT_STATUS_EVENTLOG_CANT_START,			ERROR_EVENTLOG_CANT_START,
	NT_STATUS_EVENTLOG_FILE_CHANGED,		ERROR_EVENTLOG_FILE_CHANGED,
	NT_STATUS_EVENTLOG_FILE_CORRUPT,		ERROR_EVENTLOG_FILE_CORRUPT,
	NT_STATUS_FAIL_CHECK,				ERROR_INVALID_PARAMETER,
	NT_STATUS_FILEMARK_DETECTED,			ERROR_FILEMARK_DETECTED,
	NT_STATUS_FILES_OPEN,				ERROR_OPEN_FILES,
	NT_STATUS_FILE_CLOSED,				ERROR_INVALID_HANDLE,
	NT_STATUS_FILE_CORRUPT_ERROR,			ERROR_FILE_CORRUPT,
	NT_STATUS_FILE_DELETED,				ERROR_ACCESS_DENIED,
	NT_STATUS_FILE_ENCRYPTED,			ERROR_FILE_ENCRYPTED,
	NT_STATUS_FILE_FORCED_CLOSED,			ERROR_HANDLE_EOF,
	NT_STATUS_FILE_INVALID,				ERROR_FILE_INVALID,
	NT_STATUS_FILE_IS_A_DIRECTORY,			ERROR_ACCESS_DENIED,
	NT_STATUS_FILE_IS_OFFLINE,			ERROR_FILE_OFFLINE,
	NT_STATUS_FILE_LOCK_CONFLICT,			ERROR_LOCK_VIOLATION,
	NT_STATUS_FILE_NOT_ENCRYPTED,			ERROR_FILE_NOT_ENCRYPTED,
	NT_STATUS_FILE_RENAMED,				ERROR_ACCESS_DENIED,
	NT_STATUS_FLOPPY_BAD_REGISTERS,			ERROR_FLOPPY_BAD_REGISTERS,
	NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND,		ERROR_FLOPPY_ID_MARK_NOT_FOUND,
	NT_STATUS_FLOPPY_UNKNOWN_ERROR,			ERROR_FLOPPY_UNKNOWN_ERROR,
	NT_STATUS_FLOPPY_WRONG_CYLINDER,		ERROR_FLOPPY_WRONG_CYLINDER,
	NT_STATUS_FREE_VM_NOT_AT_BASE,			ERROR_INVALID_ADDRESS,
	NT_STATUS_FT_MISSING_MEMBER,			ERROR_IO_DEVICE,
	NT_STATUS_FT_ORPHANING,				ERROR_IO_DEVICE,
	NT_STATUS_FULLSCREEN_MODE,			ERROR_FULLSCREEN_MODE,
	NT_STATUS_GENERIC_NOT_MAPPED,			ERROR_GENERIC_NOT_MAPPED,
	NT_STATUS_GRACEFUL_DISCONNECT,			ERROR_GRACEFUL_DISCONNECT,
	NT_STATUS_GROUP_EXISTS,				ERROR_GROUP_EXISTS,
	NT_STATUS_GUIDS_EXHAUSTED,			ERROR_NO_MORE_ITEMS,
	NT_STATUS_HANDLE_NOT_CLOSABLE,			ERROR_INVALID_HANDLE,
	NT_STATUS_HOST_DOWN,				ERROR_HOST_DOWN,
	NT_STATUS_HOST_UNREACHABLE,			ERROR_HOST_UNREACHABLE,
	NT_STATUS_ILLEGAL_CHARACTER,			ERROR_NO_UNICODE_TRANSLATION,
	NT_STATUS_ILLEGAL_ELEMENT_ADDRESS,		ERROR_ILLEGAL_ELEMENT_ADDRESS,
	NT_STATUS_ILLEGAL_FUNCTION,			ERROR_INVALID_FUNCTION,
	NT_STATUS_ILL_FORMED_PASSWORD,			ERROR_ILL_FORMED_PASSWORD,
	NT_STATUS_IMAGE_ALREADY_LOADED,			ERROR_SERVICE_ALREADY_RUNNING,
	NT_STATUS_IMAGE_CHECKSUM_MISMATCH,		ERROR_BAD_EXE_FORMAT,
	NT_STATUS_IMAGE_MP_UP_MISMATCH,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INCOMPATIBLE_FILE_MAP,		ERROR_INVALID_PARAMETER,
	NT_STATUS_INFO_LENGTH_MISMATCH,			ERROR_BAD_LENGTH,
	NT_STATUS_INSTANCE_NOT_AVAILABLE,		ERROR_PIPE_BUSY,
	NT_STATUS_INSUFFICIENT_RESOURCES,		ERROR_NO_SYSTEM_RESOURCES,
	NT_STATUS_INSUFF_SERVER_RESOURCES,		ERROR_NOT_ENOUGH_SERVER_MEMORY,
	NT_STATUS_INTEGER_OVERFLOW,			ERROR_ARITHMETIC_OVERFLOW,
	NT_STATUS_INTERNAL_DB_CORRUPTION,		ERROR_INTERNAL_DB_CORRUPTION,
	NT_STATUS_INTERNAL_DB_ERROR,			ERROR_INTERNAL_DB_ERROR,
	NT_STATUS_INTERNAL_ERROR,			ERROR_INTERNAL_ERROR,
	NT_STATUS_INVALID_ACCOUNT_NAME,			ERROR_INVALID_ACCOUNT_NAME,
	NT_STATUS_INVALID_ACL,				ERROR_INVALID_ACL,
	NT_STATUS_INVALID_ADDRESS,			ERROR_UNEXP_NET_ERR,
	NT_STATUS_INVALID_ADDRESS_COMPONENT,		ERROR_INVALID_NETNAME,
	NT_STATUS_INVALID_ADDRESS_WILDCARD,		ERROR_INVALID_NETNAME,
	NT_STATUS_INVALID_BLOCK_LENGTH,			ERROR_INVALID_BLOCK_LENGTH,
	NT_STATUS_INVALID_BUFFER_SIZE,			ERROR_INVALID_USER_BUFFER,
	NT_STATUS_INVALID_CID,				ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_COMPUTER_NAME,		ERROR_INVALID_COMPUTERNAME,
	NT_STATUS_INVALID_CONNECTION,			ERROR_UNEXP_NET_ERR,
	NT_STATUS_INVALID_DEVICE_REQUEST,		ERROR_INVALID_FUNCTION,
	NT_STATUS_INVALID_DEVICE_STATE,			ERROR_BAD_COMMAND,
	NT_STATUS_INVALID_DOMAIN_ROLE,			ERROR_INVALID_DOMAIN_ROLE,
	NT_STATUS_INVALID_DOMAIN_STATE,			ERROR_INVALID_DOMAIN_STATE,
	NT_STATUS_INVALID_EA_FLAG,			ERROR_EA_LIST_INCONSISTENT,
	NT_STATUS_INVALID_EA_NAME,			ERROR_INVALID_EA_NAME,
	NT_STATUS_INVALID_FILE_FOR_SECTION,		ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_GROUP_ATTRIBUTES,		ERROR_INVALID_GROUP_ATTRIBUTES,
	NT_STATUS_INVALID_HANDLE,			ERROR_INVALID_HANDLE,
	NT_STATUS_INVALID_ID_AUTHORITY,			ERROR_INVALID_ID_AUTHORITY,
	NT_STATUS_INVALID_IMAGE_FORMAT,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_LE_FORMAT,		ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_NE_FORMAT,		ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_NOT_MZ,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_PROTECT,		ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_WIN_16,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_WIN_32,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMAGE_WIN_64,			ERROR_BAD_EXE_FORMAT,
	NT_STATUS_INVALID_IMPORT_OF_NON_DLL,		ERROR_INVALID_IMPORT_OF_NON_DLL,
	NT_STATUS_INVALID_INFO_CLASS,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_LEVEL,			ERROR_INVALID_LEVEL,
	NT_STATUS_INVALID_LOCK_SEQUENCE,		ERROR_ACCESS_DENIED,
	NT_STATUS_INVALID_LOGON_HOURS,			ERROR_INVALID_LOGON_HOURS,
	NT_STATUS_INVALID_LOGON_TYPE,			ERROR_INVALID_LOGON_TYPE,
	NT_STATUS_INVALID_MEMBER,			ERROR_INVALID_MEMBER,
	NT_STATUS_INVALID_NETWORK_RESPONSE,		ERROR_BAD_NET_RESP,
	NT_STATUS_INVALID_OPLOCK_PROTOCOL,		ERROR_INVALID_OPLOCK_PROTOCOL,
	NT_STATUS_INVALID_OWNER,			ERROR_INVALID_OWNER,
	NT_STATUS_INVALID_PAGE_PROTECTION,		ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_1,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_2,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_3,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_4,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_5,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_6,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_7,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_8,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_9,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_10,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_11,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_12,			ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PARAMETER_MIX,		ERROR_INVALID_PARAMETER,
	NT_STATUS_INVALID_PIPE_STATE,			ERROR_BAD_PIPE,
	NT_STATUS_INVALID_PORT_HANDLE,			ERROR_INVALID_HANDLE,
	NT_STATUS_INVALID_PRIMARY_GROUP,		ERROR_INVALID_PRIMARY_GROUP,
	NT_STATUS_INVALID_READ_MODE,			ERROR_BAD_PIPE,
	NT_STATUS_INVALID_SECURITY_DESCR,		ERROR_INVALID_SECURITY_DESCR,
	NT_STATUS_INVALID_SERVER_STATE,			ERROR_INVALID_SERVER_STATE,
	NT_STATUS_INVALID_SID,				ERROR_INVALID_SID,
	NT_STATUS_INVALID_SUB_AUTHORITY,		ERROR_INVALID_SUB_AUTHORITY,
	NT_STATUS_INVALID_SYSTEM_SERVICE,		ERROR_INVALID_FUNCTION,
	NT_STATUS_INVALID_USER_BUFFER,			ERROR_INVALID_USER_BUFFER,
	NT_STATUS_INVALID_VIEW_SIZE,			ERROR_ACCESS_DENIED,
	NT_STATUS_INVALID_VOLUME_LABEL,			ERROR_LABEL_TOO_LONG,
	NT_STATUS_INVALID_WORKSTATION,			ERROR_INVALID_WORKSTATION,
	NT_STATUS_IN_PAGE_ERROR,			ERROR_SWAPERROR,
	NT_STATUS_IO_DEVICE_ERROR,			ERROR_IO_DEVICE,
	NT_STATUS_IO_REPARSE_DATA_INVALID,		ERROR_INVALID_REPARSE_DATA,
	NT_STATUS_IO_REPARSE_TAG_INVALID,		ERROR_REPARSE_TAG_INVALID,
	NT_STATUS_IO_REPARSE_TAG_MISMATCH,		ERROR_REPARSE_TAG_MISMATCH,
	NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED,		ERROR_CANT_ACCESS_FILE,
	NT_STATUS_IO_TIMEOUT,				ERROR_SEM_TIMEOUT,
	NT_STATUS_ISSUING_CA_UNTRUSTED,			SEC_E_ISSUING_CA_UNTRUSTED,
	NT_STATUS_JOURNAL_DELETE_IN_PROGRESS,		ERROR_JOURNAL_DELETE_IN_PROGRESS,
	NT_STATUS_JOURNAL_ENTRY_DELETED,		ERROR_JOURNAL_ENTRY_DELETED,
	NT_STATUS_JOURNAL_NOT_ACTIVE,			ERROR_JOURNAL_NOT_ACTIVE,
	/* NT_STATUS_KDC_INVALID_REQUEST,		SEC_E_KDC_INVALID_REQUEST, */
	/* NT_STATUS_KDC_UNABLE_TO_REFER,		SEC_E_KDC_UNABLE_TO_REFER, */
	/* NT_STATUS_KDC_UNKNOWN_ETYPE,			SEC_E_KDC_UNKNOWN_ETYPE, */
	NT_STATUS_KEY_DELETED,				ERROR_KEY_DELETED,
	NT_STATUS_KEY_HAS_CHILDREN,			ERROR_KEY_HAS_CHILDREN,
	NT_STATUS_LAST_ADMIN,				ERROR_LAST_ADMIN,
	NT_STATUS_LICENSE_QUOTA_EXCEEDED,		ERROR_LICENSE_QUOTA_EXCEEDED,
	/* NT_STATUS_LICENSE_VIOLATION,			ERROR_CTX_LICENSE_NOT_AVAILABLE, */
	NT_STATUS_LINK_FAILED,				ERROR_UNEXP_NET_ERR,
	NT_STATUS_LINK_TIMEOUT,				ERROR_UNEXP_NET_ERR,
	NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED,		ERROR_LM_CROSS_ENCRYPTION_REQUIRED,
	NT_STATUS_LOCAL_DISCONNECT,			ERROR_NETNAME_DELETED,
	NT_STATUS_LOCAL_USER_SESSION_KEY,		ERROR_LOCAL_USER_SESSION_KEY,
	NT_STATUS_LOCK_NOT_GRANTED,			ERROR_LOCK_VIOLATION,
	NT_STATUS_LOGIN_TIME_RESTRICTION,		ERROR_LOGIN_TIME_RESTRICTION,
	NT_STATUS_LOGIN_WKSTA_RESTRICTION,		ERROR_LOGIN_WKSTA_RESTRICTION,
	NT_STATUS_LOGON_FAILURE,			ERROR_LOGON_FAILURE,
	NT_STATUS_LOGON_NOT_GRANTED,			ERROR_LOGON_NOT_GRANTED,
	NT_STATUS_LOGON_SESSION_COLLISION,		ERROR_LOGON_SESSION_COLLISION,
	NT_STATUS_LOGON_SESSION_EXISTS,			ERROR_LOGON_SESSION_EXISTS,
	NT_STATUS_LOGON_TYPE_NOT_GRANTED,		ERROR_LOGON_TYPE_NOT_GRANTED,
	NT_STATUS_LOG_FILE_FULL,			ERROR_LOG_FILE_FULL,
	NT_STATUS_LPC_REPLY_LOST,			ERROR_CONNECTION_ABORTED,
	NT_STATUS_LPC_REPLY_LOST,			ERROR_INTERNAL_ERROR,
	NT_STATUS_LUIDS_EXHAUSTED,			ERROR_LUIDS_EXHAUSTED,
	NT_STATUS_MAGAZINE_NOT_PRESENT,			ERROR_MAGAZINE_NOT_PRESENT,
	NT_STATUS_MAPPED_ALIGNMENT,			ERROR_MAPPED_ALIGNMENT,
	NT_STATUS_MAPPED_FILE_SIZE_ZERO,		ERROR_FILE_INVALID,
	/* NT_STATUS_MAX_REFERRALS_EXCEEDED,		SEC_E_MAX_REFERRALS_EXCEEDED, */
	NT_STATUS_MEDIA_CHANGED,			ERROR_MEDIA_CHANGED,
	NT_STATUS_MEDIA_WRITE_PROTECTED,		ERROR_WRITE_PROTECT,
	NT_STATUS_MEMBERS_PRIMARY_GROUP,		ERROR_MEMBERS_PRIMARY_GROUP,
	NT_STATUS_MEMBER_IN_ALIAS,			ERROR_MEMBER_IN_ALIAS,
	NT_STATUS_MEMBER_IN_GROUP,			ERROR_MEMBER_IN_GROUP,
	NT_STATUS_MEMBER_NOT_IN_ALIAS,			ERROR_MEMBER_NOT_IN_ALIAS,
	NT_STATUS_MEMBER_NOT_IN_GROUP,			ERROR_MEMBER_NOT_IN_GROUP,
	NT_STATUS_MEMORY_NOT_ALLOCATED,			ERROR_INVALID_ADDRESS,
	NT_STATUS_MESSAGE_NOT_FOUND,			ERROR_MR_MID_NOT_FOUND,
	NT_STATUS_MFT_TOO_FRAGMENTED,			ERROR_DISK_TOO_FRAGMENTED,
	NT_STATUS_MORE_ENTRIES,				ERROR_MORE_DATA,
	NT_STATUS_MORE_PROCESSING_REQUIRED,		ERROR_MORE_DATA,
	/* NT_STATUS_MUST_BE_KDC,			SEC_E_MUST_BE_KDC, */
	NT_STATUS_MUTANT_NOT_OWNED,			ERROR_NOT_OWNER,
	NT_STATUS_MUTUAL_AUTHENTICATION_FAILED,		ERROR_MUTUAL_AUTH_FAILED,
	NT_STATUS_NAME_TOO_LONG,			ERROR_FILENAME_EXCED_RANGE,
	NT_STATUS_NETLOGON_NOT_STARTED,			ERROR_NETLOGON_NOT_STARTED,
	NT_STATUS_NETWORK_ACCESS_DENIED,		ERROR_NETWORK_ACCESS_DENIED,
	NT_STATUS_NETWORK_BUSY,				ERROR_NETWORK_BUSY,
	NT_STATUS_NETWORK_CREDENTIAL_CONFLICT,		ERROR_SESSION_CREDENTIAL_CONFLICT,
	NT_STATUS_NETWORK_NAME_DELETED,			ERROR_NETNAME_DELETED,
	NT_STATUS_NETWORK_SESSION_EXPIRED,		ERROR_NO_USER_SESSION_KEY,
	NT_STATUS_NETWORK_UNREACHABLE,			ERROR_NETWORK_UNREACHABLE,
	NT_STATUS_NET_WRITE_FAULT,			ERROR_NET_WRITE_FAULT,
	NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,	ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,
	NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT,		ERROR_NOLOGON_SERVER_TRUST_ACCOUNT,
	NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT,	ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT,
	NT_STATUS_NONEXISTENT_EA_ENTRY,			ERROR_FILE_CORRUPT,
	/* NT_STATUS_NONEXISTENT_NET_NAME,		ERROR_DEV_NOT_EXIST, */
	NT_STATUS_NONEXISTENT_SECTOR,			ERROR_SECTOR_NOT_FOUND,
	NT_STATUS_NONE_MAPPED,				ERROR_NONE_MAPPED,
	NT_STATUS_NOTIFY_ENUM_DIR,			ERROR_NOTIFY_ENUM_DIR,
	NT_STATUS_NOT_ALL_ASSIGNED,			ERROR_NOT_ALL_ASSIGNED,
	NT_STATUS_NOT_A_DIRECTORY,			ERROR_DIRECTORY,
	NT_STATUS_NOT_A_REPARSE_POINT,			ERROR_NOT_A_REPARSE_POINT,
	NT_STATUS_NOT_CLIENT_SESSION,			ERROR_NOT_SUPPORTED,
	NT_STATUS_NOT_COMMITTED,			ERROR_INVALID_ADDRESS,
	NT_STATUS_NOT_EXPORT_FORMAT,			ERROR_NOT_EXPORT_FORMAT,
	NT_STATUS_NOT_FOUND,				ERROR_NOT_FOUND,
	NT_STATUS_NOT_IMPLEMENTED,			ERROR_INVALID_FUNCTION,
	NT_STATUS_NOT_LOCKED,				ERROR_NOT_LOCKED,
	NT_STATUS_NOT_LOGON_PROCESS,			ERROR_NOT_LOGON_PROCESS,
	NT_STATUS_NOT_MAPPED_DATA,			ERROR_INVALID_ADDRESS,
	NT_STATUS_NOT_MAPPED_VIEW,			ERROR_INVALID_ADDRESS,
	NT_STATUS_NOT_REGISTRY_FILE,			ERROR_NOT_REGISTRY_FILE,
	NT_STATUS_NOT_SAME_DEVICE,			ERROR_NOT_SAME_DEVICE,
	NT_STATUS_NOT_SERVER_SESSION,			ERROR_NOT_SUPPORTED,
	NT_STATUS_NOT_SUPPORTED,			ERROR_NOT_SUPPORTED,
	NT_STATUS_NOT_SUPPORTED_ON_SBS,			ERROR_NOT_SUPPORTED_ON_SBS,
	NT_STATUS_NO_BROWSER_SERVERS_FOUND,		ERROR_NO_BROWSER_SERVERS_FOUND,
	NT_STATUS_NO_DATA_DETECTED,			ERROR_NO_DATA_DETECTED,
	NT_STATUS_NO_EAS_ON_FILE,			ERROR_FILE_CORRUPT,
	NT_STATUS_NO_EFS,				ERROR_ACCESS_DENIED,
	NT_STATUS_NO_IMPERSONATION_TOKEN,		ERROR_NO_IMPERSONATION_TOKEN,
	NT_STATUS_NO_INHERITANCE,			ERROR_NO_INHERITANCE,
	/* NT_STATUS_NO_IP_ADDRESSES,			SEC_E_NO_IP_ADDRESSES, */
	/* NT_STATUS_NO_KERB_KEY,			SEC_E_NO_KERB_KEY, */
	NT_STATUS_NO_LDT,				ERROR_INVALID_THREAD_ID,
	NT_STATUS_NO_LOGON_SERVERS,			ERROR_NO_LOGON_SERVERS,
	NT_STATUS_NO_LOG_SPACE,				ERROR_NO_LOG_SPACE,
	NT_STATUS_NO_MATCH,				ERROR_NO_MATCH,
	NT_STATUS_NO_MEDIA,				ERROR_NO_MEDIA_IN_DRIVE,
	NT_STATUS_NO_MEDIA_IN_DEVICE,			ERROR_NOT_READY,
	NT_STATUS_NO_MEMORY,				ERROR_NOT_ENOUGH_MEMORY,
	NT_STATUS_NO_MORE_EAS,				ERROR_NO_MORE_ITEMS,
	NT_STATUS_NO_MORE_ENTRIES,			ERROR_NO_MORE_ITEMS,
	NT_STATUS_NO_MORE_FILES,			ERROR_NO_MORE_FILES,
	/* NT_STATUS_NO_PA_DATA,			SEC_E_NO_PA_DATA, */
	NT_STATUS_NO_QUOTAS_FOR_ACCOUNT,		ERROR_NO_QUOTAS_FOR_ACCOUNT,
	NT_STATUS_NO_RECOVERY_POLICY,			ERROR_ACCESS_DENIED,
	NT_STATUS_NO_SECURITY_ON_OBJECT,		ERROR_NO_SECURITY_ON_OBJECT,
	NT_STATUS_NO_SPOOL_SPACE,			ERROR_NO_SPOOL_SPACE,
	NT_STATUS_NO_SUCH_ALIAS,			ERROR_NO_SUCH_ALIAS,
	NT_STATUS_NO_SUCH_DEVICE,			ERROR_FILE_NOT_FOUND,
	NT_STATUS_NO_SUCH_DOMAIN,			ERROR_NO_SUCH_DOMAIN,
	NT_STATUS_NO_SUCH_FILE,				ERROR_FILE_NOT_FOUND,
	NT_STATUS_NO_SUCH_GROUP,			ERROR_NO_SUCH_GROUP,
	NT_STATUS_NO_SUCH_LOGON_SESSION,		ERROR_NO_SUCH_LOGON_SESSION,
	NT_STATUS_NO_SUCH_MEMBER,			ERROR_NO_SUCH_MEMBER,
	NT_STATUS_NO_SUCH_PACKAGE,			ERROR_NO_SUCH_PACKAGE,
	NT_STATUS_NO_SUCH_PRIVILEGE,			ERROR_NO_SUCH_PRIVILEGE,
	NT_STATUS_NO_SUCH_USER,				ERROR_NO_SUCH_USER,
	/* NT_STATUS_NO_TGT_REPLY,			SEC_E_NO_TGT_REPLY, */
	NT_STATUS_NO_TOKEN,				ERROR_NO_TOKEN,
	NT_STATUS_NO_TRACKING_SERVICE,			ERROR_NO_TRACKING_SERVICE,
	NT_STATUS_NO_TRUST_LSA_SECRET,			ERROR_NO_TRUST_LSA_SECRET,
	NT_STATUS_NO_TRUST_SAM_ACCOUNT,			ERROR_NO_TRUST_SAM_ACCOUNT,
	NT_STATUS_NO_USER_KEYS,				ERROR_ACCESS_DENIED,
	NT_STATUS_NO_USER_SESSION_KEY,			ERROR_NO_USER_SESSION_KEY,
	NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED,		ERROR_NT_CROSS_ENCRYPTION_REQUIRED,
	NT_STATUS_NULL_LM_PASSWORD,			ERROR_NULL_LM_PASSWORD,
	/* NT_STATUS_OBJECTID_EXISTS,			STATUS_OBJECTID_EXISTS, */
	NT_STATUS_OBJECTID_NOT_FOUND,			ERROR_FILE_NOT_FOUND,
	NT_STATUS_OBJECT_NAME_COLLISION,		ERROR_ALREADY_EXISTS,
	NT_STATUS_OBJECT_NAME_INVALID,			ERROR_INVALID_NAME,
	NT_STATUS_OBJECT_NAME_NOT_FOUND,		ERROR_FILE_NOT_FOUND,
	NT_STATUS_OBJECT_PATH_INVALID,			ERROR_BAD_PATHNAME,
	NT_STATUS_OBJECT_PATH_NOT_FOUND,		ERROR_PATH_NOT_FOUND,
	NT_STATUS_OBJECT_PATH_SYNTAX_BAD,		ERROR_BAD_PATHNAME,
	NT_STATUS_OBJECT_TYPE_MISMATCH,			ERROR_INVALID_HANDLE,
	NT_STATUS_ONLY_IF_CONNECTED,			ERROR_ONLY_IF_CONNECTED,
	NT_STATUS_OPEN_FAILED,				ERROR_OPEN_FAILED,
	NT_STATUS_OPLOCK_NOT_GRANTED,			ERROR_OPLOCK_NOT_GRANTED,
	NT_STATUS_ORDINAL_NOT_FOUND,			ERROR_INVALID_ORDINAL,
	NT_STATUS_PAGEFILE_QUOTA,			ERROR_PAGEFILE_QUOTA,
	NT_STATUS_PARTIAL_COPY,				ERROR_PARTIAL_COPY,
	NT_STATUS_PARTITION_FAILURE,			ERROR_PARTITION_FAILURE,
	NT_STATUS_PASSWORD_EXPIRED,			ERROR_PASSWORD_EXPIRED,
	NT_STATUS_PASSWORD_MUST_CHANGE,			ERROR_PASSWORD_MUST_CHANGE,
	NT_STATUS_PASSWORD_RESTRICTION,			ERROR_PASSWORD_RESTRICTION,
	NT_STATUS_PATH_NOT_COVERED,			ERROR_HOST_UNREACHABLE,
	NT_STATUS_PENDING,				ERROR_IO_PENDING,
	NT_STATUS_PIPE_BROKEN,				ERROR_BROKEN_PIPE,
	NT_STATUS_PIPE_BUSY,				ERROR_PIPE_BUSY,
	NT_STATUS_PIPE_CLOSING,				ERROR_NO_DATA,
	NT_STATUS_PIPE_CONNECTED,			ERROR_PIPE_CONNECTED,
	NT_STATUS_PIPE_DISCONNECTED,			ERROR_PIPE_NOT_CONNECTED,
	NT_STATUS_PIPE_EMPTY,				ERROR_NO_DATA,
	NT_STATUS_PIPE_LISTENING,			ERROR_PIPE_LISTENING,
	NT_STATUS_PIPE_NOT_AVAILABLE,			ERROR_PIPE_BUSY,
	NT_STATUS_PKINIT_CLIENT_FAILURE,		SEC_E_PKINIT_CLIENT_FAILURE,
	NT_STATUS_PKINIT_FAILURE,			ERROR_PKINIT_FAILURE,
	/* NT_STATUS_PKINIT_NAME_MISMATCH,		SEC_E_PKINIT_NAME_MISMATCH, */
	NT_STATUS_PLUGPLAY_NO_DEVICE,			ERROR_SERVICE_DISABLED,
	NT_STATUS_POLICY_OBJECT_NOT_FOUND,		ERROR_POLICY_OBJECT_NOT_FOUND,
	NT_STATUS_POLICY_ONLY_IN_DS,			ERROR_POLICY_ONLY_IN_DS,
	NT_STATUS_PORT_ALREADY_SET,			ERROR_INVALID_PARAMETER,
	NT_STATUS_PORT_CONNECTION_REFUSED,		ERROR_ACCESS_DENIED,
	NT_STATUS_PORT_DISCONNECTED,			ERROR_INVALID_HANDLE,
	NT_STATUS_PORT_UNREACHABLE,			ERROR_PORT_UNREACHABLE,
	NT_STATUS_POSSIBLE_DEADLOCK,			ERROR_POSSIBLE_DEADLOCK,
	NT_STATUS_PRENT4_MACHINE_ACCOUNT,		ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4,
	NT_STATUS_PRINT_CANCELLED,			ERROR_PRINT_CANCELLED,
	NT_STATUS_PRINT_QUEUE_FULL,			ERROR_PRINTQ_FULL,
	NT_STATUS_PRIVILEGE_NOT_HELD,			ERROR_PRIVILEGE_NOT_HELD,
	NT_STATUS_PROCEDURE_NOT_FOUND,			ERROR_PROC_NOT_FOUND,
	NT_STATUS_PROCESS_IS_TERMINATING,		ERROR_ACCESS_DENIED,
	NT_STATUS_PROPSET_NOT_FOUND,			ERROR_SET_NOT_FOUND,
	NT_STATUS_PROTOCOL_UNREACHABLE,			ERROR_PROTOCOL_UNREACHABLE,
	NT_STATUS_QUOTA_EXCEEDED,			ERROR_NOT_ENOUGH_QUOTA,
	NT_STATUS_RANGE_NOT_FOUND,			ERROR_NOT_LOCKED,
	NT_STATUS_RANGE_NOT_LOCKED,			ERROR_NOT_LOCKED,
	NT_STATUS_REDIRECTOR_NOT_STARTED,		ERROR_PATH_NOT_FOUND,
	NT_STATUS_REDIRECTOR_PAUSED,			ERROR_REDIR_PAUSED,
	NT_STATUS_REDIRECTOR_STARTED,			ERROR_SERVICE_ALREADY_RUNNING,
	NT_STATUS_REGISTRY_CORRUPT,			ERROR_BADDB,
	NT_STATUS_REGISTRY_IO_FAILED,			ERROR_REGISTRY_IO_FAILED,
	NT_STATUS_REGISTRY_RECOVERED,			ERROR_REGISTRY_RECOVERED,
	NT_STATUS_REG_NAT_CONSUMPTION,			ERROR_REG_NAT_CONSUMPTION,
	NT_STATUS_REINITIALIZATION_NEEDED,		ERROR_DEVICE_REINITIALIZATION_NEEDED,
	NT_STATUS_REMOTE_DISCONNECT,			ERROR_NETNAME_DELETED,
	NT_STATUS_REMOTE_NOT_LISTENING,			ERROR_REM_NOT_LIST,
	NT_STATUS_REMOTE_RESOURCES,			ERROR_REM_NOT_LIST,
	NT_STATUS_REMOTE_SESSION_LIMIT,			ERROR_REMOTE_SESSION_LIMIT_EXCEEDED,
	NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR,		ERROR_REMOTE_STORAGE_MEDIA_ERROR,
	NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE,		ERROR_REMOTE_STORAGE_NOT_ACTIVE,
	NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT,		ERROR_REPARSE_ATTRIBUTE_CONFLICT,
	NT_STATUS_REPARSE_POINT_NOT_RESOLVED,		ERROR_CANT_RESOLVE_FILENAME,
	NT_STATUS_REQUEST_ABORTED,			ERROR_REQUEST_ABORTED,
	NT_STATUS_REQUEST_NOT_ACCEPTED,			ERROR_REQ_NOT_ACCEP,
	NT_STATUS_RESOURCE_DATA_NOT_FOUND,		ERROR_RESOURCE_DATA_NOT_FOUND,
	NT_STATUS_RESOURCE_LANG_NOT_FOUND,		ERROR_RESOURCE_LANG_NOT_FOUND,
	NT_STATUS_RESOURCE_NAME_NOT_FOUND,		ERROR_RESOURCE_NAME_NOT_FOUND,
	NT_STATUS_RESOURCE_NOT_OWNED,			ERROR_NOT_OWNER,
	NT_STATUS_RESOURCE_TYPE_NOT_FOUND,		ERROR_RESOURCE_TYPE_NOT_FOUND,
	NT_STATUS_RETRY,				ERROR_RETRY,
	NT_STATUS_REVISION_MISMATCH,			ERROR_REVISION_MISMATCH,
	NT_STATUS_REVOCATION_OFFLINE_C,			SEC_E_REVOCATION_OFFLINE_C,
	NT_STATUS_RXACT_COMMIT_FAILURE,			ERROR_RXACT_COMMIT_FAILURE,
	NT_STATUS_RXACT_INVALID_STATE,			ERROR_RXACT_INVALID_STATE,
	NT_STATUS_SAM_INIT_FAILURE,			ERROR_SAM_INIT_FAILURE,
	NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY,		ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY,
	NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD,		ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD,
	NT_STATUS_SECRET_TOO_LONG,			ERROR_SECRET_TOO_LONG,
	NT_STATUS_SECTION_NOT_EXTENDED,			ERROR_OUTOFMEMORY,
	NT_STATUS_SECTION_NOT_IMAGE,			ERROR_INVALID_PARAMETER,
	NT_STATUS_SECTION_PROTECTION,			ERROR_INVALID_PARAMETER,
	NT_STATUS_SECTION_TOO_BIG,			ERROR_NOT_ENOUGH_MEMORY,
	NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED,		ERROR_TOO_MANY_POSTS,
	NT_STATUS_SERIAL_COUNTER_TIMEOUT,		ERROR_COUNTER_TIMEOUT,
	NT_STATUS_SERIAL_MORE_WRITES,			ERROR_MORE_WRITES,
	NT_STATUS_SERIAL_NO_DEVICE_INITED,		ERROR_SERIAL_NO_DEVICE,
	NT_STATUS_SERVER_DISABLED,			ERROR_SERVER_DISABLED,
	NT_STATUS_SERVER_NOT_DISABLED,			ERROR_SERVER_NOT_DISABLED,
	NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS,		ERROR_SERVER_SHUTDOWN_IN_PROGRESS,
	NT_STATUS_SETMARK_DETECTED,			ERROR_SETMARK_DETECTED,
	NT_STATUS_SHARED_IRQ_BUSY,			ERROR_IRQ_BUSY,
	NT_STATUS_SHARED_POLICY,			ERROR_SHARED_POLICY,
	NT_STATUS_SHARING_PAUSED,			ERROR_SHARING_PAUSED,
	NT_STATUS_SHARING_VIOLATION,			ERROR_SHARING_VIOLATION,
	NT_STATUS_SHUTDOWN_IN_PROGRESS,			ERROR_SHUTDOWN_IN_PROGRESS,
	/* NT_STATUS_SMARTCARD_... */
	NT_STATUS_SOME_NOT_MAPPED,			ERROR_SOME_NOT_MAPPED,
	NT_STATUS_SOURCE_ELEMENT_EMPTY,			ERROR_SOURCE_ELEMENT_EMPTY,
	NT_STATUS_SPECIAL_ACCOUNT,			ERROR_SPECIAL_ACCOUNT,
	NT_STATUS_SPECIAL_GROUP,			ERROR_SPECIAL_GROUP,
	NT_STATUS_SPECIAL_USER,				ERROR_SPECIAL_USER,
	NT_STATUS_STACK_OVERFLOW,			ERROR_STACK_OVERFLOW,
	/* NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED,	SEC_E_STRONG_CRYPTO_NOT_SUPPORTED, */
	NT_STATUS_SUSPEND_COUNT_EXCEEDED,		ERROR_SIGNAL_REFUSED,
	/* NT_STATUS_SXS_... */
	NT_STATUS_THREAD_IS_TERMINATING,		ERROR_ACCESS_DENIED,
	NT_STATUS_TIME_DIFFERENCE_AT_DC,		ERROR_TIME_SKEW,
	NT_STATUS_TOKEN_ALREADY_IN_USE,			ERROR_TOKEN_ALREADY_IN_USE,
	NT_STATUS_TOO_LATE,				ERROR_WRITE_PROTECT,
	NT_STATUS_TOO_MANY_ADDRESSES,			ERROR_TOO_MANY_NAMES,
	NT_STATUS_TOO_MANY_COMMANDS,			ERROR_TOO_MANY_CMDS,
	NT_STATUS_TOO_MANY_CONTEXT_IDS,			ERROR_TOO_MANY_CONTEXT_IDS,
	NT_STATUS_TOO_MANY_GUIDS_REQUESTED,		ERROR_TOO_MANY_NAMES,
	NT_STATUS_TOO_MANY_LINKS,			ERROR_TOO_MANY_LINKS,
	NT_STATUS_TOO_MANY_LUIDS_REQUESTED,		ERROR_TOO_MANY_LUIDS_REQUESTED,
	NT_STATUS_TOO_MANY_NAMES,			ERROR_TOO_MANY_NAMES,
	NT_STATUS_TOO_MANY_NODES,			ERROR_TOO_MANY_NAMES,
	NT_STATUS_TOO_MANY_OPENED_FILES,		ERROR_TOO_MANY_OPEN_FILES,
	NT_STATUS_TOO_MANY_PAGING_FILES,		ERROR_NOT_ENOUGH_MEMORY,
	/* NT_STATUS_TOO_MANY_PRINCIPALS,		SEC_E_TOO_MANY_PRINCIPALS, */
	NT_STATUS_TOO_MANY_SECRETS,			ERROR_TOO_MANY_SECRETS,
	NT_STATUS_TOO_MANY_SESSIONS,			ERROR_TOO_MANY_SESS,
	NT_STATUS_TOO_MANY_SIDS,			ERROR_TOO_MANY_SIDS,
	NT_STATUS_TRANSACTION_ABORTED,			ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSACTION_INVALID_ID,		ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSACTION_INVALID_TYPE,		ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSACTION_NO_MATCH,			ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSACTION_NO_RELEASE,		ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSACTION_RESPONDED,		ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSACTION_TIMED_OUT,		ERROR_UNEXP_NET_ERR,
	NT_STATUS_TRANSPORT_FULL,			ERROR_TRANSPORT_FULL,
	NT_STATUS_TRUSTED_DOMAIN_FAILURE,		ERROR_TRUSTED_DOMAIN_FAILURE,
	NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE,		ERROR_TRUSTED_RELATIONSHIP_FAILURE,
	NT_STATUS_TRUST_FAILURE,			ERROR_TRUST_FAILURE,
	NT_STATUS_UNABLE_TO_DECOMMIT_VM,		ERROR_INVALID_ADDRESS,
	NT_STATUS_UNABLE_TO_DELETE_SECTION,		ERROR_INVALID_PARAMETER,
	NT_STATUS_UNABLE_TO_FREE_VM,			ERROR_INVALID_PARAMETER,
	NT_STATUS_UNABLE_TO_LOCK_MEDIA,			ERROR_UNABLE_TO_LOCK_MEDIA,
	NT_STATUS_UNABLE_TO_UNLOAD_MEDIA,		ERROR_UNABLE_TO_UNLOAD_MEDIA,
	NT_STATUS_UNDEFINED_CHARACTER,			ERROR_NO_UNICODE_TRANSLATION,
	NT_STATUS_UNEXPECTED_NETWORK_ERROR,		ERROR_UNEXP_NET_ERR,
	/* NT_STATUS_UNFINISHED_CONTEXT_DELETED,	SEC_E_UNFINISHED_CONTEXT_DELETED, */
	NT_STATUS_UNKNOWN_REVISION,			ERROR_UNKNOWN_REVISION,
	NT_STATUS_UNMAPPABLE_CHARACTER,			ERROR_NO_UNICODE_TRANSLATION,
	NT_STATUS_UNRECOGNIZED_MEDIA,			ERROR_UNRECOGNIZED_MEDIA,
	NT_STATUS_UNRECOGNIZED_VOLUME,			ERROR_UNRECOGNIZED_VOLUME,
	NT_STATUS_UNSUCCESSFUL,				ERROR_GEN_FAILURE,
	/* NT_STATUS_UNSUPPORTED_PREAUTH,		SEC_E_UNSUPPORTED_PREAUTH, */
	NT_STATUS_USER_EXISTS,				ERROR_USER_EXISTS,
	NT_STATUS_USER_MAPPED_FILE,			ERROR_USER_MAPPED_FILE,
	NT_STATUS_USER_SESSION_DELETED,			ERROR_UNEXP_NET_ERR,
	NT_STATUS_VARIABLE_NOT_FOUND,			ERROR_ENVVAR_NOT_FOUND,
	NT_STATUS_VERIFY_REQUIRED,			ERROR_MEDIA_CHANGED,
	NT_STATUS_VIRTUAL_CIRCUIT_CLOSED,		ERROR_VC_DISCONNECTED,
	NT_STATUS_VOLUME_DISMOUNTED,			ERROR_NOT_READY,
	NT_STATUS_VOLUME_NOT_UPGRADED,			ERROR_INVALID_FUNCTION,
	NT_STATUS_WMI_ALREADY_DISABLED,			ERROR_WMI_ALREADY_DISABLED,
	NT_STATUS_WMI_ALREADY_ENABLED,			ERROR_WMI_ALREADY_ENABLED,
	NT_STATUS_WMI_GUID_DISCONNECTED,		ERROR_WMI_GUID_DISCONNECTED,
	NT_STATUS_WMI_GUID_NOT_FOUND,			ERROR_WMI_GUID_NOT_FOUND,
	NT_STATUS_WMI_INSTANCE_NOT_FOUND,		ERROR_WMI_INSTANCE_NOT_FOUND,
	NT_STATUS_WMI_ITEMID_NOT_FOUND,			ERROR_WMI_ITEMID_NOT_FOUND,
	NT_STATUS_WMI_NOT_SUPPORTED,			ERROR_NOT_SUPPORTED,
	NT_STATUS_WMI_READ_ONLY,			ERROR_WMI_READ_ONLY,
	NT_STATUS_WMI_SET_FAILURE,			ERROR_WMI_SET_FAILURE,
	NT_STATUS_WMI_TRY_AGAIN,			ERROR_WMI_TRY_AGAIN,
	NT_STATUS_WORKING_SET_LIMIT_RANGE,		ERROR_INVALID_PARAMETER,
	NT_STATUS_WORKING_SET_QUOTA,			ERROR_WORKING_SET_QUOTA,
	/* NT_STATUS_WRONG_CREDENTIAL_HANDLE,		SEC_E_WRONG_CREDENTIAL_HANDLE, */
	NT_STATUS_WRONG_EFS,				ERROR_ACCESS_DENIED,
	NT_STATUS_WRONG_PASSWORD,			ERROR_INVALID_PASSWORD,
	NT_STATUS_WRONG_PASSWORD_CORE,			ERROR_INVALID_PASSWORD,
	NT_STATUS_WRONG_VOLUME,				ERROR_WRONG_DISK,

	EPT_NT_CANT_CREATE,				EPT_S_CANT_CREATE,
	EPT_NT_CANT_PERFORM_OP,				EPT_S_CANT_PERFORM_OP,
	EPT_NT_INVALID_ENTRY,				EPT_S_INVALID_ENTRY,
	EPT_NT_NOT_REGISTERED,				EPT_S_NOT_REGISTERED,

	RPC_NT_ADDRESS_ERROR,				RPC_S_ADDRESS_ERROR,
	RPC_NT_ALREADY_LISTENING,			RPC_S_ALREADY_LISTENING,
	RPC_NT_ALREADY_REGISTERED,			RPC_S_ALREADY_REGISTERED,
	RPC_NT_BAD_STUB_DATA,				RPC_X_BAD_STUB_DATA,
	RPC_NT_BINDING_HAS_NO_AUTH,			RPC_S_BINDING_HAS_NO_AUTH,
	RPC_NT_BINDING_INCOMPLETE,			RPC_S_BINDING_INCOMPLETE,
	RPC_NT_BYTE_COUNT_TOO_SMALL,			RPC_X_BYTE_COUNT_TOO_SMALL,
	RPC_NT_CALL_CANCELLED,				RPC_S_CALL_CANCELLED,
	RPC_NT_CALL_FAILED,				RPC_S_CALL_FAILED,
	RPC_NT_CALL_FAILED_DNE,				RPC_S_CALL_FAILED_DNE,
	RPC_NT_CALL_IN_PROGRESS,			RPC_S_CALL_IN_PROGRESS,
	RPC_NT_CANNOT_SUPPORT,				RPC_S_CANNOT_SUPPORT,
	RPC_NT_CANT_CREATE_ENDPOINT,			RPC_S_CANT_CREATE_ENDPOINT,
	RPC_NT_COMM_FAILURE,				RPC_S_COMM_FAILURE,
	RPC_NT_DUPLICATE_ENDPOINT,			RPC_S_DUPLICATE_ENDPOINT,
	RPC_NT_ENTRY_ALREADY_EXISTS,			RPC_S_ENTRY_ALREADY_EXISTS,
	RPC_NT_ENTRY_NOT_FOUND,				RPC_S_ENTRY_NOT_FOUND,
	RPC_NT_ENUM_VALUE_OUT_OF_RANGE,			RPC_X_ENUM_VALUE_OUT_OF_RANGE,
	RPC_NT_FP_DIV_ZERO,				RPC_S_FP_DIV_ZERO,
	RPC_NT_FP_OVERFLOW,				RPC_S_FP_OVERFLOW,
	RPC_NT_FP_UNDERFLOW,				RPC_S_FP_UNDERFLOW,
	RPC_NT_GROUP_MEMBER_NOT_FOUND,			RPC_S_GROUP_MEMBER_NOT_FOUND,
	RPC_NT_INCOMPLETE_NAME,				RPC_S_INCOMPLETE_NAME,
	RPC_NT_INTERFACE_NOT_FOUND,			RPC_S_INTERFACE_NOT_FOUND,
	RPC_NT_INTERNAL_ERROR,				RPC_S_INTERNAL_ERROR,
	RPC_NT_INVALID_ASYNC_CALL,			RPC_S_INVALID_ASYNC_CALL,
	RPC_NT_INVALID_ASYNC_HANDLE,			RPC_S_INVALID_ASYNC_HANDLE,
	RPC_NT_INVALID_AUTH_IDENTITY,			RPC_S_INVALID_AUTH_IDENTITY,
	RPC_NT_INVALID_BINDING,				ERROR_INVALID_HANDLE,
	RPC_NT_INVALID_BOUND,				RPC_S_INVALID_BOUND,
	RPC_NT_INVALID_ENDPOINT_FORMAT,			RPC_S_INVALID_ENDPOINT_FORMAT,
	RPC_NT_INVALID_ES_ACTION,			RPC_X_INVALID_ES_ACTION,
	RPC_NT_INVALID_NAF_ID,				RPC_S_INVALID_NAF_ID,
	RPC_NT_INVALID_NAME_SYNTAX,			RPC_S_INVALID_NAME_SYNTAX,
	RPC_NT_INVALID_NETWORK_OPTIONS,			RPC_S_INVALID_NETWORK_OPTIONS,
	RPC_NT_INVALID_NET_ADDR,			RPC_S_INVALID_NET_ADDR,
	RPC_NT_INVALID_OBJECT,				RPC_S_INVALID_OBJECT,
	RPC_NT_INVALID_PIPE_OBJECT,			RPC_X_INVALID_PIPE_OBJECT,
	RPC_NT_INVALID_PIPE_OPERATION,			RPC_X_WRONG_PIPE_ORDER,
	RPC_NT_INVALID_RPC_PROTSEQ,			RPC_S_INVALID_RPC_PROTSEQ,
	RPC_NT_INVALID_STRING_BINDING,			RPC_S_INVALID_STRING_BINDING,
	RPC_NT_INVALID_STRING_UUID,			RPC_S_INVALID_STRING_UUID,
	RPC_NT_INVALID_TAG,				RPC_S_INVALID_TAG,
	RPC_NT_INVALID_TIMEOUT,				RPC_S_INVALID_TIMEOUT,
	RPC_NT_INVALID_VERS_OPTION,			RPC_S_INVALID_VERS_OPTION,
	RPC_NT_MAX_CALLS_TOO_SMALL,			RPC_S_MAX_CALLS_TOO_SMALL,
	RPC_NT_NAME_SERVICE_UNAVAILABLE,		RPC_S_NAME_SERVICE_UNAVAILABLE,
	RPC_NT_NOTHING_TO_EXPORT,			RPC_S_NOTHING_TO_EXPORT,
	RPC_NT_NOT_ALL_OBJS_UNEXPORTED,			RPC_S_NOT_ALL_OBJS_UNEXPORTED,
	RPC_NT_NOT_CANCELLED,				RPC_S_NOT_CANCELLED,
	RPC_NT_NOT_LISTENING,				RPC_S_NOT_LISTENING,
	RPC_NT_NOT_RPC_ERROR,				RPC_S_NOT_RPC_ERROR,
	RPC_NT_NO_BINDINGS,				RPC_S_NO_BINDINGS,
	RPC_NT_NO_CALL_ACTIVE,				RPC_S_NO_CALL_ACTIVE,
	RPC_NT_NO_CONTEXT_AVAILABLE,			RPC_S_NO_CONTEXT_AVAILABLE,
	RPC_NT_NO_ENDPOINT_FOUND,			RPC_S_NO_ENDPOINT_FOUND,
	RPC_NT_NO_ENTRY_NAME,				RPC_S_NO_ENTRY_NAME,
	RPC_NT_NO_INTERFACES,				RPC_S_NO_INTERFACES,
	RPC_NT_NO_MORE_BINDINGS,			RPC_S_NO_MORE_BINDINGS,
	RPC_NT_NO_MORE_ENTRIES,				RPC_X_NO_MORE_ENTRIES,
	RPC_NT_NO_MORE_MEMBERS,				RPC_S_NO_MORE_MEMBERS,
	RPC_NT_NO_PRINC_NAME,				RPC_S_NO_PRINC_NAME,
	RPC_NT_NO_PROTSEQS,				RPC_S_NO_PROTSEQS,
	RPC_NT_NO_PROTSEQS_REGISTERED,			RPC_S_NO_PROTSEQS_REGISTERED,
	RPC_NT_NULL_REF_POINTER,			RPC_X_NULL_REF_POINTER,
	RPC_NT_OBJECT_NOT_FOUND,			RPC_S_OBJECT_NOT_FOUND,
	RPC_NT_OUT_OF_RESOURCES,			RPC_S_OUT_OF_RESOURCES,
	RPC_NT_PIPE_CLOSED,				RPC_X_PIPE_CLOSED,
	RPC_NT_PIPE_DISCIPLINE_ERROR,			RPC_X_PIPE_DISCIPLINE_ERROR,
	RPC_NT_PIPE_EMPTY,				RPC_X_PIPE_EMPTY,
	RPC_NT_PROCNUM_OUT_OF_RANGE,			RPC_S_PROCNUM_OUT_OF_RANGE,
	RPC_NT_PROTOCOL_ERROR,				RPC_S_PROTOCOL_ERROR,
	RPC_NT_PROTSEQ_NOT_FOUND,			RPC_S_PROTSEQ_NOT_FOUND,
	RPC_NT_PROTSEQ_NOT_SUPPORTED,			RPC_S_PROTSEQ_NOT_SUPPORTED,
	RPC_NT_SEC_PKG_ERROR,				RPC_S_SEC_PKG_ERROR,
	RPC_NT_SEND_INCOMPLETE,				RPC_S_SEND_INCOMPLETE,
	RPC_NT_SERVER_TOO_BUSY,				RPC_S_SERVER_TOO_BUSY,
	RPC_NT_SERVER_UNAVAILABLE,			RPC_S_SERVER_UNAVAILABLE,
	RPC_NT_SS_CANNOT_GET_CALL_HANDLE,		RPC_X_SS_CANNOT_GET_CALL_HANDLE,
	RPC_NT_SS_CHAR_TRANS_OPEN_FAIL,			RPC_X_SS_CHAR_TRANS_OPEN_FAIL,
	RPC_NT_SS_CHAR_TRANS_SHORT_FILE,		RPC_X_SS_CHAR_TRANS_SHORT_FILE,
	RPC_NT_SS_CONTEXT_DAMAGED,			RPC_X_SS_CONTEXT_DAMAGED,
	RPC_NT_SS_CONTEXT_MISMATCH,			ERROR_INVALID_HANDLE,
	RPC_NT_SS_HANDLES_MISMATCH,			RPC_X_SS_HANDLES_MISMATCH,
	RPC_NT_SS_IN_NULL_CONTEXT,			ERROR_INVALID_HANDLE,
	RPC_NT_STRING_TOO_LONG,				RPC_S_STRING_TOO_LONG,
	RPC_NT_TYPE_ALREADY_REGISTERED,			RPC_S_TYPE_ALREADY_REGISTERED,
	RPC_NT_UNKNOWN_AUTHN_LEVEL,			RPC_S_UNKNOWN_AUTHN_LEVEL,
	RPC_NT_UNKNOWN_AUTHN_SERVICE,			RPC_S_UNKNOWN_AUTHN_SERVICE,
	RPC_NT_UNKNOWN_AUTHN_TYPE,			RPC_S_UNKNOWN_AUTHN_TYPE,
	RPC_NT_UNKNOWN_AUTHZ_SERVICE,			RPC_S_UNKNOWN_AUTHZ_SERVICE,
	RPC_NT_UNKNOWN_IF,				RPC_S_UNKNOWN_IF,
	RPC_NT_UNKNOWN_MGR_TYPE,			RPC_S_UNKNOWN_MGR_TYPE,
	RPC_NT_UNSUPPORTED_AUTHN_LEVEL,			RPC_S_UNSUPPORTED_AUTHN_LEVEL,
	RPC_NT_UNSUPPORTED_NAME_SYNTAX,			RPC_S_UNSUPPORTED_NAME_SYNTAX,
	RPC_NT_UNSUPPORTED_TRANS_SYN,			RPC_S_UNSUPPORTED_TRANS_SYN,
	RPC_NT_UNSUPPORTED_TYPE,			RPC_S_UNSUPPORTED_TYPE,
	RPC_NT_UUID_LOCAL_ONLY,				RPC_S_UUID_LOCAL_ONLY,
	RPC_NT_UUID_NO_ADDRESS,				RPC_S_UUID_NO_ADDRESS,
	RPC_NT_WRONG_ES_VERSION,			RPC_X_WRONG_ES_VERSION,
	RPC_NT_WRONG_KIND_OF_BINDING,			RPC_S_WRONG_KIND_OF_BINDING,
	RPC_NT_WRONG_PIPE_VERSION,			RPC_X_WRONG_PIPE_VERSION,
	RPC_NT_WRONG_STUB_VERSION,			RPC_X_WRONG_STUB_VERSION,
	RPC_NT_ZERO_DIVIDE,				RPC_S_ZERO_DIVIDE,

	/* END CSTYLED */
	0, 0
};
