/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Unified version for both position independent and non position independent
 * for both v8plus and v9
 * compile with:
 *
 * cc -c -xarch=v8plus des_crypt_asm.s     or
 * cc -c -arch=v9 des_crypt_asm.s
 * for kernel use (no -KPIC)
 *
 * and with
 *
 * cc -c -xarch=v8plus -KPIC -DPIC des_crypt_asm.s     or
 * cc -c -arch=v9 -KPIC -DPIC des_crypt_asm.s
 * for  .so  use
 *
 * The tables were generated by a C program, compiled into the C version
 * of this function, from which a .s was generated by the C compiler and
 * that .s was used as a starting point for this one, in particular for
 * the data definitions. It is important, though that the tables and
 * the code both remain in the text section and in this order, otherwise,
 * at least on UltraSparc-II processors, collisions in the E-cache are
 * highly probable between the code and the data it is using which can
 * result in up to 40% performance loss
 *
 * For a description of the DES algithm, see NIST publication FIPS PUB 46-3
 *
 * In this implementation, the 16 rounds of DES are carried out by unrolling
 * a loop that computes two rounds. For those 2 rounds, the two parts of
 * the intermediate variable (L and R in the FIPS pub) are kept in their
 * extended forms (i.e. in the one after applying the transformation E),
 * with the appropriate bits repeated so that bits needed for the S-box
 * lookups are in consecutive positions. So the bits of the L (or R)
 * variable appear in the following order (X represents a bit that is not
 * from L (R), these bits are always 0):
 * 32  1  2  3  4  5  X  X   X  X  X  X  X  X  4  5
 *  6  7  8  9  8  9 10 11  12 13 12 13 14 15 16 17
 * 16 17 18 19 20 21  X  X   X  X  X 20 21 22 23 24
 * 25 24 25 26 27 28 29 28  29 30 31 32  1  X  X  X
 * This arrangement makes it possible that 3 of the 8 S-box indices
 * can be extracted by a single instruction: srlx by 55 for the S1 index,
 * srl by 23 for the S5 index and and by 0x1f80 for the S8 index. The rest
 * of the indices requires two operations, a shift and an and.
 * The tables for the S-boxes are computed in such a way that when or-ed
 * together, they give the result of the S-box, P and E computations.
 * Also, the key schedule bits are computed to follow this bit-scheme.
 * The initial permutation tables are also computed to produce this
 * bit distribution and the final permutation works from these, too.
 *
 * The end of each round is overlapped with the beginning of the next
 * one since after the first 6 S-box lookups all the bits necessary
 * for one S-box lookup in the next round can be computed (by xor-ing
 * the next key schedule item to the partially computed next R).
 */

#if defined(lint) || defined(__lint)
	/* LINTED */
	/* Nothing to be linted in this file, its pure assembly source */
#else	/* lint || __lint */

	.register	%g2,#scratch
	.register	%g3,#scratch

	.file	"encrypt_asm.S"

	.section	".text",#alloc
	.align	32

!
! CONSTANT POOL
!

des_sbox_table:
	.word	5121
	.word	1073872896
	.word	0
	.word	0
	.word	1
	.word	1073741824
	.word	5121
	.word	1073872928
	.word	5121
	.word	1073741856
	.word	1
	.word	1073872928
	.word	0
	.word	32
	.word	1
	.word	1073741824
	.word	0
	.word	131072
	.word	5121
	.word	1073872896
	.word	5121
	.word	1073872928
	.word	0
	.word	131072
	.word	5120
	.word	131104
	.word	5121
	.word	1073741856
	.word	5120
	.word	0
	.word	0
	.word	32
	.word	0
	.word	131104
	.word	5120
	.word	131072
	.word	5120
	.word	131072
	.word	1
	.word	1073872896
	.word	1
	.word	1073872896
	.word	5121
	.word	1073741824
	.word	5121
	.word	1073741824
	.word	5120
	.word	131104
	.word	1
	.word	1073741856
	.word	5120
	.word	32
	.word	5120
	.word	32
	.word	1
	.word	1073741856
	.word	0
	.word	0
	.word	0
	.word	131104
	.word	1
	.word	1073872928
	.word	5120
	.word	0
	.word	1
	.word	1073741824
	.word	5121
	.word	1073872928
	.word	0
	.word	32
	.word	5121
	.word	1073741824
	.word	5121
	.word	1073872896
	.word	5120
	.word	0
	.word	5120
	.word	0
	.word	0
	.word	131072
	.word	5121
	.word	1073741856
	.word	1
	.word	1073741824
	.word	1
	.word	1073872896
	.word	5120
	.word	32
	.word	0
	.word	131072
	.word	0
	.word	32
	.word	5120
	.word	131104
	.word	1
	.word	1073872928
	.word	5121
	.word	1073872928
	.word	1
	.word	1073741856
	.word	5121
	.word	1073741824
	.word	5120
	.word	131104
	.word	5120
	.word	32
	.word	0
	.word	131104
	.word	1
	.word	1073872928
	.word	5121
	.word	1073872896
	.word	0
	.word	131104
	.word	5120
	.word	131072
	.word	5120
	.word	131072
	.word	0
	.word	0
	.word	1
	.word	1073741856
	.word	1
	.word	1073872896
	.word	0
	.word	0
	.word	5121
	.word	1073741856
	.word	536870992
	.word	536872192
	.word	536870912
	.word	536870912
	.word	0
	.word	536870912
	.word	80
	.word	536872192
	.word	80
	.word	0
	.word	0
	.word	1280
	.word	536870992
	.word	1280
	.word	536870912
	.word	536872192
	.word	536870912
	.word	1280
	.word	536870992
	.word	536872192
	.word	536870992
	.word	536870912
	.word	536870912
	.word	0
	.word	536870912
	.word	536870912
	.word	80
	.word	0
	.word	0
	.word	1280
	.word	536870992
	.word	1280
	.word	80
	.word	536870912
	.word	80
	.word	1280
	.word	536870912
	.word	536872192
	.word	0
	.word	0
	.word	536870912
	.word	0
	.word	0
	.word	536870912
	.word	80
	.word	536872192
	.word	536870992
	.word	0
	.word	80
	.word	1280
	.word	536870912
	.word	1280
	.word	0
	.word	0
	.word	80
	.word	536870912
	.word	0
	.word	536872192
	.word	536870992
	.word	536870912
	.word	536870992
	.word	0
	.word	0
	.word	536872192
	.word	0
	.word	0
	.word	80
	.word	536872192
	.word	536870992
	.word	1280
	.word	80
	.word	0
	.word	536870912
	.word	536872192
	.word	536870992
	.word	0
	.word	536870992
	.word	536870912
	.word	0
	.word	536870912
	.word	536870992
	.word	0
	.word	536870912
	.word	536870912
	.word	0
	.word	1280
	.word	536870992
	.word	536872192
	.word	80
	.word	536872192
	.word	0
	.word	1280
	.word	0
	.word	536870912
	.word	536870912
	.word	0
	.word	0
	.word	536872192
	.word	536870992
	.word	536870912
	.word	80
	.word	0
	.word	536870912
	.word	1280
	.word	80
	.word	1280
	.word	536870912
	.word	536872192
	.word	536870912
	.word	1280
	.word	80
	.word	1280
	.word	80
	.word	536870912
	.word	0
	.word	0
	.word	536870912
	.word	536870912
	.word	0
	.word	536872192
	.word	536870912
	.word	0
	.word	536870992
	.word	1280
	.word	536870992
	.word	536872192
	.word	80
	.word	536870912
	.word	0
	.word	81984
	.word	32770
	.word	-2147401728
	.word	0
	.word	0
	.word	32770
	.word	-2147483584
	.word	32768
	.word	81920
	.word	0
	.word	0
	.word	2
	.word	-2147401664
	.word	32768
	.word	81920
	.word	2
	.word	-2147483584
	.word	32768
	.word	64
	.word	32768
	.word	64
	.word	2
	.word	-2147483648
	.word	32770
	.word	-2147401664
	.word	2
	.word	-2147483584
	.word	32770
	.word	-2147483648
	.word	0
	.word	81984
	.word	32768
	.word	0
	.word	0
	.word	64
	.word	32770
	.word	-2147401728
	.word	0
	.word	81920
	.word	2
	.word	-2147401728
	.word	32770
	.word	-2147483648
	.word	32770
	.word	-2147483584
	.word	2
	.word	-2147401664
	.word	32768
	.word	81984
	.word	2
	.word	-2147401728
	.word	2
	.word	-2147483648
	.word	32768
	.word	81984
	.word	0
	.word	64
	.word	32770
	.word	-2147401664
	.word	0
	.word	81920
	.word	32768
	.word	0
	.word	32770
	.word	-2147401728
	.word	32768
	.word	0
	.word	2
	.word	-2147483584
	.word	0
	.word	81984
	.word	2
	.word	-2147483648
	.word	32770
	.word	-2147401728
	.word	32768
	.word	81920
	.word	0
	.word	0
	.word	0
	.word	81920
	.word	2
	.word	-2147483584
	.word	32770
	.word	-2147401664
	.word	32768
	.word	81920
	.word	32768
	.word	64
	.word	0
	.word	81920
	.word	0
	.word	0
	.word	32770
	.word	-2147483584
	.word	32768
	.word	81984
	.word	2
	.word	-2147483648
	.word	32768
	.word	0
	.word	32770
	.word	-2147401664
	.word	0
	.word	64
	.word	2
	.word	-2147401664
	.word	2
	.word	-2147401728
	.word	32768
	.word	64
	.word	32770
	.word	-2147483648
	.word	32768
	.word	81984
	.word	0
	.word	81984
	.word	32770
	.word	-2147483648
	.word	2
	.word	-2147401664
	.word	0
	.word	64
	.word	32770
	.word	-2147483584
	.word	2
	.word	-2147401728
	.word	1073742336
	.word	135266312
	.word	1073741824
	.word	135270408
	.word	1073741824
	.word	135270408
	.word	0
	.word	4096
	.word	512
	.word	135270400
	.word	1073742336
	.word	4104
	.word	1073742336
	.word	8
	.word	1073741824
	.word	135266312
	.word	0
	.word	0
	.word	512
	.word	135266304
	.word	512
	.word	135266304
	.word	1073742336
	.word	135270408
	.word	1073741824
	.word	4104
	.word	0
	.word	0
	.word	512
	.word	4096
	.word	1073742336
	.word	8
	.word	1073741824
	.word	8
	.word	0
	.word	135266304
	.word	512
	.word	0
	.word	1073742336
	.word	135266312
	.word	0
	.word	4096
	.word	512
	.word	0
	.word	1073741824
	.word	135266312
	.word	0
	.word	135270400
	.word	1073742336
	.word	4104
	.word	1073741824
	.word	8
	.word	0
	.word	135270400
	.word	512
	.word	4096
	.word	0
	.word	135266304
	.word	512
	.word	135270400
	.word	1073742336
	.word	135270408
	.word	1073741824
	.word	4104
	.word	512
	.word	4096
	.word	1073742336
	.word	8
	.word	512
	.word	135266304
	.word	1073742336
	.word	135270408
	.word	1073741824
	.word	4104
	.word	0
	.word	0
	.word	0
	.word	0
	.word	512
	.word	135266304
	.word	0
	.word	135270400
	.word	512
	.word	4096
	.word	1073742336
	.word	4104
	.word	1073741824
	.word	8
	.word	1073742336
	.word	135266312
	.word	1073741824
	.word	135270408
	.word	1073741824
	.word	135270408
	.word	0
	.word	4096
	.word	1073742336
	.word	135270408
	.word	1073741824
	.word	4104
	.word	1073741824
	.word	8
	.word	0
	.word	135266304
	.word	1073742336
	.word	8
	.word	1073741824
	.word	135266312
	.word	512
	.word	135270400
	.word	1073742336
	.word	4104
	.word	1073741824
	.word	135266312
	.word	0
	.word	135270400
	.word	512
	.word	0
	.word	1073742336
	.word	135266312
	.word	0
	.word	4096
	.word	512
	.word	0
	.word	0
	.word	135266304
	.word	512
	.word	135270400
	.word	0
	.word	40960
	.word	10248
	.word	40960
	.word	10248
	.word	0
	.word	268445696
	.word	40960
	.word	8
	.word	0
	.word	0
	.word	40960
	.word	268435456
	.word	0
	.word	10248
	.word	0
	.word	268435464
	.word	40960
	.word	8
	.word	0
	.word	10240
	.word	40960
	.word	268435464
	.word	40960
	.word	268445696
	.word	40960
	.word	268445704
	.word	0
	.word	8
	.word	40960
	.word	268435456
	.word	0
	.word	10240
	.word	0
	.word	268435464
	.word	0
	.word	268435464
	.word	0
	.word	0
	.word	0
	.word	268435456
	.word	40960
	.word	268445704
	.word	40960
	.word	268445704
	.word	40960
	.word	10240
	.word	40960
	.word	268445704
	.word	0
	.word	268435456
	.word	40960
	.word	0
	.word	0
	.word	268445696
	.word	0
	.word	10248
	.word	40960
	.word	10240
	.word	0
	.word	268445696
	.word	0
	.word	8
	.word	40960
	.word	8
	.word	0
	.word	268445696
	.word	40960
	.word	0
	.word	40960
	.word	10240
	.word	0
	.word	268435456
	.word	0
	.word	10248
	.word	0
	.word	268445696
	.word	40960
	.word	268435464
	.word	40960
	.word	10240
	.word	40960
	.word	268435456
	.word	0
	.word	268445704
	.word	0
	.word	10248
	.word	40960
	.word	268435464
	.word	40960
	.word	0
	.word	40960
	.word	10240
	.word	0
	.word	268445704
	.word	0
	.word	268445704
	.word	40960
	.word	8
	.word	40960
	.word	268445696
	.word	0
	.word	268445704
	.word	40960
	.word	10248
	.word	0
	.word	0
	.word	0
	.word	268435464
	.word	0
	.word	268445696
	.word	0
	.word	8
	.word	40960
	.word	10240
	.word	40960
	.word	268435456
	.word	40960
	.word	8
	.word	0
	.word	0
	.word	0
	.word	268435464
	.word	0
	.word	10248
	.word	40960
	.word	268435456
	.word	40960
	.word	134348800
	.word	640
	.word	134349056
	.word	0
	.word	0
	.word	268435456
	.word	134349056
	.word	268436096
	.word	134349056
	.word	0
	.word	0
	.word	640
	.word	134349056
	.word	268436096
	.word	256
	.word	0
	.word	134348800
	.word	268435456
	.word	256
	.word	268436096
	.word	256
	.word	0
	.word	134348800
	.word	640
	.word	256
	.word	640
	.word	134348800
	.word	268435456
	.word	134348800
	.word	0
	.word	0
	.word	268436096
	.word	0
	.word	0
	.word	256
	.word	640
	.word	134348800
	.word	268436096
	.word	0
	.word	268435456
	.word	256
	.word	268435456
	.word	134348800
	.word	268436096
	.word	0
	.word	640
	.word	134349056
	.word	640
	.word	134349056
	.word	640
	.word	0
	.word	0
	.word	256
	.word	268436096
	.word	134349056
	.word	268435456
	.word	0
	.word	268436096
	.word	256
	.word	268435456
	.word	134349056
	.word	268435456
	.word	134348800
	.word	0
	.word	134348800
	.word	268435456
	.word	0
	.word	640
	.word	134349056
	.word	640
	.word	256
	.word	268435456
	.word	134349056
	.word	268436096
	.word	256
	.word	0
	.word	0
	.word	268436096
	.word	134348800
	.word	640
	.word	256
	.word	0
	.word	134348800
	.word	268435456
	.word	134348800
	.word	0
	.word	0
	.word	268436096
	.word	134348800
	.word	640
	.word	134349056
	.word	268436096
	.word	256
	.word	268435456
	.word	134349056
	.word	0
	.word	256
	.word	268436096
	.word	134349056
	.word	268435456
	.word	0
	.word	0
	.word	134349056
	.word	640
	.word	0
	.word	640
	.word	0
	.word	268435456
	.word	134349056
	.word	0
	.word	256
	.word	268436096
	.word	0
	.word	268435456
	.word	256
	.word	640
	.word	134348800
	.word	268436096
	.word	0
	.word	0
	.word	134349056
	.word	268435456
	.word	134348800
	.word	0
	.word	256
	.word	640
	.word	134348800
	.word	268436096
	.word	160
	.word	0
	.word	-2147467104
	.word	16
	.word	-2147467264
	.word	262160
	.word	0
	.word	0
	.word	0
	.word	262144
	.word	-2147467264
	.word	262160
	.word	-2147483488
	.word	262160
	.word	16544
	.word	262144
	.word	-2147467104
	.word	262160
	.word	160
	.word	0
	.word	0
	.word	0
	.word	-2147467264
	.word	16
	.word	-2147483648
	.word	16
	.word	16384
	.word	0
	.word	-2147467104
	.word	16
	.word	-2147483648
	.word	262160
	.word	16384
	.word	262144
	.word	-2147483488
	.word	262160
	.word	-2147483488
	.word	16
	.word	16384
	.word	262144
	.word	-2147467264
	.word	16
	.word	16544
	.word	0
	.word	16544
	.word	262144
	.word	-2147483488
	.word	16
	.word	16544
	.word	0
	.word	0
	.word	262144
	.word	-2147483648
	.word	262160
	.word	-2147467104
	.word	262160
	.word	160
	.word	262144
	.word	-2147483648
	.word	16
	.word	16384
	.word	0
	.word	160
	.word	262144
	.word	16384
	.word	0
	.word	160
	.word	262144
	.word	160
	.word	0
	.word	-2147467264
	.word	262160
	.word	-2147467264
	.word	262160
	.word	-2147467104
	.word	16
	.word	-2147467104
	.word	16
	.word	-2147483648
	.word	16
	.word	-2147483488
	.word	16
	.word	16384
	.word	0
	.word	16384
	.word	262144
	.word	160
	.word	0
	.word	16544
	.word	262144
	.word	-2147483648
	.word	262160
	.word	-2147483488
	.word	262160
	.word	16544
	.word	262144
	.word	-2147483648
	.word	262160
	.word	-2147467264
	.word	16
	.word	-2147467104
	.word	262160
	.word	16544
	.word	0
	.word	160
	.word	262144
	.word	0
	.word	0
	.word	-2147483648
	.word	16
	.word	-2147467104
	.word	262160
	.word	0
	.word	0
	.word	-2147483488
	.word	262160
	.word	16544
	.word	0
	.word	0
	.word	262144
	.word	-2147467264
	.word	16
	.word	16384
	.word	262144
	.word	0
	.word	262144
	.word	-2147483488
	.word	16
	.word	67174400
	.word	67635200
	.word	0
	.word	67633152
	.word	4
	.word	0
	.word	67174404
	.word	67635200
	.word	67174400
	.word	0
	.word	67174400
	.word	67635200
	.word	0
	.word	2048
	.word	67174400
	.word	0
	.word	4
	.word	2048
	.word	67174404
	.word	0
	.word	67174404
	.word	67635200
	.word	4
	.word	67633152
	.word	67174404
	.word	67633152
	.word	4
	.word	67635200
	.word	0
	.word	67633152
	.word	0
	.word	2048
	.word	67174404
	.word	0
	.word	67174400
	.word	2048
	.word	67174400
	.word	67633152
	.word	0
	.word	67635200
	.word	4
	.word	67633152
	.word	4
	.word	2048
	.word	67174404
	.word	2048
	.word	67174404
	.word	67633152
	.word	0
	.word	67635200
	.word	0
	.word	0
	.word	0
	.word	0
	.word	67174404
	.word	2048
	.word	67174400
	.word	2048
	.word	67174400
	.word	67633152
	.word	4
	.word	67635200
	.word	4
	.word	0
	.word	4
	.word	67635200
	.word	4
	.word	0
	.word	67174404
	.word	67633152
	.word	0
	.word	67633152
	.word	0
	.word	2048
	.word	67174404
	.word	2048
	.word	0
	.word	67633152
	.word	4
	.word	67635200
	.word	67174400
	.word	67633152
	.word	0
	.word	2048
	.word	67174400
	.word	2048
	.word	67174404
	.word	0
	.word	67174404
	.word	2048
	.word	67174400
	.word	0
	.word	4
	.word	0
	.word	67174400
	.word	67635200
	.word	0
	.word	0
	.word	67174404
	.word	67635200
	.word	4
	.word	2048
	.word	67174400
	.word	2048
	.word	67174404
	.word	0
	.word	67174400
	.word	67633152
	.word	67174400
	.word	67635200
	.word	0
	.word	0
	.word	67174404
	.word	67635200
	.word	4
	.word	67633152
	.word	4
	.word	67633152
	.word	0
	.word	67635200
	.word	0
	.word	67635200
	.word	4
	.word	2048
	.word	67174400
	.word	0
	.word	67174404
	.word	67633152
	.type	des_sbox_table,#object
	.size	des_sbox_table,4096

	.align 32
!
! CONSTANT POOL
!
	.section	".text",#alloc,#execinstr

des_ip_table:
	.word	0
	.word	0
	.word	0
	.word	1024
	.word	8388608
	.word	640
	.word	8388608
	.word	1664
	.word	0
	.word	4194304
	.word	0
	.word	4195328
	.word	8388608
	.word	4194944
	.word	8388608
	.word	4195968
	.word	0
	.word	2621440
	.word	0
	.word	2622464
	.word	8388608
	.word	2622080
	.word	8388608
	.word	2623104
	.word	0
	.word	6815744
	.word	0
	.word	6816768
	.word	8388608
	.word	6816384
	.word	8388608
	.word	6817408
	.word	4
	.word	0
	.word	4
	.word	1024
	.word	8388612
	.word	640
	.word	8388612
	.word	1664
	.word	4
	.word	4194304
	.word	4
	.word	4195328
	.word	8388612
	.word	4194944
	.word	8388612
	.word	4195968
	.word	4
	.word	2621440
	.word	4
	.word	2622464
	.word	8388612
	.word	2622080
	.word	8388612
	.word	2623104
	.word	4
	.word	6815744
	.word	4
	.word	6816768
	.word	8388612
	.word	6816384
	.word	8388612
	.word	6817408
	.word	2
	.word	-2147483648
	.word	2
	.word	-2147482624
	.word	8388610
	.word	-2147483008
	.word	8388610
	.word	-2147481984
	.word	2
	.word	-2143289344
	.word	2
	.word	-2143288320
	.word	8388610
	.word	-2143288704
	.word	8388610
	.word	-2143287680
	.word	2
	.word	-2144862208
	.word	2
	.word	-2144861184
	.word	8388610
	.word	-2144861568
	.word	8388610
	.word	-2144860544
	.word	2
	.word	-2140667904
	.word	2
	.word	-2140666880
	.word	8388610
	.word	-2140667264
	.word	8388610
	.word	-2140666240
	.word	6
	.word	-2147483648
	.word	6
	.word	-2147482624
	.word	8388614
	.word	-2147483008
	.word	8388614
	.word	-2147481984
	.word	6
	.word	-2143289344
	.word	6
	.word	-2143288320
	.word	8388614
	.word	-2143288704
	.word	8388614
	.word	-2143287680
	.word	6
	.word	-2144862208
	.word	6
	.word	-2144861184
	.word	8388614
	.word	-2144861568
	.word	8388614
	.word	-2144860544
	.word	6
	.word	-2140667904
	.word	6
	.word	-2140666880
	.word	8388614
	.word	-2140667264
	.word	8388614
	.word	-2140666240
	.word	16384
	.word	0
	.word	16384
	.word	1024
	.word	8404992
	.word	640
	.word	8404992
	.word	1664
	.word	16384
	.word	4194304
	.word	16384
	.word	4195328
	.word	8404992
	.word	4194944
	.word	8404992
	.word	4195968
	.word	16384
	.word	2621440
	.word	16384
	.word	2622464
	.word	8404992
	.word	2622080
	.word	8404992
	.word	2623104
	.word	16384
	.word	6815744
	.word	16384
	.word	6816768
	.word	8404992
	.word	6816384
	.word	8404992
	.word	6817408
	.word	16388
	.word	0
	.word	16388
	.word	1024
	.word	8404996
	.word	640
	.word	8404996
	.word	1664
	.word	16388
	.word	4194304
	.word	16388
	.word	4195328
	.word	8404996
	.word	4194944
	.word	8404996
	.word	4195968
	.word	16388
	.word	2621440
	.word	16388
	.word	2622464
	.word	8404996
	.word	2622080
	.word	8404996
	.word	2623104
	.word	16388
	.word	6815744
	.word	16388
	.word	6816768
	.word	8404996
	.word	6816384
	.word	8404996
	.word	6817408
	.word	16386
	.word	-2147483648
	.word	16386
	.word	-2147482624
	.word	8404994
	.word	-2147483008
	.word	8404994
	.word	-2147481984
	.word	16386
	.word	-2143289344
	.word	16386
	.word	-2143288320
	.word	8404994
	.word	-2143288704
	.word	8404994
	.word	-2143287680
	.word	16386
	.word	-2144862208
	.word	16386
	.word	-2144861184
	.word	8404994
	.word	-2144861568
	.word	8404994
	.word	-2144860544
	.word	16386
	.word	-2140667904
	.word	16386
	.word	-2140666880
	.word	8404994
	.word	-2140667264
	.word	8404994
	.word	-2140666240
	.word	16390
	.word	-2147483648
	.word	16390
	.word	-2147482624
	.word	8404998
	.word	-2147483008
	.word	8404998
	.word	-2147481984
	.word	16390
	.word	-2143289344
	.word	16390
	.word	-2143288320
	.word	8404998
	.word	-2143288704
	.word	8404998
	.word	-2143287680
	.word	16390
	.word	-2144862208
	.word	16390
	.word	-2144861184
	.word	8404998
	.word	-2144861568
	.word	8404998
	.word	-2144860544
	.word	16390
	.word	-2140667904
	.word	16390
	.word	-2140666880
	.word	8404998
	.word	-2140667264
	.word	8404998
	.word	-2140666240
	.word	10240
	.word	0
	.word	10240
	.word	1024
	.word	8398848
	.word	640
	.word	8398848
	.word	1664
	.word	10240
	.word	4194304
	.word	10240
	.word	4195328
	.word	8398848
	.word	4194944
	.word	8398848
	.word	4195968
	.word	10240
	.word	2621440
	.word	10240
	.word	2622464
	.word	8398848
	.word	2622080
	.word	8398848
	.word	2623104
	.word	10240
	.word	6815744
	.word	10240
	.word	6816768
	.word	8398848
	.word	6816384
	.word	8398848
	.word	6817408
	.word	10244
	.word	0
	.word	10244
	.word	1024
	.word	8398852
	.word	640
	.word	8398852
	.word	1664
	.word	10244
	.word	4194304
	.word	10244
	.word	4195328
	.word	8398852
	.word	4194944
	.word	8398852
	.word	4195968
	.word	10244
	.word	2621440
	.word	10244
	.word	2622464
	.word	8398852
	.word	2622080
	.word	8398852
	.word	2623104
	.word	10244
	.word	6815744
	.word	10244
	.word	6816768
	.word	8398852
	.word	6816384
	.word	8398852
	.word	6817408
	.word	10242
	.word	-2147483648
	.word	10242
	.word	-2147482624
	.word	8398850
	.word	-2147483008
	.word	8398850
	.word	-2147481984
	.word	10242
	.word	-2143289344
	.word	10242
	.word	-2143288320
	.word	8398850
	.word	-2143288704
	.word	8398850
	.word	-2143287680
	.word	10242
	.word	-2144862208
	.word	10242
	.word	-2144861184
	.word	8398850
	.word	-2144861568
	.word	8398850
	.word	-2144860544
	.word	10242
	.word	-2140667904
	.word	10242
	.word	-2140666880
	.word	8398850
	.word	-2140667264
	.word	8398850
	.word	-2140666240
	.word	10246
	.word	-2147483648
	.word	10246
	.word	-2147482624
	.word	8398854
	.word	-2147483008
	.word	8398854
	.word	-2147481984
	.word	10246
	.word	-2143289344
	.word	10246
	.word	-2143288320
	.word	8398854
	.word	-2143288704
	.word	8398854
	.word	-2143287680
	.word	10246
	.word	-2144862208
	.word	10246
	.word	-2144861184
	.word	8398854
	.word	-2144861568
	.word	8398854
	.word	-2144860544
	.word	10246
	.word	-2140667904
	.word	10246
	.word	-2140666880
	.word	8398854
	.word	-2140667264
	.word	8398854
	.word	-2140666240
	.word	26624
	.word	0
	.word	26624
	.word	1024
	.word	8415232
	.word	640
	.word	8415232
	.word	1664
	.word	26624
	.word	4194304
	.word	26624
	.word	4195328
	.word	8415232
	.word	4194944
	.word	8415232
	.word	4195968
	.word	26624
	.word	2621440
	.word	26624
	.word	2622464
	.word	8415232
	.word	2622080
	.word	8415232
	.word	2623104
	.word	26624
	.word	6815744
	.word	26624
	.word	6816768
	.word	8415232
	.word	6816384
	.word	8415232
	.word	6817408
	.word	26628
	.word	0
	.word	26628
	.word	1024
	.word	8415236
	.word	640
	.word	8415236
	.word	1664
	.word	26628
	.word	4194304
	.word	26628
	.word	4195328
	.word	8415236
	.word	4194944
	.word	8415236
	.word	4195968
	.word	26628
	.word	2621440
	.word	26628
	.word	2622464
	.word	8415236
	.word	2622080
	.word	8415236
	.word	2623104
	.word	26628
	.word	6815744
	.word	26628
	.word	6816768
	.word	8415236
	.word	6816384
	.word	8415236
	.word	6817408
	.word	26626
	.word	-2147483648
	.word	26626
	.word	-2147482624
	.word	8415234
	.word	-2147483008
	.word	8415234
	.word	-2147481984
	.word	26626
	.word	-2143289344
	.word	26626
	.word	-2143288320
	.word	8415234
	.word	-2143288704
	.word	8415234
	.word	-2143287680
	.word	26626
	.word	-2144862208
	.word	26626
	.word	-2144861184
	.word	8415234
	.word	-2144861568
	.word	8415234
	.word	-2144860544
	.word	26626
	.word	-2140667904
	.word	26626
	.word	-2140666880
	.word	8415234
	.word	-2140667264
	.word	8415234
	.word	-2140666240
	.word	26630
	.word	-2147483648
	.word	26630
	.word	-2147482624
	.word	8415238
	.word	-2147483008
	.word	8415238
	.word	-2147481984
	.word	26630
	.word	-2143289344
	.word	26630
	.word	-2143288320
	.word	8415238
	.word	-2143288704
	.word	8415238
	.word	-2143287680
	.word	26630
	.word	-2144862208
	.word	26630
	.word	-2144861184
	.word	8415238
	.word	-2144861568
	.word	8415238
	.word	-2144860544
	.word	26630
	.word	-2140667904
	.word	26630
	.word	-2140666880
	.word	8415238
	.word	-2140667264
	.word	8415238
	.word	-2140666240
	.word	0
	.word	0
	.word	0
	.word	20480
	.word	0
	.word	2048
	.word	0
	.word	22528
	.word	0
	.word	83886080
	.word	0
	.word	83906560
	.word	0
	.word	83888128
	.word	0
	.word	83908608
	.word	0
	.word	8388608
	.word	0
	.word	8409088
	.word	0
	.word	8390656
	.word	0
	.word	8411136
	.word	0
	.word	92274688
	.word	0
	.word	92295168
	.word	0
	.word	92276736
	.word	0
	.word	92297216
	.word	80
	.word	0
	.word	80
	.word	20480
	.word	80
	.word	2048
	.word	80
	.word	22528
	.word	80
	.word	83886080
	.word	80
	.word	83906560
	.word	80
	.word	83888128
	.word	80
	.word	83908608
	.word	80
	.word	8388608
	.word	80
	.word	8409088
	.word	80
	.word	8390656
	.word	80
	.word	8411136
	.word	80
	.word	92274688
	.word	80
	.word	92295168
	.word	80
	.word	92276736
	.word	80
	.word	92297216
	.word	8
	.word	0
	.word	8
	.word	20480
	.word	8
	.word	2048
	.word	8
	.word	22528
	.word	8
	.word	83886080
	.word	8
	.word	83906560
	.word	8
	.word	83888128
	.word	8
	.word	83908608
	.word	8
	.word	8388608
	.word	8
	.word	8409088
	.word	8
	.word	8390656
	.word	8
	.word	8411136
	.word	8
	.word	92274688
	.word	8
	.word	92295168
	.word	8
	.word	92276736
	.word	8
	.word	92297216
	.word	88
	.word	0
	.word	88
	.word	20480
	.word	88
	.word	2048
	.word	88
	.word	22528
	.word	88
	.word	83886080
	.word	88
	.word	83906560
	.word	88
	.word	83888128
	.word	88
	.word	83908608
	.word	88
	.word	8388608
	.word	88
	.word	8409088
	.word	88
	.word	8390656
	.word	88
	.word	8411136
	.word	88
	.word	92274688
	.word	88
	.word	92295168
	.word	88
	.word	92276736
	.word	88
	.word	92297216
	.word	327680
	.word	4
	.word	327680
	.word	20484
	.word	327680
	.word	2052
	.word	327680
	.word	22532
	.word	327680
	.word	83886084
	.word	327680
	.word	83906564
	.word	327680
	.word	83888132
	.word	327680
	.word	83908612
	.word	327680
	.word	8388612
	.word	327680
	.word	8409092
	.word	327680
	.word	8390660
	.word	327680
	.word	8411140
	.word	327680
	.word	92274692
	.word	327680
	.word	92295172
	.word	327680
	.word	92276740
	.word	327680
	.word	92297220
	.word	327760
	.word	4
	.word	327760
	.word	20484
	.word	327760
	.word	2052
	.word	327760
	.word	22532
	.word	327760
	.word	83886084
	.word	327760
	.word	83906564
	.word	327760
	.word	83888132
	.word	327760
	.word	83908612
	.word	327760
	.word	8388612
	.word	327760
	.word	8409092
	.word	327760
	.word	8390660
	.word	327760
	.word	8411140
	.word	327760
	.word	92274692
	.word	327760
	.word	92295172
	.word	327760
	.word	92276740
	.word	327760
	.word	92297220
	.word	327688
	.word	4
	.word	327688
	.word	20484
	.word	327688
	.word	2052
	.word	327688
	.word	22532
	.word	327688
	.word	83886084
	.word	327688
	.word	83906564
	.word	327688
	.word	83888132
	.word	327688
	.word	83908612
	.word	327688
	.word	8388612
	.word	327688
	.word	8409092
	.word	327688
	.word	8390660
	.word	327688
	.word	8411140
	.word	327688
	.word	92274692
	.word	327688
	.word	92295172
	.word	327688
	.word	92276740
	.word	327688
	.word	92297220
	.word	327768
	.word	4
	.word	327768
	.word	20484
	.word	327768
	.word	2052
	.word	327768
	.word	22532
	.word	327768
	.word	83886084
	.word	327768
	.word	83906564
	.word	327768
	.word	83888132
	.word	327768
	.word	83908612
	.word	327768
	.word	8388612
	.word	327768
	.word	8409092
	.word	327768
	.word	8390660
	.word	327768
	.word	8411140
	.word	327768
	.word	92274692
	.word	327768
	.word	92295172
	.word	327768
	.word	92276740
	.word	327768
	.word	92297220
	.word	32768
	.word	0
	.word	32768
	.word	20480
	.word	32768
	.word	2048
	.word	32768
	.word	22528
	.word	32768
	.word	83886080
	.word	32768
	.word	83906560
	.word	32768
	.word	83888128
	.word	32768
	.word	83908608
	.word	32768
	.word	8388608
	.word	32768
	.word	8409088
	.word	32768
	.word	8390656
	.word	32768
	.word	8411136
	.word	32768
	.word	92274688
	.word	32768
	.word	92295168
	.word	32768
	.word	92276736
	.word	32768
	.word	92297216
	.word	32848
	.word	0
	.word	32848
	.word	20480
	.word	32848
	.word	2048
	.word	32848
	.word	22528
	.word	32848
	.word	83886080
	.word	32848
	.word	83906560
	.word	32848
	.word	83888128
	.word	32848
	.word	83908608
	.word	32848
	.word	8388608
	.word	32848
	.word	8409088
	.word	32848
	.word	8390656
	.word	32848
	.word	8411136
	.word	32848
	.word	92274688
	.word	32848
	.word	92295168
	.word	32848
	.word	92276736
	.word	32848
	.word	92297216
	.word	32776
	.word	0
	.word	32776
	.word	20480
	.word	32776
	.word	2048
	.word	32776
	.word	22528
	.word	32776
	.word	83886080
	.word	32776
	.word	83906560
	.word	32776
	.word	83888128
	.word	32776
	.word	83908608
	.word	32776
	.word	8388608
	.word	32776
	.word	8409088
	.word	32776
	.word	8390656
	.word	32776
	.word	8411136
	.word	32776
	.word	92274688
	.word	32776
	.word	92295168
	.word	32776
	.word	92276736
	.word	32776
	.word	92297216
	.word	32856
	.word	0
	.word	32856
	.word	20480
	.word	32856
	.word	2048
	.word	32856
	.word	22528
	.word	32856
	.word	83886080
	.word	32856
	.word	83906560
	.word	32856
	.word	83888128
	.word	32856
	.word	83908608
	.word	32856
	.word	8388608
	.word	32856
	.word	8409088
	.word	32856
	.word	8390656
	.word	32856
	.word	8411136
	.word	32856
	.word	92274688
	.word	32856
	.word	92295168
	.word	32856
	.word	92276736
	.word	32856
	.word	92297216
	.word	360448
	.word	4
	.word	360448
	.word	20484
	.word	360448
	.word	2052
	.word	360448
	.word	22532
	.word	360448
	.word	83886084
	.word	360448
	.word	83906564
	.word	360448
	.word	83888132
	.word	360448
	.word	83908612
	.word	360448
	.word	8388612
	.word	360448
	.word	8409092
	.word	360448
	.word	8390660
	.word	360448
	.word	8411140
	.word	360448
	.word	92274692
	.word	360448
	.word	92295172
	.word	360448
	.word	92276740
	.word	360448
	.word	92297220
	.word	360528
	.word	4
	.word	360528
	.word	20484
	.word	360528
	.word	2052
	.word	360528
	.word	22532
	.word	360528
	.word	83886084
	.word	360528
	.word	83906564
	.word	360528
	.word	83888132
	.word	360528
	.word	83908612
	.word	360528
	.word	8388612
	.word	360528
	.word	8409092
	.word	360528
	.word	8390660
	.word	360528
	.word	8411140
	.word	360528
	.word	92274692
	.word	360528
	.word	92295172
	.word	360528
	.word	92276740
	.word	360528
	.word	92297220
	.word	360456
	.word	4
	.word	360456
	.word	20484
	.word	360456
	.word	2052
	.word	360456
	.word	22532
	.word	360456
	.word	83886084
	.word	360456
	.word	83906564
	.word	360456
	.word	83888132
	.word	360456
	.word	83908612
	.word	360456
	.word	8388612
	.word	360456
	.word	8409092
	.word	360456
	.word	8390660
	.word	360456
	.word	8411140
	.word	360456
	.word	92274692
	.word	360456
	.word	92295172
	.word	360456
	.word	92276740
	.word	360456
	.word	92297220
	.word	360536
	.word	4
	.word	360536
	.word	20484
	.word	360536
	.word	2052
	.word	360536
	.word	22532
	.word	360536
	.word	83886084
	.word	360536
	.word	83906564
	.word	360536
	.word	83888132
	.word	360536
	.word	83908612
	.word	360536
	.word	8388612
	.word	360536
	.word	8409092
	.word	360536
	.word	8390660
	.word	360536
	.word	8411140
	.word	360536
	.word	92274692
	.word	360536
	.word	92295172
	.word	360536
	.word	92276740
	.word	360536
	.word	92297220
	.type	des_ip_table,#object
	.size	des_ip_table,4096


	.section	".data",#alloc
		.align	32


des_enc_const:

#ifdef __sparcv9

!
! For v9, the addresses ar 64-bit long, so we should use .xword
! instead of .word, this makes the constant table bigger
!
	.xword	(des_ip_table+0x0)	! initial permutation table
	.xword	(des_ip_table+0x800)

	.xword	(des_fp_table+0x0)	! final permutation table

	.xword	(des_sbox_table+0x0)    ! sboxes table
	.xword	(des_sbox_table+0x200)
	.xword	(des_sbox_table+0x400)
	.xword	(des_sbox_table+0x600)
	.xword	(des_sbox_table+0x800)
	.xword	(des_sbox_table+0xa00)
	.xword	(des_sbox_table+0xc00)
	.xword	(des_sbox_table+0xe00)

	.word   0			! for alignment
	.word	7			! counter for encrypt loop

	.word	16515072		! top_1
	.word	0			!

	.word	262143			! mid_4
	.word	-67108864		!

	.word	0			! low_3
	.word	67108608		!

	.word	-1431655766		! 0xaaaaaaaaaaaaaaaa
	.word	-1431655766		!

	.word	1431655765		! 0x5555555555555555
	.word	1431655765		!
#else

!
! For v8, the addresses are 32-bit long
!

	.word	(des_ip_table+0x0)	! initial permutation table
	.word	(des_ip_table+0x800)

	.word	(des_fp_table+0x0)	! final permutation table

	.word	(des_sbox_table+0x0)    ! sboxes table
	.word	(des_sbox_table+0x200)
	.word	(des_sbox_table+0x400)
	.word	(des_sbox_table+0x600)
	.word	(des_sbox_table+0x800)
	.word	(des_sbox_table+0xa00)
	.word	(des_sbox_table+0xc00)
	.word	(des_sbox_table+0xe00)

	.word	7			! counter for encrypt loop

	.word	16515072		! top_1
	.word	0			!

	.word	262143			! mid_4
	.word	-67108864		!

	.word	0			! low_3
	.word	67108608		!

	.word	-1431655766		! 0xaaaaaaaaaaaaaaaa
	.word	-1431655766		!

	.word	1431655765		! 0x5555555555555555
	.word	1431655765		!
#endif
	.type	des_enc_const,#object
	.size	des_enc_const,(.-des_enc_const)


	.section	".text",#alloc,#execinstr
/* 000000	   0 */		.align	32
/* 000000	     */		.skip	32
!
! SUBROUTINE des_crypt_impl
!
! OFFSET    SOURCE LINE	LABEL	INSTRUCTION

.global des_crypt_impl

! uint64_t des_crypt_impl(uint64_t *ks, uint64_t block, int one_or_three);
!
! ks is the key schedule, en/decryption is differentiated by computing
!    an encryption key schedule for encryption and the reverse of it
!    for decryption (for DES, 16 entries, for triple-DES, 48 entries)
! block is the 64-bit block to en/decrypt
! one_or_three is 1 for DES and 3 for triple-DES

	des_crypt_impl:

#ifdef __sparcv9
	save	%sp,-192,%sp
#ifdef PIC
.L0:
	call	. + 8
	sethi	%hi(_GLOBAL_OFFSET_TABLE_ - (.L0 - .)), %o1
	sethi	%hi(des_enc_const), %g1

	or	%o1, %lo(_GLOBAL_OFFSET_TABLE_ - (.L0 - .)), %o1
	or	%g1, %lo(des_enc_const),%g1

	add	%o1, %o7, %o1
#else
	sethi	%hh(des_enc_const),%o1
	sethi	%lm(des_enc_const),%g1

	or	%o1,%hm(des_enc_const),%o1
	or	%g1,%lo(des_enc_const),%g1

	sllx	%o1,32,%o1
#endif
	sethi	%hi(0xaaaaaaaa), %g3

#ifdef PIC
	ldx	[%o1 + %g1], %i5
#else
	or	%o1,%g1,%i5		! &des_enc_const
#endif
	or	%g3, %lo(0xaaaaaaaa), %g3

	sllx	%g3, 32, %o0

	or	%g3, %o0, %g3		! 0xaaaaaaaaaaaaaaaa

	srlx	%g3, 1, %g2		! 0x5555555555555555
	and	%i1, %g3, %g1

	sllx	%g1, 7, %g3
	ldx	[%i5 + 0], %l7		! &(des_ip_table[0][0])
	and	%i1, %g2, %g2

	srlx	%g2, 7, %g4
	ldx	[%i5 + 8], %l6		! &(des_ip_table[1][0])
	or	%g1, %g3, %g1

	srlx	%g1, 21, %o0
	ld	[%i5 + 92], %i4		! 7 (for iteration counter)
	or	%g2, %g4, %g2

	srlx	%g1, 5, %o1
	ldx	[%i5 + 24], %l0		! &(des_sbox_table[0][0])
	and	%o0, 0x7f8, %o0

	srlx	%g2, 13, %o2
	ldx	[%l7 + %o0], %o0
	and	%o1, 0x7f8, %o1

	sllx	%g2, 3, %o3
	ldx	[%l6 + %o1], %o1
	and	%o2, 0x7f8, %o2

	srlx	%g1, 53, %o4
	ldx	[%l7 + %o2], %o2
	and	%o3, 0x7f8, %o3

	srlx	%g1, 37, %o5
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x7f8, %o4

	srlx	%g2, 45, %g1
	ldx	[%l7 + %o4], %o4
	and	%o5, 0x7f8, %o5

	srlx	%g2, 29, %g2
	ldx	[%l6 + %o5], %o5
	and	%g1, 0x7f8, %g1

	sllx	%o0, 6, %o0
	ldx	[%l7 + %g1], %g1
	and	%g2, 0x7f8, %g2

	sllx	%o1, 6, %o1
	ldx	[%l6 + %g2], %g2
	or	%o4, %o5, %o4

	sllx	%o2, 6, %o2
	ldx	[%i5 + 32], %l1		! &(des_sbox_table[1][0])
	or	%o0, %o1, %o0

	sllx	%o3, 6, %o3
	ldx	[%i5 + 96], %g3		! top_1
	or	%o0, %o4, %o0

	or	%g1, %g2, %g1
	ldx	[%i5 + 104], %g4	! mid_4
	or	%o2, %o3, %o2

	and	%o0, %g3, %o4
	ldx	[%i5 + 112], %g2	! low_3
	or	%o2, %g1, %o1

	sllx	%o4, 8, %o4
	ldx	[%i5 + 40], %l2		! &(des_sbox_table[2][0])
	and	%o1, %g3, %o5

	sllx	%o5, 8, %o5
	ldx	[%i5 + 48], %l3		! &(des_sbox_table[3][0])
	and	%o0, %g2, %o2

	srlx	%o2, 5, %o2
	ldx	[%i5 + 56], %l4		! &(des_sbox_table[4][0])
	and	%o1, %g2, %o3

	srlx	%o3, 5, %o3
	ldx	[%i0], %g2		! ks[0]
	and	%o0, %g4, %o0

	or	%o0, %o2, %o0
	ldx	[%i5 + 64], %l5		! &(des_sbox_table[5][0])
	and	%o1, %g4, %o1

	or	%o0, %o4, %o0
	ldx	[%i5 + 72], %l6		! &(des_sbox_table[6][0])
	or	%o1, %o3, %o1

	xor	%o0, %g2, %g1
	ldx	[%i5 + 80], %l7		! &(des_sbox_table[7][0])
	or	%o1, %o5, %o1
#else

! v8 version

	save	%sp,-144,%sp
	sethi	%hi(des_enc_const), %g2

#ifdef PIC
.L1:
	call	.+8

	sethi	%hi(_GLOBAL_OFFSET_TABLE_ - (.L1 - .)), %g1

	or	%g1, %lo(_GLOBAL_OFFSET_TABLE_ - (.L1 - .)), %g1
	or	%g2, %lo(des_enc_const), %g2
#else
	or	%g2, %lo(des_enc_const), %i5
#endif
	srl	%i2, 0, %g4
	sethi	%hi(0xaaaaaaaa), %g3

	sllx	%i1, 32, %g5
	or	%g3, %lo(0xaaaaaaaa), %g3

	sllx	%g3, 32, %o0
	add	%o7, %g1, %g1

	or	%g3, %o0, %g3		! 0xaaaaaaaaaaaaaaaa
#ifdef PIC
	ld	[%g1 + %g2], %i5
#endif
	or	%g4, %g5, %g4

	srlx	%g3, 1, %g2		! 0x5555555555555555
	and	%g4, %g3, %g1

	sllx	%g1, 7, %g3
	ld	[%i5 + 0], %l7		! &(des_ip_table[0][0])
	and	%g4, %g2, %g2

	srlx	%g2, 7, %g4
	ld	[%i5 + 4], %l6		! &(des_ip_table[1][0])
	or	%g1, %g3, %g1

	srlx	%g1, 21, %o0
	ld	[%i5 + 44], %i4		! 7 (for iteration counter)
	or	%g2, %g4, %g2

	srlx	%g1, 5, %o1
	ld	[%i5 + 12], %l0		! &(des_sbox_table[0][0])
	and	%o0, 0x7f8, %o0

	srlx	%g2, 13, %o2
	ldx	[%l7 + %o0], %o0
	and	%o1, 0x7f8, %o1

	sllx	%g2, 3, %o3
	ldx	[%l6 + %o1], %o1
	and	%o2, 0x7f8, %o2

	srlx	%g1, 53, %o4
	ldx	[%l7 + %o2], %o2
	and	%o3, 0x7f8, %o3

	srlx	%g1, 37, %o5
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x7f8, %o4

	srlx	%g2, 45, %g1
	ldx	[%l7 + %o4], %o4
	and	%o5, 0x7f8, %o5

	srlx	%g2, 29, %g2
	ldx	[%l6 + %o5], %o5
	and	%g1, 0x7f8, %g1

	sllx	%o0, 6, %o0
	ldx	[%l7 + %g1], %g1
	and	%g2, 0x7f8, %g2

	sllx	%o1, 6, %o1
	ldx	[%l6 + %g2], %g2
	or	%o4, %o5, %o4

	sllx	%o2, 6, %o2
	ld	[%i5 + 16], %l1		! &(des_sbox_table[1][0])
	or	%o0, %o1, %o0

	sllx	%o3, 6, %o3
	ldx	[%i5 + 48], %g3		! top_1
	or	%o0, %o4, %o0

	or	%g1, %g2, %g1
	ldx	[%i5 + 56], %g4		! mid_4
	or	%o2, %o3, %o2

	and	%o0, %g3, %o4
	ldx	[%i5 + 64], %g2		! low_3
	or	%o2, %g1, %o1

	sllx	%o4, 8, %o4
	ld	[%i5 + 20], %l2		! &(des_sbox_table[2][0])
	and	%o1, %g3, %o5

	sllx	%o5, 8, %o5
	ld	[%i5 + 24], %l3		! &(des_sbox_table[3][0])
	and	%o0, %g2, %o2

	srlx	%o2, 5, %o2
	ld	[%i5 + 28], %l4		! &(des_sbox_table[4][0])
	and	%o1, %g2, %o3

	srlx	%o3, 5, %o3
	ldx	[%i0], %g2		! ks[0]
	and	%o0, %g4, %o0

	or	%o0, %o2, %o0
	ld	[%i5 + 32], %l5		! &(des_sbox_table[5][0])
	and	%o1, %g4, %o1

	or	%o0, %o4, %o0
	ld	[%i5 + 36], %l6		! &(des_sbox_table[6][0])
	or	%o1, %o3, %o1

	xor	%o0, %g2, %g1
	ld	[%i5 + 40], %l7		! &(des_sbox_table[7][0])
	or	%o1, %o5, %o1

#endif
.L2:
	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5
.L3:
	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
	add	%i0, 16, %i0

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %o1

	srl	%g1, 23, %g1
	xor	%o1, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0], %g2
	subcc	%i4,1,%i4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	xor	%o0, %g2, %g1
!	bnz	%icc, .L2
	xor	%o0, %o5, %o0

	srlx	%g1, 55, %g1
	xor	%o0, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l0 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 35, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 6, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l2 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srl	%o5, 23, %o5
	ldx	[%l6 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l4 + %o5], %o5
	or	%o2, %o3, %o3

	or	%g4, %o3, %o3
	ldx	[%i0 + 8], %g2
#ifdef __sparcv9
	subcc	%i2, 1, %i2		! one_or_three for v9
#else
	subcc	%i3, 1, %i3		! one_or_three for v8
#endif

	xor	%o1, %o3, %o1
	or	%o4, %o5, %o5

	xor	%o1, %g2, %g1
	xor	%o1, %o5, %g5

	srl	%g1, 23, %g1
	xor	%g5, %g2, %o5

	srlx	%o5, 41, %g3
	ldx	[%l4 + %g1], %g1
	and	%o5, 0x1f8, %g2

	srlx	%o5, 29, %g4
	ldx	[%l7 + %g2], %g2
	and	%g3, 0x1f8, %g3

	srlx	%o5, 12, %o2
	ldx	[%l1 + %g3], %g3
	and	%g4, 0x1f8, %g4

	srlx	%o5, 6, %o3
	ldx	[%l3 + %g4], %g4
	and	%o2, 0x1f8, %o2

	srlx	%o5, 35, %o4
	ldx	[%l5 + %o2], %o2
	and	%o3, 0x1f8, %o3

	or	%g1, %g2, %g2
	ldx	[%l6 + %o3], %o3
	and	%o4, 0x1f8, %o4

	srlx	%o5, 55, %o5
	ldx	[%l2 + %o4], %o4
	or	%g3, %g4, %g4

	or	%g2, %g4, %g4
	ldx	[%l0 + %o5], %o5
	bz,pn	%icc, .L4		! if finished (one or three iterations
	or	%o2, %o3, %o3		! of the 16 rounds), go to final perm.

	or	%g4, %o3, %o3
	ldx	[%i0 + 16], %g2
	add	%i0, 16, %i0

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o4

	xor	%g5, %g2, %o5
	xor	%o0, %o4, %o1

	srlx	%o5, 55, %g1
	ba	.L3
	or	%g5, %g0, %o0


.L4:
	or	%g4, %o3, %o3
#ifdef __sparcv9
	ldx	[%i5 + 16], %i5		! &(dec_fp_table[0])
#else
	ld	[%i5 + 8], %i5		! &(dec_fp_table[0])
#endif
	or	%g0, 0xf, %g4

	xor	%o0, %o3, %o0
	or	%o4, %o5, %o5

	sllx	%g4, 59, %g4		! mask for bits 1-4
	xor	%o0, %o5, %o0

! fp starts here

	srlx	%o0, 33, %g1
	and	%o0, %g4, %g2

	srlx	%g5, 37, %l0
	and	%g5, %g4, %g3

	srlx	%g2, 53, %g2
	and	%g1, 0x3c0, %g1

	srlx	%g3, 57, %l1
	and	%l0, 0x3c, %l0

	srlx	%o0, 21, %g3
	or	%g1, %l0, %l0

	srlx	%g5, 25, %l2
	ld	[%i5 + %l0], %l0
	or	%l1, %g2, %l1

	srlx	%o0, 4, %g4
	ld	[%i5 + %l1], %l1
	and	%g3, 0x3c0, %g3

	srlx	%g5, 8, %l3
	and	%l2, 0x3c, %l2

	srlx	%o0, 27, %g1
	or	%l2, %g3, %l2

	srlx	%g5, 31, %l4
	ld	[%i5 + %l2], %l2
	and	%g4, 0x3c0, %g4

	and	%l3, 0x3c, %l3
	and	%g1, 0x3c0, %g1

	srlx	%o0, 10, %g2
	or	%l3, %g4, %l3

	srlx	%g5, 14, %l5
	ld	[%i5 + %l3], %l3
	and	%l4, 0x3c, %l4

	sllx	%o0, 2, %g3
	or	%l4, %g1, %l4

	srlx	%g5, 2, %l6
	ld	[%i5 + %l4], %l4
	and	%g2, 0x3c0, %g2

	srlx	%o0, 39, %g4
	and	%l5, 0x3c, %l5

	and	%g3, 0x3c0, %g3
	or	%l5, %g2, %l5

	srlx	%g5, 43, %l7
	ld	[%i5 + %l5], %l5
	and	%l6, 0x3c, %l6

	and	%g4, 0x3c0, %g4
	or	%l6, %g3, %l6

	srl	%l0, 2, %l0
	ld	[%i5 + %l6], %l6
	and	%l7, 0x3c, %l7

	srl	%l2, 4, %l2
	or	%l7, %g4, %l7

	srl	%l4, 2, %l4
	ld	[%i5 + %l7], %l7
	or	%l0, %l1, %l1

	srl	%l5, 4, %l5
	or	%l1, %l2, %l2

	srl	%l6, 6, %l6
	or	%l4, %l5, %l5

	srl	%l3, 6, %l3
	or	%l6, %l7, %l7

	or	%l2, %l3, %i1
	or	%l5, %l7, %i0

!
! result at this point is in i0-i1, just as it should for v8
!
#ifdef __sparcv9
	srl	%i1, 0, %i1

	sllx	%i0, 32, %i0

	or	%i0, %i1, %i0
#endif


	ret
	restore	%g0,%g0,%g0
	.type	des_crypt_impl,2
	.size	des_crypt_impl,(.-des_crypt_impl)

	.align	32
!
! CONSTANT POOL
!
des_fp_table:
	.word	0
	.word	-2147483648
	.word	8388608
	.word	-2139095040
	.word	32768
	.word	-2147450880
	.word	8421376
	.word	-2139062272
	.word	128
	.word	-2147483520
	.word	8388736
	.word	-2139094912
	.word	32896
	.word	-2147450752
	.word	8421504
	.word	-2139062144
	.word	1073741824
	.word	-1073741824
	.word	1082130432
	.word	-1065353216
	.word	1073774592
	.word	-1073709056
	.word	1082163200
	.word	-1065320448
	.word	1073741952
	.word	-1073741696
	.word	1082130560
	.word	-1065353088
	.word	1073774720
	.word	-1073708928
	.word	1082163328
	.word	-1065320320
	.word	4194304
	.word	-2143289344
	.word	12582912
	.word	-2134900736
	.word	4227072
	.word	-2143256576
	.word	12615680
	.word	-2134867968
	.word	4194432
	.word	-2143289216
	.word	12583040
	.word	-2134900608
	.word	4227200
	.word	-2143256448
	.word	12615808
	.word	-2134867840
	.word	1077936128
	.word	-1069547520
	.word	1086324736
	.word	-1061158912
	.word	1077968896
	.word	-1069514752
	.word	1086357504
	.word	-1061126144
	.word	1077936256
	.word	-1069547392
	.word	1086324864
	.word	-1061158784
	.word	1077969024
	.word	-1069514624
	.word	1086357632
	.word	-1061126016
	.word	16384
	.word	-2147467264
	.word	8404992
	.word	-2139078656
	.word	49152
	.word	-2147434496
	.word	8437760
	.word	-2139045888
	.word	16512
	.word	-2147467136
	.word	8405120
	.word	-2139078528
	.word	49280
	.word	-2147434368
	.word	8437888
	.word	-2139045760
	.word	1073758208
	.word	-1073725440
	.word	1082146816
	.word	-1065336832
	.word	1073790976
	.word	-1073692672
	.word	1082179584
	.word	-1065304064
	.word	1073758336
	.word	-1073725312
	.word	1082146944
	.word	-1065336704
	.word	1073791104
	.word	-1073692544
	.word	1082179712
	.word	-1065303936
	.word	4210688
	.word	-2143272960
	.word	12599296
	.word	-2134884352
	.word	4243456
	.word	-2143240192
	.word	12632064
	.word	-2134851584
	.word	4210816
	.word	-2143272832
	.word	12599424
	.word	-2134884224
	.word	4243584
	.word	-2143240064
	.word	12632192
	.word	-2134851456
	.word	1077952512
	.word	-1069531136
	.word	1086341120
	.word	-1061142528
	.word	1077985280
	.word	-1069498368
	.word	1086373888
	.word	-1061109760
	.word	1077952640
	.word	-1069531008
	.word	1086341248
	.word	-1061142400
	.word	1077985408
	.word	-1069498240
	.word	1086374016
	.word	-1061109632
	.word	64
	.word	-2147483584
	.word	8388672
	.word	-2139094976
	.word	32832
	.word	-2147450816
	.word	8421440
	.word	-2139062208
	.word	192
	.word	-2147483456
	.word	8388800
	.word	-2139094848
	.word	32960
	.word	-2147450688
	.word	8421568
	.word	-2139062080
	.word	1073741888
	.word	-1073741760
	.word	1082130496
	.word	-1065353152
	.word	1073774656
	.word	-1073708992
	.word	1082163264
	.word	-1065320384
	.word	1073742016
	.word	-1073741632
	.word	1082130624
	.word	-1065353024
	.word	1073774784
	.word	-1073708864
	.word	1082163392
	.word	-1065320256
	.word	4194368
	.word	-2143289280
	.word	12582976
	.word	-2134900672
	.word	4227136
	.word	-2143256512
	.word	12615744
	.word	-2134867904
	.word	4194496
	.word	-2143289152
	.word	12583104
	.word	-2134900544
	.word	4227264
	.word	-2143256384
	.word	12615872
	.word	-2134867776
	.word	1077936192
	.word	-1069547456
	.word	1086324800
	.word	-1061158848
	.word	1077968960
	.word	-1069514688
	.word	1086357568
	.word	-1061126080
	.word	1077936320
	.word	-1069547328
	.word	1086324928
	.word	-1061158720
	.word	1077969088
	.word	-1069514560
	.word	1086357696
	.word	-1061125952
	.word	16448
	.word	-2147467200
	.word	8405056
	.word	-2139078592
	.word	49216
	.word	-2147434432
	.word	8437824
	.word	-2139045824
	.word	16576
	.word	-2147467072
	.word	8405184
	.word	-2139078464
	.word	49344
	.word	-2147434304
	.word	8437952
	.word	-2139045696
	.word	1073758272
	.word	-1073725376
	.word	1082146880
	.word	-1065336768
	.word	1073791040
	.word	-1073692608
	.word	1082179648
	.word	-1065304000
	.word	1073758400
	.word	-1073725248
	.word	1082147008
	.word	-1065336640
	.word	1073791168
	.word	-1073692480
	.word	1082179776
	.word	-1065303872
	.word	4210752
	.word	-2143272896
	.word	12599360
	.word	-2134884288
	.word	4243520
	.word	-2143240128
	.word	12632128
	.word	-2134851520
	.word	4210880
	.word	-2143272768
	.word	12599488
	.word	-2134884160
	.word	4243648
	.word	-2143240000
	.word	12632256
	.word	-2134851392
	.word	1077952576
	.word	-1069531072
	.word	1086341184
	.word	-1061142464
	.word	1077985344
	.word	-1069498304
	.word	1086373952
	.word	-1061109696
	.word	1077952704
	.word	-1069530944
	.word	1086341312
	.word	-1061142336
	.word	1077985472
	.word	-1069498176
	.word	1086374080
	.word	-1061109568
	.type	des_fp_table,#object
	.size	des_fp_table,1024

#endif	/* lint || __lint */
