/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#include <sys/types.h>

static uint64_t pc1_table[2][128]=
{
/* BEGIN CSTYLED */
{
0x0000000000000000ULL, 0x0000000000100000ULL, 0x0000000000001000ULL, 0x0000000000101000ULL,
0x0000000000000010ULL, 0x0000000000100010ULL, 0x0000000000001010ULL, 0x0000000000101010ULL,
0x0000000000000001ULL, 0x0000000000100001ULL, 0x0000000000001001ULL, 0x0000000000101001ULL,
0x0000000000000011ULL, 0x0000000000100011ULL, 0x0000000000001011ULL, 0x0000000000101011ULL,
0x0000000100000000ULL, 0x0000000100100000ULL, 0x0000000100001000ULL, 0x0000000100101000ULL,
0x0000000100000010ULL, 0x0000000100100010ULL, 0x0000000100001010ULL, 0x0000000100101010ULL,
0x0000000100000001ULL, 0x0000000100100001ULL, 0x0000000100001001ULL, 0x0000000100101001ULL,
0x0000000100000011ULL, 0x0000000100100011ULL, 0x0000000100001011ULL, 0x0000000100101011ULL,
0x0000010000000000ULL, 0x0000010000100000ULL, 0x0000010000001000ULL, 0x0000010000101000ULL,
0x0000010000000010ULL, 0x0000010000100010ULL, 0x0000010000001010ULL, 0x0000010000101010ULL,
0x0000010000000001ULL, 0x0000010000100001ULL, 0x0000010000001001ULL, 0x0000010000101001ULL,
0x0000010000000011ULL, 0x0000010000100011ULL, 0x0000010000001011ULL, 0x0000010000101011ULL,
0x0000010100000000ULL, 0x0000010100100000ULL, 0x0000010100001000ULL, 0x0000010100101000ULL,
0x0000010100000010ULL, 0x0000010100100010ULL, 0x0000010100001010ULL, 0x0000010100101010ULL,
0x0000010100000001ULL, 0x0000010100100001ULL, 0x0000010100001001ULL, 0x0000010100101001ULL,
0x0000010100000011ULL, 0x0000010100100011ULL, 0x0000010100001011ULL, 0x0000010100101011ULL,
0x0001000000000000ULL, 0x0001000000100000ULL, 0x0001000000001000ULL, 0x0001000000101000ULL,
0x0001000000000010ULL, 0x0001000000100010ULL, 0x0001000000001010ULL, 0x0001000000101010ULL,
0x0001000000000001ULL, 0x0001000000100001ULL, 0x0001000000001001ULL, 0x0001000000101001ULL,
0x0001000000000011ULL, 0x0001000000100011ULL, 0x0001000000001011ULL, 0x0001000000101011ULL,
0x0001000100000000ULL, 0x0001000100100000ULL, 0x0001000100001000ULL, 0x0001000100101000ULL,
0x0001000100000010ULL, 0x0001000100100010ULL, 0x0001000100001010ULL, 0x0001000100101010ULL,
0x0001000100000001ULL, 0x0001000100100001ULL, 0x0001000100001001ULL, 0x0001000100101001ULL,
0x0001000100000011ULL, 0x0001000100100011ULL, 0x0001000100001011ULL, 0x0001000100101011ULL,
0x0001010000000000ULL, 0x0001010000100000ULL, 0x0001010000001000ULL, 0x0001010000101000ULL,
0x0001010000000010ULL, 0x0001010000100010ULL, 0x0001010000001010ULL, 0x0001010000101010ULL,
0x0001010000000001ULL, 0x0001010000100001ULL, 0x0001010000001001ULL, 0x0001010000101001ULL,
0x0001010000000011ULL, 0x0001010000100011ULL, 0x0001010000001011ULL, 0x0001010000101011ULL,
0x0001010100000000ULL, 0x0001010100100000ULL, 0x0001010100001000ULL, 0x0001010100101000ULL,
0x0001010100000010ULL, 0x0001010100100010ULL, 0x0001010100001010ULL, 0x0001010100101010ULL,
0x0001010100000001ULL, 0x0001010100100001ULL, 0x0001010100001001ULL, 0x0001010100101001ULL,
0x0001010100000011ULL, 0x0001010100100011ULL, 0x0001010100001011ULL, 0x0001010100101011ULL
},
{
0x0000000000000000ULL, 0x0000000001000000ULL, 0x0000000000010000ULL, 0x0000000001010000ULL,
0x0000000000000100ULL, 0x0000000001000100ULL, 0x0000000000010100ULL, 0x0000000001010100ULL,
0x0000000010000000ULL, 0x0000000011000000ULL, 0x0000000010010000ULL, 0x0000000011010000ULL,
0x0000000010000100ULL, 0x0000000011000100ULL, 0x0000000010010100ULL, 0x0000000011010100ULL,
0x0000001000000000ULL, 0x0000001001000000ULL, 0x0000001000010000ULL, 0x0000001001010000ULL,
0x0000001000000100ULL, 0x0000001001000100ULL, 0x0000001000010100ULL, 0x0000001001010100ULL,
0x0000001010000000ULL, 0x0000001011000000ULL, 0x0000001010010000ULL, 0x0000001011010000ULL,
0x0000001010000100ULL, 0x0000001011000100ULL, 0x0000001010010100ULL, 0x0000001011010100ULL,
0x0000100000000000ULL, 0x0000100001000000ULL, 0x0000100000010000ULL, 0x0000100001010000ULL,
0x0000100000000100ULL, 0x0000100001000100ULL, 0x0000100000010100ULL, 0x0000100001010100ULL,
0x0000100010000000ULL, 0x0000100011000000ULL, 0x0000100010010000ULL, 0x0000100011010000ULL,
0x0000100010000100ULL, 0x0000100011000100ULL, 0x0000100010010100ULL, 0x0000100011010100ULL,
0x0000101000000000ULL, 0x0000101001000000ULL, 0x0000101000010000ULL, 0x0000101001010000ULL,
0x0000101000000100ULL, 0x0000101001000100ULL, 0x0000101000010100ULL, 0x0000101001010100ULL,
0x0000101010000000ULL, 0x0000101011000000ULL, 0x0000101010010000ULL, 0x0000101011010000ULL,
0x0000101010000100ULL, 0x0000101011000100ULL, 0x0000101010010100ULL, 0x0000101011010100ULL,
0x0010000000000000ULL, 0x0010000001000000ULL, 0x0010000000010000ULL, 0x0010000001010000ULL,
0x0010000000000100ULL, 0x0010000001000100ULL, 0x0010000000010100ULL, 0x0010000001010100ULL,
0x0010000010000000ULL, 0x0010000011000000ULL, 0x0010000010010000ULL, 0x0010000011010000ULL,
0x0010000010000100ULL, 0x0010000011000100ULL, 0x0010000010010100ULL, 0x0010000011010100ULL,
0x0010001000000000ULL, 0x0010001001000000ULL, 0x0010001000010000ULL, 0x0010001001010000ULL,
0x0010001000000100ULL, 0x0010001001000100ULL, 0x0010001000010100ULL, 0x0010001001010100ULL,
0x0010001010000000ULL, 0x0010001011000000ULL, 0x0010001010010000ULL, 0x0010001011010000ULL,
0x0010001010000100ULL, 0x0010001011000100ULL, 0x0010001010010100ULL, 0x0010001011010100ULL,
0x0010100000000000ULL, 0x0010100001000000ULL, 0x0010100000010000ULL, 0x0010100001010000ULL,
0x0010100000000100ULL, 0x0010100001000100ULL, 0x0010100000010100ULL, 0x0010100001010100ULL,
0x0010100010000000ULL, 0x0010100011000000ULL, 0x0010100010010000ULL, 0x0010100011010000ULL,
0x0010100010000100ULL, 0x0010100011000100ULL, 0x0010100010010100ULL, 0x0010100011010100ULL,
0x0010101000000000ULL, 0x0010101001000000ULL, 0x0010101000010000ULL, 0x0010101001010000ULL,
0x0010101000000100ULL, 0x0010101001000100ULL, 0x0010101000010100ULL, 0x0010101001010100ULL,
0x0010101010000000ULL, 0x0010101011000000ULL, 0x0010101010010000ULL, 0x0010101011010000ULL,
0x0010101010000100ULL, 0x0010101011000100ULL, 0x0010101010010100ULL, 0x0010101011010100ULL
}
/* END CSTYLED */
};


static uint32_t pc2_1_table[4][64] =
{
{
0x00000000, 0x00004000, 0x04000000, 0x04004000,
0x00000100, 0x00004100, 0x04000100, 0x04004100,
0x00020000, 0x00024000, 0x04020000, 0x04024000,
0x00020100, 0x00024100, 0x04020100, 0x04024100,
0x00000001, 0x00004001, 0x04000001, 0x04004001,
0x00000101, 0x00004101, 0x04000101, 0x04004101,
0x00020001, 0x00024001, 0x04020001, 0x04024001,
0x00020101, 0x00024101, 0x04020101, 0x04024101,
0x08000000, 0x08004000, 0x0c000000, 0x0c004000,
0x08000100, 0x08004100, 0x0c000100, 0x0c004100,
0x08020000, 0x08024000, 0x0c020000, 0x0c024000,
0x08020100, 0x08024100, 0x0c020100, 0x0c024100,
0x08000001, 0x08004001, 0x0c000001, 0x0c004001,
0x08000101, 0x08004101, 0x0c000101, 0x0c004101,
0x08020001, 0x08024001, 0x0c020001, 0x0c024001,
0x08020101, 0x08024101, 0x0c020101, 0x0c024101
},
{
0x00000000, 0x00000200, 0x20000000, 0x20000200,
0x00001000, 0x00001200, 0x20001000, 0x20001200,
0x00000000, 0x00000200, 0x20000000, 0x20000200,
0x00001000, 0x00001200, 0x20001000, 0x20001200,
0x00000040, 0x00000240, 0x20000040, 0x20000240,
0x00001040, 0x00001240, 0x20001040, 0x20001240,
0x00000040, 0x00000240, 0x20000040, 0x20000240,
0x00001040, 0x00001240, 0x20001040, 0x20001240,
0x00000010, 0x00000210, 0x20000010, 0x20000210,
0x00001010, 0x00001210, 0x20001010, 0x20001210,
0x00000010, 0x00000210, 0x20000010, 0x20000210,
0x00001010, 0x00001210, 0x20001010, 0x20001210,
0x00000050, 0x00000250, 0x20000050, 0x20000250,
0x00001050, 0x00001250, 0x20001050, 0x20001250,
0x00000050, 0x00000250, 0x20000050, 0x20000250,
0x00001050, 0x00001250, 0x20001050, 0x20001250
},
{
0x00000000, 0x00000000, 0x40000000, 0x40000000,
0x00000020, 0x00000020, 0x40000020, 0x40000020,
0x00008000, 0x00008000, 0x40008000, 0x40008000,
0x00008020, 0x00008020, 0x40008020, 0x40008020,
0x80000000, 0x80000000, 0xc0000000, 0xc0000000,
0x80000020, 0x80000020, 0xc0000020, 0xc0000020,
0x80008000, 0x80008000, 0xc0008000, 0xc0008000,
0x80008020, 0x80008020, 0xc0008020, 0xc0008020,
0x00000002, 0x00000002, 0x40000002, 0x40000002,
0x00000022, 0x00000022, 0x40000022, 0x40000022,
0x00008002, 0x00008002, 0x40008002, 0x40008002,
0x00008022, 0x00008022, 0x40008022, 0x40008022,
0x80000002, 0x80000002, 0xc0000002, 0xc0000002,
0x80000022, 0x80000022, 0xc0000022, 0xc0000022,
0x80008002, 0x80008002, 0xc0008002, 0xc0008002,
0x80008022, 0x80008022, 0xc0008022, 0xc0008022
},
{
0x00000000, 0x10000000, 0x00000800, 0x10000800,
0x00000000, 0x10000000, 0x00000800, 0x10000800,
0x00002000, 0x10002000, 0x00002800, 0x10002800,
0x00002000, 0x10002000, 0x00002800, 0x10002800,
0x00000004, 0x10000004, 0x00000804, 0x10000804,
0x00000004, 0x10000004, 0x00000804, 0x10000804,
0x00002004, 0x10002004, 0x00002804, 0x10002804,
0x00002004, 0x10002004, 0x00002804, 0x10002804,
0x00000400, 0x10000400, 0x00000c00, 0x10000c00,
0x00000400, 0x10000400, 0x00000c00, 0x10000c00,
0x00002400, 0x10002400, 0x00002c00, 0x10002c00,
0x00002400, 0x10002400, 0x00002c00, 0x10002c00,
0x00000404, 0x10000404, 0x00000c04, 0x10000c04,
0x00000404, 0x10000404, 0x00000c04, 0x10000c04,
0x00002404, 0x10002404, 0x00002c04, 0x10002c04,
0x00002404, 0x10002404, 0x00002c04, 0x10002c04
}
};

static uint32_t pc2_1_tail_table[8] =
{
0x00000000, 0x00010000, 0x00000008, 0x00010008,
0x00000080, 0x00010080, 0x00000088, 0x00010088
};

static uint32_t pc2_2_table[5][32] =
{
{
0x00000000, 0x00010000, 0x00000008, 0x00010008,
0x20000000, 0x20010000, 0x20000008, 0x20010008,
0x00100000, 0x00110000, 0x00100008, 0x00110008,
0x20100000, 0x20110000, 0x20100008, 0x20110008,
0x00000010, 0x00010010, 0x00000018, 0x00010018,
0x20000010, 0x20010010, 0x20000018, 0x20010018,
0x00100010, 0x00110010, 0x00100018, 0x00110018,
0x20100010, 0x20110010, 0x20100018, 0x20110018
},
{
0x00000000, 0x00000000, 0x10000000, 0x10000000,
0x00000020, 0x00000020, 0x10000020, 0x10000020,
0x00000000, 0x00000000, 0x10000000, 0x10000000,
0x00000020, 0x00000020, 0x10000020, 0x10000020,
0x00000400, 0x00000400, 0x10000400, 0x10000400,
0x00000420, 0x00000420, 0x10000420, 0x10000420,
0x00000400, 0x00000400, 0x10000400, 0x10000400,
0x00000420, 0x00000420, 0x10000420, 0x10000420
},
{
0x00000000, 0x00000000, 0x00000080, 0x00000080,
0x80000000, 0x80000000, 0x80000080, 0x80000080,
0x00080000, 0x00080000, 0x00080080, 0x00080080,
0x80080000, 0x80080000, 0x80080080, 0x80080080,
0x00001000, 0x00001000, 0x00001080, 0x00001080,
0x80001000, 0x80001000, 0x80001080, 0x80001080,
0x00081000, 0x00081000, 0x00081080, 0x00081080,
0x80081000, 0x80081000, 0x80081080, 0x80081080
},
{
0x00000000, 0x00008000, 0x08000000, 0x08008000,
0x00000100, 0x00008100, 0x08000100, 0x08008100,
0x00020000, 0x00028000, 0x08020000, 0x08028000,
0x00020100, 0x00028100, 0x08020100, 0x08028100,
0x00004000, 0x0000c000, 0x08004000, 0x0800c000,
0x00004100, 0x0000c100, 0x08004100, 0x0800c100,
0x00024000, 0x0002c000, 0x08024000, 0x0802c000,
0x00024100, 0x0002c100, 0x08024100, 0x0802c100
},
{
0x00000000, 0x00000200, 0x40000000, 0x40000200,
0x00040000, 0x00040200, 0x40040000, 0x40040200,
0x00000040, 0x00000240, 0x40000040, 0x40000240,
0x00040040, 0x00040240, 0x40040040, 0x40040240,
0x00002000, 0x00002200, 0x40002000, 0x40002200,
0x00042000, 0x00042200, 0x40042000, 0x40042200,
0x00002040, 0x00002240, 0x40002040, 0x40002240,
0x00042040, 0x00042240, 0x40042040, 0x40042240
}
};

static uint32_t pc2_2_tail_table[4] =
{
0x00000000, 0x00000800, 0x04000000, 0x04000800
};

static int ss[16] = {1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};


/*
 * This routine initializes the key schedule.
 */
void
des_ks(uint64_t *ks, uint64_t key)
{
	int i;
	uint32_t upper, lower;
	uint64_t c, d;

	c = pc1_table[0][key >> 57] |
		((pc1_table[0][(key >> 49) & 127ULL]) << 1) |
		((pc1_table[0][(key >> 41) & 127ULL]) << 2) |
		((pc1_table[0][(key >> 33) & 127ULL]) << 3) |
		pc1_table[1][(key >> 25) & 127ULL] |
		((pc1_table[1][(key >> 17) & 127ULL]) << 1) |
		((pc1_table[1][(key >> 9) & 127ULL]) << 2) |
		((pc1_table[1][(key >> 1) & 127ULL]) << 3);

	d = (c & 0xfffffffULL) | ((c & 0xfffffffULL) << 28);
	c = (c & 0xfffffff0000000ULL) | ((c & 0xfffffff0000000ULL) >> 28);

	for (i = 0; i < 16; i++) {
		c = c << ss[i];
		d = d << ss[i];

		upper = pc2_1_table[0][(c >> 50) & 63] |
			pc2_1_table[1][(c >> 44) & 63] |
			pc2_1_table[2][(c >> 38) & 63] |
			pc2_1_table[3][(c >> 32) & 63] |
			pc2_1_tail_table[(c >> 28) & 7];

		lower = pc2_2_table[0][(d >> 51) & 31] |
			pc2_2_table[1][(d >> 46) & 31] |
			pc2_2_table[2][(d >> 41) & 31] |
			pc2_2_table[3][(d >> 36) & 31] |
			pc2_2_table[4][(d >> 31) & 31] |
			pc2_2_tail_table[(d >> 28) & 3];
		ks[i] = ((uint64_t)upper)<<32 | ((uint64_t)lower);
	}
}
