/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Unified version for both position independent and non position independent
 * for both v8plus and v9.
 * Compile with:
 *
 * cc -c -xarch=v8plus aes_crypt_asm.S     or
 * cc -c -arch=v9 aes_crypt_asm.S
 * for kernel use (no -KPIC).
 *
 * and with
 *
 * cc -c -xarch=v8plus -KPIC -DPIC aes_crypt_asm.S     or
 * cc -c -arch=v9 -KPIC -DPIC aes_crypt_asm.S
 * for  .so  use.
 *
 *
 * The tables were generated by a C program, compiled into the C version
 * of this function, from which a .s was generated by the C compiler and
 * that .s was used as a starting point for this one, in particular for
 * the data definitions. It is important, though that the tables and
 * the code both remain in the text section and in this order, otherwise,
 * at least on UltraSparc-II processors, collisions in the E-cache are
 * highly probable between the code and the data it is using which can
 * result in up to 40% performance loss.
 *
 * For a description of the AES algorithm (a.k.a. Rijndael), see NIST
 * publication FIPS PUB 197.
 *
 */

#include <sys/stack.h>

#if defined(lint) || defined(__lint)

#include <sys/types.h>
/* ARGSUSED */
void aes_encrypt_impl(const uint32_t rk[], int Nr, const uint32_t pt[4],
	uint32_t ct[4]) {
}
/* ARGSUSED */
void aes_decrypt_impl(const uint32_t rk[], int Nr, const uint32_t ct[4],
	uint32_t pt[4]) {
}

#else	/* lint || __lint */

	.section	".text",#alloc,#execinstr
	.file	"aes_crypt_asm.s"

	.register	%g2,#scratch
	.register	%g3,#scratch

	.section	".text",#alloc
	.align	8192

!
! CONSTANT POOL
!
Te0:
	.word	1584
	.word	1661148456
	.word	1984
	.word	2080629792
	.word	1904
	.word	1996733640
	.word	1968
	.word	2063850600
	.word	2040
	.word	-234385304
	.word	1712
	.word	1795382760
	.word	1776
	.word	1862499720
	.word	1160
	.word	-989451616
	.word	768
	.word	805405312
	.word	16
	.word	16779288
	.word	1648
	.word	1728265544
	.word	688
	.word	721509352
	.word	1848
	.word	-33034040
	.word	1448
	.word	-687424752
	.word	616
	.word	-1425711312
	.word	1888
	.word	1979954384
	.word	1144
	.word	-905555416
	.word	248
	.word	-2113661720
	.word	1096
	.word	-922334720
	.word	2000
	.word	2097409080
	.word	1912
	.word	-100151128
	.word	1424
	.word	1493356376
	.word	1136
	.word	1191329352
	.word	2008
	.word	-267943848
	.word	520
	.word	-1392152736
	.word	1432
	.word	-737762504
	.word	760
	.word	-1576724504
	.word	552
	.word	-1358594224
	.word	280
	.word	-1677400584
	.word	664
	.word	-1543166024
	.word	1824
	.word	1912837296
	.word	1240
	.word	-1073347880
	.word	936
	.word	-1224360432
	.word	1800
	.word	-49813280
	.word	488
	.word	-1828414096
	.word	608
	.word	637612880
	.word	864
	.word	906080976
	.word	1008
	.word	1057094152
	.word	1960
	.word	-150489072
	.word	1048
	.word	-871996808
	.word	832
	.word	872522464
	.word	648
	.word	-1526386784
	.word	1672
	.word	-452515424
	.word	1992
	.word	-251164608
	.word	1808
	.word	1896058008
	.word	1368
	.word	-670645352
	.word	784
	.word	822184600
	.word	336
	.word	352365048
	.word	64
	.word	67117152
	.word	1192
	.word	-955893104
	.word	560
	.word	587275048
	.word	1256
	.word	-1023010064
	.word	384
	.word	402702656
	.word	440
	.word	-1778076408
	.word	80
	.word	83896440
	.word	376
	.word	-1710959192
	.word	112
	.word	117454920
	.word	288
	.word	302027184
	.word	216
	.word	-2147220264
	.word	1784
	.word	-502853144
	.word	1640
	.word	-351839952
	.word	624
	.word	654392136
	.word	1016
	.word	-1308256664
	.word	1872
	.word	1963175160
	.word	144
	.word	151013592
	.word	232
	.word	-2096882448
	.word	704
	.word	738288544
	.word	416
	.word	436261232
	.word	432
	.word	453040488
	.word	1760
	.word	1845720464
	.word	1440
	.word	1510135664
	.word	728
	.word	-1610283048
	.word	1312
	.word	1375901616
	.word	944
	.word	989977192
	.word	1464
	.word	-704204024
	.word	1000
	.word	-1291477392
	.word	656
	.word	687950808
	.word	1768
	.word	-486073872
	.word	752
	.word	788626312
	.word	152
	.word	-2080103240
	.word	1328
	.word	1392680872
	.word	1480
	.word	-788100288
	.word	0
	.word	0
	.word	1544
	.word	-318281376
	.word	512
	.word	536937216
	.word	1816
	.word	-66592520
	.word	968
	.word	-1325035968
	.word	1456
	.word	1526914920
	.word	1696
	.word	1778603504
	.word	1128
	.word	-888776144
	.word	824
	.word	-1106905400
	.word	912
	.word	956418648
	.word	1184
	.word	1241667312
	.word	1216
	.word	1275225760
	.word	1408
	.word	1476577088
	.word	1064
	.word	-821659056
	.word	1496
	.word	-804879528
	.word	1576
	.word	-284722864
	.word	632
	.word	-1442490584
	.word	1896
	.word	-83371856
	.word	1072
	.word	1124212264
	.word	1232
	.word	1292005048
	.word	816
	.word	855743144
	.word	136
	.word	-2063324000
	.word	1104
	.word	1157770872
	.word	1864
	.word	-116930432
	.word	32
	.word	33558576
	.word	2032
	.word	2130967560
	.word	1280
	.word	1342343040
	.word	960
	.word	1006756384
	.word	296
	.word	-1627062832
	.word	600
	.word	-1476049128
	.word	1296
	.word	1359122328
	.word	744
	.word	-1559945232
	.word	1024
	.word	1073874432
	.word	40
	.word	-1895531440
	.word	504
	.word	-1845193368
	.word	264
	.word	-1660621344
	.word	896
	.word	939639360
	.word	1928
	.word	-184047584
	.word	792
	.word	-1140463880
	.word	952
	.word	-1241139704
	.word	1400
	.word	-637086808
	.word	528
	.word	553716504
	.word	256
	.word	268468608
	.word	1832
	.word	-16254768
	.word	2024
	.word	-217606032
	.word	1528
	.word	-771320984
	.word	1032
	.word	-855217568
	.word	192
	.word	201351328
	.word	304
	.word	318806440
	.word	1560
	.word	-335060616
	.word	1520
	.word	1594031880
	.word	424
	.word	-1761297136
	.word	1088
	.word	1140991584
	.word	368
	.word	385923528
	.word	1176
	.word	-1006230856
	.word	680
	.word	-1492828272
	.word	2016
	.word	2114188304
	.word	976
	.word	1023535672
	.word	1600
	.word	1677927776
	.word	1488
	.word	1560473400
	.word	400
	.word	419481944
	.word	1840
	.word	1929616552
	.word	1536
	.word	1610810624
	.word	200
	.word	-2130441024
	.word	1264
	.word	1325563528
	.word	1304
	.word	-603528200
	.word	544
	.word	570495792
	.word	672
	.word	704730096
	.word	472
	.word	-1878751912
	.word	88
	.word	-2012986344
	.word	1120
	.word	1174550096
	.word	1592
	.word	-301502136
	.word	856
	.word	-1207581032
	.word	320
	.word	335585760
	.word	1336
	.word	-569969720
	.word	1504
	.word	1577252624
	.word	176
	.word	184572136
	.word	1384
	.word	-620307536
	.word	1752
	.word	-536411688
	.word	800
	.word	838963888
	.word	928
	.word	973197936
	.word	160
	.word	167792880
	.word	1168
	.word	1224888024
	.word	96
	.word	100675664
	.word	576
	.word	604054368
	.word	1472
	.word	1543694112
	.word	1272
	.word	-1039789336
	.word	1512
	.word	-754541712
	.word	536
	.word	-1408931976
	.word	1568
	.word	1644369200
	.word	456
	.word	-1861972672
	.word	392
	.word	-1794855648
	.word	1688
	.word	-469294664
	.word	1936
	.word	2030292056
	.word	1704
	.word	-418956912
	.word	1112
	.word	-939113960
	.word	880
	.word	922860232
	.word	1744
	.word	1828941240
	.word	8
	.word	-1929089952
	.word	1416
	.word	-720983264
	.word	1248
	.word	1308784272
	.word	584
	.word	-1459269888
	.word	1728
	.word	1812161952
	.word	1376
	.word	1443018704
	.word	1944
	.word	-200826824
	.word	1656
	.word	-368619224
	.word	1616
	.word	1694707064
	.word	1952
	.word	2047071344
	.word	568
	.word	-1375373496
	.word	128
	.word	134234304
	.word	888
	.word	-1174022488
	.word	1920
	.word	2013512768
	.word	592
	.word	620833656
	.word	736
	.word	771847056
	.word	448
	.word	469819680
	.word	696
	.word	-1509607544
	.word	920
	.word	-1274698184
	.word	1208
	.word	-972672376
	.word	1624
	.word	-402177768
	.word	1288
	.word	-586748960
	.word	1856
	.word	1946395872
	.word	496
	.word	520157448
	.word	1200
	.word	1258446568
	.word	776
	.word	-1123684640
	.word	104
	.word	-1962648528
	.word	120
	.word	-1979427800
	.word	1792
	.word	1879278720
	.word	992
	.word	1040314896
	.word	904
	.word	-1257918944
	.word	1632
	.word	1711486288
	.word	1152
	.word	1208108736
	.word	48
	.word	50337832
	.word	1976
	.word	-167268344
	.word	224
	.word	234909840
	.word	1552
	.word	1627589912
	.word	848
	.word	889301752
	.word	1392
	.word	1459797960
	.word	840
	.word	-1190801792
	.word	184
	.word	-2046544760
	.word	1224
	.word	-1056568640
	.word	464
	.word	486598968
	.word	312
	.word	-1643842104
	.word	1736
	.word	-519632448
	.word	1880
	.word	-133709672
	.word	344
	.word	-1744517736
	.word	272
	.word	285247896
	.word	1680
	.word	1761824216
	.word	1352
	.word	-653866112
	.word	56
	.word	-1912310712
	.word	408
	.word	-1811634888
	.word	360
	.word	-1694179920
	.word	480
	.word	503378192
	.word	168
	.word	-2029765488
	.word	1608
	.word	-385398528
	.word	1080
	.word	-838438328
	.word	1360
	.word	1426239480
	.word	640
	.word	671171520
	.word	1320
	.word	-553190448
	.word	24
	.word	-1945869192
	.word	712
	.word	-1593503808
	.word	72
	.word	-1996207104
	.word	208
	.word	218130616
	.word	808
	.word	-1090126128
	.word	1720
	.word	-435736184
	.word	1056
	.word	1107433008
	.word	1664
	.word	1745044928
	.word	1040
	.word	1090653720
	.word	328
	.word	-1727738496
	.word	720
	.word	755067832
	.word	240
	.word	251689096
	.word	984
	.word	-1341815208
	.word	1344
	.word	1409460192
	.word	872
	.word	-1157243216
	.word	352
	.word	369144272
	.type	Te0,#object
	.size	Te0,2048
!
! CONSTANT POOL
!
Te1:
	.word	1320
	.word	-972874984
	.word	1056
	.word	-133962784
	.word	1224
	.word	-301745224
	.word	1128
	.word	-167519272
	.word	104
	.word	-16279664
	.word	1512
	.word	-704423080
	.word	1416
	.word	-570197128
	.word	672
	.word	-1861865944
	.word	640
	.word	1610711424
	.word	24
	.word	33556488
	.word	1352
	.word	-838649032
	.word	1000
	.word	1442928984
	.word	200
	.word	-418908176
	.word	784
	.word	-1257849160
	.word	1840
	.word	1292197208
	.word	1232
	.word	-335301712
	.word	552
	.word	-1895410096
	.word	1256
	.word	520360976
	.word	512
	.word	-1996075448
	.word	1080
	.word	-100406296
	.word	168
	.word	-284698672
	.word	1880
	.word	-1308439864
	.word	1608
	.word	-1912456648
	.word	88
	.word	-83392640
	.word	1888
	.word	1090874728
	.word	824
	.word	-1291409760
	.word	2024
	.word	1594168592
	.word	1872
	.word	1157987704
	.word	1528
	.word	587523296
	.word	1976
	.word	1392846112
	.word	1200
	.word	-469527664
	.word	728
	.word	-1694104064
	.word	1552
	.word	1963310520
	.word	224
	.word	-519573528
	.word	1392
	.word	1023712408
	.word	848
	.word	1275146544
	.word	720
	.word	1812050352
	.word	520
	.word	2114058744
	.word	16
	.word	-184041544
	.word	632
	.word	-2096732576
	.word	736
	.word	1744937376
	.word	1952
	.word	1359293736
	.word	416
	.word	-788058328
	.word	64
	.word	-116945016
	.word	1176
	.word	-503084152
	.word	920
	.word	-1425619264
	.word	664
	.word	1644267912
	.word	504
	.word	704686248
	.word	96
	.word	134225952
	.word	656
	.word	-1794752968
	.word	808
	.word	1174477080
	.word	752
	.word	-1660543464
	.word	320
	.word	805355712
	.word	1288
	.word	923055280
	.word	120
	.word	167782440
	.word	1448
	.word	788845776
	.word	72
	.word	234895416
	.word	432
	.word	604016784
	.word	1240
	.word	453248000
	.word	488
	.word	-553183472
	.word	304
	.word	-855154856
	.word	840
	.word	1308703032
	.word	1640
	.word	2131072400
	.word	1272
	.word	-368858200
	.word	216
	.word	302008392
	.word	1264
	.word	486808600
	.word	928
	.word	1476485472
	.word	368
	.word	872468688
	.word	360
	.word	906025176
	.word	1424
	.word	-603753616
	.word	1904
	.word	-1274883376
	.word	2008
	.word	1527055616
	.word	1968
	.word	-1543335280
	.word	616
	.word	1979832792
	.word	776
	.word	-1224296784
	.word	1648
	.word	2097520024
	.word	984
	.word	1375816008
	.word	496
	.word	-586735848
	.word	904
	.word	1577154936
	.word	1208
	.word	319038496
	.word	1960
	.word	-1509778792
	.word	832
	.word	-1190752632
	.word	0
	.word	0
	.word	352
	.word	-1056477336
	.word	768
	.word	1073807616
	.word	248
	.word	-486021152
	.word	1600
	.word	2030407048
	.word	1896
	.word	-1241326888
	.word	1520
	.word	-737979568
	.word	560
	.word	-1928962472
	.word	1736
	.word	1728443888
	.word	600
	.word	1912719816
	.word	1776
	.word	-1811787184
	.word	1696
	.word	-1744674208
	.word	1856
	.word	-1341996352
	.word	592
	.word	-2063171976
	.word	856
	.word	-1157200256
	.word	336
	.word	-989364360
	.word	1832
	.word	1325749584
	.word	176
	.word	-318251048
	.word	1576
	.word	-2046682600
	.word	1720
	.word	-1711117720
	.word	680
	.word	1711380888
	.word	1184
	.word	285486120
	.word	1656
	.word	-1979569624
	.word	128
	.word	-385364024
	.word	48
	.word	67112976
	.word	1032
	.word	-33293320
	.word	1920
	.word	-1610448256
	.word	544
	.word	2013389280
	.word	1488
	.word	621083896
	.word	1816
	.word	1258636608
	.word	1944
	.word	-1576891768
	.word	2032
	.word	1560616216
	.word	1536
	.word	-2147352064
	.word	1104
	.word	84180088
	.word	1384
	.word	1057264784
	.word	1504
	.word	553970920
	.word	576
	.word	1879163328
	.word	32
	.word	-251154520
	.word	1784
	.word	1661330912
	.word	1544
	.word	1996862896
	.word	936
	.word	-1358506288
	.word	792
	.word	1107364104
	.word	384
	.word	536903808
	.word	208
	.word	-452460552
	.word	112
	.word	-49832040
	.word	872
	.word	-1090087280
	.word	608
	.word	-2130284952
	.word	160
	.word	402677856
	.word	424
	.word	637573272
	.word	376
	.word	-1022924960
	.word	1800
	.word	-1107100936
	.word	1296
	.word	889502904
	.word	1632
	.word	-2013126112
	.word	456
	.word	771799224
	.word	696
	.word	-1828313568
	.word	1936
	.word	1426406712
	.word	1040
	.word	-66849808
	.word	568
	.word	2046945768
	.word	1376
	.word	-939318496
	.word	1848
	.word	-1174213912
	.word	344
	.word	838912200
	.word	1192
	.word	-435971176
	.word	1280
	.word	-1073544448
	.word	1216
	.word	419695624
	.word	1672
	.word	-1644004744
	.word	1016
	.word	-1559828768
	.word	816
	.word	1140920592
	.word	1008
	.word	1409372496
	.word	1368
	.word	990151808
	.word	1048
	.word	184828992
	.word	1616
	.word	-1946013136
	.word	328
	.word	-955811984
	.word	1688
	.word	1795540416
	.word	480
	.word	671129760
	.word	968
	.word	-1492715792
	.word	1808
	.word	-1140657424
	.word	232
	.word	369121368
	.word	944
	.word	-1392058664
	.word	472
	.word	-620296448
	.word	688
	.word	1677824400
	.word	624
	.word	1946276304
	.word	240
	.word	335564880
	.word	1752
	.word	-1845343672
	.word	80
	.word	201338928
	.word	864
	.word	1208033568
	.word	1824
	.word	-1207770400
	.word	744
	.word	-1626991088
	.word	880
	.word	-1123639656
	.word	1912
	.word	1124427104
	.word	1328
	.word	-1006431472
	.word	1344
	.word	956599432
	.word	1312
	.word	822389928
	.word	440
	.word	-754505952
	.word	1112
	.word	-234632248
	.word	400
	.word	-720945352
	.word	536
	.word	-1962523072
	.word	712
	.word	1845606840
	.word	1464
	.word	-637310104
	.word	1120
	.word	17067112
	.word	800
	.word	-1324962136
	.word	1680
	.word	-1677561232
	.word	1792
	.word	1225084232
	.word	1440
	.word	-670866592
	.word	2000
	.word	-1409109328
	.word	56
	.word	-217602144
	.word	296
	.word	-821602480
	.word	1400
	.word	-905762008
	.word	1136
	.word	-201075760
	.word	1864
	.word	1191540080
	.word	192
	.word	268451904
	.word	1704
	.word	1862653392
	.word	1088
	.word	-268188736
	.word	888
	.word	1241590056
	.word	912
	.word	1543598448
	.word	288
	.word	939581664
	.word	1928
	.word	1459959088
	.word	1592
	.word	1929749920
	.word	648
	.word	-1761200592
	.word	280
	.word	-888715456
	.word	992
	.word	-1593381144
	.word	1248
	.word	-402414688
	.word	264
	.word	1040251128
	.word	1768
	.word	-1778230696
	.word	1760
	.word	1627778536
	.word	1072
	.word	218389592
	.word	1064
	.word	251941968
	.word	1152
	.word	-536640640
	.word	528
	.word	2080502256
	.word	1568
	.word	1896197544
	.word	1360
	.word	-872205520
	.word	1728
	.word	-1878900160
	.word	40
	.word	100669464
	.word	8
	.word	-150489168
	.word	144
	.word	469790832
	.word	1304
	.word	-1039987960
	.word	760
	.word	1778493864
	.word	1992
	.word	-1375552840
	.word	1664
	.word	1761988040
	.word	1160
	.word	386151472
	.word	704
	.word	-1727656440
	.word	312
	.word	973138152
	.word	1480
	.word	654636272
	.word	448
	.word	-653848824
	.word	152
	.word	-351811648
	.word	1432
	.word	721732800
	.word	408
	.word	570460296
	.word	1496
	.word	-771536056
	.word	896
	.word	-1459171640
	.word	1096
	.word	117732464
	.word	1336
	.word	855942304
	.word	1456
	.word	755293400
	.word	272
	.word	1006694640
	.word	1168
	.word	352599096
	.word	256
	.word	-922267832
	.word	584
	.word	-2029619600
	.word	2040
	.word	-1442665816
	.word	960
	.word	1342259520
	.word	976
	.word	-1526268168
	.word	1144
	.word	50619488
	.word	1984
	.word	1493503240
	.word	1024
	.word	151276616
	.word	184
	.word	436234344
	.word	1744
	.word	1694891512
	.word	392
	.word	-687392976
	.word	1584
	.word	-2080239088
	.word	1472
	.word	-805092544
	.word	1560
	.word	-2113795576
	.word	1408
	.word	688180424
	.word	952
	.word	1510041960
	.word	136
	.word	503347320
	.word	1624
	.word	2063959424
	.word	2016
	.word	-1476222304
	.word	1712
	.word	1829101016
	.word	464
	.word	738242736
	.type	Te1,#object
	.size	Te1,2048
!
! CONSTANT POOL
!
Te2:
	.word	792
	.word	-1526320360
	.word	992
	.word	-2079865888
	.word	952
	.word	-1727564872
	.word	984
	.word	-1928875048
	.word	1936
	.word	218627984
	.word	856
	.word	-1123634344
	.word	888
	.word	-1324944520
	.word	1576
	.word	1409584680
	.word	384
	.word	1342374272
	.word	8
	.word	50335752
	.word	824
	.word	-1459195080
	.word	344
	.word	2097328472
	.word	2032
	.word	419905520
	.word	1720
	.word	1644539576
	.word	1368
	.word	-436048552
	.word	944
	.word	-1710791760
	.word	1616
	.word	1157922384
	.word	1040
	.word	-1660879856
	.word	1608
	.word	1074024008
	.word	1000
	.word	-2029530136
	.word	2000
	.word	352813008
	.word	712
	.word	-351956280
	.word	568
	.word	-922455496
	.word	1920
	.word	185065344
	.word	1384
	.word	-335409816
	.word	1696
	.word	1728421536
	.word	1296
	.word	-50135792
	.word	1400
	.word	-368956040
	.word	1248
	.word	-1090446112
	.word	1312
	.word	-150823648
	.word	912
	.word	-1777917040
	.word	1536
	.word	1527045632
	.word	1464
	.word	-1039946312
	.word	2024
	.word	470224872
	.word	1176
	.word	-1375605608
	.word	304
	.word	1778540848
	.word	432
	.word	1510171056
	.word	504
	.word	1090777592
	.word	1976
	.word	34058168
	.word	1632
	.word	1325669984
	.word	416
	.word	1543717280
	.word	1320
	.word	-201159384
	.word	1832
	.word	872845096
	.word	1928
	.word	134729608
	.word	904
	.word	-1828252792
	.word	1728
	.word	1929731776
	.word	392
	.word	1392710024
	.word	168
	.word	1057050792
	.word	32
	.word	201343008
	.word	1592
	.word	1376038456
	.word	280
	.word	1694642456
	.word	1560
	.word	1577381400
	.word	192
	.word	671187136
	.word	1200
	.word	-1593721680
	.word	40
	.word	251678760
	.word	1232
	.word	-1258193712
	.word	56
	.word	151023672
	.word	144
	.word	906043536
	.word	1024
	.word	-1694442496
	.word	1808
	.word	1023868688
	.word	1880
	.word	637955928
	.word	312
	.word	1761767736
	.word	1424
	.word	-855376496
	.word	936
	.word	-1626909784
	.word	72
	.word	453021768
	.word	1048
	.word	-1644106728
	.word	352
	.word	1946337632
	.word	208
	.word	771858640
	.word	216
	.word	755085528
	.word	880
	.word	-1308171408
	.word	720
	.word	-301620528
	.word	1280
	.word	-83698432
	.word	656
	.word	-167435632
	.word	472
	.word	1292087768
	.word	1712
	.word	1627766448
	.word	1432
	.word	-838603368
	.word	328
	.word	2063765832
	.word	1816
	.word	1040641816
	.word	376
	.word	1896018296
	.word	1056
	.word	-1761567712
	.word	664
	.word	-184208744
	.word	1672
	.word	1745211016
	.word	0
	.word	0
	.word	1896
	.word	738594664
	.word	256
	.word	1610744064
	.word	2016
	.word	520560608
	.word	1416
	.word	-939274872
	.word	728
	.word	-318393640
	.word	848
	.word	-1106861232
	.word	1624
	.word	1174695512
	.word	1520
	.word	-654098960
	.word	456
	.word	1258525128
	.word	592
	.word	-570121648
	.word	608
	.word	-737885600
	.word	704
	.word	-402292032
	.word	1656
	.word	1241788024
	.word	1664
	.word	1795546752
	.word	1912
	.word	705048440
	.word	1360
	.word	-452821680
	.word	2008
	.word	369586136
	.word	536
	.word	-989580776
	.word	616
	.word	-687549848
	.word	408
	.word	1426272664
	.word	1064
	.word	-1811903448
	.word	552
	.word	-821800408
	.word	1992
	.word	268914632
	.word	16
	.word	100671504
	.word	1016
	.word	-2130185224
	.word	640
	.word	-268107136
	.word	480
	.word	1141096928
	.word	1272
	.word	-1174328072
	.word	1344
	.word	-486384320
	.word	648
	.word	-217771384
	.word	1304
	.word	-33362664
	.word	512
	.word	-1073479168
	.word	1144
	.word	-1979700104
	.word	1168
	.word	-1392378736
	.word	1256
	.word	-1140781848
	.word	448
	.word	1208189376
	.word	1960
	.word	67604392
	.word	1504
	.word	-553443872
	.word	1456
	.word	-1056719440
	.word	1744
	.word	1963294416
	.word	264
	.word	1661079816
	.word	128
	.word	805372032
	.word	2040
	.word	436678648
	.word	1944
	.word	235401112
	.word	1680
	.word	1829109392
	.word	1640
	.word	1275334248
	.word	96
	.word	335593568
	.word	152
	.word	889270424
	.word	1888
	.word	788930400
	.word	760
	.word	-519703816
	.word	1208
	.word	-1576948552
	.word	544
	.word	-872136160
	.word	184
	.word	956395704
	.word	1568
	.word	1459920416
	.word	1336
	.word	-234705608
	.word	1008
	.word	-2113412112
	.word	488
	.word	1191432680
	.word	800
	.word	-1408875744
	.word	744
	.word	-419048728
	.word	200
	.word	721522888
	.word	920
	.word	-1794690152
	.word	768
	.word	-1610218752
	.word	1032
	.word	-1744778232
	.word	632
	.word	-788204936
	.word	1760
	.word	2131042016
	.word	272
	.word	1711415568
	.word	336
	.word	2114101584
	.word	1152
	.word	-1425941376
	.word	1088
	.word	-2097128384
	.word	560
	.word	-905682384
	.word	1904
	.word	688275312
	.word	1472
	.word	-754754112
	.word	160
	.word	1006715040
	.word	1776
	.word	2030386928
	.word	752
	.word	-502930704
	.word	88
	.word	486584408
	.word	1752
	.word	1980067544
	.word	1792
	.word	990306048
	.word	400
	.word	1443045776
	.word	464
	.word	1308860880
	.word	80
	.word	503357520
	.word	584
	.word	-620457400
	.word	48
	.word	167796784
	.word	288
	.word	1812087072
	.word	736
	.word	-469384480
	.word	1552
	.word	1560608272
	.word	1688
	.word	1845882520
	.word	1376
	.word	-285074080
	.word	784
	.word	-1509547248
	.word	1160
	.word	-1476277112
	.word	1192
	.word	-1543402328
	.word	1824
	.word	923180832
	.word	968
	.word	-1962437688
	.word	1848
	.word	839298872
	.word	1600
	.word	1124359744
	.word	440
	.word	1493397944
	.word	872
	.word	-1224289432
	.word	1128
	.word	-1946153880
	.word	1704
	.word	1678085800
	.word	624
	.word	-771431824
	.word	1352
	.word	-536720056
	.word	864
	.word	-1274625184
	.word	688
	.word	-100310352
	.word	1952
	.word	117940128
	.word	1872
	.word	621182800
	.word	808
	.word	-1358539992
	.word	976
	.word	-1912101936
	.word	1392
	.word	-385729168
	.word	64
	.word	402686016
	.word	1488
	.word	-721191472
	.word	960
	.word	-2012773440
	.word	296
	.word	1862422824
	.word	368
	.word	1912791408
	.word	224
	.word	604094688
	.word	1328
	.word	-251478736
	.word	1440
	.word	-956064352
	.word	1584
	.word	1359265328
	.word	1856
	.word	587620160
	.word	1768
	.word	2080706280
	.word	928
	.word	-1677245536
	.word	248
	.word	553775352
	.word	600
	.word	-586894760
	.word	1512
	.word	-603779608
	.word	1112
	.word	-2046792616
	.word	1104
	.word	-2063565744
	.word	896
	.word	-1878588544
	.word	496
	.word	1107550704
	.word	1448
	.word	-1006400088
	.word	816
	.word	-1442421968
	.word	576
	.word	-670793152
	.word	24
	.word	83898392
	.word	1968
	.word	17285040
	.word	112
	.word	302047344
	.word	776
	.word	-1559883000
	.word	424
	.word	1594053032
	.word	696
	.word	-117083464
	.word	1480
	.word	-805089848
	.word	1072
	.word	-1862222800
	.word	1544
	.word	1476709896
	.word	232
	.word	654430440
	.word	1264
	.word	-1191101200
	.word	1800
	.word	939970312
	.word	1984
	.word	319250368
	.word	1216
	.word	-1291756352
	.word	136
	.word	855707784
	.word	840
	.word	-1157196984
	.word	1736
	.word	1879396040
	.word	1136
	.word	-1996473232
	.word	1184
	.word	-1493066592
	.word	1240
	.word	-1241420584
	.word	240
	.word	570548464
	.word	1080
	.word	-1845449672
	.word	1864
	.word	537284424
	.word	1648
	.word	1225014896
	.word	680
	.word	-16428376
	.word	320
	.word	2013430080
	.word	1784
	.word	2047160056
	.word	1120
	.word	-1895818144
	.word	1288
	.word	-134034168
	.word	1096
	.word	-2147464120
	.word	104
	.word	385929320
	.word	1528
	.word	-637325832
	.word	1840
	.word	822525744
	.word	528
	.word	-972807664
	.word	832
	.word	-1207532736
	.word	520
	.word	-1023143416
	.word	1224
	.word	-1342092088
	.word	360
	.word	1996673384
	.word	120
	.word	285274232
	.word	1408
	.word	-888939136
	.word	672
	.word	-66764128
	.word	1496
	.word	-704418344
	.word	176
	.word	973168816
	.type	Te2,#object
	.size	Te2,2048
!
! CONSTANT POOL
!
Te3:
	.word	792
	.word	1661283888
	.word	992
	.word	2080647104
	.word	952
	.word	1996803952
	.word	984
	.word	2063888304
	.word	1936
	.word	-234852360
	.word	856
	.word	1795550896
	.word	888
	.word	1862635248
	.word	1576
	.word	-989682552
	.word	384
	.word	805470976
	.word	8
	.word	16783376
	.word	824
	.word	1728401008
	.word	344
	.word	721676976
	.word	2032
	.word	-33501384
	.word	1720
	.word	-687663704
	.word	1368
	.word	-1425591704
	.word	944
	.word	1980028768
	.word	1616
	.word	-905827208
	.word	1040
	.word	-2113607432
	.word	1608
	.word	-922614712
	.word	1000
	.word	2097430480
	.word	2000
	.word	-100618376
	.word	712
	.word	1493654928
	.word	568
	.word	1191595120
	.word	1920
	.word	-268410920
	.word	1384
	.word	-1392025080
	.word	1696
	.word	-737985128
	.word	1296
	.word	-1576539400
	.word	1400
	.word	-1358474712
	.word	1248
	.word	-1677330152
	.word	1312
	.word	-1542997352
	.word	912
	.word	1912911648
	.word	1536
	.word	-1073554216
	.word	1464
	.word	-1224338520
	.word	2024
	.word	-50272504
	.word	1176
	.word	-1828359704
	.word	304
	.word	637751904
	.word	432
	.word	906154848
	.word	504
	.word	1057098736
	.word	1976
	.word	-150988888
	.word	1632
	.word	-872252392
	.word	416
	.word	872604480
	.word	1320
	.word	-1526226296
	.word	1832
	.word	-452876664
	.word	1928
	.word	-251639864
	.word	904
	.word	1896128272
	.word	1728
	.word	-670851752
	.word	392
	.word	822254352
	.word	168
	.word	352450896
	.word	32
	.word	67133504
	.word	1592
	.word	-956132184
	.word	280
	.word	587409968
	.word	1560
	.word	-1023216408
	.word	192
	.word	402735488
	.word	1200
	.word	-1778054728
	.word	40
	.word	83916880
	.word	1232
	.word	-1710904968
	.word	56
	.word	117459056
	.word	144
	.word	302100768
	.word	1024
	.word	-2147165992
	.word	1808
	.word	-503189768
	.word	1880
	.word	-352242072
	.word	312
	.word	654527088
	.word	1424
	.word	-1308201992
	.word	936
	.word	1963261776
	.word	72
	.word	151050384
	.word	1048
	.word	-2096828184
	.word	352
	.word	738435776
	.word	208
	.word	436302240
	.word	216
	.word	453077424
	.word	880
	.word	1845860064
	.word	720
	.word	1510438304
	.word	1280
	.word	-1610097960
	.word	656
	.word	1376236832
	.word	472
	.word	990014384
	.word	1712
	.word	-704442952
	.word	1432
	.word	-1291422744
	.word	328
	.word	688118416
	.word	1816
	.word	-486410520
	.word	376
	.word	788761328
	.word	1056
	.word	-2080065384
	.word	664
	.word	1393012016
	.word	1672
	.word	-788314680
	.word	0
	.word	0
	.word	1896
	.word	-318675448
	.word	256
	.word	537068032
	.word	2016
	.word	-67043560
	.word	1416
	.word	-1324989496
	.word	728
	.word	1527213488
	.word	848
	.word	1778775712
	.word	1624
	.word	-889047960
	.word	1520
	.word	-1106851016
	.word	456
	.word	956455824
	.word	592
	.word	1241969824
	.word	608
	.word	1275503808
	.word	704
	.word	1476871552
	.word	1656
	.word	-821930968
	.word	1664
	.word	-805085736
	.word	1912
	.word	-285125080
	.word	1360
	.word	-1442370952
	.word	2008
	.word	-83839128
	.word	536
	.word	1124478000
	.word	616
	.word	1292287184
	.word	408
	.word	855812912
	.word	1064
	.word	-2063294328
	.word	552
	.word	1158052944
	.word	1992
	.word	-117405880
	.word	16
	.word	33566752
	.word	1016
	.word	2130972656
	.word	640
	.word	1342670080
	.word	480
	.word	1006773184
	.word	1272
	.word	-1627008728
	.word	1344
	.word	-1475929512
	.word	648
	.word	1359453456
	.word	1304
	.word	-1559760152
	.word	512
	.word	1074136064
	.word	1144
	.word	-1895542744
	.word	1168
	.word	-1845138952
	.word	1256
	.word	-1660559096
	.word	448
	.word	939672448
	.word	1960
	.word	-184539256
	.word	1504
	.word	-1140393192
	.word	1456
	.word	-1241117768
	.word	1744
	.word	-637293192
	.word	264
	.word	553851408
	.word	128
	.word	268534016
	.word	2040
	.word	-16722136
	.word	1944
	.word	-218073112
	.word	1680
	.word	-771527176
	.word	1640
	.word	-855481336
	.word	96
	.word	201367744
	.word	152
	.word	318875952
	.word	1888
	.word	-335446504
	.word	760
	.word	1594297840
	.word	1208
	.word	-1761275480
	.word	544
	.word	1141269568
	.word	184
	.word	385993072
	.word	1568
	.word	-1006453608
	.word	1336
	.word	-1492675928
	.word	1008
	.word	2114197472
	.word	488
	.word	1023556560
	.word	800
	.word	1678075456
	.word	744
	.word	1560755664
	.word	200
	.word	419518864
	.word	920
	.word	1929686832
	.word	768
	.word	1610941952
	.word	1032
	.word	-2130394936
	.word	632
	.word	1325829360
	.word	1760
	.word	-603718376
	.word	272
	.word	570634784
	.word	336
	.word	704901792
	.word	1152
	.word	-1878697512
	.word	1088
	.word	-2012997544
	.word	560
	.word	1174819936
	.word	1904
	.word	-301904328
	.word	1472
	.word	-1207526568
	.word	160
	.word	335667520
	.word	1776
	.word	-570176200
	.word	752
	.word	1577522656
	.word	88
	.word	184608944
	.word	1752
	.word	-620513944
	.word	1792
	.word	-536748328
	.word	400
	.word	839037728
	.word	464
	.word	973239200
	.word	80
	.word	167833760
	.word	584
	.word	1225186448
	.word	48
	.word	100683872
	.word	288
	.word	604201536
	.word	736
	.word	1543972288
	.word	1552
	.word	-1039995656
	.word	1688
	.word	-754747928
	.word	1376
	.word	-1408796136
	.word	784
	.word	1644508704
	.word	1160
	.word	-1861926456
	.word	1192
	.word	-1794825848
	.word	1824
	.word	-469647720
	.word	968
	.word	2030329744
	.word	1848
	.word	-419326296
	.word	1600
	.word	-939385768
	.word	440
	.word	922930032
	.word	872
	.word	1829093072
	.word	1128
	.word	-1929093112
	.word	1704
	.word	-721214072
	.word	624
	.word	1309054176
	.word	1352
	.word	-1459158456
	.word	864
	.word	1812309696
	.word	688
	.word	1443353952
	.word	1952
	.word	-201310312
	.word	1872
	.word	-369021320
	.word	808
	.word	1694858832
	.word	976
	.word	2047113120
	.word	1392
	.word	-1375253960
	.word	64
	.word	134267008
	.word	1488
	.word	-1173968008
	.word	960
	.word	2013546368
	.word	296
	.word	620984912
	.word	368
	.word	771986144
	.word	224
	.word	469836224
	.word	1328
	.word	-1509455176
	.word	1440
	.word	-1274659944
	.word	1584
	.word	-972911432
	.word	1856
	.word	-402579880
	.word	1768
	.word	-586947320
	.word	928
	.word	1946478400
	.word	248
	.word	520161776
	.word	600
	.word	1258745008
	.word	1512
	.word	-1123622136
	.word	1112
	.word	-1962659736
	.word	1104
	.word	-1979438984
	.word	896
	.word	1879344896
	.word	496
	.word	1040323552
	.word	1448
	.word	-1257888888
	.word	816
	.word	1711625824
	.word	576
	.word	1208403072
	.word	24
	.word	50341936
	.word	1968
	.word	-167768136
	.word	112
	.word	234918112
	.word	776
	.word	1627725328
	.word	424
	.word	889387856
	.word	696
	.word	1460129136
	.word	1480
	.word	-1190755512
	.word	1072
	.word	-2046523208
	.word	1544
	.word	-1056783160
	.word	232
	.word	486619600
	.word	1264
	.word	-1643787976
	.word	1800
	.word	-519977272
	.word	1984
	.word	-134176936
	.word	1216
	.word	-1744463528
	.word	136
	.word	285317392
	.word	840
	.word	1761992336
	.word	1736
	.word	-654080696
	.word	1136
	.word	-1912321992
	.word	1184
	.word	-1811596904
	.word	1240
	.word	-1694125720
	.word	240
	.word	503386592
	.word	1080
	.word	-2029743960
	.word	1864
	.word	-385808824
	.word	1648
	.word	-838710216
	.word	680
	.word	1426586960
	.word	320
	.word	671335040
	.word	1784
	.word	-553396952
	.word	1120
	.word	-1945864168
	.word	1288
	.word	-1593326904
	.word	1096
	.word	-1996226488
	.word	104
	.word	218151120
	.word	1528
	.word	-1090071768
	.word	1840
	.word	-436105544
	.word	528
	.word	1107702816
	.word	832
	.word	1745208960
	.word	520
	.word	1090919440
	.word	1224
	.word	-1727692472
	.word	360
	.word	755219152
	.word	120
	.word	251693296
	.word	1408
	.word	-1341760552
	.word	672
	.word	1409803584
	.word	1496
	.word	-1157188760
	.word	176
	.word	369217888
	.type	Te3,#object
	.size	Te3,2048
	.align	4
!
! CONSTANT POOL
!
Te4:
	.word	1667457891
	.word	2088533116
	.word	2004318071
	.word	2071690107
	.word	-218959118
	.word	1802201963
	.word	1869573999
	.word	-976894523
	.word	808464432
	.word	16843009
	.word	1734829927
	.word	724249387
	.word	-16843010
	.word	-673720361
	.word	-1414812757
	.word	1987475062
	.word	-892679478
	.word	-2105376126
	.word	-909522487
	.word	2105376125
	.word	-84215046
	.word	1499027801
	.word	1195853639
	.word	-252645136
	.word	-1381126739
	.word	-724249388
	.word	-1566399838
	.word	-1347440721
	.word	-1667457892
	.word	-1532713820
	.word	1920103026
	.word	-1061109568
	.word	-1212696649
	.word	-33686019
	.word	-1819044973
	.word	640034342
	.word	909522486
	.word	1061109567
	.word	-134744073
	.word	-858993460
	.word	875836468
	.word	-1515870811
	.word	-437918235
	.word	-235802127
	.word	1903260017
	.word	-656877352
	.word	825307441
	.word	353703189
	.word	67372036
	.word	-943208505
	.word	589505315
	.word	-1010580541
	.word	404232216
	.word	-1768515946
	.word	84215045
	.word	-1701143910
	.word	117901063
	.word	303174162
	.word	-2139062144
	.word	-488447262
	.word	-336860181
	.word	656877351
	.word	-1296911694
	.word	1970632053
	.word	151587081
	.word	-2088533117
	.word	741092396
	.word	437918234
	.word	454761243
	.word	1852730990
	.word	1515870810
	.word	-1600085856
	.word	1381126738
	.word	993737531
	.word	-690563370
	.word	-1280068685
	.word	690563369
	.word	-471604253
	.word	791621423
	.word	-2071690108
	.word	1397969747
	.word	-774778415
	.word	0
	.word	-303174163
	.word	538976288
	.word	-50529028
	.word	-1313754703
	.word	1532713819
	.word	1785358954
	.word	-875836469
	.word	-1094795586
	.word	960051513
	.word	1246382666
	.word	1280068684
	.word	1482184792
	.word	-808464433
	.word	-791621424
	.word	-269488145
	.word	-1431655766
	.word	-67372037
	.word	1128481603
	.word	1296911693
	.word	858993459
	.word	-2054847099
	.word	1162167621
	.word	-101058055
	.word	33686018
	.word	2139062143
	.word	1347440720
	.word	1010580540
	.word	-1616928865
	.word	-1465341784
	.word	1364283729
	.word	-1549556829
	.word	1077952576
	.word	-1886417009
	.word	-1835887982
	.word	-1650614883
	.word	943208504
	.word	-168430091
	.word	-1128481604
	.word	-1229539658
	.word	-623191334
	.word	555819297
	.word	269488144
	.word	-1
	.word	-202116109
	.word	-757935406
	.word	-842150451
	.word	202116108
	.word	320017171
	.word	-320017172
	.word	1600085855
	.word	-1751672937
	.word	1145324612
	.word	387389207
	.word	-993737532
	.word	-1482184793
	.word	2122219134
	.word	1027423549
	.word	1684300900
	.word	1566399837
	.word	421075225
	.word	1936946035
	.word	1616928864
	.word	-2122219135
	.word	1330597711
	.word	-589505316
	.word	572662306
	.word	707406378
	.word	-1869574000
	.word	-2004318072
	.word	1179010630
	.word	-286331154
	.word	-1195853640
	.word	336860180
	.word	-555819298
	.word	1583242846
	.word	185273099
	.word	-606348325
	.word	-522133280
	.word	842150450
	.word	976894522
	.word	168430090
	.word	1229539657
	.word	101058054
	.word	606348324
	.word	1549556828
	.word	-1027423550
	.word	-741092397
	.word	-1397969748
	.word	1650614882
	.word	-1852730991
	.word	-1785358955
	.word	-454761244
	.word	2038004089
	.word	-404232217
	.word	-926365496
	.word	926365495
	.word	1835887981
	.word	-1920103027
	.word	-707406379
	.word	1313754702
	.word	-1448498775
	.word	1819044972
	.word	1448498774
	.word	-185273100
	.word	-353703190
	.word	1701143909
	.word	2054847098
	.word	-1364283730
	.word	134744072
	.word	-1162167622
	.word	2021161080
	.word	623191333
	.word	774778414
	.word	471604252
	.word	-1499027802
	.word	-1263225676
	.word	-960051514
	.word	-387389208
	.word	-572662307
	.word	1953789044
	.word	522133279
	.word	1263225675
	.word	-1111638595
	.word	-1953789045
	.word	-1970632054
	.word	1886417008
	.word	1044266558
	.word	-1246382667
	.word	1717986918
	.word	1212696648
	.word	50529027
	.word	-151587082
	.word	235802126
	.word	1633771873
	.word	892679477
	.word	1465341783
	.word	-1179010631
	.word	-2038004090
	.word	-1044266559
	.word	488447261
	.word	-1633771874
	.word	-505290271
	.word	-117901064
	.word	-1734829928
	.word	286331153
	.word	1768515945
	.word	-640034343
	.word	-1903260018
	.word	-1802201964
	.word	-1684300901
	.word	505290270
	.word	-2021161081
	.word	-370546199
	.word	-825307442
	.word	1431655765
	.word	673720360
	.word	-538976289
	.word	-1936946036
	.word	-1583242847
	.word	-1987475063
	.word	218959117
	.word	-1077952577
	.word	-421075226
	.word	1111638594
	.word	1751672936
	.word	1094795585
	.word	-1717986919
	.word	757935405
	.word	252645135
	.word	-1330597712
	.word	1414812756
	.word	-1145324613
	.word	370546198
	.type	Te4,#object
	.size	Te4,1024
	.align	8


	.section	".data",#alloc,#write
	.align	8
aes_const:

#ifdef __sparcv9
!
! for v8plus, the addresses are 64-bit long so we should use .xword
! instead of .word
!
!
	.xword	(Te0+0x0)
	.xword	(Te1+0x0)
	.xword	(Te2+0x0)
	.xword	(Te3+0x0)
	.xword	(Te4+0x0)
	.xword	(Td0+0x0)
	.xword	(Td1+0x0)
	.xword	(Td2+0x0)
	.xword	(Td3+0x0)
	.xword	(Td4+0x0)

#else /* __sparcv9 */

!
! for v8plus, the addresses are 32-bit long, we use filler 0's so that
! we can use ldx to load the addresses just like in the v9 version
!
	.word	0
	.word	(Te0+0x0)
	.word	0
	.word	(Te1+0x0)
	.word	0
	.word	(Te2+0x0)
	.word	0
	.word	(Te3+0x0)
	.word	0
	.word	(Te4+0x0)
	.word	0
	.word	(Td0+0x0)
	.word	0
	.word	(Td1+0x0)
	.word	0
	.word	(Td2+0x0)
	.word	0
	.word	(Td3+0x0)
	.word	0
	.word	(Td4+0x0)

#endif /* __sparcv9 */

	.type	aes_const,#object
	.size	aes_const,40

	.section	".text",#alloc,#execinstr
!
! SUBROUTINE aes_encrypt_impl
!
! void aes_encrypt_impl(const uint32_t rk[], int Nr, const uint32_t pt[4],
!    uint32_t ct[4]);
!
! OFFSET    SOURCE LINE	LABEL	INSTRUCTION

        .global aes_encrypt_impl
	aes_encrypt_impl:

#ifdef __sparcv9

	save	%sp, -SA(MINFRAME), %sp

#ifdef PIC
	sethi	%hi(aes_const), %l0
.L1:
	call	.+8

	sethi	%hi(_GLOBAL_OFFSET_TABLE_-(.L1-.)), %l1
	or	%l0, %lo(aes_const), %l0
	ld	[%i2], %g1

	or	%l1, %lo(_GLOBAL_OFFSET_TABLE_-(.L1-.)), %l1
	sethi	%hi(0xff000000), %i5

	add	%l1, %o7, %l1
	sethi	%hi(0x7fff8), %l6

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
	ldx	[%l1+%l0], %l7
#else /* PIC */
	sethi	%hh(aes_const), %l0
	sethi	%lm(aes_const), %l7

	or	%l0, %hm(aes_const), %l0
	or	%l7, %lo(aes_const), %l7

	sllx	%l0, 32, %l0
	sethi	%hi(0xff000000), %i5
	ld	[%i2], %g1

	sethi	%hi(0x7fff8), %l6
	or	%l0, %l7, %l7

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
#endif /* PIC */

#else /* __sparcv9 */

	save	%sp, -SA(MINFRAME), %sp
	sethi	%hi(aes_const), %l0

#ifdef PIC
.L1:
	call	.+8

	sethi	%hi(_GLOBAL_OFFSET_TABLE_-(.L1-.)), %l1
	or	%l0, %lo(aes_const), %l0
	ld	[%i2], %g1

	or	%l1, %lo(_GLOBAL_OFFSET_TABLE_-(.L1-.)), %l1
	sethi	%hi(0xff000000), %i5

	add	%l1, %o7, %l1
	sethi	%hi(0x7fff8), %l6

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
	ld	[%l1+%l0], %l7
#else /* PIC */
	or	%l0, %lo(aes_const), %l7
	sethi	%hi(0xff000000), %i5
	ld	[%i2], %g1

	sethi	%hi(0x7fff8), %l6

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
#endif /* PIC */

#endif /* __sparcv9 */

	sll	%g1, 3, %g1
	and	%o5, %i5, %o5
	ld	[%i2 + 4], %g2

	sllx	%o0, 11, %o0
	and	%g1, %l6, %g1

	or	%o0, %o5, %o5
	ldx	[%i0], %o1
	and	%g2, %i5, %o0

	sll	%g2, 8, %g5
	or	%o5, %g1, %g1
	ldx	[%l7], %l0

	sll	%g2, 3, %g2
	xor	%g1, %o1, %o1
	ldx	[%l7 + 8], %l1

	sllx	%o0, 11, %o0
	and	%g5, %i5, %o5
	ld	[%i2 + 8], %g3

	or	%o0, %o5, %o5
	and	%g2, %l6, %g2
	ldx	[%i0 + 8], %o2

	or	%o5, %g2, %g2
	and	%g3, %i5, %o5
	ldx	[%l7 + 16], %l2

	sll	%g3, 8, %o0
	xor	%g2, %o2, %o2
	ldx	[%l7 + 24], %l3

	sllx	%o5, 11, %o5
	and	%o0, %i5, %o0
	ld	[%i2 + 12], %g4

	sll	%g3, 3, %g1
	or	%o5, %o0, %o0
	ldx	[%l7 + 32], %i4

	and	%g1, %l6, %g1
	and	%g4, %i5, %o5
	ldx	[%i0 + 16], %o3

	sll	%g4, 8, %g3
	or	%o0, %g1, %g1

	sll	%g4, 3, %g5
	xor	%g1, %o3, %o3

	sllx	%o5, 11, %g4
	and	%g3, %i5, %o0
	ldx	[%i0 + 24], %o5

	srlx	%o1, 32, %l4
	or	%g4, %o0, %o0

	srl	%o2, 21, %l5
	and	%g5, %l6, %g5

.L2:
	srl	%o3, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o4
	ldx	[%l1 + %l5], %o5

	and	%o4, 0x7f8, %l7
	add	%i0, 32, %i0
	ldx	[%l2 + %l6], %g5

	srlx	%o2, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o3, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0], %o5

	srl	%o4, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g1
	ldx	[%l1 + %l5], %o5

	and	%o1, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o3, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o4, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 8], %o5

	srl	%o1, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g2
	ldx	[%l1 + %l5], %o5

	and	%o2, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o4, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o1, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 16], %o5

	srl	%o2, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g3
	ldx	[%l1 + %l5], %o5

	and	%o3, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5
	sub	%i1, 2, %i1

	srlx	%g1, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g2, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 24], %o5

.L3:
	srl	%g3, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g4
	ldx	[%l1 + %l5], %o5

	and	%g4, 0x7f8, %l7
	add	%i0, 32, %i0
	ldx	[%l2 + %l6], %g5

	srlx	%g2, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g3, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0], %o5

	srl	%g4, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o1
	ldx	[%l1 + %l5], %o5

	and	%g1, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%g3, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g4, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 8], %o5

	srl	%g1, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o2
	ldx	[%l1 + %l5], %o5

	and	%g2, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%g4, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g1, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 16], %o5

	srl	%g2, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o3
	ldx	[%l1 + %l5], %o5

	and	%g3, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o1, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o2, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 24], %o5


	srl	%o3, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o4
	ldx	[%l1 + %l5], %o5

	and	%o4, 0x7f8, %l7
	add	%i0, 32, %i0
	ldx	[%l2 + %l6], %g5

	srlx	%o2, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o3, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0], %o5

	srl	%o4, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g1
	ldx	[%l1 + %l5], %o5

	and	%o1, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o3, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o4, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 8], %o5

	srl	%o1, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g2
	ldx	[%l1 + %l5], %o5

	and	%o2, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o4, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o1, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 16], %o5

	srl	%o2, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g3
	ldx	[%l1 + %l5], %o5

	and	%o3, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5
	subcc	%i1, 2, %i1

	srlx	%g1, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g2, 21, %l5
	xor	%o5, %g5, %g5
	bnz,pt	%icc, .L3
	ldx	[%i0 + 24], %o5


.L4:
	srl	%l4, 1, %l4	!***** should be removed after
	srl	%l5, 1, %l5	!***** unrolling the loop and correcting
	add	%i0, 32, %i0	!***** the last iteration

	srl	%i5, 8, %i1
	xor	%g5, %o0, %g5
	ld	[%i4 + %l4], %o1

	srl	%g3, 9, %l6
	xor	%g5, %o5, %g4
	ld	[%i4 + %l5], %o2

	srl	%g4, 1, %l7
	and	%l6, 0x3fc, %l6

	srl	%i1, 8, %l0
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %o3

	and	%o1, %i5, %o1
	and	%o2, %i1, %o2
	ld	[%i4 + %l7], %o4

	srlx	%g2, 33, %l4
	xor	%o1, %o2, %o2
	ld	[%i0], %o5

	srl	%g3, 22, %l5
	and	%o3, %l0, %o3
	ld	[%i4 + %l4], %l1

	xor	%o2, %o3, %o3
	and	%o4, 0xff, %o4

	srl	%g4, 9, %l6
	xor	%o3, %o4, %o4
	ld	[%i4 + %l5], %l2

	srl	%g1, 1, %l7
	and	%l6, 0x3fc, %l6

	xor	%o4, %o5, %o5
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %l3

	and	%l1, %i5, %l1
	and	%l2, %i1, %l2
	st	%o5, [%i3]

	srlx	%g3, 33, %l6
	xor	%l1, %l2, %l2
	ld	[%i4 + %l7], %l4

	srl	%g4, 22, %l5
	and	%l3, %l0, %l3
	ld	[%i0 + 4], %g5

	xor	%l2, %l3, %l3
	and	%l4, 0xff, %l4
	ld	[%i4 + %l6], %o1

	srl	%g1, 9, %l6
	xor	%l3, %l4, %l4
	ld	[%i4 + %l5], %o2

	srl	%g2, 1, %l7
	and	%l6, 0x3fc, %l6

	xor	%l4, %g5, %g5
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %o3

	and	%o1, %i5, %o1
	and	%o2, %i1, %o2
	st	%g5, [%i3 + 4]

	srlx	%g4, 33, %l4
	xor	%o1, %o2, %o2
	ld	[%i4 + %l7], %o4

	srl	%g1, 22, %l5
	and	%o3, %l0, %o3
	ld	[%i0 + 8], %o5

	xor	%o2, %o3, %o3
	and	%o4, 0xff, %o4
	ld	[%i4 + %l4], %l1

	srl	%g2, 9, %l6
	xor	%o3, %o4, %o4
	ld	[%i4 + %l5], %l2

	srl	%g3, 1, %l7
	and	%l6, 0x3fc, %l6

	xor	%o4, %o5, %o5
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %l3

	and	%l1, %i5, %l1
	and	%l2, %i1, %l2
	ld	[%i4 + %l7], %l4

	xor	%l1, %l2, %l2
	and	%l3, %l0, %l3
	ld	[%i0 + 12], %l5

	xor	%l2, %l3, %l3
	and	%l4, 0xff, %l4
	st	%o5, [%i3 + 8]

	xor	%l3, %l4, %l4

	xor	%l4, %l5, %l5
	st	%l5, [%i3 + 12]

	ret
	restore	%g0,%g0,%g0

	.type	aes_encrypt_impl,2
	.size	aes_encrypt_impl,(.-aes_encrypt_impl)


	.section	".text",#alloc,#execinstr
	.align	8192
!
! SUBROUTINE aes_decrypt_impl
!
! void aes_decrypt_impl(const uint32_t rk[], int Nr, const uint32_t ct[4],
!    uint32_t pt[4]);
!
! OFFSET    SOURCE LINE	LABEL	INSTRUCTION

        .global aes_decrypt_impl
        aes_decrypt_impl:

#ifdef __sparcv9

	save	%sp, -SA(MINFRAME), %sp

#ifdef PIC
	sethi	%hi(aes_const), %l0
.L1d:
	call	.+8

	sethi	%hi(_GLOBAL_OFFSET_TABLE_-(.L1d-.)), %l1
	or	%l0, %lo(aes_const), %l0
	ld	[%i2 + 12], %g1

	or	%l1, %lo(_GLOBAL_OFFSET_TABLE_-(.L1d-.)), %l1
	sethi	%hi(0xff000000), %i5

	add	%l1, %o7, %l1
	sethi	%hi(0x7fff8), %l6

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
	ldx	[%l1+%l0], %l7
#else /* PIC */
	sethi	%hh(aes_const), %l0
	sethi	%lm(aes_const), %l7

	or	%l0, %hm(aes_const), %l0
	or	%l7, %lo(aes_const), %l7

	sllx	%l0, 32, %l0
	sethi	%hi(0xff000000), %i5
	ld	[%i2 + 12], %g1

	sethi	%hi(0x7fff8), %l6
	or	%l0, %l7, %l7

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
#endif /* PIC */

#else /* __sparcv9 */

	save	%sp, -SA(MINFRAME), %sp
	sethi	%hi(aes_const), %l0

#ifdef PIC
.L1d:
	call	.+8

	sethi	%hi(_GLOBAL_OFFSET_TABLE_-(.L1d-.)), %l1
	or	%l0, %lo(aes_const), %l0
	ld	[%i2 + 12], %g1

	or	%l1, %lo(_GLOBAL_OFFSET_TABLE_-(.L1d-.)), %l1
	sethi	%hi(0xff000000), %i5

	add	%l1, %o7, %l1
	sethi	%hi(0x7fff8), %l6

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
	ld	[%l1+%l0], %l7
#else /* PIC */
	or	%l0, %lo(aes_const), %l7
	sethi	%hi(0xff000000), %i5
	ld	[%i2 + 12], %g1

	sethi	%hi(0x7fff8), %l6

	and	%g1, %i5, %o0
	or	%l6, %lo(0x7ff8), %l6

	sll	%g1, 8, %o5
#endif /* PIC */

#endif /* __sparcv9 */

	sll	%g1, 3, %g1
	and	%o5, %i5, %o5
	ld	[%i2 + 8], %g2

	sllx	%o0, 11, %o0
	and	%g1, %l6, %g1

	or	%o0, %o5, %o5
	ldx	[%i0], %o1
	and	%g2, %i5, %o0

	sll	%g2, 8, %g5
	or	%o5, %g1, %g1
	ldx	[%l7 + 40], %l0

	sll	%g2, 3, %g2
	xor	%g1, %o1, %o1
	ldx	[%l7 + 48], %l1

	sllx	%o0, 11, %o0
	and	%g5, %i5, %o5
	ld	[%i2 + 4], %g3

	or	%o0, %o5, %o5
	and	%g2, %l6, %g2
	ldx	[%i0 + 8], %o2

	or	%o5, %g2, %g2
	and	%g3, %i5, %o5
	ldx	[%l7 + 56], %l2

	sll	%g3, 8, %o0
	xor	%g2, %o2, %o2
	ldx	[%l7 + 64], %l3

	sllx	%o5, 11, %o5
	and	%o0, %i5, %o0
	ld	[%i2], %g4

	sll	%g3, 3, %g1
	or	%o5, %o0, %o0
	ldx	[%l7 + 72], %i4

	and	%g1, %l6, %g1
	and	%g4, %i5, %o5
	ldx	[%i0 + 16], %o3

	sll	%g4, 8, %g3
	or	%o0, %g1, %g1

	sll	%g4, 3, %g5
	xor	%g1, %o3, %o3

	sllx	%o5, 11, %g4
	and	%g3, %i5, %o0
	ldx	[%i0 + 24], %o5

	srlx	%o1, 32, %l4
	or	%g4, %o0, %o0

	srl	%o2, 21, %l5
	and	%g5, %l6, %g5

.L2d:
	srl	%o3, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o4
	ldx	[%l1 + %l5], %o5

	and	%o4, 0x7f8, %l7
	add	%i0, 32, %i0
	ldx	[%l2 + %l6], %g5

	srlx	%o2, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o3, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0], %o5

	srl	%o4, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g1
	ldx	[%l1 + %l5], %o5

	and	%o1, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o3, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o4, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 8], %o5

	srl	%o1, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g2
	ldx	[%l1 + %l5], %o5

	and	%o2, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o4, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o1, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 16], %o5

	srl	%o2, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g3
	ldx	[%l1 + %l5], %o5

	and	%o3, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5
	sub	%i1, 2, %i1

	srlx	%g1, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g2, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 24], %o5

.L3d:
	srl	%g3, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g4
	ldx	[%l1 + %l5], %o5

	and	%g4, 0x7f8, %l7
	add	%i0, 32, %i0
	ldx	[%l2 + %l6], %g5

	srlx	%g2, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g3, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0], %o5

	srl	%g4, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o1
	ldx	[%l1 + %l5], %o5

	and	%g1, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%g3, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g4, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 8], %o5

	srl	%g1, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o2
	ldx	[%l1 + %l5], %o5

	and	%g2, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%g4, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g1, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 16], %o5

	srl	%g2, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o3
	ldx	[%l1 + %l5], %o5

	and	%g3, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o1, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o2, 21, %l5
	xor	%o5, %g5,%g5
	ldx	[%i0 + 24], %o5


	srl	%o3, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %o4
	ldx	[%l1 + %l5], %o5

	and	%o4, 0x7f8, %l7
	add	%i0, 32, %i0
	ldx	[%l2 + %l6], %g5

	srlx	%o2, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o3, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0], %o5

	srl	%o4, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g1
	ldx	[%l1 + %l5], %o5

	and	%o1, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o3, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o4, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 8], %o5

	srl	%o1, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g2
	ldx	[%l1 + %l5], %o5

	and	%o2, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5

	srlx	%o4, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%o1, 21, %l5
	xor	%o5, %g5, %g5
	ldx	[%i0 + 16], %o5

	srl	%o2, 8, %l6
	xor	%g5, %o0, %g5
	ldx	[%l0 + %l4], %o0

	and	%l6, 0x7f8, %l6
	xor	%g5, %o5, %g3
	ldx	[%l1 + %l5], %o5

	and	%o3, 0x7f8, %l7
	ldx	[%l2 + %l6], %g5
	subcc	%i1, 2, %i1

	srlx	%g1, 32, %l4
	xor	%o0, %o5, %o5
	ldx	[%l3 + %l7], %o0

	srl	%g2, 21, %l5
	xor	%o5, %g5, %g5
	bnz,pt	%icc, .L3d
	ldx	[%i0 + 24], %o5


.L4d:
	srl	%l4, 1, %l4	!***** should be removed after
	srl	%l5, 1, %l5	!***** unrolling the loop and correcting
	add	%i0, 32, %i0	!***** the last iteration

	srl	%i5, 8, %i1
	xor	%g5, %o0, %g5
	ld	[%i4 + %l4], %o1

	srl	%g3, 9, %l6
	xor	%g5, %o5, %g4
	ld	[%i4 + %l5], %o2

	srl	%g4, 1, %l7
	and	%l6, 0x3fc, %l6

	srl	%i1, 8, %l0
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %o3

	and	%o1, %i5, %o1
	and	%o2, %i1, %o2
	ld	[%i4 + %l7], %o4

	srlx	%g2, 33, %l4
	xor	%o1, %o2, %o2
	ld	[%i0], %o5

	srl	%g3, 22, %l5
	and	%o3, %l0, %o3
	ld	[%i4 + %l4], %l1

	xor	%o2, %o3, %o3
	and	%o4, 0xff, %o4

	srl	%g4, 9, %l6
	xor	%o3, %o4, %o4
	ld	[%i4 + %l5], %l2

	srl	%g1, 1, %l7
	and	%l6, 0x3fc, %l6

	xor	%o4, %o5, %o5
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %l3

	and	%l1, %i5, %l1
	and	%l2, %i1, %l2
	st	%o5, [%i3 + 12]

	srlx	%g3, 33, %l6
	xor	%l1, %l2, %l2
	ld	[%i4 + %l7], %l4

	srl	%g4, 22, %l5
	and	%l3, %l0, %l3
	ld	[%i0 + 4], %g5

	xor	%l2, %l3, %l3
	and	%l4, 0xff, %l4
	ld	[%i4 + %l6], %o1

	srl	%g1, 9, %l6
	xor	%l3, %l4, %l4
	ld	[%i4 + %l5], %o2

	srl	%g2, 1, %l7
	and	%l6, 0x3fc, %l6

	xor	%l4, %g5, %g5
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %o3

	and	%o1, %i5, %o1
	and	%o2, %i1, %o2
	st	%g5, [%i3 + 8]

	srlx	%g4, 33, %l4
	xor	%o1, %o2, %o2
	ld	[%i4 + %l7], %o4

	srl	%g1, 22, %l5
	and	%o3, %l0, %o3
	ld	[%i0 + 8], %o5

	xor	%o2, %o3, %o3
	and	%o4, 0xff, %o4
	ld	[%i4 + %l4], %l1

	srl	%g2, 9, %l6
	xor	%o3, %o4, %o4
	ld	[%i4 + %l5], %l2

	srl	%g3, 1, %l7
	and	%l6, 0x3fc, %l6

	xor	%o4, %o5, %o5
	and	%l7, 0x3fc, %l7
	ld	[%i4 + %l6], %l3

	and	%l1, %i5, %l1
	and	%l2, %i1, %l2
	ld	[%i4 + %l7], %l4

	xor	%l1, %l2, %l2
	and	%l3, %l0, %l3
	ld	[%i0 + 12], %l5

	xor	%l2, %l3, %l3
	and	%l4, 0xff, %l4
	st	%o5, [%i3 + 4]

	xor	%l3, %l4, %l4

	xor	%l4, %l5, %l5
	st	%l5, [%i3]

	ret
	restore	%g0,%g0,%g0

	.type	aes_decrypt_impl,2
	.size	aes_decrypt_impl,(.-aes_decrypt_impl)


	.section	".text",#alloc
	.align	8
!
! CONSTANT POOL
!
Td0:
	.word	648
	.word	-200983936
	.word	1008
	.word	1090726552
	.word	208
	.word	386213400
	.word	464
	.word	654505136
	.word	472
	.word	-1425842600
	.word	248
	.word	-1660801144
	.word	1376
	.word	-100481704
	.word	600
	.word	-486531944
	.word	256
	.word	805819048
	.word	1384
	.word	1979936688
	.word	1088
	.word	-872172408
	.word	1960
	.word	33710376
	.word	632
	.word	-452542496
	.word	1576
	.word	705060536
	.word	304
	.word	889332736
	.word	1448
	.word	1644502136
	.word	1776
	.word	-1325215160
	.word	296
	.word	-1174349000
	.word	552
	.word	-369068864
	.word	744
	.word	-33159416
	.word	1560
	.word	788768784
	.word	1032
	.word	1275560080
	.word	1128
	.word	1174715672
	.word	856
	.word	-754463184
	.word	24
	.word	-1895629000
	.word	168
	.word	-1845173080
	.word	1528
	.word	1828968280
	.word	1192
	.word	1375915728
	.word	1696
	.word	-1107027608
	.word	704
	.word	1946226328
	.word	584
	.word	-536655544
	.word	1136
	.word	-922336736
	.word	936
	.word	-1039905968
	.word	1952
	.word	-1912353856
	.word	1224
	.word	1476522840
	.word	312
	.word	-1190949144
	.word	1520
	.word	-519930448
	.word	1920
	.word	-2012911432
	.word	1608
	.word	537223984
	.word	1000
	.word	-838740576
	.word	792
	.word	-553496384
	.word	1832
	.word	436309008
	.word	1208
	.word	1359059712
	.word	784
	.word	1392769576
	.word	1416
	.word	1677967104
	.word	1496
	.word	1795519520
	.word	2032
	.word	-2130378528
	.word	1992
	.word	134306976
	.word	896
	.word	1208173248
	.word	1144
	.word	1158146248
	.word	1184
	.word	-570203080
	.word	656
	.word	2064106936
	.word	1368
	.word	1929812248
	.word	912
	.word	1258297104
	.word	1816
	.word	520387256
	.word	816
	.word	1426413904
	.word	1424
	.word	-352239560
	.word	376
	.word	-1257893864
	.word	1072
	.word	-989602608
	.word	1688
	.word	922764584
	.word	384
	.word	671367056
	.word	280
	.word	-1090179696
	.word	16
	.word	50550224
	.word	1896
	.word	369365728
	.word	1104
	.word	-822025896
	.word	1336
	.word	2030412944
	.word	1944
	.word	117938048
	.word	624
	.word	1762071816
	.word	808
	.word	-637032856
	.word	48
	.word	84276904
	.word	1672
	.word	872616184
	.word	1568
	.word	-1509428144
	.word	416
	.word	771923176
	.word	1296
	.word	-217928448
	.word	40
	.word	-1979250288
	.word	1312
	.word	-167289944
	.word	88
	.word	-2096668216
	.word	512
	.word	1611103568
	.word	752
	.word	1896151088
	.word	1512
	.word	1845527176
	.word	496
	.word	553932744
	.word	1200
	.word	-587189784
	.word	1768
	.word	1040199024
	.word	616
	.word	-435819984
	.word	1160
	.word	1409576360
	.word	904
	.word	-1006442456
	.word	32
	.word	101098360
	.word	768
	.word	1342222328
	.word	200
	.word	-1744316128
	.word	1712
	.word	-1123595080
	.word	1096
	.word	1073880672
	.word	824
	.word	-653986888
	.word	1408
	.word	-402516504
	.word	56
	.word	-1996202944
	.word	1848
	.word	419617216
	.word	968
	.word	-939034920
	.word	1288
	.word	2080395832
	.word	992
	.word	1107328840
	.word	1984
	.word	-2080311736
	.word	0
	.word	0
	.word	72
	.word	-2147208168
	.word	400
	.word	721906240
	.word	240
	.word	285443424
	.word	864
	.word	1510183536
	.word	2024
	.word	235405272
	.word	120
	.word	-2063482192
	.word	488
	.word	-1375295248
	.word	432
	.word	755091768
	.word	80
	.word	252103456
	.word	832
	.word	1543844104
	.word	1240
	.word	1526900360
	.word	288
	.word	906064336
	.word	96
	.word	167984520
	.word	1176
	.word	1460091000
	.word	1440
	.word	-301681008
	.word	216
	.word	-1694200592
	.word	1024
	.word	-1073337736
	.word	776
	.word	-603912944
	.word	720
	.word	1996643144
	.word	224
	.word	302043312
	.word	1808
	.word	-1828335536
	.word	1536
	.word	-1610524888
	.word	480
	.word	570884632
	.word	144
	.word	453032168
	.word	112
	.word	151021656
	.word	1936
	.word	-1962525336
	.word	360
	.word	-1241168440
	.word	160
	.word	503664192
	.word	696
	.word	-251605976
	.word	1400
	.word	1962949216
	.word	1904
	.word	-1727599144
	.word	1304
	.word	2130905064
	.word	1976
	.word	16856312
	.word	736
	.word	1913105888
	.word	544
	.word	1711398440
	.word	728
	.word	-83627616
	.word	1112
	.word	1124158384
	.word	1624
	.word	587609824
	.word	1456
	.word	-318250176
	.word	1472
	.word	-469267688
	.word	1720
	.word	822535760
	.word	528
	.word	1661216896
	.word	152
	.word	-1761537536
	.word	1056
	.word	-973043456
	.word	1064
	.word	1241588712
	.word	1680
	.word	-1157500992
	.word	1392
	.word	-117337976
	.word	1592
	.word	688196456
	.word	232
	.word	-1644070312
	.word	1760
	.word	-1308522600
	.word	104
	.word	-2046650528
	.word	952
	.word	-1056498048
	.word	344
	.word	-1291799712
	.word	1352
	.word	1879428296
	.word	136
	.word	-1811789872
	.word	568
	.word	-385670896
	.word	1344
	.word	-66820576
	.word	1280
	.word	-268306224
	.word	688
	.word	2097243840
	.word	272
	.word	855934840
	.word	1080
	.word	1224898104
	.word	1736
	.word	939953672
	.word	1120
	.word	-905635856
	.word	1216
	.word	-738174544
	.word	1328
	.word	-184283528
	.word	1320
	.word	2047275328
	.word	1744
	.word	-1224445648
	.word	504
	.word	-1392116448
	.word	352
	.word	973401888
	.word	640
	.word	2013565032
	.word	848
	.word	1594254552
	.word	672
	.word	2114073360
	.word	1968
	.word	-1929339376
	.word	1152
	.word	-670709952
	.word	368
	.word	956807920
	.word	1040
	.word	-1023049816
	.word	1272
	.word	1560544752
	.word	840
	.word	-805004320
	.word	888
	.word	-721326776
	.word	1656
	.word	620795288
	.word	1600
	.word	-1408972328
	.word	128
	.word	402910520
	.word	1856
	.word	-1677517968
	.word	1752
	.word	990239704
	.word	1640
	.word	637780040
	.word	880
	.word	1493223328
	.word	1888
	.word	-1710901240
	.word	1048
	.word	1325716800
	.word	1840
	.word	-1794936024
	.word	1360
	.word	-16305168
	.word	264
	.word	-1140426688
	.word	1912
	.word	352798512
	.word	1488
	.word	-419111224
	.word	592
	.word	1862383216
	.word	1872
	.word	-1627369824
	.word	328
	.word	-1341921616
	.word	392
	.word	-1543137928
	.word	336
	.word	1057036680
	.word	1584
	.word	-1526423168
	.word	424
	.word	-1576847872
	.word	928
	.word	1309008312
	.word	2016
	.word	-2113514192
	.word	1792
	.word	-1878620800
	.word	408
	.word	-1492729688
	.word	1928
	.word	67420752
	.word	520
	.word	-335095880
	.word	1016
	.word	-855474064
	.word	184
	.word	-1861766792
	.word	944
	.word	1292285032
	.word	536
	.word	-284851608
	.word	1632
	.word	-1442682208
	.word	1824
	.word	-1778374920
	.word	1264
	.word	-788156648
	.word	608
	.word	1778663640
	.word	1544
	.word	738262464
	.word	560
	.word	1694665720
	.word	1256
	.word	1577537568
	.word	8
	.word	-1946047768
	.word	2000
	.word	-2029804648
	.word	2008
	.word	184682864
	.word	1432
	.word	1728113360
	.word	1168
	.word	-620326256
	.word	1864
	.word	268611992
	.word	872
	.word	-704497512
	.word	1232
	.word	-687666080
	.word	440
	.word	-1593809968
	.word	712
	.word	-134175632
	.word	1880
	.word	318891080
	.word	1648
	.word	-1459536016
	.word	1464
	.word	1627802024
	.word	1800
	.word	470232936
	.word	976
	.word	1191545312
	.word	1248
	.word	-771294520
	.word	680
	.word	-234645000
	.word	192
	.word	335967176
	.word	920
	.word	-956187144
	.word	664
	.word	-150573232
	.word	760
	.word	-49982760
	.word	1784
	.word	1023637664
	.word	960
	.word	1141300272
	.word	1616
	.word	-1358455800
	.word	1480
	.word	1745232368
	.word	448
	.word	604086624
	.word	1552
	.word	-1560149256
	.word	176
	.word	486939536
	.word	1504
	.word	-503240608
	.word	320
	.word	1006783576
	.word	2040
	.word	218409480
	.word	456
	.word	-1476392056
	.word	64
	.word	201694960
	.word	1728
	.word	-1274600224
	.word	800
	.word	1443236992
	.word	984
	.word	-888921336
	.word	1704
	.word	839234432
	.word	576
	.word	1812128672
	.word	1664
	.word	-1207780848
	.type	Td0,#object
	.size	Td0,2048
!
! CONSTANT POOL
!
Td1:
	.word	640
	.word	1359455544
	.word	664
	.word	2114063144
	.word	1560
	.word	436256032
	.word	1200
	.word	973159152
	.word	1624
	.word	990206808
	.word	1928
	.word	520415784
	.word	1368
	.word	-1408773440
	.word	1176
	.word	1258756120
	.word	680
	.word	536971216
	.word	1968
	.word	-1392266392
	.word	1160
	.word	-2012847184
	.word	296
	.word	-184544672
	.word	2016
	.word	1325870776
	.word	1720
	.word	-989768104
	.word	1024
	.word	637643296
	.word	1144
	.word	-1258089192
	.word	584
	.word	-570062128
	.word	824
	.word	621138136
	.word	1216
	.word	1158107248
	.word	1800
	.word	1560802816
	.word	16
	.word	-1023312984
	.word	144
	.word	-2130548864
	.word	1304
	.word	-1929235272
	.word	1584
	.word	1795596232
	.word	1848
	.word	50625272
	.word	1192
	.word	352621792
	.word	1880
	.word	-1090294832
	.word	1744
	.word	-1794993464
	.word	360
	.word	-737807336
	.word	1688
	.word	1476632840
	.word	328
	.word	1225196360
	.word	544
	.word	-1912189376
	.word	848
	.word	1963332680
	.word	960
	.word	-201034808
	.word	856
	.word	-1727872528
	.word	1768
	.word	654691208
	.word	1456
	.word	-1106834824
	.word	184
	.word	-268155544
	.word	816
	.word	-922679968
	.word	1440
	.word	2097574352
	.word	192
	.word	1661401680
	.word	1040
	.word	-452931192
	.word	768
	.word	-1761441384
	.word	552
	.word	1644338168
	.word	1792
	.word	-1325194312
	.word	1056
	.word	-1157407376
	.word	224
	.word	-33288960
	.word	1184
	.word	-117423784
	.word	704
	.word	1879196480
	.word	200
	.word	-1895682072
	.word	1080
	.word	-1811483808
	.word	1464
	.word	1375985600
	.word	280
	.word	-1425826152
	.word	1808
	.word	1912756240
	.word	696
	.word	-486474632
	.word	336
	.word	1711451480
	.word	56
	.word	-1308141248
	.word	24
	.word	788901392
	.word	1232
	.word	-2046415912
	.word	1320
	.word	-754862016
	.word	1936
	.word	805389368
	.word	1424
	.word	587595048
	.word	1488
	.word	33561424
	.word	736
	.word	-318721008
	.word	344
	.word	-1979287328
	.word	1168
	.word	-1492922976
	.word	1920
	.word	-218087536
	.word	1288
	.word	1308839696
	.word	1640
	.word	1694947232
	.word	1704
	.word	100675056
	.word	248
	.word	-788421872
	.word	1104
	.word	-1006290960
	.word	1256
	.word	872510104
	.word	1280
	.word	-1576559960
	.word	400
	.word	84170504
	.word	936
	.word	-1542998184
	.word	456
	.word	184819552
	.word	1360
	.word	1073940344
	.word	48
	.word	1577291000
	.word	648
	.word	-1123848064
	.word	1992
	.word	1040256080
	.word	488
	.word	-1777932240
	.word	1392
	.word	-587075544
	.word	560
	.word	1292318184
	.word	1448
	.word	-1862097816
	.word	40
	.word	1896227560
	.word	888
	.word	67122848
	.word	2040
	.word	1610776744
	.word	288
	.word	419743704
	.word	1208
	.word	-704254136
	.word	1632
	.word	-1996357096
	.word	952
	.word	1728498928
	.word	1512
	.word	-1341701616
	.word	1088
	.word	117722200
	.word	448
	.word	-419378472
	.word	1752
	.word	2030454640
	.word	568
	.word	-1593581488
	.word	1864
	.word	2080510072
	.word	1608
	.word	-133947152
	.word	0
	.word	0
	.word	1048
	.word	151258160
	.word	576
	.word	838950760
	.word	1376
	.word	503352192
	.word	624
	.word	1812124560
	.word	2008
	.word	-50300936
	.word	688
	.word	251931072
	.word	240
	.word	1023768232
	.word	312
	.word	906062280
	.word	800
	.word	167804616
	.word	264
	.word	1745020208
	.word	1672
	.word	-1694311776
	.word	464
	.word	604090736
	.word	1416
	.word	201347896
	.word	120
	.word	-1828536520
	.word	1680
	.word	-1274579792
	.word	1264
	.word	453303432
	.word	632
	.word	-2147088856
	.word	1296
	.word	1627840768
	.word	840
	.word	1510193752
	.word	176
	.word	469799120
	.word	80
	.word	-503013936
	.word	1832
	.word	-1073413808
	.word	536
	.word	1006704384
	.word	232
	.word	302045368
	.word	88
	.word	234899560
	.word	1384
	.word	-234594760
	.word	1480
	.word	755348800
	.word	1600
	.word	335607112
	.word	1064
	.word	1460111560
	.word	608
	.word	-1358714824
	.word	1496
	.word	-301674776
	.word	2024
	.word	-1560020224
	.word	1272
	.word	-150992592
	.word	1504
	.word	1543739304
	.word	1576
	.word	1141060056
	.word	416
	.word	1527241712
	.word	944
	.word	-1962796728
	.word	1760
	.word	-889119184
	.word	832
	.word	-1241026592
	.word	792
	.word	-1207490680
	.word	1616
	.word	-687763744
	.word	128
	.word	1107500072
	.word	512
	.word	319076624
	.word	256
	.word	-2079969144
	.word	1000
	.word	-2063445728
	.word	1984
	.word	-771368472
	.word	136
	.word	-1375221360
	.word	872
	.word	-956216056
	.word	600
	.word	486863224
	.word	1944
	.word	-603614848
	.word	1888
	.word	218378896
	.word	1664
	.word	1996885784
	.word	864
	.word	721787056
	.word	1224
	.word	-1459386936
	.word	2000
	.word	285516352
	.word	272
	.word	1191660320
	.word	1568
	.word	-1475877792
	.word	208
	.word	-1610120712
	.word	1728
	.word	1443096928
	.word	1912
	.word	570530944
	.word	1592
	.word	-2029893008
	.word	1544
	.word	-654195064
	.word	2032
	.word	-1945742064
	.word	432
	.word	-1744396200
	.word	1656
	.word	-1509446648
	.word	320
	.word	-1526475024
	.word	304
	.word	-637158288
	.word	1312
	.word	1057320440
	.word	1824
	.word	738317544
	.word	104
	.word	1342424208
	.word	1240
	.word	1778581088
	.word	784
	.word	1409544752
	.word	1552
	.word	-167483240
	.word	1856
	.word	-1878604352
	.word	752
	.word	771870648
	.word	1960
	.word	-2113528456
	.word	1520
	.word	-1627198464
	.word	992
	.word	1762034840
	.word	1352
	.word	1862707560
	.word	1432
	.word	-822007664
	.word	472
	.word	-939170616
	.word	1336
	.word	268485608
	.word	880
	.word	-402332904
	.word	984
	.word	-620634664
	.word	72
	.word	-855559232
	.word	1952
	.word	1845676224
	.word	8
	.word	-335227464
	.word	1344
	.word	-2096988976
	.word	808
	.word	-435901584
	.word	1008
	.word	-1442316496
	.word	64
	.word	554034808
	.word	1840
	.word	-285167808
	.word	1736
	.word	-1173930792
	.word	1648
	.word	1241741744
	.word	1696
	.word	-368773048
	.word	1712
	.word	688227296
	.word	1400
	.word	822420880
	.word	392
	.word	704772376
	.word	384
	.word	-972739424
	.word	1536
	.word	889525040
	.word	440
	.word	1946318304
	.word	1328
	.word	-66841008
	.word	1408
	.word	-536574336
	.word	168
	.word	855981760
	.word	592
	.word	-251648832
	.word	1976
	.word	1091004112
	.word	112
	.word	2131126912
	.word	376
	.word	386174896
	.word	1128
	.word	1979870896
	.word	616
	.word	1124564352
	.word	672
	.word	-872066456
	.word	1784
	.word	-469454816
	.word	1816
	.word	-1643737688
	.word	216
	.word	1275286592
	.word	1472
	.word	-1056874248
	.word	1016
	.word	1174612616
	.word	32
	.word	-1660750000
	.word	744
	.word	17064360
	.word	920
	.word	-100385888
	.word	368
	.word	-83863032
	.word	720
	.word	-1291634456
	.word	656
	.word	-1845043568
	.word	408
	.word	-385842512
	.word	152
	.word	1829155384
	.word	1120
	.word	-1710834936
	.word	976
	.word	923076704
	.word	1136
	.word	1493680288
	.word	1096
	.word	-352282144
	.word	1904
	.word	-838514376
	.word	424
	.word	-1224536504
	.word	1896
	.word	-520034520
	.word	480
	.word	2046967176
	.word	712
	.word	-1677289736
	.word	504
	.word	1426559896
	.word	968
	.word	402695792
	.word	1528
	.word	1929787832
	.word	1872
	.word	1393016424
	.word	728
	.word	1594355024
	.word	160
	.word	-553522312
	.word	1072
	.word	2013406936
	.word	1032
	.word	-905609320
	.word	496
	.word	-1190967776
	.word	352
	.word	939598240
	.word	760
	.word	-1039853056
	.word	912
	.word	369159704
	.word	96
	.word	-1140387544
	.word	1112
	.word	671212104
	.word	520
	.word	-16749400
	.word	904
	.word	956645384
	.word	1776
	.word	134243736
	.word	1248
	.word	-670718176
	.word	1152
	.word	1677899272
	.word	776
	.word	2064014368
	.word	896
	.word	-721316432
	.word	928
	.word	1208181472
	.word	528
	.word	-804928840
	.type	Td1,#object
	.size	Td1,2048
!
! CONSTANT POOL
!
Td2:
	.word	1336
	.word	1342345120
	.word	808
	.word	1392767496
	.word	1312
	.word	-1023356744
	.word	752
	.word	-1778265800
	.word	856
	.word	-889070248
	.word	552
	.word	-251593496
	.word	704
	.word	-1425709104
	.word	24
	.word	-1828561128
	.word	2000
	.word	1426129280
	.word	872
	.word	-167416912
	.word	944
	.word	-1861990816
	.word	608
	.word	621258768
	.word	1720
	.word	-66945240
	.word	1624
	.word	-687462064
	.word	544
	.word	-2147405400
	.word	1304
	.word	-1895453936
	.word	720
	.word	1225192840
	.word	216
	.word	1728130512
	.word	112
	.word	-1744687280
	.word	1536
	.word	-519901200
	.word	936
	.word	33954168
	.word	1920
	.word	302254688
	.word	1208
	.word	-1559991760
	.word	1992
	.word	-972857704
	.word	760
	.word	-419423112
	.word	1248
	.word	-1795117936
	.word	976
	.word	-351929496
	.word	712
	.word	-637228400
	.word	1048
	.word	755410416
	.word	264
	.word	-754793568
	.word	840
	.word	688017152
	.word	1600
	.word	1141143112
	.word	1096
	.word	1778626064
	.word	968
	.word	2013766768
	.word	496
	.word	1795476160
	.word	904
	.word	-587121208
	.word	632
	.word	-1241123064
	.word	1384
	.word	386368576
	.word	1376
	.word	1711687936
	.word	464
	.word	-1274810768
	.word	592
	.word	402857720
	.word	392
	.word	-2113460016
	.word	408
	.word	1610922632
	.word	1016
	.word	1157829272
	.word	952
	.word	-536507616
	.word	1392
	.word	-2079990952
	.word	1280
	.word	470283272
	.word	344
	.word	-1811429312
	.word	832
	.word	1476624960
	.word	2024
	.word	419723816
	.word	864
	.word	-2029738256
	.word	1984
	.word	-1224567848
	.word	1688
	.word	587553688
	.word	16
	.word	-503082408
	.word	1144
	.word	1460082936
	.word	1368
	.word	704852648
	.word	320
	.word	117806936
	.word	1552
	.word	50429352
	.word	984
	.word	-1711000024
	.word	64
	.word	-1526294088
	.word	1080
	.word	-234782400
	.word	1320
	.word	-1308549640
	.word	848
	.word	-1174401000
	.word	1040
	.word	1543989424
	.word	224
	.word	721704568
	.word	1440
	.word	-1845150776
	.word	1936
	.word	-267937736
	.word	1808
	.word	-1593674936
	.word	1952
	.word	-855429424
	.word	1520
	.word	-721407960
	.word	784
	.word	520522144
	.word	2032
	.word	-1979308752
	.word	664
	.word	-1660837520
	.word	680
	.word	-1610279016
	.word	1800
	.word	838872144
	.word	1880
	.word	1963272112
	.word	1888
	.word	956324888
	.word	1912
	.word	-1442708736
	.word	1272
	.word	100856712
	.word	128
	.word	1359342448
	.word	1104
	.word	-117313272
	.word	48
	.word	1023719144
	.word	40
	.word	-1375278608
	.word	1512
	.word	1174564656
	.word	1128
	.word	-1257993568
	.word	744
	.word	84119072
	.word	1696
	.word	1862279216
	.word	168
	.word	-16579968
	.word	2008
	.word	604032192
	.word	1864
	.word	-1761167896
	.word	536
	.word	-872134144
	.word	1264
	.word	1996701384
	.word	528
	.word	-1123711168
	.word	1112
	.word	-2013250488
	.word	728
	.word	939997384
	.word	1904
	.word	-620507584
	.word	80
	.word	1191513056
	.word	120
	.word	-385621488
	.word	240
	.word	-922237920
	.word	0
	.word	0
	.word	1072
	.word	-2097132544
	.word	1896
	.word	1208062296
	.word	896
	.word	-1409224568
	.word	912
	.word	1308844752
	.word	2040
	.word	-83367824
	.word	448
	.word	1442872360
	.word	1704
	.word	503442800
	.word	456
	.word	654422376
	.word	1736
	.word	1677742200
	.word	1328
	.word	553861856
	.word	672
	.word	-788210984
	.word	368
	.word	973152688
	.word	824
	.word	-1325375408
	.word	1848
	.word	251959992
	.word	1200
	.word	-771381392
	.word	1160
	.word	-1644110632
	.word	1576
	.word	1325663744
	.word	256
	.word	-1576857888
	.word	600
	.word	1761792952
	.word	208
	.word	369156240
	.word	1488
	.word	168236184
	.word	336
	.word	-452590336
	.word	1792
	.word	1124196624
	.word	184
	.word	486576344
	.word	104
	.word	184578120
	.word	1592
	.word	-1392012200
	.word	1344
	.word	-1191088720
	.word	1352
	.word	-939482896
	.word	200
	.word	-2063417464
	.word	56
	.word	1275427752
	.word	1768
	.word	-1157139256
	.word	768
	.word	-49996808
	.word	304
	.word	-1626884088
	.word	1960
	.word	-1140661360
	.word	472
	.word	-989715664
	.word	1008
	.word	872603608
	.word	328
	.word	1979996696
	.word	1584
	.word	-603563752
	.word	2016
	.word	1745205096
	.word	1928
	.word	1661323040
	.word	1760
	.word	-905528952
	.word	1064
	.word	268571416
	.word	272
	.word	1073781944
	.word	136
	.word	537142832
	.word	288
	.word	2097424976
	.word	488
	.word	-133786152
	.word	400
	.word	285571016
	.word	1288
	.word	1829124424
	.word	376
	.word	1258351856
	.word	384
	.word	-217651824
	.word	656
	.word	-335516624
	.word	1816
	.word	-805061112
	.word	176
	.word	1812028824
	.word	1480
	.word	-1727706240
	.word	576
	.word	-100627296
	.word	800
	.word	570572616
	.word	1120
	.word	-1006286880
	.word	504
	.word	436537216
	.word	352
	.word	-670911512
	.word	1152
	.word	-285142632
	.word	624
	.word	-956024248
	.word	1672
	.word	-1056519744
	.word	1296
	.word	-33266096
	.word	88
	.word	906282656
	.word	1032
	.word	-821741656
	.word	1776
	.word	671427536
	.word	1136
	.word	637982136
	.word	1528
	.word	-1543373464
	.word	1256
	.word	-469671472
	.word	1168
	.word	218268608
	.word	1632
	.word	-1694280968
	.word	560
	.word	1644340208
	.word	152
	.word	-1039682456
	.word	1472
	.word	-402356544
	.word	1976
	.word	1577152968
	.word	1400
	.word	-184281576
	.word	1024
	.word	-1106969880
	.word	1176
	.word	2080591488
	.word	360
	.word	-1459388760
	.word	144
	.word	-1291421400
	.word	1224
	.word	990266720
	.word	1000
	.word	-1493139264
	.word	792
	.word	1845970144
	.word	1496
	.word	2064046552
	.word	960
	.word	151415088
	.word	192
	.word	-201100600
	.word	1464
	.word	17261776
	.word	1232
	.word	-1476126088
	.word	880
	.word	1694971048
	.word	1840
	.word	2114279416
	.word	1656
	.word	134286816
	.word	1856
	.word	-435717976
	.word	1240
	.word	-653928648
	.word	432
	.word	-838708360
	.word	72
	.word	-737717000
	.word	992
	.word	-704557696
	.word	1424
	.word	-1358852832
	.word	280
	.word	822170104
	.word	1184
	.word	805713192
	.word	816
	.word	-1073631984
	.word	1504
	.word	922985072
	.word	1616
	.word	-1509432304
	.word	1664
	.word	-1341717376
	.word	1728
	.word	352427320
	.word	1216
	.word	1242007584
	.word	1744
	.word	-150859936
	.word	640
	.word	235142760
	.word	1968
	.word	788577416
	.word	1712
	.word	-1929137560
	.word	1408
	.word	1291984760
	.word	616
	.word	1409705296
	.word	32
	.word	-553179984
	.word	1448
	.word	-486214008
	.word	1088
	.word	453141328
	.word	248
	.word	-1207563936
	.word	648
	.word	2130850600
	.word	1872
	.word	67431152
	.word	424
	.word	1560284256
	.word	928
	.word	1929892920
	.word	520
	.word	772266072
	.word	232
	.word	1510316856
	.word	1680
	.word	1376032472
	.word	688
	.word	856115328
	.word	568
	.word	318992048
	.word	776
	.word	-1945839944
	.word	96
	.word	2046934280
	.word	160
	.word	-1912418368
	.word	480
	.word	-1996007272
	.word	312
	.word	-301566648
	.word	1608
	.word	889568008
	.word	1832
	.word	-318306080
	.word	1416
	.word	1006883384
	.word	1784
	.word	1493493392
	.word	920
	.word	1057140624
	.word	1648
	.word	2030092448
	.word	440
	.word	-1090281928
	.word	1640
	.word	-368926792
	.word	1360
	.word	1526923240
	.word	888
	.word	336001512
	.word	1752
	.word	-2046574048
	.word	1944
	.word	-2130291336
	.word	1568
	.word	1040567104
	.word	416
	.word	738312480
	.word	512
	.word	1594234136
	.word	1560
	.word	1912647912
	.word	296
	.word	201713424
	.word	584
	.word	-1962851872
	.word	1192
	.word	1091041384
	.word	8
	.word	1895943488
	.word	1432
	.word	-570408864
	.word	1824
	.word	-1677277792
	.word	1544
	.word	-1878842704
	.word	1056
	.word	1627643480
	.word	1456
	.word	1879484816
	.word	736
	.word	1946305376
	.word	696
	.word	1107723712
	.type	Td2,#object
	.size	Td2,2048
!
! CONSTANT POOL
!
Td3:
	.word	1952
	.word	-1493007736
	.word	520
	.word	1694669808
	.word	184
	.word	-1543104304
	.word	312
	.word	1577365968
	.word	1368
	.word	1795578328
	.word	1256
	.word	1158121720
	.word	2000
	.word	1476746592
	.word	1816
	.word	50633304
	.word	384
	.word	-100488960
	.word	944
	.word	1829221736
	.word	1632
	.word	1980009536
	.word	16
	.word	1275146152
	.word	1832
	.word	-687349128
	.word	336
	.word	-888750552
	.word	424
	.word	1141113136
	.word	784
	.word	-1559986776
	.word	1416
	.word	1510100720
	.word	1488
	.word	453196072
	.word	1872
	.word	235192872
	.word	2032
	.word	-1073280280
	.word	376
	.word	1962939928
	.word	608
	.word	-268397560
	.word	560
	.word	-1761272728
	.word	1688
	.word	-117034152
	.word	1144
	.word	1594308632
	.word	1168
	.word	-1677416280
	.word	872
	.word	2047303160
	.word	656
	.word	1493619880
	.word	1520
	.word	-2097058144
	.word	928
	.word	554080960
	.word	1792
	.word	1761692232
	.word	1608
	.word	-939383696
	.word	1552
	.word	-1996270680
	.word	1136
	.word	2030290848
	.word	704
	.word	1040407752
	.word	1480
	.word	1896278328
	.word	1800
	.word	1325774320
	.word	1088
	.word	-1392459904
	.word	256
	.word	-1409075640
	.word	1648
	.word	973448168
	.word	1784
	.word	1241563928
	.word	208
	.word	822351656
	.word	648
	.word	855835832
	.word	664
	.word	2130848528
	.word	800
	.word	1996948872
	.word	856
	.word	-1375459880
	.word	1032
	.word	-1610553360
	.word	64
	.word	721725384
	.word	576
	.word	1745011584
	.word	552
	.word	-50279304
	.word	1776
	.word	1812216992
	.word	984
	.word	-133842288
	.word	920
	.word	-754901672
	.word	600
	.word	34018192
	.word	248
	.word	-1895645416
	.word	680
	.word	-1425976528
	.word	1880
	.word	671104400
	.word	1448
	.word	-1040180872
	.word	1576
	.word	2063914032
	.word	440
	.word	134557336
	.word	320
	.word	-2029547136
	.word	1528
	.word	-1526361832
	.word	24
	.word	1778765840
	.word	176
	.word	-2113738904
	.word	1656
	.word	469851216
	.word	968
	.word	-1274768072
	.word	56
	.word	-234387560
	.word	840
	.word	-502986128
	.word	1744
	.word	-200905944
	.word	40
	.word	-1106859984
	.word	416
	.word	1644232328
	.word	1328
	.word	-33270240
	.word	368
	.word	1392830880
	.word	1944
	.word	1426392336
	.word	1104
	.word	-519991256
	.word	1968
	.word	-352080608
	.word	1048
	.word	-335427496
	.word	768
	.word	-284864000
	.word	904
	.word	-1627376912
	.word	880
	.word	268602856
	.word	264
	.word	-1979201040
	.word	1768
	.word	100789424
	.word	496
	.word	84244200
	.word	1840
	.word	-1123929496
	.word	672
	.word	-1929007992
	.word	1568
	.word	1560292232
	.word	48
	.word	-737970144
	.word	640
	.word	352844544
	.word	1216
	.word	-83812152
	.word	1512
	.word	-385565008
	.word	512
	.word	1124492360
	.word	1736
	.word	-1643922632
	.word	1856
	.word	1107684736
	.word	1096
	.word	-1962655688
	.word	200
	.word	1526843192
	.word	1600
	.word	-301540408
	.word	992
	.word	167918856
	.word	528
	.word	252136416
	.word	1056
	.word	503730112
	.word	0
	.word	0
	.word	1024
	.word	-2046551992
	.word	344
	.word	-318619248
	.word	136
	.word	1879400688
	.word	720
	.word	1912763232
	.word	112
	.word	-16261144
	.word	1064
	.word	939700344
	.word	1392
	.word	-721358360
	.word	360
	.word	956381616
	.word	120
	.word	-654106544
	.word	736
	.word	-1509881024
	.word	728
	.word	1409715416
	.word	432
	.word	771871008
	.word	80
	.word	1728415840
	.word	696
	.word	-419398504
	.word	1904
	.word	-1777953376
	.word	1240
	.word	-1861947176
	.word	1536
	.word	-989692928
	.word	1760
	.word	537203464
	.word	952
	.word	1258506960
	.word	144
	.word	436252896
	.word	1176
	.word	-1174382832
	.word	1280
	.word	705113600
	.word	272
	.word	-536733216
	.word	216
	.word	385935504
	.word	72
	.word	218126448
	.word	1112
	.word	-955945072
	.word	1456
	.word	-1476015768
	.word	240
	.word	-1459208032
	.word	1928
	.word	419703480
	.word	936
	.word	117597560
	.word	1224
	.word	-586817680
	.word	1016
	.word	1611132184
	.word	8
	.word	637861816
	.word	912
	.word	-184163616
	.word	816
	.word	990259744
	.word	2008
	.word	2114036440
	.word	536
	.word	688108632
	.word	280
	.word	-972626344
	.word	1896
	.word	-66894416
	.word	1824
	.word	-251454016
	.word	392
	.word	-603564360
	.word	792
	.word	-2063564272
	.word	1208
	.word	570556568
	.word	1584
	.word	285279264
	.word	592
	.word	604236840
	.word	1496
	.word	1023919760
	.word	1992
	.word	838897008
	.word	328
	.word	-1593610696
	.word	1264
	.word	788682984
	.word	1424
	.word	805805792
	.word	1072
	.word	1376215144
	.word	1544
	.word	-486112328
	.word	1432
	.word	369320280
	.word	896
	.word	-1190867640
	.word	1184
	.word	1208471688
	.word	1864
	.word	1677791800
	.word	2016
	.word	-1945754304
	.word	1920
	.word	1057019136
	.word	1000
	.word	738640560
	.word	408
	.word	-1878558448
	.word	584
	.word	1309031480
	.word	448
	.word	-788132152
	.word	1616
	.word	-1576536992
	.word	1696
	.word	184661184
	.word	1960
	.word	-2130281168
	.word	976
	.word	-570342104
	.word	1464
	.word	-1912523056
	.word	1384
	.word	-1090182664
	.word	464
	.word	-1660477088
	.word	960
	.word	-1845466496
	.word	760
	.word	-872096944
	.word	1008
	.word	1174606496
	.word	1128
	.word	319166384
	.word	1728
	.word	-1207483264
	.word	456
	.word	-150802064
	.word	1560
	.word	-1358451696
	.word	744
	.word	-2147093256
	.word	1664
	.word	-1828461752
	.word	1704
	.word	755321720
	.word	296
	.word	302358136
	.word	1376
	.word	-1727930816
	.word	192
	.word	2097494144
	.word	1248
	.word	1661171520
	.word	472
	.word	-1157374248
	.word	304
	.word	2013285992
	.word	712
	.word	403153776
	.word	1232
	.word	-1224732832
	.word	632
	.word	-1710930920
	.word	1192
	.word	1845702448
	.word	2040
	.word	-435948208
	.word	1504
	.word	-822066936
	.word	168
	.word	-402180232
	.word	1848
	.word	-1694052912
	.word	888
	.word	906392144
	.word	1272
	.word	151430992
	.word	1408
	.word	2080813384
	.word	1312
	.word	-1308264056
	.word	504
	.word	587303248
	.word	1320
	.word	-1811839440
	.word	1296
	.word	1711669672
	.word	624
	.word	-1140737120
	.word	1040
	.word	-905627680
	.word	1152
	.word	-804944128
	.word	1336
	.word	-671045224
	.word	32
	.word	-1744676984
	.word	1888
	.word	-637027832
	.word	1640
	.word	1342206968
	.word	1160
	.word	-167675720
	.word	616
	.word	-704353360
	.word	1912
	.word	-1342019048
	.word	1360
	.word	1292019296
	.word	1200
	.word	67567392
	.word	1672
	.word	-1257825040
	.word	848
	.word	-2013210016
	.word	352
	.word	520472072
	.word	808
	.word	1359215152
	.word	752
	.word	-369089304
	.word	1120
	.word	889382920
	.word	1080
	.word	1946394576
	.word	88
	.word	1090615256
	.word	824
	.word	486725016
	.word	1752
	.word	-771582832
	.word	128
	.word	1442946888
	.word	1712
	.word	1191222120
	.word	1720
	.word	1627677904
	.word	1288
	.word	201576888
	.word	1984
	.word	335835848
	.word	152
	.word	1006915416
	.word	1352
	.word	654800496
	.word	776
	.word	-922636872
	.word	224
	.word	-452497656
	.word	568
	.word	-1325276208
	.word	1680
	.word	-553464608
	.word	1936
	.word	1929509544
	.word	160
	.word	-838612800
	.word	1592
	.word	923138968
	.word	1976
	.word	-855158120
	.word	2024
	.word	-1442653448
	.word	488
	.word	1862313720
	.word	544
	.word	-620481600
	.word	1400
	.word	-217838000
	.word	832
	.word	-1006504504
	.word	288
	.word	872505792
	.word	1304
	.word	1073937936
	.word	232
	.word	-1023176528
	.word	1808
	.word	620783072
	.word	480
	.word	1225021760
	.word	104
	.word	-1795026952
	.word	1344
	.word	17009096
	.word	96
	.word	-1291390912
	.word	1440
	.word	-469440832
	.word	688
	.word	-1056668896
	.word	1624
	.word	-2080175144
	.word	400
	.word	-1241282904
	.word	864
	.word	1543742016
	.word	1472
	.word	1459754624
	.type	Td3,#object
	.size	Td3,2048
	.align	4
!
! CONSTANT POOL
!
Td4:
	.word	1381126738
	.word	151587081
	.word	1785358954
	.word	-707406379
	.word	808464432
	.word	909522486
	.word	-1515870811
	.word	943208504
	.word	-1077952577
	.word	1077952576
	.word	-1549556829
	.word	-1633771874
	.word	-2122219135
	.word	-202116109
	.word	-673720361
	.word	-67372037
	.word	2088533116
	.word	-471604253
	.word	960051513
	.word	-2105376126
	.word	-1684300901
	.word	791621423
	.word	-1
	.word	-2021161081
	.word	875836468
	.word	-1903260018
	.word	1128481603
	.word	1145324612
	.word	-993737532
	.word	-555819298
	.word	-370546199
	.word	-875836469
	.word	1414812756
	.word	2071690107
	.word	-1802201964
	.word	842150450
	.word	-1499027802
	.word	-1027423550
	.word	589505315
	.word	1027423549
	.word	-286331154
	.word	1280068684
	.word	-1785358955
	.word	185273099
	.word	1111638594
	.word	-84215046
	.word	-1010580541
	.word	1313754702
	.word	134744072
	.word	774778414
	.word	-1583242847
	.word	1717986918
	.word	673720360
	.word	-640034343
	.word	606348324
	.word	-1296911694
	.word	1987475062
	.word	1532713819
	.word	-1566399838
	.word	1229539657
	.word	1835887981
	.word	-1953789045
	.word	-774778415
	.word	623191333
	.word	1920103026
	.word	-117901064
	.word	-151587082
	.word	1684300900
	.word	-2038004090
	.word	1751672936
	.word	-1734829928
	.word	370546198
	.word	-724249388
	.word	-1532713820
	.word	1549556828
	.word	-858993460
	.word	1566399837
	.word	1701143909
	.word	-1229539658
	.word	-1835887982
	.word	1819044972
	.word	1886417008
	.word	1212696648
	.word	1347440720
	.word	-33686019
	.word	-303174163
	.word	-1179010631
	.word	-623191334
	.word	1583242846
	.word	353703189
	.word	1179010630
	.word	1465341783
	.word	-1482184793
	.word	-1920103027
	.word	-1650614883
	.word	-2071690108
	.word	-1869574000
	.word	-656877352
	.word	-1414812757
	.word	0
	.word	-1936946036
	.word	-1128481604
	.word	-741092397
	.word	168430090
	.word	-134744073
	.word	-454761244
	.word	1482184792
	.word	84215045
	.word	-1195853640
	.word	-1280068685
	.word	1162167621
	.word	101058054
	.word	-791621424
	.word	741092396
	.word	505290270
	.word	-1886417009
	.word	-892679478
	.word	1061109567
	.word	252645135
	.word	33686018
	.word	-1044266559
	.word	-1347440721
	.word	-1111638595
	.word	50529027
	.word	16843009
	.word	320017171
	.word	-1970632054
	.word	1802201963
	.word	976894522
	.word	-1852730991
	.word	286331153
	.word	1094795585
	.word	1330597711
	.word	1734829927
	.word	-589505316
	.word	-353703190
	.word	-1751672937
	.word	-218959118
	.word	-808464433
	.word	-825307442
	.word	-252645136
	.word	-1263225676
	.word	-421075226
	.word	1936946035
	.word	-1768515946
	.word	-1397969748
	.word	1953789044
	.word	572662306
	.word	-404232217
	.word	-1381126739
	.word	892679477
	.word	-2054847099
	.word	-488447262
	.word	-101058055
	.word	926365495
	.word	-387389208
	.word	471604252
	.word	1970632053
	.word	-538976289
	.word	1852730990
	.word	1195853639
	.word	-235802127
	.word	437918234
	.word	1903260017
	.word	488447261
	.word	690563369
	.word	-976894523
	.word	-1987475063
	.word	1869573999
	.word	-1212696649
	.word	1650614882
	.word	235802126
	.word	-1431655766
	.word	404232216
	.word	-1094795586
	.word	454761243
	.word	-50529028
	.word	1448498774
	.word	1044266558
	.word	1263225675
	.word	-960051514
	.word	-757935406
	.word	2038004089
	.word	538976288
	.word	-1701143910
	.word	-606348325
	.word	-1061109568
	.word	-16843010
	.word	2021161080
	.word	-842150451
	.word	1515870810
	.word	-185273100
	.word	522133279
	.word	-572662307
	.word	-1465341784
	.word	858993459
	.word	-2004318072
	.word	117901063
	.word	-943208505
	.word	825307441
	.word	-1313754703
	.word	303174162
	.word	269488144
	.word	1499027801
	.word	656877351
	.word	-2139062144
	.word	-320017172
	.word	1600085855
	.word	1616928864
	.word	1364283729
	.word	2139062143
	.word	-1448498775
	.word	421075225
	.word	-1246382667
	.word	1246382666
	.word	218959117
	.word	757935405
	.word	-437918235
	.word	2054847098
	.word	-1616928865
	.word	-1819044973
	.word	-909522487
	.word	-1667457892
	.word	-269488145
	.word	-1600085856
	.word	-522133280
	.word	993737531
	.word	1296911693
	.word	-1364283730
	.word	707406378
	.word	-168430091
	.word	-1330597712
	.word	-926365496
	.word	-336860181
	.word	-1145324613
	.word	1010580540
	.word	-2088533117
	.word	1397969747
	.word	-1717986919
	.word	1633771873
	.word	387389207
	.word	724249387
	.word	67372036
	.word	2122219134
	.word	-1162167622
	.word	2004318071
	.word	-690563370
	.word	640034342
	.word	-505290271
	.word	1768515945
	.word	336860180
	.word	1667457891
	.word	1431655765
	.word	555819297
	.word	202116108
	.word	2105376125
	.type	Td4,#object
	.size	Td4,1024

!
! CONSTANT POOL
!
rcon:
	.word	16777216
	.word	33554432
	.word	67108864
	.word	134217728
	.word	268435456
	.word	536870912
	.word	1073741824
	.word	-2147483648
	.word	452984832
	.word	905969664
	.type	rcon,#object
	.size	rcon,40

! Begin Disassembling Stabs
	.xstabs	".stab.index","Xa ; O ; P ; V=3.1 ; R=WorkShop Compilers 5.0 99/02/25 C 5.0 patch 107289-01",60,0,0,0	! (/tmp/acompAAA5jaWsZ:1)
! End Disassembling Stabs

! Begin Disassembling Ident
	.ident	"cg: WorkShop Compilers 5.0 99/04/15 Compiler Common 5.0 Patch 107357-02"	! (NO SOURCE LINE)
	.ident	"acomp: WorkShop Compilers 5.0 99/02/25 C 5.0 patch 107289-01"	! (/tmp/acompAAA5jaWsZ:4675)
! End Disassembling Ident

#endif	/* lint || __lint */
