/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 */

#include <sys/trapstat.h>
#include "_trapstat.h"

static tstat_ent_t g_traps[TSTAT_NENT] = {
#ifndef	sun4v
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "power-on", 		"power on reset" },
	{ "watchdog", 		"watchdog reset" },
	{ "xir", 		"externally initiated reset" },
	{ "sir", 		"software initiated reset" },
	{ "red", 		"RED state exception" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "immu-xcp", 		"instruction access exception" },
	{ "immu-miss", 		"instruction access MMU miss" },
	{ "immu-err", 		"instruction access error" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "ill-inst", 		"illegal instruction" },
	{ "priv-inst", 		"privileged opcode" },
	{ "unimp-ldd", 		"unimplemented LDD" },
	{ "unimp-std", 		"unimplemented STD" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "fp-disabled", 	"fp disabled" },
	{ "fp-ieee754", 	"fp exception ieee754" },
	{ "fp-xcp-other", 	"fp exception other" },
	{ "tag-oflow", 		"tag overflow" },
	{ "cleanwin", 		"clean window" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "div-zero", 		"division by zero" },
	{ "internal-err", 	"internal processor error" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "dmmu-xcp", 		"data access exception" },
	{ "dmmu-miss", 		"data access MMU miss" },
	{ "dmmu-err", 		"data access error" },
	{ "dmmu-prot", 		"data access protection" },
	{ "unalign", 		"mem address not aligned" },
	{ "lddf-unalign", 	"LDDF mem address not aligned" },
	{ "stdf-unalign", 	"STDF mem address not aligned" },
	{ "priv-act", 		"privileged action" },
	{ "ldqf-unalign",	"LDQF mem address not aligned" },
	{ "stqf-unalign", 	"STQF mem address not aligned" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "async-d-err", 	"async data error" },
	{ "level-1", 		"interrupt level 1" },
	{ "level-2", 		"interrupt level 2" },
	{ "level-3", 		"interrupt level 3" },
	{ "level-4", 		"interrupt level 4" },
	{ "level-5", 		"interrupt level 5" },
	{ "level-6", 		"interrupt level 6" },
	{ "level-7", 		"interrupt level 7" },
	{ "level-8", 		"interrupt level 8" },
	{ "level-9", 		"interrupt level 9" },
	{ "level-10", 		"interrupt level 10" },
	{ "level-11", 		"interrupt level 11" },
	{ "level-12", 		"interrupt level 12" },
	{ "level-13", 		"interrupt level 13" },
	{ "level-14", 		"interrupt level 14" },
	{ "level-15", 		"interrupt level 15" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "int-vec", 		"interrupt vector" },
	{ "pa-watch", 		"PA watchpoint" },
	{ "va-watch", 		"VA watchpoint" },
	{ "ecc-err", 		"corrected ECC error" },
	{ "itlb-miss", 		"instruction access MMU miss" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "dtlb-miss", 		"data access MMU miss" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "dtlb-prot", 		"data access protection" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fast-ecc",		"fast ECC error" },
	{ "dcache-parity",	"D-cache parity error" },
	{ "icache-parity",	"I-cache parity error" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
#else /* sun4v */
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "watchdog", 		"watchdog reset" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "immu-xcp", 		"instruction access exception" },
	{ "immu-miss", 		"instruction access MMU miss" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "ill-inst", 		"illegal instruction" },
	{ "priv-inst", 		"privileged opcode" },
	{ "unimp-ldd", 		"unimplemented LDD" },
	{ "unimp-std", 		"unimplemented STD" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "fp-disabled", 	"fp disabled" },
	{ "fp-ieee754", 	"fp exception ieee754" },
	{ "fp-xcp-other", 	"fp exception other" },
	{ "tag-oflow", 		"tag overflow" },
	{ "cleanwin", 		"clean window" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "div-zero", 		"division by zero" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "dmmu-xcp", 		"data access exception" },
	{ "dmmu-miss", 		"data access MMU miss" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "dmmu-prot", 		"data access protection" },
	{ "unalign", 		"mem address not aligned" },
	{ "lddf-unalign", 	"LDDF mem address not aligned" },
	{ "stdf-unalign", 	"STDF mem address not aligned" },
	{ "priv-act", 		"privileged action" },
	{ "ldqf-unalign",	"LDQF mem address not aligned" },
	{ "stqf-unalign", 	"STQF mem address not aligned" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "level-1", 		"interrupt level 1" },
	{ "level-2", 		"interrupt level 2" },
	{ "level-3", 		"interrupt level 3" },
	{ "level-4", 		"interrupt level 4" },
	{ "level-5", 		"interrupt level 5" },
	{ "level-6", 		"interrupt level 6" },
	{ "level-7", 		"interrupt level 7" },
	{ "level-8", 		"interrupt level 8" },
	{ "level-9", 		"interrupt level 9" },
	{ "level-10", 		"interrupt level 10" },
	{ "level-11", 		"interrupt level 11" },
	{ "level-12", 		"interrupt level 12" },
	{ "level-13", 		"interrupt level 13" },
	{ "level-14", 		"interrupt level 14" },
	{ "level-15", 		"interrupt level 15" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "pa-watch", 		"PA watchpoint" },
	{ "va-watch", 		"VA watchpoint" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "itlb-miss", 		"instruction access MMU miss" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "dtlb-miss", 		"data access MMU miss" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "dtlb-prot", 		"data access protection" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "ctl-xfer",		"control transfer" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "instr-brkpt",	"instruction breakpoint" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ "hw-changed", 	"hardware changed" },
	{ "cpu_mondo", 		"cpu mondo trap" },
	{ "dev_mondo", 		"device mondo trap" },
	{ "res-err", 		"resumable error" },
	{ "nonres-err",		"non-resumable error" },
#endif /* sun4v */
	{ "spill-0-normal", 	"spill 0 normal" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-user-32", 	"spill user window, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-user-64", 	"spill user window, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-user-32-cln", 	"spill, clean user window, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-user-64-cln", 	"spill, clean user window, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-kern-32", 	"spill kernel window, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-kern-64", 	"spill kernel window, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-mixed", 	"spill window, mixed 32-bit/64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-0-other", 	"spill 0 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-asuser-32", 	"spill user window as kernel, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-asuser-64", 	"spill user window as kernel, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-asuser-32-cln", "spill, clean user window as kernel, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-asuser-64-cln", "spill, clean user window as kernel, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-5-other", 	"spill 5 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-6-other", 	"spill 6 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "spill-7-other", 	"spill 7 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-0-normal", 	"fill 0 normal" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-user-32", 	"fill user window, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-user-64", 	"fill user window, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-user-32-cln", 	"fill user window, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-user-64-cln", 	"fill user window, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-kern-32", 	"fill kernel window, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-kern-64", 	"fill kernel window, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-mixed", 	"fill window, mixed 32-bit/64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-0-other", 	"fill 0 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-asuser-32", 	"fill user window as kernel, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-asuser-64", 	"fill user window as kernel, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-asuser-32-cln", "fill user window as kernel, 32-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-asuser-64-cln",	"fill user window as kernel, 64-bit" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-5-other", 	"fill 5 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-6-other", 	"fill 6 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "fill-7-other", 	"fill 7 other" },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ NULL, NULL,		TSTAT_ENT_CONTINUED },
	{ "syscall-4x", 	"old system call" },
	{ "usr-brkpt", 		"user breakpoint" },
	{ "usr-div-zero", 	"user divide by zero" },
	{ "flush-wins", 	"flush windows" },
	{ "clean-wins", 	"clean windows" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "fix-align", 		"fix unaligned references" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "syscall-32", 	"ILP32 system call" },
	{ "set-t0-addr", 	"set trap0 address" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "trap-inst-16", 	"trap instruction 16", },
	{ "trap-inst-17", 	"trap instruction 17", },
	{ "trap-inst-18", 	"trap instruction 18", },
	{ "trap-inst-19", 	"trap instruction 19", },
	{ "trap-inst-20", 	"trap instruction 20", },
	{ "trap-inst-21", 	"trap instruction 21", },
	{ "trap-inst-22", 	"trap instruction 22", },
	{ "trap-inst-23", 	"trap instruction 23", },
	{ "trap-inst-24", 	"trap instruction 24", },
	{ "trap-inst-25", 	"trap instruction 25", },
	{ "trap-inst-26", 	"trap instruction 26", },
	{ "trap-inst-27", 	"trap instruction 27", },
	{ "trap-inst-28", 	"trap instruction 28", },
	{ "trap-inst-29", 	"trap instruction 29", },
	{ "trap-inst-30", 	"trap instruction 30", },
	{ "trap-inst-31", 	"trap instruction 31", },
	{ "get-cc", 		"get condition codes" },
	{ "set-cc", 		"set condition codes" },
	{ "get-psr", 		"get psr" },
	{ "set-psr", 		"set psr (some fields)" },
	{ "getts", 		"get timestamp" },
	{ "gethrvtime", 	"get lwp virtual time" },
	{ "self-xcall", 	"self xcall" },
	{ "gethrtime", 		"get hrestime" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "getlgrp",		"get lgrpid" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "dtrace-pid",		"DTrace pid provider" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "dtrace-return",	"DTrace pid provider return" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "syscall-64", 	"LP64 system call" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "tt-freeze", 		"freeze traptrace" },
	{ "tt-unfreeze", 	"unfreeze traptrace" },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ NULL, NULL,		TSTAT_ENT_UNUSED },
	{ "ptl1-panic", 	"test ptl1-panic" },
	{ "kmdb-enter", 	"kmdb enter (L1-A)" },
	{ "kmdb-brkpt", 	"kmdb breakpoint" },
	{ "obp-brkpt", 		"obp breakpoint" },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED },
	{ NULL, NULL,		TSTAT_ENT_RESERVED }
};

tstat_ent_t *
get_trap_ent(int ndx)
{
	return (&g_traps[ndx]);
}
