/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2000 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 *  dos_iso
 *
 *  created by eddy bell 8-14-89
 */

#define		CODE_PAGE_US		1	/* code page 437 */
#define		CODE_PAGE_MULTILINGUAL	2	/* code page 850 */
#define		CODE_PAGE_PORTUGAL	3	/* code page 860 */
#define		CODE_PAGE_CANADA_FRENCH	4	/* code page 863 */
#define		CODE_PAGE_NORWAY	5	/* code page 865 */

#define		IN_FILE			0	/* in file       */
#define		OUT_FILE		1	/* out file      */

#ifdef old_table
unsigned char dos_to_iso_cp_860[256] = {	/*Portugal code page*/
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 07 */
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 0f */
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, /* 10 - 17 */
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 1f */
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 27 */
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 2f */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 37 */
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 3f */
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 47 */
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 4f */
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 57 */
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 5f */
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 67 */
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 6f */
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 77 */
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, /* 78 - 7f */
	0xc7, 0xfc, 0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7, /* 80 - 87 */
	0xea, 0xeb, 0xe8, 0xef, 0xee, 0xec, 0xc4, 0xc5, /* 88 - 8f */
	0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2, 0xfb, 0xf9, /* 90 - 97 */
	0xff, 0xd6, 0xdc, 0xa2, 0xa3, 0xa5, 0xa9, 0xd2, /* 98 - 9f */
	0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba, /* a0 - a7 */
	0xbf, 0xd3, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xbb, /* a8 - af */
	0x80, 0x81, 0x82, 0xa6, 0x83, 0x84, 0x85, 0x86, /* b0 - b7 */
	0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, /* b8 - bf */
	0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, /* c0 - c7 */
	0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, /* c8 - cf */
	0x9f, 0xa7, 0xd4, 0xd5, 0xd7, 0xd8, 0xd9, 0xda, /* d0 - d7 */
	0xdb, 0xa8, 0xa4, 0xad, 0xae, 0xdd, 0xe3, 0xaf, /* d8 - df */
	0xb3, 0xb4, 0xb6, 0xb7, 0xb8, 0xb9, 0xb5, 0xbe, /* e0 - e7 */
	0xde, 0xc0, 0xc1, 0xf0, 0xc2, 0xf8, 0xc3, 0xc8, /* e8 - ef */
	0xca, 0xb1, 0xcb, 0xcc, 0xcd, 0xce, 0xf7, 0xcf, /* f0 - f7 */
	0xb0, 0xd0, 0xdf, 0xf5, 0xfd, 0xb2, 0xfe, 0xa0, /* f8 - ff */
	};
unsigned char dos_to_iso[256] = {	/*United States code page  base - codepage diffs */
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 07 */
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 0f */
	0x10, 0x11, 0x12, 0x13, 0xb6, 0xa7, 0x16, 0x17, /* 10 - 17 */
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 1f */
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 27 */
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 2f */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 37 */
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 3f */
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 47 */
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 4f */
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 57 */
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 5f */
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 67 */
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 6f */
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 77 */
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0xfff, /* 78 - 7f */
	0xc7, 0xfc, 0xe9, 0xe2, 0xfff, 0xe0, 0xfff, 0xe7, /* 80 - 87 */
	0xea, 0xfff, 0xe8, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, /* 88 - 8f */
	0xc9, 0xfff, 0xfff, 0xf4, 0xfff, 0xfff, 0xfff, 0xfff, /* 90 - 97 */
	0xfff, 0xfff, 0xdc, 0xfff, 0xa3, 0xfff, 0xfff, 0xfff, /* 98 - 9f */
	0xfff, 0xfff, 0xf3, 0xfa, 0xfff, 0xfff, 0xfff, 0xfff, /* a0 - a7 */
	0xfff, 0xfff, 0xac, 0xbd, 0xbc, 0xfff, 0xab, 0xfff, /* a8 - af */
	0x97, 0x98, 0x99, 0xfe, 0xfff, 0xfff, 0xfff, 0xfff, /* b0 - b7 */
	0xfff, 0xa0, 0xa6, 0xa9, 0xad, 0xfff, 0xfff, 0xfff, /* b8 - bf */
	0xfff, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, /* c0 - c7 */
	0xae, 0xd0, 0xd7, 0xdd, 0xde, 0xfff, 0xf0, 0xfff, /* c8 - cf */
	0xfff, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, 0xfff, /* d0 - d7 */
	0xfff, 0xfff, 0xfff, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, /* d8 - df */
	0x80, 0xdf, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, /* e0 - e7 */
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, /* e8 - ef */
	0x14, 0xb1, 0xfff, 0xfff, 0x9f, 0x15, 0xf7, 0x95, /* f0 - f7 */
	0xb0, 0xb7, 0x94, 0x93, 0x92, 0xb2, 0x91, 0x90, /* f8 - ff */
	};

#endif



unsigned char dos_to_iso_cp_437[256] = {	/*United States code page*/
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 07 */
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 0f */
	0x10, 0x11, 0x12, 0x13, 0xb6, 0xa7, 0x16, 0x17, /* 10 - 17 */
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 1f */
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 27 */
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 2f */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 37 */
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 3f */
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 47 */
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 4f */
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 57 */
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 5f */
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 67 */
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 6f */
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 77 */
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x81, /* 78 - 7f */
	0xc7, 0xfc, 0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7, /* 80 - 87 */
	0xea, 0xeb, 0xe8, 0xef, 0xee, 0xec, 0xc4, 0xc5, /* 88 - 8f */
	0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2, 0xfb, 0xf9, /* 90 - 97 */
	0xff, 0xd6, 0xdc, 0xa2, 0xa3, 0xa5, 0xa4, 0x96, /* 98 - 9f */
	0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba, /* a0 - a7 */
	0xbf, 0xa8, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xaf, /* a8 - af */
	0x97, 0x98, 0x99, 0xfe, 0xb3, 0xb4, 0xb5, 0xb8, /* b0 - b7 */
	0xb9, 0xa0, 0xa6, 0xa9, 0xad, 0xbb, 0xbe, 0xc0, /* b8 - bf */
	0xc1, 0xc2, 0xc3, 0xc8, 0xfd, 0xca, 0xcb, 0xcc, /* c0 - c7 */
	0xae, 0xd0, 0xd7, 0xdd, 0xde, 0xcd, 0xf0, 0xce, /* c8 - cf */
	0xcf, 0xd2, 0xd3, 0xd4, 0xd5, 0xd8, 0xd9, 0xda, /* d0 - d7 */
	0xdb, 0xe3, 0xf5, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, /* d8 - df */
	0x80, 0xdf, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, /* e0 - e7 */
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, /* e8 - ef */
	0x14, 0xb1, 0xf8, 0x7f, 0x9f, 0x15, 0xf7, 0x95, /* f0 - f7 */
	0xb0, 0xb7, 0x94, 0x93, 0x92, 0xb2, 0x91, 0x90, /* f8 - ff */
	};

unsigned char dos_to_iso_cp_850[256] = {	/* Multilingual code page */
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 08 */
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 10 */
        0x10, 0x11, 0x12, 0x13, 0xb6, 0xa7, 0x16, 0x17, /* 10 - 18 */
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 20 */
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 28 */
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 30 */
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 38 */
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 40 */
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 48 */
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 50 */
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 58 */
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 60 */
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 68 */
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 70 */
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 78 */
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x81, /* 78 - 80 */
        0xc7, 0xfc, 0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7, /* 80 - 88 */
        0xea, 0xeb, 0xe8, 0xef, 0xee, 0xec, 0xc4, 0xc5, /* 88 - 90 */
        0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2, 0xfb, 0xf9, /* 90 - 98 */
        0xff, 0xd6, 0xdc, 0xf8, 0xa3, 0xd8, 0xd7, 0x96, /* 98 - a0 */
        0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba, /* a0 - a8 */
        0xbf, 0xae, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xbb, /* a8 - b0 */
        0x97, 0x98, 0x99, 0x14, 0x15, 0xc1, 0xc2, 0xc0, /* b0 - b8 */
        0xa9, 0xa0, 0x7f, 0x80, 0xad, 0xa2, 0xa5, 0x82, /* b8 - c0 */
        0x83, 0x84, 0x85, 0x87, 0x88, 0x89, 0xe3, 0xc3, /* c0 - c8 */
        0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x92, 0xa4, /* c8 - d0 */
        0xf0, 0xd0, 0xca, 0xcb, 0xc8, 0x93, 0xcd, 0xce, /* d0 - d8 */
        0xcf, 0x94, 0x95, 0x9a, 0x9b, 0xa6, 0xcc, 0x9e, /* d8 - e0 */
        0xd3, 0xdf, 0xd4, 0xd2, 0xf5, 0xd5, 0x86, 0xfe, /* e0 - e8 */
        0xde, 0xda, 0xdb, 0xd9, 0xfd, 0xdd, 0xaf, 0xb4, /* e8 - f0 */
        0x9c, 0xb1, 0x9d, 0xbe, 0x9f, 0xb5, 0xf7, 0xb8, /* f0 - f8 */
        0xb0, 0xa8, 0xb7, 0xb9, 0xb3, 0xb2, 0x91, 0x90, /* f8 - 100 */
	};

unsigned char dos_to_iso_cp_860[256] = {	/* Portugal code page */
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 08 */
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 10 */
        0x10, 0x11, 0x12, 0x13, 0xb6, 0xa7, 0x16, 0x17, /* 10 - 18 */
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 20 */
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 28 */
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 30 */
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 38 */
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 40 */
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 48 */
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 50 */
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 58 */
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 60 */
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 68 */
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 70 */
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 78 */
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x96, /* 78 - 80 */
        0xc7, 0xfc, 0xe9, 0xe2, 0xe3, 0xe0, 0xc1, 0xe7, /* 80 - 88 */
        0xea, 0xca, 0xe8, 0xcd, 0xd4, 0xec, 0xc3, 0xc2, /* 88 - 90 */
        0xc9, 0xc0, 0xc8, 0xf4, 0xf5, 0xf2, 0xda, 0xf9, /* 90 - 98 */
        0xcc, 0xd5, 0xdc, 0xa2, 0xa3, 0xd9, 0x7f, 0xd3, /* 98 - a0 */
        0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba, /* a0 - a8 */
        0xbf, 0xd2, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xbb, /* a8 - b0 */
        0x97, 0x98, 0x99, 0xfe, 0x81, 0xa4, 0xa5, 0xa8, /* b0 - b8 */
        0xaf, 0xa0, 0xa6, 0xa9, 0xad, 0xb3, 0xb4, 0xb5, /* b8 - c0 */
        0xb8, 0xb9, 0xbe, 0xc4, 0xc5, 0xc6, 0xcb, 0xce, /* c0 - c8 */
        0xae, 0xd0, 0xd7, 0xdd, 0xde, 0xcf, 0xf0, 0xd6, /* c8 - d0 */
        0xd8, 0xdb, 0xe4, 0xe5, 0xe6, 0xeb, 0xee, 0xef, /* d0 - d8 */
        0xf6, 0xf8, 0xfb, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, /* d8 - e0 */
        0x80, 0xdf, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, /* e0 - e8 */
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, /* e8 - f0 */
        0x14, 0xb1, 0xfd, 0xff, 0x9f, 0x15, 0xf7, 0x95, /* f0 - f8 */
        0xb0, 0xb7, 0x94, 0x93, 0x92, 0xb2, 0x91, 0x90, /* f8 - 100 */
	};
unsigned char dos_to_iso_cp_863[256] = {	/*Canada-French code page*/
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 08 */
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 10 */
        0x10, 0x11, 0x12, 0x13, 0xb6, 0xa7, 0x16, 0x17, /* 10 - 18 */
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 20 */
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 28 */
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 30 */
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 38 */
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 40 */
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 48 */
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 50 */
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 58 */
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 60 */
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 68 */
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 70 */
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 78 */
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, /* 78 - 80 */
        0xc7, 0xfc, 0xe9, 0xe2, 0xc2, 0xe0, 0x81, 0xe7, /* 80 - 88 */
        0xea, 0xeb, 0xe8, 0xef, 0xee, 0xa1, 0xc0, 0xa5, /* 88 - 90 */
        0xc9, 0xc8, 0xca, 0xf4, 0xcb, 0xcf, 0xfb, 0xf9, /* 90 - 98 */
        0xa4, 0xd4, 0xdc, 0xa2, 0xa3, 0xd9, 0xdb, 0x96, /* 98 - a0 */
        0xaa, 0xb4, 0xf3, 0xfa, 0xa8, 0xb8, 0xb3, 0xaf, /* a0 - a8 */
        0xce, 0xb5, 0xac, 0xbd, 0xbc, 0xbe, 0xab, 0xbb, /* a8 - b0 */
        0x97, 0x98, 0x99, 0xfe, 0xb9, 0xba, 0xbf, 0xc1, /* b0 - b8 */
        0xc3, 0xa0, 0xa6, 0xa9, 0xad, 0xc4, 0xc5, 0xc6, /* b8 - c0 */
        0xcc, 0xcd, 0xd1, 0xd2, 0xd3, 0xd5, 0xd6, 0xd8, /* c0 - c8 */
        0xae, 0xd0, 0xd7, 0xdd, 0xde, 0xda, 0xf0, 0xe1, /* c8 - d0 */
        0xe3, 0xe4, 0xe5, 0xe6, 0xec, 0xed, 0xf1, 0xf2, /* d0 - d8 */
        0xf5, 0xf6, 0xf8, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, /* d8 - e0 */
        0x80, 0xdf, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, /* e0 - e8 */
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, /* e8 - f0 */
        0x14, 0xb1, 0xfd, 0xff, 0x9f, 0x15, 0xf7, 0x95, /* f0 - f8 */
        0xb0, 0xb7, 0x94, 0x93, 0x92, 0xb2, 0x91, 0x90, /* f8 - 100 */
	};
unsigned char dos_to_iso_cp_865[256] = {	/*Norway code page*/
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, /* 00 - 08 */
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, /* 08 - 10 */
        0x10, 0x11, 0x12, 0x13, 0xb6, 0xa7, 0x16, 0x17, /* 10 - 18 */
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, /* 18 - 20 */
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, /* 20 - 28 */
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, /* 28 - 30 */
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 30 - 38 */
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, /* 38 - 40 */
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, /* 40 - 48 */
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, /* 48 - 50 */
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, /* 50 - 58 */
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, /* 58 - 60 */
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, /* 60 - 68 */
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, /* 68 - 70 */
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, /* 70 - 78 */
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, /* 78 - 80 */
        0xc7, 0xfc, 0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7, /* 80 - 88 */
        0xea, 0xeb, 0xe8, 0xef, 0xee, 0xec, 0xc4, 0xc5, /* 88 - 90 */
        0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2, 0xfb, 0xf9, /* 90 - 98 */
        0xff, 0xd6, 0xdc, 0xf8, 0xa3, 0xd8, 0x81, 0x96, /* 98 - a0 */
        0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba, /* a0 - a8 */
        0xbf, 0xa2, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xa4, /* a8 - b0 */
        0x97, 0x98, 0x99, 0xfe, 0xa5, 0xa8, 0xaf, 0xb3, /* b0 - b8 */
        0xb4, 0xa0, 0xa6, 0xa9, 0xad, 0xb5, 0xb8, 0xb9, /* b8 - c0 */
        0xbb, 0xbe, 0xc0, 0xc1, 0xc2, 0xc3, 0xc8, 0xca, /* c0 - c8 */
        0xae, 0xd0, 0xd7, 0xdd, 0xde, 0xcb, 0xf0, 0xcc, /* c8 - d0 */
        0xcd, 0xce, 0xcf, 0xd2, 0xd3, 0xd4, 0xd5, 0xd9, /* d0 - d8 */
        0xda, 0xdb, 0xe3, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, /* d8 - e0 */
        0x80, 0xdf, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, /* e0 - e8 */
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, /* e8 - f0 */
        0x14, 0xb1, 0xf5, 0xfd, 0x9f, 0x15, 0xf7, 0x95, /* f0 - f8 */
        0xb0, 0xb7, 0x94, 0x93, 0x92, 0xb2, 0x91, 0x90, /* f8 - 100 */
	};

unsigned char dos_to_lower_xlate_cp_437[8] = {	/*United States code page*/
        0x81, /* u-umlaut */
        0x82, /* e-acute */
        0x84, /* a-umlaut */
        0x86, /* a-circle */
        0x87, /* c-cidilla */
        0x91, /* ae */
        0x94, /* o-umlaut */
        0xa4, /* n-anyay */
       	};

unsigned char dos_to_lower_xlate_cp_850[8] = {	/*Multilingual code page*/
        0x81, /* u-umlaut */
        0x82, /* e-acute */
        0x84, /* a-umlaut */
        0x86, /* a-circle */
        0x87, /* c-cidilla */
        0x91, /* ae */
        0x94, /* o-umlaut */
        0xa4, /* n-anyay */
       	};

unsigned char dos_to_lower_xlate_cp_860[8] = {	/* Portugal code page */
        0x81, /* u-umlaut */
        0x82, /* e-acute */
        0x84, /* a-anyay */
        0x8f, /* a-hat */
        0x87, /* c-cidilla */
        0x92, /* e-` */
        0x94, /* o-anyay */
        0xa4, /* n-anyay */
	};

unsigned char dos_to_lower_xlate_cp_863[8] = {	/*Canada-French code page*/
        0x81, /* u-umlaut */
        0x82, /* e-acute */
        0x85, /* a-` */
        0x8f, /* graphics */
        0x87, /* c-cidilla */
        0x88, /* e-^*/
        0x93, /* o-^ */
        0xa5, /* graphics */
	};

unsigned char dos_to_lower_xlate_cp_865[8] = {	/*Norway code page*/
        0x81, /* u-umlaut */
        0x82, /* e-acute */
        0x84, /* a-umlaut */
        0x86, /* a-circle */
        0x87, /* c-cidilla */
        0x91, /* ae */
        0x94, /* o-umlaut */
        0xa4, /* n-anyay */
	};

