/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright 2021 Tintri by DDN, Inc. All rights reserved.
 */

#ifndef _TEST_DATA_H
#define	_TEST_DATA_H

/*
 * Test data for the encrypt/decrypt tests.
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Don't use static data for a "nonce" in real life!
 */
char authdata[] = "Authentication16";
char keydata[]  = "The Key  Data 16";
char nonce[]    = "Noncedata11";

const char clear_data_ref[] =
	"\"The Road Not Taken\" by Robert Frost\n"
	"\n"
	"Two roads diverged in a yellow wood,\n"
	"And sorry I could not travel both\n"
	"And be one traveler, long I stood\n"
	"And looked down one as far as I could\n"
	"To where it bent in the undergrowth;\n"
	"Then took the other, as just as fair,\n"
	"And having perhaps the better claim\n"
	"Because it was grassy and wanted wear,\n"
	"Though as for that the passing there\n"
	"Had worn them really about the same,\n"
	"And both that morning equally lay\n"
	"In leaves no step had trodden black.\n"
	"Oh, I kept the first for another day!\n"
	"Yet knowing how way leads on to way\n"
	"I doubted if I should ever come back.\n"
	"I shall be telling this with a sigh\n"
	"Somewhere ages and ages hence:\n"
	"Two roads diverged in a wood, and I,\n"
	"I took the one less traveled by,\n"
	"And that has made all the difference.\n"
	"\n";

size_t clear_data_len = sizeof (clear_data_ref);

#define	CLEAR_DATA_LEN		765
#define	CIPHER_DATA_LEN		(CLEAR_DATA_LEN + 16)

// Cipher for the above, using CKM_AES_CCM

const uint8_t cipher_data_ccm[CIPHER_DATA_LEN] =
	"\x60\xcc\xb4\x54\x32\xa4\x45\x7f\x90\x4d\x27\x54\x9d\x0f\x06\x92"
	"\xff\x6f\x90\xe3\x5c\xcf\xdd\xed\x52\x51\x6a\x5f\x0d\x84\xe6\x4d"
	"\x3b\xae\x52\xe4\xdc\x20\xdd\xb6\xd5\x24\xc7\x7c\xbe\x08\xb7\xd8"
	"\x5c\x32\x95\x72\x9a\x7d\xd4\x02\xbb\xed\x8a\x0a\xbc\xc1\x97\x59"
	"\x44\x65\xab\x7a\xd7\xe9\x7d\x7e\x8f\x77\x8c\xc7\x62\x42\xb1\x42"
	"\xcd\x9e\x6e\x96\x1f\x57\x01\xba\x7d\x2b\xf5\x55\x0e\x61\x85\xeb"
	"\xd2\x33\x6a\xc2\xac\x42\xf7\xa4\x4d\xf4\xf5\xb3\x59\xe6\x9b\x7c"
	"\x37\x01\x71\x24\x92\x1a\x14\xf7\x7f\x37\x92\x0f\x34\x0c\xbc\xf8"
	"\x02\x95\x88\xa5\xed\xc7\x1c\x6c\x68\xe7\x10\x43\xde\x1e\x35\x77"
	"\x1c\xae\x4a\x12\xdf\x3d\x88\x7a\xf8\x59\xb9\xfc\x54\x2a\x94\x3b"
	"\x59\xcf\xd7\x85\x35\x37\x35\x43\xb5\x3e\xb6\xa2\xc4\x27\x7e\x92"
	"\xd5\x68\x8d\xe8\xfb\x13\xa7\x65\xa1\x81\xf3\x18\xc4\xe7\xee\x3a"
	"\x19\x3c\xd6\xde\xd2\x8e\xfd\xce\x97\xb4\xe9\xc0\x7d\x64\x5d\x15"
	"\x1a\x50\x43\x66\xcb\x62\xc0\xa2\x77\x33\x1e\x59\xea\x6c\x65\x9e"
	"\x78\xda\x9d\xb4\x35\x78\x06\x5d\xef\x7f\x78\x13\xa5\xa0\x94\x23"
	"\x4d\x95\x07\x46\xc1\x42\x07\xa5\x2f\xb3\xc2\xe0\x80\x83\x35\x93"
	"\xaf\x40\x48\x9f\x86\xf3\x7d\x96\xca\x4a\xba\x84\x9b\xec\x9e\x02"
	"\xba\x89\x6e\x5e\x9b\x7b\x6b\x38\xf7\xf3\xf7\xd3\xeb\x33\xe6\x8c"
	"\x94\xaa\x58\x11\x19\xfd\xed\x88\xea\x08\x69\x8f\x7f\x50\xde\x69"
	"\x2f\x6b\x75\xa1\x8e\xbc\x17\x03\x58\xd5\xb5\x02\x18\x4e\xde\xa7"
	"\xe1\xde\x30\xfa\x61\x2a\xee\x21\x85\xe7\x13\x14\x3a\x45\xd0\x8b"
	"\xc7\x20\x38\x2c\xc2\xdd\x05\x95\xde\x42\x02\xb6\xad\x2e\x24\xeb"
	"\x68\x31\x56\xa8\x80\x5a\x4f\xd7\x9d\x5f\x91\xf6\x3d\x8c\xb1\x21"
	"\x82\x3a\x35\xea\x38\x1d\xb7\x1a\x0e\x7a\xa0\x2b\x8d\x23\x55\xd4"
	"\x2e\x78\x26\x08\x0b\xab\xc1\x53\xf3\xc8\xa0\x96\x88\x5d\x6b\x37"
	"\x33\xc0\xbc\x30\xd3\x26\x4e\xb2\xb1\x66\x45\x08\xc0\x92\xfc\x0b"
	"\x6c\xc2\x40\x2b\x6b\x16\xf2\x14\x09\xdd\x2c\xb3\x8c\xdf\x17\x4e"
	"\xd6\x02\x63\x6e\x94\x50\x5f\xfa\x05\x0d\x44\x1c\xbf\x84\x16\xfe"
	"\xdd\x7c\x04\xa1\x77\x6b\x31\x42\xdb\xf8\x7a\xe1\x81\x5c\x8b\xc7"
	"\xa5\x8f\xde\x42\xca\x0f\x5e\xd6\xc0\x11\x32\xe0\x51\x02\xb3\x10"
	"\x82\xa7\xa0\xd0\xfa\x0d\x8d\xca\x04\x9d\x1e\x92\x81\x70\xc1\xd5"
	"\x11\xfc\x0d\x0e\x51\x73\x60\x87\xeb\x4b\xec\x0d\xa2\x4b\x18\x0f"
	"\xe3\x56\xff\xfc\x6b\x30\x6a\x71\x26\xea\x86\xe8\xf6\xfa\x5f\xa2"
	"\xe7\x65\xb7\x62\xa1\x86\x97\x7b\x86\x17\xc6\x90\x10\xe6\x17\x92"
	"\xee\x19\xb5\x4f\xfe\xf6\xeb\xa9\xa9\xb1\x5b\xa1\xa0\xb9\x7c\x76"
	"\xda\xb9\x4f\x45\xfe\x59\xde\x0b\x56\x31\x36\xbc\x3b\x12\x2d\x0b"
	"\x15\x85\x82\x1b\x6c\xcb\xbe\xe4\xa1\xdc\x59\x5c\xd0\x56\xb8\xc7"
	"\xd9\x5c\xfb\x94\x8d\x31\x34\xe6\x37\x8f\xf9\x79\x5f\x72\x28\x05"
	"\xf4\xe9\x59\x5e\x17\x91\x98\xcd\xbf\xf3\x07\xc7\x4d\x76\x64\x0f"
	"\xd6\xc5\x5b\xbd\xf8\xe8\x15\x03\xdc\xf4\x7c\x70\x0e\xea\x68\x3e"
	"\xf7\xa9\x0f\x78\x3c\x68\x4c\x66\x3b\x13\x25\xf5\xb3\xd6\xbb\x90"
	"\x71\xeb\xaf\x6e\x5e\x6a\x3b\x68\xe1\xd3\x41\xae\x62\x0b\xf8\x9d"
	"\xd4\xb5\xc8\x17\x83\xf6\x8e\x92\x3a\x67\x96\xeb\x03\x57\x62\xb1"
	"\x8e\x32\x3b\x79\x0f\x42\x37\x93\x6d\x3e\x1c\xf1\xdd\xd6\xd5\x51"
	"\xb3\x59\x1f\x2a\x2d\x9d\x38\x2a\x6f\x4a\xb9\x32\x3c\xb2\x69\xc3"
	"\x45\xdd\x9e\x19\x38\xb4\xcc\xe8\x95\xd2\x8b\x92\x6e\x4d\xe2\xc2"
	"\x8d\xe6\x99\xba\xa0\x24\x21\xcd\x6a\x8c\x85\xd5\xa7\x36\xac\x49"
	"\x0b\xe3\xfa\x8b\x48\xff\xda\x80\x68\x08\x69\x17\x76"
/* This is the MAC (last 16 bytes) */
	"\xd7\xcc\xfb\xab\x9c\x60\xb8\x7b\x2e\xa2\x57\xaa\x11\xdf\x63\x52"
	;

// Cipher for the above, using CKM_AES_GCM

const uint8_t cipher_data_gcm[CIPHER_DATA_LEN] =
	"\x8b\xf4\x04\xaa\xd4\x9e\x61\xc1\xb7\x5a\x68\x42\x59\x13\xcd\xf9"
	"\x8b\x0c\x31\x4c\x13\xfd\xbf\xc9\x7d\x9f\xe0\x3e\x8c\x1a\xfb\x2c"
	"\xf5\x4c\x47\x37\x01\x2c\x5f\xa1\x07\x12\xd5\x46\x59\x3c\x94\x28"
	"\x60\x71\xb9\x74\x9b\xfa\x33\xa4\x87\xa0\xd6\x1a\xce\xf3\x5b\x19"
	"\xf4\xc7\x9e\xb8\x22\xe0\xfb\xf3\x44\x43\x47\x25\x14\x66\xb3\x95"
	"\xca\xa0\xd7\x55\x08\x0b\xaf\x45\x75\xa6\x95\x22\x0a\x28\xeb\xf9"
	"\x5d\xbe\x8e\xb0\x56\x48\x68\x4c\x52\xbf\x5b\xec\xad\x65\x5d\xa6"
	"\x28\x68\xeb\xdf\x55\x31\xc2\x0d\xef\xe4\xec\x85\x84\x56\xda\xa3"
	"\x1d\x84\x98\x64\xf4\x54\xb6\x9b\x23\xc4\x09\x51\x40\xe3\xd6\x48"
	"\x85\xaf\x89\x47\xb6\xdf\x00\x94\x98\x12\x36\x34\xb8\xa2\xcd\x3a"
	"\xc8\x75\xde\x4f\xcb\x02\x19\x91\x7a\x8e\xbc\x53\x85\x43\xbe\xae"
	"\xeb\x6c\x17\xef\xd4\x89\x61\x66\x87\x33\xe4\x8d\xc0\x55\xb6\xfc"
	"\x29\x88\x1b\x01\x1f\x9d\xfc\xdb\x04\x55\xaf\xa1\xb8\x91\x72\x83"
	"\x41\x73\x3d\x5b\x87\x7d\xed\x90\x06\x62\x0e\xf1\xdf\x9e\x73\xdd"
	"\x12\xdb\x3f\x9f\x07\x66\x60\x8b\x8c\xea\x38\xc8\xf5\x63\x98\x0e"
	"\x37\x69\xa9\x6a\x3c\x03\xe9\x0a\x16\x81\x44\xb9\xa5\xb3\x42\x19"
	"\x42\x93\x97\x5f\xc6\x26\x37\xab\x47\x65\x1b\x30\x73\x1b\x60\x4c"
	"\x24\x43\xe7\xa6\x19\x24\x70\x75\xb3\xa6\x2d\x1e\xfe\xa7\xa8\xc0"
	"\x63\x56\x2c\x48\x8c\x2f\xa9\x8b\x2e\xca\x01\xff\x84\xb8\xd5\x39"
	"\x44\x61\xcb\xd7\x6d\xfd\x50\xb1\x63\x92\x9b\x1e\x9f\x79\x5b\x1a"
	"\x98\x12\x82\x84\x18\xa3\x9f\x9c\xfa\xee\xd9\x66\x54\x1b\x62\x04"
	"\x23\x08\x52\xe0\x8b\xf0\xc1\x64\x05\x3f\xf5\xf8\xa5\x0f\x13\x9e"
	"\x80\x3b\xb6\x3c\xbb\x68\xb2\xad\xad\x09\xf5\x68\x62\x24\xc9\x27"
	"\x5c\x27\xb0\xdd\x84\xde\x65\xef\xa1\xcc\xd6\x8b\x9c\x5a\x6a\x9f"
	"\x87\xc1\xd5\xdf\xd8\x50\x33\x87\xce\x3d\x2f\x28\x2b\x60\x88\xd3"
	"\xac\x19\x03\x65\x26\xc5\x5d\x09\xb3\xc4\x07\x9b\x04\x11\x4b\xc1"
	"\x33\xc9\x7c\x45\xc5\xeb\x7f\xa9\xb6\xb4\x1a\x90\x53\x94\xe4\xe9"
	"\xb6\xa5\x48\x77\xc4\xc5\x72\xed\x70\x00\x14\x34\x80\x18\x92\x9b"
	"\x38\x18\x86\x03\x76\x38\x36\xf4\xcf\xac\x74\x3e\xaf\xa8\x06\x7d"
	"\x04\xb4\x57\xdc\x88\x04\xb6\xee\x41\x0e\xda\x9c\xc3\x65\xe9\x23"
	"\xb2\xed\xd3\x7b\xd4\x7f\x28\x36\xe7\x37\x83\x5c\x9e\xfa\xb9\x17"
	"\x8b\xb6\xbe\x9f\xe3\x72\x25\x80\x42\x6f\xd7\xd6\xc5\x66\x20\x5c"
	"\xfe\xc8\xcd\x16\x1b\x6b\xbb\xf0\x1f\x88\xd7\xfa\x2d\xe4\x6f\xa4"
	"\xf5\x48\x85\x33\x65\x39\x2b\xef\xe8\x3d\xd2\x30\x48\xed\xde\x45"
	"\x0b\xb0\xf3\x54\x5b\xff\x37\x41\xc3\x6c\x62\x53\x33\x42\x59\x04"
	"\xbb\x5e\xcf\x5f\x69\x00\xf5\xa8\x23\xdb\x5b\xc9\x10\xe6\x4f\x9e"
	"\x38\xfd\xb1\x1b\x4a\x35\xe4\xf1\x91\x1d\x01\xaa\x1b\x99\xfc\x5c"
	"\x88\xcb\x78\xb8\xc9\x9b\x45\xba\x29\x12\x50\x7f\xe2\xa0\x52\xcd"
	"\xe9\xc2\x34\xbe\x94\xf9\xc6\x84\xe2\x3e\x60\xdc\x39\xc0\x23\xa8"
	"\xa3\x31\xc1\x9b\x7e\x09\x70\x4f\x59\xd6\x37\x76\xda\x93\x39\x42"
	"\xd0\xba\xc8\xb0\xd7\xe4\x7c\xd3\x52\x28\x46\x9e\x3d\x9e\x2a\xb2"
	"\x96\x92\xcf\xc6\x6f\x99\x50\x21\x93\x57\x80\x37\x7c\xb8\x79\x7f"
	"\xed\xb0\xcd\x3c\x02\xa7\xa6\x9b\xf9\xa3\x0c\xcc\x5a\x40\x79\x76"
	"\xf5\xc9\x0d\xcf\xa8\x9b\xb3\x8b\xcd\x29\x31\x8c\x90\x89\x92\x7b"
	"\x38\x18\x54\x6b\xee\x25\xee\x91\xab\x3b\xf7\x6c\xee\x8e\x30\xad"
	"\xf0\x3c\xac\x04\x3f\xac\x39\x2f\xee\x12\x06\x11\x89\xc6\xd6\x6c"
	"\xc4\x7c\xa6\x1f\x4f\x5c\x40\x79\x8a\xd8\xe2\x48\x6d\xa7\x32\xd7"
	"\x52\x92\x57\x9e\xc7\x17\x59\x92\xdb\xa4\x22\x21\x8f"
/* This is the MAC (last 16 bytes) */
	"\xd6\xa2\xca\x10\x72\x15\x82\xe7\x02\x8c\x3f\xa3\x77\x2a\x42\x13"
	;

#ifdef __cplusplus
}
#endif

#endif /* _TEST_DATA_H */
