/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_EVENT_MESS_H
#define	_EVENT_MESS_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * event_mess.h
 *
 *  RSC Event Messages Header File.
 *
 * Caution: This file was generated by
 * ../../src/util/createRSCMessages and event_messages.txt.
 *
 */

static char *ps_event_alerts[] = {
	"Power Supply 1 Failure.",			/* PS1_FAIL */
	"Power Supply 1 OK.",				/* PS1_OK */
	"Power Supply 2 Failure.",			/* PS2_FAIL */
	"Power Supply 2 OK.",				/* PS2_OK */
	"Power Supply General Failure.",		/* PS_GENERAL_FAIL */
	"Power Supply 3 Failure.",			/* PS3_FAIL */
	"Power Supply 3 OK.",				/* PS3_OK */
	"Power Supply 0 Failure.",			/* PS0_FAIL */
	"Power Supply 0 OK.",				/* PS0_OK */
	"Power Supply 0 AC Power Unavailable.",		/* PS0_UNPLUGGED */
	"Power Supply 1 AC Power Unavailable.",		/* PS1_UNPLUGGED */
	"Power Supply 2 AC Power Unavailable.",		/* PS2_UNPLUGGED */
	"Power Supply 3 AC Power Unavailable.",		/* PS3_UNPLUGGED */
	"Power Supply 1 Fault.",			/* PS1_FAULT */
	"Power Supply 2 Fault.",			/* PS2_FAULT */
	"Power Supply 3 Fault.",			/* PS3_FAULT */
	"Power Supply 0 Fault.",			/* PS0_FAULT */
	"PS%s was removed from system.",		/* PS_REMOVED */
	NULL
};



static char *disk_event_alerts[] = {
	"Disk 0 Failure.",			/* DISK0_FAILURE */
	"Disk 0 OK.",				/* DISK0_OK */
	"Disk 1 Failure.",			/* DISK1_FAILURE */
	"Disk 1 OK.",				/* DISK1_OK */
	"Disk 2 Failure.",			/* DISK2_FAILURE */
	"Disk 2 OK.",				/* DISK2_OK */
	"Disk 3 Failure.",			/* DISK3_FAILURE */
	"Disk 3 OK.",				/* DISK3_OK */
	"Disk 4 Failure.",			/* DISK4_FAILURE */
	"Disk 4 OK.",				/* DISK4_OK */
	"Disk 5 Failure.",			/* DISK5_FAILURE */
	"Disk 5 OK.",				/* DISK5_OK */
	"Disk 6 Failure.",			/* DISK6_FAILURE */
	"Disk 6 OK.",				/* DISK6_OK */
	"Disk 7 Failure.",			/* DISK7_FAILURE */
	"Disk 7 OK.",				/* DISK7_OK */
	"Disk 8 Failure.",			/* DISK8_FAILURE */
	"Disk 8 OK.",				/* DISK8_OK */
	"Disk 9 Failure.",			/* DISK9_FAILURE */
	"Disk 9 OK.",				/* DISK9_OK */
	"Disk 10 Failure.",			/* DISK10_FAILURE */
	"Disk 10 OK.",				/* DISK10_OK */
	"Disk 11 Failure.",			/* DISK11_FAILURE */
	"Disk 11 OK.",				/* DISK11_OK */
	"HDD%s was removed from system.",	/* DISK_REMOVED */
	"HDD%s was inserted into system.",	/* DISK_INSERTED */
	NULL
};



static char *temp_event_alerts[] = {
	"CPU0 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",		/* CPU0_MIN_TEMP */
	"CPU0 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU0_WARNING */
	"CPU0 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU0_SHUTDOWN */
	"CPU0 Temperature Normal.",		/* CPU0_OK */
	"CPU1 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",		/* CPU1_MIN_TEMP */
	"CPU1 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU1_WARNING */
	"CPU1 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU1_SHUTDOWN */
	"CPU1 Temperature Normal.",		/* CPU1_OK */
	"MB0 Thermal Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* MB0_MIN_TEMP */
	"MB0 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* MB0_WARNING */
	"MB0 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* MB0_SHUTDOWN */
	"MB0 Temperature Normal.",		/* MB0_OK */
	"MB1 Thermal Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* MB1_MIN_TEMP */
	"MB1 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* MB1_WARNING */
	"MB1 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* MB1_SHUTDOWN */
	"MB1 Temperature Normal.",		/* MB1_OK */
	"PDB Thermal Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* PDB_MIN_TEMP */
	"PDB Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* PDB_WARNING */
	"PDB exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* PDB_SHUTDOWN */
	"PDB Temperature Normal.",		/* PDB_OK */
	"SCSI Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* SCSI_MIN_TEMP */
	"SCSI Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* SCSI_WARNING */
	"SCSI exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* SCSI_SHUTDOWN */
	"SCSI Temperature Normal.",		/* SCSI_OK */
	"SC Ambient Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* RSC_MIN_TEMP */
	"SC Ambient Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* RSC_WARNING */
	"SC exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* RSC_SHUTDOWN */
	"SC Temperature Normal.",		/* RSC_OK */
	"CPU2 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* CPU2_MIN_TEMP */
	"CPU2 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU2_WARNING */
	"CPU2 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU2_SHUTDOWN */
	"CPU2 Temperature Normal.",		/* CPU2_OK */
	"CPU3 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* CPU3_MIN_TEMP */
	"CPU3 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU3_WARNING */
	"CPU3 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU3_SHUTDOWN */
	"CPU3 Temperature Normal.",		/* CPU3_OK */
	"CPU4 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* CPU4_MIN_TEMP */
	"CPU4 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU4_WARNING */
	"CPU4 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU4_SHUTDOWN */
	"CPU4 Temperature Normal.",		/* CPU4_OK */
	"CPU5 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* CPU5_MIN_TEMP */
	"CPU5 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU5_WARNING */
	"CPU5 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU5_SHUTDOWN */
	"CPU5 Temperature Normal.",		/* CPU5_OK */
	"CPU6 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* CPU6_MIN_TEMP */
	"CPU6 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU6_WARNING */
	"CPU6 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU6_SHUTDOWN */
	"CPU6 Temperature Normal.",		/* CPU6_OK */
	"CPU7 Thermal Minimum Temperature Alert. Temperature equals %s "
	    "Celsius.",				/* CPU7_MIN_TEMP */
	"CPU7 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* CPU7_WARNING */
	"CPU7 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* CPU7_SHUTDOWN */
	"CPU7 Temperature Normal.",		/* CPU7_OK */
	"IO Thermal Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* IO_MIN_TEMP */
	"IO Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* IO_WARNING */
	"IO exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* IO_SHUTDOWN */
	"IO Temperature Normal.",		/* IO_OK */
	"BP0 Thermal Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* BP0_MIN_TEMP */
	"BP0 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* BP0_WARNING */
	"BP0 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* BP0_SHUTDOWN */
	"BP0 Temperature Normal.",		/* BP0_OK */
	"BP1 Thermal Minimum Temperature Alert. Temperature equals %s Celsius.",
	    /* BP1_MIN_TEMP */
	"BP1 Thermal Warning Threshold Alert. Temperature equals %s Celsius.",
	    /* BP1_WARNING */
	"BP1 exceeds shutdown temperature. Temperature equals %s Celsius.",
	    /* BP1_SHUTDOWN */
	"BP1 Temperature Normal.",		/* BP1_OK */
	NULL
};



static char *user_event_alerts[] = {
	"%s",				/* USER_WARNING */
	"%s",				/* USER_CRITICAL */
	"SC Test Pager Alert",		/* USER_TEST_PAGE */
	"TEST PROGRAM BEGINNING",	/* USER_TEST_START */
	"TEST PROGRAM EXITING",		/* USER_TEST_END */
	NULL
};



static char *system_event_alerts[] = {
	"SC Request to Power Off Host.",	/* POWER_OFF */
	"SC Request to Power On Host.",		/* POWER_ON */
	"Host System has Reset",		/* SYSTEM_RESET */
	"%s",					/* SYSTEM_GEN_ERROR */
	"System Fan OK",			/* SYSTEM_FAN_OK */
	"System Fan Failure",			/* SYSTEM_FAN_FAILURE */
	"SC set bootmode to normal.",		/* SYSTEM_SET_BOOTMODE_NORMAL */
	"SC set bootmode to forth, will expire %s.",
	    /* SYSTEM_SET_BOOTMODE_FORTH */
	"SC set bootmode to reset_nvram, will expire %s.",
	    /* SYSTEM_SET_BOOTMODE_RESET_NVRAM */
	"SC set bootmode to diag, will expire %s.",
	    /* SYSTEM_SET_BOOTMODE_DIAG */
	"SC set bootmode to skip_diag, will expire %s.",
	    /* SYSTEM_SET_BOOTMODE_SKIP_DIAG */
	"Host System has read and cleared bootmode.",
	    /* SYSTEM_SET_BOOTMODE_CLEAR */
	"SC Environment Poller: Cannot open i2c device",
	    /* SYSTEM_I2C_ERROR */
	"SC Environment Poller disabled",	/* SYSTEM_POLLER_OFF */
	"SC Request to Power Off Host Immediately.",
	    /* POWER_OFF_NOW */
	"CPU Primary Fan OK",			/* SYSTEM_CPU_P_FAN_OK */
	"CPU Primary Fan Failure",		/* SYSTEM_CPU_P_FAN_FAILURE */
	"CPU Secondary Fan OK",			/* SYSTEM_CPU_S_FAN_OK */
	"CPU Secondary Fan Failure",		/* SYSTEM_CPU_S_FAN_FAILURE */
	"IO Primary Fan OK",			/* SYSTEM_IO_P_FAN_OK */
	"IO Primary Fan Failure",		/* SYSTEM_IO_P_FAN_FAILURE */
	"IO Secondary Fan OK",			/* SYSTEM_IO_S_FAN_OK */
	"IO Secondary Fan Failure",		/* SYSTEM_IO_S_FAN_FAILURE */
	"IO Bridge Primary Fan OK",		/* SYSTEM_IO_BRIDGE_P_FAN_OK */
	"IO Bridge Primary Fan Failure",
	    /* SYSTEM_IO_BRIDGE_P_FAN_FAILURE */
	"IO Bridge Secondary Fan OK",		/* SYSTEM_IO_BRIDGE_S_FAN_OK */
	"IO Bridge Secondary Fan Failure",
	    /* SYSTEM_IO_BRIDGE_S_FAN_FAILURE */
	"CPU Fan OK",				/* SYSTEM_CPU_FAN_OK */
	"Fan Tray 0 CPU Fan 1 OK",		/* SYSTEM_CPU0_FAN_OK */
	"Fan Tray 0 CPU Fan 2 OK",		/* SYSTEM_CPU1_FAN_OK */
	"CPU Fan Failure",			/* SYSTEM_CPU_FAN_FAILURE */
	"Fan Tray 0 CPU Fan 1 Failure",		/* SYSTEM_CPU0_FAN_FAILURE */
	"Fan Tray 0 CPU Fan 2 Failure",		/* SYSTEM_CPU1_FAN_FAILURE */
	"IO Fan OK",				/* SYSTEM_IO_FAN_OK */
	"Fan Tray 1 IO Fan 0 OK",		/* SYSTEM_IO0_FAN_OK */
	"Fan Tray 1 IO Fan 1 OK",		/* SYSTEM_IO1_FAN_OK */
	"IO Fan Failure",			/* SYSTEM_IO_FAN_FAILURE */
	"Fan Tray 1 IO Fan 0 Failure",		/* SYSTEM_IO0_FAN_FAILURE */
	"Fan Tray 1 IO Fan 1 Failure",		/* SYSTEM_IO1_FAN_FAILURE */
	"Fan Tray 0 CPU Fan 0 OK",		/* SYSTEM_MB_FAN_OK */
	"Fan Tray 0 CPU Fan 0 Failure",		/* SYSTEM_MB_FAN_FAILURE */
	"Host system has shut down.",		/* SYSTEM_DOWN */
	"CPU 0 Fan 0 OK",			/* SYSTEM_EN_CPU0_FAN0_OK */
	"CPU 0 Fan 1 OK",			/* SYSTEM_EN_CPU0_FAN1_OK */
	"CPU 1 Fan 0 OK",			/* SYSTEM_EN_CPU1_FAN0_OK */
	"CPU 1 Fan 1 OK",			/* SYSTEM_EN_CPU1_FAN1_OK */
	"CPU 0 Fan 0 Failure",
	    /* SYSTEM_EN_CPU0_FAN0_FAILURE */
	"CPU 0 Fan 1 Failure",
	    /* SYSTEM_EN_CPU0_FAN1_FAILURE */
	"CPU 1 Fan 0 Failure",
	    /* SYSTEM_EN_CPU1_FAN0_FAILURE */
	"CPU 1 Fan 1 Failure",
	    /* SYSTEM_EN_CPU1_FAN1_FAILURE */
	"Enclosure Fan 0 OK",			/* SYSTEM_EN_FAN0_OK */
	"Enclosure Fan 1 OK",			/* SYSTEM_EN_FAN1_OK */
	"Enclosure Fan 2 OK",			/* SYSTEM_EN_FAN2_OK */
	"Enclosure Fan 3 OK",			/* SYSTEM_EN_FAN3_OK */
	"Enclosure Fan 0 Failure",		/* SYSTEM_EN_FAN0_FAILURE */
	"Enclosure Fan 1 Failure",		/* SYSTEM_EN_FAN1_FAILURE */
	"Enclosure Fan 2 Failure",		/* SYSTEM_EN_FAN2_FAILURE */
	"Enclosure Fan 3 Failure",		/* SYSTEM_EN_FAN3_FAILURE */
	"SCC has been inserted.",		/* SYSTEM_SCC_INSERT */
	"SCC has been removed.",		/* SYSTEM_SCC_REMOVE */
	"SCC is not valid.",			/* SYSTEM_SCC_INVALID */
	NULL
};



static char *keyswitch_event_alerts[] = {
	"KeySwitch Position has changed to Locked State.",
	    /* KEYSWITCH_LOCKED */
	"KeySwitch Position has changed to Off State.",	/* KEYSWITCH_OFF */
	"KeySwitch Position has changed to On State.",	/* KEYSWITCH_ON */
	"KeySwitch Position has changed to Diagnostics State.",
	    /* KEYSWITCH_DIAG */
	"Keyswitch Broken?",				/* KEYSWITCH_BROKEN */
	NULL
};



static char *rsc_event_alerts[] = {
	"SC Login: User %s Logged on.",			/* RSC_LOGIN */
	"SC Login Failure for user %s.",		/* RSC_LOGIN_FAILURE */
	"SC Login: User %s Logged out.",		/* RSC_LOGOUT */
	"SC System booted.",				/* RSC_BOOT */
	"SC Request to Reset Host.",
	    /* RSC_RESET_HOST_COMMAND */
	"SC NVRAM Update: %s has been modified.",	/* RSC_NVRAM_UPDATE */
	"Failed to send page alert for recent event.",	/* RSC_PAGER_FAILURE */
	"Failed to send email alert for recent event.",	/* RSC_EMAIL_FAILURE */
	"DHCP network configuration initiated.",	/* RSC_DHCP_INIT */
	"DHCP configuration complete (from server %s).",
	    /* RSC_DHCP_COMPLETE */
	"DHCP lease lost.",				/* RSC_DHCP_LEASELOST */
	"SC Request to send Break to host.",		/* RSC_BREAK_COMMAND */
	"SC date/time has been set to %s.",		/* RSC_DATE_CHANGED */
	"SC Battery Voltage is low.",			/* RSC_BATTERY_LOW */
	"SC No modem card detected!",			/* RSC_CARD_DETECT */
	"SC Modem could not get phone line.",
	    /* RSC_MODEM_LINE_ERROR */
	"SC Could not communicate with modem.",		/* RSC_MODEM_ERROR */
	"SC Could not communicate with paging service.",
	    /* RSC_PAGE_SVC_ERROR */
	"SC Operating on battery Power.",		/* RSC_BATTERY_POWER */
	"Failed to send email alert to the primary mailserver.",
	    /* RSC_MAILSERVER_FAILURE */
	"SC Request to Reset Host due to Watchdog",
	    /* RMC_RESET_HOST_WDOG */
	"Preceding SC reset due to watchdog",
	    /* RMC_RESET_SELF_WDOG */
	"SC Request to execute XIR Reset on the Host.",
	    /* RMC_XIR_HOST_COMMAND */
	"SC Request to XIR Host due to Watchdog",	/* RMC_XIR_HOST_WDOG */
	"SC Request to Reset Host due to no Reset since Watchdog XIR",
	    /* RMC_XIR_RESET_HOST_WDOG */
	NULL
};



static char *debug_event_alerts[] = {
	"I2C Ioctl Enter",			/* I2C_IOCTL_ENTER */
	"%s",					/* DRIVER_MESSAGE */
	"%s",					/* DRIVER_ERROR */
	"i2cIoctl: NAK ERROR",			/* DRIVER_NAK_ERROR */
	"i2cIoctl: UNDERRUN ERROR",		/* DRIVER_UNDERRUN_ERROR */
	"i2cIoctl: COLLISION ERROR",		/* DRIVER_COLLISION_ERROR */
	"i2cIoctl: OVERRUN ERROR",		/* DRIVER_OVERRUN_ERROR */
	"%s",					/* DRIVER_RXBD_ERROR */
	"i2cIoctl: BUSY ERROR",			/* DRIVER_RXBD_BUSY */
	"%s",					/* M68360_IOCTL */
	"I2C ERROR Reading NVRAM",		/* NVRAM_READ_ERROR */
	"I2C ERROR Writing NVRAM",		/* NVRAM_WRITE_ERROR */
	"%s",					/* I2C_LIB_DEBUG */
	"%s",					/* EVENT_SUBSYSTEM_ERROR */
	"%s",					/* NETCONFIG_ERROR */
	"%s",					/* FRU_DEBUG */
	"%s",					/* CPU_SIG_DEBUG */
	"%s",					/* VTS_LED_TEST */
	NULL
};




static char **rsc_alerts[] = {
	ps_event_alerts,
	disk_event_alerts,
	temp_event_alerts,
	user_event_alerts,
	system_event_alerts,
	keyswitch_event_alerts,
	rsc_event_alerts,
	debug_event_alerts
};



enum event_severities {
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL
};

static int ps_events_severity[] = {
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR
};



static int disk_events_severity[] = {
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR
};



static int temp_events_severity[] = {
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR
};



static int user_events_severity[] = {
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR
};



static int system_events_severity[] = {
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR
};



static int keyswitch_events_severity[] = {
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR
};



static int rsc_events_severity[] = {
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_CRITICAL,
	EVENT_SEVERITY_MINOR
};



static int debug_events_severity[] = {
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MAJOR,
	EVENT_SEVERITY_MINOR,
	EVENT_SEVERITY_MINOR
};


static int *severity[] = {
	ps_events_severity,
	disk_events_severity,
	temp_events_severity,
	user_events_severity,
	system_events_severity,
	keyswitch_events_severity,
	rsc_events_severity,
	debug_events_severity
};

#ifdef	__cplusplus
}
#endif

#endif /* _EVENT_MESS_H */
