
/*
 * kadmin/ldap_util/kdb5_ldap_list.h
 */

/* Copyright (c) 2004-2005, Novell, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *   * The copyright holder's name is not used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _KDB5_LDAP_LIST_H_
#define _KDB5_LDAP_LIST_H_

#define MAX_LIST_ENTRIES	64
#define END_OF_LIST		-1      /* End of List */
#define LIST_DELIMITER		":"     /* List entry separator */
#define LIST_MODE_ADD 		0x701   /* Add to the List */
#define LIST_MODE_DELETE 	0x702   /* Delete from the list */
#define MAX_LEN_LIST_ENTRY 	512     /* Max len of an entry */

extern krb5_error_code krb5_parse_list(char *buffer, char *delimiter, char **list);
extern void krb5_free_list_entries(char **list);
extern void list_modify_str_array(char ***destlist, const char **sourcelist, int mode);
extern int list_modify_int_array(int *destlist, const int *sourcelist, int mode);
extern int list_count_str_array(char **list);
extern int list_count_int_array(int *list);
extern int compare_int(const void*, const void *);

#endif /* _KDB5_LDAP_LIST_H_ */
