/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2010 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ipath.h -- public definitions for ipath module
 *
 */

#ifndef	_EFT_IPATH_H
#define	_EFT_IPATH_H

#ifdef	__cplusplus
extern "C" {
#endif

void ipath_init(void);
const struct ipath *ipath(struct node *np);
void ipathlastcomp(const struct ipath *ipp);
char *ipath2str(const char *ename, const struct ipath *ipp);
size_t ipath2strlen(const char *ename, const struct ipath *ipp);
void ipath_print(int flags, const char *ename, const struct ipath *ipp);
void ipath_fini(void);

#ifdef	__cplusplus
}
#endif

#endif	/* _EFT_IPATH_H */
