/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_BENV_H
#define	_BENV_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <errno.h>
#include <fcntl.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>

#define	NO_PERROR	0
#define	PERROR		1

typedef struct eplist {
	struct eplist *next;
	struct eplist *prev;
	void *item;
} eplist_t;

extern char *progname;
extern char *boottree;
extern struct utsname uts_buf;
extern int _error(int do_perror, char *fmt, ...);
extern char *strcats(char *s, ...);
extern eplist_t *new_list(void);
extern void add_item(void *item, eplist_t *list);

#ifdef	__cplusplus
}
#endif

#endif /* _BENV_H */
