/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright (c) 2019 by Chelsio Communications, Inc.
 */

#ifndef __CUDBG_VIEW_ENTITY_H__
#define __CUDBG_VIEW_ENTITY_H__

#include "cudbg_entity.h"

static const char * const memory[] = { "EDC0:", "EDC1:", "MC:",
	"MC0:", "MC1:", "HMA:"};

static const char * const lb_stat_name[] = {
	"OctetsOK:", "FramesOK:", "BcastFrames:", "McastFrames:",
	"UcastFrames:", "ErrorFrames:", "Frames64:", "Frames65To127:",
	"Frames128To255:", "Frames256To511:", "Frames512To1023:",
	"Frames1024To1518:", "Frames1519ToMax:", "FramesDropped:",
	"BG0FramesDropped:", "BG1FramesDropped:", "BG2FramesDropped:",
	"BG3FramesDropped:", "BG0FramesTrunc:", "BG1FramesTrunc:",
	"BG2FramesTrunc:", "BG3FramesTrunc:"
};


static struct field_desc tp_la0[] = {
	{ "RcfOpCodeOut", 60, 4 },
	{ "State", 56, 4 },
	{ "WcfState", 52, 4 },
	{ "RcfOpcSrcOut", 50, 2 },
	{ "CRxError", 49, 1 },
	{ "ERxError", 48, 1 },
	{ "SanityFailed", 47, 1 },
	{ "SpuriousMsg", 46, 1 },
	{ "FlushInputMsg", 45, 1 },
	{ "FlushInputCpl", 44, 1 },
	{ "RssUpBit", 43, 1 },
	{ "RssFilterHit", 42, 1 },
	{ "Tid", 32, 10 },
	{ "InitTcb", 31, 1 },
	{ "LineNumber", 24, 7 },
	{ "Emsg", 23, 1 },
	{ "EdataOut", 22, 1 },
	{ "Cmsg", 21, 1 },
	{ "CdataOut", 20, 1 },
	{ "EreadPdu", 19, 1 },
	{ "CreadPdu", 18, 1 },
	{ "TunnelPkt", 17, 1 },
	{ "RcfPeerFin", 16, 1 },
	{ "RcfReasonOut", 12, 4 },
	{ "TxCchannel", 10, 2 },
	{ "RcfTxChannel", 8, 2 },
	{ "RxEchannel", 6, 2 },
	{ "RcfRxChannel", 5, 1 },
	{ "RcfDataOutSrdy", 4, 1 },
	{ "RxDvld", 3, 1 },
	{ "RxOoDvld", 2, 1 },
	{ "RxCongestion", 1, 1 },
	{ "TxCongestion", 0, 1 },
	{ NULL }
};

static struct field_desc tp_la1[] = {
	{ "CplCmdIn", 56, 8 },
	{ "CplCmdOut", 48, 8 },
	{ "ESynOut", 47, 1 },
	{ "EAckOut", 46, 1 },
	{ "EFinOut", 45, 1 },
	{ "ERstOut", 44, 1 },
	{ "SynIn", 43, 1 },
	{ "AckIn", 42, 1 },
	{ "FinIn", 41, 1 },
	{ "RstIn", 40, 1 },
	{ "DataIn", 39, 1 },
	{ "DataInVld", 38, 1 },
	{ "PadIn", 37, 1 },
	{ "RxBufEmpty", 36, 1 },
	{ "RxDdp", 35, 1 },
	{ "RxFbCongestion", 34, 1 },
	{ "TxFbCongestion", 33, 1 },
	{ "TxPktSumSrdy", 32, 1 },
	{ "RcfUlpType", 28, 4 },
	{ "Eread", 27, 1 },
	{ "Ebypass", 26, 1 },
	{ "Esave", 25, 1 },
	{ "Static0", 24, 1 },
	{ "Cread", 23, 1 },
	{ "Cbypass", 22, 1 },
	{ "Csave", 21, 1 },
	{ "CPktOut", 20, 1 },
	{ "RxPagePoolFull", 18, 2 },
	{ "RxLpbkPkt", 17, 1 },
	{ "TxLpbkPkt", 16, 1 },
	{ "RxVfValid", 15, 1 },
	{ "SynLearned", 14, 1 },
	{ "SetDelEntry", 13, 1 },
	{ "SetInvEntry", 12, 1 },
	{ "CpcmdDvld", 11, 1 },
	{ "CpcmdSave", 10, 1 },
	{ "RxPstructsFull", 8, 2 },
	{ "EpcmdDvld", 7, 1 },
	{ "EpcmdFlush", 6, 1 },
	{ "EpcmdTrimPrefix", 5, 1 },
	{ "EpcmdTrimPostfix", 4, 1 },
	{ "ERssIp4Pkt", 3, 1 },
	{ "ERssIp6Pkt", 2, 1 },
	{ "ERssTcpUdpPkt", 1, 1 },
	{ "ERssFceFipPkt", 0, 1 },
	{ NULL }
};

static struct field_desc tp_la2[] = {
	{ "CplCmdIn", 56, 8 },
	{ "MpsVfVld", 55, 1 },
	{ "MpsPf", 52, 3 },
	{ "MpsVf", 44, 8 },
	{ "SynIn", 43, 1 },
	{ "AckIn", 42, 1 },
	{ "FinIn", 41, 1 },
	{ "RstIn", 40, 1 },
	{ "DataIn", 39, 1 },
	{ "DataInVld", 38, 1 },
	{ "PadIn", 37, 1 },
	{ "RxBufEmpty", 36, 1 },
	{ "RxDdp", 35, 1 },
	{ "RxFbCongestion", 34, 1 },
	{ "TxFbCongestion", 33, 1 },
	{ "TxPktSumSrdy", 32, 1 },
	{ "RcfUlpType", 28, 4 },
	{ "Eread", 27, 1 },
	{ "Ebypass", 26, 1 },
	{ "Esave", 25, 1 },
	{ "Static0", 24, 1 },
	{ "Cread", 23, 1 },
	{ "Cbypass", 22, 1 },
	{ "Csave", 21, 1 },
	{ "CPktOut", 20, 1 },
	{ "RxPagePoolFull", 18, 2 },
	{ "RxLpbkPkt", 17, 1 },
	{ "TxLpbkPkt", 16, 1 },
	{ "RxVfValid", 15, 1 },
	{ "SynLearned", 14, 1 },
	{ "SetDelEntry", 13, 1 },
	{ "SetInvEntry", 12, 1 },
	{ "CpcmdDvld", 11, 1 },
	{ "CpcmdSave", 10, 1 },
	{ "RxPstructsFull", 8, 2 },
	{ "EpcmdDvld", 7, 1 },
	{ "EpcmdFlush", 6, 1 },
	{ "EpcmdTrimPrefix", 5, 1 },
	{ "EpcmdTrimPostfix", 4, 1 },
	{ "ERssIp4Pkt", 3, 1 },
	{ "ERssIp6Pkt", 2, 1 },
	{ "ERssTcpUdpPkt", 1, 1 },
	{ "ERssFceFipPkt", 0, 1 },
	{ NULL }
};

static const char * const devlog_level_strings[] = {
	/*[FW_DEVLOG_LEVEL_EMERG]	=*/ "EMERG",
	/*[FW_DEVLOG_LEVEL_CRIT]	=*/ "CRIT",
	/*[FW_DEVLOG_LEVEL_ERR]		=*/ "ERR",
	/*[FW_DEVLOG_LEVEL_NOTICE]	=*/ "NOTICE",
	/*[FW_DEVLOG_LEVEL_INFO]	=*/ "INFO",
	/*[FW_DEVLOG_LEVEL_DEBUG]	=*/ "DEBUG",
	/*[FW_DEVLOG_LEVEL_MAX]		=*/ "MAX"
};

static const char * const devlog_facility_strings[] = {
	/*[FW_DEVLOG_FACILITY_CORE]   =*/ "CORE",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_SCHED]  =*/ "SCHED",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_TIMER]  =*/ "TIMER",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_RES]    =*/ "RES",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_HW]     =*/ "HW",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_FLR]    =*/ "FLR",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DMAQ]   =*/ "DMAQ",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_PHY]    =*/ "PHY",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_MAC]    =*/ "MAC",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_PORT]   =*/ "PORT",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_VI]     =*/ "VI",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_FILTER] =*/ "FILTER",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_ACL]    =*/ "ACL",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_TM]     =*/ "TM",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_QFC]    =*/ "QFC",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_DCB]    =*/ "DCB",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_ETH]    =*/ "ETH",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_OFLD]   =*/ "OFLD",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_RI]     =*/ "RI",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_ISCSI]  =*/ "ISCSI",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_FCOE]   =*/ "FCOE",
	/*[FW_DEVLOG_FACILITY_DUMMY]  =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_FOISCSI]	 =*/ "FOISCSI",
	/*[FW_DEVLOG_FACILITY_DUMMY]   =*/ "DUMMY",
	/*[FW_DEVLOG_FACILITY_FOFCOE] =*/ "FOFCOE",
	/*[FW_DEVLOG_FACILITY_MAX]    =*/ "MAX"
};

static struct tp1_reg_info t6_tp_mib_index_reg_array[] = {
	{"0x0", "TP_MIB_MAC_IN_ERR_0"},
	{"0x1", "TP_MIB_MAC_IN_ERR_1"},
	{"0x2", "TP_MIB_MAC_IN_ERR_2"},
	{"0x3", "TP_MIB_MAC_IN_ERR_3"},
	{"0x4", "TP_MIB_HDR_IN_ERR_0"},
	{"0x5", "TP_MIB_HDR_IN_ERR_1"},
	{"0x6", "TP_MIB_HDR_IN_ERR_2"},
	{"0x7", "TP_MIB_HDR_IN_ERR_3"},
	{"0x8", "TP_MIB_TCP_IN_ERR_0"},
	{"0x9", "TP_MIB_TCP_IN_ERR_1"},
	{"0xA", "TP_MIB_TCP_IN_ERR_2"},
	{"0xB", "TP_MIB_TCP_IN_ERR_3"},
	{"0xC", "TP_MIB_TCP_OUT_RST"},
	{"0x10", "TP_MIB_TCP_IN_SEG_HI"},
	{"0x11", "TP_MIB_TCP_IN_SEG_LO"},
	{"0x12", "TP_MIB_TCP_OUT_SEG_HI"},
	{"0x13", "TP_MIB_TCP_OUT_SEG_LO"},
	{"0x14", "TP_MIB_TCP_RXT_SEG_HI"},
	{"0x15", "TP_MIB_TCP_RXT_SEG_LO"},
	{"0x18", "TP_MIB_TNL_CNG_DROP_0"},
	{"0x19", "TP_MIB_TNL_CNG_DROP_1"},
	{"0x1A", "TP_MIB_TNL_CNG_DROP_2"},
	{"0x1B", "TP_MIB_TNL_CNG_DROP_3"},
	{"0x1C", "TP_MIB_OFD_CHN_DROP_0"},
	{"0x1D", "TP_MIB_OFD_CHN_DROP_1"},
	{"0x1E", "TP_MIB_OFD_CHN_DROP_2"},
	{"0x1F", "TP_MIB_OFD_CHN_DROP_3"},
	{"0x20", "TP_MIB_TNL_OUT_PKT_0"},
	{"0x21", "TP_MIB_TNL_OUT_PKT_1"},
	{"0x22", "TP_MIB_TNL_OUT_PKT_2"},
	{"0x23", "TP_MIB_TNL_OUT_PKT_3"},
	{"0x24", "TP_MIB_TNL_IN_PKT_0"},
	{"0x25", "TP_MIB_TNL_IN_PKT_1"},
	{"0x26", "TP_MIB_TNL_IN_PKT_2"},
	{"0x27", "TP_MIB_TNL_IN_PKT_3"},
	{"0x28", "TP_MIB_TCP_V6IN_ERR_0"},
	{"0x29", "TP_MIB_TCP_V6IN_ERR_1"},
	{"0x2A", "TP_MIB_TCP_V6IN_ERR_2"},
	{"0x2B", "TP_MIB_TCP_V6IN_ERR_3"},
	{"0x2C", "TP_MIB_TCP_V6OUT_RST"},
	{"0x30", "TP_MIB_TCP_V6IN_SEG_HI"},
	{"0x31", "TP_MIB_TCP_V6IN_SEG_LO"},
	{"0x32", "TP_MIB_TCP_V6OUT_SEG_HI"},
	{"0x33", "TP_MIB_TCP_V6OUT_SEG_LO"},
	{"0x34", "TP_MIB_TCP_V6RXT_SEG_HI"},
	{"0x35", "TP_MIB_TCP_V6RXT_SEG_LO"},
	{"0x36", "TP_MIB_OFD_ARP_DROP"},
	{"0x37", "TP_MIB_OFD_DFR_DROP"},
	{"0x38", "TP_MIB_CPL_IN_REQ_0"},
	{"0x39", "TP_MIB_CPL_IN_REQ_1"},
	{"0x3A", "TP_MIB_CPL_IN_REQ_2"},
	{"0x3B", "TP_MIB_CPL_IN_REQ_3"},
	{"0x3C", "TP_MIB_CPL_OUT_RSP_0"},
	{"0x3D", "TP_MIB_CPL_OUT_RSP_1"},
	{"0x3E", "TP_MIB_CPL_OUT_RSP_2"},
	{"0x3F", "TP_MIB_CPL_OUT_RSP_3"},
	{"0x40", "TP_MIB_TNL_LPBK_0"},
	{"0x41", "TP_MIB_TNL_LPBK_1"},
	{"0x42", "TP_MIB_TNL_LPBK_2"},
	{"0x43", "TP_MIB_TNL_LPBK_3"},
	{"0x44", "TP_MIB_TNL_DROP_0"},
	{"0x45", "TP_MIB_TNL_DROP_1"},
	{"0x46", "TP_MIB_TNL_DROP_2"},
	{"0x47", "TP_MIB_TNL_DROP_3"},
	{"0x48", "TP_MIB_FCOE_DDP_0"},
	{"0x49", "TP_MIB_FCOE_DDP_1"},
	{"0x4A", "TP_MIB_FCOE_DDP_2"},
	{"0x4B", "TP_MIB_FCOE_DDP_3"},
	{"0x4C", "TP_MIB_FCOE_DROP_0"},
	{"0x4D", "TP_MIB_FCOE_DROP_1"},
	{"0x4E", "TP_MIB_FCOE_DROP_2"},
	{"0x4F", "TP_MIB_FCOE_DROP_3"},
	{"0x50", "TP_MIB_FCOE_BYTE_0_HI"},
	{"0x51", "TP_MIB_FCOE_BYTE_0_LO"},
	{"0x52", "TP_MIB_FCOE_BYTE_1_HI"},
	{"0x53", "TP_MIB_FCOE_BYTE_1_LO"},
	{"0x54", "TP_MIB_FCOE_BYTE_2_HI"},
	{"0x55", "TP_MIB_FCOE_BYTE_2_LO"},
	{"0x56", "TP_MIB_FCOE_BYTE_3_HI"},
	{"0x57", "TP_MIB_FCOE_BYTE_3_LO"},
	{"0x58", "TP_MIB_OFD_VLN_DROP_0"},
	{"0x59", "TP_MIB_OFD_VLN_DROP_1"},
	{"0x5A", "TP_MIB_OFD_VLN_DROP_2"},
	{"0x5B", "TP_MIB_OFD_VLN_DROP_3"},
	{"0x5C", "TP_MIB_USM_PKTS"},
	{"0x5D", "TP_MIB_USM_DROP"},
	{"0x5E", "TP_MIB_USM_BYTES_HI"},
	{"0x5F", "TP_MIB_USM_BYTES_LO"},
	{"0x60", "TP_MIB_TID_DEL"},
	{"0x61", "TP_MIB_TID_INV"},
	{"0x62", "TP_MIB_TID_ACT"},
	{"0x63", "TP_MIB_TID_PAS"},
	{"0x64", "TP_MIB_RQE_DFR_PKT"},
	{"0x65", "TP_MIB_RQE_DFR_MOD"},
	{"0x68", "TP_MIB_CPL_OUT_ERR_0"},
	{"0x69", "TP_MIB_CPL_OUT_ERR_1"},
	{"0x6A", "TP_MIB_CPL_OUT_ERR_2"},
	{"0x6B", "TP_MIB_CPL_OUT_ERR_3"},
	{"0x6c", "TP_MIB_ENG_LINE_0"},
	{"0x6d", "TP_MIB_ENG_LINE_1"},
	{"0x6e", "TP_MIB_ENG_LINE_2"},
	{"0x6f", "TP_MIB_ENG_LINE_3"},
	{"0x70", "TP_MIB_TNL_ERR_0"},
	{"0x71", "TP_MIB_TNL_ERR_1"},
	{"0x72", "TP_MIB_TNL_ERR_2"},
	{"0x73", "TP_MIB_TNL_ERR_3"}
};

static struct tp1_reg_info t5_tp_mib_index_reg_array[] = {
	{"0x0", "TP_MIB_MAC_IN_ERR_0"},
	{"0x1", "TP_MIB_MAC_IN_ERR_1"},
	{"0x2", "TP_MIB_MAC_IN_ERR_2"},
	{"0x3", "TP_MIB_MAC_IN_ERR_3"},
	{"0x4", "TP_MIB_HDR_IN_ERR_0"},
	{"0x5", "TP_MIB_HDR_IN_ERR_1"},
	{"0x6", "TP_MIB_HDR_IN_ERR_2"},
	{"0x7", "TP_MIB_HDR_IN_ERR_3"},
	{"0x8", "TP_MIB_TCP_IN_ERR_0"},
	{"0x9", "TP_MIB_TCP_IN_ERR_1"},
	{"0xA", "TP_MIB_TCP_IN_ERR_2"},
	{"0xB", "TP_MIB_TCP_IN_ERR_3"},
	{"0xC", "TP_MIB_TCP_OUT_RST"},
	{"0x10", "TP_MIB_TCP_IN_SEG_HI"},
	{"0x11", "TP_MIB_TCP_IN_SEG_LO"},
	{"0x12", "TP_MIB_TCP_OUT_SEG_HI"},
	{"0x13", "TP_MIB_TCP_OUT_SEG_LO"},
	{"0x14", "TP_MIB_TCP_RXT_SEG_HI"},
	{"0x15", "TP_MIB_TCP_RXT_SEG_LO"},
	{"0x18", "TP_MIB_TNL_CNG_DROP_0"},
	{"0x19", "TP_MIB_TNL_CNG_DROP_1"},
	{"0x1A", "TP_MIB_TNL_CNG_DROP_2"},
	{"0x1B", "TP_MIB_TNL_CNG_DROP_3"},
	{"0x1C", "TP_MIB_OFD_CHN_DROP_0"},
	{"0x1D", "TP_MIB_OFD_CHN_DROP_1"},
	{"0x1E", "TP_MIB_OFD_CHN_DROP_2"},
	{"0x1F", "TP_MIB_OFD_CHN_DROP_3"},
	{"0x20", "TP_MIB_TNL_OUT_PKT_0"},
	{"0x21", "TP_MIB_TNL_OUT_PKT_1"},
	{"0x22", "TP_MIB_TNL_OUT_PKT_2"},
	{"0x23", "TP_MIB_TNL_OUT_PKT_3"},
	{"0x24", "TP_MIB_TNL_IN_PKT_0"},
	{"0x25", "TP_MIB_TNL_IN_PKT_1"},
	{"0x26", "TP_MIB_TNL_IN_PKT_2"},
	{"0x27", "TP_MIB_TNL_IN_PKT_3"},
	{"0x28", "TP_MIB_TCP_V6IN_ERR_0"},
	{"0x29", "TP_MIB_TCP_V6IN_ERR_1"},
	{"0x2A", "TP_MIB_TCP_V6IN_ERR_2"},
	{"0x2B", "TP_MIB_TCP_V6IN_ERR_3"},
	{"0x2C", "TP_MIB_TCP_V6OUT_RST"},
	{"0x30", "TP_MIB_TCP_V6IN_SEG_HI"},
	{"0x31", "TP_MIB_TCP_V6IN_SEG_LO"},
	{"0x32", "TP_MIB_TCP_V6OUT_SEG_HI"},
	{"0x33", "TP_MIB_TCP_V6OUT_SEG_LO"},
	{"0x34", "TP_MIB_TCP_V6RXT_SEG_HI"},
	{"0x35", "TP_MIB_TCP_V6RXT_SEG_LO"},
	{"0x36", "TP_MIB_OFD_ARP_DROP"},
	{"0x37", "TP_MIB_OFD_DFR_DROP"},
	{"0x38", "TP_MIB_CPL_IN_REQ_0"},
	{"0x39", "TP_MIB_CPL_IN_REQ_1"},
	{"0x3A", "TP_MIB_CPL_IN_REQ_2"},
	{"0x3B", "TP_MIB_CPL_IN_REQ_3"},
	{"0x3C", "TP_MIB_CPL_OUT_RSP_0"},
	{"0x3D", "TP_MIB_CPL_OUT_RSP_1"},
	{"0x3E", "TP_MIB_CPL_OUT_RSP_2"},
	{"0x3F", "TP_MIB_CPL_OUT_RSP_3"},
	{"0x40", "TP_MIB_TNL_LPBK_0"},
	{"0x41", "TP_MIB_TNL_LPBK_1"},
	{"0x42", "TP_MIB_TNL_LPBK_2"},
	{"0x43", "TP_MIB_TNL_LPBK_3"},
	{"0x44", "TP_MIB_TNL_DROP_0"},
	{"0x45", "TP_MIB_TNL_DROP_1"},
	{"0x46", "TP_MIB_TNL_DROP_2"},
	{"0x47", "TP_MIB_TNL_DROP_3"},
	{"0x48", "TP_MIB_FCOE_DDP_0"},
	{"0x49", "TP_MIB_FCOE_DDP_1"},
	{"0x4A", "TP_MIB_FCOE_DDP_2"},
	{"0x4B", "TP_MIB_FCOE_DDP_3"},
	{"0x4C", "TP_MIB_FCOE_DROP_0"},
	{"0x4D", "TP_MIB_FCOE_DROP_1"},
	{"0x4E", "TP_MIB_FCOE_DROP_2"},
	{"0x4F", "TP_MIB_FCOE_DROP_3"},
	{"0x50", "TP_MIB_FCOE_BYTE_0_HI"},
	{"0x51", "TP_MIB_FCOE_BYTE_0_LO"},
	{"0x52", "TP_MIB_FCOE_BYTE_1_HI"},
	{"0x53", "TP_MIB_FCOE_BYTE_1_LO"},
	{"0x54", "TP_MIB_FCOE_BYTE_2_HI"},
	{"0x55", "TP_MIB_FCOE_BYTE_2_LO"},
	{"0x56", "TP_MIB_FCOE_BYTE_3_HI"},
	{"0x57", "TP_MIB_FCOE_BYTE_3_LO"},
	{"0x58", "TP_MIB_OFD_VLN_DROP_0"},
	{"0x59", "TP_MIB_OFD_VLN_DROP_1"},
	{"0x5A", "TP_MIB_OFD_VLN_DROP_2"},
	{"0x5B", "TP_MIB_OFD_VLN_DROP_3"},
	{"0x5C", "TP_MIB_USM_PKTS"},
	{"0x5D", "TP_MIB_USM_DROP"},
	{"0x5E", "TP_MIB_USM_BYTES_HI"},
	{"0x5F", "TP_MIB_USM_BYTES_LO"},
	{"0x60", "TP_MIB_TID_DEL"},
	{"0x61", "TP_MIB_TID_INV"},
	{"0x62", "TP_MIB_TID_ACT"},
	{"0x63", "TP_MIB_TID_PAS"},
	{"0x64", "TP_MIB_RQE_DFR_PKT"},
	{"0x65", "TP_MIB_RQE_DFR_MOD"},
	{"0x68", "TP_MIB_CPL_OUT_ERR_0"},
	{"0x69", "TP_MIB_CPL_OUT_ERR_1"},
	{"0x6A", "TP_MIB_CPL_OUT_ERR_2"},
	{"0x6B", "TP_MIB_CPL_OUT_ERR_3"}
};

static struct cudbg_reg_info t6_tp_tm_regs[] = {
	{ "TP_TX_MOD_Q7_Q6_TIMER_SEPARATOR", 0x0, 0 },
	{ "S_TXTIMERSEPQ7", 16, 16 },
	{ "S_TXTIMERSEPQ6", 0, 16 },
	{ "TP_TX_MOD_Q5_Q4_TIMER_SEPARATOR", 0x1, 0 },
	{ "S_TXTIMERSEPQ4", 16, 16 },
	{ "S_TXTIMERSEPQ4", 0, 16 },
	{ "TP_TX_MOD_Q3_Q2_TIMER_SEPARATOR", 0x2, 0 },
	{ "S_TXTIMERSEPQ3", 16, 16 },
	{ "S_TXTIMERSEPQ2", 0, 16 },
	{ "TP_TX_MOD_Q1_Q0_TIMER_SEPARATOR", 0x3, 0 },
	{ "S_TXTIMERSEPQ1", 16, 16 },
	{ "S_TXTIMERSEPQ0", 0, 16 },
	{ "TP_RX_MOD_Q1_Q0_TIMER_SEPARATOR", 0x4, 0 },
	{ "S_RXTIMERSEPQ1", 16, 16 },
	{ "S_RXTIMERSEPQ0", 0, 16 },
	{ "TP_TX_MOD_Q7_Q6_RATE_LIMIT", 0x5, 0 },
	{ "S_TXRATEINCQ7", 24, 8 },
	{ "S_TXRATETCKQ7", 16, 8 },
	{ "S_TXRATEINCQ6", 8, 8 },
	{ "S_TXRATETCKQ6", 0, 8 },
	{ "TP_TX_MOD_Q5_Q4_RATE_LIMIT", 0x6, 0 },
	{ "S_TXRATEINCQ5", 24, 8 },
	{ "S_TXRATETCKQ5", 16, 8 },
	{ "S_TXRATEINCQ4", 8, 8 },
	{ "S_TXRATETCKQ4", 0, 8 },
	{ "TP_TX_MOD_Q3_Q2_RATE_LIMIT", 0x7, 0 },
	{ "S_TXRATEINCQ3", 24, 8 },
	{ "S_TXRATETCKQ3", 16, 8 },
	{ "S_TXRATEINCQ2", 8, 8 },
	{ "S_TXRATETCKQ2", 0, 8 },
	{ "TP_TX_MOD_Q1_Q0_RATE_LIMIT", 0x8, 0 },
	{ "S_TXRATEINCQ1", 24, 8 },
	{ "S_TXRATETCKQ1", 16, 8 },
	{ "S_TXRATEINCQ0", 8, 8 },
	{ "S_TXRATETCKQ0", 0, 8 },
	{ "TP_RX_MOD_Q1_Q0_RATE_LIMIT", 0x9, 0 },
	{ "S_RXRATEINCQ1", 24, 8 },
	{ "S_RXRATETCKQ1", 16, 8 },
	{ "S_RXRATEINCQ0", 8, 8 },
	{ "S_RXRATETCKQ0", 0, 8 },
	{ "TP_TX_MOD_C3_C2_RATE_LIMIT", 0xA, 0 },
	{ "TP_TX_MOD_C1_C0_RATE_LIMIT", 0xB, 0 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_tm_regs[] = {
	{ "TP_TX_MOD_Q7_Q6_TIMER_SEPARATOR", 0x0, 0 },
	{ "S_TXTIMERSEPQ7", 16, 16 },
	{ "S_TXTIMERSEPQ6", 0, 16 },
	{ "TP_TX_MOD_Q5_Q4_TIMER_SEPARATOR", 0x1, 0 },
	{ "S_TXTIMERSEPQ4", 16, 16 },
	{ "S_TXTIMERSEPQ4", 0, 16 },
	{ "TP_TX_MOD_Q3_Q2_TIMER_SEPARATOR", 0x2, 0 },
	{ "S_TXTIMERSEPQ3", 16, 16 },
	{ "S_TXTIMERSEPQ2", 0, 16 },
	{ "TP_TX_MOD_Q1_Q0_TIMER_SEPARATOR", 0x3, 0 },
	{ "S_TXTIMERSEPQ1", 16, 16 },
	{ "S_TXTIMERSEPQ0", 0, 16 },
	{ "TP_RX_MOD_Q1_Q0_TIMER_SEPARATOR", 0x4, 0 },
	{ "S_RXTIMERSEPQ1", 16, 16 },
	{ "S_RXTIMERSEPQ0", 0, 16 },
	{ "TP_TX_MOD_Q7_Q6_RATE_LIMIT", 0x5, 0 },
	{ "S_TXRATEINCQ7", 24, 8 },
	{ "S_TXRATETCKQ7", 16, 8 },
	{ "S_TXRATEINCQ6", 8, 8 },
	{ "S_TXRATETCKQ6", 0, 8 },
	{ "TP_TX_MOD_Q5_Q4_RATE_LIMIT", 0x6, 0 },
	{ "S_TXRATEINCQ5", 24, 8 },
	{ "S_TXRATETCKQ5", 16, 8 },
	{ "S_TXRATEINCQ4", 8, 8 },
	{ "S_TXRATETCKQ4", 0, 8 },
	{ "TP_TX_MOD_Q3_Q2_RATE_LIMIT", 0x7, 0 },
	{ "S_TXRATEINCQ3", 24, 8 },
	{ "S_TXRATETCKQ3", 16, 8 },
	{ "S_TXRATEINCQ2", 8, 8 },
	{ "S_TXRATETCKQ2", 0, 8 },
	{ "TP_TX_MOD_Q1_Q0_RATE_LIMIT", 0x8, 0 },
	{ "S_TXRATEINCQ1", 24, 8 },
	{ "S_TXRATETCKQ1", 16, 8 },
	{ "S_TXRATEINCQ0", 8, 8 },
	{ "S_TXRATETCKQ0", 0, 8 },
	{ "TP_RX_MOD_Q1_Q0_RATE_LIMIT", 0x9, 0 },
	{ "S_RXRATEINCQ1", 24, 8 },
	{ "S_RXRATETCKQ1", 16, 8 },
	{ "S_RXRATEINCQ0", 8, 8 },
	{ "S_RXRATETCKQ0", 0, 8 },
	{ "TP_TX_MOD_C3_C2_RATE_LIMIT", 0xA, 0 },
	{ "TP_TX_MOD_C1_C0_RATE_LIMIT", 0xB, 0 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_20_to_3b[] = {
	{ "TP_RX_SCHED_MAP", 0x20, 0 },
	{ "S_RXMAPCHANNEL3", 24, 8 },
	{ "S_RXMAPCHANNEL2", 16, 8 },
	{ "S_RXMAPCHANNEL1", 8, 8 },
	{ "S_RXMAPCHANNEL0", 0, 8 },
	{ "TP_RX_SCHED_SGE", 0x21, 0 },
	{ "S_RXSGEMOD1", 12, 4 },
	{ "S_RXSGEMOD0", 8, 4 },
	{ "S_RXSGECHANNEL3", 3, 1 },
	{ "S_RXSGECHANNEL2", 2, 1 },
	{ "S_RXSGECHANNEL1", 1, 1 },
	{ "S_RXSGECHANNEL0", 0, 1 },
	{ "TP_TX_SCHED_MAP", 0x22, 0 },
	{ "S_TXMAPCHANNEL3", 12, 4 },
	{ "S_TXMAPCHANNEL2", 8, 4 },
	{ "S_TXMAPCHANNEL1", 4, 4 },
	{ "S_TXMAPCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_HDR", 0x23, 0 },
	{ "S_TXMAPHDRCHANNEL7", 28, 4 },
	{ "S_TXMAPHDRCHANNEL6", 24, 4 },
	{ "S_TXMAPHDRCHANNEL5", 20, 4 },
	{ "S_TXMAPHDRCHANNEL4", 16, 4 },
	{ "S_TXMAPHDRCHANNEL3", 12, 4 },
	{ "S_TXMAPHDRCHANNEL2", 8, 4 },
	{ "S_TXMAPHDRCHANNEL1", 4, 4 },
	{ "S_TXMAPHDRCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_FIFO", 0x24, 0 },
	{ "S_TXMAPFIFOCHANNEL7", 28, 4 },
	{ "S_TXMAPFIFOCHANNEL6", 24, 4 },
	{ "S_TXMAPFIFOCHANNEL5", 20, 4 },
	{ "S_TXMAPFIFOCHANNEL4", 16, 4 },
	{ "S_TXMAPFIFOCHANNEL3", 12, 4 },
	{ "S_TXMAPFIFOCHANNEL2", 8, 4 },
	{ "S_TXMAPFIFOCHANNEL1", 4, 4 },
	{ "S_TXMAPFIFOCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_PCMD", 0x25, 0 },
	{ "S_TXMAPPCMDCHANNEL7", 28, 4 },
	{ "S_TXMAPPCMDCHANNEL6", 24, 4 },
	{ "S_TXMAPPCMDCHANNEL5", 20, 4 },
	{ "S_TXMAPPCMDCHANNEL4", 16, 4 },
	{ "S_TXMAPPCMDCHANNEL3", 12, 4 },
	{ "S_TXMAPPCMDCHANNEL2", 8, 4 },
	{ "S_TXMAPPCMDCHANNEL1", 4, 4 },
	{ "S_TXMAPPCMDCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_LPBK", 0x26, 0 },
	{ "S_TXMAPLPBKCHANNEL7", 28, 4 },
	{ "S_TXMAPLPBKCHANNEL6", 24, 4 },
	{ "S_TXMAPLPBKCHANNEL5", 20, 4 },
	{ "S_TXMAPLPBKCHANNEL4", 16, 4 },
	{ "S_TXMAPLPBKCHANNEL3", 12, 4 },
	{ "S_TXMAPLPBKCHANNEL2", 8, 4 },
	{ "S_TXMAPLPBKCHANNEL1", 4, 4 },
	{ "S_TXMAPLPBKCHANNEL0", 0, 4 },
	{ "TP_CHANNEL_MAP", 0x27, 0 },
	{ "RxMapChannelELN", 16, 4 },
	{ "RxMapE2LChannel3", 14, 2 },
	{ "RxMapE2LChannel2", 12, 2 },
	{ "RxMapE2LChannel1", 10, 2 },
	{ "RxMapE2LChannel0", 8, 2 },
	{ "RxMapC2CChannel3", 7, 1 },
	{ "RxMapC2CChannel2", 6, 1 },
	{ "RxMapC2CChannel1", 5, 1 },
	{ "RxMapC2CChannel0", 4, 1 },
	{ "RxMapE2CChannel3", 3, 1 },
	{ "RxMapE2CChannel2", 2, 1 },
	{ "RxMapE2CChannel1", 1, 1 },
	{ "RxMapE2CChannel0", 0, 1 },
	{ "TP_RX_LPBK", 0x28, 0 },
	{ "CommitReset3", 31, 1 },
	{ "CommitReset2", 30, 1 },
	{ "CommitReset1", 29, 1 },
	{ "CommitReset0", 28, 1 },
	{ "ForceCong3", 27, 1 },
	{ "ForceCong2", 26, 1 },
	{ "ForceCong1", 25, 1 },
	{ "ForceCong0", 24, 1 },
	{ "CommitLimit3", 18, 6 },
	{ "CommitLimit2", 12, 6},
	{ "CommitLimit1", 6, 6 },
	{ "CommitLimit0", 0, 6 },
	{ "TP_TX_LPBK", 0x29, 0 },
	{ "CommitReset3", 31, 1 },
	{ "CommitReset2", 30, 1 },
	{ "CommitReset1", 29, 1 },
	{ "CommitReset0", 28, 1 },
	{ "ForceCong3", 27, 1 },
	{ "ForceCong2", 26, 1 },
	{ "ForceCong1", 25, 1 },
	{ "ForceCong0", 24, 1 },
	{ "CommitLimit3", 18, 6 },
	{ "CommitLimit2", 12, 6},
	{ "CommitLimit1", 6, 6 },
	{ "CommitLimit0", 0, 6 },

	{ "TP_TX_SCHED_PPP", 0x2A, 0 },
	{ "S_TXPPPENPORT3", 24, 8 },
	{ "S_TXPPPENPORT2", 16, 8 },
	{ "S_TXPPPENPORT1", 8, 8 },
	{ "S_TXPPPENPORT0", 0, 8 },
	{ "TP_RX_SCHED_FIFO", 0x2B, 0 },
	{ "S_COMMITLIMIT1H", 24, 8 },
	{ "S_COMMITLIMIT1L", 16, 8 },
	{ "S_COMMITLIMIT0H", 8, 8 },
	{ "S_COMMITLIMIT0L", 0, 8 },
	{ "TP_IPMI_CFG1", 0x2E, 0 },
	{ "S_VLANENABLE", 31, 1 },
	{ "S_PRIMARYPORTENABLE", 30, 1 },
	{ "S_SECUREPORTENABLE", 29, 1 },
	{ "S_ARPENABLE", 28, 1 },
	{ "S_IPMI_VLAN", 0, 16 },
	{ "TP_IPMI_CFG2", 0x2F, 0 },
	{ "S_SECUREPORT", 16, 16 },
	{ "S_PRIMARYPORT", 0, 16 },
	{ "TP_RSS_PF0_CONFIG", 0x30, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF1_CONFIG", 0x31, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF2_CONFIG", 0x32, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF3_CONFIG", 0x33, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF4_CONFIG", 0x34, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF5_CONFIG", 0x35, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF6_CONFIG", 0x36, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF7_CONFIG", 0x37, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_CHNENABLE", 30, 1 },
	{ "S_PRTENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF_MAP", 0x38, 0 },
	{ "S_LKPIDXSIZE", 24, 2 },
	{ "S_PF7LKPIDX", 21, 3 },
	{ "S_PF6LKPIDX", 18, 3 },
	{ "S_PF5LKPIDX", 15, 3 },
	{ "S_PF4LKPIDX", 12, 3 },
	{ "S_PF3LKPIDX", 9, 3 },
	{ "S_PF2LKPIDX", 6, 3 },
	{ "S_PF1LKPIDX", 3, 3 },
	{ "S_PF0LKPIDX", 0, 3 },
	{ "TP_RSS_PF_MSK", 0x39, 0 },
	{ "S_PF7MSKSIZE", 28, 4 },
	{ "S_PF6MSKSIZE", 24, 4 },
	{ "S_PF5MSKSIZE", 20, 4 },
	{ "S_PF4MSKSIZE", 16, 4 },
	{ "S_PF3MSKSIZE", 12, 4 },
	{ "S_PF2MSKSIZE", 8, 4 },
	{ "S_PF1MSKSIZE", 4, 4 },
	{ "S_PF0MSKSIZE", 0, 4 },
	{ "TP_RSS_VFL_CONFIG", 0x3A, 0 },
	{ "S_KEYSCRAMBLE", 0, 32 },
	{ "TP_RSS_VFH_CONFIG", 0x3B, 0 },
	{ "S_ENABLEUDPHASH", 31, 1 },
	{ "S_VFUPEN", 30, 1 },
	{ "S_RESERVED", 29, 1 },
	{ "S_VFVLNEX", 28, 1 },
	{ "S_VFPRTEN", 27, 1 },
	{ "S_VFCHNEN", 26, 1 },
	{ "S_DEFAULTQUEUE", 16, 10 },
	{ "S_VFLKPIDX", 8, 8 },
	{ "S_VFIP6FOURTUPEN", 7, 1 },
	{ "S_VFIP6TWOTUPEN", 6, 1 },
	{ "S_VFIP4FOURTUPEN", 5, 1 },
	{ "S_VFIP4TWOTUPEN", 4, 1 },
	{ "S_KEYINDEX", 0, 4 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_20_to_3b[] = {
	{ "TP_RX_SCHED_MAP", 0x20, 0 },
	{ "S_RXMAPCHANNEL3", 24, 8 },
	{ "S_RXMAPCHANNEL2", 16, 8 },
	{ "S_RXMAPCHANNEL1", 8, 8 },
	{ "S_RXMAPCHANNEL0", 0, 8 },
	{ "TP_RX_SCHED_SGE", 0x21, 0 },
	{ "S_RXSGEMOD1", 12, 4 },
	{ "S_RXSGEMOD0", 8, 4 },
	{ "S_RXSGECHANNEL3", 3, 1 },
	{ "S_RXSGECHANNEL2", 2, 1 },
	{ "S_RXSGECHANNEL1", 1, 1 },
	{ "S_RXSGECHANNEL0", 0, 1 },
	{ "TP_TX_SCHED_MAP", 0x22, 0 },
	{ "S_TXMAPCHANNEL3", 12, 4 },
	{ "S_TXMAPCHANNEL2", 8, 4 },
	{ "S_TXMAPCHANNEL1", 4, 4 },
	{ "S_TXMAPCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_HDR", 0x23, 0 },
	{ "S_TXMAPHDRCHANNEL7", 28, 4 },
	{ "S_TXMAPHDRCHANNEL6", 24, 4 },
	{ "S_TXMAPHDRCHANNEL5", 20, 4 },
	{ "S_TXMAPHDRCHANNEL4", 16, 4 },
	{ "S_TXMAPHDRCHANNEL3", 12, 4 },
	{ "S_TXMAPHDRCHANNEL2", 8, 4 },
	{ "S_TXMAPHDRCHANNEL1", 4, 4 },
	{ "S_TXMAPHDRCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_FIFO", 0x24, 0 },
	{ "S_TXMAPFIFOCHANNEL7", 28, 4 },
	{ "S_TXMAPFIFOCHANNEL6", 24, 4 },
	{ "S_TXMAPFIFOCHANNEL5", 20, 4 },
	{ "S_TXMAPFIFOCHANNEL4", 16, 4 },
	{ "S_TXMAPFIFOCHANNEL3", 12, 4 },
	{ "S_TXMAPFIFOCHANNEL2", 8, 4 },
	{ "S_TXMAPFIFOCHANNEL1", 4, 4 },
	{ "S_TXMAPFIFOCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_PCMD", 0x25, 0 },
	{ "S_TXMAPPCMDCHANNEL7", 28, 4 },
	{ "S_TXMAPPCMDCHANNEL6", 24, 4 },
	{ "S_TXMAPPCMDCHANNEL5", 20, 4 },
	{ "S_TXMAPPCMDCHANNEL4", 16, 4 },
	{ "S_TXMAPPCMDCHANNEL3", 12, 4 },
	{ "S_TXMAPPCMDCHANNEL2", 8, 4 },
	{ "S_TXMAPPCMDCHANNEL1", 4, 4 },
	{ "S_TXMAPPCMDCHANNEL0", 0, 4 },
	{ "TP_TX_SCHED_LPBK", 0x26, 0 },
	{ "S_TXMAPLPBKCHANNEL7", 28, 4 },
	{ "S_TXMAPLPBKCHANNEL6", 24, 4 },
	{ "S_TXMAPLPBKCHANNEL5", 20, 4 },
	{ "S_TXMAPLPBKCHANNEL4", 16, 4 },
	{ "S_TXMAPLPBKCHANNEL3", 12, 4 },
	{ "S_TXMAPLPBKCHANNEL2", 8, 4 },
	{ "S_TXMAPLPBKCHANNEL1", 4, 4 },
	{ "S_TXMAPLPBKCHANNEL0", 0, 4 },
	{ "TP_CHANNEL_MAP", 0x27, 0 },
	{ "RxMapChannelELN", 16, 4 },
	{ "RxMapE2LChannel3", 14, 2 },
	{ "RxMapE2LChannel2", 12, 2 },
	{ "RxMapE2LChannel1", 10, 2 },
	{ "RxMapE2LChannel0", 8, 2 },
	{ "RxMapC2CChannel3", 7, 1 },
	{ "RxMapC2CChannel2", 6, 1 },
	{ "RxMapC2CChannel1", 5, 1 },
	{ "RxMapC2CChannel0", 4, 1 },
	{ "RxMapE2CChannel3", 3, 1 },
	{ "RxMapE2CChannel2", 2, 1 },
	{ "RxMapE2CChannel1", 1, 1 },
	{ "RxMapE2CChannel0", 0, 1 },
	{ "TP_RX_LPBK", 0x28, 0 },
	{ "TP_TX_LPBK", 0x29, 0 },
	{ "TP_TX_SCHED_PPP", 0x2A, 0 },
	{ "S_TXPPPENPORT3", 24, 8 },
	{ "S_TXPPPENPORT2", 16, 8 },
	{ "S_TXPPPENPORT1", 8, 8 },
	{ "S_TXPPPENPORT0", 0, 8 },
	{ "TP_RX_SCHED_FIFO", 0x2B, 0 },
	{ "S_COMMITLIMIT1H", 24, 8 },
	{ "S_COMMITLIMIT1L", 16, 8 },
	{ "S_COMMITLIMIT0H", 8, 8 },
	{ "S_COMMITLIMIT0L", 0, 8 },
	{ "TP_IPMI_CFG1", 0x2E, 0 },
	{ "S_VLANENABLE", 31, 1 },
	{ "S_PRIMARYPORTENABLE", 30, 1 },
	{ "S_SECUREPORTENABLE", 29, 1 },
	{ "S_ARPENABLE", 28, 1 },
	{ "S_IPMI_VLAN", 0, 16 },
	{ "TP_IPMI_CFG2", 0x2F, 0 },
	{ "S_SECUREPORT", 16, 16 },
	{ "S_PRIMARYPORT", 0, 16 },
	{ "TP_RSS_PF0_CONFIG", 0x30, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF1_CONFIG", 0x31, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF2_CONFIG", 0x32, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF3_CONFIG", 0x33, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF4_CONFIG", 0x34, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF5_CONFIG", 0x35, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF6_CONFIG", 0x36, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF7_CONFIG", 0x37, 0 },
	{ "S_MAPENABLE", 31, 1 },
	{ "S_PRTENABLE", 30, 1 },
	{ "S_CHNENABLE", 29, 1 },
	{ "S_UDPFOURTUPEN", 28, 1 },
	{ "S_IP6FOURTUPEN", 27, 1 },
	{ "S_IP6TWOTUPEN", 26, 1 },
	{ "S_IP4FOURTUPEN", 25, 1 },
	{ "S_IP4TWOTUPEN", 24, 1 },
	{ "S_IVFWIDTH", 20, 4 },
	{ "S_CH1DEFAULTQUEUE", 10, 10 },
	{ "S_CH0DEFAULTQUEUE", 0, 10 },
	{ "TP_RSS_PF_MAP", 0x38, 0 },
	{ "S_LKPIDXSIZE", 24, 2 },
	{ "S_PF7LKPIDX", 21, 3 },
	{ "S_PF6LKPIDX", 18, 3 },
	{ "S_PF5LKPIDX", 15, 3 },
	{ "S_PF4LKPIDX", 12, 3 },
	{ "S_PF3LKPIDX", 9, 3 },
	{ "S_PF2LKPIDX", 6, 3 },
	{ "S_PF1LKPIDX", 3, 3 },
	{ "S_PF0LKPIDX", 0, 3 },
	{ "TP_RSS_PF_MSK", 0x39, 0 },
	{ "S_PF7MSKSIZE", 28, 4 },
	{ "S_PF6MSKSIZE", 24, 4 },
	{ "S_PF5MSKSIZE", 20, 4 },
	{ "S_PF4MSKSIZE", 16, 4 },
	{ "S_PF3MSKSIZE", 12, 4 },
	{ "S_PF2MSKSIZE", 8, 4 },
	{ "S_PF1MSKSIZE", 4, 4 },
	{ "S_PF0MSKSIZE", 0, 4 },
	{ "TP_RSS_VFL_CONFIG", 0x3A, 0 },
	{ "S_KEYSCRAMBLE", 0, 32 },
	{ "TP_RSS_VFH_CONFIG", 0x3B, 0 },
	{ "S_ENABLEUDPHASH", 31, 1 },
	{ "S_VFUPEN", 30, 1 },
	{ "S_RESERVED", 29, 1 },
	{ "S_VFVLNEX", 28, 1 },
	{ "S_VFPRTEN", 27, 1 },
	{ "S_VFCHNEN", 26, 1 },
	{ "S_DEFAULTQUEUE", 16, 10 },
	{ "S_VFLKPIDX", 8, 8 },
	{ "S_VFIP6FOURTUPEN", 7, 1 },
	{ "S_VFIP6TWOTUPEN", 6, 1 },
	{ "S_VFIP4FOURTUPEN", 5, 1 },
	{ "S_VFIP4TWOTUPEN", 4, 1 },
	{ "S_KEYINDEX", 0, 4 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_40_to_49[] = {
	{ "TP_RSS_SECRET_KEY0", 0x40, 0 },
	{ "TP_RSS_SECRET_KEY1", 0x41, 0 },
	{ "TP_RSS_SECRET_KEY2", 0x42, 0 },
	{ "TP_RSS_SECRET_KEY3", 0x43, 0 },
	{ "TP_RSS_SECRET_KEY4", 0x44, 0 },
	{ "TP_RSS_SECRET_KEY5", 0x45, 0 },
	{ "TP_RSS_SECRET_KEY6", 0x46, 0 },
	{ "TP_RSS_SECRET_KEY7", 0x47, 0 },
	{ "TP_RSS_SECRET_KEY8", 0x48, 0 },
	{ "TP_RSS_SECRET_KEY9", 0x49, 0 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_50_to_59[] = {
	{ "TP_ETHER_TYPE_VL", 0x50, 0 },
	{ "S_CQFCTYPE", 16, 16 },
	{ "S_VLANTYPE", 0, 16 },
	{ "TP_ETHER_TYPE_IP", 0x51, 0 },
	{ "S_IPV6TYPE", 16, 16 },
	{ "S_IPV4TYPE", 0, 16 },
	{ "TP_ETHER_TYPE_FW", 0x52, 0 },
	{ "S_ETHTYPE1", 16, 16 },
	{ "S_ETHTYPE0", 0, 16 },
	{ "TP_VXLAN_HEADER", 0x53, 0 },
	{ "S_VXLANPORT", 0, 16 },
	{ "TP_CORE_POWER", 0x54, 0 },
	{ "S_SLEEPRDYVNT", 12, 1 },
	{ "S_SLEEPRDYTBL", 11, 1 },
	{ "S_SLEEPRDYMIB", 10, 1 },
	{ "S_SLEEPRDYARP", 9, 1 },
	{ "S_SLEEPRDYRSS", 8, 1 },
	{ "S_SLEEPREQVNT", 4, 1 },
	{ "S_SLEEPREQTBL", 3, 1 },
	{ "S_SLEEPREQMIB", 2, 1 },
	{ "S_SLEEPREQARP", 1, 1 },
	{ "S_SLEEPREQRSS", 0, 1 },
	{ "TP_CORE_RDMA", 0x55, 0 },
	{ "S_SHAREDRQEN", 31, 1 },
	{ "S_SHAREDXRC", 30, 1 },
	{ "S_IMMEDIATEOP", 20, 4 },
	{ "S_IMMEDIATESE", 16, 4 },
	{ "S_ATOMICREQOP", 12, 4 },
	{ "S_ATOMICRSPOP", 8, 4 },
	{ "S_IMMEDIASEEN", 1, 1 },
	{ "S_IMMEDIATEEN", 0, 1 },
	{ "TP_FRAG_CONFIG", 0x56, 0 },
	{ "Reserved", 16, 16 },
	{ "UserMode", 14, 2 },
	{ "FcoeMode", 12, 2 },
	{ "IandpMode", 10, 2 },
	{ "RddpMode", 8, 2 },
	{ "IwarpMode", 6, 2 },
	{ "IscsiMode", 4, 2 },
	{ "DdpMode", 2, 2 },
	{ "PassMode", 0, 2 },
	{ "TP_CMM_CONFIG", 0x57, 0 },
	{ "WrCntIdle", 16, 16 },
	{ "RdThreshold", 8, 7 },
	{ "WrThrLevel2", 7, 1 },
	{ "WrThrLevel1", 6, 1 },
	{ "WrThrThreshEn", 5, 1 },
	{ "WrThrThresh", 0, 5},
	{ "TP_VXLAN_CONFIG", 0x58, 0 },
	{ "VxLanFlags", 16, 16},
	{ "VxLanType", 0, 16},
	{ "TP_NVGRE_CONFIG", 0x59, 0 },
	{ "GreFlags", 16, 16 },
	{ "GreType", 0, 16 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_40_to_52[] = {
	{ "TP_RSS_SECRET_KEY0", 0x40, 0 },
	{ "TP_RSS_SECRET_KEY1", 0x41, 0 },
	{ "TP_RSS_SECRET_KEY2", 0x42, 0 },
	{ "TP_RSS_SECRET_KEY3", 0x43, 0 },
	{ "TP_RSS_SECRET_KEY4", 0x44, 0 },
	{ "TP_RSS_SECRET_KEY5", 0x45, 0 },
	{ "TP_RSS_SECRET_KEY6", 0x46, 0 },
	{ "TP_RSS_SECRET_KEY7", 0x47, 0 },
	{ "TP_RSS_SECRET_KEY8", 0x48, 0 },
	{ "TP_RSS_SECRET_KEY9", 0x49, 0 },
	{ "TP_ETHER_TYPE_VL", 0x50, 0 },
	{ "S_CQFCTYPE", 16, 16 },
	{ "S_VLANTYPE", 0, 16 },
	{ "TP_ETHER_TYPE_IP", 0x51, 0 },
	{ "S_IPV6TYPE", 16, 16 },
	{ "S_IPV4TYPE", 0, 16 },
	{ "TP_ETHER_TYPE_FW", 0x52, 0 },
	{ "S_ETHTYPE1", 16, 16 },
	{ "S_ETHTYPE0", 0, 16 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_54_to_55[] = {
	{ "TP_CORE_POWER", 0x54, 0 },
	{ "S_SLEEPRDYVNT", 12, 1 },
	{ "S_SLEEPRDYTBL", 11, 1 },
	{ "S_SLEEPRDYMIB", 10, 1 },
	{ "S_SLEEPRDYARP", 9, 1 },
	{ "S_SLEEPRDYRSS", 8, 1 },
	{ "S_SLEEPREQVNT", 4, 1 },
	{ "S_SLEEPREQTBL", 3, 1 },
	{ "S_SLEEPREQMIB", 2, 1 },
	{ "S_SLEEPREQARP", 1, 1 },
	{ "S_SLEEPREQRSS", 0, 1 },
	{ "TP_CORE_RDMA", 0x55, 0 },
	{ "S_IMMEDIATEOP", 20, 4 },
	{ "S_IMMEDIATESE", 16, 4 },
	{ "S_ATOMICREQOP", 12, 4 },
	{ "S_ATOMICRSPOP", 8, 4 },
	{ "S_IMMEDIASEEN", 1, 1 },
	{ "S_IMMEDIATEEN", 0, 1 },
	{ NULL }
};

static struct cudbg_reg_info sge_debug_data_high[] = {
	{"SGE_DEBUG_DATA_HIGH_INDEX_0", 0x1280},
	{"SGE_DEBUG_DATA_HIGH_INDEX_1", 0x1284},
	{"SGE_DEBUG_DATA_HIGH_INDEX_2", 0x1288},
	{"SGE_DEBUG_DATA_HIGH_INDEX_3", 0x128c},
	{"SGE_DEBUG_DATA_HIGH_INDEX_4", 0x1290},
	{"SGE_DEBUG_DATA_HIGH_INDEX_5", 0x1294},
	{"SGE_DEBUG_DATA_HIGH_INDEX_6", 0x1298},
	{"SGE_DEBUG_DATA_HIGH_INDEX_7", 0x129c},
	{"SGE_DEBUG_DATA_HIGH_INDEX_8", 0x12a0},
	{"SGE_DEBUG_DATA_HIGH_INDEX_9", 0x12a4},
	{"SGE_DEBUG_DATA_HIGH_INDEX_10", 0x12a8},
	{"SGE_DEBUG_DATA_HIGH_INDEX_11", 0x12ac},
	{"SGE_DEBUG_DATA_HIGH_INDEX_12", 0x12b0},
	{"SGE_DEBUG_DATA_HIGH_INDEX_13", 0x12b4},
	{"SGE_DEBUG_DATA_HIGH_INDEX_14", 0x12b8},
	{"SGE_DEBUG_DATA_HIGH_INDEX_15", 0x12bc},

};

static struct cudbg_reg_info sge_debug_data_low[] = {
	{"SGE_DEBUG_DATA_LOW_INDEX_0", 0x12c0},
	{"SGE_DEBUG_DATA_LOW_INDEX_1", 0x12c4},
	{"SGE_DEBUG_DATA_LOW_INDEX_2", 0x12c8},
	{"SGE_DEBUG_DATA_LOW_INDEX_3", 0x12cc},
	{"SGE_DEBUG_DATA_LOW_INDEX_4", 0x12d0},
	{"SGE_DEBUG_DATA_LOW_INDEX_5", 0x12d4},
	{"SGE_DEBUG_DATA_LOW_INDEX_6", 0x12d8},
	{"SGE_DEBUG_DATA_LOW_INDEX_7", 0x12dc},
	{"SGE_DEBUG_DATA_LOW_INDEX_8", 0x12e0},
	{"SGE_DEBUG_DATA_LOW_INDEX_9", 0x12e4},
	{"SGE_DEBUG_DATA_LOW_INDEX_10", 0x12e8},
	{"SGE_DEBUG_DATA_LOW_INDEX_11", 0x12ec},
	{"SGE_DEBUG_DATA_LOW_INDEX_12", 0x12f0},
	{"SGE_DEBUG_DATA_LOW_INDEX_13", 0x12f4},
	{"SGE_DEBUG_DATA_LOW_INDEX_14", 0x12f8},
	{"SGE_DEBUG_DATA_LOW_INDEX_15", 0x12fc},
};

static struct cudbg_reg_info t6_tp_pio_regs_60_to_6d[] = {
	{ "TP_DBG_CLEAR", 0x60, 0 },
	{ "TP_DBG_CORE_HDR0", 0x61, 0 },
	{ "S_RESERVED", 17, 15 },
	{ "S_E_TCP_OP_SRDY", 16, 1 },
	{ "S_E_PLD_TXZEROP_SRDY", 15, 1 },
	{ "S_E_PLD_RX_SRDY", 14, 1 },
	{ "S_E_RX_ERROR_SRDY", 13, 1 },
	{ "S_E_RX_ISS_SRDY", 12, 1 },
	{ "S_C_TCP_OP_SRDY", 11, 1 },
	{ "S_C_PLD_TXZEROP_SRDY", 10, 1 },
	{ "S_C_PLD_RX_SRDY", 9, 1 },
	{ "S_C_RX_ERROR_SRDY", 8, 1 },
	{ "S_C_RX_ISS_SRDY", 7, 1 },
	{ "S_E_CPL5_TXVALID", 6, 1 },
	{ "S_E_ETH_TXVALID", 5, 1 },
	{ "S_E_IP_TXVALID", 4, 1 },
	{ "S_E_TCP_TXVALID", 3, 1 },
	{ "S_C_CPL5_RXVALID", 2, 1 },
	{ "S_C_CPL5_TXVALID", 1, 1 },
	{ "S_E_TCP_OPT_RXVALID", 0, 1 },
	{ "TP_DBG_CORE_HDR1", 0x62, 0 },
	{ "S_RESERVED", 7, 25 },
	{ "S_E_CPL5_TXFULL", 6, 1 },
	{ "S_E_ETH_TXFULL", 5, 1 },
	{ "S_E_IP_TXFULL", 4, 1 },
	{ "S_E_TCP_TXFULL", 3, 1 },
	{ "S_C_CPL5_RXFULL", 2, 1 },
	{ "S_C_CPL5_TXFULL", 1, 1 },
	{ "S_E_TCP_OPT_RXFULL", 0, 1 },
	{ "TP_DBG_CORE_FATAL", 0x63, 0 },
	{ "S_EMSGFATAL", 31, 1 },
	{ "S_CMSGFATAL", 30, 1 },
	{ "S_PAWSFATAL", 29, 1 },
	{ "S_SRAMFATAL", 28, 1 },
	{ "S_CPCMDCONG", 24, 4 },
	{ "S_EPCMDCONG", 22, 2 },
	{ "S_CPCMDLENFATAL", 21, 1 },
	{ "S_EPCMDLENFATAL", 20, 1 },
	{ "S_CPCMDVALID", 16, 4 },
	{ "S_CPCMDAFULL", 12, 4 },
	{ "S_EPCMDVALID", 10, 2 },
	{ "S_EPCMDAFULL", 8, 2 },
	{ "S_CPCMDEOIFATAL", 7, 1 },
	{ "S_CPCMDTTLFATAL", 6, 1 },
	{ "S_CDATACHNFATAL", 5, 1 },
	{ "S_RESERVED", 4, 1 },
	{ "S_CNONZEROPPOPCNT", 2, 2 },
	{ "S_CPCMDEOICNT", 0, 2 },
	{ "TP_DBG_CORE_OUT", 0x64, 0 },
	{ "S_CRXBUSYOUT", 31, 1 },
	{ "S_CTXBUSYOUT", 30, 1 },
	{ "S_CRDCPLPKT", 29, 1 },
	{ "S_CRDTCPPKT", 28, 1 },
	{ "S_CNEWMSG", 27, 1 },
	{ "S_CCPLENC", 26, 1 },
	{ "S_CWRCPLPKT", 25, 1 },
	{ "S_CWRETHPKT", 24, 1 },
	{ "S_CWRIPPKT", 23, 1 },
	{ "S_CWRTCPPKT", 22, 1 },
	{ "S_CWRZEROP", 21, 1 },
	{ "S_CCPLTXFULL", 20, 1 },
	{ "S_CETHTXFULL", 19, 1 },
	{ "S_CIPTXFULL", 18, 1 },
	{ "S_CTCPTXFULL", 17, 1 },
	{ "S_CPLDTXZEROPDRDY", 16, 1 },
	{ "S_ERXBUSYOUT", 15, 1 },
	{ "S_ETXBUSYOUT", 14, 1 },
	{ "S_ERDCPLPKT", 13, 1 },
	{ "S_ERDTCPPKT", 12, 1 },
	{ "S_ENEWMSG", 11, 1 },
	{ "S_RESERVED1", 10, 1 },
	{ "S_EWRCPLPKT", 9, 1 },
	{ "S_EWRETHPKT", 8, 1 },
	{ "S_EWRIPPKT", 7, 1 },
	{ "S_EWRTCPPKT", 6, 1 },
	{ "S_EWRZEROP", 5, 1 },
	{ "S_ECPLTXFULL", 4, 1 },
	{ "S_EETHTXFULL", 3, 1 },
	{ "S_EIPTXFULL", 2, 1 },
	{ "S_ETCPTXFULL", 1, 1 },
	{ "S_EPLDTXZEROPDRDY", 0, 1 },
	{ "TP_DBG_CORE_TID", 0x65, 0 },
	{ "S_LINENUMBER", 24, 7 },
	{ "S_SPURIOUSMSG", 23, 1 },
	{ "S_SRC", 21, 2 },
	{ "S_SYNLEARNED", 20, 1 },
	{ "S_TIDVALUE", 0, 20 },
	{ "TP_DBG_ENG_RES0", 0x66, 0 },
	{ "S_RESOURCESREADY", 31, 1 },
	{ "S_RCFOPCODEOUTSRDY", 30, 1 },
	{ "S_RCFDATAOUTSRDY", 29, 1 },
	{ "S_FLUSHINPUTMSG", 28, 1 },
	{ "S_RCFOPSRCOUT", 26, 2 },
	{ "S_C_MSG", 25, 1 },
	{ "S_E_MSG", 24, 1 },
	{ "S_RCFOPCODEOUT", 20, 4 },
	{ "S_EFFRCFOPCODEOUT", 16, 4 },
	{ "S_SEENRESOURCESREADY", 15, 1 },
	{ "S_DELDRDY", 14, 1 },
	{ "S_OPCODEWAITSFORDATA", 13, 1 },
	{ "S_CPLDRXSRDY", 12, 1 },
	{ "S_CPLDRXZEROPSRDY", 11, 1 },
	{ "S_EPLDRXZEROPSRDY", 10, 1 },
	{ "S_ERXERRORSRDY", 9, 1 },
	{ "S_EPLDRXSRDY", 8, 1 },
	{ "S_CRXBUSY", 7, 1 },
	{ "S_ERXBUSY", 6, 1 },
	{ "S_TIMERINSERTBUSY", 5, 1 },
	{ "S_WCFBUSY", 4, 1 },
	{ "S_CTXBUSY", 3, 1 },
	{ "S_CPCMDBUSY", 2, 1 },
	{ "S_ETXBUSY", 1, 1 },
	{ "S_EPCMDBUSY", 0, 1 },
	{ "TP_DBG_ENG_RES1", 0x67, 0 },
	{ "S_RXCPLSRDY", 31, 1 },
	{ "S_RXOPTSRDY", 30, 1 },
	{ "S_RXPLDLENSRDY", 29, 1 },
	{ "S_RXISSSRDY", 28, 1 },
	{ "S_CPLCMDIN", 20, 8 },
	{ "S_RCFPTIDSRDY", 19, 1 },
	{ "S_EPDUHDRSRDY", 18, 1 },
	{ "S_TUNNELPKTREG", 17, 1 },
	{ "S_TXPKTCSUMSRDY", 16, 1 },
	{ "S_TABLEACCESSLATENCY", 12, 4 },
	{ "S_MMGRDONE", 11, 1 },
	{ "S_SEENMMGRDONE", 10, 1 },
	{ "S_RXERRORSRDY", 9, 1 },
	{ "S_RCFOPTIONSTCPSRDY", 8, 1 },
	{ "S_ENGINESTATE", 6, 2 },
	{ "S_TABLEACCESINCREMENT", 5, 1 },
	{ "S_TABLEACCESCOMPLETE", 4, 1 },
	{ "S_RCFOPCODEOUTUSABLE", 3, 1 },
	{ "S_RCFDATAOUTUSABLE", 2, 1 },
	{ "TP_DBG_ENG_RES2", 0x68, 0 },
	{ "S_CPLCMDRAW", 24, 8 },
	{ "S_RXMACPORT", 20, 4 },
	{ "S_TXECHANNEL", 18, 2 },
	{ "S_RXECHANNEL", 16, 2 },
	{ "S_CDATAOUT", 15, 1 },
	{ "S_CREADPDU", 14, 1 },
	{ "S_EDATAOUT", 13, 1 },
	{ "S_EREADPDU", 12, 1 },
	{ "S_ETCPOPSRDY", 11, 1 },
	{ "S_CTCPOPSRDY", 10, 1 },
	{ "S_CPKTOUT", 9, 1 },
	{ "S_CMDBRSPSRDY", 8, 1 },
	{ "S_RXPSTRUCTSFULL", 6, 2 },
	{ "S_RXPAGEPOOLFULL", 4, 2 },
	{ "S_RCFREASONOUT", 0, 4 },
	{ "TP_DBG_CORE_PCMD", 0x69, 0 },
	{ "S_CPCMDEOPCNT", 30, 2 },
	{ "S_CPCMDLENSAVE", 16, 14 },
	{ "S_EPCMDEOPCNT", 14, 2 },
	{ "S_EPCMDLENSAVE", 0, 14 },
	{ "TP_DBG_SCHED_TX", 0x6A, 0 },
	{ "S_TXCHNXOFF", 28, 4 },
	{ "S_TXFIFOCNG", 24, 4 },
	{ "S_TXPCMDCNG", 20, 4 },
	{ "S_TXLPBKCNG", 16, 4 },
	{ "S_TXHDRCNG", 8, 8 },
	{ "S_TXMODXOFF", 0, 8 },
	{ "TP_DBG_SCHED_RX", 0x6B, 0 },
	{ "S_RXCHNXOFF", 28, 4 },
	{ "S_RXSGECNG", 24, 4 },
	{ "S_RXFIFOCNG", 20, 4 },
	{ "S_RXLPBKCNG", 16, 4 },
	{ "S_RXPCMDCNG", 14, 2 },
	{ "S_RESERVED0", 12, 2 },
	{ "S_RXHDRCNG", 8, 4 },
	{ "S_RESERVED0", 2, 6 },
	{ "S_RXMODXOFF", 0, 2 },
	{ "TP_DBG_ERROR_CNT", 0x6C, 0 },
	{ "TP_DBG_CORE_CPL", 0x6d, 0 },
	{ "CplCmdOut3", 24, 8 },
	{ "CplCmdOut2", 16, 8 },
	{ "CplCmdOut1", 8, 8 },
	{ "CplCmdOut0", 0, 8 },
	{ NULL }
};


static struct cudbg_reg_info t5_tp_pio_regs_60_to_6c[] = {
	{ "TP_DBG_CLEAR", 0x60, 0 },
	{ "TP_DBG_CORE_HDR0", 0x61, 0 },
	{ "S_RESERVED", 17, 15 },
	{ "S_E_TCP_OP_SRDY", 16, 1 },
	{ "S_E_PLD_TXZEROP_SRDY", 15, 1 },
	{ "S_E_PLD_RX_SRDY", 14, 1 },
	{ "S_E_RX_ERROR_SRDY", 13, 1 },
	{ "S_E_RX_ISS_SRDY", 12, 1 },
	{ "S_C_TCP_OP_SRDY", 11, 1 },
	{ "S_C_PLD_TXZEROP_SRDY", 10, 1 },
	{ "S_C_PLD_RX_SRDY", 9, 1 },
	{ "S_C_RX_ERROR_SRDY", 8, 1 },
	{ "S_C_RX_ISS_SRDY", 7, 1 },
	{ "S_E_CPL5_TXVALID", 6, 1 },
	{ "S_E_ETH_TXVALID", 5, 1 },
	{ "S_E_IP_TXVALID", 4, 1 },
	{ "S_E_TCP_TXVALID", 3, 1 },
	{ "S_C_CPL5_RXVALID", 2, 1 },
	{ "S_C_CPL5_TXVALID", 1, 1 },
	{ "S_E_TCP_OPT_RXVALID", 0, 1 },
	{ "TP_DBG_CORE_HDR1", 0x62, 0 },
	{ "S_RESERVED", 7, 25 },
	{ "S_E_CPL5_TXFULL", 6, 1 },
	{ "S_E_ETH_TXFULL", 5, 1 },
	{ "S_E_IP_TXFULL", 4, 1 },
	{ "S_E_TCP_TXFULL", 3, 1 },
	{ "S_C_CPL5_RXFULL", 2, 1 },
	{ "S_C_CPL5_TXFULL", 1, 1 },
	{ "S_E_TCP_OPT_RXFULL", 0, 1 },
	{ "TP_DBG_CORE_FATAL", 0x63, 0 },
	{ "S_EMSGFATAL", 31, 1 },
	{ "S_CMSGFATAL", 30, 1 },
	{ "S_PAWSFATAL", 29, 1 },
	{ "S_SRAMFATAL", 28, 1 },
	{ "S_CPCMDCONG", 24, 4 },
	{ "S_EPCMDCONG", 22, 2 },
	{ "S_CPCMDLENFATAL", 21, 1 },
	{ "S_EPCMDLENFATAL", 20, 1 },
	{ "S_CPCMDVALID", 16, 4 },
	{ "S_CPCMDAFULL", 12, 4 },
	{ "S_EPCMDVALID", 10, 2 },
	{ "S_EPCMDAFULL", 8, 2 },
	{ "S_CPCMDEOIFATAL", 7, 1 },
	{ "S_CPCMDTTLFATAL", 6, 1 },
	{ "S_CDATACHNFATAL", 5, 1 },
	{ "S_RESERVED", 4, 1 },
	{ "S_CNONZEROPPOPCNT", 2, 2 },
	{ "S_CPCMDEOICNT", 0, 2 },
	{ "TP_DBG_CORE_OUT", 0x64, 0 },
	{ "S_CRXBUSYOUT", 31, 1 },
	{ "S_CTXBUSYOUT", 30, 1 },
	{ "S_CRDCPLPKT", 29, 1 },
	{ "S_CRDTCPPKT", 28, 1 },
	{ "S_CNEWMSG", 27, 1 },
	{ "S_CCPLENC", 26, 1 },
	{ "S_CWRCPLPKT", 25, 1 },
	{ "S_CWRETHPKT", 24, 1 },
	{ "S_CWRIPPKT", 23, 1 },
	{ "S_CWRTCPPKT", 22, 1 },
	{ "S_CWRZEROP", 21, 1 },
	{ "S_CCPLTXFULL", 20, 1 },
	{ "S_CETHTXFULL", 19, 1 },
	{ "S_CIPTXFULL", 18, 1 },
	{ "S_CTCPTXFULL", 17, 1 },
	{ "S_CPLDTXZEROPDRDY", 16, 1 },
	{ "S_RESERVED1", 10, 1 },
	{ "S_EWRCPLPKT", 9, 1 },
	{ "S_EWRETHPKT", 8, 1 },
	{ "S_EWRIPPKT", 7, 1 },
	{ "S_EWRTCPPKT", 6, 1 },
	{ "S_EWRZEROP", 5, 1 },
	{ "S_ECPLTXFULL", 4, 1 },
	{ "S_EETHTXFULL", 3, 1 },
	{ "S_EIPTXFULL", 2, 1 },
	{ "S_ETCPTXFULL", 1, 1 },
	{ "S_EPLDTXZEROPDRDY", 0, 1 },
	{ "TP_DBG_CORE_TID", 0x65, 0 },
	{ "S_LINENUMBER", 24, 7 },
	{ "S_SPURIOUSMSG", 23, 1 },
	{ "S_SRC", 21, 2 },
	{ "S_SYNLEARNED", 20, 1 },
	{ "S_TIDVALUE", 0, 20 },
	{ "TP_DBG_ENG_RES0", 0x66, 0 },
	{ "S_RESOURCESREADY", 31, 1 },
	{ "S_RCFOPCODEOUTSRDY", 30, 1 },
	{ "S_RCFDATAOUTSRDY", 29, 1 },
	{ "S_FLUSHINPUTMSG", 28, 1 },
	{ "S_RCFOPSRCOUT", 26, 2 },
	{ "S_C_MSG", 25, 1 },
	{ "S_E_MSG", 24, 1 },
	{ "S_RCFOPCODEOUT", 20, 4 },
	{ "S_EFFRCFOPCODEOUT", 16, 4 },
	{ "S_SEENRESOURCESREADY", 15, 1 },
	{ "S_DELDRDY", 14, 1 },
	{ "S_OPCODEWAITSFORDATA", 13, 1 },
	{ "S_CPLDRXSRDY", 12, 1 },
	{ "S_CPLDRXZEROPSRDY", 11, 1 },
	{ "S_EPLDRXZEROPSRDY", 10, 1 },
	{ "S_ERXERRORSRDY", 9, 1 },
	{ "S_EPLDRXSRDY", 8, 1 },
	{ "S_CRXBUSY", 7, 1 },
	{ "S_ERXBUSY", 6, 1 },
	{ "S_TIMERINSERTBUSY", 5, 1 },
	{ "S_WCFBUSY", 4, 1 },
	{ "S_CTXBUSY", 3, 1 },
	{ "S_CPCMDBUSY", 2, 1 },
	{ "S_ETXBUSY", 1, 1 },
	{ "S_EPCMDBUSY", 0, 1 },
	{ "TP_DBG_ENG_RES1", 0x67, 0 },
	{ "S_RXCPLSRDY", 31, 1 },
	{ "S_RXOPTSRDY", 30, 1 },
	{ "S_RXPLDLENSRDY", 29, 1 },
	{ "S_RXNOTBUSY", 28, 1 },
	{ "S_CPLCMDIN", 20, 8 },
	{ "S_RCFPTIDSRDY", 19, 1 },
	{ "S_EPDUHDRSRDY", 18, 1 },
	{ "S_TUNNELPKTREG", 17, 1 },
	{ "S_TXPKTCSUMSRDY", 16, 1 },
	{ "S_TABLEACCESSLATENCY", 12, 4 },
	{ "S_MMGRDONE", 11, 1 },
	{ "S_SEENMMGRDONE", 10, 1 },
	{ "S_RXERRORSRDY", 9, 1 },
	{ "S_RCFOPTIONSTCPSRDY", 8, 1 },
	{ "S_ENGINESTATE", 6, 2 },
	{ "S_TABLEACCESINCREMENT", 5, 1 },
	{ "S_TABLEACCESCOMPLETE", 4, 1 },
	{ "S_RCFOPCODEOUTUSABLE", 3, 1 },
	{ "S_RCFDATAOUTUSABLE", 2, 1 },
	{ "S_RCFDATAWAITAFTERRD", 1, 1 },
	{ "S_RCFDATACMRDY", 0, 1 },
	{ "TP_DBG_ENG_RES2", 0x68, 0 },
	{ "S_CPLCMDRAW", 24, 8 },
	{ "S_RXMACPORT", 20, 4 },
	{ "S_TXECHANNEL", 18, 2 },
	{ "S_RXECHANNEL", 16, 2 },
	{ "S_CDATAOUT", 15, 1 },
	{ "S_CREADPDU", 14, 1 },
	{ "S_EDATAOUT", 13, 1 },
	{ "S_EREADPDU", 12, 1 },
	{ "S_ETCPOPSRDY", 11, 1 },
	{ "S_CTCPOPSRDY", 10, 1 },
	{ "S_CPKTOUT", 9, 1 },
	{ "S_CMDBRSPSRDY", 8, 1 },
	{ "S_RXPSTRUCTSFULL", 6, 2 },
	{ "S_RXPAGEPOOLFULL", 4, 2 },
	{ "S_RCFREASONOUT", 0, 4 },
	{ "TP_DBG_CORE_PCMD", 0x69, 0 },
	{ "S_CPCMDEOPCNT", 30, 2 },
	{ "S_CPCMDLENSAVE", 16, 14 },
	{ "S_EPCMDEOPCNT", 14, 2 },
	{ "S_EPCMDLENSAVE", 0, 14 },
	{ "TP_DBG_SCHED_TX", 0x6A, 0 },
	{ "S_TXCHNXOFF", 28, 4 },
	{ "S_TXFIFOCNG", 24, 4 },
	{ "S_TXPCMDCNG", 20, 4 },
	{ "S_TXLPBKCNG", 16, 4 },
	{ "S_TXHDRCNG", 8, 8 },
	{ "S_TXMODXOFF", 0, 8 },
	{ "TP_DBG_SCHED_RX", 0x6B, 0 },
	{ "S_RXCHNXOFF", 28, 4 },
	{ "S_RXSGECNG", 24, 4 },
	{ "S_RXFIFOCNG", 20, 4 },
	{ "S_RXLPBKCNG", 16, 4 },
	{ "S_RXPCMDCNG", 14, 2 },
	{ "S_RESERVED0", 12, 2 },
	{ "S_RXHDRCNG", 8, 4 },
	{ "S_RESERVED0", 2, 6 },
	{ "S_RXMODXOFF", 0, 2 },
	{ "TP_DBG_ERROR_CNT", 0x6C, 0 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_6f[] = {
	{ "TP_MIB_DEBUG", 0x6F, 0 },
	{ "S_SRC3", 31, 1 },
	{ "S_LINENUM3", 24, 7 },
	{ "S_SRC2", 23, 1 },
	{ "S_LINENUM2", 16, 7 },
	{ "S_SRC1", 15, 1 },
	{ "S_LINENUM1", 8, 7 },
	{ "S_SRC0", 7, 1 },
	{ "S_LINENUM0", 0, 7 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_130_to_141[] = {
	{ "TP_DBG_ESIDE_PKT0", 0x130, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_PKT1", 0x131, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_PKT2", 0x132, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_PKT3", 0x133, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_FIFO0", 0x134, 0 },
	{ "S_PLDRXCSUMVALID1", 31, 1 },
	{ "S_PLDRXZEROPSRDY1", 30, 1 },
	{ "S_PLDRXVALID1", 29, 1 },
	{ "S_TCPRXVALID1", 28, 1 },
	{ "S_IPRXVALID1", 27, 1 },
	{ "S_ETHRXVALID1", 26, 1 },
	{ "S_CPLRXVALID1", 25, 1 },
	{ "S_FSTATIC1", 24, 1 },
	{ "S_ERRORSRDY1", 23, 1 },
	{ "S_PLDTXSRDY1", 22, 1 },
	{ "S_DBVLD1", 21, 1 },
	{ "S_PLDTXVALID1", 20, 1 },
	{ "S_ETXVALID1", 19, 1 },
	{ "S_ETXFULL1", 18, 1 },
	{ "S_ERXVALID1", 17, 1 },
	{ "S_ERXFULL1", 16, 1 },
	{ "S_PLDRXCSUMVALID0", 15, 1 },
	{ "S_PLDRXZEROPSRDY0", 14,  1},
	{ "S_PLDRXVALID0", 13, 1 },
	{ "S_TCPRXVALID0", 12, 1 },
	{ "S_IPRXVALID0", 11, 1 },
	{ "S_ETHRXVALID0", 10, 1 },
	{ "S_CPLRXVALID0", 9, 1 },
	{ "S_FSTATIC0", 8, 1 },
	{ "S_ERRORSRDY0", 7, 1 },
	{ "S_PLDTXSRDY0", 6, 1 },
	{ "S_DBVLD0", 5, 1 },
	{ "S_PLDTXVALID0", 4, 1 },
	{ "S_ETXVALID0", 3, 1 },
	{ "S_ETXFULL0", 2, 1 },
	{ "S_ERXVALID0", 1, 1 },
	{ "S_ERXFULL0", 0, 1 },
	{ "TP_DBG_ESIDE_FIFO1", 0x135, 0 },
	{ "S_PLDRXCSUMVALID3", 31, 1 },
	{ "S_PLDRXZEROPSRDY3", 30, 1 },
	{ "S_PLDRXVALID3", 29, 1 },
	{ "S_TCPRXVALID3", 28, 1 },
	{ "S_IPRXVALID3", 27, 1 },
	{ "S_ETHRXVALID3", 26, 1 },
	{ "S_CPLRXVALID3", 25, 1 },
	{ "S_FSTATIC3", 24, 1 },
	{ "S_ERRORSRDY3", 23, 1 },
	{ "S_PLDTXSRDY3", 22, 1 },
	{ "S_DBVLD3", 21, 1 },
	{ "S_PLDTXVALID3", 20, 1 },
	{ "S_ETXVALID3", 19, 1 },
	{ "S_ETXFULL3", 18, 1 },
	{ "S_ERXVALID3", 17, 1 },
	{ "S_ERXFULL3", 16, 1 },
	{ "S_PLDRXCSUMVALID2", 15, 1 },
	{ "S_PLDRXZEROPSRDY2", 14,  1},
	{ "S_PLDRXVALID2", 13, 1 },
	{ "S_TCPRXVALID2", 12, 1 },
	{ "S_IPRXVALID2", 11, 1 },
	{ "S_ETHRXVALID2", 10, 1 },
	{ "S_CPLRXVALID2", 9, 1 },
	{ "S_FSTATIC2", 8, 1 },
	{ "S_ERRORSRDY2", 7, 1 },
	{ "S_PLDTXSRDY2", 6, 1 },
	{ "S_DBVLD2", 5, 1 },
	{ "S_PLDTXVALID2", 4, 1 },
	{ "S_ETXVALID2", 3, 1 },
	{ "S_ETXFULL2", 2, 1 },
	{ "S_ERXVALID2", 1, 1 },
	{ "S_ERXFULL2", 0, 1 },
	{ "TP_DBG_ESIDE_DISP0", 0x136, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_FIFOGRERXVALID", 15, 1 },
	{ "S_FIFOGRERXREADY", 14, 1 },
	{ "S_FIFOGRERXSOCP", 13, 1 },
	{ "S_ESTATIC4", 12, 1 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_DISP1", 0x137, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_FIFOGRERXVALID", 15, 1 },
	{ "S_FIFOGRERXREADY", 14, 1 },
	{ "S_FIFOGRERXSOCP", 13, 1 },
	{ "S_ESTATIC4", 12, 1 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_MAC_MATCH_MAP0", 0x138, 0 },
	{ "S_MAPVALUEWR", 16, 8 },
	{ "S_RESERVED", 11, 5 },
	{ "S_MAPINDEX", 2, 9 },
	{ "S_MAPREAD", 1, 1 },
	{ "S_MAPWRITE", 0, 1 },
	{ "TP_MAC_MATCH_MAP1", 0x139, 0 },
	{ "S_RESERVED", 9, 15 },
	{ "S_MAPVALUERD", 0, 9 },
	{ "TP_DBG_ESIDE_DISP2", 0x13A, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_FIFOGRERXVALID", 15, 1 },
	{ "S_FIFOGRERXREADY", 14, 1 },
	{ "S_FIFOGRERXSOCP", 13, 1 },
	{ "S_ESTATIC4", 12, 1 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_DISP3", 0x13B, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_FIFOGRERXVALID", 15, 1 },
	{ "S_FIFOGRERXREADY", 14, 1 },
	{ "S_FIFOGRERXSOCP", 13, 1 },
	{ "S_ESTATIC4", 12, 1 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_HDR0", 0x13C, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_HDR1", 0x13D, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_HDR2", 0x13E, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_HDR3", 0x13F, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_VLAN_PRI_MAP", 0x140, 0 },
	{ "S_FILTERMODE", 15, 1 },
	{ "S_FCOEMASK", 14, 1 },
	{ "S_SRVRSRAM", 13, 1 },
	{ "S_FRAGMENTATION", 9, 1 },
	{ "S_MPSHITTYPE", 8, 1 },
	{ "S_MACMATCH", 7, 1 },
	{ "S_ETHERTYPE", 6, 1 },
	{ "S_PROTOCOL", 5, 1 },
	{ "S_TOS", 4,  1},
	{ "S_VLAN", 3, 1 },
	{ "S_VNIC_ID", 2, 1 },
	{ "S_PORT", 1, 1 },
	{ "S_FCOE", 0, 1 },
	{ "TP_INGRESS_CONFIG", 0x141, 0 },
	{ "S_OPAQUE_TYPE", 16, 16 },
	{ "S_OPAQUE_RM", 15, 1 },
	{ "S_OPAQUE_HDR_SIZE", 14,  1},
	{ "S_OPAQUE_RM_MAC_IN_MAC", 13, 1 },
	{ "S_FRAG_LEN_MOD8_COMPAT", 12, 1 },
	{ "S_VNIC", 11, 1 },
	{ "S_CSUM_HAS_PSEUDO_HDR", 10, 1 },
	{ "S_RM_OVLAN", 9, 1 },
	{ "S_LOOKUPEVERYPKT", 8, 1 },
	{ "S_IPV6_EXT_HDR_SKIP", 0, 8 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_145_to_157[] = {
	{ "TP_INGRESS_CONFIG2", 0x145, 0 },
	{ "S_IPV6_UDP_CSUM_COMPAT", 31, 1 },
	{ "S_VNTAGPLDENABLE", 30, 1 },
	{ "S_TCP_PLD_FILTER_OFFSET", 20,  10},
	{ "S_UDP_PLD_FILTER_OFFSET", 10, 10 },
	{ "S_TNL_PLD_FILTER_OFFSET", 0, 10 },
	{ "TP_EHDR_CONFIG_LO", 0x146, 0 },
	{ "S_CPLLIMIT", 24, 8 },
	{ "S_ETHLIMIT", 16, 8 },
	{ "S_IPLIMIT", 8, 8 },
	{ "S_TCPLIMIT", 0, 8 },
	{ "TP_EHDR_CONFIG_HI", 0x147, 0 },
	{ "S_CPLLIMIT", 24, 8 },
	{ "S_ETHLIMIT", 16, 8 },
	{ "S_IPLIMIT", 8, 8 },
	{ "S_TCPLIMIT", 0, 8 },
	{ "TP_DBG_ESIDE_INT", 0x148, 0 },
	{ "S_ERXSOP2X", 28, 4 },
	{ "S_ERXEOP2X", 24, 4 },
	{ "S_ERXVALID2X", 20, 4 },
	{ "S_ERXAFULL2X", 16, 4 },
	{ "S_PLD2XTXVALID", 12, 4 },
	{ "S_PLD2XTXAFULL", 8, 4 },
	{ "S_ERRORSRDY", 7, 1 },
	{ "S_ERRORDRDY", 6, 1 },
	{ "S_TCPOPSRDY", 5, 1 },
	{ "S_TCPOPDRDY", 4, 1 },
	{ "S_PLDTXSRDY", 3, 1 },
	{ "S_PLDTXDRDY", 2, 1 },
	{ "S_TCPOPTTXVALID", 1, 1 },
	{ "S_TCPOPTTXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_DEMUX", 0x149, 0 },
	{ "S_EALLDONE", 28, 4 },
	{ "S_EFIFOPLDDONE", 24, 4 },
	{ "S_EDBDONE", 20, 4 },
	{ "S_EISSFIFODONE", 16, 4 },
	{ "S_EACKERRFIFODONE", 12, 4 },
	{ "S_EFIFOERRORDONE", 8, 4 },
	{ "S_ERXPKTATTRFIFOFDONE", 4, 4 },
	{ "S_ETCPOPDONE", 0, 4 },
	{ "TP_DBG_ESIDE_IN0", 0x14A, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_IN1", 0x14B, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_IN2", 0x14C, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_IN3", 0x14D, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_FRM", 0x14E, 0 },
	{ "S_ERX2XERROR", 28, 4 },
	{ "S_EPLDTX2XERROR", 24, 4 },
	{ "S_ETXERROR", 20, 4 },
	{ "S_EPLDRXERROR", 16, 4 },
	{ "S_ERXSIZEERROR3", 12, 4 },
	{ "S_ERXSIZEERROR2", 8, 4 },
	{ "S_ERXSIZEERROR1", 4, 4 },
	{ "S_ERXSIZEERROR0", 0, 4 },
	{ "TP_DBG_ESIDE_DRP", 0x14F, 0 },
	{ "S_RXDROP3", 24, 8 },
	{ "S_RXDROP2", 16, 8 },
	{ "S_RXDROP1", 8, 8 },
	{ "S_RXDROP0", 0, 8 },
	{ "TP_DBG_ESIDE_TX", 0x150, 0 },
	{ "TXERRORCNT", 8, 24 },
	{ "S_ETXVALID", 4, 4 },
	{ "S_ETXFULL", 0, 4 },
	{ "TP_ESIDE_SVID_MASK", 0x151, 0 },
	{ "TP_ESIDE_DVID_MASK", 0x152, 0 },
	{ "TP_ESIDE_ALIGN_MASK", 0x153, 0 },
	{ "S_USE_LOOP_BIT", 24, 1 },
	{ "S_LOOP_OFFSET", 16, 8 },
	{ "S_DVID_ID_OFFSET", 8, 8 },
	{ "S_SVID_ID_OFFSET", 0, 8 },
	{ "TP_DBG_ESIDE_OP", 0x154, 0 },
	{ "S_RESERVED0", 30, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL0", 29, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL0", 28, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL0", 26, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL0", 24, 2 },
	{ "S_RESERVED1", 22, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL1", 21, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL1", 20, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL1", 18, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL1", 16, 2 },
	{ "S_RESERVED2", 14, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL2", 13, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL2", 12, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL2", 10, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL2", 8, 2 },
	{ "S_RESERVED3", 6, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL3", 5, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL3", 4, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL3", 2, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL3", 0, 2 },
	{ "TP_DBG_ESIDE_OP_ALT", 0x155, 0 },
	{ "S_RESERVED0", 30, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL0", 29, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL0", 24, 5 },
	{ "S_RESERVED1", 22, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL1", 21, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL1", 16, 5 },
	{ "S_RESERVED2", 14, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL2", 13, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL2", 8, 5 },
	{ "S_RESERVED3", 6, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL3", 5, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL3", 0, 5 },
	{ "TP_DBG_ESIDE_OP_BUSY", 0x156, 0 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL3", 24, 8 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL2", 16, 8 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL1", 8, 8 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL0", 0, 8 },
	{ "TP_DBG_ESIDE_OP_COOKIE", 0x157, 0 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL3", 24, 8 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL2", 16, 8 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL1", 8, 8 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL0", 0, 8 },
	{ NULL }

};

static struct cudbg_reg_info t6_tp_pio_regs_160[] = {
	{ "TP_ESIDE_CONFIG", 0x160, 0 },
	{ "VNI_EN", 26, 1 },
	{ "ENC_RX_EN", 25, 1 },
	{ "TNL_LKP_INNER_SEL", 24, 1 },
	{ "AttackFilterEnable", 23, 1 },
	{ "PingDrop", 20, 1 },
	{ "FragmentDrop", 19, 1 },
	{ "RoCEv2UDPPort", 0, 16 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_70_to_75[] = {
	{ "TP_DBG_CACHE_WR_ALL", 0x70, 0 },
	{ "TP_DBG_CACHE_WR_HIT", 0x71, 0 },
	{ "TP_DBG_CACHE_RD_ALL", 0x72, 0 },
	{ "TP_DBG_CACHE_RD_HIT", 0x73, 0 },
	{ "TP_DBG_CACHE_MC_REQ", 0x74, 0 },
	{ "TP_DBG_CACHE_MC_RSP", 0x75, 0 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_6f[] = {
	{ "TP_MIB_DEBUG", 0x6F, 0 },
	{ "S_SRC3", 31, 1 },
	{ "S_LINENUM3", 24, 7 },
	{ "S_SRC2", 23, 1 },
	{ "S_LINENUM2", 16, 7 },
	{ "S_SRC1", 15, 1 },
	{ "S_LINENUM1", 8, 7 },
	{ "S_SRC0", 7, 1 },
	{ "S_LINENUM0", 0, 7 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_120_to_123[] = {
	{ "TP_TX_DROP_CNT_CH0", 0x120, 0 },
	{ "TP_TX_DROP_CNT_CH1", 0x121, 0 },
	{ "TP_TX_DROP_CNT_CH2", 0x122, 0 },
	{ "TP_TX_DROP_CNT_CH3", 0x123, 0 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_12b_to_12c[] = {
	{ "TP_TX_DROP_CFG_CH0", 0x12B, 0 },
	{ "S_TIMERENABLED", 31, 1 },
	{ "S_TIMERERRORENABLE", 30, 1 },
	{ "S_TIMERTHRESHOLD", 4, 26 },
	{ "S_PACKETDROPS", 0, 4 },
	{ "TP_TX_DROP_CFG_CH1", 0x12C, 0 },
	{ "S_TIMERENABLED", 31, 1 },
	{ "S_TIMERERRORENABLE", 30, 1 },
	{ "S_TIMERTHRESHOLD", 4, 26 },
	{ "S_PACKETDROPS", 0, 4 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_12f_to_143[] = {
	{ "TP_TX_DROP_MODE", 0x12F, 0 },
	{ "S_TXDROPMODECH3", 3, 1 },
	{ "S_TXDROPMODECH2", 2, 1 },
	{ "S_TXDROPMODECH1", 1, 1 },
	{ "S_TXDROPMODECH0", 0, 1 },
	{ "TP_DBG_ESIDE_PKT0", 0x130, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_PKT1", 0x131, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_PKT2", 0x132, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_PKT3", 0x133, 0 },
	{ "S_ETXSOPCNT", 28, 4 },
	{ "S_ETXEOPCNT", 24, 4 },
	{ "S_ETXPLDSOPCNT", 20, 4 },
	{ "S_ETXPLDEOPCNT", 16, 4 },
	{ "S_ERXSOPCNT", 12, 4 },
	{ "S_ERXEOPCNT", 8, 4 },
	{ "S_ERXPLDSOPCNT", 4, 4 },
	{ "S_ERXPLDEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_FIFO0", 0x134, 0 },
	{ "S_PLDRXCSUMVALID1", 31, 1 },
	{ "S_PLDRXZEROPSRDY1", 30, 1 },
	{ "S_PLDRXVALID1", 29, 1 },
	{ "S_TCPRXVALID1", 28, 1 },
	{ "S_IPRXVALID1", 27, 1 },
	{ "S_ETHRXVALID1", 26, 1 },
	{ "S_CPLRXVALID1", 25, 1 },
	{ "S_FSTATIC1", 24, 1 },
	{ "S_ERRORSRDY1", 23, 1 },
	{ "S_PLDTXSRDY1", 22, 1 },
	{ "S_DBVLD1", 21, 1 },
	{ "S_PLDTXVALID1", 20, 1 },
	{ "S_ETXVALID1", 19, 1 },
	{ "S_ETXFULL1", 18, 1 },
	{ "S_ERXVALID1", 17, 1 },
	{ "S_ERXFULL1", 16, 1 },
	{ "S_PLDRXCSUMVALID0", 15, 1 },
	{ "S_PLDRXZEROPSRDY0", 14,  1},
	{ "S_PLDRXVALID0", 13, 1 },
	{ "S_TCPRXVALID0", 12, 1 },
	{ "S_IPRXVALID0", 11, 1 },
	{ "S_ETHRXVALID0", 10, 1 },
	{ "S_CPLRXVALID0", 9, 1 },
	{ "S_FSTATIC0", 8, 1 },
	{ "S_ERRORSRDY0", 7, 1 },
	{ "S_PLDTXSRDY0", 6, 1 },
	{ "S_DBVLD0", 5, 1 },
	{ "S_PLDTXVALID0", 4, 1 },
	{ "S_ETXVALID0", 3, 1 },
	{ "S_ETXFULL0", 2, 1 },
	{ "S_ERXVALID0", 1, 1 },
	{ "S_ERXFULL0", 0, 1 },
	{ "TP_DBG_ESIDE_FIFO1", 0x135, 0 },
	{ "S_PLDRXCSUMVALID3", 31, 1 },
	{ "S_PLDRXZEROPSRDY3", 30, 1 },
	{ "S_PLDRXVALID3", 29, 1 },
	{ "S_TCPRXVALID3", 28, 1 },
	{ "S_IPRXVALID3", 27, 1 },
	{ "S_ETHRXVALID3", 26, 1 },
	{ "S_CPLRXVALID3", 25, 1 },
	{ "S_FSTATIC3", 24, 1 },
	{ "S_ERRORSRDY3", 23, 1 },
	{ "S_PLDTXSRDY3", 22, 1 },
	{ "S_DBVLD3", 21, 1 },
	{ "S_PLDTXVALID3", 20, 1 },
	{ "S_ETXVALID3", 19, 1 },
	{ "S_ETXFULL3", 18, 1 },
	{ "S_ERXVALID3", 17, 1 },
	{ "S_ERXFULL3", 16, 1 },
	{ "S_PLDRXCSUMVALID2", 15, 1 },
	{ "S_PLDRXZEROPSRDY2", 14,  1},
	{ "S_PLDRXVALID2", 13, 1 },
	{ "S_TCPRXVALID2", 12, 1 },
	{ "S_IPRXVALID2", 11, 1 },
	{ "S_ETHRXVALID2", 10, 1 },
	{ "S_CPLRXVALID2", 9, 1 },
	{ "S_FSTATIC2", 8, 1 },
	{ "S_ERRORSRDY2", 7, 1 },
	{ "S_PLDTXSRDY2", 6, 1 },
	{ "S_DBVLD2", 5, 1 },
	{ "S_PLDTXVALID2", 4, 1 },
	{ "S_ETXVALID2", 3, 1 },
	{ "S_ETXFULL2", 2, 1 },
	{ "S_ERXVALID2", 1, 1 },
	{ "S_ERXFULL2", 0, 1 },
	{ "TP_DBG_ESIDE_DISP0", 0x136, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_ESTATIC4", 12, 4 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_DISP1", 0x137, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_ESTATIC4", 12, 4 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_MAC_MATCH_MAP0", 0x138, 0 },
	{ "S_MAPVALUEWR", 16, 8 },
	{ "S_RESERVED", 11, 5 },
	{ "S_MAPINDEX", 2, 9 },
	{ "S_MAPREAD", 1, 1 },
	{ "S_MAPWRITE", 0, 1 },
	{ "TP_MAC_MATCH_MAP1", 0x139, 0 },
	{ "S_RESERVED", 9, 15 },
	{ "S_MAPVALUERD", 0, 9 },
	{ "TP_DBG_ESIDE_DISP2", 0x13A, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_ESTATIC4", 12, 4 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_DISP3", 0x13B, 0 },
	{ "S_RESRDY", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_FIFOCPL5RXVALID", 27, 1 },
	{ "S_FIFOETHRXVALID", 26, 1 },
	{ "S_FIFOETHRXSOCP", 25, 1 },
	{ "S_FIFOPLDRXZEROP", 24, 1 },
	{ "S_PLDRXVALID", 23, 1 },
	{ "S_FIFOPLDRXZEROP_SRDY", 22, 1 },
	{ "S_FIFOIPRXVALID", 21, 1 },
	{ "S_FIFOTCPRXVALID", 20, 1 },
	{ "S_PLDRXCSUMVALID", 19, 1 },
	{ "S_FIFOIPCSUMSRDY", 18, 1 },
	{ "S_FIFOIPPSEUDOCSUMSRDY", 17, 1 },
	{ "S_FIFOTCPCSUMSRDY", 16, 1 },
	{ "S_ESTATIC4", 12, 4 },
	{ "S_FIFOCPLSOCPCNT", 10, 2 },
	{ "S_FIFOETHSOCPCNT", 8, 2 },
	{ "S_FIFOIPSOCPCNT", 6,  2},
	{ "S_FIFOTCPSOCPCNT", 4, 2 },
	{ "S_PLD_RXZEROP_CNT", 2, 2 },
	{ "S_ESTATIC6", 1, 1 },
	{ "S_TXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_HDR0", 0x13C, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_HDR1", 0x13D, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_HDR2", 0x13E, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_DBG_ESIDE_HDR3", 0x13F, 0 },
	{ "S_TCPSOPCNT", 28, 4 },
	{ "S_TCPEOPCNT", 24, 4 },
	{ "S_IPSOPCNT", 20, 4 },
	{ "S_IPEOPCNT", 16, 4 },
	{ "S_ETHSOPCNT", 12, 4 },
	{ "S_ETHEOPCNT", 8, 4 },
	{ "S_CPLSOPCNT", 4, 4 },
	{ "S_CPLEOPCNT", 0, 4 },
	{ "TP_VLAN_PRI_MAP", 0x140, 0 },
	{ "S_FILTERMODE", 15, 1 },
	{ "S_FCOEMASK", 14, 1 },
	{ "S_SRVRSRAM", 13, 1 },
	{ "S_FRAGMENTATION", 9, 1 },
	{ "S_MPSHITTYPE", 8, 1 },
	{ "S_MACMATCH", 7, 1 },
	{ "S_ETHERTYPE", 6, 1 },
	{ "S_PROTOCOL", 5, 1 },
	{ "S_TOS", 4,  1},
	{ "S_VLAN", 3, 1 },
	{ "S_VNIC_ID", 2, 1 },
	{ "S_PORT", 1, 1 },
	{ "S_FCOE", 0, 1 },
	{ "TP_INGRESS_CONFIG", 0x141, 0 },
	{ "S_OPAQUE_TYPE", 16, 16 },
	{ "S_OPAQUE_RM", 15, 1 },
	{ "S_OPAQUE_HDR_SIZE", 14,  1},
	{ "S_OPAQUE_RM_MAC_IN_MAC", 13, 1 },
	{ "S_FRAG_LEN_MOD8_COMPAT", 12, 1 },
	{ "S_VNIC", 11, 1 },
	{ "S_CSUM_HAS_PSEUDO_HDR", 10, 1 },
	{ "S_RM_OVLAN", 9, 1 },
	{ "S_LOOKUPEVERYPKT", 8, 1 },
	{ "S_IPV6_EXT_HDR_SKIP", 0, 8 },
	{ "TP_TX_DROP_CFG_CH2", 0x142, 0 },
	{ "S_TIMERENABLED", 31, 1 },
	{ "S_TIMERERRORENABLE", 30, 1 },
	{ "S_TIMERTHRESHOLD", 4, 26 },
	{ "S_PACKETDROPS", 0, 4 },
	{ "TP_TX_DROP_CFG_CH3", 0x143, 0 },
	{ "S_TIMERENABLED", 31, 1 },
	{ "S_TIMERERRORENABLE", 30, 1 },
	{ "S_TIMERTHRESHOLD", 4, 26 },
	{ "S_PACKETDROPS", 0, 4 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_145_to_157[] = {
	{ "TP_INGRESS_CONFIG2", 0x145, 0 },
	{ "S_IPV6_UDP_CSUM_COMPAT", 31, 1 },
	{ "S_VNTAGPLDENABLE", 30, 1 },
	{ "S_TCP_PLD_FILTER_OFFSET", 20,  10},
	{ "S_UDP_PLD_FILTER_OFFSET", 10, 10 },
	{ "S_TNL_PLD_FILTER_OFFSET", 0, 10 },
	{ "TP_EHDR_CONFIG_LO", 0x146, 0 },
	{ "S_CPLLIMIT", 24, 8 },
	{ "S_ETHLIMIT", 16, 8 },
	{ "S_IPLIMIT", 8, 8 },
	{ "S_TCPLIMIT", 0, 8 },
	{ "TP_EHDR_CONFIG_HI", 0x147, 0 },
	{ "S_CPLLIMIT", 24, 8 },
	{ "S_ETHLIMIT", 16, 8 },
	{ "S_IPLIMIT", 8, 8 },
	{ "S_TCPLIMIT", 0, 8 },
	{ "TP_DBG_ESIDE_INT", 0x148, 0 },
	{ "S_ERXSOP2X", 28, 4 },
	{ "S_ERXEOP2X", 24, 4 },
	{ "S_ERXVALID2X", 20, 4 },
	{ "S_ERXAFULL2X", 16, 4 },
	{ "S_PLD2XTXVALID", 12, 4 },
	{ "S_PLD2XTXAFULL", 8, 4 },
	{ "S_ERRORSRDY", 7, 1 },
	{ "S_ERRORDRDY", 6, 1 },
	{ "S_TCPOPSRDY", 5, 1 },
	{ "S_TCPOPDRDY", 4, 1 },
	{ "S_PLDTXSRDY", 3, 1 },
	{ "S_PLDTXDRDY", 2, 1 },
	{ "S_TCPOPTTXVALID", 1, 1 },
	{ "S_TCPOPTTXFULL", 0, 1 },
	{ "TP_DBG_ESIDE_DEMUX", 0x149, 0 },
	{ "S_EALLDONE", 28, 4 },
	{ "S_EFIFOPLDDONE", 24, 4 },
	{ "S_EDBDONE", 20, 4 },
	{ "S_EISSFIFODONE", 16, 4 },
	{ "S_EACKERRFIFODONE", 12, 4 },
	{ "S_EFIFOERRORDONE", 8, 4 },
	{ "S_ERXPKTATTRFIFOFDONE", 4, 4 },
	{ "S_ETCPOPDONE", 0, 4 },
	{ "TP_DBG_ESIDE_IN0", 0x14A, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_IN1", 0x14B, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_IN2", 0x14C, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_IN3", 0x14D, 0 },
	{ "S_RXVALID", 31, 1 },
	{ "S_RXFULL", 30, 1 },
	{ "S_RXSOCP", 29, 1 },
	{ "S_RXEOP", 28, 1 },
	{ "S_RXVALID_I", 27, 1 },
	{ "S_RXFULL_I", 26, 1 },
	{ "S_RXRUNT", 25, 1 },
	{ "S_RXRUNTPARSER", 24, 1 },
	{ "S_RXVALID_I2", 23, 1 },
	{ "S_RXFULL_I2", 22, 1 },
	{ "S_RXSOCP_I2", 21, 1 },
	{ "S_RXEOP_I2", 20, 1 },
	{ "S_CT_MPA_TXVALID_FIFO", 19, 1 },
	{ "S_CT_MPA_TXFULL_FIFO", 18, 1 },
	{ "S_CT_MPA_TXVALID", 17, 1 },
	{ "S_CT_MPA_TXFULL", 16, 1 },
	{ "S_RXVALID_BUF", 15, 1 },
	{ "S_RXFULL_BUF", 14, 1 },
	{ "S_PLD_TXVALID", 13, 1 },
	{ "S_PLD_TXFULL", 12, 1 },
	{ "S_ISS_FIFO_SRDY", 11, 1 },
	{ "S_ISS_FIFO_DRDY", 10, 1 },
	{ "S_CT_TCP_OP_ISS_SRDY", 9, 1 },
	{ "S_CT_TCP_OP_ISS_DRDY", 8, 1 },
	{ "S_P2CSUMERROR_SRDY", 7, 1 },
	{ "S_P2CSUMERROR_DRDY", 6, 1 },
	{ "S_ERROR_SRDY", 5, 1 },
	{ "S_ERROR_DRDY", 4, 1 },
	{ "S_PLD_SRDY", 3, 1 },
	{ "S_PLD_DRDY", 2, 1 },
	{ "S_RX_PKT_ATTR_SRDY", 1, 1 },
	{ "S_RX_PKT_ATTR_DRDY", 0, 1 },
	{ "TP_DBG_ESIDE_FRM", 0x14E, 0 },
	{ "S_ERX2XERROR", 28, 4 },
	{ "S_EPLDTX2XERROR", 24, 4 },
	{ "S_ETXERROR", 20, 4 },
	{ "S_EPLDRXERROR", 16, 4 },
	{ "S_ERXSIZEERROR3", 12, 4 },
	{ "S_ERXSIZEERROR2", 8, 4 },
	{ "S_ERXSIZEERROR1", 4, 4 },
	{ "S_ERXSIZEERROR0", 0, 4 },
	{ "TP_DBG_ESIDE_DRP", 0x14F, 0 },
	{ "S_RXDROP3", 24, 8 },
	{ "S_RXDROP2", 16, 8 },
	{ "S_RXDROP1", 8, 8 },
	{ "S_RXDROP0", 0, 8 },
	{ "TP_DBG_ESIDE_TX", 0x150, 0 },
	{ "S_ETXVALID", 4, 4 },
	{ "S_ETXFULL", 0, 4 },
	{ "TP_ESIDE_SVID_MASK", 0x151, 0 },
	{ "TP_ESIDE_DVID_MASK", 0x152, 0 },
	{ "TP_ESIDE_ALIGN_MASK", 0x153, 0 },
	{ "S_USE_LOOP_BIT", 24, 1 },
	{ "S_LOOP_OFFSET", 16, 8 },
	{ "S_DVID_ID_OFFSET", 8, 8 },
	{ "S_SVID_ID_OFFSET", 0, 8 },
	{ "TP_DBG_ESIDE_OP", 0x154, 0 },
	{ "S_RESERVED0", 30, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL0", 29, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL0", 28, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL0", 26, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL0", 24, 2 },
	{ "S_RESERVED1", 22, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL1", 21, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL1", 20, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL1", 18, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL1", 16, 2 },
	{ "S_RESERVED2", 14, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL2", 13, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL2", 12, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL2", 10, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL2", 8, 2 },
	{ "S_RESERVED3", 6, 2 },
	{ "S_OPT_PARSER_FATAL_CHANNEL3", 5, 1 },
	{ "S_OPT_PARSER_BUSY_CHANNEL3", 4, 1 },
	{ "S_OPT_PARSER_ITCP_STATE_CHANNEL3", 2, 2 },
	{ "S_OPT_PARSER_OTK_STATE_CHANNEL3", 0, 2 },
	{ "TP_DBG_ESIDE_OP_ALT", 0x155, 0 },
	{ "S_RESERVED0", 30, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL0", 29, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL0", 24, 5 },
	{ "S_RESERVED1", 22, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL1", 21, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL1", 16, 5 },
	{ "S_RESERVED2", 14, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL2", 13, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL2", 8, 5 },
	{ "S_RESERVED3", 6, 2 },
	{ "S_OPT_PARSER_PSTATE_FATAL_CHANNEL3", 5, 1 },
	{ "S_OPT_PARSER_PSTATE_ERRNO_CHANNEL3", 0, 5 },
	{ "TP_DBG_ESIDE_OP_BUSY", 0x156, 0 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL3", 24, 8 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL2", 16, 8 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL1", 8, 8 },
	{ "S_OPT_PARSER_BUSY_VEC_CHANNEL0", 0, 8 },
	{ "TP_DBG_ESIDE_OP_COOKIE", 0x157, 0 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL3", 24, 8 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL2", 16, 8 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL1", 8, 8 },
	{ "S_OPT_PARSER_COOKIE_CHANNEL0", 0, 8 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_230_to_248[] = {
	{ "TP_DBG_CSIDE_RX0", 0x230, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_RX1", 0x231, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_RX2", 0x232, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_RX3", 0x233, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX0", 0x234, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX1", 0x235, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX2", 0x236, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX3", 0x237, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_FIFO0", 0x238, 0 },
	{ "S_PLD_RXZEROP_SRDY1", 31, 1 },
	{ "S_PLD_RXZEROP_DRDY1", 30, 1 },
	{ "S_PLD_TXZEROP_SRDY1", 29, 1 },
	{ "S_PLD_TXZEROP_DRDY1", 28, 1 },
	{ "S_PLD_TX_SRDY1", 27, 1 },
	{ "S_PLD_TX_DRDY1", 26, 1 },
	{ "S_ERROR_SRDY1", 25, 1 },
	{ "S_ERROR_DRDY1", 24, 1 },
	{ "S_DB_VLD1", 23, 1 },
	{ "S_DB_GT1", 22, 1 },
	{ "S_TXVALID1", 21, 1 },
	{ "S_TXFULL1", 20, 1 },
	{ "S_PLD_TXVALID1", 19 , 1 },
	{ "S_PLD_TXFULL1", 18, 1 },
	{ "S_CPL5_TXVALID1", 17, 1 },
	{ "S_CPL5_TXFULL1", 16, 1 },
	{ "S_PLD_RXZEROP_SRDY0", 15, 1 },
	{ "S_PLD_RXZEROP_DRDY0", 14, 1 },
	{ "S_PLD_TXZEROP_SRDY0", 13, 1 },
	{ "S_PLD_TXZEROP_DRDY0", 12, 1 },
	{ "S_PLD_TX_SRDY0", 11, 1 },
	{ "S_PLD_TX_DRDY0", 10, 1 },
	{ "S_ERROR_SRDY0", 9, 1 },
	{ "S_ERROR_DRDY0", 8, 1 },
	{ "S_DB_VLD0", 7, 1 },
	{ "S_DB_GT0", 6, 1 },
	{ "S_TXVALID0", 5, 1 },
	{ "S_TXFULL0", 4, 1 },
	{ "S_PLD_TXVALID0", 3, 1 },
	{ "S_PLD_TXFULL0", 2, 1 },
	{ "S_CPL5_TXVALID0", 1, 1 },
	{ "S_CPL5_TXFULL0", 0, 1 },
	{ "TP_DBG_CSIDE_FIFO1", 0x239, 0 },
	{ "S_PLD_RXZEROP_SRDY3", 31, 1 },
	{ "S_PLD_RXZEROP_DRDY3", 30, 1 },
	{ "S_PLD_TXZEROP_SRDY3", 29, 1 },
	{ "S_PLD_TXZEROP_DRDY3", 28, 1 },
	{ "S_PLD_TX_SRDY3", 27, 1 },
	{ "S_PLD_TX_DRDY3", 26, 1 },
	{ "S_ERROR_SRDY3", 25, 1 },
	{ "S_ERROR_DRDY3", 24, 1 },
	{ "S_DB_VLD3", 23, 1 },
	{ "S_DB_GT3", 22, 1 },
	{ "S_TXVALID3", 21, 1 },
	{ "S_TXFULL3", 20, 1 },
	{ "S_PLD_TXVALID3", 19 , 1 },
	{ "S_PLD_TXFULL3", 18, 1 },
	{ "S_CPL5_TXVALID3", 17, 1 },
	{ "S_CPL5_TXFULL3", 16, 1 },
	{ "S_PLD_RXZEROP_SRDY2", 15, 1 },
	{ "S_PLD_RXZEROP_DRDY2", 14, 1 },
	{ "S_PLD_TXZEROP_SRDY2", 13, 1 },
	{ "S_PLD_TXZEROP_DRDY2", 12, 1 },
	{ "S_PLD_TX_SRDY2", 11, 1 },
	{ "S_PLD_TX_DRDY2", 10, 1 },
	{ "S_ERROR_SRDY2", 9, 1 },
	{ "S_ERROR_DRDY2", 8, 1 },
	{ "S_DB_VLD2", 7, 1 },
	{ "S_DB_GT2", 6, 1 },
	{ "S_TXVALID2", 5, 1 },
	{ "S_TXFULL2", 4, 1 },
	{ "S_PLD_TXVALID2", 3, 1 },
	{ "S_PLD_TXFULL2", 2, 1 },
	{ "S_CPL5_TXVALID2", 1, 1 },
	{ "S_CPL5_TXFULL2", 0, 1 },
	{ "TP_DBG_CSIDE_DISP0", 0x23A, 0 },
	{ "S_TXFULL", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_CPL5RXVALID", 27, 1 },
	{ "S_CPL5RXFULL", 26, 1 },
	{ "S_PLD_RXZEROP_SRDY", 25, 1 },
	{ "S_PLD_RXZEROP", 24, 1 },
	{ "S_PLD2XRXVALID", 23, 1 },
	{ "S_DDP_SRDY", 22, 1 },
	{ "S_DDP_DRDY", 21, 1 },
	{ "S_DDPSTATE", 16, 5 },
	{ "S_DDPMSGCODE", 12, 4 },
	{ "S_CPL5SOCPCNT", 8, 4 },
	{ "S_PLDRXZEROPCNT", 4, 4 },
	{ "S_TXFRMERR2", 3, 1 },
	{ "S_TXFRMERR1", 2, 1 },
	{ "S_TXVALID2X", 1, 1 },
	{ "S_TXFULL2X", 0, 1 },
	{ "TP_DBG_CSIDE_DISP1", 0x23B, 0 },
	{ "S_TXFULL", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_CPL5RXVALID", 27, 1 },
	{ "S_CPL5RXFULL", 26, 1 },
	{ "S_PLD_RXZEROP_SRDY", 25, 1 },
	{ "S_PLD_RXZEROP", 24, 1 },
	{ "S_PLD2XRXVALID", 23, 1 },
	{ "S_DDP_SRDY", 22, 1 },
	{ "S_DDP_DRDY", 21, 1 },
	{ "S_DDPSTATE", 16, 5 },
	{ "S_DDPMSGCODE", 12, 4 },
	{ "S_CPL5SOCPCNT", 8, 4 },
	{ "S_PLDRXZEROPCNT", 4, 4 },
	{ "S_TXFRMERR2", 3, 1 },
	{ "S_TXFRMERR1", 2, 1 },
	{ "S_TXVALID2X", 1, 1 },
	{ "S_TXFULL2X", 0, 1 },
	{ "TP_DBG_CSIDE_DDP0", 0x23C, 0 },
	{ "S_DDPMSGLATEST7", 28, 4 },
	{ "S_DDPMSGLATEST6", 24, 4 },
	{ "S_DDPMSGLATEST5", 20, 4 },
	{ "S_DDPMSGLATEST4", 16, 4 },
	{ "S_DDPMSGLATEST3", 12, 4 },
	{ "S_DDPMSGLATEST2", 8, 4 },
	{ "S_DDPMSGLATEST1", 4, 4 },
	{ "S_DDPMSGLATEST0", 0, 4 },
	{ "TP_DBG_CSIDE_DDP1", 0x23D, 0 },
	{ "S_DDPMSGLATEST7", 28, 4 },
	{ "S_DDPMSGLATEST6", 24, 4 },
	{ "S_DDPMSGLATEST5", 20, 4 },
	{ "S_DDPMSGLATEST4", 16, 4 },
	{ "S_DDPMSGLATEST3", 12, 4 },
	{ "S_DDPMSGLATEST2", 8, 4 },
	{ "S_DDPMSGLATEST1", 4, 4 },
	{ "S_DDPMSGLATEST0", 0, 4 },
	{ "TP_DBG_CSIDE_FRM", 0x23E, 0 },
	{ "S_CRX2XERROR", 28, 4 },
	{ "S_CPLDTX2XERROR", 24, 4 },
	{ "S_CTXERROR", 22, 2 },
	{ "S_CPLDRXERROR", 20, 2 },
	{ "S_CPLRXERROR", 18, 2 },
	{ "S_CPLTXERROR", 16, 2 },
	{ "S_CPRSERROR", 0, 4 },
	{ "TP_DBG_CSIDE_INT", 0x23F, 0 },
	{ "S_CRXVALID2X", 28, 4 },
	{ "S_CRXAFULL2X", 24, 4 },
	{ "S_CTXVALID2X", 22, 2 },
	{ "S_CTXAFULL2X", 20, 2 },
	{ "S_PLD2X_RXVALID", 18, 2 },
	{ "S_PLD2X_RXAFULL", 16, 2 },
	{ "S_CSIDE_DDP_VALID", 14, 2 },
	{ "S_DDP_AFULL", 12, 2 },
	{ "S_TRC_RXVALID", 11, 1 },
	{ "S_TRC_RXFULL", 10, 1 },
	{ "S_CPL5_TXVALID", 9, 1 },
	{ "S_CPL5_TXFULL", 8, 1 },
	{ "S_PLD2X_TXVALID", 4, 4 },
	{ "S_PLD2X_TXAFULL", 0, 4 },
	{ "TP_CHDR_CONFIG", 0x240, 0 },
	{ "S_CH1HIGH", 24, 8 },
	{ "S_CH1LOW", 16, 8 },
	{ "S_CH0HIGH", 8, 8 },
	{ "S_CH0LOW", 0, 8 },
	{ "TP_UTRN_CONFIG", 0x241, 0 },
	{ "S_CH2FIFOLIMIT", 16, 8 },
	{ "S_CH1FIFOLIMIT", 8, 8 },
	{ "S_CH0FIFOLIMIT", 0, 8 },
	{ "TP_CDSP_CONFIG", 0x242, 0 },
	{ "S_SHAREDRQEN", 31, 1 },
	{ "S_ISCSICMDMODE", 28, 1 },
	{ "S_IMMEDIATEOP", 20, 4 },
	{ "S_IMMEDIATESE", 16, 4 },
	{ "S_ATOMICREQOP", 12, 4 },
	{ "S_ATOMICRSPOP", 8, 4 },
	{ "S_STARTSKIPPLD", 7, 1 },
	{ "S_ATOMICCMDEN", 5, 1 },
	{ "S_WRITEZEROEN", 4, 1 },
	{ "S_WRITEZEROOP", 0, 4 },
	{ "TP_CSPI_POWER", 0x243, 0 },
	{ "S_GATECHNTX3", 11, 1 },
	{ "S_GATECHNTX2", 10, 1 },
	{ "S_GATECHNTX1", 9, 1 },
	{ "S_GATECHNTX0", 8, 1 },
	{ "S_GATECHNRX1", 7, 1 },
	{ "S_GATECHNRX0", 6, 1 },
	{ "S_SLEEPRDYUTRN", 4, 1 },
	{ "S_SLEEPREQUTRN", 0, 1 },
	{ "TP_TRC_CONFIG", 0x244, 0 },
	{ "S_TRCRR", 1, 1 },
	{ "S_TRCCH", 0, 1 },
	{ "TP_TAG_CONFIG", 0x245, 0 },
	{ "S_ETAGTYPE", 16, 16 },
	{ "S_VLANTYPE", 0, 16 },
	{ "TP_DBG_CSIDE_PRS", 0x246, 0 },
	{ "S_C4TUPBUSY3", 31, 1 },
	{ "S_CDBVALID3", 30, 1 },
	{ "S_CRXVALID3", 29, 1 },
	{ "S_CRXFULL3", 28, 1 },
	{ "S_CPRSSTATE3", 24, 4 },
	{ "S_C4TUPBUSY2", 23, 1 },
	{ "S_CDBVALID2", 22, 1 },
	{ "S_CRXVALID2", 21, 1 },
	{ "S_CRXFULL2", 20, 1 },
	{ "S_CPRSSTATE2", 16, 4 },
	{ "S_C4TUPBUSY1", 15, 1 },
	{ "S_CDBVALID1", 14, 1 },
	{ "S_CRXVALID1", 13, 1 },
	{ "S_CRXFULL1", 12, 1 },
	{ "S_CPRSSTATE1", 8, 4 },
	{ "S_C4TUPBUSY0", 7, 1 },
	{ "S_CDBVALID0", 6, 1 },
	{ "S_CRXVALID0", 5, 1 },
	{ "S_CRXFULL0", 4, 1 },
	{ "S_CPRSSTATE0", 0, 4 },
	{ "TP_DBG_CSIDE_DEMUX", 0x247, 0 },
	{ "S_CARBVALID", 28, 4 },
	{ "S_CCPL5DONE", 24, 4 },
	{ "S_CTXZEROPDONE", 20, 4 },
	{ "S_CPLDDONE", 16, 4 },
	{ "S_CTCPOPDONE", 12, 4 },
	{ "S_CDBDONE", 8, 4 },
	{ "S_CISSFIFODONE", 4, 4 },
	{ "S_CTXPKTCSUMDONE", 0, 4 },
	{ "TP_DBG_CSIDE_ARBIT", 0x248, 0 },
	{ "S_CPLVALID3", 31, 1 },
	{ "S_PLDVALID3", 30, 1 },
	{ "S_CRCVALID3", 29, 1 },
	{ "S_ISSVALID3", 28, 1 },
	{ "S_DBVALID3", 27, 1 },
	{ "S_CHKVALID3", 26, 1 },
	{ "S_ZRPVALID3", 25, 1 },
	{ "S_ERRVALID3", 24, 1 },
	{ "S_CPLVALID2", 23, 1 },
	{ "S_PLDVALID2", 22, 1 },
	{ "S_CRCVALID2", 21, 1 },
	{ "S_ISSVALID2", 20, 1 },
	{ "S_DBVALID2", 19, 1 },
	{ "S_CHKVALID2", 18, 1 },
	{ "S_ZRPVALID2", 17, 1 },
	{ "S_ERRVALID2", 16, 1 },
	{ "S_CPLVALID1", 15, 1 },
	{ "S_PLDVALID1", 14, 1 },
	{ "S_CRCVALID1", 13, 1 },
	{ "S_ISSVALID1", 12, 1 },
	{ "S_DBVALID1", 11, 1 },
	{ "S_CHKVALID1", 10, 1 },
	{ "S_ZRPVALID1", 9, 1 },
	{ "S_ERRVALID1", 8, 1 },
	{ "S_CPLVALID0", 7, 1 },
	{ "S_PLDVALID0", 6, 1 },
	{ "S_CRCVALID0", 5, 1 },
	{ "S_ISSVALID0", 4, 1 },
	{ "S_DBVALID0", 3, 1 },
	{ "S_CHKVALID0", 2, 1 },
	{ "S_ZRPVALID0", 1, 1 },
	{ "S_ERRVALID0", 0, 1 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_24c[] = {
	{ "TP_DBG_CSIDE_TRACE_CNT", 0x24a, 0 },
	{ "TrcSopCnt", 24, 8 },
	{ "TrcEopCnt", 16, 8 },
	{ "TrcFltHit", 12, 4 },
	{ "TrcRntPkt", 8, 4 },
	{ "TrcPktLen", 0, 8 },
	{ "TP_DBG_CSIDE_TRACE_RSS", 0x24b, 0 },
	{ "TP_VLN_CONFIG", 0x24c, 0 },
	{ "EthTypeQinQ", 16, 16 },
	{ "EthTypeVlan", 0, 16 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_230_to_248[] = {
	{ "TP_DBG_CSIDE_RX0", 0x230, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_RX1", 0x231, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_RX2", 0x232, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_RX3", 0x233, 0 },
	{ "S_CRXSOPCNT", 28, 4 },
	{ "S_CRXEOPCNT", 24, 4 },
	{ "S_CRXPLDSOPCNT", 20, 4 },
	{ "S_CRXPLDEOPCNT", 16, 4 },
	{ "S_CRXARBSOPCNT", 12, 4 },
	{ "S_CRXARBEOPCNT", 8, 4 },
	{ "S_CRXCPLSOPCNT", 4, 4 },
	{ "S_CRXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX0", 0x234, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX1", 0x235, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX2", 0x236, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_TX3", 0x237, 0 },
	{ "S_TXSOPCNT", 28, 4 },
	{ "S_TXEOPCNT", 24, 4 },
	{ "S_TXPLDSOPCNT", 20, 4 },
	{ "S_TXPLDEOPCNT", 16, 4 },
	{ "S_TXARBSOPCNT", 12, 4 },
	{ "S_TXARBEOPCNT", 8, 4 },
	{ "S_TXCPLSOPCNT", 4, 4 },
	{ "S_TXCPLEOPCNT", 0, 4 },
	{ "TP_DBG_CSIDE_FIFO0", 0x238, 0 },
	{ "S_PLD_RXZEROP_SRDY1", 31, 1 },
	{ "S_PLD_RXZEROP_DRDY1", 30, 1 },
	{ "S_PLD_TXZEROP_SRDY1", 29, 1 },
	{ "S_PLD_TXZEROP_DRDY1", 28, 1 },
	{ "S_PLD_TX_SRDY1", 27, 1 },
	{ "S_PLD_TX_DRDY1", 26, 1 },
	{ "S_ERROR_SRDY1", 25, 1 },
	{ "S_ERROR_DRDY1", 24, 1 },
	{ "S_DB_VLD1", 23, 1 },
	{ "S_DB_GT1", 22, 1 },
	{ "S_TXVALID1", 21, 1 },
	{ "S_TXFULL1", 20, 1 },
	{ "S_PLD_TXVALID1", 19 , 1 },
	{ "S_PLD_TXFULL1", 18, 1 },
	{ "S_CPL5_TXVALID1", 17, 1 },
	{ "S_CPL5_TXFULL1", 16, 1 },
	{ "S_PLD_RXZEROP_SRDY0", 15, 1 },
	{ "S_PLD_RXZEROP_DRDY0", 14, 1 },
	{ "S_PLD_TXZEROP_SRDY0", 13, 1 },
	{ "S_PLD_TXZEROP_DRDY0", 12, 1 },
	{ "S_PLD_TX_SRDY0", 11, 1 },
	{ "S_PLD_TX_DRDY0", 10, 1 },
	{ "S_ERROR_SRDY0", 9, 1 },
	{ "S_ERROR_DRDY0", 8, 1 },
	{ "S_DB_VLD0", 7, 1 },
	{ "S_DB_GT0", 6, 1 },
	{ "S_TXVALID0", 5, 1 },
	{ "S_TXFULL0", 4, 1 },
	{ "S_PLD_TXVALID0", 3, 1 },
	{ "S_PLD_TXFULL0", 2, 1 },
	{ "S_CPL5_TXVALID0", 1, 1 },
	{ "S_CPL5_TXFULL0", 0, 1 },
	{ "TP_DBG_CSIDE_FIFO1", 0x239, 0 },
	{ "S_PLD_RXZEROP_SRDY3", 31, 1 },
	{ "S_PLD_RXZEROP_DRDY3", 30, 1 },
	{ "S_PLD_TXZEROP_SRDY3", 29, 1 },
	{ "S_PLD_TXZEROP_DRDY3", 28, 1 },
	{ "S_PLD_TX_SRDY3", 27, 1 },
	{ "S_PLD_TX_DRDY3", 26, 1 },
	{ "S_ERROR_SRDY3", 25, 1 },
	{ "S_ERROR_DRDY3", 24, 1 },
	{ "S_DB_VLD3", 23, 1 },
	{ "S_DB_GT3", 22, 1 },
	{ "S_TXVALID3", 21, 1 },
	{ "S_TXFULL3", 20, 1 },
	{ "S_PLD_TXVALID3", 19 , 1 },
	{ "S_PLD_TXFULL3", 18, 1 },
	{ "S_CPL5_TXVALID3", 17, 1 },
	{ "S_CPL5_TXFULL3", 16, 1 },
	{ "S_PLD_RXZEROP_SRDY2", 15, 1 },
	{ "S_PLD_RXZEROP_DRDY2", 14, 1 },
	{ "S_PLD_TXZEROP_SRDY2", 13, 1 },
	{ "S_PLD_TXZEROP_DRDY2", 12, 1 },
	{ "S_PLD_TX_SRDY2", 11, 1 },
	{ "S_PLD_TX_DRDY2", 10, 1 },
	{ "S_ERROR_SRDY2", 9, 1 },
	{ "S_ERROR_DRDY2", 8, 1 },
	{ "S_DB_VLD2", 7, 1 },
	{ "S_DB_GT2", 6, 1 },
	{ "S_TXVALID2", 5, 1 },
	{ "S_TXFULL2", 4, 1 },
	{ "S_PLD_TXVALID2", 3, 1 },
	{ "S_PLD_TXFULL2", 2, 1 },
	{ "S_CPL5_TXVALID2", 1, 1 },
	{ "S_CPL5_TXFULL2", 0, 1 },
	{ "TP_DBG_CSIDE_DISP0", 0x23A, 0 },
	{ "S_TXFULL", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_CPL5RXVALID", 27, 1 },
	{ "S_CPL5RXFULL", 26, 1 },
	{ "S_PLD_RXZEROP_SRDY", 25, 1 },
	{ "S_PLD_RXZEROP", 24, 1 },
	{ "S_PLD2XRXVALID", 23, 1 },
	{ "S_DDP_SRDY", 22, 1 },
	{ "S_DDP_DRDY", 21, 1 },
	{ "S_DDPSTATE", 16, 5 },
	{ "S_DDPMSGCODE", 12, 4 },
	{ "S_CPL5SOCPCNT", 8, 4 },
	{ "S_PLDRXZEROPCNT", 4, 4 },
	{ "S_TXFRMERR2", 3, 1 },
	{ "S_TXFRMERR1", 2, 1 },
	{ "S_TXVALID2X", 1, 1 },
	{ "S_TXFULL2X", 0, 1 },
	{ "TP_DBG_CSIDE_DISP1", 0x23B, 0 },
	{ "S_TXFULL", 31, 1 },
	{ "S_STATE", 28, 3 },
	{ "S_CPL5RXVALID", 27, 1 },
	{ "S_CPL5RXFULL", 26, 1 },
	{ "S_PLD_RXZEROP_SRDY", 25, 1 },
	{ "S_PLD_RXZEROP", 24, 1 },
	{ "S_PLD2XRXVALID", 23, 1 },
	{ "S_DDP_SRDY", 22, 1 },
	{ "S_DDP_DRDY", 21, 1 },
	{ "S_DDPSTATE", 16, 5 },
	{ "S_DDPMSGCODE", 12, 4 },
	{ "S_CPL5SOCPCNT", 8, 4 },
	{ "S_PLDRXZEROPCNT", 4, 4 },
	{ "S_TXFRMERR2", 3, 1 },
	{ "S_TXFRMERR1", 2, 1 },
	{ "S_TXVALID2X", 1, 1 },
	{ "S_TXFULL2X", 0, 1 },
	{ "TP_DBG_CSIDE_DDP0", 0x23C, 0 },
	{ "S_DDPMSGLATEST7", 28, 4 },
	{ "S_DDPMSGLATEST6", 24, 4 },
	{ "S_DDPMSGLATEST5", 20, 4 },
	{ "S_DDPMSGLATEST4", 16, 4 },
	{ "S_DDPMSGLATEST3", 12, 4 },
	{ "S_DDPMSGLATEST2", 8, 4 },
	{ "S_DDPMSGLATEST1", 4, 4 },
	{ "S_DDPMSGLATEST0", 0, 4 },
	{ "TP_DBG_CSIDE_DDP1", 0x23D, 0 },
	{ "S_DDPMSGLATEST7", 28, 4 },
	{ "S_DDPMSGLATEST6", 24, 4 },
	{ "S_DDPMSGLATEST5", 20, 4 },
	{ "S_DDPMSGLATEST4", 16, 4 },
	{ "S_DDPMSGLATEST3", 12, 4 },
	{ "S_DDPMSGLATEST2", 8, 4 },
	{ "S_DDPMSGLATEST1", 4, 4 },
	{ "S_DDPMSGLATEST0", 0, 4 },
	{ "TP_DBG_CSIDE_FRM", 0x23E, 0 },
	{ "S_CRX2XERROR", 28, 4 },
	{ "S_CPLDTX2XERROR", 24, 4 },
	{ "S_CTXERROR", 22, 2 },
	{ "S_CPLDRXERROR", 20, 2 },
	{ "S_CPLRXERROR", 18, 2 },
	{ "S_CPLTXERROR", 16, 2 },
	{ "S_CPRSERROR", 0, 4 },
	{ "TP_DBG_CSIDE_INT", 0x23F, 0 },
	{ "S_CRXVALID2X", 28, 4 },
	{ "S_CRXAFULL2X", 24, 4 },
	{ "S_CTXVALID2X", 22, 2 },
	{ "S_CTXAFULL2X", 20, 2 },
	{ "S_PLD2X_RXVALID", 18, 2 },
	{ "S_PLD2X_RXAFULL", 16, 2 },
	{ "S_CSIDE_DDP_VALID", 14, 2 },
	{ "S_DDP_AFULL", 12, 2 },
	{ "S_TRC_RXVALID", 11, 1 },
	{ "S_TRC_RXFULL", 10, 1 },
	{ "S_CPL5_TXVALID", 9, 1 },
	{ "S_CPL5_TXFULL", 8, 1 },
	{ "S_PLD2X_TXVALID", 4, 4 },
	{ "S_PLD2X_TXAFULL", 0, 4 },
	{ "TP_CHDR_CONFIG", 0x240, 0 },
	{ "S_CH1HIGH", 24, 8 },
	{ "S_CH1LOW", 16, 8 },
	{ "S_CH0HIGH", 8, 8 },
	{ "S_CH0LOW", 0, 8 },
	{ "TP_UTRN_CONFIG", 0x241, 0 },
	{ "S_CH2FIFOLIMIT", 16, 8 },
	{ "S_CH1FIFOLIMIT", 8, 8 },
	{ "S_CH0FIFOLIMIT", 0, 8 },
	{ "TP_CDSP_CONFIG", 0x242, 0 },
	{ "S_IMMEDIATEOP", 20, 4 },
	{ "S_IMMEDIATESE", 16, 4 },
	{ "S_ATOMICREQOP", 12, 4 },
	{ "S_ATOMICRSPOP", 8, 4 },
	{ "S_STARTSKIPPLD", 7, 1 },
	{ "S_ATOMICCMDEN", 5, 1 },
	{ "S_WRITEZEROEN", 4, 1 },
	{ "S_WRITEZEROOP", 0, 4 },
	{ "TP_CSPI_POWER", 0x243, 0 },
	{ "S_GATECHNTX3", 11, 1 },
	{ "S_GATECHNTX2", 10, 1 },
	{ "S_GATECHNTX1", 9, 1 },
	{ "S_GATECHNTX0", 8, 1 },
	{ "S_GATECHNRX1", 7, 1 },
	{ "S_GATECHNRX0", 6, 1 },
	{ "S_SLEEPRDYUTRN", 4, 1 },
	{ "S_SLEEPREQUTRN", 0, 1 },
	{ "TP_TRC_CONFIG", 0x244, 0 },
	{ "S_TRCRR", 1, 1 },
	{ "S_TRCCH", 0, 1 },
	{ "TP_TAG_CONFIG", 0x245, 0 },
	{ "S_ETAGTYPE", 16, 16 },
	{ "S_VLANTYPE", 0, 16 },
	{ "TP_DBG_CSIDE_PRS", 0x246, 0 },
	{ "S_C4TUPBUSY3", 31, 1 },
	{ "S_CDBVALID3", 30, 1 },
	{ "S_CRXVALID3", 29, 1 },
	{ "S_CRXFULL3", 28, 1 },
	{ "S_CPRSSTATE3", 24, 4 },
	{ "S_C4TUPBUSY2", 23, 1 },
	{ "S_CDBVALID2", 22, 1 },
	{ "S_CRXVALID2", 21, 1 },
	{ "S_CRXFULL2", 20, 1 },
	{ "S_CPRSSTATE2", 16, 4 },
	{ "S_C4TUPBUSY1", 15, 1 },
	{ "S_CDBVALID1", 14, 1 },
	{ "S_CRXVALID1", 13, 1 },
	{ "S_CRXFULL1", 12, 1 },
	{ "S_CPRSSTATE1", 8, 4 },
	{ "S_C4TUPBUSY0", 7, 1 },
	{ "S_CDBVALID0", 6, 1 },
	{ "S_CRXVALID0", 5, 1 },
	{ "S_CRXFULL0", 4, 1 },
	{ "S_CPRSSTATE0", 0, 4 },
	{ "TP_DBG_CSIDE_DEMUX", 0x247, 0 },
	{ "S_CARBVALID", 28, 4 },
	{ "S_CCPL5DONE", 24, 4 },
	{ "S_CTXZEROPDONE", 20, 4 },
	{ "S_CPLDDONE", 16, 4 },
	{ "S_CTCPOPDONE", 12, 4 },
	{ "S_CDBDONE", 8, 4 },
	{ "S_CISSFIFODONE", 4, 4 },
	{ "S_CTXPKTCSUMDONE", 0, 4 },
	{ "TP_DBG_CSIDE_ARBIT", 0x248, 0 },
	{ "S_CPLVALID3", 31, 1 },
	{ "S_PLDVALID3", 30, 1 },
	{ "S_CRCVALID3", 29, 1 },
	{ "S_ISSVALID3", 28, 1 },
	{ "S_DBVALID3", 27, 1 },
	{ "S_CHKVALID3", 26, 1 },
	{ "S_ZRPVALID3", 25, 1 },
	{ "S_ERRVALID3", 24, 1 },
	{ "S_CPLVALID2", 23, 1 },
	{ "S_PLDVALID2", 22, 1 },
	{ "S_CRCVALID2", 21, 1 },
	{ "S_ISSVALID2", 20, 1 },
	{ "S_DBVALID2", 19, 1 },
	{ "S_CHKVALID2", 18, 1 },
	{ "S_ZRPVALID2", 17, 1 },
	{ "S_ERRVALID2", 16, 1 },
	{ "S_CPLVALID1", 15, 1 },
	{ "S_PLDVALID1", 14, 1 },
	{ "S_CRCVALID1", 13, 1 },
	{ "S_ISSVALID1", 12, 1 },
	{ "S_DBVALID1", 11, 1 },
	{ "S_CHKVALID1", 10, 1 },
	{ "S_ZRPVALID1", 9, 1 },
	{ "S_ERRVALID1", 8, 1 },
	{ "S_CPLVALID0", 7, 1 },
	{ "S_PLDVALID0", 6, 1 },
	{ "S_CRCVALID0", 5, 1 },
	{ "S_ISSVALID0", 4, 1 },
	{ "S_DBVALID0", 3, 1 },
	{ "S_CHKVALID0", 2, 1 },
	{ "S_ZRPVALID0", 1, 1 },
	{ "S_ERRVALID0", 0, 1 },
	{ NULL }
};

static struct cudbg_reg_info t6_tp_pio_regs_8c0[] = {
	{ "TP_FIFO_CONFIG", 0x8C0, 0 },
	{ "S_CH1_OUTPUT", 27, 5 },
	{ "S_CH2_OUTPUT", 22, 5 },
	{ "S_RESERVED", 17, 5 },
	{ "S_STROBE1", 16, 1 },
	{ "S_CH1_INPUT", 11, 5 },
	{ "S_CH2_INPUT", 6, 5 },
	{ "S_CH3_INPUT", 1, 5 },
	{ "S_STROBE0", 0, 1 },
	{ NULL }
};

static struct cudbg_reg_info t5_tp_pio_regs_8c0[] = {
	{ "TP_FIFO_CONFIG", 0x8C0, 0 },
	{ "S_CH1_OUTPUT", 27, 5 },
	{ "S_CH2_OUTPUT", 22, 5 },
	{ "S_RESERVED", 17, 5 },
	{ "S_STROBE1", 16, 1 },
	{ "S_CH1_INPUT", 11, 5 },
	{ "S_CH2_INPUT", 6, 5 },
	{ "S_CH3_INPUT", 1, 5 },
	{ "S_STROBE0", 0, 1 },
	{ NULL }
};

static struct cudbg_reg_info t5_pcie_pdbg_regs_00_to_20[] = {
	{ "PCIE_PDEBUG_REG_0x0", 0x00, 0 },
	{ "PCIE_PDEBUG_REG_0x1", 0x01, 0 },
	{ "PCIE_PDEBUG_REG_0x2", 0X02, 0 },
	{ "tagq_ch0_tags_used", 11, 8 },
	{ "tagq_ch0_data_empty", 10, 1 },
	{ "rdq_ch0_req_empty", 9, 1 },
	{ "req_ctl_rd_ch0_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch0_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch0_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch0_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch0_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch0_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch0_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch0_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch0_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x3", 0X03, 0 },
	{ "tagq_ch1_tags_used", 11, 8 },
	{ "req_ch1_data_empty", 10, 1 },
	{ "rdq_ch1_req_empty", 9, 1 },
	{ "req_ctl_rd_ch1_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch1_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch1_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch1_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch1_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch1_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch1_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch1_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch1_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x4", 0X04, 0 },
	{ "tagq_ch2_tags_used", 11, 8 },
	{ "req_ch2_data_empty", 10, 1 },
	{ "rdq_ch2_req_empty", 9, 1 },
	{ "req_ctl_rd_ch2_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch2_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch2_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch2_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch2_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch2_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch2_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch2_wait_for_pause", 1, 1},
	{ "req_ctl_rd_ch2_wait_for_fifo_data", 0, 1},
	{ "PCIE_PDEBUG_REG_0x5", 0x05, 0 },
	{ "tagq_ch3_tags_used", 11, 8 },
	{ "req_ch3_data_empty", 10, 1 },
	{ "rdq_ch3_req_empty", 9, 1 },
	{ "req_ctl_rd_ch3_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch3_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch3_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch3_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch3_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch3_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch3_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch3_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch3_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x6", 0x06, 0 },
	{ "tagq_ch4_tags_used", 11, 8 },
	{ "req_ch4_data_empty", 10, 1 },
	{ "rdq_ch4_req_empty", 9, 1 },
	{ "req_ctl_rd_ch4_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch4_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch4_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch4_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch4_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch4_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch4_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch4_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch4_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x7", 0x07, 0 },
	{ "tagq_ch5_tags_used", 11, 8 },
	{ "req_ch5_data_empty", 10, 1 },
	{ "rdq_ch5_req_empty", 9, 1 },
	{ "req_ctl_rd_ch5_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch5_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch5_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch5_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch5_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch5_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch5_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch5_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch5_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x8", 0x08, 0 },
	{ "tagq_ch6_tags_used", 11, 8 },
	{ "req_ch6_data_empty", 10, 1 },
	{ "rdq_ch6_req_empty", 9, 1 },
	{ "req_ctl_rd_ch6_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch6_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch6_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch6_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch6_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch6_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch6_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch6_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch6_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x9", 0x09, 0 },
	{ "tagq_ch7_tags_used", 11, 8 },
	{ "req_ch7_data_empty", 10, 1 },
	{ "rdq_ch7_req_empty", 9, 1 },
	{ "req_ctl_rd_ch7_wait_for_tagtq", 8, 1 },
	{ "req_ctl_rd_ch7_wait_for_cmd", 7, 1 },
	{ "req_ctl_rd_ch7_wait_for_data_mem", 6, 1 },
	{ "req_ctl_rd_ch7_wait_for_rdq", 5, 1 },
	{ "req_ctl_rd_ch7_wait_for_txn_disable_fifo", 4, 1 },
	{ "req_ctl_rd_ch7_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_rd_ch7_exit_top_vld_started", 2, 1 },
	{ "req_ctl_rd_ch7_wait_for_pause", 1, 1 },
	{ "req_ctl_rd_ch7_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0xa", 0x0a, 0 },
	{ "req_ctl_rd_ch0_wait_for_seqnum", 27, 1 },
	{ "req_ctl_wr_ch0_seqnum", 19, 8 },
	{ "req_ctl_rd_ch0_seqnum", 11, 8 },
	{ "req_ctl_wr_ch0_wait_for_si_fifo", 4, 1 },
	{ "req_ctl_wr_ch0_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_wr_ch0_exit_top_vld_started", 2, 1 },
	{ "req_ctl_wr_ch0_wait_for_pause", 1, 1 },
	{ "req_ctl_wr_ch0_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0xb", 0x0b, 0 },
	{ "req_ctl_rd_ch1_wait_for_seqnum", 27, 1 },
	{ "req_ctl_wr_ch1_seqnum", 19, 8 },
	{ "req_ctl_rd_ch1_seqnum", 11, 8 },
	{ "req_ctl_wr_ch1_wait_for_si_fifo", 4, 1 },
	{ "req_ctl_wr_ch1_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_wr_ch1_exit_top_vld_started", 2, 1 },
	{ "req_ctl_wr_ch1_wait_for_pause", 1, 1 },
	{ "req_ctl_wr_ch1_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0xc", 0x0c, 0 },
	{ "req_ctl_rd_ch2_wait_for_seqnum", 27, 27},
	{ "req_ctl_wr_ch2_seqnum", 19, 8 },
	{ "req_ctl_rd_ch2_seqnum", 11, 8 },
	{ "req_ctl_wr_ch2_wait_for_si_fifo", 4, 1 },
	{ "req_ctl_wr_ch2_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_wr_ch2_exit_top_vld_started", 2, 1 },
	{ "req_ctl_wr_ch2_wait_for_pause", 1, 1 },
	{ "req_ctl_wr_ch2_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0xd", 0x0d, 0 },
	{ "req_ctl_rd_ch3_wait_for_seqnum", 27, 1 },
	{ "req_ctl_wr_ch3_seqnum", 19, 8 },
	{ "req_ctl_rd_ch3_seqnum", 11, 8 },
	{ "req_ctl_wr_ch3_wait_for_si_fifo", 4, 1 },
	{ "req_ctl_wr_ch3_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_wr_ch3_exit_top_vld_started", 2, 1 },
	{ "req_ctl_wr_ch3_wait_for_pause", 1, 1 },
	{ "req_ctl_wr_ch3_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0xe", 0x0e, 0 },
	{ "req_ctl_rd_ch4_wait_for_seqnum", 27, 1 },
	{ "req_ctl_wr_ch4_seqnum", 19, 8 },
	{ "req_ctl_rd_ch4_seqnum", 11, 8 },
	{ "req_ctl_wr_ch4_wait_for_si_fifo", 4, 1 },
	{ "req_ctl_wr_ch4_exit_bot_vld_started", 3, 1 },
	{ "req_ctl_wr_ch4_exit_top_vld_started", 2, 1 },
	{ "req_ctl_wr_ch4_wait_for_pause", 1, 1 },
	{ "req_ctl_wr_ch4_wait_for_fifo_data", 0, 1 },
	{ "PCIE_PDEBUG_REG_0xf", 0xf, 0 },
	{ "PCIE_PDEBUG_REG_0x10", 0x10, 0 },
	{ "pipe0_tx3_datak_0", 31, 1 },
	{ "pipe0_tx3_data_6_0", 24, 7 },
	{ "pipe0_tx2_data_7_0", 16, 8 },
	{ "pipe0_tx1_data_7_0", 8 , 8 },
	{ "pipe0_tx0_datak_0", 7, 1 },
	{ "pipe0_tx0_data_6_0", 0 , 7 },
	{ "PCIE_PDEBUG_REG_0x11", 0x11, 0 },
	{ "pipe0_tx3_datak_1", 31, 1 },
	{ "pipe0_tx3_data_14_8", 24, 7 },
	{ "pipe0_tx2_data_15_8", 16, 8 },
	{ "pipe0_tx1_data_15_8", 8, 8 },
	{ "pipe0_tx0_datak_1", 7, 1 },
	{ "pipe0_tx0_data_14_8", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x12", 0x12, 0 },
	{ "pipe0_tx7_datak_0", 31, 1 },
	{ "pipe0_tx7_data_6_0", 24, 7 },
	{ "pipe0_tx6_data_7_0", 16, 8 },
	{ "pipe0_tx5_data_7_0", 8, 8 },
	{ "pipe0_tx4_datak_0", 7, 1 },
	{ "pipe0_tx4_data_6_0", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x13", 0x13, 0 },
	{ "pipe0_tx7_datak_1", 31, 1 },
	{ "pipe0_tx7_data_14_8", 24, 7 },
	{ "pipe0_tx6_data_15_8", 16, 8 },
	{ "pipe0_tx5_data_15_8", 8, 8 },
	{ "pipe0_tx4_datak_1", 7, 1 },
	{ "pipe0_tx4_data_14_8", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x14", 0x14, 0 },
	{ "pipe0_rx3_valid_14", 31, 1 },
	{ "pipe0_rx3_valid2_14", 24, 7 },
	{ "pipe0_rx2_valid_14", 16, 8 },
	{ "pipe0_rx1_valid_14", 8, 8 },
	{ "pipe0_rx0_valid_14", 7, 1 },
	{ "pipe0_rx0_valid2_14", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x15", 0x15, 0 },
	{ "pipe0_rx3_valid_15", 31, 1 },
	{ "pipe0_rx3_valid2_15", 24, 7 },
	{ "pipe0_rx2_valid_15", 16, 8 },
	{ "pipe0_rx1_valid_15", 8, 8 },
	{ "pipe0_rx0_valid_15", 7, 1 },
	{ "pipe0_rx0_valid2+15", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x16", 0x16, 0 },
	{ "pipe0_rx7_valid_16", 31, 1 },
	{ "pipe0_rx7_valid2_16", 24, 7 },
	{ "pipe0_rx6_valid_16", 16, 8 },
	{ "pipe0_rx5_valid_16", 8, 8 },
	{ "pipe0_rx4_valid_16", 7, 1 },
	{ "pipe0_rx4_valid2_16", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x17", 0x17, 0 },
	{ "pipe0_rx7_valid_17", 31, 1 },
	{ "pipe0_rx7_valid2_17", 24, 7 },
	{ "pipe0_rx6_valid_17", 16, 8 },
	{ "pipe0_rx5_valid_17", 8, 8 },
	{ "pipe0_rx4_valid_17", 7, 1 },
	{ "pipe0_rx4_valid2_17", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x18", 0x18, 0 },
	{ "pipe0_rx7_polarity", 31, 1 },
	{ "pipe0_rx7_status", 28, 3 },
	{ "pipe0_rx6_polarity", 27, 1 },
	{ "pipe0_rx6_status", 24 , 3 },
	{ "pipe0_rx5_polarity", 23, 1 },
	{ "pipe0_rx5_status", 20, 3 },
	{ "pipe0_rx4_polarity", 19, 1 },
	{ "pipe0_rx4_status", 16, 3 },
	{ "pipe0_rx3_polarity", 15, 1 },
	{ "pipe0_rx3_status", 12, 3 },
	{ "pipe0_rx2_polarity", 11, 1 },
	{ "pipe0_rx2_status", 8, 3 },
	{ "pipe0_rx1_polarity", 7, 1 },
	{ "pipe0_rx1_status", 4, 3 },
	{ "pipe0_rx0_polarity", 3, 1 },
	{ "pipe0_rx0_status", 0, 3 },
	{ "PCIE_PDEBUG_REG_0x19", 0x19, 0 },
	{ "pipe0_tx7_compliance", 31, 1 },
	{ "pipe0_tx6_compliance", 30, 1 },
	{ "pipe0_tx5_compliance", 29, 1 },
	{ "pipe0_tx4_compliance", 28, 1 },
	{ "pipe0_tx3_compliance", 27, 1 },
	{ "pipe0_tx2_compliance", 26, 1 },
	{ "pipe0_tx1_compliance", 25, 1 },
	{ "pipe0_tx0_compliance", 24, 1 },
	{ "pipe0_tx7_elecidle", 23, 1 },
	{ "pipe0_tx6_elecidle", 22, 1 },
	{ "pipe0_tx5_elecidle", 21, 1 },
	{ "pipe0_tx4_elecidle", 20, 1 },
	{ "pipe0_tx3_elecidle", 19, 1 },
	{ "pipe0_tx2_elecidle", 18, 1 },
	{ "pipe0_tx1_elecidle", 17, 1 },
	{ "pipe0_tx0_elecidle", 16, 1 },
	{ "pipe0_rx7_polarity_19", 15, 1 },
	{ "pipe0_rx6_polarity_19", 14, 1 },
	{ "pipe0_rx5_polarity_19", 13, 1 },
	{ "pipe0_rx4_polarity_19", 12, 1 },
	{ "pipe0_rx3_polarity_19", 11, 1 },
	{ "pipe0_rx2_polarity_19", 10, 1 },
	{ "pipe0_rx1_polarity_19", 9, 1 },
	{ "pipe0_rx0_polarity_19", 8, 1 },
	{ "pipe0_rx7_elecidle", 7, 1 },
	{ "pipe0_rx6_elecidle", 6, 1 },
	{ "pipe0_rx5_elecidle", 5, 1 },
	{ "pipe0_rx4_elecidle", 4, 1 },
	{ "pipe0_rx3_elecidle", 3, 1 },
	{ "pipe0_rx2_elecidle", 2, 1 },
	{ "pipe0_rx1_elecidle", 1, 1 },
	{ "pipe0_rx0_elecidle", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x1a", 0x1a , 0 },
	{ "reserved", 22 , 10 },
	{ "pipe0_reset_n", 21, 1 },
	{ "pcs_common_clocks", 20, 1 },
	{ "pcs_clk_req", 19, 1 },
	{ "pipe_clkreq_n", 18, 1 },
	{ "mac_clkreq_n_to_mux", 17, 1 },
	{ "pipe0_tx2rx_loopbk", 16, 1 },
	{ "pipe0_tx_swing", 15, 1 },
	{ "pipe0_tx_margin", 12, 3 },
	{ "pipe0_tx_deemph", 11, 1 },
	{ "pipe0_tx_detectrx", 10, 1 },
	{ "pipe0_powerdown", 8, 2 },
	{ "phy_mac_phystatus", 0, 8 },
	{ "PCIE_PDEBUG_REG_0x1b", 0x1b, 0 },
	{ "pipe0_rx7_eq_in_prog", 31, 1 },
	{ "pipe0_rx7_eq_invld_req", 30, 1 },
	{ "pipe0_rx7_syncheader", 28, 2 },
	{ "pipe0_rx6_eq_in_prog", 27, 1 },
	{ "pipe0_rx6_eq_invld_req", 26, 1 },
	{ "pipe0_rx6_syncheader", 24, 2 },
	{ "pipe0_rx5_eq_in_prog", 23, 1 },
	{ "pipe0_rx5_eq_invld_req", 22, 1 },
	{ "pipe0_rx5_syncheader", 20, 2 },
	{ "pipe0_rx4_eq_in_prog", 19, 1 },
	{ "pipe0_rx4_eq_invld_req", 18, 1 },
	{ "pipe0_rx4_syncheader", 16, 2 },
	{ "pipe0_rx3_eq_in_prog", 15, 1 },
	{ "pipe0_rx3_eq_invld_req", 14, 1 },
	{ "pipe0_rx3_syncheader", 12, 2 },
	{ "pipe0_rx2_eq_in_prog", 11, 1 },
	{ "pipe0_rx2_eq_invld_req", 10, 1 },
	{ "pipe0_rx2_syncheader", 8, 2 },
	{ "pipe0_rx1_eq_in_prog", 7, 1 },
	{ "pipe0_rx1_eq_invld_req", 6, 1 },
	{ "pipe0_rx1_syncheader", 4, 2 },
	{ "pipe0_rx0_eq_in_prog", 3, 1 },
	{ "pipe0_rx0_eq_invld_req", 2, 1 },
	{ "pipe0_rx0_syncheader", 0, 2 },
	{ "PCIE_PDEBUG_REG_0x1c", 0x1c, 0 },
	{ "SI_ReqVFID", 24, 8 },
	{ "SI_ReqVec", 13, 11 },
	{ "SI_ReqTCVal", 10, 3 },
	{ "SI_ReqRdy", 9, 1 },
	{ "SI_ReqVld", 8, 1 },
	{ "AI", 0, 8 },
	{ "PCIE_PDEBUG_REG_0x1d", 0x1d, 0 },
	{ "GntSI", 31, 1 },
	{ "DropIntForFLR", 30, 1 },
	{ "SmArb", 27, 3 },
	{ "SmDefr", 24, 3 },
	{ "sys_int", 16, 8 },
	{ "CFG_INTXClr", 8, 8 },
	{ "PIO_INTXClr", 0, 8 },
	{ "PCIE_PDEBUG_REG_0x1e", 0x1e, 0 },
	{ "PLI_TABDatWrEn", 31, 1 },
	{ "TAB_RdEna", 30, 1 },
	{ "TAB_RdEna2", 19, 11 },
	{ "PLI_ReqAddr", 10, 9 },
	{ "PLI_ReqVFID", 2, 8 },
	{ "PLI_ReqTabHit", 1, 1 },
	{ "PLI_ReqRdVld", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x1f", 0x1f, 0 },
	{ "PLI_ReqVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x20", 0x20, 0 },
	{"PLI_RspVld", 0, 32 },
	{ NULL }
};

static struct cudbg_reg_info t5_pcie_pdbg_regs_21_to_40[] = {
	{ "PCIE_PDEBUG_REG_0x21", 0x21, 0 },
	{ "PLI_ReqPbaStart", 20, 12 },
	{ "PLI_ReqPbaEnd", 9, 11 },
	{ "PLI_ReqVFID", 2, 7 },
	{ "PLI_ReqPbaHit", 1, 1 },
	{ "PLI_ReqRdVld", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x22", 0x22, 0 },
	{ "GntSI1", 31, 1 },
	{ "GntSI2", 30, 1 },
	{ "GntSI3", 27, 3 },
	{ "GntSI4", 16, 11 },
	{ "GntSI5", 8, 8 },
	{ "GntSI6", 7, 1 },
	{ "GntSI7", 6, 1 },
	{ "GntSI8", 5, 1 },
	{ "GntSI9", 4, 1 },
	{ "GntSIa", 3, 1 },
	{ "GntAI", 2, 1 },
	{ "GntDB", 1, 1 },
	{ "GntDI", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x23", 0x23, 0 },
	{ "DI_ReqVld", 31, 1 },
	{ "DI_ReqRdy", 30, 1 },
	{ "DI_ReqWrEn", 19, 11 },
	{ "DI_ReqMsiEn", 18, 1 },
	{ "DI_ReqMsxEn", 17, 1 },
	{ "DI_ReqMsxVFIDMsk", 16, 1 },
	{ "DI_ReqWrEn2", 2, 14 },
	{ "DI_ReqRdEn", 1, 1 },
	{ "DI_ReqWrEn3", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x24", 0x24, 0 },
	{ "ven_msi_req_24", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x25", 0x25, 0 },
	{ "ven_msi_req", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x26", 0x26, 0 },
	{ "ven_msi_req", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x27", 0x27, 0 },
	{ "FID_STI_RspVld", 31, 1 },
	{ "TAB_StiRdEna", 30, 1 },
	{ "TAB_StiWrEna", 29, 1 },
	{ "TAB_StiRdEna2", 18, 11 },
	{ "PLI_ReqTabHit", 7, 11 },
	{ "GntSI", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x28", 0x28, 0 },
	{ "PLI_ReqWrVld", 31, 1 },
	{ "PLI_ReqPbaHit", 30, 1 },
	{ "PLI_TABAddrLWrEn", 29, 1 },
	{ "PLI_TABAddrHWrEn", 28, 1 },
	{ "PLI_TABDatWrEn", 27, 1 },
	{ "PLI_TABMskWrEn", 26, 1 },
	{ "AI_ReqVld", 23, 3 },
	{ "AI_ReqVld2", 22, 1 },
	{ "AI_ReqRdy", 21, 1 },
	{ "ven_msi_req_28", 18, 3 },
	{ "ven_msi_req2", 11, 7 },
	{ "ven_msi_req3", 6, 5 },
	{ "ven_msi_req4", 3 , 3 },
	{ "ven_msi_req5", 2, 1 },
	{ "ven_msi_grant", 1, 1 },
	{ "ven_msi_req6", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x29", 0x29, 0 },
	{ "TRGT1_ReqDataVld", 16, 26 },
	{ "TRGT1_ReqDataVld2", 12, 4 },
	{ "TRGT1_ReqDataVld3", 11, 1 },
	{ "TRGT1_ReqDataVld4", 10, 1 },
	{ "TRGT1_ReqDataVld5", 9, 1 },
	{ "TRGT1_ReqDataVld6", 8, 1 },
	{ "TRGT1_ReqDataVld7", 4, 4 },
	{ "TRGT1_ReqDataVld8", 2, 2 },
	{ "TRGT1_ReqDataRdy", 1, 1 },
	{ "TRGT1_ReqDataVld0", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x2a", 0x2a, 0 },
	{ "TRGT1_ReqDataVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x2b", 0x2b, 0 },
	{ "radm_trgt1_addr", 20, 12 },
	{ "radm_trgt1_dwen", 16, 4 },
	{ "radm_trgt1_fmt", 14, 2 },
	{ "radm_trgt1_type", 9, 5 },
	{ "radm_trgt1_in_membar_range", 6, 3 },
	{ "radm_trgt1_ecrc_err", 5, 1 },
	{ "radm_trgt1_dllp_abort", 4, 1 },
	{ "radm_trgt1_tlp_abort", 3, 1 },
	{ "radm_trgt1_eot", 2, 1 },
	{ "radm_trgt1_dv_2b", 1, 1 },
	{ "radm_trgt1_hv_2b", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x2c", 0x2c, 0 },
	{ "StateMPIO", 29, 3 },
	{ "StateCPL", 25, 4 },
	{ "StateAlin", 22, 3 },
	{ "StatePL", 19, 3 },
	{ "StateMARsp", 18, 1 },
	{ "MA_TagsInUse", 11, 7 },
	{ "radm_trgt1_hsrdy", 10, 1 },
	{ "radm_trgt1_dsrdy", 9, 1 },
	{ "ALIND_ReqWrDataVld", 8, 1 },
	{ "FID_LkUpWrHdrVld", 7, 1 },
	{ "MPIO_WrVld", 6, 1 },
	{ "trgt1_radm_halt", 5, 1 },
	{ "radm_trgt1_dv_2c", 4, 1 },
	{ "radm_trgt1_dv_2c_2", 3, 1 },
	{ "radm_trgt1_tlp_abort_2c", 2, 1 },
	{ "radm_trgt1_dllp_abort_2c", 1, 1 },
	{ "radm_trgt1_ecrc_err_2c", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x2d", 0x2d, 0 },
	{ "radm_trgt1_hv_2d", 31, 1 },
	{ "radm_trgt1_dv_2d", 30, 1 },
	{ "radm_trgt1_hv2", 23, 7 },
	{ "radm_trgt1_hv3", 20, 3 },
	{ "radm_trgt1_hv4", 16, 4 },
	{ "radm_trgt1_hv5", 12, 4 },
	{ "radm_trgt1_hv6", 11, 1 },
	{ "radm_trgt1_hv7", 10, 1 },
	{ "radm_trgt1_hv8", 7, 3 },
	{ "radm_trgt1_hv9", 6, 1 },
	{ "radm_trgt1_hva", 5, 1 },
	{ "radm_trgt1_dsrdy_2d", 4, 1 },
	{ "radm_trgt1_WrCnt", 0, 4 },
	{ "PCIE_PDEBUG_REG_0x2e", 0x2e, 0 },
	{ "radm_trgt1_hv_2e", 30, 2 },
	{ "radm_trgt1_hv_2e_2", 20, 10 },
	{ "radm_trgt1_hv_we_3", 12, 8 },
	{ "ALIN_ReqDataVld4", 8, 4 },
	{ "ALIN_ReqDataVld5", 7, 1 },
	{ "ALIN_ReqDataVld6", 6, 1 },
	{ "ALIN_ReqDataVld7", 4, 2 },
	{ "ALIN_ReqDataVld8", 3, 1 },
	{ "ALIN_ReqDataVld9", 2, 1 },
	{ "ALIN_ReqDataRdy", 1, 1 },
	{ "ALIN_ReqDataVlda", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x2f", 0x2f, 0 },
	{"ALIN_ReqDataVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x30", 0x30, 0 },
	{ "radm_trgt1_hv_30", 25, 7 },
	{ "PIO_WrCnt", 15, 10 },
	{ "ALIND_ReqWrCnt", 12, 3 },
	{ "FID_LkUpWrCnt", 9, 3 },
	{ "ALIND_ReqRdDataVld", 8, 1 },
	{ "ALIND_ReqRdDataRdy", 7, 1 },
	{ "ALIND_ReqRdDataVld2", 6, 1 },
	{ "ALIND_ReqWrDataVld3", 3, 3 },
	{ "ALIND_ReqWrDataVld4", 2, 1 },
	{ "ALIND_ReqWrDataRdyOpen", 1, 1 },
	{ "ALIND_ReqWrDataVld5", 0, 1 },
	{ "PCIE_PDEBUG_REG_0x31", 0x31, 0 },
	{ "ALIND_ReqWrDataVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x32", 0x32, 0 },
	{ "ALIND_ReqWrDataVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x33", 0x33, 0 },
	{ "ALIND_ReqWrDataVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x34", 0x34, 0 },
	{ "ALIND_ReqWrDataVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x35", 0x35, 0 },
	{ "MPIO_WrVld", 19, 13 },
	{ "FID_LkUpRdHdrVld", 18, 1 },
	{ "FID_LkUpRdHdrVld2", 17, 1 },
	{ "FID_LkUpRdHdrVld3", 16, 1 },
	{ "FID_LkUpRdHdrVld4", 15, 1 },
	{ "FID_LkUpRdHdrVld5", 14, 1 },
	{ "FID_LkUpRdHdrVld6", 13, 1 },
	{ "FID_LkUpRdHdrVld7", 12, 1 },
	{ "FID_LkUpRdHdrVld8", 11, 1 },
	{ "FID_LkUpRdHdrVld9", 10, 1 },
	{ "FID_LkUpRdHdrVlda", 9, 1 },
	{ "FID_LkUpRdHdrVldb", 8, 1 },
	{ "FID_LkUpRdHdrVldc", 7, 1 },
	{ "MPIO_WrVld1", 6, 1 },
	{ "MPIO_WrVld2", 5, 1 },
	{ "MPIO_WrVld3", 4, 1 },
	{ "MPIO_WrVld4", 0, 4 },
	{ "PCIE_PDEBUG_REG_0x36", 0x36, 0 },
	{ "MPIO_WrVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x37", 0x37, 0},
	{ "MPIO_WrVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x38", 0x38, 0 },
	{ "MPIO_WrVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x39", 0x39, 0 },
	{ "MPIO_WrVld", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x3a", 0x3a, 0 },
	{ "client0_tlp_vfunc_active", 31, 1 },
	{ "client0_tlp_vfunc_num", 24, 7 },
	{ "client0_tlp_func_num", 21, 3 },
	{ "client0_tlp_byte_en", 13, 8 },
	{ "client0_tlp_byte_len", 0, 13 },
	{ "PCIE_PDEBUG_REG_0x3b", 0x3b, 0 },
	{ "xadm_client0_halt", 31, 1 },
	{ "client0_tlp_dv", 30, 1 },
	{ "client0_addr_align_en", 29, 1 },
	{ "client0_cpl_bcm", 28, 1 },
	{ "client0_tlp_ep", 27, 1 },
	{ "client0_cpl_status", 24, 3 },
	{ "client0_tlp_td", 23, 1 },
	{ "client0_tlp_type", 18 , 5 },
	{ "client0_tlp_fmt", 16, 2 },
	{ "client0_tlp_bad_eot", 15, 1 },
	{ "client0_tlp_eot", 14, 1 },
	{ "client0_tlp_attr", 11, 3 },
	{ "client0_tlp_tc", 8, 3 },
	{ "client0_tlp_tid", 0, 8 },
	{ "PCIE_PDEBUG_REG_0x3c", 0x3c, 0 },
	{ "MEM_RspRRAVld", 31, 1 },
	{ "MEM_RspRRARdy", 30, 1 },
	{ "PIO_RspRRAVld", 29, 1 },
	{ "PIO_RspRRARdy", 28, 1 },
	{ "MEM_RspRdVld", 27, 1 },
	{ "MEM_RspRdRRARdy", 26, 1 },
	{ "PIO_RspRdVld", 25, 1 },
	{ "PIO_RspRdRRARdy", 24, 1 },
	{ "TGT_TAGQ_RdVld", 16 , 8},
	{ "CplTxnDisable", 8, 8 },
	{ "CplTxnDisable2", 7, 1 },
	{ "client0_tlp_hv", 0, 7 },
	{ "PCIE_PDEBUG_REG_0x3D", 0x3d, 0 },
	{ "pdebug_0x3D", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x3E", 0x3e, 0 },
	{ "pdebug_0x3E", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x3F", 0x3f, 0 },
	{ "pdebug_0x3F", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x40", 0x40, 0 },
	{ "pdebug_0x40", 0, 32 },
	{ NULL }
};

static struct cudbg_reg_info t5_pcie_pdbg_regs_41_to_50[] = {
	{ "PCIE_PDEBUG_REG_0x41", 0x41, 0 },
	{ "pdebug_0x41", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x42", 0x42, 0 },
	{ "pdebug_0x42", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x43", 0x43, 0 },
	{ "pdebug_0x43", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x44", 0x44, 0 },
	{ "pdebug_0x44", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x45", 0x45, 0 },
	{ "pdebug_0x45", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x46", 0x46, 0 },
	{ "pdebug_0x46", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x47", 0x47, 0 },
	{ "pdebug_0x47", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x48", 0x48, 0 },
	{ "pdebug_0x48", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x49", 0x49, 0 },
	{ "pdebug_0x49", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x4a", 0x4a, 0 },
	{ "pdebug_0x4A", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x4b", 0x4b, 0 },
	{ "pdebug_0xaB", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x4c", 0x4c, 0 },
	{ "pdebug_0x4C", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x4d", 0x4d, 0 },
	{ "pdebug_0x4D", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x4e", 0x4e, 0 },
	{ "pdebug_0x4E", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x4f", 0x4f, 0 },
	{ "pdebug_0x4F", 0, 32 },
	{ "PCIE_PDEBUG_REG_0x50", 0x50, 0 },
	{ "pdebug_0x50", 0, 32 },
	{ NULL }
};

static struct cudbg_reg_info t5_pcie_cdbg_regs_00_to_20[] = {
	{ "PCIE_CDEBUG_REG_0x0", 0x00, 0 },
	{ "PCIE_CDEBUG_REG_0x1", 0x01, 0 },
	{ "PCIE_CDEBUG_REG_0x2", 0x02, 0 },
	{ "FLR_ReqVld", 31, 1 },
	{ "D_RspVld", 28, 3 },
	{ "D_RspVld2", 27, 1 },
	{ "D_RspVld3", 26, 1 },
	{ "D_RspVld4", 25, 1 },
	{ "D_RspVld5", 24, 1 },
	{ "D_RspVld6", 20, 4 },
	{ "D_RspAFull", 16, 4 },
	{ "D_RdReqVld", 12, 4 },
	{ "D_RdReqAFull", 8, 4 },
	{ "D_WrReqVld", 4, 4 },
	{ "D_WrReqAFull", 0, 4 },
	{ "PCIE_CDEBUG_REG_0x3", 0x03, 0 },
	{ "C_ReqVld", 19, 13 },
	{ "C_RspVld2", 16, 3 },
	{ "C_RspVld3", 15, 1 },
	{ "C_RspVld4", 14, 1 },
	{ "C_RspVld5", 13, 1 },
	{ "C_RspVld6", 12, 1 },
	{ "C_RspVld7", 9, 3 },
	{ "C_RspAFull", 6, 3 },
	{ "C_ReqVld8", 3, 3 },
	{ "C_ReqAFull", 0, 3 },
	{ "PCIE_CDEBUG_REG_0x4", 0x04, 0 },
	{ "H_ReqVld", 7, 25 },
	{ "H_RspVld", 6, 1 },
	{ "H_RspVld2", 5, 1 },
	{ "H_RspVld3", 4, 1 },
	{ "H_RspVld4", 3, 1 },
	{ "H_RspAFull", 2, 1 },
	{ "H_ReqVld2", 1, 1 },
	{ "H_ReqAFull", 0, 1 },
	{ "PCIE_CDEBUG_REG_0x5", 0x05, 0 },
	{ "ER_RspVld", 16, 16 },
	{ "ER_ReqVld2", 5, 10 },
	{ "ER_ReqVld3", 2, 3 },
	{ "ER_RspVld4", 1, 1 },
	{ "ER_ReqVld5", 0, 1 },
	{ "PCIE_CDEBUG_REG_0x6", 0x06, 0 },
	{ "PL_BAR2_ReqVld", 4, 28 },
	{ "PL_BAR2_ReqVld2", 3, 1 },
	{ "PL_BAR2_ReqVlde", 2, 1 },
	{ "PL_BAR2_ReqFull", 1, 1 },
	{ "PL_BAR2_ReqVld4", 0, 1},
	{ "PCIE_CDEBUG_REG_0x7", 0x07, 0 },
	{"PL_BAR2_ReqVld_7", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x8", 0x08, 0 },
	{"PL_BAR2_ReqVld_8", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x9", 0x09, 0 },
	{"PL_BAR2_ReqVld_9", 0, 32 },
	{ "PCIE_CDEBUG_REG_0xa", 0x0a, 0 },
	{ "VPD_RspVld", 20, 12 },
	{ "VPD_ReqVld2", 9, 11 },
	{ "VPD_ReqVld3", 6, 3 },
	{ "VPD_ReqVld4", 5, 1 },
	{ "VPD_ReqVld5", 3, 2 },
	{ "VPD_RspVld2", 2, 1 },
	{ "VPD_RspVld3", 1, 1 },
	{ "VPD_ReqVld6", 0, 1 },
	{ "PCIE_CDEBUG_REG_0xb", 0x0b, 0 },
	{ "MA_ReqDataVld", 28, 4 },
	{ "MA_ReqAddrVld", 27, 1 },
	{ "MA_ReqAddrVld2", 26, 1 },
	{ "MA_RspDataVld2", 22, 4 },
	{ "MA_ReqAddrVld3", 20, 2 },
	{ "MA_ReqAddrVld4", 4, 16 },
	{ "MA_ReqAddrVld5", 3, 1 },
	{ "MA_ReqAddrVld6", 2, 1 },
	{ "MA_ReqAddrRdy", 1, 1 },
	{ "MA_ReqAddrVld7", 0, 1 },
	{ "PCIE_CDEBUG_REG_0xc", 0x0c, 0 },
	{ "MA_ReqAddrVld_c", 0, 32 },
	{ "PCIE_CDEBUG_REG_0xd", 0x0d, 0 },
	{ "MA_ReqAddrVld_d", 0, 32 },
	{ "PCIE_CDEBUG_REG_0xe", 0x0e, 0 },
	{ "MA_ReqAddrVld_e", 0, 32 },
	{ "PCIE_CDEBUG_REG_0xf", 0x0f, 0 },
	{ "MA_ReqAddrVld_f", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x10", 0x10, 0 },
	{ "MA_ReqAddrVld_10", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x11", 0x11, 0 },
	{ "MA_ReqAddrVld_11", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x12", 0x12, 0 },
	{ "MA_ReqAddrVld_12", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x13", 0x13, 0 },
	{ "MA_ReqAddrVld_13", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x14", 0x14, 0 },
	{ "MA_ReqAddrVld_14", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x15", 0x15, 0 },
	{ "PLM_ReqVld",  19, 13 },
	{ "PLM_ReqVld2", 18, 1 },
	{ "PLM_RspVld3", 17, 1 },
	{ "PLM_ReqVld4", 16, 1 },
	{ "PLM_ReqVld5", 15, 1 },
	{ "PLM_ReqVld6", 14, 1 },
	{ "PLM_ReqVld7", 13, 1 },
	{ "PLM_ReqVld8", 12, 1 },
	{ "PLM_ReqVld9", 4, 8 },
	{ "PLM_ReqVlda", 1, 3 },
	{ "PLM_ReqVldb", 0, 1 },
	{ "PCIE_CDEBUG_REG_0x16", 0x16, 0 },
	{ "PLM_RspVld", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x17", 0x17, 0 },
	{ "cdebug_0x17", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x18", 0x18, 0 },
	{ "cdebug_0x18", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x19", 0x19, 0 },
	{ "cdebug_0x19", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x1A", 0x1a, 0 },
	{ "cdebug_0x1A", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x1B", 0x1b, 0 },
	{ "cdebug_0x1B", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x1C", 0x1c, 0 },
	{ "cdebug_0x1C", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x1D", 0x1d, 0 },
	{ "cdebug_0x1D", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x1E", 0x1e, 0 },
	{ "cdebug_0x1E", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x1F", 0x1f, 0 },
	{ "cdebug_0x1F", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x20", 0x20, 0 },
	{ "cdebug_0x20", 0, 32 },
	{ NULL }
};

static struct cudbg_reg_info t5_pcie_cdbg_regs_21_to_37[] = {
	{ "PCIE_CDEBUG_REG_0x21", 0x21, 0 },
	{ "cdebug_0x21", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x22", 0x22, 0 },
	{ "cdebug_0x22", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x23", 0x23, 0 },
	{ "cdebug_0x23", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x24", 0x24, 0 },
	{ "cdebug_0x24", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x25", 0x25, 0 },
	{ "cdebug_0x25", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x26", 0x26, 0 },
	{ "cdebug_0x26", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x27", 0x27, 0 },
	{ "cdebug_0x27", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x28", 0x28, 0 },
	{ "cdebug_0x28", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x29", 0x29, 0 },
	{ "cdebug_0x29", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x2a", 0x2a, 0 },
	{ "cdebug_0x2A", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x2b", 0x2b, 0 },
	{ "cdebug_0x2B", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x2c", 0x2c, 0 },
	{ "cdebug_0x2C", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x2d", 0x2d, 0 },
	{ "cdebug_0x2D", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x2e", 0x2e, 0 },
	{ "cdebug_0x2E", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x2f", 0x2f, 0 },
	{ "cdebug_0x2F", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x30", 0x30, 0 },
	{ "cdebug_0x30", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x31", 0x31, 0 },
	{ "cdebug_0x31", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x32", 0x32, 0 },
	{ "cdebug_0x32", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x33", 0x33, 0 },
	{ "cdebug_0x33", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x34", 0x34, 0 },
	{ "cdebug_0x34", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x35", 0x35, 0 },
	{ "cdebug_0x35", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x36", 0x36, 0 },
	{ "cdebug_0x36", 0, 32 },
	{ "PCIE_CDEBUG_REG_0x37", 0x37, 0 },
	{ "cdebug_0x37", 0, 32 },
	{ NULL }
};

static struct cudbg_reg_info t5_pm_rx_regs_10000_to_10020[] = {
	{ "PM_TX_ISPI_DBG_4B_DATA0", 0x10000, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA1", 0x10001, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA2", 0x10002, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA3", 0x10003, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA4", 0x10004, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA5", 0x10005, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA6", 0x10006, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA7", 0x10007, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_ISPI_DBG_4B_DATA8", 0x10008, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA0", 0x10009, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA1", 0x1000a, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA2", 0x1000b, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA3", 0x1000c, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA4", 0x1000d, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA5", 0x1000e, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA6", 0x1000f, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA7", 0x10010, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA8", 0x10011, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_OSPI_DBG_4B_DATA9", 0x10012, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_RX_DBG_STAT_MSB", 0x10013, 0 },
	{ "stat_msb", 0, 32 },
	{ "PM_RX_DBG_STAT_LSB", 0x10014, 0 },
	{ "stat_lsb", 0, 32 },
	{ "PM_RX_DBG_RSVD_FLIT_CNT", 0x10015, 0 },
	{ "i_to_o_path_rsvd_flit_backup", 12, 4 },
	{ "i_to_o_path_rsvd_flit", 8, 4 },
	{ "prfch_rsvd_flit", 4, 4 },
	{ "ospi_rsvd_flit", 0, 4 },
	{ "PM_RX_SDC_EN", 0x10016, 0 },
	{ "sdc_en", 0, 1 },
	{ "PM_RX_INOUT_FIFO_DBG_CHNL_SEL", 0x10017, 0 },
	{ "chnl_3_sel", 3, 1 },
	{ "chnl_2_sel", 2, 1 },
	{ "chnl_1_sel", 1, 1 },
	{ "chnl_0_sel", 0, 1 },
	{ "PM_RX_INOUT_FIFO_DBG_WR", 0x10018, 0 },
	{ "o_fifo_write", 3, 1 },
	{ "i_fifo_write", 2, 1 },
	{ "o_fifo_read", 1, 1 },
	{ "i_fifo_read", 0, 1 },
	{ "PM_RX_INPUT_FIFO_STR_FWD_EN", 0x10019, 0 },
	{ "ispi_str_fwd_en", 0, 1 },
	{ "PM_RX_PRFTCH_ACROSS_BNDLE_EN", 0x1001a, 0 },
	{ "prftch_across_bndle_en", 0, 1 },
	{ "PM_RX_PRFTCH_WRR_ENABLE", 0x1001b, 0 },
	{ "prftch_wrr_enable", 0, 1 },
	{ "PM_RX_PRFTCH_WRR_MAX_DEFICIT_CNT", 0x1001c, 0 },
	{ "chnl1_max_deficit_cnt", 16, 16 },
	{ "chnl0_max_deficit_cnt", 0, 16 },
	{ "PM_RX_FEATURE_EN", 0x1001d, 0 },
	{ "pio_ch_deficit_ctl_en", 0, 1 },
	{ "PM_RX_CH0_OSPI_DEFICIT_THRSHLD", 0x1001e, 0 },
	{ "CH0_OSPI_DEFICIT_THRSHLD", 0, 12 },
	{ "PM_RX_CH1_OSPI_DEFICIT_THRSHLD", 0x1001f, 0 },
	{ "CH1_OSPI_DEFICIT_THRSHLD", 0, 12 },
	{ "PM_RX_INT_CAUSE_MASK_HALT", 0x10020, 0 },
	{ "INT_CAUSE_MASK", 0, 32 },
	{ NULL }
};

static struct cudbg_reg_info t5_pm_rx_regs_10021_to_1002c[] = {
	{ "PM_RX_DBG_STAT0", 0x10021, 0 },
	{ "rx_rd_i_busy", 29, 1 },
	{ "rx_wr_to_o_busy", 28, 1 },
	{ "rx_m_to_o_busy", 27, 1 },
	{ "rx_i_to_m_busy", 26, 1 },
	{ "rx_pcmd_fb_only", 25, 1 },
	{ "rx_pcmd_mem", 24, 1 },
	{ "rx_pcmd_bypass", 23, 1 },
	{ "rx_pcmd_eop", 22, 1 },
	{ "rx_dumplicate_pcmd_eop", 21, 1 },
	{ "rx_pcmd_eob", 20, 1 },
	{ "rx_pcmd_fb", 16, 4 },
	{ "rx_pcmd_len", 0, 16 },
	{ "PM_RX_DBG_STAT1", 0x10022, 0 },
	{ "rx_PCMD0_mem", 30, 1 },
	{ "rx_free_ospi_cnt0", 18, 12 },
	{ "rx_PCMD0_flit_len", 6, 12 },
	{ "rx_PCMD0_cmd", 2, 4 },
	{ "rx_ofifo_full0", 1, 1 },
	{ "rx_PCMD0_bypass", 0, 1 },
	{ "PM_RX_DBG_STAT2", 0x10023, 0 },
	{ "rx_PCMD1_mem", 30, 1 },
	{ "rx_free_ospi_cnt1", 18, 12 },
	{ "rx_PCMD1_flit_len", 6, 12 },
	{ "rx_PCMD1_cmd", 2, 4 },
	{ "rx_ofifo_full1", 1, 1 },
	{ "rx_PCMD1_bypass", 0, 1 },
	{ "PM_RX_DBG_STAT3", 0x10024, 0 },
	{ "rx_set_pcmd_res_rdy_rd", 10, 2 },
	{ "rx_issued_prefetch_rd_e_clr", 8, 2 },
	{ "rx_issued_prefetch_rd", 6, 2 },
	{ "rx_pcmd_res_rdy", 4, 2 },
	{ "rx_db_vld", 3, 1 },
	{ "rx_first_bundle", 1, 2 },
	{ "rx_sdc_drdy", 0, 1 },
	{ "PM_RX_DBG_STAT4", 0x10025, 0 },
	{ "rx_pcmd_vld", 26, 1 },
	{ "rx_pcmd_to_ch", 25, 1 },
	{ "rx_pcmd_from_ch", 23, 2 },
	{ "rx_line", 18, 5 },
	{ "rx_iespi_TxValid", 14, 4 },
	{ "rx_iespi_TxFull", 10, 4 },
	{ "rx_PCMD_srdy", 8, 2 },
	{ "rx_PCMD_drdy", 6, 2 },
	{ "rx_pcmd_cmd", 2 , 4},
	{ "rx_pcmd_res_rdy", 0, 2 },
	{ "PM_RX_DBG_STAT5", 0x10026, 0 },
	{ "rx_atlst_1_pcmd_ch1", 29, 1 },
	{ "rx_atlst_1_pcmd_ch0", 28, 1 },
	{ "rx_pcmd_drdy", 26, 2 },
	{ "rx_pcmd_srdy", 24, 2 },
	{ "rx_Ispi_TxValid", 20, 4 },
	{ "rx_Ispi_Full", 16, 4 },
	{ "rx_Ospi_TxValid", 14, 2 },
	{ "rx_Ospi_Full", 12, 2 },
	{ "rx_E_RxValid", 8, 4 },
	{ "rx_E_RxAFull", 4, 4 },
	{ "rx_C_TxValid", 2, 2 },
	{ "rx_C_TxAFull", 0, 2 },
	{ "PM_RX_DBG_STAT6", 0x10027, 0 },
	{ "rx_m_intrnl_fifo_cnt", 4, 2 },
	{ "rx_M_ReqAddrRdy", 3, 1 },
	{ "rx_M_ReqWrite", 2, 1 },
	{ "rx_M_ReqDataVld", 1, 1 },
	{ "rx_M_ReqDataRdy", 0, 1 },
	{ "PM_RX_DBG_STAT7", 0x10028, 0 },
	{ "rx_pcmd1_free_cnt", 7, 7 },
	{ "rx_pcmd0_free_cnt", 0, 7 },
	{ "PM_RX_DBG_STAT8", 0x10029, 0 },
	{ "rx_In_Eop_Cnt3", 28, 4 },
	{ "rx_In_Eop_Cnt2", 24, 4 },
	{ "rx_In_Eop_Cnt1", 20, 4 },
	{ "rx_In_Eop_Cnt0", 16, 4 },
	{ "rx_In_Sop_Cnt3", 12, 4 },
	{ "rx_In_Sop_Cnt2", 8, 4 },
	{ "rx_In_Sop_Cnt1", 4, 4 },
	{ "rx_In_Sop_Cnt0", 0, 4 },
	{ "PM_RX_DBG_STAT9", 0x1002a, 0 },
	{ "rx_rsvd0", 28, 4 },
	{ "rx_rsvd1", 24, 4 },
	{ "rx_Out_Eop_Cnt1", 20, 4 },
	{ "rx_Out_Eop_Cnt0", 16, 4 },
	{ "rx_rsvd2", 12, 4 },
	{ "rx_rsvd3", 8, 4 },
	{ "rx_Out_Sop_Cnt1", 4, 4 },
	{ "rx_Out_Sop_Cnt0", 0, 4 },
	{ "PM_RX_DBG_STAT10", 0x1002b, 0 },
	{ "rx_ch_deficit_blowed", 24, 1 },
	{ "rx_ch1_deficit", 12, 12 },
	{ "rx_ch0_deficit", 0, 12 },
	{ "PM_RX_DBG_STAT11", 0x1002c, 0 },
	{ "rx_bundle_len_srdy", 30, 2 },
	{ "rx_rsvd11_1", 28, 2 },
	{ "rx_bundle_len1", 16, 12 },
	{ "rx_rsvd11", 12, 4 },
	{ "rx_bundle_len0", 0, 12 },
	{ NULL }
};

static struct cudbg_reg_info t5_pm_tx_regs_10000_to_10020[] = {
	{ "PM_TX_ISPI_DBG_4B_DATA0", 0x10000, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA1", 0x10001, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA2", 0x10002, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA3", 0x10003, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA4", 0x10004, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA5", 0x10005, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA6", 0x10006, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA7", 0x10007, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_ISPI_DBG_4B_DATA8", 0x10008, 0 },
	{ "ispi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA0", 0x10009, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA1", 0x1000a, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA2", 0x1000b, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA3", 0x1000c, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA4", 0x1000d, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA5", 0x1000e, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA6", 0x1000f, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA7", 0x10010, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA8", 0x10011, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA9", 0x10012, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA10", 0x10013, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA11", 0x10014, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA12", 0x10015, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA13", 0x10016, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA14", 0x10017, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA15", 0x10018, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_OSPI_DBG_4B_DATA16", 0x10019, 0 },
	{ "ospi_dbg_data", 0, 32 },
	{ "PM_TX_DBG_STAT_MSB", 0x1001a, 0 },
	{ "stat_msb", 0, 32 },
	{ "PM_TX_DBG_STAT_LSB", 0x1001b, 0 },
	{ "stat_lsb", 0, 32 },
	{ "PM_TX_DBG_RSVD_FLIT_CNT", 0x1001c, 0 },
	{ "i_to_o_path_rsvd_flit_backup", 12, 4 },
	{ "i_to_o_path_rsvd_flit", 8, 4 },
	{ "prfch_rsvd_flit", 4, 4 },
	{ "ospi_rsvd_flit", 0, 4 },
	{ "PM_TX_SDC_EN", 0x1001d, 0 },
	{ "sdc_en", 0, 1 },
	{ "PM_TX_INOUT_FIFO_DBG_CHNL_SEL", 0x1001e, 0 },
	{ "chnl_3_sel", 3, 1 },
	{ "chnl_2_sel", 2, 1 },
	{ "chnl_1_sel", 1, 1 },
	{ "chnl_0_sel", 0, 1 },
	{ "PM_TX_INOUT_FIFO_DBG_WR", 0x1001f, 0 },
	{ "o_fifo_write", 3, 1 },
	{ "i_fifo_write", 2, 1 },
	{ "o_fifo_read", 1, 1 },
	{ "i_fifo_read", 0, 1 },
	{ "PM_TX_INPUT_FIFO_STR_FWD_EN", 0x10020, 0 },
	{ "ispi_str_fwd_en", 0, 1 },
	{ NULL }
};

static struct cudbg_reg_info t5_pcie_config_regs_00_to_208[] = {
	{ "PCIE_DEVID_VENID", 0x00, 0 },
	{ "VendorID", 0, 16 },
	{ "DeviceID", 16, 16 },
	{ "PCIE_STAT_CMD", 0x04, 0 },
	{ "IOEnable", 0, 1 },
	{ "MemEnable", 1, 1 },
	{ "BusMasterEnable", 2, 1 },
	{ "Rsvdl", 3, 3 },
	{ "PERREnable", 6, 1 },
	{ "Rsvd2", 7, 1 },
	{ "SERREnable", 8, 1 },
	{ "Rsvd3", 9, 1 },
	{ "IntDisable", 10, 1 },
	{ "Rsvd4", 11, 8 },
	{ "IntStatus", 19, 1 },
	{ "CapList", 20, 1 },
	{ "Rsvd5", 21, 3 },
	{ "MstDatParErr", 24, 1 },
	{ "Rsvd6", 25, 2 },
	{ "SigTgtAbort", 27, 1 },
	{ "RcvTgtAbort", 28, 1 },
	{ "RcvMstAbort", 29, 1 },
	{ "SigSERR", 30, 1 },
	{ "DetPERR", 31, 1 },
	{ "PCIE_CCODE_REVID", 0x08, 0 },
	{ "RevisionID", 0, 8, },
	{ "ClassCode", 8, 24 },
	{ "PCIE_BIST_HDR_TMR_CLS", 0xc, 0 },
	{ "CacheLineSize", 0, 8 },
	{ "MstLatTimer", 8, 8 },
	{ "HdrType", 16, 8 },
	{ "BIST", 24, 8 },
	{ "PCIE_BAR0", 0x10, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Prefetchable", 3, 1 },
	{ "BaseAddress", 4, 28 },
	{ "PCIE_BAR1", 0x14, 0 },
	{ "PCIE_BAR2", 0x18, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Prefetchable", 3, 1 },
	{ "BaseAddress", 4, 28 },
	{ "PCIE_BAR3", 0x1c, 0 },
	{ "PCIE_BAR4", 0x20, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Prefetchable", 3, 1 },
	{ "BaseAddress", 4, 28 },
	{ "PCIE_BAR5", 0x24, 0 },
	{ "PCIE_CIS", 0x28, 0 },
	{ "PCIE_SSID_SSVENID", 0x2c, 0 },
	{ "SSVenID", 0, 16 },
	{ "SSID", 16, 16 },
	{ "PCIE_EXPROM", 0x30, 0 },
	{ "ExpROMEn", 0, 1 },
	{ "Rsvd", 1, 10 },
	{ "BaseAddr", 11, 21 },
	{ "PCIE_CAP_PTR", 0x34, 0 },
	{ "CapPtr", 0, 8 },
	{ "Rsvd", 8, 24 },
	{ "PCIE_INT_LINE_PIN", 0x3c, 0 },
	{ "IntLine", 0, 8 },
	{ "IntPin", 8, 8 },
	{ "Rsvd", 16, 16 },
	{ "PCIE_PM_CAP", 0x40, 0 },
	{ "PMCapID", 0, 8 },
	{ "NextCapPtr", 8, 8 },
	{ "PMVer", 16, 3 },
	{ "PMEClock", 19, 1 },
	{ "Rsvd", 20, 1 },
	{ "DSI", 21, 1 },
	{ "AuxCur", 22, 3 },
	{ "D1Sup", 25, 1 },
	{ "D2Sup", 26, 1 },
	{ "PMESup", 27, 5 },
	{ "PCIE_MSI_CAP", 0x50, 0 },
	{ "MSICapID", 0, 8 },
	{ "NextCapPtr", 8, 8 },
	{ "MSIEn", 16, 1 },
	{ "MultMsgCap", 17, 3 },
	{ "MultMsgEn", 20, 3 },
	{ "MSI64Cap", 23, 1 },
	{ "PerVecMaskCap", 24, 1 },
	{ "Rsvd", 25, 7 },
	{ "PCIE_MSI_ADDR", 0x54, 0 },
	{ "Rsvd", 0, 2 },
	{ "MsgAddr", 2, 30 },
	{ "PCIE_MSI_UPR_ADDR", 0x58, 0 },
	{ "MsgUprAddr", 0, 32 },
	{ "PCIE_MSI_DATA", 0x5c, 0 },
	{ "MsgData", 0, 16 },
	{ "Rsvd", 16, 16 },
	{ "PCIE_MSI_MASK", 0x60, 0 },
	{ "MSIMask", 0, 32 },
	{ "PCIE_MSI_PND", 0x64, 0 },
	{ "MSIPnd", 0, 32 },
	{ "PCIE_PCIE_CAP", 0x70, 0 },
	{ "PCIECapID", 0, 8 },
	{ "NextCapPtr", 8, 8 },
	{ "PCIECapVer", 16, 4 },
	{ "DeviceType", 20, 4 },
	{ "SlotImpl", 24, 1 },
	{ "IntMsgNum", 25, 5 },
	{ "Rsvd", 30, 2 },
	{ "PCIE_DEV_CAP", 0x74, 0 },
	{ "MaxPyldSzSup", 0, 3 },
	{ "PhantomFuncSup", 3, 2 },
	{ "ExtTagSup", 5, 1 },
	{ "L0sAccLat", 6, 3 },
	{ "L1AccLat", 9, 3 },
	{ "Rsvd1", 13, 3 },
	{ "RoleBasedErr", 15, 1 },
	{ "Rsvd2", 16, 2 },
	{ "CapSlotPwrLmtVal", 18, 8 },
	{ "CapSlotPwrLmtScl", 26, 2 },
	{ "FLRCap", 28, 1 },
	{ "Rsvd3", 29, 3 },
	{ "PCIE_DEV_STAT_CNTL", 0x78, 0 },
	{ "CorErrRptEn", 0, 1 },
	{ "NonFatErrRptEn", 1, 1 },
	{ "FatErrRptEn", 2, 1 },
	{ "UnSupReqRptEn", 3, 1 },
	{ "RlxOrdEn", 4, 1 },
	{ "MaxPyldSz", 5, 3 },
	{ "ExtTagEn", 8, 1 },
	{ "PhantomFuncEn", 9, 1 },
	{ "AuxPwrPMEn", 10, 1 },
	{ "NoSnoopEn", 11, 1 },
	{ "MaxRdReqSz", 12, 3 },
	{ "InitiateFLR", 15, 1 },
	{ "CorErrDet", 16, 1 },
	{ "NonFatErrDet", 17, 1 },
	{ "FatErrDet", 18, 1 },
	{ "UnSupReqDet", 19, 1 },
	{ "AuxPwrDet", 20, 1 },
	{ "TxnPnd", 21, 1 },
	{ "Rsvd", 22, 10 },
	{ "PCIE_LINK_CAP", 0x7c, 0 },
	{ "MaxLinkSpeed", 0, 4 },
	{ "MaxLinkWidth", 4, 6 },
	{ "ASPMSup", 10, 2 },
	{ "L0sExitLat", 12, 3 },
	{ "L1ExitLat", 15, 3 },
	{ "ClkPwrMgmt", 18, 1 },
	{ "SurpriseDnErrRptCap", 19, 1 },
	{ "DLLActvRptCap", 20, 1 },
	{ "LnkBWNotifCap", 21, 1 },
	{ "ASPMOptComp", 22, 1 },
	{ "Rsvd", 23, 1 },
	{ "PortNum", 24, 8 },
	{ "PCIE_LINK_STAT_CNTL", 0x80, 0 },
	{ "ASPMCtl", 0, 2 },
	{ "Rsvd1", 2, 1 },
	{ "RCB", 3, 1 },
	{ "LinkDisable", 4, 1 },
	{ "RetrainLink", 5, 1 },
	{ "ComClkCfg", 6, 1 },
	{ "ExtendedSync", 7, 1 },
	{ "ClkPwrMgmtEn", 8, 1 },
	{ "HWAutoWidthDis", 9, 1 },
	{ "LnkBWMgmtIntEn", 10, 1 },
	{ "LnkAutoBWIntEn", 11, 1 },
	{ "Rsvd2", 12, 4 },
	{ "CurLinkSpeed", 16, 4 },
	{ "NegLinkWidth", 20, 6 },
	{ "Rsvd3", 26, 1 },
	{ "LnkTraining", 27, 1 },
	{ "SlotClkCfg", 28, 1 },
	{ "DLLActive", 29, 1 },
	{ "LnkBWMgmtStat", 30, 1 },
	{ "LnkAutoBWStat", 31, 1 },
	{ "PCIE_DEV_CAP2", 0x94, 0 },
	{ "CplTORangesSup", 0, 4 },
	{ "CplTODisSup", 4, 1 },
	{ "ARIFwdSup", 5, 1 },
	{ "AtomicOpRouteSup", 5, 1 },
	{ "32bAtomicOpCplSup", 7, 1 },
	{ "64bAtomicOpCplSup", 8, 1 },
	{ "128bCASCplSup", 9, 1 },
	{ "NoROPRPRPass", 10, 1 },
	{ "LTRMechSupp", 11, 1 },
	{ "TPHCplSupp", 12, 2 },
	{ "Rsvd1", 14, 4 },
	{ "OBFFSupp", 18, 2 },
	{ "ExtFmtSupp", 20, 1 },
	{ "EndEndTLPPrSupp", 21, 1 },
	{ "MaxEndEndTLPPr", 22, 2 },
	{ "Rsvd2", 24, 8 },
	{ "PCIE_DEV_STAT_CNTL2", 0x98, 0 },
	{ "CplTOValue", 0, 4 },
	{ "CplTODis", 4, 1 },
	{ "ARIFwdEn", 5, 1 },
	{ "AtomicOpRqstEn", 6, 1 },
	{ "AtomicOpEgBlock", 7, 1 },
	{ "IDORqstEn", 8, 1 },
	{ "IDOCplEn", 9, 1 },
	{ "LTRMechEn", 10, 1 },
	{ "Rsvd1", 11, 2 },
	{ "OBFFEn", 13, 2 },
	{ "EndEndTLPPrBlock", 15, 1 },
	{ "Rsvd2", 16, 16 },
	{ "PCIE_LINK_CAP2", 0x9c, 0 },
	{ "Rsvd1", 0, 1 },
	{ "SupLinkSpeeds", 1, 7 },
	{ "CrossLinkSup", 8, 1 },
	{ "Rsvd2", 9, 23 },
	{ "PCIE_LINK_STAT_CNTL2", 0xa0, 0 },
	{ "TarLnkSpeed", 0, 4 },
	{ "EnterComp", 4, 1 },
	{ "HWAutoSpeedDis", 5, 1 },
	{ "SelDeEmph", 6, 1 },
	{ "TxMargin", 7, 3 },
	{ "EnterModComp", 10, 1 },
	{ "CompSOS", 11, 1 },
	{ "CompDeEmph", 12, 4 },
	{ "CurDeEmph", 16, 1 },
	{ "EqComplete", 17, 1 },
	{ "EqPh1Succ", 18, 1 },
	{ "EqPh2Succ", 19, 1 },
	{ "EqPh3Succ", 20, 1 },
	{ "LinkEqRqst", 21, 1 },
	{ "Rsvd", 22, 10 },
	{ "PCIE_MSIX_CAP", 0xb0, 0 },
	{ "MSIXCapID", 0, 8 },
	{ "NextCapPtr", 8, 8 },
	{ "TableSize", 16, 11 },
	{ "Rsvd", 27, 3 },
	{ "FuncMask", 30, 1 },
	{ "MSIXEn", 31, 1 },
	{ "PCIE_MSIX_TBL_OFST_BIR", 0xb4, 0 },
	{ "TblBIR", 0, 3 },
	{ "TblOfst", 3, 29 },
	{ "PCIE_MSIX_PBA_OFST_BIR", 0xb8, 0 },
	{ "PBABIR", 0, 3 },
	{ "PBAOfst", 3, 29 },
	{ "PCIE_VPD_CAP", 0xd0, 0 },
	{ "VPDCapID", 0, 8 },
	{ "NextCapPtr", 8, 8 },
	{ "VPDAddr", 16, 15 },
	{ "VPDFBit", 31, 1 },
	{ "PCIE_VPD_DATA", 0xd4, 0 },
	{ "Data", 0, 32 },
	{ "PCIE_AER_CAP", 0x100, 0 },
	{ "AERCapID", 0, 16 },
	{ "AERCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_AER_UNCOR_ERR_STAT", 0x104, 0 },
	{ "Undefined", 0, 1 },
	{ "Rsvd1", 1, 3 },
	{ "DLLProtErr", 4, 1 },
	{ "SurpriseDnErr", 5, 1 },
	{ "Rsvd2", 6, 6 },
	{ "PsndTLP", 12, 1 },
	{ "FlowCtlProtErr", 13, 1 },
	{ "ComplTO", 14, 1 },
	{ "ComplAbort", 15, 1 },
	{ "UnExpCpl", 16, 1 },
	{ "RcvrOFlow", 17, 1 },
	{ "MalTLP", 18, 1 },
	{ "ECRCErr", 19, 1 },
	{ "UnSupReqErr", 20, 1 },
	{ "ACSViol", 21, 1 },
	{ "UnIntErr", 22, 1 },
	{ "MCBlockTLP", 23, 1 },
	{ "AtomicOPEgBlock", 24, 1 },
	{ "TLPPrBlockErr", 25, 1 },
	{ "Rsvd3", 26, 6 },
	{ "PCIE_AER_UNCOR_ERR_MASK", 0x108, 0 },
	{ "Rsvd1", 0, 4 },
	{ "DLLProtErr", 4, 1 },
	{ "SurpriseDnErr", 5, 1 },
	{ "Rsvd2", 6, 6 },
	{ "PsndTLP", 12, 1 },
	{ "FlowCtlProtErr", 13, 1 },
	{ "ComplTO", 14, 1 },
	{ "ComplAbort", 15, 1 },
	{ "UnExpCpl", 16, 1 },
	{ "RcvrOFlow", 17, 1 },
	{ "MalTLP", 18, 1 },
	{ "ECRCErr", 19, 1 },
	{ "UnSupReqErr", 20, 1 },
	{ "ACSViol", 21, 1 },
	{ "UnIntErr", 22, 1 },
	{ "MCBlockTLP", 23, 1 },
	{ "AtomicOPEgBlock", 24, 1 },
	{ "TLPPrBlockErr", 25, 1 },
	{ "Rsvd3", 26, 6 },
	{ "PCIE_AER_UNCOR_ERR_SEV", 0x10c, 0 },
	{ "Rsvd1", 0, 4 },
	{ "DLLProtErr", 4, 1 },
	{ "SurpriseDnErr", 5, 1 },
	{ "Rsvd2", 6, 6 },
	{ "PsndTLP", 12, 1 },
	{ "FlowCtlProtErr", 13, 1 },
	{ "ComplTO", 14, 1 },
	{ "ComplAbort", 15, 1 },
	{ "UnExpCpl", 16, 1 },
	{ "RcvrOFlow", 17, 1 },
	{ "MalTLP", 18, 1 },
	{ "ECRCErr", 19, 1 },
	{ "UnSupReqErr", 20, 1 },
	{ "ACSViol", 21, 1 },
	{ "UnIntErr", 22, 1 },
	{ "MCBlockTLP", 23, 1 },
	{ "AtomicOPEgBlock", 24, 1 },
	{ "TLPPrBlockErr", 25, 1 },
	{ "Rsvd3", 26, 6 },
	{ "PCIE_AER_COR_ERR_STAT", 0x110, 0 },
	{ "RcvrErr", 0, 1 },
	{ "Rsvd1", 1, 5 },
	{ "BadTLP", 6, 1 },
	{ "BadDLLP", 7, 1 },
	{ "RplNumRollOver", 8, 1 },
	{ "Rsvd2", 9, 3 },
	{ "RplTimerTO", 12, 1 },
	{ "AdvNonFatErr", 13, 1 },
	{ "CorIntErr", 14, 1 },
	{ "HdrLogOFl", 15, 1 },
	{ "Rsvd3", 16, 16 },
	{ "PCIE_AER_COR_ERR_MASK", 0x114, 0 },
	{ "RcvrErr", 0, 1 },
	{ "Rsvd1", 1, 5 },
	{ "BadTLP", 6, 1 },
	{ "BadDLLP", 7, 1 },
	{ "RplNumRollOver", 8, 1 },
	{ "RplNumRollOver", 9, 3 },
	{ "RplTimerTO", 12, 1 },
	{ "AdvNonFatErr", 13, 1 },
	{ "CorIntErr", 14, 1 },
	{ "HdrLogOFl", 15, 1 },
	{ "Rsvd3", 16, 16 },
	{ "PCIE_AER_CAP_CNTL", 0x118, 0 },
	{ "FirstErrPtr", 0, 5 },
	{ "ECRCGenCap", 5, 1 },
	{ "ECRCGenEn", 6, 1 },
	{ "ECRCChkCap", 7, 1 },
	{ "ECRCChkEn", 8, 1 },
	{ "MultHdrRecCap", 9, 1 },
	{ "MultHdrRecEn", 10, 1 },
	{ "TLPPrLog", 11, 1 },
	{ "Rsvd", 12, 20 },
	{ "CIE_AER_HDR_LOG1", 0x11c, 0 },
	{ "Hdr1DW", 0, 32 },
	{ "CIE_AER_HDR_LOG2", 0x120, 0 },
	{ "Hdr2DW", 0, 32 },
	{ "CIE_AER_HDR_LOG3", 0x124, 0 },
	{ "Hdr3DW", 0, 32 },
	{ "CIE_AER_HDR_LOG4", 0x128, 0 },
	{ "Hdr4DW", 0, 32 },
	{ "PCIE_MFVC_CAP", 0x140, 0 },
	{ "MFVCCapID", 0, 16 },
	{ "MFVCCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_MFVC_PORT_VC_CAP1", 0x144, 0 },
	{ "ExtVCCount", 0, 3 },
	{ "Rsvd1", 3, 1 },
	{ "LPExtVCCount", 4, 3 },
	{ "Rsvd2", 7, 1 },
	{ "RefClk", 8, 2 },
	{ "PortArbTblSz", 10, 2 },
	{ "Rsvd3", 12, 20 },
	{ "PCIE_MFVC_PORT_VC_CAP2", 0x148, 0 },
	{ "LoadVCArbTbl", 0, 1 },
	{ "VCArbSel", 1, 3 },
	{ "Rsvd1", 4, 12 },
	{ "PortVCArbStat", 16, 1 },
	{ "Rsvd2", 17, 15 },
	{ "PCIE_MFVC_VC0_RES_CAP", 0x150, 0 },
	{ "PortArbCap", 0, 8 },
	{ "Rsvd1", 8, 7 },
	{ "RejectSnoopTxns", 15, 1 },
	{ "MaxTimeSlots", 16, 7 },
	{ "Rsvd2", 23, 1 },
	{ "PortArbTblOfst", 24, 8 },
	{ "PCIE_MFVC_VC0_RES_CNTL", 0x154, 0 },
	{ "TCVCMapBit0", 0, 1 },
	{ "TCVCMap", 1, 7 },
	{ "Rsvd1", 8, 8 },
	{ "LoadPortArbTbl", 16, 1 },
	{ "PortArbSel", 17, 3 },
	{ "Rsvd2", 20, 4 },
	{ "VCID", 24, 3 },
	{ "Rsvd3", 27, 4 },
	{ "VCEnable", 31, 1 },
	{ "PCIE_MFVC_VC0_RES_STAT", 0x158, 0 },
	{ "Rsvd1", 0, 16 },
	{ "PortArbTblStat", 16, 1 },
	{ "VC0NegPnd", 17, 1 },
	{ "Rsvd2", 18, 14 },
	{ "PCIE_MFVC_VC1_RES_CAP", 0x15c, 0 },
	{ "PortArbCap", 0, 8 },
	{ "Rsvd1", 8, 7 },
	{ "RejectSnoopTxns", 15, 1 },
	{ "MaxTimeSlots", 16, 7 },
	{ "Rsvd2", 23, 1 },
	{ "PortArbTblOfst", 24, 8 },
	{ "PCIE_MFVC_VC1_RES_CNTL", 0x160, 0 },
	{ "TCVCMap", 0, 8 },
	{ "Rsvd1", 8, 8 },
	{ "LoadPortArbTbl", 16, 1 },
	{ "PortArbSel", 17, 3 },
	{ "Rsvd2", 20, 4 },
	{ "VCID", 24, 3 },
	{ "Rsvd3", 27, 4 },
	{ "VCEnable", 31, 1 },
	{ "PCIE_MFVC_VC1_RES_STAT", 0x164, 0 },
	{ "Rsvd1", 0, 16 },
	{ "PortArbTblStat", 16, 1 },
	{ "VC1NegPnd", 17, 1 },
	{ "Rsvd2", 18, 14 },
	{ "PCIE_DSN_CAP", 0x170, 0 },
	{ "DSNCapID", 0, 16 },
	{ "DSNCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_DSN_DW1", 0x174, 0 },
	{ "DSN1Dw", 0, 32 },
	{ "PCIE_DSN_DW2", 0x178, 0 },
	{ "DSN2Dw", 0, 32 },
	{ "PCIE_PB_CAP_HDR", 0x180, 0 },
	{ "PBCapID", 0, 16 },
	{ "PBCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_PB_DATA_SEL", 0x184, 0 },
	{ "DataSelReg", 0, 8 },
	{ "Rsvd", 8, 24 },
	{ "PCIE_PB_DATA_REG", 0x188, 0 },
	{ "BasePower", 0, 8 },
	{ "DataScale", 8, 2 },
	{ "PMSubState", 10, 3 },
	{ "PMState", 13, 2 },
	{ "Type", 15, 3 },
	{ "PowerRail", 18, 3 },
	{ "Rsvd", 21, 11 },
	{ "PCIE_PB_CAP_REG", 0x18c, 0 },
	{ "SysAlloc", 0, 1 },
	{ "Rsvd", 1, 31 },
	{ "PCIE_ARI_CAP_HDR", 0x190, 0 },
	{ "ARICapID", 0, 16 },
	{ "ARICapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_ARI_CAP_CNTL", 0x194, 0 },
	{ "MFVCFnGrpCap", 0, 1 },
	{ "ACSFnGrpCap", 1, 1 },
	{ "Rsvd1", 2, 6 },
	{ "NextFnNum", 8, 8 },
	{ "MFVCFnGrpEn", 16, 1 },
	{ "ACSFnGrpEn", 17, 1 },
	{ "Rsvd2", 18, 2 },
	{ "FnGrp", 20, 3 },
	{ "Rsvd3", 23, 9 },
	{ "PCIE_SEC_PCIE_EXTENDED_CAP_HDR", 0x1a0, 0 },
	{ "PCIeExtCapID", 0, 16 },
	{ "PCIeExtCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_LINK_CNTL3", 0x1a4, 0 },
	{ "PerfEql", 0, 1 },
	{ "LinkEqlReqIntEn", 1, 1 },
	{ "Rsvd", 2, 30 },
	{ "PCIE_LANE_ERR_STAT", 0x1a8, 0 },
	{ "LaneErrStat", 0, 8 },
	{ "Rsvd", 8, 24 },
	{ "PCIE_LANE_EQL_CNTL0", 0x1ac, 0 },
	{ "Ln0DnPrtXmtrPrst", 0, 4 },
	{ "Ln0DnPrtRcvrPrst", 4, 3 },
	{ "Ln0UpPrtXmtrPrst", 8, 4 },
	{ "Ln0UpPrtRcvrPrst", 12, 3 },
	{ "Ln1DnPrtXmtrPrst", 16, 4 },
	{ "Ln1DnPrtRcvrPrst", 20, 3 },
	{ "Ln1UpPrtXmtrPrst", 24, 4 },
	{ "Ln1UpPrtRcvrPrst", 28, 3 },
	{ "PCIE_LANE_EQL_CNTL1", 0x1b0, 0 },
	{ "Ln2DnPrtXmtrPrst", 0, 4 },
	{ "Ln2DnPrtRcvrPrst", 4, 3 },
	{ "Ln2UpPrtXmtrPrst", 8, 4 },
	{ "Ln2UpPrtRcvrPrst", 12, 3 },
	{ "Ln3DnPrtXmtrPrst", 16, 4 },
	{ "Ln3DnPrtRcvrPrst", 20, 3 },
	{ "Ln3UpPrtXmtrPrst", 24, 4 },
	{ "Ln3UpPrtRcvrPrst", 28, 3 },
	{ "PCIE_LANE_EQL_CNTL2", 0x1b4, 0 },
	{ "Ln4DnPrtXmtrPrst", 0, 4 },
	{ "Ln4DnPrtRcvrPrst", 4, 3 },
	{ "Ln4UpPrtXmtrPrst", 8, 4 },
	{ "Ln4UpPrtRcvrPrst", 12, 3 },
	{ "Ln5DnPrtXmtrPrst", 16, 4 },
	{ "Ln5DnPrtRcvrPrst", 20, 3 },
	{ "Ln5UpPrtXmtrPrst", 24, 4 },
	{ "Ln5UpPrtRcvrPrst", 28, 3 },
	{"PCIE_LANE_EQL_CNTL3", 0x1b8, 0 },
	{ "Ln6DnPrtXmtrPrst", 0, 4 },
	{ "Ln6DnPrtRcvrPrst", 4, 3 },
	{ "Ln6UpPrtXmtrPrst", 8, 4 },
	{ "Ln6UpPrtRcvrPrst", 12, 3 },
	{ "Ln7DnPrtXmtrPrst", 16, 4 },
	{ "Ln7DnPrtRcvrPrst", 20, 3 },
	{ "Ln7UpPrtXmtrPrst", 24, 4 },
	{ "Ln7UpPrtRcvrPrst", 28, 3 },
	{ "PCIE_SR_CAP_HDR", 0x1c0, 0 },
	{ "SRIOVCapID", 0, 16 },
	{ "SRIOVCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_SR_CAP Register", 0x1c4, 0 },
	{ "VFMigCap", 0, 1 },
	{ "ARICapHierPrsrvd", 1, 1 },
	{ "Rsvd", 2, 19 },
	{ "VFMigIntMsgNum", 21, 11 },
	{ "PCIE_SR_STAT_CNTL", 0x1c8, 0 },
	{ "VFEn", 0, 1 },
	{ "VFMigEn", 1, 1 },
	{ "VFMigIntEn", 2, 1 },
	{ "VFMSE", 3, 1 },
	{ "ARICapHier", 4, 1 },
	{ "Rsvd1", 5, 11 },
	{ "VFMigStatus", 16, 1 },
	{ "Rsvd2", 17, 15 },
	{ "PCIE_SR_INIT_TOT_VFS", 0x1cc, 0 },
	{ "InitVFs", 0, 16 },
	{ "TotVFs", 16, 16 },
	{ "PCIE_SR_NUMVFS_FUNCDEPLINK", 0x1d0, 0 },
	{ "NumVFs", 0, 16 },
	{ "FuncDepLink", 16, 8 },
	{ "PCIE_SR_VF_OFST_STRIDE", 0x1d4 },
	{ "FirstVFOfst", 0, 16 },
	{ "VFStride", 16, 16 },
	{ "PCIE_SR_VF_DEVID", 0x1d8, 0 },
	{ "Rsvd", 0, 16 },
	{ "VFDevID",  16, 16 },
	{ "PCIE_SR_SUPP_PAGE_SIZES", 0x1dc, 0 },
	{ "SuppPageSzs", 0, 32 },
	{ "PCIE_SR_SYS_PAGE_SIZE", 0x1e0 },
	{ "SysPageSz", 0, 32 },
	{ "PCIE_SR_VFBAR0", 0x1e4, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Rsvd", 3, 9 },
	{ "BaseAddress", 12, 20 },
	{ "PCIE_SR_VFBAR1", 0x1e8, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Rsvd", 3, 9 },
	{ "BaseAddress", 12, 20 },
	{ "PCIE_SR_VFBAR2", 0x1ec, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Rsvd", 3, 9 },
	{ "BaseAddress", 12, 20 },
	{ "PCIE_SR_VFBAR3", 0x1f0, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Rsvd", 3, 9 },
	{ "BaseAddress", 12, 20 },
	{ "PCIE_SR_VFBAR4", 0x1f4, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Rsvd", 3, 9 },
	{ "BaseAddress", 12, 20 },
	{ "PCIE_SR_VFBAR5", 0x1f8, 0 },
	{ "MemSpaceInd", 0, 1 },
	{ "Type", 1, 2 },
	{ "Rsvd", 3, 9 },
	{ "BaseAddress", 12, 20 },
	{ "PCIE_SR_MIG_STATE_ARRAY_OFST", 0x1fc, 0 },
	{ "Rsvd", 0, 32 },
	{ "PCIE_TPH_CAP_HDR", 0x200, 0 },
	{ "TPHCap", 0, 16 },
	{ "TPHCapVer", 16, 4 },
	{ "NextCapPtr", 20, 12 },
	{ "PCIE_TPH_REQ_CAP", 0x204, 0 },
	{ "NoSTModeSup", 0, 1 },
	{ "IntVecModeSup", 1, 1 },
	{ "DevSpModeSup", 2, 1 },
	{ "ExtTPHReqSup", 8, 1 },
	{ "STTblLoc", 9, 2 },
	{ "STTblSize", 16, 11 },
	{ "PCIE_TPH_REQ_CNTL", 0x208, 0 },
	{ "STModeSel", 0, 3 },
	{ "TPHRqstEn", 8, 1 },
	{ "ExtTPHRqstEn", 9, 1 },
	{ NULL }
};

static struct cudbg_reg_info t5_pm_tx_regs_10021_to_1003c[] = {
	{ "PM_TX_FEATURE_EN", 0x10021, 0 },
	{ "pio_ch_deficit_ctl_en", 2, 1 },
	{ "pio_wrr_based_prftch_en", 1, 1 },
	{ "prftch_across_bndle_en", 0, 1 },
	{ "PM_TX_T5_PM_TX_INT_ENABLE", 0x10022, 0 },
	{ "ospi_overflow3", 7, 1 },
	{ "ospi_overflow2", 6, 1 },
	{ "ospi_overflow1", 5, 1 },
	{ "ospi_overflow0", 4, 1 },
	{ "M_IntfPerrEn", 3, 1 },
	{ "bundle_len_ParErr_en", 2, 1 },
	{ "bundle_len_ovfl_en", 1, 1 },
	{ "sdc_err_en", 0, 1 },
	{ "PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD0", 0x10023, 0 },
	{ "pio_wrr_wait_cnt_thrshld0", 0, 32 },
	{ "PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD1", 0x10024, 0 },
	{ "pio_wrr_wait_cnt_thrshld1", 0, 32 },
	{ "PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD2", 0x10025, 0 },
	{ "pio_wrr_wait_cnt_thrshld2", 0, 32 },
	{ "PM_TX_PRFTCH_WRR_WAIT_CNT_THRSHLD3", 0x10026, 0 },
	{ "pio_wrr_wait_cnt_thrshld3", 0, 32 },
	{ "PM_TX_CH0_OSPI_DEFICIT_THRSHLD", 0x10027, 0 },
	{ "CH0_OSPI_DEFICIT_THRSHLD", 0, 12 },
	{ "PM_TX_CH1_OSPI_DEFICIT_THRSHLD", 0x10028, 0 },
	{ "CH1_OSPI_DEFICIT_THRSHLD", 0, 12 },
	{ "PM_TX_CH2_OSPI_DEFICIT_THRSHLD", 0x10029, 0 },
	{ "CH2_OSPI_DEFICIT_THRSHLD", 0, 12 },
	{ "PM_TX_CH3_OSPI_DEFICIT_THRSHLD", 0x1002a, 0 },
	{ "CH3_OSPI_DEFICIT_THRSHLD", 0, 12 },
	{ "PM_TX_INT_CAUSE_MASK_HALT", 0x1002b, 0 },
	{ "INT_CAUSE_MASK", 0, 32 },
	{ "PM_TX_DBG_STAT0", 0x1002c, 0 },
	{ "rd_i_busy", 29, 1 },
	{ "wr_o_busy", 28, 1 },
	{ "m_to_o_busy", 27, 1 },
	{ "i_to_m_busy", 26, 1 },
	{ "pcmd_fb_only", 25, 1 },
	{ "pcmd_mem", 24, 1 },
	{ "pcmd_bypass", 23, 1 },
	{ "pcmd_eop2", 22, 1 },
	{ "pcmd_eop", 21, 1 },
	{ "pcmd_end_bundle", 20, 1 },
	{ "pcmd_fb_cmd", 16, 4 },
	{ "cur_pcmd_len", 0, 16 },
	{ "PM_TX_DBG_STAT1", 0x1002d, 0 },
	{ "pcmd_mem0", 31, 1 },
	{ "free_oespi_cnt0", 19, 12 },
	{ "pcmd_flit_len0", 7, 12 },
	{ "pcmd_cmd0", 3, 4 },
	{ "ofifo_full0", 2, 1 },
	{ "gcsum_drdy0", 1, 1 },
	{ "Bypass0", 0, 1 },
	{ "PM_TX_DBG_STAT2", 0x1002e, 0 },
	{ "pcmd_mem1", 31, 1 },
	{ "free_oespi_cnt1", 19, 12 },
	{ "pcmd_flit_len1", 7, 12 },
	{ "pcmd_cmd1", 3, 4 },
	{ "ofifo_full1", 2, 1 },
	{ "gcsum_drdy1", 1, 1 },
	{ "Bypass1", 0, 1 },
	{ "PM_TX_DBG_STAT3", 0x1002f, 0 },
	{ "pcmd_mem2", 31, 1 },
	{ "free_oespi_cnt2", 19, 12 },
	{ "pcmd_flit_len2", 7, 12 },
	{ "pcmd_cmd2", 3, 4 },
	{ "ofifo_full2", 2, 1 },
	{ "gcsum_drdy2", 1, 1 },
	{ "Bypass2", 0, 1 },
	{ "PM_TX_DBG_STAT4", 0x10030, 0 },
	{ "pcmd_mem3", 31, 1 },
	{ "free_oespi_cnt3", 19, 12 },
	{ "pcmd_flit_len3", 7, 12 },
	{ "pcmd_cmd3", 3, 4 },
	{ "ofifo_full3", 2, 1 },
	{ "gcsum_drdy3", 1, 1 },
	{ "Bypass3", 0, 1 },
	{ "PM_TX_DBG_STAT5", 0x10031, 0 },
	{ "set_pcmd_res_rdy_rd", 24, 4 },
	{ "issued_pref_rd_er_clr", 20, 4 },
	{ "issued_pref_rd", 16, 4},
	{ "pcmd_res_rdy", 12, 4 },
	{ "db_vld", 11, 1 },
	{ "inject0_drdy", 10, 1 },
	{ "inject1_drdy", 9, 1 },
	{ "first_bundle", 5, 4 },
	{ "gcsum_more_than_2_left", 1, 5 },
	{ "sdc_drdy", 0, 1 },
	{ "PM_TX_DBG_STAT6", 0x10032, 0 },
	{ "pcmd_vld", 31, 1 },
	{ "pcmd_ch", 29, 2 },
	{ "state_machine_loc", 24, 4 },
	{ "icspi_TxValid", 20, 4 },
	{ "icspi_TxFull", 16, 4 },
	{ "PCMD_srdy", 12, 4 },
	{ "PCMD_drdy", 8, 4 },
	{ "pcmd_cmd", 4, 4 },
	{ "oefifo_full3", 3, 1 },
	{ "oefifo_full2", 2, 1 },
	{ "oefifo_full1", 1, 1 },
	{ "oefifo_full0", 0, 1 },
	{ "PM_TX_DBG_STAT7", 0x10033, 0 },
	{ "icspi_RxValid", 28, 4 },
	{ "icspi_RxFull", 24, 4 },
	{ "oespi_valid", 20, 4 },
	{ "oespi_full", 16, 4 },
	{ "C_RxValid", 12, 4 },
	{ "C_RxAFull", 8, 4 },
	{ "E_TxValid3", 7, 1 },
	{ "E_TxValid2", 6, 1 },
	{ "E_TxValid1", 5, 1 },
	{ "E_TxValid0", 4, 1 },
	{ "E_TxFull3", 3, 1 },
	{ "E_TxFull2", 2, 1 },
	{ "E_TxFull1", 1, 1 },
	{ "E_TxFull0", 0, 1 },
	{ "PM_TX_DBG_STAT8", 0x10034, 0 },
	{ "mc_rsp_fifo_cnt", 24, 2 },
	{ "pcmd_free_cnt0", 14, 10 },
	{ "pcmd_free_cnt1", 4, 10 },
	{ "M_ReqAddrRdy", 3, 1 },
	{ "M_ReqWrite", 2, 1 },
	{ "M_ReqDataVld", 1, 1 },
	{ "M_ReqDataRdy", 0, 1 },
	{ "PM_TX_DBG_STAT9", 0x10035, 0 },
	{ "pcmd_free_cnt2", 10, 10 },
	{ "pcmd_free_cnt3", 0, 10 },
	{ "PM_TX_DBG_STAT10", 0x10036, 0 },
	{ "In_Eop_Cnt3", 28, 4 },
	{ "In_Eop_Cnt2", 24, 4 },
	{ "In_Eop_Cnt1", 20, 4 },
	{ "In_Eop_Cnt0", 16, 4 },
	{ "In_Sop_Cnt3", 12, 4 },
	{ "In_Sop_Cnt2", 8, 4 },
	{ "In_Sop_Cnt1", 4, 4 },
	{ "In_Sop_Cnt0", 0, 4 },
	{ "PM_TX_DBG_STAT11", 0x10037, 0 },
	{ "Out_Eop_Cnt3", 28, 4 },
	{ "Out_Eop_Cnt2", 24, 4 },
	{ "Out_Eop_Cnt1", 20, 4 },
	{ "Out_Eop_Cnt0", 16, 4 },
	{ "Out_Sop_Cnt3", 12, 4 },
	{ "Out_Sop_Cnt2", 8, 4 },
	{ "Out_Sop_Cnt1", 4, 4 },
	{ "Out_Sop_Cnt0", 0, 4 },
	{ "PM_TX_DBG_STAT12", 0x10038, 0 },
	{ "dbg_stat12", 0, 32 },
	{ "PM_TX_DBG_STAT13", 0x10039, 0 },
	{ "ch_deficit_blowed", 31, 1 },
	{ "rsvd_13_1", 28, 3 },
	{ "ch1_deficit", 16, 12},
	{ "rsvd_13", 12, 4 },
	{ "ch0_deficit", 0, 12 },
	{ "PM_TX_DBG_STAT14", 0x1003a, 0 },
	{ "rsvd_14_1", 28, 4 },
	{ "ch3_deficit", 16, 12 },
	{ "rsvd_14", 12, 4 },
	{ "ch2_deficit", 0, 12 },
	{ "PM_TX_DBG_STAT15", 0x1003b, 0 },
	{ "bundle_len_srdy", 28, 4 },
	{ "bundle_len1", 16, 12 },
	{ "rsvd_15", 12, 4 },
	{ "bundle_len0", 0, 12 },
	{ "PM_TX_DBG_STAT16", 0x1003c, 0 },
	{ "rsvd_16_1", 28, 4 },
	{ "bundle_len3", 16, 12 },
	{ "rsvd_16", 12, 4 },
	{ "bundle_len2", 0, 12 },
	{ NULL }
};

static struct cudbg_cntxt_field t6_egress_cntxt[] = {
	{ "DCA_ST:", 181, 191, 0, 0 },
	{ "StatusPgNS:", 180, 180, 0, 0 },
	{ "StatusPgRO:", 179, 179, 0, 0 },
	{ "FetchNS:", 178, 178, 0, 0 },
	{ "FetchRO:", 177, 177, 0, 0 },
	{ "Valid:", 176, 176, 0, 0 },
	{ "ReschedulePending_1:", 175, 175, 0, 0 },
	{ "PCIeDataChannel:", 174, 174, 0, 0 },
	{ "StatusPgTPHintEn:", 173, 173, 0, 0 },
	{ "StatusPgTPHint:", 171, 172, 0, 0 },
	{ "FetchTPHintEn:", 170, 170, 0, 0 },
	{ "FetchTPHint:", 168, 169, 0, 0 },
	{ "FCThreshOverride:", 167, 167, 0, 0 },
	{ "WRLength:", 162, 166, 0, 0 },
	{ "WRLengthKnown:", 161, 161, 9, 1 },
	{ "ReschedulePending:", 160, 160, 0, 0 },
	{ "TimerIx:", 157, 159, 0, 0 },
	{ "FetchBurstMin:", 156, 157, 4, 1},
	{ "FLMPacking:", 155, 155, 0, 0 },
	{ "FetchBurstMax:", 153, 154, 0, 0 },
	{ "uPToken:", 133, 152, 0, 0 },
	{ "uPTokenEn:", 132, 132, 0, 0 },
	{ "UserModeIO:", 131, 131, 0, 0 },
	{ "uPFLCredits:", 123, 130, 0, 0 },
	{ "uPFLCreditEn:", 122, 122, 0, 0 },
	{ "FID:", 111, 121, 0, 0 },
	{ "HostFCMode:", 109, 110, 0, 0 },
	{ "HostFCOwner:", 108, 108, 0, 0 },
	{ "CIDXFlushThresh:", 105, 107, 0, 1 },
	{ "CIDX:", 89, 104, 0, 0 },
	{ "PIDX:", 73, 88, 0, 0 },
	{ "BaseAddress:", 18, 72, 9, 0 },
	{ "QueueSize:", 2, 17, 0, 0 },
	{ "QueueType:", 1, 1, 0, 0 },
	{ "CachePriority:", 0, 0, 0 },
	{ NULL }
};

static struct cudbg_cntxt_field t5_egress_cntxt[] = {
	{ "DCA_ST:", 181, 191, 0, 0 },
	{ "StatusPgNS:", 180, 180, 0, 0 },
	{ "StatusPgRO:", 179, 179, 0, 0 },
	{ "FetchNS:", 178, 178, 0, 0 },
	{ "FetchRO:", 177, 177, 0, 0 },
	{ "Valid:", 176, 176, 0, 0 },
	{ "PCIeDataChannel:", 174, 175, 0, 0 },
	{ "StatusPgTPHintEn:", 173, 173, 0, 0 },
	{ "StatusPgTPHint:", 171, 172, 0, 0 },
	{ "FetchTPHintEn:", 170, 170, 0, 0 },
	{ "FetchTPHint:", 168, 169, 0, 0 },
	{ "FCThreshOverride:", 167, 167, 0, 0 },
	{ "WRLength:", 162, 166, 0, 0 },
	{ "WRLengthKnown:", 161, 161, 9, 1 },
	{ "ReschedulePending:", 160, 160, 0, 0 },
	{ "OnChipQueue:", 159, 159, 0, 0 },
	{ "FetchSizeMode:", 158, 158, 0, 0 },
	{ "FetchBurstMin:", 156, 157, 4, 1},
	{ "FLMPacking:", 155, 155, 0, 0 },
	{ "FetchBurstMax:", 153, 154, 0, 0 },
	{ "uPToken:", 133, 152, 0, 0 },
	{ "uPTokenEn:", 132, 132, 0, 0 },
	{ "UserModeIO:", 131, 131, 0, 0 },
	{ "uPFLCredits:", 123, 130, 0, 0 },
	{ "uPFLCreditEn:", 122, 122, 0, 0 },
	{ "FID:", 111, 121, 0, 0 },
	{ "HostFCMode:", 109, 110, 0, 0 },
	{ "HostFCOwner:", 108, 108, 0, 0 },
	{ "CIDXFlushThresh:", 105, 107, 0, 1 },
	{ "CIDX:", 89, 104, 0, 0 },
	{ "PIDX:", 73, 88, 0, 0 },
	{ "BaseAddress:", 18, 72, 9, 0 },
	{ "QueueSize:", 2, 17, 0, 0 },
	{ "QueueType:", 1, 1, 0, 0 },
	{ "CachePriority:", 0, 0, 0 },
	{ NULL }
};

static struct cudbg_cntxt_field t6_ingress_cntxt[] = {
	{ "SP_NS:", 158, 158 },
	{ "SP_RO:", 157, 157 },
	{ "SP_TPHintEn:", 156, 156 },
	{ "SP_TPHint:", 154, 155 },
	{ "DCA_ST:", 143, 153 },
	{ "ISCSICoalescing:", 142, 142 },
	{ "Queue_Valid:", 141, 141 },
	{ "TimerPending:", 140, 140 },
	{ "DropRSS:", 139, 139 },
	{ "PCIeChannel:", 137, 138 },
	{ "SEInterruptArmed:", 136, 136 },
	{ "CongestionMgtEnable:", 135, 135 },
	{ "NoSnoop:", 134, 134 },
	{ "RelaxedOrdering:", 133, 133 },
	{ "GTSmode:", 132, 132 },
	{ "TPHintEn:", 131, 131 },
	{ "TPHint:", 129, 130 },
	{ "UpdateScheduling:", 128, 128 },
	{ "UpdateDelivery:", 126, 127 },
	{ "InterruptSent:", 125, 125 },
	{ "InterruptIDX:", 114, 124 },
	{ "InterruptDestination:", 113, 113 },
	{ "InterruptArmed:", 112, 112 },
	{ "RxIntCounter:", 106, 111 },
	{ "RxIntCounterThreshold:", 104, 105 },
	{ "Generation:", 103, 103 },
	{ "BaseAddress:", 48, 102, 9, 0 },
	{ "PIDX:", 32, 47 },
	{ "CIDX:", 16, 31 },
	{ "QueueSize:", 4, 15, 4, 0 },
	{ "QueueEntrySize:", 2, 3, 4, 1 },
	{ "QueueEntryOverride:", 1, 1 },
	{ "CachePriority:", 0, 0 },
	{ NULL }
};

static struct cudbg_cntxt_field t5_ingress_cntxt[] = {
	{ "DCA_ST:", 143, 153 },
	{ "ISCSICoalescing:", 142, 142 },
	{ "Queue_Valid:", 141, 141 },
	{ "TimerPending:", 140, 140 },
	{ "DropRSS:", 139, 139 },
	{ "PCIeChannel:", 137, 138 },
	{ "SEInterruptArmed:", 136, 136 },
	{ "CongestionMgtEnable:", 135, 135 },
	{ "NoSnoop:", 134, 134 },
	{ "RelaxedOrdering:", 133, 133 },
	{ "GTSmode:", 132, 132 },
	{ "TPHintEn:", 131, 131 },
	{ "TPHint:", 129, 130 },
	{ "UpdateScheduling:", 128, 128 },
	{ "UpdateDelivery:", 126, 127 },
	{ "InterruptSent:", 125, 125 },
	{ "InterruptIDX:", 114, 124 },
	{ "InterruptDestination:", 113, 113 },
	{ "InterruptArmed:", 112, 112 },
	{ "RxIntCounter:", 106, 111 },
	{ "RxIntCounterThreshold:", 104, 105 },
	{ "Generation:", 103, 103 },
	{ "BaseAddress:", 48, 102, 9, 0 },
	{ "PIDX:", 32, 47 },
	{ "CIDX:", 16, 31 },
	{ "QueueSize:", 4, 15, 4, 0 },
	{ "QueueEntrySize:", 2, 3, 4, 1 },
	{ "QueueEntryOverride:", 1, 1 },
	{ "CachePriority:", 0, 0 },
	{ NULL }
};

static struct cudbg_cntxt_field t5_cnm_cntxt[] = {
	{ "CngMPSEnable:", 21, 21 },
	{ "CngTPMode:", 19, 20 },
	{ "CngDBPHdr:", 18, 18 },
	{ "CngDBPData:", 17, 17 },
	{ "CngIMSG:", 16, 16 },
	{ "CngChMap:", 0, 15, 0, 0 },
	{ NULL }
};

static struct cudbg_cntxt_field t6_flm_cntxt[] = {
	{ "Valid:", 89, 89 },
	{ "SplitLenMode:", 87, 88 },
	{ "TPHintEn:", 86, 86 },
	{ "TPHint:", 84, 85 },
	{ "NoSnoop:", 83, 83 },
	{ "RelaxedOrdering:", 82, 82 },
	{ "DCA_ST:", 71, 81 },
	{ "EQid:", 54, 70 },
	{ "SplitEn:", 52, 53 },
	{ "PadEn:", 51, 51 },
	{ "PackEn:", 50, 50 },
	{ "Cache_Lock :", 49, 49 },
	{ "CongDrop:", 48, 48 },
	{ "Inflifght:", 47, 47 },
	{ "CongEn:", 46, 46 },
	{ "CongMode:", 45, 45 },
	{ "PackOffset:", 20, 39 },
	{ "CIDX:", 8, 15 },
	{ "PIDX:", 0, 7 },
	{ NULL }
};

static struct cudbg_cntxt_field t5_flm_cntxt[] = {
	{ "Valid:", 89, 89 },
	{ "SplitLenMode:", 87, 88 },
	{ "TPHintEn:", 86, 86 },
	{ "TPHint:", 84, 85 },
	{ "NoSnoop:", 83, 83 },
	{ "RelaxedOrdering:", 82, 82 },
	{ "DCA_ST:", 71, 81 },
	{ "EQid:", 54, 70 },
	{ "SplitEn:", 52, 53 },
	{ "PadEn:", 51, 51 },
	{ "PackEn:", 50, 50 },
	{ "Cache_Lock :", 49, 49 },
	{ "CongDrop:", 48, 48 },
	{ "PackOffset:", 16, 47 },
	{ "CIDX:", 8, 15 },
	{ "PIDX:", 0, 7 },
	{ NULL }
};

static struct cudbg_reg_info t6_hma_regs_a000_to_a01f[] = {
	{ "HMAT6_DEBUG_FSM_0", 0xa000, 0 },
	{ "edc_fsm", 18, 5 },
	{ "ras_fsm_slv", 15, 3 },
	{ "fc_fsm", 10, 5 },
	{ "cookie_arb_fsm", 8, 2 },
	{ "pcie_chunk_fsm", 6, 2 },
	{ "wtransfer_fsm", 4, 2 },
	{ "wd_fsm", 2, 2 },
	{ "rd_fsm", 0, 2 },
	{ "HMAT6_DEBUG_FSM_1", 0xa001, 0 },
	{ "sync_fsm", 11, 10 },
	{ "ochk_fsm", 9, 2 },
	{ "tlb_fsm", 5, 4 },
	{ "pio_fsm", 0, 5 },
	{ "HMAT6_DEBUG_PCIE_INTF", 0xa002, 0 },
	{ "H_ReqVld", 28, 1 },
	{ "H_ReqFull", 27, 1 },
	{ "H_ReqSOP", 26, 1 },
	{ "H_ReqEOP", 25, 1 },
	{ "H_RspVld", 24, 1 },
	{ "H_RspFull", 23, 1 },
	{ "H_RspSOP", 22, 1 },
	{ "H_RspEOP", 21, 1 },
	{ "H_RspErr", 20, 1 },
	{ "pcie_cmd_avail", 19, 1 },
	{ "pcie_cmd_rdy", 18, 1 },
	{ "pcie_wnr", 17, 1 },
	{ "pcie_len", 9, 8 },
	{ "pcie_trwdat_rdy", 8, 1 },
	{ "pcie_trwdat_avail", 7, 1 },
	{ "pcie_trwsop", 6, 1 },
	{ "pcie_trweop", 5, 1 },
	{ "pcie_trrdat_rdy", 4, 1 },
	{ "pcie_trrdat_avail", 3, 1 },
	{ "pcie_trrsop", 2, 1 },
	{ "pcie_trreop", 1, 1 },
	{ "pcie_trrerr", 0, 1 },
	{ "HMAT6_DEBUG_PCIE_ADDR_INTERNAL_LO", 0xa003, 0 },
	{ "pcie_addr_lo", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_ADDR_INTERNAL_HI", 0xa004, 0 },
	{ "pcie_addr_hi", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_REQ_DATA_EXTERNAL", 0xa005, 0 },
	{ "ReqData2", 24, 8 },
	{ "ReqData1", 21, 3 },
	{ "ReqData0", 0, 21 },
	{ "HMAT6_DEBUG_PCIE_RSP_DATA_EXTERNAL", 0xa006, 0 },
	{ "RspData3", 24, 8 },
	{ "RspData2", 16, 8 },
	{ "RspData1", 8, 8 },
	{ "RspData0", 0, 8 },
	{ "HMAT6_DEBUG_MA_SLV_CTL", 0xa007, 0 },
	{ "ma_cmd_avail", 19, 1 },
	{ "ma_clnt", 15, 4 },
	{ "ma_wnr", 14, 1 },
	{ "ma_len", 6, 8 },
	{ "ma_mst_rd", 5, 1 },
	{ "ma_mst_vld", 4, 1 },
	{ "ma_mst_err", 3, 1 },
	{ "mas_tlb_req", 2, 1 },
	{ "mas_tlb_ack", 1, 1 },
	{ "mas_tlb_err", 0, 1 },
	{ "HMAT6_DEBUG_MA_SLV_ADDR_INTERNAL", 0xa008, 0 },
	{ "ma_addr", 0, 32 },
	{ "HMAT6_DEBUG_TLB_HIT_ENTRY", 0xa009, 0 },
	{ "tlb_hit_entry", 0, 32 },
	{ "HMAT6_DEBUG_TLB_HIT_CNT", 0xa00a, 0 },
	{ "tlb_hit_cnt", 0, 32 },
	{ "HMAT6_DEBUG_TLB_MISS_CNT", 0xa00b, 0 },
	{ "tlb_miss_cnt", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_CTL", 0xa00c, 0 },
	{ "lkp_req_vld", 4, 1 },
	{ "lkp_desc_sel", 1, 4 },
	{ "lkp_rsp_vld", 0, 1 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_REQ_ADDR", 0xa00d, 0 },
	{ "lkp_req_addr", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_0", 0xa00e, 0 },
	{ "lkp_rsp_0", 0, 32, },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_1", 0xa00f, 0 },
	{ "lkp_rsp_1", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_2", 0xa010, 0 },
	{ "lkp_rsp_2", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_3", 0xa011, 0 },
	{ "lkp_rsp_3", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_4", 0xa012, 0 },
	{ "lkp_rsp_4", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_5", 0xa013, 0 },
	{ "lkp_rsp_5", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_6", 0xa014, 0 },
	{ "lkp_rsp_6", 0, 32 },
	{ "HMAT6_DEBUG_PAGE_TBL_LKP_RSP_7", 0xa015, 0 },
	{ "lkp_rsp_7", 0, 32 },
	{ "HMAT6_DEBUG_PHYS_DESC_INTERNAL_LO", 0xa016, 0 },
	{ "paddr_lo", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_RD_REQ_CNT_LO", 0xa017, 0 },
	{ "rd_req_cnt_lo", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_RD_REQ_CNT_HI", 0xa018, 0 },
	{ "rd_req_cnt_hi", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_WR_REQ_CNT_LO", 0xa019, 0 },
	{ "wr_req_cnt_lo", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_WR_REQ_CNT_HI", 0xa01a, 0 },
	{ "wr_req_cnt_hi", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_RD_DATA_CYC_CNT_LO", 0xa01b, 0 },
	{ "rd_data_cnt_lo", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_RD_DATA_CYC_CNT_HI", 0xa01c, 0 },
	{ "rd_data_cnt_hi", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_WR_DATA_CYC_CNT_LO", 0xa01d, 0 },
	{ "wr_data_cnt_lo", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_WR_DATA_CYC_CNT_HI", 0xa01e, 0 },
	{ "wr_data_cnt_hi", 0, 32 },
	{ "HMAT6_DEBUG_PCIE_SOP_EOP_CNT", 0xa01f, 0 },
	{ "wr_eop_cnt", 16, 8 },
	{ "rd_sop_cnt", 8, 8 },
	{ "rd_eop_cnt", 0, 8 },
	{ NULL }
};

static struct cudbg_reg_info t6_ma_regs_a000_to_a016[] = {
	{ "MA_SGE_THREAD_0_CLIENT_INTERFACE_EXTERNAL", 0xa000, 0 },
	{ "CmdVld0", 31, 1 },
	{ "CmdRdy0", 30, 1 },
	{ "CmdType0", 29, 1 },
	{ "CmdLen0", 21, 8 },
	{ "CmdAddr0", 8, 13 },
	{ "WrDataVld0", 7, 1 },
	{ "WrDataRdy0", 6, 1 },
	{ "RdDataRdy0", 5, 1 },
	{ "RdDataVld0", 4, 1 },
	{ "RdData0", 0, 4 },
	{ "MA_SGE_THREAD_1_CLIENT_INTERFACE_EXTERNAL", 0xa001, 0 },
	{ "CmdVld1", 31, 1 },
	{ "CmdRdy1", 30, 1 },
	{ "CmdType1", 29, 1 },
	{ "CmdLen1", 21, 8 },
	{ "CmdAddr1", 8, 13 },
	{ "WrDataVld1", 7, 1 },
	{ "WrDataRdy1", 6, 1 },
	{ "RdDataRdy1", 5, 1 },
	{ "RdDataVld1", 4, 1 },
	{ "RdData1", 0, 4 },
	{ "MA_ULP_TX_CLIENT_INTERFACE_EXTERNAL", 0xa002, 0 },
	{ "CmdVld2", 31, 1 },
	{ "CmdRdy2", 30, 1 },
	{ "CmdType2", 29, 1 },
	{ "CmdLen2", 21, 8 },
	{ "CmdAddr2", 8, 13 },
	{ "WrDataVld2", 7, 1 },
	{ "WrDataRdy2", 6, 1 },
	{ "RdDataRdy2", 5, 1 },
	{ "RdDataVld2", 4, 1 },
	{ "RdData2", 0, 4 },
	{ "MA_ULP_RX_CLIENT_INTERFACE_EXTERNAL", 0xa003, 0 },
	{ "CmdVld3", 31, 1 },
	{ "CmdRdy3", 30, 1 },
	{ "CmdType3", 29, 1 },
	{ "CmdLen3", 21, 8 },
	{ "CmdAddr3", 8, 13 },
	{ "WrDataVld3", 7, 1 },
	{ "WrDataRdy3", 6, 1 },
	{ "RdDataRdy3", 5, 1 },
	{ "RdDataVld3", 4, 1 },
	{ "RdData3", 0, 4 },
	{ "MA_ULP_TX_RX_CLIENT_INTERFACE_EXTERNAL", 0xa004, 0 },
	{ "CmdVld4", 31, 1 },
	{ "CmdRdy4", 30, 1 },
	{ "CmdType4", 29, 1 },
	{ "CmdLen4", 21, 8 },
	{ "CmdAddr4", 8, 13 },
	{ "WrDataVld4", 7, 1 },
	{ "WrDataRdy4", 6, 1 },
	{ "RdDataRdy4", 5, 1 },
	{ "RdDataVld4", 4, 1 },
	{ "RdData4", 0, 4 },
	{ "MA_TP_THREAD_0_CLIENT_INTERFACE_EXTERNAL", 0xa005, 0 },
	{ "CmdVld5", 31, 1 },
	{ "CmdRdy5", 30, 1 },
	{ "CmdType5", 29, 1 },
	{ "CmdLen5", 21, 8 },
	{ "CmdAddr5", 8, 13 },
	{ "WrDataVld5", 7, 1 },
	{ "WrDataRdy5", 6, 1 },
	{ "RdDataRdy5", 5, 1 },
	{ "RdDataVld5", 4, 1 },
	{ "RdData5", 0, 4 },
	{ "MA_TP_THREAD_1_CLIENT_INTERFACE_EXTERNAL", 0xa006, 0 },
	{ "CmdVld6", 31, 1 },
	{ "CmdRdy6", 30, 1 },
	{ "CmdType6", 29, 1 },
	{ "CmdLen6", 21, 8 },
	{ "CmdAddr6", 8, 13 },
	{ "WrDataVld6", 7, 1 },
	{ "WrDataRdy6", 6, 1 },
	{ "RdDataRdy6", 5, 1 },
	{ "RdDataVld6", 4, 1 },
	{ "RdData6", 0, 4 },
	{ "MA_LE_CLIENT_INTERFACE_EXTERNAL", 0xa007, 0 },
	{ "CmdVld7", 31, 1 },
	{ "CmdRdy7", 30, 1 },
	{ "CmdType7", 29, 1 },
	{ "CmdLen7", 21, 8 },
	{ "CmdAddr7", 8, 13 },
	{ "WrDataVld7", 7, 1 },
	{ "WrDataRdy7", 6, 1 },
	{ "RdDataRdy7", 5, 1 },
	{ "RdDataVld7", 4, 1 },
	{ "RdData7", 0, 4 },
	{ "MA_CIM_CLIENT_INTERFACE_EXTERNAL", 0xa008, 0 },
	{ "CmdVld8", 31, 1 },
	{ "CmdRdy8", 30, 1 },
	{ "CmdType8", 29, 1 },
	{ "CmdLen8", 21, 8 },
	{ "CmdAddr8", 8, 13 },
	{ "WrDataVld8", 7, 1 },
	{ "WrDataRdy8", 6, 1 },
	{ "RdDataRdy8", 5, 1 },
	{ "RdDataVld8", 4, 1 },
	{ "RdData8", 0, 4 },
	{ "MA_PCIE_CLIENT_INTERFACE_EXTERNAL", 0xa009, 0 },
	{ "CmdVld9", 31, 1 },
	{ "CmdRdy9", 30, 1 },
	{ "CmdType9", 29, 1 },
	{ "CmdLen9", 21, 8 },
	{ "CmdAddr9", 8, 13 },
	{ "WrDataVld9", 7, 1 },
	{ "WrDataRdy9", 6, 1 },
	{ "RdDataRdy9", 5, 1 },
	{ "RdDataVld9", 4, 1 },
	{ "RdData9", 0, 4 },
	{ "MA_PM_TX_CLIENT_INTERFACE_EXTERNAL", 0xa00a, 0 },
	{ "CmdVld10", 31, 1 },
	{ "CmdRdy10", 30, 1 },
	{ "CmdType10", 29, 1 },
	{ "CmdLen10", 21, 8 },
	{ "CmdAddr10", 8, 13 },
	{ "WrDataVld10", 7, 1 },
	{ "WrDataRdy10", 6, 1 },
	{ "RdDataRdy10", 5, 1 },
	{ "RdDataVld10", 4, 1 },
	{ "RdData10", 0, 4 },
	{ "MA_PM_RX_CLIENT_INTERFACE_EXTERNAL", 0xa00b, 0 },
	{ "CmdVld11", 31, 1 },
	{ "CmdRdy11", 30, 1 },
	{ "CmdType11", 29, 1 },
	{ "CmdLen11", 21, 8 },
	{ "CmdAddr11", 8, 13 },
	{ "WrDataVld11", 7, 1 },
	{ "WrDataRdy11", 6, 1 },
	{ "RdDataRdy11", 5, 1 },
	{ "RdDataVld11", 4, 1 },
	{ "RdData11", 0, 4 },
	{ "MA_HMA_CLIENT_INTERFACE_EXTERNAL", 0xa00c, 0 },
	{ "CmdVld12", 31, 1 },
	{ "CmdRdy12", 30, 1 },
	{ "CmdType12", 29, 1 },
	{ "CmdLen12", 21, 8 },
	{ "CmdAddr12", 8, 13 },
	{ "WrDataVld12", 7, 1 },
	{ "WrDataRdy12", 6, 1 },
	{ "RdDataRdy12", 5, 1 },
	{ "RdDataVld12", 4, 1 },
	{ "RdData12", 0, 4 },
	{ "MA_TARGET_0_ARBITER_INTERFACE_EXTERNAL_REG0", 0xa00d, 0 },
	{ "ci0_arb0_Req", 31, 1 },
	{ "arb0_ci0_Gnt", 30, 1 },
	{ "ci0_dm0_wdata_vld", 29, 1 },
	{ "dm0_ci0_rdata_vld", 28, 1 },
	{ "ci1_arb0_Req", 27, 1 },
	{ "arb0_ci1_Gnt", 26, 1 },
	{ "ci1_dm0_wdata_vld", 25, 1 },
	{ "dm0_ci1_rdata_vld", 24, 1 },
	{ "ci2_arb0_Req", 23, 1 },
	{ "arb0_ci2_Gnt", 22, 1 },
	{ "ci2_dm0_wdata_vld", 21, 1 },
	{ "dm0_ci2_rdata_vld", 20, 1 },
	{ "ci3_arb0_Req", 19, 1},
	{ "arb0_ci3_Gnt", 18, 1 },
	{ "ci3_dm0_wdata_vld", 17, 1 },
	{ "dm0_ci3_rdata_vld", 16, 1 },
	{ "ci4_arb0_Req", 15, 1 },
	{ "arb0_ci4_Gnt", 14, 1 },
	{ "ci4_dm0_wdata_vld", 13, 1 },
	{ "dm0_ci4_rdata_vld", 12, 1 },
	{ "ci5_arb0_Req", 11, 1 },
	{ "arb0_ci5_Gnt", 10, 1 },
	{ "ci5_dm0_wdata_vld", 9, 1 },
	{ "dm0_ci5_rdata_vld", 8, 1 },
	{ "ci6_arb0_Req", 7, 1 },
	{ "arb0_ci6_Gnt", 6, 1 },
	{ "ci6_dm0_wdata_vld", 5, 1 },
	{ "dm0_ci6_rdata_vld", 4, 1 },
	{ "ci7_arb0_Req", 3, 1 },
	{ "arb0_ci7_Gnt", 2, 1 },
	{ "ci7_dm0_wdata_vld", 1, 1},
	{ "dm0_ci7_rdata_vld", 0, 1 },
	{ "MA_TARGET_1_ARBITER_INTERFACE_EXTERNAL_REG0", 0xa00e, 0 },
	{ "ci0_arb1_Req", 31, 1 },
	{ "arb1_ci0_Gnt", 30, 1 },
	{ "ci0_dm1_wdata_vld", 29, 1 },
	{ "dm1_ci0_rdata_vld", 28, 1 },
	{ "ci1_arb1_Req", 27, 1 },
	{ "arb1_ci1_Gnt", 26, 1 },
	{ "ci1_dm1_wdata_vld", 25, 1 },
	{ "dm1_ci1_rdata_vld", 24, 1 },
	{ "ci2_arb1_Req", 23, 1 },
	{ "arb1_ci2_Gnt", 22, 1 },
	{ "ci2_dm1_wdata_vld", 21, 1 },
	{ "dm1_ci2_rdata_vld", 20, 1 },
	{ "ci3_arb1_Req", 19, 1 },
	{ "arb1_ci3_Gnt", 18, 1 },
	{ "ci3_dm1_wdata_vld", 17, 1 },
	{ "dm1_ci3_rdata_vld", 16, 1 },
	{ "ci4_arb1_Req", 15, 1 },
	{ "arb1_ci4_Gnt", 14, 1 },
	{ "ci4_dm1_wdata_vld", 13, 1 },
	{ "dm1_ci4_rdata_vld", 12, 1 },
	{ "ci5_arb1_Req", 11, 1 },
	{ "arb1_ci5_Gnt", 10, 1 },
	{ "ci5_dm1_wdata_vld", 9, 1 },
	{ "dm1_ci5_rdata_vld", 8, 1 },
	{ "ci6_arb1_Req", 7, 1 },
	{ "arb1_ci6_Gnt", 6, 1 },
	{ "ci6_dm1_wdata_vld", 5, 1 },
	{ "dm1_ci6_rdata_vld", 4, 1 },
	{ "ci7_arb1_Req", 3, 1 },
	{ "arb1_ci7_Gnt", 2, 1 },
	{ "ci7_dm1_wdata_vld", 1, 1 },
	{ "dm1_ci7_rdata_vld", 0, 1 },
	{ "MA_TARGET_2_ARBITER_INTERFACE_EXTERNAL_REG0", 0xa00f, 0 },
	{ "ci0_arb2_Req", 31, 1 },
	{ "arb2_ci0_Gnt", 30, 1 },
	{ "ci0_dm2_wdata_vld", 29, 1 },
	{ "dm2_ci0_rdata_vld", 28, 1 },
	{ "ci1_arb2_Req", 27, 1 },
	{ "arb2_ci1_Gnt", 26, 1 },
	{ "ci1_dm2_wdata_vld", 25, 1 },
	{ "dm2_ci1_rdata_vld", 24, 1 },
	{ "ci2_arb2_Req", 23, 1 },
	{ "arb2_ci2_Gnt", 22, 1 },
	{ "ci2_dm2_wdata_vld", 21, 1 },
	{ "dm2_ci2_rdata_vld", 20, 1 },
	{ "ci3_arb2_Req", 19, 1 },
	{ "arb2_ci3_Gnt", 18, 1 },
	{ "ci3_dm2_wdata_vld", 17, 1 },
	{ "dm2_ci3_rdata_vld", 16, 1 },
	{ "ci4_arb2_Req", 15, 1 },
	{ "arb2_ci4_Gnt", 14, 1 },
	{ "ci4_dm2_wdata_vld", 13, 1 },
	{ "dm2_ci4_rdata_vld", 12, 1 },
	{ "ci5_arb2_Req", 11, 1 },
	{ "arb2_ci5_Gnt", 10, 1 },
	{ "ci5_dm2_wdata_vld", 9, 1 },
	{ "dm2_ci5_rdata_vld", 8, 1 },
	{ "ci6_arb2_Req", 7, 1 },
	{ "arb2_ci6_Gnt", 6, 1 },
	{ "ci6_dm2_wdata_vld", 5, 1 },
	{ "dm2_ci6_rdata_vld", 4, 1 },
	{ "ci7_arb2_Req", 3, 1 },
	{ "arb2_ci7_Gnt", 2, 1 },
	{ "ci7_dm2_wdata_vld", 1, 1 },
	{ "dm2_ci7_rdata_vld", 0, 1 },
	{ "MA_TARGET_3_ARBITER_INTERFACE_EXTERNAL_REG0", 0xa010, 0 },
	{ "ci0_arb3_Req", 31, 1 },
	{ "arb3_ci0_Gnt", 30, 1 },
	{ "ci0_dm3_wdata_vld", 29, 1 },
	{ "dm3_ci0_rdata_vld", 28, 1 },
	{ "ci1_arb3_Req", 27, 1 },
	{ "arb3_ci1_Gnt", 26, 1 },
	{ "ci1_dm3_wdata_vld", 25, 1 },
	{ "dm3_ci1_rdata_vld", 24, 1 },
	{ "ci2_arb3_Req", 23, 1 },
	{ "arb3_ci2_Gnt", 22, 1 },
	{ "ci2_dm3_wdata_vld", 21, 1 },
	{ "dm3_ci2_rdata_vld", 20, 1 },
	{ "ci3_arb3_Req", 19, 1 },
	{ "arb3_ci3_Gnt", 18, 1 },
	{ "ci3_dm3_wdata_vld", 17, 1 },
	{ "dm3_ci3_rdata_vld", 16, 1 },
	{ "ci4_arb3_Req", 15, 1 },
	{ "arb3_ci4_Gnt", 14, 1 },
	{ "ci4_dm3_wdata_vld", 13, 1 },
	{ "dm3_ci4_rdata_vld", 12, 1 },
	{ "ci5_arb3_Req", 11, 1 },
	{ "arb3_ci5_Gnt", 10, 1 },
	{ "ci5_dm3_wdata_vld", 9, 1 },
	{ "dm3_ci5_rdata_vld", 8, 1 },
	{ "ci6_arb3_Req", 7, 1 },
	{ "arb3_ci6_Gnt", 6, 1 },
	{ "ci6_dm3_wdata_vld", 5, 1 },
	{ "dm3_ci6_rdata_vld", 4, 1 },
	{ "ci7_arb3_Req", 3, 1 },
	{ "arb3_ci7_Gnt", 2, 1 },
	{ "ci7_dm3_wdata_vld", 1, 1 },
	{ "dm3_ci7_rdata_vld", 0, 1 },
	{ "MA_MA_DEBUG_SIGNATURE_LTL_END", 0xa011, 0 },
	{ "MA_MA_DEBUG_SIGNATURE_BIG_END_INVERSE", 0xa012, 0 },
	{ "MA_TARGET_0_ARBITER_INTERFACE_EXTERNAL_REG1", 0xa013, 0 },
	{ "ci8_arb0_Req", 31, 1 },
	{ "arb0_ci8_Gnt", 30, 1 },
	{ "ci8_dm0_wdata_vld", 29, 1 },
	{ "dm0_ci8_rdata_vld", 28, 1 },
	{ "ci9_arb0_Req", 27, 1 },
	{ "arb0_ci9_Gnt", 26, 1 },
	{ "ci9_dm0_wdata_vld", 25, 1 },
	{ "dm0_ci9_rdata_vld", 24, 1 },
	{ "ci10_arb0_Req", 23, 1 },
	{ "arb0_ci10_Gnt", 22, 1 },
	{ "ci10_dm0_wdata_vld", 21, 1 },
	{ "dm0_ci10_rdata_vld", 20, 1 },
	{ "ci11_arb0_Req", 19, 1 },
	{ "arb0_ci11_Gnt", 18, 1 },
	{ "ci11_dm0_wdata_vld", 17, 1 },
	{ "dm0_ci11_rdata_vld", 16, 1 },
	{ "ci12_arb0_Req", 15, 1 },
	{ "arb0_ci12_Gnt", 14, 1 },
	{ "ci12_dm0_wdata_vld", 13, 1 },
	{ "dm0_ci12_rdata_vld", 12, 1 },
	{ "RSVD", 0, 12 },
	{ "MA_TARGET_1_ARBITER_INTERFACE_EXTERNAL_REG1", 0xa014, 0 },
	{ "ci8_arb1_Req", 31, 1 },
	{ "arb1_ci8_Gnt", 30, 1 },
	{ "ci8_dm1_wdata_vld", 29, 1 },
	{ "dm1_ci8_rdata_vld", 28, 1 },
	{ "ci9_arb1_Req", 27, 1 },
	{ "arb1_ci9_Gnt", 26, 1 },
	{ "ci9_dm1_wdata_vld", 25, 1 },
	{ "dm1_ci9_rdata_vld", 24, 1 },
	{ "ci10_arb1_Req", 23, 1 },
	{ "arb1_ci10_Gnt", 22, 1 },
	{ "ci10_dm1_wdata_vld", 21, 1 },
	{ "dm1_ci10_rdata_vld", 20, 1 },
	{ "ci11_arb1_Req", 19, 1 },
	{ "arb1_ci11_Gnt", 18, 1 },
	{ "ci11_dm1_wdata_vld", 17, 1 },
	{ "dm1_ci11_rdata_vld", 16, 1 },
	{ "ci12_arb1_Req", 15, 1 },
	{ "arb1_ci12_Gnt", 14, 1 },
	{ "ci12_dm1_wdata_vld", 13, 1 },
	{ "dm1_ci12_rdata_vld", 12, 1 },
	{ "RSVD", 0, 12 },
	{ "MA_TARGET_2_ARBITER_INTERFACE_EXTERNAL_REG1", 0xa015, 0 },
	{ "ci8_arb2_Req", 31, 1 },
	{ "arb2_ci8_Gnt", 30, 1 },
	{ "ci8_dm2_wdata_vld", 29, 1 },
	{ "dm2_ci8_rdata_vld", 28, 1 },
	{ "ci9_arb2_Req", 27, 1 },
	{ "arb2_ci9_Gnt", 26, 1 },
	{ "ci9_dm2_wdata_vld", 25, 1 },
	{ "dm2_ci9_rdata_vld", 24, 1 },
	{ "ci10_arb2_Req", 23, 1 },
	{ "arb2_ci10_Gnt", 22, 1 },
	{ "ci10_dm2_wdata_vld", 21, 1 },
	{ "dm2_ci10_rdata_vld", 20, 1 },
	{ "ci11_arb2_Req", 19, 1 },
	{ "arb2_ci11_Gnt", 18, 1 },
	{ "ci11_dm2_wdata_vld", 17, 1 },
	{ "dm2_ci11_rdata_vld", 16, 1 },
	{ "ci12_arb2_Req", 15, 1 },
	{ "arb2_ci12_Gnt", 14, 1 },
	{ "ci12_dm2_wdata_vld", 13, 1 },
	{ "dm2_ci12_rdata_vld", 12, 1 },
	{ "RSVD", 0, 12 },
	{ "MA_TARGET_3_ARBITER_INTERFACE_EXTERNAL_REG1", 0xa016, 0 },
	{ "ci8_arb3_Req", 31, 1 },
	{ "arb3_ci8_Gnt", 30, 1 },
	{ "ci8_dm3_wdata_vld", 29, 1 },
	{ "dm3_ci8_rdata_vld", 28, 1 },
	{ "ci9_arb3_Req", 27, 1 },
	{ "arb3_ci9_Gnt", 26, 1 },
	{ "ci9_dm3_wdata_vld", 25, 1 },
	{ "dm3_ci9_rdata_vld", 24, 1 },
	{ "ci10_arb3_Req", 23, 1 },
	{ "arb3_ci10_Gnt", 22, 1 },
	{ "ci10_dm3_wdata_vld", 21, 1 },
	{ "dm3_ci10_rdata_vld", 20, 1},
	{ "ci11_arb3_Req", 19, 1 },
	{ "arb3_ci11_Gnt", 18, 1 },
	{ "ci11_dm3_wdata_vld", 17, 1 },
	{ "dm3_ci11_rdata_vld", 16, 1 },
	{ "ci12_arb3_Req", 15, 1 },
	{ "arb3_ci12_Gnt", 14, 1 },
	{ "ci12_dm3_wdata_vld", 13, 1 },
	{ "dm3_ci12_rdata_vld", 12, 1 },
	{"RSVD", 0, 12 },
	{ NULL }
};
static struct cudbg_reg_info t6_ma_regs_a400_to_a41e[] = {
	{ "MA_SGE_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG0", 0xa400, 0 },
	{ "Cmd_In_FIFO_Cnt0", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt0", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt0", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt0", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt0", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt0", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt0", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_SGE_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG0", 0xa401, 0 },
	{ "Cmd_In_FIFO_Cnt1", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt1", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt1", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt1", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt1", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt1", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt1", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_ULP_TX_CLIENT_INTERFACE_INTERNAL_REG0", 0xa402, 0 },
	{ "Cmd_In_FIFO_Cnt2", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt2", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt2", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt2", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt2", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt2", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt2", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_ULP_RX_CLIENT_INTERFACE_INTERNAL_REG0", 0xa403, 0 },
	{ "Cmd_In_FIFO_Cnt3", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt3", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt3", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt3", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt3", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt3", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt3", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_ULP_TX_RX_CLIENT_INTERFACE_INTERNAL_REG0", 0xa404, 0 },
	{ "Cmd_In_FIFO_Cnt4", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt4", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt4", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt4", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt4", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt4", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt4", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_TP_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG0", 0xa405, 0 },
	{ "Cmd_In_FIFO_Cnt5", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt5", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt5", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt5", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt5", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt5", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt5", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_TP_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG0", 0xa406, 0 },
	{ "Cmd_In_FIFO_Cnt6", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt6", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt6", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt6", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt6", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt6", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt6", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_LE_CLIENT_INTERFACE_INTERNAL_REG0", 0xa407, 0 },
	{ "Cmd_In_FIFO_Cnt7", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt7", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt7", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt7", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt7", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt7", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt7", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_CIM_CLIENT_INTERFACE_INTERNAL_REG0", 0xa408, 0 },
	{ "Cmd_In_FIFO_Cnt8", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt8", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt8", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt8", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt8", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt8", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt8", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_PCIE_CLIENT_INTERFACE_INTERNAL_REG0", 0xa409, 0 },
	{ "Cmd_In_FIFO_Cnt9", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt9", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt9", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt9", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt9", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt9", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt9", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_PM_TX_CLIENT_INTERFACE_INTERNAL_REG0", 0xa40a, 0 },
	{ "Cmd_In_FIFO_Cnt10", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt10", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt10", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt10", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt10", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt10", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt10", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_PM_RX_CLIENT_INTERFACE_INTERNAL_REG0", 0xa40b, 0 },
	{ "Cmd_In_FIFO_Cnt11", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt11", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt11", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt11", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt11", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt11", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt11", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_HMA_CLIENT_INTERFACE_INTERNAL_REG0", 0xa40c, 0 },
	{ "Cmd_In_FIFO_Cnt12", 30, 2 },
	{ "Cmd_Split_FIFO_Cnt12", 28, 2 },
	{ "Cmd_Throttle_FIFO_Cnt12", 22, 6 },
	{ "Rd_Chnl_FIFO_Cnt12", 15, 7 },
	{ "Rd_Data_Ext_FIFO_Cnt12", 13, 2 },
	{ "Rd_Data_512b_FIFO_Cnt12", 5, 8 },
	{ "Rd_Req_Tag_FIFO_Cnt12", 1, 4 },
	{ "RSVD", 0, 1 },
	{ "MA_TARGET_0_ARBITER_INTERFACE_INTERNAL_REG0", 0xa40d, 0 },
	{ "RSVD", 24, 8 },
	{ "Wr_data_FSM0", 23, 1 },
	{ "Rd_Data_FSM0", 22, 1 },
	{ "Tgt_Cmd_FIFO_Cnt0", 19, 2 },
	{ "Clnt_Num_FIFO_Cnt0", 16, 3 },
	{ "Wr_Cmd_Tag_FIFO_Cnt_tgt0", 8, 8},
	{ "Wr_Data_512b_FIFO_Cnt_tgt0", 0, 8 },
	{ "MA_TARGET_1_ARBITER_INTERFACE_INTERNAL_REG0", 0xa40e, 0 },
	{ "RSVD", 24, 8 },
	{ "Wr_data_FSM1", 23, 1 },
	{ "Rd_Data_FSM1", 22, 1 },
	{ "Tgt_Cmd_FIFO_Cnt1", 19, 2 },
	{ "Clnt_Num_FIFO_Cnt1", 16, 3 },
	{ "Wr_Cmd_Tag_FIFO_Cnt_tgt1", 8, 8},
	{ "Wr_Data_512b_FIFO_Cnt_tgt1", 0, 8 },
	{"MA_TARGET_2_ARBITER_INTERFACE_INTERNAL_REG0", 0xa40f, 0 },
	{ "RSVD", 24, 8 },
	{ "Wr_data_FSM2", 23, 1 },
	{ "Rd_Data_FSM2", 22, 1 },
	{ "Tgt_Cmd_FIFO_Cnt2", 19, 2 },
	{ "Clnt_Num_FIFO_Cnt2", 16, 3 },
	{ "Wr_Cmd_Tag_FIFO_Cnt_tgt2", 8, 8},
	{ "Wr_Data_512b_FIFO_Cnt_tgt2", 0, 8 },
	{ "MA_TARGET_3_ARBITER_INTERFACE_INTERNAL_REG0", 0xa410, 0 },
	{ "RSVD", 24, 8 },
	{ "Wr_data_FSM3", 23, 1 },
	{ "Rd_Data_FSM3", 22, 1 },
	{ "Tgt_Cmd_FIFO_Cnt3", 19, 2 },
	{ "Clnt_Num_FIFO_Cnt3", 16, 3 },
	{ "Wr_Cmd_Tag_FIFO_Cnt_tgt3", 8, 8},
	{ "Wr_Data_512b_FIFO_Cnt_tgt3", 0, 8 },
	{ "MA_SGE_THREAD_0_CLNT_EXP_RD_CYC_CNT", 0xa412, 0 },
	{ "MA_SGE_THREAD_1_CLNT_EXP_RD_CYC_CNT", 0xa413, 0 },
	{ "MA_ULP_TX_CLNT_EXP_RD_CYC_CNT", 0xa414, 0 },
	{ "MA_ULP_RX_CLNT_EXP_RD_CYC_CNT", 0xa415, 0 },
	{ "MA_ULP_TX_RX_CLNT_EXP_RD_CYC_CNT", 0xa416, 0 },
	{ "MA_TP_THREAD_0_CLNT_EXP_RD_CYC_CNT", 0xa417, 0 },
	{ "MA_TP_THREAD_1_CLNT_EXP_RD_CYC_CNT", 0xa418, 0 },
	{ "MA_LE_CLNT_EXP_RD_CYC_CNT", 0xa419, 0 },
	{ "MA_CIM_CLNT_EXP_RD_CYC_CNT", 0xa41a, 0 },
	{ "MA_PCIE_CLNT_EXP_RD_CYC_CNT", 0xa41b, 0 },
	{ "MA_PM_TX_CLNT_EXP_RD_CYC_CNT", 0xa41c, 0 },
	{ "MA_PM_RX_CLNT_EXP_RD_CYC_CNT", 0xa41d, 0 },
	{ "MA_HMA_CLNT_EXP_RD_CYC_CNT", 0xa41e, 0 },
	{ NULL }
};

static struct cudbg_reg_info t6_ma_regs_a800_to_a813[] = {
	{ "MA_EDRAM0_WRDATA_CNT1", 0xa800, 0 },
	{ "MA_EDRAM0_WRDATA_CNT0", 0xa801, 0 },
	{ "MA_EDRAM1_WRDATA_CNT1", 0xa802, 0 },
	{ "MA_EDRAM1_WRDATA_CNT0", 0xa803, 0 },
	{ "MA_EXT_MEMORY0_WRDATA_CNT1", 0xa804, 0 },
	{ "MA_EXT_MEMORY0_WRDATA_CNT0", 0xa805, 0 },
	{ "MA_HOST_MEMORY_WRDATA_CNT1", 0xa806, 0 },
	{ "MA_HOST_MEMORY_WRDATA_CNT0", 0xa807, 0 },
	{ "MA_EXT_MEMORY1_WRDATA_CNT1", 0xa808, 0 },
	{ "MA_EXT_MEMORY1_WRDATA_CNT0", 0xa809, 0 },
	{ "MA_EDRAM0_RDDATA_CNT1", 0xa80a, 0 },
	{ "MA_EDRAM0_RDDATA_CNT0", 0xa80b, 0 },
	{ "MA_EDRAM1_RDDATA_CNT1", 0xa80c, 0 },
	{ "MA_EDRAM1_RDDATA_CNT0", 0xa80d, 0 },
	{ "MA_EXT_MEMORY0_RDDATA_CNT1", 0xa80e, 0 },
	{ "MA_EXT_MEMORY0_RDDATA_CNT0", 0xa80f, 0 },
	{ "MA_HOST_MEMORY_RDDATA_CNT1", 0xa810, 0 },
	{ "MA_HOST_MEMORY_RDDATA_CNT0", 0xa811, 0 },
	{ "MA_EXT_MEMORY1_RDDATA_CNT1", 0xa812, 0 },
	{ "MA_EXT_MEMORY1_RDDATA_CNT0", 0xa813, 0 },
	{ NULL }
};

static struct cudbg_reg_info t6_ma_regs_e400_to_e600[] = {
	{ "MA_SGE_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG1", 0xe400, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt0", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt0", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt0", 18, 8 },
	{ "Rd_Data_Align_FSM0", 17, 1 },
	{ "Rd_Data_Fetch_FSM0", 16, 1 },
	{ "Coherency_Tx_FSM0", 15, 1 },
	{ "Coherency_Rx_FSM0", 14, 1 },
	{ "Arb_Req_FSM0", 13, 1 },
	{ "Cmd_Split_FSM0", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_SGE_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG1", 0xe420, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt1", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt1", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt1", 18, 8 },
	{ "Rd_Data_Align_FSM1", 17, 1 },
	{ "Rd_Data_Fetch_FSM1", 16, 1 },
	{ "Coherency_Tx_FSM1", 15, 1 },
	{ "Coherency_Rx_FSM1", 14, 1 },
	{ "Arb_Req_FSM1", 13, 1 },
	{ "Cmd_Split_FSM1", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_ULP_TX_CLIENT_INTERFACE_INTERNAL_REG1", 0xe440, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt2", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt2", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt2", 18, 8 },
	{ "Rd_Data_Align_FSM2", 17, 1 },
	{ "Rd_Data_Fetch_FSM2", 16, 1 },
	{ "Coherency_Tx_FSM2", 15, 1 },
	{ "Coherency_Rx_FSM2", 14, 1 },
	{ "Arb_Req_FSM2", 13, 1 },
	{ "Cmd_Split_FSM2", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_ULP_RX_CLIENT_INTERFACE_INTERNAL_REG1", 0xe460, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt3", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt3", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt3", 18, 8 },
	{ "Rd_Data_Align_FSM3", 17, 1 },
	{ "Rd_Data_Fetch_FSM3", 16, 1 },
	{ "Coherency_Tx_FSM3", 15, 1 },
	{ "Coherency_Rx_FSM3", 14, 1 },
	{ "Arb_Req_FSM3", 13, 1 },
	{ "Cmd_Split_FSM3", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_ULP_TX_RX_CLIENT_INTERFACE_INTERNAL_REG1", 0xe480, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt4", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt4", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt4", 18, 8 },
	{ "Rd_Data_Align_FSM4", 17, 1 },
	{ "Rd_Data_Fetch_FSM4", 16, 1 },
	{ "Coherency_Tx_FSM4", 15, 1 },
	{ "Coherency_Rx_FSM4", 14, 1 },
	{ "Arb_Req_FSM4", 13, 1 },
	{ "Cmd_Split_FSM4", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_TP_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG1", 0xe4a0, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt5", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt5", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt5", 18, 8 },
	{ "Rd_Data_Align_FSM5", 17, 1 },
	{ "Rd_Data_Fetch_FSM5", 16, 1 },
	{ "Coherency_Tx_FSM5", 15, 1 },
	{ "Coherency_Rx_FSM5", 14, 1 },
	{ "Arb_Req_FSM5", 13, 1 },
	{ "Cmd_Split_FSM5", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_TP_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG1", 0xe4c0, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt6", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt6", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt6", 18, 8 },
	{ "Rd_Data_Align_FSM6", 17, 1 },
	{ "Rd_Data_Fetch_FSM6", 16, 1 },
	{ "Coherency_Tx_FSM6", 15, 1 },
	{ "Coherency_Rx_FSM6", 14, 1 },
	{ "Arb_Req_FSM6", 13, 1 },
	{ "Cmd_Split_FSM6", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_LE_CLIENT_INTERFACE_INTERNAL_REG1", 0xe4e0, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt7", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt7", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt7", 18, 8 },
	{ "Rd_Data_Align_FSM7", 17, 1 },
	{ "Rd_Data_Fetch_FSM7", 16, 1 },
	{ "Coherency_Tx_FSM7", 15, 1 },
	{ "Coherency_Rx_FSM7", 14, 1 },
	{ "Arb_Req_FSM7", 13, 1 },
	{ "Cmd_Split_FSM7", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_CIM_CLIENT_INTERFACE_INTERNAL_REG1", 0xe500, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt8", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt8", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt8", 18, 8 },
	{ "Rd_Data_Align_FSM8", 17, 1 },
	{ "Rd_Data_Fetch_FSM8", 16, 1 },
	{ "Coherency_Tx_FSM8", 15, 1 },
	{ "Coherency_Rx_FSM8", 14, 1 },
	{ "Arb_Req_FSM8", 13, 1 },
	{ "Cmd_Split_FSM8", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_PCIE_CLIENT_INTERFACE_INTERNAL_REG1", 0xe520, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt9", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt9", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt9", 18, 8 },
	{ "Rd_Data_Align_FSM9", 17, 1 },
	{ "Rd_Data_Fetch_FSM9", 16, 1 },
	{ "Coherency_Tx_FSM9", 15, 1 },
	{ "Coherency_Rx_FSM9", 14, 1 },
	{ "Arb_Req_FSM9", 13, 1 },
	{ "Cmd_Split_FSM9", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_PM_TX_CLIENT_INTERFACE_INTERNAL_REG1", 0xe540, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt10", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt10", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt10", 18, 8 },
	{ "Rd_Data_Align_FSM10", 17, 1 },
	{ "Rd_Data_Fetch_FSM10", 16, 1 },
	{ "Coherency_Tx_FSM10", 15, 1 },
	{ "Coherency_Rx_FSM10", 14, 1 },
	{ "Arb_Req_FSM10", 13, 1 },
	{ "Cmd_Split_FSM10", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_PM_RX_CLIENT_INTERFACE_INTERNAL_REG1", 0xe560, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt11", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt11", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt11", 18, 8 },
	{ "Rd_Data_Align_FSM11", 17, 1 },
	{ "Rd_Data_Fetch_FSM11", 16, 1 },
	{ "Coherency_Tx_FSM11", 15, 1 },
	{ "Coherency_Rx_FSM11", 14, 1 },
	{ "Arb_Req_FSM11", 13, 1 },
	{ "Cmd_Split_FSM11", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_HMA_CLIENT_INTERFACE_INTERNAL_REG1", 0xe580, 0 },
	{ "Wr_Data_Ext_FIFO_Cnt12", 30, 2 },
	{ "Wr_Cmd_Tag_FIFO_Cnt12", 26, 4 },
	{ "Wr_Data_512b_FIFO_Cnt12", 18, 8 },
	{ "Rd_Data_Align_FSM12", 17, 1 },
	{ "Rd_Data_Fetch_FSM12", 16, 1 },
	{ "Coherency_Tx_FSM12", 15, 1 },
	{ "Coherency_Rx_FSM12", 14, 1 },
	{ "Arb_Req_FSM12", 13, 1 },
	{ "Cmd_Split_FSM12", 11, 2},
	{ "RSVD", 0, 11 },
	{ "MA_TARGET_0_ARBITER_INTERFACE_INTERNAL_REG1", 0xe5a0, 0 },
	{ "RSVD", 16, 16 },
	{ "Rd_Cmd_Tag_FIFO_Cnt0", 8, 8 },
	{ "Rd_Data_FIFO_Cnt0", 0, 8 },
	{ "MA_TARGET_1_ARBITER_INTERFACE_INTERNAL_REG1", 0xe5c0, 0 },
	{ "RSVD", 16, 16 },
	{ "Rd_Cmd_Tag_FIFO_Cnt1", 8, 8 },
	{ "Rd_Data_FIFO_Cnt1", 0, 8 },
	{ "MA_TARGET_2_ARBITER_INTERFACE_INTERNAL_REG1", 0xe5e0, 0 },
	{ "RSVD", 16, 16 },
	{ "Rd_Cmd_Tag_FIFO_Cnt2", 8, 8 },
	{ "Rd_Data_FIFO_Cnt2", 0, 8 },
	{ "MA_TARGET_3_ARBITER_INTERFACE_INTERNAL_REG1", 0xe600, 0 },
	{ "RSVD", 16, 16 },
	{ "Rd_Cmd_Tag_FIFO_Cnt3", 8, 8 },
	{ "Rd_Data_FIFO_Cnt3", 0, 8 },
	{ NULL }
};

static struct cudbg_reg_info t6_ma_regs_e640_to_e7c0[] = {
	{ "MA_SGE_THREAD_0_CLNT_EXP_WR_CYC_CNT", 0xe640, 0 },
	{ "MA_SGE_THREAD_1_CLNT_EXP_WR_CYC_CNT", 0xe660, 0 },
	{ "MA_ULP_TX_CLNT_EXP_WR_CYC_CNT", 0xe680, 0 },
	{ "MA_ULP_RX_CLNT_EXP_WR_CYC_CNT", 0xe6a0, 0 },
	{ "MA_ULP_TX_RX_CLNT_EXP_WR_CYC_CNT", 0xe6c0, 0 },
	{ "MA_TP_THREAD_0_CLNT_EXP_WR_CYC_CNT", 0xe6e0, 0 },
	{ "MA_TP_THREAD_1_CLNT_EXP_WR_CYC_CNT", 0xe700, 0 },
	{ "MA_LE_CLNT_EXP_WR_CYC_CNT", 0xe720, 0 },
	{ "MA_CIM_CLNT_EXP_WR_CYC_CNT", 0xe740, 0 },
	{ "MA_PCIE_CLNT_EXP_WR_CYC_CNT", 0xe760, 0 },
	{ "MA_PM_TX_CLNT_EXP_WR_CYC_CNT", 0xe780, 0 },
	{ "MA_PM_RX_CLNT_EXP_WR_CYC_CNT", 0xe7a0, 0 },
	{ "MA_HMA_CLNT_EXP_WR_CYC_CNT", 0xe7c0, 0 },
	{ NULL }
};

static char *cudbg_ulptx_rdptr[] = {
	"ULP_TX_LA_RDPTR_0" ,
	"ULP_TX_LA_RDPTR_1" ,
	"ULP_TX_LA_RDPTR_2" ,
	"ULP_TX_LA_RDPTR_3" ,
	"ULP_TX_LA_RDPTR_4" ,
	"ULP_TX_LA_RDPTR_5" ,
	"ULP_TX_LA_RDPTR_6" ,
	"ULP_TX_LA_RDPTR_7" ,
	"ULP_TX_LA_RDPTR_8" ,
	"ULP_TX_LA_RDPTR_9" ,
	"ULP_TX_LA_RDPTR_10"
};

static char *cudbg_ulptx_wrptr[] = {
	"ULP_TX_LA_WRPTR_0",
	"ULP_TX_LA_WRPTR_1",
	"ULP_TX_LA_WRPTR_2",
	"ULP_TX_LA_WRPTR_3",
	"ULP_TX_LA_WRPTR_4",
	"ULP_TX_LA_WRPTR_5",
	"ULP_TX_LA_WRPTR_6",
	"ULP_TX_LA_WRPTR_7",
	"ULP_TX_LA_WRPTR_8",
	"ULP_TX_LA_WRPTR_9",
	"ULP_TX_LA_WRPTR_10"
};

static char *cudbg_ulptx_rddata[] = {
	"ULP_TX_LA_RDDATA_0",
	"ULP_TX_LA_RDDATA_1",
	"ULP_TX_LA_RDDATA_2",
	"ULP_TX_LA_RDDATA_3",
	"ULP_TX_LA_RDDATA_4",
	"ULP_TX_LA_RDDATA_5",
	"ULP_TX_LA_RDDATA_6",
	"ULP_TX_LA_RDDATA_7",
	"ULP_TX_LA_RDDATA_8",
	"ULP_TX_LA_RDDATA_9",
	"ULP_TX_LA_RDDATA_10"
};

static struct cudbg_reg_info t6_up_cim_2000_to_207c[] = {
	{"CIM_CTL_CONFIG", 0x2000, 0},
	{"AutoPrefLoc", 17, 5},
	{"AutoPrefEn", 16, 1},
	{"DisMATimeOut", 15, 1},
	{"DisSlowTimeOut", 14, 1},
	{"IntlRspEn", 9, 1},
	{"PIFMultiCmd", 8, 1},
	{"UPSelfResetTOut", 7, 1},
	{"PLSwapDisWr", 6, 1},
	{"PLSwapDisRd", 5, 1},
	{"Timer1En", 4, 1},
	{"Timer0En", 3, 1},
	{"TimerEn", 1, 1},
	{"PrefEn", 0, 1},
	{"CIM_CTL_PREFADDR", 0x2004, 0},
	{"PrefAddr", 0, 32},
	{"CIM_CTL_ALLOCADDR", 0x2008, 0},
	{"IbqGen0", 0, 32},
	{"CIM_CTL_INVLDTADDR", 0x200c, 0},
	{"InvldtAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR0", 0x2010, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR1", 0x2014, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR2", 0x2018, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR3", 0x201c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR4", 0x2020, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR5", 0x2024, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR6", 0x2028, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR7", 0x202c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR8", 0x2030, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR9", 0x2034, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR10", 0x2038, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR11", 0x203c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR12", 0x2040, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR13", 0x2044, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR14", 0x2048, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR15", 0x204c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR0", 0x2050, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR1", 0x2054, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR2", 0x2058, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR3", 0x205c, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR4", 0x2060, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR5", 0x2064, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR6", 0x2068, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR7", 0x206c, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR8", 0x2070, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR9", 0x2074, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR10", 0x2078, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR11", 0x207c, 0},
	{"StaticAllocAddr", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_2000_to_207c[] = {
	{"CIM_CTL_CONFIG", 0x2000, 0},
	{"AutoPrefLoc", 17, 5},
	{"AutoPrefEn", 16, 1},
	{"DisMATimeOut", 15, 1},
	{"PIFMultiCmd", 8, 1},
	{"UPSelfResetTOut", 7, 1},
	{"PLSwapDisWr", 6, 1},
	{"PLSwapDisRd", 5, 1},
	{"Timer1En", 4, 1},
	{"Timer0En", 3, 1},
	{"TimerEn", 1, 1},
	{"PrefEn", 0, 1},
	{"CIM_CTL_PREFADDR", 0x2004, 0},
	{"PrefAddr", 0, 32},
	{"CIM_CTL_ALLOCADDR", 0x2008, 0},
	{"IbqGen0", 0, 32},
	{"CIM_CTL_INVLDTADDR", 0x200c, 0},
	{"InvldtAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR0", 0x2010, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR1", 0x2014, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR2", 0x2018, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR3", 0x201c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR4", 0x2020, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR5", 0x2024, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR6", 0x2028, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR7", 0x202c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR8", 0x2030, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR9", 0x2034, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR10", 0x2038, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR11", 0x203c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR12", 0x2040, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR13", 0x2044, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR14", 0x2048, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_PREFADDR15", 0x204c, 0},
	{"StaticPrefAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR0", 0x2050, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR1", 0x2054, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR2", 0x2058, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR3", 0x205c, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR4", 0x2060, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR5", 0x2064, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR6", 0x2068, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR7", 0x206c, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR8", 0x2070, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR9", 0x2074, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR10", 0x2078, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR11", 0x207c, 0},
	{"StaticAllocAddr", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4900_to_4c60[] = {
	{"CIM_CTL_0_TSCH_CHANNEL_TSCH_CHNLN_CTL", 0x4900, 0},
	{"TSCHNLEN", 31, 1},
	{"TSCHNRESET", 30, 1},
	{"MIN_MAX_EN", 29, 1},
	{"CIM_CTL_1_TSCH_CHANNEL_TSCH_CHNLN_CTL", 0x4a20, 0},
	{"TSCHNLEN", 31, 1},
	{"TSCHNRESET", 30, 1},
	{"MIN_MAX_EN", 29, 1},
	{"CIM_CTL_2_TSCH_CHANNEL_TSCH_CHNLN_CTL", 0x4b40, 0},
	{"TSCHNLEN", 31, 1},
	{"TSCHNRESET", 30, 1},
	{"MIN_MAX_EN", 29, 1},
	{"CIM_CTL_3_TSCH_CHANNEL_TSCH_CHNLN_CTL", 0x4c60, 0},
	{"TSCHNLEN", 31, 1},
	{"TSCHNRESET", 30, 1},
	{"MIN_MAX_EN", 29, 1},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4904_to_4c64[] = {
	{"CIM_CTL_0_TSCH_CHANNEL_TSCH_CHNLN_CLASS_RATECTL", 0x4904, 0},
	{"TSC0RATECTL", 0, 1},
	{"TSC1RATECTL", 1, 1},
	{"TSC2RATECTL", 2, 1},
	{"TSC3RATECTL", 3, 1},
	{"TSC4RATECTL", 4, 1},
	{"TSC5RATECTL", 5, 1},
	{"TSC6RATECTL", 6, 1},
	{"TSC7RATECTL", 7, 1},
	{"TSC8RATECTL", 8, 1},
	{"TSC9RATECTL", 9, 1},
	{"TSC10RATECTL", 10, 1},
	{"TSC11RATECTL", 11, 1},
	{"TSC12RATECTL", 12, 1},
	{"TSC13RATECTL", 13, 1},
	{"TSC14RATECTL", 14, 1},
	{"TSC15RATECTL", 15, 1},
	{"CIM_CTL_1_TSCH_CHANNEL_TSCH_CHNLN_CLASS_RATECTL", 0x4a24, 0},
	{"TSC0RATECTL", 0, 1},
	{"TSC1RATECTL", 1, 1},
	{"TSC2RATECTL", 2, 1},
	{"TSC3RATECTL", 3, 1},
	{"TSC4RATECTL", 4, 1},
	{"TSC5RATECTL", 5, 1},
	{"TSC6RATECTL", 6, 1},
	{"TSC7RATECTL", 7, 1},
	{"TSC8RATECTL", 8, 1},
	{"TSC9RATECTL", 9, 1},
	{"TSC10RATECTL", 10, 1},
	{"TSC11RATECTL", 11, 1},
	{"TSC12RATECTL", 12, 1},
	{"TSC13RATECTL", 13, 1},
	{"TSC14RATECTL", 14, 1},
	{"TSC15RATECTL", 15, 1},
	{"CIM_CTL_2_TSCH_CHANNEL_TSCH_CHNLN_CLASS_RATECTL", 0x4b44, 0},
	{"TSC0RATECTL", 0, 1},
	{"TSC1RATECTL", 1, 1},
	{"TSC2RATECTL", 2, 1},
	{"TSC3RATECTL", 3, 1},
	{"TSC4RATECTL", 4, 1},
	{"TSC5RATECTL", 5, 1},
	{"TSC6RATECTL", 6, 1},
	{"TSC7RATECTL", 7, 1},
	{"TSC8RATECTL", 8, 1},
	{"TSC9RATECTL", 9, 1},
	{"TSC10RATECTL", 10, 1},
	{"TSC11RATECTL", 11, 1},
	{"TSC12RATECTL", 12, 1},
	{"TSC13RATECTL", 13, 1},
	{"TSC14RATECTL", 14, 1},
	{"TSC15RATECTL", 15, 1},
	{"CIM_CTL_3_TSCH_CHANNEL_TSCH_CHNLN_CLASS_RATECTL", 0x4c64, 0},
	{"TSC0RATECTL", 0, 1},
	{"TSC1RATECTL", 1, 1},
	{"TSC2RATECTL", 2, 1},
	{"TSC3RATECTL", 3, 1},
	{"TSC4RATECTL", 4, 1},
	{"TSC5RATECTL", 5, 1},
	{"TSC6RATECTL", 6, 1},
	{"TSC7RATECTL", 7, 1},
	{"TSC8RATECTL", 8, 1},
	{"TSC9RATECTL", 9, 1},
	{"TSC10RATECTL", 10, 1},
	{"TSC11RATECTL", 11, 1},
	{"TSC12RATECTL", 12, 1},
	{"TSC13RATECTL", 13, 1},
	{"TSC14RATECTL", 14, 1},
	{"TSC15RATECTL", 15, 1},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4908_to_4c68[] = {
	{"CIM_CTL_0_TSCH_CHANNEL_TSCH_CHNLN_CLASS_ENABLE_A", 0x4908, 0},
	{"TSC15WRREN", 31, 1},
	{"TSC15RATEEN", 30, 1},
	{"TSC14WRREN", 29, 1},
	{"TSC14RATEEN", 28, 1},
	{"TSC13WRREN", 27, 1},
	{"TSC13RATEEN", 26, 1},
	{"TSC12WRREN", 25, 1},
	{"TSC12RATEEN", 24, 1},
	{"TSC11WRREN", 23, 1},
	{"TSC11RATEEN", 22, 1},
	{"TSC10WRREN", 21, 1},
	{"TSC10RATEEN", 20, 1},
	{"TSC9WRREN", 19, 1},
	{"TSC9RATEEN", 18, 1},
	{"TSC8WRREN", 17, 1},
	{"TSC8RATEEN", 16, 1},
	{"TSC7WRREN", 15, 1},
	{"TSC7RATEEN", 14, 1},
	{"TSC6WRREN", 13, 1},
	{"TSC6RATEEN", 12, 1},
	{"TSC5WRREN", 11, 1},
	{"TSC5RATEEN", 10, 1},
	{"TSC4WRREN", 9, 1},
	{"TSC4RATEEN", 8, 1},
	{"TSC3WRREN", 7, 1},
	{"TSC3RATEEN", 6, 1},
	{"TSC2WRREN", 5, 1},
	{"TSC2RATEEN", 4, 1},
	{"TSC1WRREN", 3, 1},
	{"TSC1RATEEN", 2, 1},
	{"TSC0WRREN", 1, 1},
	{"TSC0RATEEN", 0, 1},
	{"CIM_CTL_1_TSCH_CHANNEL_TSCH_CHNLN_CLASS_ENABLE_A", 0x4a28, 0},
	{"TSC15WRREN", 31, 1},
	{"TSC15RATEEN", 30, 1},
	{"TSC14WRREN", 29, 1},
	{"TSC14RATEEN", 28, 1},
	{"TSC13WRREN", 27, 1},
	{"TSC13RATEEN", 26, 1},
	{"TSC12WRREN", 25, 1},
	{"TSC12RATEEN", 24, 1},
	{"TSC11WRREN", 23, 1},
	{"TSC11RATEEN", 22, 1},
	{"TSC10WRREN", 21, 1},
	{"TSC10RATEEN", 20, 1},
	{"TSC9WRREN", 19, 1},
	{"TSC9RATEEN", 18, 1},
	{"TSC8WRREN", 17, 1},
	{"TSC8RATEEN", 16, 1},
	{"TSC7WRREN", 15, 1},
	{"TSC7RATEEN", 14, 1},
	{"TSC6WRREN", 13, 1},
	{"TSC6RATEEN", 12, 1},
	{"TSC5WRREN", 11, 1},
	{"TSC5RATEEN", 10, 1},
	{"TSC4WRREN", 9, 1},
	{"TSC4RATEEN", 8, 1},
	{"TSC3WRREN", 7, 1},
	{"TSC3RATEEN", 6, 1},
	{"TSC2WRREN", 5, 1},
	{"TSC2RATEEN", 4, 1},
	{"TSC1WRREN", 3, 1},
	{"TSC1RATEEN", 2, 1},
	{"TSC0WRREN", 1, 1},
	{"TSC0RATEEN", 0, 1},
	{"CIM_CTL_2_TSCH_CHANNEL_TSCH_CHNLN_CLASS_ENABLE_A", 0x4b48, 0},
	{"TSC15WRREN", 31, 1},
	{"TSC15RATEEN", 30, 1},
	{"TSC14WRREN", 29, 1},
	{"TSC14RATEEN", 28, 1},
	{"TSC13WRREN", 27, 1},
	{"TSC13RATEEN", 26, 1},
	{"TSC12WRREN", 25, 1},
	{"TSC12RATEEN", 24, 1},
	{"TSC11WRREN", 23, 1},
	{"TSC11RATEEN", 22, 1},
	{"TSC10WRREN", 21, 1},
	{"TSC10RATEEN", 20, 1},
	{"TSC9WRREN", 19, 1},
	{"TSC9RATEEN", 18, 1},
	{"TSC8WRREN", 17, 1},
	{"TSC8RATEEN", 16, 1},
	{"TSC7WRREN", 15, 1},
	{"TSC7RATEEN", 14, 1},
	{"TSC6WRREN", 13, 1},
	{"TSC6RATEEN", 12, 1},
	{"TSC5WRREN", 11, 1},
	{"TSC5RATEEN", 10, 1},
	{"TSC4WRREN", 9, 1},
	{"TSC4RATEEN", 8, 1},
	{"TSC3WRREN", 7, 1},
	{"TSC3RATEEN", 6, 1},
	{"TSC2WRREN", 5, 1},
	{"TSC2RATEEN", 4, 1},
	{"TSC1WRREN", 3, 1},
	{"TSC1RATEEN", 2, 1},
	{"TSC0WRREN", 1, 1},
	{"TSC0RATEEN", 0, 1},
	{"CIM_CTL_3_TSCH_CHANNEL_TSCH_CHNLN_CLASS_ENABLE_A", 0x4c68, 0},
	{"TSC15WRREN", 31, 1},
	{"TSC15RATEEN", 30, 1},
	{"TSC14WRREN", 29, 1},
	{"TSC14RATEEN", 28, 1},
	{"TSC13WRREN", 27, 1},
	{"TSC13RATEEN", 26, 1},
	{"TSC12WRREN", 25, 1},
	{"TSC12RATEEN", 24, 1},
	{"TSC11WRREN", 23, 1},
	{"TSC11RATEEN", 22, 1},
	{"TSC10WRREN", 21, 1},
	{"TSC10RATEEN", 20, 1},
	{"TSC9WRREN", 19, 1},
	{"TSC9RATEEN", 18, 1},
	{"TSC8WRREN", 17, 1},
	{"TSC8RATEEN", 16, 1},
	{"TSC7WRREN", 15, 1},
	{"TSC7RATEEN", 14, 1},
	{"TSC6WRREN", 13, 1},
	{"TSC6RATEEN", 12, 1},
	{"TSC5WRREN", 11, 1},
	{"TSC5RATEEN", 10, 1},
	{"TSC4WRREN", 9, 1},
	{"TSC4RATEEN", 8, 1},
	{"TSC3WRREN", 7, 1},
	{"TSC3RATEEN", 6, 1},
	{"TSC2WRREN", 5, 1},
	{"TSC2RATEEN", 4, 1},
	{"TSC1WRREN", 3, 1},
	{"TSC1RATEEN", 2, 1},
	{"TSC0WRREN", 1, 1},
	{"TSC0RATEEN", 0, 1},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4910_to_4c70[] = {
	{"CIM_CTL_0_TSCH_CHANNEL_TSCH_CHNLN_RATE_LIMITER", 0x4910, 0},
	{"TSCHNLRATENEG", 31, 1},
	{"TSCHNLRATEPROT", 30, 1},
	{"TSCHNLRATEL", 0, 30},
	{"CIM_CTL_1_TSCH_CHANNEL_TSCH_CHNLN_RATE_LIMITER", 0x4a30, 0},
	{"TSCHNLRATENEG", 31, 1},
	{"TSCHNLRATEPROT", 30, 1},
	{"TSCHNLRATEL", 0, 30},
	{"CIM_CTL_2_TSCH_CHANNEL_TSCH_CHNLN_RATE_LIMITER", 0x4b50, 0},
	{"TSCHNLRATENEG", 31, 1},
	{"TSCHNLRATEPROT", 30, 1},
	{"TSCHNLRATEL", 0, 30},
	{"CIM_CTL_3_TSCH_CHANNEL_TSCH_CHNLN_RATE_LIMITER", 0x4c70, 0},
	{"TSCHNLRATENEG", 31, 1},
	{"TSCHNLRATEPROT", 30, 1},
	{"TSCHNLRATEL", 0, 30},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4914_to_4c74[] = {
	{"CIM_CTL_0_TSCH_CHANNEL_TSCH_CHNLN_RATE_PROPERTIES", 0x4914, 0},
	{"TSCHNLRMAX", 16, 16},
	{"TSCHNLRTSEL", 14, 2},
	{"TSCHNLRINCR", 0, 14},
	{"CIM_CTL_1_TSCH_CHANNEL_TSCH_CHNLN_RATE_PROPERTIES", 0x4a34, 0},
	{"TSCHNLRMAX", 16, 16},
	{"TSCHNLRTSEL", 14, 2},
	{"TSCHNLRINCR", 0, 14},
	{"CIM_CTL_2_TSCH_CHANNEL_TSCH_CHNLN_RATE_PROPERTIES", 0x4b54, 0},
	{"TSCHNLRMAX", 16, 16},
	{"TSCHNLRTSEL", 14, 2},
	{"TSCHNLRINCR", 0, 14},
	{"CIM_CTL_3_TSCH_CHANNEL_TSCH_CHNLN_RATE_PROPERTIES", 0x4c74, 0},
	{"TSCHNLRMAX", 16, 16},
	{"TSCHNLRTSEL", 14, 2},
	{"TSCHNLRINCR", 0, 14},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4920_to_4a10[] = {
	{"CIM_CTL_0_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4920, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_1_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4930, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_2_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4940, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_3_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4950, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_4_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4960, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_5_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4970, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_6_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4980, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_7_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4990, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_8_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x49a0, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_9_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x49b0, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_10_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x49c0, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_11_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x49d0, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_12_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x49e0, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_13_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x49f0, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_14_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4a00, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{"CIM_CTL_15_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_LIMITER", 0x4a10, 0},
	{"TSCCLRATENEG", 31, 1},
	{"TSCCLRATEPROT", 30, 1},
	{"TSCCLRATEL", 0, 24},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4924_to_4a14[] = {
	{"CIM_CTL_0_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4924, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_1_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4934, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_2_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4944, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_3_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4954, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_4_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4964, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_5_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4974, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_6_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4984, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_7_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4994, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_8_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x49a4, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_9_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x49b4, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_10_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x49c4, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_11_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x49d4, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_12_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x49e4, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_13_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x49f4, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_14_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4a04, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{"CIM_CTL_15_TSCH_CLASS_TSCH_CHNLN_CLASSM_RATE_PROPERTIES", 0x4a14, 0},
	{"TSCCLRMAX", 16, 16},
	{"TSCCLRTSEL", 14, 2},
	{"TSCCLRINCR", 0, 14},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_4928_to_4a18[] = {
	{"CIM_CTL_0_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4928, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_1_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4938, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_2_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4948, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_3_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4958, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_4_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4968, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_5_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4978, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_6_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4988, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_7_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4998, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_8_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x49a8, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_9_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x49b8, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_10_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x49c8, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_11_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x49d8, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_12_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x49e8, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_13_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x49f8, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_14_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4a08, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{"CIM_CTL_15_TSCH_CLASS_TSCH_CHNLN_CLASSM_WRR", 0x4a18, 0},
	{"TSCCLWRRNEG", 31, 1},
	{"TSCCLWRRPROT", 30, 1},
	{"TSCCLWRR", 0, 26},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_492c_to_4a1c[] = {
	{"CIM_CTL_0_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x492c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_1_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x493c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_2_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x494c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_3_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x495c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_4_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x496c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_5_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x497c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_6_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x498c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_7_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x499c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_8_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x49ac, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_9_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x49bc, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_10_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x49cc, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_11_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x49dc, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_12_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x49ec, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_13_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x49fc, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_14_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x4a0c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{"CIM_CTL_15_TSCH_CLASS_TSCH_CHNLN_CLASSM_WEIGHT", 0x4a1c, 0},
	{"PAUSEVECSEL", 28, 2},
	{"MPSPAUSEMASK", 20, 8},
	{"TSCCLWEIGHT", 0, 16},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_2080_to_20fc[] = {
	{"CIM_CTL_STATIC_ALLOCADDR12", 0x2080, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR13", 0x2084, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR14", 0x2088, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR15", 0x208c, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_FIFO_CNT", 0x2090, 0},
	{"CtlFifoCnt", 0, 4},
	{"CIM_CTL_GLB_TIMER", 0x2094, 0},
	{"GlblTimer", 0, 32},
	{"CIM_CTL_TIMER0", 0x2098, 0},
	{"Timer0", 0, 32},
	{"CIM_CTL_TIMER1", 0x209c, 0},
	{"Timer1", 0, 32},
	{"CIM_CTL_GEN0", 0x20a0, 0},
	{"Gen0", 0, 32},
	{"CIM_CTL_GEN1", 0x20a4, 0},
	{"Gen1", 0, 32},
	{"CIM_CTL_GEN2", 0x20a8, 0},
	{"Gen2", 0, 32},
	{"CIM_CTL_GEN3", 0x20ac, 0},
	{"Gen3", 0, 32},
	{"CIM_CTL_GLB_TIMER_TICK", 0x20b0, 0},
	{"GlblTTick", 0, 16},
	{"CIM_CTL_GEN_TIMER0_CTL", 0x20b4, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER0", 0x20b8, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_GEN_TIMER1_CTL", 0x20bc, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER1", 0x20c0, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_GEN_TIMER2_CTL", 0x20c4, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER2", 0x20c8, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_GEN_TIMER3_CTL", 0x20cc, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER3", 0x20d0, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_0_MAILBOX_VF_STATUS", 0x20e0, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_1_MAILBOX_VF_STATUS", 0x20e4, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_2_MAILBOX_VF_STATUS", 0x20e8, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_3_MAILBOX_VF_STATUS", 0x20ec, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_4_MAILBOX_VF_STATUS", 0x20f0, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_5_MAILBOX_VF_STATUS", 0x20f4, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_6_MAILBOX_VF_STATUS", 0x20f8, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_7_MAILBOX_VF_STATUS", 0x20fc, 0},
	{"MBVFStatus", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_2080_to_20ec[] = {
	{"CIM_CTL_STATIC_ALLOCADDR12", 0x2080, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR13", 0x2084, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR14", 0x2088, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_STATIC_ALLOCADDR15", 0x208c, 0},
	{"StaticAllocAddr", 0, 32},
	{"CIM_CTL_FIFO_CNT", 0x2090, 0},
	{"CtlFifoCnt", 0, 4},
	{"CIM_CTL_GLB_TIMER", 0x2094, 0},
	{"GlblTimer", 0, 32},
	{"CIM_CTL_TIMER0", 0x2098, 0},
	{"Timer0", 0, 32},
	{"CIM_CTL_TIMER1", 0x209c, 0},
	{"Timer1", 0, 32},
	{"CIM_CTL_GEN0", 0x20a0, 0},
	{"Gen0", 0, 32},
	{"CIM_CTL_GEN1", 0x20a4, 0},
	{"Gen1", 0, 32},
	{"CIM_CTL_GEN2", 0x20a8, 0},
	{"Gen2", 0, 32},
	{"CIM_CTL_GEN3", 0x20ac, 0},
	{"Gen3", 0, 32},
	{"CIM_CTL_GLB_TIMER_TICK", 0x20b0, 0},
	{"GlblTTick", 0, 16},
	{"CIM_CTL_GEN_TIMER0_CTL", 0x20b4, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER0", 0x20b8, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_GEN_TIMER1_CTL", 0x20bc, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER1", 0x20c0, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_GEN_TIMER2_CTL", 0x20c4, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER2", 0x20c8, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_GEN_TIMER3_CTL", 0x20cc, 0},
	{"GenTimerRun", 7, 1},
	{"GenTimerTrig", 6, 1},
	{"GenTimerAct", 4, 2},
	{"GenTimerCfg", 2, 2},
	{"GenTimerStop", 1, 1},
	{"GenTimerStrt", 0, 1},
	{"CIM_CTL_GEN_TIMER3", 0x20d0, 0},
	{"GenTimer0", 0, 32},
	{"CIM_CTL_0_MAILBOX_VF_STATUS", 0x20e0, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_1_MAILBOX_VF_STATUS", 0x20e4, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_2_MAILBOX_VF_STATUS", 0x20e8, 0},
	{"MBVFStatus", 0, 32},
	{"CIM_CTL_3_MAILBOX_VF_STATUS", 0x20ec, 0},
	{"MBVFStatus", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_00_to_7c[] = {
	{"UP_IBQ_CONFIG", 0x0, 0},
	{"IbqGen2", 2, 30},
	{"IbqBusy", 1, 1},
	{"IbqEn", 0, 1},
	{"UP_OBQ_CONFIG", 0x4, 0},
	{"ObqGen2", 2, 30},
	{"ObqBusy", 1, 1},
	{"ObqEn", 0, 1},
	{"UP_IBQ_GEN", 0x8, 0},
	{"IbqGen0", 22, 10},
	{"IbqTSCHChnlRdy", 18, 5},
	{"IbqMBVFStatus", 17, 1},
	{"IbqMBStatus", 16, 1},
	{"IbqGen1", 6, 10},
	{"IbqEmpty", 0, 6},
	{"UP_OBQ_GEN", 0xc, 0},
	{"ObqGen", 8, 25},
	{"ObqFull", 0, 8},
	{"UP_IBQ_0_RDADDR", 0x10, 0},
	{"QueID", 13, 19},
	{"QueRdAddr", 0, 13},
	{"UP_IBQ_0_WRADDR", 0x14, 0},
	{"QueID", 13, 19},
	{"QueWrAddr", 0, 13},
	{"UP_IBQ_0_STATUS", 0x18, 0},
	{"QueErrFrame", 31, 1},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_0_PKTCNT", 0x1c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_1_RDADDR", 0x20, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_1_WRADDR", 0x24, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_1_STATUS", 0x28, 0},
	{"QueErrFrame", 31, 1},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_1_PKTCNT", 0x2c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_2_RDADDR", 0x30, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_2_WRADDR", 0x34, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_2_STATUS", 0x38, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_2_PKTCNT", 0x3c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_3_RDADDR", 0x40, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_3_WRADDR", 0x44, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_3_STATUS", 0x48, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_3_PKTCNT", 0x4c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_4_RDADDR", 0x50, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_4_WRADDR", 0x54, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_4_STATUS", 0x58, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_4_PKTCNT", 0x5c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_5_RDADDR", 0x60, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_5_WRADDR", 0x64, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_5_STATUS", 0x68, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_5_PKTCNT", 0x6c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_0_RDADDR", 0x70, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_0_WRADDR", 0x74, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_0_STATUS", 0x78, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_0_PKTCNT", 0x7c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_80_to_fc[] = {
	{"UP_OBQ_1_RDADDR", 0x80, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_1_WRADDR", 0x84, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_1_STATUS", 0x88, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_1_PKTCNT", 0x8c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_2_RDADDR", 0x90, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_2_WRADDR", 0x94, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_2_STATUS", 0x98, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_2_PKTCNT", 0x9c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_3_RDADDR", 0xa0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_3_WRADDR", 0xa4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_3_STATUS", 0xa8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_3_PKTCNT", 0xac, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_4_RDADDR", 0xb0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_4_WRADDR", 0xb4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_4_STATUS", 0xb8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_4_PKTCNT", 0xbc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_5_RDADDR", 0xc0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_5_WRADDR", 0xc4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_5_STATUS", 0xc8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_5_PKTCNT", 0xcc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_0_CONFIG", 0xd0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"Que1KEn", 6, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_0_REALADDR", 0xd4, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_1_CONFIG", 0xd8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"Que1KEn", 6, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_1_REALADDR", 0xdc, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_2_CONFIG", 0xe0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"Que1KEn", 6, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_2_REALADDR", 0xe4, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_3_CONFIG", 0xe8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"Que1KEn", 6, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_3_REALADDR", 0xec, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_4_CONFIG", 0xf0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"Que1KEn", 6, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_4_REALADDR", 0xf4, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_5_CONFIG", 0xf8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"Que1KEn", 6, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_5_REALADDR", 0xfc, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_80_to_fc[] = {
	{"UP_OBQ_1_RDADDR", 0x80, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_1_WRADDR", 0x84, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_1_STATUS", 0x88, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_1_PKTCNT", 0x8c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_2_RDADDR", 0x90, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_2_WRADDR", 0x94, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_2_STATUS", 0x98, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_2_PKTCNT", 0x9c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_3_RDADDR", 0xa0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_3_WRADDR", 0xa4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_3_STATUS", 0xa8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_3_PKTCNT", 0xac, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_4_RDADDR", 0xb0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_4_WRADDR", 0xb4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_4_STATUS", 0xb8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_4_PKTCNT", 0xbc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_5_RDADDR", 0xc0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_5_WRADDR", 0xc4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_5_STATUS", 0xc8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_5_PKTCNT", 0xcc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_0_CONFIG", 0xd0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_0_REALADDR", 0xd4, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_1_CONFIG", 0xd8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_1_REALADDR", 0xdc, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_2_CONFIG", 0xe0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_2_REALADDR", 0xe4, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_3_CONFIG", 0xe8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_3_REALADDR", 0xec, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_4_CONFIG", 0xf0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_4_REALADDR", 0xf4, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_5_CONFIG", 0xf8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_5_REALADDR", 0xfc, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_100_to_14c[] = {
	{"UP_OBQ_0_CONFIG", 0x100, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_0_REALADDR", 0x104, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_1_CONFIG", 0x108, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_1_REALADDR", 0x10c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_2_CONFIG", 0x110, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_2_REALADDR", 0x114, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_3_CONFIG", 0x118, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_3_REALADDR", 0x11c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_4_CONFIG", 0x120, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_4_REALADDR", 0x124, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_5_CONFIG", 0x128, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_5_REALADDR", 0x12c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_MAILBOX_STATUS", 0x130, 0},
	{"MBGen0", 31, 20},
	{"GenTimerTrig", 19, 16},
	{"MBGen1", 8, 8},
	{"MBPFInt", 0, 8},
	{"UP_UP_DBG_LA_CFG", 0x140, 0},
	{"UpDbgLaCaptBub", 31, 1},
	{"UpDbgLaCaptPCOnly", 30, 1},
	{"UpDbgLaMaskStop", 29, 1},
	{"UpDbgLaMaskTrig", 28, 1},
	{"UpDbgLaWrPtr", 16, 12},
	{"UpDbgLaBusy", 14, 1},
	{"UpDbgLaRdPtr", 2, 12},
	{"UpDbgLaRdEn", 1, 1},
	{"UpDbgLaEn", 0, 1},
	{"UP_UP_DBG_LA_DATA", 0x144, 0},
	{"UpDbgLaWrData", 0, 32},
	{"UP_PIO_MST_CONFIG", 0x148, 0},
	{"ReqVFVld", 27, 1},
	{"FLSrc", 24, 3},
	{"SEProt", 23, 1},
	{"SESrc", 20, 3},
	{"UpRgn", 19, 1},
	{"UpPF", 16, 3},
	{"UpRID", 8, 8},
	{"UP_UP_SELF_CONTROL", 0x14c, 0},
	{"UpSelfReset", 0, 1},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_100_to_14c[] = {
	{"UP_OBQ_0_CONFIG", 0x100, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_0_REALADDR", 0x104, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_1_CONFIG", 0x108, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_1_REALADDR", 0x10c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_2_CONFIG", 0x110, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_2_REALADDR", 0x114, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_3_CONFIG", 0x118, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_3_REALADDR", 0x11c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_4_CONFIG", 0x120, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_4_REALADDR", 0x124, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_5_CONFIG", 0x128, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_5_REALADDR", 0x12c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_MAILBOX_STATUS", 0x130, 0},
	{"MBGen0", 31, 20},
	{"GenTimerTrig", 19, 16},
	{"MBGen1", 8, 8},
	{"MBPFInt", 0, 8},
	{"UP_UP_DBG_LA_CFG", 0x140, 0},
	{"UpDbgLaCaptBub", 31, 1},
	{"UpDbgLaCaptPCOnly", 30, 1},
	{"UpDbgLaMaskStop", 29, 1},
	{"UpDbgLaMaskTrig", 28, 1},
	{"UpDbgLaWrPtr", 16, 12},
	{"UpDbgLaBusy", 14, 1},
	{"UpDbgLaRdPtr", 2, 12},
	{"UpDbgLaRdEn", 1, 1},
	{"UpDbgLaEn", 0, 1},
	{"UP_UP_DBG_LA_DATA", 0x144, 0},
	{"UpDbgLaWrData", 0, 32},
	{"UP_PIO_MST_CONFIG", 0x148, 0},
	{"ReqVFVld", 27, 1},
	{"FLSrc", 24, 3},
	{"SEProt", 23, 1},
	{"SESrc", 20, 3},
	{"UpRgn", 19, 1},
	{"UpPF", 16, 3},
	{"RSVD", 8, 8},
	{"UpRID", 0, 8},
	{"UP_UP_SELF_CONTROL", 0x14c, 0},
	{"UpSelfReset", 0, 1},
	{ NULL }
};

static struct cudbg_reg_info t6_up_cim_200_to_23c[] = {
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_RDY", 0x200, 0},
	{"TSCHCHNLCRDY", 0, 32},
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_WATCH_RDY", 0x204, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_WATCH_LIST", 0x208, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_TAKE", 0x20c, 0},
	{"TSCHCHNLCHDIS", 31, 1},
	{"TSCHCHNLWDIS", 30, 1},
	{"TSCHCHNLCLDIS", 29, 1},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_RDY", 0x210, 0},
	{"TSCHCHNLCRDY", 0, 32},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_WATCH_RDY", 0x214, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_WATCH_LIST", 0x218, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_TAKE", 0x21c, 0},
	{"TSCHCHNLCHDIS", 31, 1},
	{"TSCHCHNLWDIS", 30, 1},
	{"TSCHCHNLCLDIS", 29, 1},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_RDY", 0x220, 0},
	{"TSCHCHNLCRDY", 0, 32},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_WATCH_RDY", 0x224, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_WATCH_LIST", 0x228, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_TAKE", 0x22c, 0},
	{"TSCHCHNLCHDIS", 31, 1},
	{"TSCHCHNLWDIS", 30, 1},
	{"TSCHCHNLCLDIS", 29, 1},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_RDY", 0x230, 0},
	{"TSCHCHNLCRDY", 0, 32},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_WATCH_RDY", 0x234, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_WATCH_LIST", 0x238, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_TAKE", 0x23c, 0},
	{"TSCHCHNLCHDIS", 31, 1},
	{"TSCHCHNLWDIS", 30, 1},
	{"TSCHCHNLCLDIS", 29, 1},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_200_to_23c[] = {
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_RDY", 0x200, 0},
	{"ECO_15444_SGE_DB_BUSY", 31, 1},
	{"ECO_15444_PL_INTF_BUSY", 30, 1},
	{"TSCHCHNLCRDY", 0, 30},
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_WATCH_RDY", 0x204, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_WATCH_LIST", 0x208, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL0_TSCH_CHNLn_CLASS_TAKE", 0x20c, 0},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_RDY", 0x210, 0},
	{"ECO_15444_SGE_DB_BUSY", 31, 1},
	{"ECO_15444_PL_INTF_BUSY", 30, 1},
	{"TSCHCHNLCRDY", 0, 30},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_WATCH_RDY", 0x214, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_WATCH_LIST", 0x218, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL1_TSCH_CHNLn_CLASS_TAKE", 0x21c, 0},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_RDY", 0x220, 0},
	{"ECO_15444_SGE_DB_BUSY", 31, 1},
	{"ECO_15444_PL_INTF_BUSY", 30, 1},
	{"TSCHCHNLCRDY", 0, 30},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_WATCH_RDY", 0x224, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_WATCH_LIST", 0x228, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL2_TSCH_CHNLn_CLASS_TAKE", 0x22c, 0},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_RDY", 0x230, 0},
	{"ECO_15444_SGE_DB_BUSY", 31, 1},
	{"ECO_15444_PL_INTF_BUSY", 30, 1},
	{"TSCHCHNLCRDY", 0, 30},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_WATCH_RDY", 0x234, 0},
	{"TSCHWRRLIMIT", 16, 16},
	{"TSCHCHNLCWRDY", 0, 16},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_WATCH_LIST", 0x238, 0},
	{"TSCHWRRRELOAD", 16, 16},
	{"TSCHCHNLCWATCH", 0, 16},
	{"UP_TSCH_CHANNEL3_TSCH_CHNLn_CLASS_TAKE", 0x23c, 0},
	{"TSCHCHNLCNUM", 24, 5},
	{"TSCHCHNLCCNT", 0, 24},
	{ NULL }

};

static struct cudbg_reg_info t5_up_cim_240_to_244[] = {
	{"UP_UpLaDbgPcChkData_0", 0x240, 0},
	{"UpLaPcData", 0, 32},
	{"UP_UpLaDbgPcChkMask_0", 0x244, 0},
	{"UpLaPcMask", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_250_to_254[] = {
	{"UP_UpLaDbgPcChkData_1", 0x250, 0},
	{"UpLaPcData", 0, 32},
	{"UP_UpLaDbgPcChkMask_1", 0x254, 0},
	{"UpLaPcMask", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_260_to_264[] = {
	{"UP_UpLaDbgPcChkData_2", 0x260, 0},
	{"UpLaPcData", 0, 32},
	{"UP_UpLaDbgPcChkMask_2", 0x264, 0},
	{"UpLaPcMask", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_270_to_274[] = {
	{"UP_UpLaDbgPcChkData_3", 0x270, 0},
	{"UpLaPcData", 0, 32},
	{"UP_UpLaDbgPcChkMask_3", 0x274, 0},
	{"UpLaPcMask", 0, 32},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_280_to_2fc[] = {
	{"UP_IBQ_0_SHADOW_RDADDR", 0x280, 0},
	{"QueID", 13, 19},
	{"QueRdAddr", 0, 13},
	{"UP_IBQ_0_SHADOW_WRADDR", 0x284, 0},
	{"QueID", 13, 19},
	{"QueWrAddr", 0, 13},
	{"UP_IBQ_0_SHADOW_STATUS", 0x288, 0},
	{"QueErrFrame", 31, 1},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_0_SHADOW_PKTCNT", 0x28c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_1_SHADOW_RDADDR", 0x290, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_1_SHADOW_WRADDR", 0x294, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_1_SHADOW_STATUS", 0x298, 0},
	{"QueErrFrame", 31, 1},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_1_SHADOW_PKTCNT", 0x29c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_2_SHADOW_RDADDR", 0x2a0, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_2_SHADOW_WRADDR", 0x2a4, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_2_SHADOW_STATUS", 0x2a8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_2_SHADOW_PKTCNT", 0x2ac, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_3_SHADOW_RDADDR", 0x2b0, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_3_SHADOW_WRADDR", 0x2b4, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_3_SHADOW_STATUS", 0x2b8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_3_SHADOW_PKTCNT", 0x2bc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_4_SHADOW_RDADDR", 0x2c0, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_4_SHADOW_WRADDR", 0x2c4, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_4_SHADOW_STATUS", 0x2c8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_4_SHADOW_PKTCNT", 0x2cc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_5_SHADOW_RDADDR", 0x2d0, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_5_SHADOW_WRADDR", 0x2d4, 0},
	{"QueID", 13, 19},
	{"UP_IBQ_5_SHADOW_STATUS", 0x2d8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_IBQ_5_SHADOW_PKTCNT", 0x2dc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_0_SHADOW_RDADDR", 0x2e0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_0_SHADOW_WRADDR", 0x2e4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_0_SHADOW_STATUS", 0x2e8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_0_SHADOW_PKTCNT", 0x2ec, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_1_SHADOW_RDADDR", 0x2f0, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_1_SHADOW_WRADDR", 0x2f4, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_1_SHADOW_STATUS", 0x2f8, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_1_SHADOW_PKTCNT", 0x2fc, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_300_to_37c[] = {
	{"UP_OBQ_2_SHADOW_RDADDR", 0x300, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_2_SHADOW_WRADDR", 0x304, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_2_SHADOW_STATUS", 0x308, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_2_SHADOW_PKTCNT", 0x30c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_3_SHADOW_RDADDR", 0x310, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_3_SHADOW_WRADDR", 0x314, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_3_SHADOW_STATUS", 0x318, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_3_SHADOW_PKTCNT", 0x31c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_4_SHADOW_RDADDR", 0x320, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_4_SHADOW_WRADDR", 0x324, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_4_SHADOW_STATUS", 0x328, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_4_SHADOW_PKTCNT", 0x32c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_5_SHADOW_RDADDR", 0x330, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_5_SHADOW_WRADDR", 0x334, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_5_SHADOW_STATUS", 0x338, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_5_SHADOW_PKTCNT", 0x33c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_6_SHADOW_RDADDR", 0x340, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_6_SHADOW_WRADDR", 0x344, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_6_SHADOW_STATUS", 0x348, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_6_SHADOW_PKTCNT", 0x34c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_OBQ_7_SHADOW_RDADDR", 0x350, 0},
	{"QueID", 15, 17},
	{"QueRdAddr", 0, 15},
	{"UP_OBQ_7_SHADOW_WRADDR", 0x354, 0},
	{"QueID", 15, 17},
	{"QueWrAddr", 0, 15},
	{"UP_OBQ_7_SHADOW_STATUS", 0x358, 0},
	{"QueRemFlits", 0, 11},
	{"UP_OBQ_7_SHADOW_PKTCNT", 0x35c, 0},
	{"QueEOPCnt", 16, 12},
	{"QueSOPCnt", 0, 12},
	{"UP_IBQ_0_SHADOW_CONFIG", 0x360, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_0_SHADOW_REALADDR", 0x364, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_1_SHADOW_CONFIG", 0x368, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_1_SHADOW_REALADDR", 0x36c, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_2_SHADOW_CONFIG", 0x370, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_2_SHADOW_REALADDR", 0x374, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_3_SHADOW_CONFIG", 0x378, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_3_SHADOW_REALADDR", 0x37c, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{ NULL }
};

static struct cudbg_reg_info t5_up_cim_380_to_3cc[] = {
	{"UP_IBQ_4_SHADOW_CONFIG", 0x380, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_4_SHADOW_REALADDR", 0x384, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_IBQ_5_SHADOW_CONFIG", 0x388, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_IBQ_5_SHADOW_REALADDR", 0x38c, 0},
	{"QueRdAddrWrap", 31, 1},
	{"QueWrAddrWrap", 30, 1},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_0_SHADOW_CONFIG", 0x390, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_0_SHADOW_REALADDR", 0x394, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_1_SHADOW_CONFIG", 0x398, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_1_SHADOW_REALADDR", 0x39c, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_2_SHADOW_CONFIG", 0x3a0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_2_SHADOW_REALADDR", 0x3a4, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_3_SHADOW_CONFIG", 0x3a8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_3_SHADOW_REALADDR", 0x3ac, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_4_SHADOW_CONFIG", 0x3b0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_4_SHADOW_REALADDR", 0x3b4, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_5_SHADOW_CONFIG", 0x3b8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_5_SHADOW_REALADDR", 0x3bc, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_6_SHADOW_CONFIG", 0x3c0, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_6_SHADOW_REALADDR", 0x3c4, 0},
	{"QueMemAddr", 3, 11},
	{"UP_OBQ_7_SHADOW_CONFIG", 0x3c8, 0},
	{"QueSize", 26, 6},
	{"QueBase", 8, 6},
	{"QueDbg8BEn", 7, 1},
	{"QueBareAddr", 0, 1},
	{"UP_OBQ_7_SHADOW_REALADDR", 0x3cc, 0},
	{"QueMemAddr", 3, 11},
	{ NULL }
};

static struct cudbg_reg_info *t6_tp_pio_ptr[] = {
	t6_tp_pio_regs_20_to_3b,
	t6_tp_pio_regs_40_to_49,
	t6_tp_pio_regs_50_to_59,
	t6_tp_pio_regs_60_to_6d,
	t6_tp_pio_regs_6f,
	t6_tp_pio_regs_70_to_75,
	t6_tp_pio_regs_130_to_141,
	t6_tp_pio_regs_145_to_157,
	t6_tp_pio_regs_160,
	t6_tp_pio_regs_230_to_248,
	t6_tp_pio_regs_24c,
	t6_tp_pio_regs_8c0
};

static struct cudbg_reg_info *t5_tp_pio_ptr[] = {
	t5_tp_pio_regs_20_to_3b,
	t5_tp_pio_regs_40_to_52,
	t5_tp_pio_regs_54_to_55,
	t5_tp_pio_regs_60_to_6c,
	t5_tp_pio_regs_6f,
	t5_tp_pio_regs_120_to_123,
	t5_tp_pio_regs_12b_to_12c,
	t5_tp_pio_regs_12f_to_143,
	t5_tp_pio_regs_145_to_157,
	t5_tp_pio_regs_230_to_248,
	t5_tp_pio_regs_8c0
};

static struct cudbg_reg_info *t5_pm_tx_ptr[] = {
	t5_pm_tx_regs_10000_to_10020,
	t5_pm_tx_regs_10021_to_1003c,
};

static struct cudbg_reg_info *t5_pm_rx_ptr[] = {
	t5_pm_rx_regs_10000_to_10020,
	t5_pm_rx_regs_10021_to_1002c,
};

static struct cudbg_reg_info *t5_pcie_pdbg_ptr[] = {
	t5_pcie_pdbg_regs_00_to_20,
	t5_pcie_pdbg_regs_21_to_40,
	t5_pcie_pdbg_regs_41_to_50,
};

static struct cudbg_reg_info *t5_pcie_config_ptr[] = {
	t5_pcie_config_regs_00_to_208,
};

static struct cudbg_reg_info *t5_pcie_cdbg_ptr[] = {
	t5_pcie_cdbg_regs_00_to_20,
	t5_pcie_cdbg_regs_21_to_37,
};

static struct cudbg_reg_info *t6_hma_ptr[] = {
	t6_hma_regs_a000_to_a01f,
};

static struct cudbg_reg_info *t6_ma_ptr[] = {
	t6_ma_regs_a000_to_a016,
	t6_ma_regs_a400_to_a41e,
	t6_ma_regs_a800_to_a813,
	t6_ma_regs_e400_to_e600,
	t6_ma_regs_e640_to_e7c0,
};

static struct cudbg_reg_info *t6_up_cim_reg_ptr[] = {
	t6_up_cim_2000_to_207c,
	t6_up_cim_2080_to_20fc,
	t5_up_cim_00_to_7c,
	t6_up_cim_80_to_fc,
	t6_up_cim_100_to_14c,
	t6_up_cim_200_to_23c,
	t5_up_cim_240_to_244,
	t5_up_cim_250_to_254,
	t5_up_cim_260_to_264,
	t5_up_cim_270_to_274,
	t5_up_cim_280_to_2fc,
	t5_up_cim_300_to_37c,
	t5_up_cim_380_to_3cc,
	t6_up_cim_4900_to_4c60,
	t6_up_cim_4904_to_4c64,
	t6_up_cim_4908_to_4c68,
	t6_up_cim_4910_to_4c70,
	t6_up_cim_4914_to_4c74,
	t6_up_cim_4920_to_4a10,
	t6_up_cim_4924_to_4a14,
	t6_up_cim_4928_to_4a18,
	t6_up_cim_492c_to_4a1c,
};

static struct cudbg_reg_info *t5_up_cim_reg_ptr[] = {
	t5_up_cim_2000_to_207c,
	t5_up_cim_2080_to_20ec,
	t5_up_cim_00_to_7c,
	t5_up_cim_80_to_fc,
	t5_up_cim_100_to_14c,
	t5_up_cim_200_to_23c,
	t5_up_cim_240_to_244,
	t5_up_cim_250_to_254,
	t5_up_cim_260_to_264,
	t5_up_cim_270_to_274,
	t5_up_cim_280_to_2fc,
	t5_up_cim_300_to_37c,
	t5_up_cim_380_to_3cc,
};

#define TP_TM_PIO_ADDR		A_TP_TM_PIO_ADDR
#define TP_MIB_INDEX		A_TP_MIB_INDEX
#define TP_PIO			A_TP_PIO_ADDR
#define PM_RX_INDIRECT		A_PM_RX_STAT_LSB
#define PM_TX_INDIRECT		A_PM_TX_STAT_LSB
#define PCIE_CDEBUG_INDIRECT	A_PCIE_CDEBUG_INDEX
#define PCIE_PDEBUG_INDIRECT	A_PCIE_PDEBUG_INDEX
#define SGE_DEBUG_DATA_INDIRECT A_SGE_DEBUG_INDEX

#endif
