#
# This file and its contents are supplied under the terms of the
# Common Development and Distribution License ("CDDL"), version 1.0.
# You may only use this file in accordance with the terms of version
# 1.0 of the CDDL.
#
# A full copy of the text of the CDDL should have accompanied this
# source.  A copy of the CDDL is also available via the Internet at
# http://www.illumos.org/license/CDDL.
#

#
# Copyright 2021 OmniOS Community Edition (OmniOSce) Association.
#

#
# Test whether ksh mishandles a heredoc that spans a 8K chunk and has
# a backslash as the last character of the first chunk.
# See https://www.illumos.org/issues/13434
#

# test setup
function err_exit
{
	print -u2 -n "\t"
	print -u2 -r ${Command}[$1]: "${@:2}"
	(( Errors++ ))
}
alias err_exit='err_exit $LINENO'

set -o nounset
Command=${0##*/}
integer Errors=0

# .........................................................................
# This comment introduces the correct number of padding characters to that
# the \ in the second heredoc below occurs at byte position 8192 of the
# script.
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................................
# .........................................................

t1=`mktemp`
t2=`mktemp`
if [[ ! -f "$t1" || ! -f "$t2" ]]; then
	# Don't use the global err _ exit function as the test harness uses
	# calls to that to compute the number of tests present in this file.
	echo "Could not create temporary files"
	exit 1
fi

cat > "$t1" << EOF
\$
EOF
cat > "$t2" << EOF
\$
EOF

if ! cmp -s "$t1" "$t2"; then
	err_exit "Shell truncates heredoc over chunk boundary"
	#/bin/od -t x1 "$t1"
	#/bin/od -t x1 "$t2"
fi

rm -f "$t1" "$t2"

# tests done
exit $Errors
