/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2021 OmniOS Community Edition (OmniOSce) Association.
 */

#ifndef _ILLUMOS_KSH_CMDLIST_H
#define	_ILLUMOS_KSH_CMDLIST_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * List builtins for illumos.
 * The list here is partially autogenerated and partially hand-picked
 * based on compatibility with the native illumos versions of these
 * tools
 */

/*
 * Commands which are 100% compatible with native illumos versions (/bin is
 * a softlink to ./usr/bin, ksh93 takes care of the lookup)
 */
#define	BINCMDLIST(f)	\
	{ "/bin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	USRBINCMDLIST(f)	\
	{ "/usr/bin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	SBINCMDLIST(f)	\
	{ "/sbin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	SUSRBINCMDLIST(f)	\
	{ "/usr/sbin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
/* POSIX compatible commands */
#define	XPG6CMDLIST(f)	\
	{ "/usr/xpg6/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	XPG4CMDLIST(f)	\
	{ "/usr/xpg4/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#ifdef SHOPT_USR_GNU_BIN_BUILTINS
/* GNU coreutils compatible commands */
#define	GNUCMDLIST(f)	\
	{ "/usr/gnu/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#else
#define	GNUCMDLIST(f)
#endif
/*
 * Make all ksh93 builtins accessible when /usr/ast/bin was added to
 * /usr/xpg6/bin:/usr/xpg4/bin:/usr/ccs/bin:/usr/bin:/bin:/opt/SUNWspro/bin
 */
#define	ASTCMDLIST(f)	\
	{ "/usr/ast/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },

/* undo ast_map.h #defines to avoid collision */
#undef basename
#undef dirname
#undef mktemp

/* Generated data, do not edit. */
ASTCMDLIST(basename)
GNUCMDLIST(basename)
XPG4CMDLIST(basename)
ASTCMDLIST(cat)
BINCMDLIST(cat)
ASTCMDLIST(chgrp)
// XPG4CMDLIST(chgrp)
ASTCMDLIST(chmod)
ASTCMDLIST(chown)
// XPG4CMDLIST(chown)
// BINCMDLIST(chown)
ASTCMDLIST(cksum)
BINCMDLIST(cksum)
GNUCMDLIST(cksum)
ASTCMDLIST(cmp)
BINCMDLIST(cmp)
ASTCMDLIST(comm)
BINCMDLIST(comm)
GNUCMDLIST(comm)
ASTCMDLIST(cp)
// XPG4CMDLIST(cp)
ASTCMDLIST(cut)
BINCMDLIST(cut)
GNUCMDLIST(cut)
ASTCMDLIST(date)
// XPG4CMDLIST(date)
ASTCMDLIST(dirname)
BINCMDLIST(dirname)
GNUCMDLIST(dirname)
ASTCMDLIST(expr)
GNUCMDLIST(expr)
XPG6CMDLIST(expr)
ASTCMDLIST(fds)
ASTCMDLIST(fmt)
ASTCMDLIST(fold)
BINCMDLIST(fold)
GNUCMDLIST(fold)
ASTCMDLIST(head)
BINCMDLIST(head)
ASTCMDLIST(id)
XPG4CMDLIST(id)
ASTCMDLIST(join)
BINCMDLIST(join)
GNUCMDLIST(join)
ASTCMDLIST(ln)
// XPG4CMDLIST(ln)
ASTCMDLIST(logname)
BINCMDLIST(logname)
GNUCMDLIST(logname)
ASTCMDLIST(md5sum)
ASTCMDLIST(mkdir)
BINCMDLIST(mkdir)
GNUCMDLIST(mkdir)
ASTCMDLIST(mkfifo)
BINCMDLIST(mkfifo)
GNUCMDLIST(mkfifo)
ASTCMDLIST(mktemp)
BINCMDLIST(mktemp)
GNUCMDLIST(mktemp)
ASTCMDLIST(mv)
// XPG4CMDLIST(mv)
ASTCMDLIST(paste)
BINCMDLIST(paste)
GNUCMDLIST(paste)
ASTCMDLIST(pathchk)
BINCMDLIST(pathchk)
GNUCMDLIST(pathchk)
ASTCMDLIST(rev)
BINCMDLIST(rev)
ASTCMDLIST(rm)
XPG4CMDLIST(rm)
ASTCMDLIST(rmdir)
BINCMDLIST(rmdir)
GNUCMDLIST(rmdir)
GNUCMDLIST(sleep)
ASTCMDLIST(stty)
// XPG4CMDLIST(stty)
ASTCMDLIST(sum)
BINCMDLIST(sum)
ASTCMDLIST(sync)
BINCMDLIST(sync)
GNUCMDLIST(sync)
SBINCMDLIST(sync)
SUSRBINCMDLIST(sync)
ASTCMDLIST(tail)
BINCMDLIST(tail)
XPG4CMDLIST(tail)
ASTCMDLIST(tee)
BINCMDLIST(tee)
GNUCMDLIST(tee)
ASTCMDLIST(tty)
BINCMDLIST(tty)
GNUCMDLIST(tty)
ASTCMDLIST(uname)
ASTCMDLIST(uniq)
BINCMDLIST(uniq)
GNUCMDLIST(uniq)
ASTCMDLIST(wc)
BINCMDLIST(wc)
GNUCMDLIST(wc)

/* Mandatory for ksh93 test suite and AST scripts */
BINCMDLIST(getconf)

#ifdef	__cplusplus
}
#endif

#endif /* !_ILLUMOS_KSH_CMDLIST_H */
