# Coursebook

[![Build Status](https://github.com/illinois-cs241/coursebook/actions/workflows/deploy.yaml/badge.svg?branch=master)](https://github.com/illinois-cs241/coursebook/actions/workflows/deploy.yaml)
[![Current Pdf Link](https://img.shields.io/badge/current-pdf-blue.svg)](https://github.com/illinois-cs241/coursebook/blob/pdf_deploy/main.pdf)
[![Current Wiki Link](https://img.shields.io/badge/current-wiki-blue.svg)](https://github.com/illinois-cs241/coursebook/wiki)
[![Current HTML Link](https://img.shields.io/badge/current-html-blue.svg)](http://cs341.cs.illinois.edu/coursebook/index.html)
[![Current Epub Link](https://img.shields.io/badge/current-epub-blue.svg)](https://github.com/illinois-cs241/coursebook/blob/epub_deploy/main.epub)

<p align="center">
    <img src="_images/duck-alpha-cropped.png" width="50%"/>
</p>

Welcome to the systems programming coursebook!
This repository houses a high-quality, open-source introductory systems programming textbook used by the [CS 341: System Programming](http://cs341.cs.illinois.edu/) course at the [University of Illinois at Urbana-Champaign](https://illinois.edu/)
The book assumes that you have taken a programming language course and are familiar with assembly instructions.
All of the code and instruction will be in C, as it is the de-facto language of the Linux Kernel.

The Coursebook is an aim to standardize and build upon Angrave's [original wikibook experiment](https://github.com/angrave/SystemProgramming/wiki).

The most recent version of the coursebook as a single pdf is here: [main.pdf](https://github.com/illinois-cs241/coursebook/blob/pdf_deploy/main.pdf).

## Overview

### Goals

* Improve the quality and rigour of the original wikibook while maintaining openness.
* Improve the factualness by including citations, footnotes, extended reading, and a glossary.
* Have exports in the form of pdf, markdown, and html.
* Automagically build so writers can focus on writing.

## Contributing, Building, and Structure

Read `CONTRIBUTING.md`

## Credit Where Credit is Due

* Title Page Idea Inspiration - https://tex.stackexchange.com/questions/85904/showcase-of-beautiful-title-page-done-in-tex
* Duck Image Inspiration - https://pixabay.com/photos/toy-bath-rubber-duck-studio-1474138/
* Chapter Style Inspiration - https://texblog.org/2012/07/03/fancy-latex-chapter-styles/
* PDF Image Inspiration - https://pixabay.com/illustrations/pdf-miniature-file-icon-2127829/
