﻿<%@ Page PathInChannel="index{Page}{Ext}" %>
<%@ OutputCache Duration="3600" VaryByParam="none" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="keywords" content="<%=MetaKeywords%>" />
<meta name="description" content="<%=MetaDescription%>" />
<title><%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" type="text/css" href="<%=CssPath%>common.css" />
<script type="text/javascript">
var _webPath = "<%=WebPath%>";
var _isNeedToCheck = <%=Config[IsNeedToCheck]%>;
var _lang_name_empty = "名称不能空！";
var _lang_subject_empty = "主题不能空！";
var _lang_content_empty = "内容不能空！";
var _lang_qq_not_correct = "QQ号格式不正确！";
var _lang_email_not_correct = "Email地址格式不正确！";
var _lang_fail = "留言失败！";
var _lang_success = "留言成功！";
</script>
</head>
<body>
<%If String.IsNullOrEmpty(Site[Logo])%>
	<!-- TemplateBeginEditable name="广告位：Banner" -->
	<ilghar:Ad Guid="{099A2FEC-2278-4b03-BC08-A3C1FC3ADC66}">
		<a href="http://www.ilghar.cn"><img src="<%=ImagePath%>ad/banner.gif" alt="Ad" style="width:990px;height:150px" /></a>
	</ilghar:Ad>
	<!-- TemplateEndEditable -->
<%Else%>
	<div class="Header">
		<ul>
			<li class="Left"><img src="<%=Site[Logo]%>" alt="<%=Site[Name]%>" /></li>
			<li class="Right"><%=Site[Name]%></li>
		</ul>
	</div>
<%EndIf%>

<!-- TemplateBeginEditable name="主菜单" -->
<ilghar:Menu Condition="IsDisplay=true and CategoryID IS NULL and ParentID IS NULL">
	<div class="Menu">
		<div class="Left"></div>
		<div class="Middle">
			<ilghar:Record>
				<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
				<ilghar:Separator> | </ilghar:Separator>
			</ilghar:Record>
		</div>
		<div class="Right"></div>
	</div>
</ilghar:Menu>
<!-- TemplateEndEditable -->

<div class="Wrap">
	<div class="Block1">
		<!-- TemplateBeginEditable name="网站公告" -->
		<h1>网站公告</h1>
		<div class="Block4"><%=Notice%></div>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="最新产品" -->
		<ilghar:List Mark="Shop" Object="Goods" Page="1" PageSize="10" Condition="IsDeleted=false and IsReleased=true" Sort="UpdateTime DESC">
			<h1>最新产品</h1>
			<ul class="List3">
				<ilghar:Record>
					<li><a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>" /></a><br />
						<a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><%=Name%></a>
					</li>
				</ilghar:Record>
			</ul>
		</ilghar:List>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="友情连接" -->
		<ilghar:List Mark="System" Object="Link" Condition="IsChecked=true">
			<h1>友情连接</h1>
			<div class="Link">
				<ilghar:Record>
					<a href="<%=URL%>" title="<%=Name%>" target="_blank"><img src="<%=Logo%>" alt="<%=Name%>" /></a><br />
				</ilghar:Record>
			</div>
		</ilghar:List>
		<!-- TemplateEndEditable -->
	</div>
	<div class="Block2">
		<!-- TemplateBeginEditable name="路径" -->
		<div class="Path">
			你的位置：
			<ilghar:Path>
				<ilghar:Record>
					<a href="<%=URL%>"><%=Name%></a> &gt;
				</ilghar:Record>
			</ilghar:Path>
			<%=Channel[Name]%>
		</div>
		<!-- TemplateEndEditable -->

		<div class="Block7">
			<div class="Left"><a href="#write" class="Bold">我要留言</a></div>
			<div class="Right">
				<!-- TemplateBeginEditable name="分页" -->
				<ilghar:Pagination ID="Pagination" Page="PageNumber" PageSize="5" RecordCount="List[RecordCount]">
					<div class="Pagination">
						<ilghar:FirstPage>
							<ilghar:Yes>
								<span class="Disabled"> &lt;&lt; </span>
								<span class="Disabled"> &lt; </span>
							</ilghar:Yes>
							<ilghar:No>
								<a href="<%=FirstPage%>"> &lt;&lt; </a>
								<a href="<%=PreviousPage%>"> &lt; </a>
							</ilghar:No>
						</ilghar:FirstPage>
						<ilghar:CurrentPage Range="5">
							<ilghar:Yes>
								<span class="Select"><%=Index%></span>
							</ilghar:Yes>
							<ilghar:No>
								<a href="<%=URL%>"><%=Index%></a>
							</ilghar:No>
						</ilghar:CurrentPage>
						<ilghar:LastPage>
							<ilghar:Yes>
								<span class="Disabled"> &gt;&gt; </span>
								<span class="Disabled"> &gt; </span>
							</ilghar:Yes>
							<ilghar:No>
								<a href="<%=NextPage%>"> &gt; </a>
								<a href="<%=LastPage%>"> &gt;&gt; </a>
							</ilghar:No>
						</ilghar:LastPage>
					</div>
				</ilghar:Pagination>
				<!-- TemplateEndEditable -->
			</div>
		</div>

		<!-- TemplateBeginEditable name="列表" -->
		<ilghar:List ID="List" Object="GuestBook" Page="PageNumber" PageSize="5">
			<ilghar:Record>
				<table border="0" align="center" cellpadding="15" cellspacing="1">
					<tr>
						<th>
							<div><img src="<%=Head%>" alt="<%=Name%>" /></div>
							<span>姓名：</span><%=Name%><br />
							<span>Email：</span><%=Email%><br />
							<span>QQ：</span><%=QQ%><br />
							[发表于：<%=CreateTime%>]
						</th>
						<td>
							<div class="Block8">主题：<%=Subject%></div>
								&nbsp;&nbsp;&nbsp;&nbsp;<pre><%=HttpUtility.HtmlEncode(Convert.ToString(Content))%></pre>
							<%If Convert.ToString(Reply) != ""%>
								<div class="Block9">
									<span>站长回复：</span><br />
									<pre><%=Reply%></pre>
								</div>
							<%EndIf%>
						</td>
					</tr>
				</table>
			</ilghar:Record>
		</ilghar:List>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="表单" -->
		<form action="">
			<table border="0" cellpadding="4" cellspacing="1">
				<thead>
					<tr>
						<td colspan="2">注意：带 <span>* </span>为必填项！<a name="write"></a></td>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td colspan="2"><input type="submit" value="提交" class="<%=PageLang%>Font" /></td>
					</tr>
				</tfoot>
				<tbody>
					<tr>
						<th><span>* </span>姓名：</th>
						<td><input type="text"  name="Name"size="25" maxlength="50" class="<%=PageLang%>Font" /></td>
					</tr>
					<tr>
						<th>QQ：</th>
						<td><input type="text" name="QQ" size="25" maxlength="50" class="CHSFont" /></td>
					</tr>
					<tr>
						<th>Email：</th>
						<td><input type="text" name="Email" size="25" maxlength="255" class="CHSFont" /></td>
					</tr>
					<tr>
						<th>头像：</th>
						<td height="100">
							<select name="Head" class="CHSFont">
								<option>01</option>
								<option>02</option>
								<option>03</option>
								<option>04</option>
								<option>05</option>
								<option>06</option>
								<option>07</option>
								<option>08</option>
								<option>09</option>
								<option>10</option>
								<option>11</option>
								<option>12</option>
								<option>13</option>
								<option>14</option>
								<option>15</option>
								<option>16</option>
								<option>17</option>
								<option>18</option>
								<option>19</option>
								<option>20</option>
							</select>
							<img id="HeadPicture" src="<%=ImagePath%>head/01.gif" alt="头像" />
						</td>
					</tr>
					<tr>
						<th>性别：</th>
						<td>
							<input type="radio" name="Sex" id="Man" checked="checked" /><label for="Man">男</label>
							<input type="radio" name="Sex" id="Woman" /><label for="Woman">女</label>
						</td>
					</tr>
					<tr>
						<th><span>* </span>主题：</th>
						<td><input type="text" name="Subject" size="50" maxlength="255" class="<%=PageLang%>Font" /></td>
					</tr>
					<tr>
						<th><span>* </span>内容：</th>
						<td><textarea cols="50" rows="10" name="Content" class="<%=PageLang%>Font"></textarea></td>
					</tr>
				</tbody>
			</table>
		</form>
		<!-- TemplateEndEditable -->
	</div>
</div>

<!-- TemplateBeginEditable name="脚注" -->
<div class="Footer">
	<ilghar:Menu Condition="CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ilghar:Record>
			<a href="<%=URL%>" target="<%=Target%>" title="<%=Name%>"><%=Name%></a>
			<ilghar:Separator>|</ilghar:Separator>
		</ilghar:Record>
	</ilghar:Menu>
	<hr size="1" />

	<%=Footer%>
</div>
<!-- TemplateEndEditable -->

<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/marquee.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<%=StatisticsCode%>
</body>
</html>
