﻿function BuildHeader()
{
	if (_page == "menu_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&CategoryID=" + $("#CategoryID").val();
	else if (_page == "generate_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&ChannelID=" + $("#ChannelID").val();
	else if (_page == "module_dictionary_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Namespace=" + _namespace + "&Page=" + _pageNumber;
	else if (_page == "link_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "admin_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&RoleID=" + $("#RoleID").val() + "&Page=" + _pageNumber;
	else if (_page == "config_rewrite")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "log_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "privilege")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&InstanceID=" + $("#InstanceID").val() + "&CurrentLang=" + $("#CurrentLang").val() + "&RoleID=" + $("#RoleID").val();
	else if (_page == "skin_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "template_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "template_dictionary_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&TemplatePath=" + _templatePath + "&Language=" + document.forms[0].TargetLanguageAb.value + "&Page=" + _pageNumber;
	else if (_page == "template_page_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&TemplatePath=" + _templatePath + "&Page=" + _pageNumber;
	else if (_page == "template_menu_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&TemplatePath=" + _templatePath + "&Namespace=" + $("#Namespace").val() + "&Page=" + _pageNumber;
	else if (_page == "link_category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "menu_list")
			{
				SetCookie("CategoryID", $("#CategoryID").val(), 10*360*24*60);
			}
			else if (_page == "template_menu_list")
			{
				SetCookie("Namespace", $("#Namespace").val(), 10*360*24*60);
				CloseAll();
			}
			else if (_page == "file_manager_list")
			{
				FileManager_CalcSize();
			}
			else if (_page == "module_object_list")
			{
				CloseAll();
			}
			else if (_page == "link_list" || _page == "admin_list")
			{
				MakeButton();
			}
			else if (_page == "link_category_list")
			{
				MakeButton();
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "link_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateLink('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateLink('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
	else if (_page == "admin_list")
	{
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAdmin('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAdmin('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateAdmin('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
	else if (_page == "link_category_list")
	{
	    //显示
	    var obj = $("#IsDisplay")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLinkCategory('Display')\" >" + _lang_display + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLinkCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLinkCategory('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLinkCategory('UnHold')\" >" + _lang_unhold + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLinkCategory('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLinkCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}

	$("#ExtraButton").html(buttons);
}

function SelectFile(type, path)
{
	var form = $("form")[0];
	switch (type)
	{
		case "Menu":
			form.Picture.value = path;
			$("#PictureView").attr("src", path);
			break;
	}	
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Menu":
			path += "true&Root=" + _root;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function Style_OnChange()
{
    if ($("#Custom")[0].checked)
    {
        if (this.id == "Custom")
            $("[name=CustomStyle]").show();

        return;
    }
    else
    {
        $("[name=CustomStyle]").hide();
    }

    var result = "";

    if ($("#Bold")[0].checked)
        result = "font-weight:bold";

    if ($("#Italic")[0].checked)
    {
        if (result != "")
            result += ";";

        result += "font-style:italic";
    }

    if ($.trim($("#Color").val()) != "")
    {
        if (result != "")
            result += ";";

        result += "color:" + $("#Color").val();
    }
    
    $("[name=CustomStyle]").val(result);
}

//-------------------------------------------------
//Start : 菜单管理
function GetMenuParentList()
{
	var form = $("form")[0];
	var condition;
	if (form.CategoryID.value == "")
		condition = IlgharCMS.SystemModule.Menu.CategoryID + " IS NULL";
	else
		condition = IlgharCMS.SystemModule.Menu.CategoryID + "=" + form.CategoryID.value;

	SetStatusMessage(_lang_parent);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=List&Condition=" + encodeURIComponent(condition),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_parent_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var selected = form.ParentID.value;
			if (typeof(_parentID) != "undefined")
			{
				selected = _parentID;
				_parentID = null;
			}
			form.ParentID.length = 1;

			var xmlDoc = CreateXmlDom();
			xmlDoc.loadXML(data);
			BuildTreeOptions(xmlDoc, IlgharCMS.SystemModule.Menu.ParentID, IlgharCMS.SystemModule.Menu.ID, IlgharCMS.SystemModule.Menu.Name, form.ParentID);
			CheckAndSelect(form.ParentID, selected);
			SetStatusMessage();
		}
	});
	return false;
}

function AddMenu()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data;
	if ($("#LinkTypeContent")[0].checked)
	{
		var editor = FCKeditorAPI.GetInstance("HtmlEditor");
		
		data = "Content=" + encodeURIComponent(editor.GetXHTML(false));
		data += "&ChannelID=" + this.ChannelID.value;
		data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
		data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
		data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);		
	}
	else if ($("#LinkTypeInnerLink")[0].checked)
	{
		if (this.Path.value.indexOf("http://") == 0 || this.Path.value.indexOf("/") == 0)
		{
			Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
			return false;
		}
		
		data = "Path=" + encodeURIComponent(this.Path.value);
		data += "&ChannelID=" + this.ChannelID.value;
	}
	else
	{
		if (this.Path.value.indexOf("http://") != 0)
		{
			Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
			return false;
		}
		
		data = "Path=" + encodeURIComponent(this.Path.value);
	}
	
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&Target=" + this.Target.value;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	var uploadPicture = _uploader.NeedUpload("Picture");
	if (!uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddMenu_GetInnerID();
		}
	});
	
	return false;	
}

function AddMenu_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddMenu_SetPageID();
		}
	});
}

function AddMenu_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);

    SetStatusMessage(_lang_setting_pageid);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		Menu_UploadPicture();
		}
	});
}

function EditMenu()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if ($("#LinkTypeInnerLink")[0].checked)
	{
		if (this.Path.value.indexOf("http://") == 0 || this.Path.value.indexOf("/") == 0)
		{
			Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
			return false;
		}
	}
	else if ($("#LinkTypeOuterLink")[0].checked)
	{
		if (this.Path.value.indexOf("http://") != 0)
		{
			Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
			return false;
		}
	}
	
	var data = "CategoryID=" + this.CategoryID.value;
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&Target=" + this.Target.value;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	var uploadPicture = _uploader.NeedUpload("Picture");
	if (!uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#LinkTypeContent")[0].checked)
	{
		var editor = FCKeditorAPI.GetInstance("HtmlEditor");
		
		var pageID = this.PageID.value;
		if (pageID == "")
		{
			pageID = _id;
		}
		else
		{
			pageID = pageID.replace(/\{Guid\}/g, _guid);
			pageID = pageID.replace(/\{ID\}/g, _id);
		}
		
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
		data += "&ChannelID=" + this.ChannelID.value;
		data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
		data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
		data += "&PageID=" + encodeURIComponent(pageID);
		data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
		data += "&Path=";
	}
	else if ($("#LinkTypeInnerLink")[0].checked)
	{
		data += "&Content=";
		data += "&Path=" + encodeURIComponent(this.Path.value);
		data += "&ChannelID=" + this.ChannelID.value;
	}
	else
	{
		data += "&Content=";
		data += "&Path=" + encodeURIComponent(this.Path.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Menu_UploadPicture();
		}
	});
	
	return false;	
}

function Menu_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Menu&Operation=UploadPicture&ID=" + _id});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function ModifyMenu(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteMenu(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveMenu(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Menu&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function AddMenuCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MenuCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditMenuCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MenuCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyMenuCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MenuCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteMenuCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MenuCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveMenuCategory(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MenuCategory&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 菜单管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 批量生成
function GetTemplatePages()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Template.Page&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Template_Page.TemplatePath + ":" + _channels[_channelIndex].TemplatePath),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_pages);
		},
		success : function(data)
		{
			_pages.loadXML(data);
			_pageIndex = 0;
			GenerateChannel();
		}
	});
}

function GenerateChannel()
{
	var pages = _pages.documentElement.childNodes;
	
	while (_pageIndex < pages.length && typeof(pages[_pageIndex].selectSingleNode) == "undefined")
	{
		_pageIndex++;
	}
	
	if (_pageIndex >= pages.length)
	{
		$(document.body).append(_lang_generate_complete);
		return;
	}

	_mark  = pages[_pageIndex].selectSingleNode(IlgharCMS.SystemModule.Template_Page.Mark).text;
	_object  = pages[_pageIndex].selectSingleNode(IlgharCMS.SystemModule.Template_Page.Object).text;
	if (_type == "Object" && _objectHeader != _object)
	{
		_pageIndex++;
		GenerateChannel();
		return;
	}
	
	_pathInChannel = pages[_pageIndex].selectSingleNode(IlgharCMS.SystemModule.Template_Page.PathInChannel).text;
	if (_pathInChannel == "")
	{
		_pathInChannel = pages[_pageIndex].selectSingleNode(IlgharCMS.SystemModule.Template_Page.PathInTemplate).text.replace(".dwt", "");
		if (_pathInChannel.indexOf(".e") == _pathInChannel.length - 2)
			_pathInChannel = _pathInChannel.substr(0, _pathInChannel.length - 2);
	}
	_pathInChannel = _webPath + _channels[_channelIndex].Path + _pathInChannel;

	var runAt = pages[_pageIndex].selectSingleNode(IlgharCMS.SystemModule.Template_Page.RunAt).text;
	if (_pathInChannel.indexOf(".ascx") != -1 && runAt == "Execute")
	{
		_pageIndex++;
		GenerateChannel();
		return;
	}
	
	_pageIndex++;
	if (_object == "")
	{
		_pathInChannel = _pathInChannel.replace("{Ext}", _channels[_channelIndex].Extension);
		
		if (_pathInChannel.replace("{Page}", "").indexOf("{") != -1)
		{
			GenerateChannel();
			return;
		}
		
		_caller[_caller.length] = GenerateChannel;
		if (_pathInChannel.indexOf("{Page}") != -1)
		{
			_pageNumber = -1;
			_pageCount = 0;
			GeneratePage();
		}
		else
		{
			Generate(_pathInChannel);
		}
	}
	else
	{
		if (_pathInChannel.replace(/\{(ID|Page|Ext)\}/g, "").indexOf("{") != -1)
		{
			GenerateChannel();
			return;
		}
		
		_records = null;
		_recordPageNumber = 1;
		_pathInChannelBackup = _pathInChannel;
		GenerateObject();
	}
}

function GenerateObject()
{
	if (_records == null)
	{
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Instance=" + _channels[_channelIndex].InstanceID + "&Lang=" + _channels[_channelIndex].Lang + "&Object=" + _object + "&Operation=List&Page=" + _recordPageNumber + "&PageSize=" + _pageSize,
			type : "GET",
			error : function(request)
			{
				GenerateChannel();
			},
			success : function(data)
			{
				_recordIndex = 0;
				_records = CreateXmlDom();
				_records.loadXML(data);
				if (data.indexOf("<") != 0 || _records.documentElement.childNodes.length == 0)
					GenerateChannel();
				else
					GenerateObject();
			}
		});
		return;
	}
	
	var records = _records.documentElement.childNodes;
	
	while (_recordIndex < records.length && typeof(records[_recordIndex].selectSingleNode) == "undefined")
	{
		_recordIndex++;
	}
	
	if (_recordIndex >= records.length)
	{
		_records = null;
		_recordPageNumber++;
		GenerateObject();
		return;
	}
	
	_pathInChannel = _pathInChannelBackup;

    var prefix = "";
    if (_mark != "")
    {
        for (var i = 0; i < _extraInstances.length; i++)
        {
            if (_extraInstances[i].ChannelID == _channels[_channelIndex].ID && _extraInstances[i].Mark == _mark)
            {
                prefix = _extraInstances[i].Namespace;
                break;
            }
        }
        
        if (prefix == "")
        {
            for (var i = 0; i < _modules.length; i++)
            {
                if (_modules[i].Name == _mark)
                {
                    prefix = _modules[i].Namespace;
                    break;
                }
            }
        }
    }
    else
    {
	    prefix = _channels[_channelIndex].Namespace;
    }
    
    if (prefix != "")
    {
        prefix = prefix + "." + _object.replace(/\./g, "_") + ".";
	    if (eval("typeof (" + prefix + "PageID) == \"undefined\""))
	    {
		    _pathInChannel = _pathInChannel.replace("{ID}", records[_recordIndex].selectSingleNode(eval(prefix + "InnerID")).text);
		    _pathInChannel = _pathInChannel.replace("{Ext}", _channels[_channelIndex].Extension);
	    }
	    else
	    {
	        var node = records[_recordIndex].selectSingleNode(eval(prefix + "PageGenerate"));
		    if (node != null && node.text == "0")
		    {
			    _recordIndex++;
			    GenerateObject();
			    return;
		    }

    		node = records[_recordIndex].selectSingleNode(eval(prefix + "PageID"));
		    _pathInChannel = _pathInChannel.replace("{ID}", node.text);
    		
    		node = records[_recordIndex].selectSingleNode(eval(prefix + "PageExtension"));
		    if (node == null || node.text == "")
			    _pathInChannel = _pathInChannel.replace("{Ext}", _channels[_channelIndex].Extension);
		    else
			    _pathInChannel = _pathInChannel.replace("{Ext}", node.text);
	    }
	}
	
	_recordIndex++;
	_caller[_caller.length] = GenerateObject;
	if (_pathInChannel.indexOf("{Page}") != -1)
	{
		_pageNumber = -1;
		_pageCount = 0;
		GeneratePage();
	}
	else
	{
		Generate(_pathInChannel);
	}
}

function GeneratePage()
{
	if (_pageNumber >= _pageCount || (_pageNumber == 0 && _pageCount == 1))
	{
		var caller = _caller[_caller.length - 1];
		_caller.length = _caller.length - 1;
		caller();
		return;
	}
	
	if (_pageCount <= 0)
	{
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Action=Generate&Path=" + encodeURIComponent(_pathInChannel.replace("{Page}", "")) + "&GetPageCount=1",
			type : "GET",
			error : function(request)
			{
				var caller = _caller[_caller.length - 1];
				_caller.length = _caller.length - 1;
				caller();
			},
			success : function(data)
			{
				_pageCount = parseInt(data);
				if (_pageCount == 0 || isNaN(_pageCount))
					_pageCount = 1;
				GeneratePage();
			}
		});
	}
	else
	{
		_pageNumber++;
		_caller[_caller.length] = GeneratePage;
		Generate(_pageNumber == 0 ? _pathInChannel.replace("{Page}", "") : _pathInChannel.replace("{Page}", "_" + _pageNumber));
	}
}

function Generate(path)
{
	if (path == null)
	{
		var caller = _caller[_caller.length - 1];
		_caller.length = _caller.length - 1;
		caller();
		return;
	}

	$(document.body).append(_lang_generating + "<a href=\"" + path + "\" target=\"_blank\">" + path + "</a>");
	window.scrollTo(0, document.body.scrollHeight);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Action=Generate&Path=" + encodeURIComponent(path),
		data : {},
		type : "POST",
		error : function(request)
		{
			$(document.body).append(" , <div style=\"display:inline;color:#F00\">" + _lang_generate_fail + "," + _lang_sleep.replace("{Interval}", _interval) + "<div>");
			setTimeout("Generate()", _interval * 1000);
		},
		success : function(data)
		{
			$(document.body).append(" , <div style=\"display:inline;color:#393\">" + _lang_generate_success + "," + _lang_sleep.replace("{Interval}", _interval) + "<div>");
			setTimeout("Generate()", _interval * 1000);
		}
	});
}
//End : 批量生成
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目管理
function MoveChannel(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function DeleteChannel(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function Type_OnClick()
{
	var trs = $("tr");
	
	if ($("#FunctionalChannel")[0].checked)
	{
		InstanceID_OnChange();
		
		trs.each(function(){this.style.display = "";});
		
		$("#PathTip").html(_lang_path_tip1);
		$("[name=Path]").val("");
	}
	else if ($("#NonFunctionalChannel")[0].checked)
	{
		var templateSelect = document.forms[0].TemplatePath;
		templateSelect.length = 0;
		
		var itemList = _xmlTemplate.documentElement.childNodes;
		for (var i = 0; i < itemList.length; i++)
		{
			if (typeof (itemList[i].selectSingleNode) == "undefined")
				continue;
						
			var path = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Template.Path).text;
			var moduleID = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Template.ModuleID).text;
			if (moduleID != g_empty)
				continue;
			
			var skins = _xmlSkin.selectNodes("//Item[" + IlgharCMS.SystemModule.Skin.Language + "='" + document.forms[0].TemplateLang.value + "']");
			for (var j = 0; j < skins.length; j++)
			{
				var templatePath = skins[j].selectSingleNode(IlgharCMS.SystemModule.Skin.TemplatePath).text;
				if (templatePath.indexOf(path) != -1)
				{
					templateSelect.options.add(new Option(path.substr(0, path.length - 1), path));
					break;
				}
			}
		}
	
		TemplatePath_OnChange();
		
		for (var i = 0; i < trs.length; i++)
		{
			if (i == 2)
				trs.eq(i).css("display", "none");
			else
				trs.eq(i).css("display", "");
		}
		
		$("#PathTip").html(_lang_path_tip1);
		$("[name=Path]").val("");
		
		$(":submit")[0].disabled = false;
	}
	else
	{
		for (var i = 2; i < trs.length; i++)
		{
			if (i == 3 || i == 4 || i == 5)
				continue;
				
			trs.eq(i).css("display", "none");
		}
		
		$("#PathTip").html(_lang_path_tip2);
		$("[name=Path]").val("http://");
		
		$(":submit")[0].disabled = false;
	}
}

function TemplatePath_OnChange()
{
	var form = document.forms[0];
	var templateSelect = form.TemplatePath;
	var skinSelect = form.SkinPath;
	skinSelect.length = 0;
	
	if (templateSelect.selectedIndex == -1)
		return;

	var itemList = _xmlSkin.selectNodes("//Item[" + IlgharCMS.SystemModule.Skin.Language + "='" + form.TemplateLang.value + "']");
	for (var i = 0; i < itemList.length; i++)
	{
		var templatePath = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Skin.TemplatePath).text;
		if (templatePath.indexOf(templateSelect.options[templateSelect.selectedIndex].text) == -1)
			continue;

		var path = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Skin.Path).text;
		var text = path.substr(0, path.length - 2 - form.TemplateLang.value.length);
		var slash = text.lastIndexOf("/");
		if (slash != -1)
			text = text.substr(slash + 1);
		
		skinSelect.options.add(new Option(text, path));
		
		if (_page == "channel_change_template" && path == _skinPath)
			skinSelect.selectedIndex = skinSelect.options.length - 1;
	}
	
	SkinPath_OnChange();
}

function SkinPath_OnChange()
{
	var form = document.forms[0];
	var templateSelect = form.TemplatePath;
	var skinSelect = form.SkinPath;
	
	if (skinSelect.selectedIndex == -1)
		return;
	
	var itemList = _xmlSkin.selectNodes("//Item[" + IlgharCMS.SystemModule.Skin.Language + "='" + form.TemplateLang.value + "' and " + IlgharCMS.SystemModule.Skin.Path + "='" + skinSelect.value + "']");
	for (var i = 0; i < itemList.length; i++)
	{
		var templatePath = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Skin.TemplatePath).text;
		if (templatePath.indexOf(templateSelect.options[templateSelect.selectedIndex].text) != -1)
		{
			$("#Thumbnail").attr("src", itemList[i].selectSingleNode(IlgharCMS.SystemModule.Skin.Thumbnail).text);
			break;
		}
	}
}

function TranslateLang_OnChange()
{
	var form = document.forms[0];
	if (form.TranslateLang.value == "")
	{
		$("#MatchSpan").css("display", "none");
		$("#Match")[0].checked = false;
	}
	else
	{
		$("#MatchSpan").css("display", "");
	}
	
	Match_OnClick();
}

function Match_OnClick()
{
    var form = document.forms[0];
    if (this.checked)
	    form.TemplateLang.value = form.TranslateLang.value;
    else
	    form.TemplateLang.value = _channelLang;
    TemplatePath_OnChange();
}

function GetTemplateList(moduleID)
{
	SetStatusMessage(_lang_loading_template_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=List" + (moduleID == null ? "" : "&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Template.ModuleID + ":" + moduleID)),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_xmlTemplate.loadXML(data);
			GetSkinList();
		}
	});
}

function GetSkinList()
{
	SetStatusMessage(_lang_loading_skin_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin&Operation=List",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_xmlSkin.loadXML(data);
			
			if (_page == "channel_add")
			{
			    if ($("#FunctionalChannel")[0].checked)
				    InstanceID_OnChange();
    				
			    GetChannelList();
			}
			else// if (_page == "channel_change_template")
			{
			    var templateSelect = document.forms[0].TemplatePath;
    		
			    var itemList = _xmlTemplate.documentElement.childNodes;
			    for (var i = 0; i < itemList.length; i++)
			    {
					if (typeof (itemList[i].selectSingleNode) == "undefined")
						continue;
						
				    var path = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Template.Path).text;
    				
				    var skins = _xmlSkin.documentElement.childNodes;
				    for (var j = 0; j < skins.length; j++)
				    {
						if (typeof (skins[j].selectSingleNode) == "undefined")
							continue;
						
					    var templatePath = skins[j].selectSingleNode(IlgharCMS.SystemModule.Skin.TemplatePath).text;
					    if (templatePath.indexOf(path) != -1)
					    {
						    templateSelect.options.add(new Option(path.substr(0, path.length - 1), path));
    						
						    if (path == _templatePath)
							    templateSelect.selectedIndex = templateSelect.length - 1;
						    break;
					    }
				    }
			    }
    			
	            var form = document.forms[0];
	            if (form.TranslateLang.value == "")
	            {
		            $("#MatchSpan").css("display", "none");
		            $("#Match")[0].checked = false;
	            }
	            else
	            {
		            $("#MatchSpan").css("display", "");
	            }

			    TemplatePath_OnChange();
				
				SetStatusMessage();
			}
		}
	});
}

function GetChannelList()
{
	SetStatusMessage(_lang_loading_channel_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=List",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_xmlChannel.loadXML(data);
			
			if (_page != "channel_extra_instance")
			{
			    var parentSelect = document.forms[0].ParentID;
			    var oldParentID = parentSelect.value;
			    parentSelect.length = 1;
    		
			    BuildTreeOptions(_xmlChannel, IlgharCMS.SystemModule.Channel.ParentID, IlgharCMS.SystemModule.Channel.ID, IlgharCMS.SystemModule.Channel.Name, parentSelect);
			    CheckAndSelect(parentSelect, oldParentID);
			}
			
			SetStatusMessage();
		}
	});
}

function InstanceID_OnChange()
{
	var form = document.forms[0];
	var instanceSelect = form.InstanceID;
	var templateSelect = form.TemplatePath;
	var skinSelect = form.SkinPath;
	templateSelect.length = 0;
	skinSelect.length = 0;
	
	if (instanceSelect == null)
	{
	    $(":submit")[0].disabled = true;
	    return;
	}
	
	if (instanceSelect.length == 0)
		return;
	
	var itemList = _xmlTemplate.selectNodes("//Item[" + IlgharCMS.SystemModule.Template.ModuleID + "='" + $(instanceSelect.options[instanceSelect.selectedIndex]).attr("ModuleID") + "']");
	for (var i = 0; i < itemList.length; i++)
	{
		var path = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Template.Path).text;
		
		var skins = _xmlSkin.selectNodes("//Item[" + IlgharCMS.SystemModule.Skin.Language + "='" + form.TemplateLang.value + "']");
		for (var j = 0; j < skins.length; j++)
		{
			var templatePath = skins[j].selectSingleNode(IlgharCMS.SystemModule.Skin.TemplatePath).text;
			if (templatePath.indexOf(path) != -1)
			{
				templateSelect.options.add(new Option(path.substr(0, path.length - 1), path));
				break;
			}
		}
	}
	
	TemplatePath_OnChange();
}

function AddChannel()
{
    if ($("#FunctionalChannel")[0].checked && this.InstanceID == null)
    {
		Alert(_lang_select_instance);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	if (!$("#OuterLink")[0].checked)
	{
		if (this.TemplatePath.selectedIndex == -1)
		{
			Alert(_lang_select_template);
			return false;
		}
	
		if (this.SkinPath.selectedIndex == -1)
		{
			Alert(_lang_select_skin);
			return false;
		}

		if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
		{
			Alert(_lang_logo_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
			return false;
		}
		
		if (!IsAllowedType(this.Link.value, this.LinkAllowedType.value))
		{
			Alert(_lang_link_type_must_be + this.LinkAllowedType.value, function(){this.Link.select();}, this);
			return false;
		}
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Lang=" + _lang;
	if (this.ParentID.value != "")
		data += "&ParentID=" + this.ParentID.value;
	data += "&Path=" + encodeURIComponent(this.Path.value);
	data += "&TemplateLang=" + this.TemplateLang.value;
	if (!$("#OuterLink")[0].checked)
	{
        if (this.Path.value.indexOf("/") == 0 || this.Path.value.lastIndexOf("/") != this.Path.value.length - 1)
        {
            Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
            return false;
        }
    
	    var itemNodes = _xmlChannel.documentElement.childNodes;
	    for (var i = 0; i < itemNodes.length; i++)
	    {
			if (typeof (itemNodes[i].selectSingleNode) == "undefined")
				continue;
						
	        var pathNode = itemNodes[i].selectSingleNode(IlgharCMS.SystemModule.Channel.Path);
	        if ((pathNode == null && this.Path.value == "") || (pathNode != null && pathNode.text == this.Path.value))
            {
	            Alert(_lang_path_exist, function(){this.Path.select();}, this);
	            return false;
            }
	    }

		if ($("#FunctionalChannel")[0].checked)
			data += "&InstanceID=" + this.InstanceID.value;
		data += "&TemplatePath=" + this.TemplatePath.value;
		data += "&SkinPath=" + this.SkinPath.value;
		data += "&TranslateLang=" + this.TranslateLang.value;
		data += "&IsDynamicTemplate=" + $("#IsDynamicTemplateYes")[0].checked;
		data += "&DynamicTemplateID=" + encodeURIComponent(this.DynamicTemplateID.value);
		data += "&Generate=" + $("#GenerateYes")[0].checked;
		data += "&DefaultDocument=" + encodeURIComponent(this.DefaultDocument.value);
		data += "&Extension=" + encodeURIComponent(this.Extension.value);
		data += "&Domain=" + encodeURIComponent(this.Domain.value);
		data += "&Notice=" + encodeURIComponent(this.Notice.value);
		data += "&Footer=" + encodeURIComponent(this.Footer.value);
		data += "&ICP=" + encodeURIComponent(this.ICP.value);
		data += "&StatisticsCode=" + encodeURIComponent(this.StatisticsCode.value);
		_uploadLogo = _uploader.NeedUpload("Logo");
		if (!_uploadLogo)
			data += "&Logo=" + encodeURIComponent(this.Logo.value);
		_uploadLink = _uploader.NeedUpload("Link");
		if (!_uploadLink)
			data += "&Link=" + encodeURIComponent(this.Link.value);
		data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
		data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	}
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    AddChannel_GetInnerID(data);
		}
	});
	
	return false;
}

function AddChannel_GetInnerID(id)
{
    if (!_uploadLogo && !_uploadLink)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }
    
	SetStatusMessage(_lang_loading_innerid);

    $.ajax(
    {
	    url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=GetInnerIDFromGuid&ID=" + id,
	    type : "GET",
	    error : function(request)
	    {
		    Alert(_lang_innerid_fail);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
	    },
	    success : function(data)
	    {
	        Channel_UploadLogo(data);
	    }
    });
}

function EditChannel()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (_type != "OuterLink")
	{
        if (this.Path.value.indexOf("/") == 0 || this.Path.value.lastIndexOf("/") != this.Path.value.length - 1)
        {
            Alert(_lang_path_incorrect, function(){this.Path.select();}, this);
            return false;
        }
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Path=" + encodeURIComponent(this.Path.value);
	if (_templatePath != "")
	{
		if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
		{
			Alert(_lang_logo_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
			return false;
		}
		
		if (!IsAllowedType(this.Link.value, this.LinkAllowedType.value))
		{
			Alert(_lang_link_type_must_be + this.LinkAllowedType.value, function(){this.Link.select();}, this);
			return false;
		}
		
		if (_instanceID != g_empty)
			data += "&InstanceID=" + encodeURIComponent(this.InstanceID.value);
		data += "&IsDynamicTemplate=" + $("#IsDynamicTemplateYes")[0].checked;
		data += "&DynamicTemplateID=" + encodeURIComponent(this.DynamicTemplateID.value);;
		data += "&Generate=" + $("#GenerateYes")[0].checked;
		data += "&DefaultDocument=" + encodeURIComponent(this.DefaultDocument.value);
		data += "&Extension=" + encodeURIComponent(this.Extension.value);
		data += "&Domain=" + encodeURIComponent(this.Domain.value);
		data += "&Notice=" + encodeURIComponent(this.Notice.value);
		data += "&Footer=" + encodeURIComponent(this.Footer.value);
		data += "&ICP=" + encodeURIComponent(this.ICP.value);
		data += "&StatisticsCode=" + encodeURIComponent(this.StatisticsCode.value);
		_uploadLogo = _uploader.NeedUpload("Logo");
		if (!_uploadLogo)
			data += "&Logo=" + encodeURIComponent(this.Logo.value);
		_uploadLink = _uploader.NeedUpload("Link");
		if (!_uploadLink)
			data += "&Link=" + encodeURIComponent(this.Link.value);
		data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
		data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Channel_UploadLogo(_id);
		}
	});
	
	return false;
}

function Channel_UploadLogo(id)
{
    if (!_uploadLogo)
    {
        Channel_UploadLink(id);
        return;
    }
    
	SetStatusMessage(_lang_start_upload_logo);
	_uploader.Init({Status:_lang_uploading_logo,Params:"Lang=" + _lang + "&Object=Channel&Operation=UploadLogo&ID=" + id});
	_uploader.Upload("Logo", function()
	{
		if (arguments.length == 2)
		{
			Alert(arguments[1]);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
		else
		{
			Channel_UploadLink(id);
		}
	});
}

function Channel_UploadLink(id)
{
    if (!_uploadLink)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }
    
	SetStatusMessage(_lang_start_upload_link);
	_uploader.Init({Status:_lang_uploading_link,Params:"Lang=" + _lang + "&Object=Channel&Operation=UploadLink&ID=" + id});
	_uploader.Upload("Link", function()
	{
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
	});
}

function ChangeTemplate()
{
	if (this.TemplatePath.selectedIndex == -1)
	{
		Alert(_lang_select_template);
		return false;
	}

	if (this.SkinPath.selectedIndex == -1)
	{
		Alert(_lang_select_skin);
		return false;
	}
	
	var data = "TemplatePath=" + this.TemplatePath.value;
	data += "&SkinPath=" + this.SkinPath.value;
	data += "&TemplateLang=" + this.TemplateLang.value;
	data += "&TranslateLang=" + this.TranslateLang.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function BindingInstance_OnChange()
{
    var form = this.form;
	if (form.BindingChannelID == null)
		return;
		
	form.BindingChannelID.length = 1;
	if (form.BindingInstanceID.value != "")
	{
		var channels = _xmlChannel.selectNodes("//Item[" + IlgharCMS.SystemModule.Channel.InstanceID + "='" + form.BindingInstanceID.value + "' and " + IlgharCMS.SystemModule.Channel.Lang + "='" + _channelLang + "']");
		for (var i = 0; i < channels.length; i++)
		{
			var name = channels[i].selectSingleNode(IlgharCMS.SystemModule.Channel.Name).text;
			var id = channels[i].selectSingleNode(IlgharCMS.SystemModule.Channel.ID).text;
			var parent = channels[i];
			while (parent.selectSingleNode(IlgharCMS.SystemModule.Channel.ParentID).text != g_empty)
			{
				parent = _xmlChannel.selectSingleNode("//Item[" + IlgharCMS.SystemModule.Channel.ID + "='" + parent.selectSingleNode(IlgharCMS.SystemModule.Channel.ParentID).text + "']");
				name = parent.selectSingleNode(IlgharCMS.SystemModule.Channel.Name).text + " → " + name;
			}
			form.BindingChannelID.options.add(new Option(name, id));
		}
	}
}

function SetExtraInstance()
{
	if (this.BindingInstanceID.value == "")
	{
		if (this.ID.value == "")
			return false;

		var form = this;
		
	    SetStatusMessage(_lang_working);

	    $.ajax(
	    {
		    url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel.ExtraInstance&Operation=Delete&ID=" + this.ID.value,
		    data : {},
		    type : "POST",
		    error : function(request)
		    {
			    Alert(_lang_operation_fail);
			    SetStatusMessage();
		    },
		    success : function(data)
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    
			    form.ID.value = "";
		    }
	    });		
	}
	else
	{
	    if (typeof(this.BindingChannelID) != "undefined" && this.BindingChannelID.value == "")
	    {
		    Alert(_lang_select_channel);
		    return false;
	    }
    	
		var form = this;
	    var data = "";

	    SetStatusMessage(_lang_working);

	    if (this.ID.value == "")
	    {
		    if (typeof(this.BindingChannelID) == "undefined")
			    data = "ChannelID=" + _channelID + "&Mark=" + this.Mark.value + "&BindingInstanceID=" + this.BindingInstanceID.value + "&BindingChannelID=";
		    else
			    data = "ChannelID=" + _channelID + "&Mark=" + this.Mark.value + "&BindingChannelID=" + this.BindingChannelID.value + "&BindingInstanceID=";
			    
	        $.ajax(
	        {
		        url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel.ExtraInstance&Operation=Add",
		        data : data,
		        type : "POST",
		        error : function(request)
		        {
			        Alert(_lang_operation_fail);
			        SetStatusMessage();
		        },
		        success : function(data)
		        {
	                $.ajax(
	                {
		                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel.ExtraInstance&Operation=GetInnerIDFromGuid&ID=" + data,
		                type : "GET",
		                error : function(request)
		                {
			                Alert(_lang_operation_fail);
			                SetStatusMessage();
		                },
		                success : function(data)
		                {
			                Alert(_lang_operation_success);
			                SetStatusMessage();
            			    
			                form.ID.value = data;
		                }
	                });
		        }
	        });		
	    }
	    else
	    {
		    if (this.BindingChannelID == null)
			    data = "BindingInstanceID=" + this.BindingInstanceID.value + "&BindingChannelID=";
		    else
			    data = "BindingChannelID=" + this.BindingChannelID.value + "&BindingInstanceID=";

            $.ajax(
            {
	            url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Channel.ExtraInstance&Operation=Modify&ID=" + this.ID.value,
	            data : data,
	            type : "POST",
	            error : function(request)
	            {
		            Alert(_lang_operation_fail);
		            SetStatusMessage();
	            },
	            success : function(data)
	            {
		            Alert(_lang_operation_success);
		            SetStatusMessage();
	            }
            });
	    }
    }

	return false;
}
//End : 栏目管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模块词典管理
function ModifyModuleDictionary(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&Content=" + encodeURIComponent(form.Content.value);

	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Dictionary&Operation=Modify&Name=" + id + "&Namespace=" + _namespace,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
	
	return false;
}

function DeleteModuleDictionary(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Dictionary&Operation=Delete&Name=" + id + "&Namespace=" + _namespace + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}

function AddModuleDictionary()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Dictionary&Operation=Add&Namespace=" + _namespace,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}
//End : 模块词典管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 链接类别管理
function UpdateLinkCategory(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
		    Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateLinkCategory(action, id); }, this);
		else
			UpdateLinkCategory(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function AddLinkCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit").eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
		    _guid = data;
	        AddLinkCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddLinkCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
            _id = data;
		    LinkCategory_UploadPicture();
		}
	});
}

function EditLinkCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit").eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
		    LinkCategory_UploadPicture();
		}
	});
	
	return false;	
}

function LinkCategory_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit").eq(0).attr("disabled", false);
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=LinkCategory&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit").eq(0).attr("disabled", false);
    });
}

function ModifyLinkCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}

	});
}

function DeleteLinkCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveLinkCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=LinkCategory&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 链接类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 链接管理
function AddLink()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadLogo)
		    {
			    _guid = data;

		        SetStatusMessage(_lang_getting_innerid);
		        AddLink_GetInnerID();
			}
			else
			{
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
			}
		}
	});
	
	return false;
}

function AddLink_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
            
		    Link_UploadLogo();
		}
	});
}

function EditLink()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
	        Link_UploadLogo();
		}
	});
	
	return false;
}

function Link_UploadLogo()
{
    if (!_uploadLogo)
    {
	    Alert(_lang_operation_success);
	    SetStatusMessage();
	    $(":submit")[0].disabled = false;

	    return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Link&Operation=UploadLogo&ID=" + _id});
    _uploader.Upload("Logo", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function ModifyLink(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&URL=" + encodeURIComponent(form.URL.value);
	data += "&QQ=" + encodeURIComponent(form.QQ.value);
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function MoveLink(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function DeleteLink(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}

function UpdateLink(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateLink(action, id);}, this);
		else
			UpdateLink(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Link&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				//Init();
			}
		});
	}
}	

//End : 链接管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 管理员管理
function AddAdmin()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Password.value == "")
	{
		Alert(_lang_password_empty, function(){this.Password.select();}, this);
		return false;
	}
	
	if (!this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
	{
		Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
		return false;
	}
	
	if (this.ChangeMember.checked)
	{
		if (this.MemberName.value == "")
		{
		    Alert(_lang_member_name_empty, function(){this.MemberName.select();}, this);
			return false;
		}
		
		if (this.MemberPassword.value == "")
		{
		    Alert(_lang_member_password_empty, function(){this.MemberPassword.select();}, this);
			return false;
		}
		
		if (!this.MemberEmail.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
		{
		    Alert(_lang_member_email_incorrect, function(){this.MemberEmail.select();}, this);
			return false;
		}
	}
	
	var data = "RoleID=" + this.RoleID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Password=" + encodeURIComponent(this.Password.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&RealName=" + encodeURIComponent(this.RealName.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&MSN=" + encodeURIComponent(this.MSN.value);
	data += "&HasSelfLimitation=" + $("#HasSelfLimitationYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Admin&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (document.forms[0].ChangeMember.checked)
		    {
			    _guid = data;
		        AddAdmin_AddMember();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
		    }
		}
	});
	
	return false;
}

function AddAdmin_AddMember()
{
    var form = document.forms[0];

	var data = "ID=" + _guid;
	data += "&Name=" + encodeURIComponent(form.MemberName.value);
	data += "&Password=" + encodeURIComponent(form.MemberPassword.value);
	data += "&PasswordQuestion=" + encodeURIComponent(Math.random());
	data += "&PasswordAnswer=" + encodeURIComponent(Math.random());
	data += "&Email=" + encodeURIComponent(form.MemberEmail.value);
	data += "&ValidateKey=" + encodeURIComponent(_validatekey);
	
    SetStatusMessage(_lang_adding_member);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Instance=" + _memberInstanceID + "&Lang=" + _lang + "&Object=Member&Operation=Add&Validate=false",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditAdmin()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
	{
		Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
		return false;
	}
	
	if (this.ChangeMember.checked)
	{
		if (this.MemberName.value == "")
		{
		    Alert(_lang_member_name_empty, function(){this.MemberName.select();}, this);
			return false;
		}
		
		if (_memberID == 0 && this.MemberPassword.value == "")
		{
		    Alert(_lang_member_password_empty, function(){this.MemberPassword.select();}, this);
			return false;
		}
		
		if (!this.MemberEmail.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
		{
		    Alert(_lang_member_email_incorrect, function(){this.MemberEmail.select();}, this);
			return false;
		}
	}
	
	var data = "RoleID=" + this.RoleID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	if (this.Password.value != "")
		data += "&Password=" + encodeURIComponent(this.Password.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&RealName=" + encodeURIComponent(this.RealName.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&MSN=" + encodeURIComponent(this.MSN.value);
	data += "&HasSelfLimitation=" + $("#HasSelfLimitationYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Admin&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			var form = document.forms[0];
			if (form.ChangeMember.checked)
			{
			    EditAdmin_HandleMember();
			}
			else
			{
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
			}
		}
	});
	
	return false;
}

function EditAdmin_HandleMember()
{
    var form = document.forms[0];
    var url;
    var data;
	if (_memberID == 0)
	{
		data = "ID=" + _guid;
		data += "&Name=" + encodeURIComponent(form.MemberName.value);
		data += "&Password=" + encodeURIComponent(form.MemberPassword.value);
		data += "&Email=" + encodeURIComponent(form.MemberEmail.value);
		data += "&ValidateKey=" + encodeURIComponent(_validatekey);
		
		url = _webPath + "ilghar.aspx?Instance=" + _memberInstanceID + "&Lang=" + _lang + "&Object=Member&Operation=Add&Validate=false";
	}
	else
	{
		var data = "Name=" + encodeURIComponent(form.MemberName.value);
		if (form.MemberPassword.value != "")
			data += "&Password=" + encodeURIComponent(form.MemberPassword.value);
		data += "&Email=" + encodeURIComponent(form.MemberEmail.value);
		data += "&ValidateKey=" + encodeURIComponent(_validatekey);
		
		url = _webPath + "ilghar.aspx?Instance=" + _memberInstanceID + "&Lang=" + _lang + "&Object=Member&Operation=Modify&Validate=false&ID=" + _memberID;
	}

	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : url,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function UpdateAdmin(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateAdmin(action, id);}, this);
		else
			UpdateAdmin(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Admin&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));				
			}
		});
	}
}

function ChangeMember_OnClick()
{
    var form = document.forms[0];
    if (form.ChangeMember.checked)
    {
        form.MemberName.disabled = false;
        form.MemberPassword.disabled = false;
        form.MemberEmail.disabled = false;
    }
    else
    {
        form.MemberName.disabled = true;
        form.MemberPassword.disabled = true;
        form.MemberEmail.disabled = true;
    }
}

//End : 管理员管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_logo_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Link.value, this.LinkAllowedType.value))
	{
		Alert(_lang_link_type_must_be + this.LinkAllowedType.value, function(){this.Link.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&Notice=" + encodeURIComponent(this.Notice.value);
	data += "&Footer=" + encodeURIComponent(this.Footer.value);
	data += "&ICP=" + encodeURIComponent(this.ICP.value);
	data += "&StatisticsCode=" + encodeURIComponent(this.StatisticsCode.value);
	data += "&UploadType=" + encodeURIComponent(this.UploadType.value);
	data += "&Error404Redirect=" + encodeURIComponent(this.Error404Redirect.value);
	data += "&ErrorRedirect=" + encodeURIComponent(this.ErrorRedirect.value);
	data += "&DisplayCheckCode=" + $("#DisplayCheckCodeYes")[0].checked;
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);
	_uploadLink = _uploader.NeedUpload("Link");
	if (!_uploadLink)
		data += "&Link=" + encodeURIComponent(this.Link.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			SetBasicSettings_UploadLogo();
		}
	});
	
	return false;	
}

function SetBasicSettings_UploadLogo()
{
    if (!_uploadLogo)
    {
		SetBasicSettings_UploadLink();
        return;
    }

    SetStatusMessage(_lang_start_upload_logo);
    _uploader.Init({Status:_lang_uploading_logo,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadLogo"});
    _uploader.Upload("Logo", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
            SetBasicSettings_UploadLink();
        }
    });
}

function SetBasicSettings_UploadLink()
{
    if (!_uploadLink)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_link);
    _uploader.Init({Status:_lang_uploading_link,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadLink"});
    _uploader.Upload("Link", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
		    Alert(_lang_operation_success);
	    SetStatusMessage();
	    $(":submit")[0].disabled = false;
    });
}

function SetEmailSettings()
{
	var data = "Tool=" + this.Tool.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Address=" + encodeURIComponent(this.Address.value);
	data += "&Account=" + encodeURIComponent(this.Account.value);
	if (form.Password.value != "")
		data += "&Password=" + encodeURIComponent(this.Password.value);
	data += "&Server=" + encodeURIComponent(this.Server.value);
	data += "&NeedValidation=" + $("#NeedValidationYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetEmailSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function SpeedUpEnabled_OnClick()
{
	if ($("#SpeedUpEnabledYes")[0].checked)
		$("#SpeedUpConnectionStringSpan").show();
	else
		$("#SpeedUpConnectionStringSpan").hide();
}

function SetGlobalSettings()
{
	if (this.ConnectionString.value == "")
	{
		Alert(_lang_connection_string_empty, function(){this.ConnectionString.select();}, this);
		return false;
	}
	
	if (!this.AutoGenerateInterval.value.match(/^\d+$/))
	{
		Alert(_lang_auto_generate_interval_incorrect, function(){this.AutoGenerateInterval.select();}, this);
		return false;
	}
	
	if (!this.GenerateInterval.value.match(/^\d+$/))
	{
		Alert(_lang_generate_interval_incorrect, function(){this.GenerateInterval.select();}, this);
		return false;
	}
	
	var data = "Domain=" + encodeURIComponent(this.Domain.value);
	data += "&DatabaseProvider=" + encodeURIComponent(this.DatabaseProvider.value);
	data += "&ProtectConnectionString=" + $("#ProtectConnectionStringYes")[0].checked;
	data += "&ConnectionString=" + encodeURIComponent(this.ConnectionString.value);
	data += "&SpeedUpEnabled=" + $("#SpeedUpEnabledYes")[0].checked;
	data += "&SpeedUpConnectionString=" + encodeURIComponent(this.SpeedUpConnectionString.value);
	data += "&ClearWhiteSpace=" + $("#ClearWhiteSpace")[0].checked;
	data += "&ClearHtmlComment=" + $("#ClearHtmlComment")[0].checked;
	data += "&ClearScriptComment=" + $("#ClearScriptComment")[0].checked;
	data += "&GZipEnabled=" + $("#GZipEnabledYes")[0].checked;
	data += "&Fake404=" + $("#Fake404Yes")[0].checked;
	data += "&IIS404=" + $("#IIS404Yes")[0].checked;
	data += "&AutoGenerateInterval=" + this.AutoGenerateInterval.value;
	data += "&GenerateInterval=" + this.GenerateInterval.value;
	data += "&OnlyAdminCanDebug=" + $("#OnlyAdminCanDebug")[0].checked;
	data += "&DisplayTrace=" + $("#DisplayTrace")[0].checked;
	data += "&ShutDown=" + $("#ShutDownYes")[0].checked;
	data += "&ShutDownReason=" + encodeURIComponent(this.ShutDownReason.value);
	data += "&DataDirectory=" + encodeURIComponent(this.DataDirectory.value);
	data += "&TemplateDirectory=" + encodeURIComponent(this.TemplateDirectory.value);
	data += "&CacheDirectory=" + encodeURIComponent(this.CacheDirectory.value);
	data += "&ModuleDirectory=" + encodeURIComponent(this.ModuleDirectory.value);
	data += "&CommonDirectory=" + encodeURIComponent(this.CommonDirectory.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetGlobalSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function SetWaterMarkSettings()
{
	if (this.FontSize.value != "" && !this.FontSize.value.match(/^\d+$/))
	{
		Alert(_lang_font_size_incorrect, function(){this.FontSize.select();}, this);
		return false;
	}

	if (this.ForeColor.value != "" && !this.ForeColor.value.match(/^#[0-9a-fA-F]{6}$/))
	{
		Alert(_lang_font_color_incorrect, function(){this.ForeColor.select();}, this);
		return false;
	}

	if (this.BackColor.value != "" && !this.BackColor.value.match(/^#[0-9a-fA-F]{6}$/))
	{
		Alert(_lang_back_color_incorrect, function(){this.BackColor.select();}, this);
		return false;
	}

	if (this.MarginX.value != "" && !this.MarginX.value.match(/^\d+$/))
	{
		Alert(_lang_margin_x_incorrect, function(){this.MarginX.select();}, this);
		return false;
	}

	if (this.MarginY.value != "" && !this.MarginY.value.match(/^\d+$/))
	{
		Alert(_lang_margin_y_incorrect, function(){this.MarginY.select();}, this);
		return false;
	}

	if (this.Transparency.value != "" && !this.Transparency.value.match(/^(1|(0.\d+))$/))
	{
		Alert(_lang_transparency_incorrect, function(){this.Transparency.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Image.value, this.ImageAllowedType.value))
	{
		Alert(_lang_type_must_be + this.ImageAllowedType.value, function(){this.Image.select();}, this);
		return false;
	}
	
	var data = "Type=" + $("[name=Type]:checked").val();
	_uploadImage = _uploader.NeedUpload("Image");
	if (!_uploadImage)
		data += "&Image=" + encodeURIComponent(this.Image.value);
	data += "&Text=" + encodeURIComponent(this.Text.value);
	data += "&FontFamily=" + encodeURIComponent(this.FontFamily.value);
	data += "&FontSize=" + encodeURIComponent(this.FontSize.value);
	data += "&ForeColor=" + encodeURIComponent(this.ForeColor.value);
	data += "&BackColor=" + encodeURIComponent(this.BackColor.value);
	data += "&Bold=" + $("#BoldYes")[0].checked;
	data += "&Italic=" + $("#ItalicYes")[0].checked;
	data += "&Position=" + encodeURIComponent(this.Position.value);
	data += "&MarginX=" + encodeURIComponent(this.MarginX.value);
	data += "&MarginY=" + encodeURIComponent(this.MarginY.value);
	data += "&Transparency=" + encodeURIComponent(this.Transparency.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetWaterMarkSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			SetWaterMarkSettings_UploadImage();
		}
	});
	
	return false;	
}

function SetWaterMarkSettings_UploadImage()
{
    if (!_uploadImage)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }
    
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadWaterMarkImage"});
	_uploader.Upload("Image", function()
	{
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
	});
}

function AddRewrite()
{
	if (this.LookFor.value == "")
	{
		Alert(_lang_lookfor_empty, function(){this.LookFor.select();}, this);
		return false;
	}
	
	if (!this.LookFor.value.match(/^((http:\/\/)|(~\/)|(\/))/))
	{
		Alert(_lang_lookfor_incorrect, function(){this.LookFor.select();}, this);
		return false;
	}
	
	if (this.SendTo.value == "" && this.InstanceID.value == "" && this.ObjectFullName.value == "")
	{
		Alert(_lang_sendto_empty, function(){this.SendTo.select();}, this);
		return false;
	}
	
	if (this.SendTo.value != "" && !this.SendTo.value.match(/^((http:\/\/)|(~\/)|(\/))/))
	{
		Alert(_lang_sendto_incorrect, function(){this.SendTo.select();}, this);
		return false;
	}
	
	var data = "LookFor=" + encodeURIComponent(this.LookFor.value);
	if (this.SendTo.value == "")
	{
		data += "&InstanceID=" + this.InstanceID.value;
		data += "&ObjectFullName=" + this.ObjectFullName.options[form.ObjectFullName.selectedIndex].name;
	}
	else
	{
		data += "&SendTo=" + encodeURIComponent(this.SendTo.value);
	}
	data += "&Is301=" + this.Is301.checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Rewrite&Operation=Add&Transfer=" + encodeURIComponent(BuildHeader()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;

			$("#List").html(HandleFake404(data, "text"));
		}
	});
	
	return false;	
}

function DeleteRewrite(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Rewrite&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}


//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 支付管理
function AddPayment()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&Type=" + encodeURIComponent(this.Type.value);
	data += "&AcountName=" + encodeURIComponent(this.AcountName.value);
	data += "&Acount=" + encodeURIComponent(this.Acount.value);
	data += "&Key=" + encodeURIComponent(this.Key.value);
	data += "&PartnerID=" + encodeURIComponent(this.PartnerID.value);
	data += "&IsOnline=" + encodeURIComponent($("input:radio:checked").val());	
	data += "&Rate=" + this.Rate.value;
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Payment&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Payment_UploadLogo();
		}
	});
	
	return false;
}

function EditPayment()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&Type=" + encodeURIComponent(this.Type.value);
	data += "&AcountName=" + encodeURIComponent(this.AcountName.value);
	data += "&Acount=" + encodeURIComponent(this.Acount.value);
	data += "&Key=" + encodeURIComponent(this.Key.value);
	data += "&PartnerID=" + encodeURIComponent(this.PartnerID.value);
	data += "&IsOnline=" + encodeURIComponent($("input:radio:checked").val());	
	data += "&Rate=" + this.Rate.value;
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Payment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Payment_UploadLogo();
		}
	});
	
	return false;
}

function Payment_UploadLogo()
{
    if (!_uploadLogo)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Payment&Operation=UploadLogo&ID=" + _id});
    _uploader.Upload("Logo", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function DeletePayment(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Payment&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 支付管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 实用工具
function BackupDb()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=BackupDb&Name=" + encodeURIComponent(this.Name.value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
	
	return false;
}

function BackupSite()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=BackupSite",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_backup_site_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function CompactDb()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=CompactDb",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
}

function RestoreDb(name)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=RestoreDb&Name=" + encodeURIComponent(name),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
	
	return false;
}

function DeleteDbBackup(name)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=DeleteDbBackup&Name=" + encodeURIComponent(name) + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
		}
	});
}

function ClearCache()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=ClearCache",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function UpdateTemplateCache()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=UpdateTemplateCache",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function InitSystem()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=InitSystem",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function ReplaceEotRootString(value)
{
	if (typeof(value) != "string")
	{
		Prompt(_lang_prompt, "", function(returnValue){if (returnValue != null && returnValue != "")ReplaceEotRootString(returnValue);}, this);
	}
	else
	{
		var me = this;
		me.disabled = true;
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=ReplaceEotRootString",
			data : "RootString=" + encodeURIComponent(value),
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
				me.disabled = false;
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
				me.disabled = false;
			}
		});
	}
}

function CheckUpgrade()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=CheckUpgrade",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
		    if (data == "")
		    {
		        Alert(_lang_no_update);
		    }
		    else
		    {
		        var upgrade = eval(data);
			    Alert(_lang_has_upgrade + upgrade.Time, function(){window.open(upgrade.Url);}, this);
            }

		    SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}

function UploadUpgrade()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!IsAllowedType($("#FileTextbox").val(), "zip"))
	{
		Alert(_lang_type_must_be + "zip");
		return false;
	}
	
    var me = this;
    me.disabled = true;
    SetStatusMessage(_lang_start_upload);
    
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Utility&Operation=UploadUpgrade"});
    _uploader.Upload("File", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
        me.disabled = false;
    });

	return false;
}

function Upgrade()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Utility&Operation=Upgrade",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
		    SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}
//End : 实用工具
//-------------------------------------------------

//-------------------------------------------------
//Start : 文件管理
function FileManager_CalcSize()
{
	var sum = 0;
	$("tbody tr").each(function()
	{
		var name = $(this).attr("id");
		
		var tds = $(this).find("td");
		
		var size = tds.eq(1).text();
		if (size.indexOf(" B") != -1)
			sum += parseFloat(size.replace(" B", ""));
		else if (size.indexOf(" K") != -1)
			sum += parseFloat(size.replace(" B", "")) * 1024;
		else if (size.indexOf(" M") != -1)
			sum += parseFloat(size.replace(" M", "")) * 1024 * 1024;
		else if (size.indexOf(" G") != -1)
			sum += parseFloat(size.replace(" G", "")) * 1024 * 1024 * 1024;		
	});
	
	var unit = " B";
	if (sum > 1024)
	{
		sum = sum / 1024;
		unit = " K";
	}
	if (sum > 1024)
	{
		sum = sum / 1024;
		unit = " M";
	}
	if (sum > 1024)
	{
		sum = sum / 1024;
		unit = " G";
	}
	$("tfoot td:last").html(sum.toFixed(2) + unit);
}

function List()
{
	var input = $("#Folder")[0];
	var slash = input.value.indexOf("/");
	if (slash != 0)
	{
		Alert(_lang_start_slash);
		return;
	}
	
	slash = input.value.lastIndexOf("/");
	if (slash < input.value.length - 1)
		input.value += "/";
	
	if (arguments.length == 1 && typeof(arguments[0]) == "string")
		input.value = input.value + arguments[0] + "/";
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + encodeURIComponent(input.value),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			//Init();
			SetStatusMessage();
		}
	});
}

function Up()
{
	var input = $("#Folder")[0];
	var value = input.value;
	if (value.length <= 1)
	    return;
		
	if (value.lastIndexOf("/") == value.length - 1)
	    value = value.substr(0, value.length - 1);

	var slash = value.lastIndexOf("/");
	if (slash == -1)
		return;

	input.value = value.substr(0, slash + 1);
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + encodeURIComponent(input.value),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();
		}
	});
}

function CreateFolder(value)
{
	if (typeof(value) != "string")
	{
		Prompt(_lang_folder_name, "", function(returnValue){if (returnValue != null && returnValue != "")CreateFolder(returnValue);}, this);
	}
	else
	{
		var folder = $("#Folder").val();
		if (folder.lastIndexOf("/") != folder.length - 1)
			folder += "/";

		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=CreateFolder&Path=" + encodeURIComponent(folder + value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Upload()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	var folder = $("#Folder").val();
	if (folder.lastIndexOf("/") != folder.length - 1)
		folder += "/";

	$(":submit")[0].disabled = true;
    SetStatusMessage(_lang_start_upload);
    
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=FileManager&Operation=Upload&Folder=" + encodeURIComponent(folder) + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("File", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
        }
        else
        {
    		Alert(_lang_operation_success);
    		List();
    	}
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });

	return false;
}

function Delete(name)
{
	var folder = $("#Folder").val();
	if (folder.lastIndexOf("/") != folder.length - 1)
		folder += "/";
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Delete&Path=" + encodeURIComponent(folder + name) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();
		}
	});
}

function Rename(name, value)
{
	if (value == null)
	{
		Prompt(_lang_input_name, "", function(returnValue){if (returnValue != null && returnValue != "")Rename(name, returnValue);}, this);
	}
	else
	{
		var folder = $("#Folder").val();
		if (folder.lastIndexOf("/") != folder.length - 1)
			folder += "/";
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Rename&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(folder + value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Move(name, value)
{
	if (value == null)
	{
		Prompt(_lang_input_name, "", function(returnValue){if (returnValue != null && returnValue != "")Move(name, returnValue);}, this);
	}
	else
	{
		var folder = $("#Folder").val();
		if (folder.lastIndexOf("/") != folder.length - 1)
			folder += "/";
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		
		var slash = value.lastIndexOf("/");
		var dot = value.indexOf(".", slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += "/";
			value += name;
		}
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Move&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Copy(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_name, "", function(returnValue){if (returnValue != null && returnValue != "")Copy(name, returnValue);}, this);
	}
	else
	{
		var folder = document.getElementById("Folder").value;
		if (folder.lastIndexOf("/") != folder.length - 1)
			folder += "/";
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		
		var slash = value.lastIndexOf("/");
		var dot = value.indexOf(".", slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += "/";
			value += name;
		}
	
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Copy&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Zip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_file, "", function(returnValue){if (returnValue != null && returnValue != "")Zip(name, returnValue);}, this);
	}
	else
	{
		if (value.length <= 4 || value.substr(value.length - 4) != ".zip")
		{
			Alert(_lang_must_be_zip);
			return;
		}
		
		var folder = $("#Folder").val();
		if (folder.lastIndexOf("/") != folder.length - 1)
			folder += "/";
			
		if (value.indexOf('/') != 0)
			result = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Zip&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function UnZip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_folder, "", function(returnValue){if (returnValue != null && returnValue != "")UnZip(name, returnValue);}, this);
	}
	else
	{
		var folder = $("#Folder").val();
		if (folder.lastIndexOf("/") != folder.length - 1)
			folder += "/";
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=UnZip&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Folder=" + folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function NormalizeFolder()
{
	var input = $("#Folder")[0];
	var value = input.value;
	var slash = value.indexOf("/");
	if (slash == 0)
		value = value.substr(1);
	if (value == "")
		return _root;
	
	if (value.lastIndexOf("/") != value.length - 1)
		value += "/";
	
	return _root + value;
}

function BuildTransfer(folder)
{
	return "&Transfer=" + encodeURIComponent(BuildAjaxPath(true) + "?Lang=" + _lang + "&Root=" + folder + "&ListByPicture=" + $("#ListByPicture")[0].checked);
}

function Select_List()
{
	var folder = NormalizeFolder();
	if (arguments.length == 1 && typeof(arguments[0]) == "string")
		folder += arguments[0] + "/";
	$("#Folder").val(folder.substr(_root.length - 1));
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildAjaxPath(true) + "?Lang=" + _lang + "&Root=" + encodeURIComponent(folder) + "&ListByPicture=" + $("#ListByPicture")[0].checked,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();
		}
	});
}

function Select_Up()
{
	var folder = NormalizeFolder();
	if (folder == _root)
		return;
		
	var slash = folder.lastIndexOf("/", folder.length - 2);
	if (slash == -1)
		return;
	
	folder = folder.substr(0, slash).substr(_root.length - 1);
	$("#Folder").val(folder == "" ? "/" : folder);

	Select_List();
}

function Select_CreateFolder(value)
{
	if (typeof(value) != "string")
	{
		Prompt(_lang_folder_name, "", function(returnValue){if (returnValue != null && returnValue != "")Select_CreateFolder(returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=CreateFolder&Path=" + encodeURIComponent(folder + value) + BuildTransfer(folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Select_Rename(name, value)
{
	if (value == null)
	{
		Prompt(_lang_input_name, "", function(returnValue){if (returnValue != null && returnValue != "")Select_Rename(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Rename&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(folder + value) + BuildTransfer(folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Select_Move(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_folder, "", function(returnValue){if (returnValue != null && returnValue != "")Select_Move(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		else
			value = (_root + value).replace("//", "/");
		
		var slash = value.lastIndexOf("/");
		var dot = value.indexOf(".", slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += "/";
			value += name;
		}
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Move&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Select_Copy(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_name, "", function(returnValue){if (returnValue != null && returnValue != "")Select_Copy(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();
			
		if (value.indexOf('/') != 0)
			value = folder + value;
		else
			value = (_root + value).replace("//", "/");
		
		var slash = value.lastIndexOf("/");
		var dot = value.indexOf(".", slash + 1);
		if (dot == -1)
		{
			if (slash != value.length - 1)
				value += "/";
			value += name;
		}
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Copy&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Select_Zip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_file, "", function(returnValue){if (returnValue != null && returnValue != "")Select_Zip(name, returnValue);}, this);
	}
	else
	{
		if (value.length <= 4 || value.substr(value.length - 4) != ".zip")
		{
			Alert(_lang_must_be_zip);
			return;
		}
		
		var folder = NormalizeFolder();
			
		if (value.indexOf('/') == 0)
			value = _root + value.substr(1);
		else
			value = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Zip&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Select_UnZip(name, value)
{
	if (value == null)
	{
		Prompt(_lang_target_folder, "", function(returnValue){if (returnValue != null)Select_UnZip(name, returnValue);}, this);
	}
	else
	{
		var folder = NormalizeFolder();

		if (value.indexOf('/') == 0)
			value = _root + value.substr(1);
		else
			value = folder + value;
		
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=UnZip&From=" + encodeURIComponent(folder + name) + "&To=" + encodeURIComponent(value) + BuildTransfer(folder),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				$("#List").html(HandleFake404(data, "text"));
				SetStatusMessage();
			}
		});
	}
}

function Select_Delete(name)
{
	var folder = NormalizeFolder();
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=FileManager&Operation=Delete&Path=" + encodeURIComponent(folder + name) + BuildTransfer(folder),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();
		}
	});
}

function Select_Upload()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	var folder = NormalizeFolder();

	$(":submit")[0].disabled = true;
    SetStatusMessage(_lang_start_upload);
    
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=FileManager&Operation=Upload&Folder=" + encodeURIComponent(folder) + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("File", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
        }
        else
        {
    		Alert(_lang_operation_success);
    		Select_List();
    	}
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });

	return false;
}

//End : 文件管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 实例管理
function AddInstance()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ModuleID=" + this.ModuleID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&DatabaseProvider=" + this.DatabaseProvider.value;
	data += "&ConnectionString=" + encodeURIComponent(this.ConnectionString.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Instance&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditInstance()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&DatabaseProvider=" + this.DatabaseProvider.value;
	data += "&ConnectionString=" + encodeURIComponent(this.ConnectionString.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Instance&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyInstance(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Instance&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
	
	return false;
}

function MoveInstance(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Instance&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function DeleteInstance(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Instance&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#Row" + id).remove();
		}
	});
}
//End : 实例管理
//-------------------------------------------------
function AddLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Ab.value == "")
	{
		Alert(_lang_ab_empty, function(){this.Ab.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Ab=" + encodeURIComponent(this.Ab.value);
	data += "&Direction=" + encodeURIComponent(this.Direction.value);
	data += "&FontFamily=" + encodeURIComponent(this.FontFamily.value);
	data += "&Eot=" + encodeURIComponent(this.Eot.value);
	if (this.Candidate.selectedIndex != 0)
	{
		var items = this.Candidate.value.split("|");
		data += "&ID=" + items[0];
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&FontFamily=" + encodeURIComponent(this.FontFamily.value);
	data += "&Eot=" + encodeURIComponent(this.Eot.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function DeleteLanguage(id, allButton)
{
    var all = "";
    if (allButton != null)
	{
        all = "&All=true";
		allButton.disabled = true;
	}

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Delete&ID=" + id + all,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 语言管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 日志管理
function UpdateLog(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "" && action != "DeleteAll")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateLog(action, id);}, this);
		else if (action == "DeleteAll")
			Confirm(_lang_confirm_delete_all, function(returnValue){if (returnValue)UpdateLog(action, id);}, this);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Log&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));				
			}
		});
	}
}	
//End : 日志管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模块管理
function AddModule()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ID=" + this.ID.value;
	data += "&Namespace=" + encodeURIComponent(this.Namespace.value);
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditModule()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	//创建日期	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
		Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}	
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	if (this.UpdateTime.value != "")
		data += "&UpdateTime=" + this.UpdateTime.value;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module&Operation=Modify&Namespace=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function DeleteModule(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module&Operation=Delete&Namespace=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}

function BuildAlias()
{
    var me = $(this);
    me.attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module&Operation=BuildAlias",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.attr("disabled", false);
		}
	});
}

function AddModuleObject()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ID=" + this.ID.value;
	data += "&ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&TableName=" + encodeURIComponent(this.TableName.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=Add&Namespace=" + _namespace,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditModuleObject()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&TableName=" + encodeURIComponent(this.TableName.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=Modify&ID=" + _id + "&Namespace=" + _namespace,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyModuleObject(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=Modify&ID=" + id + "&Namespace=" + _namespace,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function MoveModuleObject(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Namespace=" + _namespace,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function DeleteModuleObject(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=Delete&ID=" + id + "&Namespace=" + _namespace,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function AddOperation()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ID=" + this.ID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Operation&Operation=Add&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditOperation()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Operation&Operation=Modify&ID=" + _id + "&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyOperation(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Operation&Operation=Modify&ID=" + id + "&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteOperation(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Operation&Operation=Delete&ID=" + id + "&Namespace=" + _namespace + "&ObjectID=" + _objectID + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}

function AddProperty()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.MaxLength.value.match(/^\d*$/))
	{
		Alert(_lang_max_length_incorrect, function(){this.MaxLength.select();}, this);
		return false;
	}

	if (!this.NumericPrecision.value.match(/^\d*$/))
	{
		Alert(_lang_numeric_precision_empty, function(){this.NumericPrecision.select();}, this);
		return false;
	}

	if (!this.NumericScale.value.match(/^\d*$/))
	{
		Alert(_lang_numeric_scale_empty, function(){this.NumericScale.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&FieldName=" + encodeURIComponent(this.FieldName.value);
	data += "&IsNullable=" + $("#IsNullableYes")[0].checked;
	data += "&SqlDbDefault=" + encodeURIComponent(this.SqlDbDefault.value);
	data += "&OleDbDefault=" + encodeURIComponent(this.OleDbDefault.value);
	data += "&SqlDbType=" + this.SqlDbType.value;
	data += "&OleDbType=" + this.OleDbType.value;
	data += "&MaxLength=" + this.MaxLength.value;
	data += "&NumericPrecision=" + this.NumericPrecision.value;
	data += "&NumericScale=" + this.NumericScale.value;
	data += "&IsIdentity=" + $("#IsIdentityYes")[0].checked;
	data += "&MultiLanguage=" + $("#MultiLanguageYes")[0].checked;
	data += "&PrimaryKey=" + $("#PrimaryKeyYes")[0].checked;
	data += "&Unique=" + $("#UniqueYes")[0].checked;
	data += "&IsMeta=" + $("#IsMetaYes")[0].checked;
	data += "&MainTableID=" + this.MainTableID.value;
	data += "&MainFieldID=" + this.MainFieldID.value;
	data += "&UpdateRule=" + $("#UpdateRuleYes")[0].checked;
	data += "&DeleteRule=" + $("#DeleteRuleYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Property&Operation=Add&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditProperty()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.MaxLength.value.match(/^\d*$/))
	{
		Alert(_lang_max_length_incorrect, function(){this.MaxLength.select();}, this);
		return false;
	}

	if (!this.NumericPrecision.value.match(/^\d*$/))
	{
		Alert(_lang_numeric_precision_empty, function(){this.NumericPrecision.select();}, this);
		return false;
	}

	if (!this.NumericScale.value.match(/^\d*$/))
	{
		Alert(_lang_numeric_scale_empty, function(){this.NumericScale.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&FieldName=" + encodeURIComponent(this.FieldName.value);
	data += "&IsNullable=" + $("#IsNullableYes")[0].checked;
	data += "&SqlDbDefault=" + encodeURIComponent(this.SqlDbDefault.value);
	data += "&OleDbDefault=" + encodeURIComponent(this.OleDbDefault.value);
	data += "&SqlDbType=" + this.SqlDbType.value;
	data += "&OleDbType=" + this.OleDbType.value;
	data += "&MaxLength=" + this.MaxLength.value;
	data += "&NumericPrecision=" + this.NumericPrecision.value;
	data += "&NumericScale=" + this.NumericScale.value;
	data += "&IsIdentity=" + $("#IsIdentityYes")[0].checked;
	data += "&MultiLanguage=" + $("#MultiLanguageYes")[0].checked;
	data += "&PrimaryKey=" + $("#PrimaryKeyYes")[0].checked;
	data += "&Unique=" + $("#UniqueYes")[0].checked;
	data += "&IsMeta=" + $("#IsMetaYes")[0].checked;
	data += "&MainTableID=" + this.MainTableID.value;
	data += "&MainFieldID=" + this.MainFieldID.value;
	data += "&UpdateRule=" + $("#UpdateRuleYes")[0].checked;
	data += "&DeleteRule=" + $("#DeleteRuleYes")[0].checked;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Property&Operation=Modify&ID=" + _id + "&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function MoveProperty(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Property&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyProperty(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&FieldName=" + encodeURIComponent(form.FieldName.value);
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Property&Operation=Modify&ID=" + id + "&Namespace=" + _namespace + "&ObjectID=" + _objectID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteProperty(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Property&Operation=Delete&ID=" + id + "&Namespace=" + _namespace + "&ObjectID=" + _objectID + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}

function SqlDbType_OnChange()
{
    var form = this.form;
	var oleDbType = $("[name=OleDbType]")[0];
	switch (parseInt(form.SqlDbType.value))
	{
		case 8://Int
			CheckAndSelect(oleDbType, 3);
			break;
		case 12://NVarChar
			CheckAndSelect(oleDbType, 202);
			break;
		case 22://VarChar
			CheckAndSelect(oleDbType, 200);
			break;
		case 11://NText
			CheckAndSelect(oleDbType, 203);
			break;
		case 2://Bit
			CheckAndSelect(oleDbType, 11);
			break;
		case 15://SmallDateTime
			CheckAndSelect(oleDbType, 135);
			break;
		case 4://DateTime
			CheckAndSelect(oleDbType, 7);
			break;
		case 9://Money
			CheckAndSelect(oleDbType, 6);
			break;
		case 5://Decimal
			CheckAndSelect(oleDbType, 131);
			break;
		case 14://UniqueIdentifier
			CheckAndSelect(oleDbType, 72);
			break;
	}
}

function MainTableID_OnChange()
{
    var form = document.forms[0];
	if (form.MainTableID.selectedIndex > 0)
	{
		form.MainFieldID.length = 0;
		
		var condition = IlgharCMS.SystemModule.Module_Object_Property.ModuleInnerID + ":" + _namespace;
		condition += ";" + IlgharCMS.SystemModule.Module_Object_Property.ObjectID + ":" + form.MainTableID.value;
	
	    $.ajax(
	    {
		    url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Property&Operation=List&Condition=" + condition,
		    type : "GET",
		    error : function(request)
		    {
			    Alert(_lang_operation_fail);
		    },
		    success : function(data)
		    {
			    var mainFieldIDSelect = form.MainFieldID;
    			
			    var xmlDoc = CreateXmlDom();
			    xmlDoc.loadXML(data);
			    var itemList = xmlDoc.documentElement.childNodes;
			    for (var i = 0; i < itemList.length; i++)
			    {
					if (typeof (itemList[i].selectSingleNode) == "undefined")
						continue;
						
				    var id = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Module_Object_Property.ID).text;
				    var name = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Module_Object_Property.Name).text;

				    mainFieldIDSelect.options.add(new Option(name, id));
				    
				    if (_page == "module_object_property_edit" && id == _mainFieldID)
				    {
				        mainFieldIDSelect.selectedIndex = mainFieldIDSelect.length - 1;
				    }
			    }
		    }
	    });
	}
	else
	{
		form.MainFieldID.length = 0;
	}
}
//End : 模块管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 播放器管理
function AddPlayer()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Code=" + encodeURIComponent(this.Code.value);
	data += "&PackExtention=" + encodeURIComponent(this.PackExtention.value);
	data += "&Pack=" + encodeURIComponent(this.Pack.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	_uploadFile = _uploader.NeedUpload("File");
	if (!_uploadFile)
		data += "&File=" + encodeURIComponent(this.File.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Player&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadFile)
		    {
			    _guid = data;

		        SetStatusMessage(_lang_getting_innerid);
		        AddPlayer_GetInnerID();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
		    }
		}
	});
	
	return false;
}

function AddPlayer_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Player&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
            
			Player_UploadFile();
		}
	});
}

function EditPlayer()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Code=" + encodeURIComponent(this.Code.value);
	data += "&PackExtention=" + encodeURIComponent(this.PackExtention.value);
	data += "&Pack=" + encodeURIComponent(this.Pack.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	_uploadFile = _uploader.NeedUpload("File");
	if (!_uploadFile)
		data += "&File=" + encodeURIComponent(this.File.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Player&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
	        if (_uploadFile)
	        {
		        Player_UploadFile();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
		    }
		}
	});
	
	return false;
}

function Player_UploadFile()
{
    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Player&Operation=UploadFile&ID=" + _id});
    _uploader.Upload("File", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function DeletePlayer(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Player&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function CreateAllCodeFile()
{
    var me = $(this);
    me.attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Player&Operation=CreateAllCodeFile",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.attr("disabled", false);
		}
	});
}
//End : 播放器管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 角色管理
function AddRole()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&HasPrivilegeByDefault=" + $("#HasPrivilegeByDefaultYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Role&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditRole()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&HasPrivilegeByDefault=" + $("#HasPrivilegeByDefaultYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Role&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function DeleteRole(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Role&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function SavePrivilege()
{
	_addIndex = 0;
	_addList.length = 0;
	_deleteIndex = 0;
	_deleteList.length = 0;

    $("[name=OperationID]").each(function()
    {
        var me = $(this);
	    if (this.checked && me.attr("PrivilegeID") == "")
	    {
		    var data = "InstanceID=" + $("#InstanceID").val() + "&Lang=" + $("#CurrentLang").val() + "&ObjectID=" + me.attr("ObjectID") + "&OperationID=" + me.val() + "&ObjectName=" + me.attr("ObjectName") + "&OperationName=" + me.attr("OperationName");
		    if ($("#RoleID").val() != "")
			    data += "&RoleID=" + $("#RoleID").val();

		    _addList[_addList.length] = new Object();
		    _addList[_addList.length - 1].ID = this.id;
		    _addList[_addList.length - 1].Data = data;
	    }
	    else if (!this.checked && me.attr("PrivilegeID") != "")
	    {
		    _deleteList[_deleteList.length] = new Object();
		    _deleteList[_deleteList.length - 1].ID = this.id;
		    _deleteList[_deleteList.length - 1].PrivilegeID = me.attr("PrivilegeID");
	    }
    });
	
	if (_addList.length == 0 && _deleteList.length == 0)
	{
		Alert(_lang_no_changes);
		return;
	}
	
	$("#Save").attr("disabled", true);
	SetStatusMessage(_lang_working);
	DeletePrivilege();
}

function DeletePrivilege()
{
	if (_deleteIndex >= _deleteList.length)
	{
		AddPrivilege();
		return;
	}

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Privilege&Operation=Delete&ID=" + _deleteList[_deleteIndex++].PrivilegeID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$("#Save").attr("disabled", false);
		},
		success : function(data)
		{
		    $("#" + _deleteList[_deleteIndex - 1].ID).attr("PrivilegeID", "");
			DeletePrivilege();
		}
	});
}

function AddPrivilege()
{
	if (_addIndex >= _addList.length)
	{
	    Alert(_lang_operation_success);
	    SetStatusMessage();
		$("#Save").attr("disabled", false);
		return;
	}

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Privilege&Operation=Add",
		data : _addList[_addIndex++].Data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$("#Save").attr("disabled", false);
		},
		success : function(data)
		{
	        $.ajax(
	        {
		        url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Privilege&Operation=GetInnerIDFromGuid&ID=" + data,
		        type : "GET",
		        error : function(request)
		        {
			        Alert(_lang_operation_fail);
			        SetStatusMessage();
			        $("#Save").attr("disabled", false);
		        },
		        success : function(data)
		        {
		            $("#" + _addList[_addIndex - 1].ID).attr("PrivilegeID", data);
			        AddPrivilege();
		        }
		    });
		}
	});
}
//End : 角色管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 皮肤管理
function AddSkin()
{
	if (this.TemplatePath.value == "")
	{
        Alert(_lang_select_template);
		return false;
	}

	if (this.Language.value == "")
	{
        Alert(_lang_select_language);
		return false;
	}
	
	var data = "Path=" + encodeURIComponent(this.SkinPath.value);
	data += "&TemplatePath=" + encodeURIComponent(this.TemplatePath.value);
	data += "&Language=" + encodeURIComponent(this.Language.value);
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&AuthorName=" + encodeURIComponent(this.AuthorName.value);
	data += "&AuthorID=" + encodeURIComponent(this.AuthorID.value);
	data += "&Organization=" + encodeURIComponent(this.Organization.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditSkin()
{
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Version=" + this.Version.value;
	data += "&AuthorName=" + this.AuthorName.value;
	data += "&AuthorID=" + this.AuthorID.value;
	data += "&Organization=" + this.Organization.value;
	data += "&Description=" + this.Description.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin&Operation=Modify&Path=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function DeleteSkin(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin&Operation=Delete&Path=" + encodeURIComponent(id) + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}

function UploadSkinPicture()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!this.Width.value.match(/^\d*$/))
	{
		Alert(_lang_width_incorrect, function(){this.Width.select();}, this);
		return false;
	}	
	
	if (!this.Height.value.match(/^\d*$/))
	{
		Alert(_lang_height_incorrect, function(){this.Height.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.File.value, this.AllowedType.value))
	{
		Alert(_lang_type_must_be + this.AllowedType.value);
		return false;
	}
    
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Skin&Operation=UploadPicture&Path=" + _id});
	_uploader.Upload("File", function()
	{
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
            Alert(_lang_operation_success);
        SetStatusMessage();
        $(":submit")[0].disabled = false;
	});
	
	return false;
}

function UploadSkinThumbnail()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!IsAllowedType(this.File.value, this.AllowedType.value))
	{
		Alert(_lang_type_must_be + this.AllowedType.value);
		return false;
	}
    
    $(":submit")[0].disabled = true;
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Skin&Operation=UploadThumbnail&Path=" + _id});
	_uploader.Upload("File", function()
	{
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
            Alert(_lang_operation_success);
        SetStatusMessage();
        $(":submit")[0].disabled = false;
	});
	
	return false;
}

function Skin_GetLanguageList()
{
	SetStatusMessage(_lang_loading_language_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=List",
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_xmlLanguage.loadXML(data);
			
			Skin_GetSkinList();
		}
	});
}

function Skin_GetSkinList()
{
	SetStatusMessage(_lang_loading_skin_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin&Operation=List",
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var templateSelect = document.forms[0].TemplatePath;
			
			_xmlSkin.loadXML(data);
			var items = _xmlSkin.documentElement.childNodes;
			for (var i = 0; i < items.length; i++)
			{
				if (typeof (items[i].selectSingleNode) == "undefined")
					continue;
						
				var templatePath = items[i].selectSingleNode(IlgharCMS.SystemModule.Skin.TemplatePath).text;
				var j = 0;
				for (; j < templateSelect.options.length; j++)
				{
					if (templateSelect.options[j].value == templatePath)
						break;
				}
				
				if (j < templateSelect.options.length)
					continue;
					
				templateSelect.options.add(new Option(templatePath, templatePath));
			}
			
			Skin_TemplatePath_OnChange();
			SetStatusMessage();
		}
	});
}

function Skin_TemplatePath_OnChange()
{
    var form = document.forms[0];
    
	var templateSelect = form.TemplatePath;
	if (templateSelect.selectedIndex == -1)
		return;
	
	var skinSelect = form.SkinPath;
	skinSelect.length = 1;
	var items = _xmlSkin.selectNodes("//Item[" + IlgharCMS.SystemModule.Skin.TemplatePath + "='" + templateSelect.value + "']");
	for (var i = 0; i < items.length; i++)
	{
		var path = items[i].selectSingleNode(IlgharCMS.SystemModule.Skin.Path).text;
		path = path.substr(templateSelect.value.length);
		path = path.substr(0, path.indexOf("/") + 1);
				
		var j = 0;
		for (; j < skinSelect.options.length; j++)
		{
			if (skinSelect.options[j].text == path)
				break;
		}
		
		if (j < skinSelect.options.length)
			continue;

		skinSelect.options.add(new Option(path, path));
	}
	
	var languageSelect = form.Language;
	languageSelect.length = 0;
	items = _xmlLanguage.documentElement.childNodes;
	for (var i = 0; i < items.length; i++)
	{
		if (typeof (items[i].selectSingleNode) == "undefined")
			continue;
						
		var name = items[i].selectSingleNode(IlgharCMS.SystemModule.Language.Name).text;
		var ab = items[i].selectSingleNode(IlgharCMS.SystemModule.Language.Ab).text;

		languageSelect.options.add(new Option(name, ab));
	}	
    
}

function Skin_SkinPath_OnChange()
{
    var form = document.forms[0];
    
	var languageSelect = form.Language;
	languageSelect.length = 0;
	items = _xmlLanguage.documentElement.childNodes;
	
	if (form.SkinPath.value == "")
	{
		for (var i = 0; i < items.length; i++)
		{
			if (typeof (items[i].selectSingleNode) == "undefined")
				continue;
						
			var name = items[i].selectSingleNode(IlgharCMS.SystemModule.Language.Name).text;
			var ab = items[i].selectSingleNode(IlgharCMS.SystemModule.Language.Ab).text;
	
			languageSelect.options.add(new Option(name, ab));
		}	
	}
	else
	{
		for (var i = 0; i < items.length; i++)
		{
			if (typeof (items[i].selectSingleNode) == "undefined")
				continue;
						
			var name = items[i].selectSingleNode(IlgharCMS.SystemModule.Language.Name).text;
			var ab = items[i].selectSingleNode(IlgharCMS.SystemModule.Language.Ab).text;

			var nodeList = _xmlSkin.selectNodes("//Item[" + IlgharCMS.SystemModule.Skin.Path + "='" + form.TemplatePath.value + form.SkinPath.value + ab + "/']");
			if (nodeList.length > 0)
				continue;
	
			languageSelect.options.add(new Option(name, ab));
		}	
	}
}

function DeleteCss(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin.Css&Operation=Delete&Name=" + id + "&SkinPath=" + _skinPath,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function AddCss()
{
	if (!CheckFileName(this.Name.value))
	{
		Alert(_lang_file_name_invalid, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value + ".css");
	data += "&Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin.Css&Operation=Add&SkinPath=" + _skinPath,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditCss()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin.Css&Operation=Modify&Name=" + _id + "&SkinPath=" + _skinPath,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function CheckFileName(name)
{
	if (name.match(/^(CON\.)|(AUX\.)|(COM1\.)|(COM2\.)|(COM3\.)|(COM4\.)|(LPT1\.)|(LPT2\.)|(LPT3\.)|(PRN\.)|(NUL\.)/))
		return false;

	if (name.match(/^((CON)|(AUX)|(COM1)|(COM2)|(COM3)|(COM4)|(LPT1)|(LPT2)|(LPT3)|(PRN)|(NUL))$/))
		return false;
		
	if (name.length >= 255)
		return false;
	
	if (name.match(/"|'|\/|\\|:|\|/))
		return false;
	
	if (!name.match(/^[a-z]|[A-Z]|\d/))
		return false;
	
	return true;
}

function DeleteFile(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin.Image&Operation=DeleteFile&FolderName=" + encodeURIComponent($("#Folder").val()) + "&FileName=" + id + "&SkinPath=" + _skinPath,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).html("<span style='color:#333'>" + _lang_deleted + "</span>");
		}
	});
}

function DeleteFolder()
{
	if ($("#Folder").val() == "")
	{
		Alert(_lang_cant_delete_root);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin.Image&Operation=DeleteFolder&FolderName=" + encodeURIComponent($("#Folder").val()) + "&SkinPath=" + _skinPath,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			var folder = $("#Folder")[0];
			folder.remove(folder.selectedIndex);
			folder.selectedIndex = folder.length - 1;
			Folder_OnChange();			
		}
	});
}

function Folder_OnChange()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildAjaxPath(true) + "?Lang=" + _lang + "&SkinPath=" + _skinPath + "&Folder=" + encodeURIComponent($("#Folder").val()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			//Init();
	
			if ($("Folder").val() == "/")
				$("#DeleteFolder").attr("disabled", true);
			else
				$("#DeleteFolder").attr("disabled", false);
			
			SetStatusMessage();
		}
	});
}

function TranslateSkin()
{
	if ($("#To").val() == "")
	{
		Alert(_lang_select_target);
		return;
	}
	
	$("#Start").eq(0).attr("disabled", true);
	$("body").append(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin&Operation=Translate&Path=" + _path + "&To=" + encodeURIComponent($("#To").val()) + "&MoveImage=" + $("#MoveImage")[0].checked,
		data : {},
		type : "POST",
		error : function(request)
		{
			$("body").append(_lang_operation_fail);
	        $("#Start").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			$("body").append(_lang_operation_success);
	        $("#Start").eq(0).attr("disabled", false);
		}
	});
}

function UploadSkinImage()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!IsAllowedType(this.File.value, this.AllowedType.value))
	{
		Alert(_lang_type_must_be + this.AllowedType.value);
		return false;
	}
    
    $(":submit")[0].disabled = true;
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Skin.Image&Operation=Upload&FolderName=" + encodeURIComponent(this.Folder.value) + "&SkinPath=" + _skinPath});
	_uploader.Upload("File", function()
	{
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
            Alert(_lang_operation_success);
        SetStatusMessage();
        $(":submit")[0].disabled = false;
	});
	
	return false;
}

function SkinImage_AddFolder()
{
	var folderName = $("#FolderName").val();
	if (!CheckFileName(folderName))
	{
		Alert(_lang_file_name_invalid);
		return;
	}
	
	var folder = $("#Folder")[0];
	folderName = folder.value + "/" + folderName;
	var len = folder.value.length;
	for (var i = 0; i < len; i++)
	{
		if (folder.options[i].value == folderName)
		{
		    Alert(_lang_folder_exist);
			return;
		}
	}
	
	$("#AddFolder").eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Skin.Image&Operation=AddFolder&FolderName=" + encodeURIComponent(folderName) + "&SkinPath=" + _skinPath,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
	        
			var folderName = $("#Folder").val() + "/" + $("#FolderName").val();
			$("#FolderName").val("");
			$("#Folder")[0].options.add(new Option(folderName, folderName));
			$("#Folder")[0].selectedIndex = $("#Folder")[0].length - 1;
		}
	});
}
//End : 皮肤管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模板管理
function AddTemplate()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Language=" + this.Language.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&SystemVersion=" + encodeURIComponent(this.SystemVersion.value);
	data += "&AuthorName=" + encodeURIComponent(this.AuthorName.value);
	data += "&AuthorID=" + encodeURIComponent(this.AuthorID.value);
	data += "&Organization=" + encodeURIComponent(this.Organization.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditTemplate()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&SystemVersion=" + encodeURIComponent(this.SystemVersion.value);
	data += "&AuthorName=" + encodeURIComponent(this.AuthorName.value);
	data += "&AuthorID=" + encodeURIComponent(this.AuthorID.value);
	data += "&Organization=" + encodeURIComponent(this.Organization.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=Modify&Path=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EncryptTemplate(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=Encrypt&Path=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});

    return false;
}

function DecryptTemplate(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=Decrypt&Path=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});

    return false;
}

function ClearTemplateCache(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=ClearCache&Path=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});

    return false;
}

function DeleteTemplate(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template&Operation=Delete&Path=" + encodeURIComponent(id) + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}
//End : 模板管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模板词典管理
function AddTemplateDictionary()
{
	if (this.TargetLanguageAb.value == "")
	{
		Alert(_lang_target_language_empty);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&From=" + encodeURIComponent(this.SourceLanguage.value);
	data += "&To=" + encodeURIComponent(this.TargetLanguage.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Dictionary&Operation=Add&TemplatePath=" + _templatePath + "&Language=" + this.TargetLanguageAb.value + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;

			$("#List").html(HandleFake404(data, "text"));
			//Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
	
	return false;
}

function ModifyTemplateDictionary(form, id)
{
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&From=" + encodeURIComponent(form.SourceLanguage.value);
	data += "&To=" + encodeURIComponent(form.TargetLanguage.value);
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Dictionary&Operation=Modify&ID=" + id + "&TemplatePath=" + _templatePath + "&Language=" + document.forms[0].TargetLanguageAb.value,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
	
	return false;
}

function DeleteTemplateDictionary(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Dictionary&Operation=Delete&&ID=" + id + "&TemplatePath=" + _templatePath + "&Language=" + document.forms[0].TargetLanguageAb.value + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}

function TargetLanguageAb_OnChange()
{
	SetCookie("TargetLanguageAb", this.value, 10*360*24*60);
	$(this.form.TargetLanguage).attr("class", "Text " + this.value + "Font");
	Search(1);
}

function GetChineseString()
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Dictionary&Operation=GetString&TemplatePath=" + _templatePath + "&Language=" + document.forms[0].TargetLanguageAb.value + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}
//End : 模板词典管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模块绑定
function AddTemplateModule()
{
	var data = "ModuleID=" + this.ModuleID.value;
	data += "&Mark=" + encodeURIComponent(this.Mark.value);
	data += "&JustData=" + this.JustData.checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Module&Operation=Add&TemplatePath=" + _templatePath + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
	
	return false;
}

function DeleteTemplateModule(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Module&Operation=Delete&_Mark=" + id + "&TemplatePath=" + _templatePath + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}
//End : 模块绑定
//-------------------------------------------------

//-------------------------------------------------
//Start : 模板页面管理
function TemplatePage_AddFolder()
{
	var folderName = $("#FolderName").val();
	if (!CheckFileName(folderName))
	{
		Alert(_lang_file_name_invalid);
		return;
	}
	
	var folder = $("#Folder")[0];
	folderName = folder.value + "/" + folderName;
	var len = folder.value.length;
	for (var i = 0; i < len; i++)
	{
		if (folder.options[i].value == folderName)
		{
		    Alert(_lang_folder_exist);
			return;
		}
	}
	
	$("#AddFolder").eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Page&Operation=AddFolder&Folder=" + encodeURIComponent(folderName) + "&TemplatePath=" + _templatePath,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
	        
	        var folder = $("#Folder")[0];
	        var folderName = $("#FolderName")[0];
			var value = "";
			if (folder.selectedIndex > 0)
			    value = folder.value + "/" + folderName.value;
			else
			    value = folderName.value;
			folderName.value = "";
			folder.options.add(new Option(value, value));
			folder.selectedIndex = folder.length - 1;
		}
	});
}

function TemplatePage_DeleteFolder()
{
	var folder = $("#Folder")[0];
	if (folder.value == "")
	{
		Alert(_lang_cant_delete_root);
		return;
	}
	
	$("#DeleteFolder").attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Page&Operation=DeleteFolder&Folder=" + encodeURIComponent(folder.value) + "&TemplatePath=" + _templatePath + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var index = folder.selectedIndex;
			folder.options.remove(index);
			folder.selectedIndex = index - 1;
	        $("#DeleteFolder").attr("disabled", false);

			SetStatusMessage();
		}
	});
}

function AddTemplatePage()
{
	if (!CheckFileName(this.Name.value))
	{
		Alert(_lang_file_name_invalid, function(){this.Name.select();}, this);
		return false;
	}
	
	var folder = $("#Folder")[0];
	var pathInTemplate = "";
	if (folder.selectedIndex > 0)
		pathInTemplate = folder.value + "/" + this.Name.value;
	else
		pathInTemplate = this.Name.value;
	pathInTemplate += $("#Extention").text();
	
	
	var data = "PathInTemplate=" + encodeURIComponent(pathInTemplate);
	data += "&Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Page&Operation=Add&TemplatePath=" + _templatePath,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditTemplatePage()
{
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Page&Operation=Modify&PathInTemplate=" + _id + "&TemplatePath=" + _templatePath,
		data : "Content=" + encodeURIComponent(this.Content.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function DeleteTemplatePage(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Page&Operation=Delete&PathInTemplate=" + id + "&TemplatePath=" + _templatePath + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}
//End : 模板页面管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模板脚本管理
function AddTemplateScript()
{
	if (!CheckFileName(this.Name.value))
	{
		Alert(_lang_file_name_invalid, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value + ".js");
	data += "&Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Script&Operation=Add&TemplatePath=" + _templatePath,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditTemplateScript()
{
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Script&Operation=Modify&Name=" + _id + "&TemplatePath=" + _templatePath,
		data : "Content=" + encodeURIComponent(this.Content.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function DeleteTemplateScript(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Script&Operation=Delete&Name=" + id + "&TemplatePath=" + _templatePath + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			//Init();
		}
	});
}
//End : 模板脚本管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 模板模块菜单
function AddTemplateMenu()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + this.ParentID.value;
	data += "&ObjectID=" + this.ObjectID.value;
	data += "&OperationID=" + this.OperationID.value;
	data += "&PathInTemplate=" + encodeURIComponent(this.PathInTemplate.value);
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Target=" + encodeURIComponent(this.Target.value);
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	data += "&IsDefault=" + $("#IsDefaultYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Menu&Operation=Add&TemplatePath=" + _templatePath + "&Namespace=" + $("#Namespace").val(),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success, function(){TemplateMenu_GetParentList("adding")});
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditTemplateMenu()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + this.ParentID.value;
	data += "&ObjectID=" + this.ObjectID.value;
	data += "&OperationID=" + this.OperationID.value;
	data += "&PathInTemplate=" + encodeURIComponent(this.PathInTemplate.value);
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Target=" + encodeURIComponent(this.Target.value);
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	data += "&IsDefault=" + $("#IsDefaultYes")[0].checked;

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Menu&Operation=Modify&TemplatePath=" + _templatePath + "&Namespace=" + _namespace + "&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		}
	});
	
	return false;	
}

function ModifyTemplateMenu(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Menu&Operation=Modify&TemplatePath=" + _templatePath + "&Namespace=" + _namespace + "&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function MoveTemplateMenu(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Menu&Operation=" + g_action + "&From=" + from + "&To=" + to + "&TemplatePath=" + _templatePath + "&Namespace=" + $("#Namespace").val(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function DeleteTemplateMenu(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Menu&Operation=Delete&TemplatePath=" + _templatePath + "&Namespace=" + $("#Namespace").val() + "&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function TemplateMenu_GetPageList(type)
{
	var pageSelect = $("#PathInTemplate")[0];
	pageSelect.length = 0;
	pageSelect.options.add(new Option(_lang_none, ""));

	SetStatusMessage(_lang_loading_page_list);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Page&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Template_Page.TemplatePath + ":" + _templatePath),
		type : "GET",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var pageSelect = $("#PathInTemplate")[0];

			_xmlDoc.loadXML(data);
			var itemList = _xmlDoc.documentElement.childNodes;
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (itemList[i].selectSingleNode) == "undefined")
					continue;
				
				var namespace;
				if (_page == "template_menu_edit")
					namespace = _namespace;
				else
					namespace = $("#Namespace").val();

				var pathInTemplate = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Template_Page.PathInTemplate).text;
				if (pathInTemplate.indexOf(namespace) != -1)
				{
					pathInTemplate = pathInTemplate.substr(namespace.length + 1);
					pageSelect.options.add(new Option(pathInTemplate, pathInTemplate));
				}
			}
			
			if (_page == "template_menu_add")
			{
			    TemplateMenu_GetParentList(type);
			}
			else if (type == "loading")
			{
				CheckAndSelect(pageSelect, _pathInTemplate);
				TemplateMenu_GetObjectList(type);
			}
		}
	});
}

function TemplateMenu_GetParentList(type)
{
	SetStatusMessage(_lang_loading_parent_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Template.Menu&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Template_Menu.Namespace + ":" + $("#Namespace").val() + ";" + IlgharCMS.SystemModule.Template_Menu.TemplatePath + ":" + _templatePath),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var parentSelect = $("#ParentID")[0];
			var curParent = parentSelect.value;
			parentSelect.length = 0;
			parentSelect.options.add(new Option(_lang_none, ""));
		
			_xmlDoc.loadXML(data);	
			BuildTreeOptions(_xmlDoc, IlgharCMS.SystemModule.Template_Menu.ParentID, IlgharCMS.SystemModule.Template_Menu.ID, IlgharCMS.SystemModule.Template_Menu.Name, parentSelect);
			
			if (type != "loading")
			{
				CheckAndSelect(parentSelect, curParent);
				SetStatusMessage();
			}

			if (type != "adding")
				TemplateMenu_GetObjectList(type);
		}
	});
}

function TemplateMenu_GetObjectList(type)
{
	SetStatusMessage(_lang_loading_object_list);

	var namespace;
	if (_page == "template_menu_edit")
		namespace = _namespace;
	else
		namespace = $("#Namespace").val();

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Module_Object.Namespace + ":" + namespace),
		type : "GET",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var objectSelect = $("#ObjectID")[0];
			objectSelect.length = 1;
		
			_xmlDoc.loadXML(data);	
			BuildTreeOptions(_xmlDoc, IlgharCMS.SystemModule.Module_Object.ParentID, IlgharCMS.SystemModule.Module_Object.ID, IlgharCMS.SystemModule.Module_Object.Name, objectSelect);
			
			if (type == "loading")
			{
			    if (_page == "template_menu_edit" && _objectID != "")
			    {
					CheckAndSelect(objectSelect, _objectID);
					TemplateMenu_ObjectID_OnChange(type);
			    }
			}

			SetStatusMessage();
		}
	});
}

function TemplateMenu_ObjectID_OnChange(type)
{
	var operationSelect = $("#OperationID")[0];
	operationSelect.length = 0;
	operationSelect.options.add(new Option(_lang_none, ""));
	
	var objectSelect = $("#ObjectID")[0];
	if (objectSelect.selectedIndex == -1 || objectSelect.value == "")
		return;

	SetStatusMessage(_lang_loading_operation_list);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object.Operation&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Module_Object_Operation.ObjectID + ":" + objectSelect.value),
		type : "GET",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var operationSelect = $("#OperationID")[0];
		
			_xmlDoc.loadXML(data);
			var itemList = _xmlDoc.documentElement.childNodes;
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (itemList[i].selectSingleNode) == "undefined")
					continue;
						
				var value = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Module_Object_Operation.ID).text;
				var text = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Module_Object_Operation.Name).text;
				operationSelect.options.add(new Option(text, value));
			}
			
			if (_page == "template_menu_edit" && type == "loading")
			{
				CheckAndSelect(operationSelect, _operationID);
			}

			SetStatusMessage();
		}
	});
}
//End : 模板模块菜单
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "menu_add")
	{
		GetMenuParentList();
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form:first").submit(AddMenu);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("[name=CategoryID]").change(GetMenuParentList);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Menu")});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("[name=LinkType]").click(function()
		{
			if (this.id == "LinkTypeContent")
			{
				$("[name=Path]").hide();
				$("#PathTip").hide();
				$("#Page").show();
				$("#HtmlEditorTR").show();
				$("#ChannelIDSpan").show();
			}
			else if (this.id == "LinkTypeInnerLink")
			{
				$("#Page").hide();
				$("#HtmlEditorTR").hide();
				$("#ChannelIDSpan").show();
				$("#PathTip").show();
				$("[name=Path]").show();
				$("[name=Path]").val("");
			}
			else
			{
				$("#ChannelIDSpan").hide();
				$("#PathTip").hide();
				$("#Page").hide();
				$("#HtmlEditorTR").hide();
				$("[name=Path]").show();
				$("[name=Path]").val("http://");
			}
		});
		
		if (GetCookie("LinkType") != "")
			$("#" + GetCookie("LinkType"))[0].click();
		else
			$("#LinkTypeContent")[0].click();
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "menu_edit")
	{
		GetMenuParentList();
		CheckAndSelect($("[name=Target]")[0], _target);
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
				
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
		
		$("form:first").submit(EditMenu);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("[name=CategoryID]").change(GetMenuParentList);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Menu")});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);

		$("[name=LinkType]").click(function()
		{
			if (this.id == "LinkTypeContent")
			{
				$("[name=Path]").hide();
				$("#PathTip").hide();
				$("#Page").show();
				$("#HtmlEditorTR").show();
				$("#ChannelIDSpan").show();
			}
			else if (this.id == "LinkTypeInnerLink")
			{
				$("#Page").hide();
				$("#HtmlEditorTR").hide();
				$("#ChannelIDSpan").show();
				$("#PathTip").show();
				$("[name=Path]").show();
			}
			else
			{
				$("#ChannelIDSpan").hide();
				$("#PathTip").hide();
				$("#Page").hide();
				$("#HtmlEditorTR").hide();
				$("[name=Path]").show();
			}
		});
		
		if ($("[name=Path]")[0].value.indexOf("http://") == 0)
			$("#LinkTypeOuterLink")[0].click();
		else if (_linkTypeContent == "True")
			$("#LinkTypeContent")[0].click();
		else
			$("#LinkTypeInnerLink")[0].click();
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "menu_list")
	{
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyMenu(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteMenu(id);}, this);
			return false;
		});

		InitMove(null,"Move", null, MoveMenu);
		
		$("#CategoryID").change(Search);
	}
	else if (_page == "menu_category_add")
	{
		$("form").submit(AddMenuCategory);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "menu_category_edit")
	{
		$("form").submit(EditMenuCategory);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "menu_category_list")
	{
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			ModifyMenuCategory(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteMenuCategory(id);}, this);
			return false;
		});
		
		InitMove(null,"Move", null, MoveMenuCategory);
	}
	else if (_page == "generate_list")
	{
		//生成对象
		$("#List").delegate("input", "click", function()
		{
			window.open(HandleFake404("do.aspx?Type=Object&ChannelID=" + $("#ChannelID").val() + "&Object=" + this.name, "url"));
		});

		$("#ChannelID").change(function()
		{
			if ($(this.options[this.selectedIndex]).css("color") == "#ccc")
			{
				this.selectedIndex = 0;
				return false;
			}

			Search();
		});

		$("#ChannelID option").each(function()
		{
			if ($(this).attr("Generate") == "False")
				$(this).css("color", "#CCC");
		});
		
		//生成网站
		$(".ToolBar input").eq(1).click(function()
		{
			window.open(HandleFake404("do.aspx?Type=Site", "url"));
		});
		
		//生成栏目
		$(".ToolBar input").eq(0).click(function()
		{
			var channelIDSelect = document.getElementById("ChannelID");
			if ($("#ChannelID").val() == "")
			{
				Alert(_lang_select_channel);
				return;
			}
			
			window.open(HandleFake404("do.aspx?Type=Channel&ChannelID=" + $("#ChannelID").val(), "url"));
		});
	}
	else if (_page == "generate_do")
	{
		if (_channels.length == 0)
		{
			$(document.body).append("<div>" + _lang_nothing + "</div>");
			return;
		}
		
		_pages = CreateXmlDom();
		GetTemplatePages();
	}
	else if (_page == "channel_list")
	{
		var list = $("#List");

		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteChannel(id);}, this);
			return false;
		});
		
		InitMove(null,"Move", null, MoveChannel);
	}
	else if (_page == "channel_add")
	{
        _xmlChannel = CreateXmlDom();
        _xmlTemplate = CreateXmlDom();
        _xmlSkin = CreateXmlDom();
        
        GetTemplateList();
        
        if (_lang == "UYG")
        {
	        var option = document.createElement("OPTION");
	        option.text = _lang_uyl;
	        option.value = "UYL";
	        document.forms[0].TranslateLang.options.add(option);
        	
	        option = document.createElement("OPTION");
	        option.text = _lang_uyc;
	        option.value = "UYC";
	        document.forms[0].TranslateLang.options.add(option);
        }
        else if (_lang == "CHS")
        {
	        var option = document.createElement("OPTION");
	        option.text = _lang_cht;
	        option.value = "CHT";
	        document.forms[0].TranslateLang.options.add(option);
        }
        else if (_lang == "KGA")
        {
	        var option = document.createElement("OPTION");
	        option.text = _lang_kgc;
	        option.value = "KGC";
	        document.forms[0].TranslateLang.options.add(option);
        }
		
		$("form:first").submit(AddChannel);
		$("[name=Type]").click(Type_OnClick);
		$("[name=TemplatePath]").change(TemplatePath_OnChange);
		$("[name=SkinPath]").change(SkinPath_OnChange);
		$("[name=TranslateLang]").change(TranslateLang_OnChange);
		$("[name=InstanceID]").change(InstanceID_OnChange);
		$("#Match").click(Match_OnClick);
		$("#GenerateYes").click(function(){this.form.Extension.value=".htm";});
		$("#GenerateNo").click(function(){this.form.Extension.value=".aspx";});
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#LinkTextbox").change(function(){$("#LinkView").attr("src", this.value)});
		
		$("[name=IsDynamicTemplate]").click(function()
		{
			if ($("#IsDynamicTemplateYes")[0].checked)
				$("#DynamicTemplateID").show();
			else
				$("#DynamicTemplateID").hide();
		});
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		_uploader.Add("Link", "LinkTextbox", "LinkBrowse");
	}
	else if (_page == "channel_edit")
	{
	    $("#" + _type)[0].checked = true;
	    if (_type == "OuterLink")
	        $("#PathTip").html(_lang_path_tip2);
	    else
	        $("#PathTip").html(_lang_path_tip1);

		$("form:first").submit(EditChannel);
		$("#GenerateYes").click(function(){this.form.Extension.value=".htm";});
		$("#GenerateNo").click(function(){this.form.Extension.value=".aspx";});
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#LinkTextbox").change(function(){$("#LinkView").attr("src", this.value)});
		
		$("[name=IsDynamicTemplate]").click(function()
		{
			if ($("#IsDynamicTemplateYes")[0].checked)
				$("#DynamicTemplateID").show();
			else
				$("#DynamicTemplateID").hide();
		});
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		_uploader.Add("Link", "LinkTextbox", "LinkBrowse");
	}
	else if (_page == "channel_change_template")
	{
        _xmlTemplate = CreateXmlDom();
        _xmlSkin = CreateXmlDom();
        
        var form = document.forms[0];
        if (_channelLang == "UYG")
        {
	        var option = document.createElement("OPTION");
	        option.text = _lang_uyl;
	        option.value = "UYL";
	        form.TranslateLang.options.add(option);
        	
	        option = document.createElement("OPTION");
	        option.text = _lang_uyc;
	        option.value = "UYC";
	        form.TranslateLang.options.add(option);
        }
        else if (_channelLang == "CHS")
        {
	        var option = document.createElement("OPTION");
	        option.text = _lang_cht;
	        option.value = "CHT";
	        form.TranslateLang.options.add(option);
        }
        else if (_channelLang == "KGA")
        {
	        var option = document.createElement("OPTION");
	        option.text = _lang_kgc;
	        option.value = "KGC";
	        form.TranslateLang.options.add(option);
        }
        
        CheckAndSelect(form.TranslateLang, _translateLang);
        if (form.TemplateLang.value == form.TranslateLang.value)
	        $("#Match")[0].checked = true;
        
        GetTemplateList(_moduleID);
        
		$("form").submit(ChangeTemplate);
		$("[name=TranslateLang]").change(TranslateLang_OnChange);
		$("[name=TemplatePath]").change(TemplatePath_OnChange);
		$("[name=SkinPath]").change(SkinPath_OnChange);
		$("#Match").click(Match_OnClick);
	}
	else if (_page == "channel_extra_instance")
	{
        _xmlChannel = CreateXmlDom();
        GetChannelList();
        
		$("form").submit(SetExtraInstance);
		$("[name=BindingInstanceID]").click(BindingInstance_OnChange);
	}
	else if (_page == "module_dictionary_list")
	{
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).closest("tr").attr("id");
			ModifyModuleDictionary(this, id);
			return false;
		});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteModuleDictionary(id);}, this);
			return false;
		});			

		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "module_dictionary_add")
	{
		$("form").submit(AddModuleDictionary);
	}
	else if (_page == "link_category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form:first").submit(AddLinkCategory);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "link_category_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form:first").submit(EditLinkCategory);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "link_category_list")
	{
		MakeButton();

		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyLinkCategory(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLinkCategory(id);}, this);
			return false;
		});

		InitMove(null,"Move", null, MoveLinkCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "link_list")
	{
		MakeButton();
		
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			ModifyLink(this, id);
			return false;
		});

		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});

		InitMove(null,"Move", null, MoveLink);
	
		$("#IsChecked,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Delete").click(function(){UpdateLink("Delete")});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "link_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form:first").submit(AddLink);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
	}
	else if (_page == "link_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
				
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		$("form:first").submit(EditLink);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
	}
	else if (_page == "admin_list")
	{
		MakeButton();

		$("#IsRecycled").change(Search);
		$("#RoleID").change(Search);
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "admin_add")
	{
        if (_memberInstanceID > 0)
        {
	        var form = document.forms[0];
	        form.ChangeMember.disabled = false;
	        form.ChangeMember.checked = true;
	        ChangeMember_OnClick();
        }
	
		$("form:first").submit(AddAdmin);
		$("[name=ChangeMember]").click(ChangeMember_OnClick);
	}
	else if (_page == "admin_edit")
	{
		$("form:first").submit(EditAdmin);
		$("[name=ChangeMember]").click(ChangeMember_OnClick);
		
	    //获取关联会员信息
		if (_memberInstanceID > 0)
		{
		    $.ajax(
		    {
			    url : _webPath + "ilghar.aspx?Instance=" + _memberInstanceID + "&Lang=" + _lang + "&Object=Member&Operation=Get&Validate=false&ID=" + _guid,
			    data : "ValidateKey=" + encodeURIComponent(_validatekey),
			    type : "POST",
			    error : function(request)
			    {
				    Alert(_lang_operation_fail);
				    SetStatusMessage();
			    },
			    success : function(data)
			    {
			        if (data == "")
			            return;

                    var xmlDoc = CreateXmlDom();
                    xmlDoc.loadXML(data);
                    
                    var form = document.forms[0];
                    _memberID = parseInt(xmlDoc.selectSingleNode("//" + IlgharCMS.MemberModule.Member.InnerID).text);
                    form.MemberName.value = xmlDoc.selectSingleNode("//" + IlgharCMS.MemberModule.Member.Name).text;
                    form.MemberEmail.value = xmlDoc.selectSingleNode("//" + IlgharCMS.MemberModule.Member.Email).text;
			    }
		    });

		    $("[name=ChangeMember]").attr("disabled", false);
		}
	}
	else if (_page == "config_basic")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
        _uploader.Add("Link", "LinkTextbox", "LinkBrowse");
		
		$("form:first").submit(SetBasicSettings);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#LinkTextbox").change(function(){$("#LinkView").attr("src", this.value)});
	}
	else if (_page == "config_email")
	{
	    CheckAndSelect($("[name=Tool]")[0], _tool);
	
		$("form:first").submit(SetEmailSettings);
	}
	else if (_page == "config_global")
	{
	    CheckAndSelect($("[name=DatabaseProvider]")[0], _databaseProvider);
	
		$("form:first").submit(SetGlobalSettings);
		
		var speedUpEnabled = $("[name=SpeedUpEnabled]");
		speedUpEnabled.click(SpeedUpEnabled_OnClick);
		SpeedUpEnabled_OnClick();
	}
	else if (_page == "config_water_mark")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Image", "ImageTextbox", "ImageBrowse");

	    CheckAndSelect($("[name=Position]")[0], _position);
	
		$("form:first").submit(SetWaterMarkSettings);
		$("#ImageTextbox").change(function(){$("#ImageView").attr("src", this.value)});
	}
	else if (_page == "config_rewrite")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRewrite(id);}, this);
			return false;
		});
		
		$("tbody tr").each(function()
		{
			var id = $(this).attr("id");
			
			var cell = $(this.cells[2]);
			var option = $("[name=InstanceID] [value=" + cell.attr("InstanceID") + "]");
			if (option.length == 0)
			    cell.html("");
			else
			    cell.html(option.text());
		});
	
		$("form:first").submit(AddRewrite);
		
		$("[name=InstanceID]").change(function()
		{
		    var form = this.form;
	        form.ObjectFullName.length = 0;
	        if (form.InstanceID.value == "")
	        {
		        form.ObjectFullName.options.add(new Option("--未指定--"), "");
	        }
	        else
	        {
	            SetStatusMessage(_lang_working);

	            $.ajax(
	            {
		            url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Module.Object&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Module_Object.ModuleID + ":" + $("[name=InstanceID] option:selected").attr("ModuleID")),
		            type : "GET",
		            error : function(request)
		            {
			            Alert(_lang_operation_fail);
			            SetStatusMessage();
			            $(":submit")[0].disabled = false;
		            },
		            success : function(data)
		            {
			            var objectSelect = document.forms[0].ObjectFullName;
			            var xmlDoc = CreateXmlDom();
			            xmlDoc.loadXML(data);
			            BuildTreeOptions(xmlDoc, IlgharCMS.SystemModule.Module_Object.ParentID, IlgharCMS.SystemModule.Module_Object.ID, IlgharCMS.SystemModule.Module_Object.Name, objectSelect);
            			
			            for (var i = 0; i < objectSelect.options.length; i++)
			            {
				            var id = objectSelect.options[i].value;
				            if (id == "")
					            continue;
            				
				            var name = "";
				            var itemNode = null;
				            var nodes = xmlDoc.selectNodes("//" + IlgharCMS.SystemModule.Module_Object.ID);
				            for (var j = 0; j < nodes.length; j++)
				            {
					            var node = nodes[j];
					            if (node.text == id)
					            {
						            itemNode = node.parentNode;
						            break;
					            }
				            }

				            var parentID = itemNode.selectSingleNode(IlgharCMS.SystemModule.Module_Object.ParentID).text;
				            while (parentID != g_empty)
				            {
					            if (name == "")
						            name = itemNode.selectSingleNode(IlgharCMS.SystemModule.Module_Object.Name).text;
					            else
						            name = itemNode.selectSingleNode(IlgharCMS.SystemModule.Module_Object.Name).text + "." + name;
            					
					            nodes = xmlDoc.selectNodes("//" + IlgharCMS.SystemModule.Module_Object.ID);
					            for (var j = 0; j < nodes.length; j++)
					            {
						            var node = nodes[j];
						            if (node.text == parentID)
						            {
							            itemNode = node.parentNode;
							            break;
						            }
					            }
					            parentID = itemNode.selectSingleNode(IlgharCMS.SystemModule.Module_Object.ParentID).text;
				            }
            				
				            if (name == "")
					            name = itemNode.selectSingleNode(IlgharCMS.SystemModule.Module_Object.Name).text;
				            else
					            name = itemNode.selectSingleNode(IlgharCMS.SystemModule.Module_Object.Name).text + "." + name;
            				
				            objectSelect.options[i].name = name;
			            }
		            
			            SetStatusMessage();
		            }
	            });
	        }
		});
	}
	else if (_page == "currency_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCurrency(id);}, this);
			return false;
		});
	}
	else if (_page == "currency_add")
	{
        for (var i = 0; i < _currencies.length; i++)
        {
	        var items = document.forms[0].Candidate.options;
	        for (var j = 0; j < items.length; j++)
	        {
		        if (items[j].value.indexOf(_currencies[i] + "|") == 0)
		        {
			        items.remove(j);
			        break;
		        }
	        }
        }
        
		$("form:first").submit(AddCurrency);

		$("[name=Candidate]").change(function()
		{
		    var form = this.form;
	        if (form.Candidate.selectedIndex == 0)
		        return;

	        var items = form.Candidate.value.split("|");
	        form.Name.value = form.Candidate.options[form.Candidate.selectedIndex].text;
	        form.Ab.value = items[0];
	        form.Symbol.value = items[1];
		});
	}
	else if (_page == "currency_edit")
	{
		$("form:first").submit(EditCurrency);
	}
	else if (_page == "payment_list")
	{
		var list = $("#List");
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeletePayment(id);}, this);
			return false;
		});
	}
	else if (_page == "payment_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form:first").submit(AddPayment);
	}
	else if (_page == "payment_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("select[name=Type] option").each(function()
		{
			if($(this).val() == _type)
			{
				$(this).attr("selected", "selected");
			}
		});
		
		$("form:first").submit(EditPayment);
	}
	else if (_page == "file_manager_list")
	{
		var list = $("#List");

		list.delegate("th a", "click", function()
		{
		    if ($(this).closest("tr").find("td:eq(4)").text() == "d")
		    {
				List($(this).text());
				return false;
		    }
			else
			{
				return true;
			}
		});

		list.delegate("td::nth-child(7) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Rename(name);
			return false;
		});

		list.delegate("td::nth-child(8) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Move(name);
			return false;
		});

		list.delegate("td::nth-child(9) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Copy(name);
			return false;
		});

		list.delegate("td::nth-child(10) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			if (name.substr(name.length - 4) == ".zip")
				UnZip(name);
			else
				Zip(name);
			return false;
		});

		list.delegate("td::nth-child(11) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)Delete(name);}, this);
			return false;
		});
		
		FileManager_CalcSize();

		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add("File", "FileTextbox", "FileBrowse");
	
		$("form:first").submit(Upload);
		$("#Folder").keydown(function(e){if(e.keyCode == 13){List();e.preventDefault();}});
		$("#Open").click(List);
		$("#Up").click(Up);
		$("#CreateFolder").click(CreateFolder);
	}
	else if (_page == "file_manager_select")
	{
		var list = $("#List");

		list.delegate("ul a", "click", function()
		{
		    if ($(this).attr("Path") == null)
		    {
		        Select_List($(this).text());
		    }
		    else
		    {
		        if (_type == "Editor")
		            window.opener.SetUrl($(this).attr("Path"));
	            else if ($.browser.msie)
		            window.dialogArguments.SelectFile(_type, $(this).attr("Path"));
	            else
		            window.opener.SelectFile(_type, $(this).attr("Path"));
	            window.close();
		    }
		    return false;
		});

		list.delegate("th a", "click", function()
		{
		    if ($(this).attr("Path") == null)
		    {
				Select_List($(this).text());
		    }
			else
			{
				if (_type == "Editor")
					window.opener.SetUrl($(this).attr("Path"));
				else if ($.browser.msie)
					window.dialogArguments.SelectFile(_type, $(this).attr("Path"));
				else
					window.opener.SelectFile(_type, $(this).attr("Path"));
				window.close();
			}
			return false;
		});

		list.delegate("td::nth-child(7) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Select_Rename(name);
			return false;
		});

		list.delegate("td::nth-child(8) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Select_Move(name);
			return false;
		});

		list.delegate("td::nth-child(9) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Select_Copy(name);
			return false;
		});

		list.delegate("td::nth-child(10) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			if (name.substr(name.length - 4) == ".zip")
				Select_UnZip(name);
			else
				Select_Zip(name);
			return false;
		});

		list.delegate("td::nth-child(11) a", "click", function()
		{
			var name = $(this).closest("tr").find("th a").text();
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)Select_Delete(name);}, this);
			return false;
		});

	    var referrer = null;
	    if (window.opener != null)
	        referrer = window.opener.location.href;
	    else
	        referrer = window.dialogArguments.location.href;
	    if (referrer.indexOf(document.domain) == -1)
	        window.close();
	    
	    if (_type == "Editor" && referrer.indexOf("/fckeditor/") == -1 || _type != "Editor" && referrer.indexOf("/fckeditor/") != -1)
	        window.close();

        if (_root == "")
	        window.close();
        if (_root.charAt(_root.length - 1) != '/')
	        _root += "/";
		
		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

	    $("html").bind("contextmenu", function(){return false;});
		$("form:first").submit(Select_Upload);
		$("#Folder").keydown(function(e){if(e.keyCode == 13){Select_List();e.preventDefault();}});
		$("#Open").click(Select_List);
		$("#Up").click(Select_Up);
		$("#CreateFolder").click(Select_CreateFolder);
		
		$("#ListByPicture").click(function()
		{
			SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
			Select_List();
		});
	}
	else if (_page == "instance_list")
	{
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyInstance(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteInstance(id);}, this);
			return false;
		});
		
		InitMove(null,"Move", null, MoveInstance);
	}
	else if (_page == "instance_add")
	{
		$("form:first").submit(AddInstance);
	}
	else if (_page == "instance_edit")
	{
        CheckAndSelect(document.forms[0].DatabaseProvider, _dataProvider);

		$("form:first").submit(EditInstance);
	}
	else if (_page == "language_list")
	{
		var list = $("table");

		list.delegate("a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLanguage(id);}, this);
			return false;
		});

		list.delegate("button", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLanguage(id, this);}, this);
			return false;
		});
	}
	else if (_page == "language_add")
	{
		$("form:first").submit(AddLanguage);
		
		$("[name=Candidate]").change(function()
		{
		    var form = this.form;
	        if (this.selectedIndex == 0)
	        {
		        form.Name.disabled = false;
		        form.Ab.disabled = false;
		        form.Direction.disabled = false;
	        }
	        else
	        {
		        form.Name.disabled = true;
		        form.Ab.disabled = true;
		        form.Direction.disabled = true;
        		
		        var items = form.Candidate.value.split("|");
		        form.Name.value = items[1];
		        form.Ab.value = items[2];
		        CheckAndSelect(form.Direction, items[3]);
		        form.FontFamily.value = items[4];
		        form.Eot.value = items[5];
	        }
		});
	}
	else if (_page == "language_edit")
	{
		$("form:first").submit(EditLanguage);
	}
	else if (_page == "log_list")
	{
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateLog("Delete")});
		$("#DeleteAll").click(function(){UpdateLog("DeleteAll")});
	}
	else if (_page == "module_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteModule(id);}, this);
			return false;
		});

		$("#BuildAlias").click(BuildAlias);
	}
	else if (_page == "module_add")
	{
		$("form:first").submit(AddModule);
	}
	else if (_page == "module_edit")
	{
		$("form:first").submit(EditModule);
	}
	else if (_page == "module_object_list")
	{
		CloseAll();
		
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyModuleObject(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteModuleObject(id);}, this);
			return false;
		});

		InitMove(null,"Move", null, MoveModuleObject);
	}
	else if (_page == "module_object_add")
	{
		$("form:first").submit(AddModuleObject);
	}
	else if (_page == "module_object_edit")
	{
		$("form:first").submit(EditModuleObject);
	}
	else if (_page == "module_object_operation_list")
	{	
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("id");
			ModifyOperation(this, id);
			return false;
		});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteOperation(id);}, this);
			return false;
		});
	}
	else if (_page == "module_object_operation_add")
	{
		$("form:first").submit(AddOperation);
	}
	else if (_page == "module_object_operation_edit")
	{
		$("form:first").submit(EditOperation);
	}
	else if (_page == "module_object_property_list")
	{
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyProperty(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteProperty(id);}, this);
			return false;
		});

		InitMove(null,"Move", null, MoveProperty);
	}
	else if (_page == "module_object_property_add")
	{
		$("form:first").submit(AddProperty);
		$("[name=SqlDbType]").change(SqlDbType_OnChange);
		$("[name=MainTableID]").change(MainTableID_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "module_object_property_edit")
	{
	    MainTableID_OnChange();
        CheckAndSelect($("[name=SqlDbType]")[0], _sqlDbType);
        CheckAndSelect($("[name=OleDbType]")[0], _oleDbType);

		$("form:first").submit(EditProperty);
		$("[name=SqlDbType]").change(SqlDbType_OnChange);
		$("[name=MainTableID]").change(MainTableID_OnChange);
	}
	else if (_page == "player_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeletePlayer(id);}, this);
			return false;
		});

	    $("#CreateAllCodeFile").click(CreateAllCodeFile);
	}
	else if (_page == "player_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

		$("form:first").submit(AddPlayer);
	}
	else if (_page == "player_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

		$("form:first").submit(EditPlayer);
	}
	else if (_page == "role_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRole(id);}, this);
			return false;
		});
	}
	else if (_page == "role_add")
	{
		$("form:first").submit(AddRole);
	}
	else if (_page == "role_edit")
	{
		$("form:first").submit(EditRole);
	}
	else if (_page == "privilege")
	{
		var list = $("#List");

		list.delegate("[name=ObjectID]", "click", function(){$(this.parentNode.parentNode.cells[1]).find(":checkbox").attr("checked", this.checked);});

	    $("#Save").click(SavePrivilege);
	    $("#RoleID,#InstanceID,#CurrentLang").change(Search);
	    $("#CheckAll").click(function(){$("[name=OperationID]").attr("checked", true);});
	}
	else if (_page == "skin_list")
	{
		$("#List").delegate("dd:last-child a", "click", function()
		{
			var id = $(this).closest("dl").attr("id");
			var index = $(this).parent().children().index(this);
			if (index == 0)
				window.open(HandleFake404("translate.aspx?Lang=" + _lang + "&Path=" + id, "url"), "", "top=200,left=200,width=500,height=400,menubar=0,toolbar=0,scrollbars=yes");
			else
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSkin(id);}, this);
			return false;
		});
	}
	else if (_page == "skin_add")
	{
	    _xmlLanguage = CreateXmlDom();
	    _xmlSkin = CreateXmlDom();

	    Skin_GetLanguageList();
	
		$("form:first").submit(AddSkin);
		$("[name=TemplatePath]").change(Skin_TemplatePath_OnChange);
		$("[name=SkinPath]").change(Skin_SkinPath_OnChange);
	}
	else if (_page == "skin_edit")
	{
		$("form:first").submit(EditSkin);
	}
	else if (_page == "skin_picture")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

		$("form:first").submit(UploadSkinPicture);
		$("#FileTextbox").change(function(){$("#Picture").attr("src", this.value)});
	}
	else if (_page == "skin_thumbnail")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

		$("form:first").submit(UploadSkinThumbnail);
		$("#FileTextbox").change(function(){$("#Thumbnail").attr("src", this.value)});
	}
	else if (_page == "skin_css_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCss(id);}, this);
			return false;
		});
	}
	else if (_page == "skin_css_add")
	{
		$("form:first").submit(AddCss);
	}
	else if (_page == "skin_css_edit")
	{
		$("form:first").submit(EditCss);
	}
	else if (_page == "skin_image_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFile(id);}, this);
			return false;
		});

	    $("#Folder").change(Folder_OnChange);
	    $("#DeleteFolder").click(function()
	    {
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFolder();}, this);
	    });
	}
	else if (_page == "skin_translate")
	{
	    var i = 0;
	    $("option").each(function()
	    {
	        if (_path.indexOf("/" + this.value + "/") != -1)
	        {
	            $("#SourceLanguage").html(this.text);
	            this.parentNode.remove(i);
	            return;
	        }
	        i++;
	    });
	    
	    $("#Start").click(TranslateSkin);
	}
	else if (_page == "skin_image_add")
	{
		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

		$("form:first").submit(UploadSkinImage);
		$("#FolderName").keydown(function(e){if(e.keyCode == 13){SkinImage_AddFolder();e.preventDefault();}});
		$("#AddFolder").click(SkinImage_AddFolder);
		$("#FileTextbox").change(function(){$("#Thumbnail").attr("src", this.value)});
	}
	else if (_page == "template_list")
	{
		var list = $("#List");

		list.delegate("td:nth-child(8) a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			
			var index = $(this).parent().children().index(this);
			if (index == 0)
				return EncryptTemplate(id);
			else
				return DecryptTemplate(id);
		});

		list.delegate("td:nth-child(9) a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			return ClearTemplateCache(id);
		});

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTemplate(id);}, this);
			return false;
		});
	}
	else if (_page == "template_add")
	{
		$("form:first").submit(AddTemplate);
	}
	else if (_page == "template_edit")
	{
		$("form:first").submit(EditTemplate);
	}
	else if (_page == "template_dictionary_list")
	{
		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("id");
			ModifyTemplateDictionary(this, id);
			return false;
		});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTemplateDictionary(id);}, this);
			return false;
		});

		$("form:first").submit(AddTemplateDictionary);
		$("[name=TargetLanguageAb]").change(TargetLanguageAb_OnChange);
		$("#GetChineseString").click(GetChineseString);
	}
	else if (_page == "template_module_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTemplateModule(id);}, this);
			return false;
		});

		$("form:first").submit(AddTemplateModule);
	}
	else if (_page == "template_page_add")
	{
		$("form:first").submit(AddTemplatePage);
		$("#FolderName").keydown(function(e){if(e.keyCode == 13){TemplatePage_AddFolder();e.preventDefault();}});
		$("#AddFolder").click(TemplatePage_AddFolder);
		$("#DeleteFolder").click(TemplatePage_DeleteFolder);
	}
	else if (_page == "template_page_edit")
	{
		$("form:first").submit(EditTemplatePage);
	}
	else if (_page == "template_page_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTemplatePage(id);}, this);
			return false;
		});
	}
	else if (_page == "template_script_add")
	{
		$("form:first").submit(AddTemplateScript);
	}
	else if (_page == "template_script_edit")
	{
		$("form:first").submit(EditTemplateScript);
	}
	else if (_page == "template_script_list")
	{
		var list = $("#List");

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTemplateScript(id);}, this);
			return false;
		});
	}
	else if (_page == "template_menu_list")
	{
		Search();

		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyTemplateMenu(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteTemplateMenu(id);}, this);
			return false;
		});
		
		$("#Namespace").change(Search);

		InitMove(null,"Move", null, MoveTemplateMenu);
	}
	else if (_page == "template_menu_add")
	{
	    _xmlDoc = CreateXmlDom();
		TemplateMenu_GetPageList("loading");

		$("#Namespace").change(function()
		{
			SetCookie("Namespace", $("#Namespace").val(), 10*360*24*60);
			
			TemplateMenu_GetPageList();
		});
		$("form:first").submit(AddTemplateMenu);
		$("#ObjectID").change(TemplateMenu_ObjectID_OnChange);
		$("#TargetCandidate").change(function(){this.form.Target.value=this.value;});
	}
	else if (_page == "template_menu_edit")
	{
	    _xmlDoc = CreateXmlDom();
	    TemplateMenu_GetPageList("loading");
	
		$("#Namespace").change(TemplateMenu_GetPageList);
		$("form:first").submit(EditTemplateMenu);
		$("#ObjectID").change(TemplateMenu_ObjectID_OnChange);
		$("#TargetCandidate").change(function(){this.form.Target.value=this.value;});
	}
	else if (_page == "utility_data_list")
	{
		var list = $("#List");

		list.delegate("td:nth-child(1) a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			return RestoreDb(id);
		});

		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteDbBackup(id);}, this);
			return false;
		});

		$("form:first").submit(BackupDb);
		$("#CompactDb").click(CompactDb);
		$("#BackupSite").click(BackupSite);
	}
	else if (_page == "utility_other")
	{
		$("#ClearCache").click(ClearCache);
		$("#UpdateTemplateCache").click(UpdateTemplateCache);
		$("#InitSystem").click(InitSystem);
		$("#ReplaceEotRootString").click(ReplaceEotRootString);
	}
	else if (_page == "utility_upgrade")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");

		$("#CheckUpgrade").click(CheckUpgrade);
		$("#UploadUpgrade").click(UploadUpgrade);
		$("#Upgrade").click(Upgrade);
	}
	
}
Init(true);