﻿function BuildHeader()
{
	if (_page == "download_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&PlatformID=" + $("#PlatformID").val() + "&LicenseID=" + $("#LicenseID").val() + "&TypeID=" + $("#TypeID").val() + "&LanguageID=" + $("#LanguageID").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "download_url_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&DownloadID=" + _downloadInnerID + ($("[name=CategoryID]")[0].selectedIndex == 0 ? "" : "&CategoryID=" + $("[name=CategoryID]")[0].val());
	else if (_page == "comment_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "special_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "special_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
		    if (_page == "comment_list")
			    $("#RecordList").html(HandleFake404(data, "text"));
			else
			    $("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "download_list")
			{
		        var action = "";
		        if ($("#IsRecommended")[0].selectedIndex == 2 && ($("#Sort").val() == "5" || $("#Sort").val() == "6"))
			        action = "MoveRecommend";
		        else if ($("#IsHeld")[0].selectedIndex == 2 && ($("#Sort").val() == "7" || $("#Sort").val() == "8"))
			        action = "MoveHold";
		        if (action != "")
			        g_action = action;
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "download_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
    else if (_page == "category_list")
    {
        //显示
        var obj = $("#IsDisplay")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateCategory('Display')\" >" + _lang_display + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";

        //置顶
        var obj = $("#IsHeld")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateCategory('Hold')\" >" + _lang_hold + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateCategory('UnHold')\" >" + _lang_unhold + "</button>";

        //推荐
        var obj = $("#IsRecommended")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateCategory('Recommend')\" >" + _lang_recommend + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    }

	$("#ExtraButton").html(buttons);
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Picture":
			path += "true&Root=" + _pictureRoot;
			break;
		case "Thumbnail":
			path += "true&Root=" + _thumbnailRoot;
			break;
		case "URL":
			path += "false&Root=" + _urlRoot;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx?Lang=" + _lang;
	else if (type == "Platform")
		path = "../platform/select.aspx?Lang=" + _lang;
	else if (type == "Special")
		path = "../special/select.aspx?Lang=" + _lang;

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectFile(type, path)
{
	var form = document.forms[0];
	switch (type)
	{
		case "Picture":
			form.Picture.value = path;
			$("#PictureView").attr("src", path);
			break;
		case "Thumbnail":
			form.Thumbnail.value = path;
			$("#ThumbnailView").attr("src", path);
			break;
		case "URL":
		    if (_page == "download_url_edit")
			    form.URL.value = path;
			else
			    form.UrlTemplate.value = path;
			break;
	}
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' value='" + tag.Name + "' PageGenerate='" + tag.PageGenerate + "' PageTemplate='" + tag.PageTemplate + "'' PageID='" + tag.PageID + "'' PageExtension='" + tag.PageExtension + "' /><label class='" + _lang + "Font' for='" + tag.ID + "'>" + tag.Name + "</label>");	
}

function SelectPlatform(platform, checked)
{
	var platforms = $("[name=Platform]");
	for (var i = 0; i < platforms.length; i++)
	{
		if (platforms[i].id == platform.ID)
		{
			platforms[i].checked = checked;
			return;
		}
	}
	
	var platformContainer = $("#PlatformDiv");
	var br = "";
	if (platforms.length > 0 && platforms.length % 5 == 0) br = "<br />";
	platformContainer.html(platformContainer.html() + br + "<input type='checkbox' checked='checked' name='Platform' id='" + platform.ID + "' value='" + platform.Name + "' PageGenerate='" + platform.PageGenerate + "' PageTemplate='" + platform.PageTemplate + "'' PageID='" + platform.PageID + "'' PageExtension='" + platform.PageExtension + "' /><label class='" + _lang + "Font' for='" + platform.ID + "'>" + platform.Name + "</label>");
}

function SelectSpecial(a)
{
    $("[name=Special]").attr("id", $(a).attr("id")).attr("PageGenerate", $(a).attr("PageGenerate")).attr("PageTemplate", $(a).attr("PageTemplate")).attr("PageID", $(a).attr("PageID")).attr("PageExtension", $(a).attr("PageExtension")).val($(a).text());
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PreparePlatform()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var platforms = $("[name=Platform]");
	
	if (typeof(_platformIndex) != "undefined")
	{
	    _platformIndex = 0;
	}
	else
	{
	    _platformAddIndex = 0;
	    _platformDeleteIndex = 0;
	    _platformAddList.length = 0;
	    _platformDeleteList.length = 0;
    	    	
	    platforms.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _platforms.length; j++)
			    {
				    if (this.id == _platforms[j] || this.id == _platforms[j].ID)
					    break;
			    }
			    if (j >= _platforms.length)
				    _platformAddList[_platformAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _platforms.length; j++)
			    {
				    if (this.id == _platforms[j] || this.id == _platforms[j].ID)
				    {
					    _platformDeleteList[_platformDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_platforms.length = 0;
	platforms.each(function()
	{
		if (!this.checked)
		    return false;

		_platforms[_platforms.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function Style_OnChange()
{
    if ($("#Custom")[0].checked)
    {
        if (this.id == "Custom")
            $("[name=CustomStyle]").show();

        return;
    }
    else
    {
        $("[name=CustomStyle]").hide();
    }

    var result = "";

    if ($("#Bold")[0].checked)
        result = "font-weight:bold";

    if ($("#Italic")[0].checked)
    {
        if (result != "")
            result += ";";

        result += "font-style:italic";
    }

    if ($.trim($("#Color").val()) != "")
    {
        if (result != "")
            result += ";";

        result += "color:" + $("#Color").val();
    }
    
    $("[name=CustomStyle]").val(result);
}

//-------------------------------------------------
//Start : 类别管理
function UpdateCategory(action, id)
{
    if (id == null)
    {
        id = "";
        $("[name=Sel]:checked").each(function () { id += id == "" ? this.value : "|" + this.value; });
        if (id == "")
        {
            Alert(_lang_selection_empty);
            return;
        }

        if (action == "Delete")
            Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateCategory(action, id); }, this);
        else
            UpdateCategory(action, id);
    }
    else
    {
        SetStatusMessage(_lang_working);

        $.ajax(
		{
		    url: _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		    data: {},
		    type: "POST",
		    error: function (request)
		    {
		        Alert(_lang_operation_fail);
		        SetStatusMessage();
		    },
		    success: function (data)
		    {
		        Alert(_lang_operation_success);
		        SetStatusMessage();

		        $("#List").html(HandleFake404(data, "text"));
		        Init();
		    }
		});
    }
}

function AddCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddCategory_SetPageID();
		}
	});
}

function AddCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Category_UploadPicture();
		}
	});
}

function EditCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Category_UploadPicture();
		}
	});
	
	return false;	
}

function Category_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Category&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	if (this.DownloadFolder.value.length > 0 && this.DownloadFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_download_folder_incorrect, function(){this.DownloadFolder.select();}, this);
		return false;
	}
	
	if (!this.DownloadThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_width_incorrect, function(){this.DownloadThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.DownloadThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_height_incorrect, function(){this.DownloadThumbnailHeight.select();}, this);
		return false;
	}	
	
	if (!IsAllowedType(this.DownloadDefaultThumbnail.value, this.DownloadDefaultThumbnailAllowedType.value))
	{
		Alert(_lang_type_must_be + this.ImageAllowedType.value, function(){this.DownloadDefaultThumbnail.select();}, this);
		return false;
	}
	
	var data = "DownloadFolder=" +  encodeURIComponent(this.DownloadFolder.value);
	data += "&DownloadThumbnailFolder=" +  encodeURIComponent(this.DownloadThumbnailFolder.value);
	data += "&DownloadPictureFolder=" +  encodeURIComponent(this.DownloadPictureFolder.value);
	data += "&DownloadThumbnailWidth=" + this.DownloadThumbnailWidth.value;
	data += "&DownloadThumbnailHeight=" + this.DownloadThumbnailHeight.value;
	data += "&EnableComment=" + this.EnableComment.checked;
	data += "&CheckComment=" + this.CheckComment.checked;
	_uploadDownloadDefaultThumbnail = _uploader.NeedUpload("Download");
	if (!_uploadDownloadDefaultThumbnail)
		data += "&DownloadDefaultThumbnail=" + encodeURIComponent(this.DownloadDefaultThumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    SetBasicSettings_UploadDownloadDefaultThumbnail();
		}
	});
	
	return false;	
}

function SetBasicSettings_UploadDownloadDefaultThumbnail()
{
    if (!_uploadDownloadDefaultThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadDownloadDefaultThumbnail"});
    _uploader.Upload("Download", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function CreateAllDownloadThumbnail()
{
    var me = this;
    me.disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=CreateAllThumbnail",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.disabled = false;
		}
	});
	
	return false;
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 下载管理
function AddDownload()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Size.value.match(/^[\d\.]+$/))
	{
		Alert(_lang_size_incorrect, function(){this.Size.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.DownCount.value.match(/^\d+$/))
	{
		Alert(_lang_downcount_incorrect, function(){this.DownCount.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	_urlIndex = 0;
	_urlTable = $("#UrlTable tbody")[0];

	var tag = PrepareTag();
	var platform = PreparePlatform();

	var category = $("[name=CategoryID] option:selected");
	var license = $("[name=LicenseID] option:selected");
	var type = $("[name=TypeID] option:selected");
	var language = $("[name=LanguageID] option:selected");
    var special = $(this.Special);

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("LicenseID", license.val(), 10*360*24*60);	
	SetCookie("TypeID", type.val(), 10*360*24*60);	
	SetCookie("LanguageID", language.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
    data += "&SpecialID=" + (special.attr("id") == g_empty ? "" : special.attr("id"));
    data += "&SpecialName=" + special.attr("value");
    data += "&SpecialPageGenerate=" + special.attr("PageGenerate");
    data += "&SpecialPageTemplate=" + special.attr("PageTemplate");
    data += "&SpecialPageID=" + special.attr("PageID");
    data += "&SpecialPageExtension=" + special.attr("PageExtension");
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&Size=" + encodeURIComponent(this.Size.value);
	data += "&LicenseID=" + this.LicenseID.value;
	data += "&LicenseName=" + license.attr("Name");
	data += "&LicensePageGenerate=" + license.attr("PageGenerate");
	data += "&LicensePageTemplate=" + license.attr("PageTemplate");
	data += "&LicensePageID=" + license.attr("PageID");
	data += "&LicensePageExtension=" + license.attr("PageExtension");
	data += "&TypeID=" + this.TypeID.value;
	data += "&TypeName=" + type.attr("Name");
	data += "&TypePageGenerate=" + type.attr("PageGenerate");
	data += "&TypePageTemplate=" + type.attr("PageTemplate");
	data += "&TypePageID=" + type.attr("PageID");
	data += "&TypePageExtension=" + type.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + type.attr("Name");
	data += "&LanguagePageGenerate=" + type.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + type.attr("PageTemplate");
	data += "&LanguagePageID=" + type.attr("PageID");
	data += "&LanguagePageExtension=" + type.attr("PageExtension");
	data += "&Developer=" + encodeURIComponent(this.Developer.value);
	data += "&Website=" + encodeURIComponent(this.Website.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Demo=" + encodeURIComponent(this.Demo.value);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&DownCount=" + this.DownCount.value;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PlatformNames=" + encodeURIComponent(platform.Names);
	data += "&PlatformPageGenerates=" + encodeURIComponent(platform.PageGenerates);
	data += "&PlatformPageTemplates=" + encodeURIComponent(platform.PageTemplates);
	data += "&PlatformPageIDs=" + encodeURIComponent(platform.PageIDs);
	data += "&PlatformPageExtensions=" + encodeURIComponent(platform.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddDownload_GetInnerID();
		}
	});
	
	return false;	
}

function AddDownload_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddDownload_SetPageID();
		}
	});
}

function AddDownload_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddDownload_AddTag();
		}
	});
}

function AddDownload_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddDownload_AddPlatform();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddDownload_AddTag();
		}
	});
}

function AddDownload_AddPlatform()
{
	if (_platformIndex >= _platforms.length)
	{
		AddDownload_AddUrl();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&PlatformID=" + _platforms[_platformIndex];
	
	_platformIndex++;

    SetStatusMessage(_lang_adding_platform);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Platform&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddDownload_AddPlatform();
		}
	});
}

function AddDownload_AddUrl()
{
	if (_urlIndex >= _urlTable.rows.length)
	{
		Download_UploadPicture();
		return;
	}
	
	var urlCategoryID = _urlTable.rows[_urlIndex].cells[0].childNodes[0].value;
	var name = _urlTable.rows[_urlIndex].cells[1].childNodes[0].value;
	var url = _urlTable.rows[_urlIndex].cells[2].childNodes[0].value;
	
	_urlIndex++;
	if (name == "" || url == "")
	{
		AddDownload_AddUrl();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&CategoryID=" + urlCategoryID;
	data += "&Name=" + encodeURIComponent(name);
	data += "&Url=" + encodeURIComponent(url);
	
    SetStatusMessage(_lang_adding_url);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddDownload_AddUrl();
		}
	});
}

function EditDownload()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Size.value.match(/^[\d\.]+$/))
	{
		Alert(_lang_size_incorrect, function(){this.Size.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.DownCount.value.match(/^\d+$/))
	{
		Alert(_lang_downcount_incorrect, function(){this.DownCount.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	var platform = PreparePlatform();
	
	var category = $("[name=CategoryID] option:selected");
	var license = $("[name=LicenseID] option:selected");
	var type = $("[name=TypeID] option:selected");
	var language = $("[name=LanguageID] option:selected");
    var special = $(this.Special);

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
    data += "&SpecialID=" + (special.attr("id") == g_empty ? "" : special.attr("id"));
    data += "&SpecialName=" + special.attr("value");
    data += "&SpecialPageGenerate=" + special.attr("PageGenerate");
    data += "&SpecialPageTemplate=" + special.attr("PageTemplate");
    data += "&SpecialPageID=" + special.attr("PageID");
    data += "&SpecialPageExtension=" + special.attr("PageExtension");
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&Size=" + encodeURIComponent(this.Size.value);
	data += "&LicenseID=" + this.LicenseID.value;
	data += "&LicenseName=" + license.attr("Name");
	data += "&LicensePageGenerate=" + license.attr("PageGenerate");
	data += "&LicensePageTemplate=" + license.attr("PageTemplate");
	data += "&LicensePageID=" + license.attr("PageID");
	data += "&LicensePageExtension=" + license.attr("PageExtension");
	data += "&TypeID=" + this.TypeID.value;
	data += "&TypeName=" + type.attr("Name");
	data += "&TypePageGenerate=" + type.attr("PageGenerate");
	data += "&TypePageTemplate=" + type.attr("PageTemplate");
	data += "&TypePageID=" + type.attr("PageID");
	data += "&TypePageExtension=" + type.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&Developer=" + encodeURIComponent(this.Developer.value);
	data += "&Website=" + encodeURIComponent(this.Website.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Demo=" + encodeURIComponent(this.Demo.value);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&UpdateTime=" + this.UpdateTime.value;
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&DownCount=" + this.DownCount.value;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PlatformNames=" + encodeURIComponent(platform.Names);
	data += "&PlatformPageGenerates=" + encodeURIComponent(platform.PageGenerates);
	data += "&PlatformPageTemplates=" + encodeURIComponent(platform.PageTemplates);
	data += "&PlatformPageIDs=" + encodeURIComponent(platform.PageIDs);
	data += "&PlatformPageExtensions=" + encodeURIComponent(platform.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_DeleteTag();
		}
	});

	return false;
}

function EditDownload_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditDownload_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Tag&Operation=Delete&DownloadID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_DeleteTag();
		}
	});
}

function EditDownload_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditDownload_DeletePlatform();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_AddTag();
		}
	});
}

function EditDownload_DeletePlatform()
{
	if (_platformDeleteIndex >= _platformDeleteList.length)
	{
		EditDownload_AddPlatform();
		return;
	}

	SetStatusMessage(_lang_modifying_platform);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Platform&Operation=Delete&DownloadID=" + _guid + "&PlatformID=" + _platformDeleteList[_platformDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_DeletePlatform();
		}
	});
}

function EditDownload_AddPlatform()
{
	if (_platformAddIndex >= _platformAddList.length)
	{
        Download_UploadPicture();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&PlatformID=" + _platformAddList[_platformAddIndex];
	
	_platformAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Platform&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_AddPlatform();
		}
	});
}

function Download_UploadPicture()
{
    if (!_uploadPicture)
    {
        Download_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Download&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Download_UploadThumbnail();
    	}
    });
}

function Download_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Download&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveDownload(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateDownload(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateDownload(action, id);}, this);
		else
			UpdateDownload(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function ReplaceDownload()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function AddClientUrl()
{
    var form = $("form")[0];
	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	
	var urlCategory = form.UrlCategoryID.outerHTML.replace("name=UrlCategoryID", "");
	var extention = form.Extention.value == "" ? "" : "." + form.Extention.value;

	var names = new Array();
	var urls = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			names[names.length] = "01";
		else
			names[names.length] = form.UrlName.value;
		
		urls[urls.length] = form.UrlTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (form.To.value.match(/^\d+$/) == null || form.From.value.match(/^\d+$/) == null || form.Wildcard.value.match(/^\d+$/) == null)
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + r;
			else
				names[names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + r + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", r) + extention;
			}			
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){this.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){this.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				names[names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + extention;	
			}			
		}
	}
	
	var table = $("#UrlTable tbody")[0];
	for (var i = 0; i < names.length; i++)
	{
		var row = table.insertRow(-1);
		var cell = null;
		
		cell = row.insertCell(-1);
		cell.innerHTML = urlCategory;
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + names[i] + "' size='20' maxlength='50' class='" + _lang + "Font' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + urls[i] + "' size='40' maxlength='255' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='button' value='" + _lang_delete + "' onclick='DeleteClientUrl(this)' />";
	}
}

function DeleteClientUrl(input)
{
	var table = $("#UrlTable")[0];
	table.deleteRow(input.parentNode.parentNode.rowIndex);
}

function Type_OnChange()
{
    var form = this.form;
	if (this.value == "")
	{
		$("#Batch").hide();
	}
	else
	{
		if (this.value == "0")
		{
			form.From.maxLength = 3;
			form.From.value = "1";
			form.To.maxLength = 3;
			form.To.value = "2";
	
			$("#WildcardSpan").show();
		}
		else if (form.Type.value == "1")
		{
			form.From.maxLength = 1;
			form.From.value = "A";
			form.To.maxLength = 1;
			form.To.value = "B";
	
			$("#WildcardSpan").hide();
		}

		$("#Batch").show();
	}
}

function Property_OnChange()
{
    switch (this.value)
    {
        case "CategoryID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
				
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.DownModule.Category.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.DownModule.Category.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "Title":
        case "Description":
	        $("#FromTd").html("<input type=\"text\" name=\"From\" class=\"Text " + _lang + "Font\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" class=\"Text " + _lang + "Font\" />");
	        break;
        default:
	        $("#FromTd").html("<input type=\"text\" name=\"From\" size=\"40\" class=\"Text\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" size=\"40\" class=\"Text\" />");
	        break;
    }
}
//End : 下载管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地址管理
function PrepareUrl()
{
    var form = $("form")[0];

	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	
	_categoryID = form.CategoryID.value;
	_extention = form.Extention.value == "" ? "" : "." + form.Extention.value;
	_counter = 0;
	
	_names = new Array();
	_urls = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			_names[_names.length] = "01";
		else
			_names[_names.length] = form.UrlName.value;
		
		_urls[_urls.length] = form.UrlTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (!form.To.value.match(/^\d+$/) || !form.From.value.match(/^\d+$/) || !form.Wildcard.value.match(/^\d+$/))
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + r;
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + r + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", r) + _extention;
			}
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){form.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){form.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + _extention;	
			}
		}
	}
}

function AddUrl()
{
    if (_counter >= _names.length)
    {
	    Alert(_lang_operation_success);
	    SetStatusMessage();
    	$(":submit")[0].disabled = false;

	    Search();
        return;
    }
    
	var data = "DownloadID=" + _downloadID;
	data += "&CategoryID=" + _categoryID;
	data += "&Name=" + encodeURIComponent(_names[_counter]);
	data += "&Url=" + encodeURIComponent(_urls[_counter]);
	
	_counter++;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    AddUrl();
		}
	});
}

function ModifyUrl(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&URL=" + encodeURIComponent(form.URL.value);

	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Url&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});

	return false;
}

function DeleteUrl(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Url&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}

function EditUrl()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.DownCount.value.match(/^\d+$/))
	{
		Alert(_lang_downcount_incorrect, function(){this.DownCount.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var data = "CategoryID=" + this.CategoryID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	_upload = _uploader.NeedUpload("URL");
	if (!_upload)
		data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&DownCount=" + this.DownCount.value;
	data += "&Error=" + this.Error.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Download.Url&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
	        Url_Upload();
		}
	});
	
	return false;
}

function Url_Upload()
{
    if (!_upload)
    {
	    Alert(_lang_operation_success);
	    SetStatusMessage();
	    $(":submit")[0].disabled = false;

	    return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Download.Url&Operation=UploadForDownload&ID=" + _id});
    _uploader.Upload("URL", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}
//End : 地址管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 评论管理
function EditComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=DownloadComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdateComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateComment(action, id);}, this);
		else
			UpdateComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=DownloadComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}	
//End : 评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 语言管理
function AddLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddLanguage_GetInnerID();
		}
	});
	
	return false;
}

function AddLanguage_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddLanguage_SetPageID();
		}
	});
}

function AddLanguage_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyLanguage(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteLanguage(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}	
//End : 语言管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 授权管理
function AddLicense()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=License&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddLicense_GetInnerID();
		}
	});
	
	return false;
}

function AddLicense_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=License&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddLicense_SetPageID();
		}
	});
}

function AddLicense_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=License&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditLicense()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=License&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyLicense(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=License&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteLicense(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=License&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}	
//End : 授权管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 平台管理
function AddPlatform()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Platform&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddPlatform_GetInnerID();
		}
	});
	
	return false;
}

function AddPlatform_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Platform&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddPlatform_SetPageID();
		}
	});
}

function AddPlatform_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Platform&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditPlatform()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Platform&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyPlatform(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Platform&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeletePlatform(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Platform&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}	
//End : 平台管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类型管理
function AddType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddType_GetInnerID();
		}
	});
	
	return false;
}

function AddType_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddType_SetPageID();
		}
	});
}

function AddType_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyType(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteType(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}	
//End : 类型管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 标签管理
function AddTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddTag_GetInnerID();
		}
	});
	
	return false;	
}

function AddTag_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddTag_SetPageID();
		}
	});
}

function AddTag_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function ModifyTag(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteTag()
{
	var id = GetChecked("Sel");
	if(id == "")
	{
		Alert(_lang_no_selection);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();			
		}
	});
}	
//End : 标签管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地址类别管理
function AddUrlCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&UrlPrefix=" + encodeURIComponent(this.UrlPrefix.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditUrlCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&UrlPrefix=" + encodeURIComponent(this.UrlPrefix.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function MoveUrlCategory(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyUrlCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});

	return false;
}

function DeleteUrlCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 地址类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 专题管理
function AddSpecial()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;

		    SetStatusMessage(_lang_getting_innerid);
		    AddSpecial_GetInnerID();
		}
	});
	
	return false;	
}

function AddSpecial_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
            
			AddSpecial_SetPageID();
		}
	});
}

function AddSpecial_SetPageID(id, pageID)
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
	        Alert(_lang_operation_success);
	        SetStatusMessage();
	        $(":submit")[0].disabled = false;
		}
	});
}

function EditSpecial()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSpecial(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 专题管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(AddCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(EditCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "category_list")
	{
	    MakeButton();

	    $("tr").each(function ()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyCategory(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCategory(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
	}
	else if (_page == "config_basic")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Download", "DownloadTextbox", "DownloadBrowse");
		
		$("form").eq(0).submit(SetBasicSettings);
		$("#DownloadTextbox").change(function(){$("#DownloadDefaultThumbnailView").attr("src", this.value)});
		$("#CreateAllDownloadThumbnail").click(CreateAllDownloadThumbnail);
	}
	else if (_page == "download_add")
	{
	    var form = $("form")[0];
	    form.UrlName.value = GetCookie("UrlName");
	    form.Extention.value = GetCookie("Extention");
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
	    CheckAndSelect(form.LicenseID, GetCookie("LicenseID"));
	    CheckAndSelect(form.TypeID, GetCookie("TypeID"));
	    CheckAndSelect(form.LanguageID, GetCookie("LanguageID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddDownload);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PlatformSelect").click(function(){ShowSelectDialog("Platform")});
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
		$("#SpecialSelect").click(function(){ShowSelectDialog("Special")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		$("[name=UrlName],[name=Extention],[name=UrlTemplate]").keydown(function(e){if (e.keyCode == 13){AddClientUrl();e.preventDefault();}});
		$("#AddUrl").click(AddClientUrl);
		$("[name=Type]").change(Type_OnChange);
		
		$("#ClearSpecial").click(function()
		{
		    var special = $("[name=Special]");
		    special.val("");
		    special.attr("id", "");
		    special.attr("PageGenerate", "");
		    special.attr("PageTemplate", "");
		    special.attr("PageID", "");
		    special.attr("PageExtension", "");
		});
	}
	else if (_page == "download_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
        
        for (var i = 0; i < _platforms.length; i++)
        {
	        SelectPlatform(_platforms[i], true);
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditDownload);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PlatformSelect").click(function(){ShowSelectDialog("Platform")});
		$("#SpecialSelect").click(function(){ShowSelectDialog("Special")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#ClearSpecial").click(function()
		{
		    var special = $("[name=Special]");
		    special.val("");
		    special.attr("id", "");
		    special.attr("PageGenerate", "");
		    special.attr("PageTemplate", "");
		    special.attr("PageID", "");
		    special.attr("PageExtension", "");
		});
	}
	else if (_page == "download_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});

		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveDownload);

		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#PlatformID,#LicenseID,#TypeID,#LanguageID,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "download_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceDownload);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "download_url_list")
	{
	    $("tr").each(function ()
	    {
	        var id = this.id;

	        $(this).find("form").submit(function () { return ModifyUrl(this, id); });

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUrl(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

	    $("[name=UrlName]").val(GetCookie("UrlName"));
	    $("[name=Extention]").val(GetCookie("Extention"));

		$("form").eq(0).submit(function(){PrepareUrl();AddUrl();return false;});
		$("[name=CategoryID]").change(Search);
		$("[name=Type]").change(Type_OnChange);
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
	}
	else if (_page == "download_url_edit")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("URL", "URLTextbox", "URLBrowse");

		$("form").eq(0).submit(EditUrl);
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
	}
	else if (_page == "comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateComment("Delete");});
	}
	else if (_page == "comment_edit")
	{
		$("form").eq(0).submit(EditComment);
	}
	else if (_page == "language_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyLanguage(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLanguage(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "language_add")
	{
		$("form").eq(0).submit(AddLanguage);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "language_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditLanguage);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "license_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyLicense(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLicense(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "license_add")
	{
		$("form").eq(0).submit(AddLicense);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "license_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditLicense);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "platform_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyPlatform(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeletePlatform(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "platform_add")
	{
		$("form").eq(0).submit(AddPlatform);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "platform_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditPlatform);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "platform_select")
	{
		$("#Ok").click(function(){window.close();});
		
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectPlatform({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectPlatform({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
	}
	else if (_page == "type_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyType(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteType(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "type_add")
	{
		$("form").eq(0).submit(AddType);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "type_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditType);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "tag_list")
	{
		$("form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){return ModifyTag(this, id)});
		});

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){DeleteTag();});
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "tag_add")
	{
		$("form").submit(AddTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "tag_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "url_category_add")
	{
		$("form").eq(0).submit(AddUrlCategory);
	}
	else if (_page == "url_category_edit")
	{
		$("form").eq(0).submit(EditUrlCategory);
	}
	else if (_page == "url_category_list")
	{
		$("tr").each(function()
		{
		    var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){return ModifyUrlCategory(this, id);});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUrlCategory(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveUrlCategory);
	}
	else if (_page == "special_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSpecial(id);}, this);
				return false;
			});
		});		
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "special_add")
	{
		$("form").eq(0).submit(AddSpecial);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "special_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
	
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
	
		$("form").eq(0).submit(EditSpecial);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);		
	}
	else if (_page == "special_select")
	{
		$("td a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectSpecial(this);
			else
				window.opener.SelectSpecial(this);
			window.close();
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
}
Init(true);