﻿function BuildHeader()
{
	if (_page == "tag_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "comment_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "article_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Type=" + $("#Type").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "file_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "file_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "special_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "special_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "article_category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
		    if (_page == "comment_list")
			    $("#RecordList").html(HandleFake404(data, "text"));
			else
			    $("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "article_list")
			{
		        var action = "";
		        if ($("#IsRecommended")[0].selectedIndex == 2 && ($("#Sort").val() == "5" || $("#Sort").val() == "6"))
			        action = "MoveRecommend";
		        else if ($("#IsHeld")[0].selectedIndex == 2 && ($("#Sort").val() == "7" || $("#Sort").val() == "8"))
			        action = "MoveHold";
		        if (action != "")
			        g_action = action;
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "article_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('UnHold')\" >" + _lang_unhold + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}
	else if (_page == "comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
	else if (_page == "article_category_list")
	{
	    //显示
	    var obj = $("#IsDisplay")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticleCategory('Display')\" >" + _lang_display + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticleCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticleCategory('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticleCategory('UnHold')\" >" + _lang_unhold + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticleCategory('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticleCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}
		
	$("#ExtraButton").html(buttons);
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx?Lang=" + _lang;
	else if (type == "File")
		path = "../file/select.aspx?Lang=" + _lang;
	else if (type == "Special")
		path = "../special/select.aspx?Lang=" + _lang;

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Thumbnail":
			path += "true&Root=" + _thumbnailRoot;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function SelectFile(type, path)
{
	var form = document.forms[0];
	switch (type)
	{
		case "Thumbnail":
			form.Thumbnail.value = path;
			$("#ThumbnailView").attr("src", path);
			break;
		case "File":
            $("#FileTextBox").val(path);
			break;
	}	
}

function SelectSpecial(a)
{
    $("[name=Special]").attr("id", $(a).attr("id")).attr("PageGenerate", $(a).attr("PageGenerate")).attr("PageTemplate", $(a).attr("PageTemplate")).attr("PageID", $(a).attr("PageID")).attr("PageExtension", $(a).attr("PageExtension")).val($(a).text());
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 标签管理
function AddTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddTag_GetInnerID();
		}
	});
	
	return false;	
}

function AddTag_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddTag_SetPageID();
		}
	});
}

function AddTag_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function ModifyTag(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteTag()
{
	var id = GetChecked("Sel");
	if(id == "")
	{
		Alert(_lang_no_selection);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();			
		}
	});
}	
//End : 标签管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类别管理
function UpdateArticleCategory(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
		    Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateArticleCategory(action, id); }, this);
		else
			UpdateArticleCategory(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function AddArticleCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddArticleCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddArticleCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddArticleCategory_SetPageID();
		}
	});
}

function AddArticleCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			ArticleCategory_UploadPicture();
		}
	});
}

function EditArticleCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    ArticleCategory_UploadPicture();
		}
	});
	
	return false;	
}

function ArticleCategory_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=ArticleCategory&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function ModifyArticleCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteArticleCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveArticleCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 专题管理
function AddSpecial()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;

		    SetStatusMessage(_lang_getting_innerid);
		    AddSpecial_GetInnerID();
		}
	});
	
	return false;	
}

function AddSpecial_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
            
			AddSpecial_SetPageID();
		}
	});
}

function AddSpecial_SetPageID(id, pageID)
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
	        Alert(_lang_operation_success);
	        SetStatusMessage();
	        $(":submit")[0].disabled = false;
		}
	});
}

function EditSpecial()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSpecial(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Special&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 专题管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	var data = "ArticleThumbnailFolder=" + encodeURIComponent(this.ArticleThumbnailFolder.value);
	data += "&FileFolder=" + encodeURIComponent(this.FileFolder.value);
	data += "&EnableComment=" + this.EnableComment.checked;
	data += "&CheckComment=" + this.CheckComment.checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 评论管理
function EditComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdateComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateComment(action, id);}, this);
		else
			UpdateComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}	

//End : 评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 文件管理
function AddFile()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	var uploadFile = _uploader.NeedUpload("File");
	if (!uploadFile)
		data += "&URL=" + encodeURIComponent(this.URL.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=File&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			if (uploadFile)
			{
				$.ajax(
				{
					url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=File&Operation=GetInnerIDFromGuid&ID=" + data,
					type : "GET",
					error : function(request)
					{
						Alert(_lang_innerid_fail);
						SetStatusMessage();
						$(":submit")[0].disabled = false;
					},
					success : function(data)
					{
					    SetStatusMessage(_lang_start_upload);
					    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=File&Operation=Upload&ID=" + data});
					    _uploader.Upload("File", function()
					    {
                            if (arguments.length == 2)
                                Alert(arguments[1]);
                            else
					            Alert(_lang_operation_success);
				            SetStatusMessage();
				            $(":submit")[0].disabled = false;
					    });
					}
				});
			}
			else
			{
	            Alert(_lang_operation_success);
	            SetStatusMessage();
	            $(":submit")[0].disabled = false;
			}
		}
	});
	
	return false;
}

function EditFile()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	var uploadFile = _uploader.NeedUpload("File");
	if (!uploadFile)
		data += "&URL=" + encodeURIComponent(this.URL.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=File&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			if (uploadFile)
			{
				SetStatusMessage(_lang_start_upload);
				_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=File&Operation=Upload&ID=" + _id});
				_uploader.Upload("File", function()
				{
                    if (arguments.length == 2)
                        Alert(arguments[1]);
                    else
					    Alert(_lang_operation_success);
				    SetStatusMessage();
				    $(":submit")[0].disabled = false;
				});
			}
			else
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
				$(":submit")[0].disabled = false;
			}
		}
	});
	
	return false;	
}

function DeleteFile(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=File&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 文件管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 文章管理
function UpdateArticle(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateArticle(action, id);}, this);
		else
			UpdateArticle(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function MoveArticle(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' value='" + tag.Name + "' PageGenerate='" + tag.PageGenerate + "' PageTemplate='" + tag.PageTemplate + "'' PageID='" + tag.PageID + "'' PageExtension='" + tag.PageExtension + "' /><label class='" + _lang + "Font' for='" + tag.ID + "'>" + tag.Name + "</label>");
}

function Style_OnChange()
{
    if ($("#Custom")[0].checked)
    {
        if (this.id == "Custom")
            $("[name=CustomStyle]").show();

        return;
    }
    else
    {
        $("[name=CustomStyle]").hide();
    }

    var result = "";

    if ($("#Bold")[0].checked)
        result = "font-weight:bold";

    if ($("#Italic")[0].checked)
    {
        if (result != "")
            result += ";";

        result += "font-style:italic";
    }

    if ($.trim($("#Color").val()) != "")
    {
        if (result != "")
            result += ";";

        result += "color:" + $("#Color").val();
    }
    
    $("[name=CustomStyle]").val(result);
}

function AddArticle()
{
	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (this.Introduction.value.length > 250)
	{
		Alert(_lang_introduction_incorrect, function(){this.Description.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();

	var category = $("[name=CategoryID] option:selected");
    var special = $(this.Special);
	
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Title=" + encodeURIComponent(this.Title.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
    data += "&SpecialID=" + (special.attr("id") == g_empty ? "" : special.attr("id"));
    data += "&SpecialName=" + special.attr("value");
    data += "&SpecialPageGenerate=" + special.attr("PageGenerate");
    data += "&SpecialPageTemplate=" + special.attr("PageTemplate");
    data += "&SpecialPageID=" + special.attr("PageID");
    data += "&SpecialPageExtension=" + special.attr("PageExtension");
	data += "&FromLabel=" + encodeURIComponent(this.FromLabel.value);
	data += "&FromLink=" + encodeURIComponent(this.FromLink.value);
	data += "&Type=" + this.Type.value;
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
	if (!_uploadThumbnail)
		data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddArticle_GetInnerID();
		}
	});
	
	return false;	
}

function AddArticle_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddArticle_SetPageID();
		}
	});
}

function AddArticle_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddArticle_AddTag();
		}
	});
}

function AddArticle_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		Article_UploadThumbnail();
		return;
	}
	
	var data = "ArticleID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddArticle_AddTag();
		}
	});
}

function EditArticle()
{
	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	
	var category = $("[name=CategoryID] option:selected");
    var special = $(this.Special);
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	var data = "Title=" + encodeURIComponent(this.Title.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
    data += "&SpecialID=" + (special.attr("id") == g_empty ? "" : special.attr("id"));
    data += "&SpecialName=" + special.attr("value");
    data += "&SpecialPageGenerate=" + special.attr("PageGenerate");
    data += "&SpecialPageTemplate=" + special.attr("PageTemplate");
    data += "&SpecialPageID=" + special.attr("PageID");
    data += "&SpecialPageExtension=" + special.attr("PageExtension");
	data += "&FromLabel=" + encodeURIComponent(this.FromLabel.value);
	data += "&FromLink=" + encodeURIComponent(this.FromLink.value);
	data += "&Type=" + this.Type.value;
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&UpdateTime=" + encodeURIComponent(this.UpdateTime.value);
	_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
	if (!_uploadThumbnail)
		data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditArticle_DeleteTag();
		}
	});
	
	return false;	
}

function EditArticle_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditArticle_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article.Tag&Operation=Delete&ArticleID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditArticle_DeleteTag();
		}
	});
}

function EditArticle_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        Article_UploadThumbnail();
		return;
	}
	
	var data = "ArticleID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditArticle_AddTag();
		}
	});
}

function Article_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Article&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function ReplaceArticle()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Article&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function Property_OnChange()
{
    switch (this.value)
    {
        case "CategoryID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=ArticleCategory&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.ArticleModule.ArticleCategory.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.ArticleModule.ArticleCategory.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "Title":
        case "Introduction":
        case "Content":
	        $("#FromTd").html("<input type=\"text\" name=\"From\" class=\"Text " + _lang + "Font\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" class=\"Text " + _lang + "Font\" />");
	        break;
        default:
	        $("#FromTd").html("<input type=\"text\" name=\"From\" size=\"40\" class=\"Text\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" size=\"40\" class=\"Text\" />");
	        break;
    }
}

function SubTitleButton_OnClick()
{
	var editor = FCKeditorAPI.GetInstance("HtmlEditor") ;

	if (editor.EditMode == FCK_EDITMODE_WYSIWYG)
		editor.InsertHtml("[title]" + $("#SubTitle").val() + "[/title]");
}

function FileButton_OnClick()
{
	var editor = FCKeditorAPI.GetInstance("HtmlEditor") ;

	if (editor.EditMode == FCK_EDITMODE_WYSIWYG)
	{
	    if ($("#PlayerID")[0].selectedIndex > 0)
	    {
	        player = $("#PlayerID").val();
	        if (player != "")
	            player = "=" + player;
    		editor.InsertHtml("[player" + player + "]" + $("#FileTextBox").val() + "[/player]");
	    }
        else
        {
		    editor.InsertHtml($("#FileTextBox").val());
		}
	}
}

//End : 文章管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "tag_list")
	{
		$("form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){return ModifyTag(this, id)});
		});		

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){DeleteTag();});
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "tag_add")
	{
		$("form").submit(AddTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "tag_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "article_category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(AddArticleCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "article_category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(EditArticleCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "article_category_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyArticleCategory(this, id);return false;});
			$(this).find("img").eq(0).mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteArticleCategory(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveArticleCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateComment("Delete");});
	}
	else if (_page == "comment_edit")
	{
		$("form").eq(0).submit(EditComment);
	}
	else if (_page == "config_basic")
	{
		$("form").eq(0).submit(SetBasicSettings);
	}
	else if (_page == "article_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("img").eq(0).mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});

		if (arguments.length == 0)
		    return;

		CheckAndSelect($("#KeywordType")[0], _keywordType);
		InitMove(null, "Move", null, MoveArticle);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#CategoryID,#Type,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "article_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		
		$("form").eq(0).submit(AddArticle);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#FileSelect").click(function(){ShowSelectDialog("File")});
		$("#SpecialSelect").click(function(){ShowSelectDialog("Special")});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#SubTitleButton").click(SubTitleButton_OnClick);
		$("#FileButton").click(FileButton_OnClick);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#ClearSpecial").click(function()
		{
		    var special = $("[name=Special]");
		    special.val("");
		    special.attr("id", "");
		    special.attr("PageGenerate", "");
		    special.attr("PageTemplate", "");
		    special.attr("PageID", "");
		    special.attr("PageExtension", "");
		});
	}
	else if (_page == "article_edit")
	{
		CheckAndSelect($("[name=Type]")[0], _type);
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		
		$("form").eq(0).submit(EditArticle);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#FileSelect").click(function(){ShowSelectDialog("File")});
		$("#SpecialSelect").click(function(){ShowSelectDialog("Special")});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#SubTitleButton").click(SubTitleButton_OnClick);
		$("#FileButton").click(FileButton_OnClick);
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#ClearSpecial").click(function()
		{
		    var special = $("[name=Special]");
		    special.val("");
		    special.attr("id", "");
		    special.attr("PageGenerate", "");
		    special.attr("PageTemplate", "");
		    special.attr("PageID", "");
		    special.attr("PageExtension", "");
		});
	}
	else if (_page == "article_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceArticle);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "file_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFile(id);}, this);
				return false;
			});
		});		
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "file_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");
		
		$("form").eq(0).submit(AddFile);
	}
	else if (_page == "file_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");
		
		$("form").eq(0).submit(EditFile);
	}
	else if (_page == "file_select")
	{
		$("td a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectFile("File", $(this).attr("href"));
			else
				window.opener.SelectFile("File", $(this).attr("href"));
			window.close();
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "special_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSpecial(id);}, this);
				return false;
			});
		});		
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "special_add")
	{
		$("form").eq(0).submit(AddSpecial);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "special_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
	
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
	
		$("form").eq(0).submit(EditSpecial);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);		
	}
	else if (_page == "special_select")
	{
		$("td a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectSpecial(this);
			else
				window.opener.SelectSpecial(this);
			window.close();
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
}
Init(true);