﻿function BuildHeader()
{
	if (_page == "ad_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&PositionID=" + _positionID + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "ad_search")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&PositionID=" + _positionID + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "income_clicks" || _page == "income_cpc")
		return BuildAjaxPath(true) + "?Lang=" + _lang + ($("#StartTime").val() == "" ? "" : "&StartTime=" + $("#StartTime").val()) + ($("#EndTime").val() == "" ? "" : "&EndTime=" + $("#EndTime").val()) + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "income_cpt")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "income_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	if (_page == "position_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsAvailable=" + $("#IsAvailable").val() + "&TypeID=" + $("#TypeID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	if (_page == "type_resource_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&TypeID=" + _typeID + "&Folder=" + $("#Folder").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	if (_page == "income_clicks" || _page == "income_cpc")
	{
	    var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	

	    if ($("#StartTime").val() != "" && !re.test($("#StartTime").val()))
	    {
	        Alert(_lang_start_time_incorrect, function(){$("#StartTime")[0].select();}, this);
		    return;
	    }

	    if ($("#EndTime").val() != "" && !re.test($("#EndTime").val()))
	    {
	        Alert(_lang_end_time_incorrect, function(){$("#EndTime")[0].select();}, this);
		    return;
	    }
	}
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "ad_list" || _page == "ad_search")
	{	
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAd('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAd('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateAd('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAd('Check')\" >" + _lang_check + "</button>";
	}
	else if (_page == "position_list")
	{	
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePosition('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePosition('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdatePosition('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
		
	$("#ExtraButton").html(buttons);
}

function SelectFile(type, path)
{
	var form = document.forms[0];
	switch (type)
	{
		case "Image":
			form.Image.value = path;
			$("#ImageView").attr("src", path);
			break;
		case "SketchMap":
			form.SketchMap.value = path;
			$("#SketchMapView").attr("src", path);
			break;
	}	
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Image":
			path += "true&Root=" + _imageRoot;
			break;
		case "SketchMap":
			path += "true&Root=" + _sketchMapRoot;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function CheckFileName(name)
{
	if (name.match(/^(CON\.)|(AUX\.)|(COM1\.)|(COM2\.)|(COM3\.)|(COM4\.)|(LPT1\.)|(LPT2\.)|(LPT3\.)|(PRN\.)|(NUL\.)/))
		return false;

	if (name.match(/^((CON)|(AUX)|(COM1)|(COM2)|(COM3)|(COM4)|(LPT1)|(LPT2)|(LPT3)|(PRN)|(NUL))$/))
		return false;
		
	if (name.length >= 255)
		return false;
	
	if (name.match(/"|'|\/|\\|:|\|/))
		return false;
	
	if (!name.match(/^[a-z]|[A-Z]|\d/))
		return false;
	
	return true;
}

//-------------------------------------------------
//Start : 广告管理
function AddAd()
{
	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	if (!this.Width.value.match(/^\d+$/))
	{
		Alert(_lang_width_incorrect, function(){this.Width.select();}, this);
		return false;
	}
	
	if (!this.Height.value.match(/^\d+$/))
	{
		Alert(_lang_height_incorrect, function(){this.Height.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Image.value, this.ImageAllowedType.value))
	{
		Alert(_lang_image_type_must_be + this.ImageAllowedType.value, function(){this.Image.select();}, this);
		return false;
	}
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if (this.StartTime.value == "" || !re.test(this.StartTime.value))
	{
		Alert(_lang_start_time_incorrect, function(){this.StartTime.select();}, this);
		return false;
	}
	
	if (this.EndTime.value != "" && !re.test(this.EndTime.value))
	{
		Alert(_lang_end_time_incorrect, function(){this.EndTime.select();}, this);
		return false;
	}
	
	var data = "PositionID=" + _positionID;
	data += "&Title=" + encodeURIComponent(this.Title.value);
	data += "&Width=" + this.Width.value;
	data += "&Height=" + this.Height.value;
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Code=" + encodeURIComponent(this.Code.value);
	data += "&StartTime=" + this.StartTime.value;
	data += "&EndTime=" + this.EndTime.value;
	data += "&Charge=" + $("#ChargeYes")[0].checked;
	_uploadImage = _uploader.NeedUpload("Image");
	if (!_uploadImage)
		data += "&Image=" + encodeURIComponent(this.Image.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Ad&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadImage)
		    {
			    _guid = data;

		        SetStatusMessage(_lang_getting_innerid);
		        AddAd_GetInnerID();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
			    
				//解决添加的时候没有出来图片
				$.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GenerateCacheFile&ID=" + _positionID, {});
		    }
		}
	});
	
	return false;	
}

function AddAd_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Ad&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
            
			Ad_UploadImage();
		}
	});
}

function EditAd()
{
	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	if (!this.Width.value.match(/^\d+$/))
	{
		Alert(_lang_width_incorrect, function(){this.Width.select();}, this);
		return false;
	}
	
	if (!this.Height.value.match(/^\d+$/))
	{
		Alert(_lang_height_incorrect, function(){this.Height.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Image.value, this.ImageAllowedType.value))
	{
		Alert(_lang_image_type_must_be + this.ImageAllowedType.value, function(){this.Image.select();}, this);
		return false;
	}
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if (this.StartTime.value == "" || !re.test(this.StartTime.value))
	{
		Alert(_lang_start_time_incorrect, function(){this.StartTime.select();}, this);
		return false;
	}
	
	if (this.EndTime.value != "" && !re.test(this.EndTime.value))
	{
		Alert(_lang_end_time_incorrect, function(){this.EndTime.select();}, this);
		return false;
	}
	
	var data = "Title=" + encodeURIComponent(this.Title.value);
	data += "&Width=" + this.Width.value;
	data += "&Height=" + this.Height.value;
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Code=" + encodeURIComponent(this.Code.value);
	data += "&StartTime=" + this.StartTime.value;
	data += "&EndTime=" + this.EndTime.value;
	data += "&Charge=" + $("#ChargeYes")[0].checked;
	_uploadImage = _uploader.NeedUpload("Image");
	if (!_uploadImage)
		data += "&Image=" + encodeURIComponent(this.Image.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Ad&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadImage)
		    {
		        Ad_UploadImage();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
			    
				//解决添加的时候没有出来图片
				$.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GenerateCacheFile&ID=" + _positionID, {});
		    }
		}
	});
	
	return false;	
}

function Ad_UploadImage()
{
    SetStatusMessage(_lang_start_upload_image);
    _uploader.Init({Status:_lang_uploading_image,Params:"Lang=" + _lang + "&Object=Ad&Operation=UploadImage&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Image", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
			    
		//解决添加的时候没有出来图片
		$.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GenerateCacheFile&ID=" + _positionID, {});
    });
}

function MoveAd(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Ad&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateAd(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateAd(action, id);}, this);
		else
			UpdateAd(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Ad&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}	
//End : 广告管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function Rebuild()
{
    var me = $(this);
    me.attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=Rebuild",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            me.attr("disabled", false);
		}
	});
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 收入管理
function SettleCpc(id)
{
	var startTime = "";
	var endTime = "";
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if ($("#StartTime").val() != "")
	{
		if (re.test($("#StartTime").val()))
		{
			startTime = "&StartTime=" + $("#StartTime").val();
		}
		else
		{
	        Alert(_lang_start_time_incorrect, function(){$("#StartTime")[0].select();}, this);
			return false;
		}
	}
	
	if ($("#EndTime").val() != "")
	{
		if (re.test($("#EndTime").val()))
		{
			endTime = "&EndTime=" + $("#EndTime").val();
		}
		else
		{
	        Alert(_lang_end_time_incorrect, function(){$("#StartTime")[0].select();}, this);
			return false;
		}
	}
	
    $("#" + id).attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Ad&Operation=SettleCpc&ID=" + id + startTime + endTime,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            $("#" + id).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            $("#" + id).attr("disabled", false);
		}
	});
}

function SettleCpt(id)
{
    $("#" + id).attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Cpt&Operation=SettleCpt&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            $("#" + id).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            $("#" + id).attr("disabled", false);
		}
	});
}

function DeleteIncome(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Income&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            $("#" + id).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 收入管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 广告位管理
function AddPosition()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.TypeID.value == "")
	{
		Alert(_lang_select_type);
		return false;
	}
	
	if (!this.Width.value.match(/^\d+$/))
	{
		Alert(_lang_width_incorrect, function(){this.Width.select();}, this);
		return false;
	}
	
	if (!this.Height.value.match(/^\d+$/))
	{
		Alert(_lang_height_incorrect, function(){this.Height.select();}, this);
		return false;
	}
	
	if (!this.Price.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
		return false;
	}
	
	if (!this.Duration.value.match(/^\d+$/))
	{
		Alert(_lang_duration_incorrect, function(){this.Duration.select();}, this);
		return false;
	}
	
	if (!this.ClickPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_click_price_incorrect, function(){this.ClickPrice.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.SketchMap.value, this.SketchMapAllowedType.value))
	{
		Alert(_lang_sketch_map_type_must_be + this.SketchMapAllowedType.value, function(){this.SketchMap.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Image.value, this.ImageAllowedType.value))
	{
		Alert(_lang_image_type_must_be + this.ImageAllowedType.value, function(){this.Image.select();}, this);
		return false;
	}
	
	var data = "TypeID=" + this.TypeID.value;
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Width=" + this.Width.value;
	data += "&Height=" + this.Height.value;
	data += "&Title=" + encodeURIComponent(this.Title.value);
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Code=" + encodeURIComponent(this.Code.value);
	data += "&Price=" + this.Price.value;
	data += "&Duration=" + this.Duration.value;
	data += "&ClickPrice=" + this.ClickPrice.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&IsAvailable=" + $("#IsAvailableYes")[0].checked;
	_uploadSketchMap = _uploader.NeedUpload("SketchMap");
	if (!_uploadSketchMap)
		data += "&SketchMap=" + encodeURIComponent(this.SketchMap.value);
	_uploadImage = _uploader.NeedUpload("Image");
	if (!_uploadImage)
		data += "&Image=" + encodeURIComponent(this.Image.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;

		    if (_uploadSketchMap || _uploadImage)
		    {
		        SetStatusMessage(_lang_getting_innerid);
		        AddPosition_GetInnerID();
		    }
		    else
		    {
			    Alert(_lang_operation_success + _lang_page_code + HtmlEncode("<ilghar:Ad Guid=\"{" + _guid.toUpperCase() + "}\"></ilghar:Ad>"));
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;

		        //解决添加的时候没有出来图片
		        $.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GenerateCacheFile&ID=" + data, {});
		    }
		}
	});
	
	return false;	
}

function AddPosition_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
            
			Position_UploadSketchMap();
		}
	});
}

function UpdatePosition(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePosition(action, id);}, this);
		else
			UpdatePosition(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function EditPosition(form)
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.TypeID.value == "")
	{
		Alert(_lang_select_type);
		return false;
	}
	
	if (!this.Width.value.match(/^\d+$/))
	{
		Alert(_lang_width_incorrect, function(){this.Width.select();}, this);
		return false;
	}
	
	if (!this.Height.value.match(/^\d+$/))
	{
		Alert(_lang_height_incorrect, function(){this.Height.select();}, this);
		return false;
	}
	
	if (!this.Price.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
		return false;
	}
	
	if (!this.Duration.value.match(/^\d+$/))
	{
		Alert(_lang_duration_incorrect, function(){this.Duration.select();}, this);
		return false;
	}
	
	if (!this.ClickPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_click_price_incorrect, function(){this.ClickPrice.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.SketchMap.value, this.SketchMapAllowedType.value))
	{
		Alert(_lang_sketch_map_type_must_be + this.SketchMapAllowedType.value, function(){this.SketchMap.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Image.value, this.ImageAllowedType.value))
	{
		Alert(_lang_image_type_must_be + this.ImageAllowedType.value, function(){this.Image.select();}, this);
		return false;
	}
	
	var data = "TypeID=" + this.TypeID.value;
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Width=" + this.Width.value;
	data += "&Height=" + this.Height.value;
	data += "&Title=" + encodeURIComponent(this.Title.value);
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Code=" + encodeURIComponent(this.Code.value);
	data += "&Price=" + this.Price.value;
	data += "&Duration=" + this.Duration.value;
	data += "&ClickPrice=" + this.ClickPrice.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&IsAvailable=" + $("#IsAvailableYes")[0].checked;
	_uploadSketchMap = _uploader.NeedUpload("SketchMap");
	if (!_uploadSketchMap)
		data += "&SketchMap=" + encodeURIComponent(this.SketchMap.value);
	_uploadImage = _uploader.NeedUpload("Image");
	if (!_uploadImage)
		data += "&Image=" + encodeURIComponent(this.Image.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadSketchMap || _uploadImage)
		    {
		        Position_UploadSketchMap();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;

		        //解决添加的时候没有出来图片
		        $.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GenerateCacheFile&ID=" + _id, {});
		    }
		}
	});
	
	return false;	
}

function Position_UploadSketchMap()
{
    if (!_uploadSketchMap)
    {
		Position_UploadImage();
        return;
    }

    SetStatusMessage(_lang_start_upload_sketch_map);
    _uploader.Init({Status:_lang_uploading_sketch_map,Params:"Lang=" + _lang + "&Object=Position&Operation=UploadSketchMap&ID=" + _id});
    _uploader.Upload("SketchMap", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Position_UploadImage();
    	}
    });
}

function Position_UploadImage()
{
    if (!_uploadImage)
    {
		if (typeof(_lang_page_code) != "undefined")
		    Alert(_lang_operation_success + _lang_page_code + HtmlEncode("<ilghar:Ad Guid=\"{" + _guid.toUpperCase() + "}\"></ilghar:Ad>"));
		else
		    Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
		

        return;
    }

    SetStatusMessage(_lang_start_upload_image);
    _uploader.Init({Status:_lang_uploading_image,Params:"Lang=" + _lang + "&Object=Position&Operation=UploadImage&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Image", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
        }
        else
        {
		    if (typeof(_lang_page_code) != "undefined")
		        Alert(_lang_operation_success + _lang_page_code + HtmlEncode("<ilghar:Ad Guid=\"{" + _guid.toUpperCase() + "}\"></ilghar:Ad>"));
		    else
		        Alert(_lang_operation_success);
    	}
		SetStatusMessage();
		$(":submit")[0].disabled = false;

		//解决添加的时候没有出来图片
		$.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Position&Operation=GenerateCacheFile&ID=" + _id, {});
    });
}

//End : 广告位管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类型管理
function DeleteType(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
function AddType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Template.value, this.TemplateAllowedType.value))
	{
		Alert(_lang_type_must_be + this.TemplateAllowedType.value, function(){this.Template.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&DataFileName=" + encodeURIComponent(this.DataFileName.value);
	data += "&DataTemplate=" + encodeURIComponent(this.DataTemplate.value);
	data += "&InvokeCode=" + encodeURIComponent(this.InvokeCode.value);
	_uploadTemplate = _uploader.NeedUpload("Template");

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadTemplate)
		    {
			    _guid = data;

		        SetStatusMessage(_lang_getting_innerid);
		        AddType_GetInnerID();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
		    }
		}
	});
	
	return false;	
}

function AddType_GetInnerID()
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
            
			Type_UploadTemplate();
		}
	});
}

function EditType(form)
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Template.value, this.TemplateAllowedType.value))
	{
		Alert(_lang_type_must_be + this.TemplateAllowedType.value, function(){this.Template.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&DataFileName=" + encodeURIComponent(this.DataFileName.value);
	data += "&DataTemplate=" + encodeURIComponent(this.DataTemplate.value);
	data += "&InvokeCode=" + encodeURIComponent(this.InvokeCode.value);
	_uploadTemplate = _uploader.NeedUpload("Template");

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    if (_uploadTemplate)
		    {
		        Type_UploadTemplate();
		    }
		    else
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
		    }
		}
	});
	
	return false;
}

function Type_UploadTemplate()
{
    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Type&Operation=UploadTemplate&ID=" + _id});
    _uploader.Upload("Template", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function AddResource()
{
	if (!_uploader.NeedUpload("File"))
	{
		Alert(_lang_select_file);
		return false;
	}
	
	if (!IsAllowedType(this.File.value, this.AllowedType.value))
	{
		Alert(_lang_type_must_be + this.AllowedType.value, function(){this.File.select();}, this);
		return false;
	}
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_start_upload);
	_uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Type.Resource&Operation=Upload&FolderName=" + encodeURIComponent(this.Folder.value) + "&TypeID=" + _typeID});
	_uploader.Upload("File", function()
	{
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
	});

	return false;
}

function DeleteFolder()
{
    var folder = $("#Folder")[0];
    if (folder.value == "")
    {
        Alert(_lang_cant_delete_root);
        return;
    }

    $("#DeleteFolder").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Resource&Operation=DeleteFolder&FolderName=" + encodeURIComponent($("#Folder").val()) + "&TypeID=" + _typeID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
            $("#DeleteFolder").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            $("#DeleteFolder").attr("disabled", false);
            
			folder.remove(folder.selectedIndex);
			folder.selectedIndex = folder.length - 1;
			Search();
		}
	});
	
	return false;	
}

function DeleteFile(id)
{
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Resource&Operation=DeleteFile&FolderName=" + encodeURIComponent($("#Folder").val()) + "&FileName=" + id + "&TypeID=" + _typeID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
            
			$("#" + id).remove();
		}
	});
	
	return false;	
}

function AddFolder()
{
	var folderName = $("#FolderName").val();
	if (!CheckFileName(folderName))
	{
		Alert(_lang_folder_name_invalid);
		return;
	}
	
	var folder = $("#Folder")[0];
	folderName = folder.value + "/" + folderName;
	var len = folder.value.length;
	for (var i = 0; i < len; i++)
	{
		if (folder.options[i].value == folderName)
		{
		    Alert(_lang_folder_exist);
			return;
		}
	}

	$("#AddFolder").eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Resource&Operation=AddFolder&FolderName=" + encodeURIComponent(folderName) + "&TypeID=" + _typeID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
	        $("#AddFolder").eq(0).attr("disabled", false);
	        
			var folderName = $("#Folder").val() + "/" + $("#FolderName").val();
			$("#FolderName").val("");
			$("#Folder")[0].options.add(new Option(folderName, folderName));
			$("#Folder")[0].selectedIndex = $("#Folder")[0].length - 1;
		}
	});
}
//End : 类型管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "ad_list")
	{
	    MakeButton();
	
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveAd);
	
		$("#IsRecycled,#IsChecked,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "ad_search")
	{
		if (arguments.length == 0)
		    return;

		$("#IsRecycled,#IsChecked,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "ad_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Image", "ImageTextbox", "ImageBrowse");
		
		$("form").eq(0).submit(AddAd);
		$("#ImageSelect").click(function(){ShowSelectFileDialog("Image")});
		$("#ImageTextbox").change(function(){$("#ImageView").attr("src", this.value)});
		$("#Escape").click(function(){this.form.Code.value = escape(this.form.Code.value);});
		$("#UnEscape").click(function(){this.form.Code.value = unescape(this.form.Code.value);});
		$("[name=StartTime]").focus(function(){new DatePicker(this);});
		$("[name=EndTime]").focus(function(){new DatePicker(this);});
	}
	else if (_page == "ad_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Image", "ImageTextbox", "ImageBrowse");
		
		$("form").eq(0).submit(EditAd);
		$("#ImageSelect").click(function(){ShowSelectFileDialog("Image")});
		$("#ImageTextbox").change(function(){$("#ImageView").attr("src", this.value)});
		$("#Escape").click(function(){this.form.Code.value = escape(this.form.Code.value);});
		$("#UnEscape").click(function(){this.form.Code.value = unescape(this.form.Code.value);});
	}
	else if (_page == "config_basic")
	{
		$("#Rebuild").click(Rebuild);
	}
	else if (_page == "income_clicks")
	{
		if (arguments.length == 0)
		    return;

		$("#StartTime").focus(function(){new DatePicker(this);});
		$("#EndTime").focus(function(){new DatePicker(this);});
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "income_cpc")
	{
		if (arguments.length == 0)
		    return;

		$("#StartTime").focus(function(){new DatePicker(this);});
		$("#EndTime").focus(function(){new DatePicker(this);});
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("tbody button").click(function(){var id = this.id;Confirm(_lang_confirm_settle, function(returnValue){if (returnValue)SettleCpc(id);}, this);});
	}
	else if (_page == "income_cpt")
	{
		if (arguments.length == 0)
		    return;

		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("tbody button").click(function(){var id = this.id;Confirm(_lang_confirm_settle, function(returnValue){if (returnValue)SettleCpt(id);}, this);});
	}
	else if (_page == "income_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteIncome(id);}, this);
				return false;
			});
		});		
		
		if (arguments.length == 0)
		    return;

		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	if (_page == "position_list")
	{
	    MakeButton();
	
		if (arguments.length == 0)
		    return;

		$("#IsRecycled,#IsAvailable,#TypeID,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "position_add")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("SketchMap", "SketchMapTextbox", "SketchMapBrowse");
		_uploader.Add("Image", "ImageTextbox", "ImageBrowse");
		
		$("form").eq(0).submit(AddPosition);
		$("#SketchMapSelect").click(function(){ShowSelectFileDialog("SketchMap")});
		$("#SketchMapTextbox").change(function(){$("#SketchMapView").attr("src", this.value)});
		$("#ImageSelect").click(function(){ShowSelectFileDialog("Image")});
		$("#ImageTextbox").change(function(){$("#ImageView").attr("src", this.value)});
		$("#Escape").click(function(){this.form.Code.value = escape(this.form.Code.value);});
		$("#UnEscape").click(function(){this.form.Code.value = unescape(this.form.Code.value);});
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "position_edit")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("SketchMap", "SketchMapTextbox", "SketchMapBrowse");
		_uploader.Add("Image", "ImageTextbox", "ImageBrowse");
		
		$("form").eq(0).submit(EditPosition);
		$("#SketchMapSelect").click(function(){ShowSelectFileDialog("SketchMap")});
		$("#SketchMapTextbox").change(function(){$("#SketchMapView").attr("src", this.value)});
		$("#ImageSelect").click(function(){ShowSelectFileDialog("Image")});
		$("#ImageTextbox").change(function(){$("#ImageView").attr("src", this.value)});
		$("#Escape").click(function(){this.form.Code.value = escape(this.form.Code.value);});
		$("#UnEscape").click(function(){this.form.Code.value = unescape(this.form.Code.value);});
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	if (_page == "type_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteType(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "type_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Template", "TemplateTextbox", "TemplateBrowse");
		
		$("form").eq(0).submit(AddType);
	}
	else if (_page == "type_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Template", "TemplateTextbox", "TemplateBrowse");
		
		$("form").eq(0).submit(EditType);
	}
	if (_page == "type_resource_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFile(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

	    if ($("[name=Folder]")[0].selectedIndex > 0)
	        $("#DeleteFolder").attr("disabled", false);
	    else
	        $("#DeleteFolder").attr("disabled", true);
	
	    $("#Folder").change(Search);
	    $("#DeleteFolder").click(function(){Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFolder();}, this);});
	}
	else if (_page == "type_resource_add")
	{
		_uploader.Init({WebPath:_webPath,NameBySystem:false,Overwrite:false});
		_uploader.Add("File", "FileTextbox", "FileBrowse");
		
		$("form").eq(0).submit(AddResource);
		$("#FolderName").keydown(function(e){if(e.keyCode == 13){AddFolder();e.preventDefault();}});
		$("#AddFolder").click(AddFolder);
	}
}
Init(true);