﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Link.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Link.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Link.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Link.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Link.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Name":
				condition.Append(and + Alias.Link.Name + " LIKE '%" + keyword + "%'");
				break;
			case "URL":
				condition.Append(and + Alias.Link.URL + " LIKE '%" + keyword + "%'");
				break;
			case "Email":
				condition.Append(and + Alias.Link.Email + " LIKE '%" + keyword + "%'");
				break;
			case "QQ":
				condition.Append(and + Alias.Link.QQ + " LIKE '%" + keyword + "%'");
				break;
			case "Phone":
				condition.Append(and + Alias.Link.Phone + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Link.Sort + " ASC";
			break;
		case "2":
			sort = Alias.Link.InnerID + " DESC";
			break;
		case "3":
			sort = Alias.Link.InnerID + " ASC";
			break;
		default:
			sort = Alias.Link.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th width="30">移动</th>
			<th width="90">LOGO</th>
			<th>名称</th>
			<th>网址</th>
			<th width="80">QQ</th>
			<th width="40">修改</th>
			<th width="40">编辑</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Link" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="">
					<form action="<%=InnerID%>">
						<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
						<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
						<td>
							<%If Convert.ToString(Logo) != String.Empty%>
								<a href="<%=URL%>" target="_blank"><img src="<%=Logo%>" /></a>
							<%EndIf%>
						</td>
						<td><input type="text" name="Name" value="<%=Name%>" size="30" class="Text <%=ContentLang%>Font" /></td>
						<td><input type="text" name="URL" value="<%=URL%>" size="40" class="Text" /></td>
						<td><input type="text" name="QQ" value="<%=QQ%>" size="10" class="Text" /></td>
						<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
						<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a></td>
					</form>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
