﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Admin.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Admin.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 角色
	if (!String.IsNullOrEmpty(Request.QueryString["RoleID"]))
		condition.Append(and + Alias.Admin.RoleID + "=" + Request.QueryString["RoleID"]);
	#endregion
	
	return condition.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>名称</th>
			<th>Email</th>
			<th>真实姓名</th>
			<th>QQ</th>
			<th>MSN</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Admin" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td>
						<%If User["ID"] != Convert.ToString(ID)%>
							<input type="checkbox" name="Sel" value="<%=InnerID%>" />
						<%EndIf%>
					</td>
					<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<td><%=Email%></td>
					<td><%=RealName%></td>
					<td><%=QQ%></td>
					<td><%=MSN%></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
