﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	condition.Append(Alias.Goods.IsDeleted + "=false");
	condition.Append(" AND " + Alias.Goods.IsReleased + "=true");
	condition.Append(" AND " + Alias.Goods.OnlyAsPart + "=false");

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
		condition.Append(" AND " + Alias.Goods.CategoryID + "=" + Convert.ToInt32(categoryID));
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(" AND " + Alias.Goods.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Goods.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>名称</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Goods" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()">
			<ilghar:Record>
				<%If Convert.ToBoolean(HasSpec)%>
					<ilghar:List Object="Goods.Spec" Condition="GoodsID=ID">
						<ilghar:Record>
							<tr>
								<td>
									<a href="" goodsID="<%=List[ID]%>" goodsSpecID="<%=ID%>" number="<%=Number%>" name="<%=List[Name]%> - <%=Name%>" kind="<%=List[Kind]%>" weight="<%=List[Weight]%>" price="<%=Price%>"><%=List[Name]%> - <%=Name%></a>
								</td>
							</tr>
						</ilghar:Record>										
					</ilghar:List>
				<%Else%>
					<tr>
						<td>
							<a href="" goodsID="<%=ID%>" goodsSpecID="" number="<%=Number%>" name="<%=Name%>" kind="<%=Kind%>" weight="<%=Weight%>" price="<%=SalePrice%>"><%=Name%></a>
						</td>
					</tr>
				<%EndIf%>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>