﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>选择配件</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	condition.Append(Alias.Goods.IsDeleted + "=false");
	condition.Append(" AND " + Alias.Goods.IsReleased + "=true");

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
		condition.Append(" AND " + Alias.Goods.CategoryID + "=" + Convert.ToInt32(categoryID));
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(" AND " + Alias.Goods.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Goods.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "goods_select_part";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _single = "<%=Request.QueryString["Single"]%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择配件</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
		</select>
		<select id="CategoryID" class="<%=ContentLang%>Font">
			<option>所有类别</option>
			<option value="0">未指定类别</option>
			<ilghar:Tree Object="GoodsCategory">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Name">商品名称</option>
		</select>
		<input id="Search" type="button" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>名称</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Goods" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()">
					<ilghar:Record>
						<%If Convert.ToBoolean(HasSpec)%>
							<ilghar:List Object="Goods.Spec" Condition="GoodsID=ID">
								<ilghar:Record>
									<tr>
										<td>
											<%If Request.QueryString["Single"] == null%>
												<input type="checkbox" id="<%=InnerID%>" SourceID="<%=List[ID]%>" SourceSpecID="<%=ID%>" Number="<%=Number%>" Name="<%=List[Name]%> - <%=Name%>" Price="<%=Price%>" /><label for="<%=InnerID%>"><%=List[Name]%> - <%=Name%></label>
											<%Else%>
												<a href="" SourceID="<%=List[ID]%>" SourceSpecID="<%=ID%>" Number="<%=Number%>" Name="<%=List[Name]%> - <%=Name%>" Price="<%=Price%>"><%=List[Name]%> - <%=Name%></a>
											<%EndIf%>
										</td>
									</tr>
								</ilghar:Record>										
							</ilghar:List>
						<%Else%>
							<tr>
								<td>
									<%If Request.QueryString["Single"] == null%>
										<input type="checkbox" id="<%=InnerID%>" SourceID="<%=ID%>" SourceSpecID="" Number="<%=Number%>" Name="<%=Name%>" Price="<%=SalePrice%>" /><label for="<%=InnerID%>"><%=Name%></label>
									<%Else%>
										<a href="" SourceID="<%=ID%>" SourceSpecID="" Number="<%=Number%>" Name="<%=Name%>" Price="<%=SalePrice%>"><%=Name%></a>
									<%EndIf%>
								</td>
							</tr>
						<%EndIf%>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>shop.js"></script>
</body>
</html>