﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Import Namespace="System.Text.RegularExpressions" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Lyric.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Lyric.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Lyric.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Lyric.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Lyric.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Lyric.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Name":
				condition.Append(and + Alias.Lyric.Name + " LIKE '%" + keyword + "%'");
				break;
			case "Content":
				condition.Append(and + Alias.Lyric.Content + " LIKE '%" + keyword + "%'");
				break;
			case "MusicName":
				condition.Append(and + Alias.Lyric.MusicName + " LIKE '%" + keyword + "%'");
				break;
			case "MusicID":
				if (Regex.IsMatch(keyword, @"^\{?[a-fA-F0-9]{8}(-?[a-fA-F0-9]{4}){3}-?[a-fA-F0-9]{12}\}?$"))
					condition.Append(and + Alias.Lyric.MusicID + "=" + keyword);
				else
					condition.Append(and + Alias.Lyric.MusicInnerID + "=" + keyword);
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Lyric.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Lyric.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Lyric.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Lyric.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Lyric.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Lyric.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Lyric.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Lyric.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Lyric.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Lyric.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Lyric.Up + " DESC";
			break;
		case "12":
			sort = Alias.Lyric.Up + " ASC";
			break;
		case "13":
			sort = Alias.Lyric.Down + " DESC";
			break;
		case "14":
			sort = Alias.Lyric.Down + " ASC";
			break;
		case "15":
			sort = Alias.Lyric.Error + " DESC";
			break;
		case "16":
			sort = Alias.Lyric.Error + " ASC";
			break;
		default:
			sort = Alias.Lyric.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected bool Move
{
	get
	{
		if (Request.QueryString["Sort"] == "5" || Request.QueryString["Sort"] == "6")
			return Request.QueryString["IsRecommended"] == "true";
		else if (Request.QueryString["Sort"] == "7" || Request.QueryString["Sort"] == "8")
			return Request.QueryString["IsHeld"] == "true";
		else
			return false;
	}
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<%If Move%>
				<th width="60">
					<%If Request.QueryString["IsRecommended"] == "true"%>
						移动推荐
					<%Else%>
						移动置顶
					<%EndIf%>
				</th>
			<%EndIf%>
			<th>名称</th>
			<th width="110">更新日期</th>
			<th width="40">人气</th>
			<th width="40">顶</th>
			<th width="40">踩</th>
			<th width="40">错误</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Lyric" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<%If Move%>
							<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
					<%EndIf%>
					<td class="<%=ContentLang%>Font"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<td><%=UpdateTime%></td>
					<td><%=HitCount%></td>
					<td><%=Up%></td>
					<td><%=Down%></td>
					<td><%=Error%></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>