﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Member.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Member.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Member.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Member.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否锁定
	string isLocked = Request.QueryString["IsLocked"];
	if (!String.IsNullOrEmpty(isLocked))
		condition.Append(and + Alias.Member.IsLocked + "=" + isLocked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 角色
	string roleID = Request.QueryString["RoleID"];
	if (!String.IsNullOrEmpty(roleID))
		condition.Append(and + Alias.Member.RoleID + "=" + Request.QueryString["RoleID"]);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Member.Name + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Member.RealName + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Member.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.Member.CreateTime + " ASC";
			break;
		default:
			sort = Alias.Member.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>会员名</th>
			<th>真实姓名</th>
			<th>注册日期</th>
			<th>最后登录</th>
			<th>登陆次数</th>
			<th>添加下属</th>
			<th width="50">资金</th>
			<th width="50">积分</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Member" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<%If Manager.HasUyghurText(Name)%>
						<td class="UYGFont"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<%Else%>
						<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<%EndIf%>
					<%If Manager.HasUyghurText(RealName)%>
						<td class="UYGFont"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=RealName%></a></td>
					<%Else%>
						<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=RealName%></a></td>
					<%EndIf%>
					<td><%=CreateTime%></td>
					<td><%=LastLoginTime%></td>
					<td><%=LoginTimes%></td>
					<td><a href="add.aspx?CreatorID=<%=ID%>&amp;Creator=<%=Name%>">添加下属</a></td>
					<td><a href="money/list.aspx?Lang=<%=ContentLang%>&amp;MemberID=<%=InnerID%>">资金</a></td>
					<td><a href="point/list.aspx?Lang=<%=ContentLang%>&amp;MemberID=<%=InnerID%>">积分</a></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>		
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
