﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>入站管理</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 开始日期
	string startTime = Request.QueryString["StartTime"];
	if (!String.IsNullOrEmpty(startTime))
		condition.Append(and + Alias.In.CreateTime + " >= #" + startTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 结束日期
	string endTime = Request.QueryString["EndTime"];
	if (!String.IsNullOrEmpty(endTime))
		condition.Append(and + Alias.In.CreateTime + " <= #" + endTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "LinkName")
			condition.Append(and + Alias.In.LinkName + " LIKE '%" + keyword + "%'");
		if (Request.QueryString["KeywordType"] == "LinkInnerID")
			condition.Append(and + Alias.In.LinkInnerID + "=" + keyword);
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.In.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.In.CreateTime + " ASC";
			break;
		default:
			sort = Alias.In.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "in_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_no_selection = "没有选择任何对象！";
var _lang_start_time_incorrect = "开始日期不正确！";
var _lang_end_time_incorrect = "结束日期不正确！";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">入站管理</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">入站管理</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">日期↓</option>
			<option value="2">日期↑</option>
		</select>
		<input id="Keyword" value="<%=Request.QueryString["Keyword"]%>" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="LinkName">网址名称</option>
			<option value="LinkInnerID">网址编号</option>
		</select>
		<input id="Search" type="button" value="搜索" class="Button" />
		从：<input type="text" size="12" id="StartTime" class="Wdate" />
		到：<input type="text" size="12" id="EndTime" class="Wdate" />
		<input id="SelectAll" type="button" value="全选" class="Button" />
		<input id="ReverseSelect" type="button" value="反选" class="Button" />
		<input id="Delete" type="button" value="删除" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th>名称</th>
					<th>时间</th>
					<th>IP地址</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="In" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr>
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td class="<%=ContentLang%>Font"><a href="../link/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=LinkInnerID%>"><%=LinkName%></a></td>
							<td><%=CreateTime%></td>
							<td><%=IP%></td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=CommonPath%>date_picker/date_picker.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>link.js"></script>
</body>
</html>