﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="WebServer" Object="Server" InnerID="Request.QueryString['ServerID']" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>应用程序池</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<style type="text/css">
#List TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.AppPool.ServerID + "=" + WebServer[Alias.Server.ID]);

	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(Alias.AppPool.Name + " LIKE '%" + keyword + "%'");
	}
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.AppPool.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.AppPool.InnerID + " ASC";
			break;
		default:
			sort = Alias.AppPool.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = 1;
var _action = null;
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		var list = document.getElementById("List");
		list.innerHTML = HandleFake404(xmlHttp);

		if (_action == "Add")
			alert("添加成功！");
		else if (_action == "Delete")
			alert("删除成功！");
	}
	else
	{
		if (_action == "Add")
			alert("添加失败！请查看日志！");
		else if (_action == "Delete")
			alert("删除失败！请查看日志！");
		else
			alert("失败！请查看日志！");
	}
	
	_action = null;
	document.getElementById("Submit").disabled = false;
}

function BuildHeader()
{
	return BuildAjaxPath(true) + "?Lang=<%=ContentLang%>&ServerID=<%=Request.QueryString["ServerID"]%>&Sort=" + document.getElementById("Sort").value + "&Keyword=" + encodeURIComponent(document.getElementById("Keyword").value) + "&KeywordType=" + document.getElementById("KeywordType").value + "&Page=" + _page;
}

function OnSearch()
{
	if (arguments.length > 0)
		_page = arguments[0];

	_action = "Search";
	_ajax.Post(BuildHeader(), null, XmlHttpCallBack);
	return false;
}

function Update(action)
{
	if (_action != null)
	{
		alert("请稍等，目前有一项正在操作！");
		return;
	}
	
	var id = GetChecked("Sel");
	if(id == "")
	{
		alert("没有选择任何对象！");
		return;
	}

	if(action == "Delete" && !confirm("真的要删除吗？"))
		return;
	
	_action = action;
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=AppPool&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()), null, XmlHttpCallBack);
}

function OnAdd(form)
{
	if (form.Name.value == "")
	{
		alert("名称不能空！");
		form.Name.select();
		return false;
	}
	
	if (form.PeriodicRestartTimeEnabled.checked && !form.PeriodicRestartTime.value.match(/^\d+$/))
	{
		alert("回收工作进程（分钟）的格式不正确！");
		form.PeriodicRestartTime.select();
		return false;
	}
	
	if (form.PeriodicRestartRequestsEnabled.checked && !form.PeriodicRestartRequests.value.match(/^\d+$/))
	{
		alert("回收工作进程（请求数目）的格式不正确！");
		form.PeriodicRestartRequests.select();
		return false;
	}
	
	if (form.PeriodicRestartMemoryEnabled.checked && !form.PeriodicRestartMemory.value.match(/^\d+$/))
	{
		alert("最大虚拟内存的格式不正确！");
		form.PeriodicRestartMemory.select();
		return false;
	}
	
	if (form.PeriodicRestartPrivateMemoryEnabled.checked && !form.PeriodicRestartPrivateMemory.value.match(/^\d+$/))
	{
		alert("最大使用的内存的格式不正确！");
		form.PeriodicRestartPrivateMemory.select();
		return false;
	}
	
	if (form.IdleTimeoutEnabled.checked && !form.IdleTimeout.value.match(/^\d+$/))
	{
		alert("空闲时间格式不正确！");
		form.IdleTimeout.select();
		return false;
	}
	
	if (!form.AppPoolQueueLength.value.match(/^\d+$/))
	{
		alert("核心请求队列限制格式不正确！");
		form.AppPoolQueueLength.select();
		return false;
	}
	
	if (form.CPUEnabledYes.checked)
	{
		if (!form.CPULimit.value.match(/^\d+$/))
		{
			alert("最大CPU使用率格式不正确！");
			form.CPULimit.select();
			return false;
		}
		
		if (!form.CPUResetInterval.value.match(/^\d+$/))
		{
			alert("刷新CPU使用率值格式不正确！");
			form.CPUResetInterval.select();
			return false;
		}
	}
	
	if (form.PingingEnabledYes.checked && !form.PingInterval.value.match(/^\d+$/))
	{
		alert("Ping间隔时间格式不正确！");
		form.PingInterval.select();
		return false;
	}
	
	if (form.RapidFailProtectionYes.checked)
	{
		if (!form.RapidFailProtectionMaxCrashes.value.match(/^\d+$/))
		{
			alert("失败数格式不正确！");
			form.RapidFailProtectionMaxCrashes.select();
			return false;
		}
		
		if (!form.RapidFailProtectionInterval.value.match(/^\d+$/))
		{
			alert("时间段格式不正确！");
			form.RapidFailProtectionInterval.select();
			return false;
		}
	}
	
	if (!form.StartupTimeLimit.value.match(/^\d+$/))
	{
		alert("启动时间限制格式不正确！");
		form.StartupTimeLimit.select();
		return false;
	}
	
	if (!form.ShutdownTimeLimit.value.match(/^\d+$/))
	{
		alert("关闭时间限制格式不正确！");
		form.ShutdownTimeLimit.select();
		return false;
	}
	
	if (form.AppPoolIdentityType.value == "3")
	{
		if (form.WAMUserName.value == "")
		{
			alert("请输入用户名！");
			form.WAMUserName.select();
			return false;
		}

		if (form.WAMUserPass.value == "")
		{
			alert("请输入密码！");
			form.WAMUserPass.select();
			return false;
		}
	}
	
	if (!form.MaxHostCount.value.match(/^\d+$/))
	{
		alert("最大网站数格式不正确！");
		form.MaxHostCount.select();
		return false;
	}
	
	var data = "ServerID=<%=WebServer[ID]%>&Name=" + encodeURIComponent(form.Name.value);
	if (form.PeriodicRestartTimeEnabled.checked)
		data += "&PeriodicRestartTime=" + form.PeriodicRestartTime.value;
	else
		data += "&PeriodicRestartTime=0";
	if (form.PeriodicRestartRequestsEnabled.checked)
		data += "&PeriodicRestartRequests=" + form.PeriodicRestartRequests.value;
	else
		data += "&PeriodicRestartRequests=0";
	if (form.PeriodicRestartMemoryEnabled.checked)
		data += "&PeriodicRestartMemory=" + form.PeriodicRestartMemory.value;
	else
		data += "&PeriodicRestartMemory=0";
	if (form.PeriodicRestartPrivateMemoryEnabled.checked)
		data += "&PeriodicRestartPrivateMemory=" + form.PeriodicRestartPrivateMemory.value;
	else
		data += "&PeriodicRestartPrivateMemory=0";
	if (form.IdleTimeoutEnabled.checked)
		data += "&IdleTimeout=" + form.IdleTimeout.value;
	else
		data += "&IdleTimeout=0";
	data += "&AppPoolQueueLength=" + form.AppPoolQueueLength.value;
	if (form.CPUEnabledYes.checked)
	{
		data += "&CPULimit=" + form.CPULimit.value;
		data += "&CPUResetInterval=" + form.CPUResetInterval.value;
		data += "&CPUAction=" + form.CPUAction.value;
	}
	else
	{
		data += "&CPUResetInterval=0";
	}
	data += "&PingingEnabled=" + form.PingingEnabledYes.checked;
	if (form.PingingEnabledYes.checked)
		data += "&PingInterval=" + form.PingInterval.value;
	data += "&RapidFailProtection=" + form.RapidFailProtectionYes.checked;
	if (form.RapidFailProtectionYes.checked)
	{
		data += "&RapidFailProtectionMaxCrashes=" + form.RapidFailProtectionMaxCrashes.value;
		data += "&RapidFailProtectionInterval=" + form.RapidFailProtectionInterval.value;
	}
	data += "&StartupTimeLimit=" + form.StartupTimeLimit.value;
	data += "&ShutdownTimeLimit=" + form.ShutdownTimeLimit.value;
	data += "&AppPoolIdentityType=" + form.AppPoolIdentityType.value;
	if (form.AppPoolIdentityType.value == "3")
	{
		data += "&WAMUserName=" + form.WAMUserName.value;
		data += "&WAMUserPass=" + form.WAMUserPass.value;
	}
	data += "&MaxHostCount=" + form.MaxHostCount.value;
	data += "&IsClosed=" + form.IsClosedYes.checked;
	
	document.getElementById("Submit").disabled = true;
	_action = "Add";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=AppPool&Operation=Add&Transfer=" + encodeURIComponent(BuildHeader()), data, XmlHttpCallBack);
	return false;
}

function ChangeClass(checkbox, textInput)
{
	if (checkbox.checked)
	{
		textInput.className = "Text";
		textInput.disabled = false;
	}
	else
	{
		textInput.className = "Disabled";
		textInput.disabled = true;
	}
}

function CPUEnabled_OnClick()
{
	var form = document.forms[0];
	if (form.CPUEnabledYes.checked)
	{
		form.CPULimit.className = "Text";
		form.CPULimit.disabled = false;
		
		form.CPUResetInterval.className = "Text";
		form.CPUResetInterval.disabled = false;
	}
	else
	{
		form.CPULimit.className = "Disabled";
		form.CPULimit.disabled = true;
		
		form.CPUResetInterval.className = "Disabled";
		form.CPUResetInterval.disabled = true;
	}
}

function PingingEnabled_OnClick()
{
	var form = document.forms[0];
	if (form.PingingEnabledYes.checked)
	{
		form.PingInterval.className = "Text";
		form.PingInterval.disabled = false;
	}
	else
	{
		form.PingInterval.className = "Disabled";
		form.PingInterval.disabled = true;
	}
}

function RapidFailProtection_OnClick()
{
	var form = document.forms[0];
	if (form.RapidFailProtectionYes.checked)
	{
		form.RapidFailProtectionMaxCrashes.className = "Text";
		form.RapidFailProtectionMaxCrashes.disabled = false;
		
		form.RapidFailProtectionInterval.className = "Text";
		form.RapidFailProtectionInterval.disabled = false;
	}
	else
	{
		form.RapidFailProtectionMaxCrashes.className = "Disabled";
		form.RapidFailProtectionMaxCrashes.disabled = true;
		
		form.RapidFailProtectionInterval.className = "Disabled";
		form.RapidFailProtectionInterval.disabled = true;
	}
}

function AppPoolIdentityType_OnChange()
{
	var form = document.forms[0];
	if (form.AppPoolIdentityType.value == 3)
		document.getElementById("AppPoolIdentityType3").style.display = "";
	else
		document.getElementById("AppPoolIdentityType3").style.display = "none";
}
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title"><a href="../list.aspx?Lang=<%=ContentLang%>">服务器列表</a> → <span class="<%=ContentLang%>Font"><%=WebServer[Name]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ServerID"]%>">编辑</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">应用程序池</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Sort" onchange="OnSearch()">
			<option value="1">编号↓</option>
			<option value="2">编号↑</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" onkeydown="if(event.keyCode == 13) OnSearch(1);" />
		<select id="KeywordType">
			<option value="Name">名称</option>
		</select>
		<input type="button" value="搜索" class="Button" onclick="OnSearch(1)" />
		<input type="button" value="全选" class="Button" onclick="SetCheck('Sel',true)" />
		<input type="button" value="反选" class="Button" onclick="ReverseCheck('Sel')" />
		<input type="button" value="删除" class="Button" onclick="Update('Delete')" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th>名称</th>
					<th width="100">封顶</th>
					<th width="120">最大网站数</th>
					<th width="120">CPU监控</th>
					<th width="120">内存监控</th>
					<th width="120">快速失败保护</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="AppPool" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr id="Row<%=InnerID%>">
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ServerID=<%=Request.QueryString["ServerID"]%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
							<td><%=IsClosed%></td>
							<td><%=MaxHostCount%></td>
							<td>
								<%If Convert.ToInt32(CPUResetInterval) != 0%>
									<%=CPULimit%>%，<%=CPUResetInterval%>分钟，
									<%If Convert.ToInt32(CPUAction) == 0%>
										无操作
									<%Else%>
										关闭
									<%EndIf%>
								<%EndIf%>
							</td>
							<td>
								<%If Convert.ToInt32(PeriodicRestartPrivateMemory) != 0%>
									实存：<%=PeriodicRestartPrivateMemory%>
								<%EndIf%>
								<%If Convert.ToInt32(PeriodicRestartMemory) != 0%>
									<%If Convert.ToInt32(PeriodicRestartPrivateMemory) != 0%>
										，
									<%EndIf%>
									虚存：<%=PeriodicRestartMemory%>
								<%EndIf%>
							</td>
							<td>
								<%If Convert.ToBoolean(RapidFailProtection)%>
									失败数：<%=RapidFailProtectionMaxCrashes%>，
									时间段：<%=RapidFailProtectionInterval%>
								<%EndIf%>
							</td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<br />
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">添加应用程序池</li>
		<li class="Right"></li>
	</ul>
	<form method="post" onsubmit="return OnAdd(this)">
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th width="220">名称：</th>
					<td colspan="3"><input type="text" name="Name" maxlength="50" class="Text" /></td>
				</tr>
				<tr>
					<th><input type="checkbox" name="PeriodicRestartTimeEnabled" id="PeriodicRestartTimeEnabled" checked="checked" onclick="ChangeClass(this, this.form.PeriodicRestartTime)" /><label for="PeriodicRestartTimeEnabled">回收工作进程（分钟）：</label></th>
					<td><input type="text" name="PeriodicRestartTime" value="1740" size="10" maxlength="20" class="Text" /></td>
					<th>启用Ping：</th>
					<td>
						<input type="radio" name="PingingEnabled" id="PingingEnabledYes" checked="checked" onclick="PingingEnabled_OnClick()" /><label for="PingingEnabledYes">是</label>
						<input type="radio" name="PingingEnabled" id="PingingEnabledNo" onclick="PingingEnabled_OnClick()" /><label for="PingingEnabledNo">否</label>
					</td>
				</tr>
				<tr>
					<th><input type="checkbox" name="PeriodicRestartRequestsEnabled" id="PeriodicRestartRequestsEnabled" onclick="ChangeClass(this, this.form.PeriodicRestartRequests)" /><label for="PeriodicRestartRequestsEnabled">回收工作进程（请求数目）：</label></th>
					<td><input type="text" name="PeriodicRestartRequests" value="35000" size="10" maxlength="20" disabled="disabled" class="Disabled" /></td>
					<th>每个下列时间Ping工作线程：</th>
					<td><input type="text" name="PingInterval" value="30" size="10" maxlength="20" class="Text" />（秒）</td>
				</tr>
				<tr>
					<th><input type="checkbox" name="PeriodicRestartMemoryEnabled" id="PeriodicRestartMemoryEnabled" onclick="ChangeClass(this, this.form.PeriodicRestartMemory)" /><label for="PeriodicRestartMemoryEnabled">最大虚拟内存：</label></th>
					<td><input type="text" name="PeriodicRestartMemory" value="500" size="10" maxlength="20" disabled="disabled" class="Disabled" />（兆）</td>
					<th>启用快速失败保护：</th>
					<td>
						<input type="radio" name="RapidFailProtection" id="RapidFailProtectionYes" checked="checked" onclick="RapidFailProtection_OnClick()" /><label for="RapidFailProtectionYes">是</label>
						<input type="radio" name="RapidFailProtection" id="RapidFailProtectionNo" onclick="RapidFailProtection_OnClick()" /><label for="RapidFailProtectionNo">否</label>
					</td>
				</tr>
				<tr>
					<th><input type="checkbox" name="PeriodicRestartPrivateMemoryEnabled" id="PeriodicRestartPrivateMemoryEnabled" onclick="ChangeClass(this, this.form.PeriodicRestartPrivateMemory)" /><label for="PeriodicRestartPrivateMemoryEnabled">最大使用的内存：</label></th>
					<td><input type="text" name="PeriodicRestartPrivateMemory" value="192" size="10" maxlength="20" disabled="disabled" class="Disabled" />（兆）</td>
					<th>失败数：</th>
					<td><input type="text" name="RapidFailProtectionMaxCrashes" value="5" size="10" maxlength="20" class="Text" /></td>
				</tr>
				<tr>
					<th><input type="checkbox" name="IdleTimeoutEnabled" id="IdleTimeoutEnabled" checked="checked" onclick="ChangeClass(this, this.form.IdleTimeout)" /><label for="IdleTimeoutEnabled">在空闲此段时间后关闭工作进程：</label></th>
					<td><input type="text" name="IdleTimeout" value="20" size="10" maxlength="20" class="Text" />（分钟）</td>
					<th>时间段：</th>
					<td><input type="text" name="RapidFailProtectionInterval" value="5" size="10" maxlength="20" class="Text" />（分钟）</td>
				</tr>
				<tr>
					<th>核心请求队列限制为：</th>
					<td><input type="text" name="AppPoolQueueLength" value="1000" size="10" maxlength="20" class="Text" />（请求次数）</td>
					<th>启动时间限制：</th>
					<td><input type="text" name="StartupTimeLimit" value="90" size="10" maxlength="20" class="Text" />（秒）</td>
				</tr>
				<tr>
					<th>启用CPU监视：</th>
					<td>
						<input type="radio" name="CPUEnabled" id="CPUEnabledYes" onclick="CPUEnabled_OnClick()" /><label for="CPUEnabledYes">是</label>
						<input type="radio" name="CPUEnabled" id="CPUEnabledNo" checked="checked" onclick="CPUEnabled_OnClick()" /><label for="CPUEnabledNo">否</label>
					</td>
					<th>关闭时间限制：</th>
					<td><input type="text" name="ShutdownTimeLimit" value="90" size="10" maxlength="20" class="Text" />（秒）</td>
				</tr>
				<tr>
					<th>最大CPU使用率：</th>
					<td><input type="text" name="CPULimit" value="100" size="10" maxlength="20" disabled="disabled" class="Disabled" />（百分比）</td>
					<th>应用程序池标识：</th>
					<td>
						<select name="AppPoolIdentityType" onchange="AppPoolIdentityType_OnChange()">
							<option value="0">本地系统</option>
							<option value="1">本地服务</option>
							<option value="2" selected="selected">网络服务</option>
							<option value="3">自定义</option>
						</select>
						<span id="AppPoolIdentityType3" style="display:none">
							<br />
							用户名：<input type="text" name="WAMUserName" maxlength="50" class="Text" /><br />
							密&nbsp;&nbsp;码：<input type="password" name="WAMUserPass" maxlength="50" class="Text" />
						</span>
					</td>
				</tr>
				<tr>
					<th>刷新CPU使用率值：</th>
					<td><input type="text" name="CPUResetInterval" value="5" size="10" maxlength="20" disabled="disabled" class="Disabled" />（分钟）</td>
					<th>最大网站数：</th>
					<td><input type="text" name="MaxHostCount" value="20" size="10" maxlength="20" class="Text" /></td>
				</tr>
				<tr>
					<th>CPU使用率超过最大时执行的操作：</th>
					<td>
						<select name="CPUAction">
							<option value="0">无操作</option>
							<option value="1">关闭</option>
						</select>
					</td>
					<th>封顶：</th>
					<td>
						<input type="radio" name="IsClosed" id="IsClosedYes" /><label for="IsClosedYes">是</label>
						<input type="radio" name="IsClosed" id="IsClosedNo" checked="checked" /><label for="IsClosedNo">否</label>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="4"><input type="submit" id="Submit" class="Button" value="添加" /></td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>

<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>