﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<ilghar:Get ID="WebServer" Object="Server" InnerID="Request.QueryString['ServerID']" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.AppPool.ServerID + "=" + WebServer[Alias.Server.ID]);

	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(Alias.AppPool.Name + " LIKE '%" + keyword + "%'");
	}
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.AppPool.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.AppPool.InnerID + " ASC";
			break;
		default:
			sort = Alias.AppPool.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>名称</th>
			<th width="100">封顶</th>
			<th width="120">最大网站数</th>
			<th width="120">CPU监控</th>
			<th width="120">内存监控</th>
			<th width="120">快速失败保护</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="AppPool" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td><a href="../edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<td><%=IsClosed%></td>
					<td><%=MaxHostCount%></td>
					<td>
						<%If Convert.ToInt32(CPUResetInterval) != 0%>
							<%=CPULimit%>%，<%=CPUResetInterval%>分钟，
							<%If Convert.ToInt32(CPUAction) == 0%>
								无操作
							<%Else%>
								关闭
							<%EndIf%>
						<%EndIf%>
					</td>
					<td>
						<%If Convert.ToInt32(PeriodicRestartPrivateMemory) != 0%>
							实存：<%=PeriodicRestartPrivateMemory%>
						<%EndIf%>
						<%If Convert.ToInt32(PeriodicRestartMemory) != 0%>
							<%If Convert.ToInt32(PeriodicRestartPrivateMemory) != 0%>
								，
							<%EndIf%>
							虚存：<%=PeriodicRestartMemory%>
						<%EndIf%>
					</td>
					<td>
						<%If Convert.ToBoolean(RapidFailProtection)%>
							失败数：<%=RapidFailProtectionMaxCrashes%>，
							时间段：<%=RapidFailProtectionInterval%>
						<%EndIf%>
					</td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
