﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>选择产品</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	condition.Append(Alias.Product.IsDeleted + "=false");
	condition.Append(" AND " + Alias.Product.IsChecked + "=true");
	if (Request.QueryString["Type"] == "Host")
		condition.Append(" AND " + Alias.Product.Kind + "='Host'");
	else if (Request.QueryString["Type"] == "WebSite")
		condition.Append(" AND " + Alias.Product.Kind + "='WebSite'");
	else if (Request.QueryString["Type"] == "Binding" || Request.QueryString["Type"] == "Present")
		condition.Append(" AND " + Alias.Product.Kind + "<>'Set' AND " + Alias.Product.Kind + "<>'AutoSite'");

	#region 性质
	string kind = Request.QueryString["Kind"];
	if (kind != null && kind != "*")
		condition.Append(" AND " + Alias.Product.Kind + "='" + kind + "'");
	#endregion

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
		condition.Append(" AND " + Alias.Product.CategoryID + "=" + Convert.ToInt32(categoryID));
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(" AND " + Alias.Product.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Product.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Product.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Product.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = 1;
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		var list = document.getElementById("List");
		list.innerHTML = HandleFake404(xmlHttp);
	}
	else
	{
		alert("失败！请查看日志！");
	}
}

function BuildHeader()
{
	return BuildAjaxPath(true) + "?Lang=<%=ContentLang%>&Type=<%=Request.QueryString["Type"]%>&Kind=" + document.getElementById("Kind").value + "&Sort=" + document.getElementById("Sort").value + "&Keyword=" + encodeURIComponent(document.getElementById("Keyword").value) + "&KeywordType=" + document.getElementById("KeywordType").value + "&Page=" + _page;
}

function OnSearch()
{
	if (arguments.length > 0)
		_page = arguments[0];
		
	_action = "Search";
	_ajax.Post(BuildHeader(), null, XmlHttpCallBack);
	return false;
}

function OnSelect(control)
{
	<%If Request.QueryString["Type"] == "Product"%>
		if (g_browser == "IE")
			window.dialogArguments.SelectProduct(control);
		else
			window.opener.SelectProduct(control);
		window.close();
	<%Else%>
		if (g_browser == "IE")
			window.dialogArguments.Select<%=Request.QueryString["Type"]%>(control, document.getElementById(control.InnerID).checked);
		else
			window.opener.Select<%=Request.QueryString["Type"]%>(control, document.getElementById(control.InnerID).checked);
	<%EndIf%>
}
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择产品</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Sort" onchange="OnSearch()">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
		</select>
		<select id="Kind" onchange="OnSearch()">
			<option value="*">所有性质</option>
			<option value="AutoSite">智能建站</option>
			<option value="Host">虚拟主机</option>
			<option value="WebSite">网站</option>
			<option value="Set">套餐</option>
			<option value="">其他</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" onkeydown="if(event.keyCode == 13) OnSearch(1);" />
		<select id="KeywordType">
			<option value="Name">产品名称</option>
		</select>
		<input type="button" value="搜索" class="Button" onclick="OnSearch(1)" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr><th colspan="4">结果</th></tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Product" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()">
					<ilghar:Row MaxCol="2">
						<tr>
							<ilghar:Col MaxRecord="1">
								<ilghar:Record>
									<%If Request.QueryString["Type"] == "Product"%>
										<td><a href="javascript:OnSelect({ProductID:'<%=ID%>',ProductNumber:'<%=Number%>',Name:'<%=Name%>',Kind:'<%=Kind%>',UnitID:'<%=UnitID%>',UnitName:'<%=UnitName%>',Price:'<%=Price%>'})" class="<%=ContentLang%>Font"><%=Name%></a></td>
									<%Else%>
										<td><input type="checkbox" id="<%=InnerID%>" onclick="OnSelect({ID:'<%=ID%>',InnerID:'<%=InnerID%>',Name:'<%=Name%>',Amount:1})" /><label for="<%=InnerID%>" class="<%=ContentLang%>Font"><%=Name%></label></td>
									<%EndIf%>
								</ilghar:Record>
							</ilghar:Col>
						</tr>
					</ilghar:Row>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
</body>
</html>