﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 状态
	string status = Request.QueryString["Status"];
	if (!String.IsNullOrEmpty(status))
		condition.Append(and + Alias.Invoice.Status + "=" + status);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Number")
			condition.Append(and + Alias.Invoice.Number + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Member")
			condition.Append(and + Alias.Invoice.Member + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>发票号</th>
			<th>金额</th>
			<th>会员名</th>
			<th>电话</th>
			<th>申请时间</th>
			<th>更新时间</th>
			<th>状态</th>
			<th width="120">操作</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Invoice" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><%=Number%></td>
					<td><%=Amount%></td>
					<td><%=Member%></td>
					<td><%=Phone%></td>
					<td><%=CreateTime%></td>
					<td><%=UpdateTime%></td>
					<td>
						<%If Int32.Equals(Status, 1)%>
							未处理
						<%ElseIf Int32.Equals(Status, 2)%>
							已受理
						<%ElseIf Int32.Equals(Status, 3)%>
							已取消
						<%ElseIf Int32.Equals(Status, 4)%>
							已发送
						<%EndIf%>
					</td>
					<td>
						<%If Int32.Equals(Status, 1)%>
							<input type="button" value="受理" onclick="OnConfirm('<%=InnerID%>')" />
						<%ElseIf Int32.Equals(Status, 2)%>
							<input type="button" value="发送" onclick="OnPost('<%=InnerID%>')" />
							<input type="button" value="取消" onclick="OnCancel('<%=InnerID%>')" />
						<%EndIf%>
						<input type="button" value="删除" onclick="OnDelete('<%=InnerID%>')" />
					</td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
