﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "PositionName")
			condition.Append(and + Alias.Ad.PositionName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "PositionInnerID")
			condition.Append(and + Alias.Ad.PositionInnerID + "=" + keyword);
		else if (Request.QueryString["KeywordType"] == "Creator")
			condition.Append(and + Alias.Ad.Creator + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Title")
			condition.Append(and + Alias.Ad.Title + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>广告位</th>
			<th>广告</th>
			<th>广告主</th>
			<th>开始日期</th>
			<th>结束日期</th>
			<th>金额</th>
			<th>结算</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Ad" Operation="ListCpt" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ilghar:Record>
				<tr>
					<td class="<%=ContentLang%>Font"><a href="../position/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=PositionInnerID%>"><%=PositionName%></a></td>
					<td class="<%=ContentLang%>Font"><a href="../ad/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Title%></a></td>
					<td><%=Creator%></td>
					<td><%=StartTime%></td>
					<td><%=EndTime%></td>
					<td><%=Amount%></td>
					<td><button id="<%=InnerID%>" onclick="OnSettle('<%=InnerID%>')">结算</button></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
