﻿function BuildHeader()
{
	if (_page == "picture_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "person_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "person_select")
		return BuildAjaxPath(true) + "?RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "album_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "album_select")
		return BuildAjaxPath(true) + "?Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
		    $("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "picture_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePicture('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePicture('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdatePicture('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
	if (_page == "person_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
	else if (_page == "album_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Recover')\" >" + _lang_recover + "</button>";
	    }
	}

	$("#ExtraButton").html(buttons);
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx";
	else if (type == "Person")
		path = "../person/select.aspx";
	else if (type == "Album")
		path = "../album/select.aspx";

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' value='" + tag.Name + "' PageGenerate='" + tag.PageGenerate + "' PageTemplate='" + tag.PageTemplate + "'' PageID='" + tag.PageID + "'' PageExtension='" + tag.PageExtension + "' /><label for='" + tag.ID + "'>" + tag.Name + "</label>");
}

function SelectPerson(person, checked)
{
	var persons = $("[name=Person]");
	for (var i = 0; i < persons.length; i++)
	{
		if (persons[i].id == person.ID)
		{
			persons[i].checked = checked;
			return;
		}
	}
	
	var personContainer = $("#PersonDiv");
	var br = "";
	if (persons.length > 0 && persons.length % 5 == 0) br = "<br />";
	personContainer.html(personContainer.html() + br + "<input type='checkbox' checked='checked' name='Person' id='" + person.ID + "' value='" + person.Name + "' PageGenerate='" + person.PageGenerate + "' PageTemplate='" + person.PageTemplate + "'' PageID='" + person.PageID + "'' PageExtension='" + person.PageExtension + "' /><label for='" + person.ID + "'>" + person.Name + "</label>");
}

function SelectAlbum(album, checked)
{
	var albums = $("[name=Album]");
	for (var i = 0; i < albums.length; i++)
	{
		if (albums[i].id == album.ID)
		{
			albums[i].checked = checked;
			return;
		}
	}
	
	var albumContainer = $("#AlbumDiv");
	var br = "";
	if (albums.length > 0 && albums.length % 5 == 0) br = "<br />";
	albumContainer.html(albumContainer.html() + br + "<input type='checkbox' checked='checked' name='Album' id='" + album.ID + "' value='" + album.Name + "' PageGenerate='" + album.PageGenerate + "' PageTemplate='" + album.PageTemplate + "'' PageID='" + album.PageID + "'' PageExtension='" + album.PageExtension + "' /><label for='" + album.ID + "'>" + album.Name + "</label>");
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PreparePerson()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var persons = $("[name=Person]");
	
	if (typeof(_personIndex) != "undefined")
	{
	    _personIndex = 0;
	}
	else
	{
	    _personAddIndex = 0;
	    _personDeleteIndex = 0;
	    _personAddList.length = 0;
	    _personDeleteList.length = 0;
    	    	
	    persons.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _persons.length; j++)
			    {
				    if (this.id == _persons[j] || this.id == _persons[j].ID)
					    break;
			    }
			    if (j >= _persons.length)
				    _personAddList[_personAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _persons.length; j++)
			    {
				    if (this.id == _persons[j] || this.id == _persons[j].ID)
				    {
					    _personDeleteList[_personDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_persons.length = 0;
	persons.each(function()
	{
		if (!this.checked)
		    return false;

		_persons[_persons.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PrepareAlbum()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var albums = $("[name=Album]");
	
	if (typeof(_albumIndex) != "undefined")
	{
	    _albumIndex = 0;
	}
	else
	{
	    _albumAddIndex = 0;
	    _albumDeleteIndex = 0;
	    _albumAddList.length = 0;
	    _albumDeleteList.length = 0;
    	    	
	    albums.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _albums.length; j++)
			    {
				    if (this.id == _albums[j] || this.id == _albums[j].ID)
					    break;
			    }
			    if (j >= _albums.length)
				    _albumAddList[_albumAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _albums.length; j++)
			    {
				    if (this.id == _albums[j] || this.id == _albums[j].ID)
				    {
					    _albumDeleteList[_albumDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_albums.length = 0;
	albums.each(function()
	{
		if (!this.checked)
		    return false;

		_albums[_albums.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 图片管理
function AddPicture()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	var album = PrepareAlbum();
	var person = PreparePerson();

	var category = $("[name=CategoryID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&AlbumNames=" + encodeURIComponent(album.Names);
	data += "&AlbumPageGenerates=" + encodeURIComponent(album.PageGenerates);
	data += "&AlbumPageTemplates=" + encodeURIComponent(album.PageTemplates);
	data += "&AlbumPageIDs=" + encodeURIComponent(album.PageIDs);
	data += "&AlbumPageExtensions=" + encodeURIComponent(album.PageExtensions);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddPicture_GetInnerID();
		}
	});
	
	return false;	
}

function AddPicture_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddPicture_SetPageID();
		}
	});
}

function AddPicture_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddPicture_AddTag();
		}
	});
}

function AddPicture_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddPicture_AddAlbum();
		return;
	}
	
	var data = "PictureID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPicture_AddTag();
		}
	});
}

function AddPicture_AddAlbum()
{
	if (_albumIndex >= _albums.length)
	{
		AddPicture_AddPerson();
		return;
	}
	
	var data = "PictureID=" + _guid;
	data += "&AlbumID=" + _albums[_albumIndex];
	
	_albumIndex++;

    SetStatusMessage(_lang_adding_album);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Album&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPicture_AddAlbum();
		}
	});
}

function AddPicture_AddPerson()
{
	if (_personIndex >= _persons.length)
	{
		Picture_UploadPicture();
		return;
	}
	
	var data = "PictureID=" + _guid;
	data += "&PersonID=" + _persons[_personIndex];
	
	_personIndex++;

    SetStatusMessage(_lang_adding_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPicture_AddPerson();
		}
	});
}

function EditPicture()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	var album = PrepareAlbum();
	var person = PreparePerson();
	
	var category = $("[name=CategoryID] option:selected");

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&AlbumNames=" + encodeURIComponent(album.Names);
	data += "&AlbumPageGenerates=" + encodeURIComponent(album.PageGenerates);
	data += "&AlbumPageTemplates=" + encodeURIComponent(album.PageTemplates);
	data += "&AlbumPageIDs=" + encodeURIComponent(album.PageIDs);
	data += "&AlbumPageExtensions=" + encodeURIComponent(album.PageExtensions);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_DeleteTag();
		}
	});

	return false;
}

function EditPicture_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditPicture_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Tag&Operation=Delete&PictureID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_DeleteTag();
		}
	});
}

function EditPicture_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditPicture_DeleteAlbum();
		return;
	}
	
	var data = "PictureID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_AddTag();
		}
	});
}

function EditPicture_DeleteAlbum()
{
	if (_albumDeleteIndex >= _albumDeleteList.length)
	{
		EditPicture_AddAlbum();
		return;
	}

	SetStatusMessage(_lang_modifying_album);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Album&Operation=Delete&PictureID=" + _guid + "&AlbumID=" + _albumDeleteList[_albumDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_DeleteAlbum();
		}
	});
}

function EditPicture_AddAlbum()
{
	if (_albumAddIndex >= _albumAddList.length)
	{
        EditPicture_DeletePerson();
		return;
	}
	
	var data = "PictureID=" + _guid;
	data += "&PersonID=" + _albumAddList[_albumAddIndex];
	
	_albumAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Album&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_AddAlbum();
		}
	});
}

function EditPicture_DeletePerson()
{
	if (_personDeleteIndex >= _personDeleteList.length)
	{
		EditPicture_AddPerson();
		return;
	}

	SetStatusMessage(_lang_modifying_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Person&Operation=Delete&PictureID=" + _guid + "&PersonID=" + _personDeleteList[_personDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_DeletePerson();
		}
	});
}

function EditPicture_AddPerson()
{
	if (_personAddIndex >= _personAddList.length)
	{
        Picture_UploadPicture();
		return;
	}
	
	var data = "PictureID=" + _guid;
	data += "&PersonID=" + _personAddList[_personAddIndex];
	
	_personAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Picture.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPicture_AddPerson();
		}
	});
}

function Picture_UploadPicture()
{
    if (!_uploadPicture)
    {
        Picture_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Picture&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Picture_UploadThumbnail();
    	}
    });
}

function Picture_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Picture&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdatePicture(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePicture(action, id);}, this);
		else
			UpdatePicture(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Picture&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}
//End : 图片管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 人物管理
function AddPerson()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddPerson_GetInnerID();
		}
	});
	
	return false;	
}

function AddPerson_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddPerson_SetPageID();
		}
	});
}

function AddPerson_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddPerson_AddTag();
		}
	});
}

function AddPerson_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPerson_AddTag();
		}
	});
}

function EditPerson()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	
	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});

	return false;
}

function EditPerson_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditPerson_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person.Tag&Operation=Delete&PersonID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});
}

function EditPerson_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_AddTag();
		}
	});
}

function Person_UploadPicture()
{
    if (!_uploadPicture)
    {
        Person_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Person&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Person_UploadThumbnail();
    	}
    });
}

function Person_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Person&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdatePerson(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePerson(action, id);}, this);
		else
			UpdatePerson(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Person&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}
//End : 人物管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 影集管理
function AddAlbum()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	var person = PreparePerson();

	var category = $("[name=CategoryID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddAlbum_GetInnerID();
		}
	});
	
	return false;	
}

function AddAlbum_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddAlbum_SetPageID();
		}
	});
}

function AddAlbum_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddAlbum_AddTag();
		}
	});
}

function AddAlbum_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddAlbum_AddPerson();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddAlbum_AddTag();
		}
	});
}

function AddAlbum_AddPerson()
{
	if (_personIndex >= _persons.length)
	{
		Album_UploadPicture();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&PersonID=" + _persons[_personIndex];
	
	_personIndex++;

    SetStatusMessage(_lang_adding_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddAlbum_AddPerson();
		}
	});
}

function EditAlbum()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	var person = PreparePerson();
	
	var category = $("[name=CategoryID] option:selected");

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_DeleteTag();
		}
	});

	return false;
}

function EditAlbum_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditAlbum_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album.Tag&Operation=Delete&AlbumID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_DeleteTag();
		}
	});
}

function EditAlbum_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditAlbum_DeletePerson();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_AddTag();
		}
	});
}

function EditAlbum_DeletePerson()
{
	if (_personDeleteIndex >= _personDeleteList.length)
	{
		EditAlbum_AddPerson();
		return;
	}

	SetStatusMessage(_lang_modifying_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album.Person&Operation=Delete&AlbumID=" + _guid + "&PersonID=" + _personDeleteList[_personDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_DeletePerson();
		}
	});
}

function EditAlbum_AddPerson()
{
	if (_personAddIndex >= _personAddList.length)
	{
        Album_UploadPicture();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&PersonID=" + _personAddList[_personAddIndex];
	
	_personAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Album.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_AddPerson();
		}
	});
}

function Album_UploadPicture()
{
    if (!_uploadPicture)
    {
        Album_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Album&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Album_UploadThumbnail();
    	}
    });
}

function Album_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Album&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdateAlbum(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateAlbum(action, id);}, this);
		else
			UpdateAlbum(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Album&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}
//End : 影集管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "picture_add")
	{
	    var form = $("form")[0];
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddPicture);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#AlbumSelect").click(function(){ShowSelectDialog("Album")});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "picture_edit")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
        
        for (var i = 0; i < _albums.length; i++)
        {
	        SelectAlbum(_albums[i], true);
        }
        
        for (var i = 0; i < _persons.length; i++)
        {
	        SelectPerson(_persons[i], true);
        }

		$("form").eq(0).submit(EditPicture);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#AlbumSelect").click(function(){ShowSelectDialog("Album")});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "picture_list")
	{
		MakeButton();
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "person_add")
	{
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddPerson);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "person_edit")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }

		$("form").eq(0).submit(EditPerson);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "person_list")
	{
		MakeButton();
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "person_select")
	{
		$("#List :checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "album_add")
	{
	    var form = $("form")[0];
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddAlbum);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "album_edit")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true)
        }
        
        for (var i = 0; i < _persons.length; i++)
        {
	        SelectPerson(_persons[i], true)
        }

		$("form").eq(0).submit(EditAlbum);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "album_list")
	{
		MakeButton();
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "album_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectAlbum({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectAlbum({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
}
Init(true);